﻿USE sofia;
DROP TABLE IF EXISTS sofia.cakENT_vpl;
CREATE TABLE cakENT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cakENT_vpl WRITE;
INSERT INTO cakENT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ri jun vuj ri nutz'om-e chere', jun vuj ri tz'iban-vi can ri quibi' ri ruxquin-rumama' can ri Jesucristo. Nk'alajin-vi c'a que ja rija' ri ruxquin-rumam can ri rey David, ri xc'uje' pari' ri tinamit Israel ojer can, y ja rija' ri ruxquin-rumam can chuka' ri Abraham. ");
INSERT INTO cakENT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ri Abraham jari' ri rutata' ri Isaac, ri Isaac rutata' ri Jacob, ri Jacob rutata' ri Judá y ch'aka chic ru-hermanos. ");
INSERT INTO cakENT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ja ri Judá y ri Tamar ri rixjayil quite-quitata' ri Fares y ri Zara. Ja ri Fares ri rutata' ri Esrom, y ri Esrom rutata' ri Aram. ");
INSERT INTO cakENT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Y ri Aram ri' rutata' ri Aminadab, ri Aminadab rutata' ri Naasón, y ri Naasón rutata' ri Salomón. ");
INSERT INTO cakENT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Y ri Salomón y ri Rahab ri rixjayil rute-rutata' Booz, ri Booz y ri Rut ri rixjayil rute-rutata' ri Obed, y ri Obed rutata' ri Isaí. ");
INSERT INTO cakENT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Y ri Isaí ri' rutata' ri rey David, y ri rey David rutata' ri Salomón riq'uin ri Betsabé ri rixjayil. Ri rute' ri Salomón, ja ri rixjayil can ri Urías. ");
INSERT INTO cakENT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ja ri Salomón rutata' ri Roboam, ri Roboam rutata' ri Abías, y ri Abías rutata' ri Asa. ");
INSERT INTO cakENT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Y ri Asa ri' rutata' ri Josafat, ri Josafat rutata' ri Joram, y ri Joram rutata' ri Uzías. ");
INSERT INTO cakENT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Y ri Uzías ri' rutata' ri Jotam, ri Jotam rutata' ri Acaz, y ri Acaz rutata' ri Ezequías. ");
INSERT INTO cakENT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Y ri Ezequías ri' rutata' ri Manasés, ri Manasés rutata' ri Amón, y ri Amón rutata' ri Josías. ");
INSERT INTO cakENT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Y ri Josías ri' rutata' ri Jeconías y ch'aka chic ru-hermanos. Y jari' tok ri kavinak israelitas xban cheque coma ri qui-enemigos que xequic'uaj pa ruch'ulef rubini'an Babilonia. ");
INSERT INTO cakENT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Y tok yec'o chic chiri' pa Babilonia, ri Jeconías rutata' ri Salatiel y ri Salatiel rutata' ri Zorobabel. ");
INSERT INTO cakENT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Y ri Zorobabel ri' rutata' ri Abiud, ri Abiud rutata' ri Eliaquim, y ri Eliaquim rutata' ri Azor. ");
INSERT INTO cakENT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Y ri Azor ri' rutata' ri Sadoc, ri Sadoc rutata' ri Aquim, y ri Aquim rutata' ri Eliud. ");
INSERT INTO cakENT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Y ri Eliud ri' rutata' ri Eleazar, ri Eleazar rutata' ri Matán, ri Matán rutata' c'a jun ri rubini'an chuka' Jacob. ");
INSERT INTO cakENT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Y ri Jacob ri' rutata' c'a ri José ri xoc rachijil ri María. Y ri María ri' jari' ri rute' ri Jesús ri Cristo. ");
INSERT INTO cakENT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Catorce c'a familia can xec'uje-pe, ri ntz'ucutüj-pe riq'uin ri Abraham c'a riq'uin ri rey David. Catorce chuka' familia can xec'uje-pe, ri ntz'ucutüj-pe riq'uin ri rey David hasta c'a chupan ri tiempo tok ri kavinak israelitas xebec'uje' pa ruch'ulef Babilonia. Y quiri' c'a chuka' ri familia can xec'uje', ri ntz'ucutüj-pe riq'uin ri tiempo tok ri kavinak israelitas xebec'uje' pa ruch'ulef Babilonia, y hasta xapon riq'uin ri Cristo, catorce c'a familia can chuka'. ");
INSERT INTO cakENT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Y tok xalüx ri Jesucristo quere' c'a ri rubanic: Ri María ja ri rute' ri Jesucristo, jun xtün ri c'utun chic c'a roma ri José. Pero xbanatüj c'a que tok c'a man jani quic'uan ta qui' que xnabex que ri María nye'avüj chic rubanun-pe. Pero ri María quere' xuc'ulachij roma xka-ka c'a ri Lok'olüj Espíritu pari'. ");
INSERT INTO cakENT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ja ri José ri nbe'oc rachijil ri María, jun chojmilüj vinük vi, y man c'a xrajo' tüj xuya' pa q'uixaj ri María chiquivüch ri vinük, romari' xbün que xa chilak'ül nuya' can ri María y man xrajo' tüj xrelesaj rutzijol chiquivüch ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Y jari' c'a ri xunuc-ka rija' pa ránima, que xa chilak'üj nuya' can. Y pa ruvaran c'a rija' tok jun ángel richin ri Ajaf Dios ri xutz'et rija', y ri ángel ri' xbij chin ri': José, rat ri ruxquin-riy can ri rey David, man taxbij-avi' ncac'ule' riq'uin ri María ri ac'utun chic richin ntoc avixjayil, roma ja ri Lok'olüj Espíritu ri xka-ka pari' richin nralaj jun ac'ual. ");
INSERT INTO cakENT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ri ac'ual c'a ri nralaj ri María, vit ala', y Jesús c'a ri rubi' ri naya'. Y quiri' ri rubi' naya', roma rija' nyerucol ri vinük chupan ri quimac. ");
INSERT INTO cakENT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ronojel c'a re' ri rubin chic ri jun achi ri rusamajel ri Dios ri xc'uje' ojer can. Cachi'el c'a ri xuk'alajrisaj ri Ajaf Dios chuvüch ri samajel ri', quiri' vi xbanatüj. Y quere' c'a ri rubin can: ");
INSERT INTO cakENT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Titz'eta' na pe', que nc'uje' c'a jun xtün ri npu'u yabil chirij, stape' (aunque) man c'o tüj pe achi riq'uin. Y nralaj na vi jun ac'ual, vit ala', ri rubini'an Emanuel. Ri bi'aj ri' nbij c'a chi tzij que ri Dios c'o kiq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tok xc'astüj c'a ri José, xbün na vi c'a ri xbix chin roma ri ángel richin ri Ajaf Dios. Rija' xuc'ün na vi ri María richin xoc rixjayil. ");
INSERT INTO cakENT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ri ral c'a ri María man ralc'ual tüj achi, roma ri José man xuyoj tüj ri' riq'uin ri María hasta que xalüx ri ac'ual. Ri ral ri María utz vi ri xuspaj ri Lok'olüj Espíritu. Y tok ri José xuya' rubi' ri ac'ual, Jesús ri rubi' xuya'. ");
INSERT INTO cakENT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ri Jesús xalüx c'a pa tinamit rubini'an Belén, ri tinamit ri c'o pa ruch'ulef Judea. Tok xalüx ri Jesús, ja ri Herodes ri rey, y jari' c'a tok jun ca'i' etamanela' chiquij ri ch'umila', xeka-pe pa Jerusalén. Ri achi'a' etamanela' ri', pan oriente ye petenük-vi, ");
INSERT INTO cakENT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","y xquic'utula' c'a: ¿Ape' c'o-vi ri ac'ual alaxnük, ri qui-rey ri israelitas? Roma roj ja ri cala' pan oriente katz'eton-pe ri ruch'umil, y xojpu'u chin nkaya' ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tok ri rey Herodes rac'axan chic ri xquibij ri achi'a' etamanela', xsatz ruc'u'x. Y quiri' c'a chuka' xquic'ulachij ri vinük ri aj pa tinamit Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Y ri rey Herodes xerumol c'a conojel ri más-nimalüj tak sacerdotes y ri achi'a' etamanela' chiquicojol ri israelitas, c'ateri' c'a xuc'utuj cheque que ape' c'a nalüx-vi ri Cristo. ");
INSERT INTO cakENT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Xepu'u ri más-nimalüj tak sacerdotes y ri achi'a' etamanela' xquibij chin ri rey: Ri Cristo nalüx pa tinamit Belén chere' pa Judea. Roma ri jun cheque ri rusamajela' ri Dios ri xc'uje' ojer can, quere' c'a ri rutz'iban can: ");
INSERT INTO cakENT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Y rat tinamit Belén ri ratc'o pa ruch'ulef Judá, rat man rat co'ol tüj chiquicojol ri nimalüj tak tinamit chiri' pa Judá, roma ja chiri' aviq'uin rat ri npu'u-vi ri jun c'amol-bey, y nyeruyuk'uj-vi c'a ri vinük aj-Israel ri nutinamit, nbij ri Dios, xquibij-apu chin ri rey Herodes. ");
INSERT INTO cakENT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Y c'ateri' ri rey Herodes pan evatül c'a xeroyoj ri achi'a' etamanela' chiquij ch'umila', y xuc'utula' c'a juis cheque jampe' tok xquitz'et ri ruch'umil ri Cristo. ");
INSERT INTO cakENT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Y c'ateri' xerutük-e pa tinamit Belén y xbij-e cheque: Quixbiyin c'a chila' y ticanoj ri ac'ual, y tok ivilon chic can, tiya' rutzijol chuve, richin que yin nquibe chuka' chin ninya' ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Y tok ri achi'a' ye etamanela' chiquij ch'umila' cac'axan chic c'a ri tzij ri xerubij-e ri rey Herodes cheque, xebe. Y ri ch'umil ri quitz'eton-pe rije' c'a ape' quepu'u-vi, pan oriente, ruc'uan c'a e quibey. Y tok xe'apon, ri ch'umil re' xpa'e' pari' ri ape' c'o-vi ri ac'ual. ");
INSERT INTO cakENT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Y ri achi'a' ye etamanela' chiquij ri ch'umila', xnoj-vi ri cánima riq'uin quicot tok xquitz'et chic c'a ri ruch'umil ri Cristo. ");
INSERT INTO cakENT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ja tok ri achi'a' ri' xe'oc-apu pa jay, xquitz'et na vi c'a ri ac'ual y ri María ri rute', y ja c'ateri' xexuque-ka-qui' c'a pan ulef richin xquiya' ruk'ij ri ac'ual. Y chuka' xequijakala' c'a ri quiyacol y xquispala' c'a can, oro, pon y jun jubulüj ak'on rubini'an mirra chin. ");
INSERT INTO cakENT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pero cheque c'a ri achi'a' etamanela' chiquij ri ch'umila', xk'alajrisüs c'a chiquivüch pa cachic', que man chic quetzolij pa quibey richin nyequiya' rutzijol chin ri rey Herodes. Y quiri' vi xquibün ri achi'a' ri', roma xetzolij-e pa quiruch'ulef y jun yan chic c'a quibey xquic'uaj-e. ");
INSERT INTO cakENT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Y ri achi'a' ri etamanela' chiquij ri ch'umila' xetzolij. Y jari' tok jun ángel richin ri Ajaf Dios xuc'ut-ri' chuvüch ri José, pa rachic'. Y ri ángel ri' xbij chin: Cacatüj c'a e. Tac'uaj-e ri ac'ual rachibilan ri rute' y quixanmüj-e chere'. Quixbiyin c'a pan Egipto y quixc'uje' chila', y yin ninya' rutzijol chave tok utz chic nyixtzolij-pe. Roma ri vocomi, ri rey Herodes nberucanoj-pe ri ac'ual richin que nucamsaj, xbij ri ángel chin ri José, pa rachic'. ");
INSERT INTO cakENT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Y ri José jari' tok xc'astüj, xuc'uaj-e ri ac'ual y ri te'ej. Chupan c'a ri ak'a' ri' xquitz'om-e bey richin nyebe c'a pan Egipto. ");
INSERT INTO cakENT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chila' vi c'a pa ruch'ulef Egipto xec'uje-vi y xetzolij pa ruch'ulef Israel hasta c'a jampe' xcom ri rey Herodes. Richin quiri' nbanatüj na vi c'a ri ruk'alajrisan can ri Ajaf Dios chuvüch ri rusamajel ri xc'uje' ojer can. Ri tz'iban c'a can nbij: Pan Egipto c'a c'o-vi ri nuc'ajol tok xinvoyoj, bin can roma ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Y jari' tok ri rey Herodes xunabej que ri achi'a' ye etamanela' chiquij ri ch'umila' xa man xquibün tüj cachi'el ri rubin-e rija' cheque. Y rija' xcatüj juis royoval y xutük quicamsasic conojel ri vit alabo' ri yec'o chiri' pa tinamit Belén y ri yec'o pa tak lugar ri yec'o-pe chunakaj ri tinamit. Roma ri tiempo ri xquibij ri etamanela' chiquij ri ch'umila' pari' tok xquitz'et ri ruch'umil ri ac'ual, romari' rija' xutük quicamsasic ri tak ac'uala' ca'i' qui juna' pa xulan. ");
INSERT INTO cakENT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chere' xbanatüj-vi c'a cachi'el ri tz'iban can roma ri jun rusamajel ri Dios ri xc'uje' ojer can, ri rubini'an Jeremías: ");
INSERT INTO cakENT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Que chiri' pa Ramá xac'axüx c'a ok'ej. C'o-vi bis. C'o c'a jun ri nujik' ok'ej. Ri' ja ri Raquel nyerok'ej ri ral. Man nc'o tüj c'a ri bis chin roma ri ral xecom. Quiri' ri tz'iban can roma ri Jeremías. ");
INSERT INTO cakENT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Y tok camnük chic e ri rey Herodes, c'ateri' c'a tok ri ángel richin ri Ajaf Dios xuc'ut chic ri' chuvüch ri José, pa rachic', chiri' pa ruch'ulef Egipto. ");
INSERT INTO cakENT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Y ri ángel richin ri Ajaf Dios xbij c'a chin: Cacatüj c'a e. Tac'uaj-e ri ac'ual rachibilan ri rute' y quixtzolij c'a pa ruch'ulef Israel. Roma ri xcajo' xquicamsaj ri ac'ual chila', xa ye manak chic. ");
INSERT INTO cakENT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Y ri José xbün-vi c'a ri xbix chin pa rachic' roma ri ángel. Xuc'uaj-e ri ac'ual y ri te'ej. Xetzolij c'a pa ruch'ulef Israel. ");
INSERT INTO cakENT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero rija' roma ri xrac'axaj que ja ri Arquelao ri ruc'ajol can ri rey Herodes, ri nbün mandar pa ruch'ulef Judea, xuxbij-ri' que nyec'uje-ka chiri' pa Judea. Pero xk'alajrisüs c'a chuvüch ri José pa jun rachic' ri c'uluman que nbün, y romari' rija' c'a pa ruch'ulef Galilea xuc'uaj-vi ri ac'ual y ri te'ej. ");
INSERT INTO cakENT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Y xe'apon c'a pa tinamit rubini'an Nazaret y chiri' xec'uje-vi-ka, richin quiri' nbanatüj na vi c'a cachi'el ri tz'iban can coma ri rusamajela' ri Dios ri xec'uje' ojer can. Ri rusamajela' ri Dios quitz'iban can que ri Jesús nc'atzinej que nbix nazareno chin. ");
INSERT INTO cakENT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chupan c'a ri k'ij tok ri Juan Bautista xutz'om ruk'alajrisasic ri rutzij ri Dios chiquivüch ri vinük, chiri' pa tz'iran ruch'ulef ri c'o pa ruch'ulef Judea, ");
INSERT INTO cakENT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","rija' nbij c'a cheque: Titzolij c'a pe ic'u'x riq'uin ri Dios, roma xa nakaj chic c'o-vi-pe ri k'ij richin que nkujoc pa ruk'a' rija', nbij c'a ri Juan cheque ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ja vi c'a ri Juan Bautista ri achique chok bin-vi can pari' rija' roma ri k'alajrisüy rutzij ri Dios ri xc'uje' ojer, ri rubini'an Isaías. Y rija' rutz'iban-vi can y quere' ri nbij: C'o c'a jun achi ri nc'uje' pa tz'iran ruch'ulef, y ja rija' ri ntzijon ri rutzij ri Dios chiquivüch ri vinük ri nye'apon riq'uin. Y nbila' c'a cheque: Tichojmirsala' rubey ri ic'aslen, roma ya ja npu'u ri Ajaf Dios. Quiri' c'a ri tz'iban can. ");
INSERT INTO cakENT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ri rutziek c'a ri Juan Bautista banun riq'uin rusmal camello, y jun tz'un ri ximbül-rupan. Man jabel tüj oc nyetzu'un. Y ri ruvay rija' ja ri sac' y ri cab ri nquiya' ri chico pa tak juyu'. ");
INSERT INTO cakENT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Y ri vinük c'a ri nye'apon-vi riq'uin ri Juan Bautista, ye juis vi ye q'uiy. Yec'o c'a ri aj pa tinamit Jerusalén, ri tinamit c'o chiri' pa ruch'ulef Judea. Y yec'o chuka' ri aj pa ch'aka chic tinamit richin ri Judea. Y chuka' yec'o c'a ri nyepu'u c'a cala' chunakaj ri rakün-ya' rubini'an Jordán. Conojel c'a ri vinük ri' ri nye'apon riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ri vinük ri' nyeban c'a e bautizar roma rija' chiri' pa rakün-ya' Jordán. Nyequik'alajrisaj-vi c'a ri quimac chuvüch ri Juan Bautista. ");
INSERT INTO cakENT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Y tok rija' xutz'et que ye q'uiy c'a cheque ri achi'a' fariseos y ye q'uiy chuka' cheque ri achi'a' saduceos ri nye'apon riq'uin richin que nyerbün-e bautizar, xbij c'a cheque: Rix cachi'el itzel tak cumütz, ri nyixanmüj chuvüch ri castigo, roma nijo' nyixcolotüj chuvüch ri castigo ri nutük-pe ri Dios, ri chikavüch apu. ¿Achique c'a xyo'on rutzijol chive que quere' tibana'? ");
INSERT INTO cakENT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pero rix nc'atzin c'a que nic'ut que ketzij na vi que nitzolij-pe ic'u'x riq'uin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Man tinuc-ka c'a rix que xe roma ri rix ruxquin-rumam can ri Abraham, romari' nyixcolotüj ta, man quiri' tüj. Roma ri Dios nrajo' ta, rija' nyerubün ta ruxquin-rumam can ri Abraham cheque ri abüj ri nye'itz'et chere'. ");
INSERT INTO cakENT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ri castigo ri nuya' ri Dios npu'u yan. Rija' nbün c'a cachi'el nbün jun achi ri c'o chic ri icüj pa ruk'a' richin que nyerukasaj ri che' ri xa man nquiya' tüj utz quivüch. Y ronojel c'a ri che' ri nyerukasaj, nyeruporoj pa k'ak'. ");
INSERT INTO cakENT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yin, ya' c'a ri nincusaj richin nyixinbün bautizar tok nitzolij-pe ic'u'x riq'uin ri Dios. Pero c'o c'a Jun ri npu'u ri chikavüch apu, ri man cachi'el tüj oc yin. Roma yin man c'uluman tüj richin ninvelesaj y ninya' ri ruxajab chirakün, ri Jun ri nim ruk'ij y nim ruchuk'a'. Ri Jun c'a ri npu'u, nyixrubün-vi bautizar riq'uin ri Lok'olüj Espíritu y riq'uin k'ak'. ");
INSERT INTO cakENT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Y cachi'el c'a jun achi tok nujosk'ij ri ru-trigo. Rija' nc'atzin jun che' c'o ca'i' o oxi' rutza'n chin, richin quiri' ntorix pa cakik' ri trigo ri ch'ayon chic. Ri runak' ri trigo nc'uje' can, pero ri rij xa nuc'uaj-e ri cakik'. Y ja ri runak' ri ru-trigo, jari' ri nuyüc, y ri rij nuporoj. Quiri' c'a nbün ri Jun ri npu'u, xbij ri Juan. Ri Jun ri npu'u c'o chic autoridad pa ruk'a', richin nbün juzgar pa quivi' ri vinük ri yec'o chuvüch ri ruch'ulef. Ri vinük c'a ri nyetaken richin, nyeruc'uaj chila' chicaj. Jac'a ri vinük ri man nyetaken tüj richin, nyerutük chupan ri k'ak' ri man jun bey nchup. ");
INSERT INTO cakENT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Y c'ateri' tok ri Jesús xapon riq'uin ri Juan chiri' chuchi' ri rakün-ya' Jordán. Ri Jesús, c'a pa Galilea petenük-vi. Rija' petenük c'a richin que nban-e bautizar roma ri Juan Bautista. ");
INSERT INTO cakENT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jac'a ri Juan man nrajo' tüj nbün bautizar ri Jesús, roma nbij c'a chin: Ja ta yin ri c'uluman que nquiban bautizar avoma rat y mani xa ja rat ri xatka-pe viq'uin yin, richin ncatinbün-e bautizar, xbij ri Juan. ");
INSERT INTO cakENT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero ri Jesús xbij chin ri Juan Bautista: Roj c'uluman c'a que nkabün ronojel ri nbij ri Dios cheke. Romari' ri vocomi nc'atzin c'a que rat nquinabün bautizar yin. C'ateri' tok ri Juan Bautista xbün bautizar ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Y tok ri Jesús banun chic c'a bautizar, xbe'el-pe pa ya'. Y rija' xutz'et c'a que ri caj xjakatüj y xutz'et chuka' que ri Lok'olüj Espíritu richin ri Dios ntajin nka-ka-pe pari' rija' cachi'el jun paloma. Choj vi c'a petenük pari' rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Y c'o c'a jun ch'abül petenük chila' chicaj ri xbij: Jare' ri Nuc'ajol juis ninjo' y nucukuban vánima riq'uin, xbij ri ch'abül ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Y jari' tok ri Jesús xban chin roma ri Lok'olüj Espíritu que xbe pa tz'iran ruch'ulef, richin que ntijox c'a roma ri itzel-vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ri Jesús cuarenta k'ij y cuarenta ak'a' ri man va'inük tüj. Y tok ye c'unük chic ri k'ij ri', c'ateri' xpu'u ruvayjül. ");
INSERT INTO cakENT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Y jari' xjel-apu ri itzel-vinük riq'uin chin nutijoj ri Jesús, y xbij c'a chin: Roma rat nabij que rat Ruc'ajol ri Dios y nnum apan, tabana' c'a cheque ri abüj re' que que'oc vüy. ");
INSERT INTO cakENT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero ri Jesús xbij chin ri itzel-vinük: Tz'iban can chupan ri rutzij ri Dios, que ri achi nril chuka' ruc'aslen riq'uin ri rutzij ri Dios y man xe tüj c'a riq'uin ri vüy. ");
INSERT INTO cakENT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Y jari' tok ri itzel-vinük xuc'uaj c'a ri Jesús pa lok'olüj tinamit Jerusalén, y ja c'a ri más nüj jotol-vi chicaj chin ri racho ri Dios, chiri' xberuya-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","C'ateri' ri itzel-vinük xbij chin ri Jesús: Tatorij-ka-avi' pa xulan, rat ri ncabin que rat Ruc'ajol ri Dios. Roma chupan ri rutzij ri Dios tz'iban can, nbij: Ri Dios nyerutük ri ángeles aviq'uin richin ncatquichajij. Ncatquili'ej pa quik'a', richin quiri' man natopij tüj avakün chuvüch abüj. ");
INSERT INTO cakENT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pero ri Jesús xbij chin ri itzel-vinük: Yin man ninbün tüj ri narayij rat, y nintijoj ta ri Dios. Roma tz'iban chuka' chupan ri rutzij ri Dios que man tikatijoj ri Kajaf Dios, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Y ri itzel-vinük xuc'uaj c'a jun bey chic ri Jesús, y xuc'uaj c'a pari' jun juyu' ri juis nüj jotol chicaj y xuc'ut ronojel tinamit richin ri ruch'ulef chuvüch. Nimak' tak tinamit y juis quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Y c'ateri' ri itzel-vinük xbij c'a chin ri Jesús: Ronojel c'a ri xinc'ut chavüch ntoc avichin, si ncaxuque' chinuvüch y naya' nuk'ij, xbij ri itzel-vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pero ri Jesús jari' tok xbij chin: Cabiyin cala' rat, Satanás. Yin xa man ninbün tüj ri narayij rat. Roma chupan ri rutzij ri Dios ri tz'iban can, nbij: Xaxe c'a ri Kajaf Dios tikaya' ruk'ij, y xaxe rija' chuka' ri tikasamajij, xbij ri Jesús chin. ");
INSERT INTO cakENT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Y jari' tok ri itzel-vinük xuya' can ri Jesús. Y xeka-pe ángeles riq'uin ri Jesús, y xquitz'om rilixic. ");
INSERT INTO cakENT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Y tok ri Jesús xrac'axaj que ri Juan Bautista tz'amos y c'o chic pa cárcel, jari' tok ri Jesús xtzolij chic pa Galilea. ");
INSERT INTO cakENT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ri Jesús xbec'uje' c'a pa tinamit Nazaret, y tok xuya' can ri tinamit ri', xbe c'a richin que nyec'uje' pa jun tinamit rubini'an Capernaum, jun tinamit ri c'o chuchi' ri jun lago rubini'an Galilea. Ri Capernaum ri' c'o chucojol ri culef ri ye quixquin-quimam can ri Zabulón y ri Neftalí. ");
INSERT INTO cakENT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ri Jesús xapon c'a chupan ri jun tinamit ri', richin que nbanatüj ri tz'iban can roma ri rusamajel ri Dios, ri xubini'aj Isaías. Y rija' rutz'iban c'a can: ");
INSERT INTO cakENT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ri vinük ri yec'o pa culef ri ye ruxquin-rumam can ri Zabulón y ri yec'o pa culef ri ye ruxquin-rumam can ri Neftalí, ri chuchi' ri mar, ri c'o-apu lojc'an ruchi' ri rakün-ya' Jordán. Ri Galilea, ri quiyon chic vinük ri man ye israelitas tüj yec'o. ");
INSERT INTO cakENT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ye tinamit c'a pa k'eku'n vi ri quic'aslen, pero xapon c'a ri Nimalüj Sük quiq'uin. Y chuka' ye tinamit c'a pa rumujal ri camic yec'o-vi, pero xapon c'a quiq'uin ri nsakrisan pa quivi'. Quiri' ri tz'iban can. ");
INSERT INTO cakENT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Y tok ri Jesús xapon pa tinamit Capernaum, jari' tok xtz'om rutzijosic ri rutzij ri Dios y nbij c'a cheque ri vinük: Titzolij c'a pe ic'u'x riq'uin ri Dios, roma xa nakaj chic c'o-vi-pe ri k'ij richin que nyixoc pa ruk'a' rija', xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Y jun k'ij ri Jesús tok benük chuchi' ri lago rubini'an Galilea, xerutz'et-apu ye ca'i' achi'a' quichak'-qui'. Ri ca'i' achi'a' ri', ja ri Simón ri Pedro nbix chin chuka' y ri Andrés, y ye tz'amoy cür, romari' tok nquiyala-ka ri quiya'l tz'ambül-cür chupan ri ya'. ");
INSERT INTO cakENT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Y tok ri Jesús xch'o-pe cheque ri tz'amoy tak cür ri', xbij cheque: Rix ca'i' tz'amoy tak cür, quinitzeklebej c'a, y ninc'ut chivüch achique rubanic nye'itz'om vinük richin yinquitzeklebej. ");
INSERT INTO cakENT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ri ca'i' achi'a' ri', jari' xquiya' can ri tz'amoj-cür y xquitzeklebej ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","C'ate ba' quebiyin, tok ri Jesús xerutz'et c'a ye ca'i' chic achi'a' ri quichak'-qui' chuka'. Y ri ca'i' achi'a' ri', ja ri Jacobo y ri Juan ri ye ruc'ajol ri jun achi rubini'an Zebedeo. Rije' ja pa canoa nyesamüj-vi riq'uin ri Zebedeo ri quitata'. Nyequic'ojoj c'a ri quiya'l tz'ambül-cür. Y xpu'u c'a ri Jesús xeroyoj richin nquitzeklebej. ");
INSERT INTO cakENT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Y ri Jacobo y ri Juan, ri ye ca'i' achi'a' ri', jari' xquiya' can ri qui-canoa y ri quitata' y xquitzeklebej ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ri Jesús ronojel tinamit richin ri ruch'ulef Galilea xapon-vi, nyerutijoj c'a ri vinük riq'uin ri rutzij ri Dios pa tak jay ape' nquimol-qui' richin ntzijos ri rutzij ri Dios cheque. Y chuka' ntzijoj ri utzilüj rutzij ri Dios ri nch'o pari' tok ri vinük nye'oc pa ruk'a' ri Dios. Nyeruc'achojrisala' c'a vinük ri jalajoj chi yabil y k'oxon ntoc cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ri rutzijol ri Jesús xapon c'a pa ronojel tinamit richin ri ruch'ulef Siria. Y ri ye yava'i' xec'amür-pe riq'uin ri Jesús. Yava'i' ri man junan tüj ruvüch yabil ntoc cheque. Yec'o xa ja ri k'oxon richin ri ch'acul ri ntoc cheque. Yec'o ri xa itzel tak espíritu ri ye c'unük quiq'uin. Yec'o c'a ri ye nuya' ataque chin y yec'o c'a chuka' ri ye man nyetiquer tüj nyesilon quich'acul. Y conojel c'a ri yava'i' ri' xeruc'achojrisaj-e. ");
INSERT INTO cakENT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Y ri Jesús xtzeklebüs c'a coma juis vinük ri aj chiri' pa tak tinamit richin ri ruch'ulef Galilea, coma chuka' ri nyepu'u pa tak tinamit ri yec'o pa ruch'ulef Decápolis, ri nyepu'u pa tinamit Jerusalén y ri aj pa ch'aka chic tinamit ri chiri' pa ruch'ulef Judea. Y quiri' c'a chuka', xtzekelebüs coma juis vinük ri nyepu'u c'a lojc'an chic ruchi' ri rakün-ya' Jordán. ");
INSERT INTO cakENT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Y tok ri Jesús xerutz'et que ye juis vinük ri quimolon-qui' chiri', rija' xjote-e pari' ri juyu', y xtz'uye-ka. Y c'ateri' xquimol-apu-qui' ri rachibila' riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Y jari' tok ri Jesús xch'o c'a richin nyerutijoj, y xbij c'a: ");
INSERT INTO cakENT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Jabel quiquicot ri meba' cánima chuvüch ri Dios, roma nye'oc-vi pa ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Jabel quiquicot ri ntok' cánima chuvüch ri Dios, roma ri Dios nujül-e ri cok'ej y nbün cheque que nyequicot. ");
INSERT INTO cakENT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Jabel quiquicot ri ch'utinirsaj cánima, roma nye'ichinan c'a chupan ri ruch'ulef richin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Jabel quiquicot ri nnum y nc'at cánima chirij ri chojmilüj rubanic c'aslen riq'uin ri Dios, roma ri Dios nbün c'a cheque que nyetiquer nquibün ri ncajo'. ");
INSERT INTO cakENT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Jabel quiquicot ri c'o joyovanic pa tak cánima, roma rije' njoyovüx chuka' quivüch. ");
INSERT INTO cakENT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Jabel quiquicot ri ch'ajch'oj cánima chuvüch ri Dios, roma rije' nquitz'et ruvüch rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Jabel quiquicot ri c'o cánima ri nkasan ruvi' oyoval, roma rije' nbix cheque que ye ralc'ual ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Jabel quiquicot ri nquic'usaj pokonül pa quik'a' ch'aka chic, roma choj vi ri quic'aslen chuvüch ri Dios. Jabel vi quiquicot, roma rije' yec'o pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Y ri vinük ri nyeyok'otüj, ri man nc'ulix tüj quivüch y ri ntz'uculux tzij chiquij voma yin, jabel c'a chuka' quiquicot. ");
INSERT INTO cakENT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Romari' rix titze'en c'a ivüch y quixquicot c'a juis, roma nim rajil-ruq'uexel ri nic'ul chila' chicaj. Roma ri pokonül ri nic'usaj rix, quiri' c'a chuka' xquic'usaj ri achi'a' ri xek'alajrisan ri xbix cheque roma ri Dios ojer can, achi'a' ri xec'uje-e nabey que chivüch rix. ");
INSERT INTO cakENT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ja rix c'a cachi'el atz'an, y si utz ic'aslen, ja ri ic'aslen rix cachi'el rutzayil ri quic'aslen ri vinük ri yec'o chuvüch ri ruch'ulef. Y si ta ri cachi'el ri rutzayil re' nq'uis ta e, ¿achique ta c'a rubanic richin quiri' ntzolij ta jun bey chic pe ri rutzayil? Cachi'el atz'an ri xq'uis rutzayil, xa man jun chic c'a nc'atzin-vi. Xa ntorix c'a e, richin que nyec'o vinük pari'. Quiri' chuka' si man utz tüj ic'aslen, man utz tüj chic ri rutzayil ri ic'aslen chiquivüch ri vinük. Man jun chic c'a nc'atzin-vi, y ri vinük cachi'el ta nyec'o pan ivi'. ");
INSERT INTO cakENT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Rix rix rusakil c'a ri quic'aslen ri vinük chuvüch ri ruch'ulef y nyixk'alajin jabel, cachi'el nk'alajin-pe jun tinamit pari' jun juyu' banun-vi y man ntiquer tüj richin nrevaj-ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Rix c'a ri nitzij jun k'ak', man jun bey c'a niya' ta oc chuxe' jun cajón, man quiri' tüj. Ri k'ak' richin nsakrisan, nicanoj jun c'ojlibül ri ntz'uyuba-vi, richin quiri' nyerusakrisaj c'a conojel ri yec'o pa jay. ");
INSERT INTO cakENT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Quiri' ta c'a nbün ri ic'aslen chiquivüch ri vinük, jun ta c'a sük. Richin quiri' tok nquitz'et c'a ri utz ri nyixbanun, ri vinük nquiya' c'a ruk'ij ri aj-chicaj Itata'. ");
INSERT INTO cakENT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Man tinuc c'a que yin xinpu'u richin que man jun ruk'ij ninbün chin ri ley richin ri Moisés, y chuka' man tinuc que yin xinpu'u richin quiri' mismo ninbün cheque ri tz'iban can coma ri achi'a' ri xek'alajrisan ri tzij ri xbix cheque roma ri Dios, chupan ri ojer can tiempo. Man roma tüj c'a ri' yin xinpu'u richin que ninbün-vi ri nquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Roma ketzij ninbij chive que ronojel ri tz'iban chupan ri ley, nyebanatüj-vi. Ri ruch'ulef y ri caj xa nyeq'uis. Pero ri ye tz'iban chupan ri ley nyebanatüj-vi, y man jun ri quiri' ta nc'uje' can. ");
INSERT INTO cakENT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Achique na vinük ri man nrajo' tüj nbün ri nbij chupan ri ley, stape' (aunque) ta jun tzij ri cachi'el xa man jun rakalen nk'alajin y quiri' chuka' ri nuchilabej cheque ch'aka chic vinük que tiquibana' ri nbanun c'a quiri', xa man jun c'a oc ruk'ij ri nc'uje' chiquicojol ri yec'o pa ruk'a' ri Dios. Jac'a ri vinük ri nbanun ronojel ri nbij chupan ri ley y quiri' chuka' nuchilabej cheque ri ch'aka chic vinük que tiquibana', rija' nc'uje' c'a ruk'ij chiquicojol ri yec'o pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Rix ri nijo' nyixoc pa ruk'a' ri Dios, nc'atzin que ri ic'aslen más choj chuvüch ri quic'aslen ri achi'a' ri ye etamanela' chin ri ley y chuvüch ri quic'aslen ri achi'a' fariseos. Roma rije' nquinuc que choj ri quic'aslen, pero xa man quiri' tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Y rix jabel ivetaman, roma ivac'axan ri xbix cheque ri kavinak ojer can, que man quecamsan. Y achique na c'a vinük ri ncamsan, aj-mac vi y nc'atzinej que nban juzgar pari'. ");
INSERT INTO cakENT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Jac'a yin ninbij que stape' (aunque) xaxe royoval ri npu'u chin jun vinük, nmacun-vi y tiban juzgar pari'. Chuka' ri nbin chin jun chic vinük: Manak ana'oj. Ri nbin quiri', aj-mac chuka', romari' c'uluman que nuc'u'üx chiquivüch ri achi'a' pa comon nquibün juzgar richin que nban juzgar pari'. Y ja ri nbin nacanic chin jun chic vinük, ri' xa oyoben chic roma ri k'ak'. ");
INSERT INTO cakENT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Romari' si rat ratc'o chic apu riq'uin ri altar richin que naya' jun sipanic chin ri Dios y jari' tok nka-pe chi'ac'u'x que rat c'o jun ri abanun chuvüch jun vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Taya' c'a can ri sipanic chiri' ape' c'o-vi ri altar y jari' cabiyin riq'uin ri jun vinük ri', que'achojmirsaj can ri oyoval ri c'o chi'icojol. Y tok achojmirsan chic can y junan chic ivüch, c'ateri' c'a catzolij y taya' ri sipanic chin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tachojmirsaj c'a avi' chanin riq'uin ri vinük ri ncatuc'uan chuvüch ri juez, utz ri' xa c'ateri' itz'amon-e bey pa juzgado. Roma si xa man quiri' tüj nabün, ri sujunel chavij ncarujüch pa ruk'a' ri juez, y ri juez ri' ncarujüch-e pa ruk'a' ri chajiy ri cárcel, y rija' ncaberutz'apij can pa cárcel. ");
INSERT INTO cakENT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Y ketzij vi ninbij chin ri quiri' nc'ulachin, que man ntel tüj c'a pe chiri' pa cárcel, hasta tok rutojon chic na can ri ruq'uisbül centavo richin ri ruc'as chin ri vinük ri banayun ri kajo'n chin. ");
INSERT INTO cakENT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Rix jabel ivetaman, roma ivac'axan ri tzij bin can ojer. Ri tzij ri' nbij: Jun achi c'ulan, man tucanoj chic jun ixok. Y jun ixok c'ulan, man tucanoj chic jun achi. ");
INSERT INTO cakENT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Jac'a yin ninbij que chuka' ri achi ri nuya' runak' ruvüch chirij jun ixok xaxe riq'uin nurayij ruvüch, ri nbanun quiri', pa ránima xa xmacun yan c'a riq'uin ri jun ixok ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Xa roma c'a ri' si jun runak' avüch nbanun chave que ncamacun, xa man tabün chic quiri'. Tabana' chin cachi'el navelesaj-e y natorij-e ri runak' avüch. Stape' (Aunque) ta ja ri runak' avüch más utz. Roma más utz que xaxe jun cheque ri runak'-avüch ntel-e y mani ja rat ncabe can pa k'ak'. ");
INSERT INTO cakENT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chuka' si xa jun cheque ri ak'a' nbanun chave que ncamacun, xa man ta tabün chic quiri'. Tabana' chin cachi'el nachoy y natorij-e ri ak'a'. Stape' (Aunque) ta ja ri ak'a' ri más utz. Roma más utz que xaxe jun cheque ri ak'a' ntel-e y mani que ja rat ncabe can pa k'ak'. ");
INSERT INTO cakENT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Y chuka' ketaman que ri ojer can xbix: Ri achi ri man nrajo' tüj chic ri rixjayil y nujüch-ri' riq'uin, tubana' ri vuj ri richin jachojri'il y tuya' chin ri ixok. ");
INSERT INTO cakENT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Jac'a yin ninbij chive: Ri achi ri nujüch-ri' riq'uin ri rixjayil y xa man roma tüj que ri ixok xucanoj ta chic jun achi ri achijlonel ri' nbün-vi c'a chin ri rixjayil que nmacun tok nbe chic riq'uin jun achi. Ri achi ri' nmacun-vi, y quiri' chuka' ri jun chic achi ri nuc'uan chin ri ixok, nmacun c'a chuka', roma ri ixok ri' xa c'a c'o-vi ri nabey rachijil. ");
INSERT INTO cakENT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Y chuka' rix xa jabel ivetaman, roma ivac'axan ri xbix cheque ri kavinak ojer can, que man tiquik'üj quitzij. Y quiri' chuka' tok nquibün jurar, man tiquik'üj quitzij. Y tok c'o ri nquisuj chin ri Ajaf que nquibün, tiquibana' c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Jac'a yin ninbij chive: Man jun bey tibün jurar, y chuka' man tibün cachi'el nquibün ri ch'aka vinük, que nquicusaj ri rubi' ri caj tok nquibün jurar. Rix man jun bey tibün quiri', roma ja ri chila' chicaj c'o-vi ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Y man ticusaj ri rubi' ri ruch'ulef, roma ja chiri' nuya-vi ri rakün ri Dios. Ni man chuka' ticusaj ri rubi' ri tinamit Jerusalén, roma ri tinamit re' richin ri Nimalüj Rey. ");
INSERT INTO cakENT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Y chuka' man tibün cachi'el nquibün ri ch'aka vinük tok nquibün jurar, nquibij que titzaq'uix ri quijolon si xa man ketzij tüj ri nquibij. Rix man jun bey tibün quiri', roma man ja tüj rix ri ivajaf ri ic'aslen. Ri Rajaf ri ic'aslen ja ri Dios, y xaxe chuka' rija' ri ntiquer nujül ri ntzu'un ri rusmal tak ivi'. Xaxe rija' ntiquer nbanun xak chin ri sük y ntiquer chuka' nbün sük chin ri xak. ");
INSERT INTO cakENT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Man jun bey c'a tibün jurar. Ronojel ri nibij, choj c'a tibij, si ketzij ri nibij o xa man ketzij tüj. Y si xa nibün jurar, nk'alajin c'a que c'o itzel pan ivánima. ");
INSERT INTO cakENT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Y rix jabel ivetaman, roma ivac'axan ri xbix cheque ri kavinak ojer can, que ri nrelesan jun runak' ruvüch jun vinük, quiri' c'a chuka' tiban chin ri xbanun. Ri nk'ajon-e rey jun vinük, quiri' c'a chuka' tiban chin ri xbanun. ");
INSERT INTO cakENT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Jac'a yin ninbij chive: Man tipaba-ivi' chuvüch ri nbanun itzel chive. Si xa c'o c'a jun ri nyixch'ayon, man c'a tiya' ruq'uexel chin. Utz c'a niya' chic ivi' pa ruk'a' jun bey. ");
INSERT INTO cakENT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Y si c'o c'a jun vinük ri nuc'uaj jun chive rix pa juzgado roma nrajo' nrelesaj jun rutziek, man c'a tupokonaj nuya' can chin. Y pari' ri', tuya' c'a can chuka' ri rutziek ri cachi'el coton. ");
INSERT INTO cakENT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","O si c'o c'a jun chive rix ri nban chin roma jun vinük ri nüj nbe-vi que tuc'uaj jun aka'n c'a pa jun kilómetro, xa riq'uin c'a quicot tuc'uaj ri aka'n ri xuya-e ri jun vinük chirij, y chuka' man tupokonaj nusuj-ri' que nuc'uaj jun kilómetro más richin nuto' riq'uin ri raka'n. ");
INSERT INTO cakENT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Y si c'o c'a jun chive rix c'o nc'utux chin roma jun vinük, tuya' c'a e chin. Y si c'o chuka' nrajo' que nuküj-e, man jun bey c'a tunuc que man nuya' tüj e. ");
INSERT INTO cakENT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Rix jabel ivetaman, roma ivac'axan ri tzij bin ojer. Ri tzij ri' nbij: C'uluman-vi que que'ajo' ri ch'aka. Jac'a ri nye'etzelan avichin, que'avetzelaj. ");
INSERT INTO cakENT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Jac'a yin ninbij chive: Que'ijo' c'a ri nye'etzelan ivichin, tiya' quik'ij riq'uin ri itzij ri nyejo'on que nka-ka ta itzel pan ivi', quixoc utz quiq'uin ri xa man utz tüj quina'oj iviq'uin rix, y tic'utuj ri utzilüj sipanic ri nspaj-pe ri Dios pa quivi' ri nyetzekleben-pe y nyeyok'on ivichin. ");
INSERT INTO cakENT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Richin quiri' nk'alajin-vi que rix rix ralc'ual ri aj-chicaj Itata'. Roma rija' utz vi c'a pa quivi' conojel. Rija' c'a chila' c'a chicaj nbün-pe que c'o ri rusakil ri k'ij pa quivi' ri vinük ye utz y pa quivi' ri vinük ye itzel. Chila' c'a chuka' nbün-pe que c'o job, pa quivi' ri vinük ye choj y ri man ye choj tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Roma si rix xaxe ri vinük ri nyejo'on ivichin ri nye'ijo', ¿c'o rajil-ruq'uexel nic'ul romari'? Roma ri quiri', hasta jun vinük ri itzel ruc'aslen ntiquer nbün, ntiquer nyerujo' xaxe ri nyejo'on richin. ");
INSERT INTO cakENT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Y si xaxe ri i-hermanos ri nibün saludar, ¿achique ta chic c'a ri más utz nyixtajin chubanic? Man jun. Roma hasta ri vinük ri man quetaman tüj ruvüch ri Dios nyetiquer nquibün quiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Rix quixoc c'a tz'aküt riq'uin ri nyixbanun cachi'el ri aj-chicaj Itata'. Rija' tz'akatinük riq'uin ri nbanun. ");
INSERT INTO cakENT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tichajij c'a ivi' jabel, que man tibananej chiquivüch ri vinük que nyixtajin chubanic ri nrajo' ri Dios, roma xa man utz tüj. Roma si xa quiri' nibün, man jun c'a rajil-ruq'uexel nic'ul riq'uin ri aj-chicaj Itata'. ");
INSERT INTO cakENT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tok rix niya' limosna, man c'a tivelesaj rutzijol, cachi'el tok nk'ajan jun trompeta ri nac'axüx coma conojel ri vinük. Man tibün quiri'. Man tibün cachi'el ri nquibün ri vinük ca'i' quipalüj, nquelesaj rutzijol pa tak bey y pa tak jay ape' ntzijos-vi ri rutzij ri Dios, richin que tetamüx que utz ri nyetajin chubanic. Ketzij vi ninbij que ri vinük ri nyebanun quiri', riq'uin ri xquic'ul quik'ij quiq'uin ri vinük, xa xquil yan c'a rajil-ruq'uexel ri nyebanun. ");
INSERT INTO cakENT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Y tok rix niya' limosna, man c'a titzijoj chin jun chic. Man jun c'a nc'atzin-vi que nretamaj ta na jun chic vinük ri nyixtajin chubanic. ");
INSERT INTO cakENT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Richin quiri' ri limosna ri niya', man jun chic c'a vinük tetaman. Pero ri aj-chicaj Itata', rija' retaman. Rija' nutz'et ri man tz'etetül tüj coma ri vinük y nuya' rajil-ruq'uexel chive. Y ri rajil-ruq'uexel ri nuya' chive, nk'alajin c'a chiquivüch ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Rix tok nibün c'a orar, man tibün cachi'el nquibün ri vinük ca'i' quipalüj. Roma ri vinük ri' juis c'a ncajo' que ja ri ape' yec'o vinük, chiri' nquibün-vi orar: Pa tak jay ape' ntzijos-vi rutzij ri Dios, pa tak esquina, xaxe richin quetz'et. Rije' ye pa'ül tok nquibün orar. Y ketzij vi ninbij chive, que ri vinük ri nyebanun quiri', riq'uin ri nquic'ul quik'ij quiq'uin ri vinük, xa xquic'ul yan c'a rajil-ruq'uexel ri nyebanun. ");
INSERT INTO cakENT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Y tok jun c'a chive rix nbün orar, utz toc pa jay y tutz'apij ruchi' ri jay y c'ateri' tich'o c'a riq'uin ri Rutata' ri c'o chila' chicaj. Y stape' (aunque) man nutz'et tüj ri achique chok chin nch'o-vi, retaman que c'o ri nac'axan richin. Y ri nac'axan-pe richin nutz'et-vi c'a ri man tz'etetül tüj coma ri vinük y nuya' rajil-ruq'uexel chin. Y ri rajil-ruq'uexel ri nuya' chin, nk'alajin c'a chiquivüch ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tok rix nibün c'a orar, man tibün cachi'el nquibün ri vinük ri man quetaman tüj ruvüch ri Dios. Roma chiquivüch rije', xaxe roma nyequibün nimak' tak oraciones y juis tzij ri nquicusaj chupan, romari' tok nye'ac'axüx-pe roma ri Dios, quiri' nquinuc rije'. ");
INSERT INTO cakENT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tok rix nibün orar, man tibün cachi'el nquibün ri vinük ri man quetaman tüj ruvüch ri Dios. Roma ri aj-chicaj Itata' retaman chic c'a ri achique nc'atzin chive, tok c'a man jani nic'utuj tüj chin. ");
INSERT INTO cakENT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tok rix nibün orar, tibana' jun oración cachi'el re': Katata' Dios ratc'o chila' chicaj, xtibanatüj ta c'a que conojel ta ri vinük nquiya' ta ruk'ij ri lok'olüj abi'. ");
INSERT INTO cakENT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Y xtika-pe yan ta c'a ri k'ij tok ja rat ri ncatoc ri Jun ri nabün mandar pa kavi'. Y xe ta c'a ri najo' rat que nban chere' chuvüch ri ruch'ulef, xe ta ri' ri nkabün, cachi'el nquibün ri yec'o aviq'uin chila' chicaj. ");
INSERT INTO cakENT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Y taya' c'a chuka' ri kavay ri nc'atzin cheke ronojel k'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Y cachi'el nyekacuy ri vinük ri c'o nquibün cheke, quiri' ta tabana' kiq'uin roj, tacuy ta c'a ronojel ri man utz tüj ri nyekabün chavüch. ");
INSERT INTO cakENT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Y man c'a taya' k'ij que ri itzel nbün ta cheke que nkutzak pa mac. Kojacolo' c'a chuvüch. Quiri' ri nkac'utuj, roma xaxe c'a rat ri ratc'o pa kavi', c'o avuchuk'a', y c'o ak'ij richin jumul. Quiri' vi. ");
INSERT INTO cakENT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Si rix nye'icuy ri vinük ri nquibün itzel na'oj chive, ri aj-chicaj Itata' nyixrucuy c'a chuka' rix. ");
INSERT INTO cakENT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Y si xa man nye'icuy tüj ri vinük ri nquibün itzel chive, ri aj-chicaj Itata' chuka' man nyixrucuy tüj c'a riq'uin ri imac ri nye'ibanala' chuvüch. ");
INSERT INTO cakENT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tok rix man nyixva' tüj roma nibün orar, man tibün cachi'el nquibün ri vinük ri ca'i' quipalüj, roma xa nyebison ri nyetzu'un. Ye k'alüj ri nyetzu'un que tik'alajin chiquivüch ri vinük que man ye va'inük tüj. Y ketzij ninbij chive, que ri nyebanun quiri', riq'uin ri nquic'ul quik'ij quiq'uin ri vinük, xquic'ul yan c'a ri rajil-ruq'uexel. ");
INSERT INTO cakENT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jac'a tok rix man nyixva' tüj roma nibün orar, man tibün que nk'alajin que man ibanun tüj va'in, xa jabel tich'aja' ipalüj, tiya' ba' aceite pan ivi' y jabel tijica' rusmal ivi'. ");
INSERT INTO cakENT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Richin quiri', man tic'ut chiquivüch ri vinük que man ibanun tüj va'in roma nibün orar. Xaxe ta c'a ri aj-chicaj Itata' ri nretaman, y rija' man c'a tz'etetül tüj. Rija' nutz'et c'a ri man tz'etetül tüj coma ri vinük y nuya' rajil-ruq'uexel chive. Ri rajil-ruq'uexel ri nuya' chive, nk'alajin chiquivüch ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mani c'a nimol ibeyomal chuvüch ri ruch'ulef, roma xa yec'o chico ri nyebanun chin que nyechicopir-ka y c'o chuka' ri pus ri nq'uison richin, y roma chuka' xa yec'o elek'oma' ri nye'elek'an y nye'elesan-e. ");
INSERT INTO cakENT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Timolo' ibeyomal ri ape' man jun nchicopirsan richin y man jun chuka' pus ri nq'uison richin. Ri ape' chuka' man jun elek'on ri nelek'an-e y nrelesan-e. Timolo' c'a ibeyomal chila' chicaj. ");
INSERT INTO cakENT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Roma ri ivánima nc'uje' ape' c'o-vi ri ibeyomal, roma jari' ri nitzeklebej-e. ");
INSERT INTO cakENT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ri runak'-avüch nyec'atzin c'a chave, cachi'el nc'atzin jun k'ak' richin sük nbün. Y si ri runak'-avüch ye utz, rat ratc'o pa jun sük. ");
INSERT INTO cakENT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero si ri runak'-avüch man ye utz tüj, rat ratc'o pa jun k'eku'n. Romari' si xa njalatüj ri sük ri ruyo'on ri Dios pan avánima, nk'alajin c'a pe que pa k'eku'n ratc'o-vi. Y ri k'eku'n ri' juis nim vi. ");
INSERT INTO cakENT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Man jun c'a samajel ri yec'o ta ca'i' rajaf y ntiquer ta nsamüj quiq'uin chi ca'i' pa jun bey. Roma si nrajo' jun cheque ri rajaf, nretzelaj chic can ri jun. Y si juis nutakej rutzij ri jun, man ntiquer tüj nbün quiri' riq'uin ri jun chic. Y quiri' c'a, manak modo que c'o ta jun ri benük ránima chirij ri beyomül, y nrajo' ta chuka' nbün ri nrajo' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Y romari' tok yin ninbij chive: Man tichajij pena riq'uin ri achique nc'atzin chive k'ij-k'ij, ri ape' nivil-vi ivay, ni man tinuc ri ape' nic'ün-vi itziek. Roma si ri Dios xuya-pe ic'aslen chuvüch ri ruch'ulef, ¿ninuc rix que rija' man ntiquer tüj chuka' nuya-pe ri ivay richin c'o ic'aslen y ri itziek richin nitz'apij-ivi'? ");
INSERT INTO cakENT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Que'itz'eta' na pe' ri ch'ipa' ri nyebe chicaj, rije' man nyetico'n tüj, y romari' manak cosecha nquelesaj juna-juna', ni manak chuka' quicabal richin nquiyüc ta quijal. Man riq'uin tüj ri' rije' nyeva', roma ja ri aj-chicaj Itata' ri nyo'on quivay. Ya voro c'a rix man ta nuya' ivay ri Dios, tok rix más ivakalen que chiquivüch ri ch'ipa'. Xa roma c'a ri' man más tinuc ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿C'o ta c'a jun chive rix ri ntiquer ta nbanun que nq'uiy chic ba', roma chunuquic ri pena? Man jun. ");
INSERT INTO cakENT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Y achique c'a roma tok nitz'om pena richin nivil itziek? Ri Dios nuya' itziek. Xaxe na pe' que'itz'eta' ri cotz'i'j quibini'an lirio, ri yec'o pa tak k'ayis. Que'itz'eta' tok nyeq'uiy. Rije' man nyesamüj tüj, ni man nyebatz'in tüj, richin quiri' nyequibanala' ta quitziek jabel oc. Man jun bey. ");
INSERT INTO cakENT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Y c'o c'a jun rey richin ri Israel xc'uje' ojer can ri rubini'an Salomón. Rija' ruyon jabel tak tziük ri xerucusaj, pero man jun bey xchajij ta jun rutziek cachi'el ntzu'un jun cotz'i'j. ");
INSERT INTO cakENT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ri Dios nyeruvek jabel ri k'ayis. Roma ri cotz'i'j jari' ri tziük ri nuya' ri Dios cheque ri k'ayis ri yec'o pa k'ayis. Y stape' (aunque) ri k'ayis man katz nyelayuj tüj más, roma jun k'ij jabel quibanun, jun chic k'ij nyechaki'j-ka y c'ateri' nyetorix pa k'ak', man riq'uin tüj ri' ri Dios nyeruvek jabel. ¿Y achique c'a roma rix man iyo'on tüj iv'anima riq'uin ri Dios que nuya' ta itziek? ");
INSERT INTO cakENT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Roma c'a ri' rix man titz'om pena chucanoxic ivay y ri itziek. ");
INSERT INTO cakENT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ri vinük ri nquitz'om pena chucanoxic quivay y ri quitziek, ja ri man quetaman tüj ruvüch ri Dios. Jac'a rix c'o ri Itata' chila' chicaj y retaman chic que jare' ri nc'atzin chive. ");
INSERT INTO cakENT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Romari' ri c'uluman que nibün rix ja ri tiya-ivi' chuxe' rutzij ri Dios y titija' ik'ij que nic'uaj jun chojmilüj c'aslen chuvüch, cachi'el ri nrajo' rija'. Y si nibün quiri', ri Dios nuya' jun ic'aslen jabel y nuya' chuka' ri nc'atzin chive. ");
INSERT INTO cakENT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Rix man nc'atzin tüj que nitz'om pena roma ninuc yan ri achique nuc'ün-pe ri k'ij chuak'. Ri chuak' c'o-vi ri nuc'ün-pe. Pero xaxe c'a ri c'o chivüch ri tinucu', roma ronojel k'ij c'o-vi rupokonül y man tic'ün yan c'a pe ri richin chuak', roma quiri' xa q'uiy c'a ri nimol chivij. ");
INSERT INTO cakENT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Man jun bey tibün que nye'itz'eta' ri vinük xaxe richin que itzel nyixch'o chiquij, richin quiri' man nban tüj quiri' chive rix. ");
INSERT INTO cakENT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Roma si nibün que nye'itz'eta' ri vinük xaxe richin que itzel nyixch'o chiquij, quiri' c'a chuka' ri nban chive rix. Cachi'el vi c'a rubanic ri nibün rix cheque ri vinük, quiri' chuka' nban chive rix. ");
INSERT INTO cakENT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Y rat ¿achique roma tok ja ri vit k'ayis c'o pa runak'-ruvüch ri a-hermano ri natz'et chanin y man nana' tüj ri che' k'atül pa runak'-avüch rat? Ri ejemplo re' nbij c'a que man tikanimirsaj ri rumac jun hermano y nkach'utinirsaj-ka ri nimalüj tak kamac roj. ");
INSERT INTO cakENT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Man tabij c'a chuka' chin ri a-hermano: Taya' k'ij chuve richin ninvelesaj ri vit k'ayis k'atül pa runak'-avüch, y rat xa jun che' ri k'e'el pa runak'-avüch. Ri ejemplo re' nbij c'a que man tabij chin jun a-hermano que man camacun chic, tok rat chuka' xa nabün amac. Man naya' tüj ka pa cuenta ri amac. Xa ca'i' apalüj. Nabey tachojmirsaj-ka ri ac'aslen rat, c'ateri' utz nato' ri a-hermano. ");
INSERT INTO cakENT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ri rutzij ri Dios y ronojel ri juis cakalen, ri cachi'el cakalen ri vekbül-abüj nbix perla cheque, man que'iya' chiquivüch ri vinük ri xa nquibün cachi'el nquibün ri tz'i' y ri ak. Roma ri chico ri', stape' (aunque) juis rakalen ri nuya' jun vinük cheque, rije' xa nquiyak' pan akün y c'o mul nyecatüj chirij ri xyo'on cheque y nquiba' chi eyaj. ");
INSERT INTO cakENT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tic'utuj c'a ri nc'atzin chive y ri Dios nuya-pe chive. Ticanoj y nivil ri nijo'. Tibana' tocar ri ruchi-jay y nyixjakatüj-pe. ");
INSERT INTO cakENT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Roma c'a ri', si riq'uin ronojel ivánima nic'utuj chin ri Dios, rija' nuya-vi-pe chive. Si rix nicanoj, nivil-vi. Y si rix nibün tocar ri ruchi-jay, njakatüj-vi-pe chivüch. ");
INSERT INTO cakENT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Achique ta c'a achi ri ntiquer nuya' jun abüj pa ruk'a' ri ralc'ual, tok ri ac'ual xa jun vüy ri nuc'utuj chin? ");
INSERT INTO cakENT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O ntiquer ta nuya' jun itzel cumütz pa ruk'a', tok ri ac'ual xa jun cür nrajo'? ");
INSERT INTO cakENT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Rix man nyixtiquer tüj nibün quiri' cheque ri ivalc'ual. Man riq'uin ta que rix man ta utz ina'oj, pero man jun bey niya' jun cosa itzel. Rix ja ri utz tak cosas ri niya'. Ya voro comi ri aj-chicaj Itata', que man nuya tüj pe ri nic'utuj chin. Y ronojel ri nuya-pe rija', ye utz vi. ");
INSERT INTO cakENT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Rix ruyon chuka' utz tibana' quiq'uin ri vinük, roma rix man c'a nka' tüj chivüch que ri vinük itzel quina'oj iviq'uin. Quiri' ri tz'iban chupan ri ley ri richin ri Moisés, y quiri' chuka' quibin can ri xek'alajrisan ri rutzij ri Dios ojer can. ");
INSERT INTO cakENT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Chupan c'a ri ruchi-jay juis latz', chiri' c'a quixoc-vi. Roma nk'alajin que nim ruvüch ri ruchi-jay y ri rubey ri itzel c'aslen, ri nc'amon-pe ri camic ri richin chi jumul, y ye juis c'a vinük ri nye'oc chiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero juis latz' ri ruchi-jay y co'ol oc ruvüch ri bey ri nc'amon-pe c'aslen, y man ye q'uiy tüj ri nye'ilon richin. ");
INSERT INTO cakENT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Romari' nc'atzin nichajij-ivi' chiquivüch ri nyebin que nquik'alajrisaj c'a ri bin cheque roma ri Dios y xa man ketzij tüj ri nquibij. Roma tok c'ateri' nye'apon iviq'uin, ri c'aslen ri nquic'ut, juis jabel, cachi'el quibanic ri ovejas, man jun itzel ntz'etetüj chiquij. Jac'a tok nyek'alajin ri itzel ri c'o pa tak cánima, xa cachi'el chic quibanic ri utiva', nyequiq'uis c'a ri achique chok q'uin nye'apon-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nivetamaj-vi quivüch, cachi'el nivetamaj ruvüch achique chi che' ri', xaxe riq'uin nitz'et rubanic ri ruvüch ri nuya-ka. Tok nvachin jun k'ayis ri juis ruq'uixal, ¿nuya' uva o higo? Man jun bey nbün quiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Quiri' c'a chuka' ivetaman que jun utzilüj che' nuya' utzilüj tak ruvüch, jac'a ri man utzilüj che' tüj, ri ruvüch ri nuya-ka xa itzel chuka'. ");
INSERT INTO cakENT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Man jun utzilüj che' nuya' ta itzel tak ruvüch, nixta jun chuka' che' ri man utz tüj, nuya' ta utzilüj tak ruvüch. ");
INSERT INTO cakENT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Y ronojel c'a che' ri man nquiya' tüj utzilüj tak quivüch, nyekasüs y c'ateri' nyetorix pa k'ak'. ");
INSERT INTO cakENT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Roma c'a ri' nivetamaj quivüch ri vinük ri nye'apon iviq'uin, xaxe riq'uin nitz'et ri rubanic ri quic'aslen. ");
INSERT INTO cakENT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ye q'uiy vi c'a vinük ri nyebin ¡Ajaf! ¡Ajaf! chuve yin, pero man conojel tüj cheque rije' ri nye'oc pa ruk'a' ri Dios. Roma ri nye'oc richin ri Dios xaxe c'a ri riq'uin ronojel cánima nquibün ri rurayibül ri Nata' Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Y chupan c'a ri k'ij tok yin ninbün juzgar pa quivi' ri vinük, ye q'uiy c'a ri nyebin chuve: ¡Ajaf! ¡Ajaf! nquibij, roj pan abi' rat xkatzijoj-vi ri rutzij ri Dios, pan abi' rat xekacol q'uiy vinük ri c'o itzel tak espíritu quiq'uin y pan abi' rat chuka' xekabanala' juis q'uiy milagros, nquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jac'a yin, jari' tok ninbij cheque ri nyebin quiri': Yin man jun bey xixintz'et tok xibün quiri'. Man vetaman tüj c'a ivüch. Man c'uluman tüj c'a que nyixc'uje' viq'uin, roma rix xa rix banuy richin ri itzel, ninbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Y achique na c'a vinük ri nac'axan y nbün ri tzij ri c'ateri' ninbij-ka, junan c'a riq'uin ri jun achi listo ri xupaba' jun racho pari' abüj. ");
INSERT INTO cakENT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xka-ka c'a job, xepu'u rakün tak ya' y cakik' chirij ri jun jay ri' y ri jay man xtzak tüj. Roma ri ruxe' ri jun jay ri' pari' ri abüj tiquil-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Y achique na c'a vinük ri nac'axan ri tzij ri quiri' ninbij-ka, y xa man nbün tüj ri ninbij chin, junan c'a riq'uin ri jun achi tonto ri xupaba' jun racho pa sanayi'. ");
INSERT INTO cakENT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xka-ka c'a job, xepu'u rakün tak ya' y cakik' chirij ri jun jay ri'. Y ri jay xtzak y xq'uis c'a chiri'. Quiri' c'a ri tzij ri xerubij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Y tok ri Jesús xtane' chubixic ri tzij ri', ri vinük ri xe'ac'axan richin, xsatz quic'u'x y xe' xquica'yej roma ri tzij ri xcac'axaj. ");
INSERT INTO cakENT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Roma ri rubanic ri rutijonic, jun tijonic richin jun ri c'o ruchuk'a' pa ruk'a' y man cachi'el tüj oc ri quitijonic ri achi'a' ye etamanela' chin ri ley. ");
INSERT INTO cakENT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Y tok ri Jesús kajnük chic c'a pe pari' ri juyu', ri vinük ri ye benük chirij ye juis ye q'uiy. ");
INSERT INTO cakENT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Y c'o c'a jun achi yava' riq'uin ri jun yabil rubini'an lepra, xapon chuvüch ri Jesús, xxuque-ka chuvüch y xbij c'a chin: Ajaf, yin vetaman que ncatiquer nquinac'achojrisaj riq'uin ri nuyabil, pero man vetaman tüj achique nanojij pa nuvi', xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Y ri Jesús jari' xtz'om-apu ri achi yava' riq'uin ri lepra y xbij chin: Ninjo' que ncac'achoj. Tiq'uis c'a e ri yabil re' chavij, xbij chin. Y xe xbij quiri' ri Jesús, ri achi xch'ajch'ojir-e riq'uin ri ruyabil. ");
INSERT INTO cakENT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","C'ateri' ri Jesús xbij chin ri achi ri': Ninchilabej c'a chave que man tatzijoj cheque ri vinük ri xbanatüj aviq'uin, xa choj cabiyin pa racho ri Dios richin que'ac'utu-avi' chuvüch ri sacerdote, y taya' c'a ri chico, ri sipanic ri nbij chupan ri vuj ri rutz'iban can ri Moisés ri nc'atzin que naya' chin ri Dios. Richin quiri' nak'alajrisaj c'a chiquivüch que rat ch'ajch'oj chic, xbij-e chin. ");
INSERT INTO cakENT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Y tok ri Jesús c'o chic c'a pa tinamit Capernaum, c'o c'a jun achi ri xapon riq'uin. Y ri achi ri' jun Capitán y xuc'utuj c'a jun favor chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Quere' c'a ri xbij ri Capitán: Ajaf, ri achi nusamajel, man ntiquer tüj nsilon ruch'acul. Y ri yabil re' rukasan chuvüch ri ruvarabül. Y juis pokonül ri ntajin chuc'usasic. Rija' chila' c'a pa vacho c'o-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Xpu'u ri Jesús xbij chin ri Capitán: Jo' c'a y ninc'achojrisaj ri achi yava', xbij. ");
INSERT INTO cakENT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Y quere' c'a ri tzij ri xbij chic ri Capitán chin ri Jesús: Ajaf, yin xa yin jun achi aj-mac y romari' man c'uluman tüj chave que ncatoc pa vacho. Xaxe c'a tabij que nc'achoj y nc'achoj ri achi nusamajel. ");
INSERT INTO cakENT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yin vetaman-vi que quiri' nbanatüj, roma yin c'o jun ri nbin chuve ri nc'atzinej que ninbün. Y chuka' yec'o achi'a' ye yo'on pa nuk'a'. Tok ninbij c'a chin jun achi ri c'o pa nuk'a' que tibiyin, nbe-vi. Y si ninbij chuka' chin jun chic cheque ri achi'a' ri yec'o pa nuk'a' que tipu'u, npu'u-vi chuka'. Y tok ninbij c'a chin ri nusamajel que tabana' re', nbün-vi chuka', xbij ri Capitán. ");
INSERT INTO cakENT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Y ri Jesús xsatz ruc'u'x tok rac'axan chic c'a ka ri tzij ri' y xbij cheque ri ye tzekleben richin: Ketzij ninbij chive que ri xbin ri tzij re', ruyo'on-vi ránima viq'uin. Y man jun c'a nuvinak israelita ri vilon ri ruyo'on ta ránima viq'uin, cachi'el ri jun achi re'. ");
INSERT INTO cakENT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ninbij-vi c'a chive que juis ye q'uiy vinük ri nyepu'u chila' pan este y chila' chuka' pan oeste, vinük ri quiyo'on c'anima viq'uin. Rije' nyetz'uye' c'a riq'uin ri Abraham, ri Isaac, ri Jacob y ri ch'aka chic ri yec'o-vi chic pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Jac'a ri vinük ri ye richin que nye'oc ta pa ruk'a' ri Dios, xa man chic nye'oc tüj, xa nye'elesüs can y nyetorix chupan ri k'eku'n, roma xa man xquiya' tüj cánima viq'uin yin. Y chiri' npu'u c'a ri ok'ej cheque y nquijach'ach'ela' quey. ");
INSERT INTO cakENT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","C'ateri' c'a ri Jesús xbij-e chin ri Capitán: Catzolij pan avacho. Roma xanimaj que yin nquitiquer nquic'achojrisan, tibanatüj c'a ri arayibül, xbij-e chin. Y ri achi ri rusamajel ri Capitán ri', jari' xc'achoj riq'uin ri ruyabil. ");
INSERT INTO cakENT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Y tok ri Jesús xapon pa racho ri rachibil rubini'an Pedro, xutz'et c'a que ri rujite' ri Pedro cotz'ol pa ch'at y c'o jun nimalüj c'atün chirij. ");
INSERT INTO cakENT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xpu'u rija' xutz'om ruk'a' ri yava' y jari' tok xq'uis-e ri nimalüj c'atün chirij. Ri rujite' ri Pedro xcatüj c'a pe pa ruch'at y xutz'om quilixic ri Jesús y ri ye benük riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tok ncok'a-pe c'a ri k'ij ri', ye q'uiy c'a ri c'o itzel tak espíritu quiq'uin xe'uc'u'üx-apu chuvüch ri Jesús, richin que ri Jesús nyerelesaj ta e ri itzel tak espíritu quiq'uin. Y rija' xbij c'a cheque ri itzel tak espíritu que que'el-e, y xeruc'achojrisaj chuka' e conojel ri ye yava'i'. ");
INSERT INTO cakENT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Richin quiri' nbanatüj c'a ri rubin can ri Isaías, ri jun ri xk'alajrisan ri rutzij ri Dios ojer can. Ri Isaías quere' c'a ri rubin can pari' ri Jesús: Xerelesaj c'a e kayabil konojel, y xuc'uaj c'a ronojel kak'oxomül. Quiri' ri rubin can. ");
INSERT INTO cakENT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Y riq'uin ri Jesús ye juis c'a vinük ri nquimol-apu-qui'. Y tok rija' xerutz'et ri vinük ri', jari' tok xbij cheque ri rachibila' que tiquic'ama' yan c'a pe jun canoa roma nc'atzinej que nyebe lojc'an ruchi-ya'. ");
INSERT INTO cakENT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Y c'o c'a jun achi etamanel chin ri ley ri xapon-apu riq'uin ri Jesús y xbij chin: Rat rat Maestro vi, y yin ninjo' c'a ncatintzeklebej ape' na ri ncatapon-vi, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Xpu'u ri Jesús xbij chin ri etamanel ri': Ri utiva' c'o-vi quijul ape' nyec'uje-vi. Y quiri' chuka' ri ch'ipa', c'o chuka' quisoc. Jac'a yin ri xinalüx chi'icojol, man jun ape' nquinuxlan-vi, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jari' chuka' tok jun chic ri xutzeklebej-e richin ri Jesús, xbij c'a apu chin: Ajaf, yin juis ninjo' que nquibe chavij. Pero taya' c'a k'ij chuve que ninmuk na e ri nata', c'ateri' nquibe chic chavij, xbij c'a rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Xpu'u ri Jesús xbij chin: Rat quinatzeklebej. Xa taya' c'a can que ri camnük nyemuk coma ri ye caminaki' roma ri quimac, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Y ri Jesús xoc c'a e pa jun canoa. Y ri quetzekleben-vi richin xebe chuka' chirij. ");
INSERT INTO cakENT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Y jari' tok juis xberubana-pe ri ya', juis c'a nyesilon. Ri boloj ri nbün ri ya' nquevaj c'a ri canoa tok chiquicojol nc'uje-vi can. Y ri Jesús nvür c'a benük. ");
INSERT INTO cakENT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Y xepu'u ri achibila' xquic'asoj c'a ri Jesús y xquibij chin: ¡Ajaf! ¡Ajaf! Kojato'. Vocomi nkucom, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Xpu'u ri Jesús xbij cheque ri rachibila': Man iyo'on tüj c'a ivánima viq'uin, romari' tok ixbin-ivi', xbij. Y rija' xbecatüj c'a pe y xbij, que tiq'uis-e ri cakik' y titane-ka ri nbolko't ri ya'. Y quiri' xbanatüj. Ri cakik' xq'uis-e, y chuka' ri nbolko't ri ya' xtane-ka. ");
INSERT INTO cakENT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Y ri achibila' xsatz c'a quic'u'x tok xquitz'et ri xbün ri Jesús y nquibila' c'a: ¿Achique c'a chi achi re'? Roma ri cakik' y ri ya' nquitakej chuka' rutzij. ");
INSERT INTO cakENT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Y tok ri Jesús y ri rachibila' yec'o chic c'a lojc'an ruchi-ya', chiri' pa jun lugar rubini'an Gadara, yec'o c'a ca'i' vinük xe'apon riq'uin ri Jesús. Vinük ri xa c'o itzel tak espíritu quiq'uin y ja ri camposanto ri c'o chupan ri lugar ri' ri c'unük cacho. Man jun vinük c'a ri ntiquer ntoc tüj quiq'uin y romari' chuka' man jun chic vinük nbiyin chupan ri bey ri nc'o chiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ri ca'i' achi'a' ri', ri c'o itzel tak espíritu quiq'uin, riq'uin c'a cuchuk'a' xech'o-apu chin ri Jesús, y xquibij: Rat Jesús ri Ruc'ajol ri Dios, ¿achique c'a roma tok nkojanük? ¿Achique c'a roma ja naya' yan pokon chikac'u'x, tok xa man jani napon ruk'ijul? xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Y xa ba' apu cala' chunakaj ri ape' yec'o-vi, juis ye q'uiy ak nyetajin nyeva' chiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Xepu'u ri itzel tak espíritu ri yec'o quiq'uin ri ca'i' achi'a', xquic'utuj favor chin ri Jesús. Y xquibij c'a chin: Si nkojavelesaj-e chere' quiq'uin ri achi'a', taya' c'a k'ij cheke richin nkujoc quiq'uin la ak yec'o chila', xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ri Jesús xbij c'a cheque: Quixbiyin c'a. Y ri itzel tak espíritu jari' xe'el-e y xebe'oc quiq'uin ri ak. Y conojel ri ak ri' xquitz'om anin pa xulan, chuvüch jun juyu' pa'ül-pa'ül, y jic' xebeka' pa ya'. Xecom c'a conojel ri ak ri' chiri' pa ya'. ");
INSERT INTO cakENT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jac'a ri nyeyuk'un quichin ri ak ri', xe c'a xquitz'et can ri xbanatüj, xe'anmüj. Xebe pa tinamit, xbequiyala' can rutzijol achique ri xquic'ulachij ri ak y xbequibij chuka' ri xbanatüj quiq'uin ri ye ca'i' achi'a' ri c'o itzel tak espíritu quiq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Y jari' tok jubama conojel vinük richin ri tinamit xepu'u c'a riq'uin ri Jesús, chutz'etic y chuka' richin xquic'utuj favor chin que tel-e chiri' chupan ri qui-lugar, roma rije' man ncajo' tüj que nc'uje-ka. ");
INSERT INTO cakENT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","C'ateri' ri Jesús y ri quitzekleben-vi richin, xquiya' can ri lugar ri'. Xe'oc-e pa canoa y xebe c'a lojc'an ruchi-ya'. Y chupan ri tinamit ape' tic'uje-vi ri Jesús, chiri' xe'apon-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Y jari' tok c'o jun achi ri man ntiquer tüj nsilon ruch'acul, li'an-e chuvüch-ruvarabül, ri xc'u'üx-apu chuvüch ri Jesús. Y tok ri Jesús xerutz'et que riq'uin ronojel cánima xe'apon apu riq'uin rija', xpu'u rija' xbij chin ri achi ri man ntiquer tüj nsilon ruch'acul: Valc'ual, xbij chin. Tiquicot c'a avánima. Ri amac xecuyutüj. ");
INSERT INTO cakENT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Y jari' tok yec'o cheque ri etamanela' chin ri ley ri yec'o-apu chiri', xquibij-ka pa tak cánima chirij ri Jesús: Itzel achi re'. Nbün que ja rija' ri Dios, roma nbij que nucuy mac. ");
INSERT INTO cakENT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero ri Jesús retaman c'a ri nquinuc pa tak cánima ri etamanela'. Y rija' xbij cheque: ¿Achique c'a roma ja ri itzel ri xinuc chanin? ");
INSERT INTO cakENT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Roma si yin nquitiquer ninbün chin ri jun achi re' ri man ntiquer tüj nsilon ruch'acul, richin nbiyin-e y nbe, ¿nquitiquer ta chuka' ninbij chin que nincuy rumac? ¿Achique nibij rix? ");
INSERT INTO cakENT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Vocomi c'a, richin que rix nivetamaj que yin ri xinalüx chi'icojol c'o nuchuk'a' pa nuk'a' richin nincuy mac, titz'eta' c'a, xbij rija'. Y jari' tok ri Jesús xbij chin ri achi ri man ntiquer tüj nsilon ri ruch'acul: Ninbij c'a chave: Cacatüj, tac'uaj-e la avarabül y cabiyin chi'avacho, xbix chin roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Y jari' tok ri achi ri man ntiquer tüj nsilon ruch'acul xcatüj-e y xbe chiracho. ");
INSERT INTO cakENT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ri vinük c'a ri quimolon-apu-qui' chiiri', tok xquitz'et que ri achi ri man ntiquer tüj nsilon ruch'acul xpa'e-e, xsatz quic'u'x, roma man jun bey c'a quitz'eton que nbanatüj ta quiri'. Y ri vinük ri' xquiya' c'a chuka' ruk'ij ri Dios, ri yo'on-pe ri jun nimalüj ruchuk'a' ri' chiquicojol ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Y tok ri Jesús benük chic c'a, xutz'et jun achi rubini'an Mateo. Ri achi ri' tz'uyul pa jun ch'acüt chiri', nuc'ul can ri alcaval ri nyetoj can. Ri Jesús xbij c'a chin: Quinatzeklebej. Y jari' tok rija' xbecatüj-pe ri ape' tz'uyul-vi y xutzeklebej-e ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Y ja tok rija' tz'uyul chuvüch mesa chiri' pa jay, ye q'uiy c'a cheque ri moloy tak alcaval y ch'aka chic vinük ri aj-maqui' nbix cheque, xetz'uye-apu chuvüch mesa, junan riq'uin ri Jesús y ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Y ri achi'a' fariseos ri xetz'eton ri', xquibij c'a cheque ri rachibila' ri Jesús: ¿Achique roma tok ri Jesús ri I-maestro nva' quiq'uin moloy tak alcaval y quiq'uin ri ch'aka chic ri xa ye aj-maqui? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tok ri Jesús xrac'axaj-pe ri tzij ri nquibij ri achi'a' fariseos, rija' xbij cheque: Jun ak'omanel man ja tüj ri ye utz ri nyerak'omaj. Rija' nyerak'omaj ri c'o quiyabil. ");
INSERT INTO cakENT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yin man xinpu'u tüj chiquicanoxic vinük ri choj quic'aslen. Yin xinpu'u chiquicanoxic ri aj-maqui', ri nc'atzin que ntzolij-pe quic'u'x riq'uin ri Dios. Y rix man choj quiri' tibij-pe ri tzij nabey, xa quixbiyin c'a chutz'etic y chiretamaxic ri achique nic'ulun-vi ri nbij ri Dios: Yin más nka' chinuvüch que ja ta ri joyovanic ri c'o iviq'uin, que chuvüch ri chico ri nye'isuj chuve. ");
INSERT INTO cakENT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Y ja tok ri rachibila' ri Juan Bautista xeka-pe riq'uin ri Jesús, xquibij chin: Roj kacha'on c'a k'ij richin man nkava' tüj, richin quiri' nkabün orar. Y quiri' chuka' nquibün ri cachibila' ri achi'a' fariseos. ¿Y achique c'a roma tok ri avachibila' rat man quiri' tüj nquibün? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Xpu'u ri Jesús xbij cheque: ¿Achique nibij rix? ¿C'uluman comi que riq'uin bis nyec'uje' ri ye oyon pa jun c'ulubic y man nyeva' tüj, tok xa c'a c'o ri ala' c'ulubel quiq'uin? Man c'uluman tüj. Pero napon ri k'ij tok ri ala' re' nrelesüs-e chiquicojol, y jari' tok nquibün que man nyeva' tüj, richin nquibün orar. ");
INSERT INTO cakENT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Y man jun chuka' vinük nbanun que nrelesaj ta jun c'ojobül chin jun tziük c'ac'a', y c'ateri' nucusaj ta richin nc'ojoj jun tziük ri xa ri'j chic. Roma jun c'ojobül c'ac'a' nc'ol-ri' y njec' ri tziük c'ojol, y ri tziük ri' xa más nk'ach'itüj-ka. ");
INSERT INTO cakENT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Y quiri' chuka' man jun nyo'on c'ac'a' vino chupan jun tz'un c'ojlibül ri xa ucusan chic. Roma si quiri' nban, y ri tz'un xa man niyukuk tüj chic, ri tz'un nbojbo' y nq'uis-e ri vino chupan. Y chuka' ri tz'un man jun chic nc'atzin-vi. Pero chupan jun c'ac'a' c'ojlibül, utz niyaque' c'ac'a' vino, roma c'a niyukuk jabel y man nbojbo' tüj. Ri vino niyaque' c'a jabel chupan. Quiri' xbij ri Jesús pari' ri rutijonic. ");
INSERT INTO cakENT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Y tok ri Jesús ntajin c'a chutzijosic ronojel ri', c'o c'a jun achi juis ruk'ij xapon y xbexuque' chuvüch y c'ateri' xbij: Ri numi'al xa c'ate ba' xcom-ka, tabana' favor que'aya' ri ak'a' pari' richin quiri' nc'ase', xbij ri achi. ");
INSERT INTO cakENT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Xpu'u ri Jesús xcatüj c'a e y ye rachibilan ri rachibila' xquitzeklebej-e ri achi. ");
INSERT INTO cakENT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Y c'o c'a jun ixok yava'. Yava' riq'uin ntel ruquiq'uel ya ruc'uan doce juna'. Rija' xjel c'a apu riq'uin ri Jesús pero ja ri chirij, y xberutz'ama' c'a can ba' ri ruchi-rutziek ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Roma ri ixok ri' rubilon c'a pe pa ránima: Xa riq'uin ta ba' nintz'om-e ruchi-rutziek, nquic'achoj, bin pa ránima. ");
INSERT INTO cakENT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pero ri Jesús chanin c'a xuna' y xtzu'un chirij. Y tok rutz'eton chic achique ri xtz'amon ruchi-rutziek, xbij c'a chin ri ixok ri': Numi'al, xac'achoj, roma xaya' avánima viq'uin. Man cabison chic, xbij chin. Y ri ixok ri', jari' xc'achoj riq'uin ri ruyabil. ");
INSERT INTO cakENT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Y tok ri Jesús ntoc c'a apu pa racho ri achi juis ruk'ij, ri Jesús xutz'et que nyech'ujlan y yec'o chic c'a ri nyexuban xul. ");
INSERT INTO cakENT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xpu'u rija' xbij: Quixel-e ba' chere', roma ri vit xtün re' xa man camnük tüj, xa nvür, xbij cheque ri vinük. Pero rije' xa xetze'en chirij ri Jesús, roma quetaman que camnük chic ri vit xtün ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Y ja tok ri vinük ye elenük chic pe chiri', ri Jesús xoc-apu chupan ri jay ape' c'o-vi ri vit xtün camnük chic. Xpu'u rija' xutz'om ruk'a' ri vit xtün, y ri vit xtün xc'astüj-pe. ");
INSERT INTO cakENT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ri xbanatüj c'a chiri', xbe rutzijol pa tak tinamit chupan ri ruch'ulef ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Y tok ri Jesús elenük chic c'a pe chiri', yec'o c'a ca'i' moyi' ri ye tzeketül chirij y riq'uin cuchuk'a' nquibij c'a chin: ¡Tajoyovaj kavüch y kojato' c'a, rat ri ruxquin-rumam can ri rey David! nquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tok ri Jesús xapon pa jay, ri ca'i' moyi' xe'apon c'a chuka' riq'uin. Y ri Jesús xuc'utuj c'a cheque: ¿Ninimaj c'a rix que yin nquitiquer ninbün chive que nyixtzu'un? xbij cheque. Y ri ca'i' moyi' ri' xquibij: Ja', Ajaf Jesús. Nkanimaj, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Xpu'u ri Jesús xutz'om ri runak' tak quivüch ri ye ca'i' y xbij cheque: Roma rix ninimaj que yin nquitiquer nyixinc'achojrisaj, tibanatüj c'a ri irayibül, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Y jari' tok ri runak' tak quivüch rije' xejakatüj. Y xetzu'un c'a. Pero ri Jesús juis xuchilabej-e cheque y xbij: Tivac'axaj c'a e jabel, que ri xbanatüj iviq'uin, man ta nac'axüx coma ri ch'aka chic vinük, xbij-e cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jac'a rije' xa man quiri' tüj xquibün tok ye elenük chic pe chiri' riq'uin ri Jesús. Rije' xa xquitz'om c'a rutzijosic pa ronojel ri ruch'ulef ri', ri xbün ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Y tok xe'el c'a pe ri ye ca'i' achi'a' nyetzu'un chic, jari' tok yec'o xe'oc can riq'uin ri Jesús, quic'uan-apu jun achi ri mem banun pa ruk'a' jun itzel espíritu. ");
INSERT INTO cakENT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Y tok elesan chic c'a ri itzel espíritu riq'uin ri achi, roma ri Jesús, ri achi xch'o chic jun bey. Y ri vinük ri xetz'eton xsatz quic'u'x y xquibij: Man jun bey c'a tz'eton ta que quere' ta banatajnük chere' pa ruch'ulef Israel, nquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Jac'a ri achi'a' fariseos xa nquibij c'a chirij ri Jesús: Ja ri cajaf ri itzel tak espíritu ri nyo'on ruchuk'a' chin, romari' tok ntiquer nyerelesaj itzel tak espíritu, nquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Y ri Jesús ronojel vi c'a nimak' y cocoj tak tinamit napon-vi, y nyerutijoj c'a ri vinük riq'uin ri rutzij ri Dios. Y ja pa tak jay ape' ntzijos-vi ri rutzij ri Dios, chiri' napon-vi richin nyerutijoj. Y chuka' nutzijoj c'a ri utzilüj rutzij ri Dios ri nch'o pari' tok ri vinük nye'oc pa ruk'a' ri Dios. Nyeruc'achojrisaj chuka' yava'i', y nyerucol c'a ri vinük chuvüch ronojel ruvüch k'oxomül. ");
INSERT INTO cakENT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Y tok juis ye q'uiy vinük xerutz'et, xujoyovaj quivüch, roma quiyon yec'o y quitalun-qui', cachi'el nquibün ri ovejas tok xa man jun ri nyuk'un quichin. ");
INSERT INTO cakENT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jari' tok ri Jesús xbij cheque ri rachibila': Ketzij vi que ri samaj richin ntzijos ri rutzij ri Dios, juis nim, jac'a ri samajela' man ye q'uiy tüj. Xa ye ca'i-oxi' oc. ");
INSERT INTO cakENT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Romari' tic'utuj c'a chin ri Rajaf ri samaj, que querutaka-pe más samajela' chiquicojol ri vinük ri nc'atzin richin ncac'axaj ri rutzij. ");
INSERT INTO cakENT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Y ri Jesús xeroyoj c'a ri doce rachibila' y xuya' cuchuk'a' cheque richin que nyetiquer nyequelesaj ri itzel tak espíritus y richin chuka' nyequic'achojrisala' ri vinük chin ri jalajoj quik'oxomül y quiyabil. ");
INSERT INTO cakENT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Y jare' ri quibi' chiquijujunal ri doce achi'a' ri nyetak chubanic ri samaj. Ri nabey bi'aj ja ri richin ri Simón ri nbix chuka' Pedro chin. Ri Andrés. Ri ca'i' re' ye quichak'-qui'. Ri Jacobo y ri Juan ri ye ruc'ajol jun achi rubini'an Zebedeo. ");
INSERT INTO cakENT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ri Felipe, ri Bartolomé, ri Tomás, ri Mateo ri moloy-alcaval, ri Jacobo ruc'ajol jun achi rubini'an Alfeo, ri Lebeo ri nbix chuka' Tadeo chin. ");
INSERT INTO cakENT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ri Simón ri c'o quiq'uin ri achi'a' ri nbix cananista cheque, y ri Judas Iscariote ri xc'ayin richin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Y ja ri doce achi'a' ri' ri xerutük-e ri Jesús. Xerupixabala' c'a e. Xubila' cheque: Nitz'om c'a bey, pero man quixapon quiq'uin ri vinük ri xa man ye israelitas tüj. Chuka' man quixapon pa tak tinamit chiri' pa ruch'ulef Samaria. ");
INSERT INTO cakENT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xa quiq'uin c'a ri kavinak israelitas ri man yec'o tüj apu riq'uin ri Dios quixbiyin-vi. Roma rije' quibanun cachi'el nquibün ri ovejas tok nquisütz can qui'. ");
INSERT INTO cakENT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Y ja tok rix benük chic, titzijoj-vi ri rutzij ri Dios y tibij c'a: Nakaj chic c'o-vi-pe ri k'ij richin que nkujoc pa ruk'a' ri Dios, xbij-e cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Que'ic'achojrisaj c'a yava'i'. Ri c'o c'a ri yabil lepra chiquij, tibana' c'a cheque que nch'ajch'ojin jabel ri quich'acul. Ri ye camnük chic, que'ic'asoj. Que'ivelesaj c'a chuka' ri itzel tak espíritu. Y roma c'a ronojel ri ivuchuk'a' re' xa span chive rix, quiri' c'a chuka' tibana' can rix cheque ri utz. Que'ispala' can. ");
INSERT INTO cakENT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Man timol c'a itumin y nic'uala' pa tak ruximbül-ipan. Man jun c'a ruvüch tumin tic'uaj. Man tic'uaj tumin ri banun riq'uin ri ch'ich' nbix cobre chin, man tic'uaj chuka' ri banun riq'uin sakpük, ni ri riq'uin oro banun-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ri nitz'om-e bey man c'a tic'uaj chinchor (morral). Chuka' man tic'uaj jun chic itziek, xaxe ri icusan. Man tic'uaj jun chic c'ulaj ixajab, ni man tic'uaj chuka' ich'ami'y. Man jun c'a ri tic'uaj. Roma ri samajel achique na lugar napon-vi, c'uluman que nuc'ul ri nc'atzin chin. ");
INSERT INTO cakENT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pero tok nyixapon c'a pa jun nimalüj tinamit o pa jun vit tinamit, nabey tivetamaj achique vinük ri c'uluman que nyixapon pa racho. Y chiri' c'a quixc'uje-vi-ka, y c'a ja tok nyixel na pe chupan ri tinamit ri', utz niya' can ri jay ri ape' xixc'uje-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Y tok c'ateri' c'a nyixoc-apu chupan ri jay ape' nyixbec'uje-vi, tiyala' saludos cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tibij c'a cheque: Ja ta c'a ri uxlanen richin ri Dios tic'uje' iviq'uin. Y si c'uluman-vi que nyixc'uje' chupan ri jay ri', ri ruxlanen ri Dios ri nirayij pa quivi', nka-ka-vi c'a pa quivi'. Xa jac'a si man c'uluman tüj que nyixc'uje-ka chupan ri jay ri', ri ruxlanen ri Dios ri nirayij rix pa quivi' rije', man nka-ka tüj pe pa quivi'. ");
INSERT INTO cakENT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Si man nyixquic'ul tüj c'a jabel, y man ncajo' tüj chuka' ncac'axaj ri rutzij ri Dios ri nitzijoj rix cheque, quixel c'a pe chiri' quiq'uin pa cacho o ja pa quitinamit. Y titotala' can ri pokolaj ri c'o chi ivakün chiquivüch ri vinük, richin tiquinabej que man utz tüj ri xquibün. ");
INSERT INTO cakENT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Roma ninbij-vi c'a chive, que chupan ri k'ij tok nbanatüj ri juicio, ri castigo c'a ri nka-ka pa quivi' ri vinük ri xec'uje' pa tinamit Sodoma y Gomorra man ta xtic'o ruvi', que chuvüch ri nka-ka pa quivi' ri vinük richin ri tinamit ri ape' man nyixc'ulutüj tüj jabel. ");
INSERT INTO cakENT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Vocomi nyixintük c'a e, y rix ivetaman que xa cachi'el tak ovejas ri nyixbeka' chiquicojol ri vinük ye cachi'el utiva'. Pero tibana' c'a que nyixoc cachi'el nbün ri cumütz, roma rija' nuna' tok c'o ri petenük. Tibana' c'a chuka' que nyixoc cachi'el nbün jun paloma, roma rija' man jun itzel c'o ta riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tichajij c'a ivi', richin que man choj niya-ivi' pa quik'a' ri vinük ri nye'etzelan ivichin. Roma rije' nyixquijüch pa quik'a' ri achi'a' pa comon nquibün juzgar, y chuka' ri vinük ri' nquibün c'a chive que nyixch'ay chiri' pa tak jay ape' ntzijos-vi ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chuka' ri vinük nyixquic'uaj c'a chiquivüch gobernadores, chiquivüch reyes y ch'aka chic achi'a' ri c'o autoridad quiq'uin. Y xa voma c'a yin nic'ulachij quiri', pero xa nyixtiquer c'a nquinik'alajrisaj chiquivüch rije' y chiquivüch chuka' ri vinük ri man ye israelitas tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero tok ri vinük nyixquijüch pa quik'a' ri autoridades, man tinuc juis achique ri nibij cheque y achique rubanic tzij nicusaj richin nyixch'o chiquivüch. Roma chupan ri hora ri', ri Dios nuya' c'a pe chive ri c'uluman que nibij. ");
INSERT INTO cakENT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Roma ja ri Lok'olüj Espíritu richin ri Dios ri nbanun chive ri achique chi tzij ri nc'atzinej que nibij. Man ja tüj c'a rix ri nyixch'o, xa ja ri Espíritu richin ri aj-chicaj Itata'. ");
INSERT INTO cakENT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Y nbanatüj c'a, que si yec'o ye ca'i' achi'a' quichak'-qui', jun cheque rije' ncatüj y nujüch ri runimal o ri ruchak' pa camic. Chuka' yec'o-vi tata'aj ri nyecatüj-pe chiquij ri calc'ual. Ri ac'uala' nyecatüj-pe chuka' chiquij ri quite-quitata' y nyequiya' pa camic. ");
INSERT INTO cakENT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Conojel vi c'a nye'etzelan ivichin roma iyo'on ivánima viq'uin. Pero ri nucoch' ronojel hasta pa ruq'uisbül, ncolotüj-vi c'a ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Y tok ri vinük chupan jun tinamit nquitz'om nyixquiya' pa pokonül, utz niya' can y nyixanmüj c'a e chuvüch ronojel re', y nyixbe pa jun chic tinamit. Y ninbij c'a chive que man jani c'a quixapon pa ronojel ri tinamit ri yec'o chere' pan Israel, tok yin ri xinalüx chi'icojol nquipu'u yan. ");
INSERT INTO cakENT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Y rix nic'usaj-vi c'a pokonül pa quik'a' ri nye'etzelan ivichin. Roma ninc'usaj na pokonül yin ri Maestro ivichin, ya voro rix. Man jun c'a que xa ja ri ntijoj-ri' ri más ta nim ruk'ij que chuvüch ri ru-maestro. Chuka' man jun samajel ri más ta ruk'ij que chuvüch ri rajaf ri samaj. ");
INSERT INTO cakENT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jac'a yin ri Tata'aj ri chi'icojol y ja rix ri rix ic'unük valc'ual. Si chuve yin quibin Beelzebú, jun chic rubi' ri itzel-vinük, rix tivoyobej c'a que más itzel ri nyequibij chive. Pero si xa man xtic'o tüj c'a ruvi' ri nquibün chive, y xa cachi'el ri xquibün chuve yin, quiri' nquibün chive rix, c'uluman c'a que nyixquicot rix ri vachibila' y nusamajela'. ");
INSERT INTO cakENT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Pero man c'a tixbij-ivi' chiquivüch ri nyebanun quiri' chive, roma xa nc'atzin que nk'alajrisüs ivoma rix, ri man jun bey tüj k'alajrisan-pe jabel. Nc'atzin c'a que netamatüj ri tz'apül can rij. ");
INSERT INTO cakENT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ronojel c'a ri tzij ri ninbij chive, man tic'uje' can pa k'eku'n, xa tivelesaj c'a pe, richin que rix niya' chuvüch sük. Ri xinbij c'a chive pa tak ixiquin, man tivevaj-ka, xa quixjote' c'a pari' ri ivacho y chiri' tiya-vi rutzijol. ");
INSERT INTO cakENT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Man tixbij c'a ivi' chiquivüch ri xaxe oc ri ich'acul ri nyetiquer nquicamsaj y chin ri ivánima man jun nyetiquer nquibün. Ri c'uluman que nyixbij-ivi' chuvüch, ja ri chuvüch ri jun ri ntiquer nuya' ri ivánima y ri ich'acul chupan ri k'ak' richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Jabel c'a ivetaman que tok nye'ilok' ca'i' tak ch'ipa', xaxe jun centavo cajil. Y man riq'uin tüj ri' que ri ch'ipa' ri' man jun oc ri cajil, man jun c'a ri ntzak ta pan ulef si xa man rurayibül tüj ri aj-chicaj Itata'. ");
INSERT INTO cakENT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ya voro comi rix. Roma rix hasta ri rusmal tak ivi' ajlan ronojel. ");
INSERT INTO cakENT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ri Dios man jun bey nyixrumestaj ta can. Ri Dios juis nyixrujo'. Rix más c'a nyixjo'ox que chiquivüch ri ch'ipa', y romari' man tixbij-ivi'. ");
INSERT INTO cakENT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Y achique na c'a vinük ri nuk'alajrisaj-ri' que vichin yin, yin c'a chuka' nink'alajrisaj que rija' vichin chic yin. Y ri tzij re' chin c'a ri Nata' Dios ninbij-vi, ri c'o chila' chicaj. ");
INSERT INTO cakENT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jac'a ri vinük ri xa man nuk'alajrisaj tüj ri' que vichin yin, yin c'a chuka' man nink'alajrisaj tüj apu rubi' chin ri Nata' Dios ri c'o chila' chicaj, roma man vichin tüj yin ri vinük ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Man tinuc c'a que roma xinpu'u yin chuvüch ri ruch'ulef roma ta ri' c'o ta uxlanen quiq'uin conojel. Man quiri' tüj. Xa voma yin nyejalajo' ri vinük y nquitz'amala-qui'. ");
INSERT INTO cakENT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yin xinpu'u c'a chuvüch ri ruch'ulef richin ntz'ucutüj oyoval chiquicojol ri vinük. Quiri' nbanatüj pa tak jay. Ri ala' ncatüj chirij ri rutata' roma man nka' tüj chuvüch ri nbij. Ri xtün ncatüj c'a chirij ri rute'. Y quiri' chuka' ri ali' ncatüj chirij ri ralite'. ");
INSERT INTO cakENT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ri nye'etzelan c'a richin jun vinük ri nuya' ránima viq'uin yin, xa ja ri ye aj pa racho. ");
INSERT INTO cakENT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ri vinük ri más c'a nyerujo' rute-rutata' y xa man nbün tüj ri ninbij chin, man c'uluman tüj que ntoc vichin yin. Ri te'ej y tata'aj ri más nyequijo' ri calc'ual que chinuvüch yin, man c'uluman tüj que nye'oc vichin yin. ");
INSERT INTO cakENT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jun vinük ri nrajo-vi ntoc vichin yin, nc'atzin que man tupokonaj nuc'usaj pokonül voma yin, cachi'el xa ta benük chuxe' ru-cruz. Jac'a ri vinük ri xa nupokonaj nuc'usaj pokonül voma yin y man nrajo' tüj nquirutzeklebej, man c'uluman tüj que ntoc vichin yin. ");
INSERT INTO cakENT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Roma xa ja ri c'aslen richin ri ruch'ulef ri nrajo' y romari' man nril tüj ruc'aslen richin chi jumul. Jac'a ri vinük ri man nupokonaj tüj ri', stape' (aunque) napon pa camic voma yin, nril-vi ruc'aslen richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ri jun c'a ri nyixruc'ul rix, ja chuka' yin ri nquiruc'ul. Y ri nc'ulun c'a vichin yin, nuc'ul c'a chuka' ri takayon-pe vichin. ");
INSERT INTO cakENT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ri vinük c'a ri nka' chuvüch ri rutzij ri Dios, y romari' nuc'ul ri jun ri ntzijon tzij ri k'alajrisan chin roma ri Dios, ri vinük ri nac'axan ri tzij junan c'a rajil-ruq'uexel nuc'ul riq'uin ri ntzijon ri tzij. Y quiri' chuka' ri vinük ri utz nutz'et jun c'aslen choj y romari' quicot nuc'ul jun vinük ri choj vi ruc'aslen. Ri nc'ulun, junan c'a rajil-ruq'uexel nuc'ul riq'uin ri choj ruc'aslen. ");
INSERT INTO cakENT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Y ri vinük c'a ri nyeka' chuvüch ri cocoj quik'ij, roma ja yin ri yinquitzeklebej, y romari' c'o ri nuya' cheque, ri nbanun c'a quiri' c'o-vi rajil-ruq'uexel ri nuc'ul. Y ketzij c'a ri ninbij chive, que stape' (aunque) xa ba' raxya' ri nuya' cheque, c'o rajil-ruq'uexel nuc'ul romari'. Quiri' c'a ri tzij ri xerubij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Y tok xtzakon c'a chubixic cheque ri doce rachibila' ri achique chi samaj ri nyequibana', ri Jesús man xc'uje' tüj c'a can chiri'. Rija' xbe c'a chuka' ruyon pa ch'aka tinamit ri yec'o chiri' pan Israel, chuc'utic y chutzijosic ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ri samaj c'a ri nbün ri Jesucristo, ri Jun cha'on-pe y takon-pe roma ri Dios, xac'axüx roma ri Juan Bautista tok c'o chiri' pa cárcel, y xpu'u rija' xerutük c'a e ca'i' rachibila' c'a riq'uin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Y rija' xutük c'a e ruc'utuxic chin: ¿Ja rat ri Cristo, ri Jun cha'on-pe y takon-pe roma ri Dios ri oyoben? ¿O nkoyobej chic na jun? Quiri' c'a xbequibij ri ca'i' rachibila' richin ri Juan Bautista. ");
INSERT INTO cakENT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Y ri Jesús xbij c'a cheque ri ca'i' rachibila' ri Juan: Vocomi quixtzolij y titzijoj chin ri xitz'et can y ri xivac'axaj-e chere'. ");
INSERT INTO cakENT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Que'itzijoj chin achique rubanic tok ri moyi' nyetiquer nyetzu'un-e, achique rubanic tok ri vinük ri man ta nyetiquer nyebiyin roma ri ye jetz', nyebiyin-e jabel, y achique rubanic tok ri ye yava'i' riq'uin ri yabil lepra, nyec'achoj. Titzijoj chuka' chin ri achique rubanic tok ri man nye'ac'axan tüj, nyec'achoj, ri caminaki' nyec'astüj, y ri vinük ri meba' cánima chuvüch ri Dios, ninbij ri utzilüj tzij richin colonic cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tibij c'a chuka' chin que jun vinük cachi'el rija', ri ruyo'on ránima viq'uin y man jun bey nquirumalij ta can, jabel ruquicot. Quiri' c'a xbix-e cheque ri ca'i' rachibila' ri Juan Bautista. ");
INSERT INTO cakENT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Y tok ri ye ca'i' rachibila' ri Juan Bautista xebe c'a, ri Jesús xerubila' c'a utzilüj tak tzij pari' ri Juan chiquivüch ri vinük yec'o chiri'. Y quere' c'a ri nbij ri Jesús cheque: ¿Achique ri xbe'itz'eta' rix chiri' chupan ri tz'iran ruch'ulef? ¿Xitz'et rix jun achi chiri', ri cachi'el aj, ri nbe cala' nbe cala' pa ruk'a' ri cakik'? ");
INSERT INTO cakENT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Achique c'a ri xbe'itz'eta' rix chiri'? ¿Xitz'et rix jun achi ri jabel tak tziük ye rucusan? Man quiri' tüj. Ri achi'a' ri ye quicusalon jabel tak tziük quiri', pa tak cacho reyes nyec'uje-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Pero achique c'a ri xbe'itz'eta' rix chiri' pa tz'iran ruch'ulef? ¿Xitz'et jun achi ri nk'alajrisan ri bin chin roma ri Dios? Ja'. Ri achi ri xitz'et chiri' ja vi ri' ri rusamaj. Pero c'o c'a chuka' jun chic samaj ri yo'on pa ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Roma pari' c'a ri Juan nch'o-vi ri Dios chupan ri rutzij ri tz'iban can, tok nbij: Yin nintük c'a jun achi nabey, richin que nuchojmirsaj ri bey richin napon-vi ri Cristo. Quiri' nbij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Y tivac'axaj c'a jabel ri ninbij chive vocomi: Jaru' achi'a' ri ye k'alajrisüy rutzij ri Dios ri ye alaxnük chuvüch ri ruch'ulef, man jun c'a ri más ta ruk'ij que chuvüch ri Juan Bautista. Nim vi c'a ruk'ij rija'. Jac'a ri vocomi, conojel c'a ri nye'oc pa ruk'a' ri Dios, más c'a nimak' quik'ij. Y ri más co'ol cheque rije', más nim que chuvüch ri Juan. ");
INSERT INTO cakENT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Y chupan c'a ri k'ij tok c'a nsamüj na ri Juan Bautista, c'a ri k'ij re', ri vinük juis c'a nquibün que nye'oc pa ruk'a' ri Dios. Nyemajon c'a qui' chirij y más nquibün ri riq'uin c'a ronojel cánima nye'apon. ");
INSERT INTO cakENT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Roma ri achi'a' ri xek'alajrisan ri bin cheque roma ri Dios chupan ri ojer can tiempo, c'o xquibij can pari' tok ri vinük nye'oc pa ruk'a' ri Dios. Y quiri' c'a chuka' ruk'alajrisan can ri ley richin ri Moisés. Pero c'a ja tok c'o ri Juan xebanatüj. ");
INSERT INTO cakENT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Si rix ninimaj o man ninimaj tüj, pero ri ninbij chive yin que tok ri tz'iban can nbij que npu'u ri Elías xa pari' c'a ri Juan nch'o-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Ri c'o ruxiquin, trac'axaj c'a ri xinbij! ");
INSERT INTO cakENT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Achique comi chok q'uin ye junan vi ri vinük richin ri tiempo re'? Ri vinük re' ye junan c'a quiq'uin ri ac'uala' ri nyec'uje' pa tak bey y riq'uin cuchuk'a' ri nyech'o chicachibil qui' tok nye'etz'an. ");
INSERT INTO cakENT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Y ri ac'uala' ri' nquibij c'a: Xojk'ojoman riq'uin xul chivüch y man xixxajo' tüj roma quicot. Xkabixaj bix richin bis chivüch y man xixok' tüj. Quiri' nquibila' ri ac'uala' pa quitz'anil. Y ye quiri' ri vinük richin ri tiempo re', man jun ri nka' chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Roma tok xk'alajin-pe ri Juan Bautista, rija' man nc'ux tüj caxlan-vüy y man nukum tüj chuka' ruya'al-uva. Y ye q'uiy nyebin que rija' c'o itzel espíritu riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Y tok xinka-pe yin, ri xinalüx chi'icojol, ninc'ux caxlan-vüy y nintij chuka' ruya'al-uva. Y ye q'uiy nyebin que xe va'in ninjo', y nquibij chuka' que yin jun k'abarel, que yin cachibil ri moloy tak alcaval y yin cachibil chuka' ri vinük ri ye aj-maqui' nbix cheque. Pero ri etamabül richin ri Dios nk'alajin pa quic'aslen ri vinük ri nyetaken richin, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yec'o c'a tinamit ri xeban-vi juis q'uiy milagros roma ri Jesús. Pero nixta riq'uin ri' ri vinük ri yec'o chupan ri tinamit ri' man xquitzolij tüj pe quic'u'x riq'uin ri Dios. Y romari' ri Jesús q'uiy ri xbij chiquij. ");
INSERT INTO cakENT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Rija' xbij c'a: Juya' c'a quivüch ri yec'o pa tinamit Corazín, y juya' chuka' quivüch ri yec'o pa tinamit Betsaida, roma juis q'uiy milagros xeban chiquivüch y man xquinimaj tüj ri rutzij ri Dios. Roma xa ta ja pa tak tinamit Tiro y Sidón xeban-vi ri milagros re', ri vinük aj chiri' xquitzolij yan ta pe quic'u'x riq'uin ri Dios, y quicusalon ta chic quitziek richin bis, y quiyolon ta chaj chiquij, richin quiri' nk'alajin que nyebison roma juis ri quimac ri ye quibanalun. ");
INSERT INTO cakENT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero tok napon ri k'ij que nbanatüj ri juicio, yin ninbij c'a chive que ja ri yec'o pa tinamit Corazín y ri yec'o pa tinamit Betsaida ri más ru-castigo ri Dios nka-ka pa quivi', que chiquivüch ri aj-Tiro y aj-Sidón. ");
INSERT INTO cakENT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y ri yec'o pa tinamit Capernaum nquinuc que nyebe chila' chicaj riq'uin ri Dios y juis ninimirsüs quik'ij. Pero xa man quiri' tüj. Xa nkasüs quik'ij, roma xa c'a chupan ri lugar ri richin pokonül nyebeka-vi. Roma xa ta ronojel ri milagros ri xban chiquivüch rije' ja ta ri' ri xban chiquivüch ri aj-Sodoma, xquitakej ta y man ta xeq'uis rachibilan ri quitinamit. Xa c'a yec'o ta na ri k'ij re'. ");
INSERT INTO cakENT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero tok napon ri k'ij que nbanatüj ri juicio, yin ninbij c'a chive que ja ri yec'o pa tinamit Capernaum ri más ru-castigo ri Dios nka-ka pa quivi', que chiquivüch ri aj-Sodoma. ");
INSERT INTO cakENT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Y ja tiempo chuka' ri' tok ri Jesús xbij: Matiox ninya' chave Nata' Dios, rat ri Rajaf ri caj y ri ruch'ulef, roma man xak'alajrisaj tüj ri utzilüj atzij chiquivüch ri vinük ri nquina' que juis etamabül c'o quiq'uin. Xa ja chiquivüch ri vinük ri manak más quetaman, xa chiquivüch rije' xak'alajrisaj-vi ri utzilüj atzij re'. ");
INSERT INTO cakENT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Quiri' vi c'a Nata' Dios, roma jari' ri arayibül rat, xbij ri Jesús pa ru-oración. ");
INSERT INTO cakENT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Y c'ateri' rija' xbij c'a: Ri Nata' Dios, ronojel c'a ruyo'on-pe pa nuk'a'. Y man jun chic c'a etamayon chin, yin achique yin, xaxe ri Nata' etamayon. Y man jun chuka' etamayon achique ri' ri Nata', xaxe yin ri Ruc'ajol, y ri vinük achique chok chin que ninjo' nink'alajrisaj-vi yin, nretamaj achique ri' c'a ri Nata'. ");
INSERT INTO cakENT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Quixampe c'a viq'uin chi'ivonojel rix ri juis itijon ik'ij pan iyon y juis ralal ri aka'n kajnük chivij, roma yin ninbün c'a chive que nyixuxlan chin ronojel ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Y ja ri nu-yugo yin tiya-e chirij ivi' rix, roma ja ri vichin yin ri más man c'ayuf tüj ruc'uaxic y man al tüj. Quinitz'eta' yin, nuc'uan jun c'aslen ri nuch'utinirsan-vi'. Y quiri' tibana' rix. Tic'uaj c'a ri nu-yugo yin, richin que ri ivánima nril ta uxlanen, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Y ja tiempo ri' chuka', pa jun k'ij richin uxlanen, ri Jesús y ri rachibila' ye benük c'a pa jun ulef ri ticon ruvüch riq'uin trigo. Y ri rachibila' nquic'ux c'a ri ruvüch ri trigo ri nyequich'upula', roma nnum quipan. ");
INSERT INTO cakENT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Y ri' xtz'etetüj c'a pe coma ri achi'a' fariseos, y xquibij c'a chin ri Jesús: Que'atz'eta' la avachibila' roma man ja tüj nyetajin chubanic. Man c'uluman tüj que nyesamüj chupan jun k'ij richin uxlanen cachi'el ri k'ij vocomi, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero ri Jesús xbij cheque: ¿Man itz'eton tüj c'a rix ri tz'iban can pari' ri xquibün ri David y ri ye rachibil, chupan ri ojer can tiempo, tok juis nnum quipan? ");
INSERT INTO cakENT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ri David xbe c'a chucanoxic vüy chiri' pa racho ri Dios, y ja ri lok'olüj tak caxlan-vüy ri xbejach-pe chin. Rija' y ri ye rachibil xquic'ux c'a ri lok'olüj tak caxlan-vüy ri'. Man nixta riq'uin vi ri', man mac tüj ri xquibün. Y ri' xaxe ri sacerdotes c'o quik'a' chin. ");
INSERT INTO cakENT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yin ninnuc que isiq'uin-vi chuka' ruvüch ri vuj ri' ri c'o chupan ri ley richin ri Moisés. ¿Y achique c'a roma tok ri sacerdotes nyesamüj-vi pa racho ri Dios chupan ri k'ij richin uxlanen y rije' man mac tüj nquibün? ");
INSERT INTO cakENT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ri' roma c'a ri racho ri Dios c'o-vi ruk'ij. Pero ri vocomi, rix nitz'et c'a Jun ri más ruk'ij que chuvüch ri racho ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Y rix man ta xixtiquer xibij que man utz tüj ri nyetajin chubanic ri vachibila', xa ta ivetaman achique ntel-vi chi tzij ri rutzij ri Dios ri nbij: Yin más nka' chinuvüch que ja ta ri joyovanic ri c'o iviq'uin, que chuvüch ri chico ri nye'isuj chuve. Quiri' ri nbij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ja yin ri xinalüx chi'icojol ri Rajaf ri k'ij richin uxlanen, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Y tok ri Jesús y ri rachibila' xetzolij yan c'a pe, rije' xebe pa jay ape' ntzijos-vi ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Y chiri' chiquicojol ri vinük ri quimolon-qui', c'o c'a jun achi chaki'j jun ruk'a'. Xepu'u c'a ri vinük ri' xquic'utuj chin ri Jesús: ¿C'uluman que nc'achojrisüs jun yava' pa jun k'ij richin uxlanen? Quiri' c'a ri xquic'utuj chin roma ncajo' nyecatüj chirij y nquisujuj. ");
INSERT INTO cakENT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Xpu'u c'a ri Jesús xbij cheque: C'o ta jun chive rix achi'a' ri c'o ta jun ru-oveja y ntzak ta pa jun jul chupan jun k'ij richin uxlanen, ¿achique ta nbün riq'uin? ¿Nuya' ta c'a chiri'? Man nbün tüj quiri'. Xa nuc'ün-vi c'a ka richin nrelesaj-pe. ");
INSERT INTO cakENT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ya voro comi, c'a jun achi que man ta ncol, tok xa más c'o-vi ruk'ij que chuvüch jun oveja. Xa roma c'a ri' tok c'uluman-vi que nban ri utz pa jun k'ij richin uxlanen. ");
INSERT INTO cakENT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Y c'ateri' c'a tok ri Jesús xbij chin ri achi ri chaki'j ri ruk'a': Tayuku' la ak'a'. Y ri achi xe xuyuk ri ruk'a', jari' xchojmir y xoc cachi'el ri jun chic ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Y ri achi'a' fariseos xe xquitz'et can ri', xebe y xbequimolo-qui' richin nquinuc achique nquibün, roma ncajo' nquicamsaj ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ri Jesús xel c'a e chiri' tok xretamaj ri nquinuc chirij. Rija' ye juis c'a ri vinük xetzekleben-e richin. Y nyeruc'achojrisala' c'a conojel ri ye yava'i'. ");
INSERT INTO cakENT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pero juis c'a nuchilabej-e cheque conojel rije' que man tiquiya' rutzijol que rija' xeruc'achojrisaj riqúin ri quiyabil. ");
INSERT INTO cakENT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Richin quiri' nbanatüj na c'a ri ruk'alajrisan can ri Dios chuvüch ri rusamajel ri xc'uje' ojer can ri rubini'an Isaías. Ri tz'iban c'a can nbij: ");
INSERT INTO cakENT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jare' c'o ri Nusamajel ri nucha'on. Yin juis ninjo' rija', nquicot-vi vánima riq'uin. Ninya' c'a pe chuka' ri nu-espíritu pari', y rija' nuk'alajrisaj c'a chiquivüch ri man quetaman tüj nuvüch yin, ri achique nc'atzin-vi ri c'aslen choj. ");
INSERT INTO cakENT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Man nbün tüj oyoval, man nuyüc tüj ri rutzij roma royoval, ni man nuya' tüj rutzijol rija' mismo chiquivüch ri vinük pa tak bey. ");
INSERT INTO cakENT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Y stape' (aunque) ri ruc'aslen jun vinük cachi'el ta chic jun aj ri k'och'on-ri', rija' man nbün tüj c'a chin que nik'aj. Chuka' si ri ruc'aslen jun vinük cachi'el ta ruxak jun k'ak' ri nbukun roma nchup yan ka, rija' man nchup tüj. Y chi jumul quiri' nbün-apu, c'a tok napon ri k'ij que rija' nbün que nch'acon ri chojmilüj gobierno. ");
INSERT INTO cakENT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y ri vinük c'a ri man jani quetaman tüj nuvüch, riq'uin c'a rija' ncoyobej-vi ri quicolonic. ");
INSERT INTO cakENT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Y c'o c'a jun moy y mem uc'uan-apu chin ri Jesús, y quiri' ruc'ulachin roma tz'amon c'a roma jun itzel espíritu. Y ri Jesús xrelesaj c'a ri itzel espíritu ri'. Xbün c'a chin que xtzu'un y xch'o. ");
INSERT INTO cakENT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Y romari' tok conojel vinük xe' xquica'yej tok xquitz'et y nquibila' c'a: ¿Man ja tüj re' ri Cristo, ri Jun cha'on-pe y takon-pe roma ri Dios, ri koyoben, ri ruxquin-rumam can ri David? ");
INSERT INTO cakENT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero tok ri achi'a' fariseos xcac'axaj ri nquibij ri vinük pari' ri Jesús, rije' xquibij c'a: Ri Jesús nyerelesaj itzel tak espíritu pero xa pa rubi' ri Beelzebú ri cajaf ri itzel tak espíritu, nquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Y roma ri Jesús retaman c'a ri nquinojila' ri achi'a' fariseos, rija' xbij cheque: Si ri vinük richin jun ruch'ulef man nyenucun tüj y ca'i' quivüch nquibün, npu'u oyoval chiquicojol. Y re' man utz tüj, roma nbün chin ri quiruch'ulef que ntzak. Y quiri' chuka' ronojel tinamit y ronojel jay, si xa nyejalajo' chiquivüch y nyech'aratüj, man nyepa'e' tüj can. ");
INSERT INTO cakENT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Y si ri itzel-vinük nyerelesaj c'a e ri ye rusamajela' vi, ntel c'a chi tzij ri' que ruyon rija' nrokotaj-e-ri'. Xa chirij rija' mismo catajnük-vi. Y si quiri' nbün, ruyon nc'uje' can y chanin ntzak. ");
INSERT INTO cakENT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Rix ninuc-vi c'a chuvij yin que pa rubi' ri Beelzebú, ri jun chic rubi' ri itzel-vinük, nyenvelesaj ri itzel tak espíritu, pero rix ¿achique c'a ninuc pa quivi' ri nyetzekleben ivichin? ¿Achique chok chin yo'on cuchuk'a' cheque rije' richin nyetiquer nyequelesaj itzel tak espíritu chuka'? Ja vi c'a ri nyetzekleben ivichin ri nyek'alajrisan que xa man utz tüj ri nibij rix. ");
INSERT INTO cakENT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yin nquitiquer c'a nyenvelesaj itzel tak espíritu roma ja ri ru-espíritu ri Dios ri c'o viq'uin. Xa xka-pe yan c'a ri k'ij que conojel c'uluman que nquitakej rutzij ri Dios y nyec'uje' pa ruk'a' rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Y ri nrajo' c'a nelek'-e pa racho ri itzel-vinük ri juis ruchuk'a', ri nabey nc'atzinej que nbün riq'uin rija', ja ri tuxima' y c'ateri' c'a tucanoj-e ronojel ri nrajo' nyeruc'uaj. Y jari' ninbün yin, riq'uin nyenvelesaj-e ri itzel tak espíritus ri yec'o quiq'uin ye ch'aka vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jun c'a ri man viq'uin tüj yin nsamüj-vi, xa chuvij c'a yin nsamüj-vi. Y achique ri man nto'on tüj vichin, xa jari' ri niyojon ronojel ri nyenbün yin. ");
INSERT INTO cakENT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Y roma ri xbitüj, yin ninbij c'a chive: Ri mac y ri itzel tak tzij ri nyequibila' ri vinük, richin nquiyok'bej rubi' ri Dios, c'a nyecuyutüj-vi. Jac'a ri tzij yok'onic richin ri Lok'olüj Espíritu, man ncuyutüj tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Y achique na c'a vinük ri nbin tzij chuvij yin ri xinalüx chi'icojol, c'a ncuyutüj na rumac. Jac'a ri nbin tzij chirij ri Lok'olüj Espíritu, man ncuyutüj tüj rumac ri vocomi, ni ri chikavüch apu. ");
INSERT INTO cakENT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Roma xaxe na pe' jun che', nyetamüx ruvüch si utz o man utz tüj, xaxe riq'uin ntz'et ri ruvüch ri nuya'. Man tibij que jun che' xa man utz tüj, tok ri ruvüch ri nyeruya' ye utz vi. Chuka' man tibij que jun che' utz, tok ri ruvüch ri nyeruya' xa man ye utz tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Roma c'a ri' rix ri rix cachi'el itzel tak cumütz, ¿nyixtiquer c'a nibij ri utz, tok xa ja ri itzel c'o iviq'uin? Roma jun vinük ja ri c'o pa ránima ri nbij. ");
INSERT INTO cakENT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jun utzilüj vinük chucojol c'a ri utzilüj beyomül c'o pa ránima nyerelesaj-pe ri nyerubij. Jac'a ri vinük ri man utz tüj, chucojol c'a ri itzel beyomül c'o pa ránima nyerelesaj-pe ri nyerubij. ");
INSERT INTO cakENT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Y yin ninbij c'a chive que chupan ri k'ij tok nbanatüj ri juicio, ri vinük ri xebin tzij ri xa man jun xec'atzin-vi, nban juzgar pa quivi', roma ronojel ri tzij ri xequibila'. ");
INSERT INTO cakENT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ri utz tak tzij ri nibij rix, nuc'ut c'a que man jun imac nk'alajin chuvüch ri Dios. Jac'a ri itzel tak tzij ri nibij, nuc'ut c'a que nka-ka ru-castigo ri Dios pan ivi'. ");
INSERT INTO cakENT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Y yec'o c'a cheque ri etamanela' chin ri ley y yec'o chuka' cheque ri achi'a' fariseos xech'o-apu chin ri Jesús, y xquibij c'a: Rat ri rat jun Maestro vi, nkac'utuj c'a chave que tabana' jun milagro chikavüch. Tac'utu-avi' chikavüch que ja vi ri Dios ri takayon-pe avichin, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pero ri Jesús xbij c'a cheque: Ri vinük richin vocomi juis ye itzel y man nquitakej tüj ri Dios. Ncajo' c'a que yin ninbün na jun milagro chiquivüch richin yinquitakej. Pero man ja tüj c'a ri ncajo' rije' ri nbanatüj. Man quiri' tüj. Xaxe ri xbanatüj riq'uin ri jun achi ri rubini'an Jonás, jun achi ri xk'alajrisan ri xbix chin roma ri Dios ojer can, xaxe ri' ri retal chuka' cheque rije'. ");
INSERT INTO cakENT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Roma ri Jonás xc'uje' c'a pa rupan jun nimalüj cür, oxi' k'ij y oxi' ak'a'. Y quiri' c'a chuka' ri retal ninya' yin chivüch. Yin c'a ri xinalüx chi'icojol, nquic'uje' c'a pa ruc'u'x ri ulef, oxi' k'ij y oxi' ak'a' chuka'. ");
INSERT INTO cakENT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Y tok napon c'a ri k'ij richin juicio, nban c'a chuka' juicio pa quivi' ri vinük yec'o vocomi. Y nyec'astüj c'a pe ri vinük aj-Nínive y nquibij c'a que man utz tüj xquibün ri vinük ri yec'o vocomi, que man xquitakej tüj. Roma ri vinük ri xec'uje' pa tinamit Nínive xe xcac'axaj ri rutzij ri Dios ri xutzijoj ri Jonás cheque, jari' xquitzolij-pe quic'u'x riq'uin ri Dios. Y vocomi yinc'o yin ri más c'o nuk'ij chuvüch ri Jonás, y xa man yinquitakej tüj ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Y tok napon c'a chuka' ri k'ij richin ninbün juzgar pa quivi' ri vinük yec'o vocomi, nyec'astüj c'a pe ri jun reina ri aj-Sabá. Ri reina ri' nbij c'a que man utz tüj xquibün ri vinük ri yec'o vocomi, que man xquitakej tüj. Roma tok xc'ase' ri jun reina ri', juis nüj xbiyin richin quiri' xrac'axaj-pe ri etamabül richin ri jun rey richin ri Israel, ri rubini'an Salomón. Y vocomi yinc'o yin ri más c'o nuk'ij chuvüch ri rey Salomón ri xc'uje' ojer can, y xa man yinquitakej tüj ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tok c'o jun itzel espíritu ntel-e pa ránima jun vinük, nucanoj uxlanen pa tak lugar tz'iran-tz'iran. Pero ri itzel espíritu ri' man nril tüj c'a ri uxlanen ri nucanoj. ");
INSERT INTO cakENT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Romari' tok rija' nunuc c'a: Más utz nquitzolij chic pa ránima ri vinük ri xinel-vi-pe, nbij c'a. Y tok ri jun itzel espíritu re' ntzolij chic apu pa ránima ri vinük, nril c'a ri ránima ri vinük ri' cachi'el jun jay ri man jun ri c'o ta chupan, y meson y chojmirsan can jabel. ");
INSERT INTO cakENT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Y c'ateri' ri itzel espíritu re' nyeruc'ün c'a pe ye siete chic itzel tak espíritu ri más ye itzel, y conojel c'a re' nye'oc pa ránima ri vinük. Y ri vinük achique chok q'uin nyec'uje-vi ri itzel tak espíritu re', más c'ayuf nbün ri ruc'aslen que chuvüch ri xbün nabey. Y quiri' c'a nquic'ulachij ri vinük man utz tüj quic'aslen, ri yec'o vocomi. ");
INSERT INTO cakENT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Y ri Jesús c'a ntajin ntzijon quiq'uin ri vinük tok xapon ri rute' y ri ye ruchak'. Rije' ncajo' c'a nyech'o chin ri Jesús, pero man xe'apon tüj apu c'a riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Y c'o c'a jun ri xbin-apu chin ri Jesús: Ri ate' y ri ye achak' rat coyoben chuvüch ri jay. Rije' ncajo' nyech'o aviq'uin, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero ri Jesús xbij c'a chin ri xbin-apu quiri': Ri cachi'el anucun rat, ¿achique c'a ri nte' y ye achique c'a ri nunimal o nuchak'? ");
INSERT INTO cakENT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Y ri Jesús riq'uin c'a ri ruk'a' xeruc'ut ri rachibila' y xbij c'a: Jare' ri ye c'unük nte' y ye c'unük nchak'. ");
INSERT INTO cakENT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Roma conojel c'a ri nyebanun ri rurayibül ri Nata' Dios ri c'o chila' chicaj, jari' ri ye nte', vana' y nchak', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chupan c'a ri k'ij ri' ri Jesús ye rachibilan ri rachibila' xel-e pa jay y xbetz'uye' chuchi-ya'. ");
INSERT INTO cakENT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Y ye juis c'a q'uiy vinük ri xquimol-apu-qui' riq'uin. Romari' rija' xoc-apu pa jun canoa y xtz'uye-ka chiri' xutzijoj c'a pe ri rutzij ri Dios cheque ri vinük. Y conojel c'a ri vinük ye pa'ül chuchi-ya' ncac'axaj-apu ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Rija' q'uiy c'a ri xbij cheque y ruyon riq'uin ejemplos. Y jun c'a cheque ri ejemplos ri xucusaj, jare': C'o c'a jun achi ri xbe pa jopin ija'. ");
INSERT INTO cakENT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Y tok ri achi c'o chic pa samaj, njopin ija', juba' c'a chin ri ija' pa bey xtzak-vi. Y xepu'u c'a ri ch'ipa' xquic'ux-e ri ija' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Juba' chic c'a chin ri ija' chucojol abüj xtzak-vi y chiri' xa man q'uiy tüj ri ulef c'o. Y chanin c'a xe'el-pe roma man pin tüj ri ulef. ");
INSERT INTO cakENT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Xa ja tok xpu'u ruvüch ri k'ij, xemayamo-ka y xechaki'j-ka. Roma c'a ri xa man nüj tüj benük-ka quixe', romari' xechaki'j-ka chanin. ");
INSERT INTO cakENT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Y juba' chic ija' xtzak-ka chucojol k'ayis c'o quiq'uixal. Y tok xe'el-pe, junan xeq'uiy quiq'uin ri q'uix. Pero roma ri q'uix juis xeq'uiy, ri q'uix xuk'ayisaj ri tico'n. ");
INSERT INTO cakENT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jac'a ri ch'aka chic ija' xetzak pa jun utzilüj ulef, y ri tico'n jabel xeq'uiy y xevachin chuka' jabel. Roma c'o ija' xquiyala' a treinta quivüch, c'o xquiyala' a sesenta y c'o ri xquiyala' a cien quivüch. ");
INSERT INTO cakENT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ri c'o c'a ruxiquin, trac'axaj c'a ri xinbij, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Y jari' tok ri achibila' xebe-apu riq'uin ri Jesús y xquic'utuj chin: ¿Achique katz tok xach'o chiquivüch ri vinük xe'acusaj ejemplos? xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Xpu'u c'a ri Jesús xbij cheque: Man jun bey katz bin ta can jabel pari' tok ri vinük nye'oc pa ruk'a' ri Dios, pero chive rix yo'on c'a k'ij que nivetamaj. Jac'a ri vinük ri man nyetaken tüj vichin, riq'uin ejemplos nquich'o-vi quiq'uin, roma chiquivüch rije' man nk'alajrisüs tüj vi. ");
INSERT INTO cakENT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Roma ri c'o c'a ruyacon pa ránima, nuc'ul c'a más y quiri' q'uiy nc'uje' riq'uin. Jac'a ri xa man q'uiy tüj ruyacon, ntelesüs c'a ri ba' ri' chin. ");
INSERT INTO cakENT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Xa roma c'a ri' tok yin nyencusaj ejemplos richin nquich'o quiq'uin. Roma xa man ncajo' tüj nk'ax cheque, stape' (aunque) nquitz'eta' y ncac'axaj. ");
INSERT INTO cakENT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ja vi c'a re' nbanatüj ri tz'iban can roma ri Isaías, ri jun ri xk'alajrisan ri rutzij ri Dios ojer can. Y quere' c'a ri rutz'iban rija': Rix xaxe c'a choj nivac'axaj y man nk'ax ta chive ri nivac'axaj. Rix xaxe ta c'a choj nitz'eta' ri' y man nitz'et tüj jabel ri nitz'eta'. ");
INSERT INTO cakENT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Roma ri cánima ri vinük re' xa xquicovirsaj. C'ayuf c'a que ntoc pa quixiquin ri ncac'axaj. Ri runak' tak quivüch, quimoyin, roma man ncajo' tüj nyetzu'un. Rije' man jun ncajo', man ncajo' tüj ncac'axaj, man ncajo' tüj nka' pa tak quijolon, man ncajo' tüj nquitzolij-pe quic'u'x, richin que yin ninchojmirsaj ri quic'aslen. Quiri' ri xbij ri Dios, ri tz'iban can roma ri Isaías. ");
INSERT INTO cakENT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jac'a rix vachibila', jabel vi iquicot, roma ri runak' tak ivüch nyetzu'un-vi jabel. Ri ixiquin nye'ac'axan-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Roma tivac'axaj na pe' jabel ri ninbij chive vocomi, que ye q'uiy chojmilüj tak vinük y ri achi'a' ri xek'alajrisan ri tzij ri xbix cheque roma ri Dios, ojer can, juis xcajo' xquitz'et ta ri nitz'et rix vocomi, pero man xquitz'et tüj e. Juis chuka' xcajo' xcac'axaj ta ri nivac'axaj rix vocomi, pero man xcac'axaj tüj e chuka'. ");
INSERT INTO cakENT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Y ri Jesús xbij c'a cheque: Tivac'axaj c'a achique nbij ri ejemplo ri nch'o pari' ri achi ri xbe pa jopin ija'. ");
INSERT INTO cakENT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ri ija' ri xtzak can pa bey, jari' ri tzij ri nch'o pari' tok ri vinük nye'oc pa ruk'a' ri Dios. Pero chiquicojol c'a ri vinük ri ncac'axaj ri tzij yec'o ri man ncajo' tüj nquic'ün-ka pa tak cánima. Y romari' tok ri itzel nrelesaj-e ri tzij ri ticon-ka. ");
INSERT INTO cakENT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ri ija' ri xtzak can chucojol tak abüj, nch'o-vi c'a pari' ri rutzij ri Dios ri nac'axüx roma jun vinük. Ri vinük ri' juis c'a nquicot tok nuc'ul ri rutzij ri Dios pa ránima. ");
INSERT INTO cakENT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero roma c'a ri man nuc'ün tüj ka ruxe' jabel ri rutzij ri Dios pa ránima, man nlayuj tüj c'a ri quicot riq'uin, xa jun ca'i-oxi' oc k'ij ri utz c'o riq'uin ri Dios. Y tok nyepu'u c'a pokonül y nyetzelüs roma ri runiman ri rutzij ri Dios, ntzak can chanin. ");
INSERT INTO cakENT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Y ri ija' ri xtzak can chucojol tak k'ayis ri c'o ruq'uixal, nch'o-vi c'a pari' ri rutzij ri Dios ri nac'axüx roma jun vinük. Pero ri vinük ri' roma xa ja ri nrajo' ri tiempo ri nrajo' nbün, njik' c'a ri rutzij ri Dios ri c'o riq'uin. Njik' pa ruk'a' ri beyomül ri cachi'el xa c'o utz nuc'ün-pe nk'alajin y xa man quiri' tüj. Y ri vinük ri' man jun bey c'a nquic'uan jun utzilüj c'aslen y nyeq'uiy chupan ri rutzij ri Dios, y romari' man q'uiy tüj ch'aka chic nyetaken ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jac'a ri ija' ri xtzak-ka pa jun utzilüj ulef, nch'o-vi c'a pari' ri rutzij ri Dios ri nac'axüx roma jun vinük, y ri vinük ri' nuc'ün-vi-ka ri rutzij ri Dios y nuc'uan jun utzilüj c'aslen y nq'uiy chupan ri rutzij ri Dios, y romari' ye q'uiy ch'aka chic nyetaken ri rutzij ri Dios. Nuc'ulachij-vi c'a cachi'el nquibün ri ija'. Roma c'o ija' nquiya' c'a treinta quivüch, yec'o nquiya' a sesenta quivüch y yec'o a cien c'a quivüch nquiya'. Quiri' c'a nbün ruc'aslen ri vinük ri nuc'ün-ka ri rutzij ri Dios pa ránima, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Y ri Jesús xuya' chic c'a jun ejemplo chiquivüch, y xbij c'a: Ri utzilüj ija' ri xberutica' c'a can jun achi pa rulef, junan c'a riq'uin tok ri vinük nye'oc pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero jun ak'a', tok conojel c'a vinük nyevür, xpu'u c'a ri nretzelan richin ri rajaf ri ulef, xberutica' can ri itzel ija' que cachi'el trigo pari' ri trigo ticon chic can. Y xe xberubana' can ri', xbe. ");
INSERT INTO cakENT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jac'a tok xebeq'uiy-pe ri tico'n y xebe'el-pe ruvi', c'a jari' xk'alajin ri itzel k'ayis que cachi'el trigo. ");
INSERT INTO cakENT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Y jari' tok ri ye samajela' richin ri rajaf ri ulef xe'apon c'a riq'uin y xquibij chin: Ri ija' ri xatic-ka pan avulef utz vi. Pero vocomi c'o itzel k'ayis que cachi'el trigo chucojol. ¿Ape' c'a xpu'u-vi ri ija' richin ri itzel k'ayis que cachi'el trigo? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Y ri achi xbij c'a cheque ri rusamajela': Re' rusamaj jun ri nretzelan vichin, ninnuc yin. Y ri ye rusamajela' xquibij c'a chin: ¿Najo' c'a que nkube chuc'ukic? xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero ri achi xbij c'a cheque ri rusamajela': Ni, man nyixbe tüj chuc'ukic, man xa chuc'ukic ri itzel k'ayis que cachi'el trigo quec'ukutüj chuka' ri trigo. ");
INSERT INTO cakENT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Xa tiya' na c'a k'ij que ri itzel k'ayis que cachi'el trigo junan nq'uiy riq'uin ri trigo, c'a tapon na ri k'atoj. Roma tok napon ri k'ij richin ri k'atoj, yin ninbij c'a cheque ri k'atonela' que nabey tiquimolo' ri itzel k'ayis que cachi'el trigo y quequibana' pa tak manojo richin que nyeporox, y c'ateri' c'a tiquik'ata' ri trigo richin que nyequiyaca' can, xbij ri achi. Quiri' xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Y ri Jesús xuya' chic c'a jun ejemplo chiquivüch, y xbij c'a: Jun vit ija' richin mostaza ri nyerutica' jun achi pa rulef, junan nbün riq'uin tok ri vinük nye'oc pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Roma stape' (aunque) ja ri ija' richin ri mostaza ri más tak cocoj, tok ntel-pe, juis nq'uiy y ja rija' ri más nim ntel chiquivüch ri ch'aka chic ichaj. Ri mostaza xa che' c'a nbün tok nq'uiy. Romari' ri ch'ipa' ri nyebe pa cakik', nye'apon chiri' y nquibün quisoc pa tak ruk'a', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ri Jesús xuya' chic c'a jun ejemplo chiquivüch, y xbij c'a cheque: Ri levadura ri nyeruc'ama-pe jun ixok y nuya' can chupan oxi' pajbül-c'üj, ntoc chupan c'a ronojel ri qui'en. Quiri' c'a chuka' nbiyin rutzijol ri rutzij ri Dios ri nch'o pari' tok ri vinük nye'oc pa ruk'a' ri Dios, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Y ronojel c'a ri xbij ri Jesús cheque ri vinük ri', ronojel riq'uin ejemplos. Man jun c'a ri xbij cheque ri man ta xucusaj ejemplos richin xuya' chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Richin quiri' nbanatüj na c'a ri rubin can jun ri xtzijon ri rutzij ri Dios ojer can. Ri rusamajel ri Dios quere' c'a ri rutz'iban can pari' ri Jesús: Yin tok nquich'o nyencusaj c'a ejemplos. Q'uiy c'a ri ye evatül pa rutz'uquic-pe ri ruch'ulef, nyenk'alajrisaj c'a. Quiri' nbij ri tz'iban can. ");
INSERT INTO cakENT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Y tok ri Jesús xerutük c'a can ri vinük chi tak cacho, rija' xtzolij c'a pa jay ye rachibilan ri rachibila'. Y jari' c'a tok ri rachibila' xejel-apu riq'uin y xquibij c'a: Roj nkajo' c'a que rat nabij ta cheke achique ntel-vi chi tzij ri ejemplo pari' ri trigo y ri itzel k'ayis que cachi'el trigo ri xetic can pa jun ulef. Roma man xk'ax ta cheke. ");
INSERT INTO cakENT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Y ri Jesús xuk'alajrisaj c'a chiquivüch ri ejemplo, y xbij c'a: Ri ticoy richin ri utzilüj ija', ja yin ri xinalüx chi'icojol. ");
INSERT INTO cakENT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ri ulef ri xban-vi ri ticoj, ja ri ruch'ulef. Ri utzilüj ija' ja ri yec'o pa ruk'a' ri Dios. Y ri itzel k'ayis que cachi'el trigo ja ri ye richin vi ri itzel. ");
INSERT INTO cakENT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Y ri xbeticon can ri itzel k'ayis que cachi'el trigo roma juis nyetzelan, ja ri itzel-vinük. Ri k'atoj, ja ri nbanatüj pa ruq'uisbül chin ri tiempo katz'amon, y ri k'atonela', ja ri ángeles. ");
INSERT INTO cakENT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Cachi'el c'a nban ri itzel k'ayis que cachi'el trigo que nye'elesüs-e y nyeporox pa k'ak', quiri' c'a chuka' nbanatüj pa ruq'uisbül chin ri tiempo katz'amon. ");
INSERT INTO cakENT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yin ri xinalüx chi'icojol nyentük c'a ri nu-ángeles chiquimolic conojel ri nyebanun itzel y nquibün cheque ch'aka chic que nyetzak. Roma man ninjo' tüj c'a que yec'o ta ri vinük ri' chiquicojol ri yec'o pa nuk'a' yin. ");
INSERT INTO cakENT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Y conojel c'a ri nyemol-e, nyebetorix can chupan ri nimalüj k'ak', y ja chiri' c'a npu'u ri ok'ej cheque y nquijach'ach'ela' quey. ");
INSERT INTO cakENT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jac'a ri vinük ri choj chic quic'aslen nyeyic'lun-vi na vi c'a cachi'el ri k'ij. Nyek'alajin c'a que yec'o pa ruk'a' ri aj-chicaj Quitata'. Ri c'o c'a ruxiquin, trac'axaj c'a ri xinbij. ");
INSERT INTO cakENT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ri beyomül mukun can pa jun ulef y xilitüj roma jun achi, junan c'a riq'uin tok ri vinük nye'oc pa ruk'a' ri Dios. Ri achi ri' xumuk chic c'a can ri beyomül ri' y nquicot ránima xtzolij y xutz'om c'a ruc'ayixic ronojel ri c'o riq'uin, y c'ateri' xulok' ri ulef ri ape' mukutunük-vi ri beyomül. ");
INSERT INTO cakENT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ri vinük ri nye'oc pa ruk'a' ri Dios, ye junan c'a riq'uin jun lok'onel y c'ayinel quichin vekbül-abüj ri nbix perlas cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tok ri achi ri' nril c'a can jun perla juis jabel y nc'ayix, junanin ntzolij y nuc'ayij ronojel ri c'o riq'uin, c'ateri' c'a nbe chulok'ic ri perla ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Y ri ya'l tz'ambül-cür tok yo'on-ka pa ya' y nyeberuc'ama-pe ronojel quivüch cür, junan c'a riq'uin tok ri vinük nye'oc pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Y tok nojnük chic c'a ri ya'l riq'uin cür, nquic'uaj c'a e c'a chuchi-ya'. Y c'ateri' nyetz'uye' c'a chucha'ic. Ri utzilüj tak cür nyequiya' c'a can pa tak chacüch, jac'a ri cür ri xa man ye utz tüj man nyequiya' tüj pa tak chacüch, xa nyequelesaj c'a can. ");
INSERT INTO cakENT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Quiri' c'a ri nc'ulachitüj pa ruq'uisbül chin ri tiempo katz'amon. Ri ángeles nyepu'u c'a chiquicha'ic ri vinük. Lojc'an nyequiya-vi ri choj chic quic'aslen, y nyequelesaj c'a can ri man ye utz tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Y ri vinük ri man ye utz tüj, nyebequitorij c'a can chupan ri nimalüj k'ak', y chiri' c'a npu'u ri ok'ej cheque y nquijach'ach'ela' quey. ");
INSERT INTO cakENT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Y ri Jesús xbij c'a cheque ri rachibila': ¿Xk'ax chive? xbij cheque. Y ri achibila' xquibij c'a: Ja', Ajaf, xk'ax cheke, xquibij rije'. ");
INSERT INTO cakENT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Rija' xbij chic c'a: Jabel utz vi xk'ax chive, roma xixoc yan pa ruk'a' ri Dios y c'o chic ivetaman pari' ri', y chuka' ivetaman ri ye tz'iban can ojer yan chic ri'. Y romari' rix junan c'a riq'uin jun tata'aj pa jun jay. Tok c'o nc'atzin-vi, c'ateri' c'a nyeberelesala-pe ri rubeyomal. Nyerucusaj c'a ri rubeyomal ri c'o yan chic tiempo ye yacül y nyeberelesala-pe chuka' ri rubeyomal ri xa c'ate ba' ri' nyeruchajin, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Y tok ri Jesús xtane' c'a chubixic ri ejemplos ri', rija' xuya' c'a can ri lugar ri' y xbe ye rachibilan-e ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jac'a tok xapon pa tinamit ri ape' xq'uiy-vi, rija' xuc'ut c'a ri rutzij ri Dios chiri' pa jay ape' ntzijos-vi ri rutzij ri Dios. Y roma c'a ri tzij ri nyerubij cheque, ri vinük ri' xsatz quic'u'x y xquibij c'a: ¿Achique c'a roma tok ri achi re' juis etamabül c'o riq'uin y ntiquer nyerubün milagros? ");
INSERT INTO cakENT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Xa jare' ri ruc'ajol ri jun achi samajiy-che' (carpintero). Xa jare' ri María rubini'an ri rute' y ri ye ruchak' ja ri Jacobo, ri José, ri Simón y ri Judas. ");
INSERT INTO cakENT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Xa chikacojol c'a roj yec'o-vi ri ye rana'. ¿Ape' ta c'a xretamaj-vi ri retaman y ape' ta c'a petenük-vi ri ruchuk'a' richin nyerubanala' milagros? nquibij chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Y romari' ri vinük man ba' tüj xquitakej ri Jesús. Y ri Jesús xbij c'a cheque ri vinük ri': Conojel c'a ri nyek'alajrisan ri tzij ri bin cheque roma ri Dios, man jun quik'ij, pero ri' xaxe chiquivüch ri vinük aj pa rutinamit y chiquivüch ri aj pa racho, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chupan ri rutinamit, ri Jesús man q'uiy tüj milagros ri xerubanala', roma ri ruvinak man xquitakej tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chupan c'a ri tiempo ri', ri Herodes ri rey richin ri ruch'ulef Galilea, xrac'axaj c'a que ri Jesús juis rutzijol chiquicojol ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Y ri Herodes xbij c'a cheque ri rajic'a': Ri Jesús xa ja ri Juan Bautista c'astajnük-pe chiquicojol ri caminaki'. Romari' tok c'o uchuk'a' pa ruk'a' richin q'uiy ri ntiquer nyerubanala', xbij ri Herodes cheque ri rajic'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Roma xa ja ri rey Herodes ri xbin que tiz'amatüj-pe ri Juan. Xuxim-vi c'a pa cadena y xuya' pa cárcel. Ri Herodes quiri' xbün roma ri ixok ri c'o riq'uin. Ri ixok rubini'an Herodías, xa rixjayil c'a ri Felipe ri ruca'n ruchak' ri Herodes. ");
INSERT INTO cakENT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ri Juan xtz'am c'a roma jari' ri rubin chin ri Herodes. Rija' rubin c'a chin: Man utz tüj abanun que ac'amon-ka ri Herodías. ");
INSERT INTO cakENT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Y roma c'a ri' ri Herodes rujo'on c'a rucamsan ta ri Juan, pero nuxbij c'a ri' chiquivüch ri vinük, roma rije' quetaman que ri Juan Bautista jun k'alajrisüy richin ri tzij ri nbix chin roma ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Xa ja chupan ri k'ij tok ri Herodes xutz'akatisaj jun chic rujuna', rija' xbün c'a jun nimak'ij, y chupan c'a ri nimak'ij ri' ri xtün ral ri Herodías xxajo' c'a chuvüch ri Herodes, y ri Herodes juis xka' chuvüch ri xajoj ri xbün ri xtün. ");
INSERT INTO cakENT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Y romari' ri Herodes xbün c'a jurar chin ri ral ri Herodías que achique na c'a ri nrajo' xa nuya-vi chin. ");
INSERT INTO cakENT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pero tok ri xtün rutaken chic c'a runa'oj riq'uin ri rute', c'ateri' c'a xbij chin ri Herodes: Yin ninjo' que naya' chinuvüch chere' pa jun lük, ri rujolon ri Juan Bautista, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Y ri rey Herodes xpu'u bis pa ránima romari', pero roma c'a rubanun chic jurar chin que nuya-vi ri nrajo' y roma chuka' chiquivüch ri ye rachibilan chuvüch mesa xbij-vi, rija' xbij c'a que tic'amür-pe ri rujolon ri Juan Bautista chin ri xtün ral ri Herodías. ");
INSERT INTO cakENT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Xutük c'a rukupixic rukul ri Juan Bautista chiri' pa cárcel. ");
INSERT INTO cakENT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Y ri rujolon xc'amür-pe pa jun lük chin ri xtün, y ri xtün xberujacha' pa ruk'a' ri rute'. ");
INSERT INTO cakENT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Y ri ye rachibila' ri Juan Bautista xe'apon c'a chucanoxic ri ruch'acul y xbequimuku' can. Y rije' xbequibij c'a chuka' chin ri Jesús ronojel ri xbanatüj. ");
INSERT INTO cakENT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Y ri Jesús xe c'a xrac'axaj-e ronojel ri banatajnük, xbe, ye rachibilan-e ri rachibila'. Xe'oc-e pa jun canoa y xec'o c'a lojc'an ruchi-ya', xebe c'a pa jun lugar nüj. Lugar ri ye manak vinük. Xa jac'a tok ri vinük xcac'axaj-e, chicakün c'a xe'el-e pa tak tinamit richin xe'apon c'a ri lugar ri ape' nc'atzinej que napon-vi ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Y tok ri Jesús ntel-e c'a chupan ri canoa chiri' lojc'an ruchi-ya', xutz'et c'a que ye juis chic ye q'uiy vinük ri coyoben richin y rija' juis c'a xujoyovaj quivüch ri vinük ri'. Y rija' xeruc'achojrisaj-vi c'a ri yava'i' yec'o chiquicojol. ");
INSERT INTO cakENT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Y tok xa xkak'ij-ka chupan ri jun k'ij ri', ri rachibila' xejel c'a apu riq'uin y xquibij chin: Ri chere' xa ye manak vinük y juis xkak'ij yan. Que'ataka' c'a e ri vinük re' richin que nyebe pa tak cocoj tinamit ri yec'o-pe nakaj y tiquilok'o' quivay chiri', xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pero ri Jesús xbij cheque ri rachibila': Man nc'atzin tüj c'a richin nyebe y c'ateri' nquil ta quivay, xa tiya' rix quivay, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Y ri rachibila' xquibij c'a: Roj xaxe vo'o' vüy y ca'i' cür kachajin, y re' man nyerubün tüj, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Pero ri Jesús xbij cheque: Tic'ama-pe chere'. ");
INSERT INTO cakENT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Y jari' chuka' tok rija' xbij que quetz'uye' c'a conojel ri vinük pari' ri sabana. Y c'ateri' rija' xeruli'ej pa ruk'a' ri vo'o' vüy y ri ca'i' cür, xtzu'un chicaj y xumatioxij chin ri Dios. Rija' xeruper c'a e ri cür y ri vüy, y xuya-e cheque ri rachibila' y ri rachibila' xbequijacha' can chiquivüch ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Conojel c'a jabel xquic'ux quivay. Man jun c'a ri man ta jabel xva'. Y c'a c'o na c'a doce chacüch ri xnoj can riq'uin ri vüy y ri cür ri xmolotüj can, ri xa man xq'uis tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Conojel c'a ri vinük ri xquic'ux quivay yec'o la'ük vo'o' mil xaxe achi'a', y yec'o chuka' ixoki' y ac'uala'. ");
INSERT INTO cakENT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Y jari' tok ri Jesús xerucusaj-e ri rachibila' chupan ri canoa y xbij cheque que quebiyin c'a ri lojc'an chic ruchi-ya', que quenabeyüj c'a e chuvüch, roma rija' c'a xcanaj can chin nyerutakala' ri vinük chi tak cacho. ");
INSERT INTO cakENT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jac'a tok ye rutakon chic c'a ri vinük chi tak cacho, ruyon c'a xjote-e pari' ri juyu' chubanic orar. Y chiri' c'a c'o-vi tok xoc-pe ri ak'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Y ri canoa ri ye benük-vi ri achibila' pa runic'ajal chic c'a ya' c'o-vi, pero ri nbolko't ri ya' man nuya' tüj k'ij que nbiyin. Juis c'a cakik' y man nuya' tüj k'ij chin ri canoa que choj nbe chuvüch. ");
INSERT INTO cakENT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Y tok cumaj yan ri saker, ri Jesús petenük c'a chirakün pari' ri ya', richin napon quiq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pero tok ri rachibila' xquitz'et que c'o jun petenük chirakün pari' ri ya', rije' xsatz quic'u'x y xquibij: ¡La' jun xibinel! xquibij. Y riq'uin cuchuk'a' xquibila' quiri' roma quixbiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero ri Jesús chanin xch'o-pe cheque, y xbij c'a: Man tixbij-ivi'. Xa tiya' ivánima. Ja yin ri Jesús, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Y ri Pedro jari' xch'o-apu chin ri Jesús ri c'a petenük pari' ri ya'. Ri Pedro xbij c'a chin ri Ajaf Jesús: Si ja rat, tabana' c'a chuve que nquibiyin pari' ri ya' richin nquibe-apu aviq'uin, xbij ri Pedro. ");
INSERT INTO cakENT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Y ri Ajaf Jesús xbij-pe chin ri Pedro: Catampe c'a. Y ri Pedro jari' xka-ka-e pa canoa y xutz'om c'a nbiyin-apu pari' ri ya' richin nbe-apu c'a riq'uin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Xa ja tok xutz'et ri nbün ri nimalüj cakik', xpu'u xbiri' chin. Y tok xuna' que nbe-ka chuxe' ri ya', riq'uin c'a ruchuk'a' xbij: ¡Ajaf, quinacolo'! ");
INSERT INTO cakENT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Y ri Jesús jari' xutz'om chanin ri Pedro y xbij chin: ¿Achique c'a roma ba' oc ayo'on avánima viq'uin? xbix chin ri Pedro roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tok rije' ye jotol chic c'a e pa canoa, ri cakik' xtane-e. ");
INSERT INTO cakENT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Y jari' tok conojel ri ye benük chiri' pa canoa xquiya' c'a ruk'ij ri Jesús y xquibij chin: Vocomi c'a xkatz'et ketzij que ja vi rat ri Ruc'ajol ri Dios. Quiri' c'a xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Y rije' xec'o c'a pari' ri lago ri' y xe'apon pa tinamit Genesaret. ");
INSERT INTO cakENT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chiri', tok xetamüx c'a ruvüch ri Jesús coma ri achi'a', rije' xquelesaj c'a rutzijol chanin c'a pa tak lugar yec'o-pe chunakaj ri quitinamit, y ri vinük xequic'amala' c'a pe ri quiyava'i'. ");
INSERT INTO cakENT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Y ri yava'i' re' nquic'utula' c'a favor chin ri Jesús que tuya' k'ij cheque que stape' (aunque) xaxe ruchi-rutziek nquitz'om richin nyec'achoj. Y quiri' vi c'a xbanatüj. Conojel ri xetz'amon ruchi-rutziek ri Jesús xec'achoj q'uin ri quiyabil. ");
INSERT INTO cakENT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Y yec'o c'a ca'i-oxi' achi'a' ri xe'apon riq'uin ri Jesús. Ri achi'a' ri' ye aj-Jerusalén y jari' ri nbix cheque fariseos y etamanela' richin ri ley ri xuya' ri Dios richin ri Moisés. Xe'apon c'a riq'uin ri Jesús y xquibij chin: ");
INSERT INTO cakENT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Achique c'a roma tok ri avachibila' nquik'üj ri bin can coma ri kaxquin-kamama' can? Roma ri avachibila' tok nquic'ux quivay man nquich'üj tüj jabel ri quik'a'. Man nquibün tüj cachi'el rubanic ruch'ajic quik'a' ri chilaben cheke konojel, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ri Jesús roma ri xquic'utuj quiri' chin, rija' xbij c'a cheque: Y rix ¿achique c'a roma tok ja riq'uin ri quibin ri kaxquin-kamama' can, riq'uin ri' nik'üj-vi ri ru-ley ri Dios? ");
INSERT INTO cakENT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ri ru-ley ri Dios nbij c'a: Taya' quik'ij rate-atata'. Y ri nbanun c'a itzel cheque rute-rutata', man jun chic c'a ri nrajo', ja vi c'a ri camic ri tika-ka pari'. Quiri' c'a ri rubin can ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Jac'a rix xa man quiri' tüj ri nibün y nic'ut. Xa man nibün tüj cachi'el ri rubin can ri Dios. Rix xa nye'itijoj ri ac'uala' que man nc'atzin tüj que nyequito' ri quite-quitata'. Xa nye'el chuvüch ri' riq'uin nquibij cheque ri quite-quitata': Yin man nquitiquer tüj nyixinto' riq'uin ri nc'atzin chive, roma xa nsujun chic chin ri Dios ri nc'atzin ta chive rix. Y riq'uin nquibij quiri' nye'el chuvüch ronojel, nibila' cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Y riq'uin ri nibij, nk'alajin-vi que rix nibij cheque que man tiquiya' quik'ij quite-quitata'. Y riq'uin ri', xaxe riq'uin ri quibin can ri kaxquin-kamama' can ibanun que man jun ruk'ij ri ru-mandamientos ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Rix xa ca'i' c'a ipalüj. Xa jabel c'a rubixic rubanun can ri Isaías chivij. Ri xbij ri Dios chin que tutz'ibaj can, nbij c'a: ");
INSERT INTO cakENT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ri vinük re' xaxe riq'uin ri quitzij nquiya' nuk'ij, jac'a ri nrajo' ri cánima xa man ja tüj ri', xa nüj c'a chin ri nquiya' ta nuk'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xa man jun c'a nc'atzin-vi ri nquiya' nuk'ij, roma xa ye maestros quichin quetamabül achi'a' y nquibij que jari' ri nc'atzinej que nban. Quiri' ri rutz'iban can ri Isaías, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Y c'ateri' c'a ri Jesús xch'o quiq'uin ri juis chi vinük quimolon-qui' chiri', y xbij c'a cheque: Tivac'axaj c'a ri ninbij chive y tik'ax-e chive. ");
INSERT INTO cakENT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ri nbanun tz'il chin ri vinük man ja tüj c'a ri ntoc pa ruchi', nbanun, man quiri' tüj. Ri nbanun tz'il chin ri vinük xa ja ri ntel-e pa ruchi', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Y tok ri achibila' xejel-apu riq'uin ri Jesús, xquibij chin: Ri achi'a' fariseos xpu'u coyoval tok xcac'axaj ri tzij ri xabij, xquibij ri achibila'. ");
INSERT INTO cakENT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero rija' xbij cheque ri rachibila': Ri tico'n ri quibanun rije' man nc'uje' tüj c'a can, xa nic'uk-e. Roma ronojel ri tico'n ri' man ja tüj c'a ri Nata' c'o chila' chicaj banayun. ");
INSERT INTO cakENT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xa que'iya' can. Xa ye moyirnük c'a riq'uin ri etamabül ri quichajin, y nyequic'uaj ch'aka chic ri xa ye moyi' chuka'. Y si ri ye moyi' nyequiyukej ri ch'aka chic moyi', junan c'a nyetzak pa tak jul, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Y ri Pedro xbij c'a chin ri Jesús: Tabij ba' cheke pari' ri nbanun tz'il chin jun vinük, roma man nk'ax ta cheke, xbij ri Pedro. ");
INSERT INTO cakENT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Y ri Jesús xbij: ¿Rix chuka' c'a man jani nk'ax ta chive ri ninbij? ");
INSERT INTO cakENT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Man nk'ax ta chive ri tzij ri nbij que ri nuc'ux-ka ri vinük xa man ja tüj ri' ri nbanun tz'il chin? Roma ri nuc'ux-ka xa choj pa rupan nbe-vi y c'ateri' ntel-e. ");
INSERT INTO cakENT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ri nbanun tz'il chin jun vinük ja ri tzij, ri nojibül ri nyepu'u riq'uin. Ri nye'el-pe pa ránima. ");
INSERT INTO cakENT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Roma xa pa cánima c'a ri vinük nyepu'u-vi ri itzel tak nojibül. Chiri' npu'u-vi ri nojibül tok nyecamsan. Chiri' chuka' npu'u-vi ri nojibül tok ri vinük ri ye c'ulan y ri man ye c'ulan tüj nquicanola-qui' richin nyemacun. Y pa cánima chuka' npu'u-vi tok nye'elek', nquiyacala-pe tzij chiquij ch'aka chic, y chuka' tok nyeyok'on. ");
INSERT INTO cakENT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Y ronojel c'a ri nojibül quiri' jari' ri nbanun chin jun vinük que nutz'ilübisaj-ri'. Pero ri nbün ri vinük que man jabel tüj ruch'ajon ruk'a' y c'ateri' nuc'ux-ka ruvay, ri' man jun nbün chin ri ruc'aslen. Man nutz'ilübisaj tüj. Quiri' c'a xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Y ri Jesús ye rachibilan ri rachibila' xel c'a e chiri', y xbe c'a cala' pa jun lugar ri nakaj ncanaj cheque ri tinamit quibini'an Tiro y Sidón. ");
INSERT INTO cakENT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Y chiri' yec'o-vi c'a ri ye ruxquin-rumam can ri achi rubini'an Canaán. Y jun c'a ixok ri chiquicojol rije', xpu'u c'a riq'uin ri Jesús. Rija' roma bis, nuc'utula' c'a favor chin ri Jesús y nubila' c'a riq'uin ruchuk'a': Tajoyovaj nuvüch rat Ajaf, rat ri ruxquin-rumam can ri rey David. Quinato' c'a, roma ri val-xtün c'o jun itzel espíritu riq'uin, y c'ayuf rubanun pa ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero ri Jesús man jun tzij xbij chin ri ixok. Y ri rachibila' xejel-apu riq'uin ri Jesús y xquibij chin: Tabana' que tic'uje' can ri ixok re', roma tzeketül-pe chikij y ri rutzij c'anüj nac'axüx-vi, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Xpu'u ri Jesús xbij: Yin xintak-pe xaxe chiquicanoxic ri kavinak israelitas ri man yec'o tüj apu riq'uin ri Dios, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jari' tok xpu'u ri ixok xxuque-pe chuvüch ri Jesús, y xbij chin: Ajaf, quinato' c'a, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Pero ri Jesús xbij chin ri ixok: Ri utzilüj sipanic ri nspaj-pe ri Dios man utz tüj que chin achique na ninya-vi. Cachi'el ri quivay ri ac'uala' man c'uluman tüj que ntelesüs cheque richin ja ri vit tak tz'i' cho jay nyec'uxun, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero ri ixok xbij: Ajaf, ketzij ri nabij. Pero nkutiquer c'a chuka' nkac'ul-apu ba' chin ri utzilüj sipanic ri nspaj-pe ri Dios. Cachi'el nquibün ri vit tak tz'i' cho jay nyequimolola' ri ruchi' tak vüy ri nyequitzük-ka ri cajaf nyeva' chuvüch mesa. ");
INSERT INTO cakENT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Y ri Jesús jari' xbij c'a chin ri ixok: Juis nk'alajin que ayo'on avánima. Tibanatüj-vi c'a ri juis najo' rat, xbij ri Jesús. Y ri xtün, ral ri ixok, chupan c'a ri hora ri' xel-e ri itzel espíritu riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tok ri Jesús ye rachibilan ri rachibila' ye c'unük chic c'a pe chupan ri lugar ri nakaj ncanaj-vi cheque ri tinamit Tiro y Sidón, xapon c'a chunakaj ri lago rubini'an Galilea. Y rija' xjote' c'a pari' ri juyu' c'o chiri' y c'ateri' xbetz'uye'. ");
INSERT INTO cakENT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Y yec'o c'a juis ye q'uiy vinük ri xe'apon riq'uin, y ye quic'uan-apu quiyava'i'. Cheque ri yava'i' ri ye quic'uan-apu yec'o ri xa man choj tüj nyebiyin roma ri ye jetz', yec'o moyi', yec'o mema', yec'o ri man utz tüj ri quik'a' ri cakün, y yec'o ch'aka chic ri jun vi chic chi ruvüch yabil ntoc cheque. Ri vinük ri' xequiya' c'a apu ri quiyava'i' chuvüch ri Jesucristo, y rija' xeruc'achojrisaj. ");
INSERT INTO cakENT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Roma c'a ri xbün ri Jesús quiq'uin ri yava'i', ri vinük xe' xquica'yej tok xquitz'et. Roma ye mema' ri banun can, y vocomi nyech'o yan chic. Ri man utz tüj ri quik'a' ri cakün, xec'achoj. Ri ye jetz', choj chic nyebiyin. Ri moyi', nyetzu'un yan chic. Ri vinük xquiya-vi c'a ruk'ij ri Dios ri richin ri Israel. ");
INSERT INTO cakENT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Y tok ri Jesús xeroyoj ri rachibila', xbij c'a cheque: Juis ninjoyovaj quivüch ri vinük re', roma c'o yan oxi' k'ij yec'o-pe viq'uin y vocomi man jun chic quivay richin nquic'ux. Y nyentük ta c'a e chi tak cacho choj quiri' y man jun nquic'ux-e, man utz tüj man xa quebetzak pa tak bey roma vayjül, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jari' xech'o-apu ri rachibila' chin ri Jesús y xquibij c'a: Ri lugar ape' rojc'o-vi xa ye manak vinük. ¿C'o ta nyekila-vi-pe vüy richin nyekatzuk jabel ri vinük re'? Xa juis ye q'uiy, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pero ri Jesús xuc'utuj cheque: ¿Jaru' c'a vüy ichajin? xbij. Y rije' xquibij: Roj xaxe siete vüy kachajin y chuka' ca'i-oxi' vit cür, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Y ri Jesús xbij c'a que ri vinük quetz'uye-ka pan ulef. ");
INSERT INTO cakENT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","C'ateri' rija' xeruli'ej ri siete vüy y ri cür pa ruk'a' y xumatioxij chin ri Dios. Y c'ateri' c'a xeruvech'ela-e y xuyala-e cheque ri rachibila', y ri achibila' nyequiya' cheque ri vinük ri', ri juis vi ye q'uiy. ");
INSERT INTO cakENT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Conojel c'a jabel xquic'ux quivay. Man jun c'a ri man ta jabel xva'. Y c'a c'o vüy y cür ri xcolotüj can. Siete chacüch ri xnoj can riq'uin ri vüy y cür ri xcolotüj. ");
INSERT INTO cakENT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ye caji' mil achi'a' c'a ri xquic'ux quivay. Jac'a ri ixoki' y ri ac'uala' ri xquic'ux quivay, man xe'ajlüx tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Y ja tok ri Jesús ye rutakalon chic e ri vinük chi tak cacho, rija' ye rachibilan ri rachibila' xoc-e pa canoa y xbe c'a pa tinamit Magdala. ");
INSERT INTO cakENT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Y jari' tok yec'o achi'a' fariseos y yec'o chuka' achi'a' saduceos ri xe'apon riq'uin ri Jesús. Ri achi'a' ri' xe'apon riq'uin xaxe richin que nquitij ri Jesús, y xquibij c'a chin que tuc'utu' jun retal chupan ri caj, richin tuc'utu' que rija' ja vi ri Dios takayon-pe richin, xquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero ri Jesús xbij cheque ri achi'a' ri': Rix tok nitz'et que cük quibanun ri sutz' chicaj, tok ntajin nka-ka ri k'ij, nibij que utz k'ij nberubana'. ");
INSERT INTO cakENT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y chuka' pa tak saker, tok rix nitz'et que ri caj k'ekumuj banun y cük chuka' quibanun ri sutz', nibij que man utz tüj k'ij nberubana'. Rix xa ca'i' c'a ipalüj, roma jabel ivetaman nitz'eta' ri caj, ivetaman si utz o man utz tüj k'ij nberubana'. Jac'a ri retal ri ntz'etetüj-vi y nbij achique tiempo rojc'o-vi, rix xa man nitz'eta' tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ri vinük re' ri yec'o vocomi juis ye itzel y man nquitakej tüj ri Dios. Ncajo' que yin ninbün ta que c'o ri nc'ulachitüj chupan ri caj richin yinquinimaj. Pero man ja tüj c'a ri ncajo' rije' ri nc'ulachitüj. Man quiri' tüj. Xaxe ri xc'ulachitüj riq'uin ri jun achi ri rubini'an Jonás, jun achi ri xk'alajrisan ri xbix chin roma ri Dios ojer can, xaxe ri' ri retal chuka' cheque rije', xbij ri Jesús y xbe ye rachibilan ri rachibila'. Xeruya' can quiyon ri achi'a' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Y ja tok ri Jesús y ri rachibila' xe'apon c'a ri lojc'an ruchi-ya', ri rachibila' c'ateri' c'a xquinabej que xa manak caxlan vüy quic'uan-e. ");
INSERT INTO cakENT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ri Jesús xbij c'a cheque ri rachibila': Tivac'axaj c'a ri ninbij chive, que tichajij c'a ivi' chuvüch ri levadura quichin ri achi'a' fariseos y ri achi'a' saduceos, roma xa nnimur, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Y roma quiri' xbij ri Jesús, ri rachibila' xquinuc c'a pa tak cánima: Rija' xbij quiri' roma roj man xkac'ün tüj pe caxlan-vüy. (Ri levadura xa cachi'el jun ak'on que nbün chin ri qui'en ri ntoc caxlan-vüy que nnimür). ");
INSERT INTO cakENT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero ri Jesús xretamaj c'a ri nquinuc ri rachibila' pa tak cánima, y xbij c'a cheque: ¿Achique roma rix ninuc que roma manak caxlan-vüy, romari' tok xinbij quiri'? ¿Man iyo'on tüj ivánima viq'uin y romari' xaxe chic ri vüy ri ninuc? ");
INSERT INTO cakENT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Manak c'a nc'atzin-vi que xaxe chic ri vüy ri ninuc. Cachi'el xa c'a man jani nk'ax ta chive. ¿Y man nka-pe tüj c'a chi'ic'u'x tok xentzuk ri vo'o' mil vinük riq'uin ri vo'o' vüy? ¿Man nka-pe tüj c'a chi'ic'u'x jaru' chi chacüch vüy ri ximol can? ");
INSERT INTO cakENT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Chuka' man nka-pe tüj c'a chi'ic'u'x tok xentzuk ri caji' mil vinük riq'uin ri siete vüy? ¿Chuka' jaru' c'a chacüch ri xe'imol can? ");
INSERT INTO cakENT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Achique ta c'a jun chic rubixic ninbün yin, richin nk'ax ta chive que man roma tüj ri caxlan-vüy ri ximestaj can, tok xinbij que rix tichajij-ivi' chuvüch ri levadura quichin ri achi'a' fariseos y saduceos? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Y ri rachibila', c'ateri' c'a xk'ax chive que man chuvüch tüj c'a ri levadura ri nquicusaj ri achi'a' fariseos y saduceos ri tiquichajij-vi-qui'. Xa chuvüch c'a ri quitijonic ri achi'a' ri', ri tiquichajij-vi-qui', roma ri tijonic ri' chanin nuyoj ape' ri ntoc-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Y ri Jesús rachibilan ri rachibila' xapon c'a pa jun lugar ri nakaj ncanaj chin ri tinamit rubini'an Cesarea richin ri Filipo. Xpu'u ri Jesús xuc'utuj c'a cheque ri rachibila': ¿Achique c'a nquinuc ri vinük pa nuvi' yin ri xinalüx chi'icojol, que yin achique c'a yin? xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Y ri rachibila' xquibij c'a chin ri Jesús: Yec'o ri nyebin que rat ja ri Juan Bautista. Yec'o ch'aka chic nquibij que ja rat ri Elías, ri jun achi ri xk'alajrisan ri xbix chin roma ri Dios ojer can. Yec'o chuka' ri nyebin que rat ja ri Jeremías ri jun chuka' achi ri xk'alajrisan ri xbix chin roma ri Dios ojer can. Y yec'o chuka' ri nyebin que rat jun c'a cheque ri ch'aka chic achi'a' ri xek'alajrisan ri xbix cheque roma ri Dios ri ojer, xquibij ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Y rija' xuc'utuj c'a cheque ri rachibila': Y rix ¿achique ninuc pa nuvi'? xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Y ri Simón Pedro jari' xbij chin ri Jesús: Ja rat ri Cristo, ri jun cha'on-pe y takon-pe roma ri Dios, ri Ruc'ajol ri c'aslic Dios, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Y xe c'a xrac'axaj ri Jesús quiri', jari' xbij: Rat Simón Pedro ruc'ajol ri Jonás, jabel c'a aquicot, roma ri xabij que ja yin ri Cristo ri Ruc'ajol ri Dios. Ri xabij man jun tüj c'a vinük ri xk'alajrisan chavüch, xa ja ri Nata' Dios ri c'o chila' chicaj ri xk'alajrisan chavüch. ");
INSERT INTO cakENT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yin ninjo' c'a ninbij chave rat: Yin nuyo'on chic c'a jun abi'. Romari' tok rat abini'an Pedro. Y ninbij chuka' chave que pari' c'a ri abüj re' ninpaba-vi ri nu-iglesia. Y man c'a nch'acatüj tüj roma ri camic y roma ri itzel. ");
INSERT INTO cakENT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Chave vi c'a rat ninya-vi ri llave chin najük o natz'apij ri puerta richin ri vinük nye'oc pa ruk'a' ri Dios. Utz vi c'a ntz'etos ri chila' chicaj, tok rat natz'apij o najük jun puerta chiquivüch ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Y ri Jesús jari' xbij cheque ri rachibila' que man jun tiquibij-vi que ja rija' ri Cristo. ");
INSERT INTO cakENT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jari' chuka' tok ri Jesús xutz'om ruk'alajrisasic chiquivüch ri rachibila', que nc'atzin c'a que rija' nbe pa tinamit Jerusalén richin nuc'usaj q'uiy pokonül pa quik'a' ri rajatük tak achi'a' ri c'o quik'ij, pa quik'a' ri más-nimalüj tak sacerdotes y pa quik'a' chuka' ri etamanela' chin ri ley ri xuya ri Dios richin ri Moisés. Nquinapon na c'a pa camic, pero pa rox k'ij nquic'astüj c'a pe, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Y ri Pedro xe c'a xrac'axaj que quiri' xbij ri Jesús, xberuc'ama-pe y c'a cala' ri xbechapon-pe chin. Xbij c'a chin: Man ta ja nrajo' ri Dios, que nbanatüj cachi'el ri xabij rat Ajaf, xbij ri Pedro. ");
INSERT INTO cakENT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero tok ri Jesús xrac'axaj quiri', xupiscolij-ri'. Y xbij c'a chin ri Pedro: Man cac'uje-pe viq'uin rat Satanás, roma man utz tüj ri nanuc. Rat xa ncatoc k'atbül ruvüch nubey. Roma ri anojibül rat xa junan riq'uin ri nquinuc ri vinük y man nanuc tüj ba' achique c'a ri nrajo' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Y ri Jesús xch'o c'a chuka' cheque ri ch'aka chic rachibila' y xbij: Si c'o jun nrajo' ntzekleben vichin, tubana' c'a cachi'el nbün jun ri benük chuxe' ru-cruz. Man nbün tüj ri nurayij rija'. Man nupokonaj tüj nuc'usaj pokonül. Si c'o c'a jun ri nnucun quere', utz npu'u viq'uin richin nquirutzeklebej. ");
INSERT INTO cakENT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Roma si juis nupokonaj ri ruc'aslen ri chere' chuvüch ri ruch'ulef, xa man nril tüj c'a ruc'aslen richin chi jumul. Jac'a ri man nupokonaj tüj ri', stape' (aunque) napon pa camic voma yin, nril-vi ruc'aslen richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Roma achique ta c'a nuc'ün-pe chin ri vinük, si nc'uje' ri beyomül richin ronojel ri ruch'ulef riq'uin y ri vinük re' xa man ncolotüj tüj? Stape' (Aunque) ta juis ri beyomül c'o riq'uin ri vinük, man ntiquer tüj c'a nulok' ri c'aslen richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yin ri xinalüx chi'icojol nquipu'u c'a jun bey chic, y junan chic c'a nuk'ij riq'uin ri Nata' y ye vachibilan-pe ri nu-ángeles. Y jari' tok ninya' ruq'uexel cheque conojel, ruq'uexel ri quibanun. ");
INSERT INTO cakENT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Y tivac'axaj c'a ri ninbij chive, y juis rakalen: Yin ri xinalüx chi'icojol nquipu'u-vi c'a, riq'uin chic nuk'ij y c'o chic autoridad pa nuk'a'. Y yec'o c'a chive rix man nyecom tüj, c'a tok quitz'eton chic na can ri', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Y tok c'unük chic c'a vaki' (seis) k'ij, ri Jesús xucha' ri Pedro, xerucha' chuka' ri Jacobo y ri Juan ri quichak'-qui', richin que xaxe quiyon ri ye oxi' xeruc'uaj c'a pari' jun juyu' nim. ");
INSERT INTO cakENT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ri Jesús xjalatüj c'a ruvüch chiquivüch ri ye oxi' rachibila'. Xoc c'a cachi'el ntzu'un ri k'ij tok jabel nyiq'uiyot. Y ri rutziek xoc cachi'el ri sük. Juis c'a sük xtzu'un. ");
INSERT INTO cakENT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Y tok ri ye oxi' achibila' xquitz'et c'a, nyetzijon yan chic riq'uin ri Jesús ri ca'i' achi'a' quibini'an Moisés y Elías. Ri achi'a' ri' ye rusamajela' ri Dios ri xec'uje' ojer can tiempo. ");
INSERT INTO cakENT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Y c'ateri' c'a tok ri Pedro xbij-apu chin ri Jesús: Ajaf, chere' utz kabanun. Si rat najo', nkabün c'a oxi' tak jay. Jun chave rat, jun chin ri Moisés, y jun chuka' chin ri Elías. ");
INSERT INTO cakENT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tok ri Pedro c'a ntajin nch'o apu chin ri Jesús, xa jari' tok ri achibila' ri' xquitz'et que c'o jun sutz' nsakin xka-pe pa quivi'. Y chupan c'a ri sutz' ri' c'o Jun ri xch'o-pe y xbij: Jare' ri Nuc'ajol y juis ninjo'. Nuyo'on c'a vánima riq'uin. Tivac'axaj c'a ri rutzij. ");
INSERT INTO cakENT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Y tok ri ye oxi' achibila' xcac'axaj ri', xquikasaj-ka-qui' c'a pan ulef. Y juis c'a xquixbij-qui'. ");
INSERT INTO cakENT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Y ri Jesús xjel c'a apu quiq'uin ri rachibila', xerutz'om-ka y xbij c'a cheque: Quixcatüj c'a y man tixbij-ivi', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tok ri achibila' xebetzu'un-pe, man jun chic c'a ri achique ri xquitz'et, xa ruyon chic c'a ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Y tok rije' ye xulan c'a pe chuvüch ri juyu', ri Jesús xuchilabej cheque ri rachibila': Man jun titzijoj ri xitz'et. Rix utz nitzijoj pero tok yin ri xinalüx chi'icojol xinc'astüj yan pe chiquicojol ri caminaki', c'a jari' tok c'uluman nitzijoj, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ri achibila' ri' jari' xquibij chin ri Jesús: Roj k'axnük cheke que ja rat ri Cristo, ri cha'on-pe y takon-pe roma ri Dios. ¿Pero achique c'a roma tok ri etamanela' chin ri ley ri xuya ri Dios richin ri Moisés nquibij que nabey que nka-pe ri Cristo, ri Jun cha'on-pe y takon-pe roma ri Dios, nc'atzinej que nka-pe ri Elías? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Y ri Jesús xbij c'a cheque: Ketzij vi que ri Elías npu'u nabey y nbün c'a ruchojmil ronojel ri c'o. ");
INSERT INTO cakENT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero yin ninbij c'a chive que ri Elías ri' xpu'u yan y man xquinabej tüj achique ri'. Xa juis xquibün-e chin. Achique ri xquirayij xquibün-e chin, quiri' vi xquibün. Y quiri' c'a chuka' yin ri xinalüx chi'icojol, yec'o ri nyebanun chuve que ninc'usaj pokonül, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Y c'ateri' c'a tok ri achibila' xk'ax cheque que ri Jesús pari' c'a ri Juan Bautista xch'o-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tok ri Jesús y ri ye oxi' rachibila' xe'apon-ka ape' quimolon-qui' juis ye q'uiy vinük, c'o c'a jun achi xka-pe riq'uin ri Jesús y xxuque' chuvüch. Ri achi xbij c'a chin ri Jesús: ");
INSERT INTO cakENT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ajaf, tajoyovaj ruvüch ri nuc'ajol, roma rija' juis nutij pokon pa ruk'a' ri yabil rubini'an epilepsia, y juis mul c'a tzaknük pa k'ak' y pa tak ya'. ");
INSERT INTO cakENT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xinc'ün-pe c'a richin xinya' chiquivüch ri avachibila' richin nquic'achojrisaj ta rije', pero man nyetiquer tüj nquic'achojrisaj, xbij ri achi. ");
INSERT INTO cakENT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Y ri Jesús jari' xbij: Man jun vinük chupan ri tiempo re' ri ruyo'on ta ránima riq'uin ri Dios. Xa conojel ye satzinaki'. ¿Rix ninuc que yin chi jumul nquic'uje' iviq'uin? ¿Chi jumul nc'atzinej que nyixincoch'? Tic'ama' c'a pe ri ala' chere', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ri Jesús richin xuc'achojrisaj ri ala', xchapon chirij ri itzel espíritu richin que xrelesaj-e chiri' riq'uin ri ala'. Y ri ala' jari' xc'achoj. Xq'uis c'a e ri ruyabil chupan ri hora ri' roma xel-e ri itzel espíritu. ");
INSERT INTO cakENT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Y tok ri Jesús y ri rachibila' quiyon chic c'a yec'o, xepu'u ri achibila' xquic'utuj chin ri Jesús: ¿Achique c'a roma roj man xojtiquer tüj xkelesaj-e ri itzel espíritu? xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Y ri Jesús xbij cheque: Man xixtiquer tüj xivelesaj roma man iyo'on tüj ivánima jabel riq'uin ri Dios. Y ketzij vi c'a ri ninbij chive: Xa riq'uin ta ba' niya' ivánima riq'uin ri Dios, stape' (aunque) ta cachi'el jun vit ija' richin mostaza, xa riq'uin ri', si rix nibij chin ri jun juyu' re' que tel-e chere' y tic'o cala', nc'o-vi. Man jun c'a ri man ta nyixtiquer nibün, riq'uin niya' ba' ivánima riq'uin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jac'a ri jun ruvüch espíritu re' ntel, pero si rix nibün que man nyixva' tüj richin nibün orar, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Y tok ri Jesús y ri rachibila' yec'o chic c'a pa Galilea, xpu'u ri Jesús xbij c'a chic cheque ri rachibila': Yin ri xinalüx chi'icojol, nquijach-vi pa quik'a' ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nquicamsüs-vi c'a, pero pa rox k'ij nquic'astüj-pe chiquicojol ri caminaki'. Y tok ri rachibila' xcac'axaj ri xbij ri Jesús, juis c'a xebison. ");
INSERT INTO cakENT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Y ja tok ri Jesús y ri rachibila' xe'apon pa tinamit Capernaum, ri nyemolon ruchi' ri tumin richin pa racho ri Dios, ri nc'atzinej que nquitoj conojel ri achi'a', xe'apon c'a chuka' riq'uin ri Pedro y xquic'utuj chin: ¿Ri i-Maestro rix man nuya' tüj ri tumin richin pa racho ri Dios? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Y ri Pedro xbij: Ja', nuya'. Y tok ri Pedro xapon pa jay, nabey ri Jesús xbech'o-pe y xbij chin: Simón Pedro ¿achique na c'a ri nanuc rat? ¿Ri nimak' tak autoridades chuvüch ri ruch'ulef, achique c'a chok chin nquic'utuj-vi ri alcaval y ri impuestos? ¿Cheque ri quivinak rije' o xa cheque ri ch'aka chic ri xa man ye quivinak tüj? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Y ri Pedro xbij c'a chin ri Jesús: Ri nimak' tak autoridades xa cheque ri man ye quivinak tüj nquic'utuj-vi alcaval y ri impuestos, xbij. Y ri Jesús jari' xbij: Yin c'a ri' man nintoj tüj ri alcaval y ri impuestos, roma ja yin ri Alc'ual. ");
INSERT INTO cakENT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero si xa man nkatoj tüj, riq'uin ba' man nk'ax ta cheque achique roma tok man nkatoj tüj. Xa cabiyin c'a ka pa ya' chutz'amic cür. Y ri nabey ri natz'om, tajaka' c'a pa ruchi' y chiri' navil ri tumin ri nc'atzin richin naya' can cheque ri moloy-tumin richin pa racho ri Dios. Ri tumin c'a ri' nbün c'a richin naya' can ri avichin rat y ri vichin yin, xbij ri Jesús chin ri Pedro. ");
INSERT INTO cakENT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Y jari' tok ri achibila' xejel-apu riq'uin ri Jesús, y xquic'utuj c'a chin: Tok ja chic ri Dios ri Jun ri nbün mandar pa kavi', ¿achique c'a ri más nim ruk'ij nc'uje' cheke roj? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Y ri Jesús jari' tok xroyoj jun vit ac'ual y xuya' chiri' pa quinic'ajal. ");
INSERT INTO cakENT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","C'ateri' rija' xbij cheque ri rachibila': Ketzij c'a ninbij chive, si rix man nijül tüj ri inojibül, si man nyixoc tüj cachi'el jun vit ac'ual, man nyixoc tüj pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Xaxe c'a ri nuch'utinirsaj-ri' cachi'el ri jun vit ac'ual re', jari' ri más nim ruk'ij nc'uje' chiquicojol ri yec'o pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ri yacayon vichin yin pa ránima y riq'uin quicot nuc'ul jun ac'ual, jun ri cachi'el re', man xe tüj nuc'ul ri ac'ual, xa nquiruc'ul yin chuka'. ");
INSERT INTO cakENT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Si c'o ta jun co'ol ri nquitaken y npu'u ta jun vinük y nbün chin ri jun co'ol ri' que ntzak pa mac, man utz tüj ri nbün. Romari' ri vinük ri nunucun que nbün ri itzel ri', más ta utz chin rija' que ximox ta jun nimalüj abüj chin que'en chukul y nyetorix can pa jun nimalüj ya' ri juis nim rupan. ");
INSERT INTO cakENT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","C'ayuf quibanun ri vinük yec'o chuvüch ri ruch'ulef roma yec'o ri nyebanun cheque que nyemacun. C'o-vi c'a que quiri' nc'ulachitüj chuvüch ri ruch'ulef. Pero ri c'uluman que juis juya' ruvüch ja ri vinük ri nbanun chin jun chic que nmacun. ");
INSERT INTO cakENT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Xa roma c'a ri' si jun ak'a' o jun avakün ri nbanun chave que ncamacun, xa man tabün chic quiri'. Tabana' chin cachi'el nachoy y natorij-e. Roma más utz que xaxe jun ak'a' o jun avakün c'o y ncatoc chupan ri c'aslen ri man nq'uis tüj, que chuvüch ta ca'i' ak'a' y ca'i' avakün c'o y xa que tz'aküt ncabetorix can chupan ri k'ak' ri man jun bey nchup. ");
INSERT INTO cakENT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Y chuka' si xa jun cheque ri runak'-avüch nbanun chave que ncamacun, xa man tabün chic quiri'. Tabana' chin cachi'el navelesaj y natorij-e. Roma más utz que xaxe jun runak'-avüch c'o y ncatoc chupan ri c'aslen ri man nq'uis tüj, que chuvüch ta ca'i' runak'-avüch c'o y xa que tz'aküt ncabetorix can chupan ri k'ak'. ");
INSERT INTO cakENT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Man c'a que'ivetzelaj ri vinük ri man jun oc quik'ij, roma rije' ye chajin coma ángeles. Y yin ninbij c'a chive que ri chajinela' quichin rije' chi jumul c'a nyetiquer nye'apon chila' chicaj riq'uin ri Nata'. ");
INSERT INTO cakENT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Y yin ri xinalüx chi'icojol, xinpu'u-vi c'a chiquicanoxic y chiquicolic ri yec'o pa mac. ");
INSERT INTO cakENT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Quixnucun c'a jabel roma ri ninbij chive. Si jun achi yec'o ta jun ciento ru-ovejas y nsatz ta can jun tok nyeberuyuk'uj, ¿man nyeruya' tüj can ba' ri ch'aka chic ru-ovejas, y nbe pa tak juyu' chucanoxic ri jun ri satznük can? ");
INSERT INTO cakENT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y stape' (aunque) ri achi ri' c'a yec'o na ri ch'aka chic ru-ovejas ri man xesatz tüj, yin ninbij que rija' más c'a nquicot ránima riq'uin ri jun ru-oveja ri satznük can, si nyerila-pe. ");
INSERT INTO cakENT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Quiri' c'a chuka' nbanatüj riq'uin ri aj-chicaj Itata', man rurayibül tüj c'a rija' que nsatz ta can jun vinük chupan ri mac, stape' (aunque) ta ri vinük ri' man jun oc ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Si c'o c'a jun a-hermano c'o itzel ri nbün chave, cabiyin riq'uin y pa ruyon tabij c'a chin. Y si ri a-hermano ri' nrac'axaj ri nabij chin, xach'acon-vi c'a ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jac'a si xa man ncarac'axaj tüj, que'ac'uaj c'a jun o ye ca'i' chic, richin que chiquivüch rije' tok nabij chin ri a-hermano que man utz tüj rubanun. Richin quiri' rix ca'i' o rix oxi' c'a ri rixc'o tok nbanatüj ronojel ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Y si ri a-hermano man nrac'axaj tüj riq'uin ri xibij rix chin, c'ateri' rat ri rubanun ri itzel chave tabij cheque conojel ri hermanos nquimol-qui'. Y tok bin chic chin coma ri hermanos y man riq'uin tüj ri' man nutakej tüj tzij, richin tuna' que man utz tüj ri xbün, tibana' c'a chin que man ivachibil tüj chic. ");
INSERT INTO cakENT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Y ketzij vi c'a que yin ninya' can vuchuk'a' pan ik'a'. Y romari' utz vi c'a ntz'et chila' chicaj, tok rix nitz'apij o nijük jun bey chiquivüch ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Chuka' ninbij chive: Si chuvüch ri ruch'ulef yec'o ye ca'i' hermanos ri junan quivüch chin que nquic'utuj achique na chin ri Dios, ri Nata' Dios ri c'o chila' chicaj nbün c'a ri nc'utux chin coma ri ye ca'i' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Roma ape' na c'a ri quimolon-qui' ca'i' o ye oxi', si pa nubi' yin quimolon-vi-qui', yinc'o c'a pa quinic'ajal, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Y jari' tok xjel-apu ri Pedro riq'uin ri Jesús y xbij chin: Ajaf, si jun nu-hermano chi jumul nbün itzel chuve, ¿Jaru' c'a mul c'uluman que nincuy rumac? ¿Jun siete mul c'uluman que nincuy rumac? xbij ri Pedro chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jac'a ri Jesús xbij chin ri Pedro: Yin man ninbij tüj c'a chave que siete mul ri c'uluman que nacuy rumac jun a-hermano ri c'o itzel nbün chave. Yin ninbij c'a chave que ri rumac ri a-hermano c'uluman que nacuy setenta mul siete. ");
INSERT INTO cakENT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Roma chupan ri aj-chicaj gobierno, nbanatüj c'a cachi'el ri xbanatüj roma jun rey. Ri rey re' xrajo' c'a nuchojmirsaj jaru' quic'as chiquijujunal ri rusamajela'. ");
INSERT INTO cakENT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Y tok ri rey ri' xutz'om c'a ruchojmirsasic, c'o c'a jun rusamajel xbepabüx chuvüch y ri samajel re' colope' c'o jun lajuj millón quetzales ruc'as. ");
INSERT INTO cakENT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Roma c'a ri samajel ri' man ntiquer tüj nutoj ri ruc'as ri rubanun, ri rey xbij c'a que tic'ayix ri rusamajel rachibilan ri rixjayil y ri ye calc'ual. Y chuka' quec'ayix ri ru-cosas richin ri cajil ntajox chuvüch ri c'as. ");
INSERT INTO cakENT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jari' tok ri samajel xxuque-ka c'a pan ulef chuvüch ri rey, y juis c'a nuc'utuj favor chin. Ri samajel nubila' c'a chin ri rey: Tabana' favor quinavoyobej chic ba' más. Yin nintoj c'a chave ronojel ri nuc'as, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Y ri rey ri rajaf ri samajel ri', juis vi c'a xujoyovaj ruvüch ri rusamajel juis q'uiy ruc'as, romari' xucuy ri ruc'as y man jun xbün chin. ");
INSERT INTO cakENT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Jac'a tok colotajnük chic e ri samajel ri', xberuc'ulu' c'a pe jun chic samajel ri banayun jun kajo'n riq'uin. Ri kajo'n c'a ri rubanun ri jun rachibil ri', man cachi'el tüj c'a ri ruc'as rija', xa colope' jun cien quetzales. Man riq'uin tüj ri', rija' xutz'om chukul y nutz'apij yan c'a ruxla', y nbij c'a chin: Tatojo-pe ri c'as abanun viq'uin, nbij c'a chin. ");
INSERT INTO cakENT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Y ri rachibil pa samaj jari' xxuque-ka chuvüch, y juis c'a nuc'utuj favor chin. Nbij c'a: Quinavoyobej chic c'a ba' y yin nintoj ronojel chave, xbij. ");
INSERT INTO cakENT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jac'a ri achi samajel achique chok q'uin banun-vi ri c'as, man xka' tüj chin ri xbix chin y romari' xbe pa juzgado y xberuya' can pa cárcel, richin que tutz'eta' c'a achique rubanic nbün richin nutoj can ri ruc'as, richin ncolotüj-pe. ");
INSERT INTO cakENT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Y ri ch'aka chic cachibil pa samaj tok xquitz'et ronojel ri xbanatüj, xpu'u-vi c'a bis pa cánima. Y rije' xebe c'a riq'uin ri rey ri cajaf y xbequitzijoj c'a ronojel ri xbün ri jun samajel riq'uin ri jun chic. ");
INSERT INTO cakENT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Y ri rey, ri cajaf, jari' xutük royoxic ri samajel ri man utz tüj xbün, y xbij c'a chin: Rat, xa rat jun itzel nusamajel. Yin xincuy ronojel ri nimalüj ac'as, roma quiri' ri c'utunic xabün chuve. ");
INSERT INTO cakENT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Man ja tüj comi ri' ri c'uluman que xabün ta rat chuka' riq'uin ri avachibil pa samaj, cachi'el ri xinbün yin aviq'uin que xinjoyovaj avüch? ");
INSERT INTO cakENT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Y jari' ri rey ri cajaf ri samajela', roma xcatüj royoval xujüch c'a e ri itzel rusamajel pa quik'a' ri achi'a' ri nyebetz'apin can pa cárcel, y chiri' nban chin que nuc'usaj pokonül tok c'a ntojtüj can ronojel ri ruc'as. ");
INSERT INTO cakENT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Quiri' c'a nbün ri Nata' Dios ri c'o chila' chicaj iviq'uin rix, si man riq'uin tüj ronojel ivánima nicuy quimac ri i-hermanos tok c'o itzel nquibün chive, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Y tok ri Jesús xtane' chubixic ri tzij ri', xbe c'a ye rachibilan ri rachibila', xuya' can c'a ri lugar ri', ri rubini'an Galilea. Rija' xbe c'a cala' pa ruch'ulef Judea, y xc'o c'a lojc'an chin ri rakün-ya' rubini'an Jordán. ");
INSERT INTO cakENT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Rija' juis c'a ye q'uiy vinük ri xetzekleben richin chiri', y yec'o c'a chuka' ri xeruc'achojrisaj. ");
INSERT INTO cakENT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Y jari' tok yec'o achi'a' fariseos ri xe'apon riq'uin, richin que nquiya' ta pa c'ayuf ri Jesús y ntzak ta pa quik'a'. Y romari' xquic'utuj c'a chin: ¿Jun achi c'uluman nujüch-ri' riq'uin ri rixjayil roma achique na ri nquic'ulachij? Quiri' ri xquic'utuj rije'. ");
INSERT INTO cakENT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pero ri Jesús xbij c'a cheque ri achi'a' ri': ¿Man itz'eton tüj c'a rix chupan ri rutzij ri Dios ri nbij-vi que ri Dios ja pa rutz'uquic pe tok pa c'ulaj xerubün y man ruyon tüj jun? Man ruyon tüj c'a ri achi, y chuka' man ruyon tüj ri ixok. ");
INSERT INTO cakENT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","¿Chuka' man itz'eton tüj ri tzij ri nbin que romari' ri achi man quiq'uin tüj chic rute-rutata' nc'uje-vi? Xa riq'uin c'a ri rixjayil nc'uje-vi, y chi ca'i' xa jun c'a nquibün. Quiri' nbij ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Y romari' tok quic'uan chic qui', man chic ye ca'i' ta c'a vinük, man quiri' tüj, xa jun chic c'a ri quibanun. Roma c'a ri' ri ye tunun chic roma ri Dios, man tubün ri vinük que nyeruch'ür, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Y ri achi'a' fariseos xquic'utuj c'a chin ri Jesús: Si man c'uluman tüj que quiri' nban, ¿achique c'a roma tok ri Moisés xbij que jun achi, xaxe tubana' jun vuj richin jachojri'il chin ri rixjayil y tuya' can? ");
INSERT INTO cakENT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Y ri Jesús xbij c'a cheque ri achi'a' ri': Cachi'el c'a covirnük ri ivánima rix chupan ri man utz tüj, quiri' c'a chuka' xc'ulachitüj ojer can, pa ru-tiempo ri Moisés. Xa romari' tok rija' xuya' k'ij que utz nban ri jachojri'il riq'uin ri rixjaylonel. Y stape' (aunque) pa rutz'uquic pe, man quiri' tüj xbanatüj. ");
INSERT INTO cakENT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yin ninbij-vi c'a chive que achique na achi ri nujüch-ri' riq'uin ri rixjayil y xa man roma tüj ri ixok nucanoj jun chic achi, si ri achi ri' nuc'ün-pe jun chic ixok, ri achi ri' nmacun chuvüch ri Dios. Y si c'o c'a jun achi ri nuc'uan chin ri ixok ri jachon can roma ri rachijil, chuka' ri achi ri' nmacun chuvüch ri Dios, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Y ri achibila' xquibij c'a chin ri Jesús: Si jun achi chijumul ximil riq'uin ri rixjayil, más ta utz chin ri achi que man ta c'o rixjayil, xquibij rije'. ");
INSERT INTO cakENT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Y ri Jesús jari' tok xbij cheque ri rachibila': Man conojel tüj c'a ri jabel ta ruc'ulic nquibün chin ri tzij ri xinbij, roma man cheque tüj conojel yo'on-vi k'ij que quiri' ta nquibün can y man ta nyec'ule'. ");
INSERT INTO cakENT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Y yec'o na vi achi'a' pa calaxic pe riq'uin ri quite' tok xk'alajin yan que man nquicanoj tüj ixok. Yec'o chuka' achi'a' ri ye quiri', pero xa roma ri banun cheque coma ri ak'omanela'. Y yec'o chuka' achi'a' ri ye quiri', pero xa quiq'uin rije' xpu'u-vi que man nquicanoj tüj ixok, richin que nyesamüj jabel pa rusamaj ri Dios y nyequito' ri nye'oc pa ruk'a' ri Dios. Ri jun c'a ri nuna' que ntiquer nbün que man nc'ule' tüj, man c'a tic'ule', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Y yec'o c'a ac'uala' ri xe'uc'u'üx-apu chuvüch ri Jesús, richin que rija' tuya' ruk'a' pa quivi' y tuc'utuj chuka' ri ru-favor ri Dios pa quivi' ri ac'uala' ri'. Pero ri rachibila' xa xquibij cheque ri vinük que man tiquibün quiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero ri Jesús xa xbij c'a cheque ri rachibila': Tiya' k'ij richin que ri ac'uala' nyepu'u c'a viq'uin yin, y man que'ik'üt. Roma ri nye'oc pa ruk'a' ri Dios, xaxe ri ye cachi'el ri ac'uala'. ");
INSERT INTO cakENT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Y tok ri Jesús ruc'utun chic c'a ri utzilüj sipanic ri nspaj-pe ri Dios y xuyala' can ruk'a' pa quivi' ri ac'uala', rija' xbe, xuya' c'a can ri lugar ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Y c'o c'a jun ri xapon riq'uin ri Jesús y xbij: Rat ri utzilüj Maestro tabij c'a chuve: ¿Achique c'a chi utz ri c'uluman ta que ninbün yin richin quiri' nc'uje' ta nuc'aslen ri man nq'uis tüj? xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Y ri Jesús xbij chin: ¿Achique c'a roma tok nabij utz chuve yin? Roma man jun vinük ri utz ta, xaxe c'a Jun ri utz y ri' ja ri Dios. Si rat najo' c'a ncatapon chupan ri c'aslen ri man nq'uis tüj, que'atakej c'a ri mandamientos, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Y xpu'u ri ala' ri apon chic riq'uin ri Jesús xuc'utuj c'a: ¿Achique chi mandamientos ri'? xbij. Y ri Jesús xbij chin: Ri mandamiento ri' ja ri man cacamsan. Rat achi ri c'o avixjayil man tacanoj jun chic ixok, man catelek', man tatz'uc tzij chirij jun chic vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Chuka' taya' quik'ij ri ate-atata'. Y cachi'el najo-ka-avi' rat, quiri' c'a chuka' que'ajo' ri ch'aka chic. Ja mandamiento ri', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Y ri ala' xbij c'a chin ri Jesús: Yin c'a co'ol tok nubanun-pe ronojel ri'. ¿Achique ta c'a ri ch'aka chic ri man nubanun tüj? xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Y ri Jesús xbij c'a chin: Richin natz'akatisaj c'a rubanic ronojel, xaxe chic c'a jun ri man abanun tüj. Man atalun tüj ri abeyomal chiquivüch ri vinük ri manak quichajin. Que'ac'ayij c'a can ri achajin y ri rajil tataluj chiquivüch ri vinük ri manak quichajin, richin quiri' nc'uje' abeyomal chila' chicaj. Y catampe c'a viq'uin y quinatzeklebej, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tok ri ala' xrac'axaj c'a ri tzij ri xbij ri Jesús, nbison ránima xtzolij-e, roma juis ri beyomül ri ruchajin y man nrajo' tüj ntel-e pa ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jari' tok ri Jesús xbij cheque ri rachibila': Vocomi ninbij-vi c'a chive que ketzij vi que juis c'ayuf que jun ri juis beyomül c'o riq'uin ntoc ta pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Xa más man c'ayuf tüj que nc'o ri jun chico rubini'an camello chupan ri vit jul c'o chirachük jun bak, que chuvüch jun beyon ntoc ta pa ruk'a' ri Dios, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Y tok ri rachibila' ri Jesús xcac'axaj ri tzij ri', xe' xquica'yej. Y nquibila' c'a chiquivüch: Si cachi'el ri nbij, quiri', man jun ncolotüj, nquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ri Jesús xerutz'et-apu ri rachibila' y xbij cheque: Man tinuc quiri'. Ri vinük man nyetiquer tüj nquicol-qui', jac'a ri Dios ronojel ntiquer nbün, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Y jari' tok ri Pedro xbij c'a chin ri Jesús: Rat avetaman que roj kayo'on can ronojel ri kachajin, richin quiri' rat katzekleben. ¿Y achique c'a ri nkac'ul roj romari'? ");
INSERT INTO cakENT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ri Jesús xbij c'a: Ketzij c'a ninbij chive que tok napon ri tiempo tok ronojel c'ac'a' chic rubanic, yin ri xinalüx chi'icojol c'o chic c'a nuk'ij y nquitz'uye' pa jun ch'acüt richin ninbün juzgar. Y jari' chuka' tok rix ri xixtzekleben vichin, nyixtz'uye' pa doce ch'acüt richin nibün juzgar pa quivi' ri doce tak tinamit rubanun ri nimalüj tinamit Israel. ");
INSERT INTO cakENT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y achique na vinük ri voma c'a yin ruyo'on can racho, runimal o ruchak' ye alabo' y xtani', rute-rutata', rixjayil, ralc'ual o rulef, q'uiy c'a ri nuc'ul, pa ciento mul c'a más q'uiy ri nuc'ul. Y nrichinaj chuka' ruc'aslen ri man nq'uis tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Y ye q'uiy c'a ri juis quik'ij vocomi, napon ri k'ij tok manak chic quik'ij nc'uje'. Y ye q'uiy ri xa manak quik'ij ri vocomi, napon ri k'ij tok nc'uje' vi quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ri nbün jun achi ri tata'aj pa jun jay que xel-e ri cumaj yan chiquicanoxic samajela', richin nyerutük pa rulef ri ruticon uva chuvüch, junan c'a riq'uin tok ri vinük nye'oc pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tok ri achi ri' xeril c'a ri rusamajela' y ch'ovinük chic quiq'uin que nuya-vi jun tumin cheque, ri rajil jun k'ij rusamaj jun samajel, c'ateri' c'a xerutük chusamajisic ri rulef ri ruticon ruvüch riq'uin uva. ");
INSERT INTO cakENT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Colope' pa las nueve ri saker yan ri', rija' xel chic e jun bey y xerutz'et c'a chiri' pa c'ayibül que yec'o samajela' ri man quilon tüj quisamaj. ");
INSERT INTO cakENT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Rija' xapon quiq'uin y xch'o cheque. Rija' xbij c'a cheque: ¿Nijo' isamaj? Roma si nijo', quixbiyin c'a chuka' rix quixbesamüj pa vulef nuticon uva chuvüch, y yin ninya' c'a chive ri c'uluman que nich'üc, xbij cheque. Y ri samajela' ri' xebe na vi pa samaj. ");
INSERT INTO cakENT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ri tata'aj c'a ri rajaf ri ulef, quiri' c'a chuka' ri xbanala' quiq'uin ri ch'aka chic samajela' ri xeril tok xel-e pa nic'aj-k'ij y pa las tres ri xkak'ij. Rija' xerutük c'a ri samajela' pa rusamaj y xbij cheque que nuya-vi c'a cheque ri c'uluman que nquich'üc. ");
INSERT INTO cakENT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Y pa las cinco ri xkak'ij rija' xel-e jun bey chic y xeberila' c'a pe ch'aka chic samajela'. Y rija' xbij c'a cheque ri samajela' ri': ¿Achique c'a roma tok man ivilon tüj e isamaj y que jun k'ij ri rixc'o chere'? xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Y ri samajela' ri' xquibij c'a: Man jun xyo'on kasamaj, xquibij. Y ri tata'aj rajaf ri ulef xbij c'a cheque ri samajela' ri': Quixbesamüj c'a chuka' rix pa vulef ri nuticon uva chuvüch y ninya' c'a chive ri jaru' c'uluman que nich'üc, xbij cheque. Y ri samajela' ri' xebe na vi pa samaj. ");
INSERT INTO cakENT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ja tok xka-ka ri k'ij, xpu'u ri rajaf ri ulef tiquil uva chuvüch, xbij c'a chin ri uc'uey quichin ri rusamajela': Que'avoyoj-pe conojel ri samajela' y que'atojo-e. Nabey c'a nye'avoyoj-pe ri samajela' xeka-pe pa ruq'uisbül, y ja ri samajela' ri xeka-pe pa nabey jari' ri nyeruq'uisibej can, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tok ri samajela' ri xe'oc pa samaj pa las cinco ri xkak'ij, xe'apon richin nyequic'ulu-pe ri cajil, jun tumin rajil jun k'ij rusamaj jun samajel c'a ri xquic'ulula-pe, roma quiri' ri rurayibül ri rajaf ri ulef, que nuya' cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Y tok xe'apon c'a ri samajela' ri xe'oc pa samaj nabey, richin nyequic'ulu-pe ri cajil, xquinuc que rije' más q'uiy cajil nquic'ul chiquivüch ri ch'aka chic ri xa man jun k'ij tüj ri xesamüj. Jac'a tok xquic'ul ri cajil, c'ateri' c'a xquitz'et que rije' chuka' xa ri mismo jun tumin ri cajil xquic'ul. ");
INSERT INTO cakENT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tok ri samajela' ri' xquic'ul ri cajil y xquitz'et que junan ri xquic'ul quiq'uin ri ch'aka, xquich'ojij c'a ri cajil. ");
INSERT INTO cakENT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ri samajela' ri' nquibij c'a: Ri ruq'uisbül tak samajela' ri xe'oc pa samaj, ri xa jun hora oc xesamüj, junan xabün cheque kiq'uin roj, tok roj jun k'ij ri xojsamüj y xojc'uje' chuka' chuxe' ri ruk'ak'al ri k'ij, nquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Y ri tata'aj rajaf ri samaj xbij c'a chin jun cheque ri samajela' ri': Riq'uin ri junan xentoj ri ch'aka chic samajela' man jun itzel xinbün chave rat. Roma aviq'uin rat xa roj canajnük c'a can que jun tumin chin rajil jun rusamaj jun samajel ri ninya' chave. ¿Nka-pe chi'ac'u'x? ");
INSERT INTO cakENT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Vocomi rat xaxe c'a tac'uaj la avajil y utz ncabe. Y ja cheque ri samajela' ri c'a pa ruq'uisbül xe'oc pa samaj, pa vánima c'a yin xpu'u-vi tok xinya-e ri cajil cachi'el ri avajil rat. ");
INSERT INTO cakENT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Roma ronojel ri c'o viq'uin yin, pa nuk'a' c'a yin c'o-vi richin ninbün achique ri ninjo' ninbün riq'uin. ¿O rat xa itzel nana' chuve tok yin xa ja ri utz ninbün? xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ri ejemplo re' nuk'alajrisaj c'a achique rubanic ri tzij: Ye q'uiy c'a ri juis quik'ij vocomi, napon c'a jun k'ij tok manak chic quik'ij nc'uje'. Y ye q'uiy ri xa manak quik'ij ri vocomi, napon jun k'ij tok nc'uje' quik'ij. Y stape' (aunque) ye q'uiy ri nye'oyox, man conojel tüj c'a ri nyecha'tüj richin nc'uje' quik'ij. Quiri' xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ri Jesús y ri doce rachibila' y ri ch'aka chic vinük ye benük quiq'uin, quitz'amon-e ri bey nbe pa tinamit Jerusalén. Y jari' tok ri Jesús xeruch'ür-e ba' ri rachibila' roma c'o c'a ri nrajo' nbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Rija' xbij c'a: Rix ivetaman que pa tinamit Jerusalén katz'amon-vi-e bey, y ja chiri' ape' nquijach-vi-e yin ri xinalüx chi'icojol. Nquijach-e pa quik'a' ri más nimalüj tak sacerdotes y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés. Y rije' nquibij c'a que tika-ka ri camic pa nuvi'. ");
INSERT INTO cakENT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Y chuka' yinquijüch-e pa quik'a' vinük ri xa man ye israelitas tüj. Y ri vinük man ye israelitas tüj yinquitze'ej, yinquich'ey y c'ateri' yinquibajij chuvüch ri cruz richin nquicom. Pero pa rox k'ij nquic'astüj-pe. ");
INSERT INTO cakENT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Y ri ye ca'i' rachibila' ri Jesús ri ye ruc'ajol ri achi rubini'an Zebedeo, xejel-apu riq'uin ri Jesús, cachibilan ri quite'. Y ri quite' xxuque' c'a ka chuvüch ri Jesús richin que nuc'utuj jun favor chin. ");
INSERT INTO cakENT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ri Jesús xbij c'a chin ri te'ej ri': ¿Achique c'a ri najo'? xbij chin. Y ri ixok xbij c'a chin ri Jesús: Yin ninjo' c'a que tok rat nabün mandar, tabana' c'a que ri ca'i' val re' nyetz'uye' ta apu aviq'uin, jun ta c'a pan avajquik'a' (pan a-derecha) y jun ta pan axocon (pan a-izquierda). Tabana' cheque que nc'uje' ta quik'ij, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Y jari' tok ri Jesús xbij: Rix man ivetaman tüj c'a que c'ayuf chive ri nic'utuj. Y romari' yin ninc'utuj c'a chive vocomi: ¿Nicoch' rix cachi'el ri nban chuve yin? ¿Y nicoch' chuka' rix jun pokonül cachi'el ri nka-ka-pe pa nuvi' yin?, xbij ri Jesús. Y ri ca'i' achibila' ri ye ral ri ixok xquibij c'a: Nkacoch', xquibij chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Y ri Jesús xbij chic c'a cheque: Ketzij vi c'a que rix nicoch' na vi cachi'el ri nban chuve yin. Chuka' nicoch' jun pokonül cachi'el ri nka-ka-pe pa nuvi' yin. Xa jac'a ri nibij, que rix nijo' que jun ntz'uye' pa vajquik'a' (pa nu-derecha) y jun pa nuxocon (pa nu-izquierda), ri' man pa nuk'a' tüj c'a yin c'o-vi richin que ninya' chive. Roma ri nic'utuj rix, ri' xa quichin chic c'a ri nbij ri Nata' que utz que nyetz'uye' chiri', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Y ja tok ri lajuj (diez) chic rachibila' xcac'axaj ri xbitüj, xpu'u c'a coyoval cheque ri ye ca'i' achibila' ri quich'ak-qui'. ");
INSERT INTO cakENT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jari' tok ri Jesús xeroyoj ri rachibila' y xbij c'a cheque: Yin ninbij que rix jabel ivetaman que chere' chuvüch ri ruch'ulef ri tak achi'a' ri nquibün mandar, roma yec'o c'a ri vinük pa quik'a', romari' nquina' que ja rije' ri ye cajaf. Xaxe c'a ri c'o quik'ij ri nyebin ri nc'atzinej que nban. ");
INSERT INTO cakENT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Jac'a chi'icojol rix man quiri' tüj. Roma ri nrajo' c'a nc'uje' ruk'ij chive rix, nc'atzin que nuna-ka-ri' que xa manak ruk'ij y tuch'utinirsaj-ri' richin nusuj-ri' chubanic achique na samaj. ");
INSERT INTO cakENT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Si jun c'a chive rix nrajo' que ja rija' ri nabey y c'o ta ruk'ij, tuna' c'a ri' que xa manak ruk'ij y tuch'utinirsaj-ri' richin que nusuj-ri' chubanic achique na samaj. ");
INSERT INTO cakENT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nc'atzinej c'a que nbün cachi'el ri ninbün yin, ri xinalüx chi'icojol. Yin man ninpokonaj tüj nquisamüj coma ri ch'aka, roma richin ri' tok xinpu'u, y man nquipu'u tüj c'a richin que yec'o ch'aka chic nyebanun-pe ri ninbij cheque. Ja yin ri nquibanun ri samaj, y ja yin ri nquiyo'on ri nuc'aslen richin quiri' ye q'uiy ri nyecolotüj, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ri Jesús y ri rachibila' jari' tok nquiya' can ri tinamit rubini'an Jericó, y ye juis c'a ye q'uiy vinük ri ye tzekleben-e. ");
INSERT INTO cakENT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jari' tok ye ca'i' moyi' ye tz'uyul chuchi' ri bey xcac'axaj c'a que ri Jesús jari' ri nc'o-e quiri', y rije' riq'uin cuchuk'a' xech'o y xquibij c'a: Rat Ajaf, ri rat ruxquin-rumam can ri rey David, tajoyovaj c'a kavüch roma ri kabanun, xquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Y ri vinük xquich'olij c'a cheque que man quech'o chic. Pero rije' xa riq'uin más cuchuk'a' xech'o y xquibij: Rat Ajaf, ri rat ruxquin-rumam can ri rey David, tajoyovaj c'a kavüch roma ri kabanun, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Y ri Jesús xrac'axaj c'a ri quitzij. Romari' xpa'e-ka y xeroyoj. Y c'ateri' xbij c'a: ¿Achique c'a nijo'? xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Rije' xquibij c'a chin ri Jesús: Ajaf, roj nkajo' c'a nkutzu'un, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ri Jesús roma c'a juis xujoyovaj quivüch ri ca'i' achi'a' moyi' ri', jari' tok xutz'om ri runak' tak quivüch, y rije' xetzu'un c'a. Y rije' xetzeke-e chuka' chirij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Y ri Jesús, ri rachibila' y ri ch'aka chic vinük ye benük chirij, nakaj chic c'a yec'o-vi-apu chin ri tinamit Jerusalén. Chiri' chic c'a pa tinamit Betfagé yec'o-vi, ri c'o-apu chuvüch ri juyu' rubini'an Olivos. Y xpu'u c'a ri Jesús xerutük c'a e ye ca'i' rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Rija' xbij c'a e cheque: Quixbiyin-apu chupan la vit tinamit la nitz'et-apu chila', y ja yan ri nyixoc-apu, jari' nivil jun alaj burro c'o chiri' riq'uin ri rute'. Tisolo-pe ri te'ej y que'ic'ama-pe chi ca'i' chuve. ");
INSERT INTO cakENT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Y si c'o c'a ri nbin-pe chive achique nc'atzin-vi que nye'ic'ün-pe, tibij c'a chin: Nc'atzin chin ri Ajaf, pero chanin nyeberujacha' chic can, tibij can, xbix-e cheque roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nbanatüj na vi c'a cachi'el ri tz'iban can roma ri jun ri xk'alajrisan ri rutzij ri Dios ojer can. Ri rutz'iban c'a can rija', nbij: ");
INSERT INTO cakENT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tiya' c'a rutzijol cheque ri ye richin chic ri tinamit rubini'an Sión, que ri qui-rey jare' petenük. Ri qui-rey nuch'utinirsaj vi c'a ránima. Y rija' tz'uyul-pe chirij jun burro. Chirij vi c'a jun alaj burro tz'uyul-vi-pe rija'. Ri alaj burro ral c'a jun samajel chico. Quiri' c'a ri tz'iban can. ");
INSERT INTO cakENT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Y ri ca'i' achibila' xebe c'a, y xquibün-vi ri bin-e cheque roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xquic'ün c'a pe ri alaj burro rachibilan ri rute', chin ri Jesús. C'ateri' ri achibila' xquirip-e ri quitziek ri cachi'el coton chiquij ri ca'i' chico ri', richin que ri Jesús ntz'uye' c'a e. ");
INSERT INTO cakENT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Y ri ye benük chirij ri Jesús juis vi ye q'uiy. Y jubama conojel cheque rije' ri xquiriq'uila' ri quitziek ri cachi'el coton pa rubey ri Jesús richin que nquiya' ruk'ij. Y ch'aka chic vinük richin que nquiya' chuka' ruk'ij ri Jesús xebequic'amala-pe ruk'a' tak che' richin nquivek, richin que nquiric' pa rubey. Y quiri' c'a nquibanala' ye benük. ");
INSERT INTO cakENT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Y ri vinük ri ye nabey chuvüch ri Jesús y ri yec'o can chirij, riq'uin c'a ronojel cuchuk'a' nquibij: ¡Matiox que petenük ri ruxquin-rumam can ri rey David! ¡Que ri Ajaf Dios nbün ta bendecir rija! ¡Petenük c'a pa rubi' ri Ajaf Dios! ¡Matiox chin ri Dios ri c'o chila' chicaj! nquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jac'a tok ri Jesús ntoc-apu pa tinamit Jerusalén, xepu'u c'a ri vinük y xquimol-qui' chanin chutz'etic ri Jesús. Y ri vinük ri' nquibila' c'a: ¿Achique c'a achi re'? nquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pero yec'o c'a ri xebin: Re' jare' ri Jesús, ri nk'alajrisan ri nbix chin roma ri Dios. Rija' aj pa tinamit Nazaret, tinamit ri c'o chiri' pa ruch'ulef Galilea, nquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Y ri Jesús xapon c'a pa racho ri Dios ri c'o pa tinamit Jerusalén. Y roma xutz'et que cachi'el c'ayibül quibanun ri vinük chin, xerokotaj c'a pe conojel, chi c'ayinel chi lok'onel. Y cheque ri jaloy-ruvüch tumin, xerutec'mayila' ri qui-mesas. Y quiri' chuka' xbün can cheque ri quich'acat ri c'ayinel palomas. ");
INSERT INTO cakENT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ri Jesús xbij c'a cheque ri vinük ri': Chupan ri rutzij ri Dios ri tz'iban can, nbij que ri vacho, jay richin oración. Jac'a rix xa cachi'el quijul elek'oma' ibanun chin, xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Y tok ri Jesús c'o c'a pa racho ri Dios, yec'o c'a vinük ye moyi' y yec'o chuka' ri man nyetiquer tüj nyebiyin roma ri ye jetz', ri xe'apon riq'uin rija', richin ta nyeruc'achojrisaj-e. Y rija' quiri' c'a ri xbün. Xeruc'achojrisaj-e. ");
INSERT INTO cakENT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jac'a ri más nimalüj tak sacerdotes y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés xpu'u coyoval, roma ri Jesús q'uiy milagros ri nyerubanala', y roma chuka' ri ac'uala' riq'uin c'a cuchuk'a' nquibila' chiri' chi racho ri Dios: ¡Matiox que xka-pe ri ruxquin-rumam can ri David! nquibij. Y jari' xyacon coyoval. ");
INSERT INTO cakENT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Xepu'u ri más nimalüj tak sacerdotes y ri achi'a' etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés, xquibij c'a chin ri Jesús: ¿Navac'axaj c'a ri nyetajin chubixic ri ac'uala'? xquibij. Y xpu'u ri Jesús xbij cheque ri achi'a' ri': Ja', ninvac'axaj. Y rix ¿man itz'eton tüj chupan ri rutzij ri Dios ri nbij-vi, que ri ketzij nyeyo'on ruk'ij ri Dios ja ri ac'uala' y ri c'a nyetz'uman vi? xbij ri Jesús cheque ri achi'a' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Y ri Jesús xeruya' c'a can chiri' ri achi'a' ri'. Rija' xel-e pa tinamit Jerusalén y xbe c'a pa tinamit Betania. Chiri' c'a xbe-vi richin xbe'uxlan can ri jun ak'a' ri', rachibilan ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Y cumaj ruca'n k'ij, tok quitz'amon bey richin nyetzolij pa tinamit Jerusalén, ri Jesús nnum rupan. ");
INSERT INTO cakENT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Y tok ye benük, rija' xutz'et c'a jun che' higuera xquil chunakaj ri bey. Xbe-apu chuxe' chucanoxic ruvüch, pero xa man jun vit ruvüch c'o, xa ruyon ruxak. Jari' tok ri Jesús xch'o chin ri che' y xbij c'a: Man jun bey chic c'a navachin. Y ri che' higuera ri' xchaki'j-vi-ka. ");
INSERT INTO cakENT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tok ri rachibila' ri Jesús xquitz'et que chaki'j chic ri che' higuera, xquibila' chiquivüch: ¡Chanin comi xchaki'j-ka ri higuera re'! nquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Xpu'u ri Jesús xbij c'a cheque: Ketzij ninbij chive: Si rix niyo'on ivánima y chuka' man npu'u tüj pan ivánima colope' xa man nbanatüj tüj re', nyixtiquer c'a nibün quere' chin jun che' higuera. Y c'o ta nojibül más nimak' ri nyixtiquer nibün, que chuvüch ri jun re'. Nyixtiquer ta nibij chin ri juyu' re' que tel-e chere' y tic'o chupan ri mar, y quiri' ta ri nbanatüj. ");
INSERT INTO cakENT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ronojel vi c'a ri nic'utuj chin ri Dios riq'uin ronojel ivánima, nic'ul-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Y tok ri Jesús c'o chic pa racho ri Dios y nuc'ut chic ri rutzij ri Dios chiquivüch ri vinük, ri más nimalüj tak sacerdotes y ri rajatük tak achi'a' ri juis quik'ij chiquicojol ri vinük, xe'apon-apu riq'uin y xquic'utuj c'a chin ri Jesús: ¿Achique xyo'on autoridad pan ak'a' richin xe'avokotaj-e ri vinük c'ayinela' pa racho ri Dios? ¿Y achique chuka' yoyon k'ij chave richin que q'uiy ri nye'abanala' chiquicojol ri vinük? xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Xpu'u ri Jesús xbij c'a cheque ri achi'a' ri': Yin c'o c'a chuka' jun ri ninjo' ninc'utuj chive, y riq'uin c'a nibij chuve re', yin chuka' ninbij chive achique yoyon autoridad pa nuk'a' richin nyenbanala' quere'. ");
INSERT INTO cakENT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Y jari' tok ri Jesús xuc'utuj c'a: ¿Ri Juan xtak-pe roma ri Dios richin xerubün bautizar ri vinük? ¿O xa vinük xebin chin que tubana' quiri'? xbij ri Jesús. Y ri más nimalüj tak sacerdotes y ri rajatük tak achi'a' ri c'o quik'ij xquibila' c'a chiquivüch: ¿Achique c'a nkabij chin ri Jesús vocomi? xquibij-ka. Roma si nkabij que ri Juan ja ri Dios ri takayon-pe richin, ri Jesús nbij c'a cheke que achique c'a roma tok man xitakej tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y si nkabij que xa vinük xebin chin ri Juan que tubana' quiri', c'ayuf cheke roj, roma ri vinük nyecatüj chikij. Roma conojel vinük quiniman-vi que ri Juan xuk'alajrisaj-vi ri xbix chin roma ri Dios, xquibij c'a ka chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Y xquibij-apu c'a chin ri Jesús: Roj man ketaman tüj, xquibij-apu. Y ri Jesús jari' chuka' xbij cheque ri achi'a' ri': Roma c'a rix man xixtiquer tüj xibij chuve, quiri' c'a chuka' yin man ninbij tüj chive achique yoyon k'ij chuve richin nyenbanala' quere', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","C'ateri' ri Jesús xbij chic c'a cheque ri más nimalüj tak sacerdotes y ri rajatük tak achi'a' ri c'o quik'ij: quixnucun-vi c'a jabel roma ri ninbij chive. C'o c'a jun achi yec'o ca'i' ruc'ajol. Y ri tata'aj re' xapon c'a riq'uin ri jun ruc'ajol nabey, y xbij chin: Vocomi, cabiyin pa samaj, ri ape' katicon-vi-ka uva, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Xpu'u ri c'ajol ri' xbij c'a chin ri rutata': Vocomi man ninjo' tüj nquibe pa samaj, xbij. Y c'ateri' xtzolij ruc'u'x y xbe c'a pa samaj. ");
INSERT INTO cakENT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Y ri tata'aj xapon c'a chuka' riq'uin ri jun chic ruc'ajol, y xbij chin que tibiyin pa samaj. Y ri c'ajol ri' xbij chin ri rutata': Nata', jare' nquibe, xbij. Pero ri c'ajol ri' xa man xbe tüj pa samaj. ");
INSERT INTO cakENT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Y c'ateri' ri Jesús xuc'utuj cheque ri más nimalüj tak sacerdotes y ri rajatük tak achi'a' ri juis quik'ij: ¿Achique cheque ri ca'i' ri xbanun ri rurayibül ri rutata'? xbij. Y ri achi'a' ri' xquibij c'a: Ri xbanun ri rurayibül ri rutata' ja ri nabey, xquibij. Y ri Jesús xbij c'a cheque ri más nimalüj tak sacerdotes y ri rajatük tak achi'a' ri juis quik'ij: Ketzij c'a ninbij chive que xa ja ri moloy tak alcaval y ri ixoki' ri man utz tüj c'aslen quic'uan, jari' ri nyec'o-e chivüch, roma nquitzolij-pe quic'u'x. Xa ja yan chic c'a rije' ri nabey nye'oc pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ri Juan Bautista tok xpu'u, jun chojmilüj bey c'a ri xuc'ut chivüch rix, jac'a rix man xitakej tüj. Xaxe c'a ri moloy tak alcaval y ri ixoki' ri man utz tüj quic'aslen, xaxe rije' ri xetaken. Jac'a rix, man riq'uin tüj ri' man xitzolij tüj pe ic'u'x riq'uin ri Dios y man xitakej tüj chuka'. ");
INSERT INTO cakENT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Y tivac'axaj na pe' jun chic ejemplo, xbij ri Jesús cheque ri vinük: Xc'uje' c'a jun achi ri rajaf jun ulef, xpu'u rija' xutic c'a ruvüch ri rulef riq'uin uva y xuc'ojoj rij ri rulef. Xbün chuka' cachi'el jun vit pila ri chupan ulef ri richin niyitz' ri uva, y jun chuka' tz'ak ri nüj jotol, y pari' ri' xc'uje-vi racho ri chajinel. C'ateri' xuya' can pa kajic cheque ca'i-oxi' samajela', y rija' xbe nüj. ");
INSERT INTO cakENT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Y ja tok xapon yan ri tiempo richin nban ri vuxuj-uva, ri rajaf ri ulef xutük nabey jun raj-ic' achi, c'ate ba' ri' jun chic. Y quiri' ye q'uiy ri rajic'a' ri xerutük richin ta que xbequic'ama-pe ri ruvüch ri uva ri xuya-ka ri ulef. ");
INSERT INTO cakENT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero ri achi'a' kajoy tak ulef, xa man xequic'ul tüj jabel ri achi'a' ajic'a', ri ye takon-e roma ri rajaf ri ulef. Xa yec'o xequich'ey, yec'o xequic'ük chi abüj y yec'o xequicamsaj. ");
INSERT INTO cakENT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Xpu'u ri rajaf ri ulef xerutakala-e c'a ch'aka chic achi'a' ri ye rajic'a'. Más c'a ye q'uiy vi ri xerutakala-e ri jun chic bey re'. Pero ri achi'a' kajoy tak ulef ja mismo ri xquibanala-pe cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Y pa ruq'uisbül, ri rajaf ri ulef xunuc y xbij c'a: Ri achi'a' kajoy-ulef nyetaken-vi c'a tok nquitz'et que ja ri nuc'ajol ri napon, xbij-ka rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero ri achi'a' ri ye kajayon ri ulef, xe xquitz'et que ja ri ruc'ajol ri rajaf ri ulef ri xapon, xquibila-ka c'a chiquivüch: Jare' ri nchinan ronojel ri ulef ri kakajon vocomi. ¿Achique roma man nkacamsaj tüj? Richin quiri' pa kak'a' roj nc'uje-vi ri ulef, xquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Y quiri' vi c'a xquibün. Xquitz'om y c'ateri' xquelesaj-pe ri c'ajol chiri' chupan ri rulef y xquicamsaj. ");
INSERT INTO cakENT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","C'ateri' ri Jesús xbij: Tok npu'u ri rajaf ri ulef ri xquil uva chuvüch, ¿achique nbün cheque ri achi'a' kajoy tak ulef, ninuc rix? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Y ri vinük xquibij c'a: Ri rajaf ri ulef man nujoyovaj tüj c'a quivüch ri itzel tak achi'a' kajoy-ulef y nyeruq'uis. Y c'ateri' ri rulef nuya' chic can pa kajic cheque ch'aka chic achi'a' kajoy tak ulef, ri nquiya-vi ri uva nuya' ri ulef tok napon ri tiempo, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Xpu'u ri Jesús xbij c'a cheque: ¿Man jun bey c'a itz'eton ri jun tzij tz'iban can chupan ri rutzij ri Dios? Ri tzij ri' nbij c'a: C'o c'a jun abüj ri man xka' tüj chiquivüch ri ch'aka banuy tak jay. Pero ri abüj re' xch'acon-vi, roma ri abüj re' xa c'o-vi ri xucusan chin ri jay richin que ri jay ri' man ntzak tüj. Ja vi ri Ajaf Dios xbanun re', y ri runak' tak kavüch man jun bey c'a quitz'eton que nbanatüj ta quere'. Quiri' nbij ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Y roma c'a ri ye banatajnük, rix man nyixc'uje' tüj chic pa ruk'a' ri Dios, ri nyec'uje' pa ruk'a' ri Dios xa ja ri ch'aka chic vinük ri nquic'uan jun utzilüj c'aslen y nyeq'uiy chupan ri rutzij ri Dios y romari' ye q'uiy ch'aka chic nyetaken ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ri vinük c'a ri ntzak chuvüch ri abüj ri xucusüs chin ri jay, nucraj-ri' chuvüch. Y ri vinük ri ntzak ri abüj ri' chirij, nuque'ej c'a, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Y tok ri más nimalüj tak sacerdotes y ri achi'a' fariseos cac'axan chic ka ri ejemplos ri xerutzijoj ri Jesús, xk'ax-vi cheque que chiquij rije' xch'o-vi-ka. ");
INSERT INTO cakENT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Y jari' tok rije' xcajo' c'a xquitz'om yan e ri Jesús. Pero man xquibün tüj roma xa nquixbij-qui' chiquivüch ri vinük, roma chiquivüch ri vinük, ri Jesús k'alajrisüy vi rutzij ri Dios y nbij chuka' cheque ri nyebanatüj ri más chiquivüch apu. ");
INSERT INTO cakENT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Y ri Jesús xutz'om chic c'a nch'o cheque ri vinük, y xerucusaj ch'aka chic ejemplos. Rija' xutz'om c'a rubixic: ");
INSERT INTO cakENT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Jun nimak'ij ri xbün jun rey chin ri ruc'ajol tok xc'ule', junan c'a riq'uin tok ri vinük nye'oc pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Y ri rey ri' yec'o chic vi ri rubin cheque que nye'apon chupan ri jun c'ulubic ri', y romari' xerutük c'a ri rusamajela' chicoyoxic ri vinük ri'. Jac'a ri xe'oyox man xcajo' tüj chic xebe. ");
INSERT INTO cakENT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Y ri rey xerutük-e ch'aka chic rusamajela' y xbij-e cheque: Tibij cheque conojel ri nuyo'on rutzijol cheque pari' ri jun nimak'ij re', que ronojel c'o chic richin nkabün ri va'in. Ri achij tak nuvacx y ri ch'aka chic chico ri xentiojrisaj richin nyec'atzin chupan ri k'ij re', xechojmirsüs yan y c'o chic richin nyec'ux. Ronojel c'a c'o chic, quixbij cheque. Que quepu'u c'a chupan ri jun c'ulubic re', xbij-e cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero ri xe'oyox, man xetaken tüj pe riq'uin ri xbebix jun bey chic cheque. Yec'o ri xa xebe pa tak quisamaj pa k'ayis, y yec'o xa xebe pa tak c'ayij. ");
INSERT INTO cakENT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jac'a ri ch'aka chic xequitz'om ri samajela' ye rutakon-e ri rey, y xequicamsaj, roma chiquivüch rije' ri samajela' ri' xa man jun quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ja tok xapon rutzijol riq'uin ri rey ri achique xbanatüj, jari' xbanun que rija' xcatüj royoval. Jari' tok rija' xerutük achi'a' ye banuy-oyoval chiquij richin que xeruq'uis c'a ri ye camsanela' quiq'uin ri rusamajel rija', y chuka' xbij que tiporox c'a ri quitinamit. ");
INSERT INTO cakENT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","C'ateri' c'a ri rey xch'o chic quiq'uin ri rusamajela' jun bey chic y xbij c'a cheque: Ketzij vi que ronojel chic c'o richin nbanatüj ri c'ulubic, xa ja ri xenvoyoj man xeka-pe tüj, y xa más c'a utz xbün que man xepu'u tüj, roma xa man c'uluman tüj vi que xeka-pe. ");
INSERT INTO cakENT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Vocomi c'a, quixbiyin pa tak bey ri nyebe lojc'an chic y que'ivoyoj-pe conojel richin que nyepu'u chupan ri c'ulubic chere', xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Y tok ri samajela' xebe na vi pa tak bey ri nyebe lojc'an chic, xecoyoj y xequimol-vi c'a pe ronojel quivüch vinük, chi utz y man utz tüj quic'aslen chiquivüch ri vinük. Y ri jay ape' xban-vi ri c'ulubic, xnoj. ");
INSERT INTO cakENT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Y ri rey xoc c'a apu chiquitz'etic conojel ri xeroyoj. Y rija' xutz'et c'a que c'o c'a jun achi chiri' ri man rucusan tüj e ri rutziek ri nc'atzin chupan ri jun c'ulubic ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ri rey xch'o c'a chin ri achi ri', ri royon-vi chuka' chupan ri jun c'ulubic ri', y xuc'utuj c'a chin: Y rat ¿achique c'a xabün richin xatiquer xatoc-pe chere'? Tok xa man ja tüj ri tziük ri nc'atzin chupan ri jun c'ulubic re' ri acusan pe, xbij ri rey chin. Y ri achi man jun tzij xtiquer xbij, xa mem xbün c'a chuvüch ri rey. ");
INSERT INTO cakENT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Y ri rey jari' tok xbij cheque ri rusamajela': Tixima-e ruk'a-rakün ri jun achi ri xa man rucusan tüj pe rutziek ri nc'atzin que rucusan ta pe, y que'itorij can c'a cala' pa k'eku'n. Chiri' xaxe c'a ok'ej y jach'ach'en eyaj c'o. ");
INSERT INTO cakENT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Y stape' (aunque) ye q'uiy vi c'a ri nye'oyox, man conojel tüj c'a ri nyecha'tüj can richin que nye'oc pa ruk'a' ri Dios, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Y jari' tok ri achi'a' fariseos xebe. Rije' xbequiya' c'a chiquivüch richin achique ta jun nquibün richin que ri Jesús ntzak ta pa quik'a' riq'uin ri nbij. ");
INSERT INTO cakENT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jari' tok rije' xequitük ri cachibila' ye cachibilan-e ye ca'i-oxi' ruvinak ri rey Herodes. Xequitük-e c'a riq'uin ri Jesús. Y rije' xbequibij c'a chin ri Jesús tok xe'apon riq'uin: Rat ri rat jun Maestro, roj ketaman c'a que xaxe vi c'a ri ketzij ri nka' chavüch y jari' ri ncatzijoj. Nac'ut-vi ri rutzij ri Dios pa rubeyal. Y rat man naxbij tüj chuka' avi' chuvüch jun vinük, stape' (aunque) juis ta ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Y vocomi nkajo' c'a nkac'axaj achique ri nabij cheke. Roma nkanuc ka roj nkabij: ¿C'uluman que nkatoj ri alcaval ri nbij ri rey César ri nc'atzinej que nkatoj o xa man c'uluman tüj? xquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero ri Jesús retaman-vi c'a ri nquinojij chirij. Romari' rija' xbij c'a cheque: Rix xa ca'i' ipalüj. ¿Achique c'a roma rix nitij ik'ij richin nquinitij? ");
INSERT INTO cakENT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tic'utu' c'a pe ri tumin ri nucusüs richin nitoj ri alcaval, xbij cheque. Y rije' jari' xquic'ut-apu ri tumin chuvüch. Ri tumin ri xquic'ut-apu ja ri nquibij denario chin. ");
INSERT INTO cakENT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Y ri Jesús jari' xuc'utuj cheque: ¿Achique chok vachbül c'a la'? ¿Y achique chok bi' chuka' la c'o chuvüch la tumin? xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Y rije' xquibij c'a chin ri Jesús: Richin ri rey César, xquibij. Y ri Jesús xbij c'a cheque: Titojo' c'a ri alcaval chin ri César riq'uin ri tumin ri c'uluman que niya' chin rija'. Y tiya' chin ri Dios, ronojel ri c'uluman que niya' chin rija', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Y tok ri achi'a' ri' cac'axan chic ka ri xbij ri Jesús, xe' xquica'yej tok xcac'axaj. Y rije' xquiya' can c'a ri Jesús. Rije' xebe c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Y ja k'ij ri' tok ch'aka cheque ri achi'a' saduceos xe'apon riq'uin ri Jesús. Ri achi'a' re' man nquinimaj tüj que ri caminaki' nyecastüj chic pe. Rije' xe'apon c'a, roma c'o ri ncajo' chin. ");
INSERT INTO cakENT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Rije' xquibij c'a chin ri Jesús: Rat rat jun Maestro chuka'. C'o c'a jun ri nkajo' nkac'utuj chave. Ri Moisés rutz'iban-vi c'a can cheke: Si c'o c'a jun achi nuya' can ri rixjayil roma rija' ncom-e y man jun ralc'ual nuya' can, jun c'a ruchak' o runimal rija' ri nc'atzinej que nc'ule' riq'uin ri malca'n-ixok, richin quiri' nyec'uje' ta ralc'ual riq'uin ri ixok malca'n. Y si yec'o ralc'ual nyec'uje' riq'uin ri ixok, ri nabey ala' ntoc ralc'ual ri camnük chic e. ");
INSERT INTO cakENT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Y rije' xquibij c'a: Y quiri' c'a xec'uje' ye siete achi'a' quichak'-qui'. Ri nabey xc'ule' c'a. Pero ri achi ri' xcom-e y man jun ralc'ual xuya' ta can. Ri rixjayil ri achi ri' xc'uje' c'a can riq'uin ri ruchak'. ");
INSERT INTO cakENT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ri ruca'n achi quiri' c'a chuka' xuc'ulachij-e, rija' xcom-e y man jun ralc'ual xuya' can. Ri rox achi ja chuka' ri' xuc'ulachij-e, cachi'el ri ca'i' nabey tak runimal y ri ixok c'a xc'uje' na can. Y quiri' c'a xquic'ulachila-e, c'a riq'uin ri ruq'uisbül achi cheque ri ye siete quichak'-qui'. ");
INSERT INTO cakENT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Y tok ye camnük chic c'a e ri siete achi'a' quichak'-qui' chuvüch ri ixok ri', chuka' rija' xcom c'a e. ");
INSERT INTO cakENT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Y ri achi'a' saduceos xquibij c'a chin ri Jesús: Rat nabij que napon jun k'ij tok ri caminaki' nyec'astüj-pe. Tok napon c'a ri k'ij ri', ¿achique chok rixjayil c'a ntoc ri ixok re'? Roma chi siete achi'a' quichak'-qui' xec'uje' riq'uin, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jari' tok ri Jesús xbij cheque ri achi'a' ri': Rix xa rix satznük riq'uin ri xibij. Ri rutzij ri Dios jun vi chic ri nbij. Y man ivetaman tüj c'a chuka' que ri ruchuk'a' ri Dios juis nim. ");
INSERT INTO cakENT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Roma tok napon ri k'ij que ri caminaki' nyec'astüj-e, man nyec'ule' tüj chic, nixta chuka' man nyeyatüj tüj e quimi'al y quic'ajol richin nyec'ule'. Rije' xa nye'oc c'a cachi'el ri ru-ángeles ri Dios chila' chicaj. ");
INSERT INTO cakENT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Jac'a ri c'astajbül quichin ri caminaki' c'o-vi. ¿Man itz'eton tüj c'a ri rutzij ri Dios ri yo'on can pan ik'a'? Chupan ri' ri Dios nbij-vi c'a chive: ");
INSERT INTO cakENT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ja yin ri ru-Dios ri Abraham, ri ru-Dios ri Isaac y ri ru-Dios chuka' ri Jacob. Quiri' c'a ri xbij ri Dios ojer can. Y xa ta ri kaxquin-kamama' can ri' ye caminaki' ta e richin chi jumul, ri Dios man ta qui-Dios rije', roma xa man nyec'astüj tüj chic pe. Ri Dios qui-Dios vi ri c'o quic'aslen y xa man quichin tüj ri caminaki', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Y tok ri vinük cac'axan chic ri tijonic ri xuya' ri Jesús, xe xquica'yej tok xcac'axaj, roma man jun bey cac'axan tüj tzij quiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Y ri achi'a' fariseos chanin c'a xquimol-qui' chunuquic achique ri nquibün, tok xcac'axaj que ri Jesús xutz'apij-vi c'a quichi' ri achi'a' saduceos riq'uin ri xbij. ");
INSERT INTO cakENT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Xpu'u c'a jun cheque ri achi'a' fariseos, jun etamanel vi richin ri ley ri xuya' ri Dios pa ruk'a' ri Moisés, xaxe c'a richin nutij ri Jesús, xuc'utuj c'a chin: ");
INSERT INTO cakENT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Rat ri rat Maestro vi, tabij c'a chuve, ¿achique c'a cheque ri mandamientos ri xuya' ri Dios pa ruk'a' ri Moisés, ri c'o más rakalen? ");
INSERT INTO cakENT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Y ri Jesús xbij chin: Ri mandamiento ri' ja ri tajo' c'a ri Dios ri Avajaf. Tajo' riq'uin ronojel avánima. Tajo' c'a chupan ronojel ri ac'aslen, y riq'uin ri anojibül. ");
INSERT INTO cakENT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jari' ri nabey y nimalüj mandamiento ri c'o chupan ri ley. ");
INSERT INTO cakENT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Y c'o chuka' jun ruca'n mandamiento juis c'o rakalen y jubama junan riq'uin ri nabey. Y ri mandamiento ri' nbij c'a: Cachi'el najo-ka-avi' rat, quiri' c'a chuka' que'ajo' ri ch'aka chic. Quiri' nbij ri mandamiento ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ronojel vi c'a ri nbij ri ley ri xuya' ri Dios pa ruk'a' ri Moisés y ronojel c'a ri quibin can ri achi'a' ri xek'alajrisan ri xbix cheque roma ri Dios ojer can, chupan c'a ri ca'i' mandamientos ri' petenük ruxe'. Ca'i' c'a mandamientos ri juis yec'o cakalen, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Y tok c'a quimolon-qui' y quic'uan-qui' ri achi'a' fariseos, xpu'u ri Jesús c'o c'a ri xuc'utuj cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Rija' xuc'utuj c'a cheque: ¿Achique c'a ninuc rix pari' ri Cristo? Tok rija' npu'u, ¿achique chok alc'ual rija'? Y ri achi'a' fariseos xquibij c'a: Richin ri rey David, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Y ri Jesús xbij c'a cheque: ¿Pero achique c'a roma tok ri rey David xbij Vajaf chin ri Cristo? Roma xa xk'alajrisüs chin roma ri Lok'olüj Espíritu, y romari' xbij c'a: ");
INSERT INTO cakENT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ri Ajaf Dios xbij c'a chin ri Vajaf ri Cristo: Catz'uye-pe pa vajquik'a' (nu-derecha) y nyenya' pan ak'a' ri nye'etzelan avichin. Quiri' xbij. ");
INSERT INTO cakENT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Y si ri rey David, Vajaf nbij chin ri Cristo, ¿achique c'a roma tok nbix que ri Cristo xa choj jun ruxquin-rumam can ri rey David? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Y man jun c'a ri xbin ta apu jun tzij chin ri Jesús, richin nbij ta apu ri xuc'utuj ri Jesús pari' ri Cristo. Ja k'ij ri' tok xutz'om-e que man jun chic xbanun covil richin c'o ta ri nuc'utuj chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Y ri Jesús jari' tok xch'o chiquivüch ri vinük y chuka' xch'o quiq'uin ri rachibila'. Rija' xbij c'a: ");
INSERT INTO cakENT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Pa ruq'uexel c'a ri Moisés, ye tz'uyul ri achi'a' ri ye etamanela' chin ri ley ri xuya ri Dios richin rija' y ri achi'a' fariseos. ");
INSERT INTO cakENT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Roma c'a ri' rix titakej quitzij. Ronojel c'a ri nquibij chive, tibana' y tichajij. Pero man tibün c'a cachi'el ri nquibün rije'. Roma rije' xa man nyetiquer tüj nquibün ri nquibij que tiban. ");
INSERT INTO cakENT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rije' nimalüj tak aka'n nquiya' chiquij ri vinük, aka'n ri c'o calal y c'ayuf quic'uaxic. Ri aka'n ri' xaxe c'a chiquij ri vinük nquiya-vi y rije' man nquisiloj tüj jun vit ruvi-quik'a' richin ta nquibün y nquic'uaj ta ri aka'n ri nquibij que nc'atzinej que nquic'uaj ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Y rije' nquibanala' c'a ri utz, pero man richin tüj que utz nquibün chuvüch ri Dios. Xa man roma tüj c'a ri' tok nyequibanala'. Rije' xaxe richin que quetz'et y quenimüx coma ri vinük que ja ri utz ri nyetajin chubanic. Y xe chuka' richin ri' tok juis nimak' nquibanala' chin ri c'ojlibül ri nquic'uaj chirij ri quik'a' y ri nic'aj-quivüch. C'ojlibül ri nquiyüc-vi ri ch'aka mucaj chin ri rutzij ri Dios. Y chuka' más nimak' rakün nquibanala' chin ri retz'aba'l ruchi' tak quitziek. ");
INSERT INTO cakENT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ja chuka' ri nabey tak ch'acüt nyequijo' pa nimak' tak va'in y ja chuka' ri' ri nyequicha' pa tak jay ape' ntzijos-vi ri rutzij ri Dios, richin quiri' tibix que rije' juis quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Juis nka' chiquivüch ri nyeban saludar can pa bey ri ape' nyequimolo-vi-qui' ri vinük. Y chuka' juis nka' chiquivüch que nbix can cheque coma ri vinük: Maestro, Maestro, nquibij cheque roma c'o quik'ij nyequitz'et. ");
INSERT INTO cakENT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jac'a rix man tijo' nbix maestro chive, roma xaxe c'a Jun ri c'o ri c'uluman que nibij Maestro chin, y ri' ja ri Cristo. Jac'a rix chi'ivonojel, i-hermanos ivi'. ");
INSERT INTO cakENT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chuka' man roma tüj que ri vinük c'o ruk'ij, roma ta ri' rix nibij ta katata' chin. Man tibün quiri'. Roma ri Tata'aj xa Jun c'a ri c'o pa kavi' konojel, y ri' ja ri aj-chicaj Itata'. ");
INSERT INTO cakENT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Man tijo' c'a que ri vinük nquibij maestro chive. Roma xaxe Jun ri Maestro c'o y ri' ja ri Cristo. ");
INSERT INTO cakENT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Roma ri más nim ruk'ij chive rix, nc'atzin que nuna-ka-ri' que xa manak ruk'ij y tuch'utinirsaj-ri' richin nusuj-ri' chubanic achique na samaj. ");
INSERT INTO cakENT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Roma ri nquinimirsaj-qui', xa nkasüs ri quik'ij. Y ja ri man nquinimirsaj tüj qui', ninimirsüs quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Jac'a rix etamanela' richin ri ley ri xuya' ri Dios richin ri Moisés y rix fariseos ri xa ca'i' ipalüj, juya' ivüch! roma xa ik'aton c'a quibey ri vinük richin man nye'oc pa ruk'a' ri Dios. Man utz tüj c'a ri ibanun, roma man nyixoc tüj apu rix y chuka' man niya' tüj k'ij cheque ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Juya' ivüch rix etamanela' richin ri ley ri xuya' ri Dios richin ri Moisés y rix fariseos ri xa ca'i' ipalüj! roma rix xa nivelesala' ronojel qui-cosas ri malcani'a' tak ixoki'. Y xaxe richin que tinimüx que jabel ic'aslen, nyixlayuj c'a tok nibanala' oración chin ri Dios. Y roma c'a ri' tok rix más nim castigo nka-ka pan ivi', roma ri imac juis q'uiy. ");
INSERT INTO cakENT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Juya' ivüch rix etamanela' richin ri ley ri xuya' ri Dios richin ri Moisés y rix fariseos ri xa ca'i' ipalüj! roma rix nic'usala' ya' y nic'usala' ruch'ulef chucanoxic si c'o ta jun ri ntoc tzeklebey ivichin y nutakej ta ri nitakej rix. Xa ja tok ivilon chic ri achique ntzekleben ivichin, rix xa c'ayuf nibün chin, roma riq'uin ri nic'ut chuvüch, nibün chin que nüj nbe-vi chin ri Dios. Rix nüj c'a nyixc'o-vi, pero rija' ca'i' mul más nüj nbe-vi, y xa romari' tok c'uluman que nbe pa k'ak' chuka' rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Y chuka' juya' ivüch rix ri nyixbin que rix uc'uey-bey y xa rix moyi'! Rix ri nyixibin que si c'o jun ri nucusaj ri racho ri Dios richin que nbün jurar, stape' (aunque) man nbün tüj ri rubin, man jun rubanun. Jac'a ri nucusaj ri oro ri c'o pa racho ri Dios, richin que nbün jurar, ri' ruc'as chic c'a ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Rix nic'ut-vi c'a que rix tontos y chuka' rix moyi', ¿roma achique c'a ri más ruk'ij? ¿Ja ri oro ri c'o pa racho ri Dios o xa ja ri racho ri Dios ri nbanun lok'olüj chin ri oro c'o chiri'? ");
INSERT INTO cakENT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Rix chuka' nibij: Ri nucusaj ri altar richin que nbün jurar, stape' (aunque) man nbün tüj c'a ri rubin, man jun rubanun. Jac'a ri nucusaj ri sipanic ri nc'uje' pari' ri altar, richin que nbün jurar, ruc'as chic c'a ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Rix tontos y rix moyirnük vi c'a, ¿roma achique c'a ri más ruk'ij? ¿Ja c'a ri sipanic ri nisuj pari' ri altar chin ri Dios o xa ja ri altar? Ja ri altar ri más ruk'ij, roma jari' ri nbanun lok'olüj chin ri sipanic. ");
INSERT INTO cakENT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ri nucusaj c'a ri altar richin nbün jurar, numej-vi c'a ronojel. Numej ri altar y numej chuka' ri sipanic ri nisuj pari' ri altar. ");
INSERT INTO cakENT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ri nucusaj c'a ri racho ri Dios richin que nbün jurar, numej c'a ronojel. Numej ri racho ri Dios y numej ri c'o chiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Y ri nucusaj c'a ri caj richin que nbün jurar, chuvüch c'a ronojel ri c'o chila' nbij-vi ri'. Numej-vi c'a ronojel. Numej c'a ri tz'uyul-vi ri Dios y numej c'a chuka' ri Dios ri tz'uyul chiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Xa juya' ivüch vi rix etamanela' richin ri ley ri xuya' ri Dios richin ri Moisés y rix fariseos ri xa ca'i' ipalüj! roma rix xaxe ri jubulüj tak k'ayis, ri rubini'an menta, ri anís y ri comino ri nye'inuc. Roma nye'ivelesala' pa lajuj (diez), y xa jujun c'a cheque ri lajuj (diez) ri' ri niya' chin ri Dios. Y xa iyo'on c'a can rubanic ri más nc'atzin ri nbij chupan ri ley, que choj tibana' quiq'uin ri vinük, que tic'uje' joyovanic iviq'uin y ketzij yo'on ta ivánima riq'uin ri Dios. Jare' ri nabey c'uluman ta ibanun, y c'ateri' ri nyixtajin-vi chubanic. ");
INSERT INTO cakENT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Rix c'a ri nyixbin que rix uc'uey-bey, pero xa rix moyi', ninbij c'a chive, que rix xaxe oc ri más tak cocoj ley ri nyixtajin chubanic y ri más ye nimak' man ye ibanun tüj, xa iyo'on k'ij que choj nyec'o. ");
INSERT INTO cakENT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Juya' ivüch c'a rix etamanela' richin ri ley ri xuya' ri Dios richin ri Moisés y rix fariseos ri xa ca'i' ipalüj! roma xa rix cachi'el lük ri jabel ch'ajch'oj rij y ri rupan xa tz'il-tz'il. Rix nic'ut c'a chiquivüch ri vinük que utz ri inojibül, pero pa tak ivánima man quiri' tüj, roma xa nojnük riq'uin elek', y nojnük riq'uin itzel rayinic, roma rix nirayij que ronojel ri c'o quiq'uin ri vinük iviq'uin ta rix c'o-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Rix fariseos xa rix moyi'. Tibana' c'a chin ri ic'aslen cachi'el nibün riq'uin ri lük, nich'ajch'ojrisaj rupan y ri rij. Rix tich'ajch'ojrisaj c'a ri ivánima nabey, richin quiri' ri ic'aslen chiquivüch ri vinük ch'ajch'oj chuka' nk'alajin. ");
INSERT INTO cakENT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Juya' ivüch c'a rix etamanela' richin ri ley ri xuya' ri Dios richin ri Moisés y rix fariseos ri xa ca'i' ipalüj! roma xa rix junan riq'uin jun tz'ak ri ape' yo'on-vi jun camnük, ri rij sük y ch'ajch'oj, jac'a ri rupan man quiri' tüj. Ri rupan xa ruyon man utz tüj c'o y ruyon rubakil camnük. ");
INSERT INTO cakENT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Rix quiri' vi c'a rix. Rix nyixk'alajin c'a que choj ri ic'aslen chiquivüch ri vinük, jac'a pan ivánima xa man quiri' tüj. Ri ivánima xa nojnük riq'uin itzel. Y chuka' ca'i' c'a ipalüj. ");
INSERT INTO cakENT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Juya' ivüch c'a rix etamanela' richin ri ley y rix fariseos ri xa ca'i' ipalüj! roma jabel nye'ichojmirsala' ri tz'ak ape' ye muknük-vi ri achi'a' ri xek'alajrisan ri xbix cheque roma ri Dios ojer can. Rix jabel vi nivek ape' ye muknük-vi ri chojmilüj tak ralc'ual ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Y rix nibij c'a: Xa ta roj xojc'uje' pa qui-tiempo ri kaxquin-kamama' can, roj man ta xojoc cachibil rije' tok xequicamsaj ri achi'a' ri xek'alajrisan ri tzij ri xbix cheque roma ri Dios, nyixbij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pero xa ja rix ri nyixk'alajrisan-ka chivij que rix quixquin-quimam can ri xecamsan quichin ri achi'a' ri xek'alajrisan ri xbix cheque roma ri Dios ojer can. ");
INSERT INTO cakENT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tiya' c'a can ri xquibanala' ri ixquin-imama' can. ");
INSERT INTO cakENT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Rix, xa cachi'el itzel tak cumütz. ¿C'o ta c'a jun rubanic richin man ta nquixbe pa k'ak' chuc'ulic ri rutojic ri nyixbanun? Man jun. Rix chiri' c'a nyixapon-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Y richin c'a que rix nic'ut ri ivetzelal, yin jare' yinc'o chic richin nyentük-e chi'icojol, achi'a' ri nyek'alajrisan ri nbij ri Dios cheque, achi'a' ri juis quina'oj y achi'a' ri c'o etamabül quiq'uin. Pero rix yec'o c'a cheque ri nusamajela' ri nye'ibajij chuvüch tak cruz richin nyecom, y yec'o ri choj quiri' nivelesaj quic'aslen. Yec'o c'a la' nye'ich'ey chiri' pa tak jay ape' ntzijos-vi ri rutzij ri Dios, y achique na c'a tinamit nyebe-vi rije', rix chuka' nyixapon chiri' roma c'o itzel ri nijo' nibün cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Y ronojel re' nbün c'a chive que ja rix nyixakalen ri quicamic conojel ri chojmilüj tak vinük ri elesan quic'aslen. Ri rutz'uquic-pe riq'uin ri rucamic ri chojmilüj achi rubini'an Abel c'a riq'uin ri rucamic ri achi rubini'an Zacarías, ri ruc'ajol ri achi rubini'an Berequías. Y ninbij c'a chive, que ri Zacarías ja chuka' rix ri xixcamsan richin, chiri' chunakaj ri altar ri c'o chiri' chuvüch racho ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ri xinbij c'a ka chive, ketzij vi que quiri' nbanatüj. Ronojel vi c'a ri' nka-ka pa quivi' ri vinük ri yec'o chupan ri tiempo re'. ");
INSERT INTO cakENT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","C'ateri' ri Jesús xch'o c'a pa quivi' ri vinük ri yec'o pa Jerusalén. Rija' xbij c'a: Aj-Jerusalén, aj-Jerusalén, ¿achique c'a roma tok nye'icamsala' ri achi'a' ri nyek'alajrisan ri nbix cheque roma ri Dios? ¿Achique c'a roma chuka' tok nye'icamsala' chi abüj ri nyerutük-pe ri Dios chi'icojol? Y yin, juis c'a mul ri xinjo' que xixinmol ta viq'uin, cachi'el nbün ri quite-üc' cheque ri xtak ral, nyerumol chuxe' ri ruxic'. Man jun bey c'a xijo' ta rix. ");
INSERT INTO cakENT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vocomi c'a, ri ivacho chi'ijujunal rix nc'uje' can cachi'el jun tz'iran ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Y quiri' c'a ri ninbij chive roma rix jare' ruq'uisbül mul ri nquinitz'et-e. Y nquinitz'et c'a jun bey chic ja tok ninbij chive: ¡Matiox que petenük ri Jun re'! ¡Que ri Ajaf Dios nbün ta bendecir rija'! ¡Y petenük pa rubi' ri Ajaf Dios! Chupan c'a ri k'ij ri' tok nquinitz'et jun bey chic, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Y tok ri Jesús xel c'a pe chiri' pa racho ri Dios, richin que nbe, ri rachibila' xejel c'a apu y c'o c'a ri xquibij pari' ri racho ri Dios y xquic'utula' c'a chuvüch chuka' riq'uin ri ruvi' tak quik'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jac'a tok rija' xch'o-apu cheque ri rachibila', xbij c'a: Rix nye'itz'eta' c'a que ri jay re' juis ye jabel. Pero yin ketzij ninbij chive, que napon c'a jun k'ij tok xa nyevulüx y man nyepa'e' tüj chic can. Ronojel ri nimalüj tak abüj ri ye ucusan cheque ri jay re', xa nyetorix-ka pe. Man jun c'a abüj ri nc'uje' ta can cachi'el la rubanun vocomi, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Y tok ri Jesús tz'uyul chic c'a pari' ri juyu' rubini'an Olivos, jari' tok ri rachibila' xejel-apu riq'uin y xquic'utuj chin: Tabij c'a cheke, ¿jampe' c'a nc'ulachitüj ri xabij yan ka pari' ri racho ri Dios? ¿Achique c'a retal richin quiri' ninabex ri ruca'n mul ri ncapu'u rat? ¿Y achique chuka' retal richin quiri' ninabex que napon yan ri ruq'uisbül k'ij richin ri tiempo re'? xquibij c'a rije'. ");
INSERT INTO cakENT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Y ri Jesús xbij cheque ri rachibila': Jabel c'a tichajij-ivi' richin man nyixch'acatüj. ");
INSERT INTO cakENT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Roma ye q'uiy ri nyepu'u, nquibij: Ja yin ri Cristo, nquibij c'a. Y ye juis ye q'uiy ri nyech'acatüj pa quik'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Y nivac'axala' c'a que yec'o ruch'ulef c'o oyoval ntajin chiquicojol. Y nivac'axala' chuka' que quiri' cha nyebanatüj, que c'o cha oyoval ri nyepu'u. Pero man tisatz c'a ic'u'x, roma ronojel ri' xa nc'atzinej c'a que nyebanatüj vi. Pero man ja tüj c'a ri' ri ruq'uisbül tak k'ij richin ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jun tinamit ncatüj c'a e richin nberubana' oyoval riq'uin jun chic tinamit. Yec'o c'a chuka' nimak' tak ruch'ulef nyecatüj-e richin que nyequibana' oyoval quiq'uin ch'aka chic nimak' tak ruch'ulef. Nyepu'u c'a yabil, vayjül y chuka' cab-rakün achique na lugar chin ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Y jari' ri nabey tak k'oxomül, y c'ateri' nyepu'u chic c'a ch'aka quivüch pokonül. ");
INSERT INTO cakENT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nyixyalox c'a pa tak pokonül, y yec'o c'a chive rix ri nyecamsüs. Xa nyixetzelüs-vi c'a coma conojel quivüch vinük ri yec'o chuvüch ri ruch'ulef, roma rix iyo'on ivánima viq'uin yin. ");
INSERT INTO cakENT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ye q'uiy c'a ri nyetzak chic can, yec'o chuka' nquisujula-qui' y yec'o ri nquetzelaj-qui'. ");
INSERT INTO cakENT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Y nyebec'ulun c'a chuka' pe juis ye q'uiy, ri nyebin que rije' ye k'alajrisüy richin ri nbij ri Dios cheque, y roma c'a quiri' ri nquibij, ye q'uiy vi c'a vinük ri nyech'acatüj pa quik'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chuka' chupan ri tiempo ri' roma juis chic biyinük rubanic ri itzel, ye q'uiy c'a ri xa nquimalij ri ncajo' ri ch'aka chic. ");
INSERT INTO cakENT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero ri man c'a nutzolij tüj ruc'u'x chirij y nucoch' c'a pa ruq'uisbül chin ronojel, ncolotüj-vi c'a ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pero nc'atzinej que ntzijos ri utzilüj rutzij ri Dios ri nch'o pari' tok ri vinük nye'oc pa ruk'a' ri Dios. Nc'atzinej que ntzijos ri tzij ri' pa ronojel ruch'ulef, richin quiri' tetamüx c'a. Y c'a jari' tok napon ri ruq'uisbül k'ij richin ri tiempo ri katz'amon. ");
INSERT INTO cakENT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Y chuka' napon-vi ri k'ij tok nyebananun ri xajan chupan ri lok'olüj lugar chupan ri racho ri Dios. Jari' ri tz'iban can roma ri Daniel, ri jun cheque ri achi'a' ri xek'alajrisan ri xbix cheque roma ri Dios, ojer can. Ri ntz'eton c'a ri tz'iban can, tic'o c'a chin ri nutz'et. ");
INSERT INTO cakENT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Richin quiri' tok nitz'et que ja chic ri' ri nbanatüj, ri vinük ri yec'o pa ruch'ulef Judea xa que'anmüj c'a e y quequevaj-qui' pa tak juyu'. ");
INSERT INTO cakENT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ri xa nuxlan c'a pari' ri racho tok napon ronojel ri vululen ri', choj quiri' tanmüj-e. Man toc chic apu pa racho richin que c'o na ri nyeruc'ama-pe. Man tubün quiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ri nsamüj c'a pa k'ayis, man c'a tibe chic pa racho chuc'amic rutziek ri cachi'el coton. Xa choj chuka' quiri' tanmüj-e. ");
INSERT INTO cakENT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jac'a ri ixoki' ri coyoben chic alanen, y ri ixoki' ri xa c'a nquiya' quitz'un tak cal, juya' quivüch c'a tok napon ri k'ij ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Roma c'a ri' xa tic'utuj chin ri Dios que ri vululen ri' man ta nbanatüj chupan ri tiempo richin tef, y chuka' tic'utuj c'a que man pa jun k'ij richin uxlanen nbanatüj ronojel ri', richin que man c'ayuf tüj nbün chive richin que nyixanmüj. ");
INSERT INTO cakENT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Y c'ateri' tok nc'o ruvi' ri pokonül ri npu'u. Jun pokonül ri man jun bey c'ulachitajnük tüj pari' ri ruch'ulef jampe' ri banun can roma ri Dios, c'a ri vocomi chupan ri ka-tiempo roj. Chuka' ri pokonül ri' man jun bey chic c'a nc'ulachitüj. ");
INSERT INTO cakENT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Y si man ta c'a nch'utinirsüs ri k'ij richin ri pokonül ri', conojel ta nyecom. Pero roma ri Dios nyerujo' ri ye rucha'on chic, nuch'utinirsaj ri k'ij ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Chupan ri k'ij ri', si yec'o c'a ri nyebin chive: Titz'eta', ja Cristo re'. O si nquibij chive: Titz'eta', ja Cristo la'. Pero rix man quixch'acatüj c'a pa quik'a', man tinimaj ri nquibij chive. ");
INSERT INTO cakENT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Roma yec'o c'a ri nyebec'ulun-pe y nquibila' c'a: Ja yin ri Cristo. Pero rix man que'inimaj c'a, roma xa quiyon ch'aconela'. Y ja chuka' tiempo ri' tok nyebec'ulun-pe ri nyebin: Yin nink'alajrisaj ri nbij ri Dios chuve, nquibij. Pero rix man que'inimaj c'a, roma xa ye ch'aconela' chuka'. Y nyequibanala' c'a nimak' tak milagros, ri man jun bey ye tz'eton tüj, xaxe richin quenimüx, y yec'o ri nyequich'üc. Y si ta xa nyetiquer, rije' nyequich'üc ta chuka' ri ye cha'on chic roma ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ja yan c'a re' xinbij can chive ri nyebanatüj. ");
INSERT INTO cakENT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Romari' si xa nbix c'a chive: Ri Cristo xpu'u yan y vocomi jari' c'o pa tz'iran ruch'ulef, rix man quixbe chutz'etic c'a. Y si nbix chive que ri Cristo c'o chic y vocomi chupan ri jun jay ri' c'o-vi, man que'inimaj. ");
INSERT INTO cakENT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Roma tok yin ri xinalüx chi'icojol nquipu'u jun bey chic, nquik'alajin-vi c'a jabel. Xa nbanatüj c'a cachi'el nbanatüj riq'uin ri coyopa' ri nbün cala' ape' ntel-vi-pe ri k'ij y nbek'alajin c'a cala' ape' nka-vi ri k'ij, conojel vi c'a nyetz'eton. Y quiri' c'a yin. ");
INSERT INTO cakENT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Roma ri ru-juicio ri Dios ntak-pe ape' c'o-vi ri mac. Nbanatüj c'a cachi'el nbanatüj quiq'uin ri c'uch. Roma ri ch'ipa' ri' ape' na c'o-vi ruch'acul jun camnük, chiri' c'a nyeka-ka-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Y tok ye c'unük chic c'a ronojel ri pokonül richin ri tiempo ri', nbanatüj-vi c'a que ri k'ij nk'ekumür-ka y ri ic' chuka' man ntzu'un tüj chic. Ri ch'umila' nyetzak c'a ka ri ape' yec'o-vi. Ronojel vi c'a ri nimalüj tak uchuk'a' ri yec'o chila' chicaj nyesilon roma ri ruchuk'a' ri Dios. Que jun vi c'a ri caj nsilon. ");
INSERT INTO cakENT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jari' tok ri chicaj ntz'etetüj ri vetal yin ri xinalüx chi'icojol. Ronojel c'a quivüch vinük ri yec'o chuvüch ri ruch'ulef, c'ateri' c'a nye'ok' y c'ateri' nka-pe chiquic'u'x ri achique rije', tok yinquitz'et que ja yin ri nquika-pe pa sutz' ri chila' chicaj, riq'uin chic nimalüj vuchuk'a' y riq'uin chuka' chic jun nimalüj nuk'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Y jari' chuka' tok ri trompeta nk'ajan riq'uin juis ruchuk'a', y yin nyentük c'a ri nu-ángeles chiquimolic ri ye nucha'on chic. Nyequimol-vi c'a pe ri cala' pan oriente y ri cala' pan occidente, ri cala' c'a pa norte y ri cala' chuka' pa sur. Nyequimol-vi c'a pe' ronojel ri ape' ntiquer-pe ri jun rutza'n ri caj, c'a la jun chic rutza'n. ");
INSERT INTO cakENT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Tic'ama' c'a ina'oj riq'uin ri che' higuera. Tok nyeraxür c'a pe ri ruk'a' y nquitz'om-pe quelic ri ruxak, etaman c'a ri' que ri ru-tiempo ri job nka-pe yan. ");
INSERT INTO cakENT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Y quiri' c'a tok nitz'et que yec'o chic ri nyec'ulachitüj chupan ri k'ij, ri ic' y ri ch'umila', y ronojel ri xinbij yan ka nbanatüj chic, tivetamaj c'a ri' que nka-pe yan ri k'ij. Xa nakaj chic c'a c'o-vi-pe. ");
INSERT INTO cakENT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Y tivac'axaj c'a jabel ri ninbij chive vocomi: Ronojel re' nc'ulachitüj tok ri vinük richin ri tiempo re' c'a man jani queq'uis-e chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Y ri ruch'ulef y ri caj ye richin vi nyeq'uis. Jac'a ri nutzij yin man nq'uis tüj quiri', xa nbanatüj-vi ri nbij. ");
INSERT INTO cakENT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jac'a ri k'ij y ri hora tok yin nquipu'u, man jani k'alüj tüj. Ri ángeles ri yec'o chila' chicaj man quetaman tüj jampe'. Xaxe c'a ri Nata' Dios ri etamayon chin ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Xa cachi'el c'a ri xbanatüj pa ru-tiempo ri Noé, xa quiri' c'a chuka' nc'ulachitüj tok nquipu'u chic yin ri xinalüx chi'icojol. ");
INSERT INTO cakENT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Roma pa ru-tiempo ri Noé, tok c'a man jani tibanatüj ri camic job, ri vinük xa benük c'a cánima chirij ri quiva'in y chirij ri achique nyequikumula'. Xa benük c'a cánima chirij ri quic'ulubic y chirij ri nyequijüch-e quimi'al-quic'ajol richin nyec'ule'. Y quiri' c'a nyetajin chubanic chupan ri k'ij tok ri Noé y ri ye aj pa racho xe'oc chupan ri nimalüj barco. ");
INSERT INTO cakENT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Y man jun bey c'a xk'ax ta cheque ri xk'alajrisüs chiquivüch, xa c'a ja tok xapon na ri camic job ri xuc'uan quichin conojel. Y quiri' vi c'a chuka' nbanatüj tok napon ri k'ij chin nquipu'u jun bey chic yin ri xinalüx chi'icojol. ");
INSERT INTO cakENT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jari' tok nbanatüj que ye ca'i' achi'a' ri junan nyesamüj pa k'ayis, jun rutaken y jun man rutaken tüj, xaxe c'a jun ri nuc'u'üx-e y ri jun chic ncanaj can. ");
INSERT INTO cakENT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Y si yec'o ye ca'i' ixoki' ri junan nyeque'en riq'uin jun abüj joc'oj-trigo y xaxe jun ri rutaken, xaxe c'a jun ri nuc'u'üx-e y ri jun chic ncanaj can. ");
INSERT INTO cakENT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Roma c'a ri' man quixmestan, xa quinivoyobej-apu, roma xa man nivetamaj tüj jampe' tok nquinka-pe yin ri Ivajaf. ");
INSERT INTO cakENT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Roma rix ivetaman-vi c'a, que si ta ri rajaf jun jay nretamaj jampe' napon ri elek'on pa racho, ri rajaf ri jay ri' nc'ase' ta chuchajixic ri racho, y man ta nuya' k'ij que ri elek'on nujük-apu ri racho richin nelek'-e. ");
INSERT INTO cakENT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Xa romari' tok rix c'uluman que chi jumul quinivoyobej-apu, roma tok xa man ja tüj ri' nyixtajin chunuquic, jari' tok nquinka-pe yin ri xinalüx chi'icojol. ");
INSERT INTO cakENT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Chupan ri k'ij ri' nbanatüj c'a cachi'el ri nbanatüj riq'uin jun rajaf-jay ri ruyo'on can jun rusamajel pa quivi' ri ye aj pa racho. Rubin can chin que querutzuku-apu tok napon ri hora. Y si ri samajel ri' nbün ta ri bin can chin y utz nbün chin ronojel ri samaj, ¿achique ta nbün? ");
INSERT INTO cakENT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Rija' nbün-vi ri samaj ri bin can chin, y romari' nquicot ránima tok nilitüj-ka-pe roma ri rajaf y ntajin chubanic ri samaj. ");
INSERT INTO cakENT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ketzij vi c'a ninbij chive que ri rajaf ri samajel ri' nuya' c'a pari' ronojel ri ruchajin, richin que nuchajij. ");
INSERT INTO cakENT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Jac'a si ri samajel ri' xa itzel ta nbün, y nunuc ta ka pa ránima: Ri vajaf ri' xa man jani nka-pe, nbij ta ka. ");
INSERT INTO cakENT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Y nutz'om ta c'a quich'ayic ri ch'aka chic samajela' y chuka' xe ta va'in y ya' nbün quiq'uin ri k'abarela', ");
INSERT INTO cakENT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","jac'a ri k'ij y ri hora tok man jun nunuc que nka-pe ta ri rajaf, jari' tok nka-pe. ");
INSERT INTO cakENT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ri rajaf, nuya-vi castigo pari' ri samajel ri' y nuya' quiq'uin ri ch'aka chic ri xa ca'i' quipalüj. Y chiri' xaxe c'a ok'ej y jach'ach'en eyaj ri c'o. ");
INSERT INTO cakENT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Chupan c'a ri k'ij tok nquipu'u jun bey chic, yec'o c'a ri nye'oc-vi pa ruk'a' ri Dios, y yec'o ri xa man nye'oc tüj. Xa nc'ulachitüj c'a cachi'el ri xc'ulachitüj quiq'uin ye lajuj (diez) xtani' quic'uan-e quik'ak' richin sük richin xebe chiroyobexic ri ala' ri nc'ule' chupan ri ak'a' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ye vo'o' c'a cheque ri xtani' ri' c'o-vi quina'oj. Jac'a ri ye vo'o' chic xa ye manak quina'oj. ");
INSERT INTO cakENT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ri vo'o' xtani' ri xa ye manak quina'oj, xebe c'a chiroyobexic ri ala' ri nc'ule', pero xa man xquic'uaj tüj c'a ch'aka chic aceite richin ri quik'ak', xaxe ri quiyo'on-e chupan. ");
INSERT INTO cakENT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jac'a ri vo'o' chic xtani' ri c'o quina'oj, xquic'uaj c'a ri quik'ak' y quic'ualon-e chuka' ri jujun c'ojlibül nojnük-e riq'uin aceite. Y rije' xebe c'a chiroyobexic ri ala' ri nc'ule'. ");
INSERT INTO cakENT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Y roma c'a ri ala' ri nc'ule' juis xlayuj yan y man nka-pe tüj chanin, ri lajuj (diez) xtani' ri ye oyobeyon richin, xa xpu'u c'a ruchuk'a' ri varan cheque. Nabey xexca'r-ka y c'ate ba' ri' xa xevür-vi-ka. ");
INSERT INTO cakENT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jac'a pa nic'aj-ak'a' xac'axatüj c'a rutzij jun ri riq'uin juis ruchuk'a' nch'o y nbij c'a: Jari' petenük ri ala' ri nc'ule'. Quixel c'a pe chuc'ulic. Quiri' c'a ri nbij ri riq'uin ruchuk'a' nch'o. ");
INSERT INTO cakENT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Y jari' tok ri lajuj (diez) xtani' ri', ri ye oyobeyon richin ri ala' ri nc'ule', junanin c'a xecatüj y xquibanala' c'ojlen ri quik'ak' richin sük. ");
INSERT INTO cakENT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jac'a ri vo'o' xtani' ri ye manak quina'oj xquibij c'a cheque ri vo'o' chic xtani' ri c'o-vi quina'oj: Ri kak'ak' xa nyebechup c'a roma xa man q'uiy tüj chic aceite quic'uan. Tiya' c'a ba' ka-aceite rix, xquibij ri xtani' ri ye manak quina'oj. ");
INSERT INTO cakENT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Jac'a ri vo'o' chic xtani' ri c'o-vi quina'oj, xquibij c'a: Ri c'uluman que nibün rix vocomi ja ri que'ilok'o' aceite quiq'uin ri c'ayinela', roma si roj nkaya' ri aceite chive, riq'uin ba' chic ri' xa nc'atzin cheke roj, y quiri' chuka' rix. Romari' ri más utz nibün xa quixbiyin chulok'ic aceite, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Y tok ri vo'o' xtani' ri' xa c'ateri' ye benük chulok'ic aceite, jari' tok xapon ri ala' ri nc'ule'. Ri vo'o' xtani' ri yec'o-vi-apu coyoben ri ala' ri nc'ule', xe'oc c'a pa jay ape' nban ri c'ulubic. Y tok ye c'unük chic c'a apu conojel ri ye benük, xtz'apis c'a can ri puerta. ");
INSERT INTO cakENT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Y jari' c'a tok xe'apon ri vo'o' chic xtani' ri xebe chulok'ic aceite richin ri quik'ak', y rije' xech'o c'a apu chin ri rajaf ri jun c'ulubic ri' y xquibila' c'a: Tajaka' ri puerta chikavüch richin que nkujoc-apu, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Y rija' xbij c'a pe cheque ri xtani' ri': ¿Rix achique c'a rix? Yin ketzij ri ninbij chive que man jun bey xinvetamaj tüj ivüch, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Roma c'a ri' rix man quixmestan, quinivoyobej-apu, roma xa man ivetaman tüj achique k'ij, achique hora tok yin ri xinalüx chi'icojol nquipu'u jun bey chic. ");
INSERT INTO cakENT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Roma c'a ri' ri aj-chicaj gobierno junan riq'uin ri xbün jun achi tok xbe nüj. Rija' xeroyola' c'a ri rusamajela' y xuya' c'a can ri rubeyomal pa quik'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pa ruk'a' c'a jun rusamajel xuya' can vo'o' mil quetzales, pa ruk'a' jun chic xuya' c'a can ca'i' mil quetzales y pa ruk'a' ri jun chic xuya' c'a can jun mil quetzales. Pa ruk'a' c'a ri nabey más q'uiy tumin xuya' can roma xutz'et que ntiquer nusamajij. Ri jun xa ca'i' oc mil quetzales xuya' can pa ruk'a' roma xaxe ri' ri ntiquer nusamajij. Y ri rox xa jun mil quetzales oc ri xuya' can pa ruk'a' richin tusamajij. Y ri achi xe c'a xbün can ri', xbe c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Y ri samajel c'a ri yo'on can vo'o' mil quetzales pa ruk'a' richin tusamajij y nuch'üc más tumin riq'uin, xbün na vi ri bin can chin. Rija' xusamajij-vi c'a ri vo'o' mil quetzales y xuch'üc chic c'a jun vo'o mil riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Y quiri' chuka' xbün c'a ri jun chic samajel ri yo'on can ca'i' mil quetzales pa ruk'a', rija' xuch'üc c'a ca'i' chic mil quetzales riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Jac'a ri rox samajel ri xa jun mil quetzales oc xyo'ox can chin roma ri rajaf, xa xberuc'oto' c'a jun jul pan ulef y chiri' c'a xumuk-vi can ri tumin ri yo'on can pa ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Y tok xa c'unük chic q'uiy k'ij, c'ateri' c'a xtzolij-pe ri achi, ri cajaf ri samajela' ri'. Y rija' xuc'utuj c'a cheque achique xquibün riq'uin ri tumin ri xuya' can cheque tok xbe. ");
INSERT INTO cakENT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tok xapon c'a ri samajel ri yo'on can vo'o' mil quetzales pa ruk'a', man xe tüj c'a ri' ri ruc'uan-apu, xa ruc'uan c'a apu vo'o' mil quetzales más y xbij c'a chin ri achi rajaf rija': Rat vo'o' mil quetzales c'a ri xaya' can pa nuk'a'. Jac'a ri c'o re', y ja chuka' re' c'o vo'o' mil quetzales más ri xinch'üc riq'uin, xbij ri samajel ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Y ri rajaf ri samajel ri' xbij c'a chin: Utz ri xabün. Rat, jun c'a utzilüj nusamajel ri nabün ri nbix chave. Y roma c'a utz xabün riq'uin ri ba' ri xinya' can pan ak'a' tok xinbe, vocomi c'a ncatinya' pari' jun samaj más nim. Catampe c'a y catoc chupan ri quicot ri c'o riq'uin ri Avajaf, xbix chin ri samajel. ");
INSERT INTO cakENT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tok xapon chuka' ri samajel ri yo'on can ca'i' mil quetzales pa ruk'a', rija' xbij c'a chin ri achi, rajaf: Rat ca'i' c'a mil quetzales ri xaya' can pa nuk'a'. Ja ri c'o re', y ja ca'i' mil quetzales c'o re' chuka', ri más ri xinch'üc riq'uin, xbij ri samajel ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ri rajaf ri samajel ri' xbij c'a chin: Utz ri xabün. Rat, jun c'a utzilüj nusamajel ri nabün ri nbix chave. Y roma c'a utz xabün riq'uin ri ba' ri xinya' can pan ak'a' tok xinbe, vocomi c'a ncatinya' pari' jun samaj más nim. Catampe c'a y catoc chupan ri quicot ri c'o riq'uin ri Avajaf, xbix chin ri samajel. ");
INSERT INTO cakENT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Jac'a tok xapon chuka' ri samajel ri yo'on can jun mil quetzales pa ruk'a', rija' xbij c'a chin ri rajaf: Yin vetaman-vi c'a avüch, y romari' vetaman que juis rat ch'ojinel. Xa najo-vi c'a ncach'acon. Rat najo' nac'ul ri ntel-pe chuvüch ri ticoj ri xa man rat tüj xaticon-ka. Najo' nayüc ri trigo ri xa man rat tüj xach'ayon. ");
INSERT INTO cakENT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Y romari' yin xinxbij-vi' xinsamajij ri jun mil quetzales ri xaya' can pa nuk'a'. Yin tok xinc'ul c'a e ri tumin, xinc'ot jun jul pan ulef y chiri' xinmuk-vi can. Y ja atumin re' ninjacha' can chave, xbij ri samajel ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Y ri rajaf ri samajel ri' xbij c'a: Man utz tüj ri xabün. Roma rat, jun itzel samajel y man nabün tüj ri nbix chave. Roma si avetaman que yin yin ch'ojinel vi, que yin ninjo' ninc'ul ri ntel-pe chuvüch ri ticoj ri xa man yin tüj xinticon-ka y ninjo' ninyüc ri trigo ri xa man yin tüj xinch'ayon, ");
INSERT INTO cakENT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","xa roma ta ri', xaya' ta ri nutumin pa quik'a' ri achi'a' quibini'an banqueros, y ri tok xinka-pe vocomi xinc'ul ta c'a ri tumin vichin yin y xinc'ul ta chuka' ri ral ri tumin re'. ");
INSERT INTO cakENT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vocomi tic'ama' c'a can ri tumin chuk'a' y tijacha' pa ruk'a' ri nusamajel ri tz'amayon lajuj (diez) mil quetzales. ");
INSERT INTO cakENT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Roma ri c'o-vi ruchajin, nuc'ul c'a más y q'uiy c'a nbün-ka riq'uin. Jac'a ri man jun oc ruchajin, jaru' oc ri c'o ruchajin ntelesüs c'a can chuk'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Y ri samajel c'a ri xa man jun nc'atzin-vi titorij-e c'a chupan ri k'eku'n, ri ape' ruyon ok'ej c'o y ruyon chuka' jach'ach'en eyaj c'o. ");
INSERT INTO cakENT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Y tok yin ri xinalüx chi'icojol nquipu'u chic c'a, riq'uin chic c'a nuk'ij y chuka' conojel ri lok'olüj tak ángeles nyepu'u chuvij. Y jari' tok yin nquitz'uye' pa nuch'acat ri juis chuka' ruk'ij, y ninbün c'a juzgar. ");
INSERT INTO cakENT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nyemol-vi c'a apu chinuvüch ri vinük richin conojel ruch'ulef. Y nquipu'u c'a yin nyench'ür-vi c'a conojel, cachi'el nbün jun yuk'uy quiq'uin ri ruchico. Rija' lojc'an c'a nyeruya-vi ri ovejas, y lojc'an chic nyeruya-vi ri cabras. ");
INSERT INTO cakENT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ri vinük c'a ri cachi'el ovejas, roma ch'ajch'oj chic quic'aslen, nyenya' c'a pa vajquik'a' (nu-derecha). Jac'a ri vinük cachi'el cabras, roma man utz tüj ri quic'aslen, nyenya' pa nuxocon (nu-izquierda). ");
INSERT INTO cakENT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Y jari' tok ri Rey nbij cheque ri yec'o pa rajquik'a' (ru-derecha): Quixampe c'a rix, ri ic'ulun chic ri utzilüj sipanic ri nspaj-pe ri Nata' Dios. Quixc'uje' c'a ri ape' ja ri Dios ri nbün juzgar, ri ivichin vi rix tok rija' rubanun, y ri' xbün c'a tok c'a man jani c'o tüj ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Roma tok yin xinvayjan, rix c'o c'a xiya' chuve richin xinc'ux. Tok yin xchaki'j c'a nuchi', rix c'o c'a xiya' chuve richin xintij. Xc'atzin nu-posada y rix xiya'. ");
INSERT INTO cakENT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tok xa manak chic nutziek, rix xiya' nutziek richin xintz'apij chic jun bey vij yin. Tok yin xintzak pa ruk'a' yabil, xixapon c'a chinutz'etic. Tok xintz'ape' pa cárcel, xixapon c'a richin xinepochi'ij, nbij ri Rey. ");
INSERT INTO cakENT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jac'a ri chojmilüj tak vinük nquibij c'a: Ajaf, ¿jampe' c'a ri' tok roj c'o xkaya' chave richin ncava' roma ncavayjan? ¿Jampe' c'a ri' tok roj c'o xkaya' chave richin xatij roma nchaki'j achi'? ");
INSERT INTO cakENT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Y jampe' c'a ri' tok xkaya' a-posada roma xc'atzin chave? ¿Jampe' c'a ri' tok roj xkaya' ri atziek richin xkatz'apij avij roma manak atziek? ");
INSERT INTO cakENT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jampe' c'a ri' tok xojapon chi'atz'etic roma xayavüj? ¿Y jampe' chuka' ri' tok xojapon richin xatkapochi'ij roma ratc'o pa cárcel? nquibij rije'. ");
INSERT INTO cakENT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Y ri Rey nbij c'a: Ketzij vi c'a ri ninbij chive que roma quiri' xibün riq'uin ri nu-hermanos ri más co'ol, xa chuve chuka' yin ri xibün-vi ri favor ri xibün chin rija', nbij ri Rey. ");
INSERT INTO cakENT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Y jari' chuka' tok ri Rey nbij cheque ri yec'o pa ruxocon (ru-izquierda): Rix xa castigo chic ri ivoyoben que nka-ka-pe pan ivi'. Quixel c'a e chinuvüch y quixbe c'a pa k'ak' ri man jun bey nichup, y xa banatajnük c'a richin ri itzel-vinük y ri ru-ángeles. ");
INSERT INTO cakENT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Roma yin xinvayjan c'a y rix man jun ri xiya' ta chuve richin xinc'ux. Juis c'a xchaki'j nuchi' y rix man jun xiya' chuve richin xintij. ");
INSERT INTO cakENT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Roma yin xc'atzin nu-posada y rix xa man xiya' tüj. Y tok manak chic nutziek, rix man xinivek tüj. Tok xintzak pa ruk'a' yabil, rix man c'a xinibetz'eta' tüj. Tok xinc'uje' pa cárcel, man xixapon tüj richin xinepochi'ij, nbij ri Rey cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Y jari' tok rije' chuka' nquibij: Ajaf, roj man jun bey xatkatz'et que ncatij ta vayjül, nchaki'j ta achi', chuka' man xkatz'et tüj que nc'atzin ta a-posada, o manak ta atziek, rat yava' ta abanun, ratc'o ta pa cárcel. Roj man jun bey xatkatz'et que quiri' ta ac'ulachin, romari' man jun vi c'a favor xkabün chave, nquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Y jari' tok ri Rey nbij cheque: Ketzij vi c'a ri ninbij chive que roma man jun favor xibün cheque ri cocoj yec'o-pe viq'uin, xa man jun c'a chuka' favor xibün chuve yin. ");
INSERT INTO cakENT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Y ri vinük ri' nyebe-vi c'a pa pokonül richin chi jumul. Y ri chojmilüj tak vinük nquil c'a jun c'aslen ri man nq'uis tüj. Quiri' c'a ri tzij ri xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tok ri Jesús rubin chic c'a ka ronojel ri', rija' xch'o c'a quiq'uin ri rachibila' y xbij c'a: ");
INSERT INTO cakENT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Rix ivetaman-vi que pa ca'i' apu k'ij c'o ri kanimak'ij ri rubini'an pascua. Chupan c'a ri nimak'ij ri' tok yin ri xinalüx chi'icojol nquijach-vi-e richin que nquibajix chuvüch cruz richin que nquicom, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Y ja vi c'a ri' tok ri más nimalüj tak sacerdotes, ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y chuka' ri rajatük tak achi'a' ri juis quik'ij chiquicojol ri vinük, quimolon-vi c'a qui' chi-racho ri nimalüj sacerdote ri rubini'an Caifás. ");
INSERT INTO cakENT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Rije' xquiya' c'a chiquivüch achique chi ch'acoj nyequicusaj richin que ntzak ri Jesús pa quik'a', y c'ateri' nquicamsaj. ");
INSERT INTO cakENT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero chuka' xquibij c'a: Man tikatz'om chupan ri nimak'ij re', richin que man quecatüj-pe ri vinük chikij. ");
INSERT INTO cakENT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Y ri Jesús c'o c'a pa tinamit rubini'an Betania, chiri' pa racho ri Simón ri xc'achojrisüs riq'uin ri yabil rubini'an lepra. ");
INSERT INTO cakENT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Y jari' tok xapon jun ixok riq'uin ri Jesús, ruc'uan-apu jun bambül ri banun riq'uin jun abüj rubini'an alabastro, y c'o-e jun jubulüj ak'on chupan. Y ri ak'on ri' juis q'uiy rajil. Y jari' ri xberuk'ija' pa rujolon ri Jesús, tok tz'uyul c'a chiri' pa mesa, nva' chiri' pa racho ri Simón. ");
INSERT INTO cakENT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tok ri rachibila' xquitz'et ri xbün ri ixok riq'uin ri jubulüj ak'on que xuya' pa rujolon ri Jesús, xpu'u coyoval y xquibila' c'a: ¿Achique nc'atzin-vi que choj quiri' xutix la jubulüj ak'on la'? ");
INSERT INTO cakENT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Roma la jubulüj ak'on la' nim rajil, y romari' más ta utz xc'ayix, y ri rajil xa xjachox ta chiquivüch ri vinük ri manak quichajin, xquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ri Jesús chanin xuna' ri nquibila' ri rachibila', romari' rija' xbij c'a cheque: ¿Achique c'a roma tok rix man nyixtane' tüj ka chi tzij chirij ri ixok re'? Xa tiya' can. Rija' jun utzilüj nojibül c'a ri xbanun chuve. ");
INSERT INTO cakENT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ri vinük ri manak quichajin, chi jumul c'a yec'o iviq'uin, richin que achique na k'ij c'o modo nitola' rije'. Jac'a yin man chi jumul tüj nquic'uje' iviq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Roma tok ri ixok re' xuk'ij ri jun jubulüj ak'on re' chuvij, rija' xbün yan c'a chuve cachi'el nban cheque ri caminaki' tok nyemuk-e. ");
INSERT INTO cakENT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Y tivac'axaj na pe' jabel ri ninbij chive, que achique na lugar c'a ape' ntzijos-vi ri utzilüj tzij richin colonic, chiri' chuka' ntzijos-vi ri xbün ri jun ixok re'. Pa ronojel c'a ruch'ulef ntzijos-vi, y man jun bey c'a nimestüs, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Y jun c'a cheque ri doce rachibila' ri Jesús, ri rachibil rubini'an Judas Iscariote, xapon c'a quiq'uin ri más nimalüj tak sacerdotes. ");
INSERT INTO cakENT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Rija' xberubij c'a cheque: ¿Achique niya' rix chuve, si yin ninjüch ri Jesús pan ik'a'? xbij cheque. Y ri más nimalüj tak sacerdotes xquibij que nquiya' treinta tumin banun riq'uin sakpük chin. ");
INSERT INTO cakENT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Y jari' tok ri Judas Iscariote xutz'om runuquic achique modo nbün richin nujüch ri Jesús pa quik'a' ri achi'a' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Y chupan c'a ri nabey k'ij richin ri nimak'ij ri', tok nc'ux chuka' caxlan-vüy ri manak levadura riq'uin, jari' tok ri rachibila' xe'apon-apu riq'uin ri Jesús, y xquic'utuj c'a chin: ¿Ape' c'a najo' nabün-vi ri va'in chupan ri jun pascua re' richin nkabana' c'ojlen ronojel ri nc'atzin? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Y yec'o c'a cheque ri rachibila' ri xetak-e roma ri Jesús pa tinamit Jerusalén, pa racho jun achi, y xbix-e cheque que tok nye'apon, tiquibij c'a chin: Ri Ka-maestro rubin c'a pe cheke: Ri nu-tiempo xa nakaj chic c'a c'o-vi-pe. Ja pan avacho rat ninjo' ninbün-vi va'in richin ri pascua re', ye vachibilan ri vachibila', tibij, xbij ri Jesús cheque ri rachibila' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Y ri rachibila' xquibün-vi c'a cachi'el ri bin-e cheque roma ri Jesús. Rije' xquibün-vi c'a c'ojlen ronojel ri nc'atzin richin ri va'in richin ri pascua ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jac'a tok xk'ekumür-ka chupan ri k'ij ri', ri Jesús y ri ye doce rachibila' xebetz'uye' c'a chuvüch mesa richin ri va'in. ");
INSERT INTO cakENT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Y tok nyetajin c'a chi va'in, ri Jesús xbij c'a: Ketzij c'a ninbij chive, que jun chive rix ri yinjachon-e pa quik'a' ri vinük, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jac'a ri rachibila' juis xebison pa cánima tok xcac'axaj ri xbij ri Jesús cheque. Y c'ateri' c'a chiquijujunal xech'o-apu chin y xquic'utula' c'a: Ajaf, ¿man ja tüj yin ri nquibanun quiri'? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Y ri Jesús jari' tok xbij cheque ri rachibila': Ri jun c'a ri nuyuk-pe ri ruk'a' richin numuba-pe ruvay viq'uin pa lük, jari' ri nquijachon-e vichin pa quik'a' ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tivac'axaj c'a chuka' ri ninbij chive, que yin ri xinalüx chi'icojol nquibe-vi c'a ri' tok nquijach-e. Nbanatüj cachi'el ri tz'iban can. Pero juya' ruvüch c'a ri achique njachon-e vichin yin ri xinalüx chi'icojol. Ri achi ri njachon-e vichin más ta utz que man ta xalüx, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Y jari' tok xch'o-apu ri Judas, ri njachon richin ri Jesús. Y ri Judas xbij c'a: Rat ri Nu-maestro, ¿ja yin ri nquijachon-e avichin? xbij. Y ri Jesús xbij: Ja rat ncabin ri', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Y tok c'a nyetajin na c'a chi va'in, ri Jesús xuc'ün-apu jun caxlan-vüy y xumatioxij chin ri Dios. C'ateri' xuper ri caxlan-vüy ri' y xuya' cheque ri rachibila'. Rija' xbij c'a cheque ri rachibila' ri': Tic'ama' y tic'uxu' ri caxlan-vüy re'. Roma jare' ri nuch'acul ri napon pa camic. ");
INSERT INTO cakENT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Y ri Jesús xuc'ün-apu chuka' ri vaso ri c'o ruya'al-uva chupan. Y tok rumatioxin chic chin ri Dios, xuya' c'a cheque ri rachibila'. Y rija' xbij c'a tok xuya' cheque: Titija' c'a can chi'ivonojel ri ruya'al-uva c'o chupan ri vaso re'. ");
INSERT INTO cakENT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Roma jare' ri nuquiq'uel ri nbiyin tok nquicom. Nbiyin-vi c'a ri nuquiq'uel, richin que ye q'uiy c'a ri ncuyutüj ri quimac. Riq'uin ri nuquiq'uel, jare' xc'achoj ri c'ac'a' trato ri rujo'on-pe ri Dios que nbün quiq'uin ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ninbij-vi c'a chive que ja ruq'uisbül mul re' xintij-e ri ruya'al-uva re'. Y tok nintij jun bey chic, ja chic c'a chupan ri utzilüj ru-gobierno ri Nata' Dios. Iviq'uin c'a rix chuka' tok nintij ri ruya'al-uva ri'. Y ri nkatij c'a chiri', jun c'ac'a' ruya'al-uva, xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Y tok quibixan chic c'a ri bix richin nquiya' ruk'ij ri Dios, ri Jesús y ri rachibila' xe'el-e chiri' pa jay y xebe pa juyu' Olivos. ");
INSERT INTO cakENT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Y tok ye benük c'a, ri Jesús xbij cheque ri rachibila': Chi'ivonojel rix nitaluj-e-ivi' y nquiniya' c'a can nuyon chupan ri ak'a' re', tok xa nitz'et que yin nquijach-e pa quik'a' ri vinük. Roma ri Dios nbij-vi c'a chupan ri tz'iban can: Tok yin ninya' k'ij que ncamsüs ri k'uyunel, y ri ru-ovejas xa nquitaluj-e-qui'. Quiri' ri tz'iban can. ");
INSERT INTO cakENT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero yin ri K'uyunel man c'a nquicom tüj e richin chi jumul, xa nquic'astüj chic pe. Y ja yin ri ninoyoben ivichin chila' pa Galilea, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Y ri Pedro jari' xch'o-apu chin ri Jesús y xbij: Si ri ch'aka chic ncatquiya' can ayon tok nquitz'et que xa c'o ri nac'ulachij, tiquibana' na c'a. Jac'a yin xa man jun bey ncatinya' can, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pero ri Jesús xbij c'a chin ri Pedro: Yin ketzij c'a ninbij chave, que chupan ri ak'a' re', xa c'a man jani tisiq'uin-pe ri gallo tok rat oxi' mul yan tabij cheque ri nyec'utun chave, que man avetaman tüj nuvüch, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Y ri Pedro xbij c'a chin: Stape' (Aunque) ta nc'atzinej que nquicom aviq'uin rat, man nquitiquer tüj ninbij que man vetaman tüj avüch, xbij ri Pedro. Y conojel c'a ri achibila' quiri' chuka' xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Y jari' tok ri Jesús ye rachibilan ri rachibila' xe'apon c'a chiri' chupan ri lugar rubini'an Getsemaní. Xpu'u ri Jesús xbij c'a cheque ri rachibila': Rix quixtz'uye' na can ba' chere', roma yin xa nquibe chic c'a apu ba' chiri' richin que nquibana' orar, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Rija' xaxe c'a ri Pedro y ri ye ca'i' ruc'ajol ri achi rubini'an Zebedeo ri xeruc'uaj chirij. Jari' tok rija' juis xuna' yan ri nyeruc'ulachij. Jun c'a bis juis nim ri xpu'u pa ránima. ");
INSERT INTO cakENT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Y jari' tok rija' xbij cheque ri ye oxi' rachibila': Ri bis c'o pa vánima, juis nim. Y nquirucamsaj ninna' yin. Quixc'uje' c'a pe viq'uin, quixc'ase' y man quixvür-ka, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Rija' xbiyin chic c'a apu ba' y chiri' xxuque-vi-ka. Xukasaj-vi c'a ka ri' c'a pan ulef, xbün orar. Y ri tzij ri xerubila' quere' c'a: Nata' yin, si ntiquer, tabana' c'a que man ta ninc'usaj ri jun pokonül re', pero man tabün c'a chuka' ri ninrayij yin, xaxe voma ta yin. Roma yin xa ninjo' c'a chuka' ninbün ri arayibül rat, nbij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Y tok rija' xtzakon riq'uin ri oración, xpu'u c'a quiq'uin ri ye oxi' rachibila', pero tok xka-pe quiq'uin xa nyevür. Xpu'u rija' xbij c'a chin ri Pedro: ¿Man ba' c'a xixtiquer xixc'ase' jun vit hora viq'uin? ");
INSERT INTO cakENT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Man quixvür-ka c'a, xa tibana' orar y tic'utuj chin ri Dios richin que tok nyixtijox, man quixtzak pa mac. Vetaman-vi que ri rurayibül ri ivánima ja ri nibün ri nrajo' ri Dios. Pero iyon xa man nyixtiquer tüj c'a, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Y ri Jesús xbe chic c'a apu richin xberubana' orar pa ruca'n mul, y nbij c'a: Nata' yin, si nc'atzinej que ninc'usaj na ri pokonül, richin quiri' nquinic'o chuvüch, yin ninjo' c'a ninbün ri arayibül rat. Quiri' c'a ri nbij pa ru-oración. ");
INSERT INTO cakENT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Y tok rija' xpu'u c'a jun bey chic quiq'uin ri ye oxi' rachibila', nyevür c'a jun bey chic ri xeril, roma ri rachibila' ri' al-al c'a runak' tak quivüch roma ri quivaran. ");
INSERT INTO cakENT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ri Jesús xeruya' c'a can jun bey chic y xbe chic chubanic orar. Oxi' yan mul ri' nbe chubanic orar. Rija' xucamulij chic c'a rubixic ri tzij ri xberubij chupan ri oración c'a ba' tubün-ka. ");
INSERT INTO cakENT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Y c'ateri' ri Jesús xpu'u c'a quiq'uin ri ye oxi' rachibila', y xbij c'a cheque: ¿Nyixvür rix c'a? ¿Nijo' nitz'akatisaj ri ivaran? Yin ri xinalüx chi'icojol ja vi c'a re' xobos nu-hora, nquijach-e c'a pa quik'a' ri itzel tak achi'a'. ");
INSERT INTO cakENT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Chanin, quixcatüj. Jala' petenük ri nquijachon-e pa quik'a' ri itzel tak achi'a', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Y ri Jesús c'a ntajin ntzijon quiq'uin ri rachibila', tok ja yan ri' xka-pe ri Judas ri jun cheque ri doce rachibila', y ye ruc'uan c'a apu ye q'uiy vinük ri ye quic'ualon che' y machet. Conojel re' ye takon c'a e coma ri más nimalüj tak sacerdotes y coma chuka' ri rajatük tak achi'a' ri c'o juis quik'ij chiquicojol ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ri Judas ri njachon-e richin ri Jesús rubin chic c'a pe cheque ri ye petenük chirij, achique modo nbün richin nuc'ut ri Jesús chiquivüch. Rija' rubin c'a pe cheque: Ja ri nquijel-apu riq'uin richin nintz'ubaj, jari' ri Jesús, y titz'ama' c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Y ri Judas jari' tok xjel-apu riq'uin ri Jesús y xbij: Xcok'a' Maestro, caquicot c'a, xbij chin richin xbün saludar. Y xutz'ubaj c'a ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Xpu'u ri Jesús xbij c'a chin ri Judas: ¿Achique c'a ri najo' tok xatobos? xbij chin. Y jari' tok xejel-apu ri vinük ri ye tz'amoy richin ri Jesús y xquitz'om c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Y jun c'a cheque ri ye rachibil ri Jesús, ri yec'o chiri', chanin c'a xrelesaj ri rumachet y xuchoy-e ri ruxiquin ri jun rusamajel ri nimalüj sacerdote. ");
INSERT INTO cakENT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Y ri Jesús jari' tok xbij chin ri xbanun quiri': Tayaca' la amachet pa ruc'ojbül. Roma achique c'a ri nyecatüj riq'uin machet, chi machet c'a chuka' nyecamsüs-vi. ");
INSERT INTO cakENT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Man avetaman tüj rat c'a? Xa ta yin ninc'utuj chin ri Nata' Dios que quiruto', rija' nyerutük ta pe más setenta y dos mil ángeles chinuto'ic. ");
INSERT INTO cakENT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero xa jare' nbanatüj ri ye tz'iban can chupan ri rutzij ri Dios, romari' tok man nc'atzin tüj c'a que nyepu'u ta ri ángeles chinuto'ic, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Y chupan c'a chuka' ri hora ri' ri Jesús xbij cheque ri vinük: ¿Achique c'a xinuc rix? ¿Xinuc que nyixpu'u chutz'amic jun elek'on y romari' ic'amon-pe che' y machet? K'ij-k'ij c'a xintz'uye' iviq'uin chiri' pa racho ri Dios, tok xinc'ut ri rutzij chivüch y man jun bey xinitz'om tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ronojel c'a ri nbanatüj vocomi, xa richin c'a que nbanatüj-vi ri tz'iban can chupan ri rutzij ri Dios coma ri achi'a' ri xek'alajrisan ri rutzij ojer can. Y ja vi c'a ri' tok ri ye rachibila' ri Jesús, xquiya' can ruyon y xe'anmüj. ");
INSERT INTO cakENT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ri xebetz'amon-pe richin ri Jesús chiri' pa Getsemaní, xquic'uaj c'a riq'uin ri Caifás ri nimalüj sacerdote, ri jay ape' quimolon-vi can qui' ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri rajatük tak achi'a' ri c'o-vi quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Y ri Pedro c'anüj c'a c'o-vi can, ye rutzekleben-e, y xoc apu chuka' chiri' chuvüch racho ri nimalüj sacerdote. Tok rija' c'o chic c'a chiri', xtz'uye-apu chiquicojol ri samajela' ri yec'o-apu chiri', richin c'a que nutz'et achique ri nuc'ulachij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Y ri más nimalüj tak sacerdotes, ri rajatük tak achi'a' ri c'o-vi quik'ij, y conojel c'a ri achi'a' pa comon nquibün juzgar, nquicanola' c'a que yec'o ta ri itzel tak nojibül ri nye'ilitüj chirij ri Jesús, richin quiri' nquitük-vi pa camic. ");
INSERT INTO cakENT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Y stape' (aunque) ye q'uiy vi c'a ri xe'apon ri xquitz'uc tzij chirij, xa man jun c'a ri c'o ta ruchuk'a' richin xucusüs. Xa c'a ja pa ruq'uisbül xe'apon ye ca'i' ri junan vi ri nquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ri ye ca'i' ri' xquibij c'a: Ri achi re' rubin: Yin nquitiquer ninvulaj ri racho ri Dios y pan oxi' k'ij ninpaba' jun bey chic. Quiri' ri rubin, xquibij ri ye ca'i' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Y ri Caifás, ri nimalüj sacerdote, xbepa'e' c'a pe y xbij chin ri Jesús: ¿Ketzij ri xquibij-ka chavij ri ye ca'i' re'? ¿Achique nabij vocomi? xbij. ");
INSERT INTO cakENT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero ri Jesús man jun c'a tzij xbij. Y jari' tok ri nimalüj sacerdote xbij chin: Chuvüch c'a ri c'aslic Dios tabij cheke si ja rat ri Cristo ri Ruc'ajol. ");
INSERT INTO cakENT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Y ri Jesús xbij c'a chin: Ja', ja yin ri Cristo. Y chuka' ninbij-vi c'a chive que ri chikavüch apu nquinitz'et-vi que yin ri xinalüx chi'icojol, yin tz'uyul pa rajquik'a' (ru-derecha) ri Dios ri ntiquer nbün ronojel. Y nquinitz'et tok nquika-pe pa sutz' chila' chicaj, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Xpu'u ri Caifás ri nimalüj sacerdote jari' xuk'ach'ij-ka ri rutziek chirij roma itzel xrac'axaj, y xbij c'a: Man nc'atzin tüj c'a que nka-pe chic jun richin nbij cheke que ri Jesús aj-mac vi. Rix, jari' c'a nivac'axaj-ka chi'ivonojel ri xbij que ja rija' ri Cristo. Itzel c'a xbün chuvüch ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Y achique c'a nibij rix vocomi que nkabün chin? xbij rija'. Y ri ch'aka chic ri quimolon-qui' chiri' xquibij c'a: C'uluman que ticamsüs, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Y xquichubala' c'a rupalüj ri Jesús, y xquich'ey riq'uin c'olon-k'a' y yec'o chuka' ri quiric'on quik'a' xquipak'ila' rupalüj. ");
INSERT INTO cakENT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Chuka' xquibila' chin ri Jesús tok quitz'apin ruvüch: Rat ri Cristo, tabij c'a cheke achique ri nyech'ayon avichin, nquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ri Pedro tz'uyul c'a chuvüch ri jay. Y jari' tok c'o jun ixok raj-ic' ri nimalüj sacerdote ri xapon-apu riq'uin y xbij c'a chin: Rat chuka' rat rachibil ri Jesús ri aj-Galilea, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero rija' xa chiquivüch c'a conojel xrevaj-vi, roma xbij: Man nk'ax ta chuve achique roma tok quiri' nabij chuve, xbij chin ri aj-ic'. ");
INSERT INTO cakENT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Y tok rija' nrajo' que ntel-e pa puerta, c'o chic c'a jun ixok aj-ic' ri xtz'eton richin y xbij c'a cheque ri yec'o-apu chiri': Ri jun achi re' chuka' rachibil ri Jesús ri npu'u pa tinamit Nazaret, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pero ri Pedro xa xrevaj chic c'a jun bey. Rija' xbij: Chuvüch Dios ninbij que yin man vetaman tüj ruvüch ri jun achi ri', xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","C'ate ba' chic ri', ri quimolon-qui' chiri' xejel-apu riq'uin ri Pedro y xquibij c'a chin: Ketzij na vi que rat rat jun cheque ri yec'o riq'uin ri Jesús. Xaxe riq'uin ri rubanic ri ncach'o nuk'alajrisaj que quiri' vi, roma ri aj-Galilea quiri' nyech'o, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pero ri Pedro xbij c'a: Yin man vetaman tüj ruvüch ri achi ri'. Chuvüch Dios ninbij-vi chive que man vetaman tüj ruvüch. Y si man ketzij tüj ri ninbij, tika-ka c'a castigo pa nuvi', xbij. Y jari' tok xbesiq'uin-pe ri gallo. ");
INSERT INTO cakENT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Y jari' tok ri Pedro xeka-pe c'a chin ri tzij ri ye rubin can ri Jesús chin, que c'a man jani tisiq'uin-pe ri gallo tok rat oxi' yan mul tabij cheque ri nyec'utun chave, que man avetaman tüj nuvüch. Y rija' xel c'a e y xujik' ok'ej. ");
INSERT INTO cakENT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Y tok xsaker-pe, conojel c'a ri más nimalüj tak sacerdotes y ri rajatük tak achi'a' ri c'o-vi quik'ij chiri' chiquicojol ri vinük, xquimol-qui' richin que nquinuc achique nquibün richin nquitük ri Jesús pa camic. ");
INSERT INTO cakENT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ri Jesús ximon-vi-e tok xquic'uaj y xbequijacha' pa ruk'a' ri gobernador rubini'an Poncio Pilato. ");
INSERT INTO cakENT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jac'a tok ri Judas ri xjachon richin ri Jesús, xutz'et que ri Jesús xa ntak pa camic, jari' tok rija' xpu'u k'oxon riq'uin y xberutzolij can ri treinta tumin banun riq'uin sakpük. Xberutzolij can cheque ri más nimalüj tak sacerdotes y ri rajatük tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ri Judas xbij c'a can cheque ri achi'a' ri': Yin xinmacun c'a tok xinjüch ri Jesús pan ik'a', roma rija' man jun rumac rubanun richin ncamsüs, xbij cheque. Jac'a ri más nimalüj tak sacerdotes y ri rajatük tak achi'a' ri c'o quik'ij, xa xquibij c'a pe chin ri Judas: ¿Achique nkajo' roj chin ri', si rija' manak rumac? Ri' chavüch rat achique na cabanala' rat q'uin, xquibij chin ri Judas. ");
INSERT INTO cakENT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Xpu'u c'a rija' xutorij can ri tumin ye banun riq'uin sakpük. Rija', ja chiri' pa racho ri Dios xutorij c'a can, y xbe c'a rija', xberujitz'aj c'a ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Y ri más nimalüj tak sacerdotes xquisic'-e c'a ri tumin ri banun riq'uin sakpük y xquibij c'a: Ri tumin re' man c'uluman tüj c'a que nkayoj-ka riq'uin ri tumin ri nsipüs can chere' pa racho ri Dios, roma ri tumin re' xa rajil jun achi ri nbiyin ri ruquiq'uel. ");
INSERT INTO cakENT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ja tok quiyo'on chic c'a chiquivüch ri nquibün riq'uin ri tumin ri', rije' xquilok' c'a ri rulef jun banuy-bojo'y. Ri ulef ri' nc'atzin c'a richin que ja chiri' nyemuk-vi ri vinük ri man ye israelitas tüj. ");
INSERT INTO cakENT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Y romari' tok ri jun ulef ri' rubini'an Ulef richin Quic' xbix chin. Man jalatajnük tüj c'a ri rubi'. ");
INSERT INTO cakENT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Riq'uin c'a ri' xbanatüj-vi ri rubin can ri Jeremías, ri jun ri xk'alajrisan ri rutzij ri Dios ojer can. Rija' rubin-vi c'a can: Y ri ye ruxquin-rumam can ri achi ri rubini'an Israel, xquic'ün c'a e ri treinta tumin ri banun riq'uin sakpük, tumin ri xquiya' rije', roma xquibij que jari' ri rajil ri rusamajel ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Y ri tumin ri' jari' ri xquiya' chuvüch ri ulef ri richin ri banuy-bojo'y. Cachi'el vi rubin ri Ajaf chuve. Quiri' c'a ri rubin can ri Jeremías. ");
INSERT INTO cakENT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Y ri Jesús pa'ül-vi c'a apu chuvüch ri gobernador rubini'an Poncio Pilato. Y ri gobernador ri' xuc'utuj c'a chin ri Jesús: ¿Ja rat ri qui-rey ri israelitas? xbij chin. Y ri Jesús xbij: Ja', quiri'. Cachi'el ri xabij, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Y tok ri Jesús juis vi c'a ri nbix-apu chirij coma ri más nimalüj tak sacerdotes y ri rajatük tak achi'a' c'o quik'ij, rija' man jun c'a ri nbij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ri Pilato jari' tok xbij chin ri Jesús: ¿Man navac'axaj tüj c'a ri nquibij ri vinük chavij richin nquisujuj-pe chavij? Y rat man jun nabij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero ri Jesús man jun c'a tzij ri xbij ta chin ri Pilato. Y romari' tok ri gobernador ri' xe' xuca'yej, roma man jun bey rutz'eton ta que jun vinük quiri' ta nbün. ");
INSERT INTO cakENT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Y ronojel c'a juna' pa ru-tiempo ri nimak'ij israelita rubini'an pascua, ri gobernador nucol-vi c'a e jun cheque ri yec'o pa cárcel. Rija' nucol c'a e ri preso ri ncajo' ri vinük que ntel-e. ");
INSERT INTO cakENT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Y chupan c'a ri tiempo ri', c'o c'a preso jun achi rubini'an Barrabás, jun achi ri etaman-vi ruvüch que juis itzel. ");
INSERT INTO cakENT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Y cheque c'a ri vinük ri xbequimolo-qui' chiri', ri Pilato xbij-pe: ¿Achique c'a ri nijo' rix que yin nincol ta e cheque rije'? ¿Nijo' que nincol-e ri Barrabás o ja ri Jesús ri nbix chuka' Cristo chin? xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ri Pilato quiri' vi c'a ri xbij-pe, roma rija' retaman-vi que ri vinük ri' quiyo'on ri Jesús pa ruk'a', roma xa nyetajin nquetzelaj, roma juis ye q'uiy ri nyetzekleben richin. ");
INSERT INTO cakENT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Y ri Pilato tz'uyul c'a ape' nbün juzgar, tok xapon c'a rutzijol riq'uin ri rubin-e ri rixjayil. Ri rixjayil rutakon c'a e rubixic chin: Ri Jesús jun achi choj, romari' rat, man catoc cachibil ri ncajo' rucamic. Roma yin xinbün jun itzel achic' roma ri Jesús. Quiri' c'a ri rutakon-e rubixic ri rixjayil ri Pilato. ");
INSERT INTO cakENT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Y ri más nimalüj tak sacerdotes y ri rajatük tak achi'a' ri c'o quik'ij, xequich'üc c'a ri vinük richin que tiquic'utuj c'a que ja ri Barrabás ri ticolotüj-e y ri Jesús ticamsüs. ");
INSERT INTO cakENT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Y ja tok ri gobernador xuc'utuj jun bey chic cheque ri vinük ri' chi achique c'a cheque ri ca'i' ri nucol-e, ri vinük ri' jari' xquibij: Ja ri Barrabás tacolo-e, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","C'ateri' ri Pilato xuc'utuj c'a cheque ri vinük: ¿Y achique ta ninbün yin chin ri Jesús, ri nbix chuka' Cristo chin? Tibij rix, xbij rija'. Jari' tok conojel xech'o-apu y xquibij: Ri Jesús xa ticamsüs chuvüch cruz, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Xpu'u c'a ri gobernador xbij cheque ri vinük: ¿Achique c'a rumac rubanun chivüch? Pero ri vinük man nyetane' tüj ka. Xa riq'uin más cuchuk'a' xech'o-apu y xquibij: Xa ticamsüs chuvüch cruz, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Y tok ri Pilato xutz'et que xa man jun chic c'a ri ntiquer nbün y ri vinük xa xquitz'om juis nquibün, xpu'u rija' xberuc'ama-pe ba' ruya' y xuch'üj ruk'a' chiquivüch conojel ri vinük ri', y xbij: Yin man jun numac chin ri rucamic ri jun chojmilüj achi re'. Ri' xa chivüch na vi rix achique nibanala' chin, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Xepu'u conojel ri vinük xquibij c'a: Xa pa kavi' c'a roj y pa quivi' ri ye kami'al-kac'ajol can, tika-vi ri rucamic ri jun achi re', xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jari' tok ri gobernador chiquivüch vi c'a ri vinük xucol-e ri Barrabás, jac'a ri Jesús xa xutük c'a chin nch'ay, c'ateri' xujüch-e richin que ticamsüs chuvüch cruz. ");
INSERT INTO cakENT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Y ri soldados richin ri gobernador ri' xquic'uaj c'a apu ri Jesús chupan ri palacio. C'ateri' xecoyoj c'a conojel ri ch'aka chic soldados, ri ye cachibil. Xequimol c'a apu chirij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xepu'u ri soldados ri' xquelesaj c'a e ch'aka rutziek ri Jesús, c'ateri' xquiya' c'a jun tziük cük chirij cachi'el vi ri nyequicusala' ri reyes. ");
INSERT INTO cakENT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Rije' xquipach'uj chuka' jun k'ayis ri juis ruq'uixal. Cachi'el jun corona xquibün chin, y c'ateri' xquiya' pa rujolon ri Jesús. Y xquibün chuka' chin ri Jesús que xutz'om jun aj pa rajquik'a' (pa ru-mano derecha). Y riq'uin tze'en c'a tok nyexuque' chuvüch ri Jesús y nquibila' c'a: Caquicot c'a juis, rat ri qui-rey ri israelitas, nquibij c'a chin. ");
INSERT INTO cakENT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nquichubala' c'a chuka' ri Jesús y nquelesala' ri aj c'o pa rajquik'a' (ru-mano derecha) richin nquit'oy pa rujolon. ");
INSERT INTO cakENT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Y tok rije' xetane' c'a que tze'en chirij, xquelesaj-e ri tziük ri quiyo'on-ka chirij. C'ateri' xquiya-e ri rutziek vi rija', y xquic'uaj c'a e richin que nyequibajij chuvüch cruz. ");
INSERT INTO cakENT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Y ja tok nyetajin nye'el-e chupan ri tinamit, xquic'ul jun achi rubini'an Simón y rija' aj-Cirene. Xepu'u c'a ri soldados xquibün-vi c'a chin ri achi ri' que tuc'uaj-e ri ru-cruz ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Y xe'apon c'a chupan ri jun juyu' rubini'an Gólgota. Ri juyu' ri', Calavera chuka' nquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tok yec'o chic c'a chiri', chin ri Jesús xquiya' c'a jun ch'amilüj ruya'al-uva yojon riq'uin jun c'ayilüj ak'on. Pero tok rija' xuna' ri xquiya' chin, man xrajo' tüj xutij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Y tok ri soldados quibajin chic ri Jesús chuvüch ri cruz, xquiya' c'a pan atz'anin chin xquitz'et achique ri nquich'acon ri rutziek ri Jesús chiquijujunal. Y riq'uin ri' nbanatüj c'a ri bin can roma ri jun ri xk'alajrisan ri rutzij ri Dios ojer can. Ri rusamajel c'a ri Dios rutz'iban-vi can pari' ri Cristo: Xequijüch ri nutziek y chuka' xequiya' pan atz'anin. Quiri' ri rutz'iban can. ");
INSERT INTO cakENT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ri soldados ye tz'uyul c'a chiri' quichajin-apu ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Y chutza'n-e ri cruz, rije' xquiya' c'a jun tz'alün ri tz'iban-e chuvüch ri achique rumac ri Jesús, y romari' ncamsüs. Chuvüch ri tz'alün ri' nbij c'a: Ri Jesús jari' ri qui-rey ri israelitas. Quiri' c'a ri nbij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Y jari' chuka' tok yec'o ye ca'i' elek'oma' ri nyecamsüs chuvüch cruz. Jun c'a xc'uje' pa rajquik'a' (ru-derecha) ri Jesús y ri jun chic pa ruxocon (ru-izquierda). ");
INSERT INTO cakENT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ri vinük c'a ri nyec'o-e y nye'apon riq'uin ri Jesús, nquisilola-apu quijolon chuvüch, roma man nquinimaj tüj que ja rija' ri Ruc'ajol ri Dios. Y c'o chuka' tzij ri nyequibila' can chin. ");
INSERT INTO cakENT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ri vinük ri' nquibila' c'a can chin ri Jesús: Rat ri ncabin que navulaj ri racho ri Dios y pan oxi' k'ij nabün chic jun bey, tacolo' c'a avi' ayon. Y si ja rat ri Ruc'ajol ri Dios, caka-ka-pe chuvüch la a-cruz, nquibij c'a can chin. ");
INSERT INTO cakENT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Y ja chuka' tzij ri' ri nquibila' ri más nimalüj tak sacerdotes. Rije' y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés, ri achi'a' fariseos y ri rajatük tak achi'a' ri c'o-vi juis quik'ij, nquitze'ej c'a ri Jesús y nquibila' c'a chiquivüch: ");
INSERT INTO cakENT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Rija' ye q'uiy vi c'a xerucol, pero rija' man ntiquer tüj nucol-ri'. Y si ja rija' ri Rey richin ri tinamit Israel, tika-ka c'a pe chuvüch la ru-cruz richin quiri' roj nkaya-vi kánima riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Rija' xuya-vi ránima riq'uin ri Dios, y si ri Dios nrajo-vi ri Jesús, tucolo' c'a. Roma ri Jesús xa rubin-vi: Ja yin c'a ri Ruc'ajol ri Dios. Quiri' vi c'a rubin, xquibij ri achi'a' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Y ri elek'oma' ri ye bajin chuvüch qui-cruz cachibilan ri Jesús, quiri' chuka' nquibün, cachi'el ri nquibanala' ri ch'aka chic. C'o chuka' nquibila-apu chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Y tok chi nic'aj k'ij c'a ri jun k'ij ri', jari' tok xk'ekumür-ka ronojel ri ruch'ulef. Y ri k'eku'n ri' xq'uis c'a e pa las tres ri xkak'ij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ja pa las tres ri', jari' tok ri Jesús xch'o-pe riq'uin ronojel ruchuk'a' y xbij c'a: Elí, Elí, ¿lama sabactani? xbij. Y ri tzij ri' nbij: Nu-Dios yin, nu-Dios yin, ¿achique c'a roma tok xinamalij can? ");
INSERT INTO cakENT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Y yec'o ri yec'o-apu chiri' chunakaj ri Jesús, tok xcac'axaj ri xbij, xquibila' c'a: Rija' ja ri Elías ri nroyoj, xquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Y ja vi c'a ri' tok c'o c'a jun ri junanin xberuc'ama-pe jun bo'j cachi'el esponja, xumuba' pa jun ch'amilüj ruya'al-uva. C'ateri' xuya' ri esponja chutza'n jun aj, richin xuya' chin ri Jesús richin que nc'o ba' ri ruchakajal ruchi'. ");
INSERT INTO cakENT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero ri ch'aka ri yec'o-apu chiri' riq'uin ri Jesús, xquibij: Taya' can, xa tikoyobej na k'alüj ri' si npu'u ri Elías chucolic, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pero ri Jesús xa jari' tok xch'o chic riq'uin ronojel ruchuk'a', y xujüch c'a ri ránima pa ruk'a' ri Dios, xcom. ");
INSERT INTO cakENT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Y jari' tok ri c'ul ri achique chok q'uin ch'aron-vi ri rupan ri racho ri Dios xk'ach'itüj, y ca'i' xel. Xutz'om-pe pa jotol y hasta c'a pa xulan ka. Chuka' ri ruch'ulef xsilon-vi c'a y ri abüj xerekero' y xepax. ");
INSERT INTO cakENT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ri jul ape' ye mukun-vi ri caminaki' xejakatüj. Y ye q'uiy c'a cheque ri lok'olüj tak ralc'ual ri Dios ri ye uxlanük chic e, xec'astüj, ");
INSERT INTO cakENT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","y xebe'el-pe. Ja tok c'astajnük chic pe ri Jesús, jari' tok xetz'etetüj chuka' rije'. Rije' xe'apon c'a pa lok'olüj tinamit Jerusalén. Xquic'utula-vi c'a qui' chiquivüch ye q'uiy vinük. ");
INSERT INTO cakENT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ri achi Capitán y conojel ri yec'o chiri' quichajin-apu ri Jesús, tok quitz'eton chic ka ri xbün ri cab-rakün, y quitz'eton chic chuka' ri ch'aka chic ri xebanatüj, rije' juis c'a xquixbij-qui' y xquibila' c'a: Ketzij na vi que ri jun achi re' Ruc'ajol ri Dios, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Y ye q'uiy c'a ixoki' ri quitzekleben-vi-pe ri Jesús tok xel-pe chiri' pa Galilea richin que nquilij, rije' nyetzu'un c'a apu, pero c'anüj c'a yec'o-vi-e. ");
INSERT INTO cakENT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Y chiquicojol c'a conojel ri ixoki' ri', c'o c'a ri María Magdalena, ri María ri quite' ri Jacobo y ri José, y chuka' ri rixjayil ri achi rubini'an Zebedeo, ri quite' ri Jacobo y ri Juan. ");
INSERT INTO cakENT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ja tok xkak'ij yan, c'o c'a jun tzeklebey richin ri Jesús ri xapon. Jun beyon aj pa tinamit Arimatea, rubini'an José. ");
INSERT INTO cakENT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Rija' xbe c'a riq'uin ri Pilato ri gobernador y xberuc'utuj ri ruch'acul ri Jesús richin numuk. Y ri Pilato xbij c'a que tijach-pe ri ruch'acul ri Jesús chin ri José. ");
INSERT INTO cakENT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Y ri José richin xuc'uaj-e ri ruch'acul ri Jesús, xberuc'ama' c'a pe, y c'ateri' xumutz-e pa jun ch'ajch'ojilüj c'ul. ");
INSERT INTO cakENT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ri José aj-Arimatea, xberuya' c'a ri ruch'acul ri Jesús pa jun c'ac'a' jul, jun jul ri ruc'oton rija' chuvüch jun juyu' ri xa abüj vi. Y tok rija' rutz'apin chic c'a can ri jul riq'uin jun nimalüj setesic abüj, xtzolij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ri María Magdalena y ri jun chic ixok rubini'an chuka' María, xetz'uye-vi c'a chuvüch ri jul tok xmuk can. ");
INSERT INTO cakENT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ri k'ij tok xmuk ri Jesús, ja k'ij chuka' ri' tok ri vinük nquibanala' chic ruc'ojlen ronojel ri nc'atzin cheque ri ruca'n k'ij, roma jari' napon ri k'ij richin uxlanen. Y pa ruca'n k'ij, tok yec'o chic chupan ri k'ij richin uxlanen, jari' tok ri más nimalüj tak sacerdotes y ri achi'a' fariseos xquibün c'a que xbequic'ulu-qui' chuvüch ri Pilato ri gobernador. ");
INSERT INTO cakENT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Rije' xbequibij c'a chin: Roj xka-pe chikac'u'x que tok ri Jesús c'a c'üs, xbij c'a que nc'astüj-pe pa rox k'ij. Quiri' vi c'a rubin can ri ch'aconel ri', xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Y richin c'a que man quepu'u ri rachibila' y tiquelek'aj-e ri ruch'acul ri Jesús ri chak'a', y c'ateri' nquibij cheque ri vinük: Ri Jesús xc'astüj-vi-e chiquicojol ri caminaki', romari' roj petenük vocomi richin nkac'utuj favor chave que tataka' ruchajisic ri ape' mukun-vi can, c'a tok ntz'aküt na ri oxi' k'ij. Y si man nkabün tüj quiri' y nsatz-e ri ruch'acul, c'ateri' c'a más ye q'uiy ri nyeniman que takon-vi-pe roma ri Dios, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Y ri Pilato xbij c'a cheque ri achi'a' ri': Quixbiyin c'a y que'ic'uaj-e la achi'a' chajinela' la'. Rix xa ivetaman chic c'a jabel achique rubanic ri nc'atzinej que nibün can chin, xbix cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ri achi'a' ri' jari' xebe ape' mukun-vi can ri Jesús y nyequichojmirsaj can que tichajix jabel. Xquiya' c'a can retal ri abüj ri tz'apbül ruchi' ri jul, ri nc'utun si c'o ri njakon. Y xequiya' can chuka' chajinela' chiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Y tok c'unük chic ri k'ij richin uxlanen, cumaj saker yan chin ri domingo ri nabey k'ij richin ri semana, ri María Magdalena y ri jun chic ixok rubini'an chuka' María xebe c'a, richin nyebe chuchi-jul ri ape' mukun-vi can ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pero tok c'a man jani c'a nye'apon tüj ri ixoki' chiri' chuchi' ri jul, xsilon c'a ri ruch'ulef. Roma jun ángel richin ri Ajaf ri petenük chila' chicaj, xka-pe chupan ri lugar ri', ri ape' mukun-vi can ri Jesús. Ri ángel xrelesaj c'a ri setesic abüj ri tz'apibül-ruchi' ri jul y xtz'uye-ka pari'. ");
INSERT INTO cakENT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ri rusakil c'a ri ángel ri tz'uyul pari' ri abüj, nyiq'uiyot c'a cachi'el nyiq'uiyot jun coyopa'. Y ri rutziek sük-sük cachi'el rusakil ri sutz' tok nsakrisan y chuka' cachi'el ri hielo. ");
INSERT INTO cakENT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Y ri achi'a' chajinela' roma c'a juis xquixbij-qui' chuvüch ri ángel, xebarbot-vi c'a. Cachi'el xecom c'a roma quixbiri'. ");
INSERT INTO cakENT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jac'a ri ángel tok xch'o cheque ri ca'i' ixoki', xbij c'a cheque: Rix man c'a tixbij-ivi'. Roma yin vetaman-vi que rix ja ri ruch'acul ri Jesús ri xcamsüs chuvüch ri cruz ri nicanoj. ");
INSERT INTO cakENT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ri ruch'acul rija' xa manak chic chere', roma rija' xc'astüj yan e, cachi'el ri rubin can chive. Quixampe y titz'eta' na pe' ri ape' xc'uje-vi ri ruch'acul ri Ajaf. ");
INSERT INTO cakENT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Quixtzolij c'a chanin, richin que nibij c'a cheque conojel ri rachibila' ri Jesús que rija' xc'astüj yan e chiquicojol ri caminaki'. Rija' ninabeyüj c'a e chivüch rix, richin que nic'ulu-ivi' chila' pa ruch'ulef Galilea. Y chiri' nitz'et-vi, cachi'el ri ninbij-e chive. ");
INSERT INTO cakENT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Y ri ca'i' ixoki' ri' jari' xe'el-e chiri' chuchi' ri jul. Y stape' (aunque) quixbin-qui', xa juis c'a nyequicot chuka'. Rije' junanin c'a xebe richin que nyequiya' rutzijol cheque ri rachibila' ri Jesús. Rije' c'a quitz'amon-vi-e bey. ");
INSERT INTO cakENT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Y jari' tok ri Jesús xbec'ulun-pe chiquivüch pa bey y xbij c'a cheque: Quixquicot c'a, xbij cheque richin xerubün saludar. Y ri ca'i' ixoki' ri' jari' xexuque-ka chirakün ri Jesús, xquik'etej ri rakün y xquiya' c'a ruk'ij chuka'. ");
INSERT INTO cakENT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Y ri Jesús jari' tok xbij cheque ri ixoki' ri': Man tixbij chic ivi' c'a. Vocomi quixbiyin c'a y que'iya' rutzijol cheque ri nu-hermanos. Richin que quebiyin-vi c'a pa Galilea y chila' c'a yinquitz'et-vi, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ri ixoki' ri' c'a quitz'amon na c'a bey. Y jari' tok yec'o cheque ri chajinela' chiri' chuchi' ri jul xebe c'a pa tinamit Jerusalén. Ri chajinela' ri' xbequiya' c'a rutzijol cheque ri más nimalüj tak sacerdotes, ri ronojel c'a ri xbanatüj chiri' ape' xmukutüj-vi ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Xepu'u ri más nimalüj tak sacerdotes xquimol c'a qui' quiq'uin ri rajatük tak achi'a' ri c'o quik'ij y xquiya-vi c'a chiquivüch que nquiya' juis quitumin ri soldados ri xquichajij ri jul. ");
INSERT INTO cakENT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Y xquibij c'a cheque ri chajinela': Rix xaxe c'a tibij que ja tok nyixvür jari' tok xe'apon ri rachibila' ri Jesús pa k'eku'n y xquelek'aj-e ri ruch'acul. ");
INSERT INTO cakENT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Y si ri gobernador nretamaj c'a que xa xixvür-ka y man xixchajin tüj cachi'el ri bin chive, roj nkubech'o c'a riq'uin y nkurunimaj. Y quiri' nyixkacol pa ruk'a', xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ri soldados ri xechajin chuchi-jul xquic'ün-vi c'a ri tumin chiquik'a', y cachi'el ri xbix-e cheque ja vi c'a ri' xquibün. Ronojel c'a re' xa xbiyin yan rutzijol, y jare' ri etaman coma ri vinük israelitas chupan c'a ri k'ij re'. ");
INSERT INTO cakENT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jac'a ri once rachibila' ri Jesús, xebe c'a pa ruch'ulef Galilea. Xebe c'a pari' ri juyu' ri bin can cheque roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Y tok xquitz'et c'a ruvüch ri Jesús, rije' xquiya' c'a ruk'ij. Y xa c'a yec'o c'a chuka' ri man jani quiniman tüj que ri Jesús jari' ri c'o quiq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ri Jesús xjel c'a pe quiq'uin richin ntzijon, y xbij c'a cheque: Ronojel pa nuk'a' c'a yin jachon-vi, quiri' chila' chicaj y quiri' chuka' chere' chuvüch ri ruch'ulef. Ronojel c'a ri uchuk'a' yo'on chuve. ");
INSERT INTO cakENT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Roma c'a ri' vocomi ninbij-vi chive: Quixbiyin c'a ronojel ruch'ulef y ri vinük nye'oc ta c'a tzeklebey vichin. Ri yinquitzeklebej c'a, que'ibana' bautizar pa rubi' ri Nata' Dios, pa nubi' yin ri Ruc'ajol y pa rubi' ri Lok'olüj Espíritu. ");
INSERT INTO cakENT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Y tic'utu' chiquivüch que tiquitakej ronojel ri nubin can. Y yin k'ij-k'ij c'a nquic'uje' iviq'uin. Nquic'uje-vi iviq'uin c'a tok ri ruch'ulef napon chupan ri ruq'uisbül k'ij. Quiri' c'a.");
INSERT INTO cakENT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Quere' c'a ntz'ucutüj-e ri utzilüj rutzijol pari' ri Jesucristo ri Ruc'ajol ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ri Isaías, ri xk'alajrisan ri rutzij ri Dios ojer can, rutz'iban can ri xbix chin roma ri Dios pari' ri Jesucristo. Y jare' ri xutz'ibaj can rija': Nquitük c'a jun achi nabey, chin nuc'ut y nutzijoj que ya ja nobos ri Cristo, ri Jun cha'on-pe y takon-pe roma Rija', richin que ri vinük nquichojmirsaj-qui' cachi'el jun achi nuchojmirsaj jun bey. ");
INSERT INTO cakENT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ja achi re' nc'uje' pa tz'iran ruch'ulef. Rija' nutzijoj c'a ri rutzij ri Dios chiquivüch ri vinük ri nye'apon riq'uin. Y nubila' c'a cheque: Tichojmirsala' rubey ri ic'aslen, roma ya ja chic nobos ri Ajaf. ");
INSERT INTO cakENT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ri achi ri xk'alajrisaj c'a ri Isaías que npu'u nabey, ja ri Juan Bautista. Y rija' c'o c'a pa tz'iran ruch'ulef y nbij cheque ri vinük ri nye'apon riq'uin, que tiquitzolij-pe quic'u'x riq'uin ri Dios y tiquibana' bautizar-qui', richin quiri' ri Dios nucuy quimac. Y ye q'uiy ri nyerubün-e bautizar rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Y ri vinük c'a ri nye'apon riq'uin ri Juan Bautista, ye juis ye q'uiy. Yec'o ri aj pa tinamit Jerusalén, ri tinamit ri c'o chiri' pa ruch'ulef Judea. Y yec'o ri aj pa ch'aka chic tinamit richin ri Judea chuka'. Ri vinük re' nyeban c'a e bautizar roma rija' chiri' pa rakün-ya' Jordán. Rije' nyequik'alajrisaj c'a ri quimac pa sük chuvüch ri Juan Bautista. ");
INSERT INTO cakENT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ri rutziek c'a ri Juan banun riq'uin rusumal camello, y jun tz'un ri ximbül-rupan. Y ri ruvay, ja ri sac' y cab ri nquiya' ri chico pa k'ayis. ");
INSERT INTO cakENT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ri Juan nutzijoj c'a cheque ri vinük: C'o Jun ri npu'u chikavüch apu ri man cachi'el ta oc yin. Ri Jun ri' nim vi ruk'ij y nim chuka' ri ruchuk'a': romari', nixta yin man c'uluman tüj chuve nquichaque-ka chin ninquir ri ruxajab, roma nim ruchuk'a' ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Y yin, ya' nincusaj richin nyixinbün bautizar. Pero ri Jun ri npu'u, riq'uin ri Lok'olüj Espíritu nyixrubün-vi bautizar. ");
INSERT INTO cakENT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chupan ri k'ij can ri' tok ri Jesús elenük-pe pa tinamit Nazaret chin ri ruch'ulef Galilea y xapon riq'uin ri Juan. Y rija' chuka' xban bautizar roma ri Juan pa rakün-ya' Jordán. ");
INSERT INTO cakENT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tok ri Jesús xel-pe pa ya', xutz'et que ri caj xjakatüj, y ri Lok'olüj Espíritu nka-ka c'a pe pari' cachi'el jun paloma. ");
INSERT INTO cakENT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Y c'o jun ch'abül xbij-pe chila' chicaj: Ja rat ri Nuc'ajol, juis ncatinjo' y nuyo'on vánima aviq'uin, xbij ri ch'abül ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jari' tok ri Jesús xban chin roma ri Lok'olüj Espíritu que xbe pa tz'iran ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Y nk'alajin que pa tz'iran ruch'ulef yec'o-vi ri itzel tak chico chiri'. Chiri' c'a xc'uje'-vi cuarenta k'ij. Y tok ri Jesús c'o c'a chiri', ri itzel-vinük nutij c'a ruk'ij chirij richin ntzak ta pa ruk'a', pero man xtiquer tüj chirij. Y ri ángeles xquilij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","C'o chic c'a ri Juan pa cárcel, tok ri Jesús xbe pa ruch'ulef Galilea. Ri Jesús nutzijoj c'a ri utzilüj rutzij ri Dios que ri Dios nka-pe chuch'ulef chin nbün mandar, ");
INSERT INTO cakENT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","y nbij c'a: Ya ja nobos ri tiempo tok nka-pe ri Dios chere' chuch'ulef chin nbün mandar. Titzolij c'a pe ic'u'x y tinimaj ri utzilüj tzij richin colonic, nbij c'a rija' cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Y jun k'ij ri Jesús tok benük c'a chuchi' ri mar rubini'an Galilea, xerutz'et c'a ca'i' achi'a' quichak'-qui', Simón rubi' ri jun y Andrés rubi' ri jun chic. Ri ca'i' achi'a' ri' ye tz'amoy tak cür, romari' tok nquijük c'a ri quiya'l tz'ambül-cür y nquitorij ka pa ya'. ");
INSERT INTO cakENT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Y tok ri Jesús xch'o cheque ri tz'amoy tak cür ri', xbij cheque: Rix ca'i' tz'amoy tak cür quinitzeklebej c'a, y comi banun chive rix tz'amoy tak achi'a' chin yinquitzeklebej. ");
INSERT INTO cakENT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ri ca'i' achi'a' ri', jari' xquiya' can ri tz'amoj-cür y xebe chirij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Y c'ate ba' xebiyin, tok ri Jesús xpa'e' yan. Rija' xerutz'et c'a ri Jacobo y ri Juan, ri ye ruc'ajol ri jun achi rubini'an Zebedeo. Ri ye ca'i' achi'a' ri' pa canoa c'a yec'o-vi, nyesamüj. Rije' nyequic'ojoj ri quiya'l tz'ambül-cür. ");
INSERT INTO cakENT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Y xpu'u c'a ri Jesús xeroyoj chin nquitzeklebej. Y ri Jacobo y ri Juan xcac'axaj quiri', xebe chirij. Y xaxe c'a ri quitata' y ri samajela' ri xec'uje' can chiri' pa canoa. ");
INSERT INTO cakENT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ri Jesús y ri ye benük chirij, xe'apon c'a pa tinamit Capernaum. Y chupan ri k'ij richin uxlanen, ri Jesús xbe c'a pa ri jay ape' ntzijos-vi ri rutzij ri Dios. Rija' nbij c'a ri rutzij ri Dios cheque ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Y ri xe'ac'axan richin, xsatz quic'u'x roma ri tzij ri xcac'axaj. Roma rija' nuc'ut riq'uin autoridad y man cachi'el tüj oc ri nquic'ut ri achi'a' ye etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés. ");
INSERT INTO cakENT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Y chiri' pa ri jay ape' ntzijos-vi ri rutzij ri Dios, ri k'ij ri' c'o c'a apu jun achi ri c'o jun itzel espíritu ruchajin. Y ri itzel espíritu ri ruchajin ri achi, riq'uin ruchuk'a' xch'o. ");
INSERT INTO cakENT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Y xbij c'a chin ri Jesús: ¿Achique c'a ri najo' cheke, rat Jesús aj-Nazaret? ¿Xapu'u c'a richin que nkojaq'uis? Yin vetaman rat achique rat y romari' vetaman que rat rat lok'olüj-vi y rat petenük riq'uin ri Dios, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero ri Jesús xuch'olij ri itzel espíritu y xbij chin: Man cach'o chic. Catel-e. ");
INSERT INTO cakENT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Y ri itzel espíritu xuyiquiya' can ruch'acul ri achi, y nsiq'uin xel-e. ");
INSERT INTO cakENT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Y ri vinük ri quimolon-qui' chiri', xsatz quic'u'x tok xquitz'et ri xbün ri Jesús, y nquibila' c'a chiquivüch: Ronojel ri ntzijoj rija' re' c'ac'a' c'a. Ni jun bey kac'axan. Y ja ri nbij rija', jari' nquibün ri itzel tak espíritu. Jari' nquitzijoj ri vinük chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Y chanin c'a xbiyin rutzijol ri Jesús, y romari' ri vinük ri yec'o pa tak tinamit ri yec'o-pe pa ruch'ulef Galilea, chanin c'a xcac'axaj ri rutzijol ri nbanala' ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tok ri Jesús, ri Jacobo y ri Juan xe'el c'a pe chiri' pa ri jay ape' ntzijos-vi ri rutzij ri Dios, rije' xebe c'a chicacho ri Simón y Andrés. ");
INSERT INTO cakENT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pero tok xe'apon c'a, xbix chin ri Jesús que ri rujite' ri Simón nye'avüj y cotz'ol pa ruvarabül, roma jun nimalüj c'atün. ");
INSERT INTO cakENT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Y ri Jesús xberutz'et ri yava'. Rija' xutz'om c'a ruk'a' ri yava' y xbün chin que xcatüj. Y xe quiri' xbün chin, c'ateri' xq'uis-e ri c'atün chirij. Y ri ixok ri' c'ateri' xuya' quivay ri Jesús y ri ye benük chirij. ");
INSERT INTO cakENT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ja mismo k'ij re' tok xcok'a-ka, jari' tok conojel ri vinük ri c'o yava'i' quiq'uin xequic'uala-apu chuvüch ri Jesús. Ri yava'i' c'a ri', c'o ri choj chi yabil ri ntoc cheque y yec'o c'a ri yava'i' pa quik'a' itzel tak espíritu. ");
INSERT INTO cakENT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ye q'uiy vi ri vinük ri xquimol-apu-qui' chiri', xa bama conojel ri vinük ri yec'o chupan ri jun tinamit ri' ri xe'apon riq'uin ri jay ape' c'o-vi ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Y ri Jesús xeruc'achojrisaj-e ri yava'i'. Ri yava'i' ri' jalajoj c'a ruvüch yabil ri tz'amayon quichin. Y chuka' rija' xerelesala-e ri itzel tak espíritu quichajin ri vinük. Ri Jesús man xuya' tüj k'ij cheque ri itzel tak espíritu richin xech'o, roma rije' quetaman achique rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Cumaj yan c'a ruca'n k'ij, ri Jesús xcatüj-e y xbe pa tz'iran ruch'ulef richin xberubana' orar. ");
INSERT INTO cakENT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Y ri Simón y ri ye rachibila' xebequicanoj ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tok xquil c'a, xquibij chin: Ncatquicanoj q'uiy vinük, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Y ri Jesús xbij c'a cheque: Jo' pa ch'aka chic tinamit ri yec'o-pe nakaj, richin nyentzijoj chuka' ri rutzij ri Dios chiri', roma chubanic ri samaj ri' xinpu'u chere' chuch'ulef, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Y rija' xberutzijoj ri rutzij ri Dios pa ronojel ri ruch'ulef Galilea. Xa achique na tinamit ape' napon-vi, rija' nutzijoj ri rutzij ri Dios pa tak jay ape' ntzijos-vi ri rutzij ri Dios. Y chuka' xerelesala' c'a ri itzel tak espíritu. ");
INSERT INTO cakENT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","C'o jun achi ri c'o ri jun itzel yabil chirij, ri rubini'an lepra. Ri achi ri' xapon riq'uin ri Jesús, xxuque-ka chuvüch y xbij c'a riq'uin ronojel ránima: Yin vetaman que rat ncatiquer nquinac'achojrisaj ri nuyabil, pero man vetaman tüj si najo' nabün, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ri Jesús juis xupokonaj ruvüch ri achi ri ruc'ulachin ri yabil ri'. Romari' rija' c'ateri' xutz'om-apu y xbij chin: Ninjo' que nac'achoj. Tiq'uis c'a e ri yabil re' chavij, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Y xe xbij quiri' ri Jesús, ri ru-lepra ri achi xq'uis-e y xch'ajch'ojir c'a can. ");
INSERT INTO cakENT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Y ri Jesús, c'ateri' xbij chin ri achi que tibiyin, pero juis xuchilabej can chin ri achique rubanic nbün. ");
INSERT INTO cakENT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ri Jesús xbij c'a e chin ri achi ri': Man tatzijoj ri achique ri xbanatüj aviq'uin, xa choj cabiyin pa racho ri Dios richin te'ac'utu-avi' chuvüch ri sacerdote. Y taya' c'a ri nbij chupan ri vuj ri rutz'iban can ri Moisés. Chupan ri vuj ri' nbij ri achique nc'atzin que naya' rat. Richin quiri' nac'ut chiquivüch ri vinük que rat ch'ajch'oj chic, xbij-e. ");
INSERT INTO cakENT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero ri achi xaxe c'a xuya' can ri Jesús, xa xutz'om c'a rutzijosic cheque ri vinük ri achique xbanatüj riq'uin rija'. Y romari' ri Jesús chanin c'a xel rutzijol, y man ntiquer tüj chic c'a ntoc-apu pa tak tinamit ape' napon-vi, roma ye q'uiy ri vinük ri nyec'ulun-apu richin. Y roma chuka' ri', ri Jesús nc'uje' c'a can pa k'ayis. Ri lugar ye manak vinük. Y ri vinük ri nye'apon riq'uin ye juis ye q'uiy, y chuka' q'uiy lugar nyepu'u-vi ri vinük ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Y tok c'unük chic c'a ca'i-oxi' k'ij, ri Jesús xtzolij pa tinamit Capernaum, y jari' tok ri vinük xcac'axaj que rija' c'o pa jun jay chiri' pa tinamit. ");
INSERT INTO cakENT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jari' tok yec'o vinük ri chanin c'a xquimol-apu-qui' riq'uin ri jay ape' c'o-vi ri Jesús. Man yec'o tüj chic c'a pa jay, romari' cho jay xec'uje' can vinük. Pa ruchi-jay man jun chic c'a ntiquer ntoc. Y ri Jesús nbij c'a ri rutzij ri Dios cheque conojel ri xquimol-apu-qui'. ");
INSERT INTO cakENT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jari' tok yec'o ch'aka chic ri xe'apon. Rije' quic'uan c'a apu jun achi ri man ntiquer tüj nsilon ruch'acul. Ye caji' c'a ri ye uc'uayon-apu richin ri achi ri man ntiquer tüj nsilon ruch'acul y rije' quili'en-e chuvüch ri ruvarabül. ");
INSERT INTO cakENT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero rije' xa man xetiquer tüj xe'oc-apu c'a riq'uin ri Jesús, coma ri vinük ri quimolon-apu-qui' juis ye q'uiy. Man xetiquer tüj c'a xec'o chiquicojol ri vinük ri', romari' ja pari' ri jay xquivop. Y ri jul ri xquibün can ja ri ape' c'o-vi ri Jesús chiri' xquibün-vi-ka. Y chiri' c'a xquikasaj-vi-ka ri yava', rachibilan ri ruvarabül. ");
INSERT INTO cakENT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Y tok ri Jesús xerutz'et que quiyo'on c'anima riq'uin rija', xbij c'a chin ri achi ri man ntiquer tüj nsilon ruch'acul: Valc'ual, xbij chin. Ri amac xecuyutüj. ");
INSERT INTO cakENT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Y ri jay ape' quimolon-vi-qui', yec'o chuka' apu etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés, y rije' ye tz'uyul c'a. Rije' nquinuc c'a pa tak cánima: ");
INSERT INTO cakENT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Achique roma tok ri Jesús nbij chin la achi que nucuy rumac? Nbün que ja rija' ri Dios. ¿Roma achique vinük ncuyun mac? Man jun. Xaxe ri Dios ri ncuyun mac, xquibij c'a pa tak cánima ri etamanela' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero ri Jesús retaman-vi ri nquinuc pa tak cánima ri achi'a' ri'. Y romari' xbij cheque: ¿Achique c'a roma tok rix quere' ninuc pa tak ivánima? ");
INSERT INTO cakENT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Roma si yin nquitiquer ninbün chin ri jun achi ri man ntiquer tüj nsilon ruch'acul que nbiyin-e, y nuc'uaj-e la ruvarabül, ¿Y si yin nquitiquer ta comi chuka' ninbij chin que nincuy rumac? ¿Achique nibij rix? ");
INSERT INTO cakENT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vocomi c'a, richin que rix nivetamaj que yin ri xinalüx chi'icojol c'o vuchuk'a' richin nincuy mac, titz'eta' c'a. Y ri Jesús xbij c'a chin ri achi ri man ntiquer tüj nsilon ruch'acul: ");
INSERT INTO cakENT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ninbij c'a chave: Cacatüj, tac'uaj-e la avarabül y cabiyin chi'avacho, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Y ri achi jari' xpa'e-e, xuc'ol-e ri ruvarabül, y xel-e chiquicojol ri quimolon-qui' chiri'. Y ri vinük ri' xsatz c'a quic'u'x, roma man jun bey quitz'eton que quiri' ta nbanatüj. Y xquiya' c'a chuka' ruk'ij ri Dios y xquibila' c'a: Man jun bey katz'eton que quere' ta nbanatüj, xquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Y ri Jesús xbe chic c'a chuchi' ri mar jun bey: y ye juis ye q'uiy vinük ri xe'apon riq'uin, y rija' nyerutzijoj cheque ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Y ja tok rija' rutz'amon bey richin ntzolij, jari' tok xutz'et ri Leví, ri ruc'ajol ri jun achi rubini'an Alfeo. Ri Leví tz'uyul c'a pari' jun ch'acüt chin nquitoj can ri alcaval. Xpu'u ri Jesús xbij c'a chin: Quinatzeklebej. Y jari' tok rija' xbecatüj-pe ape' tz'uyul-vi y xutzeklebej-e ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Y ja tok rija' tz'uyul chuvüch mesa chiri' pa racho ri Leví, ye q'uiy c'a cheque ri moloy tak alcaval y ch'aka chic vinük ri aj-mac nbix cheque, xetz'uye-apu chuvüch mesa, junan riq'uin ri Jesús y ri rachibila'. Ye juis ye q'uiy ri nyetzekleben richin ri Jesús ri yec'o c'a chiri'. ");
INSERT INTO cakENT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Y tok ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri achi'a' fariseos xquitz'et ri Jesús que xa nva' quiq'uin ri moloy tak alcaval y quiq'uin ri vinük ri nbix aj-mac cheque, xquic'utuj c'a cheque ri rachibila': ¿Achique roma la' que rija' nva' quiq'uin moloy tak alcaval y quiq'uin la aj-mac? xquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Y tok ri Jesús xrac'axaj-pe ri tzij ri nquibij ri etamanela' richin ri ley ri xuya' ri Dios richin ri Moisés y ri achi'a' fariseos, rija' xbij cheque: Jun ak'omanel man nuna' tüj ri manak quiyabil nyerok'omaj sino que ja ri c'o quiyabil, jari' nyerok'omaj. Yin man xinpu'u tüj chiquicanoxic vinük ri choj quic'aslen. Yin xinpu'u chiquicanoxic ri c'o quimac richin nquitzolij-pe quic'u'x riq'uin ri Dios, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ri rachibila' ri Juan Bautista y ri cachibila' ri achi'a' fariseos, c'o c'a k'ij quicha'on richin man nyeva' tüj, chin nquibün orar. Y romari' xquic'utuj c'a chin ri Jesús: Roj ri katzekleben ri Juan y ri katzekleben ri fariseos kacha'on k'ij richin man nkuva' tüj, richin nkabün orar. ¿Y achique roma ri ncatquitzekleben rat man quiri' tüj nquibün? Jari' xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Y ri Jesús xbij c'a cheque: ¿Achique nibij rix? ¿Utz comi que man nyeva' tüj ri ye oyon pa jun c'ulubic y c'o-apu quiq'uin ri ala' ri xc'ule'? Man utz tüj nquibün si man nyeva' tüj, roma ri ala' c'a c'o quiq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero napon ri k'ij tok ri ala' re' ntelesüs-e chiquicojol, y jari' tok nquibün que man nyeva' tüj richin nquibün orar. ");
INSERT INTO cakENT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Y rija' xbij chic cheque: Y man nijun nka-pe pa rujolon nuc'ojoj rutziek riq'uin jun c'ojobül c'ac'a' roma xa c'anc'ol ri'. Y si quiri' xtibün chin xa más nim nuk'ach'ij can ri k'axtanük. ");
INSERT INTO cakENT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Y xbij chuka': Man nijun nyo'on c'ac'a' vino chupan jun tz'un yacbül vino ri'j chic. Ri' c'ateri' nuya-pe punto y juis nchoboloj y nuk'ach'ij ri tz'un ri'j chic. Y nq'uis ri vino y ri tz'un chuka'. Romari' c'ac'a' vino chupan c'ac'a' tz'un nyo'ox-vi. Quiri' xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa jun k'ij richin uxlanen, ri Jesús y ri rachibila' xec'o-e chupan jun ulef ri tico'n ruvüch riq'uin trigo. Y ri rachibila' nquich'up-e pa rutza'n ri trigo. ");
INSERT INTO cakENT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pero ri achi'a' fariseos xquibij chin ri Jesús: Tatz'eta' la avachibila' rat, roma man ja tüj nyetajin nquibün. ¿Achique roma nyequich'up trigo ri k'ij re'? Ri k'ij re', k'ij richin uxlanen y man c'uluman tüj que nyesamüj, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero ri Jesús xbij cheque: ¿Man itz'eton tüj c'a rix ri tz'iban can pari' ri xquibün ri David y ri ye rachibila', chupan ri ojer can tiempo, tok juis xenum quipan y manak quivay? ");
INSERT INTO cakENT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ri David xbe c'a chucanoxic vüy chiri' pa racho ri Dios. Y ri nimalüj sacerdote chupan ri tiempo ri' ja ri jun sacerdote rubi' Abiatar. Y ja ri lok'olüj tak caxlan-vüy ri xbejach-pe chin. Y ri caxlan-vüy ri' man xe tüj c'a ri David ri xc'ux, man quiri' tüj, y xuya' chuka' cheque ri rachibila'. Y riq'uin ri' man mac tüj ri xquibün. Y ri' xaxe ri sacerdotes c'o quik'a' chin. ");
INSERT INTO cakENT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Y ri Jesús xbij chuka' cheque: Ri k'ij richin uxlanen xban chin nye'uxlan ri vinük y man ja tüj ri vinük xeban chin ri k'ij richin uxlanen. ");
INSERT INTO cakENT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Rix c'uluman c'a que nivetamaj que ja yin ri xinalüx ch'icojol, ri Rajaf ri k'ij richin uxlanen. Pa nuk'a' yin c'o-vi richin ninbij achique utz nban chupan ri k'ij ri', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Y ri Jesús y rachibila' xe'apon chic c'a pa ri jay ape' ntzijos-vi ri rutzij ri Dios. Y chiquicojol ri vinük ri quimolon-qui' chiri', c'o c'a jun achi chaki'j jun ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pero yec'o c'a ri ye quinachajij-apu richin ri Jesús, k'alüj ri', si nuc'achojrisaj ri achi, richin quiri' nyesujun chirij ri Jesús que xsamüj chupan ri k'ij richin uxlanen ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Y ri Jesús xbij chin ri achi chaki'j ri ruk'a': Cac'o pa nic'aj, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Y ri Jesús xbij cheque ri vinük ri yec'o chiri': Yin ninjo' c'a ninc'utuj chive: ¿Más comi utz que nban ri utz pa jun k'ij richin uxlanen o ri itzel? ¿Ri ncol jun vinük chuvüch ri camic o ri ncamsüs? ¿Achique nibij rix? xbij cheque. Pero conojel nijun xech'o. ");
INSERT INTO cakENT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","C'ateri' ri Jesús xutz'et-apu quivüch conojel ri quimolon-qui' chiri', y xerutz'et man ncajo' tüj nquitakej. Romari' rija' juis xbison, y xcatüj royoval. C'ateri' rija' xbij c'a chin ri achi chaki'j ri ruk'a': Tayuku' la ak'a'. Y ri achi xe xuyuk ri ruk'a', jari' xchojmir. ");
INSERT INTO cakENT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Y ri achi'a' fariseos xe xquitz'et ri', jari' xbequimolo-qui' quiq'uin ri ye ruvinak ri rey Herodes, richin nquinuc achique nquibün roma ncajo' nquicamsaj ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Y ri Jesús xbe c'a chuchi' ri lago Galilea, ye rachibilan-e ri rachibila'. Ri Jesús xtzekelebüs c'a coma juis vinük ri aj chiri' pa ruch'ulef Galilea, y coma ri vinük ri xepu'u pa ruch'ulef Judea. ");
INSERT INTO cakENT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Rija' xtzekelebüs c'a coma ri vinük ri xepu'u pa Jerusalén, ri jun tinamit ri c'o chuka' chila' pa Judea. Ri vinük ri xetzekleben richin rija' yec'o c'a ri xepu'u pa ruch'ulef Idumea, yec'o chuka' xepu'u c'a lojc'an chic ri rakün-ya' Jordán. Xtzekelebüs chuka' coma ri vinük ri xepu'u pa tinamit Tiro y Sidón y ri xepu'u chuka' chiquinakaj ri ca'i' tinamit ri'. Conojel c'a ri vinük ri xe'apon riq'uin ri Jesús, xepu'u roma cac'axan c'a pe ri milagros nyerubanala' ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Y roma c'a ye q'uiy ri vinük nye'apon riq'uin, ri Jesús xbij cheque rachibila' que tiquiya-pe jun canoa chiri' nakaj, richin que si ri vinük juis nquipitz', rija' ntoc c'a chupan ri canoa ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ri Jesús ye q'uiy-vi c'a ri ye ruc'achojrisan chic. Pero roma conojel c'a ri ye yava'i' ncajo' chuka' que nyec'achojrisüs roma ri Jesús, romari' nquimajla' c'a qui' pari', richin nquitz'om-apu ri rutziek y nyec'achoj ta chin ri quiyabil. ");
INSERT INTO cakENT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Y ri itzel tak espíritu tok nquitz'et c'a ri Jesús, nquixucubala' c'a qui' chuvüch y riq'uin c'a cuchuk'a' nyech'o y nquibij: Ja rat ri Ruc'ajol ri Dios, nquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero ri Jesús nubila' c'a cheque que man tiquik'alajrisaj que ja rija' ri Ruc'ajol ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ri Jesús xjote' c'a e pari' ri juyu' y chiri' xerucha' y xeroyoj-apu ye q'uiy achi'a'. Y ri achi'a' ri' xebe c'a riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ye doce c'a ri xerucha' chin nyetzeklebej y richin chuka' nyerutük-e nyetzijoj ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Y quiri' chuka' xuya-e cuchuk'a' cheque richin nyequic'achojrisaj yava'i', y chin quelesaj-e itzel tak espíritu. ");
INSERT INTO cakENT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ri ye doce ri xerucha' ri Jesús, ja ri Simón ri xbij chuka' Pedro chin. ");
INSERT INTO cakENT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ri Jacobo y ri Juan, ri ye ruc'ajol ri Zebedeo, ri xquibij chuka' Boanerges cheque. Ri bi'aj ri' ntel chi tzij que juis nyek'ajan. ");
INSERT INTO cakENT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ri Andrés, ri Felipe, ri Bartolomé, ri Mateo, ri Tomás, ri Jacobo ri ruc'ajol ri Alfeo, ri Tadeo, ri Simón ri c'o quiq'uin ri achi'a' ri nbix cananista cheque, ");
INSERT INTO cakENT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y ri Judas Iscariote ri xc'ayin richin ri Jesús. Ri Jesús y rachibila' xebe pa jun jay. ");
INSERT INTO cakENT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pero roma c'a juis ye q'uiy vinük ri xquimol chic apu qui' jun bey, rije' man xetiquer tüj xquiva'. ");
INSERT INTO cakENT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Y ri ye roxpochel ri Jesús xquinabej-pe. Y xe'apon chin nyequic'ama-pe, roma rije' xquinuc que ri Jesús ntel loco. ");
INSERT INTO cakENT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés ye petenük pa tinamit Jerusalén, yec'o-apu ape' c'o-vi ri Jesús. Y nquitzijola' chiquivüch que ri Jesús c'o ri Beelzebú riq'uin, ri cajaf ri itzel tak espíritu. Y ja ri Beelzebú ri ruyo'on ruchuk'a' ruk'ij chin nyerelesaj ri itzel tak espíritu. ");
INSERT INTO cakENT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Y romari' ri Jesús xeroyoj c'a, y xbij cheque riq'uin ejemplos. Rija' xbij c'a cheque: ¿Achique rubanic que ri itzel-vinük ja rija' nye'elesan-e ri rusamajela'? ");
INSERT INTO cakENT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Roma si ri vinük richin jun ruch'ulef ca'i' quivüch nquibün, npu'u oyoval chiquicojol. Y re' man utz tüj roma nbün chin ri quiruch'ulef que ntzak. ");
INSERT INTO cakENT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Y quiri' chuka' chupan jun jay, si ca'i' quivüch ri vinük, man utz tüj, manak modo nquic'uaj ta chic qui' junan. ");
INSERT INTO cakENT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Y romari' ri itzel-vinük man utz tüj nbün oyoval quiq'uin ri rusamajela'. Man utz tüj nbün oyoval chirij rija' mismo. Roma si quiri' nbün, ruyon nc'uje' can y chanin ntzak. ");
INSERT INTO cakENT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Quiri' chuka' si jun nrajo' nelek'-e pa racho jun achi juis ruchuk'a', ri nabey nc'atzinej nbün chin ri achi ri', ja ri tuxima' y c'ateri' c'a tucanoj-e ronojel ri nrajo' nyeruc'uaj. ");
INSERT INTO cakENT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","Y tivac'axaj c'a utz ri tzij ri ninbij chive vocomi. Ri nyok'on chin ri Lok'olüj Espíritu, man ncuyutüj tüj rumac, xa nrakalej rumac richin chi jumul. Y ri ch'aka chic mac ri nyequibanala' ri vinük ri ye alaxnük chuvüch ri ruch'ulef ri' nyecuyutüj-vi. Y quiri' chuka' ronojel ri itzel tak tzij ri nyequibila' richin nquiyok' rubi' ri Dios, ri' nyecuyutüj-vi chuka' tzij ri nyequibila' richin nquiyok' rubi' ri Dios, ri' nyecuyutüj-vi chuka'. ");
INSERT INTO cakENT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ri Jesús xbij c'a quiri' cheque ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés, roma rije' xa nquibij c'a chirij rija' que c'o itzel espíritu riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Y ri rute' y ri ye ruchak' ri Jesús xepu'u c'a ape' c'o-vi rija'. Pero man xe'oc tüj apu riq'uin. Xaxe xquitük rubixic chin que ncajo' nyech'o chin. ");
INSERT INTO cakENT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Y ri vinük ri ye tz'uyul-apu riq'uin ri Jesús xquibij c'a chin: Ri ate' y ri ye achak' rat coyoben chuvüch ri jay, y ncajo' nyech'o aviq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero ri Jesús xbij c'a cheque ri vinük quimolon-qui' riq'uin: ¿Achique ninuc rix, achique c'a ri nte' y ri ye nchak'? ");
INSERT INTO cakENT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Y ri Jesús xerutz'et-apu c'a conojel ri ye tz'uyul-apu riq'uin y xbij cheque: Ja rije' ri ye c'unük nte' y nchak'. ");
INSERT INTO cakENT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Roma conojel ri nquibün ri rurayibül ri Dios, jari' ri nye'oc nte', vana' y nchak', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Y ri Jesús ye rachibilan ri rachibila' xbe chic c'a chuchi' ri lago rubini'an Galilea y rija' nyerutijoj c'a ri vinük riq'uin ri rutzij ri Dios. Y juis ye q'uiy vinük ri xquimol-apu-qui' chin ncac'axaj. Romari' ri Jesús xoc-apu pa jun canoa chiri' pa ruvi-ya', y xtz'uye' c'a chupan. Y chiri' pan ulef chuchi' apu ri ya', yec'o c'a ri vinük ncac'axaj-apu ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ri Jesús q'uiy cosas xuc'ut riq'uin ejemplos. Rija' xbij c'a cheque: ");
INSERT INTO cakENT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Tivac'axaj c'a utz ri ninbij chive: C'o jun achi ri xbe pa jopin ija'. ");
INSERT INTO cakENT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Y tok ri achi c'o chic pa samaj, njopin ija', c'o ba' chin ri ija' pa bey xtzak-vi. Y xetobos q'uiy chico xquic'ux-e ri ija' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Y c'o ba' chin ri ija' cojol abüj xtzak-vi y chiri' xa man q'uiy tüj ri ulef c'o. Y chanin c'a xe'el-pe roma xa man pin tüj ri ulef. ");
INSERT INTO cakENT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Xa ja tok xporon-pe ri k'ij, xemayamo' ka quivüch y xecom. Roma c'a ri xa man nüj tüj benük-ka ri quixe', romari' xechaki'j-ka chanin. ");
INSERT INTO cakENT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Y c'o ba' ija' xtzak cojol q'uix. Y tok xe'el-pe, junan xeq'uiy quiq'uin ri q'uix. Pero roma ri q'uix juis xeq'uiy, xuk'ayisaj ri tico'n y man xquiya' tüj quivüch. ");
INSERT INTO cakENT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Y ri ch'aka chic c'a ija' xtzak pa jun utzilüj ulef, xe'el-pe y xeq'uiy utz. Y c'o mata xquiyala' a treinta quivüch, c'o xquiyala' a sesenta, y c'o ri xquiyala' a cien quivüch. ");
INSERT INTO cakENT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","C'ateri' ri Jesús xbij c'a: Achique ri nrac'axan, trac'axaj c'a ri xinbij, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Y tok xcanaj can ruyon ri Jesús quiq'uin ca'i'-oxi' vinük y ri ye doce quitzekleben rija', ri yec'o riq'uin xquic'utuj c'a chin achique c'a ri nrajo' nbij cheque riq'uin ri ejemplo ri xutzijoj cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Y rija' xbij cheque: Ni jun bey bin can jabel achique rubeyal cheque ri vinük riq'uin ronojel cánima nye'oc pa ruk'a' ri Dios, pero chive rix yo'on c'a k'ij que nivetamaj. Pero chiquivüch ri vinük ri man yec'o tüj viq'uin, riq'uin ejemplos ninbij cheque, ");
INSERT INTO cakENT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","chin nquitz'et utz y ncac'axaj utz pero man nk'ax ta cheque, chin quiri' man nquitzolij tüj pe quic'u'x, y man ncuyutüj tüj chuka' quimac roma ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Y ri Jesús xbij chic c'a jun bey cheque ri ca'i'-oxi' vinük y ri rachibila': ¿Man xk'ax ta comi chive ri ejemplo ri c'ate ba' xinbij chive? Roma si man xk'ax ta chive, ¿achique modo nk'ax chive ri ch'aka chic ejemplos? ");
INSERT INTO cakENT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Riq'uin ri jun ejemplo re' ninc'ut c'a que ri xbejopin ija', jari' ri samajel ri ntzijon ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ri ba' ija' ri xtzak pa bey, cachi'el ri vinük tok cac'axan chic ri rutzij ri Dios, y ri itzel-vinük junanin napon qui'quin y nrelesaj-e ri tzij ri' pa tak cánima. ");
INSERT INTO cakENT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ri ija' ri xtzak can cojol tak abüj, jari' cachi'el ri rutzij ri Dios ri nac'axüx coma ri vinük. Ri vinük ri' juis c'a nyequicot tok nquic'ul ri rutzij ri Dios pa tak cánima. ");
INSERT INTO cakENT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero roma c'a ri man nc'uje' tüj ka ruxe' jabel ri rutzij ri Dios pa tak cánima, man nlayuj tüj ri quiquicot, xa jun ca'i-oxi' oc k'ij ri utz yec'o riq'uin ri Dios. Y tok npu'u pokonül y nye'etzelüs roma quiniman ri rutzij ri Dios, nyetzak can chanin. ");
INSERT INTO cakENT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Y ri ija' ri xetzak can cojol tak q'uix jari' cachi'el ri rutzij ri Dios ri nac'axüx coma ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero ri vinük ri' roma xa ja ri rayibül c'o chuvüch ri ruch'ulef nquinuc, nujik' c'a ri rutzij ri Dios ri c'o quiq'uin. Nujik' pa ruk'a' ri beyomül ri cachi'el xa c'o utz nc'uje' nk'alajin y xa man quiri' tüj. Y q'uiy chuka' ruvüch rayinic nyepu'u quiq'uin, romari' ri vinük ri' man jun bey c'a nquic'uan jun utzilüj c'aslen y nyeq'uiy chupan ri rutzij ri Dios y romari' ye q'uiy ch'aka chic nyetaken ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Y ri ija' ri xetzak pa jun utzilüj ulef, jari' cachi'el ri rutzij ri Dios ri nac'axüx ri vinük, y ri vinük ri' nquic'ün ri rutzij ri Dios y nquic'uan jun utzilüj c'aslen y nyeq'uiy chupan ri rutzij ri Dios y romari' ye q'uiy ch'aka chic nyetaken ri rutzij ri Dios. Nquic'uan jun utzilüj c'aslen y nyeq'uiy chupan ri rutzij ri Dios y romari' ye q'uiy ch'aka chic nyetaken ri rutzij ri Dios c'a cachi'el nquibün ri ija'. Roma yec'o mata nquiya' c'a treinta quivüch, yec'o nquiya' a sesenta quivüch y yec'o a cien quivüch nquiya'. Quiri' c'a nbün quic'aslen ri vinük ri nquic'ün ri rutzij ri Dios pa tak cánima. ");
INSERT INTO cakENT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Y ri Jesús xbij c'a chuka' cheque: Tok nic'ün-pe jun k'ak' chin sük nbün pa jay, ¿chuxe' comi cajón o chuxe' comi ch'at nc'uje-vi? Man quiri' tüj. Ri k'ak' chin sük c'o ruc'ojbül chin ntzu'un-vi, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Quiri' chuka' man nijun achique evan can, o tz'apin rij ri man ta nbek'alajin-pe. Y chuka' man nijun ri tz'apin can rij, ri xa man ta nbek'alajrisüs-pe y ntelesüs pa sük. ");
INSERT INTO cakENT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ri achique ri nrac'axan, trac'axaj c'a ri xinbij, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Y ri Jesús xbij chuka' cheque ri vinük: Tok rix nivac'axaj ri rutzij ri Dios, tivac'axaj c'a utz ri nbij. Tapon-ka pa tak ivánima, roma xa cachi'el nivac'axaj xa quiri' chuka' nivetamaj y riq'uin ba' chic nutz'aküt-ka. ");
INSERT INTO cakENT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Roma ri c'o ruyacon pa ránima, nuc'ul más. Jac'a ri nrac'axan ri rutzij ri Dios y xa man nuyüc tüj ka pa ránima, ri jaru' oc c'o riq'uin nabey, ri' ntelesüs-e chin. ");
INSERT INTO cakENT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Y ri Jesús xbij chuka': Tok ri vinük nye'oc pa ruk'a' ri Dios, nbanatüj c'a cachi'el nbanatüj riq'uin jun ija' ri nutic can roma jun achi pan ulef. ");
INSERT INTO cakENT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Y tok ri ija' c'o chic c'a can pan ulef, ri ticoy man jun chic ri nbün. Rija' nvür c'a tok ntoc-ka ri ak'a' y ncatüj-e tok nsaker-pe ri ruca'n k'ij. Y tok napon ri k'ij, ri ija' nbos-pe y nq'uiy-e, pero ri xticon-ka chin ri ija' man retaman tüj achique rubeyal, y chuka' man ntiquer tüj nbij achique rubeyal tok ri ija' nbos-pe y achique rubeyal tok nq'uiy. ");
INSERT INTO cakENT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ri ticoy man nijun nbün chin que ri tico'n nq'uiy-pe roma ri tico'n xa ruyon nq'uiy-pe roma ri ulef jabel ruchuk'a'. Pero nabey ja ral ri trigo nq'uiy-pe. Y tok nim chic, ja nc'uje-ka ruvüch. Y pa ruq'uisbül nunoj c'a pe ri ruvüch riq'uin ri rupan. ");
INSERT INTO cakENT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Y tok k'ün chic, ri rajaf jari' nyerutük ri rusamajela' chupan, chin nquik'üt, roma ja tiempo ri' chin ri k'atoj. ");
INSERT INTO cakENT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Y ri Jesús xbij c'a chuka': ¿Achique nkabij pari' ri rubanic tok ri vinük nye'oc pa ruk'a' ri Dios? ¿O achique ta choj riq'uin nkajunimaj ri'? ¿Y achique ta comi ejemplo ri nk'alajrisan chin? ");
INSERT INTO cakENT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Xa junan nbün riq'uin semilla richin ri mostaza ri nitic-ka pan ulef. Y xa jari' ri semilla ri más cocoj ri c'o chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero jari' ri más nim ntel chiquivüch achique na ichaj, y nyec'uje ruk'a' ye nimak'. Romari' ri chico aj pa k'ayis nquibanala' quisoc pa tak ruk'a', roma chiri' jabel nyemujan. ");
INSERT INTO cakENT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ri Jesús tok xutzijoj ri rutzij ri Dios cheque ri vinük, xerucusaj ejemplos hasta ape' na nk'ax cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Rija' xaxe c'a riq'uin ejemplos xch'o cheque ri vinük. Pero tok quiyon can, rija' nbij c'a cheque rachibila' achique rubeyal. ");
INSERT INTO cakENT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Y tok xoc c'a pe ri ak'a' chupan ri k'ij ri', ri Jesús xbij cheque rachibila': Jo' lojc'an chic ri lago rubini'an Galilea, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Comi ja xq'uis, ya c'o modo nyixbe, xbij cheque ri ch'aka chic vinük. Y rija' c'o chic pa canoa y rija' y ri rachibila' xquitz'om-e bey pari' ri ya'. Y yec'o chuka' ch'aka chic canoas junan xebe. ");
INSERT INTO cakENT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Y tok quitz'amon c'a bey, xpu'u jun nimalüj cakik' chiri' pari' ri ya'. Y romari' bama xnoj ri canoa riq'uin ya'. Ba' ta chic nyebe chuxe' ya'. ");
INSERT INTO cakENT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero ri Jesús nvür c'a chupan ri canoa tok ntajin ri cakik' pari' ri ya'. Rija' chirij ri canoa rucanon-ka jun ruch'acat rujolon, y chiri' nvür benük. Y xepu'u c'a rachibila', xquic'asoj y xquibij c'a chin: ¡Maestro! ¡Maestro! Roj ya mero nkucom y rat xa ncavür, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Y ri Jesús xcatüj c'a pe, y xbij: Tiq'uis-e ri cakik' y titane' ri ya' nbolko't. Y quiri' xbün. Ri cakik' xq'uis-e, y chuka' ri nbolko't ri ya' xtane-ka. ");
INSERT INTO cakENT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","C'ateri' ri Jesús xbij cheque: ¿Achique roma tok xixbij-ivi'? Nc'atzinej que nquiya' más ri ivánima viq'uin yin. ");
INSERT INTO cakENT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero ri rachibila' juis quixbin-qui' y xquic'utula' c'a chiquivüch: ¿Achique c'a chi achi re'? Roma ri cakik' y ri ya' nquitakej chuka' rutzij. ");
INSERT INTO cakENT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Y ri Jesús y ri rachibila' xe'apon c'a ri lojc'an ruchi' ri lago Galilea, chiri' pa jun lugar rubini'an Gadara. ");
INSERT INTO cakENT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Y tok ri Jesús xka-ka chupan ri mama' canoa, jari' tok xapon jun achi riq'uin. Jun achi ri ape' ye mukux ri caminaki' elenük-vi-pe, roma ri achi ri' xa c'o c'a itzel espíritu riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ri achi ri' ja ri ape' ye mukux ri caminaki' ri c'unük racho, y rija' nixta ri cadena man ntiquer tüj chin nuximox, roma juis ruchuk'a'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Q'uiy mul ye quiximilon ri ruk'a'-rakün riq'uin ch'ich' y riq'uin chuka' cadena, pero xa ye ruk'ajon y ye ruk'ach'in can. Man jun c'a ri tiquernük riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rija' xa ronojel tiempo nbiyin pa tak k'ayis o juyu' chiquicojol ri ape' ye mukun caminaki', nsiq'uin y nusocola-ri' riq'uin abüj. Chi pak'ij chi chak'a' c'a ri nbanala' quiri' ri achi ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Y tok rija' xutz'et-pe ri Jesús chi nüj, junanin xpu'u y xxuque' chuvüch y xuya' ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Y riq'uin ruchuk'a' xch'o chin ri Jesús y xbij c'a: Rat Jesús ri Ruc'ajol ri nimalüj Dios, ¿achique roma tok nquinanük? Pa rubi' ri Dios ninc'utuj chave, que man quinaya' pa k'oxomül, xbij chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ri achi xbij quiri' roma ri Jesús rubin chic c'a chin ri itzel espíritu ri c'o riq'uin ri achi ri' que tel-e. ");
INSERT INTO cakENT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Y xpu'u ri Jesús xuc'utuj c'a chin: ¿Achique abi'? Y rija' xbij chin: Roj Legión ri nubi', roma roj q'uiy chikakün rojc'o chupan ri achi. (Jun Legión ri rubi' seis mil soldados romanos.) ");
INSERT INTO cakENT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Y juis c'a xuc'utuj chin ri Jesús que tubana' favor man querelesaj-e chupan ri ruch'ulef ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Y chunakaj apu ri lugar ri', chunakaj pa rujolon jun juyu', ye q'uiy ak nyeva'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Y xepu'u c'a conojel ri itzel tak espíritu ri yec'o riq'uin ri achi, xquic'utuj favor chin ri Jesús. Y xquibij c'a chin: Taya' k'ij cheke richin nkujoc quiq'uin ri ak yec'o chila'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Y ri Jesús jari' xbij cheque que utz. Y ri itzel tak espíritu jari' xe'el-e y xebe'oc quiq'uin ri ak. Ri ak ri' ye q'uiy chicakün. Yec'o la'ük ca'i' mil. Y conojel ri ak ri' xepu'u junanin pa xulan, chuvüch jun juyu' pa'ül ruvüch, y jic' xebe-ka pa ya'. Conojel ri ak ri' xejik' c'a pa ya'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Y jari' tok ri nyeyek'un quichin ri ak ri', xe c'a xquitz'et can ri xbanatüj, xe'anmüj-pe y xquiya' rutzijol pa tinamit y pa k'ayis chuka'. Y ri vinük xepu'u c'a richin nquitz'eta' ri xbebix can cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Y tok ri vinük ri' xe'apon riq'uin ri Jesús, xquitz'et c'a que ri achi ri xec'uje' itzel tak espíritu riq'uin, tz'uyul, rucusan rutziek y man nbün tüj chic c'a ri cachi'el ri rubanun-pe. Xa xuc'achojnük chic. Pero ri vinük ri' xa xquixbij-qui' tok xquitz'et ri achi ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ri vinük c'a ri quitz'eton can ri banatajnük richin ri achi ri xelesüs itzel tak espíritu riq'uin y ri xbanatüj quiq'uin ri ak, xquitzijola' c'a cheque ri vinük ri ye petenük chutz'etic ri xbanatüj chiri'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Roma c'a ri' ri vinük xquic'utuj favor chin ri Jesús que tel-e chupan ri quiruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Y tok ri Jesús ya njote' pa canoa, y ri achi ri xec'uje' itzel tak espíritu riq'uin, xuc'utuj c'a favor chin ri Jesús chin tuya' k'ij chin richin nbe riq'uin rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero ri Jesús man xrajo' tüj. Xa xbij c'a chin: Catzolij chi'avacho, y tatzijoj cheque ri ye avoxpochel que xe'elesüs ri itzel tak espíritu aviq'uin, roma xjoyovüx avüch roma ri Ajaf. ");
INSERT INTO cakENT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Y ri achi xbe c'a y xutz'om rutzijosic ri xbün ri Jesús chin rija'. Y rija' xutzijoj c'a cheque ri vinük ri yec'o pa ri lugar rubini'an Decápolis. Y ri vinük xsatz quic'u'x y xenucun pari' ri ruc'aslen ri jun achi ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Y ri Jesús y rachibila' xe'oc chic e pa canoa richin que xec'o c'a la lojc'an chic ruchi' ri lago Galilea. Y tok xe'apon yan la lojc'an chic ruchi' ri ya, juis ye q'uiy vinük ri xquimol-qui' riq'uin. Rija' chunakaj ri mar xc'uje-vi. ");
INSERT INTO cakENT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Xapon c'a chuka' jun achi rubini'an Jairo. Ri achi ri' c'o jun rusamaj chupan ri jay ape' ntzijos-vi ri rutzij ri Dios. Ja rija' jun nabey chiquivüch ri samajel chiri'. Y tok ri Jairo xutz'et-apu ri Jesús, jari' xbexuque' chuvüch ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Y c'ateri' rija' xbij c'a chin ri Jesús: Ri alaj numi'al yava', y ya ja ncom. Tabana' favor taya' ri ak'a' pari' richin ncolotüj chuvüch ri camic y nc'ase' can, xbij ri achi. Y juis xuc'utuj favor chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Y ri Jesús xbe c'a. Y ye q'uiy chuka' vinük xebe-e chiquij. Y roma juis q'uiy vinük, man nyebiyin tüj utz roma quipitz'-qui'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Y c'o jun ixok benük chiquicojol ri vinük yava' riq'uin chi ntel ruquiq'uel ya ruc'uan doce juna'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Y rija' ya mani chic riq'uin ri k'oxomül roma benük quiq'uin q'uiy ak'omanela' roma xuq'uis rutumin. Y xa man jun nuc'ach'ojrisaj. Xa más jumul nbün c'a. ");
INSERT INTO cakENT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ri ixok re' xrac'axaj rutzijol ri Jesús ri nyerubün cheque ri yeva'i', y xbobos chirij ri Jesús y xc'o chiquicojol ri vinük ri yec'o can chirij ri Jesús, y rija' xbetz'ama' ba' ri rutziek ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Roma ri ixok ri' rubin pa ránima: Xa riq'uin ta ba' nintz'om rutziek ri Jesús yin nquic'achoj-e, rubin pa ránima ri ixok ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Y jari' c'a chanin xc'achoj ri ruyabil. Rija' xuna' c'a que xc'achoj can ri ruyabil ri ruchajin. ");
INSERT INTO cakENT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ri Jesús chanin c'a xuna' que c'o jun xuc'achojrisaj riq'uin ri ruchuk'a' ruk'ij ri ruchajin. Romari' xtzu'un chirij y xerutz'et conojel, y xbij cheque ri vinük: ¿Achique xutz'amon-pe ri nutziek?, xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pero ri achi'a' ri rachibila' xquibij c'a chin: Rat najo' navetamaj achique ri xtz'amon ri atziek, pero ri' man nabün tüj porque ri vinük ncatquipitz' rat, y rat nac'utuj: ¿Achique ri xintz'amon? ri xquibij chin ri Jesús ri xquitzeklebej. ");
INSERT INTO cakENT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero ri Jesús xerut'zet ri vinük, y nucanoj chiquicojol achique ri xtz'amon ri rutziek. ");
INSERT INTO cakENT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Y ri ixok ruxbin-ri' y nbarbot c'a, roma xa ja rija' ri xtz'amon ri rutziek ri Jesús, y xc'achoj riq'uin ri ruyabil. C'ateri' rija' xxuque-pe chuvüch ri Jesús y xbij c'a ronojel ri achique xbün. ");
INSERT INTO cakENT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Y ri Jesús xbij chin ri ixok: Numi'al, xac'achojnük, roma xaya' ri avánima viq'uin. Vocomi tikuquex ac'u'x y tuxulan ri avánima y catzolij. Ri ayabil ri ac'ulachin-pe man chic ntzolij tüj pe, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Y ntajin nch'o ri Jesús riq'uin ri ixok, tok yec'o vinük xe'apon riq'uin ri Jesús ri ye petenük-pe chiracho ri Jairo, ri achi ri cachi'el jun nabey chiquivüch ri samajela' yec'o pa ri jay ape' ntzijos-vi ri rutzij ri Dios. Ri achi'a' xe'apon riq'uin ri Jairo, xquibij chin: Ri alaj ami'al xa xcom yan. Man nc'atzin tüj chic nac'ün chic pe ri Maestro, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jac'a tok ri Jesús xrac'axaj-pe, chanin xbij chin ri Jairo, ri jun achi ri jun nabey chiquivüch ri samajela' pa ri jay ape' ntzijos-vi ri rutzij ri Dios: Man tuxbij-ri' ri avánima roma ri xquibij ri vinük chave. Taya' avánima viq'uin, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Y ri Jesús xaxe ri Pedro, y ri Jacobo y ri Juan ri ye quichak'-qui', ri xeruc'uaj-e. ");
INSERT INTO cakENT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Y ri Jesús ye rachibilan ri ye oxi' rachibila' xebe c'a chiracho ri achi ri jun nabey chiquivüch ri samajela' chiri' pa ri jay ape' ntzijos ri rutzij ri Dios. Y tok xe'apon, ri Jesús xerutz'et que ri vinük nyech'ujlan pa jay, y xerutz'et chuka' ri nbiyin ruya'al-quivüch y riq'uin juis cuchuk'a' nye'ok'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tok ri Jesús c'unük chic apu pa jay, xbij cheque ri vinük: ¿Achique roma nyixok' y nyixch'ujlan? Ri ac'ual man camnük tüj, xa nvür, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero rije' xa xetze'en chirij ri Jesús, roma quetaman que ri ac'ual xa camnük chic. Pero ri Jesús xbün cheque ri vinük que xe'el-pe. C'ateri' rija' xerucusaj-apu ri rute-rutata' ri alaj xtün y ri oxi' rachibilan, chupan ri jay ape' c'o-vi ri ruch'acul ri alaj xtün. ");
INSERT INTO cakENT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Rija' xutz'om ri ruk'a' ri alaj xtün ri camnük chic y xch'o pa jun chic ch'abül, y xbij: Talita, cumi, xbij. Ri tzij re' nbij c'a: Alaj xtün, chave rat ninbij-vi que cacatüj. ");
INSERT INTO cakENT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Xaxe xbij quiri' ri Jesús, jari' xcatüj y xbiyin-e ri alaj xtün, roma xa doce chic rujuna'. Y ri yec'o riq'uin, xsatz quic'u'x tok xquitz'et que xuc'ase' chic chiquicojol ri caminaki'. ");
INSERT INTO cakENT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero ri Jesús juis xuchilabej cheque: Man tiquelesaj rutzijol. Xaxe tisuju' y tiya' ruvay ri xtün, xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Y ri Jesús ye rachibilan ri rachibila' xe'el-e chiri' y xebe pa Nazaret ri tinamit ape' xq'uiy-vi rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Y tok xapon ri k'ij richin uxlanen, rija' xutijoj ri rutzij ri Dios pa ri jay ape' ntzijos ri rutzij ri Dios. Y roma ri tzij ri nyerubij cheque, ri vinük ri quimolon-qui' chiri', xe' xquica'yej c'a tok xcac'axaj, y xquibij: ¿Jari' c'a retaman ronojel la'? ¡Y ntiquer nbün milagros! ¿Jaru' c'a ntiquer nbün ronojel re'? ");
INSERT INTO cakENT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Roma ri achi re', xa jare' ri samajiy-che' (carpintero), ral ri María, quinimal ri Jacobo, ri José, ri Judas y ri Simón. Y ri rana' xa chikacojol roj yec'o-vi, xquibij. Romari' ri vinük nixta ba' xquitakej tüj ri Jesús, roma rija' aj-chiri' pa quitinamit. ");
INSERT INTO cakENT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Y ri Jesús xbij c'a cheque ri vinük ri': Conojel c'a ri nyek'alajrisan ri tzij ri bin cheque roma ri Dios, man ni jun c'a quik'ij pa quitinamit pero ri' xaxe chiquivüch ri vinük aj pa rutinamit, chiquivüch ri roxpochel y chiquivüch chuka' ri aj pa racho, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Y chupan ri rutinamit, ri Jesús man q'uiy tüj milagros xtiquer xbün. Xaxe oc ca'i-oxi' yava'i' ri xuya' ruk'a' pa quivi' richin xeruc'achojrisaj. ");
INSERT INTO cakENT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Y rija' xsatz ruc'u'x roma xerutz'et que ri vinük ri aj chiri' pa rutinamit, que xa man xquiya' tüj cánima riq'uin. Rija' xbe c'a pa tak cocoj tinamit ri yec'o-pe chunakaj ri rutinamit. Rija' xuc'ut c'a ri rutzij ri Dios chiquivüch ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","C'ateri' ri Jesús xeroyoj c'a ri doce rachibila'. Y xuya' quisamaj y xerutük-e chin ri samaj, y xuya' cuchuk'a' quik'ij cheque chin nyetiquer nyequelesaj ri itzel tak espíritu. ");
INSERT INTO cakENT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Y rija' xbij c'a chuka' cheque que xaxe ri quich'ami'y tiquic'uaj-e y man jun chic tiquic'uaj. Man tiquic'uaj vit ya'l achique nquiya-e chupan, man tiquic'uaj vüy, nixta tumin tiquic'uaj. ");
INSERT INTO cakENT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Man tiquicusaj-e ca'i' quitziek. Pero utz que nquicusaj-e quixajab. ");
INSERT INTO cakENT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ri Jesús xbij chuka' cheque ri rachibila': Achique na tinamit nyixapon-vi tok nyixoc pa jun jay, chiri' quixc'uje-vi hasta que nyixel-e chupan ri tinamit ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Y tok nyixapon-vi quiq'uin ri vinük y man ncajo' tüj nyixoc pa cacho chin nyixc'uje' quiq'uin chin nitzijoj ri rutzij ri Dios cheque, y man xcajo' tüj ncac'axaj ri rutzij ri Dios ri nitzijoj rix cheque, quixel-e chiri' y titotala' can ri pokolaj ri c'o pa tak ivakün chiquivüch ri vinük richin tiquitz'et man utz tüj xquibün. Ninbij chive, que chupan ri k'ij chin ri juicio pari' ri ruch'ulef, ri castigo nobos más nim pari' ri vinük ri man nyixquic'ul tüj utz, que chuvüch ri xc'ulachij ri tinamit Sodoma y Gomorra, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Y ri rachibila' ri Jesús xebe c'a. Rije' xquibij c'a cheque ri vinük que tiquitzolij-pe quic'u'x riq'uin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Y ri rachibila' q'uiy itzel tak espíritu xequelesala'. Y chuka' xquiyala' aceite olivo pa quijolon ye q'uiy yava'i', y xequic'achojrisaj can. ");
INSERT INTO cakENT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ri rey rubini'an Herodes xrac'axaj c'a que ri Jesús jaru' la rutzijol petenük chiquicojol ri vinük. Pero ri Herodes xbij-ka pa ránima: Ri Jesús re' xa ri Juan Bautista xc'astüj chic pe chiquicojol ri caminaki', y roma c'a ri' c'o ruchuk'a' ruk'ij y ntiquer nyerubanala' milagros, xbij-ka ri Herodes. ");
INSERT INTO cakENT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero ch'aka vinük xquibij que ri Jesús xa ja ri' ri Elías. Y yec'o ch'aka chic xquibij que rija' jun achi ri nk'alajrisan ri nbix chin roma ri Dios y chuka' xquibij que rija' jun cheque ri ch'aka chic achi'a' ri xek'alajrisan ri rutzij ri Dios chupan ri ojer can tiempo. ");
INSERT INTO cakENT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero tok ri rey Herodes xrac'axaj c'a ri', xbij: Ri Jesús xa ja ri Juan Bautista ri xintük chuk'upixic rukul, y vocomi xc'astüj chic pe chiquicojol ri caminaki', xbij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Roma xa ja ri rey Herodes ri xbin que titz'om-pe ri Juan. Y c'ateri' xuya' pa cárcel y xxime' pa cadena. Ri Herodes quiri' xbün roma ri ixok ri c'o riq'uin, ri ixok rubini'an Herodías, xa rixjayil c'a ri Felipe ri ruchak' ri Herodes. Y ri Herodes ruc'amon c'a ka ri ixok ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ri Juan xtz'amatüj-pe roma ri xbin chin ri Herodes: Man utz tüj abanun que ac'amon-ka ri avixnan, ri ixok Herodías, xa rixjayil ri achak' Felipe. ");
INSERT INTO cakENT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ri ixok Herodías xrajo' xcamsaj ri Juan roma itzel nuna' chin, pero xa roma man pa ruk'a' tüj rija' c'o-vi, romari' man tiquernük tüj riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ri rey Herodes retaman-vi que ri Juan jun achi utz, choj ruc'aslen y lok'olüj chin ri Dios. Y nuxbij-ri' chuvüch. Más que nbün cuenta nuchajij chin man nijun nuc'ulachij. Rija' xa jabel utz ri nrac'axaj ri rutzij ri Dios ri nbij ri Juan chin. Pero rija' man xunucun tüj achique ri c'uluman que nbün. ");
INSERT INTO cakENT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Y ri ixok Herodías royoben chic ri k'ij chin ntzak ri Juan pa ruk'a'. Y xapon ri k'ij tok ri rey Herodes xtz'aküt chic jun juna' y xbün jun nimak'ij y xuya' jun va'in. Y xeroyoj ri achi'a' ri c'o quik'ij ri nyesamüj riq'uin rija' y ri achi'a' ri nquibün mandar pa quivi' ri nyebanun oyoval y ri achi'a' ri c'o q'uiy quik'ij chiquicojol ri vinük aj-Galilea. ");
INSERT INTO cakENT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Y ri ape' quimolon-qui' conojel chupan ri nimak'ij, xoc-apu jun xtün ral ri Herodías. Y xxajo' chiquivüch ri vinük nyeva' chiri'. Y ri rey Herodes xka' chin y conojel ri yec'o chiri'. Y ri rey Herodes xbij chin ri xtün: Tac'utuj chuve achique najo' y ninya' chave. ");
INSERT INTO cakENT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ninbün jurar chavüch, que achique na ri nac'utuj chuve, ninya' chave, stape' (aunque) nic'aj ri ruch'ulef ri c'o pa nuk'a', xbij ri rey Herodes chin ri ral ri Herodías. ");
INSERT INTO cakENT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pero ri xtün, xe xrac'axaj ri xbij ri rey Herodes chin, xel-e y xberubij chin ri rute': ¿Achique ta ninc'utuj yin chin ri rey Herodes? Roma rija' xbij chuve que achique na ri ninjo' nuya' chuve, xbij ri xtün chin ri rute'. Y xpu'u ri te'ej xbij chin ri ral: Tac'utuj que ticamsüs ri Juan Bautista y ja ri rujolon titzaq'uis-e y tic'amox-pe chave. ");
INSERT INTO cakENT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Y ri xtün chanin xtzolij-apu riq'uin ri rey Herodes y xberubij chin: Yin ninjo' que vocomi yan nacamsaj ri Juan Bautista y ri rujolon pa jun lük naya-pe chuve, xbij chin ri rey Herodes. ");
INSERT INTO cakENT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Y ri rey Herodes xpu'u juis bis pa ránima romari', pero roma rubanun jurar chin que nuya-vi ri nrajo' y roma chuka' rubin chic chiquivüch ri achi'a' ri xerumol richin ri va'in pa racho man nrajo' tüj nbij chin que man nbün tüj ri nc'utux chin. ");
INSERT INTO cakENT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Y ri rey jari' c'a xutük-e jun soldado chin tuc'ama-pe ri rujolon ri Juan ri Bautista. ");
INSERT INTO cakENT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Y ri soldado xbe c'a. Rija' xberutzaq'uij-pe chuxe' rujolon ri Juan Bautista chiri' pa cárcel. Y xuc'ün-pe ri rujolon ri Juan. Xuya-pe pa jun nim lük y xuya' chin ri xtün. Y xbe ri xtün, xuya' chin rute'. ");
INSERT INTO cakENT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tok ri rachibila' ri Juan xcac'axaj que xcamsüs, xebe xquic'ama' ri ruch'acul, y xebe xquimuku'. ");
INSERT INTO cakENT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ri achi'a' ri nyerutakon ri Jesús pa rusamaj ri Dios xetzolij-pe y xquimol-qui' chic riq'uin ri Jesús. Y xquitzijoj ronojel ri xquibanala' y ri tzij ri xquic'ut chiquivüch ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Y ri Jesús xbij cheque: Jo' pa jun lugar ape' manak vinük chin nkujuxlan ba'. Y quiri' xbij cheque roma xa ye q'uiy vinük nye'el y nye'oc quiq'uin y romari' manak chic modo nyeva'. ");
INSERT INTO cakENT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Y ri Jesús y ri rachibila' xe'oc-e pa jun canoa chin nyec'o-apu lojc'an ri lago Galilea pa jun lugar ape' manak vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero tok rije' xe'el-e, ye q'uiy vinük ri xequitz'et y xquetamaj quivüch. Romari' ri vinük junanin xebe chicakün, xquimolon-qui' pa bey pa tak tinamit xec'o-vi-e. Y xa ja rije' ri xe'apon nabey. Y tok ri Jesús y ri quitzekleben xe'apon, entonces ri vinük xquimol-apu-qui' chiquij. ");
INSERT INTO cakENT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Y tok ri Jesús xeka-ka chupan ri canoa, xutz'et juis q'uiy vinük ye coyoben-apu chiri'. Xujoyovaj quivüch, roma ri quibanun, cachi'el oveja tok man nijun nuyuk'un quichin. C'ateri' xuc'ut chiquivüch, q'uiy ri nc'atzin que nquetamaj pari' ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pero tok ya xxule', ya xka-ka ri k'ij, ri rachibila' ri Jesús xquimol-qui' y xejel-apu riq'uin. Y xquibij chin ri Jesús: Chere' manak cacho vinük y ri k'ij xxule' y xka-ka yan. ");
INSERT INTO cakENT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Que'ataka' ri vinük richin nyebe pa tak cocoj tinamit y pa ch'aka chic lugar yec'o nakaj, chin nquibelok'o' quivay, roma chere' manak vüy, xquibij chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jac'a ri Jesús xbij cheque ri rachibila': Tiya' quivay rix, xbij cheque. Y rije' xquibij chin ri Jesús: ¿Rat nabij cheke roj que nkubelok' ca'i' ciento denario? (Jun denario rakalen jun ruk'ij jun achi, y ronojel ca'i' ciento k'ij samaj rakalen.) ");
INSERT INTO cakENT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Y rija' xuc'utuj c'a cheque: ¿Jaru' vüy ichajin? Titz'eta' na c'a. Y tok rije' xquitz'eta-pe, xebe y xquibij chin: C'o vo'o vüy y ca'i' cür, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","C'ateri' rija' xbij cheque ri rachibila' que tiquibij cheque ri vinük que quetz'uye' conojel pan ulef ape' c'o sabana rüx-rüx rubanun, y tiquimoquej-qui' quetz'uye'. ");
INSERT INTO cakENT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Y ri vinük ri' xetz'uye' c'a pa tak ulef ape' c'o sabana rüx, y xquimolola-qui' pa jujun ciento y pa jujun cincuenta. ");
INSERT INTO cakENT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Y ri Jesús xeruli'ej-pe pa ruk'a' ri vo'o' vüy y ri ca'i' cür, xtzu'un-e chicaj y xumatioxij chin ri Dios. Y xuvech'ela' ri vüy y ri cür, y xuya' pa quik'a' ri rachibila' chin nquijachala' cheque conojel ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Y conojel ri vinük jabel xeva', y nixta jun ri man ta jabel xva'. ");
INSERT INTO cakENT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Y tok xetzakon conojel riq'uin ri va'in, c'o doce chacüch vüy rachibilan cür ri xquimol ri man xq'uis tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Juis ye q'uiy vinük ri xeva' chiri', roma xaxe ri achi'a' ye vo'o' mil. ");
INSERT INTO cakENT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Y ri Jesús jari' tok xerucusaj-e ri rachibila' chupan ri canoa richin quenabeyüj chuvüch rija', richin quebe pa jun tinamit rubini'an Betsaida, ri c'o lojc'an ri lago. Y ri Jesús xerubün can despedir ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Y tok ri Jesús nyerubün can despedir ri vinük, rija' xbe chucojol tak juyu' chin nbün orar. ");
INSERT INTO cakENT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ri Jesús xcanaj can pan ulef, pero ri rachibila' xebe pa canoa. Ya nüj chic ye benük pari' ri ya'. Pa runic'ajal ri ya' yec'o-apu tok xoc-pe ri ak'a'. ");
INSERT INTO cakENT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Y ri Jesús xerutz'et-apu que ri rachibila' man choj tüj nbiyin ri canoa, roma ri cakik' nupaxij-ri' chuvüch ri canoa y nutzolij c'a. Y xc'o ri ak'a' pa quivi' y ya ja nsakrisan-pe chiquivüch pari' ri ya' tok ri Jesús nbiyin riq'uin ri rakün pari' ri ya', y nbün cachi'el nc'o chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero tok ri rachibila' xquitz'et-apu que c'o jun petenük chirakün pari' ri ya', xquic'utula' chiquivüch riq'uin quichuk'a' que achique la'. Roma rije' xquibij que ri petenük pari' ri ya' xa jun xibinel. ");
INSERT INTO cakENT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Y roma conojel xquitz'et-apu ri', juis xquixbij-qui'. Pero ri' xa ri Jesús y rija' xch'o chanin cheque y xbij: Man tixbij-ivi'. Ja yin ri Jesús yinpetenük iviq'uin. Tic'uje ruchuk'a' ri ivánima, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Y rija' xoc-e quiq'uin pa canoa. Y ri cakik' xtane' chanin. Y ri rachibila' ri Jesús xsatz q'uiy quic'u'x. ");
INSERT INTO cakENT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pero ri achi'a' ri rachibila' ri Jesús xa c'ate ba' quitz'eton can ri nabey milagro xbün riq'uin ri vo'o' vüy, pero rije' man xk'ax ta cheque que rija' ntiquer nbün achique na, roma c'o ruchuk'a' ruk'ij. Rije' covirnük c'a ri cánima. ");
INSERT INTO cakENT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Y rije' xebe chic pari' ri ya' y xe'apon lojc'an chic ri lago pa jun lugar rubini'an Genesaret. ");
INSERT INTO cakENT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Y xe xe'el-e pa canoa y xeka-ka pari' ulef, ri vinük que quimolon-qui' chiri' chuchi' ri ya', xquetamaj-e chanin ruvüch que ja ri Jesús xka-ka pa canoa. ");
INSERT INTO cakENT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Romari' xquiyala' rutzijol cho tak jay ronojel lugar ri yec'o chiri' nakaj. Y ri vinük xequic'ün-pe ri quiyava'i', y xa ronojel lugar xec'amox-pe. Y ye q'uiy xetobos nyec'amon-pe chuvüch ri quivarabül, y xequic'uaj chin ri Jesús achique na lugar ape' ncac'axaj que c'o-vi. ");
INSERT INTO cakENT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Y achique na lugar xapon-vi, pa tak nimak' tinamit y pa tak cocoj tinamit y pa k'ayis, ri vinük xequiyala' ri yava'i' pa tak bey ape' ri nc'o ri Jesús. Juis xquic'utuj qui-favor chin ri Jesús chin tuya' k'ij cheque chin nquitz'om ba' stape' (aunque) ruchi-rutziek. Y conojel ri xquitz'om ri rutziek ri Jesús, xec'achoj can, y xel-e quiyabil. ");
INSERT INTO cakENT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Y chirij c'a ri Jesús xquimol c'a apu qui' ri achi'a' fariseos, y chuka' ca'i'-oxi' etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés ri ye petenük pa tinamit Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Y tok ri achi'a' ri' xquitz'et que yec'o cheque ri rachibila' ri Jesús ri man nquich'üj tüj jabel ri quik'a' cachi'el nquibün rije' tok nquic'ux quivay, man utz tüj xequitz'et. Roma chiquivüch rije' man ch'ajch'oj tüj ri quik'a'. Y romari' juis xech'o chiquij roma man nquibün tüj cachi'el nquibün rije'. ");
INSERT INTO cakENT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Roma ri achi'a' fariseos y conojel ri ch'aka chic vinük israelitas, c'utun can chiquivüch roma ri quixquin-quimama' can. Y quibin can cheque achique rubanic tiquich'ajla' ri quik'a'. Y si man nquibün tüj, man nquic'ux tüj quivay. ");
INSERT INTO cakENT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tok nyetzolij-pe pa tak c'ayibül si man nquijosk'in tüj qui', man nyeva' tüj. Y c'o chic ch'aka ri nyequibanala' chuka' cachi'el ri achique quijosk'ixic ri kumbül tak ya', ri xára, ri ch'ich' tak lük, y ri achique chuka' rujosk'ixic nquibün chin ri quivarabül. Quiri' c'a ri nyequibanala' rije'. ");
INSERT INTO cakENT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Romari' xepu'u ri achi'a' fariseos y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés xquic'utuj chin ri Jesús: ¿Achique c'a roma la achi'a' la avachibila' rat man nquibün tüj cachi'el ri quibin can ri kaxquin-kamama' can? Ri avachibila' man nquich'üj tüj quik'a' pa rubanic ri quibin can ri kaxquin-kamama' can, xa man ch'ajch'oj tüj ri quik'a' tok nyeva', y man nquibün tüj cachi'el nkabün roj, xquibij chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pero ri Jesús xbij cheque ri achi'a' ri': Rix xa ca'i' ipalüj. Romari' xbij can ri Isaías chivij. Ri xbij ri Dios chin que tutz'ibaj can, nbij c'a: Ri vinük re' xaxe riq'uin ri quitzij nquiya' nuk'ij, ja ri nrajo' ri cánima xa man ja tüj ri', y nüj yec'o-vi chi nuvüch. ");
INSERT INTO cakENT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xa man jun nc'atzin-vi ri nquiya' nuk'ij, roma xa man ketzij tüj chi vinük roma ri quetemabal ri nquic'ut ri vinük man richin tüj ri Dios, xa quetamabal achi'a'. Jari' ri rutz'iban can ri Isaías. ");
INSERT INTO cakENT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Y rix jari' ri nyixtajin nibanala'. Xa iyo'on can ri rubin can ri Dios ri nibün. Pero rix man nibün tüj ri nrajo' ri Dios sino xa ja ri nquibij ri vinük chive. Jari' ri nibün rix y nyixtajin chubanic cachi'el ri nijosk'ila' ri xára y ri kumbül ri ya', y ch'aka chic cachi'el ri' nye'ibanala'. ");
INSERT INTO cakENT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Y ri Jesús chuka' xbij cheque: Rix richin nibün ri achique ye quibilon can ri kaxquin-kamama' can, iyo'on can nibün ri achique rubin can ri Dios que nibün. ");
INSERT INTO cakENT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Roma ri tzij ri ye rutz'iban can ri Moisés, nbij: Taya' quik'ij ri ate' y ri atata'. Y ri c'ateri' nbanun itzel cheque ri rute' y rutata', ja ri camic ri tika-ka pari'. ");
INSERT INTO cakENT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ja rix xa man quiri' tüj nibün y nic'ut. Xa man nibün tüj cachi'el ri rubin can ri Dios. Rix xa nye'itijoj ri ac'uala' que man nc'atzin tüj que nyequito' ri quite' y quitata'. Xa nye'el chuvüch ri' riq'uin nquibij cheque ri quite' o ri quitata': Yin man nquitiquer tüj nyixinto' riq'uin ri nc'atzin chive, roma ri nc'atzin tüj chive rix xa Corbán. Ri tzij re' nbij: Nusujun chic chin ri Dios. Y riq'uin nquibij quiri', que quisujun chic chin ri Dios ri nc'atzin tüj cheque ri quite' y quitata', man nc'atzin tüj chic chin nyequito', nibij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Y riq'uin ri nibij, nk'alajin que rix nibün cheque ri ac'uala' que man nijun tiquiya' chic cheque ri quite' y ri quitata' chin nyequito' y nyequitzuk. ");
INSERT INTO cakENT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Riq'uin ri', rix ibanun que man jun ruk'ij ri rubin can ri Dios. Y quiri' ibanun xaxe chin nibün achique quibin can ri ixquin-imama' can. Y yec'o chuka' ch'aka chic cachi'el ri' nye'ibanala'. Quiri' xbij ri Jesús cheque ri achi'a' fariseos y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés. ");
INSERT INTO cakENT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Y ri Jesús xch'o chic jun bey quiq'uin ri q'uiy vinük ri quimolon-qui' chiri' y xbij cheque: Tivac'axaj c'a rix ivonojel ri ninbij chive y tik'ax chive. ");
INSERT INTO cakENT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Roma ri nuc'ux ri vinük, man jari' tüj ri nbanun tz'il richin ri vinük sino xa ja itzel na'oj ntel pa ránima, jari' ri nbanun tz'il richin. ");
INSERT INTO cakENT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Conojel ri ncac'axan, ticac'axaj-e ri xinbij chive, xbij ri Jesús cheque ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Y rija' xeruya' can ri vinük, y xbe pa jun jay quiq'uin ri rachibila', y rije' xquic'utuj chin pari' ri nbanun tz'il richin ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Y ri Jesús xbij cheque: ¿Junan ibanun rix quiq'uin ri ch'aka chic vinük que man nk'ax ta chive ri ninbij? ¿Man nk'ax ta chive que ronojel ri nuc'ux ri vinük, xa man ja tüj ri' ri ntiquer nbanun tz'il richin? ");
INSERT INTO cakENT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ronojel ri achique nuc'ux, man pa ránima nbe-vi sino xa pa rupan ntoc-ka y c'ateri' ntel-e. Y roma quiri' xbij ri Jesús, nk'alajin que ronojel ri achique ri nuc'ux xa utz vi. ");
INSERT INTO cakENT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Y ri Jesús xbij chuka' que xa ja ri itzel ri npu'u pa ránima ri vinük, xa jari' ri nbanun tz'il richin. ");
INSERT INTO cakENT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Roma xa pa ránima ri vinük nyepu'u ri itzel tak na'oj. Chiri' npu'u ri na'oj tok ri vinük ye c'ulan y ri man ye c'ulan tüj nquic'uala-qui'. Y chiri' chuka' npu'u ri na'oj tok nyecamsan. ");
INSERT INTO cakENT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Pa tak cánima ri vinük npu'u-vi ri jalajoj tak nojibül, tok nye'elek', tok nquirayij que ronojel ta cosa quiq'uin ta rije' c'o-vi, nyequibanala' itzel, nyek'olan, ri achi'a' y ri ixoki' nquibanala' mac juis nyeq'uixbisan, itzel nquina' chin jun vinük utz, nquitz'uc tzij chiquij ch'aka chic, nquina' que juis quik'ij, ri manak runojibül xa nc'o rutzij. ");
INSERT INTO cakENT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ronojel ri itzel quiri', pa ránima ri vinük npu'u, y jari' ri nbanun tz'il richin. Quiri' xbij ri Jesús cheque ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Y ri Jesús y ri rachibila' xel chiri', y xbe pa jun lugar nakaj ncanaj can cheque ri tinamit quibini'an Tiro y Sidón. Y xc'uje' pa jun jay, roma man nrajo' tüj nac'axüx y ncatamüx que rija' c'o chiri'. Pero xa manak modo ape' xrevaj-ri'. Chanin nquinabej que c'o chiri'. ");
INSERT INTO cakENT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chanin c'a xnabex-pe roma jun ixok ri c'o jun ral-xtün ri c'o jun itzel espíritu tz'amayon chin. Ri ixok ri' xe xrac'axaj-pe que ri Jesús c'o chiri', xpu'u rija' riq'uin y xxuque-ka chuvüch. ");
INSERT INTO cakENT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ri jun ixok ri' man israelita tüj. Rija' jun aj-Sirofenicia. Pero xxuque' chuvüch ri Jesús richin xuc'utuj favor chin que trelesaj ri itzel espíritu ri tz'amayon ri ral-xtün. ");
INSERT INTO cakENT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero ri Jesús xbij chin ri ixok: Ri Dios man nbün tüj favor cheque ri achique na vinük. Yec'o nuvinak israelitas nyento' nabey. Roma man utz tüj que ntelesüs ri quivay ri ac'uala' chin ja ri vit tak tz'i' nquiva', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pero ri ixok xbij chin ri Jesús: Tai, ketzij na vi nabij. Pero nkutiquer chuka' nkac'ul ba' chin ri favor ri'. Cachi'el nquibün ri vit tak tz'i' chuxe' mesa, nyequimolola' chuka' ri ruc'aj vüy ri nyequitzakala' ri ac'uala'. ");
INSERT INTO cakENT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Y ri Jesús xbij chin ri ixok: Ri xabij quiri' na vi. Vocomi catzolij c'a, roma ri itzel espíritu xusok'opij can ri aval, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Y ri ixok xtzolij-apu chiracho. Y xberila' ri ral cotz'ol pa ruch'at. Y chanin xutz'et que ri itzel espíritu xusok'opij can ri ral. ");
INSERT INTO cakENT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ri Jesús y ri rachibila' xel c'a chupan jun lugar nakaj ncanaj-vi can chin ri tinamit Tiro y xec'o pa tinamit Sidón. Y xec'o chuka' chupan ri lugar rubini'an Decápolis, c'ateri' xapon chuchi' ri lago rubini'an Galilea. ");
INSERT INTO cakENT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chiri' c'a c'o-vi tok ri vinük xquitz'et-pe y xquic'ün-pe jun achi man nrac'axaj tüj y man nch'o tüj utz. Y ri vinük ri ye c'amayon-pe richin, xquic'utuj c'a favor chin ri Jesús que tuya' ruk'a' pari'. ");
INSERT INTO cakENT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ri Jesús xrelesaj-e ri achi ruyon chiquicojol ri vinük. Xuju' ruvi-ruk'a' pa tak ruxiquin, xch'uban, c'ateri' xutz'om nic' ri rak'. ");
INSERT INTO cakENT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Y ri Jesús xtzu'un chicaj, nüj xpu'u ruxla', y xbij: Efata. Ri tzij re' nbij quere' pa kach'abül: Tijakatüj. ");
INSERT INTO cakENT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Y ri achi jari' tok xrac'axaj y chuka' xch'o utz. ");
INSERT INTO cakENT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Y ri Jesús xuc'ün-pe ri achi y xbij cheque ri vinük que man tiquitzijoj ri xbanatüj. Pero ri vinük man xetaken tüj sino xa nabey xquelesaj rutzijol ri xbanatüj. ");
INSERT INTO cakENT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Y ri vinük ri' xsatz quic'u'x tok xquitz'et ri xbanatüj, y nquibila' c'a: Jabel ri xbün. Nbün c'a cheque ri vinük ri man nye'ac'axan tüj, que nye'ac'axan. Y nbün chuka' cheque ri man nyech'o tüj, que nyech'o, xquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chupan ri k'ij ri xquimol-qui' apu ye q'uiy vinük riq'uin. Pero ri vinük re' xq'uis quivay, y romari' ri Jesús xeroyoj ri rachibila' y xbij cheque: ");
INSERT INTO cakENT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Yin juis ninjoyovaj quivüch ri vinük re', roma ya c'o chic oxi' k'ij yec'o-pe viq'uin y vocomi man jun chic quivay chin nquic'ux. ");
INSERT INTO cakENT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Y nyentük ta e chi tak cacho choj quiri' y man jun nquic'ux-e, man utz tüj. Roma yec'o jujun ye petenük nüj, y riq'uin ba' nyetzak pa tak bey roma vayjül, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Y ri rachibila' xquibij c'a chin: Ri lugar ape' nkuc'o-vi xa jun lugar tz'iran ape' ye manak vinük. ¿Comi achique modo nkila-pe vüy richin nyeva' jabel conojel ri vinük re'? xquibij chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pero ri Jesús xuc'utuj c'a cheque ri rachibila': ¿Jaru' vüy ichajin? xbij cheque. Y rije' xquibij: C'o vuku' (siete) vüy, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Y ri Jesús xbij que ri vinük quetz'uye-ka pan ulef. C'ateri' rija' xeruli'ej ri vuku' (siete) vüy y xumatioxij chin ri Dios. Y c'ateri' xeruvech'ela-e y xuya-e cheque ri rachibila' chin nquijachala' cheque ri vinük. Y quiri' xquibün. ");
INSERT INTO cakENT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Y chuka' c'o ca'i-oxi' tak cür quiq'uin. Y ri Jesús xumatioxij chin ri Dios roma ri cür re', y c'ateri' xutük rujachic cheque ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ri vinük jabel xevayila'. Man jun tüj man ta jabel xva', y c'o vüy y cür ri xmol can. Vuku' (siete) chacüch ri xnoj can riq'uin ri vüy y cür ri xmol. ");
INSERT INTO cakENT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ri xquibün va'in chupan ri k'ij ri', la'ük caji' mil vinük. Y c'ateri' ri Jesús xerubün despedir ri vinük y xebe chi tak cacho. ");
INSERT INTO cakENT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","C'ateri' ri Jesús xoc-e pa canoa quiq'uin ri rachibila', y xebe pa jun lugar rubini'an Dalmanuta. ");
INSERT INTO cakENT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Y yec'o cheque ri achi'a' fariseos ri xe'apon riq'uin ri Jesús, y xquitz'om-qui' riq'uin tzij chin nquinaka' ri Jesús y ncajo' nquitzük pa trampa chin nquitija'. Y xquic'utuj chin que tuc'utu' jun retal ri petenük chicaj richin tuc'utu' que rija' ketzij na vi ri Dios takayon-pe richin. Jari' xquibij chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pero ri Jesús nüj xpu'u ruxla'. Rija' xpu'u bis pa ránima, y xbij: ¿Achique roma ri vinük richin vocomi ncajo' nquitz'et que c'o jun retal chupan ri caj? Pero yin ketzij ninbij chive que man ninya' tüj nijun retal ri ncajo' rije' ri nbanatüj, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Y ri Jesús xeruya' can ri achi'a' fariseos, y xoc-e pa canoa quiq'uin ri rachibila', richin que nyec'o c'a lojc'an chic ruchi-ya'. ");
INSERT INTO cakENT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Y ri rachibila' ri Jesús xquimestaj c'a xquic'uaj quivay, y chiri' pa canoa xaxe c'a jun vüy c'o can. ");
INSERT INTO cakENT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Y ri Jesús xbij cheque ri rachibila': Tivac'axaj ri ninbij chive, que tichajij-ivi' chuvüch ri levadura quichin ri achi'a' fariseos y ri Herodes, roma xa nnimür, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pero ri rachibila' xquibij chiquivüch: Rija' xbij quiri' roma roj man xkac'ün tüj pe caxlan vüy, xquibij. (Ri levadura xa cachi'el jun ak'on que nbün chin ri qui'en ri ntoc caxlan vüy que nnimür.) ");
INSERT INTO cakENT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pero ri Jesús retaman c'a ri nquibila' ri rachibila', romari' xbij cheque: ¿Achique roma rix ninuc que roma manak caxlan vüy, romari' xinbij quiri'? ¿Man xk'ax ta c'a chive ri xinbij? ¿Xa covirnük ri ivánima, romari' man nk'ax ta chive? ");
INSERT INTO cakENT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Rix c'o runak'-ivüch, pero xa man nyixtzu'un tüj. C'o ixiquin, pero xa man nivac'axaj tüj. ¿Xa man jun c'a ri nka-pe chive? ");
INSERT INTO cakENT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Man nka-pe tüj chive tok yin xentzuk ri vo'o' mil vinük riq'uin ri vo'o' vüy ri xinvech'ela' chiquivüch? ¿Rix ri' nka-pe chive jaru' chacüch ri xe'inojsaj riq'uin ri vüy ri ximol can? xbij cheque. Y ri rachibila' xquibij c'a chin ri Jesús: Doce chacüch, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","¿Man nka' tüj pe chuka' chive tok xentzuk ri caji' mil vinük riq'uin ri vuku' (siete) vüy ri xinvech'ela' chiquivüch? ¿Rix ri' nka-pe chive chuka' jaru' chacüch ri xe'inojsaj riq'uin ri vüy ri ximol can? xbij cheque. Y ri rachibila' xquibij chin ri Jesús: Vuku' (siete) chacüch, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Y ri Jesús xbij cheque: ¿Y achique c'a roma man jani nk'ax ta chive? ");
INSERT INTO cakENT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Y ri Jesús y rachibila' xe'apon c'a pa Betsaida. Y xquic'ün-pe jun achi moy chin ri Jesús. Y ri ye c'amayon-pe chin ri moy ri' xquic'utuj favor chin chin tuya' ruk'a' pari' richin ri achi moy ntiquer tüj ntzu'un. ");
INSERT INTO cakENT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Xpu'u ri Jesús xutz'om chuk'a' ri achi moy y xuc'uaj-e c'a chuchi' ri vit tinamit. Y ri Jesús xuya-apu ruchub chi tak runak'-ruvüch ri moy. Y chuka' xuya' ruk'a' pari'. Y xuc'utuj chin si nutzu'un. ");
INSERT INTO cakENT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Y tok ri moy xujük runak'-ruvüch, xbij: Ja'. Nyentz'et ri achi'a'. Nyentz'et que cachi'el ye che'. Pero xa man quiri' tüj roma xa nyebiyin, nbij. ");
INSERT INTO cakENT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Y ri Jesús xuya' chic ri ruk'a' chi tak runak'-ruvüch ri achi. Xbün c'a chin ri achi que xtzu'un utz. Y ri achi xtzu'un c'a jabel. Utz c'a xerutz'et-apu ronojel, chi nüj chi nakaj. ");
INSERT INTO cakENT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Y ri Jesús xutük-e ri achi richin tibe chiracho. Rija' xbij c'a chin: Man te'atzijoj pa tinamit. Man catoc-apu, xa choj cabiyin chi'avacho, xbij ri Jesús chin. ");
INSERT INTO cakENT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Y ri Jesús y ri rachibila' xebe pa tak k'os (aldea) ri yec'o chiri' pan ri lugar Cesarea richin ri Filipo. Y pa bey, ri Jesús xuc'utuj cheque ri rachibila': ¿Achique c'a yin, nquinuc ri vinük? xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Y rije' xquibij chin: Yec'o ch'aka nyebin que rat ja ri Juan Bautista. Y yec'o ch'aka chic nquibij que ja rat ri Elías, ri jun ri xk'alajrisan ri xbix chin roma ri Dios ojer can. Y yec'o c'a chuka' ri nyebin que rat jun cheque ri ch'aka chic achi'a' ri xek'alajrisan ri xbix cheque roma ri Dios chupan ri ojer can tiempo, xquibij chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Y rija' xuc'utuj cheque ri rachibila': ¿Y rix achique ninuc pan nuvi'? xbij cheque. Y ri Pedro xbij chin ri Jesús: Ja rat ri Cristo, ri Jun cha'on-pe y takon-pe roma ri Dios, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Y ri Jesús xbij cheque que man tiquitzijoj. ");
INSERT INTO cakENT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Y ri Jesús xutz'om ruc'utic chiquivüch ri rachibila': Yin ri xinalüx chi'icojol, nc'atzin que nincusaj q'uiy pokonül. Y itzel yinquitz'et ri rajatük tak achi'a' ri c'o quik'ij. Itzel yinquitz'et ri nimalüj tak sacerdotes. Chuka' itzel yinquitz'et ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés. Y nquicamsüs. Pero pa rox k'ij nquic'astüj chic, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Y tok ri Jesús xbij ri tzij ri' cheque ri rachibila', jabel k'alüj ri rubixic xbün chin. Man xrevaj tüj. Pero ri Pedro man xka' tüj chin ri xbij ri Jesús, romari' xrelesaj-e ba' chiri', y xberuchapa-pe chin. ");
INSERT INTO cakENT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero ri Jesús tok xrac'axaj quiri', xupiscolij-ri' y xerutz'et-apu ri ch'aka chic rachibila'. Y xbij chin ri Pedro: Man cac'uje-pe viq'uin rat itzel-vinük, roma man utz tüj ri nanuc. Roma xa cachi'el ri quinojibül ri vinük achajin junan riq'uin nquinuc ri vinük y man nanuc tüj cachi'el nrajo' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Y ri Jesús xeroyoj-pe ri vinük y ri ch'aka chic rachibila'. Y rija' xbij cheque: Achique c'a ri nrajo' nquirutzeklebej vichin, tubana' cachi'el nbün jun vinük benük chuxe' ru-cruz. Man nbün tüj ri nurayij rija'. Man nupokonaj tüj nuc'usaj pokonül. Si c'o jun ri nunuc quere' utz npu'u viq'uin chin nquirutzeklebej. ");
INSERT INTO cakENT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Roma si juis nupokonaj ri ruc'aslen chere' chuvüch ri ruch'ulef, xa man nril tüj ruc'aslen richin chi jumul. Jac'a ri man nupokonaj tüj ri', stape' (aunque) napon pa camic voma yin y roma ri utzilüj tzij richin ri colonic, nril ruc'aslen richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Roma achique c'a nrelesaj chin ri vinük si nc'uje' ri beyomül richin ronojel ri ruch'ulef riq'uin y ri vinük ri' xa man ncolotüj tüj? ");
INSERT INTO cakENT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Y stape' (aunque) juis q'uiy ri beyomül ruchajin ri vinük, man ntiquer tüj nulok' ri c'aslen richin jumul. ");
INSERT INTO cakENT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Man jun vinük c'a tiq'uix nuk'alajrisaj que yin rutaken yin y que rutaken ri nutzij. Man tiq'uix nbij quiri' cheque ri vinük richin vocomi, ri xa man nquitakej tüj ri Dios y ye aj-maqui' vi. Roma si c'o jun ri nq'uix nbij quiri' cheque, yin chuka' ri xinalüx chi'icojol ninq'uix ninbij que ri jun vinük ri' vichin yin. Quiri' ninbün tok nquipu'u chic jun bey, y junan chic nuk'ij riq'uin ri Nata' y ye vachibilan-pe ri lok'olüj tak ángeles. ");
INSERT INTO cakENT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Y chuka' ri Jesús xbij cheque ri yec'o riq'uin: Tivac'axaj c'a ri ninbij chive, y juis rakalen: Ri Dios nc'uje' pari' ri ruch'ulef y ri ruvinak y ntz'uye' cachi'el jun juez nbün juzgar pa quivi' ri vinük y nuk'alajrisaj ri ruchuk'a' ruk'ij: Y yec'o chive rix ri man nyecom tüj hasta que nquitz'et can ri', ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Y tok c'unük chic vaki' (seis) k'ij, ri Jesús xerucha-e ri Pedro, ri Jacobo y ri Juan, richin que xaxe rije' xeruc'uaj pari' jun juyu' nim-e rupalen. Y ri Jesús xjalatüj c'a ruvüch chiquivüch ri ye oxi' rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Y chuka' ri rutziek xjalatüj ruvüch: Xbün sük-sük, cachi'el ri sutz' tok nsakrisan y chuka' cachi'el ri hielo, y juis nyiq'uiyot. Y man nijun ch'ajoy-tziük ntiquer ta nbün quere' rusakil chin jun tziük. ");
INSERT INTO cakENT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Y xek'alajin-pe ri ca'i' achi'a' quibini'an Elías y Moisés, y nyetzijon riq'uin ri Jesús. Ri achi'a' ri' ye rusamajela' ri Dios ri xec'uje' ojer can. ");
INSERT INTO cakENT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Y ri Pedro xbij chin ri Jesús: Maestro, xbij chin. Utz rojc'o chere'. Kabana' oxi' vit tak jay. Jun chave rat, jun richin ri Moisés, y jun chuka' richin ri Elías, xbij chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ri Pedro quiri' xbij-apu pero rija' man xunuc tüj nabey ri xerubila-apu. Ri ye oxi' rije' rachibila' ri Jesús ri yec'o chiri' juis quixbin-qui'. ");
INSERT INTO cakENT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Y jari' tok c'o jun sutz' ri xmujan quichin. Y chupan ri sutz' ri' c'o Jun ri xch'o-pe y xbij: Jare' ri Nuc'ajol y juis ninjo'. Tivac'axaj ri rutzij, xbij ri ch'abül. ");
INSERT INTO cakENT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pero tok ri rachibila' xetzu'un chic apu, xquitz'et que xa man nijun chic c'o riq'uin ri Jesús. Xa ruyon chic c'o can. ");
INSERT INTO cakENT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Y tok rije' nyexule-ka-pe chuvüch ri juyu', ri Jesús juis xuchilabej cheque ri oxi' rachibila': Man titzijoj ri xitz'et. Rix utz nitzijoj pero tok yin ri xinalüx chi'icojol nquic'astüj chic pe chiquicojol ri caminaki'. C'ateri' tok nitz'om rutzijosic xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Y rije' man xquitzijoj tüj ri xquitz'et, pero nquic'utula' chiquivüch achique nrajo' nbij ri ch'abül ri xbij cheque que nc'astüj-pe chiquicojol ri caminaki'. ");
INSERT INTO cakENT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Y c'ateri' ri ye oxi' rachibila' xquibij chin ri Jesús: Roj xk'ax cheke que ja vi rat ri Cristo ri cha'on-pe y takon-pe roma ri Dios. ¿Pero achique c'a roma tok ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés nquibij que nabey que nobos ri Cristo nc'atzin que nobos ri Elías? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Y ri Jesús xbij cheque: Ketzij na vi que ri Elías npu'u nabey y nbün nuchojmirsaj ronojel ri c'o. Cachi'el vi ri bin can pari'. ¿Y achique nibij rix? ¿Man comi nbanatüj tüj chuka' ri tz'iban can pa nuvi' yin ri xinalüx chi'icojol que nc'atzin que ninc'usaj q'uiy pokonül y man jun nuk'ij nban chuve? ");
INSERT INTO cakENT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero yin ninbij chive que ri Elías ri' xpu'u yan. Y juis pokonül xuc'usaj-e achique na la xcajo' xquibün chin. Y quiri-vi xquibün ri tz'iban can, xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Y tok ri Jesús y ri ye oxi' rachibila' xapon quiq'uin ri ch'aka chic rachibila', rija' xutz'et que juis ye q'uiy vinük ri quimolon-qui' chiquij, y chuka' ca'i-oxi' etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés ri quitz'amon-qui' riq'uin tzij quiq'uin ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Y tok conojel ri vinük ri ye c'o chiri' xquitz'et que petenük ri Jesús, xsatz quic'u'x. Rije' xequicot, y junanin xebequiculu' y xquibana' saludar. ");
INSERT INTO cakENT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Y ri Jesús xuc'utuj cheque ri rachibila': ¿Pari' achique nyixtz'amon-ivi' quiq'uin rije'? xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Pero c'o jun cheque ri vinük xutz'om-apu rubixic chin ri Jesús y xbij: Maestro, nuc'amon-pe ri nuc'ajol aviq'uin, roma c'o jun itzel espíritu rutz'amon. Y ri itzel espíritu re' man nuya' tüj k'ij chin nch'o. ");
INSERT INTO cakENT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Y tok más nutz'om, achique na lugar c'o-vi, nutorij pan ulef, nvokon ruc'axaj ruchi', y nujach'ach'ej rey. Juis chuka' rucajman chic roma ri ruc'ulachin. Y romari' xinc'utuj favor cheque ri avachibil chin tiquelesaj ri jun itzel espíritu re' riq'uin ri nuc'ajol. Pero man nyetiquer tüj, xbij ri achi. ");
INSERT INTO cakENT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Y ri Jesús jari' xbij cheque: Man jun vinük chupan ri tiempo re' ri nuya' ta ronojel ri ránima riq'uin ri Dios. ¿Rix ninuc que yin chi jumul nquic'uje' iviq'uin? ¿Chi jumul nc'atzin que nyixincoch'? Tic'ama' c'a pe ri ala' viq'uin, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Y xquicün-pe ri ala' chuvüch ri Jesús. Pero tok ri itzel espíritu chin xutz'et ri Jesús, riq'uin ruchuk'a' xbün chin nbarbot ri ala' y xutorij pan ulef. Y ri ala' nubolkotila-ri' y nvokon-pe ruc'axaj ruchi'. ");
INSERT INTO cakENT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Y ri Jesús xuc'utuj c'a chin ri rutata' ri ala': ¿Jaru' tiempo ruc'uan ri ruc'ulachin-pe quere' ri ala'? xbij ri Jesús. Y ri rutata' xbij: Re' c'a co'ol tok quere' ruc'ulachin-pe. ");
INSERT INTO cakENT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Y q'uiy chic mul rutorin pa tak k'ak', pa tak ya', richin ta ncom. Pero si rat ncatiquer ncato', tajoyovaj c'a ruvüch rija', tajoyovaj nuvüch yin, y kojato'. Quiri' xbij ri rutata' ri ala' chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Pero ri Jesús xbij chin ri tata'aj: Si rat ncatiquer ronojel avánima naya' viq'uin que nquitiquer ninto' ri ac'ajol, nbanatüj-vi ri nac'utuj. Pero ri' ja rat c'o-vi, roma ri nuya' ronojel ránima tok nuc'utuj, nbanatüj-vi ri achique ri nrajo', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Y ri rutata' ri ala' jari' xbij: Ninya' vánima. Y chuka' quinato' chin que más ta ninya' vánima. Y tok ri tata'aj xbij ri tzij ri', riq'uin ruchuk'a' xbij, roma juis nim ri bis ri c'o riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pero tok ri Jesús xutz'et que xa ye juis ye q'uiy vinük ri nquimol-apu-qui', xuchop ri itzel espíritu. Rija' xbij c'a chin: Rat ri abanun chin ri ala' re' que man nrac'axaj tüj y man nch'o tüj chuka', catel-e, y man catzolij chic pe riq'uin, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Y ri itzel espíritu nsiq'uin, xel-e riq'uin ri ala'. Pero juis xbün chin nbarbot. Y ri ala' xc'uje' can pan ulef, cachi'el jun camnük. Y romari' ye q'uiy vinük xenucun que ri ala' xcom. ");
INSERT INTO cakENT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ri Jesús xutz'om ruk'a' ri ala' y xupaba'. Y ri ala' jari' xbecatüj-pe. ");
INSERT INTO cakENT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Y tok yec'o chic pa jay quiyon riq'uin ri Jesús, ri rachibila' xquic'utuj chin: ¿C'o roma roj man xojtiquer tüj xkelesaj-e ri itzel espíritu? xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Y ri Jesús xbij c'a cheque: Ri mucaj espíritu re' ntel, pero si rix nibün que man nyixva' tüj richin nibün orar, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Y tok rije' ye elenük chic pe chiri', xec'o pa ri lugar rubini'an Galilea. Pero ri Jesús man xrajo' tüj que rija' xc'o-apu chiri'. ");
INSERT INTO cakENT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Roma rija' nrajo' nyeruc'ut can y que nquetamaj can ri rachibila', romari' nucamulij can rubixic cheque. Rija' nbij c'a cheque: Yin ri xinalüx ch'icojol, nquijachox pa quik'a' ri vinük y yinquicamsaj. Jac'a tok xa yin camnük chic, pa rox k'ij nquic'astüj-pe. ");
INSERT INTO cakENT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero ri rachibila' xa man xk'ax ta cheque ri xbix cheque roma ri Jesús. Y nquixbij-qui' nquic'utuj chin ri achique c'a ri rubeyal ri tzij ri xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Y ri Jesús y rachibila' xapon pa tinamit Capernaum. Y tok c'o chic pa jay, rija' xuc'utuj cheque ri rachibila': Y rix ¿achique c'a ri nibila' chivüch tok nyixbiyin-pa bey? xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero ri rachibila' man xech'o tüj chuvüch ri Jesús chin nquitzolij ri tzij, roma tok ye petenük pa bey, xa xquich'ojila' chiquivüch achique ri más nim ruk'ij chiquivüch rije'. ");
INSERT INTO cakENT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Y ri Jesús xtz'uye-ka y xeroyoj ri doce rachibila' y xbij c'a cheque: Si c'o jun nrajo' que ja rija' ri nabey y c'o ta ruk'ij, nc'atzin que xa vit oc tubana', que tuna' que xa manak ruk'ij y tubana' achique na samaj quichin conojel ri ch'aka chic. ");
INSERT INTO cakENT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Y ri Jesús xberuc'ama-pe jun vit ac'ual y xuya' chiri' pa quinic'ajal. Y xuch'elej chiquivüch xbij cheque ri rachibila': ");
INSERT INTO cakENT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ri ruyacon riq'uin quicot nuc'ul jun ac'ual, jun cachi'el re', man xe tüj nuc'ul ri ac'ual, quiri' c'a ri nquiruc'ul chuka' yin. Y ri nc'ulun vichin yin, man xe tüj chuka' yin ri nquiruc'ul, xa nuc'ul chuka' ri takayon-pe vichin. ");
INSERT INTO cakENT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Y ri Juan xbij c'a pe chin ri Jesús: Maestro, xbij chin. C'o jun achi man kachibil tüj roj katz'eton. Pero ri achi ri', pan abi' rat nyeresala' itzel tak espíritu. Pero roma xa man kachibil tüj roj, xkabij chin que man tubün chic quiri', xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Y ri Jesús xbij: Man tibij quiri' chin. Roma si pa nubi' yin nyerubanala' milagros, man chanin tüj nbij itzel tzij chuvij. ");
INSERT INTO cakENT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Roma ri achique c'a ri man nkuretzelaj tüj, jari' c'o kiq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Y ri vinük ri utz nyixrutz'et roma viq'uin yin ri Cristo rixc'o-vi, stape' (aunque) xa ba' iya' ri nuya', ketzij ri ninbij chive que c'o rajil-ruq'uexel nril romari'. ");
INSERT INTO cakENT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Si c'o ta jun co'ol ri nquirutaken y npu'u ta jun vinük y nbün chin ri jun co'ol ri' que ntzak pa mac, man utz tüj ri nbün. Y romari' ri vinük ri ninucun que nbün ri itzel ri', xa más ta utz chin rija' que ximon ta jun nimalüj abüj richin que'en chukul y nbetorix pa jun mar. ");
INSERT INTO cakENT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Xa roma c'a ri' si c'o jun ak'a' nbün chave que ncamacun, xa man tabün chic quiri'. Tabana' chin cachi'el nakupij-e. Roma más utz que xaxe jun ak'a' c'o y ncatoc chupan ri c'aslen chi jumul, que ca'i' ak'a' y xa ncabe chupan ri lugar ri pokonül, chupan ri k'ak' ri man nchup tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ri lugar ri' chiri' yec'o-vi ri jut ri quijutil ri quich'acul ri vinük, y ri' man nyecom tüj, y c'o chuka' ri k'ak' ri xa man nchup tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Y si c'o jun avakün que nbün chave que ncamacun, xa man tabün chic quiri'. Tabana' chin cachi'el nakupij-e. Roma más utz que xaxe jun avakün c'o y ncatoc chupan ri c'aslen chi jumul, que ca'i' avakün ncabetorix can chupan ri lugar ape' c'o pokonül, chupan ri k'ak' ri man nchup tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ri lugar ri' yec'o-vi ri jut ri quijutil ri quich'acul ri vinük, y ri' man nyecom tüj, y c'o chuka' ri k'ak' ri xa man nchup tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Y si c'o jun runak'-avüch ri nbün chave que ncamacun, xa man tabün chic quiri'. Tabana' chin cachi'el navelesaj-e, Roma más utz que xaxe jun runak'-avüch c'o y ncatapon chila' riq'uin ri Dios, ri ape' ja rija' ri nbün mandar, que ca'i' runak'-avüch ncabetorix can chupan ri lugar ape' c'o pokonül. ");
INSERT INTO cakENT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ri lugar ri' yec'o-vi ri jut ri quijutil ri quich'acul ri vinük, y man nyecom tüj, y c'o chuka' ri k'ak' ri xa man nchup tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ronojel chico ri ye sujun-pe chin ri Dios, nyetz'amis. Quiri' chuka' conojel ri vinük nyetz'amis pero ri xa man riq'uin tüj atz'an jac'a xa riq'uin k'ak'. ");
INSERT INTO cakENT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jabel utz ri atz'an. Pero si ri atz'an re' nq'uis ta e rutzayil, ¿achique c'a rubeyal nibün rix richin quiri' ntzolij chic pe rutzayil? Romari' rix tichajij ic'aslen, richin quiri' man quixoc cachi'el ri atz'an ri man ncatz'amin tüj chic, y chuka' man jun tüj oyoval chi'icojol. Quiri' xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Y c'ateri' ri Jesús y ri rachibila' xel-e chiri' y xbe pa ruch'ulef Judea. Y xc'o chuka' lojc'an ri rakün-ya' Jordán. Chiri', juis q'uiy vinük xquimol-qui' riq'uin. Y rija' xutz'om c'a ruc'utic ri rutzij ri Dios chiquivüch, cachi'el rubanun-vi-pe. ");
INSERT INTO cakENT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Y jari' tok yec'o achi'a' fariseos ri xe'apon riq'uin, chin nquinaka' ri Jesús chin ntzak tüj pa quik'a' riq'uin tzij. Rije' xquic'utuj c'a chin si utz que jun achi nujüch-ri' riq'uin ri rixjayil. ");
INSERT INTO cakENT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Y ri Jesús xbij c'a cheque ri achi'a' ri': ¿Achique c'a ri rubin can ri Moisés chive richin jari' nibün? xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Y rije' xquibij: Ri Moisés ruyo'on can k'ij chin ri achi nutz'ibaj jun vuj chin nurocotaj-e y nujüch-ri' riq'uin ri rixjayil, xquibij rije'. ");
INSERT INTO cakENT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Y ri Jesús xbij cheque: Rix, xa roma xcovir ri ivánima rix chupan ri man utz tüj, quiri' chuka' xc'ulachitüj ojer can, pa ru-tiempo ri Moisés. Xa romari' tok rija' xbij que tiban c'a quiri'. ");
INSERT INTO cakENT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero pa rutz'uquic ojer can tiempo xa man quiri' tüj. Tok ri Dios xbün ri ruch'ulef, pa c'ulaj c'a xerubün ri vinük. Man ruyon tüj ri achi y man ruyon tüj chuka' ri ixok. ");
INSERT INTO cakENT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Romari' ri achi man quiq'uin tüj chic rute-rutata' nc'uje-vi. Xa riq'uin c'a ri rixjayil nc'uje-vi, ");
INSERT INTO cakENT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","y tok c'a ye quiyon, ca'i' quibanun. Pero tok quic'uan-qui', xa jun ri quibanun. ");
INSERT INTO cakENT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Roma c'a ri' ri ye tunun chic roma ri Dios, man tubün ri vinük que nyeruch'ür, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tok ri Jesús y ri rachibila' yec'o chic pa jay, xepu'u ri rachibila' xquic'utuj chin ri Jesús que achique c'a rubeyal ri tzij ri nyerubij can cheque ri achi'a' fariseos. ");
INSERT INTO cakENT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Y ri Jesús xbij cheque: Achique na achi ri nujüch-ri' riq'uin ri rixjayil y c'ateri' nuc'ün chic pe jun ixok, ri achi ri' nmacun chuvüch ri rixjayil. ");
INSERT INTO cakENT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Y quiri' chuka' ri ixok ri nujüch-ri' riq'uin ri rachijil y nbe riq'uin jun chic achi, ri ixok ri' nmacun chuka'. Quiri' xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Y ri vinük nyequic'amalon-pe ri ac'uala' riq'uin ri Jesús, richin nuya' ta e ri ruk'a' pa quivi'. Pero ri rachibila' ri Jesús xa xquibij cheque ri vinük que man tiquibün quiri'. ");
INSERT INTO cakENT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pero tok ri Jesús xutz'et ri nquibün ri rachibila', xpu'u royoval, roma man utz tüj xutz'et ri nyetajin nquibün, y xbij cheque: Tiya' k'ij cheque ri ac'uala' nyepu'u viq'uin, y man tik'üt. Roma ri nye'oc pa ruk'a ri Dios, xaxe ri ye cachi'el ri ac'uala'. ");
INSERT INTO cakENT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Y ketzij ninbij chive, que ri man nquibün tüj c'achi'el ri ac'uala', ncajo' nquijüch-qui' pa ruk'a' ri Dios, ri' man nye'oc tüj pa ruk'a' ri Dios, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Y rija' xerutz'om ri ac'uala' y xeruch'elej y xuya' ruk'a' pa quivi' chin xerubün can bendecir. ");
INSERT INTO cakENT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Y tok ri Jesús y ri rachibila' xutz'om chic rubey, c'o jun achi junanin xobos riq'uin, xxuque' chuvüch, y xbij c'a chin: Rat utzilüj Maestro, tabij chuve: ¿Achique c'a utz que ninbün yin chin ninvichinaj ri c'aslen chi jumul? xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Y ri Jesús xbij chin: ¿Achique roma nabij utz chuve yin? Roma man jun vinük utz ta c'o, xaxe ri Dios ri utz. ");
INSERT INTO cakENT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Y yin ninbij que rat jabel avetaman ri diez mandamientos ri xuya' ri Dios pa ruk'a' ri Moisés ojer can, que rat achi ri c'o avixjayil man tacanoj jun chic ixok: man cacamsan: man catelek'. Man tamol tzij chirij jun chic vinük. Man tabij tzij man ketzij tüj cheque vinük chin navelesaj ri ruchajin. Taya' quik'ij ri ate' y atata', xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Y ri achi xbij chin ri Jesús: Maestro, xbij chin. Ri' c'a yin co'ol tok ronojel ri' nubanun-pe, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Y ri Jesús xutz'et-apu ri achi, juis xrajo' tok xbij quiri', y c'ateri' xbij chin: C'o jun chic man abanun tüj. Te'ac'ayij ronojel ri achajin y ri rajil taspaj cheque ri vinük ri manak quichajin, richin quiri' nc'uje' abeyomal chila' chicaj. Y catampe viq'uin, quinatzeklebej, y man tapokonaj nac'usaj pokonül xa voma yin, cachi'el xa ta ncatelej jun cruz, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pero tok ri achi xrac'axaj ri tzij xbij ri Jesús chin, juis itzel xuna' y xbison-pe ri ránima, roma juis rubeyomal. Y nbison ránima xtzolij-e, roma man nrajo' tüj que nuya' can ri rubeyomal. ");
INSERT INTO cakENT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Y ri Jesús xtzu'un ronojel lado, y xbij cheque ri rachibila': Ri vinük c'o quibeyomal, juis c'ayuf chin nye'oc pa ruk'a' ri Dios, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Y ri rachibila' ri Jesús tok xcac'axaj ri tzij ri xbij ri Jesús, xsatz quic'u'x. Pero rija' xbij chic jun bey cheque: Valc'ual, xbij cheque. Ri vinük ri xaxe riq'uin quibeyomal c'o ri cánima, juis c'ayuf nye'oc pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Xa más man c'ayuf tüj que nc'o ri jun chico rubini'an camello chi rachük jun bak richin t'ison, que chuvüch jun beyon ntoc tüj riq'uin ri Dios o pa ruk'a' ri Dios, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pero tok ri rachibila' xcac'axaj chic jun bey ri tzij ri xbij ri Jesús, juis xsatz quic'u'x y xquibila' c'a chiquivüch: Cachi'el ri nbij, quiri', man jun vinük xticolotüj, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Pero ri Jesús xerutz'et-apu ri rachibila' y xbij cheque: Ri vinük man nyetiquer tüj nquicol-qui', pero ri Dios ntiquer-vi nyerucol, roma rija' ronojel ntiquer nbün, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Y jari' tok ri Pedro xutz'om-apu rubixic chin y xbij: Rat avetaman que roj ya xkaya' can ronojel ri kachajin, chin quiri' rat katzekleben, xbij ri Pedro. ");
INSERT INTO cakENT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pero ri Jesús xbij chin: Ketzij ninbij chive, que achique na vinük c'o ri nuc'ul, si voma yin y roma ri utzilüj tzij richin colonic ruyo'on ta can racho, roxpochel ye alabo' y xtani', rute' o rutata', rixjayil, ralc'ual o rulef. ");
INSERT INTO cakENT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Q'uiy nuc'ul ri nbanun quiri'. Pa ciento mul más q'uiy ri nuc'ul yan chupan ri tiempo ri katz'amon-apu. Nuc'ul yan racho, roxpochel ye alabo' y xtani', rute', ralc'ual o rulef. Y nuc'usaj pokonül roma tzeklebey vichin yin, pero chupan ri jun chic tiempo ri petenük, nril ri ruc'aslen chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero ye q'uiy ri juis quik'ij vocomi, napon ri k'ij tok manak chic quik'ij ntic'uje'. Y ye q'uiy ri manak quik'ij vocomi, napon ri k'ij tok nc'uje' quik'ij, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ri Jesús, ri rachibila' y ri ch'aka chic vinük, quitz'amon bey pa tinamit Jerusalén. Y ri Jesús c'unük chiquivüch, y ri rachibila' xsatz quic'u'x y ri vinük quixbin-qui' ye benük chirij. C'ateri' ri Jesús xeruch'ür ba' ri doce rachibila' y xbij chic cheque ri achique pokonül ri nuc'usaj. ");
INSERT INTO cakENT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Rija' xbij c'a cheque: Rix ivetaman que pa tinamit Jerusalén katz'amon-e bey, y ja chiri' nquijachatüj-vi yin ri xinalüx chi'icojol. Nquijachatüj-e pa quik'a' ri nimalüj tak sacerdotes y pa quik'a' ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés. Y rije' nquibij que tika-ka ri camic pa nuvi'. Y chuka' yinquijüch-e pa quik'a' vinük man ye israelitas tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Y ri vinük ri' yinquitze'ej, yinquichubaj, yinquich'ey, y c'ateri' yinquicamsaj. Pero pa rox k'ij nquic'astüj chic pe chiquicojol ri caminaki'. ");
INSERT INTO cakENT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Y ri Jacobo y ri Juan, ri ye ruc'ajol ri achi rubini'an Zebedeo, xejel-apu riq'uin ri Jesús, y xquibij chin: Maestro, xquibij chin. Roj nkajo' nkac'utuj jun favor chave. Pero nkajo' que nabün cheke ri nkac'utuj chave, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Y rija' xbij cheque: ¿Achique c'a ri favor ri nijo'? xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Y rije' xquibij: Roj nkajo' que tok c'o chic ak'ij rat, nabün ta chuka' cheke roj que nc'uje kak'ij, naya' ta k'ij cheke richin que nkatz'uye' ta apu aviq'uin, jun ntz'uye' pan avajquik'a' (a-derecha) y jun chic pan axocon (a-izquierda). ");
INSERT INTO cakENT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pero ri Jesús xbij cheque: Rix man ivetaman tüj c'a que c'ayuf chive ri nic'utuj. Y romari' yin ninc'utuj c'a chive: ¿Nicoch' comi rix ri nban chuve yin? ¿Y nicoch' comi chuka' rix jun pokonül cachi'el ri nka-ka pa nuvi' yin? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Y rije' xquibij: Nkacoch', xquibij. Y ri Jesús xbij chic cheque: Ketzij na vi que nicoch' rix ri' cachi'el ri nban chuve yin. Chuka' nicoch' jun pokonül cachi'el ri nka-ka pa nuvi' yin. ");
INSERT INTO cakENT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero ri nic'utuj chuve que jun ntz'uye' ta pa vajquik'a' (nu-derecha) y jun ntz'uye' ta pa nuxocon (nu-izquierda), ri' man pa nuk'a' tüj yin c'o-vi chin ninya' chive. Roma ri nic'utuj rix, ri' xa quichin ri Dios ri nbin que utz que nyetz'uye' chiri', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Y ri diez chic rachibila', tok xcac'axaj ri tzij ri xbix cheque y ri xquic'utuj chin, xpu'u coyoval chiquij ri Jacobo y ri Juan. ");
INSERT INTO cakENT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Y jari' tok ri Jesús xeroyoj ri rachibila' y xbij cheque: Yin ninbij que rix jabel ivetaman que chere' chuch'ulef que yec'o achi'a' que c'o quik'ij, jari' ri yec'o pa quivi' ri vinük, y roma yec'o ri vinük pa quik'a', romari' nquina' que ja rije' ri ye cajaf. Xaxe ri c'o quik'ij ri nyebin ri nc'atzin nban. ");
INSERT INTO cakENT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero chi'icojol rix man quiri' tüj. Roma ri nrajo' nc'uje' ruk'ij chive rix, nc'atzin que tuna' que xa manak ruk'ij y tubana' cachi'el jun samajel y ri ch'aka chic nyeruto'. ");
INSERT INTO cakENT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Si c'o jun c'a chive rix nrajo' que ja rija' ri nabey y c'o ta ruk'ij, tuna-ri' que xa manak ruk'ij y tubana' cachi'el jun samajel o esclavo quichin ri ch'aka chic. ");
INSERT INTO cakENT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Y quiri' c'a yin ri xinalüx chi'icojol. Yin man ninpokonaj tüj nquisamüj coma ri ch'aka, roma richin ri' tok xinpu'u, y man xinpu'u tüj c'a richin que yec'o chic ch'aka nyebanun-pe ri ninbij cheque. Pero yin nquibanun ri samaj, y ja yin ri nquiyo'on ri nuc'aslen richin quiri' ye q'uiy ri nyecolotüj, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","C'ateri' ri Jesús y ri rachibila' xe'apon pa tinamit Jericó. Y tok rije' ya nquiya' can ri tinamit, ye juis ye q'uiy vinük ri ye tzeklebeyon-e quichin. Y chiri' chuchi-bey c'o jun moy rubini'an Bartimeo, ruc'ajol jun achi rubini'an Timeo. Rija' tz'uyurnük chiri', nuc'utuj limosna cheque ri vinük ri yec'o chiri'. ");
INSERT INTO cakENT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Y tok rija' xrac'axaj que chiri' nc'o ri Jesús aj-Nazaret, rija' riq'uin ruchuk'a' xch'o y xbij: Tajoyovaj nuvüch rat Jesús, ri ruxquin-rumam can ri rey David, xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Y ye q'uiy vinük xquibij chin que man chic tich'o. Pero rija' xa más riq'uin ruchuk'a' nch'o y nbij c'a: Rat ri ruxquin-rumam can ri rey David, tajoyovaj nuvüch roma ri nubanun, nbij. ");
INSERT INTO cakENT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Y ri Jesús xrac'axaj ri rutzij. Romari' xpa'e' ba' y xbij que toyox-pe ri achi. Y jari' xbecoyoj-pe ri achi moy y xquibij chin: Man taxbij-avi'. Jo' kiq'uin. Ri Jesús ncaroyoj, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Y ri achi, tok xrac'axaj quiri', xcatüj-pe chanin. Xuya' can ri rutziek ri cachi'el coton chiri' y xbe-apu riq'uin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Y ri Jesús xuc'utuj chin: ¿Achique c'a najo'? Y ri achi moy xbij chin: Maestro, yin ninjo' nquitzu'un, xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Y ri Jesús xbij chin: Vocomi xa utz chic ncabe, roma ya ncatzu'un chic. Ya xac'achoj roma xaya' avánima viq'uin. Y ri moy xtzu'un-vi y xutzeklebej ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Y tok xebe y nakaj chic yec'o-apu pa tinamit quibini'an Betfagé y Betania, xa ba' chic nrajo' que nye'apon pa tinamit Jerusalén, roma chuxe' chic apu ri juyu' rubini'an Olivos yec'o-vi. Y jari' tok ri Jesús xerutük-e ye ca'i' cheque ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Rija' xbij c'a cheque: Quixbiyin-apu chupan la vit tinamit la nitz'et-apu. Y ya ri nyixoc-apu chiri', nivil jun alaj burro yukuban can chiri'. Y ri alaj burro ri' c'a man jun nabey tz'uybeyon tüj. Tisol-pe y tic'ama-pe chuve yin. ");
INSERT INTO cakENT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Y si c'o jun vinük xtubij-pe chive que si c'o roma nisol-pe ri chico, tibij chin que nc'atzinej chin ri Ajaf, pero chanin nutzolij can, quixbij can chin, xbix-e roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Y ri ca'i' rachibila' ri Jesús xebe chucanoxic ri alaj burro. Y xquila-pe ximon can chiri' pa bey ri ape' nye'oc-apu ri vinük pa jun jay. Y rije' xquisol c'a pe. ");
INSERT INTO cakENT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pero tok rije' nyetajin chusolic ri alaj burro, yec'o ch'aka achi'a' xequitz'et-pe y xquibij cheque ri ye ca'i' rachibila' ri Jesús: ¿Achique nyixtajin chubanic rix chiri'? ¿Achique roma nyixtajin chusolic ri vit alaj burro? xquibij-pe cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Y ri rachibila' ri Jesús xquibij ri rubin-e ri Jesús cheque. Y ri xetz'eton-pe quichin xquiya' k'ij cheque richin xquic'uaj-e ri alaj burro ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Y ri rachibila' ri Jesús ri' xquic'ün-pe ri alaj burro chin ri Jesús. Y xquiya-e quitziek ri cachi'el coton chirij ri chico ri', chin ri Jesús xutz'uye-e chirij. ");
INSERT INTO cakENT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Y ye q'uiy cheque ri vinük nquiya' ruk'ij ri Jesús, y nquiriq'uila' ri quitziek ri cachi'el coton pa rubey. Y ch'aka chic vinük nquikupila' tak ruk'a' che', nquiriq'uila' pa rubey, richin vekbül. Y quiri' nquibanala' ye benük. ");
INSERT INTO cakENT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ri vinük ye c'unük chuvüch y ri ye petenük chirij xquitz'om-pe nquibij riq'uin ronojel quichuk'a' y nquibij: ¡Matiox que petenük ri Jun re'! ¡Que ri Ajaf Dios nbün ta bendecir rija'! ¡Rija' petenük pa rubi' ri Ajaf Dios! ");
INSERT INTO cakENT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Matiox que ntzolij yan chic pe ri gobierno ri katata' David ri rey ri xc'uje' ojer can! ¡Matiox chin ri Dios ri c'o chila' chicaj! xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Y ri Jesús xoc-apu pa tinamit Jerusalén y xoc-apu pa racho ri Dios y xutz'et ronojel apu achique ri yec'o chiri'. Y tok xtzak-ka ri k'ij, rija' y ri ye doce rachibila' xebe pa tinamit Betania. ");
INSERT INTO cakENT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pa ruca'n k'ij tok quitz'amon bey chin nyetzolij-pe pa tinamit Betania y nyebe pa tinamit Jerusalén, ri Jesús xpu'u vayjül chin. ");
INSERT INTO cakENT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Y rija' chi nüj xutz'et-apu jun che' munil rubini'an higuera, y jabel ruxak c'o. Xbe-apu riq'uin, chin nucanoj-pe jun ruvüch. Pero tok xapon-apu riq'uin, xa nijun ruvüch c'o, xa ruyon ruxak. Roma man ruk'ijul tüj richin nc'uje' ruvüch. ");
INSERT INTO cakENT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jari' tok ri Jesús xch'o chin ri che' y xbij: Man ncavachin tüj chic. Man jun chic c'a vinük ntijon ri avüch, xbij. Y ri rachibila' xcac'axaj ri xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Y xe'apon chic pa tinamit Jerusalén. Y ri Jesús xbe pa racho ri Dios. Pero tok rija' xoc-apu chiri', xerelesaj-e ri vinük ri ye c'ayin y ri ye lok'on. Y xerutecmayila' can ri qui-mesas ri vinük ri jaloy-ruvüch tumin. Y quiri' chuka' xbün cheque ri quich'acat ri vinük ri nquic'ayila' palomas. ");
INSERT INTO cakENT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Y rija' man xrajo' tüj que ri vinük quic'uan aka'n, nyec'o ta chupan ri xulan chuvüch ri racho ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","C'ateri' rija', xuc'ut chuka' chiquivüch ri vinük riq'uin ri rutzij ri Dios, que ri racho ri Dios xa richin oración. Romari' rija' xbij cheque ri vinük: ¿Man tz'iban tüj comi chupan ri rutzij ri Dios que ri vacho jay richin nquibün orar conojel vinük ri yec'o chuvüch ri ruch'ulef? Pero rix xa man quiri' tüj ri' icusan-vi, xa ibanun quijul elek'oma' chin, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Y ri' tok xcac'axaj-pe ri nimalüj cheque ri sacerdotes y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés, xquixbij-qui' chuvüch ri Jesús roma ri vinük xsatz quic'u'x riq'uin ri tzij ri nbij ri Jesús cheque, romari' xquitz'om c'a nquicanoj achique na rubanic nquibün richin nquicamsaj ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Y tok xka-ka-pe ri k'ij, ri Jesús y ri rachibila' xbe c'a. Man xc'uje' tüj chiri' pa tinamit Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cumaj yan chuca'n k'ij, tok quitz'amon bey pa Jerusalén, xquitz'et que chaki'j chic ri che' higuera ri xch'o can ri Jesús riq'uin, que man jun bey chic xtuya' ruvüch. ");
INSERT INTO cakENT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Y ri Pedro chanin xuc'uxaj, y xbij chin ri Jesús: Maestro, tatz'eta' na la che' la higuera. Ya xchaki'j chic cachi'el ri xabij, xbij ri Pedro. ");
INSERT INTO cakENT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pero ri Jesús xbij cheque conojel ri rachibila': Rix chuka' nc'atzin que tiya' ronojel ivánima riq'uin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Roma riq'uin quiri', ketzij ninbij chive que achique na ri nbin chin ri juyu' re' que tel-e chere' y tic'o chupan ri mar, quiri-vi nbanatüj. Si ketzij nuya' ránima y man npu'u tüj pa ránima que xa man nbanatüj tüj quiri'. ");
INSERT INTO cakENT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Roma ri', yin ninbij chive que ronojel ri nic'utuj tok rix nibün orar y ninimaj na vi que chive, nivil na vi ri nijo'. ");
INSERT INTO cakENT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Y tok nibün orar, chin man jun nk'aton richin. Roma si xa c'o ta jun ri c'o rubanun chive, ticuyu'. Richin quiri' ri Itata' chicaj nyixrucuy chuka' rix riq'uin ri imac ri nye'ibanala' chuvüch rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Roma si rix xa man ncuy tüj rumac jun ri c'o rubanun chive, chuka' ri Itata' chicaj man ncuy tüj ri imac ri nye'ibanala' chuvüch rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ri Jesús y ri rachibila' xe'apon chic c'a pa tinamit Jerusalén. Y chiri' pa racho ri Dios c'o-vi rija' tok xe'apon ri nimalüj tak sacerdotes riq'uin, y chuka' ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri rajatük tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Y xquic'utuj c'a chin: ¿Achique xuyo'on ruchuk'a' rutzij pan ak'a' chin xe'avokotaj-e ri vinük ye c'ayin chere' pa racho ri Dios? ¿Y achique xbin chave que que'abanala' quere'? xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Y ri Jesús xutzolij ri tzij cheque chuka' y xbij cheque ri achi'a' ri': Yin chuka' c'o jun ninjo' ninc'utuj chive. Y si rix nibij chuve, yin chuka' ninbij chive achique yo'on can ruchuk'a' chuve richin quere' ninbün. ");
INSERT INTO cakENT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tivac'axaj c'a utz ri ninc'utuj chive. ¿Ri Juan xtak-pe roma ri Dios chin xerubün bautizar ri vinük? ¿O xa vinük xebin chin que tubana' quiri'? Tibij c'a chuve ri achique ninuc, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Y ri nimalüj tak sacerdotes, ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y chuka' ri rajatük tak achi'a' ri c'o quik'ij, xquibila' chiquivüch: ¿Achique xtikabij chin ri Jesús vocomi? xquibij. Roma si nkabij que ri Juan ja ri Dios takayon-pe chin, ri Jesús xtubij cheke que si c'o roma man xinitakej tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Y si nkabij que xa vinük xebin chin ri Juan que tubana' quiri', c'ayuf cheke roj. Rije' xquinuc quiri', roma quixbin-qui' chiquivüch ri vinük. Roma conojel ri vinük quiniman-vi que ri Juan xuk'alajrisaj-vi ri xbix chin roma ri Dios. Xa jun rusamajel ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Y c'ateri' rije' xquibij-apu chin ri Jesús: Roj man ketaman tüj, xquibij. Y ri Jesús xutzolij ri tzij cheque, y xbij cheque: Roma rix xa man xixtiquer tüj xibij chuve, quiri' chuka' yin man ninbij tüj chive achique ruyo'on can ruchuk'a' rutzij chuve chin nyenbanala' quere', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Y ri Jesús, riq'uin ejemplos xch'o-vi quiq'uin. Rija' quere' xbij cheque: Xc'uje' c'a jun achi ri xutic ruvüch ri rulef riq'uin uva. Xutz'apij rij ri rulef y xbün chuka' cachi'el jun vit pila pan ulef richin niyitz' ri uva. Xbün chuka' jun jay ri nüj rupalen, y pari' ri jay ri' xc'uje-vi racho ri jun achi nchajin chin ri ulef. C'ateri' xuya' can pa kajic cheque ca'i-oxi' samajela', y rija' xbe nüj. ");
INSERT INTO cakENT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Y ri rajaf ri ulef xutük c'a jun rusamajel quiq'uin ri achi'a' ri ye kajoy ri ulef tok tiempo chic richin nberuc'ulu-pe ri uva kajbül chin ri ulef. ");
INSERT INTO cakENT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero tok xapon ri samajel quiq'uin ri achi'a' ri ye kajoy ri ulef, ri kajoy tak ulef ri' xquitz'om c'a ri samajel y xquich'ey, y man nijun uva xquiya-e pa ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Y ri rajaf ri ulef xutük jun chic samajel quiq'uin ri kajoy tak ulef, chuc'amic ri uva kajbül richin ri ulef. Pero ri achi'a' kajoy tak ulef xa chi abüj xquic'ul-apu y xquisoc-e pa rujolon. Q'uiy ri xquibanala' y xquibila-e chin, y quiri' xquitük-e. ");
INSERT INTO cakENT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pero ri rajaf ri ulef xutük jun chic rusamajel. Y ri samajel ri' xcamsüs coma ri achi'a' ri ye kajoy ri ulef. Y ye juis ch'aka chic rusamajela' xerutük, pero conojel c'o xquic'ulachin. Yec'o xech'ay, y yec'o xecamsüs. ");
INSERT INTO cakENT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Y pa ruq'uisbül, ri rajaf ri ulef xaxe chic ri ruc'ajol xc'uje can riq'uin y rija' juis nrajo' ri ruc'ajol. Pero ri rajaf ri ulef xutük c'a ri ruc'ajol c'a quiq'uin ri achi'a' ri ye kajoy ri rulef, roma rija' xunuc: Ri achi'a' kajoy-ulef yinquitakej tok nquitz'et que ja ri nuc'ajol ri napon, xbij pa ránima. ");
INSERT INTO cakENT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero tok ri achi'a' ri ye kajoy chin ri ulef xquitz'et que ja ri ruc'ajol ri rajaf ri ulef ri xapon, xquibila' c'a chiquivüch: Jare' ri nrichinan ronojel ri ulef ri kakajon vocomi. Kacamsaj, richin quiri' pa kak'a' roj nc'uje-vi can ri ulef, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Y quiri' xquibün. Xquitz'om ri ruc'ajol ri rajaf ri ulef, xquicamsaj. Xquelesaj-e chiri' pa rulef. Rije' xbequitorij lojc'an chic ulef. ");
INSERT INTO cakENT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Y ri Jesús xbij: ¿Achique comi nbün ri rajaf ri ulef quiq'uin ri achi'a' kajoy tak ulef? Ri rajaf ri ulef npu'u y nyerucamsaj ri kajoy tak ulef ri' y ri rulef nuya' can pa kajic cheque ch'aka chic. ");
INSERT INTO cakENT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Y man jun bey comi chuka' itz'eton ri jun tzij tz'iban can chupan ri rutzij ri Dios? que nbij quere': C'o jun abüj man xka' tüj cheque ri ch'aka banuy tak jay. Pero ri abüj re' nc'atzinej, roma ri abüj re' xa ri xucusan chin ri jay chin ri jay ri' man ntzak tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ja ri Ajaf xbanun re', y ri runak' tak kavüch man jun bey quitz'eton que nbanatüj tüj quere'. Quiri' nbij ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Y ri achi'a' ri xech'o riq'uin ri Jesús xcajo' ta xquitz'om tüj rija', roma xquinabej que ri achi'a' kajoy tak ulef ri xeruk'alajrisaj chupan ri ejemplo, xa chiquij rije' xch'o. Y xa man nijun xquibün richin xquitz'om tüj roma nquixbij-qui' chiquivüch ri vinük ri yec'o riq'uin. Romari' rije' xquiya' can ri Jesús y xebe. ");
INSERT INTO cakENT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Y ri achi'a' ri' yec'o c'a ch'aka chic cachibil ri xequitük-pe. Xequitük-pe ca'i-oxi' achi'a' fariseos y chuka' ye ca'i-oxi' ruvinak ri rey Herodes, richin nquinaka' ri Jesús y ntzak ta pa quik'a' riq'uin rutzij ri nbij. ");
INSERT INTO cakENT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","C'ateri' rije' xepu'u y xquibij chin ri Jesús: Maestro, roj ketaman que xaxe ri ketzij ri nka' chave y jari' ri ncatzijoj. Y rat man naxbij tüj chuka' avi' chuvüch nijun vinük, stape' (aunque) juis ta ruk'ij. Y nac'ut ri rutzij ri Dios pa ruchojmil. ¿Achique c'a nabij cheke? ¿Utz comi que nkatoj ri alcaval ri nbij ri rey César ri nc'atzinej nkatoj o xa man utz tüj que nkatoj chin? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero ri Jesús retaman yan que riq'uin ca'i' quipalüj nquic'utuj quiri'. Romari' rija' xbij cheque: ¿Achique c'a roma rix nitij ik'ij chuvij chin nquininük y nquitzak ta pan ik'a' nijo'? Tic'ama-pe ri tumin ri' chin nintz'et achique ruvüch, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Y rije' xbequic'ama' c'a pe ri tumin chin nquic'ut chuvüch. Y rija' xuc'utuj cheque: ¿Achique ruvachbül c'a la'? ¿Y achique rubi' chuka' la c'o chuvüch la tumin? xbij rija'. Y rije' xquibij: Richin ri rey César, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Y jari' tok ri Jesús xbij cheque: Titojo' ri alcaval chin ri César ri c'uluman que niya' chin rija'. Y tiya' chin ri Dios ronojel ri c'uluman que niya' chin rija', xbij ri Jesús cheque. Y rije' xsatz quic'u'x tok xcac'axaj ri xbij ri Jesús cheque, roma man xetiquer tüj xquinaka'. ");
INSERT INTO cakENT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Y jari' tok ch'aka cheque ri achi'a' saduceos xe'apon riq'uin ri Jesús. Ri achi'a' re' man nquinimaj tüj que ri caminaki' nyec'astüj chic pe. Y roma ri' rije' xquibij chin ri Jesús: ");
INSERT INTO cakENT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","C'o jun nkajo' nkac'utuj chave. Ri Moisés rutz'iban can cheke, que tok jun achi nuya' can ri rixjayil roma ncom-e y man jun ralc'ual ncanaj can nc'atz'inej si c'o jun ruchak' o runimal rija' que nc'ule' riq'uin ri malca'n-ixok, richin quiri' nyecanaj ta ralc'ual riq'uin ri ixok malca'n. Y si yec'o ralc'ual nyecanaj riq'uin ri ixok, ri nabey ala' ntoc ralc'ual ri camnük chic. ");
INSERT INTO cakENT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Y rije' xquibij c'a: Quiri' c'a xec'uje' ye vuku' (siete) achi'a' quichak'-qui'. Ri nabey xc'ule'. Pero xcom-e, y man jun ralc'ual xcanaj. ");
INSERT INTO cakENT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Xpu'u ri ruca'n achi, ri ruchak' ri achi ri camnük chic e, xc'ule' riq'uin ri malca'n ixok. Pero chuka' ri achi ri' xcom-e y man jun ralc'ual xcanaj. Ri rox achi can jari' chuka' xuc'ulachij-e, cachi'el ri ca'i' nabey tak runimal y ri ixok xcanaj chic can ruyon. ");
INSERT INTO cakENT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Y quiri' ri ye vuku' (siete) achi'a' quiri' xquic'ulachila-e. Y man nijun cheque ri vuku' achi'a' ri' xcanaj ta can ralc'ual. Y pa ruq'uisbül xcom-e ri ixok chuka'. ");
INSERT INTO cakENT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Y ri achi'a' saduceos xquibij chin ri Jesús: Rat nabij que napon jun k'ij tok ri caminaki' nyec'astüj-pe. Tok napon ri k'ij ri', ¿achique rixjayil ntoc ri ixok ri'? Roma xc'ule' chiquivüch ri ye vuku' achi'a' quichak'-qui' xc'uje' quiq'uin, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Y ri Jesús xutzolij ri tzij cheque ri achi'a' ri y xbij: ¿Man rix satznük tüj riq'uin ri xibij, roma man k'axnük ta chive ri nbij chupan ri rutzij ri Dios? ¿Man ivetaman tüj que ri ruchuk'a' ri Dios juis nim? ");
INSERT INTO cakENT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Roma tok ri caminaki' nyec'astüj chic e, man nyec'ule' ta chic, nixta nquiya' quic'ajol o quimi'al richin nyec'ule'. Xa nye'oc cachi'el ri ángeles ri yec'o chila' chicaj. ");
INSERT INTO cakENT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Y ri caminaki' can nyec'astüj-vi, y yin ninnuc que rix utz ivetaman achique ri tz'iban can roma ri Moisés, tok rija' xutz'et ri jun k'ayis c'o ruq'uixal, nc'at, y chiri' xbech'o-pe ri Dios chin y xbij: Ja yin ri ru-Dios ri Abraham, ri ru-Dios ri Isaac y ri ru-Dios chuka' ri Jacob, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Y si ta rije' ye caminaki' chi jumul y xa man ta nyec'astüj chic pe jun bey, ri Dios man ta qui-Dios rije', roma ri Dios qui-Dios vi ri c'o quic'aslen y man quichin tüj ri caminaki'. Romari' yin ninbij que xa rix satznük riq'uin ri nibij, xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Y jari' tok xjel-apu riq'uin ri Jesús jun etamanel chin ri ley ri xuya' ri Dios richin ri Moisés. Ri etamanel ri' xrac'axaj ri xquibij ri achi'a' saduceos chin ri Jesús, y xrac'axaj chuka' ri xbij ri Jesús cheque ri achi'a' ri'. Y chuvüch rija' k'alüj vi que utz ri xbij ri Jesús y c'ateri' xuc'utuj: ¿Achique cheque ri mandamientos ri xuya' ri Dios pa ruk'a' ri Moisés, ri c'o pa nabey? xbij chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Y ri Jesús xbij chin: Ri nabey mandamiento ja ri nbij: Tivac'axaj c'a rix aj-Israel, ri Kajaf xaxe jun, y ri' ja ri Kajaf Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tijo' c'a ri Dios ri Ivajaf. Tijo' riq'uin ronojel ivánima. Tijo' chupan ronojel ri ic'aslen, riq'uin ri inojibül y riq'uin chuka' ronojel ri ivuchuk'a'. Jare' ri mandamiento ri más nim rakalen. ");
INSERT INTO cakENT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Y c'o chuka' jun ruca'n mandamiento juis rakalen y jubama junan riq'uin ri nabey. Y ri mandamiento ri' nbij: Cachi'el najo-avi' rat, quiri' chuka' que'ajo' ri ch'aka chic. Y ja ca'i' mandamientos re' ri más ye nimak' yec'o, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Y ri etamanel chin ri ley ri xuya' ri Dios richin ri Moisés xbij c'a chin ri Jesús: Maestro, xbij chin. Quiri' na vi. Ketzij ri xabij que xaxe jun Dios c'o, y man jun chic. ");
INSERT INTO cakENT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nc'atzin que nkajo' riq'uin ronojel kánima. Nc'atzin que nkajo' riq'uin ri kanojibül, riq'uin ri ronojel ri kac'aslen y riq'uin chuka' ronojel ri kuchuk'a'. Y cachi'el chuka' nkajo-ki' roj, quiri' chuka' quekajo' ri ch'aka chic. Si nyekabün re', más cakalen que chuvüch ri chico ri nyesuj chin ri Dios, tok ronojel o man ronojel tüj ri ti'ij nporox, xbij ri etamanel. ");
INSERT INTO cakENT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Y tok ri Jesús xrac'axaj que utz na vi xk'ax chin ri jun etamanel ri', ri Jesús xbij chin: Rat xa man nüj tüj chic ratc'o-vi chin ncatoc pa ruk'a' ri Dios, xbij chin. Y jari' tok nijun chic xuya' ruchuk'a' richin c'o ta achique xuc'utuj chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Y ri Jesús richin nyerutijoj ri vinük ri quimolon-qui' riq'uin, chiri' pa racho ri Dios, xbij cheque: ¿Achique c'a roma ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés nquibij que ri Cristo, ri Jun cha'on-pe y takon-pe roma ri Dios, xa choj jun ruxquin-rumam can ri rey David? ");
INSERT INTO cakENT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tok xa ja ri rey David xbin ri xk'alajrisüs chin roma ri Lok'olüj Espíritu. Ri David xbij: Ri Ajaf Dios xbij chin ri Vajaf ri Cristo: Catz'uye-pe pa vajquik'a' (nu-derecha), y nyenya' pan ak'a' ri vinük ye itzel chavij. Quiri' xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Y si ri rey David tok xc'ase' chuvüch ri ruch'ulef xbij Vajaf chin ri Cristo, ¿achique c'a roma tok ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés nquibij que ri Cristo xa choj jun ruxquin-rumam can ri rey David? xbij ri Jesús. Y juis ye q'uiy cheque ri vinük chiri' riq'uin ronojel cánima xcac'axaj ri xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Y ri Jesús xbij chuka' cheque ri vinük tok nyerutijoj: Man tibün cachi'el nquibün ri achi'a' ye etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés. Roma rije' juis nka' chiquivüch nquicusaj tukutük tak tziük, richin quiri' titz'et que juis quik'ij. Juis chuka' nka' cheque que nyeban saludar pa bey ape' nyequimol-qui' ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Y pa tak jay ape' ntzijos ri rutzij ri Dios, ja ri nabey tak ch'acüt nquicanoj, richin quiri' tibix que juis quik'ij. Y quiri' chuka' nyequibanala' pa nimak' tak va'in. ");
INSERT INTO cakENT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Y ri achi'a' ri' nyequelesala' ronojel ri quichajin ri malca'n tak ixoki'. Y xe richin quenimüx que rije' ye utz tak vinük, nyelayuj tok nquibanala' oración chin ri Dios. Pero rije' nquil más castigo, roma ri quimac juis q'uiy, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Y ri Jesús tz'uyurnük chiri' chuvüch apu ape' c'o-vi ri yacbül chin tumin ri c'o chiri' pa racho ri Dios. Jari' tok rija' nyerutz'et ri vinük tok nquiyala' can tumin chiri'. Xerutz'et ye q'uiy beyoma' ri juis q'uiy tumin nquiyala' can. ");
INSERT INTO cakENT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pero xapon chuka' jun malca'n-ixok ri nk'alajin que man beyon tüj. Rija' xuya' can ca'i' tak tumin ri man rubanun tüj ni jun centavo. ");
INSERT INTO cakENT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Y tok ri Jesús xutz'et ri ixok ri', xuc'ut chiquivüch ri rachibila' y xbij cheque: Ketzij ninbij chive que yin nintz'et que xa ja la ixok la' ri xyo'on can más q'uiy, que chiquivüch conojel ri ye yo'on can tumin pa racho ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Roma rija', stape' (aunque) man q'uiy tüj oc rajil xuya' can, rija' xuya' ronojel ri ruchajin. Pero la ch'aka chic, stape' (aunque) juis q'uiy tumin xquiyala' can, xa ba' oc chin ronojel ri quibeyomal, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Y tok ri Jesús xel-pe pa racho ri Dios, jun cheque ri rachibila' xbij chin ri Jesús: Maestro, xbij. Tatz'eta' ri rubanun can chin ri racho ri Dios, y ri abüj ri ye ucusan chin, xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Y ri Jesús xbij chin ri rachibil: Rat natz'et que ri jay re' ye jabel banun y ye nimak', pero napon jun k'ij chin ronojel re' nq'uis. Nyevolotüj-pe ri jay y ronojel abüj nyetzak-pe y man nyepa'e' tüj chic. Ronojel ri nimalüj tak abüj ri ye ucusan cheque ri jay re', man cachi'el tüj rubanun vocomi. ");
INSERT INTO cakENT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Y tok ri Jesús tz'uyurnük chic cho tz'alan ri juyu' rubini'an Olivos, ape' jabel nquitz'et-pe ri racho ri Dios, jari' tok ye caji' cheque ri rachibila': Ri Pedro, ri Jacobo, ri Juan y ri Andrés xejel-apu riq'uin ri Jesús y xquic'utuj chin: ");
INSERT INTO cakENT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Tabij cheke: ¿Jampe' c'a nbanatüj ri xabij yan ka riq'uin ri racho ri Dios? ¿Y achique retal chin quiri' ninabex que nbanatüj yan? xquibij rije'. ");
INSERT INTO cakENT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Y ri Jesús xutzolij ri tzij cheque y xutz'om xbij cheque: Titz'et y tina-ivi' chin man nyixch'acatüj. ");
INSERT INTO cakENT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Roma ye q'uiy vi nyebec'ulun-pe y nquibila': Ja yin ri Cristo, nquibij. Y ye juis ye q'uiy ri nyech'acatüj pa quik'a'. ");
INSERT INTO cakENT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Y tok nivac'axaj que yec'o ruch'ulef ri ntajin oyoval chiquicojol, y nivac'axaj chuka' que quiri' cha nyebanatüj, que c'o cha oyoval ri nyepu'u, man tisatz ic'u'x, roma ronojel ri' xa ncatz'inej na vi nyebanatüj ri'. Pero ri' xa man ja tüj ri ruq'uisbül k'ij chin ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jun tinamit ncatüj c'a e richin nberubana' oyoval riq'uin jun chic tinamit. Yec'o chuka' ye nimak' tak ruch'ulef nyecatüj-e chin nquibanala' oyoval quiq'uin ch'aka chic nimak' tak ruch'ulef. Nyepu'u cab-rakün q'uiy lugar. Nyepu'u chuka' vayjül, y q'uiy quivüch oyoval nyepu'u chiquicojol ri vinük pa tak ruch'ulef. Y re' xa c'ateri' ri nabey tak k'oxomül y nyepu'u ch'aka chic quivüch pokonül. ");
INSERT INTO cakENT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pero rix tichajij-ivi' jabel. Roma yec'o achi'a' nyixquijüch pa quik'a' ri achi'a' ape' nquibün juzgar. Y chuka' nyixch'ay pa tak jay ape' ntzijos-vi ri rutzij ri Dios nyixuc'u'üx c'a chiquivüch gobernadores, chiquivüch reyes y ch'aka chic autoridades. Y xa voma yin nic'ulachij quiri', pero xa nyixtiquer nquinikalajrisaj chiquivüch rije'. ");
INSERT INTO cakENT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ri utzilüj tzij chin colonic nc'atzinej que ntzijos pa ronojel ruch'ulef nabey, c'ateri' nka-ka ri ruq'uisbül k'ij chin ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Y tok nyixcamox-pe chiquivüch chin nyixjachox pa quik'a', man tinuc q'uiy chin achique tzij ri nye'ibij. Rix xaxe tibij achique tzij ri nuya' ri Dios chive, roma xa man ja tüj chic rix ri nyixch'o chupan ri hora ri', xa ja ri Lok'olüj Espíritu ri nch'o. ");
INSERT INTO cakENT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Roma nbanatüj chuka' que si yec'o ye ca'i' achi'a' quichak'-qui', jun cheque rije' ncatüj y nujüch ri ruchak' o runimal pa camic. Chuka' yec'o-vi tata'aj ri nyecatüj chiquij ri calc'ual. Ri ac'uala' nyecatüj chuka' chiquij ri quite' y quitata' y nyequiya' pa camic. ");
INSERT INTO cakENT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Y conojel ri vinük juis itzel nyixquitz'et, roma iyo'on ivánima viq'uin yin. Pero ri man nutzolij tüj ri' chirij y nucoch' pa ruq'uisbül chin ronojel, jari' nucol-ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Y chuka' napon-vi ri k'ij tok nyebanatüj ri xajan tak nojibül chupan ri lugar ape' xa man utz tüj nyebanatüj. Y riq'uin ri' nvulaj can ri lugar ri'. Jari' ri tz'iban can roma ri Daniel, ri jun cheque ri achi'a' ri xek'alajrisan ri xbix cheque roma ri Dios, ojer can. Ri ntz'eton c'a ri tz'iban can, tik'ax chin ri nutz'et. Richin quiri' tok nitz'et que ja chic ri' ri nbanatüj, ri vinük ri yec'o pa ruch'ulef Judea xa que'anmüj-e y tibequevaj-qui' cho tak juyu'. ");
INSERT INTO cakENT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ri xa nuxlan cho jay tok nvulutüj ronojel ri', choj quiri' tanmüj-e. Man toc chic apu pa racho richin c'o ri nberuc'ama-pe. Man tubün quiri'. ");
INSERT INTO cakENT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ri nsamüj pa k'ayis, man titzolij chic pa racho chin nuc'ama' rutziek ri cachi'el coton. Más utz choj tanmüj-e. ");
INSERT INTO cakENT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ja ri ixoki' ri coyoben chic ac'uala', y ri ixoki' ri nquiya' quitz'un tak cal, juya' quivüch tok napon ri k'ij ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Roma ri' xa tic'utuj chin ri Dios que tok nvulutüj ri' man ta nbanatüj chupan ri tiempo richin tef, chin man c'ayuf tüj nbün chive chin nyixanmüj. ");
INSERT INTO cakENT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Roma tok napon c'a ri k'ij ri', nc'o ruvi' pokonül ri npu'u. Jun pokonül ri man jun bey xuc'ulun tüj pari' ri ruch'ulef jampe' ri banun can roma ri Dios. Y chuka' ri pokonül ri' man jun bey chic nc'ulun. ");
INSERT INTO cakENT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Y si ta ri Ajaf Dios man ta nuch'utinirsaj ri k'ij chin ri pokonül ri', conojel ta nyecom. Pero roma juis ránima quiq'uin ri nyerucha'on chic, romari' nuch'utinirsaj ri k'ij ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chupan ri k'ij ri', si yec'o vinük nyebin chive: Titz'eta' ri Cristo, ri Jun cha'on-pe y takon-pe roma ri Dios, jari' c'o re'. O si nquibij chive: Titz'eta', jari' c'o la'. Pero rix man quixch'acatüj pa quik'a'. Man tinimaj ri nquibij chive. ");
INSERT INTO cakENT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Roma yec'o ri nyebec'ulun-pe y nquibij: Ja yin ri Cristo. Pero rix man que'inimaj, roma xaxe ch'aconela' quichin vinük. Y ja chuka' tiempo ri' tok nyebec'ulun-pe ri nyebin: Yin nink'alajrisaj ri nbij ri Dios chuve, nquibij. Pero rix man c'a nye'inimaj, roma xaxe ye ch'aconela' quichin vinük chuka'. Y nyequibanala' milagros ri man jun bey ye tz'eton tüj, xaxe richin nyenimüx ta y yec'o ri nyequich'üc. Y si ta xa nyetiquer, rije' nyequich'üc ta chuka' ri ye cha'on chic roma ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero rix tichajij-ivi', chin man nyixch'acatüj, roma re' ya xinbij can chive ronojel ri nyebanatüj. ");
INSERT INTO cakENT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Chupan ri k'ij tok ya c'unük chic ri pokonül ri', nbanatüj c'a que ri k'ij nk'ekumür y ri ic' chuka' man nsaker tüj chic. ");
INSERT INTO cakENT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ri ch'umila' nyetzak-e ape' yec'o-vi. Ronojel ri nimalüj tak uchuk'a' ri yec'o chicaj nyesilon roma ri ruchuk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jari' tok yinquitz'et yin ri xinalüx chi'icojol, que nquika-pe pa sutz', riq'uin nimalüj uchuk'a' y c'o chuka' chic nuk'ij. ");
INSERT INTO cakENT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Y jari' tok yin nyentük ri nu-ángeles chin nyemolotüj ye nucha'on chic, nyemolotüj-pe chuvüch caji' ruvüch ruch'ulef hasta pan oriente, pan occidente, chiri' pa norte y chiri' chuka' pa sur. Nyequimol-vi-pe chi jun ruch'ulef. Ntzucutüj-pe pa jun rutza'n ri caj, c'a la jun chic rutza'n. ");
INSERT INTO cakENT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Vocomi c'a tic'ama' ina'oj pari' ri che' higuera. Tok nyeraxür-pe ri ruk'a' y ri ruxak nyevulvu', ivetaman c'a ri' que ri ru-tiempo ri job nobos yan. ");
INSERT INTO cakENT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Y quiri' c'a tok nitz'et que yec'o chic nyec'ulachitüj chupan ri k'ij, ri ic' y ri ch'umila', y ronojel ri xinbij yan nbanatüj chic, tivetamaj c'a ri' que nobos yan ri k'ij. Xa nakaj chic c'o ri k'ij nquinobos yan. ");
INSERT INTO cakENT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Y tivac'axaj c'a jabel ri ninbij chive vocomi: Ronojel re' nuc'ulun, tok ri vinük richin ri tiempo re' man jani nyeq'uis-e chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Y ri ruch'ulef y ri caj nyeq'uis. Pero ri nutzij yin man nq'uis tüj quiri', xa nbanatüj-vi can ri nbij. ");
INSERT INTO cakENT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pero ri k'ij y ri hora tok yin nquipu'u, man jani k'alüj tüj. Ri ángeles ri yec'o chila' chicaj man quetaman tüj jampe'. Quiri' chuka' yin ri C'ajol man vetaman tüj. Xaxe c'a ri Nata' Dios ri etamayon ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Rix xa tichajij-apu jabel ri ic'aslen. Tivoyobej c'a, y tibana' chuka' orar, roma man ivetaman tüj jampe' napon ri ruk'ijul tok nquipu'u. ");
INSERT INTO cakENT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Cachi'el jun achi nuya' can racho y nbe nüj pa jun chic tinamit. Rija' nuchilabej c'a ri rusamaj cheque ri rusamajela'. Nuyala' can quisamaj chiquijujunal. Y chin ri chajinel nbij can que chi jumul troyobej-apu. ");
INSERT INTO cakENT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Quiri' c'a tibana' rix, jumul quinivoyobej-apu. Cachi'el ri achi chajinel, roma man retaman tüj jampe' nobos ri rajaf ri jay, rija' nc'atzinej nroyoben-apu. Roma ri rajaf ri jay riq'uin ba' nobos tok ntoc-pe ri ak'a', o ja pa runic'ajal-ak'a', tok nyesiq'uin-pe ri üc' cumaj yan, o ja tok nsaker-pe yan. Romari' rix chi jumul c'a quinivoyobej-apu. ");
INSERT INTO cakENT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Roma yin ninjo' que nquinivoyobej ta apu, roma man ninya' tüj na rutzijol tok nquipu'u. ");
INSERT INTO cakENT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Y cachi'el ri ninbij chive rix que quinivoyobej-apu, quiri' chuka' ninbij cheque conojel, xbij ri Jesús cheque ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xa ca'i' chic k'ij nrajo' chin napon ri ca'i' quinimak'ij ri israelitas. Ri jun quinimak'ij ri israelitas rubini'an pascua. Y ri jun chic ja tok nquic'ux ri caxlan-vüy ri manak levadura riq'uin. Y jari' tok ri nimalüj tak sacerdotes y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés nquinucula' achique tzij man ketzij tüj nyequicusaj chin ntzak ri Jesús pa quik'a' y c'ateri' nquicamsaj. ");
INSERT INTO cakENT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Y nquibij chiquivüch: Man tikatz'om chupan ri nimak'ij re', chin man nyecatüj-pe ri vinük chikij, xquibij rije'. ");
INSERT INTO cakENT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Y ri Jesús c'o chic pa tinamit rubini'an Betania, chiri' pa racho ri Simón ri xc'achojrisüs chin ri yabil rubini'an lepra. Ri Jesús tz'uyul chuchi' ri' mesa nva'. Jari' tok c'o jun ixok xoc-apu y ruc'uan-apu jun bambül banun riq'uin jun abüj rubini'an alabastro y c'o nardo chupan, jun jubulüj ak'on ri juis jotol rajil. Y tok ri ixok ri' xrelesaj-e ri vit rukul ri bambül, xuk'üj ri jubulüj ak'on pa rujolon ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Y yec'o ch'aka chiquicojol ri yec'o chiri' ri xpu'u coyoval tok xquitz'et que quiri' xbün ri ixok riq'uin ri jubulüj ak'on y xquibij c'a: ¿Achique roma ri' la ixok la' xbün que choj quiri' xutix-e la jubulic ak'on la'? ");
INSERT INTO cakENT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Roma xa xbe ta chi más oxi' ciento quetzales, y ri tumin ri' xtalux ta cheque ri vinük ri manak quichajin, xquibij. Y juis xech'o chin ri ixok. ");
INSERT INTO cakENT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero ri Jesús xbij c'a cheque: ¿Achique roma man nyixtane' ta ka chi tzij chirij? Xa tiya' can. Rija' jun utzilüj nojibül xbün viq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ri vinük ri manak quichajin xa chi jumul yec'o iviq'uin, y achique na k'ij nijo' nye'ito', tibana' c'a favor cheque. Pero yin man chi jumul tüj nquic'uje' iviq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Rija' xbün ri achique ntiquer nbün viq'uin. Rija' xa xbün yan favor chin tok yinquibemuk can. ");
INSERT INTO cakENT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Y tivac'axaj na pe' utz ri ninbij chive, que achique na lugar ape' ntzijos ri utzilüj tzij richin colonic, chiri' chuka' ntzijos ri xbün ri jun ixok re'. Ronojel ruch'ulef ntzijos, y man jun bey numestüs, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Y jun c'a cheque ri ye doce rachibila' ri Jesús, ri rubini'an Judas Iscariote, xapon quiq'uin ri nimalüj tak sacerdotes, chin xusuj-ri' si ncajo' que nujüch ri Jesús pa quik'a'. ");
INSERT INTO cakENT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Y tok rije' xcac'axaj quiri', juis xequicot. Y xquisuj rutumin romari'. Y rija' xutz'om xucanoj achique na rubanic nbün richin nujüch ri Jesús pa quik'a' ri achi'a' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Xapon c'a ri nabey k'ij richin ri nimak'ij tok nc'uxtüj ri caxlan-vüy manak levadura riq'uin. Ja chuka' k'ij ri' tok nyecamsüs y nyesujüs chin ri Dios ri alaj tak ovejas richin ri pascua. Jari' tok ri rachibila' xquic'utuj chin ri Jesús: ¿Ape' najo' que nabün ri va'in chupan ri jun pascua re', chin nkube chin kabana' ruc'ojlen ronojel ri nc'atzin? xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Y ri Jesús xerutük-e ye ca'i' cheque ri rachibila', y xbij cheque: Quixbiyin pa tinamit Jerusalén, y chiri' nitz'et jun achi samajel ruc'uan ruya' pa jun cura'. Titzeklebej. ");
INSERT INTO cakENT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ri jay ape' ntoc-apu rija', chiri' chuka' quixoc-apu rix y quixch'o riq'uin ri rajaf ri jay y tibij chin: Ri Maestro rubin-pe: ¿Achique cuarto chere' pan avacho ri utz tüj richin ninbün ri va'in richin ri pascua ye vachibilan ri vachibil? tibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Y ri rajaf ri jay nuc'ut chivüch jun chic rutaslen ri racho nim rubanun chin. Pa jotol-e c'o vi. Y chojmirsan chic rupan. Ja chiri' tibana' favor nbanatüj ri va'in chin ri pascua, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Y ri ca'i' rachibila' xebe c'a pa tinamit Jerusalén. Y tok xe'apon, xbanatüj na vi cachi'el ri rubin-e ri Jesús cheque. Y rije' xquibün-vi ronojel ri nc'atzin richin ri va'in richin ri pascua ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tok xcok'a-ka, jari' tok ri Jesús y ri doce rachibila' xe'apon chiri' pa jay. ");
INSERT INTO cakENT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Y tok rije' ye tz'uyul chic chuvüch ri mesa, y nyetajin chic nyeva', jari' tok ri Jesús xbij cheque ri rachibila': Ketzij ninbij chive, que jun chive rix ri nquiruc'ayij-e. Jun ri nva' viq'uin, jari' nquirujüch-e pa quik'a' ri vinük, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Rije' c'a jari' xebison-pe. Y nquic'utula' chin ri Jesús: ¿Man ja tüj comi yin ri ninbün quiri'? xquibij chiquijujunal. ");
INSERT INTO cakENT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Y ri Jesús xutzolij ri tzij cheque y xbij: Ri' ja ri jun chive rix doce, ri numuban ruvay viq'uin chupan ri bambül. ");
INSERT INTO cakENT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tivac'axaj ri ninbij chive, que yin ri xinalüx chi'icojol can nquibe-vi c'a ri' tok nquijach-e. Nbanatüj cachi'el ri tz'iban can. Pero juya' ruvüch ri njachon-e vichin yin ri xinalüx chi'icojol. Ri achi ri njachon-e vichin xe utz tüj que man ta xalüx, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Y tok ya nyetajin chic nyeva', ri Jesús xuc'ün-apu jun caxlan-vüy y xumatioxij chin ri Dios. C'ateri' xuper ri caxlan-vüy ri' y xuya' cheque ri rachibila'. Rija' xbij cheque ri rachibila' ri': Tic'ama' can ri caxlan-vüy re'. Roma jare' ri nuch'acul ri napon pa camic. ");
INSERT INTO cakENT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Y ri Jesús xuc'ün chuka' apu ri vaso ri c'o ruya'al-uva chupan: y tok xumatioxij chic chin ri Dios, xuya' cheque, y conojel c'a xquitij ri ruya'al-uva. ");
INSERT INTO cakENT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Y rija' xbij cheque ri rachibila': Jare' ri nuquiq'uel ri nbiyin tok nquicom. Riq'uin nuquiq'uel, jari' xc'achoj ri c'ac'a' trato ri xrajo' ri Dios que nbün quiq'uin ri vinük. Ri nuquiq'uel ri nbiyin, richin ye q'uiy vinük nyecolotüj. ");
INSERT INTO cakENT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tivac'axaj ri ninbij chive: Ja ruq'uisbül bey re' xintij-e ruya'al-uva. Y tok nintij jun bey chic, ja chupan ri utzilüj k'ij tok nbün mandar ri Dios. Y ri ruya'al-uva ri nintij chiri', jun c'ac'a' ruya'al-uva, xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Y tok quibixan chic c'a ri bix chin nquiya' ruk'ij ri Dios, ri Jesús y ri rachibila' xe'el-e chiri' pa jay y xebe pa juyu' Olivos. ");
INSERT INTO cakENT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Y tok ye benük c'a, ri Jesús xbij cheque ri rachibila': Chi'ivonojel rix nitaluj-e-ivi' y nquiniya' can nuyon chupan ri ak'a' re', tok xa nitz'et que yin nquijach-e pa quik'a' ri vinük. Roma ri Dios nbij-vi c'a chupan ri tz'iban can: Tok yin ninya' k'ij que ncamsüs ri k'uyunel, ri ovejas xa nquitaluj-e-qui'. Quiri' ri tz'iban can. ");
INSERT INTO cakENT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero yin ri K'uyunel man nquicom tüj e chi jumul, xa nquic'astüj-pe. Y ja yin ri nquinoyoben ivichin chila' pa Galilea, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Y ri Pedro xbij c'a: Si ri ch'aka chic ncatquiya' can ayon, yin man ncatinbün tüj quiri', xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jac'a ri Jesús xbij chin ri Pedro: Yin ketzij c'a ninbij chave que vocomi chupan ri jun ak'a' re', xa man jani tisiq'uin-pe ri mama' ca'i' mul, tok rat oxi' yan mul tabij cheque ri nyec'utun chave, que man avetaman tüj nuvüch, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero man riq'uin tüj ri xbij ri Jesús quiri', ri Pedro xa xbij chic apu chin ri Jesús: Si yin nc'atzinej nquicom junan aviq'uin rat, pero man jun bey ninbij que man vetaman tüj avüch. Y chuka' ri ch'aka chic rachibila' quiri' nquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ri Jesús y ri rachibila' xe'apon c'a chupan ri lugar rubini'an Getsemaní. Xpu'u ri Jesús xbij cheque ri rachibila': Quixtz'uye' na can ba' chere' y yin nquibana' orar. ");
INSERT INTO cakENT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Y xaxe c'a ri Pedro, ri Jacobo y ri Juan xeruc'uaj chirij. Jari' c'a xuna' yan ri nuc'ulachij. Jun bis juis nim xpu'u pa ránima. ");
INSERT INTO cakENT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Y xbij cheque ri ye oxi' rachibila': Ri bis c'o pa vánima, juis nim. Y nquirucamsaj ninna' yin. Quixc'uje' can chere', quixc'ase' y man quixvür, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Rija' xbiyin chic juba' apu y c'ateri' xxuque-ka y xukasaj-ka-ri' pan ulef y xbün orar. Rija' xuc'utuj que si ntiquer ta, choj ta nc'o-e ri hora ri', que man ta nuc'usaj ri pokonül. ");
INSERT INTO cakENT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Y quere' c'a ri tzij ri xerubij pa ru-oración: Nata', Nata', yin vetaman que rat ncatiquer nabün ronojel. Tabana' que man ta ninc'usaj yin ri jun pokonül re'. Pero man tabün chuka' ri ninrayij yin, xaxe voma yin. Roma yin xa ninjo' chuka' ninbün ri arayibül rat, xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Y tok rija' xtzakon-pe riq'uin ri oración, xpu'u quiq'uin ri ye oxi' rachibila', pero tok xapon quiq'uin xa nyevür. Xpu'u rija' xbij c'a chin ri Pedro: Simón, ¿xa xavür-ka? ¿Man juba' xatiquer xac'ase' jun vit hora viq'uin? ");
INSERT INTO cakENT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Man quixvür-ka, xa tibana' orar y tic'utuj chin ri Dios chin man quixtzak pa mac. Vetaman que ri rurayibül ri ivánima ja ri nbün ri nrajo' ri Dios. Pero iyon xa man nyixtiquer tüj, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Y ri Jesús xbe chic apu jun bey richin xberubana' orar. Y xbij ri cachi'el ri xbij-vi nabey. ");
INSERT INTO cakENT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Y tok xtzolij chic pa ruca'n mul quiq'uin ri ye oxi' rachibila' xa nyevür chic jun bey ri xeril, roma rije' xa al-al c'a runak' tak quivüch roma ri quivaran. Y rije' man nquil tüj achique nquibij, roma xe'ilitüj chic jun mul que quitz'amon varan. ");
INSERT INTO cakENT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Y ri Jesús xbe chic chin nbana' chic orar. Pero tok xtzolij chic pa rox mul, rija' xbij c'a cheque ri ye oxi' rachibila': ¿Nyixvür chic? ¿Nijo' nitz'akrisaj ri ivaran? Pero man nyixtiquer tüj chic. Ya xobos ri hora chin yin ri xinalüx chi'icojol nquijachatüj pa quik'a' ri itzel tak achi'a'. ");
INSERT INTO cakENT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Chanin, quixcatüj. Jala' petenük ri nquijachon-e pa quik'a' ri itzel tak achi'a', xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Y jari' tok ri Jesús c'a ntajin ntz'ijon quiq'uin ri rachibila', tok xobos ri Judas ri jun cheque ri doce rachibila', y ye ruc'uan c'a apu ye q'uiy vinük ri ye quic'amon che' y machet. Conojel re' ye takon-e coma ri nimalüj tak sacerdotes, coma ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y coma chuka' ri rajatük tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ri Judas ri njachon richin ri Jesús rubin cheque ri ye petenük chirij, achique rubeyal nbün richin nuc'ut ri Jesús chiquivüch. Rija' rubin-pe cheque: Ja ri nquijel-apu riq'uin richin nintz'ubaj richin ninbün saludar, jari' ri Jesús. Titz'ama', y man tanmüj chivüch. ");
INSERT INTO cakENT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Y tok ri Judas xobos, jari' choj xbe-apu riq'uin ri Jesús y xbij chin: Maestro, Maestro, xbij chin y c'ateri' xutz'ubaj richin nbün saludar. ");
INSERT INTO cakENT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Y ri vinük ri ye benük tz'amoy richin ri Jesús jari' xquitz'om. ");
INSERT INTO cakENT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Y jun cheque ri yec'o riq'uin ri Jesús chiri', xrelesaj ri rumachet, xuya' chin ri jun rusamajel ri nimalüj sacerdote, y ja ri ruxiquin xukupij-e riq'uin ri jun machet ri xuya' chin. ");
INSERT INTO cakENT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Y c'ateri' xpu'u ri Jesús xbij cheque ri vinük ri ye benük tz'amoy richin: ¿Achique c'a xinuc rix? ¿Xinuc que nyixpu'u chin nitz'om jun elek'on y romari' ic'amon-pe che' y machet? ");
INSERT INTO cakENT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yin k'ij-k'ij xinc'uje' iviq'uin chiri' pa racho ri Dios, tok xinc'ut ri rutzij chive y man jun bey xinitz'om tüj. Pero re' quere' na vi ri nbanatüj, roma jare' ri tz'iban can chupan ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jari' tok conojel ri ye rachibila' ri Jesús, xquiya' can ruyon y xe'anmüj. ");
INSERT INTO cakENT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero c'o c'a jun ala' ri rutzekleben ri Jesús y rutz'apin rij riq'uin jun c'ul. Y ri xetz'amon richin ri Jesús, xquitz'om ri ala' ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero rija' xa xel-e chupan ri c'ul ri', y choj quiri' xanmuj-e chiquivüch. Manak rutziek xbe. ");
INSERT INTO cakENT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Y ri vinük ri ye tz'amayon chin ri Jesús xquic'uaj chi racho ri nimalüj sacerdote. Y chiri' chuka' xquimol-qui' ri nimalüj tak sacerdotes, cachibilan ri rajatük tak achi'a' ri c'o quik'ij y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés. ");
INSERT INTO cakENT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Y ri Pedro xutzeklebej-apu chi nüj ri Jesús. Y tok xucusüs-apu ri Jesús pa racho ri nimalüj quitata' ri ye sacerdotes, chuka' ri Pedro xoc-apu chiri' cho jay. Y xtz'uye-ka chiquicojol ri samajela' ri yec'o-apu chiri', ye nquimek'-qui' chuchi' ri k'ak'. ");
INSERT INTO cakENT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Y ri nimalüj tak sacerdotes, y conojel ri achi'a' pa comon nquibün ri ley nquicanola' achique tak chok riq'uin ntzak pa quik'a' y nquitz'ucula' tzij chirij ri Jesús achique ta jun rumac nilitüj chirij chin jari' nquiya' rakal y quiri' nquicamsaj. Pero xa man jun ri xquil chirij. ");
INSERT INTO cakENT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Roma stape' (aunque) ye q'uiy ri xe'apon ri xquitz'uc tzij chirij, man xbequic'ulu' tüj qui' ca'i' junan ri nquibij chirij ri Jesús, y richin quiri' c'o ta ruchuk'a' ri nquibij richin nucusüs chirij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Y c'ateri' yec'o ch'aka chic ri xebepa'e' y quere' c'a xquitz'uc tzij chirij ri Jesús y xquibij: ");
INSERT INTO cakENT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Roj kac'axan tok rija' rubin: Yin ninvulaj ri racho ri Dios banun coma achi'a', y pan oxi' k'ij ninbün chic jun ri man achi'a' tüj nyebanun. ");
INSERT INTO cakENT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nixta riq'uin ri', man junan tüj chuka' ri xquibila'. ");
INSERT INTO cakENT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Y ri nimalüj quitata' ri sacerdotes, xbepa'e' pa quinic'ajal y xuc'utuj chin ri Jesús: ¿C'o roma rat man jun nic' ncach'o? ¿Ketzij na vi ri nquibila' ri achi'a' chavij? ¿Achique nabij vocomi? xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero ri Jesús nixta juba' xch'o. Nijun achique tüj xbij. Romari' xpu'u ri nimalüj quitata' ri sacerdotes, xuc'utuj chic chin y xbij chin: ¿Ja rat ri' ri Cristo ri Ruc'ajol ri Dios ri nkaya' ruk'ij? xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Y ri Jesús xbij c'a: Ja', ja yin. Y nquinitz'et chuka' que yin ri xinalüx chi'icojol que yin tz'uyul pa rajquik'a' (ru-derecha) ri Dios ri ntiquer nbün ronojel. Y nquinitz'et tok nquika-pe pa sutz' chila' chicaj. ");
INSERT INTO cakENT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tok ri nimalüj quitata' ri sacerdotes xrac'axaj ri', xuk'achij-ka ri rutziek chirij, roma itzel xrac'axaj y xbij c'a: Man nc'atzin tüj que nobos chic jun richin nbij cheke que ri Jesús xa aj-mac vi. ");
INSERT INTO cakENT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chi'ivonojel rix xivac'axaj que xbij que ja rija' ri Cristo. Itzel xbün chuvüch ri Dios. ¿Achique nibij vocomi? xbij rija'. Y conojel ri vinük jun xquibün y xquibij: Que vocomi ticamsüs. ");
INSERT INTO cakENT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Y yec'o ch'aka ri xquitz'om nquibün q'uiy itzel chin ri Jesús. Xquitz'om nquichubala'. Xquitz'apij ruvüch. Xquich'ey y c'ateri' nquic'utula' chin: ¿Achique ri xach'ayon? Tabij na cheke, xquibij chin. Y ri samajela' ri yec'o chiri', xquiyala' k'a' chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Y tok ri Pedro c'o c'a pa xulan chuvüch ri jay, c'o jun ixok raj-ic' ri nimalüj quitata' ri sacerdotes ri xapon chiri'. ");
INSERT INTO cakENT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ri Pedro numek-ri' chuchi-k'ak'. Y jari' tok xpu'u ri aj-ic' nutz'et-nutz'et apu ri Pedro, y c'ateri' xbij chin: Rat chuka' rat rachibila' ri Jesús ri aj-Nazaret, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero ri Pedro xa xrevaj c'a, roma xbij: Yin man vetaman tüj ruvüch ri Jesús. Man nk'ax ta chuka' chuve achique roma ri quiri' nabij chuve, xbij chin ri aj-ic'. Y ri Pedro xel-e chiri' chiquicojol y xbe chuchi-bey. Y jari' tok ri mama' xsiq'uin-pe. ");
INSERT INTO cakENT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Y tok ri ixok aj-ic' xutz'et chic jun bey ri Pedro, xutz'om chic rubixic cheque ri yec'o chiri': La achi la' jun cheque ri yec'o riq'uin ri Jesús, xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero ri Pedro xa xrevaj chic jun bey. Y xa c'ate ba' c'unük ri' ri quimolon-qui' chiri' xquibij jun bey chic chin: Ketzij na vi que rat rat rachibila' vi ri Jesús. Roma rat xa pa Galilea ncapu'u-vi, y junan ri ach'abül quiq'uin, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pero ri Pedro xbij c'a: Yin man vetaman tüj ruvüch ri achi ri nibij rix. Chuvüch Dios ninbij chive que yin man vetaman tüj ruvüch. Y si man ketzij tüj ri ninbij, tika-ka pokonül pa nuvi', xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Y ri mama' xbesiq'uin-pe pa ruca'n mul. Y ri Pedro jari' xeka-pe pa ránima ri tzij ri ye rubin can ri Jesús chin, que man jani tisiq'uin-pe ri mama' pa ruca'n mul tok rat oxi' yan mul tabij cheque ri nyec'utun chave, que man avetaman tüj nuvüch. Y rija' xtz'om ok'ej roma nunuc pa quivi' ri tzij ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Y tok xsaker-pe cumaj yan chupan ri k'ij ri', ri nimalüj tak sacerdotes xquimol-qui' ye cachibilan ri rajatük tak achi'a' ri c'o quik'ij y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés. Conojel ri xquimol-qui' pa comon. Rije' xquinuc achique nquibün riq'uin ri Jesús, y ximon-vi-e tok xquic'uaj y xbequijacha' pa ruk'a' ri jun achi rubini'an Pilato. Jari' nbün juzgar pari' achique xtibanatüj chin. ");
INSERT INTO cakENT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Y jari' tok ri Pilato xuc'utuj chin ri Jesús: ¿Ja rat ri qui-Rey ri israelitas? xbij chin. Y ri Jesús xbij c'a: Ja', quiri'. Cachi'el ri xabij, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Y ri nimalüj tak sacerdotes, q'uiy ri nquibila-apu chin ri Pilato, richin nquisujuj ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Xpu'u ri Pilato xch'o chic apu riq'uin ri Jesús y xbij chin: Rije' juis q'uiy ri nquibila-pe chavij richin ncatquisujuj, y rat ¿man jun tzij nabij? xbij ri Pilato chin. ");
INSERT INTO cakENT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero man riq'uin tüj ri' ri Jesús man jun tzij ri xbij. Y ri Pilato juis xsatz ruc'u'x, roma man jun bey rutz'eton tüj que jun vinük quiri' ta nbün. ");
INSERT INTO cakENT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Y ronojel juna' tok napon ri quinimak'ij ri israelitas, ri nimak'ij ri rubini'an pascua, ri Pilato nusok'opij-e jun preso, ri preso ri nquibij ri vinük que utz ntel-e. ");
INSERT INTO cakENT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Y ri k'ij ri', c'o pa cárcel jun achi rubini'an Barrabás ye rachibilan ch'aka chic rachibila'. Rije' ye kajnük pa cárcel roma xecatüj chirij ri nbanun mandar y chuka' xquibün camic. ");
INSERT INTO cakENT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Y roma ri vinük ri' quetaman que ri Pilato nusok'opij-e jun cheque ri yec'o pa cárcel, romari' xepu'u rije' xquic'utuj chin ri Pilato que trelesaj-e jun cheque ri yec'o pa cárcel. ");
INSERT INTO cakENT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Y ri Pilato jari' xbij-pe cheque: ¿Ri irayibül rix que yin ninsok'opij-e ri achi Rey ivichin rix israelitas? xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ri Pilato quiri' xbij-pe, roma rija' retaman que ri nimalüj tak sacerdotes quiyo'on ri Jesús pa ruk'a', roma itzel nquina' chin que juis ye q'uiy vinük ri nquitzekleben richin. ");
INSERT INTO cakENT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Y ri nimalüj tak sacerdotes xquiya' quina'oj ri vinük, que tiquibij-apu chin ri Pilato que xa ja ri Barrabás ri tisok'opis-e. Y ri vinük quiri' xquibün. ");
INSERT INTO cakENT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Y ri Pilato jari' xbech'o jun bey chic y xuc'utuj cheque: ¿Achique ri nibij rix que yin ninbün ta riq'uin ri achi ri nibij que i-Rey rix israelitas? xbij rija' cheque. ");
INSERT INTO cakENT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Y ri vinük xech'o chic apu y riq'uin cuchuk'a' xquibij: Tataka' rucamsasic chuvüch cruz, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Romari' ri Pilato xbij cheque: ¿Achique rumac rubanun chive? Pero rije' man nyetane' tüj ka. Xa riq'uin más cuchuk'a' xquibij-apu: ¡Tataka' rucamsasic chuvüch cruz! xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Y ri Pilato xusok'opij-e ri Barrabás, chin ticuker cánima ri vinük. C'ateri' xutük ruch'ayic ri Jesús y xujüch-e chin ticamsüs chuvüch cruz. ");
INSERT INTO cakENT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xepu'u ri soldados xquicusaj-apu ri Jesús cho jay richin ri palacio. C'ateri' xecoyoj conojel ri ch'aka chic soldados, ri ye cachibil. Xequimol c'a apu chirij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Y ri soldados ri' xquiya' jun tziük morado chirij ri Jesús, cachi'el vi ri nyequicusala' ri reyes. Y xquipach'uj chuka' jun k'ayis ri q'uiy ruq'uixal. Cachi'el jun corona xquibün chin, y c'ateri' xquiya' pa rujolon ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Xepu'u chuka' ri soldados nquibün que nquibün saludar ri Jesús, y nquibila' c'a chin: Caquicot c'a juis, rat ri qui-Rey ri israelitas, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Rije' nquibujij pa rujolon ri Jesús riq'uin jun aj, y nquichubala' chuka'. Nyexuque' chuvüch. Nquibün c'a que nquiya' ruk'ij, pero xa nyetze'en chubanic. ");
INSERT INTO cakENT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Y tok rije' xetane' que tze'en chirij, xquelesaj-e ri tziük morado ri quiyo'on chirij. C'ateri' xquiya-e ri rutziek-vi rija', y xquic'uaj-e richin que nquibebajij chuvüch cruz. ");
INSERT INTO cakENT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tok quitz'amon-e bey, xquic'ul jun achi aj-Cirene, jun achi petenük pa k'ayis, Ri achi re', quitata' ri achi'a' quibini'an Alejandro y Rufo. Y rija' rubini'an Simón. Y ri soldados xquibün chin ri achi ri' que xuc'uaj-e ri ru-cruz ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Y ri soldados pari' ri jun juyu' rubini'an Gólgota xquic'uaj ri Jesús. Ri juyu' ri nbix chuka' Calavera chin. ");
INSERT INTO cakENT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Y tok yec'o chic chiri', xquisuj chin ri Jesús vino yoyon riq'uin ruya'al jun che' rubini'an mirra. Pero rija' man xrajo' tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Y tok ri soldados quibajin chic ri Jesús chuvüch ri cruz, xquic'ün-e ri rutziek y xquiya' pan atz'anin riq'uin nquitij achique nch'acon-e chin nquic'uaj chiquijujunal. ");
INSERT INTO cakENT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tok ri hora las nueve xsaker-pe xquibajij ri Jesús chuvüch cruz. ");
INSERT INTO cakENT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Y pa rutza'n ri ru-cruz, chiri' tz'iban-vi chuvüch jun tz'alün ri achique rumac ri Jesús richin ncamsüs. Chuvüch ri tz'alün ri' nbij c'a: Jare' ri qui-Rey ri israelitas. ");
INSERT INTO cakENT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Y ri soldados yec'o chuka' ye ca'i' chic ri xequibajij. Ri ca'i' achi'a' ri' ye elek'oma'. Jun c'a ri xpabüx pa rajquik'a' (ru-derecha) ri Jesús y jun chic pa ruxocon (ru-izquierda). ");
INSERT INTO cakENT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Y riq'uin ri' nbanatüj cachi'el ri tz'iban can chupan ri rutzij ri Dios, tok nbij: Rija' cachi'el chuka' jun aj-mac xban chin. Quiri' ri tz'iban can. ");
INSERT INTO cakENT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ri vinük c'a ri yec'o-e y nye'apon riq'uin ri Jesús, nquisiloj can quijolon chuvüch, roma man nquinimaj tüj que ja rija' ri Ruc'ajol ri Dios. Y c'o chuka' tzij ri nyequibila' can chin. Ri vinük ri' nquibila' can chin ri Jesús: Ja rat ri xabin que navulaj ri racho ri Dios y pan oxi' k'ij nabün chic jun bey. ");
INSERT INTO cakENT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tacolo-e-avi' ayon y caka-pe chuvüch ri cruz, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Y ja chuka' tzij ri' ri nquibila' ri nimalüj tak sacerdotes. Rije' y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés nquitze'ej ri Jesús y nquibila' chiquivüch: Rija' ye q'uiy xerucol, pero rija' man ntiquer tüj nucol-ri'. ");
INSERT INTO cakENT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Rubin que ja rija' ri Cristo, ri Rey richin ri tinamit Israel. Si quiri', tika-pe chuvüch ri ru-cruz, chin nkatz'et y nkanimaj, xquibij. Y ri elek'oma' ri ye bajin chuvüch qui-cruz cachibilan ri Jesús, c'o c'a chuka' tzij quiri' ri nyequibij-apu chin. ");
INSERT INTO cakENT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Y tok xnic'ajür k'ij, jari' tok xk'ekumür ri ruch'ulef. Y ri k'eku'n ri' xq'uis-e pa las tres ri xkak'ij-ka. ");
INSERT INTO cakENT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Y ja ri hora ri', tok ri Jesús riq'uin ruchuk'a' xch'o y xbij: Eloi, Eloi, ¿lama sabactani? xbij. Y ri tzij ri xerubij rija', quiri' ri nbij: Nu-Dios yin, nu-Dios yin, ¿achique c'a roma tok xinamalij can? ");
INSERT INTO cakENT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Y yec'o-apu ch'aka chunakaj ri Jesús, tok xcac'axaj ri xbij, xquibila' c'a: ¿Xivac'axaj? Rija' ja ri Elías ri nroyoj, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Y c'o jun ri junanin xberumuba-pe jun cachi'el bo'j ri nbix esponja chin. Xumuba' chupan jun ch'amilüj ruya'al-uva, xuya' pa rutza'n jun aj y xuya' chin ri Jesús richin nch'uptüj juba' ri nchaki'j ruchi', y xbij: Vocomi tikoyobej ba' chin nkatz'et si ja ri Elías nobos, nberukasaj-pe chuvüch ri cruz, xbij. ");
INSERT INTO cakENT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jari' tok ri Jesús riq'uin ruchuk'a' xch'o y xcom. ");
INSERT INTO cakENT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Y ri c'ul ri tason rupan ri racho ri Dios xk'achitüj pa nic'aj. Ca'i' xbün. Xutz'om-pe pa jotol pa xulan ka. ");
INSERT INTO cakENT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Chuvüch apu ape' c'o-vi ri Jesús c'o ri Capitán quichin ri soldados. Rija' xrac'axaj tok ri Jesús riq'uin ruchuk'a' xch'o, y jari' tok xcom. Romari' tok ri Capitán xbij c'a: Ketzij na vi que ri achi re' Ruc'ajol ri Dios, xbij c'a. ");
INSERT INTO cakENT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Y yec'o chuka' ixoki' ri nyetzu'un-apu, pero chi nüj yec'o-vi. Chiquicojol ri ixoki' ri', c'o ri María Magdalena, c'o ri María ri quite' ri José y ri Jacobo ri más chaklatz', y c'o chuka' ri jun ixok rubini'an Salomé. ");
INSERT INTO cakENT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ri ixoki' ri', tok c'o ri Jesús pa Galilea, quitzekleben y xquilij-pe. Y chuka' yec'o ch'aka chic ixoki' ri quitzekleben-apu ri Jesús pa Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tok ya xtzak-ka ri k'ij y xoc-pe ri ak'a' chin ri k'ij richin uxlanen. Ja k'ij ri' nquibanala' c'a achique ri nc'atzin cheque roma xa k'ij richin uxlanen quichin conojel ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Y jari' tok xapon jun achi rubini'an José: y rija' aj tinamit Arimatea. Rija' jun achi cachibil ri achi'a' ri nquibün juzgar chiquicojol ri quivinak: y rija' c'o juis ruk'ij chiquicojol rije'. Rija' jun achi ri royoben chuka' tok ri Dios ntoc ri nbün mandar. Y rija' xapon riq'uin ri Pilato chupan ri hora ri', chin nuc'utuj ri ruch'acul ri Jesús richin numuk. Ri José man xuxbij tüj ri' chin xuc'utuj ri ruch'acul ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pero ri Pilato man nunimaj tüj que ta chanin yan xcom ri Jesús. Romari' rija' xroyoj ri Capitán, y xuc'utuj chin si ketzij que camnük chic ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Y tok ri Capitán xbij chin ri Pilato que ya camnük chic ri Jesús, c'ateri' xuya' k'ij chin ri José que nberumuku' can ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Y ri José xulok' c'a jun c'ul nim. Y tok rukasan chic pe ri ruch'acul ri Jesús chuvüch ri cruz, xupis-e chupan ri c'ul ri'. Y c'ateri' xberumuku' can pa jun jul richin camnük, c'oton chuvüch jun juyu' ri xa abüj vi. Y tok xumuk apu xusirirej jun abüj y xuya' can chuchi' ri ape' xumukutüj-vi. Y xutz'apij ri ruchi' ri jul. ");
INSERT INTO cakENT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Y ri María Magdalena y ri María ri quite' ri José y ri Jacobo, xquitz'et c'a jabel ape' xmuk-vi can ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Y tok xc'o chic ri k'ij richin uxlanen, ri María Magdalena, ri María ri quite' ri José y ri Jacobo, y chuka' ri ixok rubini'an Salomé xbequilok'o-pe jubulüj tak ak'on. Y ri ak'on re' nc'atzin cheque richin nyequiya' can pari' ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Y cumaj yan chupan ri nabey k'ij chin ri semana, xebe c'a chuchi-jul. Y tok nsaker-pe, jari' tok nye'apon yan. ");
INSERT INTO cakENT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Y rije' xquibila' c'a chiquivüch: ¿Y achique njakon ri jul chikavüch? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero tok xquitz'et ri jul, xquitz'et que xa jakül. Ri nimalüj abüj ri tz'apin can riq'uin, xa elesan chic e. ");
INSERT INTO cakENT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Y tok rije' ye c'unük chic apu chupan ri jul, rije' xquitz'et que c'o jun cachi'el ala', tz'uyul pa cajquik'a' (qui-derecha), rucusan jun tziük sük ri napon chirakün-ka. Y ri ixoki' tok xquitz'et ri', juis xquixbij-qui' riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero rija' xbij cheque: Man tixbij-ivi'. Roma yin vetaman que rix nicanoj ri ruch'acul ri Jesús aj-Nazaret, ri xcamsüs chuvüch ri cruz. Rija' xc'astüj yan e, xa manak chic chere'. Titz'eta' ape' xc'uje-vi. ");
INSERT INTO cakENT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vocomi c'a quixbiyin, y tibij chin ri Pedro y cheque ri ch'aka chic rachibila' ri Jesús. Tibij cheque que ri Jesús nbe nabey chivüch, richin nic'ul-ivi' chila' pa ruch'ulef Galilea. Y chiri' nitz'et-vi, cachi'el ri rubin can chive. ");
INSERT INTO cakENT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Y ri ixoki' xe'el-e chiri' pa jul, pero nyebarbot. Ri xbiri' ri tz'amayon quichin juis nim. Rije' ye anmajnük c'a e. Man jun achique chok chin ta xquitzijoj-vi, roma ye camnük roma xquixbij-qui'. ");
INSERT INTO cakENT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tok ri Jesús xc'astüj cumaj yan chupan ri xsaker ri k'ij domingo, ri nabey k'ij richin ri semana, xuc'ut-ri' nabey chuvüch ri María Magdalena, ri ixok ruchajin vuku' (siete) itzel espíritu y xerelesaj-e ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Y ri María Magdalena jari' xbe y xberubij cheque conojel ri rachibila' ri Jesús. Rije' juis nyebison y quitz'amon ok'ej. ");
INSERT INTO cakENT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero tok rije' xcac'axaj que ri Jesús xa xc'astüj chic pe y ri María Magdalena xutz'et yan can ruvüch, xa man xquinimaj tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Quiri' chuka' ri Jesús xuc'ut-ri' chiquivüch ye ca'i' achi'a' ri quitz'amon bey chin nyebe lojc'an chic. Rije' pa k'ayis ye benük-vi. Pero roma ri Jesús jun vi chic xbün tok xuc'ut-ri' chiquivüch, man chanin tüj xquetamaj ruvüch. ");
INSERT INTO cakENT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ri ca'i' achi'a' ri' xbequibij chuka' cheque ri ch'aka chic ri xquitzekleben ri Jesús, pero chuka' man xenimüx tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","C'ateri' ri Jesús xuc'ut-ri' chiquivüch ri once rachibila', tok nyetajin nyeva'. Rija' xbij c'a cheque: ¿C'o roma rix xa man xinimaj tüj y xicovirsaj ri ivánima? xbij cheque. Quiri' xbij cheque roma ri rachibila' xa man xequinimaj tüj ri xetz'eton richin ri Jesús que xa xc'astüj chic pe chiquicojol ri caminaki'. ");
INSERT INTO cakENT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Y xbij chuka' cheque: Quixbiyin chuvüch ri ruch'ulef y titzijoj ri utzilüj tzij richin colonic cheque conojel ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ri vinük c'a ri nutaken ri utzilüj tzij richin colonic y nbün chuka' bautizar-ri', ncolotüj c'a. pero ri vinük ri xa man nuniman tüj, ri' nutij k'oxomül. ");
INSERT INTO cakENT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ri nyetaken c'a vichin, q'uiy c'a nyequibanala' richin nk'alajin que yinc'o-vi quiq'uin. Pa nubi' yin nyequelesala' itzel tak espíritu y nyech'o pa ch'aka chic ch'abül ri man ye quetamalon tüj. ");
INSERT INTO cakENT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Rije' chuka' stape' (aunque) nyequitz'om itzel tak cumütz y ak'on chin camic, man nijun nquibün. Nquiyala' chuka' quik'a' pa quivi' yava'i' y nyec'achoj. Q'uiy ri nyequibanala' rije', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tok ri Ajaf Jesús ch'ovinük chic can cheque ri rachibila', xbe y chila' chicaj xc'ul roma ri Dios, y xtz'uye-apu pa rajquik'a' (ru-derecha). ");
INSERT INTO cakENT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Y tok ri rachibila' xe'el c'a chi nüj chi nakaj, xquitzijoj ri rutzij ri Dios. Y ri Ajaf c'o-vi quiq'uin richin nyeruto' y chuka' xbün cheque que q'uiy milagros ri xetiquer xquibanala' richin tik'alajin que ja ri ketzij ri'. Quiri' c'a.");
INSERT INTO cakENT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ye q'uiy yan c'a vinük ri quitijon chic quik'ij richin nquitz'ibaj pa rucholajen ri xa c'a ja ri tiempo re' xebanatüj. ");
INSERT INTO cakENT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Y ri rutz'ibaxic ri xquibün chin cachi'el vi ri xtzijos cheke coma ri xetz'eton c'a pa rutz'uquic pe. Y ri xetz'eton ri xbanatüj xe'oc chuka' tzijoy rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Y yin chuka' ninjo' nintz'ibaj ri xbanatüj. Xintij c'a nuk'ij richin xinvetamaj pari' ri rutz'uquic. Y jari' ri ninjo' nintzijoj chave. Ninjo' que pa rucholajen nintzijoj chave rat nimalüj Teófilo, ");
INSERT INTO cakENT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","richin quiri' ja vi ri rubanic ri navetamaj pari' ri ketzij ri rat tijon-vi-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chiri' pa ruch'ulef Judea xc'uje' c'a jun sacerdote quichin ri israelitas ri rubini'an Zacarías, y rija' xc'uje' c'a quiq'uin juk'at sacerdotes quichin ri israelitas ri quibini'an que ye richin ri Abías, ri jun sacerdote quichin ri israelitas más ojer can. Pa ru-tiempo ri Zacarías ja ri achi Herodes ri rey chiri' pa Judea. Ri rixjayil ri Zacarías rubini'an Elisabet. Ri Elisabet ri' jun ruxquin-rumam can ri nimalüj sacerdote quichin ri israelitas ri rubini'an Aarón. ");
INSERT INTO cakENT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ri juc'ulaj vinük ri' ye choj chuvüch ri Ajaf Dios, y nquitakej c'a ri rutzij. Nquibün-vi ri nbij. Y man jun vinük ntiquer nbin c'a achique ta tzij chiquij, roma ye choj vi. ");
INSERT INTO cakENT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ri juc'ulaj vinük ri' man jun c'a calc'ual, roma ri Elisabet man nalan tüj. Y chi ca'i' c'o chic ba' q'uiy qui juna' chuka'. ");
INSERT INTO cakENT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ri k'ij c'a tok ja ri Zacarías y ri ye rachibil ri yec'o que nyebanun ri jalajoj ruvüch samaj chiri' pa racho ri Dios, quere' c'a xbanatüj. ");
INSERT INTO cakENT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chiquijujunal ri sacerdotes ri' jalajoj c'a ruvüch samaj ri nc'atzinej que nquibün. Romari' quiyo'on pa atz'anin achique ri nka-ka pari' que ntoc-apu pa racho ri Dios richin que nuporoj ri pon. Y ri k'ij ri' pari' ri Zacarías xka-ka-vi richin que ja rija' ri nc'atzinej que nsujun ri pon. ");
INSERT INTO cakENT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Y tok ntajin c'a chuporoxic ri pon, conojel c'a ri vinük ri nquimol-apu-qui' chuvüch-jay, nquibün orar. ");
INSERT INTO cakENT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ja tok c'o ri Zacarías chiri' richin nuporoj ri pon, jari' tok xuc'ut-ri' jun ángel chuvüch, jun ángel richin ri Ajaf Dios. Y ri ángel ri' xpa'e' chunakaj ri altar ape' nporox-vi ri pon. Pa rajquik'a' (ru-derecha) ri altar xpa'e-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tok ri Zacarías xutz'et ri ángel ri', xsatz ruc'u'x y xpu'u xbiri' chin. ");
INSERT INTO cakENT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero ri ángel xbij chin ri Zacarías: Man taxbij-avi'. Ri Dios xrac'axaj ri a-oración. Ri Elisabet ri avixjayil nc'uje' c'a jun ral, y ri ac'ual re', Juan ri rubi' ri naya'. ");
INSERT INTO cakENT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ri ac'ual re' nuc'ün-pe juis quicot chave rat, y nuc'ün-pe chuka' quicot cheque juis ye q'uiy vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Roma ri avalc'ual re' ntoc nimalüj samajel chuvüch ri Dios. Man nukum tüj vino, nixta ch'aka chic quivüch ya' ri nyek'abarsan, roma pa ralaxic pe ri nojnük ránima riq'uin ri Lok'olüj Espíritu. ");
INSERT INTO cakENT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Y nbün c'a cheque ye q'uiy avinak israelitas richin nquitakej ri Ajaf Dios y njalatüj ri quic'aslen. ");
INSERT INTO cakENT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ja ri Juan ri avalc'ual ri nchojmirsan ape' nka-pe-vi ri Ajaf Cristo, ri Jun cha'on-pe y takon-pe roma ri Dios. Rija' nc'uje' c'a ri Lok'olüj Espíritu y ri ruchuk'a' riq'uin, cachi'el ruchuk'a' xc'uje' riq'uin ri Elías, ri jun ri xk'alajrisan ri rutzij ri Dios ojer can. Chuka' ri Juan nbün c'a cheque ri te'ej-tata'aj richin nyequijo' ri calc'ual, y nbün chuka' cheque ri vinük ri man nyetaken tüj tzij, que nquic'uaj jun choj c'aslen cachi'el ri quic'uan ri vinük choj quic'aslen. Quiri' ruchojmirsasic nbün-apu cheque ri vinük, richin quiri' ri vinük re' xaxe chic coyoben ri Ajaf Cristo, xbij ri ángel chin ri Zacarías. ");
INSERT INTO cakENT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Y ri Zacarías xuc'utuj chin ri ángel: ¿Achique c'a modo tok ninvetamaj yin que ketzij ri nabij? Roma yin y ri vixjayil xa roj rajatük chic, y man nyec'uje' ta chic kalc'ual, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Y jari' tok ri ángel xbij chin: Ja yin ri nubini'an Gabriel, y ri Dios nquirutük richin ninbün ri nrajo'. Roma c'a ri' xinrutük-pe vocomi richin ninbij can chave ri nuc'ün-pe quicot, que nc'uje' ri avalc'ual. ");
INSERT INTO cakENT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Y roma c'a ri man xanimaj tüj ri xinbij chave, ncatoc can mem, man ncach'o tüj c'a, entonces tok nalüx na ri avalc'ual, c'ateri' ncach'o jun bey chic. Ronojel c'a re' nbanatüj na vi, pero tok napon ri k'ij, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tok ri Zacarías ntzijon c'a ri ángel riq'uin, ri vinük ri ye oyobeyon richin chuvüch-e ri jay, nquibila' c'a: ¿Achique roma tok xa man jun bey ntel-pe chupan ri lok'olüj racho ri Dios? ");
INSERT INTO cakENT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Y tok ri Zacarías xbe'el-pe, man ntiquer tüj nch'o cheque, roma xoc mem. Roma c'a ri', ri ye oyobeyon richin, nquinabej que c'o ri xk'alajrisüs-pe chuvüch chiri' chupan ri lok'olüj jay. Ri Zacarías xaxe riq'uin ruk'a' nch'o-vi cheque, roma xa xoc mem. ");
INSERT INTO cakENT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Y tok rija' ye rutz'akatisan chic can ri k'ij richin samaj chiri' pa racho ri Dios, xbe chiracho. ");
INSERT INTO cakENT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Xa c'ate ba' ri xc'ulachitüj chiri' pa racho ri Dios, tok ri Elisabet ri rixjayil ri Zacarías, xunabej que yava' chic, y romari' man xel tüj pa bey vo'o' ic'. Ri Elisabet nbij c'a: ");
INSERT INTO cakENT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Vocomi ri Vajaf Dios nuya' c'a ri ac'ual re' chuve, richin que yin man quiq'uix chic chiquivüch ri vinük ri nquikasaj nuk'ij roma man jun val. ");
INSERT INTO cakENT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ja tok ri Elisabet rutz'amon chic vaki' (seis) ic' yava' pe, jari' tok ri Dios xutük ri ángel Gabriel pa jun tinamit rubini'an Nazaret, jun tinamit ri c'o pa ruch'ulef Galilea. ");
INSERT INTO cakENT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ri ángel Gabriel xtak riq'uin jun xtün rubini'an María. Ri xtün c'a ri', c'utun chic richin c'ulubic roma jun ala' rubini'an José. Y ri José ri' ruxquin-rumam can ri rey David. ");
INSERT INTO cakENT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ri ángel xapon na vi riq'uin ri xtün, y xbij chin: ¡Tiquicot c'a ri avánima, roma jabel xaka' chuvüch ri Dios! Ri Ajaf Cristo, ri Jun cha'on-pe y takon-pe roma ri Dios, c'o aviq'uin. Y cheque conojel ri ixoki' ja rat ri más nim ri bendición xac'ul. ");
INSERT INTO cakENT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Y tok ri María xutz'et ri ángel y xrac'axaj ri xbij chin, cachi'el xsatz ruc'u'x y xunuc c'a ka pa ránima que achique roma tok quere' saludo nuya' chin. ");
INSERT INTO cakENT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jari' tok ri ángel chanin xbij chin ri María: Man taxbij-avi'. Rat avilon ru-favor ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Vocomi c'a, ninbij can chave que npu'u alanic chavij, y tok nalüx c'a ri ac'ual re', vit ala' y Jesús ri rubi' ri naya'. ");
INSERT INTO cakENT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Rija' juis c'a ruk'ij nc'uje', y rubini'an chuka' Ruc'ajol ri nimalüj Dios. Ri Jesús jun ruxquin-rumam can ri rey David, y ri Ajaf Dios ja rija' ri nutz'uyuba' can pa rutz'uyubal ri rey David ri xc'uje' ojer can, ");
INSERT INTO cakENT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","richin quiri' ri Jesús nbün mandar pan ivi' rix ruxquin-rumam can ri Jacob. Y ri ru-gobierno chi jumul, man jun bey chic ntane', xbij ri ángel chin ri María. ");
INSERT INTO cakENT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Y tok ri María rac'axan chic ka ronojel re', xuc'utuj chin ri ángel: ¿Achique c'a rubeyal tok nc'uje' val? Roma yin xa man jani yinc'o ta riq'uin ri ntoc vachijil. ");
INSERT INTO cakENT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Y ri ángel xbij chin ri María: Ja ri Lok'olüj Espíritu riq'uin ri ruchuk'a' ri nimalüj Dios, jari' ri nka-pe pan avi'. Roma c'a ri', ri lok'olüj ac'ual ri nalüx aviq'uin, rubini'an na vi Ruc'ajol ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Y tavetamaj c'a chuka' can, que ri Elisabet ri avoxpochel nyeralaj jun ac'ual, stape' (aunque) man alanel tüj y chuka' ri'j chic. Y jare' ri vaki' (sexto) ic'. ");
INSERT INTO cakENT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Roma ri Dios man nijun ri c'ayuf ta nbün chuvüch. ");
INSERT INTO cakENT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jari' tok ri María xbij: Jare' yinc'o pa ruk'a' ri Ajaf Dios. Tibanatüj c'a cachi'el ri xabij chuve, xbij ri María chin ri ángel. Y ri ángel xel-e chiri' riq'uin ri María, y xbe. ");
INSERT INTO cakENT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ja k'ij c'a ri' tok ri María chanin xbe pa jun tinamit ri c'o pari' jun juyu' richin ruch'ulef Judea. ");
INSERT INTO cakENT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Y tok xapon chiri' pa tinamit, rija' xbe pa cacho ri Zacarías y ri Elisabet. Rija' xuya' saludo c'a chin ri Elisabet. ");
INSERT INTO cakENT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tok ri Elisabet xrac'axaj ri saludo ri xuya' ri María, xropin juis ri ac'ual ri royoben, xuna' rija'. Y tok ri Elisabet nojnük chic ránima riq'uin ri Lok'olüj Espíritu, ");
INSERT INTO cakENT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","riq'uin c'a ruchuk'a' xch'o, y xbij: Chikacojol roj ixoki', ja rat ri más nim ri bendición ac'ulun, y quiri' chuka' ri bendición c'o pari' ri ac'ual ri nalüx aviq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Man nk'ax ta c'a chuve, ¿roma yin achique c'a yin, richin nquinabetz'eta' can rat ri rute' ri Vajaf Dios? ");
INSERT INTO cakENT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Y xe xinvac'axaj ri ach'abül tok xinaya' saludo, ri ac'ual ri voyoben, xropin roma quicot, xinna' yin. ");
INSERT INTO cakENT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jabel quicot chave rat c'a que xatakej ri xbij ri Ajaf Dios chave, roma ri ac'ual ri xbij chave que nalüx aviq'uin, nalüx na vi. ");
INSERT INTO cakENT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Y jari' tok ri María xbij: Yin riq'uin ronojel vánima ninya' ruk'ij ri Ajaf Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ri vánima nquicot roma ri Dios ri Nucolonel. ");
INSERT INTO cakENT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Roma ri Dios xinrucha', yin ri xa yin achique na oc chi samajel. Y chi jumul ri nbe-apu, ri vinük nquibij que jabel quicot chuve. ");
INSERT INTO cakENT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Roma q'uiy nimak' tak utz ri rubanun-pe chuve rija', ri ntiquer-vi nbün ronojel. Y ri rubi' rija' lok'olüj vi. ");
INSERT INTO cakENT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Y chuka' nujoyovaj c'a quivüch conojel ri vinük, ri chi familia can chi familia can nyec'o-e chuvüch ri ruch'ulef y nquiya' ruk'ij rija'. ");
INSERT INTO cakENT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Y riq'uin c'a ri ruchuk'a', q'uiy c'a rubanalun. Rija' rukasan quik'ij ri nyenucun pa tak cánima que juis quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ye rukasan nimak' tak autoridades, y ye runimirsan ri xa juba' oc quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ri nyevayjan, ruyo'on c'a ronojel ri nc'atzin cheque, jac'a ri beyoma' xe tal quiri' xetak-e. Man jun xuya-e cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Rija' roj ruto'on c'a roj israelitas ri roj rucha'on-vi richin que nkabün ri rusamaj. Man roj rumestan tüj vi can y rujoyovan kavüch. ");
INSERT INTO cakENT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Rujoyovan-vi kavüch, cachi'el ri rusujun can cheque ri kaxquin-kamama' ojer, ri rusujun can chin ri Abraham y cheke roj ri ruxquin-rumam can rija'. Ri Dios man jun bey c'a numestaj ri rusujun can. Quiri' c'a ri xbij ri María. ");
INSERT INTO cakENT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Y ri María xc'uje' la'ük can jun oxi' ic' riq'uin ri Elisabet, y c'ateri' xtzolij chiracho. ");
INSERT INTO cakENT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tok xapon ri k'ij richin nalüx ri vit ac'ual chuk'a' ri Elisabet, xralaj jun ac'ual vit ala'. ");
INSERT INTO cakENT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Y ri vinük c'a ri ye ru-vecinos ri Elisabet y ri ye roxpochel xcac'axaj c'a que jun utzilüj nimalüj rusipanic ri Ajaf Dios, roma xralaj jun ac'ual. Y ri vinük c'a ri' xe'apon riq'uin, chutz'etic, y juis c'a chuka' xequicot riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Y rije' xe'apon chic c'a riq'uin ri Elisabet, tok xapon ri ocho ruk'ij ri ac'ual, tok ja chuka' ri' nban ri circuncisión chin ri ac'ual, ri jun retal ri xquibün ri israelitas pa ruch'ac'ul jun ac'ual ala' que ja richin ri tinamit ri Dios cachi'el nbij chupan ri ru-ley ri xuya' ri Dios richin ri Moisés. Y ja chuka' k'ij ri' tok nquicanoj can rubi' ri ac'ual. Y ri yec'o quiq'uin ri rute-rutata' ri ac'ual xcajo' c'a xquiya' ri rubi' ri rutata' chin ri ac'ual, y quiri' ri ac'ual rubini'an ta Zacarías. ");
INSERT INTO cakENT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Jac'a ri rute' ri ac'ual chanin xbij: Ri ac'ual man nuc'uaj tüj ri rubi' ri rutata', roma ri ac'ual re' nubini'aj Juan. ");
INSERT INTO cakENT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Y ri yec'o quiq'uin ri Elisabet xquibij chin: ¿Achique roma tok najo' que ri ac'ual nubini'aj Juan? Roma man jun cheque ri ye avoxpochel rubini'an ta quiri'. ");
INSERT INTO cakENT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jari' tok pa mem xech'o-apu chin ri Zacarías, ri rutata' ri ac'ual, richin nquic'utuj chin achique bi'aj nrajo' nuya' chin ri ac'ual. ");
INSERT INTO cakENT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ri rutata' ri ac'ual xuc'utuj jun tz'alün ri nyequicusaj richin nyetz'iban. Chuvüch c'a ri tz'alün ri' xutz'ibaj: Ri ac'ual nubini'aj Juan. Y conojel c'a ri quimolon-apu-qui' quiq'uin ri rute-rutata' ri ac'ual, xsatz quic'u'x, roma ja ri bi'aj ri xbij ri te'ej, ja chuka' ri' xutz'ibaj ri Zacarías chuvüch ri tz'alün. ");
INSERT INTO cakENT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jari' tok ri Zacarías xch'o jun bey chic. Y rija' xe xch'o, jari' xuya' ruk'ij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Y ri ye qui-vecinos xsatz c'a quic'u'x cheque, roma ri xbanatüj chiri'. Y ri xbanatüj, ntzijos c'a ri lugar ri', chiri' pa tak k'ayis ri ye richin ri ruch'ulef Judea. ");
INSERT INTO cakENT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Y conojel c'a vinük ri nye'ac'axan ri xbanatüj quiq'uin ri Zacarías y ri Elisabet, nquiyüc c'a ka pa tak cánima ri ntzijos cheque, y nquibij: ¿Achique c'a rusamaj ruc'amon-pe ri ac'ual re'? nquibij. Roma nk'alajin que c'o-vi ri Ajaf Dios riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Roma c'a ri' ri Zacarías, ri rutata' ri ac'ual, tok nojnük ránima riq'uin ri Lok'olüj Espíritu, rija' xuk'alajrisaj c'a y xbij: ");
INSERT INTO cakENT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Juis ninimirsüs ta rubi' ri Ajaf Dios kichin roj ri aj-Israel, roma nkuruc'uxla'aj-pe roj ri rutinamit, y nkurucol. ");
INSERT INTO cakENT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ri Dios nuya' jun kanimalüj Colonel. Y ri Kacolonel re', ruxquin-rumam can ri David ri jun ka-rey y rusamajel ri Dios ri xc'uje' ojer can. ");
INSERT INTO cakENT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ri Dios xbin cheque ri lok'olüj tak achi'a' ri xek'alajrisan ri rutzij rija' ojer can, que xquibij que nuya' jun Kacolonel. Rusujun-vi-pe jun Kacolonel ojer ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Rubin-vi-pe que nkurucol chiquivüch ri nye'etzelan kichin, y nkurucol pa quik'a' ri man nyejo'on tüj kichin, ");
INSERT INTO cakENT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","y richin nujoyovaj chuka' quivüch ri kaxquin-kamama' xec'uje' ojer can, nbün-vi ri xbij, tok xbün ri lok'olüj trato. ");
INSERT INTO cakENT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Xbün-vi jurar chin ri kaxquin-kamama' can Abraham ");
INSERT INTO cakENT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","que nkurucol na vi pa quik'a' ri nye'etzelan kichin, richin quiri' man jun xbiri' pa tak kánima nkasamajij rija', ");
INSERT INTO cakENT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","y riq'uin jun chojmilüj y ch'ajch'ojilüj c'aslen chuvüch rija', nkasamajij-e jampe' tiempo nkuc'ase-e chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Y rat vit nuc'ajol, xbij ri Zacarías, rat k'alajrisüy ri rutzij ri nimalüj Dios nbix chave, roma ja rat ri ncabin cheque ri vinük que tiquichojmirsala' ri rubey ri quic'aslen, roma nakaj chic c'o-vi ri rupetenük ri Ajaf Cristo, ri Jun cha'on-pe y takon-pe roma ri Dios, ");
INSERT INTO cakENT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","y ja rat ri ncabin que ri Dios nucuy quimac ri ye rutinamit, richin nyecolotüj. ");
INSERT INTO cakENT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Y ri', xaxe roma ri ka-Dios juis nujoyovaj kavüch, riq'uin ronojel ránima nkurujo'. Romari' nutük-pe ri Jun ri nsakrisan-pe kichin, ri cachi'el k'ij tok nka-pe chila' chicaj. ");
INSERT INTO cakENT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ri Jun c'a ri nsakrisan-pe, nyeruya' pa sük ri yec'o pa k'eku'n y ri yec'o pa rumujal ri camic, y nkuruyukej c'a chupan ri bey richin uxlanen. ");
INSERT INTO cakENT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Y quiri' c'a, ri ac'ual ri xalüx quiq'uin ri Zacarías y ri Elisabet, rutz'amon c'a ruq'uiyilen y chuka' quiri' pa ruc'aslen. Y ja pa tz'iran ruch'ulef xc'uje-vi, c'a tok xapon ri k'ij richin xutzijoj ri rutzij ri Dios chiquivüch ri aj-Israel ri ruvinak. ");
INSERT INTO cakENT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Y chupan c'a ri k'ij ri', pa ru-tiempo ri César Augusto ri jun nimalüj rey, jari' tok xtak rubixic cheque conojel vinük que nyeban jun tz'ibaxic bi'aj. ");
INSERT INTO cakENT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Man jun bey banatajnük ta quiri'. Pero tok xban ri nabey tz'ibaxic bi'aj ri', jari' tok c'a gobernador ri achi rubini'an Cirenio, chiri' pa ruch'ulef Siria. ");
INSERT INTO cakENT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Y ri vinük pa ruch'ulef Israel nc'atzinej c'a que nyequitz'ibaj quibi' pa tak quitinamit ri quixquin-quimama' can. ");
INSERT INTO cakENT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Y chiri' pa ruch'ulef Galilea c'o jun tinamit rubini'an Nazaret. Y chiri' pa Nazaret c'o c'a jun achi rubini'an José. Y ri José c'a ri', nc'atzinej c'a que nbe chutz'ibaxic ri rubi' c'a pa Belén, ri jun tinamit c'a pa Judea ncanaj-vi can, roma ye aj chiri' ri ye ruxquin-rumama' can. Chiri' c'a pa tinamit Belén xalüx-vi ri rey David, y ri José ruxquin-rumam can c'a ri rey David. ");
INSERT INTO cakENT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Y ri José rachibilan ri María ri rixjayil chic, roma pa nabey xaxe c'a ruc'utun richin que nc'ule' riq'uin. Chi ye ca'i' rije' xebe c'a pa Belén chutz'ibaxic quibi'. Y ri María xa nakaj chic c'a ri alanic chirij. ");
INSERT INTO cakENT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Y chiri' c'a pa tinamit Belén yec'o-vi tok ri María xtz'aküt ri ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Rija' xc'uje' c'a ral vit ala'. Ri María jabel xubolkotij ri ac'ual pa c'ul, y xuliba' pa jun quivaybül avüj. Pa jun ruc'ojbül quivay avüj xalüx-vi ri nabey vit ral ri María, roma nojnük chic ri posada. ");
INSERT INTO cakENT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Y yec'o c'a yuk'uy nyequivaraj qui-ovejas pa k'ayis nakaj ncanaj-vi can chin ri tinamit Belén. ");
INSERT INTO cakENT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jari' tok xuc'ut-ri' jun ángel chiquivüch ri yuk'uy quichin ovejas ri', jun ángel ri petenük chila' chicaj riq'uin ri Ajaf Dios. Y rije' juis nquixbij-qui' roma ri ángel, y roma chuka' ri rusakil ri Ajaf Dios ri xsakrisan quichin. ");
INSERT INTO cakENT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero ri ángel xbij cheque: Man tixbij-ivi'. Tivac'axaj na pe' ri ninjo' ninbij chive, richin juis quicot. Y man xe tüj chuka' ivichin rix ri quicot re', xa quichin conojel vinük chuka'. ");
INSERT INTO cakENT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tivac'axaj c'a ri ninbij chive: Chiri' pa Belén, ri rutinamit can ri rey David, vocomi xalüx ri Colonel, ri Cristo ri Ajaf. ");
INSERT INTO cakENT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ri retal richin vi ja vit ac'ual ri' ri xivil, nitz'et c'a que bolkotin jabel pa c'ul y cotz'oban pa jun quivaybül avüj, xbij ri ángel. ");
INSERT INTO cakENT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jari' chuka' xek'alajin-pe ch'aka chic ángeles ri ye petenük chila' chicaj. Ye juis. Y rije' nquiya' c'a ruk'ij ri Dios, y nquibij: ");
INSERT INTO cakENT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Vocomi, chila' chicaj juis ruk'ij nuc'ul ri Dios! ¡Y chere' chuvüch ri ruch'ulef xka-pe yan ri uxlanen. Xka-pe yan chiquicojol ri vinük, roma ri utzilüj rusipanic ri Dios! ");
INSERT INTO cakENT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Xe xquibij can quiri' ri ángeles, jari' xebe chila' chicaj. Y xe c'a xebe ri ángeles ri', ri yuk'uy quichin ovejas jari' xquibila-ka chiquivüch: Jo' junanin pa tinamit Belén. Jo' chin nkatz'et ri ac'ual ri xalüx chila'. Roma ri Ajaf Dios xutük-pe ri rutzijol cheke. ");
INSERT INTO cakENT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Y richin c'a que nyequitz'eta', ri yuk'uy ri' junanin c'a xebe pa tinamit. C'o na vi ri María, ri José, y ri ac'ual cotz'oban c'a pa jun quivaybül avüj. ");
INSERT INTO cakENT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ri yuk'uy quichin ovejas ri', xe xquitz'et ri ac'ual, xquitz'om c'a rutzijosic ri xbix cheque roma ri ángel pari' ri jun vit ac'ual re'. ");
INSERT INTO cakENT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Y conojel c'a ri vinük ri nye'ac'axan quichin, xsatz quic'u'x tok xcac'axaj ri utzilüj tak tzij ri nquitzijoj ri yuk'uy. ");
INSERT INTO cakENT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Y ri María xeruyüc c'a pa ránima ronojel ri tzij ri', y nunuc chuka' pari' ri tzij ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ri yuk'uy xetzolij c'a. Pero rije' nquiyala' c'a ruk'ij ri Dios y nquinimirsala' ri rubi'. Rije' quiri' c'a nquibün roma ronojel ri quitz'eton y cac'axan chic. Xbanatüj-vi c'a cachi'el ri rubin can ri ángel. ");
INSERT INTO cakENT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","C'a man jani rutzijol que nc'uje' ta c'a ral ri María chiri', tok jun ángel xbij que ri ac'ual ri nralaj nubini'aj Jesús. Y quere' c'a xubini'aj can ri ac'ual tok c'a ocho k'ij xalüx. Y ja k'ij ri' chuka' tok xban ri circuncisión chin, ri jun retal ri xquibün ri israelitas pa ruch'ac'ul jun ac'ual ala' que ja richin ri tinamit ri Dios, cachi'el ri nbij ri rutzij ri Dios que nc'atzinej que nban. ");
INSERT INTO cakENT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Y tok xtz'aküt c'a ri k'ij cachi'el nbij ri ley richin ri Moisés, que ri ixoki' ri xe'alan nc'atzinej que nquich'ajch'ojrisaj-qui', ri María quiri' vi xbün. Y tok xebe c'a chubanic ri ch'ajch'ojrisanic ri' c'a chila' pa racho ri Dios pa Jerusalén, ri María y ri José xquic'uaj c'a chuka' ri Jesús richin que jari' nbequic'utu' can ri ac'ual pa racho ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Quiri' xquibün roma ri ley richin ri Ajaf Dios nbij que ronojel nabey ac'ual ala' pa tak familia, richin vi ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ri José y ri María xquibün-vi c'a ri nbij chupan ri ley richin ri Ajaf Dios, ri nch'o pari' ri ch'ajch'ojrisanic. Rije' xquiya' c'a chuvüch ri Dios ca'i' palomas, roma ri ley nbij-vi c'a: Ca'i' palomas ye nimak' o ca'i' tak cocoj. ");
INSERT INTO cakENT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Y chiri' pa tinamit Jerusalén ri tiempo ri', c'o c'a jun achi rubini'an Simeón. Ri jun achi c'a ri', choj ri ruc'aslen y yo'ol ruk'ij ri Dios. Ri Simeón, c'o-vi c'a ri Lok'olüj Espíritu riq'uin y royoben chuka' tok npu'u ri Cristo chucolic ka rija' y chiquicolic ri ch'aka chic israelitas. ");
INSERT INTO cakENT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Y ri Lok'olüj Espíritu ruk'alajrisan chic c'a chin ri Simeón que man ncom tüj yan nabey si nabey man rutz'eton tüj can ruvüch ri Cristo, ri nutük-pe ri Ajaf Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Y chupan c'a ri k'ij tok ri te'ej-tata'aj xquic'uaj ri ac'ual pa racho ri Dios richin nquibün cachi'el ri nbij ri ley, ja k'ij ri' chuka' tok xapon ri Simeón pa racho ri Dios, roma quiri' xrajo' ri Lok'olüj Espíritu. ");
INSERT INTO cakENT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ri Simeón xuch'elej c'a ri ac'ual, y richin que xuya' ruk'ij ri Dios, xbij c'a: ");
INSERT INTO cakENT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ajaf Dios, vocomi c'a xa utz chic que nquinavelesaj-e, xa c'o chic e uxlanen pa vánima nquibe, roma cachi'el ri abin chuve, quiri' xbanatüj. ");
INSERT INTO cakENT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ri runak'-nuvüch xquitz'et yan can c'a ri Colonel ri petenük aviq'uin rat, ");
INSERT INTO cakENT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ri xaya-pe rat quichin conojel ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ja rija' chuka' ri Sük quichin ri vinük man ye israelitas tüj, roma ja rija' ri nk'alajrisan ri abey rat chiquivüch. Y roj ri atinamit Israel, roma chikacojol xalüx-vi ri Colonel, q'uiy utz nkil y nc'uje' kak'ij, xbij ri Simeón. ");
INSERT INTO cakENT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Y ri José y ri María ri te'ej xsatz quic'u'x tok xcac'axaj ri xubila' ri Simeón pari' ri ac'ual. ");
INSERT INTO cakENT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Y jari' tok ri Simeón xbün jun oración coma ri José y ri María, richin ja ta ri Dios ri nuya' ru-bendición pa quivi'. Tok rubanun chic ka orar ri Simeón, xbij c'a chin ri María, ri rute' ri ac'ual: Tavac'axaj na pe', ri ac'ual re' nim ri samaj yo'on-pe chin roma ri Dios. Y roma rija', ye q'uiy cheque ri kavinak israelitas nyecolotüj. Y ye q'uiy chuka' ri nyetzak, roma juis nquetzelaj. ");
INSERT INTO cakENT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Roma c'a rija' tok nyek'alajin-pe ri itzel c'o pa tak cánima ri vinük. Y ri Simeón xbij chuka' chin ri María: Roma ri itzel ri nban chin ri Jesús, npu'u k'oxon aviq'uin rat. Nana' c'a que cachi'el jun ch'ich' ri nusoc ri avánima, xbij ri Simeón. ");
INSERT INTO cakENT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chiri' c'a pa racho ri Dios c'o c'a jun ixok rubini'an Ana. Rija' jun ri nk'alajrisan c'a richin ri nbix chin roma ri Dios. Rija' rumi'al can jun achi rubini'an Fanuel, y ruxquin-rumam can ri Aser, ri jun achi xc'uje' ojer can. Ri Ana ri' ya ri'j chic oc. Rija' c'a man q'uiy tüj c'o rujuna' tok xc'ule'. Y xaxe siete juna' xquic'uaj-qui' riq'uin ri rachijil, roma xa chanin xcom-e ri achi chuvüch. ");
INSERT INTO cakENT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Man riq'uin tüj ri' man xc'ule' tüj jun bey chic. C'o chic c'a ochenta y cuatro rujuna', y nc'uje' c'a pa racho ri Dios k'ij-k'ij. Q'uiy mul c'a nbün que man nva' tüj, richin nbün orar. Nuya' c'a ruk'ij ri Dios chi pak'ij chi chak'a'. ");
INSERT INTO cakENT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tok ri Ana xutz'et ri vit ac'ual Jesús, rija' xbe-apu riq'uin. Y juis c'a xmatioxin chin ri Dios roma ri ac'ual ri', roma xunabej que jari' ri Colonel. Y xutz'om c'a rutzijosic cheque ri vinük ri ye oyobeyon richin ri Colonel re', chiri' pa tinamit Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ri José y ri María xquibün c'a ronojel ri nuchilabej ri Ajaf Dios chupan ri ru-ley, ri nc'atzinej que nquibün tok c'ate ba' xalüx jun ac'ual. C'ateri' xetzolij chi cacho chiri' pa tinamit Nazaret. Ri tinamit ri' c'a pa ruch'ulef Galilea ncanaj-vi can. ");
INSERT INTO cakENT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y ri ac'ual xutz'om c'a ruq'uiyilen, y xa ntajin nc'uje-e más ruchuk'a'. Rija' ntajin nq'uiyür más runa'oj, y c'o ri utzilüj sipanic ri nspaj-pe ri Dios pari'. ");
INSERT INTO cakENT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ri María y ri José ri ye rute-rutata' ri Jesús, ronojel c'a juna' nyebe pa tinamit Jerusalén. Rije' nyebe chiri' pa Jerusalén tok napon ri k'ij richin ri quinimak'ij ri israelitas ri rubini'an pascua. ");
INSERT INTO cakENT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Y xapon chic c'a jun bey ri k'ij richin ri quinimak'ij ri'. Ri Jesús rutz'aksan chic c'a doce rujuna' tok xebe c'a pa Jerusalén. Xebe c'a pa tinamit, cachi'el vi nquibün ri quivinak israelitas. ");
INSERT INTO cakENT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tok c'unük chic can c'a ri quinimak'ij ri israelitas ri rubini'an pascua, ri María y ri José xetzolij chicacho. Pero rije' man quetaman tüj c'a que ri ac'ual Jesús xa xcanaj can chiri' pa tinamit Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ri José y María quiyo'on-ka cánima que ri ac'ual benük, y quiri' xebiyin jun k'ij. Pero tok xquinabej que man benük tüj, c'ateri' tok xquic'utula' na cheque ri coxpochel y cheque ri quetaman quivüch. ");
INSERT INTO cakENT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Y roma ri man xquil tüj, ri José y ri María xetzolij chic jun bey chucanoxic ri ac'ual c'a pa tinamit Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","C'a pa rox k'ij tok quisatzon ri ac'ual, c'ateri' tok ri José y ri María xbequila'. Rije' xquil c'a ri ac'ual chiri' pa racho ri Dios chiri' pa Jerusalén. Ri ac'ual tz'uyul-apu quiq'uin ri achi'a' ye etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés, nrac'axaj ri nquibij y c'o chuka' ri nyeruc'utula-apu rija' cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Y conojel c'a ri xcac'axaj ri nbij ri ac'ual xsatz quic'u'x, roma ri nc'utux-pe chin coma ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés, ri ac'ual jabel vi ntiquer nbij-apu cheque. Rija' nk'alajin-vi que ronojel jabel nk'ax chin y c'o etamabül riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chiri' c'a pa racho ri Dios c'o-vi ri Jesús tok ri María y ri José xbequila'. Rije' xesatz quic'u'x. Y jari' tok ri rute' xbij chin ri ral: ¿Achique c'a roma tok quere' xabün cheke? ¿Achique roma tok xacanaj can y man jun xabij cheke? Tatz'eta' la'. La atata' y yin juis chic rat kacanon. Y nk'oxon chic kánima roma man jun bey ncatkilon. ");
INSERT INTO cakENT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Y jari' tok rija' xbij cheque: ¿Achique c'a roma tok juis nquinicanoj? Chinuvüch yin, rix jabel vi ivetaman que ja ri nrajo' ri Nata' Dios jari' ri nc'atzinej que ninbün. ");
INSERT INTO cakENT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jac'a ri tzij ri xbij ri ac'ual cheque ri José y María man xk'ax ta cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Y c'ateri' ri ac'ual junan c'a xtzolij quiq'uin rije' chicacho, ri c'o-vi pa tinamit Nazaret. Ri ac'ual juis nutakej quitzij. Y ronojel c'a ri xbanatüj pa Jerusalén riq'uin ri ac'ual, ri María xeruyüc c'a pa ránima. ");
INSERT INTO cakENT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Y riq'uin ri benük ri tiempo, ri Jesús chuka' ntajin ruq'uiyilen, y quiri' chuka' ri etamabül ri c'o riq'uin benük pa jotol. Juis c'a jabel chuvüch ri Dios, y juis c'a chuka' jabel chiquivüch ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","C'o yan chic c'a quince juna' nbün mandar ri achi rubini'an Tiberio César. Y pa ruk'a' c'a ri Tiberio César ri' xec'uje-vi ri caji' gobernadores ri'. Jun cheque ri caji' gobernadores ri' ja ri Poncio Pilato, y rija' nbün mandar pa ruch'ulef Judea. Ri jun chic, ja ri Herodes y rija' nbün mandar pa ruch'ulef Galilea. Ri rox, ja ri Felipe ri ruchak' ri Herodes, y rija' nbün mandar pa ruch'ulef Iturea y Traconite. Ri rucaj gobernador ja ri Lisanias, y rija' nbün mandar pa ruch'ulef Abilinia. ");
INSERT INTO cakENT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Y ja chuka' tiempo ri' tok ri Anás y ri Caifás ye nimalüj tak sacerdotes chiri' pa racho ri Dios, chiri' pan Israel. Ronojel c'a re' nye'oc retal richin tok xch'o ri Dios chin ri Juan ri ruc'ajol ri Zacarías. Ja chiri' pa tz'iran ruch'ulef xch'o-vi ri Dios chin ri Juan. ");
INSERT INTO cakENT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Y rija' xaxe c'a ri ruchi' ri rakün-ya' Jordán ruc'uan-e, y xbe. Rija' nbij c'a cheque ri vinük ri nye'apon riq'uin que titzolij-pe quic'u'x riq'uin ri Dios y tiquibana' bautizar qui', richin quiri' ri Dios nucuy quimac. ");
INSERT INTO cakENT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Y ja riq'uin ri Juan xbanatüj-vi ri rubin can ri Dios chin ri jun rusamajel ri xc'uje' ojer can. Ri rusamajel c'a re' rubini'an Isaías. Y ri rutz'iban can ri Isaías tok xch'o pari' que nc'atzinej que ri vinük nquichojmirsaj ri quic'aslen, quere' c'a ri nbij: C'o c'a jun achi ri nc'uje' pa tz'iran ruch'ulef, y ja rija' ri ntzijon ri rutzij ri Dios chiquivüch ri vinük ri nye'apon riq'uin. Y nubila' c'a cheque: Tichojmirsala' rubey ri ic'aslen, roma ya ja nobos-vi ri Ajaf. ");
INSERT INTO cakENT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Y richin c'a nchojmirsüs jun bey, nc'atzin c'a que nyenojsüs ri sivan. Nc'atzin chuka' nvulüx-ka ri juyu'. Ri xotoxük tak bey, choj tiban cheque. Y ri cojcük tak bey, tak'aj c'a chuka' tiban cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y conojel c'a vinük nquitz'et ri colonic ri nuya' ri Dios, nbij chupan ri vuj ri rutz'iban can ri Isaías. ");
INSERT INTO cakENT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Y quiri' c'a, tok nye'apon ri vinük riq'uin ri Juan richin nyeban-e bautizar, rija' nbij c'a cheque: Rix rix cachi'el itzel tak cumütz, ri nyixanmüj chuvüch ri castigo, roma nijo' nyixcolotüj chuvüch ri castigo ri nutük-pe ri Dios, ri chikavüch apu. ¿Achique c'a xyo'on rutzijol chive que quere' tibana'? ");
INSERT INTO cakENT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Rix nc'atzin c'a que nc'ut que ketzij nitzolij-pe ic'u'x riq'uin ri Dios. Y man tinuc-ka que xe roma ri rix ruxquin-rumam can ri Abraham, romari' nyixcolotüj ta rix, man quiri' tüj. Roma ri Dios nrajo' ta, rija' nyerubün ta ye ruxquin-rumam can ri Abraham cheque ri abüj ri nye'itz'et chere'. ");
INSERT INTO cakENT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ri pokonül ri nuya' ri Dios npu'u yan. Rija' nbün c'a cachi'el nbün jun achi ri c'o chic ri icüj pa ruk'a' richin que nyerukasaj ri che' ri xa man nquiya' tüj utzilüj quivüch. Y ronojel c'a ri che' ri nyerukasaj, nyerutorij pa k'ak', xbij ri Juan. ");
INSERT INTO cakENT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Y jari' tok ri vinük ri nye'ac'axan-apu richin ri Juan, xquic'utuj chin: ¿Achique c'a ri c'uluman que nkabün? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Y ri Juan xbij c'a cheque ri xec'utun-apu: Achique c'a chive rix ri c'o ca'i' rutziek, tuya' jun chin ri jun manak rutziek. Y achique na c'a chuka' chive rix c'o ta vüy ruchajin, tuya' c'a chuka' chin ri man jun nuc'ux-ka, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Y chiri' riq'uin ri Juan, yec'o c'a chuka' apu ca'i-oxi' achi'a' ri ye moloy tak alcaval. Ri achi'a' c'a re' xe'apon richin nyeban bautizar. Y ri achi'a' re' chuka' xquic'utuj chin ri Juan: Maestro, xquibij chin. Y roj ¿achique ri c'uluman que nkabün? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ri Juan xbij cheque: Xaxe c'a ri alcaval ri bin chive roma ri ley, xe ri' tic'utuj cheque ri vinük. Man c'a tic'usaj ruvi'. ");
INSERT INTO cakENT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jari' chuka' tok ye ca'i-oxi' soldados ri ye apon riq'uin ri Juan, xquic'utuj-apu chin: Y roj ¿achique c'uluman que nkabün? xquibij Ri Juan xbij cheque: Man que'ivelesala' c'a qui-cosas ri vinük, roma ri c'o autoridad pan ik'a'. Nixta man que'ik'abala' achique chiquij vinük. Y ticukür c'a ka ivánima riq'uin ri jani' tumin nich'üc, xbij ri Juan. ");
INSERT INTO cakENT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Y ri vinük ri yec'o c'a apu riq'uin ri Juan, coyoben c'a que ri Juan c'o ta ri nbij, roma nquibila' c'a pa tak cánima que riq'uin ba' ja ri Juan jari' ri Cristo, pero xa man ja tüj rija'. ");
INSERT INTO cakENT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Roma c'a ri' ri Juan xbij cheque ri vinük ri nye'apon riq'uin: Rix nitz'et que yin nyixinbün bautizar riq'uin ya'. Pero c'o c'a Jun ri npu'u ri chikavüch apu, ri nyixrubün bautizar riq'uin ri Lok'olüj Espíritu y riq'uin k'ak'. Ri Jun c'a ri npu'u, juis nim ruk'ij y nim ruchuk'a'. Xa man cachi'el tüj oc yin. Roma yin man c'uluman tüj richin ninsol ri ruximbal ri ruxajab, roma rija' nim ruk'ij y nim ruchuk'a'. ");
INSERT INTO cakENT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Y cachi'el c'a jun achi tok nujosk'ij ri ru-trigo. Rija' nc'atzin jun che' c'o ca'i' o oxi' rutza'n chin, richin quiri' nutorij chuvüch-cakik' ri trigo ri ch'ayon chic. Ri runak' ri trigo ncanaj can, pero ri rij nuc'uaj-e cakik'. Y ja ri runak' ri trigo, jari' ri nuyüc, y ri rij nuporoj. Quiri' c'a nbün ri Jun ri npu'u, xbij ri Juan. Ri Jun ri npu'u c'o chic autoridad pa ruk'a', richin nbün mandar pa quivi' ri vinük ri yec'o chuvüch ri ruch'ulef. Ri vinük c'a ri nyetaken richin, nyeruc'uaj chila' chicaj. Jac'a ri vinük ri man nyetaken tüj richin, nyerutük chupan ri k'ak' ri man jun bey nchup. ");
INSERT INTO cakENT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Q'uiy c'a tzij cachi'el re' xerucusaj ri Juan richin xutzijoj ri utzilüj tzij richin colonic cheque ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ri Juan xbij c'a chin ri gobernador rubini'an Herodes, que man utz tüj ri rubanun, roma rija' ruc'amon-ka ri rixjayil ri ruchak', rubini'an Felipe. Ri ixok re' rubini'an Herodías. Ri Juan xuc'uxla'aj c'a ri' chin ri Herodes, y xeruc'ut chuka' ch'aka chic rumac ri ye rubanalun. ");
INSERT INTO cakENT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Y ri Herodes xnimür c'a ruvi' ri rumac, roma xutz'apij ri Juan pa cárcel. ");
INSERT INTO cakENT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Y c'o c'a ri xbanatüj tok ntajin ri bautismo cheque ri vinük y xban chuka' bautizar ri Jesús. Tok ri Jesús ntajin c'a chubanic ri oración, jari' tok xjakatüj ri caj. ");
INSERT INTO cakENT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Y ri Lok'olüj Espíritu tz'etetül-vi ri xka-pe pari' ri Jesús. Cachi'el jun paloma ri xka-pe pari' rija'. Y xac'axatüj chuka' que xbix-pe chin chila' chicaj: Ja rat ri Nuc'ajol, juis ncatinjo', y aviq'uin rat nucukuban-vi nuc'u'x. ");
INSERT INTO cakENT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Chupan ri tiempo ri', ri Jesús c'o la'ük treinta rujuna'. Jari' tok xutz'om ri rusamaj. Y chiquivüch ri vinük, ri Jesús ruc'ajol ri José. Ri José ruc'ajol can ri Elí. ");
INSERT INTO cakENT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Y ri Elí re', ruc'ajol can ri Matat, y ri Matat ruc'ajol can ri Leví, y ri Leví ruc'ajol can ri Melqui, y ri Melqui ruc'ajol can ri Jana, y ri Jana ruc'ajol can jun chic achi rubini'an José. ");
INSERT INTO cakENT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Y ri José re', ruc'ajol can ri Matatías, y ri Matatías ruc'ajol can ri Amós, y ri Amós ruc'ajol can ri Nahum, y ri Nahum ruc'ajol can ri Esli, y ri Esli ruc'ajol can ri Nagai. ");
INSERT INTO cakENT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Y ri Nagai re', ruc'ajol can ri Maat, y ri Maat ruc'ajol can jun achi rubini'an Matatías, y ri Matatías re', ruc'ajol can ri Semei, y ri Semei ruc'ajol can jun achi rubini'an José, y ri José re', ruc'ajol can ri Judá. ");
INSERT INTO cakENT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Y ri Judá re', ruc'ajol can ri Joana, y ri Joana ruc'ajol can ri Resa, y ri Resa ruc'ajol can ri Zorobabel, y ri Zorobabel ruc'ajol can ri Salatiel, y ri Salatiel ruc'ajol can ri Neri. ");
INSERT INTO cakENT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Y ri Neri re', ruc'ajol can jun achi rubini'an Melqui, y ri Melqui ruc'ajol can ri Adi, y ri Adi ruc'ajol can ri Cosam, y ri Cosam ruc'ajol can ri Elmodam, y ri Elmodam ruc'ajol can ri Er. ");
INSERT INTO cakENT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Y ri Er re', ruc'ajol can ri Josué, y ri Josué ruc'ajol can ri Eliezer, y ri Eliezer ruc'ajol can ri Jorim, y ri Jorim ruc'ajol can jun achi rubini'an Matat. ");
INSERT INTO cakENT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Y ri Matat re', ruc'ajol can jun achi rubini'an Leví, y ri Leví ruc'ajol can ri Simeón, y ri Simeón ruc'ajol can jun achi rubini'an Judá, y ri Judá ruc'ajol can jun achi rubini'an José, y ri José ruc'ajol can ri Jonán, y ri Jonán ruc'ajol can ri Eliaquim. ");
INSERT INTO cakENT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Y ri Eliaquim re', ruc'ajol can ri Melea, y ri Melea ruc'ajol can ri Mainán, y ri Mainán ruc'ajol can ri Matata, y ri Matata ruc'ajol can ri Natán. ");
INSERT INTO cakENT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Y ri Natán re', ruc'ajol can ri David, y ri David ruc'ajol can ri Isaí, y ri Isaí ruc'ajol can ri Obed, y ri Obed ruc'ajol can ri Booz, y ri Booz ruc'ajol can ri Salmón, y ri Salmón ruc'ajol can ri Naasón. ");
INSERT INTO cakENT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Y ri Naasón re', ruc'ajol can ri Aminadab, y ri Aminadab ruc'ajol can ri Aram, y ri Aram ruc'ajol can ri Esrom, y ri Esrom ruc'ajol can ri Fares, y ri Fares ruc'ajol can jun achi rubini'an Judá. ");
INSERT INTO cakENT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Y ri Judá re', ruc'ajol can ri Jacob, y ri Jacob ruc'ajol can ri Isaac, y ri Isaac ruc'ajol can ri Abraham, y ri Abraham ruc'ajol can ri Taré, y ri Taré ruc'ajol can ri Nacor. ");
INSERT INTO cakENT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Y ri Nacor re', ruc'ajol can ri Serug, y ri Serug ruc'ajol can ri Ragau, y ri Ragau ruc'ajol can ri Peleg, y ri Peleg ruc'ajol can ri Heber, y ri Heber ruc'ajol can ri Sala. ");
INSERT INTO cakENT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Y ri Sala re', ruc'ajol can ri Cainán, y ri Cainán ruc'ajol can ri Arfaxad, y ri Arfaxad ruc'ajol can ri Sem, y ri Sem ruc'ajol can ri Noé, y ri Noé ruc'ajol can ri Lamec. ");
INSERT INTO cakENT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Y ri Lamec re', ruc'ajol can ri Matusalén, y ri Matusalén ruc'ajol can ri Enoc, y ri Enoc ruc'ajol can ri Jared, y ri Jared ruc'ajol can ri Mahalaleel, y ri Mahalaleel ruc'ajol can jun achi rubini'an Cainán. ");
INSERT INTO cakENT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Y ri Cainán re', ruc'ajol can ri Enós, y ri Enós ruc'ajol can jun achi rubini'an Set, y ri Set ruc'ajol can ri Adán, y ri Adán ralc'ual ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ri k'ij tok xban c'a bautizar ri Jesús, rija' nojnük ránima riq'uin ri Lok'olüj Espíritu xtzolij-pe pa rakün-ya' Jordán. Y ri Lok'olüj Espíritu re' xbün c'a chin ri Jesús que xbe c'a pa tz'iran ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Y chiri' xc'uje-vi. Ri cuarenta k'ij c'a xc'uje' chiri', ri itzel-vinük nutij ruk'ij chirij richin ntzak ta pa ruk'a'. Y chupan ri jaru' k'ij xc'uje' ri Jesús chupan ri lugar ri', man jun vüy xuc'ux. Romari' nnum rupan nuna' rija'. ");
INSERT INTO cakENT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Y jari' c'o-apu ri itzel-vinük, y xbij chin ri Jesús: Rat nabij que rat Ruc'ajol ri Dios, y nnum apan. Tabana' c'a cheque ri abüj re' que que'oc vüy. ");
INSERT INTO cakENT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pero ri Jesús xbij chin: Tz'iban can chupan ri rutzij ri Dios, que ri achi nril chuka' ruc'aslen riq'uin ri rutzij ri Dios y man xe tüj c'a riq'uin ri vüy. ");
INSERT INTO cakENT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Y jari' tok ri itzel-vinük xuc'uaj ri Jesús pari' jun nimalüj juyu', y xuc'ut ronojel tinamit richin ri ruch'ulef chuvüch ri Jesús, pa jun vit rato. ");
INSERT INTO cakENT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Y jari' ri itzel-vinük xbij chin ri Jesús: Yin ninjüch pan ak'a' ri quik'ij ri nimalüj tak tinamit re', y nye'oc pan ak'a' richin nabün mandar pa quivi', roma pa nuk'a' yin ye jachon-vi can, y yin nquitiquer ninya' ronojel re' chin achique na ri ninjo' yin. ");
INSERT INTO cakENT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Y si rat ncaxuque' chinuvüch y naya' nuk'ij, ronojel c'a re' ntoc avichin, xbij ri itzel-vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero ri Jesús jari' tok xbij chin: Catel-e viq'uin rat Satanás, y man quinanük chic. Roma chupan ri rutzij ri Dios ri tz'iban can, nbij: Xaxe c'a ri Kajaf Dios tikaya' ruk'ij, y xaxe chuka' rija' ri tikasamajij, xbij ri Jesús chin ri itzel vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Y jari' chuka' tok ri itzel-vinük xuc'uaj ri Jesús, c'a pa tinamit Jerusalén, y jari' más nüj benük-vi chicaj chin ri racho ri Dios, chiri' xberuya-vi. Y tok yec'o chic chiri', ri itzel-vinük xbij chin ri Jesús: Tatorij-ka-avi' chere', rat ri ncabin que rat Ruc'ajol ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Roma chupan ri rutzij ri Dios tz'iban can, nbij: Ri Dios nyerutük ri ru-ángeles, richin ncatquichajij. ");
INSERT INTO cakENT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Y ncatquili'ej pa quik'a', richin quiri' man natopij tüj avakün chuvüch abüj. ");
INSERT INTO cakENT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pero ri Jesús xbij chin ri itzel-vinük: Yin man ninbün tüj ri narayij rat, y nintij ta ri Dios. Roma ri rutzij ri Dios nbij que man tikatij ri Kajaf Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Y tok ri itzel-vinük man jun chic xril richin nbün chin ri Jesús, richin nmacun ta, xuya' can ca'i-oxi' k'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Y ri Jesús xtzolij pa ruch'ulef Galilea, y nojnük ránima riq'uin ri ruchuk'a' ri Lok'olüj Espíritu. Y pa conojel c'a tinamit ri yec'o-pe chunakaj ri Galilea, xapon rutzijol ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Y rija' nuc'ut c'a ri rutzij ri Dios pa tak jay ape' ntzijos-vi ri rutzij ri Dios, ri achique tinamit napon-vi. Y ri vinük c'a ri nye'ac'axan ri nbij, juis c'a nquiyala' ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ri Jesús xbe pa Nazaret, ri tinamit ape' xq'uiy-vi. Y chupan ri k'ij richin uxlanen, rija' xbe c'a chupan ri jay ape' ntzijos-vi ri rutzij ri Dios, cachi'el vi tubün. Y tok c'o chic chiri', rija' xpa'e' c'a, richin nusiq'uij ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Y c'o c'a jun vuj ri rutz'iban can ri Isaías, jun achi ri xk'alajrisan ri rutzij ri Dios ojer can. Ja vuj re' xjach pa ruk'a' ri Jesús, richin nusiq'uij chiquivüch ri vinük ri quimolon-qui' chiri'. Y tok ri Jesús xuric'-ka ri vuj ri', xril c'a ri nbij-vi: ");
INSERT INTO cakENT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ri Lok'olüj Espíritu richin ri Ajaf Dios, c'o viq'uin yin, roma xinrucha-vi-pe richin ninbij ri utzilüj tzij richin colonic cheque ri meba' cánima chuvüch ri Dios. Xinrutük-pe chuka' richin nyenvak'omaj vinük ri nk'oxon cánima pa ruk'a' ri mac. Xinrutük-pe ri Dios richin ninbij cheque ri vinük ri yec'o preso pa ruk'a' ri mac, que nyetiquer nyecolotüj pa ruk'a'. Xintak-pe chuka' richin ninbün cheque ri vinük ye cachi'el moyi', que nyetzu'un. Y ri Dios xinrutük-pe chuka' richin nyencol ri vinük ri juis nquitij pokonül. ");
INSERT INTO cakENT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Y xinrutük-pe chuka' richin ninbij cheque ri vinük que ja tiempo re' tok ri Ajaf Dios nbün ri utz. ");
INSERT INTO cakENT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Y ri Jesús xubot can c'a ri vuj ri xusiq'uij chiquivüch ri vinük ri yec'o chupan ri jay ape' ntzijos-vi ri rutzij ri Dios. C'ateri' xuya' can chin jun ri nsamüj chiri', y xbetz'uye' c'a richin que ntzijon. Y ri vinük xe' quica'yen-quica'yen c'a. ");
INSERT INTO cakENT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Y rija' xch'o c'a y xbij: Jare' chivüch rix vocomi nbanatüj-vi ri rubin can ri Dios chupan ri vuj ri tz'iban can cheke, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Y conojel c'a ri vinük ri quimolon-qui' chiri', juis xka' chiquivüch ri Jesús. Y ri utzilüj tak tzij ri xerubij ri Jesús cheque, xe' c'a xquica'yej tok xcac'axaj, roma man jun bey ye cac'axalon ta tzij cachi'el ri xerubij rija' cheque. Y ri vinük ri' nquibila' chuka' chiquivüch: ¿Man ja tüj comi re' ri ruc'ajol ri José? nquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Y ri Jesús xbij cheque: Yin nuyo'on vánima que rix ninuc-ka pa nuvi': Si ri Jesús re' ntiquer-vi nyerubanala' milagros, man ta xe c'a pa Capernaum nyerubanala-vi. Querubanala' c'a chuka' chere' pa rutinamit. ");
INSERT INTO cakENT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Y xbij chuka' cheque ri quimolon-qui' chiri': Ri nk'alajrisan ri tzij ri bin chin roma ri Dios, man nquitakej tüj c'a tok napon pa rutinamit. ");
INSERT INTO cakENT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Y yin ninbij que rix ivetaman ri xbanatüj tok man xbün tüj job oxi' juna' riq'uin nic'aj, pa ru-tiempo ri jun achi kavinak ri xk'alajrisan ri rutzij ri Dios ojer can, ri xubini'aj Elías. Ketzij vi que juis ye q'uiy ri ixoki' ye malcani'a' chere' pan Israel, ri tiempo ri', tok juis vayjül xpu'u chuvüch ri karuch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero ri Dios man xutük tüj ri Elías chuto'ic jun malca'n-ixok chere' pan Israel, pa ruruch'ulef ri Elías c'o-vi. Rija' xutük-e ri Elías riq'uin jun malca'n-ixok c'a pa jun tinamit rubini'an Sarepta. Y ri tinamit Sarepta re', c'a chunakaj ri tinamit Sidón c'o-vi-apu. ");
INSERT INTO cakENT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Y quiri' chuka' xc'ulachitüj quiq'uin ri yava'i' pa ru-tiempo ri Eliseo, ri xk'alajrisan ri rutzij ri Dios ojer can. Pa ru-tiempo c'a ri Eliseo, chiri' pan Israel ye q'uiy c'a ri ye yava'i' riq'uin ri jun yabil rubini'an lepra. Pero ri Dios man xrajo' tüj chuka' que c'o ta jun ri xc'achojrisüs cheque ri c'o ri yabil ri' quichajin, xaxe c'a ri Naamán ri xrajo' que xc'achojrisüs y rija' jun achi aj pa ruch'ulef Siria. ");
INSERT INTO cakENT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Y ri vinük ri quimolon-qui' chiri' pa ri jay ape' ntzijos-vi ri rutzij ri Dios, tok xcac'axaj ri xbij ri Jesús cheque, xcatüj coyoval tok xcac'axaj que ri vinük ri man ye israelitas tüj nyetiquer nquic'ul ri utz ri riq'uin ri Dios tok ri israelitas man xetiquer tüj. ");
INSERT INTO cakENT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Y xebecatüj-pe, c'ateri' xquelesaj-e chuchi' ri tinamit. Ri jun tinamit c'a re' chuvüch jun juyu' c'o-vi. Romari' ri vinük xquic'uaj c'a ri Jesús c'a pari' ri juyu' richin nquitorij-ka. ");
INSERT INTO cakENT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero ri Jesús cachi'el ye man jun ri vinük chuvüch. Choj xel-pe chiquicojol ri vinük y xbexule-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","C'ateri' ri Jesús xbe-ka pa tinamit Capernaum, jun chic tinamit ri c'o pa ruch'ulef Galilea. Y chiri' c'a c'o-vi tok xapon ri k'ij richin uxlanen. Y romari' rija' nutzijoj ri rutzij ri Dios cheque ri vinük ri quimolon-qui' chiri' pa nima-jay ape' ntzijos-vi ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Y conojel c'a ri vinük ri quimolon-qui', xe' xquica'yej tok xcac'axaj ri tijonic ri xuya' ri Jesús cheque, roma ri rutzij rija' nuc'ut que ri nbij rija' jari' ri nc'atzinej que nban. ");
INSERT INTO cakENT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Y chiri' pa ri jay ape' ntzijos-vi ri rutzij ri Dios, chiri' chiquicojol ri vinük c'o c'a apu jun achi ri c'o jun itzel espíritu riq'uin. Y ri itzel espíritu ri c'o riq'uin ri achi, riq'uin ronojel ruchuk'a' xch'o. ");
INSERT INTO cakENT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ri espíritu ri' xbij c'a chin ri Jesús: ¿Achique najo' cheke roj, Jesús aj-Nazaret? ¿Xapu'u c'a richin que nkujaq'uis? Yin vetaman rat achique rat y romari' vetaman que rat rat lok'olüj vi y rat petenük riq'uin ri Dios, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pero ri Jesús xbij chin ri itzel espíritu: Man cach'o chic. Catel-e. Y ri itzel espíritu ri' xbün c'a chin ri achi achique chok q'uin c'o-vi, que xtzak pan ulef chiri' chiquicojol ri vinük quimolon-qui'. Y ri itzel espíritu re', choj xel-e riq'uin ri achi, y man jun chic xbün can chin. ");
INSERT INTO cakENT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Y ri vinük ri quimolon-qui' chiri', xsatz quic'u'x tok xquitz'et ri xbün ri Jesús, y nquibila' c'a chiquivüch: ¿Achique c'a ruchuk'a' ri rutzij ri achi re'? Roma c'o rakalen ri tzij ri nch'o. Nuc'ut que ja ri nbij rija' ri nc'atzinej que nban. Ri itzel tak espíritu nquitakej rutzij y nye'el, nquibij ri vinük chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Y ri vinük ri yec'o pa tak lugar ri yec'o-pe chunakaj ri Capernaum, xcac'axaj chuka' ri nyerubanala' ri Jesús. Chanin c'a xbiyin rutzijol ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Y chupan c'a ri k'ij richin uxlanen ri', ri Jesús xel c'a pe chiri' pa ri jay ape' ntzijos-vi ri rutzij ri Dios y choj xbe c'a pa racho ri jun rachibil rubini'an Simón. Y chupan c'a ri k'ij ri' ri rujite' ri Simón, yava' rubanun riq'uin jun nimalüj c'atün. Y ri yec'o chiri' pa jay xquic'utuj favor chin ri Jesús pari' ri yava'. ");
INSERT INTO cakENT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Y rija' xluque-ka riq'uin ri yava' y xbij que tiq'uis-e ri c'atün chirij. Y xe c'a xbij quiri' ri Jesús, jari' xq'uis-e ri c'atün chirij ri yava'. Y ri ixok ri', jari' xbecatüj-pe y xuya' quivay ri Jesús y ri ye benük chirij. ");
INSERT INTO cakENT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tok xka-ka yan c'a ka ri k'ij chupan ri jun k'ij ri', conojel c'a ri vinük richin ri tinamit, ri yec'o yava'i' quiq'uin, xequic'uala-apu chuvüch ri Jesús. Ri yava'i' ri xequic'uala-apu ri vinük ri', jalajoj c'a ruvüch yabil ri ntoc cheque. Y ri Jesús xuya' c'a ruk'a' pa quivi' chiquijujunal ri yava'i'. Rija' xeruc'achojrisaj c'a e. ");
INSERT INTO cakENT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ye q'uiy c'a cheque ri yava'i' re' xa man choj tüj yabil ntoc cheque. Xa itzel tak espíritu yec'o quiq'uin. Pero ri Jesús xerelesaj-e chuka'. Y tok ri itzel tak espíritu nye'el c'a e quiq'uin ri yava'i' re', riq'uin c'a ruchuk'a' nquibij y nquibij: Ja rat ri Ruc'ajol ri Dios. Y ri Jesús xeruk'üt riq'uin ri rutzij y man xuya' tüj k'ij cheque richin xech'o más. Roma ri itzel tak espíritu re' quetaman que ja ri Jesús, jari' ri Cristo. ");
INSERT INTO cakENT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Y tok xsaker-pe ruca'n k'ij, ri Jesús xel-e ba' pa tinamit. Rija' xbe pa tz'iran ruch'ulef. Pero ri vinük xebe chucanoxic ri Jesús, y xbequila-pe. Ri vinük c'a re' man ncajo' tüj que nbe ri Jesús, rije' xcajo' ta xquik'üt-ka. ");
INSERT INTO cakENT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero ri Jesús xbij cheque: Yin nc'atzinej que nquibe pa ch'aka chic tinamit, richin nintzijoj ri utzilüj rutzij ri Dios ri nch'o pari' tok ri vinük nye'oc pa ruk'a' ri Dios, roma xa romari' tok xintak-pe, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Y quiri' xbün. Chiri' pa ruch'ulef Galilea, rija' nutzijoj c'a ri rutzij ri Dios pa tak jay ape' ntzijos-vi ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Y jun k'ij, tok ri Jesús c'o chiri' chuchi' ri lago rubini'an Genesaret, juis c'a vinük xe'apon riq'uin, roma ncajo' ncac'axaj ri rutzij ri Dios. Y ri vinük re' juis vi ye q'uiy, romari' nquipitz' ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pero rija' chanin xutz'et-apu ca'i' canoas yec'o can chuchi' ri ya', y man jun c'o chiquipan. Roma ri cajaf ri canoas re' ye tz'amoy tak cür, y ri hora ri' xa quitz'amon ruch'ajic ri quiya'l tz'ambül-cür. ");
INSERT INTO cakENT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Y jun c'a cheque ri canoas re' richin ri Simón. Y chupan ri ru-canoa ri Simón, xoc-vi-e ri Jesús. Y rija' xbij c'a chin ri Simón que que'oc-apu ba' pari' ri ya'. Y rija' xtz'uye-ka chiri' pa canoa, y xutz'om-pe xutijoj ri rutzij ri Dios cheque ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tok ri Jesús xtane' richin nch'o quiq'uin ri vinük re', rija' xbij chin ri Simón: Jo-apu ape' nim rupan ri ya', y que'iya-ka ri iya'l tz'ambül-cür. ");
INSERT INTO cakENT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pero jari' tok ri Simón xbij chin ri Jesús: Maestro, xbij chin. Roj junak'a' xojc'ase' richin xekacanoj cür, y xa man jun xkatz'om. Pero roma c'a ja rat ncabin que tikaya-ka ri ya'l tz'ambül-cür pa ya', nkaya-ka. ");
INSERT INTO cakENT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Y tok xquiya-ka ri quiya'l tz'ambül-cür, yec'o na vi. Juis c'a cür xe'oc chupan ri ya'l, y romari' ri ya'l xutz'om ruk'ach'ixic roma ri calal ri cür. ");
INSERT INTO cakENT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Romari' ri achi'a' tz'amoy tak cür re' xquibün-apu retal cheque ri ch'aka chic cachibil ri yec'o pa jun chic canoa, richin quepu'u chiquito'ic. Y ri cachibil xepu'u na vi chiquito'ic. Y ri ca'i' canoas xequinojsaj chi cür. Romari' ri ca'i' canoas re' jubama nyebe-ka chuxe' ri ya'. ");
INSERT INTO cakENT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Y tok ri Simón ri nbix chuka' Pedro chin, xutz'et que jun milagro ri xbanatüj quiq'uin ri cür, rija' xbexuque' chuvüch ri Jesús, y xbij chin: Ajaf, yin xa yin jun achi aj-mac, man c'uluman tüj c'a que ncac'uje-apu viq'uin, rat ri juis ak'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Quere' xbij ri Simón roma rija' man jun bey rutz'eton que quere' ta nbanatüj. Y quiri' chuka' conojel ri ye benük chirij. Rije' xe' xquica'yej c'a tok xquitz'et que juis cür xequitz'om ri k'ij ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Y chuka' ri Jacobo y ri Juan, ri ye rachibil ri Simón, ri ye ruc'ajol ri jun achi rubini'an Zebedeo, xe' xquica'yej tok xquitz'et ri xbanatüj. Romari' ri Jesús xbij chin ri Simón: Man tisatz ac'u'x c'a roma ri xatz'et. Ri rubanun-pe rat jun achi tz'amoy-cür, pero ri nbe-apu chikavüch, navetamaj chuka' ncatoc tz'amoy tak vinük, richin quiri' yinquitzeklebej. ");
INSERT INTO cakENT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Y ri achi'a' tz'amoy tak cür re' xequic'ün-pe ri qui-canoas c'a chuchi' ri ya'. Ri achi'a' re' xquiya' can ri quisamaj y xquitzeklebej-e ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Y tok ri Jesús xapon c'a pa jun tinamit, xapon c'a jun achi riq'uin, jun achi yava' riq'uin ri jun yabil rubini'an lepra. Ri achi re', xe xutz'et ri Jesús, xbexuque' chuvüch y xulucuba-ka ri rujolon chuvüch. Y xbij chin ri Jesús: Ajaf, yin vetaman que ncatiquer nquinac'achojrisaj riq'uin ri nuyabil, pero man vetaman tüj achique nanuc pa nuvi', xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Y ri Jesús jari' xutz'om-apu ri achi yava' riq'uin ri lepra y xbij chin: Ninjo' que ncac'achoj. Tiq'uis c'a e ri yabil re' chavij, xbij chin. Y xe xbij quiri' ri Jesús, jari' xq'uis-e ri lepra chirij ri achi. ");
INSERT INTO cakENT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ri Jesús xuchilabej c'a e chin ri achi ri' que man tutzijoj cheque ri vinük ri xbanatüj riq'uin. Y xbij-e chin chuka': Vocomi xa choj cabiyin pa racho ri Dios, richin quiri' te'ac'utu-avi' chuvüch ri sacerdote. Y taya' c'a ri nbij chupan ri vuj ri rutz'iban can ri Moisés. Chupan ri vuj ri' nbij ri nc'atzin que naya' rat, richin nak'alajrisaj chiquivüch ri vinük que rat ch'ajch'oj chic, xbij-e chin. ");
INSERT INTO cakENT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero ri Jesús más c'a xbiyin rutzijol, y juis c'a vinük nquimol-qui' riq'uin. Yec'o c'a vinük ri nyepu'u riq'uin, ncajo' ncac'axaj ri rutzij ri Dios. Y yec'o c'a ch'aka chic ncajo' que nyec'achojrisüs-e roma rija'. ");
INSERT INTO cakENT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Y rija' ja pa tz'iran ruch'ulef nbe-vi, richin que nbün orar. ");
INSERT INTO cakENT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Y jun k'ij c'a, yec'o c'a achi'a' fariseos y yec'o chuka' etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés ri xbequic'ulu-qui' ri ape' c'o-vi ri Jesús. Yec'o c'a cheque rije' ri ye petenük c'a cala' pa tak tinamit ri yec'o pa ruch'ulef Galilea. Yec'o ye petenük pa tinamit Jerusalén y pa ch'aka chic tinamit ri yec'o pa ruch'ulef Judea. Ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri fariseos ri' ye tz'uyul-apu chiquicojol ri vinük ri nye'ac'axan ri rutzij ri Dios ri nuc'ut ri Jesús chiquivüch. Y ri Jesús c'o ruchuk'a' ri Ajaf Dios riq'uin, richin nyeruc'achojrisaj ri yava'i'. ");
INSERT INTO cakENT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Y c'o c'a jun achi ri man ntiquer tüj nsilon ruch'acul ruc'uan-apu chuvüch ruvarabül coma achi'a'. Y rije' xcajo' c'a xe'oc-apu pa jay c'a riq'uin ri Jesús, richin nquiya-apu ri quiyava' chuvüch. ");
INSERT INTO cakENT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero ri achi'a' ri' man xetiquer tüj xe'oc-apu chupan ri jay, roma juis ye q'uiy vinük quimolon-qui' chiri'. Romari' rije' xquinuc que xejote' pari' ri jay, y xquisol ri ruvi'. Y c'ateri' xquikasaj-ka ri varabül ri ape' li'an-vi-e ri achi ri man ntiquer tüj nsilon ruch'acul. Ri yava' ri' c'a chuvüch ri Jesús xbec'uje-vi-ka, chiri' chiquicojol ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Y tok ri Jesús xutz'et que ri achi'a' ri ye uc'uayon-apu ri achi yava', quiyo'on cánima riq'uin rija', xbij chin ri achi yava': Ri amac xecuyutüj. ");
INSERT INTO cakENT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Xe xcac'axaj ri tzij ri' ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri achi'a' fariseos, ri achi'a' ri' jari' xquitz'om nquinuc-ka: ¿Achique c'a achi re'? ¿Y achique roma tok nbün que ja rija' ri Dios? ¿Roma achique ta c'a vinük ncuyun mac? Man jun. Xaxe ri Dios ri ncuyun mac, nquibij c'a pa tak cánima. ");
INSERT INTO cakENT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero ri Jesús jabel retaman ri nquinuc ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés, y retaman chuka' ri nquinuc ri achi'a' fariseos. Romari' rija' xbij cheque: ¿Achique c'a roma tok rix ninuc quere'? ");
INSERT INTO cakENT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Roma si yin nquitiquer ninbün chin ri jun achi re' ri man ntiquer tüj nsilon ruch'acul, richin nbiyin-e y nbe, ¿nquitiquer ta comi ninbij chuka' chin que nincuy rumac? ¿Achique nibij rix? ");
INSERT INTO cakENT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Vocomi c'a, richin que rix nivetamaj que yin ri xinalüx chi'icojol c'o vuchuk'a' pa nuk'a' richin nincuy mac, titz'eta' c'a, xbij rija'. Y jari' tok ri Jesús xbij chin ri achi ri man ntiquer tüj nsilon ruch'acul: Ninbij c'a chave: Cacatüj, tac'uaj-e la avarabül y cabiyin chi'avacho, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Y ri achi ri man ntiquer tüj nsilon ruch'acul, jari' xpa'e-e. Chiquivüch conojel vinük ri quimolon-qui' chiri' xpa'e-e rija'. Y xuc'ol-e ri ruvarabül ri ape' cotz'oban-vi-pe, y xbe. Y rija' juis c'a nuya' ruk'ij ri Dios ri xtzolij-e chiracho. ");
INSERT INTO cakENT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Y conojel ri vinük ri quimolon-qui' chiri', xsatz quic'u'x, roma man jun bey quitz'eton tüj que quiri' nbanatüj. Ri vinük re' c'a juis xquiya' ruk'ij ri Dios, y quixbin-qui' nquibij: Chupan ri jun k'ij re' xekatz'et milagros ri man jun bey ye tz'eton. ");
INSERT INTO cakENT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ri Jesús xel c'a pe chiri', y xutz'et c'a jun achi moloy-alcaval. Ri achi re' rubini'an Leví, y tz'uyul pa jun ch'acüt, nuc'ul can ri alcaval ri ntojox can. Y ri Jesús xbij chin: Quinatzekelebej. ");
INSERT INTO cakENT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Y jari' tok rija' xbecatüj-pe ri ape' tz'uyul-vi, xuya' can ronojel ri c'o chiri', y xutzeklebej ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Y c'ate ba' ri', ri achi rubini'an Leví xbün c'a jun nima-va'in pa racho, jun nima-va'in ri richin vi ri Jesús, pero chuka' xeroyoj ri moloy tak alcaval y chuka' ch'aka chic vinük. Y conojel c'a ri' junan ye tz'uyul chuvüch mesa riq'uin ri Jesús y ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Y yec'o c'a etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y yec'o chuka' achi'a' fariseos ri yec'o-apu chiri'. Y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri fariseos ri', q'uiy c'a tzij nyequibila-apu chiquij ri rachibila' ri Jesús. Nyequibila' c'a apu cheque: ¿Achique roma tok rix nyixva' y nitij ya' quiq'uin ri moloy tak alcaval y ri ch'aka chic vinük ri xa ye aj-maqui'? nquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pero ri Jesús xbij cheque ri achi'a' fariseos y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés: Jun ak'omanel man ja tüj ri ye utz ri nyerak'omaj. Rija' nyerak'omaj ri c'o quiyabil. ");
INSERT INTO cakENT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Y romari' yin man xinpu'u tüj chin nyencanoj vinük ri choj quic'aslen. Yin xinpu'u chin nyencanoj ri aj-maqui', ri nc'atzin que ntzolij-pe quic'u'x riq'uin ri Dios, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Y ri achi'a' fariseos y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés xquic'utuj chin ri Jesús: ¿Achique roma tok ri rachibila' ri Juan quicha'on k'ij richin man nyeva' tüj, richin nyequibanala' oraciones chin ri Dios? Y quiri' chuka' nquibün ri cachibila' ri achi'a' fariseos, pero ri avachibila' rat man quiri' tüj nquibün, xa nyeva', xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Y ri Jesús xbij cheque: ¿Achique nibij rix? ¿C'uluman comi que rix nibün que man nyeva' tüj ri ye oyon pa jun c'ulubic, tok xa c'a c'o na ri ala' c'ulubel quiq'uin? Man c'uluman tüj. ");
INSERT INTO cakENT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero napon ri k'ij tok ri ala' re' ntelesüs-e chiquicojol, y jari' tok nquibün que man nyeva' tüj richin nquibün orar. ");
INSERT INTO cakENT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chuka' ri Jesús xucusaj ri jun ejemplo re' chiquivüch: Man jun vinük nrelesan jun c'ojobül chin jun tziük c'ac'a', y c'ateri' nucusaj ta richin nuc'ojoj jun tziük ri xa tziek' chic. Roma si c'o jun ri nbanun quiri', c'ayuf. Roma nukupij-ka ri tziük c'ac'a' richin nrelesaj jun c'ojobül, y ri c'ojobül re' xa man nuc'ün tüj ri jun rutziek ri xa tziek' chic. ");
INSERT INTO cakENT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Y quiri' chuka' man jun nyo'on c'ac'a' vino chupan jun tz'un c'ojlibül ri xa tziek' chic. Roma si quiri' nban, y ri tz'un xa man nyukuk tüj chic, ri tz'un nbojbo' y ntix-e ri vino chupan. Y ri tz'un chuka' man jun chic nc'atzin-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pero chupan jun c'ac'a' c'ojlibül, utz nyaque' c'ac'a' vino, roma c'a nyukuk na jabel y man nbojbo' tüj. Ri vino nyaque' c'a jabel chupan. ");
INSERT INTO cakENT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Y man jun ri rukumun vino ri c'o yan chic juna' yacül, y c'ateri' nrajo' ri c'ac'a' vino. Man quiri' tüj. Roma xa nbij: Ri vino ri c'o yan chic tiempo yacül jari' ri más utz, nbij. ");
INSERT INTO cakENT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pa jun k'ij richin uxlanen, ri Jesús y ri rachibila' nyec'o apu c'a pa jun ulef ticon ruvüch riq'uin trigo. Y ri rachibila' c'o c'a ruvi-trigo nyequich'up-e, y ri ruvi' ri trigo ri' nyequibiyila' pa quik'a'. Y ja ri ruvüch ri trigo, nquic'ux. ");
INSERT INTO cakENT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Romari' tok yec'o achi'a' fariseos xquibij cheque ri rachibila' ri Jesús: ¿Achique c'a roma rix nibiyila' ri trigo pan ik'a' ri k'ij re'? Ri k'ij re', k'ij richin uxlanen y man utz tüj richin nban samaj, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Pero ri Jesús xch'o-apu cheque, y xbij: ¿Man jun bey comi itz'eton ri jun tzij ri tz'iban can pari' ri xquibün ri rey David y ri ye rachibil, chupan ri ojer can tiempo, tok juis xenum quipan? ");
INSERT INTO cakENT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ri David xbe chucanoxic vüy chiri' pa racho ri Dios, y xa ja ri lok'olüj tak caxlan-vüy ri xbejach-pe chin. Rija' xuc'ux ri lok'olüj tak caxlan-vüy ri', y xuya' chuka' cheque ri ye benük chirij. Y man riq'uin tüj ri', man mac tüj ri xquibün. Y ri' xaxe ri sacerdotes c'o quik'a' chin, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Y ri Jesús xbij chuka' cheque ri achi'a' fariseos: Ri Rajaf ri k'ij richin uxlanen ja yin, ri xinalüx chi'icojol, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pa jun chic c'a k'ij richin uxlanen, ri Jesús y ri rachibila' xebe pa jun jay ape' ntzijos-vi ri rutzij ri Dios, y xutz'om c'a quitijoxic ri quimolon-qui' chiri'. Y chiquicojol ri vinük ri quimolon-qui' chiri', c'o c'a jun achi ri chaki'j ri rajquik'a' (ru-mano derecha). ");
INSERT INTO cakENT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Roma c'a ri' yec'o cheque ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y yec'o chuka' achi'a' fariseos ri nquinachaj-apu ri Jesús, k'alüj ri' si nuc'achojrisaj ri achi, richin quiri' nquisujuj que ri Jesús xsamüj chupan ri jun k'ij richin uxlanen ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero ri Jesús jabel retaman ri nyetajin nquinuc ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri achi'a' fariseos ri'. Y ri Jesús xbij chin ri achi chaki'j ri ruk'a': Cac'o-pe chiri' pa nic'aj. Y ri achi jari' xcatüj-pe ape' tz'uyul-vi, y xbepa'e' ape' ri xbix-vi chin roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Xpu'u c'a ri Jesús xbij cheque ri vinük ri yec'o chiri': Vocomi ninjo' c'a ninc'utuj chive: ¿Más comi c'uluman nban ri utz pa jun k'ij richin uxlanen o ri itzel? ¿Ri ncol jun vinük chuvüch ri camic o ri ncamsüs? ¿Achique ninuc rix? xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Y ri Jesús xerutz'eta' c'a conojel ri quimolon-qui' chiri'. Xch'o chin ri achi ri yava' ruk'a', y xbij: Tayuku' la ak'a'. Y ri achi xaxe xuyuk ri ruk'a' cachi'el ri xbix chin roma ri Jesús, xa jari' xchojmir can ri ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri achi'a' fariseos ri yec'o-apu chiri', xcatüj coyoval. Y ri achi'a' re' nquitz'etela-qui', y nquic'utula' chuka' chiquivüch achique nquinuc nquibün chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Y jun k'ij, ri Jesús xbe c'a pari' ri juyu' richin xberubana' orar. Y junak'a' c'a xc'ase' richin xtzijon riq'uin ri Dios pan oración. ");
INSERT INTO cakENT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Y chupan c'a ri cumaj yan ruca'n k'ij, rija' xeroyoj ri achi'a' ri nyetzekleben-vi richin. Chiquicojol c'a ri achi'a' ri', xerucha' ye doce, y xbij apóstoles cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ri ye doce ri xerucha' ri Jesús, ja ri Simón ri xbij chuka' Pedro chin, y ri Andrés ri ye quichak'-qui', ri Jacobo, ri Juan, ri Felipe, ri Bartolomé, ");
INSERT INTO cakENT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ri Mateo, ri Tomás, ri Jacobo ri ruc'ajol jun achi rubini'an Alfeo, ri Simón ri c'o quiq'uin ri achi'a' quibini'an cananistas, ");
INSERT INTO cakENT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ri Judas ri ruchak' ri Jacobo, y ri Judas Iscariote ri xc'ayin richin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Y jari' tok ri Jesús y ri ye ru-apóstoles xeka-pe pari' ri juyu', y xebec'uje-ka quiq'uin ri ch'aka chic achibila' chiri' pa jun tak'aj. Y chiri' juis vinük chuka' quimolon-qui'. Yec'o vinük ye petenük pa tinamit Jerusalén y pa ch'aka chic tinamit ri yec'o pa ruch'ulef Judea, y yec'o chuka' ye petenük c'a cala' chuchi-mar, ri c'a cala' pa tinamit Tiro y Sidón. Yec'o c'a cheque ri vinük re' ye petenük richin ncac'axaj ri rutzij ri Dios ri nutzijoj ri Jesús, y yec'o c'a ye petenük richin nyec'achojrisüs-e roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Y yec'o c'a chuka' vinük ri yec'o pa pokonül pa quik'a' ri itzel tak espíritu ri yec'o quiq'uin. Xe'elesüs chuka' e ri itzel tak espíritu ri' roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Y conojel ri vinük ye yava'i' ncajo' c'a nquitz'om-apu ri rutziek ri Jesús, roma rija' c'o ruchuk'a' riq'uin richin nuc'achojrisaj ronojel ruvüch yabil. ");
INSERT INTO cakENT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Y jari' tok ri Jesús xerutz'et-apu ri rachibila' y xbij cheque: Jabel iquicot rix ri meba' ivánima chuvüch ri Dios, roma nyixoc-vi pa ruk'a' rija'. ");
INSERT INTO cakENT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Jabel iquicot rix ri ninum ri ivánima chuvüch ri Dios, roma ri Dios nbün c'a chive que nquicot ri ivánima. Jabel iquicot rix ri ntok' ri ivánima chuvüch ri Dios, roma ri Dios nujül ri ivok'ej riq'uin tze'en. ");
INSERT INTO cakENT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Jabel iquicot chuka' rix ri nyixetzelüs coma ri vinük, rix ri nyixquikotaj-pe chiquicojol, rix ri nyixyok', rix ri itzel nyixtz'et roma ja ri nubi' yin ri itaken, y ronojel ruvüch pokonül re' nicoch' voma yin ri xinalüx chi'icojol. ");
INSERT INTO cakENT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Y tok nc'ulachij ronojel re', quixquicot c'a juis, y quixropin chuka' roma quicot, roma nim rajil-ruq'uexel nic'ul chila' chicaj. Roma quiri' chuka' ri pokonül ri xquic'usala' ri achi'a' ri xek'alajrisan ri xbix cheque roma ri Dios, ojer can. Rije' xquic'usala' pokonül pa quik'a' ri quixquin-quimama' can ri vinük ri nye'etzelan ivichin rix vocomi. ");
INSERT INTO cakENT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Y rix beyoma', juya' ivüch c'a, roma xic'usaj yan jun c'aslen juis jabel chuvüch ri ruch'ulef. Jac'a ri k'ij ri ye petenük chivij man ye quiri' tüj chic. ");
INSERT INTO cakENT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Rix chuka' ri nyixva' jabel, juya' ivüch, roma napon c'a ri k'ij tok nitij vayjül. Rix ri jabel nyixtze'en vocomi, juya' ivüch, roma napon ri k'ij tok ntoc ri ok'ej iviq'uin, roma ri bis. ");
INSERT INTO cakENT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Y rix xa juya' ivüch tok ninimirsüs ik'ij coma ri vinük ri xa man ye richin tüj ri Dios. Roma ri quixquin-quimama' can rije' xa xquiya' quik'ij ri xebin que ye k'alajrisüy rutzij ri Dios y xa man quiri' tüj. ");
INSERT INTO cakENT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pero rix ri rixc'o chere' viq'uin vocomi, ri nquinivac'axaj-vi, tivac'axaj c'a ri ninbij chive: que'ijo' c'a ri nye'etzelan ivichin, y xaxe ri utz tibana' cheque ri vinük ri nyec'ulula'an ivichin. ");
INSERT INTO cakENT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tic'utuj c'a chin ri Dios que nyerubün bendecir ri vinük ri nyerayin itzel pan ivi', y chuka' man que'imestaj pan i-oración ri nyebanun chive que nic'usaj pokonül. ");
INSERT INTO cakENT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Y si c'o c'a jun nyixch'ayon, man c'a tiya' ruq'uexel chin. Utz c'a que niya' chic ivi' pa ruk'a' jun bey. Y si c'o c'a chuka' jun vinük numüj-e jun atziek ri cachi'el coton, man c'a tabisoj naya' chuka' e jun chic atziek chin. ");
INSERT INTO cakENT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Achique na c'a vinük ri c'o nuc'utuj chave, taya' chin ri nrajo'. Y si c'o jun vinük ri c'o numüj-e chave, man jun bey chic c'a tach'ojij chin. ");
INSERT INTO cakENT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Y rix utz tibana' quiq'uin ri vinük, roma rix man nka' ta chivüch c'a que ri vinük itzel quina'oj iviq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Y si rix xaxe ri vinük ri nyejo'on ivichin ri nye'ijo', man c'ayuf tüj. Roma achique na vinük ntiquer nbanun quiri'. Quiri' chuka' ri vinük juis ye itzel, nyequijo' ri nyejo'on quichin rije'. ");
INSERT INTO cakENT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Si rix, xaxe ri vinük ri nyebanun utz chive, xaxe cheque rije' nibün-vi utz chuka', man c'ayuf tüj. Quiri' chuka' ri vinük juis ye itzel, nquibün utz cheque ri vinük ri nyebanun utz cheque rije'. ");
INSERT INTO cakENT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Si rix niya' jun cosa chin jun vinük pa kajic, roma nivoyobej ri kajbül richin, man c'ayuf tüj. Roma ri vinük juis ye itzel nyequiya-ka pa kajic ri qui-cosas chiquivüch rije', richin quiri' c'o nquich'üc can chirij. ");
INSERT INTO cakENT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero rix man tibün quiri'. Xa que'ijo' ri vinük ri nye'etzelan ivichin. Que'itola'. Y tok rix niya' pa kajic jun i-cosa, man c'a tivoyobej ri kajbül richin. Richin quiri' nim ri rajil-ruq'uexel ri nic'ul, y nk'alajin c'a que rix ralc'ual chic ri nimalüj lok'olüj Dios ri c'o chila' chicaj. Rija' jabel runa'oj quiq'uin ri vinük juis ye itzel, y jabel runa'oj quiq'uin ri man jun bey nyematioxin tüj. Quiri' c'a chuka' tibana' rix. ");
INSERT INTO cakENT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tijoyovaj quivüch ri vinük, xa cachi'el ri nujoyovaj kavüch roj ri Katata' Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Man jun bey tibün que nye'itz'eta' ri vinük xaxe richin chi itzel nyixch'o chiquij, y ri Dios man nbün tüj chuka' quiri' iviq'uin rix. Man tirayij que ri vinük nc'atzinej que nquitoj ri itzel ri nyequibanala', y ri Dios man nbün tüj chuka' quiri' iviq'uin rix. Ticuyu' quimac ri vinük y ri Dios quiri' chuka' nbün iviq'uin rix. ");
INSERT INTO cakENT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Si rix riq'uin ronojel ivánima nye'ito' ri vinük riq'uin ri nc'atzin, ri Dios nuya' chuka' ri rajil-ruq'uexel chive. Ri rajil-ruq'uexel nuya' chive ri Dios, juis q'uiy. Nupulisaj ri iyaconabal. Y cachi'el ri nibün rix quiq'uin ri vinük, quiri' chuka' nbün ri Dios iviq'uin rix. ");
INSERT INTO cakENT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Y ri Jesús xbij c'a chuka' jun ejemplo cheque. Rija' xbij c'a: ¿C'o comi jun moy ri ntiquer ta nuyukej jun chic moy, y man ta nyetzak pa tak jul? ");
INSERT INTO cakENT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Y quiri' chuka' man jun c'a estudiante ri más ta ruk'ij que chuvüch ri ru-maestro. Man juba' tüj. Nretamaj na ronojel ri nc'atzin, c'ateri' junan nbün-e riq'uin ri ru-maestro. ");
INSERT INTO cakENT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Y achique roma tok rat ja ri vit k'ayis c'o pa runak'-ruvüch ri a-hermano ri natz'et chanin y man nana' tüj ri che' k'atül pa runak'-avüch rat? Ri ejemplo re' nbij c'a que man tikanimirsaj ri rumac jun hermano y nkach'utinirsaj-ka ri nimalüj tak kamac roj. ");
INSERT INTO cakENT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Y man tabij c'a chuka' chin ri a-hermano: Taya' k'ij chuve richin ninvelesaj ri vit k'ayis k'atül pa runak'-avüch, y man naya' tüj ka cuenta chin ri che' k'atül pa runak'-avüch rat. Ri ejemplo re' nbij c'a que man tabij chin jun a-hermano que man camacun chic, tok xa ja chuka' ri nabün rat. Man naya' tüj ka pa cuenta ri amac. Xa ca'i' apalüj. Nabey tachojmirsaj na ka ri ac'aslen rat, c'ateri' utz nato' ri a-hermano. ");
INSERT INTO cakENT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Y man jun utzilüj che' nuya' ta itzel tak ruvüch. Man jun chuka' che' ri man utz tüj, nuya' ta utzilüj tak ruvüch. ");
INSERT INTO cakENT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ri che' netamüx ruvüch si utz o man utz tüj, roma ri ruvüch ri nuya', si utz o man utz tüj. Roma ri k'ayis juis quiq'uixal man nquiya' tüj higo, nixta uva. ");
INSERT INTO cakENT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Y quiri' c'a ri achi. Ri achi utz, ja ri utz ri nbün y nbij, roma ja ri utz ri c'o pa ránima. Jac'a ri achi itzel, ja ri itzel ri nbün y ri nbij, roma ja ri itzel ri c'o pa ránima. Roma jun vinük jac'a ri c'o pa ránima ri nbij. ");
INSERT INTO cakENT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Y achique c'a chuka' roma tok rix nibij: Ajaf, Ajaf, nibila' chuve, y xa man nibün tüj ri ninbij yin chive? ");
INSERT INTO cakENT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Romari' ri vinük ri npu'u viq'uin, ri nrac'axaj ri nutzij y nbün ri ninbij chin, ");
INSERT INTO cakENT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","junan riq'uin ri jun achi ri xupaba' jun racho. Nabey, xbün-ka ri jul richin ri ru-cimiento ri jay, y pan abüj xuc'ot-vi-ka ri jul ri'. C'ateri' xuya' ri ru-cimiento ri jay, y xutz'om c'a samaj. Y tok c'achojnük chic c'a ri jay, xq'uiy-pe ri rakün-ya'. Y ri rakün-ya' ri' xberila' ri jay. Pero ri jay man xsilon tüj, man riq'uin tüj que ri rakün-ya' juis nimarnük, y juis ruchuk'a'. ");
INSERT INTO cakENT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero ri vinük ri npu'u viq'uin richin nrac'axaj ri nutzij, y man nbün tüj ri ninbij chin, junan riq'uin ri jun achi ri xupaba' jun racho, y xa man xuya' tüj ru-cimiento. Y tok ri rakün-ya' xbeq'uiy-pe, xberila' ri jay. Ri jay ri' xtzak y xq'uis chiri'. ");
INSERT INTO cakENT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tok ri Jesús xtane' chi tzij chiquivüch ri vinük, rija' xbe pa tinamit Capernaum. ");
INSERT INTO cakENT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Y chiri' pa tinamit c'o jun achi Capitán. Y ri achi ri' c'o jun rusamajel achi ri juis nrajo', pero yava', y xa jubama ncom yan ka. ");
INSERT INTO cakENT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Y tok ri Capitán xrac'axaj c'a pari' ri Jesús, rija' xerutük ch'aka rajatük tak achi'a' ri c'o quik'ij, achi'a' israelitas, richin quiri' nquic'utuj favor chin ri Jesús que tipu'u ba' richin nc'achojrisaj can ri rusamajel ri Capitán. ");
INSERT INTO cakENT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Y tok ri rajatük tak achi'a' xe'apon riq'uin ri Jesús, juis c'a xquic'utuj favor chin. Y xquibij chuka' chin: C'uluman-vi c'a que nabün ri jun favor ri' chin ri Capitán. ");
INSERT INTO cakENT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Roma rija' juis nkurujo' roj israelitas, y chuka' xbün jun jay ape' nkamol-vi-ki', ape' ntzijos-vi ri rutzij ri Dios, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Y ri Jesús xbe c'a chiquij ri rajatük tak achi'a' ri ye takon-pe roma ri Capitán. Y tok ri Jesús y ri ye benük chirij nakaj chic c'a nye'apon yan chiracho ri Capitán, rija' xerutük c'a pe ch'aka chic vinük ri quetaman ruvüch, chuc'ulic ri Jesús. Y ri achi'a' ri' xquibij-pe c'a chin ri Jesús: Ajaf, ri achi ri roj takayon-pe chi'ac'ulic rubin c'a pe: Ajaf, man taya' c'a más asamaj voma yin, yin xa jun aj-mac y romari' man c'uluman tüj chave que ncatoc pa vacho. ");
INSERT INTO cakENT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Y jari' ri xbanun chuve que xinna-vi. Que man c'uluman tüj que ja yin ri xinapon aviq'uin. Rat xaxe c'a tabij que nc'achoj ri nusamajel, y nc'achoj. ");
INSERT INTO cakENT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Y vetaman-vi que quiri' nbanatüj, roma yin, c'o jun ri nbin chuve ri nc'atzinej que ninbün. Y chuka' yec'o achi'a' ye yo'on pa nuk'a' yin. Tok ninbij c'a chin jun achi ri c'o pa nuk'a' que tibiyin, xa nbe-vi. Y si ninbij chuka' chin jun chic cheque ri achi'a' ri yec'o pa nuk'a' que tipu'u, xa npu'u-vi chuka'. Y tok ninbij c'a chin ri nusamajel que tabana' re', xa nbün-vi chuka', nbij-pe, xquibij ri achi'a' chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Y ri Jesús xe' xuca'yej tok xrac'axaj ri xquibij ri achi'a' chin. Xe' xuca'yej tok xrac'axaj ri rutakon-e rubixic ri Capitán. Y ri Jesús jari' xerutz'eta' ri vinük ri ye benük chirij, y xbij c'a cheque: Ketzij ninbij chive, que ri achi ri takayon-pe rubixic ri tzij re', ruyo'on-vi ránima viq'uin. Y man jun c'a nuvinak israelita ri vilon ri ruyo'on ta ránima viq'uin, cachi'el ri jun achi re'. ");
INSERT INTO cakENT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Y tok xetzolij ri vinük ri ye takon-pe roma ri Capitán, xquitz'et c'a que ri achi samajel, y yava' c'o can, man jun chic yabil c'o chirij. ");
INSERT INTO cakENT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jun chic c'a k'ij, ri Jesús xbe pa jun tinamit rubini'an Naín, y ye benük chuka' ri rachibila' chirij. Y juis c'a chuka' vinük ri ye tzekel-e chiquij. ");
INSERT INTO cakENT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tok ri Jesús y ri ye benük chirij nakaj chic chin nye'apon-apu pa tinamit Naín, xquitz'et c'a que c'amon-pe jun camnük richin nyemukux can. Ri camnük ri' jun ala', ral jun malca'n-ixok. Ri malca'n-ixok ri', xaxe c'a ri jun ral-ala' ri c'o, y jari' ri benük chumukic vocomi. Y juis c'a vinük ri nyepochi'ij richin ye benük chirij chumukic ri camnük. ");
INSERT INTO cakENT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Y tok ri Ajaf Jesús xutz'et ruvüch ri ixok ri xcom-e ri ral, xujoyovaj ruvüch, y xbij c'a chin: Man catok' chic c'a. ");
INSERT INTO cakENT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Y ri Jesús xutz'om-apu ri ru-cajón ri camnük, y ri ye uc'uayon-e richin ri camnük xepa'e-ka chiri'. Y rija' xbij chin ri camnük ala': Chave rat nquich'o-vi. Cacatüj. ");
INSERT INTO cakENT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Y tok ri Jesús xbij quiri', ri camnük ala' xcatüj, y xbetzijon-pe. Y ri Jesús xujüch-e c'a ri ala' chin ri rute'. ");
INSERT INTO cakENT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tok ri vinük xquitz'et ri xbanatüj, conojel juis xquixbij-qui'. Y xquiya' ruk'ij ri Dios chuka', y nquibila' c'a: Vocomi xbek'alajin-pe jun nimalüj achi chikacojol, ri nk'alajrisan ri rutzij ri Dios. Vocomi ri Dios xutük-pe jun ri nyo'on ri utzilüj rusipanic chikacojol roj ri rutinamit, xquibij ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Y ri xbün ri Jesús chupan ri k'ij ri', xetamüx chiri' pa Judea, y xetamüx chuka' pa tak tinamit ri yec'o-pe chunakaj ri Judea. ");
INSERT INTO cakENT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Y ri Juan Bautista xrac'axaj c'a ronojel, roma ja ri rachibila' rija' ri xebetzijon chin. Romari' rija' xeroyoj ye ca'i' cheque ri rachibila', ");
INSERT INTO cakENT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","y xerutük-e riq'uin ri Jesús. Xerutük-e richin xbequic'utuj chin: ¿Ja rat ri Cristo ri oyoben? ¿O xa c'a nkoyobej jun chic? Quiri' xbij-e cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Y ri ye rutakon-e ri Juan, xe'apon c'a riq'uin ri Jesús. Y rije' xquibij c'a chin: Ri Juan Bautista roj rutakon-pe aviq'uin, richin nkac'utuj chave: ¿Ja rat ri Cristo ri oyoben? ¿O xa c'a c'o chic na jun ri nkoyobej? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Y tok yec'o-ka chiri' c'a ri ye ca'i' rachibila' ri Juan, ri Jesús ye q'uiy c'a vinük xeruc'achojrisaj riq'uin ri quiyabil. Xeruc'achojrisala' chuka' vinük riq'uin nimalüj tak yabil. Xerelesala' chuka' itzel tak espíritu ri yec'o quiq'uin ch'aka vinük, y xbün chuka' cheque ri moyi' que xetzu'un. ");
INSERT INTO cakENT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Y jari' tok ri Jesús xbij cheque ri ye ca'i' rachibila' ri Juan: Vocomi quixtzolij, y titzijoj chin ri xitz'et can y xivac'axaj-e chere'. Titzijoj chin ri Juan achique rubanic tok ri moyi' nyetiquer nyetzu'un-e, achique rubanic tok ri vinük ri man nyetiquer tüj nyebiyin roma ri ye jetz', nyebiyin-e jabel, y achique rubanic tok ri ye yava'i' riq'uin ri yabil lepra nyec'achoj. Titzijoj chuka' chin ri achique rubanic tok ri man ncac'axaj tüj, nyec'achoj, ri caminaki' nyec'astüj, y ri vinük ri meba' cánima chuvüch ri Dios, ninbij ri utzilüj tzij richin colonic cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Y tibij chuka' chin que jun vinük cachi'el rija', ri ruyo'on ránima viq'uin y man jun bey nquirumalij tüj can, jabel ruquicot, xbij-e cheque, y xebe. ");
INSERT INTO cakENT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Y tok ri ye ca'i' achi'a' ri ye rutakon-pe ri Juan xetzolij, ri Jesús xerubila' c'a utzilüj tak tzij pari' ri Juan chiquivüch ri vinük yec'o chiri'. Y quere' c'a ri nbij ri Jesús cheque ri vinük: ¿Achique ri xbe'itz'eta' rix chiri' chupan ri tz'iran ruch'ulef? ¿Xitz'et comi rix jun achi chiri' ri cachi'el aj ri nbe cala' nbe cala' pa ruk'a' ri cakik'? ");
INSERT INTO cakENT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Achique c'a ri xbe'itz'eta' rix chiri'? ¿Xitz'et comi rix jun achi ri jabel tak tziük ye rucusan? Man quiri' tüj. Ri achi'a' ye cucusalon tziük quiri', jabel ri yec'o-vi. Rije' nyec'uje' pa tak cacho ri reyes. ");
INSERT INTO cakENT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Pero achique ri xbe'itz'eta' rix chiri' pa tz'iran ruch'ulef? ¿Jun achi ri nk'alajrisan ri bin chin roma ri Dios ri xitz'et chiri'? Ja'. Ri achi ri xitz'et chiri' ja vi ri' ri rusamaj. Pero c'o c'a chuka' jun chic samaj ri yo'on pa ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Y pari' c'a ri Juan nch'o-vi ri Dios chupan ri rutzij ri tz'iban can, tok nbij: Nintük c'a jun achi nabey, richin que nuchojmirsaj ri bey ape' napon-vi ri Cristo. Quiri' nbij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Y tivetamaj c'a, que ye jani' achi'a' ri ye k'alajrisüy rutzij ri Dios ri ye alaxnük chuvüch ri ruch'ulef, man jun c'a ri más c'o ta ruk'ij que chuvüch ri Juan Bautista. Rija' nim vi ruk'ij. Jac'a vocomi, conojel c'a ri nye'oc pa ruk'a' ri Dios, más c'a nimak' quik'ij. Y ri más co'ol cheque rije', más nim que chuvüch ri Juan. ");
INSERT INTO cakENT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Y chiri' yec'o c'a q'uiy vinük y moloy tak alcaval ri ye banun bautizar roma ri Juan. Y tok rije' xcac'axaj ri xbij ri Jesús, xquibij que ri Dios jabel choj. ");
INSERT INTO cakENT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Y ja ri achi'a' fariseos y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés man xcajo' tüj xquic'ul ri runucun ri Dios que quichin rije' chuka'. Rije' man xcajo' tüj que xeban bautizar roma ri Juan. ");
INSERT INTO cakENT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Y ri Ajaf Jesús xbij: ¿Achique comi ninbij pari' ri vinük richin ri tiempo re'? ¿Y achique chok q'uin ye junan vi? ");
INSERT INTO cakENT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ri vinük re' xa ye junan riq'uin ri jun catz'anin ri nquibün ri ac'uala' pa tak bey. Ri ac'uala' re' riq'uin cuchuk'a' nquibij chiquivüch, y nquibij c'a chupan ri catz'anin: Xojk'ojoman riq'uin xul chivüch y man xixxajo' tüj roma quicot. Xkabixaj bix richin bis chivüch y man xixok' tüj, nquibij ri ac'uala' pa catz'anin. Y ye quiri' ri vinük ri', man jun ri nka' chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Roma tok xc'ulun-pe ri Juan Bautista, rija' man xuc'ux tüj caxlan-vüy, man xutij tüj chuka' ri ruya'al-uva. Jac'a rix xibij chin que rija' c'o itzel espíritu riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Y tok xinka-pe yin, ri xinalüx chi'icojol, ninc'ux caxlan-vüy, y nintij chuka' ruya'al-uva. Y rix xibij chuve que xe va'in ninjo', y xibij chuka' que yin jun k'abarel, que yin cachibil ri moloy tak alcaval, y yin cachibil chuka' ri vinük ri aj-maqui' nibij rix cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero ri etamabül richin ri Dios nk'alajin pa quic'aslen ri vinük ri nyeniman richin, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Y c'o c'a jun achi fariseo ri xoyon richin ri Jesús. Xroyoj richin jun va'in pa racho. Y tok ri Jesús xapon c'a pa racho ri achi, xtz'uye' c'a apu chuvüch mesa, richin ri va'in. ");
INSERT INTO cakENT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Y chupan ri tinamit ri', c'o c'a jun ixok ri itzel ruc'aslen. Y ri ixok ri' xrac'axaj c'a que ri Jesús c'o pa racho ri jun achi fariseo, romari' rija' xapon chiri'. Y rija' ruc'uan-apu chuka' jun bambül, ri banun riq'uin jun abüj rubini'an alabastro. Ri bambül ri' c'o-e jun jubulüj ak'on chupan. ");
INSERT INTO cakENT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Y ri ixok ri' xapon c'a riq'uin ri Jesús, rija' juis c'a ntok'. Y ri ruya'al tak runak'-ruvüch ri ixok ri' nyeka-ka chirij rakün ri Jesús. Rija' nyerusula' c'a rakün ri Jesús, riq'uin ri rusmal tak ruvi'. Ri ixok ri' nyerutz'ubala' chuka' ri rakün ri Jesús, y xuya' chuka' ri jubulüj ak'on chirij ri rakün. ");
INSERT INTO cakENT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Y ri achi fariseo ri xoyon richin ri Jesús, tok xutz'et ri xbün ri ixok, xunuc-ka: Si ta ri Jesús ketzij vi que k'alajrisüy richin ri rutzij ri Dios, nunabej ta achique ntz'amon la rakün, y achique chi vinük la ixok la'. Roma la jun ixok la' itzel ri ruc'aslen, xbij-ka pa ránima. ");
INSERT INTO cakENT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Y ri Jesús xbij chin ri achi fariseo ri xoyon richin: Simón, c'o jun ri ninjo' ninbij chave. Ri Simón xbij chin: Ajaf, ¿achique c'a ri najo' nabij chuve? ");
INSERT INTO cakENT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Y ri Jesús xbij chin: Yec'o c'a ye ca'i' achi'a' c'o quic'as riq'uin jun achi ri nyo'on tumin pa kajic. Jun cheque ri achi'a' ri', vo'o' ciento quetzales ruc'as, y ri jun chic, cincuenta quetzales ruc'as. ");
INSERT INTO cakENT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero roma c'a ri achi'a' ri' man nyetiquer tüj nquitoj ri quic'as, ri achi ri yo'on tumin pa kajic cheque, xbij que man tiquitoj chic, xa tiq'uis quiri', xbij cheque. Y ri Jesús xbij chuka' chin ri Simón ri fariseo: Vocomi c'a tabij chuve, ¿Achique c'a cheque ri ye ca'i' achi'a' ri' ri más najo'on richin ri achi ri nyo'on tumin pa kajic? ");
INSERT INTO cakENT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ri Simón xbij: Yin ninbij que ja ri más q'uiy ruc'as xbün riq'uin. Ja', quiri', xbij ri Jesús chin ri Simón. ");
INSERT INTO cakENT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Y ri Jesús nutz'et ri ixok tok xbij chin ri Simón ri fariseo: ¿Natz'et ri ixok re'? Yin tok xinoc-pe chere' pan avacho, man xaya' tüj nuya' ch'ajbül-vakün. Jac'a ri ixok re' xeruch'üj ri vakün riq'uin ri ruya'al tak runak'-ruvüch, y xerusu' riq'uin ri rusmal tak ruvi'. ");
INSERT INTO cakENT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Chuka' tok xinoc-pe man xinatz'ubaj tüj richin xinabün saludar. Jac'a ri ixok re', ja ri vakün ri ye rutz'uban hasta que jampe' xinoc-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Rat chuka' man xak'ij tüj aceite pa nuvi' tok xinoc-pe. Jac'a ri ixok re', jubulüj ak'on ri xuyala' chirij ri vakün. ");
INSERT INTO cakENT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Romari' ninbij chave rat Simón, que ri ixok re' juis nrajo' ri Jun ri xcuyun ri rumac. Roma ri janipe' mac ri ye rubanalun xecuyutüj yan. Jac'a ri xa man q'uiy tüj ri rumac ri xecuy, xa man quiri' tüj nrajo' ri Jun ri xcuyun ri rumac. ");
INSERT INTO cakENT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Y ri Jesús xbij chin ri ixok: Ri amac xecuyutüj yan. ");
INSERT INTO cakENT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Y ri vinük ri ye oyon roma ri Simón ri fariseo y junan yec'o riq'uin ri Jesús chiri' chuvüch mesa, nquibila' c'a chiquivüch: ¿Achique c'a chi achi re'? Roma nyerucuy mac chuka', nquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Y ri Jesús xbij chin ri xtün: Xacolotüj, roma ri xaya' avánima viq'uin. Vocomi c'a, catzolij. Ri avánima xril yan uxlanen. ");
INSERT INTO cakENT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ca'i-oxi' k'ij c'unük ronojel ri', ri Jesús xutz'om c'a nbe pa tak nimak' y cocoj tinamit, y ye doce rachibila' ye benük chirij. Y rija' nutzijoj ri utzilüj rutzij ri Dios ri nch'o pari' tok ri vinük nye'oc pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Y yec'o chuka' ca'i-oxi' ixoki' ri ye tzekel-e chirij. Ri ixoki' ri', jari' ri ye ruc'achojrisan ri Jesús y relesalon itzel tak espíritu chiquij. Chiquicojol c'a ri ixoki' ri' benük ri María, ri nbix Magdalena chin chuka'. Y ja riq'uin ri ixok ri' xe'elesüs-e ye siete itzel tak espíritu, roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Chiquicojol ri ixoki' ri ye tzekel chirij ri Jesús, benük ri jun ixok ri rubini'an Juana, rixjayil ri jun achi rubini'an Chuza. Y ri achi ri' jun rusamajel ri Herodes. Chuka' benük ri jun ixok rubini'an Susana. Y yec'o chuka' ch'aka chic ixoki' ri ye benük ri nyeto'on chuka' richin ri Jesús. Ri ixoki' ri' xequilij ri Jesús y ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Y riq'uin ri Jesús juis q'uiy vinük xquimol-qui', vinük ri nyepu'u pa ch'aka chic tinamit. Romari' ri jun k'ij ri', tok juis chic ye q'uiy vinük quimolon-qui' riq'uin, rija' xbij jun ejemplo cheque: ");
INSERT INTO cakENT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","C'o c'a jun achi ri xbejopin ija'. Y tok ri achi njopin chic ija', juba' c'a chin ri ija' xtzak pa bey, romari' ri vinük yec'o pari'. Y riq'uin chic xepu'u ri ch'ipa' ri nyebe chicaj, xquic'ux-e ri ija' ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Y ch'aka chic ija' xtzak chucojol tak abüj. Ri ija' ri' richin xel-pe, xel-pe. Jac'a tok xpu'u ruvüch ri k'ij, xechaki'j-ka, roma man rüx tüj ri ulef ape' xtzak-ka-vi ri ija'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Y ba' chic ija' xtzak chucojol k'ayis c'o quiq'uixal. Y tok xe'el-pe, junan xeq'uiy quiq'uin ri q'uix. Pero roma ri q'uix juis xeq'uiy, ri tico'n xek'ayisüs pa quik'a'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Y ri ch'aka chic c'a ija' xka-ka pa jun utzilüj ulef, y jabel xeq'uiy. Y xquiyala' jujun ciento quivüch jujun ija', xbij. Y tok rubin chic ka ri' ri Jesús, riq'uin c'a ruchuk'a' xch'o, y xbij: Ri c'o c'a ruxiquin, trac'axaj c'a ri xinbij, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Y ri rachibila' ri Jesús xquic'utuj c'a chin que achique c'a ri nrajo' nuk'alajrisaj chiquivüch riq'uin ri jun ejemplo ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Y ri Jesús xbij cheque: Man jun bey bin ta can jabel pari' tok ri vinük nye'oc pa ruk'a' ri Dios, pero chive rix yo'on c'a k'ij que nivetamaj. Jac'a cheque ri vinük ri man nyetaken tüj vichin, riq'uin ejemplos nquich'o-vi quiq'uin, richin quiri' choj nquitz'eta' y man nquitz'et tüj jabel ri nquitz'et, y richin que choj ncac'axaj y man nk'ax ta cheque ri ncac'axaj. ");
INSERT INTO cakENT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Y quere' c'a ri nbij ri ejemplo ri': Ri ija' junan nbün riq'uin ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ri ba' ija' ri xtzak-ka pa bey, junan riq'uin ri rutzij ri Dios tok nac'axüx coma ri vinük. Ri itzel-vinük junanin npu'u, y nrelesaj-e ri rutzij ri Dios pa tak cánima ri vinük ri', richin quiri' ri vinük ri' man tiquitakej ri Dios, y man quecolotüj chuka'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Y ri ija' ri xtzak can chucojol tak abüj, nch'o-vi c'a pari' ri rutzij ri Dios ri nac'axüx coma ri vinük. Ri vinük ri' juis c'a nyequicot tok nquic'ul ri rutzij ri Dios pa tak cánima. Pero roma c'a ri man nuc'ün tüj ka ruxe' jabel ri rutzij ri Dios pa tak cánima, man nlayuj tüj c'a ri quicot quiq'uin, xa jun ca'i-oxi' oc k'ij nquiya' cánima riq'uin ri Dios. Y tok nyetijox c'a, man c'ayuf tüj richin nquiya' can ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ri ija' ri xtzak chucojol tak k'ayis ri c'o quiq'uixal nch'o-vi c'a pari' ri rutzij ri Dios ri nac'axüx coma ri vinük. Pero ri vinük ri' xa nyejik' roma ja ri nc'atzin chin ri quic'aslen chere' chuvüch ri ruch'ulef ri nquinuc, nyejik' chupan ri quibeyomal y chuka' chupan ri nyequirayila'. Y man nquic'uan tüj jun utzilüj c'aslen, y man nyeq'uiy tüj chupan ri rutzij ri Dios. Y romari' man q'uiy tüj ch'aka chic nyetaken ri rutzij ri Dios ");
INSERT INTO cakENT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Y ri ija' ri xtzak pa jun utzilüj ulef, nch'o-vi c'a pari' ri rutzij ri Dios ri nac'axüx coma ri vinük. Rije' riq'uin ronojel cánima ncac'axaj y nquibün ri nbij. Chi jumul quiyo'on cánima riq'uin ri Dios, y nquic'uan jun utzilüj c'aslen y nyeq'uiy chupan ri rutzij ri Dios. Y romari' ye q'uiy ch'aka chic nyetaken ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Y man jun vinük chuka' ri nutzij jun k'ak' y c'ateri' nrajo' nutz'apij o nuya' ta apu chuxe' ri ruch'at. Man quiri' tüj nbün. Ri k'ak' ri' nc'atzin richin ncanox jun c'ojlibül ape' ntz'uyubüs-vi, richin quiri' ri nye'oc-apu pa jay nyetzu'un jabel. ");
INSERT INTO cakENT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Y man jun ri evan can, ri man ta nbek'alajin-pe. Y chuka' man jun ri tz'apin can rij, ri xa man ta nbek'alajin-pe y ntel-pe chuvüch-sük. ");
INSERT INTO cakENT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Y quiri', si rix nivac'axaj ri rutzij ri Dios, tiyaca' c'a ka pa tak ivánima. Roma ri c'o c'a ruyacon pa ránima, nuc'ul c'a más. Jac'a ri nrac'axan ri rutzij ri Dios y xa man nuyüc tüj ka pa ránima, ri jaru' ri nunuc que ruchajin, hasta ri' ntelesüs pa ruk'a', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Y ri rute' y ri ye ruchak' ri Jesús xepu'u c'a ape' c'o-vi rija'. Pero man xetiquer tüj c'a xe'apon-apu riq'uin rija', roma juis ye q'uiy vinük quimolon-qui' riq'uin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Y xbix c'a apu chin ri Jesús: Ri ate' y ri ye achak' rat coyoben chuvüch-jay, ye petenük chin ncatquitz'eta'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero rija' xbij: Ja ri vinük ri nye'ac'axan y nquibün ri nbij ri rutzij ri Dios, jari' ri nte' y ri ye nchak', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Y jun k'ij, ri Jesús rachibilan ri rachibila', xoc-e pa jun canoa. Y c'ateri' xbij cheque: Jo' la lojc'an chic ruchi-ya'. Y xebe. ");
INSERT INTO cakENT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Y ri Jesús xvür-e, tok quitz'amon-e bey pari' ri ya'. Quitz'amon c'a bey tok xpu'u jun cakik' juis nim chiri' pari' ri ya'. Romari' ri canoa ape' ye benük-vi, xutz'om nnoj-pe ya' chupan, y riq'uin ri' man c'ayuf tüj nbe chuxe' ya' ri canoa. Pa c'ayuf c'a yec'o-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Xepu'u c'a ri rachibila' xquic'asoj ri Jesús, y xquibij chin: ¡Ajaf! ¡Ajaf! Vocomi nkucom, xquibij chin. Y ri Jesús xcatüj c'a pe, y xbij: Tiq'uis-e ri cakik' y titane-ka ri nbolko't ri ya'. Y quiri' xbanatüj. Ri cakik' xq'uis-e, y ri nbolko't ri ya' xtane-ka. ");
INSERT INTO cakENT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","C'ateri' ri Jesús xbij cheque ri rachibila': ¿Achique roma tok man xiya' tüj ivánima viq'uin? Pero ri achibila' quixbin-qui'. Xe' xquica'yej tok xquitz'et ri xbanatüj y xquic'utula' chiquivüch: ¿Achique c'a chi achi re'? Roma nch'o cheque ri cakik' y ri ya', y nquitakej rutzij. ");
INSERT INTO cakENT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Y ri Jesús y ri rachibila' xe'apon c'a ri lojc'an-apu ruchi-ya', chiri' pa jun lugar rubini'an Gadara, ri c'o-apu chuvüch ri ruch'ulef Galilea. ");
INSERT INTO cakENT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Y tok ri Jesús xka-ka can chupan ri canoa, xapon jun achi aj pa tinamit riq'uin. Y ri achi ri' c'o chic c'a q'uiy tiempo ri yec'o-pe itzel tak espíritu riq'uin. Manak rutziek nucusaj, nixta man nc'uje' tüj pa racho. Xa ja ri camposanto richin ri tinamit ri', ri c'unük racho. ");
INSERT INTO cakENT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Y ri achi ri', xe xutz'et ri Jesús, jari' xbexuque' chuvüch. Y riq'uin c'a ruchuk'a' nch'o-apu chin ri Jesús, y nbij c'a: Rat Jesús ri Ruc'ajol ri nimalüj Dios, ¿achique roma tok nquinanük? Tabana' jun favor man quinaya' pa k'oxomül. ");
INSERT INTO cakENT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ri achi xbij quere' roma ri Jesús xbij chin ri itzel espíritu c'o riq'uin, que tel-e chiri'. Roma q'uiy tiempo c'o-pe ri itzel espíritu ri' riq'uin. Y roma chuka' ri' ri vinük quitz'amon ye quiximilon ruk'a-rakün ri achi ri' riq'uin ch'ich' y cadenas, pero man ye tiquernük tüj chirij. Roma ri achi ri' nyeruk'üj ri cadenas ri ye ximiyon richin, y ri itzel espíritu c'o riq'uin nbün c'a chin que nbe pa tz'iran ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Y ri Jesús xuc'utuj c'a chin ri achi: ¿Achique abi'? Y ri achi xbij: Legión nubi', xbij. Quiri' xbij ri achi roma ye juis ri itzel tak espíritu ri yec'o riq'uin, y ri tzij Legión ntel chi tzij que ye q'uiy. ");
INSERT INTO cakENT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Y ri itzel tak espíritu ri' juis xquic'utuj favor chin ri Jesús, que si nyerelesaj-e riq'uin ri achi, man querutük-e c'a chupan ri qui-lugar conojel ri itzel tak espíritu, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Y roma chunakaj apu ri lugar ri', pari' jun juyu', juis ye q'uiy ak nyeva', romari' ri itzel tak espíritu xquic'utuj favor chin ri Jesús que tuya' k'ij cheque richin nye'oc quiq'uin ri ak ri'. Y ri Jesús xbij cheque que utz. ");
INSERT INTO cakENT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Y ri itzel tak espíritu jari' xe'el-e riq'uin ri achi, y xebe'oc quiq'uin ri ak. Conojel c'a ri ak ri' xquitz'om canin chuvüch jun juyu' pa'ül-pa'ül, y jic' xebetzak-ka pa ya'. Y chiri' xejik'-vi conojel ri ak ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Y ri nyeyuk'un quichin ri ak ri', tok xquitz'et ri xc'ulachitüj, xe'anmüj. Y rije' xbequiyala' rutzijol pa tinamit y pa k'ayis chuka'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Y ri vinük ri xe'ac'axan-pe ri xc'ulachitüj, xepu'u richin xquitz'eta'. Tok ri vinük ri' xeka-pe riq'uin ri Jesús, xquitz'et c'a que ri achi ri xe'elesüs ri itzel tak espíritu chirij, tz'uyul c'a apu riq'uin ri Jesús. Rucusan rutziek, y man nbün tüj chic c'a ri cachi'el ri rubanun-pe. Pero ri vinük ri' xa nquixbij-qui' tok xquitz'et ri achi ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Y xtzijos chuka' cheque ri ketzij ri xc'ulachitüj. Ronojel ri' xtzijos cheque coma ri vinük ri xetz'eton tok xe'elesüs ri itzel tak espíritu chirij ri achi, roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Riq'uin c'a ri xc'ulachitüj ronojel ri', ri vinük ri aj chiri' pa Gadara xquic'utuj c'a favor chin ri Jesús que man tic'uje-ka chiri'. Ri vinük ri aj chiri' xquibij quiri' roma ri juis quixbin-qui'. Roma c'a ri' ri Jesús ye rachibilan ri rachibila' xoc-e pa canoa, richin nbe. ");
INSERT INTO cakENT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Y ri achi ri xe'elesüs ri itzel tak espíritu chirij, nuc'utuj c'a favor chin ri Jesús que tuya' k'ij chin richin nbe chirij. Pero richin que ntzolij ri achi, ri Jesús xbij c'a chin: ");
INSERT INTO cakENT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Catzolij chi'avacho, y te'atzijoj ri xbün ri Dios chave rat, xbij. Y ri achi xberutzijoj na vi chiracho, y cheque conojel ri vinük pa rutinamit xutzijoj ri xbün ri Jesús chin rija'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Y tok ri Jesús ye rachibilan ri rachibila' xtzolij c'a lojc'an chic ruchi' ri ya', ri vinük yec'o chiri', riq'uin juis quicot xquic'ul-apu, roma ri vinük ri' ja rija' ri coyoben. ");
INSERT INTO cakENT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Xapon c'a chuka' jun achi rubini'an Jairo. Ri achi c'a ri' c'o jun rusamaj chupan ri jay ape' ntzijos-vi ri rutzij ri Dios y ja rija' ri cachi'el tata'aj chiri'. Ri achi rubini'an Jairo xbexuque' chuvüch ri Jesús, y xuc'utuj favor chin que tibe c'a chirij pa racho, ");
INSERT INTO cakENT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","roma xaxe ri jun vit rumi'al c'o, ri c'o la'ük doce rujuna' y ncom yan ka. Y tok ri Jesús y ri ye benük chirij xquitz'om-e bey richin nyebe pa racho ri Jairo, juis ye q'uiy vinük xetzeke-e chirij. Y roma juis ye q'uiy ri vinük ri ye benük, man utz tüj nyebiyin ");
INSERT INTO cakENT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chiquicojol c'a ri vinük, benük jun ixok yava'. Ri ixok re' c'o yan doce juna' yava' riq'uin ntel ruquiq'uel. Xuq'uis yan c'a ronojel rutumin, roma benük chic quiq'uin q'uiy ak'omanela', y man jun cheque ri ak'omanela' rubanun ta rak'oman ri ruyabil. ");
INSERT INTO cakENT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ri ixok ri' xjel-apu c'a riq'uin ri Jesús, pero ja ri chirij, y xberutz'ama' c'a can ba' ri ruchi-rutziek ri Jesús. Y jari' xc'achoj can ri ruyabil ri ruchajin. ");
INSERT INTO cakENT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Y jari' tok ri Jesús xuc'utuj: ¿Achique ri xintz'amon? Y roma ri conojel rije' nquibij que man jun quitz'amon, ri Pedro y ri ch'aka chic achibila' xquibij chin ri Jesús: Ajaf, rat najo' navetamaj achique xatz'amon. Pero chere' c'ayuf richin navetamaj, roma juis ye q'uiy vinük nquipitz'-qui' y nquinimila-qui' chavij, y rat nac'utuj: ¿Achique xintz'amon? ");
INSERT INTO cakENT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Y jari' tok ri Jesús xbij: C'o jun ri xintz'amon, roma xinna' que c'o jun ri xinc'achojrisaj riq'uin ri vuchuk'a' c'o viq'uin, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Y ri ixok tok xutz'et que xa xnabex, nbarbot xxuque-pe chuvüch ri Jesús. Y chiquivüch conojel ri vinük xbij-apu chin ri Jesús ri achique roma tok xutz'om ruchi-rutziek. Y xbij chuka' tok xe xutz'om ruchi-rutziek ri Jesús, jari' xc'achoj xuna' rija'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ri Jesús xbij chin: Numi'al, xacolotüj, roma xaya' avánima viq'uin. Vocomi c'a, catzolij. Ri avánima xril yan uxlanen, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Y tok ntajin c'a ntzijon ri Jesús riq'uin ri ixok, tok c'o jun xka-pe petenük chiracho ri Jairo, ri achi ri cachi'el tata'aj chiri' pa jay ape' ntzijos-vi ri rutzij ri Dios. Ri jun ri xpu'u, xbij-pe c'a chin ri Jairo: Man tac'uaj chic e ri Maestro Jesús, roma ri vit ami'al xa xcom yan. ");
INSERT INTO cakENT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jac'a tok ri Jesús xrac'axaj-pe, xbij chin ri Jairo: Man tuxbij-ri' ri avánima roma ri xbix-pe chave. Taya' c'a avánima viq'uin, y ri vit ami'al nc'astüj, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Y tok xe'apon c'a chiracho ri Jairo, ri Jesús xaxe c'a cheque ri Pedro, ri Jacobo y ri Juan ri ye rachibila', y cheque ri rute-rutata' ri ac'ual xuya' k'ij richin xe'oc riq'uin ri vit camnük. ");
INSERT INTO cakENT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Conojel juis nquibisoj y ncok'ej ri vit xtün ri'. Pero ri Jesús xbij cheque: Man tivok'ej chic c'a ri vit xtün, roma rija' xa man camnük tüj, rija' xa nuxlan, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero rije' xa xetze'en chirij ri Jesús, roma quetaman que xa camnük chic ri vit xtün ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Y ri Jesús xutz'om ruk'a' ri vit xtün camnük, y xbij c'a: Vit xtün, cacatüj. ");
INSERT INTO cakENT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Y ri vit xtün xtzolij na vi pe ri ránima riq'uin, y jari' xcatüj-pe. Y ri Jesús xbij que tisuj ruvay. ");
INSERT INTO cakENT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Y ri te'ej-tata'aj xe' xquica'yej tok xquitz'et ri xbanatüj riq'uin ri calc'ual. Y ri Jesús xbij cheque que man tiquitzijoj ri xbanatüj chiri'. ");
INSERT INTO cakENT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ri Jesús xeroyoj c'a ri doce rachibila', y xuya' cuchuk'a' cheque richin nyequelesala' conojel quivüch itzel tak espíritu, y richin chuka' nyequic'achojrisala' yava'i'. Y man xe tüj chuka' xuya' cuchuk'a' cheque, xa xuya' chuka' k'ij cheque richin nquicusaj ri cuchuk'a' ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Y xerutük c'a e ri rachibila' richin xebe chutzijosic pari' tok ri vinük nye'oc pa ruk'a' ri Dios, y richin chuka' nyequic'achojrisaj yava'i'. ");
INSERT INTO cakENT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Y ri Jesús xbij cheque chuka': Ri ntz'om-e bey, man jun c'a tic'uaj. Man tic'uaj ch'ami'y, man tic'uaj morral, nixta vüy, nixta tumin. Y man tic'uaj chic jun itziek, xaxe ri icusan-e tic'uaj. ");
INSERT INTO cakENT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Y ri jay c'a ape' nyixapon-vi, pa jun tinamit, chiri' quixc'uje-vi-ka. Xa c'a ja tok nyixel na pe chupan ri tinamit ri', utz niya' can ri jay ape' xixc'uje-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Y si ri tinamit ape' nyixapon-vi xa man nyixc'ul tüj jabel, xa tiya' can c'a, y titotala' can ri pokolaj ri c'o pa tak ivakün chiquivüch ri vinük, richin quiri' tiquinabej que man utz tüj ri xquibün, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Y ri achibila' xebe na vi. Xebe pa tak cocoj tinamit richin xbequitzijoj ri utzilüj tzij richin colonic. Y xequic'achojrisala' chuka' yava'i' ronojel lugar ape' xec'o-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Y ri Herodes ri gobernador chupan ri tiempo ri', nyerac'axala' c'a ronojel ri nyerubanala' ri Jesús. Pero man nril tüj c'a achique ri nunimaj, roma yec'o ri nyebin que ri nbanun ri nojibül ri' ja ri Juan Bautista c'astajnük chic pe. Ri Juan camnük chic c'a ri tiempo ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yec'o c'a chuka' nyebin que ri Jesús ja ri Elías ri xtzolij-pe. Y ch'aka chic vinük nquibij c'a que ri Jesús jun cheque ri ch'aka chic achi'a' ri xek'alajrisan ri rutzij ri Dios ojer can, ri xbec'astüj-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Y ri Herodes nbij: ¿Achique comi achi ri Jesús re'? Roma q'uiy nyenvac'axaj pari'. Pero man ja tüj ri Juan Bautista, roma ri Juan ja yin xintakon rukupuxic rukul, xbij. Y ri Herodes xucanola' c'a rubanic richin que xutz'et ta ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Y tok ri ye ru-apóstoles ri Jesús xetzolij-pe riq'uin ri xquibanala' ri rusamaj ri Dios, xquitzijola' c'a chin ri Jesús ri xquibanala'. Y ri Jesús xeruc'uaj c'a e ri rachibila' ri', y xebe pa jun tz'iran ruch'ulef. Y ri lugar ri' richin c'a ri tinamit rubini'an Betsaida. ");
INSERT INTO cakENT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Y tok ri vinük xequinabej-e ri Jesús y ri rachibila', xebe chuka'. Y tok ri vinük ri' xe'apon riq'uin ri Jesús, rija' jabel xeruc'ul y xbij chuka' cheque pari' tok ri vinük nye'oc pa ruk'a' ri Dios. Y chuka' xeruc'achojrisala' yava'i'. ");
INSERT INTO cakENT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Y tok xa xkak'ij-ka ri k'ij ri', ri doce achibila' xejel-apu riq'uin ri Jesús y xquibij chin: Que'ataka' c'a e ri vinük re' richin nyebe chucanoxic ape' nyebevür-vi, y nyebe chuka' chucanoxic quivay pa tak cocoj tinamit y pa ch'aka chic lugar ri yec'o-pe nakaj. Roma ri ape' rojc'o-vi, xa ye manak vinük, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jac'a ri Jesús xbij cheque ri rachibila': Tiya' quivay rix. Y ri rachibila' xquibij chin ri Jesús: Chere' man q'uiy tüj vüy c'o richin nkaya' cheque, xaxe vo'o' vüy y ca'i' cür. Ri vinük re' nyeva', pero si nkube chulok'ic vüy, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Roma ri vinük juis ye q'uiy. Y xaxe achi'a' yec'o la'ük vo'o' mil. Y ri Jesús xbij cheque ri rachibila': Tibana' c'a cheque ri vinük re' que quetz'uye' pa tak nic'aj ciento, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Y quiri' na vi xquibün ri achibila', xequitz'uyuba' conojel vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Y ri Jesús xeruli'ej c'a pa ruk'a' ri vo'o' vüy y ca'i' cür, xtzu'un chicaj y xumatioxij ri vüy y ri cür ri' chin ri Dios. Y ri Jesús xeruper c'a e ri vüy y ri cür, xuya-e cheque ri rachibila' richin nquiya' cheque ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Conojel c'a jabel xquic'ux quivay. Man jun c'a ri man ta jabel xva'. Y c'a c'o na doce chacüch vüy y cür xcolotüj can. ");
INSERT INTO cakENT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Y jun k'ij ri Jesús rujachon-e ri', roma nbün orar, y ri rachibila' yec'o chuka' riq'uin. Y jari' tok ri Jesús xuc'utuj cheque ri rachibila': ¿Yin achique c'a yin nquinuc ri vinük? ");
INSERT INTO cakENT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Y rije' xquibij chin: Yec'o ri nquibij que rat ja ri Juan Bautista. Yec'o ch'aka chic nquibij que ja rat ri Elías, ri jun achi ri xk'alajrisan ri xbix chin roma ri Dios ojer can. Y yec'o c'a chuka' ri nquibij que rat jun cheque ri ch'aka chic achi'a' ri xek'alajrisan ri xbix cheque roma ri Dios, ri ojer can, y vocomi xac'astüj-pe chiquicojol ri caminaki', xquibij chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Y rija' xuc'utuj c'a cheque ri rachibila': Y rix ¿achique ninuc pa nuvi'? xbij cheque. Y ri Pedro jari' xbij chin ri Jesús: Ja rat ri Cristo, ri takon-pe y cha'on-pe roma ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero ri Jesús juis xuchilabej cheque ri rachibila' que man tiquitzijoj que ja rija' ri Cristo. ");
INSERT INTO cakENT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Y xbij c'a chuka' cheque: Yin ri xinalüx chi'icojol, nc'atzinej que ninc'usaj q'uiy pokonül. Y nquinetzelüs coma ri rajatük tak achi'a' ri c'o quik'ij. Nquinetzelüs coma ri más nimalüj tak sacerdotes y coma ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés. Y nquicamsüs. Pero pa rox k'ij nquic'astüj-pe, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Y jari', cheque c'a conojel xbij-vi: Si c'o jun nrajo' ntzekleben vichin, tubana' c'a cachi'el nbün jun ri benük chuxe' ru-cruz. Man nbün tüj ri nurayij rija'. Man nupokonaj tüj nuc'usaj pokonül. Si c'o c'a jun ri nunucun que ntiquer nbün quiri' k'ij-k'ij, utz npu'u viq'uin richin nquirutzeklebej. ");
INSERT INTO cakENT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Roma si juis nujoyovaj ruvüch ruc'aslen chere' chuvüch ri ruch'ulef, xa man nril tüj c'a ruc'aslen richin chi jumul. Jac'a ri man nujoyovaj tüj ruvüch ruc'aslen ri', stape' (aunque) napon pa camic voma yin, xa nril ruc'aslen richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Roma achique ta c'a nuc'ün-pe chin ri vinük si nc'uje' ri beyomül richin ronojel ri ruch'ulef riq'uin y ri vinük ri' xa man ncolotüj tüj? Xa ruyon c'a nuya-ri' chupan ri camic ri richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Y si c'o chuka' jun chive rix nq'uixaj nuk'alajrisaj que yin rutaken yin y ri nutzij, yin chuka' ri xinalüx chi'icojol, nquiq'uixaj ninbij que ri jun vinük ri' vichin yin. Quiri' ninbün tok nquipu'u jun bey chic, tok nk'alajin que yin Rey vi, y chuka' junan chic nuk'ij riq'uin ri Nata' y ye vachibilan-pe ri lok'olüj tak ángeles. ");
INSERT INTO cakENT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Y ketzij c'a ri ninbij chive, que ri Dios nc'uje' c'a pe pa kavi' y ntoc jun utzilüj ri nbün mandar. Y yec'o c'a chive rix ri man nyecom tüj, tok c'a quitz'eton chic na can ri', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Y colope' c'o yan jun semana xc'o can tok ri Jesús xch'o chiquivüch ri vinük, c'ateri' rija' xerucha' c'a ri Pedro, ri Juan y ri Jacobo richin que nyerachibilaj-e ri nbe pari' jun juyu' chin nquibün orar. ");
INSERT INTO cakENT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Y tok ri Jesús ntajin q'uin ri oración, xjalatüj ri ruvüch, y quiri' chuka' ri rutziek, xjalatüj. Ri rutziek juis rusük xbün y nyiq'uiyot. ");
INSERT INTO cakENT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Y tok ri ye oxi' achibila' xquitz'et c'a, nyetzijon yan chic riq'uin ri Jesús ca'i' achi'a'. Ri ca'i' achi'a' ri' quibini'an Moisés y Elías, y ye rusamajela' ri Dios ri xec'uje' ojer can tiempo. ");
INSERT INTO cakENT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ri ye ca'i' ri' c'a yec'o c'a pa jun lok'olüj sük, y nyetzijon pari' ri camic ri nuc'uaj ri Jesús pa Jerusalén. Roma ja samaj ri' ri yo'on-pe chin roma ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Y ri Pedro y ri rachibil, stape' (aunque) juis quivaran, xquicoch', y xquitz'et c'a ri lok'olüj rusakil ri Jesús, y xequitz'et chuka' ri ye ca'i' chic achi'a' ri yec'o riq'uin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Y tok ri ca'i' achi'a' ri' ntajin nquiya' can ri Jesús richin nyebe, jari' tok ri Pedro xbij chin ri Jesús: Ajaf, chere' utz kabanun. Tikabana' oxi' tak jay, jun avichin rat, jun richin ri Moisés y jun richin ri Elías. Ri Pedro quiri' c'a xbij-apu y man retaman tüj achique roma tok xch'o-apu. Xa nucun man nucun tüj ri xerubila-apu. ");
INSERT INTO cakENT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Y tok c'a nch'o na rija' tok c'o jun sutz' ri xbec'ulun-pe y xerutz'apij. Y ri achibila' xquixbij-qui' tok xquina' que yec'o chic chupan ri sutz' ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Y jari' tok c'o jun ch'abül xcac'axaj chupan ri sutz' ri', y xbij: Jare' ri Nuc'ajol, y juis ninjo'. Tivac'axaj c'a ri rutzij. ");
INSERT INTO cakENT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Y ja tok cac'axan chic ri jun ch'abül ri', tok xquitz'et yan chic, ri Jesús xa ruyon chic c'o. Y ri achibila' ri', q'uiy c'a tiempo ri man jun xquitzijoj-vi ri xquitz'et chiri' pari' ri juyu'. ");
INSERT INTO cakENT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Y pa ruca'n k'ij, tok ri Jesús ye rachibilan ri ye oxi' rachibila' xka-pe pari' ri juyu', ye juis c'a ye q'uiy ri vinük ri xec'ulun-apu. ");
INSERT INTO cakENT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Y jun achi ri c'o chiquicojol ri vinük, xch'o-apu chin ri Jesús. Maestro, xbij c'a apu chin. Yin xaxe jun valc'ual c'o. Ninc'utuj c'a favor chave que tatz'eta' ba', ");
INSERT INTO cakENT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","roma c'o jun itzel espíritu ri ntz'amon. Y tok nutz'om, nbün c'a chin que riq'uin ruchuk'a' nch'o, nbün chin que nuyiquiya' ri ruch'acul, y nbün chuka' chin que nvokon ruc'axaj pa ruchi'. Ri itzel espíritu ri' juis c'a nbün chin ri nuc'ajol, y c'arunaj nuya' can tok nutz'om. ");
INSERT INTO cakENT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Romari' xinc'utuj yan favor cheque ri avachibila' que tiquelesaj ri itzel espíritu ri' riq'uin ri nuc'ajol, pero xa man nyetiquer tüj, xbij ri achi. ");
INSERT INTO cakENT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Y ri Jesús jari' xbij: Man jun vinük chupan ri tiempo re' ri ruyo'on ta ránima riq'uin ri Dios. Xa conojel xa ye satznük. ¿Ninuc rix que yin chi jumul nquic'uje' iviq'uin, y chi jumul nc'atzinej que nyixincoch'? Tac'ama-pe ri ac'ajol chere', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Y tok ri ala' xapon-apu riq'uin ri Jesús, ri itzel espíritu riq'uin ruchuk'a' xuyiquiya' ri ala' y xutorij pan ulef. Ri Jesús xuch'olij c'a ri itzel espíritu, richin que tel-e riq'uin ri ala'. Y ri Jesús xucol ri ala' ri' chuvüch ri itzel espíritu, y xujüch-e chin ri rutata'. ");
INSERT INTO cakENT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Y conojel c'a ri vinük xsatz quic'u'x tok xk'alajin que ri Dios juis vi nim. Y tok ri vinük nyetzijon c'a chiquivüch pari' ri ala' ri xuc'achojrisaj ri Jesús, ri Jesús xbij cheque ri rachibila': ");
INSERT INTO cakENT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Tivac'axaj c'a jabel ri tzij re', y man timestaj c'a: Yin ri xinalüx chi'icojol, nquijach pa quik'a' ri vinük, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Y ja ri tzij re' man xk'ax ta cheque ri achibila', roma evan chiquivüch. Y nquixbij c'a qui' nquic'utuj chin ri Jesús achique ri xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Y ri rachibila' ri Jesús xquich'ojila' chiquivüch ri achique cheque rije' ri más nim ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero ri Jesús retaman c'a achique nyetajin chunuquic pa tak cánima ri rachibila'. Romari' rija' xberuc'ama-pe jun vit ac'ual, y xupaba' riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Y xbij cheque ri rachibila': Ri yacayon vichin pa ránima y riq'uin quicot nuc'ul jun ac'ual, jun ri cachi'el re', man xe tüj nuc'ul ri ac'ual, xa nquiruc'ul yin chuka'. Y ri nc'ulun c'a vichin yin, nuc'ul c'a chuka' ri takayon-pe vichin. Ja ri ivachibil ri más man jun ruk'ij nitz'et rix, xa jari' ri más nim ruk'ij, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Y xpu'u c'a ri Juan xbij chin ri Jesús: Maestro, xbij chin. Roj katz'eton jun achi pan abi' rat nyerelesala' itzel tak espíritu. Pero roma xa man kachibil tüj, xkabij chin que man tubün chic quiri'. ");
INSERT INTO cakENT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Y ri Jesús xbij c'a chin ri Juan: Man tibij chic c'a quiri' chin. Roma ri man nye'etzelan tüj kichin, kachibil vi ki' quiq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Y tok xa nka-pe yan c'a ri k'ij que ri Jesús ntzolij chila' chicaj, rija' xbün-e ruvüch richin xbe pa tinamit Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Y yec'o chuka' ri xerutük-e nabey. Y ri xetak-e ri', xebe pa jun vit tinamit ri c'o pa ruch'ulef Samaria, richin xbequicanoj jun jay ape' nye'uxlan-vi ri Jesús y ri ye rachibilan-e. ");
INSERT INTO cakENT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ri vinük aj chiri' man xcajo' tüj xquic'ul ri Jesús, roma ri vinük ri' nquinabej que xa pa Jerusalén rutz'amon-vi-e bey. ");
INSERT INTO cakENT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tok ri achibila' quibini'an Jacobo y Juan nquinabej que man nc'ulux tüj coma ri vinük, xquibij chin ri Jesús: Ajaf, ¿najo' que nkac'utuj que tika-pe k'ak' chila' chicaj, richin nyeruq'uis ri vinük re'? Cachi'el xbün ri Elías, ri jun achi ri xk'alajrisan ri rutzij ri Dios ojer can, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Y ri Jesús xerutz'et y xeruch'olij. Y xbij c'a cheque: Rix ni man ivetaman tüj que rix richin ri Lok'olüj Espíritu ri nyerujo' conojel vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Roma yin ri xinalüx chi'icojol, man xinpu'u tüj chere' chuvüch ri ruch'ulef chiquicamsasic vinük, yin xa xinpu'u chiquicolic, xbij. Y ri Jesús y ri rachibila' xebe chic c'a pa jun vit tinamit. ");
INSERT INTO cakENT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Y tok rije' quitz'amon chic c'a bey, c'o c'a jun achi ri xbec'ulun-pe, y rija' xbij chin ri Jesús: Ajaf, yin ninjo' c'a ncatintzeklebej ape' na ri ncatapon-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Pero ri Jesús xbij chin ri achi: Ri utiva', c'o-vi quijul ape' nyec'uje-vi. Y quiri' chuka' ri ch'ipa' ri nyebe pa chicaj, c'o chuka' quisoc. Jac'a yin ri xinalüx chi'icojol, man jun c'a ape' nquinuxlan-vi, xbij chin ri achi ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Y ri Jesús xbij c'a chin jun chic achi: Quinatzeklebej. Pero ri achi ri' xbij: Ajaf, yin juis ninjo' nquibe chavij. Pero taya' c'a k'ij chuve que ninmuk na e ri nata', c'ateri' nquibe chavij. ");
INSERT INTO cakENT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pero ri Jesús xbij chin ri achi ri': Taya' can ri nanuc re' cheque ri vinük ri ye cachi'el ye camnük roma man nquitakej tüj ri Dios. Jac'a rat, te'atzijoj pari' tok ri vinük nye'oc pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Y c'o chic c'a jun ri xbin chin ri Jesús: Ajaf, yin ninjo' ncatintzeklebej. Pero nabey, taya' c'a k'ij chuve richin nquibech'o na can cheque ri nte-nata' y cheque ri ye voxpochel, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero ri Jesús xbij chin: Ri achi ri nuc'uan richin ri arado, richin nusamajij jun ulef, man utz tüj c'a que ntzu'un can chirij, roma man utz tüj ntel ri rusamaj. Y quiri' c'a chuka' ri vinük ri ntaken richin ri Dios, man utz tüj que nutz'eta' ri nyebanatüj can chirij. Roma si quiri' nbün, man c'uluman tüj que nsamüj pa rusamaj ri Dios y nyeruto' ta ri nye'oc pa ruk'a' ri Dios, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Y tok ye banatajnük chic c'a ronojel ri', ri Ajaf Jesús xerucha' c'a ch'aka chic achi'a' richin nyesamüj riq'uin. Rija' xerucha' ye setenta achi'a', richin xerutük-e chi caca'. Xerutük pa tak tinamit y pa ch'aka chic lugar ape' napon-vi rija'. ");
INSERT INTO cakENT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Y ri Jesús xbij c'a cheque ri achi'a' ri xerucha': Ketzij vi que ri samaj richin ntzijos ri rutzij ri Dios, juis nim. Jac'a ri samajela' man ye q'uiy tüj. Xa ye ca'i-oxi' oc. Romari' tic'utuj c'a chin ri Rajaf ri samaj, que querutaka-pe más samajela' chiquicojol ri vinük ri nc'atzin richin ncac'axaj ri rutzij. ");
INSERT INTO cakENT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Y vocomi quixbiyin c'a. Ivetaman c'a ri' que rix xa cachi'el tak ovejas ri nyixintük-e chiquicojol ri vinük ye cachi'el utiva'. ");
INSERT INTO cakENT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Y man tic'uaj c'a morral, nixta man tic'uaj tumin, y man tic'uaj chuka' jun chic c'ulaj xajab. Nixta chuka' man quixpatüj pa tak bey richin niya' rutzij quivüch vinük. Xa choj quixbiyin c'a ape' nc'atzinej que nyixapon-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Y tok nyixapon c'a pa jun jay, ri nabey nc'atzinej que nibün, ja ri niya' rutzij quivüch. Y nibij c'a cheque: Ja ta c'a ri uxlanen richin ri Dios ri nc'uje' iviq'uin chupan ri jay re'. ");
INSERT INTO cakENT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Y si chiri' chupan ri jay ri', ri vinük riq'uin quicot nyixquic'ul-vi richin ncac'axaj ri rutzij ri Dios, ri uxlanen richin ri Dios nc'uje-vi quiq'uin. Jac'a si ri vinük xa man jabel tüj nyixquic'ul richin ncac'axaj ri rutzij ri Dios, ri uxlanen man c'a nc'uje' tüj can quiq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Rix quixc'uje' c'a ka chupan ri jay ape' nyixapon-vi y jabel ic'ulic nquibün, tic'uxu' y titija' ri nquispaj chive. Roma ri samajel c'uluman-vi que ntojox roma ri samaj ri nbün. Y man tijalala' c'a ri jay ri ape' nyixc'uje-vi. Xa ape' nyixapon-vi pa nabey, chiri' nyixc'uje-vi-ka. ");
INSERT INTO cakENT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Y quiri' chuka' tibana' tok nyixapon achique na tinamit y jabel ic'ulic nban. Tic'uxu' c'a ronojel ri nsipüs chive. ");
INSERT INTO cakENT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Que'ic'achojrisala' c'a chuka' ri yava'i' ri yec'o chiri', y tibij c'a cheque: Ri k'ij richin que rix nyixoc pa ruk'a' ri Dios, xa nakaj chic c'o-vi-pe chive. ");
INSERT INTO cakENT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero ja si nyixapon pa jun tinamit ri xa man utz tüj ic'ulic nban, quixel c'a e pa tak bey richin ri tinamit y tibij c'a cheque ri vinük: ");
INSERT INTO cakENT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ri pokolaj richin ri tinamit re' ri c'o-e pa kakün, nkatotaj can chivüch, richin quiri' tivetamaj que man utz tüj ri xibün que man xojic'ul tüj jabel. Y tivetamaj can chuka' que ri k'ij richin que ri vinük nye'oc pa ruk'a' ri Dios nakaj chic c'o-vi-pe, y rix xsuj c'a chive, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Y ri Jesús xbij-e chuka' cheque: Tok ri Dios nuya-pe ri ru-castigo, ri vinük quichin ri tinamit ri man nquic'ul tüj jabel ri rutzij ri Dios ri nibij rix cheque, más q'uiy c'a ri castigo ri nuya' pa quivi' rije' que chuvüch ri castigo ri nuya' pa quivi' ri aj-Sodoma ojer can tiempo. ");
INSERT INTO cakENT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Romari' juya' quivüch ri yec'o pa tinamit Corazín, y chuka' juya' quivüch ri yec'o pa tinamit Betsaida, roma juis q'uiy milagros xeban chiquivüch y man nquitakej tüj ri rutzij ri Dios. Roma xa ta ja pa tinamit Tiro y Sidón xeban-vi ri milagros re', ri vinük aj chiri' xtzolij ta yan pe quic'u'x riq'uin ri Dios, y quicusalon ta chic quitziek richin bis, y quiyolon ta chaj chiquij, richin quiri' nk'alajin que nyebison roma juis ri quimac ri ye quibanalun. ");
INSERT INTO cakENT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero chupan ri k'ij tok nbanatüj ri juicio, ja ri yec'o pa tinamit Corazín y ri yec'o pa tinamit Betsaida ri más castigo nka-ka pa quivi', que chiquivüch ri aj-Tiro y aj-Sidón. ");
INSERT INTO cakENT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y ri yec'o pa tinamit Capernaum nquinuc que nyebe chila' chicaj riq'uin ri Dios y juis nimirsüs quik'ij. Pero xa man quiri' tüj. Xa nkasüs quik'ij, roma xa c'a chupan ri lugar ri richin ri pokonül nyebetzak-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Y achique c'a vinük ri nyixruc'ul jabel richin nrac'axaj ri rutzij ri Dios, ja yin chuka' ri nquiruc'ul. Y ri achique c'a chuka' ri nyixetzelan roma ri rutzij ri Dios, ja chuka' yin ri nquiretzelaj. Y ri nyetzelan vichin yin, ja ri Dios chuka' ri takayon-pe vichin ri nretzelaj, xbij-e c'a ri Jesús cheque ri setenta achi'a' ri xerucha'. ");
INSERT INTO cakENT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Y tok xetzolij c'a pe ri setenta achi'a' ri' chin ri samaj ri bin-e cheque y xeka-pe riq'uin ri Jesús, juis nyequicot, y xquibij c'a chin: Ajaf, ri itzel tak espíritu xetaken chuka' cheke tok pan abi' rat xojch'o-vi cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Y ri Jesús xbij cheque: Ja', ketzij ri nibij. Roma yin xintz'et que ri Satanás xuna' yan que xch'acatüj, roma cachi'el nbün ri coyopa' ri chicaj, quiri' xbün rija' tok xtzak-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yin nuyo'on na vi nuchuk'a' chive richin que nyixch'acon chirij ri ruchuk'a' ri itzel-vinük, y chuka' richin que stape' (aunque) nye'ipalibela' ta cumütz y sna'j ri nyeruya' pan ibey, man jun nic'ulachij pa ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero rix man quixquicot xaxe roma ri itzel tak espíritu nyixquitakej. Más quixquicot pa tak ivánima roma tz'iban ri ibi' chila' chicaj riq'uin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Y chupan c'a ri misma hora ri', ri Lok'olüj Espíritu juis quicot xuya' pa ránima ri Jesús. Y ri Jesús xbij: Matiox ninya' chave Nata' Dios, rat ri Rajaf ri caj y ri ruch'ulef, roma man xak'alajrisaj tüj ri utzilüj atzij chiquivüch ri vinük ri nquina' que juis q'uiy quetaman. Xa ja chiquivüch ri vinük ri manak más quetaman, xa chiquivüch rije' xak'alajrisaj-vi ri utzilüj atzij re'. Quiri' vi c'a Nata' Dios, roma jari' ri arayibül rat, xbij ri Jesús pa ru-oración. ");
INSERT INTO cakENT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Y c'ateri' rija' xbij c'a: Ri Nata' Dios ronojel c'a ruyo'on-pe pa nuk'a'. Y man jun chic c'a etamayon yin achique yin, xaxe ri Nata' ri etamayon. Y man jun chuka' etamayon achique ri Nata', xaxe yin ri Ruc'ajol, y ri vinük achique chok chin nrajo' nink'alajrisaj-vi yin, nretamaj achique c'a ri Nata'. ");
INSERT INTO cakENT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Y c'ateri' ri Jesús xerutz'et ri rachibila' y xaxe cheque rije' xbij-vi: Jabel iquicot rix, roma ri nyixtajin nitz'et riq'uin ri runak' tak ivüch. Y chuka' jabel quiquicot ri ch'aka chic vinük ri nyetz'eton ronojel re'. ");
INSERT INTO cakENT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Y ninbij c'a chive, que ye q'uiy ri achi'a' xek'alajrisan ri tzij ri xbix cheque roma ri Dios y ri reyes ri xec'uje' ojer can, juis xcajo' que xquitz'et ta ri nitz'et rix vocomi, y man xquitz'et tüj. Xcajo' ta chuka' xcac'axaj ri nivac'axaj rix vocomi, y man xcac'axaj tüj chuka', xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Y c'o c'a jun etamanel chin ri ley ri xuya' ri Dios richin ri Moisés xbecatüj-pe y xbech'o chin ri Jesús, roma nrajo' nutij ri Jesús. Maestro, xbij c'a chin. ¿Achique nc'atzin richin ninbün yin richin quiri' ninvichinaj ri c'aslen ri man nq'uis tüj? xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ri Jesús xbij chin: ¿Achique c'a ri nbij chupan ri ley ri xuya' ri Dios chin ri Moisés? ¿Y achique nk'ax chave rat? ");
INSERT INTO cakENT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Y ri etamanel chin ri ley ri xuya' ri Dios richin ri Moisés xbij chin ri Jesús: Ri ley nbij que tajo' ri Dios ri Avajaf. Tajo' riq'uin ronojel avánima. Tajo' chupan ri ronojel ri ac'aslen, riq'uin ronojel avuchuk'a', y riq'uin chuka' ri anojibül. Y cachi'el najo-ka-avi' rat, quiri' c'a chuka' que'ajo' ri ch'aka chic. ");
INSERT INTO cakENT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Y jari' tok ri Jesús xbij chin ri etamanel chin ri ley ri xuya' ri Dios richin ri Moisés: Ketzij ri xabij. Vocomi c'a, si nabün ronojel ri', navichinaj c'a ri c'aslen ri man nq'uis tüj, xbij ri Jesús chin. ");
INSERT INTO cakENT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero ri etamanel chin ri ley ri xuya' ri Dios richin ri Moisés ri' xrajo' que tik'alajin que c'o-vi ri nrajo' nretamaj. Romari' rija' xbün que cachi'el man k'axnük tüj chin ri achique c'a ri' ri ch'aka chic, ri c'uluman que nyerujo' cachi'el nrajo-ka-ri' rija'. Romari' xuc'utuj-apu chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Y ri Jesús jari' xutzijoj jun ejemplo chin ri etamanel chin ri ley ri xuya' ri Dios richin ri Moisés: C'o c'a jun achi ri elenük-pe pa tinamit Jerusalén y xulan-ka richin nbe-ka c'a pa tinamit Jericó. Pero ri achi ri' xebe'el-pe elek'oma' chirij pa bey, y ri elek'oma' ri' ronojel xquelek'aj-e chin. Hasta ri rutziek ri rucusan ri achi xquelesaj can chirij. Ri elek'oma' xebe na vi, pero nabey juis xquich'ey can. Ri achi xpune' c'a can chiri' pa bey cachi'el jun camnük. ");
INSERT INTO cakENT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Y c'o c'a jun sacerdote israelita ri petenük chuka' chupan ri bey ri'. Y tok ri sacerdote ri' xutz'et que punul ri achi chiri' pa bey, xa ja lojca'n ri jun ruchi-bey yan chic xc'o-apu. ");
INSERT INTO cakENT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Y quiri' chuka' jun achi levita, ri nyeto'on quichin ri sacerdotes pa racho ri Dios, petenük chuka' chupan ri bey ri'. Y tok ri levita ri' xapon chupan ri lugar ri', xutz'et chuka' ri achi, y cachi'el xbün ri sacerdote ojer can tiempo, quiri' chuka' xbün rija'. Xe' xutz'et ri achi punul pa bey, xa ja chuka' ri jun yan chic ruchi' ri bey xc'o-apu. ");
INSERT INTO cakENT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero c'o c'a jun achi aj-Samaria ri petenük chuka' chupan ri bey ri', y nc'atzinej c'a que nc'o riq'uin ri achi punul can pa bey, ri achi ch'ayon can coma elek'oma'. Y tok ri aj-Samaria xutz'et ri achi punul pa bey, juis xujoyovaj ruvüch roma ri rubanun. ");
INSERT INTO cakENT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Romari' ri aj-Samaria ri' xjel-apu riq'uin ri achi punul pa bey, xutz'et achique rubanun. Y xerak'omala' ri rusocotajic ri achi riq'uin aceite olivo y vino. Rija' xerupisla' c'a chuka' ri socotajic riq'uin c'ul. C'ateri' ri achi aj-Samaria, chirij ruquiej rija' mismo xuya-vi-pe ri achi socotajnük y xuc'ün-pe c'a pa jun posada. Y xuchajij c'a ri junak'a' ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pa ruca'n k'ij tok ri aj-Samaria nutz'om chic e ri rubey, rija' xrelesaj ba' tumin y xuya' can chin ri rajaf ri posada, y xbij chin: Tavilij y tavak'omaj ri jun achi re'. Y tok nquitzolij-pe, nintoj c'a chave ri ch'aka chic tumin ri nacusaj. ");
INSERT INTO cakENT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Roma c'a ri', ¿chavüch rat achique c'a cheque ri ye oxi' achi'a' ri cachi'el nrajo-ka-ri' rija', quiri' chuka' xrajo' ri achi ri xtzak pa quik'a' elek'oma'? xbij ri Jesús chin ri etamanel chin ri ley ri xuya' ri Dios richin ri Moisés. ");
INSERT INTO cakENT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Y ri etamanel chin ri ley ri xuya' ri Dios richin ri Moisés xbij: Ja ri achi ri xjoyovan ruvüch, xbij. Y ri Jesús xbij c'a chin ri etamanel chin ri ley ri xuya' ri Dios richin ri Moisés: Vocomi cabiyin c'a y tabana' cachi'el xbün ri achi aj-Samaria. ");
INSERT INTO cakENT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Y ri Jesús xutz'om chic c'a rubey y xapon pa jun vit tinamit. Y chiri' chupan ri vit tinamit ri' c'o c'a ri ixok rubini'an Marta, y ja rija' ri xc'ulun-apu richin ri Jesús pa racho. ");
INSERT INTO cakENT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ri ixok c'a ri' c'o c'a jun runimal rubini'an María. Y ri María ri' xtz'uye' c'a chirakün ka ri Jesús, richin quiri' nrac'axaj ri rutzij ri Dios ri nutzijoj ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Jac'a ri Marta xa man quiri' tüj xbün. Rija' c'o q'uiy ropis nbün pa racho. Roma c'a ri' ri Marta xapon riq'uin ri Jesús y xbij chin: Ajaf, ¿man natz'et tüj c'a que ri María nuyon yin ruyo'on can chuvüch ri opis? Tabij c'a chin que quiruto' ba'. ");
INSERT INTO cakENT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero ri Ajaf Jesús xbij chin: Marta, rat q'uiy ri nanuc, y satznük ac'u'x roma q'uiy ri nc'atzinej que nabün. ");
INSERT INTO cakENT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero xaxe c'a jun ri más nc'atzin y más utz, y jari' ri xucha' ri María. Y ri xucha' rija', man jun nrelesan chin. ");
INSERT INTO cakENT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Y jun bey c'a, ri Jesús c'o pa jun lugar, y nbün c'a orar. Y tok tanül chic ka, jun c'a cheque ri rachibila' xbij chin: Ajaf, nkujatijoj richin nkabün orar, cachi'el ri Juan Bautista xerutijoj ri rachibila' rija' richin nquibün orar. ");
INSERT INTO cakENT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Y jari' tok ri Jesús xbij cheque ri rachibila': Tok nibün c'a orar, tibana' c'a jun oración cachi'el re': Katata' Dios ratc'o chila' chicaj, nbanatüj ta c'a que conojel ta ri vinük nquiya' ta ak'ij, y man ta nquixolk'otij ri lok'olüj abi'. Y nka-pe ta yan c'a ri k'ij tok ja rat ri ncatoc ri Jun ri nbün mandar. Y xe ta c'a ri najo' rat que nkabün, xe ta c'a ri' ri nkabün, cachi'el nquibün ri yec'o aviq'uin chila' chicaj. ");
INSERT INTO cakENT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Y taya' c'a chuka' ri kavay ri nc'atzin cheke ronojel k'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Y cachi'el c'a nyekacuy conojel ri vinük ri nquibün itzel cheke, quiri' ta c'a nabün kiq'uin roj, nacuy ta c'a ri kamac ri nkabün chavüch. Y man taya' k'ij c'a que ri itzel nbün ta cheke que nkutzak pa mac. Nkujacolo' c'a chuvüch, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Y ri Jesús xbij c'a chuka' cheque ri rachibila': Si jun chive rix napon pa nic'aj-ak'a' pa jun jay ri etaman-vi ruvüch jabel, y nbij ta chin ri rajaf ri jay: Tabana' favor chuve ninjül ta oxi' avay. ");
INSERT INTO cakENT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Roma c'o jun nu-amigo ri lojc'an chic petenük-vi y xka-pe viq'uin yin, y yin man jun vüy ninchajij richin ninya-apu chin. Roma c'a ri' tabana' favor chuve, nabij-apu chin. ");
INSERT INTO cakENT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Y ri vinük ri ape' nac'utuj-apu ri vüy, pa ruvarabül c'a nch'o-pe chave y nbij c'a: Tabana' favor man quinaya' pa c'ayuf, roma ri ruchi-jay xa xintz'apij yan can y ri ac'uala' xa viq'uin yin nyevür-vi. Romari' man nquitiquer tüj nquicatüj-e richin que nquijacha' can chave ri najo'. ");
INSERT INTO cakENT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Y ri Jesús xbij c'a cheque ri rachibila': Ketzij vi ninbij chive, que ri vinük ri nc'utux-apu ri vüy chin, ncatüj-pe, pero man roma tüj ri juis ta ye amigos riq'uin ri nc'utun-apu ri vüy. Man quiri' tüj. Rija' ncatüj-pe y nyeruya-pe ronojel ri nc'atzin chin, richin que titane-apu chuc'utuxic. ");
INSERT INTO cakENT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Y yin ninbij c'a chive rix, xbij ri Jesús. Tibana' c'a cachi'el ri xbün ri achi ri xbec'utun vüy. Tic'utuj ri nc'atzin chive y ri Dios nuya-pe chive. Ticanoj y nivil ri nijo'. Tic'oj c'a apu ri ruchi-jay y njakox-pe chivüch. ");
INSERT INTO cakENT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Roma c'a ri', si riq'uin ronojel ivánima nic'utuj chin ri Dios, rija' nuya-vi-pe chive. Si rix nicanoj, nivil-vi. Y si rix nic'oj c'a apu ri ruchi' ri jay, njakox-vi-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Y rix ri rix tata'aj chic, ¿nyixtiquer comi niya' jun abüj pa ruk'a' jun ivalc'ual, tok ri ac'ual xa jun vüy nuc'utuj chive? ¿O niya' ta jun itzel cumütz pa ruk'a', tok ri ac'ual xa jun cür nrajo'? ");
INSERT INTO cakENT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O niya' ta chuka' jun sna'j pa ruk'a', tok ri ac'ual xa jun sakmolo' ri nuc'utuj chive? ");
INSERT INTO cakENT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Rix man nyixtiquer tüj nibün quiri' cheque ri ivalc'ual. Man riq'uin tüj rix que man ta utz ina'oj, pero chuka' man jun bey niya' jun cosa itzel. Rix ja ri utz tak cosas ri niya'. Ya voro chi comi ri aj-chicaj Itata'. Rija' nuya-vi c'a ri Lok'olüj Espíritu cheque ri nquic'utuj, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Y jun k'ij ri Jesús, c'o c'a jun achi riq'uin, mem rubanun pa ruk'a' jun itzel espíritu. Y tok ri Jesús xbij chin ri itzel espíritu que tel-e riq'uin ri achi ri', ri itzel espíritu xel na vi e, y ri achi ri c'unük mem xch'o jun bey chic. Y ri vinük ri xetz'eton, xe' xquica'yej tok xquitz'et. ");
INSERT INTO cakENT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero yec'o c'a chuka' cheque ri vinük xebin: Ri Jesús c'o ri Beelzebú riq'uin, ri cajaf ri itzel tak espíritu. Y ja ri Beelzebú ri nyo'on ruchuk'a' chin richin quiri' ntiquer nyerelesaj ri itzel tak espíritu. ");
INSERT INTO cakENT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Y yec'o c'a ch'aka chic vinük, ri xaxe richin nquitij ri Jesús xquibij c'a chin que tubana' c'a que c'o ri nbanatüj chupan ri caj, richin tuc'utu' que rija' ja vi ri Dios ri takayon-pe richin, xquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero ri Jesús retaman c'a ri nquinucula-ka ri achi'a' ri', romari' xbij cheque: Si ri vinük richin jun ruch'ulef man nyenucun tüj y ca'i' quivüch nquibün, npu'u oyoval chiquicojol. Y re' man utz tüj, roma nbün chin ri quiruch'ulef que ntzak. Y quiri' chuka' pa jun jay, si xa nyejalajo' chiquivüch y nyech'aratüj, man nquic'uaj tüj c'a chic qui' junan. ");
INSERT INTO cakENT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Y quiri' c'a chuka' ri itzel-vinük, man utz tüj que nbün-ka oyoval quiq'uin ri rusamajela'. Roma si quiri' nbün, ri rachibil ruyon nquiya' can y chanin ntzak rija'. Y yin quere' ninbij chive, roma rix nibij que yin c'o ri Beelzebú viq'uin y romari' tok nquitiquer nyenvelesaj ri itzel tak espíritu. ");
INSERT INTO cakENT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Rix quiri' ninuc chuvij yin, que c'o ri Beelzebú viq'uin romari' nquitiquer nyenvelesaj ri itzel tak espíritu, ¿pero achique c'a ninuc rix pa quivi' ri nyetzekleben ivichin? ¿Achique yo'on cuchuk'a' cheque rije' richin nyetiquer nyequelesaj itzel tak espíritu chuka'? Ja ri nyetzekleben ivichin ri nyek'alajrisan que xa man utz tüj ri nibij rix. ");
INSERT INTO cakENT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Y yin ja vi ri Dios ri yo'on-pe vuchuk'a' chuve richin nquitiquer nyenvelesaj ri itzel tak espíritu. Xa xka-pe yan c'a ri k'ij que conojel c'uluman que nquitakej rutzij ri Dios y nyec'uje' pa ruk'a' rija'. ");
INSERT INTO cakENT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Y tok c'o jun achi ri juis ruchuk'a', y c'o ronojel tobül ri nc'atzin chin, ri achi re' jabel vi nuchajij ri racho, y man jun ri nrelesan ta chin ri ruchajin. ");
INSERT INTO cakENT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero si tok nobos chic jun achi ri c'o más ruchuk'a' que chuvüch rija', nch'acatüj, y nelesüs ronojel ri tobül ri nucusaj ri ruyo'on ránima riq'uin. C'ateri' ri achi ri más c'o ruchuk'a' nutalula' c'a ronojel ri xrelesaj-e chin ri achi ri xuch'üc. ");
INSERT INTO cakENT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Y roma c'a ri', ri man viq'uin tüj yin nsamüj-vi, xa chuvij yin nsamüj-vi. Y ri achique ri man nto'on tüj vichin, xa jari' ri nyojon ronojel ri nyenbün yin. ");
INSERT INTO cakENT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Y tok c'o jun itzel espíritu ntel-e pa ránima jun vinük, ri itzel espíritu ri' nucanoj uxlanen pa tak lugar tz'iran-tz'iran. Y tok ri jun itzel espíritu ri' nuna' que man jun uxlanen nril, nunuc-ka: Más utz nquitzolij chic pa ránima ri vinük ri ape' xinel-vi-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Y tok ri jun itzel espíritu ri' ntzolij chic apu pa ránima ri vinük, nril c'a ri ránima ri vinük ri' cachi'el jun jay ri meson y chojmirsan can jabel. ");
INSERT INTO cakENT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Y c'ateri' ri itzel espíritu ri' nyeruc'ün c'a pe ye siete chic itzel tak espíritu ri más ye itzel, y conojel c'a ri' nye'oc pa ránima ri vinük. Y ri vinük achique chok q'uin nyec'uje-vi ri itzel tak espíritu ri', más c'ayuf nbün ri ruc'aslen que chuvüch ri xbün nabey. ");
INSERT INTO cakENT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Y tok ri Jesús ntajin c'a chubixic ri tzij ri' chiquivüch ri juis vinük ri quimolon-qui' riq'uin, jari' tok c'o c'a jun ixok chiri' chiquicojol, ri riq'uin ruchuk'a' xbech'o-pe, y xbij c'a: Ri te'ej ri xalan avichin chuvüch ri ruch'ulef y xaruq'uiytisaj riq'uin tz'umaj, jabel ruquicot, xbij ri ixok chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Y ri Jesús xbij: Más jabel quiquicot ri nye'ac'axan ri rutzij ri Dios y nquibün ronojel ri nbij ri rutzij rija', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Y tok ye juis c'a ri vinük ri nyetajin nquimol-apu-qui' chirij ri Jesús, xpu'u rija' xbij c'a cheque ri vinük ri': Ri vinük vocomi juis ye itzel y man yinquitakej tüj. Romari' tok ncajo' que yin ninbün jun milagro chiquivüch richin yinquitakej. Pero man ja tüj ri ncajo' rije' ri nbanatüj. Man quiri' tüj. Xaxe ri xbanatüj riq'uin ri jun achi ri xubini'aj Jonás, jun achi ri xk'alajrisan ri xbix chin roma ri Dios ojer can, xaxe ri' ri retal chuka' cheque rije'. ");
INSERT INTO cakENT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ri xbanatüj riq'uin ri Jonás xuc'ut chiquivüch ri vinük ri xec'uje' ojer can chupan ri tinamit Nínive, que ja ri Dios takayon-pe richin. Y quiri' c'a chuka' yin ri xinalüx chi'icojol, ri ninc'ulachij yin nucusüs richin jun retal chiquivüch ri vinük vocomi. ");
INSERT INTO cakENT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Y tok napon c'a ri k'ij richin juicio, nban c'a juzgar chuka' pa quivi' ri vinük ri yec'o vocomi. Y nc'astüj c'a pe ri jun reina ri aj-Sabá y nbij c'a que man utz tüj xquibün ri vinük ri yec'o vocomi, que man nquitakej tüj. Roma tok xc'ase' ri jun reina ri', juis nüj xbiyin richin quiri' xrac'axaj-pe ri etamabül richin ri jun rey richin ri Israel, ri rubini'an Salomón. Y vocomi yinc'o yin ri más nuk'ij chuvüch ri rey Salomón ri xc'uje' ojer can, y xa man yinquitakej tüj ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Y tok napon c'a chuka' ri k'ij richin juicio pa quivi' ri vinük ri yec'o vocomi, nyec'astüj c'a pe ri vinük aj-Nínive. Ri vinük ri' nquibij c'a que man utz tüj xquibün ri vinük ri yec'o vocomi, roma man xinquitakej tüj. Y ri vinük ri xec'uje' pa tinamit Nínive ri ojer can, xe xcac'axaj ri rutzij ri Dios ri xutzijoj ri Jonás cheque, jari' xquitzolij-pe quic'u'x riq'uin ri Dios. Y vocomi yinc'o yin ri más nuk'ij chuvüch ri Jonás, y xa man yinquitakej tüj ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Y man jun vinük ri nutzij ta jun k'ak' y c'ateri' nuya' ape' ri man nk'alajin tüj pe ri k'ak', o nuya' ta chuxe' jun cajón. Man jun nbanun quiri'. Ri vinük ri nutzij jun k'ak', nutzekeba', richin quiri' sük nbün cheque ri nye'oc pa jay. ");
INSERT INTO cakENT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Y ri runak'-avüch chuka' nyec'atzin chave cachi'el ri k'ak'. Roma si ri runak'-avüch ye utz, rat ratc'o pa jun sük. Pero si ri runak'-avüch man ye utz tüj, rat ratc'o pa jun k'eku'n. ");
INSERT INTO cakENT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Roma c'a ri' tachajij ri ac'aslen, richin quiri' ri sük ri ruyo'on ri Dios pan avánima man tijalatüj, y nyek'alajin ta pe que xa pa k'eku'n chic ratc'o-vi. Man tabün quiri'. ");
INSERT INTO cakENT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Roma si ratc'o pa jun sük, man jun c'a vit retal tüj ri k'eku'n aviq'uin, y quiri' ncatzu'un-vi jabel. Re' junan vi c'a riq'uin tok tzijon jun k'ak' richin sük y jabel sük nk'alajin richin nbün sük chave. ");
INSERT INTO cakENT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Y tok ri Jesús xtane' c'a ka riq'uin ntzijon chiquivüch ri vinük, c'o c'a jun cheque ri achi'a' fariseos xbij chin ri Jesús que tubana' favor nbe ta ba' pa racho, richin nuc'ux jun ruvay. Y ri Jesús xbe na vi. Rija' xapon, y xbetz'uye' chuvüch mesa. ");
INSERT INTO cakENT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Y ri achi fariseo, xe' xuca'yej ri Jesús, roma xtz'uye-apu chuvüch mesa y man xuch'üj tüj ruk'a' cachi'el rubanic ruch'ajic quik'a' ri chilaben cheque conojel. ");
INSERT INTO cakENT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Y ri Ajaf Jesús xutz'et ri nunuc ri fariseo ri xoyon richin, y romari' xbij chin: Rix fariseos xa rix cachi'el ri lük ri jabel ch'ajch'oj rij y ri rupan xa tz'il-tz'il. Rix nic'ut c'a chiquivüch ri vinük que utz ri inojibül, pero pa tak ivánima man quiri' tüj, roma xa nojnük riq'uin elek', y nojnük riq'uin itzel. ");
INSERT INTO cakENT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Man jun bey rix tontos. ¿Man ivetaman tüj c'a que ri xbanun ri kach'acul, xbün chuka' pe jun kánima? ");
INSERT INTO cakENT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Roma c'a ri' rix xa ja ri ivánima tich'ajch'ojrisaj, richin quiri' tok ch'ajch'ojirnük chic ri ivánima, nalüx c'a pe iviq'uin que nye'ito' chuka' ri manak ruchajin, y nyixch'ajch'ojir c'a. ");
INSERT INTO cakENT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Juya' ivüch rix fariseos! roma rix xaxe ri jubulüj tak k'ayis, ri ruda y ronojel quivüch ichaj ri ninuc. Roma nye'ivelesala' pa lajuj, y jun c'a chin ri' ri niya' chin ri Dios. Xaxe oc ri' ri nye'inuc. Y xa man nijo' tüj ri Dios, ni man rix choj tüj chuka' quiq'uin ri vinük. Y xa ja ta ri' ri más c'uluman ibanun, ja ta c'a ri nyixtajin chubanic. ");
INSERT INTO cakENT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Juya' ivüch rix fariseos! roma ja oc ri nabey tak ch'acüt nye'icanola' pa tak jay ape' ntzijos-vi ri rutzij ri Dios, richin quiri' nbix que juis ik'ij. Y juis chuka' nka' chivüch ri quiyo'on rutzij ivüch pa bey ape' nyequimolo-vi-qui' ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Juya' ivüch chuka' rix etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y rix fariseos ri xa ca'i' ipalüj! roma xa rix cachi'el ri ulef ri c'o pari' jun camnük, man nk'alajin tüj, y ri vinük choj chic nyec'o-e pari'. Man quenaben tüj, y romari' man ye ch'ajch'oj tüj chic. Y rix quiri' ibanun, nibün cheque ri vinük que man ch'ajch'oj tüj chic chuvüch ri Dios roma ri itijonic y ic'aslen rix, y man nquinabej tüj, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pero jun c'a cheque ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés xbij chin ri Jesús: Maestro, xbij rija'. Tok rat nabij quiri', man xe tüj chic ri fariseos nye'ilon, xa nkujilon chuka' roj. ");
INSERT INTO cakENT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Y ri Jesús xbij c'a chin ri etamanel chin ri ley ri xuya' ri Dios richin ri Moisés ri': ¡Juya' ivüch chuka' rix ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés! roma tok nye'itijoj ri vinük, niya' nimalüj tak aka'n chiquij, ri juis c'ayuf quic'uaxic. Ri aka'n ri' xaxe c'a chiquij ri vinük niya-vi y rix man nisiloj tüj jun vit ruvi-ik'a' richin nitz'om ta apu ri aka'n ri nibij que nc'atzinej que nquic'uaj ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Juya' ivüch rix etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés! roma ja rix ri nyixchojmirsan ri tz'ak ape' ye mukul-vi ri achi'a' ri xek'alajrisan rutzij ri Dios ojer can, y rije' xa ja ri ixquin-imama' can ri xecamsan quichin. ");
INSERT INTO cakENT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Vocomi nk'alajin c'a que rix nka' chivüch ri itzel ri xequibanala' ri ixquin-imama' ri ojer can, roma ja rije' ri xecamsan ri achi'a' ri ye richin ri Dios, y rix nye'ichojmirsala' ri tz'ak ape' ye mukul-vi can. ");
INSERT INTO cakENT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Y roma chuka' ri' ri Dios, roma ri retaman, xbij: Nyentük c'a achi'a' quiq'uin ri nuvinak, achi'a' ri nyek'alajrisan ri tzij ri ninbij cheque, y nyentük chuka' apóstoles chiquicojol. Pero ri vinük yec'o c'a ri nyequicamsaj, y yec'o ri nquibün cheque richin nquic'usaj pokonül, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Romari', xbij ri Jesús, Ri Dios pa quivi' ri vinük ri yec'o vocomi nuya-vi ri quicamic ri achi'a' ri'. Y ntz'ucutuj-pe c'a pa rutz'uquic pe ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ntz'ucutuj-pe riq'uin ri rucamic ri achi xubini'aj Abel c'a riq'uin ri rucamic ri achi xubini'aj Zacarías. Y jari' ri xcamsüs chunakaj ri altar ri c'o chuvüch-racho ri Dios. Roma c'a ri' ninbij chive, que ri Dios pa quivi' ri vinük ri yec'o vocomi nuya-vi ri quicamic ri achi'a' ye rusamajela' rija'. ");
INSERT INTO cakENT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Juya' ivüch rix etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés! roma rix ivetaman achique rubanic richin que jun vinük ntoc richin ri Dios, pero rix man rix c'unük tüj richin ri Dios y chuka' nye'ik'üt ri vinük ri ncajo' nye'oc richin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tok ri Jesús xbij ronojel ri', ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri achi'a' fariseos chuka', juis xcatüj coyoval chirij rija'. Y roma c'a ri' rije' ronojel c'a nquic'utula-apu chin ri Jesús xaxe richin nquinük. ");
INSERT INTO cakENT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri achi'a' fariseos, man nquiya' tüj c'a can ba' ri Jesús, c'o ta ncajo' que ncac'axaj que rija' c'o ta jun tzij ri man c'uluman tüj ri nbij y ntzak ta pa quik'a', richin que nquisujuj. Pero ri Jesús ruyon c'a pa rubeyal ri nyerubij. ");
INSERT INTO cakENT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Y ri vinük xemolotüj c'a apu. Pa mil vinük ri xquimol-apu-qui' chiri'. Romari' nquitopila' chic qui'. Y ri Jesús xutz'om c'a tzij quiq'uin ri rachibila' nabey, y xbij c'a cheque: Tichajij-ivi' chuvüch ri levadura quichin ri achi'a' fariseos. Ri levadura ri quichin ri achi'a' fariseos ja ri ca'i' quipalüj. ");
INSERT INTO cakENT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Y ronojel ri man k'alajrisan tüj nk'alajin-pe. Y ronojel ri tz'apül can rij, ntel c'a pe pa sük, y conojel c'a nye'etaman, y conojel chuka' nyetz'eton. ");
INSERT INTO cakENT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Roma c'a ri' rix, ronojel ri ibilon pa tak evatül, ronojel nbek'alajin-pe. Y ronojel c'a ri ibilon pa tak ixiquin pa jay, nbetamüx na coma ri vinük y nbesiq'uin chubixic pa tak ruvi' cheque ri jay. ");
INSERT INTO cakENT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Y roma chuka' ri' ninbij chive rix ri rix nu-amigos: Man tixbij-ivi' chiquivüch ri xaxe oc ri ch'acul ri nyetiquer nquicamsaj, y tok quicamsan chic ri ch'acul man jun chic achique nyetiquer ta nquibün. ");
INSERT INTO cakENT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Y ninbij c'a chive achique chok chuvüch c'uluman que nixbij-ivi': Tixbij-ivi' chuvüch ri jun ri ntiquer nyixrutük pa k'ak', y man xe tüj ri ch'acul nucamsaj. Tixbij c'a ivi' chuvüch ri nbanun quiri'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Y rix chuka' jabel ivetaman que tok nye'ilok' vo'o' vit tak ch'ipa', xaxe ca'i' tak centavos cajil. Y man riq'uin tüj que ri vit tak ch'ipa' ri' man jun oc ri cajil, ri Dios man jun bey nyerumestaj ta can. ");
INSERT INTO cakENT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Y ya voro chi comi rix. Rix ajlan-vi ri rusmal tak ivi'. Ri Dios man jun bey nyixrumestaj ta can. Ri Dios juis nyixrujo'. Más nyixrujo' que chiquivüch ri vit tak ch'ipa'. Roma c'a ri' man tixbij-ivi'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Chuka' ninbij c'a chive, que achique na vinük ri nuk'alajrisaj-ri' que vichin yin, yin chuka' ri xinalüx chi'icojol, nink'alajrisaj que rija' vichin chic yin. Y ri tzij re' chiquivüch ri ru-ángeles ri Dios ninbij-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jac'a ri vinük ri man nuk'alajrisaj tüj ri' que vichin yin, yin c'a chuka' man nink'alajrisaj tüj ri rubi' chiquivüch ri ru-ángeles ri Dios, roma man vichin tüj yin ri vinük ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Y achique na c'a vinük ri nyok'on vichin yin ri xinalüx chi'icojol, ncuyutüj c'a rumac. Jac'a ri nyok'on richin ri Lok'olüj Espíritu, man ncuyutüj tüj c'a rumac. ");
INSERT INTO cakENT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Y si ja yin ri nquinitakej, romari' nyixuc'u'üx chiquivüch ri más nimalüj achi'a' pa tak jay ape' ntzijos-vi ri rutzij ri Dios, y romari' chuka' nyixuc'u'üx chiquivüch autoridades pa tak juzgado, man tinuc juis achique ri nibij cheque y achique rubanic tzij nicusaj richin nyixch'o chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Roma tok nc'atzinej que nyixch'o-apu, ja ri Lok'olüj Espíritu ri nyo'on tzij chive richin nibij-apu, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Y chiri' chiquicojol ri juis vinük ri quimolon-apu-qui', c'o c'a jun ri xch'o-apu y xbij chin ri Jesús: Maestro, xbij c'a chin. Tabana' favor cach'o riq'uin ri nunimal y tabij chin que tuya-pe ri herencia ri rubanun-ka rija' chin que richin. ");
INSERT INTO cakENT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero ri Jesús xbij chin ri achi: ¿Banun comi chuve yin que yin jun juez pan ivi' rix y chuka' yin jun jachoy-herencia chi'icojol? ");
INSERT INTO cakENT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Y ri Jesús xch'o chic c'a cheque ri vinük y xbij: Titz'eta' c'a ka ivi' jabel richin nichajij ri ic'aslen, richin que man tipu'u rayinic pan ivánima chirij ronojel ruvüch cosas. Roma stape' (aunque) juis q'uiy rubeyomal jun vinük, man ja tüj ri' ri nyo'on ruc'aslen. ");
INSERT INTO cakENT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Y jari' tok ri Jesús xutz'om rubixic jun ejemplo, y xbij: C'o c'a jun achi beyon, ri juis ulef ruchajin. Y jun bey c'a, juis cosecha ri xumol. ");
INSERT INTO cakENT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Roma c'a ri' ri beyon ri' xunuc-ka pa ránima: ¿Achique ta jun ninbün richin quiri' ninyüc ronojel ri nu-cosecha? Roma man jun chic ape' ninya-vi ri ch'aka chic. ");
INSERT INTO cakENT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Y tok xnucutüj chin, xbij: Más utz nyentaluj na e ri cocoj tak cabül, y nyenbün chic ch'aka más nimak'. Y chupan ri cabül re' nyenyacala-vi ri nyenchajin y ronojel ri nu-cosecha chuka'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Y ninbij c'a chin ri vánima: Vánima, vocomi juis q'uiy a-cosas ri ayacon, y q'uiy juna' man natij tüj vayjül. Caquicot c'a, catuxlan, cava' y tatij ya', xbij ri beyon chin ri ránima. ");
INSERT INTO cakENT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero ri Dios xbij chin ri beyon ri': Tonto chi achi, chupan ri ak'a' re' ninvoyoj-e ri avánima, ¿y ronojel ri abeyomal ri xayüc, achique c'a ri nchinan can? ");
INSERT INTO cakENT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Quiri' c'a ri vinük ri nmolon beyomül richin ri ruch'ulef, y xa manak rubeyomal ri Dios riq'uin ránima. ");
INSERT INTO cakENT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Y ri Jesús xbij c'a cheque ri rachibila': Ninbij c'a chive, que man titz'om pena roma ri achique nc'atzin chive k'ij-k'ij, ri ape' nivil-vi ivay y ri ape' nic'ün-vi itziek. ");
INSERT INTO cakENT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Roma si ri Dios xuya-pe ic'aslen chuvüch ri ruch'ulef, nuya-pe chuka' ri ivay richin c'o ic'aslen y ri itziek richin nitz'apij-ivi'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Que'itz'eta' na pe' ri ch'ipa' quibini'an c'uch. Ri ch'ipa' ri' man nyetico'n tüj, y romari' manak cosecha nquelesaj juna-juna', nixta manak chuka' quicabal richin quiyacon ta quijal. Pero man riq'uin tüj ri' rije' nyeva', roma ja ri Dios ri nyo'on quivay. Ya voro chi comi rix man ta nuya' ivay ri Dios, tok rix más c'o ivakalen que chiquivüch ri ch'ipa'. Xa roma c'a ri' man más tinuc ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿C'o ta comi jun chive rix ri ntiquer ta nbanun que nq'uiy chic ba', roma nutz'om pena chubanic? Man jun. ");
INSERT INTO cakENT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Y si xa jun samaj ri juis co'ol cachi'el re' man nyixtiquer tüj nibün, ¿achique c'a roma tok nitz'om pena richin nivil ivay, itziek y ri ch'aka chic ri nyec'atzin chive? ");
INSERT INTO cakENT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Que'itz'eta' na pe' ri cotz'i'j quibini'an lirio. Que'itz'eta' na pe' tok nyeq'uiy. Rije' man nyesamüj tüj, ni man nyebatz'in tüj, richin quiri' nquibanala' ta quitziek jabel oc. Man jun bey. Y c'o c'a jun rey richin ri Israel xc'uje' ojer can ri rubini'an Salomón. Rija' ruyon jabel tak tziük ri xerucusaj, pero man jun bey xc'uje' ta jun rutziek cachi'el titzu'un jun cotz'i'j. ");
INSERT INTO cakENT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Roma ri cotz'i'j jari' ri tziük ri nuya' ri Dios cheque ri k'ayis. Y stape' (aunque) ri k'ayis man ta nlayuj, roma jun k'ij jabel rubanun, jun chic k'ij nchaki'j-ka y c'ateri' ntorix pa k'ak'. Man riq'uin tüj ri' ri Dios nuvek jabel. Y si ri Dios nuvek jabel ri k'ayis, ¿achique c'a roma rix man iyo'on tüj ivánima riq'uin que nuya' itziek? ");
INSERT INTO cakENT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Romari' rix man titz'om pena nicanola' ri ivay y iya'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Roma conojel vinük quere' nquibün. Pero rix c'o jun Itata' ri retaman chic que jare' ri nc'atzin chive. ");
INSERT INTO cakENT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Romari' ri c'uluman que nibün rix ja ri tiya-ivi' chuxe' rutzij ri Dios. Y si nibün c'a quiri', ri Dios nuya' jun ic'aslen jabel, y nuya' chuka' ri nc'atzin chive. ");
INSERT INTO cakENT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Roma c'a ri' man tixbij-ivi' rix ri nyixtzekleben vichin, roma stape' (aunque) xa rix ba' oc, rurayibül vi c'a ri aj-chicaj Itata' que nyixc'uje' pa ruk'a' rija'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tic'ayila' c'a ri ichajin y tiyala' cheque ri vinük ri man jun quichajin. Si quiri' c'a nibün, nc'uje' jun iyacbal chila' chicaj ri man jun bey nk'ey, y nc'uje' chuka' ibeyomal ri man jun bey nq'uis. Chila' chicaj man jun elek'on, nixta jun chuka' jut ri nchicopirsan. ");
INSERT INTO cakENT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Roma ri ivánima nc'uje' ape' c'o-vi ri ibeyomal, roma jari' ri nitzeklebej-e. ");
INSERT INTO cakENT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tichajij c'a ri ic'aslen, y chi jumul tic'at ri i-candil. ");
INSERT INTO cakENT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tibana' c'a cachi'el nquibün ri samajela' pa jun jay. Ri samajela' coyoben que ntzolij-pe ri cajaf benük pa jun c'ulubic, richin quiri' tok nka-pe y noyon-apu, jari' nquijük ri ruchi-jay chuvüch. ");
INSERT INTO cakENT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Y jabel c'a quiquicot ri samajela' ri ye c'üs tok xka-pe ri cajaf. Y ketzij ninbij chive, que ri cajaf mismo nbanun ruc'ojlen ronojel richin nyerutz'uyuba' ri rusamajela' chuvüch mesa y nuya-apu ronojel cosas richin nc'ux chiquivüch. Nyerilij-apu jabel roma juis nquicot que c'a coyoben-apu ri hora ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Y si ri cajaf ri samajela' ri' nka-pe pa nic'aj-ak'a' o ja tok nsaker yan cumaj, ri samajela' ri' jabel quiquicot roma c'a ye c'üs chiroyobexic ri cajaf ri hora ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Y rix ivetaman, que si ta jun rajaf-jay retaman jampe' napon jun elek'on pa racho, ri rajaf-jay ri' nc'ase' richin nuchajij ri racho, y man nuya' tüj k'ij que ri elek'on nujük-apu ri racho richin nelek'-e. ");
INSERT INTO cakENT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Romari' rix chi jumul c'a quinivoyobej-apu, roma ja tok man ja tüj, man ja tüj ri' ninuc, jari' tok nquinka-pe yin ri xinalüx chi'icojol, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jari' tok ri Pedro xbij chin ri Jesús: Ajaf, ¿rat xatzijoj ri ejemplo re' xaxe cheke roj avachibila', o xatzijoj cheque conojel vinük? ");
INSERT INTO cakENT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Y ri Ajaf Jesús xbij: Yin nquich'o cheque conojel ri ye cachi'el ri samajel pa jun jay, ri nban chin roma ri rajaf que nc'uje' pa quivi' ri ye aj pa racho, richin que nuya' quivay y richin que nuya' ronojel ri nc'atzin cheque tok napon ri hora. Y si ri samajel ri' nbün ta ri bin can chin y utz nbün chin ronojel ri samaj, ¿achique ta comi nbün? ");
INSERT INTO cakENT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Rija' nbün-vi ri samaj ri bin can chin, y romari' nquicot ránima tok nbelitüj-ka roma ri rajaf y ntajin chubanic ri samaj. ");
INSERT INTO cakENT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ketzij c'a ninbij chive que ri rajaf ri samajel ri' nuya' pari' ronojel ri ruchajin, richin que nuchajij. ");
INSERT INTO cakENT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Jac'a si ri samajel ri' nunuc-ka pa ránima: Ri vajaf ri' xa c'a man jani nka-pe, nbij ta ka. Y nutz'om ta c'a nyeruch'ey ri ch'aka chic samajela' achi'a' y ixoki', y xaxe ta va'in nbün, y nutz'om rutijic ya' richin nk'abür, y man jun tüj chic samaj nbün, ");
INSERT INTO cakENT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","jac'a ri k'ij y ri hora tok man jun nunuc que nka-pe ta ri rajaf, jari' tok nka-pe. Ri rajaf nuya-vi ru-castigo pari' ri samajel ri' y nuya' quiq'uin ri ch'aka chic samajela' ri man nyetaken tüj tzij. ");
INSERT INTO cakENT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ri samajel c'a ri etamayon achique nrajo' ri rajaf, pero xa man nuchojmirsaj tüj ri' richin nbün ri samaj, ni man nbün tüj ri nrajo' ri rajaf, ri samajel c'a re' nka-ka juis ru-castigo pari'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Jac'a ri samajel ri xa man retaman tüj achique ri nrajo' ri rajaf, y c'o ri man utz tüj nyerubanala-apu, stape' (aunque) ta ri samajel ri' c'uluman ta que juis ru-castigo nka-ka pari', man quiri' tüj nban chin, ri ru-castigo ri nka-ka pari' rija' man ta nc'o ruvi'. Roma ri q'uiy c'a yo'on chin, chuka' q'uiy c'a ri nc'utux chin, si rubanun o xa man rubanun tüj. Chuka' ri q'uiy ri jachon can pa ruk'a', q'uiy c'a chuka' ri nc'utux chin, que achique c'a ri rubanun riq'uin, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yin xinka-pe chuvüch ri ruch'ulef chuya'ic c'a ri k'ak' chi'icojol. Y juis ninrayij que ri k'ak' re' nc'at ta chic. ");
INSERT INTO cakENT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero nabey nc'atzin c'a que ninc'usaj c'a na pokonül, romari' nk'oxon vánima ri voyoben-apu, y juis ninrayij que c'unük ta chic can ri jun pokonül re'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Rix ninuc que yin xinpu'u richin nuc'amon-pe quicot chuvüch ri ruch'ulef? Man quiri' tüj. Voma yin yec'o ri nquijachala-qui'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Romari' richin chikavüch-apu, si pa jun jay yec'o ye vo'o' vinük, ye oxi' xa nyecatüj c'a chiquij ri ye ca'i', o ja ri ye ca'i' ri nyecatüj chiquij ri ye oxi'. Pero man nquic'uaj tüj qui'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ri tata'aj man nka' tüj c'a chuvüch ri nbij ri ruc'ajol. Nixta ri c'ajol man nka' tüj chuvüch ri nbij ri rutata'. Nixta ri te'ej man nka' tüj chuvüch ri nbij ri ral-xtün chin. Y quiri' c'a chuka' ri xtün man nka' tüj chuvüch ri nbij ri rute' chin. Y quiri' c'a ri alite' man nquic'uaj tüj qui' riq'uin ri rali', roma man junan tüj nyenucun, y nixta ri ali' nuc'uaj-ri' riq'uin ri ralite'. ");
INSERT INTO cakENT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Y ri Jesús xbij c'a chuka' cheque ri vinük: Rix ivetaman achique titzu'un ri sutz' ri nc'amon-pe job. Y tok nitz'et c'a ri sutz' re', chanin nibij que npu'u job. Y npu'u-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y tok nutz'om ri cakik', ja retal ri' iyo'on que ntel yan sak'ij. Y ntel-vi sak'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Rix xa ca'i' ipalüj, roma jabel ivetaman achique ri npu'u tok nitz'et que c'o sutz' chicaj y jabel chuka' ivetaman achique ri npu'u xaxe riq'uin nitz'et ri ruch'ulef. Si ivetaman ri', ¿achique c'a roma tok man ivetaman tüj chuka' achique tiempo ri rojc'o-vi? ");
INSERT INTO cakENT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Y achique c'a roma tok man pan iyon tüj nitz'et ri choj ri c'uluman que nibün rix? ");
INSERT INTO cakENT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Roma si c'o jun chive ri nsujüs pa juzgado roma c'o ruc'as riq'uin jun vinük, nutij ruk'ij richin nuchojmirsaj-ri' riq'uin ri vinük ri xsujun chirij, tok xa c'ateri' quitz'amon-e bey pa juzgado. Roma si man nuchojmirsaj tüj ri' riq'uin ri vinük achique chok q'uin c'o-vi ruc'as, nuc'u'üx c'a chuvüch ri juez ri', y ri juez ri' nujüch-e pa ruk'a' ri achi ri nchajin ri cárcel, y ri chajiy-cárcel nuc'uaj-e, richin nutz'apij. ");
INSERT INTO cakENT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Y ketzij ninbij, que ri vinük ri ntoc pa cárcel roma ruc'as, man ntel tüj pe chiri' si man nutoj tüj can ronojel ri ruc'as. ");
INSERT INTO cakENT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Y ja k'ij ri' tok yec'o ca'i-oxi' vinük ri xe'apon riq'uin ri Jesús, y rije' xquitzijoj c'a chin pari' ri xquic'ulachij ch'aka achi'a' aj pa ruch'ulef Galilea. Ri achi'a' ri' cha yec'o c'a pa racho ri Dios, y ye quic'ualon-apu chico richin que nyequisuj chin ri Dios. Y ja tok nyetajin chusujic ri chico chin ri Dios, rije' xebecamsüs c'a can. Etaman c'a que ri xbanun que xebecamsüs can ri achi'a' ri' ja ri gobernador Pilato. Ri quiquiq'uel c'a ri chico y ri quiquiq'uel ri achi'a', xuyol-ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pero ri Jesús xbij cheque: ¿Rix ninuc que ri achi'a' aj-Galilea ri', quiri' xquic'ulachij roma más ye aj-maqui' que chiquivüch ri ch'aka chic ye quivinak aj-Galilea? ");
INSERT INTO cakENT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Man quiri' tüj. Jac'a rix, si man nitzolij tüj pe ic'u'x riq'uin ri Dios, xa nyixapon chuka' chupan ri pokonül ri ape' xe'apon-vi rije'. ");
INSERT INTO cakENT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿O rix ninuc chuka' que ri ye dieciocho ri xecom chiri' ape' c'o-vi ri ya' rubini'an Siloé, tok xtzak ri torre chiquij, que más ye aj-maqui' que chiquivüch conojel ri ch'aka chic vinük ri yec'o chiri' pa tinamit Jerusalén? ");
INSERT INTO cakENT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Man quiri' tüj. Jac'a rix si man nitzolij tüj pe ic'u'x riq'uin ri Dios, xa nyixapon chuka' chupan ri pokonül ri ape' xe'apon-vi rije'. ");
INSERT INTO cakENT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Y ri Jesús xutz'om c'a rubixic jun ejemplo chiquivüch, y xbij: C'o c'a jun achi ruticon jun che' higuera pa rulef, y xapon chuxe' ri che' chutz'etic si c'o ruvüch. Y ri che' higuera ri' xa man jun vit ruvüch c'o. ");
INSERT INTO cakENT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Romari' ri rajaf ri ulef xbij chin ri achi ri samajel rulef: Oxi' yan c'a juna' re' ri juna-juna' nintz'eta' ri che' re', y man jun bey nutz'eton que ruyo'on ta jun vit ruvüch. Roma c'a ri' más utz tachoyo-e, roma xa man jun vit ruvüch nuya'. ¿Achique nc'atzin-vi que xaxe nuq'uis ruchuk'a' ri ulef? ");
INSERT INTO cakENT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero ri samajel richin ri ulef xbij chin ri rajaf: Taya' na chic c'a can ri juna' re'. Tinbana' na c'a ruc'ojlen ri ulef ri ape' tiquil-vi y tinya' na k'ayis chuxe'. ");
INSERT INTO cakENT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Si nuya' c'a ruvüch, utz. Y si xa man nuya' tüj c'a ruvüch, c'ateri' c'a tachoyo-e, xbij ri samajel richin ri ulef. Quiri' ri ejemplo ri xutzijoj ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Y pa jun c'a k'ij richin uxlanen, ri Jesús nyerutijoj c'a ri vinük riq'uin ri rutzij ri Dios, pa jun jay ape' ntzijos-vi rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Y chiquicojol ri vinük ri quimolon-qui' chiri', c'o c'a jun ixok ri c'o yan dieciocho juna' rutz'amon-pe yabil. Ri ixok c'a ri' luculic, y man ntiquer tüj npa'e' ba' choj. Ri ixok ri' quiri' c'a ruc'ulachin roma jun itzel espíritu. ");
INSERT INTO cakENT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pero tok ri Jesús xutz'et ri ixok ri', xroyoj y xbij chin: Vocomi jare' xacolotüj chuvüch ri ayabil. ");
INSERT INTO cakENT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Y xuya' c'a ruk'a' pari' ri ixok. Y ri ixok jari' xchojmir, xpa'e' jabel. Y ri ixok jari' xuya' ruk'ij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero ri achi ri cachi'el jun tata'aj chiri' chupan ri jay ape' ntzijos-vi ri rutzij ri Dios, juis itzel xutz'et ri Jesús roma xuc'achojrisaj ri ixok chupan ri k'ij ri richin uxlanen. Romari' ri cachi'el tata'aj xbij cheque ri vinük ri quimolon-qui' chiri': Ronojel semana c'o vaki' (seis) k'ij richin nkusamüj. Y chupan c'a ri k'ij ri' quixpu'u riq'uin ri Jesús richin nyixc'achojrisüs, y man ja tüj ri k'ij re', k'ij richin uxlanen. ");
INSERT INTO cakENT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pero ri Ajaf Jesús jari' xbij chin: Rix xa ca'i' ipalüj. ¿Man chi'ivonojel tüj rix c'a nye'isol-e ri ivacx, ri iquiej pa jun k'ij richin uxlanen, richin nyixbe chuya'ic ri quiya'? Ja', quiri' ri nibün rix, y ri chico man ta juis ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ya voro chi comi c'a ri jun ixok re', ri ralc'ual can roma ri Abraham, cachi'el rix. Y ri itzel-vinük c'o yan dieciocho juna' ri ruximon-pe. ¿Man c'uluman tüj comi c'a que nc'achojrisüs chupan jun k'ij richin uxlanen? ");
INSERT INTO cakENT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tok ri Jesús rubin chic ka ri tzij ri', conojel ri nye'etzelan richin, xeq'uix-ka chuvüch. Jac'a ri ch'aka chic vinük juis nquicot cánima, roma ri Jesús juis nim ri rusamaj ri Dios ntajin chubanic. ");
INSERT INTO cakENT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Y ri Jesús xbij c'a: ¿Achique c'a xtinbij pari' ri rubanic tok ri vinük nye'oc pa ruk'a' ri Dios? ¿Achique chok q'uin junan vi? ");
INSERT INTO cakENT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yin ninbij c'a que junan riq'uin ri ija' ri richin ri mostaza ri nutic can jun achi pa rulef. Tok nq'uiy, cachi'el jun vit che' ntzu'un, juis nim. Romari' tok ri ch'ipa' ri nyebe chicaj, nye'apon chupan richin nquibün quisoc pa tak ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Y ri Jesús xbij c'a chuka': ¿Achique comi xtinbij pari' ri rubanic tok ri vinük nye'oc pa ruk'a' ri Dios? ¿Achique chok q'uin junan vi? ");
INSERT INTO cakENT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Xa junan c'a riq'uin ri levadura ri nyeruc'ama-pe jun ixok y nuya' can chupan oxi' pajbül-q'uej, y ntoc ronojel, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Y ri Jesús xutz'om chic c'a e ri rubey pa tinamit Jerusalén. Pero nabey xbec'o-pe pa tak nimak' y cocoj tinamit, richin nutzijoj ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Y c'o c'a jun ri xc'utun chin ri Jesús, y xbij chin: Ajaf Jesús, ¿ye q'uiy comi ri nyecolotüj? Pero ri Jesús xa cheque c'a conojel xch'o-vi, y xbij: ");
INSERT INTO cakENT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Titija' c'a ik'ij titakej ri rutzij ri Dios. Ronojel ri nibün rix, pa ruchojmilüj tibana' chuvüch ri Dios. Roma ri ruchi-jay ri ape' nyixoc-vi, juis co'ol oc ruvüch. Y juis c'a ye q'uiy ri vinük ncajo' nye'oc chupan ri ruchi-jay ri', pero man nyetiquer tüj nye'oc. ");
INSERT INTO cakENT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Roma tok ri Ajaf ncatüj-pe y ntz'apij-pe ri ruchi-jay, rix ri man jani rix c'unük tüj apu riq'uin, nyixoyon c'a apu y nibij: Ajaf, Ajaf, tajaka' ri ruchi-jay chikavüch richin que nkujoc-apu. Pero rija' nbij-pe chive: Man vetaman tüj ape' quixpu'u-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Y rix nibila' c'a apu chin: Ja roj ri xojva' aviq'uin. Y ja pa tak bey richin ri katinamit, chiri' xabij-vi ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jac'a rija' nbij-pe chive: Xinbij yan chive que man vetaman tüj ape' quixpu'u-vi. Man utz tüj que nyixc'uje' viq'uin, rix banuy-itzel, nbij ri Ajaf. ");
INSERT INTO cakENT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Y tok nye'itz'et ri achi'a' ri quibini'an Abraham, Isaac, Jacob y conojel ri achi'a' ri xek'alajrisan ri rutzij ri Dios ojer can, que yec'o pa ruk'a' ri Dios, jari' tok ntoc ri ok'ej iviq'uin roma ri bis, nijach'ach'ej ivey roma xixyo'ox can. ");
INSERT INTO cakENT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Y nyepu'u c'a vinük chiri' pa norte, chiri' pa sur, chiri' pan oriente y chiri' pan occidente. Vinük ri quiyo'on cánima viq'uin. Y ri vinük ri' nyec'uje' c'a pa ruk'a' ri Dios. Rije' nyetz'uye' c'a apu chuvüch mesa. ");
INSERT INTO cakENT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Y chiri' yec'o c'a nc'uje' quik'ij y ri vocomi manak oc quik'ij, y yec'o c'a ri juis quik'ij vocomi, manak oc quik'ij nc'uje', xbij c'a ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Y chupan c'a chuka' ri k'ij ri', yec'o achi'a' fariseos ri xe'apon riq'uin ri Jesús, y xquibij chin: Ri Herodes, ri rey, nrajo' ncarucamsaj. Catel c'a e chere' chanin, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero ri Jesús xbij cheque ri achi'a' ri': Quixbiyin y tibij chin ri jun rey ri', ri ch'acoy vinük, que yin c'a nyenvelesala' na itzel tak espíritu y c'a nyenc'achojrisala' na chuka' ri c'o quiyabil. Quiri' ri vocomi, ri chuak', y c'ateri' ri cabij c'a ninq'uis can rubanic ri samaj re'. ");
INSERT INTO cakENT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yin xa nc'atzinej-vi que nintz'om-e nubey. Quiri' ri vocomi, ri chuak' y ri cabij. Nc'atzinej que nquinapon pa tinamit Jerusalén, roma ri ye k'alajrisüy ri rutzij ri Dios man jun bey ri nyecamsüs tüj pa jun chic tinamit. ");
INSERT INTO cakENT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Y c'ateri' ri Jesús xch'o c'a chiquij ri vinük ri yec'o pa tinamit Jerusalén. Rija' xbij c'a: Aj-Jerusalén, aj-Jerusalén, ¿achique c'a roma tok nye'icamsala' ri achi'a' ri nyek'alajrisan ri nbix cheque roma ri Dios? ¿Achique c'a roma chuka' tok nye'icamsala' chi abüj ri nyerutük-pe ri Dios chi'icojol? Y yin, juis mul c'a ri xinjo' que xixinmol ta viq'uin, cachi'el nbün ri quite-üc' cheque ri tak ral, nyerumol chuxe' ri ruxic'. Man jun bey c'a xijo' tüj rix. ");
INSERT INTO cakENT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Vocomi c'a, ri ivacho chi'ijujunal rix nc'uje' can cachi'el jun tz'iran ruch'ulef. Y ketzij chuka' ninbij chive que man chic c'a nquinitz'et ta chic, c'a ja tok napon na ri k'ij tok nbij chuve: ¡Matiox que petenük ri Jun re'! ¡Que ri Ajaf Dios nbün ta bendecir rija' ri petenük pa rubi' rija'! Chupan c'a ri k'ij ri' tok nquinitz'et chic jun bey. ");
INSERT INTO cakENT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Y pa jun k'ij richin uxlanen, ri Jesús xbe pa racho jun quitata' ri achi'a' fariseos. Ri Jesús oyon c'a roma ri achi ri' richin jun va'in. Y ri yec'o chiri' nquinachaj c'a apu ri Jesús, ");
INSERT INTO cakENT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","roma chiri' c'o-apu jun achi yava'. Ri yabil ri ntoc chin ri jun achi ri', ja ri ya' c'o pa ruch'acul. ");
INSERT INTO cakENT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Y ri Jesús xbij c'a cheque ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y chuka' cheque ri achi'a' fariseos ri yec'o chiri': ¿Xajan comi que nc'achojrisüs jun yava' pa jun k'ij richin uxlanen? ¿Achique nibij rix? ");
INSERT INTO cakENT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri fariseos man jun xquibij. Romari' ri Jesús xutz'om-apu ri yava' y xuc'achojrisaj y xbij chin que tibiyin. ");
INSERT INTO cakENT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Y cheque ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri fariseos, ri Jesús xbij: Si c'o jun chive rix ntzak jun ruquiej o jun ruvacx pa jun jul, ¿man comi junanin ta nyixbe chirelesasic, stape' (aunque) jun k'ij richin uxlanen? ");
INSERT INTO cakENT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri fariseos man xquil tüj c'a achique xquibij-apu chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Y xpu'u ri Jesús xutz'om c'a rubixic jun ejemplo cheque ri ye oyon pa va'in. Roma xerutz'et ri vinük ri ye oyon que nquichala' quich'acat richin nyetz'uye' chiri' chuvüch mesa. Romari' xbij c'a cheque: ");
INSERT INTO cakENT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Tok c'o c'a jun ri noyon ivichin pa jun c'ulubic, man ticanoj c'a ri nabey tak ch'acüt. Roma riq'uin ba' rat tz'uyul chic chiri' tok napon jun vinük ri más c'o ruk'ij que chavüch rat, ");
INSERT INTO cakENT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","y npu'u ri xoyon avichin pa c'ulubic, nbij chave: Tabana' favor taya' can ri ach'acat chin ri jun ri voyon chuka'. Y rat ncaq'uix y rat ncabetz'uye' pa ruq'uisbül tak ch'acüt. ");
INSERT INTO cakENT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Roma c'a ri' tok c'o jun ri noyon ivichin pa jun c'ulubic, quixtz'uye' pa ruq'uisbül tak ch'acüt richin quiri' tok ncarutz'et-pe ri xoyon avichin, napon c'a aviq'uin rat y nbij chave: Tabana' favor cajote-pe chere'. Y tok quiri' nban chave, conojel c'a ri nyetz'uye' aviq'uin chuvüch mesa richin va'in nquetamaj que c'o ak'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Roma c'a ri', ri nquinimirsaj-qui', xa nkasüs quik'ij. Y jac'a ri man nunimirsaj tüj ri', nnimirsüs ruk'ij, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Y ri Jesús xbij c'a chuka' chin ri xoyon richin: Tok najo' c'a que c'o nyepu'u aviq'uin richin jun va'in, man c'a que'avoyoj xaxe ri avachibil, ri ate-atata', conojel ri ye animal-achak' y ri a-vecinos ri ye beyoma', roma rije' nyetiquer chuka' ncatcoyoj richin jun va'in pa cacho, y riq'uin ri' nac'ul yan e ri rajil-ruq'uexel. ");
INSERT INTO cakENT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jac'a rat, tok c'o jun nimak'ij chi avacho, si nye'avoyoj vinük ri manak quichajin, ri vinük ri man utz tüj ri quik'a' o ri cakün, o nye'avoyoj ri xa man choj tüj nyebiyin roma ri ye jetz' y ri moyi', ");
INSERT INTO cakENT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","jabel c'a aquicot, roma ri vinük ri xe'avoyoj ri', man nyetiquer tüj nquiya' yan e rajil-ruq'uexel chave. Pero rat nac'ul ri rajil-ruq'uexel, tok junan ncac'astüj-e quiq'uin ri chojmilüj tak vinük, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Y c'o c'a jun ri tz'uyul chiri' chuvüch mesa, tok rac'axan chic ka ri tzij ri xbij ri Jesús, xbij c'a apu chin: Jabel quiquicot ri nyec'uje' pa ruk'a' ri Dios y nquic'ux quivay chiri', xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Y jari' tok ri Jesús xbij: Jun achi jun bey, nrajo' c'a nbün nimak'ij chi racho y nuya' jun va'in. Romari' rija' cheque ye q'uiy vinük ri xbij que nyeroyobej chiracho ri k'ij richin va'in. ");
INSERT INTO cakENT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Romari', tok xapon ri k'ij richin ri va'in, ri achi xutük c'a e jun rusamajel chicoyoxic conojel ri vinük ri'. Y ri samajel xberubij c'a cheque: Ronojel c'o chic, vocomi jo' c'a chi va'in. ");
INSERT INTO cakENT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero conojel junan ri xquibila-pe, que man nyetiquer tüj nyebe. C'o c'a jun ri xbij-pe: Tabana' favor tabij chin ri avajaf, que quirucuyu' ba' que man nquitiquer tüj nquibe, roma xa c'a xinlok' can jun vulef, y nc'atzin richin nquibe chutz'etic. ");
INSERT INTO cakENT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","C'o jun chic ri quiri' chuka' xbij: Tabana' favor tabij chin ri avajaf que man nquitiquer tüj nquibe, roma yec'o vo'o' c'ulaj nuvacx richin samaj xenlok', y nc'atzin richin nyentij. ");
INSERT INTO cakENT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Y c'o c'a jun chic ri xbij-pe, que man ntiquer tüj nbe roma xa c'a xc'ule'. ");
INSERT INTO cakENT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Y tok ri samajel ri takon-e xtzolij-apu riq'uin ri rajaf, ronojel c'a ri xbix-pe chin xutzijoj chin. Romari' ri rajaf itzel xuna', y xbij chin ri rusamajel: Vocomi c'a cabiyin pa tak bey chucojol tak jay y quebe'amolo' c'a pe ri xa man utz tüj ri quik'a' o ri cakün, ri man choj tüj nyebiyin roma ye jetz', ri ye moyi', y chuka' ri xa manak quichajin. ");
INSERT INTO cakENT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Y tok ri samajel xtzolij, xbij c'a chin ri rajaf: Xenc'ün yan pe ri vinük ri xabij-e chuve, pero ri ch'acüt c'a q'uiy c'o. ");
INSERT INTO cakENT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Y ri rajaf xbij chin: Vocomi c'a cabiyin ri rutza'n tak jay e y pa tak bey ri nyebe lojc'an chic tinamit, y tabana' c'a cheque ri vinük ri nyec'uje' chiri' que quepu'u pa vacho, richin quiri' nnoj ri vacho. ");
INSERT INTO cakENT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Roma yin ketzij vi ninbij chive que man jun chic cheque ri xenvoyoj pa nabey, ri nbanun ta pe ri va'in re' viq'uin, xbij, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Y juis c'a vinük ri ye tzeklebeyon-e richin ri Jesús. Y tok rija' xtzu'un c'a can chirij y xerutz'et ri vinük ri', xpa'e', y xutz'om c'a rubixic cheque: ");
INSERT INTO cakENT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Si c'o c'a jun ri npu'u viq'uin richin ntoc vachibil, nc'atzinej c'a que ja yin ri más ta nquirujo'. Man c'uluman tüj c'a que ja ta ri rute-rutata' ri más nyerujo' que chinuvüch yin. Nixta c'uluman c'a chuka' que ja ta ri rixjayil, ri ye ralc'ual, ri ye runimal-ruchak' o rija' mismo ri más nrajo-ka-ri'. Nc'atzinej c'a que ja yin ri más nquirujo'. Roma si man quiri' tüj ri nbün, man ntiquer tüj c'a ntoc vachibil. ");
INSERT INTO cakENT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ri vinük ri nrajo-vi ntoc vachibil, nc'atzin que man tupokonaj nuc'usaj pokonül voma yin, cachi'el xa ta benük chuxe' ru-cruz. Jac'a ri vinük ri xa nupokonaj nuc'usaj pokonül voma yin y man nrajo' tüj nquirutzeklebej, man ntiquer tüj ntoc vachibil. ");
INSERT INTO cakENT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Roma tok c'o jun chive rix ri nrajo' nbün jun jay nim, ¿man ntz'uye' tüj comi ba' richin que nunuc jani' tumin nc'atzin chin, y si c'o ronojel ruchajin richin nuq'uis rubanic o xa man ntiquer tüj? ");
INSERT INTO cakENT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Roma si xaxe ri ru-cimiento ri jay ntiquer nuya-ka y nupaba' can ri samaj chiri', nyepu'u c'a ri vinük nquitze'ej, ");
INSERT INTO cakENT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","y nquibila' c'a: La jun achi la' xrajo' xupaba' jun jay, y xa man xtiquer tüj chic, nquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O si jun rey, nc'atzinej que nbün oyoval riq'uin jun chic rey, ¿man ntz'uye' tüj comi ba' richin quiri' nunuc si diez mil ru-soldados nyetiquer nquibün oyoval quiq'uin ri veinte mil soldados ri ye ruc'amon-pe ri jun chic rey? ");
INSERT INTO cakENT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Y si nunuc que man ntiquer tüj, rija' nyerutük achi'a' chuc'ulic ri rey, tok xa c'a man jani rutzijol nka-pe. Y ri achi'a' ri nyebe chuc'ulic nyequic'utuj favor chin que man ncajo' tüj oyoval. ");
INSERT INTO cakENT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Romari', si jun chive rix nrajo' ntoc vachibil, nc'atzinej c'a que nunuc nabey que nc'atzinej que nuya' can ronojel ri ruchajin. Si man nbün tüj quiri', man ntiquer tüj ntoc vachibil. ");
INSERT INTO cakENT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ri atz'an jabel utz. Y si ta ri atz'an re' nq'uis ta e ri rutz'ayil, ¿achique ta c'a rubanic richin quiri' ntzolij ta chic pe ri rutz'ayil? ");
INSERT INTO cakENT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jun atz'an ri man ntz'ayin tüj chic, man utz tüj nucusüs cachi'el nucusüs ri ulef, nixta utz chuka' nucusüs richin nbün abonar jun ulef. Xa ntorix-e, roma man jun chic nc'atzin-vi. Rix ri c'o ixiquin, tivac'axaj c'a ri xinbij-ka, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Y conojel c'a ri achi'a' moloy tak alcaval y ri ch'aka chic vinük ri nbix aj-maqui' cheque, nye'apon apu c'a riq'uin ri Jesús. Ri vinük ri' nye'apon riq'uin ri Jesús richin ncac'axaj ri rutzij ri Dios ri nutzijoj. ");
INSERT INTO cakENT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Y roma ja quivüch vinük ri' ri nye'apon riq'uin ri Jesús, ri achi'a' fariseos y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés juis c'a nquibij chirij ri Jesús. Y nquibila' c'a: Ri Jesús junan ruvüch quiq'uin ri aj-maqui'. Roma man xe tüj ri jabel quic'ulic nbün, xa nbe chuka' chiquij chi tak cacho richin nyeva', nquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Roma c'a ri' ri Jesús xutz'om c'a rubixic jun ejemplo chiquivüch, y xbij: ");
INSERT INTO cakENT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Si ta jun chive rix ri yec'o ta jun ciento ovejas y nsatz ta can jun tok ye ruc'uan richin nyeruyuk'uj, ¿man nyeruya' tüj comi can ba' ri ch'aka chic ru-ovejas chiri' pa k'ayis, chucanoxic ri jun? Ja', quiri' nbün. ");
INSERT INTO cakENT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Y tok nril-pe ri oveja ri', nuya' c'a pe pari' rutele'n. Nquicot-vi c'a roma ri xril-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Y tok napon chiracho, nyeroyoj ri vinük retaman quivüch, y nyeroyoj chuka' Ri ru-vecinos, y nbij c'a cheque: Quixquicot c'a viq'uin vocomi, roma ri nu-oveja ri satznük can, xinvil-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Y ketzij c'a ninbij chive, que chila' chicaj c'o quicot tok yec'o noventa y nueve vinük ri choj quic'aslen, ri xa tzolijnük chic pe quic'u'x riq'uin ri Dios. Pero c'o más quicot chila' chicaj, tok c'o jun aj-mac ri ntzolij-pe ruc'u'x riq'uin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","O si c'o ta jun ixok ri c'o tumin riq'uin, y chin ri diez tumin ri' nutzük ta jun chiri' pa racho, ¿man nutzij tüj comi jun k'ak' ri ixok ri', richin nucanoj ri rutumin? ¿Y man numes tüj comi rupan ri racho chucanoxic ri rutumin? Ja', quiri' nbün. ");
INSERT INTO cakENT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y tok nril, nyeroyoj ri vinük ri retaman quivüch, y nyeroyoj chuka' ri ru-vecinos, y nbij c'a cheque: Quixquicot c'a viq'uin, roma ri nutumin ri satznük, xinvil yan. ");
INSERT INTO cakENT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Y ketzij c'a ninbij chive, que tok c'o jun aj-mac ntzolij-pe ruc'u'x riq'uin ri Dios, chiquivüch chuka' ri ángeles richin ri Dios juis quicot, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Y ri Jesús xbij c'a chuka' cheque: C'o c'a jun achi ri yec'o ye ca'i' ruc'ajol. ");
INSERT INTO cakENT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Y jun k'ij ri chak'laxel-ala' xbij c'a chin ri rutata': Nata', yin ninjo' yan ri nu-herencia, y taya' c'a chuve ri jani' ntel-apu chikavüch riq'uin ri nunimal, xbij. Y ri tata'aj xujüch na vi ri herencia chiquivüch chi ca'i'. ");
INSERT INTO cakENT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","C'ate ba' ri', ri chak'laxel-ala' xuc'ayila' can ronojel ri xrichinaj. Q'uiy c'a ri tumin ri xumol-e, y c'ateri' xbe pa jun chic ruch'ulef ri nüj c'o-vi: Y tok c'o chic chiri', xuc'uaj c'a jun itzel c'aslen, y romari' juis q'uiy tumin ri nuq'uis. ");
INSERT INTO cakENT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Rija' xuq'uis c'a ronojel ri rutumin. Y jari' tok xpu'u jun nimalüj vayjül chupan ri ruch'ulef ape' c'o-vi. Y ri ala' ri' q'uiy c'a ri xbec'atzin-pe chin. ");
INSERT INTO cakENT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Y romari' xberusuju-ri' pa samaj riq'uin jun achi aj chiri' chupan ri ruch'ulef ri', y ri achi xutük-e c'a pa rulef y roma nc'atzinej yuk'un ak xberubana'. ");
INSERT INTO cakENT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Y roma ri juis vayjül c'o chin ri ala' ri', nurayij c'a nuc'ux ri nquic'ux ri ak. Pero man jun vinük ri nyo'on ta chin. ");
INSERT INTO cakENT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Y ri ala' ri', c'ateri' xtzolij-pe ruc'u'x, y xunuc-ka: Ri ye rusamajela' ri nata' man nquitij tüj vayjül, roma c'o q'uiy quivay. Pero yin xa nquicom yan ka roma vayjül chere'. ");
INSERT INTO cakENT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Más utz nquitzolij na riq'uin ri nata', y ninbij c'a chin: Nata', xinmacun chuvüch ri Dios, y xinmacun chuka' chavüch rat. ");
INSERT INTO cakENT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Man c'uluman tüj chic c'a nabij ac'ajol chuve. Más utz tabana' chuve que nquinoc jun asamajel, xbij pa ránima. ");
INSERT INTO cakENT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Y xutz'om na vi e bey chiracho, riq'uin c'a ri rutata'. Y c'a nüj na c'a c'o-vi ri ala' chi ri racho, tok ri rutata' xutz'et yan ri ruc'ajol, y juis c'a xujoyovaj ruvüch. Romari' junanin xbe chuc'ulic, xuk'etej y xutz'ubaj. ");
INSERT INTO cakENT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Y ri ala' jari' xbij chin ri rutata': Nata', xinmacun chuvüch ri Dios, y xinmacun chuka' chavüch rat. Man c'uluman tüj chic c'a que nabij ac'ajol chuve. ");
INSERT INTO cakENT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero ri rutata' xbij c'a cheque ri rusamajela': Tivelesaj-pe ri tziük más jabel y tiveka' ri nuc'ajol. Tiya' jun anillo chuvi-ruk'a' y tiya' chuka' ruxajab chirakün. ");
INSERT INTO cakENT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Y te'ic'ama' c'a pe chuka' ri vit vacx ri tiojrisan, y ticamsaj-ka. Tikabana' c'a jun nimak'ij, y nkuva'. ");
INSERT INTO cakENT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Roma tok yin ninbij quiri', ninbij que ri jun nuc'ajol re' camnük chic, pero vocomi cachi'el c'astajnük chic pe. Rusatzon c'a e ri', pero xka-pe chic kiq'uin, xbij ri tata'aj. Y jari' xtz'ucutuj ri nimak'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Y tok ntajin c'a ri nimak'ij, ri nimalaxel-ala' nsamüj pa k'ayis. Y tok xtzolij c'a pe y xapon chunakaj apu ri jay, xrac'axaj c'a que c'o nimak'ij ntajin. ");
INSERT INTO cakENT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Romari' rija' xroyoj jun cheque ri quisamajela' y xuc'utuj chin: ¿Achique xbanatüj? ¿Y achique roma tok c'o nimak'ij? ");
INSERT INTO cakENT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Y ri samajel xbij chin: Roma xtzolij-pe ri achak', y utz ruvüch xtzolij-pe. Romari' ri atata' xutük rucamsasic ri vit vacx ri tiojrisan. ");
INSERT INTO cakENT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tok quiri' xrac'axaj ri nimalaxel-ala', xcatüj royoval, y man nrajo' tüj c'a ntoc-apu pa jay. Xbe'el c'a pe ri rutata', y nubochila' c'a, richin quiri' ntoc ta apu. ");
INSERT INTO cakENT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero man xrajo' tüj. Rija' xa xbij c'a chin ri rutata': Yin chi jumul nquisamüj aviq'uin y man jun bey ri man ta nutaken atzij. Y man riq'uin tüj ri', manak ri ayo'on ta chuve. Stape' (Aunque) ta jun vit cabra, richin nkabün ta jun nimak'ij quiq'uin ri vachibil, pero ri' man jun. ");
INSERT INTO cakENT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Y vocomi rat xacamsaj-ka ri vit vacx ti'oj, xaxe roma xtzolij-pe ri jun ac'ajol re', ri xa xberuq'uisa' can ronojel ri abeyomal, quiq'uin ixoki' ri man choj tüj quic'aslen, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Y ri tata'aj xbij: Nuc'ajol, xbij c'a chin. Rat, viq'uin ratc'o-vi. Romari' ronojel ri c'o, avichin vi rat. ");
INSERT INTO cakENT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero ri achak' re' camnük vi chic chinuvüch yin, y vocomi cachi'el c'astajnük chic pe, chinuvüch yin. Rusatzon c'a e ri', y vocomi xka-pe chic kiq'uin. Y romari' nc'atzinej c'a que c'o nimak'ij y quicot pa tak kánima, xbij ri tata'aj ri', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ri Jesús xbij c'a chuka' cheque ri rachibila': C'o c'a jun achi beyon. Y ri beyon ri' c'o c'a jun rusamajel ri c'o pari' ronojel ri rubeyomal rija'. Y chin ri achi beyon xtzijos c'a que ri rusamajel ri c'o pari' ronojel ri ruchajin, ntajin c'a chuq'uisic ronojel ri rubeyomal. ");
INSERT INTO cakENT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Y ri patrón xutük c'a royoxic ri samajel ri'. Y tok xobos c'a ri samajel, ri patrón xbij chin: ¿Achique nabij chuve pari' ri ntzijos chavij? Vocomi c'a ninjo' nintz'et achique rubanun ronojel ri beyomül pan ak'a', roma ri asamaj jare' xq'uis can chere', xbij ri patrón chin. ");
INSERT INTO cakENT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Y ri samajel xunuc c'a ka pa ránima: ¿Achique ninbün? Roma ri nu-patrón nrelesaj nusamaj. Y ninbün ta c'a jun chic ruvüch nusamaj ri nrajo' uchuk'a', pero man nquitiquer tüj chic. Nquinoc ta c'utuy-limosna pa tak bey, pero nquiq'uix. ");
INSERT INTO cakENT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tok xnucutüj chin, xbij: Vocomi vetaman chic achique ri ninbün, richin quiri' yec'o nyec'ulun vichin pa tak cacho, tok ntelesüs ri nusamaj. ");
INSERT INTO cakENT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ri samajel ri' xeroyoj chiquijujunal ri c'o quic'as riq'uin ri ru-patrón, y xuc'utuj c'a chin ri nabey: ¿Achique c'a ri ac'as, y jani'? ");
INSERT INTO cakENT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Y ri achi aj-c'as xbij c'a: Yin c'o jun ciento barril aceite olivo nuc'as, xbij. Y ri rusamajel ri beyon achi xbij c'a chin ri aj-c'as: Ja ruvuj ri ac'as re'. Y vocomi chanin catz'uye-ka y tabana' chic can jun. Y chupan ri jun chic vuj ri nabün, tabana' c'a ka chupan que xa nic'aj ciento barril aceite ri ac'as. ");
INSERT INTO cakENT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Y tok xapon chic c'a jun aj-c'as, ri samajel xuc'utuj c'a chin: Y rat ¿achique ri ac'as y jani'? Ri aj-c'as xbij: Yin cien quintal trigo nuc'as, xbij. Y ri samajel xbij chin: Ja ruvuj ri ac'as re', y vocomi catz'uye-ka y tabana' chic jun. Y chupan ri jun chic vuj ri nabün, tabana-ka chupan que xa ochenta ri ac'as, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Y tok ri ru-patrón xrac'axaj ri nbün ri jun itzel samajel ri', xbij: C'o runa'oj, xbij. Y cachi'el c'a ri achi ri', ye quiri' ri vinük ri c'a quiyo'on cánima riq'uin ri ruch'ulef. Juis vi yec'o quina'oj quiq'uin ri vinük ri man quitaken tüj ri Dios. Y más yec'o quina'oj ri vinük re', que chiquivüch ri quitaken ri Dios y ye richin chic ri sük. ");
INSERT INTO cakENT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Y yin ninbij c'a chive, xbij ri Jesús. Q'uiy mul ri beyomül richin ri ruch'ulef, man utz tüj rucusasic nban coma ri vinük. Jac'a si pan ik'a' rix ri ralc'ual chic ri Dios c'o-vi ri beyomül re', ticusaj c'a richin que nye'ito' ri nc'atzin quito'ic. Richin quiri' tok ri ibeyomal nq'uis, nyixc'ulutüj c'a chila' chicaj, chupan ri jay ri man jun bey nyeq'uis. ");
INSERT INTO cakENT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jun ri utz nbün riq'uin jun cosa ri xa manak más rakalen, utz c'a chuka' nbün riq'uin ri juis rakalen. Jac'a ri xa man utz tüj nbün riq'uin jun cosa ri xa manak más rakalen, xa quiri' chuka' nbün riq'uin ri c'o-vi rakalen. ");
INSERT INTO cakENT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Y si riq'uin ri beyomül richin ri ruch'ulef, rix man utz tüj nibün, ¿nujüch comi ri Dios ri ketzij beyomül pan ik'a'? ");
INSERT INTO cakENT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Roma si xa man utz tüj nibün riq'uin ri beyomül richin ri ruch'ulef ri uxkanen can pan ik'a', ya voro chi comi c'a que utz ta nibün riq'uin ri ketzij beyomül, si ta njach chive roma ri Dios, beyomül ri ivichin vi rix. ");
INSERT INTO cakENT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Y man jun c'a samajel ri ye ca'i' ta rajaf y ntiquer ta nsamüj quiq'uin chi ca'i' pa jun mul. Roma si nrajo' jun cheque ri rajaf, nretzelaj chic can ri jun. Y si nutakej rutzij ri jun, man ntiquer tüj nbün quiri' riq'uin ri jun chic. Y quiri' c'a, manak modo que c'o ta jun ri benük ránima chirij ri beyomül, y nrajo' ta chuka' nbün ri nrajo' ri Dios, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Y ri achi'a' fariseos xcac'axaj c'a ri xbij ri Jesús, romari' xquibanala-apu quipalüj chuvüch, roma rije' benük cánima chirij ri beyomül. ");
INSERT INTO cakENT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Y ri Jesús xbij cheque: Rix nibanala' chiquivüch ri vinük que juis rix choj. Pero ri Dios retaman achique ri c'o pan ivánima, y man utz tüj nyixrutz'et. Y ri' stape' (aunque) chi jumul jabel nyixtz'et y stape' (aunque) chuka' chi jumul rix nimirsan coma ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Y tok c'a man jani c'a tutz'om samaj ri Juan Bautista, c'a ja na c'a ri ley richin ri Moisés ri ntzijos. Y c'a ja na chuka' ri rutzij ri Dios ri tz'iban can coma ri achi'a' ri xek'alajrisan ri bin cheque roma ri Dios chupan ri ojer can tiempo, c'a ja na ri' chuka' ntzijos. Jac'a tok xutz'om samaj ri Juan, jari' tok xtz'am can rutzijosic ri utzilüj rutzij ri Dios ri nch'o pari' tok ri vinük nye'oc pa ruk'a' rija'. Y ye q'uiy c'a vinük ri juis nquitij quik'ij richin nye'oc chiri'. ");
INSERT INTO cakENT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Y chuka' ninbij chive, que más man c'ayuf tüj que ri ruch'ulef y ri caj nyeq'uis, que chuvüch ri ley. Roma ri nbij chiri', nc'atzinej-vi c'a que nbanatüj na, y man jun ri quiri' ta nc'uje' can, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Y ri Jesús xbij chuka': Si c'o c'a jun achi ri nujüch-ri' riq'uin ri rixjayil y c'ateri' nuc'ün chic pe jun ixok, ri achi re' nbün mac chuvüch ri Dios. Y si c'o c'a jun achi ri nuc'uan-e ri ixok ri jachon can roma ri rachijil, chuka' ri achi ri' nmacun chuvüch ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Y ri Jesús xbij c'a chuka': Xc'uje' c'a jun achi ri juis beyon. Ri achi ri' ruyon c'a jabel tak tziük ri jotol cajil ri nyerucusala', y k'ij-k'ij nbanala' nima tak va'in. ");
INSERT INTO cakENT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pero quiri' chuka' xc'uje' c'a jun achi ri c'utuy-limosna y nojnük ruch'acul riq'uin ch'a'c. Rija' rubini'an Lázaro, y ja pa ruchi-racho ri beyon nc'uje-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ri Lázaro juis c'a nurayij que nuc'ux ta ri ruchi' tak vüy ri nyetzak-ka chuxe' ri mesa. Y ri tz'i' nye'apon c'a riq'uin churek'ic ri ch'a'c c'o chirij. ");
INSERT INTO cakENT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Y jun k'ij ri c'utuy-limosna xcom-e, y c'a ja ri lugar richin quicot ri ape' xapon-vi, chiri' riq'uin ri Abraham. C'a ja ri lugar ri' xuc'u'üx-vi coma ri ángeles. Y chuka' ri achi beyon xcom y xmukutüj. ");
INSERT INTO cakENT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Y tok rija' nutij chic c'a pokonül chupan ri lugar ape' nye'apon-vi ri caminaki' ri man nquitakej tüj e, rija' xtzu'un-pe, y jari' tok xutz'et ri Abraham, pero c'anüj c'a c'o-vi. Xutz'et c'a chuka' ri Lázaro c'o chuchi' ri Abraham. ");
INSERT INTO cakENT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Y ri achi beyon riq'uin ruchuk'a' xch'o, y xbij c'a chin ri Abraham: Nata' Abraham, tajoyovaj nuvüch. Tabana' c'a favor tabij chin la Lázaro, que stape' (aunque) xe jun ruvi-ruk'a' tuch'ekeba', y tataka-pe viq'uin chere', richin nuya-pe ba' chutza'n vak'. Roma nc'at vánima chupan ri k'ak' re', xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero ri Abraham xbij chin: Tika-pe c'a chi'ac'u'x rat nuc'ajol, que tok xac'ase' chuvüch ri ruch'ulef, ri ac'aslen ri xac'usaj juis jabel, y ri Lázaro juis pokonül xc'usaj. Pero rija' juis jabel ri ruc'aslen ri xrila-pe chere', y rat xa jun c'aslen richin pokonül xavil. ");
INSERT INTO cakENT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Y chuka' xa c'o jun nimalüj sivan chikacojol. Romari', si c'o jun ri c'o chere' nrajo' ta napon iviq'uin, man ntiquer tüj. Y si ta jun chive rix nrajo' npu'u chere' kiq'uin roj, man ntiquer tüj chuka', xbij ri Abraham. ");
INSERT INTO cakENT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Y ri achi beyon xbij c'a: Si quiri', ninjo' c'a ninc'utuj chic jun favor chave rat nata' Abraham. Tataka' c'a e ba' ri Lázaro chuvüch ri ruch'ulef, pa racho ri nata'. ");
INSERT INTO cakENT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Roma yec'o vo'o' nuchak', y nbech'o ta quiq'uin, richin man quepu'u chupan ri jun lugar richin pokonül, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Y ri Abraham xbij chin: Rije' c'o ri rutzij ri Dios quiq'uin, ri rutz'iban can ri Moisés. Y c'o chuka' rutzij ri Dios ri tz'iban can coma ri achi'a' ri xek'alajrisan ri rutzij ri Dios ojer can. Jari' ri ticac'axaj, y tiquitakej, xbij ri Abraham. ");
INSERT INTO cakENT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Y ri achi beyon xbij: Ja', ketzij, nata' Abraham. Pero si c'o jun camnük ri nc'astüj-e y napon quiq'uin ri nuchak', nquitzolij-vi quic'u'x riq'uin ri Dios, xbij ri beyon. ");
INSERT INTO cakENT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero ri Abraham xbij chin: Si man nquitakej tüj ri rutzij ri Dios ri rutz'iban can ri Moisés, nixta nquitakej tüj chuka' ri rutzij ri Dios ri quitz'iban can ri achi'a' ri xek'alajrisan ri tzij ri' ojer can, xa man nquitakej tüj chuka' jun ri nc'astüj-e chiquicojol ri caminaki'. ");
INSERT INTO cakENT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Y ri Jesús xbij c'a cheque ri rachibila': Chi jumul c'o ri nbanun cheque ri vinük richin nyemacun. Pero ri nbanun chin jun chic vinük que nmacun, xa juya' ruvüch c'a. ");
INSERT INTO cakENT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Y más ta utz chin ri jun vinük ri nunucun que nbün ri itzel ri', que ximon ta jun nimalüj abüj richin que'en chukul y ntorix chupan jun mar, que chuvüch nbün chin jun co'ol que ntzak chupan mac. ");
INSERT INTO cakENT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Romari' rix tichajij c'a ri ic'aslen. Y si c'o jun a-hermano c'o itzel ri nbün chave, tabij c'a chin. Y si ri nbanun itzel chave nuc'utuj-pe cuyubül rumac chavüch roma xtzolij-pe ruc'u'x, tacuyu' c'a rumac. ");
INSERT INTO cakENT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Y si pa jun k'ij siete mul c'o ta itzel nbün chave y chi siete mul ntzolij ta pe ruc'u'x y npu'u aviq'uin y nbij chave: Tacuyu' y tamestaj numac, c'uluman que nacuy rumac, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Y ri apóstoles xquibij c'a chin ri Ajaf Jesús: Tabana' c'a cheke que nkaya' ta más kánima riq'uin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pero ri Ajaf Jesús xbij cheque: Si rix iyo'on ivánima riq'uin ri Dios, stape' (aunque) ta ba' oc cachi'el jun vit ija' richin ri mostaza, y nibij ta chin ri che' rubini'an sicómoro que tel-e chere' y tic'o chupan ri mar richin nyerutica-ri' chiri', ri che' re' nutakej vi itzij. ");
INSERT INTO cakENT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Y si c'o ta c'a jun chive rix ri c'o ta jun ri samajel vi riq'uin, y rutakon ta e pa k'ayis pan arado o yuk'uy quichin ovejas, ¿xe comi tok ntzolij-pe, ja comi ri' nbij chin: Catoc pa jay, catz'uye' chuvüch mesa y cava'? Man jun bey ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿Man nabij comi ta chin: Tabana' ruc'ojlen ri achique ninc'ux vocomi chi nkak'ij, y tachojmirsaj avi' rat chuka' richin quiri' nquinavilij-pe ri nquiva', y c'a tok nquicolaj na yin, c'ateri' cava' rat? ");
INSERT INTO cakENT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Y naya' comi juis ruk'ij ri samajel roma xbün ri xabij chin? Man jun. ");
INSERT INTO cakENT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Y cachi'el ri samajel ri', quiri' chuka' rix. Tok ibanun chic ri samaj ri nbij ri Dios chive, tibij: Roj roj samajela' ri man jun nkuc'atzin-vi. Roma xaxe ri bin cheke, xaxe ri' ri xkabün, quixbij, xbij ri Jesús cheque ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Y tok ri Jesús rachibilan ri rachibila' xutz'om chic e bey pa Jerusalén, xc'o c'a chiquicojol ri ruch'ulef Samaria y ri ruch'ulef Galilea. ");
INSERT INTO cakENT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Y tok xapon pa jun vit tinamit, yec'o c'a ye diez achi'a' ri c'o ri yabil ri rubini'an lepra chiquij. Ri achi'a' ri' xebe'el-pe, pero c'a nüj xepa'e-vi chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Y tok xech'o c'a, riq'uin cuchuk'a' xech'o-apu chin ri Jesús y xquibij: Ajaf, tajoyovaj kavüch roma ri kabanun, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Y ri Jesús xerutz'et-vi c'a y xbij cheque: Quixbiyin c'a y te'ic'utu-ivi' chiquivüch ri sacerdotes, xbij-e ri Jesús cheque. Y tok quitz'amon c'a e binen richin nyequic'utu-qui' chiquivüch ri sacerdotes, ri quiyabil xq'uis-e y xech'ajch'ojir c'a. ");
INSERT INTO cakENT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Y jun c'a cheque ri ye diez achi'a', tok xutz'et que xc'achojrisüs-vi riq'uin ri ruyabil, rija' xtzolij. Y juis c'a nuya' ruk'ij ri Dios, y riq'uin c'a ruchuk'a' nch'o tok nuya' ruk'ij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Y tok xapon riq'uin ri Jesús, xxuque' chuvüch y xulucuba-ka-ri', y juis c'a numatioxij chin ri Jesús. Ri achi re' aj-Samaria. ");
INSERT INTO cakENT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Y ri Jesús xbij: ¿Man ye diez tüj c'a ri xq'uis-e ri quiyabil y xech'ajch'ojir? ¿Y ri nueve chic? ");
INSERT INTO cakENT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Man jun chic c'a ri xtzolij ta pe richin que nuya' ruk'ij ri Dios? ¿Xaxe comi ri man israelita tüj ri xtzolij-pe richin que nuya' ruk'ij ri Dios? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Y ri Jesús xbij chuka' chin ri achi aj-Samaria: Cacatüj y cabiyin c'a. Xac'achoj roma xaya' avánima viq'uin, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Y ri achi'a' fariseos xquic'utuj c'a chin ri Jesús que jampe' c'a nka-pe ri utzilüj gobierno richin ri Dios richin pa ruk'a' rija' nkuc'uje-vi. Y ri Jesús xbij c'a cheque: Man ninabex tüj jampe' nka-pe, roma ri ru-gobierno ri Dios man tz'etetül tüj. ");
INSERT INTO cakENT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Y man c'a jun nbin ta que jare' c'o chere', o jala' c'o chila', roma ri ru-gobierno ri Dios c'o chic iviq'uin, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Y rija' xch'o c'a cheque ri rachibila', y xbij: Nyeka-pe c'a ri k'ij tok rix nijo' que stape' (aunque) xaxe jun k'ij nquic'uje' ta chic iviq'uin, yin ri xinalüx chi'icojol. Pero man jani nquinitz'et tüj. ");
INSERT INTO cakENT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Y yec'o c'a ri nyebin chive: Jare' c'o chere'. Jala' c'o chila'. Pero rix man quixbe c'a quiq'uin, nixta que'itzeklebej c'a chuka'. ");
INSERT INTO cakENT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Roma tok napon ri k'ij que yin ri xinalüx chi'icojol nquipu'u chic jun bey, nquinka-pe cachi'el jun coyopa', ri nk'alajin jabel roma nusakrisaj ri caj. ");
INSERT INTO cakENT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero nabey nc'atzinej c'a que ninc'usaj na q'uiy pokonül, y nc'atzinej c'a chuka' que nquinetzelüs coma ri vinük richin ri tiempo re', ri rojc'o vocomi. ");
INSERT INTO cakENT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Y ri k'ij c'a tok nquipu'u, yin ri xinalüx chi'icojol, nbanatüj c'a chuka' cachi'el ri xc'ulachitüj chupan ri k'ij tok xc'ase' ri Noé. ");
INSERT INTO cakENT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chupan c'a ri ru-tiempo ri Noé, ri vinük man jun chic c'a ri juis ta rakalen chiquivüch. Rije' xa ja ri quivay y quiya' ri nquinuc, chuka' ri c'ulubic, ri nyequiyala' chuka' quimi'al-quic'ajol richin nyec'ule'. Jari' ri nyequinucula' rije', tok xapon c'a ri k'ij richin que ri Noé y ri ye aj pa racho xe'oc chupan ri nimalüj barco, y xutz'om ri camic job. Y ri ch'aka chic vinük, conojel xecom. ");
INSERT INTO cakENT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Y quiri' c'a chuka' xc'ulachitüj pa ru-tiempo ri Lot. Ri vinük xa benük c'a cánima chirij ri quiva'in, riq'uin ri achique nyequikumula', riq'uin ri quilok'oj, ri quic'ayij, ri quiticoj y ri paban tak jay. ");
INSERT INTO cakENT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Y ri k'ij tok ri Lot y ri ye aj pa racho xquiya' can ri tinamit Sodoma, xka-ka c'a ri k'ak' y azufre pari' ri tinamit. Cachi'el c'a job xbün tok xka-pe chicaj, y conojel vinük ri yec'o chiri' xeruq'uis k'ak'. ");
INSERT INTO cakENT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Y ri k'ij c'a tok yin ri xinalüx chi'icojol yinc'ulun chic pe chere' chuvüch ri ruch'ulef, juis c'a ye q'uiy vinük ri xa riq'uin ronojel ri achique quichajilon benük-vi cánima. Y romari' nka-ka castigo pa quivi'. Nquic'ulachij c'a cachi'el ri xec'uje' pa tinamit Sodoma. ");
INSERT INTO cakENT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ri xa nuxlan pari' ri racho tok napon ri k'ij ri', choj quiri' tanmüj-e. Man toc chic apu pa racho richin que c'o ri nyeruc'ama-pe. Y si c'o c'a chuka' jun ri nsamüj pa k'ayis chupan ri k'ij ri', man titzolij chic chi racho. ");
INSERT INTO cakENT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Roma xaxe c'a tika-pe chi'ic'u'x ri xuc'ulachij ri rixjayil ri Lot, tok xporox ri tinamit Sodoma roma ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ri juis c'a nupokonaj ri ruc'aslen chere' chuvüch ri ruch'ulef, man nril tüj ruc'aslen richin chi jumul. Jac'a ri man nupokonaj tüj ri ruc'aslen richin ri chere', ri ruc'aslen man nq'uis tüj. ");
INSERT INTO cakENT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Y tok yin nquipu'u chic jun bey, si yec'o ye ca'i' nyevür chuvüch jun ch'at, jun rutaken y jun man rutaken tüj, xaxe c'a jun cheque rije' ri nuc'u'üx-e y ri jun chic ncanaj can. ");
INSERT INTO cakENT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Y si yec'o c'a ye ca'i' ixoki' ri junan nyeque'en, y xaxe jun ri rutaken, xa jun c'a ri nuc'u'üx-e y ri jun chic ncanaj can. ");
INSERT INTO cakENT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Y si yec'o ye ca'i' achi'a' ri junan chuka' yec'o pa samaj pa k'ayis, y xaxe jun ri rutaken, xaxe c'a jun chuka' ri nuc'u'üx-e y ri jun chic ncanaj can. ");
INSERT INTO cakENT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Y tok ri rachibila' cac'axan chic ka ri xbij ri Jesús, xquic'utuj chin: Ajaf, ¿ape' c'a nc'ulachitüj-vi ri quiri' ri'? Y ri Jesús xbij c'a cheque: Ri ru-gobierno ri Dios nka-ka ape' c'o-vi ri mac. Nbanatüj c'a cachi'el nbanatüj quiq'uin ri c'uch. Roma ri ch'ipa' ri' nyeka-ka ape' c'o-vi jun camnük nch'ovir chic, xbij ri Jesús chin nuc'ut que ri ru-castigo ri Dios nka-ka ape' c'o-vi ri mac. ");
INSERT INTO cakENT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Y ri Jesús xutzijoj c'a jun ejemplo cheque ri rachibila', richin que nuc'ut chiquivüch que nc'atzin-vi que chi jumul tiquibana' orar y man tiquimalij rubanic. ");
INSERT INTO cakENT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Rija' xbij c'a cheque: Pa jun tinamit xc'uje' jun juez ri man nuxbij tüj ri' chuvüch ri Dios, y man jun chuka' cakalen ri vinük chuvüch. ");
INSERT INTO cakENT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Y chupan c'a chuka' ri tinamit ri', c'o c'a jun malca'n-ixok. Y ri malca'n-ixok ri' ntel-ntoc c'a riq'uin ri jun juez ri', richin nuc'utuj favor chin que tuto' richin que nch'acon chirij ri banayun ch'a'oj chin. ");
INSERT INTO cakENT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Y q'uiy c'a k'ij ri xc'o, y ri juez man nrajo' tüj nuto' ri ixok malca'n. Pero jun k'ij ri juez re' xunuc c'a ka pa ránima: Stape' (Aunque) man yin ninimaj tüj richin ri Dios, nixta jun chuka' cakalen ri vinük chinuvüch, ");
INSERT INTO cakENT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero roma c'a ri ixok re' ntel-ntoc viq'uin, tinto' na c'a. Roma si man ninto' tüj, nc'o nuc'u'x pa ruk'a'. Quiri' nbij ri ejemplo ri xutzijoj ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Y c'ateri' ri Ajaf Jesús xbij: Yin vetaman que rix xivac'axaj ri jabel tak tzij ri xerubij ri juez, y rija' xa man choj tüj. ");
INSERT INTO cakENT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ya voro chi comi ri Dios que man ta nyeruto' ri vinük ri ye rucha'on chic rija' y chi pak'ij chi chak'a' nquibün orar. ¿Ri Dios man chanin tüj comi nyeruto-pe ri vinük ri ye rucha'on chic? ");
INSERT INTO cakENT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yin ninbij c'a chive que chanin nyeruto-pe. Y tok yin ri xinalüx chi'icojol nquipu'u chic jun bey chere' chuvüch ri ruch'ulef, ¿c'a yec'o comi vinük ri quiyo'on cánima riq'uin ri Dios? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Y ri Jesús xuya' chic c'a jun ejemplo chiquivüch ri vinük, roma yec'o cheque rije' ri nquinuc que juis ye choj, y nyequetzelaj ri ch'aka chic vinük. Romari' ri Jesús xbij: ");
INSERT INTO cakENT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Yec'o c'a ye ca'i' achi'a' ri xebe pa racho ri Dios chi oración. Ri jun achi, jun cheque ri fariseos, y ri jun chic jun moloy-alcaval. ");
INSERT INTO cakENT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ri achi fariseo pa'ül, ruyon nbün orar, y nbij c'a chupan ri ru-oración: Dios, matiox ninya' chave roma yin man yin junan tüj quiq'uin ri ch'aka chic. Roma ri ch'aka chic vinük ye elek'oma', ye canoy quichin ch'aka chic ixoki', y man ye choj tüj chupan ri quic'aslen. Nixta man yin junan tüj c'a chuka' riq'uin la jun achi moloy-alcaval la'. ");
INSERT INTO cakENT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Roma yin ca'i' k'ij pa jun semana ri man nquiva' tüj, richin ninbün orar. Y ronojel ri ninch'üc, diez ninbün chin, y jun chin ri' ninya' chave rat, xbij ri fariseo pa ru-oración. ");
INSERT INTO cakENT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Y ja ri moloy-alcaval c'a nüj xc'uje-vi can richin nbün orar. Pa'ül c'a nbün orar, pero jun lucul-vi chiri', roma chuvüch rija' man c'uluman tüj nuyüc ri runak'-ruvüch chicaj y rija' nt'inita' c'a ruc'u'x riq'uin ri ruk'a', y nbij c'a chin ri Dios: Tajoyovaj nuvüch, roma yin yin jun aj-mac chavüch. ");
INSERT INTO cakENT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ketzij ninbij chive, xbij ri Jesús, que ri achi moloy-alcaval xtzolij-e, y man jun rumac xutz'et ri Dios. Jac'a ri achi fariseo man quiri' tüj xutz'et ri Dios. Roma achique na c'a ri nunimirsaj-ri', nban c'a chin que nkasüs ruk'ij. Jac'a ri ruch'utinirsan-ri', nimirsüs ruk'ij, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Y ri vinük nyequic'amala-pe c'a ri ac'uala' riq'uin ri Jesús, richin nuya' ta ri ruk'a' pa quivi'. Y ri rachibila' ri Jesús xquitz'et, y xquibij cheque ri vinük que man tiquibün quiri'. ");
INSERT INTO cakENT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero ri Jesús xeroyoj ri rachibila', y xbij cheque: Tiya' k'ij richin que ri ac'uala' nyepu'u viq'uin yin, y man que'ik'üt. Roma ri nye'oc pa ruk'a' ri Dios, xaxe ri ye cachi'el ri ac'uala'. ");
INSERT INTO cakENT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Y ketzij c'a ninbij chive, que ri xa man nquibün tüj cachi'el ri ac'uala' richin que nquijüch-qui' pa ruk'a' ri Dios, man nye'oc tüj c'a pa ruk'a' ri Dios, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Y c'o c'a jun achi ri nim ruk'ij, xuc'utuj chin ri Jesús: Rat utzilüj Maestro, ¿achique c'a c'uluman que ninbün yin richin que ninvichinaj ri c'aslen ri man nq'uis tüj? xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Y ri Jesús xbij chin: ¿Achique roma tok nabij utz chuve yin? Roma man jun vinük ri utz, xaxe ri Dios ri utz. ");
INSERT INTO cakENT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Y yin ninbij que rat jabel avetaman ri diez mandamientos ri xuya' ri Dios pa ruk'a' ri Moisés ri ojer can, que rat achi ri c'o avixjayil man tacanoj chic jun ixok. Man cacamsan. Man catelek'. Man tatz'uc tzij chirij jun chic vinük. Taya' quik'ij ri ate-atata', xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Y ri achi xbij chin ri Jesús: Yin c'a co'ol tok nubanun-pe ronojel ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tok ri Jesús xrac'axaj quiri', xbij: C'a c'o jun ri man abanun tüj. Man atalun tüj ri abeyomal chiquivüch ri vinük ri manak quichajin. Tac'ayij c'a ronojel ri achajin y ri rajil tataluj chiquivüch ri vinük ri manak quichajin, richin quiri' nc'uje' abeyomal chila' chicaj. Y catampe c'a viq'uin y quinatzeklebej, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Y tok ri achi xrac'axaj ri xbij ri Jesús, juis xbison pa ránima, roma juis ri beyomül ruchajin y man nrajo' tüj ntel pa ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Y tok ri Jesús xutz'et que xa xpu'u juis bis pa ránima ri achi, xbij: Ri c'o quibeyomal, juis c'ayuf richin que nye'oc pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Xa más man c'ayuf tüj que nc'o ri jun chico rubini'an camello chupan ri jul c'o chirachük ri jun bak, que jun beyon ntoc ta pa ruk'a' ri Dios, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ri xe'ac'axan ri xbij ri Jesús, xquibila' c'a: Si cachi'el ri nbij, quiri', man jun ncolotüj, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Y ri Jesús xbij cheque: Ri vinük man nyetiquer tüj nquicol-qui'. Jac'a ri Dios ronojel ntiquer nbün, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jari' tok xpu'u ri Pedro xbij: Rat avetaman que roj kayo'on can ri kachajin, richin rat katzekleben. ");
INSERT INTO cakENT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Y ri Jesús xbij c'a cheque: Ketzij ninbij chive, que achique na vinük nc'atzinej ri nuc'ul, si ruyo'on can racho, rute-rutata', runimal o ruchak', rixjayil o ralc'ual, richin nbün rusamaj ri Dios y nyeruto' ri nye'oc pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Q'uiy c'a ri nuc'ul chupan ri tiempo ri katz'amon-apu. Y chupan apu ri jun chic tiempo chikavüch apu, nuc'ul c'a ri ruc'aslen ri xa man nq'uis tüj. ");
INSERT INTO cakENT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Y ri Jesús xaxe c'a quiq'uin ri ye doce rachibil xeroyoj richin xch'o cheque, y xbij: Rix ivetaman que pa tinamit Jerusalén katz'amon-e bey. Y chiri', q'uiy ri nban chuve yin ri xinalüx chi'icojol. Ronojel vi c'a ri tz'iban can pa nuvi' nbanatüj, cachi'el ri quitz'iban can ri achi'a' ri xek'alajrisan ri rutzij ri Dios ojer can. ");
INSERT INTO cakENT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nquijach c'a pa quik'a' vinük ri xa man ye israelitas tüj. Y ri vinük ri' nyetze'en chuvij, nquibila' pokon tak tzij chuve y yinquichubaj. ");
INSERT INTO cakENT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yinquich'ey, y c'ateri' yinquicamsaj. Pero pa rox k'ij nquic'astüj c'a pe, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero ri achibila' man xk'ax ta cheque ri xbij ri Jesús. Ri tzij ri' xa evan c'a chiquivüch, roma c'a ri' xaxe choj xcac'axaj y man quetaman tüj achique ntel chi tzij. ");
INSERT INTO cakENT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tok ri Jesús nakaj chic ntoc apu pa tinamit rubini'an Jericó, chiri' chuchi-bey tz'uyul c'a jun achi. Y ri achi ri' xa moy, y nuc'utula' limosna cheque ri vinük ri nyetobos chiri'. ");
INSERT INTO cakENT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Y tok ri moy ri' xrac'axaj que sibilüj vinük ri nyec'o-e, xuc'utuj c'a que achique xc'ulachitüj. ");
INSERT INTO cakENT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Y xquibij chin que ja ri Jesús aj-Nazaret ri nc'o-e chiri'. ");
INSERT INTO cakENT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Y ri achi moy riq'uin ruchuk'a' xch'o, y xbij c'a: Tajoyovaj nuvüch rat Jesús, ri rat ruxquin-rumam can ri rey David, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Y ri vinük c'a ri ye nabey e chuvüch ri Jesús, xquibila' chin ri achi que man tich'o chic. Pero rija' xa riq'uin más ruchuk'a' xch'o, y xbij: Rat ri ruxquin-rumam can ri rey David, tajoyovaj nuvüch roma ri nubanun, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Y ri Jesús xrac'axaj c'a ri rutzij. Romari' xpa'e-ka y xbij que tiquic'ama-pe. Y tok c'amon chic pe c'a ri achi riq'uin, xuc'utuj c'a chin: ");
INSERT INTO cakENT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Achique c'a ri najo'? Y ri achi moy xbij: Ajaf, yin ninjo' nquitzu'un, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Y ri Jesús xbij chin: Catzu'un c'a. Roma ri xaya' avánima viq'uin, xac'achoj. ");
INSERT INTO cakENT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Y ri achi moy jari' tok xtzu'un y xtzeke-e chirij ri Jesús. Ri achi re' chuka' nuya' ruk'ij ri Dios. Y conojel ri vinük ri xetz'eton que ri moy xtzu'un, xquiya' c'a chuka' ruk'ij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Y jari' tok ri Jesús rachibilan ri rachibila' xoc-apu pa tinamit rubini'an Jericó, y nc'o-e. ");
INSERT INTO cakENT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Y chiri' chupan ri tinamit ri' c'o c'a jun achi beyon rubini'an Zaqueo. Ri achi ri', jare' ri c'o más ruk'ij que chiquivüch ri ch'aka chic moloy tak alcaval. ");
INSERT INTO cakENT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Y rija' nutij c'a ruk'ij richin nutz'et-e ri Jesús, pero roma c'a ri ye juis vinük y xa vit co'ol chuka' ri rakün, xa man ntiquer tüj nutz'et-e. ");
INSERT INTO cakENT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Romari' rija' junanin xnabeyüj-e y xbejote' pa rutza'n jun che' ri nbix sicómoro chin, richin quiri' nutz'et-e ri Jesús, roma chiri' nc'atzinej que nc'o-vi-e. ");
INSERT INTO cakENT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Y tok ri Jesús xc'o c'a e chiri', xtzu'un chicaj pa ruk'a' ri che', y xbij c'a chin ri jotol chiri': Zaqueo, chanin caka-ka-pe chiri', roma ja ri vocomi nc'atzinej que nquinapon chi'avacho, richin que nquinuxlan ba', xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Y ri Zaqueo jari' xka-ka-pe junanin, y riq'uin quicot xuc'ulu' ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tok xbanatüj c'a quiri', ri vinük nquibila' c'a que ri Jesús xa pa racho jun achi aj-mac xbecanaj-vi can roma ri Zaqueo jun moloy alcaval. ");
INSERT INTO cakENT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Y ri Zaqueo pa'ül c'a tok xch'o chin ri Ajaf Jesús y xbij c'a: Ajaf, vocomi nic'aj chin ri nubeyomal nintaluj chiquivüch ri vinük ri manak quichajin. Y ri vinük ri c'o velesan cheque, caji' chic c'a ri nintzolij cheque, man xe tüj chic ri xinvelesaj cheque, roma yin xinc'o ruvi' ri tumin ri xinc'utuj cheque, man xaxe tüj chic ri tumin ri nc'atzinej que nquitoj chin ri gobierno, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Y ri Jesús xbij chin: Ri colonic xka-pe chere' pan avacho vocomi, roma rat xaya' avánima cachi'el xuya' ránima ri jun kaxquin-kamama' ojer can, ri rubini'an Abraham. ");
INSERT INTO cakENT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Roma yin ri xinalüx chi'icojol, yin petenük-vi chiquicanoxic y chiquicolic ri yec'o pa mac, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Y tok ri Jesús rubin chic ka ronojel ri' cheque ri vinük, xutz'om rubixic jun ejemplo cheque. Quiri' xbün roma nakaj chic yec'o-vi chin ri tinamit Jerusalén y roma chuka' ri vinük ri nye'ac'axan richin, nquinuc que tok rija' ntoc-apu pa tinamit, nyetz'uye' can pan autoridad richin quiri' ntz'amatüj yan nk'alajin ri utzilüj ru-gobierno ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Y rija' xbij c'a: Xc'uje' c'a jun achi ri juis nim ruk'ij. Ri achi ri' xbe c'a pa jun chic ruch'ulef ri c'anüj c'o-vi, richin nban-pe rey chin. Y c'ateri' ntzolij-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pero tok c'a man jani c'a tibe, xeroyoj ye diez rusamajela' y xuya' can jun moneda k'anapük pa tak quik'a' chiquijujunal, y xbij cheque: Tic'uaj c'a ri tumin ri xinya' can chive richin c'o nich'üc chirij, hasta jampe' nquitzolij-pe yin, xbij can cheque, y xbe. ");
INSERT INTO cakENT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Y tok c'o chic c'a chupan ri ruch'ulef ape' nc'atzinej que napon-vi richin nban-pe rey chin, yec'o c'a achi'a' ri ye benük pa quibi' conojel ri ruvinak ri xe'apon c'a ape' c'o-vi rija'. Y ri achi'a' ri' xbequibij: Roj man nkajo' tüj que ri achi re' ntoc rey pa karuch'ulef, xquibij. Ri ye takayon c'a e ri achi'a' ri', juis c'a nquetzelaj ri achi ri nban-pe rey chin. ");
INSERT INTO cakENT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Y man riq'uin tüj ri' ri jun achi ri' xban-pe rey chin, y xtzolij c'a. Y tok c'o chic pa ruruch'ulef, xutük c'a coyoxic ri rusamajela' ri xuya' can tumin pa quik'a' tok rija' c'a man jani xbe, roma nrajo' nrac'axaj jampe' tumin quich'acon chiquijujunal. ");
INSERT INTO cakENT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tok xapon c'a ri nabey samajel, xbij: Ajaf, ri tumin xajüch can pa nuk'a' richin c'o ninch'üc chirij, xinch'üc na vi ca'i' diez mul chic tumin chirij, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Y ri achi, rey chic ri tiempo ri', xbij c'a chin ri rusamajel: Jabel utz ri xabün. Rat jun utzilüj samajel. Y roma c'a ri utz xabün riq'uin ri ba' ri xinya' can pan ak'a', vocomi c'a ninya' diez tinamit pan ak'a' richin nabün mandar pa quivi', xbij ri rey. ");
INSERT INTO cakENT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Y jari' tok xapon jun chic samajel, y xbij: Ajaf, ri tumin ri xaya' can pa nuk'a' tok xabe, xinch'üc vo'o' mul chic tumin riq'uin, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Y ri rey xbij c'a chuka' chin ri jun samajel re': Roma utz ri xabün riq'uin ri ba' ri xinya' can pan ak'a', vocomi c'a ninya' vo'o' tinamit pan ak'a' richin nabün mandar pa quivi', xbij chuka' ri rey chin. ");
INSERT INTO cakENT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jac'a ri jun chic samajel ri xapon, xbij: Ajaf, ja tumin re' ninya' can chave. Ri tumin re' xinpis pa jun su't richin xinyüc. ");
INSERT INTO cakENT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Roma yin ninxbij-vi' chavüch. Roma rat jun achi juis rat ch'ojinel. Xa najo-vi c'a ncach'acon. Rat xa rat junan vi riq'uin jun achi ri nyeruc'utuj rutumin pa banco y xa man jun tumin ruyo'on can chiri'. Y chuka' najo' nac'ul ri ntel-pe chuvüch ri ticoj ri xa man rat tüj xaticon-ka, xbij ri samajel chin ri rey. ");
INSERT INTO cakENT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Y ri rey xbij c'a chin ri samajel ri': Rat man rat jun utzilüj samajel tüj. Ri tzij ri xabij jari' ri nincusaj richin ninbün juzgar pan avi'. Roma si avetaman que yin yin ch'ojinel vi, que yin ninch'ojij-vi nutumin ape' xa man jun nuyacon tüj, y chuka' ninjo' ninc'ul ri ntel-pe chuvüch ri ticoj ri xa man ja tüj yin xinticon-ka, ");
INSERT INTO cakENT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","si quiri' nabij rat, ¿achique c'a roma tok man xaya' tüj ri nutumin pa kajic? Richin quiri' ninc'ul ta c'a ri tumin ri vichin yin y c'o ta chuka' ral ninc'ul vocomi tok xintzolij-pe, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Y ri rey xbij c'a cheque ri yec'o chiri': Tic'ama' c'a can la tumin pa ruk'a', y tiya' chin ri nusamajel ri xch'acon diez mul chic tumin. ");
INSERT INTO cakENT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Y ri yec'o chiri' xquibij: Ajaf, ri tumin ri xuch'üc, pa ruk'a' rija' c'o-vi, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pero rija' xbij cheque: Yin ninbij c'a chive, que ri c'o, ruchajin, nuc'ul más. Jac'a ri man jun oc ruchajin, jani' oc ri ruchajin ntelesüs chin. ");
INSERT INTO cakENT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Vocomi c'a, ninjo' nquich'o chiquij ri nye'etzelan vichin, y ri xejo'on que man ta xinoc can rey: Ja que'ic'amala-pe, y c'a chinuvüch yin que'icamsala-vi, xbij ri rey. Quiri' xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Y tok ri Jesús xtane' yan ka chubixic chiquivüch ri vinük, xutz'om c'a bey chiquivüch ri rachibila'. Benük c'a chiquivüch, quitz'amon-e bey pa tinamit Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Y ja tok ya nakaj chic nye'apon apu pa tinamit Betfagé y ri tinamit Betania ri yec'o chuvüch ri juyu' rubini'an Olivos, ri Jesús xerutük c'a e ye ca'i' cheque ri rachibila', ");
INSERT INTO cakENT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","y xbij-e cheque: Quixbiyin-apu la pa vit tinamit la', y ja tok ya nyixoc-apu, jari' nivil jun alaj burro ximil can chiri'. Y c'a man jani jun tz'uybeyon chin. Tisolo' c'a pe y tic'ama-pe chuve. ");
INSERT INTO cakENT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Y si c'o jun nch'o-pe chive que achique roma tok rix nisol-e ri alaj burro ri', tibij c'a chin que nc'atzin chin ri Ajaf, xbij-e cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ri ca'i' achibila' ri xetak-e, xebe c'a, y xquil na vi ri burro, cachi'el ri bin-e cheque roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ja tok nyetajin chusolic, ri ye rajaf xquibij-pe cheque: ¿Achique roma tok nisol-e? xquibij-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Y ri rachibila' ri Jesús xquibij c'a cheque ri ye rajaf ri burro: Xa nc'atzin chin ri Ajaf, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Y xquic'ün-pe chin ri Jesús. Y rije' xquiya' c'a chuka' quitziek ri cachi'el coton chirij ri burro ri', y xquitz'uyuba-e ri Jesús chirij. ");
INSERT INTO cakENT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Y tok benük c'a ri Jesús, ri vinük nquiriq'uila' c'a ka ri quitziek ri cachi'el coton pa rubey richin nquiya' ruk'ij. Y quiri' c'a nquibanala' ye benük. ");
INSERT INTO cakENT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ja tok xa ja nquitz'om yan ka ri xulan richin ri juyu' Olivos, conojel ri ye tzeklebey richin ri Jesús ye benük, roma nquicot ri cánima, nquiya' c'a ruk'ij ri Dios. Nquiya' c'a ruk'ij ri Dios roma ri milagros ye quitz'eton riq'uin ri Jesús. Y riq'uin c'a cuchuk'a' nquibila'. ");
INSERT INTO cakENT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Rije' nquibij c'a: ¡Que ri Ajaf Dios nbün ta bendecir ri Rey ri pa rubi' vi ri Ajaf Dios petenük-vi! ¡Quicot c'a ri chila' chicaj! ¡Juis c'a ruk'ij nuc'ul ri Dios ri chila' chicaj! nquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Y chiri' chiquicojol ri vinük, ye benük c'a ch'aka achi'a' fariseos. Y rije' xquibij c'a chin ri Jesús: Maestro, xquibij chin. Tabij cheque ri ye tzeklebey avichin que man tibij quiri', xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jac'a ri Jesús xbij cheque: Ketzij ninbij chive, que si nyetane-ka rije', ja ri abüj nyebech'o-pe richin nquiya' nuk'ij, xbij cheque ri achi'a' fariseos. ");
INSERT INTO cakENT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Y ri Jesús xutz'et c'a ri tinamit Jerusalén, tok más nakaj chic yec'o-vi-apu. Rija' xrok'ej c'a ri tinamit ri', ");
INSERT INTO cakENT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","y xbij c'a: Rix ri rixc'o pa Jerusalén, stape' (aunque) c'a ja ta ri k'ij re' nk'ax ta chive ri achique nyo'on uxlanen pa tak ivánima. Pero xa evan can chivüch, y romari' man nyixtiquer tüj nitz'et. ");
INSERT INTO cakENT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Roma nibevila' c'a k'ij richin k'oxon, k'ij tok achi'a' banuy-oyoval nyebecatüj-pe chivij, y nquisutij rij ri itinamit riq'uin jun chic tz'ak, y nyixquiya' pa pokonül, roma pa quinic'ajal nyixc'uje-vi can. ");
INSERT INTO cakENT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nquikasaj c'a pan ulef ri itinamit ivachibilan rix. Y chin ri itinamit man jun c'a jay ri npa'e' can. Ronojel-ronojel nyevulüx. Roma man nitz'et tüj que ri Dios xka-pe yan iviq'uin, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Y tok ri Jesús xapon chic c'a chiri', rija' xoc-apu pa racho ri Dios ri c'o chiri' pa Jerusalén. Jari' tok rija' xerokotala-pe ri c'ayinela' y ri nyelok'on chiri' pa racho ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Y xbij c'a chuka' cheque: Chupan ri rutzij ri Dios ri tz'iban can, nbij que ri vacho, jay richin oración. Jac'a rix xa cachi'el quijul elek'oma' ibanun chin, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Y jari' tok ri Jesús k'ij-k'ij xerutijoj ri vinük riq'uin ri rutzij ri Dios, chiri' chupan ri racho ri Dios. Pero ri más nimalüj tak sacerdotes cachibilan ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri achi'a' ri c'o-vi quik'ij chupan ri tinamit, nquicanola' c'a achique ta nquibün richin quiri' nquicamsaj ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Y man nquil tüj c'a achique nquibün, roma ri vinük coyoben-vi ri nbij ri Jesús cheque. Nka-vi chiquivüch ncac'axaj ri achique nuk'alajrisaj ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Y chupan jun cheque ri k'ij ri', tok ri Jesús c'o pa racho ri Dios nuc'ut y nutzijoj ri utzilüj tzij richin colonic cheque ri vinük, jari' tok xeka-pe riq'uin, ri más nimalüj tak sacerdotes, ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés cachibilan ri rajatük tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Y ri achi'a' ri' xquibij c'a chin ri Jesús: Tabij c'a cheke: ¿Achique xyo'on autoridad pan ak'a' richin xe'avokotaj-e ri vinük c'ayinela' pa racho ri Dios? ¿Y achique xyo'on k'ij chave richin que q'uiy ri nye'abanala' chiquicojol ri vinük? xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Y ri Jesús xbij c'a cheque: Yin c'o c'a jun chuka' ri ninjo' ninc'utuj chive. Tibij c'a chuve: ");
INSERT INTO cakENT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ri Juan xtak-pe roma ri Dios richin xerubün bautizar ri vinük? ¿O xa vinük xebin chin que tubana' quiri'? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pero ri más nimalüj tak sacerdotes, ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés y ri rajatük tak achi'a' ri c'o quik'ij, xquibila' c'a chiquivüch: ¿Achique c'a nkabij chin ri Jesús vocomi? xquibij-ka. Roma si nkabij que ri Juan ja ri Dios takayon-pe chin, ri Jesús nbij c'a cheke que achique c'a roma tok man xitakej tüj. ");
INSERT INTO cakENT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y si nkabij que xa vinük xebin chin ri Juan que tubana' quiri', nyepu'u conojel vinük chikij y nkujquicamsaj chi abüj. Roma ri vinük quetaman-vi que ri Juan xuk'alajrisaj-vi ri xbix chin roma ri Dios, xquibij-ka chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Y c'ateri' xquibij-apu chin ri Jesús que man quetaman tüj achique xbin chin ri Juan que querubana' bautizar ri vinük, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Y ri Jesús xbij c'a cheque ri achi'a' ri': Roma c'a rix man xixtiquer tüj xibij chuve, quiri' c'a yin chuka' man ninbij tüj chive achique yo'on k'ij chuve richin nyenbanala' quere', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Y ri Jesús xutz'om c'a nch'o chiquivüch ri vinük. Xutz'om rubixic jun ejemplo cheque, y xbij c'a: C'o c'a jun achi ri xutic ruvüch ri rulef riq'uin uva. Y c'ateri' xuya' can pa kajic cheque ca'i-oxi' samajela'. Y rija' xbe richin q'uiy tiempo. ");
INSERT INTO cakENT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Y ri rajaf ri ulef ri' xutük c'a jun raj-ic' achi quiq'uin ri achi'a' ri ye kajayon ri ulef, tok tiempo chic richin que nquiya' ri uva kajbül richin ri ulef. Jac'a tok xapon ri aj-ic' quiq'uin ri achi'a' ri ye kajayon ri ulef, ri kajoy tak ulef ri' xquitz'om c'a ri aj-ic' y xquich'ey, y man jun c'a uva xquiya-e chin. ");
INSERT INTO cakENT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Y ri rajaf ri ulef xutük chic jun raj-ic' achi chuc'amic ruvüch ri uva kajbül richin ri ulef. Pero ri achi'a' kajoy tak ulef xa xquitz'om y xquich'ey. Q'uiy c'a ri xquibanala' y xquibila-e chin, y chuka' man jun ruvüch ri uva kajbül richin ri ulef xquiya' ta e chin. ");
INSERT INTO cakENT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pero ri rajaf ri ulef xutük chic c'a e jun raj-ic' achi chuc'amic ri uva kajbül richin ri ulef, pero ja quiri' chuka' xuc'ulachij. Xquisocola', y c'ateri' xcokotaj-e. ");
INSERT INTO cakENT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Y pa ruq'uisbül c'a, ri rajaf ri ulef xbij: ¿Achique c'a nintük-e? xbij. Y rija' c'o c'a jun ruc'ajol ri juis nrajo', y jari' ri xutük-e chuc'amic ri uva, kajbül richin ri ulef. Roma ri rajaf ri ulef ri' xunuc-ka que ri achi'a' ri ye kajayon ri rulef, riq'uin ba' nquitakej-vi tok nquitz'et que ja ri c'ajol ri napon. ");
INSERT INTO cakENT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero ri achi'a' ri ye kajayon ri ulef, xe xquitz'et ri ruc'ajol ri rajaf ri ulef, xquibij c'a chiquivüch: Jare' ri nchinan can ronojel ri ulef ri kakajon vocomi. ¿Achique roma man nkacamsaj? Richin quiri' pa kak'a' roj nc'uje-vi can ri ulef, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Y quiri' vi c'a xquibün. Xquelesaj-pe ri c'ajol chiri' chupan ri rulef y xquicamsaj. C'ateri' ri Jesús xbij: ¿Achique comi nbün ri rajaf-ulef quiq'uin ri achi'a' kajoy tak ulef? ");
INSERT INTO cakENT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ri rajaf ri ulef npu'u c'a y nyerucamsaj ri kajoy tak ulef ri' y ri rulef nuya' chic can pa kajic cheque ch'aka chic, xbij ri Jesús. Tok ri vinük cac'axan chic ka ronojel ri', xquibij: Man jun bey nbanatüj ta quiri', xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Y ri Jesús xerutz'eta' c'a ri vinük, y xbij: ¿Achique comi ntel chi tzij que nbij chupan ri rutzij ri Dios ri tz'iban can? Tok nbij: C'o c'a jun abüj ri man xka' tüj chiquivüch ri ch'aka banuy tak jay. Pero ri abüj ri' xch'acon-vi, roma ri abüj ri' xa c'o-vi ri xucusan chin, richin xbün ri jay y richin que ri jay ri' man ntzak tüj, nbij, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Y ri vinük c'a ri ntzak chuvüch ri jun abüj ri', nupaxij-ri' chuvüch. Y ri vinük ri xtitzak ri abüj ri' chirij, nuque'ej c'a, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Y ri más nimalüj tak sacerdotes, y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés, ja yan c'a ri' tok xcajo' ta rije' nquitz'om-e ri Jesús, roma nquinabej que ri achi'a' kajoy tak ulef ri xerucusaj chupan ri ejemplo, xa chiquij rije' xch'o-vi. Pero man xquitz'om tüj e, roma xa nquixbij-qui' chiquivüch ri vinük ri yec'o riq'uin ri Jesús, xa xebe. ");
INSERT INTO cakENT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Y ri más nimalüj tak sacerdotes y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés ri' xequitük c'a pe ch'aka chic achi'a' ri choj ri quic'aslen nk'alajin, pero xa man ye quiri' tüj. Rije' xa ncajo' c'a nquiya' ta pa c'ayuf ri Jesús, y ntzak ta pa quik'a' riq'uin ri tzij ri nbij. Y si ntzak c'a ri Jesús pa quik'a', nquiya' pa ruk'a' ri gobernador. ");
INSERT INTO cakENT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Y richin c'a que nquiya' pa c'ayuf ri Jesús, ri achi'a' ri' xquic'utuj c'a chin: Rat ri rat jun Maestro, roj ketaman-vi que ketzij ri natzijoj. Man naxbij tüj avi' chuvüch jun vinük, stape' (aunque) juis ruk'ij. Y nac'ut-vi ri rutzij ri Dios pa rubeyal. ");
INSERT INTO cakENT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tabij c'a cheke: ¿C'uluman comi nkatoj ri alcaval ri nbij ri rey César ri nc'atzinej que nkatoj, o xa man c'uluman tüj que nkatoj chin? xquibij chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero ri Jesús retaman-vi c'a ri nquinuc chirij rija'. Romari' rija' xbij c'a cheque: ¿Achique c'a roma rix nitij ik'ij richin nquinitij yin? ");
INSERT INTO cakENT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tic'utu' c'a pe ri tumin, xbij. Y ri Jesús xuc'utuj c'a: ¿Achique chok vachbül la'? ¿Y achique chok bi' chuka' la c'o chuvüch la tumin? Y rije' xquibij chin: Richin ri rey César, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Y ri Jesús xbij c'a cheque: Titojo' ri alcaval chin ri César riq'uin ri tumin ri c'uluman que niya' chin rija'. Y tiya' chin ri Dios, ronojel ri c'uluman que niya' chin rija', xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Y ri achi'a' ri xec'utun chin ri Jesús, man jun chic c'a xech'acon tüj chirij, roma ri Jesús ronojel tzij pa rubeyal nyerubila' cheque chiquivüch ri vinük. Y xe' xquica'yej tok xcac'axaj ri xbij ri Jesús cheque. Y romari' man xech'o tüj chic apu. ");
INSERT INTO cakENT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Y jari' tok ch'aka cheque ri achi'a' saduceos xe'apon riq'uin ri Jesús. Ri achi'a' ri' man nquitakej tüj c'a que ri caminaki' nyec'astüj chic pe. Y roma c'a ri' rije' xquibij chin ri Jesús: ");
INSERT INTO cakENT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Rat ri rat jun Maestro chuka', c'o c'a jun ri nkajo' nkac'utuj chave. Ri Moisés rutz'iban-vi can c'a cheke que tok jun achi nuya' can ri rixjayil roma ri ncom-e y man jun ralc'ual nuya' can, jun c'a runimal-ruchak' rija' nc'atzinej que nc'ule' riq'uin ri malca'n-ixok, richin quiri' nyec'uje' ta ralc'ual riq'uin ri ixok malca'n. Y si yec'o ralc'ual ncanaj riq'uin ri ixok, ri nabey ala' ntoc ralc'ual ri camnük chic e. ");
INSERT INTO cakENT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Y rije' xquibij c'a: Quiri' c'a xec'uje' ye siete achi'a' quichak'-qui'. Ri nabey xc'ule'. Pero xcom-e, y man jun ralc'ual xuya' can. ");
INSERT INTO cakENT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Xpu'u ri ruca'n achi, ri ruchak' can ri achi ri camnük chic e, xc'ule' c'a riq'uin ri malca'n-ixok. Pero chuka' ri achi ri' xcom-e, y man jun ralc'ual xuya' can. ");
INSERT INTO cakENT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ri rox achi xc'ule' c'a chuka' riq'uin ri malca'n-ixok, pero cachi'el ri xquic'ulachij-e ri ye ca'i' nabey runimal, quiri' chuka' xuc'ulachij-e rija'. Y chi siete achi'a' quichak'-qui' quiri' xquic'ulachila-e. Y man jun c'a cheque ri siete achi'a' ri' xuya' ta can ralc'ual. ");
INSERT INTO cakENT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Y pa ruq'uisbül xcom e ri ixok chuka'. ");
INSERT INTO cakENT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Y ri achi'a' saduceos xquibij c'a chin ri Jesús: Rat nabij que napon jun k'ij tok ri caminaki' nyec'astüj-pe. Tok napon c'a ri k'ij ri', ¿achique c'a chok rixjayil c'a ntoc ri ixok ri'? Roma chi siete achi'a' quichak'-qui' xec'uje' riq'uin, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Y ri Jesús jari' tok xbij cheque: Chuvüch ri ruch'ulef, ri vinük c'a nyec'ule' na c'a y c'a nyeyo'on na quimi'al-quic'ajol richin nyec'ule'. ");
INSERT INTO cakENT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Jac'a ri ye caminaki' chic e, manak chic c'ulubic chiquivüch. Romari' ri nyec'astüj-e y yo'on k'ij cheque richin nyebe chila' chicaj, man nyec'ule' tüj chic, nixta man nquiya' tüj e chuka' quimi'al-quic'ajol richin nyec'ule'. ");
INSERT INTO cakENT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Roma rije' man napon tüj chic ri camic quiq'uin, roma nye'oc cachi'el ri ángeles y chuka' ye ralc'ual ri Dios roma ye c'astajnük chic e. ");
INSERT INTO cakENT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Y ri caminaki' nyec'astüj-vi. Roma ri Moisés rutz'iban can chupan ri rutzij ri Dios, tok rija' xutz'et ri ruxulu-quiej, ri jun k'ayis c'o ruq'uixal, nc'at, y xrac'axaj tok xbij ri Dios: Ja yin ri ru-Dios ri Abraham, ri ru-Dios ri Isaac, y ri ru-Dios chuka' ri Jacob, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Y si ta rije' ye camnük chi jumul, y xa man ta nyec'astüj pe jun bey chic, ri Dios man ta qui-Dios rije', roma ri Dios qui-Dios vi ri c'o quic'aslen y man quichin tüj ri caminaki'. Roma chuvüch ri Dios rije' ye c'üs vi, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Y yec'o c'a cheque ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés ri xquibij chin ri Jesús: Maestro, xquibij chin. Ketzij vi ri xabij, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y man xquibün tüj chic c'a xquicovij-qui' richin c'o ta xquic'utuj-apu chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Y c'ateri' ri Jesús xbij c'a cheque: ¿Achique roma tok nbix que ri Cristo xa choj jun ruxquin-rumam can ri rey David? ");
INSERT INTO cakENT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tok xa ja ri rey David biyon can chupan ri vuj ri rubini'an Salmos: Que ri Ajaf Dios xbij chin ri Vajaf ri Cristo: Catz'uye-pe pa vajquik'a' (nu-derecha), ");
INSERT INTO cakENT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","y nyenya' pan ak'a' ri nye'etzelan avichin, nbij. ");
INSERT INTO cakENT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Y k'alüj vi c'a que ri rey David tok xc'ase' chere' chuvüch ri ruch'ulef, xbij Vajaf chin ri Cristo. ¿Y achique c'a roma tok nbix que ri Cristo xa choj jun ruxquin-rumam can ri rey David? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Y conojel c'a ri vinük ri quimolon-qui' chiri', xcac'axaj tok ri Jesús xbij cheque ri rachibila': ");
INSERT INTO cakENT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Man tibün c'a cachi'el nquibün ri achi'a' ye etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés. Roma rije' jabel nka' chiquivüch nquicusaj tukutük tak tziük, richin quiri' titz'etüj que juis quik'ij. Juis chuka' nka' chiquivüch que yo'ox rutzij quivüch pa bey ape' nyequimolo-vi-qui' ri vinük. Y pa tak jay ape' ntzijos-vi ri rutzij ri Dios, ja ri nabey tak ch'acüt nyequicanola', richin quiri' tibix que juis quik'ij. Y quiri' c'a chuka' nyequibanala' pa nimak' tak va'in. ");
INSERT INTO cakENT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Y ri achi'a' c'a re' chuka' nyequelesala' ronojel qui-cosas ri malcani'a' tak ixoki'. Y xe richin quenimüx que rije' ye utz tak vinük, nyelayuj tok nyequibanala' oración chin ri Dios. Pero rije' nka-ka-vi más ru-castigo pa quivi', roma ri quimac juis q'uiy, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Chiri' c'a pa racho ri Dios, ri Jesús xerutz'et c'a que ri vinük beyoma' nquiyala' can tumin chiri' ape' nyalox-vi can ri tumin pa racho ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Y quiri' c'a chuka' xutz'et jun malca'n-ixok ri nk'alajin que man beyon tüj, que xuya' can ca'i' tak tumin ri manak oc rakalen ni ta jun centavo. ");
INSERT INTO cakENT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Y tok ri Jesús xutz'et ri jun malca'n-ixok ri', xuc'ut c'a chiquivüch ri rachibila', y xbij cheque: Ketzij c'a ninbij chive que yin nintz'et que xa ja la ixok la' ri xyo'on can más q'uiy que chiquivüch ri ye yo'on can tumin. ");
INSERT INTO cakENT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Roma rija' stape' (aunque) manak oc ri ruchajin, xuya' c'a can ronojel ri ruchajin, y xuya' can chupan la ape' yec'o-vi ri sipanic ri ye banun chin ri Dios. Jac'a la beyoma', stape' (aunque) juis q'uiy tumin nquiyala' can, xa ba' oc chin ronojel ri beyomül ri quichajin, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Y yec'o c'a ri quitz'amon tzij pari' ri racho ri Dios. Y nquibila' c'a que juis jabel rubanic, que ruyon jabel tak abüj ri ye ucusan richin banun, y que ronojel ri vekbül ruyon sipanic quichin ri vinük, xquibij. Y ri Jesús xbij c'a cheque: ");
INSERT INTO cakENT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Napon c'a jun k'ij tok ronojel ri nitz'et chere' nyevulüx-ka y man nyepa'e' tüj chic can. Ronojel ri nimalüj tak abüj ri ye ucusan chin ri jay re', xa nyetorix c'a pe. Man jun c'a abüj ri nc'uje' ta can cachi'el la rubanun vocomi, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Y ri rachibila' xquic'utuj c'a chin ri Jesús: Maestro, xquibij. ¿Jampe' c'a nc'ulachitüj ri xabij yan ka pari' ri racho ri Dios? ¿Y achique retal richin quiri' ninabex que nbanatüj yan? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Y ri Jesús xbij cheque: Jabel c'a tichajij-ivi' richin man nyixch'acatüj. Roma ye q'uiy ri nyepu'u, nquibij: Ja yin ri Cristo. Ja tiempo ri' xka-pe, nquibij. Pero rix man que'itakej, nixta que'itzeklebej chuka'. ");
INSERT INTO cakENT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Y tok nivac'axaj c'a chuka' que yec'o ruch'ulef c'o oyoval ntajin chiquicojol o ri vinük pa ch'aka tinamit nquibanala-ka oyoval chiquivüch, man tixbij-ivi' c'a, roma nabey nc'atzinej na que nbanatüj quiri', pero man jani tüj ri' chuka' ri ruq'uisbül tak k'ij richin ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Y ri Jesús xbij c'a chuka': Jun tinamit ncatüj-e richin nberubana' oyoval riq'uin jun chic tinamit. Yec'o c'a chuka' ye nimak' tak ruch'ulef nyecatüj-e richin que nyequibana' oyoval quiq'uin ch'aka chic nimak' tak ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nyepu'u nimalüj tak cab-rakün, vayjül y yabil achique na lugar chin ri ruch'ulef. Nuya' c'a jun nimalüj xbiri' ri nyebanatüj y nyetz'etetüj chupan ri caj, ri man jun bey ye tz'eton tüj. ");
INSERT INTO cakENT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Y tok man jani tibanatüj ronojel ri', rix nyixtz'am y nban c'a chive que nitij pokonül, roma ri rutzij ri Dios. Nyixuc'u'üx c'a chiquivüch ri más nimalüj pa tak jay ape' ntzijos-vi ri rutzij ri Dios. Nyixtz'apis pa cárcel. Nyixuc'u'üx chiquivüch gobernadores, chiquivüch reyes y ch'aka chic autoridades. Ronojel c'a ri' nc'ulachij roma ic'uan ri nubi' yin. ");
INSERT INTO cakENT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Y tok quere' c'a nban chive coma ri vinük, jari' tok nyixtiquer nquinik'alajrisaj chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Y tika-pe c'a chi'ic'u'x que man jun nc'atzin-vi que rix juis ninuc ri achique nc'atzinej que nye'ibij richin nito-ivi', ");
INSERT INTO cakENT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","roma ja yin ri nquiyo'on tzij chive. Y ninya' chuka' etamabül chive richin quiri', riq'uin ri etamabül ri' ntz'apij quichi' ri nye'etzelan ivichin. ");
INSERT INTO cakENT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Y nyixjachalox c'a pa quik'a' ri nye'etzelan ivichin. Y xa ja ri ite-itata', ri inimal-ichak' o ri ye ivachibil ri nyejachon ivichin. Y yec'o c'a chive rix ri nyecamsüs. ");
INSERT INTO cakENT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Xa nyixetzelüs-vi c'a coma conojel, roma iyo'on ivánima viq'uin yin. ");
INSERT INTO cakENT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero man c'a tixbij-ivi', roma ri Dios nyixruchajij-nyixruvaraj, y chuvüch rija' man jun vit rusmal ivi' ri ntzak can choj quiri'. ");
INSERT INTO cakENT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Y si nicoch' ronojel, nivil c'a ri utzilüj c'aslen ri man nq'uis tüj. ");
INSERT INTO cakENT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Y tok nitz'et c'a que ri tinamit Jerusalén sutin rij coma achi'a' ye richin oyoval, tivetamaj c'a ri' que xa ba' chic tiempo nrajo' richin que ri tinamit nvulüx. ");
INSERT INTO cakENT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Romari', si rix rixc'o pa ruch'ulef Judea, quixanmüj c'a e y tibevevaj-ivi' pa k'ayis. Y si pa tinamit Jerusalén rixc'o-vi, quixanmüj c'a pe chupan. Y si pa k'ayis rixc'o-vi, man quixtzolij chic apu pa tinamit. ");
INSERT INTO cakENT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Roma tok napon c'a ri k'ij richin ri pokonül, jari' tok ri tinamit ri' nuc'ul ruq'uexel ronojel ri ye rubanalun, y nbanatüj c'a ronojel ri tz'iban can chupan ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Y chupan ri k'ij ri' nc'o c'a ruvi' pokonül npu'u pari' ri ruch'ulef. Nka-ka c'a ri ru-castigo ri Dios pari' ri tinamit re'. Y roma ri pokonül ri', c'ayuf c'a nbün cheque ri ixoki' ri coyoben chic que nyec'achoj riq'uin jun ac'ual y chuka' c'ayuf nbün cheque ri ixoki' ri c'a nquiya' na quitz'un ri cal. Juya' quivüch c'a ri ye te'ej chupan ri tiempo ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ye juis c'a q'uiy vinük nyecom pa quik'a' ri achi'a' ye richin oyoval. Y ri ch'aka chic cheque ri vinük nye'uc'u'üx-e coma ri achi'a' ye richin oyoval. Nye'uc'u'üx c'a pa ch'aka chic ruch'ulef. Y ri tinamit Jerusalén nquiyek' vinük ri xa man ye israelitas tüj. Pero man richin tüj c'a chi jumul quiri' nquibün, roma ri k'ij ri yo'on cheque xa nc'o. ");
INSERT INTO cakENT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Y q'uiy c'a ri man jun bey ye banatajnük tüj y man jun bey ye tz'eton tüj nyec'ulachitüj chupan ri k'ij, ri ic' y ri ch'umila'. Y ri vinük c'a ri yec'o chuvüch ri ruch'ulef man nquil tüj achique nquibün, xa nsatz quic'u'x roma ri mar, nc'o c'a ruvi' nk'ajan, roma juis nbolko't. ");
INSERT INTO cakENT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Y ri vinük roma coyoben c'a ri achique nc'ulachitüj chuvüch ri ruch'ulef, npu'u quicamic roma ri xbiri' ri'. Roma hasta ronojel ri nimalüj tak uchuk'a' ri ye richin ri chicaj nyesilon roma ri ruchuk'a' ri Dios. Chi jun vi c'a ri caj nsilon. ");
INSERT INTO cakENT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Y jari' tok yinquitz'et yin ri xinalüx chi'icojol, que nquika-pe pa jun sutz', riq'uin chic nimalüj vuchuk'a' y riq'uin chic chuka' jun nimalüj nuk'ij, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Y ja rix, xbij ri Jesús cheque ri rachibila', tok nitz'et que ronojel ri' nyec'ulachitüj chic, quixquicot y tic'uje-e más ivuchuk'a', roma napon yan ri k'ij richin nyixcolotüj-e chuvüch ronojel pokonül richin ri ruch'ulef, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Y jari' tok rija' xbij chuka' jun ejemplo cheque: Titz'eta' na pe' ri che', xbij ri Jesús. Titz'eta' ri che' higuera o achique na chic chi che'. ");
INSERT INTO cakENT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tok xa nquitz'om yan pe quiq'uiylen ri quixak, ivetaman c'a ri' que ri ru-tiempo ri job ntzak yan. ");
INSERT INTO cakENT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Y quiri' c'a tok nitz'et que yec'o chic nyec'ulachitüj chupan ri k'ij, ri ic' y ri ch'umila', y ronojel ri xinbij yan ka nbanatüj chic, tivetamaj c'a ri' que nka-pe yan ri k'ij tok nbün mandar ri Dios. Rija' nc'uje' c'a chikacojol. ");
INSERT INTO cakENT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Y tivac'axaj c'a jabel ri ninbij chive vocomi: Ronojel re' nc'ulachitüj, tok ri vinük richin ri tiempo ri' c'a man jani queq'uis-e chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Y ri ruch'ulef y ri caj ye richin vi nyeq'uis. Jac'a ri nutzij man nq'uis tüj quiri', xa nbanatüj-vi ri nbij. ");
INSERT INTO cakENT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Y tichajij c'a ri ic'aslen. Man tibe ivánima chirij ri va'in. Man quixk'abür. Y chuka' man xaxe ri nc'atzin chive chuvüch ri ruch'ulef ri ninuc, y c'a tok nina' xa jari' xka-pe ri k'ij, richin que yin nquinka-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Xa nka-pe cachi'el jun trampa ri chanin nutz'om. Quiri' rubanic tok nka-pe pa quivi' conojel ri vinük ri yec'o chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Roma c'a ri' tichajij-apu jabel ri ic'aslen. Y tibana' chuka' orar chi jumul, richin nyixcolotüj chuvüch ronojel ri pokonül ri npu'u pari' ri ruch'ulef, y richin chuka' utz nyixapon c'a chinuvüch yin ri xinalüx chi'icojol, xbij ri Jesús cheque ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Y pak'ij, ri Jesús c'o c'a chiri' pa racho ri Dios, nyerutijoj ri vinük riq'uin ri rutzij ri Dios. Y chak'a' nbe chiri' pa juyu' rubini'an Olivos, y chiri' nc'uje-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y roma c'a ri Jesús nutzijoj ri rutzij ri Dios chiri' pa racho ri Dios, ye juis c'a vinük ri nye'apon cumaj yan richin ncac'axaj. ");
INSERT INTO cakENT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Y xa chuak'-cabij c'a ri quinimak'ij ri israelitas chiri', jun nimak'ij tok nquic'ux caxlan-vüy ri manak levadura riq'uin, y nquibij pascua chin. ");
INSERT INTO cakENT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Y jari' c'a tok ri más nimalüj tak sacerdotes y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés nquinucula' c'a achique ta modo nquibün richin quiri' nquicamsaj ri Jesús. Pero xa quixbin-qui' chiquivüch ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Y ri Judas ri jun cheque ri doce rachibila' ri Jesús, ri rachibil ri xbix chuka' Iscariote chin, nsamüj chic vi ri Satanás pa ránima. ");
INSERT INTO cakENT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Romari' ri Judas ri' xbe c'a quiq'uin ri más nimalüj tak sacerdotes y quiq'uin chuka' ri nye'uc'uan quichin ri ye chajinela' chiri' pa racho ri Dios, y xch'o quiq'uin pari' ri achique modo nbün richin nujüch ri Jesús pa quik'a'. ");
INSERT INTO cakENT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Y rije' juis c'a xequicot tok xcac'axaj ri', y xquisuj rutumin romari'. ");
INSERT INTO cakENT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ri Judas xberusuju' c'a can ri Jesús cheque. Y xutz'om c'a runuquic jampe' tok nujüch pa quik'a', y ja tok man quimolon tüj qui' vinük riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tok xka-pe ri nimak'ij, k'ij richin nc'uxtüj ri caxlan-vüy manak levadura riq'uin, y tok nyecamsüs chuka' ri xtak ovejas ri richin ri pascua, ");
INSERT INTO cakENT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ri Jesús xerutük c'a e ri Pedro y ri Juan, y xbij c'a e cheque: Quixbiyin y tibana' c'ojlen ri nkac'ux chupan ri pascua re'. ");
INSERT INTO cakENT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Y ri ca'i' achibila' xquic'utuj c'a chin: ¿Ape' c'a najo-vi que nkabün ruc'ojlen? ");
INSERT INTO cakENT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Y ri Jesús xbij cheque: Tok nyixapon pa tinamit Jerusalén, nitz'et c'a que c'o jun achi aj-ic' ri ruc'amon-pe ruya' pa jun cura'. Titzeklebej c'a e ri achi ri' c'a achique jay ntoc-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Y tibij c'a chin ri tata'aj chupan ri jun jay ri': Ri ka-Maestro rubin c'a pe: ¿Achique jay chere' pan avacho ri utz ta richin ninbün ri va'in richin ri pascua ye vachibilan ri vachibila'? quixbij chin. ");
INSERT INTO cakENT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Y ri rajaf-jay nyixruc'uaj c'a pa jun ruca'n piso chin ri jay. Y chiri' c'o jun nima-jay ri chojmirsan chic rupan. Ja chiri' tibana-vi c'ojlen ri nkac'ux richin ri pascua, xbij-e. ");
INSERT INTO cakENT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Y ri ca'i' achibila' xebe c'a. Y cachi'el ri rubin-e ri Jesús cheque, quiri' ri xquibana'. Y rije' xquibün-vi c'a c'ojlen ronojel ri nc'atzin richin ri va'in richin ri pascua ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Y tok xapon c'a ri hora, ri Jesús y ri doce apóstoles xetz'uye-apu chuvüch ri mesa. ");
INSERT INTO cakENT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Y ri Jesús xbij c'a cheque: Juis nurayin-pe que nabey que nquinapon chuvüch ri camic, junan nkabün can ri jun va'in richin ri jun pascua re'. ");
INSERT INTO cakENT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Roma ninbij-vi c'a chive, que ja tok c'o chic na ri k'ij tok nbün-vi mandar ri Dios, y tok banatajnük chic ronojel ri ntel-vi chi tzij ri pascua, c'a jari' tok ninbün chic ri jun va'in re'. ");
INSERT INTO cakENT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Y ri Jesús xutz'om c'a jun vaso ri c'o ruya'al-uva chupan, y tok rumatioxin chic chin ri Dios, xbij: Titija' c'a can chi'ivonojel. ");
INSERT INTO cakENT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Roma ninbij-vi c'a chive, que ja tok c'o chic ri k'ij tok nbün-vi mandar ri Dios, c'ateri' tok nintij jun bey chic ruya'al-uva. ");
INSERT INTO cakENT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Y quiri' c'a chuka' xuc'ün-apu jun caxlan-vüy, y tok rumatioxin chic chin ri Dios, xuper ri caxlan-vüy y xuya' cheque ri rachibila' y xbij: Re' chin nquinic'uxla'aj yin. Titija' c'a. Roma ri nuch'acul njach c'a richin que napon pa camic, richin nyixcolotüj. ");
INSERT INTO cakENT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Y tok ye vai'nük chic, ri Jesús xutz'om c'a chuka' ri vaso ri c'o ruya'al-uva chupan, y xbij: Ri ruya'al-uva re', jare' ri nuquiq'uel ri nbiyin tok nquicom. Riq'uin c'a ri nuquiq'uel re', jare' xc'achoj ri c'ac'a' trato ri rujo'on-pe ri Dios que nbün quiq'uin ri vinük. Ri nuquiq'uel ri nbiyin, richin que nyixcolotüj. ");
INSERT INTO cakENT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Y vocomi c'a, ri achi ri xquijachon-e pa quik'a' ri vinük, c'o c'a pe viq'uin chuvüch mesa. ");
INSERT INTO cakENT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tivac'axaj c'a ri ninbij chive, que yin ri xinalüx chi'icojol, nquibe-vi pa camic, roma jari' ri runucun ri Dios pa nuvi'. Pero juya' ruvüch c'a ri njachon-e vichin yin ri xinalüx chi'icojol, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Y jari' tok ri rachibila' ri Jesús nquibila-ka chiquivüch que achique comi ri njachon-e richin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Y ri rachibila' ri' xquich'ojila' c'a chuka' chiquivüch achique ri más nim ruk'ij chiquicojol rije'. ");
INSERT INTO cakENT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero ri Jesús xa xbij cheque: Ri reyes richin ri ruch'ulef, roma yec'o ri vinük pa quik'a', romari' nquina' que ja rije' ri ye cajaf. Y ri achi'a' c'o quik'a' cheque ri vinük, achi'a' ye banuy-utz nbix cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jac'a chi'icojol rix vachibila' man quiri' tüj. Roma ri más nim ruk'ij chi'icojol rix, nc'atzin que nuna-ka-ri' que xa más co'ol que chiquivüch ri rachibil. Y ri jun chive rix ri nc'uje' pan ivi', nc'atzin que nuna-ka-ri' que xa manak ruk'ij y xa vit oc tuna' ka richin nusuj-ri' chubanic achique na samaj. ");
INSERT INTO cakENT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Roma c'a ri', ¿ja comi ri c'o chuvüch mesa ri nilix-apu ri c'o más ruk'ij, o ja ri achique ri njachon? ¿Man ja tüj comi ri c'o chuvüch mesa ri nilix-apu ri más ruk'ij? Pero chinuvüch yin man quiri' tüj, roma yin xa cachi'el ri jun ri njachon yinc'o chi'icojol. ");
INSERT INTO cakENT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Rix rixc'o c'a pe viq'uin chupan ri pokonül ri nyetijon vichin. ");
INSERT INTO cakENT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Roma c'a ri', yin ninya' jun autoridad pan ik'a' rix, cachi'el ri rubanun ri Nata' Dios chuve yin, ");
INSERT INTO cakENT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","richin quiri' nyixva' y nquitij ya' chuvüch jun misma mesa viq'uin, tok xa c'o chic c'a autoridad pa nuk'a' yin. Y rix nyixoc c'a jueces pa quivi' ri doce tak tinamit rubanun ri nimalüj tinamit Israel. ");
INSERT INTO cakENT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Y ri Ajaf Jesús xbij c'a chuka' chin ri jun rachibil nbix Pedro chin: Simón, Simón, ninbij c'a chave que ri itzel-vinük xixruc'utuj yan chin ri Dios richin que nyixrutij. Nrajo' c'a nyixrusiloj cachi'el nsilos ri trigo chupan ri chaybül. ");
INSERT INTO cakENT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero yin nubanun-vi orar avoma rat, richin quiri' taya' avánima viq'uin. Richin quiri' man ncatapon tüj pa ruk'a' ri Satanás. Richin tok ntzolij-pe ac'u'x viq'uin, tabana' cheque ri ch'aka chic vachibila' que rije' tiquiya-vi cánima viq'uin, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Y ri Simón xbij: Ajaf, si rat ncatuc'u'üx pa jun cárcel, nquibe chavij. Hasta nquibe chavij, si rat ncatapon chuvüch ri camic, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pero ri Jesús xbij chin: Pedro, yin ninbij c'a chave, que chupan ri ak'a' vocomi, man jani tisiq'uin-pe ri gallo tok rat oxi' yan mul tabij cheque ri nyec'utun chave, que man avetaman tüj nuvüch, xbij ri Jesús chin ri Pedro. ");
INSERT INTO cakENT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Y ri Jesús xuc'utuj c'a cheque ri rachibila': Tok ri jun bey can xixintük y man xinjo' tüj richin xic'uaj morral, nixta tumin, ni jun chic c'ulaj xajab, ¿c'o comi ri xijo' y man xivil tüj? xbij. Y rije' xquibij que man jun. ");
INSERT INTO cakENT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Y ri Jesús xbij c'a cheque: Ja vocomi jun vi chic ri rubanic nrajo'. Roma vocomi ri achique c'o morral ruchajin, tuc'uaj. Ri c'o rutumin, tuc'uaj chuka'. Y ri manak rumachet, tuc'ayij ri rutziek ri cachi'el coton y c'ateri' tulok'o' jun riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Y vocomi quiri' ninbij chive, roma nc'atzinej que nbanatüj cachi'el ri nbij chupan ri rutzij ri Dios ri tz'iban can. Chiri' nbij c'a: Cachi'el chuka' jun aj-mac xban chin. Quiri' ri tz'iban can. Y re' nbanatüj na vi viq'uin yin. Ronojel c'a ri ye tz'iban can pa nuvi' yin chupan ri rutzij ri Dios, nyebanatüj na vi, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Y ri achibila' xquibij c'a chin ri Jesús: Ajaf, chere' c'o ca'i' machet. Pero ri Jesús xbij cheque: Ya xbün riq'uin ri', xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ri Jesús tok elenük chic c'a e chiri', xbe c'a ape' tibe-vi. Rija' xbe c'a pari' ri juyu' Olivos. Y ri rachibila' ye tzekel-vi e chirij. ");
INSERT INTO cakENT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Y tok xe'apon c'a, xbij cheque: Tibana' orar y tic'utuj chin ri Dios richin que tok nyixtijox man quixtzak pa mac. ");
INSERT INTO cakENT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Y ri Jesús xbiyin chic c'a apu jun ca'i' rakün-c'an, xxuque-ka chiri', y xutz'om c'a nbün orar. ");
INSERT INTO cakENT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Y nbij c'a pa ru-oración: Nata' Dios, tabana' c'a que man ninc'usaj tüj ri jun pokonül re', si quiri' ri najo' rat chuka'. Pero man tabün chuka' ri ninrayij yin, xaxe voma yin. Roma yin ninjo-vi c'a ninbün ri arayibül rat, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Y c'o c'a jun ángel ri petenük chila' chicaj xuc'ut-ri' chuvüch, richin nuya-ka-pe ruchuk'a' ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Y juis c'a k'oxon ri c'o pa ránima rija'. Romari' riq'uin c'a ronojel ránima nbün orar. Y roma chuka' ri k'oxon ri', ri ya' ri ntel chirij man choj tüj ya'. Xa cachi'el chic nimak' tak tz'uj quic' ri nyeka-ka pan ulef. ");
INSERT INTO cakENT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tok ri Jesús xbecatüj-pe ape' xucul-vi nbün orar, xpu'u c'a quiq'uin ri rachibila', pero tok xka-pe quiq'uin, xa quitz'amon varan, roma bis y cosic ntoc cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Y ri Jesús xbij c'a cheque ri rachibila' ri': ¿Achique roma xa nyixvür? Quixcatüj, tibana' orar y tic'utuj chin ri Dios richin que tok nyixtijox, man quixtzak pa mac, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Y c'a ntajin nch'o c'a ri Jesús quiq'uin ri rachibila', tok c'a nquina' xe'apon ye q'uiy vinük quiq'uin. Y ja ri jun cheque ri doce rachibila' ri rubini'an Judas, jari' ri uc'uayon-apu bey chiquivüch ri vinük ri'. Y ri Judas xjel-apu riq'uin ri Jesús richin xutz'ubaj. ");
INSERT INTO cakENT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero ri Jesús xbij c'a chin ri Judas: ¿Xinatz'ubaj yin ri xinalüx chi'icojol, xaxe richin nquinac'ayij-e pa quik'a' ri nye'etzelan vichin? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Y ri rachibila' tok xquitz'et ri ntajin rubanic, nquinabej ri achique ri nyec'ulachitüj. Romari' xquibij c'a chin: Ajaf, ¿nkatz'om comi ki' chi machet quiq'uin? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Y c'o na vi jun cheque ri rachibila' ri Jesús ri xusoc jun samajel richin ri nimalüj sacerdote. Xuchoy na vi ri ruxiquin. Y ri ruxiquin ri xuchoy ja ri c'o pa rajquik'a' (ru-derecha). ");
INSERT INTO cakENT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Y ri Jesús xbij c'a cheque ri rachibila': Man jun chic c'a tibün. Y xpu'u rija' xutz'om ri ruxiquin y xuc'achojrisaj can. ");
INSERT INTO cakENT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Y ja ri más nimalüj tak sacerdotes, ri nye'uc'uan quichin ri achi'a' ye chajinela' pa racho ri Dios, y ri rajatük tak achi'a' c'o quik'ij, jari' ri ye benük tz'amoy richin ri Jesús. Y rija' xbij cheque: ¿Achique c'a xinuc rix? ¿Xinuc que nyixpu'u chutz'amic jun elek'on y romari' ic'amon-pe che' y machet? ");
INSERT INTO cakENT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","K'ij-k'ij c'a xinc'uje' iviq'uin pa racho ri Dios, y man jun achique tüj xibün chuve. Pero c'a ja hora re' ri yo'on chive rix, hora tok nch'acon ri k'eku'n, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xquitz'om c'a e ri Jesús, y xquic'uaj pa racho ri nimalüj sacerdote. Y ri Pedro ye rutzekleben-e, pero c'anüj c'o-vi can chiquij. ");
INSERT INTO cakENT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Y chiri' pa nic'aj patio, ri rusamajela' ri nimalüj sacerdote xquibox k'ak', y xetz'uye-apu conojel chuchi' ri k'ak'. Y chuka' ri Pedro xtz'uye-apu chiquicojol. ");
INSERT INTO cakENT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Y jun c'a ixok raj-ic' ri nimalüj sacerdote, tok xutz'et ri Pedro que tz'uyul chiri' rumek'en-ri', xutz'et-xutz'et y xbij: Ri jun achi re' rachibil chuka' ri Jesús, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero ri Pedro xa xrevaj c'a chuvüch ri ixok, y xbij: Yin man vetaman tüj ruvüch ri Jesús, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Y c'a ba' chic ri' c'o chic c'a jun ri xtz'eton-pe richin ri Pedro, y xbij chin: Rat, jun cheque ri yec'o riq'uin ri Jesús, xbij. Ri' man yin tüj, xbij ri Pedro chin. ");
INSERT INTO cakENT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Colope' jun hora c'unük-ka ri', tok c'o chic c'a jun ri xbin pari' ri Pedro: Ri achi re', ketzij vi que xc'uje' riq'uin ri Jesús, roma aj-Galilea chuka', xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero ri Pedro xbij chin ri achi: Man nk'ax ta chuve achique roma nabij quiri', xbij ri Pedro. Y c'a nch'o na c'a ri Pedro, tok ri gallo xsiq'uin-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Y ri Ajaf Jesús xtzu'un-pe chirij y xutz'et-pe ri Pedro. Y ri Pedro jari' xka-pe chuc'u'x ri rubin can ri Ajaf Jesús chin, que c'a man jani tisiq'uin-pe ri gallo tok rat oxi' yan mul tabij cheque ri nyec'utun chave, que man avetaman tüj nuvüch. ");
INSERT INTO cakENT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Y ri Pedro xel c'a e y xujik' ok'ej. ");
INSERT INTO cakENT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Y ri achi'a' ri ye chajiyon c'a richin ri Jesús, nyetze'en c'a chirij y nquich'ey c'a. ");
INSERT INTO cakENT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","C'ateri' xquitz'apij runak'-ruvüch y xquipak'ala' rupalüj y nquic'utula' c'a chin: ¿Achique ri xach'ayon? Tabij na c'a cheke, nquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Y c'o c'a q'uiy ri man utzilüj tüj tak tzij ri xquibila' chin. ");
INSERT INTO cakENT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tok xsaker c'a pe, xquimol c'a qui' ri rajatük tak achi'a' ri c'o quik'ij, ri más nimalüj tak sacerdotes, y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés chuka'. Y ri Jesús xuc'u'üx c'a apu chiquivüch ri achi'a' ri', pa comon nyebanun juzgar. Y xquic'utuj c'a chin ri Jesús: ");
INSERT INTO cakENT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tabij c'a cheke: ¿Ja rat ri Cristo? xquibij. Pero ri Jesús xbij cheque: Si ninbij chive que ja yin ri Cristo, man nquininimaj tüj. ");
INSERT INTO cakENT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Y chuka' si ta c'o ri nyenc'utuj-apu chive, man jun nbij-pe chuve, chuka' nixta nquinisok'opij ta e. ");
INSERT INTO cakENT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Y tok nc'o c'a can ri jun pokonül re', yin ri xinalüx chi'icojol, nquibetz'uye' c'a pa rajquik'a' (ru-derecha) ri Dios ri ntiquer nbün ronojel, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jari' tok conojel xec'utun-apu chin ri Jesús: ¿Ja rat ri Ruc'ajol ri Dios? xquibij. Ja', quiri', cachi'el ri c'ari' nibij-ka rix, xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Y rije' xquibij: Man jun chic tzij nc'atzin cheke richin nketamaj que ri Jesús aj-mac vi. Roma konojel xkac'axaj ri c'ari' nbij-ka, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Y c'ateri' c'a, conojel ri yec'o chiri' xecatüj c'a e, y xquic'uaj-e ri Jesús richin nyequijacha' pa ruk'a' ri gobernador Pilato. ");
INSERT INTO cakENT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Y chiri' chuvüch ri gobernador, nquisujula' c'a apu y nquibij: Roj ketaman que ri Jesús q'uiy rumac. Rija' nuya' quina'oj ri vinük. Rija' nubila' chuka' cheque ri vinük que man tiquitoj ri alcaval chin ri rey César. Y chuka' nubila' que ja rija' ri Cristo, y re' nuk'alajrisaj c'a que ja rija' ri Rey, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Y ri Pilato xuc'utuj c'a chin ri Jesús: ¿Ja rat ri qui-Rey ri israelitas? xbij chin. Y ri Jesús xbij chin: Ja', quiri'. Cachi'el ri xabij, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Y c'ateri' ri Pilato xbij cheque ri más nimalüj tak sacerdotes y cheque ri ch'aka chic vinük chuka': Yin man jun ch'a'oj ninvil chirij ri jun achi re', xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero rije' man nyetane' ta ka. Xa nquitij c'a quik'ij que nquibila-apu: Xa nuya' quina'oj ri vinük pa ronojel tinamit richin ri ruch'ulef Judea. Chila' c'a pa ruch'ulef Galilea rutz'amon-pe rubanic. Y quiri' nbanala' ri petenük, y tok xkana' ja xka-pe chuka' chere' pa tinamit Jerusalén, xquibij-apu. ");
INSERT INTO cakENT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Y tok ri Pilato xrac'axaj ri quiri' xquibij-ka, xuc'utuj c'a que si aj-Galilea ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tok xbix c'a chin que ketzij, rija' xutük c'a e ri Jesús chin ri Herodes, ri jun rey ri xbün mandar richin ri ruch'ulef Galilea. Y man c'ayuf tüj xbün roma ri Herodes c'o c'a chiri' pa tinamit Jerusalén ri k'ij ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Y tok ri Herodes xutz'et ri Jesús, juis xquicot ránima, roma c'o yan chic k'ij rurayin que rutz'eton ta ruvüch. Y q'uiy c'a ri rac'axan pari'. Romari' royoben c'a que xtutz'et jun bey tok nbün jun milagro. ");
INSERT INTO cakENT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Y ri Herodes q'uiy c'a ri xeruc'utula' chin ri Jesús, pero ri Jesús man jun tzij xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Y yec'o c'a apu chuka' ri más nimalüj tak sacerdotes y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés, richin nquisujula' apu tzij chirij ri Jesús. Rije' nquitij c'a quik'ij richin nyesujun-apu. ");
INSERT INTO cakENT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Y ri Herodes y ri ye ru-soldados man jun ruk'ij xquibün chin ri Jesús y xquitze'ej. Xquiya' c'a jun tziük chirij, cachi'el ri nyequicusala' ri reyes. Roma chiquivüch rije' xa man jun ruk'ij ri Jesús. Y c'ateri' c'a ri Herodes xutzolij chic e chin ri Pilato. ");
INSERT INTO cakENT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ri Herodes y ri Pilato c'o oyoval chiquicojol. Jac'a ri k'ij ri' xa junan quivüch xbün ka. ");
INSERT INTO cakENT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Y c'ateri' ri Pilato xeroyoj ri ye más nimalüj tak sacerdotes y ri ye cachibil, pa comon nquibün mandar. Y chuka' xeroyoj ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Y c'ateri' xbij cheque: Rix xiya-pe ri Jesús pa nuk'a', y nyixsujun-pe que nuyala' quina'oj ri vinük. Pero chivüch c'a rix xinc'utuj-vi chin, y yin nintz'et que man ye rubanalun tüj ri ch'a'oj ri nibij rix richin nyixsujun-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Y chuka' ri Herodes man jun xril chirij, tok xixintük-e riq'uin, y romari' xutzolij chic pe pa nuk'a' yin. Xaxe riq'uin ri' nketamaj que man jun ch'a'oj rubanun richin quiri' nka-ka ta ri camic pari'. ");
INSERT INTO cakENT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nintük c'a chin nch'ay, y c'ateri' nincol-e, xbij ri Pilato. ");
INSERT INTO cakENT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Y ri Pilato nc'atzinej c'a que nucol-e jun preso, roma quiri' nban ronojel juna' pa ru-tiempo ri pascua, ri jun quinimak'ij ri israelitas. ");
INSERT INTO cakENT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Romari' conojel junan xech'o-apu riq'uin cuchuk'a', y xquibij: ¡Ja ri Barrabás tacolo-e, y ri Jesús ticamsüs! xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Y ri Barrabás c'o c'a pa cárcel roma xcatüj chirij ri gobierno chiri' pa tinamit, y rubanun chuka' camic. ");
INSERT INTO cakENT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Y ri Pilato, roma c'a nrajo-vi nucol-e ri Jesús, xch'o c'a jun bey chic cheque ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero ri vinük xech'o-apu riq'uin cuchuk'a', y xquibij: ¡Ticamsüs chuvüch cruz! ¡Ticamsüs chuvüch cruz! ");
INSERT INTO cakENT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Y pa rox mul ri Pilato xbij c'a cheque: ¿Achique c'a mac rubanun chivüch ri jun achi re'? Yin man jun ch'a'oj ninvil chirij, richin que nka-ka ta ri camic pari'. Nintük c'a richin nch'ay, y c'ateri' nincol-e, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero ri vinük y ri más nimalüj tak sacerdotes, riq'uin c'a cuchuk'a' nquic'utuj-apu que ticamsüs ri Jesús chuvüch cruz. Nk'alajin c'a que ja ri tzij ri xquibila-apu rije' jari' ri nch'acon. ");
INSERT INTO cakENT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Y jari' tok ri Pilato xbij que tiban c'a cachi'el ri nquic'utuj-apu rije'. ");
INSERT INTO cakENT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Y xucol c'a e ri achi ri xquic'utuj-apu chin que tucolo-e. Y ri achi ri' xa c'o c'a pa cárcel roma xcatüj chirij ri gobierno y xbün chuka' camic. Ja ri Jesús xa xujüch-e richin que ticamsüs chuvüch cruz, roma jari' ri xcajo' ri vinük chirij. ");
INSERT INTO cakENT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Y tok ri soldados quic'uan c'a e ri Jesús richin nyequibajij chuvüch ri cruz, xquic'ul c'a jun achi petenük pa k'ayis, jun achi aj-Cirene y rubini'an Simón. Y ri soldados chirij c'a rija' xquiya-vi-e ri ru-cruz ri Jesús. Ja rija' xuc'uan-e ri cruz, y chirij ri Jesús benük-vi. ");
INSERT INTO cakENT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Y juis c'a vinük ri ye benük chirij. Y juis c'a chuka' ixoki' ri nye'ok'en ruvüch ri Jesús, y juis nquibisoj. ");
INSERT INTO cakENT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Y ri Jesús xerutz'et c'a, y xbij cheque: Ixoki' aj-Jerusalén, man quinivok'ej yin. Xa tivok'ej-ivi' rix, y tivok'ej chuka' quivüch ri ac'uala' yec'o iviq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Roma yec'o c'a k'ij nyeka-pe tok c'ayuf ri nbanatüj. Y romari' nbitüj que juis quicot ri ixok ri man nalan tüj, ni man jun bey xuya' ta jun ac'ual, y man xuya' tüj chuka' rutz'un. ");
INSERT INTO cakENT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Roma jari' tok nbanatüj que ri vinük nyech'o cheque ri nimak' tak juyu' y nquibila': Quixtzak-pe chikij. Chuka' nyech'o cheque ri cocoj tak juyu' y nquibila' c'a: Kojivevaj, nquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Roma si chuve yin ri cachi'el jun che' rüx nban que nc'atzinej que ninc'usaj pokonül, ¿achique ta comi ri man nban cheque ri xa ye cachi'el chaki'j tak che'? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Y yec'o c'a chuka' ye ca'i' elek'oma' ri ye uc'uan-e richin nyecamsüs junan riq'uin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Y tok xe'apon c'a chupan ri jun lugar rubini'an Calavera, xquibajij c'a ri Jesús chuvüch ri ru-cruz, y quiri' chuka' ri ye ca'i' elek'oma'. Jun xpabüx pa rajquik'a' (ru-derecha), y ri jun chic pa ruxocon (ru-izquierda). ");
INSERT INTO cakENT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Y ri Jesús xbij c'a: Nata' Dios, tacuyu' quimac, roma man quetaman tüj achique ri nyetajin chubanic, xbij ri Jesús. Y ri soldados xquiya' pan atz'anin ri rutziek ri Jesús, richin xquitz'et achique chi tziük ri nquic'uala-e chiquijujunal. ");
INSERT INTO cakENT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Y juis c'a vinük nquitz'eta-apu ri Jesús y quiri' chuka' ri ch'aka ri nquibün mandar chiquicojol ri israelitas. Y conojel c'a ri vinük re' nquitze'ej-apu, y nquibila': Rija' ye q'uiy xerucol. Vocomi tucolo' c'a ri' rija', si ketzij que ja rija' ri Cristo ri cha'on roma ri Dios, nquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Y quiri' chuka' nquibün ri soldados. Nyetze'en-apu chirij ri Jesús. Nyejel-apu riq'uin y nquisujla' jun ch'amilüj ruya'al-uva chin. ");
INSERT INTO cakENT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Y nquibila' c'a chin chuka': Si ja rat ri qui-Rey ri israelitas, tacolo' c'a avi' ayon, nquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Y pari' e ri cruz c'o c'a tzij tz'iban chuvüch jun tz'alün. Ri tzij c'a ri' tz'iban-e pan oxi' ch'abül. Tz'iban pa quich'abül ri aj-Grecia, pa quich'abül ri aj-Roma y pa quich'abül ri israelitas. Y ri tzij ri' nbij c'a: Jare' ri qui-Rey ri israelitas. ");
INSERT INTO cakENT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Y jun c'a cheque ri ye ca'i' elek'oma' ri yec'o chuka' chuvüch qui-cruz, itzel xch'o-apu chin ri Jesús, roma xbij: Rat ri nabij que ja rat ri Cristo, tacolo' c'a avi' rat, y kojacolo' roj chuka', xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jac'a ri jun chic elek'on xuch'olij, y xbij-apu chin ri jun: ¿Man naxbij tüj avi' rat chuvüch ri Dios chupan ri k'oxomül ri nkuc'o-vi riq'uin? ");
INSERT INTO cakENT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Roj utz vi rubanic cheke, roma nkutajin chutojic ri itzel ye kabanalun. Jac'a rija' man jun achique tüj mac rubanun. ");
INSERT INTO cakENT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Y ri elek'on ri' xbij c'a apu chin ri Jesús: Quinac'uxla'aj c'a pan avánima, tok ncapu'u y ja rat chic ri Jun ri nabün mandar, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Y ri Jesús xbij c'a chin: Ketzij c'a ninbij chave, que ja ri vocomi ncabec'uje' viq'uin pa lugar richin quicot, xbij ri Jesús chin. ");
INSERT INTO cakENT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Y pa nic'aj-k'ij la'ük ri' tok ri ruch'ulef xk'ekumür. Y ri k'eku'n ri' xq'uis-e ri las tres ri xkak'ij. ");
INSERT INTO cakENT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ri k'ij xa xk'ekumür-ka, y jari' tok ri c'ul ri tason rupan ri racho ri Dios xk'ach'itüj pa nic'aj y xel ca'i'. ");
INSERT INTO cakENT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jari' tok ri Jesús riq'uin c'a ruchuk'a' xbij: Nata' Dios, pan ak'a' c'a ninjüch-vi ri vánima, xbij. Y xe c'a xbij quere', jari' tok xcom-ka. ");
INSERT INTO cakENT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tok ri Capitán quichin ri soldados xutz'et ri xbanatüj, xuya' c'a ruk'ij ri Dios, y xbij c'a: Ketzij na vi que ri jun achi re' man jun na vi rumac, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Y ye juis ri vinük ri yec'o-apu y xquitz'et ri xbanatüj, nquit'init'a' c'a quic'u'x xetzolij roma ri k'oxon c'o pa cánima. ");
INSERT INTO cakENT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Y ri ye etamayon ruvüch ri Jesús, y ri ixoki' ri c'a pa Galilea ye tzekel-pe chirij, c'a nüj c'a yec'o-vi-e nquitz'et-apu ri xbanatüj. ");
INSERT INTO cakENT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Y c'o c'a jun achi rubini'an José, y aj pa tinamit Arimatea pa ruch'ulef Judea ncanaj-vi can. Ri jun utzilüj y chojmilüj achi c'a re' cachibil ri achi'a' ri nquibün mandar chiquicojol ri israelitas. ");
INSERT INTO cakENT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Y ri José chuka' royoben tok ri Dios ntoc ri Jun ri nbün mandar y romari' tok rija' man xka' tüj chuvüch ri xquibij ri rachibil que nbanatüj chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Y rija' xbe c'a riq'uin ri gobernador Pilato chuc'utuxic ruch'acul ri Jesús, richin numuk. ");
INSERT INTO cakENT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Y tok rukasan chic c'a pe ri ruch'acul ri Jesús chuvüch ri cruz, rija' xupis pa jun c'ul. Y c'ateri' xberumuku' can pa jun jul richin camnük, c'oton chuvüch jun juyu' ri xa abüj vi. Y man jun c'a ucusayon ri jul ri'. ");
INSERT INTO cakENT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pero ri k'ij ri', ri vinük nquichojmirsala' chic c'a qui', roma ri k'ij ri richin uxlanen ntz'ucutüj yan. Y ja tok nc'o-ka ri k'ij, jari' tok ntz'ucutüj. ");
INSERT INTO cakENT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Y ri ixoki' ri c'a pa Galilea ye tzekel-pe chirij ri Jesús, xebe c'a tok xbemuk can. Y romari' tok jabel quetaman ri lugar ape' xmuktüj can, y chuka' xquitz'et jabel achique rubanic xban can chin ri ruch'acul. ");
INSERT INTO cakENT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Y tok xetzolij pa tak cacho ri ixoki' ri', xquibanala' quic'ojlen jubulüj tak ak'on richin jari' nyequiya' can chirij ri Jesús. Y xe'uxlan c'a chupan ri jun k'ij richin uxlanen ri', cachi'el nbij chupan ri ley richin ri Moisés. ");
INSERT INTO cakENT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Y cumaj yan domingo ri nabey k'ij richin ri semana, ri ixoki' xebe c'a chuchi' ri jul, y ye quic'ualon-e ri jubulüj tak ak'on ri ye quibanun-e. Y yec'o c'a chuka' ch'aka chic ixoki' ri ye benük chiquij. ");
INSERT INTO cakENT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Y tok xe'apon c'a chuchi' ri jul, xquitz'et c'a que ri abüj tz'apibül ruchi' ri jul, elesan chic e. ");
INSERT INTO cakENT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Rije' xe'oc c'a apu chupan ri jul, y xquitz'et c'a que ri ruch'acul ri Ajaf Jesús xa manak chic. ");
INSERT INTO cakENT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Romari' juis c'a xquixbij-qui', y xsatz quic'u'x. Y jari' tok xequitz'et ye ca'i' cachi'el achi'a' ye pa'ül-apu quiq'uin, y nyiq'uiyot ri quitziek. ");
INSERT INTO cakENT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Y ri ixoki', roma ri quixbiri' xquilukuba-ka-qui'. Y jari' c'a tok ri cachi'el achi'a' xquibij-pe c'a cheque: ¿Achique c'a roma rix chiquicojol caminaki' nicanoj-vi ri jun xa c'üs? ");
INSERT INTO cakENT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ri ruch'acul manak chic chere'. Rija' xc'astüj yan e. Tika-pe c'a chi'ic'u'x ri xbij chive tok rija' c'a c'o c'a chiri' pa Galilea. ");
INSERT INTO cakENT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Rija' xbij c'a chive: Yin ri xinalüx chi'icojol, nc'atzinej c'a que nquijach pa quik'a' ri aj-maqui'. Nquicamsüs chuvüch cruz. Y pa rox k'ij nquic'astüj chic pe jun bey, xquibij ri ye ca'i' cachi'el achi'a'. ");
INSERT INTO cakENT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Y ri ixoki' xka-pe vi c'a chiquic'u'x ri tzij ri rubilon can ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Y tok ye tzolijnük chic c'a pe chiri' pa jul, xquitzijoj cheque ri julajuj apóstoles y ri quimolon-qui' quiq'uin, ronojel ri xquitz'et can. ");
INSERT INTO cakENT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ri ixoki' ri xebeyo'on rutzijol cheque ri apóstoles ja ri María Magdalena, ri Juana, ri María ri rute' ri Jacobo, y ch'aka chic ixoki'. ");
INSERT INTO cakENT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero ri apóstoles xa xquinuc que ri quitzij ri ixoki' ri' xa cachi'el loco, y romari' man xquinimaj tüj ri xbix cheque coma ri ixoki'. ");
INSERT INTO cakENT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Y ri Pedro jari' xel-e, y junanin xbe c'a chuchi' ri jul. Y tok xtzu'un c'a apu chupan ri jul, xutz'et que ri tziük yec'o can chiri'. Rija' xtzolij c'a e, pero juis c'a nunuc pari' ri xbanatüj. ");
INSERT INTO cakENT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Y chupan ri k'ij ri', chuka' yec'o c'a ye ca'i' cheque ri xetzekleben richin ri Jesús quitz'amon-e bey richin nyebe pan Emaús, ri jun vit tinamit ncanaj can pa colope' oxi' leguas chin ri tinamit Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Y nyetzijon c'a ri ye benük. Nquitzijola' ri xebanatüj ri cabijir-oxijir can. ");
INSERT INTO cakENT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Y tok benük c'a cánima chirij ri quitzij ri ye benük, y riq'uin ri nquic'utula' c'a chiquivüch ka rije', ri Jesús c'astajnük chic e, xbün c'a que xjel-apu quiq'uin y xeberila', y junan xebe. ");
INSERT INTO cakENT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ri ca'i' c'a achi'a' ri' nquitz'et-vi c'a ri benük chiquij, pero c'o c'a banayun cheque richin quiri' man nquetamaj tüj ruvüch. ");
INSERT INTO cakENT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Y ri Jesús xuc'utuj c'a cheque: ¿Achique c'a chi tzij ri itz'amon-pe ri rix petenük? ¿Y achique roma tok nyixbison chuka' nyixintz'et yin? xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Y jun c'a cheque rije', ri rubini'an Cleofas, xch'o-apu chin y xbij: Man jun la'ük vinük ri c'o chiri' pa tinamit Jerusalén ri man ta etamayon ri xc'ulachitüj chupan ri ca'i-oxi' k'ij can. Y rat chiri' rat petenük-vi y man avetaman tüj achique ri ye xbanatüj chiri', xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Y ri Jesús xuc'utuj c'a cheque: ¿Achique ri xc'ulachitüj? Y rije' xquibij: Ri xuc'ulachij ri Jesús aj-Nazaret, jun achi ri k'alajrisüy richin ri xbix chin roma ri Dios. Y chuka' xuc'ut que c'o ruchuk'a', riq'uin ri nimak' tak milagros ri xerubanala' y chuka' riq'uin ri rutzij. Quiri' c'a xk'alajin chiquivüch ri vinük y chuka' chuvüch ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero ri más nimalüj tak sacerdotes y ri ye cachibil, pa comon nyebanun juzgar chikacojol, jari' ri xebanun chin que xcamsüs chuvüch cruz. ");
INSERT INTO cakENT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Y roj xa kayo'on c'a kánima riq'uin que ja vi rija' ri petenük chikacolic konojel roj israelitas. Pero vocomi man jun chic c'a achique nkabün, roma ja yan re' ri rox k'ij xcom-e. ");
INSERT INTO cakENT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero yec'o kachibil ixoki' cumaj yan xsaker xebe chuchi' ri jul, y xojquixbij-pe. ");
INSERT INTO cakENT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Roma nquibij que ri ruch'acul ri Jesús xa manak chic chiri' pa jul. Y nquibij c'a chuka' que c'o ángeles xquic'ut-qui' chiquivüch, y que ri ángeles re' xquibij cheque que ri Jesús xc'astüj yan e. ");
INSERT INTO cakENT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Y romari' yec'o c'a cheke roj achi'a' ri xebe chuchi' ri jul richin xbequitz'eta'. Y cachi'el ri xbequibij ri ixoki' cheke, quiri' ri xbequitz'eta' can ri achi'a', pero ri Jesús man xquitz'et tüj can. ");
INSERT INTO cakENT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Y ri Jesús ri ntzijon benük chiquij, xbij c'a cheque: Nacanük. Rix xa man c'unük tüj c'a pan ivánima ri quibin can ri achi'a' ri xek'alajrisan ri rutzij ri Dios ojer can. ");
INSERT INTO cakENT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Man quibin tüj comi rije' que ri Cristo nc'atzinej-vi que nuc'usaj pokonül, y c'ateri' nbe chila' chicaj richin nbec'uje' ruk'ij? xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Y ri Jesús xutz'om c'a rubixic pari' ri chiquivüch ri ye ca'i' achi'a' ri', ronojel ri ye tz'iban can pari' rija' chupan ri rutzij ri Dios. Xutz'om c'a e riq'uin ri ye rutz'iban can ri Moisés, y riq'uin chuka' ri quitz'iban can ri ch'aka chic achi'a' ri xek'alajrisan ri rutzij ri Dios ojer can. ");
INSERT INTO cakENT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Y tok xe'apon c'a pa vit tinamit Emaús, ri Jesús xbün que choj xc'o-e. ");
INSERT INTO cakENT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Y richin c'a que ncanaj can quiq'uin, ri ca'i' achi'a' ri' xquibij chin: Cac'uje' ka kiq'uin, roma ri k'ij xa xtzak yan ka, y xa nmoymot chic, xquibij. Y ri Jesús xoc c'a apu, richin nc'uje-ka quiq'uin. ");
INSERT INTO cakENT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Y tok ye tz'uyul chic c'a apu chuvüch mesa, ri Jesús xuc'ün-apu ri vüy, y tok rumatioxin chic chin ri Dios, xuper ri vüy y xuya' c'a cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Y jari' cachi'el xjakatüj ri runak'-quivüch, y c'ateri' xquetamaj ruvüch que ja c'a ri Jesús ri c'o quiq'uin. Ri Jesús xq'uis chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Y ri ca'i' achi'a' ri' nquibila' c'a chiquivüch: Ketzij vi que nuna-vi chic ri kánima tok nkutzijon ri roj petenük, tok rija' xuk'alajrisaj pari' ri rutzij ri Dios chikavüch, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ri ca'i' achi'a' ri' jari' xecatüj-e chuvüch mesa, y xquitz'om bey richin nyetzolij pa Jerusalén. Y xebequila' c'a ri julajuj rachibil ri Jesús y ri ch'aka chic ri ye tzeklebey vi richin ri Jesús, quimolon-qui'. ");
INSERT INTO cakENT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Y ri rachibil ri Jesús y ri ch'aka chic nquibij c'a: Ri Ajaf Jesús xc'astüj yan na vi e, y xuc'ut yan ri' chuvüch ri Simón. ");
INSERT INTO cakENT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Y jari' tok ri ca'i' achi'a' xquitzijoj-apu ri xquic'ulachij tok quitz'amon-e bey pa tinamit Emaús, y xquetamaj ruvüch que ja ri Jesús tok xuper ri vüy. ");
INSERT INTO cakENT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Y conojel ri quimolon-qui', c'a nyetzijon c'a pari' ri Jesús, tok xquitz'et c'o chic chiri' chiquicojol, y xbij c'a cheque: Ja ta c'a ri uxlanen ri xtic'uje' pa tak ivánima chi'ivonojel, xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero rije' xquinuc que ri nquitz'et ja ri ánima richin ri Jesús, romari' juis xquixbij-qui'. ");
INSERT INTO cakENT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero ri Jesús xbij cheque: ¿Achique roma tok xixbij-ivi' tok xinitz'et y xpu'u pa tak ivánima ca'i' nojibül? ");
INSERT INTO cakENT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Que'itz'et ri nuk'a-vakün. Quinitz'ama' na pe', y nitz'et que ja vi yin. Roma xa ta yin jun ánima cachi'el ri ninuc rix, man ta c'o nuch'acul. Y rix nitz'et que yin c'o ronojel, xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Y tok ri Jesús rubin chic quiri' cheque, xeruc'ut c'a ri ruk'a-rakün chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero rije' man nquinimaj tüj. Xa xsatz quic'u'x roma ri nquitz'et y roma ri quicot. Y richin que nquinimaj, xpu'u ri Jesús xuc'utuj c'a cheque: ¿Man jun achique ta ba' chin nc'uxtüj ichajin chin nispaj ta ba' chuve? xbij. ");
INSERT INTO cakENT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Y rije' xbequiya-pe chin ba' sa'on cür y ba' cab c'a c'o pa cera. ");
INSERT INTO cakENT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Y rija' xuc'ul y xutz'om ruc'uxic, richin tiquitz'eta' que ja vi rija' ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Y xbij c'a cheque: Tok c'a yinc'o c'a iviq'uin, xinbij c'a chive ri ninc'ulachij, y que nc'atzin na vi que nbanatüj ronojel ri ye tz'iban can chuvij yin chupan ri rutzij ri Dios, cachi'el ri ye tz'iban can roma ri Moisés, ri ye tz'iban can coma ri ch'aka chic achi'a' ri xek'alajrisan rutzij ri Dios ri ojer can, y ri ye tz'iban can chupan ri vuj rubini'an Salmos. ");
INSERT INTO cakENT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","C'ateri' rija' xbün cheque richin tik'ax cheque ri rutzij ri Dios ri tz'iban can. ");
INSERT INTO cakENT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Y xbij c'a cheque: Tz'iban-vi c'a can ri', que yin ri Cristo nc'atzinej que ninc'usaj pokonül, y que nquicom na vi, y pa rox k'ij nquic'astüj-pe, ");
INSERT INTO cakENT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","y que yec'o ri nyebe pa nubi' yin richin nyequitzijoj ri rutzij ri Dios cheque ri vinük chuvüch ri ruch'ulef, que titzolij-pe quic'u'x riq'uin ri Dios richin ncuyutüj ri quimac. Y ntz'amatüj-e pa Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Y rix ri xitz'et, tik'alajrisaj c'a ri xitz'et. ");
INSERT INTO cakENT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Y tivac'axaj c'a jabel ri ninbij can chive, xbij ri Jesús. Nintük c'a pe chive ri rusujun ri Nata' Dios que nuya-pe chive. Ri rusujun c'a rija' chive rix, ja ri Lok'olüj Espíritu. Y jari' ri nbeyo'on-ka ivuchuk'a'. Y quixc'uje' c'a chere' pa tinamit Jerusalén hasta jampe' napon ri k'ij tok nka-pe ri Lok'olüj Espíritu, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Y ri Jesús xeruc'uaj c'a e ri rachibil pa tinamit Betania. Y chiri', rija' xerutzekej ri ruk'a' chicaj, y xuc'utuj ri utzilüj rusipanic ri Dios pa quivi' rije'. ");
INSERT INTO cakENT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Y ri Jesús jari' c'a ri ntajin chubanic tok ja yan ri' xujüch-e-ri'. Jari' tok xcatüj-e pa cakik' y xuc'u'üx c'a e chicaj riq'uin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Y ri ye rachibil xquiya' c'a ruk'ij ri Jesús chiri'. C'ateri' xetzolij pa tinamit Jerusalén. Rije' juis c'a nyequicot pa cánima. ");
INSERT INTO cakENT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Y k'ij-k'ij c'a yec'o pa racho ri Dios richin nquiya' ruk'ij ri Dios y nquinimirsaj rubi'. Quiri' c'a.");
INSERT INTO cakENT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ri Cristo jari' ri Rutzij ri Dios ri nk'alajrisan ri runa'oj ri Dios. Tok xtz'ucutüj c'a pe ronojel, c'o-vi rija'. Rija' c'o c'a riq'uin ri Dios, y rija' chuka' Dios vi. ");
INSERT INTO cakENT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Rija' c'o-vi-pe riq'uin ri Dios tok xban ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Y roma rija' tok c'o ronojel. Roma ri Dios pa ruk'a' ri Cristo xuya-vi richin xbün ronojel. ");
INSERT INTO cakENT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Riq'uin c'a rija' c'o-vi ri c'aslen. Y ri c'aslen re', jare' ri nsakrisan quichin ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Y ri jun Sük re', nsakrisan-vi pa k'eku'n quic'aslen ri vinük. Y man jun bey c'a ri k'eku'n nuchup ri Sük ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Y xc'uje' c'a jun achi ri cha'on-pe roma ri Dios, jun achi ri rubini'an Juan. ");
INSERT INTO cakENT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ri Juan c'a re' xpu'u richin xberuk'alajrisaj ri Sük, richin quiri' conojel c'a vinük tiquitakej. Tiquinimaj c'a ri nuya' rutzijol rija' cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Y man ja tüj c'a rija' ri Sük. Rija' xaxe c'a richin xberuk'alajrisaj ri Sük ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Y jari' tok xka-pe ri Sük ri' chuvüch ri ruch'ulef. Jari' ri ketzij Sük, ri nsakrisan quichin ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Xka-pe c'a chuvüch ri ruch'ulef ri banun roma rija', pero ri yec'o chuvüch ri ruch'ulef re' xa man xquetamaj tüj ruvüch tok xka-pe. ");
INSERT INTO cakENT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Chupan c'a ri ruch'ulef richin rija' xka-pe, pero ri vinük ri ye richin rija' xa man xquic'ul tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Jac'a ri xec'ulun richin tok xka-pe chuvüch ri ruch'ulef, ri xetaken-vi richin, xbün c'a cheque que xe'oc ralc'ual ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ri vinük c'a ri xe'oc ralc'ual ri Dios, xe'alüx-vi chic, pero man junan tüj chic chi alaxic ri xquic'uaj cachi'el tok xe'alüx riq'uin ri quite', tok xa ja ri te'ej-tata'aj xquirayij que xalüx jun ac'ual. Roma ri c'ac'a' alaxic rurayibül ri Dios, y man rurayibül tüj ri achi. ");
INSERT INTO cakENT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Y ri Cristo ri Rutzij ri Dios xka-pe c'a chuvüch ri ruch'ulef y xoc c'a chuka' cachi'el roj vinük. Y xkatz'et c'a que xaxe vi rija' ri Ruc'ajol ri Dios, roma c'o ruk'ij. Y nojnük c'a riq'uin ri ketzij y juis chuka' riq'uin ri utz ri nuspaj ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Y ri Juan ri xbix chuka' Bautista chin, c'o c'a ri xuk'alajrisaj pari' ri Cristo. Riq'uin vi ruchuk'a' tok xbij: Jare' ri nutzijon chive, tok xinbij chive que ri nka-pe chuvij yin, jari' ri nimalaxel chinuvüch. Y c'o-vi-pe pa nabey, tok yin c'a man jani nquibec'ulun tüj pe chuvüch ri ruch'ulef, xbij c'a ri Juan Bautista. ");
INSERT INTO cakENT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Konojel c'a roj kac'ulun ri utzilüj sipanic ri nspaj-pe ri Cristo. Man xe tüj c'a jun bey ri ruyo'on-pe pa kavi', xa quitzeklebelon-pe-qui' ri utz ri nuspaj ri Dios pa kavi'. ");
INSERT INTO cakENT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ri Dios ja ri Moisés ri xucusaj richin xuya-pe ri ley ri nuc'ut achique rurayibül rija'. Jac'a richin que xka-pe ri utzilüj sipanic ri nspaj-pe ri Dios y ri ketzij, ja ri Jesucristo ri xucusaj. ");
INSERT INTO cakENT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Man jun c'a vinük ri tz'eteyon tüj richin ri Dios, xaxe ri Ruc'ajol ri tz'eteyon richin. Ri Dios xaxe c'a ri jun Ruc'ajol c'o y juis nrajo'. Y jari' ri xbek'alajrisan-ka-pe ri Dios chikavüch chere' chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Y ri achi'a' ri c'o quik'ij chiquicojol ri israelitas chiri' pa tinamit Jerusalén, yec'o c'a achi'a' ri xequitük-e c'a riq'uin ri Juan Bautista. Xequitük c'a achi'a' ye sacerdotes y achi'a' ri ye levitas nbix cheque, richin que xbequic'utuj chin ri Juan que tubij si ja rija' ri Cristo. Y rija' xuk'alajrisaj-vi chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ri Juan ja vi c'a ri ketzij ri xuk'alajrisaj, roma xbij c'a cheque: Man ja tüj yin ri Cristo. ");
INSERT INTO cakENT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Y c'ateri' ri achi'a' ri ye takon-e, xquic'utuj chic c'a chin: ¿Rat achique c'a rat c'a? ¿O xa ja rat ri achi ri xk'alajrisan ri rutzij ri Dios ojer can y xubini'aj Elías? xquibij chin. Pero ri Juan xbij c'a cheque: Man ja tüj yin, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Y c'ateri' ri achi'a' ri' xquic'utuj c'a chin: ¿Rat achique c'a rat c'a? Roma roj nc'atzin c'a cheke que nketamaj-e rat achique rat, y jari' ri nkabebij cheque ri ye takayon-pe kichin. Tak'alajrisaj c'a avi' chikavüch, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Y rija' xbij c'a cheque ri achi'a' ri': Ja yin ri jun ri achique chok pari' c'o rutz'iban ri k'alajrisüy rutzij ri Dios ri xc'uje' ojer can y rubini'an Isaías. Y jare' ri xutz'ibaj can rija': C'o jun achi c'a ri nc'uje' pa tz'iran ruch'ulef, y ja rija' ri ntzijon ri rutzij ri Dios chiquivüch ri vinük ri nye'apon riq'uin. Y nubila' c'a cheque: Tichojmirsala' rubey ri ic'aslen, roma ya ja nobos ri Ajaf, xbij ri Juan cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ri achi'a' c'a ri xe'apon riq'uin ri Juan, ja ri achi'a' ri ye takon-e coma ri fariseos. ");
INSERT INTO cakENT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Y ri achi'a' ri' xquic'utuj chic c'a chin ri Juan: ¿Achique c'a roma rat nye'abün bautizar ri vinük? Tok xa man ja tüj rat ri Cristo, ni man ja tüj chuka' rat ri Elías, ni man ja tüj rat ri k'alajrisüy ri rutzij ri Dios ri nc'atzinej npu'u, xquibij ri achi'a' ri' chin ri Juan. ");
INSERT INTO cakENT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Y ri Juan xbij c'a cheque: Yin riq'uin ya' nyenbün bautizar ri vinük, pero chi'icojol rix c'o c'a Jun ri man ivetaman tüj ruvüch, ");
INSERT INTO cakENT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","y rija' c'a chuvij c'a yin nka-pe, pero ja rija' ri c'o-pe nabey que chinuvüch yin. Y yin man c'uluman tüj c'a ni richin ninsol ri ruximbül ri ruxajab. ");
INSERT INTO cakENT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Y ronojel c'a re', ja chiri' pa Betábara xbanatüj-vi, ri lugar ri c'o-apu lojc'an ruchi' ri rakün-ya' Jordán, ri nbün-vi bautizar ri Juan. ");
INSERT INTO cakENT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pa ruca'n k'ij tok ri Juan Bautista xutz'et que choj petenük ri Jesús c'a riq'uin, xbij: Jare' xka-pe ri cachi'el Alaj Oveja ri takon-pe roma ri Dios, richin que nrelesaj ri quimac ri vinük ri yec'o chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Y jare' ri nutzijon chive, tok xinbij que chuvij yin nka-pe c'a jun achi ri xa nimalaxel vi chinuvüch yin, y c'o-vi-pe nabey yan, tok yin man jani nquic'ulun ta pe chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Y yin man vetaman tüj achique achi rija'. Pero richin que nk'alajrisüs chuvüch ri tinamit Israel, romari' tok xinpu'u chubanic bautizar riq'uin ya'. ");
INSERT INTO cakENT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Y ri Juan xuk'alajrisaj c'a chuka' y xbij: Yin xintz'et c'a ri Lok'olüj Espíritu tok xka-pe chila' chicaj cachi'el jun paloma y xc'uje-ka pari' rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Y yin chiri' c'a man jani c'a vetaman tüj achique c'a ri Jun ri'. Pero ri Dios ri yo'on-pe ri jun samaj re' chuve, ruk'alajrisan-vi chic c'a chinuvüch que tok nintz'et que nka-pe ri Lok'olüj Espíritu y nc'uje-ka pari' jun achi, jari' ri nbanun bautizar riq'uin ri Lok'olüj Espíritu y man riq'uin tüj ya'. ");
INSERT INTO cakENT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Vocomi xintz'et yan c'a. Y romari' nink'alajrisaj que ja rija' ri Ruc'ajol ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Y pa ruca'n k'ij, ri Juan ye rachibilan ye ca'i' cheque ri rachibila', c'o chic c'a chiri' jun bey. ");
INSERT INTO cakENT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Y jari' tok rija' xutz'et que ri Jesús nc'o-e chiri'. Rija' xbij c'a: Titz'eta', ja Jesucristo la', ri cachi'el Alaj Oveja ri takon-pe roma ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Y ri ye ca'i' rachibila' ri Juan tok xcac'axaj c'a ri xbij, rije' xquitzeklebej-e ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Y tok ri Jesús xtzu'un can chirij y xerutz'et ri ye ca'i' rachibila' ri Juan que ye tzekel-e chirij, rija' xuc'utuj c'a cheque: ¿Achique nicanoj? xbij cheque. Y rije' xquibij c'a chin ri Jesús: Roj nkajo' nketamaj ape' c'o-vi ri avacho rat Rabí. Rije' Rabí xquibij c'a chin roma ri israelitas quiri' nquibij chin jun maestro. ");
INSERT INTO cakENT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Y ri Jesús xbij c'a cheque: Jo', y tibevetamaj can. Y rije' xebe na vi y xbequetamaj can ri racho. Ya xec'uje' c'a ka riq'uin ri jun k'ij ri', roma xa las cuatro chic ri xkak'ij. Xa xkak'ij yan c'a. ");
INSERT INTO cakENT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ri jun c'a cheque ri ye ca'i' achibila' ri xe'ac'axan-e achique ri xbij ri Juan y xquitzeklebej-e ri Jesús, ja ri Andrés. Ri Andrés y ri Simón Pedro ye quichak'-qui'. ");
INSERT INTO cakENT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ri Andrés nabey c'a xberucanoj ri Simón y xberubij c'a chin: Ketaman chic c'a achique ri Mesías. Y quiri' c'a nquibij ri israelitas chin ri Cristo, ri Jun cha'on-pe y takon-pe roma ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","C'ateri' ri Andrés xuc'uaj ri Simón c'a riq'uin ri Jesús. Y tok ri Jesús xutz'et, xbij c'a chin: Ja rat ri Simón ri ruc'ajol ri Jonás. Vocomi nabini'aj c'a chuka' Cefas. Y quiri' c'a nquibij ri israelitas chin jun vinük rubini'an Pedro. ");
INSERT INTO cakENT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ja pa ruca'n k'ij, ri Jesús runucun-vi que nbe c'a pa ruch'ulef Galilea. Y chupan c'a ri k'ij ri' ri Jesús xberuc'ulu-pe ri jun achi rubini'an Felipe y xbij c'a chin: Quinatzeklebej. ");
INSERT INTO cakENT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Y ri jun achi re', ri rubini'an Felipe, aj pa tinamit Betsaida, ri tinamit ape' c'o-vi cacho ri Andrés y ri Pedro. ");
INSERT INTO cakENT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ri achi c'a ri rubini'an Felipe, xberuc'ulu-pe ri jun achi rubini'an Natanael, y xbij c'a chin: C'o chic ri Jun ri rubin can ri Moisés chupan ri ley ri xuya' ri Dios richin rija', y ri quibin can chuka' ri achi'a' ri xek'alajrisan ri rutzij ri Dios ojer can, ri chupan ri quivuj ye quitz'ibalun can. C'ateri' nketamaj can ruvüch. Rija', ja ri Jesús ri ruc'ajol ri José aj-Nazaret. ");
INSERT INTO cakENT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Y ri Natanael xbij: ¿Xtic'ulun ta c'a pe jun utzilüj achi ri chiri' pa tinamit Nazaret? xbij rija'. Pero ri Felipe xbij chin: Si man nanimaj tüj, jo' chutz'etic. ");
INSERT INTO cakENT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Y tok ri Jesús xutz'et ri Natanael que xa napon yan apu riq'uin, xbij c'a: Titz'eta' la jun achi la'. Rija' richin vi ri rutinamit ri Dios. Rija' jun ketzij israelita, roma quiri' nuc'ut ri ruc'aslen. Man jun ch'aconic riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","C'ateri' ri Natanael xuc'utuj c'a chin ri Jesús: ¿Ape' xavetamaj-vi nuvüch? Y ri Jesús xbij c'a chin: Yin xatintz'et tok c'a ratc'o na chiri' chuxe' ri jun che' rubini'an higuera, tok c'a man jani tac'ul ri Felipe, xbij ri Jesús chin. ");
INSERT INTO cakENT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ri Natanael jari' tok xbij: Maestro, xbij chin. Ja vi rat ri Ruc'ajol ri Dios. Y ja rat ri Rey richin ri tinamit Israel, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Y ri Jesús xbij chin ri Natanael: Rat xanimaj que ja yin ri Ruc'ajol ri Dios xaxe riq'uin xinbij chave que chuxe' ri jun che' rubini'an higuera ratc'o-vi tok c'a man jani tac'ul ri Felipe. C'o q'uiy c'a na rubanic natz'et richin quiri' nanimaj más. ");
INSERT INTO cakENT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Y ri Jesús xbij c'a chuka': Tinimaj c'a ri ninbij chive: Rix nitz'et c'a que ri caj njakatüj, y que ri ángeles richin ri Dios nyexule-nyejote' chinuto'ic yin ri xinalüx chi'icojol. ");
INSERT INTO cakENT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Y pa rox k'ij, chiri' pa tinamit rubini'an Caná chiri' pa ruch'ulef Galilea, c'o c'a jun c'ulubic xbanatüj. Y ri María ri rute' ri Jesús, c'o c'a chuka' chiri' chupan ri c'ulubic ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Y ri Jesús ye rachibilan ri rachibila', xe'oyox c'a chuka' chupan ri c'ulubic ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jac'a ri ruya'al-uva xa xq'uis yan chanin chupan ri c'ulubic ri'. Y ri María ri rute' ri Jesús, xapon c'a apu riq'uin ri Jesús y xberubij chin: Man jun chic tz'uj ruya'al-uva quiq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pero ri Jesús xbij c'a chin: ¿Achique c'a ri najo'? Roma ri nu-hora xa man jani tapon, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Y ri rute' ri Jesús xbij c'a cheque ri ajic'a': Si c'o ri nbij ri Jesús chive, tibana' c'a, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Y chiri' yec'o c'a vaki' (seis) nimak' tak tanax, ye banun riq'uin abüj. Ri israelitas jabel nyecucusaj tanax quiri', roma chupan tanax quiri' nquiya-vi ya' ri nc'atzin cheque richin nquich'ajch'ojrisaj-qui', cachi'el c'a ri nchilabex cheque roma ri qui-ley ri xuya' ri Dios richin ri Moisés. Y ri tanax ri', ochenta o cien litros ya' quipan. ");
INSERT INTO cakENT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Y ri Jesús xbij cheque ri ajic'a': Que'inojsaj chi ya' ri tanax re', xbij cheque. Y ri ajic'a' quiri' vi xquibün. Xequipulisaj c'a can ri nimak' tak tanax ri' ");
INSERT INTO cakENT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","C'ateri' ri Jesús xbij c'a cheque ri ajic'a': Vocomi tipaja-e ba' y tic'uaj chin ri pa'ül chuvüch ri nimak'ij re', richin tutija' na. Y ri ajic'a' xquibün-vi ri xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Y ri pa'ül chuvüch ri nimak'ij ri', tok rutijon chic ka que galán jabel ri ruya'al-uva ri', xroyoj c'a ri achi culbel chupan ri c'ulubic ri'. Ri pa'ül c'a chuvüch ri nimak'ij ri', man retaman c'a tüj ape' petenük-vi ri ruya'al-uva ri'. Xaxe c'a ri ajic'a' ri xepajon ri ye etamayon. ");
INSERT INTO cakENT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Y tok ri achi culbel xapon c'a, ri pa'ül chuvüch ri nimak'ij richin ri c'ulubic ri' xbij c'a chin: Tok c'o jun nimak'ij quere', conojel c'a vinük ja ri ruya'al-uva ri utz nquiya' nabey, y tok xa yojtajnük chic pa quichi' ri yec'o pa nimak'ij, roma q'uiy chic ri Quitijon, nquiya' c'a jun choj ruya'al-uva. Pero rat xa man quiri' tüj xabün. Rat xa c'a ri' xabevelesaj-pe ri ruya'al-uva ri utz, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ri xbün c'a ri Jesús que xbün ruya'al-uva chin ri ya' pa c'ulubic pa tinamit Caná chiri' pa ruch'ulef Galilea, jari' ri nabey milagro ri xbün. Y ri jun milagro re', xuc'ut c'a que rija' c'o-vi nim ruk'ij. Y ri ye rachibila' xquiya' c'a cánima riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tok ya tzurnük chic c'a can ri c'ulubic, ri Jesús rachibilan ri rute', ri ye ruchak' y ri rachibila' xebe pa tinamit Capernaum. Y xec'uje' c'a ca'i-oxi' k'ij chiri'. ");
INSERT INTO cakENT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Y nakaj chic c'a ri k'ij richin ri quinimak'ij ri israelitas, ri rubini'an pascua, k'ij tok nyecamsüs ri alaj ovejas. Romari' ri Jesús xbe c'a pa tinamit Jerusalén, richin ri nimak'ij ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Y chiri' chuvüch racho ri Dios ri c'o pa Jerusalén, ri Jesús xeberila' c'a nyec'ayin vacx, nyec'ayin ovejas, y nyec'ayin palomas. Y xeberila' chuka' q'uexoy-ruvüch tumin ye tz'uyul chiri'. ");
INSERT INTO cakENT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ri Jesús, xe c'a xerutz'et, xbün c'a jun ruch'aybül riq'uin colo' y xerokotaj-pe conojel. Xerokotaj c'a pe cachibilan ri qui-ovejas y ri quivacx chiri' chuvüch racho ri Dios. Y cheque ri q'uexoy-ruvüch tumin, xuc'akala' c'a can ri qui-tumin chiquivüch y xerutecamayila' can ri qui-mesas. ");
INSERT INTO cakENT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Y cheque ri nyec'ayin palomas xbij c'a: Que'ivelesaj-e re' chere'. Y man tibün chin ri racho ri Nata' Dios, jun c'ayibül, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Romari' ri rachibila', chanin c'a xka-pe chiquic'u'x ri jun tzij tz'iban chupan ri rutzij ri Dios. Ri tzij c'a ri' nbij: Nupaxij vánima ri itzel nyetajin chubanic ri vinük chupan ri avacho, nbij. ");
INSERT INTO cakENT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Y jari' tok ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, xquibij chin ri Jesús: ¿Achique c'a ncatiquer nac'ut chikavüch richin que nketamaj que c'o avuchuk'a' pan ak'a' richin xe'avokotaj-e ri vinük chere'? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Y ri Jesús xbij c'a cheque: Tikasaj c'a pan ulef ri jun jay re', ri richin ri Dios, y yin pan oxi' k'ij ninyüc jun bey chic, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Y jari' tok ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, xquibij chin ri Jesús: Ri jun jay re', cuarenta y seis juna' xquibün ri kate-katata' chirij richin xquipaba'. ¿Ncatiquer comi c'a rat napaba' pan oxi' k'ij? xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ri jay ri xbij ri Jesús cheque ri vinük ri', ja ri mismo ruch'acul. ");
INSERT INTO cakENT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Y romari', tok ri Jesús xcamsüs chuvüch ri cruz y pa rox k'ij xbec'astüj-pe, ri rachibila' xquic'uxla'aj-pe ri jun tzij re' ri xbij cheque ri achi'a' ri c'o quik'ij chiquicojol ri israelitas. Y xquiya' c'a cánima riq'uin ri rutzij ri Dios ri tz'iban can y riq'uin ri tzij ri ye rubin can ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Y chupan c'a ri k'ij tok c'o-ka ri Jesús pa Jerusalén roma ri nimak'ij pascua, ye q'uiy vi c'a vinük ri xetaken. Ri vinük re' xquitakej tok xequitz'et ri milagros ri xerubün chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero ri Jesús man c'a xuya' tüj ránima quiq'uin ri vinük ri', roma rija' retaman-vi ri c'o pa tak cánima conojel vinük. ");
INSERT INTO cakENT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Y man nc'atzin tüj c'a chin que c'o ta jun ri nbin chin achique rubanic ri quic'aslen chiquijujunal ri vinük, roma rija' retaman-vi achique c'a ri c'o pa tak cánima. ");
INSERT INTO cakENT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Y c'o c'a jun achi chiquicojol ri fariseos ri rubini'an Nicodemo, y ri achi re' c'o-vi c'a ruk'ij chiquivüch ri ruvinak israelitas. ");
INSERT INTO cakENT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Y pa jun ak'a', rija' xapon riq'uin ri Jesús y xbij chin: Nk'alajin-vi c'a que rat jun Maestro ri takon-pe roma ri Dios, roma ri milagros ri nye'abanala', xaxe c'a ri c'o Dios riq'uin ri ntiquer nbanun. ");
INSERT INTO cakENT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Y ri Jesús xbij c'a chin ri Nicodemo: Yin ketzij c'a ri ninbij chave: Ri achique c'a ri man nalüx tüj chic, man ntoc tüj pa ruk'a' ri Dios, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pero ri Nicodemo xbij chin ri Jesús: ¿Ntiquer comi nalüx jun bey chic jun achi cachi'el yin, yin ri'j chic? ¿Y ntiquer comi que ri nte' nquiralaj jun bey chic? xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ri Jesús xbij c'a: Yin ketzij vi c'a ri ninbij chave: Ri c'ac'a' alaxic ri xinbij, jari' ri nban roma ri Lok'olüj Espíritu y ya'. Y ri man c'a nquic'uaj tüj ri jun c'ac'a' alaxic ri', man nye'oc tüj pa ruk'a' ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ri vinük c'a ri ruc'uan xaxe ri alaxic richin ri ruch'ulef, aj-ruch'ulef vi. Jac'a ri vinük ri ruc'uan chuka' ri alaxic richin ri Lok'olüj Espíritu, richin vi ri Lok'olüj Espíritu. ");
INSERT INTO cakENT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Y man tisatz c'a ac'u'x riq'uin ri ninbij chave, roma quiri' vi: Conojel c'a nc'atzin que nquic'uaj jun chic c'ac'a' alaxic. ");
INSERT INTO cakENT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ri nye'uc'uan ri alaxic richin ri Lok'olüj Espíritu, njalatüj ri quic'aslen. Y ri Lok'olüj Espíritu ri njalon ri quic'aslen, man c'a tz'etetüj tüj. Xa cachi'el c'a ri cakik' ri ape' na nc'ulun-vi-pe. Roma xaxe navac'axaj, pero man c'a avetaman tüj ape' petenük-vi y man avetaman tüj chuka' ape' nbe-vi, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Y ri Nicodemo xuc'utuj c'a chin ri Jesús: ¿Achique c'a rubanic ri'? ");
INSERT INTO cakENT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ri Jesús xbij c'a chin: ¿Man avetaman tüj c'a achique rubanic re', y rat jun maestro chiquicojol ri kavinak israelitas? ");
INSERT INTO cakENT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yin ja ri vetaman y nutz'eton ri nintzijoj, jac'a rix vinük man nijo' tüj ninimaj. ");
INSERT INTO cakENT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Rix man ninimaj tüj ri ninbij chive, y xa pari' cosas richin ri ruch'ulef. Y ja ta cala' nintzijoj ta chive ri achique ri ye richin chila' chicaj. ");
INSERT INTO cakENT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ri chila' chicaj man jun chic c'a ri xapon tüj, xaxe c'a ri Jun kajnük-pe chila'. Xe rija' ri xapon. Xaxe ri Jun ri xalüx chi'icojol y chila' chicaj riq'uin ri Dios c'o-vi racho. ");
INSERT INTO cakENT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Y ojer-ojer can ri', tok ri Moisés xc'uje' pa tz'iran ruch'ulef, rija' xutic c'a jun che' nim rakün y xuya' jun ruvachbül cumütz pari'. Y cachi'el c'a xban chin ri ruvachbül ri cumütz chutza'n ri che' re', quiri' chuka' nc'atzin que nban chin ri Jun ri alaxnük chi'icojol. ");
INSERT INTO cakENT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Richin quiri' achique c'a vinük ri nitaken richin, man c'a napon tüj chupan ri camic ri richin chi jumul, xa nc'uje' ruc'aslen ri man nq'uis tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ri Dios juis vi c'a njo'on. Xerujo' ri vinük ri yec'o chuvüch ronojel ruch'ulef, y romari' xutük c'a pe ri Ruc'ajol chere' chuvüch ri ruch'ulef. Rija' xaxe c'a jun Ruc'ajol c'o, pero xutük-pe richin que achique na c'a vinük ri nitaken richin, man c'a napon tüj chupan ri camic ri richin chi jumul, xa nc'uje' ruc'aslen ri man nq'uis tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Roma ri Dios man xutük tüj pe ri Ruc'ajol chere' chuvüch ri ruch'ulef, richin que nbün-pe juzgar pa quivi' ri vinük y nuya-pe tüj ru-castigo richin chi jumul pa quivi'. Man quiri' tüj. Ri Dios xutük-pe ri Ruc'ajol, richin que nkurucolo-pe-ka chupan ri kamac. ");
INSERT INTO cakENT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Y achique vinük ri ntaken richin, man nka' tüj ru-castigo pari'. Jac'a ri vinük ri man ntaken tüj richin, ri ru-castigo richin chi jumul xa c'o chic c'a pari', roma xa man xutakej tüj rubi' ri junayin Ruc'ajol ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Conojel vi c'a ri man nyetaken tüj, c'o chic ri ru-castigo pa quivi', roma ri Sük xka-pe chuvüch ri ruch'ulef, pero rije' xa más xcajo' ri k'eku'n que chuvüch ri Sük, roma rije' xe vi c'a ri itzel tak nojibül ri nyequibanala'. ");
INSERT INTO cakENT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Y conojel c'a ri nyebanun ri itzel tak nojibül, man nka-pe tüj c'a ri Sük chiquivüch, ni man chuka' nyejel tüj apu riq'uin, roma ri Sük re' nbün c'a que nyebek'alajin-pe ronojel ri itzel tak quinojibül ri nyetajin chubanic. ");
INSERT INTO cakENT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jac'a ri vinük ri nyequibanala' nojibül richin ri ketzij, nyebe-vi-apu chupan ri Sük, richin nyek'alajin que nyetiquer nquibün quiri' roma jun quibanun riq'uin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Y tok banatajnük chic c'a ronojel re', ri Jesús ye rachibilan ri rachibila' xbe pa ruch'ulef Judea, y chiri' xebec'uje-vi. Y xetapon c'a vinük chiri' richin xeban-e bautizar. ");
INSERT INTO cakENT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chupan c'a chuka' ri tiempo ri', ri Juan Bautista c'o c'a chiri' pan Enón, ri c'o-apu chunakaj ri tinamit rubini'an Salim. Rija' chiri' c'a nyerubün-vi bautizar ri vinük, roma chupan ri lugar ri' jabel ya' c'o. Ri vinük nye'apon c'a riq'uin richin nyeban-e bautizar. ");
INSERT INTO cakENT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chupan ri tiempo ri' ri Juan man jani tüj c'a xtz'apis pa cárcel. ");
INSERT INTO cakENT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Y yec'o ruvinak israelitas ri xquibila' chiquivüch quiq'uin ri rachibila' ri Juan pari' ri achique bautismo ri más utz. ");
INSERT INTO cakENT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xepu'u c'a ri achibila' ri' xebe c'a riq'uin ri Juan y xbequibij chin: Maestro, xquibij c'a, ri Jun ri xapon aviq'uin lojc'an chic ruchi-ya' Jordán, ri xabij que ja rija' ri nak'alajrisaj, xa conojel chic ri vinük nye'apon riq'uin richin que querubana' bautizar. ");
INSERT INTO cakENT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ri Juan xbij c'a cheque ri rachibila': Ja ri Dios nbin achique ri nc'uje' ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Y rix mismo nyixtiquer nyixbin achique ri nubin yin, que xa man ja tüj yin ri Cristo. Yin xaxe nubin que xintak-pe richin que ninchojmirsaj ri ape' nka-pe rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yin xtz'aküt c'a ri quicot pa vánima vocomi, riq'uin ri xinvac'axaj que juis ye q'uiy vinük nye'apon riq'uin ri Jesús. Ninc'ulachij c'a ri nuc'ulachij jun ala' rachibil ri ala' c'a ruc'ulubic, roma ri jun ri' nquicot que nyerac'axaj ri juc'ulaj nyetzijon y quic'uan chic qui'. Retaman c'a que ri xtün c'o chic apu riq'uin ri rachijil. ");
INSERT INTO cakENT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Xe c'a ri Jesús ri c'uluman que nnimür ruk'ij, jac'a yin más utz que nquich'utinür-ka. ");
INSERT INTO cakENT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ri Jun ri petenük chicaj, jari' ri más nim que chikavüch konojel roj vinük. Roma roj vinük, ri vit kana'oj xe oc chere' chuvüch ri ruch'ulef nq'uis-vi-ka. Xe oc ri' ri nkutiquer nkatzijoj. Jac'a ri Jun ri kajnük-pe chila' chicaj, man cachi'el tüj oc roj, roma rija' c'o c'a pari' ronojel. ");
INSERT INTO cakENT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ri Jun c'a ri petenük chila' chicaj, ja ri rac'axan-pe y rutz'eton can, jari' ri nberuk'alajrisaj-ka cheke. Pero ri vinük man ncajo' tüj nquic'ul ri nuk'alajrisaj rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Y ri vinük c'a ri nuniman ri nuk'alajrisaj ri Jun ri petenük chila' chicaj, nuk'alajrisaj c'a que ri Dios ketzij vi. ");
INSERT INTO cakENT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Roma ri Jun ri xutük-pe ri Dios chuvüch ri ruch'ulef, ja vi ri rutzij ri Dios ri nutzijoj. Y ri Dios ruyo'on c'a pe ri Lok'olüj Espíritu chin. Y ri Lok'olüj Espíritu ri nuya-pe chin rija' man jun ri ntiquer tüj netan. ");
INSERT INTO cakENT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Y ri Tata'aj juis vi c'a nrajo' ri Ruc'ajol, y pa ruk'a' rija' xujüch-vi ronojel. ");
INSERT INTO cakENT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Achique c'a vinük ri nyetaken richin ri Ruc'ajol, nc'uje' quic'aslen ri man nq'uis tüj. Jac'a ri vinük ri man ncajo' tüj nquitakej ri Ruc'ajol ri Dios, man c'a nc'uje' tüj quic'aslen. Roma ri vinük ri man nquiya' tüj cánima riq'uin, yec'o chic c'a richin nka-ka ri ru-castigo ri Dios pa quivi'. ");
INSERT INTO cakENT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ri achi'a' fariseos cac'axan c'a que ri Jesús más vinük ri nyerubün bautizar y más ye q'uiy ri nyetzekleben richin, que chiquivüch ri vinük ri nyeban bautizar y ri nyetzekleben richin ri Juan Bautista. Y ri Ajaf Jesús xretamaj c'a ronojel re'. ");
INSERT INTO cakENT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero ri Jesús man ja tüj rija' ri nyebanun bautizar ri vinük. Xa ja ri ye rachibila' ri nyebanun bautizar. ");
INSERT INTO cakENT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Y ri Jesús xel c'a e chiri' pa ruch'ulef Judea y xtzolij jun bey chic pa ruch'ulef Galilea ye rachibilan ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Xa ja richin que nye'apon c'a pa ruch'ulef Galilea, nc'atzinej que nyec'o pa ruch'ulef Samaria. ");
INSERT INTO cakENT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ri Jesús ye rachibilan ri rachibila' xe'apon c'a pa Sicar. Ri Sicar jun tinamit richin ri Samaria. Ri Sicar c'o c'a apu chunakaj ri ulef ri xuya' ri Jacob chin ri José ri ruc'ajol. ");
INSERT INTO cakENT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Y ja chiri' c'o-vi ri pozo ri nbix Richin Jacob chin. Chiri' c'a xtz'uye-vi-ka ri Jesús, roma rija' juis c'a cosnük-pe roma ri bey quibanun-pe. Ri' colope' pa nic'aj-k'ij ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Y tok ye benük c'a ri rachibila' pa tinamit chulok'ic vüy, chiri' chi pozo xapon c'a jun ixok aj chiri' pa Samaria, chirelesasic ruya'. Y ri Jesús xbij c'a chin ri ixok ri': Taspaj ba' nuya' richin nintij, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pero ri ixok aj-Samaria xbij c'a chin ri Jesús: Rat rat jun israelita, ¿y achique roma tok nac'utuj aya' chuve yin? ¿C'uluman comi c'a que jun aj-Samaria nuya' ruya' jun israelita? xbij ri ixok. Rija' xbij quiri' roma ri ye israelitas y ri ye aj-Samaria man junan tüj quivüch. ");
INSERT INTO cakENT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","C'ateri' ri Jesús xbij c'a chin ri ixok ri': Si avetaman ta rat achique chi sipanic ruyo'on-pe ri Dios, y avetaman ta chuka' achique c'a ri' ri nc'utun ba' ruya' chave, xa ja ta rat ri ncac'utun aya' chin, y rija' nuya' ta Aya' ri nyo'on c'aslen, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Y ri ixok xbij c'a chin ri Jesús: Ri pozo nüj kajnük-vi-ka, y rat man jun ac'uan richin nac'ün-ka ya'. ¿Ape' c'a nac'ün-vi ri Ya' ri nyo'on c'aslen ri nasuj? ");
INSERT INTO cakENT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Roma chupan c'a ri jun pozo re' xuc'ün-vi ruya' ri kaxquin-kamama' can Jacob, ri ye ralc'ual y quichin chuka' ri quichico. ¿Ape' ta c'a nac'ün-vi ri Ya' ri nasuj? ¿O c'o más ak'ij rat que chuvüch ri kaxquin-kamama' can Jacob que man chere' tüj navelesaj-vi ri Ya' ri nabij que nuya' c'aslen? xbij ri ixok. ");
INSERT INTO cakENT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Y ri Jesús xbij c'a chin ri ixok: Ri nyetijon ri ya' re', ri ntel chupan ri pozo, man nuc'usaj tüj e ri ruchakal quichi'. Xa nc'atzin c'a que nquitij más ya' richin que nch'uptüj-ka ba' ri ruchakal quichi'. ");
INSERT INTO cakENT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jac'a ri nyetijon ri Ya' ri nyo'on c'aslen ri ninya' yin cheque, nbün c'a chin ri cánima que man chic nchaki'j tüj quichi'. Xa nbün cheque que quiq'uin rije' nalüx-vi ri Ya' ri', y nchoxin c'a pe richin que nyeruc'uaj chupan ri c'aslen ri man nq'uis tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Y ri ixok jari' tok xbij chin ri Jesús: Taya' c'a ri Ya' ri' chuve yin, richin quiri' man jun bey chic c'a nchaki'j nuchi', y richin man jun chic nc'atzin-vi que nquipu'u chere' chi pozo chirelesasic ya', xbij ri ixok. ");
INSERT INTO cakENT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Pero ri Jesús xbij c'a chin ri ixok: Cabiyin y que'avoyoj-pe ri avachijil, xbix chin roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ri ixok xbij c'a: Yin manak vachijil, xbij. Y ri Jesús xbij chin: Ketzij vi ri nabij que manak avachijil. ");
INSERT INTO cakENT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Roma ye vo'o' yan avachijil yec'o. Y ri achi ri c'o aviq'uin vocomi, xa man avachijil tüj. C'uluman-vi c'a ri xabij que manak avachijil. ");
INSERT INTO cakENT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Y jari' tok ri ixok xbij chin ri Jesús: Yin ninnuc que rat rat jun k'alajrisüy richin ri nbix chave roma ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","¿Achique c'a lugar c'uluman que nkaya-vi ruk'ij ri Dios? Roma ri kaxquin-kamama' can ri xec'uje' ojer can, pari' ri jun juyu' re' xquibün-vi ri jay richin xquiya' ruk'ij ri Dios. Pero rix israelitas nibij que conojel vinük nc'atzinej ja pa tinamit Jerusalén nquiya-vi ruk'ij ri Dios, xbij ri ixok. ");
INSERT INTO cakENT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jac'a ri Jesús xbij chin ri ixok ri': Tanimaj c'a ri ninbij chave. Nka-pe c'a jun k'ij tok ronojel vinük man ja tüj chic pari' ri juyu' re', ni man pa Jerusalén tüj chuka' nquiya-vi ruk'ij ri Katata' Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Rix aj-Samaria q'uiy c'a ri man ivetaman tüj pari' ri niya' ruk'ij. Jac'a roj israelitas ketaman-vi ri achique nkaya' ruk'ij, roma ja kiq'uin roj petenük-vi ri colonic quichin ri vinük chupan ri quimac. ");
INSERT INTO cakENT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ri jun k'ij ri xinbij chave que npu'u-vi, xka-pe yan, richin conojel vinük man nquiya' tüj chic ruk'ij ri Katata' Dios pari' ri juyu' re', ni chuka' pa tinamit Jerusalén. Ri ketzij nyeyo'on ruk'ij ri Katata' Dios, ja ri c'o ri Lok'olüj Espíritu quiq'uin, y chuka' riq'uin ronojel cánima nquiya' ruk'ij. Y ri Dios ja ri vinük ri nyebanun quiri' ri nyerujo'. ");
INSERT INTO cakENT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ri Dios Espíritu vi. Roma c'a ri' ri vinük ri nyeyo'on ruk'ij, nc'atzin que c'o ri Lok'olüj Espíritu quiq'uin y riq'uin ronojel cánima tiquiya' ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Y ri ixok xbij c'a chin ri Jesús: Yin vetaman c'a que c'o na jun k'ij tok nka-pe chuvüch ri ruch'ulef ri Mesías, ri nbix chuka' Cristo chin, ri Jun cha'on-pe y takon-pe roma ri Dios. Y ri k'ij tok nka-pe rija', ronojel c'a nuk'alajrisaj chikavüch, xbij ri ixok. ");
INSERT INTO cakENT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ri Jesús xbij c'a chin: Ri Mesías ri nibij chuka' Cristo chin, ja yin ri'. Ja yin ri nquitzijon chave, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Y jari' tok xe'apon ri rachibila', y rije' jun vi ba' xquitz'et roma ntzijon riq'uin jun ixok aj chiri' pa Samaria. Pero ri achibila' man jun xquibij chin ri Jesús: ¿Achique nac'utuj chin? o ¿Achique ri natzijoj riq'uin? Man jun vi c'a xquic'utuj chin. ");
INSERT INTO cakENT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Y ri ixok ri' xuya' c'a can ri rucura' y xbe pa tinamit. Y xberubij c'a cheque ri vinük: ");
INSERT INTO cakENT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","C'o jun achi xtzijon viq'uin y xbij c'a chuve ronojel ri ye nubanalun. ¿Man ja tüj comi c'a re' ri Cristo, ri Jun cha'on-pe y takon-pe roma ri Dios? Jo', y titz'eta', xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Y ri vinük ri xe'ac'axan ri', xquiya' can ri tinamit y xebe c'a ape' c'o-vi ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Y tok man jani tüj c'a que'apon ri vinük, ri achibila' xquibij c'a chin ri Jesús: Maestro, tac'uxu' avay, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero rija' xbij c'a cheque: Rix man c'a ivetaman tüj que yin c'o nuvay richin ninc'ux, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","¿C'o comi xc'amon-pe ruvay? xquibij-ka ri achibila' chiquivüch rije'. ");
INSERT INTO cakENT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Y ri Jesús xbij cheque: Ri nuvay yin ja ri ninbün ri rurayibül ri takayon-pe vichin y ninq'uis can rubanic ronojel ri rusamaj ri ruchilaben-pe chuve. ");
INSERT INTO cakENT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Rix nibij c'a que c'o na caji' ic' nrajo' richin que nic'ol ronojel quivüch tico'n. Jac'a yin ninbij chive: Quixtzu'un chila' y que'itz'eta' la vinük. Rije' ye cachi'el jun tico'n ri k'ün chic. Coyoben chic richin ntzijos ri rutzij ri Dios cheque, richin nquitakej. ");
INSERT INTO cakENT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ri nyebanun c'a la cosecha la', c'o c'a rajil-ruq'uexel nquic'ul, roma ri vinük ri nitaken ri rutzij ri Dios, nuc'ul ruc'aslen ri man nq'uis tüj. Y riq'uin ri', ri ye tiquiyon can ri rutzij ri Dios, nquicot c'a cánima quiq'uin ri nyec'olon ri jun ruvüch cosecha re'. ");
INSERT INTO cakENT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chere' ketzij vi c'a ntel ri tzij ri nbij: Jun vi c'a ri nbanun can ri ticoj y jun vi chic ri nc'olon ruvüch ri tico'n. ");
INSERT INTO cakENT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yin xixintük c'a richin que rix xaxe chic nic'ol ri cosecha ri man ja tüj rix ri xixcos chusamajisic. Roma ri rutzij ri Dios ch'aka chic c'a samajela' ye tiquiyon can pa tak cánima ri vinük, y rix xaxe chic c'a ba' samaj ri nyixbebana' richin nquitakej ri rutzij ri Dios, xbij ri Jesús cheque ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Y chupan c'a ri k'ij ri', ye juis vi ri vinük xetaken richin ri Jesús chiri' pa tinamit Sicar, ri c'o chiri' pa ruch'ulef Samaria. Y ri' roma ri xberubij ri ixok cheque que ri Jesús xbij chin ronojel ri ye rubanalun. ");
INSERT INTO cakENT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Y ri aj-Samaria ri' xbequic'utuj c'a chin ri Jesús que tic'uje-ka quiq'uin. Y rija' xc'uje' c'a ka ca'i' k'ij quiq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Y yec'o c'a ch'aka chic vinük ri aj chiri' ri xetaken, pero c'a ja tok cac'axan chic na ri tzij ri nbij ri Jesús. Ye q'uiy vi c'a ri xetaken. ");
INSERT INTO cakENT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ri vinük c'a re' nquibila' c'a chin ri ixok ri xbeyo'on rutzijol cheque: Vocomi ketaman chic c'a y nkatakej chuka', man xe tüj roma ri xabij rat cheke, xa nkatakej chuka' roma ri xkac'axaj roj mismo. Xketamaj c'a que ketzij vi que ja rija' ri Cristo, ri Colonel quichin conojel vinük ri yec'o chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tok c'unük chic ri ca'i' k'ij, xuya' can ri tinamit Sicar ri c'o chiri' pa ruch'ulef Samaria y xutz'om chic c'a e ri rubey richin nbe c'a pa ruch'ulef Galilea. ");
INSERT INTO cakENT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Y ja ri Jesús ri nbin que jun ri nk'alajrisan ri rutzij ri Dios pa rutinamit, xa man jun ruk'ij chiquivüch ri ruvinak. ");
INSERT INTO cakENT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pero tok ri Jesús xapon pa Galilea, jabel ruc'ulic xban coma ri vinük aj chiri', roma ri vinük re' xec'uje' pa tinamit Jerusalén richin ri nimak'ij y xquitz'et ri milagros ri xerubanala' ri Jesús chiri'. ");
INSERT INTO cakENT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","C'ateri' ri Jesús xbe chic c'a jun bey pa tinamit Caná ri c'o chiri' pa Galilea, ape' xbün que xoc ruya'al-uva ri ya'. Y chiri' pa Galilea, pa jun chic tinamit ri rubini'an Capernaum, c'o c'a jun achi nimalüj rusamajel ri rey, nye'avüj jun ruc'ajol. ");
INSERT INTO cakENT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ri achi ri rusamajel ri rey, tok xrac'axaj que ri Jesús petenük c'a cala' pa ruch'ulef Judea y xapon chiri' pa ruch'ulef Galilea, xbe c'a riq'uin. Rija' xberuc'utuj favor chin richin nucol tüj ri ruc'ajol chuvüch ri camic, roma ri ala' ri' xa ncom yan. ");
INSERT INTO cakENT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","C'ateri' ri Jesús xbij c'a chin ri rusamajel ri rey: Man ta nitz'et rix ri milagros ri ninbün yin, xa man nquinitakej tüj. Y chuka' si man ta nk'alajin riq'uin ri milagros que ja ri Dios ri takayon-pe vichin, xa man tüj chuka' nquinitakej. ");
INSERT INTO cakENT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero ri achi ri rusamajel ri rey xbij c'a chin ri Jesús: Ajaf, tabana' c'a favor que ncaxule' ta c'a ka pa tinamit Capernaum, roma ri nuc'ajol xa ncom yan. ");
INSERT INTO cakENT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Y ri Jesús xbij c'a chin: Catzolij. Ri ac'ajol nc'ase' c'a can, xbix-e. Y ri achi ri' xunimaj-vi ri xbij ri Jesús, y xbe. ");
INSERT INTO cakENT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tok ri achi ri rusamajel ri rey rutz'amon-ka nutzolij, yec'o c'a rajic'a' xepu'u chuc'ulic y xquibij c'a chin: Ri ac'ajol c'üs. Man xcom tüj, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Y rija' xuc'utuj c'a cheque ri ajic'a' ri' achique c'a hora tok ri ruc'ajol xk'alajin que nc'achoj. Y ri ajic'a' xquibij: Ja ri xkak'ij ivir. La una chiri', tok xq'uis-e ri c'atün chirij, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ri rutata' ri ala' yava', chanin c'a xka-pe chuc'u'x que ja hora ri' tok ri Jesús xbij chin que ri ruc'ajol man ncom tüj. Y romari' rija' y ri ye aj pa racho xquitakej c'a ri Jesús, xquiya' c'a cánima riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Y jare' ri ruca'n milagro ri xbün ri Jesús chiri' pa ruch'ulef Galilea, milagro ri nk'alajrisan richin que ja vi ri Dios takayon-pe richin. Y re' jare' ri milagro ri xbün tok petenük c'a cala' pa Judea. ");
INSERT INTO cakENT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Y tok banatajnük chic c'a ronojel ri', jari' nka-pe yan c'a jun quinimak'ij ri israelitas, y romari' tok ri Jesús nc'atzinej xbe-e pa tinamit Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chiri' c'a pa tinamit Jerusalén, chunakaj apu ri puerta Quichin ri Ovejas nbix chin, c'o c'a jun piscina. Y chiri' chuchi' ri ya' yec'o c'a vo'o' corredores. Y ri vinük israelitas nquibij c'a Betesda chin ri lugar ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chiri' c'a pa tak corredores ri' juis ye q'uiy yava'i' ye cotz'ol chiri' pan ulef. Yec'o ye moy, yec'o ri man choj tüj nyebiyin roma ri ye jetz', y yec'o ri man nyetiquer tüj nyesilon quich'acul. Y yec'o c'a ri jun vi chic chi ruvüch yabil ntoc cheque. Y ronojel c'a quivüch yava'i' ri', coyoben c'a que nsilon-pe ri ya'. ");
INSERT INTO cakENT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Roma ri ya' re' c'o c'a k'ij tok nsilos can roma jun ángel ri npu'u chila' chicaj riq'uin ri Dios. Y ja ri yava' ri nka-ka nabey chupan ri ya' tok silon chic, ja yava' ri' ri nc'achoj. Y achique na yabil ntoc chin ri yava', nc'achoj-e. ");
INSERT INTO cakENT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Y chiri' chuchi' ri ya' c'o c'a jun achi ri yava' treinta y ocho juna'. ");
INSERT INTO cakENT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Y jun k'ij tok ri Jesús nc'o c'a e chiri', xutz'et c'a ri achi cotz'ol chiri'. Y rija' retaman c'a que ri achi ri' q'uiy yan c'a juna' ri quiri' ruc'ulachin-pe. Y c'ateri' rija' xuc'utuj c'a chin ri achi ri': ¿Najo' ncac'achoj? xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Y ri yava' re' xbij c'a chin ri Jesús: Tok nsilon-pe la ya', man jun nbanun favor chuve richin ta nquiruto' nquinapon-apu c'a chupan. Romari', stape' (aunque) nintij nuk'ij que nquibe ta apu, man jani quinapon tok ja yan ri' xapon chic jun, xbij chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Y ri Jesús xbij chin ri achi: Cacatüj, tac'uaj-e la avarabül y cabiyin, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Xe c'a xbij quiri' ri Jesús chin ri yava', jari' tok xc'achoj chin ri ruyabil. Xuc'ol c'a e ri ruvarabül y xutz'om-e bey. Ri k'ij c'a ri', richin uxlanen. ");
INSERT INTO cakENT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Y ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, xquibij chin ri achi ri xc'achojrisüs chin ri ruyabil: Vocomi k'ij richin uxlanen, xa xajan que rat ac'uan-e la avarabül. ");
INSERT INTO cakENT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pero rija' xbij c'a cheque ri achi'a' ri': Ri xc'achojrisan vichin xbij chuve: Tac'olo-e la avarabül y cabiyin. ");
INSERT INTO cakENT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Y ri achi'a' ri' xquic'utuj c'a chin ri achi: ¿Achique c'a ri xbin chave que tac'olo' ri avarabül y cabiyin? xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero ri achi ri xc'achojrisüs, man retaman tüj c'a achique ri xc'achojrisan chin ri ruyabil, roma ri Jesús xa man xc'uje' tüj ka chiri' chiquicojol ri vinük. Rija' xa xbe. ");
INSERT INTO cakENT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Y juba' chic ri Jesús xberila' chic ri achi ri' pa racho ri Dios, y xbij chin: Vocomi xa rat utz chic. Man camacun chic c'a, richin quiri' man tavoyobej jun cosa más itzel chavij, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Y ri achi xtzolij-e, y xapon c'a quiq'uin ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, y xbij cheque: Ri xc'achojrisan vichin, ja ri Jesús, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Romari' tok ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, xecatüj c'a chirij ri Jesús, y nquinucula' c'a achique ta modo nquibün richin nquicamsaj, roma ri Jesús c'o milagros nyerubanala' chupan ri k'ij richin uxlanen. ");
INSERT INTO cakENT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero ri Jesús xbij: Ri Nata' Dios c'a nsamüj ri k'ij re', y quiri' c'a chuka' yin, nquisamüj. ");
INSERT INTO cakENT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Y jari' tok ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, más xquinuc pari' richin achique ta modo nquibün richin nquicamsaj ri Jesús, roma chiquivüch rije', xajan ri nyerubanala' chupan ri k'ij richin uxlanen. Y chuka' man xe tüj c'a romari', xa roma c'a chuka' ri Jesús nbij Rutata' chin ri Dios, roma chiquivüch rije', ri Jesús nbün que rija' junan riq'uin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Y jari' tok ri Jesús xbij: Ketzij c'a ri ninbij chive, que yin ri Ruc'ajol ri Dios man nquitiquer tüj nquisamüj nuyon. Xa nc'atzin que ninvoyobej na ri nbij ri Nata'. Roma ja ri samaj ri nrajo' rija', jari' ri ninbün yin ri Ruc'ajol. ");
INSERT INTO cakENT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Y roma ri Nata' Dios juis nquirujo' yin ri Ruc'ajol, romari' tok rija' nuc'ut chinuvüch ronojel ri rusamaj rija'. Y chikavüch apu c'o samaj más ye nimak' ri nuc'ut chinuvüch. Y tok ninbün ri samaj re', rix nsatz c'a ic'u'x chutz'etic. ");
INSERT INTO cakENT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Y cachi'el c'a nbün ri Nata' Dios tok nuya' quic'aslen ri caminaki' ri nyeruyüc-pe, quiri' c'a chuka' ninbün yin. Yin ninya' c'a chuka' quic'aslen ri nyenjo'. ");
INSERT INTO cakENT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ri Nata' Dios, pa nuk'a' c'a chuka' yin ri Ruc'ajol rujachon-vi ri juicio y man ja tüj c'a rija' ri nbanun. ");
INSERT INTO cakENT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Richin quiri', yin ninc'ul c'a chuka' nuk'ij cachi'el ri nuc'ul ri Nata'. Roma achique vinük ri man nyo'on tüj nuk'ij yin ri C'ajol, man nuya' tüj c'a chuka' ruk'ij ri Nata', ri takayon-pe vichin. ");
INSERT INTO cakENT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Roma ketzij vi ri ninbij chive, que ri nac'axan ri nutzij y nutakej rubi' ri takayon-pe vichin, nril ruc'aslen ri man nq'uis tüj. Man c'a napon tüj chupan ri lugar richin juis pokonül, roma colotajnük chic chuvüch ri camic, richin xc'o-apu chupan ri c'aslen. ");
INSERT INTO cakENT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Y ketzij c'a ri ninbij chive, que c'o c'a jun k'ij ri oyoben y jare' xka-pe yan, que ri cachi'el ye caminaki' ncac'axaj c'a ri nutzij yin ri Ruc'ajol ri Dios. Y ja ri yincac'axaj-vi, nquil quic'aslen. ");
INSERT INTO cakENT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Roma ri Dios ruyo'on k'ij chuve richin ninya' c'aslen, cachi'el nbün rija'. Ri Nata' Dios nuya-vi c'aslen. ");
INSERT INTO cakENT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Y chuka' nilitüj juicio viq'uin, roma ri Nata' Dios nquirucusaj richin ri', roma rija' retaman que yin xinalüx chi'icojol. ");
INSERT INTO cakENT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Man tinuc c'a que ja ri xinbij yan chive ri más nimak' ri nquitiquer ninbün, man quiri' tüj, roma napon c'a ri k'ij que ri ye caminaki' chic e nc'atzinej c'a ncac'axaj ri nutzij. ");
INSERT INTO cakENT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Y ja ri xe'uc'uan jun c'aslen utz chuvüch ri Dios, nyebecatüj c'a pe richin nquil quic'aslen ri man nq'uis tüj. Y ri man utzilüj tüj c'aslen nquic'uaj chuvüch ri Dios, nyebecatüj c'a pe richin nyebeka' c'a pa pokonül. ");
INSERT INTO cakENT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yin man nquitiquer tüj c'a nquisamüj nuyon, roma xa cachi'el ri juicio ri nk'alajrisüs chinuvüch, quiri' ri ninbün. Ri juicio pa ruchojmil, roma man ja tüj ri nurayibül yin ri ninbün, xa ja ri rurayibül ri Nata' Dios ri takayon-pe vichin, jari' ri ninbün. ");
INSERT INTO cakENT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Y si ta man jun chic nk'alajrisan vichin, utz ta que nbix chuvij que man ketzij tüj ri ninbij. ");
INSERT INTO cakENT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero c'o chic c'a Jun ri nk'alajrisan vichin. Y ri nbij rija' chuvij yin, ketzij vi. ");
INSERT INTO cakENT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Y rix xitük c'a ruc'utuxic chin ri Juan Bautista pari' ri Cristo, y rija' xuk'alajrisaj-pe ri ketzij chivüch. ");
INSERT INTO cakENT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Re' ninc'uxla'aj c'a apu chive, richin nyixcolotüj ta c'a. Roma c'o chic c'a Jun ri más nim ri nk'alajrisan vichin, que chuvüch ri Juan Bautista o jun chic vinük. ");
INSERT INTO cakENT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Y ri Juan Bautista xuya' c'a ri sük chive. Xbün-vi c'a cachi'el nbün juboraj chüj tok nc'at y nsakrisan. Y rix xirayij y xixquicot c'a riq'uin ri sük ri', jun ca'i-oxi' k'ij. ");
INSERT INTO cakENT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Y roma c'a ri xuk'alajrisaj ri Juan pa nuvi' yin, utz vi que nquinitakej. Pero más c'a nc'atzin que nquinitakej, roma ri samaj ri nyenbün yin chivüch. Samaj ri nquik'alajrisaj que ja ri Nata' Dios ri takayon-pe vichin. Y ja rija' ri chilabeyon-pe chuve que ninbün ri samaj re'. ");
INSERT INTO cakENT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Y ja ri Nata' Dios ri xintakon-pe, ri nk'alajrisan chuka' vichin. Y rix man jun bey ivac'axan tüj achique rubanic nbün nch'o, ni man jun bey chuka' itz'eton tüj ruvüch. ");
INSERT INTO cakENT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ri rutzij rija' man c'o tüj c'a pa tak ivánima, roma rix xa man nquinitakej tüj yin ri xintak-pe richin nquic'uje-ka-pe chi'icojol. ");
INSERT INTO cakENT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tinic'oj c'a jabel rupan ri rutzij ri Dios ri tz'iban can, roma ivetaman que chupan ri' nivil-vi c'aslen ri man nq'uis tüj. Y chupan ri rutzij ri Dios ja yin ri nquiruk'alajrisaj. ");
INSERT INTO cakENT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jac'a rix man nijo' tüj niya' ivánima viq'uin, richin quiri' nivil tüj ri ic'aslen ri man nq'uis tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Y ronojel ri xinbij-ka chive, man roma tüj c'a que yin ninjo' ta que rix niya' nuk'ij. ");
INSERT INTO cakENT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yin xa vetaman c'a ivüch jabel, romari' vetaman que xa man jun retal ri nyixjo'on ta richin ri Dios pa tak ivánima. ");
INSERT INTO cakENT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Roma yin pa rubi' ri Nata' Dios yin petenük-vi y xa man xinic'ul tüj. Pero si ta yec'o ri nyepu'u, pa quibi' rije' mismo, jari' sí chi'ivonojel nyixbe chiquic'ulic. ");
INSERT INTO cakENT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Rix c'a ri xa man nicanoj tüj ik'ij riq'uin ri ketzij Dios, y xa quiq'uin vinük nicanola-vi, man c'a niya' tüj ivánima viq'uin yin. ");
INSERT INTO cakENT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Y man c'a tinuc pa tak ivánima que ja yin ri nquisujun chivij chuvüch ri Nata' Dios. Man quiri' tüj. Ri nsujun c'a ivichin chuvüch ri Dios roma man ja tüj ri nibün, ja ri Moisés, ri achique chok q'uin nibij-vi rix que iyo'on-apu ivánima. ");
INSERT INTO cakENT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Roma xa ta ketzij que rix nitakej ri ye rutz'iban can ri Moisés, nquinitakej ta chuka' yin, roma ri ye rutz'iban can rija' chuvij vi yin nyech'o-vi. ");
INSERT INTO cakENT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Y si xa man nitakej tüj ri ye tz'iban can roma ri Moisés, man c'a nitakej tüj chuka' ri tzij ri nuc'amon-pe yin chive, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Y tok ye banatajnük chic c'a can ronojel re', ri Jesús y ri rachibila' xebe c'a lojc'an ruchi-ya' Galilea, lago ri rubini'an chuka' Tiberias. ");
INSERT INTO cakENT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ye juis c'a ye q'uiy vinük ri xetzekleben-e richin, roma ri vinük re' quitz'eton chic c'a ri milagros nyerubanala' quiq'uin ri yava'i', milagros ri nyek'alajrisan richin que ja vi ri Dios takayon-pe richin. ");
INSERT INTO cakENT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ri Jesús y ri rachibila' xejote' c'a e pari' jun juyu', y rija' tz'uyul c'a chiquicojol ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ri k'ij c'a ri', xa nakaj chic c'a c'o-vi ri pascua, ri nimak'ij israelita. ");
INSERT INTO cakENT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Y tok ri Jesús xtzu'un c'a más cala', xutz'et que juis c'a ye q'uiy vinük ri ye apon-apu riq'uin. Romari' rija' xbij c'a chin ri Felipe ri jun rachibil: ¿Ape' nyekalok'o-vi-pe vüy richin nyekatzuk conojel ri vinük re'? ");
INSERT INTO cakENT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Quere' c'a ri xuc'utuj ri Jesús chin ri rachibil, richin nretamaj achique c'a ri nunuc, si nka-pe chuc'u'x que ri Jesús ronojel ntiquer nbün. Pero ri Jesús xa retaman chic ri nc'atzinej nbün richin nyerutzuk ri vinük ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Y ri Felipe xbij c'a chin ri Jesús: Si ta nkalok' ca'i' ciento quetzales vüy, man nyerubün tüj. Man ntel tüj apu chiquivüch, stape' (aunque) xa ba' ta oc ri nkaya' cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","C'ateri' jun c'a cheque ri rachibila', ri rubini'an Andrés y ye quichak'-qui' riq'uin ri Simón Pedro, xbij: ");
INSERT INTO cakENT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Chere' c'o jun ala' c'o vo'o' vüy richin cebada y ca'i' tak cür ye ruc'amon-pe, ¿pero xaxe ta oc re' ri nkaya-apu chiquivüch conojel ri vinük re'? xbij ri Andrés. ");
INSERT INTO cakENT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","C'ateri' ri Jesús xbij c'a: Tibana' cheque la vinük que quetz'uye', xbij rija'. Y ri lugar c'a ri' jabel richin nyetz'uye', roma ri sabana rüx-rüx rubanun. Conojel c'a ri vinük quimolon-qui' chiri' xetz'uye'. Ye colope' vo'o' mil xaxe ri achi'a'. ");
INSERT INTO cakENT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ri Jesús xeruli'ej c'a ri vo'o' vüy re' y xumatioxij chin ri Dios. C'ateri' xujachala-e cheque ri rachibila', y ri achibila' xbequijachala' can cheque ri vinük ri ye tz'uyul. Y ri Jesús quiri' c'a chuka' xbün riq'uin ri ca'i' cür. Ri vinük xquic'ul c'a ri jaru' vüy y cür ri xcajo'. ");
INSERT INTO cakENT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Y tok ye va'inük chic c'a jabel ri vinük ri', ri Jesús xbij c'a cheque ri rachibila': Timolo' c'a pe ronojel vüy y cür ri man xq'uis tüj, roma man ninjo' tüj c'a que c'o ta nyec'uje' can quiri'. ");
INSERT INTO cakENT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ri achibila' xbequimolo' c'a pe y xquinojsaj doce chacüch riq'uin ri man xq'uis tüj ruc'uxic, tok ye va'inük chic conojel. C'a ja na c'a ri' xmolotüj can chin ri vo'o' tak vüy banun riq'uin cebada. ");
INSERT INTO cakENT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Y ri vinük ri', tok quitz'eton chic ka ri milagro ri xbün ri Jesús, ri nk'alajrisan que ja ri Dios ri takayon-pe richin, rije' xquibij: Ketzij vi que ja achi re' ri k'alajrisüy rutzij ri Dios ri q'uiy yan tiempo oyoben que npu'u-vi chuvüch ri ruch'ulef, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ri Jesús ruyon c'a xtzolin-e pari' ri juyu', roma xunabej que ri vinük nyepu'u chuc'amic richin que nquibün qui-rey chin y rija' xa man nrajo' tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Y ri rachibila' ri Jesús xetzolij-ka chuchi-ya', tok xquitz'et que xkak'ij-ka. ");
INSERT INTO cakENT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Rije' xe'oc c'a e pa jun canoa y quitz'amon c'a e bey richin que nyebe c'a pa tinamit Capernaum, ri c'o c'a lojc'an chic ruchi' ri ya'. Juis chic c'a k'eku'n chiri' y ri Jesús xa man apon tüj quiq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Y jari' tok xbetiquer-pe jun nimalüj cakik' pari' ri ya', jun cakik' ri juis ruchuk'a'. Y romari' ri ya' juis c'a nsilon. ");
INSERT INTO cakENT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Y tok ye biyinük chic c'a jun vo'o' o vaki' (seis) kilómetros pari' ri ya', ri rachibila' xquitz'et chanin que ja ri Jesús ri petenük chirakün pari' ya' y nyeruk'i' yan c'a. Y rije' juis c'a xquixbij-qui'. ");
INSERT INTO cakENT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero ri Jesús xbij c'a cheque: Man tixbij-ivi'. Ja yin ri Jesús, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ri rachibila' xcac'axaj c'a que ja na vi rija' ri Jesús, c'ateri' xquiya-ka cánima y riq'uin quicot xquic'ul-apu ri Jesús chupan ri canoa. Y jari' tok xe'apon chuchi' ri ya', ri lugar ri nc'atzinej nye'apon-vi. ");
INSERT INTO cakENT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pa ruca'n k'ij, ri vinük ri c'a xec'uje' na can lojc'an ruchi-ya' ri jun xkak'ij can, c'a quimolon c'a qui'. Rije' quetaman c'a que xaxe ri rachibila' ri Jesús ri xetzolin chupan ri jun oc canoa ri c'o chiri'. Y ri Jesús xa xc'uje' can. ");
INSERT INTO cakENT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ri k'ij c'a ri', yec'o c'a canoas ri ye petenük pa tinamit Tiberias y xe'apon chunakaj ri ape' xquic'ux-vi quivay ri vinük ri jun k'ij can, ri vüy ri xuya' ri Ajaf Jesús cheque, tok rumatioxin chic chin ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Y ri vinük ri', roma xquitz'et que ri Jesús xa man c'o tüj chic chiri' y ri rachibila' xa xetzolij yan, rije' chuka' xe'oc-e pa tak canoas y xebe pa Capernaum chucanoxic ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tok ri vinük re' xbequila' ri Jesús lojc'an ruchi-ya', xquibij c'a chin: ¿Jampe' xatobos chere'? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Pero ri Jesús xbij c'a cheque ri vinük ri': Ketzij ninbij chive, que rix nquinicanoj xaxe roma xivil ivay viq'uin y jabel xinojsala' ipan, y man roma tüj que xe'itz'et ri milagros ri nyek'alajrisan que yin ja vi ri Dios ri takayon-pe vichin. ");
INSERT INTO cakENT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Quixsamüj c'a, pero man richin tüj que nich'üc ri vüy ri xa nq'uis. Xa quixsamüj richin nich'üc ri vüy ri chi jumul c'o y nuya' ic'aslen ri man nq'uis tüj. Vüy ri ninya' chive yin ri xinalüx chi'icojol, roma ja yin xinrutük-pe ri Nata' Dios, richin ninbün ri samaj re', xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Y ri vinük ri' xquibij c'a chin ri Jesús: ¿Achique c'a ri nka' chuvüch ri Dios que nkabün ta? ");
INSERT INTO cakENT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Y ri Jesús xbij c'a cheque: Ri nka' chuvüch ri Dios que rix nibün ta, ja ri quinitakej yin ri xintak-pe roma rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Y ri vinük xquibij chin ri Jesús: ¿Achique c'a ri ncatiquer nabün? Tabana' c'a jun milagro, richin quiri' nkatz'et y ncatkanimaj. ");
INSERT INTO cakENT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Roma ri ojer tak kaxquin-kamama' can, tok xec'o chupan ri tz'iran ruch'ulef, ja ri vüy xubini'aj maná ri xuya' ri Moisés cheque richin xquic'ux. Cachi'el vi c'a ri nbij ri rutzij ri Dios ri tz'iban can. Chiri' nbij: Vüy c'a ri petenük chila' chicaj ri xuya' cheque richin xquic'ux. Y rat ¿ncatiquer comi nabün cachi'el xbün ri Moisés? ");
INSERT INTO cakENT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Y ri Jesús xbij c'a cheque: Tivac'axaj c'a jabel ri ninbij chive: Ri vüy ri xpu'u chila' chicaj, man ja tüj c'a ri Moisés ri xyo'on. Jac'a ri Nata' Dios ri nyo'on chive ri ketzij Vüy richin chila' chicaj. ");
INSERT INTO cakENT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Roma ri Vüy ri richin ri Dios, ja ri Jun ri petenük chila' chicaj. Y jari' ri c'amayon-pe c'aslen cheque ri vinük, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tok xcac'axaj quiri' ri vinük, xquibij c'a chin ri Jesús: Chi jumul c'a taya' ri Vüy re' cheke, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Y ri Jesús xbij c'a cheque: Ja yin ri Vüy ri nquiyo'on c'aslen. Ri nuya' ránima viq'uin, man chic c'a nnum tüj ri ránima, roma ja yin ri nquinoc Ruvay ri nc'usan-e ruvayjül. Y chuka' ri nuya' ránima viq'uin, man nchaki'j tüj chic ruchi' ri ránima, roma ja yin ri nquinoc Ruya' ri nc'usan-e ri chakal ruchi' ");
INSERT INTO cakENT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero cachi'el c'a ri nubin chive, que stape' (aunque) rix xitz'et y xivac'axaj ri samaj xinbün yin iviq'uin, man c'a nquinitakej tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Conojel c'a ri nyepu'u chinucanoxic, nyenc'ul, y man jun bey nyenvetzelaj tüj e. Roma jare' ri ye rucha'on chic ri Nata'. ");
INSERT INTO cakENT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Roma yin ri xinka-pe chila' chicaj man nusamaj tüj c'a yin ri nuc'amon-pe, man quiri' tüj. Yin xinka-pe chila' chicaj chubanic ri samaj ri rurayibül vi ri takayon-pe vichin. ");
INSERT INTO cakENT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Y ri samaj c'a ri ruchilaben-pe ri Nata' Dios ri takayon-pe vichin, jac'a que conojel ri ye rucha'on rija', ri nyecanon vichin yin, man ta c'a nyesatz can, y pa ruq'uisbül k'ij nyenc'asoj ta e chiquicojol ri caminaki'. ");
INSERT INTO cakENT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ri samaj chuka' ri chilaben-pe chuve roma ri Nata', ri takayon-pe vichin, ja que conojel ri nyetz'eton ri nusamaj y nquiya' chuka' cánima viq'uin, tic'uje' c'a quic'aslen ri man nq'uis tüj, y nyenc'asoj-e chiquicojol ri caminaki' pa ruq'uisbül k'ij, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ja ri vinük israelitas ri' nyexebexot chirij ri Jesús, roma rija' xbij: Ja yin ri Vüy ri kajnük-pe chila' chicaj. ");
INSERT INTO cakENT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Y nyequixebexa' c'a: ¿Man ja tüj c'a re' ri Jesús ri ruc'ajol ri José? Xa ketaman c'a quivüch ri rute-rutata'. Porque c'a cheke roj nbij-pe que rija' kajnük-pe chila' chicaj riq'uin ri Dios, nquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pero ri Jesús xbij c'a cheque: Man quixxebexot-pe chuvij yin. ");
INSERT INTO cakENT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Roma ri nyetaken vichin, xa ja ri samajnük chic ri Nata' Dios pa tak cánima, ri Nata' Dios ri takayon-pe vichin. Y yin ninbün c'a cheque ri nyetaken vichin que nyec'astüj-e chiquicojol ri caminaki' pa ruq'uisbül k'ij. ");
INSERT INTO cakENT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Y tz'iban c'a chuka' coma ri achi'a' ri xek'alajrisan ri rutzij ri Dios ojer can, que conojel c'o c'a ri nc'ut chiquivüch roma ri Dios, quiri' ri nbij. Y ri achique c'a ri nrac'axaj ri rutzij ri Nata' Dios y nretamaj, npu'u c'a chinucanoxic. ");
INSERT INTO cakENT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pero yin man ninbij tüj c'a que c'o ta jun vinük ri tz'eteyon richin ri Dios, man quiri' tüj. Xaxe yin ri yin petenük chila' chicaj riq'uin rija' ri yin tz'eteyon ruvüch ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tivac'axaj na pe' jabel ri ninbij chive: Ri ntaken c'a vichin, c'o na vi ruc'aslen ri man nq'uis tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ri Vüy ri nyo'on na vi c'aslen, ja yin. ");
INSERT INTO cakENT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Roma ri vüy ri xubini'aj maná, ri xc'ux coma ri ojer tak ixquin-imama' can ri xec'o pa tz'iran ruch'ulef, man xtiquer tüj xbün cheque que xc'uje' ta quic'aslen richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jac'a ri ketzij Vüy ri kajnük-pe chila' chicaj nbün cheque ri nyec'uxun richin que man nye'apon tüj chupan ri camic richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ja yin c'a ri Vüy ri c'o ruc'aslen, ri xka-pe chila' chicaj. Ri nquic'ux c'a ri Vüy re', nyec'ase' richin chi jumul. Ri Vüy c'a ri ninya' yin cheque ja ri nuch'acul. Napon-vi c'a pa camic richin que nuc'ün-pe c'aslen cheque ri vinük ri yec'o chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Y ri vinük israelitas re', tok xcac'axaj ri xbij ri Jesús, xquic'utula' c'a chiquivüch ka rije': ¿Achique c'a rubanic ri' que rija' nuya' ri ruch'acul cheke richin nkac'ux? nquibij c'a. Xa xejalajo' c'a roma man junan tüj quinojibül. ");
INSERT INTO cakENT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Y ri Jesús xbij c'a cheque: Ketzij vi, que si xa man nic'ux tüj ri nuch'acul y man nitij tüj chuka' ri nuquiq'uel yin ri xinalüx chi'icojol, ri c'aslen richin chi jumul can man ntoc tüj ivichin. ");
INSERT INTO cakENT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ri nquic'ux c'a ri nuch'acul yin y nquitij chuka' ri nuquiq'uel, c'o-vi c'a ri quic'aslen richin chi jumul. Y yin ninbün c'a cheque que nyec'astüj-e chiquicojol ri caminaki', pa ruq'uisbül k'ij. ");
INSERT INTO cakENT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Roma ri nuch'acul yin jari' ri ketzij Vüy y ri nuquiq'uel jari' ri ketzij Ya', ri nquic'ün-pe c'aslen. ");
INSERT INTO cakENT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ri nquic'ux c'a ri nuch'acul yin y nquitij chuka' ri nuquiq'uel, xa jun c'a ri nkabün quiq'uin. Rije' nyec'uje' viq'uin yin y yin quiq'uin rije'. ");
INSERT INTO cakENT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Roma ja ri Nata' ri takayon-pe vichin y rija' c'o-vi ri c'aslen riq'uin, yin chuka' c'o ri c'aslen ri' viq'uin. Y quiri' c'a chuka' ri yinquic'ul yin, nyec'ase-vi voma yin. ");
INSERT INTO cakENT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ri ketzij Vüy c'a, ri kajnük-pe chila' chicaj, ri Vüy ri' man junan tüj riq'uin ri vüy ri rubini'an maná ri xquic'ux ri ojer tak ixquin-imama' can, roma ri vüy ri xquic'ux rije' man xtiquer tüj xbün cheque que xc'uje' ta quic'aslen richin chi jumul. Jac'a ri nquic'ux ri ketzij Vüy ri kajnük-pe chila' chicaj nc'uje' quic'aslen ri richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jare' ri xbij ri Jesús cheque ri vinük israelitas ri quimolon-qui' chupan ri jay ape' ntzijos-vi ri rutzij ri Dios, chiri' pa tinamit Capernaum. ");
INSERT INTO cakENT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Entonces tok ri nyetzekleben richin ri Jesús cac'axan chic ka ri xbij, ye q'uiy c'a cheque rije' ri xquibij: Juis c'ayuf ri xbij. Man k'alüj tüj si yec'o ri nyetaken. ");
INSERT INTO cakENT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Entonces tok ri Jesús xutz'et ri nquinuc pa tak cánima ye q'uiy cheque ri nyetzekleben richin, rija' xbij c'a cheque: ¿Achique roma tok rix ninuc que c'ayuf richin xtinimüx ri xinbij? ");
INSERT INTO cakENT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Si ta nquinitz'et yin ri xinalüx chi'icojol que nquitzolij chila' riq'uin ri Dios ri ape' yin petenük-vi, ¿man ta comi nquinitakej? ");
INSERT INTO cakENT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ri ruc'aslen ri ich'acul, ja ri ru-espíritu ri nyo'on. Ri ich'acul xa man jun rakalen. Y ri Espíritu ri nyo'on ri ketzij ic'aslen, ja ri tzij ri ye nubin chic ka chive ri nyo'on. ");
INSERT INTO cakENT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero ye q'uiy na c'a chive rix ri man nurayij tüj cánima yinquitakej, xbij ri Jesús. Roma rija' pa nabey c'a retaman chic pe achique vinük ri man nyetaken tüj, y ri achique nc'ayin-e richin. ");
INSERT INTO cakENT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Y ri Jesús xbij c'a: Roma yec'o c'a chive rix ri man nurayij tüj cánima yinquitakej, romari' tok yin nubin c'a chive que ja ri vinük ri ye cha'on roma ri Nata' Dios, jari' ri nyepu'u c'a viq'uin yin chinucanoxic, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Roma c'a ri xbij ri Jesús, juis c'a ye q'uiy cheque ri nyetzekleben richin, man xquitzeklebej tüj chic. Xa xetzolij c'a can. ");
INSERT INTO cakENT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Y ri Jesús xbij c'a cheque ri doce rachibila': ¿Rix chuka' nijo' nyixbe can? ");
INSERT INTO cakENT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Y ri Simón Pedro xbij c'a chin ri Jesús: Ajaf, man jun chic cachi'el rat, richin nkatzeklebej tüj, roma ri atzij rat nuya' c'aslen ri man nq'uis tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Roj kayo'on kánima aviq'uin y ketaman que ja rat ri Cristo, ri Ruc'ajol ri c'aslic Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Y ri Jesús xbij c'a: Stape' (Aunque) ja yin ri xincha'on ivichin rix doce, c'o c'a jun ri itzel-vinük xc'ulun chi'icojol, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tok ri Jesús xuya' retal c'a ri jun ri itzel-vinük xel, pari' c'a ri Judas Iscariote xch'o-vi, ri Judas ri ruc'ajol ri jun achi rubini'an Simón. Ri Jesús xuya' retal c'a ri jun ri', roma jari' ri nc'ayin-e richin ri Jesús. Y rija' jun c'a cheque ri doce rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Y c'ateri' ri Jesús xutz'om xbiyin pa tak tinamit ri yec'o pa ruch'ulef Galilea. Man c'a rujo'on tüj chic benük tzijoy rutzij ri Dios c'a pa Judea, roma ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, nquicanola' c'a achique rubanic nquibün richin nquicamsaj. ");
INSERT INTO cakENT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ri k'ij c'a ri', xa nakaj chic c'a c'o-vi ri jun cheque ri quinimak'ij ri israelitas, nimak'ij richin nquiya' retal ri tiempo ri xquic'usaj ri quixquin-quimama' can chupan ri tz'iran ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Y ri ye ruchak' c'a ri Jesús xquibij chin rija': Taya' c'a can ba' ri ruch'ulef Galilea y cabiyin pa ruch'ulef Judea, richin quiri' ri vinük ri nyetzekleben avichin ri yec'o chila', tiquitz'eta' c'a ri asamaj. Tiquitz'eta' c'a ri milagros ri nye'abanala'. ");
INSERT INTO cakENT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Roma achique c'a ri nrajo' nuk'alajrisaj-ri' chiquivüch ri vinük, man c'uluman tüj c'a que nrevaj-ri'. Nc'atzin que nuc'ut-ri' que c'o-vi ri ntiquer nbün, xquibij ri ye ruchak' chin. ");
INSERT INTO cakENT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Stape' (Aunque) rije' quichak' ri Jesús, man c'a nquitakej tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Y c'ateri' ri Jesús xbij c'a cheque ri ye ruchak': Rix achique na c'a k'ij utz nyixapon chupan ri nimak'ij. Jac'a yin man quiri' tüj. Yin man jani c'a utz tüj richin que nquinapon. ");
INSERT INTO cakENT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Rix xa man c'a nyixetzelüs tüj coma ri vinük ri c'a quiyo'on na cánima riq'uin ri ruch'ulef. Jac'a yin yinquetzelaj-vi. Yinquetzelaj roma yin nink'alajrisaj ri itzel ri nyequibanala'. ");
INSERT INTO cakENT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Quixbiyin c'a e iyon rix. Yin xa c'a man jani nquibe-e chupan ri nimak'ij re'. Ri hora richin que nink'alajrisaj-vi', c'a man jani c'a tapon, xbij ri Jesús cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Y tok ri Jesús rubin chic c'a ronojel re' cheque ri ye ruchak', rija' xc'uje' na vi can chiri' pa Galilea. ");
INSERT INTO cakENT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Y tok ye benük chic ri ye ruchak' chupan ri jun nimak'ij ri', c'ateri' c'a xbe rija'. Cachi'el xa pan evatül c'a ri xbe, roma man xtz'etetüj tüj e. ");
INSERT INTO cakENT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ja pa nimak'ij ri', ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, y nquetzelaj ri Jesús, nyexule-nyejote' chucanoxic y nquic'utula' c'a: ¿Man itz'eton tüj ri jun achi ri'? nquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Y chiquicojol ri vinük chupan ri nimak'ij ri', q'uiy c'a ri nbitüj chirij ri Jesús. Yec'o ch'aka nquibij que ri nuk'alajrisaj ri Jesús, utz. Yec'o ch'aka man quiri' tüj chiquivüch, xa nquibila' c'a que ri Jesús xa nyeruch'üc ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero man jun c'a cheque ri vinük ri nyebin quiri' nuk'alajrisaj ta ri', roma nquixbij c'a qui' chiquivüch ri achi'a' ri c'o quik'ij chiquicojol ri israelitas. ");
INSERT INTO cakENT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Y ja tok ya xnic'ajür ri nimak'ij ri', jari' tok ri Jesús xapon pa racho ri Dios ri c'o chiri' pa tinamit Jerusalén, ri ape' ntajin-vi ri nimak'ij ri'. Y rija' nutzijoj c'a ri rutzij ri Dios chiquivüch ri vinük ri quimolon-qui' chiri'. ");
INSERT INTO cakENT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ri achi'a' c'a ri c'o quik'ij chiquicojol ri israelitas, nquibij c'a chirij ri Jesús: ¿Achique c'a roma que ri achi re' juis etamabül ruchajin pari' ri rutzij ri Dios y xa man jun bey xkatz'et que ntajin ta nretemaj? nquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pero ri Jesús xbij: Ri tijonic ri ninya', ja ri takayon-pe vichin ri chilabeyon-pe chuve. Re' man vichin tüj c'a yin. ");
INSERT INTO cakENT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Y ri vinük ri c'o rayibül riq'uin richin nbün ri nrajo' ri Dios, ri vinük ri' nretamaj c'a, si ri tijonic ri ninya' yin riq'uin ri Dios petenük-vi o xa nuyon nutz'ucun-e. ");
INSERT INTO cakENT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Achique c'a vinük ri ruyon rija' nuk'alajrisaj-ri', nrajo' c'a que ri vinük nquiya' ta ruk'ij. Jac'a yin ninjo' que rix niya' ta ruk'ij ri Dios ri takayon-pe vichin. Y romari' nk'alajin que yin ja ri ketzij ninbün y man jun bey ninbün tüj ri man utz tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Rix nicanoj c'a achique rubanic nibün richin nquinicamsaj. Xa man nibün tüj c'a ri achique nbij ri ley ri xuya' ri Dios richin ri Moisés, y ri ley re' xa pan ik'a' c'o-vi, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Y ri vinük xquibij c'a: Xa xch'ujir la'. ¿Achique c'a ri njo'on ncamsan avichin? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pero ri Jesús xbij c'a cheque: Rix xe' xica'yej tok xitz'et que yin pa jun k'ij richin uxlanen xinc'achojrisaj ri jun achi. ");
INSERT INTO cakENT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Y ri Moisés tok xuya' ri ley ri xuya' ri Dios richin rija' xbij c'a que tiban ri circuncisión cheque ri alabo'. Pero xa man ja tüj c'a rija' ri tz'ucuyun-pe, xa ja ri ojer tak kaxquin-kamama' can ri xetz'ucun-pe. Y romari' rix, tok napon ri ocho k'ij talüx jun ac'ual vit ala', stape' (aunque) pa jun k'ij richin uxlanen, nibün-vi c'a ri circuncisión chin, ri retal que ja richin ri tinamit ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Rix nibij que man nijo' tüj nik'üj ri nbij chupan ri ley ri xuya' ri Dios richin ri Moisés, y stape' (aunque) pa jun k'ij richin uxlanen rix nibün-vi ri circuncisión. ¿Y achique roma tok xpu'u ivoyoval chuve yin roma xinc'achojrisaj jun achi chupan jun k'ij richin uxlanen? ");
INSERT INTO cakENT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Man tibij c'a que man utz tüj ri nquibanun, xaxe roma quiri' nk'alajin chivüch rix. Xa tivetamaj na c'a jabel, si quiri' o man quiri' tüj, richin quiri' man quixsatz, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Y yec'o c'a cheque ri vinük aj chiri' pa tinamit Jerusalén ri nquibila' c'a: ¿Man ja tüj comi c'a ri Jesús ri ncanox richin ncamsüs? ");
INSERT INTO cakENT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pero rija' xa man revan tüj ri'. Titz'eta' c'a la', rija' nch'o chiquivüch la vinük y man jun nbin tüj chin que man tubün chic cala'. Riq'uin juba' ri achi'a' ri c'o-vi quik'ij ri yec'o chikacojol xa xquitz'et yan que ja vi rija' ri Cristo. ");
INSERT INTO cakENT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero nk'alajin c'a que xa man ja tüj rija' ri Cristo, roma xa ketaman c'a ape' petenük-vi. Y tok nka-pe ri ketzij Cristo, xa man c'a nk'alajin tüj ape' npu'u-vi, nquibij ri vinük aj-Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Y ri Jesús nch'o c'a chiquivüch ri vinük ri chiri' pa racho ri Dios. Y riq'uin c'a ruchuk'a' xch'o y xbij: Rix ivetaman-vi nuvüch y ivetaman chuka' ape' nquipu'u-vi. Jac'a ri takayon-pe vichin man c'a ivetaman tüj ruvüch, y rija' ketzij. Man c'a nuyon tüj yin xinbün que xinpu'u chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yin vetaman-vi c'a ruvüch ri man ivetaman tüj ruvüch rix, roma riq'uin rija' yin petenük-vi, y ja chuka' rija' ri takayon-pe vichin, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Y yec'o c'a ri xejo'on que xquitz'om tüj, pero man xquitz'om tüj e roma ri hora richin ri Jesús man jani c'a tapon. ");
INSERT INTO cakENT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ye juis c'a ye q'uiy cheque ri vinük ri xetaken richin ri Jesús chupan ri k'ij ri'. Ri vinük c'a ri' nquibij que ja rija' ri Cristo, roma ri milagros man jun chic c'a nbanun. Xaxe c'a si ja ri Cristo, ntiquer nbün, xquibij rije'. ");
INSERT INTO cakENT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Y ri achi'a' fariseos xcac'axaj c'a que quiri' ri nyequibila' ri vinük pari' ri Jesús. Romari' ri achi'a' fariseos y ri más nimalüj tak sacerdotes, xequitük c'a e ri achi'a' ri ye chajinela' richin ri racho ri Dios richin nquitz'om rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jari' tok xbij ri Jesús: C'o na ba' tiempo ri nquic'uje' iviq'uin. C'ateri' nquitzolij riq'uin ri achique takayon-pe vichin. ");
INSERT INTO cakENT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Rix nquinicanoj c'a, y man nquinivil tüj chic, roma ri lugar ape' nquibec'uje-vi yin, man nyixtiquer tüj nyixapon chinucanoxic, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Y ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, nquibila' c'a chiquivüch: ¿Ape' comi c'a nbe-vi ri Jesús re'? Roma nbij que chiri' man nkila' tüj chic pe. ¿Nbe comi c'a pa ch'aka chic ruch'ulef richin nyerutzijoj ri rutzij cheque ri kavinak israelitas y cheque ri man ye israelitas tüj? ");
INSERT INTO cakENT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Man c'a ketaman tüj ape' nbe-vi, roma man ketaman tüj achique ntel-vi chi tzij tok xbij: Nquinicanoj y man nquinivil tüj. Ri lugar ape' nquibec'uje-vi yin, man nyixtiquer tüj nyixapon rix, nquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chupan c'a ri nimalüj k'ij y ruq'uisbül richin ri jun semana nimak'ij ri', ri Jesús pa'ül tok riq'uin c'a ruchuk'a' xbij: Si c'o c'a jun ri nchaki'j ruchi' ri ránima, tipu'u c'a viq'uin yin, richin nc'o-e chakal ruchi' ránima riq'uin ri Ya' ri ninya-e chin yin. ");
INSERT INTO cakENT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ri npu'u c'a viq'uin yin richin nquirutakej, nc'uje' c'a ri Ya' richin c'aslen pa ránima, y ri Ya' ri' cachi'el c'a ri nbün ri ya' pa ralaxbül, quiri' nbün pa ruc'aslen. Quiri' ri nbij chupan ri rutzij ri Dios ri tz'iban can. ");
INSERT INTO cakENT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ri Ya' c'a ri xuya' retal ri Jesús, ja ri Lok'olüj Espíritu, roma jari' ri nquic'ul ri vinük ri nyetaken richin ri Jesús. Y ri k'ij c'a ri' c'a man jani tüj tika-pe ri Lok'olüj Espíritu, roma c'a man jani tüj chuka' titzolij-e ri Jesús chila' chicaj richin que nk'alajin que rija' c'o-vi ruk'ij. ");
INSERT INTO cakENT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Y yec'o c'a cheque ri vinük, tok xcac'axaj-ka ri tzij ri xerubij ri Jesús, xquibij c'a: Ketzij vi que ri Jesús jare' ri rusamajel ri Dios ri nk'alajrisan ri rutzij, ri q'uiy yan tiempo oyoben-pe. ");
INSERT INTO cakENT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Y yec'o chuka' la' nquibij: Ja ri Jesús jari' ri Cristo, ri Jun cha'on-pe y takon-pe roma ri Dios. Pero yec'o chic c'a ch'aka ri nquibij: Ri Cristo man pa Galilea tüj npu'u-vi. ");
INSERT INTO cakENT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Roma ri rutzij ri Dios ri tz'iban can nbij que ri Cristo ruxquin-rumam can ri rey David. Y chiri' pa Belén ri tinamit ape' xalüx-vi ri David, chiri' nc'atzinej npu'u-vi, nquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Man junan tüj c'a ri quinojibül pari' ri Cristo, roma xa jun vi nbij la jun y jun vi chic nbij la jun. ");
INSERT INTO cakENT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Y yec'o c'a ch'aka chic cheque ri vinük, xcajo' c'a que xquitz'om ta e ri Jesús, pero xa man xquibün tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ja tok ri chajinela' richin ri racho ri Dios, ri ye takon-e coma ri más nimalüj tak sacerdotes y coma ri achi'a' fariseos, xetzolij, xbix c'a cheque: ¿Achique c'a roma tok man xitz'om tüj pe ri Jesús? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pero ri chajinela' ri' xquibij: Roj man c'a xkatz'om tüj pe, roma ri tzij ri nyerubij man jun chic c'a achi ri biyon tüj. Galán c'a jabel, xquibij rije'. ");
INSERT INTO cakENT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","C'ateri' ri achi'a' fariseos xquibij c'a cheque ri chajinela': ¿Rix chuka' xixch'acatüj-pe? ");
INSERT INTO cakENT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Nitz'et ta comi c'a rix que yec'o ta cheque ri achi'a' pa comon nyebanun juzgar y ri fariseos que quiniman ta ri nbij ri Jesús? ");
INSERT INTO cakENT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Xa ja ri vinük ri man jun quetaman chin ri ley ri xuya' ri Dios richin ri Moisés, xa jari' ri nyetaken richin. Ja ta nka-pe castigo pa quivi' ri vinük re'. ");
INSERT INTO cakENT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pero ri Nicodemo ri achi ri xa chak'a' xapon riq'uin ri Jesús, xbij c'a cheque ri ye rachibil: ");
INSERT INTO cakENT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","¿Utz ta comi chuvüch ri ka-ley que nbix que jun achi c'o rumac, y xa man etaman tüj, ni man ac'axan tüj chuka' chin si ketzij que c'o mac rubanun o xa man jun? ");
INSERT INTO cakENT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Y rije' xquibij c'a chin ri Nicodemo: Rat ni man rat aj-Galilea tüj, richin quiri' nato' ri Jesús. Tanic'oj na pe' jabel ri rutzij ri Dios tz'iban can. Chiri', nk'alajin-vi c'a que pa ruch'ulef Galilea man nc'ulun tüj c'a pe jun achi k'alajrisüy richin ri nbix chin roma ri Dios, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Y c'ateri' ri achi'a' ri quimolon-qui', xquitaluj-e-qui' y xebe chi tak cacho. ");
INSERT INTO cakENT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ri Jesús xbe c'a e pari' ri juyu' rubini'an Olivos. ");
INSERT INTO cakENT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Y xsaker yan, rija' xapon chic pa racho ri Dios. Ri vinük xe'apon c'a riq'uin. Y tz'uyul tok nutzijoj rutzij ri Dios cheque ri vinük ri quimolon-apu-qui' chiri'. ");
INSERT INTO cakENT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Y ri achi'a' fariseos y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés xe'apon c'a riq'uin ri Jesús, quic'uan-apu jun ixok ri nmacun riq'uin jun achi ri xbe'ilitüj-pe. Xbequipaba' chuvüch ri Jesús, pa quinic'ajal. ");
INSERT INTO cakENT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ri fariseos y ri etamanela' chin ri ley ri xuya' ri Dios richin ri Moisés ri' xquibij c'a chin ri Jesús: Maestro, xquibij rije'. Ri jun ixok ri kapaban chavüch, nmacun riq'uin jun achi ri xilitüj-pe. ");
INSERT INTO cakENT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Chupan ri ley ri xuya' ri Dios richin ri Moisés nbij que ri nyebanun quere', quecamsüs chi abüj. ¿Achique c'a nabij rat? ¿Utz o man utz tüj nkacamsaj chi abüj ri jun ixok re'? xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ri achi'a' ri' quiri' xquibij xaxe richin nquitij ri Jesús, richin quiri' nyetiquer nyesujun chirij. Pero ri Jesús xa xluque-ka, y c'o c'a xerutz'ibaj-ka pan ulef riq'uin ri ruvi-ruk'a'. ");
INSERT INTO cakENT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Y roma c'a ri achi'a' ri' juis c'a nquic'utula-apu chin ri Jesús, si ncamsüs o man ncamsüs tüj ri ixok re', rija' xbepa'e' c'a pe y xbij: Ri man jun bey c'a kajnük pa jun mac, tutz'ama' c'a ruc'akic ri ixok, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Y ri Jesús xluque' c'a ka jun bey chic y xutz'om chic c'a tz'ibanic jun bey, riq'uin ri ruvi-ruk'a', chiri' pan ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tok ri sujunela' chirij ri ixok xcac'axaj c'a ri xbij ri Jesús, ri cánima xbij cheque que rije' chuka' ye aj-maqui', y xquitalüj c'a e qui'. Xenabeyüj-e ri rajatük, y c'ateri' xebe ri más c'a ye ac'uala'. Xaxe chic c'a ri ixok ri xc'uje' can, roma ri ye sujunela' chirij xa xebe yan. Ri ixok pa'ül c'a chiri' ape' xbequipaba-vi chuvüch ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Y tok ri Jesús xbepa'e' chic pe, xutz'et c'a que xaxe chic ri ixok ri pa'ül can chiri'. Romari' xuc'utuj c'a chin ri ixok ri': ¿Y ri vinük ri ye c'amayon-pe avichin? ¿Man jun xc'uje-ka richin ncarucamsaj? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Y ri ixok ri' xbij: Ajaf, man jun chic xcanaj can, xbij. Y ri Jesús xbij c'a chin: Yin chuka' man ninbij tüj que ncacamsüs. Vocomi c'a catzolij y man camacun tüj chic. ");
INSERT INTO cakENT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tok ri Jesús xch'o chic c'a jun bey chiquivüch ri vinük, xbij c'a: Ja yin ri nquisakrisan quic'aslen ri vinük ri yec'o chuvüch ri ruch'ulef. Ri ntzekleben c'a vichin, ninsakrisaj c'a y nril ruc'aslen viq'uin. Y rija' man nbiyin tüj chic c'a pa k'eku'n. ");
INSERT INTO cakENT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","C'ateri' ri achi'a' fariseos ri yec'o c'a chiri', xquibij-apu chin ri Jesús: Roj man nkanimaj tüj que ketzij ri nabij chavij, roma xa ja rat ri ncabin. ");
INSERT INTO cakENT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pero ri Jesús xbij c'a cheque ri achi'a' fariseos: Stape' (Aunque) xa ja yin ri nquik'alajrisan-ka vichin, ketzij vi c'a ri nink'alajrisaj-ka pa nuvi'. Roma chinuvüch yin k'alüj ri ape' yin petenük-vi, y chiri' c'a chuka' nquitzolin-vi. Jac'a rix man ivetaman tüj ape' nquipu'u-vi, ni man ivetaman tüj c'a chuka' ape' nquibe-vi. ");
INSERT INTO cakENT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Rix iyon c'a nibanala-ka i-leyes. Jac'a yin man quiri' tüj ninbün. ");
INSERT INTO cakENT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Y si yin ninbün jun juicio, pa ruchojmil c'a ntel-vi, roma man nuyon tüj yin, xa vachibilan-vi c'a ri Nata' ri takayon-pe vichin. ");
INSERT INTO cakENT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chupan ri ley ri ivichin ibanun-ka chin, nbij c'a que tok yec'o ye ca'i' ri junan ri nquibij, nk'alajin c'a que ketzij ri nquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Y yin y ri Nata' ri takayon-pe vichin, junan ri nkabij, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ri achi'a' fariseos xquibij c'a chin ri Jesús: ¿Ape' c'a c'o-vi ri Atata'? xquibij chin. Y ri Jesús xbij c'a: Rix man ivetaman tüj ruvüch ri Nata', roma man ivetaman tüj nuvüch yin. Si ta ivetaman nuvüch yin, ivetaman ta chuka' ruvüch ri Nata'. ");
INSERT INTO cakENT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Y ja tzij re' ri xerubij ri Jesús cheque ri vinük ri quimolon-qui' ape' nyeyalox-vi can tumin coma ri vinük chiri' pa racho ri Dios. Y man riq'uin tüj xerubila' tzij quiri', man jun ri xpu'u tüj chutz'amic, roma ri ru-hora man jani c'a tapon. ");
INSERT INTO cakENT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Y jun bey chic, ri Jesús xbij c'a cheque: Yin nquitzolij-vi c'a, y tok rix c'ateri' nquinicanoj, man c'a nquinivil tüj. Xa chupan c'a ri imac nyixcom-vi. Y ri ape' nquibe-vi yin, rix man nyixtiquer tüj nyixapon, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Y jari' tok ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, nquibila' c'a chiquivüch: ¿Nucamsaj comi c'a ri' ri Jesús? Roma nbij: Ri ape' nquibe-vi yin, rix man c'a nyixtiquer tüj nyixapon, nbij, nquibij ri achi'a' ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pero ri Jesús xbij c'a cheque: Rix rix aj chere' ka y yin yin aj chila' chicaj. Rix richin vi ri ruch'ulef y yin man quiri' tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Y romari' xinbij c'a chive que chupan ri imac nyixcom-vi. Y si xa man ninimaj tüj ri achique c'a yin, nyixcom na vi chupan ri imac, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","C'ateri' ri achi'a' ri' xquibij chic c'a chin ri Jesús: ¿Rat achique c'a rat? Y ri Jesús xbij cheque: Yin, jac'a tok nutzamon-pe tzij iviq'uin, jari' tok nubin-pe chive ri achique yin. ");
INSERT INTO cakENT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Q'uiy c'a ri nc'atzinej que ninbij chive, roma ri itzel ri nyixbanun. Pero ri ninbij c'a chive rix y cheque conojel vinük, xaxe c'a ri vac'axan-pe riq'uin ri takayon-pe vichin, y rija' ketzij vi, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero rije' man xk'ax ta cheque ri xbix cheque roma ri Jesús, romari' man xquetamaj tüj que pari' ri Tata'ixel nch'o-vi rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ri Jesús xbij chic c'a: Ri k'ij c'a tok nquinijotoba' chuvüch ri cruz yin ri xinalüx chi'icojol, c'a jari' tok nivetamaj ri achique c'a yin. Y nivetamaj chuka' que ronojel ri ninbün yin, xa man nuyon tüj yin. Xa cachi'el ri rubin-pe ri Nata' chuve yin, quiri' c'a chuka' ninbij yin chive. ");
INSERT INTO cakENT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ri Nata' ri takayon-pe vichin, c'o viq'uin. Man c'a nquiruya' tüj can nuyon, roma yin ninbün-vi ri nka' chuvüch, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Y roma c'a ri tzij ri xerutzijola' ri Jesús chiquivüch ri vinük, ye q'uiy c'a ri xetaken richin. ");
INSERT INTO cakENT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","C'ateri' ri Jesús xbij c'a cheque ri achi'a' ri c'o quik'ij chiquicojol ri israelitas ri xetaken richin: Si rix jabel ruc'uaxic nibün chin ri nutzij, nyixoc c'a ketzij tak tzeklebey vichin. ");
INSERT INTO cakENT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nivetamaj c'a chuka' achique ri ketzij, y ri ketzij nbün c'a chive que nyixel libre. ");
INSERT INTO cakENT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Y ri vinük ri' xquibij c'a: Roj roj ruxquin-rumam can ri Abraham, y romari' man xojc'uje' tüj chuxe' quitzij ch'aka chic, cachi'el ta roj lok'on tak ajic'a'. ¿Achique c'a roma tok nabij cheke que nkucolotüj-e? ");
INSERT INTO cakENT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Pero ri Jesús xbij cheque: Tivac'axaj na pe' jabel ri ninbij chive vocomi: Conojel c'a vinük ri nyemacun, nk'alajin que chuxe' rutzij ri mac yec'o-vi y jari' ri uc'uayon quichin. ");
INSERT INTO cakENT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Y si jun vinük chuxe' rutzij ri mac c'o-vi, man nc'uje' tüj riq'uin ri Dios. Jac'a ri jun ri ralc'ual vi ri Dios, nc'uje-vi riq'uin richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Romari' si yin ri Ruc'ajol ri Dios nquicolon ivichin, ketzij vi que colonic ri nivil. ");
INSERT INTO cakENT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Y chinuvüch yin, ri nibij rix que rix ruxquin-rumam can ri Abraham, quiri' vi, xa jac'a ri nyixbanun man nuc'ut tüj que quiri', roma rix xa nicanola' achique c'a modo nibün richin nquinicamsaj. Re' nuc'ut c'a que rix man iyo'on tüj k'ij chin ri nutzij que c'unük ta pa tak ivánima. ");
INSERT INTO cakENT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ronojel c'a ri nintzijoj yin, jac'a ri Nata' c'utuyun-pe chinuvüch. Y quiri' c'a chuka' rix. Xaxe chic c'a rix riq'uin ri jun ri c'unük itata', riq'uin rija' nivac'axaj ronojel ri nyixtajin chubanic. ");
INSERT INTO cakENT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Y rije' xquibij c'a chin ri Jesús: Ri Abraham jari' ri kaxquin-kamama' can roj, xquibij. Y ri Jesús xbij cheque: Si ta rix ruxquin-rumam can ri Abraham, nk'alajin ta, roma ja ta ri utz ri xerubanala' rija', ja ta chuka' ri' ri nye'ibanala' rix. ");
INSERT INTO cakENT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero rix man quiri' tüj nibün. Rix xa nicanoj achique rubanic nibün richin nquinicamsaj yin ri nintzijoj ri ketzij chive, ketzij ri vac'axan-pe riq'uin ri Dios. Ri Abraham man c'a xbün tüj cachi'el ri nibün rix, y rix nibij que rix ruxquin-rumam can rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Rix xa ja ri nbün ri jun ri c'unük itata', xa jari' ri nibün, xbij ri Jesús cheque. Y rije' xquibij c'a chin: Roj ketaman ruvüch ri xojalc'ualan. Xaxe c'a Jun ri Katata', y ri' ja ri Dios, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","C'ateri' ri Jesús xbij c'a cheque ri vinük ri': Si ja ta ri Dios ri Itata', nk'alajin ta, roma nquinijo' ta y nquinic'ul ta jabel, roma yin riq'uin ri Dios yin petenük y yin kajnük-vi-pe. Ja vi c'a ri Dios ri takayon-pe vichin y man pa nuyon tüj yin que xinpu'u chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Achique c'a roma tok rix man nijo' tüj que nk'ax chive ri ninbij chive? Roma xa man nka' tüj chive. ");
INSERT INTO cakENT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ri itata' rix xa ja ri itzel-vinük y rix richin c'a rija', y ja ri nka' chuvüch rija', jari' ri nyixtajin chubanic. Ri itzel-vinük ja pa rutz'uquic tz'ucutnük-vi-pe richin ncamsan. Man xc'uje' tüj c'a chic chupan ri ketzij, roma xa man jun c'a ketzij ri c'o ta riq'uin. Xa jun tz'ucuy-tzij vi. Quitata' c'a conojel tz'ucuy tak tzij. ");
INSERT INTO cakENT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Y yin man c'a nquininimaj tüj roma ja ri ketzij ri ninbij chive. ");
INSERT INTO cakENT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿C'o comi c'a jun ri nbin-pe chuve vocomi achique mac ye nubanalun? Y si jabel nk'alajin que man jun mac pa nuc'aslen y ruyon ketzij ri ninbij, ¿achique c'a roma tok man nquininimaj tüj? ");
INSERT INTO cakENT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Roma ri richin chic c'a ri Dios, ja ri nbij ri rutzij ri Dios ri nbün. Jac'a rix man quiri' tüj nibün, roma man rix richin tüj ri Dios, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Y ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, xquibij c'a chin ri Jesús: Ketzij vi c'a ri kabin chavij que rat xa rat jun aj-Samaria y c'o itzel espíritu aviq'uin, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Pero ri Jesús xbij c'a cheque ri achi'a' ri': Yin man jun itzel espíritu ri c'o ta viq'uin. Yin ja ri Nata' ri ninya' ruk'ij, y rix xa man quiri' tüj chivüch. Rix xa nibün chuve que yin itzel. ");
INSERT INTO cakENT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yin man nuk'ij tüj ri nincanoj chi'icojol, pero c'o c'a Jun ri njo'on que ronojel vinük nuya' ta nuk'ij. Y ja chuka' rija' ri nbün juzgar pa quivi' ri man nquibün tüj quiri'. ");
INSERT INTO cakENT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tivac'axaj na pe' jabel ri ninbij chive: Achique c'a vinük ri nutakej ri nutzij, man c'a nutz'et tüj ri camic ri richin chi jumul, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Y ri achi'a' ri c'o quik'ij chiquicojol ri israelitas xquibij c'a chin ri Jesús: Vocomi ketaman chic c'a que c'o-vi itzel espíritu aviq'uin, roma nabij que achique ri nyetaken ri atzij, man c'a nyecom tüj. Tatz'eta' na pe' ri kaxquin-kamama' can Abraham y ri xek'alajrisan ri rutzij ri Dios ojer can, xecom. ");
INSERT INTO cakENT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Más nim ta comi ak'ij rat que chuvüch ri kaxquin-kamama' can Abraham? Rija' xa xcom, y quiri' chuka' ri xek'alajrisan ri rutzij ri Dios ojer can, xecom. ¿Rat achique ta c'a rat? Roma nabij que ri nyetaken ri atzij man nyecom tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Y ri Jesús xbij: Si nuyon c'a yin ninya' nuk'ij, xa man jun c'a nc'atzin-vi. Pero ri nuk'ij yin, ja ri Nata' nyo'on. Ri Nata' jari' ri nibij i-Dios chin. ");
INSERT INTO cakENT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Y stape' (aunque) rix quiri' nibij chin, man ivetaman tüj ruvüch. Jac'a yin vetaman-vi ruvüch. Y xa nquinoc c'a jun tz'ucuy-tzij cachi'el rix, si ta ninbij que man vetaman tüj ruvüch ri Dios, y xa vetaman. Yin ninbün-vi c'a ri nbij ri rutzij rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ri Abraham juis c'a xquicot ránima, roma nc'atzinej c'a que nutz'et can ri k'ij vichin yin. Y rija' xutz'et-vi, y juis xquicot ránima romari', xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jari' tok ri achi'a' ri c'o quik'ij chiquicojol ri israelitas xquibij chin ri Jesús: Rat nabij que atz'eton chic ri kaxquin-kamama can Abraham, pero rat xa c'a rat ac'ual vi. Xa c'a man jani cincuenta ajuna'. ");
INSERT INTO cakENT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Pero ri Jesús xbij cheque ri achi'a' ri': Ketzij c'a ninbij chive que yin yinc'o-vi-pe. Yinc'o-vi-pe tok man jani rutzijol que nalüx ri Abraham, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Y ri achi'a' ri' jari' tok xbequisiq'uila-pe abüj richin nyequic'ük chirij. Pero ri Jesús xel c'a pe chiri' pa racho ri Dios. Chiquicojol c'a ri vinük xrevala-pe-ri', xel-e. ");
INSERT INTO cakENT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ri Jesús nc'o c'a e ape' c'o-vi jun achi moy pa ralaxic. Ri Jesús xutz'et c'a ri jun achi ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Y ri achibila' xquic'utuj c'a chin ri Jesús: Ajaf, ¿achique c'a ri xmacun richin quere' xalüx ri achi re'? ¿Ja ri rute-rutata' o ja rija'? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Pero ri Jesús xbij: Man jun c'a cheque tüj rije' ri xmacun, richin quere' xuc'ulachij ri jun achi re'. Ni rija' ni ri rute-rutata'. Rija' quere' c'a pa ralaxic, richin que nk'alajin ta ri rusamaj ri Dios riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Pak'ij, utz vi que nban samaj. Jac'a tok ntoc-pe ri ak'a', conojel man utz tüj chic nyesamüj. Y quiri' c'a chuka' yin, vocomi nc'atzin richin ninbün ri samaj ri ruchilaben-pe chuve ri takayon-pe vichin, roma tok man nquic'uje' tüj chic, man nquitiquer tüj chic ninbün ri samaj re'. ");
INSERT INTO cakENT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Y ri k'ij c'a ri c'a yinc'o na e chuvüch ri ruch'ulef, jac'a yin ri nquisakrisan quic'aslen conojel vinük, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tok ye rubin chic c'a ka ri tzij ri' ri Jesús, rija' xchuban c'a pan ulef. Y riq'uin ri ruchub ri xka' pan ulef, xbün ba' vit ch'abük. C'ateri' ri chabük ri' xuquil-e chirunak'-ruvüch ri achi moy. ");
INSERT INTO cakENT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Y xbij chin: Vocomi cabiyin c'a, y te'ach'aja' ri runak'-avüch pan atinbül rubini'an Siloé. Ri bi'aj c'a re' pa jun chic tzij nbix Takon chin. Ri achi ri' xbe na vi, xuch'üj ri runak'-ruvüch, y tok xtzolij-pe, ntzu'un chic. ");
INSERT INTO cakENT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","C'ateri' c'a tok ri vinük ri ye ru-vecinos ri achi re' y ri ch'aka chic vinük ri ye tz'eteyon richin que moy, nquibila' c'a: ¿Man ja tüj comi achi re' ri c'utuy-limosna ri katz'etelon que tz'uyul nuc'utuj can ru-limosna? nquibij c'a. ");
INSERT INTO cakENT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Y yec'o c'a vinük ri nyebin: Ja', ja rija'. Ch'aka chic nquibij: Junan ntzu'un riq'uin ri achi ri'. Pero rija' nbij c'a: Ja'. Ja yin ri' ri tz'uyul ninc'utuj can limosna cheque ri vinük, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Y ri vinük nquic'utuj c'a chin ri achi ri': Ri rubanun-pe xa man ncatzu'un tüj. ¿Achique c'a rubanic xban chave richin que ncatzu'un chic vocomi? xquibij c'a chin. ");
INSERT INTO cakENT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ri achi xbij cheque: Ri jun achi rubini'an Jesús xbün ba' vit ch'abük y jari' ri xuquil chirunak'-nuvüch, y c'ateri' xbij chuve: Cabiyin y te'ach'aja' ri runak'-avüch pa Siloé. Y yin xinbe-vi, xinch'üj ri runak'-nuvüch y jari' tok xintzu'un. ");
INSERT INTO cakENT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pero ri vinük xquic'utuj chin: ¿Ape' c'a c'o-vi ri Jesús vocomi? xquibij. Y rija' xbij: Man vetaman tüj, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Y ri vinük xquic'uaj c'a e ri achi moy tok rubanun can, c'a chiquivüch ri achi'a' fariseos. ");
INSERT INTO cakENT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ri k'ij c'a tok ri Jesús xbün ri ba' vit ch'abük y xbün chin ri achi moy que ntzu'un, pa jun c'a k'ij richin uxlanen. ");
INSERT INTO cakENT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tok ri achi, ri moy rubanun can, c'o chic c'a apu chiquivüch ri achi'a' fariseos, ri achi'a' ri' xquic'utuj c'a chin que achique rubanic xban chin richin vocomi ntzu'un chic. Y rija' xbij: Ri xbanun c'a chuve richin nquitzu'un chic, xuquil c'a ba' vit ch'abük chirunak'-nuvüch, xinch'üj, y jare' nquitzu'un chic, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Y yec'o c'a achi'a' fariseos ri xquibij: Ri achi ri rubini'an Jesús man riq'uin tüj ri Dios petenük-vi, roma man nuchajij tüj ba' ri k'ij ri richin uxlanen, nquibij. Pero yec'o c'a ch'aka chic fariseos ri xquibij: ¿Ntiquer ta comi nyerubün milagros jun achi aj-mac, cachi'el xbün ri Jesús riq'uin ri achi moy? Ri achi'a' fariseos ri' man junan tüj c'a ri quinojibül pari' ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","C'ateri' ri achi'a' fariseos xquic'utuj c'a chin ri achi, ri moy tok rubanun can: ¿Achique chi achi ri Jesús nanuc rat? Ri xbün chave que ncatzu'un. Y ri achi ri' xbij: Yin ninnuc que ri Jesús k'alajrisüy richin ri nbix chin roma ri Dios, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jac'a ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, man nquinimaj tüj c'a que ri achi ri' moy vi tok xalüx. Romari' man nquinimaj tüj chuka' que jun milagro ri xbanun que ntzu'un vocomi. Xecoyoj na c'a ri rute-rutata' ri achi ri ntzu'un chic vocomi. ");
INSERT INTO cakENT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Y ri achi'a' ri' xquic'utuj c'a cheque ri rute-rutata' ri achi: ¿Ja ivalc'ual re', ri nibij que moy pa ralaxic? Si moy c'a tok xalüx, ¿achique c'a roma tok ntzu'un vocomi? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Y ri rute-rutata' ri achi xquibij c'a cheque ri achi'a' ri': Ja', ja kalc'ual re' y moy vi pa ralaxic. ");
INSERT INTO cakENT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jac'a ri man ketaman tüj roj, ja ri achique rubanic xbün richin ntzu'un chic vocomi. Y si c'o jun ri xbanun chin richin ntzu'un chic vocomi, man ketaman tüj roj. Tic'utuj c'a chin rija', roma xa c'o chic c'a rujuna', y ntiquer nbij chive ri achique xbanatüj, xquibij rije'. ");
INSERT INTO cakENT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Quiri' c'a ri xquik'alajrisaj ri rute-rutata' ri achi, cheque ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, roma quixbin c'a qui' chiquivüch. Ri achi'a' ri c'o quik'ij, quelesan chic c'a rutzijol que achique na vinük ri nbin que ri Jesús jari' ri Cristo, nokotüx c'a pe chupan ri jay ape' ntzijos-vi ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Xa romari' tok ri rute-rutata' ri achi ri ntzu'un chic, xaxe c'a xquibij que tiquic'utuj chin rija', roma xa c'o chic rujuna'. ");
INSERT INTO cakENT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Y ri achi'a' ri' xcoyoj chic c'a jun bey ri achi ri ntzu'un chic, y xquibij chin: Ja ri Dios taya' ruk'ij. Roj ketaman que ri achi rubini'an Jesús, jun achi aj-mac, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Y ri achi xbij c'a cheque ri achi'a' ri': Yin man c'a vetaman tüj si ri Jesús jun aj-mac o man aj-mac tüj. Ri vetaman yin pari' rija', ja que xinruc'achojrisaj, roma tok rubanun can man c'a nquitzu'un tüj, y vocomi nquitzu'un chic, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Y ri achi'a' ri' xquic'utuj chic c'a chin ri achi: ¿Achique ri xbün chave richin quiri' xatiquer xatzu'un? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Rija' xbij c'a cheque ri achi'a' ri': Pero ri' xintzijoj yan c'a chive y xa man xinivac'axaj tüj. ¿Achique c'a roma tok vocomi rix nijo' que yin nincamulij chic rubixic chive? ¿Nijo' c'a nitzeklebej ri Jesús? xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pero ri achi'a' ri' xcatüj c'a coyoval y xquibij: Ja rat sí rat jun tzeklebey richin rija', jac'a roj roj tzeklebey richin ri Moisés. ");
INSERT INTO cakENT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Roj ketaman-vi c'a que ri Moisés xch'o-vi ri Dios riq'uin, jac'a ri Jesús re' man ketaman tüj ape' tipu'u-vi, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Y ri achi xch'o-apu cheque y xbij c'a: Jare' ri nbanun chuve yin que juis nquinuc pari', roma rix man ivetaman tüj ape' npu'u-vi, pero viq'uin yin xbün jun milagro, roma vocomi nquitzu'un chic. ");
INSERT INTO cakENT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nk'alajin-vi que ri Jesús man aj-mac tüj, roma ketaman que ri Dios man nbün tüj ri nquic'utuj ri aj-maqui' chin. Pero ri jun ri nuya-vi ruk'ij ri Dios y nbün chuka' ri nrajo' ri Dios, nac'axüx-vi roma ri Dios, y nbanatüj ri nuc'utuj. ");
INSERT INTO cakENT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Man jun bey c'a tz'eton o ac'axan tüj que c'o ta jun ri nbanun chin jun ri moy vi pa ralaxic richin ntzu'un ta. ");
INSERT INTO cakENT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Y si ta ri achi rubini'an Jesús, man ta riq'uin ri Dios petenük-vi, man ta xtiquer xbün ri milagro viq'uin yin, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pero ri achi'a' ri' xquibij chin ri achi ri ntzu'un chic: Rat rat aj-mac pe pan avalaxic, ¿y najo' nkojatijoj roj? xquibij. Y xquelesaj c'a pe ri achi ri', ri chiri'. ");
INSERT INTO cakENT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ri Jesús xrac'axaj c'a que ri achi ri' xelesüs-pe. Romari' xberucanoj, y tok nril, xbij c'a chin: ¿Naya' comi avánima rat riq'uin ri Ruc'ajol ri Dios? xbij ri Jesús chin. ");
INSERT INTO cakENT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Y ri achi ri ntzu'un chic xbij c'a chin ri Jesús: Yin ninjo' ninya' vánima riq'uin ri Ruc'ajol ri Dios, xa jac'a ri man vetaman tüj achique ri'. Tabij c'a chuve, xbij ri achi. ");
INSERT INTO cakENT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Y ri Jesús xbij c'a chin: Rat atz'eton chic c'a ri Ruc'ajol ri Dios. Ja yin ri Ruc'ajol ri Dios. Ja yin ri nquich'o aviq'uin, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ri achi jari' xbij: Ajaf, yin ncatintakej. Y ri achi xuya' ruk'ij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Y ri Jesús xbij: Yin xinpu'u c'a chuvüch ri ruch'ulef chiquitz'etic ri vinük achique quibanun, si utz o man utz tüj. Y ninbün c'a cheque ri vinük ri man ntzu'un tüj cánima, que titzu'un. Jac'a ri nquina' que ntzu'un ri cánima, xa ninbün que man nquitzuün tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Y yec'o c'a achi'a' fariseos ri yec'o-apu chiri' ape' c'o-vi ri Jesús, tok xcac'axaj ri', xquibij: ¿Roj moyirnük c'a chuka' roj? ");
INSERT INTO cakENT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Y ri Jesús xbij cheque: Si ta rix moy, jabel ta, roma man jun tüj mac nivakalej. Xa roma c'a rix nibij que man rix moy tüj, xa romari' tok ri imac c'o-vi. ");
INSERT INTO cakENT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Y tivac'axaj na pe' jabel ri ninbij chive: Ri quicoral ri oveja c'o c'a jun ruchi'. Y ri man c'a nucusan tüj ri ruchi' ri coral richin ntoc-apu y xa nuropij, ri nbanun c'a quiri' jun elek'on y jun tz'amoy quichin vinük pa tak bey richin c'o nrelesaj can cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jac'a ri nucusan ri ruchi' ri coral richin ntoc-apu, ri' ja vi ri' ri yuk'uy quichin ri ovejas. ");
INSERT INTO cakENT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Y ri yuk'uy quichin ri ovejas nujük c'a pe ri ruchi' ri coral chuvüch, y ri ovejas quetaman chic ri ruch'abül ri quiyuk'uy. Rija' nyeroyoj chiquijujunal riq'uin ri quibi' y nyerelesaj c'a e. ");
INSERT INTO cakENT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tok ri yuk'uy quichin ovejas ye relesan chic c'a e conojel ri ru-ovejas, ninabeyüj c'a e chiquivüch y ri ovejas nyetzeke-e chirij. Ri ovejas quiri' vi nquibün, roma quetaman c'a ruch'abül ri niyuk'un quichin. ");
INSERT INTO cakENT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Jac'a ri man quetaman tüj ruvüch, man nquitzeklebej tüj. Xa nye'anmüj chuvüch, roma man quetaman tüj ri ruch'abül, ch'abül ri xa man jun bey cac'axan tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ri Jesús jun ejemplo ri xbij cheque ri achi'a' fariseos, jac'a rije' man xk'ax ta cheque achique ri xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","C'ateri' ri Jesús xch'o jun bey chic y xbij cheque ri achi'a' fariseos ri': Tivac'axaj c'a jabel ri ninbij chive: Ja yin ri Ruchi' ri coral ri ape' nye'oc-apu ri ovejas. ");
INSERT INTO cakENT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Y ye q'uiy c'a ri xec'uje' yan nabey que chinuvüch yin y xquibij que ye takon-pe roma ri Dios, pero xa man quiri' tüj, xa ye junan quiq'uin ri elek'oma' y ye junan quiq'uin ri nyetz'amon vinük pa tak bey richin c'o nquelesaj can cheque. Matiox c'a que man xetzeklebex tüj coma ri ovejas ri ye vichin yin. ");
INSERT INTO cakENT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ja yin c'a ri Ruchi' ri coral. Ri ntoc c'a viq'uin yin, ncolotüj y nril ronojel ri nc'atzin chin. ");
INSERT INTO cakENT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Jun elek'on tok napon, xe c'a richin nberubana-pe elek' y ncamsan can. Ronojel c'a ri nbün can, man pa rubeyal tüj. Jac'a yin, nbij ri Jesús, xinpu'u richin ninya' ri c'ac'a' c'aslen, jun utzilüj c'aslen. ");
INSERT INTO cakENT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Y ja yin ri utzilüj K'uyunel. Ri utzilüj K'uyunel, nuya-vi ruc'aslen coma ri ru-ovejas. ");
INSERT INTO cakENT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jac'a ri xa man ketzij k'uyunel tüj, ri xa nyuk'un roma tojon y man rajaf tüj chuka' ri ovejas, ri' tok nutz'et c'a que npu'u ri utif, xa ja rija' ri nucol-e-ri' nabey y nyeruvulaj ri ovejas ri nyeruyuk'uj. Y ri utif nyeruc'uaj c'a ri ovejas, y ri ch'aka chic nquitalüj-e-qui'. ");
INSERT INTO cakENT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ri man c'a ketzij tüj yuk'uy quichin ri ovejas, ri xa tojon, nanmüj. Y quiri' nbün roma xa man c'a rajaf tüj ri ovejas. Man jun c'a pena chin rija' si c'o nquic'ulachij ri ovejas. ");
INSERT INTO cakENT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Jac'a yin ri utzilüj K'uyunel, y vetaman quivüch ri ovejas ri ye vichin yin, y rije' quetaman c'a chuka' nuvüch yin. ");
INSERT INTO cakENT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Quiri' c'a chuka' nubanun yin riq'uin ri Nata'. Rija' retaman nuvüch yin, y yin vetaman ruvüch rija'. Yin ninya' c'a nuc'aslen coma ri nu-ovejas. ");
INSERT INTO cakENT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Y yin man xe tüj c'a nu-ovejas re' yec'o, xa yec'o c'a chuka' ch'aka chic ri man jani yec'o ta chere' chupan ri jun coral re'. Nyenc'ün c'a pe y ncac'axaj chuka' ri nuch'abül. Nc'uje-vi c'a jun ketzij K'uyunel y jun li'aj ru-ovejas. ");
INSERT INTO cakENT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ri Nata' Dios nquirujo-vi c'a. Nka' c'a chuvüch que yin ninya' ri nuc'aslen coma ri nu-ovejas, y chuka' roma ri nc'uje' chic c'a e nuc'aslen jun bey. ");
INSERT INTO cakENT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ri nuc'aslen yin, man jun c'a nelesan, xa c'a ja na yin ri nquiyo'on. Pa nuk'a' c'a yin c'o-vi richin que ninya' y pa nuk'a' chuka' yin c'o-vi richin nc'uje' chic e nuc'aslen jun bey. Quiri' c'a ri rubin-pe ri Nata' chuve, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Y jari' tok xjalajo' jun bey chic chiquivüch ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, roma ri tzij ri xerubij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ye q'uiy cheque rije' ri xquibij chirij ri Jesús: Xa loco la'. Xa itzel espíritu ri c'o riq'uin, y rix ninimaj-ka ri nbij. ");
INSERT INTO cakENT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jac'a ri ch'aka chic xquibij: Jun ri c'o itzel espíritu riq'uin, man ntiquer tüj nbij utzilüj tak tzij cachi'el ri xerubij-ka ri Jesús. ¿Ntiquer ta comi chuka' jun ri c'o itzel espíritu riq'uin que nbün chin jun moy que ntzu'un jun bey chic? nquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Y pa ru-tiempo c'a ri tef, jari' tok nban ri nimak'ij rubini'an Dedicación, nimak'ij richin ruk'ijul tok xch'ajch'ojrisüs ri racho ri Dios ri c'o chiri' pa tinamit Jerusalén. ");
INSERT INTO cakENT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Y ri Jesús c'o c'a apu chupan ri racho ri Dios. Y pa jun corredor ri rubini'an Richin ri Salomón, chiri' c'a c'o-vi. ");
INSERT INTO cakENT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ri achi'a' ri c'o quik'ij chiquicojol ri israelitas xe'apon riq'uin ri Jesús, xquisutij rij, y c'ateri' xquibij c'a chin: ¿Achique c'a roma tok man jun bey najo' nak'alajrisaj-avi' chikavüch? Si ja rat ri Cristo, tabij c'a cheke. ");
INSERT INTO cakENT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Y ri Jesús xbij c'a cheque ri achi'a' ri': Nubin chic c'a chive y man nquitaken tüj. Y ronojel ri samaj ri nyenbün, pa rubi' c'a ri Nata' Dios nyenbün-vi. Y ri samaj ri' nuk'alajrisaj-vi c'a ri achique yin. ");
INSERT INTO cakENT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Xa jac'a rix man nquinitakej tüj vi, roma rix xa man rix nu-ovejas tüj, cachi'el vi c'a ri xinbij yan chive. ");
INSERT INTO cakENT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ri nu-ovejas yin quetaman y ncac'axaj ri nuch'abül, y yinquitzeklebej chuka'. Yin vetaman c'a chuka' quivüch rije'. ");
INSERT INTO cakENT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Man nyesatz tüj c'a can, xa nquil-vi quic'aslen ri man nq'uis tüj, viq'uin yin. Ni man jun c'a chuka' ri ntiquer nye'elesan-e pa nuk'a'. ");
INSERT INTO cakENT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Y chuka' pa ruk'a' c'a ri Nata' Dios yec'o-vi, roma ja rija' ri xcha'on quichin. Y rija' jari' ri más nim ruk'ij que chuvüch achique na. Y man jun c'a ri xtiquer nyerelesaj-e pa ruk'a' rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yin vachibilan ri Nata', jun c'a kabanun riq'uin, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Y jari' tok ri achi'a' ri c'o quik'ij chiquicojol ri israelitas xebequisiq'uila' chic c'a pe abüj chirij ri Jesús, richin nquicamsaj chi abüj. ");
INSERT INTO cakENT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero ri Jesús xbij c'a cheque ri achi'a' ri': Q'uiy c'a utzilüj tak samaj ri ye nubanalun chivüch, roma ri vuchuk'a' ri ruyo'on-pe ri Nata' chuve. ¿Achique c'a cheque ri utzilüj tak samaj ri nubanun ri man nka' tüj chivüch, y romari' nijo' nquinicamsaj chi abüj? xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Y ri achi'a' ri c'o quik'ij chiquicojol ri israelitas xquibij chin ri Jesús: Roj man ncatkac'ük tüj chi abüj roma jun utzilüj samaj. Roj ncatkac'ük chi abüj roma nabij que rat junan riq'uin ri Dios. Roma jun achi ri nbin quiri', xa nuyok' rubi' ri Dios, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Pero ri Jesús xbij c'a cheque: Chupan ri ley ri ivichin ibanun-ka chin, ri Dios nbij c'a: Yin nubin que ivonojel rix rix dios chuka'. ");
INSERT INTO cakENT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ketaman c'a que man jun bey nkutiquer tüj nkabij que ri nbij ri rutzij ri Dios man ketzij tüj. Rija' xbij dios cheque ri achique chok chin xuya-vi ri rutzij. ");
INSERT INTO cakENT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Si quiri' xbij ri Dios, ¿achique c'a roma rix nibij que yin xinyok' rubi' ri Dios roma xinbij que ja yin ri Ruc'ajol ri Dios? Y yin xinrucha' c'a ri Dios richin xinrutük-pe chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Y si man ninbün tüj c'a ri ruchilaben-pe ri Nata' Dios que ninbün yin, man nquinitakej tüj c'a. ");
INSERT INTO cakENT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Jac'a si ninbün ri ruchilaben-pe ri Dios chuve, quinitakej romari', stape' (aunque) man nquinitakej tüj roma ri nubin chive. Titakej, richin que tivetamaj que ri Nata' Dios c'o-vi c'a viq'uin y yin chuka' quiri' nubanun riq'uin rija', xbij ri Jesús cheque ri achi'a' ri c'o quik'ij. ");
INSERT INTO cakENT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Juis c'a xcajo' ri achi'a' ri' que xquitz'om ta e ri Jesús, pero xa man xetiquer tüj jun bey chic, roma xa xbe chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Y ri Jesús xc'o chic apu lojc'an ruchi' rakün-ya' Jordán y xc'uje' c'a ka q'uiy k'ij chiri', ri ape' xbün-vi bautizar ri Juan Bautista, pa nabey. ");
INSERT INTO cakENT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Y ye juis c'a ye q'uiy vinük xe'apon riq'uin ri Jesús chiri'. Y ri vinük ri' nquibila' c'a: Ri Juan Bautista ketzij vi que man jun milagro ri xbün richin que xuk'alajrisaj-ri' que takon-pe roma ri Dios, pero ronojel c'a ri tzij ri xerubij can chirij ri achi re', ketzij vi, nquibij c'a ri vinük ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y ye q'uiy c'a vinük ri xetaken richin ri Jesús chupan ri jun lugar ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Chupan c'a ri vit tinamit rubini'an Betania ri quitinamit ri María y ri Marta ri quichak'-qui', c'o c'a jun yava'. Ri yava' ri' rubini'an c'a Lázaro. ");
INSERT INTO cakENT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ri María re', jare' ri xyo'on jubulüj ak'on chirij ri rakün ri Ajaf Jesús y xerusu' riq'uin ri rusmal tak ruvi'. Xa ruxbal c'a rija' ri Lázaro, ri yava'. ");
INSERT INTO cakENT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Y ri María y ri Marta ri ye rana' ri Lázaro, xquitük c'a rubixic chin ri Jesús: Ajaf, vocomi c'a nkaya' rutzijol chave que ri kaxbal Lázaro, ri juis najo' rat, yava'. Cotz'ol c'a pa ruvarabül. ");
INSERT INTO cakENT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Y tok ri Jesús xrac'axaj c'a ri takon-e rutzijol chin, rija' xbij: Ri Lázaro nyavüj, roma nc'atzin c'a que nk'alajin ri ruchuk'a' ri Dios. Ri yabil c'a ri ntoc chin, man c'a ntiquer tüj nuc'uaj pa camic. Xa nk'alajin na c'a ri ruchuk'a' ri Dios, richin quiri' yin ri Ruc'ajol ri Dios ninc'ul tüj c'a nuk'ij, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ri Jesús juis c'a nrajo' ri Marta, chuka' ri María ri ruchak', y ri Lázaro. Ye oxi' juis c'a nyerujo'. ");
INSERT INTO cakENT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Y tok rija' xrac'axaj que ri Lázaro c'o yabil tz'amayon richin, c'a pa rox c'a k'ij xbe chutz'etic, roma c'a xc'uje' na chic ca'i' k'ij chupan ri lugar ape' c'o-vi. ");
INSERT INTO cakENT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Y ja tok c'unük chic ri ca'i' k'ij, ri Jesús xbij cheque ri rachibila': Vocomi nkutzolij c'a pa ruch'ulef Judea, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Y ri rachibila' xquibij c'a chin: Maestro, xquibij c'a chin. Xa c'ate ba' tok ri achi'a' ri c'o quik'ij chikacojol roj israelitas quic'ualon chic abüj chavij richin ncatquicamsaj. ¿Najo' c'a que ncatzolij chic chila' vocomi? xquibij ri achibila' chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Pero ri Jesús xbij cheque: Ri k'ij ruc'uan c'a doce horas. Ri nbiyin pak'ij, man c'a nutopla' tüj rakün, roma c'o ri sük richin ri ruch'ulef. Ronojel c'a nutz'et roma ri sük ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Jac'a ri nbiyin pa k'eku'n, nutopla' ri rakün, roma xa manak ri sük pa ruvüch. ");
INSERT INTO cakENT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Y tok ri Jesús rubin chic ka ronojel re', xch'o jun bey chic cheque ri rachibila' y xbij: Ri Lázaro ri ketaman ruvüch, nvür. Roma c'a ri' jare' nquibe chin nc'asoj, xbij cheque ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Y jari' tok ri rachibila' xquibij chin: Ajaf, si ri Lázaro xa nvür, xa nc'achoj, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Y ri Jesús xa pari' ri rucamic ri Lázaro xch'o-vi tok xbij que nvür, pero ri rachibila' xk'ax cheque que varan vi. ");
INSERT INTO cakENT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","C'ateri' ri Jesús jabel c'a choj ri xbij cheque. Rija' xbij c'a: Ri Lázaro xcom. ");
INSERT INTO cakENT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Y juis c'a nquiquicot, xbij ri Jesús, roma man pa Betania tüj yinc'o-vi tok xcom ri Lázaro, richin quiri' c'o k'ij chive rix richin que más niya' ivánima viq'uin. Vocomi jo' c'a pa Betania, ape' c'o-vi ri Lázaro, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jac'a ri rachibil ri rubini'an Tomás, y nbix chuka' Ri Cuach chin, rija' xbij c'a cheque ri achibila' ri ye rachibil vi: Jo' c'a chirij ri Jesús, richin que si rija' ncamsüs, ja chuka' ri' tikac'ulachij roj, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Y ri Jesús y ri rachibila' xe'apon c'a pa tinamit Betania. Ri k'ij c'a tok xe'apon rije', ya ja caji' k'ij c'o ri camnük pa jul. ");
INSERT INTO cakENT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ri tinamit Betania man nüj tüj ncanaj-vi can chin ri tinamit Jerusalén. Ri quicojol xa bama nic'aj legua. ");
INSERT INTO cakENT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Y ye q'uiy c'a achi'a' ri c'o quik'ij chiquicojol ri israelitas ri xepu'u chiri' y xe'apon nquipochi'ij ri Marta y ri María, roma ri rucamic ri quixbal Lázaro. ");
INSERT INTO cakENT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tok ri Marta xapon c'a rutzijol riq'uin que petenük ri Jesús, junanin xel-e richin xbe chi ruc'uluxic. Y ri María man c'a xunabej tüj, xa xcanaj can chiri' pa jay. ");
INSERT INTO cakENT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Y ri Marta tok xapon c'a riq'uin ri Jesús, rija' xbij chin: Ajaf, ri nuxbal xcom. Xa ta chere' ratc'o-vi, c'a c'üs ta vocomi. ");
INSERT INTO cakENT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero yin vetaman que ri nac'utuj chin ri Dios vocomi, ri Dios nuya-vi chave, xbij ri Marta chin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jari' tok ri Jesús xbij chin ri Marta: Ri axbal Lázaro nc'astüj, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Y ri Marta xbij chin ri Jesús: Ja', yin vetaman que nc'astüj, roma tok napon ri ruq'uisbül k'ij, conojel c'a ri caminaki' nyec'astüj, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ri Jesús xbij c'a chin ri Marta: Yin nquitiquer-vi nyenc'asoj ri ye camnük chic e, y nquitiquer-vi ninya' c'aslen. Romari' ri ntaken vichin, man jun rubanun si camnük chic, roma nc'uje' ruc'aslen. ");
INSERT INTO cakENT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Achique na c'a vinük ri c'a c'o na ruc'aslen chuvüch ri ruch'ulef y nquirutakej yin, man c'a napon tüj chupan ri camic richin chi jumul. ¿Nanimaj c'a re'? xbij ri Jesús chin ri Marta. ");
INSERT INTO cakENT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Y ri Marta xbij chin ri Jesús: Ja', Ajaf. Ninnimaj na vi ronojel ri nabij, roma vetaman-vi que ja rat ri Cristo ri Ruc'ajol ri Dios, ri nc'atzinej-vi que npu'u na chuvüch ri ruch'ulef, xbij ri Marta. ");
INSERT INTO cakENT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tok ri Marta rubin chic c'a can ri tzij re' chin ri Jesús, xbe chiroyoxic ri María ri rana'. Y tok xapon c'a, ri Marta xbij pa ruxiquin ri María: Ri Ajaf Jesús xka-pe y vocomi ncaroyoj, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ri María, xe c'a xrac'axaj-e quiri', jari' xcatüj-e ape' tz'uyul-vi y junanin xbe. Rija' xbe c'a ape' c'o-vi ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ri Jesús c'a man jani c'a toc-apu chupan ri vit tinamit Betania, xa c'a c'o na ape' xbec'ul-vi roma ri Marta. ");
INSERT INTO cakENT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Y ri vinük israelitas ri yec'o chiri' pa jay, ri nquipochi'ij ri María, tok xquitz'et que junanin xcatüj, xel-e y xbe. Ri vinük ri' junanin chuka' xquitzeklebej-e, roma rije' xquinuc que ri María nbe chuchi-jul richin nrok'ej ri ruxbal. ");
INSERT INTO cakENT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ja tok ri María xapon ape' c'o-vi ri Jesús y xutz'et, xxuque-ka chirakün y xbij chin: Ajaf, ri nuxbal xcom. Xa ta chere' ratc'o-vi, man ta camnük vocomi, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ja tok ri Jesús xutz'et que ri María ntok' y quiri' chuka' nye'ok' conojel ri quivinak israelitas ri xe'apon chin nquipochi'ij ri María, ri ránima ri Jesús jun vi xbün xuna' rija' y xpu'u c'a bis riq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Y c'ateri' c'a xuc'utuj: ¿Ape' ximuk-vi ri Lázaro? xbij. Y rije' xquibij: Ajaf, jo' y nkac'utu' c'a chavüch ape' xkamuk-vi, xquibij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Y ri Jesús xok'. ");
INSERT INTO cakENT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jari' tok ri vinük israelitas ri nyepochi'in ri Marta y ri María, xquibila' c'a: Titz'eta' la Jesús, nrok'ej ri Lázaro. Nk'alajin que juis xrajo', xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","C'ateri' yec'o c'a cheque ri vinük ri' xquibila' c'a chirij ri Jesús: Rija' xtiquer c'a xbün chin ri moy richin xtzu'un. ¿Man xtiquer tüj comi xbün chin ri Lázaro que man ta xcom? xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tok ri Jesús xapon c'a chuchi' ri jul, xtzolij chic c'a pe ri bis riq'uin. Ri jul ape' mukul-vi ri Lázaro, jun jul ri c'oton chuvüch jun juyu', y tz'apül can ruchi' riq'uin jun abüj. ");
INSERT INTO cakENT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Y jari' tok ri Jesús xbij: Tivelesaj la abüj tz'apbül ruchi' la jul, xbij rija'. Jac'a ri Marta, ri rana' can ri Lázaro ri xcom-e, xbij chin ri Jesús: Ajaf, caji' yan c'a k'ij ri'. Ya chuj chic ninnuc yin, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero ri Jesús xbij chin ri Marta: Yin nubin chic c'a chave que si xtanimaj, xtatz'et c'a ri nbün ri ruchuk'a' ri Dios, xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Y jari' tok xquelesaj c'a ri abüj tz'apbül ruchi' ri jul ape' c'o-vi ri camnük. C'ateri' ri Jesús xtzu'un c'a chicaj y xbij: Nata', matiox ninya' chave, roma xinavac'axaj c'a pe. ");
INSERT INTO cakENT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yin vetaman que chi jumul vi nquinavac'axaj. Y ronojel c'a re', ninbij coma ri vinük ri quimolon-pe-qui' viq'uin vocomi, richin que tiquinimaj que ja rat ri xatakon-pe vichin chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tok ri Jesús rubin chic c'a ka ri tzij re', riq'uin c'a ronojel ruchuk'a' xch'o y xbij: Lázaro, cacatüj y catel c'a pe, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Y ri Lázaro, ri camnük chic e, xbe'el-pe. Ri ruk'a-rakün ri camnük, jabel c'a botz'on-e pa tak c'ul, y ri ruvüch tz'apül c'a e riq'uin jun xax c'ul. C'ateri' ri Jesús xbij: Que'isolo' can la c'ul chirij, richin que utz nbiyin y ntiquer ntzolin-e, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Y ye q'uiy c'a vinük israelitas nquipochi'ij ri María, xquitakej ri Jesús tok xquitz'et ri xbün, que xuc'asoj ri camnük. ");
INSERT INTO cakENT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero yec'o ch'aka ri xebe quiq'uin ri achi'a' fariseos y xbequitzijoj cheque ri achique ri xbün ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Y ja yan c'a ri' ri más nimalüj tak sacerdotes y ri achi'a' fariseos xquimol-qui' y xecoyoj chuka' ri ch'aka chic achi'a' ri junan nyebanun juzgar quiq'uin, y xquibij cheque: ¿Achique c'a nkabün? Roma ri achi rubini'an Jesús rutz'amon samaj y q'uiy milagros ri nyerubanala' chiquivüch ri vinük richin tiquitakej. ");
INSERT INTO cakENT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Y si nkaya' c'a k'ij chin, conojel c'a ri vinük nyetaken richin. Y tok nquinabej-pe ri vinük romanos, nquivulaj-pe ri jay ape' nkaya-vi ruk'ij ri Dios y nkujquiq'uis chuka' can roj ri rojc'o chupan ri ruch'ulef re', nquibij c'a rije'. ");
INSERT INTO cakENT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","C'ateri' c'o jun ri xch'o. Ri xch'o ja ri Caifás ri nimalüj sacerdote chupan ri tiempo ri'. Rija' c'o c'a chiri', roma rija' jun cheque ri c'o quik'ij. Y tok rija' xch'o, xbij c'a: Xa man jun ivetaman rix. ");
INSERT INTO cakENT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Man ninuc tüj c'a ba' que xa más utz cheke roj que xaxe ri jun ncom pa kaq'uexel konojel y mani nkucom konojel xaxe roma ri jun ri', xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ri Caifás tok xch'o y xbij quiri', man ta ja ri runojibül rija' ri xucusaj, man quiri' tüj. Ri tzij ri xerubij rija', ja ri Dios ri xyo'on-pe chin. Roma ja rija' ri nimalüj ru-sacerdote ri Dios ri tiempo ri', romari' ri Dios xuya' c'a k'ij chin richin que xbij yan que ri Jesús nc'atzinej c'a que ncom na pa quiq'uexel ri vinük richin ri ruch'ulef ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y ri Jesús man xe tüj c'a pa quiq'uexel ri vinük richin ri ruch'ulef ri' tok ncom, xa ncom c'a richin nyerumol conojel ri vinük ri ye ralc'ual vi ri Dios ri ye quitalun-qui' chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Y ja k'ij ri' tok ri achi'a' ri c'o quik'ij, xquiya' yan can chiquivüch que nquicamsaj ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Roma c'a ri', ri Jesús man xtz'et tüj chic coma ri achi'a' ri c'o quik'ij chiquicojol ri israelitas. Rija' xa xbe c'a pa jun chic tinamit. Xbe pa jun tinamit ri rubini'an Efraín, y ri tinamit c'a ri' chunakaj apu ri tz'iran ruch'ulef c'o-vi. Y xc'uje' c'a ka chiri' ye rachibilan ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Y jari' tok napon yan ri k'ij richin ri pascua, ri jun quinimak'ij ri israelitas. Romari' juis yan c'a ye q'uiy vinük ri xe'el-pe pa tak quitinamit, richin xebe pa tinamit Jerusalén. Xebe yan c'a roma nc'atzinej que nyequich'ajch'ojrisaj-qui' chuvüch ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Y ri vinük nquicanola' c'a ri Jesús. Rije' ye pa'ül chupan ri racho ri Dios y nquic'utula' c'a chiquivüch: ¿Achique c'a ninuc rix? ¿Npu'u comi chupan ri nimak'ij? nquibij c'a ri vinük ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jac'a ri nimalüj tak sacerdotes y ri achi'a' fariseos, quelesan chic c'a rutzijol que achique na c'a vinük ri xtetaman ta ape' c'o-vi ri Jesús, tubij cheque rije', richin que nquitz'om. ");
INSERT INTO cakENT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tok xa vaki' (seis) chic c'a k'ij nrajo' richin man napon ri k'ij richin ri nimak'ij rubini'an pascua, ri Jesús xbe pa tinamit Betania, ri rutinamit ri jun achi rubini'an Lázaro, ri Lázaro ri xcom-e y xbec'asüs-pe chiquicojol caminaki' roma ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Y chiri' xban c'a jun nima-va'in, roma xapon ri Jesús. Y ja ri Marta ri nye'ilin-apu chuvüch mesa. Ri Lázaro jun c'a cheque ri ye tz'uyul-apu chuvüch mesa riq'uin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Xpu'u ri María ri ruch'ak ri Marta y rana' ri Lázaro, xberuc'ama' c'a pe jun libra jubulüj ak'on rubini'an nardo, jun jubulüj ak'on ri juis jotol rajil. Y jare' ri xuya' chirij rakün ri Jesús y xerusula' can riq'uin ri rusmal tak ruvi' rija'. Y ri jay ri' xnoj c'a riq'uin ri rujubulil ri ak'on ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Y c'o c'a jun cheque ri achibila' ri man xka' tüj chuvüch que quiri' xban chin ri jubulüj ak'on, y ri' ja ri Judas Iscariote ri ruc'ajol ri jun achi rubini'an Simón, ri achibil ri nc'ayin na richin ri Jesús. Rija' xbij c'a: ");
INSERT INTO cakENT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Achique roma tok xa man xc'ayix tüj ri jubulüj ak'on re'? Ri ak'on re' xa xbe ta chi oxi' ciento tumin ri rajil oxi' ciento k'ij samaj chin jun samajel, y ri tumin re' xtalüx ta cheque ri vinük ri man ni jun quichajin, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tok rija' xbij quiri', man roma tüj c'a que juis ta nyerujo' ri vinük ri man ni jun quichajin, y nrajo' ta nyeruto', man quiri' tüj. Xa roma c'a que ja rija' ri yacol-tumin y c'o c'a nrelesala-e, xa romari'. Rija' xa nelek' c'a. ");
INSERT INTO cakENT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jari' tok ri Jesús xbij chin ri Judas: Man tabij c'a jun chic. Taya' can ri xtün re' que tubana' na ri nrajo' ri ránima. Stape' (Aunque) man jani nquicom richin nquimuk, pero vichin yin ruyacon-pe ri ak'on re'. ");
INSERT INTO cakENT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Roma ri vinük ri man ni jun quichajin, chi jumul c'a yec'o iviq'uin richin que achique na k'ij nibün favor cheque. Jac'a yin man chi jumul tüj nquic'uje' iviq'uin, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tok ri Jesús xnabex c'a pe coma ri ruvinak israelitas que c'o pa tinamit Betania, xepu'u. Y juis c'a vinük ri xepu'u. Conojel c'a ri vinük ri' xepu'u roma ri Jesús y richin chuka' que nquitz'et can ri Lázaro, ri xc'asüs-pe roma ri Jesús chiquicojol ri caminaki'. ");
INSERT INTO cakENT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Roma-ri' ri más nimalüj tak sacerdotes xquiya' chiquivüch que chuka' ri Lázaro nquicamsaj rachibilan ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Roma chirij ri Lázaro xquiya-vi que juis ye q'uiy quivinak israelitas ri nyeyo'on can quichin rije' y nquitakej-e ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pa ruca'n k'ij, chiri' pa tinamit Jerusalén, ye juis c'a ye q'uiy vinük. Conojel c'a ri' quic'ulun-qui' chiri' roma ri nimak'ij. Y tok xcac'axaj c'a que benük-apu ri Jesús, ");
INSERT INTO cakENT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ye quic'uan ruk'a' tak che' ri nbix palma chin, xebe chuc'ulic y nquibila' c'a: ¡Matiox que petenük ri Jun re'! ¡Jare' ri ka-Rey roj israelitas! ¡Que ri Ajaf Dios nbün ta bendecir rija' ri pa rubi' ri Ajaf Dios petenük-vi! nquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Y ri Jesús c'o c'a jun alaj burro ri xril, richin que xutz'uye' chirij. Cachi'el vi c'a ri nbij chupan ri rutzij ri Dios ri tz'iban can, chiri' nbij: ");
INSERT INTO cakENT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Man c'a tuxbij-ri' ri ivánima rix ri rix richin chic ri tinamit rubini'an Sión, roma ri i-Rey jare' petenük, tz'uyul-pe chirij jun alaj burro. Quiri' c'a ri tz'iban can. ");
INSERT INTO cakENT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Y pa nabey, ronojel re' man xk'ax ta c'a cheque ri rachibila'. Y xk'ax cheque c'a ja tok ri Jesús c'astajnük chic e chiquicojol ri caminaki' y c'o chic ruk'ij. C'ateri' c'a tok xka' chiquic'u'x que ronojel re' tz'iban can, que nc'atzinej na c'a que nbanatüj, y quiri' vi, roma cachi'el ri tz'iban can, quiri' xbanatüj. ");
INSERT INTO cakENT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Y ri vinük c'a ri xetz'eton richin ri Jesús tok xroyoj ri Lázaro ri camnük chic e richin xc'astüj-pe chiquicojol ri caminaki', nquitzijola' c'a cheque ri ch'aka chic vinük. ");
INSERT INTO cakENT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Y roma c'a ri', tok ri Jesús nakaj chic c'o-vi chin ri tinamit Jerusalén, xepu'u c'a richin nquic'ulu'. Ri vinük ri' cac'axan chic c'a ri milagro ri xbün riq'uin ri Lázaro. ");
INSERT INTO cakENT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jac'a ri achi'a' fariseos nquibila' c'a chiquivüch: Titz'eta', conojel ri vinük ye benük chirij. Man nquinimaj c'a tüj katzij, nquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Y chiquicojol c'a conojel ri vinük ri ye apon pa tinamit Jerusalén chupan ri k'ij ri', richin nquiya' ruk'ij ri Dios chupan ri nimak'ij ri', yec'o chuka' ye ca'i-oxi' vinük griegos. ");
INSERT INTO cakENT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ri ca'i-oxi' c'a vinük re', xe'apon-apu riq'uin ri Felipe ri npu'u pa tinamit Betsaida ri c'o pa ruch'ulef Galilea, richin nquic'utuj jun favor chin, roma rija' jun rachibil ri Jesús. Ri vinük ri' xquibij c'a chin: Roj nkajo' nkuch'o ba' riq'uin ri Jesús, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ri Felipe xbe y xberubij c'a chin ri Andrés ri chuka' ri rachibil ri Jesús. C'ateri' chi ca'i' xebe-apu c'a riq'uin ri Jesús y xquibij chin: Yec'o ca'i-oxi' vinük griegos ri ncajo' nyech'o chave. ");
INSERT INTO cakENT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Y ri Jesús jari' xbij cheque ri ca'i' rachibila' ri': Ja k'ij re' xka-pe, richin que yin ri xinalüx chi'icojol nc'uje' nuk'ij y nquitzolij-e chila' chicaj. ");
INSERT INTO cakENT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Y tivac'axaj c'a ri ninbij chive vocomi, que ketzij vi: Si nkapokonaj nkatic-ka jun vit ruvüch-trigo pan ulef, ri vit ruvüch-trigo ri' xa choj c'a quiri' nc'uje'. Jac'a si man nkapokonaj tüj nkatic-ka, stape' (aunque) nc'uje' can chuxe' ulef ri vit ruvüch-trigo ri', ntel-pe y nuya' ruvüch. ");
INSERT INTO cakENT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Roma c'a ri', ri vinük ri juis nupokonaj ri ruc'aslen chere' chuvüch ri ruch'ulef, man nril tüj ruc'aslen richin chi jumul. Jac'a ri man nupokonaj tüj ri ruc'aslen voma yin richin c'a chi jumul nuyüc-apu. Nc'uje-vi ruc'aslen richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Si c'o c'a jun ri nrajo' nbün ri nusamaj, tipu'u c'a viq'uin. Y ri ape' c'a yinc'o-vi yin, chiri' c'a chuka' nc'uje-vi rija'. Ri nbanun c'a ri nusamaj, ninimirsüs c'a ruk'ij roma ri Nata'. ");
INSERT INTO cakENT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yin juis c'a nk'oxon ri vánima vocomi. ¿Pero ninbij ta c'a chin ri Nata': Quinacolo' chuvüch ri k'oxomül re'? Tok xa romari' xinka-pe. Romari' tok c'a yinc'o vocomi. ");
INSERT INTO cakENT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","C'ateri' rija' xbij c'a: Nata', tabana' c'a que nk'alajin ta ri ak'ij, xbij. Y jari' tok ri Dios xch'o-pe chila' chicaj y xbij: Nubanun chic c'a quiri'. Y ninbün c'a jun bey chic, que nk'alajin-vi ri nuk'ij. ");
INSERT INTO cakENT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Y ye juis c'a cheque ri vinük ri yec'o chiri' ri xebin que xa jun nk'ajan-pe ri xcac'axaj tok xch'o-pe ri Dios chila' chicaj. Jac'a ri ch'aka chic nquibij: Jun ángel xch'o-pe chin, nquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Y ri Jesús xbij c'a cheque: Ri Jun c'a ri xivac'axaj que xch'o-pe chila' chicaj, xch'o-pe ivoma rix y man voma tüj yin. ");
INSERT INTO cakENT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vocomi nka-pe yan c'a ri ru-juicio ri Dios chuvüch ri ruch'ulef, y ri itzel-vinük ri tz'amayon ri ruch'ulef, ntelesüs c'a e. ");
INSERT INTO cakENT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Y tok yin nquijotobüx chuvüch ri cruz, ri vinük nyepu'u c'a viq'uin yin, roma nquisamüj pa tak cánima, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ri Jesús xbij c'a quiri', richin xuk'alajrisaj c'a ri rubanic ri rucamic. ");
INSERT INTO cakENT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Y ri vinük xquibij c'a: Rat abin que ja rat ri' ri Jun ri xalüx chikacojol, pero xa nabij chuka' que najotobüx chuvüch ri cruz. Man nk'ax ta c'a cheke achique roma ri'. Roma roj ketaman ri nbij chupan ri rutzij ri Dios que ri Cristo tok npu'u, nc'uje' richin chi jumul. Tak'alajrisaj c'a chikavüch si ri xalüx chikacojol, jari' ri Cristo o man ja tüj, xquibij rije'. ");
INSERT INTO cakENT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jari' tok ri Jesús xbij cheque: Ri Sük c'a c'o na ba' iviq'uin. Chupan c'a ri Sük ri' quixbiyin-vi, roma c'a c'o na. Y si xa c'a nivoyobej na, c'a tok nina' nk'ekumür-pe chivüch. Y ri xa pa k'eku'n nbiyin-vi, man retaman tüj achique lugar benük-vi. ");
INSERT INTO cakENT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Romari', ri k'ij tok c'a c'o na ri Sük iviq'uin, tiya' ivánima riq'uin, richin que nyixoc alc'ualaxela' richin ri Sük ri'. Quere' c'a ri xerubij ri Jesús cheque ri vinük. C'ateri' xeruya' can, y man jun c'a xetaman ape' xbe-vi. ");
INSERT INTO cakENT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ri Jesús xerubanala-vi juis milagros chiquivüch ri vinük. Pero man riq'uin tüj ri' rije' man xquinimaj tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Y quere' c'a xbanatüj, roma nc'atzinej c'a que nbanatüj na ri ye tz'iban can. Nc'atzinej na que xbanatüj ri rutz'iban can ri Isaías, ri jun ri xk'alajrisan ri rutzij ri Dios ojer can. Rija' rutz'iban c'a can: Ajaf, ¿ri atzij ri xkatzijoj cheque ri vinük, c'o comi c'a jun ri xniman? ¿C'o comi c'a jun ri xk'ax yan chin, roma xutz'et ri avuchuk'a'? Quiri' nbij ri rutz'iban can ri Isaías. ");
INSERT INTO cakENT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ri vinük re' man nyetiquer tüj que nquitakej, roma chupan ri rutz'iban can ri Isaías nbij chuka': ");
INSERT INTO cakENT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Banun c'a cheque rije' que man nyetzu'un tüj y covirnük ri cánima. Romari' man nquitz'et tüj ri nc'ut chiquivüch, man nka-ka tüj pa cánima, y man ntzolij tüj pe quic'u'x richin que yin ninchojmirsaj ri quic'aslen, nbij ri Ajaf. Quiri' ri tz'iban can roma ri Isaías. ");
INSERT INTO cakENT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ri Isaías, ri achi ri xk'alajrisan ri rutzij ri Dios ojer can, xbij quiri' tok xutz'et yan c'a ruk'ij ri Ajaf Jesús, y pari' c'a rija' ch'ovinük-vi can. ");
INSERT INTO cakENT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero chiquicojol c'a ri vinük ri xetaken richin ri Jesús, ye q'uiy ri ye cachibil vi ri achi'a' pa comon nyebanun juzgar chiquicojol ri israelitas. Xa ja ri man xquik'alajrisaj tüj qui', roma nquixbij-qui' chiquivüch ri achi'a' fariseos. Xa nquixbij c'a qui' que nye'okotüx-pe chupan ri jay ape' ntzijos-vi ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Rije' xa más c'a xquinuc achique nquibij ri vinük, y man xka-pe tüj chiquic'u'x ri Dios ri más c'o ruk'ij que chiquivüch ri vinük ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Y ri Jesús riq'uin c'a ruchuk'a' xch'o y xbij: Ri nutaken c'a vichin yin, man xe tüj c'a yin ri nquirutakej, xa nutakej c'a ri Dios ri takayon-pe vichin. ");
INSERT INTO cakENT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ri ntz'eton vichin, nutz'et c'a chuka' ri Dios ri takayon-pe vichin. ");
INSERT INTO cakENT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Roma yin ri Sük, xinpu'u chuvüch ri ruch'ulef richin que achique c'a ri nutaken vichin, man nc'uje' tüj can chupan jun k'eku'n c'aslen. ");
INSERT INTO cakENT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Y ja ri vinük ri nrac'axaj ri nutzij y xa man nka' tüj chuvüch nbün ri nrac'axaj, man ja tüj c'a yin ri nquibanun juzgar pari'. Roma ri nusamaj ri nuc'amon-pe tok xinpu'u chuvüch ri ruch'ulef, man richin tüj que ninbün juzgar pa quivi' ri vinük. Man tinuc quiri'. Ri nusamaj c'a yin ja ri nyencol ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pero pa ruq'uisbül k'ij, nban na c'a juzgar pa quivi' ri nye'etzelan vichin y man nquic'ul tüj ri nutzij pa cánima. Ninbün juzgar pa quivi', roma ri tzij ri xenk'alajrisaj. ");
INSERT INTO cakENT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Roma ri tzij ri xenk'alajrisaj chivüch, ja ri Nata' biyon-pe chuve, y man xentz'ucula' tüj e. Ja rija' ri takayon-pe vichin y rubin c'a pe chuve achique chi tzij ri ninbij y nink'alajrisaj-pe chivüch. ");
INSERT INTO cakENT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Y vetaman c'a que ri rubin-pe ri Nata' Dios chuve, nuya-vi c'a c'aslen ri man nq'uis tüj. Romari' ri tzij ninbij c'a chive, cachi'el rubixic rubanun-pe ri Nata' chuve yin, quiri' rubixic xinbana-pe chivüch rix. ");
INSERT INTO cakENT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Y tok nobos yan ri k'ij richin ri nimak'ij quichin ri israelitas rubini'an pascua, ri Jesús retaman chic c'a que nobos yan ri hora richin que rija' ntel-e chere' chuvüch ri ruch'ulef y ntzolij chila' chicaj riq'uin ri Dios, ri Rutata'. Ri Jesús juis vi ye rujo'on-pe conojel ri ye richin chic rija' ri yec'o chere' chuvüch ri ruch'ulef, y quiri' na c'a ri nuc'ut richin ri nbanun chupan ri k'ij ri', ri ruq'uisbül k'ij. ");
INSERT INTO cakENT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ri Jesús y ri rachibila' quitzamon c'a va'in. Ja ri Judas Iscariote, ri ruc'ajol ri jun achi rubini'an Simón, nsamüj chic c'a ri itzel-vinük pa ránima, y jari' ri nbin chin que tujacha' ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Y stape' (aunque) ri Jesús retaman-vi que ronojel jachon pa ruk'a' roma ri Dios ri Rutata', y chiri' riq'uin ri Dios petenük-vi y chiri' chic ntzolij-vi-e. ");
INSERT INTO cakENT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Man roma tüj ri' xupokonaj ta xcatüj-pe y xuya' can ri ruva'in. Man quiri' tüj. Rija' xrelesaj can ri tziük ri cachi'el jun coton, xberuc'ama-pe jun toalla, y xuxim chuxe' rupan. ");
INSERT INTO cakENT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","C'ateri' xuya' chuka' ya' chupan jun palangana y xutz'om ruch'ajic ri cakün chiquijujunal ri rachibila', y nusula' c'a ri cakün riq'uin ri toalla ri ruximon chuxe' rupan. ");
INSERT INTO cakENT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ja tok xapon riq'uin ri Simón Pedro richin nuch'üj ri rakün, ri Pedro xbij chin ri Jesús: Ajaf, ¿nach'üj c'a chuka' vakün yin? xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Y ri Jesús xbij chin ri Pedro: Ri ninch'üj c'a ri ivakün vocomi, man jani c'a nk'ax ta chive achique roma tok ninbün. Pero nk'ax c'a chive, ba' chic apu. ");
INSERT INTO cakENT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Jac'a ri Pedro xbij: Man c'uluman tüj c'a chuve yin que ja rat ncach'ajon ri vakün. Man c'a ninya' tüj k'ij que nach'üj ta ri vakün, xbij. Y ri Jesús xbij c'a chin: Si man naya' tüj c'a k'ij, man c'a ncac'uje' tüj viq'uin, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Roma c'a ri' ri Simón Pedro xbij chin ri Jesús: Ajaf, si quiri', man c'a xaxe ri vakün nach'üj, xa tach'aja' c'a chuka' ri nuk'a' y ri nujolon, xbij ri Pedro. ");
INSERT INTO cakENT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero ri Jesús xbij chin: Ri ruch'ajch'ojrisan chic ri', xaxe c'a ri rakün ri c'uluman que nuch'üj roma ri pokolaj, roma rija' ch'ajch'oj chic. Rix rix ch'ajch'oj chic. Stape' (Aunque) man chi'ivonojel tüj, pero rix ch'ajch'oj chic, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Rija' xbij c'a quiri', roma retaman achique ri nc'ayin richin. Y romari' tok xbij: Man chi'ivonojel tüj rix ch'ajch'oj. ");
INSERT INTO cakENT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Y tok ri Jesús ruch'ajon chic c'a cakün ri rachibila' xberuc'ama' chic c'a pe ri tziük ri ruch'ilon can chirij, xbetz'uye' chic chuvüch mesa y xbij c'a: ¿Xk'ax comi chive achique roma tok yin xinch'üj ri ivakün? ");
INSERT INTO cakENT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ka-maestro y Kajaf, nquibij c'a chuve. Utz vi c'a ri', roma quiri' vi. ");
INSERT INTO cakENT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Y roma yin ri I-maestro y ri Ivajaf man xiq'uix tüj richin xinch'üj ri ivakün, quiri' c'a chuka' tibana' rix. Man c'a quixq'uix nich'ajila' ivakün. Quiri' c'a tibana'. ");
INSERT INTO cakENT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yin xinc'ut yan c'a can chivüch. Cachi'el c'a ri xinbün yin iviq'uin, quiri' chuka' tibana' rix quiq'uin ri ch'aka chic. ");
INSERT INTO cakENT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yin c'o-vi c'a nuk'ij y xinbün ri samaj re'. Quere' c'a chuka' tibana' rix. Man tipokonaj nibün ri samaj re'. Roma chuvüch ri ruch'ulef, man ja tüj c'a ri samajel ri más ruk'ij que chuvüch ri rajaf ri samaj, nixta c'a ri jun ri ntak, man ja tüj chuka' ri' ri más ruk'ij que chuvüch ri takayon richin. ");
INSERT INTO cakENT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Si rix xivetamaj c'a can ronojel re' y nibün c'a ri xivetamaj, jabel c'a iquicot. ");
INSERT INTO cakENT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ninbij c'a que man ivonojel tüj quiri' nyixel, roma yin vetaman ivüch chi'ivonojel ri xixincha'. Y chuka' ri tz'iban can, nc'atzinej c'a que nbanatüj na. Cachi'el ri nbij: Ri jun c'a ri xva' viq'uin, xcatüj c'a chuvij. Quiri' nbij chupan ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ri jun nojibül re', ninya' yan c'a apu rutzijol chive, nabey chuvüch tok nbanatüj, richin quiri' tok napon ruk'ijul, ninimaj c'a que ja yin ri Cristo. ");
INSERT INTO cakENT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ketzij vi c'a ninbij chive, que ri nc'ulun c'a richin ri nintük-e yin, ja yin ri nquiruc'ul. Y ri nquic'ulun c'a yin, xa nuc'ul c'a chuka' ri takayon-pe vichin. ");
INSERT INTO cakENT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Y tok ri Jesús rubin chic c'a ronojel re', ri ránima achique la xbün xuna' rija', roma ri bis. Rija' xuk'alajrisaj c'a achique roma tok juis bis pa ránima y xbij c'a: Ketzij c'a ri ninbij chive, que jun chive rix vachibila' ri nquijachon-e pa quik'a' ri vinük, xbij rija'. ");
INSERT INTO cakENT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jari' tok ri ye rachibila' rija' xquitz'etela-qui', y man nquil tüj c'a achique nquinuc, roma man quetaman tüj pari' achique chok xch'o-vi ri Jesús. Man c'a quetaman tüj achique ri nc'ayin richin. ");
INSERT INTO cakENT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jac'a ri jun cheque ri rachibila', ri juis njo'ox roma ri Jesús, xujel c'a apu riq'uin ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Y chin c'a ri jun achibil ri', ri xbün-vi-apu retal ri Simón Pedro. Rija' xbij c'a apu chin que tuc'utuj chin ri Jesús que achique c'a ri jun ri nc'ayin richin, ri c'ateri' nbij-ka cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Y ri achibil ri' tok njel c'a apu chunakaj ri Jesús, xuc'utuj c'a chin: Ajaf, ¿achique ri jun ri njachon avichin? xbij chin. ");
INSERT INTO cakENT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ri Jesús jari' tok xbij chin ri achibil ri': Ri ninya' c'a ri caxlan-vüy muban chin, jari' ri njachon vichin. Y rija' xumuba' c'a ri caxlan-vüy y xuya' chin ri Judas Iscariote ri ruc'ajol jun achi rubini'an Simón. ");
INSERT INTO cakENT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Y tok ri Judas Iscariote ruq'uison chic c'a ka ri jucach' caxlan-vüy ri', xpu'u-vi c'a ri itzel-vinük pa ránima. C'ateri' ri Jesús xbij chin: Ri anucun chic que nabün, cataken chubanic, xbij-e chin. ");
INSERT INTO cakENT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jac'a ri rachibila' ri yec'o-apu chuvüch mesa riq'uin, man xk'ax ta cheque achique roma tok xbij-e quiri' chin ri Judas. ");
INSERT INTO cakENT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yec'o xenucun que xtak-e roma ri Jesús chulok'ic ronojel ri nc'atzin cheque chupan ri nimak'ij ri'. Y yec'o ch'aka chic cheque ri achibila' xenucun que xtak-e richin c'o queruyala' can cheque ri vinük ri manak quichajin, roma rije' quetaman-vi que ja ri Judas ri yacol-tumin. ");
INSERT INTO cakENT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ri Judas xa xe c'a tok xuq'uis-e ri jucach' caxlan-vüy, xa jari' tok xel-e. Tok xel c'a e rija', xa chak'a' chic. ");
INSERT INTO cakENT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Y tok ri Judas elenük chic c'a e, c'ateri' c'a ri Jesús xbij: Jare' xka-pe yan ri k'ij que yin ri xinalüx chi'icojol nk'alajin que c'o-vi nuk'ij. Y quiri' c'a chuka' ri Dios. Nk'alajin ri ruk'ij, voma yin. ");
INSERT INTO cakENT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Y roma ri Dios nk'alajin ri ruk'ij, voma yin, rija' nbün c'a que nk'alajin ri nuk'ij yin. Y ri' man c'a jampe' tüj, xa ja yan c'a ri k'ij re'. ");
INSERT INTO cakENT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ba' chic c'a oc ri nquic'uje' iviq'uin rix ri cachi'el tak valc'ual nubanun chive. C'ateri' nquinicanoj. Pero vocomi ninbij c'a can chive, cachi'el ri nubin cheque ch'aka kavinak israelitas, que ri nquibec'uje-vi yin, man nyixtiquer tüj nyixapon chinucanoxic. ");
INSERT INTO cakENT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Xa tijo' c'a ivi' chi'ivüch. Yin nyixinjo-vi. Quiri' c'a chuka' tibana' rix. Tijo' c'a ivi' chi'ivüch. Jare' ri ninbij can chive vocomi, y jun c'ac'a' mandamiento. ");
INSERT INTO cakENT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Y si nijo' c'a ivi' chi'ivüch, ri vinük nquetamaj que rix vachibila' yin, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jari' tok ri Simón Pedro xbij chin ri Jesús: Ajaf, ¿ape' c'a ncabe-vi? xbij. Y ri Jesús xbij chin: Vocomi man jani ncatiquer tüj nquinatzeklebej ri ape' nquibe-vi yin. Jac'a tok napon ri k'ij, nquinatzeklebej-vi-e, xbij chin ri Pedro. ");
INSERT INTO cakENT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Y ri Pedro xbij chin: Ajaf, ¿achique c'a roma tok man nquitiquer tüj ncatintzeklebej-e vocomi? Roma si nc'atzin, ninya' c'a ri nuc'aslen avoma rat, xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Y ri Jesús xbij chin: ¿Naya' comi ri ac'aslen voma yin? Yin ketzij vi c'a ninbij chave, que oxi' c'a mul ri nabij que man avetaman tüj nuvüch, cheque ri nyec'utun chave. Y c'ateri' nyech'o-pe ri gallo, xbij ri Jesús chin ri Pedro. ");
INSERT INTO cakENT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Man c'a tisatz ic'u'x, xbij ri Jesús cheque ri rachibila'. Yin vetaman c'a que iyo'on ivánima riq'uin ri Dios. Quiri' c'a chuka' tibana' viq'uin yin. Tiya' c'a chuka' ivánima viq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Chila' chicaj ape' c'o-vi ri Nata', c'o c'a lugar ape' nyec'uje-vi ri nye'apon riq'uin. Si man ta ketzij que quiri', yin jun vi ta chic rubixic xinbün-apu chive. Yin vocomi nquibe chubanic ruc'ojlen ri i-lugar chila' chicaj riq'uin ri Nata'. ");
INSERT INTO cakENT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Chubanic c'a ri' tok nquibe, y nquipu'u c'a chuka' jun bey chic, y nyixinc'uaj viq'uin, richin c'a que ri ape' nquic'uje-vi yin, chiri' chuka' quixc'uje-vi rix. ");
INSERT INTO cakENT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ivetaman-vi c'a ri bey ri nuc'uan ivichin c'a ape' ri nquibe-vi yin, xbij ri Jesús cheque ri rachibila'. ");
INSERT INTO cakENT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jac'a ri rachibil ri rubini'an Tomás xbij chin ri Jesús: Ajaf, roj man ketaman tüj ape' ncabe-vi. ¿Cachi'el c'a tok nketamaj achique bey nkac'uaj-e? ");
INSERT INTO cakENT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Y ri Jesús xbij: Ja yin ri bey, yin ri ketzij, y ja yin chuka' ri c'aslen. Xaxe c'a ri nutaken vichin, napon riq'uin ri Nata'. ");
INSERT INTO cakENT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Si ivetaman c'a nuvüch yin, ivetaman c'a chuka' ruvüch ri Nata'. Vocomi itz'eton chic, y chuka' ivetaman chic ruvüch, xbij cheque. ");
INSERT INTO cakENT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Y jari' chuka' tok jun chic cheque ri achibila', ri rubini'an Felipe xbij c'a chin ri Jesús: Ajaf, tac'utu' c'a ri Katata' Dios chikavüch, y xticuker kac'u'x riq'uin ri', xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jac'a ri Jesús xbij chin: Felipe, ¿man comi avetaman tüj nuvüch? Yin, c'o yan c'a juna' yinc'o-pe iviq'uin. Ri tz'eteyon c'a vichin yin, rutz'eton c'a chuka' ri Nata'. ¿Achique c'a roma tok rat nabij que ninc'ut ri Nata' chivüch? ");
INSERT INTO cakENT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Man nanimaj tüj c'a rat que ri Nata' c'o viq'uin yin, y yin yinc'o riq'uin rija'? Ri tzij c'a ri xink'alajrisaj chivüch, riq'uin c'a ri Nata' petenük-vi, roma viq'uin yin c'o-vi. Ja rija' ri nbanun ri samaj re'. ");
INSERT INTO cakENT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Quinimaj c'a que yin yinc'o riq'uin ri Nata' y rija' c'o viq'uin yin. Y si man ninimaj tüj roma ri ninbij chive, titz'eta' c'a ri nusamaj y quinimaj. ");
INSERT INTO cakENT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ketzij vi c'a ri ninbij chive: Ri nuya' c'a ránima viq'uin, nyerubanala' c'a chuka' ri samaj xenbün yin. Más c'a nimak' tak samaj nyerubanala'. Roma jari' tok yin yinc'o chic c'a riq'uin ri Nata' chila' chicaj, ");
INSERT INTO cakENT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","y ronojel c'a ri nic'utuj pa nubi' yin, ninya-vi. Richin quiri' nk'alajin ri ruk'ij ri Nata' voma yin. ");
INSERT INTO cakENT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Si c'o c'a ri nic'utuj pa nubi' yin, ninya-vi-pe chive. ");
INSERT INTO cakENT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Si nquinijo', que'itakej c'a ri mandamientos ri nyenbij chive. ");
INSERT INTO cakENT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Y yin ninc'utuj c'a chin ri Nata', y rija' nutük c'a pe jun chic ri nto'on ivichin, Jun ri nc'uje-vi iviq'uin richin chi jumul. ");
INSERT INTO cakENT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Y ri' ja ri Lok'olüj Espíritu, ri ntijon ivichin chin ri ketzij. Y rija' man ntiquer tüj richin nc'ul-apu coma ri vinük ri c'a quiyo'on na cánima riq'uin ri ruch'ulef. Roma ri Lok'olüj Espíritu xa man tz'etetül tüj ni man quetaman tüj chuka' ruvüch. Jac'a rix ri itaken chic, man quiri' tüj. Rix ivetaman chic ruvüch, roma c'o chic chi'icojol. Y rija' ntoc c'a pa tak ivánima. ");
INSERT INTO cakENT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yin man nyixinmalij tüj can stape' (aunque) nquibe, man nyixc'uje' tüj can cachi'el jun meba', roma xa nquipu'u chic iviq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jac'a ri vinük ri c'a quiyo'on na cánima riq'uin ri ruch'ulef, xa ba' chic c'a oc ri yinquitz'et. Pero rix nquinitz'et-vi, roma c'o-vi nuc'aslen. Y rix nc'uje' c'a chuka' ic'aslen quere'. ");
INSERT INTO cakENT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Y chupan c'a ri k'ij ri' tok nk'alajin jabel chivüch que yin yinc'o-vi c'a riq'uin ri Nata', rix rixc'o viq'uin yin y yin iviq'uin rix. ");
INSERT INTO cakENT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ri c'o ri nutzij pa ránima y nyerutakej ronojel ri mandamientos ri nyenbij, nquirujo-vi. Y ri nquirujo' yin, njo'ox c'a roma ri Nata', y yin chuka' ninjo' y nink'alajrisaj-vi' chuvüch, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jari' tok ri Judas ri jun rachibil, pero man ja tüj ri Judas Iscariote, xuc'utuj chin ri Jesús: Ajaf, ¿achique c'a roma ri' que xaxe chikavüch roj nak'alajrisaj-vi-avi'? ¿Y achique c'a roma tok man nak'alajrisaj tüj avi' chiquivüch ri vinük ri c'a quiyo'on na cánima riq'uin ri ruch'ulef? ");
INSERT INTO cakENT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Y ri Jesús xbij chin: Ri nquirujo-vi, nbün ri nbij ri nutzij chin. Ri jun c'a ri nbanun quiri', njo'ox-vi roma ri Nata' chuka'. C'ateri' ri Nata' y yin nkupu'u riq'uin y nkabün c'a kacho pa ránima. ");
INSERT INTO cakENT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jac'a ri man nquirujo' tüj yin, man nbün tüj ri nbij ri nutzij chin. Y ri tzij ri ivac'axan viq'uin yin, man c'a vichin tüj yin. Ja ri Nata' ri takayon-pe vichin, ja rija' ri yo'on-pe ri tzij re' chuve. ");
INSERT INTO cakENT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Y ronojel c'a ri tzij re', ye nuk'alajrisan-vi-pe chivüch. ");
INSERT INTO cakENT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Y tok yin man c'a yinc'o tüj chic iviq'uin, ri Nata' nutük-pe ri Lok'olüj Espíritu richin nyixruto'. Y ja rija' ri nc'uje' iviq'uin pa nuq'uexel. Y ja chuka' rija' nyixtijon y nuc'uxla'aj ronojel ri tzij ri ye nbin can yin chive. ");
INSERT INTO cakENT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ri uxlanen ri c'o viq'uin yin, jari' ri ninya' can chive. Ri uxlanen c'a ri ninya' can yin pa tak ivánima rix ri itaken chic, man cachi'el tüj c'a oc ri uxlanen ri nquisuj ri vinük ri xa c'a quiyo'on na cánima riq'uin ri ruch'ulef. Man c'a tisatz ic'u'x, ni man chuka' tixbij-ivi'. ");
INSERT INTO cakENT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Xa ivac'axan viq'uin que nubin: Yin nquibe-vi, pero nquipu'u chic c'a iviq'uin. Y si rix juis ta nquinijo', nquicot ta ri ivánima, roma yin riq'uin c'a ri Nata' nquitzolij-vi-e. Rija' más vi c'a ruk'ij que chinuvüch yin. ");
INSERT INTO cakENT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Re' ninya' yan can rutzijol chive, richin quiri' tok napon ruk'ijul, man jun c'a achique tüj ninuc, xa ninimaj-vi ri nubin can chive. ");
INSERT INTO cakENT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Y vocomi xa man q'uiy tüj chic c'a tzij ri ninbij can chive, roma ri tiempo xa man q'uiy tüj chic. Ri itzel-vinük ri tz'amayon ri ruch'ulef xa nuk'alajrisaj yan pe ri'. Pero stape' (aunque) ja rija' ri tz'amayon ri ruch'ulef, man jun ruk'a' chuve yin. ");
INSERT INTO cakENT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ri ninbün, ja ri Nata' ri xintakon-pe chubanic, richin que ri vinük ri c'a quiyo'on na cánima riq'uin ri ruch'ulef, tiquetamaj que yin ninjo' ri Nata'. Kucatüj-e y jo', xbij. ");
INSERT INTO cakENT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Y c'ateri' ri Jesús xbij: Ja yin ri ketzij juvi' uva, y ri Nata' jari' ri nsamajin ri uva re'. ");
INSERT INTO cakENT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Roma tok juvi' uva yec'o ruk'a' ri xa man nquiya' tüj quivüch, nye'elesüs-e. Jac'a ri ruk'a' ri nquiya' quivüch, nyejosk'ix jabel, richin más utz nyevachin. Quiri' c'a chuka' yin. Ri Nata' nyerutz'et conojel ri yec'o viq'uin y nyerelesaj-e ri man nquic'uan tüj jun utzilüj c'aslen y man nyeq'uiy tüj chupan ri rutzij ri Dios y romari' man ye q'uiy tüj ch'aka chic nyetaken ri rutzij ri Dios. Jac'a ri nquic'uan jun utzilüj c'aslen y nyeq'uiy chupan ri rutzij ri Dios y romari' ye q'uiy ch'aka chic nyetaken ri rutzij ri Dios, nyeruch'ajch'ojrisaj más, richin que más nquic'uan jun utzilüj c'aslen y nyeq'uiy chupan ri rutzij ri Dios y romari' ye más ye q'uiy ch'aka chic nyetaken ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Rix ri nuk'alajrisan-vi-pe ri tzij chivüch, xixch'ajch'ojir yan c'a roma ri tzij ri'. ");
INSERT INTO cakENT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Chi jumul c'a quixc'uje' viq'uin, richin quiri' yin nquic'uje' c'a chuka' iviq'uin. Roma ri ruk'a' ri uva man nvachin tüj, si xa man tiquil tüj chuvüch ri rakün. Xa nc'atzin que jun ruk'a' uva tiquil chuvüch ri rakün, richin quiri' nvachin. Quiri' c'a chuka' rix, nc'atzin que chi jumul quixc'uje' viq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ja yin c'a ri uva, y rix ri ruk'a'. Ri chi jumul c'o viq'uin y yin riq'uin rija', nuc'uaj jun utzilüj c'aslen y nq'uiy chupan ri rutzij ri Dios y romari' ye q'uiy ch'aka chic nyetaken ri rutzij ri Dios. Roma ri xa man c'o tüj viq'uin, man jun c'a ri ntiquer nbün. ");
INSERT INTO cakENT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ri xa man nc'uje' tüj c'a viq'uin, nc'ulachij c'a cachi'el nc'ulachij ri ruk'a' uva xa man nvachin tüj. Ntelesüs-e roma man nvachin tüj, y tok chaki'j chic, rachibilan ch'aka chic nyemolotüj-pe, nyetorix pa k'ak', y chiri' nyec'at-vi. ");
INSERT INTO cakENT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Jac'a rix quixc'uje' viq'uin, y tic'uje' ri nutzij iviq'uin. Si quiri' nibün, tic'utuj c'a chin ri Dios achique ri nurayij ri ivánima, y quiri' nbanatüj. Nuya-vi-pe chive ri nic'utuj. ");
INSERT INTO cakENT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Si nic'uaj jun utzilüj c'aslen y nyixq'uiy chupan ri rutzij ri Dios y romari' ye q'uiy ch'aka chic nyetaken ri rutzij ri Dios, nk'alajin-vi que rix tzeklebey vichin. Y romari' ri nyixtz'eton, nquiya' c'a ruk'ij ri Nata'. ");
INSERT INTO cakENT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Cachi'el c'a ri Nata' nquirujo' yin, quiri' c'a chuka' yin nyixinjo' rix. Chi jumul c'a quinijo' quiri'. ");
INSERT INTO cakENT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Y nquinijo' c'a yin, si k'ij-k'ij nibün ri nyixinbij chive. Cachi'el ri nubanun yin, ninbün ri nyerubij ri Nata', y roma yin ninjo' rija', ninbün k'ij-k'ij ri nquirubij chuve. ");
INSERT INTO cakENT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Y ronojel c'a ri nubin chic chive, richin c'a que tic'uje' quicot pa tak ivánima, cachi'el ri quicot ri c'o viq'uin yin. Y tz'aküt ta c'a chuka' ri quicot nc'uje' pan ivánima. ");
INSERT INTO cakENT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Y yin ninchilabej c'a chive, que tijo' c'a ivi', cachi'el ri nyixinjo' yin. ");
INSERT INTO cakENT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Roma ri jun ri nuya-vi ri ruc'aslen pa quiq'uexel ri ruvinak, tz'aküt vi c'a ri nyerujo'. ");
INSERT INTO cakENT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Y rix rix nuvinak, si nibün ronojel ri ninbij chive que tibana'. ");
INSERT INTO cakENT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Roma yin nuvinak chic nubanun chive, roma ronojel ri ruk'alajrisan-pe ri Nata' chuve yin, xink'alajrisaj c'a chuka' chive rix. Man choj tüj rix nusamajela' ta chic. Roma jun samajel man retaman tüj achique nunuc ri ru-patrón. Yin man quiri' tüj chic nubanun chive. ");
INSERT INTO cakENT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ri xcha'on ivichin rix, ja yin, y xa man ja tüj rix ri xixcha'on vichin yin. Y yin xixincha' richin que nyixintük chubanic ri nusamaj y richin chuka' que nic'uaj utzilüj tak ic'aslen y nyixq'uiy chupan ri rutzij ri Dios y romari' ye q'uiy ch'aka chic nyetaken ri rutzij ri Dios, y re' richin ta c'a chi jumul, richin quiri' ri achique c'a ri nic'utuj chin ri Nata' pa nubi' yin, nuya-vi c'a pe chive. ");
INSERT INTO cakENT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ninchilabej c'a chive, que tijo-ivi'. ");
INSERT INTO cakENT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Y si nyixetzelüs coma ri vinük ri c'a quiyo'on na cánima riq'uin ri ruch'ulef, tika-pe c'a chi'ic'u'x que man xe tüj chive rix quiri' nquibün, xa quiri' chuka' quibanun-pe chuve yin. ");
INSERT INTO cakENT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Si rix rix junan tüj quiq'uin ri vinük ri c'a quiyo'on na cánima riq'uin ri ruch'ulef, nyixquijo' ta. Pero vocomi nyixquetzelaj, roma man rix richin ta chic ri ruch'ulef. Jac'a yin ri xinelesan-pe ivichin chiri'. ");
INSERT INTO cakENT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tika-pe chi'ic'u'x que ri samajel, man ja tüj ri' ri más ruk'ij que chuvüch ri rajaf ri samaj. Y si yin ri Ivajaf nquinetzelüs coma ri vinük y man utz tüj ri nquibün chuve, rix chuka' xa quiri' nic'ulachij. Jac'a si nquibün ri nbij ri nutzij yin, xa nquibün chuka' ri nibij rix. ");
INSERT INTO cakENT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ri man utz tüj nquibün iviq'uin, quiri' nquibün, roma man quetaman tüj ruvüch ri Dios ri takayon-pe vichin, y romari' nyixquetzelaj, roma viq'uin yin iyo'on-vi ivánima. ");
INSERT INTO cakENT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Y si man ta xtipu'u yin chuvüch ri ruch'ulef chuk'alajrisasic ri nutzij, man ta xinquetzelaj y man ta nk'alajin que ye aj-maqui'. Jac'a vocomi, roma yin xinpu'u yan chuvüch ri ruch'ulef, romari' rije' man nyetiquer tüj nquibij que man jun quimac. ");
INSERT INTO cakENT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ri nye'etzelan vichin yin, man xe tüj c'a yin ri yinquetzelaj, xa nk'alajin c'a que quiri' chuka' nquibün chin ri Nata'. ");
INSERT INTO cakENT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yin nubanalun nimak' tak samaj ri man jun banayun chiquivüch. Y rije' xquitz'et ri samaj re', pero man yin quitaken tüj. Xa yinquetzelaj y nquetzelaj chuka' ri Nata'. Y romari' man jun nbin que man ta c'o rumac. ");
INSERT INTO cakENT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ronojel c'a re', ntajin chic rubanic, roma quiri' ri tz'iban can chupan ri rutzij ri Dios ri yo'on cheque. Chupan ri rutzij ri Dios, nbij c'a: Yinquetzelaj y xa man k'alüj tüj achique roma, roma man jun numac. Quiri' nbij chupan ri rutzij ri Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Jac'a tok yin nquitzolij chic chila' riq'uin ri Nata', nquitük c'a pe ri Jun ri nto'on ivichin, y rija' nquiruk'alajrisaj-vi c'a. Y ri Jun ri' ja ri Lok'olüj Espíritu, ri ntijon ivichin chin ri ketzij. Y rija' riq'uin c'a ri Nata' npu'u-vi. ");
INSERT INTO cakENT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Y rix nquinik'alajrisaj c'a chuka', roma ja pa rutz'uquic-pe ri rixc'o-pe viq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Y ronojel c'a re', xinbij c'a chive, richin que rix nivetamaj yan can y man ta jun nbanun chive que nyixtzak. ");
INSERT INTO cakENT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nyixokotüx c'a pe chiri' pa tak jay ape' ntzijos-vi ri rutzij ri Dios. Y napon-vi c'a chuka' ri k'ij tok ri vinük nquinuc que rusamaj ri Dios nquibün rije' tok nyixquicamsaj. ");
INSERT INTO cakENT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Quere' c'a ri nyequibanala' ri vinük, roma man quetaman tüj ruvüch ri Nata' y man quetaman tüj chuka' nuvüch yin. ");
INSERT INTO cakENT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ronojel yan c'a re' ninbij can chive, richin que tok napon ri k'ij man c'a nibij tüj que yin man xinya' tüj can rutzijol chive. Pa ruq'uexel que quiri' ta ninuc, xa jari' tok nka-pe chi'ic'u'x que ketzij ri rutzijol ri nuyo'on can chive. Ronojel re' man xinya' tüj c'a rutzijol chive pa rutz'uquic-pe, roma yinc'o-vi-pe iviq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Y vocomi, jare' nquitzolij riq'uin ri takayon-pe vichin. ¿Achique c'a roma tok man jun chic chive rix vachibila' ri nc'utun ta pe chuve: C'a ape' c'a ncatapon-vi? ");
INSERT INTO cakENT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pero pa ruq'uexel que quiri' ta nic'utuj chuve, ri ivánima xa nojnük riq'uin bis, roma ri xinbij-ka chive. ");
INSERT INTO cakENT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero yin ja ri ketzij ri ninbij chive: Jabel nbün chive, si nquibe yan, roma si man ta nquibe, man nka-pe tüj ri Lok'olüj Espíritu ri nto'on-pe ivichin. Jac'a si nquibe yan, jari' nintük-pe. ");
INSERT INTO cakENT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Y tok nka-pe c'a ri Lok'olüj Espíritu, nuk'alajrisaj c'a chiquivüch ri vinük ri c'a quiyo'on na cánima riq'uin ri ruch'ulef que ye aj-maqui' vi, que c'o jun chojmilüj bey richin c'aslen, y que ri Dios nbün-vi juzgar pa quivi' ri vinük. ");
INSERT INTO cakENT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Rija' nuk'alajrisaj c'a chiquivüch ri vinük que ye aj-maqui', roma man yinquitakej tüj yin. ");
INSERT INTO cakENT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nuk'alajrisaj c'a chuka' chiquivüch ri vinük, ri chojmilüj bey richin ri c'aslen, roma yin riq'uin ri Nata' nquinapon-vi. Y jari' tok rix man nquinitz'et tüj chic. ");
INSERT INTO cakENT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Y chuka' rija' nuk'alajrisaj que ri Dios nbün-vi juzgar pa quivi' ri vinük, roma vocomi nc'atzinej chic que nban juzgar pari' ri itzel-vinük ri tz'amayon richin ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Q'uiy c'a ri man ninbij tüj chic can chive, roma c'ayuf richin nyek'ax yan ta chive y c'ayuf chuka' ri quic'uaxic. ");
INSERT INTO cakENT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Jac'a tok npu'u ri Lok'olüj Espíritu, nyixrutijoj y nyixruyukej chupan ri ketzij. Rija' man pa ruyon tüj c'a nsamüj, roma ri tzij c'a ri nuyala' chive, jari' ri ye bin-pe chin chila' chicaj. Y romari' tok rija' nyeruk'alajrisaj yan c'a chivüch ri nyebanatüj ri chivüch apu. ");
INSERT INTO cakENT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Y rija' nuya' c'a nuk'ij yin, roma ronojel c'a ri nuk'alajrisaj chivüch, pa nuvi' c'a yin y ri nusamaj. ");
INSERT INTO cakENT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ronojel c'a ri c'o riq'uin ri Nata' Dios, vichin yin chuka', y romari' tok yin xinbij yan c'a que ronojel ri nuk'alajrisaj ri Lok'olüj Espíritu chivüch, pa nuvi' c'a yin y ri nusamaj. ");
INSERT INTO cakENT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","C'o c'a ba' tok man nquinitz'et tüj chic. Pero c'a ba' c'a ri', nquinitz'et jun bey chic, y c'ateri' yin nquitzolij chic c'a chila' riq'uin ri Nata' Dios, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Y ch'aka cheque ri achibila' tok xcacaxaj ri xbij ri Jesús, xquic'utula' c'a chiquivüch. Rije' xquibij c'a: ¿Achique c'a ri xrajo' xbij cheke riq'uin ri tzij ri xerubij? Roma xbij: C'o c'a ba' tok man nquinitz'et tüj chic. Pero c'a ba' c'a ri', nquinitz'et jun bey chic, y c'ateri' yin nquitzolij chic c'a chila' riq'uin ri Nata' Dios, xbij, xquibila' ri achibila' chiquivüch. ");
INSERT INTO cakENT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ri achibila' ri' c'a nquibila' c'a chiquivüch: ¿Achique c'a nrajo' nbij ri rutzij: C'o c'a ba'? Xa man nyek'ax ta cheke ri rutzij, nquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Y ri Jesús chanin c'a xunabej que ri rachibila' c'o ri ncajo' nquic'utuj chin, romari' rija' xbij: Rix nijo' nivetamaj achique c'a ri xinbij, que c'o c'a ba' tok man nquinitz'et tüj chic, pero c'a ba' ri' nquinitz'et jun bey chic. ");
INSERT INTO cakENT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ketzij c'a ninbij chive: Rix nyixok' y nyixbison roma ri ninc'ulachij yin. Jac'a ri vinük ri c'a quiyo'on na cánima riq'uin ri ruch'ulef, nyequicot romari'. Y man riq'uin tüj c'a que c'o-vi bis pa tak ivánima, ri bis c'a ri' njalatüj. Ri bis c'a ri' xa ntoc quicot. ");
INSERT INTO cakENT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ri bis c'a ri' junan riq'uin ri k'oxon ri nuc'usaj jun ixok tok napon ruk'ijul richin nralaj jun ac'ual. Tok ri ac'ual alaxnük chic, ri te'ej ri' man c'a nka-pe tüj chic chuc'u'x achique chi k'oxomül ri xuc'usaj, roma juis nquicot ránima que xalüx chic jun ac'ual chuvüch ri ruch'ulef. ");
INSERT INTO cakENT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Quiri' c'a rix, vocomi c'o bis pa tak ivánima, pero xa nquipu'u chic iviq'uin jun bey richin nyixintz'et. Y jari' tok ntzolij chic pe ri quicot pa tak ivánima, y ri quicot ri' man jun c'a nrelesan iviq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Y chupan ri k'ij ri', man chic c'a chuve ta yin nic'utuj-vi ri nurayij ri ivánima. Pero ketzij ninbij chive, que ronojel c'a ri nic'utuj chin ri Nata' pa nubi' yin, nuya-vi c'a pe chive. ");
INSERT INTO cakENT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nixta vocomi man jun c'a ri ic'utun tüj chin ri Nata' pa nubi' yin. Tic'utuj c'a, y nic'ul. Y richin quiri' tz'aküt ta c'a ri quicot pa tak ivánima. ");
INSERT INTO cakENT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ronojel c'a ri nubin chic ka chive, c'ayuf vi richin nyek'ax chive, pero nka-pe c'a ri k'ij tok man quiri' tüj chic rubanic nquich'o iviq'uin. Xa k'alüj-k'alüj chic c'a ri rubixic ninbün chive pari' ri Nata' Dios. ");
INSERT INTO cakENT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Y chupan c'a ri k'ij ri', pa nubi' c'a yin nic'utuj-vi chin ri Nata', y rija' nuya' c'a pe chive ri nic'utuj chin. Y nuya' chive, man roma tüj que ja yin ri nquic'utun pan iq'uexel rix. Man quiri' tüj. ");
INSERT INTO cakENT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ri Nata' nuya' chuka' chive ri nic'utuj, roma nyixrujo'. Y rija' nyixrujo', roma rix nquinijo' yin y ninimaj que yin riq'uin rija' yin petenük-vi. ");
INSERT INTO cakENT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Riq'uin vi c'a ri Nata' Dios yin petenük-vi, richin xinka-pe chuvüch ri ruch'ulef. Y vocomi, riq'uin c'a chuka' rija' nquitzolij-vi, y ninya' can ri ruch'ulef, xbij ri Jesús. ");
INSERT INTO cakENT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Y ri rachibila' xquibij c'a chin: Ketzij vi que vocomi man c'ayuf tüj chic richin nyek'ax cheke ri nabij, xa ye k'alüj ri nye'abij. ");
INSERT INTO cakENT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vocomi nk'ax cheke que rat ronojel vi natz'et y ronojel vi chuka' avetaman. Man nc'atzin tüj que c'a nkac'utuj na chave richin navetamaj ri nkanuc. Y romari' roj nkanimaj-vi que riq'uin ri Dios rat petenük-vi, xquibij. ");
INSERT INTO cakENT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Y ri Jesús xbij c'a cheque ri rachibila': ¿Nquininimaj na vi vocomi? ");
INSERT INTO cakENT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Roma ketzij ninbij chive que ri jun k'ij ri' npu'u-vi, y hora chic, que nbanatüj c'a que rix xa nitaluj-e-ivi' y xa nquiniya' can nuyon yin. Pero man ta nuyon chuka' nquic'uje' can, roma ri Nata' c'o-vi viq'uin. ");
INSERT INTO cakENT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Y ronojel c'a re', nink'alajrisaj yan can chive, richin que c'o ta c'a ri uxlanen pa tak ivánima. Y ri uxlanen ri' nc'uje' pa tak ivánima, si iyo'on ivánima viq'uin. Y ninbij c'a chuka' can chive, que nivil-vi pokonül. Pero roma yin xinch'acon yan chirij ri itzel-vinük ri tz'amayon richin ri ruch'ulef, re' nbün ta c'a chive que nc'uje-e ivuchuk'a'. ");
INSERT INTO cakENT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Y tok ri Jesús rubin chic c'a ronojel re' cheque, rija' xtzu'un c'a chicaj richin nbün orar, y xbij c'a: Nata' Dios, ri nu-hora jare' xka-pe. Vocomi tabana' c'a chuve yin ri