﻿USE sofia;
DROP TABLE IF EXISTS sofia.cakCNT_vpl;
CREATE TABLE cakCNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cakCNT_vpl WRITE;
INSERT INTO cakCNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Re jun vuj re nuchop-el vave', jun vuj ri tz'ibatel-vi can ri quibi' ri rati't-rumama' ri Jesucristo. Can nik'alajin-vi c'a chi rija' can riy-rumam vi can ri rey richin ri tinamit Israel, ri xubini'aj David, y can riy-rumam can chuka' ri Abraham. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ri Abraham jari' ri xalc'ualan ri Isaac; ri Isaac xralc'ualaj ri Jacob; ri Jacob xralc'ualaj ri Judá y ch'aka' chic rach'alal. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jac'a ri Judá y ri Tamar ri rixjayil xecalc'ualaj ri Fares y ri Zara; jac'a ri Fares ri xalc'ualan ri Esrom; y ri Esrom xralc'ualaj ri Aram. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Y re Aram re' xralc'ualaj ri Aminadab; ri Aminadab xralc'ualaj ri Naasón; y ri Naasón xralc'ualaj ri Salmón. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Y re Salmón y ri Rahab ri rixjayil xcalc'ualaj ri Booz; ri Booz y ri Rut ri rixjayil xcalc'ualaj ri Obed; y ri Obed xralc'ualaj ri Isaí. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Y re Isaí re' xralc'ualaj ri rey David; y ri rey David xralc'ualaj ri Salomón riq'uin ri Betsabé ri rixjayil. Re rute' re Salomón, ja ri rixjayil can ri Urías. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Jac'a ri Salomón xralc'ualaj ri Roboam; ri Roboam xralc'ualaj ri Abías; y ri Abías xralc'ualaj ri Asa. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Y re Asa re' xralc'ualaj ri Josafat; ri Josafat xralc'ualaj ri Joram; y ri Joram xralc'ualaj ri Uzías. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Y re Uzías re' xralc'ualaj ri Jotam; ri Jotam xralc'ualaj ri Acaz; y ri Acaz xralc'ualaj ri Ezequías. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Y re Ezequías re' xralc'ualaj ri Manasés; ri Manasés xralc'ualaj ri Amón; y ri Amón xralc'ualaj ri Josías. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Y re Josías re' xralc'ualaj ri Jeconías y ch'aka' chic rach'alal. Y jari' tok ri kavinak israelitas xban chique chi xebec'oje' pa ruvach'ulef rubini'an Babilonia. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Y tok ec'o chic chiri' pa Babilonia, ri Jeconías xralc'ualaj ri Salatiel; y ri Salatiel xralc'ualaj ri Zorobabel. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Y re Zorobabel re' xralc'ualaj ri Abiud; ri Abiud xralc'ualaj ri Eliaquim; y ri Eliaquim xralc'ualaj ri Azor. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Y re Azor re' xralc'ualaj ri Sadoc; ri Sadoc xralc'ualaj ri Aquim; y ri Aquim xralc'ualaj ri Eliud. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Y re Eliud re' xralc'ualaj ri Eleazar; ri Eleazar xralc'ualaj ri Matán; ri Matán xralc'ualaj c'a jun ri xubini'aj chuka' Jacob. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Y re Jacob re' xralc'ualaj c'a ri José ri xoc rachijil ri María. Y re María re' jare' ri rute' ri Jesús ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Cajlajuj c'a sol vinek xec'oje-pe, ri nitiquir-pe riq'uin ri Abraham c'a riq'uin ri rey David. Cajlajuj chuka' sol vinek xec'oje-pe, ri nitiquir-pe riq'uin ri rey David c'a chupan ri tiempo tok ri kavinak israelitas xebec'oje' pa ruvach'ulef Babilonia. Y can que c'a chuka' ri' ri sol vinek xec'oje', ri nitiquir-pe riq'uin ri tiempo tok ri kavinak israelitas xebec'oje' pa ruvach'ulef Babilonia, c'a riq'uin ri Cristo, cajlajuj c'a chuka' sol vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Y ri alaxibel richin ri Jesucristo que c'a re' ri rubanic: Ri María ri xoc rute' ri Jesucristo, jun c'a xten ri c'utun chic roma ri José. Pero xc'ulvachitej c'a chi tok c'a man jani quic'uan ta qui', xnabetej chi ri María yava' chic richin alanic. Pero ri María quere' xuc'ulvachij roma xka' c'a ri Lok'olej Espíritu pa ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jac'a ri José ri ne'oc rachijil ri María, can jun chojmilej vinek vi; y man c'a xrajo' ta xuya' ruq'uix ri María chiquivech ri vinek, romari' xuben chi nuya' can choj queri' y man nutaluj ta na rutzijol. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Y jari' c'a ri xuch'ob-ka rija' pa ránima, chi choj queri' nuya' can. Y pa ruvaran c'a tok jun ángel richin ri Ajaf ri xutz'et rija', y xbix chire roma ri ángel ri': José, rat ri riy-rumam can ri rey David, man c'a taxibij-avi' chi yac'ule' riq'uin ri María ri ac'utun chic richin noc avixjayil, roma jac'a ri Lok'olej Espíritu ri xka' pa ruvi' y vacami petenek alanic chirij. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ri ac'ual c'a ri xtralaj ri María, ti ala', y Jesús c'a ri rubi' ri xtaya'. Y queri' ri rubi' xtaya', roma rija' xquerucol ri vinek chupan ri quimac. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ronojel c'a re' bin chic can roma jun chique ri rusamajela' ri Dios ri xc'oje' ojer can. Can achi'el c'a ri xuk'alajirisaj ri Ajaf chuvech ri samajel ri', queri' vi xbanatej. Y que c'a re' ri rubin can: ");
INSERT INTO cakCNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Titzu' na pe', chi xtic'oje' c'a jun xten ri xtipe alanic chirij, stape' man c'o ta pe achin riq'uin. Y can xtralaj na vi jun ac'ual, ti ala', ri xtubini'aj Emanuel. Re bi'aj re' can nubij c'a chi tzij chi ri Dios c'o kiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tok xc'astej c'a ri José, can xuben na vi c'a ri xbix chire roma ri ángel richin ri Ajaf. Rija' can xuq'uen na vi ri María richin xoc rixjayil. ");
INSERT INTO cakCNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ri ral c'a ri María man ralc'ual ta achin, roma rija' royoben chic alanic tok xquic'uaj-qui' riq'uin ri José. Ri ral ri María can rutzil vi ri Lok'olej Espíritu. Y tok ri José xuya' rubi' ri ac'ual, Jesús ri rubi' xuya'. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ri Jesús xalex c'a ri pa tinamit rubini'an Belén, ri tinamit ri c'o pa Judea. Tok xalex ri Jesús, jac'a ri Herodes ri rey, y jari' c'a tok jun ca'i' etamanela' chiquij ri ch'umila', xe'oka' pa Jerusalem. Re achi'a' etamanela' re', pa relebel-k'ij e petenek-vi, ");
INSERT INTO cakCNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","y xquic'utula' c'a: ¿Acuchi c'o-vi ri ac'ual alaxinek, ri qui-Rey ri israelitas? Roma roj can jac'a ri quela' pa relebel ri k'ij katz'eton-pe ri ruch'umilal, y xojpe chuya'ic ruk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tok ri rey Herodes rac'axan chic ri xquibij ri achi'a' etamanela', xsach ruc'u'x. Y can que c'a chuka' ri' xquic'ulvachij ri vinek ri aj pa tinamit Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Y ri rey Herodes xerumol c'a conojel ri principal-i' tak sacerdotes y ri achi'a' etamanela' chiquicojol ri israelitas, c'ari' c'a xuc'utuj chique chi acuchi c'a nalex-vi ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Xepe ri principal-i' tak sacerdotes y ri achi'a' etamanela' xquibij chire ri rey: Ri Cristo nalex pa tinamit Belén vave' pa Judea. Roma ri jun chique ri rusamajela' ri Dios ri xc'oje' ojer can, que c'a re' ri rutz'iban can: ");
INSERT INTO cakCNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Y rat tinamit Belén ri atc'o pa Judá, rat man can ta at co'ol ri chiquicojol ri nimalej tak tinamit ri chiri' pa Judá, roma ja ri chiri' aviq'uin rat ri xtipe-vi ri uc'uey-bey, y can xqueruyuk'uj-vi c'a ri vinek aj-Israel ri nutinamit, nicha' ri Dios, xecha-apo chire ri rey Herodes. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Y c'ari' ri rey Herodes pa ruyonil c'a xeroyoj ri achi'a' etamanela' chiquij ch'umila', y xuc'utula' na c'a jebel chique jampe' tok xquitz'et ri ruch'umilal ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Y c'ari' xerutek-el ri pa tinamit Belén y xubij-el chique: Quixbiyin c'a chila' y ticanoj ri ac'ual, y tok ivilon chic can, tiya' rutzijol chuve, richin yin yibe chuka' chuya'ic ruk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Y tok ri achi'a' e etamanela' chiquij ch'umila' cac'axan chic c'a ri ch'abel ri xerubij-el ri rey Herodes chique, xebe. Y ri ch'umil ri quitz'eton-pe rije' c'a acuchi quepe-vi, pa relebel ri k'ij, can ruc'uan c'a el quibey. Y tok xe'apon, re ch'umil re' xpa'e' pa ruvi' ri acuchi c'o-vi ri ac'ual. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Y ri achi'a' e etamanela' chiquij ri ch'umila', can xnoj-vi ri cánima che quicoten tok xquitz'et chic c'a ri ruch'umilal ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jac'a tok re achi'a' re' xe'oc-apo ri pa jay, can xquitz'et na vi c'a ri ac'ual y ri María ri rute', y can jac'ari' xquikasaj-ka-qui' c'a pan ulef richin xquiya' ruk'ij ri ac'ual. Y chuka' can xequijakala' c'a ri quiyaconabal y xquisipala' c'a can, k'anapuek, pon y mirra chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pero chique c'a re achi'a' etamanela' chiquij ri ch'umila', can xk'alajirisex c'a chiquivech ri pa cachic', chi man chic quetzolin pa quibey richin nequiya' can rutzijol chire ri rey Herodes. Y can que vi ri' xquiben ri achi'a' ri', roma xetzolin-el pa quiruvach'ulef y jun vi chic ri quibey xquic'uaj-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Y ri achi'a' ri etamanela' chiquij ri ch'umila' xetzolej. Y can jac'ari' tok jun ángel richin ri Ajaf Dios xuc'ut-ri' chuvech ri José, pa rachic'. Y re ángel re' xubij chire: Cayacatej c'a el. Tac'uaj-el ri ac'ual rachibilan ri rute' y quixanmej-el vave'. Quixbiyin c'a pan Egipto y quixc'oje' chila', y yin xtinya' rutzijol chave tok utz chic yixtzolin-pe. Roma re vacami, ri rey Herodes can xtorucanoj re ac'ual richin chi nucamisaj, xcha' ri ángel chire ri José, pa rachic'. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Y ri José can jari' tok xc'astej, xuc'uaj-el ri ac'ual y ri te'ej. Can chupan c'a ri ak'a' ri' xquichop-el bey richin yebe c'a pan Egipto. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Can chila' vi c'a pan Egipto xec'oje-vi y xetzolin pan Israel c'a tok caminek na chic ri rey Herodes. Richin queri' can nibanatej na c'a ri ruk'alajirisan can ri Ajaf Dios chuvech ri rusamajel ri xc'oje' ojer can. Ri tz'ibatel c'a can nubij: Pan Egipto c'a c'o-vi ri nuc'ajol tok xinvoyoj, cha'inek c'a can ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Y can jac'ari' tok ri rey Herodes xunabej chi ri achi'a' e etamanela' chiquij ri ch'umila' xa man xquiben ta achi'el ri rubin-el rija' chique. Y rija' xyacatej janíla royoval y xutek quicamisaxic conojel ri tak alabon ri ec'o chiri' pa tinamit Belén y ri ec'o pa tak lugar ri ec'o-pe chunakaj ri tinamit. Ri tak alabon c'a ri xutek quicamisaxic jac'a ri ca'i' quijuna' pa xulan. Roma rija' can retaman c'a can quiq'uin ri achi'a' ri e etamanela' chiquij ri ch'umila'. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Vave' can xbanatej-vi c'a achi'el ri tz'ibatel can roma ri jun rusamajel ri Dios ri xc'oje' ojer can, ri xubini'aj Jeremías: ");
INSERT INTO cakCNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Chi ri chiri' pa Ramá xac'axatej c'a ok'ej. Can c'o-vi bis. C'o c'a jun ri nujik' ok'ej. Ri' ja ri Raquel yerok'ej ri ral. Can man nic'o ta c'a ri bis chire roma ri ral xequen (xecom). Queri' ri tz'ibatel can roma ri Jeremías. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Y tok caminek chic el ri rey Herodes, can c'ari' c'a tok ri ángel richin ri Ajaf Dios xuc'ut chic ri' chuvech ri José, pa rachic', ri chiri' pan Egipto. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Y ri ángel richin ri Ajaf xubij c'a chire: Cayacatej c'a el. Tac'uaj-el ri ac'ual rachibilan ri rute' y quixtzolin c'a pa ruvach'ulef Israel. Roma ri xe'ajovan rucamic ri ac'ual ri chila', xa e manek chic. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Y ri José can xuben-vi c'a ri xbix chire pa rachic' roma ri ángel. Xuc'uaj-el ri ac'ual y ri te'ej. Can xetzolin c'a pa ruvach'ulef Israel. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero rija' roma ri xrac'axaj chi ja ri Arquelao ri ruc'ajol can ri rey Herodes, ri nik'aton tzij ri pa Judea, xuxibij-ri' chi yec'oje-ka ri chiri' pa Judea. Pero xk'alajirisex c'a chuvech ri José pa jun rachic' ri ruc'amon chi nuben, y romari' rija' can c'a pa Galilea xuc'uaj-vi ri ac'ual y ri te'ej. ");
INSERT INTO cakCNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Y xe'apon c'a ri pa tinamit rubini'an Nazaret y chiri' xec'oje-vi-ka, richin queri' can nibanatej na c'a achi'el ri tz'ibatel can coma ri rusamajela' ri Dios ri xec'oje' ojer can. Ri rusamajela' ri Dios can quitz'iban can chi ri Jesús can c'o na chi nibix nazareno chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chupan c'a ri k'ij tok ri Juan ri Bautista xuchop ruk'alajirisaxic ri ruch'abel ri Dios chiquivech ri vinek, ri chiri' pa tz'iran ruvach'ulef ri c'o pa Judea, ");
INSERT INTO cakCNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","rija' nubij c'a chique: Can titzolej c'a pe ic'u'x riq'uin ri Dios, roma xa can nakaj chic c'o-vi-pe ri k'ij richin chi yojoc pa ruk'a' rija' o chupan ri aj-chicajil ajavaren, nicha' c'a chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Can ja vi c'a ri Juan ri Bautista ri achok chij ch'ovinek-vi can ri k'alajirisey ruch'abel ri Dios ri xc'oje' ojer, ri xubini'aj Isaías. Y rija' can rutz'iban-vi c'a can y quere' ri nubij: C'o c'a jun achin ri xtic'oje' pa tz'iran ruvach'ulef, y ja rija' ri xtitzijon ri ruch'abel ri Dios chiquivech ri vinek ri xque'apon riq'uin. Y xtubila' c'a chique: Tichojmirisala' rubey ri ic'aslen, roma nakaj chic c'o-vi ri rupetebel ri Ajaf. Que c'a ri' ri tz'ibatel can. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ri rutziak c'a ri Juan ri Bautista banon riq'uin rusmal camello, y jun tz'un ri ximbel-rupan. Y ri ruvay c'a rija' ja ri sac' y ri cab ri niquiya' ri tak chicop pa tak juyu'. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Y ri vinek c'a ri ye'apon-vi riq'uin ri Juan ri Bautista, can e janíla vi e q'uiy. Ec'o c'a ri aj pa tinamit Jerusalem, ri tinamit c'o chiri' pa Judea. Y ec'o chuka' ri aj pa ch'aka' chic tinamit richin ri Judea. Y chuka' can ec'o c'a ri yepe c'a quela' chunakaj ri raken-ya' rubini'an Jordán. Can conojel c'a re vinek re' ri ye'apon riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Re vinek c'a re' yeban c'a el bautizar roma rija' ri chiri' pa raken-ya' Jordán. Can yequik'alajirisala-vi c'a ri quimac chuvech ri Juan ri Bautista. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Y tok rija' xutz'et chi can e q'uiy c'a chique ri achi'a' fariseos y e q'uiy chuka' chique ri achi'a' saduceos ri ye'apon riq'uin richin chi yeruben-el bautizar, xubij c'a chique: Ix achi'el itzel tak cumatzi', ri yixanmej chuvech ri ruc'ayeval, roma nivajo' yixcolotej chuvech ri ruc'ayeval ri xtutek-pe ri Dios, re chikavech apo. ¿Achique c'a xyo'on rutzijol chive chi quere' tibana'? ");
INSERT INTO cakCNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Rix nic'atzin c'a chi nic'ut chi can kitzij nitzolej-pe ic'u'x riq'uin ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Man c'a tich'ob-ka rix chi can xe roma ri ix riy-rumam can ri Abraham, can ta romari' xquixcolotej, man que ta ri'. Roma can ta ri Dios nrajo', rija' yeruben ta riy-rumam ri Abraham chique re abej re ye'itz'et vave'. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ri ruc'ayeval ri nuya' ri Dios nipe yan. Rija' xtuben c'a achi'el nuben jun achin ri c'o chic ri iquej pa ruk'a' richin chi yerukasaj ri che' ri xa man niquiya' ta utzilej quivech. Y ronojel c'a ri che' ri xquerukasaj, xqueruq'uek pa k'ak'. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yin, ya' vi c'a ri nincusaj richin yixinben bautizar tok nitzolej-pe ic'u'x riq'uin ri Dios. Pero c'o c'a Jun ri xtipe ri chikavech apo, ri man achi'el ta oc yin. Roma yin can man ruc'amon ta richin ninvelesaj y ninya' ri ruxajab chiraken, ri Jun ri nim ruk'ij y nim ruchuk'a'. Re Jun c'a re xtipe, can xquixruben-vi bautizar riq'uin ri Lok'olej Espíritu y riq'uin k'ak'. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Y can achi'el c'a jun achin tok nujosk'ij ri ru-trigo pan era. Rija' nic'atzin jun che' c'o ca'i' o oxi' rutza'n chire, richin queri' nuq'uek chuva-cak'ik' ri trigo ri ch'ayon chic. Ri runak' ri trigo nic'oje' can, pero ri páxa nuc'uaj-el cak'ik'. Y ja ri runak' ri ru-trigo, jari' ri nuyec, y ri páxa nuporoj. Can que c'a ri' xtuben ri Jun ri xtipe, xcha' ri Juan. Ri Jun ri xtipe c'o chic k'atbel-tzij pa ruk'a', richin nuk'et tzij pa quivi' ri vinek ri ec'o chuvech re ruvach'ulef. Ri vinek c'a ri yeniman richin, xqueruc'uaj chila' chicaj. Jac'a ri vinek ri man yeniman ta richin, xquerutek chupan ri k'ak' ri man jun bey xtichup. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Y jac'ari' tok ri Jesús xapon riq'uin ri Juan ri chiri' chuchi' ri raken-ya' Jordán. Ri Jesús, c'a pa Galilea petenek-vi. Rija' can petenek c'a richin chi niban-el bautizar roma ri Juan ri Bautista. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jac'a ri Juan man nrajo' ta nuben bautizar ri Jesús, roma nubij c'a chire: Ja ta yin ri ruc'amon chi yiban bautizar avoma rat y mani xa can ja rat ri xatoka' viq'uin yin, richin yatinben-el bautizar, xcha' ri Juan. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero ri Jesús xubij chire ri Juan ri Bautista: Roj ruc'amon c'a chi nikaben ronojel ri nubij ri Dios chike. Romari' re vacami nic'atzin c'a chi rat yinaben bautizar yin. C'ari' tok ri Juan ri Bautista xuben bautizar ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Y tok ri Jesús banon chic c'a bautizar, xbe'el-pe pa ya'. Y rija' xutz'et c'a chi ri caj xjakatej y xutz'et chuka' chi ri Lok'olej Espíritu richin ri Dios ruchapon-pe kajen pa ruvi' achi'el jun paloma. Can choj vi c'a petenek pa ruvi' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Y can c'o c'a jun ch'abel petenek chila' chicaj ri xubij: Jare' ri Nuc'ajol; can janíla ninvajo' y nucukuban nuc'u'x riq'uin, xcha' ri ch'abel ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Y jari' tok ri Jesús xban chire roma ri Lok'olej Espíritu chi xbe pa tz'iran ruvach'ulef, richin chi nitejtobex c'a roma ri itzel-vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ri Jesús can cavinek k'ij y cavinek ak'a' ri man va'inek ta; y tok e ic'ovinek chic ri k'ij ri', c'ari' xpe ruvayjal. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Y can jari' c'o-apo ri itzel-vinek richin nutejtobej ri Jesús, y xubij c'a chire: Roma rat nabij chi at Ruc'ajol ri Dios y yanum, tabana' c'a chique re abej re' chi que'oc vey. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero ri Jesús xubij chire ri itzel-vinek: Tz'ibatel can chupan ri ruch'abel ri Dios, chi ri achin nril chuka' ruc'aslen riq'uin ri ruch'abel ri Dios y man xe ta c'a riq'uin ri vey. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Y jari' tok ri itzel-vinek xuc'uaj ri Jesús c'a pa lok'olej tinamit Jerusalem, y c'a ja ri más nej benek-vi chicaj chire ri rachoch ri Dios, chiri' xberuya-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","C'ari' ri itzel-vinek xubij chire ri Jesús: Tatorij-ka-avi' pa xulan, rat ri yabin chi at Ruc'ajol ri Dios. Roma chupan ri ruch'abel ri Dios tz'ibatel can, nubij: Ri Dios can xquerutek ri ángeles aviq'uin richin yatquichajij. Xcatquili'ej pa quik'a', richin queri' man xtapajq'uij ta (xtachek'ij ta) avaken chuvech abej. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pero ri Jesús xubij chire ri itzel-vinek: Yin man ninben ta ri narayij rat, y nintejtobej ta ri Dios. Roma tz'ibatel chuka' chupan ri ruch'abel ri Dios chi man tikatejtobej ri Kajaf Dios, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Y ri itzel-vinek xuc'uaj chic c'a jun bey ri Jesús, y xuc'uaj c'a pa ruvi' jun juyu' ri janíla nej jotol chicaj y xuc'ut ronojel tinamit richin ri ruvach'ulef chuvech. Nima'k tak tinamit y janíla quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Y c'ari' ri itzel-vinek xubij c'a chire ri Jesús: Can ronojel c'a re xinc'ut chavech xtoc avichin, vi yaxuque' chinuvech y naya' nuk'ij, xcha' ri itzel-vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pero ri Jesús jari' tok xubij chire: Cabiyin quela' rat, Satanás. Yin xa can man ninben ta ri narayij rat. Roma chupan ri ruch'abel ri Dios ri tz'ibatel can, nubij: Xaxe c'a ri Kajaf Dios tikaya' ruk'ij, y xaxe chuka' rija' ri tikasamajij, xcha' ri Jesús chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Y jari' tok ri itzel-vinek xuya' can ri Jesús. Y xe'oka' ángeles riq'uin ri Jesús, y xquichop rilixic. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Y tok ri Jesús xrac'axaj chi ri Juan ri Bautista xchap y yo'on chic pa cárcel, jari' tok ri Jesús xtzolin chic pa Galilea. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ri Jesús xbec'oje' c'a pa tinamit Nazaret, y tok xuya' can ri tinamit ri', xbe c'a richin chi nec'oje' pa jun tinamit rubini'an Capernaum; jun tinamit ri c'o chuchi' jun nima-ya'. Re Capernaum re' c'o chucojol ri culef ri e quiy-quimam can ri Zabulón y ri Neftalí. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ri Jesús xapon c'a chupan ri jun tinamit ri', richin chi nibanatej ri tz'ibatel can roma ri rusamajel ri Dios, ri xubini'aj Isaías. Y rija' rutz'iban c'a can: ");
INSERT INTO cakCNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ri vinek ri ec'o pa culef can ri e riy-rumam ri Zabulón y ri ec'o ri pa culef can ri e riy-rumam ri Neftalí; ri chuchi' ri jun nimalej ya', ri c'o-apo juc'an ruchi' ri raken-ya' Jordán. Ri Galilea, ri quiyon chic vinek ri man e israelitas ta ec'o. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Can e tinamit c'a ri k'ekumatajinek ri quic'aslen, pero xapon c'a ri Nimalej Sakil quiq'uin. Y chuka' can e tinamit c'a ri pa rumujal ri camic ec'o-vi, pero xapon c'a quiq'uin ri nisakirisan quichin. Queri' ri tz'ibatel can. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Y tok ri Jesús xapon ri pa tinamit Capernaum, can jari' tok xuchop rutzijoxic ri ruch'abel ri Dios y nubij c'a chique ri vinek: Can titzolej c'a pe ic'u'x riq'uin ri Dios, roma xa can nakaj chic c'o-vi-pe ri k'ij richin chi yixoc pa ruk'a' rija' o chupan ri aj-chicajil ajavaren, xcha' ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Y jun k'ij ri Jesús tok benek chuchi' ri nima-ya' rubini'an Galilea, xerutz'et e ca'i' achi'a' cach'alal qui'. Ri ca'i' achi'a' ri', ja ri Simón ri nibix chuka' Pedro chire, rachibilan ri Andrés ri rach'alal; y can e chapoy vi quer, romari' tok yequiya-ka ri quiya'l chapbel-quer chupan ri ya'. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Y tok ri Jesús xch'on quiq'uin re chapoy tak quer re', xubij chique: Rix ca'i' chapoy tak quer, quinivojkaj c'a, y xtinc'ut chivech achique rubanic ye'ichop vinek richin yinquitzekelbej. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ri ca'i' achi'a' ri', can jari' xquiya' can ri chapoj-quer y xquitzekelbej-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","C'a juba' c'a quebiyin, tok ri Jesús xerutz'et c'a e ca'i' chic achi'a' ri cach'alal chuka' qui'. Y ri ca'i' achi'a' ri', ja ri Jacobo y ri Juan ri e ruc'ajol ri jun achin rubini'an Zebedeo. Rije' can jac'a ri pa canoa yesamej-vi riq'uin ri Zebedeo ri quitata'. Yequic'ojoj c'a ri quiya'l chapbel-quer. Y xpe c'a ri Jesús xeroyoj richin niquitzekelbej. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Y ri Jacobo y ri Juan, re e ca'i' achi'a' re', can jari' xquiya' can ri qui-canoa y ri quitata' y xquitzekelbej-el ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ri Jesús can ronojel tinamit richin ri Galilea xapoviyaj-vi, yerutijoj c'a ri vinek riq'uin ri ruch'abel ri Dios ri pa tak jay ri can richin vi niquimol-qui' richin nicac'axaj ri ruch'abel ri Dios. Y chuka' nutzijoj ri utzilej ruch'abel ri Dios ri nich'on chirij tok ri vinek xque'oc pa rajavaren o pa ruk'a' ri Dios. Yeruc'achojirisala' c'a vinek ri jalajoj chi yabilal y k'axo'n noc chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ri rutzijol ri Jesús xapon c'a pa ronojel tinamit richin ri ruvach'ulef Siria. Y ri e yava'i' xec'an-pe riq'uin ri Jesús. Yava'i' ri man junan ta ruvech yabil noc chique. Ec'o ri can k'axo'n c'a richin ri ch'aculaj ri noc chique. Ec'o ri xa itzel tak espíritu ri e oquinek quiq'uin. Ec'o c'a ri e ch'uja' y ec'o c'a chuka' ri e siquirinek. Y can conojel c'a re yava'i' re' xeruc'achojirisaj-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Y ri Jesús can xtzekelbex c'a coma janíla vinek ri aj chiri' pa tak tinamit richin ri Galilea, coma chuka' ri yepe pa tak tinamit ri ec'o pa Decápolis, ri yepe pa Jerusalem y ri aj pa ch'aka' chic tinamit ri chiri' pa Judea. Y can que c'a chuka' ri', xtzekelbex coma janíla vinek ri yepe c'a juc'an chic ruchi' ri raken-ya' Jordán. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Y tok ri Jesús xerutz'et chi e janíla vinek ri quimolon-qui' chiri', rija' xjote-el pa ruvi' ri juyu', y xtz'uye' c'a ka. Y c'ari' xquimol-apo-qui' ri rutijoxela' riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Y jari' tok ri Jesús xch'on c'a richin yerutijoj, y xubij c'a: ");
INSERT INTO cakCNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Jebel ruva-quik'ij ri meba' cánima chuvech ri Dios, roma can ye'oc-vi pa ruk'a' rija' o chupan ri aj-chicajil ajavaren. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Jebel ruva-quik'ij ri nok' cánima chuvech ri Dios, roma ri Dios xtujel ri cok'ej y xtuben chique chi can xquequicot. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Jebel ruva-quik'ij ri ch'uch'uj cánima, roma xque'ichinan c'a chupan ri ruvach'ulef richin ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Jebel ruva-quik'ij ri can ninum y nic'at cánima chirij ri chojmilej rubanic c'aslen riq'uin ri Dios, roma ri Dios xtuben c'a chique chi xtich'uch'u' ri cánima. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Jebel ruva-quik'ij ri can c'o joyovanic pa tak cánima, roma rije' can xtijoyovex chuka' quivech. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Jebel ruva-quik'ij ri ch'ajch'oj cánima chuvech ri Dios, roma rije' can xtiquitz'et ruvech rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Jebel ruva-quik'ij ri c'o cánima ri nikasan ruvi' oyoval, roma rije' xtibix chique chi e ralc'ual ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Jebel ruva-quik'ij ri niquic'ovisaj tijoj-pokonal pa quik'a' ch'aka' chic, roma can choj vi ri quic'aslen chuvech ri Dios. Can jebel vi ruva-quik'ij, roma rije' ec'o pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Y ri vinek ri yeyok', ri man nic'an ta quivech y ri nitz'uculux tzij chiquij voma yin, can jebel c'a chuka' ruva-quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Romari' rix titze'en c'a ivech y quixquicot c'a janíla, roma nim rajel-ruq'uexel ri xtic'ul chila' chicaj. Roma ri tijoj-pokonal ri nic'ovisaj rix, can que c'a chuka' ri' xquic'ovisaj ri achi'a' ri xek'alajirisan ri xbix chique roma ri Dios, ojer can; achi'a' ri xec'oje-el nabey que chivech rix. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ja rix c'a ri ratz'amil ri quic'aslen ri vinek ri ec'o chuvech re ruvach'ulef. Y vi ta re achi'el atz'an re' niq'uis ta el ri ratz'amil, ¿achique ta c'a rubanic richin queri' nitzolin ta chic pe ri ratz'amil? Xa man jun chic c'a nic'atzin-vi; xa can nic'ak c'a el, richin chi yek'ax na c'a vinek pa ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Rix can ix rusakil c'a ri quic'aslen ri vinek chuvech re ruvach'ulef y yixk'alajin jebel, achi'el nik'alajin-pe jun tinamit ri pa ruvi' jun juyu' banon-vi y man tiquirel ta richin nrevaj-ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Rix c'a ri nitzij jun k'ak', man jun bey c'a niya' ta oc chuxe' jun cajón, man que ta ri'. Ri k'ak' richin nisakirisan, nicanoj jun c'ojlibel ri nitz'uyuba-vi, richin queri' can yerusakirisaj c'a conojel ri ec'o pa jay. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Can que ta c'a ri' nuben ri ic'aslen chiquivech ri vinek; can jun ta c'a sakil. Richin queri' tok niquitz'et c'a ri utzilej tak ibanobal, ri vinek can xtiquiya' c'a ruk'ij-ruc'ojlen ri aj-chicajil Itata'. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Man c'a tich'ob chi yin xipe richin chi man jun ruk'ij ninben chire ri ley richin ri Moisés, y chuka' man tich'ob chi yin xipe richin queri' mismo ninben chique ri tz'ibatel can coma ri achi'a' ri xek'alajirisan ri ch'abel ri xbix chique roma ri Dios, chupan ri ojer can tiempo. Can man roma ta c'a ri'; yin xipe richin chi can ninben-vi ri niquibij. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Roma can kitzij ninbij chive chi ronojel ri tz'ibatel chupan ri ley, can xquebanatej-vi. Re ruvach'ulef y ri caj xa xqueq'uis. Pero ri e tz'ibatel chupan ri ley can xquebanatej-vi, y man jun ri que ta ri' xtic'oje' can. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Xabachique vinek ri man nrajo' ta nuben ri nubij chupan ri ley, stape' ta jun tzij ri achi'el xa man jun rejkalen nik'alajin y can que chuka' ri' ri nuchilabej chique ch'aka' chic vinek chi tiquibana'; ri nibanon c'a queri', xa man jun c'a oc ruk'ij ri xtic'oje' chiquicojol ri ec'o pa rajavaren o pa ruk'a' ri Dios. Jac'a ri vinek ri nibanon ronojel ri nubij chupan ri ley y can que chuka' ri' nuchilabej chique ri ch'aka' chic vinek chi tiquibana', rija' can xtic'oje' c'a ruk'ij chiquicojol ri ec'o pa rajavaren o pa ruk'a' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Rix ri nivajo' yixoc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren, can nic'atzin chi ri ic'aslen más choj chuvech ri quic'aslen ri achi'a' ri e etamanela' chirij ri ley y chuvech ri quic'aslen ri achi'a' fariseos. Roma rije' niquich'ob chi choj ri quic'aslen, pero xa man que ta ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Y rix can jebel ivetaman, roma ivac'axan ri xbix chique ri kavinak ojer can, chi man quecamisan. Y xabachique c'a vinek ri nicamisan, can aj-mac vi y c'o chi nik'at tzij pa ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Jac'a yin ninbij chi stape' xaxe royoval ri nipe chire jun vinek, can nimacun-vi y tik'at tzij pa ruvi'. Chuka' ri nibin chire jun chic vinek: Manek ana'oj. Ri nibin queri', can aj-mac chuka', romari' can ruc'amon chi nuc'uex chiquivech ri achi'a' ri pa comon yek'aton tzij richin chi nik'at tzij pa ruvi'. Y jac'a ri nibin nacanic chire jun chic vinek, ri' xa can oyoben chic roma ri k'ak'. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Romari' vi rat can atc'o chic apo riq'uin ri altar richin chi naya' jun sipanic chire ri Dios y jari' tok noka' chi'ac'u'x chi rat c'o jun ri abanon chuvech jun vinek; ");
INSERT INTO cakCNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","taya' c'a can ri sipanic chiri' acuchi c'o-vi ri altar y jari' cabiyin riq'uin ri jun vinek ri', te'achojmirisaj can ri banatajinek chi'icojol. Y tok achojmirisan chic can y junan chic ivech, c'ari' c'a catzolin y taya' ri sipanic chire ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Can tachojmirisaj c'a avi' chanin riq'uin ri vinek ri yatuc'uan chuvech ri k'atoy-tzij, utz ri' xa c'ari' ichapon-el bey pa k'atbel-tzij. Roma vi xa man que ta ri' xtaben, ri sujunel chavij xcarujech pa ruk'a' ri k'atoy-tzij, y re k'atoy-tzij re' xcarujech-el pa ruk'a' ri chajiy-cárcel, y rija' xcaberutz'apej can pa cárcel. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Y can kitzij vi ninbij chire ri queri' nic'ulvachin, chi can man xtel ta c'a pe ri chiri' pa cárcel, c'a tok rutojon chic na can ri ruq'uisibel centavo richin ri ruc'as chire ri vinek ri banayon ri kajo'n chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Rix can jebel ivetaman, roma can ivac'axan ri tzij bin can ojer. Ri tzij ri' nubij: Jun achin c'ulan, man c'a tucanoj jun chic ixok. Y jun ixok c'ulan, man c'a tucanoj jun chic achin. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Jac'a yin ninbij chi chuka' ri achin ri nuya' ruvech chirij jun ixok roma nurayij; ri nibanon queri', pa ránima xa can xmacun yan c'a riq'uin ri jun ixok ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Xa roma c'a ri' vi jun runak'-avech nibanon chave chi yamacun, más ta utz navelesaj y natorij-el. Stape' ta ja ri runak'-avech más utz. Roma más utz chi xaxe jun chique ri runak'-avech nibe can y mani can ja rat yabe can pa k'ak'. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chuka' vi xa jun chique ri ak'a' nibanon chave chi yamacun, más ta utz chi nachoy y natorij-el. Stape' ta ja ri ak'a' ri más utz. Roma más utz chi xaxe jun chique ri ak'a' nibe can y mani chi can ja rat yabe can pa k'ak'. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Y chuka' ketaman chi ri ojer can xbix: Ri achin ri man chic nrajo' ta ri rixjayil y nujech-ri' riq'uin; tubana' ri vuj ri richin jachojri'il y tuya' chire ri ixok. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Jac'a yin ninbij chive: Ri achin ri nujech-ri' riq'uin ri rixjayil y xa man roma ta chi ri ixok xucanoj ta chic jun achin; ri achijlonel ri' can nuben-vi c'a chire ri rixjayil chi nimacun tok nibe chic riq'uin jun achin. Ri achin ri' can nimacun-vi, y que chuka' ri' ri jun chic achin ri nuc'uan-el ri ixok, can nimacun c'a chuka', roma ri ixok ri' xa can c'a c'o-vi ri nabey rachijil. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Y chuka' rix xa can jebel ivetaman, roma ivac'axan ri xbix chique ri kavinak ojer can, chi man tiquik'ej quitzij. Y que chuka' ri' tok niquiben jurar, man tiquik'ej quitzij. Y tok c'o ri niquisuj chire ri Ajaf chi niquiben, can tiquibana' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Jac'a yin ninbij chive: Man jun bey tiben jurar, y chuka' man tiben achi'el niquiben ri ch'aka' vinek, chi niquicusaj ri rubi' ri caj tok niquiben jurar. Rix man jun bey tiben queri', roma ja ri chila' chicaj c'o-vi ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Y man ticusaj ri rubi' ri ruvach'ulef, roma ja ri chiri' nuya-vi ri raken ri Dios. Ni man chuka' ticusaj ri rubi' ri tinamit Jerusalem, roma re tinamit re' richin ri Nimalej Rey. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Y chuka' man tiben achi'el niquiben ri ch'aka' vinek tok niquiben jurar, niquibij chi titzaq'uix ri quijolon (quivi') vi xa man kitzij ta ri niquibij. Rix man jun bey tiben queri', roma man ja ta rix ri rajaf ri ic'aslen. Ri Rajaf ri ic'aslen can ja ri Dios, y xaxe chuka' rija' ri nitiquir nijalon ri nitzu'un ri rusmal tak ivi'. Xaxe rija' nitiquir nibanon k'ek chire ri sek y nitiquir chuka' nuben sek chire ri k'ek. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Can man jun bey c'a tiben jurar. Ronojel ri nibij, can choj c'a tibij, vi kitzij ri nibij o xa man kitzij ta. Y vi xa niben jurar, can nik'alajin c'a chi c'o itzel pan ivánima. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Y rix can jebel ivetaman, roma ivac'axan ri xbix chique ri kavinak ojer can, chi ri nelesan jun runak'-ruvech jun vinek, can que c'a chuka' ri' tiban chire ri xbanon. Ri nik'ajon-el rey jun vinek, can que c'a chuka' ri' tiban chire ri xbanon. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Jac'a yin ninbij chive: Man tipaba-ivi' chuvech ri nibanon etzelal chive. Vi xa c'o c'a jun ri yixch'ayon, man c'a tiya' ruq'uexel chire. Utz c'a niya' chic ivi' pa ruk'a' jun bey. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Y vi c'o c'a jun vinek ri can nuc'uaj jun chive rix pa k'atbel-tzij roma nrajo' nrelesaj jun rutziak, can man c'a tupokonaj nuya' can chire; y pa ruvi' ri', can tuya' c'a can chuka' ri ruk'u'. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","O vi c'o c'a jun chive rix ri niban chire roma jun vinek ri nej nibe-vi chi tuc'uaj jun ejka'n c'a pa jun kilómetro, xa can riq'uin c'a quicoten tuc'uaj ri ejka'n ri xuya-el ri jun vinek chirij, y chuka' man tupokonaj nusuj-ri' chi nuc'uaj jun kilómetro más richin nuto' riq'uin ri rejka'n. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Y vi c'o c'a jun chive rix c'o nic'utux chire roma jun vinek, can tuya' c'a el chire. Y vi c'o chuka' nrajo' chi nukej-el, man jun bey c'a tuch'ob chi man nuya' ta el. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Rix jebel ivetaman, roma ivac'axan ri tzij bin can ojer. Ri tzij ri' nubij: Can ruc'amon-vi chi que'avajo' ri ch'aka'. Jac'a ri ye'etzelan avichin, can que'avetzelaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Jac'a yin ninbij chive: Can que'ivajo' c'a ri ye'etzelan ivichin; tiya' quik'ij riq'uin ri ich'abel ri ye'ajovan chi nika' ta itzel ri pan ivi'; quixoc utz quiq'uin ri xa man utz ta quina'oj iviq'uin rix; y tic'utuj ri rutzil ri Dios pa quivi' ri ye'okotan y yeyok'on ivichin. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Richin queri' can nik'alajin-vi chi rix ix ralc'ual ri aj-chicajil Itata'. Roma rija' can utz vi c'a pa quivi' conojel. Rija' can c'a chila' c'a chicaj nuben-pe chi c'o ri rusakil ri k'ij pa quivi' ri vinek e utz y pa quivi' ri vinek e itzel; can c'a chila' c'a chuka' nuben-pe chi c'o job, pa quivi' ri vinek e choj y ri man e choj ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Roma vi rix xaxe ri vinek ri ye'ajovan ivichin ri ye'ivajo', ¿can c'o cami rajel-ruq'uexel xtic'ul romari'? Roma ri queri', hasta jun vinek ri itzel ruc'aslen nitiquir nuben; nitiquir yerajo' xaxe ri ye'ajovan richin. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Y vi xaxe ri ivach'alal nik'etela' tok nik'ejela' (nik'ijala'), ¿achique ta chic c'a ri más utz yixajin chubanic? Man jun. Roma hasta ri vinek ri man quetaman ta ruvech ri Dios yetiquir niquiben queri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Rix can quixoc c'a tz'aket riq'uin ri ibanobal achi'el ri aj-chicajil Itata'. Rija' tz'akatinek riq'uin ri rubanobal. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Can tichajij c'a ivi' jebel, chi man tibananej chiquivech ri vinek chi can yixajin chubanic ri nrajo' ri Dios, roma xa man utz ta. Roma vi xa queri' xtiben, can man jun c'a rajel-ruq'uexel xtic'ul riq'uin ri aj-chicajil Itata'. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tok rix niya' limosna, man c'a tivelesaj rutzijol, can achi'el tok nik'ajan jun trompeta ri nac'axex coma conojel ri vinek. Man tiben queri'. Man tiben achi'el ri niquiben ri vinek ca'i' quipalej, can niquelesaj rutzijol pa tak bey y pa tak jay ri can nitzijox-vi ri ruch'abel ri Dios, richin chi tetamex chi utz ri ye'ajin chubanic. Can kitzij vi ninbij chi ri vinek ri yebanon queri', riq'uin ri xquic'ul quik'ij chique ri vinek, xa can xquic'ul yan c'a rajel-ruq'uexel ri quibanobal. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Y tok rix niya' limosna, man c'a titzijoj chire jun chic. Can man jun c'a nic'atzin-vi chi nretamaj ta na jun chic vinek ri yixajin chubanic. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Richin queri' ri limosna ri niya', can man jun chic c'a vinek tetaman. Pero ri aj-chicajil Itata', rija' retaman. Rija' can nutz'et ri man tz'etel ta coma ri vinek y xtuya' rajel-ruq'uexel chive. Y ri rajel-ruq'uexel ri xtuya' chive, can xtik'alajin c'a chiquivech ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Rix tok niben c'a orar, man tiben achi'el niquiben ri vinek ca'i' quipalej. Roma ri vinek ri' can janíla c'a nicajo' chi ja ri acuchi ec'o vinek, chiri' niquiben-vi orar: Ri pa tak jay ri can nitzijox-vi ruch'abel ri Dios, ri pa tak squína; xaxe richin quetz'et. Rije' e pa'el tok niquiben orar. Y can kitzij vi ninbij chive, chi ri vinek ri yebanon queri', riq'uin ri niquic'ul quik'ij chique ri vinek, xa can xquic'ul yan c'a rajel-ruq'uexel ri quibanobal. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Y tok jun c'a chive rix nuben orar, utz toc pa jay y tutz'apej ruchi' ri jay y c'ari' tich'on c'a riq'uin ri Rutata' ri c'o chila' chicaj. Y stape' man nutz'et ta ri achok iq'uin nich'on-vi, can retaman chi c'o ri nac'axan richin. Y ri nac'axan-pe richin can nutz'et-vi c'a ri man tz'etel ta coma ri vinek y nuya' rajel-ruq'uexel chire. Y ri rajel-ruq'uexel ri xtuya' chire, can xtik'alajin c'a chiquivech ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tok rix niben c'a orar, man tiben achi'el niquiben ri vinek ri man quetaman ta ruvech ri Dios. Roma chiquivech rije', xaxe roma yequiben nima'k tak oraciones y janíla ch'abel ri niquicusaj chupan, romari' tok ye'ac'axex-pe roma ri Dios; queri' niquich'ob rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tok rix niben orar, man tiben achi'el niquiben ri vinek ri man quetaman ta ruvech ri Dios. Roma ri aj-chicajil Itata' can retaman chic c'a ri achique nic'atzin chive, tok c'a man jani nic'utuj ta chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tok rix niben orar, tibana' jun oración achi'el re': Katata' Dios atc'o chila' chicaj, xtibanatej ta c'a chi conojel ta ri vinek niquiya' ta ak'ij, y man ta xtiquixolk'otij (xtiquixalk'atuj) ri lok'olej abi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Y xtoka' yan ta c'a ri k'ij tok ja rat ri yatoc ri Kak'atoy-Tzij. Y xe ta c'a ri navajo' rat chi niban re vave' chuvech re ruvach'ulef, can xe ta ri' ri nikaben, achi'el niquiben ri ec'o aviq'uin chila' chicaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Y taya' c'a chuka' ri kavay ri nic'atzin chike ronojel k'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Y can achi'el yekacuy ri vinek ri c'o niquiben chike, que ta ri' xtaben kiq'uin roj, xtacuy ta c'a ronojel ri man utz ta ri yekaben chavech. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Y man c'a taya' k'ij chi ri itzel nuben ta chike chi yojtzak pa mac. Can kojacolo' c'a chuvech. Queri' ri nikac'utuj, roma xaxe c'a rat ri atc'o pa kavi', c'o avuchuk'a', y c'o ak'ij-ac'ojlen richin jantape'. Can que vi ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Vi rix ye'icuy ri vinek ri c'o etzelal niquiben chive, ri aj-chicajil Itata' can xquixrucuy c'a chuka' rix. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Y vi xa man ye'icuy ta ri vinek ri c'o etzelal niquiben chive, chuka' ri aj-chicajil Itata' man xquixrucuy ta c'a riq'uin ri imac ri ye'ibanala' chuvech. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tok rix man yixva' ta roma niben orar, man tiben achi'el niquiben ri vinek ri ca'i' quipalej; roma xa yebison ri yetzu'un. Can e jalatajinek ri yetzu'un, richin chi tik'alajin chiquivech ri vinek chi man e va'inek ta. Y kitzij ninbij chive, chi ri yebanon queri', riq'uin ri niquic'ul quik'ij chique ri vinek, xquic'ul yan c'a ri rajel-ruq'uexel. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jac'a tok rix man yixva' ta roma niben orar, man tiben chi can nik'alajin chi man ibanon ta va'in, xa jebel tich'aja' ipalej, tiya' juba' aceite pan ivi' y jebel tijica' rusmal ivi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Richin queri', man tic'ut chiquivech ri vinek chi man ibanon ta va'in roma niben orar. Xaxe ta c'a ri aj-chicajil Itata' ri netaman; y rija' man c'a tz'etel ta. Rija' can nutz'et c'a ri man tz'etel ta coma ri vinek y xtuya' rajel-ruq'uexel chive. Re rajel-ruq'uexel re xtuya' chive, can xtik'alajin chiquivech ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mani c'a nimol ibeyomel chuvech re ruvach'ulef, roma xa c'o nichicopirisan y c'o chuka' ri pus ri niq'uison richin, y roma chuka' xa ec'o elek'oma' ri ye'elek'an y ye'elesan-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Timolo' ibeyomel ri acuchi man jun nichicopirisan ta y man jun chuka' pus ri niq'uison richin. Ri acuchi chuka' man jun elek'on ri nelek'an y nelesan-el. Can timolo' c'a ibeyomel ri chila' chicaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Roma ri ivánima can nic'oje' acuchi c'o-vi ri ibeyomel, roma jari' ri nitzekelbej-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ri runak'-avech can yec'atzin c'a chave, achi'el nic'atzin jun k'ak' richin sakil. Y vi ri runak'-avech e utz, rat atc'o pa jun sakil. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero vi ri runak'-avech man e utz ta, rat atc'o pa jun k'eku'n. Romari' vi xa nijalatej ri sakil ri ruyo'on ri Dios pan avánima, can xtek'alajin c'a pe chi pa k'eku'n atc'o-vi. Y ri k'eku'n ri' can janíla vi nim. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Man jun c'a samajel ri e ca'i' ta rajaf y nitiquir ta nisamej quiq'uin che ca'i' pa jun bey. Roma vi nrajo' jun chique ri rajaf, nretzelaj chic can ri jun. Y vi can janíla nunimaj rutzij ri jun, man nitiquir ta nuben queri' riq'uin ri jun chic. Y que c'a ri', manek modo chi c'o ta jun ri benek ránima chirij ri beyomel, y nrajo' ta chuka' nuben ri nrajo' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Y romari' tok yin ninbij chive: Man tich'ujirisaj-ivi' roma ri achique nic'atzin chive k'ij-k'ij, ri acuchi xtivil-vi ivay-ivuc'ya'; ni man tich'ob ri acuchi xtiq'uen-vi itziak. Roma vi ri Dios can xuya-pe ic'aslen chuvech re ruvach'ulef, ¿nich'ob cami rix chi rija' man ta nitiquir chuka' nuya-pe ri ivay-ivuc'ya' richin c'o ic'aslen y ri itziak richin nicuchbej-ivi'? ");
INSERT INTO cakCNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Que'itz'eta' na pe' ri aj-xic' tak chicop ri yebe pa cak'ik', rije' man yetico'n ta, y romari' manek cosecha niquelesaj juna-juna', ni manek chuka' quic'ujay richin quiyacon ta quijal. Man riq'uin ri' rije' yeva', roma ja ri aj-chicajil Itata' ri niyo'on quivay. C'a ta la' c'a rix man ta xtuya' ivay ri Dios, tok rix más ivejkalen que chiquivech ri aj-xic' tak chicop. Xa roma c'a ri' man más tich'ob ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿C'o ta cami c'a jun chive rix ri nitiquir ta nibanon chi niq'uiy chic juba', roma can nuch'ujirisaj-ri' chubanic? Man jun. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Y achique c'a roma tok nich'ujirisaj-ivi' richin nivil itziak? Ri Dios nuya' itziak. Xaxe na pe' que'itzu' ri cotz'i'j quibini'an lirio, ri ec'o pa tak juyu'. Que'itzu' tok yeq'uiy. Rije' man yesamej ta, ni man yebatz'in ta, richin queri' yequibanala' ta quitziak jebel oc. Man jun bey. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Y c'o c'a jun rey richin re Israel xc'oje' ojer can ri xubini'aj Salomón. Rija' ruyon jebel tak tziek ri xerucusaj, pero man jun bey xc'oje' ta jun rutziak achi'el titzu'un jun cotz'i'j. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ri Dios yeruvik (yeruvek) jebel ri k'ayis. Roma ri cotz'i'j jari' ri tziek ri nuya' ri Dios chique ri k'ayis ri ec'o pa juyu'. Y stape' ri k'ayis man can ta yeyaloj, roma jun k'ij jebel quibanon, jun chic k'ij yechaki'j-ka y c'ari' yec'ak pa k'ak', man riq'uin ri' ri Dios yeruvik (yeruvek) jebel. ¿Y achique c'a roma rix man icukuban ta ic'u'x riq'uin ri Dios chi nuya' ta itziak? ");
INSERT INTO cakCNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Roma c'a ri' rix man tich'ujirisaj-ivi' chucanoxic ivay-ivuc'ya' y ri itziak. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ri vinek ri niquich'ujirisaj-qui' chucanoxic quivay-cuc'ya' y ri quitziak, ja ri man quetaman ta ruvech ri Dios. Jac'a rix c'o ri Itata' chila' chicaj y retaman chic chi jare' ri nic'atzin chive. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Romari' ri ruc'amon chi niben rix ja ri can tiya-ivi' chuxe' rutzij ri Dios y titija' ik'ij chi nic'uaj jun chojmilej c'aslen chuvech, can achi'el ri nrajo' rija'. Y vi xtiben queri', ri Dios xtuya' jun ic'aslen jebel y xtuya' chuka' ri nic'atzin chive. ");
INSERT INTO cakCNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Rix man nic'atzin ta chi nich'ujirisaj-ivi' roma nich'ob yan ri achique xtuq'uen-pe ri k'ij chua'k. Ri chua'k can c'o-vi ri xtuq'uen-pe. Pero xaxe c'a ri c'o chivech ri tich'obo', roma ronojel k'ij can c'o-vi ruc'ayeval y man tiq'uen yan c'a pe ri richin chua'k, roma ri queri' xa q'uiy c'a ri nimol chivij. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Man jun bey tiben chi ye'itzu' ri vinek xaxe richin chi itzel yixch'on chiquij, richin queri' man xtiban ta queri' chive rix. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Roma vi xtiben chi ye'itzu' ri vinek xaxe richin chi itzel yixch'on chiquij, can que c'a chuka' ri' ri xtiban chive rix. Can achi'el vi c'a rubanic ri niben rix chique ri vinek, queri' chuka' xtiban chive rix. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Y rat ¿achique roma tok ja ri ti k'ayis c'o pa runak'-ruvech ri avach'alal ri natz'et chanin y man nana' ta ri che' k'atel pa runak'-avech rat? Re c'ambel-tzij re' nubij c'a chi man tikanimirisaj ri rumac jun kach'alal y nikach'utinirisaj-ka ri nimalej tak kamac roj. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Man c'a tabij chuka' chire ri avach'alal: Taya' k'ij chuve richin ninvelesaj re ti k'ayis k'atel pa runak'-avech, y rat xa can jun che' ri k'e'el pa runak'-avech. Re c'ambel-tzij re' nubij c'a chi man tabij chire jun avach'alal chi man chic camacun, tok xa can c'a ja chuka' ri naben rat. Man naya' ta ka pa cuenta ri amac. Xa ca'i' apalej. Nabey na tachojmirisaj-ka ri ac'aslen rat, c'ari' utz nato' ri avach'alal. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ri ruch'abel ri Dios y ronojel ri janíla quejkalen, ri achi'el quejkalen ri abej nibix perla chique, man que'iya' chiquivech ri vinek ri xa niquiben achi'el niquiben ri tz'i' y ri ak. Roma ri chicop ri', stape' janíla rejkalen ri nuya' jun vinek chique, rije' niquipalibela' y c'o bey yeyacatej chirij ri xyo'on chique y niquiker chi eyaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Can tic'utuj c'a ri nic'atzin chive y ri Dios xtuya-pe chive. Ticanoj y xtivil ri nivajo'. Tibana' tocar ri ruchi-jay y yixac'axex-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Roma c'a ri', vi can riq'uin ronojel ivánima nic'utuj chire ri Dios, rija' can xtuya-vi-pe chive. Vi rix can nicanoj, can xtivil-vi. Y vi rix xtiben tocar ri ruchi-jay, can xtijak-vi-pe chivech. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Achique ta c'a achin ri nitiquir nuya' jun abej pa ruk'a' ri ralc'ual, tok ri ac'ual xa jun vey ri nuc'utuj chire? ");
INSERT INTO cakCNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O nitiquir ta cami nuya' jun itzel cumetz pa ruk'a', tok ri ac'ual xa jun quer nrajo'? ");
INSERT INTO cakCNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Rix man yixtiquir ta niben queri' chique ri ivalc'ual. Man riq'uin chi rix man can ta utz ina'oj, pero man jun bey niya' jun cosa itzel. Rix ja ri utz tak cosas ri niya'. C'a ta la' c'a ri aj-chicajil Itata', chi man ta nuya-pe ri nic'utuj chire. Y ronojel ri nuya-pe rija', can e utz vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Rix ruyon chuka' utz tibana' quiq'uin ri vinek, roma rix man c'a nika' ta chivech chi ri vinek itzel quina'oj iviq'uin. Queri' ri tz'ibatel chupan ri ley ri richin ri Moisés, y que chuka' ri' quibin can ri xek'alajirisan ri ruch'abel ri Dios ojer can. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Chupan c'a ri ruchi-jay janíla latz', chiri' c'a quixoc-vi. Roma can nik'alajin chi nim ruvech ri ruchi-jay y ri rubey ri itzel c'aslen, ri nic'amon-pe ri camic ri richin jantape'; y e janíla c'a vinek ri ye'oc ri chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero janíla latz' ri ruchi-jay y co'ol oc ruvech ri bey ri nic'amon-pe c'aslen, y man e q'uiy ta ri ye'ilon richin. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Romari' nic'atzin nichajij-ivi' chiquivech ri yebin chi niquik'alajirisaj c'a ri bin chique roma ri Dios y xa man kitzij ta ri niquibij. Roma tok c'ari' ye'apon iviq'uin, ri c'aslen ri niquic'ut, janíla jebel, achi'el quibanic ri tak carne'l; can man jun itzel nitz'etetej chiquij. Jac'a tok nec'ulun-pe ri etzelal ri c'o pa tak cánima, xa achi'el chic quibanic ri utiva'; yequiq'uis c'a ri achok iq'uin ye'apon-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Can xtivetamaj-vi quivech, achi'el nivetamaj ruvech achique chi che' ri', xaxe riq'uin nitz'et rubanic ri ruvech ri nuya'. Tok nivachin jun k'ayis ri janíla ruq'uixal, ¿nuya' cami uva o higo? Man juba'. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Que c'a chuka' ri' ivetaman chi jun utzilej che' nuya' utzilej tak ruvech, jac'a ri man utzilej che' ta, ri ruvech ri nuya' xa itzel chuka'. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Man jun utzilej che' xtuya' ta itzel tak ruvech, ni man jun chuka' che' ri man utz ta, xtuya' ta utzilej tak ruvech. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Y ronojel c'a che' ri man niquiya' ta utzilej tak quivech, yekasex y c'ari' yec'ak pa k'ak'. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Roma c'a ri' can xtivetamaj quivech ri vinek ri ye'apon iviq'uin, xaxe riq'uin nitz'et ri rubaniquil ri quic'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Can e q'uiy vi c'a vinek ri yebin ¡Ajaf! ¡Ajaf! chuve yin, pero man conojel ta chique rije' ri ye'oc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren. Roma ri ye'oc richin ri Dios xaxe c'a ri can riq'uin ronojel cánima niquiben ri rurayibel ri Nata' Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Y chupan c'a ri k'ij tok yin xtink'et tzij pa quivi' ri vinek, e q'uiy c'a ri xquebin chuve: ¡Ajaf! ¡Ajaf! xquecha', roj pan abi' rat xkatzijoj-vi ri ruch'abel ri Dios, pan abi' rat xekacol q'uiy vinek ri c'o itzel tak espíritu quiq'uin y pan abi' chuka' rat xekabanala' janíla q'uiy milagros, xquecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jac'a yin, jari' tok xtinbij chique ri yebin queri': Yin man jun bey xixintz'et tok xiben queri'. Can man vetaman ta c'a ivech. Man ruc'amon ta c'a chi yixc'oje' viq'uin, roma rix xa ix banoy richin ri etzelal, xquicha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Y xabachique c'a vinek ri nac'axan y nuben ri ch'abel ri c'ari' ninbij-ka, can junan c'a riq'uin ri jun novinek achin ri xupaba' jun rachoch pa ruvi' abej. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xka' c'a job, xepe raken tak ya' y cak'ik' chirij ri jun jay ri' y ri jay man xtzak ta. Roma ri ruxe' ri jun jay ri' can chupan ri abej tiquil-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Y xabachique c'a vinek ri nac'axan ri ch'abel ri c'ari' ninbij-ka, y xa man nuben ta ri ninbij chire, can junan c'a riq'uin ri jun nacanic achin ri xupaba' jun rachoch pa sanayi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xka' c'a job, xepe raken tak ya' y cak'ik' chirij ri jun jay ri' y ri jay xtzak; y xq'uis c'a chiri'. Queri' c'a ri ch'abel ri xerubij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Y tok ri Jesús xtane' chubixic re ch'abel re', ri vinek ri xe'ac'axan richin, xsach quic'u'x y achique la xquina' roma ri ch'abel ri xcac'axaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Roma ri rubanic ri rutijonic, can jun tijonic richin jun ri c'o uchuk'a' pa ruk'a' y man achi'el ta oc ri quitijonic ri achi'a' e etamanela' chirij ri ley. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Y tok ri Jesús kajinek chic c'a pe pa ruvi' ri juyu', ri vinek ri e benek chirij can e janíla e q'uiy. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Y c'o c'a jun achin yava' riq'uin ri jun yabil rubini'an lepra, xapon chuvech ri Jesús, xxuque-ka chuvech y xubij c'a chire: Ajaf, yin vetaman chi yatiquir yinac'achojirisaj chire re nuyabil, pero man vetaman ta achique nanojij pa nuvi', xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Y ri Jesús can jari' xuchop-apo ri achin yava' riq'uin ri lepra y xubij chire: Ninvajo' chi yac'achoj. Tiq'uis c'a el re yabil re' chavij, xcha' chire. Y can xe xubij quere' ri Jesús, ri achin xch'ajch'ojir chire ri ruyabil. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","C'ari' ri Jesús xubij chire ri achin ri': Ninchilabej c'a chave chi man tatzijoj chique ri vinek ri xbanatej aviq'uin, xa choj cabiyin pa rachoch ri Dios richin te'ac'utu-avi' chuvech ri sacerdote, y taya' c'a ri chicop, ri sipanic ri nubij chupan ri vuj ri rutz'iban can ri Moisés ri nic'atzin chi naya' chire ri Dios. Richin queri' nak'alajirisaj c'a chiquivech chi at ch'ajch'oj chic, xcha-el chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Y tok ri Jesús c'o chic c'a ri pa tinamit Capernaum, c'o c'a jun achin ri xapon riq'uin. Y ri achin ri' jun Capitán y xuc'utuj c'a jun utzil chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Que c'a re' ri xubij ri Capitán: Ajaf, ri achin nusamajel, siquirinek; y re yabil re' rukasan chuvech ri ruvarabel. Y janíla pokonal ri najin chuc'ovisaxic. Rija' chila' c'a pa vachoch c'o-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Xpe ri Jesús xubij chire ri Capitán: Jo' c'a y xtinc'achojirisaj ri achin yava', xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Y que c'a re' ri ch'abel ri xubij chic ri Capitán chire ri Jesús: Ajaf, yin xa in jun achin aj-mac y romari' man ruc'amon ta chave chi yatoc pa vachoch. Xaxe c'a tabij chi nic'achoj y xtic'achoj ri achin nusamajel. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yin can vetaman-vi chi queri' nibanatej, roma yin c'o jun ri nibin chuve ri c'o chi ninben. Y chuka' ec'o achi'a' e yo'on pa nuk'a'. Tok ninbij c'a chire jun achin ri c'o pa nuk'a' chi tibe, can nibe-vi; y vi ninbij chuka' chire jun chic chique ri achi'a' ri ec'o pa nuk'a' chi tipe, can nipe-vi chuka'. Y tok ninbij c'a chire ri nusamajel chi tabana' re', can nuben-vi chuka', xcha' ri Capitán. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Y ri Jesús can achique la xuna' tok rac'axan chic c'a ka ri ch'abel ri' y xubij chique ri e tzekelbeyon richin: Can kitzij ninbij chive chi ri xbin re ch'abel re', can rucukuban-vi ruc'u'x viq'uin. Y man jun c'a nuvinak israelita ri vilon ri can rucukuban ta ruc'u'x viq'uin, achi'el re jun achin re'. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Can ninbij-vi c'a chive chi janíla e q'uiy vinek ri xquepe quere' pa relebel-k'ij y quere' chuka' pa kajibel-k'ij, vinek ri quicukuban quic'u'x viq'uin. Rije' xquetz'uye' c'a riq'uin ri Abraham, ri Isaac, ri Jacob y ri ch'aka' chic ri can ec'o-vi chic pa rajavaren o pa ruk'a' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Jac'a ri vinek ri can e richin chi ye'oc ta pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren, xa man chic xque'oc ta, xa xque'elesex can y xquec'ak chupan ri k'eku'n, roma xa can man xquicukuba' ta quic'u'x viq'uin yin. Y c'a chiri' c'a xtipe ri ok'ej chique y xtiquikach'ach'ela' quey. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","C'ari' c'a ri Jesús xubij-el chire ri Capitán: Catzolin pan avachoch. Roma xanimaj chi yin yitiquir yic'achojirisan, can tibanatej c'a ri arayibel, xcha-el chire. Y ri achin ri rusamajel ri Capitán ri', can jari' xc'achoj chire ri ruyabil. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Y tok ri Jesús xapon pa rachoch ri rutijoxel rubini'an Pedro, xutz'et c'a chi ri rujite' ri Pedro cotz'ol pa ch'at y c'o jun nimalej c'aten chirij. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xpe rija' xuchop ruk'a' ri yava' y can jari' tok xq'uis-el ri nimalej c'aten chirij. Ri rujite' ri Pedro xyacatej c'a pe pa ruch'at y xuchop quilixic ri Jesús y ri e benek riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tok nocok'a' c'a pe ri k'ij ri', e q'uiy c'a ri c'o itzel tak espíritu quiq'uin xe'uc'uex-apo chuvech ri Jesús, richin chi ri Jesús yerelesaj ta el ri itzel tak espíritu quiq'uin. Y rija' xubij c'a chique ri itzel tak espíritu chi que'el-el, y xeruc'achojirisaj chuka' el conojel ri e yava'i'. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Richin queri' can nibanatej c'a ri rubin can ri Isaías, ri jun ri xk'alajirisan ri ruch'abel ri Dios ojer can. Ri Isaías que c'a re' ri rubin can chirij ri Jesús: Xerelesaj c'a el kayabilal konojel, y xuc'uaj c'a ronojel kak'axomal. Queri' ri rubin can. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Y riq'uin ri Jesús can e janíla c'a vinek ri niquimol-apo-qui'. Y tok rija' xerutz'et ri vinek ri', jari' tok xubij chique ri rutijoxela' chi tiquic'ama' yan c'a pe jun canoa roma c'o chi yebe juc'an ruchi-ya'. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Y c'o c'a jun achin etamanel chirij ri ley ri xapon-apo riq'uin ri Jesús y xubij chire: Rat can at Tijonel vi, y yin ninvajo' c'a yatintzekelbej xabacuchi ri yatapon-vi, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Xpe ri Jesús xubij chire ri etamanel ri': Ri utiva' can c'o-vi quijul acuchi yec'oje-vi; y que chuka' ri' ri aj-xic' tak chicop ri yebe pa cak'ik', can c'o chuka' quisoc. Jac'a yin ri xinalex chi'icojol, can man jun yinuxlan-vi, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jac'a chuka' ri' tok jun chic ri can tzekelel el richin ri Jesús, xubij c'a apo chire: Ajaf, yin can janíla ninvajo' chi yibe chavij. Pero taya' c'a k'ij chuve chi ninmuk na el ri nata', c'ari' xquibe chic chavij, xcha' c'a rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Xpe ri Jesús xubij chire: Rat quinatzekelbej. Xa taya' c'a can chi ri caminek yemuk coma ri e caminaki' roma ri quimac, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Y ri Jesús xoc c'a el pa jun canoa; y ri can quetzekelben-vi richin xebe chuka' chirij. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Y jac'ari' tok janíla xberubana-pe ri ya'; nisilon c'a janíla. Ri boloj ri nuben ri ya' niquevaj c'a ri canoa tok chiquicojol nic'oje-vi can. Y ri Jesús niver c'a benek. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Y xepe ri tijoxela' xquic'asoj c'a ri Jesús y xquibij chire: ¡Ajaf! ¡Ajaf! Kojato'. Vacami yojquen (yojcom), xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Xpe ri Jesús xubij chique ri rutijoxela': Can man cukul ta c'a ic'u'x viq'uin, romari' tok ixibin-ivi', xcha'. Y rija' xbeyacatej c'a pe y xubij, chi tiq'uis-el ri cak'ik' y titane-ka ri nibolko't ri ya'. Y queri' xbanatej. Ri cak'ik' xq'uis-el, y chuka' ri nibolko't ri ya' xtane-ka. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Y ri tijoxela' xsach c'a quic'u'x tok xquitz'et ri xuben ri Jesús y niquibila' c'a: ¿Achique c'a chi achin re'? Roma ri cak'ik' y ri ya' can niquinimaj chuka' rutzij. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Y tok ri Jesús y ri rutijoxela' ec'o chic c'a juc'an ruchi-ya', ri chiri' pa jun lugar rubini'an Gadara, ec'o c'a ca'i' vinek xe'apon riq'uin ri Jesús; vinek ri xa c'o itzel tak espíritu quiq'uin y ja ri camposanto ri c'o chupan ri lugar ri' ri oquinek cachoch. Man jun vinek c'a ri nitiquir noc ta quiq'uin y roma chuka' ri' man jun chic vinek nibiyin chupan ri bey ri nik'ax queri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ri ca'i' achi'a' ri', ri c'o itzel tak espíritu quiq'uin, riq'uin c'a cuchuk'a' xech'on-apo chire ri Jesús, y xquibij: Rat Jesús ri Ruc'ajol ri Dios, ¿achique c'a roma tok yojanek? ¿Achique c'a roma yojach'ujirisaj yan, tok xa man jani napon ruk'ijul? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Y quela' c'a apo juba' chire ri lugar ri', yeva' janíla e q'uiy ak. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Xepe ri itzel tak espíritu ri ec'o quiq'uin ri ca'i' achi'a', xquic'utuj utzil chire ri Jesús. Y xquibij c'a chire: Vi yojavelesaj-el vave' quiq'uin re achi'a', taya' c'a k'ij chike richin yojoc quiq'uin la ak ec'o chila', xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ri Jesús xubij c'a chique: Quixbiyin c'a. Y ri itzel tak espíritu jari' xe'el-el y xebe'oc quiq'uin ri ak. Y conojel ri ak ri' xquichop anin (anen) pa xulan, chuvech jun juyu' pa'el-pa'el, y choj xebeka' pa ya'. Xequen c'a (xecom c'a) conojel ri ak ri' ri chiri' pa ya'. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jac'a ri yeyuk'un quichin ri ak ri', xe c'a xquitz'et can ri xbanatej, xe'anmej. Xebe pa tinamit, xbequiyala' can rutzijol achique ri xquic'ulvachij ri ak y xbequibij chuka' ri xbanatej quiq'uin ri e ca'i' achi'a' ri c'o itzel tak espíritu quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Y jac'ari' tok jubama conojel vinek richin ri tinamit xepe c'a riq'uin ri Jesús, chutz'etic y chuka' richin xquic'utuj utzil chire chi tel-el ri chiri' chupan ri qui-lugar, roma rije' man nicajo' ta chi nic'oje-ka. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","C'ari' ri Jesús y ri can quetzekelben-vi richin, xquiya' can ri lugar ri'. Xe'oc-el pa canoa y xebe c'a juc'an ruchi-ya'. Y chupan ri tinamit ri can tic'oje-vi ri Jesús, chiri' xe'apon-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Y jac'ari' tok c'o jun achin siquirinek, li'an-el chuva-ruvarabel, ri xuc'uex-apo chuvech ri Jesús. Y tok ri Jesús xerutz'et chi can riq'uin ronojel quic'u'x xe'apon c'a riq'uin apo rija', xpe rija' xubij chire ri achin siquirinek: Valc'ual, xcha' chire. Tiquicot c'a avánima; ri amac xecuyutej. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Y can jac'ari' tok ec'o chique ri etamanela' chirij ri ley ri ec'o-apo chiri', xquibij-ka pa tak cánima chirij ri Jesús: Itzel achin re'. Can nuben chi ja rija' ri Dios, roma nubij chi nucuy mac. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero ri Jesús can retaman c'a ri niquich'ob pa tak cánima ri etamanela'. Y rija' xubij chique: ¿Achique c'a roma can ja ri itzel ri xich'ob chanin? ");
INSERT INTO cakCNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Roma vi yin yitiquir ninben chire re jun achin siquirinek re', richin nibiyin-el y nibe, ¿yitiquir ta cami chuka' ninbij chire chi nincuy rumac? ¿Achique nibij rix? ");
INSERT INTO cakCNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Vacami c'a, richin chi rix nivetamaj chi yin ri xinalex chi'icojol can c'o uchuk'a' pa nuk'a' richin nincuy mac, titz'eta' c'a, xcha' rija'. Y jari' tok ri Jesús xubij chire ri achin siquirinek: Ninbij c'a chave: Cayacatej, tac'uaj-el la avarabel y cabiyin chi'avachoch, xuche'ex roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Y jac'ari' tok ri achin siquirinek xyacatej-el y xbe chirachoch. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ri vinek c'a ri quimolon-apo-qui' chiri', tok xquitz'et chi ri achin siquirinek xpa'e-el, xsach quic'u'x; roma man jun bey c'a quitz'eton chi nibanatej ta queri'. Y ri vinek ri' xquiya' c'a chuka' ruk'ij-ruc'ojlen ri Dios; ri yoyon-pe ri jun nimalej uchuk'a' ri' chiquicojol ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Y tok ri Jesús benek chic c'a, xutz'et jun achin rubini'an Mateo. Ri achin ri' tz'uyul pa jun ch'aquet chiri', nuc'ul can ri alcaval ri yetoj can. Ri Jesús xubij c'a chire: Quinatzekelbej. Y jac'ari' tok rija' xbeyacatej-pe ri acuchi tz'uyul-vi y xrojkaj-el ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Y jac'a tok rija' tz'uyul pa mesa ri chiri' pa jay, e q'uiy c'a chique ri moloy tak alcaval y ch'aka' chic vinek ri aj-maqui' nibix chique, xetz'uye-apo ri pa mesa; junan riq'uin ri Jesús y ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Y ri achi'a' fariseos ri xetz'eton ri', xquibij c'a chique ri rutijoxela' ri Jesús: ¿Achique roma tok ri Jesús ri Itijonel niva' quiq'uin moloy tak alcaval y quiq'uin ri ch'aka' chic ri xa e aj-maqui'? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tok ri Jesús xrac'axaj-pe ri tzij ri niquibij ri achi'a' fariseos, rija' xubij chique: Jun ak'omanel man ja ta ri e utz ri yerak'omaj. Rija' yerak'omaj ri c'o quiyabil. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yin man xipe ta chiquicanoxic vinek ri choj quic'aslen. Yin xipe chiquicanoxic ri aj-maqui', ri nic'atzin chi nitzolej-pe quic'u'x riq'uin ri Dios. Y rix man choj queri' tibij-pe ri ch'abel nabey, xa quixbiyin c'a chutz'etic y chiretamaxic ri achique nic'ulun-vi ri nubij ri Dios: Yin más nika' chinuvech chi ja ta ri joyovanic ri c'o iviq'uin, que chuvech ri chicop ri ye'isuj chuve. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Y jac'a tok ri rutijoxela' ri Juan ri Bautista xe'oka' riq'uin ri Jesús, xquibij chire: Roj can kacha'on c'a k'ij richin man yojva' ta, richin queri' nikaben orar. Y que chuka' ri' niquiben ri quitijoxela' ri achi'a' fariseos. ¿Y achique c'a roma tok ri atijoxela' rat man que ta ri' niquiben? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Xpe ri Jesús xubij chique: ¿Achique nibij rix? ¿Ruc'amon cami chi riq'uin bis yec'oje' ri e oyon pa jun c'ulubic y man yeva' ta, tok xa c'a c'o na ri ala' c'a ruc'ulubic quiq'uin? Man ruc'amon ta. Pero xtapon ri k'ij tok re ala' re' xtelesex-el chiquicojol, y jari' tok xtiquiben chi man yeva' ta, richin niquiben orar. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Y man jun chuka' vinek nibanon chi nrelesaj ta jun c'ojobel chire jun tziek c'ac'a', y c'ari' nucusaj ta richin nuc'ojoj jun tziek ri xa ri'j chic. Roma jun c'ojobel c'ac'a' nuc'ol-ri' y nujic' ri tziek c'ojon; y ri tziek ri' más niretzetej. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Y que chuka' ri' man jun niyo'on c'ac'a' vino chupan jun tz'un c'ojlibel ri xa ucusan chic. Roma vi queri' niban, y ri tz'un xa man niyukuk ta chic, ri tz'un nibojbo' y niq'uis-el ri vino chupan. Y chuka' ri tz'un man jun chic nic'atzin-vi. Pero chupan jun c'ac'a' c'ojlibel, utz niyaque' c'ac'a' vino, roma can c'a niyukuk na jebel y man nibojbo' ta. Ri vino can niyaque' c'a jebel chupan. Queri' xubij ri Jesús chirij ri rutijonic. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Y tok ri Jesús najin c'a chutzijoxic ronojel ri', c'o c'a jun achin can janíla ruk'ij xapon y xbexuque' chuvech y c'ari' xubij: Ri numi'al c'o chic c'a pa camic, tabana' utzil te'aya' ri ak'a' pa ruvi' richin queri' xtic'ase', xcha' ri achin. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Xpe ri Jesús xyacatej c'a el y e rachibilan ri rutijoxela' xquitzekelbej-el ri achin. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Y c'o c'a jun ixok yava'. Ri ixok ri' c'o yan chic cablajuj juna' nibiyin ruquiq'uel y man tanel ta. Rija' xjel c'a apo riq'uin ri Jesús pero ja ri chirij, y xberuchapa' c'a can juba' ri ruchi-rutziak ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Roma ri ixok ri' can rubilon c'a pe pa ránima: Xa riq'uin ta ninchop-el juba' ruchi-rutziak, yic'achoj, cha'inek pa ránima. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pero ri Jesús chanin c'a xuna' y xtzu'un chirij. Y tok rutz'eton chic achique ri xchapon ruchi-rutziak, xubij c'a chire ri ixok ri': Numi'al, xacolotej, roma xacukuba' ac'u'x viq'uin. Man chic cabison, xuche'ex. Y ri ixok ri', can jac'ari' xc'achoj chire ri ruyabil. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Y tok ri Jesús noc c'a apo pa rachoch ri achin janíla ruk'ij, ri Jesús xutz'et chi yech'ujlan y ec'o chic c'a ri yexupun xul. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xpe rija' xubij: Kojiya' can juba' kayon, roma re ti xten re' xa man caminek ta, xa nuxlan, xcha' chique ri vinek. Pero rije' xa xetze'en chirij ri Jesús, roma can quetaman chi caminek chic ri ti xten ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Y jac'a tok ri vinek e elenek chic pe, ri Jesús xoc-apo chupan ri jay ri c'o-vi ri ti xten caminek chic. Xpe rija' xuchop ruk'a' ri ti xten, y ri ti xten xc'astej. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ri xbanatej c'a chiri', xbe rutzijol ri pa tak tinamit chupan ri ruvach'ulef ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Y tok ri Jesús elenek chic c'a pe ri chiri', ec'o c'a ca'i' moyi' ri can e tzeketel chirij y riq'uin cuchuk'a' niquibij c'a chire: ¡Tajoyovaj kavech y kojato' c'a, rat ri riy-rumam can ri rey David! yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tok ri Jesús xapon pa jay, ri ca'i' moyi' xe'apon c'a chuka' riq'uin. Y ri Jesús xuc'utuj c'a chique: ¿Can ninimaj c'a rix chi yin yitiquir ninben chive chi yixtzu'un? xcha' chique. Y ri ca'i' moyi' ri' xquibij: Ja', Ajaf. Nikanimaj, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Xpe ri Jesús xuchop ri runak' tak quivech che ca'i' y xubij chique: Roma rix ninimaj chi yin yitiquir yixinc'achojirisaj, can tibanatej c'a ri irayibel, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Y jari' tok ri runak' tak quivech rije' xejakatej. Y xetzu'un c'a. Pero ri Jesús janíla xuchilabej-el chique y xubij: Can tivac'axaj c'a el jebel, chi re xbanatej iviq'uin, man ta nac'axex coma ri ch'aka' chic vinek, xcha-el chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jac'a rije' xa man que ta ri' xquiben tok e elenek chic pe ri chiri' riq'uin ri Jesús. Rije' xa xquichop c'a rutzijoxic pa ronojel ri ruvach'ulef ri', ri xuben ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Y tok xe'el c'a pe ri e ca'i' achi'a' yetzu'un chic, jac'ari' tok ec'o xe'oc can riq'uin ri Jesús, quic'uan-apo jun achin ri memurinek pa ruk'a' jun itzel espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Y tok elesan chic c'a ri itzel espíritu riq'uin ri achin, roma ri Jesús, ri achin xch'on chic jun bey. Y ri vinek ri xetz'eton xsach quic'u'x y xquibij: Man jun bey c'a tz'eton ta chi que ta re' banatajinek vave' pa ruvach'ulef Israel, yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Jac'a ri achi'a' fariseos xa niquibij c'a chirij ri Jesús: Ja ri cajaval ri itzel tak espíritu ri niyo'on uchuk'a' chire, romari' tok nitiquir yerelesaj itzel tak espíritu, yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Y ri Jesús can ronojel vi c'a nima'k y cocoj tak tinamit napon-vi, y yerutijoj c'a ri vinek riq'uin ri ruch'abel ri Dios. Y jac'a ri pa tak jay ri can richin vi niquimol-qui' ri vinek, richin nicac'axaj ri ruch'abel ri Dios, chiri' napon-vi richin yerutijoj. Y chuka' can nutzijoj c'a ri utzilej ruch'abel ri Dios ri nich'on chirij tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios. Yeruc'achojirisala' chuka' yava'i', y yerucol c'a ri vinek chuvech ronojel ruvech k'axomal. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Y tok janíla e q'uiy vinek xerutz'et, xujoyovaj quivech, roma can quiyon ec'o y quitalun-qui'; can achi'el niquiben ri carne'l tok xa man jun ri niyuk'un quichin. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jac'ari' tok ri Jesús xubij chique ri rutijoxela': Can kitzij vi chi ri samaj richin nitzijox ri ruch'abel ri Dios, janíla nim; jac'a ri samajela' man e q'uiy ta. Xa e ca'i-oxi' oc. ");
INSERT INTO cakCNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Romari' tic'utuj c'a chire ri Rajaf ri samaj, chi querutaka-pe más samajela' chiquicojol ri vinek ri nic'atzin richin nicac'axaj ri ruch'abel. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Y ri Jesús xeroyoj c'a ri cablajuj rutijoxela' y xuya' uchuk'a' chique richin chi yetiquir yequelesaj ri itzel tak espíritu y richin chuka' yequic'achojirisala' ri vinek chire ri jalajoj quik'axomal y quiyabilal. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Y jac'are' ri quibi' chiquijujunal ri cablajuj achi'a' ri yetak chubanic ri samaj. Ri nabey bi'aj ja ri richin ri Simón ri nibix chuka' Pedro chire, ri Andrés ri rach'alal ri Simón. Ri Jacobo y ri Juan ri e ruc'ajol jun achin rubini'an Zebedeo. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ri Felipe, ri Bartolomé, ri Tomás, ri Mateo ri moloy-alcaval, ri Jacobo ruc'ajol jun achin rubini'an Alfeo, ri Lebeo ri nibix chuka' Tadeo chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ri Simón ri c'o quiq'uin ri achi'a' ri nibix cananista chique, y ri Judas Iscariote ri xc'ayin richin ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Y jac'a ri cablajuj achi'a' ri' ri xerutek-el ri Jesús. Xerupixabala' c'a el. Xubila' chique: Nichop c'a bey, pero man quixapon quiq'uin ri vinek ri xa man e israelitas ta. Chuka' man quixapon ri pa tak tinamit chiri' pa Samaria. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xa quiq'uin c'a ri kavinak israelitas ri man ec'o ta apo riq'uin ri Dios quixbiyin-vi. Roma rije' quibanon can achi'el niquiben ri carne'l tok niquisech can qui'. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Y jac'a tok ix benek chic, can titzijoj-vi ri ruch'abel ri Dios y tibij c'a: Nakaj chic c'o-vi-pe ri k'ij richin chi yojoc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren, quixcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Que'ic'achojirisaj c'a yava'i'. Ri c'o c'a ri yabil lepra chiquij, can tibana' c'a chique chi nich'ajch'ojir jebel ri quich'acul. Ri e caminek chic, que'ic'asoj. Can que'ivelesaj c'a chuka' ri itzel tak espíritu. Y roma c'a ronojel re uchuk'a' re' xa sipan chive rix, can que c'a chuka' ri' tibana' can rix chique ri utzil. Que'isipala' can. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Man c'a timol-el i-mero y nic'uala-el ri pa tak ruximbal-ipan. Can man jun c'a ruvech mero tic'uaj-el. Man tic'uaj-el mero ri banon riq'uin ri ch'ich' nibix cobre chire, man tic'uaj chuka' el ri banon riq'uin sakipuek, ni ri can riq'uin k'anapuek banon-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Re nichop-el bey man c'a tic'uaj-el pekes (morral). Chuka' man tic'uaj-el jun chic itziak, xa can xe ri icusan-el. Man tic'uaj jun chic c'ulaj ixajab, ni man tic'uaj chuka' ich'ame'y. Can man jun c'a ri tic'uaj. Roma ri samajel xabachique lugar napon-vi, ruc'amon chi nuc'ul ri nic'atzin chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pero tok yixapon c'a pa jun nimalej tinamit o pa jun ti tinamit, nabey na tivetamaj achique vinek ri ruc'amon chi yixapon pa rachoch. Y can chiri' c'a quixc'oje-vi-ka, y can c'a ja tok yixel na pe chupan ri tinamit ri', utz niya' can ri jay ri xixc'oje-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Y tok c'ari' c'a yixoc-apo chupan ri jay ri yixbec'oje-vi, quixk'ejelon (quixk'ijalon). ");
INSERT INTO cakCNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tibij c'a chique: Ja ta c'a ri uxlanen richin ri Dios tic'oje' pan ivi'. Y vi can ruc'amon-vi chi yixc'oje' chupan ri jay ri', ri ruxlanen ri Dios ri nirayibej pa quivi', can xtika-vi c'a pa quivi'. Xa jac'a vi man ruc'amon ta chi yixc'oje-ka chupan ri jay ri', ri ruxlanen ri Dios ri nirayibej pa quivi', can man xtika' ta pe pa quivi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Vi can man yixquic'ul ta c'a jebel, y man nicajo' ta chuka' nicac'axaj ri ruch'abel ri Dios ri nitzijoj rix chique, can quixel c'a pe chiri' quiq'uin pa cachoch o ja ri pa quitinamit. Y titotala' can (tiquirala' can) ri pokolaj ri c'o pa tak ivaken chiquivech ri vinek, richin tiquinabej chi man utz ta ri xquiben. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Roma can ninbij-vi c'a chive, chi chupan ri k'ij tok xtibanatej ri k'atoj-tzij, ri ruc'ayeval c'a ri xtika' pa quivi' ri vinek ri xec'oje' pa tinamit Sodoma y Gomorra man can ta xtic'o ruvi', que chuvech ri xtika' pa quivi' ri vinek richin ri tinamit ri man xquixquic'ul ta jebel. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Vacami yixintek c'a el, y rix ivetaman chi xa achi'el tak carne'l ri yixbeka' chiquicojol ri vinek e achi'el utiva'. Pero can tibana' c'a chi yixoc achi'el nuben ri cumetz, roma rija' nuna' tok c'o ri petenek. Can tibana' c'a chuka' chi yixoc achi'el nuben jun paloma, roma rija' man jun etzelal c'o ta riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Can tichajij c'a ivi', richin chi man choj te'iliba-ivi' pa quik'a' ri vinek ri ye'etzelan ivichin. Roma rije' xquixquijech pa quik'a' ri achi'a' ri pa comon yek'aton tzij; y chuka' ri vinek ri' xtiquiben c'a chive chi yixch'ay ri chiri' pa tak nima-jay ri niquimol-vi-qui' richin nicac'axaj ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chuka' ri vinek can xquixquic'uaj c'a chiquivech k'atoy tak tzij; chiquivech reyes y ch'aka' chic k'atoy tak tzij. Y xa voma c'a yin xtic'ulvachij queri', pero xa can xquixtiquir c'a xquinik'alajirisaj chiquivech rije' y chiquivech chuka' ri vinek man e israelitas ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero tok ri vinek xquixquijech pa quik'a' ri k'atoy tak tzij, man tich'ob janíla achique ri xtibij chique y achique rubanic ch'abel xticusaj richin yixch'on chiquivech. Roma chupan ri hora ri', ri Dios xtuya' c'a pe chive ri ruc'amon chi nibij. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Roma can jac'a ri Lok'olej Espíritu richin ri Dios ri xtibanon chive ri achique chi ch'abel ri c'o chi nibij. Man ja ta c'a rix ri xquixch'on, xa can ja ri Espíritu richin ri aj-chicajil Itata'. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Y xtibanatej c'a, chi vi ec'o e ca'i' achi'a' cach'alal qui', jun chique rije' xtiyacatej y xtujech ri rach'alal pa camic. Chuka' can ec'o-vi tata'aj ri xqueyacatej chiquij ri calc'ual. Ri alc'ualaxela' xqueyacatej chuka' chiquij ri quite-quitata' y xquequiya' pa camic. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Can conojel vi c'a xque'etzelan ivichin roma icukuban ic'u'x viq'uin. Pero ri can man c'a xtutzolij ta ri' chirij y xtucoch' c'a ri pa ruq'uisibel chire ronojel, can xticolotej-vi c'a ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Y tok ri vinek chupan jun tinamit niquichop yixquiya' pa tijoj-pokonal, utz niya' can y yixanmej c'a el chuvech ronojel re', y yixbe pa jun chic tinamit. Y ninbij c'a chive chi man jani c'a quixapon pa ronojel ri tinamit ri ec'o vave' pan Israel, tok yin ri xinalex chi'icojol yipe yan. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Y rix can xtic'ovisaj-vi c'a tijoj-pokonal pa quik'a' ri ye'etzelan ivichin. Roma can ninc'ovisaj na tijoj-pokonal yin ri Tijonel ivichin, c'a ta la' chic c'a rix. Man jun c'a tijoxel ri más ta ruk'ij que chuvech ri rutijonel. Chuka' man jun samajel ri más ta ruk'ij que chuvech ri rajaf ri samaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jac'a yin ri Tata'aj ri chi'icojol y ja rix ri ix oquinek valc'ual. Vi chuve yin can quibin Beelzebú, rix can tivoyobej c'a chi más itzel ri xquequibij chive. Pero vi xa man xtic'o ta c'a ruvi' ri xtiquiben chive, y xa achi'el ri xquiben chuve yin, queri' niquiben chive rix, ruc'amon c'a chi yixquicot rix ri nutijoxela' y nusamajela'. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Pero man c'a tixibij-ivi' chiquivech ri xquebanon queri' chive, roma xa can nic'atzin chi nik'alajirisex ivoma rix, ri man jun bey can ta k'alajirisan-pe jebel. Can nic'atzin c'a chi netamatej ri tz'apel can rij. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ronojel c'a ri ch'abel ri ninbij chive, man tic'oje' can pa k'eku'n, xa can tivelesaj c'a pe, richin chi rix niya' chuvech sakil. Ri xinbij c'a chive pa tak ixiquin, man tivevaj-ka, xa quixjote' c'a pa ruq'uisibel vik (vek) chire ri ivachoch y chiri' tiya-vi rutzijol. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Man tixibij c'a ivi' chiquivech ri xaxe oc ri ch'aculaj ri yetiquir niquicamisaj y chire ri ivánima man jun yetiquir niquiben. Ri ruc'amon chi nixibij-ivi' chuvech, ja ri chuvech ri jun ri nitiquir nuya' ri ivánima y ri ich'acul chupan ri k'ak' richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Can jebel c'a ivetaman chi tok ye'ilok' ca'i' tak aj-xic' chicop, xaxe jun centavo cajel. Y man riq'uin chi ri tak aj-xic' chicop ri' man jun oc ri cajel, man jun c'a ri xtitzak ta pan ulef vi xa man rurayibel ta ri aj-chicajil Itata'. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","C'a ta la' chic c'a rix. Roma rix hasta ri rusmal tak ivi' ajlan ronojel. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ri Dios man jun bey yixrumestaj ta can. Ri Dios janíla yixrajo'. Rix más c'a yixajovex que chiquivech ri tak aj-xic' chicop, y romari' man tixibij-ivi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Y xabachique c'a vinek ri nuk'alajirisaj-ri' chi vichin yin, yin c'a chuka' xtink'alajirisaj chi rija' vichin chic yin. Y re tzij re' chire c'a ri Nata' Dios xtinbij-vi, ri c'o chila' chicaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jac'a ri vinek ri xa man nuk'alajirisaj ta ri' chi vichin yin, yin c'a chuka' can man xtink'alajirisaj ta apo rubi' chire ri Nata' Dios ri c'o chila' chicaj, roma man vichin ta yin ri vinek ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Man c'a tich'ob chi roma xipe yin chuvech re ruvach'ulef roma ta ri' can ta c'o uxlanen quiq'uin conojel. Man que ta ri'. Xa voma yin xquejalajo' ri vinek y xtiquichapala-qui'. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yin xipe c'a chuvech re ruvach'ulef richin nitz'ucutej oyoval chiquicojol ri vinek. Queri' xtibanatej ri pa tak jay. Ri ala' xtiyacatej chirij ri rutata' roma man xtika' ta chuvech ri nubij. Ri xten xtiyacatej c'a chirij ri rute'. Y can que chuka' ri' ri alibetz (ali') xtiyacatej chirij ri ralite'. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ri xque'etzelan c'a richin jun vinek ri nucukuba' ruc'u'x viq'uin yin, can jac'a ri e aj pa rachoch. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ri vinek ri más c'a xquerajo' rute-rutata' y xa man nuben ta ri ninbij chire, can man ruc'amon ta chi noc vichin yin. Ri te'ej-tata'aj ri can más yecajo' ri calc'ual que chinuvech yin, can man ruc'amon ta chi ye'oc vichin yin. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jun vinek ri can nrajo-vi noc vichin yin, nic'atzin chi man tupokonaj nuc'ovisaj tijoj-pokonal voma yin, achi'el xa ta can benek chuxe' ru-cruz. Jac'a ri vinek ri xa nupokonaj nuc'ovisaj tijoj-pokonal voma yin y man nrajo' ta yirutzekelbej, man ruc'amon ta chi noc vichin yin. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Roma xa ja ri c'aslen richin re ruvach'ulef ri nrajo' y romari' man xtril ta ruc'aslen richin jantape'. Jac'a ri vinek ri man nupokonaj ta ri', stape' napon pa camic voma yin, can xtril-vi ruc'aslen richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ri jun c'a ri can yixruc'ul rix, can jac'a chuka' yin ri yiruc'ul; y ri nic'ulun c'a vichin yin, can nuc'ul c'a chuka' ri takayon-pe vichin. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ri vinek c'a ri can nika' chuvech ri ruch'abel ri Dios, y romari' nuc'ul ri jun ri nitzijon ch'abel ri k'alajirisan chire roma ri Dios, ri vinek ri nac'axan ri ch'abel can junan c'a rajel-ruq'uexel xtuc'ul riq'uin ri nitzijon ri ch'abel. Y que chuka' ri' ri vinek ri utz nutz'et jun c'aslen choj y romari' can quicoten nuc'ul jun vinek ri can choj vi ruc'aslen; ri nic'ulun, can junan c'a rajel-ruq'uexel xtuc'ul riq'uin ri choj ruc'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Y ri vinek c'a ri yeka' chuvech ri cocoj quik'ij, roma ja yin ri yinquitzekelbej, y romari' c'o ri nuya' chique, ri nibanon c'a queri' can c'o-vi rajel-ruq'uexel ri xtuc'ul. Y can kitzij c'a ri ninbij chive, chi stape' xa juba' raxya' ri nuya' chique, can c'o rajel-ruq'uexel xtuc'ul romari'. Queri' c'a ri ch'abel ri xerubij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Y tok xc'achoj c'a chubixic chique ri cablajuj rutijoxela' ri achique chi samaj ri nequibana', ri Jesús can man xc'oje' ta c'a can chiri'. Rija' can xbe c'a chuka' ruyon ri pa ch'aka' tinamit ri ec'o chiri' pan Israel, chuc'utic y chutzijoxic ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ri samaj c'a ri nuben ri Jesús ri Cristo xac'axex roma ri Juan ri Bautista tok c'o chiri' pa cárcel; y xpe rija' xerutek c'a el ca'i' rutijoxela' c'a riq'uin ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Y rija' xutek c'a el ruc'utuxic chire: ¿Can jac'a rat ri Cristo ri oyoben? ¿O nikoyobej chic na jun? Can que c'a ri' xbequibij ri ca'i' tijoxela' richin ri Juan ri Bautista. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Y ri Jesús xubij c'a chique ri ca'i' rutijoxela' ri Juan: Vacami quixtzolin y titzijoj chire ri xitz'et can y ri xivac'axaj-el re vave'. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Te'itzijoj chire achique rubanic tok ri moyi' yetiquir yetzu'un-el, achique rubanic tok ri vinek ri man can ta yetiquir yebiyin roma ri e jetz', yebiyin-el jebel, y achique rubanic tok ri e yava'i' riq'uin ri yabil lepra, yec'achoj. Titzijoj chuka' chire ri achique rubanic tok ri man ye'aq'uex ta, yec'achoj, ri caminaki' yec'astej, y ri vinek ri meba' cánima chuvech ri Dios, ninbij ri utzilej ch'abel richin colotajic chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Can tibij c'a chuka' chire chi jun vinek achi'el rija', ri can rucukuban ruc'u'x viq'uin y man jun bey yirumalij ta can, jebel ruva-ruk'ij. Que c'a ri' xe'uche'ex-el ri ca'i' tijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Y tok ri e ca'i' rutijoxela' ri Juan ri Bautista xebe c'a, ri Jesús xerubila' c'a utzilej tak tzij chirij ri Juan chiquivech ri vinek ec'o chiri'. Y que c'a re' ri nubij ri Jesús chique: ¿Achique ri xbe'itz'eta' rix chiri' chupan ri tz'iran ruvach'ulef? ¿Xitz'et cami rix jun achin chiri', ri achi'el aj, ri nibe quela' nibe quela' pa ruk'a' ri cak'ik'? ");
INSERT INTO cakCNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Achique c'a ri xbe'itz'eta' rix ri chiri? ¿Xitz'et cami rix jun achin ri jebel tak tziek e rucusan? Man que ta ri'. Ri achi'a' ri e cucusalon tziek queri', pa tak cachoch reyes yec'oje-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Pero achique c'a ri xbe'itz'eta' rix ri chiri' pa tz'iran ruvach'ulef? ¿Xitz'et cami jun achin ri nik'alajirisan ri bin chire roma ri Dios? Ja'. Ri achin ri xitz'et chiri' can ja vi ri' ri rusamaj. Pero can c'o c'a chuka' jun chic samaj ri yo'on pa ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Roma can chirij c'a ri Juan nich'on-vi ri Dios chupan ri ruch'abel ri tz'ibatel can, tok nubij: Yin xtintek c'a jun achin nabey, richin chi nuchojmirisaj ri bey ri xtapon-vi ri Cristo. Queri' nubij ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Y tivac'axaj c'a jebel re xtinbij chive vacami: Janipe' achi'a' ri e k'alajirisey ruch'abel ri Dios ri e alaxinek chuvech re ruvach'ulef, man jun c'a ri más ta ruk'ij que chuvech ri Juan ri Bautista. Can nim vi c'a ruk'ij rija'. Jac'a re vacami, can conojel c'a ri ye'oc pa rajavaren o pa ruk'a' ri Dios, can más c'a nima'k quik'ij. Y ri más co'ol chique rije', más nim que chuvech ri Juan. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Y chupan c'a ri k'ij tok can c'a nisamej na ri Juan ri Bautista, c'a re k'ij re', ri vinek can janíla c'a niquiben chi ye'oc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren. Can yemajon c'a qui' chirij y más niquiben ri can riq'uin c'a ronojel quic'u'x ye'apon. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Roma ri achi'a' ri xek'alajirisan ri bin chique roma ri Dios chupan ri ojer can tiempo, c'o xquibij can chirij tok ri vinek ye'oc pa ruk'a' ri Dios. Y can que c'a chuka' ri' ruk'alajirisan can ri ley richin ri Moisés. Pero can c'a ja tok c'o ri Juan xebanatej. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Vi rix ninimaj o man ninimaj ta, pero ri ninbij chive yin chi tok ri tz'ibatel can nubij chi nipe ri Elías xa chirij c'a ri Juan nich'on-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Ri c'o rac'axabal, can trac'axaj c'a ri xinbij! ");
INSERT INTO cakCNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Achok iq'uin cami e junan vi ri vinek richin re tiempo re'? Re vinek re' can e junan c'a quiq'uin ri tak ac'uala' ri yec'oje' pa tak bey y riq'uin cuchuk'a' ri yech'on chicachibil qui' tok ye'etz'an. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Y ri tak ac'uala' ri' niquibij c'a: Xojk'ojoman riq'uin xul chivech y man xixxajo' ta roma quicoten. Xkabixaj bix richin bis chivech y man xixok' ta. Queri' niquibila' ri ac'uala' pa quetz'anen. Y e queri' ri vinek richin re tiempo re', man jun ri nika' chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Roma tok xoc'ulun ri Juan ri Bautista, rija' man nutej ta caxlan-vey y man nukun ta chuka' ruya'al-uva. Y e q'uiy yebin chi rija' c'o itzel espíritu riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Y tok xinoka' yin, ri xinalex chi'icojol, nintej caxlan-vey y ninkun chuka' ruya'al-uva. Y e q'uiy yebin chi xe va'in ninvajo', y niquibij chuka' chi in jun k'abarel, chi in cachibil ri moloy tak alcaval y in cachibil chuka' ri vinek ri e aj-maqui' nibix chique. Pero ri etamabel richin ri Dios can nik'alajin pa quic'aslen ri vinek ri yeniman richin, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ec'o c'a tinamit ri xeban-vi janíla q'uiy milagros roma ri Jesús. Pero man riq'uin vi ri' ri vinek ri ec'o chupan ri tinamit ri' man xtzolin ta pe quic'u'x riq'uin ri Dios. Y romari' ri Jesús q'uiy ri xubij chiquij. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Rija' xubij c'a: Ninvok'ej c'a quivech ri ec'o pa tinamit Corazín, y ninvok'ej chuka' quivech ri ec'o pa tinamit Betsaida, roma janíla q'uiy milagros xeban chiquivech y man xquinimaj ta ri ruch'abel ri Dios. Roma xa ta ja ri pa tak tinamit Tiro y Sidón xeban-vi re milagros re', ri vinek aj chiri' xtzolej yan ta pe quic'u'x riq'uin ri Dios, y quicusalon ta chic quitziak richin bis, y quiyolon ta chaj chiquij, richin queri' nik'alajin chi yebison roma janíla ri quimac ri e quibanalon. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero tok xtapon ri k'ij chi nibanatej ri k'atoj-tzij, yin ninbij c'a chive chi ja ri ec'o pa Corazín y ri ec'o pa Betsaida ri más ruc'ayeval xtika' pa quivi', que chiquivech ri aj-Tiro y aj-Sidón. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y ri ec'o pa tinamit Capernaum can niquich'ob chi yebe chila' chicaj riq'uin ri Dios y janíla xtinimirisex quik'ij. Pero xa man que ta ri'. Xa xtikasex quik'ij, roma xa c'a chupan ri lugar ri richin tijoj-pokonal xquebeka-vi. Roma xa ta ronojel ri milagros ri xban chiquivech rije' ja ta ri' ri xban chiquivech ri aj-Sodoma, xquinimaj ta y man ta xeq'uis rachibilan ri quitinamit. Xa c'a ec'o ta na re k'ij re'. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero tok xtapon ri k'ij chi nibanatej ri k'atoj-tzij, yin ninbij c'a chive chi ja ri ec'o pa Capernaum ri más ruc'ayeval xtika' pa quivi', que chiquivech ri aj-Sodoma. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Y ja tiempo chuka' ri' tok ri Jesús xubij: Matiox ninya' chave Nata' Dios, rat ri Rajaf ri caj y re ruvach'ulef, roma man xak'alajirisaj ta ri utzilej ach'abel chiquivech ri vinek ri can niquina' chi janíla etamabel c'o quiq'uin. Xa ja ri chiquivech ri vinek ri manek más quetaman, xa chiquivech rije' xak'alajirisaj-vi re utzilej ach'abel re'. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Can que vi c'a ri' Nata' Dios, roma jari' ri arayibel rat, xcha' ri Jesús pa ru-oración. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Y c'ari' rija' xubij c'a: Ri Nata' Dios, can ronojel c'a ruyo'on-pe pa nuk'a'. Y man jun chic c'a etamayon in achique yin, xaxe ri Nata' etamayon. Y man jun chuka' etamayon achique ri' ri Nata', xaxe yin ri Ruc'ajol, y ri vinek achok che xtinvajo' xtink'alajirisaj-vi yin, xtretamaj achique c'a ri' ri Nata'. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Quixampe c'a viq'uin chi'ivonojel rix ri can janíla itijon ik'ij pan iyonil y janíla ralal ri ejka'n kajinek chivij, roma yin xtinben c'a chive chi yixuxlan chire ronojel ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Y jac'a ri nu-yugo yin tiya-el chirij ivi' rix, roma ja ri vichin yin ri más man c'ayef ta ruc'uaxic y man al ta. Quinitzu' yin, nuc'uan jun c'aslen ch'uch'uj y nuch'utinirisan-vi'. Y can queri' tibana' rix. Can tic'uaj c'a ri nu-yugo yin, richin chi ri ivánima can xtril ta uxlanen, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Y ja tiempo chuka' ri', pa jun uxlanibel-k'ij, ri Jesús y ri rutijoxela' e benek c'a pa jun ulef ri ticon ruvech riq'uin trigo. Y ri tijoxela' niquitej c'a ri ruvech ri trigo ri yequich'upula', roma xpe quivayjal. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Y ri' xtz'et c'a pe coma ri achi'a' fariseos, y xquibij c'a chire ri Jesús: Que'atzu' la atijoxela' roma man ja ta ye'ajin chubanic. Can man ruc'amon ta chi yesamej chupan jun uxlanibel-k'ij achi'el re k'ij re vacami, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero ri Jesús xubij chique: ¿Man itz'eton ta c'a rix ri tz'ibatel can chirij ri xquiben ri David y ri e rachibil, chupan ri ojer can tiempo, tok janíla xenum? ");
INSERT INTO cakCNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ri David xbe c'a chucanoxic vey chiri' pa rachoch ri Dios, y can ja ri lok'olej tak caxlan-vey ri xbejach-pe chire. Rija' y ri e rachibil xquitej c'a ri lok'olej tak caxlan-vey ri'. Man riq'uin vi ri', man mac ta ri xquiben. Y ri' xaxe ri sacerdotes c'o quik'a' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yin ninch'ob chi can isiq'uin-vi chuka' ri c'o chupan ri ley richin ri Moisés. ¿Y achique c'a roma tok ri sacerdotes can yesamej-vi pa rachoch ri Dios chupan ri uxlanibel-k'ij y rije' man mac ta niquiben? ");
INSERT INTO cakCNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ri' roma c'a ri rachoch ri Dios can c'o-vi ruk'ij. Pero re vacami, rix nitz'et c'a Jun ri más ruk'ij que chuvech ri rachoch ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Y rix man ta xixtiquir xibij chi man utz ta ri ye'ajin chubanic ri nutijoxela', xa ta ivetaman achique nic'ulun-vi chi tzij ri ruch'abel ri Dios ri nubij: Yin más nika' chinuvech chi ja ta ri joyovanic ri c'o iviq'uin, que chuvech ri chicop ri ye'isuj chuve. Queri' ri nubij ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Can jac'a yin ri xinalex chi'icojol ri Rajaf ri uxlanibel-k'ij, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Y tok ri Jesús y ri rutijoxela' xetzolin yan c'a pe, rije' xebe ri pa nima-jay ri niquimol-vi-qui' ri vinek richin nicac'axaj ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Y ri chiri' chiquicojol ri vinek ri quimolon-qui', c'o c'a jun achin chaki'j jun ruk'a'. Xepe c'a ri vinek ri' xquic'utuj chire ri Jesús: ¿Ruc'amon cami chi nic'achojirisex jun yava' pa jun uxlanibel-k'ij? Queri' c'a ri xquic'utuj chire roma nicajo' yeyacatej chirij y niquisujuj. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Xpe c'a ri Jesús xubij chique: C'o ta jun chive rix achi'a' ri c'o ta jun rucarne'l y nitzak ta pa jun jul chupan jun uxlanibel-k'ij, ¿achique ta cami nuben riq'uin? ¿Nuya' ta cami can chiri'? Man xtuben ta queri'. Xa can nuq'uen-vi c'a ka richin nrelesaj-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","C'a ta la' chic c'a jun achin chi man ta nicol, tok xa can más vi ruk'ij que chuvech jun carne'l. Xa roma c'a ri' tok can ruc'amon-vi chi niban ri utz pa jun uxlanibel-k'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Y c'ari' c'a tok ri Jesús xubij chire ri achin ri chaki'j ri ruk'a': Tayuku' la ak'a'. Y ri achin can xe xuyuk ri ruk'a', can jari' xchojmir y xoc achi'el ri jun chic ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Y ri achi'a' fariseos can xe xquitz'et can ri', xebe y xbequimolo-qui' richin niquich'ob achique niquiben, roma nicajo' niquicamisaj ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ri Jesús xel c'a el ri chiri' tok xretamaj ri niquich'ob chirij. Rija' can e janíla c'a ri vinek xetzekelben-el richin. Y yeruc'achojirisala' c'a conojel ri e yava'i'. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pero can janíla c'a nuchilabej-el chique conojel rije' chi man tiquiya' rutzijol chi rija' xeruc'achojirisaj chire ri quiyabil. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Richin queri' can nibanatej na c'a ri ruk'alajirisan can ri Dios chuvech ri rusamajel ri xc'oje' ojer can ri xubini'aj Isaías. Ri tz'ibatel c'a can nubij: ");
INSERT INTO cakCNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jac'are' c'o ri Nusamajel ri nucha'on. Yin janíla ninvajo' rija'; can niquicot-vi vánima riq'uin. Can xtinya' c'a chuka' pe ri nu-Espíritu pa ruvi'; y rija' xtuk'alajirisaj c'a chiquivech ri man quetaman ta nuvech yin, ri achique nic'atzin-vi ri c'aslen choj. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Man xtuben ta oyoval, man xtuyec ta ri ruch'abel roma royoval, ni man xtuya' ta rutzijol rija' mismo chiquivech ri vinek ri pa tak bey. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Y stape' ri ruc'aslen jun vinek achi'el ta chic jun aj ri paxnek, rija' man xtuben ta c'a chire chi nik'aj. Chuka' vi ri ruc'aslen jun vinek achi'el ta ruxak jun k'ak' ri nibukun roma nichup yan ka, rija' man xtuchup ta. Y jantape' queri' xtuben-apo, c'a tok xtapon ri k'ij chi rija' xtuben chi xtich'acon ri chojmilej k'atbel-tzij. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y ri vinek c'a ri man jani quetaman ta nuvech, riq'uin c'a rija' xticoyobej-vi ri quicolotajic. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Y c'o c'a jun moy y mem uc'uan-apo chire ri Jesús, y queri' ruc'ulvachin roma chapon c'a roma jun itzel espíritu. Y ri Jesús can xrelesaj c'a ri itzel espíritu ri'. Can xuben c'a chire chi xtzu'un y xch'on. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Y romari' tok conojel vinek can achique la xquina' tok xquitz'et y niquibila' c'a: ¿Man ja ta cami re' ri Cristo ri koyoben, ri riy-rumam ri David? ");
INSERT INTO cakCNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero tok ri achi'a' fariseos xcac'axaj ri niquibij ri vinek chirij ri Jesús, rije' xquibij c'a: Ri Jesús yerelesaj itzel tak espíritu pero xa pa rubi' ri Beelzebú ri cajaval ri itzel tak espíritu, yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Y roma ri Jesús can retaman c'a ri niquinojila' ri achi'a' fariseos, rija' xubij chique: Vi ri vinek richin jun ruvach'ulef man yenojin ta y ca'i' quivech niquiben, nipe oyoval chiquicojol. Y re' man utz ta, roma nuben chire ri quiruvach'ulef chi nitzak. Y que chuka' ri' ronojel tinamit y ronojel jay, vi xa yejalajo' chiquivech y yech'aratej, man xquepa'e' ta can. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Y vi ri Satanás yerelesaj c'a el ri can e rusamajela' vi, can nic'ulun c'a chi tzij ri' chi ruyon rija' nrokotaj-el-ri'. Xa chirij rija' mismo yacatajinek-vi. Y vi queri' nuben, ruyon nic'oje' can y chanin nitzak. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Rix can nich'ob-vi c'a chuvij yin chi pa rubi' ri Beelzebú yenvelesaj ri itzel tak espíritu, pero rix ¿achique c'a nich'ob chiquij ri yetzekelben ivichin? ¿Achique yoyon uchuk'a' chique rije' richin yetiquir yequelesaj itzel tak espíritu chuka'? Can ja vi c'a ri yetzekelben ivichin ri yek'alajirisan chi xa man utz ta ri nibij rix. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yin yitiquir c'a yenvelesaj itzel tak espíritu roma can jac'a ri ru-Espíritu ri Dios ri c'o viq'uin. Xa can xoka' yan c'a ri k'ij chi conojel ruc'amon chi niquinimaj rutzij ri Dios y yec'oje' pa rajavaren o pa ruk'a' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Y ri nrajo' c'a nelek'-el pa rachoch jun achin ri can janíla ruchuk'a', ri nabey c'o chi nuben riq'uin ri achin ri', ja ri tuxima' y c'ari' c'a tucanoj-el ronojel ri nrajo' yeruc'uaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jun c'a ri man viq'uin ta yin nisamej-vi, xa chuvij c'a yin nisamej-vi. Y achique ri man nito'on ta vichin, xa jari' ri niyojon (niyujun) ronojel ri yenben yin. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Y roma ri xbitej, yin ninbij c'a chive: Ri mac y ri itzel tak ch'abel ri yequibila' ri vinek, richin niquiyok'bej rubi' ri Dios, can c'a yecuyutej-vi. Jac'a ri ch'abel yok'bel richin ri Lok'olej Espíritu, can man xquecuyutej ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Y xabachique c'a vinek ri nibin ch'abel chuvij yin ri xinalex chi'icojol, can c'a nicuyutej na rumac. Jac'a ri nibin ch'abel chirij ri Lok'olej Espíritu, can man xticuyutej ta rumac re vacami, ni ri chikavech apo. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Roma xaxe na pe' jun che', netamex ruvech vi utz o man utz ta, xaxe riq'uin nitz'et ri ruvech ri nuya'. Man tibij chi jun che' xa man utz ta, tok ri ruvech ri yeruya' can e utz vi. Chuka' man tibij chi jun che' utz, tok ri ruvech ri yeruya' xa man e utz ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Roma c'a ri' rix ri ix achi'el itzel tak cumatzi', ¿can yixtiquir cami c'a nibij ri utz, tok xa ja ri etzelal c'o iviq'uin? Roma jun vinek can jac'a ri c'o pa ránima ri nubij. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jun utzilej vinek can chucojol c'a ri utzilej beyomel c'o pa ránima yerelesaj-pe ri yerubij. Jac'a ri vinek ri man utz ta, can chucojol c'a ri itzel beyomel c'o pa ránima yerelesaj-pe ri yerubij. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Y yin ninbij c'a chive chi chupan ri k'ij tok xtibanatej ri k'atoj-tzij, ri vinek ri xebin ch'abel ri xa man jun xec'atzin-vi, can xtik'at c'a tzij pa quivi', roma ronojel ri ch'abel ri xequibila'. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ri utz tak ch'abel ri nibij rix, can nuc'ut c'a chi man jun imac yixc'ulun chuvech ri Dios. Jac'a ri man utz tak ch'abel ta ri nibij, can nuc'ut c'a chi xtika' ruc'ayeval pan ivi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Y ec'o c'a chique ri etamanela' chirij ri ley y ec'o chuka' chique ri achi'a' fariseos xech'on-apo chire ri Jesús, y xquibij c'a: Rat ri can at jun Tijonel vi, nikac'utuj c'a chave chi tabana' jun milagro chikavech. Tac'utu-avi' chikavech chi can ja vi ri Dios ri takayon-pe avichin, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pero ri Jesús xubij c'a chique: Ri vinek richin vacami janíla e itzel y man niquinimaj ta ri Dios. Can nicajo' c'a chi yin ninben na jun milagro chiquivech richin yinquinimaj. Pero man ja ta c'a ri nicajo' rije' ri xtibanatej. Man que ta ri'. Xa can xe ri xbanatej riq'uin ri jun achin ri xubini'aj Jonás, jun achin ri xk'alajirisan ri xbix chire roma ri Dios ojer can, xaxe ri' ri retal chuka' chique rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Roma ri Jonás xc'oje' c'a pa rupan jun nimalej quer, oxi' k'ij y oxi' ak'a'. Y can que c'a chuka' ri' ri retal ninya' yin chivech. Yin c'a ri xinalex chi'icojol, xquic'oje' c'a pa ruc'u'x re ulef, oxi' k'ij y oxi' ak'a' chuka'. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Y tok xtapon c'a ri k'ij richin xtik'at tzij, xtik'at c'a chuka' tzij pa quivi' ri vinek ec'o vacami. Y xquec'astej c'a pe ri vinek aj-Nínive y xtiquibij c'a chi man utz ta xquiben re vinek re ec'o vacami, chi man xquinimaj ta. Roma ri vinek ri xec'oje' pa tinamit Nínive can xe xcac'axaj ri ruch'abel ri Dios ri xutzijoj ri Jonás chique, can jari' xtzolin-pe quic'u'x riq'uin ri Dios. Y vacami inc'o yin ri más nuk'ij chuvech ri Jonás, y xa man yinquinimaj ta ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Y tok can xtapon c'a chuka' ri k'ij richin xtik'at tzij pa quivi' ri vinek ec'o vacami, xtec'astej c'a pe ri jun reina ri aj-Sabá. Ri reina ri' xtubij c'a chi man utz ta xquiben ri vinek ri ec'o vacami, chi man xquinimaj ta. Roma tok xc'ase' ri jun reina ri', janíla nej xbiyin richin queri' xorac'axaj ri etamabel richin ri jun rey richin re Israel, ri xubini'aj Salomón. Y vacami inc'o yin ri más nuk'ij chuvech ri rey Salomón ri xc'oje' ojer can, y xa man yinquinimaj ta ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tok c'o jun itzel espíritu nel-el pa ránima jun vinek, nucanoj uxlanen pa tak lugar tz'iran-tz'iran. Pero ri itzel espíritu ri' man nril ta c'a ri uxlanen ri nucanoj. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Romari' tok rija' nuch'ob c'a: Más utz yitzolin chic pa ránima ri vinek ri xinel-vi-pe, nicha' c'a. Y tok re jun itzel espíritu re' nitzolin chic apo pa ránima ri vinek, nril c'a ri ránima ri vinek ri' achi'el jun jay ri man jun ri c'o ta chupan, y meson y chojmirisan can jebel. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Y c'ari' re itzel espíritu re' yeruq'uen c'a pe e vuku' chic itzel tak espíritu ri más e itzel, y conojel c'a re' ye'oc pa ránima ri vinek. Y ri vinek achok iq'uin yec'oje-vi re itzel tak espíritu re', más c'ayef nuben ri ruc'aslen que chuvech ri xuben nabey. Y can que c'a ri' xtiquic'ulvachij ri vinek man utz ta quic'aslen, ri ec'o vacami. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Y ri Jesús can c'a nich'on na quiq'uin ri vinek tok xapon ri rute' y ri e rach'alal. Rije' nicajo' c'a yech'on riq'uin ri Jesús, pero man xe'apon ta apo c'a riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Y c'o c'a jun ri xbin-apo chire ri Jesús: Ri ate' y ri e avach'alal at coyoben chuva-jay. Rije' nicajo' yech'on aviq'uin, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero ri Jesús xubij c'a chire ri xbin-apo queri': Ri achi'el yach'obon rat, ¿achique c'a ri nte' y e achique c'a ri vach'alal? ");
INSERT INTO cakCNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Y ri Jesús riq'uin c'a ri ruk'a' xeruc'ut ri rutijoxela' y xubij c'a: Jac'are' ri e oquinek nte' y e oquinek vach'alal. ");
INSERT INTO cakCNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Roma can conojel c'a ri yebanon ri rurayibel ri Nata' Dios ri c'o chila' chicaj, jac'ari' ri e nte', vana' y nchak', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chupan c'a ri k'ij ri' ri Jesús e rachibilan ri rutijoxela' xel-el pa jay y xbetz'uye' chuchi-ya'. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Y e janíla c'a q'uiy vinek ri xquimol-apo-qui' riq'uin. Romari' rija' xoc-apo pa jun canoa y xtz'uye-ka chiri' y nubij c'a pe ri ruch'abel ri Dios chique ri vinek. Y conojel c'a ri vinek e pa'el chuchi-ya' nicac'axaj-apo ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Rija' q'uiy c'a ri xubij chique y ruyon riq'uin c'ambel tak tzij. Y jun c'a chique ri c'ambel-tzij ri xrucusaj, jare': C'o c'a jun achin ri xbe pa jopin ija'tz. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Y tok ri achin c'o chic pa samaj, nijopin ija'tz, juba' c'a chire ri ija'tz pa bey xka-vi. Y xepe c'a ri aj-xic' tak chicop xquitej-el ri ija'tz ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Juba' chic c'a chire ri ija'tz cojol abej xka-vi y chiri' xa man q'uiy ta ri ulef c'o. Y can chanin c'a xe'el-pe roma man pin ta ri ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Xa jac'a tok xpe ruvech ri k'ij, xemayamo' y xechaki'j-ka. Roma c'a ri xa man nej ta benek-ka quixe', romari' xechaki'j-ka chanin. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Y juba' chic ija'tz xka' cojol k'ayis c'o quiq'uixal. Y tok xe'el-pe, junan xeq'uiy quiq'uin ri q'uix. Pero roma ri q'uix janíla xeq'uiy, ri tico'n xejik' pa quik'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jac'a ri ch'aka' chic ija'tz xka' pa jun utzilej ulef, y ri tico'n jebel xeq'uiy y xevachin chuka' jebel. Roma c'o ija'tz xquiyala' a treinta quivech, c'o xquiyala' a sesenta y c'o ri xquiyala' a cien quivech. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ri c'o c'a rac'axabal, can trac'axaj c'a ri xinbij, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Y jac'ari' tok ri tijoxela' xebe-apo riq'uin ri Jesús y xquic'utuj chire: ¿Achique c'a roma tok richin xach'on chiquivech ri vinek xe'acusaj c'ambel tak tzij? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Xpe c'a ri Jesús xubij chique: Man jun bey can ta bin can jebel chirij tok ri vinek ye'oc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren, pero chive rix yo'on c'a k'ij chi nivetamaj. Jac'a ri vinek ri man yeniman ta vichin, riq'uin c'ambel tak tzij yich'on-vi quiq'uin, roma chiquivech rije' can man nik'alajirisex ta vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Roma ri can c'o c'a ruyacon pa ránima, xtuc'ul c'a más y queri' q'uiy xtic'oje' riq'uin. Jac'a ri xa man q'uiy ta ruyacon, xtelesex c'a ri juba' ri' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Xa roma c'a ri' tok yin yencusaj c'ambel tak tzij richin yich'on quiq'uin. Roma xa can man nicajo' ta nik'ax chiquivech, stape' can niquitzu' y nicac'axaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Can ja vi c'a re' nibanatej ri tz'ibatel can roma ri Isaías, ri jun ri xk'alajirisan ri ruch'abel ri Dios ojer can. Y que c'a re' ri rutz'iban can rija': Rix xaxe c'a choj xtivac'axaj y man xtik'ax ta chivech ri xtivac'axaj. Rix xaxe ta c'a choj xtitzu' ri' y man xtitz'et ta jebel ri nitzu'. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Roma ri cánima re vinek re' xa xquicovirisaj. C'ayef c'a chi noc pa quixiquin ri nicac'axaj. Ri runak' tak quivech, quimoyin, roma man nicajo' ta yetzu'un. Rije' can man jun nicajo', can man nicajo' ta nicac'axaj, can man nicajo' ta nika' pa tak cánima, man nicajo' ta nitzolin-pe quic'u'x, richin chi yin ninchojmirisaj ri quic'aslen. Queri' ri xubij ri Dios, ri tz'ibatel can roma ri Isaías. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jac'a rix nutijoxela', can jebel vi ruva-ik'ij, roma ri runak' tak ivech can yetzu'un-vi jebel. Ri ixiquin can ye'ac'axan-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Roma can tivac'axaj na pe' jebel ri ninbij chive vacami, chi e q'uiy chojmilej tak vinek y ri achi'a' ri xek'alajirisan ri ch'abel ri xbix chique roma ri Dios, ojer can, janíla xcajo' xquitz'et ta ri nitz'et rix vacami, pero man xquitz'et ta el. Can janíla chuka' xcajo' xcac'axaj ta ri nivac'axaj rix vacami, pero man xcac'axaj ta el chuka'. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Y ri Jesús xubij c'a chique: Tivac'axaj c'a achique nubij ri c'ambel-tzij ri nich'on chirij ri achin ri xbe pa jopin ija'tz. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ri ija'tz ri xka' can pa bey, jari' ri ch'abel ri nich'on chirij tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios. Pero chiquicojol c'a ri vinek ri nicac'axaj ri ch'abel ec'o ri man nicajo' ta niquiq'uen-ka ri pa tak cánima. Y romari' tok ri itzel norelesaj-el ri ch'abel ri ticon-ka. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ri ija'tz ri xka' can cojol tak abej, can nich'on-vi c'a chirij ri ruch'abel ri Dios ri nac'axex roma jun vinek. Ri vinek ri' can janíla c'a niquicot tok nuc'ul ri ruch'abel ri Dios pa ránima. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero roma c'a ri can man nuq'uen ta ka ruxe' jebel ri ruch'abel ri Dios pa ránima, can man niyaloj ta c'a ri quicoten riq'uin, xa jun ca'i-oxi' oc k'ij ri utz c'o riq'uin ri Dios. Y tok yepe c'a tijoj-pokonal y netzelex roma ri runiman ri ruch'abel ri Dios, nitzak can chanin. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Y ri ija'tz ri xka' can cojol tak k'ayis ri c'o ruq'uixal, can nich'on-vi c'a chirij ri ruch'abel ri Dios ri nac'axex roma jun vinek. Pero ri vinek ri' roma xa ja ri nrajo' re tiempo ri nrajo' nuben, nijik' c'a ri ruch'abel ri Dios ri c'o riq'uin. Nijik' pa ruk'a' ri beyomel ri achi'el xa c'o utz nuq'uen-pe nik'alajin y xa man que ta ri'. Y ri vinek ri' can man jun bey c'a xtivachin jebel ri ruch'abel ri Dios pa ruc'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jac'a ri ija'tz ri xka' pa jun utzilej ulef, can nich'on-vi c'a chirij ri ruch'abel ri Dios ri nac'axex roma jun vinek, y ri vinek ri' can nuq'uen-vi-ka ri ruch'abel ri Dios y ri ruc'aslen nivachin jebel. Can nivachin-vi c'a achi'el niquiben ri ija'tz. Roma c'o ija'tz niquiya' c'a treinta quivech, ec'o niquiya' a sesenta quivech y ec'o can a cien c'a quivech niquiya'. Can que c'a ri' nuben ruc'aslen ri vinek ri nuq'uen-ka ri ruch'abel ri Dios pa ránima, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Y ri Jesús xuya' chic c'a jun c'ambel-tzij chiquivech, y xubij c'a: Ri utzilej ija'tz ri xberutica' c'a can jun achin ri pa rulef, can junan c'a riq'uin tok ri vinek ye'oc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero jun ak'a', tok can conojel c'a vinek yever, xpe c'a ri netzelan richin ri rajaf ri ulef, xberutica' can rijatzul ri pach'un-k'os (q'uexevach-trigo) pa ruvi' ri trigo ticon chic can. Y xe xberubana' can ri', xbe. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jac'a tok xebeq'uiy-pe ri tico'n y xebe'el-pe ruvi', c'a jac'ari' xk'alajin ri pach'un-k'os. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Y jari' tok ri e samajela' richin ri rajaf ri ulef xe'apon c'a riq'uin y xquibij chire: Ri ija'tz ri xatic-ka pan avulef can utz vi. Pero vacami c'o pach'un-k'os chucojol. ¿Acuchi cami c'a xpe-vi ri ija'tz richin ri pach'un-k'os? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Y ri achin xubij c'a chique ri rusamajela': Re' rusamaj jun ri netzelan vichin, ninch'ob yin. Y ri e rusamajela' xquibij c'a chire: ¿Navajo' c'a chi yojbe chuc'ukic? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero ri achin xubij c'a chique ri rusamajela': Ne', man yixbe ta chuc'ukic, man xa chuc'ukic ri pach'un-k'os quec'ukutej chuka' ri trigo. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Xa tiya' na c'a k'ij chi ri pach'un-k'os junan niq'uiy riq'uin ri trigo, c'a tapon na ri k'atoj. Roma tok xtapon ri k'ij richin ri k'atoj, yin xtinbij c'a chique ri k'atonela' chi nabey tiquimolo' ri pach'un-k'os y quequibana' pa tak manóxo richin chi yeporox; y c'ari' c'a tiquik'ata' ri trigo richin chi nequiyaca' can, xcha' ri achin. Queri' xubij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Y ri Jesús xuya' chic c'a jun c'ambel-tzij chiquivech, y xubij c'a: Jun ti ija'tz richin mostaza ri nerutica' can jun achin ri pa rulef, junan nuben riq'uin tok ri vinek ye'oc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Roma stape' ja ri ija'tz richin ri mostaza ri más tak cocoj, tok nel-pe, janíla niq'uiy y ja rija' ri más nim nel chiquivech ri ch'aka' chic ichaj. Ri mostaza xa can che' c'a nuben tok niq'uiy. Romari' ri aj-xic' tak chicop ri yebe pa cak'ik', ye'apon chiri' y niquiben quisoc ri pa tak ruk'a', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ri Jesús xuya' chic c'a jun c'ambel-tzij chiquivech, y xubij c'a chique: Ri ch'en (ch'amilej-k'or) ri neruc'ama-pe jun ixok y nuya' can chupan oxi' pajbel-q'uej, nuch'amirisaj c'a ronojel. Que c'a chuka' ri' xtibiyin rutzijol ri ruch'abel ri Dios ri nich'on chirij tok ri vinek ye'oc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Y ronojel c'a ri xubij ri Jesús chique ri vinek ri', ronojel riq'uin c'ambel tak tzij. Can man jun c'a ri xubij chique ri man ta xrucusaj c'ambel tak tzij richin xuya' chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Richin queri' can nibanatej na c'a ri rubin can jun ri xtzijon ri ruch'abel ri Dios ojer can. Ri rusamajel ri Dios can que c'a re' ri rutz'iban can chirij ri Jesús: Yin tok xquich'on xquencusaj c'a c'ambel tak tzij. Q'uiy c'a ri can e evatel pa rutiquiribel pe re ruvach'ulef, xquenk'alajirisaj c'a. Queri' nubij ri tz'ibatel can. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Y tok ri Jesús xerutek c'a can ri vinek chi tak cachoch, rija' xtzolin c'a pa jay e rachibilan ri rutijoxela'. Y jari' c'a tok ri rutijoxela' xejel-apo riq'uin y xquibij c'a: Roj nikajo' c'a chi rat nabij ta chike achique nic'ulun-vi chi tzij ri c'ambel-tzij chirij ri trigo y ri pach'un-k'os (q'uexevach-trigo) ri xetic can pa jun ulef. Roma can man xk'ax ta chikavech. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Y ri Jesús can xuk'alajirisaj c'a chiquivech ri c'ambel-tzij, y xubij c'a: Ri ticonel richin ri utzilej ija'tz, ja yin ri xinalex chi'icojol. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ri ulef ri xban-vi ri ticoj, can jac'a re ruvach'ulef. Ri utzilej ija'tz jac'a ri ec'o pa rajavaren o pa ruk'a' ri Dios. Y ri pach'un-k'os (q'uexevach-trigo) jac'a ri can e richin vi ri itzel. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Y ri xbeticon can ri pach'un-k'os roma janíla netzelan, jac'a ri itzel-vinek. Ri k'atoj, jac'a ri xtibanatej pa ruq'uisibel chire re tiempo kachapon; y ri k'atonela', jac'a ri ángeles. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Can achi'el c'a niban riq'uin ri pach'un-k'os chi ye'elesex-el y yeporox pa k'ak', can que c'a chuka' ri' xtibanatej pa ruq'uisibel chire re tiempo kachapon. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yin ri xinalex ri chi'icojol xquentek c'a ri nu-ángeles chiquimolic conojel ri yebanon etzelal y niquiben chique ch'aka' chic chi yetzak. Roma man ninvajo' ta c'a chi ec'o ta ri vinek ri' chiquicojol ri ec'o pa vajavaren o pa nuk'a' yin. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Y conojel c'a ri xquemol-el, xquebec'ak can chupan ri nimalej k'ak'; y c'a chiri' c'a xtipe ri ok'ej chique y xtiquikach'ach'ela' quey. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jac'a ri vinek ri choj chic quic'aslen can xqueyic'lun-vi c'a achi'el ri k'ij. Can xquek'alajin c'a chi ec'o pa rajavaren o pa ruk'a' ri aj-chicajil Quitata'. Ri c'o c'a rac'axabal, can trac'axaj c'a ri xinbij. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ri beyomel mukul can pa jun ulef y xilitej roma jun achin, can junan c'a riq'uin tok ri vinek ye'oc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren. Ri achin ri' xumuk chic c'a can ri beyomel ri' y niquicot ránima xtzolin y xuchop c'a ruc'ayixic ronojel ri c'o riq'uin, y c'ari' xulok' ri ulef ri acuchi mukul-vi ri beyomel. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ri vinek ri ye'oc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren, can e junan c'a riq'uin jun lok'onel y c'ayinel quichin tak abej ri nibix perlas chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tok ri achin ri' nril c'a can jun perla janíla jebel y nic'ayix, junanin nitzolin y nuc'ayij ronojel ri c'o riq'uin, c'ari' c'a nibe chulok'ic ri perla ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Y ri ya'l chapbel-quer tok yo'on-ka pa ya' y yeberuc'ama-pe ronojel quivech quer, can junan c'a riq'uin tok ri vinek ye'oc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Y tok nojinek chic c'a ri ya'l riq'uin quer, niquic'uaj c'a el c'a chuchi-ya'. Y c'ari' yetz'uye' c'a chucha'ic. Ri utzilej tak quer yequiya' c'a can pa tak chaquech, jac'a ri quer ri xa man e utz ta man yequiya' ta pa tak chaquech, xa yequelesaj c'a can. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Que c'a ri' ri xtic'ulvachitej pa ruq'uisibel chire re tiempo kachapon. Ri ángeles xquepe c'a chiquicha'ic ri vinek. Juc'an xquequiya-vi ri choj chic quic'aslen, y xquequelesaj c'a can ri man e utz ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Y ri vinek ri man e utz ta, xquebequic'aka' c'a can chupan ri nimalej k'ak', y chiri' c'a xtipe ri ok'ej chique y xtiquikach'ach'ela' quey. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Y ri Jesús xubij c'a chique ri rutijoxela': ¿Xk'ax chivech? xcha' chique. Y ri tijoxela' xquibij c'a: Ja', Ajaf, xk'ax chikavech, xecha' rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Rija' xubij chic c'a: Yalan utz vi xk'ax chivech, roma xixoc yan pa rajavaren o pa ruk'a' ri Dios y c'o chic ivetaman chirij ri', y chuka' ivetaman ri e tz'ibatel can ojer yan chic ri'. Y romari' can ix junan c'a riq'uin jun tata'aj pa jun jay. Tok c'o nic'atzin-vi, c'ari' c'a yeberelesala-pe ri rubeyomel. Yerucusaj c'a ri rubeyomel ri c'o yan chic tiempo e yaquel y yeberelesala' chuka' pe ri rubeyomel ri c'a juba' ri' ec'o riq'uin, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Y tok ri Jesús xtane' c'a chubixic ri c'ambel tak tzij ri', rija' xuya' c'a can ri lugar ri' y xbe e rachibilan-el ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jac'a tok xapon ri pa tinamit ri xq'uiy-vi, rija' xuc'ut c'a ri ruch'abel ri Dios ri chiri' pa nima-jay ri can richin niquimol-qui' ri vinek richin nicac'axaj ri ruch'abel ri Dios. Y roma c'a ri ch'abel ri yerubij chique, ri vinek ri' can xsach quic'u'x y xquibij c'a: ¿Achique c'a roma tok re achin re' janíla etamabel c'o riq'uin y nitiquir yeruben milagros? ");
INSERT INTO cakCNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Xa jac'are' ri ruc'ajol ri jun achin samajiy-che' (ajanel). Xa jare' ri María rubini'an ri rute' y ri e rach'alal ja ri Jacobo, ri José, ri Simón y ri Judas. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Xa chikacojol c'a roj ec'o-vi ri e rana'. ¿Acuchi ta c'a xretamaj-vi ri retaman y acuchi ta c'a petenek-vi ri ruchuk'a' richin yerubanala' milagros? yecha' chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Y romari' ri vinek can man juba' xquinimaj ta ri Jesús. Y ri Jesús xubij c'a chique ri vinek ri': Conojel c'a ri yek'alajirisan ri ch'abel ri bin chique roma ri Dios, man jun quik'ij; pero ri' xaxe chiquivech ri vinek aj pa rutinamit y chiquivech ri aj pa rachoch, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chupan ri rutinamit, ri Jesús man q'uiy ta milagros ri xerubanala', roma ri ruvinak man xquinimaj ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chupan c'a ri tiempo ri', ri Herodes ri k'atoy-tzij, xrac'axaj c'a chi ri Jesús janíla rutzijol chiquicojol ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Y ri Herodes xubij c'a chique ri rajic'a': Ri Jesús xa ja ri Juan ri Bautista c'astajinek-pe chiquicojol ri caminaki'. Romari' tok c'o uchuk'a' pa ruk'a' richin q'uiy ri nitiquir yerubanala', xcha' ri Herodes chique ri rajic'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Roma xa can jac'a ri rey Herodes ri xbin chi techap-pe ri Juan. Can xuxim-vi c'a pa cadena y xuya' pa cárcel. Ri Herodes queri' xuben roma ri ixok ri c'o riq'uin; ri ixok rubini'an Herodías, xa rixjayil c'a ri Felipe ri rach'alal ri Herodes. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ri Juan xchap c'a roma jari' ri rubin chire ri Herodes. Rija' rubin c'a chire: Man utz ta abanon chi ac'amon-ka ri Herodías. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Y roma c'a ri' ri Herodes can rajovan c'a rucamisan ta ri Juan, pero can nuxibij c'a ri' chiquivech ri vinek, roma rije' can quetaman chi ri Juan ri Bautista can jun k'alajirisey richin ri ch'abel ri nibix chire roma ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Xa jac'a chupan ri k'ij tok ri Herodes xutz'akatisaj jun chic rujuna', rija' xuben c'a jun nimak'ij, y chupan c'a ri nimak'ij ri' ri xten ral ri Herodías xxajo' c'a chuvech ri Herodes, y ri Herodes janíla xka' chuvech ri xajoj xuben. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Y romari' ri Herodes xuben c'a jurar chire ri ral ri Herodías chi xabachique c'a ri nrajo' can xtuya-vi chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pero tok ri xten can ruc'ulun chic c'a runa'oj riq'uin ri rute', can c'ari' c'a xubij chire ri Herodes: Yin ninvajo' chi naya' chinuvech re vave' pa jun lek, ri rujolon (ruvi') ri Juan ri Bautista, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Y ri rey Herodes xpe bis pa ránima romari', pero roma c'a can rubanon chic jurar chire chi can xtuya-vi ri nrajo' y roma chuka' can chiquivech ri e rachibilan pa mesa xubij-vi; rija' xubij c'a chi tic'an-pe ri rujolon (ruvi') ri Juan ri Bautista chire ri xten ral ri Herodías. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Xutek c'a rutzaq'uixic rukul ri Juan ri Bautista chiri' pa cárcel. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Y ri rujolon (ruvi') xc'an-pe pa jun lek chire ri xten, y ri xten xberujacha' pa ruk'a' ri rute'. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Y ri e rutijoxela' ri Juan ri Bautista xe'apon c'a chucanoxic ri ruch'acul y xbequimuku' can. Y rije' xbequibij c'a chuka' chire ri Jesús ronojel ri xbanatej. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Y ri Jesús can xe c'a xrac'axaj-el ronojel ri banatajinek, xbe, e rachibilan-el ri rutijoxela'. Xe'oc-el pa jun canoa y xek'ax c'a juc'an ruchi-ya', xebe c'a pa jun lugar nej. Lugar ri e manek vinek. Xa jac'a tok ri vinek xcac'axaj-el, chicaken c'a xe'el-el ri pa tak tinamit richin xe'apon c'a ri lugar ri c'o chi napon-vi ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Y tok ri Jesús nel c'a can chupan ri canoa ri chiri' juc'an ruchi-ya', xutz'et c'a chi e janíla chic e q'uiy vinek ri e oyobeyon richin y rija' janíla c'a xujoyovaj quivech ri vinek ri'. Y rija' can xeruc'achojirisaj-vi c'a ri yava'i' ec'o chiquicojol. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Y tok xa xkak'ij-ka chupan ri jun k'ij ri', ri rutijoxela' xejel c'a apo riq'uin y xquibij chire: Re vave' xa e manek vinek y janíla xkak'ij yan. Que'ataka' c'a el re vinek re' richin chi yebe ri pa tak cocoj tinamit ri ec'o-pe nakaj y tiquilok'o' quivay chiri', xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pero ri Jesús xubij chique ri rutijoxela': Man nic'atzin ta c'a richin yebe y c'a ta ri' niquil quivay, xa tiya' quivay rix, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Y ri rutijoxela' xquibij c'a: Roj xaxe vo'o' vey y ca'i' quer c'o kiq'uin, y re' man xqueruben ta, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Pero ri Jesús xubij chique: Tic'ama-pe vave'. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Y jac'a chuka' ri' tok rija' xubij chi quetz'uye' c'a conojel ri vinek pa ruvi' ri sabana. Y c'ari' rija' xeruli'ej pa ruk'a' ri vo'o' vey y ri ca'i' quer, xtzu'un chicaj y xumatioxij chire ri Dios. Rija' xeruper c'a el (xerupir c'a el) ri quer y ri vey, y xuya-el chique ri rutijoxela' y ri tijoxela' xbequijacha' can chiquivech ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Can conojel c'a jebel xquitej quivay. Can man jun c'a ri man ta jebel xva'. Y c'a c'o na c'a cablajuj chaquech ri xnoj can riq'uin ri vey y ri quer ri xmolotej can, ri xa man xq'uis ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Conojel c'a ri vinek ri xquitej quivay ec'o la'ek vo'o' mil xaxe achi'a', y ec'o chuka' ixoki' y ac'uala'. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Y jac'ari' tok ri Jesús xerucusaj-el ri rutijoxela' chupan ri canoa y xubij chique chi quebe c'a ri juc'an chic ruchi-ya'; chi can quenabeyej c'a el chuvech, roma rija' c'a yerutakala' na can ri vinek chi tak cachoch. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jac'a tok e rutakon chic can ri vinek chi tak cachoch, ruyon c'a xjote-el pa ruvi' ri juyu' chubanic orar. Y c'a chiri' c'a c'o-vi tok xoc-pe ri ak'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Y ri canoa ri e benek-vi ri tijoxela' pa runic'ajal chic c'a ya' c'o-vi, pero ri nibolko't ri ya' man nuya' ta k'ij chi nibiyin. Can janíla c'a cak'ik' y man nuya' ta k'ij chire ri canoa chi choj nibe chuvech. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Y tok nipe yan c'a rusekeric y jubama nik'ax yan ri ak'a' ri', ri Jesús petenek c'a chiraken pa ruvi' ri ya', richin napon quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pero tok ri rutijoxela' xquitz'et chi c'o jun petenek chiraken pa ruvi-ya'; rije' xsach quic'u'x y xquibij: ¡La' jun xibinel! xecha'. Y can riq'uin cuchuk'a' xquibila' queri' roma quixibinri'il. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero ri Jesús chanin xch'on-pe chique, y xubij c'a: Man tixibij-ivi'. Xa ticukuba' ic'u'x. Ja yin ri Jesús, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Y ri Pedro can jac'ari' xch'on-apo chire ri Jesús ri c'a petenek na pa ruvi' ri ya'. Ri Pedro xubij c'a chire ri Ajaf: Vi jac'a rat, tabana' c'a chuve chi yibiyin pa ruvi-ya' richin yibe-apo aviq'uin, xcha' ri Pedro. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Y ri Ajaf xubij-pe chire ri Pedro: Catampe c'a. Y ri Pedro can jari' xka-el ri pa canoa y xuchop c'a nibiyin pa ruvi' ri ya' richin nibe-apo c'a riq'uin ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Xa jac'a tok xutz'et ri nuben ri nimalej cak'ik', xpe xibinri'il chire. Y tok xuna' chi nibe-ka chuxe' ri ya', riq'uin c'a ruchuk'a' xubij: ¡Ajaf, quinacolo'! ");
INSERT INTO cakCNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Y ri Jesús can jac'ari' xuchop chanin ri Pedro y xubij chire: ¿Achique c'a roma juba' oc xacukuba' ac'u'x viq'uin? xuche'ex ri Pedro roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tok rije' e jotol chic c'a el ri pa canoa, ri cak'ik' xtane-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Y can jari' tok conojel ri e benek ri chiri' pa canoa xquiya' c'a ruk'ij ri Jesús y xquibij chire: C'a vacami c'a xkatz'et kitzij chi can ja vi rat ri Ruc'ajol ri Dios. Que c'a ri' xquibij chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Y rije' xek'ax c'a pa ruvi' ri nima-ya' ri' y xe'apon ri pa Genesaret. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ri chiri', tok xetamex c'a ruvech ri Jesús coma ri achi'a', rije' xquelesaj c'a rutzijol chanin c'a ri pa tak lugar ec'o-pe chunakaj ri quitinamit, y ri vinek xequic'amala' c'a pe ri quiyava'i'. ");
INSERT INTO cakCNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Y re yava'i' re' can niquic'utula' c'a utzil chire ri Jesús chi tuya' k'ij chique chi stape' xaxe ruchi-rutziak niquichop richin yec'achoj. Y can que vi c'a ri' xbanatej. Conojel ri xechapon ruchi-rutziak ri Jesús xec'achoj chire ri quiyabil. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Y ec'o c'a ca'i-oxi' achi'a' ri xe'apon riq'uin ri Jesús. Ri achi'a' ri' e aj-Jerusalem y jari' ri nibix fariseos y etamanela' chique. Xe'apon c'a riq'uin ri Jesús y xquibij chire: ");
INSERT INTO cakCNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Achique c'a roma tok ri atijoxela' niquik'ej ri bin can coma ri kati't-kamama'? Roma ri atijoxela' tok niquitej quivay can man niquich'ej ta jebel ri quik'a'. Man niquiben ta achi'el nikaben roj, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ri Jesús roma ri xquic'utuj queri' chire, rija' xubij c'a chique: Y rix ¿achique c'a roma tok ja riq'uin ri quibin ri kati't-kamama', riq'uin ri' nik'ej-vi ri rupixa' ri Dios? ");
INSERT INTO cakCNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ri rupixa' ri Dios nubij c'a: Taya' quik'ij ate-atata'. Y ri nibanon c'a itzel chique rute-rutata', can man jun chic c'a ri nrajo', can ja vi c'a ri camic ri tika' pa ruvi'. Que c'a ri' ri rubin can ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Jac'a rix xa man que ta ri' ri niben y nic'ut. Xa man niben ta achi'el ri rubin can ri Dios. Rix xa ye'itijoj ri alc'ualaxela' chi man nic'atzin ta chi yequito' ri quite-quitata'. Xa ye'el chuvech ri' riq'uin niquibij chique ri quite-quitata': Yin man yitiquir ta yixinto' riq'uin ri nic'atzin chive, roma xa nusujun chic chire ri Dios ri nic'atzin ta chive rix. Y riq'uin niquibij queri' ye'el chuvech ronojel, yixcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Y riq'uin ri nibij, can nik'alajin-vi chi rix nibij chique chi man tiquiya' quik'ij quite-quitata'. Y riq'uin ri', xaxe riq'uin ri quibin can ri kati't-kamama' ibanon chi can man jun ruk'ij ri rupixa' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Rix xa ca'i' c'a ipalej. Xa can jebel c'a rubixic rubanon can ri Isaías chivij. Ri xubij ri Dios chire chi tutz'ibaj can, nubij c'a: ");
INSERT INTO cakCNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Re vinek re' xaxe riq'uin ri quich'abel niquiya' nuk'ij, jac'a ri nrajo' ri cánima xa man ja ta ri'; xa nej c'a chire ri niquiya' ta nuk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xa can man jun c'a nic'atzin-vi ri niquiya' nuk'ij, roma xa e tijonel quichin quetamabal achi'a' y niquibij chi can jari' ri ruc'amon chi niban. Queri' ri rutz'iban can ri Isaías, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Y c'ari' c'a ri Jesús xch'on quiq'uin ri janíla chi vinek quimolon-qui' chiri', y xubij c'a chique: Tivac'axaj c'a re xtinbij chive y tik'ax-el chivech. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ri nitz'ilobisan richin ri vinek man ja ta c'a ri nutej-ka nibanon, man que ta ri'. Ri nitz'ilobisan richin ri vinek xa ja ri ch'abel y nojibel ri yepe riq'uin, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Y tok ri tijoxela' xejel-apo riq'uin ri Jesús, xquibij chire: Ri achi'a' fariseos xpe coyoval tok xcac'axaj ri ch'abel ri xabij, xecha' ri tijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero rija' xubij chique ri rutijoxela': Ri tico'n ri quibanon rije' man xtic'oje' ta c'a can, xa xtic'uk-el. Roma ronojel ri tico'n ri' man ja ta c'a ri Nata' c'o chila' chicaj banayon. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xa que'iya' can. Xa can e moyirinek c'a riq'uin ri etamabel ri c'o quiq'uin, y yequic'uaj ch'aka' chic ri xa e moyi' chuka'. Y vi ri e moyi' yequiyukej ri ch'aka' chic moyi', junan c'a xquetzak pa tak jul, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Y ri Pedro xubij c'a chire ri Jesús: Tabij juba' chike chirij ri nitz'ilobisan richin jun vinek, roma can man nik'ax ta chikavech, xcha' ri Pedro. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Y ri Jesús xubij: ¿Chuka' rix can c'a man jani nik'ax ta chivech ri ninbij? ");
INSERT INTO cakCNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Man nik'ax ta chivech ri tzij ri nubij chi ri nutej-ka ri vinek xa man ja ta ri' ri nitz'ilobisan richin? Roma ri nutej-ka xa choj pa rupan nibe-vi y c'ari' nel-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ri nitz'ilobisan richin jun vinek jac'a ri ch'abel, ri nojibel ri yepe riq'uin. Ri ye'el-pe pa ránima. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Roma xa pa cánima c'a ri vinek yepe-vi ri itzel tak ch'obonic. Chiri' nipe-vi ri ch'obonic tok yecamisan. Chiri' chuka' nipe-vi ri ch'obonic tok ri vinek ri e c'ulan y ri man e c'ulan ta niquicanola-qui' richin yemacun. Y pa cánima chuka' nipe-vi tok ye'elek', niquiyacala-pe tzij chiquij ch'aka' chic, y chuka' tok yeyok'on. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Y ronojel c'a ri banobel que tak ri' jari' ri nibanon chire jun vinek chi nutz'ilobisaj-ri'. Pero ri nuben ri vinek chi man jebel ta ruch'ajon ruk'a' y c'ari' nutej-ka ruvay, ri' man jun nuben chire ri ruc'aslen; can man c'a nutz'ilobisaj ta. Que c'a ri' xubij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Y ri Jesús e rachibilan ri rutijoxela' xel c'a el ri chiri', y xbe c'a quela' pa jun lugar ri nakaj nicanej chique ri tinamit quibini'an Tiro y Sidón. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Y chiri' ec'o-vi c'a ri e riy-rumam can ri achin xubini'aj Canaán. Y jun c'a ixok ri chiquicojol rije', xpe c'a riq'uin ri Jesús. Rija' roma bis, can nuc'utula' c'a utzil chire ri Jesús y nubila' c'a riq'uin ruchuk'a': Tajoyovaj nuvech rat Ajaf, rat ri riy-rumam can ri rey David. Quinato' c'a, roma ri val-xten c'o jun itzel espíritu riq'uin, y c'ayef rubanon pa ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero ri Jesús man jun ch'abel xubij chire ri ixok. Y ri tijoxela' xejel-apo riq'uin ri Jesús y xquibij chire: Tabana' chi tic'oje' can re ixok re', roma tzeketel-pe chikij y ri ruch'abel c'anej nac'axex-vi, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Xpe ri Jesús xubij: Yin xitak-pe xaxe chiquicanoxic ri kavinak israelitas ri man ec'o ta apo riq'uin ri Dios, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Can jac'ari' xpe ri ixok xoxuque' chuvech ri Jesús, y xubij chire: Ajaf, can quinato' c'a, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Pero ri Jesús xubij chire ri ixok: Ri rutzil ri Dios man utz ta chi chire xabachique ninya-vi. Achi'el ri quivay ri alc'ualaxela' man ruc'amon ta chi nelesex chique richin ja ri tak tz'i' yetijon, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero ri ixok xubij: Ajaf, can kitzij ri nabij. Pero can yojtiquir c'a chuka' nikac'ul-apo juba' chire ri utzil ri'. Achi'el niquiben ri tak tz'i' yequimolola' ri ruc'aj vey ri yequitzek-ka ri cajaf yeva' pa mesa. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Y ri Jesús can jari' xubij c'a chire ri ixok: Can janíla nik'alajin chi acukuban ac'u'x. Can tibanatej-vi c'a ri janíla navajo' rat, xcha' ri Jesús. Y ri xten, ral ri ixok, can chupan c'a ri hora ri' xel-el ri itzel espíritu riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tok ri Jesús e rachibilan ri rutijoxela' e k'axinek chic c'a pe chupan ri lugar ri nakaj nicanej-vi chique ri tinamit Tiro y Sidón, xapon c'a chunakaj ri nima-ya' rubini'an Galilea. Y rija' xjote' c'a pa ruvi' ri juyu' c'o chiri' y c'ari' xbetz'uye'. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Y ec'o c'a janíla e q'uiy vinek ri xe'apon riq'uin, y e quic'uan-apo quiyava'i'. Chique ri yava'i' ri e quic'uan-apo ec'o ri xa man choj ta yebiyin roma ri e jetz', ec'o moyi', ec'o mema', ec'o ri man utz ta ri quik'a' ri caken, y ec'o ch'aka' chic ri jun vi chic chi ruvech yabilal noc chique. Ri vinek ri' xequiya' c'a apo ri quiyava'i' chuvech ri Jesucristo, y rija' xeruc'achojirisaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Can roma c'a ri xuben ri Jesús quiq'uin ri yava'i', ri vinek can achique la xquina' tok xquitz'et. Roma ri mema' tok rubanon can, vacami yech'on chic. Ri man utz ta ri quik'a' ri caken, xec'achoj. Ri e jetz', choj chic yebiyin. Ri moyi', yetzu'un chic. Ri vinek can xquiya-vi c'a ruk'ij-ruc'ojlen ri Dios ri richin ri Israel. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Y tok ri Jesús xeroyoj ri rutijoxela', xubij c'a chique: Janíla ninjoyovaj quivech re vinek re', roma c'o yan oxi' k'ij ec'o-pe viq'uin y vacami man jun chic quivay richin niquitej. Y yentek ta c'a el chi tak cachoch choj queri' y man jun niquitej-el, man utz ta; man xa quebetzak pa tak bey roma vayjal, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Can jac'ari' xech'on-apo ri tijoxela' chire ri Jesús y xquibij c'a: Re lugar ojc'o-vi xa e manek vinek. ¿C'o ta cami nekila-vi-pe vey richin yekatzuk jebel re vinek re'? Xa can janíla e q'uiy, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pero ri Jesús xuc'utuj chique: ¿Janipe' c'a vey c'o iviq'uin? xcha'. Y rije' xquibij: Roj xaxe vuku' vey c'o kiq'uin y chuka' ca'i-oxi' tak quer, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Y ri Jesús xubij c'a chi ri vinek quetz'uye-ka ri pan ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","C'ari' rija' xeruli'ej ri vuku' vey y ri quer pa ruk'a' y xumatioxij chire ri Dios. Y c'ari' c'a xeruperela-el y xuyala-el chique ri rutijoxela', y ri tijoxela' nequiya' chique ri vinek ri'; ri can janíla vi e q'uiy. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Can conojel c'a jebel xquitej quivay. Can man jun c'a ri man ta jebel xva'. Y c'a c'o na vey y quer ri xmol can. Vuku' chaquech c'a ri xnoj can riq'uin ri vey y quer ri xmol. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","E caji' mil achi'a' c'a ri xquitej quivay. Jac'a ri ixoki' y ri ac'uala' ri xquitej quivay, man xe'ajlex ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Y jac'a tok ri Jesús e rutakalon chic can ri vinek chi tak cachoch, rija' e rachibilan ri rutijoxela' xoc-el pa canoa y xbe c'a ri pa Magdala. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Y jac'ari' tok ec'o achi'a' fariseos y ec'o chuka' achi'a' saduceos ri xe'apon riq'uin ri Jesús. Ri achi'a' ri' xe'apon riq'uin xaxe richin chi niquitejtobej ri Jesús, y xquibij c'a chire chi tubana' c'a chi c'o nibanatej chupan ri caj, richin tuc'utu' chi rija' can ja vi ri Dios takayon-pe richin, xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero ri Jesús xubij chique ri achi'a' ri': Rix tok nitz'et chi quek quibanon ri sutz' chicaj, tok c'a rukajic ka ri k'ij, nibij chi utz k'ij nerubana'. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y chuka' ri pa tak nimak'a', tok rix nitz'et chi ri caj mukul y quek chuka' quibanon ri sutz', nibij chi man utz ta k'ij nerubana'. Rix xa ca'i' c'a ipalej, roma jebel ivetaman nitzu' ri caj, ivetaman vi utz o man utz ta k'ij nerubana'. Jac'a ri retal ri can nitz'etetej-vi y nubij achique tiempo ojc'o-vi, rix xa man nitzu' ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ri vinek richin vacami janíla e itzel y man niquinimaj ta ri Dios. Can nicajo' chi yin ninben ta chi c'o ri nic'ulvachitej chupan ri caj richin yinquinimaj. Pero man ja ta c'a ri nicajo' rije' ri xtic'ulvachitej. Man que ta ri'. Xa can xe ri xc'ulvachitej riq'uin ri jun achin ri xubini'aj Jonás, jun achin ri xk'alajirisan ri xbix chire roma ri Dios ojer can, xaxe ri' ri retal chuka' chique rije', xcha' ri Jesús y xbe e rachibilan ri rutijoxela'; xeruya' can quiyon ri achi'a' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Y ja tok ri Jesús y ri rutijoxela' xe'apon c'a ri juc'an ruchi-ya', ri tijoxela' c'ari' c'a xquinabej chi xa manek vey quic'uan-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ri Jesús xubij c'a chique ri rutijoxela': Can tivac'axaj c'a ri xtinbij chive, chi can tichajij c'a ivi' chuvech ri ch'en (ch'amilej-k'or) quichin ri achi'a' fariseos y ri achi'a' saduceos, roma xa nuben chire ronojel chi nich'amir, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Y roma queri' xubij ri Jesús, ri tijoxela' xquich'ob c'a ri pa tak cánima: Rija' xubij queri' roma man xkaq'uen ta pe kavay. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero ri Jesús xretamaj c'a ri niquich'ob ri rutijoxela' ri pa tak cánima, y xubij c'a chique: ¿Achique roma rix nich'ob chi roma manek kavay, romari' tok xinbij queri'? ¿Can man icukuban ta ic'u'x viq'uin y romari' xaxe chic ri vey ri nich'ob? ");
INSERT INTO cakCNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Manek c'a nic'atzin-vi chi xaxe chic ri vey ri nich'ob. Achi'el xa c'a man jani nik'ax ta chivech. ¿Y man noka' ta c'a chi'ic'u'x tok xentzuk ri vo'o' mil vinek riq'uin ri vo'o' vey? ¿Can man noka' ta c'a chi'ic'u'x janipe' chi chaquech vey ri ximol can? ");
INSERT INTO cakCNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Chuka' can man noka' ta c'a chi'ic'u'x tok xentzuk ri caji' mil vinek riq'uin ri vuku' vey? Chuka' chiri' can c'a pa chaquech na ri xe'imol can. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Achique ta c'a jun chic rubixic ninben yin, richin nik'ax ta chivech chi man roma ta ri vey ri ximestaj can, tok xinbij chi rix tichajij-ivi' chuvech ri ch'en (ch'amilej-k'or) quichin ri achi'a' fariseos y saduceos? xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Y ri tijoxela', c'ari' c'a xk'ax chiquivech chi man chuvech ta c'a ri ch'en (ch'amilej-k'or) ri niquicusaj ri achi'a' fariseos y saduceos ri tiquichajij-vi-qui'. Xa chuvech c'a ri quitijonic ri achi'a' ri', ri tiquichajij-vi-qui', roma ri tijonic ri' chanin nuyoj (nuyuj) ri nika-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Y ri Jesús rachibilan ri rutijoxela' xapon c'a pa jun lugar ri nakaj nicanej chire ri tinamit rubini'an Cesarea richin ri Filipo. Xpe ri Jesús xuc'utuj c'a chique ri rutijoxela': ¿Achique c'a niquich'ob ri vinek chuvij yin ri xinalex chi'icojol, chi in achique c'a yin? xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Y ri tijoxela' xquibij c'a chire ri Jesús: Ec'o ri yebin chi rat ja ri Juan ri Bautista. Ec'o ch'aka' chic niquibij chi ja rat ri Elías, ri jun achin ri xk'alajirisan ri xbix chire roma ri Dios ojer can. Ec'o chuka' ri yebin chi rat ja ri Jeremías ri jun chuka' achin ri xk'alajirisan ri xbix chire roma ri Dios ojer can. Y can ec'o chuka' ri yebin chi rat jun c'a chique ri ch'aka' chic achi'a' ri xek'alajirisan ri xbix chique roma ri Dios ri ojer, xecha' ri tijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Y rija' xuc'utuj c'a chique ri rutijoxela': Y rix ¿achique nich'ob chuvij? xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Y ri Simón Pedro can jac'ari' xubij chire ri Jesús: Ja rat ri Cristo, ri Ruc'ajol ri c'aslic Dios, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Y can xe xrac'axaj queri' ri Jesús, can jac'ari' xubij: Rat Simón Pedro ruc'ajol ri Jonás, can jebel c'a ruva-ak'ij, roma ri xabij chi ja yin ri Cristo ri Ruc'ajol ri Dios. Ri xabij man jun ta c'a vinek ri xk'alajirisan chavech, xa can jac'a ri Nata' Dios ri c'o chila' chicaj ri xk'alajirisan chavech. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yin ninvajo' c'a ninbij chave rat: Yin nuyo'on chic c'a jun abi'; romari' tok rat abini'an Pedro. Y ninbij chuka' chave chi pa ruvi' c'a re abej re' xtinpaba-vi ri nu-iglesia. Y man c'a xtich'acatej ta roma ri camic y roma ri etzelal. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Can chave vi c'a rat xtinya-vi ri uchuk'a' jakbel o tz'apebel richin ri oquen pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren. Can utz vi c'a xtitz'et ri chila' chicaj, tok rat xtatz'apej o xtajek jun bey chiquivech ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Y ri Jesús can jac'ari' xubij chique ri rutijoxela' chi man jun tiquibij-vi chi ja rija' ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Can jac'a chuka' ri' tok ri Jesús xuchop ruk'alajirisaxic chiquivech ri rutijoxela', chi nic'atzin c'a chi rija' nibe ri pa tinamit Jerusalem richin nuc'ovisaj q'uiy tijoj-pokonal pa quik'a' ri rijita'k tak achi'a' ri c'o quik'ij, pa quik'a' ri principal-i' tak sacerdotes y pa quik'a' chuka' ri etamanela' chirij ri ley. Can xquinapon na c'a ri pa camic, pero pa rox k'ij xquic'astej c'a pe, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Y ri Pedro can xe xrac'axaj chi queri' xubij ri Jesús, xberuc'ama-pe y c'a quela' ri xbechapon-pe chire. Can xubij c'a chire: Man ta ja nrajo' ri Dios, chi nibanatej achi'el ri xabij rat Ajaf, xcha' ri Pedro. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero tok ri Jesús xrac'axaj queri', xupiscolij-ri'. Y c'ari' c'a xubij chire ri Pedro: Man cac'oje-pe viq'uin rat Satanás, roma man utz ta ri nach'ob. Rat xa yatoc k'atbel nubey. Roma ri ach'obonic rat xa can junan riq'uin ri niquich'ob ri vinek y man nach'ob ta juba' achique c'a ri nrajo' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Y ri Jesús xch'on c'a chuka' chique ri ch'aka' chic rutijoxela' y xubij: Vi c'o jun nrajo' nitzekelben vichin, can tubana' c'a achi'el nuben jun ri benek chuxe' ru-cruz. Man nuben ta ri nurayij rija'. Man nupokonaj ta nuc'ovisaj tijoj-pokonal. Vi c'o c'a jun ri nich'obon quere', utz nipe viq'uin richin yirutzekelbej. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Roma vi yalan nupokonaj ri ruc'aslen re vave' chuvech re ruvach'ulef, xa man xtril ta c'a ruc'aslen richin jantape'. Jac'a ri man nupokonaj ta ri', stape' napon pa camic voma yin, can xtril-vi ruc'aslen richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Roma achique ta c'a nuq'uen-pe chire ri vinek, vi nic'oje' ri beyomel richin ronojel re ruvach'ulef riq'uin y re vinek re' xa man nicolotej ta? Stape' ta janíla ri beyomel c'o riq'uin ri vinek, man nitiquir ta c'a nulok' ri c'aslen richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yin ri xinalex chi'icojol can xquipe chic c'a jun bey, y junan chic c'a nuk'ij-nuc'ojlen riq'uin ri Nata' y e vachibilan-pe ri nu-ángeles. Y jac'ari' tok xtinya' ruq'uexel chique conojel; ruq'uexel ri quibanobal ri xequibanala'. ");
INSERT INTO cakCNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Y tivac'axaj c'a re xtinbij chive, y janíla rejkalen: Yin ri xinalex chi'icojol can xquipe-vi c'a, riq'uin chic nuk'ij-nuc'ojlen y c'o chic uchuk'a' pa nuk'a'. Y ec'o c'a chive rix can man xquequen ta (xquecom ta), c'a tok quitz'eton chic na can ri', xcha' ri Jesáus. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Y tok ic'ovinek chic c'a vaki' k'ij, ri Jesús xucha' ri Pedro, xerucha' chuka' ri Jacobo y ri Juan ri cach'alal qui', richin chi xaxe quiyon ri e oxi' xeruc'uaj c'a pa ruvi' jun juyu' nim. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ri Jesús xjalatej c'a ruvech chiquivech ri e oxi' rutijoxela'. Xoc c'a achi'el nitzu'un ri k'ij tok jebel niyic'lun. Y ri rutziak can xoc achi'el ri sakil. Can janíla c'a sek xtzu'un. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Y tok ri e oxi' tijoxela' xquitz'et c'a, yetzijon yan chic riq'uin ri Jesús ri ca'i' achi'a' quibini'an Moisés y Elías. Ri achi'a' ri' e rusamajela' ri Dios ri xec'oje' ojer can tiempo. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Y c'ari' c'a tok ri Pedro xubij-apo chire ri Jesús: Ajaf, vave' utz kabanon. Vi rat navajo', nikaben c'a oxi' tak jay. Chave rat nikaben jun, ri Moisés nikaben chuka' jun richin, y que chuka' ri' nikaben jun richin ri Elías. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tok ri Pedro can c'a nich'on na apo riq'uin ri Jesús, jac'ari' tok ri tijoxela' ri' xquitz'et chi c'o jun sutz' richin sakil xka-pe pa quivi'. Y chupan c'a ri sutz' ri' c'o Jun ri xch'on-pe y xubij: Jare' ri Nuc'ajol y janíla ninvajo'; can nucukuban c'a nuc'u'x riq'uin. Tivac'axaj c'a ri rutzij. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Y tok ri e oxi' tijoxela' xcac'axaj ri', xquikasaj-ka-qui' c'a pan ulef. Y janíla c'a xquixibij-qui'. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Y ri Jesús xjel c'a apo quiq'uin ri rutijoxela', xeruchop-ka y xubij c'a chique: Quixyacatej c'a y man tixibij-ivi', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tok ri tijoxela' xebetzu'un-pe, man jun chic c'a ri xquitz'et, xa can ruyon chic c'a ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Y tok rije' e xulan c'a pe chuvech ri juyu', ri Jesús xuchilabej chique ri rutijoxela': Man jun titzijoj-vi ri xitz'et. Rix utz nitzijoj pero tok yin ri xinalex chi'icojol xic'astej yan pe chiquicojol ri caminaki'; c'a jari' tok ruc'amon nitzijoj, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ri tijoxela' ri' can jari' xquibij chire ri Jesús: Roj k'axinek chikavech chi ja rat ri Cristo ri takon-pe roma ri Dios. ¿Pero achique c'a roma tok ri etamanela' chirij ri ley niquibij chi nabey chi noka' ri Cristo c'o chi noka' ri Elías? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Y ri Jesús xubij c'a chique: Can kitzij vi chi ri Elías nipe nabey y nuben c'a ruchojmilal ronojel ri c'o. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero yin can ninbij c'a chive chi ri Elías ri' xpe yan y man xquinabej ta achique ri'. Xa janíla xquiben-el chire. Can achique ri xquirayij xquiben-el chire, can que vi ri' xquiben. Y can que c'a chuka' ri' yin ri xinalex ri chi'icojol, ec'o ri yebanon chuve chi ninc'ovisaj tijoj-pokonal, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Y c'ari' c'a tok ri tijoxela' xk'ax chiquivech chi ri Jesús chirij ajc'a ri Juan ri Bautista xch'on-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tok ri Jesús y ri e oxi' rutijoxela' xe'apon-ka acuchi quimolon-qui' janíla e q'uiy vinek, c'o c'a jun achin xoka' riq'uin ri Jesús y xoxuque' chuvech. Ri achin xubij c'a chire ri Jesús: ");
INSERT INTO cakCNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ajaf, tajoyovaj ruvech ri nuc'ajol, roma rija' janíla nutej pokon pa ruk'a' ri yabil rubini'an epilepsia, y janíla c'a bey tzakinek pa k'ak' y pa tak ya'. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xinq'uen c'a pe richin xonya' chiquivech re atijoxela' y niquic'achojirisaj ta, pero man yetiquir ta niquic'achojirisaj, xcha' ri achin. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Y ri Jesús jari' xubij: Man jun vinek chupan re tiempo re' ri cukul ta ruc'u'x riq'uin ri Dios. Xa conojel e sachinaki'. ¿Rix nich'ob chi yin can jantape' yic'oje' iviq'uin? ¿Can jantape' c'o chi yixincoch'? Tic'ama' c'a pe ri ala' vave', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ri Jesús richin xuc'achojirisaj ri ala', xchapon chirij ri itzel espíritu richin chi tel-el chiri' riq'uin ri ala'. Y ri ala' can jari' xc'achoj. Xq'uis c'a el ri ruyabil chupan ri hora ri' roma xel-el ri itzel espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Y tok ri Jesús y ri rutijoxela' quiyon chic c'a ec'o, xepe ri tijoxela' xquic'utuj chire ri Jesús: ¿Achique c'a roma roj man xojtiquir ta xkelesaj-el ri itzel espíritu? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Y ri Jesús xubij chique: Man xixtiquir ta xivelesaj roma man icukuban ta ic'u'x jebel riq'uin ri Dios. Y can kitzij vi c'a ri ninbij chive: Xa riq'uin ta nicukuba' juba' ic'u'x riq'uin ri Dios, stape' ta achi'el jun ti ija'tz richin mostaza, xa riq'uin ri', vi rix nibij chire re jun juyu' re' chi tel-el vave' y tik'ax quela', can nik'ax-vi. Can man jun c'a ri man ta xquixtiquir niben, riq'uin nicukuba' juba' ic'u'x riq'uin ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jac'a re jun ruvech espíritu re' nel, pero vi rix niben chi can man yixva' ta richin niben orar, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Y tok ri Jesús y ri rutijoxela' ec'o chic c'a ri pa Galilea, xpe ri Jesús xubij chic c'a chique ri rutijoxela': Yin ri xinalex chi'icojol, can xquijach-vi pa quik'a' ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Can xquicamisex-vi c'a; pero pa rox k'ij xquic'astej-pe chiquicojol ri caminaki'. Y tok ri tijoxela' xcac'axaj ri xubij ri Jesús, can janíla c'a xebison. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Y jac'a tok ri Jesús y ri rutijoxela' xe'apon ri pa tinamit Capernaum, ri yemolon ruchi' ri mero richin pa rachoch ri Dios, ri c'o chi niquitoj conojel ri achi'a', can xe'apon c'a chuka' riq'uin ri Pedro y xquic'utuj chire: ¿Ri Tijonel ivichin man nuya' ta cami ri mero richin pa rachoch ri Dios? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Y ri Pedro xubij: Ja', nuya'. Y tok ri Pedro xapon ri pa jay, nabey ri Jesús xbech'on-pe y xubij chire: Simón Pedro ¿achique na c'a ri nach'ob rat? ¿Ri nima'k tak k'atoy-tzij chuvech re ruvach'ulef, achok che c'a niquic'utuj-vi ri alcaval y ri impuestos? ¿Chique ri calc'ual ka rije' o chique ri ch'aka' chic ri xa man e calc'ual ta? xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Y ri Pedro xubij c'a chire ri Jesús: Ri nima'k tak k'atoy-tzij xa chique ri man e calc'ual ta niquic'utuj-vi alcaval y ri impuestos, xcha'. Y ri Jesús can jac'ari' xubij: Yin ajc'a ri' man nintoj ta ri alcaval y ri impuestos, roma ja yin ri Alc'ualaxel. ");
INSERT INTO cakCNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero vi xa man nikatoj ta, riq'uin juba' man nik'ax ta chiquivech achique roma tok man nikatoj ta. Xa cabiyin c'a ka pa ya' chuchapic quer. Y ri nabey ri xtachop, tajaka' c'a pa ruchi' y chiri' xtavil ri mero ri nic'atzin richin ne'aya' can chique ri moloy-mero richin pa rachoch ri Dios. Ri mero c'a ri' nuben c'a richin naya' can ri avichin rat y ri vichin yin, xcha' ri Jesús chire ri Pedro. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Y jac'ari' tok ri tijoxela' xejel-apo riq'uin ri Jesús, y xquic'utuj c'a chire: Tok can ja chic ri Dios ri K'atoy-Tzij pa kavi', ¿achique c'a ri más nim ruk'ij xtic'oje' chike roj? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Y ri Jesús can jac'ari' tok xroyoj jun ti ac'ual y xuya' ri chiri' pa quinic'ajal. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","C'ari' rija' xubij chique ri rutijoxela': Can kitzij c'a ninbij chive, vi rix man nijel ta ri ich'obonic, vi man yixoc ta achi'el jun ti ac'ual, man xquixoc ta pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Xaxe c'a ri xtuch'utinirisaj-ri' achi'el re jun ti ac'ual re', jac'ari' ri más nim ruk'ij xtic'oje' chiquicojol ri ec'o pa ruk'a' ri Dios, chupan ri aj-chicajil ajavaren. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ri yacayon vichin yin ri pa ránima y can riq'uin quicoten nuc'ul jun ac'ual, jun ri achi'el re', man xe ta xtuc'ul ri ac'ual, xa can xquiruc'ul chuka' yin. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Vi c'o ta jun co'ol ri yiniman y nipe ta jun vinek y nuben chire ri jun co'ol ri' chi nitzak pa mac; man utz ta ri nuben. Romari' ri vinek ri nich'obon chi nuben ri etzelal ri', más ta utz chire rija' chi ximon jun nimalej abej richin que'en chukul y netorix can pa jun nimalej ya' ri janíla nim rupan. Y ri abej ri' ja ta ri nisilox roma ri chicop nibix burro chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","C'ayef quibanon ri vinek ec'o chuvech re ruvach'ulef roma ec'o ri yebanon chique chi yemacun. Can c'o-vi c'a chi queri' nic'ulvachitej chuvech re ruvach'ulef. Pero ri can ruc'amon chi janíla nok'ex ruvech jac'a ri vinek ri nibanon chire jun chic chi nimacun. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Xa roma c'a ri' vi jun ak'a' o jun avaken ri nibanon chave chi yamacun, más ta utz chi nachoy y natorij-el. Roma más utz chi xaxe jun ak'a' o jun avaken c'o y yatoc chupan ri c'aslen ri man q'uisel ta, que chuvech ta ca'i' ak'a' y ca'i' avaken c'o y xa chi tz'aket yabetorix can chupan ri k'ak' ri man jun bey xtichup. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Y chuka' vi xa jun chique ri runak'-avech nibanon chave chi yamacun, más ta utz navelesaj y natorij-el. Roma más utz chi xaxe jun runak'-avech c'o y yatoc chupan ri c'aslen ri man q'uisel ta, que chuvech ta ca'i' runak'-avech c'o y xa chi tz'aket yabetorix can chupan ri k'ak'. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Man c'a que'ivetzelaj ri vinek ri can man jun oc quik'ij, roma rije' can e chajin coma ángeles. Y yin ninbij c'a chive chi ri chajinela' quichin rije' can jantape' c'a yetiquir ye'apon chila' chicaj riq'uin ri Nata'. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Y yin ri xinalex chi'icojol, can xipe-vi c'a chiquicanoxic y chiquicolic ri ec'o pa mac. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Can quixch'obon c'a jebel roma ri xtinbij chive. Vi jun achin ec'o ta jun ciento rucarne'l y nisach ta can jun tok yeberuyuk'uj, ¿man cami yeruya' ta can juba' ri ch'aka' chic rucarne'l, y nibe pa tak juyu' chucanoxic ri jun ri sachinek can? ");
INSERT INTO cakCNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y stape' ri achin ri' c'a ec'o na ri ch'aka' chic rucarne'l ri man xesach ta, yin ninbij chi rija' más c'a niquicot ránima riq'uin ri jun rucarne'l ri sachinek can, vi nerila-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Can que c'a chuka' ri' nibanatej riq'uin ri aj-chicajil Itata', can man rurayibel ta c'a rija' chi nisach ta can jun vinek chupan ri mac, stape' ta ri vinek ri' man jun oc ruk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Vi c'o c'a jun avach'alal c'o itzel ri nuben chave, cabiyin riq'uin y pa ruyonil tabij c'a chire. Y vi ri avach'alal ri' nrac'axaj ri nabij chire, can xach'acon-vi c'a ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jac'a vi xa man yarac'axaj ta, que'ac'uaj c'a jun o e ca'i' chic, richin chi chiquivech rije' tok nabij chire ri avach'alal chi man utz ta rubanon. Richin queri' can ix ca'i' o ix oxi' c'a ri ixc'o tok nibanatej ronojel ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Y vi ri avach'alal can man nrac'axaj ta riq'uin ri xibij rix chire, c'ari' rat ri rubanon ri itzel chave tabij chique conojel ri kach'alal niquimol-qui'. Y tok bin chic chire coma ri kach'alal y man riq'uin ri' man niniman ta tzij, richin tuna' chi man utz ta ri xuben, tibana' c'a chire chi man ivachibil ta chic. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Y can kitzij vi c'a chi yin ninya' can vuchuk'a' pan ik'a'. Y romari' can utz vi c'a xtitz'et ri chila' chicaj, tok rix xtitz'apej o xtijek jun bey chiquivech ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Chuka' ninbij chive: Vi chuvech re ruvach'ulef ec'o e ca'i' kach'alal ri can junan quivech richin chi niquiben xabachique c'utunic chire ri Dios, ri Nata' Dios ri c'o chila' chicaj can xtuben c'a ri nic'utux chire coma ri e ca'i' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Roma xabacuchi c'a ri quimolon-qui' ca'i' o e oxi', vi can pa nubi' yin quimolon-vi-qui', can inc'o c'a pa quinic'ajal, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Y can jari' tok xjel-apo ri Pedro riq'uin ri Jesús y xubij chire: Ajaf, vi jun vach'alal can jantape' c'o itzel nuben chuve, ¿c'a janipe' c'a bey ruc'amon chi nincuy rumac? ¿Jun cami vuku' bey ruc'amon chi nincuy rumac? xcha' ri Pedro chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jac'a ri Jesús xubij chire ri Pedro: Yin man ninbij ta c'a chave chi vuku' bey ri ruc'amon chi nacuy rumac jun avach'alal ri c'o itzel nuben chave. Yin ninbij c'a chave chi ri rumac ri avach'alal ruc'amon chi nacuy setenta bey vukutek. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Roma chupan ri aj-chicajil k'atbel-tzij, can nibanatej c'a achi'el ri xbanatej roma jun rey. Re rey re' xrajo' c'a nuchojmirisaj janipe' quic'as chiquijujunal ri rusamajela'. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Y tok ri rey ri' xuchop c'a ruchojmirisaxic, c'o c'a jun rusamajel xbepabex chuvech y re samajel re' c'o la'ek jun lajuj millón quetzales ruc'as. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Roma c'a ri samajel ri' man nitiquir ta nutoj ri ruc'as rubanon, ri rey xubij c'a chi tic'ayix ri rusamajel rachibilan ri rixjayil y ri e calc'ual. Y chuka' can quec'ayix ri ru-cosas richin ri cajel noc chuvech ri c'as. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Can jac'ari' tok ri samajel xukasaj-ri' c'a pan ulef chuvech ri rey, y janíla c'a nuc'utuj utzil chire. Ri samajel nubila' c'a chire ri rey: Tabana' utzil quinavoyobej c'a juba' más. Yin can xtintoj c'a chave ronojel ri nuc'as, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Y ri rey ri rajaf ri samajel ri', can janíla vi c'a xujoyovaj ruvech ri rusamajel janíla q'uiy ruc'as, romari' xucuy ri ruc'as y man jun xuben chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Jac'a tok colotajinek chic el ri samajel ri', xberuc'ulu' c'a pe jun chic samajel ri banayon jun kajo'n riq'uin. Ri kajo'n c'a ri rubanon ri jun rachibil ri', man achi'el ta c'a ri ruc'as rija', xa jun la'ek cien quetzales. Man riq'uin ri', rija' xuchop chukul y nutz'apej yan c'a ruxla', y nubij c'a chire: Tatojo-pe ri c'as abanon viq'uin, nicha' c'a chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Y ri rachibil pa samaj can jac'ari' xxuque-ka chuvech, y janíla c'a nuc'utuj utzil chire; can nubij c'a: Quinavoyobej chic c'a juba' y yin xtintoj ronojel chave, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jac'a ri achin samajel achok iq'uin banon-vi ri c'as, man xka' ta chuvech ri xbix chire y romari' xbe pa k'atbel-tzij y xberuya' can pa cárcel, richin chi tutz'eta' c'a achique rubaniquil nuben richin nutoj can ri ruc'as, richin nicolotej-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Y ri ch'aka' chic cachibil pa samaj tok xquitz'et ronojel ri xbanatej, can xpe-vi c'a bis pa cánima. Y rije' xebe c'a riq'uin ri rey ri cajaf y xbequitzijoj c'a ronojel ri xuben ri jun samajel riq'uin ri jun chic. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Y ri rey, ri cajaf, can jac'ari' xutek royoxic ri samajel ri man utz ta xuben, y xubij c'a chire: Rat, xa at jun ajc'a itzel nusamajel. Yin xincuy ronojel ri nimalej ac'as, roma can queri' ri c'utunic xaben chuve. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Man ja ta cami ri' ri ruc'amon chuka' xaben ta rat riq'uin ri avachibil pa samaj, achi'el ri xinben yin aviq'uin chi xinjoyovaj avech? ");
INSERT INTO cakCNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Y can jac'ari' ri rey ri cajaf ri samajela', roma xyacatej royoval xujech c'a el ri itzel rusamajel pa quik'a' ri achi'a' ri yebetz'apen can pa cárcel, y chiri' xtiban chire chi nuc'ovisaj tijoj-pokonal c'a tok nitojtej na can ronojel ri ruc'as. ");
INSERT INTO cakCNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Can que c'a ri' xtuben ri Nata' Dios ri c'o chila' chicaj iviq'uin rix, vi man riq'uin ta ronojel ivánima nicuy quimac ri ivach'alal tok c'o itzel niquiben chive, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Y tok ri Jesús xtane' chubixic ri ch'abel ri', xbe c'a e rachibilan ri rutijoxela', xuya' c'a can ri lugar ri', ri rubini'an Galilea. Rija' xbe c'a quela' pa Judea, y xk'ax c'a juc'an chire ri raken-ya' rubini'an Jordán. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Rija' can janíla c'a e q'uiy vinek ri xetzekelben richin ri chiri', y ec'o c'a chuka' ri xeruc'achojirisaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Y jac'ari' tok ec'o achi'a' fariseos ri xe'apon riq'uin, richin chi niquiya' ta pa c'ayef ri Jesús y nitzak ta pa quik'a'. Y romari' xquic'utuj c'a chire: ¿Jun achin ruc'amon nujech-ri' riq'uin ri rixjayil roma xabachique ri niquic'ulvachij? Queri' ri xquic'utuj rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pero ri Jesús xubij c'a chique ri achi'a' ri': ¿Man itz'eton ta c'a rix chupan ri ruch'abel ri Dios ri nubij-vi chi ri Dios can ja ri pa rutiquiribel pe tok can pa c'ulaj xeruben y man ruyon ta jun? Can man ruyon ta c'a ri achin, y chuka' man ruyon ta ri ixok. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","¿Chuka' can man itz'eton ta ri ch'abel ri nibin chi romari' ri achin man chic c'a quiq'uin ta rute-rutata' xtic'oje-vi? Xa riq'uin c'a ri rixjayil xtic'oje-vi, y che ca'i' xa jun c'a xtiquiben. Queri' nubij ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Y romari' tok quic'uan chic qui', man chic e ca'i' ta c'a vinek, man que ta ri', xa jun chic c'a ri quibanon. Roma c'a ri' ri can e tunun chic roma ri Dios, man tuben ri vinek chi yeruch'er, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Y ri achi'a' fariseos xquic'utuj c'a chire ri Jesús: Vi man ruc'amon ta chi queri' niban, ¿achique c'a roma tok ri Moisés xubij chi jun achin, xaxe tubana' jun vuj richin jachojri'il chire ri rixjayil y tuya' can? ");
INSERT INTO cakCNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Y ri Jesús xubij c'a chique ri achi'a' ri': Can achi'el c'a covirinek ri ivánima rix chupan ri man utz ta, can que c'a chuka' ri' xc'ulvachitej ojer can, ri pa ru-tiempo ri Moisés. Xa romari' tok rija' xuya' k'ij chi utz niban ri jachojri'il riq'uin ri ixjaylonel. Y stape' ri pa rutiquiribel pe, man que ta ri' xbanatej. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yin can ninbij-vi c'a chive chi xabachique achin ri nujech-ri' riq'uin ri rixjayil y xa man roma ta ri ixok nucanoj jun chic achin; vi ri achin ri' nuq'uen chic pe jun ixok, ri achin ri' nimacun chuvech ri Dios. Y vi c'o c'a jun achin ri nuc'uan-el ri ixok ri jachon can roma ri rachijil, chuka' ri achin ri' nimacun chuvech ri Dios, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Y ri tijoxela' xquibij c'a chire ri Jesús: Vi jun achin can jantape' ximil riq'uin ri rixjayil, más ta utz chire ri achin chi man ta c'o rixjayil, xecha' rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Y ri Jesús can jari' tok xubij chique ri rutijoxela': Man conojel ta c'a ri jebel ta ruc'ulic niquiben chire ri ch'abel ri xibij, roma man chique ta conojel yo'on-vi k'ij chi que ta ri' niquiben can y man ta yec'ule'. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Y can ec'o na vi achi'a' ri can c'a pa calaxic pe riq'uin ri quite' tok xk'alajin yan chi man xtiquicanoj ta ixok. Ec'o chuka' achi'a' ri e queri', pero xa roma ri banon chique coma ri ak'omanela'. Y ec'o chuka' achi'a' ri e queri', pero xa quiq'uin rije' xpe-vi chi man niquicanoj ta ixok, richin chi yesamej jebel pa rusamaj ri Dios y yequito' ri ye'oc pa ruk'a' ri Dios, chupan ri aj-chicajil ajavaren. Ri jun c'a ri can nuna' chi nitiquir nuben chi man nic'ule' ta, can man c'a tic'ule', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Y ec'o c'a ac'uala' ri xe'uc'uex-apo chuvech ri Jesús, richin chi rija' tuya' ruk'a' pa quivi' y tuc'utuj chuka' ri rutzil ri Dios pa quivi' ri ac'uala' ri'. Pero ri tijoxela' xa xquibij chique ri vinek chi man tiquiben queri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero ri Jesús xa xubij c'a chique ri rutijoxela': Tiya' k'ij richin chi ri ac'uala' yepe c'a viq'uin yin, y man que'ik'et. Roma ri xque'oc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren, xaxe ri e achi'el ri ac'uala'. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Y tok ri Jesús ruc'utun chic c'a ri rutzil ri Dios y xuyala' can ruk'a' pa quivi' ri ac'uala', rija' xbe, xuya' c'a can ri lugar ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Y c'o c'a jun ri xapon riq'uin ri Jesús y xubij: Rat ri utzilej Tijonel tabij c'a chuve: ¿Achique c'a utzilej banobel ri ruc'amon ta chi ninben yin richin queri' nic'oje' ta nuc'aslen ri man q'uisel ta? xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Y ri Jesús xubij chire: ¿Achique c'a roma tok nabij utz chuve yin? Roma man jun vinek ri utz ta, xa can xe c'a Jun ri utz y ri' ja ri Dios. Vi rat can navajo' c'a yatapon chupan ri c'aslen ri man q'uisel ta, can que'atakej c'a ri pixa', xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Y xpe ri c'ajol achin ri apovinek riq'uin ri Jesús xuc'utuj c'a: ¿Achique chi pixa' ri'? xcha'. Y ri Jesús xubij chire: Ri pixa' ri' ja ri man cacamisan; rat achin ri c'o avixjayil man tacanoj jun chic ixok; man catelek'; man tatz'uc tzij chirij jun chic vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Chuka' taya' quik'ij ri ate-atata'. Y achi'el navajo-ka-avi' rat, que c'a chuka' ri' que'avajo' ri ch'aka' chic. Ja pixa' ri', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Y ri c'ajol achin xubij c'a chire ri Jesús: C'a in co'ol tok nubanon-pe ronojel ri'. ¿Achique ta c'a ri ch'aka' chic ri man nubanon ta? xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Y ri Jesús xubij c'a chire: Richin can natz'akatisaj c'a rubanic ronojel, xaxe chic c'a jun ri man abanon ta. Man atalun ta ri abeyomel chiquivech ri vinek ri man jun c'o quiq'uin. Te'ac'ayij c'a can ri c'o aviq'uin y ri rajel tataluj chiquivech ri vinek ri man jun c'o quiq'uin, richin queri' nic'oje' abeyomel chila' chicaj. Y catampe c'a viq'uin y quinatzekelbej, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tok ri c'ajol achin xrac'axaj c'a ri ch'abel ri xubij ri Jesús, nibison ránima xtzolin-el, roma janíla ri beyomel c'o riq'uin y man nrajo' ta nel pa ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Can jac'ari' tok ri Jesús xubij chique ri rutijoxela': Vacami can ninbij-vi c'a chi can kitzij vi chi janíla c'ayef chi jun ri janíla beyomel c'o riq'uin noc ta pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Xa más la'ek man can ta c'ayef chi nik'ax ri jun chicop rubini'an camello pa ti rujulil jun bak, que chuvech jun beyon noc ta pa rajavaren o pa ruk'a' ri Dios, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Y tok ri rutijoxela' ri Jesús xcac'axaj ri ch'abel ri', can achique la xcac'axaj. Y niquibila' c'a chiquivech: Vi can achi'el ri nubij, queri', man jun xticolotej, yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ri Jesús xerutzu-apo ri rutijoxela' y xubij chique: Man tich'ob queri'. Ri vinek man yetiquir ta niquicol-qui', jac'a ri Dios ronojel nitiquir nuben, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Y jari' tok ri Pedro xubij c'a chire ri Jesús: Rat avetaman chi roj kayo'on can ronojel ri c'o kiq'uin, richin queri' at katzekelben. ¿Y achique c'a ri xtikac'ul roj romari'? ");
INSERT INTO cakCNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ri Jesús xubij c'a: Can kitzij c'a ninbij chive chi tok xtapon ri tiempo tok ronojel c'ac'a' chic rubanic, yin ri xinalex chi'icojol c'o chic c'a nuk'ij-nuc'ojlen y xquitz'uye' pa jun ch'aquet richin yik'aton tzij. Y jac'a chuka' ri' tok rix ri xixtzekelben vichin, xquixtz'uye' pa cablajuj ch'aquet richin nik'et tzij pa quivi' ri cablajuj tak tinamit rubanon re nimalej tinamit Israel. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y xabachique vinek ri voma c'a yin ruyo'on can rachoch, rach'alal e alabon y xtani', rute-rutata', rixjayil, ralc'ual o rulef, q'uiy c'a ri xtuc'ul; can pa ciento c'a bey más q'uiy ri xtuc'ul. Y xtrichinaj chuka' ruc'aslen ri man q'uisel ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Y e q'uiy c'a ri janíla quik'ij vacami, xtapon ri k'ij tok manek chic quik'ij xtic'oje'. Y e q'uiy ri xa manek quik'ij re vacami, xtapon ri k'ij tok xtic'oje' quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ri nuben jun achin ri tata'aj pa jun jay chi xel-el ri nimak'a' chiquicanoxic samajela', richin yerutek pa rulef ri ruticon uva chuvech, can junan c'a riq'uin tok ri vinek ye'oc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tok ri achin ri' xeril c'a ri rusamajela' y ch'ovinek chic quiq'uin chi can xtuya-vi jun quetzal chique, c'ari' c'a xerutek chusamajixic ri rulef ri ruticon ruvech riq'uin uva. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pa tak las nueve la'ek ri nimak'a' ri', rija' xel chic el jun bey y xerutz'et c'a ri chiri' pa c'ayibel chi ec'o samajela' ri man quilon ta quisamaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Rija' xapon quiq'uin y xch'on quiq'uin; rija' xubij c'a chique: ¿Nivajo' isamaj? Roma vi nivajo', quixbiyin c'a chuka' rix quixbesamej ri pa vulef nuticon uva chuvech, y yin xtinya' c'a chive ri ruc'amon chi nich'ec, xcha' chique. Y ri samajela' ri' can xebe na vi ri pa samaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ri tata'aj c'a ri rajaf ri ulef, can que c'a chuka' ri' ri xubanala' quiq'uin ri ch'aka' chic samajela' ri xeril tok xel-el ri pa nic'aj-k'ij y ri pa tak las tres ri tikak'ij. Rija' xerutek c'a ri samajela' pa rusamaj y xubij chique chi can xtuya-vi c'a chique ri ruc'amon chi niquich'ec. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Y ri pa tak las cinco ri tikak'ij rija' xel chic el jun bey y xeberila' c'a pe ch'aka' chic samajela'. Y rija' xubij c'a chique ri samajela' ri': ¿Achique c'a roma tok man ivilon ta el isamaj y chi jun k'ij re ixc'o vave'? xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Y ri samajela' ri' xquibij c'a: Man jun xyo'on kasamaj, xecha'. Y ri tata'aj rajaf ri ulef xubij c'a chique ri samajela' ri': Quixbesamej c'a chuka' rix pa vulef ri nuticon uva chuvech y xtinya' c'a chive ri janipe' ruc'amon chi nich'ec, xcha' chique. Y ri samajela' ri' can xebe na vi ri pa samaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Jac'a tok xka-ka ri k'ij, xpe ri rajaf ri ulef tiquil uva chuvech, xubij c'a chire ri uc'uey quichin ri rusamajela': Que'avoyoj-pe conojel ri samajela' y que'atojo-el. Nabey c'a ye'avoyoj-pe ri samajela' xe'oka' pa ruq'uisibel, y ja ri samajela' ri xe'oka' pa nabey jari' ri xqueruq'uisibej can, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tok ri samajela' ri xe'oc pa samaj ri pa tak las cinco ri tikak'ij, xe'apon richin nequic'ulu-pe ri cajel, jun quetzal c'a ri xquic'ulula-pe, roma queri' ri rurayibel ri rajaf ri ulef, chi nuya' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Y tok xe'apon c'a ri samajela' ri xe'oc pa samaj nabey, richin nequic'ulu-pe ri cajel; xquich'ob chi rije' más q'uiy cajel xtiquic'ul chiquivech ri ch'aka' chic ri xa man jun k'ij ta ri xesamej. Jac'a tok xquic'ul ri cajel, c'ari' c'a xquitz'et chi rije' chuka' xa jun quetzal ri cajel xquic'ul. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tok ri samajela' ri' xquic'ul ri cajel y xquitz'et chi junan ri xquic'ul quiq'uin ri ch'aka', xquich'ojij c'a ri cajel. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ri samajela' ri' niquibij c'a: Ri ruq'uisibel tak samajela' ri xe'oc pa samaj, ri xa jun hora oc xesamej, can junan xaben chique kiq'uin roj, tok roj jun k'ij ri xojsamej y xojc'oje' chuka' chuxe' ri ruk'ak'al ri k'ij, yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Y ri tata'aj rajaf ri samaj xubij c'a chire jun chique ri samajela' ri': Riq'uin ri junan xentoj ri ch'aka' chic samajela' man jun itzel xinben chave rat. Roma aviq'uin rat xa can oj canajinek c'a can chi jun quetzal ri ninya' chave. ¿Noka' chi'ac'u'x? ");
INSERT INTO cakCNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Vacami rat xaxe c'a tac'uaj la avajel y utz yabe. Y jac'a chique ri samajela' ri c'a pa ruq'uisibel xe'oc pa samaj, can pa vánima c'a yin xpe-vi tok xinya-el ri cajel achi'el ri avajel rat. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Roma ronojel ri c'o viq'uin yin, can pa nuk'a' c'a yin c'o-vi richin ninben achique ri ninvajo' ninben riq'uin. ¿O rat xa itzel nana' chuve tok yin xa ja ri utz ninben? xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Re c'ambel-tzij re' nuk'alajirisaj c'a achique rubanic ri tzij: E q'uiy c'a ri janíla quik'ij vacami, xtapon c'a jun k'ij tok manek chic quik'ij xtic'oje'. Y e q'uiy ri xa manek quik'ij re vacami, xtapon jun k'ij tok xtic'oje' quik'ij. Y stape' e q'uiy ri ye'oyox, man conojel ta c'a ri xquechatej richin nic'oje' quik'ij. Queri' xubij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ri Jesús y ri cablajuj rutijoxela' y ri ch'aka' chic vinek e benek quiq'uin, quichapon-el ri bey nibe pa tinamit Jerusalem. Y jari' tok ri Jesús xeruch'er-el juba' ri rutijoxela' roma c'o c'a ri nrajo' nubij chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Rija' xubij c'a: Rix ivetaman chi pa tinamit Jerusalem kachapon-vi-el bey, y ja ri chiri' ri xquijach-vi-el yin ri xinalex chi'icojol. Xquijach-el pa quik'a' ri principal-i' tak sacerdotes y ri etamanela' chirij ri ley. Y rije' xtiquibij c'a chi tika' ri camic pa nuvi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Y chuka' xquinquijech-el pa quik'a' vinek ri xa man e israelitas ta. Y ri vinek man e israelitas ta xquinquitze'ej, xquinquich'ey y c'ari' xquinquibajij chuva ri cruz richin yiquen (yicom). Pero pa rox k'ij xquic'astej-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Y ri e ca'i' tijoxela' ri e ruc'ajol ri achin rubini'an Zebedeo, xejel-apo riq'uin ri Jesús, cachibilan ri quite'. Y ri quite' xxuque' c'a ka chuvech ri Jesús richin chi nuc'utuj jun utzil chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ri Jesús xubij c'a chire ri te'ej ri': ¿Achique c'a ri navajo'? xcha' chire. Y ri ixok xubij c'a chire ri Jesús: Yin ninvajo' c'a chi tok c'o chic ri utzilej ak'atbel-tzij, can tabana' c'a chi re ca'i' val re' yetz'uye' ta apo aviq'uin; jun ta c'a ri pan avajquik'a' y jun ta ri pan avajxocon (izquierda). Can tabana' chique chi nic'oje' ta quik'ij, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Y jac'ari' tok ri Jesús xubij: Rix man ivetaman ta c'a chi c'ayef chive ri nic'utuj. Y romari' yin ninc'utuj c'a chive vacami: ¿Nicoch' cami rix achi'el ri xtiban chuve yin? ¿Y nicoch' cami chuka' rix jun tijoj-pokonal achi'el ri xtika' pa nuvi' yin? Roma ronojel c'a re xtik'ax pa nuvi', xa achi'el jun c'ayevalej bautismo, xcha' ri Jesús. Y ri ca'i' tijoxela' ri e ral ri ixok xquibij c'a: Nikacoch', xecha' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Y ri Jesús xubij chic c'a chique: Can kitzij vi c'a chi rix xticoch' na vi achi'el ri xtiban chuve yin. Chuka' can xticoch' jun tijoj-pokonal achi'el ri xtika' pa nuvi' yin; ri xa xtik'ax pa nuvi' achi'el jun c'ayevalej bautismo. Xa jac'a ri nibij, chi rix nivajo' chi jun nitz'uye' pa vajquik'a' y jun ri pa vajxocon (izquierda), ri' man pa nuk'a' ta c'a yin c'o-vi richin chi ninya' chive. Roma ri nic'utuj rix, ri' xa quichin chic c'a ri xtubij ri Nata' chi utz chi yetz'uye' chiri', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Y jac'a tok ri lajuj chic tijoxela' xcac'axaj ri xbitej, xpe c'a coyoval chique ri e ca'i' tijoxela' ri can cach'alal qui'. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Can jac'ari' tok ri Jesús xeroyoj ri rutijoxela' y xubij c'a chique: Yin ninbij chi rix jebel ivetaman chi re vave' chuvech re ruvach'ulef ri k'atoy tak tzij, roma can ec'o c'a ri vinek pa quik'a', romari' can niquina' chi ja rije' ri e cajaf. Xa can xe c'a ri c'o quik'ij ri yebin ri c'o chi niban. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Jac'a ri chi'icojol rix man que ta ri'. Roma ri nrajo' c'a nic'oje' ruk'ij chive rix, nic'atzin chi nuna-ka-ri' chi xa manek ruk'ij y tuch'utinirisaj-ri' richin nusuj-ri' chubanic xabachique samaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Vi jun c'a chive rix can nrajo' chi ja rija' ri nabey y c'o ta ruk'ij, can tuna' c'a ri' chi xa manek ruk'ij y tuch'utinirisaj-ri' richin chi nusuj-ri' chubanic xabachique samaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Can c'o c'a chi nuben achi'el ri ninben yin, ri xinalex chi'icojol. Yin man ninpokonaj ta yisamej coma ri ch'aka', roma can richin ri' tok xipe; y man xipe ta c'a richin chi ec'o chic ch'aka' yebanon-pe ri ninbij chique. Can jac'a yin ri yibanon ri samaj, y can jac'a yin ri yiyo'on ri nuc'aslen richin queri' e q'uiy ri yecolotej, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ri Jesús y ri rutijoxela' jac'ari' tok niquiya' can ri tinamit rubini'an Jericó, y e janíla c'a e q'uiy vinek ri e tzekelbeyon-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Can jac'ari' tok e ca'i' moyi' e tz'uyul chuchi' ri bey xcac'axaj c'a chi ri Jesús jari' ri nik'ax-el queri', y rije' riq'uin cuchuk'a' xech'on y xquibij c'a: Rat Ajaf, ri at riy-rumam can ri rey David, tajoyovaj c'a kavech roma re kabanon, xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Y ri vinek xquibila' c'a chique chi man chic quech'on. Pero rije' xa riq'uin más cuchuk'a' xech'on y xquibij: Rat Ajaf, ri at riy-rumam can ri rey David, tajoyovaj c'a kavech roma re kabanon, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Y ri Jesús xrac'axaj c'a ri quich'abel. Romari' xpa'e-ka y xeroyoj. Y c'ari' xubij c'a: ¿Achique c'a nivajo'? xcha' ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Rije' xquibij c'a chire ri Jesús: Ajaf, roj nikajo' c'a yojtzu'un, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ri Jesús roma c'a janíla xujoyovaj quivech ri ca'i' achi'a' moyi' ri', can jac'ari' tok xuchop ri runak' tak quivech, y rije' xetzu'un c'a. Y rije' xetzeke' chuka' el chirij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Y ri Jesús, ri rutijoxela' y ri ch'aka' chic vinek e benek quiq'uin, nakaj chic c'a ec'o-vi-apo chire ri tinamit Jerusalem. Chiri' chic c'a pa Betfagé ec'o-vi, ri c'o-apo chuvech ri juyu' rubini'an Olivos. Y xpe c'a ri Jesús xerutek c'a el e ca'i' rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Rija' xubij c'a el chique: Quixbiyin-apo chupan la ti tinamit la nitzu-apo chila', y can ja yan ri xquixoc-apo, jari' xtivil jun alaj burro c'o chiri' riq'uin ri rute'. Tisolo-pe ri te'ej y que'ic'ama-pe che ca'i' chuve. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Y vi c'o c'a ri xtibin-pe chive achique nic'atzin-vi chi ye'iq'uen-pe, tibij c'a can chire: Nic'atzin chire ri Ajaf, pero xque'orutzolij can chanin, quixcha' can, xe'uche'ex-el roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Can nibanatej na c'a achi'el ri tz'iban can roma ri jun ri xk'alajirisan ri ruch'abel ri Dios ojer can. Ri rutz'iban c'a can rija', nubij: ");
INSERT INTO cakCNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tiya' c'a rutzijol chique ri e richin chic ri tinamit rubini'an Sión, chi ri qui-Rey jac'are' petenek. Ri qui-Rey can ch'uch'uj vi c'a ránima. Y rija' ch'ocol-pe chirij jun burro. Can chirij vi c'a jun alaj burro ch'ocol-vi-pe rija'. Ri alaj burro ral c'a jun samajel chicop. Queri' c'a ri tz'ibatel can. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Y ri ca'i' tijoxela' xebe c'a, y xquiben-vi ri bin-el chique roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xquiq'uen c'a pe ri alaj burro rachibilan ri rute', chire ri Jesús. C'ari' ri tijoxela' xquirip-el ri quik'u' chiquij ri ca'i' chicop ri', richin chi ri Jesús nich'oque' c'a el. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Y ri e benek chirij ri Jesús can janíla vi e q'uiy. Y jubama conojel chique rije' ri xquiriq'uila' ri quik'u' pa rubey ri Jesús richin chi niquiya' ruk'ij. Y ch'aka' chic vinek richin chi niquiya' chuka' ruk'ij ri Jesús xebequic'amala-pe ruk'a' tak che' richin vikobel (vekobel), richin chi xquiric' pa rubey. Y que c'a ri' niquibanala' e benek. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Y ri vinek ri e nabey chuvech ri Jesús y ri ec'o can chirij, can riq'uin c'a ronojel cuchuk'a' niquibij: ¡Matiox chi petenek ri riy-rumam can ri rey David! ¡Rija' urtisan-pe roma ri Ajaf Dios! ¡Petenek c'a pa rubi' ri Ajaf Dios! ¡Matiox chire ri Dios ri c'o chila' chicaj! yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jac'a tok ri Jesús noc-apo ri pa tinamit Jerusalem, xepe c'a ri vinek y xquimol-qui' chanin chutz'etic ri Jesús. Y ri vinek ri' niquibila' c'a: ¿Achique c'a achin re'? yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pero ec'o c'a ri xebin: Re' jare' ri Jesús, ri nik'alajirisan ri nibix chire roma ri Dios. Rija' aj pa tinamit Nazaret; tinamit ri c'o chiri' pa Galilea, yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Y ri Jesús xapon c'a pa rachoch ri Dios ri c'o pa tinamit Jerusalem. Y roma xutz'et chi achi'el c'ayibel quibanon ri vinek chire, xerokotaj c'a pe conojel, chi c'ayinel chi lok'onel. Y chique ri jaloy-ruvech mero, xerutec'mayila' can ri qui-mesas. Y que chuka' ri' xuben can chique ri quich'acat ri c'ayil tak palomas. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ri Jesús xubij c'a chique ri vinek ri': Chupan ri ruch'abel ri Dios ri tz'ibatel can, nubij chi ri vachoch, jay richin oración. Jac'a rix xa achi'el quijul elek'oma' ibanon chire, xcha' ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Y tok ri Jesús c'o c'a pa rachoch ri Dios, ec'o c'a vinek e moyi' y ec'o chuka' ri man can ta yetiquir yebiyin roma ri e jetz', ri xe'apon riq'uin rija', richin ta yeruc'achojirisaj-el. Y rija' can que c'a ri' ri xuben; can xeruc'achojirisaj-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jac'a ri principal-i' tak sacerdotes y ri etamanela' chirij ri ley xpe coyoval, roma ri Jesús q'uiy milagros ri yerubanala', y roma chuka' ri tak alabon riq'uin c'a cuchuk'a' niquibila' ri chiri' chuva-rachoch ri Dios: ¡Matiox chi xoka' ri riy-rumam can ri David! yecha'. Y jac'ari' ri xyacon coyoval. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Xepe ri principal-i' tak sacerdotes y ri achi'a' etamanela', xquibij c'a chire ri Jesús: ¿Navac'axaj c'a ri ye'ajin chubixic ri ac'uala'? xecha'. Y xpe ri Jesús xubij chique ri achi'a' ri': Ja', ninvac'axaj. Y rix ¿man itz'eton ta cami chupan ri ruch'abel ri Dios ri nubij-vi, chi ri kitzij yeyo'on ruk'ij ri Dios ja ri ac'uala' y ri c'a yetz'uman na? xcha' ri Jesús chique ri achi'a' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Y ri Jesús xeruya' c'a can chiri' ri achi'a' ri'. Rija' xel-el ri pa tinamit Jerusalem y xbe c'a pa tinamit Betania. C'a chiri' c'a xbe-vi richin xbe'uxlan can ri junak'a' ri', rachibilan ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Y nimak'a' ruca'n k'ij, tok quichapon bey richin yetzolin pa tinamit Jerusalem, ri Jesús xpe vayjal chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Y tok e benek, rija' xutz'et c'a jun víquix (higo) tiquil chunakaj ri bey. Xbe-apo chuxe' chucanoxic ruvech, pero xa man jun ti ruvech c'o, xa ruyon ruxak. Jac'ari' tok ri Jesús xch'on chire ri che' y xubij c'a: Man jun bey chic c'a xcavachin. Y ri víquix ri' can xchaki'j-vi-ka. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tok ri rutijoxela' ri Jesús xquitz'et chi chaki'j chic ri víquix, xquibila' chiquivech: ¿Can chanin ta cami c'a xchaki'j-ka re víquix re'? yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Xpe ri Jesús xubij c'a chique: Can kitzij ninbij chive: Vi rix can nicukuba' ic'u'x y chuka' can man nipe ta pan ivánima chi xa man nibanatej ta la'ek re', can xquixtiquir c'a niben quere' chire jun víquix. Y c'o ta banobel más nima'k ri yixtiquir niben, que chuvech re jun re'. Yixtiquir ta nibij chire re juyu' re' chi tel-el vave' y tik'ax chupan ri nimalej ya' rubini'an mar, y can queri' ta ri nibanatej. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Can ronojel vi c'a ri nic'utuj chire ri Dios riq'uin ronojel ic'u'x, can xtic'ul-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Y tok ri Jesús c'o chic pa rachoch ri Dios y nuc'ut chic ri ruch'abel ri Dios chiquivech ri vinek, ri principal-i' tak sacerdotes y ri rijita'k tak achi'a' ri janíla quik'ij chiquicojol ri vinek, xe'apon-apo riq'uin y xquic'utuj c'a chire ri Jesús: ¿Achique xyo'on k'atbel-tzij pan ak'a' richin xe'avokotaj-el ri vinek c'ayinela' re pa rachoch ri Dios? ¿Y achique chuka' yoyon k'ij chave richin chi q'uiy ri ye'abanala' chiquicojol ri vinek? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Xpe ri Jesús xubij c'a chique ri achi'a' ri': Yin c'o c'a chuka' jun ri ninvajo' ninc'utuj chive, y riq'uin c'a xtibij chuve re', yin chuka' xtinbij chive achique yoyon uchuk'a' pa nuk'a' richin yenbanala' que tak re'. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Y jari' tok ri Jesús xuc'utuj c'a: ¿Ri Juan xtak-pe roma ri Dios richin xeruben bautizar ri vinek? ¿O xa vinek xebin chire chi tubana' queri'? xcha' ri Jesús. Y ri principal-i' tak sacerdotes y ri rijita'k tak achi'a' ri c'o quik'ij xquibila' c'a chiquivech: ¿Achique c'a xtikabij chire re Jesús vacami? xecha-ka. Roma vi nikabij chi ri Juan ja ri Dios ri takayon-pe richin, ri Jesús xtubij c'a chike chi achique c'a roma tok man xinimaj ta: ");
INSERT INTO cakCNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y vi nikabij chi xa vinek xebin chire ri Juan chi tubana' queri', c'ayef chike roj, roma ri vinek yeyacatej chikij. Roma conojel vinek can quetaman-vi chi ri Juan can xuk'alajirisaj-vi ri xbix chire roma ri Dios, xecha' c'a ka chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Y c'ari' xquibij-apo chire ri Jesús: Roj man ketaman ta, xecha-apo. Y ri Jesús can jac'a chuka' ri' xubij chique ri achi'a' ri': Roma c'a rix man xixtiquir ta xibij chuve, que c'a chuka' ri' yin man xtinbij ta chive achique yoyon k'ij chuve richin yenbanala' quere', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","C'ari' ri Jesús xubij chic c'a chique ri achi'a' ri': Can quixch'obon-vi c'a jebel roma ri xtinbij chive. C'o c'a jun achin ec'o ca'i' ruc'ajol. Y re tata'aj re' xapon c'a riq'uin ri jun ruc'ajol nabey, y xubij chire: Vacami, cabiyin pa samaj, ri acuchi katicon-vi-ka uva, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Xpe ri c'ajolaxel ri' xubij c'a chire ri rutata': Vacami man ninvajo' ta yibe pa samaj, xcha'. Y c'ari' xtzolin-pe ruc'u'x roma ri ch'abel ri xubij y xbe c'a pa samaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Y ri tata'aj xapon c'a chuka' riq'uin ri jun chic ruc'ajol, y xubij chire chi tibe pa samaj. Y ri c'ajolaxel ri' xubij chire ri rutata': Táta, jare' yibe, xcha'. Pero ri c'ajolaxel ri' xa man xbe ta pa samaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Y c'ari' ri Jesús xuc'utuj: ¿Achique chique ri ca'i' ri xbanon ri rurayibel ri rutata'? xcha'. Y ri achi'a' ri' xquibij c'a: Ri xbanon ri rurayibel ri rutata' ja ri nabey, xecha'. Y ri Jesús xubij c'a chique: Can kitzij c'a ninbij chive chi xa ja ri moloy tak alcaval y ri ixoki' ri man utz ta c'aslen quic'uan, jari' ri xque'ic'o-el chivech, roma nitzolej-pe quic'u'x. Xa ja chic c'a rije' ri nabey ye'oc pa rajavaren o pa ruk'a' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ri Juan ri Bautista tok xpe, jun chojmilej bey c'a ri xuc'ut chivech, jac'a rix man xinimaj ta. Xaxe c'a ri moloy tak alcaval y ri ixoki' ri man utz ta quic'aslen, xaxe rije' ri xeniman. Jac'a rix, man riq'uin ri' can man xtzolin ta pe ic'u'x riq'uin ri Dios y xinimaj ta chuka'. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Y tivac'axaj na pe' jun chic c'ambel-tzij, xcha' ri Jesús chique ri vinek: Xc'oje' c'a jun achin ri can tata'aj chic, xpe rija' xutic c'a ruvech ri rulef riq'uin uva y xuc'ojoj rij ri rulef. Xuben chuka' achi'el jun ti pila ri pan ulef ri richin niyitz' ri uva, y jun chuka' tz'ak ri nej jotol, y pa ruvi' ri' xc'oje-vi rachoch ri chajinel. C'ari' xuya' can pa kajic chique ca'i-oxi' samajela', y rija' xbe nej. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Y jac'a tok xapon yan ri tiempo richin niban ri vuxuj-uva, ri rajaf ri ulef xutek nabey jun raj-ic' achin, c'a juba' ri' jun chic. Y queri' e q'uiy ri rajic'a' ri xerutek richin ta chi xbequic'ulu-pe ri ruvech ri uva kajbel richin ri ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero ri achi'a' kajoy tak ulef, xa man xequic'ul ta jebel ri achi'a' ajic'a', ri e takon-el roma ri rajaf ri ulef. Xa ec'o xequich'ey, ec'o xequiq'uek chi abej y ec'o xequicamisaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Xpe ri rajaf ri ulef xerutakala' c'a ch'aka' chic achi'a' ri e rajic'a'. Can más vi c'a e q'uiy ri xerutakala-el re bey re'. Pero ri achi'a' kajoy tak ulef ja mismo ri xquibanala-pe chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Y pa ruq'uisibel, ri rajaf ri ulef xuch'ob y xubij c'a: Ri achi'a' kajoy-ulef can xqueniman-vi c'a tok xtiquitz'et chi can ja ri c'ajolaxel ri napon, xcha-ka rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero ri achi'a' ri e kajayon ri ulef, can xe xquitz'et chi ja ri ruc'ajol ri rajaf ri ulef ri xapon, xquibila' c'a chiquivech: Jare' ri xtichinan can ronojel re ulef re kakajon vacami. ¿Achique roma man nikacamisaj? Richin queri' pa kak'a' roj nic'oje-vi can re ulef, xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Y can que vi c'a ri' xquiben. Xquichop y c'ari' xquelesaj-pe ri c'ajolaxel ri chiri' chupan ri rulef y xquicamisaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","C'ari' ri Jesús xubij: Tok xtipe ri rajaf ri ulef ri tiquil uva chuvech, ¿achique cami xtuben chique ri achi'a' kajoy tak ulef, nich'ob rix? xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Y ri vinek xquibij c'a: Ri rajaf ri ulef man c'a xtujoyovaj ta quivech ri itzel tak achi'a' kajoy-ulef y xqueruq'uis; y c'ari' ri rulef xtuya' chic can pa kajic chique ch'aka' chic achi'a' kajoy tak ulef, ri can xtiquiya-vi ri uva kajbel richin ri ulef tok napon ri tiempo, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Xpe ri Jesús xubij c'a chique: ¿Can man jun bey c'a itz'eton ri jun tzij tz'ibatel can chupan ri ruch'abel ri Dios? Ri tzij ri' nubij c'a: C'o c'a jun abej ri man xka' ta chiquivech ri ch'aka' banoy tak jay. Pero re abej re' can xch'acon-vi, roma re abej re' xa can c'o-vi ri xucusan chire ri jay richin chi ri jay ri' man nitzak ta. Can ja vi ri Ajaf xbanon re', y ri runak' tak kavech can man jun bey c'a quitz'eton chi nibanatej ta quere'. Queri' nubij ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Y roma c'a ri e banatajinek, rix man chic xquixc'oje' ta pa rajavaren o pa ruk'a' ri Dios; ri xquec'oje' pa rajavaren o pa ruk'a' ri Dios xa ja ri ch'aka' chic vinek ri can xtivachin-vi ri quic'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ri vinek c'a ri xtitzak chuvech ri abej ri xucusex chire ri jay, can xtuvulaj-ri' chuvech. Y ri vinek ri xtika' ri abej ri' chirij, can xtuque'ej c'a, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Y tok ri principal-i' tak sacerdotes y ri achi'a' fariseos cac'axan chic ka ri c'ambel tak tzij ri xerutzijoj ri Jesús, can xk'ax-vi chiquivech chi chiquij rije' xch'on-vi-ka. ");
INSERT INTO cakCNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Y jari' tok rije' xcajo' c'a xquichop yan el ri Jesús. Pero man xquiben ta roma xa niquixibij-qui' chiquivech ri vinek; roma chiquivech ri vinek, ri Jesús can k'alajirisey vi ruch'abel ri Dios y nubij chuka' chique ri xquebanatej ri más chiquivech apo. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Y ri Jesús xuchop chic c'a nich'on quiq'uin ri vinek, y xerucusaj ch'aka' chic c'ambel tak tzij. Rija' xuchop c'a rubixic: ");
INSERT INTO cakCNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Jun nimak'ij ri xuben jun rey chire ri ruc'ajol tok xc'ule', can junan c'a riq'uin tok ri vinek ye'oc pa ruk'a' ri Dios o tok ye'oc chupan ri aj-chicajil ajavaren. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Y ri rey ri' can ec'o-vi chic ri rubin chique chi ye'apon chupan ri jun c'ulubic ri', y romari' xerutek c'a ri rusamajela' chicoyoxic ri vinek ri'. Jac'a ri xe'oyox man chic xcajo' ta xebe. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Y ri rey xerutek chic el ch'aka' rusamajela' y xubij-el chique: Tibij chique conojel ri nuyo'on rutzijol chique chirij re jun nimak'ij re', chi ronojel c'o chic richin nikaben ri va'in. Ri achij tak nuváquix y ri ch'aka' chic chicop ri xentiojirisaj richin yec'atzin chupan re k'ij re', xechojmirisex yan y c'o chic richin yetij. Can ronojel c'a c'o chic, quixcha' chique. Chi can quepe c'a chupan re jun c'ulubic re', xcha-el chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero ri xe'oyox, man xeniman ta pe riq'uin ri xbebix chic jun bey chique. Ec'o la' xa xebe pa tak quisamaj ri pa juyu'; y ec'o xa xebe pa tak quic'ayij. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jac'a ri ch'aka' chic xequichop ri samajela' e rutakon-el ri rey, y xequicamisaj; roma chiquivech rije' ri samajela' ri' xa man jun quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jac'a tok xapon rutzijol riq'uin ri rey ri achique xbanatej, jac'ari' xbanon chi rija' xyacatej royoval. Can jac'ari' tok rija' xerutek achi'a' e banoy-oyoval chiquij richin chi xeruq'uis c'a ri e camisanela' quichin ri rusamajel rija', y chuka' can xubij chi tiporox c'a ri quitinamit. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","C'ari' c'a ri rey xch'on chic quiq'uin ri rusamajela' jun bey y xubij c'a chique: Can kitzij vi chi ronojel chic c'o richin nibanatej ri c'ulubic, xa jac'a ri xenvoyoj man xe'oka' ta, y xa can más c'a utz xuben chi man xepe ta, roma xa can man ruc'amon ta vi chi xe'oka' ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Vacami c'a, quixbiyin ri pa tak bey ri yebe juc'an chic y que'ivoyoj-pe conojel richin chi yepe chupan re c'ulubic vave', xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Y tok ri samajela' can xebe na vi ri pa tak bey ri yebe juc'an chic, xecoyoj y xequimol-vi c'a pe ronojel quivech vinek, chi utz y man utz ta quic'aslen chiquivech ri vinek. Y ri jay ri xban-vi ri c'ulubic, xnoj. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Y ri rey xoc c'a apo chiquitz'etic conojel ri xeroyoj. Y rija' xutz'et c'a chi c'o c'a jun achin ri chiri' ri man rucusan ta el ri rutziak ri nic'atzin chupan ri jun c'ulubic ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ri rey xch'on c'a riq'uin ri achin ri', ri can royon-vi chuka' chupan ri jun c'ulubic ri', y xuc'utuj c'a chire: Y rat ¿achique c'a xaben richin xatiquir xatoc-pe vave'? Tok xa man ja ta ri tziek ri nic'atzin chupan re jun c'ulubic re' ri acusan ta pe, xcha' ri rey chire. Y ri achin man jun ch'abel xtiquir xubij, xa xmemur c'a chuvech ri rey. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Y ri rey jac'ari' tok xubij chique ri rusamajela': Tixima-el ruk'a-raken re jun achin re xa man rucusan ta pe rutziak ri nic'atzin chi rucusan ta pe, y te'ic'aka' can c'a quela' pa k'eku'n. Ri chiri' xaxe c'a ok'ej y kach'ach'en eyaj c'o. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Y stape' can e q'uiy vi c'a ri ye'oyox, can man conojel ta c'a ri xquechatej can richin chi ye'oc pa rajavaren o pa ruk'a' ri Dios, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Y jac'ari' tok ri achi'a' fariseos xebe. Rije' xbequiya' c'a chiquivech richin achique ta jun niquiben richin chi ri Jesús nitzak ta pa quik'a' riq'uin ri nubij. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jac'ari' tok rije' xequitek ri quitijoxela' e cachibilan-el e ca'i-oxi' ruvinak ri rey Herodes. Xequitek-el c'a riq'uin ri Jesús; y rije' xbequibij c'a chire ri Jesús tok xe'apon riq'uin: Rat ri at jun Tijonel, roj can ketaman c'a chi xaxe vi c'a ri kitzij ri nika' chavech y jari' ri natzijoj. Can nac'ut-vi ri ruch'abel ri Dios pa rubeyal. Y rat man naxibij ta chuka' avi' chuvech jun vinek, stape' can janíla ta ruk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Y vacami nikajo' c'a nikac'axaj achique ri xtabij chike. Roma ri pa kach'obonic ka roj nikabij: ¿Ruc'amon cami chi nikatoj ri alcaval ri nubij ri rey César ri c'o chi nikatoj o xa man ruc'amon ta? xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero ri Jesús can retaman-vi c'a ri niquinojij chirij. Romari' rija' xubij c'a chique: Rix xa ca'i' ipalej. ¿Achique c'a roma rix nitej ik'ij richin yinitejtobej? ");
INSERT INTO cakCNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tic'utu' c'a pe ri mero ri nucusex richin nitoj ri alcaval, xcha' chique. Y rije' can jac'ari' xquic'ut-apo ri mero chuvech; ri mero ri xquic'ut-apo jac'a ri niquibij denario chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Y ri Jesús jac'ari' xuc'utuj chique: ¿Achok vachibel c'a la'? ¿Y achok bi' chuka' la c'o chuvech la mero? xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Y rije' xquibij c'a chire ri Jesús: Richin ri rey César, xecha'. Y ri Jesús xubij c'a chique: Titojo' c'a ri alcaval chire ri César riq'uin ri mero ri ruc'amon chi niya' chire rija'. Y tiya' chire ri Dios, ronojel ri ruc'amon chi niya' chire rija', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Y tok ri achi'a' ri' cac'axan chic ka ri xubij ri Jesús, can achique la xquina' tok xcac'axaj. Y rije' xquiya' c'a can ri Jesús. Rije' xebe c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Y ja k'ij ri' tok ch'aka' chique ri achi'a' saduceos xe'apon riq'uin ri Jesús. Re achi'a' re' man niquinimaj ta chi ri caminaki' xquec'astej chic pe. Rije' xe'apon c'a, roma c'o ri nicajo' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Rije' xquibij c'a chire ri Jesús: Rat ri at jun Tijonel chuka', c'o c'a jun ri nikajo' nikac'utuj chave. Ri Moisés can rutz'iban-vi c'a can chike: Vi c'o c'a jun achin nuya' can ri rixjayil roma rija' niquen-el (nicom-el) y man jun ralc'ual nic'oje' can, can jun c'a rach'alal rija' ri c'o chi nic'ule' riq'uin ri malca'n-ixok, richin queri' yec'oje' ta ralc'ual riq'uin ri ixok malca'n. Y vi can ec'o ralc'ual yec'oje' riq'uin ri ixok, ri nabey ala' noc ralc'ual ri caminek chic el. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Y rije' xquibij c'a: Y que c'a ri' xec'oje' e vuku' achi'a' cach'alal qui'. Ri nabey xc'ule' c'a. Pero ri achin ri' xquen-el (xcom-el) y man jun ralc'ual xc'oje' ta can. Ri rixjayil ri achin ri' xc'oje' c'a can chire ri rach'alal. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ri ruca'n achin can que c'a chuka' ri' xuc'ulvachij-el, rija' xquen-el (xcom-el) y man jun ralc'ual xc'oje' can. Ri rox achin can ja chuka' ri' xuc'ulvachij-el, achi'el ri ca'i' nabey tak rach'alal y ri ixok c'a xc'oje' na can. Y que c'a ri' xquic'ulvachila-el, c'a riq'uin ri ruq'uisibel achin chique ri e vuku' cach'alal qui'. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Y tok can e caminek chic c'a el ri vuku' achi'a' cach'alal qui' chuvech ri ixok ri', chuka' rija' xquen c'a el (xcom c'a el). ");
INSERT INTO cakCNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Y ri achi'a' saduceos xquibij c'a chire ri Jesús: Rat nabij chi xtapon jun k'ij tok ri caminaki' xquec'astej-pe. Tok xtapon c'a ri k'ij ri', ¿achok ixjayil c'a xtoc re ixok re'? Roma che vuku' achi'a' cach'alal qui' xec'oje' riq'uin, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Can jac'ari' tok ri Jesús xubij chique ri achi'a' ri': Rix xa ix sachinek riq'uin ri xibij. Ri ruch'abel ri Dios jun vi chic ri nubij. Y can man ivetaman ta c'a chuka' chi ri ruchuk'a' ri Dios janíla nim. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Roma tok xtapon ri k'ij chi ri caminaki' xquec'astej-el, man xquec'ule' ta chic, ni man chuka' xqueyatej ta el quimi'al-quic'ajol richin yec'ule'. Rije' xa xque'oc c'a achi'el ri ru-ángeles ri Dios chila' chicaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Jac'a ri c'astajibel quichin ri caminaki', can c'o-vi. ¿Man itz'eton ta c'a ri ruch'abel ri Dios ri yo'on can pan ik'a'? Chupan ri' ri Dios can nubij-vi c'a chive: ");
INSERT INTO cakCNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Jac'a yin ri ru-Dios ri Abraham, ri ru-Dios ri Isaac y ri ru-Dios chuka' ri Jacob. Can que c'a ri' ri xubij ri Dios ojer can. Y xa ta ri kati't-kamama' ri' e caminaki' ta el richin jantape', ri Dios man ta qui-Dios rije', roma xa man xquec'astej ta chic pe. Ri Dios can qui-Dios vi ri c'o quic'aslen y xa man quichin ta ri caminaki', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Y tok ri vinek cac'axan chic ri tijonic ri xuya' ri Jesús, can achique la xquina' tok xcac'axaj, roma man jun bey cac'axan ta ch'abel queri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Y ri achi'a' fariseos can chanin c'a xquimol-qui' chuch'obic achique ri xtiquiben, tok xcac'axaj chi ri Jesús can xutz'apej-vi c'a quichi' ri achi'a' saduceos riq'uin ri xubij. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Xpe c'a jun chique ri achi'a' fariseos, ri can etamanel vi richin ri ru-ley ri Moisés, xaxe c'a richin nutejtobej ri Jesús, xuc'utuj c'a chire: ");
INSERT INTO cakCNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Rat ri can at Tijonel vi, tabij c'a chuve, ¿achique c'a chique ri pixa' ri xuya' ri Dios pa ruk'a' ri Moisés, ri más rejkalen? ");
INSERT INTO cakCNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Y ri Jesús xubij chire: Ri pixa' ri' ja ri tavajo' c'a ri Dios ri Avajaf. Tavajo' riq'uin ronojel avánima. Tavajo' c'a chupan ronojel ri ac'aslen, y riq'uin ri anojibal. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Can jac'ari' ri nabey y nimalej pixa' ri c'o chupan ri ley. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Y c'o chuka' jun ruca'n pixa' ri janíla rejkalen y jubama junan riq'uin ri nabey. Y ri pixa' ri' nubij c'a: Can achi'el navajo-ka-avi' rat, can que c'a chuka' ri' que'avajo' ri ch'aka' chic. Queri' nubij ri pixa' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Can ronojel vi c'a ri nubij ri ley richin ri Moisés y ronojel c'a ri quibin can ri achi'a' ri xek'alajirisan ri xbix chique roma ri Dios ojer can, can chupan c'a ri ca'i' pixa' ri' petenek ruxe'. Ca'i' c'a pixa' ri janíla quejkalen, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Y tok can c'a quimolon y quic'uan na qui' ri achi'a' fariseos, xpe ri Jesús can c'o c'a ri xuc'utuj chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Rija' can xuc'utuj c'a chique: ¿Achique c'a nich'ob rix chirij ri Cristo? Tok rija' xtipe, ¿achok alc'ual rija'? Y ri achi'a' fariseos xquibij c'a: Richin ri rey David, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Y ri Jesús xubij c'a chique: ¿Pero achique c'a roma tok ri rey David xubij Vajaf chire ri Cristo? Roma xa can xk'alajirisex chire roma ri Lok'olej Espíritu; y romari' can xubij c'a: ");
INSERT INTO cakCNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ri Ajaf Dios xubij c'a chire ri Vajaf ri Cristo: Catz'uye-pe re pa vajquik'a' y xquenya' pan ak'a' ri ye'etzelan avichin. Queri' xubij. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Y vi ri rey David, Vajaf nicha' chire ri Cristo, ¿achique c'a roma tok nibix chi ri Cristo xa choj jun riy-rumam can ri rey David? xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Y man jun c'a ri xbin ta apo jun ch'abel chire ri Jesús, richin nubij ta apo ri xuc'utuj ri Jesús chirij ri Cristo. Can jac'a k'ij ri' tok xuchop-el chi man jun chic xbanon covil richin c'o ta ri nuc'utuj chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Y ri Jesús jac'ari' tok xch'on chiquivech ri vinek y chuka' xch'on quiq'uin ri rutijoxela'. Rija' xubij c'a: ");
INSERT INTO cakCNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Pa ruq'uexel c'a ri Moisés, e tz'uyul ri achi'a' ri e etamanela' chirij ri ley y ri achi'a' fariseos. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Roma c'a ri' rix can tinimaj quitzij. Can ronojel c'a ri niquibij chive, tibana' y tichajij. Pero man tiben c'a achi'el ri niquiben rije'. Roma rije' xa man yetiquir ta niquiben ri niquibij chi tiban. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rije' nimalej tak ejka'n niquiya' chiquij ri vinek, ejka'n ri can c'o calal y c'ayef quic'uaxic. Ri ejka'n ri' xaxe c'a chiquij ri vinek niquiya-vi y rije' man niquisiloj ta jun ti ruvi-quik'a' richin ta niquiben y niquic'uaj ta ri ejka'n ri niquibij chi c'o chi niquic'uaj ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Y rije' niquibanala' c'a ri utz, pero man richin ta chi utz niquiben chuvech ri Dios. Xa man roma ta c'a ri' tok yequibanala'. Rije' xaxe richin chi quetz'et y quenimex coma ri vinek chi ja ri utz ri ye'ajin chubanic. Y can xe chuka' richin ri' tok janíla nima'k niquibanala' chire ri c'ojlibel ri niquic'uaj chirij ri quik'a' y ri nic'aj-quivech. C'ojlibel ri niquiyec-vi ri ch'aka' mocaj chire ri ruch'abel ri Dios. Y chuka' más nima'k raken niquibanala' chire ri retz'aba'l ruchi' tak quitziak. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Can ja chuka' oc ri nabey tak ch'aquet yecajo' ri pa nima'k tak va'in y ja chuka' ri' ri yequicha' pa tak nima-jay ri can nitzijox-vi ri ruch'abel ri Dios, richin queri' tibix chi rije' janíla quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Can janíla nika' chiquivech ri yek'ejelox can (yek'ijalox can) ri pa bey ri acuchi nequimolo-vi-qui' ri vinek. Y chuka' can janíla nika' chiquivech chi nibix can chique coma ri vinek: Tijonel, Tijonel, yecha' chique roma c'o quik'ij yequitz'et. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jac'a rix man tivajo' nibix tijonel chive, roma xa can xe c'a Jun ri c'o ri ruc'amon chi nibij Tijonel chire, y ri' ja ri Cristo. Jac'a rix chi'ivonojel, ivach'alal ivi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chuka' man roma ta chi ri vinek c'o ruk'ij, roma ta ri' rix nibij ta katata' chire. Man tiben queri'. Roma ri Tata'aj xa Jun c'a ri c'o pa kavi' konojel, y ri' ja ri aj-chicajil Itata'. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Can man tivajo' c'a chi ri vinek niquibij tijonel chive. Roma xa can xe Jun ri Tijonel c'o y ri' ja ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Roma ri más nim ruk'ij chive rix, nic'atzin chi nuna-ka-ri' chi xa manek ruk'ij y tuch'utinirisaj-ri' richin nusuj-ri' chubanic xabachique samaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Roma ri niquinimirisaj-qui', xa xtikasex ri quik'ij. Y jac'a ri man niquinimirisaj ta qui', xtinimirisex quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Jac'a rix etamanela' y rix fariseos ri xa ca'i' ipalej, can tok'ex c'a ivech! roma xa can ik'aton c'a quibey ri vinek richin man ye'oc pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren. Can man utz ta c'a ri ibanon, roma man yixoc ta apo rix y chuka' man niya' ta k'ij chique ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Tok'ex c'a ivech rix etamanela' y rix fariseos ri xa ca'i' ipalej! roma rix xa nivelesala' ronojel qui-cosas ri malcani'a' tak ixoki'. Y xaxe richin chi tinimex chi jebel ic'aslen, yixyaloj c'a tok nibanala' oración chire ri Dios. Y roma c'a ri' tok rix más nim ruc'ayeval xtika' pan ivi', roma ri imac janíla q'uiy. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Tok'ex c'a ivech rix etamanela' y rix fariseos ri xa ca'i' ipalej! roma rix can nic'ovisala' ya' y nic'ovisala' ruvach'ulef chucanoxic vi c'o ta jun ri noc tzekelbey ivichin y nunimaj ta ri ninimaj rix. Xa jac'a tok ivilon chic ri achique xtitzekelben ivichin, rix xa c'ayef niben chire, roma riq'uin ri nic'ut chuvech, niben chire chi nej nibe-vi can chire ri Dios. Rix can nej c'a ixc'o-vi, pero rija' ca'i' bey más nej nibe-vi, y xa romari' tok can ruc'amon chi nibe pa k'ak' chuka' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Y chuka' can tok'ex c'a ivech rix ri yixbin chi ix uc'uey-bey y xa ix moyi'! Rix ri yixbin chi vi c'o jun ri ninatan ri rachoch ri Dios richin chi nuben jurar, stape' can man nuben ta ri rubin, man jun rubanon. Jac'a ri ninatan ri k'anapuek ri c'o pa rachoch ri Dios, richin chi nuben jurar, ri' can ruc'as chic c'a ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Rix can nic'ut-vi c'a chi ix nacanek y chuka' ix moyi', ¿roma achique c'a ri más ruk'ij? ¿Ja cami ri k'anapuek ri c'o pa rachoch ri Dios o xa can ja ri rachoch ri Dios ri nibanon lok'olej chire ri k'anapuek c'o chiri'? ");
INSERT INTO cakCNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Rix chuka' nibij: Ri ninatan ri altar richin chi nuben jurar, stape' can man nuben ta c'a ri rubin, man jun rubanon. Jac'a ri ninatan ri sipanic ri nic'oje' pa ruvi' ri altar, richin chi nuben jurar, can ruc'as chic c'a ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Can ix nacanek y ix moyirinek vi c'a, ¿roma achique c'a ri más ruk'ij? ¿Ja cami c'a ri sipanic ri nisuj pa ruvi' ri altar chire ri Dios o xa can ja ri altar? Ja ri altar ri más ruk'ij, roma jari' ri nibanon lok'olej chire ri sipanic. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ri ninatan c'a ri altar richin nuben jurar, can numej-vi c'a ronojel. Numej ri altar y numej chuka' ri sipanic ri nisuj pa ruvi' ri altar. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ri can ninatan c'a ri rachoch ri Dios richin chi nuben jurar, can numej c'a ronojel. Numej ri rachoch ri Dios y numej ri c'o chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Y ri ninatan c'a ri caj richin chi nuben jurar, can chuvech c'a ronojel ri c'o chila' nubij-vi ri'. Can numej-vi c'a ronojel. Numej c'a ri tz'uyul-vi ri Dios y can numej c'a chuka' ri Dios ri tz'uyul chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Xa can tok'ex-vi c'a ivech rix etamanela' y rix fariseos ri xa ca'i' ipalej! roma rix xaxe ri jubulej tak k'ayis, ri rubini'an menta, ri anís y ri comino ri ye'ich'ob. Roma ye'ivelesala' pa lajuj, y xa jujun c'a chique ri lajujtek ri' ri niya' chire ri Dios. Y xa iyo'on c'a can rubanic ri más nic'atzin ri nubij chupan ri ley, chi choj tibana' quiq'uin ri vinek, chi tic'oje' joyovanic iviq'uin y kitzij cukurinek ta ic'u'x riq'uin ri Dios. Jac'are' ri nabey ruc'amon ta ibanon, y c'a ta ri' ri can yixajin-vi chubanic. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Rix c'a ri yixbin chi ix uc'uey-bey, pero xa ix moyi', ninbij c'a chive, chi rix xaxe oc ri más tak cocoj pixa' ri yixajin chubanic y ri más e nima'k man e ibanon ta, xa iyo'on k'ij chi choj ye'ic'o. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Can tok'ex c'a ivech rix etamanela' y rix fariseos ri xa ca'i' ipalej! roma xa ix achi'el lek ri jebel ch'ajch'oj rij y ri rupan xa tz'il-tz'il. Rix can nic'ut c'a chiquivech ri vinek chi utz ri ibanobal, pero ri pa tak ivánima man que ta ri', roma xa nojinek riq'uin elek', y nojinek riq'uin itzel rayinic, roma rix can nirayij chi ronojel ri c'o quiq'uin ri vinek iviq'uin ta rix c'o-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Rix fariseos xa ix moyi'. Can tibana' c'a chire ri ic'aslen achi'el niben riq'uin ri lek, nich'ajch'ojirisaj rupan y ri rij. Rix tich'ajch'ojirisaj c'a ri ivánima nabey, richin queri' ri ic'aslen chiquivech ri vinek can ch'ajch'oj chuka' nik'alajin. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Tok'ex c'a ivech rix etamanela' y rix fariseos ri xa ca'i' ipalej! roma xa ix junan riq'uin jun tz'ak ri acuchi yo'on-vi jun caminek, ri rij sek y ch'ajch'oj, jac'a ri rupan man que ta ri'. Ri rupan xa ruyon man utz ta c'o y ruyon rubakil caminek. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Can ix que vi c'a ri' rix. Rix yixk'alajin c'a chi choj ri ic'aslen chiquivech ri vinek, jac'a ri pan ivánima xa man que ta ri'. Ri ivánima xa nojinek riq'uin etzelal. Y chuka' can ca'i' c'a ipalej. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Tok'ex c'a ivech rix etamanela' y rix fariseos ri xa ca'i' ipalej! roma jebel ye'ichojmirisala' ri tz'ak acuchi e mukul-vi ri achi'a' ri xek'alajirisan ri xbix chique roma ri Dios ojer can. Rix can jebel vi nivik (nivek) acuchi e mukul-vi ri chojmilej tak ralc'ual ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Y rix nibij c'a: Xa ta roj xojc'oje' pa qui-tiempo ri kati't-kamama', roj man ta xojoc cachibil rije' tok xequicamisaj ri achi'a' ri xek'alajirisan ri ch'abel ri xbix chique roma ri Dios, yixcha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pero xa can ja rix ri yixk'alajirisan-ka chivij chi ix quiy-quimam can ri xecamisan quichin ri achi'a' ri xek'alajirisan ri xbix chique roma ri Dios ojer can. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Can tibana' c'a chuka' rix c'a acuchi xapon-vi ri quibanobal ri ivati't-imama'. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Rix, xa achi'el itzel tak cumatzi'. ¿Can c'o ta cami c'a jun rubanic richin man ta yixbe pa k'ak' chuc'ulic ri rutojbalil ri ibanobal? Man jun. Rix can chiri' c'a xquixapon-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Y richin c'a chi rix nic'ut ri ivetzelal, yin jare' inc'o chic richin yentek-el chi'icojol, achi'a' ri yek'alajirisan ri nubij ri Dios chique, achi'a' ri janíla quina'oj y achi'a' ri c'o etamabel quiq'uin. Pero rix ec'o c'a chique ri nusamajela' ri xque'ibajij chuva tak cruz richin yequen (yecom), y ec'o ri choj queri' xtivelesaj quic'aslen. Ec'o c'a la' xque'ich'ey ri chiri' pa tak jay ri can richin vi nimol-ivi' richin ninic'oj ri ruch'abel ri Dios; y xabachique c'a tinamit yebe-vi rije', rix chuka' xquixapon chiri' roma c'o etzelal ri nivajo' niben chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Y ronojel re' can xtuben c'a chive chi ja rix yixejkalen ri quicamic conojel ri chojmilej tak vinek ri elesan quic'aslen. Ri xtiquir-pe riq'uin ri rucamic ri chojmilej achin xubini'aj Abel c'a riq'uin ri rucamic ri achin xubini'aj Zacarías, ri ruc'ajol ri achin xubini'aj Berequías. Y ninbij c'a chive, chi ri Zacarías can ja chuka' rix ri xixcamisan richin, chiri' chunakaj ri altar ri c'o chiri' chuva-rachoch ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Re xinbij c'a ka chive, can kitzij vi chi queri' xtibanatej. Can ronojel vi c'a ri' xtika' pa quivi' ri vinek ri ec'o chupan re tiempo re'. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","C'ari' ri Jesús xch'on c'a chiquij ri vinek ri ec'o pa Jerusalem. Rija' xubij c'a: Aj-Jerusalem, aj-Jerusalem, ¿achique c'a roma tok ye'icamisala' ri achi'a' ri yek'alajirisan ri nibix chique roma ri Dios? ¿Achique c'a roma chuka' tok ye'icamisala' chi abej ri yerutek-pe ri Dios chi'icojol? Y yin, can janíla c'a bey ri xinvajo' chi xixinmol ta viq'uin, achi'el nuben ri quite-ec' chique ri tak ral, yerumol chuxe' ri ruxic'. Man jun bey c'a xivajo' ta rix. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vacami c'a, ri ivachoch chi'ijujunal rix xtic'oje' can achi'el jun tz'iran ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Y que c'a ri' ri ninbij chive roma rix can jare' ruq'uisibel bey ri yinitz'et-el. Y xquinitz'et chic c'a jun bey c'a ja tok xtibij chuve: ¡Matiox chi petenek re Jun re'! ¡Rija' can urtisan-vi-pe roma ri Ajaf Dios! ¡Y petenek pa rubi' ri Ajaf Dios! C'a chupan c'a ri k'ij ri' tok xquinitz'et chic jun bey, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Y tok ri Jesús xel c'a pe ri chiri' pa rachoch ri Dios, richin chi nibe, ri rutijoxela' xejel c'a apo y c'o c'a ri xquibij chirij ri rachoch ri Dios y can xquic'utula' c'a chuka' chuvech riq'uin ri ruvi' tak quik'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jac'a tok rija' xch'on-apo chique ri rutijoxela', xubij c'a: Rix can ye'itzu' c'a chi re jay re' yalan e jebel. Pero yin can kitzij ninbij chive, chi xtapon c'a jun k'ij tok xa can xquevulex y man xquepa'e' ta chic can. Ronojel re nimalej tak abej re e ucusan chique re jay re', xa can xquec'akalox c'a pe. Can man jun c'a abej ri xtic'oje' ta can achi'el la rubanon vacami, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Y tok ri Jesús tz'uyul chic c'a pa ruvi' ri juyu' rubini'an Olivos, jac'ari' tok ri rutijoxela' xejel-apo riq'uin y xquic'utuj chire: Tabij c'a chike, ¿jampe' c'a xtic'ulvachitej ri xabij yan ka chirij ri rachoch ri Dios? ¿Achique c'a retal richin queri' ninabex ri ruca'n apetebel rat? ¿Y achique chuka' retal richin queri' ninabex chi napon yan ri ruq'uisibel k'ij richin re tiempo re'? xecha' c'a rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Y ri Jesús xubij chique ri rutijoxela': Can jebel c'a tichajij-ivi' richin man yixk'olotej. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Roma e q'uiy ri xquepe, xtiquibij: Ja yin ri Cristo, xquecha' c'a. Y e janíla e q'uiy ri xquek'olotej pa quik'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Y xtivac'axala' c'a chi ec'o ruvach'ulef c'o oyoval najin chiquicojol. Y xtivac'axala' chuka' chi que cha ri' xquebanatej, chi c'o cha oyoval ri xquepe. Pero man c'a tisach ic'u'x, roma ronojel ri' xa can c'o c'a chi yebanatej na. Pero man ja ta c'a ri' ri ruq'uisibel tak k'ij richin re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jun tinamit xtiyacatej c'a el richin nerubana' oyoval riq'uin jun chic tinamit. Ec'o c'a chuka' nima'k tak ruvach'ulef xqueyacatej-el richin chi nequibana' oyoval quiq'uin ch'aka' chic nima'k tak ruvach'ulef. Xquepe c'a yabilal, vayjal y chuka' silonel (cab-raken) xabachique lugar chire re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Y jac'ari' ri nabey tak k'axomal, y c'ari' xquepe chic c'a ch'aka' quivech tijoj-pokonal. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Xquixyalox c'a pa tak tijoj-pokonal, y ec'o c'a chive rix ri can xquecamisex. Xa can xquixetzelex-vi c'a coma conojel quivech vinek ri ec'o chuvech re ruvach'ulef, roma rix can icukuban ic'u'x viq'uin yin. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","E q'uiy c'a ri can xquetzak chic can, ec'o chuka' xtiquisujula-qui' y ec'o ri xtiquetzelaj-qui'. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Y xquebec'ulun c'a chuka' pe janíla e q'uiy, ri xquebin chi rije' e k'alajirisey richin ri nubij ri Dios chique, y roma c'a can queri' ri niquibij, can e q'uiy vi c'a vinek ri xquek'olotej pa quik'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chuka' chupan ri tiempo ri' roma can janíla chic biyinek rubanic ri etzelal, e q'uiy c'a ri xa can xtiquimalij ri ajovabel ri ruyo'on ri Dios chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero ri can man c'a xtutzolij ta ri' chirij y xtucoch' c'a ri pa ruq'uisibel chire ronojel, can xticolotej-vi c'a ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pero c'o na chi nitzijox ri utzilej ruch'abel ri Dios ri nich'on chirij tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios. C'o na chi nitzijox ri ch'abel ri' pa ronojel ruvach'ulef, richin queri' can tetamex c'a. Y c'a jac'ari' tok xtapon ri ruq'uisibel k'ij richin re tiempo re kachapon. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Y chuka' can xtapon-vi ri k'ij tok xquebanatej ri xajan tak banobel, chupan ri lok'olej lugar. Y riq'uin ri', can xtivulatej c'a can ri lugar ri'. Jari' ri tz'ibatel can roma ri Daniel, ri jun chique ri achi'a' ri xek'alajirisan ri xbix chique roma ri Dios, ojer can. Ri nitz'eton c'a ri tz'ibatel can, tik'ax c'a chuvech ri nutz'et. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Richin queri' tok xtitz'et chi can ja chic ri' ri nibanatej, ri vinek ri ec'o pa Judea xa can que'anmej c'a el y tequevaj-qui' ri pa tak juyu'. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ri xa nuxlan c'a pa ruq'uisibel vik (vek) chire ri rachoch tok napon ronojel ri vululen ri', choj queri' tanmej-el. Man toc chic apo pa rachoch richin chi c'o na ri neruc'ama-pe. Man tuben queri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ri nisamej c'a pa juyu', man c'a tibe chic na pa rachoch chuc'amic ruk'u'. Xa choj chuka' queri' tanmej-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jac'a ri ixoki' ri coyoben chic alanen, y ri ixoki' ri xa c'a niquiya' quitz'un tak cal, tok'ex c'a quivech tok xtapon ri k'ij ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Roma c'a ri' xa tic'utuj chire ri Dios chi ri vululen ri' man ta nibanatej chupan ri tiempo richin tef, y chuka' can tic'utuj c'a chi man pa jun uxlanibel-k'ij tibanatej ronojel ri', richin chi man c'ayef ta nuben chive richin chi yixanmej. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Y can jac'ari' tok xtic'o ruvi' ri tijoj-pokonal ri xtipe. Jun tijoj-pokonal ri man jun bey c'ulvachitajinek ta pa ruvi' re ruvach'ulef jampe' ri banon can roma ri Dios, c'a re vacami chupan re ka-tiempo roj. Chuka' ri tijoj-pokonal ri' man jun bey chic c'a xtic'ulvachitej. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Y vi man ta c'a nich'utinirisex ri k'ij richin ri tijoj-pokonal ri', conojel ta yequen (yecom). Pero roma ri rutzil ri Dios pa quivi' ri e rucha'on chic, can xtuch'utinirisaj ri k'ij ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Chupan ri k'ij ri', vi ec'o c'a ri yebin chive: Titzu', jac'a Cristo re'. O vi niquibij chive: Titzu', jac'a Cristo la'. Pero rix man c'a quixk'olotej pa quik'a'; man tinimaj ri niquibij chive. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Roma can ec'o c'a ri xquebec'ulun-pe y xtiquibila' c'a: Ja yin ri Cristo. Pero rix man c'a que'inimaj, roma xa quiyon k'olonela'. Y jac'a chuka' tiempo ri' tok xquebec'ulun-pe ri xquebin: Yin nink'alajirisaj ri nubij ri Dios chuve, xquecha'. Pero rix man c'a que'inimaj; roma xa e k'olonela' chuka'. Y xquequibanala' c'a nima'k tak milagros, ri man jun bey e tz'eton ta, xaxe richin quenimex, y ec'o ri yequik'ol. Y vi ta xa can yetiquir, rije' yequik'ol ta chuka' ri e cha'on chic roma ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Can ja yan c'a re' xinbij can chive ri xquebanatej. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Romari' vi xa can nibix c'a chive: Ri Cristo xpe yan y vacami jari' c'o pa tz'iran ruvach'ulef; rix man c'a quixbe chutz'etic. Y vi nibix chive chi ri Cristo c'o chic y vacami chupan ri jun jay ri' c'o-vi, man que'inimaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Roma tok yin ri xinalex chi'icojol xquipe chic jun bey, can xquik'alajin-vi c'a jebel. Xa can xtibanatej c'a achi'el nibanatej riq'uin ri coyopa' ri nuben quela' acuchi nel-vi-pe ri k'ij y nek'alajin c'a quere' acuchi nika-vi ri k'ij, can conojel vi c'a yetz'eton. Y que c'a ri' yin. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Roma ri ruk'atbel-tzij ri Dios xtika' acuchi c'o-vi ri mac. Can xtibanatej c'a achi'el nibanatej quiq'uin ri c'uch. Roma ri aj-xic' tak chicop ri' xabacuchi c'o-vi jun caminek ch'aculaj, chiri' c'a yeka-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Y tok can e k'axinek chic c'a ronojel ri tijoj-pokonal richin ri tiempo ri', can xtibanatej-vi c'a chi ri k'ij xtik'ekumatej y ri ic' chuka' man xtisakirisan ta chic. Ri ch'umila' xquetzak c'a el ri acuchi ec'o-vi. Can ronojel vi c'a ri nimalej tak uchuk'a' ri e richin ri chicaj xquesilon roma ri ruchuk'a' ri Dios. Can chi jun vi c'a ri caj xtisilon. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jac'ari' tok ri chicaj xtitz'etetej ri vetal yin ri xinalex chi'icojol. Ronojel c'a quivech vinek ri ec'o chuvech re ruvach'ulef, c'ari' c'a xque'ok' y c'ari' xtoka' chiquic'u'x ri achique rije', tok xquinquitz'et chi ja yin ri yika-pe pa sutz' ri chila' chicaj, riq'uin chic nimalej uchuk'a' y riq'uin chuka' chic jun nimalej nuk'ij-nuc'ojlen. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Y jac'a chuka' ri' tok ri trompeta xtik'ajan riq'uin janíla uchuk'a', y yin xquentek c'a ri nu-ángeles chiquimolic ri e nucha'on chic. Can xquequimol-vi c'a pe re quere' pa relebel-k'ij y re quere' pa kajibel-k'ij, re quere' c'a pa jotol y re quere' chuka' pa xulan. Can xquequimol-vi c'a pe; ronojel ri acuchi nitiquir-pe ri jun rutza'n re caj, c'a la jun chic rutza'n. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Can tic'ama' c'a ina'oj riq'uin ri víquix (higo). Tok can yeraxer c'a pe ri ruk'a' y niquichop-pe quelic ri ruxak, etaman c'a ri' chi ri ru-tiempo ri job noka' yan. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Y que c'a ri' tok xtitz'et chi ec'o chic ri yec'ulvachitej chupan ri k'ij, ri ic' y ri ch'umila', y ronojel ri xinbij yan ka nibanatej chic, tivetamaj c'a ri' chi noka' yan ri k'ij. Xa can nakaj chic c'a c'o-vi-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Y tivac'axaj c'a jebel re xtinbij chive re vacami: Ronojel re' xtic'ulvachitej tok ri vinek richin re tiempo re' c'a man jani queq'uis-el chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Y re ruvach'ulef y ri caj can e richin vi yeq'uis. Jac'a ri nuch'abel man xtiq'uis ta queri', xa can xtibanatej-vi ri nubij. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jac'a ri k'ij y ri hora tok yin xquipe, man jani k'alaj ta. Ri ángeles ri ec'o chila' chicaj man quetaman ta jampe'. Xa can xe c'a ri Nata' Dios ri etamayon ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Xa can achi'el c'a ri xbanatej ri pa ru-tiempo ri Noé, xa can que c'a chuka' ri' xtic'ulvachitej tok xquipe chic yin ri xinalex chi'icojol. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Roma ri pa ru-tiempo ri Noé, tok can c'a man jani tibanatej ri camic job, ri vinek xa benek c'a cánima riq'uin ri quiva'in y riq'uin ri achique yequikumula'. Xa can benek c'a cánima riq'uin ri quic'ulubic y riq'uin ri yeyatej-el quimi'al-quic'ajol richin yec'ule'. Y can c'a que na ri' ye'ajin chubanic chupan ri k'ij tok ri Noé y ri e aj pa rachoch xe'oc chupan ri nimalej barco. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Y man jun bey c'a xk'ax ta chiquivech ri xk'alajirisex chiquivech, xa can c'a jac'a tok xapon na ri camic job ri xuc'uan quichin conojel. Y can que vi c'a chuka' ri' xtibanatej tok xtapon ri nupetebel yin ri xinalex chi'icojol. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jac'ari' tok xtibanatej chi e ca'i' achi'a' ri junan yesamej pa juyu', jun runiman y jun man runiman ta, xaxe c'a jun ri xtuc'uex-el y ri jun chic xtic'oje' can. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Y vi ec'o e ca'i' ixoki' ri junan yeque'en riq'uin jun abej quebel-trigo y xaxe jun ri runiman, xaxe c'a jun ri xtuc'uex-el y ri jun chic xtic'oje' can. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Roma c'a ri' can man quixmestan, xa can quinivoyobej-apo, roma xa man xtivetamaj ta jampe' tok xquinoka' yin ri Ivajaf. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Roma rix can ivetaman-vi-c'a, chi vi ta ri rajaf jun jay nretamaj jampe' napon ri elek'on pa rachoch, ri rajaf ri jay ri' nic'ase' ta chuchajixic ri rachoch, y man ta nuya' k'ij chi ri elek'on nujek-apo ri rachoch richin nelek'-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Xa romari' tok rix ruc'amon chi can jantape' quinivoyobej-apo, roma tok xa man ja ta ri' yixajin chuch'obic, jari' tok xquinoka' yin ri xinalex chi'icojol. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Chupan ri k'ij ri' can xtibanatej c'a achi'el ri nibanatej riq'uin jun rajaf-jay ri ruyo'on can jun rusamajel pa quivi' ri e aj pa rachoch. Rubin can chire chi querutzuku-apo tok napon ri hora. Y vi ri samajel ri' can ta nuben ri bin can chire y utz nuben chire ronojel ri samaj, ¿achique ta cami nuben? ");
INSERT INTO cakCNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Rija' can nuben-vi ri samaj ri bin can chire, y romari' niquicot ránima tok no'ilitej-ka roma ri rajaf y najin chubanic ri samaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Can kitzij vi c'a ninbij chive chi ri rajaf ri samajel ri' xtuya' c'a pa ruvi' ronojel ri c'o riq'uin, richin chi nuchajij. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Jac'a vi ri samajel ri' xa itzel ta, y nuch'ob ta ka ri pa ránima: Ri vajaf ri' xa c'a man jani noka', nicha' ta; ");
INSERT INTO cakCNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","y nuchop ta c'a quich'ayic ri ch'aka' chic samajela' y chuka' can xe ta va'in y tijoj-ya' nuben quiq'uin ri k'abarela', ");
INSERT INTO cakCNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","jac'a ri k'ij y ri hora tok man jun nuch'ob chi noka' ta ri rajaf, jari' tok noka'. ");
INSERT INTO cakCNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ri rajaf, can xtuya-vi ruc'ayeval pa ruvi' ri samajel ri' y xtuya' quiq'uin ri ch'aka' chic ri xa ca'i' quipalej. Y ri chiri' xa can xe c'a ok'ej y kach'ach'en eyaj ri c'o. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Chupan c'a ri k'ij tok xquipe chic jun bey, ec'o c'a ri can xque'oc-vi pa ruk'a' ri Dios o chupan ri aj-chicajil ajavaren, y ec'o ri xa man xque'oc ta. Xa can xtic'ulvachitej c'a achi'el ri xc'ulvachitej quiq'uin e lajuj xtani' quic'uan-el quik'ak' richin sakil richin xebe chiroyobexic ri ala' ri xtic'ule' chupan ri ak'a' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E vo'o' c'a chique ri xtani' ri' can c'o-vi quina'oj. Jac'a ri e vo'o' chic xa can e nacanek vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ri vo'o' xtani' ri xa e nacanek, xebe c'a chiroyobexic ri ala' ri xtic'ule', pero xa man xquic'uaj ta c'a ch'aka' chic aceite richin ri quik'ak', xa can xe ri c'o-el chupan. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jac'a ri vo'o' chic xtani' ri can c'o quina'oj, xquic'uaj c'a ri quik'ak' y quic'ualon chuka' el tak c'ojlibel nojinek-el riq'uin aceite. Y rije' xebe c'a chiroyobexic ri ala' ri xtic'ule'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Y roma c'a ri ala' ri nic'ule' janíla xyaloj yan y man noka' ta, ri lajuj xtani' ri e oyobeyon richin, xa xpe c'a ruchuk'a' ri varan chique. Nabey xeyuxcu'r-ka (xevixcu'r-ka) y c'a juba' ri' xa can xever-vi-ka. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jac'a ri pa nic'aj-ak'a' xac'axatej c'a ruch'abel jun ri can riq'uin janíla ruchuk'a' nich'on y nubij c'a: Jari' petenek ri ala' ri xtic'ule'. Can quixel c'a pe chuc'ulic. Que c'a ri' ri nubij ri riq'uin uchuk'a' nich'on. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Y jac'ari' tok ri lajuj xtani' ri', ri e oyobeyon richin ri ala' ri xtic'ule', junanin c'a xeyacatej y xquibanala' rutzil ri quik'ak' richin sakil. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jac'a ri vo'o' xtani' ri e nacanek xquibij c'a chique ri vo'o' chic xtani' ri can c'o-vi quina'oj: Re kak'ak' xa can xquebechup c'a roma xa man q'uiy ta chic aceite quic'uan. Tiya' c'a juba' kaceite rix, xecha' ri xtani' ri e nacanek. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Jac'a ri vo'o' chic xtani' ri can c'o-vi quina'oj, xquibij c'a: Ri ruc'amon chi niben rix vacami ja ri te'ilok'o' aceite quiq'uin ri c'ayinela', roma vi roj nikaya' ri aceite chive, riq'uin juba' c'a c'o na ri nic'atzin chike, y que chuka' ri' rix. Romari' ri más utz niben ja ri quixbiyin chulok'ic aceite, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Y tok ri vo'o' xtani' ri' c'ari' c'a e benek chulok'ic aceite, jac'ari' tok xoc'ulun ri ala' ri xtic'ule'. Ri vo'o' xtani' ri can ec'o-vi-apo coyoben ri ala' ri xtic'ule', xe'oc c'a pa jay acuchi niban ri c'ulubic. Y tok can e oquinek chic c'a apo conojel ri e benek, xtz'apex c'a can ri puerta. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Y c'a jac'ari' tok xe'apon ri vo'o' chic xtani' ri xebe can chulok'ic aceite richin ri quik'ak', y rije' xech'on c'a apo chire ri rajaf ri jun c'ulubic ri' y xquibila' c'a: Tajaka' ri puerta chikavech richin chi yojoc-apo, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Y rija' xubij c'a pe chique ri xtani' ri': ¿Ix achique c'a rix? Yin can kitzij ri ninbij chive chi man jun bey xinvetamaj ta ivech, xe'uche'ex-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Roma c'a ri' rix can man quixmestan, can quinivoyobej-apo, roma xa man ivetaman ta achique k'ij, achique hora tok yin ri xinalex chi'icojol xquipe chic jun bey. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Roma c'a ri' ri aj-chicajil k'atbel-tzij junan riq'uin ri xuben jun achin tok xbe nej. Rija' xeroyola' c'a ri rusamajela' y xuya' c'a can ri rubeyomel pa quik'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pa ruk'a' c'a jun rusamajel xuya' can vo'o' mil quetzales, pa ruk'a' jun chic xuya' c'a can ca'i' mil quetzales y pa ruk'a' ri jun chic xuya' c'a can jun mil quetzales. Pa ruk'a' c'a ri nabey más q'uiy mero xuya' can roma xutz'et chi nitiquir nusamajij. Ri jun xa ca'i' oc mil quetzales xuya' can pa ruk'a' roma xaxe ri' ri nitiquir nusamajij. Y ri rox xa jun mil quetzales oc ri xuya' can pa ruk'a' richin tusamajij. Y ri achin can xe c'a xuben can ri', xbe c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Y ri samajel c'a ri yo'on can vo'o' mil quetzales pa ruk'a' richin tusamajij y nuch'ec más mero riq'uin, can xuben na vi ri bin can chire. Rija' can xusamajij-vi c'a ri vo'o' mil quetzales y xuch'ec chic c'a jun queri' riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Y que chuka' ri' xuben c'a ri jun chic samajel ri yo'on can ca'i' mil quetzales pa ruk'a', rija' can xuch'ec c'a ca'i' chic mil quetzales riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Jac'a ri rox samajel ri xa jun mil quetzales oc ruc'ulun can chire ri rajaf, xa xberuc'oto' c'a jun jul pan ulef y chiri' xumuk-vi can ri mero ri yo'on can pa ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Y c'a tok k'axinek chic na q'uiy k'ij, c'ari' c'a xtzolin-pe ri achin cajaf ri samajela' ri'. Y rija' xuc'utuj c'a chique achique xquiben riq'uin ri mero ri xuya' can chique tok xbe. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tok xapon c'a ri samajel ri yo'on can vo'o' mil quetzales pa ruk'a', can man xe ta c'a ri' ri ruc'uan-apo, xa can ruc'uan c'a apo vo'o' mil quetzales más y xubij c'a chire ri achin rajaf rija': Rat vo'o' c'a mil quetzales ri xaya' can pa nuk'a'; jac'are' c'o, y ja chuka' re' c'o vo'o' mil quetzales más ri xinch'ec riq'uin, xcha' ri samajel ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Y ri rajaf ri samajel ri' xubij c'a chire: Utz ri xaben. Rat, jun c'a utzilej nusamajel ri can naben ri nibix chave. Y roma c'a can xaben ri ruc'amon riq'uin ri juba' ri xinya' can pan ak'a' tok xibe, vacami c'a yatinya' pa ruvi' jun samaj más nim. Can catampe c'a y catoc chupan ri quicoten ri c'o riq'uin ri Avajaf, xuche'ex ri samajel. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tok xapon chuka' ri samajel ri yo'on can ca'i' mil quetzales pa ruk'a', rija' xubij c'a chire ri achin, rajaf: Rat ca'i' c'a mil quetzales ri xaya' can pa nuk'a'; jac'are' c'o, y ja chuka' re' c'o ca'i' mil quetzales más ri xinch'ec riq'uin, xcha' ri samajel ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ri rajaf ri samajel ri' xubij c'a chire: Utz ri xaben. Rat, jun c'a utzilej nusamajel ri can naben ri nibix chave. Y roma c'a can xaben ri ruc'amon riq'uin ri juba' ri xinya' can pan ak'a' tok xibe, vacami c'a yatinya' pa ruvi' jun samaj más nim. Can catampe c'a y catoc chupan ri quicoten ri c'o riq'uin ri Avajaf, xuche'ex ri samajel. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Jac'a tok xapon chuka' ri samajel ri yo'on can jun mil quetzales pa ruk'a', rija' xubij c'a chire ri rajaf: Yin can vetaman-vi c'a avech, y romari' vetaman chi janíla at c'a'el. Xa can navajo-vi c'a yach'acon. Rat navajo' nac'ul ri nel-pe chuvech ri ticoj ri xa man rat ta xaticon-ka. Navajo' nayec ri trigo ri xa man rat ta xach'ayon. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Y romari' yin xinpokonaj xinsamajij ri jun mil quetzales ri xaya' can pa nuk'a'. Yin tok xinc'ul c'a el ri mero, xinc'ot jun jul pan ulef y chiri' xinmuk-vi can. Y jac'a a-mero re' nonjacha' can, xcha' ri samajel ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Y ri rajaf ri samajel ri' xubij c'a: Man utz ta ri xaben. Roma rat, jun itzel samajel y man naben ta ri nibix chave. Roma vi can avetaman chi yin can in c'a'el vi, chi yin ninvajo' ninc'ul ri nel-pe chuvech ri ticoj ri xa man yin ta xiticon-ka y ninvajo' ninyec ri trigo ri xa man yin ta xich'ayon, ");
INSERT INTO cakCNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","xa roma ta ri', xaya' ta ri nu-mero pa quik'a' ri achi'a' nibix banqueros chique, y re xinoka' vacami xinc'ul ta c'a ri mero can vichin yin y xinc'ul ta chuka' ri ral re mero re'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vacami tic'ama' c'a can ri mero chire y tijacha' pa ruk'a' ri nusamajel ri chapayon lajuj mil quetzales. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Roma ri can c'o-vi c'o riq'uin, xtuc'ul c'a más y q'uiy c'a xtuben-ka riq'uin. Jac'a ri man jun oc c'o riq'uin, janipe' oc ri c'o riq'uin can nelesex c'a can chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Y ri samajel c'a ri xa can man jun nic'atzin-vi tic'aka' c'a el chupan ri k'eku'n, ri acuchi ruyon ok'ej c'o y ruyon chuka' kach'ach'en eyaj c'o. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Y tok yin ri xinalex chi'icojol xquipe chic c'a, can riq'uin chic c'a nuk'ij-nuc'ojlen; y chuka' can conojel ri lok'olej tak ángeles xquepe viq'uin. Y jac'ari' tok yin xquitz'uye' pa nuch'acat ri can janíla chuka' ruk'ij; y xtink'et c'a tzij. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Can xquemol-vi c'a apo chinuvech ri vinek richin conojel ruvach'ulef. Y xquipe c'a yin can xquench'er-vi c'a conojel, achi'el nuben jun aj-yuk' quiq'uin ri tak ruchicop. Rija' juc'an c'a yeruya-vi ri tak carne'l, y juc'an chic yeruya-vi ri tak cabras. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ri vinek c'a ri achi'el tak carne'l, roma ch'ajch'oj chic quic'aslen, xquenya' c'a pa vajquik'a'. Jac'a ri vinek achi'el tak cabras, roma man utz ta ri quic'aslen, xquenya' pa vajxocon (izquierda). ");
INSERT INTO cakCNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Y jac'ari' tok ri Rey xtubij chique ri ec'o pa rajquik'a': Can quixampe c'a rix, ri ic'ulun chic ri rutzil ri Nata' Dios. Quixc'oje' c'a ri acuchi can ja ri Dios ri nik'aton tzij, ri can ivichin vi rix tok rubanon; y ri' xuben c'a tok c'a man jani c'o ta re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Roma tok yin xivayjan, rix c'o c'a xiya' chuve richin xintej. Tok yin xchaki'j c'a nuchi', rix c'o c'a xiya' chuve richin xinkun. Xc'atzin nu-posada y rix xiya'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tok xa can xich'ane' c'a can, rix xicuch vij jun bey chic. Tok yin xika' pa ruk'a' yabil, xixapon c'a chinutz'etic. Tok xitz'ape' pa cárcel, xixapon c'a chinuk'ejeloxic (chinuk'ijaloxic), xticha' ri Rey. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jac'a ri chojmilej tak vinek xtiquibij c'a: Ajaf, ¿jampe' c'a ri' tok roj c'o xkaya' chave richin yava' roma yavayjan? ¿Jampe' c'a ri' tok roj c'o xkaya' chave richin xakun roma nichaki'j achi'? ");
INSERT INTO cakCNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Y jampe' c'a ri' tok xkaya' a-posada roma xc'atzin chave? ¿Jampe' c'a ri' tok roj xkacuch avij roma xach'ane' can? ");
INSERT INTO cakCNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jampe' c'a ri' tok xojapon chi'atz'etic roma xayavej? ¿Y jampe' chuka' ri' tok xojapon chi'ak'ejeloxic (chi'ak'ijaloxic) roma atc'o pa cárcel? xquecha' rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Y ri Rey xtubij c'a: Can kitzij vi c'a ri ninbij chive chi roma queri' xiben riq'uin ri vach'alal ri más co'ol, xa can chuve chuka' yin xiben-vi ri utzil xiben chire rija', xticha' ri Rey. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Y jac'a chuka' ri' tok ri Rey xtubij chique ri ec'o pa rajxocon (izquierda): Rix xa ruc'ayeval chic ri ivoyoben chi nika' pan ivi'. Quixel c'a el chinuvech y quixbiyin pa k'ak' ri man jun bey xtichup, y xa richin ri itzel-vinek y ri ru-ángeles tok banon. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Roma yin can xivayjan c'a y rix man jun ri xiya' ta chuve richin xintej. Janíla c'a xchaki'j nuchi' y rix man jun xiya' chuve richin xinkun. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Roma yin xc'atzin nu-posada y rix xa man xiya' ta. Tok can xich'ane' c'a can, man xicuch ta vij. Tok xika' pa ruk'a' yabil, rix man c'a xinibetz'eta' ta. Tok xic'oje' pa cárcel, man xixapon ta chinuk'ejeloxic (chinuk'ijaloxic), xticha' ri Rey chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Y jac'ari' tok rije' chuka' xtiquibij: Ajaf, roj man jun bey xatkatz'et chi natej ta vayjal, nichaki'j ta achi', chuka' man xkatz'et ta chi nic'atzin ta a-posada, o at ch'anel ta, at yava' ta, atc'o ta pa cárcel. Roj man jun bey xatkatz'et chi que ta ri' ac'ulvachin, romari' can man jun vi c'a utzil xkaben chave, xquecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Y jac'ari' tok ri Rey xtubij chique: Can kitzij vi c'a ri ninbij chive chi roma man jun utzil xiben chique re cocoj ec'o-pe viq'uin, xa can man jun c'a chuka' utzil xiben chuve yin. ");
INSERT INTO cakCNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Y ri vinek ri' can xquebe-vi c'a pa tijoj-pokonal richin jantape'. Y ri chojmilej tak vinek xtiquil c'a jun c'aslen ri man q'uisel ta. Queri' c'a ri ch'abel ri xubij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tok ri Jesús rubin chic c'a ka ronojel ri', rija' xch'on c'a quiq'uin ri rutijoxela' y xubij c'a: ");
INSERT INTO cakCNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Rix can ivetaman-vi chi pa ca'i' apo k'ij c'o ri kanimak'ij ri rubini'an pascua. Chupan c'a ri nimak'ij ri' tok yin ri xinalex chi'icojol can xquijach-vi-el richin chi yibajix chuvech cruz richin chi xquiquen (xquicom), xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Y can ja vi c'a ri' tok ri principal-i' tak sacerdotes, ri etamanela' chirij ri ley y chuka' ri rijita'k tak achi'a' ri janíla quik'ij chiquicojol ri vinek, can quimolon-vi c'a qui' chuva-rachoch ri nimalej sacerdote ri rubini'an Caifás. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Rije' xquiya' c'a chiquivech achique chi k'oloj xquequicusaj richin chi nika' ri Jesús pa quik'a', y c'ari' niquicamisaj. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero chuka' can xquibij c'a: Man tikachop chupan re nimak'ij re', richin chi man queyacatej-pe ri vinek chikij. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Y ri Jesús c'o c'a ri pa tinamit rubini'an Betania, chiri' pa rachoch ri Simón ri xc'achojirisex chire ri yabil rubini'an lepra. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Y jac'ari' tok xapon jun ixok riq'uin ri Jesús, ruc'uan-apo jun c'ojlibel ri banon riq'uin jun abej rubini'an alabastro, y c'o-el jun jubulej ak'on chupan; ak'on ri can janíla jotol rajel. Y jari' ri xberuk'eja' pa rujolon (ruvi') ri Jesús, tok tz'uyul-apo ri chiri' pa mesa, niva' chiri' pa rachoch ri Simón. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tok ri tijoxela' xquitz'et ri xuben ri ixok riq'uin ri jubulej ak'on chi xuya' pa rujolon (ruvi') ri Jesús, xpe coyoval y xquibila' c'a: ¿Achique nic'atzin-vi chi choj queri' xutix la jubulej ak'on la'? ");
INSERT INTO cakCNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Roma la jubulej ak'on la' nim rajel, y romari' xc'ayix ta; y ri rajel xa xtalux ta chiquivech ri vinek ri man jun c'o quiq'uin, xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ri Jesús chanin xk'ax chuvech ri niquibila' ri rutijoxela', romari' rija' xubij c'a chique: ¿Achique c'a roma tok rix man yixtane' ta ka chi tzij chirij re ixok re'? Xa tiya' can. Rija' can jun utzilej banobel c'a ri xuben viq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ri vinek ri man jun c'o quiq'uin xa can jantape' c'a ec'o iviq'uin, richin chi xabachique k'ij niben utzil chique. Jac'a yin man jantape' ta xquic'oje' iviq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Roma tok re ixok re' xuk'ej chuvij re jun jubulej ak'on re', can xuc'ut c'a ri ajovabel ri c'o riq'uin. Rija' xuben yan c'a viq'uin achi'el niban chique ri caminaki' tok yemuk. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Y tivac'axaj na pe' jebel re xtinbij chive, chi xabachique lugar c'a ri xtitzijox-vi ri utzilej ch'abel richin colotajic, chiri' chuka' xtitzijox-vi re xuben re jun ixok re'. Can ronojel c'a ruvach'ulef xtitzijox-vi, y man jun bey c'a xtimestex, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Y jun c'a chique ri cablajuj rutijoxela' ri Jesús, ri tijoxel rubini'an Judas Iscariote, xapon c'a quiq'uin ri principal-i' tak sacerdotes. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Rija' xberubij c'a chique: ¿Achique cami niya' chuve rix, vi yin ninjech ri Jesús pan ik'a'? xcha' chique. Y ri principal-i' tak sacerdotes xquibij chi niquiya' juvinek-lajuj mero banon riq'uin sakipuek chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Y jac'ari' tok ri Judas Iscariote xuchop ruch'obic achique rubanic richin queri' nujech ri Jesús pa quik'a' ri achi'a' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Y chupan c'a ri nabey k'ij richin ri nimak'ij ri', tok nitij chuka' caxlan-vey ri manek ch'en (ch'amilej-k'or) riq'uin, jac'ari' tok ri tijoxela' xe'apon-apo riq'uin ri Jesús, y xquic'utuj c'a chire: ¿Acuchi c'a navajo' naben-vi ri va'in chupan re jun pascua re' richin nekabana' can rutzil ronojel ri nic'atzin? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Y ec'o c'a chique ri tijoxela' ri xetak-el roma ri Jesús c'a pa tinamit Jerusalem, pa rachoch jun achin, y xbix-el chique chi tok xque'apon, tiquibij c'a chire: Ri Katijonel rubin c'a pe: Ri nu-tiempo xa nakaj chic c'a c'o-vi-pe. Jac'a ri pan avachoch rat ninvajo' ninben-vi va'in richin re pascua re', e vachibilan ri nutijoxela', xte'ibij, xcha' ri Jesús chique ri rutijoxela' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Y ri tijoxela' can xquiben-vi c'a achi'el ri bin-el chique roma ri Jesús. Rije' can xquiben-vi c'a rutzil ronojel ri nic'atzin richin ri va'in richin ri pascua ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jac'a tok xk'ekumer-pe chupan ri k'ij ri', ri Jesús y ri e cablajuj rutijoxela' xebetz'uye' c'a pa mesa richin ri va'in. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Y tok ye'ajin c'a chi va'in, ri Jesús xubij c'a: Can kitzij c'a ninbij chive, chi jun chive rix ri xquijachon-el pa quik'a' ri vinek, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jac'a ri tijoxela' janíla bis xpe pa cánima tok xcac'axaj ri xubij ri Jesús chique. Y c'ari' c'a chiquijujunal xech'on-apo chire y xquic'utula' c'a: Ajaf, ¿man ja ta cami yin ri xquibanon queri'? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Y ri Jesús jac'ari' tok xubij chique ri rutijoxela': Ri jun c'a ri xtuyuk-pe ri ruk'a' richin numuba-pe ruvay viq'uin pa lek, jac'ari' ri xtijachon-el vichin pa quik'a' ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Can tivac'axaj c'a chuka' ri xtinbij chive, chi yin ri xinalex chi'icojol can xquibe-vi c'a ri' tok xquijach-el. Can xtibanatej achi'el ri tz'ibatel can. Pero tok'ex c'a ruvech ri xtijachon-el vichin yin ri xinalex chi'icojol. Ri achin ri xtijachon-el vichin utz ta chi man ta xalex, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Y jac'ari' tok xch'on-apo ri Judas, ri xtijachon richin ri Jesús; y ri Judas xubij c'a: Rat ri Nutijonel, ¿ja cami yin ri xquijachon-el avichin? xcha'. Y ri Jesús xubij: Jac'a rat yabin ri', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Y tok can c'a ye'ajin na c'a chi va'in, ri Jesús xuq'uen-apo jun caxlan-vey y xumatioxij chire ri Dios. C'ari' xuper (xupir) ri caxlan-vey ri' y xuya' chique ri rutijoxela'. Rija' xubij c'a chique ri tijoxela' ri': Tic'ama' y titija' re caxlan-vey re'. Roma jare' ri nuch'acul ri xtapon pa camic. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Y ri Jesús xuq'uen c'a chuka' apo ri vaso ri c'o ruya'al-uva chupan; y tok rumatioxin chic chire ri Dios, xuya' c'a chique ri rutijoxela'. Y rija' xubij c'a tok xuya' chique: Tikumu' c'a can chi'ivonojel ri ruya'al-uva c'o chupan re vaso re'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Roma jare' ri nuquiq'uel ri xtibiyin tok xquiquen (xquicom). Can xtibiyin-vi c'a ri nuquiq'uel, richin chi e q'uiy c'a ri nicuyutej ri quimac. Riq'uin re nuquiq'uel, can jac'are' xc'achoj ri c'ac'a' trato ri rajovan-pe ri Dios chi nuben quiq'uin ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Can ninbij-vi c'a chive chi ja ruq'uisibel bey re' xinkun-el re ruya'al-uva re'. Y tok xtinkun chic jun bey, ja chic c'a chupan ri utzilej ruk'atbel-tzij ri Nata' Dios. Can iviq'uin c'a chuka' rix tok xtinkun ri ruya'al-uva ri'. Y ri xtikakun c'a chiri', jun c'ac'a' ruya'al-uva, xcha' ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Y tok quibixan chic c'a ri bix richin niquiya' ruk'ij ri Dios, ri Jesús y ri rutijoxela' xe'el-el ri chiri' pa jay y xebe ri pa juyu' Olivos. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Y tok e benek c'a, ri Jesús xubij chique ri rutijoxela': Chi'ivonojel rix xtitaluj-el-ivi' y xquiniya' c'a can nuyon chupan re ak'a' re', tok xa xtitz'et chi yin yijach-el pa quik'a' ri vinek. Roma ri Dios can nubij-vi c'a chupan ri tz'ibatel can: Tok yin xtinya' k'ij chi nicamisex ri aj-yuk', ri rucarne'l xa xtiquitaluj-el-qui'. Queri' ri tz'ibatel can. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero yin ri Aj-Yuk' man c'a xquiquen ta el (xquicom ta el) richin jantape', xa xquic'astej-pe. Y ja yin ri xquinoyoben ivichin ri chila' pa Galilea, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Y ri Pedro can jac'ari' xch'on-apo chire ri Jesús y xubij: Vi ri ch'aka' chic yatquiya' c'a can ayon tok xtiquitz'et chi xa c'o ri nac'ulvachij, tiquibana' na c'a. Jac'a yin can man jun bey xcatinya' can, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pero ri Jesús xubij c'a chire ri Pedro: Yin can kitzij c'a ninbij chave, chi chupan re ak'a' re', xa c'a man jani tisiq'uin-pe ri mama' tok rat oxi' yan bey tabij chique ri yec'utun chave, chi man avetaman ta nuvech, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Y ri Pedro xubij c'a chire: Stape' ta can c'o chi yiquen (yicom) aviq'uin rat, can man xquitiquir ta xtinbij chi man vetaman ta avech, xcha' ri Pedro. Y can conojel c'a ri tijoxela' que chuka' ri' xquibij. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Y jac'ari' tok ri Jesús e rachibilan ri rutijoxela' xe'apon c'a ri chiri' chupan ri lugar rubini'an Getsemaní. Xpe ri Jesús xubij c'a chique ri rutijoxela': Rix quixtz'uye' na c'a can juba' vave', roma yin xa yibe chic c'a apo juba' queri' richin chi nenbana' orar, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Rija' xaxe c'a ri Pedro y ri e ca'i' ruc'ajol ri achin rubini'an Zebedeo ri xeruc'uaj riq'uin. Jac'ari' tok rija' janíla xuna' yan ri xteruc'ulvachij. Can jun bis c'a janíla nim ri xpe pa ránima. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Y jac'ari' tok rija' xubij chique ri e oxi' rutijoxela': Ri bis c'o pa vánima, janíla nim. Y yirucamisaj ninna' yin. Quixc'oje' c'a pe viq'uin, quixc'ase' y man quixver-ka, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Rija' xbiyin chic c'a apo juba' y chiri' xxuque-vi-ka. Can xukasaj-vi c'a ka ri' c'a pan ulef, xuben orar. Y ri ch'abel ri xerubila' que c'a re': Nata' yin, vi can tiquirel, tabana' c'a chi man ta ninc'ovisaj re jun tijoj-pokonal re', pero man taben c'a chuka' ri ninrayij yin, xaxe voma ta yin. Roma yin xa can ninvajo' c'a chuka' ninben ri arayibel rat, nicha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Y tok rija' xc'achoj chire ri oración, xpe c'a quiq'uin ri e oxi' rutijoxela', pero tok xoka' quiq'uin xa yever. Xpe rija' xubij c'a chire ri Pedro: ¿Can man juba' c'a xixtiquir xixc'ase' jun ti hora viq'uin? ");
INSERT INTO cakCNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Man c'a quixver-ka, xa tibana' orar y tic'utuj chire ri Dios richin chi tok yixtejtobex, man quixtzak pa mac. Can vetaman-vi chi ri rurayibel ri ivánima ja ri niben ri nrajo' ri Dios. Pero iyon xa can man yixtiquir ta c'a, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Y ri Jesús xbe chic c'a apo richin xberubana' orar pa ruca'n bey, y nubij c'a: Nata' yin, vi can c'o c'a chi ninc'ovisaj na ri tijoj-pokonal, richin queri' yinic'o chuvech, yin can ninvajo' c'a ninben ri arayibel rat. Que c'a ri' ri nubij pa ru-oración. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Y tok rija' xpe chic c'a jun bey quiq'uin ri e oxi' rutijoxela', yever chic c'a jun bey ri xeril, roma ri tijoxela' ri' al-al c'a runak' tak quivech roma ri quivaran. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ri Jesús xeruya' chic c'a can jun bey y xbe chic chubanic orar. Oxi' yan bey ri' nibe chubanic orar. Rija' xucamuluj chic c'a rubixic ri ch'abel ri xerubij chupan ri oración c'a juba' tuben-ka. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Y c'ari' ri Jesús xpe c'a quiq'uin ri e oxi' rutijoxela', y xubij c'a chique: ¿Can c'a yixver na c'a? ¿Nivajo' nitz'akatisaj ri ivaran? Yin ri xinalex chi'icojol can ja vi c'a re' xoka' nu-hora, can xquijach c'a el pa quik'a' ri itzel tak achi'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Chanin, quixyacatej. Jala' petenek ri xquijachon-el pa quik'a' ri itzel tak achi'a', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Y ri Jesús can c'a nich'on na c'a quiq'uin ri rutijoxela', tok ja yan ri' xoka' ri Judas ri jun chique ri cablajuj rutijoxela', y e ruc'uan c'a apo e q'uiy vinek ri e quic'ualon che' y machet. Conojel re' e takon c'a el coma ri principal-i' tak sacerdotes y coma chuka' ri rijita'k tak achi'a' ri c'o janíla quik'ij chiquicojol ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ri Judas ri nijachon-el richin ri Jesús can rubin chic c'a pe chique ri e petenek riq'uin, achique rubanic xtuben richin nuc'ut ri Jesús chiquivech. Rija' can rubin c'a pe chique: Jac'a ri xquijel-apo riq'uin richin xtintz'ubaj (xtintz'umaj), jari' ri Jesús, y tichapa' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Y ri Judas can jac'ari' xjel-apo riq'uin ri Jesús y xubij: Rat ri Nutijonel, can caquicot c'a, xcha' chire richin xuk'ejela' (xuk'ijala'). Y xutz'ubaj c'a (xutz'umaj c'a) ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Xpe ri Jesús xubij c'a chire ri Judas: ¿Achique c'a ri no'abana' na? xcha' chire. Y can jac'ari' tok xejel-apo ri vinek ri e benek chapoy richin ri Jesús y xquichop c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Y jun c'a chique ri ec'o riq'uin ri Jesús chiri', can jac'a ri ruk'a' chanin c'o-pe, xrelesaj ri rumachet y xusoc ri jun rusamajel ri nimalej sacerdote. Can xuchoy-vi c'a ri ruxiquin riq'uin ri jun machet xuya' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Y ri Jesús jac'ari' tok xubij chire ri xbanon queri': Tayaca' la amachet. Roma achique c'a ri yeyacatej riq'uin machet, can chi machet c'a chuka' yecamisex-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Rat nach'ob chi yin xa man jun nitz'eton pa nuvi'? Xa ta yin ninc'utuj chire ri Nata' Dios chi quiruto', rija' yerutek ta pe más setenta y dos mil ángeles chinuto'ic. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero xa can jare' nibanatej ri e tz'ibatel can chupan ri ruch'abel ri Dios, romari' tok man nic'atzin ta c'a chi yepe ta ri ángeles chinuto'ic, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Y chupan c'a chuka' ri hora ri' ri Jesús xubij chique ri vinek: ¿Achique c'a xich'ob rix? ¿Xich'ob chi yixpe chuchapic jun elek'on y romari' ic'amon-pe che' y machet? Can k'ij-k'ij c'a ri xitz'uye' iviq'uin chiri' pa rachoch ri Dios, tok xinc'ut ri ruch'abel chivech y man jun bey xinichop ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ronojel c'a re nibanatej vacami, xa can richin c'a chi nibanatej-vi ri tz'ibatel can chupan ri ruch'abel ri Dios coma ri achi'a' ri xek'alajirisan ri ruch'abel ojer can. Y can ja vi c'a ri' tok ri e rutijoxela' ri Jesús, xquiya' can ruyon y xe'anmej. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ri xebechapon-pe richin ri Jesús chiri' pa Getsemaní, xquic'uaj c'a riq'uin ri Caifás ri nimalej sacerdote, ri jay ri quimolon-vi can qui' ri etamanela' chirij ri ley y ri rijita'k tak achi'a' ri can c'o-vi quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Y ri Pedro c'anej c'a c'o-vi can, e rutzekelben-el, y xoc chuka' apo ri chiri' chuva-rachoch ri nimalej sacerdote. Tok rija' c'o chic c'a chiri', xtz'uye-apo chiquicojol ri samajela' ri ec'o-apo chiri', richin c'a chi nutz'et na achique ri xtuc'ulvachij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Y ri principal-i' tak sacerdotes, ri rijita'k tak achi'a' ri can c'o-vi quik'ij, y conojel c'a ri achi'a' ri can pa comon niquik'et tzij, niquicanola' c'a chi ec'o ta ri itzel tak banobel ri ye'ilitej chirij ri Jesús, richin queri' can niquitek-vi pa camic. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Y stape' can e q'uiy vi c'a ri xe'apon ri xquitz'uc tzij chirij, xa can man jun c'a ri c'o ta ruchuk'a' richin xucusex. Xa c'a ja ri pa ruq'uisibel xe'apon e ca'i' ri can junan vi ri niquibij. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ri e ca'i' ri' xquibij c'a: Re achin re' rubin: Yin yitiquir ninvulaj ri rachoch ri Dios y pan oxi' k'ij ninpaba' chic jun bey. Queri' ri rubin, xecha' ri e ca'i' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Y ri Caifás, ri nimalej sacerdote, xbepa'e' c'a pe y xubij chire ri Jesús: ¿Kitzij cami ri xquibij-ka chavij re e ca'i' re'? ¿Achique nabij vacami? xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero ri Jesús man jun c'a ch'abel xubij. Y jac'ari' tok ri nimalej sacerdote xubij chire: Can chuvech c'a ri c'aslic Dios tabij chike vi jac'a rat ri Cristo ri Ruc'ajol. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Y ri Jesús xubij c'a chire: Ja', ja yin ri Cristo; y chuka' can ninbij-vi c'a chive chi re chikavech apo can xquinitz'et-vi yin ri xinalex chi'icojol, in tz'uyul pa rajquik'a' ri Dios ri nitiquir nuben ronojel. Y xquinitz'et tok yika-pe pa sutz' ri chila' chicaj, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Xpe ri Caifás ri nimalej sacerdote jac'ari' xuretz-ka ri rutziak chirij roma itzel xrac'axaj, y xubij c'a: Man nic'atzin ta c'a chi noka' chic jun richin norubij chike chi re Jesús can aj-mac vi. Rix, c'ari' c'a nivac'axaj-ka chi'ivonojel ri xubij chi ja rija' ri Cristo. Can itzel c'a xuben chuvech ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Y achique c'a nibij rix vacami chi nikaben chire? xcha' rija'. Y ri ch'aka' chic ri quimolon-qui' chiri' xquibij c'a: Ruc'amon chi ticamisex, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Y xquichubala' c'a can rupalej (ruvech) ri Jesús, y xquich'ey riq'uin c'olon-k'a' y ec'o chuka' ri quiric'on quik'a' xquipak'ila' rupalej (ruvech). ");
INSERT INTO cakCNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Chuka' xquibila' chire ri Jesús tok quitz'apen ruvech: Rat ri Cristo, tabij c'a chike achique ri yech'ayon avichin, yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ri Pedro tz'uyul c'a ri chuva-jay. Y jac'ari' tok c'o jun ixok raj-ic' ri nimalej sacerdote ri xapon-apo riq'uin y xubij c'a chire: Rat chuka' at rachibil ri Jesús ri aj-Galilea, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero rija' xa can chiquivech c'a conojel xrevaj-vi, roma xubij: Man nik'ax ta chinuvech achique roma tok queri' nabij chuve, xcha' chire ri aj-ic'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Y tok rija' can jac'ari' nuben chi nel-el ri pa puerta, c'o chic c'a jun ixok aj-ic' ri xtz'eton richin y xubij c'a chique ri ec'o-apo chiri': Re jun chuka' achin re' can rachibil ri Jesús ri nipe pa tinamit Nazaret, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pero ri Pedro xa xrevaj chic c'a jun bey. Rija' xubij: Chuva Dios ninbij chi yin man vetaman ta ruvech ri jun achin ri', xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","C'a juba' chic ri', ja chic c'a ri quimolon-qui' que tak ri' ri xejel-apo riq'uin ri Pedro y xquibij c'a chire: Can kitzij na vi chi rat at jun chique ri ec'o riq'uin ri Jesús. Xaxe riq'uin ri rubanic ri yach'on nuk'alajirisaj chi can queri' vi, roma ri aj-Galilea queri' yech'on, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pero ri Pedro xubij c'a: Yin man vetaman ta ruvech ri achin ri'. Can chuva Dios ninbij-vi chive chi man vetaman ta ruvech. Y vi man kitzij ta ri ninbij, tika' c'a ruc'ayeval pa nuvi', xcha'. Y jac'ari' tok xbesiq'uin-pe ri mama'. ");
INSERT INTO cakCNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Y jari' tok ri Pedro xe'oka' c'a chuc'u'x ri ch'abel ri e rubin can ri Jesús chire, chi c'a man jani tisiq'uin-pe ri mama' tok rat oxi' yan bey tabij chique ri yec'utun chave, chi man avetaman ta nuvech. Y rija' xel c'a el y xujik' ok'ej. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Y tok xseker-pe, conojel c'a ri principal-i' tak sacerdotes y ri rijita'k tak achi'a' ri can c'o-vi quik'ij ri chiri' chiquicojol ri vinek, xquimol-qui' richin chi niquich'ob achique niquiben richin niquitek ri Jesús pa camic. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ri Jesús can ximon-vi-el tok xquic'uaj y xbequijacha' pa ruk'a' ri k'atoy-tzij rubini'an Poncio Pilato. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jac'a tok ri Judas ri xjachon richin ri Jesús, xutz'et chi ri Jesús xa nitak pa camic, jac'ari' tok rija' xpe k'axo'n riq'uin y xberutzolij can ri juvinek-lajuj mero banon riq'uin sakipuek. Xberutzolij can chique ri principal-i' tak sacerdotes y ri rijita'k tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ri Judas xubij c'a can chique ri achi'a' ri': Yin can ximacun c'a tok xinjech ri Jesús pan ik'a', roma rija' can man jun rubanon richin nicamisex, xcha' chique. Jac'a ri principal-i' tak sacerdotes y ri rijita'k tak achi'a' ri c'o quik'ij, xa xquibij c'a pe chire ri Judas: ¿C'o cami nic'atzin-vi chike roj chi ri Jesús xa man jun achique ta rubanon? Man jun. Ri' xaxe c'a chavech rat, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Xpe c'a rija' xutorij can ri mero e banon riq'uin sakipuek. Rija', jac'a ri chiri' pa rachoch ri Dios xutorij-vi can, y xbe c'a. Y rija' xberujitz'aj c'a ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Y ri principal-i' tak sacerdotes xquic'ol c'a el ri mero ri banon riq'uin sakipuek y xquibij c'a: Re mero re' man ruc'amon ta c'a chi nikaxol-ka riq'uin ri mero ri nisipex can vave' pa rachoch ri Dios, roma re mero re' xa rajel jun achin ri xtibiyin ri ruquiq'uel. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jac'a tok can quiyo'on chic c'a chiquivech ri niquiben riq'uin ri mero ri', rije' xquilok' c'a ri rulef jun banoy-bojo'y. Ri ulef ri' can xtic'atzin c'a richin chi ja ri chiri' yemuk-vi ri vinek ri man e israelitas ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Y romari' tok ri jun ulef ri' can c'a nibix na c'a Ulef richin Quic' chire. Can man jalatajinek ta c'a ri rubi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Riq'uin c'a ri' can xbanatej-vi ri rubin can ri Jeremías, ri jun ri can xk'alajirisan ri ruch'abel ri Dios ojer can. Rija' can rubin-vi c'a can: Y ri e riy-rumam can ri achin ri xubini'aj Israel, xquiq'uen c'a el ri juvinek-lajuj mero ri banon riq'uin sakipuek, mero ri xquiya' rije', roma xquibij chi jari' ri rajel ri rusamajel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Y ri mero ri' jari' ri xquiya' chuvech ri ulef ri richin ri banoy-bojo'y. Can achi'el vi rubin ri Ajaf chuve. Queri' c'a ri rubin can ri Jeremías. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Y ri Jesús can pa'el-vi c'a apo chuvech ri k'atoy-tzij rubini'an Poncio Pilato. Y ri k'atoy-tzij ri' xuc'utuj c'a chire ri Jesús: ¿Ja rat ri qui-Rey ri israelitas? xcha' chire. Y ri Jesús xubij: Ja', queri'. Can achi'el ri xabij, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Y tok ri Jesús can janíla vi c'a ri nibix-apo chirij coma ri principal-i' tak sacerdotes y ri rijita'k tak achi'a' c'o quik'ij, rija' can man jun c'a ri nubij. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ri Pilato can jac'ari' tok xubij chire ri Jesús: ¿Can man navac'axaj ta c'a ri niquibij ri vinek chavij richin yatquisujuj? Y rat can man jun nabij. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero ri Jesús can man jun c'a ch'abel ri xubij ta chire ri Pilato. Y romari' tok ri k'atoy-tzij ri' can achique la xuna', roma man jun bey rutz'eton ta chi jun vinek que ta ri' nuben. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Y ronojel c'a juna' pa ru-tiempo ri nimak'ij rubini'an pascua, ri k'atoy-tzij can nucol-vi c'a el jun chique ri ec'o pa cárcel. Rija' nucol c'a el ri preso ri nicajo' ri vinek chi nel-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Y chupan c'a ri tiempo ri', c'o c'a preso jun achin rubini'an Barrabás, jun achin ri can etaman-vi ruvech chi janíla itzel. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Y chique c'a ri vinek ri xbequimolo-qui' chiri', ri Pilato xubij-pe: ¿Achique c'a ri nivajo' rix chi yin nincol ta el chique rije'? ¿Nivajo' chi nincol-el ri Barrabás o ja ri Jesús ri nibix chuka' Cristo chire? xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ri Pilato can que vi c'a ri' ri xubij-pe, roma rija' can retaman-vi chi ri vinek ri' quiyo'on ri Jesús pa ruk'a', roma itzel niquina' chire chi janíla e q'uiy ri ye'ojkan richin. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Y ri Pilato tz'uyul c'a ri acuchi nuk'et-vi tzij, tok xapon c'a rutzijol riq'uin ri rubin-el ri rixjayil. Ri rixjayil rutakon c'a el rubixic chire: Ri Jesús jun achin choj, romari' rat, man catoc cachibil ri ye'ajovan rucamic. Roma yin xinben jun itzel achic' roma ri Jesús. Que c'a ri' ri rutakon-el rubixic ri rixjayil ri Pilato. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Y ri principal-i' tak sacerdotes y ri rijita'k tak achi'a' ri c'o quik'ij, xequich'ec c'a ri vinek richin chi tiquic'utuj c'a chi ja ri Barrabás ri ticol-el y ri Jesús ticamisex. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Y jac'a tok ri k'atoy-tzij xuc'utuj chic jun bey chique ri vinek ri' chi achique c'a chique che ca'i' ri xtucol-el, ri vinek ri' can jac'ari' xquibij: Ja ri Barrabás tacolo-el, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","C'ari' ri Pilato xuc'utuj c'a chique ri vinek: ¿Y achique c'a ri nibij rix chi yin ninben ta riq'uin ri Jesús, ri nibix chuka' Cristo chire? xcha' rija'. Can jac'ari' tok conojel xech'on-apo y xquibij: Ri Jesús xa ticamisex chuvech cruz, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Xpe c'a ri k'atoy-tzij xubij chique ri vinek: ¿Achique c'a rumac rubanon chivech? Pero ri vinek man yetane' ta ka. Xa riq'uin más uchuk'a' xech'on-apo y xquibij: Xa ticamisex chuvech cruz, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Y tok ri Pilato xutz'et chi xa man jun chic c'a ri nitiquir nuben y ri vinek xa xquichop janíla niquiben, xpe rija' xberuc'ama-pe juba' ruya' y xuch'ej ruk'a' chiquivech conojel ri vinek ri', y xubij: Yin man jun numac chire ri rucamic re jun chojmilej achin re'. Ri' xa jac'a rix, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Xepe conojel ri vinek xquibij c'a: Xa pa kavi' c'a roj y pa quivi' ri e kami'al-kac'ajol can, tika-vi ri rucamic re jun achin re', xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jac'ari' tok ri k'atoy-tzij can chiquivech vi c'a ri vinek xucol-el ri Barrabás, jac'a chire ri Jesús xa nabey na c'a xutek ruch'ayic, c'ari' xujech-el richin chi ticamisex chuvech cruz. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Y ri soldados richin ri k'atoy-tzij ri' xquic'uaj c'a apo ri Jesús chupan ri palacio. C'ari' xecoyoj c'a conojel ri ch'aka' chic soldados, ri e cachibil. Xequimol c'a apo chirij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xepe ri soldados ri' xquelesaj c'a el ch'aka' rutziak ri Jesús, c'ari' xquiya' c'a jun tziek quek chirij can achi'el vi ri yequicusala' ri reyes. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Rije' xquipach'uj chuka' jun k'ayis ri janíla ruq'uixal. Can achi'el jun corona xquiben chire, y c'ari' xquiya' pa rujolon (ruvi') ri Jesús. Y xquiben chuka' chire ri Jesús chi xuchop jun aj ri pa rajquik'a'. Y riq'uin tze'en c'a tok yexuque' chuvech ri Jesús y niquibila' c'a: Caquicot c'a janíla, rat ri qui-Rey ri israelitas, yecha' c'a chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Can niquichubala' c'a chuka' ri Jesús y niquelesala' ri aj c'o pa rajquik'a' richin niquiboj pa rujolon (ruvi'). ");
INSERT INTO cakCNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Y tok rije' xetane' c'a chi tze'en chirij, xquelesaj-el ri tziek ri quiyo'on-ka chirij. C'ari' xquiya-el ri can rutziak vi rija', y xquic'uaj c'a el richin chi nequibajij chuvech cruz. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Y jac'a tok quichapon-el elen chupan ri tinamit, xquic'ul jun achin; y ri achin ri' rubini'an Simón y rija' aj-Cirene. Xepe c'a ri soldados can xquiben-vi c'a chire ri achin ri' chi tuc'uaj-el ri ru-cruz ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Y xe'apon c'a chupan ri jun juyu' rubini'an Gólgota. Ri juyu' ri', Calavera chuka' yecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tok can ec'o chic c'a chiri', chire ri Jesús xquiya' c'a jun ch'amilej ruya'al-uva xolon riq'uin jun c'ayilej ak'on. Pero tok rija' xuna' ri xquiya' chire, man xrajo' ta. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Y tok ri soldados quibajin chic ri Jesús chuva ri cruz, xquiya' c'a pan etz'anen ri rutziak ri Jesús richin xquitz'et achique chi tziek ri niquic'uala-el chiquijujunal. Y riq'uin ri' can nibanatej c'a ri bin can roma ri jun ri xk'alajirisan ri ruch'abel ri Dios ojer can. Ri rusamajel c'a ri Dios can rutz'iban-vi can chirij ri Cristo: Xequijech ri nutziak y chuka' xequiya' pan etz'anen. Queri' ri rutz'iban can. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ri soldados e tz'uyul c'a chiri' quichajin-apo ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Y chutza'n el ri cruz, rije' xquiya' c'a jun tz'alen ri tz'iban-el chuvech ri achique rumac ri Jesús, y romari' nicamisex. Chuvech ri tz'alen ri' nubij c'a: Ri Jesús jari' ri qui-Rey ri israelitas. Que c'a ri' ri nubij. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Y jac'a chuka' ri' tok ec'o e ca'i' elek'oma' ri yecamisex chuvech cruz. Jun c'a xc'oje' pa rajquik'a' ri Jesús y ri jun chic pa rajxocon (izquierda). ");
INSERT INTO cakCNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ri vinek c'a ri yek'ax-el y ye'apon riq'uin ri Jesús, niquisilola-apo quijolon (quivi') chuvech, roma can man niquinimaj ta chi ja rija' ri Ruc'ajol ri Dios. Y c'o chuka' ch'abel ri yequibila' can chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ri vinek ri' niquibila' c'a can chire ri Jesús: Rat ri yabin chi navulaj ri rachoch ri Dios y pan oxi' k'ij naben chic jun bey, tacolo' c'a avi' ayon. Y vi ja rat ri Ruc'ajol ri Dios, caka-pe chuva la a-cruz, yecha' c'a can chire. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Y ja chuka' ch'abel ri' ri niquibila' ri principal-i' tak sacerdotes. Rije' y ri etamanela' chirij ri ley, ri achi'a' fariseos y ri rijita'k tak achi'a' ri can c'o-vi janíla quik'ij, niquitze'ej c'a ri Jesús y niquibila' c'a chiquivech: ");
INSERT INTO cakCNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Rija' can e q'uiy vi c'a xerucol, pero rija' man nitiquir ta nucol-ri'. Y vi can jac'a rija' ri Rey richin re tinamit Israel, tika' c'a pe chuva la ru-cruz y roj can xtikacukuba-vi kac'u'x riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Rija' can xucukuba-vi ruc'u'x riq'uin ri Dios, y vi ri Dios can nrajo-vi re Jesús, tucolo' c'a. Roma re Jesús xa can rubin-vi: Ja yin c'a ri Ruc'ajol ri Dios. Can que vi c'a ri' rubin, xecha' ri achi'a' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Y ri elek'oma' ri e bajin chuvech qui-cruz cachibilan ri Jesús, can jac'a chuka' niquiben, achi'el ri ch'aka' chic. Can c'o chuka' niquibila-apo chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Y tok xnic'ajer c'a pe ri jun k'ij ri', jac'ari' tok xk'ekumer chi jun ruvach'ulef. Y ri k'eku'n ri' xq'uis c'a el ri las tres ri tikak'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jac'a ri pa tak las tres ri', jari' tok ri Jesús xch'on-pe riq'uin ronojel ruchuk'a' y xubij c'a: Elí, Elí, ¿lama sabactani? xcha'. Y ri ch'abel ri' nubij: Nu-Dios yin, nu-Dios yin, ¿achique c'a roma tok xinamalij can? ");
INSERT INTO cakCNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Y ec'o ri ec'o-apo chiri' chunakaj ri Jesús, tok xcac'axaj ri xubij, xquibila' c'a: Rija' ja ri Elías ri nroyoj, xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Y can ja vi c'a ri' tok c'o c'a jun ri junanin xberuc'ama-pe jun achi'el bo'j ri nibix esponja chire, xumuba' pa jun ch'amilej ruya'al-uva. C'ari' xuya' ri esponja chutza'n jun aj, richin xuya' chire ri Jesús richin chi nich'uch'u-ka juba' ri nichaki'j ruchi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero ri ch'aka' ri ec'o-apo chiri' riq'uin ri Jesús, xquibij: Taya' can, xa tikoyobej na k'alaj ri' vi nipe ri Elías chucolic, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pero ri Jesús xa jac'ari' tok xch'on chic riq'uin ronojel ruchuk'a', y xujech c'a ri ránima pa ruk'a' ri Dios; xquen (xcom). ");
INSERT INTO cakCNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Y jac'ari' tok ri tziek ri achok iq'uin ch'aron-vi ri rupan ri rachoch ri Dios xel pa ca'i'. Xuchop-pe pa jotol c'a pa xulan ka. Chuka' ri ruvach'ulef can xsilon-vi c'a y ri abej xerajro' (xerekero') y xepax. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ri jul ri e mukun-vi ri caminaki' xejakatej. Y e q'uiy c'a chique ri lok'olej tak ralc'ual ri Dios ri can e uxlavinek chic el, xec'astej, ");
INSERT INTO cakCNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","y xebe'el-pe. Jac'a tok c'astajinek chic pe ri Jesús, jari' tok xetz'etetej chuka' rije'. Rije' xe'apon c'a ri pa lok'olej tinamit Jerusalem. Can chiquivech vi c'a e q'uiy ri xquic'utula-vi-qui'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ri achin Capitán y conojel ri ec'o chiri' quichajin-apo ri Jesús, tok quitz'eton chic ka ri xuben ri silonel (cab-raken), y quitz'eton chuka' chic ri ch'aka' chic ri xebanatej, rije' can janíla c'a xquixibij-qui' y xquibila' c'a: Can kitzij na vi chi re jun achin re' Ruc'ajol ri Dios, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Y e q'uiy c'a ixoki' ri can quitzekelben-vi-pe ri Jesús tok xel-pe ri chiri' pa Galilea richin chi niquilij, rije' yetzu'un c'a apo, pero c'anej c'a ec'o-vi-el. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Y chiquicojol c'a conojel ri ixoki' ri', c'o c'a ri María Magdalena, ri María ri quite' ri Jacobo y ri José, y chuka' ri rixjayil ri achin rubini'an Zebedeo; ri quite' ri Jacobo y ri Juan. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jac'a tok xkak'ij yan, c'o c'a jun tzekelbey richin ri Jesús ri xapon. Jun beyon aj pa tinamit Arimatea, rubini'an José. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Rija' xbe c'a riq'uin ri Pilato ri k'atoy-tzij y xberuc'utuj ri ruch'acul ri Jesús richin numuk. Y ri Pilato xubij c'a chi tijach-pe ri ruch'acul ri Jesús chire ri José. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Y ri José richin xuc'uaj-el ri ruch'acul ri Jesús, xberuc'ama' c'a pe, y c'ari' xubir-el (xuber-el) pa jun ch'ajch'ojilej tziek. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ri José aj-Arimatea, xberuya' c'a can ri ruch'acul ri Jesús pa jun c'ac'a' jul, jun jul ri ruc'oton rija' chuvech jun juyu' ri xa can abej vi. Y tok rija' rutz'apen chic c'a can ri jul riq'uin jun nimalej setesic abej, xtzolin c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ri María Magdalena y ri jun chic ixok rubini'an chuka' María, can xetz'uye-vi c'a ri chuvech ri jul tok xmuk can. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ri k'ij tok xmuk ri Jesús, ja k'ij chuka' ri' tok ri vinek niquibanala' chic rutzil ronojel ri xtic'atzin chique ri ruca'n k'ij, roma jari' napon ri uxlanibel-k'ij. Y pa ruca'n k'ij, tok ec'o chic chupan ri uxlanibel-k'ij, jari' tok ri principal-i' tak sacerdotes y ri achi'a' fariseos xquiben c'a chi xbequic'ulu-qui' chuvech ri Pilato ri k'atoy-tzij. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Rije' xbequibij c'a chire: Roj xoka' chikac'u'x chi tok ri Jesús can c'a q'ues na, xubij c'a chi xtic'astej-pe pa rox k'ij. Can que vi c'a ri' rubin can ri k'olonel ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Y richin c'a chi man quepe ri rutijoxela' y tiquelek'aj-el ri ruch'acul ri Jesús re chak'a', y c'ari' niquibij chique ri vinek: Ri Jesús can xc'astej-vi-el chiquicojol ri caminaki'; romari' oj petenek re vacami richin nikac'utuj utzil chave chi tataka' ruchajixic ri acuchi mukun-vi can, c'a tok nitz'aket na ri oxi' k'ij. Y vi man xtikaben ta queri' y nisach-el ri ruch'acul, c'ari' c'a más e q'uiy ri xqueniman chi can takon-vi-pe roma ri Dios, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Y ri Pilato xubij c'a chique ri achi'a' ri': Quixbiyin c'a y que'ic'uaj-el la achi'a' chajinela' la'. Rix xa can ivetaman chic c'a jebel achique rubanic ri c'o chi niben can chire, xe'uche'ex. ");
INSERT INTO cakCNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ri achi'a' ri' can jac'ari' xebe acuchi mukun-vi can ri Jesús y nequichojmirisaj can chi tichajix jebel. Xquiya' c'a can retal ri abej tz'apeben can ruchi' ri jul, ri xtic'utun vi c'o ri nijakon. Y xequiya' chuka' can chajinela' chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Y tok can k'axinek chic ri uxlanibel-k'ij, nimak'a' yan chire ri domingo ri nabey k'ij richin ri semana, ri María Magdalena y ri jun chic ixok rubini'an chuka' María xebe c'a; richin yebe c'a chuchi-jul ri acuchi mukun-vi can ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pero tok can c'a man jani c'a ye'apon ta ri ixoki' chiri' chuchi-jul, xsilon c'a ri ruvach'ulef. Roma jun ángel richin ri Ajaf ri petenek chila' chicaj, xka-pe chupan ri lugar ri'; ri acuchi mukun-vi can ri Jesús. Ri ángel xrelesaj c'a ri setesic abej ri tz'apebel-ruchi' ri jul y xtz'uye-ka pa ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ri rusakil c'a ri ángel ri tz'uyul pa ruvi' ri abej, xa can junan c'a riq'uin ri sakil nuya' jun coyopa'. Y ri rusakil ri rutziak can junan c'a riq'uin ri rusakil ri tef ri nika'. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Y ri achi'a' chajinela' roma c'a janíla xquixibij-qui' chuvech ri ángel, can xebaybot-vi c'a (xebarbot-vi c'a). Can xequen c'a (xecom c'a) roma quixibinri'il. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jac'a ri ángel tok xch'on quiq'uin ri ca'i' ixoki', xubij c'a chique: Rix man c'a tixibij-ivi'. Roma yin can vetaman-vi chi rix ja ri ruch'acul ri Jesús ri xcamisex chuva ri cruz ri nicanoj. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ri ruch'acul rija' xa manek chic vave', roma rija' xc'astej yan el, achi'el ri rubin can chive. Quixampe y titzu' na pe' ri acuchi xc'oje-vi ri ruch'acul ri Ajaf. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Can quixtzolin c'a chanin, richin chi nibij c'a chique conojel ri rutijoxela' ri Jesús chi rija' xc'astej yan c'a el chiquicojol ri caminaki'. Rija' can ninabeyej c'a el chivech, richin chi nic'ul-ivi' chila' pa Galilea. Y chiri' xtitz'et-vi, achi'el re ninbij-el chive. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Y ri ca'i' ixoki' ri' can jac'ari' xe'el-el ri chiri' pa jul. Y stape' can quixibin-qui', xa can yequicot c'a chuka' janíla. Rije' can junanin c'a xebe richin chi nequiya' rutzijol chique ri rutijoxela' ri Jesús. Rije' can quichapon-vi c'a el bey. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Y jac'ari' tok ri Jesús xbec'ulun-pe chiquivech ri pa bey y xubij c'a chique: Can quixquicot c'a, xcha' chique richin xeruk'ejela' (xeruk'ijala'). Y ri ca'i' ixoki' ri' can jari' xexuque-ka chiraken ri Jesús, xquik'etej ri raken y can xquiya' c'a ruk'ij chuka'. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Y ri Jesús can jac'ari' tok xubij chique ri ixoki' ri': Man chic c'a tixibij-ivi'. Vacami quixbiyin c'a y te'iya' rutzijol chique ri vach'alal. Richin chi can quebiyin c'a pa Galilea y chila' c'a xquinquitz'et-vi, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ri ixoki' ri' can c'a quichapon na c'a bey. Y jac'ari' tok ec'o chique ri chajinela' ri chiri' chuchi-jul xebe c'a pa tinamit Jerusalem. Ri chajinela' ri' xbequiya' c'a rutzijol chique ri principal-i' tak sacerdotes, ri ronojel c'a ri xbanatej ri chiri' acuchi xmuk-vi ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Xepe ri principal-i' tak sacerdotes xquimol c'a qui' quiq'uin ri rijita'k tak achi'a' ri can c'o quik'ij y xquiya-vi c'a chiquivech chi niquiya' janíla qui-mero ri soldados ri xechajin. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Y xquibij c'a chique ri chajinela': Rix xaxe c'a tibij chi ja tok yixver jari' tok xe'apon ri rutijoxela' ri Jesús pa k'eku'n y xquelek'aj-el ri ruch'acul. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Y vi ri k'atoy-tzij nretamaj c'a chi xa xixver-ka y man xixchajin ta achi'el ri bin chive, roj xkojbech'on c'a riq'uin y xkojrunimaj. Y queri' xquixkacol pa ruk'a', xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ri soldados ri xechajin chuchi-jul xquic'ul-vi c'a el ri mero, y achi'el ri xbix-el chique can ja vi c'a ri' xquiben. Ronojel c'a re' xa can xbiyin yan rutzijol, y jare' ri etaman coma ri vinek israelitas c'a chupan re k'ij re'. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jac'a ri julajuj rutijoxela' ri Jesús, xebe c'a pa Galilea. Xebe c'a pa ruvi' ri juyu' ri bin can chique roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Y tok xquitz'et c'a ruvech ri Jesús, rije' can xquiya' c'a ruk'ij. Y xa can c'a ec'o na c'a ri man jani niquinimaj ta chi ri Jesús jari' ri c'o quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ri Jesús can xjel c'a pe quiq'uin richin nitzijon, y xubij c'a chique: Ronojel can pa nuk'a' c'a yin jachon-vi, can queri' chila' chicaj y que chuka' ri' vave' chuvech re ruvach'ulef. Can ronojel c'a ri uchuk'a' yo'on chuve. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Roma c'a ri' re vacami can ninbij-vi chive: Quixbiyin c'a ronojel ruvach'ulef y ri vinek ye'oc ta c'a tzekelbey vichin. Ri can yinquitzekelbej c'a, que'ibana' bautizar pa rubi' ri Dios Tata'ixel, pa nubi' yin ri C'ajolaxel y pa rubi' ri Lok'olej Espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Y tic'utu' chiquivech chi tiquitakej ronojel ri nubin can. Y yin can k'ij-k'ij c'a xquic'oje' iviq'uin; can xquic'oje-vi iviq'uin c'a tok re ruvach'ulef xtapon chupan ri ruq'uisibel k'ij. Can que vi c'a ri'.");
INSERT INTO cakCNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Que c'a re' tok xtiquir-el ri utzilej ch'abel richin colotajic, ruch'abel ri Jesucristo ri Ruc'ajol ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ri Isaías, ri xk'alajirisan ri ruch'abel ri Dios ojer can, rutz'iban c'a can ri xbix chire roma ri Dios chirij ri Jesucristo. Y jare' ri xutz'ibaj can rija: Xtintek c'a jun achin nabey, richin chi nuchojmirisaj ri bey ri xtapon-vi ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jac'a achin re' ri xtic'oje' pa tz'iran ruvach'ulef. Rija' xtutzijoj c'a ri ruch'abel ri Dios chiquivech ri vinek ri xque'apon riq'uin. Y xtubila' c'a chique: Tichojmirisala' rubey ri ic'aslen, roma nakaj chic c'o-vi ri rupetebel ri Ajaf. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ri achin ri xunataj c'a ri Isaías chi xtipe nabey, ja ri Juan ri Bautista. Y rija' c'o c'a pa tz'iran ruvach'ulef y nubij chique ri vinek ri ye'apon riq'uin, chi titzolej-pe quic'u'x riq'uin ri Dios y tiquibana' bautizar qui', richin queri' ri Dios nucuy quimac. Y e q'uiy ri yeruben-el bautizar rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Y ri vinek c'a ri ye'apon riq'uin ri Juan ri Bautista, can e janíla e q'uiy. Ec'o ri aj pa tinamit Jerusalem, ri tinamit ri c'o chiri' pa Judea. Y ec'o ri aj pa ch'aka' chic tinamit richin ri Judea chuka'. Re vinek c'a re' yeban c'a el bautizar roma rija' ri chiri' pa raken-ya' Jordán. Rije' can yequik'alajirisala-vi c'a ri quimac chuvech ri Juan ri Bautista. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ri rutziak c'a ri Juan banon riq'uin rusmal camello, y jun tz'un ri ximbel-rupan. Y ri ruvay, ja ri sac' y cab ri niquiya' ri tak chicop pa tak juyu'. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ri Juan nuk'alajirisaj c'a chique ri vinek: C'o Jun ri xtipe re chikavech apo ri man achi'el ta oc yin. Ri Jun ri' can nim vi ruk'ij y nim chuka' ri ruchuk'a'; romari', stape' yin yiluque-ka richin chi ninsol ri ruximbal ri ruxajab, hasta ri' man ruc'amon ta chuve roma nim ruk'ij y nim ruchuk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Y yin, ya' ri nincusaj richin yixinben bautizar. Pero ri Jun ri xtipe, riq'uin ri Lok'olej Espíritu xquixruben-vi bautizar. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Je k'ij c'a ri' tok ri Jesús elenek-pe pa tinamit Nazaret chiri' pa Galilea y xoka' riq'uin ri Juan. Y rija' chuka' xban c'a bautizar roma ri Juan ri pa raken-ya' Jordán. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Y tok ri Jesús nel c'a pe pa ya', xutz'et chi ri caj xjakatej, y ri Lok'olej Espíritu nika' c'a pe pa ruvi' achi'el jun paloma. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Y jac'ari' tok c'o jun ch'abel xpe chila' chicaj y xubij: Ja rat ri Nuc'ajol, janíla yatinvajo' y nucukuban nuc'u'x aviq'uin, xcha' ri ch'abel ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Can jari' tok ri Jesús xban chire roma ri Lok'olej Espíritu chi xbe pa tz'iran ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Y can nik'alajin chi pa tz'iran ruvach'ulef c'o-vi roma can ec'o-apo ri itzel tak chicopi' que tak ri'. Chiri' c'a xc'oje-vi cavinek k'ij. Y tok ri Jesús c'o c'a chiri', ri Satanás nutej c'a ruk'ij chirij richin nitzak ta pa ruk'a', pero man xtiquir ta chirij. Y ri ángeles xquilij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","C'o chic c'a ri Juan pa cárcel, tok ri Jesús xbe pa Galilea. Ri Jesús nutzijoj c'a ri utzilej ruch'abel ri Dios ri nich'on chirij tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios, ");
INSERT INTO cakCNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","y nubij c'a: Ri tiempo ri rubin can ri Dios chi ri vinek ye'oc pa rajavaren o pa ruk'a' rija', xoka' yan c'a. Titzolej c'a pe ic'u'x y tinimaj ri utzilej ch'abel richin colotajic, nicha' c'a rija' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Y jun k'ij ri Jesús tok benek c'a chuchi' ri nima-ya' rubini'an Galilea, xerutz'et c'a ca'i' achi'a' cach'alal qui'; Simón rubini'an ri jun y Andrés rubini'an ri jun chic. Ri ca'i' c'a achi'a' ri' e chapoy tak quer, romari' tok niquiq'uek c'a ri quiya'l chapbel-quer ri pa ya'. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Y tok ri Jesús xch'on quiq'uin re chapoy tak quer re', xubij chique: Rix ca'i' chapoy tak quer, quinivojkaj c'a, y xtinc'ut chivech achique rubanic ye'ichop vinek richin yinquitzekelbej. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ri ca'i' achi'a' ri', can jari' xquiya' can ri chapoj-quer y xquitzekelbej-el. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Y c'a juba' c'a quebiyin, tok ri Jesús jari' xpa'e' yan. Rija' xerutz'et c'a ri Jacobo y ri Juan, ri e ruc'ajol ri jun achin rubini'an Zebedeo. Ri e ca'i' achi'a' ri' pa canoa c'a ec'o-vi, yesamej. Rije' yequic'ojoj ri quiya'l chapbel-quer. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Y xpe c'a ri Jesús xeroyoj richin chi niquitzekelbej. Y ri Jacobo y ri Juan can xe chuka' xcac'axaj queri', xebe chirij. Y xaxe c'a ri quitata' y ri samajela' ri xec'oje' can chiri' pa canoa. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ri Jesús y ri e benek riq'uin, xe'apon c'a pa tinamit Capernaum. Y chupan ri k'ij richin uxlanen, ri Jesús xbe c'a pa nima-jay ri can nitzijox-vi ri ruch'abel ri Dios. Rija' nubij c'a ri ruch'abel ri Dios chique ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Y ri xe'ac'axan richin, xsach quic'u'x roma ri ch'abel ri xcac'axaj. Roma ri rubanic ri rutijonic, can jun tijonic richin jun ri c'o uchuk'a' pa ruk'a' y man achi'el ta oc ri quitijonic ri achi'a' e etamanela' chirij ri ley. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Y ri chiri' pa nima-jay richin quimolojri'il ri vinek, ri k'ij ri' c'o c'a apo jun achin ri c'o jun itzel espíritu riq'uin. Y ri itzel espíritu ri c'o riq'uin ri achin, riq'uin ruchuk'a' xch'on. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Y xubij c'a chire ri Jesús: ¿Achique c'a ri navajo' chike, rat Jesús aj-Nazaret? ¿Xape c'a richin chi yojaq'uis? Yin vetaman at achique rat y romari' vetaman chi rat can at lok'olej vi y at petenek riq'uin ri Dios, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero ri Jesús xubij chire ri itzel espíritu: Man chic cach'on. Catel-el. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Y ri itzel espíritu nisiq'uin c'a xel-el. Y xuyiquiquej can ri ruch'acul ri achin ri achok iq'uin xel-vi-el. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Y ri vinek ri quimolon-qui' chiri', xsach quic'u'x tok xquitz'et ri xuben ri Jesús, y niquibila' c'a chiquivech: ¿Achique c'a chi tijonic y banobel re'? Roma re tijonic re e ruc'amon-pe rija', man jun bey kac'axan ta roj. Tok nich'on, can ja ri nubij rija' ri c'o chi niban. Ri itzel tak espíritu can niquinimaj rutzij, yecha' c'a ri vinek chiquivech ka rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Y chanin c'a xbiyin rutzijol ri Jesús, y romari' ri vinek ri ec'o pa tak tinamit ri ec'o-pe chunakaj ri Galilea, chanin c'a xquetamaj ri nubanala' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tok ri Jesús, ri Jacobo y ri Juan xe'el c'a pe ri chiri' pa nima-jay ri can nitzijox-vi ri ruch'abel ri Dios, rije' xebe c'a chicachoch ri Simón y Andrés. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pero tok xe'apon c'a, xbix chire ri Jesús chi ri rujite' ri Simón kajinek pa varabel, roma jun nimalej c'aten. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Y ri Jesús can jac'ari' xberutzu' ri yava'. Rija' xuchop c'a ruk'a' ri yava' y xuben chire chi xyacatej. Y can xe c'a queri' xuben chire, can jari' xq'uis-el ri c'aten chirij. Y ri ixok ri' can jac'ari' xuchop quilixic ri Jesús y ri e benek riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Y jac'a tok xka' yan ka ri k'ij y xocok'a' yan c'a pe chupan ri k'ij ri', jac'ari' tok can conojel ri vinek ri c'o yava'i' quiq'uin xequic'uala-apo chuvech ri Jesús. Ri yava'i' c'a ri', c'o ri choj chi yabil ri noc chique y ec'o c'a ri e yava'i' pa quik'a' itzel tak espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Can e janíla vi e q'uiy ri vinek ri xquimol-apo-qui' chiri', xa can jubama conojel ri vinek ri ec'o chupan ri jun tinamit ri' ri xe'apon ri achique jay c'o-vi ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Y ri Jesús can xeruc'achojirisala-vi-el ri yava'i'. Ri yava'i' ri' can jalajoj c'a ruvech yabil ri chapayon quichin. Chuka' rija' xerelesala-el ri itzel tak espíritu ri ec'o quiq'uin ri vinek ri e chapon coma itzel tak espíritu. Ri Jesús can man xuya' ta c'a k'ij chique ri itzel tak espíritu richin xech'on ta, roma rije' quetaman ri achique rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nimak'a' yan ruca'n k'ij, ri Jesús xyacatej-el y xbe pa tz'iran ruvach'ulef richin xberubana' orar. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Y ri Simón y ri e rachibil xebe c'a canoy richin ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tok xquil c'a, xquibij chire: Yacanox coma conojel vinek, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Y ri Jesús xubij c'a chique: Jo' pa ch'aka' chic tinamit ri ec'o-pe nakaj, richin chi nentzijoj chuka' ri ruch'abel ri Dios chiri', roma chubanic ri samaj ri' tok xipe vave' chuvech re ruvach'ulef, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Y rija' xbe c'a chutzijoxic ri ruch'abel ri Dios pa ronojel ri Galilea. Xabachique c'a tinamit napon-vi, rija' nutzijoj ri ruch'abel ri Dios ri pa tak nima-jay ri niquimol-vi-qui' ri vinek richin nicac'axaj ri ruch'abel ri Dios. Y chuka' can xerelesala' c'a ri itzel tak espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","C'o c'a jun achin ri c'o ri jun itzel yabil chirij, ri rubini'an lepra. Ri achin ri' xapon riq'uin ri Jesús, xxuque-ka chuvech y xubij c'a chire: Yin vetaman chi rat yatiquir yinac'achojirisaj chire re nuyabil, pero man vetaman ta achique nanojij pa nuvi', xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ri Jesús can janíla c'a xujoyovaj ruvech ri achin ri ruc'ulvachin ri yabil ri'; romari' rija' can jac'ari' xuchop-apo y xubij chire: Ninvajo' chi yac'achoj. Tiq'uis c'a el re yabil re' chavij, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Y can xe xubij quere' ri Jesús, ri ru-lepra ri achin xq'uis-el y xch'ajch'ojir c'a can. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Y ri Jesús, can jac'ari' xubij chire ri achin chi tibe, pero can janíla c'a xuchilabej chire ri achique nic'atzin chi nuben. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ri Jesús xubij c'a el chire ri achin ri': Man taya' rutzijol ri achique ri xbanatej aviq'uin, xa choj cabiyin pa rachoch ri Dios richin te'ac'utu-avi' chuvech ri sacerdote. Y can taya' c'a ri nubij chupan ri vuj ri rutz'iban can ri Moisés. Chupan ri vuj ri' nubij ri nic'atzin chi naya' rat. Richin queri' nak'alajirisaj c'a chiquivech chi at ch'ajch'oj chic, xuche'ex-el. ");
INSERT INTO cakCNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero ri achin xa can xe c'a xuya' can ri Jesús, xa xuchop c'a rutzijoxic chique ri vinek ri achique xbanatej riq'uin rija'. Y romari' ri Jesús chanin c'a xel rutzijol, y man nitiquir ta chic c'a noc-apo ri pa tak tinamit ri napon-vi, roma xa can e janíla ri vinek ri yec'ulun-apo richin. Y roma chuka' ri', ri Jesús nic'oje' c'a can ri pa tak juyu'. Ri lugar e manek vinek. Y ri vinek c'a ri ye'apon riq'uin can e janíla c'a e q'uiy, y chuka' q'uiy lugar yepe-vi ri vinek ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Y tok ic'ovinek chic c'a ca'i-oxi' k'ij, ri Jesús xtzolin ri pa tinamit Capernaum, y jac'ari' tok ri vinek xcac'axaj chi rija' c'o pa jun jay ri chiri' pa tinamit. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jari' tok ec'o vinek ri can chanin c'a xquimol-apo-qui' achique jay c'o-vi ri Jesús. Man yeruben ta chic c'a ri pa jay, romari' can c'a ri chuva-jay el ec'o vinek. Ri pa ruchi-jay can man jun chic c'a nitiquir noc. Y ri Jesús can nubij c'a ri ruch'abel ri Dios chique conojel ri xquimol-apo-qui'. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jac'a chuka' ri' tok ec'o ch'aka' chic ri xe'apon. Rije' quic'uan c'a apo jun achin siquirinek. E caji' c'a ri e uc'uayon-apo richin ri achin siquirinek y rije' quili'en-el chuvech ri ruvarabel. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero rije' xa man xetiquir ta xe'oc-apo c'a riq'uin ri Jesús, coma ri vinek ri quimolon-apo-qui' can janíla e q'uiy. Man xetiquir ta c'a xek'ax chiquicojol ri vinek ri', romari' ja chic ri ruvi' ri jay ri xquichobij. Y ri jul ri xquiben can ja ri acuchi c'o-vi ri Jesús chiri' xquiben-vi-ka. Y chiri' c'a xquikasaj-vi-ka ri yava', rachibilan ri ruvarabel. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Y tok ri Jesús xerutz'et chi can quicukuban quic'u'x riq'uin rija', xubij c'a chire ri achin siquirinek: Valc'ual, xcha' chire. Ri amac xecuyutej. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Y ri jay ri quimolon-vi-qui', ec'o chuka' apo etamanela' chirij ri ley, y rije' e tz'uyul c'a. Rije' niquich'ob c'a pa tak cánima: ");
INSERT INTO cakCNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Achique roma tok re Jesús nubij chire la achin chi nucuy rumac? Can nuben chi ja rija' ri Dios. ¿Roma achique ta c'a vinek nicuyun mac? Man jun. Xaxe ri Dios ri nicuyun mac, yecha' c'a pa tak cánima ri etamanela' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero ri Jesús can retaman-vi ri niquich'ob pa tak cánima ri achi'a' ri'. Y romari' xubij chique: ¿Achique c'a roma tok rix quere' nich'ob pa tak ivánima? ");
INSERT INTO cakCNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Roma vi yin yitiquir ninben chire re jun achin siquirinek chi nibiyin-el, y nuc'uaj-el la ruvarabel, ¿yitiquir ta cami chuka' ninbij chire chi nincuy rumac? ¿Achique nibij rix? ");
INSERT INTO cakCNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vacami c'a, richin chi rix nivetamaj chi yin ri xinalex chi'icojol can c'o uchuk'a' pa nuk'a' richin nincuy mac, titz'eta' c'a. Y ri Jesús xubij c'a chire ri achin siquirinek: ");
INSERT INTO cakCNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ninbij c'a chave: Cayacatej, tac'uaj-el la avarabel y cabiyin chi'avachoch, xuche'ex roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Y ri achin can jari' xpa'e-el, xuc'ol-el ri ruvarabel, y xel-el chiquicojol ri quimolon-qui' chiri'. Y ri vinek ri' xsach c'a quic'u'x, roma man jun bey quitz'eton chi que ta ri' nic'ulvachitej. Y xquiya' c'a chuka' ruk'ij-ruc'ojlen ri Dios y xquibila' c'a: Man jun bey katz'eton chi que ta re' nibanatej, xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Y ri Jesús xbe chic c'a chuchi' ri nima-ya' jun bey; y e janíla e q'uiy vinek ri xe'apon riq'uin, y rija' yerutijoj c'a riq'uin ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Y jac'a tok rija' ruchapon bey richin nitzolin, jari' tok xutz'et ri Leví, ri ruc'ajol ri jun achin rubini'an Alfeo. Ri Leví tz'uyul c'a pa jun ch'aquet, nuc'ul can ri alcaval ri yetoj can. Xpe ri Jesús xubij c'a chire: Quinatzekelbej. Y jac'ari' tok rija' xbeyacatej-pe ri acuchi tz'uyul-vi y xrojkaj-el ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Y jac'a tok rija' tz'uyul pa mesa ri chiri' pa jay, e q'uiy c'a chique ri moloy tak alcaval y ch'aka' chic vinek ri aj-maqui' nibix chique, xetz'uye-apo ri pa mesa; junan riq'uin ri Jesús y ri rutijoxela'. Can e janíla c'a e q'uiy ri yetzekelben richin ri Jesús ri ec'o c'a chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Y tok ri etamanela' chirij ri ley y ri achi'a' fariseos xquitz'et ri Jesús chi xa niva' quiq'uin ri moloy tak alcaval y quiq'uin ri vinek ri nibix aj-maqui' chique, xquic'utuj c'a chique ri rutijoxela': ¿Achique roma la' chi rija' niva-nuc'ya' quiq'uin moloy tak alcaval y quiq'uin la aj-maqui'? xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Y tok ri Jesús xrac'axaj-pe ri tzij ri niquibij ri etamanela' y ri achi'a' fariseos, rija' xubij chique: Jun ak'omanel man ja ta ri e utz ri yerak'omaj. Rija' yerak'omaj ri c'o quiyabil. Yin man xipe ta chiquicanoxic vinek ri choj quic'aslen. Yin xipe chiquicanoxic ri aj-maqui', ri nic'atzin chi nitzolej-pe quic'u'x riq'uin ri Dios, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ri rutijoxela' ri Juan ri Bautista y ri quitijoxela' ri achi'a' fariseos, c'o c'a k'ij quicha'on richin man yeva' ta, richin chi niquiben orar. Y romari' xoquic'utuj c'a chire ri Jesús: Roj ri rutijoxela' ri Juan y ri quitijoxela' ri fariseos can kacha'on k'ij richin man yojva' ta, richin nikaben orar. ¿Y achique c'a roma tok ri atijoxela' rat man que ta ri' niquiben? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Y ri Jesús xubij c'a chique: ¿Achique nibij rix? ¿Utz cami chi man yeva' ta ri e oyon pa jun c'ulubic y c'a c'o-apo ri ala' c'a ruc'ulubic quiq'uin? Man utz ta. Can man utz ta c'a ri niquiben vi xa man yeva' ta, roma ri ala' xa c'a c'o na quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero xtapon ri k'ij tok re ala' re' xtelesex-el chiquicojol, y jari' tok xtiquiben chi man yeva' ta, richin niquiben orar. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Y man jun chuka' vinek nibanon chi nrelesaj ta jun c'ojobel chire jun tziek c'ac'a', y c'ari' nucusaj ta richin nuc'ojoj jun tziek ri xa ri'j chic. Roma jun c'ojobel c'ac'a' nuc'ol-ri' y nujic' ri tziek ri xa ri'j chic; y ri tziek ri' más niretzetej. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Y que chuka' ri' man jun niyo'on c'ac'a' vino chupan jun tz'un c'ojlibel ri xa ucusan chic. Roma vi queri' niban, y ri tz'un xa man niyukuk ta chic, ri tz'un nibojbo' y niq'uis-el ri vino chupan. Y chuka' ri tz'un man jun chic nic'atzin-vi. Pero chupan jun c'ac'a' c'ojlibel, utz niyaque' c'ac'a' vino. Queri' xubij ri Jesús chirij ri rutijonic. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa jun uxlanibel-k'ij, ri Jesús y ri rutijoxela' yek'ax c'a pa jun ulef ri ticon ruvech riq'uin trigo. Y ri tijoxela' c'o c'a ruvi-trigo ri yequich'up-el. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pero ri achi'a' fariseos xquibij chire ri Jesús: Que'atzu' la atijoxela', roma man ja ta ye'ajin chubanic. ¿Achique roma yequich'up trigo re k'ij re'? Re k'ij re', k'ij richin uxlanen y man ruc'amon ta chi yesamej, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero ri Jesús xubij chique: ¿Man itz'eton ta c'a rix ri tz'ibatel can chirij ri xquiben ri David y ri e rachibil, chupan ri ojer can tiempo, tok janíla xenum? ");
INSERT INTO cakCNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ri David xbe c'a chucanoxic vey chiri' pa rachoch ri Dios. Y ri nimalej sacerdote chupan ri tiempo ri' jac'a ri Abiatar. Y can ja ri lok'olej tak caxlan-vey ri xbejach-pe chire. Y ri caxlan-vey ri' man xe ta c'a ri David ri xtijon, man que ta ri', xa can xuya' chuka' chique ri rachibil. Y man riq'uin ri', man mac ta ri xquiben. Y ri' xaxe ri sacerdotes c'o quik'a' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Y ri Jesús can xubij chuka' chique: Ri uxlanibel-k'ij xban richin jun utzil chire ri vinek, y man ja ta ri vinek ri xban richin ta jun utzil chire ri uxlanibel-k'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Rix can ruc'amon c'a chi nivetamaj chi ja yin ri xinalex ri chi'icojol, ri Rajaf ri uxlanibel-k'ij. Pa nuk'a' yin c'o-vi richin ninbij achique utz niban chupan ri k'ij ri', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Y ri Jesús y ri rutijoxela' xe'apon chic c'a ri pa nima'jay ri can nitzijox-vi ri ruch'abel ri Dios. Y chiquicojol ri vinek ri quimolon-qui' chiri', c'o c'a jun achin chaki'j jun ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pero ec'o c'a ri e tzulibeyon-apo richin ri Jesús, k'alaj ri' vi nuc'achojirisaj ri achin, richin queri' niquisujuj chi ri Jesús xsamej chupan ri jun uxlanibel-k'ij ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Man riq'uin ri' ri Jesús xubij chire ri achin chaki'j ri ruk'a': Cak'ax pa nic'aj, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Xpe c'a ri Jesús xubij chique ri vinek ri ec'o chiri': Yin ninvajo' c'a ninc'utuj chive: ¿Más cami ruc'amon chi niban ri utz pa jun uxlanibel-k'ij o ri itzel? ¿Ri nicol jun vinek chuvech ri camic o ri nicamisex? ¿Achique nich'ob rix? xcha' chique. Pero conojel man jun ch'abel ri xquibij. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","C'ari' ri Jesús xerutzu' c'a conojel ri quimolon-qui' chiri', y xerutz'et chi xa covirinek ri cánima y man nicajo' ta niquinimaj. Romari' rija' janíla xbison, y itzel chuka' xuna'. C'ari' rija' xubij c'a chire ri achin chaki'j ri ruk'a': Tayuku' la ak'a'. Y ri achin can xe xuyuk ri ruk'a', can jari' xchojmir. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Y ri achi'a' fariseos can xe xquitz'et can ri', can jari' xbequimolo-qui' quiq'uin ri e ruvinak ri rey Herodes, richin niquich'ob achique niquiben, roma nicajo' niquicamisaj ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Y ri Jesús xbe c'a chuchi' ri nima-ya', e rachibilan-el ri rutijoxela'. Ri Jesús can xtzekelbex c'a coma janíla vinek ri aj chiri' pa Galilea, y coma ri vinek ri xepe pa Judea. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Rija' can xtzekelbex c'a coma ri vinek ri xepe pa Jerusalem, ri jun tinamit ri c'o chuka' quela' pa Judea. Ri vinek ri xetzekelben richin rija' ec'o c'a ri xepe pan Idumea, ec'o chuka' xepe c'a juc'an chic ruchi' ri raken-ya' Jordán. Xtzekelbex chuka' coma ri vinek ri xepe pa Tiro y Sidón y ri xepe chuka' chiquinakaj ri ca'i' tinamit ri'. Can conojel c'a ri vinek ri xe'oka' riq'uin ri Jesús, xepe roma cac'axan c'a pe ri milagros yerubanala' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Y roma c'a can e janíla ri vinek ye'oka' riq'uin, ri Jesús xubij chique ri rutijoxela' chi tiquiya-pe jun canoa queri' nakaj, richin chi vi ri vinek janíla niquipitz', rija' noc c'a chupan ri canoa ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ri Jesús can e q'uiy vi c'a ri e ruc'achojirisan chic. Pero roma can conojel c'a ri e yava'i' nicajo' chuka' chi yec'achojirisex roma ri Jesús, romari' niquimajla' c'a qui' chirij, richin niquichop-apo ri rutziak y yec'achoj ta chire ri quiyabil. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Y ri itzel tak espíritu tok niquitz'et c'a ri Jesús, niquixucubala' c'a qui' chuvech y can riq'uin c'a uchuk'a' yech'on y niquibij: Ja rat ri Ruc'ajol ri Dios, yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero ri Jesús nubila' c'a chique chi man tiquik'alajirisaj chi ja rija' ri Ruc'ajol ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ri Jesús xjote' c'a el pa ruvi' ri juyu' y xeroyoj-el e q'uiy achi'a'. Can jac'a rija' mismo xe'oyon-apo chiquijujunal ri achi'a' ri' y ri achi'a' ri' can xebe c'a riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","E cablajuj c'a ri xerucha' richin yerachibilaj y richin chuka' yerutek-el chutzijoxic ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Y que chuka' ri' can xtuya' uchuk'a' chique richin yequic'achojirisala' yava'i', y richin yequelesala' itzel tak espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ri e cablajuj ri xerucha' ri Jesús, ja ri Simón ri xubij chuka' Pedro chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ri Jacobo y ri Juan, ri e ruc'ajol ri Zebedeo, ri xubij chuka' Boanerges chique; bi'aj ri nic'ulun c'a chi tzij chi e achi'el cokolajay. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ri Andrés, ri Felipe, ri Bartolomé, ri Mateo, ri Tomás, ri Jacobo ri ruc'ajol ri Alfeo, ri Tadeo, ri Simón ri c'o quiq'uin ri achi'a' ri nibix cananista chique, ");
INSERT INTO cakCNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y ri Judas Iscariote ri xc'ayin richin ri Jesús. Ri Jesús y ri rutijoxela' xebe pa jun jay. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pero roma c'a janíla e q'uiy vinek ri xquimol chic apo qui' jun bey, rije' man xetiquir ta c'a xquitej quivay. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Y ri e rach'alal ri Jesús xquinabej-pe. Y xe'apon richin nequic'ama-pe, roma rije' xquich'ob chi ri Jesús xch'ujer. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Y ri etamanela' chirij ri ley ri e petenek pa tinamit Jerusalem, ec'o-apo ri acuchi c'o-vi ri Jesús. Y niquitzijola' chiquivech chi ri Jesús c'o ri Beelzebú riq'uin; ri cajaf ri itzel tak espíritu. Y ja ri Beelzebú ri niyo'on uchuk'a' chire richin queri' nitiquir yerelesaj ri itzel tak espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Y romari' ri Jesús xeroyoj c'a, y richin xtzijon quiq'uin, xerucusaj c'ambel tak tzij. Rija' xubij c'a chique: ¿Achique modo chi ri Satanás can ja rija' ye'elesan-el ri rusamajela'? ");
INSERT INTO cakCNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Roma vi ri vinek richin jun ruvach'ulef man yenojin ta y ca'i' quivech niquiben, nipe oyoval chiquicojol. Y re' man utz ta, roma ri quiruvach'ulef can man xtipa'e' ta can. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Y que chuka' ri' pa jun jay, vi xa yejalajo' chiquivech y yech'aratej, can man jun c'a ri xtipa'e' ta can. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Y romari' ri Satanás, man utz ta chi nuben-ka oyoval quiq'uin ri rusamajela'. Man utz ta chi chirij rija' mismo niyacatej-vi. Roma vi queri' nuben, ruyon nic'oje' can y chanin nitzak. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Que chuka' ri' ri nrajo' nelek'-el pa rachoch jun achin ri can janíla ruchuk'a', ri nabey c'o chi nuben riq'uin ri achin ri', ja ri tuxima' y c'ari' c'a tucanoj-el ronojel ri nrajo' yeruc'uaj. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","Y tivac'axaj c'a jebel re ch'abel re xtinbij chive vacami. Ri niyok'on richin ri Lok'olej Espíritu, can man xticuyutej ta rumac, xa can xtrejkalej rumac richin jantape'. Y ri ch'aka' chic mac ri yequibanala' ri vinek ri e alaxinek chuvech re ruvach'ulef can c'a yecuyutej-vi. Y que chuka' ri' ronojel ri itzel tak ch'abel ri yequibila' richin niquiyok'bej rubi' ri Dios, can c'a yecuyutej-vi chuka'. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ri Jesús xubij c'a queri' chique ri etamanela' chirij ri ley, roma rije' xa niquibij c'a chirij rija' chi c'o itzel espíritu riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Y ri rute' y ri e rach'alal ri Jesús xepe c'a acuchi c'o-vi rija'. Pero man xe'oc ta apo riq'uin. Xaxe xquitek rubixic chire chi nicajo' yech'on riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Y ri vinek ri e tz'uyul-apo riq'uin ri Jesús xquibij c'a chire: Ri ate' y ri e avach'alal at coyoben chuva-jay, y nicajo' yech'on aviq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero ri Jesús xubij c'a chique ri vinek quimolon-qui' riq'uin: Ri achi'el yixch'obon rix, ¿achique c'a ri nte' y ri e vach'alal? ");
INSERT INTO cakCNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Y ri Jesús xerutzu' c'a conojel ri e tz'uyul-apo riq'uin y xubij chique: Ja rije' ri e oquinek nte' y e oquinek vach'alal. ");
INSERT INTO cakCNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Roma can conojel c'a ri yebanon ri rurayibel ri Dios, jari' ri ye'oc nte', vana' y nchak', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Y ri Jesús e rachibilan ri rutijoxela' xbe chic c'a chuchi' ri nima-ya' y rija' yerutijoj c'a ri vinek riq'uin ri ruch'abel ri Dios. Y can e janíla c'a e q'uiy vinek ri xquimol-apo-qui' richin nicac'axaj. Romari' ri Jesús xoc-apo pa jun canoa ri chiri' pa ruvi-ya', y xtz'uye' c'a chupan. Y ri chiri' pan ulef chuchi' apo ri ya', ec'o c'a ri vinek nicac'axaj-apo ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ri Jesús q'uiy c'a tijonic ri xuya' chique riq'uin c'ambel tak tzij. Rija' xubij c'a chique: ");
INSERT INTO cakCNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Tivac'axaj c'a jebel re xtinbij chive: C'o c'a jun achin ri xbe pa jopin ija'tz. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Y tok ri achin c'o chic pa samaj, nijopin ija'tz, juba' c'a chire ri ija'tz pa bey xka-vi. Y xepe c'a ri aj-xic' tak chicop xquitej-el ri ija'tz ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Juba' chic c'a chire ri ija'tz cojol abej xka-vi y chiri' xa man q'uiy ta ri ulef c'o. Y chanin c'a xe'el-pe roma xa man pin ta ri ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Xa jac'a tok xpe ruvech ri k'ij, xemayamo' y xechaki'j-ka. Roma c'a ri xa man nej ta benek-ka ri quixe', romari' xechaki'j-ka chanin. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Y juba' chic ija'tz xka' cojol k'ayis c'o quiq'uixal. Y tok xe'el-pe, junan xeq'uiy quiq'uin ri q'uix. Pero roma ri q'uix janíla xeq'uiy, ri tico'n xejik' pa quik'a' y man c'a xquiya' ta quivech. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Y ri ch'aka' chic c'a ija'tz xka' pa jun utzilej ulef, xe'el-pe y xeq'uiy jebel. Y c'o ija'tz xquiyala' a treinta quivech, c'o xquiyala' a sesenta y c'o ri xquiyala' a cien quivech. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","C'ari' ri Jesús xubij c'a: Ri c'o c'a rac'axabal, can trac'axaj c'a ri xinbij, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Y tok xcanej can ruyon ri Jesús quiq'uin ca'i-oxi' vinek y ri e cablajuj rutijoxela', ri ec'o riq'uin xquic'utuj c'a chire achique c'a ri nrajo' nubij chique riq'uin ri c'ambel-tzij ri xutzijoj chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Y rija' xubij chique: Man jun bey can ta bin can jebel chirij tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios, pero chive rix yo'on c'a k'ij chi nivetamaj. Jac'a chiquivech ri vinek ri man ec'o ta viq'uin, riq'uin c'ambel tak tzij yich'on-vi quiq'uin, ");
INSERT INTO cakCNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","richin queri' choj niquitzu' y man niquitz'et ta jebel ri niquitzu', y richin chi choj nicac'axaj y man nik'ax ta chiquivech ri nicac'axaj, richin queri' man nitzolin ta pe quic'u'x, y man nicuyutej ta chuka' quimac roma ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Y ri Jesús xubij chic c'a jun bey chique ri ca'i-oxi' vinek y ri rutijoxela': ¿Man xk'ax ta cami chivech ri c'ambel-tzij ri c'a juba' tinbij-ka chive? Roma vi xa man xk'ax ta chivech, ¿can xtik'ax cami chivech ri ch'aka' chic c'ambel tak tzij? ");
INSERT INTO cakCNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Riq'uin re jun c'ambel-tzij re' ninc'ut c'a chi ri ticonel ri xbejopin ija'tz, jac'ari' ri samajel ri nitzijon ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ri juba' ija'tz ri xka' pa bey, achi'el ri vinek tok cac'axan chic ri ruch'abel ri Dios, y ri Satanás junanin napon quiq'uin y nrelesaj-el ri ch'abel ri' pa tak cánima. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ri ija'tz ri xka' can cojol tak abej, can nich'on-vi c'a chirij ri ruch'abel ri Dios ri nac'axex coma ri vinek. Ri vinek ri' can janíla c'a yequicot tok niquic'ul ri ruch'abel ri Dios pa tak cánima. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero roma c'a ri can man nuq'uen ta ka ruxe' jebel ri ruch'abel ri Dios pa tak cánima, can man niyaloj ta c'a ri quicoten quiq'uin, xa jun ca'i-oxi' oc k'ij ri utz ec'o riq'uin ri Dios. Y tok yepe c'a tijoj-pokonal y ye'etzelex roma quiniman ri ruch'abel ri Dios, yetzak can chanin. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Y ri ija'tz ri xeka' can cojol tak k'ayis ri c'o quiq'uixal can nich'on-vi c'a chirij ri ruch'abel ri Dios ri nac'axex coma ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero ri vinek ri' roma xa ja ri nrajo' re tiempo ri nicajo' niquiben, nijik' c'a ri ruch'abel ri Dios ri c'o quiq'uin. Nijik' pa ruk'a' ri beyomel ri achi'el xa c'o utz nuq'uen-pe nik'alajin y xa man que ta ri'. Y q'uiy chuka' ruvech rayinic yepe quiq'uin, romari' ri vinek ri' can man jun bey c'a xtivachin jebel ri ruch'abel ri Dios pa tak quic'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jac'a ri ija'tz ri xeka' pa jun utzilej ulef, can nich'on-vi c'a chirij ri ruch'abel ri Dios ri nac'axex coma ri vinek, y ri vinek ri' can niquiq'uen-vi-ka ri ruch'abel ri Dios y ri quic'aslen nivachin jebel. Can yevachin c'a achi'el niquiben ri ija'tz. Roma ec'o ija'tz niquiya' c'a treinta quivech, ec'o niquiya' a sesenta quivech y ec'o can a cien c'a quivech niquiya'. Can que c'a ri' nuben quic'aslen ri vinek ri niquiq'uen-ka ri ruch'abel ri Dios pa tak cánima. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Y ri Jesús xubij c'a chuka' chique: Tok nic'an-pe jun k'ak' richin nisakirisan pa jay, ¿chuxe' cami cajón o chuxe' cami ch'at nic'oje-vi? Man que ta ri'. Ri k'ak' can c'o c'ojlibel ri nitz'uyubex-vi, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Que chuka' ri' man jun ri evan can, ri man ta xtek'alajin-pe. Y chuka' can man jun ri tz'apen can rij, ri xa man ta richin chi nek'alajirisex-pe y nelesex-pe chuva-sakil. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ri c'o c'a rac'axabal, can trac'axaj c'a ri xinbij, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Y ri Jesús xubij chuka' chique ri vinek: Tok rix nivac'axaj ri ruch'abel ri Dios, can tivac'axaj c'a jebel ri nubij. Can tika' c'a ka pa tak ivánima, roma xa can achi'el rubanic ri nivac'axaj xa can que chuka' ri' ri etamabel ri niq'uen can y riq'uin juba' chic rutz'akat. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Roma ri can c'o c'a ruyacon pa ránima, can xtuc'ul c'a más. Jac'a ri nac'axan ri ruch'abel ri Dios y xa man nuyec ta ka pa ránima, ri janipe' oc c'o riq'uin pa nabey, hasta ri' nelesex chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Y ri Jesús xubij chuka': Tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios, nibanatej c'a achi'el nibanatej riq'uin jun ija'tz ri netic can roma jun achin ri pan ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Y tok ri ija'tz c'o chic c'a can pan ulef, ri ticonel man jun chic ri nuben. Rija' never c'a tok noc-pe ri ak'a' y niyacatej-el tok niseker-pe ri ruca'n k'ij. Y tok napon ri k'ij, ri ija'tz nebos-pe y niq'uiy-el, pero ri xticon-ka richin ri ija'tz man retaman ta, y chuka' man nitiquir ta nubij achique rubanic tok ri ija'tz nebos-pe y achique rubanic tok niq'uiy. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ri ticonel can man jun c'a nuben richin chi ri tico'n niq'uiy-pe; roma ri tico'n xa ruyon niq'uiy-pe. Y ri ulef q'uiy c'a ri nuya-pe. Pero nabey ja ri ti ral ri trigo neq'uiy-pe. Y tok nim chic, nec'ulun-pe ri ruvi'. Y pa ruq'uisibel ninoj c'a pe ri ruvi' riq'uin ri rupan. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Y tok k'en chic, ri rajaf can jac'ari' yerutek ri rusamajela' chupan, richin niquik'et, roma ja tiempo ri' ri richin ri k'atoj. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Y ri Jesús xubij c'a chuka': ¿Achique nikabij chirij ri rubanic tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios? ¿Achok iq'uin junan vi? ¿Y achique ta cami c'ambel-tzij ri nik'alajirisan richin? ");
INSERT INTO cakCNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Xa can junan c'a riq'uin ri nibanatej riq'uin ri ija'tz richin mostaza ri nitic-ka pan ulef. Y xa jac'ari' ri ija'tz ri más tak cocoj ri c'o chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero jari' ri más nim nel chiquivech xabachique ichaj, y yec'oje' ruk'a' e nima'k. Romari' ri aj-xic' tak chicop ri yebe pa cak'ik' niquibanala' quisoc pa tak ruk'a', roma chiri' jebel yemujan. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ri Jesús tok xutzijoj ri ruch'abel ri Dios chique ri vinek, xerucusaj c'ambel tak tzij roma retaman chi riq'uin ri' c'o xtiquetamaj. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Rija' xaxe c'a riq'uin c'ambel tak tzij xch'on chiquivech ri vinek. Pero tok niquiyonij can, rija' can nubij c'a chique ri rutijoxela' achique yec'ulun-vi chi tzij. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Y tok xoc c'a pe ri ak'a' chupan ri k'ij ri', ri Jesús xubij chique ri rutijoxela': Jo' juc'an ruchi-ya', xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Rija' xerutakala' c'a can ri vinek. Pero roma rija' can tz'uyul chiri' chupan ri canoa, can jac'ari' xquichop-el bey pa ruvi-ya'. Y ec'o chuka' ch'aka' chic canoas ri junan xe'el-el quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Y tok quichapon c'a bey, xpe jun cak'ik' ri janíla nim ri chiri' pa ruvi' ri ya'. Y roma c'a ri' ri canoa ri e benek-vi xuchop ninoj-pe chi ya'. Y riq'uin ri' riq'uin juba' yebe chuxe' ya'. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero ri Jesús niver c'a chupan ri canoa tok najin ri cak'ik' pa ruvi' ri ya'. Rija' chirij can ri canoa rucanon-ka jun ruch'acat-ruvi', y chiri' niver benek. Y xepe c'a ri tijoxela' xquic'asoj y xquibij c'a chire: ¡Ajaf! ¡Ajaf! Roj yojquen yan (yojcom yan) y rat xa yaver, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Y ri Jesús xyacatej c'a pe, y xubij: Tiq'uis-el ri cak'ik' y titane-ka ri nibolko't ri ya'. Y queri' xbanatej. Ri cak'ik' xq'uis-el, y chuka' ri nibolko't ri ya' xtane-ka. ");
INSERT INTO cakCNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","C'ari' ri Jesús xubij chique: ¿Achique roma tok xixibij-ivi'? ¿Can man icukuban ta ic'u'x viq'uin yin? ");
INSERT INTO cakCNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero ri tijoxela' janíla quixibin-qui' y xquic'utula' c'a chiquivech, chirij ri Jesús: ¿Achique c'a chi achin re'? Roma ri cak'ik' y ri ya' can niquinimaj chuka' rutzij. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Y ri Jesús y ri rutijoxela' xe'apon c'a ri juc'an ruchi-ya', ri chiri' pa jun lugar rubini'an Gadara. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Y tok ri Jesús xka' can chupan ri canoa, can jac'ari' tok xapon jun achin riq'uin. Jun achin ri pa camposanto elenek-vi-pe, roma ri achin ri' xa c'o c'a itzel espíritu riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ri achin ri' can jac'a ri camposanto ri oquinek rachoch, y rija' hasta riq'uin cadena man e tiquirinek ta quichapon-ka, roma can janíla c'a ri ruchuk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Can q'uiy c'a bey ri e quiximilon ri ruk'a-raken pa ch'ich' y riq'uin chuka' cadena, pero xa e ruk'ajlon y e rurak'ach'ilon can. Can man jun c'a ri tiquirinek ta chirij. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rija' can jantape' c'a nibiyaj ri pa tak juyu' y ri chiquicojol ri acuchi e mukun-vi caminaki', nurek ruchi' (nisiq'uin) y nusocola-ri' riq'uin abej. Can chi pak'ij chi chak'a' c'a ri nubanala' queri' ri achin ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Y tok rija' xutz'et c'a pe ri Jesús, c'anej c'a c'o-vi, pero junanin xpe y xoxuque' chuvech. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Y can riq'uin c'a ruchuk'a' xch'on chire ri Jesús y xubij c'a: Rat Jesús ri Ruc'ajol ri nimalej Dios, ¿achique roma tok yinanek? Pa rubi' ri Dios ninc'utuj chave, chi man quinach'ujirisaj, xcha' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ri achin xubij quere' roma ri Jesús rubin chic c'a chire ri itzel espíritu ri c'o riq'uin ri achin ri' chi tel-el. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Y xpe ri Jesús xuc'utuj c'a chire: ¿Achique abi'? Y rija' xubij-pe: Oj janíla ri nubi', roma man nuyon ta yin, xa can e janíla chuka' ri vachibil ec'o. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Y can janíla c'a xuc'utuj chire ri Jesús chi tubana' utzil man querelesaj-el chupan ri ruvach'ulef ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Y chunakaj apo ri lugar ri', pa ruvi' jun juyu', janíla c'a e q'uiy ak yeva'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Y xepe c'a conojel ri itzel tak espíritu ri ec'o riq'uin ri achin, xquic'utuj utzil chire ri Jesús. Y xquibij c'a chire: Taya' k'ij chike richin yojoc quiq'uin la ak ec'o chila'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ri Jesús can jac'ari' xubij chique chi utz. Y ri itzel tak espíritu jari' xe'el-el y xebe'oc quiq'uin ri ak. Ri ak ri' can janíla c'a e q'uiy. Ec'o la'ek jun ca'i' mil. Y conojel ri ak ri' xquichop anin (anen) pa xulan, chuvech jun juyu' pa'el-pa'el, y choj xebeka' pa ya'. Can conojel c'a ri ak ri' xejik' chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jac'a ri yeyuk'un quichin ri ak ri', xe c'a xquitz'et can ri xbanatej, xe'anmej; y xbequiyala' can rutzijol ri pa tinamit y ri pa tak juyu' chuka'. Y ri vinek can xepe c'a richin noquitz'eta' ri xbebix can chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Y tok ri vinek ri' xe'oka' riq'uin ri Jesús, xquitz'et c'a chi ri achin ri xec'oje' itzel tak espíritu riq'uin, tz'uyul, rucusan rutziak y man nuben ta chic c'a ri achi'el ri rubanon-pe. Pero ri vinek ri' xa xquixibij c'a qui' tok xquitz'et ri achin ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ri vinek c'a ri xetz'eton ri xbanatej riq'uin ri achin ri xelesex itzel tak espíritu riq'uin y ri xc'ulvachitej quiq'uin ri ak, xquitzijola' c'a chique ri vinek ri e petenek chutz'etic ri xc'ulvachitej chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Roma c'a ri' ri vinek xquic'utuj utzil chire ri Jesús chi tel-el chupan ri lugar ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Y jac'a tok noc-el ri Jesús pa canoa, ri achin ri xec'oje' itzel tak espíritu riq'uin, xuc'utuj c'a utzil chire ri Jesús chi tuya' k'ij chire richin nibe riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero ri Jesús man xrajo' ta. Xa xubij c'a chire: Catzolin chi'avachoch, y tatzijoj chique ri e avach'alal chi xe'elesex ri itzel tak espíritu aviq'uin, roma xjoyovex avech roma ri Ajaf. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Y ri achin xbe c'a y xuchop rutzijoxic ri xuben ri Jesús riq'uin rija'. Rija' xutzijoj c'a chique ri vinek ri ec'o chupan ri lugar rubini'an Decápolis. Y ri vinek can janíla c'a niquich'ob rij ruc'aslen ri jun achin ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Y ri Jesús y ri rutijoxela', xe'oc chic c'a el pa canoa richin chi xek'ax c'a la juc'an chic ruchi-ya'. Y tok xe'apon yan c'a la juc'an chic ruchi-ya', janíla e q'uiy vinek ri xquimol-apo-qui' riq'uin. Rija' chunakaj c'a ri nima-ya' xc'oje-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Xapon c'a chuka' jun achin rubini'an Jairo. Re achin c'a re' c'o jun rusamaj chupan ri jay ri can nitzijox-vi ri ruch'abel ri Dios. Jac'a rija' ri achi'el tata'aj chiri'. Y tok ri Jairo xutz'et-apo ri Jesús, can jari' xbexuque' chuvech ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Y c'ari' rija' xubij c'a chire ri Jesús: Ri ti numi'al yava', y niquen yan (nicom yan). Tabana' c'a utzil te'aya' ri ak'a' pa ruvi' richin nicolotej chuvech ri camic y nic'ase' can, xcha' ri achin. Y ri achin ri' can janíla c'a xuc'utuj utzil chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Y ri Jesús can xbe c'a. Y e q'uiy chuka' vinek xetzeke-el chiquij. Y roma can janíla e q'uiy vinek, can man utz ta c'a yebiyin. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Y chiquicojol c'a ri vinek ri' benek c'a chuka' jun ixok ri c'o jun ruyabil. Ri ixok ri' c'o yan c'a cablajuj juna' ri nibiyin ruquiq'uel y man tanel ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Rija' rutijon c'a pokon roma benek chic quiq'uin q'uiy ak'omanela' y xuq'uis yan chuka' ronojel ru-mero; y pa ruq'uexel chi utz ta juba', ri ruyabil xa más xuben. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Re ixok re' c'o c'a rac'axan-pe chirij ri Jesús. Rija' benek c'a chuka' chiquicojol ri vinek ri ec'o can chirij ri Jesús, y jac'ari' tok xberuchapa' can juba' ri rutziak ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Roma ri ixok ri' can rubilon c'a pe pa ránima: Xa riq'uin ta ninchop-el juba' rutziak ri Jesús, yic'achoj-el, cha'inek c'a pa ránima ri ixok ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Y can jac'ari' xtane' nibiyin ri ruquiq'uel. Rija' can xuna' c'a chi xc'achoj chire ri ruyabil ri ruc'ulvachin. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ri Jesús can chanin c'a xuna' chi c'o jun xuc'achojirisaj riq'uin ri uchuk'a' ri c'o riq'uin. Romari' xtzu'un chirij, y xubij chique ri vinek: ¿Achique xchapon re nutziak? xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pero ri tijoxela' xquibij c'a chire: Rat navajo' navetamaj achique xchapon ri atziak, pero re vave' c'ayef richin navetamaj. Ye'atz'et chi re vinek yatquipitz', y rat nac'utuj: ¿Achique ri xichapon? yacha', xecha' ri tijoxela' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero ri Jesús yerutzula' c'a ri vinek, nucanoj ri achique xchapon ri rutziak. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Y ri ixok ruxibin-ri' y nibaybot c'a (nibarbot c'a), roma xa ja rija' ri xchapon ri rutziak ri Jesús, y can xc'achoj-vi chire ri ruyabil. C'ari' c'a, rija' xoxuque' chuvech ri Jesús y xubij c'a ronojel ri achique xuben. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Y ri Jesús xubij chire ri ixok: Numi'al, xacolotej, roma xacukuba' ac'u'x viq'uin. Vacami c'a, catzolin; ri avánima xril yan uxlanen. Ri ayabil ri ac'ulvachin-pe man chic xtitzolin ta pe, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Y c'a nich'on na c'a ri Jesús riq'uin ri ixok, tok ec'o ri xe'oka' e petenek chirachoch ri Jairo; ri achin ri achi'el tata'aj ri chiri' pa nima-jay ri can nitzijox-vi ri ruch'abel ri Dios. Ri achi'a' ri xe'oka', xoquibij c'a chire ri Jairo: Ri ti ami'al xa xquen yan (xcom yan). ¿Y can c'a c'o ta cami c'a nic'atzin-vi chi nac'uaj chic ri Tijonel? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jac'a tok ri Jesús xrac'axaj-pe, chanin xubij chire ri achin achi'el tata'aj ri pa nima-jay: Man tuxibij-ri' ri avánima roma ri xobix chave. Tacukuba' c'a ac'u'x viq'uin, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Y ri Jesús xaxe c'a ri Pedro, ri Jacobo y ri Juan ri rach'alal ri Jacobo, ri xeruc'uaj-el. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Y ri Jesús e rachibilan ri e oxi' rutijoxela' xebe c'a ri chirachoch ri achin ri achi'el tata'aj ri chiri' pa nima-jay ri can nitzijox-vi ri ruch'abel ri Dios. Y tok xe'apon c'a, ri Jesús xerutz'et chi ri vinek yech'ujlan ri pa jay, y xerutz'et chuka' ri nibiyin ruya'al-quivech y riq'uin janíla uchuk'a' ye'ok'. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tok ri Jesús oquinek chic apo, xubij chique ri vinek: ¿Achique roma yixok' y yixch'ujlan? Ri ac'ual xa man caminek ta, rija' xa nuxlan, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero rije' xa xetze'en chirij ri Jesús, roma quetaman chi ri ac'ual xa caminek chic. Pero ri Jesús xuben c'a chique ri vinek chi xe'el-pe. C'ari' rija' xerucusaj-apo ri rute-rutata' ri ti xten y ri e oxi' chic ri e benek chirij, chupan ri jay ri c'o-vi ri ruch'acul ri ti xten. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Rija' xuchop c'a ruk'a' ri ti caminek y xch'on pa jun chic ch'abel, y xubij: Talita, cumi, xcha'. Re tzij re' nubij c'a: Ti xten, chave rat ninbij-vi chi cayacatej. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Can xe xubij quere' ri Jesús, can jari' xyacatej y xbiyaj-el ri ti xten, roma xa can cablajuj chic c'a rujuna'. Y ri ec'o riq'uin, xsach quic'u'x tok xquitz'et chi xtzolin chic pe. ");
INSERT INTO cakCNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero ri Jesús janíla xuchilabej chique chi man tiquelesaj rutzijol, y chuka' xubij chi tisuj ruvay ri ti xten. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Y ri Jesús e rachibilan ri rutijoxela' xe'el-el ri chiri' y xebe pa Nazaret ri tinamit ri xq'uiy-vi rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Y tok xapon c'a ri uxlanibel-k'ij, rija' xuc'ut ri ruch'abel ri Dios ri pa nima-jay ri can nitzijox-vi ri ruch'abel ri Dios. Y roma c'a ri ch'abel ri yerubij chique, ri vinek ri quimolon-qui' chiri', can achique la c'a xcac'axaj, y xquibila' c'a: ¿Achique c'a roma re achin re' janíla etamabel c'o riq'uin y nitiquir yeruben milagros? ¿Achi'el c'a tok nitiquir nuben ronojel re'? ");
INSERT INTO cakCNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Roma re achin re', xa jare' ri samajiy-che' (ajanel), ral ri María, cach'alal ri Jacobo, ri José, ri Judas y ri Simón. Y ri rana' xa chikacojol roj ec'o-vi, xecha'. Romari' ri vinek can man juba' xquinimaj ta ri Jesús, roma rija' aj chiri' pa quitinamit. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Y ri Jesús xubij c'a chique ri vinek ri': Conojel c'a ri yek'alajirisan ri ch'abel ri bin chique roma ri Dios, man jun quik'ij; pero ri' xaxe chiquivech ri vinek aj pa rutinamit, chiquivech ri rach'alal y chiquivech chuka' ri aj pa rachoch, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Y chupan ri rutinamit, ri Jesús man q'uiy ta c'a milagros xtiquir xuben. Xaxe oc ca'i-oxi' yava'i' ri xuya' ruk'a' pa quivi' richin xeruc'achojirisaj. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Y rija' can achique la c'a xuna' roma xerutz'et chi ri vinek ri aj chiri' pa rutinamit, chi xa can man xquicukuba' ta quic'u'x riq'uin. Rija' xbe c'a ri pa tak cocoj tinamit ri ec'o-pe chunakaj ri rutinamit. Rija' can xuc'ut c'a ri ruch'abel ri Dios chiquivech ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","C'ari' ri Jesús xeroyoj c'a ri cablajuj rutijoxela'. Y chi caca' xuchop-el quitakic chubanic ri samaj, y xuya-el uchuk'a' chique richin chi yetiquir yequelesaj ri itzel tak espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Y rija' xubij c'a chuka' el chique chi xaxe ri quich'ame'y tiquic'uaj-el y man jun chic ri tiquic'uaj. Man tiquic'uaj pekes (morral), man tiquic'uaj vey y chuka' can man tiquic'uaj-el mero ri pa tak ruximbal-quipan; xa can man jun mero ri tiquic'uaj-el. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Man tiquicusaj-el ca'i' quitziak. Pero utz chi niquicusaj-el quixajab. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ri Jesús xubij c'a chuka' chique ri rutijoxela': Xabachique tinamit yixapon-vi; tok yixoc pa jun jay, chiri' quixc'oje-vi-ka. Xa can c'a ja tok yixel na pe chiri', utz niya' can ri jay ri xixc'oje-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Y vi ta ri yixapon-vi, ri vinek man yixquic'ul ta jebel, y man nicajo' ta chuka' nicac'axaj ri ruch'abel ri Dios ri nitzijoj rix chique, can quixel c'a pe ri chiri'. Y titotala' c'a can (tiquirala' c'a can) ri pokolaj ri c'o pa tak ivaken chiquivech ri vinek ri', richin tiquinabej chi man utz ta ri xquiben. Roma can ninbij-vi c'a chive, chi chupan ri k'ij tok xtibanatej ri k'atoj-tzij, ri ruc'ayeval c'a ri xtika' pa quivi' ri vinek ri xec'oje' pa tinamit Sodoma y Gomorra man can ta xtic'o ruvi', que chuvech ri xtika' pa quivi' ri vinek richin ri tinamit ri man xquixquic'ul ta jebel, xcha-el chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Y ri tijoxela' xebe c'a. Rije' xquibij c'a chique ri vinek chi titzolej-pe quic'u'x riq'uin ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Y ri tijoxela' q'uiy c'a itzel tak espíritu ri xequelesala'. Y chuka' xquiyala' aceite olivo pa quivi' e q'uiy yava'i' y xequic'achojirisala' can. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Y ri rey Herodes can xrac'axaj c'a chi ri Jesús janíla rutzijol chiquicojol ri vinek. Pero ri Herodes xubij-ka pa ránima chi ri Jesús xa ja ri Juan ri Bautista ri xc'astej-pe chiquicojol ri caminaki', y romari' tok c'o uchuk'a' pa ruk'a' richin q'uiy ri nitiquir yerubanala', xcha-ka rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero ec'o c'a chique ri vinek ri xquibij chi ri Jesús xa ja ri Elías. Y ec'o ch'aka' chic xquibij chi rija' jun achin ri nik'alajirisan ri nibix chire roma ri Dios y chuka' xquibij chi rija' jun chique ri achi'a' ri xek'alajirisan ri ruch'abel ri Dios chupan ri ojer can tiempo. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero tok ri rey Herodes xrac'axaj c'a ri', xubij: Re Jesús xa ja ri Juan ri Bautista ri xintek rutzaq'uixic rukul, y vacami c'astajinek chic pe chiquicojol ri caminaki', nicha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Roma xa can jac'a ri rey Herodes ri xbin chi techap-pe ri Juan. Y c'ari' xuya' pa cárcel y xxime' pa cadena. Ri Herodes queri' xuben roma ri ixok ri c'o riq'uin; ri ixok rubini'an Herodías, xa rixjayil c'a ri Felipe ri rach'alal ri Herodes. Y ri Herodes can ruc'amon c'a ka ri ixok ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ri Juan xchap c'a roma jari' ri rubin chire ri Herodes. Rija' rubin c'a chire: Man utz ta abanon chi ac'amon-ka ri Herodías ri rixjayil ri avach'alal Felipe. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ri Herodías can rajovan-vi c'a rucamisan ri Juan roma itzel nuna' chire, pero man pa ruk'a' ta c'a rija' c'o-vi, romari' man tiquirinek ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ri rey Herodes can retaman-vi c'a chi ri Juan jun chojmilej y lok'olej achin richin ri Dios; y nuxibij c'a ri' chuvech. Can man ruyo'on ta c'a k'ij richin c'o ta ruc'ulvachin. Rija' can jebel c'a nrac'axaj tok ri Juan nubij ri ruch'abel ri Dios chire. Pero rija' man nich'obotej ta c'a chuvech ri achique ruc'amon chi nuben. Man riq'uin ri', rija' can jebel vi c'a nrac'axaj ri nibix chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Y ri k'ij c'a ri oyoben roma ri Herodías richin nika' ri Juan pa ruk'a', xapon c'a. Chupan ri k'ij tok ri rey Herodes xtz'aket chic jun rujuna', xuya' jun va'in y xeroyoj c'a ri k'atoy tak tzij ri ec'o pa ruk'a', xeroyoj ri e uc'uey quichin ri achi'a' banoy tak oyoval y xeroyoj chuka' ri achi'a' ri c'o janíla quik'ij chiquicojol ri aj-Galilea. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Y ri acuchi c'a quimolon-vi-qui' rije', xoc-apo jun xten ral ri Herodías; y rija' xxajo' chiquivech. Y ri xajoj ri xuben ri xten janíla xka' chuvech ri rey Herodes y chiquivech conojel ri yeva' riq'uin. Y ri rey Herodes xubij c'a chire ri xten: Tac'utuj c'a ri achique navajo' y xtinya' chave. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Can ninben c'a jurar chavech, chi xabachique c'a ri xtac'utuj chuve, xtinya' chave, stape' can nic'aj chire re ruvach'ulef c'o pa nuk'a', xcha' ri rey Herodes chire ri ral ri Herodías. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pero ri xten, xe xrac'axaj ri xubij ri rey Herodes, xel-el y xberubij c'a chire ri rute': ¿Achique ta ninc'utuj chire ri rey Herodes? Roma rija' xubij chuve chi achique ri ninvajo' xtuya' chuve, xcha' ri xten chire ri rute'. Xpe ri te'ej xubij c'a chire ri ral: Tac'utuj chi ticamisex ri Juan ri Bautista y ri rujolon (ruvi') tuc'uex-apo chave. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Y ri xten can jac'ari' xtzolin-apo riq'uin ri rey Herodes y xberubij c'a chire: Yin ninvajo' chi ja re vacami yan naya-pe chuve pa jun lek, ri rujolon (ruvi') ri Juan ri Bautista, xcha' chire ri rey Herodes. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Y ri rey Herodes xpe janíla bis pa ránima romari', pero roma c'a can rubanon chic jurar chire chi can xtuya-vi ri nrajo' y roma chuka' can chiquivech ri e rachibilan pa mesa xubij-vi, can c'o c'a chi nuben ri nic'utux chire, richin man nuya' ruq'uix. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Y ri rey jari' c'a xutek-el jun soldado richin tic'an-pe ri rujolon (ruvi') ri Juan ri Bautista. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Y ri soldado xbe c'a. Rija' xberutzaq'uij c'a pe rujolon (ruvi') ri Juan ri Bautista, ri chiri' pa cárcel. Y c'ari' ri rujolon (ruvi') ri Juan xuq'uen c'a pe chire ri xten pa jun lek y ri xten xberuya' chire ri rute'. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tok ri rutijoxela' ri Juan xcac'axaj chi xcamisex, xebe c'a chuc'amic ri ruch'acul, y xbequimuku' can. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ri e ru-apóstoles ri Jesús jari' c'a xetzolin-pe banoy rusamaj ri Dios y niquimol chic apo qui' riq'uin ri Jesús. Rije' niquitzijola' c'a chire ronojel ri xquibanala' y ri tijonic ri xquiyala'. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Y ri Jesús xubij c'a chique: Jo' pa jun lugar e manek vinek richin chi yixuxlan juba'. Y queri' xubij chique roma can e janíla c'a vinek ri ye'el-ye'oc quiq'uin y romari' hasta man yetiquir ta chic yeva'. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Y ri Jesús y ri rutijoxela' xe'oc c'a el pa jun canoa richin chi yek'ax c'a juc'an ruchi-ya', pa jun lugar e manek vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero tok rije' xe'el-el, e q'uiy c'a vinek ri xetz'eton-el y xquetamaj-el quivech. Romari' ri vinek junanin xebe chicaken, xquimolola-el-qui' ri pa bey; ri pa tak tinamit ri xek'ax-vi-el. Y xa ja yan chic rije' ri xe'apon nabey. Y tok ri Jesús y ri rutijoxela' xe'apon, ri vinek xquimol c'a apo qui' chiquij. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Y tok ri Jesús xka' c'a can chupan ri canoa, xutz'et c'a chi janíla e q'uiy ri vinek ri e oyobeyon richin ri chiri'. Rija' xujoyovaj c'a quivech, roma ri quibanon, achi'el xa ja ri carne'l tok man jun niyuk'un quichin. C'ari' xuc'ut c'a chiquivech, q'uiy ri nic'atzin chi niquetamaj chirij ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pero tok xa can janíla xxule' yan c'a ri k'ij, ri rutijoxela' ri Jesús xejel-apo riq'uin y xquibij c'a chire: Re vave' xa e manek vinek y janíla xkak'ij yan. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Que'ataka' c'a el richin chi yebe ri pa tak cocoj tinamit y pa ch'aka' chic lugar ri ec'o-pe nakaj, richin chi tequilok'o' quivay, roma xa man jun quivay richin niquitej, xecha' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jac'a ri Jesús xubij chique ri rutijoxela': Tiya' quivay rix, xcha' chique. Y rije' xquibij chire: ¿Rat nabij chi yojbe chulok'ic ca'i' ciento quetzales vey richin yeva' rije'? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Y rija' xuc'utuj c'a chique: ¿Janipe' vey c'o iviq'uin? Te'itz'eta' na c'a. Y tok rije' quitz'eton chic can, xquibij: C'o vo'o' vey y ca'i' quer, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","C'ari' rija' xubij chique ri rutijoxela' chi tiquibij chique ri vinek chi quetz'uye' conojel pa ruvi' ri sabana rex-rex rubanon, y pa tak tzobaj (grupos) quetz'uye'. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Y ri vinek ri' can xetz'uye' c'a pa ruvi' ri sabana, y xquic'uala' c'a qui' pa tak ciento y nic'aj tak ciento. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Y ri Jesús xeruli'ej c'a pa ruk'a' ri vo'o' vey y ri ca'i' quer, xtzu'un chicaj y xumatioxij chire ri Dios. Rija' xeruper c'a el (xerupir c'a el) ri vey, y xuya-el chique ri rutijoxela' richin chi niquiya' chique ri vinek. Y que chuka' ri' xuben riq'uin ri quer. Xujech c'a chiquivech conojel. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Can conojel c'a jebel xquitej quivay. Can man jun c'a ri man ta jebel xva'. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Y c'a c'o na c'a cablajuj chaquech vey rachibilan quer ri xmolotej can, ri man xq'uis ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Can janíla vi e q'uiy vinek ri xquitej quivay, roma xaxe ri achi'a' e vo'o' mil. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Y ri Jesús can jac'ari' xerucusaj-el ri rutijoxela' chupan ri canoa, richin quenabeyej-el chuvech; chi quebe c'a ri pa Betsaida, ri tinamit ri c'o juc'an ruchi-ya'. Y rija' yerutek na c'a el ri vinek chi tak cachoch. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Y tok ri Jesús e rutakalon chic can ri vinek chi tak cachoch, rija' xbe pa ruvi' jun juyu' chubanic orar. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ri Jesús c'a xc'oje' c'a can pan ulef, pero ri tijoxela' e benek c'a pa canoa y nej yan quebiyin pa ruvi' ri ya'. Pa runic'ajal chic c'a ri ya' ec'o-vi-apo tok xoc-pe ri ak'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Y ri Jesús xerutzu' c'a chi ri rutijoxela' man choj ta nibiyin ri canoa chiquivech, roma ri cak'ik' nupaxij-ri' chuvech ri canoa y nutzolij c'a. Y tok nipe yan c'a rusekeric y jubama nik'ax yan ri ak'a' ri', ri Jesús nibiyin c'a riq'uin ri raken pa ruvi' ri ya' benek-apo, y nrajo' c'a nik'ax-el chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero tok ri tijoxela' xquitz'et chi c'o jun petenek chiraken pa ruvi-ya', xquic'utula' c'a chiquivech riq'uin uchuk'a' chi achique c'a la'. Roma rije' xquibij chi ri petenek pa ruvi-ya' xa jun xibinel. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Y roma can conojel c'a xetz'eton richin, xsach quic'u'x. Y romari' ri Jesús chanin xch'on chique y xubij: Man tixibij-ivi'. Xa ticukuba' ic'u'x. Ja yin ri Jesús, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Y rija' xoc c'a el quiq'uin ri pa canoa. Y can jari' tok xtane-el ri cak'ik'. Y ri tijoxela' xsach c'a quic'u'x janíla. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Y stape' can xquitz'et tok ri Jesús xuq'uiyirisaj ri vey, rije' man xk'ax ta chiquivech chi rija' can nitiquir-vi nuben xabachique, roma can c'o uchuk'a' riq'uin. Rije' covirinek c'a ri cánima. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Y rije' xek'ax c'a pa ruvi' ri nima-ya' ri' y xe'apon ri pa Genesaret. Rije' xe'apon c'a chuchi' ri ya'. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Y xe xe'el can pa canoa, ri vinek ri ec'o chiri' chuchi' ri ya', chanin xquetamaj ruvech chi ja ri Jesús ri xka' can pa canoa. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Romari' xquiya' rutzijol pa ronojel lugar ri ec'o-pe nakaj, chi ri Jesús c'o ri chiri'. Y ri vinek xquichop c'a yequic'amala-pe ri quiyava'i'. Can ronojel vi c'a lugar xec'amalox-pe yava'i'; y chuvech c'a ri quivarabel e c'amalon-vi-pe, y xequic'uaj chire ri Jesús ri achique lugar nicac'axaj chi c'o-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Y xabachique lugar xapon-vi, ri pa tak nima'k tinamit, pa tak cocoj tinamit y ri pa tak juyu' chuka', ri vinek xequiyala' ri yava'i' pa tak bey ri nik'ax-vi rija'. Janíla c'a utzil niquic'utula' chire richin chi tuya' k'ij chique richin niquichop stape' ta xaxe ri ruchi-rutziak. Y conojel c'a ri xechapon ruchi-rutziak ri Jesús, xec'achoj chire ri quiyabil. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Y chirij c'a ri Jesús xquimol c'a apo qui' ri achi'a' fariseos, y chuka' ca'i-oxi' etamanela' chirij ri ley ri e petenek ri pa tinamit Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Y tok ri achi'a' ri' xequitz'et chi ec'o chique ri rutijoxela' ri Jesús ri man niquich'ej ta jebel ri quik'a' tok niquitej quivay, man utz ta xequitz'et. Roma chiquivech rije' can man ch'ajch'oj ta ri quik'a'. Y romari' q'uiy c'a ri xquibij chiquij, roma can man niquiben ta achi'el ri niquiben rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Roma ri achi'a' fariseos y conojel ri ch'aka' chic vinek israelitas, xa ja oc ri e bilon can coma ri kati't-kamama', xa jari' ri yequibanala'. Roma vi xa man niquich'ej ta ri quik'a' q'uiy bey, can man yeva' ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tok yetzolin c'a pe ri pa tak c'ayibel, vi man niquich'ajch'ojirisaj ta qui', can man yeva' ta. Y c'o c'a ch'aka' chic ri yequibanala' chuka', achi'el ri achique quijosk'ixic ri kumbel tak ya', ri xára, ri ch'ich' tak lek y ri achique chuka' rujosk'ixic niquiben chire ri quivarabel. Que c'a ri' ri yequibanala' rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Romari' xepe c'a ri achi'a' fariseos y ri etamanela' chirij ri ley xquic'utuj c'a chire ri Jesús: ¿Achique c'a roma tok la atijoxela' man niquiben ta achi'el ri bin can coma ri kati't-kamama'? Rije' niquitej quivay y man niquich'ej ta quik'a' jebel. Man niquiben ta achi'el nikaben roj, xecha' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pero ri Jesús xubij chique ri achi'a' ri': Rix xa ca'i' ipalej. Xa can jebel c'a rubixic rubanon can ri Isaías chivij. Ri xubij ri Dios chire chi tutz'ibaj can, nubij c'a: Re vinek re' xaxe c'a riq'uin ri quich'abel niquiya' nuk'ij, jac'a ri nrajo' ri cánima xa man ja ta ri'; xa nej c'a chire ri niquiya' ta nuk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xa can man jun c'a nic'atzin-vi ri niquiya' nuk'ij, roma xa e tijonel quichin quetamabal achi'a' y niquibij chi can jari' ri ruc'amon chi niban. Queri' ri rutz'iban can ri Isaías. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Y rix jari' ri yixajin chubanic. Xa iyo'on can ri rubin can ri Dios chi c'o chi niben. Rix can man niben ta c'a ri nrajo' ri Dios, xa ja ri niquibij ri vinek, xa jari' ri ichapon rubanic. Achi'el tok nibij ri achique quijosk'ixic ri xára y ri achique quijosk'ixic ri kumbel tak ya'. Y ec'o chuka' ch'aka' chic e achi'el ri', ri ye'ibanala'. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Y ri Jesús xubij chuka' chique: Rix richin niben ri achique oc e quibilon can ri kati't-kamama', can iyo'on c'a can rubanic ri achique rubin can ri Dios chi c'o chi niben. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Roma ri ch'abel ri e rutz'iban can ri Moisés, nubij: Taya' quik'ij ri ate-atata'. Y ri nibanon c'a itzel chique rute-rutata', can man jun chic c'a ri nrajo', can ja vi c'a ri camic ri tika' pa ruvi'. Que c'a ri' ri tz'ibatel can. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jac'a rix xa man que ta ri' ri niben y nic'ut. Xa man niben ta achi'el ri rubin can ri Dios. Rix xa ye'itijoj ri alc'ualaxela' chi man nic'atzin ta chi yequito' ri quite-quitata'. Xa ye'el chuvech ri' riq'uin niquibij chique ri quite-quitata': Yin man yitiquir ta yixinto' riq'uin ri nic'atzin chive, roma ri nic'atzin ta chive rix xa Corbán. Re ch'abel re' nubij c'a: Nusujun chic chire ri Dios. Y riq'uin niquibij queri', chi quisujun chic chire ri Dios ri nic'atzin ta chique ri quite-quitata', man nic'atzin ta chic richin yequito', yixcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Y riq'uin ri nibij, can nik'alajin-vi chi rix niben chique ri alc'ualaxela' chi man jun chic tiquiya' chique ri quite-quitata'. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Riq'uin ri', rix ibanon chi man jun ruk'ij ri rubin can ri Dios. Y queri' ibanon xaxe richin niben ri achique quibin can ri ivati't-imama'. Y ec'o chuka' ch'aka' chic achi'el re' ri ye'ibanala'. Queri' xubij ri Jesús chique ri achi'a' fariseos y ri achi'a' e etamanela' chirij ri ley. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Y ri Jesús xch'on chic c'a jun bey quiq'uin ri janíla chi vinek ri quimolon-apo-qui' chiri' y xubij c'a chique: Tivac'axaj c'a chi'ivonojel re xtinbij chive y tik'ax-el chivech. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Roma ri nutej-ka ri vinek, man ja ta ri' ri nitz'ilobisan richin, man que ta ri'. Ri nitz'ilobisan richin jun vinek xa ja ri itzel ri nipe pa ránima. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ri c'o c'a rac'axabal, can trac'axaj c'a ri xinbij. Queri' xubij ri Jesús chique ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Y rija' xeruya' c'a can ri vinek, y xbe pa jun jay. Y ri tijoxela' xquic'utuj c'a chire chirij ri nitz'ilobisan richin jun vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Y ri Jesús xubij c'a chique: ¿Can junan ibanon rix quiq'uin ri ch'aka' chic vinek chi man nik'ax ta chivech ri ninbij? ¿Can man nik'ax ta chivech chi ronojel ri nutej-ka ri vinek, xa man ja ta ri' ri nitiquir nitz'ilobisan richin? ");
INSERT INTO cakCNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ronojel ri achique nutej-ka ri vinek, xa man pa ránima ta nibe-vi. Xa pa rupan nibe-vi y c'ari' nel can. Y roma ri queri' xubij ri Jesús, nik'alajin chi ronojel ri ec'o can richin chi yetij, can e utz vi. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Y ri Jesús xubij chuka' chi xa ja ri itzel ri nipe pa ránima ri vinek, xa jari' ri nitz'ilobisan richin. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Roma xa pa ránima c'a ri vinek yepe-vi ri itzel tak ch'obonic. Chiri' nipe-vi ri ch'obonic tok ri vinek ri e c'ulan y ri man e c'ulan ta niquicanola-qui' richin yemacun. Y chiri' chuka' nipe-vi ri ch'obonic tok yecamisan. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Pa tak cánima c'a ri vinek nipe-vi ri jalajoj tak ch'obonic, tok ye'elek', tok niquirayij chi ronojel ta cosa quiq'uin ta rije' c'o-vi, yequibanala' etzelal, yek'olon, ri achi'a' y ri ixoki' niquibanala' mac ri janíla yeq'uixbisan, itzel niquina' chire jun vinek ri utz c'o, yequibila' itzel tak ch'abel chiquij ri ch'aka' chic, niquina chi janíla quik'ij, e nacanek. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ronojel c'a ri etzelal que tak ri', pa ránima c'a ri vinek nipe-vi, y jari' ri nitz'ilobisan richin. Que c'a ri' xubij ri Jesús chique ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Y ri Jesús e rachibilan ri rutijoxela' xel c'a el ri chiri', y xbe c'a pa jun lugar ri nakaj nicanej can chique ri tinamit quibini'an Tiro y Sidón. Y xc'oje' c'a pa jun jay, roma man nrajo' ta c'a chi netamex chi rija' c'o chiri'. Pero man riq'uin ri', chanin xnabex chi c'o chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Can chanin c'a xnabex-pe roma jun ixok ri c'o jun ral-xten, ri c'o jun itzel espíritu riq'uin. Ri ixok ri' can xe c'a xrac'axaj-pe chi ri Jesús c'o chiri', rija' xpe c'a riq'uin. Rija' xoxuque' c'a chuvech. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ri jun ixok ri' man israelita ta c'a. Rija' jun sirofenicia. Pero xoxuque' chuvech ri Jesús richin xoruc'utuj utzil chire chi trelesaj ri itzel espíritu ri c'o riq'uin ri ral. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero ri Jesús xubij chire ri ixok: Ri rutzil ri Dios man utz ta chi chire xabachique ninya-vi. C'o chi ja ri nuvinak israelitas yento' nabey. Roma man ruc'amon ta chi nelesex ri quivay ri alc'ualaxela' richin ja ri tak tz'i' yetijon, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pero ri ixok xubij c'a chire ri Jesús: Ajaf, can kitzij ri nabij. Pero can yojtiquir c'a chuka' nikac'ul-apo juba' chire ri utzil ri'. Achi'el niquiben ri tak tz'i' ri chuxe' mesa, yequimolola' chuka' ri ruc'aj vey ri yequitzakala-ka ri ac'uala'. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Y ri Jesús can jac'ari' xubij chire ri ixok: Ri xabij can queri' vi. Vacami catzolin c'a, roma ri itzel espíritu xel yan el riq'uin ri aval, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Y ri ixok xtzolin c'a chirachoch. Y xberila' ri ral cotz'ol pa ch'at. Y chanin chuka' xutz'et chi ri itzel espíritu man c'o ta chic riq'uin ri ral. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ri Jesús e rachibilan ri rutijoxela' xel c'a pe chupan ri lugar ri nakaj nicanej-vi can chire ri tinamit Tiro y xbek'ax-pe pa Sidón. Y xbek'ax chuka' pe chupan ri lugar rubini'an Decápolis, c'ari' xoka' chuchi' ri nima-ya' rubini'an Galilea. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chiri' c'a c'o-vi tok xc'an-pe jun achin chire ri Jesús, jun achin ri man naq'uex ta y man nitiquir ta nich'on jebel. Y ri e c'amayon-pe richin, xquic'utuj c'a utzil chire ri Jesús chi tuya' ruk'a' pa ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ri Jesús xuc'uaj c'a el ri achin ri'. Xuju' ruvi-ruk'a' pa tak ruxiquin, xchuban, y c'ari' xunek ri rak'. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Y ri Jesús xtzu'un chicaj, xjik'jo'x y xubij: Efata. Re tzij re' nubij c'a: Tijakatej. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Y ri achin can jac'ari' xaq'uex y xch'on chuka' jebel. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Y ri Jesús xuq'uen c'a pe ri achin y xubij chique ri vinek chi man tiquitzijoj ri xbanatej. Pero ri vinek, man riq'uin chi can janíla chilaben-el chique roma ri Jesús chi man tiquitzijoj, xa jari' ri xbequibana-pe nabey. ");
INSERT INTO cakCNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Y ri vinek ri' can xsach-vi c'a quic'u'x tok xquitz'et ri xbanatej, y niquibila' c'a: Jebel ri xuben. Nuben c'a chique ri man ye'aq'uex ta, chi ye'aq'uex; y nuben chuka' chique ri e mema', chi yech'on, yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Je k'ij c'a ri' tok janíla e q'uiy vinek ri xquimol-apo-qui' riq'uin. Pero re vinek re' xq'uis c'a quivay, y romari' ri Jesús xeroyoj c'a ri rutijoxela' y xubij c'a chique: ");
INSERT INTO cakCNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Yin janíla ninjoyovaj quivech re vinek re', roma c'o yan oxi' k'ij ec'o-pe viq'uin y vacami man jun chic quivay richin niquitej. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Y yentek ta c'a el chi tak cachoch choj queri' y man jun niquitej-el, man utz ta. Roma ec'o nej e petenek-vi, y riq'uin juba' yetzak pa tak bey roma vayjal, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Y ri rutijoxela' xquibij c'a chire: Re lugar ojc'o-vi xa e manek vinek. ¿C'o ta cami nekila-vi-pe vey richin yeva' jebel conojel re vinek re'? xecha' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pero ri Jesús xuc'utuj c'a chique ri rutijoxela': ¿Janipe' vey c'o iviq'uin? xcha' chique. Y rije' xquibij c'a: C'o vuku', xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Y ri Jesús xubij c'a chi ri vinek quetz'uye-ka ri pan ulef. C'ari' rija' xeruli'ej ri vuku' vey y xumatioxij chire ri Dios. Y c'ari' c'a xeruper chuka' el (xerupir chuka' el) y xuya-el chique ri rutijoxela' richin chi niquiya' chique ri vinek. Y ri rutijoxela' can que vi ri' xquiben. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Y c'o c'a chuka' ca'i-oxi' tak quer quiq'uin. Y ri Jesús xumatioxij chire ri Dios roma re quer re', y c'ari' xutek rujachic chique ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ri vinek can jebel vi xquitej quivay. Can man jun c'a ri man ta jebel xva', y c'a c'o na vey y quer ri xmol can. Vuku' chaquech c'a ri xnoj can riq'uin ri vey y quer ri xmol. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ri xquiben va'in chupan ri k'ij ri', jun la'ek caji' mil vinek. Y c'ari' tok ri Jesús xerutek-el ri vinek chi tak cachoch. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Y can jac'ari' tok ri Jesús xoc-el pa canoa quiq'uin ri rutijoxela', y xebe c'a pa jun lugar rubini'an Dalmanuta. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Y ec'o c'a chique ri achi'a' fariseos ri xe'oka' riq'uin ri Jesús, y xquichop c'a qui' riq'uin ch'abel. Y richin chi niquitejtobej ri Jesús xquibij c'a chire chi tubana' c'a chi c'o nibanatej chupan ri caj, richin tuc'utu' chi rija' can ja vi ri Dios ri takayon-pe richin, xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pero ri Jesús xjik'jo'x. Rija' xpe c'a bis pa ránima, y c'ari' xubij: ¿Achique c'a roma re vinek richin re vacami nicajo' niquitz'et chi c'o nibanatej chupan re caj? Pero yin can kitzij c'a ninbij chive chi man ja ta ri nicajo' rije' ri xtibanatej, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Y ri Jesús xeruya' c'a can ri achi'a' fariseos, y xoc-el pa canoa quiq'uin ri rutijoxela', richin chi yek'ax c'a juc'an chic ruchi-ya'. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Y ri tijoxela' xquimestaj c'a xquic'uaj quivay, y ri chiri' pa canoa xaxe c'a jun vey c'o can. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Y ri Jesús xubij c'a chique ri rutijoxela': Can tivac'axaj c'a re xtinbij chive, chi can tichajij c'a ivi' chuvech ri ch'en (ch'amilej-k'or) quichin ri achi'a' fariseos y ri richin ri Herodes, roma xa nuben chire ronojel chi nich'amir, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pero ri tijoxela' xa xquibila' c'a chiquivech: Rija' xubij queri' roma man xkaq'uen ta pe kavay, yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pero ri Jesús can retaman c'a ri niquibila' ri rutijoxela', romari' xubij c'a chique: ¿Achique roma rix nich'ob chi roma manek kavay, romari' tok xinbij queri'? ¿Can man xk'ax ta c'a chivech ri xinbij? ¿Xa can c'a covirinek ri ivánima, romari' man nik'ax ta chivech? ");
INSERT INTO cakCNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Rix c'o runak' tak ivech, pero xa man yixtzu'un ta. C'o ixiquin, pero xa man nivac'axaj ta. ¿Can man jun c'a ri noka' chi'ic'u'x? ");
INSERT INTO cakCNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Can man noka' ta c'a chi'ic'u'x tok yin xentzuk ri vo'o' mil vinek riq'uin ri vo'o' vey ri xinper (xinpir) chiquivech? ¿Rix ri' noka' chi'ic'u'x janipe' chaquech ri xe'inojisaj riq'uin ri vey ri ximol can? xcha' chique. Y ri tijoxela' xquibij c'a chire ri Jesús: Cablajuj chaquech, xecha-apo. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","¿Can man noka' ta c'a chuka' chi'ic'u'x tok xentzuk ri caji' mil vinek riq'uin ri vuku' vey ri xinper (xinpir) chiquivech? ¿Rix ri' noka' chi'ic'u'x janipe' chuka' chaquech ri xe'inojisaj riq'uin ri vey ri ximol can? xcha' chique. Y ri tijoxela' xquibij c'a chire ri Jesús: Vuku' chaquech, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Y ri Jesús xubij c'a chique: ¿Y achique c'a roma tok can c'a man jani nik'ax ta chivech? ");
INSERT INTO cakCNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Y ri Jesús e rachibilan ri rutijoxela', xe'apon c'a pa Betsaida. Y xc'an c'a pe jun achin moy chire. Y ri e c'amayon-pe richin re moy re' xquic'utuj utzil chire richin chi tuya' ruk'a' pa ruvi' richin ri achin moy nitiquir ta nitzu'un. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Xpe ri Jesús xuyukej-el ri achin moy y xuc'uaj-el c'a chuchi' ri ti tinamit. C'ari' ri Jesús xuya-apo ruchub ri chi tak runak'-ruvech ri moy. Y xuya' ruk'a' pa ruvi' chuka'. C'ari' xuc'utuj chire vi c'o ri nutz'et. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Y tok ri moy xujek runak'-ruvech, xubij c'a: Ja'. Yentz'et ri achi'a'. Nintz'et chi achi'el e che'. Pero xa man e que ta chuka' ri', roma xa yebiyin, nicha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Y ri Jesús xuya' chic c'a ri ruk'a' chi tak runak'-ruvech ri achin. Can xuben c'a chire ri achin chi xtzu'un. Y ri achin xtzu'un c'a jebel. Can jebel c'a yerutzu' ronojel; chi nej chi nakaj. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Y ri Jesús xutek c'a el ri achin richin tibe chirachoch. Rija' xubij c'a el chire: Man te'atzijoj na can ri pa tinamit. Man c'a catoc-apo, xa choj cabiyin chi'avachoch, xcha-el ri Jesús chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Y ri Jesús y ri rutijoxela' xebe ri pa tak cocoj tinamit ri ec'o chiri' pa Cesarea richin ri Filipo. Y pa bey, ri Jesús xuc'utuj c'a chique ri rutijoxela': ¿In achique c'a yin, niquich'ob ri vinek? xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Y rije' xquibij chire: Ec'o ri yebin chi rat ja ri Juan ri Bautista. Ec'o ch'aka' chic niquibij chi ja rat ri Elías, ri jun ri xk'alajirisan ri xbix chire roma ri Dios ojer can. Y ec'o c'a chuka' ri yebin chi rat jun chique ri ch'aka' chic achi'a' ri xek'alajirisan ri xbix chique roma ri Dios chupan ri ojer can tiempo, xecha' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Y rija' xuc'utuj chique ri rutijoxela': ¿Y rix achique nich'ob chuvij? xcha' chique. Y ri Pedro can jac'ari' xubij chire ri Jesús: Ja rat ri Cristo, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Y ri Jesús xubij c'a chique chi man tiquitzijoj. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Y ri Jesús xuchop c'a ruc'utic chiquivech ri rutijoxela': Yin ri xinalex chi'icojol, c'o chi ninc'ovisaj q'uiy tijoj-pokonal. Xquinetzelex coma ri rijita'k tak achi'a' ri c'o quik'ij. Xquinetzelex coma ri principal-i' tak sacerdotes. Chuka' xquinetzelex coma ri etamanela' chirij ri ley. Y xquicamisex. Pero pa rox k'ij xquic'astej-pe, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Y tok ri Jesús xubij c'a re ch'abel re' chique ri rutijoxela', can jebel vi k'alaj rubixic xuben chire. Can man xrevaj ta. Pero ri Pedro man xka' ta chuvech ri xubij ri Jesús, romari' xuc'uaj-el juba' quela', y xbechapon-pe chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero tok ri Jesús xrac'axaj queri', xupiscolij-ri' y xerutzu' ri ch'aka' chic rutijoxela'. Y c'ari' xubij chire ri Pedro: Man cac'oje-pe viq'uin rat Satanás, roma man utz ta ri nach'ob. Roma ri ach'obonic rat xa can junan riq'uin ri niquich'ob ri vinek y man nach'ob ta juba' achique c'a ri nrajo' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Y ri Jesús xeroyoj c'a pe ri vinek y ri ch'aka' chic rutijoxela'. Y rija' xubij c'a chique: Vi c'o jun nrajo' nitzekelben vichin, can tubana' c'a achi'el nuben jun ri benek chuxe' ru-cruz. Man nuben ta ri nurayij rija'. Man nupokonaj ta nuc'ovisaj tijoj-pokonal. Vi c'o c'a jun ri nich'obon quere', utz nipe viq'uin richin yirutzekelbej. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Roma vi yalan nupokonaj ri ruc'aslen re vave' chuvech re ruvach'ulef, xa man xtril ta c'a ruc'aslen richin jantape'. Jac'a ri man nupokonaj ta ri', stape' napon pa camic voma yin y roma ri utzilej ch'abel richin colotajic, can xtril ruc'aslen richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Roma achique ta c'a nuq'uen-pe chire ri vinek vi nic'oje' ri beyomel richin ronojel re ruvach'ulef riq'uin y re vinek re' xa man nicolotej ta? ");
INSERT INTO cakCNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Y stape' janíla ta q'uiy ri beyomel c'o riq'uin ri vinek, can man nitiquir ta c'a nulok' ri c'aslen richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Man jun vinek c'a ri tiq'uix nuk'alajirisaj chi in runiman yin y ri nuch'abel. Man tiq'uix nubij queri' chique ri vinek richin re vacami, ri xa man niquinimaj ta ri Dios y can e aj-maqui' vi. Roma vi c'o jun ri niq'uix nubij queri' chique, yin chuka' ri xinalex chi'icojol xquiq'uix ninbij chi ri jun vinek ri' vichin yin. Queri' xtinben tok xquipe chic jun bey, y junan chic nuk'ij-nuc'ojlen riq'uin ri Nata' y e vachibilan-pe ri lok'olej tak ángeles. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Y chuka' ri Jesús xubij c'a chique ri ec'o riq'uin: Tivac'axaj c'a re xtinbij chive, y janíla rejkalen: Ri Dios can xtoc'oje' c'a pa kavi' y xtoc jun utzilej Kak'atoy-Tzij; y can xtik'alajin-vi ri ruchuk'a'. Y ec'o chive rix ri man xquequen ta (xquecom ta), c'a tok quitz'eton chic na can ri', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Y tok ic'ovinek chic c'a vaki' k'ij, ri Jesús xucha' ri Pedro, ri Jacobo y ri Juan, richin chi xaxe quiyon ri e oxi' xeruc'uaj c'a pa ruvi' jun juyu' nim. Y ri Jesús xjalatej c'a ruvech chiquivech ri e oxi' rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Y chuka' ri rutziak can xjalatej ri yetzu'un. Can janíla rusakil xuben, can achi'el ri tef ri nika', y hasta niyic'lun. Y man jun c'a ch'ajoy-tziek ri nitiquir ta nuben quere' rusakil chire jun tziek. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Y xebec'ulun c'a pe ri ca'i' achi'a' quibini'an Elías y Moisés, y yetzijon riq'uin ri Jesús. Ri achi'a' ri' e rusamajela' ri Dios ri xec'oje' ojer can. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Y c'ari' c'a tok ri Pedro xubij-apo chire ri Jesús: Tijonel, xcha' chire. Vave' utz kabanon. Tikabana' c'a oxi' tak jay. Chave rat nikaben jun, ri Moisés nikaben chuka' jun richin, y que chuka' ri' nikaben jun richin ri Elías, xcha' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ri Pedro que c'a ri' xubij-apo y man retaman ta achique roma tok xch'on-apo. Xa ch'obon man ch'obon ri xerubila-apo. Can che oxi' tijoxela' janíla c'a quixibin-qui'. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Y jac'ari' tok c'o jun sutz' ri xmujan quichin. Y chupan c'a ri sutz' ri' c'o jun ri xch'on-pe y xubij c'a: Jare' ri Nuc'ajol y janíla ninvajo'. Tivac'axaj c'a ri rutzij, xcha' ri ch'abel. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pero tok ri tijoxela' xetzu'un chic c'a apo, xquitz'et chi xa man jun chic c'o riq'uin ri Jesús. Xa ruyon chic c'o can. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Y tok rije' e xulan c'a pe chuvech ri juyu', ri Jesús xuchilabej chique ri rutijoxela': Man c'a titzijoj ri xitz'et. Rix utz nitzijoj pero tok yin ri xinalex chi'icojol xic'astej yan pe chiquicojol ri caminaki'; c'a jari' tok ruc'amon nitzijoj, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Y rije' can man c'a xquitzijoj ta ri achique xquitz'et, pero niquic'utula' c'a chiquivech achique ri xrajo' xubij ri Jesús riq'uin ri ch'abel chi xtic'astej-pe chiquicojol ri caminaki'. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Y c'ari' ri e oxi' tijoxela' xquibij c'a chire ri Jesús: Roj k'axinek chikavech chi can ja rat ri Cristo ri takon-pe roma ri Dios. ¿Pero achique c'a roma tok ri etamanela' chirij ri ley niquibij chi nabey chi noka' ri Cristo c'o chi noka' ri Elías? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Y ri Jesús xubij c'a chique: Can kitzij vi chi ri Elías nipe nabey y nuben ruchojmilal ronojel ri c'o. Can achi'el vi ri bin can chirij. ¿Y achique nibij rix? ¿Man cami xtibanatej ta chuka' ri tz'ibatel can chuvij yin ri xinalex chi'icojol chi c'o chi ninc'ovisaj q'uiy tijoj-pokonal y can man jun nuk'ij xtiban chuve? ");
INSERT INTO cakCNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero yin ninbij c'a chive chi ri Elías ri' xpe yan. Y janíla c'a xquiben-el chire. Can achique ri xquirayij xquiben-el chire, can que vi ri' xquiben. Can achi'el ri e tz'ibatajinek can, xcha' ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Y tok ri Jesús e rachibilan ri e oxi' rutijoxela' xapon quiq'uin ri ch'aka' chic tijoxela', rija' xutz'et c'a chi janíla e q'uiy vinek ri quimolon-qui' chiquij, y chuka' ca'i-oxi' etamanela' chirij ri ley ri quichapon-qui' riq'uin ch'abel quiq'uin ri tijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Conojel, can xe c'a xquitz'et chi petenek ri Jesús, xsach quic'u'x. Rije' xequicot, y junanin xebe chuk'ejeloxic (chuk'ijaloxic). ");
INSERT INTO cakCNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Y ri Jesús xuc'utuj c'a chique: ¿Achok pa ruvi' c'a ichapon-vi-ivi' quiq'uin rije'? xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Pero jun c'a chique ri vinek xuchop-apo rubixic chire ri Jesús: Tijonel, xcha' chire. Yin nuc'amon c'a pe ri nuc'ajol chave, roma c'o jun itzel espíritu riq'uin. Y re itzel espíritu re' rumemurisan. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Y tok más nuchop, xabachique lugar c'o-vi, nutorij pan ulef, nivokon ruchi', y nukach'ach'ej rey. Janíla chuka' rucajman chic roma re quere' ruc'ulvachin. Y romari' xinc'utuj utzil chique re atijoxela' richin tiquelesaj re jun itzel espíritu re' riq'uin ri nuc'ajol. Pero man yetiquir ta, xcha' ri achin. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Y ri Jesús jari' xubij chique: Man jun vinek chupan re tiempo re' ri cukul ta ruc'u'x riq'uin ri Dios. ¿Rix nich'ob chi yin can jantape' yic'oje' iviq'uin? ¿Can jantape' c'o chi yixincoch'? Tic'ama' c'a pe ri ala' viq'uin, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Y xc'an c'a pe ri ala' c'a chuvech ri Jesús. Pero tok ri itzel espíritu xutz'et ri Jesús, riq'uin ruchuk'a' xuyiquiquej ri ala' y xutorij pan ulef. Y ri ala' nubolkotila' c'a ri' y nivokon chuka' ruchi'. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Y ri Jesús xuc'utuj c'a chire ri rutata' ri ala': ¿Janipe' yan tiempo ruc'ulvachin-pe quere' re ala'? xcha' ri Jesús. Y ri tata'aj xubij: Can c'a co'ol tok quere' ruc'ulvachin-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Can q'uiy c'a bey rutorin pa k'ak', pa tak ya', richin ta niquen (nicom). Pero vi rat yatiquir nato', tajoyovaj c'a ruvech rija', tajoyovaj nuvech yin; y kojato' c'a. Queri' xubij ri tata'aj chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Pero ri Jesús xubij chire ri tata'aj: Vi rat yatiquir nacukuba' ac'u'x viq'uin chi yitiquir ninto' ri ac'ajol, can xtibanatej-vi ri arayibel. Pero ri' ja rat c'o-vi, roma ri can nucukuba' ruc'u'x tok nuc'utuj, can nibanatej-vi ri achique ri nrajo', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Y ri rutata' ri ala' can jari' xubij: Nincukuba' nuc'u'x. Y chuka' can quinato' richin chi más ta xtincukuba' nuc'u'x. Y tok ri tata'aj xubij ri ch'abel ri', riq'uin c'a uchuk'a' xubij, roma janíla nim ri bis ri c'o riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tok ri Jesús xutz'et chi xa e janíla e q'uiy vinek ri niquimol-apo-qui', ri más utz xuben ja ri xchapon chirij ri itzel espíritu. Rija' xubij c'a chire: Rat ri abanon chire re ala' re' chi man naq'uex ta y amemurisan chuka', catel-el, y man chic catzolin-pe riq'uin, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Y ri itzel espíritu nurek ruchi' (nisiq'uin), xel-el riq'uin ri ala'. Pero janíla xuyiquiquej can. Y ri ala' xc'oje' can pan ulef, achi'el jun caminek. Y romari' e q'uiy vinek xech'obon chi ri ala' xquen (xcom). ");
INSERT INTO cakCNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ri Jesús xuchop ruk'a' ri ala' richin xuyec. Y ri ala' can jari' xbeyacatej-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Y tok ec'o chic pa jay quiyon riq'uin ri Jesús, ri rutijoxela' xquic'utuj chire: ¿Achique roma roj man xojtiquir ta xkelesaj-el ri itzel espíritu? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Y ri Jesús xubij c'a chique: Re jun ruvech espíritu re' nel, pero vi rix niben chi man yixva' ta richin niben orar, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Y tok rije' e elenek chic pe chiri', xek'ax ri pa Galilea. Pero ri Jesús man xrajo' ta chi xnabex chi rija' nik'ax chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Roma rija' nrajo' c'a chi c'o ri niquetamaj can ri rutijoxela', romari' can nucamuluj c'a can rubixic chique. Rija' nubij c'a chique: Yin ri xinalex chi'icojol, can xquijach-vi pa quik'a' ri vinek y xquinquicamisaj. Jac'a tok xa in caminek chic, pa rox k'ij xquic'astej-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero ri tijoxela' xa man xk'ax ta chiquivech ri xbix chique roma ri Jesús. Y niquixibij c'a qui' niquic'utuj chire ri achique ri xubij chique riq'uin ri ch'abel ri xubij. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Y ri Jesús e rachibilan ri rutijoxela' xapon ri pa tinamit Capernaum. Y tok c'o chic ri pa jay, rija' xuc'utuj chique ri rutijoxela': Y rix ¿achique c'a ri nich'ojila' chivech tok kachapon-pe bey? xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero ri tijoxela' man xek'ajan ta apo chuvech ri Jesús, roma tok e petenek ri pa bey, xa xquich'ojila' c'a chiquivech achique ri más nim ruk'ij chique rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Y ri Jesús xtz'uye' c'a ka. C'ari' xeroyoj-apo riq'uin chi cablajuj rutijoxela' y xubij c'a chique: Vi c'o jun nrajo' chi ja rija' ri nabey y c'o ta ruk'ij, nic'atzin chi nuna-ka-ri' rija' chi xa manek ruk'ij y tuch'utinirisaj-ri' richin nusuj-ri' chubanic xabachique samaj quichin conojel ri ch'aka' chic. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Y ri Jesús xberuc'ama' c'a pe jun ti ac'ual y xuya' ri chiri' pa quinic'ajal. C'ari' xuch'elej; y rija' xubij c'a chique ri rutijoxela': ");
INSERT INTO cakCNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ri yacayon vichin ri pa ránima y can riq'uin quicoten nuc'ul jun ac'ual, jun ri achi'el re', man xe ta xtuc'ul ri ac'ual, xa can xquiruc'ul chuka' yin. Y ri nic'ulun c'a vichin yin, man xe ta chuka' yin ri xquiruc'ul, xa can xtuc'ul chuka' ri takayon-pe vichin. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Y ri Juan xubij c'a pe chire ri Jesús: Tijonel, xcha' chire. C'o jun achin man kachibil ta ri katz'eton can. Y re achin re', pan abi' rat yerelesala' itzel tak espíritu. Pero roma xa man kachibil ta, xkabij chire chi man chic tuben queri', xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Y ri Jesús xubij: Man chic c'a tibij queri' chire. Roma vi pa nubi' yin yerubanala' milagros, man chanin ta xtijalatej ri ruch'obonic, y can ja ta ri' nitiquir yerubij itzel tak ch'abel chuvij. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Roma ri man ye'etzelan ta kichin, can kachibil vi ki' quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Y ri vinek c'a ri utz yixrutz'et roma viq'uin yin ri Cristo ixc'o-vi, stape' xa juba' iya' ri nuya', can kitzij c'a ri ninbij chive chi can c'o rajel-ruq'uexel xtuc'ul romari'. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Vi c'o ta jun co'ol ri yiniman y nipe ta jun vinek y nuben chire ri jun co'ol ri' chi nitzak pa mac; man utz ta ri nuben. Y romari' ri vinek ri nich'obon chi nuben ri etzelal ri', xa más ta utz chire rija' chi ximon ta jun nimalej abej richin que'en chukul y netorix can chupan jun nimalej ya'. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Xa roma c'a ri' vi xa jun ak'a' ri nibanon chave chi yamacun, más ta utz chi nachoy-el. Roma más utz chi xaxe jun ak'a' c'o y yatoc chupan ri c'aslen ri man q'uisel ta, que chuvech ca'i' ta ak'a' c'o y xa chi tz'aket yabe chupan ri tijoj-pokonal; chupan ri k'ak' ri man nichup-ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ri lugar ri ec'o jut richin ch'aculaj, ri xa can man yequen ta (yecom ta), y chuka' c'o ri k'ak' ri xa can man nichup ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Y vi xa jun avaken ri nibanon chave chi yamacun, más ta utz chi nachoy-el. Roma más utz chi xaxe jun avaken c'o y yatoc chupan ri c'aslen ri man q'uisel ta, que chuvech ca'i' ta avaken c'o y xa chi tz'aket yabetorix can chupan ri tijoj-pokonal; chupan ri k'ak' ri man nichup ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ri lugar ri ec'o jut richin ch'aculaj, ri xa can man yequen ta (yecom ta), y chuka' c'o ri k'ak' ri xa can man nichup ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Y vi xa jun runak'-avech ri nibanon chave chi yamacun, más ta utz chi navelesaj-el. Roma más utz chi xaxe jun runak'-avech c'o y yatapon chila' riq'uin ri Dios, ri acuchi ja rija' ri K'atoy-Tzij, que chuvech ca'i' ta runak'-avech c'o y xa chi tz'aket yabetorix can chupan ri tijoj-pokonal. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ri lugar ri ec'o jut richin ch'aculaj, ri xa can man yequen ta (yecom ta), y chuka' c'o ri k'ak' ri xa can man nichup ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Can ronojel vi c'a chicop ri e sujun-pe chire ri Dios, e atz'amin. Que chuka' ri' conojel vinek xque'atz'amix, pero man riq'uin ta chic atz'an, xa riq'uin k'ak'. ");
INSERT INTO cakCNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ri atz'an yalan jebel. Y vi ta re atz'an re' niq'uis ta el ri ratz'amil, ¿achique ta c'a rubanic niben rix richin queri' nitzolin ta chic pe ri ratz'amil? Romari' rix tichajij ic'aslen, richin queri' man quixoc achi'el ri atz'an ri man natz'amin ta chic, y chuka' man jun ta oyoval chi'icojol. Queri' xubij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Y c'ari' ri Jesús e rachibilan ri rutijoxela' xel-el chiri' y xbe c'a pa Judea. Y xk'ax chuka' juc'an chire ri raken-ya' Jordán. Chiri', janíla chuka' q'uiy vinek xquimol-qui' riq'uin. Y rija' xuchop c'a ruc'utic ri ruch'abel ri Dios chiquivech, can achi'el rubanon-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Y jac'ari' tok ec'o achi'a' fariseos ri xe'apon riq'uin, richin chi niquiya' pa c'ayef ri Jesús y nitzak ta pa quik'a'. Rije' xquic'utuj c'a chire vi ruc'amon chi jun achin nujech-ri' riq'uin ri rixjayil. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Y ri Jesús xubij c'a chique ri achi'a' ri': ¿Achique c'a ri rubin can ri Moisés chive richin niben? xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Y rije' xquibij c'a: Ri Moisés can ruyo'on-vi can k'ij chire ri achin richin nuben jun vuj richin jachojri'il y nuya' can ri rixjayil, xecha' rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Y ri Jesús can jac'ari' xubij chique: Can achi'el c'a covirinek ri ivánima rix chupan ri man utz ta, can que c'a chuka' ri' xc'ulvachitej ojer can, ri pa ru-tiempo ri Moisés. Xa romari' tok rija' xubij chi can tiban c'a queri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Jac'a ri pa rutiquiribel pe xa man que ta ri'. Ri pa rutiquiribel, tok ri Dios xuben re ruvach'ulef, can pa c'ulaj c'a xeruben ri vinek. Can man ruyon ta ri achin y man ruyon ta chuka' ri ixok. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Romari' ri achin man chic c'a quiq'uin ta rute-rutata' xtic'oje-vi. Xa riq'uin c'a ri rixjayil xtic'oje-vi, ");
INSERT INTO cakCNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","y che ca'i' xa jun c'a xtiquiben. Roma tok quic'uan chic qui', man chic e ca'i' ta c'a vinek, man chic que ta ri', xa jun chic c'a ri quibanon. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Roma c'a ri' ri can e tunun chic roma ri Dios, man tuben ri vinek chi yeruch'er, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tok ri Jesús y ri rutijoxela' ec'o chic c'a pa jay, xepe ri tijoxela' xquic'utula' chire ri Jesús chi achique c'a ri xrajo' xubij riq'uin ri ch'abel ri c'ari' yerubij can chique ri achi'a' fariseos. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Y ri Jesús xubij c'a chique: Xabachique achin ri nujech-ri' riq'uin ri rixjayil y c'ari' nuq'uen chic pe jun ixok, re achin re' nimacun chuvech ri rixjayil. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Y que chuka' ri' ri ixok ri nujech-ri' riq'uin ri rachijil y nibe chic riq'uin jun achin, re ixok re' can nimacun chuka'. Queri' xubij chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Y ri vinek yequic'amala' c'a pe ri ac'uala' c'a riq'uin ri Jesús, richin nuya' ta el ri ruk'a' pa quivi'. Pero ri tijoxela' xa xquibij chique ri vinek chi man tiquiben queri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jac'a tok ri Jesús xutz'et ri niquiben ri rutijoxela', xpe royoval, roma man utz ta xutz'et ri ye'ajin chubanic, y xubij c'a chique: Tiya' k'ij richin chi ri ac'uala' yepe c'a viq'uin, y man que'ik'et. Roma ri xque'oc pa rajavaren o pa ruk'a' ri Dios, xaxe ri e achi'el ri ac'uala'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Y can kitzij c'a ninbij chive, chi ri xa man niquiben ta achi'el ri ac'uala' richin chi niquijech-qui' pa ruk'a' ri Dios, can man c'a xque'oc ta pa rajavaren o pa ruk'a' ri Dios, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Y rija' xeruch'elela' y xuyala' ri ruk'a' pa quivi' ri ac'uala' richin chi xerurtisaj. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Y tok ri Jesús e rachibilan ri rutijoxela' xuchop chic el ri rubey, c'o jun achin junanin xoka' riq'uin, xxuque' chuvech, y xubij c'a chire: Rat ri utzilej Tijonel tabij c'a chuve: ¿Achique c'a ruc'amon chi ninben yin richin chi ninvichinaj ri c'aslen ri man q'uisel ta? xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Y ri Jesús xubij chire: ¿Achique roma tok nabij utz chuve yin? Roma man jun vinek ri utz ta, xa can xe ri Dios ri utz. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Y yin ninbij chi rat jebel avetaman ri lajuj pixa' ri xuya' ri Dios pa ruk'a' ri Moisés ri ojer can, chi rat achin ri c'o avixjayil man tacanoj jun chic ixok; man cacamisan; man catelek'; man tatz'uc tzij chirij jun chic vinek; man tak'ol jun vinek richin chi navelesaj chire ri xa richin rija'; taya' quik'ij ri ate-atata', xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Y ri achin can jari' xubij chire ri Jesús: Tijonel, xcha' c'a chire. C'a in co'ol tok nubanon-pe ronojel ri', xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Y ri Jesús riq'uin c'a ajovabel xutzu' ruvech ri achin tok xubij queri', y c'ari' xubij chire: C'a c'o jun ri man abanon ta. Man atalun ta ri abeyomel chiquivech ri vinek ri man jun c'o quiq'uin. Te'ac'ayij c'a can ronojel ri c'o aviq'uin y ri rajel tataluj chiquivech ri vinek ri man jun c'o quiq'uin, richin queri' nic'oje' abeyomel ri chila' chicaj. Y catampe c'a viq'uin, quinatzekelbej, y man tapokonaj nac'ovisaj tijoj-pokonal voma yin, achi'el xa ta can at benek chuxe' jun cruz, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pero tok ri achin xrac'axaj ri ch'abel ri xubij ri Jesús chire, xa can xupiscolij-ri' ri ránima xuna' rija', roma rija' can janíla ri beyomel c'o riq'uin. Y nibison c'a ránima xtzolin-el, roma man nrajo' ta chi nel ri rubeyomel pa ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Y ri Jesús xerutzu' ri rutijoxela', y xubij chique: Ri c'o quibeyomel, janíla c'ayef richin chi ye'oc pa rajavaren o pa ruk'a' ri Dios, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Y ri rutijoxela' ri Jesús can achique la xcac'axaj ri ch'abel ri xubij ri Jesús. Pero rija' xubij chic c'a jun bey chique: Valc'ual, xcha' chique. Ri can quicukuban quic'u'x riq'uin ri quibeyomel, janíla c'ayef richin chi ye'oc pa rajavaren o pa ruk'a' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Xa más la'ek man can ta c'ayef chi nik'ax ri jun chicop rubini'an camello pa ti rujulil jun bak, que chuvech jun beyon noc ta pa rajavaren o pa ruk'a' ri Dios, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pero tok ri tijoxela' xcac'axaj chic jun bey ri ch'abel ri xubij ri Jesús, xsach quic'u'x y xquibila' c'a chiquivech: Vi can achi'el ri nubij, queri', man jun xticolotej, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Y ri Jesús xerutzu' chic c'a ri rutijoxela' jun bey y xubij c'a chique: Ri vinek man yetiquir ta niquicol-qui', jac'a ri Dios can nitiquir-vi yerucol, roma rija' ronojel nitiquir nuben, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Y jari' tok ri Pedro xubij chire: Rat avetaman chi roj kayo'on can ronojel ri c'o kiq'uin, richin queri' at katzekelben, xcha' ri Pedro. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pero ri Jesús can jari' xubij chire: Can kitzij c'a ninbij chive, chi xabachique vinek can c'o ri xtuc'ul, vi voma yin y roma ri utzilej ch'abel richin colotajic ruyo'on ta can rachoch, rach'alal e alabon y xtani', rute-rutata', rixjayil, ralc'ual o rulef. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Can q'uiy c'a xtuc'ul ri nibanon queri'. Can pa ciento c'a bey más q'uiy ri xtuc'ul yan chupan re tiempo re kachapon. Xtuc'ul yan rachoch, rach'alal e alabon y xtani', rute', ralc'ual o rulef. Can riq'uin vi c'a tijoj-pokonal roma tzekelbey vichin yin, pero chupan apo ri jun chic tiempo chikavech apo, can xtuc'ul c'a ri ruc'aslen ri xa man q'uisel ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Y e q'uiy c'a ri janíla quik'ij vacami, xtapon ri k'ij tok manek chic quik'ij xtic'oje'. Y e q'uiy ri manek quik'ij re vacami, xtapon ri k'ij tok xtic'oje' quik'ij, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ri Jesús, ri rutijoxela' y ri ch'aka' chic vinek, quichapon c'a el bey pa tinamit Jerusalem. Y can jac'a ri Jesús ri ic'ovinek-el chiquivech, y romari' ri rutijoxela' y ri vinek can achique la niquitz'et y quixibin chuka' qui' e tzeketel-el chirij. C'ari' ri Jesús xeruch'er c'a el juba' ri cablajuj rutijoxela' y xubij chic c'a chique ri achique chi tijoj-pokonal ri xtuc'ovisaj. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Rija' xubij c'a chique: Rix ivetaman chi pa tinamit Jerusalem kachapon-vi-el bey, y ja ri chiri' ri xquijach-vi-el yin ri xinalex chi'icojol. Xquijach-el pa quik'a' ri principal-i' tak sacerdotes y pa quik'a' ri etamanela' chirij ri ley. Y rije' xtiquibij chi tika' ri camic pa nuvi'. Y chuka' xquinquijech-el pa quik'a' vinek ri xa man e israelitas ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Y ri vinek ri' xquinquitze'ej, xquinquichubaj, xquinquich'ey, y c'ari' xquinquicamisaj. Pero pa rox k'ij xquic'astej-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Y ri Jacobo y ri Juan, ri e ruc'ajol ri achin rubini'an Zebedeo, xejel c'a apo riq'uin ri Jesús, y xquibij chire: Tijonel, xecha' c'a chire. Roj nikajo' nikac'utuj jun utzil chave. Pero naben ta c'a utzil can naben ri xtikac'utuj chave, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Y rija' xubij chique: ¿Achique c'a chi utzil ri nivajo'? xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Y rije' xquibij c'a: Roj nikajo' c'a chi tok c'o chic ak'ij-ac'ojlen rat, naben ta chuka' chike roj chi nic'oje' kak'ij, naya' ta k'ij chike richin chi yojtz'uye' ta apo aviq'uin; jun ta ri nic'oje' pan avajquik'a' y jun ta ri pan avajxocon (izquierda). ");
INSERT INTO cakCNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pero ri Jesús xubij chique: Rix man ivetaman ta c'a chi c'ayef chive ri nic'utuj. Y romari' yin ninc'utuj c'a chive: ¿Nicoch' cami rix ri xtiban chuve yin? ¿Y nicoch' cami chuka' rix jun tijoj-pokonal achi'el ri xtika' pa nuvi' yin? Roma ronojel c'a re xtik'ax pa nuvi', xa achi'el jun c'ayevalej bautismo, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Y rije' xquibij c'a: Nikacoch', xecha'. Y ri Jesús xubij chic c'a chique: Can kitzij vi c'a chi rix xticoch' na vi achi'el ri xtiban chuve yin. Chuka' can xticoch' jun tijoj-pokonal achi'el ri xtika' pa nuvi' yin; ri xa xtik'ax pa nuvi' achi'el jun c'ayevalej bautismo. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Jac'a ri nic'utuj chuve chi jun nitz'uye' ta pa vajquik'a' y jun ri nitz'uye' ta pa vajxocon (izquierda), ri' man pa nuk'a' ta c'a yin c'o-vi richin chi ninya' chive. Roma ri nic'utuj rix, ri' xa quichin chic c'a ri xtubij ri Dios chi utz chi yetz'uye' ri chiri', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Y ri lajuj chic tijoxela', tok xcac'axaj ri xbitej, xpe c'a coyoval chique ri Jacobo y ri Juan. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Y jac'ari' tok ri Jesús xeroyoj ri rutijoxela' y xubij c'a chique: Yin ninbij chi rix jebel ivetaman chi re vave' chuvech re ruvach'ulef, ja ri banon k'atoy tak tzij chique, jari' ri ec'o pa quivi' ri vinek, y roma c'a can ec'o ri vinek pa quik'a', romari' can niquina' chi ja rije' ri e cajaf. Xa can xe c'a ri c'o quik'ij ri yebin ri c'o chi niban. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Jac'a ri chi'icojol rix man que ta ri'. Roma ri nrajo' c'a nic'oje' ruk'ij chive rix, nic'atzin chi nuna-ka-ri' chi xa manek ruk'ij y tuch'utinirisaj-ri' richin nusuj-ri' chubanic xabachique samaj. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Vi jun c'a chive rix can nrajo' chi ja rija' ri nabey y c'o ta ruk'ij, can tuna' c'a ri' chi xa manek ruk'ij y tuch'utinirisaj-ri' richin chi nusuj-ri' chubanic xabachique samaj quichin conojel ri ch'aka' chic. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Y que c'a ri' yin ri xinalex chi'icojol. Yin man ninpokonaj ta yisamej coma ri ch'aka', roma can richin ri' tok xipe; y man xipe ta c'a richin chi ec'o chic ch'aka' yebanon-pe ri ninbij chique. Can jac'a yin ri yibanon ri samaj, y can jac'a yin ri yiyo'on ri nuc'aslen richin queri' e q'uiy ri yecolotej, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","C'ari' ri Jesús y ri rutijoxela' xe'apon c'a ri pa tinamit Jericó. Y tok rije' niquiya' c'a can ri tinamit, e janíla c'a e q'uiy vinek ri e tzekelbeyon-el quichin. Y ri chiri' chuchi-bey c'o c'a jun moy rubini'an Bartimeo, ruc'ajol jun achin rubini'an Timeo. Rija' tz'uyul c'a ri chiri', nuc'utula' can ru-limosna chique ri vinek ri yek'ax queri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Y tok rija' xrac'axaj c'a chi ri nik'ax-el queri' ja ri Jesús aj-Nazaret, rija' riq'uin c'a ruchuk'a' xch'on y xubij: Tajoyovaj nuvech rat Jesús, ri at riy-rumam can ri rey David, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Y e q'uiy c'a vinek ri xquibila' chire chi man chic tich'on. Pero rija' xa riq'uin más ruchuk'a' ri nich'on y nubij c'a: Rat ri riy-rumam can ri rey David, tajoyovaj nuvech roma re nubanon, nicha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Y ri Jesús xrac'axaj c'a ri ruch'abel. Romari' xpa'e-ka y xubij c'a chi toyox-pe ri achin. Y jac'ari' xbecoyoj-pe ri achin moy y xquibij chire: Man taxibij-avi'. Jo' kiq'uin. Ri Jesús yaroyoj, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Y ri achin can xe c'a xrac'axaj queri', can jari' xyacatej-pe. Xuya' can ri ruk'u' chiri' y xbe-apo riq'uin ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Y ri Jesús xuc'utuj chire: ¿Achique c'a ri navajo'? Y ri achin moy xubij chire: Tijonel, xcha' rija'. Yin ninvajo' yitzu'un, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Y ri Jesús can jari' xubij c'a chire: Vacami xa utz chic yabe, roma yatzu'un chic. Y re' roma ri xacukuba' ac'u'x viq'uin. Xacolotej c'a chuvech re amoyirinen. Y ri moy can xtzu'un-vi y xrojkaj-el ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Y tok nakaj chic ec'o-vi chique ri tinamit quibini'an Betfagé y Betania, xa juba' chic nrajo' chi ye'apon pa tinamit Jerusalem, roma can chuxe' chic apo ri juyu' rubini'an Olivos ec'o-vi. Y jari' tok ri Jesús xerutek-el e ca'i' chique ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Rija' xubij c'a el chique: Quixbiyin-apo chupan la ti tinamit la nitzu-apo chila'. Y can ja yan ri xquixoc-apo, jari' xtivil jun alaj burro ximil can chiri'. Y ri chicop ri' can c'a man jun ch'ocolbeyon richin. Tisolo' c'a pe y tic'ama-pe chuve. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Y vi c'o jun xtibin-pe chive chi achique roma nisol-pe ri chicop, tibij chire chi nic'atzin chire ri Ajaf, pero chanin xtorutzolij can, quixcha' can chire, xe'uche'ex-el roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Y ri ca'i' tijoxela' xebe c'a. Tok xe'apon, xquil na vi ri alaj burro, ximon can chiri' pa bey, ri acuchi niban-vi-apo oquen ri chuva-jay. Y rije' xquisol c'a pe. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pero tok rije' niquisol c'a pe ri alaj burro, xetz'et-pe coma jun ca'i' ri ec'o chiri' y xquibij chique ri e ca'i' tijoxela': ¿Achique yixajin chubanic chiri'? ¿Achique roma yixajin chusolic ri ti alaj burro? xecha-pe chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Y ri tijoxela' xquibij c'a ri rubin-el ri Jesús chique. Y ri xetz'eton-pe quichin xquiya' k'ij chique richin chi xquic'uaj-el ri alaj burro ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Y ri tijoxela' ri' xquiq'uen c'a pe ri alaj burro chire ri Jesús. C'ari' xquiya' c'a quik'u' chirij ri chicop ri', richin chi ri Jesús xch'oque-el chirij. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Y e q'uiy c'a chique ri vinek richin chi niquiya' ruk'ij ri Jesús, xquiriq'uila' ri quik'u' pa rubey. Y ch'aka' chic vinek richin chi xquiya' chuka' ruk'ij ri Jesús, xebequic'amala-pe ruk'a' tak che' richin vikobel (vekobel), richin chi xequiric' pa rubey. Y que c'a ri' niquibanala' e benek. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ri vinek c'a ri e nabey chuvech ri Jesús y ri ec'o can chirij, can riq'uin c'a ronojel cuchuk'a' niquibij: ¡Matiox chi petenek re Jun re'! ¡Rija' urtisan-pe roma ri Ajaf Dios! ¡Rija' petenek pa rubi' ri Ajaf Dios! ");
INSERT INTO cakCNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Matiox chi nitzolej yan chic pe ri ruk'atbel-tzij ri David ri katata' ri xc'oje' ojer can! ¡Matiox chire ri Dios ri c'o chila' chicaj! xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Y ri Jesús xoc c'a apo ri pa tinamit Jerusalem y xbek'ax-pe ri pa rachoch ri Dios y xerutzu' can ri ec'o chiri'. Y tok xk'ekumer-pe, rija' e rachibilan ri e cablajuj rutijoxela' xebe ri pa tinamit Betania. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pa ruca'n k'ij tok quichapon bey richin yetzolin-pe pa Betania y yebe pa Jerusalem, ri Jesús xpe c'a vayjal chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Y rija' c'anej c'a xutzu' chi c'o jun víquix (higo) tiquil, y janíla jebel rubanon ri ruxak. Xbe c'a apo riq'uin, richin nerucanoj-pe jun ruvech. Pero tok xapon-apo riq'uin, xa man jun ruvech c'o, xa ruyon ruxak. Roma man ruk'ijul ta richin c'o ruvech. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jac'ari' tok ri Jesús xch'on chire ri che' y xubij c'a: Man c'a xcavachin ta chic. Can man jun chic c'a vinek xtitijon ri avech, xcha'. Y ri rutijoxela' can xcac'axaj c'a ri xubij. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Y xe'apon chic c'a pa tinamit Jerusalem. Y ri Jesús xbe c'a pa rachoch ri Dios. Pero tok rija' c'o chic chiri', xerokotala-pe ri c'ayinela' y ri lok'onela' ri ec'o chiri'. Y chique ri jaloy-ruvech mero, xerutec'mayila' can ri qui-mesas. Y que chuka' ri' xuben can chique ri quich'acat ri c'ayil tak palomas. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Y rija' man xrajo' ta c'a chi ri vinek quic'uan ejka'n, yek'ax ta chupan ri ruva-jay richin ri rachoch ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","C'ari' rija', xuc'ut c'a chuka' chiquivech ri vinek riq'uin ri ruch'abel ri Dios, chi ri rachoch ri Dios xa can richin vi oración. Romari' rija' xubij chique ri vinek: ¿Man tz'ibatel ta cami can chupan ri ruch'abel ri Dios chi ri vachoch jay richin chi niquiben orar conojel vinek ri ec'o chuvech re ruvach'ulef? Pero rix xa man richin ta ri' icusan-vi, xa ibanon quijul elek'oma' chire, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Y ri' xac'axex c'a coma ri principal-i' tak sacerdotes y ri etamanela' chirij ri ley. Pero roma rije' yequitz'et ri vinek chi can niquicambej ri ch'abel ri nubij ri Jesús chique, romari' xa can niquicanola' c'a chi achique ta jun rubanic niquiben richin chi niquicamisaj ri Jesús. Ri principal-i' tak sacerdotes y ri etamanela' ri' niquixibij c'a qui' chuvech ri Jesús, roma xa can jubama conojel ri vinek jebel nicac'axaj ri rutijonic. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Y tok xk'ekumer-pe, ri Jesús e rachibilan ri rutijoxela' xbe c'a. Man xc'oje' ta ka ri chiri' pa tinamit Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nimak'a' ruca'n k'ij, tok quichapon bey pa Jerusalem, xquitz'et c'a chi chaki'j chic ri víquix (higo) ri xch'on can ri Jesús riq'uin, chi man jun bey chic xtuya' ruvech. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Y ri Pedro chanin c'a xoka' chuc'u'x, y xubij chire ri Jesús: Tijonel, tatzu' la víquix (higo), xa can xchaki'j-vi-ka achi'el ri xabij, xcha' c'a ri Pedro. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pero ri Jesús xubij c'a chique conojel ri rutijoxela': Rix chuka' nic'atzin chi nicukuba' ic'u'x riq'uin ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Roma riq'uin ri queri', can kitzij ninbij chive chi xabachique ri nibin chire re juyu' re' chi tel-el vave' y tik'ax chupan ri nimalej ya' rubini'an mar, can queri' nibanatej. Vi can kitzij nucukuba' ruc'u'x y man nipe ta pa ránima chi xa man nibanatej ta la'ek ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Roma c'a ri', yin can ninbij c'a chive chi ronojel ri nic'utuj tok rix niben orar y nich'ob chi can xtic'ul-vi, can xtika-vi c'a pe ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Y tok niben orar, can man ta jun ri nik'aton richin. Roma vi xa c'o ta jun ri c'o rubanon chivech, ticuyu'. Richin queri' ri aj-chicajil Itata' xquixrucuy chuka' rix riq'uin ri imac ri ye'ibanala' chuvech. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Roma vi rix xa man nicuy ta rumac jun ri c'o rubanon chive, chuka' ri aj-chicajil Itata' man xtucuy ta ri imac ri ye'ibanala' chuvech. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ri Jesús e rachibilan ri rutijoxela' xe'apon chic c'a pa tinamit Jerusalem. Y chiri' c'a pa rachoch ri Dios c'o-vi rija' tok xe'apon ri principal-i' tak sacerdotes riq'uin, y chuka' ri etamanela' chirij ri ley y ri rijita'k tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Y xquic'utuj c'a chire: ¿Achique xyo'on k'atbel-tzij pan ak'a' richin xe'avokotaj-el ri vinek c'ayinela' vave' pa rachoch ri Dios? ¿Y achique xbin chave chi que'abanala' que tak re'? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Xpe ri Jesús xubij c'a chique ri achi'a' ri': Yin c'o chuka' jun ri ninvajo' ninc'utuj chive. Y vi rix xtibij chuve, yin chuka' xtinbij chive achique yoyon uchuk'a' chuve richin yenbanala' que tak re'. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tivac'axaj c'a jebel re xtinc'utuj chive. ¿Ri Juan xtak-pe roma ri Dios richin xeruben bautizar ri vinek? ¿O xa vinek xebin chire chi tubana' queri'? Tibij c'a chuve ri achique nich'ob, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Y ri principal-i' tak sacerdotes, ri etamanela' y chuka' ri rijita'k tak achi'a' ri c'o quik'ij, xquibila' c'a chiquivech: ¿Achique c'a xtikabij chire re Jesús vacami? xecha-ka. Roma vi nikabij chi ri Juan ja ri Dios takayon-pe richin, ri Jesús xtubij c'a chike chi achique c'a roma tok man xinimaj ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Y vi nikabij chi xa vinek xebin chire ri Juan chi tubana' queri', c'ayef chike roj. Rije' xquich'ob-ka queri', roma quixibin-qui' chiquivech ri vinek. Roma conojel ri vinek can quetaman c'a chi ri Juan can xuk'alajirisaj-vi ri xbix chire roma ri Dios. Xa can jun c'a rusamajel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Y c'ari' c'a rije xquibij-apo chire ri Jesús: Roj man ketaman ta, xecha'. Y ri Jesús can jac'a chuka' ri' xubij chique: Roma c'a rix xa man xixtiquir ta xibij chuve, que c'a chuka' ri' yin man xtinbij ta chive achique yoyon k'ij chuve richin yenbanala' quere', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Y ri Jesús, riq'uin c'a c'ambel tak tzij xch'on-vi quiq'uin. Rija' que c'a re' ri xubila' chique: Xc'oje' c'a jun achin ri xutic ruvech ri rulef riq'uin uva. Xuc'ojoj rij ri rulef y xuben chuka' achi'el jun ti pila ri pan ulef ri richin niyitz' ri uva. Xuben chuka' jun tz'ak ri nej jotol, y pa ruvi' ri' xc'oje-vi rachoch ri chajinel. C'ari' xuya' can pa kajic chique ca'i-oxi' samajela', y rija' xbe nej. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Y ri rajaf ri ulef xutek c'a jun raj-ic' achin quiq'uin ri achi'a' ri e kajayon ri ulef, tok can tiempo chic richin chi neruc'ulu-pe ri uva kajbel richin ri ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Jac'a tok xapon ri aj-ic' quiq'uin ri achi'a' ri e kajayon ri ulef, re kajoy tak ulef re' xquichop c'a ri aj-ic' y xquich'ey, y man jun c'a uva xquiya-el pa ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Y ri rajaf ri ulef xutek chic c'a jun raj-ic' achin c'a quiq'uin ri kajoy tak ulef, chuc'amic ri uva kajbel richin ri ulef. Pero ri achi'a' kajoy tak ulef xa chi abej xquic'ul-vi-apo y xquisocola-el pa rujolon (ruvi'). Q'uiy c'a ri xquibanala' y xquibila-el chire, y queri' xquitek-el. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pero ri rajaf ri ulef xutek chic jun raj-ic'. Y re aj-ic' re' xcamisex coma ri kajoy tak ulef. Y e janíla c'a ch'aka' chic rajic'a' xerutek, pero conojel c'o xquic'ulvachila'. Ec'o xech'ay, y ec'o xecamisex. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Y pa ruq'uisibel, ri rajaf ri ulef xaxe chic c'a ri ruc'ajol xc'oje' can riq'uin y rija' janíla nrajo' ri ruc'ajol. Pero ri rajaf ri ulef xutek c'a ri ruc'ajol c'a quiq'uin ri achi'a' ri e kajayon ri rulef, roma rija' xuch'ob: Ri achi'a' kajoy-ulef can xqueniman-vi c'a tok xtiquitz'et chi can ja ri c'ajolaxel ri napon, xcha-ka pa ránima. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero tok ri achi'a' ri e kajoy richin ri ulef xquitz'et chi ja ri ruc'ajol ri rajaf ri ulef ri xapon, xquibila' c'a chiquivech: Jare' ri xtichinan can ronojel re ulef re kakajon vacami. ¿Achique roma man nikacamisaj? Richin queri' pa kak'a' roj nic'oje-vi can re ulef, xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Y can que vi c'a ri' xquiben. Xquichop ri c'ajolaxel, xquicamisaj. Xquelesaj c'a el ri chiri' pa rulef. Rije' xbequitorij c'a can juc'an chic ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","C'ari' ri Jesús xubij: ¿Achique cami xtuben ri rajaf ri ulef quiq'uin ri achi'a' kajoy tak ulef? Ri rajaf ri ulef xtipe c'a y xquerucamisaj ri kajoy tak ulef ri' y ri rulef xtuya' chic can pa kajic chique ch'aka' chic. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Y can man jun bey cami chuka' itz'eton ri jun tzij tz'ibatel can chupan ri ruch'abel ri Dios? Ri tzij ri nubij: C'o c'a jun abej ri man xka' ta chiquivech ri ch'aka' banoy tak jay. Pero re abej re' can xch'acon-vi, roma re abej re' xa can c'o-vi ri xucusan chire ri jay richin chi ri jay ri' man nitzak ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Can ja vi ri Ajaf xbanon re', y ri runak' tak kavech can man jun bey c'a quitz'eton chi nibanatej ta quere'. Queri' nubij ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Y ri achi'a' achok iq'uin xch'on-vi ri Jesús c'o ta xcajo' chi xquichop yan ta el, roma xquinabej chi ri achi'a' kajoy tak ulef ri xerunataj chupan ri c'ambel-tzij, xa chiquij rije' xch'on-vi. Y xa man jun xquiben richin xquichop ta el, roma niquixibij-qui' chiquivech ri vinek ri ec'o riq'uin. Rije' xquiya' c'a can ri Jesús y xebe. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Y ri achi'a' ri' ec'o c'a ch'aka' chic cachibil ri xequitek-pe. Xequitek c'a pe ca'i-oxi' achi'a' fariseos y chuka' e ca'i-oxi' ruvinak ri rey Herodes, richin chi niquiya' ta pa c'ayef ri Jesús y nitzak ta pa quik'a' riq'uin ri ch'abel ri nubij. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","C'ari' rije' xepe c'a y xquibij chire ri Jesús: Rat ri at jun Tijonel, roj can ketaman c'a chi xaxe vi c'a ri kitzij ri nika' chavech y jari' ri natzijoj. Y rat man naxibij ta chuka' avi' chuvech jun vinek, stape' can janíla ta ruk'ij. Y can nac'ut-vi ri ruch'abel ri Dios pa rubeyal. ¿Achique c'a nabij chike? ¿Ruc'amon cami chi nikatoj ri alcaval ri nubij ri rey César ri c'o chi nikatoj o xa man ruc'amon ta chi nikatoj chire? xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero ri Jesús can retaman-vi chi riq'uin ca'i' quipalej ri niquic'utuj queri'. Romari' rija' xubij chique: ¿Achique c'a roma rix nitej ik'ij richin yinitejtobej? Tic'ama' c'a pe ri mero ri' y tintzu' na c'a achique ruvech, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Y rije' xbequic'ama' c'a pe ri mero richin niquic'ut chuvech. Y c'ari' rija' xuc'utuj c'a chique: ¿Achok vachibel c'a la'? ¿Y achok bi' chuka' la c'o chuvech la mero? xcha' rija'. Y rije' xquibij: Richin ri rey César, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Y jari' tok ri Jesús xubij chique: Titojo' ri alcaval chire ri César riq'uin ri mero ri ruc'amon chi niya' chire rija'. Y tiya' chire ri Dios, ronojel ri ruc'amon chi niya' chire rija', xcha' ri Jesús chique. Y rije' can achique la xquina' tok xcac'axaj ri xubij ri Jesús chique, roma man xetiquir ta xquiya' pa c'ayef. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Y jac'ari' tok ch'aka' chique ri achi'a' saduceos xe'apon riq'uin ri Jesús. Re achi'a' re' man niquinimaj ta c'a chi ri caminaki' xquec'astej chic pe. Y roma c'a ri' rije' xquibij chire ri Jesús: ");
INSERT INTO cakCNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Rat ri at jun Tijonel chuka', c'o c'a jun ri nikajo' nikac'utuj chave. Ri Moisés can rutz'iban-vi c'a can chike, chi tok jun achin nuya' can ri rixjayil roma ri niquen-el (nicom-el) y man jun ralc'ual nic'oje' can, can jun c'a rach'alal rija' ri c'o chi nic'ule' riq'uin ri malca'n-ixok, richin queri' yec'oje' ta ralc'ual riq'uin ri ixok malca'n. Y vi can ec'o ralc'ual yec'oje' riq'uin ri ixok, ri nabey ala' noc ralc'ual ri caminek chic el. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Y rije' xquibij c'a: Que c'a ri' xec'oje' e vuku' achi'a' cach'alal qui'. Ri nabey xc'ule'. Pero xquen-el (xcom-el), y man jun ralc'ual xc'oje'. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Xpe ri ruca'n achin, ri rach'alal can ri achin ri caminek chic el, xc'ule' riq'uin ri malca'n ixok. Pero chuka' re achin re' xquen-el (xcom-el) y man jun ralc'ual xc'oje'. Ri rox achin can ja chuka' ri' xuc'ulvachij-el, achi'el ri ca'i' nabey tak rach'alal y ri ixok c'a xc'oje' na can. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Che vuku' achi'a' cach'alal qui' quere' xquic'ulvachila-el. Y man jun chique re vuku' achi'a' re' xc'oje' ta can ralc'ual. Y pa ruq'uisibel xquen chuka' el (xcom chuka' el) ri ixok. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Y ri achi'a' saduceos xquibij c'a chire ri Jesús: Rat nabij chi xtapon jun k'ij tok ri caminaki' xquec'astej-pe. Tok xtapon c'a ri k'ij ri', ¿achok ixjayil c'a xtoc re ixok re'? Roma che vuku' achi'a' cach'alal qui' xec'oje' riq'uin, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Can jac'ari' tok ri Jesús xubij chique ri achi'a' ri': ¿Man cami ix sachinek ta riq'uin ri xibij, roma man k'axinek ta chivech ri nubij chupan ri ruch'abel ri Dios? ¿Man c'a ivetaman ta chi ri ruchuk'a' ri Dios janíla nim? ");
INSERT INTO cakCNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Roma tok ri caminaki' xquec'astej-el, man xquec'ule' ta chic, ni man chuka' xqueyatej ta el quimi'al-quic'ajol richin yec'ule'. Xa xque'oc achi'el ri ángeles ri ec'o chila' chicaj. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Y ri caminaki' can xquec'astej-vi, y yin ninch'ob chi rix jebel ivetaman ri achique ri tz'ibatel can roma ri Moisés, tok rija' xutz'et ri ruxulu-quiej, ri jun k'ayis c'o ruq'uixal, nic'at, y chiri' xbech'on-pe ri Dios chire y xubij: Ja yin ri ru-Dios ri Abraham, ri ru-Dios ri Isaac y ri ru-Dios chuka' ri Jacob, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Y vi ta rije' e caminaki' richin jantape' y xa man ta yec'astej chic pe jun bey, ri Dios man ta qui-Dios rije', roma ri Dios can qui-Dios vi ri c'o quic'aslen y man quichin ta ri caminaki'. Roma c'a ri' yin ninbij chi xa ix sachinek riq'uin ri nibij, xcha' ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Y jac'ari' tok xjel-apo riq'uin ri Jesús jun etamanel chirij ri ley. Ri etamanel ri' xrac'axaj c'a ri xquibij ri achi'a' saduceos chire ri Jesús, y xrac'axaj chuka' ri xubij ri Jesús chique ri achi'a' ri'. Y chuvech rija' can k'alaj vi chi utz ri xubij ri Jesús y c'ari' xuc'utuj c'a: ¿Achique c'a chique ri pixa' ri xuya' ri Dios pa ruk'a' ri Moisés, ri c'o pa nabey? xcha' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Y ri Jesús xubij c'a chire: Ri nabey pixa' jac'a ri nubij: Tivac'axaj c'a rix aj-Israel, ri Kajaf xaxe jun, y ri' ja ri Kajaf Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Can tivajo' c'a ri Dios ri Ivajaf. Tivajo' riq'uin ronojel ivánima. Tivajo' chupan ri ronojel ri ic'aslen, riq'uin ri inojibal y riq'uin chuka' ronojel ri ivuchuk'a'. Jac'are' ri pixa' ri más nim rejkalen. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Y c'o chuka' jun ruca'n pixa' ri janíla rejkalen y jubama junan riq'uin ri nabey. Y ri pixa' ri' nubij c'a: Can achi'el navajo-ka-avi' rat, can que c'a chuka' ri' que'avajo' ri ch'aka' chic. Y ja ca'i' pixa' re' ri más e nima'k ec'o, xcha' c'a ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Y ri etamanel chirij ri ley xubij c'a chire ri Jesús: Tijonel, xcha' c'a chire. Can queri' vi. Can kitzij ri xabij chi xaxe jun Dios c'o, y man jun chic. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nic'atzin chi nikajo' riq'uin ronojel kánima. Nic'atzin chi nikajo' riq'uin ri kanojibal, riq'uin ri ronojel ri kac'aslen y riq'uin chuka' ronojel ri kuchuk'a'. Y achi'el chuka' nikajo-ka-ki' roj, can que c'a chuka' ri' quekajo' ri ch'aka' chic. Vi yekaben c'a re', can más quejkalen que chuvech ri chicop ri yesuj chire ri Dios; tok can ronojel o man ronojel ta ri ti'ij niporox, xcha' c'a ri etamanel. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Y tok ri Jesús xrac'axaj chi can jebel vi xk'ax chuvech ri jun etamanel ri', ri Jesús xubij c'a chire: Rat xa man nej ta chic c'a atc'o-vi richin chi yatoc pa rajavaren o pa ruk'a' ri Dios, xcha' chire. Y jari' c'a tok man jun chic xbanon covil richin c'o ta xuc'utuj chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Y ri Jesús richin yerutijoj c'a ri vinek ri quimolon-qui' riq'uin, chiri' pa rachoch ri Dios, xubij c'a chique: ¿Achique c'a roma tok ri etamanela' chirij ri ley niquibij chi ri Crísto xa choj jun riy-rumam can ri rey David? ");
INSERT INTO cakCNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tok xa can ja ri rey David xbin ri xk'alajirisex chire roma ri Lok'olej Espíritu. Ri David can xubij-vi c'a: Ri Ajaf Dios xubij chire ri Vajaf ri Crísto: Catz'uye-pe re pa vajquik'a', y xquenya' pan ak'a' ri ye'etzelan avichin. Queri' xubij. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Y vi ri rey David tok xc'ase' chuvech re ruvach'ulef can xubij Vajaf chire ri Crísto, ¿achique c'a roma tok ri etamanela' chirij ri ley niquibij chi ri Cristo xa choj jun riy-rumam can ri rey David? xcha' ri Jesús. Y janíla c'a e q'uiy chique ri vinek ri can riq'uin vi ronojel cánima xcac'axaj ri xubij. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Y ri Jesús xubij c'a chuka' chique ri vinek tok yerutijoj: Man c'a tiben achi'el niquiben ri achi'a' e etamanela' chirij ri ley. Roma rije' yalan nika' chiquivech niquicusaj tukutek tak tziek, richin queri' titz'et chi janíla quik'ij. Janíla chuka' nika' chiquivech chi yek'ejelox can (yek'ijalox can) ri pa bey ri acuchi nequimolo-vi-qui' ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Y ri pa tak nima-jay ri can nitzijox-vi ri ruch'abel ri Dios, can jac'a ri nabey tak ch'aquet yequicanola', richin queri' tibix chi janíla quik'ij. Y can que chuka' ri' yequibanala' ri pa nima'k tak va'in. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Y re achi'a' c'a chuka' re' yequelesala' ronojel qui-cosas ri malcani'a' tak ixoki'. Y xe richin quenimex chi rije' e utz tak vinek, yeyaloj tok niquibanala' oración chire ri Dios. Pero rije' can xtika-vi más ruc'ayeval pa quivi', roma ri quimac janíla q'uiy, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Y ri Jesús tz'uyul c'a ri chiri' chuvech apo ri acuchi niyalox-vi can ri mero chiri' pa rachoch ri Dios. Jari' c'a tok rija' yerutzu' ri vinek tok niquiyala' can mero chiri'. Xerutz'et c'a e q'uiy beyoma' ri janíla q'uiy mero niquiyala' can. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pero xapon c'a chuka' jun ixok malca'n ri can nik'alajin chi man beyon ta. Rija' xuya' c'a can ca'i' tak mero ri man rubanon ta ni jun centavo. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Y tok ri Jesús xutz'et ri ixok ri', xuc'ut c'a chiquivech ri rutijoxela' y xubij chique: Can kitzij c'a ninbij chive chi yin nintz'et chi xa ja la ti ixok la' ri xyo'on can más q'uiy, que chiquivech conojel ri e yoyon can mero richin re pa rachoch ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Roma rija', stape' man q'uiy ta oc xuya' can, rija' xuya' c'a ronojel ri c'o riq'uin. Jac'a la ch'aka' chic, stape' janíla q'uiy mero xquiyala' can, xa juba' oc chire ronojel beyomel ri c'o quiq'uin, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Y tok ri Jesús nel c'a pe ri pa rachoch ri Dios, jun chique ri rutijoxela' xubij c'a chire ri Jesús: Tijonel, xcha' chire. Tatzu' re rubanic re rachoch ri Dios, y re abej re e ucusan chire, xcha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Y ri Jesús xubij chire ri rutijoxel: Rat can ye'atzu' c'a chi re jay re' yalan e jebel y e nima'k, pero xtapon c'a jun k'ij tok xa can xquevulex y man xquepa'e' ta chic can. Ronojel re nimalej tak abej re e ucusan chique re jay re', xa can xquec'akalox c'a pe. Can man jun c'a abej ri xtic'oje' ta can achi'el la rubanon vacami. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Y tok ri Jesús tz'uyul chic c'a pa ruvi' ri juyu' rubini'an Olivos, ri acuchi jebel niquitzu-pe ri rachoch ri Dios, jac'ari' tok e caji' chique ri tijoxela': Ri Pedro, ri Jacobo, ri Juan y ri Andrés xejel c'a apo riq'uin ri Jesús y xquic'utuj c'a chire: ");
INSERT INTO cakCNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Tabij c'a chike: ¿Jampe' c'a xtic'ulvachitej ri xabij yan ka chirij ri rachoch ri Dios? ¿Y achique retal richin queri' ninabex chi nibanatej yan? xecha' rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Y xpe ri Jesús que c'a re' ri xuchop rubixic chique: Can jebel c'a tichajij-ivi' richin man yixk'olotej. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Roma xa can e q'uiy vi c'a ri xquebec'ulun-pe y xtiquibila' c'a: Ja yin ri Cristo, xquecha' c'a. Y e janíla e q'uiy ri xquek'olotej pa quik'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Y tok xtivac'axala' c'a chi ec'o ruvach'ulef ri najin oyoval chiquicojol, y xtivac'axala' chuka' chi que cha ri' xquebanatej, chi c'o cha oyoval ri xquepe, man tisach ic'u'x, roma ronojel ri' xa can c'o c'a chi yebanatej na. Pero man ja ta c'a ri' ri ruq'uisibel tak k'ij richin re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jun tinamit xtiyacatej c'a el richin nerubana' oyoval riq'uin jun chic tinamit. Ec'o c'a chuka' e nima'k tak ruvach'ulef xqueyacatej-el richin chi nequibana' oyoval quiq'uin ch'aka' chic nima'k tak ruvach'ulef. Xquepe silonel (cab-raken) q'uiy lugar. Xquepe chuka' vayjal, y q'uiy c'a chuka' quivech oyoval xquepe chiquicojolil ri vinek ri pa tak ruvach'ulef. Y re' xa c'ari' ri nabey tak k'axomal y xquepe chic c'a ch'aka' chic quivech tijoj-pokonal. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pero rix can tichajij c'a ka ivi' jebel. Roma xa can ec'o c'a ri xquejachon ivichin pa quik'a' ri achi'a' ri pa comon yek'aton tzij. Y chuka' xquixch'ay ri pa tak nima-jay ri can nitzijox-vi ri ruch'abel ri Dios. Xquixuc'uex c'a chiquivech k'atoy tak tzij; chiquivech reyes y ch'aka' chic k'atoy tak tzij. Y xa voma c'a yin xtic'ulvachij queri', pero xa can xquixtiquir c'a xquinik'alajirisaj chiquivech rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Can ja vi c'a ri utzilej ch'abel richin colotajic ri nic'atzin chi nitzijox pa ronojel ruvach'ulef nabey, c'ari' xtoka' ri ruq'uisibel k'ij richin re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jac'a tok xquixuc'uex richin chi yixbejach pa quik'a' ri k'atoy tak tzij, man tich'ob janíla ri achique chi ch'abel ri xte'ibij. Rix xaxe c'a tibij ri achique chi ch'abel ri xtuya' ri Dios chive, roma xa can man ja ta chic rix ri xquixch'on chupan ri hora ri', xa can ja chic ri Lok'olej Espíritu ri xtich'on. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Roma xtibanatej chuka' chi vi ec'o e ca'i' achi'a' cach'alal qui', jun chique rije' xtiyacatej y xtujech ri rach'alal pa camic. Chuka' can ec'o-vi tata'aj ri xqueyacatej chiquij ri calc'ual. Ri alc'ualaxela' xqueyacatej chuka' chiquij ri quite-quitata' y xquequiya' pa camic. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Xa can xquixetzelex-vi c'a coma conojel, roma icukuban ic'u'x viq'uin yin. Pero ri can man c'a xtutzolij ta ri' chirij y xtucoch' c'a ri pa ruq'uisibel chire ronojel, can xticolotej-vi c'a ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Y chuka' can xtapon-vi c'a ri k'ij tok xquebanatej ri xajan tak banobel chupan ri lugar ri xa man ruc'amon ta. Y riq'uin ri' xtivulatej c'a can ri lugar ri'. Jari' ri tz'ibatel can roma ri Daniel, ri jun chique ri achi'a' ri xek'alajirisan ri xbix chique roma ri Dios, ojer can. Ri nitz'eton c'a ri tz'ibatel can, tik'ax c'a chuvech ri nutz'et. Richin queri' tok xtitz'et chi can ja chic ri' ri nibanatej, ri vinek ri ec'o pa Judea xa can que'anmej c'a el y tequevaj-qui' ri pa tak juyu'. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ri xa nuxlan c'a pa ruq'uisibel vik (vek) chire ri rachoch tok napon ronojel ri vululen ri', choj queri' tanmej-el. Man toc chic apo pa rachoch richin chi c'o na ri neruc'ama-pe. Man tuben queri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ri nisamej c'a pa juyu', man tibe chic na pa rachoch chuc'amic ruk'u'. Xa choj chuka' queri' tanmej-el. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jac'a ri ixoki' ri coyoben chic alanen, y ri ixoki' ri xa c'a niquiya' quitz'un tak cal, tok'ex c'a quivech tok xtapon ri k'ij ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Roma c'a ri' xa tic'utuj chire ri Dios chi ri vululen ri' man ta nibanatej chupan ri tiempo richin tef, richin chi man c'ayef ta nuben chive richin chi yixanmej. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Roma tok xtapon c'a ri k'ij ri', can xtic'o ruvi' tijoj-pokonal ri xtipe. Jun tijoj-pokonal ri man jun bey c'ulvachitajinek ta pa ruvi' re ruvach'ulef jampe' ri banon can roma ri Dios. Y chuka' ri tijoj-pokonal ri' man jun bey chic c'a xtic'ulvachitej. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Y vi ta ri Ajaf Dios man ta nuch'utinirisaj ri k'ij ri richin ri tijoj-pokonal ri', conojel ta yequen (yecom). Pero roma ri rutzil rija' pa quivi' ri e rucha'on chic, can xtuch'utinirisaj ri k'ij ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chupan ri k'ij ri', vi ec'o c'a ri yebin chive: Titzu', jac'a Cristo re'. O vi niquibij chive: Titzu', jac'a Cristo la'. Pero rix man c'a quixk'olotej pa quik'a'; man tinimaj ri niquibij chive. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Roma can ec'o c'a ri xquebec'ulun-pe y xtiquibila' c'a: Ja yin ri Cristo. Pero rix man c'a que'inimaj, roma xa quiyon k'olonela'. Y jac'a chuka' tiempo ri' tok xquebec'ulun-pe ri xquebin: Yin nink'alajirisaj ri nubij ri Dios chuve, xquecha'. Pero rix man c'a que'inimaj, roma xa e k'olonela' chuka'. Y xquequibanala' c'a milagros ri man jun bey e tz'eton ta, xaxe richin quenimex y ec'o ri yequik'ol. Y vi ta xa can yetiquir, rije' yequik'ol ta chuka' ri e cha'on chic roma ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero rix can tichajij c'a ivi', richin chi man yixk'olotej, roma xa can ja yan c'a re' xinbij can chive ronojel ri xquebanatej. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Chupan ri k'ij tok k'axinek chic ri tijoj-pokonal ri', xtibanatej c'a chi ri k'ij xtik'ekumatej y ri ic' chuka' man xtisakirisan ta chic. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ri ch'umila' xquetzak c'a el ri acuchi ec'o-vi. Can ronojel vi c'a ri nimalej tak uchuk'a' ri ec'o chicaj xquesilon roma ri ruchuk'a' ri Dios. Can chi jun vi c'a ri caj xtisilon. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Y jac'ari' tok xquinquitz'et yin ri xinalex chi'icojol, chi yika-pe pa sutz', riq'uin chic nimalej uchuk'a' y c'o chuka' chic nuk'ij-nuc'ojlen. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Y jac'ari' tok yin xquentek ri nu-ángeles chiquimolic ri e nucha'on chic. Can xquequimol-vi c'a pe re quere' pa relebel-k'ij y re quere' pa kajibel-k'ij, re quere' pa jotol y re quere' chuka' pa xulan. Can xquequimol-vi c'a pe chi jun ruvach'ulef; nitiquir-pe pa jun rutza'n re caj, c'a la jun chic rutza'n. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Can tic'ama' c'a ina'oj riq'uin ri víquix (higo). Tok can yeraxer c'a pe ri ruk'a' y niquichop-pe quelic ri ruxak, etaman c'a ri' chi ri ru-tiempo ri job noka' yan. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Y que c'a ri' tok xtitz'et chi ec'o chic yec'ulvachitej chupan ri k'ij, ri ic' y ri ch'umila', y ronojel ri xinbij yan ka nibanatej chic, tivetamaj c'a ri' chi noka' yan ri k'ij. Xa can nakaj chic c'a c'o-vi-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Y tivac'axaj c'a jebel re xtinbij chive re vacami: Ronojel re' xtic'ulvachitej, tok ri vinek richin re tiempo re' c'a man jani queq'uis-el chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Y re ruvach'ulef y ri caj can e richin vi yeq'uis. Jac'a ri nuch'abel man xtiq'uis ta queri', xa can xtibanatej-vi ri nubij. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jac'a ri k'ij y ri hora tok yin xquipe, man jani k'alaj ta. Ri ángeles ri ec'o chila' chicaj man quetaman ta jampe'. Que chuka' ri' yin ri C'ajolaxel man vetaman ta. Xa can xe c'a ri Nata' Dios ri etamayon ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Rix xa can tichajij c'a apo jebel ri ic'aslen. Can tivoyobej c'a, y tibana' chuka' orar, roma xa man ivetaman ta jampe' xtapon ri ruk'ijul ri nupetebel. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Achi'el tok jun achin nuya' can ri rachoch y nibe nej, c'a juc'an chic tinamit. Rija' nuchilabela' c'a can ri rusamaj chique ri rusamajela'. Can nuyala' c'a can quisamaj chiquijujunal; y chire ri chajinel can nubij c'a can chi jantape' troyobej-apo. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Can que c'a ri' tibana' rix, can jantape' quinivoyobej-apo. Achi'el ri achin chajinel, roma ri man retaman ta jampe' xtoka' ri rajaf-jay, rija' c'o chi noyoben-apo. Roma ri rajaf-jay riq'uin juba' noka' tok noc-pe ri ak'a', o ja ri pa nic'aj-ak'a', tok yesiq'uin-pe ri ec' nimak'a' yan, o ja tok nipe yan rusekeric. Romari' rix can jantape' c'a quinivoyobej-apo. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Roma yin can ninvajo' chi yinivoyobej ta apo, roma can man xtinya' ta na rutzijol tok xquipe. ");
INSERT INTO cakCNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Y can achi'el ri ninbij chive rix chi quinivoyobej-apo, can que chuka' ri' ninbij chique conojel, xcha' ri Jesús chique ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xa ca'i' chic c'a k'ij nrajo' richin chi napon ri ca'i' quinimak'ij ri israelitas. Ri jun quinimak'ij ri israelitas rubini'an pascua. Y ri jun chic ja tok niquitej ri caxlan-vey ri manek ch'en (ch'amilej-k'or) riq'uin. Y jari' c'a tok ri principal-i' tak sacerdotes y ri etamanela' chirij ri ley niquich'obola' achique ta k'oloj yequicusaj richin chi nika' ri Jesús pa quik'a' y c'ari' niquicamisaj. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Y niquibila' c'a chiquivech: Man tikachop chupan re nimak'ij re', richin chi man queyacatej-pe ri vinek chikij, xecha' c'a rije'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Y ri Jesús c'o chic c'a ri pa tinamit rubini'an Betania, chiri' pa rachoch ri Simón ri xc'achojirisex chire ri yabil rubini'an lepra. Ri Jesús tz'uyul c'a ri pa mesa niva', y jac'ari' tok c'o jun ixok xoc-apo y ruc'uan-apo jun c'ojlibel ri banon riq'uin jun abej rubini'an alabastro y c'o-el nardo chupan; jun jubulej ak'on ri janíla jotol rajel. Y tok ri ixok ri' xrelesaj-el ri ti rukul ri c'ojlibel, xuk'ej c'a ri jubulej ak'on pa rujolon (ruvi') ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Y ec'o c'a ri xpe coyoval tok xquitz'et chi queri' xuben ri ixok riq'uin ri jubulej ak'on y xquibila' c'a: ¿Achique roma la ixok la' xuben chi choj queri' xutix la jubulej ak'on la'? ");
INSERT INTO cakCNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Roma xa xbe ta chi más oxi' ciento quetzales, y ri mero ri' xtalux ta chiquivech ri vinek ri man jun c'o quiquin, xecha'. Y q'uiy c'a ri niquibij-apo chire ri ixok. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero ri Jesús xubij c'a chique: ¿Achique c'a roma tok man yixtane' ta ka chi tzij chirij? Xa tiya' can. Rija' jun utzilej banobel c'a ri xuben viq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ri vinek ri man jun c'o quiq'uin xa can jantape' c'a ec'o iviq'uin, y xabachique k'ij nivajo' ye'ito', can tibana' c'a utzil chique. Jac'a yin man jantape' ta xquic'oje' iviq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Rija' xuben c'a ri achique nitiquir nuben viq'uin. Can xuc'ut c'a ri ajovabel ri c'o riq'uin. Rija' xa can xuben yan c'a vutzil richin tok xquibemuk can. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Y tivac'axaj na pe' jebel re xtinbij chive, chi xabachique lugar c'a xtitzijox-vi ri utzilej ch'abel richin colotajic, chiri' chuka' xtitzijox-vi re xuben re jun ixok re'. Can ronojel c'a ruvach'ulef xtitzijox-vi, y man jun bey c'a xtimestex, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Y jun c'a chique ri e cablajuj rutijoxela' ri Jesús, ri rubini'an Judas Iscariote, xapon c'a quiq'uin ri principal-i' tak sacerdotes, richin chi xusuj-ri' vi nicajo' chi nujech ri Jesús pa quik'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Y tok rije' xcac'axaj queri', janíla xequicot. Y xquisuj ru-mero romari'. Y rija' xuchop c'a ruch'obic richin achique ta rubanic nuben richin nujech ri Jesús pa quik'a' ri achi'a' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Xapon c'a ri nabey k'ij richin ri nimak'ij tok nitij ri caxlan-vey ri manek ch'en (ch'amilej-k'or) riq'uin. Jac'a chuka' k'ij ri' tok yecamisex ri tak carne'l ri richin ri pascua. Jari' tok ri tijoxela' xquic'utuj chire ri Jesús: ¿Acuchi c'a navajo-vi chi naben-vi ri va'in chupan re jun pascua re', richin yojbe chubanic rutzil ronojel ri nic'atzin? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Y ri Jesús can xerutek-vi-el e ca'i' chique ri rutijoxela', y xubij-el chique: Quixbiyin pa tinamit Jerusalem, y chiri' xtitz'et c'a chi c'o jun achin aj-ic' ri ruc'amon-pe ruya' pa jun cucu' (k'e'l). Jac'a rija' ri xtoc-el uc'uey ibey. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ri jay ri xtoc-vi rija', chiri' c'a chuka' quixoc-vi rix y quixch'on c'a riq'uin ri rajaf-jay y tibij chire: Ri Katijonel rubin c'a pe: ¿Achique jay re vave' pan avachoch ri utz ta richin ninben ri va'in richin re pascua e vachibilan ri nutijoxela'? quixcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Y ri rajaf-jay xquixruc'uaj c'a pa jun ruca'n vik jay (cavek jay). Y chiri' c'o jun nima-jay ri chojmirisan chic rupan. Ja ri chiri' tibana-vi rutzil ri xtikatej richin re pascua, xe'uche'ex-el. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Y ri ca'i' rutijoxela' xebe c'a pa tinamit Jerusalem. Y tok xe'apon, can xbanatej na vi achi'el ri rubin-el ri Jesús chique. Y rije' can xquiben-vi c'a rutzil ronojel ri nic'atzin richin ri va'in richin ri pascua ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jac'a tok xk'ekumer-pe chupan ri k'ij ri', jari' tok ri Jesús e rachibilan ri cablajuj rutijoxela' xe'apon ri chiri' pa jay. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Y tok rije' e tz'uyul chic c'a apo ri pa mesa, y ye'ajin chic chi va'in, jari' tok ri Jesús xubij chique ri rutijoxela': Can kitzij c'a ninbij chive, chi c'o jun chive rix ri xtic'ayin-el vichin. Jun ri can niva' viq'uin, jari' xquijachon-el pa quik'a' ri vinek, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Rije' can jari' xpe bis pa cánima. Y niquic'utula' c'a apo chire ri Jesús: ¿Man ja ta cami yin ri xquibanon queri'? xecha' c'a chiquijujunal. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Y ri Jesús jac'ari' xubij chique: Ri' ja ri jun chive rix cablajuj, ri xtimuban-pe ruvay viq'uin chupan re lek. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Can tivac'axaj c'a ri xtinbij chive, chi yin ri xinalex chi'icojol can xquibe-vi c'a ri' tok xquijach-el. Can xtibanatej achi'el ri tz'ibatel can. Pero tok'ex c'a ruvech ri xtijachon-el vichin yin ri xinalex chi'icojol. Ri achin ri xtijachon-el vichin utz ta chi man ta xalex, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Y tok can c'a ye'ajin na c'a chi va'in, ri Jesús xuq'uen c'a apo jun caxlan-vey y xumatioxij chire ri Dios. C'ari' xuper (xupir) ri caxlan-vey ri' y xuya' chique ri rutijoxela'. Rija' xubij c'a chique ri rutijoxela' ri': Tic'ama' c'a can re caxlan-vey re'. Roma jare' ri nuch'acul ri xtapon pa camic. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Y ri Jesús xuq'uen c'a chuka' apo ri vaso ri c'o ruya'al-uva chupan; y tok rumatioxin chic chire ri Dios, xuya' chique, y conojel c'a xquikun ri ruya'al-uva. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Y rija' xubij c'a chique ri rutijoxela': Jac'are' ri nuquiq'uel ri xtibiyin tok xquiquen (xquicom). Riq'uin c'a re nuquiq'uel, can jac'ari' xc'achoj ri c'ac'a' trato ri rajovan-pe ri Dios chi nuben quiq'uin ri vinek. Ri nuquiq'uel ri xtibiyin, richin c'a chi e q'uiy vinek yecolotej. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tivac'axaj c'a re xtinbij chive: Ja ruq'uisibel c'a bey re' xinkun-el ruya'al-uva. Y tok xtinkun chic jun bey, ja chic c'a chupan ri utzilej ruk'atbel-tzij ri Dios. Y ri ruya'al-uva ri xtinkun ri chiri', jun c'ac'a' ruya'al-uva, xcha' ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Y tok quibixan chic c'a ri bix richin niquiya' ruk'ij ri Dios, ri Jesús y ri rutijoxela' xe'el-el ri chiri' pa jay y xebe ri pa juyu' Olivos. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Y tok e benek c'a, ri Jesús xubij chique ri rutijoxela': Chi'ivonojel rix xtitaluj-el-ivi' y xquiniya' c'a can nuyon chupan re ak'a' re', tok xa xtitz'et chi yin yijach-el pa quik'a' ri vinek. Roma ri Dios can nubij-vi c'a chupan ri tz'ibatel can: Tok yin xtinya' k'ij chi nicamisex ri aj-yuk', ri carne'l xa xtiquitaluj-el-qui'. Queri' ri tz'ibatel can. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero yin ri Aj-Yuk' man c'a xquiquen ta el (xquicom ta el) richin jantape', xa xquic'astej-pe. Y ja yin ri xquinoyoben ivichin ri chila' pa Galilea, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Y ri Pedro xubij c'a: Vi ri ch'aka' chic yatquiya' can ayon, yin man xtinben ta queri', xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jac'a ri Jesús xubij chire ri Pedro: Yin can kitzij c'a ninbij chave, chi vacami chupan re jun ak'a' re', xa c'a man jani tisiq'uin-pe ri mama' ca'i' bey, tok rat oxi' yan bey tabij chique ri yec'utun chave, chi man avetaman ta nuvech, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero man riq'uin ri xubij ri Jesús queri', ri Pedro xa xubij chic c'a apo chire ri Jesús: Vi yin can c'atzinel yiquen (yicom) junan aviq'uin rat, can que c'ari' ri', pero man jun bey xtinbij chi man vetaman ta avech. Y chuka' ri ch'aka' chic tijoxela' can que c'a ri' niquibij. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ri Jesús y ri rutijoxela' xe'apon c'a chupan ri lugar rubini'an Getsemaní. Xpe ri Jesús xubij c'a chique ri rutijoxela': Quixtz'uye' na c'a can juba' vave', y yin tenbana' na orar. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Y xaxe c'a ri Pedro, ri Jacobo y ri Juan ri xeruc'uaj riq'uin. Jac'ari' tok rija' janíla xuna' yan ri xteruc'ulvachij. Can jun bis c'a janíla nim ri xpe pa ránima. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Y xubij c'a chique ri e oxi' rutijoxela': Ri bis c'o pa vánima, janíla nim. Y yirucamisaj ninna' yin. Quixc'oje' c'a can vave', quixc'ase' y man quixver-ka, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Rija' xbiyin chic c'a apo juba' y c'ari' xxuque-ka y xukasaj-ka-ri' c'a pan ulef y xuben c'a orar. Rija' xuc'utuj c'a chi vi can tiquirel, choj ta nik'ax-el ri hora ri', chi man ta nuc'ovisaj ri tijoj-pokonal. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Y que c'a re' ri ch'abel ri xerubij ri pa ru-oración: Nata', Nata', yin vetaman chi rat yatiquir naben ronojel. Tabana' c'a chi man ta ninc'ovisaj yin re jun tijoj-pokonal re'. Pero man taben c'a chuka' ri ninrayij yin, xaxe voma ta yin. Roma yin xa can ninvajo' c'a chuka' ninben ri arayibel rat, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Y tok rija' xc'achoj chire ri oración, xpe c'a quiq'uin ri e oxi' rutijoxela', pero tok xoka' quiq'uin xa yever. Xpe rija' xubij c'a chire ri Pedro: Simón, ¿xa xaver-ka? ¿Can man juba' xatiquir xac'ase' jun ti hora viq'uin? ");
INSERT INTO cakCNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Man c'a quixver-ka, xa tibana' orar y tic'utuj chire ri Dios richin chi tok yixtejtobex, man quixtzak pa mac. Can vetaman-vi chi ri rurayibel ri ivánima ja ri niben ri nrajo' ri Dios. Pero iyon xa can man yixtiquir ta c'a, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Y ri Jesús xbe chic c'a apo jun bey richin xberubana' orar. Rija' xucamuluj chic c'a rubixic ri ch'abel ri xerubij chupan ri oración c'a juba' tuben-ka. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Y tok xtzolin chic c'a jun bey quiq'uin ri e oxi' rutijoxela', xa yever chic c'a jun bey ri xeril, roma rije' xa al-al c'a runak' tak quivech roma ri quivaran. Y rije' man niquil ta c'a achique niquibij, roma xe'ilitej chic jun bey chi quichapon varan. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Y ri Jesús xbe chic c'a chubanic orar. Pero tok xtzolin-pe ri pa rox bey, rija' xubij c'a chique ri e oxi' rutijoxela': ¿Can c'a yixver na? ¿Nivajo' nitz'akatisaj ri ivaran? Pero man chic tiquirel ta. Yin ri xinalex chi'icojol can ja vi c'a re' xoka' ri nu-hora, can xquijach c'a el pa quik'a' ri itzel tak achi'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Chanin, quixyacatej. Jala' petenek ri xquijachon-el pa quik'a' ri itzel tak achi'a', xcha' ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Y ri Jesús can c'a nich'on na c'a quiq'uin ri rutijoxela', tok ja yan ri' xoka' ri Judas ri jun chique ri cablajuj rutijoxela', y e ruc'uan c'a apo e q'uiy vinek ri e quic'ualon che' y machet. Conojel re' e takon c'a el coma ri principal-i' tak sacerdotes, coma ri etamanela' chirij ri ley y coma chuka' ri rijita'k tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ri Judas ri nijachon-el richin ri Jesús can rubin c'a pe chique ri e petenek riq'uin, achique rubanic xtuben richin nuc'ut ri Jesús chiquivech. Rija' rubin c'a pe chique: Jac'a ri xquijel-apo riq'uin richin xtintz'ubaj (xtintz'umaj), jari' ri Jesús. Tichapa', y man tanmej can chivech. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Y tok ri Judas xapon c'a, can jari' choj xbe-apo riq'uin ri Jesús y xubij chire: Nutijonel, Nutijonel, xcha' chire y c'ari' c'a xutz'ubaj (xutz'umaj). ");
INSERT INTO cakCNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Y ri vinek ri e benek c'a chapoy richin ri Jesús can jac'ari' xquichop. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Y jun c'a chique ri ec'o riq'uin ri Jesús chiri', xrelesaj ri rumachet, xuya' chire ri jun rusamajel ri nimalej sacerdote, y ja ri ruxiquin ri xuchoy riq'uin ri jun machet ri xuya' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Y c'ari' xpe ri Jesús xubij chique ri vinek ri e benek chapoy richin: ¿Achique c'a xich'ob rix? ¿Xich'ob chi yixpe chuchapic jun elek'on y romari' ic'amon-pe che' y machet? ");
INSERT INTO cakCNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yin can k'ij-k'ij c'a xic'oje' iviq'uin ri chiri' pa rachoch ri Dios, tok xinc'ut ri ruch'abel chivech y man jun bey xinichop ta. Roma can quere' c'o na chi nibanatej, can achi'el ri tz'ibatel can chupan ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Y can ja vi c'a ri' tok ri e rutijoxela' ri Jesús, xquiya' can ruyon y xe'anmej. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero c'o c'a jun ala' ri can tzeketel-el chirij ri Jesús y choj pa jun tziek nim rucuchun-vi-el-ri'. Y ri e chapayon-el richin ri Jesús, xquichop c'a ri ala' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero rija' xa xel c'a el chupan ri tziek ri', y choj queri' xanmej-el chiquivech. Manek c'a rutziak xbe. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Y ri vinek ri e chapayon-el richin ri Jesús xquic'uaj c'a el c'a pa rachoch ri nimalej sacerdote. Y chiri' chuka' xquimol-vi-qui' ri principal-i' tak sacerdotes, cachibilan ri rijita'k tak achi'a' ri c'o quik'ij y ri etamanela' chirij ri ley. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Y ri Pedro c'anej c'o-vi can, pero rojkan-el ri Jesús. Y tok ri Jesús xucusex-apo pa rachoch ri nimalej sacerdote, chuka' ri Pedro xoc-apo chiri' chuva-jay. Y xtz'uye' c'a ka chiquicojol ri samajela' ri ec'o-apo chiri', e mek'el oc chuchi-k'ak'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Y ri principal-i' tak sacerdotes, y conojel c'a ri achi'a' ri can pa comon niquik'et tzij, niquicanola' c'a chi ec'o ta ri itzel tak banobel ri ye'ilitej chirij ri Jesús, richin queri' can niquitek-vi pa camic, pero xa man jun c'a ri xquil chirij. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Roma stape' can e q'uiy ri xe'apon ri xquitz'uc tzij chirij, man xbequic'ulu' ta c'a qui' ca'i' ri can ta junan ri niquibij chirij ri Jesús, y richin queri' c'o ta ruchuk'a' ri niquibij richin nucusex chirij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Y c'ari' ec'o chic c'a ch'aka' ri xebepa'e-pe y que c'a re' ri xquibij chirij ri Jesús: ");
INSERT INTO cakCNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Roj can kac'axan c'a tok rija' rubin: Yin xtinvulaj re rachoch ri Dios banon coma achi'a', y pan oxi' k'ij xtinben chic jun ri man achi'a' ta xquebanon. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Man riq'uin ri', man junan ta chuka' ri xquibila'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Y ri Caifás, ri nimalej sacerdote, xbepa'e' c'a pe ri pa quinic'ajal y xuc'utuj chire ri Jesús: ¿Kitzij cami ri xquibij-ka re xech'on-ka chavij? ¿Achique nabij vacami? xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero ri Jesús xa man xch'on ta c'a. Can man jun c'a ch'abel ri xubij. Romari' xpe ri nimalej sacerdote, c'o chic c'a ri xuc'utuj chire. Rija' xuc'utuj c'a chire: ¿Ja rat ri' ri Cristo ri Ruc'ajol ri Dios ri nikaya' ruk'ij? xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Y ri Jesús xubij c'a: Ja', ja yin. Y xquinitz'et chuka' chi yin ri xinalex chi'icojol chi in tz'uyul pa rajquik'a' ri Dios ri nitiquir nuben ronojel. Y xquinitz'et tok yika-pe pa sutz' ri chila' chicaj. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tok ri nimalej sacerdote xrac'axaj ri', xuretz-ka ri rutziak chirij, roma itzel xrac'axaj y xubij c'a: Man nic'atzin ta c'a chi noka' chic jun richin norubij chike chi ri Jesús can aj-mac vi. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chi'ivonojel rix xivac'axaj chi xubij chi ja rija' ri Cristo. Can itzel c'a xuben chuvech ri Dios. ¿Achique nibij vacami? xcha' rija'. Y conojel c'a xquibij chi ruc'amon chi nika' ri camic pa ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Y ec'o c'a ri xquichop niquiben q'uiy etzelal chire ri Jesús. Xquichop c'a niquichubala'. Xquitz'apej ruvech. Xquich'ey y c'ari' c'a niquic'utula' chire: ¿Achique ri xach'ayon? Tabij na c'a chike, yecha' chire. Y ri samajela' ri ec'o chiri', xquiyala' c'a k'a' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Y tok ri Pedro c'a c'o na c'a ri chiri' chuva-jay ka, c'o c'a jun ixok raj-ic' ri nimalej sacerdote ri xapon ri chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ri Pedro numek' c'a ri' chuchi-k'ak'. Y jari' tok xpe ri aj-ic' nutzu-nutzu' c'a apo ri Pedro, y c'ari' xubij chire: Rat chuka' at rachibil ri Jesús ri aj-Nazaret, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero ri Pedro xa xrevaj c'a, roma xubij: Yin man vetaman ta ruvech ri Jesús. Man nik'ax ta chuka' chinuvech achique roma tok queri' nabij chuve, xcha' chire ri aj-ic'. Y ri Pedro xel c'a el ri chiri' chiquicojol y xbe chuchi-bey. Y jac'ari' tok ri mama' xsiq'uin-pe. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Y tok ri ixok aj-ic' xutzu' chic jun bey ri Pedro, xuchop chic c'a rubixic chique ri ec'o chiri': La achin la' jun chique ri ec'o riq'uin ri Jesús, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero ri Pedro xa xrevaj chic jun bey. Y c'a juba' ri' ja yan chic ri quimolon-qui' chiri' xquibij chic jun bey chire: Can kitzij na vi chi rat at jun chique ri ec'o riq'uin ri Jesús. Roma rat pa Galilea yape-vi, y can junan rubanic ri yach'on quiq'uin, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pero ri Pedro xubij c'a: Yin man vetaman ta ruvech ri achin ri nibij rix. Can chuva Dios ninbij chive chi yin man vetaman ta ruvech. Y vi man kitzij ta ri ninbij, tika' c'a ruc'ayeval pa nuvi', xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Y ri mama' xbesiq'uin c'a pe pa ruca'n bey. Y ri Pedro jac'ari' xe'oka' chuc'u'x ri ch'abel ri e rubin can ri Jesús chire, chi can c'a man jani tisiq'uin-pe ri mama' pa ruca'n bey tok rat oxi' yan bey tabij chique ri yec'utun chave, chi man avetaman ta nuvech. Y rija' xujik' c'a ok'ej tok xel-el ri chiri', roma nuch'ob c'a quij ri ch'abel ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Y tok xseker c'a pe chupan ri k'ij ri', ri principal-i' tak sacerdotes xquimol c'a qui' e cachibilan ri rijita'k tak achi'a' ri c'o quik'ij y ri etamanela' chirij ri ley. Can conojel vi c'a ri achi'a' ri pa comon yek'aton tzij, can xquimol-vi c'a qui'. Rije' xquich'ob c'a ri achique niquiben riq'uin ri Jesús, y can ximon-vi-el tok xquic'uaj y xbequijacha' pa ruk'a' ri k'atoy-tzij rubini'an Pilato. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Y jac'ari' tok ri Pilato xuc'utuj chire ri Jesús: ¿Ja rat ri qui-Rey ri israelitas? xcha' chire. Y ri Jesús xubij c'a: Ja', queri'. Can achi'el ri xabij, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Y ri principal-i' tak sacerdotes, q'uiy c'a ri niquibila-apo chire ri Pilato, richin niquisujuj ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Xpe ri Pilato xch'on chic apo riq'uin ri Jesús y xubij c'a chire: Rije' janíla q'uiy ri niquibila-pe chavij richin yatquisujuj, y rat ¿man jun ch'abel nabij? xcha' ri Pilato chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero man riq'uin ri' ri Jesús can man jun c'a ch'abel ri xubij. Y ri Pilato can achique la xuna', roma man jun bey rutz'eton ta chi jun vinek que ta ri' nuben. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Y ronojel juna' tok napon c'a ri quinimak'ij ri israelitas, ri nimak'ij ri rubini'an pascua, ri k'atoy-tzij nucol c'a el jun preso; ri preso ri niquibij ri vinek chi utz nel-el. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Y ri k'ij ri', c'o c'a pa cárcel jun achin rubini'an Barrabás e rachibilan ch'aka' chic rachibil. Rije' e kajinek c'a pa cárcel roma xeyacatej chirij ri k'atbel-tzij y chuka' xquiben camic. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Y roma c'a ri vinek ri' can quetaman chi ri k'atoy-tzij can nucol-vi-el jun chique ri ec'o pa cárcel, romari' xepe rije' xquic'utuj c'a chire ri Pilato chi trelesaj-el jun chique ri ec'o pa cárcel. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Y ri Pilato can jac'ari' xubij-pe chique: ¿Ri irayibel rix chi yin nincol ta el re achin Rey ivichin rix israelitas? xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ri Pilato can que vi c'a ri' ri xubij-pe, roma rija' can retaman-vi chi ri principal-i' tak sacerdotes quiyo'on ri Jesús pa ruk'a', roma itzel niquina' chire chi janíla e q'uiy vinek ri ye'ojkan richin. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Y ri principal-i' tak sacerdotes xquiya' c'a quina'oj ri vinek, chi tiquibij-apo chire ri Pilato chi xa ja ri Barrabás ri tucolo-el. Y ri vinek can queri' xquiben. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Y ri Pilato can jac'ari' xbech'on chic pe jun bey y xuc'utuj c'a chique: ¿Achique c'a ri nibij rix chi yin ninben ta riq'uin re achin ri nibij chi i-Rey rix israelitas? xcha' rija' chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Y ri vinek xech'on chic c'a apo y riq'uin uchuk'a' xquibij: Tataka' rucamisaxic chuvech cruz, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Romari' ri Pilato xubij chique: ¿Achique c'a rumac rubanon chivech? Pero rije' man yetane' ta ka. Xa riq'uin más uchuk'a' xquibij-apo: ¡Tataka' rucamisaxic chuvech cruz! xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Y ri Pilato xucol c'a el ri Barrabás, richin chi ri vinek utz nuna-ka cánima; richin chi ticuker-ka quic'u'x. C'ari' xutek c'a ruch'ayic ri Jesús y xujech-el richin chi ticamisex chuvech cruz. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xepe ri soldados xquicusaj c'a apo ri Jesús chuva-jay richin ri palacio. C'ari' xecoyoj c'a conojel ri ch'aka' chic soldados, ri e cachibil. Xequimol c'a apo chirij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Y re soldados re' xquiya' c'a jun tziek morado chirij ri Jesús, can achi'el vi ri yequicusala' ri reyes. Y xquipach'uj chuka' jun k'ayis ri janíla ruq'uixal. Can achi'el jun corona xquiben chire, y c'ari' xquiya' pa rujolon (ruvi') ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Xepe chuka' ri soldados can niquiben c'a chi niquik'ejela' (niquik'ijala') ri Jesús, y niquibila' c'a chire: Caquicot c'a janíla, rat ri qui-Rey ri israelitas, yecha' c'a chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Rije' niquibojila' c'a pa rujolon (ruvi') ri Jesús riq'uin jun aj; y niquichubala' chuka'. Can yexucuyaj c'a chuvech. Can niquiben c'a chi niquiya' ruk'ij, pero xa yetze'en c'a chubanic. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Y tok rije' xetane' c'a chi tze'en chirij, xquelesaj-el ri tziek morado ri quiyo'on-ka chirij. C'ari' xquiya-el ri can rutziak vi rija', y xquic'uaj c'a el richin chi nequibajij chuvech cruz. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tok quichapon c'a el bey, xquic'ul jun achin aj-Cirene, jun achin petenek pa juyu'. Re achin re', quitata' ri achi'a' quibini'an Alejandro y Rufo. Y rija' rubini'an Simón. Y ri soldados xquiben c'a chire ri achin ri' chi xuc'uaj-el ri ru-cruz ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Y ri soldados pa ruvi' c'a ri jun juyu' rubini'an Gólgota xquic'uaj-vi ri Jesús. Ri juyu' ri nibix chuka' Calavera chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Y tok ec'o chic c'a chiri', xquisuj chire ri Jesús vino xolon riq'uin ruya'al jun che' rubini'an mirra. Pero rija' man xrajo' ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Y tok ri soldados quibajin chic c'a ri Jesús chuva ri cruz, xquiya' c'a pan etz'anen ri rutziak ri Jesús richin xquitz'et achique chi tziek ri niquic'uala-el chiquijujunal. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Las nueve c'a ri nimak'a' tok xquibajij ri Jesús chuvech cruz. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Y chutza'n c'a el ri ru-cruz, chiri' c'a tz'ibatel-vi chuvech jun tz'alen ri achique rumac ri Jesús richin nicamisex. Chuvech ri tz'alen ri' nubij c'a: Jare' ri qui-Rey ri israelitas. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Y ri soldados ec'o chuka' e ca'i' chic ri xequibajij. Ri ca'i' achi'a' ri' e elek'oma'. Jun c'a ri xpabex pa rajquik'a' ri Jesús y jun chic ri pa rajxocon (izquierda). ");
INSERT INTO cakCNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Y riq'uin ri' can nibanatej c'a achi'el ri tz'ibatel can chupan ri ruch'abel ri Dios, tok nubij: Rija' can achi'el chuka' jun aj-mac xban chire. Queri' ri tz'ibatel can. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ri vinek c'a ri yek'ax-el y ye'apon riq'uin ri Jesús, niquisilola-apo quijolon (quivi') chuvech, roma can man niquinimaj ta chi ja rija' ri Ruc'ajol ri Dios. Y c'o chuka' ch'abel ri yequibila' can chire. Ri vinek ri' niquibila' c'a can chire ri Jesús: Ja rat ri xabin chi can navulaj ri rachoch ri Dios y pan oxi' k'ij naben chic jun bey. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tacolo' na c'a avi' ayon y caka-pe chuva la a-cruz, yecha' c'a can chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Y ja chuka' ch'abel ri' ri niquibila' ri principal-i' tak sacerdotes. Rije' y ri etamanela' chirij ri ley niquitze'ej c'a ri Jesús y niquibila' c'a chiquivech: Rija' can e q'uiy vi c'a xerucol, pero rija' man nitiquir ta nucol-ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Can rubin c'a chi ja rija' ri Cristo, ri Rey richin re tinamit Israel. Vi queri', can tika' c'a pe chuva la ru-cruz, richin nikatz'et y nikanimaj, yecha'. Y ri elek'oma' ri e bajin chuvech qui-cruz cachibilan ri Jesús, c'o c'a chuka' ch'abel ri que tak ri' ri yequibila-apo chire. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Y tok xnic'ajer k'ij, jac'ari' tok xk'ekumer ri ruvach'ulef. Y ri k'eku'n ri' xq'uis c'a el ri las tres ri tikak'ij. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Y jac'a hora ri', tok ri Jesús can riq'uin c'a ruchuk'a' xch'on y xubij: Eloi, Eloi, ¿lama sabactani? xcha'. Y ri ch'abel c'a ri xerubij rija', que c'a re' ri nubij: Nu-Dios yin, nu-Dios yin, ¿achique c'a roma tok xinamalij can? ");
INSERT INTO cakCNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Y ec'o ri ec'o apo chiri' chunakaj ri Jesús, tok xcac'axaj ri xubij, xquibila' c'a: ¿Xivac'axaj? Rija' ja ri Elías ri nroyoj, xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Y jac'ari' tok c'o jun ri junanin xberumuba-pe jun achi'el bo'j ri nibix esponja chire. Xumuba' c'a chupan jun ch'amilej ruya'al-uva, xuya' chutza'n jun aj y xuya' chire ri Jesús richin nich'uch'u-ka juba' ri nichaki'j ruchi', y xubij: Tikoyobej na c'a k'alaj ri' vi nipe ri Elías chukasaxic, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Can jac'ari' tok ri Jesús riq'uin c'a ruchuk'a' xch'on y xquen (xcom). ");
INSERT INTO cakCNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Y ri tziek ri achok iq'uin ch'aron-vi ri rupan ri rachoch ri Dios xel pa ca'i'. Xuchop-pe pa jotol c'a pa xulan ka. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Chuvech apo acuchi c'o-vi ri Jesús c'o c'a ri Capitán quichin ri soldados. Rija' xrac'axaj c'a tok ri Jesús riq'uin ruchuk'a' xch'on, y jari' tok xquen (xcom). Romari' tok ri Capitán xubij c'a: Can kitzij na vi chi re achin re' Ruc'ajol ri Dios, xcha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Y ec'o chuka' ixoki' ri yetzu'un-apo, pero can c'anej ec'o-vi-el. Chiquicojol c'a ri ixoki' ri', c'o c'a ri María Magdalena, c'o ri María ri quite' ri José y ri Jacobo ri c'a ac'ual na, y c'o chuka' ri jun ixok rubini'an Salomé. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ri ixoki' ri', can c'a c'o ri Jesús pa Galilea, tok cojkan y quilin-pe. Y chuka' can ec'o c'a ch'aka' chic ixoki' ri cojkan-apo ri Jesús ri pa Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ri tikak'ij c'a tok xquen (xcom) ri Jesús, ri uxlanibel-k'ij nitiquir yan c'a. Romari' ri vinek niquibanala' chic c'a rutzil ronojel ri xtic'atzin chique chupan ri uxlanibel-k'ij. Xa xkak'ij yan c'a chupan ri k'ij ri'. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Y jac'ari' tok xapon jun achin rubini'an José; y rija' aj pa tinamit Arimatea. Rija' jun achin cachibil ri achi'a' ri yek'aton tzij chiquicojol ri quivinak; y rija' c'o c'a janíla ruk'ij chiquicojol rije'. Rija' jun achin ri can royoben c'a chuka' tok ri Dios xtoc ri K'atoy-Tzij. Y rija' xapon riq'uin ri Pilato chupan ri hora ri', chuc'utuxic ri ruch'acul ri Jesús richin numuk. Ri José can man jun chic c'a xibinri'il chuvech xbe chuc'utuxic ri ruch'acul ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pero ri Pilato man c'a nunimaj ta chi can ta chanin yan xquen (xcom) ri Jesús. Romari' rija' xroyoj ri Capitán, y xuc'utuj chire vi kitzij chi caminek chic ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Y tok ri Pilato retaman chic can riq'uin ri Capitán, c'ari' c'a xuya' k'ij chire ri José chi terumuku' can ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Y ri José xulok' c'a jun tziek nim. Y tok rukasan chic pe ri ruch'acul ri Jesús chuva ri cruz, xupis c'a chupan ri tziek ri'. Y c'ari' xberumuku' can pa jun jul richin caminek, c'oton chuvech jun juyu' ri xa can abej vi. Y richin xutz'apej can ri jul, xunim c'a can ri abej tz'apebel-ruchi' ri jul. ");
INSERT INTO cakCNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Y ri María Magdalena y ri María ri quite' ri José y ri Jacobo, xquitzu' c'a jebel acuchi xmuk-vi can ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Y tok k'axinek chic c'a ri uxlanibel-k'ij, ri María Magdalena, ri María ri quite' ri José y ri Jacobo, y chuka' ri ixok rubini'an Salomé xbequilok'ola-pe jubulej tak ak'on. Y re ak'on re' nic'atzin c'a chique richin nequiya' can chirij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Y nimak'a' yan chupan ri nabey k'ij chire ri semana, xebe c'a chuchi-jul. Y tok niseker c'a pe, jari' tok ye'apon yan. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Y rije' xquibila' c'a chiquivech: ¿Y achique c'a xtijakon ri jul chikavech? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero tok xquitz'et ri jul, xquitz'et chi xa jakel. Ri nimalej abej tz'apebel-ruchi' ri jul, xa elesan chic el. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Y tok rije' e oquinek chic c'a apo chupan ri jul, rije' xquitz'et c'a chi c'o jun achi'el ala', tz'uyul ri pa cajquik'a' apo, rucusan jun tziek sek ri napon c'a chiraken ka. Y ri ixoki' tok xquitz'et ri', xpe xibinri'il chique. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero rija' xubij chique: Man c'a tixibij-ivi'. Roma yin can vetaman chi rix nicanoj ri ruch'acul ri Jesús aj-Nazaret, ri xcamisex chuva ri cruz. Rija' xc'astej yan el, xa manek chic vave'. Titzu' la xc'oje-vi. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vacami c'a quixbiyin, y te'ibij chire ri Pedro y chique ri ch'aka' chic rutijoxela' ri Jesús. Te'ibij c'a chique chi ri Jesús xtinabeyej-el chivech, richin nic'ul-ivi' chila' pa Galilea. Y chiri' xtitz'et-vi, can achi'el ri rubin can chive. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Y ri ixoki' xe'el c'a el ri chiri' pa jul, pero can yebaybot c'a (yebarbot c'a). Ri xibinri'il ri chapayon c'a quichin can janíla nim. Rije' e anmajnek c'a el. Can man jun c'a achok che xquitzijoj-vi, roma e caminek roma quixibinri'il. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tok ri Jesús xc'astej c'a chupan ri nimak'a' chire ri domingo, ri nabey k'ij richin ri semana, nabey c'a xuc'ut-ri' chuvech ri María Magdalena; ri ixok ri achok iq'uin xerelesaj e vuku' itzel tak espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Y ri María Magdalena can jac'ari' xbe y xberubij c'a chique conojel ri xerachibilaj ri Jesús. Rije' janíla c'a yebison y quichapon ok'ej. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero tok rije' xcac'axaj c'a chi ri Jesús c'astajinek chic pe y chi ri María Magdalena xutz'et yan can ruvech, xa man xquinimaj ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Que chuka' ri' ri Jesús xuc'ut-ri' chiquivech e ca'i' achi'a' ri quichapon c'a bey richin chi yebe juc'an chic. Rije' pa jun juyu' c'a ri e benek-vi. Pero roma ri Jesús jun vi chic nitzu'un tok xuc'ut-ri' chiquivech, man chanin ta xquetamaj ruvech. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Re ca'i' achi'a' c'a re' xbequibij chuka' chique ri ch'aka' chic ri xe'ojkan richin ri Jesús, pero chuka' man xenimex ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","C'ari' ri Jesús xuc'ut-ri' chiquivech ri julajuj rutijoxela', tok quichapon va'in. Rija' xubij c'a chique: ¿Achique c'a roma tok xa can man xicukuba' ta ic'u'x y xicovirisaj ri ivánima? xcha' chique. Queri' ri xubij chique roma ri tijoxela' xa can man xequinimaj ta ri xetz'eton richin ri Jesús chi c'astajinek chic pe chiquicojol ri caminaki'. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Y xubij c'a chuka' chique: Can quixbiyin c'a chuvech re ruvach'ulef y titzijoj ri utzilej ch'abel richin colotajic chique conojel ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ri vinek c'a ri niniman ri utzilej ch'abel richin colotajic y nuben chuka' bautizar ri', xticolotej c'a. Jac'a ri vinek ri xa man niniman ta, xtika' c'a ri ruc'ayeval pa ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ri xqueniman c'a vichin, q'uiy c'a xquequibanala' richin nik'alajin chi can inc'o-vi quiq'uin. Pa nubi' c'a yin xquequelesala' itzel tak espíritu y xquech'on pa ch'aka' chic ch'abel ri man e quetamalon ta. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Rije' chuka' stape' xquequichop itzel tak cumatzi' y xquequitijla' camisanel tak ak'on, man jun xtiquiben. Xtiquiyala' chuka' quik'a' pa quivi' yava'i' y xquec'achoj. Q'uiy c'a ri xquequibanala' rije', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tok ri Ajaf Jesús ch'ovinek chic can chique ri rutijoxela', xbe; y ri chila' chicaj xc'ul roma ri Dios, y xtz'uye-apo pa rajquik'a'. ");
INSERT INTO cakCNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Y tok ri tijoxela' xe'el c'a chi nej chi nakaj, xquitzijoj ri ruch'abel ri Dios. Y ri Ajaf can c'o-vi c'a quiq'uin richin yeruto' y chuka' can xuben chique chi q'uiy milagros ri xetiquir xquibanala' richin tik'alajin chi can ja ri kitzij ri niquitzijoj. Que c'a ri'.");
INSERT INTO cakCNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","E q'uiy yan c'a quitijon chic quik'ij richin niquitz'ibaj pa rucholajen ri xa c'a ja re tiempo re' xebanatej. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Y ri rutz'ibaxic ri xquiben chire can achi'el vi ri xtzijox chike coma ri xetz'eton ri c'a pa rutiquiribel pe. Y ri xetz'eton ri xbanatej xe'oc chuka' tzijoy ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Y yin chuka' ninvajo' nintz'ibaj ri xbanatej. Can xintej c'a nuk'ij richin xinvetamaj chirij ri rutiquiribel. Y jari' ri ninvajo' nintzijoj chave. Ninvajo' chi pa rucholajen nintzijoj chave rat nimalej Teófilo, ");
INSERT INTO cakCNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","richin queri' can ja vi ri rubanic ri navetamaj chirij ri kitzij ri can at tijon-vi-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chiri' pa Judea xc'oje' c'a jun sacerdote ri xubini'aj Zacarías, y rija' xc'oje' c'a quiq'uin juk'at sacerdotes ri quibini'an chi e richin ri Abías. Pa ru-tiempo ri Zacarías jac'a ri achin Herodes ri rey chiri' pa Judea. Ri rixjayil ri Zacarías rubini'an Elisabet. Re Elisabet re' jun riy-rumam can ri nimalej sacerdote ri xubini'aj Aarón. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Re juc'ulaj vinek re' e choj chuvech ri Ajaf Dios, y niquinimaj c'a ri rutzij. Can niquiben-vi ri nubij. Y man jun vinek nitiquir nibin c'a achique ta tzij chiquij, roma can e choj vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Re juc'ulaj vinek re' man jun c'a calc'ual, roma ri Elisabet man alanel ta. Y che ca'i' c'o chic juba' quijuna' chuka'. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ri k'ij c'a tok ja ri Zacarías y ri e rachibil ri ec'o chi yebanon ri jalajoj ruvech samaj chiri' pa rachoch ri Dios, que c'a re' xbanatej. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chiquijujunal ri sacerdotes ri' can jalajoj c'a ruvech samaj ri c'o chi niquiben, y ri k'ij ri' pa ruvi' ri Zacarías xka-vi richin chi ja rija' ri c'o chi noc-apo pa rachoch ri Dios richin chi nuporoj ri pon. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Y tok najin c'a chuporoxic ri pon, conojel c'a ri vinek ri niquimol-apo-qui' chuva-jay, niquiben orar. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jac'a tok c'o ri Zacarías chiri' richin nuporoj ri pon, jari' tok xuc'ut-ri' jun ángel chuvech, jun ángel richin ri Ajaf Dios. Y re ángel re' xpa'e' chunakaj ri altar ri niporox-vi ri pon. Pa rajquik'a' ri altar xpa'e-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tok ri Zacarías xutz'et re ángel re', xsach ruc'u'x y xpe xibinri'il chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero ri ángel xubij chire ri Zacarías: Man taxibij-avi'. Ri Dios xrac'axaj ri a-oración. Ri Elisabet ri avixjayil xtic'oje' c'a jun ral, y re ac'ual re', Juan ri rubi' ri xtaya'. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Re ac'ual c'a re' xtuq'uen-pe janíla quicoten chave rat, y xtuq'uen chuka' pe quicoten chique janíla e q'uiy vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Roma re avalc'ual re' xtoc nimalej samajel chuvech ri Dios. Man xtukun ta vino, ni ch'aka' chic quivech ya' ri yek'abarisan, roma can pa ralaxic pe ri nojinek ránima riq'uin ri Lok'olej Espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Y xtuben c'a chique e q'uiy avinak israelitas richin niquinimaj ri Ajaf Dios y nijalatej ri quic'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jac'a ri Juan ri avalc'ual ri xtichojmirisan acuchi noka-vi ri Ajaf. Rija' can xtic'oje' c'a ri Lok'olej Espíritu y ri uchuk'a' riq'uin, can achi'el tok xc'oje' riq'uin ri Elías, ri jun ri xk'alajirisan ri ruch'abel ri Dios ojer can. Chuka' ri Juan xtuben c'a chique ri te'ej-tata'aj richin yecajo' ri calc'ual, y xtuben chuka' chique ri vinek man yeniman ta tzij, chi niquic'uaj jun choj c'aslen achi'el ri quic'uan ri vinek choj quic'aslen. Queri' ruchojmirisaxic xtuben-apo chique ri vinek, richin queri' re vinek re' xa can xe chic coyoben ri Ajaf, xcha' ri ángel chire ri Zacarías. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Y ri Zacarías xuc'utuj chire ri ángel: ¿Achi'el c'a tok xtinvetamaj yin chi can kitzij ri nabij? Roma yin y ri vixjayil xa oj rijita'k chic, y man yec'oje' ta chic kalc'ual, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Y jari' tok ri ángel xubij chire: Ja yin ri nubini'an Gabriel, y ri Dios yirutek richin ninben ri nrajo'. Roma c'a ri' xirutek-pe vacami richin nonbij can chave ri nuq'uen-pe quicoten, chi xtic'oje' ri avalc'ual. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Y roma c'a ri man xanimaj ta ri xinbij chave, xcamemur c'a can, man c'a xcach'on ta, c'a tok xtalex na ri avalc'ual, c'ari' xcach'on chic jun bey. Ronojel c'a re' can xtibanatej na vi, pero tok xtapon ri k'ij, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tok ri Zacarías nitzijon c'a ri ángel riq'uin, ri vinek ri e oyobeyon richin chuva-jay el, niquibila' c'a: ¿Achique roma tok xa man jun bey nel-pe chupan ri lok'olej rachoch ri Dios? ");
INSERT INTO cakCNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Y tok ri Zacarías xbe'el-pe, man nitiquir ta nich'on chique, roma ri memurinek. Roma c'a ri', ri e oyobeyon richin, xquinabej chi c'o ri xk'alajirisex-pe chuvech ri chiri' chupan ri lok'olej jay. Ri Zacarías xaxe riq'uin ruk'a' nich'on-vi chique, roma xa xmemur c'a can. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Y tok rija' e rutz'akatisan chic can ri k'ij richin samaj chiri' pa rachoch ri Dios, xbe chirachoch. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Xa c'a ca'i-oxi' c'a k'ij tic'o can ri xc'ulvachitej chiri' pa rachoch ri Dios, tok ri Elisabet ri rixjayil ri Zacarías, xunabej chi yava' chic, y romari' man xel ta pa bey vo'o' ic'. Ri Elisabet nubij c'a: ");
INSERT INTO cakCNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Vacami ri Vajaf Dios nuya' c'a re ac'ual re' chuve, richin chi yin man chic quiq'uix chiquivech ri vinek ri niquikasaj nuk'ij roma man jun val. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Jac'a tok ri Elisabet ruchapon chic vaki' ic' yava' pe, jari' tok ri Dios xutek ri ángel Gabriel pa jun tinamit rubini'an Nazaret, jun tinamit ri c'o pa Galilea. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ri ángel Gabriel xtak riq'uin jun xten rubini'an María. Re xten c'a re', c'utun chic richin c'ulubic roma jun ala' rubini'an José. Y re José re' riy-rumam can ri rey David. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ri ángel can xapon na vi riq'uin ri xten, y xubij chire: ¡Tiquicot c'a ri avánima, roma yalan xaka' chuvech ri Dios! Ri Ajaf can c'o aviq'uin. Y chique conojel ri ixoki' ja rat ri más urtisanic xac'ul. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Y tok ri María xutz'et ri ángel y xrac'axaj ri xubij chire, achi'el xsach ruc'u'x y xuch'ob c'a ka pa ránima chi achique roma tok quere' ruk'ejeloxic (ruk'ijaloxic) nuben. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jari' tok ri ángel chanin xubij chire ri María: Man taxibij-avi'. Rat avilon rutzil ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Vacami c'a, ninbij can chave chi xtipe alanic chavij, y tok xtalex c'a re ac'ual re', ti ala' y Jesús ri rubi' ri xtaya'. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Rija' janíla c'a ruk'ij xtic'oje', y xtubini'aj chuka' Ruc'ajol ri nimalej Dios. Ri Jesús jun riy-rumam can ri rey David, y ri Ajaf Dios can ja rija' ri xtutz'uyuba' can pa rutz'uyubal ri rey David ri xc'oje' ojer can, ");
INSERT INTO cakCNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","richin queri' ri Jesús nuk'et tzij pan ivi' rix riy-rumam can ri Jacob. Y ri ruk'atbel-tzij xtibe-ruvech, man jun bey chic xtitane', xcha' ri ángel chire ri María. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Y tok ri María rac'axan chic ka ronojel re', xuc'utuj chire ri ángel: ¿Achi'el c'a tok xtic'oje' val? Roma yin xa man jani inc'o ta riq'uin ri xtoc vachijil. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Y ri ángel xubij chire ri María: Ja ri Lok'olej Espíritu riq'uin ri ruchuk'a' ri nimalej Dios, jari' ri xtika-pe pan avi'. Roma c'a ri', ri lok'olej ac'ual ri xtalex aviq'uin, can xtubini'aj na vi Ruc'ajol ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Y tavetamaj c'a chuka' can, chi ri Elisabet ri avach'alal xteralaj jun ac'ual, stape' man vi alanel ta y chuka' can ri'j chic. Y jare' ri ruvak ric' (ruvakak ric'). ");
INSERT INTO cakCNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Roma ri Dios man jun ri c'ayef ta nuben chuvech. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Can jari' tok ri María xubij: Jac'are' inc'o pa ruk'a' ri Ajaf. Can tibanatej c'a achi'el ri xabij chuve, xcha' ri María chire ri ángel. Y ri ángel xel-el chiri' riq'uin ri María, y xbe. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Je k'ij c'a ri' tok ri María chanin xuben-el richin xbe pa jun tinamit ri c'o pa ruvi' jun juyu' richin Judea. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Y tok xapon chiri' pa tinamit, rija' xbe pa cachoch ri Zacarías y ri Elisabet. Rija' xuk'ejela' c'a (xuk'ijala' c'a) ri Elisabet. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tok ri Elisabet xrac'axaj ri ruk'ejelonic (ruk'ijalonic) ri María, can xropin janíla ri ac'ual ri royoben, xuna' rija'. Y tok ri Elisabet nojinek chic ránima riq'uin ri Lok'olej Espíritu, ");
INSERT INTO cakCNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","can riq'uin c'a ruchuk'a' xch'on, y xubij: Chikacojol roj ixoki', ja rat ri más urtisanic ac'ulun, y que chuka' ri' ri urtisanic c'o pa ruvi' ri ac'ual ri xtalex aviq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Man nik'ax ta c'a chinuvech, ¿roma in achique ta c'a yin, richin yino'ak'ejela' can (yino'ak'ijala' can) rat ri rute' ri Vajaf? ");
INSERT INTO cakCNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Y can xe xinvac'axaj ri ach'abel tok xinak'ejela' (xinak'ijala'), ri ac'ual ri voyoben, can xropin roma quicoten, xinna' yin. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jebel c'a ruva-ak'ij chi xanimaj ri xubij ri Ajaf chave, roma ri ac'ual ri xubij chave chi xtalex aviq'uin, can xtalex na vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Y jac'ari' tok ri María xubij: Yin riq'uin ronojel vánima ninya' ruk'ij ri Ajaf. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ri vánima niquicot roma ri Dios ri Nucolonel. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Roma ri Dios xirucha', yin ri xa in achique la oc chi samajel. Y janipe' ri xtibe-apo, ri vinek xtiquibij chi jebel ruva-nuk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Roma q'uiy nima'k tak utzil ri rubanon-pe chuve rija', ri can nitiquir-vi nuben ronojel. Y ri rubi' rija' can lok'olej vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Can nujoyovaj c'a chuka' quivech conojel ri vinek, ri chi sol chi sol yek'ax-el chuvech re ruvach'ulef y can niquiya' ruk'ij rija'. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Y riq'uin c'a ri ruchuk'a', can q'uiy c'a rubanalon. Rija' rukasan quik'ij ri yech'obon pa tak cánima chi can janíla quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","E rukasan nima'k tak k'atoy-tzij, y e runimirisan ri xa juba' oc quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ri yevayjan, can ruyo'on c'a ronojel ri nic'atzin chique; jac'a ri beyoma' xa choj queri' xetak-el. Can man jun xuya-el chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Rija' oj ruto'on c'a roj israelitas ri can oj rucha'on-vi richin chi nikaben ri rusamaj. Man oj rumestan ta vi can y rujoyovan kavech. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Can rujoyovan-vi kavech, achi'el ri rubin can chique ri kati't-kamama' ojer, ri rubin can chire ri Abraham y chike roj ri riy-rumam rija'. Ri Dios can man jun bey c'a xtumestaj ri rubin can. Queri' c'a ri xubij ri María. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Y ri María xc'oje' la'ek can jun oxi' ic' riq'uin ri Elisabet, y c'ari' xtzolin chirachoch. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tok xapon ri k'ij richin nalex ri ti ac'ual riq'uin ri Elisabet, xralaj jun ac'ual ti ala'. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Y ri vinek c'a ri e ru-vecinos ri Elisabet y ri e rach'alal xcac'axaj c'a chi jun nimalej rutzil ri Ajaf, roma xralaj jun ac'ual. Y re vinek c'a re' xe'apon riq'uin, chuk'ejeloxic (chuk'ijaloxic), y janíla c'a chuka' xequicot riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Y rije' xe'apon chic c'a riq'uin ri Elisabet, tok xapon ri vakxaki' ruk'ij ri ac'ual, tok can ja chuka' ri' niban ri circuncisión chire ri ac'ual, achi'el nubij chupan ri ru-ley ri Moisés. Y can ja chuka' k'ij ri' tok niquicanoj can rubi' ri ac'ual. Y ri ec'o quiq'uin ri rute-rutata' ri ac'ual xcajo' c'a xquiya' ri rubi' ri rutata' chire ri ac'ual, y queri' ri ac'ual xubini'aj ta Zacarías. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Jac'a ri rute' ri ac'ual chanin xubij: Re ac'ual man xtuc'uaj ta ri rubi' ri rutata', roma re ac'ual re' xtubini'aj Juan. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Y ri ec'o quiq'uin ri Elisabet xquibij chire: ¿Achique roma tok navajo' chi re ac'ual nubini'aj Juan? Roma man jun chique ri e avach'alal rubini'an ta queri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jac'ari' tok pa mem xech'on-apo chire ri Zacarías, ri rutata' ri ac'ual, richin niquic'utuj chire achique bi'aj nrajo' nuya' chire ri ac'ual. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ri rutata' ri ac'ual xuc'utuj jun tz'alen ri yequicusaj richin yetz'iban. Chuvech c'a ri tz'alen ri' xutz'ibaj: Ri ac'ual xtubini'aj Juan. Y conojel c'a ri quimolon-apo-qui' quiq'uin ri rute-rutata' ri ac'ual, xsach quic'u'x, roma can ja ri bi'aj ri xubij ri te'ej, can ja chuka' ri' xutz'ibaj ri Zacarías chuvech ri tz'alen. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Can jac'ari' tok ri Zacarías xch'on chic jun bey. Y rija' can xe xch'on, can jari' xuya' ruk'ij ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Y ri e qui-vecinos xpe c'a xibinri'il chique, roma ri xbanatej chiri'. Y ri xbanatej, nitzijox c'a ri lugar ri', chiri' pa tak juyu' ri e richin ri Judea. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Y conojel c'a vinek ri ye'ac'axan ri xbanatej quiq'uin ri Zacarías y ri Elisabet, niquiyec c'a ka pa tak cánima ri nitzijox chique, y niquibij: ¿Achique c'a rusamaj ruc'amon-pe re ac'ual re'? yecha'. Roma nik'alajin chi can c'o-vi ri Ajaf Dios riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Roma c'a ri' ri Zacarías, ri rutata' ri ac'ual, tok nojinek ránima riq'uin ri Lok'olej Espíritu, rija' xuk'alajirisaj c'a y xubij: ");
INSERT INTO cakCNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Janíla ta xtinimirisex rubi' ri Ajaf Dios kichin roj ri aj-Israel, roma yojrunataj-pe roj ri rutinamit, y yojrucol. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ri Dios nuya' jun kanimalej Colonel. Y re Kacolonel re', jun riy-rumam can ri David ri jun ka-rey y rusamajel ri Dios xc'oje' ojer can. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ri Dios xbin chique ri lok'olej tak achi'a' ri xek'alajirisan ri ruch'abel rija' ojer can, chi xquibij chi xtuya' jun Kacolonel. Can rusujun-vi-pe jun Kacolonel ojer ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Can rubin-vi-pe chi xkojrucol chiquivech ri ye'etzelan kichin, y xkojrucol pa quik'a' ri man ye'ajovan ta kichin, ");
INSERT INTO cakCNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","y richin xtujoyovaj chuka' quivech ri kati't-kamama' xec'oje' ojer can, can nuben-vi ri xubij, tok xuben ri lok'olej trato. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Can xuben-vi jurar chire ri kamama' Abraham ");
INSERT INTO cakCNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","chi can xkojrucol na vi pa quik'a' ri ye'etzelan kichin, richin queri' man jun xibinri'il pa tak kánima nikasamajij rija', ");
INSERT INTO cakCNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","y riq'uin jun chojmilej y ch'ajch'ojilej c'aslen chuvech rija', nikasamajij-el janipe' yojc'ase-el chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Y rat ti nuc'ajol, xcha' ri Zacarías, can at k'alajirisey ri ruch'abel ri nimalej Dios xtibix chave, roma ja rat ri xcabin chique ri vinek chi tiquichojmirisala' ri rubey ri quic'aslen, roma nakaj chic c'o-vi ri rupetebel ri Ajaf, ");
INSERT INTO cakCNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","y ja rat ri xcabin chi ri Dios nucuy quimac ri can e rutinamit, richin yecolotej. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Y ri', xaxe roma ri ka-Dios nujoyovaj kavech, riq'uin ronojel ajovabel. Romari' nutek-pe ri Jun ri nosakirisan kichin, ri can achi'el k'ij tok xtika-pe chila' chicaj. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ri Jun c'a ri nosakirisan, xquerusakirisaj ri ec'o pa k'eku'n y ri ec'o pa rumujal ri camic, y xkojruyukej c'a chupan ri bey richin uxlanen. ");
INSERT INTO cakCNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Y que c'a ri', ri ac'ual ri xalex quiq'uin ri Zacarías y ri Elisabet, ruchapon c'a niq'uiy y chuka' queri' pa ruc'aslen. Y jac'a ri pa tz'iran ruvach'ulef xc'oje-vi, c'a tok xapon ri k'ij richin xutzijoj ri ruch'abel ri Dios chiquivech ri aj-Israel ri ruvinak. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Y chupan c'a ri k'ij ri', ri pa ru-tiempo ri Augusto César ri jun nimalej k'atoy-tzij, jari' tok xtak rubixic chique conojel vinek chi neban jun tz'iban bi'aj. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Man jun bey banatajinek ta queri'. Pero tok xban re nabey tz'iban bi'aj re', jari' tok c'a k'atoy na tzij ri jun achin rubini'an Cirenio, chiri' pa ruvach'ulef Siria. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Y ri vinek pa ruvach'ulef Israel c'o c'a chi nequitz'ibaj quibi' pa tak quitinamit ri cati't-quimama'. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Y chiri' pa Galilea c'o jun tinamit rubini'an Nazaret. Y ri chiri' pa Nazaret c'o c'a jun achin rubini'an José. Y re José c'a re', c'o c'a chi nibe chutz'ibaxic ri rubi' c'a pa Belén, ri jun tinamit c'a pa Judea nicanej-vi can, roma e aj chiri' ri e rati't-rumama'. Chiri' c'a pa Belén xalex-vi ri rey David, y ri José can riy-rumam c'a ri rey David. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Y ri José rachibilan ri María ri rixjayil chic, roma ri pa nabey xaxe c'a ruc'utun richin chi nic'ule' riq'uin. Che ca'i' rije' xebe c'a pa Belén chutz'ibaxic quibi'. Y ri María xa nakaj chic c'a alanic chirij. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Y chiri' c'a pa Belén ec'o-vi tok ri María xtz'aket ri ruk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Rija' xc'oje' c'a ral ti ala'. Ri María jebel xubolkotij ri ac'ual pa tziek, y xuliba' pa jun quivaybal chicop. Pa jun quica'aj chicop xalex-vi ri nabey ti ral ri María, roma nojinek chic ri posada. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Y ec'o c'a aj-yuk'a' yequivaraj quicarne'l pa jun juyu' ri nakaj nicanej-vi can chire ri tinamit Belén. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Can jari' tok xuc'ut-ri' jun ángel chiquivech re aj-yuk'a' re', jun ángel ri petenek chila' chicaj riq'uin ri Ajaf. Y rije' janíla xquixibij-qui' roma ri ángel, y roma chuka' ri rusakil ri Ajaf ri xsakirisan quichin. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero ri ángel xubij chique: Man tixibij-ivi'. Tivac'axaj na pe' re ninvajo' ninbij chive, can richin janíla quicoten. Y man xe ta chuka' ivichin rix re quicoten re', xa can quichin chuka' conojel vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tivac'axaj c'a re xtinbij chive: Chiri' pa Belén, ri rutinamit can ri rey David, vacami xalex ri Colonel, ri Cristo ri Ajaf. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ri retal richin vi ja ti ac'ual ri' ri xivil, xtitz'et c'a chi bolkotin jebel pa tziek y cotz'oban pa jun quivaybal chicop, xcha' ri ángel. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Can jari' chuka' xe'oc'ulun ch'aka' chic ángeles ri e petenek chila' chicaj. Can e janíla. Y rije' niquiya' c'a ruk'ij ri Dios, y niquibij: ");
INSERT INTO cakCNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Vacami, ri chila' chicaj janíla ruk'ij-ruc'ojlen nuc'ul ri Dios! ¡Y vave' chuvech re ruvach'ulef xoka' yan ri uxlanen. Xoka' yan chiquicojol ri vinek, roma ri rutzil ri Dios! ");
INSERT INTO cakCNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Can xe xquibij can queri' ri ángeles, can jari' xebe chila' chicaj. Y can xe c'a xebe ri ángeles ri', ri aj-yuk'a' can jari' xquibila-ka chiquivech: Jo' junanin pa Belén. Jo' chutz'etic ri ac'ual ri xalex chila'. Roma ri Ajaf can xutek-pe re rutzijol chike. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Y richin c'a chi nequitz'eta', re aj-yuk'a' re' can junanin c'a xebe c'a pa tinamit. Can c'o na vi ri María, ri José, y ri ac'ual can cotz'oban c'a pa jun quivaybal chicop. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Re aj-yuk'a' re', can xe xquitz'et ri ac'ual, xquichop c'a rutzijoxic ri xbix chique roma ri ángel, chirij re jun ti ac'ual re'. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Y conojel c'a ri vinek ri ye'ac'axan quichin, can achique la xcac'axaj ri utzilej tak ch'abel ri niquitzijoj ri aj-yuk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Y ri María can xeruyec c'a pa ránima ronojel ri tzij ri', y nuch'ob chuka' quij ri tzij ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ri aj-yuk'a' xetzolej c'a. Pero rije' niquiyala' c'a ruk'ij-ruc'ojlen ri Dios y niquinimirisala' ri rubi'. Rije' que c'a ri' niquiben roma ronojel ri quitz'eton y cac'axan chic. Can xbanatej-vi c'a achi'el ri rubin can ri ángel. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Can c'a man jani rutzijol chi nic'oje' ta c'a ral ri María chiri', tok jun ángel xubij chi ri ac'ual ri xtralaj xtubini'aj Jesús. Y can que c'a re' xubini'aj can ri ac'ual tok c'a vakxaki' k'ij talex. Y ja k'ij chuka' ri' tok xban ri circuncisión chire, achi'el ri nubij ri ruch'abel ri Dios chi c'o chi niban. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Y tok xtz'aket c'a ri k'ij achi'el nubij ri ley richin ri Moisés, chi ri ixoki' ri xe'alan c'o chi niquich'ajch'ojirisaj-qui', ri María can queri' vi xuben. Y tok xebe c'a chubanic ri ch'ajch'ojirisanic ri' c'a chila' pa rachoch ri Dios pa Jerusalem, ri María y ri José can xquic'uaj c'a chuka' ri Jesús richin chi can jac'ari' nequic'utu' can ri ac'ual pa rachoch ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Queri' xquiben roma ri ley richin ri Ajaf Dios nubij chi ronojel nimalaxel-ala' pa jun jay, can richin vi ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ri José y ri María can xquiben-vi c'a ri nubij chupan ri ley richin ri Ajaf Dios, ri nich'on chirij ri ch'ajch'ojirisanic. Rije' xquiya' c'a chuvech ri Dios ca'i' palomas, roma ri ley can nubij-vi c'a: Ca'i' palomas e nima'k o ca'i' tak cocoj. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Y chiri' pa tinamit Jerusalem ri tiempo ri', c'o c'a jun achin rubini'an Simeón. Re jun achin c'a re', choj ri ruc'aslen y yo'ol ruk'ij ri Dios. Ri Simeón, can c'o-vi c'a ri Lok'olej Espíritu riq'uin y royoben chuka' tok xtipe ri Cristo chucolic ka rija' y chiquicolic ri ch'aka' chic israelitas. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Y ri Lok'olej Espíritu ruk'alajirisan chic c'a chire ri Simeón chi man xtutz'et ta ri camic c'a tok rutz'eton chic na can ri Cristo, ri xtutek-pe ri Ajaf Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Y chupan c'a ri k'ij tok ri te'ej-tata'aj xquic'uaj ri ac'ual pa rachoch ri Dios richin niquiben achi'el ri nubij ri ley, can jac'a chuka' k'ij ri' tok xapon ri Simeón pa rachoch ri Dios, roma queri' xrajo' ri Lok'olej Espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ri Simeón xuch'elej c'a ri ac'ual, y richin chi xuya' ruk'ij ri Dios, xubij c'a: ");
INSERT INTO cakCNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ajaf, vacami c'a xa can utz chic chi yinavelesaj-el, xa can c'o chic el uxlanen pa vánima yibe, roma can achi'el ri abin chuve, can queri' xbanatej. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ri runak'-nuvech xquitzu' yan c'a can ri Colonel ri petenek aviq'uin rat, ");
INSERT INTO cakCNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ri xaya-pe rat quichin conojel ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ja rija' chuka' ri Sakil quichin ri vinek man e israelitas ta, roma ja rija' ri xtik'alajirisan ri abey rat chiquivech. Y roj ri atinamit Israel, roma can chikacojol xalex-vi ri Colonel, q'uiy utzil xtikac'ul y xtic'oje' kak'ij-kac'ojlen, xcha' ri Simeón. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Y ri José y ri María ri te'ej can achique la c'a xcac'axaj ri xubila' ri Simeón chirij ri ac'ual. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Y jac'ari' tok ri Simeón xuben jun oración coma ri José y ri María, richin ja ta ri Dios ri xturtisan quichin. Tok rubanon chic ka orar ri Simeón, xubij c'a chire ri María, ri rute' ri ac'ual: Tavac'axaj na pe', re ac'ual re' nim ri samaj yo'on-pe chire roma ri Dios. Y roma rija', e q'uiy chique ri kavinak israelitas xquecolotej. Y e q'uiy chuka' ri xquetzak, roma xtiquetzelaj janíla. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Can roma c'a rija' tok xtek'alajin-pe ri etzelal c'o pa tak cánima ri vinek. Y ri Simeón xubij chuka' chire ri María: Roma ri itzel ri xtiban chire ri Jesús, xtipe k'axo'n aviq'uin rat. Xtana' c'a chi can achi'el jun ch'ich' ri xtusoc ri avánima, xcha' ri Simeón. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chiri' c'a pa rachoch ri Dios c'o c'a jun ixok rubini'an Ana. Rija' k'alajirisey c'a richin ri nibix chire roma ri Dios. Rija' rumi'al can jun achin rubini'an Fanuel, y riy-rumam can ri Aser, ri jun achin xc'oje' ojer can. Re Ana c'a re' ti ri'j chic. Rija' c'a co'ol tok xc'ule'. Y xaxe vuku' juna' xquic'uaj-qui' riq'uin ri rachijil, roma xa chanin xquen-el (xcom-el) ri achin chuvech. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Man riq'uin ri' man xc'ule' ta chic jun bey. C'o chic c'a ochenta y cuatro rujuna', y can nic'oje' c'a pa rachoch ri Dios k'ij-k'ij. Q'uiy c'a bey nuben chi man niva' ta, richin nuben orar. Nuya' c'a ruk'ij ri Dios chi pak'ij chi chak'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tok ri Ana xutz'et ri ti ac'ual Jesús, rija' xbe-apo riq'uin. Y janíla c'a xmatioxin chire ri Dios roma ri ac'ual ri', roma xunabej chi ja Colonel ri'. Y xuchop c'a rutzijoxic chique ri vinek ri e oyobeyon richin re Colonel re', ri chiri' pa Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ri José y ri María xquiben c'a ronojel ri nuchilabej ri Ajaf Dios chupan ri ru-ley, ri c'o chi niquiben tok c'a juba' talex jun ac'ual. C'ari' xetzolej pa cachoch chiri' pa Nazaret. Re tinamit re' c'a pa Galilea nicanej-vi can. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y ri ac'ual xuchop c'a ruq'uiyinen, y nic'oje' chuka' el ruchuk'a'. Rija' can ninimer c'a el riq'uin etamabel, y c'o ri rutzil ri Dios pa ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ri María y ri José ri e rute-rutata' ri Jesús, can ronojel c'a juna' yebe pa tinamit Jerusalem. Rije' yebe chiri' pa Jerusalem tok napon ri k'ij richin ri quinimak'ij ri israelitas ri rubini'an pascua. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Y xapon chic c'a jun bey ri k'ij richin ri quinimak'ij ri'. Ri Jesús tz'aket chic c'a cablajuj rujuna' tok xebe c'a pa Jerusalem. Xebe c'a pa tinamit, can achi'el vi niquiben ri quivinak israelitas. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tok ic'ovinek chic c'a can ri nimak'ij pascua, ri María y ri José xetzolin chicachoch. Pero rije' man quetaman ta c'a chi ri ac'ual Jesús xa xc'oje' ajc'a can chiri' pa tinamit Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ri José y María can quicukuban-ka quic'u'x chi ri ac'ual benek, y queri' xebiyin jun k'ij. Pero xquinabej chi man benek ta, c'a tok xquic'utula' na chique ri cach'alal y chique ri quetaman quivech. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Y roma ri man xquil ta, ri José y ri María xetzolin can chucanoxic ri ac'ual c'a pa tinamit Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","C'a pa rox k'ij c'a chire tok ri María y ri José quisachon ri ac'ual, c'ari' xquil. Rije' xquil c'a ri ac'ual chiri' pa rachoch ri Dios chiri' pa Jerusalem. Ri ac'ual tz'uyul-apo quiq'uin ri achi'a' e etamanela' chirij ri ley, nrac'axaj ri niquibij y c'o chuka' ri yeruc'utula-apo rija' chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Y conojel c'a ri can xcac'axaj ri nubij ri ac'ual xsach quic'u'x, roma ri nic'utux-pe chire coma ri etamanela', ri ac'ual can jebel vi nitiquir nubij-apo chique. Rija' can nik'alajin-vi chi ronojel jebel nik'ax chuvech y c'o etamabel riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chiri' c'a pa rachoch ri Dios c'o-vi ri Jesús tok ri María y ri José xbequila'. Rije' can achique la c'a xquina'. Y jari' tok ri rute' xubij chire ri ral: ¿Achique xaben? ¿Achique roma tok xac'oje' can y man jun xabij chike? Tatzu' la'. La atata' y yin janíla at kacanon chic. Y can nik'axon chic kánima roma man jun bey yatkil. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Y jari' tok rija' xubij chique: ¿Achique c'a roma tok janíla yinicanoj? Chinuvech yin, rix can jebel vi ivetaman chi ja ri nrajo' ri Nata' Dios jari' ri c'o chi ninben. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jac'a ri ch'abel ri xubij ri ac'ual chique ri José y María man xk'ax ta chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Y c'ari' ri ac'ual junan c'a xtzolin quiq'uin rije' c'a chicachoch, ri pa tinamit Nazaret c'o-vi. Ri ac'ual can janíla nunimaj quitzij. Y ronojel c'a ri xbanatej ri pa Jerusalem riq'uin ri ac'ual, ri María xeruyec c'a pa ránima. ");
INSERT INTO cakCNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Y riq'uin ri benek ri tiempo, ri Jesús ruchapon chuka' q'uiyinen, y can que chuka' ri' ri etamabel ri c'o riq'uin benek pa jotol. Can janíla c'a jebel chuvech ri Dios, y janíla c'a chuka' jebel chiquivech ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","C'o yan c'a volajuj juna' tuk'et-pe tzij ri achin rubini'an Tiberio César. Y pa ruk'a' c'a re Tiberio César re' xec'oje-vi re caji' k'atoy tak tzij re'. Jun chique ri caji' k'atoy-tzij ri' ja ri Poncio Pilato, y rija' nik'aton tzij pa Judea. Ri jun chic, ja ri Herodes y rija' nik'aton tzij pa Galilea. Ri rox, ja ri Felipe ri rach'alal ri Herodes, y rija' nik'aton tzij ri pan Iturea y Traconite. Jac'a ri rucaj k'atoy-tzij ja ri Lisanias, y rija' nik'aton tzij ri pan Abilinia. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Y can jac'a chuka' tiempo ri' tok ri Anás y ri Caifás e nimalej tak sacerdotes chiri' pa rachoch ri Dios, chiri' pan Israel. Ronojel c'a re' ye'oc retal richin tok xch'on ri Dios chire ri Juan ri ruc'ajol ri Zacarías. Can jac'a ri chiri' pa tz'iran ruvach'ulef xch'on-vi ri Dios chire ri Juan. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Y rija' xaxe c'a ri ruchi' ri raken-ya' Jordán xuchop-el, y xbe. Rija' nubij c'a chique ri vinek ri ye'apon riq'uin chi titzolej-pe quic'u'x riq'uin ri Dios y tiquibana' bautizar qui', richin queri' ri Dios nucuy quimac. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Y can jac'a riq'uin ri Juan xbanatej-vi ri rubin can ri Dios chire ri jun rusamajel ri xc'oje' ojer can. Re rusamajel c'a re' xubini'aj Isaías. Y ri rutz'iban can ri Isaías, que c'a re' ri nubij: C'o c'a jun achin ri xtic'oje' pa tz'iran ruvach'ulef, y ja rija' ri xtitzijon ri ruch'abel ri Dios chiquivech ri vinek ri xque'apon riq'uin. Y xtubila' c'a chique: Tichojmirisala' rubey ri ic'aslen, roma nakaj chic c'o-vi ri rupetebel ri Ajaf. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Y richin c'a nichojmirisex jun bey, can nic'atzin c'a chi yenojisex ri sivan. Nic'atzin chuka' yejos-ka ri juyu'. Ri xotoxek tak bey, choj tiban chique. Y ri cujquek tak bey, lik' c'a chuka' tiban chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y conojel c'a vinek xtiquitz'et ri colotajic ri nuya' ri Dios, nicha' chupan ri vuj ri rutz'iban can ri Isaías. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Y que c'a ri', tok ye'apon ri vinek riq'uin ri Juan richin yeban-el bautizar, rija' nubij c'a chique: Ix achi'el itzel tak cumatzi', ri yixanmej chuvech ri ruc'ayeval, roma nivajo' yixcolotej chuvech ri ruc'ayeval ri xtutek-pe ri Dios, re chikavech apo. ¿Achique c'a xyo'on rutzijol chive chi quere' tibana'? ");
INSERT INTO cakCNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Rix nic'atzin c'a chi nic'ut chi can kitzij nitzolej-pe ic'u'x riq'uin ri Dios. Y man tich'ob-ka chi can xe roma ri ix riy-rumam can ri Abraham, can ta romari' xquixcolotej, man que ta ri'. Roma can ta ri Dios nrajo', rija' yeruben ta riy-rumam ri Abraham chique re abej re ye'itz'et vave'. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ri ruc'ayeval ri nuya' ri Dios nipe yan. Rija' xtuben c'a achi'el nuben jun achin ri c'o chic ri iquej pa ruk'a' richin chi yerukasaj ri che' ri xa man niquiya' ta utzilej quivech. Y ronojel c'a ri che' ri xquerukasaj, xqueruq'uek pa k'ak', xcha' ri Juan. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Y can jac'ari' tok ri vinek ri ye'ac'axan-apo richin ri Juan, xquic'utuj chire: ¿Achique c'a ri ruc'amon chi nikaben? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Y ri Juan xubij c'a chique ri xec'utun-apo: Achique c'a chive rix ri c'o ca'i' rutziak, tuya' jun chire ri manek rutziak. Y xabachique c'a chuka' chive rix c'o ta vey riq'uin, tuya' c'a chuka' chire ri man jun nutej, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Y chiri' riq'uin ri Juan, ec'o c'a chuka' apo ca'i-oxi' achi'a' ri e moloy tak alcaval. Re achi'a' c'a re' xe'apon richin yeban bautizar. Y re achi'a' chuka' re' xquic'utuj chire ri Juan: Tijonel, xecha' chire. Y roj ¿achique ri ruc'amon chi nikaben? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ri Juan xubij chique: Xaxe c'a ri alcaval ri bin chive roma ri k'atbel-tzij, can xe ri' tic'utuj chique ri vinek. Man c'a tiya' ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Can jac'a chuka' ri' tok e ca'i-oxi' soldados ri e apovinek riq'uin ri Juan, xquic'utuj-apo chire: Y roj ¿achique ruc'amon chi nikaben? xecha'. Ri Juan xubij chique: Man c'a que'ivelesala' qui-cosas ri vinek, can roma ri c'o k'atbel-tzij pan ik'a'. Ni man achique que'ik'abala' chiquij vinek. Y ticuker c'a ka ic'u'x riq'uin ri mero nich'ec, xcha' ri Juan. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Y ri vinek ri ec'o c'a apo riq'uin ri Juan, can coyoben c'a chi ri Juan c'o ta ri nubij, roma niquibila' c'a pa tak cánima chi riq'uin juba' ja ri Juan jari' ri Cristo, pero xa man ja ta rija'. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Roma c'a ri' ri Juan xubij chique ri vinek ri e apovinek riq'uin: Rix nitz'et chi yin yixinben bautizar riq'uin ya'. Pero c'o c'a Jun ri xtipe re chikavech apo, ri xquixruben bautizar riq'uin ri Lok'olej Espíritu y riq'uin k'ak'. Re Jun c'a re xtipe, janíla nim ruk'ij y nim ruchuk'a'. Xa man achi'el ta oc yin. Roma yin man ruc'amon ta richin ninsol ri ruximbal ri ruxajab, roma rija' nim ruk'ij y nim ruchuk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Y can achi'el c'a jun achin tok nujosk'ij ri ru-trigo pan era. Rija' nic'atzin jun che' c'o ca'i' o oxi' rutza'n chire, richin queri' nuq'uek chuva-cak'ik' ri trigo ri ch'ayon chic. Ri runak' ri trigo nic'oje' can, pero ri páxa nuc'uaj-el cak'ik'. Y ja ri runak' ri trigo, jari' ri nuyec, y ri páxa nuporoj. Can que c'a ri' xtuben ri Jun ri xtipe, xcha' ri Juan. Ri Jun ri xtipe c'o chic k'atbel-tzij pa ruk'a', richin nuk'et tzij pa quivi' ri vinek ri ec'o chuvech re ruvach'ulef. Ri vinek c'a ri yeniman richin, xqueruc'uaj chila' chicaj. Jac'a ri vinek ri man yeniman ta richin, xquerutek chupan ri k'ak' ri man jun bey xtichup. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Q'uiy tzij c'a re que tak re' xerucusaj ri Juan richin xutzijoj ri utzilej ch'abel richin colotajic chique ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ri Juan xubij c'a chire ri k'atoy-tzij rubini'an Herodes, chi man utz ta ri rubanon, roma rija' ruc'amon-ka ri rixjayil ri rach'alal, rubini'an Felipe. Re ixok re' rubini'an Herodías. Ri Juan xunataj c'a ri' chire ri Herodes, y xerunataj chuka' ch'aka' chic rumac ri e rubanalon. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Y ri Herodes xnimer c'a ruvi' ri rumac, roma xutz'apej ri Juan pa cárcel. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Y c'o c'a ri xbanatej tok najin ri bautismo quichin ri vinek y xban chuka' bautizar ri Jesús. Tok ri Jesús najin c'a che oración, jari' tok xjakatej ri caj. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Y ri Lok'olej Espíritu can tz'etel-vi ri xka-pe pa ruvi' ri Jesús. Can achi'el jun paloma ri xka-pe pa ruvi' rija'. Y xac'axatej chuka' chi nibix-pe chire chila' chicaj: Ja rat ri Nuc'ajol, janíla yatinvajo', y aviq'uin rat nucukuban-vi nuc'u'x. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Chupan ri tiempo ri', ri Jesús c'o la'ek juvinek-lajuj rujuna'. Can jac'ari' tok xuchop ri rusamaj. Y chiquivech ri vinek, ri Jesús ruc'ajol ri José. Ri José ruc'ajol can ri Elí. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Y re Elí re', ruc'ajol can ri Matat, y ri Matat ruc'ajol can ri Leví, y ri Leví ruc'ajol can ri Melqui, y ri Melqui ruc'ajol can ri Jana, y ri Jana ruc'ajol can jun chic achin rubini'an José. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Y re José re', ruc'ajol can ri Matatías, y ri Matatías ruc'ajol can ri Amós, y ri Amós ruc'ajol can ri Nahum, y ri Nahum ruc'ajol can ri Esli, y ri Esli ruc'ajol can ri Nagai. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Y re Nagai re', ruc'ajol can ri Maat, y ri Maat ruc'ajol can jun achin rubini'an Matatías, y re Matatías re', ruc'ajol can ri Semei, y ri Semei ruc'ajol can jun achin rubini'an José, y re José re', ruc'ajol can ri Judá. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Y re Judá re', ruc'ajol can ri Joana, y ri Joana ruc'ajol can ri Resa, y ri Resa ruc'ajol can ri Zorobabel, y ri Zorobabel ruc'ajol can ri Salatiel, y ri Salatiel ruc'ajol can ri Neri. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Y re Neri re', ruc'ajol can jun achin rubini'an Melqui, y ri Melqui ruc'ajol can ri Adi, y ri Adi ruc'ajol can ri Cosam, y ri Cosam ruc'ajol can ri Elmodam, y ri Elmodam ruc'ajol can ri Er. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Y re Er re', ruc'ajol can ri Josué, y ri Josué ruc'ajol can ri Eliezer, y ri Eliezer ruc'ajol can ri Jorim, y ri Jorim ruc'ajol can jun achin rubini'an Matat. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Y re Matat re', ruc'ajol can jun achin rubini'an Leví, y ri Leví ruc'ajol can ri Simeón, y ri Simeón ruc'ajol can jun achin rubini'an Judá, y ri Judá ruc'ajol can jun achin rubini'an José, y ri José ruc'ajol can ri Jonán, y ri Jonán ruc'ajol can ri Eliaquim. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Y re Eliaquim re', ruc'ajol can ri Melea, y ri Melea ruc'ajol can ri Mainán, y ri Mainán ruc'ajol can ri Matata, y ri Matata ruc'ajol can ri Natán. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Y re Natán re', ruc'ajol can ri David, y ri David ruc'ajol can ri Isaí, y ri Isaí ruc'ajol can ri Obed, y ri Obed ruc'ajol can ri Booz, y ri Booz ruc'ajol can ri Salmón, y ri Salmón ruc'ajol can ri Naasón. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Y re Naasón re', ruc'ajol can ri Aminadab, y ri Aminadab ruc'ajol can ri Aram, y ri Aram ruc'ajol can ri Esrom, y ri Esrom ruc'ajol can ri Fares, y ri Fares ruc'ajol can jun achin rubini'an Judá. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Y re Judá re', ruc'ajol can ri Jacob, y ri Jacob ruc'ajol can ri Isaac, y ri Isaac ruc'ajol can ri Abraham, y ri Abraham ruc'ajol can ri Taré, y ri Taré ruc'ajol can ri Nacor. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Y re Nacor re', ruc'ajol can ri Serug, y ri Serug ruc'ajol can ri Ragau, y ri Ragau ruc'ajol can ri Peleg, y ri Peleg ruc'ajol can ri Heber, y ri Heber ruc'ajol can ri Sala. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Y re Sala re', ruc'ajol can ri Cainán, y ri Cainán ruc'ajol can ri Arfaxad, y ri Arfaxad ruc'ajol can ri Sem, y ri Sem ruc'ajol can ri Noé, y ri Noé ruc'ajol can ri Lamec. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Y re Lamec re', ruc'ajol can ri Matusalén, y ri Matusalén ruc'ajol can ri Enoc, y ri Enoc ruc'ajol can ri Jared, y ri Jared ruc'ajol can ri Mahalaleel, y ri Mahalaleel ruc'ajol can jun achin rubini'an Cainán. ");
INSERT INTO cakCNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Y re Cainán re', ruc'ajol can ri Enós, y ri Enós ruc'ajol can jun achin rubini'an Set, y ri Set ruc'ajol can ri Adán, y ri Adán ralc'ual ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ri k'ij c'a tok xban bautizar ri Jesús, rija' nojinek ránima riq'uin ri Lok'olej Espíritu xtzolin-pe pa raken-ya' Jordán. Y re Lok'olej Espíritu re' xuben c'a chire ri Jesús chi xbe, c'a pa tz'iran ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Y chiri' xc'oje-vi. Ri cavinek k'ij c'a xc'oje' chiri', ri itzel-vinek can nutej ruk'ij chirij richin nitzak ta pa ruk'a'. Y chupan ri janipe' k'ij xc'oje' ri Jesús chupan ri lugar ri', man jun vey xutej. Romari' ninum nuna' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Y can jac'ari' c'o-apo ri itzel-vinek, y xubij chire ri Jesús: Rat nabij chi at Ruc'ajol ri Dios, y yanum. Tabana' c'a chique re abej re' chi que'oc vey. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pero ri Jesús xubij chire: Tz'ibatel can chupan ri ruch'abel ri Dios, chi ri achin nril chuka' ruc'aslen riq'uin ri ruch'abel ri Dios y man xe ta c'a riq'uin ri vey. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Y can jac'ari' tok ri itzel-vinek xuc'uaj ri Jesús pa ruvi' jun nimalej juyu', y xuc'ut ronojel tinamit richin ri ruvach'ulef chuvech ri Jesús, pa jun ti ramaj. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Y c'ari' ri itzel-vinek xubij chire ri Jesús: Yin ninjech pan ak'a' ri quik'ij re nimalej tak tinamit re', y ye'oc pan ak'a' richin nak'et tzij pa quivi', roma pa nuk'a' yin e jachon-vi can, y yin yitiquir ninya' ronojel re' chire xabachique ri ninvajo' yin. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Y vi rat yaxuque' chinuvech y naya' nuk'ij, ronojel c'a re' xtoc avichin, xcha' ri itzel-vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero ri Jesús jari' tok xubij chire: Quinaya' can, y man chic quinanek, rat Satanás. Roma chupan ri ruch'abel ri Dios ri tz'ibatel can, nubij: Xaxe c'a ri Kajaf Dios tikaya' ruk'ij, y xaxe chuka' rija' ri tikasamajij, xcha' ri Jesús chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Y can jac'a chuka' ri' tok ri itzel-vinek xuc'uaj ri Jesús, c'a pa tinamit Jerusalem, y c'a ja ri más nej benek-vi chicaj chire ri rachoch ri Dios, chiri' xberuya-vi. Y tok ec'o chic chiri', ri itzel-vinek xubij chire ri Jesús: Tatorij-ka-avi' vave', rat ri yabin chi at Ruc'ajol ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Roma chupan ri ruch'abel ri Dios tz'ibatel can, nubij: Ri Dios xquerutek ri ru-angeles, richin yatquichajij. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Y xcatquili'ej pa quik'a', richin queri' man xtapajq'uij ta (xtachek'ij ta) avaken chuvech abej. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pero ri Jesús xubij chire ri itzel-vinek: Yin can man ninben ta ri narayij rat, y nintejtobej ta ri Dios. Roma ri ruch'abel ri Dios nubij chi man tikatejtobej ri Kajaf Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Y tok ri itzel-vinek man jun chic xril richin nuben chire ri Jesús, richin nimacun ta, xuya' can ca'i-oxi' k'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Y ri Jesús xtzolin pa ruvach'ulef Galilea, y nojinek ránima riq'uin ri ruchuk'a' ri Lok'olej Espíritu. Y pa conojel c'a tinamit ri ec'o-pe chunakaj ri Galilea, xapon rutzijol ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Y rija' nuc'ut c'a ri ruch'abel ri Dios pa tak jay ri can richin vi niquimol-qui' richin nicac'axaj ri ruch'abel ri Dios, ri achique tinamit napon-vi. Y ri vinek c'a ri ye'ac'axan ri nubij, niquiyala' c'a janíla ruk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ri Jesús xbe pa Nazaret, ri tinamit ri xq'uiy-vi. Y chupan ri uxlanibel-k'ij, rija' xbe c'a chupan ri jay ri can nitzijox-vi ri ruch'abel ri Dios, can achi'el vi tuben. Y tok c'o chic chiri', rija' xpa'e' c'a, richin nusiq'uij ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Y c'o c'a jun vuj ri rutz'iban can ri Isaías, ri jun ri xk'alajirisan ri ruch'abel ri Dios ojer can. Jac'a vuj re' xjach pa ruk'a' ri Jesús, richin nusiq'uij chiquivech ri vinek ri quimolon-qui' chiri'. Y tok ri Jesús xuric'-ka ri vuj ri', xril c'a ri nubij-vi: ");
INSERT INTO cakCNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ri Lok'olej Espíritu richin ri Ajaf Dios, c'o viq'uin yin, roma can xirucha-vi-pe richin ninbij ri utzilej ch'abel richin colotajic chique ri meba' cánima chuvech ri Dios. Xirutek chuka' pe richin yenvak'omaj vinek ri nik'axon cánima pa ruk'a' ri mac. Xirutek-pe ri Dios richin ninbij chique ri vinek ri ec'o preso pa ruk'a' ri mac, chi yetiquir yecolotej pa ruk'a'. Xitak chuka' pe richin ninben chique ri vinek e achi'el moyi', chi yetzu'un. Y ri Dios xirutek chuka' pe richin yencol ri vinek ri janíla niquitej pokon. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Y xirutek chuka' pe richin ninbij chique ri vinek chi ja tiempo re' tok ri Ajaf Dios nuben ri utzil. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Y ri Jesús xubot c'a can ri vuj ri xusiq'uij chiquivech ri vinek ri ec'o chupan ri jay richin quimolojri'il. C'ari' xuya' can chire jun ri nisamej chiri', y xbetz'uye' c'a richin chi nich'on. Y ri vinek quitzuliben-quitzuliben c'a. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Y rija' xch'on c'a y xubij: Jac'a re chivech rix, re vacami, nibanatej-vi ri rubin can ri Dios chupan re vuj re tz'iban can chike, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Y conojel c'a ri vinek ri quimolon-qui' chiri', janíla xka' chiquivech ri Jesús. Y ri utzilej tak ch'abel ri xerubij ri Jesús chique, can achique la xcac'axaj, roma man jun bey e cac'axalon ta ch'abel achi'el ri xerubij rija' chique. Y ri vinek ri' niquibila' chuka' chiquivech: ¿Man ja ta c'a re' ri ruc'ajol ri José? yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Y ri Jesús xubij chique: Yin can cukul nuc'u'x chi rix nich'ob-ka chuvij: Vi re Jesús re' can nitiquir-vi yerubanala' milagros, man ta xe c'a pa Capernaum yerubanala-vi. Can querubanala' c'a chuka' vave' pa rutinamit. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Y xubij chuka' chique ri quimolon-qui' chiri': Ri nik'alajirisan ri ch'abel ri bin chire roma ri Dios, man c'a niquinimaj ta tok napon pa rutinamit. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Y yin ninbij chi rix ivetaman ri xbanatej tok man xuben ta job oxi' juna' riq'uin nic'aj, pa ru-tiempo ri jun achin kavinak ri xk'alajirisan ri ruch'abel ri Dios ojer can, ri xubini'aj Elías. Can kitzij vi chi janíla e q'uiy ri ixoki' e malcani'a' vave' pan Israel, ri tiempo ri', tok janíla vayjal xpe chuvech re karuvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero ri Dios man xutek ta ri Elías chuto'ic jun malca'n-ixok vave' pan Israel, ri can pa ruruvach'ulef ri Elías c'o-vi. Rija' xutek-el ri Elías riq'uin jun malca'n-ixok c'a pa jun tinamit rubini'an Sarepta. Y re tinamit Sarepta re', c'a chunakaj ri tinamit Sidón c'o-vi-apo. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Y can queri' chuka' xc'ulvachitej quiq'uin ri yava'i' pa ru-tiempo ri Eliseo, ri xk'alajirisan ri ruch'abel ri Dios ojer can. Pa ru-tiempo c'a ri Eliseo, ri chiri' pan Israel can e q'uiy c'a ri e yava'i' riq'uin ri jun yabil rubini'an lepra. Pero ri Dios man xrajo' ta chuka' chi c'o ta jun ri xc'achojirisex chique ri c'o ri yabil ri' chique, xaxe c'a ri Naamán ri xrajo' chi xc'achojirisex y rija' jun achin aj pa ruvach'ulef Siria. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Y ri vinek ri quimolon-qui' chiri' pa jay richin quimolojri'il, tok xcac'axaj ri xubij ri Jesús chique, xyacatej coyoval. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Y xebeyacatej-pe, c'ari' xquelesaj-el chuchi' ri tinamit. Re jun tinamit c'a re' chuva jun juyu' c'o-vi. Romari' ri vinek xquic'uaj c'a ri Jesús c'a pa ruvi' ri juyu' richin nequinima-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero ri Jesús achi'el e man jun ri vinek chuvech. Choj xel-pe chiquicojol ri vinek y xbexule-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","C'ari' ri Jesús xbe-ka pa tinamit Capernaum, ri jun chic tinamit ri c'o pa Galilea. Y chiri' c'a c'o-vi tok xka' ri uxlanibel-k'ij. Y romari' rija' nubij ri ruch'abel ri Dios chique ri vinek ri quimolon-qui' chiri' pa nima-jay ri nitzijox-vi ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Y conojel c'a ri vinek ri quimolon-qui', can achique la xcac'axaj ri tijonic ri xuya' ri Jesús chique, roma ri ruch'abel rija' can nuc'ut chi ri nubij rija' jari' ri c'o chi niban. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Y chiri' pa nima-jay richin quimolojri'il, chiri' chiquicojol ri vinek c'o c'a apo jun achin ri c'o jun itzel espíritu riq'uin. Y ri itzel espíritu ri c'o riq'uin ri achin, riq'uin ronojel ruchuk'a' xch'on. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ri espíritu ri' xubij c'a chire ri Jesús: ¿Achique navajo' chike roj, Jesús aj-Nazaret? ¿Xape c'a richin chi yojaq'uis? Yin vetaman at achique rat y romari' vetaman chi rat can at lok'olej vi y at petenek riq'uin ri Dios, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pero ri Jesús xubij chire ri itzel espíritu: Man chic cach'on. Catel-el. Y ri itzel espíritu ri' xuben c'a chire ri achin achok iq'uin c'o-vi, chi xtzak pan ulef, chiri' chiquicojol ri vinek quimolon-qui'. Y re itzel espíritu re', choj xel-el riq'uin ri achin, y man jun chic xuben can chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Y ri vinek ri quimolon-qui' chiri', xsach quic'u'x tok xquitz'et ri xuben ri Jesús, y niquibila' c'a chiquivech: ¿Achique c'a ruchuk'a' ri ruch'abel re achin re'? Roma can riq'uin uchuk'a' nich'on. Can nuc'ut chi ja ri nubij rija' ri c'o chi niban. Ri itzel tak espíritu can niquinimaj rutzij y ye'el, yecha' ri vinek chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Y ri vinek ri ec'o pa tak lugar ri ec'o-pe chunakaj ri Capernaum, xcac'axaj chuka' ri yerubanala' ri Jesús. Chanin c'a xbiyin rutzijol ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Y chupan c'a ri uxlanibel-k'ij ri', ri Jesús xel c'a pe chiri' pa nima-jay ri can nitzijox-vi ri ruch'abel ri Dios y choj xbe c'a pa rachoch ri jun rutijoxel rubini'an Simón. Y chupan c'a ri k'ij ri' ri rujite' ri Simón, yava' riq'uin jun nimalej c'aten. Y ri ec'o chiri' pa jay xquic'utuj utzil chire ri Jesús pa ruvi' ri yava'. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Y rija' xluque-ka riq'uin ri yava' y xubij chi tiq'uis-el ri c'aten chirij. Y can xe c'a xubij queri' ri Jesús, can jari' xq'uis-el ri c'aten chirij ri yava'. Y ri ixok ri', can jari' xbeyacatej-pe y xuchop quilixic ri Jesús y ri e benek riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tok xka' yan c'a ka ri k'ij chupan ri jun k'ij ri', conojel c'a ri vinek richin ri tinamit, ri ec'o yava'i' quiq'uin, xequic'uala-apo chuvech ri Jesús. Ri yava'i' ri xequic'uala-apo ri vinek ri', jalajoj c'a ruvech yabil ri noc chique. Y ri Jesús xuya' c'a ruk'a' pa quivi' chiquijujunal ri yava'i'. Rija' xeruc'achojirisaj c'a el. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","E q'uiy c'a chique re yava'i' re' xa man choj ta yabil noc chique. Xa itzel tak espíritu ec'o quiq'uin. Pero ri Jesús xerelesaj chuka' el. Y tok ri itzel tak espíritu ye'el c'a el quiq'uin re yava'i' re', can riq'uin c'a uchuk'a' yech'on y niquibij: Ja rat ri Ruc'ajol ri Dios. Y ri Jesús xeruk'et riq'uin ri ruch'abel y man xuya' ta k'ij chique richin xech'on más. Roma re itzel tak espíritu re' can quetaman chi ja ri Jesús, jari' ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Y tok xseker-pe ruca'n k'ij, ri Jesús xel-el juba' pa tinamit. Rija' xbe ri pa tz'iran ruvach'ulef. Pero ri vinek xebe chucanoxic ri Jesús, y xbequila-pe. Re vinek c'a re' man nicajo' ta chi nibe ri Jesús, rije' xcajo' ta xquik'et-ka. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero ri Jesús xubij chique: Yin c'o chi yibe pa ch'aka' chic tinamit, richin nintzijoj ri utzilej ruch'abel ri Dios ri nich'on chirij tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios, roma xa can romari' tok xitak-pe, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Y can queri' xuben. Ri chiri' pa Galilea, rija' can nutzijoj c'a ri ruch'abel ri Dios ri pa tak nima-jay ri can nitzijox-vi ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Y jun k'ij, tok ri Jesús c'o chiri' chuchi' ri ya' rubini'an Genesaret, janíla c'a vinek xe'apon riq'uin, roma nicajo' nicac'axaj ri ruch'abel ri Dios. Y re vinek re' can janíla vi e q'uiy, romari' niquipitz' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pero rija' chanin xutz'et-apo ca'i' canoas ec'o can chuchi' ri ya', y man jun c'o chiquipan. Roma re cajaf re canoas re' e chapoy tak quer, y ri hora ri' xa quichapon ruch'ajic ri quiya'l chapbel-quer. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Y jun c'a chique re canoas re' richin ri Simón. Y chupan re ru-canoa ri Simón, xoc-vi-el ri Jesús. Y rija' xubij c'a chire ri Simón chi que'oc-apo juba' pa ruvi' ri ya'. Y rija' xtz'uye-ka chiri' pa canoa, y xuchop-pe quitijoxic ri vinek riq'uin ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tok ri Jesús xtane' richin nich'on quiq'uin re vinek re', rija' xubij chire ri Simón: Jo-apo acuchi nim rupan ri ya', y que'iya-ka ri iya'l chapbel-quer. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pero jari' tok ri Simón xubij chire ri Jesús: Tijonel, xcha' chire. Roj junak'a' xojc'ase' richin xekacanoj quer, y xa man jun xkachop. Pero roma c'a can ja rat yabin chi tikaya-ka re ya'l chapbel-quer re pa ya', nikaya-ka. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Y tok xquiya-ka ri quiya'l chapbel-quer, can ec'o na vi. Can janíla c'a quer xe'oc chupan ri ya'l, y romari' ri ya'l xuchop nirak'ach'itej roma ri calal ri quer. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Romari' re achi'a' chapoy tak quer re' xquiben-apo retal chique ri ch'aka' chic cachibil ri ec'o pa jun chic canoa, richin quepe chiquito'ic. Y ri cachibil can xepe na vi chiquito'ic. Y ri ca'i' canoas xequinojisaj chi quer. Romari' re ca'i' canoas re' yebe yan chuxe' ya'. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Y tok ri Simón ri nibix chuka' Pedro chire, xutz'et chi jun milagro ri xbanatej quiq'uin ri quer, rija' xbexuque' chuvech ri Jesús, y xubij chire: Ajaf, yin xa in jun achin aj-mac, man ruc'amon ta c'a chi yac'oje-pe viq'uin, rat ri janíla ak'ij-ac'ojlen. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Quere' xubij ri Simón roma rija' man jun bey rutz'eton chi que ta re' nibanatej. Y can que chuka' ri' conojel ri e benek riq'uin. Rije' can achique la xquina' tok xquitz'et chi janíla quer xequichop ri k'ij ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Y chuka' ri Jacobo y ri Juan, ri e rachibil ri Simón, ri e ruc'ajol ri jun achin rubini'an Zebedeo, can achique la xquina' tok xquitz'et ri xbanatej. Romari' ri Jesús xubij chire ri Simón: Man c'a tisach ac'u'x roma ri xatz'et. Re rubanon-pe at jun achin chapoy-quer, pero re xtibe-apo, xtavetamaj chuka' xque'achop vinek, richin queri' yinquitzekelbej. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Y re achi'a' chapoy tak quer re' xequiq'uen-pe ri qui-canoas c'a chuchi' ri ya'. Re achi'a' re' xquiya' can ri quisamaj y xquitzekelbej-el ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Y tok ri Jesús xapon c'a pa jun tinamit, xapon c'a jun achin riq'uin, jun achin yava' riq'uin ri jun yabil rubini'an lepra. Re achin re', can xe xutz'et ri Jesús, xbexuque' chuvech y xulucuba-ka ri rujolon (ruvi') chuvech. Y xubij chire ri Jesús: Ajaf, yin vetaman chi yatiquir yinac'achojirisaj chire re nuyabil, pero man vetaman ta achique nanojij pa nuvi', xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Y ri Jesús can jari' xuchop-apo ri achin yava' riq'uin ri lepra y xubij chire: Ninvajo' chi yac'achoj. Tiq'uis c'a el re yabil re' chavij, xcha' chire. Y can xe xubij quere' ri Jesús, can jari' xq'uis-el ri ru-lepra ri achin. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ri Jesús xuchilabej c'a el chire re achin re' chi man tutzijoj chique ri vinek ri xbanatej riq'uin. Y xubij chuka' el chire: Vacami xa choj cabiyin pa rachoch ri Dios, richin queri' te'ac'utu-avi' chuvech ri sacerdote. Y can taya' c'a ri nubij chupan ri vuj ri rutz'iban can ri Moisés. Chupan ri vuj ri' nubij ri nic'atzin chi naya' rat, richin nak'alajirisaj chi at ch'ajch'oj chic, xcha-el chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero ri Jesús más c'a xbiyin rutzijol, y janíla c'a vinek niquimol-qui' riq'uin. Ec'o c'a vinek ri yepe riq'uin, nicajo' nicac'axaj ri ruch'abel ri Dios. Y ec'o c'a ch'aka' chic nicajo' chi yec'achojirisex-el roma rija'. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Y rija' jac'a ri pa tz'iran ruvach'ulef nibe-vi, richin chi nuben orar. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Y jun c'a k'ij, ec'o c'a achi'a' fariseos y ec'o chuka' etamanela' chirij ri ley ri xbequic'ulu-qui' ri acuchi c'o-vi ri Jesús. Ec'o c'a chique rije' ri e petenek c'a quela' pa tak tinamit ri ec'o pa Galilea. Ec'o e petenek pa tinamit Jerusalem y pa ch'aka' chic tinamit ri ec'o pa Judea. Re etamanela' y re fariseos c'a re' e tz'uyul-apo chiquicojol ri vinek ri ye'ac'axan ri ruch'abel ri Dios ri nuc'ut ri Jesús chiquivech. Y ri Jesús can c'o ruchuk'a' ri Ajaf Dios riq'uin, richin yeruc'achojirisaj ri yava'i'. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Y c'o c'a jun achin siquirinek uc'uan-apo coma achi'a' chuvech ri ruvarabel. Y rije' xcajo' c'a xe'oc-apo pa jay c'a riq'uin ri Jesús, richin niquiya' ri quiyava' chuvech. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero re achi'a' re' man xetiquir ta xe'oc-apo chupan ri jay, roma janíla e q'uiy vinek quimolon-qui' chiri'. Romari' rije' xquich'ob chi xejote' pa ruvi' ri jay, y xquisol ri ruvi'. Y c'ari' xquikasaj-ka ri varabel ri acuchi li'an-vi-el ri achin siquirinek. Re yava' re' can c'a chuvech ri Jesús xbec'oje-vi-ka, chiri' chiquicojol ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Y tok ri Jesús xutz'et chi ri achi'a' ri e uc'uayon-apo ri achin yava', can quicukuban-vi quic'u'x riq'uin rija', xubij chire ri achin yava': Ri amac xecuyutej. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Can xe xcac'axaj re ch'abel re' ri etamanela' chirij ri ley y ri achi'a' fariseos, re achi'a' re' can jari' xquichop niquich'ob-ka: ¿Achique c'a achin re'? ¿Y achique roma tok nuben chi ja rija' ri Dios? ¿Roma achique ta c'a vinek nicuyun mac? Man jun. Xaxe ri Dios ri nicuyun mac, yecha' c'a pa tak cánima. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero ri Jesús jebel retaman ri niquich'ob ri etamanela', y retaman chuka' ri niquich'ob ri achi'a' fariseos. Romari' rija' xubij chique: ¿Achique c'a roma tok rix nich'ob quere'? ");
INSERT INTO cakCNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Roma vi yin yitiquir ninben chire re jun achin siquirinek re', richin nibiyin-el y nibe, ¿yitiquir ta cami ninbij chuka' chire chi nincuy rumac? ¿Achique nibij rix? ");
INSERT INTO cakCNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Vacami c'a, richin chi rix nivetamaj chi yin ri xinalex chi'icojol can c'o uchuk'a' pa nuk'a' richin nincuy mac, titz'eta' c'a, xcha' rija'. Y jari' tok ri Jesús xubij chire ri achin siquirinek: Ninbij c'a chave: Cayacatej, tac'uaj-el la avarabel y cabiyin chi'avachoch, xuche'ex roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Y ri achin siquirinek, can jari' xpa'e-el. Can chiquivech conojel vinek ri quimolon-qui' chiri' xpa'e-el rija'. Y xuc'ol-el ri ruvarabel ri acuchi cotz'oban-vi-pe, y xbe. Y rija' janíla c'a nuya' ruk'ij-ruc'ojlen ri Dios ri xtzolin-el chirachoch. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Y conojel ri vinek ri quimolon-qui' chiri', xsach quic'u'x, roma man jun bey quitz'eton ta chi queri' nibanatej. Re vinek c'a re' janíla xquiya' ruk'ij-ruc'ojlen ri Dios, y quixibin-qui' niquibij: Chupan re jun k'ij re' xekatz'et milagros ri man jun bey e tz'eton. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ri Jesús xel c'a pe chiri', y xutz'et c'a jun achin moloy-alcaval. Re achin re' rubini'an Leví, y tz'uyul pa jun ch'aquet, nuc'ul can ri alcaval ri nitoj can. Y ri Jesús xubij chire: Quinatzekelbej. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Y jac'ari' tok rija' xbeyacatej-pe ri acuchi tz'uyul-vi, xuya' can ronojel ri c'o chiri', y xrojkaj-el ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Y c'a juba' ri', ri achin rubini'an Leví xuben c'a jun nima-va'in pa rachoch, jun nima-va'in ri can richin vi ri Jesús, pero chuka' xeroyoj ri moloy tak alcaval y chuka' ch'aka' chic vinek. Y conojel c'a re' junan e tz'uyul ri pa mesa riq'uin ri Jesús y ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Y ec'o c'a etamanela' chirij ri ley y ec'o chuka' achi'a' fariseos ri ec'o-apo chiri'. Y re etamanela' y re fariseos re', q'uiy c'a tzij yequibila-apo chiquij ri rutijoxela' ri Jesús. Yequibila' c'a apo chique: ¿Achique roma tok rix yixva-yixuc'ya' quiq'uin re moloy tak alcaval y re ch'aka' chic vinek ri xa e aj-maqui'? yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pero ri Jesús xubij chique ri achi'a' fariseos y ri etamanela': Jun ak'omanel man ja ta ri e utz ri yerak'omaj. Rija' yerak'omaj ri c'o quiyabil. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Y romari' yin man xipe ta chiquicanoxic vinek ri choj quic'aslen. Yin xipe chiquicanoxic ri aj-maqui', ri nic'atzin chi nitzolej-pe quic'u'x riq'uin ri Dios, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Y ri achi'a' fariseos y ri etamanela' chirij ri ley xquic'utuj chire ri Jesús: ¿Achique roma tok ri rutijoxela' ri Juan can quicha'on k'ij richin man yeva' ta, richin yequibanala' oraciones chire ri Dios? Y can que chuka' ri' niquiben ri quitijoxela' ri achi'a' fariseos, pero ri atijoxela' rat man que ta ri' niquiben, xa yeva-ye'uc'ya', xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Y ri Jesús xubij chique: ¿Achique nibij rix? ¿Ruc'amon cami chi rix niben chi man yeva' ta ri e oyon pa jun c'ulubic, tok xa c'a c'o na ri ala' c'a ruc'ulubic quiq'uin? Man ruc'amon ta. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero xtapon ri k'ij tok re ala' re' xtelesex-el chiquicojol, y jari' tok xtiquiben chi man yeva' ta, richin niquiben orar. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chuka' ri Jesús xrucusaj re jun c'ambel-tzij re' chiquivech: Man jun vinek nelesan jun c'ojobel chire jun tziek c'ac'a', y c'ari' nucusaj ta richin nuc'ojoj jun tziek ri xa ri'j chic. Roma vi c'o jun ri nibanon queri', c'ayef. Roma can nuretz-ka ri tziek c'ac'a' richin nrelesaj jun c'ojobel, y re c'ojobel re' xa man nuq'uen ta ri jun rutziak ri xa ri'j chic. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Y que chuka' ri' man jun niyo'on c'ac'a' vino chupan jun tz'un c'ojlibel ri xa ucusan chic. Roma vi queri' niban, y ri tz'un xa man niyukuk ta chic, ri tz'un nibojbo' y niq'uis-el ri vino chupan. Y ri tz'un chuka' man jun chic nic'atzin-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pero chupan jun c'ac'a' c'ojlibel, utz niyaque' c'ac'a' vino, roma can c'a niyukuk na jebel y man nibojbo' ta. Ri vino can niyaque' c'a jebel chupan. ");
INSERT INTO cakCNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Y man jun ri rukumun vino ri c'o yan chic tiempo yaquel, y c'a ta ri' nrajo' ri c'ac'a' vino. Man que ta ri'. Roma xa xtubij: Ri vino ri c'o yan chic tiempo yaquel jari' ri más utz, xticha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pa jun uxlanibel-k'ij, ri Jesús y ri rutijoxela' yek'ax c'a el pa jun ulef ticon ruvech riq'uin trigo. Y ri tijoxela' c'o c'a ruvi-trigo yequich'up-el, y re ruvi' re trigo re' yequibil pa quik'a'. Y jac'a ri ruvech ri trigo, niquitej. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Romari' tok ec'o achi'a' fariseos xquibij chique ri rutijoxela' ri Jesús: ¿Achique c'a roma rix ye'ibil re trigo pan ik'a' re k'ij re'? Re k'ij re', k'ij richin uxlanen y man utz ta richin niban samaj, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Pero ri Jesús xch'on-apo chique, y xubij: ¿Can man jun bey cami itz'eton ri jun tzij ri tz'ibatel can chirij ri xquiben ri David y ri e rachibil, chupan ri ojer can tiempo, tok janíla xenum? ");
INSERT INTO cakCNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ri David xbe chucanoxic vey chiri' pa rachoch ri Dios, y can ja ri lok'olej tak caxlan-vey ri xbejach-pe chire. Rija' xutej ri lok'olej tak caxlan-vey ri', y xuya' chuka' chique ri e benek riq'uin. Y man riq'uin ri', man mac ta ri xquiben. Y ri' xaxe ri sacerdotes c'o quik'a' chire, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Y ri Jesús xubij chuka' chique ri achi'a' fariseos: Ri Rajaf ri k'ij richin uxlanen ja yin, ri xinalex chi'icojol, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pa jun chic c'a k'ij richin uxlanen, ri Jesús y ri rutijoxela' xebe pa jun nima-jay ri can nitzijox-vi ri ruch'abel ri Dios, y xuchop c'a quitijoxic ri quimolon-qui' chiri'. Y chiquicojol ri vinek ri quimolon-qui' chiri', c'o c'a jun achin ri chaki'j ri rajquik'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Roma c'a ri' ec'o chique ri etamanela' chirij ri ley y ec'o chuka' achi'a' fariseos ri quitzuliben ri Jesús, k'alaj ri' vi nuc'achojirisaj ri achin, richin queri' niquisujuj chi ri Jesús xsamej chupan ri jun uxlanibel-k'ij ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero ri Jesús jebel retaman ri ye'ajin chuch'obic re etamanela' y re achi'a' fariseos re'. Y ri Jesús xubij chire ri achin chaki'j ri ruk'a': Cak'ax-pe ri chiri' pa nic'aj. Y ri achin can jari' xyacatej-pe ri acuchi tz'uyul-vi, y xbepa'e' acuchi ri xbix-vi chire roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Xpe c'a ri Jesús xubij chique ri vinek ri ec'o chiri': Vacami ninvajo' c'a ninc'utuj chive: ¿Más cami ruc'amon niban ri utz pa jun uxlanibel-k'ij o ri itzel? ¿Ri nicol jun vinek chuvech ri camic o ri nicamisex? ¿Achique nich'ob rix? xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Y ri Jesús xerutzu' c'a conojel ri quimolon-qui' chiri'. Xch'on chire ri achin ri yava' ruk'a', y xubij: Tayuku' la ak'a'. Y ri achin can xe xuyuk ri ruk'a' achi'el ri xbix chire roma ri Jesús, can jari' xchojmir can ri ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero ri etamanela' chirij ri ley y ri achi'a' fariseos ri ec'o-apo chiri', xe'oyover. Y re achi'a' re' niquitzula-qui', y niquic'utula' chuka' chiquivech achique niquich'ob niquiben chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Y jun k'ij, ri Jesús xbe c'a pa ruvi' ri juyu' richin xberubana' orar. Y junak'a' c'a xc'ase' richin xch'on riq'uin ri Dios pan oración. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Y chupan c'a ri nimak'a' ruca'n k'ij, rija' xeroyoj ri achi'a' ri can yetzekelben-vi richin. Chiquicojol c'a re achi'a' re', xerucha' e cablajuj, y xubij apóstoles chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ri e cablajuj ri xerucha' ri Jesús, ja ri Simón ri xubij chuka' Pedro chire, ri Andrés ri rach'alal ri Simón, ri Jacobo, ri Juan, ri Felipe, ri Bartolomé, ");
INSERT INTO cakCNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ri Mateo, ri Tomás, ri Jacobo ri ruc'ajol jun achin rubini'an Alfeo, ri Simón ri c'o quiq'uin ri achi'a' quibini'an celadores, ");
INSERT INTO cakCNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ri Judas ri rach'alal ri Jacobo, y ri Judas Iscariote ri xc'ayin richin ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Y jac'ari' tok ri Jesús y ri e ru-apóstoles xeka-pe pa ruvi' ri juyu', y xebec'oje-ka quiq'uin ri ch'aka' chic tijoxela' chiri' pa jun tak'aj. Y chiri' janíla chuka' vinek quimolon-qui'. Ec'o vinek e petenek pa tinamit Jerusalem y pa ch'aka' chic tinamit ri ec'o pa Judea, y ec'o chuka' e petenek c'a quela' chuchi-mar, ri c'a quela' pa Tiro y Sidón. Ec'o c'a chique re vinek re' e petenek richin nicac'axaj ri ruch'abel ri Dios ri nutzijoj ri Jesús, y ec'o c'a e petenek richin yec'achojirisex-el roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Y ec'o c'a chuka' vinek ri ec'o pa pokonal pa quik'a' ri itzel tak espíritu ri ec'o quiq'uin. Xe'elesex chuka' el ri itzel tak espíritu ri' roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Y conojel ri vinek e yava'i' nicajo' c'a niquichop-apo ri rutziak ri Jesús, roma rija' c'o uchuk'a' riq'uin richin nuc'achojirisaj ronojel ruvech yabil. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Y can jac'ari' tok ri Jesús xerutzu' ri rutijoxela' y xubij chique: Jebel ruva-ik'ij rix ri meba' ivánima chuvech ri Dios, roma can yixoc-vi pa rajavaren o pa ruk'a' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Jebel ruva-ik'ij rix ri ninum ri ivánima chuvech ri Dios, roma ri Dios xtuben c'a chive chi xtich'uch'u' ri ivánima. Jebel ruva-ik'ij rix ri nok' ri ivánima chuvech ri Dios, roma ri Dios xtujel ri ivok'ej riq'uin tze'en. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Jebel ruva-ik'ij chuka' rix ri yixetzelex coma ri vinek, rix ri yixquelesaj-pe chiquicojol, rix ri yixyok', rix ri itzel yixtz'et roma ja ri nubi' yin ri iniman, y ronojel ruvech tijoj-pokonal re' nicoch' voma yin ri xinalex chi'icojol. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Y tok xtic'ulvachij ronojel re', can quixquicot c'a janíla, y quixropin chuka' roma quicoten, roma nim rajel-ruq'uexel xtic'ul chila' chicaj. Roma xa can que chuka' ri' ri pokonal ri xquic'ovisala' ri achi'a' ri xek'alajirisan ri xbix chique roma ri Dios, ojer can. Rije' xquic'ovisala' pokonal pa quik'a' ri cati't-quimama' re vinek re ye'etzelan ivichin rix vacami. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Y rix beyoma', tok'ex c'a ivech, roma xic'ovisaj yan jun c'aslen janíla jebel chuvech re ruvach'ulef. Jac'a ri k'ij ri e petenek chivij man e que ta chic ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Rix chuka' ri yixva' jebel, tok'ex ivech, roma xtapon c'a ri k'ij tok xtitej vayjal. Rix ri jebel yixtze'en vacami, tok'ex ivech, roma xtapon ri k'ij tok xtoc ri ok'ej iviq'uin, roma ri bis. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Y rix xa tok'ex c'a ivech tok ninimirisex ik'ij coma ri vinek ri can man e richin ta ri Dios. Roma ri quite-quitata' rije' xa xquiya' quik'ij ri xebin chi e k'alajirisey ruch'abel ri Dios y xa man que ta ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pero rix ri ixc'o vave' viq'uin vacami, ri can yinivac'axaj-vi, tivac'axaj c'a re xtinbij chive: Can que'ivajo' c'a ri ye'etzelan ivichin, y xaxe ri utz tibana' chique ri vinek ri yec'ulula'an ivichin. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tic'utuj c'a chire ri Dios chi yerurtisaj ta ri vinek ri yerayin itzel pan ivi', y chuka' man que'imestaj ri pan i-oración ri yebanon chive chi nic'ovisaj tijoj-pokonal. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Y vi c'o c'a jun yixch'ayon, man c'a tiya' ruq'uexel chire. Utz c'a chi niya' chic ivi' pa ruk'a' jun bey. Y vi c'o c'a chuka' jun vinek numej-el jun ak'u', man c'a tabisoj naya' chuka' el jun chic atziak chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Xabachique c'a vinek ri c'o nuc'utuj chave, taya' chire ri nrajo'. Y vi c'o jun vinek ri c'o numej-el chave, man jun bey chic c'a tach'ojij chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Y rix utz tibana' quiq'uin ri vinek, roma rix man c'a nika' ta chivech chi ri vinek itzel quina'oj iviq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Y vi rix xaxe ri vinek ri ye'ajovan ivichin ri ye'ivajo', man c'ayef ta. Roma xabachique vinek nitiquir nibanon queri'. Can que chuka' ri' ri vinek janíla e itzel, yecajo' ri ye'ajovan quichin rije'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Vi rix, xaxe ri vinek ri yebanon utzil chive, xaxe chique rije' niben-vi utzil chuka', man c'ayef ta. Can que chuka' ri' ri vinek janíla e itzel, niquiben utzil chique ri vinek ri yebanon utzil chique rije'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Vi rix niya' jun cosa chire jun vinek pa kajic, roma nivoyobej ri kajbel richin, man c'ayef ta. Roma ri vinek janíla e itzel yequiya-ka pa kajic ri qui-cosas chiquivech rije', richin queri' c'o niquich'ec can chirij. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero rix man tiben queri'. Xa que'ivajo' ri vinek ri ye'etzelan ivichin. Que'itola'. Y tok rix niya' pa kajic jun i-cosa, man c'a tivoyobej ri kajbel richin. Richin queri' nim ri rajel-ruq'uexel ri xtic'ul, y xtik'alajin c'a chi can ix ralc'ual chic ri nimalej lok'olej Dios ri c'o chila' chicaj. Rija' jebel runa'oj quiq'uin ri vinek janíla e itzel, y jebel runa'oj quiq'uin ri man jun bey yematioxin ta. Que c'a chuka' ri' tibana' rix. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tijoyovaj quivech ri vinek, can achi'el ri nujoyovaj kavech roj ri Katata' Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Man jun bey tiben chi ye'itzu' ri vinek xaxe richin chi itzel yixch'on chiquij, y ri Dios man xtuben ta chuka' queri' iviq'uin rix. Man tirayij chi ri vinek c'o chi niquitoj ri itzel tak banobel ri yequibanala', y ri Dios can man xtuben ta chuka' queri' iviq'uin rix. Ticuyu' quimac ri vinek y ri Dios que chuka' ri' xtuben iviq'uin rix. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vi rix riq'uin ronojel ivánima ye'ito' ri vinek riq'uin ri nic'atzin, ri Dios xtuya' chuka' ri rajel-ruq'uexel chive. Ri rajel-ruq'uexel xtuya' chive ri Dios, janíla q'uiy. Can xtupulisaj ri iyaconabal. Y can achi'el ri niben rix quiq'uin ri vinek, can que chuka' ri' xtuben ri Dios iviq'uin rix. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Y ri Jesús xubij c'a chuka' jun c'ambel-tzij chique. Rija' xubij c'a: ¿C'o cami jun moy ri nitiquir ta nuyukej jun chic moy, y man ta yetzak pa tak jul? ");
INSERT INTO cakCNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Y que chuka' ri' man jun c'a tijoxel ri más ta ruk'ij que chuvech ri rutijonel. Man juba'. Xa can c'a nretamaj na ronojel ri nic'atzin, c'ari' junan nuben-el riq'uin ri rutijonel. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Y achique roma tok rat ja ri ti k'ayis c'o pa runak'-ruvech ri avach'alal ri natz'et chanin y man nana' ta ri che' k'atel pa runak'-avech rat? Re c'ambel-tzij re' nubij c'a chi man tikanimirisaj ri rumac jun kach'alal y nikach'utinirisaj-ka ri nimalej tak kamac roj. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Y man c'a tabij chuka' chire ri avach'alal: Taya' k'ij chuve richin ninvelesaj re ti k'ayis k'atel pa runak'-avech, y man naya' ta ka pa cuenta ri che' k'atel pa runak'-avech rat. Re c'ambel-tzij re' nubij c'a chi man tabij chire jun avach'alal chi man chic camacun, tok xa can c'a ja chuka' ri naben rat. Man naya' ta ka pa cuenta ri amac. Xa ca'i' apalej. Nabey na tachojmirisaj-ka ri ac'aslen rat, c'ari' utz nato' ri avach'alal. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Y man jun utzilej che' xtuya' ta itzel tak ruvech. Man jun chuka' che' ri man utz ta, xtuya' ta utzilej tak ruvech. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ri che' netamex ruvech vi utz o man utz ta, roma ri ruvech ri nuya', vi utz o man utz ta. Roma ri k'ayis janíla quiq'uixal man xtiquiya' ta víquix (higo), ni uva. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Y can que c'a ri' ri achin. Ri achin utz, ja ri utz ri nuben y nubij, roma can ja ri utz ri c'o pa ránima. Jac'a ri achin itzel, ja ri itzel ri nuben y ri nubij, roma can ja ri itzel ri c'o pa ránima. Roma jun vinek can jac'a ri c'o pa ránima ri nubij. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Y achique c'a chuka' roma tok rix nibij: Ajaf, Ajaf, yixcha' chuve, y xa man niben ta ri ninbij chive? ");
INSERT INTO cakCNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Romari' ri vinek ri nipe viq'uin, ri nrac'axaj ri nuch'abel y nuben ri ninbij chire, ");
INSERT INTO cakCNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","junan riq'uin ri jun achin ri xupaba' jun rachoch. Nabey, xuben-ka ri jul richin ri ru-cimiento ri jay, y can pan abej xuc'ot-vi-ka re jul re'. C'ari' xuya' ri ru-cimiento ri jay, y xuchop c'a samaj. Y tok c'achojinek chic c'a ri jay, xq'uiy-pe ri raken-ya'. Y re raken-ya' re' xberila' ri jay. Pero ri jay man xsilon ta, man riq'uin chi ri raken-ya' janíla nimarinek, y janíla ruchuk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero ri vinek ri nipe viq'uin richin nrac'axaj ri nuch'abel, y man nuben ta ri ninbij chire, junan riq'uin ri jun achin ri xupaba' jun rachoch, y xa man xuya' ta ru-cimiento. Y tok ri raken-ya' xbeq'uiy-pe, xberila' ri jay. Ri jay ri' xtzak y xq'uis chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tok ri Jesús xtane' chi tzij chiquivech ri vinek, rija' xbe pa tinamit Capernaum. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Y chiri' pa tinamit c'o jun achin Capitán. Y re achin re' c'o jun rusamajel achin ri janíla nrajo', pero yava', y xa jubama niquen yan ka (nicom yan ka). ");
INSERT INTO cakCNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Y tok ri Capitán xrac'axaj c'a chirij ri Jesús, rija' xerutek ch'aka' rijita'k tak achi'a' ri c'o quik'ij, achi'a' israelitas, richin queri' niquic'utuj utzil chire ri Jesús chi tipe juba' richin noruc'achojirisaj can ri rusamajel ri Capitán. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Y tok ri rijita'k tak achi'a' xe'apon riq'uin ri Jesús, janíla c'a xquic'utuj utzil chire. Y xquibij chuka' chire: Can ruc'amon-vi c'a chi naben re jun utzil re' chire ri Capitán. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Roma rija' janíla yojrajo' roj israelitas, y chuka' xuben jun jay ri nikamol-vi-ki', richin nikac'axaj ri ruch'abel ri Dios, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Y ri Jesús xbe c'a chiquij ri rijita'k tak achi'a' ri e takon-pe roma ri Capitán. Y tok ri Jesús y ri e benek riq'uin ye'apon yan c'a chirachoch ri Capitán, rija' xerutek c'a pe ch'aka' chic vinek ri can quetaman ruvech, chuc'ulic ri Jesús. Y ri achi'a' ri' xoquibij c'a chire ri Jesús: Ajaf, ri achin ri oj takayon-pe chi'ac'ulic rubin c'a pe: Ajaf, man c'a taya' más asamaj voma yin, yin xa jun aj-mac y romari' man ruc'amon ta chave chi yatoc pa vachoch. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Y jac'ari' ri xbanon chuve chi can xinna-vi' chi man ruc'amon ta chi can ja yin ri xinapon aviq'uin. Rat xaxe c'a tabij chi nic'achoj ri nusamajel, y xtic'achoj. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Y can vetaman-vi chi queri' xtibanatej, roma yin, can c'o jun ri nibin chuve ri c'o chi ninben. Y chuka' ec'o achi'a' e yo'on pa nuk'a'. Tok ninbij c'a chire jun achin ri c'o pa nuk'a' chi tibe, can nibe-vi; y vi ninbij chuka' chire jun chic chique ri achi'a' ri ec'o pa nuk'a' chi tipe, can nipe-vi chuka'. Y tok ninbij c'a chire ri nusamajel chi tabana' re', can nuben-vi chuka', nicha-pe, xecha' ri achi'a' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Y ri Jesús can achique la xuna' tok xrac'axaj ri xquibij ri achi'a' chire. Can achique la xuna' tok xrac'axaj ri rutakon-el rubixic ri Capitán. Y ri Jesús can jari' xerutzu' ri vinek ri e benek chirij, y xubij c'a chique: Can kitzij ninbij chive, chi ri achin ri takayon-pe rubixic re ch'abel re', can rucukuban-vi ruc'u'x viq'uin. Y man jun c'a nuvinak israelita ri vilon ri can rucukuban ta ruc'u'x viq'uin, achi'el re jun achin re'. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Y tok xetzolin ri vinek ri e takon-pe roma ri Capitán, xquitz'et c'a chi ri achin samajel, y yava' can, man jun chic yabil c'o chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jun chic c'a k'ij, ri Jesús xbe pa jun tinamit rubini'an Naín, y e benek chuka' ri rutijoxela' riq'uin. Y janíla c'a chuka' vinek ri e tzeketel-el chiquij. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tok ri Jesús y ri e benek riq'uin ye'oc yan apo ri pa tinamit Naín, xquitz'et c'a chi c'amon-pe jun caminek richin nemuk can. Re caminek re' jun ala', ral jun malca'n-ixok. Re malca'n-ixok re', xa can xe c'a ri jun ral-ala' ri c'o, y jari' ri benek chumukic ri vacami. Y janíla c'a vinek ri k'ejeloy (k'ijaloy) richin e benek riq'uin richin ri mukunic. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Y tok ri Ajaf Jesús xutz'et ruvech ri ixok ri xquen-el (xcom-el) ri ral, xujoyovaj ruvech, y xubij c'a chire: Man chic c'a catok'. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Y ri Jesús xuchop-apo ri rucáxa ri caminek, y ri e uc'uayon-el richin ri caminek xepa'e-ka chiri'. Y rija' xubij chire ri ala' caminek: Chave rat yich'on-vi. Cayacatej. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Y tok ri Jesús xubij queri', ri caminek ala' xyacatej, y xbetzijon-pe. Y ri Jesús xujech c'a el ri ala' chire ri rute'. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tok ri vinek xquitz'et ri xbanatej, xpe jun xibinri'il quiq'uin janíla. Y xquiya' chuka' ruk'ij-ruc'ojlen ri Dios, y niquibila' c'a: Vacami xbec'ulun-pe jun nimalej achin chikacojol, ri nik'alajirisan ri ruch'abel ri Dios. Vacami ri Dios xutek-pe jun ri niyo'on rutzil chikacojol roj ri rutinamit, xecha' ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Y ri xuben ri Jesús chupan ri k'ij ri', xetamex ri chiri' pa Judea, y xetamex chuka' ri pa tak tinamit ri ec'o-pe chunakaj ri Judea. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Y ri Juan ri Bautista xrac'axaj c'a ronojel, roma ja ri rutijoxela' ri xebetzijon chire. Romari' rija' xeroyoj e ca'i' chique ri rutijoxela', ");
INSERT INTO cakCNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","y xerutek-el riq'uin ri Jesús. Xerutek-el richin xbequic'utuj chire: ¿Can jac'a rat ri Cristo ri oyoben? ¿O xa nikoyobej chic na jun? Queri' xubij-el chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Y ri e rutakon-el ri Juan, xe'apon c'a riq'uin ri Jesús. Y rije' xquibij c'a chire: Ri Juan ri Bautista oj rutakon-pe aviq'uin, richin nokac'utuj chave: ¿Jac'a rat ri Cristo ri oyoben? ¿O xa nikoyobej chic na jun? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Y riq'uin c'a ri ec'o-ka chiri' ri e ca'i' rutijoxela' ri Juan, ri Jesús e q'uiy c'a vinek xeruc'achojirisaj riq'uin ri quiyabil. Xeruc'achojirisala' chuka' vinek riq'uin nimalej tak yabil. Xerelesala' chuka' itzel tak espíritu ri ec'o quiq'uin ch'aka' vinek, y xuben chuka' chique ri moyi' chi xetzu'un. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Y c'ari' ri Jesús xubij chique ri e ca'i' rutijoxela' ri Juan: Vacami quixtzolin, y titzijoj chire ri xitz'et can y xivac'axaj-el re vave'. Te'itzijoj chire achique rubanic tok ri moyi' yetiquir yetzu'un-el, achique rubanic tok ri vinek ri man can ta yetiquir yebiyin roma ri e jetz', yebiyin-el jebel, y achique rubanic tok ri e yava'i' riq'uin ri yabil lepra yec'achoj. Titzijoj chuka' chire ri achique rubanic tok ri man ye'aq'uex ta, yec'achoj, ri caminaki' yec'astej, y ri vinek ri meba' cánima chuvech ri Dios, ninbij ri utzilej ch'abel richin colotajic chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Y tibij chuka' chire chi jun vinek achi'el rija', ri can rucukuban ruc'u'x viq'uin y man jun bey yirumalij ta can, jebel ruva-ruk'ij, xe'uche'ex-el y xebe. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Y tok ri e ca'i' achi'a' ri e rutakon-pe ri Juan xetzolin, ri Jesús xerubila' c'a utzilej tak tzij chirij ri Juan chiquivech ri vinek ec'o chiri'. Y que c'a re' ri nubij ri Jesús chique ri vinek: ¿Achique ri xbe'itz'eta' rix chiri' chupan ri tz'iran ruvach'ulef? ¿Xitz'et cami rix jun achin chiri', ri achi'el aj, ri nibe quela' nibe quela' pa ruk'a' ri cak'ik'? ");
INSERT INTO cakCNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Achique c'a ri xbe'itz'eta' rix chiri'? ¿Xitz'et cami rix jun achin ri jebel tak tziek e rucusan? Man que ta ri'. Ri achi'a' e cucusalon tziek queri', jebel ri ec'o-vi. Rije' yec'oje' pa tak cachoch ri reyes. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Pero achique ri xbe'itz'eta' rix chiri' pa tz'iran ruvach'ulef? ¿Jun achin ri nik'alajirisan ri bin chire roma ri Dios ri xitz'et chiri'? Ja'. Ri achin ri xitz'et chiri' can ja vi ri' ri rusamaj. Pero can c'o c'a chuka' jun chic samaj ri yo'on pa ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Y chirij c'a ri Juan nich'on-vi ri Dios chupan ri ruch'abel ri tz'ibatel can, tok nubij: Xtintek c'a jun achin nabey, richin chi nuchojmirisaj ri bey ri xtapon-vi ri Cristo. Queri' nubij ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Y tivetamaj c'a, chi janipe' achi'a' ri e k'alajirisey ruch'abel ri Dios ri e alaxinek chuvech re ruvach'ulef, man jun c'a ri más ta ruk'ij que chuvech ri Juan ri Bautista. Can nim vi ruk'ij rija'. Jac'a re vacami, can conojel c'a ri ye'oc pa rajavaren o pa ruk'a' ri Dios, can más c'a nima'k quik'ij. Y ri más co'ol chique rije', más nim que chuvech ri Juan. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Y ri chiri' ec'o c'a q'uiy vinek y moloy tak alcaval ri e banon bautizar roma ri Juan. Y tok rije' xcac'axaj ri xubij ri Jesús, xquibij chi ri Dios yalan choj. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Y jac'a ri achi'a' fariseos y ri etamanela' chirij ri ley man xcajo' ta xquic'ul ri can ruch'obon ri Dios chi can quichin chuka' rije'. Rije' man xcajo' ta chi xeban bautizar roma ri Juan. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Y ri Ajaf Jesús xubij: ¿Achique cami ninbij chiquij ri vinek richin re tiempo re'? ¿Y achok iq'uin e junan vi? ");
INSERT INTO cakCNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Re vinek re' xa e junan riq'uin ri jun quetz'anen ri niquiben ri ac'uala' pa tak bey. Re ac'uala' re' riq'uin cuchuk'a' yech'on chiquivech, y niquibij c'a chupan ri quetz'anen: Xojk'ojoman riq'uin xul chivech y man xixxajo' ta roma quicoten. Xkabixaj bix richin bis chivech y man xixok' ta, yecha' ri ac'uala' pa quetz'anen. Y e queri' re vinek re', man jun ri nika' chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Roma tok xoc'ulun ri Juan ri Bautista, rija' man xutej ta caxlan-vey, man xukun ta chuka' ri ruya'al-uva. Jac'a rix xibij chire chi rija' c'o itzel espíritu riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Y tok xinoka' yin, ri xinalex chi'icojol, nintej caxlan-vey, y ninkun chuka' ruya'al-uva. Y rix xibij chuve chi xe va'in ninvajo', y xibij chuka' chi in jun k'abarel, chi in cachibil ri moloy tak alcaval, y in cachibil chuka' ri vinek ri aj-maqui' nibij chique rix. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero ri etamabel richin ri Dios can nik'alajin pa quic'aslen ri vinek ri yeniman richin, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Y c'o c'a jun achin fariseo ri xoyon richin ri Jesús. Xroyoj richin jun va'in ri pa rachoch. Y tok ri Jesús xapon c'a pa rachoch ri achin, xtz'uye' c'a apo ri pa mesa, richin ri va'in. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Y chupan ri tinamit ri', c'o c'a jun ixok ri itzel ruc'aslen. Y re ixok re' xretamaj c'a chi ri Jesús c'o pa rachoch ri jun achin fariseo, romari' rija' xapon chiri'. Y rija' ruc'uan chuka' apo jun c'ojlibel, ri banon riq'uin jun abej rubini'an alabastro. Re c'ojlibel re' c'o-el jun jubulej ak'on chupan. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Y re ixok re' xapon c'a riq'uin ri Jesús, rija' janíla c'a nok'. Y ri ruya'al tak runak'-ruvech re ixok re' yeka-ka chirij raken ri Jesús. Rija' yerusula' c'a raken ri Jesús, riq'uin ri rusmal tak ruvi'. Re ixok re' yerutz'ubala' (yerutz'umala') chuka' ri raken ri Jesús, y xuya' chuka' ri jubulej ak'on chirij ri raken. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Y ri achin fariseo ri xoyon richin ri Jesús, tok xutz'et ri xuben ri ixok, xuch'ob-ka: Vi ta re Jesús can kitzij vi chi k'alajirisey richin ri ruch'abel ri Dios, nunabej ta achique nichapon la raken, y achique chi vinek la ixok la'. Roma la jun ixok la' itzel ri ruc'aslen, xcha-ka pa ránima. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Y ri Jesús xubij chire ri achin fariseo ri xoyon richin: Simón, c'o jun ri ninvajo' ninbij chave. Ri Simón xubij chire: Ajaf, ¿achique c'a ri navajo' nabij chuve? ");
INSERT INTO cakCNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Y ri Jesús xubij chire: Ec'o c'a e ca'i' achi'a' c'o quic'as riq'uin jun achin ri niyo'on mero pa kajic. Jun chique re achi'a' re', vo'o' ciento quetzales ruc'as, y ri jun chic, cincuenta quetzales ruc'as. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero roma c'a re achi'a' re' man yetiquir ta niquitoj ri quic'as, ri achin ri yoyon mero pa kajic chique, xubij chi man chic tiquitoj, xa tiq'uis queri', xcha' chique. Y ri Jesús xubij chuka' chire ri Simón ri fariseo: Vacami c'a tabij chuve, ¿achique c'a chique re e ca'i' achi'a' re' ri más najovan richin ri achin ri niyo'on mero pa kajic? ");
INSERT INTO cakCNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ri Simón xubij: Yin ninbij chi ja ri más q'uiy ruc'as xuben riq'uin. Ja', queri', xcha' ri Jesús chire ri Simón. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Y ri Jesús rutzuliben ri ixok tok xubij chire ri Simón ri fariseo: ¿Natz'et re ixok re'? Yin tok xinoc-pe re vave' pan avachoch, man xaya' ta nuya' ch'ajbel-vaken. Jac'a re ixok re' xeruch'ej re vaken riq'uin ri ruya'al tak runak'-ruvech, y xeruchakirisaj riq'uin ri rusmal tak ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Chuka' tok xinoc-pe man xinatz'ubaj ta (xinatz'umaj ta) richin xinak'ejela' (xinak'ijala'). Jac'a re ixok re', ja ri vaken ri e rutz'uban (e rutz'uman) re jampe' quinoka'. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Rat chuka' man xak'ej ta aceite pa nuvi' tok xinoc-pe. Jac'a re ixok re', can jubulej ak'on ri xuyala' chirij re vaken. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Romari' ninbij chave rat Simón, chi re ixok re' janíla nrajo' ri xcuyun ri rumac. Roma ri janipe' mac ri e rubanalon xecuyutej yan. Jac'a ri xa man q'uiy ta ri rumac ri xecuy, xa man can ta nrajo' ri xcuyun ri rumac. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Y ri Jesús xubij chire ri ixok: Ri amac xecuyutej yan. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Y ri vinek ri e oyon roma ri Simón ri fariseo y junan ec'o riq'uin ri Jesús ri chiri' pa mesa, niquibila' c'a chiquivech: ¿Achique c'a chi achin re'? Roma can yerucuy chuka' mac, yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Y ri Jesús xubij chire ri xten: Xacolotej, roma ri xacukuba' ac'u'x viq'uin. Vacami c'a, catzolin; ri avánima xril yan uxlanen. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ca'i-oxi' k'ij después chire ronojel re', ri Jesús xuchop c'a nibe pa tak nima'k y cocoj tinamit, y chi cablajuj rutijoxela' e benek riq'uin. Y rija' nutzijoj ri utzilej ruch'abel ri Dios ri nich'on chirij tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Y ec'o chuka' ca'i-oxi' ixoki' ri e tzeketel-el chirij. Re ixoki' re', jare' ri e ruc'achojirisan ri Jesús y relesalon itzel tak espíritu quiq'uin. Chiquicojol c'a re ixoki' re' benek ri María, ri nibix chuka' Magdalena chire. Y jac'a riq'uin re ixok re' xe'elesex e vuku' itzel tak espíritu, roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Chiquicojol ri ixoki' ri e tzeketel chirij ri Jesús, benek ri jun ixok ri rubini'an Juana, rixjayil ri jun achin rubini'an Chuza. Y re achin re' jun rusamajel ri Herodes. Chuka' benek ri jun ixok rubini'an Susana. Y ec'o chuka' ch'aka' chic ixoki' ri e benek ri can yeto'on chuka' richin ri Jesús. Re ixoki' re' xequilij ri Jesús y ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Y riq'uin ri Jesús janíla q'uiy vinek xquimol-qui', vinek ri yepe pa ch'aka' chic tinamit. Romari' ri jun k'ij ri', tok janíla chic e q'uiy vinek quimolon-qui' riq'uin, rija' xubij jun c'ambel-tzij chique: ");
INSERT INTO cakCNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","C'o c'a jun achin ri xbejopin ija'tz. Y tok ri achin nijopin chic ija'tz, juba' c'a chire ri ija'tz xka' pa bey, romari' ri vinek yek'ax pa ruvi'. Y riq'uin chic xepe ri aj-xic' tak chicop ri yebe pa cak'ik', xquitej-el ri ija'tz ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Y ch'aka' chic ija'tz xka' cojol tak abej. Re ija'tz c'a re' richin xel-pe, xel-pe. Xa jac'a tok xpe ruvech ri k'ij, xechaki'j-ka, roma man rex ta ri ulef ri xka-vi ri ija'tz. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Y juba' chic ija'tz xka' cojol k'ayis c'o quiq'uixal. Y tok xe'el-pe, junan xeq'uiy quiq'uin ri q'uix. Pero roma ri q'uix janíla xeq'uiy, ri tico'n xejik' pa quik'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Y ri ch'aka' chic c'a ija'tz xka' pa jun utzilej ulef, y jebel xeq'uiy. Y xquiyala' jujun ciento quivech jujun ija'tz, xcha'. Y tok rubin chic ka re' ri Jesús, can riq'uin c'a ruchuk'a' xch'on, y xubij: Ri c'o c'a rac'axabal, can trac'axaj c'a ri xinbij, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Y ri rutijoxela' ri Jesús xquic'utuj c'a chire chi achique c'a ri nrajo' nuk'alajirisaj chiquivech riq'uin re jun c'ambel-tzij re'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Y ri Jesús xubij chique: Man jun bey can ta bin can jebel chirij tok ri vinek yue'oc pa rajavaren o pa ruk'a' ri Dios, pero chive rix yo'on c'a k'ij chi nivetamaj. Jac'a chique ri vinek ri man yeniman ta vichin, riq'uin c'ambel tak tzij yich'on-vi quiq'uin, richin queri' choj niquitzu' y man niquitz'et ta jebel ri niquitzu', y richin chi choj nicac'axaj y man nik'ax ta chiquivech ri nicac'axaj. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Y que c'a re' ri nubij ri c'ambel-tzij ri': Ri ija'tz junan nuben riq'uin ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ri juba' ija'tz ri xka' pa bey, junan riq'uin ri ruch'abel ri Dios tok nac'axex coma ri vinek. Ri itzel-vinek junanin nipe, y nrelesaj-el ri ruch'abel ri Dios pa tak cánima ri vinek ri', richin queri' re vinek re' man tiquinimaj ri Dios, y man quecolotej chuka'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Y ri ija'tz ri xka' can cojol tak abej, can nich'on-vi c'a chirij ri ruch'abel ri Dios ri nac'axex coma ri vinek. Ri vinek ri' can janíla c'a yequicot tok niquic'ul ri ruch'abel ri Dios pa tak cánima. Pero roma c'a ri can man nuq'uen ta ka ruxe' jebel ri ruch'abel ri Dios pa tak cánima, can man niyaloj ta c'a ri quicoten quiq'uin, xa jun ca'i-oxi' oc k'ij cukul quic'u'x riq'uin ri Dios. Y tok yetejtobex c'a, man c'ayef ta richin niquiya' can ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ri ija'tz ri xka' cojol tak k'ayis ri c'o quiq'uixal can nich'on-vi c'a chirij ri ruch'abel ri Dios ri nac'axex coma ri vinek. Pero ri vinek ri' xa yejik' roma ja ri nic'atzin chire ri quic'aslen vave' chuvech re ruvach'ulef ri niquich'ob, yejik' chupan ri quibeyomel y chuka' chupan ri yequirayila'. Y man nivachin ta jebel ri quic'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Y ri ija'tz ri nika' pa jun utzilej ulef, can nich'on-vi c'a chirij ri ruch'abel ri Dios ri nac'axex coma ri vinek. Rije' riq'uin ronojel cánima nicac'axaj y niquiben ri nubij. Jantape' quicukuban quic'u'x riq'uin ri Dios, y nivachin jebel ri quic'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Y man jun chuka' vinek ri nutzij jun k'ak' y c'a ta ri' nrajo' nutz'apej o nuya' ta apo chuxe' ri ruch'at. Man que ta ri' nuben. Ri k'ak' ri' nic'atzin richin nicanox jun c'ojlibel ri nitz'uyubex-vi, richin queri' ri ye'oc-apo pa jay yetzu'un jebel. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Y man jun ri evan can, ri man ta xtek'alajin-pe. Y chuka' man jun ri tz'apen can rij, ri xa man ta nek'alajin-pe y nel-pe chuva-sakil. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Y queri', vi rix nivac'axaj ri ruch'abel ri Dios, tiyaca' c'a ka ri pa tak ivánima. Roma ri can c'o c'a ruyacon pa ránima, can xtuc'ul c'a más. Jac'a ri nac'axan ri ruch'abel ri Dios y xa man nuyec ta ka pa ránima, ri janipe' nuch'ob chi c'o riq'uin, hasta ri' nelesex chire, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Y ri rute' y ri e rach'alal ri Jesús xepe c'a acuchi c'o-vi rija'. Pero man xetiquir ta xe'apon c'a riq'uin apo, roma janíla e q'uiy vinek quimolon-qui' riq'uin ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Y xbix c'a apo chire ri Jesús: Ri ate' y ri e avach'alal at coyoben chuva-jay, e petenek chi'atz'etic. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero rija' xubij: Ja ri vinek ri ye'ac'axan y niquiben ri nubij ri ruch'abel ri Dios, jari' ri nte' y ri e vach'alal, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Y jun k'ij, ri Jesús rachibilan ri rutijoxela', xoc-el pa jun canoa. Y c'ari' xubij chique: Jo' juc'an ruchi-ya'. Y xebe. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Y ri Jesús xver-el, tok quichapon-el bey pa ruvi' ri ya'. Quichapon c'a bey tok xpe jun cak'ik' janíla nim ri chiri' pa ruvi' ri ya'. Romari' ri canoa ri e benek-vi, xuchop ninoj-pe chi ya', y riq'uin ri' man c'ayef ta nibe chuxe' ya' ri canoa. Can pa c'ayeval c'a ec'o-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Xepe c'a ri tijoxela' xquic'asoj ri Jesús, y xquibij chire: ¡Ajaf! ¡Ajaf! Vacami yojquen (yojcom), xecha' chire. Y ri Jesús xyacatej c'a pe, y xubij: Tiq'uis-el ri cak'ik' y titane-ka ri nibolko't ri ya'. Y queri' xbanatej. Ri cak'ik' xq'uis-el, y ri nibolko't ri ya' xtane-ka. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","C'ari' ri Jesús xubij chique ri rutijoxela': ¿Achique roma tok man xicukuba' ta ic'u'x viq'uin? Pero ri tijoxela' quixibin-qui'. Can achique la xquitz'et ri xbanatej, y xquic'utula' chiquivech: ¿Achique c'a chi achin re'? Roma can nich'on chique ri cak'ik' y ri ya', y can niquinimaj rutzij. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Y ri Jesús y ri rutijoxela' xe'apon c'a ri juc'an ruchi-ya', ri chiri' pa jun lugar rubini'an Gadara, ri c'o-apo chuvech ri Galilea. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Y tok ri Jesús xka' can chupan ri canoa, xapon jun achin aj pa tinamit riq'uin. Y re achin re' c'o chic c'a q'uiy tiempo ri ec'o-pe itzel tak espíritu riq'uin. Manek rutziak nrucusaj, ni man nic'oje' ta pa rachoch. Xa ja ri camposanto ri richin ri tinamit ri', ri oquinek rachoch. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Y re achin re', can xe xutz'et ri Jesús, can jari' xbexuque' chuvech. Y can riq'uin c'a ruchuk'a' nich'on-apo chire ri Jesús, y nubij c'a: Rat Jesús ri Ruc'ajol ri nimalej Dios, ¿achique roma tok yinanek? Tabana' jun utzil man quinach'ujirisaj. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ri achin xubij quere' roma ri Jesús xubij chire ri itzel espíritu c'o riq'uin, chi tel-el ri chiri'. Roma q'uiy tiempo c'o-pe re itzel espíritu re' riq'uin. Y roma chuka' ri' ri vinek quichapon e quiximilon ruk'a-raken re achin re' riq'uin ch'ich' y cadenas, pero man e tiquirinek ta chirij. Roma re achin re' yeruk'ej ri cadenas ri e ximiyon richin, y ri itzel espíritu c'o riq'uin nuben c'a chire chi nibe ri pa tz'iran ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Y ri Jesús xuc'utuj c'a chire ri achin: ¿Achique abi'? Y ri achin xubij: Oj janíla nubi', xcha'. Queri' xubij ri achin roma can e janíla ri itzel tak espíritu ri ec'o riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Y re itzel tak espíritu re' janíla xquic'utuj utzil chire ri Jesús, chi vi yerelesaj-el riq'uin ri achin, man c'a querutek-el chupan ri qui-lugar conojel ri itzel tak espíritu, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Y roma chunakaj apo ri lugar ri', pa ruvi' jun juyu', janíla e q'uiy ak yeva', romari' ri itzel tak espíritu xquic'utuj utzil chire ri Jesús chi tuya' k'ij chique richin ye'oc quiq'uin re ak re'. Y ri Jesús xubij chique chi utz. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Y ri itzel tak espíritu can jari' xe'el-el riq'uin ri achin, y xebe'oc quiq'uin ri ak. Conojel c'a ri ak ri' xquichop anin (anen) chuvech jun juyu' pa'el-pa'el, y choj xebeka' pa ya'. Y chiri' xejik'-vi conojel ri ak ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Y ri yeyuk'un quichin ri ak ri', tok xquitz'et ri xc'ulvachitej, xe'anmej; y rije' xbequiyala' can rutzijol ri pa tinamit y ri pa tak juyu' chuka'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Y ri vinek ri xe'ac'axan-pe ri xc'ulvachitej, xepe richin xoquitz'eta'. Tok ri vinek ri' xe'oka' riq'uin ri Jesús, xquitz'et c'a chi ri achin ri xe'elesex ri itzel tak espíritu riq'uin, tz'uyul c'a apo riq'uin ri Jesús. Rucusan rutziak, y man nuben ta chic c'a ri achi'el ri rubanon-pe. Pero ri vinek ri' xa xquixibij-qui' tok xquitz'et re achin re'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Y xtzijox chuka' chique ri kitzij ri xc'ulvachitej. Ronojel re' xtzijox chique coma ri vinek ri can xetz'eton tok xe'elesex ri itzel tak espíritu riq'uin ri achin, roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Riq'uin c'a ri xc'ulvachitej ronojel re', ri vinek ri aj chiri' pa Gadara xquic'utuj c'a utzil chire ri Jesús chi man tic'oje-ka chiri'. Ri vinek ri aj chiri' xquibij quere' roma ri quixibin-qui' janíla. Roma c'a ri' ri Jesús e rachibilan ri rutijoxela' xoc-el pa canoa, richin nibe. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Y ri achin ri xe'elesex ri itzel tak espíritu riq'uin, nuc'utuj c'a utzil chire ri Jesús chi tuya' k'ij chire richin nibe riq'uin. Pero richin chi nitzolin ri achin, ri Jesús xubij c'a chire: ");
INSERT INTO cakCNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Catzolin chi'avachoch, y te'atzijoj ri xuben ri Dios aviq'uin rat, xuche'ex. Y ri achin can xberutzijoj na vi ri chirachoch, y chique conojel ri vinek ri pa rutinamit xutzijoj ri xuben ri Jesús riq'uin rija'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Y tok ri Jesús e rachibilan ri rutijoxela' xtzolin c'a juc'an chic ruchi' ri ya', ri vinek ec'o chiri', riq'uin janíla quicoten xquic'ul-apo, roma ri vinek ri' can jac'a rija' ri coyoben. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Xapon c'a chuka' jun achin rubini'an Jairo. Re achin c'a re' c'o jun rusamaj chupan ri jay ri can nitzijox-vi ri ruch'abel ri Dios y ja rija' ri achi'el tata'aj chiri'. Re achin rubini'an Jairo xbexuque' chuvech ri Jesús, y xuc'utuj utzil chire chi tibe chirij c'a pa rachoch, ");
INSERT INTO cakCNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","roma xa can xe ri jun ti rumi'al c'o, ri c'o la'ek cablajuj rujuna' y niquen yan ka (nicom yan ka). Y tok ri Jesús y ri e benek riq'uin xquichop-el bey richin yebe pa rachoch ri Jairo, janíla e q'uiy vinek xetzeke-el chirij. Y roma can janíla e q'uiy ri vinek ri e benek, man utz ta chic yebiyin. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chiquicojol c'a ri vinek, benek jun ixok yava'. Re ixok re' c'o yan cablajuj juna' nibiyin ruquiq'uel, y man tanel ta. Xuq'uis yan c'a ronojel ru-mero, roma benek chic quiq'uin q'uiy ak'omanela', y man jun chique ri ak'omanela' tiquirinek ta rak'oman ri ruyabil. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ri ixok ri' xjel c'a apo riq'uin ri Jesús, pero ja ri chirij, y xberuchapa' c'a can juba' ri ruchi-rutziak ri Jesús. Y can jari' xtane' nibiyin ri ruquiq'uel. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Y jari' tok ri Jesús xuc'utuj: ¿Achique ri xichapon? Y roma ri conojel niquibij chi man jun quichapon rije', ri Pedro y ri ch'aka' chic tijoxela' xquibij chire ri Jesús: Ajaf, rat navajo' navetamaj achique xachapon. Pero vave' c'ayef richin navetamaj, roma janíla e q'uiy vinek niquipitz'-qui' y niquinimila-qui' chavij, y rat nac'utuj: ¿Achique xichapon? ");
INSERT INTO cakCNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Y jari' tok ri Jesús xubij: C'o jun ri xichapon, roma can xinna' chi c'o jun ri xinc'achojirisaj riq'uin ri uchuk'a' c'o viq'uin, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Y ri ixok tok xutz'et chi xa xnabex, nibaybot (nibarbot) xoxuque' chuvech ri Jesús. Y chiquivech conojel ri vinek xubij-apo chire ri Jesús ri achique roma tok xuchop ruchi-rutziak. Y xubij chuka' chi can xe xuchop ruchi-rutziak ri Jesús, can jari' xc'achoj xuna' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ri Jesús xubij chire: Numi'al, xacolotej, roma xacukuba' ac'u'x viq'uin. Vacami c'a, catzolin; ri avánima xril yan uxlanen, xuche'ex. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Y c'a nich'on na c'a ri Jesús riq'uin ri ixok, tok c'o jun xoka' petenek chirachoch ri Jairo, ri achin ri achi'el tata'aj ri chiri' pa nima-jay ri can nitzijox-vi ri ruch'abel ri Dios. Ri jun ri xpe, xorubij c'a chire ri Jairo: Man chic tac'uaj-el ri Tijonel Jesús, roma ri ti ami'al xa xquen yan (xcom yan). ");
INSERT INTO cakCNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jac'a tok ri Jesús xrac'axaj-pe, xubij chire ri Jairo: Man tuxibij-ri' ri avánima roma ri xobix chave. Tacukuba' c'a ac'u'x viq'uin, y ri ti ami'al xtic'astej, xuche'ex. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Y tok xe'apon c'a chirachoch ri Jairo, ri Jesús xaxe c'a chique ri Pedro, ri Jacobo y ri Juan ri e rutijoxela', y chique ri rute-rutata' ri ac'ual xuya' k'ij richin xe'oc riq'uin ri ti caminek. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Conojel janíla niquibisoj y nicok'ej ri ti xten ri'. Pero ri Jesús xubij chique: Man chic c'a tivok'ej ri ti xten, roma rija' xa man caminek ta, rija' xa nuxlan, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero rije' xa xetze'en chirij ri Jesús, roma quetaman chi xa caminek chic ri ti xten ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Y ri Jesús xuchop ruk'a' ri ti xten caminek, y xubij c'a: Ti xten, cayacatej. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Y ri ti xten can xtzolin na vi pe ri ránima riq'uin, y can jari' xyacatej-pe. Y ri Jesús xubij chi tisuj ruvay. ");
INSERT INTO cakCNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Y ri te'ej-tata'aj can achique la xquina' tok xquitz'et ri xbanatej riq'uin ri calc'ual. Y ri Jesús xubij chique chi man tiquitzijoj ri xbanatej chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ri Jesús xeroyoj c'a ri cablajuj rutijoxela', y xuya' uchuk'a' chique richin yequelesala' conojel quivech itzel tak espíritu, y richin chuka' yequic'achojirisala' yava'i'. Y man xe ta chuka' xuya' uchuk'a' chique, xa can xuya' chuka' k'ij chique richin niquicusaj ri uchuk'a' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Y xerutek c'a el ri rutijoxela' richin xebe chutzijoxic chirij tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios, y richin chuka' yequic'achojirisaj yava'i'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Y ri Jesús xubij chuka' chique: Re nichop-el bey, can man jun c'a tic'uaj. Man tic'uaj ch'ame'y, man tic'uaj pekes (morral), ni vey, ni mero. Y man tic'uaj chic el jun itziak, xa can xe ri icusan-el. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Y ri jay c'a ri yixapon-vi, pa jun tinamit, chiri' quixc'oje-vi-ka. Xa can c'a ja tok yixel na pe chupan ri tinamit ri', utz niya' can ri jay ri xixc'oje-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Y vi ri tinamit ri yixapon-vi xa man yixc'ul ta jebel, xa tiya' c'a can, y titotala' can (tiquirala' can) ri pokolaj ri c'o pa tak ivaken chiquivech ri vinek, richin queri' tiquinabej chi man utz ta ri xquiben, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Y ri tijoxela' xebe na vi. Xebe ri pa tak cocoj tinamit richin xbequitzijoj ri utzilej ch'abel richin colotajic. Y xequic'achojirisala' chuka' yava'i' ronojel lugar ri xek'ax-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Y ri Herodes ri k'atoy-tzij chupan ri tiempo ri', can yerac'axala' c'a ronojel ri yerubanala' ri Jesús. Pero man nril ta c'a achique ri nunimaj, roma ec'o ri yebin chi ri nibanon ri banobel ri' ja ri Juan ri Bautista c'astajinek chic pe. Ri Juan can caminek chic c'a ri tiempo ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ec'o c'a chuka' yebin chi ri Jesús ja ri Elías ri xtzolin-pe. Y ch'aka' chic vinek niquibij c'a chi ri Jesús jun chique ri achi'a' ri xek'alajirisan ri ruch'abel ri Dios ojer can, ri xbec'astej-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Y ri Herodes nubij: ¿Achique cami achin re Jesús re'? Roma q'uiy yenvac'axaj chirij. Pero man ja ta ri Juan ri Bautista, roma ri Juan ja yin xitakon rutzaq'uixic rukul, xcha'. Y ri Herodes xucanola' c'a rubaniquil richin chi xutz'et ta ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Y tok ri e ru-apóstoles ri Jesús xetzolin banoy rusamaj ri Dios, xquitzijola' c'a chire ri Jesús ri xquibanala'. Y ri Jesús xeruc'uaj c'a el ri rutijoxela' ri', y xebe pa jun tz'iran ruvach'ulef. Y re lugar re' richin c'a ri tinamit rubini'an Betsaida. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Y tok ri vinek xequinabej-el ri Jesús y ri rutijoxela', xebe chuka'. Y tok re vinek re' xe'apon riq'uin ri Jesús, rija' jebel xeruc'ul y xubij chuka' chique chirij tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios. Y chuka' xeruc'achojirisala' yava'i'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Y tok xa xkak'ij-ka ri k'ij ri', ri cablajuj tijoxela' xejel-apo riq'uin ri Jesús y xquibij chire: Que'ataka' c'a el re vinek re' richin yebe chucanoxic acuchi yebever-vi, y yebe chuka' chucanoxic quivay pa tak cocoj tinamit y pa ch'aka' chic lugar ri ec'o-pe nakaj. Roma re ojc'o-vi, xa e manek vinek, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jac'a ri Jesús xubij chique ri rutijoxela': Tiya' quivay rix. Y ri tijoxela' xquibij chire ri Jesús: Vave' man q'uiy ta vey c'o richin nikaya' chique, xaxe vo'o' vey y ca'i' quer. Re vinek re' yeva', pero vi yojbe chulok'ic vey, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Roma ri vinek janíla e q'uiy. Y xaxe achi'a' ec'o la'ek vo'o' mil. Y ri Jesús xubij chique ri rutijoxela': Tibana' c'a chique re vinek re' chi quetz'uye' pa tak nic'aj ciento, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Y can que na vi ri' xquiben ri tijoxela', xequitz'uyuba' conojel vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Y ri Jesús xeruli'ej c'a pa ruk'a' ri vo'o' vey y ca'i' quer, xtzu'un chicaj y xumatioxij ri vey y ri quer ri' chire ri Dios. Y ri Jesús xeruper c'a el (xerupir c'a el) ri vey y ri quer, xuya-el chique ri rutijoxela' richin niquiya' chique ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Can conojel c'a jebel xquitej quivay. Can man jun c'a ri man ta jebel xva'. Y c'a c'o na cablajuj chaquech vey y quer xmol can. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Y jun k'ij ri Jesús ruch'aron c'a el ri', roma nuben orar, y ri rutijoxela' can ec'o chuka' riq'uin. Y jac'ari' tok ri Jesús xuc'utuj chique ri rutijoxela': ¿In achique c'a yin niquich'ob ri vinek? ");
INSERT INTO cakCNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Y rije' xquibij chire: Ec'o ri yebin chi rat ja ri Juan ri Bautista. Ec'o ch'aka' chic niquibij chi ja rat ri Elías, ri jun achin ri xk'alajirisan ri xbix chire roma ri Dios ojer can. Y ec'o c'a chuka' ri yebin chi rat jun chique ri ch'aka' chic achi'a' ri xek'alajirisan ri xbix chique roma ri Dios, ri ojer can, y vacami xac'astej-pe chiquicojol ri caminaki', xecha' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Y rija' xuc'utuj c'a chique ri rutijoxela': Y rix ¿achique nich'ob chuvij? xcha' chique. Y ri Pedro can jac'ari' xubij chire ri Jesús: Ja rat ri Cristo, ri takon-pe roma ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero ri Jesús janíla xuchilabej chique ri rutijoxela' chi man tiquitzijoj chi ja rija' ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Y xubij c'a chuka' chique: Yin ri xinalex chi'icojol, c'o chi ninc'ovisaj q'uiy tijoj-pokonal. Y xquinetzelex coma ri rijita'k tak achi'a' ri c'o quik'ij. Xquinetzelex coma ri principal-i' tak sacerdotes y coma ri etamanela' chirij ri ley. Y xquicamisex. Pero pa rox k'ij xquic'astej-pe, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Y c'ari', chique c'a conojel xubij-vi: Vi c'o jun nrajo' nitzekelben vichin, can tubana' c'a achi'el nuben jun ri benek chuxe' ru-cruz. Man nuben ta ri nurayij rija'. Man nupokonaj ta nuc'ovisaj tijoj-pokonal. Vi c'o c'a jun ri nich'obon chi nitiquir nuben queri' k'ij-k'ij, utz nipe viq'uin richin yirutzekelbej. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Roma vi yalan nupokonaj ri ruc'aslen re vave' chuvech re ruvach'ulef, xa man xtril ta c'a ruc'aslen richin jantape'. Jac'a ri man nupokonaj ta ri', stape' napon pa camic voma yin, xa can xtril ruc'aslen richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Roma achique ta c'a nuq'uen-pe chire ri vinek vi nic'oje' ri beyomel richin ronojel re ruvach'ulef riq'uin y re vinek re' xa man nicolotej ta? Xa ruyon c'a nuya-ri' chupan ri camic ri richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Y vi c'o chuka' jun chive rix niq'uix nuk'alajirisaj chi in runiman yin y ri nuch'abel, yin chuka' ri xinalex chi'icojol, xquiq'uix ninbij chi ri jun vinek ri' vichin yin. Queri' xtinben tok xquipe chic jun bey, tok xtik'alajin chi can in Rey vi, y chuka' junan chic nuk'ij-nuc'ojlen riq'uin ri Nata' y e vachibilan-pe ri lok'olej tak ángeles. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Y can kitzij c'a re ninbij chive, chi ri Dios can xtoc'oje' c'a pa kavi' y xtoc jun utzilej Kak'atoy-Tzij. Y ec'o c'a chive rix ri man xquequen ta (xquecom ta), c'a tok quitz'eton chic na can ri', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Y c'o yan la'ek jun semana tic'o can tok ri Jesús xch'on chiquivech ri vinek, c'ari' rija' xerucha' c'a ri Pedro, ri Juan y ri Jacobo richin chi yerachibilaj-el ri nibe pa ruvi' jun juyu' chubanic orar. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Y tok ri Jesús najin chire ri oración, xjalatej ri ruvech, y can que chuka' ri' ri rutziak, xjalatej. Ri rutziak janíla rusakil xuben y niyic'lun. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Y tok ri e oxi' tijoxela' xquitz'et c'a, yetzijon yan chic riq'uin ri Jesús ca'i' achi'a'. Re ca'i' achi'a' re' quibini'an Moisés y Elías, y e rusamajela' ri Dios ri xec'oje' ojer can tiempo. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Re e ca'i' c'a re' ec'o c'a pa jun lok'olej sakil, y yetzijon chirij ri camic ri xtuc'uaj ri Jesús pa Jerusalem. Roma ja samaj ri' ri yo'on-pe chire roma ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Y ri Pedro y ri rachibil, man riq'uin ri janíla quivaran, xquicoch', y xquitz'et c'a ri lok'olej rusakil ri Jesús, y xequitz'et chuka' ri e ca'i' chic achi'a' ri ec'o riq'uin ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Y tok ri ca'i' achi'a' ri' xquichop niquiya' can ri Jesús richin yebe, jari' tok ri Pedro xubij chire ri Jesús: Ajaf, vave' utz kabanon. Tikabana' oxi' tak jay, jun avichin rat, jun richin ri Moisés y jun richin ri Elías. Ri Pedro que c'a ri' xubij-apo y man retaman ta achique roma tok xch'on-apo. Xa ch'obon man ch'obon ri xerubila-apo. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Y c'a nich'on na c'a rija' tok c'o jun sutz' ri xbec'ulun-pe y xerucuch. Y ri tijoxela' xquixibij-qui' tok xquina' chi ec'o chic chupan ri sutz' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Y jac'ari' tok c'o jun ch'abel xcac'axaj chupan re sutz' re', y xubij: Jare' ri Nuc'ajol, y janíla ninvajo'. Tivac'axaj c'a ri rutzij. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Y jac'a tok cac'axan chic ri jun ch'abel ri', tok xquitz'et yan chic, ri Jesús xa ruyon chic c'o. Y ri tijoxela' ri', q'uiy c'a tiempo ri man jun xquitzijoj-vi ri xquitz'et ri chiri' pa ruvi' ri juyu'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Y pa ruca'n k'ij, tok ri Jesús e rachibilan ri e oxi' rutijoxela' xka-pe pa ruvi' ri juyu', can e janíla c'a e q'uiy ri vinek ri xec'ulun-apo. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Y jun achin ri c'o chiquicojol ri vinek, xch'on-apo chire ri Jesús. Tijonel, xcha' c'a apo chire. Yin xaxe jun valc'ual c'o. Ninc'utuj c'a utzil chave chi tatzu' juba', ");
INSERT INTO cakCNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","roma c'o jun itzel espíritu nichapon. Y tok nuchop, nuben c'a chire chi riq'uin ruchuk'a' nich'on, nuben chire chi niyiquic ri ruch'acul, y nuben chuka' chire chi nivokon ruchi'. Re itzel espíritu re' janíla c'a nuben chire re nuc'ajol, y c'arunaj nuya' can tok nuchop. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Romari' xinc'utuj yan utzil chique re atijoxela' chi tiquelesaj re itzel espíritu re' riq'uin ri nuc'ajol, pero xa man yetiquir ta, xcha' ri achin. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Y ri Jesús jari' xubij: Man jun vinek chupan re tiempo re' ri cukul ta ruc'u'x riq'uin ri Dios. Xa conojel e sachinaki'. ¿Nich'ob rix chi yin jantape' yic'oje' iviq'uin, y can jantape' c'o chi yixincoch'? Tac'ama-pe ri ac'ajol vave', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Y tok ri ala' xapon-apo riq'uin ri Jesús, ri itzel espíritu riq'uin ruchuk'a' xuyiquiquej ri ala' y xutorij pan ulef. Ri Jesús xchapon c'a chirij ri itzel espíritu, richin chi tel-el riq'uin ri ala'. Y ri Jesús xucol ri ala' ri' chuvech ri itzel espíritu, y xujech-el chire ri rutata'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Y conojel c'a ri vinek xsach quic'u'x tok xk'alajin chi ri Dios can yalan vi nim. Y tok ri vinek yetzijon c'a chiquivech chirij ri ala' ri xuc'achojirisaj ri Jesús, ri Jesús xubij chique ri rutijoxela': ");
INSERT INTO cakCNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Tivac'axaj c'a jebel re tzij re', y man c'a timestaj: Yin ri xinalex chi'icojol, xquijach pa quik'a' ri vinek, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Y jac'a re tzij re' man xk'ax ta chiquivech ri tijoxela', roma evan chiquivech. Y niquipokonaj c'a niquic'utuj chire ri Jesús achique ri xubij. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Y ri rutijoxela' ri Jesús xquich'ojila' chiquivech ri achique chique rije' ri más nim ruk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero ri Jesús can retaman c'a achique ye'ajin chuch'obic pa tak cánima ri rutijoxela'. Romari' rija' xberuc'ama-pe jun ti ac'ual, y xupaba' riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Y xubij chique ri rutijoxela': Ri yacayon vichin ri pa ránima y can riq'uin quicoten nuc'ul jun ac'ual, jun ri achi'el re', man xe ta xtuc'ul ri ac'ual, xa can xquiruc'ul chuka' yin. Y ri nic'ulun c'a vichin yin, can nuc'ul c'a chuka' ri takayon-pe vichin. Can jac'a ri ivachibil ri más man jun ruk'ij nitz'et rix, xa jari' ri más nim ruk'ij, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Y xpe c'a ri Juan xubij chire ri Jesús: Tijonel, xcha' chire. Roj katz'eton jun achin ri pan abi' rat yerelesala' itzel tak espíritu. Pero roma xa man kachibil ta, xkabij chire chi man chic tuben queri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Y ri Jesús xubij c'a chire ri Juan: Man chic c'a tibij queri' chire. Roma ri man ye'etzelan ta kichin, can kachibil vi ki' quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Y tok xa noka' yan c'a ri k'ij chi ri Jesús nitzolin chila' chicaj, rija' can xuben-el richin xbe ri pa tinamit Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Y ec'o chuka' ri xerutek-el nabey. Y re xetak-el re', xebe pa jun ti tinamit ri c'o pa Samaria, richin xbequicanoj jun jay ri acuchi xte'uxlan-vi ri Jesús y ri e rachibilan-el. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ri vinek aj chiri' man xcajo' ta xquic'ul ri Jesús, roma re vinek re' xquinabej chi xa pa Jerusalem ruchapon-vi-el bey. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tok ri tijoxela' quibini'an Jacobo y Juan xquinabej chi man nic'ul ta coma ri vinek, xquibij chire ri Jesús: Ajaf, ¿navajo' chi nikac'utuj chi tika-pe k'ak' chila' chicaj, richin yeruq'uis re vinek re'? Achi'el xuben ri Elías, ri jun achin ri xk'alajirisan ri ruch'abel ri Dios ojer can, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Y ri Jesús xerutzu' y xchapon chiquij. Y xubij c'a chique: Rix ni man ivetaman ta chi ix richin ri Espíritu richin ri ajovabel. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Roma yin ri xinalex chi'icojol, man xipe ta vave' chuvech re ruvach'ulef chiquicamisaxic vinek, yin xa xipe chiquicolic, xcha'. Y ri Jesús y ri rutijoxela' xebe chic c'a pa jun ti tinamit. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Y tok rije' quichapon chic c'a bey, c'o c'a jun achin ri xbec'ulun-pe, y ja rija' ri xbin chire ri Jesús: Ajaf, yin ninvajo' c'a yatintzekelbej xabacuchi ri yatapon-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Pero ri Jesús xubij chire ri achin: Ri utiva', can c'o-vi quijul acuchi yec'oje-vi; y que chuka' ri' ri aj-xic' tak chicop ri yebe pa cak'ik', can c'o chuka' quisoc. Jac'a yin ri xinalex chi'icojol, can man jun yinuxlan-vi, xcha' chire ri achin ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Y ri Jesús xubij c'a chire jun chic achin: Quinatzekelbej. Pero re achin re' xubij: Ajaf, yin can janíla ninvajo' yibe chavij. Pero taya' c'a k'ij chuve chi ninmuk na el ri nata', c'ari' xquibe chavij. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pero ri Jesús xubij chire re achin re': Ri caminek quemuk c'a coma ri e caminaki' roma ri quimac. Jac'a rat, te'atzijoj chirij tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Y c'o chic c'a jun ri xbin chire ri Jesús: Ajaf, yin ninvajo' yatintzekelbej. Pero nabey, taya' c'a k'ij chuve richin yibech'on na can chique ri nte-nata' y chique ri e vach'alal, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero ri Jesús xubij chire: Ri achin ri nuc'uan richin ri arado, richin nusamajij jun ulef, man utz ta c'a chi nitzu'un can chirij, roma man utz ta nel ri rusamaj. Y que c'a chuka' ri' ri vinek ri niniman richin ri Dios, man utz ta chi nutzu' ri yebanatej can chirij. Roma vi queri' nuben, can man ruc'amon ta chi nisamej pa rusamaj ri Dios y yeruto' ta ri ye'oc pa rajavaren o pa ruk'a' ri Dios, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Y tok e banatajinek chic c'a ronojel re', ri Ajaf Jesús xerucha' c'a ch'aka' chic achi'a' richin yesamej riq'uin. Rija' xerucha' e setenta achi'a', richin xerutek-el chi caca'. Xerutek ri pa tak tinamit y pa ch'aka' chic lugar ri xtapon-vi rija'. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Y ri Jesús xubij c'a chique ri achi'a' ri xerucha': Can kitzij vi chi ri samaj richin nitzijox ri ruch'abel ri Dios, janíla nim; jac'a ri samajela' man e q'uiy ta. Xa e ca'i-oxi' oc. Romari' tic'utuj c'a chire ri Rajaf ri samaj, chi querutaka-pe más samajela' chiquicojol ri vinek ri nic'atzin richin nicac'axaj ri ruch'abel. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Y vacami quixbiyin c'a. Ivetaman c'a ri' chi rix xa achi'el tak carne'l ri yixintek-el chiquicojol ri vinek e achi'el utiva'. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Y man c'a tic'uaj pekes (morral), ni man c'a tic'uaj mero, y man tic'uaj chuka' jun chic c'ulaj xajab. Ni man chuka' quixpataj pa tak bey richin ye'ik'ejela' na can (ye'ik'ijala' na can) vinek. Xa choj quixbiyin c'a acuchi c'o chi yixapon-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Y tok yixapon c'a pa jun jay, ri nabey c'o chi niben, ja ri yixk'ejelon (yixk'ijalon). Y nibij c'a chique: Ja ta c'a ri uxlanen richin ri Dios ri xtic'oje' iviq'uin chupan re jay re'. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Y vi chiri' chupan ri jay ri', ri vinek riq'uin quicoten yixquic'ul-vi richin nicac'axaj ri ruch'abel ri Dios, ri uxlanen richin ri Dios can xtic'oje-vi quiq'uin. Jac'a vi ri vinek xa man jebel ta yixquic'ul richin nicac'axaj ri ruch'abel ri Dios, ri uxlanen man c'a xtic'oje' ta can quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Rix can quixc'oje' c'a ka chupan ri jay ri yixapon-vi y jebel ic'ulic niquiben, titija' y tikumu' ri xtiquisipaj chive. Roma ri samajel can ruc'amon-vi chi nitoj roma ri samaj ri nuben. Y man c'a tijalala' ri jay ri acuchi yixc'oje-vi. Xa can acuchi yixapon-vi pa nabey, chiri' yixc'oje-vi-ka. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Y que chuka' ri' tibana' tok yixapon xabachique tinamit y jebel ic'ulic niban. Can titija' c'a ronojel ri nisipex chive. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Que'ic'achojirisala' c'a chuka' ri yava'i' ri ec'o chiri', y tibij c'a chique: Ri k'ij richin chi rix yixoc pa rajavaren o pa ruk'a' ri Dios, xa nakaj chic c'o-vi-pe chive. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero ja vi yixapon pa jun tinamit ri xa man utz ta ic'ulic niban, quixel c'a el ri pa tak bey richin ri tinamit y tibij c'a chique ri vinek: ");
INSERT INTO cakCNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ri pokolaj richin re tinamit re' ri c'o-el pa kaken, nikatotaj can (nikaquiraj can) chivech, richin queri' tivetamaj chi man utz ta ri xiben chi man xojic'ul ta jebel. Y tivetamaj can chuka' chi ri k'ij richin chi ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios nakaj chic c'o-vi-pe, y rix can xsuj c'a chive, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Y ri Jesús xubij chuka' el chique: Tok ri Dios xtuya-pe ri ruc'ayeval, ri vinek quichin ri tinamit ri man xtiquic'ul ta jebel ri ruch'abel ri Dios ri nibij rix chique, más c'a ri ruc'ayeval ri xtuya' pa quivi' rije' que chuvech ri ruc'ayeval ri xtuya' pa quivi' ri aj-Sodoma. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Romari' ninvok'ej quivech ri ec'o pa tinamit Corazín, y ninvok'ej chuka' quivech ri ec'o pa tinamit Betsaida, roma janíla q'uiy milagros xeban chiquivech y man xquinimaj ta ri ruch'abel ri Dios. Roma xa ta ja ri pa tak tinamit Tiro y Sidón xeban-vi re milagros re', ri vinek aj chiri' xtzolej yan ta pe quic'u'x riq'uin ri Dios, y quicusalon ta chic quitziak richin bis, y quiyolon ta chaj chiquij, richin queri' nik'alajin chi yebison roma janíla ri quimac ri e quibanalon. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero chupan ri k'ij tok xtibanatej ri k'atoj-tzij, ja ri ec'o pa Corazín y ri ec'o pa Betsaida ri más ruc'ayeval xtika' pa quivi', que chiquivech ri aj-Tiro y aj-Sidón. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y ri ec'o pa tinamit Capernaum can niquich'ob chi yebe chila' chicaj riq'uin ri Dios y janíla xtinimirisex quik'ij. Pero xa man que ta ri'. Xa xtikasex quik'ij, roma xa c'a chupan ri lugar ri richin ri tijoj-pokonal xquebeka-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Y achique c'a vinek ri xquixruc'ul jebel richin nrac'axaj ri ruch'abel ri Dios, can ja chuka' yin ri yiruc'ul. Y ri achique c'a chuka' ri xquixetzelan roma ri ruch'abel ri Dios, can ja chuka' yin ri yiretzelaj. Y ri netzelan vichin yin, can ja chuka' ri Dios ri takayon-pe vichin ri nretzelaj, xcha' c'a el ri Jesús chique ri setenta achi'a' ri xerucha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Y tok xetzolin c'a pe re setenta achi'a' re' chire ri samaj ri bin-el chique y xe'oka' riq'uin ri Jesús, janíla yequicot, y xquibij c'a chire: Ajaf, ri itzel tak espíritu can xeniman chuka' chike tok pan abi' rat xojch'on-vi chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Y ri Jesús xubij chique: Ja', can kitzij ri nibij. Roma yin can xintz'et chi ri Satanás xuna' yan chi xch'acatej, roma can achi'el nuben ri coyopa' ri chicaj, queri' xuben rija' tok xtzak-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yin can nuyo'on na vi uchuk'a' chive richin chi yixch'acon chirij ri ruchuk'a' ri itzel-vinek, y chuka' richin chi stape' xque'ipalibela' ta cumatzi' y alacrán ri yeruya' pan ibey, can man jun xtic'ulvachij pa ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero rix man quixquicot xaxe roma ri itzel tak espíritu yixquinimaj. Más quixquicot pa tak ivánima roma can tz'ibatel ri ibi' chila' chicaj riq'uin ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Y chupan c'a ri misma hora ri', ri Lok'olej Espíritu janíla quicoten xuya' pa ránima ri Jesús. Y ri Jesús xubij: Matiox ninya' chave Nata' Dios, rat ri Rajaf ri caj y re ruvach'ulef, roma man xak'alajirisaj ta ri utzilej ach'abel chiquivech ri vinek ri can niquina' chi janíla q'uiy quetaman. Xa ja ri chiquivech ri vinek ri manek más quetaman, xa chiquivech rije' xak'alajirisaj-vi re utzilej ach'abel re'. Can que vi c'a ri' Nata' Dios, roma jari' ri arayibel rat, xcha' ri Jesús pa ru-oración. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Y c'ari' rija' xubij c'a: Ri Nata' Dios can ronojel c'a ruyo'on-pe pa nuk'a'. Y man jun chic c'a etamayon in achique yin, xaxe ri Nata' ri etamayon. Y man jun chuka' etamayon achique ri Nata', xaxe yin ri Ruc'ajol, y ri vinek achok che xtinvajo' xtink'alajirisaj-vi yin, xtretamaj achique c'a ri Nata'. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Y c'ari' ri Jesús xerutzu' ri rutijoxela' y xaxe chique rije' xubij-vi: Jebel ruva-ik'ij rix, roma re yixajin chutz'etic riq'uin ri runak' tak ivech. Y chuka' can jebel ruva-quik'ij ri ch'aka' chic vinek ri yetz'eton ronojel re'. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Y can ninbij c'a chive, chi e q'uiy ri achi'a' xek'alajirisan ri ch'abel ri xbix chique roma ri Dios y ri reyes ri xec'oje' ojer can, janíla xcajo' chi xquitz'et ta ri nitz'et rix vacami, y man xquitz'et ta. Xcajo' ta chuka' xcac'axaj ri nivac'axaj rix re vacami, y man xcac'axaj ta chuka', xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Y c'o c'a jun etamanel chirij ri ley xbeyacatej-pe y xbech'on riq'uin ri Jesús, roma nrajo' nutejtobej ri Jesús. Tijonel, xcha' c'a chire. ¿Achique nic'atzin richin ninben yin richin queri' ninvichinaj ri c'aslen ri man q'uisel ta? xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ri Jesús xubij chire: ¿Achique c'a ri nubij chupan ri ley ri xuya' ri Dios chire ri Moisés? ¿Y achique nik'ax chavech rat? ");
INSERT INTO cakCNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Y ri etamanel xubij chire ri Jesús: Ri ley nubij chi tavajo' ri Dios ri Avajaf. Tavajo' riq'uin ronojel avánima. Tavajo' chupan ri ronojel ri ac'aslen, riq'uin ronojel avuchuk'a', y riq'uin chuka' ri anojibal. Y can achi'el navajo-ka-avi' rat, can que c'a chuka' ri' que'avajo' ri ch'aka' chic. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Y jac'ari' tok ri Jesús xubij chire ri etamanel: Can kitzij ri xabij. Vacami c'a, vi xtaben ronojel re', xtavichinaj c'a ri c'aslen ri man q'uisel ta, xcha' ri Jesús chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero re etamanel re' can xrajo' chi tik'alajin chi can c'o-vi ri nrajo' nretamaj. Romari' rija' xuben chi achi'el man k'axinek ta chuvech ri achique c'a ri' ri ch'aka' chic, ri ruc'amon chi yerajo' achi'el nrajo-ka-ri' rija'. Romari' xuc'utuj-apo chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Y ri Jesús can jac'ari' xutzijoj jun c'ambel-tzij chire ri etamanel: C'o c'a jun achin ri elenek-pe ri pa tinamit Jerusalem y xulan-ka richin nibe-ka c'a pa tinamit Jericó. Pero re achin re' xebe'el-pe elek'oma' chirij ri pa bey, y ri elek'oma' ri' ronojel xquelesaj-el chire. Hasta ri rutziak ri rucusan ri achin xquelesaj can chirij. Ri elek'oma' xebe na vi, pero nabey janíla xquich'ey can. Ri achin xpune' c'a can ri chiri' pa bey achi'el jun caminek. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Y c'o c'a jun sacerdote ri petenek chuka' chupan ri bey ri'. Y tok re sacerdote re' xutz'et chi punul ri achin ri chiri' pa bey, ja chic ri jun ruchi-bey xk'ax-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Y que chuka' ri' jun achin levita, ri yeto'on quichin ri sacerdotes ri pa rachoch ri Dios, petenek chuka' chupan ri bey ri'. Y tok re levita re' xapon chupan ri lugar ri', xutz'et chuka' ri achin, y can achi'el xuben ri sacerdote can que chuka' ri' xuben rija'. Xe xutz'et ri achin punul pa bey, xa ja chuka' ri jun chic ruchi' ri bey xk'ax-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero c'o c'a jun achin aj-Samaria ri petenek chuka' chupan ri bey ri', y c'o c'a chi nic'o riq'uin ri achin punul can pa bey, ri achin ch'ayon can coma elek'oma'. Y tok ri aj-Samaria xutz'et ri achin punul pa bey, janíla xujoyovaj ruvech roma ri rubanon. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Romari' re aj-Samaria re' xjel-apo riq'uin ri achin punul pa bey, xutz'et achique rubanon. Y xerak'omala' ri rusocotajic ri achin riq'uin aceite olivo y vino. Rija' xerupisla' c'a chuka' ri socotajic riq'uin tziek. C'ari' ri achin aj-Samaria, chirij ruquiej rija' mismo xuya-vi-pe ri achin socotajinek y xuq'uen-pe c'a pa jun posada. Y xuchajij c'a ri junak'a' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pa ruca'n k'ij tok ri aj-Samaria nuchop yan chic ri rubey, rija' xrelesaj juba' mero y xuya' can chire ri rajaf ri posada, y xubij chire: Tavilij y tavak'omaj re jun achin re'. Y tok xquitzolin-pe, xtintoj c'a chave ri ch'aka' chic mero ri xtacusaj. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Roma c'a ri', ¿chavech rat achique c'a chique ri e oxi' achi'a' ri can achi'el nrajo-ka-ri' rija', can que chuka' ri' xrajo' ri achin ri xka' pa quik'a' elek'oma'? xcha' ri Jesús chire ri etamanel. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Y ri etamanel xubij: Ja ri achin ri xjoyovan ruvech, xcha'. Y ri Jesús xubij c'a chire ri etamanel: Vacami cabiyin c'a y tabana' achi'el xuben ri achin aj-Samaria. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Y ri Jesús xuchop chic c'a rubey y xapon pa jun ti tinamit. Y chiri' chupan ri ti tinamit ri' c'o c'a ri ixok rubini'an Marta, y ja rija' ri xc'ulun-apo richin ri Jesús pa rachoch. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Re ixok c'a re' c'o c'a jun rach'alal rubini'an María. Y re María re' xtz'uye' c'a chiraken ka ri Jesús, richin queri' nrac'axaj ri ruch'abel ri Dios ri nutzijoj ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Jac'a ri Marta xa man que ta ri' xuben. Rija' xa ch'ujirinek c'a chubanic ri rusamaj. Roma c'a ri' ri Marta xapon riq'uin ri Jesús y xubij chire: Ajaf, ¿man c'a natz'et ta chi re María nuyon in ruyo'on can chuvech re samaj? Tabij c'a chire chi quiruto' juba'. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero ri Ajaf Jesús xubij chire: Marta, rat q'uiy ri nach'ob, y sachinek ac'u'x roma q'uiy ri c'o chi naben. ");
INSERT INTO cakCNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero xaxe jun c'a ri más nic'atzin y más utz, y jari' ri xucha' ri María. Y ri xucha' rija', man jun xtelesan chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Y jun bey c'a, ri Jesús c'o pa jun lugar, y nuben c'a orar. Y tok tanel chic ka, jun c'a chique ri rutijoxela' xubij chire: Ajaf, kojatijoj richin nikaben orar, achi'el ri Juan ri Bautista xerutijoj ri rutijoxela' richin niquiben orar. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Y can jari' tok ri Jesús xubij chique ri rutijoxela': Tok xtiben c'a orar, tibana' c'a jun oración achi'el re': Katata' Dios atc'o chila' chicaj, xtibanatej ta c'a chi conojel ta ri vinek niquiya' ta ak'ij, y man ta xtiquixolk'otij (xtiquixalk'atuj) ri lok'olej abi'. Y xtoka' yan ta c'a ri k'ij tok ja rat ri yatoc Kak'atoy-tzij. Y xe ta c'a ri navajo' rat chi nikaben, can xe ta c'a ri' ri xtikaben, achi'el niquiben ri ec'o aviq'uin chila' chicaj. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Y taya' c'a chuka' ri kavay ri nic'atzin chike ronojel k'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Y can achi'el c'a yekacuy conojel ri vinek ri c'o niquiben chike, que ta c'a ri' xtaben kiq'uin roj, xtacuy ta c'a ri kamac ri nikaben chavech. Y man c'a taya' k'ij chi ri itzel nuben ta chike chi yojtzak pa mac. Can kojacolo' c'a chuvech, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Y ri Jesús xubij c'a chuka' chique ri rutijoxela': Vi jun chive rix napon pa nic'aj-ak'a' pa jun jay ri can etaman-vi ruvech jebel, y nubij ta chire ri rajaf-jay: Tabana' utzil ninjel ta oxi' avay. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Roma c'o jun nu-amigo ri juc'an chic petenek-vi y xoka' viq'uin yin, y yin man jun vey c'o viq'uin richin ninya-apo chuvech. Roma c'a ri' tabana' utzil chuve, xcacha-apo chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Y ri vinek ri nac'utuj-vi-apo ri vey, can c'a pa ruvarabel c'a xtich'on-pe chave y xtubij c'a: Tabana' utzil man quinaya' pa c'ayef, roma ri ruchi-jay xa xintz'apej yan can y ri ac'uala' xa viq'uin yin yever-vi. Romari' man yitiquir ta yiyacatej-el richin chi nenya' can chave ri navajo'. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Y ri Jesús xubij c'a chique ri rutijoxela': Can kitzij vi ninbij chive, chi ri vinek ri nic'utux-apo ri vey chire, neyacatej-pe, pero man roma ta ri can janíla ta e amigo riq'uin ri nic'utun-apo ri vey. Man que ta ri'. Rija' neyacatej-pe y neruya-pe ronojel ri nic'atzin chire, richin chi titane-apo chuc'utuxic. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Y yin ninbij c'a chive rix, xcha' ri Jesús. Tibana' c'a achi'el ri xuben ri achin ri xbec'utun vey. Tic'utuj ri nic'atzin chive y ri Dios xtuya-pe chive. Ticanoj y xtivil ri nivajo'. Tibana' c'a tocar ri ruchi-jay y yixac'axex-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Roma c'a ri', vi can riq'uin ronojel ivánima nic'utuj chire ri Dios, rija' can xtuya-vi-pe chive. Vi rix can nicanoj, can xtivil-vi. Y vi rix xtiben tocar ri ruchi-jay, can xquixac'axex-vi-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Y rix ri ix tata'aj chic, ¿yixtiquir cami niya' jun abej pa ruk'a' jun ivalc'ual, tok ri ac'ual xa jun vey nuc'utuj chive? ¿O niya' ta jun itzel cumetz pa ruk'a', tok re ac'ual xa jun quer nrajo'? ");
INSERT INTO cakCNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O niya' ta chuka' jun alacrán pa ruk'a', tok ri ac'ual xa jun sakmolo' ri nuc'utuj chive? ");
INSERT INTO cakCNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Rix man yixtiquir ta niben queri' chique ri ivalc'ual. Man riq'uin chi rix man can ta utz ina'oj, pero chuka' man jun bey niya' jun cosa itzel. Rix ja ri utz tak cosas ri niya'. C'a ta la' c'a ri aj-chicajil Itata'. Rija' can nuya-vi c'a ri Lok'olej Espíritu chique ri can niquic'utuj, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Y jun k'ij ri Jesús, c'o c'a apo jun achin memurinek pa ruk'a' jun itzel espíritu riq'uin. Y tok ri Jesús xubij chire ri itzel espíritu chi tel-el riq'uin ri achin ri', ri itzel espíritu can xel na vi el, y ri achin ri memurinek xch'on chic jun bey. Y ri vinek ri xetz'eton, can achique la xquina' tok xquitz'et. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero ec'o c'a chuka' chique ri vinek xebin: Ri Jesús c'o ri Beelzebú riq'uin; ri cajaf ri itzel tak espíritu. Y ja ri Beelzebú ri niyo'on uchuk'a' chire richin queri' nitiquir yerelesaj ri itzel tak espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Y ec'o c'a ch'aka' chic vinek, ri xaxe richin niquitejtobej ri Jesús xquibij c'a chire chi tubana' c'a chi c'o ri nibanatej chupan ri caj, richin tuc'utu' chi rija' can ja vi ri Dios ri takayon-pe richin, xecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero ri Jesús retaman c'a ri niquinojila' ri achi'a' ri', romari' xubij chique: Vi ri vinek richin jun ruvach'ulef man yenojin ta y ca'i' quivech niquiben, nipe oyoval chiquicojol. Y re' man utz ta, roma nuben chire ri quiruvach'ulef chi nitzak. Y que chuka' ri' pa jun jay, vi xa yejalajo' chiquivech y yech'aratej, man c'a xtiquic'uaj ta chic qui' junan. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Y que c'a chuka' ri' ri Satanás, man utz ta chi nuben-ka oyoval quiq'uin ri rusamajela'. Roma vi queri' nuben, ri rachibil ruyon niquiya' can y chanin nitzak rija'. Y yin quere' ninbij chive, roma rix nibij chi yin c'o ri Beelzebú viq'uin y romari' tok yitiquir yenvelesaj ri itzel tak espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Rix queri' nich'ob chuvij yin, chi c'o ri Beelzebú viq'uin romari' yitiquir yenvelesaj ri itzel tak espíritu, ¿pero achique c'a nich'ob rix chiquij ri yetzekelben ivichin? ¿Achique yoyon uchuk'a' chique rije' richin yetiquir yequelesaj itzel tak espíritu chuka'? Can jac'a ri yetzekelben ivichin ri yek'alajirisan chi xa man utz ta ri nibij rix. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Y yin can ja vi ri Dios ri yoyon-pe uchuk'a' chuve richin yitiquir yenvelesaj ri itzel tak espíritu. Xa can xoka' yan c'a ri k'ij chi conojel ruc'amon chi niquinimaj rutzij ri Dios y yec'oje' pa rajavaren o pa ruk'a' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Y tok c'o jun achin ri can janíla ruchuk'a', y c'o ronojel tobel ri nic'atzin chire, re achin re' can jebel vi nuchajij ri rachoch, y man jun ri xtelesan ta chire ri c'o riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero tok noc'ulun chic c'a jun achin ri más ruchuk'a' que chuvech rija', nich'acatej, y nelesex chire ronojel ri tobel ri nucusaj y can rucukuban ruc'u'x riq'uin. C'ari' ri achin ri más ruchuk'a' nutalula' c'a ronojel ri xrelesaj-el chire ri achin ri xuch'ec. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Y roma c'a ri', ri man viq'uin ta yin nisamej-vi, xa chuvij yin nisamej-vi. Y ri achique ri man nito'on ta vichin, xa jari' ri niyojon (niyujun) ronojel ri yenben yin. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Y tok c'o jun itzel espíritu nel-el pa ránima jun vinek, re itzel espíritu re' nucanoj uxlanen pa tak lugar tz'iran-tz'iran. Y tok re jun itzel espíritu re' nuna' chi man jun uxlanen nril, nuch'ob-ka: Más utz yitzolin chic pa ránima ri vinek ri xinel-vi-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Y tok re jun itzel espíritu re' nitzolin chic apo pa ránima ri vinek, nril c'a ri ránima ri vinek ri' achi'el jun jay ri meson y chojmirisan can jebel. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Y c'ari' re itzel espíritu re' yeruq'uen c'a pe e vuku' chic itzel tak espíritu ri más e itzel, y conojel c'a re' ye'oc pa ránima ri vinek. Y ri vinek achok iq'uin yec'oje-vi re itzel tak espíritu re', más c'ayef nuben ri ruc'aslen que chuvech ri xuben nabey. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Y tok ri Jesús najin c'a chubixic re tzij re' chiquivech ri janíla vinek ri quimolon-qui' riq'uin, jari' tok c'o c'a jun ixok ri chiri' chiquicojol ri riq'uin ruchuk'a' xbech'on-pe, y xubij c'a: Ri te'ej ri xalan avichin chuvech re ruvach'ulef y xaruq'uiytisaj riq'uin tz'umaj, jebel ruva-ruk'ij, xcha' ri ixok chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Y ri Jesús xubij: Más jebel ruva-quik'ij ri ye'ac'axan ri ruch'abel ri Dios y niquiben ronojel ri nubij ri ruch'abel rija', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Y tok can e janíla c'a ri vinek ri ye'ajin-apo chiquimolic qui' chirij ri Jesús, xpe rija' xubij c'a chique ri vinek ri': Re vinek vacami janíla e itzel y man yinquinimaj ta. Romari' tok nicajo' chi yin ninben jun milagro chiquivech richin yinquinimaj. Pero man ja ta ri nicajo' rije' ri xtic'ulvachitej. Man que ta ri'. Xa can xe ri xc'ulvachitej riq'uin ri jun achin ri xubini'aj Jonás, jun achin ri xk'alajirisan ri xbix chire roma ri Dios ojer can, xaxe ri' ri retal chuka' chique rije'. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ri xuc'ulvachij ri Jonás xuc'ut chiquivech ri vinek ri xec'oje' ojer can chupan ri tinamit Nínive, chi can ja ri Dios takayon-pe richin. Y que c'a chuka' ri' yin ri xinalex chi'icojol, ri xtinc'ulvachij yin xtucusex richin jun retal chiquivech re vinek vacami. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Y tok xtapon c'a ri k'ij richin xtik'at tzij, xtik'at c'a chuka' tzij pa quivi' ri vinek re ec'o vacami. Y xtic'astej c'a pe ri jun reina ri aj-Sabá y xtubij c'a chi man utz ta xquiben re vinek re ec'o vacami, chi man xquinimaj ta. Roma tok xc'ase' ri jun reina ri', janíla nej xbiyin richin queri' xorac'axaj ri etamabel richin ri jun rey richin re Israel, ri xubini'aj Salomón. Y vacami inc'o yin ri más nuk'ij chuvech ri rey Salomón ri xc'oje' ojer can, y xa man yinquinimaj ta ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Y tok can xtapon c'a chuka' ri k'ij richin xtik'at tzij pa quivi' ri vinek ec'o vacami, xquec'astej c'a pe ri vinek aj-Nínive. Ri vinek ri' xtiquibij c'a chi man utz ta xquiben re vinek re ec'o vacami, roma man xinquinimaj ta. Y ri vinek ri xec'oje' pa tinamit Nínive ri ojer can, can xe xcac'axaj ri ruch'abel ri Dios ri xutzijoj ri Jonás chique, can jari' xtzolej-pe quic'u'x riq'uin ri Dios. Y vacami inc'o yin ri más nuk'ij chuvech ri Jonás, y xa man yinquinimaj ta ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Y man jun vinek ri nutzij jun k'ak' y c'a ta ri' nuya' acuchi ri man nik'alajin ta pe, o nuya' ta chuxe' jun cajón. Man jun nibanon queri'. Ri vinek ri nutzij jun k'ak', nutzekeba', richin queri' yerusakirisaj ri ye'oc-apo pa jay. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Y ri runak'-avech chuka' yec'atzin chave achi'el ri k'ak'. Roma vi ri runak'-avech e utz, rat atc'o pa jun sakil. Pero vi ri runak'-avech man e utz ta, rat atc'o pa jun k'eku'n. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Roma c'a ri' tachajij ri ac'aslen, richin queri' ri sakil ri ruyo'on ri Dios pan avánima man tijalatej, y xtek'alajin ta pe chi xa pa k'eku'n chic atc'o-vi. Man taben queri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Roma vi can atc'o pa jun sakil, can man jun c'a ti retal ta ri k'eku'n aviq'uin, y queri' can yatzu'un-vi jebel. Re' can junan vi c'a riq'uin tok tzijon jun k'ak' richin sakil y jebel sek nik'alajin richin yarusakirisaj. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Y tok ri Jesús xtane' c'a ka richin nitzijon chiquivech ri vinek, c'o c'a jun chique ri achi'a' fariseos xubij chire ri Jesús chi tubana' utzil nibe ta juba' ri pa rachoch, richin nutej jun ruvay. Y ri Jesús can xbe na vi. Rija' xapon, y xbetz'uye' ri pa mesa. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Y ri achin fariseo, can achique la xutz'et ri Jesús, roma xtz'uye-apo ri pa mesa y man xuch'ej ta ruk'a' achi'el rubanic ruch'ajic quik'a' ruc'ulun chique conojel. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Y ri Ajaf Jesús xutz'et ri nuch'ob ri fariseo ri xoyon richin, y romari' xubij chire: Rix fariseos xa ix achi'el ri lek ri jebel ch'ajch'oj rij y ri rupan xa tz'il-tz'il. Rix can nic'ut c'a chiquivech ri vinek chi utz ri ibanobal, pero ri pa tak ivánima man que ta ri', roma xa nojinek riq'uin elek', y nojinek riq'uin etzelal. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Man jun bey ix nacanek. ¿Can man ivetaman ta c'a chi ri xbanon re kach'acul, xuben chuka' pe jun kánima? ");
INSERT INTO cakCNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Roma c'a ri' rix xa ja ri ivánima tich'ajch'ojirisaj, richin queri' tok ch'ajch'ojirinek chic ri ivánima, xtalex c'a pe iviq'uin chi ye'ito' chuka' ri man jun c'o quiq'uin, y xquixch'ajch'ojir c'a. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Tok'ex ivech rix fariseos! roma rix xaxe ri jubulej tak k'ayis, ri róra (ruda) y ronojel quivech ichaj ri nich'ob. Roma ye'ivelesala' pa lajuj, y jun c'a chire ri' ri niya' chire ri Dios. Xa can xe oc ri' ri ye'ich'ob. Y xa man nivajo' ta ri Dios, ni man ix choj ta chuka' quiq'uin ri vinek. Y xa ja ta ri' ri más ruc'amon ibanon, c'a ta ri' ri can yixajin-vi chubanic. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Tok'ex ivech rix fariseos! roma can ja oc ri nabey tak ch'aquet ye'icanola' ri pa tak nima-jay ri can nitzijox-vi ri ruch'abel ri Dios, richin queri' nibix chi janíla ik'ij. Y can janíla chuka' nika' chivech ri yixk'ejelox can (yixk'ijalox can) ri pa bey ri acuchi nequimolo-vi-qui' ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Tok'ex chuka' ivech rix etamanela' quiq'uin ri fariseos ri xa ca'i' ipalej! roma xa ix achi'el ri ulef ri c'o pa quivi' ri caminaki'. Tok re ulef re' xa xsoboso' yan ka y man can ta nik'alajin chic, ri vinek choj chic yek'ax-el pa ruvi'. Can man c'a quetaman ta chi xa pa ruvi' jun caminek yek'ax-vi-el, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pero jun c'a chique ri etamanela' chirij ri ley xubij chire ri Jesús: Tijonel, xcha' rija'. Tok rat nabij queri', man xe ta chic ri fariseos ye'ilon, xa can yojilon chuka' roj. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Y ri Jesús xubij c'a chire ri etamanel ri': ¡Tok'ex chuka' ivech rix ri etamanela' chirij ri ley! roma tok ye'itijoj ri vinek, niya' nimalej tak ejka'n chiquij, ri janíla c'ayef quic'uaxic. Ri ejka'n ri' xaxe c'a chiquij ri vinek niya-vi y rix man nisiloj ta jun ti ruvi-ik'a' richin ta niben y nic'uaj ta ri ejka'n ri nibij chi c'o chi niquic'uaj ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Tok'ex ivech rix etamanela'! roma ja rix ri yixchojmirisan ri tz'ak acuchi e mukul-vi ri achi'a' ri xek'alajirisan ruch'abel ri Dios ojer can, y rije' xa ja ri ivati't-imama' ri xecamisan quichin. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Vacami nik'alajin c'a chi rix can nika' chivech ri itzel ri xequibanala' ri ivati't-imama' ri ojer, roma ja rije' ri xecamisan ri achi'a' ri e richin ri Dios, y rix ye'ichojmirisala' ri tz'ak acuchi e mukul-vi can. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Y roma chuka' ri' ri Dios, roma ri retaman, xubij: Xquentek c'a achi'a' quiq'uin ri nuvinak; achi'a' ri xquek'alajirisan ri ch'abel ri ninbij chique, y xquentek chuka' apóstoles chiquicojol. Pero ri vinek ec'o c'a ri xquequicamisaj, y ec'o ri xtiquiben chique richin niquic'ovisaj pokon, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Romari', xubij ri Jesús, ri Dios pa quivi' re vinek re ec'o vacami xtuya-vi ri quicamic ri achi'a' ri xek'alajirisan ri xbix chique roma ri Dios ri ojer can. Pa quivi' rije' xtika-vi ri quicamic ri achi'a' ri'. Y nitiquir-pe c'a pa rutiquiribel pe re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nitiquir-pe riq'uin ri rucamic ri achin xubini'aj Abel c'a riq'uin ri rucamic ri achin xubini'aj Zacarías. Y jare' ri xcamisex chunakaj ri altar ri c'o chuva-rachoch ri Dios. Roma c'a ri' ninbij chive, chi ri Dios pa quivi' re vinek re ec'o vacami xtuya-vi ri quicamic ri achi'a' e rusamajela' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Tok'ex ivech rix etamanela' chirij ri ley! roma rix ivetaman achique rubaniquil richin chi jun vinek noc richin ri Dios, pero rix man ix oquinek ta richin ri Dios y chuka' ye'ik'et ri vinek ri nicajo' ye'oc richin ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tok ri Jesús xubij ronojel re', ri etamanela' chirij ri ley y ri achi'a' fariseos chuka', xe'oyover janíla. Y roma c'a ri' rije' ronojel c'a niquic'utula-apo chire ri Jesús xaxe richin niquinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ri etamanela' chirij ri ley y ri achi'a' fariseos, can man niquiya' ta c'a can juba' ri Jesús, c'o ta nicajo' chi nicac'axaj chi rija' c'o ta jun ch'abel ri man ruc'amon ta ri nubij y nika' ta pa quik'a', richin chi niquisujuj. Pero ri Jesús can ruyon c'a pa rubeyal ri yerubij. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Y ri vinek xemolotej c'a apo. Pa mil vinek ri xquimol-apo-qui' chiri'. Romari' niquipalibela' chic qui'. Y ri Jesús xuchop c'a tzij quiq'uin ri rutijoxela' nabey, y xubij c'a chique: Tichajij-ivi' chuvech ri ch'en (ch'amilej-k'or) quichin ri achi'a' fariseos. Ri ch'en (ch'amilej-k'or) ri quichin ri achi'a' fariseos ja ri ca'i' quipalej. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Y ronojel ri man k'alajirisan ta xtik'alajin-pe. Y ronojel ri tz'apel can rij, xtel c'a pe pa sakil, y conojel c'a xque'etaman, y conojel chuka' xquetz'eton. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Roma c'a ri' rix, ronojel ri ibilon pa tak evel (eval), ronojel xtek'alajin-pe. Y ronojel c'a ri ibilon pa tak ixiquin ri pa jay, xtetamex na coma ri vinek y xquesiq'uin chubixic ri pa tak ruq'uisibel vik (vek) chique ri jay. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Y roma chuka' ri' ninbij chive rix ri can ix nu-amigos: Man tixibij-ivi' chiquivech ri xaxe oc ri ch'aculaj ri yetiquir niquicamisaj, y tok quicamisan chic ri ch'aculaj man jun chic achique xquetiquir ta xtiquiben. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Y ninbij c'a chive achok chuvech ruc'amon chi nixibij-ivi': Tixibij-ivi' chuvech ri jun ri can nitiquir yixrutek pa k'ak', y man xe ta ri ch'aculaj nucamisaj. Can tixibij c'a ivi' chuvech ri nibanon queri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Y rix chuka' jebel ivetaman chi tok ye'ilok' vo'o' tak aj-xic' chicop, xaxe ca'i' tak centavos cajel. Y man riq'uin chi ri tak aj-xic' chicop ri' man jun oc ri cajel, ri Dios man jun bey yerumestaj ta can. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Y c'a ta la' chic c'a rix. Rix can ajlan-vi ri rusmal tak ivi'. Ri Dios man jun bey yixrumestaj ta can. Ri Dios can janíla yixrajo'. Más yixrajo' que chiquivech ri tak aj-xic' chicop. Roma c'a ri' man tixibij-ivi'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Chuka' ninbij c'a chive, chi xabachique vinek ri nuk'alajirisaj-ri' chi vichin yin, yin c'a chuka' ri xinalex chi'icojol, xtink'alajirisaj chi rija' vichin chic yin. Y re tzij re' can chiquivech ri ru-ángeles ri Dios xtinbij-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jac'a ri vinek ri man nuk'alajirisaj ta ri' chi vichin yin, yin c'a chuka' man xtink'alajirisaj ta ri rubi' chiquivech ri ru-ángeles ri Dios, roma man vichin ta yin ri vinek ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Y xabachique c'a vinek ri niyok'on vichin yin ri xinalex chi'icojol, c'a nicuyutej na rumac. Jac'a ri niyok'on richin ri Lok'olej Espíritu, man c'a xticuyutej ta rumac. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Y vi ja yin ri yininimaj, romari' yixuc'uex chiquivech ri principal-i' pa tak jay ri can richin nitzijox ri ruch'abel ri Dios, y roma chuka' ri' yixuc'uex chiquivech k'atoy tak tzij ri pa tak k'atbel-tzij, man tich'ob janíla achique ri xtibij chique y achique rubanic ch'abel xticusaj richin yixch'on chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Roma tok c'o chi yixch'on-apo, can ja ri Lok'olej Espíritu ri xtiyo'on ch'abel chive richin nibij-apo, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Y chiri' chiquicojol ri janíla vinek ri quimolon-apo-qui', c'o c'a jun ri xch'on-apo y xubij chire ri Jesús: Tijonel, xcha' c'a chire. Tabana' utzil cach'on riq'uin ri vach'alal y tabij chire chi tuya-pe ri verencia ri rubanon-ka richin chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero ri Jesús xubij chire ri achin: ¿Banon cami chuve yin chi in jun k'atoy-tzij pan ivi' rix y chuka' in jun jachoy-herencia chi'icojol? ");
INSERT INTO cakCNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Y ri Jesús xch'on chic c'a chique ri vinek y xubij: Can titzu' c'a ka ivi' jebel richin nichajij ri ic'aslen, richin chi man tipe rayinic pan ivánima chirij ronojel ruvech cosas. Roma stape' janíla q'uiy rubeyomel jun vinek, man ja ta ri' ri xtiyo'on ruc'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Y can jac'ari' tok ri Jesús xuchop rubixic jun c'ambel-tzij, y xubij: C'o c'a jun achin beyon, ri janíla ulef c'o riq'uin. Y jun bey c'a, janíla cosecha ri xumol. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Roma c'a ri' ri beyon ri' xuch'ob-ka pa ránima: ¿Achique ta jun ninben richin queri' ninyec ronojel ri nu-cosecha? Roma man jun chic ninya-vi re ch'aka' chic. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Y tok xch'obotej chuvech, xubij: Más utz quenturu' na el re nuc'ujay tak cocoj, y yenben chic ch'aka' más nima'k. Y chupan re nuc'ujay re' xquenyacala-vi ri c'o viq'uin y ronojel ri nu-cosecha chuka'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Y xtinbij c'a chire ri vánima: Vánima, vacami janíla q'uiy a-cosas ri ayacon, y q'uiy juna' man xtatej ta vayjal. Caquicot c'a, catuxlan, cava' y catuc'ya', xcha' ri beyon chire ri ránima. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero ri Dios xubij chire ri beyon ri': Nacanic chi achin, chupan re ak'a' re' xtinvoyoj-el ri avánima, ¿y ronojel ri abeyomel ri xayec, achique c'a ri xtichinan can? ");
INSERT INTO cakCNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Que c'a ri' ri vinek ri nimolon beyomel richin re ruvach'ulef, y xa man c'o ta ri beyomel richin ri Dios riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Y ri Jesús xubij c'a chique ri rutijoxela': Ninbij c'a chive, chi man tich'ujirisaj-ivi' roma ri achique nic'atzin chive k'ij-k'ij, ri acuchi xtivil-vi ivay y ri acuchi xtiq'uen-vi itziak. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Roma vi ri Dios can xuya-pe ic'aslen chuvech re ruvach'ulef, can nuya' chuka' pe ri ivay richin c'o ic'aslen y ri itziak richin nicuchbej-ivi'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Que'itz'eta' na pe' ri aj-xic' tak chicop quibini'an ko'ch. Re aj-xic' chicop re' man yetico'n ta, y romari' manek cosecha niquelesaj juna-juna', ni manek chuka' quic'ujay richin quiyacon ta quijal. Pero man riq'uin ri' rije' yeva', roma can ja ri Dios ri niyo'on quivay. C'a ta la' c'a rix man ta xtuya' ivay ri Dios, tok rix más ivejkalen que chiquivech ri aj-xic' tak chicop. Xa roma c'a ri' man más tich'ob ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿C'o ta cami c'a jun chive rix ri nitiquir ta nibanon chi niq'uiy chic juba', roma can nuch'ujirisaj-ri' chubanic? Man jun. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Y vi xa jun samaj ri yalan co'ol achi'el re' man yixtiquir ta niben, ¿achique c'a roma tok can nich'ujirisaj-ivi' richin nivil ivay, itziak y ri ch'aka' chic ri yec'atzin chive? ");
INSERT INTO cakCNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Que'itzu' na pe' ri cotz'i'j quibini'an lirio. Que'itzu' na pe' tok yeq'uiy. Rije' man yesamej ta, ni man yebatz'in ta, richin queri' niquibanala' ta quitziak jebel oc. Man jun bey. Y c'o c'a jun rey richin re Israel xc'oje' ojer can ri xubini'aj Salomón. Rija' ruyon jebel tak tziek ri xerucusaj, pero man jun bey xc'oje' ta jun rutziak achi'el titzu'un jun cotz'i'j. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Roma ri cotz'i'j jari' ri tziek ri nuya' ri Dios chique ri k'ayis. Y stape' ri k'ayis man can ta niyaloj, roma jun k'ij jebel rubanon, jun chic k'ij nichaki'j-ka y c'ari' nic'ak pa k'ak'; man riq'uin ri' ri Dios nuvik (nuvek) jebel. Y vi ri Dios can nuvik (nuvek) jebel ri k'ayis, ¿achique c'a roma rix man icukuban ta ic'u'x riq'uin chi nuya' itziak? ");
INSERT INTO cakCNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Romari' rix man tich'ujirisaj-ivi' nicanola' ri ivay-ivuc'ya'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Roma conojel vinek quere' niquiben. Pero rix c'o jun Itata' ri can retaman chic chi jare' ri nic'atzin chive. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Romari' ri ruc'amon chi niben rix ja ri can tiya-ivi' chuxe' rutzij ri Dios. Y vi xtiben c'a queri', ri Dios xtuya' jun ic'aslen jebel, y xtuya' chuka' ri nic'atzin chive. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Roma c'a ri' man tixibij-ivi' rix ri yixtzekelben vichin, roma stape' xa ix juba' oc, can rurayibel vi c'a ri aj-chicajil Itata' chi yixc'oje' pa rajavaren o pa ruk'a' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tic'ayila' c'a ri c'o iviq'uin y tiyala' chique ri vinek ri man jun c'o quiq'uin. Vi que c'a ri' niben, xtic'oje' jun iyaconabal chila' chicaj ri man jun bey xtik'ey, y xtic'oje' chuka' ibeyomel ri man jun bey xtiq'uis. Chila' chicaj man jun elek'on, ni man jun chuka' jut ri nichicopirisan. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Roma ri ivánima can nic'oje' acuchi c'o-vi ri ibeyomel, roma jari' ri nitzekelbej-el. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tichajij c'a ri ic'aslen, y jantape' tic'at ri i-candil. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tibana' c'a achi'el niquiben ri samajela' pa jun jay. Ri samajela' coyoben chi nitzolin-pe ri cajaf benek pa jun c'ulubic, richin queri' tok noka' y noyon-apo, can jari' niquijek ri ruchi-jay chuvech. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Y can jebel c'a ruva-quik'ij ri samajela' ri e q'ues tok xoka' ri cajaf. Y kitzij ninbij chive, chi ri cajaf xtuchojmirisaj-ri' richin nisamej, yerutz'uyuba' ri rusamajela' ri pa mesa y nuya-apo ronojel cosas richin nitij chiquivech. Yerilij-apo jebel roma janíla niquicot chi c'a coyoben na apo ri hora ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Y vi ri cajaf ri samajela' ri' noka' pa nic'aj-ak'a' o ja tok niseker yan pe, ri samajela' ri' jebel ruva-quik'ij roma c'a e q'ues na chiroyobexic ri cajaf ri hora ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Y rix ivetaman, chi vi ta jun rajaf-jay retaman jampe' napon jun elek'on pa rachoch, ri rajaf-jay ri' nic'ase' richin nuchajij ri rachoch, y man nuya' ta k'ij chi ri elek'on nujek-apo ri rachoch richin nelek'-el. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Romari' rix can jantape' c'a quinivoyobej-apo, roma ja tok man ja ta ri' nich'ob, jari' tok xquinoka' yin ri xinalex chi'icojol, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jac'ari' tok ri Pedro xubij chire ri Jesús: Ajaf, ¿rat xatzijoj re c'ambel-tzij re' xaxe chike roj atijoxela', o xatzijoj coma conojel vinek? ");
INSERT INTO cakCNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Y ri Ajaf Jesús xubij: Yin yich'on chique conojel ri e achi'el ri samajel pa jun jay, ri niban chire roma ri rajaf chi nic'oje' pa quivi' ri e aj pa rachoch, richin chi nuya' quivay y richin chi nuya' ronojel ri nic'atzin chique tok napon ri hora. Y vi ri samajel ri' can ta nuben ri bin can chire y utz nuben chire ronojel ri samaj, ¿achique ta cami nuben? ");
INSERT INTO cakCNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Rija' can nuben-vi ri samaj ri bin can chire, y romari' niquicot ránima tok no'ilitej-ka roma ri rajaf y najin chubanic ri samaj. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Can kitzij c'a ninbij chive chi ri rajaf ri samajel ri' xtuya' pa ruvi' ronojel ri c'o riq'uin, richin chi nuchajij. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Jac'a vi ri samajel ri' nuch'ob-ka pa ránima: Ri vajaf ri' xa c'a man jani noka', nicha' ta; y nuchop ta c'a quich'ayic ri ch'aka' chic samajela' achi'a' y ixoki', y xaxe ta va'in nuben, y nuchop rutijic ya' richin nik'aber, y man jun ta chic samaj nuben, ");
INSERT INTO cakCNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","jac'a ri k'ij y ri hora tok man jun nuch'ob chi noka' ta ri rajaf, jari' tok noka'. Ri rajaf can xtuya-vi ruc'ayeval pa ruvi' ri samajel ri' y xtuya' quiq'uin ri ch'aka' chic samajela' ri man yeniman ta tzij. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ri samajel c'a ri etamayon achique nrajo' ri rajaf, pero xa man nuchojmirisaj ta ri' richin nuben ri samaj, ni man nuben ta ri nrajo' ri rajaf, re samajel c'a re' xtika' janíla ruc'ayeval pa ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Jac'a ri samajel ri xa man retaman ta achique ri nrajo' ri rajaf, y c'o ri man utz ta yerubanala-apo, stape' ta re samajel re' ruc'amon ta chi janíla ruc'ayeval nika' pa ruvi', man que ta ri' xtiban chire, ri ruc'ayeval ri xtika' pa ruvi' rija' man can ta xtic'o ruvi'. Roma ri can q'uiy c'a yo'on chire, chuka' can q'uiy c'a ri xtic'utux chire, vi can rubanon o xa man rubanon ta. Chuka' ri can q'uiy ri jachon can pa ruk'a', can q'uiy c'a chuka' ri xtic'utux chire, chi achique c'a ri rubanon riq'uin, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yin can chuya'ic c'a k'ak' re chi'icojol tok xipe chuvech re ruvach'ulef. Y janíla ninrayij chi re k'ak' re' nic'at ta chic. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero nabey nic'atzin c'a chi ninc'ovisaj na tijoj-pokonal, romari' nik'axon vánima re voyoben-apo, y janíla ninrayij chi ic'ovinek ta chic can re jun c'ayevalej bautismo re'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Rix nich'ob chi yin xipe richin nuc'amon-pe quicoten chuvech re ruvach'ulef? Man que ta ri'. Voma yin ec'o ri xtiquijachala-qui'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Romari' re xtibe-apo, vi pa jun jay ec'o e vo'o' vinek, e oxi' xa xqueyacatej c'a chiquij ri e ca'i', o ja ri e ca'i' ri xqueyacatej chiquij ri e oxi'. Pero can man c'a xtiquic'uaj ta qui'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ri tata'aj man xtika' ta c'a chuvech ri nubij ri ruc'ajol. Ni ta c'a ri c'ajolaxel man xtika' ta chuvech ri nubij ri tata'aj. Ni ta c'a ri te'ej man xtika' ta chuvech ri nubij ri ral-xten chire. Y can que c'a chuka' ri' ri xten man xtika' ta chuvech ri nubij ri rute' chire. Y can que c'a ri' ri alite' man xtiquic'uaj ta qui' riq'uin ri rali', roma man junan ta yech'obon, y can ni ta c'a ri alibetz (ali') xtuc'uaj-ri' riq'uin ri ralite'. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Y ri Jesús xubij c'a chuka' chique ri vinek: Rix ivetaman achique titzu'un ri sutz' ri nic'amon-pe job. Y tok nitz'et c'a re sutz' re', chanin nibij chi nipe job. Y can nipe-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y tok nuchop ri cak'ik', jac'a retal re' iyo'on chi nel yan sak'ij. Y can nel-vi sak'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Rix xa ca'i' ipalej, roma jebel ivetaman achique ri nipe tok nitzu' chi c'o sutz' ri chicaj y jebel chuka' ivetaman achique ri nipe xaxe riq'uin nitzu' re ruvach'ulef. Vi ivetaman ri', ¿achique c'a roma tok can man ivetaman ta chuka' achique tiempo re xojoka-vi? ");
INSERT INTO cakCNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Y achique c'a roma tok man pan iyonil ta nivetamaj ri choj ri ruc'amon chi niben rix? ");
INSERT INTO cakCNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Roma vi c'o jun chive ri nisujux pa k'atbel-tzij roma c'o ruc'as riq'uin jun vinek, nutej ruk'ij richin nuchojmirisaj-ri' riq'uin ri vinek ri xsujun chirij, tok xa c'ari' quichapon-el bey pa k'atbel-tzij. Roma vi man nuchojmirisaj ta ri' riq'uin ri vinek achok iq'uin c'o-vi ruc'as, can nuc'uex c'a chuvech ri k'atoy-tzij ri', y ri k'atoy-tzij ri' nujech-el pa ruk'a' ri achin ri nichajin ri cárcel, y ri chajiy-cárcel nuc'uaj-el, richin nutz'apej. ");
INSERT INTO cakCNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Y can kitzij ninbij, chi ri vinek ri noc pa cárcel roma ruc'as, man xtel ta pe chiri' vi man nutoj ta can ronojel ri ruc'as. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Y jec'a k'ij ri' tok ec'o ca'i-oxi' vinek ri xe'apon riq'uin ri Jesús, y rije' xquitzijoj c'a chire chirij ri xquic'ulvachij ch'aka' achi'a' aj pa Galilea. Ri achi'a' cha ri' ec'o c'a pa rachoch ri Dios, y e quic'ualon-apo chicop richin chi yequisuj chire ri Dios. Y jac'a tok ye'ajin chusujic ri chicop chire ri Dios, rije' xebecamisex c'a can. Can etaman c'a chi ri xbanon chi xebecamisex can ri achi'a' ri' ja ri k'atoy-tzij rubini'an Pilato. Ri quiquiq'uel c'a ri chicop y ri quiquiq'uel ri achi'a', xuxol-ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pero ri Jesús xubij chique: ¿Rix nich'ob chi ri achi'a' aj-Galilea ri', queri' xquic'ulvachij roma más e aj-maqui' que chiquivech ri ch'aka' chic e quivinak aj-Galilea? ");
INSERT INTO cakCNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Man que ta ri'. Jac'a rix, vi man xtitzolin ta pe ic'u'x riq'uin ri Dios, xa can xquixapon chuka' chupan ri ruc'ayeval ri xe'apon-vi rije'. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿O rix nich'ob chuka' chi ri e vakxaklajuj ri xequen (xecom) ri chiri' acuchi c'o-vi ri ya' rubini'an Siloé, tok xtzak ri torre chiquij, chi más e aj-maqui' que chiquivech conojel ri ch'aka' chic vinek ri ec'o chiri' pa tinamit Jerusalem? ");
INSERT INTO cakCNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Man que ta ri'. Jac'a rix vi man xtitzolin ta pe ic'u'x riq'uin ri Dios, xa can xquixapon chuka' chupan ri ruc'ayeval ri xe'apon-vi rije'. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Y ri Jesús xuchop c'a rubixic jun c'ambel-tzij chiquivech, y xubij: C'o c'a jun achin ruticon juvi' víquix (higo) ri pa rulef, y xapon chuxe' ri che' chutz'etic vi c'o ruvech. Y ri juvi' víquix ri' xa man jun ti ruvech c'o. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Romari' ri rajaf ri ulef xubij chire ri achin ri samajiy rulef: Oxi' yan c'a juna' re' ri can juna-juna' nontz'eta' re che' re', y man jun bey nutz'eton chi ruyo'on ta jun ti ruvech. Roma c'a ri' más utz tachoyo-el, roma xa man jun ti ruvech nuya'. ¿Achique nic'atzin-vi chi xaxe nuq'uis ruchuk'a' re ulef? ");
INSERT INTO cakCNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero ri samajiy richin ri ulef xubij chire ri rajaf: Taya' na chic c'a can re juna' re'. Tinbana' na c'a rutzil ri ulef ri tiquil-vi y tinya' na k'ayis chuxe'. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Vi nuya' c'a ruvech, utz. Y vi xa man nuya' ta c'a ruvech, c'ari' c'a tachoyo-el, xcha' ri samajiy richin ri ulef. Quere' ri c'ambel-tzij ri xutzijoj ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Y pa jun c'a k'ij richin uxlanen, ri Jesús yerutijoj c'a ri vinek riq'uin ri ruch'abel ri Dios, pa jun jay ri can nitzijox-vi ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Y chiquicojol ri vinek ri quimolon-qui' ri chiri', c'o c'a jun ixok ri c'o yan vakxaklajuj juna' ruchapon-pe yabil. Re ixok c'a re' luculic, y can man nitiquir ta nipa'e' juba' choj. Re ixok re' ruc'ulvachin c'a quere' roma jun itzel espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pero tok ri Jesús xutz'et ri ixok ri', xroyoj y xubij chire: Re vacami jac'are' xacolotej chuvech ri ayabil. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Y xuya' c'a ruk'a' pa ruvi' ri ixok. Y ri ixok can jari' xchojmir, xpa'e' jebel. Y ri ixok can jac'ari' xuya' ruk'ij-ruc'ojlen ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero ri achin ri achi'el jun tata'aj ri chiri' chupan ri jay ri richin ri quimolojri'il, janíla itzel xuna' chire ri Jesús roma xuc'achojirisaj ri ixok chupan ri k'ij ri richin uxlanen. Romari' ri achi'el tata'aj xubij chique ri vinek ri quimolon-qui' ri chiri': Ronojel semana c'o vaki' k'ij richin yojsamej. Y chupan c'a ri k'ij ri' quixpe riq'uin ri Jesús richin yixc'achojirisex, y man ja ta re k'ij re', k'ij richin uxlanen. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pero ri Ajaf Jesús can jari' xubij chire: Rix xa ca'i' ipalej. ¿Man c'a chi'ivonojel ta rix ye'isol-el ri iváquix, ri iquiej pa jun uxlanibel-k'ij, richin yixbe chuya'ic quiya'? Ja', queri' ri niben rix, man riq'uin chi ri chicop man can ta janíla ruk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","C'a ta la' chic c'a re jun ixok re', ri alc'ualan can roma ri Abraham, achi'el rix. Y ri Satanás c'o yan vakxaklajuj juna' ri ruximon-pe. ¿Man ta cami c'a ruc'amon chi nic'achojirisex chupan jun uxlanibel-k'ij? ");
INSERT INTO cakCNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tok ri Jesús rubin chic ka re tzij re', conojel ri ye'etzelan richin, xeq'uixbitej-ka chuvech. Jac'a ri ch'aka' chic vinek janíla niquicot cánima, roma ri Jesús janíla nim ri rusamaj ri Dios najin chubanic. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Y ri Jesús xubij c'a: ¿Achique c'a xtinbij chirij ri rubanic tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios? ¿Achok iq'uin junan vi? ");
INSERT INTO cakCNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yin ninbij c'a chi junan riq'uin ri ija'tz ri richin ri mostaza ri nutic can jun achin ri pa rulef. Tok niq'uiy, can achi'el jun ti che' nitzu'un, can janíla nim. Romari' tok ri aj-xic' tak chicop ri yebe pa cak'ik', ye'apon chupan richin niquiben quisoc ri pa tak ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Y ri Jesús xubij c'a chuka': ¿Achique cami xtinbij chirij ri rubanic tok ri vinek ye'oc pa rajavaren o pa ruk'a' ri Dios? ¿Achok iq'uin junan vi? ");
INSERT INTO cakCNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Xa can junan c'a riq'uin ri ch'en (ch'amilej-k'or) ri neruc'ama-pe jun ixok y nuya' can chupan oxi' pajbel-q'uej, y nuch'amirisaj ronojel, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Y ri Jesús xuchop chic c'a el ri rubey pa tinamit Jerusalem. Pero nabey xbek'ax-pe pa tak nima'k y cocoj tinamit, richin nutzijoj ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Y c'o c'a jun ri xc'utun chire ri Jesús, y xubij chire: Ajaf, ¿e q'uiy cami ri xquecolotej? Pero ri Jesús xa chique c'a conojel xch'on-vi, y xubij: ");
INSERT INTO cakCNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Can titija' c'a ik'ij tinimaj ri ruch'abel ri Dios. Ronojel ri niben rix, can pa ruchojmilal tibana' chuvech ri Dios. Roma ri ruchi-jay ri yixk'ax-vi, janíla latz'. Y janíla c'a e q'uiy ri vinek xticajo' xque'oc chupan ri ruchi-jay ri', pero man xquetiquir ta xque'oc. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Roma tok ri Ajaf xtiyacatej-pe y xtorutz'apej can ri oquibel, rix ri man jani ix oquinek ta apo riq'uin, xquixoyon c'a apo y xtibij: Ajaf, Ajaf, tajaka' ri ruchi-jay chikavech richin chi yojoc-apo. Pero rija' xtubij-pe chive: Man vetaman ta acuchi quixpe-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Y rix xtibila' c'a apo chire: Ja roj ri xojva-xojuc'ya' aviq'uin. Y ja ri pa tak bey richin ri katinamit, chiri' xabij-vi ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jac'a rija' xtubij-pe chive: Xinbij yan chive chi man vetaman ta acuchi quixpe-vi. Man utz ta chi yixc'oje' viq'uin, rix banoy-etzelal, xticha' ri Ajaf. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Y tok xque'itz'et ri achi'a' ri quibini'an Abraham, Isaac, Jacob y conojel ri achi'a' ri xek'alajirisan ri ruch'abel ri Dios ojer can, chi ec'o pa rajavaren o pa ruk'a' ri Dios, jac'ari' tok xtoc ri ok'ej iviq'uin roma ri bis, xtikach'ach'ej ivey roma xixelesex can. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Y xquepe c'a vinek quere' pa jotol, quere' pa xulan, quere' pa relebel-k'ij y quere' pa kajibel-k'ij. Vinek ri quicukuban quic'u'x viq'uin. Y re vinek re' xquec'oje' c'a pa rajavaren o pa ruk'a' ri Dios. Rije' xquetz'uye' c'a apo ri pa mesa. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Y ri chiri' ec'o c'a xtic'oje' quik'ij y ri vacami manek oc quik'ij, y ec'o c'a ri janíla quik'ij vacami, manek oc quik'ij xtic'oje', xcha' c'a ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Y chupan c'a chuka' ri k'ij ri', ec'o achi'a' fariseos ri xe'apon riq'uin ri Jesús, y xquibij chire: Ri Herodes, ri k'atoy-tzij, nrajo' yarucamisaj. Catel c'a el vave' chanin, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero ri Jesús xubij chique ri achi'a' ri': Quixbiyin y tibij chire ri jun k'atoy-tzij ri', ri novinek chubanic ri etzelal, chi yin c'a xquenvelesala' na itzel tak espíritu y can c'a xquenc'achojirisala' na chuka' ri c'o quiyabil. Queri' re vacami, ri chua'k y ri cabij, y c'ari' c'a xtinq'uis can rubaniquil re samaj re'. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yin xa can c'o-vi chi ninchop-el nubey. Queri' re vacami, ri chua'k y ri cabij. C'o chi yinapon ri pa tinamit Jerusalem, roma ri e k'alajirisey ri ruch'abel ri Dios man jun bey ri xquecamisex ta pa jun chic tinamit. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Y c'ari' ri Jesús xch'on c'a chiquij ri vinek ri ec'o pa Jerusalem. Rija' xubij c'a: Aj-Jerusalem, aj-Jerusalem, ¿achique c'a roma tok ye'icamisala' ri achi'a' ri yek'alajirisan ri nibix chique roma ri Dios? ¿Achique c'a roma chuka' tok ye'icamisala' chi abej ri yerutek-pe ri Dios chi'icojol? Y yin, can janíla c'a bey ri xinvajo' chi xixinmol ta viq'uin, achi'el nuben ri quite-ec' chique ri tak ral, yerumol chuxe' ri ruxic'. Man jun bey c'a xivajo' ta rix. ");
INSERT INTO cakCNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Vacami c'a, ri ivachoch chi'ijujunal rix xtic'oje' can achi'el jun tz'iran ruvach'ulef. Y can kitzij chuka' ninbij chive chi man chic c'a xquinitz'et ta chic, can c'a ja tok xtapon na ri k'ij tok xtibij chuve: ¡Matiox chi petenek re Jun re'! ¡Rija' can urtisan-vi-pe roma ri Ajaf Dios! ¡Y petenek pa rubi' ri Ajaf Dios! C'a chupan c'a ri k'ij ri' tok xquinitz'et chic jun bey. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Y pa jun k'ij richin uxlanen, ri Jesús xbe pa rachoch jun quitata'al ri achi'a' fariseos. Ri Jesús oyon c'a roma ri achin ri' richin jun va'in. Y ri ec'o chiri' niquitzula' c'a apo ri Jesús, ");
INSERT INTO cakCNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","roma ri chiri' c'o-apo jun achin yava'. Ri yabil ri noc chire ri jun achin ri', ja ri ya' c'o pa ruch'acul. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Y ri Jesús xubij c'a chique ri etamanela' chirij ri ley y chuka' chique ri achi'a' fariseos ri ec'o chiri': ¿Xajan cami chi nic'achojirisex jun yava' pa jun k'ij richin uxlanen? ¿Achique nibij rix? ");
INSERT INTO cakCNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero ri etamanela' y ri fariseos man jun xquibij. Romari' ri Jesús xuchop-apo ri yava' y xuc'achojirisaj y xubij chire chi tibe. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Y chique ri etamanela' y ri fariseos, ri Jesús xubij: Vi c'o jun chive rix nitzak jun ruquiej o jun ruváquix pa jun jul, ¿man cami junanin ta yixbe chirelesaxic, stape' jun k'ij richin uxlanen? ");
INSERT INTO cakCNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Y ri etamanela' y ri fariseos man xquil ta c'a achique xquibij-apo chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Y xpe ri Jesús xuchop c'a rubixic jun c'ambel-tzij chique ri e oyon pa va'in. Roma xerutz'et ri vinek ri e oyon chi yequichala' quich'acat richin yetz'uye' ri chiri' pa mesa. Romari' xubij c'a chique: ");
INSERT INTO cakCNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Tok c'o c'a jun ri noyon ivichin pa jun c'ulubic, man c'a ticanoj ri nabey tak ch'aquet. Roma riq'uin juba' at tz'uyul chic ri chiri' tok napon jun vinek ri más ruk'ij que chavech rat, ");
INSERT INTO cakCNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","y nipe ri xoyon avichin ri pa c'ulubic, nubij chave: Tabana' utzil taya' can ri ach'acat chire re jun re voyon chuka'. Y rat yaq'uixbitej y at cakarinek yabetz'uye' pa ruq'uisibel tak ch'aquet. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Roma c'a ri' tok c'o jun ri noyon ivichin pa jun c'ulubic, quixtz'uye' ri pa ruq'uisibel tak ch'aquet richin queri' tok yarutz'et-pe ri xoyon avichin, xtoka' c'a aviq'uin rat y xtubij chave: Tabana' utzil cajote-pe vave'. Y tok queri' xtiban chave, conojel c'a ri yetz'uye' aviq'uin ri pa mesa richin va'in xtiquetamaj chi can c'o ak'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Roma c'a ri', ri niquinimirisaj-qui', xa xtikasex quik'ij. Y jac'a ri man nunimirisaj ta ri', xtinimirisex ruk'ij, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Y ri Jesús xubij c'a chuka' chire ri xoyon richin: Tok navajo' c'a chi c'o yepe aviq'uin richin jun va'in, man c'a que'avoyoj xaxe ri avachibil, ri ate-atata', conojel ri e avach'alal, y ri a-vecinos ri e beyoma', roma rije' can yetiquir chuka' yatcoyoj richin jun va'in ri pa cachoch, y riq'uin ri' nac'ul yan el ri rajel-ruq'uexel. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jac'a rat, tok c'o jun nimak'ij pan avachoch, vi ye'avoyoj vinek ri man jun c'o quiq'uin, ri vinek ri man utz ta ri quik'a' o ri caken, o ye'avoyoj ri xa man choj ta yebiyin roma ri e jetz' y ri moyi', ");
INSERT INTO cakCNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","can jebel c'a ruva-ak'ij, roma re vinek re xe'avoyoj re', man yetiquir ta niquiya' yan el rajel-ruq'uexel chave. Pero rat xtac'ul ri rajel-ruq'uexel, tok junan xcac'astej-el quiq'uin ri chojmilej tak vinek, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Y c'o c'a jun ri tz'uyul ri chiri' pa mesa, tok rac'axan chic ka ri tzij ri xubij ri Jesús, xubij c'a apo chire: Jebel ruva-quik'ij ri xquec'oje' pa rajavaren o pa ruk'a' ri Dios y can xtiquitej quivay chiri', xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Y jari' tok ri Jesús xubij: Jun achin jun bey, nrajo' c'a nuben nimak'ij ri pa rachoch y nuya' jun va'in. Romari' rija' chique e q'uiy vinek ri xubij chi yeroyobej chirachoch ri k'ij richin va'in. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Romari', tok xapon ri k'ij richin ri va'in, ri achin xutek c'a el jun rusamajel chicoyoxic conojel ri vinek ri'. Y ri samajel xberubij c'a chique: Ronojel c'o chic, vacami jo' c'a ri pa va'in. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero conojel can junan ri xquibila-pe, chi man yetiquir ta yebe. C'o c'a jun ri xubij-pe: Tabana' utzil tabij chire ri avajaf, chi tucuyu' juba' chi man yitiquir ta yibe, roma xa c'a xinlok' can jun vulef, y nic'atzin richin yibe chutz'etic. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","C'o chic jun ri can que chuka' ri' xubij: Tabana' utzil tabij chire ri avajaf chi man yitiquir ta yibe, roma ec'o vo'o' c'ulaj nuváquix richin samaj xenlok', y nic'atzin richin yentejtobej. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Y c'o chic c'a jun ri xubij-pe, chi man nitiquir ta nibe roma xa c'a xc'ule'. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Y tok ri samajel ri takon-el xtzolin-apo riq'uin ri rajaf, ronojel c'a ri xbix-pe chire xutzijoj chire. Romari' ri rajaf itzel xuna', y xubij chire ri rusamajel: Vacami c'a cabiyin pa tak bey ri cojol jay y quebe'amolo' c'a pe ri xa man utz ta ri quik'a' o ri caken, ri man choj ta yebiyin roma e jetz', ri e moyi', y chuka' ri xa man jun c'o quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Y tok ri samajel xtzolin, xubij c'a chire ri rajaf: Xenq'uen yan pe ri vinek ri xabij-el chuve, pero ri ch'aquet c'a q'uiy na c'o. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Y ri rajaf xubij chire: Vacami c'a cabiyin ri tza'n tak jay el y ri pa tak bey ri yebe juc'an chic tinamit, y tabana' c'a chique ri vinek ri yec'oje' que tak ri' chi quepe pa vachoch, richin queri' ninoj re vachoch. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Roma yin can kitzij vi ninbij chive chi man jun chic chique ri xenvoyoj pa nabey, ri xtorubana' ta re va'in re' viq'uin, xcha', xubij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Y janíla c'a vinek ri e tzekelbeyon-el richin ri Jesús. Y tok rija' xtzu'un c'a can chirij y xerutz'et ri vinek ri', xpa'e', y xuchop c'a rubixic chique: ");
INSERT INTO cakCNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Vi c'o c'a jun ri nipe viq'uin richin noc nutijoxel, c'o c'a chi ja yin ri más ta yirajo'. Man ruc'amon ta c'a chi ja ta ri rute-rutata' ri más yerajo' que chinuvech yin. Ni man ruc'amon ta c'a chuka' chi ja ta ri rixjayil, ri e ralc'ual, ri e rach'alal o rija' mismo ri más nrajo-ka-ri'. C'o c'a chi ja yin ri más yirajo' ta. Roma vi man que ta ri' ri nuben, man nitiquir ta c'a noc nutijoxel. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ri vinek ri can nrajo-vi noc nutijoxel, nic'atzin chi man tupokonaj nuc'ovisaj tijoj-pokonal voma yin, achi'el xa ta can benek chuxe' ru-cruz. Jac'a ri vinek ri xa nupokonaj nuc'ovisaj tijoj-pokonal voma yin y man nrajo' ta yirutzekelbej, man nitiquir ta noc nutijoxel. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Roma tok c'o jun chive rix ri nrajo' nuben jun jay nim, ¿man cami nitz'uye' ta juba' richin chi nuch'ob janipe' mero xtic'atzin chire, y vi can c'o ronojel riq'uin richin nuq'uis rubanic o xa man nitiquir ta? ");
INSERT INTO cakCNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Roma vi xaxe ri ru-cimiento ri jay nitiquir nuya-ka y nupaba' can ri samaj chiri', xquepe c'a ri vinek xtiquitze'ej, ");
INSERT INTO cakCNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","y xtiquibila' c'a: La jun achin la' xrajo' xupaba' jun jay, y xa man xtiquir ta chic, xquecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O vi jun k'atoy-tzij ri nibix rey chire, c'o chi nuben oyoval riq'uin jun chic rey, ¿man cami nitz'uye' ta juba' richin queri' nuch'ob vi lajuj mil ru-soldados yetiquir niquiben oyoval quiq'uin ri juvinek mil soldados ri e ruc'amon-pe ri jun chic rey? ");
INSERT INTO cakCNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Y vi nuch'ob chi man nitiquir ta, rija' yerutek achi'a' chuc'ulic ri rey, tok xa c'a man jani rutzijol noka'. Y ri achi'a' ri yebe chuc'ulic nequic'utuj utzil chire chi man nicajo' ta oyoval. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Romari', vi jun chive rix nrajo' noc nutijoxel, c'o c'a chi nuch'ob nabey chi c'o chi nuya' can ronojel ri c'o riq'uin. Vi man nuben ta queri', man nitiquir ta noc nutijoxel. ");
INSERT INTO cakCNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ri atz'an yalan jebel. Y vi ta re atz'an re' niq'uis ta el ri ratz'amil, ¿achique ta c'a rubanic richin queri' nitzolin ta chic pe ri ratz'amil? ");
INSERT INTO cakCNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jun atz'an ri man natz'amin ta chic, man utz ta nucusex achi'el nucusex ri ulef, ni man utz ta chuka' nucusex achi'el ri k'ayis richin nik'ayisex jun ulef. Xa nitorix-el, roma man jun chic nic'atzin-vi. Rix ri c'o ivac'axabal, can tivac'axaj c'a ri xinbij-ka, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Y conojel c'a ri achi'a' moloy tak alcaval y ri ch'aka' chic vinek ri nibix aj-maqui' chique, ye'apon c'a apo riq'uin ri Jesús. Re vinek c'a re' ye'apon riq'uin ri Jesús richin nicac'axaj ri ruch'abel ri Dios ri nutzijoj. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Y roma ja quivech vinek re' ri ye'apon riq'uin ri Jesús, ri achi'a' fariseos y ri etamanela' chirij ri ley janíla c'a niquibij chirij ri Jesús. Y niquibila' c'a: Re Jesús junan ruvech quiq'uin ri aj-maqui'. Roma man xe ta ri jebel quic'ulic nuben, xa can nibe chuka' quiq'uin ri chi tak cachoch richin neva', yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Roma c'a ri' ri Jesús xuchop c'a rubixic jun c'ambel-tzij chiquivech, y xubij: ");
INSERT INTO cakCNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Vi ta jun chive rix ri ec'o ta jun ciento rucarne'l y nisach ta can jun tok e ruc'uan-el richin yeruyuk'uj, ¿man cami yeruya' ta can juba' ri ch'aka' chic rucarne'l ri chiri' pa juyu', chucanoxic ri jun? Ja', queri' nuben. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Y tok nerila-pe ri carne'l ri', nuya' c'a pe chuvi-rutele'n. Can niquicot-vi c'a roma ri xril-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Y tok napon chirachoch, yeroyoj ri vinek retaman quivech, y yeroyoj chuka' ri ru-vecinos, y nubij c'a chique: Quixquicot c'a viq'uin re vacami, roma ri nucarne'l ri sachinek can, xinvil-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Y can kitzij c'a ninbij chive, chi chila' chicaj c'o quicoten tok ec'o noventa y nueve vinek ri choj quic'aslen, ri xa tzolijinek chic pe quic'u'x riq'uin ri Dios. Pero c'o más quicoten ri chila' chicaj, tok c'o jun aj-mac ri nitzolin-pe ruc'u'x riq'uin ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","O vi c'o ta jun ixok ri c'o lajuj fichas riq'uin, y chire ri lajuj fichas ri' nutzek ta jun, ri chiri' pa rachoch, ¿man cami nutzij ta jun k'ak' ri ixok ri', richin nucanoj ri ru-mero? ¿Y man cami numes ta rupan ri rachoch chucanoxic ri ru-mero? Ja', queri' nuben. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y tok nril, yeroyoj ri vinek ri retaman quivech, y yeroyoj chuka' ri ru-vecinos, y nubij c'a chique: Quixquicot c'a viq'uin, roma ri nu-mero ri sachinek, xinvil yan. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Y can kitzij c'a ninbij chive, chi tok c'o jun aj-mac nitzolin-pe ruc'u'x riq'uin ri Dios, chiquivech chuka' ri ángeles richin ri Dios janíla quicoten, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Y ri Jesús xubij c'a chuka' chique: C'o c'a jun achin ri ec'o e ca'i' ruc'ajol. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Y jun k'ij ri chak'laxel-ala' xubij c'a chire ri rutata': Táta, yin ninvajo' yan ri verencia, y taya' c'a chuve ri nel-apo chikavech riq'uin ri nunimal, xcha'. Y ri tata'aj can xujech na vi ri herencia chiquivech che ca'i'. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","C'a juba' ri', ri chak'laxel-ala' xuc'ayila' can ronojel ri xrichinaj. Can q'uiy c'a ri mero ri xumol-el, y c'ari' xbe pa jun chic ruvach'ulef ri nej c'o-vi: Y tok c'o chic ri chiri', xuc'uaj c'a jun itzel c'aslen, y romari' janíla q'uiy mero ri nuq'uis. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Rija' xuq'uis c'a ronojel ri ru-mero. Y jari' tok xpe jun nima-vayjal chupan ri ruvach'ulef ri c'o-vi. Y ri ala' ri' q'uiy c'a ri xbec'atzin-pe chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Y romari' xberusuju-ri' pa samaj riq'uin jun achin aj chiri' chupan ri ruvach'ulef ri', y ri achin xutek-el c'a pa rulef y yuk'un ak ri c'o chi nerubana'. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Y roma ri janíla vayjal c'o chire re ala' re', can nurayij c'a nutej ri niquitej ri ak. Pero man jun vinek ri niyo'on ta chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Y re ala' re', c'ari' xtzolin-pe ruc'u'x, y xuch'ob-ka: Ri e rusamajela' ri nata' man niquitej ta vayjal, roma c'o q'uiy quivay. Pero yin yiquen yan ka (yicom yan ka) roma vayjal vave'. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Más utz quitzolin na riq'uin ri nata', y xtinbij c'a chire: Táta, ximacun chuvech ri Dios, y can ximacun chuka' chavech rat. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Man chic c'a ruc'amon ta nabij ac'ajol chuve. Más utz tabana' chuve chi yinoc jun asamajel, xcha' ri pa ránima. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Y can xuchop na vi el bey chirachoch, c'a riq'uin ri rutata'. Y c'a nej na c'a c'o-vi ri ala' che ri rachoch, tok ri tata'aj xutz'et yan ri ruc'ajol, y janíla c'a xujoyovaj ruvech. Romari' junanin xbe chuc'ulic, xuk'etej y xutz'ubaj (xutz'umaj). ");
INSERT INTO cakCNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Y ri ala' can jac'ari' xubij chire ri rutata': Táta, ximacun chuvech ri Dios, y can ximacun chuka' chavech rat. Man chic c'a ruc'amon ta chi nabij ac'ajol chuve. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero ri tata'aj xubij c'a chique ri rusamajela': Tivelesaj-pe ri tziek más jebel y tivika' (tiveka') re nuc'ajol. Tiya' jun anillo chuvi-ruk'a' y tiya' chuka' ruxajab chiraken. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Y te'ic'ama' c'a pe chuka' ri ti váquix ri tiojirisan, y ticamisaj-ka. Tikabana' c'a jun nimak'ij, y kojva'. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Roma tok ninbij c'a yin ri', chi re jun nuc'ajol re' caminek chic, pero vacami achi'el c'astajinek chic pe. Rusachon c'a el ri', pero xoka' chic kiq'uin, xcha' ri tata'aj. Y jac'ari' xtiquir ri nimak'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Y tok najin c'a ri nimak'ij, ri nimalaxel-ala' nisamej pa juyu'. Y tok xtzolin c'a pe y napon yan pa jay, xrac'axaj c'a chi c'o nimak'ij najin. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Romari' rija' xroyoj jun chique ri quisamajela' y xuc'utuj chire: ¿Achique xbanatej? ¿Y achique roma tok c'o nimak'ij? ");
INSERT INTO cakCNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Y ri samajel xubij chire: Roma xtzolin-pe ri achak', y utz ruvech xtzolin-pe. Romari' ri atata' xutek rucamisaxic ri ti váquix ri tiojirisan. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tok xrac'axaj ri queri' ri nimalaxel-ala', xyacatej royoval, y man nrajo' ta c'a noc-apo ri pa jay. Xbe'el c'a pe ri rutata', y nubochila' c'a, richin queri' noc ta apo. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero man xrajo' ta. Rija' xa xubij c'a chire ri rutata': Yin can jantape' yisamej aviq'uin y man jun bey ri man ta nuniman atzij. Y man riq'uin ri', man jun ri ayo'on ta chuve. Stape' ta jun ti cabra, richin nikaben ta jun nimak'ij quiq'uin ri vachibil, pero ri' can man jun. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Y vacami rat xacamisaj-ka ri ti váquix ti'oj, xaxe roma xtzolin-pe re jun ac'ajol re', ri xa xberuq'uisa' yan can ronojel ri abeyomel, quiq'uin ixoki' ri man choj ta quic'aslen, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Y ri tata'aj xubij: Nuc'ajol, xcha' c'a chire. Rat, can viq'uin atc'o-vi. Romari' ronojel ri c'o, can avichin vi rat. ");
INSERT INTO cakCNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero re achak' re' can caminek vi chic chinuvech yin ri', y vacami achi'el c'astajinek chic pe, chinuvech yin. Rusachon c'a el ri', y vacami xoka' chic kiq'uin. Y romari' c'o c'a chi c'o nimak'ij y quicoten ri pa tak kánima, xcha' ri tata'aj ri', xubij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ri Jesús xubij c'a chuka' chique ri rutijoxela': C'o c'a jun achin beyon. Y re beyon re' c'o c'a jun rusamajel ri c'o pa ruvi' ronojel ri rubeyomel rija'. Y chire ri achin beyon xtzijox c'a chi ri rusamajel ri c'o pa ruvi' ronojel ri c'o riq'uin, najin c'a chuq'uisic ronojel rubeyomel. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Y ri patrón xutek c'a royoxic ri samajel ri'. Y tok xoka' c'a ri samajel, ri patrón xubij chire: ¿Achique nabij chuve chirij ri nitzijox chavij? Vacami c'a ninvajo' nintz'et achique rubanon ronojel ri beyomel pan ak'a', roma ri asamaj jare' xq'uis can vave', xcha' ri patrón chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Y ri samajel xuch'ob c'a ka pa ránima: ¿Achique ninben? Roma re nu-patrón nrelesaj nusamaj. Y ninben ta c'a jun chic ruvech nusamaj ri nrajo' uchuk'a', pero man yitiquir ta chic. Yinoc ta c'utuy-limosna pa tak bey, pero yiq'uix. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tok xch'obotej chuvech, xubij: Vacami vetaman chic achique ri xtinben, richin queri' ec'o yec'ulun vichin ri pa tak cachoch, tok xtelesex can re nusamaj. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Re samajel c'a re' xeroyoj chiquijujunal ri c'o quic'as riq'uin ri ru-patrón, y xuc'utuj c'a chire ri nabey: ¿Achique c'a ri ac'as, y janipe'? ");
INSERT INTO cakCNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Y ri achin aj-c'as xubij c'a: Yin c'o jun ciento barril aceite olivo nuc'as, xcha'. Y ri rusamajel ri beyon achin xubij c'a chire ri aj-c'as: Ja ruvujil ri ac'as re'. Y vacami aninek catz'uye-ka y tabana' chic can jun. Y chupan ri jun chic vuj ri xtaben, tabana' c'a ka chupan chi xa nic'aj ciento barril aceite ri ac'as. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Y tok xapon chic c'a jun aj-c'as, ri samajel xuc'utuj c'a chire: Y rat ¿achique ri ac'as y janipe'? Ri aj-c'as xubij: Yin vakxaki' ciento quintal trigo nuc'as, xcha'. Y ri samajel xubij chire: Ja ruvujil ri ac'as re', y vacami catz'uye-ka y tabana' chic jun. Y chupan ri jun chic vuj ri xtaben, tabana-ka chupan chi xa vaki' ciento riq'uin nic'aj ri ac'as, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Y tok ri ru-patrón xrac'axaj ri nuben ri jun itzel samajel ri', xubij: C'o runa'oj, xcha'. Y achi'el c'a ri achin ri', e queri' ri vinek ri c'a quicukuban na quic'u'x riq'uin ri ruvach'ulef. Can janíla vi e novinek quiq'uin ri vinek ri man quiniman ta ri Dios. Y can más e novinek re vinek re', que chiquivech ri quiniman ri Dios y e richin chic ri sakil. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Y yin ninbij c'a chive, xcha' ri Jesús. Q'uiy bey ri beyomel richin re ruvach'ulef, man utz ta rucusaxic niban coma ri vinek. Jac'a vi can pan ik'a' rix ri ralc'ual chic ri Dios c'o-vi re beyomel re', can ticusaj c'a richin chi ye'ito' ri nic'atzin quito'ic. Richin queri' tok ri ibeyomel xtiq'uis, xquixc'ul c'a ri chila' chicaj, chupan ri jay ri man jun bey xqueq'uis. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jun ri can utz nuben riq'uin jun cosa ri xa manek más rejkalen, can utz c'a chuka' xtuben riq'uin ri can janíla rejkalen. Jac'a ri xa man utz ta nuben riq'uin jun cosa ri xa manek más rejkalen, xa que chuka' ri' xtuben riq'uin ri can c'o-vi rejkalen. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Y vi riq'uin ri beyomel richin re ruvach'ulef, rix man utz ta niben, ¿xtujech cami ri Dios ri kitzij beyomel pan ik'a'? ");
INSERT INTO cakCNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Roma vi xa man utz ta niben riq'uin ri beyomel richin re ruvach'ulef ri uxkanen can pan ik'a', c'a ta la' chic c'a chi utz ta niben riq'uin ri kitzij beyomel, vi ta nijach chive roma ri Dios, beyomel ri can ivichin vi rix. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Y man jun c'a samajel ri e ca'i' ta rajaf y nitiquir ta nisamej quiq'uin che ca'i' pa jun bey. Roma vi nrajo' jun chique ri rajaf, nretzelaj chic can ri jun. Y vi can nunimaj rutzij ri jun, man nitiquir ta nuben queri' riq'uin ri jun chic. Y que c'a ri', manek modo chi c'o ta jun ri benek ránima chirij ri beyomel, y nrajo' ta chuka' nuben ri nrajo' ri Dios, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Y ri achi'a' fariseos xcac'axaj c'a ri xubij ri Jesús, romari' xquibanala-apo quipalej chuvech, roma rije' can benek cánima chirij ri beyomel. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Y ri Jesús xubij chique: Rix can nibananej chiquivech ri vinek chi can janíla ix choj. Pero ri Dios retaman achique ri c'o pan ivánima, y man utz ta yixrutz'et. Y ri' stape' janipe' jebel yixtz'et y stape' chuka' janipe' ix nimirisan coma ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Y tok c'a man jani c'a tuchop samaj ri Juan ri Bautista, can c'a ja na c'a ri ley richin ri Moisés ri nitzijox. Y can c'a ja na chuka' ri ruch'abel ri Dios ri tz'iban can coma ri achi'a' ri xek'alajirisan ri bin chique roma ri Dios chupan ri ojer can tiempo, can c'a ja na c'a chuka' ri' nitzijox. Jac'a tok xuchop samaj ri Juan, jari' tok xchap can rutzijoxic ri utzilej ruch'abel ri Dios ri nich'on chirij tok ri vinek ye'oc pa rajavaren o pa ruk'a' rija'. Y e q'uiy c'a vinek ri janíla niquitej quik'ij richin ye'oc ri chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Y chuka' ninbij chive, chi más man c'ayef ta chi re ruvach'ulef y ri caj yeq'uis, que chuvech ri ley. Roma ri nubij chiri', can c'o-vi c'a chi nibanatej na, y man jun ri que ta ri' xtic'oje' can, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Y ri Jesús xubij chuka': Vi c'o c'a jun achin ri nujech-ri' riq'uin ri rixjayil y c'ari' nuq'uen chic pe jun ixok, re achin re' nuben mac chuvech ri Dios. Y vi c'o c'a jun achin ri nuc'uan-el ri ixok ri jachon can roma ri rachijil, chuka' ri achin ri' nimacun chuvech ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Y ri Jesús xubij c'a chuka': Xc'oje' c'a jun achin ri janíla beyon. Re achin re' ruyon c'a jebel tak tziek ri jotol cajel ri yerucusala', y k'ij-k'ij nubanala' nima tak va'in. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pero que chuka' ri' xc'oje' c'a jun achin ri c'utuy-limosna y nojinek ruch'acul riq'uin ch'a'c. Rija' rubini'an Lázaro, y can jac'a ri pa ruchi-rachoch ri beyon nic'oje-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ri Lázaro can janíla c'a nurayij chi nutej ta ri ruchi' tak vey ri yetzak-ka chuxe' ri mesa. Y ri tz'i' can ye'apon c'a riq'uin churek'ic ri ch'a'c c'o chirij. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Y jun k'ij re c'utuy-limosna xquen-el (xcom-el), y c'a ja ri lugar richin quicoten xapon-vi; chiri' riq'uin ri Abraham. Can c'a jac'a ri lugar ri' xuc'uex-vi, coma ri ángeles. Y chuka' c'a ri achin beyon xquen (xcom), y xmuk. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Y tok rija' nutej chic c'a pokonal chupan ri lugar ri ye'apon-vi ri caminaki' ri man xquinimaj ta el, rija' xtzu'un-pe, y jari' tok xutz'et ri Abraham, pero c'anej c'a c'o-vi. Xutz'et c'a chuka' ri Lázaro rak'el-apo chuva-ruc'u'x ri Abraham. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Y ri achin beyon riq'uin ruchuk'a' xch'on, y xubij c'a chire ri Abraham: Nata' Abraham, tajoyovaj nuvech. Tabana' c'a utzil tabij chire la Lázaro, chi stape' xe rutza'n jun ruvi-ruk'a' tuch'ekeba', y tataka-pe viq'uin re vave', richin noruya' can chutza'n vak'. Roma nic'at vánima chupan re k'ak' re', xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero ri Abraham xubij chire: Toka' c'a chi'ac'u'x rat nuc'ajol, chi tok xac'ase' chuvech ri ruvach'ulef, yalan jebel xac'ovisaj ri ac'aslen, y re Lázaro yalan tijoj-pokonal xuc'ovisaj. Pero rija' yalan jebel ri ruc'aslen ri xorila' vave', y rat xa jun c'aslen richin tijoj-pokonal xavil. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Y chuka' xa c'o jun nimalej sivan chikacojol. Romari', vi c'o jun ri c'o vave' nrajo' ta napon iviq'uin, man nitiquir ta. Y vi ta jun chive rix nrajo' nipe vave' kiq'uin roj, man nitiquir ta chuka', xcha' ri Abraham. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Y ri achin beyon xubij c'a: Vi queri', ninvajo' c'a ninc'utuj jun chic utzil chave rat nata' Abraham. Tataka' c'a el juba' ri Lázaro chuvech ri ruvach'ulef, pa rachoch ri nata'. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Roma ec'o vo'o' vach'alal, y nech'on ta quiq'uin, richin man quepe chupan re jun lugar richin tijoj-pokonal, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Y ri Abraham xubij chire: Rije' c'o ri ruch'abel ri Dios ri rutz'iban can ri Moisés, quiq'uin. Y c'o chuka' ruch'abel ri Dios ri tz'iban can coma ri achi'a' ri xek'alajirisan ri ruch'abel ri Dios ojer can. Jac'ari' ri ticac'axaj, y tiquinimaj, xcha' ri Abraham. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Y ri achin beyon xubij: Ja', can kitzij, nata' Abraham. Pero vi c'o jun caminek ri nic'astej-el y napon quiq'uin ri vach'alal, can xtitzolej-vi quic'u'x riq'uin ri Dios, xcha' ri beyon. ");
INSERT INTO cakCNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero ri Abraham xubij chire: Vi can man niquinimaj ta ri ruch'abel ri Dios ri rutz'iban can ri Moisés, ni man niquinimaj ta chuka' ri ruch'abel ri Dios ri quitz'iban can ri achi'a' ri xek'alajirisan ri ch'abel ri' ojer can, xa man xtiquinimaj ta chuka' jun ri nic'astej-el chiquicojol ri caminaki'. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Y ri Jesús xubij c'a chique ri rutijoxela': Can ronojel c'a bey c'o c'a ri xtibanon chique ri vinek richin yemacun. Pero ri xtibanon chire jun chic vinek chi nimacun, xa tok'ex c'a ruvech. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Y más ta utz chire ri jun vinek ri nich'obon chi nuben ri etzelal ri', chi ximon ta jun nimalej ca' chukul y nic'ak chupan jun nimalej ya', que chuvech nuben chire jun co'ol chi nitzak pa mac. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Romari' rix tichajila' c'a ri ic'aslen. Y vi c'o jun avach'alal c'o itzel ri nuben chave, tabij c'a chire. Y vi ri nibanon itzel chave noruc'utuj cuyubel rumac chavech roma xtzolin-pe ruc'u'x, tacuyu' c'a rumac. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Y vi pa jun k'ij vuku' ta bey c'o itzel nuben chave y chi vuku' bey nitzolin ta pe ruc'u'x y nipe aviq'uin y nubij chave: Tacuyu-tasacha' numac, can ruc'amon chi nacuy rumac, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Y ri apóstoles xquibij c'a chire ri Ajaf Jesús: Tabana' c'a chike chi nikacukuba' ta más kac'u'x riq'uin ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pero ri Ajaf Jesús xubij chique: Vi rix icukuban ic'u'x riq'uin ri Dios, stape' ta juba' oc achi'el jun ti ija'tz richin ri mostaza, y nibij ta chire re che' rubini'an sicómoro chi tel-el vave' y tik'ax chupan ri nimalej ya' richin nerutica-ri' chiri', re che' re' can nunimaj ta vi itzij. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Y vi c'o ta c'a jun chive rix ri c'o ta jun ri can samajel vi riq'uin, y rutakon ta el pa juyu' pan arado o yuk'uy quichin carne'l, ¿can xe cami tok nitzolin-pe, can ja cami ri' xtubij chire: Catoc pa jay, catz'uye' pa mesa y cava'? Man jun bey ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿Man cami nabij ta chire: Tachojmirisaj ri xtintej re vacami tikak'ij, y tachojmirisaj chuka' avi' rat richin queri' yinavilij-pe re yiva' y yinuc'ya', y can c'a tok yicolaj na yin, c'ari' cava' y catuc'ya' rat? ");
INSERT INTO cakCNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Y namatioxij cami chire ri samajel roma xuben ri xabij chire? Man jun. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Y can achi'el ri samajel ri', queri' chuka' rix. Tok ibanon chic ri samaj ri nubij ri Dios chive, tibij: Roj oj samajela' ri man jun yojc'atzin-vi. Roma xaxe ri bin chike, xaxe ri' ri xkaben, quixcha', xcha' ri Jesús chique ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Y tok ri Jesús rachibilan ri rutijoxela' xuchop chic el bey pa Jerusalem, xk'ax c'a chiquicojol ri lugar Samaria y ri Galilea. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Y tok xapon pa jun ti tinamit, ec'o c'a e lajuj achi'a' ri c'o ri yabil ri rubini'an lepra chique. Ri achi'a' ri' xebec'ulun-pe, pero c'a nej xepa'e-vi chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Y tok xech'on c'a, riq'uin cuchuk'a' xech'on-apo chire ri Jesús y xquibij: Ajaf, tajoyovaj kavech roma re kabanon, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Y ri Jesús can xerutzu-vi c'a y xubij chique: Quixbiyin c'a y te'ic'utu-ivi' chiquivech ri sacerdotes, xcha-el ri Jesús chique. Y tok quichapon c'a el binen richin nequic'utu-qui' chiquivech ri sacerdotes, ri quiyabil xq'uis-el y xech'ajch'ojir c'a. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Y jun c'a chique ri e lajuj achi'a', tok xutz'et chi can xc'achojirisex-vi chire ri ruyabil, rija' xtzolin. Y janíla c'a nuya' ruk'ij-ruc'ojlen ri Dios, y can riq'uin c'a ruchuk'a' nich'on tok nuya' ruk'ij ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Y tok xapon riq'uin ri Jesús, xxuque' chuvech y xulucuba-ka-ri', y janíla c'a numatioxij chire ri Jesús. Re achin c'a re' aj-Samaria. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Y ri Jesús xubij: ¿Man e lajuj ta c'a ri xq'uis-el ri quiyabil y xech'ajch'ojir? ¿Y ri beleje' chic? ");
INSERT INTO cakCNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Can man jun chic c'a ri xtzolin ta pe richin chi nuya' ruk'ij-ruc'ojlen ri Dios? ¿Xaxe cami re man israelita ta ri xtzolin-pe richin chi nuya' ruk'ij-ruc'ojlen ri Dios? xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Y ri Jesús xubij chuka' chire ri achin aj-Samaria: Cayacatej y cabiyin c'a. Xac'achoj roma can xacukuba' ac'u'x viq'uin, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Y ri achi'a' fariseos xquic'utuj c'a chire ri Jesús chi jampe' c'a xtoka' ri utzilej k'atbel-tzij richin ri Dios richin pa ruk'a' rija' yojc'oje-vi. Y ri Jesús xubij c'a chique: Man xtinabex ta jampe' xtoka', roma ri ruk'atbel-tzij ri Dios man tz'etel ta. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Y man c'a jun xtibin ta chi jare' c'o vave', o jala' c'o chila', roma ri ruk'atbel-tzij ri Dios c'o chic iviq'uin, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Y rija' xch'on c'a chique ri rutijoxela', y xubij: Xque'oka' c'a ri k'ij tok rix xtivajo' chi stape' xaxe jun k'ij yic'oje' ta chic iviq'uin, yin ri xinalex chi'icojol. Pero man jani yinitz'et ta. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Y can ec'o c'a ri xquebin chive: Jare' c'o vave'. Jala' c'o chila'. Pero rix man c'a quixbe quiq'uin, ni man c'a chuka' que'itzekelbej. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Roma tok xtapon ri k'ij chi yin ri xinalex chi'icojol yipe chic jun bey, xquinoka' achi'el jun coyopa', ri nik'alajin jebel roma nusakirisaj ri caj. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero nabey c'o c'a chi ninc'ovisaj na q'uiy tijoj-pokonal, y c'o c'a chuka' chi yinetzelex coma ri vinek richin re tiempo re', re ojc'o vacami. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Y ri k'ij c'a tok xquipe, yin ri xinalex chi'icojol, can xtibanatej c'a chuka' achi'el ri xc'ulvachitej chupan ri k'ij tok xc'ase' ri Noé. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chupan c'a ri ru-tiempo ri Noé, ri vinek man jun chic c'a ri janíla ta rejkalen chiquivech. Rije' xa jac'a ri quivay-cuc'ya' ri niquich'ob, chuka' ri c'ulubic, ri yeyatej chuka' quimi'al-quic'ajol richin yec'ule'. Jari' ri yequich'obola' rija', tok xapon c'a ri k'ij richin chi ri Noé y ri e aj pa rachoch xe'oc chupan ri nimalej barco, y xuchop ri camic job. Y ri ch'aka' chic vinek, can conojel xequen (xecom). ");
INSERT INTO cakCNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Y can que c'a chuka' ri' xc'ulvachitej pa ru-tiempo ri Lot. Ri vinek xa benek c'a cánima riq'uin ri quiva'in, riq'uin ri achique yequikumula', riq'uin ri quilok'oj, ri quic'ayij, ri quiticoj y ri paban tak jay. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Y ri k'ij tok ri Lot y ri e aj pa rachoch xquiya' can ri tinamit Sodoma, xka' c'a can k'ak' y azufre pa ruvi' ri tinamit. Can achi'el c'a job xuben tok xka-pe ri chicaj, y can conojel vinek ri ec'o chiri' xeruq'uis k'ak'. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Y ri k'ij c'a tok yin ri xinalex chi'icojol xquinoc'ulun chic ka re vave' chuvech re ruvach'ulef, janíla c'a e q'uiy vinek ri xa riq'uin ronojel ri c'o quiq'uin benek-vi cánima. Y romari' xtika' ruc'ayeval pa quivi'. Can xtiquic'ulvachij c'a achi'el ri xec'oje' pa tinamit Sodoma. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ri xa nuxlan pa ruq'uisibel vik (vek) chire ri rachoch tok napon ri k'ij ri', choj queri' tanmej-el. Man chic toc-apo ri pa rachoch richin chi c'o na ri neruc'ama-pe. Y vi c'o c'a chuka' jun ri nisamej pa juyu' chupan ri k'ij ri', man chic titzolej ri chuva-rachoch. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Roma xaxe c'a toka' chi'ic'u'x ri xuc'ulvachij ri rixjayil ri Lot, tok xporox ri tinamit Sodoma roma ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ri can yalan c'a nupokonaj ri ruc'aslen re vave' chuvech re ruvach'ulef, man xtril ta ruc'aslen richin jantape'. Jac'a ri man nupokonaj ta ri ruc'aslen richin re vave', ri ruc'aslen can man xtiq'uis ta. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Y tok yin xquipe chic jun bey, vi ec'o e ca'i' yever pa jun ch'at, jun runiman y jun man runiman ta, xaxe c'a jun chique rije' ri xtuc'uex-el y ri jun chic xtic'oje' can. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Y vi ec'o c'a e ca'i' ixoki' ri junan yeque'en, y xaxe jun ri runiman, xa jun c'a ri xtuc'uex-el y ri jun chic xtic'oje' can. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Y vi ec'o e ca'i' achi'a' ri junan chuka' ec'o pa samaj ri pa juyu', y xaxe jun ri runiman, xaxe c'a chuka' jun ri xtuc'uex-el y ri jun chic xtic'oje' can. ");
INSERT INTO cakCNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Y tok ri tijoxela' cac'axan chic ka ri xubij ri Jesús, xquic'utuj chire: Ajaf, ¿acuchi c'a xtic'ulvachitej-vi ri queri' ri'? Y ri Jesús xubij c'a chique: Ri ruk'atbel-tzij ri Dios xtika' acuchi c'o-vi ri mac. Can xtibanatej c'a achi'el nibanatej quiq'uin ri c'uch. Roma ri aj-xic' tak chicop ri' yeka' acuchi c'o-vi jun caminek ch'aculaj, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Y ri Jesús xutzijoj c'a jun c'ambel-tzij chique ri rutijoxela', richin chi nuc'ut chiquivech chi can nic'atzin-vi chi jantape' tiquibana' orar y man tiquimalij rubanic. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Rija' xubij c'a chique: Pa jun c'a tinamit xc'oje' jun k'atoy-tzij ri can man nuxibij ta ri' chuvech ri Dios, y man jun chuka' quejkalen ri vinek chuvech. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Y chupan c'a chuka' ri tinamit ri', c'o c'a jun malca'n-ixok. Y ri malca'n-ixok ri' nel-noc c'a riq'uin ri jun k'atoy-tzij ri', richin nuc'utuj utzil chire chi tuto' richin chi nich'acon chirij ri banayon ch'a'oj chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Y q'uiy c'a k'ij ri xk'ax, y ri k'atoy-tzij man nrajo' ta nuto' ri ixok malca'n. Pero jun k'ij re k'atoy-tzij re' xuch'ob c'a ka pa ránima: Stape' man in nimey ta richin ri Dios, ni man jun chuka' quejkalen re vinek chinuvech, ");
INSERT INTO cakCNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero roma c'a re ixok re' nel-noc re viq'uin, tinto' na c'a. Roma vi man xtinto' ta, xtic'o nuc'u'x pa ruk'a'. Queri' nubij ri c'ambel-tzij ri xutzijoj ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Y c'ari' ri Ajaf Jesús xubij: Yin vetaman chi rix xivac'axaj ri jebel tak ch'abel ri xerubij ri k'atoy-tzij, y rija' xa man choj ta. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","C'a ta la' chic c'a ri Dios chi man ta xqueruto' ri vinek ri e rucha'on chic rija' y chi pak'ij chi chak'a' niquiben orar. ¿Ri Dios man chanin ta cami xqueruto-pe ri vinek ri e rucha'on chic? ");
INSERT INTO cakCNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yin can ninbij c'a chive chi chanin xqueruto-pe. Y tok yin ri xinalex chi'icojol xquipe chic jun bey vave' chuvech re ruvach'ulef, ¿c'a ec'o cami vinek ri quicukuban quic'u'x riq'uin ri Dios? xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Y ri Jesús xuya' chic c'a jun c'ambel-tzij chiquivech ri vinek, roma ec'o chique rije' ri niquich'ob chi janíla e choj, y yequetzelaj ri ch'aka' chic vinek. Romari' ri Jesús xubij: ");
INSERT INTO cakCNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ec'o c'a e ca'i' achi'a' ri xebe pa rachoch ri Dios che oración. Ri jun achin, jun chique ri fariseos, y ri jun chic jun moloy-alcaval. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ri achin fariseo pa'el, ruyon nuben orar, y nubij c'a chupan ri ru-oración: Dios, matiox ninya' chave roma yin man in junan ta quiq'uin ri ch'aka' chic. Roma ri ch'aka' chic vinek e elek'oma', e canoy quichin ch'aka' chic ixoki', y man e choj ta chupan ri quic'aslen. Ni man in junan ta c'a chuka' riq'uin la jun achin moloy-alcaval la'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Roma yin can ca'i' k'ij pa jun semana ri man yiva' ta, richin ninben orar. Y ronojel ri ninch'ec, lajuj ninben chire, y jun chire ri' ninya' chave rat, xcha' ri fariseo pa ru-oración. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Y jac'a ri moloy-alcaval c'a nej xc'oje-vi can richin nuben orar. Pa'el c'a nuben orar, pero jun lucul-vi chiri', roma chuvech rija' can man ruc'amon ta nuyec ri runak'-ruvech chicaj y rija' nubajila' c'a ruva-ruc'u'x riq'uin ri ruk'a', y nubij c'a chire ri Dios: Tajoyovaj nuvech, roma yin in jun aj-mac chavech. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Can kitzij ninbij chive, xcha' ri Jesús, chi ri achin moloy-alcaval xtzolin-el, y man jun rumac xc'ulun can chuvech ri Dios. Jac'a ri achin fariseo man que ta ri' xc'ulun chuvech ri Dios. Roma xabachique c'a ri nunimirisaj-ri', xtiban c'a chire chi xtikasex ruk'ij. Jac'a ri ruch'utinirisan-ri', xtiniminirisex ruk'ij, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Y ri vinek yequic'amala' c'a pe ri ac'uala' c'a riq'uin ri Jesús, richin nuya' ta el ri ruk'a' pa quivi'. Y ri rutijoxela' ri Jesús xquitz'et, y xquibij chique ri vinek chi man tiquiben queri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero ri Jesús xeroyoj ri rutijoxela', y xubij chique: Tiya' k'ij richin chi ri ac'uala' yepe c'a viq'uin yin, y man que'ik'et. Roma ri xque'oc pa rajavaren o pa ruk'a' ri Dios, xaxe ri e achi'el ri ac'uala'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Y can kitzij c'a ninbij chive, chi ri xa man niquiben ta achi'el ri ac'uala' richin chi niquijech-qui' pa ruk'a' ri Dios, can man c'a xque'oc ta pa rajavaren o pa ruk'a' ri Dios, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Y c'o c'a jun achin ri nim ruk'ij, xuc'utuj chire ri Jesús: Rat utzilej Tijonel, ¿achique c'a ruc'amon chi ninben yin richin chi ninvichinaj ri c'aslen ri man q'uisel ta? xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Y ri Jesús xubij chire: ¿Achique roma tok nabij utz chuve yin? Roma man jun vinek ri utz ta, xa can xe ri Dios ri utz. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Y yin ninbij chi rat jebel avetaman ri lajuj pixa' ri xuya' ri Dios pa ruk'a' ri Moisés ri ojer can, chi rat achin ri c'o avixjayil man tacanoj jun chic ixok; man cacamisan; man catelek'; man tatz'uc tzij chirij jun chic vinek; taya' quik'ij ri ate-atata', xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Y ri achin xubij chire ri Jesús: C'a in co'ol tok nubanon-pe ronojel ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tok ri Jesús xrac'axaj quere', xubij: C'a c'o jun ri man abanon ta. Man atalun ta ri abeyomel chiquivech ri vinek ri man jun c'o quiq'uin. Tac'ayij c'a ronojel ri c'o aviq'uin y ri rajel tataluj chiquivech ri vinek ri man jun c'o quiq'uin, richin queri' nic'oje' abeyomel chila' chicaj. Y catampe c'a viq'uin y quinatzekelbej, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Y tok ri achin xrac'axaj ri xubij ri Jesús, janíla xbison pa ránima, roma janíla ri beyomel c'o riq'uin y man nrajo' ta nel pa ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Y tok ri Jesús xutz'et chi xa xpe janíla bis pa ránima ri achin, xubij: Ri c'o quibeyomel, janíla c'ayef richin chi ye'oc pa rajavaren o pa ruk'a' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Xa más la'ek man can ta c'ayef chi nik'ax ri jun chicop rubini'an camello pa ti rujulil jun bak, que chuvech jun beyon noc ta pa rajavaren o pa ruk'a' ri Dios, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ri xe'ac'axan ri xubij ri Jesús, xquibila' c'a: Vi can achi'el ri nubij, queri', man jun xticolotej, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Y ri Jesús xubij chique: Ri vinek man ronojel ta yetiquir niquiben. Jac'a ri Dios can ronojel nitiquir nuben, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jari' tok xpe ri Pedro xubij: Rat avetaman chi roj kayo'on can ri c'o kiq'uin, richin at katzekelben. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Y ri Jesús xubij c'a chique: Can kitzij ninbij chive, chi xabachique vinek can c'o ri xtuc'ul, vi ruyo'on can rachoch, rute-rutata', rach'alal, rixjayil o ralc'ual, richin nuben rusamaj ri Dios y yeruto' ri ye'oc pa rajavaren o pa ruk'a' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Can q'uiy yan c'a ri nuc'ul chupan re tiempo re kachapon. Y chupan apo ri jun chic tiempo chikavech apo, can xtuc'ul c'a ri ruc'aslen ri xa man q'uisel ta. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Y ri Jesús xaxe c'a quiq'uin ri cablajuj rutijoxela' xch'on-vi, y xubij: Rix ivetaman chi pa tinamit Jerusalem kachapon-vi-el bey, y ri chiri', q'uiy c'a ri xtiban chuve yin ri xinalex chi'icojol. Can ronojel vi c'a ri tz'ibatel can chuvij xtibanatej, can achi'el ri quitz'iban can ri achi'a' ri xek'alajirisan ri ruch'abel ri Dios ojer can. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Xquijach c'a pa quik'a' vinek ri xa man e israelitas ta. Y ri vinek ri' xquetze'en chuvij, xtiquibila' pokon tak ch'abel chuve y xquinquichubaj. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Xquinquich'ey, y c'ari' xquinquicamisaj. Pero pa rox k'ij xquic'astej c'a pe, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero ri tijoxela' can man xk'ax ta chiquivech ri xubij ri Jesús. Ri ch'abel ri' xa evan c'a chiquivech, roma c'a ri' xaxe choj xcac'axaj y man quetaman ta achique nic'ulun-vi chi tzij. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tok ri Jesús noc yan apo ri pa tinamit rubini'an Jericó, ri chiri' chuchi-bey tz'uyul c'a jun achin. Y re achin c'a re' moy, y nuc'utula' limosna chique ri vinek ri yek'ax queri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Y tok re moy re' xrac'axaj chi sibilej vinek ri yek'ax-el, xuc'utuj c'a chi achique xc'ulvachitej. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Y xquibij chire chi ja ri Jesús aj-Nazaret ri nik'ax-el queri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Y ri achin moy riq'uin ruchuk'a' xch'on, y xubij c'a: Tajoyovaj nuvech rat Jesús, ri at riy-rumam can ri rey David, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Y ri vinek c'a ri e nabeyejinek-el chuvech ri Jesús, xquibila' chire ri achin chi man chic tich'on. Pero rija' xa riq'uin más ruchuk'a' xch'on, y xubij: Rat ri riy-rumam can ri rey David, tajoyovaj nuvech roma re nubanon, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Y ri Jesús xrac'axaj c'a ri ruch'abel. Romari' xpa'e-ka y xubij chi tiquic'ama-pe. Y tok c'amon chic pe ri achin c'a riq'uin, xuc'utuj c'a chire: ");
INSERT INTO cakCNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Achique c'a ri navajo'? Y ri achin moy xubij: Ajaf, yin ninvajo' yitzu'un, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Y ri Jesús xubij chire: Catzu'un c'a. Roma ri xacukuba' ac'u'x, xac'achoj. ");
INSERT INTO cakCNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Y ri achin moy can jac'ari' tok xtzu'un y xtzeke-el chirij ri Jesús. Re achin c'a chuka' re' nuya' ruk'ij-ruc'ojlen ri Dios. Y conojel ri vinek ri xetz'eton chi ri moy xtzu'un, can xquiya' c'a chuka' ruk'ij-ruc'ojlen ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Y jac'ari' tok ri Jesús rachibilan ri rutijoxela' xoc-apo ri pa tinamit rubini'an Jericó, y nik'ax c'a el. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Y ri chiri' chupan ri tinamit ri' c'o c'a jun achin beyon rubini'an Zaqueo. Re achin c'a re', jare' ri más ruk'ij que chiquivech ri ch'aka' chic moloy tak alcaval. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Y rija' can nutej c'a ruk'ij richin nutzu-el ri Jesús, pero roma c'a ri e janíla vinek y xa ti co'ol chuka' oc ri rupalen, xa man nitiquir ta nutz'et-el. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Romari' rija' junanin xnabeyej-el y xbejote' pa ruvi' jun che' ri nibix sicómoro chire, richin queri' nutz'et-el ri Jesús, roma queri' c'o chi nik'ax-vi-el. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Y tok ri Jesús nik'ax c'a el ri queri', xtzu'un chicaj pa ruvi' ri che', y xubij c'a chire ri jotol chiri': Zaqueo, chanin caka-pe ri chiri', roma can ja re vacami c'o chi yinapon chi'avachoch, richin chi yinuxlan juba', xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Y ri Zaqueo can jari' xka-pe junanin, y riq'uin quicoten xuc'ul-apo ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tok xbanatej c'a quere', ri vinek niquibila' c'a chi ri Jesús xa pa rachoch jun achin aj-mac xbecanej-vi can. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Y ri Zaqueo pa'el c'a tok xch'on chire ri Ajaf Jesús y xubij c'a: Ajaf, vacami nic'aj chire ri nubeyomel nintaluj chique ri vinek ri man jun c'o quiq'uin. Y ri vinek ri can c'o velesan chique, can caji' chic c'a ri xtintzolij chique, man xe ta chic ri xinvelesaj chique, roma yin can xic'o ruvi' ri mero ri xinc'utuj chique, man xaxe ta chic ri mero ri c'o chi niquitoj chire ri k'atbel-tzij, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Y ri Jesús xubij chire: Ri colotajic xoka' vave' pan avachoch vacami, roma rat can xacukuba' ac'u'x achi'el xucukuba' ruc'u'x ri jun ojer katata', ri xubini'aj Abraham. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Roma yin ri xinalex chi'icojol, can in petenek-vi chiquicanoxic y chiquicolic ri ec'o pa mac, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Y tok ri Jesús rubin chic ka ronojel re' chique ri vinek, xuchop rubixic jun c'ambel-tzij chique. Queri' xuben roma nakaj chic ec'o-vi chire ri Jerusalem y roma chuka' ri vinek ri ye'ac'axan richin, niquich'ob chi tok rija' xtoc-apo ri pa tinamit, xtetz'uye' can ri pa k'atbel-tzij richin queri' nuchop yan nik'alajin ri utzilej ruk'atbel-tzij ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Y rija' xubij c'a: Xc'oje' c'a jun achin ri janíla nim ruk'ij. Re achin re' xbe c'a pa jun chic ruvach'ulef ri c'anej c'o-vi, richin niban-pe rey chire. Y c'ari' nitzolej-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pero tok c'a man jani c'a tibe, xeroyoj e lajuj rusamajela' y xuya' can veinte quetzales pa quik'a' chiquijujunal, y xubij chique: Tic'uaj c'a re mero re xinya' can chive richin c'o nich'ec chirij, c'a jampe' xquitzolin-pe yin, xcha' can chique, y xbe. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Y tok c'o chic c'a chupan ri ruvach'ulef ri c'o chi napon-vi richin niban-pe rey chire, ec'o c'a achi'a' ri e benek pa quibi' conojel ri ruvinak ri xe'apon c'a acuchi c'o-vi rija'. Y re achi'a' re' xbequibij: Roj man nikajo' ta chi re achin re' noc k'atoy-tzij ri pa karuvach'ulef, xecha'. Ri e takayon c'a el ri achi'a' ri', janíla c'a niquetzelaj ri achin ri niban-pe rey chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Y man riq'uin ri' ri jun achin ri' xban-pe rey chire, y xtzolin c'a. Y tok c'o chic ri pa ruruvach'ulef, xutek c'a coyoxic ri rusamajela' ri xuya' can mero pa quik'a' tok rija' c'a man jani tibe, roma nrajo' nretamaj janipe' mero quich'acon chiquijujunal. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tok xapon c'a ri nabey samajel, xubij: Ajaf, ri veinte quetzales xajech can pa nuk'a' richin c'o ninch'ec chirij, can xinch'ec na vi ca'i' ciento quetzales chirij, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Y ri achin, rey chic ri tiempo ri', xubij c'a chire ri rusamajel: Yalan utz ri xaben. At jun utzilej samajel. Y roma c'a ri utz xaben riq'uin ri juba' ri xinya' can pan ak'a', vacami c'a ninya' lajuj tinamit pan ak'a' richin nak'et tzij pa quivi', xcha' ri rey. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Y jac'ari' tok xapon jun chic samajel, y xubij: Ajaf, ri veinte quetzales ri xaya' can pa nuk'a' tok xabe, xinch'ec jun ciento quetzales riq'uin, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Y ri rey xubij c'a chuka' chire re jun samajel re': Roma utz ri xaben riq'uin ri juba' ri xinya' can pan ak'a', vacami c'a ninya' vo'o' tinamit pan ak'a' richin nak'et tzij pa quivi', xcha' chuka' ri rey chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jac'a ri jun chic samajel ri xapon, xubij: Ajaf, ja veinte quetzales re' nonya' can chave. Re mero re' xinpis pa jun su't richin xinyec. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Roma yin ninxibij-vi' chavech. Roma at jun achin janíla c'a'el. Xa can navajo-vi c'a yach'acon. Rat xa at junan vi riq'uin jun achin ri neruc'utuj ru-mero pa banco y xa man jun mero ruyo'on can chiri'. Y chuka' navajo' nac'ul ri nel-pe chuvech ri ticoj ri xa man rat ta xaticon-ka, xcha' ri samajel chire ri rey. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Y ri rey xubij c'a chire ri samajel ri': Rat man at jun utzilej samajel ta. Ri tzij ri xabij jari' ri xtincusaj richin nink'et tzij pan avi'. Roma vi can avetaman chi yin can in c'a'el vi, chi yin can ninch'ojij-vi nu-mero ri acuchi xa man jun nuyacon ta, y chuka' can ninvajo' ninc'ul ri nel-pe chuvech ri ticoj ri xa man ja ta yin xiticon-ka; ");
INSERT INTO cakCNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","vi queri' nabij rat, ¿achique c'a roma tok man xaya' ta ri nu-mero pa kajic? Richin queri' ninc'ul ta c'a ri mero ri can vichin yin y c'o ta chuka' ral ninc'ul re vacami tok xitzolin-pe, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Y ri rey xubij c'a chique ri ec'o chiri': Tic'ama' c'a can la mero pa ruk'a', y tiya' chire ri nusamajel ri xch'acon ca'i' ciento quetzales. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Y ri ec'o chiri' xquibij: Ajaf, ri ca'i' ciento quetzales ri xuch'ec, pa ruk'a' rija' c'o-vi, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pero rija' xubij chique: Yin ninbij c'a chive, chi ri c'o, c'o riq'uin, xtuc'ul más. Jac'a ri man jun oc c'o riq'uin, janipe' oc ri c'o riq'uin xtelesex chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Vacami c'a, ninvajo' yich'on chiquij ri ye'etzelan vichin, y ri xe'ajovan chi man ta xinoc can rey: Je que'ic'amala-pe, y c'a ja re chinuvech yin que'icamisala-vi, xcha' ri rey. Queri' xubij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Y tok ri Jesús xtane' yan richin nich'on chiquivech ri vinek, xuchop c'a bey chiquivech ri rutijoxela'. Benek c'a chiquivech, quichapon-el bey pa tinamit Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Y ja tok ye'apon yan apo ri pa Betfagé y ri Betania ri ec'o chuvech ri juyu' rubini'an Olivos, ri Jesús xerutek c'a el e ca'i' chique ri rutijoxela', ");
INSERT INTO cakCNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","y xubij-el chique: Quixbiyin-apo la pa ti tinamit la', y can ja yan ri xquixoc-apo, jari' xtivil jun alaj burro ximil can chiri'. Y c'a man jun ch'ocolbeyon richin. Tisolo' c'a pe y tic'ama-pe chuve. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Y vi c'o c'a xtibin-pe chive chi achique roma tok rix nisol-pe ri alaj burro ri', tibij c'a can chire chi nic'atzin chire ri Ajaf, xcha-el chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ri ca'i' tijoxela' ri xetak-el, xebe c'a, y can xquil na vi ri burro, can achi'el ri bin-el chique roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jac'a tok ye'ajin chusolic, ri e rajaf xquibij-pe chique: ¿Achique roma tok nisol-el? xecha-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Y ri rutijoxela' ri Jesús xquibij c'a can chique ri e rajaf ri burro: Xa nic'atzin chire ri Ajaf, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Y xquiq'uen-pe chire ri Jesús. Y rije' xquiya' c'a chuka' quik'u' chirij ri burro ri', y xquich'ocoba-el ri Jesús chirij. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Y tok benek c'a ri Jesús, ri vinek niquiriq'uila' c'a ka ri quik'u' pa rubey richin niquiya' ruk'ij. Y que c'a ri' niquibanala' e benek. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jac'a tok xa niquichop yan ri xulan richin ri juyu' Olivos, conojel ri e tzekelbey richin ri Jesús e benek, roma niquicot ri cánima, niquiya' c'a ruk'ij ri Dios. Niquiya' c'a ruk'ij ri Dios roma ri milagros e quitz'etelon riq'uin ri Jesús. Y can riq'uin c'a cuchuk'a' niquibila'. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Rije' niquibij c'a: ¡Re Rey re urtisan-pe roma ri Ajaf Dios, can pa rubi' vi ri Ajaf Dios petenek-vi! ¡Quicoten c'a ri chila' chicaj! ¡Janíla c'a ruk'ij-ruc'ojlen nuc'ul ri Dios ri chila' chicaj! yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Y ri chiri' chiquicojol ri vinek, e benek c'a ch'aka' achi'a' fariseos. Y rije' xquibij c'a chire ri Jesús: Tijonel, xecha' chire. Que'ak'ila' ri e tzekelbey avichin, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jac'a ri Jesús xubij chique: Can kitzij ninbij chive, chi vi yetane-ka rije', ja ri abej xquebech'on-pe richin niquiya' nuk'ij, xcha' chique ri achi'a' fariseos. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Y ri Jesús xutzu' c'a ri tinamit Jerusalem, tok más nakaj chic ec'o-vi-apo. Rija' xrok'ej c'a ri tinamit ri', ");
INSERT INTO cakCNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","y xubij c'a: Rix ri ixc'o pa Jerusalem, stape' c'a ja ta re k'ij re' nik'ax ta chivech ri achique niyo'on uxlanen ri pa tak ivánima. Pero xa evan can chivech, y romari' man yixtiquir ta nitz'et. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Roma xque'ivil c'a k'ij richin k'axo'n, k'ij tok achi'a' banoy-oyoval xquebeyacatej-pe chivij, y xtiquisurij rij (xtiquisutij rij) ri itinamit riq'uin jun chic tz'ak, y xquixquiya' pa tijoj-pokonal, roma pa quinic'ajal xquixc'oje-vi can. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Xtiquikasaj c'a pan ulef ri itinamit ivachibilan rix. Y chire ri itinamit man jun c'a jay ri xtipa'e' can. Ronojel-ronojel xquevulex. Roma can man nitzu' ta chi ri Dios xoka' yan iviq'uin, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Y tok ri Jesús apovinek chic c'a, rija' xoc-apo ri pa rachoch ri Dios ri c'o chiri' pa Jerusalem. Jari' tok rija' xerokotala-pe ri c'ayinela' y ri lok'onela' ri chiri' pa rachoch ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Y xubij c'a chuka' chique: Chupan ri ruch'abel ri Dios ri tz'ibatel can, nubij chi ri vachoch, jay richin oración. Jac'a rix xa achi'el quijul elek'oma' ibanon chire, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Y jac'ari' tok ri Jesús k'ij-k'ij xerutijoj ri vinek riq'uin ri ruch'abel ri Dios, ri chiri' chupan ri rachoch ri Dios. Pero ri principal-i' tak sacerdotes cachibilan ri etamanela' chirij ri ley y ri achi'a' ri can c'o-vi quik'ij chupan ri tinamit, niquicanola' c'a achique ta niquiben richin queri' niquicamisaj ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Y man niquil ta c'a achique niquiben, roma ri vinek can quicamben-vi ri nubij ri Jesús chique. Can nika-vi chiquivech nicac'axaj ri achique nuk'alajirisaj ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Y chupan jun chique ri k'ij ri', tok ri Jesús c'o ri pa rachoch ri Dios nuc'ut y nutzijoj ri utzilej ch'abel richin colotajic chique ri vinek, jac'ari' tok xe'oka' riq'uin, ri principal-i' tak sacerdotes, ri etamanela' chirij ri ley cachibilan ri rijita'k tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Y re achi'a' re' xquibij c'a chire ri Jesús: Tabij c'a chike: ¿Achique xyo'on k'atbel-tzij pan ak'a' richin xe'avokotaj-el ri vinek c'ayinela' re pa rachoch ri Dios? ¿Y achique xyo'on k'ij chave richin chi q'uiy ri ye'abanala' chiquicojol ri vinek? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Y ri Jesús xubij c'a chique: Yin c'o c'a chuka' jun ri ninvajo' ninc'utuj chive. Tibij c'a chuve: ");
INSERT INTO cakCNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ri Juan xtak-pe roma ri Dios richin xeruben bautizar ri vinek? ¿O xa vinek xebin chire chi tubana' queri'? xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pero ri principal-i' tak sacerdotes, ri etamanela' y ri rijita'k tak achi'a' ri c'o quik'ij, xquibila' c'a chiquivech: ¿Achique c'a xtikabij chire re Jesús vacami? xecha-ka. Roma vi nikabij chi ri Juan ja ri Dios takayon-pe richin, ri Jesús xtubij c'a chike chi achique c'a roma tok man xinimaj ta. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y vi nikabij chi xa vinek xebin chire ri Juan chi tubana' queri', xquepe conojel vinek y xkojquicamisaj chi abej. Roma ri vinek can quetaman-vi chi ri Juan can xuk'alajirisaj-vi ri xbix chire roma ri Dios, xecha' c'a ka chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Y c'ari' xquibij-apo chire ri Jesús chi man quetaman ta achique xbin chire ri Juan chi querubana' bautizar ri vinek, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Y ri Jesús xubij c'a chique ri achi'a' ri': Roma c'a rix man xixtiquir ta xibij chuve, que c'a chuka' ri' yin man xtinbij ta chive achique yoyon k'ij chuve richin yenbanala' quere', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Y ri Jesús xuchop c'a nich'on chiquivech ri vinek. Xuchop rubixic jun c'ambel-tzij chique, y xubij c'a: Xc'oje' c'a jun achin ri xutic ruvech ri rulef riq'uin uva. Y c'ari' xuya' can pa kajic chique ca'i-oxi' samajela'. Y rija' xbe richin q'uiy tiempo. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Y ri rajaf ri ulef ri' xutek c'a jun raj-ic' achin quiq'uin ri achi'a' ri e kajayon ri ulef, tok can tiempo chic richin chi niquiya' ri uva kajbel richin ri ulef. Jac'a tok xapon ri aj-ic' quiq'uin ri achi'a' ri e kajayon ri ulef, re kajoy tak ulef re' xquichop c'a ri aj-ic' y xquich'ey, y man jun c'a uva xquiya-el pa ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Y ri rajaf ri ulef xutek chic jun raj-ic' achin chuc'amic ri uva kajbel richin ri ulef. Pero ri achi'a' kajoy tak ulef xa xquichop y xquich'ey. Q'uiy c'a ri xquibanala' y xquibila-el chire, y man jun chuka' uva kajbel richin ri ulef xquiya' ta el chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pero ri rajaf ri ulef xutek chic c'a el jun raj-ic' achin chuc'amic ri uva kajbel richin ri ulef, pero can ja chuka' xuc'ulvachij. Xquisocola', y c'ari' xcokotaj-el. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Y pa ruq'uisibel c'a, ri rajaf ri ulef xubij: ¿Achique c'a xtintek-el? xcha'. Y rija' c'o c'a jun ruc'ajol ri janíla nrajo', y jari' ri xutek-el chuc'amic ri kajbel richin ri ulef. Roma ri rajaf ri ulef ri' xuch'ob chi ri achi'a' ri e kajayon ri rulef, riq'uin juba' can xqueniman-vi tok xtiquitz'et chi can ja ri c'ajolaxel ri napon. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero ri achi'a' ri e kajayon ri ulef, can xe xquitz'et ri ruc'ajol ri rajaf ri ulef, xquibij c'a chiquivech: Jare' ri xtichinan can ronojel re ulef re kakajon vacami. ¿Achique roma man nikacamisaj? Richin queri' pa kak'a' roj nic'oje-vi can re ulef, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Y can que vi c'a ri' xquiben. Xquelesaj-pe ri c'ajolaxel ri chiri' chupan ri rulef y xquicamisaj. C'ari' ri Jesús xubij: ¿Achique cami xtuben ri rajaf-ulef quiq'uin ri achi'a' kajoy tak ulef? ");
INSERT INTO cakCNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ri rajaf ri ulef xtipe c'a y xquerucamisaj ri kajoy tak ulef ri' y ri rulef xtuya' chic can pa kajic chique ch'aka' chic, xcha' ri Jesús. Tok ri vinek cac'axan chic ka ronojel re', xquibij: Man ta jun bey xtibanatej queri', xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Y ri Jesús xerutzu' c'a ri vinek, y xubij: ¿Achique cami nic'ulun-vi chi tzij ri nubij chupan ri ruch'abel ri Dios ri tz'ibatel can? Tok nubij: C'o c'a jun abej ri man xka' ta chiquivech ri ch'aka' banoy tak jay. Pero re abej re' can xch'acon-vi, roma re abej re' xa can c'o-vi ri xucusan chire ri jay richin chi ri jay ri' man nitzak ta, nicha', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Y ri vinek c'a ri xtitzak chuvech re jun abej re', can xtuvulaj-ri' chuvech. Y ri vinek ri xtika' ri abej ri' chirij, can xtuque'ej c'a, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Y ri principal-i' tak sacerdotes, y ri etamanela' chirij ri ley, can ja yan c'a ri' tok xcajo' yan niquichop-el ri Jesús, roma xquinabej chi ri achi'a' kajoy tak ulef ri xerunataj chupan ri c'ambel-tzij, xa chiquij rije' xch'on-vi. Pero man xquichop ta el, roma niquixibij-qui' chiquivech ri vinek ri ec'o riq'uin. Y xebe. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Y ri principal-i' tak sacerdotes y ri etamanela' ri' xequitek c'a pe ch'aka' chic achi'a' ri can choj ri quic'aslen nik'alajin, pero xa man e que ta ri'. Rije' xa nicajo' c'a niquiya' ta pa c'ayef ri Jesús, y nitzak ta pa quik'a' riq'uin ri ch'abel ri nubij. Y vi can nika' c'a ri Jesús pa quik'a', niquiya' pa ruk'a' ri k'atoy-tzij. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Y richin c'a chi niquiya' pa c'ayef ri Jesús, ri achi'a' ri' xquic'utuj c'a chire: Rat ri at jun Tijonel, roj can ketaman-vi chi can kitzij ri natzijoj. Man naxibij ta avi' chuvech jun vinek, stape' janíla ruk'ij. Y can nac'ut-vi ri ruch'abel ri Dios pa rubeyal. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tabij c'a chike: ¿Ruc'amon cami nikatoj ri alcaval ri nubij ri rey César ri c'o chi nikatoj, o xa man ruc'amon ta chi nikatoj chire? xecha' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero ri Jesús can retaman-vi c'a ri niquinojij chirij. Romari' rija' xubij c'a chique: ¿Achique c'a roma rix nitej ik'ij richin yinitejtobej? ");
INSERT INTO cakCNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tic'utu' c'a pe ri mero, xcha'. Y ri Jesús xuc'utuj c'a: ¿Achok vachibel la'? ¿Y achok bi' chuka' la c'o chuvech la mero? Y rije' xquibij chire: Richin ri rey César, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Y ri Jesús xubij c'a chique: Titojo' ri alcaval chire ri César riq'uin ri mero ri ruc'amon chi niya' chire rija'. Y tiya' chire ri Dios, ronojel ri ruc'amon chi niya' chire rija', xcha' ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Y ri achi'a' ri xec'utun chire ri Jesús, man c'a xech'acon ta chirij, roma ri Jesús ronojel tzij pa rubeyal yerubila' chique chiquivech ri vinek. Y can achique la xquina' tok xcac'axaj ri xubij ri Jesús chique. Y romari' man chic xech'on ta apo. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Y jac'ari' tok ch'aka' chique ri achi'a' saduceos xe'apon riq'uin ri Jesús. Re achi'a' re' man niquinimaj ta c'a chi ri caminaki' xquec'astej chic pe. Y roma c'a ri' rije' xquibij chire ri Jesús: ");
INSERT INTO cakCNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Rat ri at jun Tijonel chuka', c'o c'a jun ri nikajo' nikac'utuj chave. Ri Moisés can rutz'iban-vi c'a can chike chi tok jun achin nuya' can ri rixjayil roma ri niquen-el (nicom-el) y man jun ralc'ual nic'oje' can, can jun c'a rach'alal rija' ri c'o chi nic'ule' riq'uin ri malca'n-ixok, richin queri' yec'oje' ta ralc'ual riq'uin ri ixok malca'n. Y vi can ec'o ralc'ual yec'oje' riq'uin ri ixok, ri nabey ala' noc ralc'ual ri caminek chic el. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Y rije' xquibij c'a: Que c'a ri' xec'oje' e vuku' achi'a' cach'alal qui'. Ri nabey xc'ule'. Pero xquen-el (xcom-el), y man jun ralc'ual xc'oje'. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Xpe ri ruca'n achin, ri rach'alal can ri achin ri caminek chic el, xc'ule' c'a riq'uin ri malca'n-ixok. Pero chuka' re achin re' xquen-el (xcom-el), y man jun ralc'ual xc'oje'. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ri rox achin xc'ule' c'a chuka' riq'uin ri malca'n-ixok, pero can achi'el ri xquic'ulvachij-el ri e ca'i' nabey rach'alal, can que chuka' ri' xuc'ulvachij-el rija'. Y che vuku' achi'a' cach'alal qui' quere' xquic'ulvachila-el. Y man jun c'a chique re vuku' achi'a' re' xec'oje' ta can ralc'ual. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Y pa ruq'uisibel xquen c'a chuka' el (xcom c'a chuka' el) ri ixok. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Y ri achi'a' saduceos xquibij c'a chire ri Jesús: Rat nabij chi xtapon jun k'ij tok ri caminaki' xquec'astej-pe. Tok xtapon c'a ri k'ij ri', ¿achok ixjayil c'a xtoc re ixok re'? Roma che vuku' achi'a' cach'alal qui' xec'oje' riq'uin, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Y ri Jesús can jac'ari' xubij chique: Chuvech re ruvach'ulef, ri vinek can c'a yec'ule' na c'a y can c'a yeyatej na quimi'al-quic'ajol richin yec'ule'. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Jac'a ri e caminaki' chic el, manek chic c'ulubic chiquivech. Romari' ri xquec'astej-el y yo'on k'ij chique richin yebe chila' chicaj, man xquec'ule' ta chic, ni man xqueyatej ta chuka' el quimi'al-quic'ajol richin yec'ule'. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Roma rije' man chic xtapon ta ri camic quiq'uin, roma xque'oc achi'el ri ángeles y chuka' e ralc'ual ri Dios roma e c'astajinek chic el. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Y ri caminaki' can yec'astej-vi. Roma ri Moisés rutz'iban can chupan ri ruch'abel ri Dios, tok rija' xutz'et ri ruxulu-quiej, ri jun k'ayis c'o ruq'uixal, nic'at, y xrac'axaj tok xubij ri Dios: Ja yin ri ru-Dios ri Abraham, ri ru-Dios ri Isaac, y ri ru-Dios chuka' ri Jacob, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Y vi ta rije' e caminaki' richin jantape', y xa man ta yec'astej chic pe jun bey, ri Dios man ta qui-Dios rije', roma ri Dios can qui-Dios vi ri c'o quic'aslen y man quichin ta ri caminaki'. Roma chuvech ri Dios rije' can e q'ues vi, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Y ec'o c'a chique ri etamanela' chirij ri ley ri xquibij chire ri Jesús: Tijonel, xecha' chire. Can kitzij vi ri xabij, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y man chic c'a xquiben ta covil richin c'o ta xquic'utuj-apo chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Y c'ari' ri Jesús xubij c'a chique: ¿Achique roma tok nibix chi ri Cristo xa choj jun riy-rumam can ri rey David? ");
INSERT INTO cakCNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tok xa can ja ri rey David biyon can chupan ri vuj ri rubini'an Salmos: Chi ri Ajaf Dios xubij chire ri Vajaf ri Cristo: Catz'uye-pe re pa vajquik'a', ");
INSERT INTO cakCNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","y xquenya' pan ak'a' ri ye'etzelan avichin, nubij. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Y can k'alaj vi c'a chi ri rey David tok xc'ase' vave' chuvech re ruvach'ulef, xubij Vajaf chire ri Cristo. ¿Y achique c'a roma tok nibix chi ri Cristo xa choj jun riy-rumam can ri rey David? xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Y conojel c'a ri vinek ri quimolon-qui' ri chiri', xcac'axaj tok ri Jesús xubij chique ri rutijoxela': ");
INSERT INTO cakCNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Man c'a tiben achi'el niquiben ri achi'a' e etamanela' chirij ri ley. Roma rije' yalan nika' chiquivech niquicusaj tukutek tak tziek, richin queri' titz'et chi janíla quik'ij. Janíla chuka' nika' chiquivech chi yek'ejelox can (yek'ijalox can) ri pa bey ri acuchi nequimolo-vi-qui' ri vinek. Y ri pa tak nima-jay ri can nitzijox-vi ri ruch'abel ri Dios, can jac'a ri nabey tak ch'aquet yequicanola', richin queri' tibix chi janíla quik'ij. Y can que c'a chuka' ri' yequibanala' ri pa nima'k tak va'in. ");
INSERT INTO cakCNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Y re achi'a' c'a chuka' re' yequelesala' ronojel qui-cosas ri malcani'a' tak ixoki'. Y xe richin quenimex chi rije' e utz tak vinek, yeyaloj tok yequibanala' oración chire ri Dios. Pero rije' can xtika-vi más ruc'ayeval pa quivi', roma ri quimac janíla q'uiy, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ri chiri' c'a ri pa rachoch ri Dios, ri Jesús xerutz'et c'a chi ri vinek beyoma' niquiyala' can mero ri chiri' acuchi niyalox-vi can ri mero pa rachoch ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Y que c'a chuka' ri' xutz'et jun malca'n-ixok ri can nik'alajin chi man beyon ta, chi xuya' can ca'i' tak mero ri man rubanon ta ni jun centavo. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Y tok ri Jesús xutz'et re jun malca'n-ixok re', xuc'ut c'a chiquivech ri rutijoxela', y xubij chique: Can kitzij c'a ninbij chive chi yin nintz'et chi xa ja la ixok la' ri xyo'on can más q'uiy que chiquivech ri e yoyon can mero. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Roma rija' stape' can man jun oc ri c'o riq'uin, xuya' c'a can ronojel ri c'o riq'uin, y xuya' can chupan la acuchi ec'o-vi ri sipanic ri e banon chire ri Dios. Jac'a la beyoma', stape' janíla q'uiy mero niquiyala' can, xa juba' oc chire ronojel ri beyomel ri c'o quiq'uin, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Y ec'o c'a ri quichapon tzij chirij ri rachoch ri Dios. Y niquibila' c'a chi janíla jebel rubanic, chi ruyon jebel tak abej ri e ucusan richin banon, y chi ronojel ri vikobel (vekobel) ruyon sipanic quichin ri vinek, xecha'. Y ri Jesús xubij c'a chique: ");
INSERT INTO cakCNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Xtapon c'a jun k'ij tok ronojel re nitz'et vave' xquevulex na y man xquepa'e' ta chic can. Ronojel re nimalej tak abej re e ucusan chire re jay re', xa can xquec'akalox c'a pe. Can man jun c'a abej ri xtic'oje' ta can achi'el la rubanon vacami, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Y ri tijoxela' xquic'utuj c'a chire ri Jesús: Tijonel, xecha'. ¿Jampe' c'a xtic'ulvachitej ri xabij yan ka chirij ri rachoch ri Dios? ¿Y achique retal richin queri' ninabex chi nibanatej yan? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Y ri Jesús xubij chique: Can jebel c'a tichajij-ivi' richin man yixk'olotej. Roma e q'uiy ri xquepe, xtiquibij: Ja yin ri Cristo. Ja tiempo re' xoka', xquecha'. Pero rix man que'inimaj, ni man chuka' que'itzekelbej. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Y tok xtivac'axaj c'a chuka' chi ec'o ruvach'ulef c'o oyoval najin chiquicojol o ri vinek pa ch'aka' tinamit niquibanala-ka oyoval chiquivech, man c'a tixibij-ivi', roma nabey can c'o na chi nibanatej quere', pero man can ta ja chuka' re' ri ruq'uisibel tak k'ij richin re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Y ri Jesús xubij c'a chuka': Jun tinamit xtiyacatej-el richin nerubana' oyoval riq'uin jun chic tinamit. Ec'o c'a chuka' e nima'k tak ruvach'ulef xqueyacatej-el richin chi nequibana' oyoval quiq'uin ch'aka' chic nima'k tak ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Xquepe nimalej tak silonel (cab-raken), vayjal y yabil xabachique lugar chire re ruvach'ulef. Xtuya' c'a jun nimalej xibinri'il ri xquebanatej y xquetz'etetej chupan re caj, ri man jun bey e tz'eton ta. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Y tok man jani tibanatej ronojel re', rix xquixchap y xtiban c'a chive chi nitej pokon, roma ri ruch'abel ri Dios. Xquixuc'uex c'a chiquivech ri principal-i' ri pa tak nima-jay ri can nitzijox-vi ri ruch'abel ri Dios. Xquixtz'apex pa cárcel. Xquixuc'uex chiquivech k'atoy tak tzij; chiquivech reyes y ch'aka' chic k'atoy tak tzij. Ronojel c'a re' xtic'ulvachila' roma ic'uan ri nubi' yin. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Y tok quere' c'a xtiban chive coma ri vinek, jari' tok xquixtiquir xquinik'alajirisaj chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Y can toka' c'a chi'ic'u'x chi man jun nic'atzin-vi chi rix janíla nich'ob ri achique c'o chi ne'ibij richin nito-ivi', ");
INSERT INTO cakCNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","roma can ja yin ri xquiyo'on ch'abel chive. Y xtinya' chuka' etamabel chive richin queri', riq'uin ri etamabel ri' xtitz'apej quichi' ri ye'etzelan ivichin. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Y xquixjachalox c'a pa quik'a' ri ye'etzelan ivichin. Y riq'uin juba' ri ite-itata', ri ivach'alal o ri can e ivachibil ri xquejachon ivichin. Y ec'o c'a chive rix ri can xquecamisex. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Xa can xquixetzelex-vi c'a coma conojel, roma icukuban ic'u'x viq'uin yin. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero man c'a tixibij-ivi', roma ri Dios can yixruchajij-yixruvaraj, y chuvech rija' man jun ti rusmal ivi' ri xtitzak can choj queri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Y vi nicoch' ronojel, xtivil c'a ri utzilej c'aslen ri man q'uisel ta. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Y tok xtitz'et c'a chi ri tinamit Jerusalem surin rij (sutin rij) coma achi'a' e richin oyoval, tivetamaj c'a ri' chi xa juba' chic tiempo nrajo' richin chi ri tinamit xtivulex. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Romari', vi rix ixc'o pa Judea, quixanmej c'a el y te'ivevaj-ivi' ri pa tak juyu'. Y vi pa tinamit Jerusalem ixc'o-vi, quixanmej c'a pe chupan. Y vi pa tak juyu' ixc'o-vi, man chic c'a quixtzolin-apo ri pa tinamit. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Roma tok xtapon c'a ri k'ij richin ri tijoj-pokonal, jac'ari' tok ri tinamit ri' xtuc'ul ruq'uexel ronojel ri e rubanalon, y can xtibanatej c'a ronojel ri tz'ibatel can chupan ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Y chupan ri k'ij ri' xtic'o c'a ruvi' tijoj-pokonal xtipe pa ruvi' re ruvach'ulef. Can xtika' c'a ri royoval ri Dios pa ruvi' re tinamit re'. Y roma ri tijoj-pokonal ri', c'ayef c'a xtuben chique ri ixoki' ri coyoben chic alanen y chuka' c'ayef xtuben chique ri ixoki' ri c'a niquiya' na quitz'un tak cal. Can tok'ex c'a quivech ri e te'ej chupan ri tiempo ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","E janíla c'a q'uiy vinek xquequen (xquecom) pa quik'a' ri achi'a' e richin oyoval. Y ri ch'aka' chic chique ri vinek xque'uc'uex-el coma ri achi'a' e richin oyoval. Xque'uc'uex c'a pa ch'aka' chic ruvach'ulef. Y re tinamit Jerusalem xtixek'-xtipalibex coma vinek ri xa man e israelitas ta. Pero man richin ta c'a jantape' queri' xtiquiben, roma ri k'ij ri yo'on chique xa xtic'o. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Y q'uiy c'a ri man jun bey e banatajinek ta y man jun bey e tz'eton ta xquec'ulvachitej chupan ri k'ij, ri ic' y ri ch'umila'. Y ri vinek c'a ri ec'o chuvech re ruvach'ulef man xtiquil ta achique xtiquiben, xa xtisach quic'u'x roma ri nimalej ya' nibix mar chire, can xtic'o c'a ruvi' xtik'ajan, roma xtibolko't janíla. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Y ri vinek roma ri can coyoben c'a ri achique xtic'ulvachitej chuvech re ruvach'ulef, xtipe quicamic roma ri xibinri'il ri'. Roma hasta ronojel ri nimalej tak uchuk'a' ri e richin ri chicaj xquesilon roma ri ruchuk'a' ri Dios. Can chi jun vi c'a ri caj xtisilon. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Y jac'ari' tok xquinquitz'et yin ri xinalex chi'icojol, chi yika-pe pa jun sutz', riq'uin chic nimalej uchuk'a' y riq'uin chuka' chic jun nimalej nuk'ij-nuc'ojlen, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Y jac'a rix, xcha' ri Jesús chique ri rutijoxela', tok xtitz'et chi ronojel re' yec'ulvachitej chic, quixquicot y tic'oje-el más ivuchuk'a', roma can napon yan ri k'ij richin yixcolotej-el chuvech ronojel tijoj-pokonal richin re ruvach'ulef, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Y jac'ari' tok rija' xubij chuka' jun c'ambel-tzij chique: Que'itzu' na pe' ri che', xcha' ri Jesús. Titzu' ri víquix (higo) o xabachique chic chi che'. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tok xa can niquichop yan pe quelic ri quixak, ivetaman c'a ri' chi ri ru-tiempo ri job noka' yan. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Y que c'a ri' tok xtitz'et chi ec'o chic yec'ulvachitej chupan ri k'ij, ri ic' y ri ch'umila', y ronojel ri xinbij yan ka nibanatej chic, tivetamaj c'a ri' chi noka' yan ri k'ij chire ri utzilej ruk'atbel-tzij ri Dios. Rija' can noc'oje' c'a chikacojol. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Y tivac'axaj c'a jebel re xtinbij chive re vacami: Ronojel re' xtic'ulvachitej, tok ri vinek richin re tiempo re' c'a man jani queq'uis-el chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Y re ruvach'ulef y ri caj can e richin vi yeq'uis. Jac'a ri nuch'abel man xtiq'uis ta queri', xa can xtibanatej-vi ri nubij. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Y tichajij c'a ri ic'aslen. Man tibe ivánima chirij ri va'in; man quixk'aber; y chuka' man xaxe ri nic'atzin chive chuvech re ruvach'ulef ri nich'ob, y c'a tok xtina' xa jari' xoka' ri k'ij, richin chi yin xquinoka'. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Xa xtoka' achi'el jun colo' ri nirarin (nirapin). Queri' rubanic tok xtoka' pa quivi' conojel ri vinek ri ec'o chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Roma c'a ri' can tichajij-apo jebel ri ic'aslen. Y tibana' chuka' orar jantape', richin yixcolotej chuvech ronojel ri tijoj-pokonal ri xtipe pa ruvi' re ruvach'ulef, y richin chuka' utz yixapon c'a chinuvech yin ri xinalex chi'icojol, xcha' ri Jesús chique ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Y ri pak'ij, ri Jesús c'o c'a chiri' ri pa rachoch ri Dios, yerutijoj ri vinek riq'uin ri ruch'abel ri Dios. Y ri chak'a' nibe ri chiri' pa juyu' rubini'an Olivos, y chiri' nic'oje-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y roma c'a ri Jesús nutzijoj ri ruch'abel ri Dios ri chiri' pa rachoch ri Dios, can e janíla c'a vinek ri ye'apon nimak'a' yan richin nicac'axaj. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Y xa chua'k-cabij c'a ri quinimak'ij ri israelitas chiri', jun nimak'ij tok niquitej caxlan-vey ri manek ch'en (ch'amilej-k'or) riq'uin, y niquibij pascua chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Y jari' c'a tok ri principal-i' tak sacerdotes y ri etamanela' chirij ri ley niquich'obola' c'a achique ta rubanic niquiben richin queri' niquicamisaj ri Jesús. Pero xa quixibin-qui' chiquivech ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Y ri Judas ri jun chique ri cablajuj rutijoxela' ri Jesús, ri tijoxel ri xbix chuka' Iscariote chire, can nisamej chic vi ri Satanás pa ránima. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Romari' ri Judas ri' xbe c'a quiq'uin ri principal-i' tak sacerdotes y quiq'uin chuka' ri ye'uc'uan quichin ri e chajinela' ri chiri' pa rachoch ri Dios, y xch'on quiq'uin chirij ri achique rubanic xtuben richin nujech ri Jesús pa quik'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Y rije' can janíla c'a xequicot tok xcac'axaj ri', y xquisuj ru-mero romari'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ri Judas can xberusuju' c'a can ri Jesús chique. Y xuchop c'a ruch'obic jampe' tok xtujech pa quik'a', y can c'a ja tok man quimolon ta qui' vinek riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tok xoka' ri nimak'ij, k'ij richin nitij ri caxlan-vey manek ch'en (ch'amilej-k'or) riq'uin, y tok yecamisex chuka' ri tak carne'l ri richin ri pascua, ");
INSERT INTO cakCNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ri Jesús xerutek c'a el ri Pedro y ri Juan, y xubij c'a el chique: Quixbiyin y tibana' rutzil ri xtikatej chupan re pascua re'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Y ri ca'i' tijoxela' xquic'utuj c'a chire: ¿Acuchi c'a navajo-vi chi nikaben ruchojmil? ");
INSERT INTO cakCNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Y ri Jesús xubij chique: Tok xquixapon ri pa tinamit Jerusalem, xtitz'et c'a chi c'o jun achin aj-ic' ri ruc'amon-pe ruya' pa jun cucu' (k'e'l). Tivojkaj c'a el re achin re' c'a achique jay xtoc-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Y tibij c'a chire ri tata'aj chupan ri jun jay ri': Ri Katijonel rubin c'a pe: ¿Achique jay re vave' pan avachoch ri utz ta richin ninben ri va'in richin re pascua e vachibilan ri nutijoxela'? quixcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Y ri rajaf-jay xquixruc'uaj c'a pa jun ruca'n vik jay (cavek jay). Y chiri' c'o jun nima-jay ri chojmirisan chic rupan. Ja ri chiri' tibana-vi rutzil ri xtikatej richin re pascua, xe'uche'ex-el. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Y ri ca'i' tijoxela' xebe c'a. Y can achi'el ri rubin-el ri Jesús chique, can queri' ri xbanatej. Y rije' can xquiben-vi c'a rutzil ronojel ri nic'atzin richin ri va'in richin ri pascua ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Y tok xapon c'a ri hora, ri Jesús y ri cablajuj apóstoles xetz'uye-apo ri pa mesa. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Y ri Jesús xubij c'a chique: Can janíla nurayiben-pe chi nabey chi yinapon chuvech ri camic, junan nikaben can re jun va'in richin re jun pascua re'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Roma can ninbij-vi c'a chive, chi can c'a ja tok c'o chic na ri utzilej ruk'atbel-tzij ri Dios, y tok banatajinek chic na ronojel ri nic'ulun-vi chi tzij ri pascua, can c'a jari' tok xtinben chic re jun va'in re'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Y ri Jesús xuchop c'a jun vaso ri c'o ruya'al-uva chupan, y tok rumatioxin chic chire ri Dios, xubij: Tikumu' c'a can chi'ivonojel. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Roma can ninbij-vi c'a chive, chi can c'a ja tok c'o chic na ri utzilej ruk'atbel-tzij ri Dios, can c'ari' tok xtinkun chic jun bey ruya'al-uva. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Y que c'a chuka' ri' xuq'uen-apo jun caxlan-vey, y tok rumatioxin chic chire ri Dios, xuper (xupir) ri caxlan-vey y xuya' chique ri rutijoxela' y xubij: Re' natabel vichin yin. Can titija' c'a. Roma ri nuch'acul can xtijach c'a richin chi napon pa camic, richin yixcolotej. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Y tok e va'inek chic, ri Jesús xuchop c'a chuka' ri vaso ri c'o ruya'al-uva chupan, y xubij: Re ruya'al-uva re', jare' ri nuquiq'uel ri xtibiyin tok xquiquen (xquicom). Riq'uin c'a re nuquiq'uel re', can jac'are' xc'achoj ri c'ac'a' trato ri rajovan-pe ri Dios chi nuben quiq'uin ri vinek. Ri nuquiq'uel ri xtibiyin, richin chi yixcolotej. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Y vacami c'a, ri achin ri xquijachon-el pa quik'a' ri vinek, can c'o c'a pe viq'uin re pa mesa. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Can tivac'axaj c'a re ninbij chive, chi yin ri xinalex chi'icojol, can yibe-vi pa camic, roma can jare' ri ruch'obon ri Dios pa nuvi'. Pero tok'ex c'a ruvech ri xtijachon-el vichin yin ri xinalex chi'icojol, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Y jari' tok ri rutijoxela' ri Jesús niquibila-ka chiquivech chi achique cami ri xtijachon-el richin ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Y re tijoxela' re' xquich'ojila' c'a chuka' chiquivech achique ri más nim ruk'ij chiquicojol rije'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero ri Jesús xa xubij chique: Ri k'atoy tak tzij richin re ruvach'ulef, roma can ec'o ri vinek pa quik'a', romari' can niquina' chi ja rije' ri e cajaf. Y ri achi'a' can c'o quik'a' chique ri vinek, can achi'a' e banoy-utzil nibix chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jac'a chi'icojol rix nutijoxela' man que ta ri'. Roma ri más nim ruk'ij chi'icojol rix, nic'atzin chi nuna-ka-ri' chi xa más co'ol que chiquivech ri rachibil. Y ri jun chive rix ri nic'oje' pan ivi', nic'atzin chi nuna-ka-ri' chi xa manek ruk'ij y nuch'utinirisaj-ri' richin nusuj-ri' chubanic xabachique samaj. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Roma c'a ri', ¿ja cami ri c'o pa mesa nilix-apo ri más ruk'ij, o ja ri ilinel? ¿Man ja ta cami ri c'o pa mesa nilix-apo ri más ruk'ij? Pero chinuvech yin man que ta ri', roma yin xa achi'el ri ilinel inc'o chi'icojol. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Rix can ixc'o c'a pe viq'uin chupan ri tijoj-pokonal ri yetejtoben vichin. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Roma c'a ri', yin xtinya' jun k'atbel-tzij pan ik'a' rix, can achi'el ri rubanon ri Nata' Dios viq'uin yin, ");
INSERT INTO cakCNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","richin queri' xquixva' y xquixuc'ya' pa jun misma mesa viq'uin, tok xa can c'o chic c'a k'atbel-tzij pa nuk'a' yin. Y rix xquixoc c'a k'atoy-tzij pa quivi' ri cablajuj tak tinamit rubanon re nimalej tinamit Israel. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Y ri Ajaf Jesús xubij c'a chuka' chire ri jun tijoxel nibix Pedro chire: Simón, Simón, ninbij c'a chave chi ri Satanás xixruc'utuj yan chire ri Dios richin chi yixrutejtobej. Can nrajo' c'a yixrusiloj achi'el nisilox ri trigo chupan ri chaybel. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero yin can nubanon-vi orar avoma rat, richin queri' can tacukuba' ac'u'x viq'uin. Can xcatapon-vi pa ruk'a' ri Satanás. Pero tok xtitzolin-pe ac'u'x viq'uin, tabana' chique ri ch'aka' chic nutijoxela' chi can tiquicukuba-vi quic'u'x viq'uin, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Y ri Simón xubij: Ajaf, vi rat xcatuc'uex pa jun cárcel, yibe aviq'uin. Hasta yibe aviq'uin, vi rat xcatapon chuvech ri camic, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pero ri Jesús xubij chire: Pedro, yin ninbij c'a chave, chi chupan re ak'a' vacami, man jani tisiq'uin-pe ri mama' tok rat oxi' yan bey tabij chique ri yec'utun chave, chi man avetaman ta nuvech, xcha' ri Jesús chire ri Pedro. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Y ri Jesús xuc'utuj c'a chique ri rutijoxela': Tok ri jun bey xixintek y man xinvajo' ta richin xic'uaj pekes (morral), ni mero, ni jun chic c'ulaj xajab, ¿c'o cami ri xivajo' y man xivil ta? xcha'. Y rije' xquibij chi man jun. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Y ri Jesús xubij c'a chique: Jac'a re vacami jun vi chic ri rubanic nrajo'. Roma vacami ri c'o pekes (morral) riq'uin, tuc'uaj. Ri c'o ru-mero, tuc'uaj chuka'. Y ri manek rumachet, tuc'ayij ri ruk'u' y c'ari' tulok'o' jun richin. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Y vacami quere' ninbij chive, roma c'o chi nibanatej achi'el ri nubij chupan ri ruch'abel ri Dios ri tz'ibatel can. Ri chiri' nubij c'a: Can achi'el chuka' jun aj-mac xban chire. Queri' ri tz'ibatel can. Y re' can xtibanatej na vi viq'uin yin. Ronojel c'a ri e tz'ibatel can chuvij yin chupan ri ruch'abel ri Dios, can xquebanatej na vi, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Y ri tijoxela' xquibij c'a chire ri Jesús: Ajaf, vave' c'o ca'i' machet. Pero ri Jesús xubij chique: Man chic tinataj ri', xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ri Jesús tok elenek chic c'a el ri chiri', xbe c'a ri acuchi can tibe-vi. Rija' xbe c'a ri pa juyu' Olivos. Y ri rutijoxela' can e tzeketel-vi el chirij. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Y tok xe'apon c'a, xubij chique: Tibana' orar y tic'utuj chire ri Dios richin chi tok yixtejtobex man quixtzak pa mac. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Y ri Jesús xbiyin chic c'a apo jun ca'i' raken-c'an, xxuque-ka chiri', y xuchop c'a nuben orar. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Y nubij c'a ri pa ru-oración: Nata' Dios, tabana' c'a chi man ta ninc'ovisaj re jun tijoj-pokonal re', vi can queri' ri navajo' chuka' rat. Pero man taben chuka' ri ninrayij yin, xaxe voma ta yin. Roma yin can ninvajo-vi c'a ninben ri arayibel rat, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Y c'o c'a jun ángel ri petenek chila' chicaj xuc'ut-ri' chuvech, richin noruya-ka ruchuk'a' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Y can janíla c'a k'axo'n ri c'o pa ránima rija'. Romari' can riq'uin c'a ronojel ránima nuben orar. Y roma chuka' ri k'axo'n ri', ri ya' ri nel chirij man choj ta ya'. Xa achi'el chic nima'k tak tz'uj quic' ri yeka' pan ulef. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tok ri Jesús xbeyacatej-pe ri acuchi xucul-vi nuben orar, xpe c'a quiq'uin ri rutijoxela', pero tok xoka' quiq'uin, xa quichapon varan, roma bis y cosic noc chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Y ri Jesús xubij c'a chique ri rutijoxela' ri': ¿Achique roma xa yixver? Quixyacatej, tibana' orar y tic'utuj chire ri Dios richin chi tok yixtejtobex, man quixtzak pa mac, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Y can c'a nich'on na c'a ri Jesús quiq'uin ri rutijoxela', tok c'a xquina' xe'apon e q'uiy vinek quiq'uin. Y can jac'a ri jun chique ri cablajuj rutijoxela' ri rubini'an Judas, can jac'ari' ri uc'uayon-apo quibey ri vinek ri'. Y ri Judas xjel-apo riq'uin ri Jesús richin xutz'ubaj (xutz'umaj). ");
INSERT INTO cakCNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero ri Jesús xubij c'a chire ri Judas: ¿Xinatz'ubaj (Xinatz'umaj) yin ri xinalex chi'icojol, xe richin yinac'ayij-el pa quik'a' ri ye'etzelan vichin? xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Y ri tijoxela' tok xquitz'et ri najin rubanic, xquinabej ri achique ri xtec'ulvachitej. Romari' xquibij c'a chire: Ajaf, ¿yojyacatej chiquij riq'uin machet? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Y can c'o na vi c'a jun chique ri tijoxela' ri xusoc jun samajel richin ri nimalej sacerdote. Can xuchoy na vi ri ruxiquin. Y ri ruxiquin ri xuchoy ja ri c'o pa rajquik'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Y ri Jesús xubij c'a chique ri rutijoxela': Man chic c'a jun tiben. Y xpe rija' xuchop ri ruxiquin y xuc'achojirisaj can. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Y can jac'a ri principal-i' tak sacerdotes, ri e uc'uey quichin ri achi'a' e chajinela' pa rachoch ri Dios, y ri rijita'k tak achi'a' c'o quik'ij, jac'ari' ri e benek chapoy richin ri Jesús. Y rija' xubij chique: ¿Achique c'a xich'ob rix? ¿Xich'ob chi yixpe chuchapic jun elek'on y romari' ic'amon-pe che' y machet? ");
INSERT INTO cakCNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Can k'ij-k'ij c'a xic'oje' iviq'uin ri pa rachoch ri Dios, y man jun achique ta xiben chuve. Pero c'a jac'a hora re' ri yo'on chive rix, hora tok xtich'acon ri k'eku'n, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xquichop c'a el ri Jesús, y xquic'uaj pa rachoch ri nimalej sacerdote. Y ri Pedro e rutzekelben-el, pero c'anej c'o-vi can chiquij. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Y ri chiri' pa nic'aj ruva-jay, ri rusamajela' ri nimalej sacerdote xquibox k'ak', y xetz'uye-apo conojel ri chuchi-k'ak'. Y chuka' ri Pedro xtz'uye-apo chiquicojol. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Y jun c'a ixok raj-ic' ri nimalej sacerdote, tok xutz'et ri Pedro chi tz'uyul chiri' rumek'on-ri', xutzu-xutzu' y xubij: Re jun achin re' rachibil chuka' ri Jesús, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero ri Pedro xa xrevaj c'a chuvech ri ixok, y xubij: Yin man vetaman ta ruvech ri Jesús, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Y c'a juba' ri' c'o chic c'a jun ri xtz'eton-pe richin ri Pedro, y xubij chire: Rat, jun chique ri ec'o riq'uin ri Jesús, xcha'. Ri' man yin ta ri', xcha' ri Pedro chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","C'a jun la'ek hora tik'ax-ka ri', tok c'o chic c'a jun ri xbin chirij ri Pedro: Re achin re', can kitzij vi chi xc'oje' riq'uin ri Jesús, roma can aj-Galilea chuka', xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero ri Pedro xubij chire ri achin: Man nik'ax ta chinuvech achique roma nabij queri', xcha' ri Pedro. Y can c'a nich'on na c'a ri Pedro, tok ri mama' xsiq'uin-pe. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Y ri Ajaf Jesús xtzu'un-pe chirij y xutzu-pe ri Pedro. Y ri Pedro can jac'ari' xoka' chuc'u'x ri rubin can ri Ajaf chire, chi c'a man jani tisiq'uin-pe ri mama' tok rat oxi' yan bey tabij chique ri yec'utun chave, chi man avetaman ta nuvech. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Y ri Pedro xel c'a el y xujik' ok'ej. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Y ri achi'a' ri e chajiyon c'a richin ri Jesús, yetze'en c'a chirij y niquich'ey c'a. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","C'ari' xquitz'apej runak'-ruvech y xquich'ayila' chupalej y niquic'utula' c'a chire: ¿Achique ri xach'ayon? Tabij na c'a chike, yecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Y c'o c'a q'uiy ri man utzilej tak tzij ta ri xquibila' chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tok xseker c'a pe, xquimol c'a qui' ri rijita'k tak achi'a' ri c'o quik'ij, ri principal-i' tak sacerdotes, y ri etamanela' chirij ri ley chuka'. Y ri Jesús xuc'uex c'a apo chiquivech ri achi'a' ri', ri can pa comon yek'aton tzij. Y xquic'utuj c'a chire ri Jesús: ");
INSERT INTO cakCNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tabij c'a chike: ¿Jac'a rat ri Cristo? xecha'. Pero ri Jesús xubij chique: Vi ninbij chive chi ja yin ri Cristo, man yininimaj ta. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Y chuka' vi ta c'o ri yenc'utuj-apo chive, man jun xtibij-pe chuve, ni man chuka' xquinivisk'opij ta el. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Y tok xtik'ax c'a can re jun tijoj-pokonal re', yin ri xinalex chi'icojol, xquibetz'uye' c'a pa rajquik'a' ri Dios ri nitiquir nuben ronojel, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Can jac'ari' tok conojel xec'utun-apo chire ri Jesús: ¿Can jac'a rat ri Ruc'ajol ri Dios? xecha'. Ja', queri', can achi'el ri c'ari' nibij-ka rix, xcha' ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Y rije' xquibij: Man jun chic tzij nic'atzin chike richin niketamaj chi re Jesús can aj-mac vi. Roma konojel xkac'axaj ri c'ari' nubij-ka, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Y c'ari' c'a, conojel ri ec'o chiri' xeyacatej c'a el, y xquic'uaj-el ri Jesús richin nequijacha' pa ruk'a' ri jun k'atoy-tzij rubini'an Pilato. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Y ri chiri' chuvech ri k'atoy-tzij, niquisujula' c'a apo y niquibij: Roj ketaman chi re Jesús q'uiy rumac. Rija' nuya' quina'oj ri vinek. Rija' nubila' chuka' chique ri vinek chi man tiquitoj ri alcaval chire ri rey César. Y chuka' nubila' chi ja rija' ri Cristo, y re' can nuk'alajirisaj c'a chi ja rija' ri Rey, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Y ri Pilato xuc'utuj c'a chire ri Jesús: ¿Ja rat ri qui-Rey ri israelitas? xcha' chire. Y ri Jesús xubij chire: Ja', queri'. Can achi'el ri xabij, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Y c'ari' ri Pilato xubij chique ri principal-i' tak sacerdotes y chique ri vinek chuka': Yin man jun ch'a'oj ninvil chirij re jun achin re', xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero rije' man yetane' ta ka. Xa niquitej c'a quik'ij chi niquibila-apo: Xa nuya' quina'oj ri vinek pa ronojel tinamit richin re Judea. Chila' c'a pa Galilea ruchapon-pe rubanic. Y queri' nubanala' ri petenek, y c'a tok xkana' xoka' chuka' re vave' pa tinamit Jerusalem, xecha-apo. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Y tok ri Pilato xrac'axaj ri c'ari' niquibij-ka, xuc'utuj c'a chi vi aj-Galilea ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tok xbix c'a chire chi kitzij, rija' xutek c'a el ri Jesús chire ri Herodes, ri k'atoy-tzij richin ri Galilea. Y man c'ayef ta xuben roma ri Herodes c'o c'a chiri' pa tinamit Jerusalem ri k'ij ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Y tok ri Herodes xutz'et ri Jesús, janíla xquicot ránima, roma can q'uiy yan c'a k'ij rurayin chi rutz'eton ta. Y q'uiy c'a ri rac'axan chirij. Romari' can rubanon c'a chi can xtutz'et na jun bey tok nuben jun milagro. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Y ri Herodes q'uiy c'a ri xeruc'utula' chire ri Jesús, pero ri Jesús man jun tzij xubij chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Y can ec'o c'a apo chuka' ri principal-i' tak sacerdotes y ri etamanela' chirij ri ley, richin niquisujuj ri Jesús. Rije' can niquitej c'a quik'ij richin yesujun-apo. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Y ri Herodes y ri e ru-soldados can man jun ruk'ij xquiben chire ri Jesús y xquitze'ej. Xquiya' c'a jun tziek chirij, can achi'el ri yequicusala' ri reyes. Roma chiquivech rije' xa man jun ruk'ij ri Jesús. Y c'ari' c'a ri Herodes xutzolij chic el chire ri Pilato. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ri Herodes y ri Pilato c'o oyoval chiquicojol. Jac'a ri k'ij ri' xa junan quivech xuben can. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Y c'ari' ri Pilato xeroyoj ri e principal-i' tak sacerdotes y ri e cachibil, ri pa comon yek'aton tzij. Y chuka' xeroyoj ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Y c'ari' xubij chique: Rix xo'iya' re Jesús pa nuk'a', y nisujuj chi nuyala' quina'oj ri vinek. Pero can chivech c'a rix xinc'utuj-vi chire, y yin nintz'et chi man e rubanalon ta ri ch'a'oj ri nibij rix richin xo'isujubej. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Y chuka' ri Herodes man jun xril chirij, tok xixintek-el riq'uin, y romari' xutzolij chic pe pa nuk'a' yin. Xaxe riq'uin ri' niketamaj chi man jun ch'a'oj rubanon richin queri' nika' ta ri camic pa ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Xtintek c'a ruch'ayic, y c'ari' nincol-el, xcha' ri Pilato. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Y ri k'atoy-tzij can c'o c'a chi nucol-el jun preso, roma queri' niban ronojel juna' pa ru-tiempo ri pascua, ri jun quinimak'ij ri israelitas. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Romari' conojel junan xech'on-apo riq'uin uchuk'a', y xquibij: ¡Ja ri Barrabás tacolo-el, y ri Jesús ticamisex! xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Y ri Barrabás kajinek c'a pa cárcel roma xyacatej chirij ri k'atbel-tzij ri chiri' pa tinamit, y rubanon chuka' camic. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Y ri Pilato, roma c'a can nrajo-vi nucol-el ri Jesús, xch'on chic c'a jun bey chique ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero ri vinek xech'on-apo riq'uin cuchuk'a', y xquibij: ¡Ticamisex chuvech cruz! ¡Ticamisex chuvech cruz! ");
INSERT INTO cakCNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Y pa rox bey ri Pilato xubij c'a chique: ¿Achique c'a mac rubanon chivech re jun achin re'? Yin man jun ch'a'oj ninvil chirij, richin chi nika' ta ri camic pa ruvi'. Xtintek c'a ruch'ayic, y c'ari' nincol-el, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero ri vinek y ri principal-i' tak sacerdotes, can riq'uin c'a uchuk'a' niquic'utuj-apo chi ticamisex ri Jesús chuvech cruz. Can nik'alajin c'a chi ja ri ch'abel ri xquibila-apo rije' ri xtech'acon. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Y jari' tok ri Pilato xubij chi tiban c'a achi'el ri niquic'utuj-apo rije'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Y xucol c'a el ri achin ri xquic'utuj-apo chire chi tucolo-el. Y ri achin ri' xa kajinek c'a pa cárcel roma xyacatej chirij ri k'atbel-tzij y xuben chuka' camic. Jac'a ri Jesús xa xujech-el richin chi ticamisex chuvech cruz, roma can jari' ri xcajo' ri vinek chirij. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Y tok ri soldados quic'uan c'a el ri Jesús richin nequibajij chuva ri cruz, xquic'ul c'a jun achin petenek pa juyu', jun achin aj-Cirene y rubini'an Simón. Y ri soldados chirij c'a rija' xquiya-vi-el ri ru-cruz ri Jesús. Can jac'a rija' xuc'uan-el ri cruz, y chirij ri Jesús benek-vi. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Y can janíla c'a vinek ri e benek chirij. Y janíla c'a chuka' ixoki' ri ye'ok'en ruvech ri Jesús, y niquibisoj janíla. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Y ri Jesús xerutzu' c'a, y xubij chique: Ixoki' aj-Jerusalem, man c'a quinivok'ej yin. Xa tivok'ej-ivi' rix, y tivok'ej chuka' quivech ri ac'uala' ec'o iviq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Roma can ec'o c'a k'ij xque'oka' tok c'ayef ri xtibanatej. Y romari' xtibitej chi jebel ruva-ruk'ij ri ixok ri man nalan ta, ni man jun bey xroyobej ta jun ac'ual, y man xuya' ta chuka' rutz'un. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Roma jari' tok xtibanatej chi ri vinek can xquech'oviyaj chique ri nima'k tak juyu' y xtiquibila': Quixtzak-pe chikij. Chuka' xquech'oviyaj chique ri cocoj tak juyu' y xtiquibila' c'a: Kojivevaj, xquecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Roma vi chuve yin ri achi'el jun che' rex can niban chi c'o chi ninc'ovisaj tijoj-pokonal, ¿achique ta cami ri man xtiban chique ri xa e achi'el chaki'j tak che'? xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Y ec'o c'a chuka' e ca'i' elek'oma' ri e uc'uan-el, richin yecamisex junan riq'uin ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Y tok xe'apon c'a chupan ri jun juyu' rubini'an Calavera, xquibajij c'a ri Jesús chuva ri ru-cruz, y que chuka' ri' ri e ca'i' elek'oma'. Jun xpabex pa rajquik'a', y ri jun chic pa rajxocon (izquierda). ");
INSERT INTO cakCNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Y ri Jesús xubij c'a: Nata' Dios, tacuyu' quimac, roma man quetaman ta achique ri ye'ajin chubanic, xcha' ri Jesús. Y ri soldados xquiya' pan etz'anen ri rutziak ri Jesús, richin xquitz'et achique chi tziek ri niquic'uala-el chiquijujunal. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Y ri Jesús tzuliben c'a apo coma janíla vinek y coma chuka' ri achi'a' ri can yek'aton-vi tzij chiquicojol ri israelitas. Y conojel c'a re vinek re' niquitze'ej-apo, y niquibila': Rija' e q'uiy xerucol. Vacami tucolo' c'a ri' rija', vi can kitzij chi ja rija' ri Cristo ri cha'on roma ri Dios, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Y can que chuka' oc ri' niquiben ri soldados. Yetze'en-apo chirij ri Jesús. Yejel-apo riq'uin y niquisujla' jun ch'amilej ruya'al-uva chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Y niquibila' c'a chire chuka': Vi can ja rat ri qui-Rey ri israelitas, tacolo' c'a avi' ayon, yecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Y pa ruvi' c'a el ri cruz c'o c'a jun tzij tz'iban chuvech jun tz'alen. Ri tzij c'a ri' tz'ibatel-el pan oxi' ch'abel. Tz'iban pa quich'abel ri aj-Grecia, pa quich'abel ri aj-Roma y pa quich'abel ri israelitas. Y ri tzij ri' nubij c'a: Jare' ri qui-Rey ri israelitas. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Y jun c'a chique ri e ca'i' elek'oma' ri ec'o chuka' chuvech qui-cruz, itzel xch'on-apo chire ri Jesús, roma xubij: Rat ri nabij chi ja rat ri Cristo, tacolo' c'a avi' rat, y kojacolo' chuka' roj, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jac'a ri jun chic elek'on xchapon, y xubij-apo chire ri jun: ¿Can man naxibij ta avi' chuvech ri Dios chupan re ruc'ayeval re ojc'o-vi riq'uin? ");
INSERT INTO cakCNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Roj can utz vi rubanic chike, roma yojajin chutojic ri itzel e kabanalon. Jac'a rija' man jun achique ta mac rubanon. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Y ri elek'on ri' xubij c'a apo chire ri Jesús: Quinoka' c'a chi'ac'u'x, tok xcape y ja rat chic ri K'atoy-Tzij, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Y ri Jesús xubij c'a chire: Kitzij c'a ninbij chave, chi can ja re vacami xcabec'oje' viq'uin ri pa lugar richin quicoten, xcha' ri Jesús chire. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Y pa nic'aj-k'ij la'ek ri' tok ri ruvach'ulef xk'ekumer. Y ri k'eku'n ri' xq'uis-el ri las tres ri tikak'ij. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ri k'ij can man xsakirisan ta chic, y jac'ari' tok xel pa ca'i' ri tziek ri achok iq'uin ch'aron-vi rupan ri rachoch ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Can jac'ari' tok ri Jesús riq'uin c'a ruchuk'a' xubij: Nata' Dios, pan ak'a' c'a ninjech-vi ri vánima, xcha'. Y can xe c'a xubij quere', can jari' xquen-ka (xcom-ka). ");
INSERT INTO cakCNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tok ri Capitán quichin ri soldados xutz'et ri xbanatej, xuya' c'a ruk'ij-ruc'ojlen ri Dios, y xubij c'a: Can kitzij na vi chi re jun achin re' man jun na vi rumac, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Y janipe' ri vinek ri ec'o-apo y xquitz'et ri xbanatej, niquibajila' c'a ruva-quic'u'x ri xetzolin roma ri k'axo'n c'o pa cánima. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Y ri e etamayon ruvech ri Jesús, y ri ixoki' ri can c'a pa Galilea e tzeketel-pe chirij, c'a nej c'a ec'o-vi-el niquitzu-apo ri xbanatej. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Y c'o c'a jun achin rubini'an José, y aj pa tinamit Arimatea ri pa Judea nicanej-vi can. Re jun utzilej y chojmilej achin c'a re' cachibil ri achi'a' ri yek'aton tzij chiquicojol ri israelitas. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Y ri José chuka' royoben tok ri Dios xtoc ri K'atoy-Tzij, y romari' tok rija' man xka' ta chuvech ri xquibij ri rachibil chi niban chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Y rija' xbe c'a riq'uin ri k'atoy-tzij rubini'an Pilato chuc'utuxic ri ruch'acul ri Jesús, richin numuk. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Y tok rukasan chic c'a pe ri ruch'acul ri Jesús chuva ri cruz, rija' xupis pa jun tziek. Y c'ari' xberumuku' can pa jun jul richin caminek, c'oton chuvech jun juyu' ri xa can abej vi. Y man jun c'a ucusayon ri jul ri'. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pero ri k'ij ri', ri vinek niquichojmirisala' chic c'a qui', roma ri k'ij ri richin uxlanen nitiquir yan. Y can jac'a tok nika' ri k'ij, jari' tok nitiquir. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Y ri ixoki' ri can c'a pa Galilea e tzeketel-pe chirij ri Jesús, xebe c'a tok xbemuk can; y romari' tok can jebel quetaman ri lugar ri xmuk-vi can, y chuka' xquitzu' can jebel achique rubanic xban can chire ri ruch'acul. ");
INSERT INTO cakCNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Y tok xetzolej ri pa tak cachoch ri ixoki' ri', xequibanala' cutzil jubulej tak ak'on richin jari' nequiya' can chirij ri Jesús. Y xe'uxlan c'a chupan ri jun k'ij richin uxlanen ri', can achi'el nubij chupan ri ley richin ri Moisés. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Y nimak'a' yan domingo ri nabey k'ij richin ri semana, ri ixoki' xebe c'a ri chuchi-jul, y e quic'ualon-el ri jubulej tak ak'on ri e quibanon-el. Y ec'o c'a chuka' ch'aka' chic ixoki' ri e benek quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Y tok xe'apon c'a ri chuchi-jul, xquitz'et c'a chi ri abej tz'apebel ruchi' ri jul, elesan chic el. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Rije' xe'oc c'a apo chupan ri jul, y xquitz'et c'a chi ri ruch'acul ri Ajaf Jesús xa man c'o ta. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Romari' janíla c'a xquixibij-qui', y xsach quic'u'x. Y can jac'ari' tok xequitz'et e ca'i' achi'el achi'a' e pa'el-apo quiq'uin, y niyic'lun ri quitziak. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Y ri ixoki', roma ri quixibinri'il xquilucuba-ka-qui'. Y jari' c'a tok ri achi'el achi'a' xquibij c'a chique: ¿Achique c'a roma rix chiquicojol caminaki' nicanoj-vi ri xa q'ues? ");
INSERT INTO cakCNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ri ruch'acul man chic c'o ta vave'. Rija' xc'astej yan el. Toka' c'a chi'ic'u'x ri xubij chive tok rija' c'a c'o na c'a ri chiri' pa Galilea. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Rija' xubij c'a chive: Yin ri xinalex chi'icojol, can c'o c'a chi xquijach pa quik'a' ri aj-maqui'. Xquicamisex chuvech-cruz. Y pa rox k'ij xquic'astej-pe, xecha' ri e ca'i' achi'el achi'a'. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Y ri ixoki' can xoka' na vi c'a chiquic'u'x ri ch'abel ri rubilon can ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Y tok e tzolijinek chic c'a pe ri chiri' pa jul, xquitzijoj chique ri julajuj apóstoles y ri quimolon-qui' quiq'uin, ronojel ri xquitz'et can. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ri ixoki' ri xebeyo'on rutzijol chique ri apóstoles ja ri María Magdalena, ri Juana, ri María ri rute' ri Jacobo, y ch'aka' chic ixoki'. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero ri apóstoles xa xquich'ob chi ri ixoki' ri' xa achique la ri yequitz'etela', y romari' man xquinimaj ta ri xbix chique coma ri ixoki'. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Y ri Pedro can jari' xel-el, y junanin xbe c'a chuchi-jul. Y tok xtzu'un c'a apo chupan ri jul, xutzu' chi ri tziek ec'o can chiri'. Rija' xtzolin c'a el, pero janíla c'a nuch'ob rij ri xbanatej. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Y chupan chuka' ri k'ij ri', ec'o c'a e ca'i' chique ri xe'ojkan richin ri Jesús quichapon-el bey richin yebe pan Emaús, ri jun ti tinamit nicanej can pa jun la'ek oxi' leguas chire ri tinamit Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Y yetzijon c'a ri e benek. Niquitzijola' ri xebanatej ri cabijir-oxijir can. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Y tok benek c'a cánima riq'uin ri quitzij ri e benek, y riq'uin ri niquic'utula' c'a chiquivech ka rije', ri Jesús c'astajinek chic el, xuben c'a chi xeberuk'i', y junan xebe. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ri ca'i' c'a achi'a' ri' can niquitzu-vi c'a ri benek quiq'uin, pero c'o c'a banayon chique richin queri' man niquetamaj ta ruvech. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Y ri Jesús xuc'utuj c'a chique: ¿Achique c'a chi tzij ri ichapon-pe re ix petenek? ¿Y achique roma tok yixbison chuka' yixintz'et yin? xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Y jun c'a chique rije', ri rubini'an Cleofas, xch'on-apo chire y xubij: Man jun la'ek vinek ri c'o chiri' pa tinamit Jerusalem ri man ta etamayon ri xc'ulvachitej chupan ri ca'i-oxi' k'ij can. Y rat chiri' at petenek-vi y man avetaman ta achique ri e c'ulvachitajinek chiri', xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Y ri Jesús xuc'utuj c'a chique: ¿Achique ri xc'ulvachitej? Y rije' xquibij: Ri xuc'ulvachij ri Jesús aj-Nazaret, jun achin ri can k'alajirisey richin ri xbix chire roma ri Dios. Y chuka' can xuc'ut chi c'o ruchuk'a', riq'uin ri nima'k tak milagros ri xerubanala' y chuka' riq'uin ri ruch'abel. Queri' c'a xk'alajin chiquivech ri vinek y chuka' chuvech ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero ri principal-i' tak sacerdotes y ri e cachibil, ri pa comon yek'aton tzij chikacojol, jari' ri xebanon chi xcamisex chuvech cruz. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Y roj can xkacukuba' c'a kac'u'x riq'uin chi can ja vi rija' ri petenek chikacolic konojel roj israelitas. Pero vacami man jun chic c'a achique xtikaben, roma ja yan re' ri rox k'ij tiquen-el (ticom-el). ");
INSERT INTO cakCNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero ec'o kachibil ixoki' ri nimak'a' yan xebe chuchi' ri jul, y xojoquixibij. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Roma niquibij chi ri ruch'acul ri Jesús xa man c'o ta ri chiri' pa jul. Y niquibij c'a chuka' chi c'o ángeles xquic'ut-qui' chiquivech, y chi re ángeles re' xquibij chique chi ri Jesús xc'astej yan el. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Y romari' ec'o c'a chike roj achi'a' ri xebe chuchi-jul richin xbequitz'eta'. Y can achi'el ri xbequibij ri ixoki' chike, can queri' ri xbequitz'eta' can ri achi'a', pero ri Jesús man xquitz'et ta can. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Y ri Jesús ri nitzijon benek quiq'uin, xubij c'a chique: Nacanek. Rix xa man oquinek ta c'a pan ivánima ri quibin can ri xek'alajirisan ri ruch'abel ri Dios ojer can. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Man quibin ta cami can rije' chi ri Cristo can c'o-vi chi nuc'ovisaj tijoj-pokonal, y c'ari' nibe chila' chicaj richin nec'oje' ruk'ij-ruc'ojlen? xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Y ri Jesús xuchop c'a rusolic rij chiquivech ri e ca'i' achi'a' ri', ronojel ri e tz'ibatel can chirij rija', chupan ri ruch'abel ri Dios. Xuchop c'a el riq'uin ri e rutz'iban can ri Moisés, c'a riq'uin ri quitz'iban can ri ch'aka' chic achi'a' ri xek'alajirisan ri ruch'abel ri Dios ojer can. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Y tok xe'apon c'a ri pa ti tinamit Emaús, ri Jesús xuben chi can choj nik'ax-el. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Y richin c'a chi nicanej-ka quiq'uin, ri ca'i' achi'a' ri' xquibij chire: Cacanej-ka kiq'uin, roma ri k'ij xa xka' yan ka, y xa can nimoymot chic, xecha'. Y ri Jesús xoc c'a apo, richin nic'oje-ka quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Y tok e tz'uyul chic c'a apo ri pa mesa, ri Jesús xuq'uen-apo ri vey, y tok rumatioxin chic chire ri Dios, xuper (xupir) ri vey y xuya' c'a chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Y can c'ari' achi'el xjakatej ri runak'-quivech, y c'ari' xquetamaj ruvech chi can ja ajc'a ri Jesús ri c'o quiq'uin. Ri Jesús xbe chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Y ri ca'i' achi'a' ri' niquibila' c'a chiquivech: Can kitzij vi chi can nuna-vi chic ri kánima tok yojtzijon ri oj petenek, tok rija' xusol rij ri ruch'abel ri Dios chikavech, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ri ca'i' achi'a' ri' can jari' xeyacatej-el ri pa mesa, y xquichop bey richin yetzolin pa Jerusalem. Y xebequila' c'a ri julajuj tijoxela' y ri ch'aka' chic ri can e tzekelbey vi richin ri Jesús, quimolon-qui'. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Y ri tijoxela' y ri ch'aka' chic niquibij c'a: Ri Ajaf Jesús can xc'astej yan na vi el, y xuc'ut yan ri' chuvech ri Simón. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Y jac'ari' tok ri ca'i' achi'a' xquitzijoj-apo ri xquic'ulvachij tok quichapon-el bey pan Emaús, y xquetamaj ruvech chi ja ri Jesús tok xuper (xupir) ri vey. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Y conojel ri quimolon-qui', c'a yetzijon na c'a chirij ri Jesús, tok xquitz'et c'o chic chiri' chiquicojol, y xubij c'a chique: Ja ta c'a ri uxlanen ri xtic'oje' pa tak ivánima chi'ivonojel, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero rije' xquich'ob chi ri niquitz'et jac'a ri ánima richin ri Jesús, romari' janíla xquixibij-qui'. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero ri Jesús xubij chique: ¿Achique roma tok xsach ic'u'x tok xinitz'et y xpe man utzilej tak ch'obonic ta iviq'uin? ");
INSERT INTO cakCNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Que'itzu' re nuk'a-vaken. Quinichapa' na pe', y xtitz'et chi can ja vi yin. Roma xa ta in jun ánima achi'el ri nich'ob rix, man ta c'o nuch'acul. Y rix nitz'et chi yin c'o ronojel, xcha' ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Y tok ri Jesús rubin chic queri' chique, xeruc'ut c'a ri ruk'a-raken chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero rije' man niquinimaj ta. Xa xsach quic'u'x roma ri niquitzu' y roma ri quicoten. Y richin chi niquinimaj, xpe ri Jesús xuc'utuj c'a chique: ¿Man jun cami richin nitij c'o iviq'uin richin nisipaj ta juba' chuve? xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Y rije' xbequiya-pe chire juba' sa'on quer y juba' cab c'a c'o pa cera. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Y rija' xuc'ul y xuchop rutijic, richin tiquitz'eta' chi can ja vi rija' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Y xubij c'a chique: Tok can c'a inc'o c'a iviq'uin, xinbij c'a chive ri xtinc'ulvachij, y chi can nic'atzin na vi chi nibanatej ronojel ri e tz'ibatel can chuvij yin chupan ri ruch'abel ri Dios, achi'el ri e tz'ibatel can roma ri Moisés, ri e tz'ibatel can coma ri ch'aka' chic achi'a' ri xek'alajirisan ruch'abel ri Dios ri ojer can, y ri e tz'ibatel can chupan ri vuj rubini'an Salmos. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","C'ari' rija' xuben chique richin tik'ax chiquivech ri ruch'abel ri Dios ri tz'ibatel can. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Y xubij c'a chique: Can tz'ibatel-vi c'a can ri', chi yin ri Cristo c'o chi ninc'ovisaj tijoj-pokonal, y chi can yiquen na vi (yicom na vi), y pa rox k'ij yic'astej-pe, ");
INSERT INTO cakCNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","y chi ec'o ri xquebe pa nubi' yin richin xtequitzijoj ri ruch'abel ri Dios chique ri vinek chuvech re ruvach'ulef, chi titzolin-pe quic'u'x riq'uin ri Dios richin nicuyutej quimac. Y nitiquiribex-el re pa Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Y rix ri can xitz'et, tik'alajirisaj c'a ri xitz'et. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Y can tivac'axaj c'a jebel re ninbij can chive, xcha' ri Jesús. Can xtintek c'a pe chive ri rusujun ri Nata' Dios chi nuya-pe chive. Ri rusujun c'a rija' chive rix, ja ri Lok'olej Espíritu. Y jari' ri xtoyo'on-ka ivuchuk'a'. Y can quixc'oje' c'a re vave' pa tinamit Jerusalem c'a ri k'ij tok xtika-pe ri Lok'olej Espíritu, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Y ri Jesús xeruc'uaj-el ri rutijoxela' c'a pa tinamit Betania. Y ri chiri', rija' xerutzekej ri ruk'a' chicaj, y xuc'utuj rutzil ri Dios pa quivi' rije'. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Y ri Jesús jari' c'a ri najin chubanic tok ja yan ri' xuch'er-el-ri'. Jac'ari' tok xyacatej-el pa cak'ik' y xuc'uex c'a el chicaj riq'uin ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Y ri tijoxela' can xquiya' c'a ruk'ij ri Jesús ri chiri'. C'ari' xetzolin pa tinamit Jerusalem. Rije' can janíla c'a quicoten c'o pa cánima. ");
INSERT INTO cakCNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Y can k'ij-k'ij c'a ec'o ri pa rachoch ri Dios richin niquiya' ruk'ij ri Dios y niquinimirisaj rubi'. Can que c'a ri'.");
INSERT INTO cakCNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ri Cristo jari' ri Ch'abel. Tok xtiquir c'a pe ronojel, can c'o-vi rija'. Rija' can c'o c'a riq'uin ri Dios, y rija' chuka' can Dios vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Rija' can c'o-vi-pe riq'uin ri Dios tok xban re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Y roma rija' tok c'o ronojel. Roma ri Dios pa ruk'a' ri Cristo xuya-vi richin xuben ronojel cosas. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Riq'uin c'a rija' c'o-vi ri c'aslen. Y re c'aslen re', jac'are' ri nisakirisan quichin ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Y re jun Sakil re', can nisakirisan-vi ri pa k'ekumatajinek quic'aslen ri vinek. Y can man jun bey c'a chupnek ta pa ruk'a' ri k'ekumatajinek c'aslen ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Y xc'oje' c'a jun achin ri cha'on-pe roma ri Dios, jun achin ri xubini'aj Juan. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Re Juan c'a re' xpe richin xoruk'alajirisaj ri Sakil, richin queri' can conojel c'a vinek tiquinimaj. Can tiquinimaj c'a ri nuya' rutzijol rija' chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Y man ja ta c'a rija' ri Sakil. Rija' xaxe c'a richin xoruk'alajirisaj ri Sakil ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Y can jac'ari' tok xoka' ri Sakil ri' chuvech re ruvach'ulef. Jari' ri kitzij Sakil, ri nisakirisan quichin ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Can xoka-vi c'a chuvech re ruvach'ulef ri banon roma rija', pero ri ec'o chuvech re ruvach'ulef re' xa man xquetamaj ta ruvech tok xoka'. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Can chupan vi c'a ri ruvach'ulef richin rija' xoka-vi, pero ri vinek ri can e richin rija' xa man xquic'ul ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Jac'a ri xec'ulun richin tok xoka' chuvech re ruvach'ulef, ri can xeniman-vi richin, can xuben c'a chique chi xe'oc ralc'ual ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ri vinek c'a ri xe'oc ralc'ual ri Dios, can xe'alex-vi chic, pero man junan ta chic chi alaxic ri xquic'uaj, achi'el tok xe'alex riq'uin ri quite', tok xa ja ri te'ej-tata'aj xe'ajovan chi xalex ri ac'ual. Roma ri c'ac'a' alaxic rurayibel ri Dios, y man rurayibel ta achin. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Y ri Cristo ri Ch'abel xoka' c'a chuvech re ruvach'ulef y can xoc c'a chuka' achi'el roj vinek. Y can xkatz'et c'a chi xaxe vi rija' ri Ruc'ajol ri Dios, roma can c'o ruk'ij-ruc'ojlen. Y can nojinek c'a riq'uin ri kitzij y janíla chuka' ri rutzil. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Y ri Juan ri xbix chuka' Bautista chire, can c'o c'a ri xuk'alajirisaj chirij ri Cristo. Can riq'uin vi ruchuk'a' tok xubij: Jare' ri nutzijon chive, tok xinbij chive chi ri xtoka' chuvij yin, jari' ri nimalaxel chinuvech. Y can c'o-vi-pe pa nabey; tok yin c'a man jani yinoc'ulun ta chuvech re ruvach'ulef, xcha' c'a ri Juan ri Bautista. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Can konojel c'a roj kac'ulun ri rutzil ri Cristo. Can man xe ta c'a jun bey ri ruyo'on-pe pa kavi', xa can quitzekelbelon-pe-qui' ri utzil ri yeruya-pe pa kavi'. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ri Dios jac'a ri Moisés ri xrucusaj richin xuya-pe ri ley. Jac'a richin chi xoka' ri utzil y ri kitzij, ja ri Jesucristo ri xrucusaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Can man jun c'a vinek ri tz'eteyon ta richin ri Dios, xa can xe ri Ruc'ajol ri tz'eteyon richin. Ri Dios xa can xe c'a ri jun Ruc'ajol c'o y janíla nrajo'. Y jari' ri xok'alajirisan-ka ri Dios chikavech re vave' chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Y ri achi'a' ri can c'o quik'ij chiquicojol ri israelitas ri chiri' pa tinamit Jerusalem, ec'o c'a achi'a' ri xequitek-el c'a riq'uin ri Juan ri Bautista. Xequitek c'a achi'a' e sacerdotes y achi'a' ri e levitas nibix chique, richin chi xbequic'utuj chire ri Juan chi tubij vi ja rija' ri Cristo. Y rija' can xuk'alajirisaj-vi chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ri Juan can ja vi c'a ri kitzij ri xuk'alajirisaj, roma xubij c'a chique: Man ja ta yin ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Y c'ari' ri achi'a' ri e takon-el, xquic'utuj chic c'a chire: ¿At achique c'a rat c'a? ¿O xa ja rat ri achin ri xk'alajirisan ri ruch'abel ri Dios ojer can y xubini'aj Elías? xecha' chire. Pero ri Juan xubij c'a chique: Man ja ta yin, xcha' chique. C'ari' ri achi'a' ri' xquic'utuj chic c'a jun bey chire ri Juan: ¿Ja rat ri k'alajirisey ri ruch'abel ri Dios ri c'o chi nipe? xecha' chire. Pero ri Juan xubij chi man ja ta rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Y c'ari' ri achi'a' ri' can xquic'utuj c'a chire: ¿At achique c'a rat c'a? Roma roj can nic'atzin c'a chike chi niketamaj-el at achique rat, y jari' ri nekabij chique ri e takayon-pe kichin. Tak'alajirisaj c'a avi' chikavech, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Y rija' xubij c'a chique ri achi'a' ri': Jac'a yin ri jun ri achok chij c'o rutz'iban ri k'alajirisey ruch'abel ri Dios ri xc'oje' ojer can y xubini'aj Isaías. Y jare' ri xutz'ibaj can rija': C'o c'a jun achin ri xtic'oje' pa tz'iran ruvach'ulef, y ja rija' ri xtitzijon ri ruch'abel ri Dios chiquivech ri vinek ri xque'apon riq'uin. Y xtubila' c'a chique: Tichojmirisala' rubey ri ic'aslen, roma nakaj chic c'o-vi ri rupetebel ri Ajaf, xcha' ri Juan chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ri achi'a' c'a ri xe'apon riq'uin ri Juan, je ri achi'a' ri e takon-el coma ri fariseos. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Y ri achi'a' ri' xquic'utuj chic c'a chire ri Juan: ¿Achique c'a roma rat ye'aben bautizar ri vinek? Tok xa man ja ta rat ri Cristo, ni man ja ta chuka' rat ri Elías, ni man ja ta rat ri k'alajirisey ri ruch'abel ri Dios ri c'o chi nipe, xecha' ri achi'a' ri' chire ri Juan. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Y ri Juan xubij c'a chique: Yin riq'uin ya' yenben bautizar ri vinek, pero chi'icojol rix c'o c'a Jun ri man ivetaman ta ruvech, ");
INSERT INTO cakCNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","y rija' can c'a chuvij c'a yin xtoka-vi, pero can ja rija' ri c'o-pe nabey que chinuvech yin. Y yin can man ruc'amon ta c'a ni richin ninsol ri ruximbal ri ruxajab. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Y ronojel c'a re', ja ri chiri' pa Betábara xbanatej-vi, ri lugar ri c'o-apo juc'an ruchi' ri raken-ya' Jordán, ri nuben-vi bautizar ri Juan. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pa ruca'n k'ij tok ri Juan ri Bautista xutz'et chi choj petenek ri Jesús c'a riq'uin, xubij: Jare' xoka' ri achi'el Alaj Carne'l ri takon-pe roma ri Dios, richin chi nrelesaj ri quimac ri vinek ri ec'o chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Y jare' ri nutzijon chive, tok xinbij chi ri chuvij yin xtoka' c'a jun achin ri xa can nimalaxel vi chinuvech yin, y can c'o-vi-pe pa nabey, tok yin c'a man jani yinoc'ulun ta chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Y yin man vetaman ta achique achin rija'. Pero richin chi nik'alajirisex chire re tinamit Israel, romari' tok xipe chubanic bautizar riq'uin ya'. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Y ri Juan can xuk'alajirisaj c'a chuka' y xubij: Yin can xintz'et c'a ri Lok'olej Espíritu tok xka-pe chila' chicaj achi'el jun paloma y xoc'oje-ka pa ruvi' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Y yin ri chiri' can c'a man jani c'a vetaman ta achique c'a ri Jun ri'. Pero ri Dios ri yoyon-pe re jun samaj re' chuve, can ruk'alajirisan-vi chic c'a chinuvech chi tok xtintz'et chi nika-pe ri Lok'olej Espíritu y noc'oje-ka pa ruvi' jun achin, jac'ari' ri nibanon bautizar riq'uin ri Lok'olej Espíritu y man riq'uin ta ya'. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Vacami can xintz'et yan c'a. Y romari' nink'alajirisaj chi ja rija' ri Ruc'ajol ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Y pa ruca'n k'ij, ri Juan e rachibilan e ca'i' chique ri rutijoxela', c'o chic c'a chiri' jun bey. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Y jac'ari' tok rija' xutz'et chi ri Jesús nik'ax-el ri queri'. Rija' xubij c'a: Titzu', ja Jesucristo la', ri achi'el Alaj Carne'l ri takon-pe roma ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Y ri e ca'i' rutijoxela' ri Juan tok xcac'axaj c'a ri xubij, rije' xquitzekelbej-el ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Y tok ri Jesús xtzu'un can chirij y xerutz'et ri e ca'i' rutijoxela' ri Juan chi e tzeketel-el chirij, rija' xuc'utuj c'a chique: ¿Achique nicanoj? xcha' chique. Y rije' xquibij c'a chire ri Jesús: Roj nikajo' niketamaj acuchi c'o-vi ri avachoch rat Rabí. Rije' Rabí xecha' c'a chire roma ri israelitas queri' niquibij chire jun tijonel. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Y ri Jesús xubij c'a chique: Jo', y te'ivetamaj can. Y rije' can xebe na vi y xbequetamaj can ri rachoch. Y xec'oje' c'a ka riq'uin ri jun k'ij ri', roma xa can las cuatro chic ri tikak'ij. Xa can xkak'ij yan c'a. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ri jun c'a chique ri e ca'i' tijoxela' ri xe'ac'axan-el achique ri xubij ri Juan y xquitzekelbej-el ri Jesús, jac'a ri Andrés ri rach'alal ri Simón Pedro. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Re Andrés nabey c'a xberucanoj ri Simón ri rach'alal y xberubij c'a chire: Ketaman chic c'a achique ri Mesías. Y que c'a ri' niquibij ri israelitas chire ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","C'ari' ri Andrés xuc'uaj ri Simón ri rach'alal, c'a riq'uin ri Jesús. Y tok ri Jesús xutz'et, xubij c'a chire: Ja rat ri Simón ri ruc'ajol ri Jonás. Vacami xtabini'aj c'a chuka' Cefas. Y que c'a ri' niquibij ri israelitas chire jun vinek rubini'an Pedro. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jac'a ri pa ruca'n k'ij, ri Jesús can ruch'obon-vi chi nibe c'a pa Galilea. Y chupan c'a ri k'ij ri' ri Jesús xberuc'ulu-pe ri jun achin rubini'an Felipe y xubij c'a chire: Quinatzekelbej. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Y re jun achin re', re rubini'an Felipe, aj pa tinamit Betsaida, ri tinamit ri c'o-vi cachoch ri Andrés y ri Pedro. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ri achin c'a ri rubini'an Felipe, xberuc'ulu-pe ri jun achin rubini'an Natanael, y xubij c'a chire: C'o chic ri Jun ri runatan can ri Moisés chupan ri ley y ri quinatan chuka' can ri achi'a' ri xek'alajirisan ri ruch'abel ri Dios ojer can, ri chupan ri quivuj e quitz'ibalon can. C'ari' niketamaj can ruvech. Rija', ja ri Jesús ri ruc'ajol ri José aj-Nazaret. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Y ri Natanael xubij: ¿Xtic'ulun ta c'a pe jun utzilej achin ri chiri' pa tinamit Nazaret? xcha' rija'. Pero ri Felipe xubij chire: Vi man nanimaj ta, jo' chutz'etic. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Y tok ri Jesús xutz'et ri Natanael chi xa napon yan apo riq'uin, xubij c'a: Titzu' la jun achin la'. Rija' can richin vi ri rutinamit ri Dios; rija' jun kitzij israelita; roma queri' nuc'ut ri ruc'aslen. Can man jun k'oloj riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","C'ari' ri Natanael xuc'utuj c'a chire ri Jesús: ¿Acuchi xavetamaj-vi nuvech? Y ri Jesús xubij c'a chire: Yin xatintz'et tok c'a atc'o na chiri' chuxe' ri víquix (higo), tok c'a man jani tac'ul ri Felipe, xcha' ri Jesús chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ri Natanael can jac'ari' xubij: Tijonel, xcha' chire. Can ja vi rat ri Ruc'ajol ri Dios. Y can ja rat ri Rey richin re tinamit Israel, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Y ri Jesús xubij chire ri Natanael: Rat can xanimaj chi ja yin ri Ruc'ajol ri Dios xaxe riq'uin xinbij chave chi chuxe' ri víquix (higo) atc'o-vi tok c'a man jani tac'ul ri Felipe. Can c'a q'uiy na rubaniquil xtatz'et richin queri' nanimaj más. ");
INSERT INTO cakCNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Y ri Jesús xubij c'a chuka': Can tinimaj c'a re xtinbij chive: Rix can xtitz'et c'a chi ri caj xtijakatej, y chi ri ángeles richin ri Dios xquexule-xquejote' chinuto'ic yin ri xinalex chi'icojol. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Y pa rox k'ij, ri chiri' pa tinamit rubini'an Caná ri chiri' pa Galilea, c'o c'a jun c'ulubic xbanatej. Y ri María ri rute' ri Jesús, can c'o c'a chuka' chiri' chupan ri c'ulubic ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Y ri Jesús e rachibilan ri rutijoxela', xe'oyox c'a chuka' chupan ri c'ulubic ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jac'a ri ruya'al-uva xa xq'uis yan chanin chupan ri c'ulubic ri'. Y ri María ri rute' ri Jesús, xapon c'a apo riq'uin ri Jesús y xberubij chire: Man jun chic tz'uj ruya'al-uva quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pero ri Jesús xubij c'a chire: ¿Achique c'a ri navajo'? Roma ri nu-hora xa c'a man jani tapon, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Y ri rute' ri Jesús xubij c'a chique ri ajic'a': Vi c'o ri xtubij ri Jesús chive, can tibana' c'a, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Y ri chiri' ec'o c'a vaki' nima'k tak cucu' (k'e'l), e banon riq'uin abej. Ri israelitas yalan yecucusaj cucu' (k'e'l) que tak ri', roma chupan cucu' (k'e'l) que tak ri' niquiya-vi ya' ri nic'atzin chique richin ri ch'ajch'ojirisanic, can achi'el c'a ri nichilabex chique roma ri qui-ley. Y ri cucu' ri' (ri k'e'l ri'), cajquej ciento vasos ya' quipan. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Y ri Jesús xubij chique ri ajic'a': Que'inojisaj chi ya' re cucu' re' (re k'e'l re'), xcha' chique: Y ri ajic'a' can que vi ri' xquiben. Can xequipulisaj c'a can ri nima'k tak cucu' ri' (k'e'l ri'). ");
INSERT INTO cakCNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","C'ari' ri Jesús xubij c'a chique ri ajic'a': Vacami tipaja-el juba' y tic'uaj chire ri pa'el chuvech re nimak'ij re', richin tuna'. Y ri ajic'a' can xquiben-vi ri xubij ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Y ri pa'el chuvech ri nimak'ij ri', tok runa'on chic ka chi yalan jebel ri ruya'al-uva ri', xroyoj c'a ri achijlonel chupan ri c'ulubic ri'. Ri pa'el c'a chuvech ri nimak'ij ri', man c'a retaman ta acuchi petenek-vi ri ruya'al-uva ri'. Xa can xe c'a ri ajic'a' ri xepajon ri e etamayon. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Y tok ri achijlonel xapon c'a, ri pa'el chuvech ri nimak'ij richin ri c'ulubic ri' xubij c'a chire: Tok c'o jun nimak'ij quere', conojel c'a vinek ja ri ruya'al-uva ri utz niquiya' nabey, y tok xa yojtajinek chic ri pa quichi' ri ec'o pa nimak'ij, roma q'uiy chic ri quikumun, niquiya' c'a jun ruya'al-uva ri man can ta utz. Pero rat xa man que ta ri' xaben. Rat xa c'a ri' xabevelesaj-pe ri ruya'al-uva ri utz, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Re xuben c'a ri Jesús chi xuben ruya'al-uva chire ri ya' ri pa c'ulubic pa Caná ri chiri' pa Galilea, jac'ari' ri nabey milagro ri xuben. Y re jun milagro re', can xuc'ut c'a chi rija' can c'o-vi ruk'ij-ruc'ojlen. Y ri e rutijoxela' can xquicukuba' c'a quic'u'x riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tok can c'achojinek chic c'a can ri c'ulubic, ri Jesús rachibilan ri rute', ri e rach'alal y ri rutijoxela' xebe pa tinamit Capernaum. Y xec'oje' c'a ca'i-oxi' k'ij chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Y can nakaj chic c'a ri k'ij richin ri quinimak'ij ri israelitas, ri rubini'an pascua, k'ij tok yecamisex ri tak carne'l. Romari' ri Jesús can xbe c'a pa tinamit Jerusalem, richin ri nimak'ij ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Y ri chiri' chuva-rachoch ri Dios ri c'o pa Jerusalem, ri Jesús xeberila' c'a c'ayil tak váquix, c'ayil tak carne'l, y c'ayil tak palomas. Y xeberila' chuka' jaloy-ruvech mero e tz'uyul ri chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ri Jesús, can xe c'a xerutz'et, xuben c'a jun ruch'aybal riq'uin colo' y xerokotaj-pe conojel. Xerokotaj c'a pe cachibilan ri quicarne'l y ri quiváquix ri chiri' chuva-rachoch ri Dios. Y chique ri jaloy-ruvech mero, xuc'akala' c'a can ri qui-mero chiquivech y xerutec'mayila' can ri qui-mesas. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Y chique ri c'ayil tak palomas xubij c'a: Que'ivelesaj-el re' vave'. Y man tiben chire ri rachoch ri Nata' Dios, jun c'ayibel, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Romari' ri rutijoxela', can chanin c'a xoka' chiquic'u'x ri jun tzij tz'ibatel chupan ri ruch'abel ri Dios. Ri tzij c'a ri' nubij: Nupaxij vánima ri itzel ye'ajin chubanic ri vinek chupan ri avachoch, nicha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Y jari' tok ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, xquibij chire ri Jesús: ¿Achique c'a ri yatiquir nac'ut chikavech richin chi can niketamaj chi c'o uchuk'a' pan ak'a' richin xe'avokotaj-el ri vinek vave'? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Y ri Jesús xubij c'a chique: Tikasaj c'a pan ulef re jun jay re', ri can richin ri Dios, y yin pan oxi' k'ij xtinyec chic jun bey, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Y jac'ari' tok ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, xquibij chire ri Jesús: Re jun jay re', cavinek-vaki' juna' xquiben ri kate-katata' chirij richin xquipaba'. ¿Yatiquir cami c'a rat napaba' pan oxi' k'ij? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ri jay ri xubij ri Jesús chique ri vinek ri', ja ri mismo ruch'acul. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Y romari', tok ri Jesús xcamisex chuva ri cruz y pa rox k'ij xbec'astej-pe, ri rutijoxela' xoka' c'a chiquic'u'x re jun tzij re xubij chique ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas. Y xcuker c'a quic'u'x riq'uin ri ruch'abel ri Dios ri tz'ibatel can y riq'uin ri ch'abel ri e rubin can ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Y chupan c'a ri k'ij tok c'o-ka ri Jesús ri pa Jerusalem roma ri nimak'ij pascua, can e q'uiy vi c'a vinek ri xeniman. Re vinek re' xquinimaj tok xequitz'et ri milagros ri xeruben chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero ri Jesús man c'a xucukuba' ta ruc'u'x quiq'uin ri vinek ri', roma rija' can retaman-vi ri c'o pa tak cánima conojel vinek. ");
INSERT INTO cakCNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Y man nic'atzin ta c'a chire chi c'o ta jun ri nibin chire achique rubanic ri quic'aslen chiquijujunal ri vinek; roma rija' can retaman-vi achique c'a ri c'o pa tak cánima. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Y c'o c'a jun achin chiquicojol ri fariseos ri rubini'an Nicodemo, y re achin re' can c'o-vi c'a ruk'ij chiquivech ri ruvinak israelitas. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Y pa jun ak'a', rija' xapon riq'uin ri Jesús y xubij chire: Can nik'alajin-vi c'a chi at jun Tijonel ri takon-pe roma ri Dios; roma ri milagros ri ye'abanala', xaxe c'a ri c'o Dios riq'uin ri nitiquir nibanon. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Y ri Jesús xubij c'a chire ri Nicodemo: Yin can kitzij c'a re ninbij chave: Ri achique c'a ri man xtuc'uaj ta jun chic c'ac'a' alaxic, man c'a xtic'oje' ta pa rajavaren o pa ruk'a' ri Dios, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pero ri Nicodemo xubij chire ri Jesús: ¿Can nitiquir cami nalex chic jun bey jun achin achi'el yin, ri xa xirijix yan? ¿Y can nitiquir cami chi ri nte' yiralaj chic jun bey? xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ri Jesús xubij c'a: Yin can kitzij vi c'a re ninbij chave: Ri c'ac'a' alaxic ri xinnataj, jari' ri niban roma ri Lok'olej Espíritu y ya'. Y ri man c'a xtiquic'uaj ta ri jun c'ac'a' alaxic ri', man xque'oc ta pa rajavaren o pa ruk'a' ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ri vinek c'a ri ruc'uan xaxe ri alaxic richin re ruvach'ulef, can aj-ruvach'ulef vi. Jac'a ri vinek ri ruc'uan chuka' ri alaxic richin ri Lok'olej Espíritu, can richin vi ri Lok'olej Espíritu. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Y man c'a tisach ac'u'x riq'uin re ninbij chave, roma can queri' vi: Can conojel c'a nic'atzin chi niquic'uaj jun chic c'ac'a' alaxic. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ri ye'uc'uan ri alaxic richin ri Lok'olej Espíritu, nijalatej ri quic'aslen. Y ri Lok'olej Espíritu ri nijalon ri quic'aslen, man c'a tz'etel ta. Xa can achi'el c'a ri cak'ik' ri xabacuchi nic'ulun-vi-pe. Roma xaxe navac'axaj, pero man c'a avetaman ta acuchi petenek-vi y man avetaman ta chuka' acuchi nibe-vi, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Y ri Nicodemo xuc'utuj c'a chire ri Jesús: ¿Achique c'a rubanic ri'? ");
INSERT INTO cakCNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ri Jesús xubij c'a chire: ¿Man avetaman ta c'a achique rubanic re', y can at jun tijonel chiquicojol ri kavinak israelitas? ");
INSERT INTO cakCNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yin ja ri vetaman y nutz'eton ri nintzijoj, jac'a rix vinek man nivajo' ta ninimaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Rix man ninimaj ta re ninbij chive, y xa chirij cosas aj-ruvach'ulef. C'a ta la' chic c'a chi nintzijoj ta chive ri cosas ri e richin chila' chicaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ri chila' chicaj man jun chic c'a ri apovinek ta, xa can xe c'a ri Jun kajinek-pe chila'. Can xe rija' ri apovinek. Xa can xe ri Jun ri xalex chi'icojol y chila' chicaj riq'uin ri Dios c'o-vi rachoch. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Y ojer-ojer can ri', tok ri Moisés xc'oje' ri pa tz'iran ruvach'ulef, rija' xutic c'a jun che' nim raken y xuya' jun ruvachibel cumetz pa ruvi'. Y achi'el c'a xban chire ri ruvachibel ri cumetz chutza'n re che' re', can que chuka' ri' nic'atzin chi niban chire ri Jun ri alaxinek chi'icojol. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Richin queri' achique c'a vinek ri xtiniman richin, man c'a xtapon ta chupan ri camic ri richin jantape', xa can xtic'oje' ruc'aslen ri man q'uisel ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ri Dios can janíla vi c'a najovan. Xerajo' ri vinek ri ec'o chuvech ronojel ruvach'ulef, y romari' can xutek c'a pe ri Ruc'ajol vave' chuvech re ruvach'ulef. Rija' xaxe c'a jun Ruc'ajol c'o, pero xutek-pe richin chi xabachique c'a vinek ri xtiniman richin, man c'a xtapon ta chupan ri camic ri richin jantape', xa can xtic'oje' ruc'aslen ri man q'uisel ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Roma ri Dios man xutek ta pe ri Ruc'ajol vave' chuvech re ruvach'ulef, richin chi noruk'ata' tzij pa quivi' ri vinek y noruya' ta ruc'ayeval ri richin jantape' pa quivi'. Man que ta ri'. Ri Dios xutek-pe ri Ruc'ajol, richin chi yojorucolo-ka chupan ri kamac. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Y achique vinek ri xtiniman richin, man xtika' ta ruc'ayeval pa ruvi'. Jac'a ri vinek ri man xtiniman ta richin, ri ruc'ayeval richin jantape' xa can c'o chic c'a pa ruvi', roma xa can man xunimaj ta rubi' ri juney (jun oc) Ruc'ajol ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Can conojel vi c'a ri man yeniman ta, c'o chic ri ruc'ayeval pa quivi'; roma ri Sakil can xoka-vi chuvech re ruvach'ulef, pero rije' xa más xcajo' ri k'eku'n que chuvech ri Sakil, roma rije' can xe vi c'a ri itzel tak banobel ri yequibanala'. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Y conojel c'a ri yebanon ri itzel tak banobel, man c'a nika' ta ri Sakil chiquivech, ni man chuka' yejel ta apo riq'uin; roma re Sakil re' nuben c'a chi yebek'alajin-pe ronojel ri itzel tak quibanobal ri ye'ajin chubanic. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jac'a ri vinek ri can yequibanala' banobel richin ri kitzij, can yebe-vi-apo chupan ri Sakil, richin yek'alajin jebel chi yetiquir niquiben queri' roma jun quibanon riq'uin ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Y tok banatajinek chic c'a ronojel re', ri Jesús e rachibilan ri rutijoxela' xbe pa Judea, y chiri' xebec'oje-vi. Y xe'apoviyaj c'a vinek ri chiri' richin xeban-el bautizar. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chupan c'a chuka' ri tiempo ri', ri Juan ri Bautista c'o c'a ri chiri' pan Enón, ri c'o-apo chunakaj ri tinamit rubini'an Salim. Rija' chiri' c'a yeruben-vi bautizar ri vinek, roma chupan ri lugar ri' jebel ya' c'o. Ri vinek ye'apon c'a riq'uin richin yeban-el bautizar. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chupan can ri tiempo ri' ri Juan c'a man jani c'a titz'apex pa cárcel, romari' c'a nuben bautizar. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Y ec'o ruvinak israelitas ri xquibila' chiquivech quiq'uin ri rutijoxela' ri Juan chirij ri achique chi bautismo ri más utz. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xepe c'a ri tijoxela' ri' xebe c'a riq'uin ri Juan y xbequibij chire: Tijonel, xecha' c'a. Ri Jun ri xapon aviq'uin ri juc'an chic ruchi-ya' Jordán. Ri xabij chi ja rija' ri nak'alajirisaj, xa can conojel chic ri vinek ye'apon riq'uin richin chi querubana' bautizar. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ri Juan xubij c'a chique ri rutijoxela': Ja ri Dios xtibin achique ri xtic'oje' ruk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Y rix mismo yixtiquir yixbin achique ri nubin yin, chi xa man ja ta yin ri Cristo. Yin xaxe nubin chi xitak-pe richin chi nonchojmirisaj ri acuchi xtoka-vi rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yin can xtz'aket c'a ri quicoten pa vánima vacami, riq'uin ri xinvac'axaj chi janíla e q'uiy vinek ye'apon riq'uin ri Jesucristo. Can ninc'ulvachij c'a ri nuc'ulvachij jun ala' rachibil ri ala' c'a ruc'ulubic; roma ri jun ri' niquicot chi yerac'axaj ri juc'ulaj yetzijon y quic'uan chic qui'. Can retaman c'a chi ri xten c'o chic apo riq'uin ri rachijil. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Can xe c'a ri Jesucristo ri ruc'amon chi ninimer ruk'ij, jac'a yin más utz chi yich'utiner-ka. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ri Jun ri petenek chicaj, jari' ri más nim que chikavech konojel roj vinek. Roma roj vinek, ri ti kana'oj can xe oc re vave' chuvech re ruvach'ulef niq'uis-vi-ka. Can xe oc ri' ri yojtiquir nikatzijoj. Jac'a ri Jun ri kajinek-pe chila' chicaj, man achi'el ta oc roj, roma rija' can c'o c'a pa ruvi' ronojel. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Re Jun c'a ri petenek chila' chicaj, can jac'a ri rac'axan-pe y rutz'eton can, jari' ri noruk'alajirisaj-ka chike. Pero ri vinek man nicajo' ta niquic'ul ri nuk'alajirisaj rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Y ri vinek c'a ri niniman ri nuk'alajirisaj ri Jun ri petenek chila' chicaj, can nuk'alajirisaj c'a chi ri Dios can kitzij vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Roma ri Jun ri xutek-pe ri Dios chuvech re ruvach'ulef, can ja vi ri ruch'abel ri Dios ri nutzijoj. Y ri Dios can ruyo'on c'a pe ri Lok'olej Espíritu chire. Y ri Lok'olej Espíritu ri nuya-pe chire rija' man jun ri nitiquir ta netan. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Y ri Tata'ixel can janíla vi c'a nrajo' ri Ruc'ajol, y pa ruk'a' rija' xujech-vi ronojel. ");
INSERT INTO cakCNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Achique c'a vinek ri xqueniman richin re C'ajolaxel, xtic'oje' quic'aslen ri man q'uisel ta. Jac'a ri vinek ri man nicajo' ta niquinimaj ri Ruc'ajol ri Dios, man c'a xtic'oje' ta quic'aslen; roma ri vinek ri man xtiquicukuba' ta quic'u'x riq'uin, can ec'o chic c'a richin nika' ri royoval ri Dios pa quivi'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ri achi'a' fariseos cac'axan c'a chi ri Jesús más vinek ri yeruben bautizar y más e q'uiy ri yetzekelben richin, que chiquivech ri vinek ri yeban bautizar y ri yetzekelben richin ri Juan ri Bautista. Y ri Ajaf Jesús xretamaj c'a ronojel re'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero ri Jesús man can ta ja rija' ri yebanon bautizar ri vinek. Xa jac'a ri e rutijoxela' ri yebanon bautizar. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Y ri Jesús xel c'a el ri chiri' pa Judea y xtzolin chic jun bey pa Galilea e rachibilan ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Xa jac'a richin chi ye'apon c'a pa Galilea, c'o c'a chi yek'ax ri pa Samaria. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ri Jesús e rachibilan ri rutijoxela' xe'apon c'a pa Sicar. Ri Sicar jun tinamit richin ri Samaria. Ri Sicar c'o c'a apo chunakaj ri ulef ri xuya' ri Jacob chire ri José ri ruc'ajol. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Y jac'a ri chiri' c'o-vi ri pozo ri nibix Richin Jacob chire. Chiri' c'a xtz'uye-vi-ka ri Jesús, roma rija' can janíla c'a cosinek-pe roma ri binen quibanon-pe. Ri' pa nic'aj-k'ij la'ek ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Y tok e benek c'a ri rutijoxela' pa tinamit chulok'ic vey, ri chiri' chi pozo xapon c'a jun ixok aj chiri' pa Samaria, chirelesaxic ruya'. Y ri Jesús xubij c'a chire ri ixok ri': Tasipaj juba' nuya' richin ninkun, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pero ri ixok aj-Samaria xubij c'a chire ri Jesús: Rat at jun israelita, ¿y achique roma tok nac'utuj aya' chuve yin? ¿Ruc'amon cami c'a chi jun aj-Samaria nuya' ruya' jun israelita? xcha' ri ixok. Rija' xubij queri' roma ri e israelitas y ri e aj-Samaria man junan ta quivech. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","C'ari' ri Jesús xubij c'a chire ri ixok ri': Vi ta rat avetaman achique chi sipanic ruyo'on-pe ri Dios, y avetaman ta chuka' achique c'a ri' ri nic'utun juba' ruya' chave; xa ja ta rat ri yac'utun aya' chire, y rija' nuya' ta Aya' ri can niyo'on c'aslen, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Y ri ixok xubij c'a chire ri Jesús: Re pozo nej kajinek-vi-ka, y rat man jun c'o aviq'uin richin naq'uen-ka ya'. ¿Acuchi c'a naq'uen-vi ri Ya' ri niyo'on c'aslen ri nasuj? ");
INSERT INTO cakCNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Roma can chupan c'a re jun pozo re' xuq'uen-vi ruya' ri kamama' Jacob, ri e ralc'ual y quichin chuka' ri quichicop. ¿Acuchi ta c'a xtaq'uen-vi ri Ya' ri nasuj? ¿O más ak'ij rat que chuvech ri kamama' Jacob chi man vave' ta navelesaj-vi ri Ya' ri nabij chi nuya' c'aslen? xcha' ri ixok. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Y ri Jesús xubij c'a chire ri ixok: Ri yekumun re ya' re', re nel chupan re pozo, man c'a nuc'ovisaj ta el ri nichaki'j quichi' (yechakchi'in). Xa can nic'atzin c'a chi niquikun más ya' richin chi nich'uch'u-ka juba' ri nichaki'j quichi'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jac'a ri yekumun ri Ya' ri niyo'on c'aslen ri ninya' chique yin, xtuben c'a che ri cánima chi man chic xtichaki'j ta quichi' (xtichakchi'in ta). Xa can xtuben chique chi quiq'uin rije' nalex-vi ri Ya' ri', y can xtichoxin c'a pe richin chi yeruc'uaj chupan ri c'aslen ri man q'uisel ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Y ri ixok can jac'ari' xubij chire ri Jesús: Taya' c'a ri Ya' ri' chuve yin, richin queri' man jun bey chic c'a xtichaki'j nuchi', y richin man jun chic nic'atzin-vi chi yipe vave' chi pozo chirelesaxic ya', xcha' ri ixok. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Pero ri Jesús xubij c'a chire ri ixok: Cabiyin y te'avoyoj-pe ri avachijil, xuche'ex roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ri ixok xubij c'a: Yin manek vachijil, xcha'. Y ri Jesús xubij chire: Can kitzij vi ri nabij chi manek avachijil. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Roma can e vo'o' yan avachijil quec'oje'. Y ri achin ri c'o aviq'uin vacami, xa man avachijil ta. Can ruc'amon-vi c'a ri xabij chi manek avachijil. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Y can jari' tok ri ixok xubij chire ri Jesús: Yin ninch'ob chi rat at jun k'alajirisey richin ri nibix chave roma ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","¿Achique c'a lugar ruc'amon chi nikaya-vi ruk'ij ri Dios? Roma ri kate-katata' ri xec'oje' ojer can, pa ruvi' re jun juyu' re' xquiben-vi ri jay richin xquiya' ruk'ij ri Dios. Ja chic c'a rix israelitas nibij chi conojel vinek c'o chi ja ri pa Jerusalem niquiya-vi ruk'ij ri Dios, xcha' ri ixok. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jac'a ri Jesús xubij chire ri ixok ri': Tanimaj c'a re xtinbij chave. Can xtoka-vi c'a jun k'ij tok ronojel vinek man ja ta chic pa ruvi' re juyu' re', ni man pa Jerusalem ta chuka' xtiquiya-vi ruk'ij ri Katata' Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Rix aj-Samaria q'uiy c'a ri man ivetaman ta chirij ri niya' ruk'ij. Jac'a roj israelitas can ketaman-vi ri achique ri nikaya' ruk'ij; roma can jac'a ri kiq'uin roj petenek-vi ri colotajic quichin ri vinek chupan ri quimac. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ri jun k'ij ri xinbij chave chi can nipe-vi, xoka' yan, richin chi conojel vinek man chic niquiya' ta ruk'ij ri Katata' Dios pa ruvi' re juyu' re', ni chuka' ri pa Jerusalem. Ri kitzij xqueyo'on ruk'ij ri Katata' Dios, ja ri c'o ri Lok'olej Espíritu quiq'uin, y chuka' can riq'uin ronojel cánima xtiquiya' ruk'ij. Y ri Dios can jac'a ri vinek ri yebanon queri' ri yerajo'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ri Dios can Espíritu vi. Roma c'a ri' ri vinek ri yeyo'on ruk'ij, can nic'atzin chi c'o ri Lok'olej Espíritu quiq'uin y riq'uin ronojel cánima tiquiya' ruk'ij. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Y ri ixok xubij c'a chire ri Jesús: Yin vetaman c'a chi c'o na jun k'ij tok xtoka' chuvech re ruvach'ulef ri Mesías, ri nibix chuka' Cristo chire. Y ri k'ij tok xtoka' rija', ronojel c'a xtuk'alajirisaj chikavech, xcha' ri ixok. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ri Jesús xubij c'a chire: Ri Mesías ri nibij chuka' Cristo chire, ja yin ri'. Ja yin ri yitzijon aviq'uin, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Y jac'ari' tok xe'apon ri rutijoxela', y rije' jun vi juba' xquitz'et roma nitzijon riq'uin jun ixok aj chiri' pa Samaria. Pero ri tijoxela' man jun xquibij chire ri Jesús: ¿Achique nac'utuj chire? o ¿Achique ri natzijoj riq'uin? Can man jun vi c'a xquic'utuj chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Y ri ixok ri' xuya' c'a can ri rucucu' (ruk'e'l) y xbe ri pa tinamit. Y xberubij c'a chique ri vinek: ");
INSERT INTO cakCNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","C'o jun achin xch'on viq'uin y xubij c'a chuve ronojel ri e nubanalon. ¿Man cami ja ta c'a re' ri Cristo? Jo', y titz'eta', xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Y ri vinek ri xe'ac'axan ri', xquiya' can ri tinamit y xebe c'a acuchi c'o-vi ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Y tok man jani c'a que'apon ri vinek, ri tijoxela' xquibij c'a chire ri Jesús: Tijonel, tatija' avay, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero rija' xubij c'a chique: Rix man c'a ivetaman ta chi yin c'o nuvay richin nintej, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","¿C'o cami xc'amon-pe ruvay? xecha-ka ri tijoxela' chiquivech rije'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Y ri Jesús xubij chique: Ri nuvay yin jac'a ri ninben ri rurayibel ri takayon-pe vichin y ninq'uis can rubanic ronojel ri rusamaj ri ruchilaben-pe chuve. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Rix nibij c'a chi c'a c'o na caji' ic' nrajo' richin chi nic'ol ronojel quivech tico'n. Jac'a yin ninbij chive: Quixtzu'un chila' y que'itzu' la vinek. Rije' e achi'el jun tico'n ri k'en chic. Coyoben chic richin nitzijox ri ruch'abel ri Dios chique, richin niquinimaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ri xquebanon c'a la cosecha la', can c'o c'a rajel-ruq'uexel xtiquic'ul; roma ri vinek ri xtiniman ri ruch'abel ri Dios, xtuc'ul ruc'aslen ri man q'uisel ta. Y riq'uin ri', ri e tiquiyon can ri ruch'abel ri Dios, can xtiquicot c'a cánima quiq'uin ri yec'olon re jun ruvech cosecha re'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Vave' can kitzij vi c'a nel ri tzij ri nubij: Jun vi c'a ri nibanon can ri ticoj y jun vi chic ri nic'olon ruvech ri tico'n. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yin xixintek c'a richin chi rix xaxe chic nic'ol ri cosecha ri man ja ta rix ri xixcos chusamajixic. Roma ri ruch'abel ri Dios can ch'aka' chic c'a samajela' e tiquiyon can pa tak cánima ri vinek, y rix xaxe chic c'a juba' samaj ri ne'ibana' richin niquinimaj ri ruch'abel ri Dios, xcha' ri Jesús chique ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Y chupan c'a ri k'ij ri', can e janíla vi ri vinek xeniman richin ri Jesús ri chiri' pa tinamit Sicar, ri c'o chiri' pa Samaria. Y ri' roma ri xberubij ri ixok chique chi ri Jesús xubij chire ronojel ri e rubanalon. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Y ri samaritanos ri' xbequic'utuj c'a chire ri Jesús chi tic'oje-ka quiq'uin. Y rija' xc'oje' c'a ka ca'i' k'ij quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Y ec'o c'a ch'aka' chic vinek ri aj chiri' ri xeniman, pero can c'a ja tok cac'axan chic na ri ch'abel ri nubij ri Jesús. Can e q'uiy vi c'a ri xeniman. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Re vinek c'a re' niquibila' c'a chire ri ixok ri xbeyo'on rutzijol chique: Vacami can ketaman chic c'a y nikanimaj chuka', man xe ta roma ri xabij rat chike, xa can nikanimaj chuka' roma ri xkac'axaj roj mismo. Xketamaj c'a chi can kitzij vi chi ja rija' ri Cristo, ri Colonel quichin conojel vinek ri ec'o chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tok ic'ovinek chic ri ca'i' k'ij, xuya' can ri tinamit Sicar ri c'o chiri' pa Samaria y xuchop chic c'a el ri rubey richin nibe c'a pa Galilea. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Y jac'a ri Jesús ri nibin chi jun ri nik'alajirisan ri ruch'abel ri Dios pa rutinamit, xa man jun ruk'ij chiquivech ri ruvinak. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pero tok ri Jesús xapon pa Galilea, jebel ruc'ulic xban coma ri vinek aj chiri'; roma re vinek re' xec'oje' pa Jerusalem richin ri nimak'ij y xquitz'et ri milagros ri xerubanala' ri Jesús chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","C'ari' ri Jesús xbe chic c'a jun bey ri pa tinamit Caná ri c'o chiri' pa Galilea, ri acuchi xuben chi xoc ruya'al-uva ri ya'. Y chiri' pa Galilea, pa jun chic tinamit ri rubini'an Capernaum, c'o c'a jun achin nimalej rusamajel ri rey, yava' jun ruc'ajol. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Re achin re rusamajel ri rey, tok xrac'axaj chi ri Jesús petenek c'a quela' pa Judea y xapon ri chiri' pa Galilea, xbe c'a riq'uin. Rija' xberuc'utuj utzil chire richin nucol ta ri ruc'ajol chuvech ri camic, roma ri ala' ri' xa can niquen yan c'a (nicom yan c'a). ");
INSERT INTO cakCNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","C'ari' ri Jesús xubij c'a chire ri rusamajel ri rey: Man ta nitz'et rix ri milagros ri ninben yin, xa man ta yininimaj. Y chuka' vi man ta nik'alajin riq'uin ri milagros chi can ja ri Dios ri takayon-pe vichin, xa man ta chuka' yininimaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero ri achin ri rusamajel ri rey xubij c'a chire ri Jesús: Ajaf, tabana' c'a utzil chi yaxule' ta c'a ka pa tinamit Capernaum, roma ri nuc'ajol xa can niquen yan (nicom yan). ");
INSERT INTO cakCNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Y ri Jesús xubij c'a chire: Catzolin. Ri ac'ajol xtic'ase' c'a can, xuche'ex-el. Y ri achin ri' can xunimaj-vi ri xubij ri Jesús, y xbe. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tok ri achin ri rusamajel ri rey ruchapon-ka rutzolejen, ec'o c'a rajic'a' xepe chuc'ulic y xquibij c'a chire: Ri ac'ajol q'ues. Man xquen ta (xcom ta), xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Y rija' xuc'utuj c'a chique ri ajic'a' ri' achique c'a hora tok ri ruc'ajol xk'alajin chi nic'achoj. Y ri ajic'a' xquibij: Ja ri tikak'ij ivir. La una chiri', tok xq'uis-el ri c'aten chirij, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ri rutata' ri ala' yava', chanin c'a xoka' chuc'u'x chi ja hora ri' tok ri Jesús xubij chire chi ri ruc'ajol man xtiquen ta (xticom ta). Y romari' rija' y ri e aj pa rachoch can xquinimaj c'a ri Jesús; xquicukuba' c'a quic'u'x riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Y jac'are' ri ruca'n milagro ri xuben ri Jesús chiri' pa Galilea; milagro ri nik'alajirisan richin chi can ja vi ri Dios takayon-pe richin. Y re' jare' ri milagro ri xuben tok petenek c'a quela' pa Judea. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Y tok banatajinek chic c'a ronojel ri', jari' noka' yan c'a jun quinimak'ij ri israelitas, y romari' tok ri Jesús c'o chi xbe-el ri pa tinamit Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ri chiri' c'a pa tinamit Jerusalem, ri chunakaj apo ri puerta Quichin ri Carne'l nibix chire, c'o c'a jun atinibel. Y chiri' chuchi' ri ya' ec'o c'a vo'o' corredores. Y ri vinek israelitas niquibij c'a Betesda che ri lugar ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ri chiri' c'a ri pa tak corredores ri' janíla e q'uiy yava'i' e cotz'ol ri chiri' pan ulef. Ec'o e moyi', ec'o ri man choj ta yebiyin roma ri e jetz', y ec'o e siquirinek. Y ec'o c'a ri jun vi chic chi ruvech yabil noc chique. Y ronojel c'a quivech yava'i' ri', can coyoben c'a chi nisilon-pe ri ya'. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Roma re ya' re' can c'o c'a k'ij tok nosilox can roma jun ángel ri nipe chila' chicaj riq'uin ri Dios. Y jac'a ri yava' ri nika' nabey chupan ri ya' tok silon chic, jac'a yava' ri' ri nic'achoj. Y xabachique yabil noc chire ri yava', nic'achoj-el. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Y chiri' chuchi' ri ya' c'o c'a jun achin ri yava' pe treinta y ocho juna'. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Y jun k'ij tok ri Jesús nik'ax c'a el queri', xutz'et c'a ri achin cotz'ol chiri'. Y rija' can retaman c'a chi ri achin ri' q'uiy yan c'a juna' ri queri' ruc'ulvachin-pe. Y c'ari' rija' xuc'utuj c'a chire ri achin ri': ¿Navajo' yac'achoj? ");
INSERT INTO cakCNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Y re yava' re' xubij c'a chire ri Jesús: Tok nisilon-pe la ya', man jun nibanon utzil chuve richin ta yiruto' yinapon-apo c'a chupan. Romari', stape nintej nuk'ij chi yibe ta apo, c'a man jani quinapon tok ja yan ri' xapon chic jun, xcha' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Y ri Jesús xubij chire ri achin: Cayacatej, tac'uaj-el la avarabel y cabiyin, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Can xe c'a xubij queri' ri Jesús chire ri yava', can jac'ari' xc'achoj chire ri ruyabil. Xuc'ol c'a el ri ruvarabel y xuchop-el binen. Ri k'ij c'a ri', richin uxlanen. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Y ri achi'a' ri can c'o quik'ij chiquicojol ri israelitas, xquibij chire ri achin ri xc'achojirisex chire ri ruyabil: Vacami k'ij richin uxlanen, xa xajan chi rat ac'uan-el la avarabel. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pero rija' xubij c'a chique ri achi'a' ri': Ri xc'achojirisan vichin xubij chuve: Tac'olo-el la avarabel y cabiyin. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Y ri achi'a' ri' xquic'utuj c'a chire ri achin: ¿Achique c'a ri xbin chave chi tac'olo' ri avarabel y cabiyin? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero ri achin ri xc'achojirisex, man retaman ta c'a achique ri xc'achojirisan chire ri ruyabil; roma ri Jesús xa man xc'oje' ta ka chiri' chiquicojol ri vinek. Rija' xa xbe. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","C'a juba' c'a ri' ri Jesús xberila' chic ri achin ri' pa rachoch ri Dios, y xubij chire: Vacami xa can at utz chic. Man chic c'a camacun, richin queri' man tavoyobej jun cosa más itzel chavij, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Y ri achin xtzolin-el, y xapon c'a quiq'uin ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, y xubij chique: Ri xc'achojirisan vichin, ja ri Jesús, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Romari' tok ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, can xeyacatej c'a chirij ri Jesús, y niquich'obola' c'a achique ta rubanic niquiben richin niquicamisaj; roma ri Jesús c'o milagros yerubanala' chupan ri k'ij richin uxlanen. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero ri Jesús xubij: Ri Nata' Dios can c'a nisamej re k'ij re', y que c'a chuka' ri' yin, yisamej. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Y jac'ari' tok ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, más xquich'ob rij richin chi achique ta rubanic niquiben richin niquicamisaj ri Jesús; roma chiquivech rije', xajan ri yerubanala' chupan ri k'ij richin uxlanen. Y chuka' man xe ta c'a romari', xa can roma c'a chuka' ri Jesús nubij Rutata' chire ri Dios, roma chiquivech rije', ri Jesús can nuben chi rija' junan riq'uin ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Y jac'ari' tok ri Jesús xubij: Can kitzij c'a re ninbij chive, chi yin ri Ruc'ajol ri Dios man yitiquir ta yisamej pa nuyonil; xa can nic'atzin chi ninvoyobej na ri nubij ri Nata'. Roma ja ri samaj ri nrajo' rija', jari' ri ninben yin ri Ruc'ajol. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Y roma ri Nata' Dios janíla yirajo' yin ri Ruc'ajol, romari' tok rija' nuc'ut chinuvech ronojel ri rusamaj rija'. Y chikavech apo c'o samaj más e nima'k ri xtuc'ut chinuvech. Y tok xtinben re samaj re', rix can xtisach c'a ic'u'x chutz'etic. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Y can achi'el c'a nuben ri Nata' Dios tok nuya' quic'aslen ri caminaki' ri yeruyec-pe, can que c'a chuka' ri' ninben yin. Yin can ninya' c'a chuka' quic'aslen ri yenvajo'. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ri Nata' Dios, can pa nuk'a' c'a chuka' yin ri Ruc'ajol rujachon-vi ri k'atoj-tzij y man ja ta c'a rija' ri xtibanon. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Richin queri', yin xtinc'ul c'a chuka' nuk'ij achi'el ri nuc'ul ri Nata'. Roma achique vinek ri man xtiyo'on ta nuk'ij yin ri C'ajolaxel, man nuya' ta c'a chuka' ruk'ij ri Nata', ri takayon-pe vichin. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Roma can kitzij vi ri ninbij chive, chi ri nac'axan ri nuch'abel y nunimaj rubi' ri takayon-pe vichin, nril ruc'aslen ri man q'uisel ta. Man c'a xtapon ta chupan ri lugar richin janíla ruc'ayeval, roma colotajinek chic chuvech ri camic, richin xk'ax-apo chupan ri c'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Y can kitzij c'a re ninbij chive, chi c'o c'a jun k'ij ri oyoben y jare' xoka' yan; chi ri achi'el e caminaki' xticac'axaj c'a ri nuch'abel yin ri Ruc'ajol ri Dios. Y jac'a ri can xquincac'axaj-vi, xtiquil quic'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Roma ri Dios ruyo'on k'ij chuve richin chi ninya' c'aslen, achi'el nuben rija'. Ri Nata' Dios can nuya-vi c'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Y chuka' nilitej k'atbel-tzij viq'uin, roma ri Nata' Dios yirucusaj richin ri'; roma rija' retaman chi yin xinalex chi'icojol. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Man c'a tich'ob chi ja ri xinbij yan chive ri más nima'k ri yitiquir ninben, man que ta ri', roma can xtapon c'a ri k'ij chi ri e caminaki' chic el can c'o c'a chi nicac'axaj ri nuch'abel. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Y jac'a ri xe'uc'uan jun c'aslen utz chuvech ri Dios, xquebeyacatej c'a pe richin xtiquil quic'aslen ri man q'uisel ta. Y ri man utzilej c'aslen ta xquic'uaj chuvech ri Dios, xquebeyacatej c'a pe richin xquebeka' c'a pa ruc'ayeval. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yin can man yitiquir ta c'a yisamej pa nuyonil, roma xa can achi'el ri k'atoj-tzij ri nik'alajirisex chinuvech, queri' ri ninben. Ri nuk'atoj-tzij can pa ruchojmilal; roma can man ja ta ri nurayibel yin ri ninben, xa can ja ri rurayibel ri Nata' Dios ri takayon-pe vichin, jari' ri ninben. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Y vi ta man jun chic nik'alajirisan vichin, utz ta chi nibix chuvij chi man kitzij ta ri ninbij. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero can c'o chic c'a Jun ri nik'alajirisan vichin. Y ri nubij rija' chuvij yin, can kitzij vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Y rix can xitek c'a ruc'utuxic chire ri Juan ri Bautista chirij ri Cristo, y rija' xuk'alajirisaj-pe ri kitzij chivech. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Re' ninnataj c'a apo chive, richin chi yixcolotej ta c'a. Roma can c'o chic c'a Jun ri más nim ri nik'alajirisan vichin, que chuvech ri Juan ri Bautista o jun chic vinek. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Y ri Juan ri Bautista can xuya' c'a ri sakil chive. Can xuben-vi c'a achi'el nuben juboraj chej tok nic'at y nisakirisan. Y rix xirayij y xixquicot c'a riq'uin ri sakil ri', jun ca'i-oxi' k'ij. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Y roma c'a ri xuk'alajirisaj ri Juan chuvij yin, can utz vi chi yininimaj. Pero más c'a nic'atzin chi yininimaj, roma ri samaj ri yenben yin chivech. Samaj ri can niquik'alajirisaj chi ja ri Nata' Dios ri takayon-pe vichin. Y can jac'a rija' ri chilabeyon-pe chuve chi ninben re samaj re'. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Y can jac'a ri Nata' Dios ri xitakon-pe, ri nik'alajirisan chuka' vichin. Y rix man jun bey ivac'axan ta achique rubanic nuben nich'on, ni man jun bey chuka' itz'eton ta ruvech. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ri ruch'abel rija' can man c'o ta c'a ri pa tak ivánima, roma rix xa man yininimaj ta yin ri xitak-pe richin chi yinoc'oje-ka chi'icojol. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Can tinic'oj c'a jebel rupan ri ruch'abel ri Dios ri tz'ibatel can, roma can ivetaman chi chupan ri' nivil-vi c'aslen ri man q'uisel ta. Y chupan ri ruch'abel ri Dios can jac'a yin ri yiruk'alajirisaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jac'a rix man nivajo' ta nicukuba' ic'u'x viq'uin, richin queri' nivil ta ri ic'aslen ri man q'uisel ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Y ronojel re xinbij-ka chive, man roma ta c'a chi yin ninvajo' ta chi rix niya' nuk'ij-nuc'ojlen. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yin xa can vetaman c'a ivech jebel, romari' vetaman chi xa man jun retal ri ajovabel richin ri Dios ri pa tak ivánima. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Roma yin can pa rubi' ri Nata' Dios in petenek-vi y xa man xinic'ul ta. Pero vi ta ec'o ri yepe, pa quibi' rije' mismo, jari' sí can chi'ivonojel yixbe chiquic'ulic. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Rix c'a ri xa man nicanoj ta ik'ij riq'uin ri kitzij Dios, y xa quiq'uin vinek nicanola-vi, can man c'a xticukuba' ta ic'u'x viq'uin yin. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Y man c'a tich'ob ri pa tak ivánima chi ja yin ri xquisujun chivij chuvech ri Nata' Dios. Man que ta ri'. Ri xtisujun c'a ivichin chuvech ri Dios roma man ja ta ri niben, ja ri Moisés; ri achok iq'uin nibij-vi rix chi can icukuban-apo ic'u'x. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Roma xa ta can kitzij chi rix ninimaj ri e rutz'iban can ri Moisés, can yininimaj ta chuka' yin, roma ri e rutz'iban can rija' can chuvij vi yin yech'on-vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Y vi xa man ninimaj ta ri e tz'ibatel can roma ri Moisés, man c'a xtinimaj ta chuka' ri ch'abel ri nuc'amon-pe yin chive, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Y tok e banatajinek chic c'a can ronojel re', ri Jesús y ri rutijoxela' xebe c'a juc'an ruchi-ya' Galilea; ya' ri rubini'an chuka' Tiberias. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Can e janíla c'a e q'uiy vinek ri xetzekelben-el richin, roma re vinek re' quitz'eton chic c'a ri milagros yerubanala' quiq'uin ri yava'i', milagros ri yek'alajirisan richin chi can ja vi ri Dios takayon-pe richin. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ri Jesús y ri rutijoxela' xejote' c'a el pa ruvi' jun juyu'; y rija' tz'uyul c'a chiquicojol ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ri k'ij c'a ri', xa nakaj chic c'a c'o-vi ri pascua, ri nimak'ij israelita. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Y tok ri Jesús xtzu'un c'a más quela', xutzu' chi can janíla c'a e q'uiy vinek ri e apovinek-apo riq'uin. Romari' rija' xubij c'a chire ri Felipe ri jun rutijoxel: ¿Acuchi xtekalok'o-vi-pe vey richin chi yekatzuk conojel re vinek re'? ");
INSERT INTO cakCNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Que c'a re' ri xuc'utuj ri Jesús chire ri rutijoxel, richin chi nretamaj achique c'a ri nuch'ob; vi noka' chuc'u'x chi ri Jesús ronojel nitiquir nuben. Pero ri Jesús xa can retaman chic ri c'o chi nuben richin yerutzuk ri vinek ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Y ri Felipe xubij c'a chire ri Jesús: Vi ta nikalok' ca'i' ciento quetzales vey, man xqueruben ta. Can man xtel ta apo chiquivech, stape' xa juba' ta oc ri nikaya' chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","C'ari' jun c'a chique ri rutijoxela', ri rubini'an Andrés y rach'alal ri Simón Pedro, xubij: ");
INSERT INTO cakCNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Vave' c'o jun ala' c'o vo'o' vey richin cebada y ca'i' tak quer e ruc'amon-pe, ¿pero xaxe ta c'a oc re' ri xtikaya-apo chiquivech conojel re vinek re'? xcha' ri Andrés. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","C'ari' ri Jesús xubij c'a: Tibana' chique la vinek chi quetz'uye', xcha' rija'. Y ri lugar c'a ri' jebel richin yetz'uye', roma ri sabana rex-rex rubanon. Conojel c'a ri vinek quimolon-qui' chiri' xetz'uye'. E vo'o' mil la'ek xaxe ri achi'a'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ri Jesús xeruli'ej c'a re vo'o' vey re' y xumatioxij chire ri Dios. C'ari' xujachala-el chique ri rutijoxela', y ri tijoxela' xbequijachala' can chique ri vinek ri e tz'uyul. Y ri Jesús can que c'a chuka' ri' xuben riq'uin ri ca'i' quer. Ri vinek can xquic'ul c'a ri janipe' vey y quer ri xcajo'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Y tok e va'inek chic c'a jebel ri vinek ri', ri Jesús xubij c'a chique ri rutijoxela': Timolo' c'a pe ronojel vey y quer ri man xq'uis ta, roma man ninvajo' ta c'a chi c'o ta yec'oje' can queri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ri tijoxela' can xbequimolo' c'a pe y xquinojisaj cablajuj chaquech riq'uin ri man xq'uis ta rutijic, tok e va'inek chic conojel. C'a ja na c'a ri' xmolotej can chire ri vo'o' tak vey banon riq'uin cebada. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Y ri vinek ri', tok quitz'eton chic ka ri milagro ri xuben ri Jesús, ri nik'alajirisan chi can ja ri Dios ri takayon-pe richin, rije' xquibij: Can kitzij vi chi ja achin re' ri k'alajirisey ruch'abel ri Dios ri q'uiy yan tiempo oyoben chi can nipe-vi chuvech re ruvach'ulef, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ri Jesús can ruyon c'a xtzolin-el pa ruvi' ri juyu', roma can xunabej chi ri vinek xquepe chuc'amic richin chi niquiben qui-rey chire y stape' man nrajo' ta rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Y ri rutijoxela' ri Jesús xetzolin-ka chuchi-ya', c'a tok xquitz'et na chi xkak'ij-ka. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Rije' xe'oc c'a el pa jun canoa y quichapon c'a el bey richin chi yebe c'a pa tinamit Capernaum, ri c'o c'a juc'an chic ruchi' ri ya'. Janíla chic c'a k'eku'n chiri' y ri Jesús xa man apovinek ta quiq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Y jac'ari' tok xbetiquir-pe jun nimalej cak'ik' pa ruvi' ri ya'; jun cak'ik' ri janíla ruchuk'a'. Y romari' ri ya' can janíla c'a nisilon. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Y tok e biyinek chic c'a jun vo'o' o vaki' kilómetros pa ruvi' ri ya', ri tijoxela' xquitz'et chanin chi ja ri Jesús ri petenek chiraken pa ruvi-ya' y yeruk'i' yan c'a. Y rije' janíla c'a xquixibij-qui'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero ri Jesús xubij c'a chique: Man tixibij-ivi'. Ja yin ri Jesús, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ri tijoxela' xcac'axaj na c'a chi can ja na vi rija' ri Jesús, c'ari' xcuker-ka quic'u'x y riq'uin quicoten xquic'ul-apo ri Jesús chupan ri canoa. Y can jac'ari' tok xe'apon chuchi' ri ya', ri lugar ri c'o chi ye'apon-vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pa ruca'n k'ij, ri vinek ri c'a xec'oje' na can juc'an ruchi-ya' ri jun tikak'ij can, c'a quimolon na c'a qui'. Rije' can quetaman c'a chi xaxe ri rutijoxela' ri Jesús ri xetzolin chupan ri jun oc canoa ri c'o chiri'. Y ri Jesús xa xc'oje' can. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ri k'ij c'a ri', ec'o c'a canoas ri e petenek pa tinamit Tiberias y xe'apon chunakaj ri acuchi xquitej-vi quivay ri vinek ri jun k'ij can; ri vey ri xuya' ri Ajaf Jesús chique, tok rumatioxin chic chire ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Y ri vinek ri', roma xquitz'et chi ri Jesús xa man c'o ta chic ri chiri' y ri rutijoxela' xa xetzolin yan, rije' chuka' xe'oc-el ri pa tak canoas y xebe pa Capernaum chucanoxic ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tok re vinek re' xbequila' ri Jesús la juc'an ruchi-ya', xquibij c'a chire: ¿Jampe' catoka' vave'? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Pero ri Jesús xubij c'a chique ri vinek ri': Kitzij ninbij chive, chi rix yinicanoj xaxe roma xivil ivay viq'uin y jebel xinojisala' ipan, y man roma ta chi xe'itz'et ri milagros ri yek'alajirisan chi yin can ja vi ri Dios ri takayon-pe vichin. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Can quixsamej c'a, pero man richin ta chi nich'ec ri vey ri xa niq'uis. Xa can quixsamej richin nich'ec ri Vey ri jantape' c'o y nuya' ic'aslen ri man q'uisel ta. Vey ri xtinya' chive yin ri xinalex chi'icojol, roma ja yin xirutek-pe ri Nata' Dios, richin ninben re samaj re', xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Y ri vinek ri' xquibij c'a chire ri Jesús: ¿Achique c'a ri nika' chuvech ri Dios chi nikaben ta? ");
INSERT INTO cakCNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Y ri Jesús xubij c'a chique: Ri nika' chuvech ri Dios chi rix niben ta, ja ri quininimaj yin ri xitak-pe roma rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Y ri vinek xquibij chire ri Jesús: ¿Achique c'a ri yatiquir naben? Tabana' c'a jun milagro, richin queri' nikatz'et y yatkanimaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Roma ri ojer tak kati't-kamama', tok xek'ax chupan ri tz'iran ruvach'ulef, jac'a ri vey xubini'aj maná ri xuya' ri Moisés chique richin xquitej. Can achi'el vi c'a ri nubij ri ruch'abel ri Dios ri tz'ibatel can. Chiri' nubij: Vey c'a ri petenek chila' chicaj ri xuya' chique richin xquitej. Y rat ¿yatiquir cami naben achi'el xuben ri Moisés? ");
INSERT INTO cakCNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Y ri Jesús xubij c'a chique: Tivac'axaj c'a jebel re xtinbij chive: Ri vey ri xpe chila' chicaj, man ja ta c'a ri Moisés ri xyo'on. Jac'a ri Nata' Dios ri niyo'on chive ri kitzij Vey richin chila' chicaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Roma ri Vey ri can richin ri Dios, jac'a ri Jun ri petenek chila' chicaj. Y jari' ri c'amayon-pe c'aslen chique ri vinek, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tok xcac'axaj queri' ri vinek, xquibij c'a chire ri Jesús: Can jantape' c'a taya' re Vey re' chike, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Y ri Jesús xubij c'a chique: Ja yin ri Vey ri yiyo'on c'aslen. Ri xtucukuba' ruc'u'x viq'uin, man chic c'a xtinum ta ri ránima; roma ja yin ri yinoc Ruvay ri nic'ovisan-el ruvayjal. Y chuka' ri xtucukuba' ruc'u'x viq'uin, man xtichaki'j ta chic ruchi' (xtichakchi'in ta chic) ri ránima; roma ja yin ri yinoc Ruya' ri nic'ovisan-el ri nichaki'j ruchi' (nichakchi'in). ");
INSERT INTO cakCNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero can achi'el c'a ri nubin chive, chi stape' rix can xitz'et y xivac'axaj ri samaj xinben yin iviq'uin, man c'a xquininimaj ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Conojel c'a ri xquepe chinucanoxic, yenc'ul; y man jun bey xquenvetzelaj ta el. Roma jac'are' ri e rucha'on chic ri Nata'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Roma yin re xika-pe chila' chicaj man nusamaj ta c'a yin ri nuc'amon-pe, man que ta ri'. Yin xika-pe chila' chicaj chubanic ri samaj ri can rurayibel vi ri takayon-pe vichin. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Y ri samaj c'a ri ruchilaben-pe ri Nata' Dios ri takayon-pe vichin, jac'a chi conojel ri e rucha'on rija', ri yecanon vichin yin, man ta c'a xquesach can, y pa ruq'uisibel k'ij xquenc'asoj ta el chiquicojol ri caminaki'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ri samaj chuka' ri chilaben-pe chuve roma ri Nata', ri takayon-pe vichin, jac'a chi conojel ri yetz'eton ri nusamaj y niquicukuba' chuka' quic'u'x viq'uin, tic'oje' c'a quic'aslen ri man q'uisel ta, y yenc'asoj-el chiquicojol ri caminaki' ri pa ruq'uisibel k'ij, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jac'a ri vinek israelitas ri' yexebeloj chirij ri Jesús, roma rija' xubij: Ja yin ri Vey ri kajinek-pe chila' chicaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Y yequixebexa' c'a: ¿Man ja ta c'a re' ri Jesús ri ruc'ajol ri José? Xa ketaman c'a quivech ri rute-rutata'. C'a ta c'a chike roj xtorubij-vi chi rija' kajinek-pe chila' chicaj riq'uin ri Dios, yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pero ri Jesús xubij c'a chique: Man c'a quixxebexot-pe chuvij yin. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Roma ri xqueniman vichin, xa jac'a ri samajinek chic ri Nata' Dios pa tak cánima; ri Nata' Dios ri takayon-pe vichin. Y yin can xtinben c'a chique ri yeniman vichin chi xquec'astej-el chiquicojol ri caminaki' ri pa ruq'uisibel k'ij. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Y can tz'ibatel c'a chuka' coma ri achi'a' ri xek'alajirisan ri ruch'abel ri Dios ojer can, chi conojel c'o c'a ri xtic'ut chiquivech roma ri Dios, queri' ri nubij. Y ri achique c'a ri nrac'axaj ri ruch'abel ri Nata' Dios y nretamaj, can xtipe c'a chinucanoxic. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pero yin man ninbij ta c'a chi c'o ta jun vinek ri tz'eteyon richin ri Dios, man que ta ri'. Xaxe yin ri in petenek chila' chicaj riq'uin rija' ri in tz'eteyon ruvech ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tivac'axaj na pe' jebel re xtinbij chive: Ri niniman c'a vichin, can c'o na vi ruc'aslen ri man q'uisel ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ri Vey c'a ri can niyo'on na vi c'aslen, ja yin. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Roma ri vey ri xubini'aj maná, ri xtij coma ri ojer tak ivati't-imama' ri xek'ax pa tz'iran ruvach'ulef, man xtiquir ta xuben chique chi xc'oje' ta quic'aslen richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jac'a ri kitzij Vey ri kajinek-pe chila' chicaj nuben chique ri yetijon richin chi man xque'apon ta chupan ri camic ri richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ja yin c'a ri Vey ri can c'o ruc'aslen, ri xka-pe chila' chicaj. Ri xtiquitej c'a re Vey re', xquec'ase' richin jantape'. Ri Vey c'a ri xtinya' yin chique can jac'a ri nuch'acul. Can xtapon-vi c'a pa camic richin chi nuq'uen-pe c'aslen chique ri vinek ri ec'o chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Y re vinek israelitas re', tok xcac'axaj ri xubij ri Jesús, xquic'utula' c'a chiquivech ka rije': ¿Achique c'a rubanic ri' chi rija' nuya' ri ruch'acul chike richin nikatej? yecha' c'a. Xa can xejalajo' c'a roma man junan ta quich'obonic. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Y ri Jesús xubij c'a chique: Can kitzij vi, chi vi xa man nitej ta ri nuch'acul y man nikun ta chuka' ri nuquiq'uel yin ri xinalex chi'icojol, ri c'aslen richin jantape' can man xtoc ta ivichin. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ri can xtiquitej c'a ri nuch'acul yin y xtiquikun chuka' ri nuquiq'uel, can c'o-vi c'a ri quic'aslen richin jantape'. Y yin can xtinben c'a chique chi xquec'astej-el chiquicojol ri caminaki', ri pa ruq'uisibel k'ij. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Roma ri nuch'acul yin jari' ri kitzij Vey y ri nuquiq'uel jari' ri kitzij Ya'; ri can niquiq'uen-pe c'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ri can niquitej c'a ri nuch'acul yin y niquikun chuka' ri nuquiq'uel, xa jun c'a ri xtikaben quiq'uin. Rije' xquec'oje' viq'uin yin y yin quiq'uin rije'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Roma can ja ri Nata' ri takayon-pe vichin y rija' can c'o-vi ri c'aslen riq'uin, yin chuka' c'o ri c'aslen ri' viq'uin. Y can que c'a chuka' ri' ri xquinquic'ul yin, can xquec'ase-vi voma yin. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ri can kitzij Vey c'a, ri kajinek-pe chila' chicaj, ri Vey ri' can man junan ta riq'uin ri vey ri xubini'aj maná ri xquitej ri ojer tak ivati't-imama', roma ri vey ri xquitej rije' man xtiquir ta xuben chique chi xc'oje' ta quic'aslen richin jantape'. Jac'a ri niquitej ri kitzij Vey ri kajinek-pe chila' chicaj xtic'oje' quic'aslen ri can richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jac'are' ri xubij ri Jesús chique ri vinek israelitas ri quimolon-qui' chupan ri jay ri can nitzijox-vi ri ruch'abel ri Dios, chiri' pa tinamit Capernaum. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Y tok ri yetzekelben richin ri Jesús cac'axan chic ka ri xubij, e q'uiy c'a chique rije' ri xquibij: Yalan c'ayef ri xubij. Man k'alaj ta, vi ec'o ri xqueniman. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Y tok ri Jesús xutz'et ri niquich'ob pa tak cánima e q'uiy chique ri yetzekelben richin, rija' xubij c'a chique: ¿Achique roma tok rix nich'ob chi c'ayef richin xtinimex ri xinbij? ");
INSERT INTO cakCNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Vi ta yinitz'et yin ri xinalex chi'icojol chi yitzolin chila' riq'uin ri Dios ri acuchi in petenek-vi, ¿man ta cami yininimaj? ");
INSERT INTO cakCNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ri ruc'aslen ri ich'acul, ja ri ru-espíritu ri niyo'on. Ri ich'acul xa can man jun rejkalen. Y ri Espíritu ri niyo'on ri kitzij ic'aslen, jac'a ri ch'abel ri e nubin chic ka chive ri niyo'on. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero can c'a e q'uiy na c'a chive rix ri man nurayij ta cánima yinquinimaj, xcha' ri Jesús. Roma rija' can pa nabey c'a ri retaman chic pe achique vinek ri man xqueniman ta, y ri achique xtic'ayin-el richin. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Y ri Jesús xubij c'a: Roma ec'o c'a chive rix ri man nurayij ta cánima yinquinimaj, romari' tok yin nubin c'a chive chi ja ri vinek ri e cha'on roma ri Nata' Dios, jari' ri xquepe c'a viq'uin yin chinucanoxic, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Roma c'a ri xubij ri Jesús, janíla c'a e q'uiy chique ri can quetzekelben richin, man chic xquitzekelbej ta. Xa can xetzolin c'a can. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Y ri Jesús xubij c'a chique ri cablajuj rutijoxela': ¿Rix chuka' nivajo' yixbe can? ");
INSERT INTO cakCNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Y ri Simón Pedro xubij c'a chire ri Jesús: Ajaf, man jun chic achi'el rat, richin nikatzekelbej ta; roma ri ach'abel rat can nuya' c'aslen ri man q'uisel ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Roj can kacukuban kac'u'x aviq'uin y ketaman chi ja rat ri Cristo, ri Ruc'ajol ri c'aslic Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Y ri Jesús xubij c'a: Man riq'uin c'a chi can ja yin ri xicha'on ivichin rix cablajuj, can c'o c'a jun ri itzel-vinek xc'ulun chi'icojol, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tok ri Jesús xunataj c'a ri jun ri itzel-vinek xel, chirij c'a ri Judas Iscariote xch'on-vi; ri Judas ri ruc'ajol ri jun achin rubini'an Simón. Ri Jesús xunataj c'a ri jun ri', roma jac'ari' ri xtic'ayin-el richin ri Jesús. Y rija' can jun c'a chique ri cablajuj rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Y c'ari' ri Jesús xuchop benan pa tak tinamit ri ec'o pa Galilea. Man c'a rajovan ta chic benek tzijoy ruch'abel ri Dios c'a pa Judea, roma ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, niquicanola' c'a achique rubanic niquiben richin niquicamisaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ri k'ij c'a ri', xa can nakaj chic c'a c'o-vi ri jun chique ri quinimak'ij ri israelitas; nimak'ij richin niquinatabej ri tiempo ri xquic'ovisaj ri cati't-quimama' chupan ri tz'iran ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Y ri e rach'alal c'a ri Jesús xquibij chire rija': Taya' c'a can juba' re Galilea y cabiyin pa Judea, richin queri' ri vinek ri can yetzekelben avichin ri ec'o chila', tiquitz'eta' c'a ri asamaj. Tiquitz'eta' c'a ri milagros ri ye'abanala'. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Roma achique c'a ri nrajo' nuk'alajirisaj-ri' chiquivech ri vinek, man ruc'amon ta c'a chi nrevaj-ri'. Can nic'atzin chi nuc'ut-ri' chi can c'o-vi ri nitiquir nuben, xecha' ri e rach'alal chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Stape' rije' can cach'alal ri Jesús, can man c'a niquinimaj ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Y c'ari' ri Jesús xubij c'a chique ri e rach'alal: Rix xabachique c'a k'ij utz yixapon chupan ri nimak'ij. Jac'a yin man que ta ri'. Yin man jani c'a utz ta richin chi yinapon. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Rix xa can man c'a yixetzelex ta coma ri vinek ri c'a quicukuban na quic'u'x riq'uin re ruvach'ulef. Jac'a yin can yinquetzelaj-vi. Yinquetzelaj roma yin can nink'alajirisaj ri itzel tak quibanobal ri yequibanala'. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Quixbiyin c'a el iyon rix. Yin xa c'a man jani yibe-el chupan re nimak'ij re'. Ri hora richin chi nink'alajirisaj-vi', can c'a man jani c'a tapon, xcha' ri Jesús chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Y tok ri Jesús rubin chic c'a ronojel re' chique ri e rach'alal, rija' can xc'oje' na vi can ri chiri' pa Galilea. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Y tok e benek chic ri e rach'alal chupan ri jun nimak'ij ri', c'ari' c'a xbe rija'. Achi'el xa pan evel c'a (pan eval c'a) ri xbe, roma man xtz'etetej ta el. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jac'a ri pa nimak'ij ri', ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, y niquetzelaj ri Jesús, yexule-yejote' chucanoxic y niquic'utula' c'a: ¿Man itz'eton ta ri jun achin ri'? yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Y chiquicojol ri vinek chupan ri nimak'ij ri', q'uiy c'a ri nibitej chirij ri Jesús. Ec'o la' niquibij chi ri nuk'alajirisaj ri Jesús, utz. Ec'o la' man que ta ri' chiquivech, xa niquibila' c'a chi ri Jesús xa yeruk'ol ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero man jun c'a chique ri vinek ri yebin queri' nuk'alajirisaj ta ri', roma niquixibij c'a qui' chiquivech ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Y jac'a tok nic'ajarinek ri nimak'ij ri', jari' tok ri Jesús xapon ri pa rachoch ri Dios ri c'o chiri' pa tinamit Jerusalem, ri acuchi najin-vi ri nimak'ij ri'. Y rija' can nutzijoj c'a ri ruch'abel ri Dios chiquivech ri vinek ri quimolon-qui' chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ri achi'a' c'a ri can c'o-vi quik'ij chiquicojol ri israelitas, niquibij c'a chirij ri Jesús: ¿Achique c'a roma chi re achin re' can janíla etamabel riq'uin chirij ri ruch'abel ri Dios y xa man jun bey xkatz'et chi najin ta chiretamaxic? yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pero ri Jesús xubij: Re tijonic re ninya', can ja ri takayon-pe vichin ri chilabeyon-pe chuve. Re' can man vichin ta c'a yin. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Y ri vinek ri can c'o rayibel riq'uin richin nuben ri nrajo' ri Dios, ri vinek ri' can xtretamaj c'a, vi ri tijonic ri ninya' yin can riq'uin ri Dios petenek-vi o xa nuyon nutz'ucun-el. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Achique c'a vinek ri ruyon rija' nuk'alajirisaj-ri', can nrajo' c'a chi ri vinek niquiya' ta ruk'ij. Jac'a yin ninvajo' chi rix niya' ta ruk'ij-ruc'ojlen ri Dios ri takayon-pe vichin. Y romari' nik'alajin chi yin can ja ri kitzij ninben y man jun bey ninben ta ri man utz ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Rix can nicanoj c'a achique rubanic niben richin yinicamisaj. Xa can man niben ta c'a ri achique nubij ri ley richin ri Moisés, y re ley re' xa can pan ik'a' c'o-vi, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Y ri vinek xquibij c'a: Xa xach'ujer la'. ¿Achique c'a ri najovan nicamisan avichin? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pero ri Jesús xubij c'a chique: Rix can achique la xuna' ri ivánima tok xitz'et chi yin pa jun k'ij richin uxlanen xinc'achojirisaj ri jun achin. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Y ri Moisés tok xuya' ri ley xubij c'a chi tiban ri circuncisión chique ri alabon. Pero xa man ja ta c'a rija' ri xtiquiriban-pe, xa ja ri ojer tak kati't-kamama' ri xetiquiriban-pe. Y romari' rix, tok napon ri vakxaki' k'ij talex jun ac'ual ti ala', stape' pa jun k'ij richin uxlanen, can niben-vi c'a ri circuncisión chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Rix nibij chi man nivajo' ta nixolk'otij (nixalk'atuj) ri nubij chupan ri ley ri ruyo'on can ri Moisés, y stape' pa jun k'ij richin uxlanen rix can niben-vi ri circuncisión. ¿Y achique roma tok xpe ivoyoval chuve yin roma xinc'achojirisaj jun achin chupan jun k'ij richin uxlanen? ");
INSERT INTO cakCNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Man c'a tibij chi man utz ta ri nubanobal, xaxe roma queri' nik'alajin chivech rix. Xa can tivetamaj na c'a jebel, vi queri' o man que ta ri'; richin queri' man quixsach, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Y ec'o c'a chique ri vinek aj chiri' pa tinamit Jerusalem ri niquibila' c'a: ¿Man ja ta cami c'a ri Jesús ri nicanox richin nicamisex? ");
INSERT INTO cakCNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pero rija' xa man revan ta ri'. Titzu' c'a la', rija' nich'on chiquivech la vinek y man jun nibin ta chire chi man tuben chic quela'. Riq'uin juba' ri achi'a' ri can c'o-vi quik'ij ri ec'o chikacojol xa xquitz'et yan chi can ja vi rija' ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero can nik'alajin c'a chi xa man ja ta rija' ri Cristo, roma xa can ketaman c'a acuchi tipe-vi. Y tok xtoka' ri kitzij Cristo, xa man c'a xtik'alajin ta acuchi xtipe-vi, yecha' ri vinek aj-Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Y ri Jesús nich'on c'a chiquivech ri vinek ri chiri' pa rachoch ri Dios. Y riq'uin c'a ruchuk'a' xch'on y xubij: Rix can ivetaman-vi nuvech y ivetaman chuka' acuchi quipe-vi. Jac'a ri takayon-pe vichin man c'a ivetaman ta ruvech, y rija' can kitzij. Man c'a nuyon ta yin xinben chi xipe chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yin can vetaman-vi c'a ruvech ri man ivetaman ta ruvech rix, roma can riq'uin rija' in petenek-vi; y can ja chuka' rija' ri takayon-pe vichin, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Y can ec'o c'a ri xe'ajovan chi xquichop ta, pero man xquichop ta el roma ri hora richin ri Jesús man jani c'a tapon. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","E janíla c'a e q'uiy chique ri vinek ri xeniman richin ri Jesús chupan ri k'ij ri'. Ri vinek c'a ri' niquibij chi ja rija' ri Cristo, roma ri milagros man jun chic c'a nibanon. Xaxe c'a vi can ja ri Cristo, nitiquir nuben, xecha' rije'. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Y ri achi'a' fariseos xcac'axaj c'a chi queri' ri yequibila' ri vinek chirij ri Jesús. Romari' ri achi'a' fariseos y ri principal-i' tak sacerdotes, xequitek c'a el achi'a' e chajinela' chuchapic. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jac'ari' tok xubij ri Jesús: C'a c'o na juba' tiempo ri yic'oje-el iviq'uin. C'ari' xquitzolin riq'uin ri achique takayon-pe vichin. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Rix xquinicanoj c'a, y man xquinivil ta chic; roma ri lugar ri xquibec'oje-vi yin, man xquixtiquir ta xquixapon chinucanoxic, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Y ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, niquibila' c'a chiquivech: ¿Acuchi cami c'a xtibe-vi re Jesús re'? Roma nubij chi chiri' man xtekila' ta chic pe. ¿Nibe cami c'a pa ch'aka' chic ruvach'ulef richin nerutzijoj ri ruch'abel chique ri kavinak israelitas y chique ri man e israelitas ta? ");
INSERT INTO cakCNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Can man c'a ketaman ta acuchi xtibe-vi, roma man ketaman ta achique nic'ulun-vi chi tzij tok xubij: Xquinicanoj y man xquinivil ta. Ri lugar ri xquibec'oje-vi yin, man xquixtiquir ta xquixapon rix, yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chupan c'a ri nimalej k'ij y ruq'uisibel richin ri jun semana nimak'ij ri', ri Jesús pa'el tok riq'uin c'a ruchuk'a' xubij: Vi c'o c'a jun ri nichaki'j ruchi' (nichakchi'in) ri ránima, tipe c'a viq'uin yin, richin nich'uch'u-el ránima riq'uin ri Ya' ri xtinya-el chire yin. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ri can xtipe c'a viq'uin yin richin yirunimaj, can xtic'oje' c'a ri Ya' richin c'aslen pa ránima, y ri Ya' ri' can achi'el c'a ri nuben ri ya' pa ralaxibel, queri' xtuben pa ruc'aslen. Queri' ri nubij chupan ri ruch'abel ri Dios ri tz'ibatel can. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Re Ya' c'a ri xunataj ri Jesús, jac'a ri Lok'olej Espíritu; roma can jac'ari' ri xtiquic'ul ri vinek ri yeniman richin ri Jesús. Y ri k'ij c'a ri' c'a man jani tika-pe ri Lok'olej Espíritu, roma c'a man jani chuka' titzolej-el ri Jesús chila' chicaj richin chi can nik'alajin chi rija' can c'o-vi ruk'ij-ruc'ojlen. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Y ec'o c'a chique ri vinek, tok xcac'axaj-ka ri ch'abel ri xerubij ri Jesús, xquibij c'a: Can kitzij vi chi re Jesús jare' ri rusamajel ri Dios ri nik'alajirisan ri ruch'abel, ri q'uiy yan tiempo oyoben-pe. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Y ec'o chuka' la' niquibij: Ja ri Jesús jari' ri Cristo. Pero ec'o chic c'a ch'aka' ri niquibij: Ri Cristo man pa Galilea ta nipe-vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Roma ri ruch'abel ri Dios ri tz'ibatel can nubij chi ri Cristo riy-rumam ri rey David. Y ri chiri' pa Belén ri tinamit ri xalex-vi ri David, chiri' c'o chi nipe-vi, yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Can man junan ta c'a ri quich'obonic chirij ri Cristo; roma xa jun vi nubij la jun y jun vi chic nubij la jun. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Y ec'o c'a ch'aka' chic chique ri vinek, can xcajo' c'a chi xquichop ta el ri Jesús, pero xa man xquiben ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jac'a tok ri achi'a' chajinela', ri e takon-el coma ri principal-i' tak sacerdotes y coma ri achi'a' fariseos, xetzolin; xbix c'a chique: ¿Achique c'a roma tok man xichop ta pe ri Jesús? xe'uche'ex. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pero ri achi'a' chajinela' ri' xquibij: Roj man c'a xkachop ta pe, roma ri ch'abel ri yerubij man jun chic c'a achin ri biyon ta. Can yalan c'a jebel, xecha' rije'. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","C'ari' ri achi'a' fariseos xquibij c'a chique ri achi'a' chajinela': ¿Rix chuka' xixk'olotej-pe? ");
INSERT INTO cakCNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Nitz'et ta cami c'a rix chi ec'o ta chique ri achi'a' ri pa comon yek'aton tzij y ri fariseos chi quiniman ta ri nubij ri Jesús? ");
INSERT INTO cakCNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Xa ja ri vinek ri man jun quetaman chire ri ley ri ruyo'on can ri Moisés, xa jac'ari' ri yeniman richin. Ja ta nika' ruc'ayeval pa quivi' re vinek re'. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pero ri Nicodemo ri achin ri xa chak'a' xapon riq'uin ri Jesús, xubij c'a chique ri can e rachibil: ");
INSERT INTO cakCNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","¿Utz ta cami chuvech ri ka-ley chi nibix chi jun achin c'o rumac, y xa man etaman ta, ni man ac'axan ta chuka' chire vi kitzij chi c'o mac rubanon o xa man jun? ");
INSERT INTO cakCNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Y rije' xquibij c'a chire ri Nicodemo: Rat ni man at aj-Galilea ta, richin queri' nato' ri Jesús. Tanic'oj na pe' jebel ri ruch'abel ri Dios tz'ibatel can. Chiri', can nik'alajin-vi c'a chi ri pa Galilea man nic'ulun ta c'a pe jun achin k'alajirisey richin ri nibix chire roma ri Dios, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Y c'ari' ri achi'a' ri quimolon-qui', xquitaluj-el-qui' y xebe chi tak cachoch. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ri Jesús xbe c'a el pa ruvi' ri juyu' rubini'an Olivos. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Y nimak'a' yan, rija' xapon chic ri pa rachoch ri Dios. Ri vinek xe'apon c'a riq'uin. Y tz'uyul tok nubij ruch'abel ri Dios chique ri vinek ri quimolon-apo-qui' chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Y ri achi'a' fariseos y ri etamanela' chirij ri ley xe'apon c'a riq'uin ri Jesús; quic'uan-apo jun ixok ri nimacun riq'uin jun achin ri xbe'ilitej-pe. Xbequipaba' chuvech ri Jesús, pa quinic'ajal. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ri fariseos y ri etamanela' ri' xquibij c'a chire ri Jesús: Tijonel, xecha' rije'. Re jun ixok re kapaban chavech, nimacun riq'uin jun achin ri xilitej-pe. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Chupan ri ley ri ruyo'on can ri Moisés, nubij chi ri yebanon quere', quecamisex chi abej. ¿Achique c'a nabij rat? ¿Utz o man utz ta nikacamisaj chi abej re jun ixok re'? xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ri achi'a' ri' queri' xquibij xaxe richin niquitejtobej ri Jesús; richin queri' yetiquir yesujun chirij. Pero ri Jesús xa xluque-ka, y c'o c'a xerutz'ibaj-ka pan ulef riq'uin ri ruvi-ruk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Y roma c'a ri achi'a' ri' can janíla c'a niquic'utula-apo chire ri Jesús, vi nicamisex o man nicamisex ta re ixok re', rija' xbepa'e' c'a pe y xubij: Ri man jun bey c'a kajinek pa jun mac, tuchapa' c'a ruc'akic re ixok, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Y ri Jesús xluque' chic c'a ka jun bey y xuchop chic c'a tz'ibanic jun bey, riq'uin ri ruvi-ruk'a', ri chiri' pan ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tok ri sujunela' chirij ri ixok xcac'axaj c'a ri xubij ri Jesús, ri cánima xubij chique chi rije' chuka' e aj-maqui'; y xe'eleyaj c'a el ri chiri'. Xenabeyej-el ri rijita'k, y c'ari' xebe ri más c'a e ac'uala'. Xa can xe chic c'a ri ixok ri xc'oje' can, roma ri e sujunela' chirij xa xebe yan. Ri ixok pa'el c'a can ri chiri' acuchi xbequipaba-vi chuvech ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Y tok ri Jesús xbepa'e' chic pe, xutz'et c'a chi xaxe chic ri ixok ri pa'el can chiri'. Romari' xuc'utuj c'a chire ri ixok ri': ¿Y ri vinek ri e c'amayon-pe avichin? ¿Man jun xc'oje-ka richin yarucamisaj? xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Y ri ixok ri' xubij: Ajaf, man jun chic c'o can, xcha'. Y ri Jesús xubij c'a chire: Yin chuka' man ninbij ta chi yacamisex. Vacami c'a catzolin y man chic camacun. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tok ri Jesús xch'on chic c'a jun bey chiquivech ri vinek, xubij c'a: Ja yin ri yisakirisan quic'aslen ri vinek ri ec'o chuvech re ruvach'ulef. Ri nitzekelben c'a vichin, can xtinsakirisaj c'a y xtril ruc'aslen viq'uin. Y rija' man chic c'a xtibiyin ta pa k'eku'n. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","C'ari' ri achi'a' fariseos ri ec'o c'a chiri', xquibij-apo chire ri Jesús: Roj man nikanimaj ta chi kitzij ri nabij chavij, roma xa ja rat ri yabin. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pero ri Jesús xubij c'a chique ri achi'a' fariseos: Stape' xa ja yin ri yik'alajirisan-ka vichin, can kitzij vi c'a ri nink'alajirisaj-ka chuvij. Roma chinuvech yin k'alaj ri acuchi yin petenek-vi, y can chiri' c'a chuka' xquitzolin-vi. Jac'a rix man ivetaman ta acuchi quipe-vi, ni man ivetaman ta c'a chuka' acuchi xquibe-vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Rix can iyon c'a nibanala-ka ik'atbel-tzij. Jac'a yin man que ta ri' ninben. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Y vi yin ninben jun k'atbel-tzij, can pa ruchojmilal c'a nel-vi; roma can man nuyon ta yin, xa can vachibilan-vi c'a ri Nata' ri takayon-pe vichin. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chupan ri ley ri can ivichin ibanon-ka chire, nubij c'a chi tok ec'o e ca'i' ri can junan ri niquibij, can nik'alajin c'a chi kitzij ri niquibij. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Y yin y ri Nata' ri takayon-pe vichin, junan ri nikabij, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ri achi'a' fariseos xquibij c'a chire ri Jesús: ¿Acuchi c'a c'o-vi ri Atata'? xecha' chire. Y ri Jesús xubij c'a: Rix man ivetaman ta ruvech ri Nata', roma man ivetaman ta nuvech yin. Vi ta ivetaman nuvech yin, can ivetaman ta chuka' ruvech ri Nata'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Y jac'a ch'abel re' ri xerubij ri Jesús chique ri vinek ri quimolon-qui' ri acuchi neyalox-vi can mero coma ri vinek ri chiri' pa rachoch ri Dios. Y man riq'uin xerubila' ch'abel queri', man jun ri xpe ta chuchapic, roma ri ru-hora man jani c'a tapon. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Y jun bey chic, ri Jesús xubij c'a chique: Yin can xquitzolin-vi c'a, y tok rix c'ari' xquinicanoj, man c'a xquinivil ta. Xa can chupan c'a ri imac xquixquen-vi (xquixcom-vi). Y ri acuchi yibe-vi yin, rix man yixtiquir ta yixapon, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Y jac'ari' tok ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, niquibila' c'a chiquivech: ¿Xtucamisaj cami c'a ri' ri Jesús? Roma nubij: Ri acuchi xquibe-vi yin, rix man c'a yixtiquir ta yixapon, nicha', yecha' ri achi'a' ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pero ri Jesús xubij c'a chique: Rix can ix aj vave' ka y yin in aj chila' chicaj. Can ix richin vi re ruvach'ulef y yin man que ta ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Y can romari' xinbij c'a chive chi chupan ri imac yixquen-vi (yixcom-vi). Y vi xa man ninimaj ta ri achique c'a yin, can xquixquen na vi (xquixcom na vi) chupan ri imac, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","C'ari' ri achi'a' ri' xquibij chic c'a chire ri Jesús: ¿At achique ta c'a rat? Y ri Jesús xubij chique: Yin, can jac'a tok nuchapon-pe tzij iviq'uin, can jac'ari' tok nubin-pe chive ri achique yin. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Can q'uiy c'a ri c'o chi ninbij chivij, roma ri itzel ibanobal. Pero ri ninbij c'a chive rix y chique conojel vinek, xaxe c'a ri vac'axan-pe riq'uin ri takayon-pe vichin, y rija' can kitzij vi, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero rije' man xk'ax ta chiquivech ri xbix chique roma ri Jesús, romari' man xquetamaj ta chi chirij ri Tata'ixel nich'on-vi rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ri Jesús xubij chic c'a: Ri k'ij c'a tok xquinijotoba' chuva ri cruz yin ri xinalex chi'icojol, c'a jac'ari' tok xtivetamaj ri achique c'a yin. Y xtivetamaj chuka' chi ronojel ri ninben yin, xa man pa nuyonil ta. Xa can achi'el ri rubin-pe ri Nata' chuve yin, can que c'a chuka' ri' ninbij yin chive. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ri Nata' ri takayon-pe vichin, can c'o viq'uin. Man c'a yiruya' ta can nuyon, roma yin can ninben-vi ri nika' chuvech, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Y roma c'a re tzij re xerutzijola' ri Jesús chiquivech ri vinek, e q'uiy c'a ri xeniman richin. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","C'ari' ri Jesús xubij c'a chique ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas ri xeniman richin: Vi rix can jebel ruc'uaxic niben chire ri nuch'abel, can xquixoc c'a kitzij tak tzekelbey vichin. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Xtivetamaj c'a chuka' achique ri kitzij; y ri kitzij xtuben c'a chive chi yixel libre. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Y ri vinek ri' xquibij c'a: Roj can oj riy-rumam can ri Abraham, y romari' man xojc'oje' ta chuxe' quitzij ch'aka' chic, achi'el ta oj lok'on tak ajic'a'. ¿Achique c'a roma tok nabij chike chi xkojcolotej-el? ");
INSERT INTO cakCNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Pero ri Jesús xubij chique: Tivac'axaj na pe' jebel re xtinbij chive vacami: Conojel c'a vinek ri yemacun, can nik'alajin chi chuxe' rutzij ri mac ec'o-vi y jari' ri uc'uayon quichin. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Y vi jun vinek chuxe' rutzij ri mac c'o-vi, man xtic'oje' ta riq'uin ri Dios. Jac'a ri jun ri can ralc'ual vi ri Dios, can xtic'oje-vi riq'uin richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Romari' vi yin ri Ruc'ajol ri Dios yicolon ivichin, can kitzij vi chi colotajic ri xtivil. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Y chinuvech yin, ri nibij rix chi ix riy-rumam can ri Abraham, can queri' vi, xa jac'a ri ibanobal man nuc'ut ta chi queri'; roma rix xa nicanola' achique c'a rubanic niben richin yinicamisaj. Re' nuc'ut c'a chi rix man iyo'on ta k'ij chire ri nuch'abel chi oquinek ta ri pa tak ivánima. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ronojel c'a ri nintzijoj yin, can jac'a ri Nata' c'utuyun-pe chinuvech. Y can que c'a chuka' ri' rix. Xaxe chic c'a rix riq'uin ri jun ri oquinek itata', riq'uin rija' nivac'axaj ronojel ri yixajin chubanic. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Y rije' xquibij c'a chire ri Jesús: Ri Abraham jari' ri katata' roj, xecha'. Y ri Jesús xubij chique: Can ta ix riy-rumam can ri Abraham, nik'alajin ta, roma ja ta ri utz tak banobel ri xerubanala' rija', ja ta chuka' ri' ri ye'ibanala' rix. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero rix man que ta ri' niben. Rix xa nicanoj achique rubanic niben richin yinicamisaj yin ri nintzijoj ri kitzij chive; kitzij ri vac'axan-pe riq'uin ri Dios. Ri Abraham man c'a xuben ta achi'el ri niben rix, y rix nibij chi ix riy-rumam can rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Rix xa can jac'a ri nuben ri jun ri oquinek itata', xa jari' ri niben, xcha' ri Jesús chique. Y rije' xquibij c'a chire: Roj can ketaman ruvech ri xojalc'ualan. Xa can xe c'a Jun ri Katata', y ri' ja ri Dios, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","C'ari' ri Jesús xubij c'a chique ri vinek ri': Can ta ja ri Dios ri Itata', can ta nik'alajin, roma yinivajo' ta y yinic'ul ta jebel; roma yin can riq'uin ri Dios in petenek y in kajinek-vi-pe. Can ja vi c'a ri Dios ri takayon-pe vichin y man pa nuyonil ta yin chi xipe chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Achique c'a roma tok rix man nivajo' ta chi nik'ax chivech ri ninbij chive? Roma xa can man nika' ta chivech. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ri itata' rix xa can ja ri itzel-vinek y can ix richin c'a rija'; y ja ri nika' chuvech rija', jari' ri yixajin chubanic. Ri itzel-vinek can ja ri pa rutiquiribel tiquirinek-vi-pe richin nicamisan. Man c'a xc'oje' ta chic chupan ri kitzij, roma xa can man jun c'a kitzij ri c'o ta riq'uin. Xa can jun tz'ucuy-tzij vi. Can quitata' c'a conojel tz'ucuy tak tzij. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Y yin man c'a yininimaj ta roma can ja ri kitzij ri ninbij chive. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿C'o cami c'a jun ri nibin-pe chuve vacami achique mac e nubanalon? Y vi can jebel nik'alajin chi man jun mac pa nuc'aslen y can ruyon kitzij ri ninbij, ¿achique c'a roma tok man yininimaj ta? ");
INSERT INTO cakCNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Roma ri can richin chic c'a ri Dios, can ja ri nubij ri ruch'abel ri Dios ri nuben. Jac'a rix man que ta ri' niben, roma man ix richin ta ri Dios, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Y ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, xquibij c'a chire ri Jesús: Can kitzij vi c'a ri kabin chavij chi rat xa at jun vinek ri tipe pa Samaria y c'o itzel espíritu aviq'uin, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Pero ri Jesús xubij c'a chique ri achi'a' ri': Yin man jun itzel espíritu ri c'o ta viq'uin. Yin can jac'a ri Nata' ri ninya' ruk'ij, y rix xa man que ta ri' chivech. Rix xa niben chuve chi in itzel. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yin man nuk'ij-nuc'ojlen ta ri nincanoj chi'icojol, pero can c'o c'a Jun ri najovan chi ronojel vinek nuya' ta nuk'ij-nuc'ojlen. Y jac'a chuka' rija' ri xtik'aton tzij pa quivi' ri man xtiquiben ta queri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Can tivac'axaj na pe' jebel re xtinbij chive: Achique c'a vinek ri can nunimaj ri nuch'abel, man c'a xtutz'et ta ri camic ri richin jantape', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Y ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas xquibij c'a chire ri Jesús: Vacami can ketaman chic c'a chi can c'o-vi itzel espíritu aviq'uin; roma nabij chi achique ri yeniman ri ach'abel, man c'a xquequen ta (xquecom ta). Tatz'eta' na pe' ri katata' Abraham y ri xek'alajirisan ri ruch'abel ri Dios ojer can, xequen (xecom). ");
INSERT INTO cakCNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Más ta cami ak'ij rat que chuvech ri katata' Abraham? Rija' xa xquen (xcom), y que chuka' ri' ri xek'alajirisan ri ruch'abel ri Dios ojer can, xequen (xecom). ¿At achique ta c'a rat? Roma nabij chi ri yeniman ri ach'abel man xquequen ta (xquecom ta). ");
INSERT INTO cakCNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Y ri Jesús xubij: Vi nuyon c'a yin ninya' nuk'ij-nuc'ojlen, xa man jun c'a nic'atzin-vi. Pero ri nuk'ij-nuc'ojlen yin, can jac'a ri Nata' niyo'on. Ri Nata' jac'ari' ri nibij i-Dios chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Y stape' rix queri' nibij chire, man ivetaman ta ruvech. Jac'a yin can vetaman-vi ruvech. Y xa yinoc c'a jun tz'ucuy-tzij achi'el rix, vi ta ninbij chi man vetaman ta ruvech ri Dios, y xa can vetaman. Yin can ninben-vi c'a ri nubij ri ruch'abel rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ri Abraham can janíla c'a xquicot ránima, roma can c'o c'a chi nutz'et can ri k'ij vichin yin. Y rija' can xutz'et-vi, y janíla xquicot ránima romari', xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jari' tok ri achi'a' ri can c'o quik'ij chiquicojol ri israelitas xquibij chire ri Jesús: Rat nabij chi atz'eton chic ri katata' Abraham, pero rat xa c'a at ac'ual na. Xa c'a man jani nak'i-el nic'aj ciento ajuna'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Pero ri Jesús xubij chique ri achi'a' ri': Can kitzij c'a ninbij chive chi yin can inc'o-vi-pe. Can inc'o-vi-pe tok man jani rutzijol chi nalex ri Abraham, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Y ri achi'a' ri' can jac'ari' xbequisiq'uila-pe abej richin yequiq'uek chirij. Pero ri Jesús xel c'a pe ri chiri' pa rachoch ri Dios. Chiquicojol c'a ri vinek xrevala-pe-ri', xel-pe. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ri Jesús nik'ax c'a el acuchi c'o-vi jun achin moy pa ralaxic. Ri Jesús can xutz'et c'a ri jun achin ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Y ri tijoxela' xquic'utuj c'a chire ri Jesús: Ajaf, ¿achique c'a ri xmacun richin quere' xalex re achin re'? ¿Ja ri rute-rutata' o ja rija'? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Pero ri Jesús xubij: Man jun c'a chique ta rije' ri xmacun, richin quere' xuc'ulvachij re jun achin re'. Ni rija' ni ri rute-rutata'. Rija' can que c'a re' pa ralaxic, richin chi nik'alajin ta ri rusamaj ri Dios riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Pak'ij, can utz vi chi niban samaj. Jac'a tok noc-pe ri ak'a', conojel man utz ta chic yesamej. Y can que c'a chuka' ri' yin, vacami nic'atzin richin ninben ri samaj ri ruchilaben-pe chuve ri takayon-pe vichin; roma tok man xquic'oje' ta chic, man chic xquitiquir ta xtinben re samaj re'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Y re k'ij c'a re c'a inc'o na el chuvech re ruvach'ulef, jac'a yin ri yisakirisan ruc'aslen ronojel vinek, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tok e rubin chic c'a ka ri ch'abel ri' ri Jesús, rija' xchuban c'a ri pan ulef. Y riq'uin ri ruchub ri xka' pan ulef, xuben juba' ti ch'abek. C'ari' ri ch'abek ri' xuquil-el ri chirunak'-ruvech ri achin moy. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Y xubij chire: Vacami cabiyin c'a, y te'ach'aja' ri runak'-avech ri pan atinibel rubini'an Siloé. Re bi'aj c'a re' pa jun chic ch'abel nibix Tako'n chire. Ri achin ri' can xbe na vi, xuch'ej ri runak'-ruvech, y tok xtzolin-pe, nitzu'un chic. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","C'ari' c'a tok ri vinek ri e ru-vecinos re achin re' y ri ch'aka' chic vinek ri can e tz'eteyon richin chi moy, niquibila' c'a: ¿Man ja ta cami achin re' ri c'utuy-limosna ri katz'etelon chi tz'uyul nuc'utuj can ru-limosna? yecha' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Y ec'o c'a vinek ri yebin: Ja', ja rija'. Ch'aka' chic niquibij: Junan nitzu'un riq'uin ri achin ri'. Pero rija' can nubij c'a: Ja'. Ja yin ri' ri tz'uyul ninc'utuj can limosna chique ri vinek, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Y ri vinek niquic'utuj c'a chire ri achin ri': Re rubanon-pe xa man yatzu'un ta. ¿Achique c'a rubanic xban aviq'uin richin chi yatzu'un chic re vacami? xecha' c'a chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ri achin xubij chique: Ri jun achin rubini'an Jesús xuben juba' ti ch'abek y jari' ri xuquil ri chirunak'-nuvech, y c'ari' xubij chuve: Cabiyin y te'ach'aja' ri runak'-avech ri pa Siloé. Y yin can xibe-vi; xinch'ej ri runak'-nuvech y jari' tok xitzu'un. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pero ri vinek xquic'utuj chire: ¿Acuchi c'a c'o-vi ri Jesús vacami? xecha'. Y rija' xubij: Man vetaman ta, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Y ri vinek xquic'uaj c'a el ri achin moy tok rubanon can, c'a chiquivech ri achi'a' fariseos. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ri k'ij c'a tok ri Jesús xuben ri juba' ti ch'abek y xuben chire ri achin moy chi nitzu'un, pa jun c'a k'ij richin uxlanen. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tok ri achin, ri moy rubanon can, c'o chic c'a apo chiquivech ri achi'a' fariseos, ri achi'a' ri' xquic'utuj c'a chire chi achique rubanic xban chire richin vacami nitzu'un chic. Y rija' xubij: Ri xbanon c'a chuve richin yitzu'un chic, xuquil c'a juba' ti ch'abek chirunak'-nuvech, xinch'ej, y jare' yitzu'un chic, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Y ec'o c'a achi'a' fariseos ri xquibij: Ri achin ri rubini'an Jesús man riq'uin ta ri Dios petenek-vi; roma can man nuchajij ta juba' ri k'ij ri richin uxlanen, yecha'. Pero ec'o c'a ch'aka' chic fariseos ri xquibij: ¿Can nitiquir ta cami yeruben milagros jun achin aj-mac, achi'el xuben ri Jesús riq'uin ri achin moy? Ri achi'a' fariseos ri' man junan ta c'a ri quich'obonic chirij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","C'ari' ri achi'a' fariseos xquic'utuj c'a chire ri achin, ri moy tok rubanon can: ¿Achique chi achin ri Jesús nach'ob rat? Ri can xuben chave chi yatzu'un. Y ri achin ri' xubij: Yin ninch'ob chi ri Jesús k'alajirisey richin ri nibix chire roma ri Dios, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jac'a ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, man niquinimaj ta c'a chi ri achin ri' can moy vi tok xalex. Romari' man niquinimaj ta chuka' chi jun milagro ri xbanon chi nitzu'un vacami. Can xecoyoj na c'a ri rute-rutata' ri achin ri nitzu'un chic vacami. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Y ri achi'a' ri' xquic'utuj c'a chique ri rute-rutata' ri achin: ¿Ja ivalc'ual re', ri nibij chi can moy pa ralaxic? Vi can moy c'a tok xalex, ¿achique c'a roma tok nitzu'un vacami? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Y ri rute-rutata' ri achin xquibij c'a chique ri achi'a' ri': Ja', ja kalc'ual re' y moy vi pa ralaxic. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jac'a ri man ketaman ta roj, ja ri achique rubanic xuben richin nitzu'un chic vacami. Y vi c'o jun ri xbanon chire richin nitzu'un chic re vacami, man ketaman ta roj. Tic'utuj c'a chire rija'; roma xa can c'o chic c'a rujuna', y nitiquir nubij chive ri achique xbanatej, xecha' rije'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Que c'a ri' ri xquik'alajirisaj ri rute-rutata' ri achin, chique ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, roma quixibin c'a qui' chiquivech. Ri achi'a' ri c'o quik'ij, can quelesan chic c'a rutzijol chi xabachique vinek ri xtibin chi ri Jesús jari' ri Cristo, can nokotex c'a pe chupan ri jay ri niquimol-vi-qui' richin nicac'axaj ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Xa romari' tok ri rute-rutata' ri achin ri nitzu'un chic, xaxe c'a xquibij chi tiquic'utuj chire rija', roma xa can c'o chic rujuna'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Y ri achi'a' ri' xcoyoj chic c'a jun bey ri achin ri nitzu'un chic, y xquibij chire: Ja ri Dios taya' ruk'ij-ruc'ojlen. Roj ketaman chi ri achin rubini'an Jesús, jun achin aj-mac, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Y ri achin xubij c'a chique ri achi'a' ri': Yin man c'a vetaman ta vi ri Jesús jun aj-mac o man aj-mac ta. Ri vetaman yin chirij rija', jac'a chi xiruc'achojirisaj; roma tok rubanon can man c'a yitzu'un ta, y vacami yitzu'un chic, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Y ri achi'a' ri' xquic'utuj chic c'a chire ri achin: ¿Achique ri xeruben chave richin queri' xuben chave chi xatiquir xatzu'un? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Rija' xubij c'a chique ri achi'a' ri': Pero ri' xintzijoj yan c'a chive y xa man xinivac'axaj ta. ¿Achique c'a roma tok vacami rix nivajo' chi yin nincamuluj chic rubixic chive? ¿Nivajo' c'a nivojkaj ri Jesús? xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pero ri achi'a' ri' xyacatej c'a coyoval y xquibij: Ja rat sí can at jun vi ojkey richin rija', jac'a roj can oj ojkey richin ri Moisés. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Roj can ketaman-vi c'a chi ri Moisés can xch'on-vi ri Dios riq'uin, jac'a re Jesús re' man ketaman ta acuchi tipe-vi, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Y ri achin xch'on-apo chique y xubij c'a: Jac'are' ri nibanon chuve yin chi can janíla ninch'ob rij, roma rix can man ivetaman ta acuchi nipe-vi, pero viq'uin yin xuben jun milagro, roma vacami yitzu'un chic. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Can nik'alajin-vi chi ri Jesús man aj-mac ta, roma ketaman chi ri Dios man nuben ta ri niquic'utuj ri aj-maqui' chire. Pero ri jun ri can nuya-vi ruk'ij ri Dios y can nuben chuka' ri nrajo' ri Dios, can nac'axex-vi roma ri Dios, y nibanatej ri nuc'utuj. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Can man jun bey c'a tz'eton o ac'axan ta chi c'o ta jun ri nibanon chire jun ri can moy vi pa ralaxic richin nitzu'un ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Y vi ta ri achin rubini'an Jesús man ta riq'uin ri Dios petenek-vi, man ta xtiquir xuben ri milagro viq'uin yin, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pero ri achi'a' ri' xquibij chire ri achin ri nitzu'un chic: Rat can at aj-mac pe pan avalaxic, ¿y navajo' yojatijoj roj? xecha'. Y xquelesaj c'a pe ri achin ri', ri chiri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ri Jesús xrac'axaj c'a chi ri achin ri' xelesex-pe. Romari' xberucanoj, y tok xril, xubij c'a chire: ¿Nacukuba' cami ac'u'x rat riq'uin ri Ruc'ajol ri Dios? xcha' ri Jesús chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Y ri achin ri nitzu'un chic xubij c'a chire ri Jesús: Yin ninvajo' nincukuba' nuc'u'x riq'uin ri Ruc'ajol ri Dios, xa jac'a ri man vetaman ta achique ri'. Tabij c'a chuve, xcha' ri achin. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Y ri Jesús xubij c'a chire: Rat can atz'eton chic c'a ri Ruc'ajol ri Dios. Ja yin ri Ruc'ajol ri Dios. Jac'a yin ri yich'on aviq'uin, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ri achin can jac'ari' xubij: Ajaf, yin yatinnimaj. Y ri achin can xuya' ruk'ij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Y ri Jesús xubij: Yin xipe c'a chuvech re ruvach'ulef chiquitz'etic ri vinek achique quibanon, vi utz o man utz ta. Y ninben c'a chique ri vinek ri man nitzu'un ta cánima, chi titzu'un. Jac'a ri niquina' chi nitzu'un ri cánima, xa tik'ekumer c'a chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Y ec'o c'a achi'a' fariseos ri ec'o-apo chiri' acuchi c'o-vi ri Jesús, tok xcac'axaj ri', xquibij: ¿Oj moyirinek c'a chuka' roj? ");
INSERT INTO cakCNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Y ri Jesús xubij chique: Vi ta ix moyi', jebel ta, roma man jun ta mac nivejkalej. Xa roma c'a rix nibij chi man ix moyi' ta, xa romari' tok ri imac can c'o-vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Y tivac'axaj na pe' jebel re xtinbij chive: Ri quicoral ri carne'l can c'o c'a jun ruchi'. Y ri man c'a nucusan ta ri ruchi' ri coral richin noc-apo y xa nuropij; ri nibanon c'a queri' jun elek'on y jun chapoy quichin vinek pa tak bey richin c'o nrelesaj can chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jac'a ri nucusan ri ruchi' ri coral richin noc-apo, ri' can ja vi ri' ri aj-yuk' quichin ri carne'l. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Y ri chajinel quichin ri carne'l nujek c'a pe ri ruchi' ri coral chuvech, y ri carne'l can quetaman chic ri ruch'abel ri caj-yuk'. Rija' yeroyoj chiquijujunal riq'uin ri quibi' y yerelesaj c'a el. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tok ri aj-yuk' e relesan chic c'a el conojel ri rucarne'l, ninabeyej c'a el chiquivech y ri carne'l yetzeke-el chirij. Ri carne'l can que vi ri' niquiben, roma can quetaman c'a ruch'abel ri niyuk'un quichin. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Jac'a ri man quetaman ta ruvech, man xtiquitzekelbej ta. Xa ye'anmej chuvech, roma man quetaman ta ri ruch'abel; ch'abel ri xa man jun bey cac'axan ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ri Jesús jun c'ambel c'a tzij ri xubij chique ri achi'a' fariseos, jac'a rije' man xk'ax ta chiquivech achique ri xubij chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","C'ari' ri Jesús xch'on chic jun bey y xubij chique ri achi'a' fariseos ri': Tivac'axaj c'a jebel re xtinbij chive: Ja yin ri Ruchi' ri coral ri acuchi ye'oc-apo ri tak carne'l. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Y e q'uiy c'a ri xec'oje' yan nabey que chinuvech yin y xquibij chi e takon-pe roma ri Dios, pero xa man que ta ri', xa e junan quiq'uin ri elek'oma' y e junan quiq'uin ri yechapon vinek pa tak bey richin c'o niquelesaj can chique. Matiox c'a chi man xetzekelbex ta coma ri tak carne'l ri e vichin yin. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ja yin c'a ri Ruchi' ri coral. Ri xtoc c'a viq'uin yin, can xticolotej y nril ronojel ri nic'atzin chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Jun elek'on tok napon, can xe c'a richin nerubana-pe elek' y nicamisan can. Can ronojel c'a ri nuben can, man pa rubeyal ta. Jac'a yin, nicha' ri Jesús, xipe richin ninya' ri c'ac'a' c'aslen; jun utzilej c'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Y jac'a yin ri utzilej Aj-Yuk'. Ri utzilej Aj-Yuk', can nuya-vi ruc'aslen coma ri rucarne'l. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jac'a ri xa man kitzij aj-yuk' ta, ri xa niyuk'un roma tojon y man rajaf ta chuka' ri carne'l; ri' tok nutz'et c'a chi nipe ri utif, xa ja rija' ri nucol-el-ri' nabey y yerumalij can ri carne'l ri yeruyuk'uj. Y ri utif yeruc'uaj c'a ri carne'l, y ri ch'aka' chic yetalutej-el. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ri man c'a kitzij aj-yuk' ta, ri xa tojon, nanmej. Y queri' nuben roma xa man c'a rajaf ta ri carne'l. Man jun c'a pena chire rija' vi c'o niquic'ulvachij ri carne'l. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Jac'a yin ri utzilej Aj-Yuk', y vetaman quivech ri carne'l ri can e vichin yin, y rije' can quetaman c'a chuka' nuvech yin. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Can que c'a chuka' ri' nubanon yin riq'uin ri Nata'. Rija' retaman nuvech yin, y yin vetaman ruvech rija'. Yin ninya' c'a nuc'aslen coma ri nucarne'l. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Y yin man xe ta c'a nucarne'l re' ec'o, xa can ec'o c'a chuka' ch'aka' chic ri man jani ec'o ta vave' chupan re jun coral re'. Can xquenq'uen c'a pe y xticac'axaj chuka' ri nuch'abel. Can xtic'oje-vi c'a jun kitzij Aj-Yuk' y jun li'aj rucarne'l. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ri Nata' Dios can yirajo-vi c'a. Can nika' c'a chuvech chi yin ninya' ri nuc'aslen coma ri nucarne'l, y chuka' roma ri nic'oje' chic c'a el nuc'aslen jun bey. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ri nuc'aslen yin, can man jun c'a xtelesan, xa c'a ja na yin ri yiyo'on. Can pa nuk'a' c'a yin c'o-vi richin chi ninya' y pa nuk'a' chuka' yin c'o-vi richin nic'oje' chic el nuc'aslen jun bey. Que c'a ri' ri rubin-pe ri Nata' chuve, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Y jari' tok xjalajo' chic jun bey chiquivech ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas, roma ri ch'abel ri xerubij ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","E q'uiy chique rije' ri xquibij chirij ri Jesús: Xa ch'ujirinek la'. Xa itzel espíritu ri c'o riq'uin, y rix can ninimaj-ka ri nubij. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jac'a ri ch'aka' chic xquibij: Jun ri c'o itzel espíritu riq'uin, man nitiquir ta nubij utzilej tak ch'abel achi'el ri xerubij-ka ri Jesús. ¿Nitiquir ta cami chuka' jun ri c'o itzel espíritu riq'uin chi nuben chire jun moy chi nitzu'un chic jun bey? yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Y pa ru-tiempo c'a ri tef, jari' tok niban ri nimak'ij rubini'an Dedicación; nimak'ij richin niquinatabej ri k'ij tok xch'ajch'ojirisex ri rachoch ri Dios ri c'o chiri' pa tinamit Jerusalem. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Y ri Jesús c'o c'a apo chupan ri rachoch ri Dios. Y pa jun corredor ri rubini'an Richin ri Salomón, chiri' c'a c'o-vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ri achi'a' ri can c'o quik'ij chiquicojol ri israelitas xe'apon riq'uin ri Jesús, xquisurij rij (xquisutij rij), y c'ari' xquibij c'a chire: ¿Achique c'a roma tok man jun bey navajo' nak'alajirisaj-avi' chikavech? Vi can jac'a rat ri Cristo, tabij c'a chike. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Y ri Jesús xubij c'a chique ri achi'a' ri': Nubin chic c'a chive y man iniman ta. Y ronojel ri samaj ri yenben, can pa rubi' c'a ri Nata' Dios yenben-vi. Y ri samaj ri' can nuk'alajirisaj-vi c'a ri achique yin. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Xa jac'a rix can man yininimaj ta vi, roma rix xa man ix nucarne'l ta; can achi'el vi c'a ri xinbij yan chive. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ri nucarne'l yin can quetaman y nicac'axaj ri nuch'abel, y can yinquitzekelbej chuka'. Yin vetaman c'a chuka' quivech rije'. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Man c'a xquesach ta can, xa can xtiquil-vi quic'aslen ri man q'uisel ta, viq'uin yin. Ni man jun c'a chuka' ri xtitiquir xque'elesan-el pa nuk'a'. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Y chuka' can pa ruk'a' c'a ri Nata' Dios ec'o-vi, roma ja rija' ri xcha'on quichin. Y rija' jari' ri más nim ruk'ij que chuvech xabachique. ¿Can c'o ta cami c'a jun ri nitiquir yerelesaj-el pa ruk'a' rija'? Man jun. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yin vachibilan ri Nata', can jun c'a kabanon riq'uin, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Y jac'ari' tok ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas xebequisiq'uila' chic c'a pe abej chirij ri Jesús, richin niquicamisaj chi abej. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero ri Jesús xubij c'a chique ri achi'a' ri': Can q'uiy c'a utzilej tak samaj ri e nubanalon chivech, roma ri uchuk'a' ri ruyo'on-pe ri Nata' chuve. ¿Achique c'a chique ri utzilej tak samaj ri nubanon ri man nika' ta chivech, y romari' nivajo' yinicamisaj chi abej? xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","y ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas xquibij chire ri Jesús: Roj man yatkaq'uek ta chi abej roma jun utzilej samaj. Roj yatkaq'uek chi abej roma nabij chi at junan riq'uin ri Dios. Roma jun achin ri nibin queri', xa nuyok' rubi' ri Dios, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Pero ri Jesús xubij c'a chique: Chupan ri ley ri can ivichin ibanon-ka chire, ri Dios nubij c'a: Yin nubin chi ivonojel rix can ix dios chuka'. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Can ketaman c'a chi man jun bey yojtiquir ta nikabij chi ri nubij ri ruch'abel ri Dios man kitzij ta. Rija' can xubij dios chique ri achok che xuya-vi ri ruch'abel. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Vi queri' xubij ri Dios, ¿achique c'a roma rix nibij chi yin xinyok' rubi' ri Dios roma xinbij chi ja yin ri Ruc'ajol ri Dios? Y yin can xirucha' c'a ri Dios richin xirutek-pe chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Y vi man ninben ta c'a ri ruchilaben-pe ri Nata' Dios chi ninben yin, can man c'a quininimaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Jac'a vi can ninben ri ruchilaben-pe ri Dios chuve, quininimaj romari'; stape' man yininimaj ta roma ri nubin chive. Tinimaj, richin chi tivetamaj chi ri Nata' Dios can c'o-vi c'a viq'uin y yin chuka' queri' nubanon riq'uin rija', xcha' ri Jesús chique ri achi'a' ri can c'o-vi quik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Can janíla c'a xcajo' ri achi'a' ri' chi xquichop ta el ri Jesús, pero xa man xetiquir ta chic jun bey; roma xa xbe chiquivech. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Y ri Jesús xk'ax chic apo juc'an ruchi' raken-ya' Jordán y xc'oje' c'a ka q'uiy k'ij ri chiri'; ri acuchi xuben-vi bautizar ri Juan ri Bautista, pa nabey. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Y e janíla c'a e q'uiy vinek xe'apon riq'uin ri Jesús, ri chiri'. Y ri vinek ri' niquibila' c'a: Ri Juan ri Bautista can kitzij vi chi man jun milagro ri xuben richin chi xuk'alajirisaj-ri' chi takon-pe roma ri Dios, pero ronojel c'a ri tzij ri xerubij can chirij re achin re', can kitzij vi, yecha' c'a ri vinek ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y e q'uiy c'a vinek ri xeniman richin ri Jesús chupan ri jun lugar ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Chupan c'a ri ti tinamit rubini'an Betania ri quitinamit ri María y ri Marta ri rach'alal, c'o c'a jun yava'. Ri yava' ri' rubini'an c'a Lázaro. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Re María re', jac'are' ri xyo'on jubulej ak'on chirij ri raken ri Ajaf Jesús y xerusu' riq'uin ri rusmal tak ruvi'. Xa ruxibal c'a rija' ri Lázaro, ri yava'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Y ri María y ri Marta ri e rana' ri Lázaro, xquitek c'a rubixic chire ri Jesús: Ajaf, vacami c'a nikaya' rutzijol chave chi ri kaxibal Lázaro, ri janíla navajo' rat, yava'. Kajinek c'a pa varabel. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Y tok ri Jesús xrac'axaj c'a ri takon-el rubixic chire, rija' xubij: Ri Lázaro yava', roma nic'atzin c'a chi nik'alajin ri ruchuk'a' ri Dios. Ri yabil c'a ri noc chire, man c'a xtitiquir ta xtuc'uaj pa camic. Xa can xtik'alajin na c'a ri ruchuk'a' ri Dios, richin queri' yin ri Ruc'ajol ri Dios xtinc'ul ta c'a nuk'ij-nuc'ojlen, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ri Jesús can janíla c'a nrajo' ri Marta, chuka' ri María ri rach'alal, y ri Lázaro. Can che oxi' janíla c'a yerajo'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Y tok rija' xrac'axaj chi ri Lázaro c'o yabil chapayon richin, c'a pa rox c'a k'ij xbe chutz'etic, roma c'a xc'oje' na chic ca'i' k'ij chupan ri lugar ri c'o-vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Y jac'a tok ic'ovinek chic ri ca'i' k'ij, ri Jesús xubij chique ri rutijoxela': Vacami kojtzolin c'a pa Judea, xcha' chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Y ri rutijoxela' xquibij c'a chire: Tijonel, xecha' c'a chire. Xa c'are' c'a can ri' tok ri achi'a' ri can c'o-vi quik'ij re chikacojol roj israelitas quic'ualon chic abej chavij richin yatquicamisaj. ¿Can navajo' c'a chi yatzolin chila' vacami? xecha' ri tijoxela' chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Pero ri Jesús xubij chique: Ri k'ij ruc'uan c'a cablajuj horas. Ri nibiyaj pak'ij, man c'a xtupajq'uila' ta (xtuchek'ila' ta) raken, roma can c'o ri sakirisayon richin re ruvach'ulef. Can ronojel vi c'a nutz'et roma ri sakil ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Jac'a ri nibiyaj pa k'eku'n, can nupajq'uila-vi (nuchek'ila-vi) ri raken; roma xa manek ri sakil pa ruvi'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Y tok ri Jesús rubin chic ka ronojel re', xch'on chic jun bey chique ri rutijoxela' y xubij: Ri Lázaro ri ketaman ruvech, niver. Roma c'a ri' jare' yibe chuc'asoxic, xcha' chique ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Y jari' tok ri rutijoxela' xquibij chire: Ajaf, vi ri Lázaro xa niver, xa xtic'achoj, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Y ri Jesús xa chirij ajc'a ri rucamic ri Lázaro xch'on-vi tok xubij chi niver, pero ri rutijoxela' xk'ax chiquivech chi can varan vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","C'ari' ri Jesús can jebel c'a k'alaj ri xubij chique. Rija' xubij c'a: Ri Lázaro xquen (xcom). ");
INSERT INTO cakCNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Y can janíla c'a yiquicot, xcha' ri Jesús, roma man pa Betania ta inc'o-vi tok xquen (xcom) ri Lázaro, richin queri' c'o k'ij chive rix richin chi más nicuker ic'u'x. Vacami jo' c'a pa Betania, acuchi c'o-vi ri Lázaro, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jac'a ri tijoxel ri rubini'an Tomás, y nibix chuka' Dídimo chire; rija' xubij c'a chique ri tijoxela' ri can e rachibil vi: Jo' c'a chirij ri Jesús, richin chi vi rija' xticamisex, can jac'a chuka' ri' tikac'ulvachij roj, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Y ri Jesús y ri rutijoxela' xe'apon c'a pa Betania. Ri k'ij c'a tok xe'apon rije', caji' yan k'ij tic'oje' ri caminek pa jul. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ri tinamit Betania man nej ta nicanej-vi can chire ri tinamit Jerusalem. Ri quicojol xa juba' ruvi' nic'aj legua. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Y e q'uiy c'a achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas ri xepe chiri' y xe'apon chiquik'ejeloxic (chiquik'ijaloxic) ri Marta y ri María, roma ri rucamic ri quixibal Lázaro. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tok ri Marta xapon c'a rutzijol riq'uin chi petenek ri Jesús, junanin xel-el richin xbe chuc'ulic. Y ri María man c'a xunabej ta, xa xc'oje' can ri chiri' pa jay. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Y ri Marta tok xapon c'a riq'uin ri Jesús, rija' xubij chire: Ajaf, ri nuxibal xquen (xcom). Xa ta vave' atc'o-vi, c'a q'ues ta re vacami. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero yin vetaman chi ri xtac'utuj chire ri Dios vacami, ri Dios can xtuya-vi chave, xcha' ri Marta chire ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jac'ari' tok ri Jesús xubij chire ri Marta: Ri axibal Lázaro xtic'astej, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Y ri Marta xubij chire ri Jesús: Ja', yin can vetaman chi xtic'astej; roma tok xtapon ri ruq'uisibel k'ij, conojel c'a ri caminaki' xquec'astej, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ri Jesús xubij c'a chire ri Marta: Yin can yitiquir-vi yenc'asoj ri e caminek chic el, y can yitiquir-vi ninya' c'aslen. Romari' ri niniman vichin, man jun rubanon vi caminek chic, roma xtic'oje' ruc'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Xabachique c'a vinek ri c'a c'o na ruc'aslen chuvech re ruvach'ulef y yirunimaj yin, man c'a xtapon ta chupan ri camic ri can richin jantape'. ¿Nanimaj c'a re'? xcha' ri Jesús chire ri Marta. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Y ri Marta xubij chire ri Jesús: Ja', Ajaf. Can ninnimaj c'a ronojel ri nabij; roma can vetaman-vi chi ja rat ri Cristo ri Ruc'ajol ri Dios, ri can c'o-vi c'a chi nipe na chuvech re ruvach'ulef, xcha' ri Marta. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tok ri Marta rubin chic c'a can re ch'abel re' chire ri Jesús, xbe chiroyoxic ri María ri rach'alal. Y tok xapon c'a, ri Marta xubij pa ruxiquin ri María: Ri Ajaf xoka' y vacami yaroyoj, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ri María, can xe c'a xrac'axaj-el queri', can jari' xyacatej-el ri acuchi tz'uyul-vi y junanin xbe. Rija' xbe c'a acuchi c'o-vi ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ri Jesús can c'a man jani c'a toc-apo chupan ri ti tinamit Betania, xa can c'a c'o na ri acuchi xbec'ul-vi roma ri Marta. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Y ri vinek israelitas ri ec'o chiri' pa jay, ri yek'ejelon (yek'ijalon) richin ri María, tok xquitz'et chi junanin xyacatej, xel-el y xbe; ri vinek ri' junanin chuka' xquitzekelbej-el, roma rije' xquich'ob chi ri María nibe chuchi-jul richin nrok'ej ri ruxibal. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jac'a tok ri María xapon acuchi c'o-vi ri Jesús y xutz'et, xxuque-ka chiraken y xubij chire: Ajaf, ri nuxibal xquen (xcom). Xa ta vave' atc'o-vi, man ta caminek vacami, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jac'a tok ri Jesús xutz'et chi ri María nok' y que chuka' ri' ye'ok' conojel ri quivinak israelitas ri xe'apon k'ejelonel (k'ijalonel) richin ri María, ri ránima ri Jesús jun vi xuben xuna' rija' y xpe c'a bis riq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Y c'ari' c'a xuc'utuj: ¿Acuchi ximuk-vi ri Lázaro? xcha'. Y rije' xquibij: Ajaf, jo' y nekac'utu' c'a chavech acuchi xkamuk-vi, xecha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Y ri Jesús xok'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jac'ari' tok ri vinek israelitas ri k'ejeloy (k'ijaloy) quichin ri Marta y ri María, xquibila' c'a: Titzu' la Jesús, nrok'ej ri Lázaro. Nik'alajin chi can janíla xrajo', xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","C'ari' ec'o c'a chique ri vinek ri' xquibila' c'a chirij ri Jesús: Rija' can xtiquir c'a xuben chire ri moy richin xtzu'un. ¿Man ta cami c'a xtiquir ta xuben chire ri Lázaro chi man ta xquen (xcom)? xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tok ri Jesús xapon c'a chuchi' ri jul, xtzolin chic c'a pe ri bis riq'uin. Ri jul ri mukul-vi can ri Lázaro, jun jul ri c'oton chuvech jun juyu', y tz'apel can ruchi' riq'uin jun abej. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Y jac'ari' tok ri Jesús xubij: Tivelesaj la abej tz'apebel ruchi' la jul, xcha' rija'. Jac'a ri Marta, ri rana' can ri Lázaro ri xquen-el (xcom-el), xubij chire ri Jesús: Ajaf, can caji' yan c'a k'ij ri'. Xa petenek chic ruchuvirinen ninch'ob yin, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero ri Jesús xubij chire ri Marta: Yin can nubin chic c'a chave chi vi xtanimaj, can xtatz'et c'a ri nuben ri ruchuk'a' ri Dios, xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Y jari' tok xquelesaj c'a ri abej tz'apebel ruchi' ri jul acuchi c'o-vi ri caminek. C'ari' ri Jesús xtzu'un c'a chicaj y xubij: Nata', matiox ninya' chave, roma can xinavac'axaj c'a pe. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yin vetaman chi can jantape' vi yinavac'axaj. Y ronojel c'a re', can ninbij coma re vinek re quimolon-pe-qui' viq'uin vacami, richin chi tiquinimaj chi can ja rat ri xatakon-pe vichin chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tok ri Jesús rubin chic c'a ka re ch'abel re', can riq'uin c'a ronojel ruchuk'a' xch'on y xubij: Lázaro, cayacatej y catel c'a pe, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Y ri Lázaro, ri caminek chic el, xbe'el-pe. Ri ruk'a-raken ri caminek, jebel c'a biron-el (baron-el) pa tak tziek, y ri ruvech tz'apel c'a el riq'uin jun xax tziek. C'ari' ri Jesús xubij: Que'isolo' can la tziek chirij, richin chi utz nibiyin y nitiquir nitzolin-el, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Y e q'uiy c'a vinek israelitas k'ejeloy (k'ijaloy) richin ri María, xquinimaj ri Jesús tok xquitz'et ri xuben, chi xuc'asoj ri caminek. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero ec'o ch'aka' ri xebe quiq'uin ri achi'a' fariseos y xbequitzijoj chique ri achique ri xuben ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Y can ja yan c'a ri' ri principal-i' tak sacerdotes y ri achi'a' fariseos xquimol-qui' y xecoyoj chuka' ri ch'aka' chic achi'a' ri junan yek'aton tzij quiq'uin, y xquibij chique: ¿Achique c'a nikaben? Roma ri achin rubini'an Jesús ruchapon samaj y q'uiy milagros ri yerubanala' chiquivech ri vinek richin tiquinimaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Y vi can xtikaya' c'a k'ij chire, can conojel c'a ri vinek xqueniman richin. Y tok xtiquinabej-pe ri vinek romanos, xtoquivulaj can ri jay ri acuchi nikaya-vi ruk'ij ri Dios y xkojquiq'uis chuka' can roj ri ojc'o chupan re ruvach'ulef re', yecha' c'a rije'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","C'ari' c'o jun ri xch'on. Ri xch'on jac'a ri Caifás ri nimalej sacerdote chupan ri tiempo ri'. Rija' c'o c'a ri chiri', roma rija' jun chique ri can c'o-vi quik'ij. Y tok rija' xch'on, xubij c'a: Xa man jun ivetaman rix. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Can man nich'ob ta c'a juba' chi xa más utz chike roj chi xaxe ri jun niquen (nicom) pa kaq'uexel konojel y mani yojquen (yojcom) konojel xaxe roma ri jun ri', xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ri Caifás tok xch'on y xubij queri', man can ta ja ri runojibal rija' ri xrucusaj; man que ta ri'. Ri ch'abel ri xerubij rija', can jac'a ri Dios ri xyo'on-pe chire. Roma can jac'a rija' ri nimalej ru-sacerdote ri Dios ri tiempo ri', romari' ri Dios xuya' c'a k'ij chire richin chi xubij yan chi ri Jesús c'o c'a chi niquen na (nicom na) pa quiq'uexel ri vinek richin ri ruvach'ulef ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y ri Jesús can man xe ta c'a pa quiq'uexel ri vinek richin ri ruvach'ulef ri' tok xtiquen (xticom), xa can xtiquen c'a (xticom c'a) richin yerumol conojel ri vinek ri can e ralc'ual vi ri Dios ri e talutajinek chuvech re ruvach'ulef. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Y can jac'a k'ij ri' tok ri achi'a' ri can c'o quik'ij, xquiya' yan can chiquivech chi xtiquicamisaj ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Roma c'a ri', ri Jesús man chic xtz'et ta coma ri achi'a' ri can c'o-vi quik'ij chiquicojol ri israelitas. Rija' xa xbe c'a pa jun chic tinamit. Xbe pa jun tinamit ri rubini'an Efraín, y ri tinamit c'a ri' chunakaj apo ri tz'iran ruvach'ulef c'o-vi. Y xc'oje' c'a ka chiri' e rachibilan ri rutijoxela'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Y jac'ari' tok napon yan ri k'ij richin ri pascua, ri jun quinimak'ij ri israelitas. Romari' can janíla yan c'a e q'uiy vinek ri xe'el-pe pa tak quitinamit, richin xebe pa tinamit Jerusalem. Can xebe yan c'a roma c'o chi nequich'ajch'ojirisaj-qui' chuvech ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Y ri vinek niquicanola' c'a ri Jesús. Rije' e pa'el chupan ri rachoch ri Dios y niquic'utula' c'a chiquivech: ¿Achique c'a nich'ob rix? ¿Xtipe cami chupan re nimak'ij? yecha' c'a ri vinek ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jac'a ri principal-i' tak sacerdotes y ri achi'a' fariseos, can quelesan chic c'a rutzijol chi xabachique c'a vinek ri xtetaman ta acuchi c'o-vi ri Jesús, tubij chique rije', richin chi niquichop. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tok xa vaki' chic c'a k'ij nrajo' richin man napon ri k'ij richin ri nimak'ij rubini'an pascua, ri Jesús xbe pa tinamit Betania, ri rutinamit ri jun achin rubini'an Lázaro; ri Lázaro ri xquen-el (xcom-el) y xbec'asox-pe chiquicojol caminaki' roma ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Y ri chiri' xban c'a jun nima-va'in, roma xapon ri Jesús. Y jac'a ri Marta ri ye'ilin-apo ri pa mesa. Ri Lázaro jun c'a chique ri e tz'uyul-apo ri pa mesa riq'uin ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Xpe ri María ri rach'alal ri Marta y rana' ri Lázaro, xberuc'ama' c'a pe jun libra jubulej ak'on rubini'an nardo; jun jubulej ak'on ri janíla jotol rajel. Y jac'are' ri xuya' chirij raken ri Jesús y xerusula' can riq'uin ri rusmal tak ruvi' rija'. Y ri jay ri' can xnoj c'a riq'uin ri rujubulil ri ak'on ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Y c'o c'a jun chique ri tijoxela' ri man xka' ta chuvech chi queri' xban chire ri jubulej ak'on, y ri' ja ri Judas Iscariote ri ruc'ajol ri jun achin rubini'an Simón; ri tijoxel ri xtic'ayin na richin ri Jesús. Rija' xubij c'a: ");
INSERT INTO cakCNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Achique roma tok xa man xc'ayix ta re jubulej ak'on re'? Re ak'on re' xa xbe ta chi oxi' ciento quetzales, y re mero re' xtalux ta chique ri vinek ri man jun c'o quiq'uin, xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tok rija' xubij queri', man roma ta c'a chi can janíla ta yerajo' ri vinek ri man jun c'o quiq'uin, y nrajo' ta yeruto', man que ta ri'. Xa roma c'a chi ja rija' ri yacol-mero y c'o c'a nrelesala-el, xa romari'. Rija' xa can nelek' c'a. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Can jac'ari' tok ri Jesús xubij chire ri Judas: Man chic c'a jun tabij. Taya' can re xten re' chi tubana' na ri nrajo' ri ránima. Stape' man jani yiquen (yicom) richin yimuk, pero can vichin yin ruyacon-pe re ak'on re'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Roma ri vinek ri man jun c'o quiq'uin, can jantape' c'a ec'o iviq'uin richin chi xabachique k'ij niben utzil chique. Jac'a yin man jantape' ta xquic'oje' iviq'uin, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tok ri Jesús xnabex c'a pe coma ri ruvinak israelitas chi c'o pa Betania, xepe. Y can janíla c'a vinek ri xepe. Conojel c'a ri vinek ri' xepe roma ri Jesús y richin chuka' chi niquitz'et can ri Lázaro, ri xc'asox-pe roma ri Jesús chiquicojol ri caminaki'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Romari' ri principal-i' tak sacerdotes xquiya' chiquivech chi chuka' ri Lázaro xtiquicamisaj rachibilan ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Roma chirij ri Lázaro xquiya-vi chi janíla e q'uiy quivinak israelitas ri yeyo'on can quichin rije' y niquinimaj-el ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pa ruca'n k'ij, ri chiri' pa tinamit Jerusalem, can e janíla c'a e q'uiy vinek. Conojel c'a ri' quic'ulun-qui' chiri' roma ri nimak'ij. Y tok xcac'axaj c'a chi benek-apo ri Jesús, ");
INSERT INTO cakCNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","e quic'uan ruk'a' tak che' ri nibix palma chire, xebe chuc'ulic y niquibila' c'a: ¡Matiox chi petenek re Jun re'! ¡Jare' ri ka-Rey roj israelitas! ¡Can urtisan-pe roma ri Ajaf Dios, y pa rubi' ri Ajaf Dios petenek-vi! yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Y ri Jesús can c'o c'a jun alaj burro ri xril, richin chi xuch'ocolbej. Can achi'el vi c'a ri nubij chupan ri ruch'abel ri Dios ri tz'ibatel can, chiri' nubij: ");
INSERT INTO cakCNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Man c'a tuxibij-ri' ri ivánima rix ri ix richin chic ri tinamit rubini'an Sión; roma ri i-Rey jac'are' petenek, ch'ocol-pe chirij jun alaj burro. Que c'a ri' ri tz'ibatel can. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Y pa nabey, ronojel re' man c'a xk'ax ta chiquivech ri rutijoxela'. Y xk'ax chiquivech can c'a ja tok ri Jesús c'astajinek chic el chiquicojol ri caminaki' y c'o chic ruk'ij-ruc'ojlen. C'ari' c'a tok xoka' chiquic'u'x chi ronojel re' can tz'ibatajinek can; chi can c'o na c'a chi xtibanatej, y can queri' vi; roma can achi'el ri tz'ibatel can, can queri' xbanatej. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Y ri vinek c'a ri xetz'eton richin ri Jesús tok xroyoj ri Lázaro ri caminek chic el richin xc'astej-pe chiquicojol ri caminaki', can niquitzijola' c'a chique ri ch'aka' chic vinek. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Y roma c'a ri', tok ri Jesús nakaj chic c'o-vi chire ri tinamit Jerusalem, can xepe c'a richin noquic'ulu'. Ri vinek ri' can cac'axan chic c'a ri milagro ri xuben riq'uin ri Lázaro. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jac'a ri achi'a' fariseos niquibila' c'a chiquivech: Titzu', conojel ri vinek e benek chirij. Man c'a niquinimaj ta katzij, yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Y chiquicojol c'a conojel ri vinek ri e apovinek pa tinamit Jerusalem chupan ri k'ij ri', richin niquiya' ruk'ij ri Dios chupan ri nimak'ij ri', ec'o chuka' e ca'i-oxi' vinek griegos. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Re ca'i-oxi' c'a vinek re', xe'apon-apo riq'uin ri Felipe ri nipe pa Betsaida ri c'o pa Galilea, richin niquic'utuj jun utzil chire; roma rija' jun rutijoxel ri Jesús. Ri vinek ri' xquibij c'a chire: Roj nikajo' yojch'on juba' riq'uin ri Jesús, xecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ri Felipe xbe y xberubij c'a chire ri Andrés ri can tijoxel chuka'. C'ari' che ca'i' xebe-apo c'a riq'uin ri Jesús y xquibij chire: Ec'o ca'i-oxi' vinek griegos ri nicajo' yech'on aviq'uin. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Y ri Jesús can jac'ari' xubij chique ri ca'i' tijoxela' ri': Ja k'ij re' xoka', richin chi yin ri xinalex chi'icojol xtic'oje' nuk'ij-nuc'ojlen y xquitzolin-el chila' chicaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Y tivac'axaj c'a re xtinbij chive re vacami, chi can kitzij vi: Vi nikapokonaj nikatic-ka jun ti ruvech-trigo pan ulef, ri ti ruvech-trigo ri' xa choj c'a queri' xtic'oje'. Jac'a vi man nikapokonaj ta nikatic-ka, stape' xtic'oje' can chuxe' ulef ri ti ruvech-trigo ri', xtel-pe y xtuya' ruvech. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Roma c'a ri', ri vinek ri yalan nupokonaj ri ruc'aslen re vave' chuvech re ruvach'ulef, man xtril ta ruc'aslen richin jantape'. Jac'a ri man nupokonaj ta ri ruc'aslen voma yin, can richin c'a jantape' nuyec-apo. Can nic'oje-vi ruc'aslen richin jantape'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Vi can c'o c'a jun ri nrajo' nuben ri nusamaj, tipe c'a viq'uin. Y ri acuchi c'a inc'o-vi yin, can chiri' c'a chuka' xtic'oje-vi rija'. Ri can xtibanon c'a ri nusamaj, xtinimirisex c'a ruk'ij roma ri Nata'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yin can janíla c'a nik'axon ri vánima vacami. ¿Pero xtinbij ta c'a chire ri Nata': Quinacolo' chuvech re k'axomal re'? Tok xa can romari' xinoka'. Romari' tok c'a inc'o vacami. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","C'ari' rija' xubij c'a: Nata', can tabana' c'a chi nik'alajin ta ri ak'ij-ac'ojlen, xcha'. Y can jac'ari' tok ri Dios xch'on-pe chila' chicaj y xubij: Can nubanon chic c'a queri'. Y xtinben chic c'a jun bey, chi can nik'alajin-vi ri nuk'ij-nuc'ojlen. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Y e janíla c'a chique ri vinek ri ec'o chiri' ri xebin chi xa jun cokolajay ri xcac'axaj tok xch'on-pe ri Dios chila' chicaj. Jac'a ri ch'aka' chic niquibij: Jun ángel ri xch'on-pe chire, yecha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Y ri Jesús xubij c'a chique: Ri Jun c'a ri xivac'axaj chi xch'on-pe chila' chicaj, xch'on-pe ivoma rix y man voma ta yin. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vacami noka' yan c'a ri ruk'atoj-tzij ri Dios chuvech re ruvach'ulef, y ri itzel-vinek ri chapayon re ruvach'ulef, can xtelesex c'a el. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Y tok yin xquijotobex chuvech ri cruz, ri vinek can xquepe c'a viq'uin yin; roma can xquisamej pa tak cánima, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ri Jesús xubij c'a queri', richin xuk'alajirisaj c'a ri rubanic ri rucamic. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Y ri vinek xquibij c'a: Rat abin chi ja rat ri' ri Jun ri xalex chikacojol, pero xa nabij chuka' chi xcajotobex chuvech ri cruz. Can man nik'ax ta c'a chikavech achique romari'. Roma roj ketaman ri nubij chupan ri ruch'abel ri Dios chi ri Cristo tok xtipe, xtic'oje' richin jantape'. Can tak'alajirisaj c'a chikavech vi ri xalex chikacojol, can jari' ri Cristo o man ja ta, xecha' rije'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jac'ari' tok ri Jesús xubij chique: Ri Sakil can c'a c'o na juba' iviq'uin. Can chupan c'a ri Sakil ri' quixbiyin-vi, roma c'a c'o na. Y vi xa c'a xtivoyobej na, c'a tok xtina' nik'ekumer-pe chivech; y ri xa pa k'eku'n nibiyin-vi, man retaman ta achique lugar benek-vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Romari', re k'ij tok c'a c'o na ri Sakil iviq'uin, can ticuker ic'u'x riq'uin, richin chi yixoc alc'ualaxela' richin ri Sakil ri'. Que c'a re' ri xerubij ri Jesús chique ri vinek. C'ari' xeruya' can, y man jun c'a xetaman acuchi xbe-vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ri Jesús can xerubanala-vi janíla milagros chiquivech ri vinek. Pero man riq'uin ri' rije' man xquinimaj ta. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Y que c'a re' xbanatej, roma can c'o c'a chi nibanatej na ri e tz'ibatel can. Can c'o na chi xbanatej ri rutz'iban can ri Isaías, ri jun ri xk'alajirisan ri ruch'abel ri Dios ojer can. Rija' rutz'iban c'a can: Ajaf, ¿ri ach'abel ri xkatzijoj chique ri vinek, can c'o cami c'a jun ri xniman? ¿C'o cami c'a jun ri xk'ax yan chuvech, roma xutz'et ri avuchuk'a'? Queri' nubij ri rutz'iban can ri Isaías. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Re vinek re' can man c'a tiquirel ta chi niquinimaj, roma chupan ri rutz'iban can ri Isaías nubij chuka': ");
INSERT INTO cakCNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Can banon c'a chique rije' chi man yetzu'un ta y covirinek ri cánima; romari' man niquitz'et ta ri nic'ut chiquivech, man nika' ta ka pa cánima, y man nitzolin ta pe quic'u'x richin chi yin ninchojmirisaj ri quic'aslen, nicha' ri Ajaf. Queri' ri tz'ibatel can roma ri Isaías. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ri Isaías, ri achin ri xk'alajirisan ri ruch'abel ri Dios ojer can, xubij quere' tok xutz'et yan c'a ruk'ij-ruc'ojlen ri Ajaf Jesús, y chirij c'a rija' ch'ovinek-vi can. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero chiquicojol c'a ri vinek ri xeniman richin ri Jesús, e q'uiy ri can e cachibil vi ri achi'a' ri pa comon yek'aton tzij chiquicojol ri israelitas. Xa jac'a ri man xquik'alajirisaj ta qui', roma niquixibij-qui' chiquivech ri achi'a' fariseos. Xa can niquixibij c'a qui' chi ye'okotex-pe chupan ri jay ri niquimol-vi-qui' richin nicac'axaj ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Rije' xa más c'a xquich'ob achique xtiquibij ri vinek, y man xoka' ta chiquic'u'x ri Dios ri can más ruk'ij que chiquivech ri vinek ri'. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Y ri Jesús riq'uin c'a ruchuk'a' xch'on y xubij: Ri niniman c'a vichin yin, man xe ta c'a yin ri xquirunimaj, xa can xtunimaj c'a ri Dios ri takayon-pe vichin. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ri nitz'eton vichin, can nutz'et c'a chuka' ri Dios ri takayon-pe vichin. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Roma yin ri Sakil, xipe chuvech re ruvach'ulef richin chi achique c'a ri xtiniman vichin, man xtic'oje' ta can chupan jun k'eku'n c'aslen. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Y jac'a ri vinek ri nrac'axaj ri nuch'abel y xa man nika' ta chuvech nuben ri nrac'axaj; man ja ta c'a yin ri xquik'aton tzij pa ruvi'. Roma ri nusamaj ri nuc'amon-pe tok xipe chuvech re ruvach'ulef, man richin ta chi nink'et tzij pa quivi' ri vinek. Man tich'ob queri'. Ri nusamaj c'a yin ja ri yencol ri vinek. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pero ri pa ruq'uisibel k'ij, can xtik'at na c'a tzij pa quivi' ri ye'etzelan vichin y man niquic'ul ta ri nuch'abel pa cánima. Xtik'at tzij pa quivi', roma ri ch'abel ri xenk'alajirisaj. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Roma ri ch'abel ri xenk'alajirisaj chivech, can jac'a ri Nata' biyon-pe chuve, y man xentz'ucula' ta el. Can jac'a rija' ri takayon-pe vichin y rubin c'a pe chuve achique chi ch'abel ri nonbij-nonk'alajirisaj chivech. ");
INSERT INTO cakCNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Y can vetaman c'a chi ri rubin-pe ri Nata' Dios chuve, can nuya-vi c'a c'aslen ri man q'uisel ta. Romari' re ch'abel nonbij c'a chive, can achi'el rubixic rubanon-pe ri Nata' chuve yin, queri' rubixic xonbana' chivech rix. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Y tok noka' yan ri k'ij richin ri nimak'ij rubini'an pascua, ri Jesús retaman chic c'a chi noka' yan ri hora richin chi rija' nel-el vave' chuvech re ruvach'ulef y nitzolin chila' chicaj riq'uin ri Dios, ri Rutata'. Ri Jesús can janíla vi e rajovan-pe conojel ri can e richin chic rija' ri ec'o vave' chuvech re ruvach'ulef, y can c'a que na c'a ri' ri nuben chupan ri k'ij ri', ri ruq'uisibel k'ij. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ri Jesús y ri rutijoxela' quichapon c'a va'in. Jac'a ri Judas Iscariote, ri ruc'ajol ri jun achin rubini'an Simón, nisamej chic c'a ri itzel-vinek pa ránima, y jac'ari' ri nibin chire chi tujacha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Y stape' ri Jesús can retaman-vi chi ronojel jachon pa ruk'a' roma ri Dios ri Rutata', y chiri' riq'uin ri Dios petenek-vi y chiri' chic nitzolej-vi-el; ");
INSERT INTO cakCNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","man roma ta ri' xupokonaj ta xyacatej-pe y xuya' can ri ruva'in. Man que ta ri'. Rija' xrelesaj can ri tziek ri ruk'un, xberuc'ama-pe jun toalla, y xuxim xe-rupan. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","C'ari' xuya' chuka' ya' chupan jun palangana y xuchop ruch'ajic ri caken chiquijujunal ri rutijoxela', y nusula' c'a ri caken riq'uin ri toalla ri ruximon xe-rupan. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jac'a tok xapon riq'uin ri Simón Pedro richin nuch'ej ri raken, ri Pedro xubij chire ri Jesús: Ajaf, ¿can nach'ej c'a chuka' vaken yin? xcha'. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Y ri Jesús xubij chire ri Pedro: Re ninch'ej c'a re ivaken vacami, man jani c'a nik'ax ta chivech achique roma tok ninben. Pero can xtik'ax c'a chivech, juba' chic apo. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Jac'a ri Pedro xubij: Man ruc'amon ta c'a chuve yin chi can ja rat yach'ajon re vaken. Man c'a xtinya' ta k'ij chi xtach'ej ta re vaken, xcha'. Y ri Jesús xubij c'a chire: Vi man c'a naya' ta k'ij, man c'a yac'oje' ta viq'uin, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Roma c'a ri' ri Simón Pedro xubij chire ri Jesús: Ajaf, vi queri', man c'a xaxe re vaken nach'ej, xa can tach'aja' c'a chuka' re nuk'a' y re nuvi', xcha' ri Pedro. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero ri Jesús xubij chire: Ri ruch'ajch'ojirisan chic ri', xaxe c'a ri raken ri ruc'amon chi nuch'ej, roma ri pokolaj; roma rija' can ch'ajch'oj chic. Rix can ix ch'ajch'oj chic. Stape' man chi'ivonojel ta, pero can ix ch'ajch'oj chic, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Rija' xubij c'a queri', roma can retaman achique ri xtic'ayin richin. Y romari' tok xubij: Man chi'ivonojel ta ix ch'ajch'oj. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Y tok ri Jesús ruch'ajon chic c'a caken ri rutijoxela' xberuc'ama' chic c'a pe ri tziek ri ruch'ilon can chirij, xbetz'uye' chic pa mesa y xubij c'a: ¿Xk'ax cami chivech achique roma tok yin xinch'ej ri ivaken? ");
INSERT INTO cakCNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Katijonel y Kajaf, yixcha' c'a chuve. Can utz vi c'a ri', roma can queri' vi. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Y roma yin ri Itijonel y ri Ivajaf man xiq'uix ta richin xinch'ej ri ivaken, can que c'a chuka' ri' tibana' rix. Man c'a quixq'uix nich'ajla' ivaken. Can que c'a ri' tibana'. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yin can xinc'ut yan c'a can chivech. Can achi'el c'a ri xinben yin iviq'uin, que chuka' ri' tibana' rix quiq'uin ri ch'aka' chic. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yin can c'o-vi c'a nuk'ij y xinben re samaj re'. Can que c'a chuka' re' tibana' rix. Man tipokonaj niben re samaj re'. Roma chuvech re ruvach'ulef, man ja ta c'a ri samajel ri más ruk'ij que chuvech ri rajaf ri samaj; ni ta c'a ri jun ri nitak, man ja ta chuka' ri' ri más ruk'ij que chuvech ri takayon richin. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Vi rix can xivetamaj c'a can ronojel re' y can niben c'a re xivetamaj, can jebel c'a ruva-ik'ij. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Can ninbij c'a chi man ivonojel ta queri' xquixel, roma yin can vetaman ivech chi'ivonojel ri xixincha'. Y chuka' ri tz'ibatel can, c'o c'a chi nibanatej na. Achi'el ri nubij: Ri jun c'a ri can xva' viq'uin, xyacatej c'a chuvij. Queri' nubij chupan ri ruch'abel ri Dios. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Re jun banobel re', can ninya' yan c'a apo rutzijol chive, nabey chuvech tok xtibanatej, richin queri' tok xtapon ruk'ijul, xtinimaj c'a chi can ja yin ri Cristo. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Can kitzij vi c'a ninbij chive, chi ri xtic'ulun c'a richin ri nintek-el yin, can ja yin ri yiruc'ul. Y ri xquic'ulun c'a yin, xa can xtuc'ul c'a chuka' ri takayon-pe vichin. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Y tok ri Jesús rubin chic c'a ronojel re', ri ránima can achique la xuben xuna' rija', roma ri bis. Rija' can xuk'alajirisaj c'a achique roma tok janíla bis pa ránima y xubij c'a: Can kitzij c'a ri ninbij chive, chi jun chive rix nutijoxela' ri xquijachon-el pa quik'a' ri vinek, xcha' rija'. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Can jac'ari' tok ri e rutijoxela' rija' xquitzula-qui', y man niquil ta c'a achique niquich'ob; roma man quetaman ta achok chij xch'on-vi ri Jesús. Can man c'a quetaman ta achique ri xtic'ayin richin. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jac'a ri jun chique ri rutijoxela', ri janíla najovex roma ri Jesús, rak'el c'a apo riq'uin ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Y chire c'a ri jun tijoxel ri', ri xuben-vi-apo retal ri Simón Pedro. Rija' xubij c'a apo chire chi tuc'utuj chire ri Jesús chi achique c'a ri jun ri xtic'ayin richin, ri c'ari' nubij-ka chique. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Y ri tijoxel ri' tok rak'el c'a apo chunakaj ri ruva-ruc'u'x ri Jesús, xuc'utuj c'a: Ajaf, ¿achique ri jun ri xtijachon avichin? xcha' chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ri Jesús can jac'ari' tok xubij chire ri tijoxel ri': Ri xtinya' c'a ri caxlan-vey muban chire, jac'ari' ri xtijachon vichin. Y rija' xumuba' c'a ri caxlan-vey y xuya' chire ri Judas Iscariote ri ruc'ajol jun achin rubini'an Simón. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Y tok ri Judas Iscariote ruq'uison chic c'a ka ri jucach' caxlan-vey ri', can xpe-vi c'a ri Satanás pa ránima. C'ari' ri Jesús xubij chire: Ri ach'obon chic chi naben, caniman chubanic, xcha-el chire. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jac'a ri rutijoxela' ri ec'o-apo ri pa mesa riq'uin, man xk'ax ta chiquivech achique roma tok xubij-el queri' chire ri Judas. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ec'o xech'obon chi xtak-el roma ri Jesús chulok'ic ronojel ri nic'atzin chique chupan ri nimak'ij ri'. Y ec'o chic ch'aka' chique ri tijoxela' xech'obon chi xtak-el richin c'o teruyala' can chique ri vinek ri man jun c'o quiq'uin, roma rije' can quetaman-vi chi ja ri Judas ri yacol-mero. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ri Judas xa can xe c'a tok xuq'uis-el ri jucach' caxlan-vey, xa can jac'ari' tok xel-el. Tok xel c'a el rija', xa can ch'ak'a' chic. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Y tok ri Judas elenek chic c'a el, c'ari' c'a ri Jesús xubij: Jac'are' xoka' yan ri k'ij chi yin ri xinalex chi'icojol xtik'alajin chi can c'o-vi nuk'ij-nuc'ojlen. Y can que c'a chuka' ri' ri Dios; can xtik'alajin ri ruk'ij-ruc'ojlen, voma yin. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Y roma ri Dios can xtik'alajin ri ruk'ij-ruc'ojlen, voma yin; rija' can xtuben c'a chi nik'alajin ri nuk'ij-nuc'ojlen yin. Y ri' man c'a jampe' ta, xa can ja yan c'a re k'ij re'. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Juba' chic c'a oc re yic'oje' iviq'uin rix ri can achi'el tak valc'ual nubanon chive. C'ari' xquinicanoj. Pero re vacami can ninbij c'a can chive, achi'el ri nubin chique ch'aka' kavinak israelitas, chi ri xquibec'oje-vi yin, man xquixtiquir ta xquixapon chinucanoxic. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Xa can tivajovala' c'a ivi'. Yin can yixinvajo-vi. Can que c'a chuka' ri' tibana' rix. Can tivajovala' c'a ivi' chi'ivachibil ivi'. Jac'are' ri ninbij can chive vacami, y can jun c'ac'a' pixa'. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Y vi can xtivajovala' c'a ivi' chi'ivachibil ivi', ri vinek can xtiquetamaj chi ix nutijoxela' yin, xcha' ri Jesús. ");
INSERT INTO cakCNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jac'ari' tok ri Simón Pedro xubij chire ri Jesús: Ajaf, ¿acuchi c'a yabe-vi? xcha'. Y ri Jesús xubij chire: Vacami man jani yatiquir ta yinatzekelbej ri