﻿USE sofia;
DROP TABLE IF EXISTS sofia.cafNT_vpl;
CREATE TABLE cafNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cafNT_vpl WRITE;
INSERT INTO cafNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ndi dustl'us 'uk'e'eduguz 'et ndutni, 'i be Sizi Gri 'en hube dínzut 'en 'uhínt'ah, 'i Sizi 'en David yuts'uh hainzut 'int'ah. David 'en Abraham yuts'uh hainzut 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham 'en Isaac bu'abá 'int'ah. Isaac 'en Jacob bu'abá 'int'ah. Jacob 'en Judah 'ink'ez bulhutsinkah bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah 'en ndun ts'eke Tamar 'en be Perez 'ink'ez Zerah bu'abá 'int'ah. Perez 'en Hezron bu'abá, 'ink'ez Hezron 'en Ram bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram 'en Amminadab bu'abá. Amminadab 'en Nashon bu'abá, 'ink'ez Nashon 'en Salmon bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon bu'at Rahab 'en be Boaz bu'abá. Boaz 'en Ruth 'en be Obed bu'abá. 'Ink'ez Obed 'en Jesse bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse hubudayi cho David bu'abá. 'Et hubudayi cho David, ndun Uriah bu'at inle, 'en be Solomon bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon 'en Rehoboam bu'abá. Rehoboam 'en Abijah bu'abá, 'ink'ez Abijah 'en Asa bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa 'en Jehoshaphat bu'abá. Jehoshaphat 'en Joram bu'abá, 'ink'ez Joram 'en Uzziah bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah 'en Jotham bu'abá. Jotham 'en Ahaz bu'abá, 'ink'ez Ahaz 'en Hezekiah bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah 'en Manasseh bu'abá. Manasseh 'en Amon bu'abá, 'ink'ez Amon 'en Josiah bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Hoh da wheghah whudezulh, ts'iyannah dune keyah whuti Babylon ts'ih wheoobuhanla, 'et Josiah 'en Jeconiah 'ink'ez bulhutsinkah 'en bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Keyah whuti Babylon whuz whebuhanla hukw'elh'az 'et Jeconiah 'en Shealtiel bu'abá 'int'ah. Shealtiel 'en Zurubbabel bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel 'en Abiud bu'abá. Abiud 'en Eliakim bu'abá, 'ink'ez Eliakim 'en Azor bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor 'en Zadok bu'abá. Zadok 'en Achim bu'abá, 'ink'ez Achim 'en Eliud bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud 'en Eleazor bu'abá. Eleazor 'en Matthan bu'abá, 'ink'ez Matthan 'en Jacob bu'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob 'en Joseph bu'abá 'int'ah. 'En Mary buki 'ink'ez Mary 'en be Sizi whuzdli. 'En Christ hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","'Et Abraham 'en David whuts'un, 'en ts'iyawh lanezi 'o 'at dit (14) bubé hudinde 'uhint'ah. 'Ink'ez David hoh da whudezulh hoh ts'iyannah keyah whut'en Babylon ts'ih whebuhanla whuts'un, 'en ts'iyawh lanezi 'o 'at dit (14) bubé hudinde hinli. 'Ink'ez hoh da whudezulh hoh ts'iyannah keyah Babylon ts'ih whebuhanla 'et hukw'elh'uz dich'oh bukeyah yun k'ut Judah, whuz whenáhedel, Christ 'et whuts'un, 'en ts'iyawh lanezi 'o 'at dit (14) bubé hudinde hinli ho' hint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","'Aw 'et Sizi Gri whuzdli, ndez na'a 'uhooja. 'Ama Mary 'en Joseph 'en yughu tedalh ka lhahódinla, 'ink'ez yughu tedalh whutsuh hoh 'et nahoo'ai 'uda 'uski bulh 'int'ah. Ndoni, 'i be 'uja. ");
INSERT INTO cafNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","'Et ndun Joseph 'en ts'ah'un dune unli, 'et huwa lhgho hutedukelh ts'iyannah tah yooya yoolhtselh whuch'a bubeni lhaidinla. 'Ink'ez whu'iz yuch'a natedalh hukwa' ninzun. ");
INSERT INTO cafNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","'Et howu nuni nuzut hoh 'et huwu nusúti hoh neMoodihti bulizas 'en 'uyulhni, “Joseph nyun David buts'u hainzut inli ho' 'int'ah. Wheniljut ilah Mary n'at wule. Ndun 'uski Ndoni be chainya ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","'Aw 'et 'en duneyaz tele. Nyunch'oh boozi bugha ídon'alh. Sizi dóni. 'En 'utenilh ts'iyannah lubeshi ch'a hubutelhyih.” ");
INSERT INTO cafNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","'Et ndez na'a 'uhooja, neMoodihti ndun nus whunilh'en, 'en be daja ni, 'et nduhoolcho hoh túne' whust'en. 'Et ndun nus whunilh'en ndez na'a njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Soo zulhts'ai ndun ts'eke 'aw dune t'enizun 'et whunts'ih khunyaz 'uski ba 'uja, 'ink'ez buyaz dune tele, boozi Emmanuel hiduténilh, Yak'usda nelh 'int'ah, ni ho' utni.” ");
INSERT INTO cafNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","'Et Joseph ts'enanzut hoh neMoodihti bulizas daja yulhni, hoh tune' 'ust'en 'ink'ez 'aw 'et Mary yilhchoot bu'at tele ka. ");
INSERT INTO cafNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","'Udechoo buyaz whutele t'eoonanzin 'et whuts'un 'aw yut'áchaghesnak. 'Aw 'et buye' whuzdli, 'et k'an zeh soo yughusda. 'Et boozi yugha íden'ai Sizi yulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","'Aw 'et yun k'ut Judea, keyah Bethlehem whuz'ai, 'et Sizi whuzdli. Hoh da whuz na'a Herod hubudayi cho unli hoh 'et 'uhooja. 'Aw 'et whuzdli hukw'elh'az khunyaz nda whut'en keyah Jerusalem ts'ih hunindel. 'En whunih Maji hubuhútni, 'en 'uhint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","'Ink'ez dune hoodulhkut, “Lizwif hubudayi cho k'an whuzdli, 'en nts'e whuzdli? 'Et ndi sum cho ts'a'en, 'i bugha lhuts'úzdel. 'Et huwa ndaz de ndun 'uski 'en buts'un teni' ts'untelhdzilh ka whusats'ándel.” ");
INSERT INTO cafNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","'Et whunts'ih hubudayi cho Herod whulh 'udúzts'ai hoh buba dzuh 'uhutni. Jerusalem whut'en, 'en chah whuz na'a zeh huba dzuh 'uhutni. ");
INSERT INTO cafNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","'Ink'ez ts'iyannah ba náwhulnuk hubumoodih 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz chah, 'en ts'iyawh Herod 'anih hubudani. 'Et 'en hubuts'un nahooté'alh Christ ndet whutele. ");
INSERT INTO cafNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","'Ink'ez 'uhiyulhni, “Yun k'ut Judea, keyah Bethlehem whuz'ai, 'et whutele. Nus whunilh'en 'et 'uk'e'edúguz, 'et ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yun k'ut Judea ts'ih keyah Bethlehem whut'en, 'et nuhkeyah hoontsolyaz hoonli, 'et whunts'ih tube whudezti tele. Nuhkeyah 'et whuts'un 'ilhunuh moodih ncha, 'en whusateyalh. 'Ink'ez sudune, Israel hits'uh hainde, 'en sheep ghunli k'una'a bughu tele.’ ” ");
INSERT INTO cafNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","'Et Herod whu'iz hoh dune whunih 'en 'anih hubudáni. 'En hubuts'un naooté'alh ka ndet dzin nts'oh whudezulh ndi sum be hóoduteltsilh. ");
INSERT INTO cafNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","'Et hukw'elh'az keyah Bethlehem ts'ih whebalh'a 'ink'ez ndo búlhni, “Ahdulh 'ink'ez soo cho hoh 'uski naoolhteh. 'Et nawhah'ai t'eh, nts'e 'int'ah 'et sts'ótl'a khunek wah'alh. Si chah whuz tesyalh buts'un teni' ntelhzilh ka.” ");
INSERT INTO cafNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","'Et hubudayi cho ndo búlhni hoh whehándel. Hedulh hoh khunyaz ndi sum ndaz de ts'un hitelh'en 'ink'ez hubutsuh 'ults'ulh. 'Et nts'e 'uski usda 'et bugha nduk, 'et lhghá dilts'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","'Et ndet sum hinalh'en da tube huhóont'i. ");
INSERT INTO cafNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","'Et 'ink'ez koo dahuníndel hoh 'uski hitelh'en, 'ama Mary 'en bulh. Hibut nachánelya 'ink'ez hits'un teni' nalhdzin. Huye 'úzdla, 'i hidah lhch'az hiyílhchoot hoh 'i hiyé ha'anla 'ink'ez hits'u hítelhdel. Gold, yoo sooltsun, 'i frankencense hiyulhni, 'ink'ez yoo Myrrh hiyulhni chah, 'i ts'iyawh hits'u hítelhdel. ");
INSERT INTO cafNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","'Ink'ez Yak'usda bubul be bugha dáni, 'aw Herod buk'unaoohdelh gunih hubudáni. 'Et huwa 'uts'un ts'un hubukeyah ts'ih whenáhedel. ");
INSERT INTO cafNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","'Aw 'et whenáhedel hukw'elh'az neMoodihti bulizas Joseph nute hoh beghah hódiltsai. 'Et ndi yúlhni, “Didinyaih, ndun 'uski 'ama bulh hubilhchoot 'ink'ez yun k'ut Egypt 'a ts'ih whuz hubalhtelh! 'Et nuhwhudutésnilh 'et whuts'un 'et doolhúts'i! 'Et 'áho Herod 'uski yuka it'é'ilh yutuzelhghelh ka!” ");
INSERT INTO cafNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","'Et 'ulh'ek dinadeja 'ink'ez 'uski 'ama bulh hubilhchoot 'ink'ez yun k'ut Egypt whuz whehandel. ");
INSERT INTO cafNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","'Et Herod datetsah whuts'un 'et hudutélts'ilh. 'Et ndúhut'en hoh neMoodihti ndun nus whunilh'en, 'en be daja ni 'et ndoneltsuk tune' whust'en hoh njan ndutni, “Suye' 'anih dáni yun k'ut Egypt whuch'a naooja ka.” ");
INSERT INTO cafNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","'Aw 'et Herod t'eoonanzin ndunnah whunih, Maji hiyulhni, nahina'a, 'et huwa tube hunilch'e. 'Et nts'oh huwa whezulh Maji hidáni hoh bulunah nehughan keyah Bethlehem ts'ih whebalh'a. 'Et ndo búlhni, 'et keyah whut'en ts'iyawh 'ink'ez whunat whut'en chah ndunnah duneyaz nat naoodezulh be suli 'ink'ez whuts'un whudelhdzulh chah, 'en ts'iyawh huboohghan. ");
INSERT INTO cafNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","'Et whuz na'a ndun nus whunilh'en Jeremiah hiyulhni, daja ni 'et ts'iyawh nduhóolhcho tune' whust'en hoh njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“'Et keyah Ramah hódants'o hoh tso yahalhtuk 'ink'ez hubuzkeh k'ehúnentai. Rachel buzkehyaz hubuk'etso yahalhtuk. 'Aw budzi nduk na'ootneh ghaít'ah, bubuzkehkah hoolah huzdli 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","'Aw 'et Herod dazsai hoh Egypt ts'ih neMoodihti bulizas Joseph huwunute hoh beghah níwhults'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","'Et ndi yulhni, “Didinyih! 'Uski bu'ama bulh naoobilchoot. Israel yun k'ut whuz nahdulh. 'Et whutsuh da ndunnah 'uski híkuneztai hituzelhghelh ka, 'en ts'iyawh yahadla.” ");
INSERT INTO cafNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","'Et dudinya. 'Uski bu'ama bulh nabílchoot 'ink'ez Israel yun k'ut ts'ih whenáhedel. ");
INSERT INTO cafNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","'Et whunts'ih Joseph whulh uduzts'ai Herod buye' Archelaus hiyulhni, 'en bu'abá k'edanya 'ink'ez k'an Judea yun k'ut hubudayi cho unli. 'Et whuz teyalh whénuljut hoh howu nusúti 'et Yak'usda yugha dáni. 'Et huwa Galilee yun k'ut ts'ih whuz whehándel. ");
INSERT INTO cafNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Whuz hunindel keyah Nazareth huwhútni, 'et hudutélts'ilh. 'Et whuz na'a nus whunilh'en daja hutni, hoh túne' whust'en njan nduhútni, “'En Nazareth whut'en hiduténilh.” ");
INSERT INTO cafNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","'Et whezulh hoh John dune too be 'ulh'en 'en Judea yun k'ut dune chahóot'ih ts'ih, whuz whinya 'ink'ez dune bulh yalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","'Et ndo búlhni, “Nuhwhulubeshi ch'a nuhwhubeni náhandunoohlelh. 'Aw 'et nilhdukw suli hoh ndun yak'uz k'une' whul'en, 'en nuhwhutah 'utet'ilh.” ");
INSERT INTO cafNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ndun 'en nus whunilh'en Isaiah yughu yalhtuk hoh njan ndutni, “Dune chahóot'ih ts'ih dune yiz dusduts'ai soo 'ultus hahuyih hoh njan ndutni, ‘NeMoodihti buti lhaoodahleh! Buti soo lhts'odez'a buba whulhtsi.’ ” ");
INSERT INTO cafNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","'Ink'ez John dich'oh khunai bugha, camel hiyulhni, 'i ye dune unli 'ink'ez 'ukulh se be sudelhú'oo. Tulk'us cho 'ink'ez honey, 'i ya'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","'Et hoh da dune ts'iyawh ndunnah Jerusalem whut'en, Judea yun k'ut whut'en, 'ink'ez dune 'et took'oh Jordan whut'en, 'en ts'iyawh John highu nindel. ");
INSERT INTO cafNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","'Ink'ez bulubeshi hubugha hunahuwhélnuk hoh 'et nyo 'et took'oh Jordan, John 'en too be' balh'en. ");
INSERT INTO cafNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","'Et whunts'ih lhanah Pharisee 'ink'ez Sadducee chah, 'en too be' hutelnilh ka highu nindel. 'Et hubunilh'en hoh ndo búlhni, “Nuhwheni poison tl'ughus buzkehkah lí'aht'ah! Ndan 'ún whulhni Yak'usda huntelch'oh whuch'a lhúwus? ");
INSERT INTO cafNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lubeshi ch'a nuhwheni nahandunihla t'eh, ndaht'en ts'iyannah t'ehonóozin ndaht'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","'Ink'ez khun teh na'dudoohtni gunih, nuwheni Abraham buts'u hats'ánde 'uts'int'ah. Ts'ah'un na'a 'ún whudusni Yak'usda soo 'ultus ho' 'int'ah, tse be 'i whunts'ih Abraham buts'u hahánde hubutelhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nuhwheni duchun lí'aht'ah. 'Aw 'et tsetsilh lhadínt'ah. Duchun bumai hoolah, bughih tubulh tsuhídantsel 'ink'ez hidutélhk'un. ");
INSERT INTO cafNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nuhwheni nahunduníhla 'et huwa too zai be too be' nuhwhúsdla. 'Et whunts'ih sk'elh'az ndun whusatéyalh, 'en sughanus dezti ho' 'int'ah. 'Aw bukegwun buba nutésdle huba soo cha'lhúdzooh. Ndun Ndoni 'ink'ez kwun bulh 'i be too be' nuhwhutelh'ilh. ");
INSERT INTO cafNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Be tl'onuldzeh 'i tl'o mai be tahawhúlhts'ih, 'i niyútun. 'Ink'ez ndi tl'o mai yutahawhúlhts'ih, 'i 'ink'ez yuk'ut 'ut'en, 'i chah yuk'ut lhadút'ih t'eh, 'ink'ez yuna'ulhdoh. 'Ink'ez ndi mai ndai lhaduja, 'i deínudzih 'ink'ez mai koo ts'ih wheyúlih. Ndi kwun 'aw nachanusne, be but'ooz, duték'un,” ndo búlhni. ");
INSERT INTO cafNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","'Et Sizi Galilee yun k'ut ts'ih hainya. Jordan took'oh ninya John too be' yutelilh ka. ");
INSERT INTO cafNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","'Et whunts'ih John dah yúlhni. “Nyun too be' sonleh huba' hoont'ah. 'Ink'ez di ka si suts'ú tenya too be' nyoosdleh ka?” ");
INSERT INTO cafNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","'Et whunts'ih Sizi ndi yúlhni, “Whute ndoh hot'e, be ts'ah'un 'uhoont'ah, 'i 'et ts'iyawh lhaoodutenilh ho' hoont'ah.” 'Aw 'et whute 'et ndúyinla. ");
INSERT INTO cafNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sizi too be' yinla hoh tooz hanája ibulh 'et 'ahoh yak'uz whuda'dutézkez 'ink'ez Yak'usda buyégha yunilh'en hoh ndus de dut'ai, 'i dove hiyúlhni, 'i k'una'a Sizi buk'édinde. ");
INSERT INTO cafNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Khunyaz ndus de 'uwhutni, “Ndun 'en suYe' buk'esi' 'en 'int'ah, 'ink'ez tube 'en bulh hoonúst'i,” ni. ");
INSERT INTO cafNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sizi dune chahóot'ih ts'ih Ndoni Sizi whuz wheyálh'a netsudule yootélhdzih ka. ");
INSERT INTO cafNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dit lanezi dzin (40) sahá'delya, 'et hukw'elh'az buye'élts'ul. ");
INSERT INTO cafNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","'Et ndun yootélhdzih ka, 'en yughu ninya 'ink'ez ndi yúlhni, “'Alha Yak'usda buYe' ninli t'eh, ndi tse lhes wule dini.” ");
INSERT INTO cafNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","'Et Sizi 'uyúlhni, “Yak'usda bughunek k'ut 'uk'une'úsduguz, ‘'Aw lhes zeh ilah dune yugha khuna, 'et Yak'usda bughunek ts'iyawh, 'i be chah higha khuna.’ ” ");
INSERT INTO cafNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","'Et netsudule keyah whudezti ts'ih yulh whin'az, 'ink'ez luglez whucho degha ndoh hukw'ut, 'et hukw'abah ninilhya. ");
INSERT INTO cafNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","'Ink'ez ndi yúlhni, “'Alha Yak'usda buYe' ninli t'eh, njan whegha' dudintneh! 'Alha 'uk'e'edúguz hoh njan ndutni, ‘Yak'usda bulizas butl'aho'ai hoh 'en nyun nka huwuhinli, 'ink'ez hubula be nyoohóotetun, 'et 'aw nke tse t'aoonalh ghaít'ah.’ ” ");
INSERT INTO cafNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","'Et Sizi nduyulhni, “Doo chah zeh njan 'uk'e'éduguz hoh ndutni, ‘Khun teh Moodihti nYak'usda 'en nantan'ah hukwa ólhdzih gunih!’ ” ");
INSERT INTO cafNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","'Et doo chah zeh netsudule ndi dzulh yédoh hadet'ai ts'ih whuz yulh whin'az. 'Et ndi yun k'ut ndulhcho hoh whenulhtun hubudayi cho bube 'ut'en k'ah 'ink'ez huyé dezti, 'i chah. ");
INSERT INTO cafNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","'Ink'ez ndi yúlhni, “Ngwutsi be nininyih 'ink'ez suts'u téni' nilhdzun t'eh, 'et sih ts'iyawh, nye'ildzun wule!” ");
INSERT INTO cafNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","'Ink'ez Sizi ndi yúlhni, “Satan naindalh! 'Et 'uk'e'éduguz hoh njan ndutni, ‘Moodihti nYak'usda, 'aw 'en zeh bubut negwutsi be nits'uyih, 'ink'ez buts'u téni' uznilhdzun, 'ink'ez 'en zeh buba né'ts'oot'en huba' hoont'ah.’ ” ");
INSERT INTO cafNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","'Et netsudule whenaja 'ink'ez lizas whusahándel 'ink'ez hiba ne'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","John tsak'ehiyan'a Sizi whulh údants'o hoh Galilee yun k'ut ts'ih whinya. ");
INSERT INTO cafNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazareth whuch'a séya 'ink'ez keyah Capernaum whuz ninya 'et tedalh ka. Keyah 'et taba whuz'ai. Yun k'ut Zebulun 'ink'ez Naphtali lhodin'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Isaiah nus ho'en, 'et howu yailhtuk lhaóodotneh hoh njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Yun k'ut Zebulun 'ink'ez yun k'ut Naphtali, bun k'uz wheti 'et whuz'ai. Galilee 'i 'udun yun k'ut whut'en, huwhut'i. ");
INSERT INTO cafNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tsahólhgus yuh hudelhts'i, 'en be whét'en cho 'i hitelh'en. Hoh huwhut'en dahutetsah tsagwusts'it huba li'hoont'ah, ndunnah 'en huba hoolh'en.” ");
INSERT INTO cafNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","'Et whuts'un Sizi dune hubulh yawhénilhtuk hoh ndo búlhni, “Nuhwhulubeshi ch'a nuhwhubeni náhandunoohleh! Yak'uz k'une' whul'en 'aw 'et nilhdukw suli.” ");
INSERT INTO cafNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","'Aw 'et bun k'ut Galilee taba Sizi hoh wheghah uyalh 'et nanah dune lhulhutsinkah hubutelh'en. 'Ilhunuh 'en Simon hiyulhni, Peter chah hiyulhni, 'et 'ilhunuh bulhutsin 'en Andrew hiyulhni. 'En lhoombilh tahíyalhdel lhook ka 'uhut'en hinli. ");
INSERT INTO cafNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","'Ink'ez ndo búlhni, “Suneh'us. Dune ka 'ut'en nuhwhutelhsilh.” ");
INSERT INTO cafNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","'Ahoh hubuloombil hiladetnik 'ink'ez hik'ah ts'ih 'uhoot'en ka hiyuntez'az. ");
INSERT INTO cafNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","'Et 'o 'un hedulh nanah dune hubutelh'en. 'En chah lhulhutsinkah Zebedee buye'kah. 'Ilhunuh James 'ink'ez 'ilhunuh 'en John hiyulhni. Bu'abá bulh ts'i cho be húdelhts'i 'ink'ez hubuloombil nahuyutl'oo. 'Et Sizi hubukahunih. ");
INSERT INTO cafNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","'Et 'ahoh bu'abá highu dehaín'az 'aw 'et ye usda hoh 'ink'ez Sizi hik'ah ts'ih 'uhoot'en ka hiyuntez'az. ");
INSERT INTO cafNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Galilee yun k'ut Sizi ndulhcho nuya. Lizwif hubuluglez dune hubulh yálhtuk. Yak'uz k'une' whul'en, 'en hubugha khunek unzoo, 'i be hubulh yálhtuk. Ndan nduda 'ink'ez buyust'e tel'en, 'en ts'iyawh soo na'bulh'en. ");
INSERT INTO cafNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","'Et Syria huwhut'en, ts'iyawh hiyulh údits'o. Ndunnah lhenyoo dada bé hunduda, 'ink'ez ndan 'o nus bulh 'últs'ulh chah, ndan ntsi' nudúde buyudínda chah, 'ink'ez hubukaootuzuk 'ink'ez nuchahúsyah chah, 'en Sizi ts'un lhgha budinla hoh ts'iyawh soo ná'binla. ");
INSERT INTO cafNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galilee, 'ink'ez Decapolis yun k'ut whut'en chah, 'ink'ez Jerusalem whut'en, Judea whut'en, 'ink'ez Jordan took'oh 'onghoh whughah whut'en chah, 'et 'ahuneltsuk 'ilhunahuwésdel 'en ts'iyawh hiyuntezdel. ");
INSERT INTO cafNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","'Ilhunahuwésdel Sizi hubunilh'en. Dzulh yenun ts'ih whenya, 'ink'ez 'et nátl'adeda hoh yugha hódul'eh, 'en highu nindel. ");
INSERT INTO cafNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","'Et wheoobudunilh'i, 'et njan ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Lubeshi 'ulh'en, 'en budzi tel'en unli, 'en yak'uz k'une' whul'en bube'ildzun huzdli, 'et huwa degha nus hoonzoo hubugha whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hubulubeshi ghu ni hinli, 'en degha nus k'enánet'a hutele. 'En 'uhuja degha nus hoonzoo hubugha whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Yuh údudildzun, 'en ndi yun k'ut bube'ildzun whutele, 'et huwa degha nus hoonzoo hubugha whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ndan ye be ts'ah'un 'uhoont'ah, 'i tube hukwa buye'élts'ul 'ink'ez ta'oosde lí'hint'ah, 'et hubugha óotelts'ulh. 'En degha nus hoonzoo hubughá whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bugha te'huninzun, Yak'usda chah hubugha te'untezilh, 'et t'eh degha nus hoonzoo hubughá whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Hubudzi dutsun chailah, 'en k'at le Yak'usda hute'ilh 'et huwa 'en degha nus hoonzoo hubughá whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ndan ts'ah'un na'a lhulh 'uhint'ah hubulhtsi, 'en Yak'usda buzkeh ubahudaténilh. 'Et huwa degha nus hoonzoo hubughá whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ndunnah ye be ts'ah'un 'uhoont'ah gha dzuh nobuhulhdeh, 'en yak'uz k'une' whul'en, 'et bube'ildzun hinli. 'Et huwa degha nus hoonzoo hubughá whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Dune nuhwheni ch'a yahutelhtuk 'ink'ez dzuh nunohotelhdzut, 'ink'ez ts'iyaitsuk whuts'it khunek dutsun, 'i be nuhwheni ch'a 'uts'un na'a yahutelhtuk, 'et si sugha whuz na'a dune dzuh nunwhahulhdzut t'eh, 'et degha nus hoonzoo hubughá whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Whunélhnik 'ink'ez degha nus hoonáht'i! Yak'uz hooncha hoh nuhwhuba k'elha whutele. Nuhtsuh nus whunilh'en inle, 'en chah whuz na'a zeh bube huzula inle. ");
INSERT INTO cafNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Lubeshi 'uhulh'en huba lusel liaht'ah. 'Et whunts'ih lusel 'aw buzachahóolkih suli t'eh, nts'e na'a simba doo chah lusel buzahóolki naoodle? 'Aw hoonli ba chaízooh ho' 'int'ah. 'I 'ants'ih dune ti híyulhkuk 'ink'ez hik'unúdelh. ");
INSERT INTO cafNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ndi yun k'ut dune huba be whét'en, 'i li'aht'ah. Keyah whuti dzulh k'ut whuz'ai t'eh, 'aw whuntool'ih ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Dune too dezk'un naidulhk'an 'ink'ez 'aw k'its'ai yut'ah niyóo'alh ghaít'ah. K'us kw'uzdai k'eíte'alh 'ink'ez kwun 'i bugha ts'iyannah huwhuntelh'ilh. ");
INSERT INTO cafNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Dune ba be whét'en ahli. 'I be nuhwhe'ut'en unzoo, 'i dune yuntelh'ilh 'ink'ez nuhwhe'aBá yak'uz usda, 'en degha nus hidutélhti.” ");
INSERT INTO cafNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Moses be' dustl'us 'ink'ez nus whunilh'en bube' dustl'us 'i hoolah natelhtsilh ka whusaíya noohzin gunih. 'I ts'iyawh lhaoodutesdlih 'et wheni whusaíya. ");
INSERT INTO cafNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","'Alha' dusni ndun whudusni, Moses be' dustl'us Hebrew bughunek k'una'a hoonsolyaz hoh 'uk'e'edúguz 'ink'ez hoonsolyaz 'uk'e'edúsgus, ndet 'uwhulhni, 'et ts'iyawh 'et ndúhooja t'eh, 'et whuts'un 'aw ndi yun 'ink'ez yat'ah chah 'ustl'e' 'uhóneh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ndai khunek neghalts'ut, hoontsolyaz whunts'ih dune k'uhinínyuz t'eh, 'ink'ez 'uyoon whuz na'a zeh wheoobodutelh'eh t'eh, 'et sih yak'uz k'úne' whul'en, 'en 'aw hoonli chailah hiduténilh. 'Et ndi khunek netl'adélts'ut, 'i dune ts'iyawh hik'une' 'ut'en t'eh, 'ink'ez 'uyoon chah whuz na'a 'az whebodutelh'eh, yak'uz k'úne' whul'en be ncha 'int'ah hiduténilh. ");
INSERT INTO cafNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ndun whudusni ndunnah Moses be' dustl'us 'uk'ununa'úsduguz 'ink'ez Pharisee chah, 'en hiye be ts'ah'un 'uhoont'ah, 'ink'ez nuhwheni ye be ts'ah'un 'uhoont'ah, 'i be huba nus hoonzoo t'eh, 'aw 'et zeh nts'e yak'uz k'une' whul'en ts'ih téhdulh. ");
INSERT INTO cafNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Whulh udahts'o netsuhda hubuhutni, ‘Dune solhghelh gunih,’ 'ink'ez ndan dune selhghi t'eh, 'et hukw'una'a huba nahuteyeh ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ndun whuhdúsni, ndunnah 'ants'ih dulh dune bulh hunilch'e t'eh, 'en huba nahutedeh. 'Et ndan dudulh dune ‘Raca’ 'ulhni t'eh, khunek dakelh k'una'a ‘Ntsi'’ ni hoh 'utni, 'i bugha naheyelh hububut huteyin. 'Ink'ez chah zeh ndun dune, ‘Whuzinik dune inli ho' 'int'ah!’ yulhni t'eh, 'en tube whewhúnujut kwuncho yuh ts'ih buhutenoh. ");
INSERT INTO cafNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","'Et huwa hoonliyaz Yak'usda bukw'uzdai k'ut howa' té'alh, 'ink'ez nyulh dune hoonli nch'a hudetni whunailnih t'eh, ");
INSERT INTO cafNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","'et whutsuh nyulh dune bulh lhk'enahoodutseh. Hukw'elh'az k'an zeh Yak'usda bukw'uzdai k'ut huwa' tan'alh, 'et huwa níoon'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","'Et khun dune hoonli nch'a hudetni t'eh, 'ahoh buts'un ts'ah'un na'hotneh. 'Et naheyelh but nínyutelhtelh whutsuh ndóneh. 'Aw ndúchainel t'eh, nch'a hudetni, 'en naheyelh but nínyutelhtelh. Naheyelh, 'en nélhghel tl'anyutelhtelh 'ink'ez nch'a dána'dute'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ts'ah'un 'un whudúsni, ts'iyaitsuk buk'elha whutelhtsilh whuts'un, nts'e na'a simba whuch'a naoohja?” ");
INSERT INTO cafNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Whulh udahts'o netsuhda hubuhutni, ‘'Uyoon ts'eke bulh tinta' ont'en gunih.’ ");
INSERT INTO cafNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sich'oh 'un whudúsni, dune ts'eke yunilh'en 'ink'ez budzi yuh hoh duninzun t'eh, ‘Bulh tínta' test'ilh hukwa' nuszun,’ 'uda budzi yuh bulh tinta' ant'en ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","'Et nalhnih ts'ih nyuna be lubeshi inla t'eh, hanón'alh 'ink'ez 'un ntolh'is. 'Et ndáhja t'eh nuhyust'e ndulhcho chadutésk'un hoh whanus soo' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","'Ink'ez nalhnih ts'ih nla be tínta' nint'en t'eh, k'ont'as 'ink'ez 'un tolh'is. Nuhyust'e ndulhcho 'aw kwuncho yuh ts'ih chadutésk'un, 'et 'o nus soo' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“'O 'un chah nduhútni ‘Ndun bu'at 'ustl'e' 'utelilh, ye' dustl'us 'istl'e' itelilh, 'i yutl'ayóolhchoos huba' hoont'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","'Et whunts'ih 'un whudúsni, bu'at 'uyoon dune bulh tinta' 'ant'en 'et huwa zeh dustl'us ye' 'ustl'e' itelilh, 'i yutl'ayóolhchoos. Ndúchainel hoh bu'at 'ustl'e' 'uyínla t'eh, dich'oh bu'at tinta' 'ant'en yulhtsi. 'Ink'ez ndun ts'eke 'uyoon dune ghu nasda t'eh, dune 'en chah tinta' 'ut'ih unli ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“'Et doo chah niz de whudezulh da ts'iyawh t'eoonáhzun 'uda dune daja hutni hoh njan duhutni, ‘Khun nyunch'oh nghunek k'ónyis gunih. 'Et neMoodihti buts'u nahizínya 'et nduhoolcho hukw'una'a 'ont'en huba' hoont'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","'Et whunts'ih sich'oh 'un whudúsni, khun whuz na'a teh ndudóohtni gunih. Khun ‘Yak'uz whunalh 'udusni,’ doohtni gunih. 'Alha yak'uz ts'ih Yak'usda bukw'usda cho dezti, 'i 'et su'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","'Ink'ez, ‘Ndi yun k'ut whunalh 'udusni,’ doohtni gunih. Yak'usda duke yuk'udelhú'ez, 'i 'int'ah 'et huwa. 'Ink'ez khun teh, ‘Keyah Jerusalem whunalh 'udusni,’ doohtni gunih. Hubudayi cho k'us dezti bukeyah whucho 'uhoont'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","'Ink'ez khun teh, ‘Sutsi be 'alha' dusni,’ doni gunih. 'Aw ntsigha 'ilhuk'i whuntsi dulyul k'us dulhgus 'ólhtsilh hoolah. ");
INSERT INTO cafNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","'Et ndez na'a njan dúdoohtni, 'Aw 'et ‘A,’ dahtni, ‘A,’ 'int'ah. 'Ink'ez ‘'Awundooh,’ dahtni t'eh chah, ‘'Awundooh,’ 'uhoont'ah. 'Et 'uts'un na'a 'udutéhnilh t'eh, 'et sih ntsi' ts'ih hadutédoh ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“'Et whutsuh da whulh udahts'o nts'e na'a dune daja hutni inle njan duhutni, ‘Dune buna chawhés'en silhtsi t'eh, nyunch'oh nyúna be chawhés'en tanle. 'I be kw'elha whutelhtsilh. 'Et bughoo habe'alhchus t'eh, nyunch'oh nghoo be k'elha whutelhtsilh,’ hutni inle. ");
INSERT INTO cafNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","'Et whunts'ih 'un whuhdúsni, dune ntsi' k'ól'en gunih. 'Et k'us ndan nalhnih ts'ih nuhnezkuk t'eh, 'et 'intl'as ts'ih buts'un nándunont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Khun ndan nts'oozt'an naheyelh but nts'u yuka 'utni t'eh, ndzoot 'i chah bughá yólhchoos. ");
INSERT INTO cafNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Dune 'et nduhóolhdzah sulh ti ínyalh nyulhni t'eh, nat 'uwhuldzah ts'ih bulh neóonya. ");
INSERT INTO cafNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ndan hoonli nts'un hukwa 'utni t'eh, hubugha yó'alh. Hoonli bughu sinla yulhni t'eh, buch'a naool'ah gunih.” ");
INSERT INTO cafNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“'Et whulh údahts'o hubuhútni, ‘Nyeghah whut'i buk'eoontsi' 'ink'ez nch'a hudetni, 'en buts'u dontnik.’ ");
INSERT INTO cafNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ndun whúdusni, nuhch'a hudetni, 'en buk'eoohtsi'. Ndunnah denwhútdule, 'en khunek unzoo, 'i be hubulh yaóolhtuk. Ndunnah nuhts'u dutnik, 'en buts'un wahzoo. 'Et ndunnah hoontsi' nuhts'un ne'hut'en 'ink'ez dzuh nunwhahulhdzut, 'en chah buba tenadoohdli. ");
INSERT INTO cafNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","'Et ndez na'a nuh'aBá yak'uz usda, buzkeh wahle. Yak'usda ndunnah hintsi' 'ink'ez hinzoo 'en ndi sa lhulhúgha buk'eidindi. Ts'ah'un 'uhint'ah 'ink'ez ts'ah'un cha'hít'ah, en chah lhulhúgha buk'ut nawhúlhtih. ");
INSERT INTO cafNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ndunnah nuhk'entsi', 'en zeh hubuk'ehtsi' t'eh, di simba nuhgha óokat? Sooneya nalhdzooh chah whuz na'a zeh nduhút'en. ");
INSERT INTO cafNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nuhwhulhutsinkah zeh dahooja hubudahni t'eh, 'uyoon degha nus ahzoo na'dunáhzun ih? Hoolah! Sooneya nalhdzooh, 'en chah whuz na'a zeh nduhút'en. ");
INSERT INTO cafNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nuh'aBá yak'uz usda dant'ah hoh ts'ah'un 'int'ah, nuhwheni chah whuz na'a zeh ndóht'e huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Huwahli! Khun tel'en gha' teh'alh t'eh, ts'et whucho ndóht'en gunih. 'Et whuz na'a ndaht'en t'eh, nuhwhe'aBá yak'uz usda, 'en 'aw nuhwhuba k'elha holhtselh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","'Et huwa tel'en gha' teh'alh t'eh, khun ts'iyannah nalh tube cho 'ududoolhúti gunih. Ndunnah duba nahudzoo, 'en 'et whuz na'a 'et duhút'en. Lizwif hubuluglez k'us ti whulheguz 'et ts'iyannah hubunoolh'en ka, 'et nduhút'en. 'Alha' dusni, ndunnah ba 'uk'elha whutele, 'uda huba 'uk'elha whuzdli ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","'Et whunts'ih tel'en gha' teh'alh t'eh, nyula 'intl'as ts'ih 'aw t'ewhunozin nyula nalhnih ts'ih dat'en 'et. ");
INSERT INTO cafNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","'Et whuz na'a 'uyoon t'ehoníszun 'et ndaht'en hoh tel'en bugha 'áh'aih. 'Ink'ez nuhwhe'aBá yak'uz usda, 'en dahoont'ah huwa 'et ndaht'en, 'et ts'iyawh nuhwhunílh'en ho' 'int'ah. 'Et huwa dich'oh ts'iyannah but hoonzoo hoh nuhwhuba k'elha whutelhtsilh.” ");
INSERT INTO cafNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“'Et tenadahdli t'eh, khun ndunnah duba nahudzoo k'ah ts'ih tenadoohdli gunih. Ndunnah Lizwif hubuluglez nahudelhúya, k'us ti wheguz chah, 'ants'ih ts'iyannah hubunoolh'en ka tenahududli. Ndun whudúsni 'uda huba k'elha whuzdli ho' hint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","'Et nuhwheni tenadutehdli t'eh, nuhwhenich'oh whaht'i, dati dána'dehtan 'ink'ez tenadoohdli. Nuhwhe'aBá, 'aw be chaoodést'en, 'en ts'iyannah nalh nuhwhuba k'elha whutelhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","'Et tenadahdli t'eh, lhat cho lhtanahoohdeh gunih. Whuz na'a ndunnah 'aw Yak'usda t'echahunízun tenahududli. Lhai khunek be tenahududli t'eh, 'et sih Yak'usda hubudutéts'o huninzun. ");
INSERT INTO cafNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","'En hubuk'una'a 'udoohni gunih. Nuhwhe'aBá dant'i be ndunahdzit 'uda t'ewhunínzun ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","'Et ndez na'a tenadoohdli, ‘Ne'aBá yak'uz sinda. Nyoozi dóoti. ");
INSERT INTO cafNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Hoh hubudayi cho inli, whusahóolts'it. Hukwa' ninzun t'eh, ndoh honeh, ndi yun k'ut 'ink'ez yak'uz chah. ");
INSERT INTO cafNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","K'an dzin uzte'alh, 'i negha iní'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","'Uyoon bulh tink'us ts'uwhulh'ai t'eh, buba whunats'odoolnah. 'Et whuz na'a zeh tink'us 'uts'ut'ih 'et neba whunaoodolnah. ");
INSERT INTO cafNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nts'e tink'us ts'unint'uk, whuch'a neghinli. 'Ink'ez ndun ntsi', 'en chah buch'a neghinli. 'Et yak'uz k'une' 'int'en 'int'ah, 'ink'ez be ilhtus, be dénti, 'i chah, 'i 'ilhuz wheni, 'i ts'iyawh nye'ildzun 'int'ah. 'Et ndoh honeh.’ ");
INSERT INTO cafNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Dune nuhwhudulhyah né'hut'en t'eh, buba whunaoodelhúnah t'eh, nuhwhe'aBá yak'uz usda, 'en chah nuhwhuba whunaoodutelnah. ");
INSERT INTO cafNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","'Et whunts'i dune nuhwhudulhyah né'hut'en t'eh, 'ink'ez buba whuchanaooduzulhunah t'eh, nuhwhe'aBá yak'uz usda, 'en chah nuhwhuba whunaoodoolnah ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ndet sahá'delhuya t'eh, ndan duba nahudzoo, 'en hubuk'una'a 'ooht'e gunih. 'En hubudzi yuh 'uhilhdzun na'hududil'i ho' hint'ah. Dunen 'uts'un 'oonint'en hiyúlhtsih, whuz na'a te'hududil'en 'ink'ez dzuh nuhuzut na'hududil'i, 'uyoon húbonoolh'en ka. 'Alha ndun whudusni, ndan nduhút'en, 'uda huba k'elha whuzdli ho' hint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","'Et nuhwheni sahá'delhúya t'eh, soo cho nuhwhunen chah na'óolhdeh 'ink'ez nuhtsigha chah naoolhlho. ");
INSERT INTO cafNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","'Et whuz na'a sahá'delhúya t'eh, 'et 'onghunnah hubuch'a nonah'i. 'Et whunts'ih nuhwhe'aBá cha'whést'en ts'ih whunts'ih whunilh'en, ts'iyannah nalh nuhwhuba k'elha whutelhtsilh.” ");
INSERT INTO cafNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ndi yun k'ut hoonáht'i, 'i 'ilho 'oohleh gunih. Ndulh'en t'eh, 'ants'ih k'enadidutsih 'ink'ez muszoombaiyaz chah hoolah yutelhtsilh. 'Undunut'ih, nuhghu dá'duteyus 'ink'ez hiduntet'ih. ");
INSERT INTO cafNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","'Et yak'uz be hoonzoo 'uhoont'ah, 'i whuz 'ilho wéhla. 'Aw buk'ena'doodutsih ghaít'ah. 'Ink'ez muszoombaiyaz chah 'aw hoolah yoolhtselh ghaít'ah. 'Aw nuhghu da'hooyis 'ink'ez nuhghe' hudunoot'ih ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","'Et ndet be hoonzoo 'uhoont'ah, ndet sáhla, nuhdzi chah 'et duté'alh.” ");
INSERT INTO cafNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nena neyust'e ba too dezk'un li'int'ah. Nuhna soo 'int'ah t'eh, nuhyust'e be whét'en, 'i dezbun. ");
INSERT INTO cafNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","'Et whunts'ih dune buna tink'us 'ut'en be untsi' t'eh, 'et buyust'e ndulhcho tsahólhgus be dutébun. 'Et huwa be whét'en nohwhulh 'int'ah tsahólhgus k'una'a be hoodet'en t'eh, dáhoolcho, 'i be simba tsahólhgus wule?” ");
INSERT INTO cafNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“'Ilhunuh dune nanah moodih ba 'oot'en ghaít'ah. 'Ilhunuh 'en yuts'u dutetnik 'ink'ez 'ilhunuh yuk'etetsi'. K'us 'ilhunuh yuk'úne' tet'en 'ink'ez 'ilhunuh yuch'a dutetni. 'Aw Yak'usda k'une' 'int'en 'ink'ez sooneya chah k'une' 'ont'en ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“'Et huwa njan ndun whudusni, yinkak delhúts'i huwu ni wahle gunih. Teh'alh, 'i 'ink'ez tehnilh, 'i chah, 'ink'ez nuhyust'e be soo nadutehnilh, 'i chah, 'i ts'iyawh khun bugha ni wahle gunih. Teh'alh, 'i be kháhna, 'i degha nus dezti nahzun ih? K'us naih 'i nuhuyust'e degha nus dezti nahzun ih? ");
INSERT INTO cafNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nduk dut'ai núdelh, 'i nulh'en! 'Aw hacha'nusdle 'ink'ez 'aw khi huba ilhucha'wesdle ilah. 'Et whunts'ih nuhwhe'aBá yak'uz usda, 'en bugha 'á'aih. Nuhwheni 'en ilah 'o nus huba déhti. ");
INSERT INTO cafNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nuhtah ndan dalcho tele howu ni unli? 'Aw 'et huwa 'o nus 'ulyez wule ghaít'ah! ");
INSERT INTO cafNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Di ka be dune tehleh wuni ahli? 'Indakyaz nts'e na'a haniyeh, 'et howu nuni nahzut. 'Aw cha'hust'en 'ink'ez 'aw naih chah cha'hulh'en hiye dune tele ka. ");
INSERT INTO cafNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ndun whudusni Solomon 'en whunts'ih soo nadut'ih teh, 'aw 'indakyaz yuch'a degha nus cha'ildzooh. ");
INSERT INTO cafNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yak'usda tl'o unzoo, 'i yilh'i. 'I k'an dzin tl'o k'ut haniyeh 'ink'ez bunt'ah 'i tsehidutelhkulh 'ink'ez duték'un. 'Et dáhoolcho 'i be nuhwheni 'o nus soo nanohdutele? Nuhwheni 'aw soo cho nuhwhuba 'alha' cha'hoot'ah ho' 'aht'ah! ");
INSERT INTO cafNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","'Et huwa di simba ts'oo'alh, k'us di simba ts'ootnai, k'us di simba be dune ts'oole, noohzin gunih. ");
INSERT INTO cafNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","'Alha 'udun yun k'ut whut'en 'et zeh hukwa hités'en. 'Ink'ez 'alha 'i be nuhwhe'aBá yak'uz usda, ndai hoonliyaz be ts'udunudli, 'i ts'iyawh t'eooninzun. ");
INSERT INTO cafNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ndet Yak'usda nuhwhuba hubudayi cho tele 'ink'ez ye ts'ah'un na'a 'uhoont'ah, 'i nuhbe'ildzun tele, 'et zeh hukwa' nahzun t'eh, 'o 'un, 'i chah ts'iyawh nuhgha tékulh ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","'Et huwa bunt'ah dawhútenilh, 'et howu ni wahle gunih. Bunt'ah dawhuténilh, 'et ndo honeh. Dzin totsuk soo' hoolcho howun ni hoonli 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“'Uyoon ba nahoohyeh gunih. Doo ka sih nuhwhuba nahoodeh. ");
INSERT INTO cafNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nts'e na'a 'uyoon ba nahahyeh, 'et whuz na'a nuhwhuba nahutedeh. 'Ink'ez nts'e na'a 'uyoon ghu nuni nahdzut, whuz na'a zeh nuhghu nuní huntezut. ");
INSERT INTO cafNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","'Et di ka nyulhutsin lhusyaz buna k'et deztan, 'i nilh'en, nyunch'oh duchun cho nyuna k'et deztan 'ink'ez? ");
INSERT INTO cafNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nts'e na'a nyulhutsin 'uduténilh, ‘Nyuna k'elts'ut, 'i nyuna k'ehanaóos'alh,’ 'ink'ez nyunch'oh lhi'ílcho, 'i nyuna k'et su'ai, 'i 'aw chanílh'en? ");
INSERT INTO cafNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Buba naindzoo! 'Udechoo lhe'ílcho, 'i nyuna k'élts'ut, 'i choo nyuna k'éhanain'aih. 'Et sih soo whunilh'en hoh buna k'élts'ut, 'i buna k'ehanáyo'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yak'usda bughunek lubeshi bughuh hoolah, 'i khun teh lhikah ndult'ah hubugha yóoh'alh gunih. K'us Yak'usda ye whúneodulh'eh, 'i kw'usul dezti, 'i pearl hiyulhni, 'et dult'ah, 'i khun teh goso dult'ah butayóolhdelh gunih. 'Et ndahja t'eh, ndulhcho hik'unutélh'us 'ink'ez 'ahoh nuhts'un nahulhúya 'ink'ez yanohodutélhch'ulh.” ");
INSERT INTO cafNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Yak'usda bukayoodulhkut, 'i nuhgha íte'alh. Bukunáhta 'ink'ez nahootéh'alh. Ndati whudúlhghalh 'ink'ez nuhwhuba da'dutékwus. ");
INSERT INTO cafNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ndan 'oodulhkut, Yak'usda hubugha whúte'alh. Hoonliyaz hukunúta, 'en nahahooté'alh. 'Ink'ez ndati hodulhghalh 'en Yak'usda huba dá'dutet'ilh. ");
INSERT INTO cafNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ndunnah nuhbákah nuhtah, buye' lhes yuts'u ka 'utni t'eh, tse yughá ndunóo'alh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","K'us lhook yuts'u ka 'utni t'eh, hoh tl'ughus yugha óolelh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nuhwheni lubeshi 'ulh'en ahli, 'et whunts'ih t'eoonahzun nts'e na'a unzoo, 'i nohwuzkeh hubugha itéh'alh. Dáwhulcho, 'i be 'o nus nduk yak'uz nuhwhe'aBá, ndunnah yoodulhkut, unzoo, 'i hubugha ité'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","'Et huwa nts'e na'a hukwa' nahzun dune danoh hotelh'ilh, 'et whuz na'a zeh nuhwheni 'et ndúboolh'en. 'Alha Moses be' dustl'us, 'ink'ez nus whunilh'en bube' dustl'us chah, 'et nawhult'ah 'et nduwhútni.” ");
INSERT INTO cafNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Njan hukwuti hoondot 'et hukohdelh huba' hoont'ah. 'Et hukwuti hoontel, 'et hoontsi' ts'un whuz’ai, whuz whéti 'uhoont'ah 'ink'ez lhanah whuz whehúdelh. ");
INSERT INTO cafNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Njan 'et huwa 'et nduhút'en, njan hukwuti hoondot, 'i 'ilhuz be ts'ukhuna 'uhoont'ah 'ink'ez howa whulna ho' hoont'ah. 'Aw lhanah ilah nahuhóo'aih.” ");
INSERT INTO cafNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ndunnah whuts'it be nus whunilh'en na'dudil'i, 'en buka huwahli! Sheep zuz be soo dint'ah, 'en buyuh ts'ih yus soo degha nus ntsi' 'en lí'hint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","'Et huwa dahút'en, 'et 'i be t'eoobuntehzeh. 'Et mai cho whus chuntah ih oonahye? K'us ndi mai, figs hiyulhni, chuntah whuduts'ul whutah oonahye ih? 'Awundooh! ");
INSERT INTO cafNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","'Et whuz na'a zeh duchun unzoo, 'i mai unzoo, 'i bugha haniyeh. ");
INSERT INTO cafNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","'Ink'ez duchun dalhjut, 'i 'aw mai unzoo, 'i bugha hanóoyeh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ts'iyai, 'i duchun 'aw mai unzoo, 'i bugha hanooyeh ghaít'ah, 'i nánuhidutselh 'ink'ez hidelhk'un. ");
INSERT INTO cafNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","'Et huwa dune chah whuz na'a ndúhint'ah. 'Et huwa t'eoobunoohzin.” ");
INSERT INTO cafNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“'Aw ts'iyannah, ‘SMoodihti, sMoodihti,’ sulhni, 'aw nts'e yak'uz k'une' ts'uwhul'en whuz hutooya ghaít'ah. Ndan se'aBá buts'o hukwa' ninzun tune' 'ut'en, 'aw 'en zeh yak'uz ts'un hutedulh. ");
INSERT INTO cafNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","'Et ndunnah njan dzin whusawhélts'ut t'eh, ‘SMoodihti sMoodihti, 'alha nyoozi be nus ts'úhoo'en. 'Ink'ez nyoozi be ntsi' nududeh, 'i 'uyoon bughu whe náts'inanyoot! 'Ink'ez nyoozi 'i be huwa 'ét'en tune' ts'ut'en,’ hutni. ");
INSERT INTO cafNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","'Et ndunt'ah dune ts'iyawh hubudutésnilh, ‘'Aw t'enwhunuzúszun. Such'a nasahdel! Nuhwheni 'aw suk'unucha'aht'il aht'ah!’ ” ");
INSERT INTO cafNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“'Et huwa ndunnah sughunek yoozilhts'ai, 'ink'ez daja dusni hukw'une' hut'en, ndun dune whunih bukoo tse k'ut niooni'ai, 'en k'una'a 'uhint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","'Aw 'et nawheóonilhtan 'ink'ez too 'aw 'et ulhtus suli, 'i njan bukoo whut'agheznai. Nilhtsi ulhtus, 'i chah whudelhts'ut. 'Et whunts'ih njan bukoo 'aw dachahóonil. Njan bukoo tse k'ut whuz'ai 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","'Et whunts'ih ndan sughunek hudits'o 'ink'ez 'aw hik'unucha'ust'en t'eh, ndun dune whusnik, 'en bukoo 'ants'ih sai k'ut niooni'ai, 'en duhúlt'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","'Aw 'et nawhéoonilhtan 'ink'ez too 'aw 'et ulhtus suli, 'i njan bukoo whut'agheznai. Nilhtsi ulhtus, 'i chah whudilhts'uk. 'Ink'ez njan bukoo nawhélts'ut. 'Ink'ez wheóonujut hoh nahwélts'ut.” ");
INSERT INTO cafNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","'Et Sizi ndi khunek ye hubulh yailhtuk, 'i lhaduja hoh 'ilhunahuwésdel tube huba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Khunek be butl'awhélts'ut hoh wheoobudalh'i. Ndunnah Moses be' dustl'us k'ut 'uk'ununa'úsduguz, 'aw whuz na'a hubuchaoodílh'il. ");
INSERT INTO cafNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","'Aw 'et Sizi ndus de dzulhyaz k'uz hanaja hoh lhanah dune hinantesdel. ");
INSERT INTO cafNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","'Et hoh dune bukak whulhjut, 'i leprosy hiyúlhni, 'en yududezya, yubut nachaniti 'ink'ez ndi yúlhni, “SMoodihti nyun hukwa' ninzun t'eh, ndi ndai be ilhtus, 'i 'int'i, 'i be suna'ilhdeh.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","'Et Sizi bula be yut'aghéznai 'ink'ez, “A, hukwa' nuszun. Nyuna'alhde!” yúlhni. 'Et bukak whulhjut, 'et 'ahoh soo na'uja. ");
INSERT INTO cafNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","'Et Sizi ndi yúlhni, “Khun teh 'uyoon doni gunih! 'Et náwhulnuk buts'inyalh 'ink'ez ts'ah'un na'a díni nyust'e nts'e na'a hoh soo na'uja 'ink'ez nyunoolh'en. 'Et Moses be' dustl'us yuk'uyaoolhtuk. 'I bugha ndai huwa ta'alh, 'i nyudóoni. 'Et whuz na'a ts'iyannah whubuntalhtun dainja hoh soo na'inja.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","'Aw 'et Sizi keyah Capernaum ts'ih huwhutni ninya hoh 'ilhunuh Rome whut'en nehughan bumoodih, 'en yududezya hoh yuts'u tedudlih, ");
INSERT INTO cafNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“SMoodihti se'ustlenyaz, 'en njan koo yun sulhti 'aw dechadusnik hoh tube dzuh nuzut.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","'Et Sizi 'uyulhni, “Buts'u tesyalh 'ink'ez soo na'tesdlilh.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","'Et whunts'ih ndun nehughan bumoodih 'uyulhni, “SMoodihti sukoo ts'ih tanyalh huba 'aw soo cha'lhúdzooh. 'Ants'ih nghunek be 'et ndudénja t'eh, 'et whunts'ih se'ustlenyaz soo na'ootnelh sih. ");
INSERT INTO cafNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","'Alha si chah 'onghunnah sugha ndoh 'uhint'ah hoh hukwa' huninzun tune' suhulh'en. 'Et si chah whuz na'a zeh nehughan huba ndoh 'ust'ah. 'Et 'ilhunuh, ‘Inyalh!’ dusni t'eh, 'et 'aho wheyih. 'Et 'uyoon ‘'Anih,’ dúsni t'eh, 'et 'ahoh sughu yih. 'Et se'ulhna, ‘Njan dineh!’ dúsni t'eh, 'et 'ahoh 'et ndút'ih.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sizi ndun dune ndet 'uwhúlhni whulhúdants'o hoh tube ba hooncha. 'Et huwa ndunnah yunedulh ndo búlhni, “Israel whuyun k'ut ndulhcho hoh, 'aw ndun dune whuz na'a buba 'alha 'uhoont'ah nachalhtel. ");
INSERT INTO cafNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","'Et ndun whudusni ndaz de 'ink'ez nus de lhanah whusatedulh hoh yak'uz k'une' whul'en ts'ih 'et Abraham, 'ink'ez Isaac, 'ink'ez Jacob chah, 'en 'ilho lhula na'hutet'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","'Et whunts'ih ndunnah yak'uz k'une' hool'en huba 'int'ah inle, 'en 'az tsahólhgus ts'ih hubotelhdulh. 'Et ts'iyawh hutso 'ink'ez hubughoo lhehídutelhk'us.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","'Et Sizi ndun nehughan bumoodih 'en ndi yúlhni, “'Aw 'et inyalh! 'Et nts'e whula mba 'alha 'ust'ah, whuz na'a zeh mba' whuténilh.” 'Et soo 'et 'uhunet'oh hoh be 'ustl'enyaz soo na'uja. ");
INSERT INTO cafNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","'Et Sizi, 'en Peter bukoo daninya hoh bubez yunilh'en. 'Et kw'usti k'ut sulhti dada nézul be nduda. ");
INSERT INTO cafNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yuzih ninínya 'ink'ez yula t'agheznai. 'Et 'ahoh ndi nézul nduda buts'uh hanaidede. 'Et 'ahoh dinadija 'ink'ez bugha ná'unt'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","'Aw 'et sa yuk tez'ai hoh lhanah ntsi' nududeh hubuyidélhts'i, 'en Sizi highu bunínla. Bughunek be ntsi' nududeh, 'i hubuyáh hanaínanyoot. 'Et ts'iyawh ndan nduda, 'en ts'iyawh soo na'ubinla. ");
INSERT INTO cafNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","'Et whuz na'a Isaiah nus ho'en hoh ndutni, 'et ts'iyawh 'et ndúhooja. 'Et huwa njan ndutni, “Ndai lait'ah neilh'i, 'i ts'iyawh neghu yílhchoot. 'Ink'ez nedada chah 'i nets'u hanáhonla.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","'Et 'ilhunahuwésdel ts'iyawh hinasdúguz. 'Et Sizi whunalh'en hoh 'et ndunnah yulh 'ut'en, 'en ts'iyawh ndo búlhni, “Nyan uztooke.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","'Et 'ilhunuh Moses be' dustl'us 'uk'ununa'usdúguz, 'en yughu ninya hoh ndi yúlhni, “Nehodulh'eh nts'oh tula nutányalh, 'et ndulhcho nyun tesyalh hukwa' nuszun.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","'Et Sizi ndi yúlhni, “Soo cho howu nuní ninzut! Nanguz 'en chah 'an whut'i ho' 'int'ah 'ink'ez dut'aiyaz chah ut'o ut'i. 'Et whunts'ih yinkak dune ye', 'aw hukw'ut tsin tel'alh 'et whunts'ih chahóot'ih.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","'Et 'uyoon yugha hoodul'eh, 'en ndi yúlhni, “SMoodihti subailh'i. 'Se'abá wheyutelhtelh choo.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","'Et whunts'ih Sizi ndi yúlhni, “Sunanyalh! Dudulh yaidla dich'oh wheyunalhuhoolyelh.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","'Aw 'et ts'i beinya 'ink'ez yugha hoodul'eh, 'en ts'iyawh hiyulh 'úja. ");
INSERT INTO cafNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ni huzki ibulh hubulh taoodelts'ut 'ink'ez 'aw 'et ts'i be tawhenduniteh, 'et whunts'ih Sizi 'en nanisti. ");
INSERT INTO cafNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","'Ink'ez yugha hoodul'eh, 'en hits'u whendel ts'enahiyulhdzit. “NeMoodihti netalhyis! 'Aw 'et too ts'uteghan!” ");
INSERT INTO cafNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","'Et ndo búlhni, “Di ka whénlhujut? 'Aw bé 'alha' whut'en, 'i soo 'últus, 'i chaht'ih ho' dahni.” Didinya hoh khunekti be hukwa' yudáni too 'ink'ez nilhtsi bulh yatelhtuk, 'ink'ez 'aw 'et dinghel. ");
INSERT INTO cafNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","'Et ndunnah dune huba hooncha hoh 'ulhódutni, “Ndun dant'ah dune simba 'int'ah? Nilhtsi 'ink'ez tatsi bulh 'i whunts'ih hik'une' 'ut'en.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","'Aw 'et nyan nisúki ndunnah Gergese hubuyun k'ut huwhutni, whuz lhghuhudindel. 'Et nanah dune highu nin'az. 'En ntsi' nududeh, 'i buyudínda. Ndet neyust'e 'ahule, 'et whuz de hahá'az. Soo cha'hunízun k'et 'aw dune buyust'e ghah lhoya ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","'Et khunyaz tube cho 'uhutni, “Sizi nyun Yak'usda buYe' inli ho' 'int'ah! Ndai nets'u hukwa' ninzun? Nket'ah neba whusaóotelts'ulh whutsuh, dzuh nunetalhdzut ka 'inja whusainya?” ");
INSERT INTO cafNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","'Et njan howu nilhdza, 'et goso lhai hoh ahú'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","'Et ntsi' nududeh, 'en hits'u tedudlih hoh hiyulhni, “Whusanáneuntanyulh t'eh, 'et nyooz goso yúzdoodeh netl'ahó'alh.” ");
INSERT INTO cafNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","'Et “Ahdulh!” ndo búlhni. 'Aw 'et ntsi' nududeh, 'i ndunnah dune hubuts'uh haídande hoh goso yídande. 'Aw 'i bulh goso wheghah helghaz 'ink'ez too hubanghan. ");
INSERT INTO cafNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","'Et ndunnah goso ghuhinli, ts'iyawh 'ahoh keyah ts'ih whehélghaz. 'Ink'ez keyah whut'en ts'iyawh ndo badáni dahooja 'et. Ndunnah nanah ntsi' nududeh, 'i hubuyidande inle, 'et dahúja nduhóolcho ndo badáni. ");
INSERT INTO cafNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","'Aw 'et keyah whut'en, ts'iyawh 'az whehélghaz 'ink'ez Sizi hidudezdel. Hitelh'en ibulh njan buyun k'ut whuch'a naóoja, 'et hukwa hits'u tedudlih. ");
INSERT INTO cafNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sizi 'aw 'et ts'i benya 'ink'ez nyan whehánki dich'oh dukeyah ts'ih. ");
INSERT INTO cafNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","'Aw 'et ndun dechadusnik, 'en kwusuti be whusahíyankai. Sizi hubunilh'en 'ink'ez t'eooninzun huba 'alha' hoont'ah. 'Et dechadusnik 'uyúlhni, “Dahooja 'uski, nduk 'un dunilt'uk! Nyulubeshi ts'iyawh mba hoolah suli!” ");
INSERT INTO cafNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","'Et 'ahoh bulunah Moses be' dustl'us 'uk'ununa'úsduguz 'ulhódutni, “Ndun dune Yak'usda ch'a yalhtuk ho' 'utni!” ");
INSERT INTO cafNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","'Et daja huninzun Sizi 'et ts'iyawh t'eooninzun. 'Et ndo búlhni, “Di ka nuhdzi yuh ntsi' ghu nuni nahzut? ");
INSERT INTO cafNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nts'e na'a simba huwa chahoolnah k'una'a uzdooni? ‘Lubeshi mba hoolah suli,’ k'us, ‘Didinyih 'ink'ez inyalh’? ");
INSERT INTO cafNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","'Et njan t'eoonóhzin yinkak dune ye', 'en ndi yun k'ut huba' hoont'ah ho' 'int'ah lubeshi 'un toolhdelh ka huba' hoont'ah ho' 'int'ah,” hubúlhni. 'Ink'ez ndun dechadusnik, “Didinyih 'ink'ez kw'usinti, 'i nailchoot 'ink'ez nkoo ts'ih naindalh!” yulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","'Et 'ahoh dinadija 'ink'ez bukoo ts'ih whenája. ");
INSERT INTO cafNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","'Et 'ilhunahuwésdel ts'iyawh huba hooncha 'ink'ez Yak'usda hidálhti, dune, 'en chah butl'aho'ai hoh huba' hót'e ka. ");
INSERT INTO cafNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","'Et hukw'elh'az Sizi wheghah lhuseya hoh ndet sooneya nalhdzooh, 'et 'ilhunuh dune Matthew hiyulhni, 'et usda yunilh'en. “Sunanyalh,” yulhni. 'Et didinya 'ink'ez yuk'ah ts'ih oot'en ka yuntezya. ");
INSERT INTO cafNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sizi yukoo ts'ih daninya 'ink'ez buzih usda bula na'utet'alh. Sooneya 'ilhunanowez'aih 'ink'ez lubeshi 'ulh'en, 'en chah koo dahuníndel 'ink'ez Sizi 'ink'ez yugha hoodul'eh hubulh hubulana'hut'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","'Ink'ez ndunnah Pharisee hinilh'en hoh yugha hoodul'eh hubuhoodulhkut, “Nuhodulh'eh, 'et di ka sooneya 'ilhunanowez'aih 'ink'ez lubeshi 'ulh'en chah hubulh na'ut'alh?” ");
INSERT INTO cafNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","'Et Sizi bubulh údants'o daja hiyulhni 'et ndo búlhni, “Ndunnah soo 'ínt'ah 'aw yoo be duyun ka cha'hunízun. Nduda, 'en zeh yoo be duyun ka' huninzun. ");
INSERT INTO cafNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","'Et huwa ahdulh 'ink'ez ndet 'uk'e'whe'edúguz hoh 'et hodoolhú'eh, ‘'Uyoon hubugha te'ntehzilh 'et nuhts'uh hukwa' nuszun. Ndai Yak'usda bukw'uzdai k'ut hidutelhk'un, 'i buka' cha'núszun,’ ni. Si chah whuz na'a, 'aw dune ts'ah'un 'uhint'ah, 'aw hubuka ilah whusáya. 'Et lubeshi 'uhulh'en, 'en bulubeshi ch'a bubeni naháhundunooleh ka, 'et huba whusáya.” ");
INSERT INTO cafNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","'Aw 'et John yugha hoodul'eh, 'en Sizi ts'un hunindel hoh hiyoodulhkut, “Dáhoont'ah huwa wheni chah 'ink'ez Pharisee, 'en chah lhat hoh sahá'delya. 'Ink'ez nyun ngha hoodulh'eh, 'en 'aw sahá'chahudulhuye?” ");
INSERT INTO cafNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","'Et Sizi ndo búlhni, “Ndun bu'at whutele, 'en bulh dunekah 'awhuz hiyulh 'int'ah, 'en chah ih soo sahá'hudutelyih? 'Awundooh! 'Et whunts'ih dubulh dunekah buch'a nahítelhtelh, 'et t'eh zeh sahá'hudutelyelh. ");
INSERT INTO cafNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","'Ink'ez chah, 'aw 'uda, 'i dzoot 'aw k'andit, 'i naih be naoolhkut ghaít'ah. 'Et nyoo k'andit, 'i naih naootéltsulh 'ink'ez buts'u hanaitech'ulh, 'et 'o nus hootétsi'. ");
INSERT INTO cafNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","'Et doo chah, 'aw k'an mai too, 'i 'aw 'ujut, 'i 'uzus be yóolhdzeh ghaít'ah. 'Et nduyínla t'eh, 'et sih bukóltalh. 'Et nyoo k'an, 'i mai too ts'iyawh nadutejulh, 'ink'ez ndi 'uzus 'i chah tinta' tet'ilh. 'Et k'an mai too, k'an 'uzus 'i be híyalhdze t'eh, 'aw tinta' 'oot'en ghait'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","'Et njan dahooja 'awhuz howu yalhtuk khunyaz 'ilhunuh moodih yughu ninya 'ink'ez yubut nachániti. 'Et ndi yulhni, “Sutse' k'an 'ahoh dazsai. 'Et whunts'ih soo tulih sukoo ts'ih tónya, 'ink'ez nla be buk'édolnih, 'et sih nakhóotna!” ");
INSERT INTO cafNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","'Et Sizi didinya 'ink'ez yuntezya. Yugha hoodul'eh, 'en chah ts'iyawh hiyulh 'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","'Et wheghah hedulh hoh khunyaz 'ilhunuh ts'eke, 'en lanezi 'o 'at nat (12) naooduzuk inle hoh 'uskai 'uyulh'en. Ndun ts'eke Sizi yut'ak ts'ih yugha ninya 'ink'ez nayits'uz, 'i yus ts'ih yut'agheznai. ");
INSERT INTO cafNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","'Et ndutenilh whuts'uh dich'oh nduna'dudútni, “'Ants'ih bunaih but'aghénai t'eh, 'et sih soo na'oosneh.” ");
INSERT INTO cafNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sizi yuts'u nálha'a 'ink'ez yunilh'en 'ink'ez ndi yúlhni, “Stse', nduk 'undunilt'uk! Be 'alha' hoont'ah, 'i mba 'alha' 'int'ah 'et huwa soo na'inja.” 'Et whuts'un soo na'uja. ");
INSERT INTO cafNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","'Aw 'et Sizi ndun moodih bukoo ts'ih daninya hoh ndi be ts'ujun, 'i flute hiyulhni, 'i hiye ujun hoh hubunilh'en. 'Et 'onghunnah tube tahúdetnik hoh tso yahalhtuk, 'ink'ez ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“'Az náhdulh! Ndun ts'ekeyaz 'aw dáchaitsal, 'ants'ih nanisti ho' 'int'ah.” 'Et highudloh. ");
INSERT INTO cafNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","'Et dune ts'iyawh 'az whenaóobahalh'a. Sizi bukoo ts'ih daninya hoh 'uski yula ilhchoot ibulh dinadija. ");
INSERT INTO cafNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","'Et dahooja, 'et yun k'ut ndulhcho 'et hukw'u nahuwhulnuk. ");
INSERT INTO cafNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","'Aw 'et Sizi natesja hoh nanah dune chawhés'en hiyuntez'az 'ink'ez hikazulh, “NeMoodihti David buts'u hainzut negha te'nenzeh!” ");
INSERT INTO cafNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","'Et Sizi koo ts'ih daninya hoh ndunnah chawhés'en highudani'az. 'Et Sizi ndo búlhni, “Nuhwhuba 'alha' hoont'ah ih njan 'et dutésnilh huba?” 'Et 'uhiyulhni, “A, neMoodihti!” ");
INSERT INTO cafNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Buna yut'agheznai 'ink'ez ndo búlhni, “Nts'e na'a nuhwhuba 'alha' hoont'ah, whuz na'a 'uhóneh.” ");
INSERT INTO cafNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","'Et 'ahoh nahitát'en 'ink'ez honilh'en. Sizi khunek ulhtus, 'i be ndo búlhni, “Khun 'uyoon dóohni gunih!” ");
INSERT INTO cafNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","'Et whunts'ih tináhunt'az 'ink'ez ndi keyah ndulhcho ts'iyannah ndo badáni. ");
INSERT INTO cafNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","'Et tinahúndel 'ilhunuh dune 'aw yachalhtuk, ntsi' nududeh, 'i buyidínda 'et huwa. 'En Sizi highu hínilhti. ");
INSERT INTO cafNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","'Et ndun ntsi' nududeh, 'i ye yáhanainanyoot. Ndun dune 'aw 'et yawhénilhtuk. 'Et 'ilhunahuwésdel 'ulhódutni, “Israel yun k'ut nduhoolhcho hoh 'aw ndez na'a cha'whúsne, 'et k'an ts'iyai 'et 'udechoo ndúhooja!” ");
INSERT INTO cafNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","'Et ndunnah Pharisee nduhútni, “'Ants'ih ntsi' nududeh, 'en bumoodih ye ulhtus, 'i bugha ndi nududeh ntsi' yuts'u hanaínanyoot!” ");
INSERT INTO cafNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","'Aw 'et Sizi njan keyah whuti 'ink'ez keyah whuyaz chah nduhóolhcho nusiya. 'Ink'ez Lizwif hubuluglez ndi khunek unzoo, 'i be yak'uz k'úne' whul'en, 'en hubugha wheboodulh'eh. 'Et dune ndunnah buyust'e nduda, 'en ts'iyawh soo na'bulh'en. ");
INSERT INTO cafNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","'Ink'ez 'ilhunahuwésdel hubunilh'en. 'En ts'iyawh nihunentsai k'ah hanul'en, 'aw 'uhooneh ghaít'ah. 'Ink'ez ts'iyaintsuk ladetnik li'hut'en. 'Ants'ih sheepyaz lhanah 'aw hubughunli hoolah li'hint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","'Ink'ez yugha hoodul'eh, 'en ndo búlhni, “'Alha 'aw 'et ha' nukat newhúninzut 'ink'ez tl'o mai lhai suli, 'et whunts'ih ndunnah 'uhut'en, 'en 'aw soo cha'huniltsuk. ");
INSERT INTO cafNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","'Et huwa Yak'usda ha' nukat whumoodih, 'en 'uyoon 'uhut'en chah whusáboolh'a, 'et huba tenadoohdli,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","'Et lanezi 'o 'at nanah (12) Sizi yugha hoodul'eh, 'en 'ilho 'anih hubudáni. Ntsi' nududeh, 'i 'en ts'iyawh ndet whehílhtus chah, 'ink'ez k'une' bool'en ka, 'et chah, 'ink'ez ndet hukw'e húndudá chah, 'et ts'iyawh 'et whuch'a soo na'botelilh, 'et chah ts'iyawh butl'ahó'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Njan 'et lanezi 'o 'at nanah whel'a huboozi yuk'e'tegus; 'udechoo Simon, 'en Peter chah hiyulhni; 'en bulhutsin 'en Andrew hiyulhni; 'et doo chah James chah Zebedee buye', 'ink'ez John 'en chah 'en bulhutsin 'int'ah; ");
INSERT INTO cafNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip 'ink'ez Bartholomew; Thomas 'ink'ez sooneya nalhdzooh Matthew hiyulhni; James 'en chah Alphaeus buye' 'int'ah, 'ink'ez Lebbaeus 'en buboozi 'udek'elh'az Thaddaeus hiyulhni; ");
INSERT INTO cafNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","'et Simon chah, 'en Canaan yun k'ut whut'en 'int'ah, 'ink'ez Judas Iscariot 'en 'uja Sizi be 'onket 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","'Aw 'et ndunnah lanezi 'o 'at nanah, 'en nts'e 'uhutet'ilh, Sizi whuz hubutelh'alh. 'Et khunek ulhtus, 'i hubutl'aida'ai hoh ndo búlhni, “Khun 'udun yun k'ut whut'en hubuti ts'ih teh toohdelh gunih. 'Ink'ez Samaria hubukeyah ts'uti whuz teh toohdelh gunih. ");
INSERT INTO cafNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","'Et Israel buts'u hainde, 'en 'ants'ih sheep tinta nilh'az, 'i lí'hint'ah, 'en zeh hubuts'un toohdelh. ");
INSERT INTO cafNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","'Aw 'et ahdulh hoh hubutah lhohdelh, njan 'et hubudutéhnilh, ‘Nts'e na'a yak'uz dune k'úne' whul'en, 'aw 'et nilhdukw suli.’ ");
INSERT INTO cafNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nduda 'ink'ez buka whulhjut, leprosy hiyúlhni, 'en chah ts'iyawh soo na'boolh'en. Yaidla chah dinábudóohlelh. Ntsi' nududeh, dune hubuts'ah hanábunoohyukw. Ndai 'ants'ih nuhgha nkat, 'i chah 'ants'ih huwaóohle. ");
INSERT INTO cafNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Khun teh sooneya nuhsooneya zus be óohdzaih gunih! ");
INSERT INTO cafNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Khun téhdulh t'eh hoonliyaz toohla gunih. 'Ezdla 'ink'ez kesgwut, 'i chah 'ink'ez nankoh ts'oozt'an 'ink'ez nuhtuz. 'Alha ndan 'ut'en, 'en nts'e na'a ne'ut'en, 'en huba soo 'úlzoo dant'i hiye ndunidzit 'i hubutl'ahó'alh huba' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ndet keyah ts'ih téhdulh 'et keyah whuyaz k'us keyah whuti, 'et ndunnah keyah whut'en, 'en hukwa boodolhkut k'us ndan simba dune budzi unzoo, 'en bukoo doolhúts'i. ");
INSERT INTO cafNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","'Et hubugha danáhdel t'eh, ndunnah bukoo hudelhts'i 'i ts'iyawh hoonzoo nuhghá holts'it, nuhwhuba hukwa' nídudzun, 'et whuz na'a 'et ndubudóohni. ");
INSERT INTO cafNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","'Et ndunnah bukoo 'et hudelhts'i, 'en huhóont'i hubughu danáhdel t'eh, 'et nuhdzi dant'ah, ts'iyawh hubuts'un be óolhnih. 'Aw 'et nduchahit'ah t'eh, daja hubudáhni, 'aw nuhwhula'hooneh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","'Et ndunnah 'aw nuhghun nuchahiyal 'ink'ez chanohuhoozilhts'ai t'eh, 'et bukoo tinaoohdelh 'et nyoh keyah whuti 'et chah whuch'a naoohdelh. 'Ink'ez nuhke ts'iyawh lhez ch'a naoohghat. ");
INSERT INTO cafNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","'Alha ndun whudusni ndet dzin dune ba nahutedeh whusawhélts'ut t'eh, ndunnah Sodom whut'en 'ink'ez Gomorrah whut'en chah, njan keyah whut'en ndunnah nuhghu núchayal, 'en 'o nus 'uwhultsi' hubugha óotelts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Njan whunulh'en, 'ants'ih sheep yus yugha wélh'az li'hoont'ah ts'ih whuz nuhwhutelh'a. 'Et huwa tl'ughus k'una'a whunih wáhle, 'ink'ez dut'aiyas, dove hiyulhni, 'i k'una'a 'aw dune ndóolhdah gunih. ");
INSERT INTO cafNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bulunah dune buch'a kháhdli. 'En Lizwif naheyelh, 'en hububut nenóhotelelh. 'Ink'ez Lizwif luglez húbez ts'ih 'et nuhohóotelhtsus. ");
INSERT INTO cafNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","'Et 'ants'ih yun k'ut whumoodih 'ink'ez hubudayi cho chah si sugha 'en hububut nenóhotelelh. 'Ink'ez si sugha wheoobuntelhtun. 'Udun yun k'ut whut'en, 'en chah si sugha wheoobuntelhtun. ");
INSERT INTO cafNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","'Aw 'et whutl'anohuhanla t'eh, nts'e na'a daja dutehnilh, 'et huwu ni wahle gunih. Nts'oh howa whudezulh whe ndai be yátelhtuk, 'i 'et t'ewhunoohzeh. ");
INSERT INTO cafNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","'Alha 'aw nuhwhenich'oh ilah yatelhtuk. Nuhwhe'aBá buyégha 'i 'uduténilh. ");
INSERT INTO cafNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","'Et dune dulhutsin datétsah ka whutl'aítelhtelh. Bu'abá 'en buzkeh chah whuz hubutelilh. Bubuzkeh budusnekah chah hubuch'a nehúdutedulh 'et dahutetsah huwá botelelh. ");
INSERT INTO cafNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","'Ink'ez si soozi bugha ts'iyannah nuhts'u dutetnik. 'Et whunts'ih ndunnah 'udek'elh'az whuts'un 'et whechahítsaz, 'aw 'en zeh hudutejih. ");
INSERT INTO cafNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","'Et whunts'ih njan keyah 'en dzuh nanóhahulhdzut t'eh, 'et 'udun keyah ts'ih hubuch'a tóohdelh. 'Et keyah whuti 'et chah dzuh nunohohulhdeh t'eh, doo chah 'o 'un keyah hubuch'a tóohdelh. 'Alha' dusni 'et yinkak dune ye' whusateyalh whutsuh, 'aw njan Israel hits'uh hainde, 'en hubukeyah ts'iyawh whutah lhóhdelh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Dune yugha hoodul'eh, 'en 'aw yuba dune hoodulh'eh hubugha ndoh cha'it'ah. 'Ink'ez be 'ulhna, 'en chah 'aw dumoodih bugha ndoh cha'it'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Dune yugha hoodul'eh, whuyodulh'eh k'una'a 'oot'e huba' hoont'ah, 'ink'ez be 'ulhna, 'en dumoodih k'una'a 'oot'e huba' hoont'ah. 'Et si Beelzebul suhútni t'eh, 'et nuhwheni sugha hoodul'eh, nuhwheni chah whuz na'a zeh 'et ndunohoduténilh! ");
INSERT INTO cafNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","'Et huwa 'en bube noolhújut gunih! Ts'iyaitsuk lubeshi whu'iz 'int'ah 'ink'ez ntelh'i, 'i ts'iyawh ts'et haóotekulh 'ink'ez ts'iyannah 'et t'ehontezeh. ");
INSERT INTO cafNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","“Njan daja nuhwhudusni tsahólhgus ts'et whucho howu yaoolhtuk. Ndet whu'iz whudahts'o, 'et bun k'ut whuts'un khunekti be howu yaoolhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ndun neyust'e hughan 'et 'aw nezul 'i hizoolhghelh ghaít'ah, 'et ndunt'ah, 'en bube noolhújut gunih. 'Et whunts'ih Yak'usda ndun nuhzul nuhyust'e bulh kwuncho yuh ts'ih nuhtenoh, 'en zeh be noolhújut. ");
INSERT INTO cafNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","'Alha ih ndi nankoh 'uschas, 'i 'ilho sooneya chadíti, 'i 'et 'ultsuk 'i be oohket? A, 'alha 'uhoont'ah. 'Et whunts'ih ne'aBá 'aw hukwa cha'nizun t'eh, 'aw 'ilhunuh ndi yun k'ut naoolts'it ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","'Ink'ez nuhtsigha, 'i ts'iyawh 'ilhuk'i hoh t'eininzun. ");
INSERT INTO cafNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","'Et huwa khun whenoolhujut gunih. Nuhwheni 'uschas buch'a degha nus déhti hoh aht'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“'Et huwa ndun dune nalh 'et ndutni, Sizi, 'en zeh si sulhyis 'int'ah, ndun 'et ndutni, se'aBá yak'uz usda, 'en dutesnilh, ndun 'en se'ildzun 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","'Et whunts'ih ndunnah dune nalh si hubulhyis ilah hutni t'eh, si chah se'aBá yak'uz usda ndunnah, 'en 'aw se'ildzun chahilah dóosni. ");
INSERT INTO cafNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ts'iyannah lhts'un ts'ah'un 'uhoot'e, 'et hukwa ndi yun k'ut whusáya noohzin gunih! 'Aw lhts'un ts'ah'un 'uhoot'e hubugha ootés'alh hukwa ilah whusáya. 'Et soh cho li'int'ah, 'i hubugha ités'alh 'et huba whusáya. ");
INSERT INTO cafNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Dune bu'abá ch'a nidúteyalh 'ink'ez butse' 'en be'ama ch'a nidúteyalh. 'Ink'ez 'en buyas'at 'en dubez ch'a nidúteyalh, 'et hukwa whusáya. ");
INSERT INTO cafNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ndunnah dune bukoo huwhut'i, 'en chah hich'a nidutédulh. ");
INSERT INTO cafNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ndan bu'abá k'us bu'ama, si sughanus hubuk'entsi' t'eh, ndunt'ah, 'en 'aw suba soo cha'hildzooh! 'Ink'ez ndan buye' 'ink'ez butse' bulh, si sughanus hubuk'entsi' t'eh, 'en 'aw suba soo cha'ildzooh. ");
INSERT INTO cafNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","'Ink'ez chah ndunnah bulhdulalhgus chadestil, 'ink'ez suchahunesdulh t'eh, 'en ts'iyawh suba soo cha'hildzooh. ");
INSERT INTO cafNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ndan dich'oh ye khuna, 'et hoolhyih hukwa 'ut'en, 'en ye khuna ts'iyawh tinta ooté'alh ho' hoont'ah. 'Et whunts'ih ndan si sugha dich'oh ye khuna, 'i tinta ooní'ai, 'en ye khuna, 'i nayité'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ndan hoont'i hoh danyunilhti, 'en si chah hoont'i hoh dasunílhti li'hoont'ah. Ndan whesalh'a, 'en chah hoont'i hoh daínilhti ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ndan nus whunilh'en, 'en 'et huwa dune hoont'i hoh dainílhti. 'Et nts'e na'a buba k'elha whutele, 'et ndan chah whuz na'a zeh buba k'elha whutele. 'Et whuz na'a zeh ndan ts'ah'un dune, 'en 'et huwa dune hoont'i hoh dainílhti, 'en ndet buba k'elha whutele, 'et whuz na'a zeh ndunnah chah ba k'elha whutele. ");
INSERT INTO cafNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","'Ink'ez ndunnah si sugha hoodul'eh, 'ink'ez ndun hubutah k'us hukw'elh'ih 'int'ah, 'en sugha hoodul'eh 'int'ah 'et huwa dune too nezk'uz yubainkai t'eh, 'alha 'ún whudusni, 'en whunts'ih buba k'elha whutale ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","'Aw 'et Sizi lanezi 'o 'at nanah yugha hoodul'eh, 'en ts'iyaintsuk ndo budáni 'ustl'e' 'udeja, 'et bughu whénya. 'Uts'un keyah ts'un whenya dune hodutelh'eh 'ink'ez hubulh yatelhtuk wheni. ");
INSERT INTO cafNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","'Aw 'et John ndalts'ut 'et Christ be 'ut'en k'ah whulh uduzts'ai. 'Et huwa nanah yugha hoodul'eh, 'en John Sizi ts'un wheóobalh'a. ");
INSERT INTO cafNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","'Et hiyoodulhkut, “Nyun ih whusatéyalh inli, k'us 'uyoon tulih ka ts'itóo'en?” ");
INSERT INTO cafNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","'Et Sizi njan ndo búlhni, “John bugha nanaht'az t'eh, ndet whunélh'en 'ink'ez ndet whudáhts'o, 'et ts'iyawh ndudóohni. ");
INSERT INTO cafNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","'Et chawhés'en chah 'et honilh'en nasdli. Dzuh nuhudelh, 'en soo nahudelh nahúsdli. Hubuka whulhjut chah leprosy hiyúlhni, butsun hoolah nasdli, 'ink'ez cha'hudusts'uk chah 'ahudits'o nasdli. Yaidla chah dináhudidel 'ink'ez tel'en chah khunek unzoo, 'i be hubulh yaintuk ho' hint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","'Et ndunnah si sugha 'aw buba dzuh chailel t'eh, 'en degha nus hoonzoo bughá whults'ut.” ");
INSERT INTO cafNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","'Et ndunnah nanah whehá'az, Sizi ndunnah 'ilhunahuwésdel, 'en njan John bugha hubulh yawhenilhtuk hoh ndo búlhni, “Di teh'ilh ka dune chahóot'ih ts'ih whéhdel? Tl'o ghazilh nonulhts'i, 'i tulih teh'ilh nahzun ih? ");
INSERT INTO cafNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ndet simba hukwa tsi hoohli whuteh'ilh? Dune naih duchut, 'i be soo naduja, 'en tulih teh'ilh nahzun ih? Sih soo zelhts'ai, ndunnah naih duchut, 'i be dune unli, 'aw 'en zeh hubudayi cho bukoo hudelhts'i. ");
INSERT INTO cafNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","'Et ndet whuteh'ilh hukwa tsi hóohli? Nus whunilh'en tulih? A, 'alha' hoont'ah. 'Et 'unhwhudúsni, nus whunilh'en degha nus hoonzoo whunalh'en! ");
INSERT INTO cafNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ndun 'en bugha 'uk'une'úsduguz, 'i 'et ndutni, ‘Sih soo zelhts'ai 'uyoon khunek suba na'a, 'en ntsuh telh'alh. Nts'oh lhutéyalh mba lhaoodutelilh ka.’ ");
INSERT INTO cafNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ts'ah'un na'a 'ún whudusni, ts'iyannah whuzdli, 'aw John dune too be 'ulh'en degha nus dezti hoolah. 'Et whunts'ih nts'e yak'uz k'úne' whul'en, ndan degha nus dezti chailah, 'en degha nus uncha ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","'Et hoh da John dune too be 'ulh'en be whe' whudit'en, 'et k'an dzin whuts'un, yak'uz nts'e k'úne' whul'en, 'et yak'uz huhoolhdel, 'ink'ez huhoolhdel, 'en ts'iyawh yak'uz da'hudutóoyis hukwa' hut'en. ");
INSERT INTO cafNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","John whusateyalh whuts'un, nus whunilh'en hube' dustl'us, 'ink'ez Moses be' dustl'us chah, ndet daóotenilh hubudani, 'et 'uwhulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","'Et daja nuhwhudúsni, soo nuhwhuba 'alha' whutet'ilh t'eh, ndun nus whunilh'en Elijah whusateyalh, John 'en 'int'ah, 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ndan budzo hooni, 'en 'ahoozólhts'a huba' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","'Et yuk'edíndeh nts'e na'a simba nuhwhuba lhuzih neooboosdlelh? Ndez na'a njan duhínt'ah hoh 'uskehyaz nduhúlt'ah 'ink'ez nts'e ts'uyi, 'i be 'ooket 'et hudelhts'i. 'en dudulh dunekah buts'u hahuyih hoh ndó buhútni, ");
INSERT INTO cafNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Be ts'ujun, 'i nuhwhuba be ts'ujun, 'et whunts'ih neba chanuzahdak. 'Ink'ez nuhwheni nuhwhuba tso ts'inli, 'et whunts'ih 'aw wáhtso ghaít'ah!’ ");
INSERT INTO cafNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","'Et John dune taninya hoh 'aw cha'us'al 'ink'ez 'aw tachasnai. 'Et highu yalhtuk ho' hutni, ‘Nududeh, 'i ntsi' buyudínda,’ dahni. ");
INSERT INTO cafNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","'Et yinkak dune ye', 'en dune hubutaninya hoh hubula whé'ni'al 'ink'ez hubula tawhénitnai, 'et 'uhutni, ‘Ndun 'en bucha hooncha 'ink'ez mai too chah 'utnai. Sooneya nalhdzooh 'ink'ez lubeshi 'ulh'en, 'en hubulh dunekah 'int'ah,’ dáhni. 'Et whunts'ih ndunnah Yak'usda bugha whunih suli, 'en ts'iyawh ndi hiye whunih, 'i be ts'ah'un 'uhint'ah suli.” ");
INSERT INTO cafNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","'Et hukw'elh'az nts'e keyah whuti totsuk 'ut'en ncha, 'i ba' yílya, 'i ndut'en hukwa' budáni. 'Aw hubeni lht'anahádunoolelh hukwa cha'hunízun. ");
INSERT INTO cafNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","'Et huwa 'utni, “Nuhwheni Chorazin whut'en, 'ink'ez nuhwheni Bethsaida whut'en chah, dawhultsi' 'et nuhts'u whélts'ulh! Soo cho soozélhts'ai 'uda ndet nduhóolcho hoolhtus nuhnat ne'whust'en, ndunnah Tyre 'ink'ez Sidon whut'en, 'en chah bunat 'et ndúhooja t'eh, 'uda da hubeni lht'anahádunoolelh, 'ink'ez doso naih be húdelhts'i 'ink'ez lhez tsi la hidudzih wule da. ");
INSERT INTO cafNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","'Et whunts'ih ndun whudusni, ndet dzin nuhwhuba whusawhutelts'ulh nts'e na'a nuhwhuba nahutedeh ka, 'et ndunnah hubulh dawhutenilh, 'et nuhwheni 'o nus 'uwhultsi' 'et nuhts'u whelts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","'Ink'ez nuhwheni Capernaum whut'en nduk yak'uz huba soo áht'ah nahzun ih? 'Awundooh! 'Et kwuncho yuh ts'ih nuhotelhdulh! 'Alha 'uda ndet hoolhtus nuhnat ne'whust'en, ndunnah Sodom whut'en, 'en chah bunat 'et ndúhooja t'eh, 'awhuz da bukeyah 'et whuz'ai wule da. ");
INSERT INTO cafNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","'Et whunts'ih ts'ah'un 'un whudúsni, dahoont'ah nuhwhuba whusawhutelts'ulh, nts'e na'a nuhwhuba nahutedeh ka, 'et ndunnah Sodom whut'en hubulh dawhutenilh, 'et nuhwheni 'o nus 'uwhultsi' 'et nuhts'u whélts'ulh.” ");
INSERT INTO cafNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sizi 'awhuz hubulh yalhtuk 'et ndutni, “'ABá nyun nyudélhti. Yak'uz 'ink'ez yun k'ut huMoodihti inli. Whunih 'ink'ez hoodul'eh, 'en ndi 'i ts'iyawh buch'a whunte'i. 'Et whunts'ih 'uskiyaz li'int'ah, 'en bunalhts'et hahó'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","'Et whunts'ih 'aBá ndet 'uhóonla hoonínt'i. Ndoh honeh. ");
INSERT INTO cafNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Se'aBá ts'iyawh stl'ahónla, 'ink'ez 'en buYe' ndan unli ts'iyannah t'ehonízun. Ba'aBá 'aw 'en zeh t'eininzun. 'Ink'ez ndan be'aBá unli, buYe' 'aw 'en zeh t'eininzun. 'Ink'ez ndan buYe' 'onghun ts'iyawh wheoobuntelhtun hukwa' ninzun t'eh, 'en zeh huba' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nuhwheni ts'iyawh ndan 'ut'en ulhtus, 'i 'ulh'en 'ink'ez ndan ndaz, 'i nuhle li'aht'ah, nuhwheni ts'iyawh dez ahdulh 'ink'ez nats'ulyis nuhgha óotes'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ndai se' 'ut'en, 'i ulhchoot 'ink'ez nedúht'aih li'ahleh 'ink'ez si sugha hoodulhú'eh. 'Aw dune ch'a nucha'zust'en 'ink'ez ts'iyannah tah te'dudulhú'en 'et huwa. 'Et whuz na'a nuhzul nátelyis huba nahóh'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ndi úlhchoot, 'i 'aw nuhwhuba hubugha chahóolnah tele, 'ink'ez se'ut'en k'ah chah hoondzak tele.” ");
INSERT INTO cafNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","'Aw 'et 'ilhut dzin 'et Lizwif huba nalyis dzin huhoolh'i. Hoh da Sizi tl'o k'ut íyalh, 'ink'ez yugha hoodul'eh, 'en chah hiyulh hudulh hoh buye'élts'ul. 'Et tl'o mai huyoonuye 'ink'ez hiya'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","'Et ndunnah Pharisee hiya'en ibulh, Sizi hiyoodulhkut, “Ngha hoodul'eh dahút'en hubunilh'en ih? K'an dzin nats'ulyis dzin 'uhoont'ah. 'Aw 'et nduhóot'en huba cha'hoot'ah!” ");
INSERT INTO cafNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","'Et Sizi ndo búlhni, “'Et hubudayi cho David daja 'aw ih hukw'e yachasulhtuk? 'Et hoh da David 'ink'ez hiyulh 'ut'en hubuye'élts'ul? ");
INSERT INTO cafNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","'Aw 'et Yak'usda bukoo daninya ndi lhes ndai Yak'usda hubugha it'aih, 'i yu'alh 'ink'ez hiyulh 'ut'en, 'en chah hiyan'al. Nawhulnuk 'aw 'en zeh huyoo'alh huba' hoont'ah, 'et whunts'ih David 'ink'ez hiyulh 'ut'en 'en chah nduhuja. ");
INSERT INTO cafNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","'Ink'ez Moses be' dustl'us chah, 'aw buk'eyáchasulhtuk hoh ih dahni? Ndez na'a njan ndutni, náwhulnuk nats'ulyis dzin luglez whucho dahuníndel 'ink'ez 'et 'uhut'en. Nts'e na'a 'uhuhoolhdzun, 'et k'uhoninyuz, 'et whunts'ih 'aw buk'echahoolts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Whuz na'a ndun whudusni, njan nuhwhutah, 'et 'ilhunuh 'en njan luglez whucho whuch'a degha nus 'ilcho 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","'Et 'uk'e'whusdúguz 'et ndutni, ‘'Uyoon bugha te'untezilh, 'et nuhts'uh hukwa' nuszun. Ndai Yak'usda bukw'uzdai k'ut hidutelhk'un, 'i buka cha'nuszun,’ ni. 'Et ndi njan ndutni, 'et t'eoonahzun t'eh, 'et sih ndan buk'echáwhulhts'it, 'en 'aw buk'ehoh'alh hukwa aht'en ilah! ");
INSERT INTO cafNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","'Et huwa yinkak dune ye' nats'ulyis dzin 'et whunts'ih 'en huMoodihti ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","'Aw 'et hukw'elh'az bughuh whinya hoh ndunnah Lizwif hubuluglez ts'ih daninya. ");
INSERT INTO cafNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","'Ilhunuh dune 'en 'et usda 'ink'ez 'aw bula 'aw ye nucha'ust'en. 'Et Sizi hiyoodulhkut, “'Et nats'ulyis dzin soo na'uztetnilh huba' hoont'ah ih?” 'Et hoonliyaz highu nahooté'alh hukwa' hut'en. ");
INSERT INTO cafNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","'Et ndo búlhni, “Ndan nuhtah 'utenilh sheepyaz tsak'et 'álts'ut hoh hanaítelhtelh nats'ulyis dzin 'et whunts'ih? ");
INSERT INTO cafNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","'Et dawhulcho, 'i be dune sheep degha nus dezti ho' 'int'ah? 'Et huwa netl'awhélts'ut nats'ulyis dzin 'ut'en unzoo, 'i 'uts'ulh'en whuba.” ");
INSERT INTO cafNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","'Et ndun dune nduyúlhni, “Nyla lhk'unadíntsih!” 'Aw 'et lhk'unaidezsi hoh ílhk'uz ts'ih k'una'a sóo na'uja. ");
INSERT INTO cafNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","'Et Pharisee 'az whuhandel 'ink'ez huwu yahalhtuk nts'e na'a hituzelhghelh hukwa. ");
INSERT INTO cafNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","'Et Sizi hituzelhghelh huwu yahalhtuk, 'et t'ewhunanzin ibulh bughuh whenaja. Lhanah nduda hiyuntezdel, 'en ts'iyawh soo naóo'balh'en. ");
INSERT INTO cafNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Khunek ulhtus, 'i be ndo búlhni, “'Uyoon ts'un sughu yaoolhtuk gunih.” ");
INSERT INTO cafNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","'Et nus whunilh'en Isaiah, daja ni, hoh tuné'whust'en. Ndi khunek njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ndun suYe' se'ustlen, 'en 'utahaílhti 'int'ah. 'En buk'esi'. 'En bugha suzul tube yé hoont'i. Suyéghah buk'eidutelhdoh. 'Et nts'e na'a dahoont'ah dune ba nahesyelh, suYe' whuz na'a zeh 'udun yun k'ut whut'en ndo buduténilh. ");
INSERT INTO cafNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","'Aw dune budulhyah 'udooni ghaít'ah. 'Aw hububúlh 'aooldzul ghaít'ah. Ti nuya t'eh, 'aw hubulh dóoltul ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","'Aw tl'oghazilh lhbe né'dujut, 'i whunts'ih k'udóojis ghaít'ah. 'Aw too dezk'un 'aw 'et nanutneh, 'i whunts'ih, 'aw nainoolhneh ghaít'ah. 'Aw 'et Yak'usda lubeshi ba naheyeh 'et whuch'a nilhde t'eh, whuz na'a zeh suYe' 'utet'ilh. ");
INSERT INTO cafNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","'Ink'ez 'udun yun k'ut whut'en ndun suYe' se'ustlen, 'en boozi, 'i be 'et whut'anihíntetan.” ");
INSERT INTO cafNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Njan 'ilhudzin 'et 'ilhunuh ntsi' nududeh buyudínda, 'en chawhés'en 'ink'ez yaoolhtuk chah ghaít'ah. 'En Sizi buts'un lhgha hidílhti hoh soo ná'yinla. 'En 'ahoh yutá'en 'ink'ez yawhenilhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","'Et 'ilhunahuwésdel ts'iyawh tube huba hooncha 'ink'ez dich'oh lhulh yáhaltuk, “'En 'alha David buts'u hainzut tulih 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","'Et Pharisee whulhódants'o hoh 'et 'uhiyulhni, “Ndun Sizi, 'en Beelzebul, ntsi' nududeh bumoodih 'int'ah, 'en be zeh ntsi' nududeh, 'i dune ts'uh hanahinuyukw,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Daja huninzun Sizi t'eooninzun 'et ndo búlhni, “Yun k'ut k'une' huwhul'en, 'en lhch'a nehúdindel t'eh, 'en ts'iyawh hoolah hutele. 'Ink'ez keyah whuti whudune k'us bukoo hudelhts'i chah, ts'iyawh lhch'a nehúdindel t'eh, 'en chah huhoolah hutele. ");
INSERT INTO cafNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Whuz na'a Satan dich'oh dune ts'uh hanainuyukw t'eh, 'et 'alha dich'oh lhch'a detni ho' 'int'ah. 'Ink'ez nts'e na'a hubudayi cho unli, 'ilhuz whutet'ilh? ");
INSERT INTO cafNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","'Et si Beelzebul 'en be 'ust'en t'eh, 'et t'eh sudahni nuhwheni nuhye'kah, k'us ndan simba ntsi' nududeh, 'i dune ts'uh hanaóobunooyukw? 'Et huwa 'en hubugha t'ewhuntehzeh tink'us údahni! ");
INSERT INTO cafNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","'Et whunts'ih Yak'usda buyégha be ntsi' nududeh dune ts'uh hanánusyukw t'eh, 'et 'alha' hoont'ah, nts'e Yak'usda hubudayi cho unli, 'aw 'et nuhghu whults'ut ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","'Et nts'e na'a 'utenilh 'ilhunuh dune 'et dune ulhtus bukoo daninya 'ink'ez hoonliyaz yegho telhchulh? 'Aw 'ooneh ghaít'ah. Ndun dune 'udechoo yulhghel t'eh, 'et t'eh zeh ts'iyaitsuk yegho telhchulh. ");
INSERT INTO cafNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ndunnah sulh cha'it'ah, 'en sch'a hudetni ho' hint'ah. 'Ink'ez ndunnah 'aw dune sula 'ilhuchahowesdle 'en ts'iyawh 'ants'ih yahutedúkulh li'hutenilh. ");
INSERT INTO cafNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“'Et huwa 'un whuhdúsni, lubeshi ts'iyawh 'ink'ez Yak'usda ch'a yalhtuk, 'et ts'iyawh nuhwhuba whunaoodutelnah. 'Et whunts'ih Ndoni ch'a detni be yalhtuk, 'aw buba whunaoodootnah ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","'Ink'ez ndunnah yinkak dune ye' ch'a yalhtuk, daja hutni, soo buba 'un whutelhdulh. 'Et whunts'ih ndunnah Ndoni ch'a yahalhtuk, 'aw buba 'un whutoolhdelh ghaít'ah. K'an dzin k'us nus de whunts'ih 'aw 'uhoneh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mai chun unzoo, 'i hanúlhyeh t'eh, bumai unzoo tele. 'Et mai chun untsi', 'i hanálhyeh t'eh, bumai ntsi' tele. 'Et bumai whuzdli t'eh, dant'i duchun 'int'ah, 'i bumai bugha t'entedzeh. ");
INSERT INTO cafNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nuhwheni ts'iyawh poison tl'ughus buzkeh li'aht'ah! Nts'e na'a ahtsi' 'ink'ez khunek unzoo, 'i be yalhtuk? Nuhdzi ndai be dezbun, 'i be zeh yalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dune unzoo 'en ndai unzoo, 'i budzi tuz 'ilhunayoole, 'aw 'i zeh buts'uh haídukat. 'Et dune untsi', 'en ndai untsi', 'i budzi tuz 'ilhunayoole, 'aw 'i zeh buts'uh haídukat. ");
INSERT INTO cafNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","'Et ndun whudusni ndunnah 'aw khunek cha'it'ah, 'i be yalhtuk, dune ba nahedelh dzin whusawhélts'ut t'eh, nts'e na'a khunek 'i be yalhtuk, whuz na'a buba nahutedeh. ");
INSERT INTO cafNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","'Et huwa nuhghunek bugha Yak'usda nalh ts'ah'un dune tehle, k'us nuhghunek bugha kwuncho yuh ts'ih téhdulh k'una'a, whuz na'a nuhwhuba nahutedeh.” ");
INSERT INTO cafNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","'Aw 'et bulunah Moses be' dustl'us 'uk'ununa'úsduguz, 'ink'ez Pharisee, 'en chah 'uhiyulhni, “Dune hoodulh'eh neba huwa 'et'en tune' tant'en nts'uh hukwa' uzninzun.” ");
INSERT INTO cafNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","'Et ndo búlhni, “K'an ndoh whudezulh dune hintsi', 'ink'ez 'ahoolhyez dune ts'eke bulh tinta' hut'ih. Hoonliyaz hooncha tune' whut'en, 'et zeh hukwa hités'en. 'I bugha t'ehonózin. 'Et whunts'ih honilh'en bughá holts'it ghaít'ah. Nts'e na'a nus whunilh'en Jonah bulh dahooja, 'et zeh hote'ilh. ");
INSERT INTO cafNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Njan dúhooja, tat dzin 'ink'ez tat 'ulh'ek Jonah lhook cho chadánda. 'Et whuz na'a zeh yinkak dune ye' 'en tat dzin 'ink'ez tat 'ulh'ek yun yuh ts'ih tédalh. ");
INSERT INTO cafNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","'Ink'ez wheghah whezulh dzin dune ba nahutedeh t'eh, Nineveh whut'en, nuhwheni k'andoh whudezulh, 'en nuhwhutah di hudutédulh 'ink'ez nuhwhuba nahoteyeh. Soo cho whunulh'en, hoh da Jonah hubulh yailhtuk da, ts'iyawh hububeni lht'anahádunezdla. 'Aw 'et soo zélhts'ai, 'ilhunuh 'en Jonah degha nus 'int'ah k'an nuhtah siyin. ");
INSERT INTO cafNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","'Et wheghah whezulh dzin dune ba nahutedeh t'eh, 'et nyaz de hubudayi cho ts'eke 'en nuhtah didutéyalh, 'et nuhk'ehóotelts'ulh. Ndi yun k'ut nilhdza hainya, Solomon ye whunih, 'i yudutéts'o ka 'et huwa. 'Et whunts'ih 'ilhunuh Solomon degha nus whunih k'an nuhtah siyin.” ");
INSERT INTO cafNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","'Ink'ez ndo búlhni, “'Et ntsi' nududeh dune ts'uh hanádide hoh yun whudezgih, 'et whuz nududeh natelyis hukwu núta. 'Et 'aw nduhóont'ah nachahóo'al. ");
INSERT INTO cafNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","'Et dich'oh na'dudútni, ‘'Et ndun buyudúsda, 'en buts'un zeh natóosja,’ ni. 'Et whuz lhghu nadija hoh 'aw hoonli hoolah. 'Et ndun dune budzi yuh chadítsun nawhulhtsi 'ink'ez ts'ah'un na'a 'uja, 'et nahoo'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","'Ink'ez 'et 'uts'un whedande 'ink'ez skwunlai 'o 'at nanah ntsi' nududeh, 'i 'en degha nus 'ultsi', 'en 'et dune hiyaíndel 'ink'ez 'et nihunina. 'Et ndun dune ndun hiyudalts'i', 'en 'et whutsuh da 'o nus 'ultsi' suli. Nuhwheni k'an ndoh nuhwheghah whudezulh, nuhwheni dune tube untsi' aht'ah, 'et whuz na'a zeh nuhwhuba 'uwhuténilh!” ");
INSERT INTO cafNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sizi 'awhuz 'ilhunahuwésdel hubulh yalhtuk hoh be'ama 'ink'ez bulhutsinkah teh, 'az nahudelhúya. 'Et hiyulh yatelhtuk hukwa' huninzun. ");
INSERT INTO cafNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","'Et 'ilhunuh dune 'uyulhni, “Nilh'en! Nyu'ama 'ink'ez nyulhutsin 'az nahudelhúya nyulh yahutelhtuk hukwa' huninzun!” ");
INSERT INTO cafNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","'Et Sizi ndi yúlhni, “Ndan su'ama, 'ink'ez ndan sulhutsinkah?” ");
INSERT INTO cafNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","'Et Sizi ndunnah yugha hoodul'eh, 'en butune'úlhge, “Nilh'en ndunnah, 'en su'ama 'ink'ez sulhutsinkah 'uhint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Se'aBá 'en yak'uz usda, k'us ndan hik'une' 'ut'en, 'en sulhutsin, sulhtus, 'ink'ez su'ama teh 'uhint'ah!” ");
INSERT INTO cafNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","'Et dzin Sizi koo tininya, 'ink'ez bun taba natl'adeda. ");
INSERT INTO cafNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","'Aw 'et dune lhanah higha wézdel 'et ts'i beinya, 'ink'ez ts'i bet natl'adeda. 'Et ts'iyawh taba 'et nahudelhúya. ");
INSERT INTO cafNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ndai khunek be whuts'odul'eh, 'i 'et lhelhdun huwa hubulh yalhtuk hoh ndo búlhni, “Sih soo zélhts'ai, 'ilhunuh 'a'nule, 'en 'a'ntelelh ts'ih whinya. ");
INSERT INTO cafNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","'Et 'a'nule bulah ti nanánkat. 'I dut'aiyaz whusahándel 'ink'ez ts'iyawh hineldel. ");
INSERT INTO cafNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","'Et bulah tse tah nanánkat, 'et huwa 'i 'ahoh hanusdúki, 'ankw'us yun hoolah huwa. ");
INSERT INTO cafNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bughih hoolah 'et huwa hasain'ai hoh ts'iyawh yanúdezgi 'ink'ez hoolah suli. ");
INSERT INTO cafNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","'Et bulah chah whus tah nanánkat. 'I chah whus cho whutah bulh tanenyi 'ink'ez bulh lhéwhuntlah. ");
INSERT INTO cafNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","'Et 'onghoh, 'i yun unzoo, 'i k'ut nanánkat hoh soo hananyi. Bumai buluh lanezi lanezi (100) bumai suli, buluh lhk'utat lanezi (60) bumai suli, 'ink'ez buluh tat lanezi (30) bumai suli. ");
INSERT INTO cafNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ndan budzo hoonli, 'en soo cho hiyoozólhts'a huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","'Aw 'et yugha hoodul'eh highu nindel, 'et hiyoodulhkut, 'ink'ez 'uhiyúlhni, “Di ka ndi khunek be whuts'odul'eh, 'i be zeh hubulh yaílhtuk?” ");
INSERT INTO cafNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","'Et ndo búlhni, “Yak'uz be k'úne' whul'en 'aw be whe' hoont'ah hooyah, 'i daja ni, nuhwheni zeh nuhghá whunt'ai. 'Et 'onghun 'aw hubugha chahóolts'ulh. 'Et huwa whuz na'a zeh hubulh yalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","'Et huwa njan duhoont'ah, ndunnah hoontsoolyaz t'ehonínzun, 'en 'o nus lhat t'ehonínzun, 'et hubugha whútelts'ulh. 'Et ndunnah hoonli t'ehonízun, hoontsoolyaz, hodits'o ndai 'aw 'i hiyit'i, 'i whunts'ih bughu nayitélchulh. ");
INSERT INTO cafNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'Et huwa ndi khunek be whuts'odul'eh, 'i be zeh hubulh yalhtuk. 'Et doo ka honalh'en 'et whunts'ih 'aw chahonilh'en. 'Ink'ez hidits'o 'et whunts'ih 'aw chahodústs'o, 'aw t'ehonoozeh chah ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","'Et Isaiah nus ho'en daja ni 'en bugha ts'iyawh lhaóodulya. Njan ndutni, ‘'Ahoolhyez whudahts'o 'et whunts'ih 'aw t'echanuzéhze. 'Ahoolhyez whunulh'en 'et whunts'ih 'aw ts'ah'un nechaóozah'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ndunnah dune budzi 'ants'ih buba' hoont'ah suli 'et huwa, 'ink'ez 'aw hoonli hodóts'o hoolah, 'ink'ez ndai be 'alha' hoont'ah, 'i 'aw hinoolh'en hukwa cha'hunízun. 'Et huwa chawhés'en lí'hint'ah. 'Et huwa 'aw honóolh'en ghaít'ah, 'ink'ez budzo be 'aw hodóts'o ghaít'ah. 'Ink'ez budzi be 'aw t'ehonoozeh hoolah. 'Et whuz na'a nducháhit'ah t'eh, 'uda da hubulubeshi ch'a nahulhya wule da, 'ink'ez da Yak'usda huboolhyih,’ ni Isaiah. ");
INSERT INTO cafNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","'Et whunts'ih nuhwheni ndai nuhna be whunulh'en, ts'ah'un na'a whunulh'en. 'Ink'ez nuhdzeh hoh soo whúdahts'o, 'et huwa degha nus hoonzoo nuhghá whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ts'ah'un 'un whúdusni, hoh da lhanah nus whunilh'en 'ink'ez ndunnah ts'ah'un 'uhint'ah, ndai nulh'en, 'i hiyuntelh'ilh hukwa' huninzun, 'et whunts'ih 'aw chahiyí'il! Ndet whudahts'o, 'et soo ts'ah'un hodutéts'o hukwa' huninzun, 'et whunts'ih 'aw chahodíts'il. ");
INSERT INTO cafNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“'Et huwa ndi khunek be whuts'odul'eh, 'i be 'a'nulih, 'en bugha, njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ndunnah yak'uz nts'e na'a 'uhuhoolhdzun whulh 'úhudits'o ndi khunek daja ni hoh 'utni 'et whunts'ih bubeni be 'aw t'ehonuszun. Ndai dune budzi tuz 'ahinanla, 'i ndun ntsi' whusayih 'ink'ez budzi be hanaída'aih! Ndi 'i 'int'ah, ti 'anélya, 'i 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ndi ndai da tse tah 'anilya, 'i ndunnah 'i k'una'a 'uhint'ah. Ndi khunek hidits'o t'eh, 'ink'ez soo 'ahoh huhóont'i hoh hiyilhchukw. ");
INSERT INTO cafNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","'Et whunts'ih dich'oh 'aw bughih hoolah li'hint'ah. 'Et huwa 'astl'iyaz zeh huba 'alha' hoont'ah. 'Ink'ez ndi khunek 'i bugha dzuh nuhudeh 'ink'ez 'onghunnah buch'a hudetni. 'Et huwa 'ahoh whulahudutnih. ");
INSERT INTO cafNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ndai whus tah 'anankat, 'i li'int'ah, 'en ndez na'a 'uhint'ah. 'En khunek hidits'o, 'et whunts'ih ndi yun k'ut huwu ni ts'inli, ndi yun k'ut soo uzde'a 'uhoont'ah, 'et 'i ts'iyawh whus cho 'i be bulh lheyúllhuk ndult'ah. 'Et huwa 'aw lhahúdulya hoole ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","'Et whunts'ih ndet yun unzoo, 'i k'éninkat, 'i li'ínt'ah, 'en ndez na'a njan ndúhint'ah. Ndi Yak'usda bughunek hidits'o, 'i t'ehinuzih teh daja ni hoh 'utni. 'Et huwa bumai lhai lhih li'hint'ah. Bulah lanezi lanezi (100) suli. 'Et doo chah bulah lhk'utat lanezi (60) suli. 'Et doo chah bulah tat lanezi (30) suli.” ");
INSERT INTO cafNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Doo chah 'uyoo khunek be nawhutnuk, 'i be whuts'odul'eh, 'i be hubulh yalhtuk 'et njan ndo búlhni, “Nts'e na'a yak'uz hubudayi cho 'uhuhoolhdzun, 'et dez na'a njan nduhoont'ah. Dune ndi yun buk'ut 'a'nukat. Unzoo, 'i 'anukat, 'i 'ainanla. ");
INSERT INTO cafNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","'Awhuz huztez hoh dune yuch'a detni whusainya. 'Et ndi 'ainanla, 'i unzoo, 'i tah, ndi 'anukat, 'i 'ut'antsi' ts'utni, 'i yutah 'ainanla, 'ink'ez whenaja. ");
INSERT INTO cafNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","'Et ts'iyawh hanányi hoh ndi 'ut'antsi', 'i chah bulh hainanyi. ");
INSERT INTO cafNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","'Et bukoo whumoodih be 'ulhna highu nindel 'ink'ez 'uhiyulhni, ‘Dahooja nemoodih, di hoh inla ndi unzoo, 'i hanuyeh butah 'anánla? Di ho' 'int'ah ndi 'ut'antsi' ndult'ah?’ ");
INSERT INTO cafNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","'Et ndo búlhni, ‘Sch'a detni 'uja.’ 'Et be 'ulhna hiyulhni, ‘Ndi 'ut'an untsi', 'i butah hananyi, 'i hats'úntelelh hukwa' ninzun ih?’ ");
INSERT INTO cafNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","'Et ndo búlhni, ‘'Awundooh! Whute 'int'ah doo ka sih ndi unzoo, 'i chah bulh 'óohneh. ");
INSERT INTO cafNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Whute ndulhdzun ha' untekulh whuts'un. 'Aw 'et ha' nukat neooninzut t'eh, ha' untelelh, 'en si budóosni, 'udechoo 'ut'antsi' hanáhle 'ink'ez ulhghel duték'un huba. 'Ink'ez ndai unzoo, 'i ts'iyawh hanáhle 'ink'ez haníyeh, 'i ba bukoo whuz danáhle.’ ” ");
INSERT INTO cafNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Doo chah 'uyoo khunek be nawhutnuk, 'i be whuts'odul'eh, 'i be hubulh yalhtuk 'et njan ndo búlhni, “Nts'e na'a yak'uz hubudayi cho 'uhuhoolhdzun, 'et ndez na'a njan nduhoont'ah. Ndi mai, mustard hiyulhni, 'i k'una'a 'int'ah. 'I dune yílhchoot 'ink'ez ha'nulhyeh k'et wheyínanla. ");
INSERT INTO cafNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ndi mai soo degha nus ninsol, 'i hanányi 'ink'ez buchun degha nus dincha suli. Ndi mustard hiyulhni buchun, 'i ndai mai chun ts'iyawh 'ut'an hanúlhyeh bugha ndoh suli. 'Et 'i dut'aiyaz buyooschun tah 'ut'o ninínla.” ");
INSERT INTO cafNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Doo chah 'uyoo khunek be nawhutnuk, 'i be whuts'odul'eh, 'i be hubulh yalhtuk 'et njan ndo búlhni, “Nts'e na'a yak'uz hubudayi cho 'uhuhoolhdzun, 'et ndez na'a njan nduhoont'ah, lhes ntuldoh, 'i ndult'ah. Ts'eke yílhchoot 'ink'ez lhes nudzaih, 'i tat tests'ai be lhtayudzih, 'i dezbun. 'Et yunélhus, 'ink'ez 'udun ninínkai hoh untéldoh.” ");
INSERT INTO cafNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ndi ts'iyai, 'i khunek be nawhutnuk, 'i be whuts'odul'eh, 'i 'et whuz na'a zeh Sizi 'ilhunahuwúdulh hubulh yailhtuk. 'Aw 'uts'un na'a cha'budínil. 'Et ndez na'a zeh hubudáni. ");
INSERT INTO cafNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","'Et whuz na'a ndun nus whunilh'en daja dani, 'et ts'iyawh lhaóoduja hoh njan ndutni, “Khunek be nawhutnuk, 'i be whuts'odul'eh, 'i be hubulh yatelhtuk. Nts'oh huwa whudezulh hoh ndi yun 'uyínla 'et whuts'un, ndai buch'a yuntez'i, 'i bugha hubudutésnilh.” ");
INSERT INTO cafNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","'Et Sizi 'ilhohuwezdel, 'en ts'iyawh whenábalh'a 'ink'ez koo danínya. 'Et yugha hoodul'eh highu nindel 'ink'ez 'uhiyúlhni, “Ndi khunek be nawhutnuk, 'i be whuts'odul'eh, 'i ts'ah'un na'a nedini ndi haniyeh, 'i unzoo, 'i tah 'ut'an ntsi' hananyi, 'i 'et daja ni hoh 'utni?” ");
INSERT INTO cafNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","'Et ndo búlhni, “Ndai unzoo, 'i hanányi bumai 'i, ndun 'ainanla, 'en yinkak dune ye' 'en 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Haniyeh k'et, 'et ndi yun k'ut nduwhúlt'ah ho' hoont'ah. Ndi mai unzoo, 'i yak'uz hubudayi cho buzkeh, 'en nduhúlt'ah. 'Et whunts'ih ndi 'ut'an ntsi', 'i ntsi' buzkeh nduhúlt'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","'Ink'ez ndun yuch'a detni, ndi 'ut'an ntsi' 'ainanla, 'en netsudule. Njan ha'nukat 'et ndóh yun k'ut ts'udelhts'i whulatah 'et 'uhóont'ah. Ndunnah ha' úntelelh, 'en lizas nduhult'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","'Et huwa nts'e na'a ndi 'ut'an ntsi' nahidulhdzooh 'ink'ez hidelhk'un, whuz na'a zeh njan k'an ndoh whudezulh whulatah t'eh chah, nduwhutenilh. ");
INSERT INTO cafNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","'Ink'ez yinkak dune ye', 'en bulizas nduhóolcho ts'ih whutl'abutelelh. Nts'e hubudayi cho unli, ndunnah hukwaya hoonli tune' 'úst'en, 'en 'ink'ez yuk'unucha'ust'en, 'en ts'iyawh 'ilhunaoobotélelh. ");
INSERT INTO cafNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nts'e kwun dezk'un huba' hoont'ah, 'et whuz hubatelhdulh. 'Ink'ez tso yahutelhtuk 'ink'ez hubughoo lhuhidutek'us. ");
INSERT INTO cafNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","'Et dzin nts'e na'a sa hadánat, ndunnah ts'ah'un na'a 'int'ah, nts'e be'aBá hubudayi cho unli, 'en chah whuz na'a zeh sa k'una'a buts'u haíteduz ho' hoont'ah. Ndunnah budzo hoonli, 'en soo cho hiyoozólhts'a huba' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Doo chah zeh 'ún whudusni, yak'uz k'úne' whul'en, daóodelti, 'et ndez na'a njan ndúhoont'ah. Ndun dune njan yun k'ut hoonzoo, 'et nunúta hoonliyaz dezti, i nayí'ai. 'Ink'ez 'onghoh nayuntelh'i. 'Et hoont'i k'et ndun dune ndai hoonli yit'i, 'i ts'iyawh ye 'ónket 'ink'ez ndi yun yuk'ut nayi'ai, 'i yun ndulhcho whe yonket. ");
INSERT INTO cafNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Doo chah zeh 'ún whudusni, yak'uz k'úne' whul'en, daoodelti, 'et ndez na'a njan nduhoont'ah. 'Et doo chah 'uyoon dune, 'en hoonliyaz 'i ts'iyawh yooket. 'Et 'o 'un doo chah ye ná'oonket. 'En kw'usul k'us dunezti, 'i hikunuta. ");
INSERT INTO cafNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","'En 'ilho kw'usul k'us dunezti, 'i naini'ai. Ndun dune ndai hoonli yit'i, 'i ts'iyawh ye 'ónket hoh ndi kw'usul k'us dunezti, 'i yoonanket. ");
INSERT INTO cafNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“'Et doo chah zeh 'ún whudusni, yak'uz k'úne' whul'en, 'et ndez na'a njan ndúhoont'ah. Ndez na'a 'uhut'en, lhoombilh tahíyalhdel 'ink'ez yanáhiyigus lhawh dédowh 'i hiyuzdlooh. ");
INSERT INTO cafNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","'Et yahíyuzguz ts'iyawh lhtahahíyule. Ndai lhook untsi', 'i ts'iyawh 'un whehíyulhdelh. 'Ink'ez ndai unzoo, 'i ts'iyawh nts'e 'uhitelh'ilh ts'ú whehiyulhdelh. ");
INSERT INTO cafNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","'Aw 'et nts'oh whúdezulh hoh huba neóoni'ai, 'et huba whusawhélts'ut t'eh, 'et hukw'un'a zeh 'uwhuténilh. Lizas whusahutedulh, 'en ts'iyawh dune hinzoo 'ink'ez dune hintsi' lhtahábotelelh. ");
INSERT INTO cafNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ndunnah hintsi', 'en nts'e kwun dezk'un huba' hoont'ah, 'et whuz hubotelhdulh. 'Ink'ez tso yahutelhtuk 'ink'ez hubughoo lhuhidutek'us.” ");
INSERT INTO cafNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","'Aw 'et Sizi ndo búlhni, “Njan ndun whudusni, 'et ts'iyawh ih t'eoonáhzun?” 'Et 'uhiyúlhni, “A, neMoodihti, ts'iyawh t'ets'oninzun.” ");
INSERT INTO cafNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","'Et ndo búlhni, “'Et huwa ndan Yak'usda bughunek 'uk'e'eduguz, 'i 'ink'ez yak'uz k'une' whul'en 'et hubugha wheyodalh'i, ndun dune 'en bukoo whumoodih, 'en ndult'ah. 'Ink'ez ndai yit'i, 'i tah ts'iyawh ts'et hayúle, k'an, 'i 'ink'ez 'uda, 'i chah. 'Et whuz na'a dune hoodulh'eh.” ");
INSERT INTO cafNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","'Et ndi khunek be nawhutnuk, 'i be whuts'odul'eh, 'i 'aw 'et Sizi ts'iyaintsuk lhaoodinla hoh njan usda 'et whuch'a nanja. ");
INSERT INTO cafNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","'Ink'ez dich'oh bukeyah ts'ih whénaja hoh Lizwif hubuluglez 'et wheóobudunilh'i. Et ts'iyannah huba hooncha suli, 'ink'ez 'ulhódutni, “Ndun dune nts'ez de hahó'ai ndi khunek whunih, 'i be yalhtuk? 'Ink'ez hooncha tune' 'ut'en nts'e na'a dat'en hoh 'ut'en? ");
INSERT INTO cafNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","'Alha ilah bukoo 'uwhulh'en, 'en buye' 'int'ah? 'Ink'ez 'en ilah be'ama Mary? K'us bulhutsinkah 'en James, Joses, Simon, 'ink'ez Judas? ");
INSERT INTO cafNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","'Et bulhtuskah 'aw ts'iyawh nelh cha'hit'ah? 'Et ndun dune ndi ts'iyawh nts'ez de hahónla hoh 'utni?” ");
INSERT INTO cafNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","'Et huwa ts'iyawh hits'u desnih. 'Et Sizi ndo búlhni, “Ndun nus whunilh'en unli, 'en ts'iyannah yudelhti. 'Et whunts'ih dich'oh bukeyah whut'en 'ink'ez dich'oh bukoo, 'en chah 'aw chahidílhti.” ");
INSERT INTO cafNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","'Et Sizi 'en 'aw buba 'alha' cha'yít'ah. 'Et huwa dich'oh bukeyah 'aw lhat hooncha tunucha'ít'il. ");
INSERT INTO cafNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","'Et hoh da wheghah whudezulh hoh hubudayi cho Herod 'en Sizi yulh údants'o. ");
INSERT INTO cafNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","'Et Herod bube 'ustl'en ndo búlhni, “Ndun John dune too be 'ulh'en, 'en 'int'ah. Yaidla tah nakhitna. 'Et huwa 'ut'en hoolhtus tune'út'en.” ");
INSERT INTO cafNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ndez na'a 'uhooja hoh da Herod John hiyílhchoot, hiyulhghel 'ink'ez tsak'e híya'ai. Bulhutsin Philip hiyulhni, 'en bu'at Herodias hiyulhni, 'en bula gha ts'ih 'uhiyínla. ");
INSERT INTO cafNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","'Et John 'en Herod ndi yulhni, “'Aw nyun mba ts'ah'un na'a cha'hoot'ah hoh 'uyoon bu'at buzih sinda.” ");
INSERT INTO cafNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","'Et Herod yutuzelhghelh hukwa' ninzun. 'Et whunts'ih ts'iyannah dune John 'en nus whunilh'en 'int'ah huninzun, 'et huwa Herod whenelhújoot. ");
INSERT INTO cafNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","'Et 'ilhudzin 'et Herod whuzdli dzin 'uhoont'ah hoh Herodia butse' 'en hububut nunúdaih. Herod tube buba hoonzoo. ");
INSERT INTO cafNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","'Et 'ahoh hits'u náhezya hoh ndi yúlhni, “Ndet sts'o hukwa' ninzun sts'o hukwa' dini.” ");
INSERT INTO cafNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","'Et ndun ts'eke be'ama, 'en, “Herod oodílhkut John dune too be 'ulh'en butsi lusyet be stl'ainkaih dóni,” yulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","'Et hubugha hubudayi cho budzi únduda suli. 'Et ts'iyannah ndunnah yuzih hudelhts'i, 'en ts'iyawh hidánts'o, 'et ts'ekeyaz bughunek yutl'aida'ai. 'Et huwa whuz na'a 'uhiyooleh huba' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","'Aw 'et nts'e tsak'esda ts'ih whuz wheyálh'a, 'ink'ez tsak'esda ghuhinli, 'en John hitsi k'unéntsel. ");
INSERT INTO cafNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","'Ink'ez lusyet be whusahíyankai, 'ink'ez ndun ts'ekeyaz tl'ahíyankai. 'Ink'ez be'ama yughah níninkai. ");
INSERT INTO cafNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yugha hoodul'eh, 'en whusahandel. Hiyust'e hiyilhchoot 'ink'ez whuyihiyalhti. 'Et hukw'elh'az Sizi ts'un whehandel 'ink'ez nduhídani. ");
INSERT INTO cafNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","'Et Sizi whulh uduzts'ai hoh buch'a nanja 'ink'ez ts'i be inya 'ink'ez nts'e dune nuchasyah ts'ih whuz whénki. 'Et whunts'ih lhanah dune t'ehonanzin ibulh nts'e whénki ts'ih, whuz lhelhdun keyah whut'en whehínandel. ");
INSERT INTO cafNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","'Et Sizi ts'i bé hainya hoh dune soo ts'ah'un hulai 'aw 'uzdooni ghaít'ah, 'en bunilh'en. 'Et 'ahoh hubugha té'nanzin 'ink'ez nduda chah ts'iyawh soo na'binla. ");
INSERT INTO cafNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","K'an 'aw 'et hulhgha 'uhoont'ah 'et huwa yugha hoodul'eh, 'en highu nindel 'ink'ez 'uhiyúlhni, “Njan dune nuchasyah 'uhoont'ah. 'Aw 'et ye 'un whezulh. Ndunnah ts'iyawh 'uts'un keyah ts'ih naoobélh'alh, 'et whuz hite'alh, 'i hiyoket.” ");
INSERT INTO cafNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","'Et whunts'ih Sizi ndo búlhni, “'Aw nahutoodelh huba cha'hóot'ah. Nuhwhenich'oh hubugha ná'nuht'aih.” ");
INSERT INTO cafNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","'Et 'uhiyúlhni, “'Aw hoonliyaz chats'it'ih. Lhes skwunlai 'ink'ez lhook nankoh, 'aw 'i zeh ts'it'i.” ");
INSERT INTO cafNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","'Et ndo búlhni, “De' sugháh ninahle!” ");
INSERT INTO cafNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","'Et ndunnah 'ilhunahuwésdel, 'en ts'iyawh tl'oyaz k'ut natl'ahudoolts'ilh hubúlhni. 'Et ndi skwunlai lhes 'ink'ez nankoh lhook chah, 'i hitl'ahíyanla, nduk yetá'en hoh suchanailya ni tenadedli. Lhes taidalhkut 'ink'ez lhook 'i chah ndíyinla 'ink'ez yugha hoodul'eh butl'ayánla, 'ilhohuwezdel hubugha híyoo'alh ka. ");
INSERT INTO cafNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","'Et ts'iyawh 'uhan'al 'ink'ez 'uhunesdai. Ndai ts'ih tezkat 'i ts'iyawh 'ilhunahiwezdla hoh lanezi 'o 'at nankoh (12) ts'its'ai dezbun. ");
INSERT INTO cafNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","'Et ndunnah dune, 'en 'ankw'us 5000 'uha'al. 'Et 'uskeh 'ink'ez ts'ekoo 'en chah 'uha'al. ");
INSERT INTO cafNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","'Aw 'et Sizi yugha hoodul'eh ts'i tuz whenaóobalh'a hoh, “Sutsuh nyan ahkelh,” hubúlhni. 'Ink'ez 'ilhunahuwésdel, 'en chah dukeyah ts'ih whenaóobalh'a. ");
INSERT INTO cafNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","'Aw 'et ndunnah ts'iyawh whenaóobalh'a hoh dich'oh ndoh dzulh k'uz whinya tenadutedli ka. Dich'oh únli hoh bé nadalhghel. ");
INSERT INTO cafNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","'Aw 'et ts'i bun k'ut taniz hoh wheghah tatsi cho be nilhts'i be hubududezts'i. 'I be ts'i hoh nudúlduz. ");
INSERT INTO cafNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","'Aw 'et bundada haootélh'en hoh Sizi too k'ut buts'u tezya. ");
INSERT INTO cafNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","'Et khunyaz yugha hoodul'eh hitelh'en hoh whehunelhújoot, “Dune tsen 'ut'en!” hutni ibulh tsoya whehúnilhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","'Et 'ahoh Sizi hubulh yatelhtuk, “Nuhdzi ulhtus úlhtsi! Si 'ust'en! Whenulhujut ílah!” ");
INSERT INTO cafNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peter ndez na'a yoodulhkut, “SMoodihti 'alha nyun 'int'en t'eh, too k'ut nts'u toosya stl'ahóo'aih.” ");
INSERT INTO cafNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","'Et 'ahoh ndi yúlhni, “'Anih!” 'Aw 'et Peter ts'i be hainya 'ink'ez Sizi too k'ut yuts'u teyalh ka. ");
INSERT INTO cafNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","'Et nyo whunilh'en hoh nilhtsi tube ulhtus 'ink'ez whenelhújoot 'ink'ez yuk tezdlat hoh, “SMoodihti, sula 'ineh!” yulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","'Et 'ahoh Sizi yula dughélchoot hoh ndi yulhni, “'Aw soo 'ultsuk, 'i be 'alha' hoont'ah, 'i chaint'ih. 'Et dahoont'ah huwa mba nawh 'uhoont'ah?” ");
INSERT INTO cafNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","'Et ts'i be nahét'az hoh 'ahoh nilhts'i k'ah na'ja. ");
INSERT INTO cafNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","'Et ndunnah ts'i be hudelhts'i, ts'iyawh hibut nachánilya 'ink'ez 'uhiyulhni, “'Alha nyun Yak'usda buYe' 'unínt'ah!” ");
INSERT INTO cafNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","'Aw 'et nyan Gennesaret ts'ih yahuzki hoh, ");
INSERT INTO cafNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","'et keyah whut'en Sizi hitelh'en ibulh, nahiyoolhúts'it hoh lhtunahunek hust'ai. 'Ink'ez ts'iyawh nduda, 'en hits'ún lhgha hobodinla. ");
INSERT INTO cafNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hits'utédudlih, “Ndai nyunaih naints'uz, 'i 'ants'ih yus ts'ih but'áts'ughoonalh,” hiyulhni. Ts'iyawh ndan hit'aghéznai, 'en ts'iyawh ts'ah'un na'a soo ná'huja. ");
INSERT INTO cafNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","'Aw 'et Jerusalem keyah whuts'un ndunnah Moses be' dustl'us 'uk'ununa'úsduguz 'ink'ez Pharisee, 'en chah ts'iyawh Sizi highu nindel 'ink'ez 'uhutni, ");
INSERT INTO cafNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“'Et di ka ngha hoodul'eh, netsuh whudelhdzulh 'uda ne'whust'en hukw'u na'a 'aw hukw'unucha'hust'en? Whunilh'en, ndunnah ngha hoodul'eh, 'aw lanacha'hulhúde 'uhute'alh whutsuh!” ");
INSERT INTO cafNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","'Et ndo búlhni, “'Et di ka nuhwhenich'oh nuhk'ah ts'ih huwa Yak'usda bughunek buk'unucha'zaht'en? ");
INSERT INTO cafNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Whunulh'en, nuhwheni nts'e na'a ndaht'en! Yak'usda bughunek nuhtl'aida'ai hoh njan ndutni, ‘Nyu'abá 'ink'ez nyu'ama bulh hubudóolhti.’ 'Et doo chah 'udun 'et njan ndutni, ‘Ndan be'ama 'ink'ez be'abá bulh dzuh ts'ih bughu yatelhtuk, 'en daootsah huba' hoont'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","'Et whunts'ih nuhwheni ndez na'a 'udahni, ‘Ndan be'abá k'us be'ama njan ndo búlhni, ndai 'ust'i, 'i be da nuhla 'oost'en wule, 'et whunts'ih 'i ts'iyawh Yak'usda bugha iníla.’ ");
INSERT INTO cafNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","'Et whuz na'a nuhwhe'ut'en k'ah be 'aw be'ama 'ink'ez be'abá bulh chabudílhti. 'I be Yak'usda bughunek nuhtl'aida'ai, 'i 'aw hoonliyaz chailah sulhtsi! ");
INSERT INTO cafNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nuhwheni duba náhdzoo ahli! Ndun nus whunilh'en Isaiah, 'en 'uda ho'en 'ink'ez ts'ah'un na'a 'utni nuhwheni nuhwhugha. Njan 'et njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ndunnah dune bughunek be buzek be sudélhti. 'Et whunts'ih budzi sughun nilhdza 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ndunnah doo ka 'ants'i 'et suts'un teni 'uhunoolhzin. 'Ink'ez ndet dune bube 'ut'en k'ah, 'i Yak'usda bughunek netl'aida'ai, 'i k'una'a 'uyoon hubuhoodoolh'eh ka' 'uhut'en.’ ” ");
INSERT INTO cafNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","'Et Sizi 'ilhunahuwésdel ndo búlhni, “'Anih! Ndez áhdulh!” 'Et ndo búlhni, “Soo zélhts'ai 'ink'ez soo cho nt'eoonahzeh! ");
INSERT INTO cafNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ndai dune buzai yúkat, 'i 'aw 'et ílah hintsi' hulhih. 'Et whunts'ih ndai khunek 'aw chaizooh, 'i dune ye yalhtuk, 'i be dune hintsi' 'ulhih.” ");
INSERT INTO cafNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","'Et yugha hoodul'eh highun nindel hoh 'uhiyúlhni, “T'eoonínzun ih ndunnah Pharisee nyudánts'o daja dini, 'et nduhóolcho huba dzuh 'údenja?” ");
INSERT INTO cafNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","'Et Sizi ndo búlhni, “'ABá yak'uz usda, ndai 'aw whuyuchaínilel, 'i bughih tubulh hahítelhch'ulh. ");
INSERT INTO cafNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Whute! Ndunnah 'aw buts'áhachaoozah'aih! 'En moodih chawhés'en li'hint'ah. 'Et ndez na'a njan nduhoont'ah, 'ilhunuh chawhés'en 'ink'ez 'ilhunuh chawhés'en ghunli t'eh, nahúlt'ah tsa k'et hutelts'ulh.” ");
INSERT INTO cafNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","'Et Peter yoodulhkut, “Ndi be nawhutnuk 'i be whuts'odul'eh, 'i nts'e na'a daja ni, 'et ts'iyawh whenénilhtun.” ");
INSERT INTO cafNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","'Et ndi yúlhni, “'Aw ih nuhwheni tachaoodulhts'it hoh ih dahni? ");
INSERT INTO cafNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","'Awhuz ih ts'ah'un nechaóozah'ak? Dune ndai buzai yúkat, 'i ts'iyawh bubut zeh be yukat. 'Ink'ez buyust'e ts'ih hanádukat. ");
INSERT INTO cafNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","'Et ndai dune khunek be yailhtuk, 'i budzi ts'ih hayúkat 'i 'int'ah, 'ink'ez 'i dune dilhtsi'. ");
INSERT INTO cafNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Soo cho whunulh'en, ndi 'et ndunt'ah, 'i dune budzi tuz hayúkat, be ne-eni untsi', 'i dune hutuzelhghelh, 'uyoon dune bu'at k'us 'uyoon ts'eke buki bulh tinta' ant'en, 'ink'ez 'aw lhughudelhúts'i whunts'ih whuz na'a zeh ne'hut'en. 'Uhudunut'ih, 'uyoon ba huwhuts'it, 'ink'ez Yak'usda ch'a yahulhtuk chah. ");
INSERT INTO cafNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","'Et njan 'et ndúhoont'ah, nduhoolhchoh dune hintsi' hulhih. 'Et 'aw lanacha'zulhude hoh 'ah'alh, 'aw 'et huwa ilah hintsi' 'ulhih.” ");
INSERT INTO cafNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","'Aw 'et Sizi njan usda whuch'a nanja hoh Tyre keyah 'ink'ez Sidon keyah wheghah nánja. ");
INSERT INTO cafNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","'Et whuts'un 'ilhunuh ts'eke, 'en Canaan whut'en 'int'ah, 'en yughu ninya. Tso bulh yalhtuk ho 'uyulhni, “SMoodihti sugha te'ninzeh, t'enyunúszun David buts'u hainzut 'unint'ah! Sutse', 'en ntsi' nududeh, 'i buyídinda!” ");
INSERT INTO cafNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","'Et 'aw daja chaidínil. 'Et yugha hoodul'eh highu nindel 'ink'ez 'uhiyúlhni, “'Un nailh'alh, 'et tso bulh yalhtuk 'ustl'e' 'udóoneh sih.” ");
INSERT INTO cafNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","'Et Sizi, 'en ndun ts'eke 'uyúlhni, “Ndunnah Israel bukoo whut'i, 'en 'ants'ih sheep tinta nílh'az, 'i li'int'ah, 'en zeh buts'un whests'alh'a.” ");
INSERT INTO cafNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ndun ts'eke 'en yughu ninya hoh yubut nachaneti 'ink'ez, “SMoodihti, sula 'ineh!” yulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","'Et Sizi 'uyúlhni, “'Uskehkah lhes híyu'alh, 'i lhiyazkah hubugha ts'iya'aih t'eh 'aw chahóozooh.” ");
INSERT INTO cafNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","'Et ts'eke ndi yúlhni, “SMoodihti 'alha' dini. 'Et whunts'ih ndai moodihti bukw'uzdai k'ut tukat, 'i lhiyazkah hiyeldel.” ");
INSERT INTO cafNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","'Et Sizi ndi yúlhni, “O ts'eke ndi mba be 'alha' hoont'ah, 'et hooncha ho' hoont'ah. 'Et huwa hukwa' ninzun k'una'a 'uhoneh.” 'Et soo ndoh wheghah whezulh, buts'e' soo na'uja. ");
INSERT INTO cafNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","'Aw 'et Sizi bughu natesja Galilee bun ghah lhunásja hoh, ndoh dzulh k'uz whenya, 'et natl'adeda. ");
INSERT INTO cafNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","'Et khunyaz lhanah dune, 'en highu nindel. Ndunnah nuchahúsdel, chawhés'en, yachahulhtuk, buyust'e hubodi'ai, 'ink'ez 'uyoon chah, 'en ts'iyawh hits'un hubuninla. Hibut nebaninla 'ink'ez ts'iyawh soo ná'hubínla. ");
INSERT INTO cafNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yachahulhtuk chah yawhehunilhtuk, buyust'e hubodi'ai, 'en chah soo na'huja. Nucháhsdel chah nahúdelh nahusdli, chahuwhés'en chah honilh'en nahusdli. Ts'iyannah bunalh'en hoh tube huba hooncha 'ink'ez Israel budune, 'en buYak'usda 'en 'o nus hidálhti. ");
INSERT INTO cafNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sizi yugha hoodul'eh, 'en 'anih hubúlhni 'ink'ez ndo búlhni, “Ts'iyawh ndunnah dune hubugha té'nuszun. Tat dzin whuts'un njan suzih hudelhts'i 'ink'ez 'aw huya'alh, 'i chahít'ih. 'Et 'aw cha'hus'al hoh bukeyah ts'ih nabutoolh'a ghaít'ah. 'Et ndúbusdla t'eh, nahedulh hoh sih bukaootoozit.” ");
INSERT INTO cafNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yugha hoodul'eh hiyulhni, “Njan keyah 'aw dune hoolah 'uhoont'ah. Nts'ez de simba soo 'últsuk, 'i tet'alh, 'i nats'óolelh dune lhe'huneltsuk lah?” ");
INSERT INTO cafNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","'Et Sizi ndo búlhni, “Daltsuk lhes sut'e aht'i?” ‘Skwunlai 'o at nankoh 'i lhes sut'e 'ink'ez lhook nsolyaz bulh,” hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","'Et 'ilhuhowezdel, 'en natl'adulhúts'ih hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","'Et ndi lhes skwunlai 'o at nankoh (7) lhook bulh yílhchoot 'ink'ez suchanailya ni hoh tenadidli. Taidalhkut 'ink'ez yugha hoodul'eh butl'ayánkai. 'I ts'iyawh natl'ahudelts'i, 'en butahíninik. ");
INSERT INTO cafNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ts'iyawh na'het'al 'ink'ez 'uhunesdai. 'Et yugha hoodul'eh skwunlai 'o at nankoh k'its'ai dezbun 'i highá' wez'al, 'i 'ilhunahiwezdla. ");
INSERT INTO cafNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","4,000 dune bat'en 'uha'al. 'Uskiyaz 'ink'ez ts'ekoo 'en chah 'uha'al. ");
INSERT INTO cafNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","'Aw 'et Sizi 'ilhunahuwésdel bukeyah ts'ih whuz whenaóobalh'a, 'et ts'i be naja 'ink'ez yun Magdala huwhutni ts'ih whuz whehánki. ");
INSERT INTO cafNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","'Aw 'et ndunnah Pharisee 'ink'ez Sadducee chah, 'en highu nindel 'ink'ez hiyóolhdzih hoh hiyoodulhkut, “'Aw ih yak'uz whuts'un hooncha tune' whut'en, whunénolhtun ghaít'ah?” ");
INSERT INTO cafNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","'Et ndo búlhni, “'Et hulhgha ts'ih nduk whunulh'en. 'Et whudulk'un t'eh, 'et dzin hoonzoo tele dahni. ");
INSERT INTO cafNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","'Et bundada kw'us bulh dulk'un suli whunulh'en t'eh, 'aw 'et zeh whudutetsi' dahni. Nuhwheni duba nahdzoo ahli! 'Et nduk dawhut'en, 'et t'eoonáhzun. 'Et whunts'ih ndoh whugha whudezulh dawhut'en, 'et ndet 'uwhulhni, 'aw t'eoonuzáhzun! ");
INSERT INTO cafNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Njan k'an ndoh whudezulh, 'en lubeshi ts'un ne'hut'en 'uhint'ah. 'Ink'ez 'ahoolhyez dune ts'eke bulh tinta' hutet'ilh, 'et zeh whuts'un hunint'uk. 'Ink'ez hooncha huwa 'ét'en whuntelh'ilh hukwa' nahzun. 'Et whunts'ih 'aw hooh'en nuhghu hólts'it ghaít'ah. 'Et nts'e na'a Jonah bulh dáhooja inle, 'et zeh whuteh'ilh ho' hoont'ah!” hubúlhni, 'ink'ez bughu whenája. ");
INSERT INTO cafNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","'Aw 'et nyan yahuzki hoh yugha hoodul'eh lhes nahodelhúnah. ");
INSERT INTO cafNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","'Et Sizi ndo búlhni, “'Ahoolhyez wheni khahdli ndunnah Pharisee 'ink'ez Sadducee chah, 'en bules untuldoh, 'i ch'a.” ");
INSERT INTO cafNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","'Et 'ahoh lhulh yawhehunilhtuk, “'Et 'aw lhes chats'ít'ih 'et huwa 'utni.” ");
INSERT INTO cafNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","'Et Sizi t'eoonanzin, 'et ndo búlhni, “Nuhwheni be 'alha' hoont'ah, 'i unsol! 'Et huwa 'udahni. 'Aw lhes whusachah'al, 'et huwa ih 'et howu yalhtuk? ");
INSERT INTO cafNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","'Awhuz ih 'aw ts'ah'un t'eoonuzahzun? 'Aw whunachazulhunik hoh ih skwulai lhes 'i be 5,000 hubugha náh'ai, 'ink'ez daltsuk k'its'ai ts'utezkat, 'i 'ilhunawehla? ");
INSERT INTO cafNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","'Et doo chah skwunlai 'o at nankoh lhes 'i be 4,000 hubugha ináh'ai, 'et daneltsuk k'its'ai ts'uhtézkat, 'i 'ilhunawehla? ");
INSERT INTO cafNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","'Et nts'e na'a aht'ah t'eoonuzahzun, 'aw lhes hubugha nohwhulh yachasulhtuk? 'Uda ndun whudúsni, ndunnah Pharisee 'ink'ez Sadducee chah, 'en bules untuldoh, 'i bughohle, 'i bughi yálhtuk ho' dusni.” ");
INSERT INTO cafNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","'Et 'ahoh t'ehoninzun ndunnah Pharisee 'ink'ez Sadducee chah, dune huhodulh'eh, 'et whuch'a buch'a huwahli, 'et 'uwhulhni. Ndi lhes bulh untuldoh, 'i ch'a huwahli ni ilah hoh 'utni. ");
INSERT INTO cafNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","'Et Sizi Caesarea Philippi buyun k'uz whinya hoh yugha hoodul'eh, 'en huboodulhkut, “Si yinkak dune ye' 'ust'ah. 'Et whunts'ih n'awh dune, ndan hoh 'ust'ah hutni?” ");
INSERT INTO cafNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","'Et 'uhiyúlhni, “Bulunah, 'en nyun John dune too be 'ulh'en 'int'ah hutni. 'Et bulunah chah, nyun Elijah 'int'ah hutni. 'Et 'onghunnah chah, nyun Jeremiah 'int'ah hutni. 'Ink'ez bulunah nyun nus whunilh'en 'ilhunuh 'int'ah hutni.” ");
INSERT INTO cafNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","'Et ndo búlhni, “Nuhwheni do, ndan 'ust'ah dahni?” ");
INSERT INTO cafNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","'Et Simon Peter yatelhtuk hoh ndi yúlhni, “Nyun ndun Christ, Yak'usda khuna, 'en buYe' 'unint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","'Et Sizi ndi yúlhni, “Simon Jonah buye', degha nus hoonzoo nghá whults'ut! Ndet sudini, 'et 'aw ndi yun k'ut dune, 'en ilah nyunalhts'et hahó'ai. Se'aBá yak'uz usda, 'en nyunalhts'et haho'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","'Ink'ez nyun Peter 'int'ah. 'Et ndi tse 'i k'ut suluglez neootes'alh. Njan ndun kwuncho ulhtus, 'i yuh ts'ih haindel, 'en whunts'ih 'aw whuch'a' hoolhdeh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nts'e yak'uz hubudayi cho usda, whuz be da'dutut'aih, 'i ntl'ates'alh. 'Et ndi yun k'ut ndai whedinguz, 'i 'et 'uda yak'uz chah whuz na'a zeh whedint'uk. 'Et ndai ndi yun k'ut k'unada'uk, 'i 'et yak'uz chah 'uda whuz na'a zeh k'una'tet'uk.” ");
INSERT INTO cafNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","'Et yugha hoodul'eh khunekti be ndo búlhni, “Khun teh 'uyoon dóohni gunih, si Sizi ndun Christ, 'en 'ust'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","'Et wheghah whezulh whuts'un Sizi yugha hoodul'eh, 'en wheóobunulhtun nus daootenilh 'et. Nts'e na'a Jerusalem ts'ih teyalh. 'Et keyah ndunnah dune netsuh whudelhdzulh, 'ink'ez náwhulnuk bumoodih, 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz chah, 'en bube lhat hoh dzuh nuhítelhdzut, 'ink'ez hituzelhghelh. 'Et whulh tat dzin, 'et dinadutédalh. ");
INSERT INTO cafNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","'Et Peter, 'en Sizi yílhchoot, 'udun neínilhti 'ink'ez hukwa' yudáni, “SMoodihti nyun Yak'usda ngha te'untezeh! 'Aw nyulh 'et ndúhoneh ghaít'ah!” ");
INSERT INTO cafNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Peter yuts'un nalhú'a 'ink'ez ndi yúlhni, “Satan sut'ak ninínyih! Nyun yooya suzilhts'i! Yak'usda nts'e na'a dat'en, 'et 'aw howu nuni chanuzinzut. Ndi yun k'ut dune nts'oh tuné'hut'en, 'et hukw'una'a zeh nuni ninzut!” ");
INSERT INTO cafNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","'Et Sizi yugha hoodul'eh ndo búlhni, “Ndan dune se'ut'en k'ah oot'en ka sunteyalh hukwa' ninzun t'eh, ndi yun k'ut dats'ínt'ah, 'et ts'iyawh whula dootnih, 'ink'ez dulhdulalhgus yóolhchoot 'ink'ez suntooya. ");
INSERT INTO cafNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","'Et huwa ndan ye khuna hotelhyih hukwa' ninzun t'eh, 'en tinta hóte'alh. 'Et whunts'ih ndan ye khuna si sugha tinta ooní'ai t'eh, 'en ye khuna 'i nahíte'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","'Et huwa dune ndi yun 'i ndulhcho bube'ildzun yúzdli t'eh, 'ink'ez duzul 'i tinta iní'ai t'eh, ndet buba whutézoo? 'Ink'ez dich'oh duzul nayitélcholh hukwa' ninzun t'eh, di k'elha simba duzul nahíyoket? ");
INSERT INTO cafNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","'Et huwa yinkak dune ye' whusateyalh, ndai be'aBá ye dezti, 'i 'ink'ez bulizas, 'en hubulh, 'et whusainya t'eh, nts'e na'a ts'iyannah dahét'en, whuz na'a 'ilhunah hoh buba k'elha whutele. ");
INSERT INTO cafNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Soo ts'ah'un na'a ndun whudusni, bulunah njan nuhudelhúya, 'en dahutetsah whutsuh 'et whuts'un yinkak dune ye' nts'e na'a hubudayi cho tele, 'en whuz de úyalh huyuntelh'ilh.” ");
INSERT INTO cafNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","'Aw 'et whulh lhk'utat dzin inle hoh Sizi 'en Peter, James, 'ink'ez dulhutsin John chah, 'en ndoh dzulh k'uz dulh hobélya. ");
INSERT INTO cafNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Khunyaz hubunalh 'uts'un oonent'en suli. Bunen 'ants'ih sa k'una'a buts'u ha'ánduz, 'ink'ez bunaih 'i chah khunyaz lhiyul suli, 'ink'ez 'i chah buts'u ha 'ánduz. ");
INSERT INTO cafNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","'Et khunyaz Moses 'ink'ez Elijah hubunalh hube whédilts'ai 'ink'ez Sizi hubulh yawhénilhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter, 'en Sizi 'uyulhni, “NeMoodihti njan uzdelhts'i hoonzoo. Hukwa' ninzun t'eh, tat whut'ah 'uts'otelilh. 'Ilhunuh nyun mba, 'et 'ilhunuh Moses ba, 'ilhunuh chah Elijah ba.” ");
INSERT INTO cafNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peter yalhtuk hoh khunyaz kw'us be tídet'en hoh buk'eyínde. Kw'us tah ts'ih khunyaz 'uwhutni, “Ndun suYe' degha nus buk'esi' 'int'ah. 'En bulh hóonust'i. 'En zeh 'oozélhts'ai!” ");
INSERT INTO cafNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yugha hoodul'eh hídants'o hoh hibut nacháneldel, 'ink'ez tube whehunelhújoot. ");
INSERT INTO cafNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sizi bughu ninya 'ink'ez but'agheznai hoh ndo búlhni, “Dinadahdelh 'ink'ez whenlhújut ilah!” ");
INSERT INTO cafNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","'Et nduk nahítat'en, 'aw 'uyoon hoolah. Sizi dich'oh zeh hiya'en. ");
INSERT INTO cafNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ndet dzulh k'ut whenahedidel, 'et yuk nahidulh, Sizi khunek ulhtus, 'i be hubulh yalhtuk 'et ndo búlhni, “Yinkak dune ye' yaidla tah dinadutédalh whuts'un ndet whunelh'en, 'et khun 'uyoon ndudóohtni gunih!” ");
INSERT INTO cafNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","'Et yugha hoodul'eh, 'en hiyoodulhkut, “Ndunnah Moses be' dustl'us 'uk'ununa'úsduguz, 'et di ka' hutni, Elijah 'en choo whusateyalh huba' hoont'ah hutni?” ");
INSERT INTO cafNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","'Et Sizi ndo búlhni, “'Et 'alha Elijah 'en choo whusateyalh 'ink'ez ndai hoonliyaz ts'iyawh lhanaidutedlilh. ");
INSERT INTO cafNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","'Et whunts'ih ndun whudusni, Elijah 'uda whusainya ho' 'int'ah. 'Ink'ez 'en 'aw t'ehinízun. 'Et hukwa' huninzun k'una'a 'uhiyinla. 'Et whuz na'a zeh 'en hubula be yinkak dune ye' dzuh nutezut.” ");
INSERT INTO cafNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","'Et yugha hoodul'eh, 'en ts'iyawh John dune too be 'ulh'en, 'en yughu yalhtuk t'ehonanzin. ");
INSERT INTO cafNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","'Aw 'et 'ilhohuwezdel 'en butanahundel hoh 'ilhunuh dune yughu ninya 'ink'ez yubut dugwútsi be nenínya. 'Ink'ez 'utni, ");
INSERT INTO cafNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“SMoodihti suye' 'en bugha te'nonzeh! Bukaootuzuk 'ink'ez tube dzuh nuzut. Lhat tsudúlts'uk 'ink'ez talts'uk chah 'ut'i. ");
INSERT INTO cafNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","'Et ngha hoodul'eh bughi nílhti 'et whunts'ih 'aw soo na'hiyooleh ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","'Et Sizi ndo búlhni, “Nuhwheni k'an ndoh whudezulh, nuhwheni 'aw be 'alha' hoont'ah, 'i chaht'ih, 'ink'ez tink'us zeh 'eht'ilh. 'Et dawhuldzah nuhwhutah tesdalh? 'Ink'ez dawhuldzah nuhwhuba 'et ndutest'ilh? De', nye' 'en sugha nínilhtih!” ");
INSERT INTO cafNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","'Et ntsi' nududeh, 'i buyudínda, Sizi 'en ts'un khunek ulhtus, 'i be hukwa' yudáni. 'Et whulh hulhgha zeh yuts'u hanája 'ink'ez ndun 'uski soo na'uja. ");
INSERT INTO cafNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","'Et Sizi yugha hoodul'eh, 'en dune hoolah ts'ih highu nindel hoh 'uhiyulhni, “'Et dahoont'ah huwa ndun 'uski, 'en ntsi' nududeh, 'i 'aw buts'u hanáts'inooyoot ghaít'ah?” ");
INSERT INTO cafNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","'Et Sizi ndo búlhni, “'Aw nuhwhuba 'alha' cha'hoot'ah 'et huwa 'aw 'oohleh ghaít'ah. 'Alha 'ún whudusni ndi 'anukat, 'i lhe'niltsol, 'i mustard hiyulhni, 'i k'una'a be nuhwhuba 'alha' hoont'ah, 'i 'et 'ulcho t'eh, 'et ndez 'una'a da 'udoohni. Ndi dzulh njan whuts'un, 'et nguz nailts'ut dahni t'eh, 'ahoh 'et ndutenilh. 'Et whuz na'a ts'iyaitsuk whuz na'a 'udahni t'eh, 'et ndutét'ilh. ");
INSERT INTO cafNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","'Et whunts'ih ndi ntsi' nududeh, 'i netenadudli, 'i 'ink'ez sahá'delya, 'et t'eh zeh dune buts'u hanáts'iyunteyolh ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","'Aw 'et Sizi 'ink'ez yugha hoodul'eh, 'en Galilee yun k'ut hudelhts'i 'et ndo búlhni, “'Aw 'et nilhdukw yinkak dune ye', 'en 'uyoon dune tl'ahítelhtelh. ");
INSERT INTO cafNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Hituzelhghelh 'ink'ez whulh tat dzin inle t'eh, dinadutédalh.” 'Et hodánts'o hoh ts'iyawh tube tso huzdli. ");
INSERT INTO cafNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","'Aw 'et keyah Capernaum whuz hunindel hoh 'ilhunuh sooneya 'ilhunanowes'aih, 'en Peter yughu ninya 'ink'ez yoodulhkut, “Nuhwheni whunohodulh'eh 'en chah ilah luglez whucho whuzooneya yuk'elha hoolh'i?” ");
INSERT INTO cafNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","'Et, “A,” ni. 'Et Peter koo danínya. 'Et Sizi 'ahoh yulh yatélhtuk 'ink'ez ndi yulhni, “Simon, daja ninzun? Ndi ndai sooneya dune buba k'elha yutele, 'i ndi yun k'ut hubudayi cho 'en ndi sooneya 'ilhunanowes'aih? Dich'oh buzkehkah tulih k'us n'awh whut'en tulih?” ");
INSERT INTO cafNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","'Et Peter ndi yulhni, “'Aw n'awh whut'en, 'aw 'en zeh.” Sizi ndi yúlhni, “'Et 'alha' dini. Hubudayi cho dich'oh bubuzkehkah 'en 'aw huba k'elha hole ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","'Et whunts'ih ndunnah Capernaum whut'en, 'en nelh hánilch'e hukw'u na'a hubuts'oolh'en ghaít'ah. 'Et huwa ndi luglez whucho whuzooneya, 'i huba k'elha ts'iyoolhtsilh. 'Aw 'et, bun k'uz ts'inyalh 'ink'ez oolhjas. Soo 'udechoo lhook silhjus, 'i buzek lhch'a 'uhoonleh. 'Et sooneya naité'alh. 'I ilhchoot 'ink'ez si 'ink'ez nyun bulh neba bugha íyo'alh.” ");
INSERT INTO cafNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","'Et hoh da zeh Sizi yugha hoodul'eh, 'en highu nindel 'ink'ez hiyoodulhkut, “Yak'uz hubudayi cho delhts'i ndan simba k'us dezti?” ");
INSERT INTO cafNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","'Et Sizi ndun 'uskiyaz 'anih yulhni, 'ink'ez hubutah neínilhti. ");
INSERT INTO cafNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","'Ink'ez ndo búlhni, “'Et soo ts'ah'un na'a 'un whudúsni, 'aw 'uts'un na'a nahcha'ahnil, 'ink'ez 'uskehyaz k'ah ts'ih sahli t'eh, 'aw 'et zeh huwa, nts'e yak'uz hubudayi cho unli whuz toohdelh ghait'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","'Et huwa ndun 'uskiyaz, ndan yuk'ah ts'ih 'int'ah, whuz na'a dich'oh te'dudil'en, 'et ndunt'ah, 'en nts'e yak'uz k'une' whul'en, 'en hubutah k'us hidelhti tele ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","'Ink'ez ndun dune 'uskiyaz, ndan yuk'ah ts'ih 'int'ah huhóont'i, 'i bulh highu nuseya, si chah whuz na'a zeh 'usuhinla.” ");
INSERT INTO cafNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“'Et ndunnah 'uskehyaz huba 'alha' 'ust'ah, 'uskehyaz hoontsi' ts'ih hubonilht'uk, ndun dune 'et ndúja, 'en tse cho buts'ilchun yehudinguz 'ink'ez k'us takhulh 'et tábuhano t'eh, 'et 'o nus whútezoo. ");
INSERT INTO cafNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ndi yun k'ut hudelhts'i, 'en ndunnah hukwaya hoonli tune' 'uhut'en, 'en dawhultsi', 'et buts'u whélts'ulh ho' hint'ah. 'Alha njan hukwaya hoonli tune' hutet'en ho' hoont'ah. 'Et whunts'ih ndan bugha 'et 'úhooja, 'en dawhultsi', 'et hote'ilh ho' hoont'ah! ");
INSERT INTO cafNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","'Et nla k'us nke 'i be hukwaya hoonli tune' 'ínt'en t'eh, k'unint'as 'ink'ez 'un tilh'is! 'Et dzuh ninya k'us nyust'e bodin'ai, 'et whuz na'a 'ilhuz be ts'ukhuna, 'i nghalts'ut t'eh, 'et whuz na'a degha nus mba whútezoo. 'Et whunts'ih nke 'anelht'et 'ink'ez nla 'anelht'et chah bulh 'ínt'ah hoh kwun nachanusne, 'i tanyaníno t'eh, degha nus mba whutétsi'. ");
INSERT INTO cafNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","'Ink'ez nyuna be hukwaya hoonli tune' whut'en whunilh'en t'eh, nyuna hanó'alh 'ink'ez 'un ntolh'is! 'Et nyuna 'ilho bulh zeh, 'et whuz na'a 'ilhuz be ts'ukhuna, 'i ngha nínzut t'eh, degha nus mba whútezoo. 'Et whunts'ih nyuna 'anelht'et bulh kwun nachanusne, 'i tanyaníno t'eh, degha nus mba whutétsi'. ");
INSERT INTO cafNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“'Et ndunnah 'uskehka khun buka cha'nuzoohzin gunih! 'Alha lizas yak'uz hudelhts'i, 'en bughu hinli 'ink'ez se'aBá yak'uz usda, bulizas 'en 'ahoolhyez hinalh ne'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","'Et huwa ndunnah tinta huninkat, 'en yinkak dune ye' hubutelhyih ka, 'et huba whusainya. ");
INSERT INTO cafNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nts'e na'a daja nahzun? 'Et dune 'en lanezi lanezi (100) sheep 'ut'i hoh 'en hubutah 'ilhunuh tinta nínya 'et bulah 'et nébuninla 'ink'ez ndai lhuk'i tinta nínya, 'en dzulh k'uz yukawhenántai. ");
INSERT INTO cafNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","'Et nayilhti t'eh, ts'ah'un na'a 'un whudusni, ndunnah bulah 'et nébuninla, 'en bugha whunelhnik. 'Et whunts'ih ndai lhuk'i tinta nínya, nayilhti t'eh, 'en bugha dahoolcho 'i be simba 'o nus whuntélhnik! ");
INSERT INTO cafNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","'Et whuz na'a zeh ndunnah 'uskehkah 'et 'ilhunuh whunts'ih kwuncho yuh ts'ih teyalh t'eh, nuhwhe'aBá yak'uz usda, 'en 'aw hukwa cha'nizun. ");
INSERT INTO cafNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“'Et nyulhutsin lubeshi be nch'ani t'eh, 'et buzih nininya 'ink'ez di ka sch'adini, 'et dóni. 'Et nyun 'ink'ez nyulhutsin bulh nuhwhenich'oh lhanaóodoohle. 'Et nghunek yílhchoot t'eh, nyulhutsin whuch'a nanilde ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","'Et 'aw chanyoozílhts'ai t'eh, 'ilhunuh k'us nanah teh ilhchoot 'ink'ez 'et bukoo ts'ih natoohdelh. Nanah k'us tanah teh mba lhgha 'úhudeja t'eh, 'et whuz na'a 'uhót'e. 'Et 'i be daja hutni, ts'iyai 'i khunek ts'ah'un na'a 'uhoneh. ");
INSERT INTO cafNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","'Et whunts'ih 'et chah 'aw chanhozílhts'ai t'eh, 'et Yak'usda ba 'ilhunahuwésdel, 'en chah budóohni. 'Et 'en chah 'aw chaboozílhts'ai t'eh, 'et ndan 'aw huba 'alha' cha'hoot'ah k'us ndan sooneya 'ilhunanowes'aih, 'et ndun lubeshi be nch'ani, 'et 'en buk'una'a noolh'en. ");
INSERT INTO cafNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","'Alha' dusni ho' dusni, nuhwheni ndai ndi yun k'ut whuladehtnik t'eh, 'et nduk yak'uz chah bulaoodutetnih. 'Et ndi yun k'ut ndai lhgha 'úhudeja t'eh, 'et ndoh yak'uz chah lhgha 'úwhutenilh. ");
INSERT INTO cafNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Doo chah 'ún whudusni, ndai buka yoodutelhkut, 'i 'ink'ez nanah k'us tanah ndi yun k'ut lhgha nuhwhuba soo' hoont'ah t'eh, 'et se'aBá yak'uz usda, 'en nuhwhuba 'uwhutelilh. ");
INSERT INTO cafNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","'Et huwa nts'e soozi bugha nanah k'us tanah 'ilhunahuwésdel t'eh, 'et sih si chah nuhtah 'ust'ah ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","'Et Peter yughu ninya 'ink'ez yoodulhkut, “SMoodihti ndun sulhutsin 'en lubeshi be sch'a 'uja. Dawhultsuk whe lubeshi be sch'a 'utet'ilh 'ink'ez buba whunaoodutelhúnah? Skwunlai 'o 'at nankoh (7) tulih 'et 'uwhuneltsuk?” ");
INSERT INTO cafNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","'Et Sizi ndi yulhni, “'Aw skwunlai 'o 'at nankoh (7) 'i chaduzúsnih. 'Et skwunlai 'o 'at nankoh lanezi (70) k'us 'o 'un tulih 'et 'uwhuneltsuk dusni ho' dusni. ");
INSERT INTO cafNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","'Et yak'uz k'úne' whul'en, 'et ndez na'a njan duhoont'ah. Ilhunuh hubudayi cho unli da, 'et be 'ulhna, 'en daneltsuk be buts'ú whulh'ai, 'i ts'iyawh ye bubúlh lhanaoodutélilh, 'et hukwa' ninzun. ");
INSERT INTO cafNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","'Et ho' whunilh'en 'ilhunuh be 'ulhna dahinilhti. Ndai ye yuts'ú whulh'ai, 'i 10,000 sooneya dezti, 'i 'et 'uneltsuk. ");
INSERT INTO cafNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hoolah! Yuk'elha yoolhtsilh, 'i hoolah. 'Et ndun hubudayi cho bughunek be 'et ndi yulhni, 'et ndun dune, bu'at, bubuzkeh, 'ink'ez ndai yit'i, 'i chah, 'i ts'iyawh ye 'óket. 'Et t'eh soo suba k'elha whutelhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","'Et huwa ndun be 'ulhna yubut nacháneti 'ink'ez yuts'un tedudlih hoh ndi yúlhni, ‘Sumoodih k'at, suba ilh'i! Ts'iyawh mba k'elha whutelhsilh!’ ");
INSERT INTO cafNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Bumoodih tube yugha te'nanzin. 'Et ndai ye yuts'u whulh'ai, 'i ts'iyawh yuba whunaoodelhunah, 'ink'ez whenayalh'a. ");
INSERT INTO cafNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","'En 'ulhna zeh 'az whinya hoh doo chah 'ilhunuh dudulh 'ulhna, 'en nayilhti. 'En lanezi lanezi (100) sooneya ch'adíti, 'i 'et 'uneltsuk yuts'u whulh'ai. Yuzool ílhchoot hoh ndi yúlhni, ‘Daneltsuk ngunelh'ai, 'i suba buk'elha hoolhtsi!’ ");
INSERT INTO cafNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ndun yubut dugwútsi be nininya 'ink'ez yuts'u tedudlih hoh ndi yúlhni, ‘K'at, suba ilh'i. Ts'iyawh mba k'elha whutelhsilh!’ ");
INSERT INTO cafNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","'Et whunts'ih 'aw chayoozilhts'ai. 'Et whunts'i 'ayan'ai ndai yughi nelh'ai, 'i ts'iyawh yuba k'elha whutelhtsilh 'et whuts'un. ");
INSERT INTO cafNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","'Et 'onghoh 'ulhna, 'en ts'iyawh honalh'en 'et dahooja. 'Et ts'iyawh howu ni huzdli. 'Et huwa hubumoodih ts'un whehandel 'ink'ez ts'iyawh nduhidani. ");
INSERT INTO cafNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","'Et ndun 'et ndúja, 'en bumoodih 'anih yudani 'ink'ez 'et ndo búlhni, ‘Nyun 'ulhna k'us ntsi' zeh 'int'ah! Suts'un tedindlih ka 'et huwa ndai be sts'o zilh'ai, 'i ts'iyawh mba whunaoodelhúnah! ");
INSERT INTO cafNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nts'e na'a ngha te'nazin, 'et whuz na'a 'oneh mba' hoont'ah, nyulh 'ulhna ts'un!’ yulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","'Et bumoodih yulh hunilch'e. 'Et ndunnah dune dzuh nuhulhdeh, 'en butl'ayálhti. 'Et ndai yughi nelh'ai, 'i ts'iyawh yuba k'elha whutelhtsilh whuts'un. ");
INSERT INTO cafNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","'Et nuhwheni chah nuhwhulhutsinka tinta' hant'en, 'ink'ez nuhdzi ndulhcho, 'i be 'aw buba whunachaooduzulhúhnah t'eh, 'et sih se'aBá yak'uz usda, 'en chah whuz na'a zeh 'aw nuhwhuba whunaoodoolnah ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","'Aw 'et Sizi hubulh yalhtuk 'ustl'e' 'udeja hoh njan Galilee yun k'ut whuch'a nanja. 'Et Judea yun k'ut Jordan koh whuch'az whuz ninya. ");
INSERT INTO cafNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lhanah dune 'et whuz hahínandel. 'Et soo na'balh'en. ");
INSERT INTO cafNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","'Et ndunnah Pharisee, 'en chah highu nindel hiyootélhdzih ka. 'Et hiyoodulhkut, “'Et ndet huwa ne'atkah 'ants'ih hoh hubugha buch'a naztedalh t'eh, 'et Moses khunek netl'aida'ai, 'i buk'una'a ih 'uhoont'ah?” ");
INSERT INTO cafNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sizi ndo búlhni, “'Et ndi dustl'us k'ut 'uk'e'eduguz, 'i 'aw ih buk'eyáchasulhtuk? Njan 'et ndutni, 'udechoo ho' whewhudit'en da ndun dune inla, 'en dune 'ink'ez ts'eke bulh 'obínla da. ");
INSERT INTO cafNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","'Ink'ez 'et ndutni, ‘Njan huwa dune be'abá 'ink'ez be'ama bulh buch'a ooya huba' hoont'ah, 'ink'ez bu'at bulh lhulh zeh 'uhoot'e huba' hoont'ah. 'Et whuz na'a nahúlt'oh 'ilho hutele.’ ");
INSERT INTO cafNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","'Et whuz na'a 'aw 'o 'un nanah chahilah, 'ilho zeh hinli suli. 'Et huwa ndun Yak'usda lhgha hubunilhti, 'aw dune lhch'a nabóolhtelh huba cha'hoot'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","'Et hiyulhni, “'Et di ka Moses hoh da whuz na'a netl'ahó'ai 'ink'ez dustl'us chah neba inla inle hoh dune, 'en bu'at tl'ayóolhchoos 'ink'ez naitoolh'a.” ");
INSERT INTO cafNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","'Et ndo búlhni, “Nuhwhenich'oh nuhdzi dulhts'un, 'et huwa Moses nuh'at whuch'a naoohja nuhtl'ahó'ai. 'Et whunts'ih whe'whudit'en whuts'un, 'aw 'et duchahoot'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","'Et 'un whudúsni, dune bu'at 'en 'uyoon dune bulh tinta' 'ant'en t'eoonanzin t'eh, 'et sih zeh ndi dustl'us ndai ye 'ustl'e' itelilh, 'i bu'at tl'ayóolhchoos. 'En bu'at 'aw tinta cha'it'il t'eh 'et whunts'ih ndi dustl'us yutl'ayálhchooz, 'ink'ez 'uyoon ts'eke yughu nasda t'eh, 'et sih dune ts'eke bulh tinta' 'ant'en suli. 'Ink'ez ndun dune bu'at 'ustl'e' 'uyínla 'ink'ez 'uyoon dune yughu nasda t'eh, ndun dune 'en chah dune ts'eke bulh tinta' 'ant'en tele.” ");
INSERT INTO cafNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","'Et Sizi yugha hoodul'eh, 'en 'uhiyulhni, “'Et dune bu'at bulh whuz na'a 'uhutet'ilh t'eh, 'aw lhghu chahíkah t'eh, 'et 'o nus soo' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","'Et ndo búlhni, “Ndi khunek, 'i 'aw ts'iyannah ba cha'it'ah. Ndan bughá whunt'ai, 'aw 'en zeh buba' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","'Et bulunah dune 'aw bughez hoolah hoh huwhuzdli. 'Et 'onghunnah 'et whuz na'a dune 'ubinla. 'Ink'ez nts'e yak'uz hubudayi cho, bulunah 'en ba whuz na'a soo whulh 'utet'ilh, 'en whuz na'a whulh 'úhoot'e.” ");
INSERT INTO cafNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","'Aw 'et 'uskehyaz highu bunínla. Khun teh buk'édolnih 'ink'ez buba tenadoodli ka. 'Et whunts'ih yugha hoodul'eh, 'en dah hubuhútni. ");
INSERT INTO cafNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","'Et Sizi ndo búlhni, “Whute 'uskehyaz sts'un hutoodelh. Khun teh dah budóohni gunih! Ndunnah Yak'usda hubudayi cho unli whuz delhts'i, 'en ndunnah 'uskehyaz hubunduhúlt'ah ho' hint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bula be hubuk'edilnik, 'ink'ez buch'a nanja. ");
INSERT INTO cafNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","'Aw 'et 'ilhunuh dune Sizi yughu ninya 'ink'ez yoodulhkut, “Dune hoodulh'eh unzoo, nts'e na'a hoonzoo k'una'a 'utest'ilh 'ilhuz khutenalh whuch'a ootélhdoh?” ");
INSERT INTO cafNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","'Et Sizi ndi yulhni, “'Et di ka nuszoo sudini? 'Aw 'ilhunuh unzoo hoolah. Yak'usda 'aw 'en zeh unzoo ho' 'int'ah. 'Et whunts'ih 'ilhuz be hukhutenalh hukwa' ninzun t'eh, ndai Yak'usda khunek dune tl'aida'ai, 'i buk'une' 'int'en da.” ");
INSERT INTO cafNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","'Et ndi yúlhni, “'Et k'us ndai ho' dini?” 'Ink'ez Sizi ndi yúlhni, “Dune sóolhghelh gunih! Ts'ekoo bulh tinta' 'ont'en gunih! 'Undunont'ih gunih! 'Uyoon ba honts'it gunih! ");
INSERT INTO cafNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nye'abá 'ink'ez nye'ama bulh hubudólhti! Nts'e na'a nyunch'oh k'enaindutsi', whuz na'a zeh nyulh dune buk'eontsi'!” ");
INSERT INTO cafNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","'Et ndun chilh ndi yulhni, “Nusol da whuts'un, ndi ts'iyawh buk'une' zust'en. Nts'e na'a 'o 'un datést'ilh?” ");
INSERT INTO cafNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sizi ndi yulhni, “Lhadulya 'utant'ilh hukwa' ninzun t'eh, ndai 'int'i, 'i ts'iyawh be 'ónket, 'ink'ez tel'en butaininle. 'Et sih nduk yak'uz ndai 'ilhuwenla, 'i 'et mba telalh. 'Ink'ez 'anih se'ut'en k'ah tune' ónt'en ka sunanyalh.” ");
INSERT INTO cafNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","'Et ndun chilh ndi khunek yudánts'o hoh tube budzi nduda hoh yuch'a nanja. Tube soode'a 'int'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","'Et Sizi yugha hoodul'eh ndo búlhni, “Ndi 'i be soo ts'ah'un na'a 'ún whudusni, yak'uz ts'ih, nts'e hubudayi cho unli, tube howa whulna hoh dune soode'a 'et whuz teyalh. ");
INSERT INTO cafNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Doo chah zeh 'un whudúsni, ndi khunai ncha, 'i camel hiyulhni, 'i buba howa whulna hoh ughabatsoh bula tah bukoni'a hukwa téyalh. 'Et whunts'ih 'o nus howa whulna hoh dune soo de'a, 'en Yak'usda hubudayi cho unli whuz dateyalh.” ");
INSERT INTO cafNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","'Et yugha hoodul'eh, 'en hidants'o hoh buba hooncha 'ink'ez 'et nduhutni, “Ndan zeh dutejih ho' 'udini?” ");
INSERT INTO cafNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sizi hubunilh'en 'ink'ez ndo búlhni, “Dune, 'aw ndet 'uhuhooleh ghaít'ah, 'et whunts'ih Yak'usda ba huwa chahoolnah ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","'Et Peter yatelhtuk hoh Sizi njan ndi yulhni, “Whunilh'en, ndai ts'ut'i, 'i ts'iyawh bulazdetnik, 'ink'ez nye 'ut'en k'ah ts'ih ts'oot'en ka nyuts'un ts'utezdel. 'Et huwa ndai negha nínkat?” ");
INSERT INTO cafNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","'Et Sizi ndo búlhni, “Ts'ah'un na'a 'ún whudusni, nts'oh whuye whudezulh ts'iyaintsuk k'an, 'i natedleh, 'et wheghah whudezulh hoh yinkak dune ye', yuk'usda cho dezti, 'i yuk'etl'adutedalh. 'Et nuhwheni suntehdel inle, nuhwheni chah lanezi 'o 'at nankoh kw'uts'uzda, 'i dune huba nahuteyeh ka, 'et dutelhúts'ilh. 'Et Israel buts'u hainde, 'en lanezi 'o 'at nanah (12) lhendoh dédowh, 'en huba nahutehyeh. ");
INSERT INTO cafNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","'Ink'ez ndan bukoo huwu tezya, k'us dulhutsinkah, k'us dulhtuskah, k'us bu'abá 'ink'ez be'ama, k'us bu'at, k'us buzkehkah, k'us dukeyah chah, njan si soozi bugha huwu tezya t'eh, 'en lanezi lanezi (100) 'et 'uwhuneltsuk butl'anaootedúkulh. 'Ink'ez 'ilhuz be ts'ukhuna, 'et chah hubugha óotelts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","'Et whunts'ih lhanah 'udechoo 'uhint'ah, 'en 'udek'elh'az nahutedleh. 'Ink'ez lhanah 'udek'elh'az hinli, 'en 'udetsah nahutedleh.” ");
INSERT INTO cafNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Yak'uz ts'e Yak'usda hubudayi cho, 'en ts'iyawh k'une' whul'en, 'et ndez na'a njan nduhoont'ah, 'ilhunuh dune 'en ndi yun k'ut yun ut'i. 'Et mai too chun haniyeh k'et, 'et huba 'utet'ilh ka' ninzun. Bundada 'uda 'et dune telh'alh ka whuz whinya. ");
INSERT INTO cafNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","'Et ndunnah hubalh'a 'ilhuk'i sooneya chaditi 'i dzin nduhóolyez hoh hik'elha utet'ilh, huhóost'et. 'Et huwa mai too chun haniyeh k'ez whebalh'a. ");
INSERT INTO cafNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","'Et hukw'elh'az 9:00 bat'en, ts'uyi be 'óoket daninya dune bunilh'en, 'ants'ih hoh nahudelhúya. ");
INSERT INTO cafNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","'Et njan ndo búlhni, ‘Nuhwheni chah whuz mai too chun haniyeh ts'ih ahdulh. 'Ink'ez nts'e na'a sooneya ts'ah'un 'int'ah, 'i nuhwhuba k'elha telhsilh.’ 'Ink'ez whuz whehándel. ");
INSERT INTO cafNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","'Et doo chah hukw'elh'az dzetniz bat'en k'us 3:00 bat'en chah whuz whinya. 'Et whuz na'a zeh 'uja. ");
INSERT INTO cafNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Doo chah hulhgha ts'ih bat'en whuz whinya 'ink'ez 'uyoon chah 'ants'ih hoh nadelhúya hubunilh'en. 'En chah ndo búlhni, ‘'Et di ka dzin nduwhulyez 'ants'ih hoh nudelhúya?’ ");
INSERT INTO cafNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘'Et 'aw dune nechalh'ah, 'et huwa 'uts'int'ah,’ hiyulhni. 'Et ndo búlhni, ‘Nuhwheni chah whuz mai too chun haniyeh ts'ih ahdulh. 'Ink'ez nts'e na'a sooneya ts'ah'un 'int'ah, 'i nuhwhuba k'elha télhsilh.’ ");
INSERT INTO cafNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","'Aw 'et hulhgha ts'ih dune 'ustl'e' hut'ih ndun mai too chun 'ut'i, 'en bughunli 'anih yudani 'ink'ez ndi yúlhni, ‘'Uhut'en ts'iyawh whusábinle, 'ink'ez huba k'elha hoolhtsi. 'Et ndun 'udek'elh'az whe'dit'en, 'en choo huba k'elha holhtsi.’ ");
INSERT INTO cafNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ndunnah hulhgha ts'ih bat'en ul'a whusahandel 'ilhunah hinli 'ilhuk'i sooneya chaditi, 'i buba k'elha yulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","'Et ndunnah 'udechoo ul'a, 'en chah whusahandel. 'O nus lhai duba k'elha tele huninzun. 'Et whunts'ih whuz na'a zeh 'ilhunah hinli 'ilhuk'i sooneya chaditi, 'i buba k'elha yulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","'En ts'iyawh buba 'uk'elha whuzdli hukw'elh'az, 'et ndun yun ut'i hich'a yawhenilhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","'Et 'uhiyúlhni, ‘Ndunnah 'udek'ah wheóobalh'a, 'en 'ilhoh sadzi hukw'e' hoonist'ah zeh 'uhet'en. 'Ink'ez wheni dzin ndúhoolyez hoh sa ulhtus, 'i niz 'uts'et'en. 'Et whunts'ih 'en nelhulhúgha zeh buba 'uk'elha whuzílhtsi.’ ");
INSERT INTO cafNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","'Et ndun yun ut'i 'et ndo búlhni, ‘Sulh dunekah 'aw hoonliyaz tink'us na'a cha'unwhúslil. 'Et ts'iyawh nuhwhuba soo' hoont'ah 'ilhuk'i sooneya chaditi, 'i mba k'elha silhsi. ");
INSERT INTO cafNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","'Aw 'et ndai nuhwhe'ildzun ulhchoot 'ink'ez nahdulh. 'Et ndunnah 'udek'elh'az hubalh'a, 'en nuhwheni nuhk'una'a zeh 'et 'uneltsuk 'i zeh buba k'elha tesilh 'et hukwa' nuszun. ");
INSERT INTO cafNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","'Alha ilah ih ndai ust'i, 'i nts'e na'a hukwa' nuszun tune' 'úlh'en? Nuszoo 'et huwa ih sugha 'aoonilh ahli?’ hubúlhni.” ");
INSERT INTO cafNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","'Et 'awhuz Sizi njan howu yalhtuk ndo búlhni, “Ndunnah 'udek'ah hinli, 'en 'udechoo nahutedleh. 'Ink'ez ndunnah 'udechoo hinli, 'en 'udek'ah nahutedleh. 'Et huwa Yak'usda lhanah 'anih dáni, 'et whunts'ih ntsoolyaz zeh 'utahaóobanla.” ");
INSERT INTO cafNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","'Aw 'et Sizi Jerusalem ts'ih tezya. 'Ink'ez ndunnah lanezi 'o 'at nanah ndunnah yugha hoodul'eh, 'en 'udun nibuninla 'ink'ez ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Soo zúlhts'ai, Jerusalem ts'iztedulh 'ink'ez yinkak dune ye', 'en ndunnah náwhulnuk moodih, 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz chah, 'aw 'et butl'ahitelhtelh, datetsah ka hiba nahuteyeh. ");
INSERT INTO cafNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","'Ink'ez 'udun yun k'ut whut'en butl'ahitelhtelh. 'En highu tedloh, hiyootelhtsus, 'ink'ez 'et lhdulalhgus k'ehítelhtelh. 'Ink'ez hukw'elh'az whulh tat dzin dinadutédalh.” ");
INSERT INTO cafNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","'Aw 'et Zebedee buzkeh hube'ama, 'et Sizi hits'un tezdel hiyoodutelhkut ka. Hube'ama yubut nachaniti. ");
INSERT INTO cafNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","'Et Sizi ndi yulhni, “Ndet sts'o hukwa' ninzun?” 'Et ts'eke 'utni, “Nts'e hubudayi cho inli, ndunnah nanah suzkeh, 'en 'ilhunuh nalhnih ts'ih tedalh 'ink'ez 'ilhunuh intl'as ts'ih tedalh, sugha óoni'ai.” ");
INSERT INTO cafNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","'Et Sizi njan ndutni, “Ndet hukwa' hoodulhkut 'aw t'eoonuzahzun. Ndi lubot 'aw 'et be' tesnilh, 'i nuhwheni chah be' tehnilh nahzun ih? 'Ink'ez ndai dune be too be 'ul'en, 'i be 'usotelilh. Nuhwheni chah whuz na'a zeh ih too be' tehnilh?” 'Et ndi híyulhni, “A, 'et sih nduts'óoneh!” ");
INSERT INTO cafNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","'Et ndo búlhni, “'Alha sulubot be' tehnilh, 'ink'ez be too be' lhúya, 'i too be' tehnilh. 'Et 'aw doosni ghaít'ah ndan nalhnih ts'ih sts'un tedalh 'ink'ez ndan intl'as ts'ih sts'un tedalh. Ndunnah se'aBá huba lhaóodinla, 'aw 'en zeh buba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","'Et 'onghunnah lanezi hidants'o hoh, 'aw 'et ndunnah nanah lhulhutsinkah huba dzuh 'uhudeja. ");
INSERT INTO cafNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","'Et Sizi ndunnah ts'iyawh 'anih hubudani 'ink'ez ndo búlhni, “Nuhwheni t'eoonahzun ndunnah 'udun yun k'ut whut'en bumoodih, 'en dune k'une' buhul'en. 'Ink'ez ndunnah ncha, 'en ndunnah bumoodih huba hubugha ndoh 'uhint'ah. 'Et whuz na'a hube 'ut'en k'ah hooni. ");
INSERT INTO cafNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","'Et whunts'ih nuhwheni nuhtah whuz na'a 'uteht'ilh nóohzin gunih. 'Et ndan nuhtah ncha tele hukwa' ninzun, 'en nuhwhuba ne'út'en wule. ");
INSERT INTO cafNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","'Et ndan nuhtah 'udechoo tele hukwa' ninzun, 'en nuhwhe'ulhna wule. ");
INSERT INTO cafNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Whuz na'a yinkak dune ye', 'aw ba ne'whutet'en hukwa whusáchaiyal. 'Et dune buba ne'ut'en tele 'ink'ez buba datetsah, 'et whuz na'a lhanah naootekulh, 'et hukwa whusainya.” ");
INSERT INTO cafNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","'Aw 'et hukw'elh'az Jericho keyah whuch'a náhusdel hoh lhanah dune hiyuntezdel. ");
INSERT INTO cafNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nanah chawhés'en ti whuzih huzke. 'Et Sizi wheghah uyalh hoh hiduzts'ai. Soo tube cho hits'uh hahuyih, “Moodihti, David buts'u haínzut, negha te'nonzeh!” ");
INSERT INTO cafNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","'Et 'ilhunahuwésdel, 'en “T'eduzahnih!” hubuhútni. 'Et whunts'ih 'o nus 'uhutni, “Moodihti, David buts'u haínzut, negha te'nonzeh!” ");
INSERT INTO cafNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","'Et Sizi bughah nininya 'ink'ez ndo búlhni, “Dez áh'us. Ndet nuhwhuba 'uwhutesdlilh hukwa' nahzun?” ");
INSERT INTO cafNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“NeMoodihti nena be ts'onolh'en hukwa' uzninzun,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","'Ink'ez Sizi hubugha te'nanzin hoh bula be hubuna yut'agheznai. 'Et 'ahoh honilh'en suli. 'Aw 'et hiyuntez'az. ");
INSERT INTO cafNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","'Aw 'et Jerusalem wheghah hedulh keyah whuyaz Bethphage huwhutni, 'et whuz hunindel. 'I dzulh yenun, Olive huwhutni. 'Et Sizi nanah yugha hoodul'eh, 'en dutsuh whébalh'a, ");
INSERT INTO cafNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","'et ndo búlhni, “Njan keyah whuyaz nuhgha nch'az whuz ah'us. 'Et whuz lhgha dah'az t'eh, 'et 'ahoh yeztliyaz, donkey hiyulhni, buyaz bulh whehudint'uk, 'et whunoolh'en. Sk'unaoobudooh'uk 'ink'ez dez sts'un naoobutoohlooh. ");
INSERT INTO cafNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","'Et dune nuhoodulhkut, ‘Di ka 'ulh'en?’ nuhuwhútni t'eh, ‘NeMoodihti yuka' ninzun,’ dóohtni. 'Et 'ahoh sts'un bula dóohtnih.” ");
INSERT INTO cafNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","'Et whuz na'a ndi ts'iyawh tune' whust'en, 'i be nus hon'en daja ni, 'et ndulhcho 'et dúhooja. 'Et njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zion bukeyah whuti whut'en, whunulh'en! Nuhhubudayi cho te'dudil'en hoh nuhts'u teyalh. Donkey buyaz, 'en yuk'usda. 'En be nuhts'u teyalh.” ");
INSERT INTO cafNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","'Et ndez na'a njan dúhooja, Sizi yugha hoodul'eh whuz wheha'az, 'ink'ez Sizi daja hubúlhni, hoh tune'hust'en. ");
INSERT INTO cafNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","'Et whuz na'a Donkey buyaz bulh hits'u hinilhti. Dunaih hik'ehíyinla 'ink'ez 'on dus de Sizi hik'etl'ahidilhda. ");
INSERT INTO cafNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lhanah dune dunaih ti hiba néhiyuzbus nts'oh lhuteyalh. 'Ink'ez 'onghunnah, 'en chah 'ul nanehidutselh 'ink'ez ti hiba nehídenla. ");
INSERT INTO cafNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","'Aw 'et 'ilhunahuwésdel bulunah butsuh 'ink'ez bulunah buk'ah ts'ih hedulh 'ink'ez tube cho hahuyih ho' hutni, “David buts'u haínzut ba ts'odélhti! NeMoodihti boozi be whuz de úyalh. 'En degha nus hoonzoo bugha whults'ut. 'Et soo deghan doh hidélhti!” hutni. ");
INSERT INTO cafNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","'Aw 'et Sizi keyah Jerusalem whuz ninya, 'et keyah whut'en khunahuntesdel hoh 'ulhódutni, “Ndan dune ho' 'int'ah?” ");
INSERT INTO cafNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","'Et 'ilhunahuwésdel hubuhútni, “Ndun 'en Sizi nus whunilh'en, 'en 'int'ah. Keyah Nazareth yun k'ut Galilee whuz'ai, whuz de hainya 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","'Aw 'et Jerusalem hubuluglez whucho whuna'neztl'oo daninya 'et ndunnah 'ooket 'ink'ez 'e'óoket, 'en ts'iyawh tenabunenyoot. Sooneya lhk'enaduleh bukw'uzdai 'i chah ts'iyawh buch'a yuntez'ai. Ndunnah dut'aiyaz, dove hiyulhni, be 'óoket, 'en bukw'usuda 'i chah buch'a yuntez'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","'Et ndo búlhni, “'Uk'e'eduguz hoh njan ndutni, ‘Njan sukoo tenadudli ba koo dahni,’ 'et whunts'ih 'et chah njan ndutni, ‘'Undunut'ih, 'en bukoo whuzúlhtsi.’ ” ");
INSERT INTO cafNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","'Et luglez whucho 'et chawhés'en 'ink'ez bukechun nduda, 'en highu nindel, 'et soo na'balh'en. ");
INSERT INTO cafNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ndunnah náwhulnuk bumoodih 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz, 'en njan huwa 'ét'en tune' 'ust'en hinalh'en. 'Ink'ez 'uskeh 'en chah luglez whucho sulyahalhtuk 'et njan nduhutni, “David buts'u haínzut buba ts'odélhti!” 'Et njan ts'iyawh honalh'en hoh hukwa hanílch'e. ");
INSERT INTO cafNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","'Ink'ez Sizi 'et ndi hiyulhni, “Ndi daja hutni huboozélhts'ai ih?” 'Et ndo búlhni, “A, 'ink'ez dahúja 'aw hukw'uyachasulhtuk hoh ih dahni? Ndez na'a 'uk'e'wheduguz 'et njan ndutni, ‘'Uskeh 'ink'ez 'uskehyaz chah, 'en bughunek 'i be' hutni, ts'ah'un na'a suba hodilhti hubulhtsi.’ ” ");
INSERT INTO cafNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","'Et ndunnah 'aw 'et buch'a nanja 'ink'ez keyah whuti huwu whenája. 'Ink'ez keyah whuyaz Bethany ts'un ninya 'et usda. ");
INSERT INTO cafNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","'Et 'om bun 'uda 'et keyah whuti whuts'u hédulh hoh khunyaz buye'élts'ul. ");
INSERT INTO cafNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","'Et ti whuzih khunyaz ndi mai chun, fig hiyulhni, yutelh'en. 'Et 'i yuts'un lhgha dinya hoh 'et 'aw bumai bughoh hoolah. 'Ut'an zeh bugha hoonli hoh ndi yúlhni, “'Et 'aw 'ilhuz nyumai hootélah.” Ni ibulh ndi duchun 'uyulhni, 'i dezgi. ");
INSERT INTO cafNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ndunnah yugha hoodul'eh hiya'en hoh tube huba hooncha. 'Et 'uhutni, “Nyoo mai chun, fig hiyulhni, daja hoh 'uja khunyaz dezgi?” ");
INSERT INTO cafNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","'Et Sizi ndo búlhni, “'Alha 'un whudusi, bé 'alha' hoont'ah, 'i aht'i, 'ink'ez 'aw nuhwhuba nawh cha'whutést'il t'eh, 'et ndi mai chun khunsih doogi. 'Aw 'et zeh ilah, njan dzulhyaz, ‘Didílhts'i 'ink'ez bun k'ut whucho ts'ih tailhts'i,’ 'i dáhtni t'eh, 'et whuz na'a 'et ndoh whútenilh. ");
INSERT INTO cafNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","'Et ndai buka' dahni tenadudli be, nuhwhuba 'alha' hoont'ah t'eh, 'i ts'iyawh nuhgha tékulh.” ");
INSERT INTO cafNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","'Aw 'et luglez whucho daninya 'et hudélhts'i wheoobudunilh'i. 'Et nawhulnuk degha nus dézti 'ink'ez dune netsuh whudelhdzulh chah, 'en highu nindel 'ink'ez 'uhiyúlhni, “Nedini ndan bugha dune gha ndoh 'unint'ah njan dint'en. K'us ndan ntl'ahó'ai dune gha ndoh 'unínt'ah?” ");
INSERT INTO cafNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","'Et Sizi ndo búlhni, “Si chah 'ilhun hukwa nuhoodutelhkut. 'Et ndusudáhni t'eh, 'et nuhwhudutesnilh ndan bugha dune gha ndoh 'ust'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nts'e na'a John dune too be 'úlh'en? Ndan yutl'aho'ai dune too be telilh huba? Yak'uz ts'ih tulih hawhélts'ut, k'us dune tulih ts'ih hawhélts'ut?” Dich'oh lhtah howu yahalhtuk 'ink'ez 'uhutni, “'Et yak'uz ts'ih hawhélts'ut ts'utni t'eh, 'et neundúdoni, ‘'Et di ka John nuhwhuba 'alha' cha'dusnih?’ ");
INSERT INTO cafNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","'Et whunts'ih, ‘Dune ts'ih hawhélts'ut whutéla 'uhoont'ah,’ ts'utni t'eh, 'aw uzdooni ghaít'ah, dune hububéznuljut, ts'iyanah John 'en nus whunilh'en 'int'ah huninzun 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","'Et Sizi ndi hiyulhni, “'Aw nts'ez de hawhélts'ut nt'ets'onízun.” 'Ink'ez Sizi ndo búlhni, “Ndan be dune bugha ndoh 'ust'ah ndi njan nduwhúlh'en, 'et si chah 'aw ndun whudóosni ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Njan hubugha daja nahzun? 'Ilhunuh dune nanah buye'. 'En 'udechoo yughu ninya 'ink'ez ndi yulhni, ‘Suye' mai too chun haniyeh ts'ih whuz inyalh 'ink'ez suba 'int'en.’ ");
INSERT INTO cafNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","'Et yuch'a tsí'desnih. 'Et whunts'ih hukw'elh'az ndunát'e 'ink'ez whuz whinya. ");
INSERT INTO cafNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","'Et bulh nat buye', 'en chah yughu ninya 'ink'ez ndi yulhni. ‘A, whuz toosya 'ink'ez 'oost'en!’ ni. 'Et whunts'ih 'aw whuz chatíyal.” ");
INSERT INTO cafNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","'Et Sizi 'utni, “Ndunnah nanah k'us ndan ndet be'abá huba hukwa' ninzun hoh teh hukw'une' hust'en?” “'Et 'udechoo, 'en zeh,” hutni. 'Et Sizi ndo búlhni, “Ts'ah'un 'ún whudusni, ndunnah sooneya nalhdzooh 'ink'ez ts'ekoo 'ul'en chah, nts'e Yak'usda hubudayi cho unli, whuz nuhtsuh hutedulh. ");
INSERT INTO cafNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Soo whunulh'en, be ts'ah'un 'uhoont'ah, 'i be John dune too be 'ulh'en nuhts'uh whusainya, 'ink'ez 'aw nuhwhuba 'alha' cha'hoot'ah. 'Et whunts'ih sooneya nalhdzooh 'ink'ez ts'ekoo 'ul'en, 'en ts'iyawh huba 'alha' hoont'ah. 'Et nuhwheni whunulh'en 'et whunts'ih 'aw nuwheni k'ah nácha'ahlil, 'ink'ez 'aw nuhwhuba 'alha' cha'hoot'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Njan 'uyoo be nawhutnuk, 'i be nuhwhudutésnilh. Sih soozólhts'a! 'Ilhunuh bukoo whumoodih, 'en haniyeh k'et 'uhoonla, 'ink'ez mai too mai too chun 'ananla. 'Ink'ez whuna'neztl'oo. 'Et tsak'et hahónkai mai too 'utahahúlhtsus, 'et chah neóoni'ai. 'Ink'ez buk'ut yutest'en, 'i chah wheni 'uhinla. 'En njan haniyeh k'et ndunnah ha' nulhyeh butl'ahó'ai, 'ink'ez nilhdza keyah ts'ih whinya. ");
INSERT INTO cafNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","'Aw 'et 'oonuje neooninzut hoh bukoo whumoodih 'en 'ulhna, 'en whuz whebalh'a 'ink'ez ndun 'uhut'en, 'en buts'un mai hitelhchulh ka. ");
INSERT INTO cafNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","'Et ndunnah ha' nulhyeh, 'en bukoo whumoodih 'en 'ulhna hubílhchoot. 'Ink'ez 'ilhunuh soo yayalhchus. 'Ilhunuh chah hizelhghi. 'Ilhunuh chah tse be yahiyalh'uz. ");
INSERT INTO cafNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","'Et doo chah zeh 'onghunnah 'ulhna 'o nus 'uhuneltsuk whuz whebalh'a. 'En chah whuz na'a zeh 'et ndo buhínla. ");
INSERT INTO cafNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","'Et 'udek'elh'az bukoo whumoodih buye' whuz buts'ú wheyálh'a. ‘'En tulih hidóolhti,’ ni. ");
INSERT INTO cafNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","'Et whunts'ih ndunnah bughu whulh'ai hitelh'en hoh 'et 'ulhódutni, ‘Ndun 'en nyoo haníyeh k'et bube'ildzun, 'en buye' 'ut'en. Ts'uzoolhghelh! 'Et t'eh ndet buts'i telts'ulh, ts'iyawh 'et nduhóolcho ts'ohólhchoot!’ ");
INSERT INTO cafNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","'Et hiyílhchoot 'ink'ez njan haníyeh k'et tínahinino 'ink'ez hizelhghi. ");
INSERT INTO cafNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","'Et huwa 'et njan mai too chun haniyeh, 'en bube'ildzun, 'en whusateyalh. Whusainya t'eh, 'et dabóoleh simba?” ");
INSERT INTO cafNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","'Et ndi híyulhni, “'Et ndunnah untsi', 'en hooncha hukw'un'a hoolah hubutelhtsilh 'ink'ez njan haniyeh k'et 'uyoon ha' untelhyeh bugho télh'alh. 'Et whuz na'a niwhúzuk totsuk ndi mai higha' hítelelh.” ");
INSERT INTO cafNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","'Et Sizi ndo búlhni, “'Aw ih hukw'e yachazulhtuk Yak'usda bughunek daja ni inle da? 'Et ndez k'e'eduguz, ‘Ndunnah 'en ndi tse be koo 'uwhulh'en 'i 'ún hidutelh'us, 'i ba koo buk'uwhuz'ai huba soo degha nus tse 'int'ah, 'i suli. 'Et Moodihti whuz na'a 'uhoonla. 'Ink'ez nuwheni tube neba hooncha ho' hoont'ah,’ ni. ");
INSERT INTO cafNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","'Et huwa nuhwhudúsni, nts'e Yak'usda hubudayi cho unli, 'et ts'iyawh nuhghu nahootélchulh 'ink'ez 'uyoon hudedowh butl'aóote'alh. 'En 'ut'en unzoo, 'i buts'u haóokat. ");
INSERT INTO cafNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","'Ink'ez ndunnah ndi tse hik'elts'ut, 'en ts'iyawh yahidutélhkulh. 'Ink'ez ndunnah ndi tse buk'édilts'ut, 'en ts'iyawh hoolah hutele.” ");
INSERT INTO cafNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","'Et ndunnah Lizwif náwhulnuk bumoodih 'ink'ez Pharisee chah, 'en ndi khunek be nawhutnuk, 'i whulh 'úhudants'o hoh t'ehonanzin Sizi 'en didut bughu yalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nts'e na'a simba Sizi hitelhchulh 'et hukwa' hut'en. 'Et whunts'ih dune yé hunuljut. 'En Sizi 'en nus whunilh'en 'int'ah huninzun 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","'Et doo chah zeh Sizi be nawhutnuk, 'i be whuts'odul'eh, 'i be hubulh yalhtuk 'et ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“'Et yak'uz k'úne' whul'en, ndez na'a njan dóohoont'ah, 'ilhunuh hubudayi cho buye' bu'at whutele, 'en huba lhadútenilh. ");
INSERT INTO cafNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","'Ink'ez ndunnah bughu núseya, de'ulhna buts'u whebaoolh'a, 'anih hubadooni ka, 'et whunts'ih buch'a tséhudesnih. ");
INSERT INTO cafNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","'Et doo chah zeh 'uyoon chah de'ulhna whuz wheóolh'a. Ndunnah bughu nusja suba budoohni, ‘'Aw 'et ts'uyi, 'i lhadínt'ah. Njan musdus ts'iyawh ndai nilhúk'a, 'i ts'iyawh suba nahiyanghan dune yute'alh whuba. Ts'iyai 'i lhadínt'ah. 'Aw 'et ndunnah lhghusdúke hubulh na'uztet'alh. Soo 'a dezáhdulh! suba hubudóohni.’ ");
INSERT INTO cafNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","'Et whunts'ih ndunnah bughu nusja huba 'ants'ih 'uhoont'ah. Ts'iyawh lhents'un whehándel. Bulunah chah há' hunulhyeh ts'ih whenáhedel. 'Et bulunah chah hube 'ut'en k'ah whuz'ai ts'ih whenáhedel. ");
INSERT INTO cafNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bulunah hubudayi cho be 'ulhna hubihílhchoot 'ink'ez dzuh ne'buhalh'en 'ink'ez hubuhanghan. ");
INSERT INTO cafNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","'Et hubudayi cho whulh údants'o hoh tube hunílch'e. Ndunnah nehughan hubít'i ts'iyawh whuz whebalh'a. Ndunnah be 'ulhna inghan, 'en ts'iyawh hoolah hubulhtsi 'ink'ez bukeyah ts'iyawh hodálhk'un. ");
INSERT INTO cafNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","'Et hukw'elh'az 'uyoon chah be 'ulhna, 'en ndo búlhni, ‘'Aw 'et na'tet'alh lhaoodint'ah, 'et whunts'ih bughu nusja, 'aw huba soo cha'hildzooh.’ ");
INSERT INTO cafNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","'Et huwa 'aw 'et ti ts'íh ahdulh. 'Ants'ih lhanah cho nahla t'eh, 'en ts'iyawh bughu nóhdelh. ");
INSERT INTO cafNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","'Et ndun be 'ulhna ti ts'ih whehandel. Ndan nabuhinla, ntsi' 'ink'ez unzoo tubulh 'ilho ts'iyawh whusábahanla. 'Aw 'et na'hutet'alh bukoo whudezbun. ");
INSERT INTO cafNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","'Aw 'et hubudayi cho buts'un danínya bughu nusja hubuntelh'ilh ka. 'Et 'ilhunuh dune 'en 'aw naih dune lhghu delhts'i whunaih be dune chailah hoh yutelh'en. ");
INSERT INTO cafNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","'Et ndi yúlhni, ‘Sulh dune 'aw dune lhghu delhts'i whunaih be dune chainlah. 'Ink'ez nts'e na'a danínya?’ 'Et ndun dune 'aw whé 'uyoodoni hoolel. ");
INSERT INTO cafNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","'Et hubudayi cho duba ne'ut'en ndo búlhni, ‘Ndun dune ulhchoot 'ink'ez ulhghel. 'Ink'ez 'az tsahólhgus yuh ts'ih táhneh! 'Et whuz tetso 'ink'ez dughoo lheidútelhk'us.’ ");
INSERT INTO cafNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Njan 'et ndutni hoh 'utni, lhanah ghu nusja 'et whunts'ih bulunah zeh 'utahálya.” ");
INSERT INTO cafNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","'Aw 'et ndunnah Pharisee 'udun nehúnindel 'ink'ez howu yahalhtuk, nts'e na'a Sizi ye yalhtuk, 'i be hitelhzah hukwa' hut'en. ");
INSERT INTO cafNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","'Et Pharisee hubugha hoodul'eh 'ink'ez Herod dédowh chah, 'en Sizi ts'un wheoobuhalh'a. 'Et ndi hiyúlhni, “Dune hoodulh'eh t'ets'oninzun nyun ts'ah'un dune 'int'ah 'ink'ez khunek 'alha' 'int'ah, 'i be Yak'usda k'una'a dune hodilh'eh. Ts'iyannah mba lhgha 'int'ah. Nts'e na'a dune dahút'en 'et whunts'ih mba 'ants'ih 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","'Et huwa nedini, ndi yun hik'elha hiyilh'i, 'i 'et ts'ah'un tulih 'uhoont'ah hoh hubudayi cho Caeser 'en tulih buba k'elha ts'uyoolhtselh, k'us 'awundooh tulih? Daja ninzun?” ");
INSERT INTO cafNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","'Et Sizi t'eooninzun nts'e na'a hoontsi' k'ah ts'ih 'uhoont'ah, 'et huwa ndo búlhni, “'Et di kah sóolhdzih? Nuhwheni ts'iyawh duba nahdúdzoo aht'ah! ");
INSERT INTO cafNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","De' nyoo sooneya sunalh ts'et nah'a!” 'Ilhuk'i sooneya chaditi, 'i hitl'ahína'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","'Et ndo búlhni, “Ndan bunen 'ink'ez boozi chah buk'e'edúguz?” ");
INSERT INTO cafNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Hubudayi cho Caesar,” hiyulhni. 'Et ndo búlhni, “'Et huwa ndai hubudayi cho Caeser bube'ildzun, 'i butl'anáyahle. 'Ink'ez ndai Yak'usda bube'ildzun, 'i Yak'usda butl'anáyahle.” ");
INSERT INTO cafNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","'Et hidants'o hoh ts'iyawh huba hooncha 'ink'ez hich'a nandel. ");
INSERT INTO cafNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","'Et dzin zeh ndunnah Sadducee, 'en highu nindel. 'En 'uhutni dats'úzsai 'ink'ez 'aw nats'ukhóotnah ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","'Et ndi híyulhni, “Dune hoodulh'eh Moses ndez na'a njan ndutni, 'et dune 'aw buzkeh hoolah hoh dazsai 'ink'ez bu'at zeh khuna t'eh, 'et bulhutsin 'en yughu naooda huba' hoont'ah. 'Et ndun bulhutsin 'en dughe yughu nasda t'eh, 'en ts'un dulhutsin ba buzkeh whutele. ");
INSERT INTO cafNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","'Et netah skwunlai 'o 'at nanah lhulhutsinka, 'en 'udetsah whudelhdzulh, 'en 'at ut'i. 'Ink'ez 'aw buzkeh hoolah hoh dazsai. 'En bu'at dulhutsin ba nayoosdzi. ");
INSERT INTO cafNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Whúlh nanah whuz na'a zeh dazsai. 'Et whulh tat, 'en chah whuz na'a zeh 'uja. 'Et nduwhúlyez hoh skwunlai 'o 'at nanah ts'iyawh yahadla. ");
INSERT INTO cafNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","'Et 'udek'elh'az ndun ts'eke 'en chah dazsai. ");
INSERT INTO cafNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","'Et huwa nedini 'ilhudzin whusawhutelts'ulh hoh ts'iyannah dinadutédulh, 'et t'eh ndun ts'eke ndan bu'at tele? 'Et whunulh'en skwunlai 'o 'at nanah ts'iyawh hubughinda.” ");
INSERT INTO cafNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","'Et Sizi ndo búlhni, “Nuhwhenich'oh na'dunáht'ah! 'Aw Yak'usda bughunek nt'enuzahzun. Ye ulhtus, 'i chah 'aw nt'enuzahzun. ");
INSERT INTO cafNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","'Et ndet dzin dune dinadidel t'eh, 'aw lhghu chahudutelhts'il 'et huwa. Dune dinadidel, 'en Yak'usda bulizas k'una'a 'uhutet'ilh ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","'Et daja sudahni yaidla tah dinadutédalh hubugha, Yak'usda daja ni, 'aw ih hukw'u yachazulhtuk? Njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Si Abraham, Isaac, 'ink'ez Jacob, hubuYak'usda 'ust'ah.’ 'Aw yaidla hubuYak'usda ilah 'int'ah. Hukhuna 'en hubuYak'usda nusli unli 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","'Et 'ilhunahuwésdel 'en dahoont'ah hubugha hubudani tube huba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","'Et Pharisee whulh 'úhudants'o nts'e na'a Sizi ndunnah Sadducee hubudani, 'et hukwa Sadducee 'aw yahutoolhdih ghaít'ah hoh hinat 'ilhunahuwésdel. ");
INSERT INTO cafNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'Aw 'et 'ilhunuh hubutah, Moses be' dustl'us k'ut, daja ni hoh beni hoonli be yalhtuk unli, 'en Sizi yóolhdzih hoh yoodulhkut, ");
INSERT INTO cafNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Dune hoodilh'eh k'us undai khunek neba yutulhúhezya, 'i k'us degha nus dezti?” ");
INSERT INTO cafNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","'Et Sizi ndi yulhni, “ ‘Yak'usda nyuMoodihti ndzi ndulhcho 'i be, nzul ndulhcho 'i be, nyunut'uk ts'iyawh 'i be, 'ink'ez nyeni ts'iyawh 'i be chah, 'et whuz na'a 'en buk'eoontsi'.’ ");
INSERT INTO cafNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ndi ndai nuhwhuba yutulhuhezya, 'i 'udechoo 'ink'ez degha nus dezti, 'i 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","'Et bulh nankoh, 'i 'udechoo, 'i k'una'a 'int'ah, ndez na'a njan ndutni, ‘'Et dahoont'ah hukw'una'a nyunch'oh k'enaindutsi', 'et whuz na'a zeh 'onghunnah chah buk'eoontsi'.’ ");
INSERT INTO cafNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ndi nankoh khunek nuhtl'adélts'ut, 'i be Moses be' dustl'us, 'ink'ez nus whunilh'en hube dustl'us chah, 'i ts'iyawh 'ants'ih koo buk'ut whuz'ai, 'i li'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","'Et 'awhuz ndunnah Pharisee 'ilhunahuwésdel hoh Sizi huboodulhkut, ");
INSERT INTO cafNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Christ ndan unli 'int'ah nahzun? K'us ndan yuts'u hainzut simba 'int'ah?” “'En David yuts'u hainzut 'int'ah,” hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","'Et ndo búlhni, “Nts'e na'a 'int'ah David Ndoni be nyun sMoodihti 'int'ah nyudúsni ni 'et ndez na'a njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Moodihti 'en sMoodihti ndi yúlhni, nalhnih ts'ih sinda t'eh nch'a detni, 'en buk'ut nke naóolyis mba hólhsilh.’ ");
INSERT INTO cafNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","'Et whuz na'a David, ‘SMoodihti,’ 'uyulhni. Nts'e na'a simba 'en yuts'u hainzut wule?” ");
INSERT INTO cafNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","'Aw dune yuts'u yatoolhdih hoolah. 'Et ts'iyannah whehunuljut 'aw 'o 'un hiyoodolhkut ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","'Aw 'et Sizi ndunnah 'ilhunahuwésdel 'en 'ink'ez yugha hoodul'eh chah hubulh yawhenilhtuk hoh ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ndun Moses be' dustl'us 'uk'ununa'úsduguz 'ink'ez Pharisee, 'en chah 'en dune hodutelh'eh 'et wheni Moses yuk'usda, 'i k'ut natl'ahudelts'i. ");
INSERT INTO cafNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","'Et ndai khunek hiye nohwhulh yalhtuk, 'i 'et ts'iyawh wúlhchoot 'ink'ez buk'úne' 'ooht'en. 'Et whunts'ih khun hubuk'una'a ne'óoht'en gunih. 'Et 'alha daja hutni, hoh tunuchá'hust'en. ");
INSERT INTO cafNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","'Et ndez na'a né'hut'en, lhai cho lhughel tube howa whulna dune neyúghe huba. Dune buwus k'ehiyíle. 'Et hedich'oh hubulasgek lhuk'i whunts'ih nuhighoolhnah ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ndai 'uhiyulh'en, 'i 'uyoon yunoolh'en huba 'uhiyulh'en. 'Ink'ez ndi Yak'usda bughunek zus, Phylacteries hiyulhni, 'o nus ncha hiyilh'i ts'iyannah hinoolh'en ka. 'Ink'ez ndi nayidúts'uz 'i tenahududli teh nahuyits'uz, 'i chah butsuh 'o nus 'udelyez nahiyulhtsih. ");
INSERT INTO cafNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","'Et 'uhuté'alh 'ink'ez luglez chah soo k'us hoonzoo 'et zeh hudutélts'ilh hukwa' huninzun. ");
INSERT INTO cafNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","'Ink'ez ndet ts'uyi, 'i be 'óoket, 'et ts'iyannah hubodélhti hoh dahooja hubuhútni, 'et huhóont'i. 'Ink'ez ts'iyawh 'ihunah hinli hoh, ‘Rabbi! Nehodulh'eh!’ huba hudóoni hukwa' huninzun. ");
INSERT INTO cafNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","'Et whunts'ih khun teh 'uyoon ‘Rabbi,’ nuhodóoni gunih! 'Aw 'ilhunuh zeh whenohodulh'eh hoonli 'et huwa, Christ 'en 'int'ah. 'Et nuhwheni ts'iyawh lhulhutsinkah ahli. ");
INSERT INTO cafNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","'Et ndi yun k'ut 'ants'ih ndan, ‘'Abá,’ hubudóohni gunih. 'Aw 'ilhunuh zeh nuh'aBá unli 'et huwa, Yak'uz usda, 'en 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","'Ink'ez khun teh 'uyoon ‘Nemoodihti,’ nuhwhudóoni gunih. 'Aw 'ilhunuh zeh nuhMoodihti hoonli 'et huwa, Christ 'en 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ndunnah nuhtah hincha, 'en nuhwhuba ne'hút'en wule. ");
INSERT INTO cafNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","'Ink'ez ndan dich'oh ncha nadudil'i, 'en deghanyuk tel'en tele. 'Et ndan deghanyuk 'ududildzun, 'en degha ndoh ncha tele.” ");
INSERT INTO cafNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","'Et nuhwheni Moses be' dustl'us 'uk'ununa'úsduguz nuhwheni Pharisee chah, nuhwheni duba nahdúdzoo aht'ah! Dawhultsi' 'et nuhts'u whélts'ulh. Ndez na'a njan ndaht'en, nts'e hubudayi cho yak'uz usda, 'et whudáti dune ch'a dána'dehtan. Nuhwhenich'oh whunts'ih daóohya ghaít'ah. 'Ink'ez ndunnah whuz hedulh, 'en chah 'aw dabóohlelh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nuhwheni Moses be' dustl'us 'uk'ununa'úsduguz, nuhwheni Pharisee chah, nuhwheni duba nadúhdzoo aht'ah! Dawhultsi' 'et nuhts'u whélts'ulh! Tsandelh hubukoo hubugha haoondunaht'ah. 'Et ndi tenadudli 'i be whuz na'a zeh 'aoonilhka sa cho tenadahdli. 'Et huwa 'o nus 'uwhulcho nuhwhuba nahutedeh. ");
INSERT INTO cafNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nuhwheni Moses be' dustl'us 'uk'ununa'úsduguz, nuhwheni Pharisee chah, nuhwheni duba nadúhdzoo aht'ah! Dawhultsi' 'et nuhts'u whélts'ulh! Ndi yun k'ut ndulhcho hoh náhdelh 'ink'ez too k'ut ndulhcho hoh nahke, 'ilhunuh tulih nuhwhenich'oh nuhk'una'a 'int'ah wulhtsilh. 'Et whuch'a nulhde t'eh, 'et sih ndan nat 'uwhultsi' hoh nuhghanus kwuncho yuh whuye' tele. ");
INSERT INTO cafNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nuhwheni chawhés'en li'aht'ah, dawhultsi' nuhts'u whélts'ulh. Lhe'aht'ah whuzeh'en 'et whunts'ih dune ti wheoobuntelhtun hukwa' aht'en. 'Et ndez na'a dune whubodulh'eh, njan luglez whucho boozi be dune nahuhezya t'eh, 'et 'ants'ih 'uhoont'ah. 'Et whunts'ih luglez whucho 'et gold 'ink'ez silver bulh 'uhoolya, 'et 'i be whuz na'a nahuhezya t'eh, 'et whuz na'a 'uhuhooleh huba' hoont'ah, dáhni. ");
INSERT INTO cafNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nuhwheni whuzáhnik 'ink'ez chaoozéh'en ahli! K'us ndet degha nus whudezti? Luglez whucho k'us gold bulh 'úhoolya, 'et 'i tulih? 'Et luglez whucho 'et degha nus whudezti. 'Et gold bulh 'uhoolya, 'i 'ants'ih Yak'usda ba 'udun nenínkat, 'i 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ndi 'i chah dune whubodulh'eh, ndan Yak'usda bukw'uzdai 'i be hoonliyaz yuts'u nahezya, 'et 'ants'ih 'uhoont'ah. 'Et whunts'ih ndai 'ants'ih huwa t'aih, 'i Yak'usda bukw'uzdai k'eyin'ai, 'et 'i be dune yuts'u nahezya t'eh, 'et nduyóoleh huba' hoont'ah. 'Et whuz na'a dune whubodulh'eh. ");
INSERT INTO cafNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nuhwheni whuzahnik 'ink'ez chaoozéh'en ahli. K'us ndet degha nus whudezti? 'Ants'ih huwa t'aih, 'i tulih k'us Yak'usda bukw'uzdai tulih? Ndi Yak'usda bukw'uzdai 'i degha nus dezti! Ndi 'ants'et huwa t'aih, 'i Yak'usda bukw'uzdai 'i bugha Yak'usda bube'ildzun suli 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","'Et huwa ndan Yak'usda bukw'uzdai 'i be hoonliyaz yuts'u nahezya, ndi Yak'usda bukw'uzdai 'ink'ez buk'uyuzdla, 'i ts'iyawh 'i be yuts'u nahezya. ");
INSERT INTO cafNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","'Ink'ez ndan luglez whucho yuts'u nahezya, luglez whucho 'ink'ez Yak'usda usda, 'et ts'iyawh yuts'u nahezya. ");
INSERT INTO cafNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","'Ink'ez ndan yak'uz yuts'u nahezya, Yak'usda yuk'usda cho dezti, 'i 'ink'ez ndan yuk'usda, 'en be yuts'u nahezya. ");
INSERT INTO cafNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nuhwheni Moses be' dustl'us 'uk'ununa'úsduguz, nuhwheni Pharisee chah, nuhwheni duba nahdzoo aht'ah! Dawhultsi' 'et nuhts'u whélts'ulh! Ndez na'a njan daht'en, ndai haníyeh, 'i 'ut'an sooltsun, 'i chah, anise hiyulhni, 'i chah, 'ink'ez cummin hiyulhni, 'i chah, 'i bulah zeh, 10%, 'i Yak'usda ghah'aih. 'Et whunts'ih Moses be' dustl'us k'ut degha nus whudezti, 'et ts'iyawh whuladehtnik. Ndez na'a ts'ah'un 'uhoont'ah. Njan ndet ts'ah'un na'a ne'áht'en, ye negha te'untezeh, 'i chah, 'ink'ez be néba 'alha' hoont'ah, 'i chah, njan 'et ts'iyawh whuladehtnik, 'et whunts'ih whuz na'a ndóht'en huba' hoont'ah, 'ink'ez 'onghun, 'i chah 'aw lhachaduzahle bula doohtnih gunih. ");
INSERT INTO cafNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Lhe'aht'ah whuzeh'en 'et whunts'ih, dune ti whúbuntelhtun hukwa' aht'en. Lhe'aht'en, ndai ahnai, 'i sts'uz yé tat'o t'eh, 'i ahguz 'et whunts'ih nuhwheni ndi khunai cho, camel hiyulhni, 'i telhnoh li'hoont'ah! ");
INSERT INTO cafNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nuhwheni Moses be' dustl'us 'uk'ununa'úsduguz, nuhwheni Pharisee chah, nuhwheni duba nahdzoo aht'ah. Dawhultsi' 'et nuhts'u whélts'ulh! Lusyet 'ink'ez lubot chah yoo 'az ts'ih toonáhgus. 'Et whunts'ih bet ts'ih 'et ndai 'uyoon be, bé whulhts'it, 'i 'ink'ez nts'e na'a hukwa' nahzun tune' aht'en 'et 'i be nuhlusyet 'ink'ez nuhlubot teh dezbun. ");
INSERT INTO cafNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nuhwheni Pharisee chawhés'en ahli! Ndi lusyet 'ink'ez lubot bulh 'udechoo bet ts'ih tóonawhahgus 'et t'eh yoo 'az chah 'aw chaditsun wule. ");
INSERT INTO cafNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nuhwheni Moses be' dustl'us 'uk'ununa'úsduguz, Pharisee nuhwheni chah, duba nahdzoo aht'ah! Dawhultsi' 'et nuhts'u whélts'ulh! 'Ants'ih ts'un k'ut whuduchun dustl'us 'i lí'aht'ah. yoo 'az ts'ih tube soo 'awhut'en, 'ink'ez bet ts'ih whudutsun 'ink'ez dune ts'un be whudezbun. ");
INSERT INTO cafNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","'Et whuz na'a zeh dune nalh nuhyust'e yoo 'az ts'ih ts'ah'un dune hinli ndoonéht'en. 'Et whunts'ih nuhyuh ts'ih ts'ah'un cha'aht'ah. Ndai duba nahdzoo 'ink'ez 'uk'únucha'ust'en, 'i chah, 'i be whudezbun. ");
INSERT INTO cafNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nuhwheni Moses be' dustl'us 'uk'ununa'úsduguz, Pharisee nuhwheni chah, duba nahdzoo aht'ah! Dawhultsi' 'et nuhts'u whélts'ulh! Nuhwheni nus whunilh'en, 'en buba tse bet 'ahudutelhtelh 'uwhulh'en. 'Ink'ez ts'ah'un 'int'ah, 'en buts'un k'ut hoonzoo whulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'Ink'ez ndez na'a njan ndudáhtni, ‘Hoh da netsuh whudelhdzulh hubulh ts'ukhuna inle ndúcha. Hoh da ts'ukhuna t'eh, 'et nus whunilh'en hubuhughan da, 'aw bulah ts'oot'en ghaít'ah inle.’ ");
INSERT INTO cafNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","'Et ndi njan ndudáhtni, 'i be nuhwhenich'oh ch'a déhtni. Ts'iyannah hobunulhtun 'aw 'uyoon ndunnah nus whunilh'en hubahanghan, nuhwheni 'en buts'uh háde ahli! ");
INSERT INTO cafNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","'Aw 'et ndai 'ut'en untsi', 'i nuhwhubákah whe'hidilh'en, 'et ts'iyawh lhaóodahla. ");
INSERT INTO cafNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tl'ughus poison buzkehkah lí'aht'ah! Njan kwuncho yuh wheni nuhwhuba nahutedeh, nts'e na'a 'utehnilh wheghoo tehdulh? 'Aw 'uhóneh ghait'ah! ");
INSERT INTO cafNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","'Et hukwa soo cho soo zélhts'ai, 'et nus whunilh'en, 'ink'ez dune huwhunih, 'ink'ez Yak'usda bughunek hodulh'eh chah, 'en ts'iyawh nuhts'ún butelh'alh. 'En bulunah butehghan. 'Et whuz na'a lhdulalhgus hubunduntélht'ah. Bulunah nuhluglez bez ts'ih 'et hubootelhtsus. 'Ink'ez lhelhdun keyah totsuk zah nohbutelhzut. ");
INSERT INTO cafNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","'Ink'ez 'et huwa 'et ndez na'a nuhk'eóotelts'ulh. Ndunnah ts'ah'un 'int'ah buzkai yun k'ut nájul, 'en bughá 'utehnilh nuhk'eóotelts'ulh. Hoh da Abel 'en 'uja buzkai yun k'ut nájul. 'Et njan Zechariah buzkai yun k'ut nájul 'et whuts'un. 'En 'int'ah Berechiah buye'. Ndun 'en njan luglez whucho 'et Yak'usda bukw'uzdai ye guz 'et nuhtsuh whudelhdzulh, 'en hizelhghi inle. ");
INSERT INTO cafNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ts'ah'un na'a be 'ún whudusni k'an whudelhdzulh, 'et nuhwheni hukw'elha whutelhtsilh ho' aht'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Nuhwheni Jerusalem whut'en, dáwhultsi' nuhts'u whélts'ulh! Nuhwheni aht'en nus whunilh'en ahghan. 'Ink'ez ndunnah nuhts'u télh'a, 'en chah tse be hubahghan. Dant'ah ligok duduzkeh dints'un be huboontun, whuz na'a nuhwheni chah lhat hoh 'ilhunanohwutésdlelh hukwa' nuszun, 'et whunts'ih 'aw hukwa cha'nahzun. ");
INSERT INTO cafNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Soo cho whunulh'en, 'aw 'et nuhwheni Jerusalem whut'en nuhkeyah 'aw hoonli hoolah suli hoh nuhwhuba 'et nenáwhults'ut, 'et whuz na'a Yak'usda nuhladutetnih. ");
INSERT INTO cafNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","'Et 'un whudusni, 'aw 'o 'un chasutuzeh'il. 'Et ndet dzin whusaootélts'ulh, 'et ndudútehnilh, ‘Ndun Yak'usda boozi be whusatéyalh, 'en degha nus hoonzoo buts'ó telts'ulh,’ 'et k'an zeh suteh'ilh!” ");
INSERT INTO cafNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","'Aw 'et njan luglez whucho Sizi 'az whenaja hoh yugha hoodul'eh highu nindel. Njan luglez whucho nts'e na'a 'uhóolya 'et whuhínulhtun. ");
INSERT INTO cafNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","'Et Sizi ndo búlhni, “Njan ts'iyawh 'aw chaoonuzulh'en 'ih? Ts'ah'un na'a 'ún whudusni, 'aw lhuk'i tse lhk'uchadutésdla, ts'iyawh nadúntejulh ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","'Aw 'et haoodet'aiyaz dzulh Olive hiyulhni, 'et usda. 'Et ndunnah yugha hoodul'eh ts'iyawh highu nindel, 'ink'ez whu'izyaz hiyoodulhkut, “Njan nket'ah 'uwhuténilh? Nts'oh whudezulh hoh whusanátandalh, 'ink'ez nts'oh huwa whudezulh hoh whulatah whutele? Ndet hoh wheóoduteltsilh, 'et huwa nt'ets'onoozeh? 'Et nendudíni!” ");
INSERT INTO cafNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","'Aw 'et Sizi ndo búlhni, “Soo cho howahli. Khun teh dune nanohwhunoo'ah gunih. ");
INSERT INTO cafNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","'Alha lhanah soozi bugha whusahutedulh 'ink'ez 'uhudutenilh, ndun Christ unli, si 'ust'ah, nduhutni hoh lhanah nahunte'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dune nehughan whulh 'udutéhts'o. 'Ink'ez dune lhutegan chah howu yahutelhtuk. 'Et chah whudutéhts'o. Khun teh whénoolhujut gunih. Njan dawhutenilh, 'et ts'iyawh nduwhutenilh, 'et whunts'ih 'awhuz whulatah ilah 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","'Et huwa lhelhdowh dédowh lhch'az nehúdutadulh. 'Ink'ez yinkak ndulhcho hubudayi cho be 'ustl'ennah, 'en chah lhehútedulh. 'Et dai whúteleh, 'ink'ez dada chah whutéleh. 'Et lhelhdun yun nutughetnah. ");
INSERT INTO cafNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ndi ts'iyawh be dzuh nuts'udeh, 'i k'an be whewhudít'en. ");
INSERT INTO cafNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","'Et neooninzut t'eh, 'et dzuh nunohotilhdeh ka whutl'anohotelelh. Bulunah nuhoteghan. 'Ink'ez si soozi bugha 'udun yun k'ut whut'en nuhts'o dutetnik. ");
INSERT INTO cafNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","'Et hukw'elh'az 'et lhanah huba dzuh tele, 'ink'ez nuhwhenich'oh nuhtah lhgha hawhútelhyih 'ink'ez lhts'udutehtnih. ");
INSERT INTO cafNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Lhanah whuts'it be nus whunilh'en hinli, 'en lhanah dune nahunte'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","'Ink'ez ndunnah 'uk'unucha'ust'en, 'en 'o nus 'uhultsi' tele. Dune ye lhk'etsi', 'i chah k'ah 'utenilh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","'Et whunts'ih ndunnah soo whulatah whuts'un whechahítsaz, 'aw 'en zeh hudutejih. ");
INSERT INTO cafNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","'Et nts'e na'a Yak'usda yak'uz ts'un dune k'une' whul'en, 'en bugha khunek unzoo, 'i yun k'ut ndulcho hoh be yatetuk. 'I be 'udun yun k'ut whut'en, 'en huba whubuntelhtun tele. 'Et zeh 'aw 'et whulatah whusawhételts'ulh.” ");
INSERT INTO cafNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“'Et huwa ndi degha nus be whunujut, 'en hoolah yutelhtsilh, 'en degha nus whudezti ts'ih siyin hoh nulh'en t'eh, ndun Daniel nus whunilh'en hoh da howu yalhtuk inle. (Soo zélhts'ai, ndi ndan yuk'eyalhtuk, 'en soo cho bubeni taóodoolts'it). ");
INSERT INTO cafNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","'Et ndan Judea yun k'ut hudelhts'i, dzulhyaz k'uz tsihutoolhdelh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ndan bukoo hukw'usda khun teh nanaóoja 'ink'ez bukoo ts'ih na'óolhchoot gunih. ");
INSERT INTO cafNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ndan haníyeh k'et 'ut'en, 'en khun bukoo ts'ih dunaih kunaóoda gunih. ");
INSERT INTO cafNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","'Et hoh t'eh, ndan ts'ekoo helchan, 'ink'ez ndan buzkeh ye'úlht'ukw, 'en huba tube 'o nus whutetsi'. ");
INSERT INTO cafNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nket'ah whuch'a tsiz telhdulh, khi k'us nats'ulyis dzin, 'et teh 'uhoneh gunih, 'et huba tenadahdli. ");
INSERT INTO cafNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","'Et 'alha whusawhélts'ut t'eh, hooncha dune dzuh nuhutedeh. 'Et ndi yun k'ut whe'whudit'en da, 'ink'ez k'an dzin whuts'un, 'aw whuz na'a doo chah zeh ndó honeh ghaít'ah, 'ilhuh zeh 'uwhutenilh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Hoh t'eh nts'oh whugha whudezulh hoondukw nachahwháhdlel t'eh, 'aw dune hudoojih hoolah. 'Et whunts'ih 'utahálya, 'en hubugha hoondukw whutelhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","'Et ndun Christ njan usda k'us nwun usda, 'et ndun nuhwhuhútni t'eh, khun nuhwhuba 'alha hudooni gunih. ");
INSERT INTO cafNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","'Alha lhanah whuts'it be Christ la'dadil'i 'ink'ez whuts'it be nus whunilh'en, 'en lhanah nuhtah whutele. 'Ink'ez nuhtah tube hooncha tune'hutet'en. 'Ink'ez huwa 'et'en chah nuhtah ne'hutet'en. 'Et ndi njan ndótet'ilh, khun teh 'utahálya nabonoo'ah huninzun, 'et hukwa' hutet'ilh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","'Et sih soo zulhts'ai, whutsuh whudelhdzulh 'uda nuhwhudáni. ");
INSERT INTO cafNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","'Et huwa dune ndun whulhni t'eh, ‘Nulh'en nda 'et dune chahóot'ih 'et usda!’ hutni t'eh, khun whuz toohdelh gunih. K'us, ‘'Et bukoo bez ts'ih usda,’ hutni t'eh, khun nuhwhuba 'alha hudooni gunih. ");
INSERT INTO cafNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ndez na'a njan nduwhútenilh, 'et ditnik kwun ndaz de hadánat 'ink'ez nuk ts'un whedanat. 'Et ts'iyannah dune yunoolh'en ka, 'et whuz na'a yinkak dune ye' whusanatedalh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","'Et huwa nts'e neyust'e súlht'i, 'et sbalyan 'ilhuwezdel. ");
INSERT INTO cafNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“'Et dune dzuh nuhutedeh, 'et ndúhooja t'eh, hukw'elh'az 'ahoh sa dulhgus tele. 'Ulh'ek ooza chah 'aw be chahoodest'en tele. Sum chah ts'iyawh ndus de hantejulh. 'Ink'ez ndai yak'uz whelhtus ndulhcho hoh notughetnah. ");
INSERT INTO cafNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","'Et njan nduhóoja t'e, ts'iyannah dune yunoolh'en ka yinkak dune ye' yak'uz ts'ih be hóoduteltsilh. 'Et hoh wheghah whezulh t'eh, 'et dune ndi yun k'ut ndulhcho tso yahutelhtuk. 'Et yinkak dune ye' whuz de úyalh hiyuntelh'ilh. Kw'us k'ut yak'uz ts'ih hatéyalh. Ye dezti, 'i 'ink'ez ye ulhtus, 'i be' tenilh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Be ts'ujih, 'i tube cho be' duts'o hoh bulizas whuz haóobutelh'alh. 'Utahálya, 'en ts'iyawh 'ilhunaooboohootélelh. Diwh hukw'un'a hutedulh 'ink'ez yaz ndulhcho notedulh. 'Et ndulhcho hoh 'ilhunaooboohootélelh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ndi mai, fig hiyulhni, buduchun, 'i be nawhutnuk be whuts'odul'eh. Ndi 'i 'int'ah, buzooschum 'ulghih teh, 'Aw 'et but'an whulhlhih, 'i bugha t'ewhunáhzun 'aw 'et dain nilhdukw suli. ");
INSERT INTO cafNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nuhwheni chah whuz na'a zeh ndi ts'iyawh nuhwhudusni. 'Et hoh nket'ah nulh'en 'aw 'et t'ewhunóhzin, 'en nuhwheghah. 'Ants'ih ndati siyin li'hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","'Alha ts'ah'un na'a 'ún whudusni, k'an ndoh whudezulh 'aw yachahútesdla, 'et ndi ndó tenilh ts'iyawh 'et lhawhúdutenilh, 'et whuts'un. ");
INSERT INTO cafNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yaz 'ink'ez ndi yun k'ut 'i chah hoolah whutele. 'Et whunts'ih ndi sughunek 'aw hoolah chatesdle. ");
INSERT INTO cafNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ndet dzin 'ink'ez nts'oh whugha whudezulh 'uwhutenilh, 'aw dune nt'echaoonízun. Lizas yak'uz hudelhts'i, 'en whunts'ih 'aw nt'ehonízun. Se'aBá yak'uz usda, 'aw 'en zeh nt'eooninzun. ");
INSERT INTO cafNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","'Et hoh da Noah khuna da, dune dahant'e, 'et whuz na'a zeh 'uwhutét'ilh hoh yinkak dune ye' whusanátedalh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Soo cho whunulh'en, yinkak too be' whutenilh da, whutsuh da, ts'iyannah 'a'alh 'ink'ez 'uhutnai. Dune 'ink'ez ts'ekoo bulh lhgho delhts'i, Noah ts'i cho be teyalh 'et whuts'un. ");
INSERT INTO cafNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dune 'aw t'ehonízun nket'ah too hadutébilh. 'Aw 'et hadámbun hoh ts'iyawh too hubanghan. 'Et whuz na'a zeh yinkak dune ye' whusanátedalh t'eh, 'et ndó tenilh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","'Et dzin nanah, 'en haniyeh k'et 'uhut'en. 'Ilhunuh, 'en hitélhcholh 'ink'ez 'ilhunuh 'aw 'et tedalh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nanah hite'ulh, 'i hidunulhduz. 'Ilhunuh hitélhcholh 'ink'ez 'ilhunuh 'aw 'et tedalh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","'Et huwa soo cho huwahli! Nts'oh huwa whezulh hoh nuhMoodihti whusateyalh 'aw nt'eoonuzahzun. ");
INSERT INTO cafNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","'Et ndi nuwheni taoonahle, ndun bukoo moodih, nts'oh huwa whudezulh undunut'ih whusateyalh, 'et t'ewhuninzun t'eh, 'et soo ts'ah'un da huwole, 'ink'ez 'aw hikoo da'óoyis ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","'Et huwa nuhwheni chah lhadóoht'e. 'Alha nts'oh huwa whudezulh, 'et buka tsih chawhahlih, 'et yinkak dune ye', 'et whusanátedalh.” ");
INSERT INTO cafNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“K'us ndan 'ulhna, 'en ts'ah'un 'int'ah 'ink'ez whunih 'int'ah? 'en 'int'ah, bumoodih dich'oh 'en 'onghunnah 'ulhna bukoo humoodih yutelhtsilh. 'Et soo hoh hite'alh, 'i hubugha ite'alh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","'Et bumoodih whusanaja teh 'ink'ez 'ulhna whuz na'a nduja, 'en degha nus hoonzoo buts'uh whélts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","'Alha 'ún whudusni, ndai yit'i, 'i chah ts'iyawh k'une' yul'en yutelhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","'Et whunts'ih ndun be 'ulhna ntsi' dich'oh budzi yuh 'et nduninzun, ‘SMoodih sa sla whusanádaih.’ ");
INSERT INTO cafNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'Et khunyaz 'onghunnah dudulh 'ulhna hububeyih, 'ink'ez tatnai chah hubula whe'ni'al 'ink'ez hubula tawhénitnai. ");
INSERT INTO cafNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ndet dzin ndun bumoodih whusanátedalh 'ink'ez nts'o huwa 'uhunit'oh utenilh 'aw t'ewhunízun, 'et wheghah 'uhunet'oh whusanátedalh. ");
INSERT INTO cafNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","'Et lhulcho lhk'ube' yutelht'oh 'ink'ez ndunnah duba nahudzoo 'en hubuts'itekulh, 'i bulah buts'itekulh. 'Et whuz na'a tso bulh dughoo lhidutelhk'us.” ");
INSERT INTO cafNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Yak'uz nts'e hubudayi cho usda ndi yun k'ut whusawhélts'ut teh, 'et ndez na'a ndó tenilh, lanezi t'etdukah 'en dune t'ehunízun, ndi kwun be whét'en, 'i hiyilhchoot 'ink'ez ndun dune 'at tet'ilh 'az 'et hibalh'i. ");
INSERT INTO cafNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Skwunlanah, 'en huwhunih 'ink'ez skwunlanah, 'en huwhusnik. ");
INSERT INTO cafNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ndunnah huwhusnik ndi too dezk'un hit'i 'et whunts'ih ndi too dezk'un hiye náhitelhdzoh, 'i hi'et 'uja. ");
INSERT INTO cafNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'Et huwhunih 'en too dezk'un denáhitelhdzoh, 'i chah hitez'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","'Et 'at tet'ilh sa sla whusayih. 'Et ts'iyawh nehunentsai 'ink'ez ts'iyawh bulh buk'eóodilts'ut hoh nahunéstez. ");
INSERT INTO cafNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tuzniz bat'en 'ilhunuh hahuyih, ‘'Aw 'et 'at tet'ilh 'az de íyalh. Dinadahdelh 'ink'ez bududéhdelh!’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","'Et ndunnah t'etdukah ts'iyawh dihudíndel 'ink'ez too dezk'un, 'i ts'iyawh nahídulhk'an. ");
INSERT INTO cafNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Huwhusnik, 'en ndunnah huwhunih hubuhutni, ‘Too dezk'un negha núlhdzeh, netoo dezk'un 'aw 'et bé haooduk'aih!’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","'Et ndunnah huwhunih, ‘'Awundooh!’ hutni ‘Nuhgha nidulze t'eh, nuhwheni 'ink'ez nuwheni chah 'aw neba soo cha'iltsuk.’ 'Et hubuhutni, ‘'E'óoket ts'ih whuz ahdulh, 'ink'ez nuhwhenich'oh 'óohket.’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","'Et whuz whehandel, 'at tet'ilh buk'elh'at whusaínya. 'Ink'ez ndunnah yuba lhadint'ah, 'en na'hutet'alh ts'ih hiyúlh danindel, 'ink'ez ndati daná'hudentan, 'ink'ez dána'hude'ai. ");
INSERT INTO cafNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","'Et hukw'elh'az ndunnah t'etdukah huwhusnik whusánahedel hoh, ‘Nemoodih, nemoodih, neba dana'dutintih!’ hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","'Et ndo búlhni, ‘'Alha 'aw nt'enwhunuzúszun!’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","'Et whuz na'a nuhwheni chah soo cho huwahli! 'Alha ndet dzin 'ink'ez nts'oh whugha whezulh hoh yinkak dune ye' whusanatedalh, 'aw dune t'eoonízun hoolah.” ");
INSERT INTO cafNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Yak'uz ndet hubudayi cho usda, ndi yun k'ut whusawhélts'ut teh, 'et whuz na'a ndó tenilh, ndun dune dukeyah huwu teyalh. 'Et teyalh whutsuh dude 'ulhna 'anih hubudani. Ndai yit'i, 'i hubutl'ayánla. ");
INSERT INTO cafNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","'Ilhunuh skwunlai sooneya dezti, 'i yutl'aina'ai. 'Et 'ilhunuh chah nankoh sooneya dezti, 'i yutl'ainanzai. 'Et doo chah 'ilhunuh 'en 'ilho zeh yutl'ainanzai. 'Ilhunuh hinli hoh nts'e na'a soo hoonzoo hukw'un'a hiye' whutelilh, 'et wheni butl'ainanzai. ");
INSERT INTO cafNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","'Et hukw'elh'az 'aw 'et whinya. 'Et 'ilhunuh skwunlai yutl'ainanzai, 'en 'o 'un skwunlai uneltsuk, 'i ye na'yínla. ");
INSERT INTO cafNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","'Et whuz na'a zeh 'ilhunuh 'en nankoh yutl'ainanzai hoh nankoh ye yúba na'yínla. ");
INSERT INTO cafNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","'Et whunts'ih 'ilhunuh lhuk'i zeh yutl'aina'ai, 'en yun hahónkai 'ink'ez whuz dumoodih buzooneya yuntelh'i. ");
INSERT INTO cafNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","'Et hukw'elh'az sa inle hoh ndunnah 'ulhna hubumoodih whusanája. 'Et nahooté'alh hukwa' ninzun nts'e na'a dahiyínla. ");
INSERT INTO cafNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","'Et ndun skwunlai yutl'ainanzai, 'en skwunlai be 'o 'un 'uneltsuk, 'i yuba whusanáinanzai. 'Et ndi yulhni, ‘Sumoodih skwunlai sooneya dezti, 'i stl'ananzai. Nah! Nilh'en skwunlai be 'o nus mba na'usdla.’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","'Et bumoodih ndi yulhni, ‘Tube soo 'inja! Nyun tube inzoo. Nduhóolhcho k'une' nyutelh'en. Nyun tube 'ulhna unzoo inli. 'Et hoontsoolyaz k'une' nyutelh'en inle. 'Et k'an n'un hoh lhai ghu tanleh. 'Anih! Ndai nyumoodih ye hoont'i, 'i nyun chah be hóotant'i.’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","'Et 'ilhunuh nankoh sooneya dezti, 'i yutl'ainanzai, 'en chah whusainya. 'Et ndi yulhni, ‘Sumoodih nankoh sooneya dezti, 'i stl'ananzai. Nah! Nilh'en nankoh be 'o nus mba na'usdla.’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","'Et bumoodih ndi yulhni, ‘Tube soo 'inja! Nyun chah tube inzoo. Nduhóolhcho k'une' nyutelh'en. Nyun chah tube 'ulhna unzoo inli. 'Et nyun chah hoontsolyaz k'une' nyutelh'en inle. 'Et k'an nyun chah n'un hoh lhai ghu tanlelh. 'Et nyun chah 'anih! Ndai nyumoodih ye hoont'i, 'i nyun chah be hootant'i.’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","'Et doo chah 'ilhunuh 'ilhuk'i sooneya dezti yutl'ainánzai, 'en chah whusainya 'ink'ez ndi yúlhni, ‘Sumoodih t'eoonuszun nyun 'aw t'echa'nínzun 'unint'ah. Nts'e 'acha'ninlel 'et whunts'ih 'et ha'ninle. Nts'e haneyeh whuyúchaninlel 'et whunts'ih 'et chah ha'nínle. ");
INSERT INTO cafNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tube whenlhujut 'et huwa ndi sooneya dezti yun yuh ts'ih ntélh'i. Nah! Nilh'en ndi stl'ana'ai, 'i ntl'ananús'aih.’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","'Et bumoodih 'uyúlhni, ‘Nyun níntsi' 'ink'ez tsi'dintnik 'ulhna 'int'ah. 'Alha t'eooninzun nts'e 'acha'nuzusdlah, 'et whunts'ih 'et chah ha' nusdle. 'Ink'ez nts'e haníyeh whucha'núsdlel, 'et whunts'ih 'et chah ha' nusdle. ");
INSERT INTO cafNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","'Et huwa hoh da ndez na'a njan ndónleh huba' hoont'ah. Ndi uszooneya ntl'anadzai, 'i sooneya lhk'enadunudzih, 'en butl'achainuzínzai. 'Et t'eh da uszooneya 'o nus 'uneltsuk, 'i be na'óotneh wule da.’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","'Et huwa ndo búlhni, ‘Ndunnah ndi uszooneya dezti, 'i bugha nailhúchoot. Ndun lanezi sooneya dezti, 'i yit'i, 'en bugha inéhzaih. ");
INSERT INTO cafNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","'Et ndan yulah zeh ut'i, 'en 'o nus lhai bugha itélts'ulh. 'Et whuz na'a lhai tet'ilh. 'Et whunts'ih ndan ntsoolyaz ut'i, 'i whunts'ih bughu nayutélchulh. ");
INSERT INTO cafNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","'Aw 'et ndun 'ulhna ntsi', ulhchoot 'ink'ez 'az tsahólhgus yuh ts'ih téhnoh.’ 'Et whuz tso bulh dughoo lhudoolhk'us sih.” ");
INSERT INTO cafNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“'Aw 'et yinkak dune ye' nket'ah buts'u ha 'ánduz hoh whusanátedalh teh, 'et ndunnah lizas lubeshi bughoh hoolah, 'en hiyulh whusanátedulh. 'Et 'ink'ez yuk'usda cho dezti, 'i k'ut nanátl'adutedalh. ");
INSERT INTO cafNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","'Et 'ink'ez yinkak dune, 'en ts'iyawh hibut 'ilhunaoobuhootélelh. 'Et sheep ghunli k'una'a sheep, 'i sbai tahanaítelelh. ");
INSERT INTO cafNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sheepyaz 'en nalhnih ts'un ts'ih nebutelelh. 'Ink'ez sbai 'en 'íntl'as ts'un ts'ih nebutelelh. ");
INSERT INTO cafNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","'Et hubudayi cho 'et ndunnah nalhnih ts'un ts'ih 'int'ah 'et whuz na'a ndubudutenilh, ‘Nuhwheni se'aBá degha nus hoonzoo nuhghá whults'ut ahli. 'Et huwa 'anih! Ndi yun 'utelnilh whutsuh, ndet hubudayi cho yak'uz úsda, 'et ndet nuhwhuba lhaoodinla, 'et k'an zeh nuhtl'aootelts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Soo cho whunulh'en, suye'élts'ul hoh 'ates'alh, 'i sugha náh'ai. Ta'oosde hoh ndai tesnilh, 'i sugha náhkai. 'Uts'un whút'en usdli 'et whunts'ih nuhwhukoo ts'ih dásunulhti. ");
INSERT INTO cafNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","'Aw naih chaúst'i hoh 'enásalhti. Ndusda hoh sts'un nusahdel. Stsak'esida hoh suts'un nusahdel.’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","'Ink'ez ndunnah ts'ah'un 'int'ah hiyoodutélhkut, ‘NeMoodihti nkeda nye'élts'ul hoh nts'a'en 'ink'ez tá'alh, 'i ngházni'ai? 'Ink'ez ta'óonde hoh tantnilh, 'i nghaznínkai? ");
INSERT INTO cafNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","'Et nkeda 'uts'un whút'en inli hoh dánts'unilhti inle? K'us naih chaint'ih hoh naih ngházninla inle? ");
INSERT INTO cafNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nkeda ndinda hoh nts'unálh'en k'us tsak'esinda hoh nts'un nuts'uzdel inle?’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","'Et hubudayi cho njan ndoh dúbudutenilh, ‘'Alha, 'i be 'ún whudusni, ndunnah sulhutsinkah, ndunnah 'aw ncha chailah, 'en 'ilhunuh whunts'ih whuz na'a 'et ndóbahla t'eh, 'et si 'usáhla ho' hoont'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","'Aw 'et ndunnah 'intl'as ts'ih 'int'ah, ndez na'a ndo ba duténilh, ‘Ndai Yak'usda ye hunilch'e, 'i nuwhulh 'int'ah sahli! Sch'a nanahdelh! 'Aw 'et ndi kwun 'aw nachanusne, 'i netsudule bulizas huba 'uhóolya, 'et nuhwheni chah whuz tehdulh! ");
INSERT INTO cafNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Suye'élts'ul inle 'et whunts'ih 'aw tes'alh, 'i sugha chah'al. Ta'óosde 'et whunts'ih 'aw tesnilh, 'i sugha chahkal. ");
INSERT INTO cafNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","'Uts'un whut'en usdli, 'aw 'et dachasúlhtel. Hoh da 'aw naih chast'ih 'et whunts'ih 'aw be oosda, 'i hoolah naih sugha chahlel. Hoh da ndusda hoh 'ink'ez tsak'esida, 'aw suts'un nuchahdulh.’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","'Et dez na'a 'uhidutenilh, ‘NeMoodihti nkeda da nts'a'en ho' dini? Nkeda nye'ilts'ul 'ink'ez ta'onde? K'us 'uts'un whut'en inle, k'us be dune onle, 'i chaínt'ih? K'us ndinda 'ink'ez tsak'esinda? 'Et whuz na'a nts'a'en 'et whunts'ih 'aw hoonliyaz hoh nlacha'ts'ínil dini?’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","'Et ndoh budutenilh, ‘'Alha 'i be 'un whudusni, ndunnah sulhutsinkah 'aw ncha chahílah, 'et 'aw 'ilhunuh whunts'ih whuz na'a nuchaoobahlil. 'Et huwa si chah 'aw nduchásahlil li'hoont'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","'Et nduhint'ah, 'en 'ilhuz wheni dzuh nahutedoh ts'ih hutedulh. 'Et whunts'ih ndunnah ts'ah'un 'int'ah, 'en 'ilhuz hoh ts'ukhuna hubugha ootékulh.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","'Aw 'et Sizi ts'iyaintsuk lhadúja yugha hoodul'eh 'et ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“'Et t'eoonahzun 'aw 'et nat dzin whuz'ai butus lhuseya 'et whunahutelnih. 'Et 'ink'ez yinkak dune ye' 'aw 'et butl'ahitelhtelh 'ink'ez lhdulalhgus k'ehiyutelhtelh.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","'Et soo wheghah whezulh hoh, 'et nahuwhulnuk degha ndoh, 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz, 'ink'ez dune netsuh whudelhdzulh chah, 'en ts'iyawh náwhulnuk degha nus dezti, 'en Caiaphas hiyulhni, bukoo soo' whulcho 'et 'ilhunahuwutédulh. ");
INSERT INTO cafNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","'Et 'ilho yahalhtuk 'ink'ez huwhuts'it hoh hoonli hiba' hoonla hoh Sizi hitélhcholh 'ink'ez hituzelhghelh. ");
INSERT INTO cafNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“'Et whunts'ih 'et njan butus lhuseya 'et whutah 'uts'inla t'eh, 'et hukwa dune lhtahahót'alh.” hutni. ");
INSERT INTO cafNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","'Aw 'et keyah whuyaz Bethany huwhútni, 'et Simon buka whulhjut ínle, leprosy hiyúlhni, bukoo 'et Sizi yuzih usda. ");
INSERT INTO cafNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","'Et 'ilhunuh ts'eke bughu daninya hoh 'en ndi tse dezti, 'i Alabaster hiyúlhni, 'i be ndi luboodai 'ulya, 'i ye'alh. Ndi k'unutsutjul sooltsun, 'i tube dezti ho' 'int'ah. 'Et kw'uzdai k'ut na'ut'alh hoh yutsi k'eyilhdze. ");
INSERT INTO cafNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","'Et ndunnah yugha hoodul'eh hinilh'en hukwa cha'hunízun. 'Ink'ez 'en ndúlhodutni, “'Et di ka ndi 'ants'ih tinta' yulh'ih? ");
INSERT INTO cafNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ndi yoo dezti, 'i bé' ts'onket 'ink'ez, 'i ts'iyawh tehel'en, 'en hubugha íts'oodzaih wule da!” ");
INSERT INTO cafNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","'Et Sizi t'eoonanzin 'et ndo búlhni, “Ndun ts'eke 'aw buts'áhachaoozah'ak. 'Ut'en unzoo, 'i suba 'uyínla ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","'Ahoolhyez tehel'en hubulh áht'ah, 'et whunts'ih si 'ahoolhyez 'aw nohwhulh cha'tuzest'il. ");
INSERT INTO cafNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","'Alha ndi k'unutsutjul sooltsun, 'i 'adutestelh huba suyust'e yuk'eyílhdze hoh 'ut'en. 'Et whuz na'a lhasúdinla. ");
INSERT INTO cafNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","'Alha 'un whudusni ndi yun k'ut ndulhcho ndi khunek unzoo, 'i nudutékat, ndun ts'eke ndet 'uhoonla, 'et hukw'u naootitnuk 'et hoh dune yunatelnih.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","'Aw 'et ndunnah lanezi 'o 'at nanah, 'en hubutah 'ilhunuh Judas Iscariot hiyulhni, 'en náwhulnuk bumoodih buts'uh whinya. ");
INSERT INTO cafNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","'Et ndo búlhni, “Daltsuk sugha ntéh'alh ndun dune nuhwhutl'aílhti t'eh?” “'Et tat lanezi sooneya, silver,” hiyulhni, 'et 'uneltsuk hiba hiyoodalhto. ");
INSERT INTO cafNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","'Et whuts'un nts'e na'a butl'aitelhtelh 'et hukwunúta. ");
INSERT INTO cafNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","'Et k'an 'aw 'et ndi lhes chantíldoh dzin whusawhélts'ut hoh ndunnah Sizi yugha hoodul'eh, 'en highu nindel 'ink'ez huyoodulhkut, “Njan Hubutus Lhuseya 'ute'alh, nts'e mba lhats'odutelilh hukwa' nínzun?” ");
INSERT INTO cafNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","'Et ndo búlhni, “Nyooz keyah whuti whuz ahdulh. 'Ilhunuh dune suba ndudóohtni, ‘Nehodulh'eh njan ndutni, 'aw 'et suba nilhdukw whezulh. Nkoo ts'ih ndunnah sugha hoodul'eh njan butus lhuseya, 'et 'ilho hubulh whunatelnih.’ ” ");
INSERT INTO cafNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","'Ink'ez yugha hoodul'eh Sizi daja hubudani, 'et whuz na'a nduhuja. 'Ink'ez njan Hubutus Lhuseya 'et wheni lhaháduja. ");
INSERT INTO cafNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","'Aw 'et hulhgha whusahonzut lanezi 'o 'at nanah yugha hoodul'eh, 'en hubulh natl'adeda hubula na'tet'alh ka. ");
INSERT INTO cafNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","'Et 'uha'alh hubutah ndo búlhni, “'Alha 'ún whudusni njan nuhtah 'ilhunuh whutl'asutelhtelh.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","'Et ts'iyawh ni huzdli, 'ink'ez 'ilhunah hinli hoh hiyoodulhkut, “SMoodihti si tulih sudini?” ");
INSERT INTO cafNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","'Et ndo búlhni, “Ndan dules sulh toonayuz'ai, 'en 'utenilh whutl'asútelhtelh. ");
INSERT INTO cafNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","'Alha yinkak dune ye' nts'e na'a ba 'uk'e'eduguz, whuz na'a 'utenilh datetsah. 'Et dune ndan whutl'ayálhti, 'en dune degha nus hoontsi' bugha ootélts'ulh. Ndun dune 'aw cha'hóolel t'eh, 'et sih 'o nus buba hózoo wule da.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","'Et Judas, ndun whutl'aitelhtelh, 'en Sizi yoodulhkut, “Rabbi si ih sudíni?” 'Et ndi yúlhni, “Nyunch'oh 'udini.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","'Aw 'et 'uhan'al hoh Sizi lhes yilhchoot. Suchanailya ni hoh tenadedli. Taidalhkut 'ink'ez yugha hoodul'eh hubutaininik. 'Et ndo búlhni, “Úlhchoot 'ink'ez ah'alh. Ndi suyust'e 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","'Et lubot 'i chah yilhchoot 'ink'ez suchanailya ni hoh tenadedli. 'Et ndo búlhni, “Nuhwheni ts'iyawh ndi wahnai. ");
INSERT INTO cafNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ndi k'andit khunek 'i suzkai be nuhts'u nahuzíya. Lhanah ba nadútelt'ih. 'Et 'i be bulubeshi huba hoolah natedleh. ");
INSERT INTO cafNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Njan 'et 'un whudusni, ndi mai too, doo chah zeh 'aw chatuzésnil. 'Et whunts'ih ndi mai too k'an, 'i nuwhulh tesnilh. Nts'e se'aBá hubudayi cho unli, 'et whuz lhgha dahdel, 'et dzin nuhwhubulh tesnilh.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","'Et Yak'usda buyun be héjun 'ink'ez ndoh dzulhyaz k'uz Olive hiyulhni, whuz whehandel. ");
INSERT INTO cafNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","'Aw 'et Sizi ndo búlhni, “K'an 'ulh'ek nuhwheni ts'iyawh skahóoyatehle. Ndez na'a 'uk'e'edúguz hoh ndutni, ‘Sheep ghunli, tuzelghelh huba whutl'aitelhtelh. 'Ink'ez 'et sheep ts'iyawh lhtatelh'us.’ ");
INSERT INTO cafNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","'Et dinadusja hukw'elh'az t'eh, 'et yun k'ut Galilee ts'ih nuhwhutsah tesyalh.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","'Et Peter ndi yúlhni, “'Et ts'iyawh nyun nkayahutele, 'et whunts'ih si 'aw nkayáchatuzésdle.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","'Et Sizi njan ndi yulhni, “'Alha, 'i be 'un nyudúsni, 'et k'an 'ulh'ek ligok dune 'uduténilh whutsuh, 'et tat t'echasunuzínzun dutanilh.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","'Et Peter 'utni, “Nyúlh datesah t'eh, 'et whunts'ih 'aw t'echanyunuzúszun doosni ghaít'ah.” 'Et 'onghun yugha hoodul'eh, 'en chah whuz na'a zeh 'uhutni. ");
INSERT INTO cafNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","'Et 'ilhunuh haniyeh k'et Gethsemane huwhútni ts'ih whuz hunindel hoh Sizi yugha hoodul'eh ndo búlhni, “Nuhwheni njan delhúts'i. 'Et si ye'at tenadutesdli.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Peter 'ink'ez Zebedee buzkeh, nanah, 'en hubilhchoot 'ink'ez dulh whebeldel. 'Aw 'et tso cho buk'édilts'ut 'ink'ez budzi tube yuk 'uja. ");
INSERT INTO cafNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","'Ink'ez ndo búlhni, “Suzul tube tso suli k'et 'aw 'et datesah li'ust'ah. Njan delhúts'i 'ink'ez sula huwahli.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","'O 'unyaz whinya hoh 'et nachaneti 'ink'ez tenawhéndunidli 'ink'ez njan ndutni, “'ABá ndi lubot be dzuh nuteszut, 'i whuz na'a 'int'ah t'eh, 'et whute senghólts'it. 'Et whunts'ih 'aw si hukwa' nuszun k'una'a ilah. Nyun hukwa' ninzun hukw'un'a 'et 'uhóneh.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","'Et ndunnah yugha hoodul'eh nahunistez hoh bughu nanja. 'Et Peter ndi yulhni, “'Aw ih lhuk'i hukw'e'uhunint'o whuts'un sula ghónle ghaít'ah? ");
INSERT INTO cafNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tink'us nínt'uk whuch'a howinli 'ink'ez tenadinli! 'Alha dune yéghah whuz na'a hukwa' ninzun, 'et whunts'ih buyust'e laít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","'Et doo chah zeh whulh nat bugho whenaja tenadutedli ka. 'Et njan ndutni, “'ABá ndi lubot ts'iyawh usnai t'eh, 'et k'an zeh sughu natalcholh. 'Et whuz na'a zeh hukwa' ninzun t'eh, 'et ndó hot'e.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","'Et doo chah zeh nahuneztez hoh bughu nanja. Bulh huba yilhtus k'et 'aw hitóo'en ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","'Aw 'et bugho whenaja 'ink'ez whulh tat, 'i khunek 'i be zeh tenadedli. ");
INSERT INTO cafNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","'Aw 'et yugha hoodul'eh bughu nanja 'ink'ez ndo búlhni, “'Awhuz nalhúyis 'ink'ez sahtez hó ih aht'ah? Soo zélhts'ai 'aw 'et suba whusawhélts'ut. Yinkak dune ye' 'en ndunnah lubeshi 'uhulh'en, 'en butl'asátelhtelh. ");
INSERT INTO cafNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Soo 'a dinadahdelh! 'Aw 'et uztoodelh sih! Whunulh'en ndun butl'asútelhtelh, 'aw 'et seghah uyalh!” ");
INSERT INTO cafNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","'Awhuz yalhtuk hoh 'et khunyaz Judas, 'en whusainya, 'en ndunnah lanezi 'o 'at nanah whuhél'a, 'en ndun 'ilhunuh 'int'ah. 'En bulh lhanah dune yulh whusaindel. Bulunah soh cho nuhule, 'ink'ez bulunah be netunuzdult'o nadule. Náwhulnuk bumoodih 'ink'ez dune netsuh whudelhdzulh, 'en whusaoohábahalh'a. ");
INSERT INTO cafNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","'Aw 'et ndun Sizi hubutl'aitelhtelh, 'en 'ilhunahuwésdel ndo búlhni, “Ndan nandunests'ooz, 'en 'udúsni. 'En 'ahoh olhchoot!” ");
INSERT INTO cafNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","'Et 'ahoh Sizi yughu ninya hoh “Dahooja Rabbi,” yulhni 'ink'ez 'en naindunants'ooz. ");
INSERT INTO cafNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","'Et Sizi ndutni, “Sulh dune di ka whusainya?” 'Aw 'et whusahandel 'ink'ez Sizi 'aw 'et hiyilhchoot. ");
INSERT INTO cafNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","'Et khunyaz 'ilhunuh Sizi yulh 'int'ah ndi soh cho hayálhtsus 'ink'ez náwhulnuk degha nus dezti be 'ulhna, 'en yudzo yuts'ah habé' yalht'o. ");
INSERT INTO cafNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","'Et Sizi ndi yulhni, “Nyoo soh cho t'unádintih! 'Alha ndunnah 'et nduhút'en, 'en 'et hukw'e dahutetsah. ");
INSERT INTO cafNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","'Et si hukwa' nuszun t'eh, se'aBá oodalhkut t'eh 'ink'ez k'an 'ahoh 70,000 lizas 'o 'un 'uhuneltsuk, 'en da sts'o tl'aboolelh wule da sula hutenilh ka. 'Et 'aw t'eoonuzínzun hoh 'int'en. ");
INSERT INTO cafNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","'Et zeh ndust'en t'eh, nts'e na'a Yak'usda bughunek lhadútenilh? Nts'e na'a sts'un dawhut'ih, 'et whuz na'a 'uhóneh huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","'Aw 'et wheghah 'uhunet'oh hoh Sizi 'ilhunahuwésdel ndo búlhni, “'Et di ka soh cho 'ink'ez be netunuzdult'o chah nudáhle 'ink'ez 'undunaht'ih hukw'u n'a'a skaootéhdel? Dzin totsuk luglez whucho 'et nuhwhutah sída 'ink'ez whunohodulh'eh. 'Et whunts'ih 'aw chasúlhchulh. ");
INSERT INTO cafNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","'Et huwa, nus whunilh'en bube' dustl'us hukw'e'edúguz, 'et ts'iyawh lhawhúdutenilh.” 'Aw 'et higha hoodul'eh, 'en whulahúdetnik 'ink'ez highut sitélhdel. ");
INSERT INTO cafNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","'Aw 'et ndunnah Sizi hiyilhchoot, 'en náwhulnuk degha nus dezti, Caiaphas hiyulhni, ghu hinílhti. Moses be' dustl'us 'uk'ununa'úsduguz, 'ink'ez dune tsuh whudelhdzulh chah, whuz 'ilhunahuwésdel. ");
INSERT INTO cafNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","'Et Peter 'o niz de hubuneyalh hoh náwhulnuk degha nus dezti bukoo whuna'nezdútl'oo whuz níbunenya. Whuz hubughu daninya hoh nélhghel buzih natl'adeda 'ink'ez na'dunildzilh, daootenilh whuntelh'ilh 'et hukwa. ");
INSERT INTO cafNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","'Et náwhulnuk bumoodih, 'ink'ez dune netsuh whudelhdzulh chah, 'ink'ez nahuheyelh chah, 'en ts'iyawh hoonliyaz whuts'it hubugha highu nahó'alh hukwa' hut'en hituzelhghelh ka. ");
INSERT INTO cafNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","'Et whunts'ih 'aw hiyulh náho'alh hoolah. Lhanah dune whusahándel 'ink'ez huwhuts'it be highu yalhtuk. 'Et whunts'ih 'awhuz hoonli hiyulh nachawhus'ai. 'Et khunyaz nanah dune huwhuts'it whuz haha'az ");
INSERT INTO cafNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","hoh nduhútni, “'Et ndun dune 'utni Yak'usda hubuluglez whucho hoolah whutelhtsilh 'ink'ez tat dzin whutah 'udun na'whutelilh ni,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","'Aw 'et náwhulnuk degha nus dezti didinya 'ink'ez Sizi yoodulhkut, “'Aw ih daja chadáhnil? Daja hutni 'et hubugha daja ninzun?” ");
INSERT INTO cafNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","'Et Sizi 'aw nt'edusnih. 'Et náwhulnuk degha nus dezti, 'en 'uyulhni, “Ndun Yak'usda khuna, 'en be nyudusni yatalhtuk huba' hoont'ah. 'I be mba nahutedeh. Nedini Christ Yak'usda buYe', 'en ih 'unint'ah?” ");
INSERT INTO cafNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","'Et Sizi ndi yulhni, “Nyunch'oh 'et 'udíni. 'Et njan hubugha nohwhulh yalhtuk, nk'atlih t'eh yinkak dune ye', 'en ndun be hóolhtus, 'en nalhnih ts'ih yughu usda, 'et whuteh'ilh. 'Ink'ez kw'us k'ut ndus de hatéyalh, 'et chah whuteh'ilh.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","'Et náwhulnuk degha nus dezti ye usda, 'i bubut gha lhts'e yalhch'ul 'ink'ez 'utni, “Yak'usda ch'a detni hoh yalhtuk. 'Aw 'uyoon nedóni hukwa cha'uznízun. K'an whunulh'en Yak'usda ch'a detni ts'iyawh nuhwheni nuhnalh 'utni. ");
INSERT INTO cafNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Daja nahzun?” 'Et 'uhutni, “Daóotsah huba 'uhoont'ah!” ");
INSERT INTO cafNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hinen ts'ih huyoodunuzewh. Huyoolhchis 'ink'ez bulunah hiyoonukat. ");
INSERT INTO cafNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","'Et whuz na'a nduhíyulhni, “Neba nus whutan'ilh. Nyun 'int'ah Christ inli t'eh, ndan 'unyinla nyunézkuk?” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","'Et Peter n'az whuna'nesdútl'oo whez ts'ih usda hoh ts'ekeyaz yughu ninya. 'Ink'ez ndi yulhni, “Ndun Sizi Galilee whut'en, nyun chah bulh 'int'en inle!” ");
INSERT INTO cafNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","'Et ts'iyawh hububut whuts'oodedlai hoh ndutni, “Daja dini 'aw nt'echaoonuzúszun.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","'Et 'az tínanja. 'Uyoon ts'eke chah yunilh'en, 'ink'ez hoh nahudelhúya, 'en ndo búlhni, “Ndun 'en chah Sizi Nazareth whut'en bulh 'int'ah inle.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","'Et doo chah zeh neghan ndoh nalh whuts'oodésdlat hoh ndutni, “Ndun dune 'aw nt'echanuzúszun!” ");
INSERT INTO cafNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hukw'elh'az ndunnah yuzih nuhudelhúya, 'en highu nindel hoh 'uhiyúlhni, “'Alha ndunnah yulh 'uhant'e, 'en nyun chah 'ilhunuh 'int'ah. Nts'e na'a yailhtuk, 'et huwa t'ents'unínzun.” ");
INSERT INTO cafNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","'Et Peter ndutni, “Yak'usda sts'e'telhtsus 'aw ts'ah'un cha'duzusnih t'eh, ndun dune 'udáhni, 'aw t'echanuzúszun.” 'Et 'ahoh ligok dune 'udéja. ");
INSERT INTO cafNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'Et Sizi daja ni 'et Peter whunalnik hoh njan ndutni, “'Et ligok dune 'uduténilh whutsuh, tat 'aw t'echasunuzinzun dutenilh.” 'Et 'az whenaja 'ink'ez tube cho howintse. ");
INSERT INTO cafNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","'Et 'om bun bundada 'uda náwhulnuk bumoodih, 'en ts'iyawh, dune netsuh whudelhdzulh, 'en chah, 'en Sizi hich'a detni hoh howu yahalhtuk hituzelhghelh hukwa. ");
INSERT INTO cafNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","'Et Sizi hiyulhghel 'ink'ez yun k'ut whumoodih, 'en Pontius Pilate hiyulhni, hits'un hinilhti. ");
INSERT INTO cafNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","'Et ndun whutl'ayálhti, 'en Judas hiyúlhni, 'aw 'et Sizi datetsah huba ba nahisda hoh, 'et nt'eoonanzin hoh tube budzi nduda suli. 'Et ndi tat lanezi sooneya silver hiyulhni, ndunnah náwhulnuk bumoodih 'ink'ez dune netsuh whudelhdzulh chah, buba whusanáyandzai. ");
INSERT INTO cafNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","'Et ndo búlhni, “Njan ndusja hoh tinta' nust'en. Ndun dune nuhts'un whutl'aílhti, 'en 'aw tinta cha'ít'il.” 'Et 'uhiyúlhni, “Nuwheni neba cha'hóot'ah. Nyunch'oh zeh mba' hoont'ah!” ");
INSERT INTO cafNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","'Et ndi tat lanezi silver ts'utni, 'i sooneya luglez whucho yun hububut nayántsut. 'Et 'ink'ez 'az whenaja 'ink'ez tsená'usduguz. ");
INSERT INTO cafNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","'Et ndunnah náwhulnuk bumoodih ndi sooneya silver ts'utni, 'i hiyilhchoot 'ink'ez 'uhutni, “Dune buzkai suli, 'i 'int'ah. 'Et huwa 'aw Yak'usda ba be 'úzdla, 'i be náts'oodzaih ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","'Et dich'oh dutah howu yahalhtuk. 'Ink'ez ndan lhez 'oosa' 'ulh'en, ndi sooneya 'i be yun hiyónket. 'I k'ut 'uts'un whut'en wheyóbahule 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","'Et huwa soo k'an njan dzin 'et whuts'un ndi yun boozi 'i 'uskai yun hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","'Et whuz na'a hoh da ndun nus whunilh'en Jeremiah, daja ni 'et nduhóolcho túne' whust'en 'et lhaóodija njan ndutni, “Ndi sooneya silver ts'utni, 'et tat lanezi 'et 'uneltsuk ulhchoot. 'Et 'uneltsuk hiyoodolhto, ndun Israel hits'uh hainde, 'en huba k'elha hiyoolhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","'Ink'ez lhez 'oosa' 'ulh'en, 'en buyun hiyónket. 'Et whuz na'a Moodihti sudani.” ");
INSERT INTO cafNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","'Aw 'et Sizi ndun yun moodih 'en yubut siyin. 'En yun moodih yoodulhkut, “Nyun ih 'int'ah Lizwif hubudayi cho inli?” 'Et Sizi ndi yúlhni, “A, 'alha dini.” ");
INSERT INTO cafNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","'Ink'ez ndunnah Lizwif bumoodih 'ink'ez dune netsuh whudelhdzulh chah, 'en hik'eho'alh hukwa' hut'en. 'Et whunts'ih 'aw hoonliyaz cha'dínil. ");
INSERT INTO cafNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","'Et Pilate yoodulhkut, “'Aw ih cha'duzínts'uk, 'aw daooneltsuk hoh nch'a yahálhtuk?” ");
INSERT INTO cafNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","'Et 'aw lhuk'i khunek be whunts'ih daja chadinil. 'Et hoh yun k'ut whumoodih tube buba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","'Et nawhudezulh totsuk Lizwif butus lhuseya 'et whunahulnih, 'et whutah yun moodih ndan tsak'esda 'ilhunuh hika' ninzun, 'en ts'iyannah buts'un lanadutetnih. 'Et whuz na'a buk'ah ts'ih 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","'Ilhunuh tsak'esda, 'en Barabbas hiyulhni, ts'iyannah t'ehinínzun. ");
INSERT INTO cafNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","'Et ts'iyawh 'ilhunahuwésdel hoh Pilate huboodulhkut, “Ndan nuhwhuba bulanadutesnih hukwa' nahzun, Barabbas k'us Sizi, 'en Christ hiyulhni?” ");
INSERT INTO cafNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","T'eooninzun 'oolnih bugha butl'ahíyalhti. ");
INSERT INTO cafNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","'Et Pilate dune ba nahedilh, 'i kw'usuda k'usda hoh bu'at 'en khunek yuts'ó tl'aida'ai, 'et ndi yulhni, “Ndun dune 'en ts'ah'un 'int'ah. Hoonliyaz onleh gunih! 'Alha k'an dzin 'en bugha huwu nusíti 'et hoh dzuh nusízut.” ");
INSERT INTO cafNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","'Et ndunnah náwhulnuk bumoodih 'ink'ez dune netsuh whudelhdzulh chah, 'en 'ilhunahuwésdel ba hubahoont'i 'et whuz na'a 'uhóoneh ka, 'en Pilate, Barabbas yulanadootnih 'ink'ez Sizi hoolah hiyoolhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","'Aw 'et yun moodih 'en huboodulhkut, “Ndunnah nanah, 'en k'us ndan nuhwhuba bulanadutesnih hukwa' nahzun?” 'Ink'ez 'et 'uhiyúlhni, “Barabbas.” ");
INSERT INTO cafNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","'Et Pilate ndo búlhni, “'Et ndun do, Sizi ndun Christ hiyúlhni, 'en nts'e na'a chah daóosdleh ka?” 'Et 'ilhunahuwésdel nduhíyulhni, “Lhdulalhgus kélhtih!” ");
INSERT INTO cafNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","'Et yun moodih 'et ndutni, “Di ka? Ndet hoh tinta' 'ant'en?” 'Et whunts'ih sulyehúdelya, “Lhdulalhgus kélhtih!” hutni. ");
INSERT INTO cafNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","'Et Pilate t'ewhunínzun 'aw hoonliyaz 'uhooleh ghaít'ah. Ndunnah 'ilhunahuwésdel 'aw 'et lhtahotét'alh li'hoont'ah. 'Ink'ez 'ilhohuwezdel hububut too be lana'elde 'ink'ez ndo búlhni, “Ndun ts'ah'un dune buzkai but'aghóosnalh hukwa cha'nuzúszun. Nuhwhenich'oh zeh nuhwhuba 'uhoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ts'iyannah dune 'et nduhútni, “Nuwheni ts'iyawh neuzkeh tubulh buzkai whuteleh, 'et nek'éholts'it!” ");
INSERT INTO cafNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","'Aw 'et Barabbas buba yulanadetnik 'ink'ez Sizi hiyolhtsus. 'Et hukw'elh'az butl'ayálhti lhdulalhgus k'ehíyoolhtelh ka. ");
INSERT INTO cafNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","'Aw 'et yun moodih 'en nehughan huwhut'i, 'en Sizi hiyílhchoot 'ink'ez bukoo ts'ih whehíyalhti, 'et Praetorium huwhútni. 'Et ts'iyawh ndunnah nehughan Sizi higha' wezguz. ");
INSERT INTO cafNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","'Et hinaih hits'u húnuhuyulhch'ul hoh nalhti dulk'un, 'i be híyalhti. ");
INSERT INTO cafNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Whus cho nahinelhbaz, 'i hitsi nihída'ai. 'Ink'ez tl'oghazilh nalhnih ts'ih hila k'ehídantan. Hubudayi cho k'una'a oot'e ka hitl'ahídantan. Hibut nachánuldulh cha' hiyulh'en. 'Et whuz na'a highudloh. 'Ink'ez “Lizwif hubudayi cho sa cho khona!” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Highá dizoh, 'ink'ez tl'oghazilh be hitsi oonulht'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","'Et highudloh 'ustl'e' 'uhudeja hoh ndi nalhti highun náhuyílchoot 'ink'ez dich'oh bunaih be nahíyalhti. 'Aw 'et lhdulalhgus k'ehítelhtelh ts'ih hítelhti. ");
INSERT INTO cafNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","'Aw 'et Sizi tehínilhti hoh 'ilhunuh dune Cyrene whut'en 'int'ah, 'en Simon hiyúlhni, 'en hidudezdel hoh ndi Sizi bulhdulalhgus buba idantilh hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","'Aw 'et njan Golgotha ts'uwhútni whuz lhgha hudindel. 'Et ndi khunek ‘'Utsints'un nez'ai,’ ni hoh 'utni. ");
INSERT INTO cafNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","'Et mai too dunink'ooz, 'i 'ink'ez yoo, gall ts'utni, hitaidenla. 'I yulh yootnai hukwa' huyinla. 'Et yálhka 'ink'ez 'aw yootnai hukwa cha'nízun. ");
INSERT INTO cafNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","'Et lhdulalhgus yehídunilht'o hukw'elh'az hinaih higha 'áinlih. Dahúja 'et hoh da nus whunilh'en nts'e na'a 'udani, 'et ts'iyawh hukw'u na'a 'uhooja. Ndez na'a njan dudani, “Ndi sunaih dich'oh lhtahiyulya. 'Ink'ez bulah higha 'ainli cha' hiyínla.” ");
INSERT INTO cafNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","'Aw 'et nátl'ahudelts'i 'ink'ez highunli. ");
INSERT INTO cafNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Butsi huwa ndoh ts'ih lhustelyaz whehindunilht'o. 'Ink'ez ndet hik'ehoo'ai 'et 'uk'e'hanguz. 'Et ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nanah 'uhundunut'ih, 'en chah hiyulh lhdulalhgus k'ebuhilhti. 'Ilhunuh nalhnih ts'ih, 'ink'ez 'ilhunuh 'intl'as ts'ih. ");
INSERT INTO cafNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ndunnah wheghah whehúdelh nodunul'us 'ink'ez hich'a detni hoh yahalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","'Et 'uhiyúlhni, “Nyun 'int'ah luglez whucho nanaóodutanlelh 'ink'ez tat dzin zeh na'whutanlelh dini! Nyunch'oh 'ududílyih! Yak'usda buYe' inli t'eh, ndi lhdulalhgus k'ut buk'ut nanaíndaih!” ");
INSERT INTO cafNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","'Et ndunnah náwhulnuk bumoodih, 'en chah whuz na'a zeh highudloh. Moses be' dustl'us 'uk'ununa'úsduguz, 'en chah 'ink'ez dune netsuh whudelhdzulh chah, ts'iyawh whuz na'a zeh 'uhutni hoh ndez na'a njan duhutni, ");
INSERT INTO cafNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“'Uyoon ulhyis 'et whunts'ih dich'oh 'aw 'ududoolyih ghaít'ah. Israel buts'u hahánde, 'en ba hubudayi cho unli t'eh, 'et t'eh ndi lhdulalhgus yuk'ut nanaóoja wule da. 'Et t'eh da neba 'alha 'oot'e. ");
INSERT INTO cafNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","'En Yak'usda t'anínentan. 'Et huwa Yak'usda yuka' ninzun t'eh, k'an 'ahoh da yoolhyih. 'En 'utni si Yak'usda buYe' 'ust'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ndunnah 'uhundunut'ih yuzih lhdulalhgus k'usulhti, 'en chah whuz na'a zeh 'et nduhíyulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dzetniz hukw'elh'az 3:00 bat'en 'ink'ez hulhgha 6:00 bat'en 'et whuts'un ndi yun k'ut ndúwhulcho tsahólhgus suli. ");
INSERT INTO cafNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","'Et 6:00 bat'en Sizi tube cho ka' deduja hoh, “Eli, Eli, lama sabachthani?” Ndi khunek, “SuYak'usda, SuYak'usda di ka sula dantnik,” ni ho' 'utni. ");
INSERT INTO cafNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bulunah dune 'et nuhúdelhuya hidánts'o 'ink'ez 'uhutni, “'Ah! Elijah hahayih hoh 'utni!” ");
INSERT INTO cafNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'Et 'ahoh 'ilhunuh whusalgai, 'ink'ez duchun bula'dul'oo, 'i mai too dunink'ooz, 'i ye toonayuztan 'ink'ez nduk Sizi yuzek be naóonulhtsul. ");
INSERT INTO cafNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","'Onghunnah 'uhutni, “Bukaza'ez! Khunsih, Elijah yughu ninya 'ink'ez tulih yoolhyih.” ");
INSERT INTO cafNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Doo chah Sizi tube cho 'udéja 'ink'ez duyéghah yula detnik. ");
INSERT INTO cafNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Khunyaz luglez whucho bez ts'ih hukwadelhchooz 'i lhulcho lhk'énch'ul. 'Et yun chah nughésnai, 'ink'ez tse cho chah lhts'edankat. ");
INSERT INTO cafNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ts'un k'ut dune 'adinla 'et cha da' dutezkat. 'Ink'ez lhanah dune Yak'usda bube'ildzun, 'en nahunestez inle, 'en dináhudidel. ");
INSERT INTO cafNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","'Aw 'et tse be tsa k'et ts'ih hanáhedel, 'ink'ez keyah Jerusalem ts'ih whehandel. 'Et lhanah nalhts'et hube hóodiltsai, 'et whébunelhtan. Sizi nakhitna hukw'elh'az ndulhcho 'et ndúhooja. ");
INSERT INTO cafNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","'Aw 'et ndun nehughan bumoodih 'en, 'ink'ez yulh 'uhut'en, 'en ndunnah Sizi yughunli, yun nughéznai 'ink'ez nts'oh tuné'whust'en, 'et honalh'en, 'et hoh tube whehunelhújoot 'ink'ez 'et 'uhutni, “'Alha ndun dune, 'en Yak'usda buYe' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Lanah ts'ekoo chah 'et nahudelhúya ye 'az de whuts'un honilh'en. 'En Galilee ts'ih hahándel 'uhut'en. 'En Sizi whusahínandel 'ink'ez hiba ne'úst'en 'uhint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","'En hubutah Mary, Magdala whut'en, 'en chah 'ut'en, 'ink'ez Mary, James 'ink'ez Joses bulh 'en hube'ama, 'en chah 'ut'en, 'et Zebedee buyekah 'en be'ama chah, 'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","'Aw 'et hulhgha wheghah whezulh hoh 'ilhunuh Arimathea whut'en, dune soode'a 'int'ah, 'en Joseph 'uhiyulhni. 'En chah Sizi yugha hoodul'eh 'ilhunuh suli. ");
INSERT INTO cafNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","'En Pilate ts'ih whinya, 'ink'ez Sizi buyust'e yuts'un ka na'dutni dutl'ayóolhtelh ka. 'Et Pilate ndo búlhni, “Sizi buyust'e ndunnah butl'ayúlhtih.” ");
INSERT INTO cafNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","'Et Joseph Sizi buyust'e ndus de hanáyalhti 'ink'ez naih dezti, 'i 'aw chaditsun, 'i yugha iwézduz. ");
INSERT INTO cafNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","'Et dich'oh butse be tsa k'et k'an 'uhoonla, 'et bez ts'ih 'et neínilhti. 'Et tse cho be whudanaindunelhmul 'ink'ez whenája. ");
INSERT INTO cafNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdala whut'en, 'en chah 'et usda. Njan tsa k'et huwanch'az, 'et 'uyoon Mary chah 'et usda. ");
INSERT INTO cafNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","'Et njan dzenis whuti 'et wheni lhazdutneh dzin 'uhoont'ah. 'Et 'om bun dzin ndunnah náwhulnuk bumoodih 'ink'ez Pharisee chah, 'en ts'iyawh Pilate ts'un whehandel. ");
INSERT INTO cafNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","'Et ndi híyulhni, “Nemoodih ndun nena'a 'awhuz khuna hoh daja neúlhni, 'et whunats'ulnih hoh ‘Tat dzin inle t'eh dinádutésdalh,’ ni. ");
INSERT INTO cafNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","'Et hoh nghunek be budóoni njan tsa k'et da'dute'a whulh tat dzin 'et whuts'un. 'Et 'aw ndúchainel t'eh ndunnah yugha hoodul'eh 'ulh'ek whusahándel 'ink'ez hiyust'e hindutet'ih tulih. 'Ink'ez ts'iyannah ndoh budóoni ndunnah yaidla hubutah dinadeja ho' 'int'ah. 'Et whuz na'a 'udek'elh'az whuts'it, 'i 'udechoo, 'i degha nus 'ultsi' whutéleh,” hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","'Et Pilate ndo búlhni, “Nuhwheni chah nohhowunli aht'i hoh aht'ah. 'Aw 'et nahdulh 'ink'ez nuhwhenich'oh soo duts'o cho hoh dána'deh'aih!” ");
INSERT INTO cafNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","'Et whehándel 'ink'ez ndi tse k'ut whuduná'hudelhdze. 'I be duts'o cho whuzdli. 'Et 'ink'ez howu hinli 'en 'et nibanínla. ");
INSERT INTO cafNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nats'ulyis dzin hukw'elh'az hukw'enilhghel, 'et 'udechoo dzin, soo haootelh'en, 'et Mary Magdala whut'en 'ink'ez 'uyoon Mary bulh ts'un k'uz huni'az 'ink'ez honilh'en. ");
INSERT INTO cafNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Khunyaz 'ilhunuh neMoodihti bulizas yak'uz hainya. 'Et huwa yun chah nughesnai. Whusainya 'ink'ez ndi tse whudahaidunalhmul, 'ink'ez yuk'étl'adida. ");
INSERT INTO cafNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bunen 'ants'ih ditnik kwun nduwhút'en. Bunaih tsil k'una'a lhiyul. ");
INSERT INTO cafNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","'Et huwa ndunnah howuhinli nujut k'et hudulduz, 'ink'ez 'ants'ih dune dahuzsai li'huja. ");
INSERT INTO cafNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lizas ndunnah ts'ekoo ndo búlhni, “Nulhújut ilah. T'eoonuszun Sizi ndun lhdulalhgus k'ut dazsai, 'en bukunáhta hó 'aht'en. ");
INSERT INTO cafNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","'Aw njan hoolah! Dinadeja ho' 'int'ah. Nts'e na'a datenilh ni, whuz na'a dinadija hó 'int'ah. 'Anih, njan whunulh'en, ndet neMoodihti ilhte! ");
INSERT INTO cafNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","'Et 'a cho whuz ah'us 'ink'ez ndunnah yugha hoodul'eh hubudáhni yaidla tah dinadija hó 'int'ah. Soo zelhts'ai nuhtsuh Galilee ts'ih iyalh. 'Et teh'ilh. Soo cho soo zelhts'ai 'uda ndun whudáni.” ");
INSERT INTO cafNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","'A tsih tse be tsa k'et whuch'a nahúnt'az. Whehunelhujoot 'et whunts'ih 'o nus huhóont'i cha' hint'ah. 'Ink'ez ndunnah yugha hoodul'eh 'en buts'un whuhelgai ndoh buduténilh ka. ");
INSERT INTO cafNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","'Et ndunnah yugha hoodul'eh ts'ih he'us hoh khunyaz Sizi bududezya 'ink'ez ndo búlhni, “Whunélhnik.” Hizih neni'az 'ink'ez hike óontun 'ink'ez hits'u téni' nalhdzin. ");
INSERT INTO cafNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","'Et Sizi ndo búlhni, “'Aw whénulhujut ilah. sulhutsinkah buts'un naht'us 'ink'ez sba dobudóohni, nuhwheni ts'iyawh Galilee ts'ih toohdelh. 'Et si suhunoolh'en.” ");
INSERT INTO cafNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","'Aw 'et hutezdel hoh 'et howuhinli bulunah Jerusalem ts'ih hunindel. 'Et whuz hunindel hoh 'et ndunnah náwhulnuk bumoodih, 'en 'et nduhóolcho hubudáni njan ndet dahooja 'et. ");
INSERT INTO cafNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","'Aw 'et náwhulnuk bumoodih 'ink'ez dune netsuh whudelhdzulh, 'en ts'iyawh 'ilhunahuwésdel 'ink'ez howu yahalhtuk. 'Ink'ez lhai sooneya 'i lhahudughan hubugha hinendzai. ");
INSERT INTO cafNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","'Et ndo buhútni, “'Et nuhwheni ndez na'a 'udutéhnilh, ‘'Et 'ulh'ek 'awhuz ts'uztez hoh ndunnah yugha hoodul'eh whusahanel'i 'ink'ez buyust'e neghu hitelhti.’ ");
INSERT INTO cafNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","'Et yun moodih whulh 'údants'o t'eh, soo kháznent'a hoh bulh yats'oolhtuk sih. 'Et t'eh whuz na'a 'aw hoonliyaz nuhts'u cha'hosne.” ");
INSERT INTO cafNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","'Et huwa ndunnah lhahudughan ndi sooneya hiyoolhchoot, 'ink'ez nts'e na'a ndo badáni, 'et whuz na'a zeh 'o 'unnah chah hubudáni. 'Et soo k'an dzin 'et whuts'un, 'et whuz na'a Lizwif dich'oh dutah howu yahalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","'Aw 'et ndunnah lanezi 'o 'at 'ilhunuh 'en yugha hoodul'eh, 'en Galilee ts'ih whehandel. Ndi dzulh k'uz Sizi hubudani, whuz whehandel. ");
INSERT INTO cafNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hiyan'en hoh hits'un teni' nalhdzin. 'Et whunts'ih bulunah huba cha'hoot'ah. ");
INSERT INTO cafNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sizi hubuts'un whusainya hoh hubulh yalhtuk 'ink'ez njan ndo búlhni, “Yak'uz 'ink'ez ndi yun k'ut 'i ts'iyawh huwandoh 'ust'ah, 'et sutl'awhélts'ut. ");
INSERT INTO cafNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","'Et huwa lhelhts'un keyah whut'en, 'en ts'iyawh buts'un nahdulh 'ink'ez si sugha hoodul'eh hubulhtsi. Se'aBá 'ink'ez 'uYe' 'ink'ez Ndoni, ndi boozi be 'i be too be' butelh'ilh. ");
INSERT INTO cafNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ndai khunek nuhtl'adá'ai, 'i ts'iyawh hik'une' 'oot'en hubodoolh'eh. 'Ink'ez sih soo zelhts'ai, 'et dzin whulatah lhaoodija t'eh, 'et whuts'un 'ahoolhyez nohwhulh 'útest'ilh ho' hoont'ah.” 'Et ndoh honeh.");
INSERT INTO cafNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ndi khunek unzoo, 'i khunek 'udechoo, 'i Sizi Gri, Yak'usda buYe' bugha. ");
INSERT INTO cafNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","'Uda Yak'usda be nus whunilh'en, ndi Yak'usda bughunek bugha 'uk'une'úsduguz, 'i 'et njan ndutni, “ ‘Yak'usda 'ust'ah, sóo zelhts'ai, 'uyoon khunek suba na'á ntsuh tes'alh, mba lhaoodutelilh 'et wheni.’ ");
INSERT INTO cafNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","'Et keyah, 'aw dune chahóot'ih, dune 'ultus hahuyih hoh, ‘NeMoodihti whuz de uyalh, buti buba lháoodahleh. Lhuteyalh hoonzoo 'ink'ez lhts'e whudez'a buba whulhtsi,” ni. ");
INSERT INTO cafNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","'Et 'uhóoja John dune too be 'ulh'en, 'aw dune chahóot'ih ts'ih ninya 'ink'ez tube 'o budáni, “Lubeshi whuch'a nuhwhubeni náhandunoohleh, 'ink'ez too be 'oohneh, 'aw 'et t'eh zeh Yak'usda nuhwhulubeshi nuhwhuba 'ún yutelhdulh.” ");
INSERT INTO cafNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ts'iyannah Judea whunat whut'en 'ink'ez Jerusalem whut'en chah hits'un lhghadindel 'ink'ez John dune too be 'ubulh'en hiyoozélhts'ai. 'Ink'ez hubulubeshi hubugha hunáhuwhulnuk hoh nyo 'et took'oh Jordan huwhútni toot 'et John dune too be balh'en. ");
INSERT INTO cafNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","'Ink'ez John dune too be 'ulh'en khunai gha sdútl'oo, 'i ye dune unli 'ink'ez 'uzuz se be sudelhú'oo. Tulk'us cho 'ink'ez honey, 'i ya'alh inle. ");
INSERT INTO cafNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","'Et ndo búlhni, “Dune sk'élh'az whusatéyalh sughanus dezti ho' 'int'ah. 'Aw bukechun ketl'oolh buba k'unaídutes'uk 'et whunts'ih huba soo cha'lhútdzooh. ");
INSERT INTO cafNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Too be 'unwhulh'en 'et whunts'ih ndun dune 'en Ndoni be too be 'unwhutelilh 'ink'ez Ndoni nuhyédute'alh.” ");
INSERT INTO cafNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","'Et sa ilah hukw'elh'az Sizi Gri Nazareth ts'ih hainya 'ink'ez took'oh Jordan huwhútni toot 'et John dune too be 'ulh'en Sizi too be 'uyínla. ");
INSERT INTO cafNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Soo Sizi tooz hanaja íbulh, nduk yak'uz dá' dutézkez whutélh'en, 'ink'ez Ndoni, dut'aiyaz k'una'a, dove hiyúlhni, ndus de buk'eyít'o. ");
INSERT INTO cafNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","'Et 'uwhútni, “Nyun suYe' inli. Tube nk'esi', 'ink'ez tube nyulh hoonúst'i.” ");
INSERT INTO cafNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","'Et 'ahoh Ndoni 'en Sizi nye'un 'aw dune chahóot'ih ts'ih wheyálh'a. ");
INSERT INTO cafNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","'Et dit lanezi dzin (40) Sizi 'aw dune chahóot'ih inda 'ink'ez Satan tink'us 'óoneh hukwa yóolhdzih. Khunai tsiyaini 'i chah hoonli. 'Et lizas whusahándel, 'ink'ez hiba ne'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","John dune too be 'ulh'en, tsak'ehíya'ai hukw'elh'az, Sizi Galilee ts'ih ninya 'ink'ez hubulh yálhtuk nts'e na'a Yak'usda buk'úne whut'en, 'et hubugha. ");
INSERT INTO cafNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","'Ink'ez 'et 'utni, “Ndi khunek unzoo, 'i 'int'ah. K'an 'aw 'et whusahónzut. 'Aw 'et nilhdukw Yak'usda buk'úne whutet'en ho' hoont'ah. Lubeshi whuch'a nuwhubeni náhandunoohlelh, 'ink'ez ndi khunek unzoo, 'i nuhwhuba 'alha 'oot'e 'ink'ez wúlhchoot!” ");
INSERT INTO cafNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","'Et Sizi bun k'ut Galilee taba nuya hoh nanah lhook ka' hut'en hubunilh'en 'en Simon 'ink'ez bulhutsin Andrew bulh lhoombilh tahíyalhdel lhook ka 'uhut'en hinli 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","'Et Sizi ndo búlhni, “Suneh'us, dune ka 'ooht'en whunwhudoolh'eh sih.” ");
INSERT INTO cafNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","'Et 'ahoh hubuloombil hiladetnik 'ink'ez hik'ah ts'ih 'uhoot'en ka hiyuntez'az. ");
INSERT INTO cafNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","'Et 'o 'unyaz hahándel 'et 'uyoon nanah lhulhutsinkah James 'ink'ez John bulh Zebedee buye'kah 'en hubutelh'en buts'i bet buloombil nahutl'oo. ");
INSERT INTO cafNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Soo Sizi hubutelh'en ibulh, “Anih,” hubúlhni. 'Aw 'et Zebedee buye'kah Sizi bulh whehá'az. Zebedee 'ink'ez yuba 'ut'en chah 'aw 'et ts'i bet hudélhts'i hoh bughoh whehá'az. ");
INSERT INTO cafNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Keyah Capernaum huwhútni whuz hunindel. 'Om bun dzin Lizwif nahulyis dzin, 'et Sizi Lizwif hubuluglez 'et bughut danínya 'ink'ez whehubondunilh'i. ");
INSERT INTO cafNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dune yudánts'o tube huba hooncha, soo buba 'uhoont'ah k'una'a hoh dune wheoobodalh'i, 'aw Moses be' dustl'us 'uk'une'úsduguz buk'una'a ilah 'utni. ");
INSERT INTO cafNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","'Et 'ilhunuh dune hubutah usda, 'en ntsi' nududeh, 'i k'úne' 'ut'en, 'alzul hoh 'utni, ");
INSERT INTO cafNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Sizi Nazareth whut'en ndet nets'ú hukwa' ninzun? Hoolah netalhtsilh ka ih whusaínya? Ndan ninli t'enyunúszun, nyun Yak'usda ba lubeshi bughu hoolah, 'en 'unint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","'Et Sizi hukwa' yudani hoh ndi yúlhni, “T'eduzinih hoh buyáh hanaindaih!” ");
INSERT INTO cafNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","'Et ntsi' nudúdeh, 'i ndun dune yukaootelhdzut, 'alzul, 'ink'ez yuyáhanaja. ");
INSERT INTO cafNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ts'iyannah huba hooncha k'et 'et 'ulhódutni, “Dant'un dune 'int'ah, whutsuh da chats'udústs'uk 'et whuneoodulh'eh? Bughunek be whúnujut k'et ntsi' nudúdeh, 'i whunts'ih hik'úne' 'ut'en.” ");
INSERT INTO cafNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","'Ahoh Galilee keyah whuti whunat whut'en Sizi hiyulh údants'o. ");
INSERT INTO cafNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","'Aw 'et Lizwif luglez tínahundel. Simon 'ink'ez Andrew bukoo ts'ih hunindel, James 'ink'ez John bulh chah whuz huni'az. ");
INSERT INTO cafNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon bubez kwusuti k'ut sulhti. Buyust'e nezul, 'i be undúda. Sizi whuz ninya ibulh ndi hidáni. ");
INSERT INTO cafNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","'Et yughu nínya 'ink'ez yula t'az nduk yilhchoot. 'Ahoh ts'eke soo 'uja 'ink'ez hubugha ná'unt'ai. ");
INSERT INTO cafNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hulhgha sa yun ts'ih tez'ai hukw'elh'az, ndan húnduda 'ink'ez dunnah ntsi' nudúdeh, 'i k'úne' hut'en chah Sizi gha banínla. ");
INSERT INTO cafNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ts'iyannah 'et keyah whut'en ndati 'ilhúhowezdel. ");
INSERT INTO cafNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Lhawh dédowh dada, 'i be húnduda, 'en Sizi soo ná'balh'en 'ink'ez ntsi' nudúdeh, 'i k'úne' hut'en, 'en chah dune yé hanabunanyoot. Ntsi' nudúdeh, 'i 'aw yahoolhtuk butl'achahóo'al, t'ehinínzun 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","'Om bun 'uda 'awhuz hootel'eh whutsuh da, 'et Sizi didinya 'ink'ez 'az whenya. 'Et nyo keyah whuch'a siya, ndet soo nehoolah ts'ih, whuz ninínya. 'Et tenadedli. ");
INSERT INTO cafNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon 'ink'ez dulh 'úhut'en, 'en Sizi híkunuta. ");
INSERT INTO cafNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nahuyilhti hoh 'et 'uhiyúlhni, “Ts'iyannah nkúnuta.” ");
INSERT INTO cafNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","'Et Sizi ndo búlhni, “Uts'un keyah ts'ih chah uztoodelh huba' hoont'ah dune bulh yatelhtuk, 'et huba whusáya.” ");
INSERT INTO cafNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Galilee ndulhcho nukéhudezde luglez totsuk hubulh yálhtuk 'ink'ez ntsi' nudúdeh, 'i dune ye hanábuneyukw. ");
INSERT INTO cafNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","'Ilhunuh dune, bukak whulhjut, leprosy hiyulhni, 'en Sizi ghu ninya, dugwútsi bé nenínya 'ink'ez yuts'u tédudli dula 'ooneh ka. “Nyun hukwa' ninzun t'eh, be ilhtus, 'i 'int'i, 'i be suná'ilhdeh,” yulhni. ");
INSERT INTO cafNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sizi yugha té'nanzin, yuts'un delhúnik 'ink'ez yut'agheznai. “Hukwa' nuszun, soo na'íntneh,” yulhni. ");
INSERT INTO cafNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","'Et zeh ndun dune bukak whulhjut, 'en soo ná'uja. ");
INSERT INTO cafNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sizi khunekti be yulh yálhtuk 'ink'ez 'aw 'et whenáyalh'a. ");
INSERT INTO cafNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ndun dune natesja 'et Sizi ndi yúlhni, “Soo zelhts'ai, 'uyoon dóni gunih! Inyalh ts'ih náwhulnuk 'en buts'ínyalh 'ink'ez nyunoolh'en. 'Et 'ants'ih soo na'ínja hukw'élha ndet Moses bughunek k'una'a náwhulnuk nts'u húkwa' 'utni, 'i hubugha íon'alh. 'Et ts'iyannah whúntalhtun ts'ah'un soo na'ínja.” ");
INSERT INTO cafNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","'Et whunts'ih ndun dune whenája 'ink'ez ts'iyannah ndo budáni 'o nus huwe yalhtuk k'et Sizi 'aw keyah dune tunóya ghaít'ah. 'Et n'awh dune chahóot'ih hoh dune unli. Lhelhts'un teh whut'en whuz highu lhk'esúdel. ");
INSERT INTO cafNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","'Et hukw'elh'az whutezut hoh Sizi koo Capernaum ts'ih lhgha nadija. Ts'iyannah whulh 'úhuduzts'ai. ");
INSERT INTO cafNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","'Et 'ahoh dune 'ilhuhowezdel. Whuz dune lhanah 'ilho daníndel k'et 'aw whuz'ai hoolah, ndati 'i bulh whudezbun. 'Et Sizi Yak'usda bughunek bugha hubulh yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yalhtuk hoh dinah dune, 'en 'ilhunuh dune buyust'e dechadusnik Sizi ts'un hítezkai. ");
INSERT INTO cafNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Whuz dune hulan 'ink'ez 'aw Sizi highah nióodelh ghaít'ah. 'Et nduk bun 'i k'ehiyílhti 'ink'ez soo ndet Sizi 'int'ah bat'en, whuz ndun dune buyust'e dechadusnik ndus de yuk'usti, 'i bulh hukwu hininkai. ");
INSERT INTO cafNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","'Et Sizi dahóolcho huba 'alha 'uhoont'ah t'eoonínzun, ndun dune buyust'e dechadusnik 'ulhni, “Uski nyulubeshi ts'iyawh mba hoolah suli.” ");
INSERT INTO cafNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bulunah Moses be' dustl'us 'uk'une'úsduguz, 'en nyo 'et hudelhts'i 'ink'ez 'uhinínzun, ");
INSERT INTO cafNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ndan na'dunúdzun hoh 'utni, Yak'usda ch'a yalhtuk. 'Aw dune lubeshi n'un hutoolhdelh ghaít'ah, Yak'usda 'en zeh lubeshi n'un yutelhdulh ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","'Et Sizi buyeghah be daja huninzun t'ewhunínzun 'et 'ahoh ndo búlhni, “Dáhoont'ah huwa hoh teh nuní nahzut? ");
INSERT INTO cafNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ndet degha nus huwa chahóolnah, ndun dune buyust'e dechadusnik 'udutésnilh, ‘Nyulubeshi mba 'un telhdel,’ k'us ‘Dinadindaih 'ink'ez ninya?’ ");
INSERT INTO cafNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Whunuh whuntelhtun, yinkak dune ye', 'en njan ndi yun k'ut lubeshi n'un tulhdelh huba' hoont'ah.” 'Et ndun dune buyust'e dechadusnik yúlhni, ");
INSERT INTO cafNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nyudúsni, bukw'usinti 'i ilhchoot 'ink'ez nkoo ts'ih naíndalh.” ");
INSERT INTO cafNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ts'iyawh hinilh'en hoh 'a hoh dinadija, yuk'usti, 'i yilhchoot 'ink'ez ts'iyannah nalh whenája. Soo ts'iyawh huba hooncha 'ink'ez Yak'usda hidálhti 'ink'ez 'uhútni, “Aw whutsuh da 'et nduhoont'ah 'aw chats'uwhes'en.” ");
INSERT INTO cafNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","'Et chah Sizi taba ts'ih lhghanadija. Hulan hoh highu nindel hoh 'et whubodalh'i. ");
INSERT INTO cafNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","'Et Sizi wheghah uyalh hoh Alphaeus buye' Levi, Capernaum hoonkuti huwunli ka sooneya 'ilhunughesdzaih, 'en Sizi yutelh'en, 'et ndi yúlhni, “Sunanyalh.” 'Et Levi dudinya 'ink'ez yuk'ah ts'ih oot'en ka yuntezya. ");
INSERT INTO cafNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hukw'elh'az 'et Levi bukoo lhannah ndunnah sooneya 'ilhughunesdzaih 'ink'ez lubeshi 'ulh'en, Sizi yugha hoodul'eh chah 'et hubula na'ut'alh. ");
INSERT INTO cafNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","'Et Moses be' dustl'us yuk'ununa'úsduguz 'ink'ez Pharisee dédowh, Sizi hinilh'en ndunnah lubeshi 'ulh'en, 'ink'ez sooneya 'ilhughunesdzaih hubula na'ut'alh. Ndunnah Pharisee Sizi yugha hoodul'eh hubuhoodulhkut, “Dáhoont'ah huwa ndunnah hubula 'ah'alh?” ");
INSERT INTO cafNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sizi hubuduzts'ai 'ink'ez ndo búlhni, “Ndan soo 'ínt'ah, 'aw yoo be duyun ka cha'hunízun, ndan nduda, 'en zeh yoo be dúyun ka' huninzun. 'Et whuz na'a zeh si chah dune ts'ah'un 'int'ah na'dunúdzun ba whusáchasyal, lubeshi 'ulh'en lht'anahunoodelh hubudutésnilh 'et wheni whusáya.” ");
INSERT INTO cafNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","'Et John dune too be 'ulh'en yugha hoodul'eh 'ink'ez Pharisee hubugha hoodul'eh chah sahá'hudelya hoh 'uyoon Sizi highu nindel 'ink'ez 'uhiyúlhni, “Et dáhoont'ah huwa John dune too be 'ulh'en yugha hoodul'eh 'ink'ez Pharisee hubugha hoodul'eh chah saha'húdelya 'et whunts'ih nyun ngha hoodul'eh, 'en 'aw sahácha'hudilyel?” ");
INSERT INTO cafNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sizi ndo búlhni, “Aw ih k'an lhghusduke bulh dunekah sahá'hudutelyelh? 'Awundooh! Ndunnah hubughun ts'úzdel, ndun dune bu'at whuzdli, 'et hubutah usda t'eh, 'aw sahácha'hudilyel. ");
INSERT INTO cafNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","'Et whunts'ih whusawhutélts'ulh ndet ndun dune 'at ut'i bughu nayitélchulh. 'Et dzin whusawhélts'ut t'eh, 'et sih saha'hudutelyelh.” ");
INSERT INTO cafNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Aw 'ilhunuh naih k'an, 'i naih jut be lhudunoolhkalh ghaít'ah. 'Et ndúja t'eh, ndi naih k'an, 'i be lhts'etech'ulh, 'et nyoo naih jut lhts'ench'ul 'i bulh hanaitech'ulh 'ink'ez 'o nus hooncha tele. ");
INSERT INTO cafNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","'Et whuz na'a 'aw 'ilhunuh mai too, 'awhuz 'ut'en, 'i 'uzus 'ujut, 'i be híyoolhdzeh huba cha'hóot'ah. 'Et nduhiyínla t'eh ndi mai too zus jut, 'i buk'otéltulh 'ink'ez mai too nadutejulh 'ink'ez buzus bulh tinta' tet'ilh. Mai too 'awhuz 'ut'en, 'i uzus k'an, 'i be yóoldzeh huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","'Et doo chah nahulyis dzin 'uhoont'ah hoh, Sizi 'ink'ez yugha hoodul'eh tubulh tl'o k'ut wheghah hidulh hoh, tl'o mai hoonuye. ");
INSERT INTO cafNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","'Et Pharisee Sizi 'uhiyúlhni, “Nilh'en dáhoont'ah huwa ngha hoodul'eh nats'ulyis dzin 'et 'uhut'en? 'Aw 'et nduhóot'en huba cha'hoot'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sizi ndo búlhni, “Aw ih hukw'e yachalhtih David dája hoh da, yoo'alh, 'i hoolah, yulh 'úhut'en teh buye'élts'ul 'et 'uja, ");
INSERT INTO cafNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yak'usda bukoo 'et danínya 'ink'ez ndi lhes Yak'usda bugha iní'ai, 'i yu'alh 'ink'ez yulh 'uhut'en, 'en chah hiya'al. Nawhulnuk 'aw 'en zeh hiyoo'alh huba' hoont'ah, 'et whunts'ih David 'ink'ez yulh 'uhut'en chah nduhuja. Hoh da Abiathar 'en nawhulnuk bumoodih unli ho' hooja.” ");
INSERT INTO cafNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","'Et Sizi ndo búlhni, “Nahulyis dzin dune huba whulhtsi, 'ink'ez dune, 'en 'aw nahulyis dzin huba cha'hílnel. ");
INSERT INTO cafNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","'Et huwa yinkak dune ye', nahulyis dzin 'et whunts'ih nts'e na'a ne'hutet'ilh hukwa' huninzun huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","'Et Sizi Lizwif hubuluglez ts'ih danínya. 'Ilhunuh dune bula 'aw ye nucha'ust'en, 'et usda. ");
INSERT INTO cafNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","'Et Pharisee tube Sizi highunli nahulyis dzin tulih ndun dune ka hoonli nayoolhyih, hukwa hik'ého'alh, 'et hukwa highunli. ");
INSERT INTO cafNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sizi ndun dune bula ka hoonli 'en 'uyúlhni, “Didinyih 'ink'ez 'udez inyalh!” ");
INSERT INTO cafNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","'Et Sizi huboodulhkut, “Neghá whunt'ai ih nats'ulyis dzin, hubula 'uts'utenilh k'us 'uts'uduntélhda, uztelhyih k'us hoolah ts'utelhtsilh?” 'Aw dája chahudinil. ");
INSERT INTO cafNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sizi tube hunílch'e hoh hubutunuyú'en tube budzi ndesda, ndunnah stabe hubudzi duts'un. 'Et ndun dune ka hoonli yulhni, “Lhk'utdughelnih!” Ndun dune 'en lhk'udughellhúnik ibulh 'ilhk'us ts'ih k'una'a soo ná'uja. ");
INSERT INTO cafNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","'Et 'ahoh Pharisee nyo luglez tínahundel 'ink'ez Herod dédowh bulh highu yalhtuk nts'e na'a Sizi hituzelhghelh 'et wheni lhahóduleh. ");
INSERT INTO cafNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","'Et chah Sizi yugha hoodul'eh tubulh Galilee bun ts'ih lhgha hudindel. Galilee keyah whut'en whuz lhgha hidunindel 'ink'ez lhelhyoo keyah ts'ih huhandel tubulh. Judea ts'ih hahandel chah, ");
INSERT INTO cafNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem whut'en, Idumea ts'ih hahándel, Jordan took'oh wheghah whut'en, 'ink'ez ndunnah Tyre 'ink'ez Sidon whut'en, 'en chah, ts'iyawh Sizi higha 'ilhuhowezdel lhat tune'út'en hiyulh 'udánts'o 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Lhanah 'ilhuhowezdel Sizi lhube' hintelhjulh 'et whuch'a yugha hoodul'eh, “Ts'iyaz suba lhadáhleh,” hubulhni. ");
INSERT INTO cafNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Lhanah hunduda soo na'ubinla 'ink'ez 'uyoon hit'aóonalh hukwa' hut'en, ");
INSERT INTO cafNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","'ink'ez ndunnah ntsi' nudúdeh, 'i hubuyudínda, Sizi hitulh'ih teh, hibut nachánuldulh, 'ink'ez hahúzulh hoh 'uhutni, “Nyun Yak'usda buYe' inli ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","'Et Sizi khunekti be ndunnah ntsi' nudúdeh, 'en ndo búlhni, “Khun ndan 'ust'ah doohtni gunih!” ");
INSERT INTO cafNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Dzulhyaz k'ut nduk whenya hoh ndunnah hubuka' ninzun 'en hubuka' dani 'ink'ez hits'uh whendel. ");
INSERT INTO cafNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Lanezi 'o 'at nanah, 'en 'utaháoobanla. 'Et ndo búlhni, “Sulh 'óoht'e ka 'utahanhóla, dune bulh yátelhtuk ka nuhwutélh'alh, ");
INSERT INTO cafNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","'ink'ez ntsi' nudúdeh, 'i dune buyuh hanainóohyukw 'ink'ez dune soo na'boolh'en, 'et nuhwhutl'ahó'ai.” ");
INSERT INTO cafNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ndunnah lanezi 'o 'at nanah, 'en 'utaháoobanla Simon, 'en Sizi “Peter” naidútni. ");
INSERT INTO cafNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James 'ink'ez bulhutsin John, Zebedee buye'kah 'en Sizi Boanerges nabudátni, ndi boozi, 'i “Huhuske” ni ho 'utni; ");
INSERT INTO cafNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James Alphaeus buye', Thaddaeus, Simon 'en ts'ah'un 'ut'udil'i, ");
INSERT INTO cafNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","'ink'ez Judas Iscariot chah 'en Sizi be ná'oodutekulh. ");
INSERT INTO cafNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","'Et doo chah zeh 'ilhohuwezdel hulai k'et Sizi 'ink'ez yugha hoodul'eh bulh 'uhute'alh, 'et whunts'ih 'aw 'uhooneh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lhanah dune 'uhutni, “Beni hoolel” hutni 'ink'ez bulhutsinkah hiyulh údants'o hoh hika natesdel budeni 'et tinta' 'oot'en whuch'a. ");
INSERT INTO cafNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moses be' dustl'us 'uk'ununa'úsduguz, Jerusalem ts'ih huhandel, 'en 'uhutni, “Beelzebul buyudínda 'ink'ez ntsi' nududeh bumoodih 'en ye úlhtus yugha óoni'ai, 'et huwa ntsi' nududeh, 'i dune buts'u hanaoobuneyukw.” ");
INSERT INTO cafNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","'Et Sizi, “Anih,” hubúlhni, 'ink'ez hubulh náwhulnuk higha hodool'eh ka, “Nts'e na'a Satan dich'oh na'dudúntejulh? ");
INSERT INTO cafNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Keyah whut'en lhch'az nihúdendel t'eh, 'et keyah hoolah whutéle, ");
INSERT INTO cafNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","k'us 'ilhunuh bukoo whut'en lhch'az nihúdendel t'eh, 'et bukoo whut'en hoolah whutéle. ");
INSERT INTO cafNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","'Et Satan dich'oh dulh duch'a nenadenja 'ink'ez lhch'a nihúdendel t'eh, 'aw sa 'uhoot'e ghaít'ah 'ink'ez hoolah whutele. ");
INSERT INTO cafNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Aw 'ilhunuh dune whunts'ih njan dune ulhtus bukoo 'et datdutooyis 'ink'ez te'oolelh ghait'ah, 'et ndunah dune ulhtus 'en yulghel choo, 'et sih yughu te'oolelh. ");
INSERT INTO cafNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Soo ts'ah'un nuhwhudúsni, ts'iyannah dune bulubeshi 'ink'ez Yak'usda ch'a yátuk chah, ts'iyawh hububa n'ún whuteldulh. ");
INSERT INTO cafNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","'Et whunts'ih ndan Ndoni ch'a yáhalhtuk, 'en 'aw bulubeshi buba n'un yutoolhdelh ghaít'ah, 'ilhuz wheni huba nahutedeh.” ");
INSERT INTO cafNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sizi hubudani, 'et huwa ndunnah Moses be' dustl'us 'uk'ununa'úsduguz 'uhútni, “Ntsi' nudúdeh, 'i buyudínda!” ");
INSERT INTO cafNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","'Et Sizi bu'ama 'ink'ez bulhutsinkah teh whusahándel koo yoo 'az ts'ih, 'et nahudelhúya hoh koo whez ts'ih khunek hits'o tl'adá'ai. ");
INSERT INTO cafNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dune 'ilhuhowezdel Sizi hinat delhts'i 'ink'ez 'et 'uhiyúlhni, “Nilh'en nyu'ama 'ink'ez nyulhutsinkah ye'at 'az 'uhint'ah 'ink'ez nka' hoodulhkut.” ");
INSERT INTO cafNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","'Et Sizi ndo búlhni, “Ndan su'ama k'us ndunnah sulhutsinkah?” ");
INSERT INTO cafNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ts'iyawh hudelhts'i hubutunúyuz'en 'ink'ez 'utni, “Whunulh'en njan ndunnah, 'en su'ama 'ink'ez sulhutsinkah chah 'uhint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ndunnah Yak'usda k'úne' 'ut'en unli, 'en sulhutsin, sulhtus, 'ink'ez su'ama 'uhint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","'Et bun k'ut Galilee huwhútni, 'et doo chah 'ilhuhowezdel Sizi higha wezdel 'ink'ez hubodulh'eh. 'Ilhuhowezdel hulai k'et ts'iyaz bet natl'adeda. 'Et 'o nus lih dudekelh 'et whuts'un 'ilhuhowezdel taba nahudelhúya hubodulh'eh. ");
INSERT INTO cafNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Lhat hukw'e hubulh nawhulnuk huwa ha hodool'eh 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Soo suzelhts'ai, 'ilhunuh ha'nule, há'untelelh ts'ih whenya. ");
INSERT INTO cafNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","'Et ha'nule hoh bulah ti nanánkat. 'I dut'aiyaz whusahándel 'ink'ez ts'iyawh hineldel. ");
INSERT INTO cafNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","'Et bulah tse tah nanánkat, 'ankw'us yunyaz hoolah, 'et huwa 'ahoh hanusduki. ");
INSERT INTO cafNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bughih hoolah 'et huwa hasain'ai hoh ts'iyawh yanúdezgi 'ink'ez hoolah suli. ");
INSERT INTO cafNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","'Et bulah chah whus cho tanínkat. 'I chah whus cho whutah bulh hananyi bulh lhéwhuntlah 'ink'ez 'aw hachániyel. ");
INSERT INTO cafNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","'Et 'onghah, 'i yun unzoo, 'i k'ut nanánkat hoh soo hananyi 'ink'ez bumai bulah tat lanezi (30) bumai suli, bulah lhk'utat lanezi (60) bumai suli, 'ink'ez bulah lanezi lanezi (100) bumai suli.” ");
INSERT INTO cafNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","'Et Sizi ndo búlhni, “Ndan budzo hooni, 'en huyoozólhts'a huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","'Et Sizi dich'oh 'int'ah hoh bulunah hiyoozálhts'ai whel'a bulh Sizi higha wézdel 'ink'ez 'uhiyúlhni, “Dája dani, 'et neba hukw'u nuhílhye.” ");
INSERT INTO cafNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sizi ndo búlhni, “Nts'e na'a 'utenilh Yak'usda budune hik'úne' 'ut'en, k'an whuts'un dune ch'a nonú'i. 'Et k'an ts'iyawh nuhwhuba hahónla t'eoonoohzeh ka, 'et whunts'ih 'uyoon dune, 'en higha hódool'eh k'una'a zeh hubulh yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","'Et huwa: ‘Honilh'en 'et whunts'ih 'aw chahuwhés'en wule. 'Uhoozélhts'ai 'et whunts'ih 'aw t'echahonoosze. 'Et bubeni taóodelts'ut 'ink'ez Yak'usda ts'un nahulhú'a t'eh, 'et bulubeshi buba 'ún yutelhdulh.” ");
INSERT INTO cafNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","'Et Sizi ndo búlhni, “Ndi bugha hodulhú'eh, 'aw ts'ah'un nichawhah'al t'eh, 'ink'ez 'uyoo bugha hoodelhú'i t'eh, 'et nts'e na'a simba 'oohneh ts'ah'un neooteh'alh?” ");
INSERT INTO cafNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","'Et Sizi ndo búlhni, “Ha'nule 'en Yak'usda bughunek 'aínule. ");
INSERT INTO cafNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Buluh Yak'usda bughunek ti nanúkat, 'i hidits'o teh, 'et 'ahoh Satan khunek budzi bughu yílhchokw. ");
INSERT INTO cafNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ndi ndai da tse tah 'anelya, ndunnah 'i k'una'a zeh 'uhint'ah. Ndi Yak'usda bughunek hidits'o 'ink'ez soo 'ahoh huhóont'i hoh huyilhchuk. ");
INSERT INTO cafNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","'Et whunts'ih dich'oh 'aw bughih hoolah li'hint'ah. 'Et huwa 'astl'iyaz zeh buba 'alha' hoont'ah. 'Ink'ez ndi khunek 'i bugha dzuh nuhudeh 'ink'ez 'onghunnah buch'a hudetni. 'Et huwa 'ahoh ndi khunek hiladutnih. ");
INSERT INTO cafNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ndai whus tah 'anankat, ndunnah 'i k'una'a zeh 'uhint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","'En khunek hidits'o, 'et whunts'ih ndi yun k'ut huwu ni udli, ndi yun k'ut soo uzde'a 'uhoont'ah, 'ink'ez ndai ndi yun k'ut huhóont'i tune' hut'en, 'et 'i ts'iyawh whus cho 'i be bulh lhewhullhuk. 'Et huwa 'aw lhadoolneh wule ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","'Et bulunah yun unzoo, 'i k'ut nanánkat 'i li'hint'ah. Yak'usda bughunek hidits'o, hiyílhchukw, 'ink'ez budzi yuh nihíyu'aih, 'et bumai whulhlhih. Bulunah tat lanezi (30), bulunah lhk'utat lanezi (60), 'ink'ez bulunah chah lanezi lanezi (100).” ");
INSERT INTO cafNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","'O 'un Sizi ndo búlhni, “Too dezk'un dune dainí'ai 'ink'ez k'its'ai tulih yeyuh niyúte'alh, k'us kw'usuti t'ah tulih niyúte'alh? 'Awundooh! Hukw'usu'ai ba'hoont'ah, 'et hukw'eíte'alh. ");
INSERT INTO cafNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","'Et huwa ndai whu'iz 'int'ah, 'i ts'iyawh ts'et haóotekulh.” ");
INSERT INTO cafNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","'Et Sizi ndo búlhni, “Ndan hubudzo hooni, 'en hiyoozólhts'a huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","'Et chah ndo búlhni, “Huwahli 'ink'ez soo cho soo zélhts'ai t'eh, soo bugha hóodolhu'eh whuz na'a Yak'usda 'o 'un chah sih nuhla 'ooneh. ");
INSERT INTO cafNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ndunnah sughunek soo cho hiyoozélhts'ai, 'en 'o 'un chah hiyootuzélhts'ilh 'ink'ez higha hódutel'eh. 'Et bugha óotet'alh 'ink'ez ndunnah chahiyootuzélhts'ilh, 'en sughunek hidánts'o 'et whunts'ih hinaoodutelnah.” ");
INSERT INTO cafNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","'Et Sizi 'utni, “Nuhwhubulh naóotelhúnuk Yak'usda buk'úne' whut'en, 'et hubugha dune lí'ut'en 'a'nulye, 'i 'ainúle whuz na'a 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","'Et hukw'elh'az 'ulh'ek usti 'ink'ez dzenis 'et n'awh ne'út'en, 'et nduhoolyez hoh 'ainanla, 'i buk'unónultalh 'ink'ez haníyeh 'et whunts'ih 'aw t'eoonízun dat'en hoh hanúlhyih. ");
INSERT INTO cafNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","'Et yun 'i bugha hanúlhyih 'ink'ez bumai whulhlhih. 'Udechoo yun yuh hanúduki, 'et nuyeh 'ink'ez dinyez 'ulhih teh bumai whulhlhih. ");
INSERT INTO cafNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","'Et bumai nut'ih teh, 'et dune tl'o be dut'as 'i be yut'us 'aw 'et há' nukat newhúninzut 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","'Et Sizi 'utni, “Daja uzdutenilh Yak'usda buk'úne' whut'en, 'et hukw'u nuts'úhulhye hígha hódool'eh 'i buk'únats'otelnuk? ");
INSERT INTO cafNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Degha nus 'anulye, 'i nintsool, 'i mustard hiyúlhni. 'I dune yilhchuk 'ink'ez yun 'ainulih. ");
INSERT INTO cafNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","'Et hanúlhyih teh, 'ink'ez soo k'enulhyi, 'i ts'iyawh 'ut'an hanúlhyih degha nus 'udelcho 'ulhih. 'Et huwa buzooschum dincha hoh lhts'enunúlhye, 'et dut'aiyaz yutah 'ut'o nilih.” ");
INSERT INTO cafNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Lhat higha hódool'eh ka hubulh yálhtuk dáhoolcho 'i be t'ehontezeh, 'et zeh hukw'u hubulh náwhulnuk. ");
INSERT INTO cafNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Higha hódool'eh, 'i be zeh hubulh yálhtuk, 'et whunts'ih dich'oh 'úhint'ah teh, yugha hoodul'eh, 'en soo cho huba hukw'ú nuhúlhye. ");
INSERT INTO cafNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","'Et hulhgha Sizi yugha hoodul'eh, 'en ndó bulhni, “Nyan tadatus ts'ih uztóoke.” ");
INSERT INTO cafNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","'Et 'ilhohuwezdel buch'a nahusdel, yugha hoodul'eh ts'i be hándel, Sizi 'uda ye usda, 'i be nyan hutezki, 'uyoo ts'iyaz chah hubulh tezkat. ");
INSERT INTO cafNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Khunyaz nilhts'i ulhtus tezts'i hoh tatsi dincha k'et ts'i be tadutih 'ink'ez 'ankw'us too be whendunimbun. ");
INSERT INTO cafNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","'Et Sizi ts'i niz ts'ih 'et tsi'alh k'ut tsilhu'al 'ink'ez nanésti. 'Et yugha hoodul'eh ts'ih nahinílhdzut 'ink'ez 'uhiyúlhni, “Nehodulh'eh, 'aw 'et yats'utedlah! 'Aw ih neghu ni chaínlah?” ");
INSERT INTO cafNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sizi didinya hoh too k'ut nilhtsi khunek ulhtus, 'i be hukwa' yudáni, “Nilhts'i, 'ustl'e' 'ineh,” 'ink'ez, “Tatsi nughuzina,” 'ink'ez 'Aw 'et dónghel. ");
INSERT INTO cafNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","'Et Sizi yugha hoodul'eh ndo búlhni, “Dahoont'ah huwa stabe whenlhujut, 'aw ih bé 'alha' hoont'ah, 'i chaht'ih hoh 'aht'ah?” ");
INSERT INTO cafNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","'Et tube whehunelhújoot 'ink'ez 'ulhódutni, “Dant'ah dune unli ho' 'int'ah? Nilhts'i 'ink'ez tatsi bulh 'i nts'ih yuk'úne' 'ut'en.” ");
INSERT INTO cafNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","'Et bun k'ut nyan nahuninki whuz Gadarene whut'en hubukeyah 'et 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Soo Sizi ts'i bé hainya ibulh 'ilhunuh dune tse bet dune 'adinla whuz de haínya. ");
INSERT INTO cafNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ndun dune tel'en ntsi' nudúdeh, 'i buyudínda 'ink'ez ts'un k'ut 'et whut'i. 'Aw dune tse tl'oolh be whunts'ih whehídoolht'uk ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Lhat hoh bula 'ink'ez buke bulh hiyulhghel 'et whunts'ih hoh totsuk tse tl'oolh k'unuyéyuz 'ink'ez tse tl'oolh buke be lhulhú'oo, 'i chah yayalh'us. Ulhtus k'et 'aw dune hich'a 'oolhdeh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dzin 'ink'ez 'ulh'ek 'i bulh ts'un k'ut whutah 'ink'ez nódest'ai, hoh nuya hoh 'alzul 'ink'ez tse be bubut na'dudut'as. ");
INSERT INTO cafNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Dzuh nilhdza, 'et yughu siyin hoh Sizi yutelh'en. 'Ahoh yuts'u télhgai 'ink'ez dugwutsi be yubut nachánetno, ");
INSERT INTO cafNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","'ink'ez soo 'ultus 'alzul hoh 'utni, “Sizi degha nus Yak'usda buYe' ndet suts'o húkwa' ninzun. Yak'usda 'en be suts'un nahútanyelh dzuh nusílhdzut ilah.” ");
INSERT INTO cafNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","'Et ndutni hoh Sizi ndi yulhni ntsi' nudúdeh, 'i ndun dune buyáh hanaindaih. ");
INSERT INTO cafNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","'Et Sizi yoodulhkut, “Ndai nyoozi?” yúlhni. 'Et 'utni, “Legion, 'i soozi 'int'ah. 'I lhanah nehughan 'uts'int'ah ni hoh 'utni.” ");
INSERT INTO cafNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","'Et ntsi' nudúdeh, 'i Sizi soo yuts'u tédudlih, “Njan keyah whuch'a netolh'a gunih,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dzulh yeghah 'et goso lhai 'et 'ahú'alh. ");
INSERT INTO cafNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","'Et ntsi' nududeh, 'i Sizi ts'un tehududleh ndunnah n'ún goso 'en buts'un neítelh'alh, 'et t'eh buyúzdoodeh. ");
INSERT INTO cafNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","'Et huwa 'ahoh Sizi hubutl'ahó'ai ntsi' nudúdeh, 'i dune yuts'ah hanádede 'ink'ez goso 'i yeyúdande. Goso 'ankw'us 2,000 'int'ah, 'i ts'iyawh wheghálghaz 'ink'ez too yanghan. ");
INSERT INTO cafNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","'Et ndunnah goso ghuhinli whuhélghaz 'ink'ez keyah whutah khunek nihuni'ai. 'Et lhanah whusaíndel dáhooja hontelh'ilh ka. ");
INSERT INTO cafNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","'Et Sizi highu nindel 'ink'ez dune hinilh'en ntsi' nudúdeh, 'i buyudelhts'i inle, 'et hukw'usda beni bugha nádelts'ut 'ink'ez soo dint'ah chah 'int'ah. Huba hooncha k'et tube whéhunelhújoot. ");
INSERT INTO cafNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","'Et ndunnah ho'en, 'en dune hubudáni ndun dune ntsi' nudúdeh, 'i buyudélhts'i inle, dája 'ink'ez goso bugha chah. ");
INSERT INTO cafNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","'Et Sizi highut tedudlih hubukeyah whuch'a naóoja ka. ");
INSERT INTO cafNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","'Et Sizi ts'i be nádaih, 'et ndun dune ndun ntsi' nudúdeh, 'i buyudélhts'i inle, 'en Sizi yuts'u tédudlih, “Nyulh 'óosneh,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","'Et Sizi, “Awundooh,” yúlhni 'ink'ez ndi yúlhni, “Nkoo ts'un naíndalh 'ink'ez nyulh 'uhut'en teh hubudóni dálhcho 'i be nyuMoodihti nts'un budzi únzoo 'ink'ez dálhcho 'i be nla 'uja.” ");
INSERT INTO cafNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","'Et ndun dune whenája 'ink'ez lanezi keyah 'et whutah lhuséya Sizi daíyinla hoh yula 'uja 'et ndo búlhni. 'Et ndan yudants'o ts'iyawh huba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","'Et Sizi nyan tadatus ts'ih whenahedúki 'ink'ez bun k'ut whuzih lhanah dune higha wezdel. ");
INSERT INTO cafNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","'Et Lizwif hubuluglez whumoodih Jairus hiyúlhni, 'en yughu ninya 'et Sizi yutelh'en hoh yubut nacháneti. ");
INSERT INTO cafNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","'Ink'ez tube cho yuts'un tédudlih, “Sustse'yaz 'aw 'et datétsah, sulh naínt'us 'ink'ez buk'edólnih sih soo ná'ootneh 'ink'ez khoona sih.” ");
INSERT INTO cafNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","'Aw 'et Sizi yulh nátest'az. 'Et whuz lhanah dune yulh tezdel k'et lhts'un na'a hiyúlh lhgha dindel. ");
INSERT INTO cafNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","'Ilhunuh ts'eke tube dzuh nuzut, lanezi 'o 'at nat naooduzuk (12) 'et nduhóolhyez hoh 'uskai 'uyulh'en, ");
INSERT INTO cafNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","yoo be dúyun lhanah chah hukwa' hiyalh'en. Duzooneya ts'iyawh hoolah yulhtsi 'et whunts'ih 'aw nus zeh lhe'enilh. ");
INSERT INTO cafNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","'Et Sizi yulh údants'o 'et huwa dune tah Sizi yut'ak ts'ih yugha nínya 'ink'ez bunaih yut'agheznai. ");
INSERT INTO cafNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Dich'oh 'et ndunínzun, “Ants'ih bunaih 'i teh but'aghénai t'eh, 'et sih soo ná'oosneh.” ");
INSERT INTO cafNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","'Et Sizi yunaih 'i yut'agheznai ibulh 'et 'ahoh 'uskai 'iyulh'en 'ustl'e' 'uja 'ink'ez 'ahoh t'éoonanzin dzuh nuzut soo ná'uja. ");
INSERT INTO cafNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","'Et 'ahoh Sizi t'éoonanzin ye úlhtus ye dune la'ut'en, 'i bulah buts'ah haidélts'ut. 'Et 'ilhuhowezdel hubuts'un nalhú'a 'ink'ez 'utni, “Ndan hoh 'uja sunaih yut'agheznai?” ");
INSERT INTO cafNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","'Ink'ez yugha hoodul'eh hiyúlhni, “Dadíni ho' dini? Lhe'uneltsuk 'ilhohuwezdel lhanah hoh nyan do hahúneldo 'ink'ez, ‘Ndan 'uja sunaih yut'agheznai dini?” ");
INSERT INTO cafNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","'Et whunts'ih Sizi ndan 'uja yukiyú'en. ");
INSERT INTO cafNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","'Et ndun ts'eke daja soo ná'uja t'eoonanzin hoh butahaínya whenuljut k'et dulduz 'ink'ez Sizi yubut nacháneti. Khunek 'alha' 'int'ah, 'i be ts'iyawh yulh náwhelnuk. ");
INSERT INTO cafNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sizi ndi yúlhni, “Sutse' be 'alha' hoont'ah, 'i yint'i, 'et huwa soo ná'inja. Ndzi hóont'i hoh natonja 'ink'ez ndai be dzuh ninzut, 'i buch'a soo ná'ontneh.” ");
INSERT INTO cafNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","'Et 'awhuz Sizi naheyelh hoh, khunek na'á Jairus bukoo ts'ih hahándel 'uhiyúlhni, “Ntse'yaz dazsai, ndun dune hoodulh'eh di ka 'o 'un bugha tédindlih?” ");
INSERT INTO cafNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","'Et Sizi whulh 'uduzts'ai ibulh daja hutni ndun luglez whumoodih ndi yúlhni, “Aw whéchanuzíljut hoh mba 'alha' hot'e.” ");
INSERT INTO cafNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","'Aw 'uyoon dune duntoodelh gunih, ndunnah Peter, James, 'ink'ez bulhutsin John chah, 'aw 'en zeh hiyulh tezdel. ");
INSERT INTO cafNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","'Aw 'et Lizwif luglez whumoodih bukoo ts'ih hunindel, 'et Sizi whunilh'en ndulhcho tahudetnik 'ink'ez tso yahalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sizi koo danínya 'ink'ez ndo búlhni, “Di ka sdabe tadéhtnik 'ink'ez ahtso? Ndun 'uski 'aw dáchaitsal, 'ants'ih usti ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","'Aw 'et ts'iyawh highudloh. 'Et ts'iyawh tinaóobunilh'a. 'Uski bu'abá 'ink'ez bu'ama bulh hubílhchoot, yugha hoodul'eh tanah chah 'ink'ez 'uski sulhti ts'un dahunindel. ");
INSERT INTO cafNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","'Et ts'ekeyaz yula ílhchoot 'ink'ez ndi yúlhni, “Talitha koumi,” 'et dakelh k'una'a, “Ts'ekeyaz dinadindaih nyudúsni,” ni hoh 'utni. ");
INSERT INTO cafNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","'Et 'ahoh dinadija 'ink'ez nádinya. Ndun ts'ekeyaz lanezi 'o 'at nat be naoodezulh (12) 'et ndúhooja hoh soo ts'ah'un buba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sizi soo khunek ulhtus, 'i be ndo búlhni, “Et dune ndo budóohtni gunih, 'ink'ez hoonliyaz yute'alh, 'i bugha yóoh'alh.” ");
INSERT INTO cafNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","'Et Sizi 'ut'en inle 'et whuch'a nanja 'ink'ez dukeyah ts'ih whenája. Yugha hoodul'eh chah hiyulh whendel. ");
INSERT INTO cafNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nahulyis dzin 'et Lizwif hubuluglez whubodulh'eh hoh lhanah dune 'et hudelhts'i hidánts'o tube huba hooncha 'ink'ez 'uhútni, “Ndun dune nts'ez de hahónla hoh 'utni? Ndi be ts'uwhunih, 'i be nts'ez de hahónla hoh 'utni? 'Et nts'e na'a 'ut'en sdabe hooncha huwa 'ut'en tuné'ut'en? ");
INSERT INTO cafNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Koo 'uwhulh'en, 'en ilah ih 'int'ah? Mary buye' 'ink'ez bulhutsinkah chah James, Joses, Judas, Simon, 'ink'ez budestl'ahkah chah 'en ts'iyawh njan huwhut'i?” 'Et hits'a desnih. ");
INSERT INTO cafNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","'Et Sizi ndo búlhni, “K'us ndan Yak'usda be nus whúnilh'en yalhtuk teh ndulhcho hoh hidelhti, 'et whunts'ih bukeyah whut'en, bulhtuskah, 'ink'ez bukoo huhuwhut'i chah, 'en zeh chahidílhti.” ");
INSERT INTO cafNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","'Et huwa nyoh 'et Sizi 'aw huwa 'oot'en tune'óot'en ghaít'ah, 'et whunts'ih bulunah nduda, 'en zeh buk'edilnih hoh soo ná'bulh'ih. ");
INSERT INTO cafNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","'Et ndunnah 'aw be 'alha' hoont'ah, 'i chahiyít'ih, 'et Sizi buba hooncha. 'Ink'ez whunat keyah hoh neya 'ink'ez dune hubodulh'eh. ");
INSERT INTO cafNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","'Aw 'et ndunnah lanezi 'o 'at nanah, “Anih,” hubudáni' 'ink'ez nanah hinli hoh lhelhts'un whebalh'a. 'Ink'ez hiye úlhtus, 'i hubugha iní'ai ntsi' nudúdeh, 'i dune yudúlts'i 'i hits'ah hanáhinooyoot ka. ");
INSERT INTO cafNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","'Ink'ez khunek ulhtus, 'i hubutl'aida'ai, “Teh'us ts'ih hoonliyaz teh whutoohla gunih! Teh'alh, 'i chah, ézdlai, 'i chah, k'us sooneya teh bulh sudoolhú'oo gunih! Tuz 'i zeh dutóohtan. ");
INSERT INTO cafNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nuhkesgwut, 'i 'ink'ez dzoozt'an 'ilhuk'i be súhke, 'i zeh be 'óohneh.” ");
INSERT INTO cafNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","'Et 'udun chah ndo búlhni, “Keyah lhghadah'az t'eh dune bukoo danah honilhti t'eh, 'et bukoo 'et wahke 'uts'un keyah ts'ih téh'us whuts'un. ");
INSERT INTO cafNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'Et keyah nenáh'az 'ink'ez dune 'aw hachanwhuhílh'al t'eh, k'us chanuwhuhudústs'uk t'eh huwu nátóoht'as 'ink'ez whulez ch'a nuhke naóohghat. 'Et dahúja t'ehonoozeh. Ts'ah'un nuhwhudúsni Sodom 'ink'ez Gomorrah whut'en sdabe hintsi'. 'Udék'elh'az dzin t'eh hiyé dzuh nutézut, ndunnah keyah whut'en, 'en 'o nus ba dzuh nahutezut ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","'Aw 'et whehándel 'ink'ez dune Yak'usda bughunek be hubulh yahúlhtuk, “Nuhwhulubeshi ch'a lht'ananoohdelh,” hubuhútni. ");
INSERT INTO cafNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lhanah ntsi' nudúdeh, 'i hubugha delhts'i hubugha whenabunanyoot 'ink'ez dune lhanah nduda khe be hubuhulho hoh soo ná'buhalh'en. ");
INSERT INTO cafNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","'Aw 'et hubudayi cho Herod hiyúlhni yulh údants'o Sizi dulhcho hoh búlh khunek bughi denzut. 'Ink'ez 'utni, “John dune too be 'ulh'en 'ut'en. Dazsai inle 'ink'ez nakhítna, 'et huwa Yak'usda ye ulhtus, 'i buyidí'ai hoh 'út'en whunul'en teh ne'út'en.” ");
INSERT INTO cafNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","'Et bulunah chah, “Elijah 'ut'en,” hutni. 'Et 'uyoon chah 'uhutni, “Uda hukw'u na'a Yak'usda be nus whunilh'en 'ut'en,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","'Et hubudayi cho Herod whulh 'údants'o hoh 'et 'utni, “John dune too be 'ulh'en 'ut'en. Butsi suba k'uhinentsel inle da, 'et whunts'ih nakhítna,” ni. ");
INSERT INTO cafNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod dich'oh John dune too be 'ulh'en 'ahiyoo'alh huwá bulh'a ínle. Hiyulhghel 'ink'ez tsak'ehíya'ai. Ndun ts'eke Herodias hiyúlhni, 'en yughusda. 'En gha 'uyínla ínle. Dulhutsin Philip bu'at 'en lhch'a bunenjoot, 'et whunts'ih yughusda. ");
INSERT INTO cafNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","John dune too be 'ulh'en Herod yudani, “Yak'usda bughunek k'uninyuz ho' 'int'ah nyulhutsin bu'at zih silda.” ");
INSERT INTO cafNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","'Et huwa bu'at Herodias, 'en John dune too be 'ulh'en yuts'u dutnik 'ink'ez yuzoolhghelh hukwa' ninzun. 'Et whunts'ih Herod, 'en bugha 'aw yuzoolhghelh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","'Et Herod 'en chah John dune too be 'ulh'en yé nuljut, t'eoonínzun John dune too be 'ulh'en, ts'ah'un dune unli, 'ink'ez Yak'usda budune 'int'ah. 'Et huwa yugha 'óoli. John whulat tune 'út'en, 'et huwa hóont'i hoh yoozélhts'ai. ");
INSERT INTO cafNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","'Et 'ilhudzin Herodias bughá whults'ut Herod whuzdli dzin 'et dune dézti 'ink'ez nehughan moodih chah 'ink'ez Galilee whut'en moodih tubulh, ts'iyawh bughu nuséya. ");
INSERT INTO cafNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias butse' danínya 'ink'ez huba nedak. Herod 'ink'ez hubughu nusja tubulh huba hoonzoo. 'Et hubudayi cho Herod ndun ts'eke ndi yúlhni, “Ndai suts'un buka' dini, 'i ngha tesdlelh,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Lhat yuts'u náhezya hoh ndi yúlhni, “Ndai suts'un buka' dini, 'i ngha tesdlelh, ndai hubudayi cho be usdli, 'i lhulcho 'i whunts'ih ngha tesdlelh,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","'Et ndun ts'ekeyaz 'az whenája 'ink'ez bu'ama 'en yoodalhkut, “Ndai simba buts'u hukwa' doosni?” yúlhni, “John dune too be 'ulh'en butsi,” yúlhni, bu'ama. ");
INSERT INTO cafNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","'Et ts'ekeyaz 'ahoh hubudayi cho yuts'un lhgha nadija 'ink'ez ndi yúlhni, “John dune too be 'ulh'en butsi k'an 'ahoh tsets'ai be sugha ninínkaih,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","'Et hubudayi cho 'ahoh ni suli 'et whunts'ih 'aw yuch'a 'uts'un 'udooni ghaít'ah, bughu nusja 'en hubunalh yuts'u náhezya 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","'Et 'ahoh 'ilhunuh huwuhinli, 'adinla delhts'i ts'ih wheyálh'a, John dune too be 'ulh'en butsi whusaínoo'alh wheni. Huwuhinli 'en 'adinla delhts'i ts'ih whénya 'ink'ez John dune too be 'ulh'en yutsi k'éinentsel. ");
INSERT INTO cafNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tsets'ai bé na'ai 'ink'ez ts'ekeyaz yutl'ayánkai. 'En be'ama yutl'ayankai. ");
INSERT INTO cafNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","'Et John dune too be 'ulh'en yugha hoodul'eh hiyulh 'údants'o, buyust'e hikunasdel 'ink'ez whuyihiyalhti. ");
INSERT INTO cafNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","'Aw 'et ndunnah whel'a whusanáhedel 'ink'ez Sizi ts'un 'ilhuhowezdel 'et 'uhidáni nts'oh tuné'hust'en 'ink'ez ndet dune whéoobuhodalh'i. ");
INSERT INTO cafNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lhanah dune whusahúdulh 'ink'ez whenáhudelh, 'et huwa Sizi 'ink'ez yugha hoodul'eh tubulh 'uhúte'alh 'et whunts'ih búgha chawhulhts'it, 'et ndo búlhni, “Uts'un uztoodelh nts'e whenich'oh úztet'ilh, 'et 'astl'iyaz naoolhuyis.” ");
INSERT INTO cafNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","'Aw 'et nus ts'i be hutezki, dune hoolah ts'ih whuz nehúninki. ");
INSERT INTO cafNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","'Et whunts'ih lhanah dune huba'en hutezki hoh 'ink'ez 'ahoh t'ehonínzun ndun 'int'ah, 'et huwa keyah totsuk whut'en lhanah helwus. Sizi 'ink'ez yugha hoodul'eh tubulh butsuh 'et whuz lhgha hadílghaz. ");
INSERT INTO cafNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","'Et Sizi ts'i be hainya lhanah 'ilhuhowezdel 'et hubunilh'en, tube hubugha té'nanzin 'ants'ih sheepyaz bughu chaídlah lí'hint'ah. 'Et lhat 'et whubuwhéoodunilh'i. ");
INSERT INTO cafNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","'Aw 'et ye 'ún whezulh hoh yugha hoodul'eh highu nindel 'ink'ez 'uhiyúlhni, “Aw 'et tube ye 'ún whezulh 'ink'ez njan dune hoolah chah 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ndunnah dune ts'iyawh n'awh keyah ts'ih nabalh'alh 'ink'ez 'i ts'uyi, 'i náhiyoododuket hiyoo'alh wheni, ndunnah 'aw hiyoo'alh hoolah 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","'Et Sizi ndo búlhni, “Nuhwhenich'oh hite'ulh, 'i hubugha ínah'ai daja.” 'Et hiyoodulhkut, “Whuz uztedulh hukwa' ninzun 'ink'ez $200.00 k'ah ts'uyi, 'i ts'onket 'ink'ez ih hubugha ízte'alh?” ");
INSERT INTO cafNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","'Et whunts'ih Sizi huboodulhkut, “Lhes dáltsuk aht'i 'et whunulh'en.” 'Et nahuhoon'ai hoh 'et 'uhiyúlhni, “Skwunlai lhes 'ink'ez nankoh lhook chah.” ");
INSERT INTO cafNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sizi 'et yugha hoodul'eh ndo búlhni, “Ts'iyawh dune lhelhdun nibunahle 'ink'ez tl'oyaz k'ut hudóolts'i.” ");
INSERT INTO cafNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","'Aw 'et dune nátl'ahudelts'i tl'oyaz k'ut lanezi lanezi (100) 'ink'ez skwunlai lanezi (50) hoh lhanoowh teh lhuhusdúguz. ");
INSERT INTO cafNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","'Aw 'et Sizi nyoo lhes 'ink'ez lhook bulh yílhchoot, ndoh yak'uz ts'ih yuta'en 'ink'ez, “Suchanailya,” ni hoh tenadedli. 'Et lhes taidalhkut hoh yugha hoodul'eh hubutunyoole ka butl'ayánla. 'Et nankoh lhook chah 'et ndúyinla hoh butainínla. ");
INSERT INTO cafNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ts'iyawh 'uha'al 'ink'ez 'uhunesdai. ");
INSERT INTO cafNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","'Et yugha hoodul'eh lanezi 'o 'at nankoh (12) k'its'ai dezbun, 'i lhook 'ink'ez lhes bulh 'et ninínkat, 'i 'ilhunahíghezdla. ");
INSERT INTO cafNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","5,000 dune, 'en ndi lhes hiya'al. ");
INSERT INTO cafNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","'Ahoh Sizi yugha hoodul'eh ts'i be naóobalh'a 'ink'ez Bethsaida huwhútni keyah whuz dutsuh whebalh'a nyan tadatus ts'ih whuz'ai. 'Et didut ndunnah 'ilhuhowezdel whenaóobalh'a. ");
INSERT INTO cafNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","'Et whenáhedel hoh tenadutedli ka 'aw 'et buch'a násja 'ink'ez dzulh k'uz ts'ih whénya. ");
INSERT INTO cafNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","'Aw 'et húlhgha suli 'et nyoo ts'i be k'an zeh taniz hekelh 'ink'ez Sizi 'en dich'oh 'awhuz nyoh yun k'ut 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yugha hoodul'eh hubunilh'en nilhts'i 'i yenah hekelh, tube hunint'uk, 'aw 'uhoot'o chah ghaít'ah. 'Et bundada haootelh'en, 'et Sizi too k'ut uyalh hoh nus whuz hubughu ninya hube ghootéyalh inle. ");
INSERT INTO cafNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","'Et whunts'i hitelh'en too k'ut uyalh hoh, “Dune tsen 'ut'en,” huninzun. Tube whéhunelhújoot 'ink'ez 'uhúldzul. ");
INSERT INTO cafNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","'Et Sizi 'ahoh ndo búlhni, “Nuhdzi ulhtus úlhtsi! Si 'ust'en. Whenulhújut ílah.” ");
INSERT INTO cafNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'Et ts'i bet hubughu dénya. 'Aw 'et nilhts'i chah 'ilhuz ninints'i, 'ink'ez yugha hoodul'eh tube buba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Whutsuh whudelhdzulh lhes dáyinla 'et 'aw ts'ah'un nechahohoo'al, 'et huwa njan lhes bugha dahóoja hubeni taóodoolts'it ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","'Aw 'et nyan bun k'ut yahúninki 'ink'ez keyah Gennesaret huwhútni, 'et ts'i whehídinguz. ");
INSERT INTO cafNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ts'i bez hahándel 'aw 'et Sizi 'en nahuyoolhúts'it. ");
INSERT INTO cafNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","'Et huwa ndulhcho nahulhúghaz 'ink'ez nts'oh Sizi usda hiyulh 'údits'o hoh, nduda hik'usútez 'i be hits'ú butule. ");
INSERT INTO cafNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","'Ink'ez nts'oh Sizi nuya keyah whuyaz k'us keyah whuti k'us khunai nuyéh 'e'óoket whutah dune 'ilhodulh whuz nduda nébuhunle 'ink'ez Sizi híghu tédudlih, “Nyunaih 'ants'ih buk'abah 'et hunduda 'en hit'aóonalh,” hiyúlhni. 'Et ndunnah yut'agheznai, ts'iyawh soo ná'huja. ");
INSERT INTO cafNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","'Aw 'et Pharisee 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz tubulh Jerusalem ts'ih huhándel 'en Sizi higha wézdel. ");
INSERT INTO cafNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","'Et hubunílh'en bulunah Sizi yugha hoodul'eh dula tsun bulh 'uha'alh. 'Uda Pharisee, 'en 'et, “Me” huwhútni inle 'et buts'ú hahuhó'ai. ");
INSERT INTO cafNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pharisee 'ink'ez 'o 'awh Lizwif ts'iyawh butsuh whudelhdzulh whebuhodalh'i whuz na'a 'uhint'ah soo ts'ah'un na'a dula toonáhugus k'ez 'uhá'alh. ");
INSERT INTO cafNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","'Ooket bukoo ts'ih hanahudulh teh la'huldoh 'et k'an zeh 'uha'alh. Lhat huba hoosdzi teh né'hut'en, dulubot, hube 'oosa', 'ink'ez 'uyoo hiyé ne'ut'en, 'i chah, hubukw'usti chah, soo buba' hoont'ah k'una'a zeh toonahíyugus. ");
INSERT INTO cafNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","'Et huwa Pharisee 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz Sizi hiyoodulhkut, “Et dáhoont'ah huwa ngha hoodul'eh netsuh whudelhdzulh whuneoodalh'i k'una'a cha'hust'en 'ink'ez hubula toonáchahusgus hoh 'uha'alh?” ");
INSERT INTO cafNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","'Et Sizi ndo búlhni, “Nuhwheni duba nahdzoo! 'Alha zeh Isaiah nuhwhugha nus whunilh'en 'uk'e'ánguz inle hoh njan ndutni, ‘Ndunnah bughunek be suba hodelhti, 'et whunts'ih 'aw budzi yuh hoh buba 'alha' cha'úst'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Suts'un téni hunilhdzun doo ka 'uhutni, ndi yun k'ut dune nihini'ai, 'i Yak'usda bughunek hiyílh'i hoh dune whubuhodulh'eh.” ");
INSERT INTO cafNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","'Et Sizi 'utni, “Yak'usda bughunek nuhtl'aída'ai, 'i 'aw chaooozulhts'ai 'ink'ez yinkak dune whubuhodalh'i, 'i zeh buk'úne 'uht'en, tsets'ai, lubot, 'ink'ez 'uyoo hiyé ne'ut'en, 'i tóonahgus hoh ndúhoont'ah, 'et zeh dune whubodulh'eh.” ");
INSERT INTO cafNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","'Et 'o 'un chah Sizi 'utni, “Tube 'uyoo ahli! Yak'usda bughunek nuhtl'aída'ai 'i buladehtnik, 'ink'ez nuhwhenich'oh be dune hoodulh'eh, 'i zeh nuht'uk hoh whubodulh'eh. ");
INSERT INTO cafNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","'Et Moses be' dustl'us 'uk'une'uzguz, 'i njan ndutni, ‘Nye'abá 'ink'ez nye'ama bulh hubudólhti,’ 'ink'ez ‘Ndan bu'ama k'us bu'abá dzuh ts'ih bughu yatelhtuk, 'en daóotsah huba' hoont'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","'Et whunts'ih ndan be'ama 'ink'ez be'abá chah ye yula tet'ilh, 'i dune yit'i t'eh 'ink'ez 'i ‘Corban 'uhoont'ah’ ní t'eh, (ndi ‘Corban’ Lizwif bughunek 'et dakelh k'una'a ‘Yak'usda be'ílhdzun’ ni hoh 'utni), ");
INSERT INTO cafNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","'et hoh 'aw be'ama 'ink'ez be'abá bulh hubula 'oot'en whuch'a hobodelh'i ho' dahni. ");
INSERT INTO cafNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","'Et njan huwa Yak'usda bughunek 'aw chaoozúlhts'ai 'ink'ez buk'únucha'zaht'en. Whuz na'a dune whúbunulhtun lhat hoh 'udun chah nuhwhenich'oh nuhk'una'a hoh, whuz na'a wheoobunulhtun.” ");
INSERT INTO cafNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","'Et 'ilhuhowezdel Sizi doo chah, “Anih! Soo zélhts'ai ts'iyannah 'ink'ez nuwheni taoodóolts'it,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","“Ndai dune hiyilhchuk, 'i 'aw bugha lubeshi ólhchoot ghaít'ah, 'et whunts'ih ndai dune buts'u haídults'it, 'i bugha lubeshi hilhchokw. ");
INSERT INTO cafNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ndan hubudzo hooni, 'en hiyoozólhts'a huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","'Ilhuhowezdel 'et hubutahanája 'ink'ez koo danánja hoh yugha hoodul'eh ndi higha hódul'eh yé yaílhtuk, 'et hukwa hiyoodulhkut. ");
INSERT INTO cafNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","'Et ndo búlhni, “Nuhwheni chah ih nuhwheni hoolah? 'Aw nuwheni taóodulhts'it hoh ndai dune yu'alh, 'i bugha lubeshi wulhchoot ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","'Aw budzi be chayuskat, bubut zeh be yúkat 'ink'ez buyust'e ts'ih hanaidukat, 'et whuz na'a untsi', 'i neyust'e ts'uh hanádukat.” ");
INSERT INTO cafNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","'Ink'ez ndo búlhni, “Ndai dune budzi yuh whuts'ahaidults'it, 'i bugha lubeshi ts'ilhchokw. ");
INSERT INTO cafNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","'Et dune budzi yuh ts'ih whuz de 'ut'en untsi' buts'uhaídukat, 'et huwa 'uyoon dune bu'at bulh lubeshi hilhchokw, dune ts'eke bulh tinta' 'ut'ih, nehughan chah, ");
INSERT INTO cafNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","'uhundunut'ih chah, 'uyoon be'ilhdzun ka' huninzun, hoontsi' k'una'a túne' hut'en, dune nahuna'ah chah 'uhut'en, yooyá chailah, 'uhoolnih chah, Yak'usda ch'a yahalhtuk, 'uhudelhúti, 'ink'ez yílah tune' hut'en. ");
INSERT INTO cafNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","'I ts'iyawh ndi dune budzi yuh ts'ih hadúlts'it, 'i bugha lubeshi hilhchokw.” ");
INSERT INTO cafNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","'Et Sizi whenája hoh Tyre 'ink'ez Sidon huwhútni keyah 'et whunat whuz lhghu nadija. 'Et 'ilhunuh koo danínya 'ink'ez 'et usda 'uyoon t'ehonózin hukwa cha'nízun, 'et whunts'ih 'aw buch'a ntool'ih ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","'Ilhunuh ts'eke buyats'e ntsi' nudúdeh, 'i buyidínda, Sizi yulh údits'o hoh yughu ninya 'ink'ez yubut nachánetno. ");
INSERT INTO cafNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ndun ts'eke nts'iz de haínya 'ink'ez 'en Greek buk'una'a yalhtuk 'ink'ez Phonecia, Syria whuz'ai, 'et whuzdli 'int'ah. 'En Sizi yughu tédudlih hoh ndi yúlhni, “Ntsi' nudúdeh, 'i suyats'e buts'u hanaínonyoot.” ");
INSERT INTO cafNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","'Et whunts'ih Sizi ts'eke ndi yúlhni, “Uskeh, 'en choo hububé' ts'oolh'alh. 'Aw ts'ah'un cha'hóot'ah 'uskeh hiya'alh, 'i ts'ílhchoot 'ink'ez lhiyazkah hubugha ts'iyoo'alh ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","'Et ts'eke 'uyúlhni, “Moodihti, 'alha' dini, 'et whunts'ih whulutah teh lhiyazkah 'en whunts'ih kw'uzdai t'ah yun nakat, 'i 'uskeh yugha' wéz'al, 'i hiya'alh.” ");
INSERT INTO cafNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","'Et Sizi ndi yulhni, “Et ndedénja 'et huwa nkoo ts'ih naíndalh, ntsi' nudúdeh, 'i nyats'e buyuh hánaidede.” ");
INSERT INTO cafNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","'Et koo ts'ih whenája 'ink'ez buyats'e kw'usuti k'ut usti ntsi' nudúdeh, 'i buyah hanaidede. ");
INSERT INTO cafNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Doo cha zeh Sizi 'en Tyre 'ink'ez Sidon keyah hoh wheghah lhuséya, 'Et Decapolis keyah whutah lhuséya 'ink'ez Galilee Bun k'ut whuz ninya. ");
INSERT INTO cafNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","'Ilhunuh dune cha'dústs'uk 'ink'ez yachalhtuk cha' 'int'ah, 'en Sizi highu nihinílhya 'ink'ez Sizi highu tédudlih yuk'édoolnih ka. ");
INSERT INTO cafNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","'Et Sizi bughah 'udunyaz nínilhya hoh yudze 'alhge, 'ink'ez 'ún whenzo, 'ink'ez dune yutsoola yut'agheznai. ");
INSERT INTO cafNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sizi nduk yak'uz ts'ih yutá'en, telhayiz 'ink'ez dune 'uyúlhni, “Ephphatha!” Ndi Lizwif bughunek 'et “Mba dá' dutoolts'it,” ni hoh 'utni. ");
INSERT INTO cafNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","'Et 'ahoh dune 'udits'o nasdli 'ink'ez soo yálhtuk chah nasdli. ");
INSERT INTO cafNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","'Et ndo búlhni, “Khun teh dune dóohtni gunih!” 'Aw 'et, “Dah” ndo búlhni, 'et whunts'ih 'o nus huwu yahulhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","'Ink'ez ndan hubodits'o ts'iyawh huba hooncha, “Sóo 'usdla ts'iyantsuk né'whul'en, cha'hudústs'uk 'uhudits'o 'ink'ez yachahúlhtuk chah yahulhtuk hubulhtsi,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","'Aw sa ilah hukw'elh'az doo chah zeh dune lhanah 'ilhuhowezdel 'aw 'et 'uhute'alh, 'i hoolah suli hoh Sizi yugha hoodul'eh, “Anih,” hubudáni 'ink'ez ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ndunnah dune hubugha te'nuszun. 'Aw 'et tat dzin sulh 'úhet'en 'ink'ez hiyoo'alh, 'i hoolah. ");
INSERT INTO cafNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","'Et nduhínt'ah bukoo ts'ih whenábalh'a t'eh nahedulh hoh bukaootoodeh. Bulunah tube nilhdza ts'ih hahándel 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","'Et yugha hoodul'eh hiyoodulhkut, “Ndoh dune chahóot'ih, nts'e simba hite'alh, 'i nats'óolelh lhe'huneltsuk dune gházte'alh wheni?” ");
INSERT INTO cafNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","'Et Sizi huboodulhkut, “Daneltsuk lhes sut'e aht'i?” 'Et ndi híyulhni, “Skwunlai 'o 'at nankoh lhes sut'e.” ");
INSERT INTO cafNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","'Et 'ilhuhowezdel yun natl'ahudóolts'ih huwa bulh'a. 'Et skwunlai 'o 'at nankoh lhes yílhchoot 'ink'ez, “Suchanailya,” ni ho' tenadedli. Taidalhkut 'ink'ez yugha hoodul'eh yutl'aiyanla hubutunyoonih ka, 'ink'ez hudelhts'i butaininik. ");
INSERT INTO cafNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","'Et lhook chah ntsoolyaz hit'i, 'i chah Sizi “Suchanailya,” ni hoh yuba tenadedli 'ink'ez 'i chah yugha hoodul'eh ndo búlhni, “Hubutunyoonih.” ");
INSERT INTO cafNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ts'iyannah 'aha'al 'ink'ez 'uhunesdai. 'Et yugha hoodul'eh skwunlai 'o 'at nat k'its'ai dezbun 'i highá' wez'al, 'i dih tezkat. ");
INSERT INTO cafNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","4,000 bat'en 'en 'aha'al. 'Aw 'et Sizi hoh whenaóobalh'a. ");
INSERT INTO cafNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","'Et 'ahoh yugha hoodul'eh bulh ts'i be náhedel 'ink'ez keyah Dalmanutha huwhútni whuz yanahúsduki. ");
INSERT INTO cafNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","'Et bulunah Pharisee, 'en Sizi highu nindel 'ink'ez hiyenah hoh hiyóolhdzih hiyóodúlhkut, “Alha Yak'usda ntl'ahón'ai t'eh, yak'uz ts'ih hooncha tune'tant'ilh 'uhonleh, 'i be t'éts'onoozeh ka.” ");
INSERT INTO cafNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sizi tube cho hiba dzuh 'uhídeja 'ink'ez ndo búlhni, “Di ka k'an dune huwa ne'ut'en hukwa' hutni? 'Alha 'un whudúsni 'aw ndi yun k'ut whudune ndúhoont'ah honóolh'en ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","'Et 'ahoh buch'a nanja, ts'i be nája 'ink'ez bun k'ut nyan whenadúki. ");
INSERT INTO cafNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yugha hoodul'eh lhes nahodelhúnuh, lhes lhuk'i zeh ts'i be húlh'ai. ");
INSERT INTO cafNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","'Et Sizi hubugha utni, “Huwohle, 'ahoolhyez khuhdli Pharisee 'ink'ez Herod hubules untuldoh, 'i ch'a,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","'Aw 'et lhulh yáwhehuniltuk, “Et 'aw lhes chats'ít'ih 'et huwa 'utni.” ");
INSERT INTO cafNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","'Et Sizi daja hutni 'uda t'eoonínzun, 'et ndó bulhni, “Et di ka lhes cháht'ih 'et huwa yalhtuk, 'awhuz nt'eoonuzúhzun k'us nuhwheni t'achaoodulhúts'it nuhdzi 'awhuz ih duts'un ho' dahni? ");
INSERT INTO cafNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nuhna hoonli be chaóozeh'en, nuhdzo hóonli be cha'duzahts'uk. 'Aw ih whunachasulhúnik? ");
INSERT INTO cafNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","5,000 dune skwunlai lhes hubutaidalhkut hoh daneltsuk k'its'ai dezbun 'i dune yugha' wéz'al, 'i dih tezkat inle?” “Lanezi 'o 'at nankoh,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ink'ez skwunlai 'o 'at nankoh lhes 4,000 dune butaidalhkut, daneltsuk k'its'ai dezbun, 'i highá' wez'al, 'i dih tezkat ínle?” hubúlhni. “Skwunlai 'o 'at nankoh,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","'Ink'ez ndo búlhni, “Et 'awhuz ih nuwheni tachaoodulhts'it?” ");
INSERT INTO cafNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","'Et Sizi yugha hoodul'eh bulh keyah Bethsaida huwhútni whuz hunindel hoh 'ilhunuh dune chawhés'en, 'en Sizi highu nihínilhya 'ink'ez highu tedudlih yuk'edoolnih ka. ");
INSERT INTO cafNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","'Et Sizi chawhés'en yula ilhchoot 'ink'ez keyah whuch'a inílhya hoh lhch'az dune yuna k'énzo 'ink'ez yuna k'édilnik hoh ndi yulhni, “Dahooja, hoonliyaz ho'en ih?” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Dune yutá'en 'ink'ez 'utni, “A, dune nulh'en, 'et whunts'ih 'aw ts'ah'un chaoozes'en, dune 'ants'ih duchun li'hint'ah hoh nuhúdelh.” ");
INSERT INTO cafNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sizi doo chah zeh lhch'az dune yuna k'édilnik 'ink'ez yeduk yuta'en hoh 'et 'aw 'et whe'en nasdli 'ink'ez ts'iyaitsuk huba hooltsai. ");
INSERT INTO cafNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","'Et Sizi dune chawhés'en bukoo ts'ih whenáyalh'a 'ink'ez khunek ulhtus, 'i be ndi yúlhni, “Bethsaida ts'ih nátonja gunih 'ink'ez Bethsaida whut'en ndo budóni gunih!” ");
INSERT INTO cafNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","'Ink'ez yugha hoodul'eh bulh Caesarea Philippi 'et keyah whuz whehándel. Hedulh hoh huboodulhkut, “Ndun dune sughu yahulhtuk t'eh, ndan usdli hutni?” ");
INSERT INTO cafNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","'Et yugha hoodul'eh 'uhiyúlhni, “Bulunah 'uhutni John dune too be' 'ulh'en inle 'int'ah. 'Et 'uyoon 'uhutni Elijah 'en Yak'usda whusaítelh'alh 'int'ah. 'Et 'uyoon chah Yak'usda be nus whunílh'en 'ilhunuh 'int'ah hutni.” ");
INSERT INTO cafNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","'Ink'ez yugha hoodul'eh ndo búlhni, “Nuhwheni do, ndan 'ust'ah dahni?” 'Et Peter 'utni, “Nyun Christ 'unint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sizi khunek ulhtus 'i be ndo búlhni, “Si sugha dune dóohni gunih!” ");
INSERT INTO cafNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","'Aw 'et Sizi yugha hoodul'eh whubodulh'eh 'ink'ez ndo búlhni, “Yinkak dune ye' tube cho dzuh nuhítelhdzut. 'Et netsuh whudelhdzulh, náwhulnuk moodih 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz chah ts'iyawh 'aw hiyoozólhts'a ghaít'ah. Hituzelhghelh 'ink'ez whulh tat dzin dinadutédalh.” ");
INSERT INTO cafNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Soo ts'et cho hubúlhni, 'et huwa Peter, 'en Sizi 'udun nenílhti 'ink'ez hukwa' yudáni. ");
INSERT INTO cafNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sizi yugha hoodul'eh buts'un nalhú'a 'ink'ez Sizi, 'en Peter hukwa' yúlhni, “Satan sut'ak ninínyih! Ndi yun k'ut hoonliyaz zeh yugha nuní nuzut. 'Aw Yak'usda be 'ut'en k'ah bugha nuní chanuzinzut.” ");
INSERT INTO cafNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","'Et Sizi 'ilhohuwezdel 'ink'ez yugha hoodul'eh tubulh, “Anih,” ndo búlhni, “Ndan suntédulh hukwa' huninzun, dich'oh duba moodih nahoodle ghaít'ah. Dulhdulalhgus hídutootan 'ink'ez suntooya. ");
INSERT INTO cafNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","'Et ndan duk'una'a zeh hukwa' huninzun, 'en 'aw 'ilhuz wheni hukhoona ghaít'ah. 'Et whunts'ih ndan si suba, 'ink'ez khunek unzoo, 'i bugha 'et huwa daházsai t'eh, 'en 'ilhuz wheni hukhutenalh. ");
INSERT INTO cafNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","'Et dune yinkak ndulhcho 'uhoolhdzun 'ink'ez dazsai t'eh, ndet simba whuch'a hólhdeh? 'Aw 'uhóneh ghait'ah! ");
INSERT INTO cafNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","K'us dahóont'ah simba dats'úzsai t'eh, 'aw hoonli be whunts'ih 'ilhuz ts'ukhutenalh nats'uhoket ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","'Et k'an yuk'edinzut lhanah dune ts'eke bulh tinta' hut'ih, 'ink'ez Yak'usda nahodilnah ho' hint'ah. 'Et huwa ndan dune si 'ink'ez sughunek bulh hukwaya unli t'eh, 'et sih yinkak dune ye', 'en yukaya hutele hoh lizas bulh be'aBá buts'u hayánduz, 'i tah whusanája t'eh.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","'Et 'o 'un chah ndutni, “Njan whunaoolhúnih, ndet ts'iyannah Yak'usda ye úlhtus, 'i be hik'úne' 'ut'en, 'i whusáwhutelts'ulh, bulunah dune njan hudelhts'i hote'ilh dahútetsah whutsuh.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lhk'utak'i dzin inle hoh 'et Sizi, Peter, James 'ink'ez John dulh hubutelhúdel ndoh dzulh k'uz dulh 'óbilya. 'Et hinilh'en hoh 'uts'un na'a be hóodiltsai. ");
INSERT INTO cafNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","'Ink'ez bunaih be hóodiltsai, lheyul k'et 'ants'ih soo tsil 'et nduja, degha nus ndi yun k'ut soo toonasdúguz, 'i bugha 'o nus lheyul suli. ");
INSERT INTO cafNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ndunnah tanah yugha hoodul'eh khunyaz Elijah 'ink'ez Moses bulh Sizi hizih siyin 'ink'ez hiyulh yálhtuk hoh hiya'en. ");
INSERT INTO cafNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","'Ahoh Peter Sizi yulh yatelhtuk, “Nehodulh'eh hoonzoo ho' hoont'ah njan uzdelhts'i. Tat bun nuhwhuba nets'oolelh, 'ilhuk'i nyun mba, 'ilhuk'i, 'i Moses ba, 'ink'ez 'ilhuk'i, 'i Elijah ba.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peter ndi khunek be yalhtuk hoh daja dutenilh 'aw nt'eoonízun, ndunnah tahult'ah 'en tube hunelhújoot 'et huwa 'utni. ");
INSERT INTO cafNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Khunyaz kw'us buk'eínde 'ink'ez yedoh kw'us tah ts'ih yaztelhtuk, “Ndun sich'oh suYe' 'int'ah, tube buk'esi'. 'En soo óozelhts'ai,” whutni. ");
INSERT INTO cafNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","'Et 'ahoh dunat nuhúyuz'en, 'aw 'uyoon chahí'il, Sizi 'en zeh hubulh 'út'en. ");
INSERT INTO cafNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","'Aw 'et dzulh k'ut ntsun nahedulh hoh Sizi khunek ulhtus, 'i be ndo búlhni, “Khun teh 'uyoon dóohni gunih! Ndet whunulh'en, yinkak dune ye' dinadutédalh 'et whuts'un.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sizi bughunek hiyoontun hoh lhulh yawhehúniltuk, 'ink'ez nduhútni, “Ndi khunek ‘Dazsai 'ink'ez dinadutédalh?’ dant'i ni hoh 'utni?” ");
INSERT INTO cafNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","'Ink'ez Sizi hiyoodulhkut, “Et Moses be' dustl'us 'uk'ununa'úsduguz di ka hubodulh'eh Elijah 'en 'udechoo whusatéyalh?” ");
INSERT INTO cafNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sizi 'et ndo búlhni, “Elijah 'alha 'udechoo whusaínya ts'iyaintsuk lhaóodutelilh ka. 'Et whunts'ih di ka Yak'usda bughunek 'uk'ununa'usdúguz, 'i 'et ndutni ‘Yinkak dune ye' 'en ye dzuh nutezut 'ink'ez tube hits'u dutnik tele?’ ");
INSERT INTO cafNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","'Et whunts'ih nuhwhudúsni Elijah 'uda whusaínya 'ink'ez dune nts'e na'a hukwa' huninzun t'eh, hoh teh né'hiyulh'en. 'Et Yak'usda be' dustl'us k'ut whuz na'a 'uk'une'úsduguz ínle.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","'Et Sizi 'onghunnah yugha hoodul'eh butananja hoh, dune hubugha 'ilhuhowezdel 'en hubunilh'en 'ink'ez bulunah Moses be' dustl'us 'uk'ununa'úsduguz yugha hoodul'eh hiyenah 'uhutni. ");
INSERT INTO cafNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","'Ilhuhowezdel Sizi hitelh'en ibulh huba hooncha hoh hidudelhúghaz 'ink'ez, “Dahooja,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","'Et Sizi Moses be' dustl'us 'uk'ununa'úsduguz huboodulhkut, “Dant'i ghu yalhtuk ho' 'udahni?” ");
INSERT INTO cafNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","'Ilhuhowezdel 'ilhunuh dune butahaínya, “Nehodulh'eh suye' ntsi' nudúdeh, 'i buyudínda 'et huwa 'aw yaoolhtuk ghaít'ah, 'en nts'un nilhti. ");
INSERT INTO cafNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","'Et ndet ndi ntsi' buyédinda 'i hubugha buba hoolhtus t'eh, 'et yun nadélduz, huwus buzek hanányi, dughoo lhedúlhk'us, 'ink'ez lhts'edunukw. Ngha hoodul'eh ntsi' nudúdeh, 'i yeyuhanahinooyoot, hubudúsni 'et whunts'ih 'aw 'uhiyooleh ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","'Ink'ez Sizi ndi yúlhni, “Aw nuhwheni dune nuhwhuba 'alha' 'uhot'e ghaít'ah! Dáwhuldzah nuhzih tesdalh? Dawhuldzah nuhwhutah tesdalh sudutéhts'o whuts'un 'ink'ez nuhwhuba 'alha' test'ilh? 'Uski ndez suts'u tóolhte!” ");
INSERT INTO cafNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","'Et highu hinílhti. 'Et ndi ntsi' nududeh, 'i ye yudínda Sizi yutelh'en ibulh, 'ahoh 'uski bukaootezut 'ink'ez nadélduz, 'ink'ez huwus buzek haneldo hoh núkallhah. ");
INSERT INTO cafNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","'Et Sizi be'abá yoodulhkut, “Dáhooldzah ndun 'uski 'et ndunt'ah?” yúlhni. “Ntsool da whuts'un,” ní be'abá. ");
INSERT INTO cafNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Lhat hoh 'uski yuzoolhghelh hukwa' yalh'en. Too be chah yuzoolhghelh hukwa' yalh'en 'ink'ez tsídunoh cha' yulh'en. Soo' tenilh t'eh, negha té'nonzeh 'ink'ez nela 'oneh!” ");
INSERT INTO cafNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“A,” yúlhni, “Soo 'úlcho 'i be be 'alha' hoont'ah int'i t'eh, ndan be 'alha' hoont'ah hit'i t'eh, 'en ts'iyaintsuk ne'hutet'en buba huwa chaootelhúnah.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","'Ahoh be'abá bunatsultoo hoonli hoh 'utni, “SMoodihti be 'alha' hoont'ah 'ust'i, 'et whunts'ih 'aw soo cha'lhutus. 'Et huwa sula 'ineh, 'o nus 'iltus, 'i be 'alha' hoont'ah, 'i be 'oost'e ka, 'et hukwa' nuszun.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","'Et Sizi whutelh'en 'ilhuhowezdel 'aw 'et higha welhúghaz hoh 'ahoh khunek ulhtus, 'i be ntsi' nudúdeh, 'i hukwa' yudáni, 'ink'ez ndi yúlhni, “Ntsi' nudúdeh, 'i cha'hudústs'o 'ink'ez yachahulhtuk hubilh'i, ndun 'uski buyáh hanaindaih nyudúsni, 'ink'ez doo chah 'o 'at buyunádondzit gunih!” ");
INSERT INTO cafNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","'Et ntsi' nudúdeh, 'i ndunnah 'uski yukaootelhdzut, 'ink'ez tube cho dulduz, 'alzul, 'ink'ez yeyáhanaja. Ndunnah 'uski 'ants'ih dazsai li'uja. 'Et huwa lhanah, “Dazsai ho' 'int'ah,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","'Et whunts'ih Sizi 'uski yula ílhchoot 'ink'ez nduk 'úyinla. 'Et 'uski dich'oh dinadija. ");
INSERT INTO cafNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","'Et hukw'elh'az Sizi koo danínya hoh yugha hoodul'eh whu'izyaz hiyoodulhkut, “Et dáhoont'ah huwa wheni ntsi' nudúdeh, 'i 'aw buts'u hanáts'inooyoot ghaít'ah?” ");
INSERT INTO cafNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","'Et Sizi ndo búlhni, “Ndan tenahududli, 'ink'ez sahá'hudulyih, 'aw 'i zeh ntsi' nudúdeh, dune nahiyunteyukw.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","'Aw 'et keyah whuch'a nahundel 'ink'ez 'et keyah Galilee wheghah lhunáhusdel. Sizi nts'e whénya ts'ih dune t'éoonózin hukwa cha'nízun, ");
INSERT INTO cafNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","yugha hoodul'eh hubodulh'eh 'et huwa. 'Ink'ez ndo búlhni, “Yinkak dune ye', 'uyoon dune tl'ahítelhtelh 'ink'ez hituzelhghelh. Hizelhghi hukw'elh'az whulh tat dzin 'et dinadutédalh.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","'Aw daja ni hoh 'utni nt'ehonízun 'ink'ez hiyé nuljut 'aw hiyoodolhkut ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","'Et keyah Capernaum ts'ih whuz lhghu nahudídel. Koo danáhandel hoh 'et Sizi yugha hoodul'eh huboodulhkut, “Njan ni ti ts'ih ahdulh hoh, dant'i ghu yalhtuk ho' dahni?” ");
INSERT INTO cafNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Daja hutni hukwaya hinli 'et huwa t'echahudusnih. Ti 'et lhena'uhutni ho' hutni, “Ndan simba netah degha nus dune uncha unli?” ");
INSERT INTO cafNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sizi nátl'adeda ndunnah lanezi 'o 'at nanah yugha hoodul'eh, “Anih,” hubúlhni 'ink'ez ndo búlhni, “Ndan degha nus dune uncha tele hukwa' ninzun t'eh, 'en 'udek'ah wule huba' hoont'ah, 'ink'ez ts'iyannah nané'tet'en.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","'Et Sizi 'ilhunuh 'uskiyaz yílhchoot 'ink'ez hububut ninílhya 'ink'ez yunasúnik hoh ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ndan si soozi gha ndun 'uski ndult'ah danílhti t'eh, si dasunílhti. 'Ink'ez ndan dasunílhti, si zeh ilah dasutálhtelh. Ndun sutélh'a, 'en chah dahinilhti ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","'Et John ndi yúlhni, “Nehodulh'eh, 'ilhunuh dune nyoozi be ntsi' nudúdeh, 'i dune buts'u hanaídulhdoh, 'en uznilh'en. ‘'Ustl'e' 'ineh ts'utni,’ 'aw nelh cha'ust'en 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sizi ndo búlhni, “Aw whuch'a néhyoot ilah, ndan soozi bugha huwa 'ét'en 'uwhulh'en, 'en 'aw hukw'elh'az t'eh dzuh k'una'a sughi yaoolhtuk ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ndan nuhch'a chahudítni, 'en nuhts'un hudetni ho' hint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","'Ink'ez 'utni, “Njan whunalhúnih, nuhwheni Christ bube'ildzun ahli huwa ndan too whunts'ih nuhgha nílhdze t'eh, 'en Yak'usda buba k'elha whutelhtsilh.” ");
INSERT INTO cafNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Et 'ilhunuh 'uski buba 'alha' 'ust'ah, 'ink'ez 'ilhunuh dune lubeshi be such'a itélhtelh t'eh, ndun dune 'uski tink'us na'a wheyúntelhtun 'et whutsuh tse be hits'ilchun ye'ulhchuz 'ink'ez hiyulh tatse doolh'is 'o nus soo' whutet'e. ");
INSERT INTO cafNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","'Et nla 'i bugha lubeshi inla t'eh, nla k'ont'as! 'Et nla k'us zeh int'i hoh yak'uz whénya t'eh whuz 'ilhuz khutanalh, 'et degha nus mba whutézoo. 'Et lhch'az nla bulh kwuncho yuh ts'ih whénya t'eh degha nus mba whutétsi', whuz kwun nachanusne ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","'Et whuz hube 'usgoo 'aw yachatésdla 'ink'ez kwun nachanusne. ");
INSERT INTO cafNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","'Et nke 'i bugha lubeshi inla t'eh, nke k'ont'as! 'Et nke k'us zeh int'i hoh yak'uz whénya t'eh whuz 'ilhuz khutanalh, degha nus mba whútezoo. 'Et lhch'az nke bulh kwuncho yuh ts'ih whénya t'eh degha nus mba whutétsi', whuz kwun nachanusne ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","'Et whuz hube 'usgoo 'aw yachatésdla 'ink'ez kwun nachanusne. ");
INSERT INTO cafNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","'Et nyuna 'i bugha lubeshi inla t'eh, hanó'alh! 'Et nyuna k'us zeh int'i hoh Yak'usda buk'úne' whut'en whénya t'eh, 'et degha nus mba whutézoo. 'Et lhch'az nyuna bulh kwuncho yuh ts'ih whényuhano t'eh, degha nus mba whutétsi', whuz kwun nachanusne ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","'Et whuz hube 'usgoo 'aw yachatésdla 'ink'ez kwun nachanusne. ");
INSERT INTO cafNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Lizwif Yak'usda ts'un khunai hidélhk'un hoh 'udechoo lusel hik'unhiyudzih. 'Et whuz na'a ts'iyannah dzuh nutezut ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Lusel unzoo ho' 'int'ah, 'et whunts'i lusel buzachahoolkih 'uts'ulh'ih t'eh, nts'e na'a doo chah lusel buzahóolki 'uztelhtsilh? Whuz na'a nuhdzi wútsi' gunih 'ink'ez nuwhulh dune ts'un nuhdzi dóoghel.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","'Et Sizi whuch'a nasja 'ink'ez Judea huwah nenínya, 'et took'oh Jordan huwhútni, 'et yasúya. 'Et lhanah dune yugha wézdel. 'Et whutsuh da datni 'ahoolhyez whuz na'a doo chah zeh huboodulh'eh. ");
INSERT INTO cafNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","'Et bulunah Pharisee highu nindel 'ink'ez hiyóolhdzih hoh hiyoodulhkut, “Nedíni, dune 'en ih bughá whunt'ai bu'at lahudootnih ka?” ");
INSERT INTO cafNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","'Et Sizi 'utni, “Daja ni hoh Moses khunek nuhtl'aída'ai inle, 'i?” ");
INSERT INTO cafNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","'Et 'uhiyúlhni, “Moses bugha óonin'ai dune dustl'us yuk'une'úzguz, 'i be bu'at buch'a nayólhtelh.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","'Et Sizi ndo búlhni, “Stabe nuhdzi duts'un 'et huwa ndi khunek Moses nuhwhuba yuk'e'ánguz. ");
INSERT INTO cafNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","'Et whunts'ih 'udechoo Yak'usda ts'iyaintsuk inla hoh dune 'ink'ez ts'eke chah inla. ");
INSERT INTO cafNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","'Et njan huwa dune be'abá 'ink'ez be'ama bulh buch'a óoya, 'ink'ez bu'at 'en zeh zih wuda. ");
INSERT INTO cafNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","'Et nuhult'ah 'ilho hutele, 'et 'o 'un hoh nanah chahílah. ");
INSERT INTO cafNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ndan Yak'usda lhghá buninla, 'en 'aw dune lhch'a nabuhóolelh huba cha'hóot'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","'Et koo danáhandel hoh yugha hoodul'eh Sizi njan dáhoont'ah 'et hukwa hiyoodulhkut. ");
INSERT INTO cafNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","'Et ndo búlhni, “Dune ndan bu'at 'ún tezno 'ink'ez 'uyoon ts'eke ghu nasda t'eh, 'en 'uyoon ts'eke bulh tinta' tét'ilh ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","'Et whuz na'a zeh ts'eke buki 'ún tezno 'ink'ez 'uyoon dune ghu nasda t'eh, 'en chah 'uyoon dune tinta' tet'ilh.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bulunah dune 'uskeh Sizi ts'un nibaninla buk'edoolni ka, 'et yugha hoodul'eh ndunnah 'uskeh whusaínla hukwa' búdani. ");
INSERT INTO cafNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","'Et Sizi whunalh'en hoh hunílch'e 'ink'ez yugha hoodul'eh ndo búlhni, “Whute 'uski suts'un hutoodelh. Khun teh dah hubudóohni gunih. Ndan Yak'usda hubudayi cho unli whuz hudelhts'i, 'en ndunnah 'uskehyaz hubunduhúlt'ah ho' hint'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Soo ts'ah'un 'alha' 'un whudúsni, ndan 'uskehyaz k'una'a njan Yak'usda hubudayi cho unli chahoolhchulh t'eh, 'aw whuz dahóoya ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","'Et 'uskehyaz ts'iyawh bunasunik 'ink'ez 'ilhunah hinli hoh hubuk'edilnik 'ink'ez huba tenadedli. ");
INSERT INTO cafNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","'Et Sizi doo chah natesja hoh dune yududelhgai, yubut bugwutsi be nenínya 'ink'ez yoodalhkut, “Dune hoodulh'eh unzoo, nts'e na'a dast'en hoh 'ilhuz khutesnalh whuch'a ootélhdoh?” ");
INSERT INTO cafNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","'Et Sizi 'uyúlhni, “Di ka 'usudíni, ninzoo sudíni? 'Aw 'ilhunuh unzoo hoolah. Yak'usda 'aw 'en zeh unzoo ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ndi khunek Yak'usda nuhtl'aída'ai, 'i 'et t'eninzun: nesóolhghelh gunih, dune k'us ts'eke bulh tinta' 'ont'en gunih, 'undunont'ih gunih, honts'it gunih, ha'ndunont'ah gunih, nyu'abá 'ink'ez nyu'ama chah hubudólhti.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","'Et dune 'utni, “Nehodulh'eh ndet chilh usdli 'uda whuts'un, ndi khunek ts'iyawh buk'úne' zust'en.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","'Et Sizi soo yuk'entsi' hoh yunalh'en 'ink'ez ndi yúlhni, “Ilhun zeh whu'et 'int'ah, inyalh 'ink'ez ndai int'i, 'i ts'iyawh be 'ónket 'ink'ez sooneya tehel'en hubugha ínondzaih, lhdulalhgus ilhchoot 'ink'ez 'anih, se'ut'en k'ah tune' 'ónt'en ka sunanyalh. 'Et t'eh nduk yak'uz hoonzoo, 'et whuch'a ootálhdoh.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","'Et ndun dune ndi khunek whudánts'o hoh tube budzi ndesda, 'ink'ez tso unli hoh yughu natesja, tube soode'a 'int'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sizi yugha hoodul'eh bunilh'en 'ink'ez ndo búlhni, “Dáhoont'ah huwa whúlna hoh ndan soode'a, 'en Yak'usda hubudayi cho unli, 'et dahútedulh.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","'Et yugha hoodul'eh ndi khunek hídants'o hoh tube huba hooncha. 'Et Sizi whuz heyelh hoh ndutni, “Suzkehkah dahoont'ah huwa whúlna hoh 'en duzooneya hit'az 'int'ah Yak'usda hubudayi cho unli, 'et dahútedulh. ");
INSERT INTO cafNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Dant'ah khunai cho, camel hiyúlhni, 'i 'aw yubatsoh buna 'aw yukólget ghaít'ah. 'Et whuz na'a dune soode'a 'int'ah, 'o nus buba huwa whúlna Yak'usda hubudayi cho unli datéyalh huba.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","'Et yugha hoodul'eh tube buba hooncha 'ink'ez lhuhoodulkut, “Ndan simba doojih?” ");
INSERT INTO cafNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","'Et Sizi hubunilh'en 'ink'ez ndo búlhni, “K'us njan 'et dune ba 'uhóneh ghaít'ah, 'et whunts'ih Yak'usda ba ts'iyaintsuk 'aw huwa chahóolnah ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","'Et Peter yatélhtuk, “Soo cho whunilh'en, ts'iyaintsuk bulazdetnik 'ink'ez nts'un tezdel.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","'Et Sizi ndo búlhni, “A, ts'ah'un nuhwhudúsni, ndan bukoo huwu tezya 'ink'ez dulhutsinkah, k'us dulhtuskah, be'ama, be'abá, bu'at, buzkehkah, k'us duyun k'ut t'eh, si sugha 'ink'ez ndi khunek unzoo, 'i k'uz ts'iyaintsuk whuladetnik, 'ink'ez suntezya t'eh, ");
INSERT INTO cafNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nus de 'o nus lhai únli hoh butl'anaítekulh: bukoo 'ink'ez bulhutsinkah, bulhtuskah, be'ama, buzkehkah, 'ink'ez buyun k'ut 'ink'ez dune hiye tena'tel'ilh chah, 'ink'ez nus de 'ilhuz khutena. ");
INSERT INTO cafNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","'Et whunts'ih lhanah 'udechoo 'int'ah 'en 'udek'elh'az hutele, 'ink'ez lhanah ndunnah 'udek'elh'az hinli, 'en 'udechoo hutele.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","'Aw 'et Jerusalem ts'ih ti hedulh Sizi, 'en yugha hoodul'eh hubutsuh úyalh. Hoh hedulh tube huba hooncha k'et whéhunuljut. 'Et doo chah Sizi yugha hoodul'eh lanezi 'o 'at nanah 'udun nébuninla 'ink'ez nus de bulh daóotenilh, 'et hubugha hubulh yaílhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","'Et ndo búlhni, “Sih soo zélhts'ai, Jerusalem ts'ih ts'utedulh 'ink'ez yinkak dune ye', 'en Lizwif náwhulnuk moodih 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz, 'en butl'aihítelhtelh. 'Et datétsah wheni hiba nahuteyeh, 'ink'ez ndunnah 'udun yun k'ut whut'en, 'en butl'aihítelhtelh. ");
INSERT INTO cafNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","'Et 'en highu tedloh, higha dútezoh, hiyootélhtsus 'ink'ez hituzelhghelh. 'Et tat dzin inle t'eh, dinadutédalh.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","'Et James 'ink'ez John bulh Zebedee buye'kah Sizi highu nin'az 'ink'ez hiyoodulhkut, “Nehodul'eh ndai nts'un buka' ts'utni, 'i 'et neba 'uwhutanlilh hukwa' ts'uninzun.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sizi huboodulhkut, “Ndet nuhwhuba 'uwhutesdlilh hukwa' nahzun?” ");
INSERT INTO cafNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","'Et 'uhutni, “Ndet yak'uz degha nus dénti ts'ih sinda t'eh, nzih taduke 'et hukwa' nídudzun, 'ilhunuh 'en nalhnih ts'ih 'ink'ez 'ilhunuh 'en 'intl'as ts'ih 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","'Et Sizi ndo búlhni, “Ndet suts'u hukwa' dahni 'aw t'éoonuzúhzun k'us ndi lubot be tesnilh, 'i soo tulih wahnai 'ink'ez nts'e na'a too bé' 'ulya soo tulih whuz na'a too be' 'óohneh?” ");
INSERT INTO cafNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Soo sih 'uts'ooneh,” hiyúlhni. 'Et Sizi ndo búlhni, “Ndai lubot be tesnilh, 'i nuhwheni chah téhtnilh ho' 'int'ah. 'Ink'ez too bé' 'ulya whuz na'a nuhwheni chah too be' téhnilh. ");
INSERT INTO cafNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","'Et ndan nalhnih ts'ih sughu tedalh, 'ink'ez 'intl'as ts'ih sughu tedalh, 'aw si huwá hos'alh ghaít'ah, ndunnah huba lhawhúdulya, 'en zeh buba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","'Et 'o 'un lanezi yugha hoodul'eh, 'en James 'ink'ez John hubulh hánilch'e. ");
INSERT INTO cafNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","'Et Sizi soo ts'iyawh, “Anih,” hubudáni, 'ink'ez ndo búlhni, “Et nt'eoonáhzun 'udun yun k'ut whut'en hubutah, ndun dune tsuh whudelhdzulh hinli, 'en dune buk'ut moodih hinli. 'Ink'ez ndan bumoodih hinli, 'en chah bumoodih hinli. ");
INSERT INTO cafNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","'Et whunts'ih nuhwheni nuhtah 'aw whuz na'a ilah ho' hoont'ah. 'Ilhunuh nuhtah dune uncha tele hukwa' ninzun t'eh, 'o 'awh chah huba ne'óot'en wule huba' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","'Et nuhtah 'ilhunuh 'udetsah tele hukwa' ninzun t'eh, ts'iyannah 'e'ulhna wule huba' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yinkak dune ye', 'en whunts'ih 'aw ba né'whutet'en huba whusachaíyal 'et huwa. Dune buba né'tet'en 'ink'ez dune buba datétsah 'et hoh dune ts'iyawh nabootekulh.” ");
INSERT INTO cafNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jericho ts'ih hunindel, Sizi yugha hoodul'eh tubulh nahutesdel hoh, lhanah 'ilhuhowezdel chah 'ut'en. Dune chawhés'en Bartimaeus hiyúlhni, Timaeus buye', 'en ti whuzih usda hoh tedudlih, ");
INSERT INTO cafNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sizi Nazareth whut'en wheghah uyalh whulhúdants'o. 'Ahoh hazulh hoh 'utni, “Sizi, David buts'u hainzut sugha té'ninzeh!” ");
INSERT INTO cafNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lhanah t'edoosnih hiyulhni 'ink'ez whuch'a hínenyoot. 'Et whunts'ih 'o nus 'alzul hoh 'utni, “Sizi, David buts'u hainzut sugha té'ninzeh!” ");
INSERT INTO cafNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sizi 'ilhunenínya 'ink'ez ndo búlhni, “Anih sba dáhni,” hubúlhni. 'Et dune chawhés'en yuka hunih, “Hoonínt'i 'ink'ez didinyih, 'anih nyúlhni,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dunaihts'uz 'i ts'ahayét'ah, dudillhah, 'ink'ez Sizi yughah ninínya. ");
INSERT INTO cafNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Et dányutesdlilh 'et suts'u hukwa' ninzun?” ni hoh Sizi yoodulhkut. “Nehodulh'eh doo chah whes'en naóosle, 'et sugha holts'it,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Naindalh, si suts'un be 'alha' hoont'ah, 'i be soo ná'inja,” yúlhni. 'Et 'ahoh dune 'aw 'et whe'en nasdli, 'ink'ez Sizi ti yuntezya. ");
INSERT INTO cafNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","'Aw 'et Jerusalem whéghah hedulh, nat keyah Bethphage 'ink'ez Bethany chah 'et dzulhyaz Olive be hóodzi, 'et whuz nihúnindel. 'Et Sizi nanah yugha hoodul'eh whébalh'a, 'et ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Keyah whiyaz nda ts'ih whuz'ai whuz ah'us. Whuz lhugha dah'az, 'et yeztliyaz, donkey hiyúlhni, whutsuh da dune yak'uchaídah, 'i 'et whédint'uk, 'i lhk'unadooh'uk 'ink'ez suts'u toolhdlooh. ");
INSERT INTO cafNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dune, ‘Di ka 'et ndaht'en?’ nuwhúlhni t'eh, ‘NeMoodihti yuka' ninzun’ doohtni. 'Aw 'et sih nuhtlayoolhtelh.” ");
INSERT INTO cafNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","'Et whehá'az 'ink'ez keyah 'et yeztliyaz nahuyilhti, 'ilhunuh bukoo ndati 'et whédint'uk, 'ink'ez lhk'unahida'uk. ");
INSERT INTO cafNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","'Et bulunah n'awh nahudelhúya, 'en hubuhoodulhkut, “Et daht'en hoh aht'en yeztliyaz lhk'unadah'uk?” hubuhútni. ");
INSERT INTO cafNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","'Et Sizi buba nahezya k'una'a hubuhútni, 'et 'ants'ih t'ehudínel 'ink'ez hubula hudetnik. ");
INSERT INTO cafNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","'Et Sizi yeztliyaz highu hinílhti hoh bulunah nahiyíts'uz 'i hiba hik'ehiyílhdel 'ink'ez Sizi yuk'étl'adida. ");
INSERT INTO cafNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lhanah dune chah nahiyíts'uz, 'i ti 'et nehíyuzbus. Bulunah chah 'ul k'us 'ut'an k'unuhídut'as, 'i ti nahídulhdelh Sizi yuk'ut lhuteyalh 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ndunnah dune Sizi hitsuh hedulh, 'ink'ez hik'ah hedulh, ts'iyawh hahuzulh hoh 'uhutni, “Yak'usda ba whudélhti! NeMoodihti boozi bugha whusaínya, 'en degha nus hoonzoo bughá whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Netsuh whudelhdzulh, David hubudayi cho keyah 'et dúhoont'ah chah zeh whusawhutélts'ulh, 'et Yak'usda ba ts'odóolhti.” ");
INSERT INTO cafNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","'Aw 'et Sizi Jerusalem keyah neninya hoh Lizwif hubuluglez whucho ts'ih danínya 'ink'ez dulhcho núyuz'en. 'Aw 'et náwhendunilhghel 'et huwa Bethany huwhútni ts'ih whuz lanezi 'o 'at nanah yugha hoodul'eh whuz hubulh whén'az. ");
INSERT INTO cafNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","'Om bun Bethany ts'ih whuz de nahédulh 'et Sizi buye'élts'ul. ");
INSERT INTO cafNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nilhdza 'et mai chun yunílh'en but'an chah hoonli. 'Et yughu nínya mai ntélhcholh ka. Yughu ninya hoh 'ut'an zeh 'int'ah, nk'achah bumai hoolah. ");
INSERT INTO cafNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","'Et Sizi ndi mai chun ndi yúlhni, “Aw 'o 'at dune nyumai hunoo'alh ghaít'ah!” 'Et ndutni hoh yugha hoodul'eh hídants'o. ");
INSERT INTO cafNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","'Et Jerusalem ts'ih hunindel. Sizi Lizwif hubuluglez whucho 'et daninya. Ndunnah 'e'óoket 'ink'ez 'ooket ts'iyawh tinábuninyoot. Sooneya lhk'enáhududzaih bukw'uzdai chah naína'ai, 'ink'ez dut'ai be 'óoket chah, ");
INSERT INTO cafNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","'aw luglez hoonli ne'hóole butl'achahoo'al. ");
INSERT INTO cafNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","'Ink'ez Sizi dune whubodulh'eh ndo búlhni, “Yak'usda be' dustl'us k'ut 'uk'ut ne'úsduguz, ‘Njan sukoo ts'iyannah tenadudli bakoo 'úhoont'ah,’ ni. 'Et 'uwháhla undunut'ih 'ink'ez nanúl'i bakoo whuzúlhtsi!” ");
INSERT INTO cafNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","'Et náwhulnuk moodih 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz hodánts'o hoh, hizoolhghelh hukwa húnuta, tube hiyé nuljut, ts'iyannah 'ilhuhowezdel hubodulh'eh, 'en huba hooncha 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Soo nadálhghel ibulh Sizi yugha hoodul'eh hubulh Jerusalem whuch'a nahúndel. ");
INSERT INTO cafNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Hoh bundada 'uda 'et ti hedulh ndi mai chun hinilh'en. Soo ts'ah'un bughih tubulh desuz. ");
INSERT INTO cafNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","'Et Peter, 'en whunalnik hoh Sizi bulh yátelhtuk, “Nehodulh'eh nilh'en ndi mai chun bulh buk'éhanya, 'i desuz,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","'Et Sizi ndo búlhni, “Njan whunaoolhúnih, Yak'usda nuhwhuba 'alha' 'int'ah t'eh, ");
INSERT INTO cafNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ndi dzulhyaz 'i 'udóohni, ‘Didilts'it 'ink'ez bun k'ut whucho ts'ih tailts'it.’ 'Et soo nuhdzi yuh 'aw nawh cha'hoot'ah 'ink'ez nuhwhuba 'alha' hoont'ah t'eh, dawhútenilh dahni, ts'iyawh nuhwhuba 'et ndó tenilh. ");
INSERT INTO cafNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","'Et huwa' 'un whudúsni, ndi be 'alha' hoont'ah, 'i be tenadahdli, 'ink'ez hoonli ka' dahni 'et 'alha' nahzun hoh nuhgha tekulh t'eh, ndai buka' dahni, 'i nuhgha tekulh ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","'Et sahyin hoh tenadahdli, 'ink'ez 'uyoon ts'un nuhwhuba dzuh t'eh, buba n'ún whutulhdelh, 'et sih nuhwhe'aBá, yak'uz úsda, 'en nuhwheni chah nuhwhulubeshi nuhwhuba 'un yutoolhdelh. ");
INSERT INTO cafNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","'Et 'uyoon buba n'ún chaootulhdulh t'eh, nuhwhe'aBá, yak'uz úsda, 'en chah 'aw nuhwhulubeshi nuhwhuba 'un yutoolhdelh ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","'Ink'ez doo chah Jerusalem ts'ih nahundel, Sizi Lizwif hubuluglez whucho nuya hoh náwhulnuk moodih, Moses be' dustl'us 'uk'ununa'úsduguz, 'ink'ez dune tsuh whudelhdzulh, 'en Sizi highu nindel, ");
INSERT INTO cafNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","'ink'ez ndi híyulhni, “Nedini ndai bugha dune bugha ndoh 'int'ah hoh njan ndint'en? Ndan nghá ooni'ai hoh 'int'en?” ");
INSERT INTO cafNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","'Et Sizi ndo búlhni, “Ilhun zeh hukwa nuhoodutelhkut. 'Et ndusudáhni t'eh, 'et sih ndun whudóosni ndi dune bugha ndoh 'ust'ah hoh njan ndust'en. ");
INSERT INTO cafNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ndusudóohni ndun John dune too be' 'ulh'en ndan yutl'ahón'ai hoh dune too be 'úlh'en inle, Yak'usda tulih k'us dune tulih yugha ooní'ai?” ");
INSERT INTO cafNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","'Et 'ahoh dich'oh dutah hukw'u nahúhulhye hoh njan duhútni, “Daja chah uzdooni, ‘Yak'usda yugha ooní'ai,’ ts'utni t'eh, 'et sih dooni, ‘Di ka John nuhwhuba 'alha' cha'dusnih?’ ");
INSERT INTO cafNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","'Et, ‘Dune yugha ooní'ai ts'utni t'eh,” 'et njan dune hubé hunuljut 'et huwa, ts'iyawh dune John dune too be 'ulh'en, 'en Yak'usda be nus whunilh'en unli inle huninzun. ");
INSERT INTO cafNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","'Et huwa Sizi 'uhiyúlhni, “Aw t'ets'onízun.” Sizi 'et ndo búlhni, “Si chah ndan sugha óoni'ai 'aw nuhwhudoosni ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","'Aw 'et Sizi khunek hiye oodool'eh hubugha hubulh yálhtuk, “Ilhunuh dune, 'en mai haníyeh, mai too 'úlh'ih, 'i 'ainanla. Yuna'neztl'oo, tsak'et hahónkaih, mai tahúndununih huba, 'ink'ez yutést'en chah 'uhóonla. 'Et dune bughu whulh'ai 'ink'ez ninza keyah whenya. ");
INSERT INTO cafNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","'Et 'aw 'et mai oonteje niwhuninzut t'eh, 'ulhna 'ilhunuh 'en mai haníyeh k'et butl'ahúhonla buts'ú wheyalh'a, ndai ooneje, 'i bulah buts'itookat huba' hoont'ah, 'i ka. ");
INSERT INTO cafNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","'Et 'uhiyínla ndunnah mai k'et butl'ahúhonla, 'ulhna hiyílhchoot yahúyalht'o 'ink'ez hoonli higha chaílel hoh whenáhinanyoot. ");
INSERT INTO cafNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ndun dune be'íldzun, 'en doo chah 'uyoon 'ulhna whuz whelh'a. 'En tse be nahínelh'uz hitsi ts'e' nalh'uz hoh nukai híyulhtsi, 'ink'ez hukwa yáhoonli k'una'a 'uhiyínla hoh whenáhinanyoot. ");
INSERT INTO cafNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Doo chah 'uyoon 'ulhna whuz wheyalh'a. 'En hizelhghi. Lhanah 'uyoon chah 'et ndo buhinla. Bulunah hubuhoolht'ah 'ink'ez bulunah chah hubuhanghan. ");
INSERT INTO cafNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","'Ilhunuh zeh 'udek'elh'az whuz buts'un wheyálh'a, 'et usda, 'en buye' yuk'entsi', ‘Suye', 'en sih hidóolhti,’ ni 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ndunnah dune mai k'et butl'ahúhonla 'et 'ulhodútni, ‘Ndun njan mai k'et be'ildzun, 'en buye' 'int'ah. 'Anih, ts'uzoolhghelh. 'Et sih ndun buye' buts'ítekulh, 'i ts'iyawh ne'ildzun wule.’ ");
INSERT INTO cafNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","'Et ndun buye' hiyílhchoot, hizelhghi 'ink'ez hiyust'e 'i nyoh haníyeh k'et tínahinino.” ");
INSERT INTO cafNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","'Et Sizi huboodulhkut, “Daóoneh simba ndun mai k'et whulh'ai? Whusanája, 'ink'ez ndunnah dune ts'iyawh hubóoghan, 'ink'ez mai k'et 'uyoon gho hohólh'a. ");
INSERT INTO cafNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","'Aw whutsuh whudelhdzulh ndi Yak'usda bughunek 'uk'une'úsduguz, 'i, 'aw ih buk'eyáchasulhtuk? 'Et ndutni, ‘Ndi tse be koo 'uwhulh'en 'ún hidutelh'uz, 'i 'uja degha nus bukadaoodilt'ah, 'i suli. ");
INSERT INTO cafNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","'Et Moodihti whuz na'a 'uhóonla. Tube huba hooncha k'una'a 'obínla ho' hoont'ah.’ 'Et whuz na'a Yak'usda be' dustl'us k'ut ndutni,” ndo búlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","'Et Lizwif bumoodih, 'en Sizi hiyoolhchoot hukwa' hut'en, t'ehonínzun didut buch'a yálhtuk hoh dune hoodalh'i, 'et whunts'ih dune 'ilhuhowezdel hiye nuljut huwa Sizi dachahíyilil hoh whenáhedel. ");
INSERT INTO cafNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","'Et bulunah Pharisee 'ink'ez Herod budune chah 'en Sizi khunek be hiyoolhgooh ka hits'ú wheóobahalh'a. ");
INSERT INTO cafNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","'Et Sizi highu nindel 'ink'ez 'uhutni, “Dune hoodulh'eh t'ets'onínzun ts'ah'un zeh 'udanilh. 'Aw 'uyoon daja huntezilh huwu ni chaínlah hoh dune dant'ah whunts'ih chabunílh'en hoh Yak'usda beni k'ah ts'ih hubugha khunek 'alha' 'int'ah, 'i be whúbodilh'eh. 'Et nedíni wheni khunek netl'ahon'ai, 'i whudulhyah 'uts'oot'en ih tulih Roman keyah whumoodih buts'un yun k'elha ts'uhoolh'i 'i buba buk'elha ts'otelh'i tulih k'us 'awundooh tulih?” ");
INSERT INTO cafNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","'Et whunts'ih Sizi hiyoolhgooh hukwa' hiyulh'en t'eoonanzin, 'ink'ez ndo búlhni, “Et di ka sóolhdzih? Sooneya stl'anah'aih noolh'en sih.” ");
INSERT INTO cafNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","'Aw 'et 'ilhunuh sooneya yutl'ainá'ai. 'Et Sizi huboodulhkut, “Ndan ho' 'int'ah bunen 'ink'ez boozi 'ukw'e'usdúguz?” 'Et 'uhiyúlhni, “Yun k'ut whumoodih Caesar, 'en 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","'Et Sizi ndo búlhni, “Ndai Caesar be'ildzun, 'i buts'un buk'elha whulh'i, 'ink'ez ndai Yak'usda be'ildzun, 'i Yak'usda ts'un buk'elha whulh'i.” 'Et soo tube huba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","'Aw 'et ndunnah Sadducee hubuhútni, 'en Sizi highu nindel. 'En 'uhutni, “Dats'úzsai 'ink'ez 'aw nats'ukhóotnah ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","'En hiyoodulhkut hoh 'uhutni, “Nehodulh'eh Moses 'en khunek negha ide'ai, 'i neba yuk'une'úzguz, ‘Dune bu'at 'en dazsai, 'ink'ez buzkeh hoolah t'eh, ndun dune dazsai bulhutsin 'en ndun tsandelh yughu naooda, ndun dune dazsai, 'en ba buzkeh hole ka.’ ");
INSERT INTO cafNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","'Et skwunlai 'o 'at nanah lhulhutsinkah hinli, 'udetsah whudelhdzulh, 'en 'at ut'i, 'awhuz buzkeh hoolah hoh dazsai. ");
INSERT INTO cafNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","'Et yuk'ah whúdelhdzulh, 'en tsandelh yughu nasda. 'En chah buzkeh hoolah hoh dazsai. 'Et whulh tat chah whuz na'a zeh 'uja. ");
INSERT INTO cafNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ts'iyawh skwunlai 'o 'at nana 'ilho dunedzulh 'en ts'iyawh highu dalts'i, ts'iyawh bubuzkeh hoolah hoh yahadla. 'Udek'elh'az ndun ts'eke dich'oh chah dazsai. ");
INSERT INTO cafNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ndunnah yahadla ts'iyawh dinahudutédulh dzin dinahudidel t'eh, k'us ndan simba bu'at tele, ts'iyawh skwunlai 'o 'a nanah, 'en highu dálts'i?” ");
INSERT INTO cafNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","'Et Sizi ndo búlhni, “Tube 'uts'un na'a 'udahni. Ndet daja dahni t'eoonuzáhzun ih? Yak'usda ye ulhtus, 'i 'ink'ez bughunek k'e'eduguz, 'i t'énuzahzun, 'et huwa whuz na'a 'udahni. ");
INSERT INTO cafNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ndet yahadla dinahudidel t'eh, ndoh yak'uz lizas li'hint'ah. 'Et ndó tet'ilh dune chah 'ink'ez ts'ekoo chah 'aw lhgha hudóolts'i ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","'Ink'ez ndunnah yaidla dináhudutédalh hubugha, ndi Moses 'uk'une'úsduguz, 'i 'aw ih buk'uyachálhdih, whus delhtan, 'i tah whudezk'un hoh Yak'usda yulh yalhtuk inle? 'Et 'uk'une'úsguz, 'i ndutni ndun Moses Yak'usda ndi yulhni, ‘Si 'ust'ah Abraham 'en buMoodihti 'ust'ah, Isaac, 'en buMoodihti 'ust'ah, 'ink'ez Jacob, 'en chah buMoodihti 'ust'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","'Et huwa huhukhuna hubuYak'usda 'int'ah, 'aw yahadla hubuYak'usda ilah ho' 'int'ah. 'Et 'ílhuz 'uts'un na'a 'udahni.” ");
INSERT INTO cafNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","'Ilhunuh dune Moses be' dustl'us 'uk'ununa'úsduguz, 'en 'et 'ut'en, 'ink'ez hubudánts'o 'ink'ez 'en t'éoonínzun Sizi ndunnah Sadducee soo ndo budáni. 'Et didut chah Sizi yoodulhkut, “K'us ndai khunek neba yutulhúhezya, 'i k'us dezti?” ");
INSERT INTO cafNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","'Et Sizi 'uyúlhni, “Ndi degha nus dezti, 'i 'int'ah, ‘Israel budune, oozélhts'ai, neMoodihti 'en Yak'usda unli. 'En zeh 'ilhunuh Moodihti 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yak'usda nuhMoodihti nuhdzi ndulhcho, 'i be, nuhzul ndulhcho, 'i be, 'ink'ez nuhwhubeni ts'iyawh ndulhcho chah.’ ");
INSERT INTO cafNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Whulh nat khunek higha nélh'a, 'i chah degha nus dezti, 'i 'int'ah, ‘Nts'e na'a nuhwhenich'oh k'enahdutsi', whuz na'a nuhwhulh dune chah buk'eoohtsi'.’ 'Aw 'uyoo khunek higha nélh'a, 'i ndi nankoh 'o nus dezti, 'i hoolah.” ");
INSERT INTO cafNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","'Et ndun Moses bughunek 'uk'ununa'úsduguz, 'en Sizi 'uyúlhni, “Nehodulh'eh soo' denja! Khunek 'alha' 'int'ah, 'i be yailhtuk! Degha ndoh Moodihti 'en zeh Yak'usda unli, 'aw 'uyoon Yak'usda chaílah. ");
INSERT INTO cafNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","'Ink'ez dune budzi ndulhcho 'i be Yak'usda yuk'eootsi' huba' hoont'ah, budeni ts'iyawh 'i be, buzul be, bunut'uk ts'iyawh, 'ink'ez dich'oh k'enadutsi' chah, whuz na'a bulh dune hubuk'eootsi'. 'Et degha nus neba hooncha ndi nankoh khunek yugha nélh'a, 'i buk'úne' ts'oot'en. Khunai 'ink'ez 'uyoo hoonliyaz Yak'usda bukw'uzdai k'ut Yak'usda bugha ídezk'un, 'i ba 'o nus whudezti.” ");
INSERT INTO cafNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sizi t'éoonanzin dalcho 'i be whunih k'una'a 'udéja 'et ndi yúlhni, “Aw 'et nilhdukw hoh Yak'usda k'úne' nyul'en tele.” 'Et hukw'elh'az 'aw 'udun hukwa chahiyoodílhkulh hiyéntsaz 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","'Et Sizi, 'en Lizwif hubuluglez whucho dune hoodulh'eh hoh huboodulhkut, “Nts'e na'a ndunnah Moses be' dustl'us 'uk'ununa'úsduguz, ‘Christ 'en David buts'u hainzut tele ho' 'int'ah,’ hutni? ");
INSERT INTO cafNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","'Et David, 'en Ndoni bugha 'et ndutni, ‘Moodihti 'en suMoodihti 'uyúlhni njan nalhnih ts'ih sughu sinda. Hoh t'eh sih nch'a húdetni, 'en buk'ut nke naóolhyis mba hólhsilh.’ ");
INSERT INTO cafNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David dich'oh, ‘Sumoodihti,’ yúlhni, 'et nts'e na'a Christ 'en David ts'ih haínzut wule?” 'Et nyoh dune, 'en huhóont'i hoh hidants'o. ");
INSERT INTO cafNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","'Et Sizi hubodulh'eh hoh 'et ndo búlhni, “Ndunnah Moses be' dustl'us 'uk'ununa'úsduguz, 'en buch'a kháhdli. Ndunnah 'e'óoket bakoo 'et dune tah hoh nahúduchun tl'asus nyez be húdelhts'i, 'ink'ez dune hubaoodelhti hukwa ne'hutdudul'en. ");
INSERT INTO cafNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Njan luglez ndet huntel'ilh, 'et 'utaháoodet'aih, 'ink'ez dune dahúlih teh, 'et chah k'us whudézti, 'et didut nátl'ahududaih. ");
INSERT INTO cafNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tsandelh chah khábonut'ah, 'ink'ez bukoo huwa hahuwhút'aih. 'Ink'ez ncha ná'hadudil'i hoh sa cho tenahududli. 'En 'et hukw'elha 'o nus dzuh nahútezut ho' hint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Lizwif hubuluglez whucho sooneya dekat, 'et Sizi usda, 'ink'ez hubunilh'en sooneya dehínudzaih. Lhanah soode'a 'uhint'ah, 'en sooneya lhai hoh dehínudzaih. ");
INSERT INTO cafNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","'Et 'ilhunuh tsandelh tel'en, 'en 'óh wheghah uyalh, 'ink'ez nankoh sooneyayaz dénalhdel. ");
INSERT INTO cafNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","'Et Sizi yugha hoodul'eh ts'un bé' buntelhúnik 'ink'ez ndo búlhni, “Nuhwhudúsni ndun tsandelh tel'en, ndunnah ts'iyawh huba nus lhai 'i denandzai ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ndunnah 'uyoon, 'en ndai hiye soode'a 'int'ah, 'i 'un hakat, 'i 'uhiyulh'en dehínudzaih. 'Et ndun lhe'int'ah tel'en ndai 'aw 'i yít'i, 'i yuk'ekhutenalh, 'i whunts'ih ts'iyawh deyándzai.” ");
INSERT INTO cafNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","'Et Sizi Lizwif hubuluglez whucho tinanja hoh 'ilhunuh yugha hoodul'eh ndi yúlhni, “Nehodilh'eh whunilh'en, njan luglez whucho 'ink'ez tse chah 'i lhe'íldzoo 'i be 'uhóolya.” ");
INSERT INTO cafNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","'Et Sizi 'utni, “Njan koo whucho whuzdla whunulh'en ih? 'Aw lhuk'i tse 'i whunts'ih lhk'uchadutésdlal, 'i ts'iyawh nadúntejulh ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","'Aw 'et Lizwif hubuluglez whucho huwanch'az dzulhyaz Olive hiyúlhni, 'i k'ut, 'et Sizi usda. Peter, James, John, 'ink'ez Andrew chah, 'et dune hoolah, 'et Sizi hiyoodulhkut. ");
INSERT INTO cafNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","'Et hiyúlhni, “Nedíni nket'ah 'uwhuténilh? 'Ink'ez ndet huwa t'ets'ontézin daóotenilh hoh 'et neóotelts'ulh?” ");
INSERT INTO cafNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","'Et Sizi ndo búlhni, “Huwuhli dune nanwhanoo'ah gunih. ");
INSERT INTO cafNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Lhanah dune whusahútedulh 'ink'ez soozi bugha 'uhudutenilh, ‘Christ 'ust'ah!’ 'Et nduhútni hoh dune lhanah nahuntet'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","'Et nuhgha ha'nóojoot gunih. Nilhdukw dune lhutedughan whulh 'uhuduzts'ai, 'ink'ez nilhdza lhuhudughan whulh 'uhúduzts'ai t'eh, 'et ndoh honeh huba' hoont'ah. 'Et whunts'ih 'awhuz whulatah ilah ho' hoont'ah, 'awhuz 'udun chah whusawhútekulh ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lhelhts'un keyah whut'en, 'en lhch'a nihúdutedulh, 'ink'ez lhelhts'un hubudayi cho hinane'ut'en 'en chah lhch'a nihúdutedulh. Nduhóolhcho yun chah natughetnah, 'ink'ez dai chah whutéleh 'ink'ez nduhóolhcho hoh dune dzuh nulhuwhuteldeh. 'Et nduwhút'en suli t'eh, t'ewhuntéhzin 'o nus hooncha tune' whutet'en. 'Et dzuh nutehdeh k'an ho' whe'whudit'en. ");
INSERT INTO cafNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nuhwhenihch'oh chah huwahli. Keyah huwunli but nenóhwhutellelh 'ink'ez luglez koo 'et chah yanwhuts'utelht'oh. 'Et si sugha ndunnah moodih 'ink'ez hubudayi cho chah bubut ninhótellelh, khunek unzoo, 'i be hubulh yaoolhtuk ka. ");
INSERT INTO cafNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","'Ink'ez 'udechoo ndi yun k'ut ndulhcho dune ts'iyawh khunek unzoo, 'i bugha hubulh yatetuk. ");
INSERT INTO cafNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tsak'e nawhuhanla 'ink'ez naheyelh but nenóhnilhti t'eh, dája dutehnilh, 'aw huwu ni wahle gunih 'ink'ez nuhdzi dóoghel. 'Et nióoninzut t'eh, 'ants'ih ndai nuhza dánkat, 'i be yaoolhtuk, Ndoni bughunek 'i be yatelhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dune, 'en dulhutsinkah dahútetsah huwa butelelh. 'Et hube'abákah 'en chah, bubuzkeh 'en ndúbotelh'ilh, 'ink'ez 'uski, 'en chah, hube'ama 'ink'ez hube'abá, 'en hubuch'a nahútel'ah 'ink'ez dahóotsah hukwa' hubutelilh. ");
INSERT INTO cafNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Si sugha sunehdulh huwa ts'iyannah nuhts'uh dútetnik. 'Et whunts'ih ndan 'udek'elh'az whuts'un whechahítsaz, 'aw 'en zeh hudutejih.” ");
INSERT INTO cafNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ndan degha nus be whunjut, 'aw buba cha'hóot'ah 'et siyin nulh'en t'eh, (ndi yuk'é yalhtuk soo cho nuwheni taóodoolts'it. Daniel, Yak'usda be nus whúnilh'en, 'en 'uda húwu yailhtuk ínle). Judea hudelhts'i dzulhyaz k'uz ts'ih, whuz tsi hutoolhdelh. ");
INSERT INTO cafNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Dune bukoo hukw'ut usda t'eh, 'aw bukoo ts'ih nuchátesdal 'ink'ez ndai be'ildzun yutelelh, 'i 'aw nayóolchoot gunih! ");
INSERT INTO cafNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","'Ink'ez dune haníyeh k'et 'ut'en chah, 'aw bukoo ts'ih nayítsuz kunaóoda gunih. ");
INSERT INTO cafNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Dahoolcho 'i be whéwhunujut tele, hoh t'eh ts'ekoo, 'úlchan 'int'ah t'eh, 'ink'ez buzkeh yé'ulht'ukw chah. ");
INSERT INTO cafNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Njan dzuh nutehzut whuch'a ténadoohdli 'et khi 'uhoneh whuch'a. ");
INSERT INTO cafNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","'Et Yak'usda yun inla k'an dzin whuts'un 'aw cha'whúsne 'ink'ez 'aw 'et 'ulcho 'i be whutsuh da hiye dzuh nulháhulzut, 'i be dzuh natezut. ");
INSERT INTO cafNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","'Et whunts'ih neMoodihti lhat dzin hoh k'ah ná'hoonla. 'Et nduchaínil t'eh, 'aw 'ilhunuh whunts'ih doojih ghaít'ah. 'Et ndunnah 'utaháoobanla, 'en bugha' hoonla hoh t'eh hoondukw whutelhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","'Et hoh t'eh dune ndunóhowhutni t'eh, ‘Nulh'en njan Christ 'en njan usda!’ K'us, ‘Ngut usda!’ nuhuwhútni t'eh, khun teh nuhwhuba 'alha' 'uhudooni gunih. ");
INSERT INTO cafNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","'Et whunts'ih ndunnah Christ na'dudil'i, 'ink'ez nus whúnilh'en na'dudil'i chah, 'en lhanah hitele hoh lhat teh huwa ne'ut'en 'ink'ez hooncha túne' hutet'en, ndunnah Yak'usda 'utuhaóobanla, 'en whunts'ih nabunoo'a hukwa' hutet'ilh. ");
INSERT INTO cafNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","'Ahoolhyez tsi hóohli! Ts'iyaintsuk whutsuh da 'un whudáni. ");
INSERT INTO cafNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Et hukw'elh'az dune dzuh nuhuzde t'eh, sa 'i chah dulhgus tele, 'ink'ez 'ulh'ek ooza chah 'aw be chawhest'en tele. ");
INSERT INTO cafNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sum chah natekulh 'ink'ez nduk yaz be hóolhtus, 'i be notughetnah. ");
INSERT INTO cafNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Hoh t'eh yinkak dune ye', 'en ndoh kw'us tah bé wheóonujut ye ulhtus, 'i bulh 'ink'ez Yak'usda buts'u hayánduz, 'i be ndoh be wheóoduteltsilh. ");
INSERT INTO cafNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","'Ink'ez bulizas 'en haóobutelh'alh, ndus de, n'az de, niz de, 'ink'ez ndaz de, 'ink'ez ndi yun k'ut 'ink'ez yaz chah ndulhcho hoh Yak'usda ndunnah 'utaháoobanla 'en 'ilhohubutughélelh 'et wheni.” ");
INSERT INTO cafNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ndi mai, fig hiyulhni, buduchun, 'i be buk'unats'uwhulnuk be whuts'odul'eh, 'i soo ts'ah'un boodulhú'eh. Ndi 'i 'int'ah, buzooschum delghih t'eh, 'aw 'et but'an whulhlhih, 'i bugha t'eoonáhzun 'aw 'et shen nilhdukw suli. ");
INSERT INTO cafNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","'Et ndez na'a ndun whudúsni, ndet whusawhét'en whutélh'en t'eh, 'et sih whuz na'a zeh t'eoonóhzin 'aw 'et nilhdukw ho' whe'oodutet'ilh. ");
INSERT INTO cafNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","'Alha ts'ah'un na'a 'un whudusni, k'an ndoh whudezulh 'aw yachahútesdla, 'et njan ndó tenilh, ts'iyawh 'et lhawhúdutenilh, 'et whuts'un. ");
INSERT INTO cafNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yaz 'ink'ez ndi yun k'ut 'i chah hoolah whutele. 'Et whunts'ih ndi sughunek 'aw hoolah chatesdle.” ");
INSERT INTO cafNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Aw dune t'eoonízun ndet dzin k'us nts'oh huwa 'uhunet'oh 'et whusawhútelts'ulh. 'Aw lizas yak'uz hudelhts'i, 'ink'es Yak'usda buYe' whunts'i 'aw t'ehonízun, se'aBá dich'oh zeh t'eoonínzun. ");
INSERT INTO cafNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","'Ahoolhyez huwahli 'ink'ez tenadahdli. 'Aw nt'eoonuzáhzun nts'oh t'eh whusawhútelts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","'Et ndez na'a 'uwhutenilh, 'ilhunuh dune bukoo huwu tezya 'ink'ez hiba 'ut'en 'en 'et nibuninla 'ilho hinli hoh dude 'ut'en 'uhoolh'en ka, 'ink'ez 'et ndati huwunli ndi yúlhni, ‘Soo cho huwonle!’ ");
INSERT INTO cafNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","'Et whuz na'a nuhwhudúsni, huwahli! 'Et nts'oh teh bukoo humoodih whusanatedalh 'aw nt'eóonuzáhzun, hulhgha tulih, tuzniz tulih, yilhkaz tulih, k'us sa haí'ai t'eh tulih. ");
INSERT INTO cafNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","'Et huwa 'ahoolhyez lhadáht'ah. 'Aw hukwa tsi chawhahlih 'ink'ez nanehtez t'eh, nuhche tulih nuhwhumoodih nuhghun naooja. ");
INSERT INTO cafNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","'Et daja nuhwhudúsni, 'et ts'iyannah chah ndo budúsni, huwahli!” ");
INSERT INTO cafNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","'Awhuz nat dzin whuz'ai Lizwif Hubutus Lhuseya whewhúnahulnih 'ink'ez lhes chantulhúdoh, 'i ts'uyi, whewhúnahulnih chah, 'et náwhulnuk moodih 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz, Sizi whu'izyaz hikunúta hituzelhghelh ka. ");
INSERT INTO cafNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","'Et 'uhutni, “Njan butus lhuseya, 'et whutah ilah 'uts'ooleh, dune lhtahohót'alh 'et whuch'a.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","'Ilhunuh keyah wheyaz Bethany huwhútni, 'et Simon buka whulhjut ínle, leprosy hiyúlhni, bukoo 'en Sizi yuzih 'usda. 'Et na'ut'alh hoh ts'eke k'unuts'újul dezti, 'i tse be ídezbun, 'ink'ez 'i be buda' deldze ye'alh hoh danínya. Ndi 'i lhts'eyalhkut 'ink'ez k'unuts'újul 'i Sizi yutsi k'eyilhdze. ");
INSERT INTO cafNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bulunah dune hukwa hunílch'e 'ink'ez ndulhóhudutni, “Et di ka ndi k'unuts'újul 'ants'i 'et tinta' yulh'ih. ");
INSERT INTO cafNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Dezti hoh bé' ts'onket t'eh 'ink'ez da sooneya tehel'en hubugha ts'ínoodzaih,” hutni, 'ink'ez koo ts'ih ts'eke tube cho hich'a yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","'Et Sizi ndo búlhni, “Buts'áhachaoozah'ak! Di ka tedulhlih? 'Ut'en unzoo, 'i suba inla ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","'Ahoolhyez tehel'en nuhwhunat whutéle. Ndet hukwá' nahzun t'eh, hubula 'ooht'en. 'Et si 'ahoolhyez huba nuhwhúbulh cha'tuzest'il ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","K'unuts'újul, 'i suyust'e yuk'eyílhdze 'adutes'alh wheni lhasúdinla. Ndun ts'eke 'aw 'o 'un 'ooneh ghaít'ah, 'et 'uhóonla ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","'Alha' 'un whudusni, ndi yun k'ut ndulhcho hoh ndi khunek unzoo, 'i nudutekat, ndun ts'eke ndet 'uhoonla, 'et hukw'u naootetnuk, 'et hoh dune yunatelnih.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Lanezi 'o 'at nanah yugha hoodul'eh, 'ilhunuh Judas Iscariot hiyúlhni, 'en Lizwif bunáwhulnuk bumoodih buts'un whinya Sizi hubutl'aítelhtelh ka. ");
INSERT INTO cafNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dája ndo búlhni huhóont'i 'ink'ez sooneya hits'óozi. 'Et Judas, 'en Sizi ye 'óotekulh, 'et hukwa hités'en. ");
INSERT INTO cafNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","'Et 'udechoo dzin lhes chantíldoh, 'i nahíyut'alh, 'et dzin sheepyaz na'hitet'alh, 'i naihizulhghih, ndi sheepyaz Lizwif Hubutus Lhuséya huba 'int'ah. 'Et Sizi yugha hoodul'eh 'uhiyúlhni, “Nts'e netalh'alh ndi na'tant'ulh, 'i mba lházdutelilh?” ");
INSERT INTO cafNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","'Et Sizi nanah, 'en wheóobalh'a 'ink'ez ndo búlhni, “Jerusalem ts'ih ah'us 'ink'ez dune too nulhtun, 'en sih nuhdudóoya. Nts'e bukoo tezya whuz bun tooh'as, ");
INSERT INTO cafNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","'ink'ez bukoo be'ildzun njan dudoohtni, ‘Dune hoodulh'eh njan ndutni ndet sugha hoodul'eh bulh Hubutus Lhuséya huwa na'uztet'alh bukoo negho télh'alh ih?’ ");
INSERT INTO cafNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","'Et nduk hukw'uz hooncha lhaóodint'ah whunwhunoolhtun, 'et na'uztet'alh, 'i lhádoohleh.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","'Aw 'et yugha hoodul'eh Jerusalem ts'ih whehá'az 'ink'ez Sizi soo daja ndo búlhni, ts'iyawh whuz na'a nahuhóo'ai 'ink'ez Hubutus Lhuséya wheni lhahodinla. ");
INSERT INTO cafNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","'Et hulhgha 'aw 'et Sizi, ndunnah lanezi 'o 'at nanah bulh, 'en whusahándel. ");
INSERT INTO cafNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","'Et na'hut'alh hoh Sizi ndo búlhni, “Et njan ndun whudusni 'ilhunuh nuhtah sulh ná'ut'alh, 'en se'óotekulh.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","'Et yugha hoodul'eh hubudzi únduda hoh 'ilhunuh hinli hoh hiyoodulhkut, “Si ih 'usudíni,” hiyúlhni. 'Et 'uyoon chah ndutni, “Si ih 'usudíni?” ");
INSERT INTO cafNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","'Et Sizi ndo búlhni, “Et lanezi 'o 'at nanah njan netah ndan bules sulh toonayuz'ai, 'en 'utenilh. ");
INSERT INTO cafNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ndi Yak'usda bughunek 'uk'une'úzguz, 'i 'et ndutni, ‘Yinkak dune ye', 'en datetsah. 'Et ndun ye 'ónket, 'en dalcho 'i be buba wheóonujut tele.’ Ndun dune 'aw chahóolel t'eh, 'et da 'o nus soo' hot'e wule da.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","'Et na'hut'alh hoh Sizi lhes yílhchoot yuba tenadedli 'ink'ez taídalhkut. 'Et yugha hoodul'eh hubugha íninla 'ink'ez ndo búlhni, “Ndi ulhchoot, 'ink'ez ah'alh. Ndi suyust'e 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","'Et lubot yílhchoot, 'ink'ez be'aBá “Schanailya,” yúlhni. Hubutl'ayankai 'ink'ez ts'iyawh hiyetnai. ");
INSERT INTO cafNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","'Ink'ez ndo búlhni, “Ndi 'i suzkai 'int'ah. Lhanah huba nadútelt'ih 'ink'ez ndi k'andit khunek 'i suzkai be nuhts'u nahuzíya. ");
INSERT INTO cafNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","'Et 'alha' 'un whudusni, ndi mai too 'aw doo chah zeh naóosnai ghaít'ah. Ndet dzin ts'iyannah Yak'usda buk'úne' hutet'en 'et whuts'un, 'et ndet t'eh, ndi mai too k'an natesnai.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","'Et Yak'usda buyun be hújun 'ink'ez ndoh dzulhyaz k'uz Olive be hóodzi whuz whehandel. ");
INSERT INTO cafNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","'Ink'ez Sizi ndo búlhni, “K'an 'ulh'ek nuhwheni ts'iyawh sukayátehle, 'ink'ez si sugha tintuz telhúwus, ndi Yak'usda bughunek ndutni, ‘'Et huwa Yak'usda 'en sheep ghunli yutuzelhghelh 'ink'ez ndi sheep ts'iyawh lhtatelwus.’ ");
INSERT INTO cafNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","'Et dinadusja hukw'elh'az t'eh, 'et yun k'ut Galilee ts'ih nuhtsuh tesyalh.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter ndi yúlhni, “Ts'iyannah nkaya tele, 'et whunts'ih 'aw si ilah!” ");
INSERT INTO cafNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","'Et Sizi ndi yúlhni, “Peter, njan whunaoolnih, k'an 'ulh'ek ligok dune nat 'uduténilh whutsuh, tat 'et ‘T'esunuzínzun,’ dutanilh.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","'Et Peter soo khunek ulhtus, 'i be ndutni, “Nyulh datésah 'et whunts'ih 'aw t'enyunuzúszun doosni ghaít'ah.” 'Onghunnah yugha hoodul'eh chah ts'iyawh whuz na'a nduhútni. ");
INSERT INTO cafNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","'Et 'ilhunuh haníyeh k'et Gethsemane huwhútni ts'ih whehándel 'ink'ez Sizi yugha hoodul'eh ndo búlhni, “Njan delhúts'i. Si nye'un tenadutesdli.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","'Et Peter, James 'ink'ez John teh 'o 'un hubulh when'az. 'Aw 'et buyust'e 'i be tso be teni'nelhts'it 'i buk'edilts'ut, ");
INSERT INTO cafNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","'ink'ez ndo búlhni, “Suzul tube tso suli, 'aw 'et datesah 'et suts'un whelts'ulh ho' hoont'ah. Njan delhúts'i 'ink'ez howohle.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","'Et 'o 'unyaz nenínya 'ink'ez nachanétno. 'Et tenadedli hoh ndutni, njan huba whusawhutelts'ulh, 'et whuz na'a senghoholts'it t'eh 'et ndoh honeh. ");
INSERT INTO cafNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","'Ink'ez ndi yúlhni, “Abba, 'aBá, nyun zeh ts'iyaintsuk nk'úne' whut'en. Ndi be dzuh nuteszut suba hoolah nahoolhtsi, 'et whunts'ih si hukwa' nuszun ilah, nyun hukwa' ninzun hukw'u na'a 'et ndoh honeh.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","'Et ndunnah tanah yugha hoodul'eh nahunéstez hoh bughu nanja 'ink'ez Peter 'uyúlhni, “Simon nanenti hoh ih 'unint'ah? 'Aw ih 'astl'iyaz whunts'i honih ghaít'ah?” ");
INSERT INTO cafNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","'Ink'ez ndo búlhni, “Howahli tink'us nteht'uk whuch'a tenadoohdli. Nuhyéghah be tehzoo hukwa' nahzun, 'et whunts'ih nuhyust'e latet'ah ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","'Et doo chah 'o 'un whenaja 'ink'ez whutsuh da tenadedli whuz na'a zeh tenadedli. ");
INSERT INTO cafNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Doo chah zeh yugha hoodul'eh, 'en nahunéstez hoh bughu nanja 'aw huhoonih ghaít'ah 'ink'ez 'aw whé' hidooni hooyah. ");
INSERT INTO cafNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Whulh tat bughu nanja 'et ndo búlhni, “Whute sahtez 'ink'ez nalhúyis. 'Aw 'et whusawhélts'ut, soo cho whunulh'en, yinkak dune ye', 'en dune ntsi' butl'ahítelhtelh. ");
INSERT INTO cafNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Dinadahdelh! 'Uztoodelh! Nulh'en ndun dune se'óotekulh, 'aw 'et nyoh hiyalh.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","'Et 'awhuz Sizi yalhtuk hoh Judas 'en whusaínya. Ndun Judas 'en lanezi 'o 'at nanah whel'a 'en, 'ilhunuh 'int'ah. Dzuh sa inle Lizwif náwhulnuk bumoodih, Moses be' dustl'us 'uk'ununa'úsduguz, 'ink'ez dune tsuh whudelhdzulh chah, 'uda buts'un nuséya, 'ink'ez Sizi ye búts'e'onket. 'En Judas buts'un whenáhiyalh'a, 'ink'ez dune lhanah yulh údulh soh cho chah 'ink'ez tuz chah hiyellelh hoh whusahándel. ");
INSERT INTO cafNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Hédulh hoh Judas ndo búlhni, “Ilhunuh dune bunenk'us k'ut nadests'ooz, 'en wahgooh 'ink'ez bugha 'óohli hoh tóolhte!” ");
INSERT INTO cafNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","'Et huwa Judas Sizi yughu ninya ibulh ndi yulhni, “Dahooja, Rabbi,” 'ink'ez naindunants'ooz. ");
INSERT INTO cafNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","'Aw 'et Sizi hiyílhchoot 'ink'ez duts'o cho hiyoontun. ");
INSERT INTO cafNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","'Et whunts'ih 'ilhunuh Sizi zih siyin soh cho hayálhtsus 'ink'ez Lizwif náwhulnuk degha nus dezti be 'ulhna, 'en yudzo k'uz habe'yalht'o. ");
INSERT INTO cafNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","'Et Sizi ndo búlhni, “Et di ka soh cho 'ink'ez tuz chah nahle 'ink'ez 'undunust'ih hukw'u na'a skaootéhdel? ");
INSERT INTO cafNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Dzin totsuk nuhwhubulh 'úst'ah 'ink'ez luglez whucho whunwhudulh'eh, 'et di ka hoh da chasulhchulh inle. 'Et whunts'ih Yak'usda bughunek dája ni whuz na'a 'uhóneh huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","'Et ts'iyawh yugha hoodul'eh hich'a sudel 'ink'ez tinta hulghaz. ");
INSERT INTO cafNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","'Ilhunuh chilh naih ts'ut'on, 'i zeh khaíwesdúduz, 'en Sizi yuneyalh. Ndun chilh 'en 'uyoon chilhkah hiyoolhchoot. ");
INSERT INTO cafNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","'Ust'et whelgai hoh naih zeh hubula k'éyano. ");
INSERT INTO cafNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","'Et Sizi hiyílhchoot 'ink'ez Lizwif náwhulnuk degha nus dezti bukoo ts'ih whehíyalhti. 'Et Lizwif náwhulnuk bumoodih, dune tsuh whudelhdzulh, Moses be' dustl'us 'uk'ununa'úsduguz chah 'ilhuhowezdel. ");
INSERT INTO cafNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter ye niz de hubuneyalh. Lizwif náwhulnuk degha nus dezti bukoo 'et whuna'nesdutl'oo, whuz bughu danínya. 'Et howuhinli buzih natl'adeda 'ink'ez na'dunildzilh. ");
INSERT INTO cafNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Lizwif náwhulnuk bumoodih 'ink'ez naheyilh chah 'en hibut Sizi nihínilhti hituzelhghelh hukwa highu nahó'alh hukwa' hut'en, dune yuch'a yaoolhtuk nahóolhtelh hukwa' hut'en, 'et whunts'ih 'aw 'ilhunuh nachahilhtel. ");
INSERT INTO cafNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Lhanah dune huwhuts'it hoh hich'a yaílhtuk, 'et whunts'ih ts'iyawh lhelhts'un na'a 'uhutni. ");
INSERT INTO cafNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bulunah dune dihudíndel 'ink'ez Sizi hiba whuts'it hoh njan nduhútni, ");
INSERT INTO cafNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Njan ndutni hoh nenalh 'útni, ‘Njan luglez whucho dune 'uhóonla, 'et nanaóoduntesyus. 'Et hukw'elh'az tat dzin inle t'eh, 'aw dune bula be nacha'hoolil hoh 'udun na'whutesdlilh.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","'Et whunts'ih 'aw ts'ah'un lhgha 'úhudooni ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","'Et Lizwif bunáwhulnuk degha nus dezti hubutah didinya 'ink'ez Sizi 'uyúlhni, “Ndunnah dune nch'a yahúlhtuk daja dutenilh?” ");
INSERT INTO cafNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","'Et whunts'ih Sizi t'edusnih 'ink'ez 'aw yachatílhtih. 'Et doo chah náwhulnuk yoodulhkut, “Nyun ih Christ 'int'ah? Yak'usda dezti buYe' inli ih?” ");
INSERT INTO cafNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sizi 'et ndi yúlhni, “A, 'en 'ust'ah, 'ink'ez nuhwheni ts'iyawh yinkak dune ye', hiyuntelh'ilh Yak'usda bugha nalhnih ts'ih sida hoh ndus de kw'us tah hanátedalh.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","'Et ndun náwhulnuk tube hunílch'e k'et dunaih lhts'e yalhch'ul 'ink'ez njan ndutni, “Aw 'o 'un 'uyoon ts'oodolhkut ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ndi bughunek Yak'usda yech'a yaílhduk, 'i dahts'o! Nuhwhuba dáhoont'ah?” 'Et ts'iyawh 'úhutni, “Daóotsah huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","'Et bulunah highá whenduninzoh, hina ka'dalh'oo 'ink'ez hiyoonukat cha' hiyulh'en 'ink'ez, “Ndan nyunézkuk?” hiyúlhni. 'Et ndunnah dune ghunli hiyílhchoot 'ink'ez 'en chah hiyoonankat. ");
INSERT INTO cafNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","'Et Peter 'onghoh nanestl'oo bet 'ut'en hoh Lizwif bunáwhulnuk degha nus dezti ts'ekeyaz yuba 'ut'en 'ut'en, 'en wheghah úyalh. ");
INSERT INTO cafNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Peter na'dunildzilh yutelh'en 'ink'ez ndi yúlhni, “Nyun chah Sizi Nazareth whut'en bulh 'ínt'en inle.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","'Et Peter 'utni, “Aw t'éoonuzúszun ndet 'uwhudini,” 'ink'ez 'az whenya. Soo 'aw 'et lígok dune 'udéja. ");
INSERT INTO cafNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","'Et ts'ekeyaz njan 'et ya'en ndunnah hoh nuhudelhúya chah 'et ndo búlhni, “Ndunnah 'en chah 'ilhunuh 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","'Et whunts'ih Peter doo chah, “Awundooh!” ni. 'Et 'astl'iyaz inle ndunnah hoh nahudelhúya, 'en chah Peter 'et ndi híyulhni, “Alha nyun chah 'ilhunuh 'unint'ah. Nyun chah Galilee hoont'en 'unint'ah, whuz na'a yailhtuk 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","'Et Peter 'utni, “Ndukni bunalh, 'alha' dusni ho' dusni, ndun dune 'udáhni, 'aw nt'enuzuszun!” ");
INSERT INTO cafNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","'Et ligok dune whulh nat 'udeja. 'Et Peter Sizi dája yulhni whunalnik, “Ligok dune nat 'uduténilh whutsuh, 'et tat t'esunuzínzun dutenilh.” 'Et huwun ni ninzut 'ink'ez intse. ");
INSERT INTO cafNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","'Et bundada 'uda Lizwif náwhulnuk moodih, dune tsuh whudelhdzulh, Moses be' dustl'us 'uk'ununa'úsduguz, 'ink'ez dune ba naheyilh chah, ts'iyawh yahalhtuk. 'Et Sizi hiyulhghel 'ink'ez Pilate tl'ahíyalhti. ");
INSERT INTO cafNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","'Et Pilate ndi yúlhni, “Nyun ih Lizwif hubudayi cho inli?” 'Et Sizi 'utni, “Alha' dini ho' dini.” ");
INSERT INTO cafNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Lizwif náwhulnuk moodih lhat Sizi hich'a yalhtuk, 'ink'ez hiba honts'it, 'et whunts'ih Sizi t'edusnih. ");
INSERT INTO cafNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","'Et Pilate doo chah Sizi yoodulhkut, “Daóoneltsuk nk'ehuhóo'ai, 'et hubugha 'aw ih dája chadutuzanil?” ");
INSERT INTO cafNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","'Et doo chah Sizi 'aw yachatílhtih. 'Et Pilate buba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Naoodezulh totsuk Lizwif butus lhuséya whunahulnih, 'et 'ilhunuh dune tsak'esda Lizwif 'utahahíyulhtih, 'en Pilate yula nadutnih. ");
INSERT INTO cafNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","'Et hoh da ndunnah lhtahuwhunt'ai da dune lhutughan ts'iyawh tsak'ebahanla. Barabbas 'en chah hubutah tsak'esda dune selhghi hukwa. ");
INSERT INTO cafNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ts'iyannah 'ilhuhowezdel 'ink'ez Pilate 'uhiyúlhni, “Nawhudezulh totsuk 'ilhunuh dune tsak'esda 'en bulanadantnik. Doo chah 'et ndoneh.” ");
INSERT INTO cafNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","'Et ndo búlhni, “Lizwif hubudayi cho, 'en ih bulanadutesnih hukwa' nahzun?” ");
INSERT INTO cafNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Dich'oh soo t'eoonínzun Lizwif náwhulnuk bumoodih 'oonih bugha Sizi hitl'ahíyalhti 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","'Et whunts'ih Lizwif náwhulnuk bumoodih dune huba nus hódelhti, Barabbas 'en Pilate yulanadootnih hidóoni ka. ");
INSERT INTO cafNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","'Et Pilate doo chah dune 'ilhuhowezdel ndo búlhni, “Ndun Lizwif hubudayi cho dáhni datésdlilh hukwa' nahzun?” ");
INSERT INTO cafNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","'Et tube cho 'uhiyúlhni, “Lhdulalhgus yundunilht'ah!” ");
INSERT INTO cafNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","'Et Pilate ndo búlhni, “Ndet hoh tink'us 'úja?” 'Et whunts'ih 'o nus 'uhutni, “Lhdulalhgus yundunilht'ah!” hutni. ");
INSERT INTO cafNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","'Et 'ilhuhowezdel 'en huhót'i ka Barabbas 'en Pilate huba yulanadetnik. 'Et Sizi yahiyalhtsus, 'ink'ez lhdulalhgus k'ehíyoolhtelh ka butl'ayálhti. ");
INSERT INTO cafNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","'Et nehughan moodih bukoo whuna'nesdutl'oo, 'i tuz ts'ih Sizi dahínilhti 'ink'ez 'onghoh nehughan ts'iyawh buka' hudáni. ");
INSERT INTO cafNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Naiyits'uz dulk'un, 'i Sizi higha híwezduz. Whus nahínelhwut, 'i hitsi nihída'ai. ");
INSERT INTO cafNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","'Et hidélhti lahoohóolh'i, 'ink'ez 'uhiyúlhni, “Lizwif hubudayi cho sa cho khona.” ");
INSERT INTO cafNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Duchun be hitsi ts'e' nalht'o, highá dizoh, hibut dugwútsi be nihúdulh, 'ink'ez hibut nachánuldulh cha' hiyulh'en. ");
INSERT INTO cafNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sizi highu núwhulhya 'ustl'e' 'uhiyínla hukw'elh'az nayits'uz dulk'un, 'i highu nahiyilchoot, 'ink'ez dich'oh bunaih be nahíyalhti. 'Aw 'et lhdulalhgus k'ehítelhtelh ts'ih hítelhti. ");
INSERT INTO cafNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","'Et hedulh hoh 'ilhunuh dune, Simon hiyúlhni, Jerusalem ts'ih tezya. 'En hidudezdel 'ink'ez Sizi bulhdulalhgus yuba idutetilh ka, 'et nihínenyoot, ndun Simon, 'en Cyrene whut'en, 'en Alexander 'ink'ez Rufus 'en hube'abá 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","'Et Sizi Golgotha huwhútni ts'ih lhgha hídilhti. Ndi Golgotha 'utsints'un nez'ai hutni ho' hutni. ");
INSERT INTO cafNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","'Et mai too 'ink'ez yoo, myrrh hiyúlhni, hitaídenla, 'i Sizi hiyíhiyoolhnai hukwa' hiyínla, 'et whunts'ih 'aw chaitítnil. ");
INSERT INTO cafNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","'Et lhdulalhgus k'ehúyilhti 'ink'ez bunaih 'i higha 'aínlih hoh lhtahiyulya. ");
INSERT INTO cafNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bundada 9:00 'uhunet'oh bat'en Sizi lhdulalhgus k'ehíyilhti. ");
INSERT INTO cafNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ndet hukwa' hiyínla hutni, 'et 'uk'e'hanguz, 'i higha ndoh huwuhidi'ai. Ndi khunek hík'e'anguz, 'i ndutni, ");
INSERT INTO cafNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nanah 'uhundunut'ih chah hiyulh lhdulalhgus k'ébuhilhti, 'ilhunuh bugha naílhni ts'ih 'ink'ez 'ilhunuh bughe 'intl'as ts'ih. ");
INSERT INTO cafNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","'Uda Yak'usda bughunek 'uk'une'úsduguz, 'i whuz na'a 'uhóoja ndutni hoh, “Dune ntsi' dult'ah huninzun.” ");
INSERT INTO cafNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dune whúghha hoh nahúdelh nohóndunul'us 'ink'ez Sizi highudloh, “Lhoonk'a'! Nyun lah 'udini, ‘Luglez whucho yanawhutduntanyus 'ink'ez tat dzin na'whutanlilh,’ dini? ");
INSERT INTO cafNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","K'an 'ahoh nanaíndaih, 'ink'ez 'ududílyih,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Whuz na'a Lizwif náwhulnuk bumoodih 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz, 'en chah, Sizi highudloh 'ink'ez njan ndulhódutni, “Uyoon úlhyis, 'et whunts'ih dich'oh k'an 'ududoolyih ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","K'an Christ, Lizwif hubudayi cho ts'unoolh'en nanaóoja, 'et neba 'alha' 'oot'e.” 'Et ndunnah nanah hizih lhdulalhgus k'ut sulhti, 'en chah highudloh. ");
INSERT INTO cafNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dzetniz 'et 'o 'un 3:00 bat'en 'uhúnet'oh keyah nduhoolhcho hoh tsahólhgus whuzdli. ");
INSERT INTO cafNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Whulh skwunlai 'o 'at dit (9) hukw'e' hunit'o, 'et Sizi soo tube cho haínzul, bughunek k'una'a 'utni, “Eloi, Eloi, lama sabachthani,” “SuYak'usda, suYak'usda, di ka suladantnik?” ni hoh 'utni. ");
INSERT INTO cafNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","'Et bulunah dune 'et nahudelhúya hoh hídants'o, 'ink'ez 'uhutni, “Nulh'en! Ndun Elijah yuka hahuyih.” ");
INSERT INTO cafNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","'Ilhunuh whusálgai, 'ink'ez duchun bulá'del'oo, 'i mai too dunink'ooz, 'i ye tóonayuzsi, 'ink'ez nduk Sizi yuza bé' yunantan, 'ink'ez 'utni, “Kw'azi'ez! Elijah tusih whusatéyalh 'ink'ez lhdulalhgus k'ut nanaítelhtelh.” ");
INSERT INTO cafNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","'Et Sizi tube cho haínzul 'ink'ez dek'elh'az hanáji. ");
INSERT INTO cafNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lizwif hubuluglez whucho njan dadelhchooz, 'i bugha nduk 'ink'ez butl'az ts'ih lhts'ench'ul. ");
INSERT INTO cafNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nehughan moodih lhdulalhgus yubut siyin. Sizi nts'e na'a haínzul 'ink'ez dazsai 'et yunalh'en. “Ndun dune 'alha hoh Yak'usda buYe' unli,” ni. ");
INSERT INTO cafNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ts'ekoo chah 'et nudelhúya yoo 'az de ts'un honilh'en. Butah Mary Magdala whut'en, 'ink'ez Mary Jamesyaz, 'ink'ez Joses bulh be'ama, 'ink'ez Salome chah. ");
INSERT INTO cafNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","'En Sizi Galilee 'et 'ut'en hoh hiyununézdel 'ink'ez hila 'ét'en. 'Uyoon ts'ekoo lhanah chah 'et 'uhut'en. 'En Jerusalem ts'ih hahínandel. ");
INSERT INTO cafNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","'Aw 'et hulhgha ts'ótezut hoh Joseph, 'en Arimathea whut'en whusaínya. 'En nahéyelh tah boozi unzoo 'int'ah. 'En, Yak'usda buk'úne' whut'en, 'et hukwa ités'en. 'Et dzin nats'ulyis dzin huba lhahúdutneh 'úhoont'ah. Joseph soo budzi ulhtus 'udulhútsi hoh Pilate yubut ninínya, 'ink'ez Sizi buyust'e yuts'un ka' dani. ");
INSERT INTO cafNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","'Et Pilate buba hooncha Sizi 'uda dazsai. Nehughan moodih, 'en yuka' dani 'ink'ez ndi yúlhni, “Sizi 'uda tulih dazsai?” ");
INSERT INTO cafNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","'Et hukw'elh'az nehughan moodih, “Alha' dazsai,” ni. 'Et Pilate, 'en Joseph 'uyúlhni, “Sizi buyust'e nailchoot.” ");
INSERT INTO cafNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph naih dezti, 'i yonket, 'ink'ez buyust'e nanáyalhti, 'ink'ez ndi naih dezti, 'i yughá iwezduz. 'Et tse 'an whuz wheyíyalhti, 'ink'ez tse cho whudunaíndunelhmul. ");
INSERT INTO cafNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdala whut'en, 'ink'ez Mary, 'en Joses be'ama bulh 'en bunalh, Sizi 'et nihínilhti. ");
INSERT INTO cafNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Lizwif nahulyis dzin hukw'elh'az hulhgha ts'ih Mary Magdala Whut'en, 'ink'ez Salome, 'ink'ez Mary James be'ama chah, yoo sooltsun, 'i hiyónket, Sizi buyust'e hiye hítelho huba. ");
INSERT INTO cafNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bundada 'uda hukw'enilhghel 'et 'udechoo dzin, 'et sa haín'ai hoh, ts'un k'uz hutezdel. ");
INSERT INTO cafNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Whuz hedulh hoh 'ulhódutni, “Tse cho ts'un k'ut whudándune'ai, 'i ndan simba neba 'udun nindunoolhmelh?” ");
INSERT INTO cafNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tse 'uda 'udun nindunelmul hoh hotelh'en. Tse tube ndunincha. ");
INSERT INTO cafNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","'Et tse 'an 'uhandel hoh chilh lheyul, 'i be dune unli, 'en naílhnih ts'ih 'usda hoh hitelh'en. 'Et hubugha tube huba hooncha hoh hunelhújoot. ");
INSERT INTO cafNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","'Et ndo búlhni, “Nulhújut ilah! T'eoonúszun Sizi Nazareth whut'en, lhdulalhgus k'ehíyilhti, 'en bukunáhta hoh 'aht'en. 'Aw hoolah! Dinadija ho' 'int'ah! Njan whunulh'en ilhte 'et. ");
INSERT INTO cafNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","'Aw 'et nahdulh, Peter 'ink'ez 'onghunnah Sizi yugha hoodul'eh, 'en ndo hubudóohni, Sizi dája nuwhúlhni da, nuhtsuh Galilee ts'ih téyalh 'et sih wah'en.” ");
INSERT INTO cafNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","'Aw 'et tse 'an tínahalghaz 'ink'ez nahutelhúghaz tube hubughá ha'nejoot 'ink'ez 'aw dune nduchahudinil, hunelhújoot 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","'Et Sizi dinadija hukw'elh'az, Lizwif nahulyis dzin bundada 'uda 'et Sizi 'udechoo Mary Magdala whut'en, 'en choo yunalhts'et hainya. 'En skwunlai 'o 'at nankoh (7) ntsi' nudúdeh, 'i ye yáhanainanyoot ínle. ");
INSERT INTO cafNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sizi yulh 'út'en inle hík'enudle, 'ink'ez hutso hoh hubughu ninya 'ink'ez ndo budáni, ");
INSERT INTO cafNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sizi khuna hoh ya'en, 'et whunts'ih 'aw huba 'alha' cha'dusnih. ");
INSERT INTO cafNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","'Et hukw'elh'az Sizi 'uts'un na'a be hóodet'en, nanah 'uts'un keyah ts'ih he'us hoh hubunalhts'et hainya. ");
INSERT INTO cafNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hoh wheha'az, 'onghunnah hubulh náwhuhulnuk 'aw huba 'alha' cha'hudusnih. ");
INSERT INTO cafNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","'Et hukw'elh'az Sizi yugha hoodul'eh lanezi 'o 'at 'ilhunuh (11) na'hut'alh hoh hubunalhts'et hainya. 'Et 'aw be 'alha' hoont'ah, 'i chahít'ih 'ink'ez 'uts'un 'uhuninzun. 'Et huwa ndunnah hiya'en 'aw huba 'alha' cha'hudusnih, 'et Sizi hukwa' hubudáni, ");
INSERT INTO cafNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","'ink'ez ndo búlhni, “Yinkak ndulhcho hoh náhdelh, 'ink'ez khunek unzoo, 'i ts'iyawh yinkak dune wheóobunulhtun. ");
INSERT INTO cafNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ndan huba 'alha' hoont'ah, 'ink'ez too be 'úlya t'eh, 'en dutejih. Ndan huba 'alha' cha'hoot'ah, 'en hoontsi' hukw'u na'a huba ne'whutet'ilh. ");
INSERT INTO cafNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ndunnah huba 'alha' 'ust'ah, 'en be úlhtus hubugha ootés'alh. Si soozi bugha ntsi' nududeh, 'i dune ts'uh hanáhiyunteyulh. K'an khunek 'i cha be yahutelhtuk. ");
INSERT INTO cafNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tl'ughus ntsi' hiyílhchoot, k'us poison hétnai t'eh, 'et whunts'ih 'aw dachahutesnil. 'Ink'ez hunduda butsi k'ehudilnih, 'en chah soo ná'hutetnilh.” ");
INSERT INTO cafNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","'Et hukw'elh'az 'et Sizi neMoodihti dune hubulh yálhtuk 'ustl'e' 'udéja hoh, 'et yak'uz whenája 'ink'ez Yak'usda bugha nálhnih ts'ih nátl'adeda. ");
INSERT INTO cafNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yugha hoodul'eh 'en ndulhcho nahúdelh, 'ink'ez ndi khunek unzoo 'i be dune bulh yahúlhtuk. 'Et neMoodihti hubulh 'út'en 'ink'ez be úlhtus, 'i hubutl'aida'ai, 'et huwa bughunek be yahulhtuk, 'alha' hutni ho' hutni. 'Et ndoh honeh.");
INSERT INTO cafNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lhanah 'uda hoolhtus hoh hét'en ndi be nawhutnuk ts'ah'un na'a 'uhidáni, 'i ts'iyawh hik'e'anguz. 'Et hik'e'anguz whutsuh, 'i ts'iyawh ndi whenich'oh netah neba 'alha' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Soo 'udechoo whe' whudit'en 'et dich'oh hubuna be honalh'en 'ink'ez Yak'usda bughunek be ne'hút'en huzdli, 'en ndi khunek netl'ahídanla, 'i 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","'Et Theophilus nyun dune uncha inli. 'Ink'ez si chah ndi 'uk'une'tésguz hoh 'ust'ah. 'Udechoo whe' whudit'en whuts'un nts'e na'a dahooja 'ink'ez ndet 'uwhulhni, 'et ts'iyawh soo ts'ah'un na'a t'eoonúszun 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","'Et ndet 'onghun whunyohodalh'i, 'et tink'us na'a 'uhoont'ah k'us ts'ah'un na'a 'uhoont'ah, 'et ts'ah'un na'a t'ewhuntanzeh. ");
INSERT INTO cafNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","'Et hoh da Herod 'en Judea yun k'ut hubudayi cho inle, 'et da 'ilhunuh náwhulnuk, 'en Zacharias hiyulhni, 'en Abijah bulh dédowh 'int'ah. Bu'at Elizabeth hiyulhni, 'en Aaron yé dinzut 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","'En nahult'ah Yak'usda nalh ts'ah'un dune 'uhint'ah. Ndet Yak'usda bughunek huba yutulhuhézya 'ink'ez ndet hubuts'u hukwa' ninzun hik'une' tet'en ka, 'et ts'iyawh hukw'ú ne'hut'en. 'Aw hoonliyaz hukwa hubuk'eho'alh gháit'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","'Et whunts'ih Elizabeth 'aw buyaz hole ghaít'ah tube ye'un hezulh 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","'Aw 'et Zacharias bulh 'ínt'ah k'una'a hoh Yak'usda nalh náwhulnuk be 'ut'en k'ah huwaghúna, ");
INSERT INTO cafNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","nts'e na'a 'ilhuk'i hinli hoh náwhulnuk k'una'a né'hutelelh, 'et whuz na'a Zacharias, 'en chah nawhulnuk 'utahayálhti yoo sooltsun dutélhk'un ka. 'Et neMoodihti hubuluglez whucho ts'ih danínya. ");
INSERT INTO cafNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","'Et yoo sooltsun yudelhk'un hoh 'et nduwhulyez lhanah 'az ts'ih tenahududli. ");
INSERT INTO cafNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","'Et Yak'usda bukw'uzdai k'ut yoo sooltsun delhk'un, 'et nalhnih ts'ih, 'et lizas be hoodiltsai. ");
INSERT INTO cafNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacharias khun yutelh'en 'i be bugha 'uts'un 'úja 'ink'ez whenelhújoot. ");
INSERT INTO cafNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","'Et lizas ndi yúlhni, “Zacharias wheniljut ilah. Yak'usda ntenadudli yudánts'o. N'at Elizabeth, 'en dune buyaz yaz tele, 'ink'ez boozi John be beootanzi. ");
INSERT INTO cafNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","'En bugha dawhulcho be hootant'i 'ink'ez whuntélhnik. 'Ink'ez whuzdli t'eh, lhanah chah hohontélhnik. ");
INSERT INTO cafNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","'Alha neMoodihti bunalh dune uncha tele. Mai too k'us too ulhtus, 'i chah chaitesnil. Whutele whutsuh 'et whunts'ih Ndoni be dutebun. ");
INSERT INTO cafNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","'Ink'ez Israel hits'uh hainzut, 'en lhanah neMoodihti buYak'usda ts'ih hubutelelh. ");
INSERT INTO cafNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","'Et nus whunilh'en Elijah hiyulhni, 'en k'una'a 'et whuz na'a Ndoni ye ulhtus, 'i be neMoodihti yutsuh teyalh. Ndez na'a njan ndotet'ilh, lhanah hubuzkehkah hube'abákah hubudzi hubuts'un tezoo dutebun nabutelhtsilh. Ndan 'uk'unucha'ust'en, 'en lhanah ts'ah'un 'int'ah ye whunih hitélhchulh. 'Ink'ez dune, 'en lhanah neMoodihti buts'un teyalh, 'et wheni lhábudutelilh,” lizas ndi yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","'Et Zacharias ndun lizas yoodulhkut, “Nts'e na'a t'ewhunteszeh? Nilh'en duneti 'ust'ah 'ink'ez su'at 'en chah ye 'un uzulh ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","'Et lizas ndi yúlhni, “Si Gabriel 'ust'ah. Yak'usda zih siyin 'ust'ah. Nts'un sutélh'a nyulh yatelhtuk ka. Ndi khunek unzoo, 'i nyudutésnilh wheni. ");
INSERT INTO cafNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Soo zélhts'ai! Sughunek daja dusni, soo 'et néwhults'ut t'eh, 'et ts'iyawh 'et ndótenilh. 'Et whunts'ih daja dusni 'aw mba 'alha' cha'hoot'ah. 'Et ndet dzin 'uwhutenilh whuts'un, 'aw yachatuzalhtuk!” yulhni. ");
INSERT INTO cafNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","'Ink'ez dune, 'en ts'iyawh Zacharias hika tsi hooli, 'ink'ez daja hoh simba 'int'ah, sa luglez whucho ts'ih 'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tinanja hoh 'aw hubulh yaóolhtuk ghaít'ah. 'Ink'ez t'ehoninzun hoonliyaz beghah hawhelts'ut ho' 'int'ah. 'Ink'ez 'ants'ih huba núlhni hoh hubulh yalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","'Et hukw'elh'az ne'úle 'ustl'e' 'uhooja hoh, 'aw 'et bukoo ts'ih whenája. ");
INSERT INTO cafNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","'Et hukw'elh'az bu'at Elizabeth buyaz 'ucháinya hoh skwunlai sanun 'et nduwhulyez 'et whu'iz inda. 'Et njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Et whuz na'a azeh neMoodihti sulh 'ut'en. Hoh da dzin sunalnih inle hoh ndet hukwaya usdli, ts'iyawh sch'ah hanáhonla.” ");
INSERT INTO cafNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","'Aw 'et bulh lhk'utat sanun hoh Yak'usda ndun lizas Gabriel hiyulhni, 'en keyah Nazareth ts'ih wheyalh'a. Njan keyah 'et yun k'ut Galilee whuz'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Whuz ts'ih 'ilhunuh ts'eke 'aw dune yut'achaghesnak unli, 'en ts'un whel'a. 'Ilhunuh dune, Joseph hiyúlhni, 'et David hits'uh hainde, 'en 'ilhunuh 'int'ah. 'En yughu tedalh yuts'un lhaoodinla. 'Et ndun ts'eke 'aw dune yut'achaghesnak, 'en Mary hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Lizas yuts'uh whusainya 'ink'ez 'et ndi yulhni, “Whunélhnik! Yak'usda nts'un unzoo! Nemoodihti nyulh 'int'ah 'et huwa ts'ekoo tah degha nus hoont'i inli!” ");
INSERT INTO cafNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","'Et yutelh'en hoh 'et tube bugha ha'nejoot. 'Ink'ez 'et howun nuni nuzut bughunek daja ni ho' 'utni. ");
INSERT INTO cafNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","'Ink'ez lizas 'en ndi yúlhni, “Mary niljut ilah! Yak'usda nyulh hoont'i. ");
INSERT INTO cafNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Dája 'uski ba' tenilh. Duneyaz nyaz tele. 'En Sizi dutanilh. ");
INSERT INTO cafNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","'En ncha tele. 'En 'uhidutenilh soo 'uk'enus 'en buYe' tele. 'Ink'ez Yak'usda neMoodihti David butsuh whudelhdzulh, ndet hukw'inda, 'et yutl'aóote'alh. ");
INSERT INTO cafNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","'Et whuz na'a Jacob hits'uh hainde 'ilhuz wheni huba hubudayi cho tele. 'Ink'ez njan hubudayi cho tele, 'aw whulatah whutélah.” ");
INSERT INTO cafNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","'Et Mary, 'en lizas 'uyúlhni, “Nts'e na'a 'uwhutenilh, 'aw dune t'enuzuszun hoh 'ust'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","'Et lizas yulh yalhtuk, “Ndoni nk'edinde 'ink'ez degha nus 'en ye ulhtus, 'i nk'ut sakwhusts'it be whútele. 'Et huwa ndi 'uyust'e lubeshi bughoh hoolah, 'i whuzdli t'eh, 'en Yak'usda buYe' hidutenilh. ");
INSERT INTO cafNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","K'an 'aw 'et nyunat Elizabeth ye'un uzulh, 'en whunts'ih duneyaz buchainya. Ndun 'aw buzkeh hole ghaít'ah hiyulhni, 'et whunts'ih 'en 'aw 'et whulh lhk'utak'i sanun be suli. ");
INSERT INTO cafNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","'Alha 'i be Yak'usda 'en 'aw hoonliyaz buba hoolhtus hoolah.” ");
INSERT INTO cafNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","'Et Mary ndi yúlhni, “Daja, si neMoodihti be 'ulhna 'ust'ah! Nts'e na'a nghunek k'una'a daootenilh dini, whuz na'a sulh 'úhoneh.” 'Et lizas yugho whenája. ");
INSERT INTO cafNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","'Et hukw'elh'az Mary lhadúja. 'Et yun k'ut nódest'ai whuz Judea yun k'ut 'ilhun keyah whuz'ai, 'ahoh whuz whinya. ");
INSERT INTO cafNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacharias bukoo daninya 'ink'ez Elizabeth dahooja yulhni. ");
INSERT INTO cafNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","'Et Elizabeth, en Mary daja ni yuduzts'ai ibulh 'uski buchan ts'ih télhah. 'Ink'ez 'ahoh Ndoni be dezbun. ");
INSERT INTO cafNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elizabeth soo tube cho ndi yúlhni “Ts'ekoo tah degha nus hoonzoo nyulh 'uhooja. 'Ink'ez nyaz whutéleh, 'en dawhuldzoo nghá whults'ut! ");
INSERT INTO cafNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nts'e na'a hoh sugha whults'ut sMoodihti 'ama 'en sughu ninya. ");
INSERT INTO cafNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","'Alha, dahooja 'usudini hoh nyuduzíts'ai ibulh, 'uski schan ts'ih hoont'i k'et núllhah. ");
INSERT INTO cafNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ndun ts'eke buba 'alha' hoont'ah, 'en degha nus hoonzoo bugha whults'ut. Nts'e na'a neMoodihti daja yulhni, buba 'alha' hoont'ah, 'et huwa hoh teh buba ne'whutet'en.” ");
INSERT INTO cafNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","'Et Mary njan ndutni, “Suzul, 'i be neMoodihti ye uncha yudélhti. ");
INSERT INTO cafNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","'Ink'ez Yak'usda súlh yih. 'En be suyéghah whuneílhnik. ");
INSERT INTO cafNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","'Alha ndun be 'ulhna, nts'e na'a yuh 'ududildzun, 'et t'ewhuninzun. 'Et whunulh'en, k'an whuts'un, nus de chah, 'ilhuz wheni ndi yun k'ut ts'iyannah soo degha nus hoonzoo bulh 'úhooja soo 'uduténilh. ");
INSERT INTO cafNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","'Alha ndun hooncha hoh tune' sulh'en, 'en be óonujut 'int'ah 'ink'ez boozi, 'i degha nus dezti. ");
INSERT INTO cafNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ndi yun k'ut hudedowh, 'ink'ez 'o 'un hubundunedoh, ndunnah 'en k'una'a hidóolhti, 'ink'ez ndan hiyé nuljut, 'en ts'iyawh hubugha te'ninzun. ");
INSERT INTO cafNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dugan bunut'uk 'i be hoolhtus tune' 'ut'en. Ndunnah budzi be 'ududelhúti, 'en ts'iyawh yabanla. ");
INSERT INTO cafNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ndunnah dune ncha hukw'adálts'i, 'et 'en nanábanla. 'Et ndunnah te'dadildzun, 'en hincha hubulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ndunnah buye'últs'ilh, 'en unzoo 'i be hubudelhbun. 'Ink'ez ndunnah soode'a, 'en 'aw hoonliyaz bughá chai'al hoh whenábalh'a. ");
INSERT INTO cafNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Be 'ustl'en Israel, 'en hubugha te'ninzun, 'et whunalnih hoh hubula 'uja. ");
INSERT INTO cafNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","'Et whuz na'a netsuh dune hanle hubulh yailhtuk hoh Abraham 'ink'ez yuts'u hainde, 'en 'ilhuz wheni 'uhint'ah, 'et whuz na'a hubudáni.” ");
INSERT INTO cafNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","'Et Mary tat sanun bat'en hoh Elizabeth yuzih inda. 'Et hukw'elh'az bukoo ts'ih whenaja. ");
INSERT INTO cafNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","'Aw 'et Elizabeth buyaz whutele 'et níoodelhdzut 'ink'ez buye' whúzdli. ");
INSERT INTO cafNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","'Et highah delhts'i 'ink'ez hinat hudélhts'ikah whulh 'úhuduzts'ai nts'e na'a neMoodihti yugha te'nanzin. 'Ink'ez ts'iyawh hiyulh whunélhnik. ");
INSERT INTO cafNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","'Aw 'et whulh lhk'udink'it dzin hoh 'uski 'en yuka dune unli, 'i k'ut hitet'us. 'Ink'ez bu'abá boozi Zacharias 'i be hiyootézilh. ");
INSERT INTO cafNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","'Et whunts'ih bu'ama, “Awundooh! Ndi boozi John 'i be hiyootézilh,” ndo búlhni. ");
INSERT INTO cafNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","'Et hiyúlhni, “Aw nyulh dunekah hubutah 'aw John boozi 'i hoolah!” ");
INSERT INTO cafNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","'Et bu'abá ndi boozi higha idúte'alh 'et t'ehontezeh hukwa' huninzun. 'Et dula be hiba núlhnih whuz na'a hiyoodulhkut. ");
INSERT INTO cafNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dula be núlhnih hoh dustl'us hubuts'u ka' dani, 'ink'ez 'uk'une'uzguz, “Boozi John hidutenilh.” 'Ink'ez ts'iyawh huba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","'Et khunyaz yanawhéniltuk hoh Yak'usda dálhti. ");
INSERT INTO cafNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yunat whut'en, 'en ts'iyawh nujut hubughu nídelts'ut. 'Ink'ez Judea yun k'ut nodest'ai ndulhcho 'et whut'en, 'en ts'iyawh howu yahalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","'Et ndunnah whulh uzduzts'ai, ts'iyawh hubudzi be hódanla 'ink'ez 'ulhódutni, “Ndan 'uski dant'ah simba wule?” hutni. 'Ink'ez neMoodihti bula be yula 'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","'Aw 'et be'abá Zacharias, Ndoni be dezbun 'ink'ez nus whunilh'en hoh ndutni, ");
INSERT INTO cafNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israel buYak'usda 'ink'ez neMoodihti, 'en dalzoo! Budune, 'en buts'un nusiya nabootekulh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","David 'en Yak'usda be 'ustl'en, 'en yuts'u hainde, 'en hubugha neulhyis hooncha, 'en neba yulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","'Uda whe' whudit'en whuts'un, 'et whuz na'a Yak'usda be nus whunilh'en, 'en hube yailhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","'Et hoh nech'a yalhtuk 'ink'ez ndunnah nets'u detni, 'en ts'iyawh hubula k'éhaoodelts'ut, 'et neulhyis. ");
INSERT INTO cafNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ne'abákah 'en Yak'usda hubugha te'ninzun. 'Ink'ez ndi khunek huba lhaídinla, 'i 'et yunalnih. ");
INSERT INTO cafNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Netsuh whudelhdzulh Abraham nts'e na'a Yak'usda bughunek yutl'aída'ai hoh 'ink'ez yuts'un náhezya, njan 'et wheni neba' whutelilh ka, ");
INSERT INTO cafNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","'et hoh nech'a hudetni, 'en hubula k'ehaoodelts'ut, 'et hoh neulhyis. 'Ink'ez 'aw whechats'uniljut hoh Yak'usda ba' uztet'ilh. ");
INSERT INTO cafNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Lubeshi cha'ulh'en uztele 'ink'ez ts'ah'un na'a uztet'ilh, 'et whuz na'a Yak'usda bunalh dzin totsuk ts'ukhuna hoh 'en ba' ts'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","'Ink'ez nyun 'uskiyaz 'en ndun degha nus dedo, 'en ba nus whunilh'en nyuhudutenilh. NeMoodihti 'en ti hoonzoo buba whutelhtsilh ka butsuh tanyalh 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","'Ink'ez wheni budune soo cho t'ets'onózin dahoont'ah hoh uzdutejih 'ink'ez nelubeshi chah neba hoolah yutelhtsilh, 'et hubugha nedutenilh. ");
INSERT INTO cafNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","'Et whutsuh neYak'usda nek'entsi' hoh negha te'nanzin. 'Et ndun sa yilhkaz ts'utni, 'en ndus de whuts'un nets'ún k'unadaih. ");
INSERT INTO cafNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ndunnah tsahólhgus yuh hudélhts'i 'ink'ez datsah huba 'int'ah chah, 'en ts'iyawh hubuk'eiduténolh. 'Ink'ez lhuteyalh hoh nedzi soo 'uhot'e, 'et nts'e wheho'a, 'et newhuntelhtun. 'Et huwa Yak'usda be nus whunilh'en nyudutenilh,” ni Zacharias. ");
INSERT INTO cafNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","'Et ndun 'uski John, 'en nezyi 'ink'ez buyégha ulhtus suli. 'Ink'ez nket'ah Israel budune hubunalh haooya dunábunteltun ka, 'et whuts'un nts'e dune chahóot'ih ts'ih inda. ");
INSERT INTO cafNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","'Et da 'ilhunuh dune Caesar Augustus hiyulhni, 'en nduhoolhcho keyah hudelhts'i, 'en ndi khunek yutah lhuhezya. Ts'iyannah boozi 'i ts'iyawh hik'e'tegus ka. ");
INSERT INTO cafNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","'Et hoh da whudezulh whutah, 'ilhunuh dune Cyrenius hiyulhni, 'en whuyun k'ut Syria whumoodih inle. 'Et wheghah whudezulh 'et whuts'un huboozi 'uk'e'whehininguz. ");
INSERT INTO cafNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","'Et ts'iyannah dich'oh dukeyah whuz whehandel huboozi k'éhutegus ka. ");
INSERT INTO cafNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","'Et Joseph 'en yun k'ut Galilee 'ink'ez keyah Nazareth, 'et whehúdin'az 'ink'ez David bukeyah, Bethlehem huwhutni, whuz wheha'az Joseph, 'en David yuts'uh hainzut 'int'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ndun Mary yughu tedalh hoh yuts'un nahezya, 'en njan Mary 'uski ba 'int'ah hoh yulh when'az huboozi k'é'hutegus ka. ");
INSERT INTO cafNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","'Aw 'et huzke hoh buyaz whutéleh 'et neoodenzut. ");
INSERT INTO cafNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","'Aw 'et 'udechoo buyaz whuzdli. 'Et ndi layin naih yugha iwézduz 'ink'ez musdus yez 'uyi, 'i be yalhti. 'Aw ts'uztez bakoo nachahuhóo'al, ts'iyawh whudézbun 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","'Ilhunuh yun k'ut dzuh nilhdzayaz, 'et sheep ghuhinli tl'o k'ut 'et huwhut'i, 'ink'ez 'ulh'ek nduwhulyez hoh hubughunai ghuhinli. ");
INSERT INTO cafNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","'Ink'ez nilh'en, 'aw 'et neMoodihti bulizas hububut siyin. 'Ink'ez neMoodihti buts'uh hayanduz, 'i ndulhcho hoh hubunat bube dendi. 'Ink'ez 'aw 'et tube hoh hunelhújoot. ");
INSERT INTO cafNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","'Et lizas ndo búlhni, “Whenoolhujut gunih! Nulh'en ndi khunek unzoo 'i soo ts'iyannah dune ye hóotet'i, 'i nuhwhuts'u té'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","K'an dzin David bukeyah, nuhwhutelhyis nuhwhuba whuzdli. 'En Christ neMoodihti ts'utni, 'en 'uja. ");
INSERT INTO cafNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ndez na'a hoh t'ewhuntehzeh ka nuhwhuba hoh hoodel'en nts'e na'a dahooja, lhe'ínt'ah layin bugha iwésduduz 'ink'ez musdus yez 'uyi, 'i bet usti.” ");
INSERT INTO cafNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Khunyaz lizas 'ink'ez lhanah lizas nehughan, 'en ndus de hahandel. 'Et Yak'usda 'o nus hiba hodélhti hoh nduhútni, ");
INSERT INTO cafNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Yak'usda degha ndoh yak'ut, 'en uzdelhti. 'Ink'ez ndi yun k'ut nedzi dooghel, 'i be ts'iyannah dune hubuts'un hoonzoo hole!” ");
INSERT INTO cafNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","'Aw 'et ndunnah lizas yak'uz ts'ih hubugho whenáhedel. Ndunnah Sheep ghuhinli ndulhodutni, “Aw 'et Bethlehem ts'ih ts'utoodelh. 'Ink'ez nts'e na'a dahooja 'et neMoodihti nedani, 'et ts'onoolh'en!” ");
INSERT INTO cafNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","'Et 'a tsih ndaz de hedulh. 'Et Mary 'ink'ez Joseph 'ink'ez 'uski musdus yez 'uyi bet usti hoh hubughu hunindel. ");
INSERT INTO cafNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hiya'en hukw'elh'az, nts'e na'a 'uski bugha lizas 'en hubudáni, 'et whunat ts'iyannah t'ehonandzin hoh ");
INSERT INTO cafNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ndunnah yudants'o sheep ghunli daja hubulhni, 'en ts'iyawh huba hooncha suli. ");
INSERT INTO cafNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","'Et Mary dahooja, budzi be yodanla 'ink'ez 'ahoolhyez howu nuni nuzut. ");
INSERT INTO cafNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","'Aw 'et ndunnah sheep ghuhinli 'en sheep ts'un whenahedel. 'Et ndet hodants'o, 'ink'ez honalh'en, 'ink'ez nts'e na'a hubulh yahalhtuk chah, 'et hubugha Yak'usda hidélhti 'ink'ez 'o nus hoonzoo k'una'a highu yalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Whulh lhk'udit dzin lhaóodija hoh 'uski yuka dune unli 'i lhk'uhinint'az, 'ink'ez hiyoozi be hiyootézilh, Sizi hiyulhni. 'Awhuz 'ucha dinda hoh 'et ndi boozi, 'i lizas yugha íde'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","'Et Moses be' dustl'us k'ut daja ni hoh ts'ekoo buyaz whulhih hukw'élh'az soo ná'hut'ih 'et luglez danáhudaih, 'et ndúwhulcho hoh Mary lhaóodinla. 'Ink'ez 'uski Jerusalem ts'ih whehíyalhti neMoodihti bunalh hahítelhtelh 'et hukwa. ");
INSERT INTO cafNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","NeMoodihti, 'en Moses bugha ndi bughunek butl'aida'ai, 'i whuz na'a 'uk'e'hanguz 'et njan ndutni, “Ndunnah duneyaz 'udechoo whuzdli, 'en ts'iyawh neMoodihti ba 'udun nelti hinli ho' hint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","'Ink'ez ndai Yak'usda bukw'uzdai k'ut hidutélhk'un, “I nankoh dut'aiyaz, dove hiyulhni, k'us nankoh dut'aiyaz, 'i dih hiyulhni.” NeMoodihti, en Moses bugha ndi bughunek butl'aida'ai, 'et whuz na'a 'utni. ");
INSERT INTO cafNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","'Et 'ilhunuh dune Simeon ts'utni, Jerusalem whut'i. Ts'ah'un na'a 'int'ah 'ink'ez 'ahoolhyez Yak'usda be 'ut'en k'ah 'uwhulh'en. Ndun Israel budune k'enábunte'ah, 'en yuka tsi hóolih. 'Ink'ez Ndoni chah yulh 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ndoni 'en whut'einalhdzin, datetsah whutsuh neMoodihti buChrist ts'utni, 'en yute'ilh. ");
INSERT INTO cafNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","'Et Ndoni bugha luglez whucho daninya. 'Ink'ez 'uskiyaz Sizi, 'en be'abá 'ink'ez be'ama, 'en hik'uz dahinilhti. Moses bughunek 'uk'une'usdúguz butl'aida'ai, ndet hubuts'un hukwa' ninzun, 'et hukw'u ne'hutet'en ka. ");
INSERT INTO cafNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","'Et 'ahoh Simeon yilhchoot 'ink'ez njan ndutni hoh Yak'usda yudélhti, ");
INSERT INTO cafNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“SMoodihti si nye 'ulhna usdli. 'Ink'ez nts'e na'a nghunek k'una'a, 'et 'uhoont'ah sudzi dezghel hoh daóosah. ");
INSERT INTO cafNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","'Alha be suna be netelhyis nulh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ts'iyannah dune hubunalh lhaoodinla. ");
INSERT INTO cafNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","'Udun yun k'ut whut'en, 'en chah huba be whét'en, 'i 'int'ah. 'En be hite'ilh. 'Ink'ez nyudune, 'en Israel budune, 'en chah huba idézti 'en 'int'ah,” ni. ");
INSERT INTO cafNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nts'e na'a yughu yatelhtuk 'et huwa Joseph 'ink'ez 'uski 'ama bulh huba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","'Et Simeon Yak'usda ts'un hukwa' dani hubuts'un wuzoo ka. 'Ink'ez 'ama Mary 'en ndi yulhni, “Ndet huba ndun 'uski Yak'usda 'en huba 'utahayálhti 'int'ah, 'et nyudutésnilh. Israel hits'uh hainde, 'en bugha lhanah natekulh 'ink'ez lhanah dinadutédulh. 'Ink'ez highu t'eooninzun 'et whunts'ih hich'a yatelhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","'Ink'ez nyunch'oh nzul soh cho be huyuzgwut li'tenilh. 'Ink'ez lhanah hubudzi be daja huninzun, 'et ts'iyawh ts'iyannah nalh ts'et haootelts'ulh.” ");
INSERT INTO cafNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","'Aw 'et 'ilhunuh ts'eketi, Anna hiyulhni, Yak'usda be nus whunilh'en. Phanuel butse', 'ink'ez Asher hubulh dédowh, 'ilhunuh 'int'ah. Tube ye 'un uzulh. 'Udechoo ki tet'ilh whutsuh, 'aw dune t'enizun 'int'ah. Skwúnlat 'o 'at nat naoodezulh duki zih inda. ");
INSERT INTO cafNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ndun tsandelh, 'en lhk'udit lanezi 'o 'at dit be naoodezulh bat'en (84). 'Et 'aw luglez whucho whuch'a chaíyal. 'Et whunts'ih lhat hoh dzenis 'ink'ez 'ulh'ek ibulh sahá'dulyih 'ink'ez tenadudli, 'i be Yak'usda ba ne'ut'en unli. ");
INSERT INTO cafNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","'Et ndun ndoh whudézulh hoh daninya 'ink'ez Yak'usda yudélhti. Jerusalem hudelhts'i, ndun nabootekulh, 'en hika ítes'en, 'et 'en bugha Anna hubudáni. ");
INSERT INTO cafNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","'Aw 'et Joseph 'ink'ez Mary, neMoodihti, 'en Moses bugha ndi bughunek hubutl'aida'ai, 'et ts'iyaintsuk lhahuduja hoh yun k'ut Galilee 'ink'ez hubukeyah Nazareth ts'un whenahedel. ");
INSERT INTO cafNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","'Et 'uski 'aw 'et nuyeh 'ink'ez buyégha be ulhtus súli. Ye whunih be dezbun 'ink'ez Yak'usda ye unzoo, 'i bulh 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","'Aw 'et be'abá, be'ama bulh naoodezulh totsuk Jerusalem ts'ih k'unáhut'us. Na'hutet'alh hoh Hubutus Lhusiya whunahutelnih, 'et hukwa whuz whehándel. ");
INSERT INTO cafNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hoh da ndunnah 'uski 'en lanezi 'o 'at nat be naoodezulh (12) 'et Jerusalem ts'ih k'unáhudulh, butus lhusiya da hukw'un'a 'et huwa 'uhut'en. ");
INSERT INTO cafNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nkeda 'ustl'e' hooja hoh k'ah nahutest'az. 'Et whunts'ih 'awhuz 'uski Sizi Jerusalem 'aw 'et usda. Joseph, 'ink'ez be'ama bulh 'aw t'ehonízun. ");
INSERT INTO cafNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","'Uyoon bulh 'ut'en huninzun. 'Ilhudzin bat'en huní'az 'et k'an zeh hika ités'en. 'Et bulh dunekah 'ink'ez bulhutsinkah 'en hubutah hikunúta. ");
INSERT INTO cafNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","'Et 'aw nachahuyílhtel 'et doo chah Jerusalem ts'ih whenáhet'az, 'ink'ez 'et hikunúta. ");
INSERT INTO cafNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tat dzin hukw'elh'az 'et k'an zeh nahuyilhti. Luglez whucho 'et whubodulh'eh hubutah usda. Huboozélhts'ai 'ink'ez huboodulhkut. ");
INSERT INTO cafNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ndan hidits'o tube huba hooncha suli. Ts'iyaintsuk t'ewhunínzun 'ink'ez ts'iyawh ts'ah'un na'a ndó bulhni. ");
INSERT INTO cafNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Be'ama 'ink'ez Joseph bulh ndet 'ut'en 'et usda hinilh'en hoh huba hooncha. 'Et be'ama 'uyúlhni, “Uyaz di ka whuz na'a nene'ilh'en? Nyu'abá 'ink'ez si bulh tube nk'enedutai.” ");
INSERT INTO cafNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","'Et ndo búlhni, “Di ka sukunahta? 'Aw nt'echaoonuzúhzun se'aBá be 'ut'en k'ah huwa óosna huba' hoont'ah?” ");
INSERT INTO cafNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","'Et daja ni hoh 'utni, 'et 'aw t'echahonízun. ");
INSERT INTO cafNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","'En hubulh whenát'az. Nazareth ts'ih whenahédel 'ink'ez hubutl'a'dudelti. 'Et be'ama ndi ndet 'uwhulhni, budzi yídanla. ");
INSERT INTO cafNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","'Ink'ez Sizi 'o nus whunih chah 'ulheh hoh nus lhaneyelh. Yak'usda yuba hoont'i, 'ink'ez dune, 'en chah hiba hoont'i. ");
INSERT INTO cafNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","'Aw 'et Caesar Tiberius, 'en yun k'ut ndulhcho hoh hubudayi cho inle. Lanezi 'o 'at skwunlai naoodezulh (15) ant'e. 'Et Pontius Pilate, 'en Judea yun k'ut whumoodih unli. Herod, 'en Galilee yun k'ut whumoodih unli. Bulhutsin Philip, 'en Iturea 'ink'ez Trachonitis yun k'ut whumoodih unli. 'Ink'ez Lysanius, 'en Abilene yun k'ut whumoodih unli. ");
INSERT INTO cafNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas 'ink'ez Caiaphas, 'en nawhulnuk degha nus dézti 'uhint'ah. 'Et whughah whudézulh whutah 'et John, 'en Zacharias buye', 'en dune chahóot'ih ts'ih usda hoh Yak'usda bughunek buk'édilts'ut. ");
INSERT INTO cafNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","'Et Jordan koh 'et whunat nuya hoh dune hubulh yalhtuk too be' hooneh ka hukwa. 'Et whebunulhtun dulubeshi ch'a bubeni náhubudunoolelh ka. 'Et hoh lubeshi buba hoolah yutelhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","'Et whuz na'a Isaiah bughunek 'uk'e'eduguz 'et njan ndutni, “Dune chahóot'ih ts'ih dune yiz dusduts'ai, 'et 'ultus hahuyih hoh njan ndutni, ‘NeMoodihti buti lhaoodahleh! Buti soo lhk'e oodez'a buba whulhtsi! ");
INSERT INTO cafNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Too k'oh totsuk naoodutebun. Dzulh 'ink'ez dzulhyaz bulh ts'iyawh lhgha yuk na'tetnilh. Whudélyah 'et chah lhk'enaoodutedukih. Yun nudest'ai 'i chah lhgha na'whutétnilh. ");
INSERT INTO cafNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","'Ink'ez nts'e na'a Yak'usda dune ulhyis, 'et ts'iyannah hontelh'ilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dune lhanah yughu nindel too be' hutenilh hukwa' huninzun. 'Et ndo búlhni, “Nuhwheni poison tl'ughus buzkehkah li'aht'ah. Yak'usda lubeshi 'ulh'en hubulh húntelch'oh 'et whuz de whélts'ulh, ndan 'un whúlhni whuch'a lhúwus? ");
INSERT INTO cafNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nuhwhulubeshi ch'a nuwheni náhundunehla t'eh, nuhwhe 'ut'en be ts'iyannah whebunoolhtun nuhwhulubeshi buladehtnik. 'Ink'ez khun lhts'un njan dudoohtni gunih wheni Abraham hits'uh hats'ánde 'uts'int'ah. 'Alha ts'ah'un na'a 'un whudusni, Yak'usda soo 'ultus ho' 'int'ah, ndi tse 'i whunts'ih 'i be Abraham buts'uh hahánde hubutelhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Njan soo cho whunulh'en, nuhwheni duchun lí'aht'ah. 'Aw 'et tsetsilh ba lhadínt'ah. 'Et nuhwheni bulunah duchun bumai hoolah, 'et ndaht'ah. K'an whunts'ih ndai bumai hoolah, 'i tsetsilh be bughih tubulh tahídantsel 'ink'ez hidutélhk'un.” ");
INSERT INTO cafNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","'Ink'ez dune ts'iyawh hiyoodulhkut, “Ink'ez nts'e na'a simba dats'óoneh.” ");
INSERT INTO cafNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","'Et ndo búlhni, “Ndan dzoozt'an nankoh 'ut'i, ndan dzoozt'an chait'ih, 'en 'ilhuk'i yugha óolhchoos. 'Ink'ez ndan ts'uyi 'ut'i, 'en chah whuz na'a zeh ndóneh.” ");
INSERT INTO cafNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ndunnah sooneya 'ilhunanowes'aih, 'en chah too be' hutenilh ka hits'uh whusaindel 'et hiyoodulhkut, “Whuneodulh'eh nts'e na'a daztenilh?” ");
INSERT INTO cafNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","'Et ndo búlhni, “Ndet ndanéltsuk hutni télhcholh huba' hoont'ah, 'et 'aw 'o 'un chawhuzóolhchoot.” ");
INSERT INTO cafNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nehughan, 'en chah hiyoodulhkut, “Nuwheni do daztenilh.” 'Et ndo búlhni, “Khun nuhwheni dune sooneya nuhgha hóo'alh huboolhtsilh gunih! Khun dune whuts'it be buk'éhoh'alh gunih! 'Ink'ez ndet daneltsuk nuhwhuba k'elha whútele, 'aw 'et hóht'i huba' hoont'ah!” ");
INSERT INTO cafNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ts'iyannah hoonliyaz hukwa tsi huholi. 'Et budzi be dahoont'ah simba John 'en bugha, ndun Christ ts'utni, 'en tulih 'int'ah k'us 'awundooh. ");
INSERT INTO cafNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John ts'iyawh 'et ndo búlhni, “Too zeh 'i be too bé' nuhwhulh'en. 'Et whunts'ih sk'elh'az whusateyalh, 'en sughanus dezti ho' 'int'ah. 'Aw buke tl'oolh buba lhk'unadutes'uk 'et whunts'ih huba soo cha'ust'ah. Ndun 'en Ndoni 'ink'ez kwun bulh 'i be too be' 'un whutelilh. ");
INSERT INTO cafNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Be tl'o nuldzeh tl'o mai be tahawhúlts'it, 'i lhaídilhdzun. 'Ink'ez ndi tl'o mai yuk'ut tahawhúlhts'it, 'i chah yuk'ut lhadút'ih t'eh, 'ink'ez yuna'ulhdoh. 'Ink'ez ndi mai lhaduja, 'i ts'iyawh denúdzih 'ink'ez mai bakoo ts'ih wheyúlih. 'Et whunts'ih ndi kwun 'aw nachanusneh, ndi but'ooz 'i be duték'un,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ndi Khunek 'ink'ez 'uyoo khunek 'i bulh 'et whuz na'a khunek ulhtus, 'i be hubudáni. ");
INSERT INTO cafNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","'Aw 'et ndi yun k'ut whumoodih Herod, 'en 'ilhunuh 'int'ah. 'En dulhutsin Philip bu'at 'en yuzih usda. John 'uyúlhni, “Lubeshi 'ilh'en.” 'Udun tink'us na'a chah 'ut'en. 'Et chah ts'iyawh lubeshi 'uhoont'ah yulhni. ");
INSERT INTO cafNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","'Et ndi lubeshi 'uyulh'en, 'i 'uyoo chah yuts'u na'whuleh hoh John 'en tsak'eya'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","'Aw 'et ts'iyannah dune too be 'úlya. Sizi 'en chah too be 'uyínla. Tenawhéndunidli 'i bulh yat'ah dá'dutezkez, ");
INSERT INTO cafNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","'ink'ez Ndoni dut'aiyaz, dove hiyulhni, 'i k'una'a ndus de hát'o 'ink'ez yuk'eít'o. 'Et nduk yak'uz khunek huduzts'ai, 'i ndutni, “Nyun suYe' nk'esi' 'unint'ah. Tube nyulh hoonúst'i.” ");
INSERT INTO cafNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","'Et Sizi tat lanezi naoodezut bat'en suli (30), 'aw 'et whe'dít'en. Ts'iyannah 'en Joseph buye' huninzun. 'Ink'ez 'en Heli buye'. ");
INSERT INTO cafNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","'En Matthat yuts'uh hainzut, 'en Levi yuts'uh hainzut, 'en Melchi yuts'uh hainzut, 'en Janna yuts'uh hainzut, 'en Joseph yuts'uh hainzut. ");
INSERT INTO cafNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","'En Mattathiah yuts'uh hainzut 'en Amos yuts'uh hainzut, 'en Nahum yuts'uh hainzut, 'en Esdli yuts'uh hainzut, 'en Naggai yuts'uh hainzut. ");
INSERT INTO cafNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","'En Maath yuts'uh hainzut, 'en Mattathiah yuts'uh hainzut, 'en Semei yuts'uh hainzut, 'en Joseph yuts'uh hainzut, 'en Judah yuts'uh hainzut. ");
INSERT INTO cafNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","'En Joannas yuts'uh hainzut, 'en Rhesa yuts'uh hainzut, 'en Zerubbabel yuts'uh hainzut, 'en Shealtiel yuts'uh hainzut, 'en Neri yuts'uh hainzut. ");
INSERT INTO cafNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","'En Melchi yuts'uh hainzut, 'en Addi yuts'uh hainzut, 'en Cosam yuts'uh hainzut, 'en Elmodam yuts'uh hainzut, 'en Er yuts'uh hainzut. ");
INSERT INTO cafNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","'En Jose yuts'uh hainzut, 'en Eliezer yuts'uh hainzut, 'en Jorim yuts'uh hainzut, 'en Matthat yuts'uh hainzut, 'en Levi yuts'uh hainzut, ");
INSERT INTO cafNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","'En Simeon yuts'uh hainzut, 'en Judah yuts'uh hainzut, 'en Joseph yuts'uh hainzut, 'en Jonan yuts'uh hainzut, 'en Eliakim yuts'uh hainzut, ");
INSERT INTO cafNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","'En Melea yuts'uh hainzut, 'en Menan yuts'uh hainzut, 'en Mattatha yuts'uh hainzut, 'en Nathan yuts'uh hainzut, 'en David yuts'uh hainzut, ");
INSERT INTO cafNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","'En Jesse yuts'uh hainzut, 'en Obed yuts'uh hainzut, 'en Boaz yuts'uh hainzut, 'en Salmon yuts'uh hainzut, 'en Nahshon yuts'uh hainzut, ");
INSERT INTO cafNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","'En Amminadab yuts'uh hainzut, 'en Ram yuts'uh hainzut, 'en Hezron, yuts'uh hainzut, 'en Pharez yuts'uh hainzut, 'en Judah yuts'uh hainzut, ");
INSERT INTO cafNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","'En Jacob yuts'uh hainzut, 'en Isaac yuts'uh hainzut, 'en Abraham yuts'uh hainzut, 'en Terah yuts'uh hainzut, 'en Nahor yuts'uh hainzut, ");
INSERT INTO cafNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","'En Serug, yuts'uh hainzut, 'en Reu yuts'uh hainzut, 'en Peleg yuts'uh hainzut, 'en Eber yuts'uh hainzut, 'en Salah yuts'uh hainzut, ");
INSERT INTO cafNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","'En Cainan yuts'uh hainzut, 'en Arphaxad yuts'uh hainzut, 'en Sem yuts'uh hainzut, 'en Noah yuts'uh hainzut, 'en Lamech yuts'uh hainzut, ");
INSERT INTO cafNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","'En Methuselah yuts'uh hainzut, 'en Enoch yuts'uh hainzut, 'en Jared yuts'uh hainzut, 'en Mahalaleel yuts'uh hainzut, 'en Cainan yuts'uh hainzut, ");
INSERT INTO cafNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","'En Enos yuts'uh hainzut, 'en Seth yuts'uh hainzut, 'en Adam yuts'uh hainzut, 'ink'ez 'en Yak'usda yuts'uh hainzut. ");
INSERT INTO cafNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","'Et Sizi, en Ndoni be dezbun hoh Jordan koh ts'ih hanája. 'Ink'ez dune chahóot'ih ts'ih Ndoni whuz wheyalh'a. ");
INSERT INTO cafNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","'Et whulh dit lanezi (40) dzin 'et dzin totsuk netsudule tink'us ooneh hukwa' yulh'en 'et yoolhdzih. 'Et nduwhulyez hoh 'aw hoonli chas'al. 'Et lhaóodinla hukw'elh'az buye'élts'ul. ");
INSERT INTO cafNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","'Et netsudule 'uyúlhni, “Alha Yak'usda buYe' inli t'eh, ndi tse lhes wule dini.” ");
INSERT INTO cafNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","'Et Sizi njan ndi yúlhni, “Ndez na'a Yak'usda bughunek k'ut 'uk'une'úsduguz 'et njan ndutni, ‘'Aw lhes zeh ilah dune yuk'ekhuna. 'Et ndai Yak'usda bughunek 'i ts'iyawh dune yuk'ekhuna.” ");
INSERT INTO cafNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","'Et netsudule nyedoh dzulh k'ut yulh whin'az. 'Et 'ahoh yun k'ut nts'oh tula dune whut'i, 'ink'ez hubudayi cho bube 'ut'en k'ah, 'et nduwhulcho wheínulhtun. ");
INSERT INTO cafNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Netsudule 'uyúlhni, “Et nyun ndi ts'iyawh humoodih tanle, 'ink'ez hiye dezti 'et chah ngha ootés'alh. Njan sugha whulya. 'Et huwa ndan hubuka', nuszun, 'en hubutl'aootes'alh. ");
INSERT INTO cafNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","'Et ngwutsi be nininya 'ink'ez sts'u téni' nilhdzun t'eh, 'et sih ndi ts'iyawh nye'ílhdzun wule.” ");
INSERT INTO cafNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","'Et Sizi ndi yulhni, “Satan st'ak inyalh! 'Et 'uk'e'éduguz hoh njan ndutni, ‘Moodihti nYak'usda 'aw 'en zeh bubut negwutsi be nits'eyih, 'ink'ez 'en zeh buts'uh teni' uznilhdzun. 'Ink'ez 'en zeh ba nets'ut'en.” ");
INSERT INTO cafNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","'Et Jerusalem ts'ih yulh whin'az 'ink'ez njan luglez whucho yedoh hukw'ut 'et soo hukw'abah ninílhya 'ink'ez ndi yúlhni, “Alha Yak'usda buYe' inli t'eh, 'et njan whegha' dudintneh! ");
INSERT INTO cafNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","'Alha 'et 'uk'e'éduguz hoh njan ndutni, ‘Yak'usda bulizas ngho hoole ka 'ink'ez nyuhotun 'ink'ez wheni hubutl'ahó'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bula be nyedoh nyuhóotetun, 'et huwa 'aw nke be tse t'aoonalh ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","'Ink'ez Sizi ndi yúlhni, “Njan 'et 'uk'e'uduguz hoh njan nduwhutni, ‘Khun teh Moodihti nYak'usda 'en nantá'ah hukwa ólhdzih gunih.” ");
INSERT INTO cafNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","'Et netsudule ts'iyaintsuk hoh tink'us ooneh hukwa yóolhdzai, 'aw 'et lhaooduja hoh 'astl'iyaz whuts'un yugha whenája. ");
INSERT INTO cafNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","'Et Sizi, en Ndoni ye ulhtus, 'i be yun k'ut Galilee ts'ih whenaja. 'Ink'ez yughu yalhtuk Galilee yun k'ut hudelhts'i ndulhcho hiyulh údants'o, 'ink'ez ts'iyawh highu yalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","'Et ts'iyawh Lizwif luglez totsuk whéoobondunilh'i 'ink'ez ts'iyannah hidélhti. ");
INSERT INTO cafNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","'Et ndet keyah nezyi Nazareth huwhutni, whuz whinya. 'Et dzin dune nalyis dzin 'uhoont'ah, 'et Lizwif hubuluglez whuz ninya. 'Et whuz na'a dich'oh be 'ut'en k'ah 'uhoont'ah. 'Ink'ez buba 'uk'eyatelhtuk ka didinya. ");
INSERT INTO cafNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","'Ink'ez nus whunilh'en Isaiah be' dustl'us 'i hitl'ahúya'ai. Lhk'inélhghal 'ink'ez ndet hukw'uyatelhtuk 'et nahoo'ai. 'Et buba k'eyawhénilhtuk 'et njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Moodihti buyégha 'i sulh 'int'ah. 'I be 'utahasalhti, ndunnah tehel'en, 'en khunek unzoo, 'i hubugha ités'alh ka. Ndunnah, en hubudzi nduda, 'en nabutélhyih ka hubuts'un whusaíya. Ndunnah ílchoot, 'en hobuntelhtun nts'e na'a hubulanadetnik hutele. 'Ink'ez hobuntelhtun ndunnah chahuwhés'en, 'en chah honilh'en nahutedleh. Ndunnah dune nts'e whuts'un yuk nihininkat, 'en chah dinábudutésdlelh. ");
INSERT INTO cafNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","'Et ndet nawhudezulh soo 'et neMoodihti buba hoonzoo, 'et ts'iyannah hubudutesnilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","'Aw 'et dustl'us nainílhghal 'ink'ez 'et 'ut'en yutl'anayá'ai 'ink'ez nanátl'adeda. 'Ink'ez ndunnah Lizwif luglez hudelhts'i, ts'iyannah 'en zeh hinilh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","'Ink'ez 'aw 'et hubulh yawhenilhtuk, “Et nuhwheni ndi Yak'usda bughunek dáhts'o, 'et k'an dzin ts'iyawh lhaooduja.” ");
INSERT INTO cafNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ts'iyannah soo highu yalhtuk. Khunek unzoo, 'i ye yailhtuk, 'i ts'iyannah huba hooncha. Dich'oh 'ulhódutni, “Ndun 'en Joseph buye' 'en ilah ih 'int'ah?” ");
INSERT INTO cafNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","'Et ndo búlhni, “Aw nawh cha'hoot'ah ndi khunek 'ahoolhyez 'et dudáhtni hoh njan ndutni, ‘Yoo be duyun nyunch'oh cho soo na'dudilneh,’ 'et whuz na'a si chah 'et ndusúdutehnilh. 'Et ndez na'a ndutehnilh, ‘Ndet keyah Capernaum huwhútni, dawhut'en whulh úzdits'o, 'et njan nyunch'oh nkeyah 'et chah whuz na'a zeh ndint'en.” ");
INSERT INTO cafNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","'Ink'ez 'et ndutni, “Alha ts'ah'un 'ún whudusni, nus whunilh'en dich'oh bukeyah ninya hoh 'aw 'ilhunuh whunts'ih yuka cha'nizun. ");
INSERT INTO cafNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ndet nuhwhudutésnilh soo ts'ah'un 'et 'alha' hoont'ah. 'Et hoh da ndun Elijah, 'en yun k'ut Israel nus whunilh'en huba unli inle. 'Et lhanah tsandelh hoonli inle. Hoh da tat naooduzuk 'o 'at lhk'utat sanun 'et nduhóolhyez 'aw chan hoolah. 'Et 'uhooja yun k'ut ndulhcho hoh dai whuzdli. ");
INSERT INTO cafNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","'Et Elijah 'aw 'ilhunuh whunts'ih hubuts'un chaitílh'al. 'Ilhunuh tsandelh, 'aw 'en zeh. 'En yun k'ut Sidon nts'e keyah Zerephath 'et whut'en, 'aw 'en zeh buts'un wheyalh'a. ");
INSERT INTO cafNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","'Ink'ez hoh da Elisha, 'en nus whunilh'en huba unli inle, 'et hoh da yun k'ut Israel hubukák whulhjut, leprosy hiyulhni, hulai. 'Aw 'ilhunuh whunts'ih soo nacha'yítlil, 'et Naman, ndun Syria whut'en, 'aw 'en zeh soo na'yinla,” ndo búlhni. ");
INSERT INTO cafNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","'Et Lizwif luglez húdelhts'i hidánts'o hoh tube huyulh húnilch'e. ");
INSERT INTO cafNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ts'iyawh dihudíndel 'ink'ez hiyílhchoot njan keyah hukw'un nahítelhya. 'Ink'ez nyedoh dzulhyaz k'ut keyah whuzdla, 'et whukw'abah nihinílhya whegha hitenoh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","'Ink'ez ts'iyannah hubutah lhuseya 'ink'ez nts'e hukwa' ninzun ts'ih whénya. ");
INSERT INTO cafNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","'Aw 'et Galilee yun k'ut 'et keyah Capernaum whuz'ai whuz whinya. Nats'ulyis dzin totsuk whubodulh'eh. ");
INSERT INTO cafNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","'Et njan hubodulh'eh tube huba hooncha. Bughunek hoolhtus hoh buk'une' hóot'en ka hubulh yalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","'Et nyo Lizwif luglez 'et 'ilhunuh dune, 'en ntsi' nududeh, 'i yudínda. Ndun ntsi' ndudeh tube cho 'alzul, ");
INSERT INTO cafNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","'ink'ez 'utni, “Ah! Nyun Sizi Nazareth whut'en 'unint'ah. Ndet nets'u hukwa' ninzun? Nehoolah ka netalhtsilh 'et hukwa whusainya ih? Ndun inli t'enyunúszun! Yak'usda ba lubeshi bughoh hoolah, 'en 'unint'ah!” ");
INSERT INTO cafNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","'Et Sizi hukwa' yudáni hoh ndi yúlhni, “T'eduzinih hoh buyáh hanaindaih!” Ntsi' nududeh, 'i ndun dune hubutah nayáno 'ink'ez yuts'u hanája. 'Ink'ez 'aw chayundílhdal. ");
INSERT INTO cafNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ts'iyannah hubugha ha'nejoot 'ink'ez whe hunelhújoot 'ink'ez 'ulhahudutni, “Ndi khunek ndai ho' 'int'ah? Ulhtus 'ink'ez buk'une' whut'en. Ndai ntsi' nududeh, 'i 'et ndi yulhni ibulh 'et yuts'u hanaja.” ");
INSERT INTO cafNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","'Et yun k'ut nduhoolcho hoh hiyulh údants'o. ");
INSERT INTO cafNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","'Et Sizi Lizwif luglez dinadija 'ink'ez Simon bukoo ts'ih whuz whinya. 'Et Simon bubez dada nezul 'i be nduda. 'Et Sizi ndi hiyúlhni khun teh yula 'ooneh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","'Et kw'usuti yuzih nininya 'ink'ez yutus chah tez'a. 'Ink'ez dada hukwa' yudáni hoh ndi nezul ye nduda, 'i yuts'ahanádoolts'it yúlhni, 'ink'ez buts'ah hanaídelts'ut. 'Et 'ahoh dinadija 'ink'ez hubugha ná'unt'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","'Aw 'et sa yun ts'ih tez'aih hoh ndunnah bulh dunekah lhelhyoo dédowh, 'i dada be nduda ts'iyannah Sizi higho bunínla. 'Ink'ez ts'iyannah hubuk'edálnik 'ink'ez 'et soo ná'ubinla. ");
INSERT INTO cafNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","'Ink'ez bulunah dune ntsi' nududeh, 'i 'ahúlzul hoh hubuts'uh hanaídede, 'ink'ez 'uhutni, “Nyun Yak'usda buYe' ndun Christ hiyulhni, 'en 'unint'ah!” T'eduzahnih ndo búlhni 'aw yahutélhtuk whunts'ih hubutl'achahoo'al, t'ehonínzun Christ 'en 'int'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","'Et 'om bun bundada sa hawhéni'ai 'et 'aw nehoolah ts'ih whenya. 'Et dune ts'iyannah hikunúta. 'Et nts'e usda highu nindel, hubughu tooya whuch'a né'hiyulh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","'Et ndo búlhni, “Udun keyah chah ndi khunek unzoo, 'i be yatelhtuk, dant'ah hoh nts'e whuba Yak'usda hubudayi cho unli hubudutesnilh. 'Et huba whusáts'alh'a.” ");
INSERT INTO cafNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","'Et Galilee yun k'ut ndulhcho Lizwif whuluglez whuz lhghadínya 'ink'ez hubulh yalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","'Ilhut dzin Gennesaret bun k'ut taba siyin, 'et dune ts'iyannah higha wezdel, Yak'usda bughunek hidutéts'o ka. ");
INSERT INTO cafNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ts'i cho nankoh yasá'a yunilh'en. 'Et whunts'ih lhook ka' hut'en, 'en 'udun loombilh toonahugus. ");
INSERT INTO cafNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","'Ink'ez 'ilhunuh Simon, 'en buts'i 'i yeínya. 'Ink'ez ndi yúlhni, “Nusyaz le 'inleh.” 'Ink'ez 'et ts'i bet natl'adeda 'ink'ez dune, 'en wheoobudunilh'i. ");
INSERT INTO cafNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Njan hubulh yalhtuk 'ustl'e' déja 'et Simon ndi yúlhni, “Nts'e soo takhulh 'et nuwhuloombilh ts'iyawh tenahle 'utehlooh huba.” ");
INSERT INTO cafNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon ndi yúlhni, “Sumoodih wheni 'ulh'ek nduhoolyez hoh 'uts'et'en 'et whunts'ih 'aw hoonliyaz nts'ih chats'ílooh. Nedini t'eh 'et lhoombilh 'ilho tenaoosdlelh sih.” ");
INSERT INTO cafNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Te'huninla hoh lhook lhai hiyuzdlooh. Lhai huzdlooh k'et hubuloombil 'aw 'et lhk'enich'oolh. ");
INSERT INTO cafNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","'Et 'onghunnah ts'i cho bet 'uhut'en, 'en 'anih hubuhútni hubula 'uhooneh ka. 'En chah whusahanki 'ink'ez 'ahunélht'et ts'i cho hidelhbun 'ink'ez 'aw 'et tewhéninlat. ");
INSERT INTO cafNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Peter, 'en whunalh'en hoh Sizi yubut dugwútsi be neninya 'ink'ez, “Sumoodihti sch'a naindalh, si lubeshi 'ulh'en usdli,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Peter 'ink'ez yulh 'ut'en, 'en ts'iyawh hubugha ha'nejoot 'ink'ez whe hunelhújoot ndi lhook lhe'neltsuk hoh hiyuzdlooh 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","'Et James 'ink'ez John Zebedee buye'kah, 'en Simon ts'udetni, 'en chah hubugha ha'nejoot 'ink'ez whehonelhújoot. 'Et Sizi 'uyulhni, “Simon khun whenoljut gunih. K'an whuts'un dune ka' tant'ilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","'Aw 'et yanahusdúki hoh ts'iyaintsuk 'et hiladetnik. 'Ink'ez hik'ah ts'ih 'uhóot'en ka hiyuntezdel. ");
INSERT INTO cafNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","'Et hukw'elh'az Sizi 'ilhunuh keyah 'ut'en. 'Ink'ez 'ilhunuh dune ndulhcho hoh bukak whulhjut, 'i leprosy hiyulhni, 'i be nduda, 'en chah 'et keyah whut'en. Sizi yutelh'en hoh yubut nachaneti, yuts'un tedudlih, “SMoodihti nyun hukwa' ninzun t'eh be ilhtus 'int'i, 'i be suna'ilhdeh,” yulhni. ");
INSERT INTO cafNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","'Et Sizi bula be yut'aghéznai 'ink'ez ndi yúlhni, “A, hukwa' nuszun hoh nyuna'alhde.” 'Et ndunnah bukak whulhjut 'en 'aw 'et soo na'uja. ");
INSERT INTO cafNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","'Et Sizi khunekti be njan ndi yulhni, “Khun teh 'uyoon ndudóni gunih! 'Et ndun náwhulnuk buts'inyalh 'ink'ez nyulh dahooja, 'et nyunoolh'en. 'Et Moses be' dustl'us k'ut daja ni hoh 'aw ts'ah'un cha'it'ah, 'et huba hoolah whutele, 'et whuz na'a Yak'usda bukw'uzdai k'ut hoonliyaz dutálhk'un. 'Et hobunolhtun dainja hoh soo na'inja,” yulhni. ");
INSERT INTO cafNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","'Et whunts'ih be nawhutnuk 'i Sizi Gri 'en bugha lha'un teh whulh 'úhudits'o. 'Et whu la gha ts'ih 'o nus hulai 'ink'ez 'o nus 'uhuneltsuk hoh highudulh, ndai hiye nduda, 'i ts'iyawh hubutelhyih hits'uh hukwa' ninzun. ");
INSERT INTO cafNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","'Et dich'oh lhat nehoolah ts'ih wheyih tenadutedli ka. ");
INSERT INTO cafNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","'Ilhut dzin dune hoodulh'eh, 'et ndunnah Pharisee, 'ink'ez Moses be' dustl'us hodulh'eh chah, 'en Sizi highah delhts'i. Ndunnah yun k'ut Galilee 'ink'ez Judea, 'ink'ez Jerusalem chah, 'en whuz hahándel. 'Ink'ez neMoodihti ye ulhtus, 'i nduda soo ná'hubutelh'ilh ka, 'i yulh 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","'Aw 'et ndun dune dechadusnik, 'en kw'usuti be whusahúyankai, 'ink'ez Sizi bukoo ts'ih hits'uh hitoolhte hukwa' hiyulh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","'Et whunts'ih dune hulai 'ink'ez 'aw 'uhiyooleh ghaít'ah. 'Et nduk bun hukw'ut, 'et hukw'ehiyilhti, 'i k'ehiyílhti. Bun hikonintsi 'ink'ez whuz hukwu hinínkai. 'Et soo buniz Sizi bubut yun nihíninkai. ");
INSERT INTO cafNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ndoh ts'iyannah hubunilh'en 'et t'eooninzun huba 'alha 'uhoont'ah 'ink'ez dechadusnik ndi yúlhni, “Dahooja dune nlubeshi ts'iyawh mba hoolah suli.” ");
INSERT INTO cafNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","'Et Moses be' dustl'us 'uk'ununa'úguz 'ink'ez Pharisee, dich'oh 'et ndonínzun, “Ndun dune 'en Yak'usda ch'a yalhtuk. Ndun na'dunúdzun hoh 'utni? Ndun lubeshi 'un tulhdelh? Yak'usda dich'oh zeh lubeshi 'un tulhdelh!” ");
INSERT INTO cafNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","'Et Sizi nt'eoonínzun daja huninzun, 'ink'ez ndo búlhni, “Et di ka nuhdzi yuh 'et ndunahzun? ");
INSERT INTO cafNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nts'e na'a simba huwa chahoolnah k'una'a uzdooni, ‘Lubeshi mba hoolah suli,’ k'us, ‘Didinyih 'ink'ez nínya?’ ");
INSERT INTO cafNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","'Et njan t'eoonóhzin yinkak dune ye', 'en ndi yun k'ut huba' hoont'ah ho' 'int'ah lubeshi 'un toolhdelh huba' hoont'ah ho' 'int'ah,” ndo búlhni. 'Ink'ez ndun dechadusnik, “Didinyih, bukw'usinti nailchoot, 'ink'ez nkooz ts'ih naindalh!” yulhni. ");
INSERT INTO cafNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","'Et 'ahoh ts'iyannah nalh didinya, yuk'usti nayílchoot 'ink'ez Yak'usda délhti hoh bukooz ts'ih whenaja. ");
INSERT INTO cafNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","'Et ts'iyannah huba hooncha. 'En chah Yak'usda hidálhti. Tube whe hunuljut, “Njan tube huwa 'et'en tune'ust'en, 'et ts'onalh'en,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","'Et hukw'elh'az Sizi 'az whenya 'ink'ez 'ilhunuh sooneya 'ilhunaoonughés'aih, Levi hiyulhni, 'en 'ut'en usda hoh yunilh'en, 'ink'ez ndi yúlhni, “Sunanyalh.” ");
INSERT INTO cafNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","'Et didinya, 'ink'ez ts'iyaintsuk yula ditnik hoh yuk'ah ts'ih oot'en ka yuntezya. ");
INSERT INTO cafNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","'Et Levi bukooz ts'ih hooncha 'et dune hubugha na'tét'alh, Sizi ba. 'Et sooneya 'ilhunaoonughés'aih 'en chah hulan. 'Ink'ez 'uyoon chah hulan hubulh 'et húdelhts'i. ");
INSERT INTO cafNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","'Et ndunnah Moses be' dustl'us 'uk'ununa'úsduguz 'ink'ez Pharisee, 'en dich'oh highu yalhtuk 'ink'ez Sizi yugha hoodul'eh, 'en hubuhútni, “Et ndunnah sooneya 'ilhunaoonughés'aih 'ink'ez lubeshi 'uhulh'en, 'en di ka hubulh áh'alh 'ink'ez hubulh táhtnai?” ");
INSERT INTO cafNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sizi 'et ndo búlhni, “Ndunnah soo 'ínt'ah, 'aw yoo be duyun ka cha'hunízun. Nduda, 'en zeh yoo be duyun ka' huninzun. ");
INSERT INTO cafNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Si chah whuz na'a zeh 'aw dune ts'ah'un 'int'ah, 'en bulubeshi ch'a bubeni naháhunduntele huba ilah whusáya. 'Et lubeshi 'ulh'en, 'en bulubeshi ch'a bubeni naháhundunoolelh hubudutésnilh ka, 'et huba whusáya.” ");
INSERT INTO cafNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","'Et hiyoodulhkut, “Dahoont'ah huwa John yugha hoodul'eh, 'en lhat soo saha'dulyih 'ink'ez tenahududli? 'Ink'ez Pharisee hiye hoodul'eh, 'en chah 'et nduhút'en. 'Et whunts'ih nyun ngha hoodul'eh, 'uha'alh cha' hut'en 'ink'ez 'uhutnai cha' hut'en?” ");
INSERT INTO cafNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","'Et ndo búlhni, “Ndun bu'at whutele, 'en bulh dune 'en 'awhuz hiyulh 'ut'en, 'en do soo saha'dutélyelh ih? 'Awundooh! ");
INSERT INTO cafNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","'Et whusawhutelts'ulh, hoh t'eh bu'at whutele bughu nayitélcholh. Hoh t'eh zeh soo sahá'hudutelyelh.” ");
INSERT INTO cafNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","'Et be nawhutnuk 'i be whuts'o dul'eh, 'i be hubulh yalhtuk 'et njan ndutni, “Aw 'ilhunuh naih k'an ts'ih hayálhch'ul 'ink'ez 'ujut, 'i lhunaidunóokalh ghaít'ah. 'Et whuz na'a nduja t'eh, 'et ndi k'an naih, 'ink'ez naih jut bulh 'aw lhk'una'a oot'e ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","'Et doo chah, 'aw 'ilhunuh k'an mai too 'i 'aw 'ujut mai too 'uzus be yóolhdzeh ghaít'ah. 'Et ndúja t'eh, k'an mai too ndi 'ujut mai too 'uzus buk'e'ootéltulh. 'Et ts'iyawh mai too bé haitejulh. 'I 'uzus 'i chah tinta' tet'ilh. ");
INSERT INTO cafNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","'Et whunts'ih k'an mai too, 'i k'an mai too 'uzus be naooldzeh huba' hoont'ah. 'Et whuz na'a 'anelht'et soo' tet'ilh. ");
INSERT INTO cafNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","'Aw 'ilhunuh mai too 'ujut utnai t'eh, 'ahoh k'an mai too ka' noozin ghaít'ah. ‘'Ujut, 'i zeh 'o nus unzoo,’ hutni,” 'et hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","K'an whulhnat dune nalyis dzin, 'udechoo 'et hukw'elh'az 'uhoont'ah. Sizi 'ink'ez higha hoodul'eh, 'en bulh tl'o k'ut hedulh hoh, tl'o mai hiyooneye. 'Ink'ez hubula k'et nuhínulhmul 'ink'ez hiya'alh. ");
INSERT INTO cafNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","'Et bulunah Pharisee hubuhútni, “Daht'en hoh 'aht'en? K'an dzin nats'ulyis dzin 'uhoont'ah! 'Aw 'et nduhóot'en huba cha'hoot'ah!” ");
INSERT INTO cafNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sizi ndo búlhni, “Hubudayi cho David daja 'aw ih hukw'e yachazulhtuk. 'Et hoh da David 'ink'ez yulh 'ut'en buye'élts'ul. ");
INSERT INTO cafNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","'Et 'úja, Yak'usda bukoo daninya. Lhes 'i Yak'usda bugha yu'aih, 'i ndi lhes nawhulnuk 'aw 'en zeh hiyoo'alh huba' hoont'ah. 'Ink'ez 'i yilhchoot 'ink'ez ya'al. 'Ink'ez dulh 'ut'en, 'en chah bulah hubugha iní'ai.” ");
INSERT INTO cafNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","'Ink'ez Sizi ndo búlhni, “Yinkak dune ye', 'en njan nats'ulyis dzin, 'et chah huMoodihti unli ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","'Et hukw'elh'az 'o 'at nats'ulyis dzin Lizwif luglez daninya 'ink'ez whubodulh'eh. 'Et 'ilhunuh dune 'en chah 'et usda. Ndun bula nalhnih ts'ih 'aw yé nucha'ust'en. ");
INSERT INTO cafNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ndunnah Moses be' dustl'us 'uk'ununa'úsduguz 'ink'ez Pharisee chah soo cho highunli 'ink'ez hinilh'en daténilh simba. 'Et dune nalyis dzin 'et tulih soo na'yooleh. 'Et hoonliyaz hiyulh nahó'alh hukwa' hut'en. ");
INSERT INTO cafNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","'Et daja huninzun t'eooninzun. 'Et dune bula yunucha'ust'en ndi yúlhni, “Didinyih 'ink'ez hubuniz sinyin.” 'Et didinya 'ink'ez hubuniz ninínya. ");
INSERT INTO cafNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","'Ink'ez Sizi ndo búlhni, “Hoonliyaz hukwa nuhoodutelhkut. 'Et nats'ulyis dzin, nts'e na'a netl'awhélts'ut, 'et ts'ah'un na'a 'uztenilh, k'us hoontsi' k'una'a 'uztenilh? Dune hiye khuna 'uztelhyih k'us daztelhtsah?” ");
INSERT INTO cafNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","'Ink'ez 'et ts'iyawh hubunilh'en. 'Et ndunnah dune ndi yúlhni, “Nla ts'ih 'un lhk'ut dughelnih!” 'Et ndúja 'ink'ez bula k'uz ts'ih dachait'ah, 'et whuz na'a zeh ndunája. ");
INSERT INTO cafNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","'Et 'onghunnah tube whuske be honílch'e, 'ink'ez dich'oh howu yahalhtuk Sizi dahítelilh 'et hukwa. ");
INSERT INTO cafNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hoh da 'et dzin njan ndúhooja, Sizi dzulhyaz k'ut tenadutedli ka whuz whenya. 'Ulh'ek nduhoolhyez Yak'usda ts'un tenadedli. ");
INSERT INTO cafNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","'Et yilhkai higha hoodul'eh, 'anih hubulhni. 'Et hubutah lanezi 'o 'at nanah, 'en 'utahaóobanla. 'En whel'a huboozi yúlhtsi. ");
INSERT INTO cafNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon, 'en ndi boozi Peter, 'i yugha íde'ai. 'Ink'ez bulhutsin Andrew, James, John, Philip 'ink'ez Bartholomew. ");
INSERT INTO cafNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew 'ink'ez Thomas. James Alphaeus buye', 'ink'ez Simon 'en huwu daóodit'ah hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, 'en James buye', 'ink'ez Judas Iscariot chah, 'en 'utenilh whu'iz buch'a niduteyalh. ");
INSERT INTO cafNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","'Et whududlun ndus de yugha hoodul'eh hubulh hainya 'ink'ez lhts'e oodez'a nináhundel. Yun k'ut Judea whut'en, Jerusalem whut'en chah, 'ink'ez yatoo ba keyah Tyre 'ink'ez Sidon whut'en, 'en chah hulan 'ink'ez 'aw uzdooni ghaít'ah. Hiyootuzélhts'ilh 'ink'ez soo na'butelilh, 'et hukwa 'ilhuhowezdel. ");
INSERT INTO cafNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","'Ink'ez ndunnah ntsi' nududeh 'i be dzuh nudeh, 'en chah 'et hudelhts'i, 'ink'ez soo na'balh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ts'iyannah hit'aghoonalh hukwa' hut'en. Ye ulhtus buts'uh haidults'uk, 'i be ts'iyawh hubudada 'et soo na'ubinla. ");
INSERT INTO cafNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sizi 'et yugha hoodul'eh, 'en ts'iyawh hubutuniyú'en hoh njan ndo búlhni, “Nuhwheni tel'en ndet Yak'usda 'et hubudayi cho unli, 'et nuhwheni nuwhe'ilhdzun 'uhoont'ah. 'Et huwa degha nus hoonzoo nuhgha whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nuhwheni k'an buye'últs'ilh, untehdai, 'et huwa degha nus hoonzoo nuhgha whults'ut. Nuhwheni k'an ahtso, 'et tehdloh, 'et huwa degha nus hoonzoo nuhgha whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Hoh t'eh dune nuhts'u hudutnik 'ink'ez 'aw hubulh 'óoht'e ghaít'ah nuhowhulhtsi. 'Ink'ez nuhch'a yahutelhtuk hoh yinkak dune ye' 'en bugha, 'et huwa nuhoozi dutsun hitelhtsilh 'ink'ez 'un hitelhdulh. 'Et whuz na'a ndunóhowhulh'en t'eh, 'et degha nus hoonzoo nuhgha whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","'Et dzin ndóohooja t'eh, 'et hooteht'i 'ink'ez hoonaht'i hoh nduk tóolhutlhuk. 'Alha 'uhoont'ah nduk yak'uz hooncha 'et nuhwhuba k'elha whutele. Hoh t'eh whusawhutelts'ulh ndunnah whuz na'a zeh ndunohotelh'ilh, 'et ndunt'ah butsuh whudelhdzulh, 'en chah niz dak'ez nus whunilh'en inle, whuz na'a zeh ndubuhalh'en 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Et whunts'ih nuhwheni soode'a 'aht'ah, soo cho howahli! Ndai be hoonaht'i, 'i be 'uda ts'iyawh nuhwhuba 'uk'elha whuzdli 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nuhwheni ndunnah soo 'a'alh, nuhwheni chah soo cho howahli! Nuhyé'telts'ulh! Ndunnah hédloh howahli! Nuhdzi dúnteda 'ink'ez tehtso! ");
INSERT INTO cafNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","'Et huwahli ndunnah sóo nuhghu yalhtuk. Hoh da nus whunilh'en la'dudil'i, 'en chah butsuh whudelhdzulh, 'et zeh ndó buhutni.” ");
INSERT INTO cafNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Et whunts'ih ndez na'a ndun whudusni, nuhch'a húdetni, 'en buk'ehtsi'. Ndunnah nuhka cha'nizun, 'en chah sóo ne'bulh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ndunnah nuhk'ehuyih, Yak'usda buts'un wúzoo ka huba tenadóohdli. 'Et ndunnah dzuh ne'nohulh'en, 'en chah huba tenadoohdli. ");
INSERT INTO cafNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ndunnah nuhnen k'ut nuhnezkuk t'eh, huba 'awh nandunóoht'ah 'ink'ez 'ilhk'us ts'ih chah 'unohuhooleh. Ndan ndzoot nghu halchooz, ndzoozt'an chah buch'a yóntun gunih. ");
INSERT INTO cafNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ts'iyannah hoonliyaz ka nuhts'u ka 'utni t'eh, hubugha íyoohlelh. Ndai nuhwhe'ilhdzun 'uyoon yílhchoot t'eh, buts'un ka na'doohtni gunih. ");
INSERT INTO cafNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nts'e na'a hukwa' nahzun dune danoh hotelh'ilh, 'et whuz na'a zeh nuhwheni chah 'et né'boolh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ndunnah nuhk'entsi', 'en zeh buk'ehtsi' t'eh, whuz na'a hoonzoo nahzun ih? 'Awundooh! Ndunnah lubeshi 'uhulh'en, 'en whunts'ih ndunnah buk'entsi', ts'iyawh hubuk'ehintsi'. ");
INSERT INTO cafNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ndunnah soo ne'nohulh'en, 'en zeh soo ne'bulh'en t'eh, whuz na'a hoonzoo nahzun ih? 'Awundooh! 'Et lubeshi 'uhulh'en chah whuz na'a zeh 'et nduhút'en. ");
INSERT INTO cafNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","'Et ndunnah bughi zilh'ai t'eh, 'en nuhtl'anaíte'alh nuhzun t'eh, whuz na'a hoonzoo nahzun ih? 'Awundooh! 'Et lubeshi 'uhulh'en, 'en whunts'ih lubeshi 'uhulh'en ghe' hulh'ai 'ink'ez 'et 'uneltsuk zeh hubutl'anáha'aih. ");
INSERT INTO cafNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","'Et whunts'ih nuhch'a hudétni, 'en hubuk'eoohtsi', 'ink'ez soo ne'boolh'en. Hubughe 'oohla 'ink'ez hoonliyaz nuhtl'unaítelts'ulh hukwa tsi hóhli gunih. 'Et whuz na'a ndaht'en t'eh, hooncha hoh nuhwhuba k'elha whutele. 'Et ndun yak'uz soo 'udedo 'int'ah, 'en k'una'a tihleh. 'Alha ndunnah suchanailya chadusnih 'ink'ez ntsi' chah, ts'iyawh hubuts'un unzoo. ");
INSERT INTO cafNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","'Et nuhwhe'aBá nts'e na'a te'ninzun, nuhwheni chah whuz na'a zeh te'noohzin. ");
INSERT INTO cafNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Uyoon ba nahoohyeh gunih, doo ka sih 'aw nuhwhuba nahoodeh ghaít'ah. 'Uyoon k'ehoh'alh gunih, 'et sih 'aw nuhk'eholts'it ghaít'ah. 'Uyoon ba whunaoodoolhunah, 'et t'eh nuhwheni chah nuhwhuba whunaoodutetnah. ");
INSERT INTO cafNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","'Uyoon hubugha' náh'ai, 'i nuhtl'anátedukulh ho' 'int'ah. Lht'usúkat 'ink'ez lhai cho tele. 'Et niyulh'uz hoh bé haitekulh. 'Et 'uneltsuk hoh nuhbut nehítekalh. Daltsuk hubugha ináh'ai, 'et 'uneltsuk zeh nuhtl'anátedukulh 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Be nawhutnuk be whúts'odul'eh, 'i be hubulh yailhtuk, “Soo ih chawhés'en 'uyoon chawhés'en nutéguz? 'Alha nahúlt'ah ka háwhedukai 'ahoolts'it! ");
INSERT INTO cafNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hodul'eh 'ink'ez whuyodulh'eh, 'en 'aw yagha ndoh cha'ít'ah. 'Et whunts'ih ndunnah soo ts'ah'un na'a hodul'eh, 'et hubodulh'eh 'en k'una'a 'uhutet'ilh. ");
INSERT INTO cafNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","'Et di ka nyulhutsin lhusyaz buna k'et deztan, 'i nilh'en, 'et whunts'ih 'aw t'eoonuzinzun nyunch'oh duchun cho nyuna k'et deztan? ");
INSERT INTO cafNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nts'e na'a nyulhutsin 'uduténilh, ‘Sulhutsin nyo lhusyaz nyuna k'ehanádoostan.’ 'Et whunts'ih nyunch'oh duchun cho nyuna k'et deztan 'aw chasá'en. Nyunch'oh duba naindzoo! 'Udechoo duchun cho nyuna k'ehanadintih. 'Et t'eh soo yutó'en hoh nyulhutsin nyoo lhusyaz 'i buna k'éhanaidontan. ");
INSERT INTO cafNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Et duchun dinzoo 'aw mai untsi', 'i bughi noot'ai ghaít'ah. 'Et whuz na'a zeh duchun dintsi' mai unzoo, 'i bughi noot'ai ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","'Et whuz na'a zeh bumai bugha duchun dant'ah 'int'ah t'enudzun. 'Et whuz na'a zeh ndi mai unzoo, figs hiyulhni, 'aw whus chun bughu hiyoonoye ghaít'ah. 'Ink'ez whuz na'a zeh whuscho chun, 'aw mai cho ndoh whut'en bughu hiyoonoye ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","'Et whuz na'a zeh dune unzoo, ndai unzoo budzi yuh hoonli, 'i bugha khunek unzoo be yalhtuk. 'Ink'ez dune untsi', ndai untsi' budzi yuh hoonli, 'i be khunek untsi' be yalhtuk. Ndez na'a njan nduwhutni, dune di budzi yuh be whudezbun, 'i be yatelhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ink'ez di ka ‘SMoodihti, sMoodihti,’ sudahni, 'ink'ez daja nuhwhudusni 'aw húkw'u nucha'zaht'en? ");
INSERT INTO cafNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ndan sts'un teyih 'ink'ez soo zelhts'ai 'ink'ez hukw'ú ne'ut'en, 'et ndan 'uhint'ah 'en bunwhuntelhtun. ");
INSERT INTO cafNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ndez whuz na'a 'et ndúhint'ah. Dune bukoo 'uwhutelilh hoh, soo ye yoh hahónkai 'ink'ez bukoo buk'uwhuz'ai 'et tse k'ut newhúte'alh. 'Et ndet too telhbun t'eh, 'et ninli ulhtus bukoo whut'agheznai, 'et whunts'ih bukoo 'aw dachahóonil. Tse k'ut niwhuni'ai 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","'Et whunts'ih ndunnah sughunek yoozelhts'ai 'ink'ez 'aw hik'unucha'ust'en t'eh, 'et ndez na'a njan nduhint'ah. Dune yun k'ut bukoo 'uhoonla. 'Ink'ez bukoo buk'uwhuz'ai 'i 'aw cha'hiyílil. 'Et ninli ulhtus bukoo whut'agheznai 'et 'ahoh nawhunet'ai. Tube wheóonujut hoh hoolah whuzdli.” ");
INSERT INTO cafNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","'Et dune Sizi yoozelhts'ai ndet hubugha ndo búlhni, 'aw 'et ts'iyawh lhaoodinla. 'Ink'ez keyah Capernaum huwhutni whuz lhgha dinya. ");
INSERT INTO cafNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","'Ink'ez njan 'et keyah whut'en 'et 'ilhunuh nehughan whumoodih yuba ne'út'en. Tube yúk'entsi', 'en tube nduda 'ink'ez 'aw 'et datetsah. ");
INSERT INTO cafNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","'Et ndun nehughan whumoodih Sizi yulh údants'o 'ink'ez Lizwif tsuh whudelhdzulh, 'en whuz whebalh'a. Sizi hiyoodutélhkut nehughan whumoodih yuba ne'ut'en soo na'yooleh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","'Et Sizi highu nindel hoh soo tube cho hits'uh tedudlih 'ink'ez 'uhiyulhni ndun nehughan whumoodih, 'en tube unzoo ho' 'int'ah yuba ne'ut'en, 'en soo na'yooleh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","“Nedune, 'en hubuk'entsi' 'ink'ez 'en bugha Lizwif buluglez neba 'uhóonla,” hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","'Et hubulh tez'as. 'Et Sizi koo wheghah uyalh hoh, 'et ndan nehughan whumoodih 'en hubulh dune Sizi hits'ú whebalh'a. Hidudezdel 'ink'ez Sizi 'uhiyúlhni, “Nehughan whumoodih njan ndunyúlhni, ‘SMoodihti 'ants'i 'et dzuh ne'dudoldzut gunih. Sukoo datányalh huba 'aw soo cha'lhudzooh 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","'Et si chah 'et ndunuszun 'aw soo cha'lhudzooh ndudutésyalh huba. 'Et whunts'ih 'ants'ih nghunek be dini t'eh, 'et suba ne'út'en soo na'óotneh. ");
INSERT INTO cafNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","'Alha si chah 'onghunnah sgha ndoh 'uhint'ah hoh hukwa' huninzun tune' satelh'en. 'Et si chah whuz na'a zeh nehughan huba gha ndoh 'ust'ah. 'Et 'ilhunuh, ‘Inyalh!’ dúsni t'eh, 'et 'ahoh 'aw 'et teyalh. 'Et 'uyoon, ‘'Anih!’ dúsni t'eh, 'et 'ahoh sts'u teyih. 'Et suba ne'út'en, ‘Njan dineh!’ dúsni t'eh, 'et 'ahoh 'et ndút'ih.’ ” ");
INSERT INTO cafNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sizi ndun dune daja ni yulh údants'o hoh tube buba hooncha. 'Et ndunnah hinedulh, 'en hubuts'un nalhú'a 'ink'ez ndo búlhni, “Israel ndulhcho keyah ndun dune 'en k'una'a 'aw 'ilhunuh ndulhcho be huba 'alha' hoont'ah nachasulhtek.” ");
INSERT INTO cafNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ndunnah yuts'un whel'a ndun nehughan whumoodih bukoo ts'ih nahundel, 'et ndun yuba ne'út'en nduda, 'en 'aw dáchait'ah hoh highu danándel. ");
INSERT INTO cafNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","'Et 'om bun dzin Sizi njan keyah Nain huwhutni, yugha hoodul'eh bulh, 'ink'ez hooncha hoh lhannah hinedulh, 'en chah ts'iyawh whuz haíndel. ");
INSERT INTO cafNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Njan keyah na'nestl'oo ghu ti wheghah nihúnindel, 'et khunyaz dune dazsai hidihídezkai. 'Et 'ama tsandelh, 'aw 'ilhunuh zeh buye' 'int'ah. 'Et keyah whut'en, 'en lhanah yulh údulh. ");
INSERT INTO cafNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","'Et neMoodihti ya'en hoh yugha te'nanzin 'et ndi yúlhni, “Intso ilah!” ");
INSERT INTO cafNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","'Ink'ez be nesulhti yughu neninya 'ink'ez yut'agheznai. Ndunnah yelhtelh, 'en chah 'ilhuz nihunindel. 'Ink'ez 'et 'utni, “Chilh dune didinyih nyudúsni!” ");
INSERT INTO cafNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","'Ink'ez ndun dune dazsai nduk ninatl'adenda 'ink'ez yawhénilhtuk. 'Ink'ez Sizi, 'en be'ama tl'anayalhti. ");
INSERT INTO cafNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ts'iyannah hunelhújoot, 'ink'ez Yak'usda hidélhti hoh njan duhutni, “Njan netah nus whunilh'en hooncha unli, 'en whusainya.” 'Ink'ez 'et chah nduhútni, “Yak'usda budune hubutah nunasja.” ");
INSERT INTO cafNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","'Et Judea yun k'ut nduhoolcho 'ink'ez 'et whunat keyah nduhoolcho chah, ts'iyannah hiyulh údants'o. ");
INSERT INTO cafNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John yugha hoodul'eh ts'iyawh ndi hiduténilh dahooja 'et. ");
INSERT INTO cafNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","'Ink'ez nanah 'anih hubúlhni 'ink'ez Sizi ts'un whebalh'a hiyoodutelhkut ka, “Nyun ih whusatányalh inli, k'us 'uyoon tulih ka ts'itóo'en?” ");
INSERT INTO cafNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","'Et Sizi highu ni'az 'ink'ez 'uhiyúlhni, “John dune too be 'ulh'en, 'en nts'u nételh'a nts'oodutelhkut ka, nyun ih whusatányalh inli, k'us 'uyoon tulih ka ts'itóo'en?” ");
INSERT INTO cafNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","'Et 'ahoh ndunnah hunduda 'ink'ez buka, 'ink'ez ntsi' nududeh buyudínda, 'en chah lhanah hoh soo na'balh'en. Chawhés'en, 'en chah honilh'en butl'anáho'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","'Et Sizi John yugha hoodul'eh ndo búlhni, “John buts'un ah'us. Ndet whunelh'en 'ink'ez whudáhts'o 'et dóohtni, nts'e na'a chawhés'en honilh'en nasdli. Nuchahúsdel, 'en nahúdelh nahusdli. Bukak nódutsi', leprosy hiyulhni, 'en chah soo ná'binla. Cha'hudusts'uk, 'en chah 'ahudits'o nahusdli. Yahadla, 'en chah dináhudidel. Tel'ennah, 'en chah khunek unzoo, 'i be hubulh yaíntuk ho' hint'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","'Ink'ez ndunnah si sugha buba dzuh chahoolah, 'en degha nus hoonzoo bughá whults'ut.” ");
INSERT INTO cafNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","'Et John khunek yuba na'a whenáhet'az, 'aw 'et Sizi John yughu yatelhtuk hoh 'ilhunahuwésdel njan ndo búlhni, “Dune chahóot'ih ts'ih ndet hukwa tsi hoohli whuteh'ilh? Tl'o ghazilh nónulhts'i, 'i tulih teh'ilh nahzun ih? ");
INSERT INTO cafNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ndet simba hukwa tsi hoohli whuteh'ilh? Dune naih duchut 'i be soo naduja, 'en tulih teh'ilh nahzun ih? 'Alha ndez whuz na'a soo nadut'ih, 'en lhai sooneya ts'iya hulhtsih 'ink'ez hubudayi cho bukoo huwhut'i. ");
INSERT INTO cafNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","'Et ndet simba hukwa tsi hoohli whuteh'ilh? Nus whunilh'en tulih? A! 'Alha 'un whudúsni nus whunilh'en ba nus unzoo 'et nulh'en! ");
INSERT INTO cafNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","'En bugha 'uk'une'usguz inle hoh njan ndutni, ‘Soo zilhts'ai, khunek suba na'a, 'en ntsuh tes'alh. 'En ti lhutanyalh, mba lhaoodutelilh 'et wheni.’ ");
INSERT INTO cafNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","'Alha 'un whudúsni, nus whunilh'en ndunnah whuzdli, 'en hubutah John dune too be 'ulh'en, 'en degha nus ncha 'int'ah. 'Et whunts'ih nts'e Yak'usda hubudayi cho unli, ndan degha nyoh 'int'ah, 'en 'o nus uncha unli.” ");
INSERT INTO cafNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ts'iyannah dune 'ink'ez sooneya 'ilhuhunughes'aih, Sizi daja ni hidants'o hoh Yak'usda buba 'alha' yija, John 'en too be' balh'en 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","'Et whunts'ih ndunnah Pharisee 'ink'ez Moses be' dustl'us k'ut daja ni hoh beni hoonli be yalhtuk, 'en ts'iyawh Yak'usda nts'e buts'uh hukwa' ninzun, 'ants'ih 'et 'un hubutelhdel. 'En 'aw John too be cha'bilel 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","'Et Sizi ndo búlhni, “Dune k'an yuk'edídeh nts'e na'a simba nuhwhuba lhzih niboosdlelh, k'us dant'ah dune hinli, 'et nuhwhudutésnilh. ");
INSERT INTO cafNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ndez na'a njan nduhínt'ah, 'uskehyaz duhúlt'ah hoh hiya'alh be 'e'óoket 'et hudelhts'i. 'Ink'ez lhts'u háhudih hoh njan ndulhódutni, ‘Be ts'ujun be nuhwhuba ts'ujun, 'et whunts'ih 'aw chanuzahdak. 'Ink'ez nuhwhuba tso ts'inli, 'et whunts'ih 'aw chasáhtso!’ ");
INSERT INTO cafNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Soo cho whunulh'en, John dune too be 'ulh'en whusainya, 'aw lhes chas'al 'ink'ez mai too chah chasnai. 'En 'údahni ‘Ntsi' nududeh buyudínda,’ dahni. ");
INSERT INTO cafNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","'Et yinkak dune ye' whusainya, 'a'alh 'ink'ez 'utnai. 'Et 'udáhni, ‘Ndun dune 'en bucha hooncha 'ink'ez tanutnai. Sooneya 'ilhunanowes'aih 'ink'ez lubeshi 'ulh'en, 'en hubudune,’ dáhni. ");
INSERT INTO cafNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","'Ink'ez ndunnah hiye whunih na'dudil'i, 'en bugha ndi be whútnih, 'i ts'ah'un na'a 'uhóoja.” ");
INSERT INTO cafNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","'Et Pharisee 'ilhunuh yughu nusíya dudulh ná'oot'alh yulhni. 'Et whuz bukoo ts'ih yughu danínya. 'Et kw'uzdai yeyoh 'int'ah, 'i yuzih nilget ute'ulh wheni. ");
INSERT INTO cafNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","'Et 'ilhunuh keyah whut'en, 'en lubeshi 'ulh'en ts'eke. 'Et Pharisee bukoo ts'ih 'et Sizi 'a'alh yulh údants'o hoh whuz whinya. Ndi k'unutsutjul sooltsun, 'i dezti, 'i alabaster luboodai bé yalhdze, 'i whuz wheya'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","'Et yut'ak suyin. Utso 'ink'ez bunatsultoo buke k'eidilt'ik. 'I dutsigha be yuna'ulhdeh, 'ink'ez buke naidunants'ooz. 'Ink'ez ndi k'unutsutjul sooltsun, 'i dezti, 'i be yuke yulhlho. ");
INSERT INTO cafNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","'Et ndun Pharisee, ndun 'anih yudani, dich'oh na'dudutni, “Et ndun nus whunilh'en unli t'eh, t'eoonózin da dant'ah ts'eke 'int'ah yut'aghunah. 'En lubeshi 'ulh'en 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","'Et Sizi ndi yúlhni, “Simon, hoonliyaz nyudutésnilh.” “Nehodulh'eh dini,” ni. ");
INSERT INTO cafNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","'Et Sizi ndi yúlhni, “Ilhunuh sooneya yughu sulh'ai nanah dune ghe 'ulh'ai. 'Ilhunuh 'en 500 unli sooneya, 'ink'ez 'ilhunuh 50 unli sooneya. ");
INSERT INTO cafNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","'Aw hiba k'elha hitelhtsilh chahít'ih. 'Et nahúlt'ah huba whuladetnik. 'Et sudini, k'us ndan degha nus yuk'entsi'?” ");
INSERT INTO cafNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","'Et Simon 'utni, “Si ndunúszun, ndun degha nus lhai yuba ladetnik, 'en degha nus yuk'entsi'.” 'Et Sizi ndi yúlhni, “Soo ts'ah'un na'a 'udenja.” ");
INSERT INTO cafNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","'Et ndun ts'eke ts'un nalhu'a 'ink'ez Simon 'uyúlhni, “Ndun ts'eke nilh'en ih? Nkoo daníya hoh 'aw too suba 'et néchainkal suke be tóona'tesgus huba. 'Et whunts'ih ndun ts'eke dunatsúltoo be suke nainelhtsul 'ink'ez butsigha be yuna'alhde. ");
INSERT INTO cafNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nyun 'aw na'duts'oos be dahooja chasudínel. 'Et whunts'ih ndun ts'eke 'udechoo danínya whuts'un 'aw suke naduts'oos stl'echa'ínil. ");
INSERT INTO cafNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","'Aw sutsi khe be chaílhoh 'et whunts'ih ndun ts'eke ndi khe be suke yulho. ");
INSERT INTO cafNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","'Et huwa ndi ndusni, bulubeshi lhai ts'iyawh huba whunaoodelhúnah. Nilh'en ih 'ilhuz tube skentsi' ho' 'int'ah? 'Et whunts'ih ndunnah hoontsolyaz lubeshi huba hoolah unli, 'en whunts'ih hoontsolyaz zeh whe skehintsi'.” ");
INSERT INTO cafNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","'Ink'ez Sizi ts'eke ndi yulhni, “Nlubeshi ts'iyawh mba hoolah suli.” ");
INSERT INTO cafNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","'Et ndunnah 'onghunnah kw'uzdai k'ut na'hut'alh, 'en dich'oh 'ulhódutni, “Ndun, ndan ho' 'int'ah? Lubeshi 'i whunts'ih yuna'alhdeh?” ");
INSERT INTO cafNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","'Ink'ez ts'eke ndi yulhni, “Mba 'alha' hoont'ah, 'i be dinjih. 'Aw 'et ndzi dezghel hoh naindalh!” ");
INSERT INTO cafNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","'Et hukw'elh'az Sizi kedutezut keyah whucho 'ink'ez keyah whuyaz totsuk, ndet hoh Yak'usda hubudayi cho unli, 'et hubugha khunek unzoo, 'i be yatelhtuk. 'Et ndunnah lanezi 'o 'at nanah, 'en chah hiyulh 'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","'Ink'ez ndunnah ts'ekoo 'en chah hiyulh 'ut'en hoh ntsi' nududeh, 'i buyudínda 'ink'ez bukak nódutsi', 'en ts'iyawh soo na'binla. Mary Magdala whut'en, 'en chah 'ut'en. 'En 'int'ah skwunlai 'o 'at nankoh ntsi' nududeh, 'i buyáh hanaidede. ");
INSERT INTO cafNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","'Ink'ez Joanna, Chuza bu'at, 'et Chuza, 'en Herod bukoo hudelhts'i bumoodih unli, 'en bu'at 'ink'ez Susanna, 'ink'ez 'uyoon lhanah chah, ndai hiyit'i, 'i be hila 'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","'Et njan nduhoolhcho keyah whut'en 'ilhuhowezdel 'ink'ez Sizi nawhutnuk, 'i be whuts'odul'eh, 'i be yatelhtuk, ");
INSERT INTO cafNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ilhunuh 'a'nule 'en 'a'untelelh ka. 'Et 'a'nule 'et ndi ninutsut 'et bulah 'ants'ih 'et nts'oh nanánkat. 'Ink'ez hik'ut nusúdel 'et dut'aiyaz chah ts'iyawh yuneldel. ");
INSERT INTO cafNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","'Et bulah chah tse tah nanánkat. 'Et ndet hanálhyi hoh 'et ndi hanulhyeh, 'i too hoolah 'et huwa yanúdezgi. ");
INSERT INTO cafNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","'Et 'onghuh, 'i chah whus cho tanínkat. 'I chah whus cho bulh taninyi 'ink'ez whus cho 'i bugha chaniyel. ");
INSERT INTO cafNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","'Et 'onghuh, 'i yun unzoo, 'i k'ut nanánkat, 'ink'ez hanálhyi. 'Ink'ez bumai 'i lhan'un teh lhai suli lanezi lanezi (100) 'et 'uneltsuk suli.” 'Et hukw'elh'az 'et tube cho ndo búlhni, “Ndunnah budzo hooni, 'en hiyoozólhts'a huba' hoont'ah!” ");
INSERT INTO cafNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","'Et yugha hoodul'eh hiyoodulhkut, “Ndi be whuts'odul'eh, 'i daja ni hoh 'utni?” ");
INSERT INTO cafNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","'Et ndo búlhni, “Ndi Yak'usda hubudayi cho unli huba whe' hoont'ah hooyah, 'i bugha t'eoonoohzeh ka, 'i 'uda nuhtl'awhélts'ut. 'Et whunts'ih 'onghunnah ndi khunek be whuts'odul'eh, 'i whuz na'a zeh hubulh yalhtuk. 'Et sih, ‘Honalh'en 'et whunts'ih 'aw chahuwhés'en. 'Et hodits'o 'et whunts'ih 'aw t'ehonízun daja ni.” ");
INSERT INTO cafNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ndi be nawhutnuk, 'i be whuts'odul'eh, 'i ndi 'et ndutni. Ndi mai 'anukat, 'i Yak'usda bughunek 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ndunnah ti 'int'ah, 'en Yak'usda bughunek hidits'o 'ink'ez netsudule ndi khunek budzi be hanaída'aih. 'Et whuz na'a 'aw huba 'alha cha'hoot'ah 'ink'ez 'aw hudoojih ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ndai tse tah nanánkat, 'i li'int'ah hodits'o 'ink'ez huhóont'i hoh khunek hiyilhchuk. 'Et whunts'ih 'aw bughih hoolah. 'Et huwa 'astl'iyaz huba 'alha' hoont'ah. 'Et 'ahoh bé tink'us hunint'uk, 'i be tinch'a haninkat, 'en 'uhint'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ndai ndi whus cho tah nanánkat, 'i 'et njan nduwhutni, dune Yak'usda bughunek hidits'o 'et whunts'ih ndi yun k'ut huwu ni ts'inli, ndi yun k'ut soo uzde'a 'uhoont'ah, 'ink'ez ndai ndi yun k'ut huhoont'i tune' hut'en, 'i ts'iyawh whus cho 'i bulh 'ilho ndunt'ah. 'Et huwa 'aw lhaoodoolneh wule ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","'Et whunts'ih ndai yun unzoo, 'i k'ut nanánkat, 'i ndez na'a njan nduwhutni, 'en huhóont'i 'et khunek hidants'o 'ink'ez budzi unzoo hoh hiyoontun. Nts'oh dahoont'ah whunts'ih 'ilhuz hiyilhchoot. 'Et whuz na'a bumai lhai tele. ");
INSERT INTO cafNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Dune too dezk'un 'ink'ez 'i nahidilhk'aih 'ink'ez 'aw 'oosa' yuk'uz koo naídoo'ah ghaít'ah. K'us kwusuti t'ah ts'ih whuyuh neyoo'alh ghaít'ah. 'Et nts'e too dezk'un, 'i hukw'usú'ai, 'et hukw'e yi'ai. 'Et sih ndunnah dahúndelh ts'iyawh 'i be hinoolh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ndez na'a 'et ndúhoont'ah, ndai nest'i, 'i whunts'ih nus de 'et ts'iyawh haootekulh. Ndai whu'iz 'uts'ulh'en hukwa' ts'ut'en, 'i 'et whunts'ih ts'iyannah t'ewhuntezeh. 'I ts'iyawh ndet whét'en, nus de ts'et haootekulh. ");
INSERT INTO cafNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","'Et soo cho howahli nts'e na'a ndi khunek dutéhts'o. Soo ts'ah'un 'alha ndunnah hoontsolyaz t'ehonínzun, 'en 'o nus lhat t'ehonínzun, 'et hubugha whútelts'ulh. 'Ink'ez ndunnah hoonli t'ewhunúszun, hoonts'olyaz 'uhudits'o, ndai 'aw 'i hiyít'i, 'i huninzun, 'et whunts'ih 'i bughu nayútelcholh.” ");
INSERT INTO cafNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","'Aw 'et be'ama 'ink'ez bulhutsinkah bulh, hits'un hukwa' hut'en. Dune hulan 'et huwa 'aw highah niooya ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bulunah ndi hiyulhni, “Nyu'ama 'ink'ez nyulhutsinkah bulh, 'az nahudelhúya, nyuhuntelh'ilh hukwa' huninzun.” ");
INSERT INTO cafNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","'Et ndo búlhni, “Ndunnah Yak'usda bughunek yoozélhts'ai 'ink'ez hik'une' 'ut'en, 'en se'ama 'ink'ez sulhutsinkah hinli, ho' hint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","'Et hukw'elh'az 'ilhuh dzin yugha hoodul'eh bulh ts'i be handel. 'Ink'ez “Nyan uztooke,” hubúlhni. 'Aw 'et nus níhuzki. ");
INSERT INTO cafNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nus nihuzki 'et Sizi 'ahoh nanesti. Khunyaz hubulh taoodelts'ut 'ink'ez 'aw 'et ts'i too be táduteh. 'Ink'ez tube wheóonujut hoh hube naints'i. ");
INSERT INTO cafNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","'Et ts'enahinílhts'ut, “NeMoodihti, neMoodihti, 'aw 'et too ts'uteghan!” hiyúlhni. 'Et ts'enahinílhdzut, 'ink'ez didinya hoh too k'ut nilhts'i 'i khunek ulhtus 'i be yuts'un nahezya. 'Et 'ahoh k'ah na'hooja 'ink'ez dínghel. ");
INSERT INTO cafNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","'Et ih, “Nuhwhuba 'alha' 'ust'ah, dáhooja?” hubúlhni. Ts'iyawh whehunelhújoot 'ink'ez huba hooncha. 'Et 'ulhódutni, “Ndun dune, 'en ndan unli ho' 'int'ah? Nilhts'i 'ink'ez tatsi 'i whunts'ih dah yúlhni, 'aw 'et yuk'une' 'ut'en.” ");
INSERT INTO cafNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","'Aw 'et Gadaren hubuyun k'ut yahuzki. 'Et njan 'et Galilee howanch'az whuz'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","'Et dehainya 'et 'ahoh dune 'et keyah whut'en yududezya. 'En sa whuts'un ntsi' nududeh, 'i lhai buyidélhts'i. 'En tsan 'et nuya, 'ink'ez 'aw koo chailah, 'et ts'un k'ut whut'i. ");
INSERT INTO cafNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","'Et Sizi yutelh'en hoh yuts'u hahuyih 'ink'ez yubut nacháneti. 'Ink'ez tube cho yuts'u tédudli, “Sizi nyun soo deghan doh Yak'usda buYe' 'unint'ah! Ndet suts'u hukwa' ninzun? Nts'u tedusdlih, dzuh nusilhdzut ilah!” ");
INSERT INTO cafNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","'Et 'uda ndi ntsi' ndudeh, 'i khunekti be ndo búlhni ndun dune ye yáhanadoodeh ka. Hoh da 'ut'es tl'ool be hiyulhghel bula 'ink'ez bukechun chah, 'et whuz na'a highunli inle. 'Et whunts'ih lhat hoh ndi ntsi' ndudeh, 'i yilhchukw hoh ndi 'ut'es tl'ool lhtánuduch'us 'ink'ez ndi ntsi' nududeh, 'i 'en dune chahóot'ih ts'ih whuz wheníyukw. ");
INSERT INTO cafNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","'Ink'ez Sizi 'en yoodulhkut, “Ndai nyoozi?” “Legion,” yulhni. Lhanah ntsi' nududeh, 'i ye yudúlts'i 'et 'utni. ");
INSERT INTO cafNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ntsi' nudúdeh, 'i Sizi hits'u tedudlih 'et nyo tsak'et whucho whutl'ah hoolah, whuz teh netólh'a gunih, hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","'Et goso lhai hoh 'onghun whenun núlh'as. 'Et ntsi' nududeh, 'i Sizi hits'u tedudlih goso hubuyídoodeh ka. 'Et hubutl'aho'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","'Et ntsi' nududeh, 'i dune, 'i buts'uh haídande hoh goso buyídande. 'Aw 'i bulh goso bulh wheghah helghaz 'ink'ez too buhanghan. ");
INSERT INTO cafNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","'Et ndunnah goso ghuhinli 'en dahooja honalh'en hoh ts'iyawh whehélghaz. Hedulh hoh keyah whunat whut'en 'ink'ez keyah whut'en ts'iyawh ndo badáni. ");
INSERT INTO cafNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","'Et ndunnah dune hodánts'o hoh 'et whuz whehándel 'ink'ez honalh'en. 'Et Sizi highu nindel hoh 'et ndun dune ndun ntsi' nududeh, 'i buts'uh hanaídede, 'en Sizi yuk'etl'a usda hoh hinalh'en. Naih be dune unli 'ink'ez beni chah bugha nádelts'ut hoh soo 'int'ah. Ts'iyawh hinalh'en 'ink'ez hunelhújoot. ");
INSERT INTO cafNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","'Et ndunnah dahooja honalh'en, 'uyoon chah hudáni 'et dahooja ndun ntsi' nududeh, 'i buyudínda 'aw 'et dujih. ");
INSERT INTO cafNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","'Et ndunnah Gadaren huwhut'en 'et whunat whut'en nduhóolhcho hoh whe hunelhújoot. 'Et huwa Sizi hubuch'a naooja hiyúlhni. 'Et ts'i be naja 'ink'ez hugho whenaduki. ");
INSERT INTO cafNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","'Et ndun dune ndi ntsi' nududeh, 'i buts'uh hanádide, 'en Sizi yuts'u tedudlih yulh útenilh hukwa' ninzun. 'Et whunts'ih Sizi whenáyalh'a 'ink'ez ndi yúlhni, ");
INSERT INTO cafNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nkoo ts'un naindalh 'ink'ez dáhoolcho hoh Yak'usda mba daja, ts'iyawh hubudóni.” 'Et whenaja 'ink'ez keyah ndulhcho hoh ts'iyannah Sizi dahoolhcho yuba' hóonla ts'iyawh 'et hubugha dune ndo budáni. ");
INSERT INTO cafNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","'Aw 'et nyan whenadúki. Ts'iyannah Sizi hikunúta hoh whusanaduki ts'iyannah huhóont'i hoh nahíyet'en. ");
INSERT INTO cafNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Soo yanasdúki ibulh 'ahoh dune Jairus yughu ninya. 'En Lizwif hubuluglez whumoodih 'int'ah. Yubut nachaneti 'ink'ez yuts'u tedudlih bukoo ts'ih yulh nátoot'as ka. ");
INSERT INTO cafNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","'Ilhunuh zeh butse', lanezi 'o 'at nat be naooduzuk bat'en. 'En 'aw 'et dáwhenintsai. Sizi, 'en Jairus bukoo ts'ih yulh nátest'az. 'Aw 'et 'ilhohuwezdel lhanah higha wézdel. ");
INSERT INTO cafNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","'Ilhunuh ts'eke tube dzuh nuzut lanezi 'o 'at nat naoodezulh 'et dúwhulyez hoh 'uskai 'iyúlh'en, yoo be dúyun lhanah chah hukwa' hiyalh'en. 'Et hukw'uz duzooneya ts'iyawh hoolah yulhtsi, 'et whunts'ih nus zeh lhe'enilh. ");
INSERT INTO cafNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ndun 'en ts'eke Sizi yut'ah ts'ih yughu ninya 'ink'ez nayits'uz, 'i yus ts'ih but'ah 'et yut'agheznai. 'Et 'ahoh uskai 'uyulh'en 'i 'ustl'e' 'uja. ");
INSERT INTO cafNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","'Et Sizi 'utni, “Ndan 'uja st'aghéznai?” “Ts'iyawh wheni ilah 'uts'uja,” hutni. Peter 'ink'ez ndunnah yulh 'ut'en, 'en 'uhutni, “Nemoodih lhe'huneltsuk nyunat hahúneldo 'ink'ez nyuhoolghas. 'Ink'ez di ka' dini ‘Ndan st'aghéznai?’ dini?” ");
INSERT INTO cafNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","'Et Sizi 'utni, “T'eoonuszun 'ilhunuh st'agheznai. Be ulhtus, 'i sts'u hadélts'ut 'et nt'eoonuszun.” ");
INSERT INTO cafNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","'Et ndun ts'eke t'eoonanzin 'aw yuch'á ntool'ih ghaít'ah. Dulduz hoh yughu ninya 'ink'ez yubut nachaneti. 'Et ts'iyannah nalh Sizi ndi yúlhni ndet huwa yut'agheznai 'ink'ez daja hoh 'ahoh soo ná'uja. ");
INSERT INTO cafNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","'Ink'ez ndi yúlhni. “Sútse' mba 'alha' hoont'ah 'et huwa soo na'inja. 'Aw 'et ndzi dezghel ho' 'unint'ah naindalh.” ");
INSERT INTO cafNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","'Et 'Awhuz ndun ts'eke yulh yalhtuk hoh Lizwif hubuluglez whumoodih bukoo usda, 'en yughu ninya 'ink'ez ndi yúlhni, “Ntse' dazsai. Whute ndun dune hoodulh'eh, 'aw 'o 'un dzuh nilhdzut ilah. 'Aw 'et dazsai ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","'Et Sizi yulh údants'o hoh Jairus ndi yúlhni, “Whenoljut gunih, njan 'et zeh mba 'alha' hot'e, 'ink'ez soo na'tetnilh ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","'Ink'ez bukoo ts'ih daninya. 'Et 'aw 'uyoon chah dachaóosya. Peter, James, John, 'ink'ez ndun 'uski be'abá 'ink'ez be'ama chah, 'en zeh dahóodelh. ");
INSERT INTO cafNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","'Et ts'iyannah tso yahalhtuk 'ink'ez hik'etedudlih. 'Et Sizi ndo búlhni, “Ahtso ilah! 'Aw dachaitsal 'ants'ih nanesti ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","'Ink'ez ts'iyawh highudloh, t'ehonínzun dazsai ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sizi ts'iyawh tinaóobunilh'a, 'ink'ez 'uski yula ilhchoot 'ink'ez, “Uski didinyih,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Buyégha buyunaídede 'ink'ez 'ahoh didinya. 'Ink'ez 'et 'obúlhni, “Hoonliyaz yute'alh, 'i bugha ináh'aih.” ");
INSERT INTO cafNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Be'ama 'ink'ez be'abá tube huba hooncha, 'ink'ez khunek ulhtus, 'i be ndo búlhni, “Uyoon dudóohtni gunih njan bulh nduhooja.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","'Et lanezi 'o 'at nanah yugha hoodul'eh, Sizi ts'iyawh buka' dani. Ntsi' nududeh, 'i ts'iyawh ndet whehílhtus chah, 'ink'ez himoodih wule ka, 'et hubugha óoni'ai. 'Ink'ez dune ndet hukw'e hunduda, 'et chah soo na'boohoolh'en, 'et chah hubugha óoni'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","'Uyoon nts'e na'a Yak'usda hubudayi cho unli 'et hubugha hubulh yalhtuk 'ink'ez nduda soo na'hubuhooleh, 'et wheni wheóobalh'a. ");
INSERT INTO cafNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","'Ink'ez ndo búlhni, “Nts'e tehdulh 'et ndi nuhtuz, k'us nuhwhu'ezdlai k'us lhes, k'us sooneya chah, 'et ndunt'i, 'i toohla gunih. 'Ink'ez nankoh dzoozt'an nyez, 'i waht'i gunih. ");
INSERT INTO cafNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ndet koo danáh'az, 'et zeh wahke, 'ink'ez 'et koo zeh whenádooht'as. ");
INSERT INTO cafNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","'Et ndunnah danáh'as 'aw chanwhadusnih t'eh, 'et keyah whunateht'us whutsah, 'et hubulez ch'a nuhwhuke naóohghat. 'I bugha t'ehonózin buk'ewhutelts'ulh 'et buts'uh whélts'ulh.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","'Et whenáhedel 'ink'ez keyah totsuk whutuh lhunáhusdel. 'Et whuz na'a dune khunek unzoo, 'i be hubulh yahulhtuk. 'Ink'ez keyah totsuk dune soo na'hulh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","'Aw 'et hubudayi cho Herod hiyulhni whulh uduzts'ai nts'oh teh Sizi ne'ut'en. Bulunah nduhútni, “John yaidla hubutah nakhitna, 'en 'int'ah,” hutni. 'Et huwa ba nawh 'uhooja. ");
INSERT INTO cafNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","'Ink'ez 'uyoon chah 'uhutni, “Ndun 'en Elijah 'int'ah hoh nenalhts'et hainya.” 'Et 'onghunnah chah nduhútni, “En 'uda yinkak Yak'usda be nus whunilh'en, 'ilhunuh nakhítna 'ink'ez 'en 'ut'en.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","'Et Herod 'utni, “John butsi k'unélht'o inle. 'Et whunts'i ndan hoh 'ut'en ndun lhe'hoont'ah teh ne'ut'en bulh 'údusts'o?” 'Ink'ez yuntelh'ilh hukwa' ninzun. ");
INSERT INTO cafNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","'Et ndunnah whel'a whusanáhedel hoh dahét'en, 'et ts'iyawh hidani. 'Ink'ez “Aw 'et uztoodelh!” hubúlhni, 'ink'ez njan Bethsaida keyah whunat dune nuchasyah ts'ih wheóobanla. ");
INSERT INTO cafNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","'Et whunts'ih 'ilhohuwezdel nahuhoon'ai hoh hiyuntezdel. 'Et Sizi hoont'i hoh highu nindel 'ink'ez nts'e na'a Yak'usda hubudayi cho unli hukw'un'a hubugha hubulh yalhtuk. 'Ink'ez ndunnah soo na'tetnilh hukwa' ninzun, 'en chah ts'iyawh soo ná'balh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","'Aw 'et ts'etniz hukw'elh'az ye'un whezulh 'ink'ez ndunnah lanezi 'o 'at nanah, 'en highu nindel 'ink'ez 'uhiyúlhni, “Ndunnah 'ilhohuwezdel nabalh'alh njan dune nuchasyah 'uts'int'ah. 'Et ndo ho keyah whunat hiya'alh, 'i hoket 'ink'ez 'et hutetez chah nahohólelh sih.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","'Et whunts'ih Sizi ndo búlhni, “Hoonliyaz hiyoo'alh, 'i hubugha naínuht'aih.” 'Et 'uhiyulhni, “Lhook nankoh 'ink'ez lhes skwulai chah, 'aw 'i zeh ts'ít'i. 'Et ndunnah 'ilhohuwezdel ts'uyi, 'i huba ts'onket t'eh, 'et zeh soo hubugha ná'uztet'alh.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","'Et njan 'ilhohuwezdel 'ankw'us 5,000 dune hinli. 'Et Sizi yugha hoodul'eh ndo búlhni, “Skwunlat lanezi hinli hoh (50) lhendun natl'ahudoolts'ilh budáhni.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","'Et whuz na'a 'uhuja. 'Aw 'et ts'iyawh natl'ahudelts'i hoh ");
INSERT INTO cafNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","'et skwulai lhes yilhchoot 'ink'ez lhook nankoh chah, 'et nduk yutá'en 'ink'ez suchanailya ni hoh yuba tenadedli. 'Et taidalhkut 'ink'ez yugha hoodul'eh butl'ayánla, 'ilhohuwezdel hubugha híyo'alh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ts'iyawh 'uha'al 'ink'ez soo' na'hunesdai hoh ndai ts'utezkat, 'i ts'iyawh 'ilunahíwezdla hoh lanezi 'o 'at nankoh k'its'ai cho dezbun. ");
INSERT INTO cafNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","'Et hukw'elh'az Sizi dich'oh zeh tenadedli 'ink'ez higha hoodul'eh hiyulh 'ut'en 'ink'ez huboodulhkut, “Ilhohuwezel, 'en ndan usdli hutni?” ");
INSERT INTO cafNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","'Ink'ez 'uhiyúlhni, “John dune too be 'ulh'en 'int'ah hutni. 'Et 'onghunnah Elijah 'int'ah hutni. 'Ink'ez 'onghunnah 'uhutni 'uda nus whunilh'en, 'ink'ez 'ilhunuh dinadija, 'en 'int'ah, hutni.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","'Et, “Nuhwheni do?” hubúlhni, “Ndan usdli dahni?” Peter yatelhtuk hoh ndi yúlhni, “Ndun Yak'usda buChrist ts'utni, 'en 'unint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","'Et khunekti be ndo búlhni, “Khun teh 'uyoon dóohtni gunih!” ");
INSERT INTO cafNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","'Ink'ez ndo búlhni, “Yinkak dune ye' lhat whé dzuh nutezut buba 'uhoont'ah. 'Ink'ez ndunnah tsuh whudelhdzulh, nawhulnuk degha nus dézti, 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz chah, 'en ts'iyawh hich'a dutétni ho' hint'ah 'ink'ez 'et hituzelhghelh. 'Ink'ez whulh tat dzin dinadutédalh.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","'Ink'ez ts'iyawh 'úbulhni, “Ndan dune se'ut'en k'ah ts'ih oot'en ka hukwa' ninzun, 'et ndunt'ah ndai dats'ínt'ah, ts'iyawh whuladootnih 'ink'ez dzin totsuk dulhdulalhgus yóolhchoot 'ink'ez suntooya. ");
INSERT INTO cafNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","'Et huwa ndunnah hoh húkhuna hotelhyih, 'en 'et whunts'ih tinta hoté'alh. 'Et whunts'ih ndan ye khuna si sugha tinta ooni'ai t'eh, 'en hoh ye khuna hotelhyih. ");
INSERT INTO cafNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","'Et dune ndi yun k'ut nduhoolhcho whuch'a oonilhde t'eh, 'et whunts'ih dich'oh ye khuna tinta ní'ai k'us ye khuna yugha nahootélchulh t'eh, 'et ndet simba whuch'a hólhdeh? ");
INSERT INTO cafNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","'Et k'us ndan dune si, 'ink'ez sughunek 'i yukaya unli, 'et nket'ah yinkak dune ye', nts'o t'eh 'i be'aBá 'ink'ez Yak'usda bulizas hiye dezti chah, 'i 'et whuz na'a whusanaja t'eh, 'et sih ndunnah dune hukwayá tele. ");
INSERT INTO cafNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","'Alha 'un whudusni, bulunah njan nuhudelhúya ndet dahutetsah 'et whuts'un, ndet Yak'usda hubudayi cho unli, 'et dahutetsah whutsuh hote'ilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Lhk'udit dzin bat'en hukw'elh'az 'et njan ndutni, 'et Peter, John, 'ink'ez James ndoh dzulh k'uz dulh wheóobeldel whuz tenadutedli ka. ");
INSERT INTO cafNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","'Et 'awhuz tenadudli hoh 'et bunen ts'ih 'uts'un be hoonet'en suli. 'Ink'ez bunaih chah soo ts'ah'un lheyul suli, 'ink'ez buts'uh ha'ánduz suli chah 'uja. ");
INSERT INTO cafNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Khunyaz nanah dune, 'en hiyulh yálhtuk. 'Ilhunuh Moses 'ink'ez 'ilhunuh Elijah. ");
INSERT INTO cafNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Whet'en buts'uh hayánduz 'i be hóodet'en. 'Et Jerusalem ts'ih datenilh hoh datétsah lhaóodutelilh, 'et huwa hubulh yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","'Et Peter 'ink'ez hiyulh 'ut'en sa tube hantez. 'Et ts'ah'un na'a ts'enawhehunide hoh 'et Sizi buts'uh hayánduz, 'i nanah dune yuzih siyin hoh hitelh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","'Et hukw'elh'az highu when'az hoh Peter, 'en Sizi ndi yúlhni, “Nemoodih hoonzoo njan uzdelhts'i. Tat whut'ah uztetez 'uts'uhooleh. 'Ilhunuh nyun mba, ilhunuh Moses ba, 'ink'ez 'ilhunuh chah Elijah ba.” 'Et whunts'ih Peter daja dutenilh 'aw t'eoonuszun. ");
INSERT INTO cafNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Awhuz yalhtuk hoh kw'us buk'eyínde. 'Et kw'us hubunanezdo hoh 'et whe hunelhújoot. ");
INSERT INTO cafNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kw'us tah ts'ih khunek huduzts'ai, “Ndun suYe' 'en buk'esi' 'int'ah. 'En oozólhts'a,” ni. ");
INSERT INTO cafNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","'Et yatuk 'ustl'e' 'uwhudeja hoh Sizi dich'oh zeh 'int'ah hinilh'en. 'Et 'aw hoonliyaz cha'hudínil ndet hohon'en. 'Et hoh da dzin 'aw dune nduchahudinil nts'e na'a hinalh'en 'et. ");
INSERT INTO cafNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","'Et 'om bun dzin dzulhyaz k'ut ts'ih hanáhedel hoh 'ilhohuwezdel Sizi hidudezdel. ");
INSERT INTO cafNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","'Ilhunuh dune 'ilhohuwezdel hubutah, 'en Sizi 'últus be yuts'u háyih hoh njan ndi yulhni, “Nehodilh'eh nts'u tédusdlih suye' nolh'en. 'En 'aw 'en zeh 'ilhunuh suye' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","'Et khunyaz ntsi' nududeh, 'i yilhchuk ibulh hazulh, bukaootuzuk, 'ink'ez huwus buza hanúldoh. 'Et huwa ndulhcho hoh bukaootúzuk. 'Ink'ez tube howa whúlna hoh yeyáhanadudoh. ");
INSERT INTO cafNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","'Et nye hódul'eh hubuts'uh tédusdli hits'uh hanáhidoolhdeh ka, 'et whunts'ih 'aw 'uhooneh ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","'Et sizi 'utni, “Nuhwheni k'an ndoh whudezulh 'alha 'i be nuhwhuba 'alha' cha'hoot'ah. Nuhwheni dune 'aw ts'ah'un cha'it'ah ahli. Dawhuldzah nuhtah 'utest'ilh hoh nohwhulh whúsyin? Nye' suts'ílhtelh!” ");
INSERT INTO cafNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","'Et 'awhuz Sizi ts'un yelhtelh hoh ndi ntsi' nududeh, 'en 'uski nayáno 'ink'ez yukaootelhzut. 'Et Sizi ntsi' nududeh, 'i khunekti be hukwa' yudáni, 'ink'ez 'uski soo na'uja hoh bu'abá yutl'anáyalhti. ");
INSERT INTO cafNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","'Ink'ez Yak'usda daltus 'et huwa ts'iyannah huba hooncha suli. 'Ink'ez Sizi nts'oh tune'ust'en huba hooncha k'et, 'aw buk'eóodoozit ghaít'ah. Hoh da zeh yugha hoodul'eh 'en 'úbulhni, ");
INSERT INTO cafNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ndi khunek be nohwhulh yatelhtuk, soo cho nuhdzi be wheoodoolts'it. 'Aw 'et nilhdukw yinkak dune ye', 'en dune ntsi' tl'aduteltelh k'une' hitel'ilh ka.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","'Et whunts'ih njan daja ni 'aw ts'ah'un t'echahonízil. 'Aw huba ts'et ka hachahóolts'ulh. 'Et huwa daja ni, 'aw ts'ah'un nachahuhoo'al. 'Et whunts'ih whehúnuljut, 'aw hukwa hiyoodolhkut ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","'Ink'ez hedich'oh lhtah 'ulhadutni, k'us ndan degha nus uncha tele. ");
INSERT INTO cafNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Hubudzi yuh daja huninzun 'et Sizi t'eooninzun. 'Et huwa 'ilhunuh 'uskiyaz yílhchoot 'ink'ez buzih ninílhti. ");
INSERT INTO cafNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","'Ink'ez ndo búlhni, “Et soo ts'ah'un na'a 'un whudusni, ndunnah soozi bugha ndun 'uskiyaz hik'esutset, 'en sk'ehintsi' ho' hint'ah. 'Ink'ez ndunnah sk'esutset, 'en ndun whuz de sútelh'a, 'en chah hik'esutset ho' hoont'ah. 'Et huwa, ndan nuhtah degha nus dune ba tel'en, 'en degha nus ncha tele.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","'Et John ndi yúlhni, “NeMoodihti 'ilhunuh dune nyoozi be ntsi' nududeh, 'i dune buts'uh hanaídulhdoh, 'et ts'uho'en. 'En 'aw nelh 'ilhunuh chailah, 'et huwa 'et ndut'en whuch'az nényoot.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","'Et whunts'ih Sizi ndi yúlhni, “Whuch'a' nehyoot ilah! 'Alha ndan 'aw nech'a chahuditni, 'en nets'ú détni 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","'Aw 'et Sizi buba whusahonzut nduk yak'uz nátedalh huba, 'aw 'et Jerusalem whuts'u nalhú'a 'ink'ez whuz natedalh howun nanínuzut. ");
INSERT INTO cafNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Khunek yuba na'a dutsuh wheoobalh'a. 'En hutezdel hoh 'aw 'et 'ilhunuh Samaria keyah ts'ih hunindel hiba lhaoodutelilh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","'Et whunts'ih Jerusalem ts'ih tezya 'et nahuhoo'ai hoh njan keyah Samaria whut'en 'aw hikacha'nízun. ");
INSERT INTO cafNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","'Et yugha hoodul'eh James 'ink'ez John honalh'en bulh dahooja hoh Sizi hiyoodulhkut, “NeMoodihti Elijah k'una'a ndi kwun ndus de yak'uz ts'ih hadóonat 'ink'ez ts'iyawh hadóok'un uzdooni, 'et ih neba hukwa' ninzun?” ");
INSERT INTO cafNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","'Et whunts'ih hubuts'un nalhú'a 'ink'ez hukwa' hubudani, 'ink'ez 'utni, “Aw daja nahzun nt'ewhunuzáhzun 'et huwa' dahni! ");
INSERT INTO cafNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Soo cho soo zélhts'ai, yinkak dune ye', dune ye khuna hoolah yutelhtsilh ka ilah whusainya, hubutelhyih ka whusainya.” 'Ink'ez 'et 'udun keyah whuyaz ts'ih whehándel. ");
INSERT INTO cafNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","'Aw 'et ti hedulh hoh 'ilhunuh dune Sizi yughu ninya 'ink'ez ndi yúlhni, “SMoodihti nts'e ténya ts'ih 'ilhuz nyun tesyalh.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","'Et Sizi ndi yúlhni, “Nanguz 'en chah 'an whut'i ho' 'int'ah 'ink'ez dut'aiyaz chah t'o ut'i. 'Et whunts'ih yinkak dune ye', 'aw netsin tet'alh 'et whunts'ih chahóot'ih.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","'Et 'uyoon chah 'ulhni, “Nyun chah sunanyalh.” 'Et whunts'ih ndi yúlhni, “SMoodihti, k'at 'udechoo se'abá buyust'e wheyútelhtelh choo.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","'Et whunts'ih Sizi ndi yúlhni, “Whute dudulh yahadla didutch'oh wheyúnalhuhoolyelh. 'Et whunts'ih nyun ndulhcho hoh nónya 'ink'ez ndi Yak'usda hubudayi cho unli, ts'iyannah 'et hubugha dóni.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","'Et 'uyoon chah 'utni, “SMoodihti nyun tesyalh, 'et whunts'ih 'udechoo sukoo hudelhts'i ts'ih hubuts'un nunatesda choo 'ink'ez 'ilhuz wheni nuhghu tesyalh budutésnilh, 'et stl'ahóo'aih.” ");
INSERT INTO cafNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","'Et whunts'ih Sizi ndi yúlhni, “Ndan wheoonilhch'ul 'ink'ez k'ah naidutut'ih t'eh, ndunt'ah ndet Yak'usda hubudayi cho unli, 'et 'aw huba soo cha'hit'ah ho' hint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","'Et hukw'elh'az neMoodihti skwunlai 'o 'at lanezi (70) 'en 'utaháoobanla keyah whuti totsuk nuteyalh, nanah hinli hoh dutsuh wheoobalh'a. ");
INSERT INTO cafNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","'Et ndo búlhni, “Alha 'aw 'et há' nukat newhúninzut 'ink'ez tl'o mai lhai suli, 'et whunts'ih 'uhut'en, 'en 'aw soo a'huneltsuk. 'Et huwa Yak'usda ba ha'nukat whumoodihti, dich'oh 'a'dunenla 'uyoon chah 'uhut'en whuz haóobalh'a, 'et huba tenadehdli. ");
INSERT INTO cafNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","'Aw 'et ahdulh 'ink'ez soo zélhts'ai! Lhe'un whusla 'ants'i Sheep k'una'a yus tuz whenwhalh'a. ");
INSERT INTO cafNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","'Aw sooneya zuz, k'us 'ezdlai, k'us kegwun chah, 'i ndunt'i, 'i toohla gunih. 'Ink'ez ti dune dudéh'az t'eh, khun teh dahooja dóohni gunih. ");
INSERT INTO cafNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ndet koo danáhya t'eh, 'et koo hudelhts'i njan ndo budoohni choo, nuhkoo whudóoghel wule. ");
INSERT INTO cafNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","'Et dune t'edusnih 'et usda t'eh, 'et nuhdzi dezghel 'et butl'á whutelts'ulh. 'Et 'aw ndunt'ah hoolah t'eh, be nuhdzi dezghel 'i nuhts'u nádutelts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","'Et koo zeh wahke. Ndai nuhgha híya'aih 'i zeh wah'alh 'ink'ez wahnai. 'Alha ndun 'ut'en bube 'ut'en, 'en k'elha hole huba' hoont'ah. 'Ink'ez lhelhdun koo teh danaóohdaih gunih. ");
INSERT INTO cafNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","'Ink'ez nts'e 'udun keyah lhgha dah'az, 'et 'anih nuhwháh hutni t'eh, 'et ndai nuhbut nehininla, 'i wah'alh. ");
INSERT INTO cafNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","'Et ndan 'et koo nduda, 'en chah soo na'ubóohleh 'ink'ez ndo budóohni, ‘Yak'usda hubudayi cho unli, 'aw 'et nuhwhughah 'uhoont'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","'Et nts'e keyah lhgha dah'az, 'et 'aw nuhghu nuchahíyal t'eh, 'et ti k'enaoohja, 'ink'ez 'udoohni, ");
INSERT INTO cafNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘'Et njan nuhkeyah whulez, ndai neke ghu hoonli, 'i whunts'ih, nuhch'a búna'ts'alhde. 'Et whunts'ih t'ewhunóhzin huba' hoont'ah, Yak'usda hubudayi cho, 'et nuhwheghah 'uhoont'ah,’ 'et hubudóohni. ");
INSERT INTO cafNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","'Alha ts'ah'un 'un whudusni, 'et dzin whusaootelts'ulh, 'et keyah Sodom whut'en, hoh da nts'e na'a hubulh dahooja inle, 'et njan keyah whut'en, ndunnah nuhka cha'nízun, 'en 'o nus hoontsi' hubugha óotelts'ulh.” ");
INSERT INTO cafNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Et nuhwheni Chorazin whut'en, 'ink'ez nuhwheni Bethsaida whut'en, nuhwheni chah 'aw 'et dawhultsi' 'et nuhts'u whélts'ulh! Soo cho soo zélhts'ai, ndet hoolhtus nuhnat 'uhooja, ndunnah Tyre 'ink'ez Sidon whut'en, 'en bunat 'et chah 'et ndúhooja t'eh, 'uda hubeni náhondunezdla wule. 'Ink'ez doso be hudelhts'i 'ink'ez lhusts'iz k'enahidudzih. 'Et whuz na'a 'uhooneh wule. ");
INSERT INTO cafNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","'Et dzin nuhwhuba whuz de whélts'ulh nuhwhuba nahutedeh ka, 'et ndunnah hubulh dawhutenilh, nuhwheni 'o nus nuhwhuba whutétsi'. ");
INSERT INTO cafNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","'Et nuhwheni Capernaum whut'en nduk koo huba soo áht'ah nahzun ih? 'Awundooh! 'Et k'us kwuncho yuh ts'ih nóhotelhdulh! ");
INSERT INTO cafNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","'Ink'ez nuhwheni sutsuh tehdulh ndunnah nuhoozelhts'ai, 'en si chah soo hoozelhts'ai. Ndan ch'a nuwhunehsjoot, si chah ch'a sunésjoot ho' hoont'ah. 'Ink'ez ndan ch'a sunésjoot, ndun whuz de sútelh'a, 'en chah ch'a inésjoot ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","'Et hukw'elh'az skwunlai 'o 'at lanezi (70) huhoont'i hoh whusanáhedel. 'Et nduhúyulhni, “NeMoodihti ndunnah ntsi' nududeh, 'i 'en whunts'ih, nyoozi bugha nek'une' hut'en!” ");
INSERT INTO cafNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","'Ink'ez ndo búlhni, “Satan, 'en ditnik kwun hadanat k'una'a ndus de yak'uz hadélduz, 'et nalh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sih soo zélhts'ai, tl'ughus 'ink'ez poison unli, 'i scorpion hiyulhni, tube cho buk'unahya. 'Ink'ez ndai nuhch'a detni, 'en hiye ulhtus, 'i 'et ts'iyawh ndi bugha ndoh 'ooht'e, 'et nuhtl'ahó'ai 'ink'ez 'aw hoonli nuhwhundóolhda ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","'Et whunts'ih ntsi' nududeh, 'i nuhk'une' 'oot'en huba 'int'ah, 'aw 'et huwa ilah whunélhnik. 'Et k'us nduk yak'uz nuhoozi ts'iyawh 'uk'une'úsduguz, 'et huwa zeh whunóolhnik.” ");
INSERT INTO cafNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","'Et hoh wheghah 'uhunet'oh Sizi, 'en Ndoni be whunélhnik hoh njan ndutni, “ABá nyun 'un yudúsni! Yak'uz 'ink'ez yun k'ut huMoodihti inli. Whunih 'ink'ez hodul'eh, ndi 'i ts'iyawh buch'á whunte'i. 'Et whunts'ih 'uskiyaz li'int'ah, 'en bunalhts'et haho'ai. 'Alha 'aBá mba soo 'uhooja. ");
INSERT INTO cafNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Se'aBá ts'iyawh stl'ahónla, 'ink'ez 'en buYe' ndan unli ts'iyannah t'ehonízun. Be'aBá 'aw 'en zeh t'eininzun. 'Ink'ez ndun be'aBá unli, buYe' 'aw 'en zeh t'eininzun. 'Ink'ez ndun buYe' 'onghunnah wheóobuntelhtun hukwa' ninzun t'eh, 'en zeh buba 'uhoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","'Ink'ez yugha hoodul'eh hubuts'un nalhú'a 'ink'ez whu'ízyaz ndo búlhni, “Ndet hoh'en 'uyoon duna be honilh'en, 'en degha nus hoonzoo hubugha whults'ut. ");
INSERT INTO cafNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ndun whudusni, lhanah nus whunilh'en, 'ink'ez hubudayi cho chah 'en dalcho 'i be ndet hoh'en hote'ilh hukwa' huninzun, 'et whunts'ih 'aw chahuhóo'il. 'Ink'ez ndet whudáhts'o 'enychah hidutéts'o hukwa' huninzun 'et whunts'ih 'aw cha'hudits'il.” ");
INSERT INTO cafNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","'Et hukw'elh'az 'ilhunuh Moses be' dustl'us k'ut, daja ni hoh beni hoonli be yalhtuk, 'en didinya 'ink'ez Sizi 'aoonilhka yoodulhkut, “Nehodulh'eh datest'ilh hoh 'ilhuz be ts'ukhutena, 'i whutélhcholh?” ");
INSERT INTO cafNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","'Et Sizi 'utni, “Ndet hukw'e'éduguz Moses be' dustl'us k'ut? Buk'eyáilhtuk hoh nts'e na'a mba daja ni?” ");
INSERT INTO cafNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","'Et ndi yulhni, “Ndez na'a njan ndutni, ‘Yak'usda nyuMoodihti ndzi ndulhcho 'i be, nzul ndulhcho 'i be, nyunut'uk ts'iyawh 'i be, 'ink'ez nyeni ts'iyawh 'i be chah, 'et whuz na'a 'en buk'eoontsi'. 'Et dáhoont'ah hukw'u na'a nyunch'oh k'enaindútsi', 'et whuz na'a zeh nyenghoh whut'i 'en chah buk'eoontsi'.” ");
INSERT INTO cafNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sizi ndi yulhni, “Soo ts'ah'un 'udini. 'Et ndint'en t'eh, 'et 'ilhuz wheni khutanalh.” ");
INSERT INTO cafNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","'Et whunts'ih ndun dune ts'ah'un 'int'ah na'dudil'i. 'Et hubugha Sizi yoodulhkut, “Ndan sughah whut'i?” ");
INSERT INTO cafNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","'Et Sizi njan di yulhni, “Ilhunuh dune Jerusalem ts'ih hainya 'ink'ez Jericho ts'un úyalh hoh 'uhundunut'ih hiyílhchoot. Bunaih ts'iyawh higha hahíyulya 'ink'ez nukai hiyulhtsi, 'et nehinílhti, 'ink'ez higho whenádel, 'aw 'et dawheníntsai. ");
INSERT INTO cafNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Soo hoh da zeh 'ilhunuh náwhulnuk ti uyalh hoh ndun 'en yutelh'en. Yutelh'en hoh 'ants'ih yagha nch'az lhusiya. ");
INSERT INTO cafNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","'Ink'ez doo chah 'ilhunuh dune Levi yuts'uh hainzut, 'en chah hoh uyalh 'et yunalh'en 'ink'ez 'ants'ih yugha nch'az lhusiya. ");
INSERT INTO cafNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","'Et whunts'ih 'ilhunuh Samaria whut'en, 'en chah hoh uyalh 'et yutelh'en 'ink'ez 'aw 'et yugha te'nanzin. ");
INSERT INTO cafNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yughu ninya 'ink'ez khe yuk'eyílhdze 'ink'ez mai too bulh yuka' dalh'oo. 'Et dughunai k'eyílhti 'ink'ez dune ts'uztez bakoo ts'ih wheyalhti, 'et yughunli. ");
INSERT INTO cafNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","'Et 'om bun dzin teyalh whutsuh nankoh sooneya ts'uztez whumoodih tl'aya'ai 'ink'ez ndi yúlhni, ‘Bughonle. 'Ink'ez ndai 'o 'un buk'uz ts'iya silhtsi t'eh, 'et whusanásja, 'et sih mba k'elha hólhtsilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","'Et Sizi 'ilhunuh Moses be' dustl'us k'ut, daja ni hoh beni hoonli be yalhtuk, 'en yoodulhkut, “Et ndun dune untsi' 'ankw'us hizelhghi, 'et ndunnah tanah dune hinalh'en da, 'et k'us ndan soo ts'ah'un na'a yeghah whut'i 'int'ah ninzun ih?” ");
INSERT INTO cafNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","'Et ndi yúlhni, “Ndun yugha te'nezit, 'en 'int'ah!” 'Et Sizi ndi yúlhni, “Aw 'et inyalh 'ink'ez nyun chah whuz na'a zeh 'et ndónt'en!” ");
INSERT INTO cafNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","'Et hukw'elh'az hedulh hoh Sizi 'udun keyah ninya 'ink'ez ts'eke Martha hiyulhni, hubukoo ts'ih yughun seya. ");
INSERT INTO cafNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Bulhtus Mary hiyulhni, 'en chah Sizi yukétl'ah usda 'ink'ez yughunek yoozélhts'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","'Et whunts'ih Martha nts'e na'a hubugha ná'tet'alh 'et tube 'unest'it. 'Et Sizi yughu ninya 'ink'ez ndi yúlhni, “SMoodihti 'ants'ih mba 'uhoont'ah ih sulhtus sich'oh zeh 'et nesunilhti buba'oost'en ka? Sula oot'en dini!” ");
INSERT INTO cafNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","'Et whunts'ih Sizi ndi yúlhni, “Martha Martha lhat teh howu ndzi nduda 'ink'ez howu nuni ninzut! ");
INSERT INTO cafNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","'Et whunts'ih 'aw 'ilhunuh zeh degha nus nduts'ooneh huba' hoont'ah. 'Et Mary degha nus hoonzoo 'utahahó'ai ho' hoont'ah 'ink'ez 'aw bula k'ehahólts'it ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","'Et 'ilhut dzin, Sizi tenadudli. 'Istl'e' deja hoh 'ilhunuh yugha hoodul'eh 'uyúlhni, “John nts'e na'a yugha hoodul'eh huboodalh'i, nyun chah whuz na'a tenazdutedli whuneoodilh'eh.” ");
INSERT INTO cafNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","'Et ndo bulhni, “Njan ndudáhni hoh tenadoohdli, ‘Ne'aBá yak'uz sinda. Nyoozi dooti. Dahoont'ah hoh hubudayi cho inli, 'et chah nets'ó toolts'it. 'Ink'ez ndet yak'uz ts'ih hukwa' ninzun dahooja, ndi yun k'ut chah, 'et whuz na'a zeh 'et ndúhoneh. ");
INSERT INTO cafNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ndai k'an dzin ts'uté'alh, 'i negha ní'aih. ");
INSERT INTO cafNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","'Ink'ez 'uyoon bulh dulhyah ts'uwhulh'ai t'eh, buba whunats'odoolnah. 'Et whuz na'a zeh nelubeshi neba whunaoodoolnah. Nts'e tink'us ts'unint'uk whuch'a neghinli. 'Ink'ez ntsi' 'en ch'a neghinli.” ");
INSERT INTO cafNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","'Ink'ez Sizi ndo búlhni, “Nuhwheni nuhtah ndan 'int'ah bulh dune hoonli 'ink'ez tuzniz buts'u téhyalh 'ink'ez 'udutéhnilh, ‘Sulh dune lhes tak'i sughu sinla! ");
INSERT INTO cafNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Njan sulh dune 'ilhunuh sughu ninya. Nilhza ts'ih hainya, 'aw bugha yóos'alh, 'i hoolah,’ yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","'Ink'ez bukoo whuts'un idóoni, ‘'Aw sugha ghínai ilah. Ndati 'aw 'et dana'délts'ut ho' hoont'ah. Suzkehkah ts'iyawh nahunéstez. 'Aw dinadóosja ghaít'ah. 'Ink'ez hoonliyaz ngha óos'alh ghaít'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","'Et ndun whudusni, 'aw dinadóoja ghaít'ah 'ink'ez hoonliyaz yugha óo'alh ghaít'ah, bulh dune 'int'ah 'et whunts'ih. 'Et whunts'ih 'awhuz yoodulhkut zeh 'utni, 'et huwa dinádutédalh 'ink'ez ndai yuka' ninzun ts'iyawh yugha itélelh. ");
INSERT INTO cafNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","'Et whuz na'a 'un whudúsni, Yak'usda ndai buka yoodulhkut, 'i nuhgha ité'alh. Bukunáhta 'ink'ez nahootéh'alh. Ndati whudulhghalh 'ink'ez nuhwhuba dá'dutetilh. ");
INSERT INTO cafNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","'Et ndunnah Yak'usda hoonli hits'u hukwa 'utni t'eh, 'en 'et bugha whútekulh. Ndunnah hoonliyaz hukwunúta, 'en nahuhooté'alh. 'Ink'ez ndunnah ndati whudulhghalh, 'en chah huba dá'dutetilh. ");
INSERT INTO cafNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ndunnah nuh'abákah nuhtah, buye' lhes yuts'u ka 'utni t'eh, 'aw tse yutl'adóo'alh ghaít'ah. K'us lhook yuts'u ka 'utni t'eh, 'aw 'i gha tl'ughus yutl'a oolelh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","K'us ligok ghez yuts'u ka 'utni t'eh, 'aw 'i gha ntsi' neoolht'ah, 'i scorpion hiyulhni, 'i yutl'ayóolhtelh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","'Et njan nduhoont'ah, nuhwheni lubeshi 'ulh'en ahli, 'ink'ez t'eoonáhzun nts'e na'a unzoo, 'i nuwhuzkeh hubugha itéhlelh. 'Et dáwhulcho, 'i be 'o nus nduk yak'uz nuhwhe'aBá, k'us ndan yoodulhkut, 'en Ndoni hubugha íte'alh.” ");
INSERT INTO cafNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","'Aw 'et ndi ntsi' nududeh buyudínda 'aw yaoolhtuk ghaít'ah hoh Sizi dune yuts'ah hanaínanyoot. 'Et yuts'ah hanaínanyoot hoh dune yalhtuk 'aw 'et yawhenilhtuk. 'Et 'ilhohuwezdel ts'iyawh huba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","'Et bulunah nduhútni, “Beelzebul ndun ntsi' nududeh bumoodih, 'en be ntsi' nududeh dune yuts'u hanainanyoot.” ");
INSERT INTO cafNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","'Et 'uyoon hiyoolhdzih hoh hiyoodulhkut, “Yak'uz ts'ih whuts'un neba huwa 'et'en tune' tant'en ih, 'et whunenilhtun?” ");
INSERT INTO cafNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Daja huninzun t'eooninzun, 'et ndo búlhni, “Nts'e hubudayi cho hinli, 'en lhch'a nihúdendel t'eh, 'en ts'iyawh huhoolah hutele. 'Et whuz na'a zeh 'ilhunuh bukoo delhts'i, 'en chah lhch'a nihúdendel t'eh, 'en chah huhoolah hutele. ");
INSERT INTO cafNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","'Et whuz na'a zeh nts'e Satan hubudayi cho unli, 'et dich'oh lhch'a nidinja t'eh, nts'e na'a buk'úne' whut'en tele? Lhe'dahni Beelzebul 'en be ntsi' nududeh, 'i dune ts'ah hanánusyukw dahni. ");
INSERT INTO cafNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","'Et si Beelzebul 'en be 'ust'en t'eh, 'et sudahni nuhwheni nuhye'kah k'us ndan be simba ntsi' nududeh, 'i dune ts'ah hanaóobunooyukw? 'Et huwa 'en bugha t'ewhuntehzeh tink'us údahni! ");
INSERT INTO cafNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","'Et whunts'ih Yak'usda bulasgek be ntsi' nududeh, 'i dune ts'ah hanánusyukw t'eh, 'et 'alha' hoont'ah, nts'e Yak'usda hoh hubudayi cho unli, 'aw 'et nuhghu whults'ut ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","'Et dune ulhtus lhahutedughan huba lhahudint'ah, 'et bukoo huwunli 'ink'ez ndai 'et yuzdla, 'i 'aw but'aghóohnalh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","'Et 'uyoon yugha nus 'ultus yundélhda 'et yuch'a' nilhde. 'Et dune ye lhuhutughan, 'i yut'aninintan, 'i ts'iyawh hubugha hayulya. 'Et hukw'elh'az ndun buch'a' ninde, 'en ndai 'et yuzdla, 'i chah ts'iyawh 'uyoon ba lhk'eyanla 'ink'ez butainínla. ");
INSERT INTO cafNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ndunnah sulh cha'it'ah, 'en such'a hudetni ho' hint'ah. 'Ink'ez ndunnah 'aw dune sula 'ilhuchawesdle, 'en ts'iyawh yadutékulh. ");
INSERT INTO cafNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Et ntsi' nududeh, 'i dune ts'ah hanádide hoh, yun whudezgi 'et whuz nududeh natelyis hukwu núta. 'Et 'aw nduhóont'ah nachahoo'al 'et dich'oh na'dudútni, ‘'Et ndun buyudúsda, whuz zeh natoosja.’ ");
INSERT INTO cafNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","'Et whuz lhghu nadidaih 'ink'ez 'et nahoo'aih ndun dune budzi yuh chaoodítsun nawhulhtsi 'ink'ez ts'ah'un na'uja. ");
INSERT INTO cafNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","'Ink'ez 'et 'uts'un whedudoh 'ink'ez skwunlai 'o 'at nankoh ntsi' nududeh, 'i 'en 'o nus 'iltsi', 'en 'et dune ye yuná'dudoh 'ink'ez 'et nihúnih. 'Et ndun dune ndun hiyudúlts'i, 'en 'et whutsuh da 'o nus 'ultsi' suli.” ");
INSERT INTO cafNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","'Et Sizi njan ndutni hukw'elh'az, 'ilhohuwezdel hubutah 'ilhunuh ts'eke yuts'uh hahúyih, “Ndun buchan yuts'uh hainzut 'ink'ez ndun nye 'alht'ukw, 'en ts'eke degha nus hoonzoo bugha whults'ut,” ni. ");
INSERT INTO cafNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","'Et whunts'ih Sizi ndi yúlhni, “Et degha nus hooncha 'uhoont'ah, k'us ndan Yak'usda bughunek yudits'o 'ink'ez yoontun, 'en degha nus hoonzoo hubulh 'uhooja!” ");
INSERT INTO cafNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","'Et 'ilhohuwezdel lha'un teh nus lhe'huneltsuk 'ink'ez ndo búlhni, “Njan k'an whudezulh dune, 'en hintsi'. 'Et hoonliyaz hooncha tune' whut'en 'et zeh huwhuntelh'ilh hukwa' huninzun. 'I bugha t'ehonóozin. 'Et whunts'ih 'aw honilh'en bughá holts'it ghaít'ah. 'Et nts'e na'a nus whunilh'en Jonah bulh dahooja, 'et zeh hote'ilh. ");
INSERT INTO cafNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","'Alha nts'e na'a Nineveh whut'en, 'en Jonah be huba whehóodal'en inle, 'et whuz na'a zeh 'en k'una'a k'an whudezulh dune, yinkak dune ye', 'en be huba whehoodel'en tele. ");
INSERT INTO cafNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Njan dzin dune ba nahutedeh whusawhélts'ut t'eh, 'et nyaz de hubudayi cho ts'eke 'en hubuniz didutéyalh, 'et hububa nahutedeh. Soo cho whunoolh'en, ndi yun k'ut nilhdza de hainya hubudayi cho Solomon ye whunih, 'i yudutets'o ka. 'Et whunts'ih 'ilhunuh hubudayi cho Solomon ch'a degha nus 'int'ah k'an 'et nuhtah siyin. ");
INSERT INTO cafNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","'Ink'ez hoh wheghah whezulh dzin dune ba nahutedeh t'eh, Nineveh whut'en nuhwheni k'an ndoh whudezulh nuhwhutah di hudutédulh 'ink'ez nuhwhuba nahuteyeh. Soo cho whunulh'en, hoh da Jonah hubulh yailhtuk da, ts'iyawh bubeni náhundunezdla. 'Aw 'et soo zulhts'ai, 'ilhunuh 'en Jonah ch'a degha nus 'int'ah k'an 'et nuhtah siyin. ");
INSERT INTO cafNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Dune 'aw too dezk'un naidulhk'an 'ink'ez whunest'i k'us k'its'ai t'ah chah 'aw níyoo'alh ghaít'ah. 'Et too dezk'un hukw'usú'ai 'et hukw'eyí'ai. 'I bugha ts'iyannah dahúndelh ndi be whét'en, 'i hinilh'en gha. ");
INSERT INTO cafNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","'Et whuz na'a nuhwheni nuhna 'i nuhyust'e ba too dezk'un li'int'ah. 'Et nuhna soo 'int'ah t'eh, 'et nuhyust'e ndulhcho hoh be whét'en, 'i be whudezbun. 'Et whunts'ih nuhna chanizooh t'eh, 'et nuhyust'e 'i chah tsahólhgus be dezbun. ");
INSERT INTO cafNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","'Et huwa ndai be nuhyust'e be whét'en, 'i ahli, khun teh nuhyust'e tsahólhgus naoodle gunih. 'Et whuch'a soo cho huwohle! ");
INSERT INTO cafNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","'Et huwa nuhyust'e ndulhcho hoh be whét'en, 'i dezbun, 'ink'ez 'aw hoontsolyaz whunts'ih tsahólhgus bughoh hoolah t'eh, 'et ndulhcho, 'i be, be whét'en wule. 'Et whuz na'a soo ts'ah'un be whét'en, 'i ulhtus, 'i k'una'a whedéndi, 'i bugha soo whunoolh'en.” ");
INSERT INTO cafNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sizi 'awhuz yalhtuk hoh 'ilhunuh Pharisee yoodulhkut, “Sulana'int'alh sukoo ts'ih.” 'Et Sizi bukoo daninya 'ink'ez natl'adeda 'ute'ulh wheni. ");
INSERT INTO cafNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","'Ute'alh whutsuh lanacha'ildoh. 'Et Pharisee yunilh'en 'ink'ez tube huba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","'Ink'ez neMoodihti 'et ndi yulhni, “Nuhwheni Pharisee soo cho whunulh'en, nuhlusyet 'ink'ez lubot bulh, bukak zeh toonáwhahgus. 'Et whunts'ih nuhdzi yuh dátni, 'ink'ez 'ut'en ntsi' 'i bulh, 'i ts'iyawh 'i be nuhyuh whudezbun. ");
INSERT INTO cafNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Whuzahnik ahli! 'Aw ih t'eoonuzáhzun? Ndan yoo 'az ts'ih 'uhoonla 'ink'ez bez ts'ih chah, 'en zeh 'uhoonla. ");
INSERT INTO cafNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","'Et whunts'ih ndai aht'i, 'i be bulah ndunnah tehel'en hubula 'ooht'en. 'Et sih ts'iyaintsuk nuhwhuba whuna'doodeh. ");
INSERT INTO cafNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","'Et whunts'ih nuhwheni Pharisee 'aw 'et dawhultsi' 'et nuhts'u whélts'ulh! Ndai hanúlhyeh, 'i 'ut'an sooltsun, 'i rue hiyulhni, 'ink'ez 'onghoh, 'i buluh, 10%, 'i Yak'usda ghah'aih. 'Et ndóht'en huba' hoont'ah. 'Et whunts'ih ndet ts'ah'un na'a ne'áht'en, 'ink'ez Yak'usda ye nek'entsi', 'i 'aw nduchazaht'en. 'Et whuz na'a chah ndóht'en huba' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nuhwheni Pharisee 'aw 'et dawhultsi' 'et nuhts'u whélts'ulh! Lizwif luglez dahyih teh, soo hoonzoo, 'et natl'adahdaih, 'et zeh hukwa' nahzun! 'Ink'ez ndet 'e'óoket, ssoo ts'iyannah nohwhudóolhti hukwa' nahzun. ");
INSERT INTO cafNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","'Et nuhwheni Moses be' dustl'us 'uk'ununa'úsduguz, 'ink'ez nuhwheni Pharisee, dune nalh duba nadudzoo. 'Aw 'et dawhultsi' 'et nuhts'u whélts'ulh! Nuhwheni ts'un k'ut 'adahla, 'aw dune chanohwhes'en li'aht'ah. 'Ink'ez 'adahla dune t'ehonízun hoh nuhk'unuhudelh.” ");
INSERT INTO cafNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","'Et 'ilhunuh Moses be' dustl'us k'ut daja ni hoh beni hoonli be yalhtuk, 'en Sizi 'uyúlhni, “Nehodulh'eh njan 'udini, 'et nuwheni chah, 'en nelh 'udini, 'et huwa neba dzuh 'udénja.” ");
INSERT INTO cafNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","'Et ndi yúlhni, “Nuhwheni chah Moses be' dustl'us k'ut daja ni hoh beni hoonli be yalhtuk, 'aw 'et dawhultsi' 'et nuhts'u whélts'ulh! Nuhwheni nuhgha dune 'ut'en howa whúlna butl'awhahle, 'aw hoontsolyaz be hubula 'oohneh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nuhwheni 'aw 'et dawhultsi' 'et nuhts'u whélts'ulh! Nuhtsuh whudelhdzulh nus whunilh'en, 'en huba tse bet 'ahudutelhtelh 'uwhulh'en. 'Ink'ez nuhwhubákah 'en hubuhanghan inle. ");
INSERT INTO cafNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","'Et 'alha nuhwhubákah 'et dahája, 'et nuhwheni nuhwhuba ts'ah'un 'uhoont'ah nahzun. 'Et soo cho whunulh'en, nuhwhubákah nus whunilh'en hubuhanghan 'ink'ez nuhwheni 'ahudutelalh huba 'uwhulh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","'Et huwa njan Yak'usda ye whunih, 'i be 'et ndutni, ‘Nus whunilh'en 'ink'ez whel'a, 'en nuhts'un hubutelh'alh. 'En bulunah dzuh nubotelhdzut 'ink'ez 'onghunnah chah huboteghan.’ ");
INSERT INTO cafNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","'Et ndi yun 'udechoo 'ulya 'et whuts'un ndunnah nus whunilh'en hubuzkai whúzdli, nuhwheni k'an whudezulh dune nuhwheni hukw'elha whutelhtsilh ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","'Et huwa hoh da Abel buzkai whuzdli whuts'un 'ink'ez Zacharias buzkai whuzdli da, ndan 'en 'int'ah Zacharias njan luglez whucho 'et Yak'usda bukw'uzdai beguz 'et hizelhghi, 'alha ts'ah'un 'ún whudusni, hoh da dahooja, 'et k'an whudezulh dune, 'et nuhwheni hukw'elha whutelhtsilh ho' aht'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","'Et nuhwheni Moses be' dustl'us k'ut daja ni hoh beni hoonli be yalhtuk, 'aw 'et dawhultsi' 'et nuhts'u whélts'ulh! Nts'e na'a dune t'ehonózin, 'et bughu naoolhúchoot! Nuhwhenich'oh 'aw chawhúlhchulh. 'Et ndunnah hóolhdzih, 'en chah k'ah húboohtun!” ");
INSERT INTO cafNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","'Et 'awhuz héyelh hoh, ndunnah Moses be' dustl'us 'uk'ununa'úsduguz, 'ink'ez Pharisee, 'en tube hiyóolhdzi. khun teh hoonliyaz 'uts'un na'a 'udooni ka 'et lhelhdun hukwa hiyoodulhkut. ");
INSERT INTO cafNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","'Ahoolhyez hinilh'en 'aoonilhka khun teh tink'us 'údooni. Khunyaz hoonliyaz 'udeja t'eh, 'et hik'eóote'alh 'et huba. ");
INSERT INTO cafNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","'Et whulhugha da lhanah dune 'ilhuhowezdel. Hulan 'ink'ez lhk'ut nahúdelh cha'hut'en. Ndunnah yugha hoodul'eh, 'en choo ndubulhni, “Ndunnah Pharisee hubules be untuldoh, 'i ch'a soo cho howahli. 'I dune nalh ye dúba naudzoo, 'i 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","'Alha ndai ts'iyawh whunest'i, ts'iyawh ts'et haóotekulh. 'Et ndai whu'iz 'int'ah, 'i chah ts'iyawh t'entedzeh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","'Et huwa ndet tsahólhgus yuh ts'ih yalhtuk, 'et whét'en hidutets'o. 'Et ndet koo whez ts'ih 'uyoon yudzek khunek i'aih daja dani, 'et bun k'ut whuts'un khunekti be howu yatelhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ink'ez sulh dunekah ndun whudusni, ndunnah nuhyust'e ughan, 'et whunts'ih 'aw 'o 'un hoonliyaz 'uhooneh ghaít'ah, ndunt'ah hube noolhújut gunih. ");
INSERT INTO cafNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","'Et whunts'ih ndun be ntelhújut, 'en bunwhuntelhtun. Ndun nuhyust'e selhghi, 'et hukw'elh'az, 'en zeh buba 'uhoont'ah hoh kwuncho yuh ts'ih chah nuhwhutenoh, 'en zeh be noolhújut! 'Alha 'ún whudusni, soo ts'ah'un na'a 'en be noolhújut! ");
INSERT INTO cafNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","'Alha ih 'uhoont'ah skwunlai 'uschas, 'i nankoh sooneya chaditi, 'i be 'óoket? 'Ink'ez ndi dut'aiyaz Yak'usda 'aw lhuk'i whunts'ih yunachaoodulhúnah ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","'Ink'ez daneltsuk nuhtsigha 'i whunts'ih ts'iyawh t'einínzun. 'Et huwa whenoolhújut gunih! Nuhwheni 'uchas degha nus déhti ho' aht'ah! ");
INSERT INTO cafNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ink'ez 'et chah 'ún whudusni, k'us ndan dune, 'en dune nalh, Sizi Gri 'en zeh sulhyis unli ni t'eh, 'en yinkak dune ye' Yak'usda bulizas ndo ba duténilh, 'en se'ildzun unli ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","'Et whunts'ih k'us ndan dune, 'en dune nalh 'aw sulhyis ilah ni t'eh, 'en Yak'usda bulizas bunalh 'aw se'ildzun ilah hubuduténilh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","'Ink'ez ndunnah yinkak dune ye' ch'a detni be yahulhtuk, daja hutni, soo huba 'un whutelhdulh. 'Et whunts'ih ndunnah Ndoni ch'a detni be yahulhtuk, 'aw huba 'un whutookat ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","'Ink'ez Lizwif luglez, k'us naheyelh k'us moodih chah, 'en hububut nenohonilhya t'eh, daja dutehnilh, 'et huwu ni oohle gunih. ");
INSERT INTO cafNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","'Et soo 'et whudezulh Ndoni whunohuntelhtun daja dutehnilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","'Aw 'et dune tah 'ilhunuh dune 'utni, “Whuneoodulh'eh nedusnekah hubuk'elhaítezkat, 'i sulhutsin ndai se'ildzun unli, 'i stl'ayóolelh suba dini!” ");
INSERT INTO cafNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","'Et Sizi ndi yúlhni, “Dune, ndan 'usinla nuhwhuba naheyelh, k'us nuhwhuba yatelhtuk sulhtsi?” ");
INSERT INTO cafNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","'Ink'ez Sizi ndo búlhni, “Nuhwheni soo cho khahdli! 'Uyoon dune be'ildzun ka noohzin gunih! Dune daneltsuk hoonli yut'i ndi yun k'ut, 'et ndi 'ants'ih ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","'Ink'ez 'et khunek bugha whuts'odul'eh hubugha hubulh yalhtuk hoh njan ndutni, “Ilhunuh dune soode'a 'int'ah, buyun k'ut ts'iyaintsuk soo haníyeh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","'Ink'ez dich'oh 'uninzun, ‘Nts'e na'a simba daoosneh? Haníyeh, 'i bakoo whudezbun k'et. 'Aw 'o 'un chah 'uyoo dánosdzaih ghaít'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","'Ink'ez 'et ndutni, ‘Njan dutésnilh lhai hananyi, 'i sutl'o bakoo nawhuntesyes 'ink'ez 'o nus 'uhoolcho na'whútesdlilh. 'Ink'ez 'et ndai hanálhyi, 'i 'ink'ez ndai ust'i, 'i ts'iyawh, 'et datésdlelh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","'Ink'ez 'et sih na'dudóosni, lhai unzoo, 'i mba 'ilhowezkat, lhat naooduzuk whuba. 'Et nailyis, 'in'alh, taintnai, 'ink'ez whunélhnik.’ ");
INSERT INTO cafNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","'Et whunts'ih Yak'usda ndi yúlhni, ‘Tube slah whuzinik! K'an 'ulh'ek nzul naitélcholh. 'Ink'ez ndai int'i, 'i ndan simba buts'e ítookat?’ ");
INSERT INTO cafNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","'Et whuz na'a ndan lhai duba 'ilhowezdla 'ink'ez Yak'usda ba hoonli chait'ih.” ");
INSERT INTO cafNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","'Ink'ez yugha hoodul'eh ndo búlhni, “Et huwa 'ún whudusni, yinkak delhúts'i, ndai teh'alh, 'ink'ez be sóo nadutehnilh, 'i ts'iyawh bugha ni wahle gunih! ");
INSERT INTO cafNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ndai ts'uyi, 'ink'ez ndi naih chah, 'ants'ih unli ho' 'int'ah. Yinkak sahda, 'ink'ez nuhyust'e chah 'i 'o nus dezti. ");
INSERT INTO cafNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ndunnah datsan cho dahint'ah buk'un nuni nulhzut. 'Aw whuyucha'hunusdzai 'ink'ez 'aw hacha'hunusdzai cha' hint'ah. 'Aw uzdla bakoo 'ink'ez haníyeh bakoo chah chahuhóot'ih. 'Et whunts'ih Yak'usda hubugha 'á'aih. 'Et njan whunulh'en, nuhwheni ndi dut'ai ch'a degha nus déhti ho' 'aht'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nuhwheni nuhtah ndan 'int'ah dalcho tele howu ni unli? 'Aw 'et huwa 'o nus 'ulyez wule ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ndi hoontsolyaz whunts'ih 'ohoohleh ghaít'ah t'eh, 'et di ka 'udun chah howu ni ahli? ");
INSERT INTO cafNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","'Ink'ez 'indakyaz unzoo, 'i nts'e na'a haníyeh, howu nuni nahzut. 'Aw cha'ust'en 'ink'ez 'aw hoonliyaz hiye soo nadootnih, 'i chah cha'husdle. 'Et hubudayi cho Solomon naih dezti 'i be soo nadut'ih teh, 'et whunts'ih 'aw 'indakyaz degha nus cha'íldzooh ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","'Et Yak'usda tl'o unzoo, 'i yilh'i. 'I k'an dzin tl'o k'ut haníyeh 'ink'ez bunt'ah 'i tsehidutelhkulh 'ink'ez duték'un. 'Et nuhwheni dalhcho 'i be 'o nus soo nuhghutele. Nuhwhuba 'alha' hoont'ah, 'i tube usdlah nuhwhuba ntsol. ");
INSERT INTO cafNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ndai teh'alh, 'ink'ez tehtnilh, 'i chah, 'ahoolhyez tube cho buka daóohtne 'ink'ez bughunek wahle gunih. ");
INSERT INTO cafNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","'Et ndi yun k'ut 'udun yun k'ut whut'en 'et zeh hukwa hunúta. 'Et whunts'ih Yak'usda nuh'aBá ndai be ndunahdzit, 'i ts'iyawh t'einínzun ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","'Et whunts'ih nts'e na'a Yak'usda hubudayi cho unli, 'et zeh hukwa itéh'en t'eh, 'et ndi chah 'o nus nuhghá tekulh ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nuhwheni se'usheep 'ilho núlh'as, 'aw whenoolhújut gunih! Njan whunulh'en, nuh'aBá nts'e na'a hubudayi cho unli, 'et hoont'i hoh nuhgha óote'alh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ndai aht'i, 'i ts'iyawh be 'óhket 'ink'ez tehel'en, 'en hubugha yoohlelh. 'Et whuz na'a 'et ndaht'en t'eh, 'ink'ez nuhsooneya zus 'aw tinta cha'test'il, 'i 'ahleh. 'Ink'ez ndai unzoo, 'i 'ilhuz wheni bula tah hoolah, 'i ts'iyawh be yóohlelh, 'i yak'uz ts'ih nióohlelh. 'Aw whuz undunut'ih daóoya ghaít'ah 'ink'ez 'aw yun nulh'as, 'i whunts'ih tinta' yoolh'en ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","'Et ndai oonaht'i be sahla 'i 'ilhughehla, ndet sula, nuhdzi chah 'et zeh da' duté'alh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nuhwheni nuhnaih be 'áht'en, 'i ts'iyawh be náhdelh 'ink'ez nuhtoo dezk'un, 'i chah dóok'un. ");
INSERT INTO cafNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","'Et nuhwhenich'oh dune ndunnah dumoodih ba lh'i, 'en buk'una'a 'ooht'e. Nts'e dune lhghusdúke ts'ih hanája, 'ink'ez ndati whudulhghalh t'eh, 'ahoh hiba dá'dutootan. ");
INSERT INTO cafNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","'Et ndet moodih whusanaja t'eh, 'ink'ez be 'ulhna hika tsi hooli, 'ink'ez hika ítes'en, ndunnah moodih ndut'en bunilh'en t'eh, 'en degha nus hoonzoo hubugha whults'ut. 'Alha 'un whudúsni, bumoodih soo nadutetnilh ka, 'ink'ez dude 'ulhna natl'adulhúts'ih hubuduténilh, 'ink'ez hububut ní'telelh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","'Ink'ez moodih tuzniz tusih k'us tuzniz hukw'elh'az tusih, 'et whusanatedalh 'ink'ez be 'ulhna hika tsi hooli hoh hika ítes'en, 'et whuz na'a moodih ndut'en hubunilh'en t'eh, 'en degha nus hoonzoo hubugha whutelts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","'Ink'ez soo cho t'eoonahzeh, ndun bukoo whumoodih nts'owhugha whudezulh undunut'ih whusatéyalh, 'et t'ewhuninzun t'eh, 'et soo ts'ah'un da huwole, 'ink'ez 'aw hikoo da'dutooyis ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","'Et huwa nuhwheni chah lhadóoht'e. 'Alha nts'owhugha 'uhunet'oh 'et buka tsichahóohlih, 'et yinkak dune ye' 'en whusanátedalh,” ni Sizi. ");
INSERT INTO cafNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","'Ink'ez 'et Peter ndi yúlhni, “NeMoodihti, ndi khunek bugha whuts'odul'eh, 'i be yailhtuk, 'i nuwheni zeh tulih k'us ts'iyannah ba tulih 'udini?” ");
INSERT INTO cafNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","'Ink'ez neMoodihti 'utni, “K'us ndan ts'ah'un 'int'ah 'ink'ez whunih unli hoh bukoo huwunli? 'En bumoodih bukoo whumoodih yutelhtsilh, soo 'et neooduzuk t'eh, 'et 'onghunnah hite'alh, 'i hubugha naítet'aih. ");
INSERT INTO cafNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","'Et bumoodih whusanaja t'eh, 'ink'ez hibe 'ulhna whuz na'a ndut'en yunilh'en t'eh, 'et tsih ndan bukoo whumoodih yulhtsi, 'en degha nus hoonzoo bulh 'uwhútenilh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","'Alha 'ún whudusni ndan bumoodih ndai yit'i, 'i ts'iyawh k'une' yul'en yutl'aóote'alh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","'Et whunts'ih ndan be 'ulhna dich'oh budzi yuh hoh 'et nduninzun t'eh, ‘Sumoodih sa slah whusanádaih.’ 'Ink'ez 'et dune bumoodih hiba 'uhút'en 'ink'ez ts'ekoo hiba 'uhút'en chah whéboonilhtsus. 'Ink'ez whé'ni'al 'ink'ez tanutnai, hoh tanutnih, ");
INSERT INTO cafNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","hoh t'eh ndet dzin 'et ndan be 'ulhna 'aw yuka ts'ih chahoolih 'ink'ez nts'oh howa 'uhunet'oh utenilh 'aw t'eoonízun, 'et hoh wheghah 'uhunet'oh hoh bumoodih whusanátedalh. Tube ye'whudutelhyah, 'ants'ih lhulcho k'eitet'us li'yutelilh 'ink'ez ndai Yak'usda k'unucha'ust'en hubuts'ítekulh, 'et didut chah whuz na'a zeh bugha ootét'alh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","'Ink'ez ndan 'ulhna 'en bumoodih ndet yuts'u hukwa' ninzun, 'et ts'iyawh t'eooninzun, 'et whunts'ih 'aw wheni lháchadit'ah 'ink'ez yuk'unucha'ust'en, 'et huwa lhat hoh hubooteltsus. ");
INSERT INTO cafNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","'Et whunts'ih ndan t'eoonízun dumoodih ndet yuts'u hukwa' ninzun, 'ink'ez dude 'ut'en k'ah huwa hubooteltsus huba, dzuhyaz zeh hubooteltsus. 'Et ndun dune lhai bugha nt'ai, 'en lhat yuts'u hukwa' ntezilh. 'Ink'ez ndan lhat butl'awhélya, 'en 'o nus lhat yuts'u hukwa' untezilh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ndi yun kwun buk'eítes'alh ka whusáya. 'Uda ncha duzk'an. ");
INSERT INTO cafNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","'Et whunts'ih be dune too be 'ul'en, 'i be too be' tesnilh huba' hoont'ah. 'Et lhaoodutenilh 'et whuts'un 'et huwa tube dzuh nuszut. ");
INSERT INTO cafNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ts'iyannah lhts'un ts'ah'un 'úhoot'e, 'et hukwa ndi yun k'ut whusáya nahzun ih? 'Awundooh! 'Et ndun whudusni, dune lhch'a nehúdutedulh 'et hukwa whusáya. ");
INSERT INTO cafNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","'Et k'an njan whuts'un skwunlanah 'ilhughun bukoo hudelhts'i, 'en lhch'a nihúdutedulh. Tanah, 'en nanah ch'a nihudutedulh, 'ink'ez nanah, 'en tanah ch'a nihúdutet'us. ");
INSERT INTO cafNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Be'abá buye' ch'a niduteyalh, 'ink'ez buye' 'en be'abá ch'a níduteyalh. Be'ama 'en chah dutse' ch'a níduteyalh, 'ink'ez butse', 'en be'ama ch'a níduteyalh. 'Ink'ez bubez 'en chah beyas'at ch'a níduteyalh, 'ink'ez beyas'at, 'en chah bubez ch'a níduteyalh.” ");
INSERT INTO cafNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","'Et lhanah 'ilhohuwezdel, 'en chah ndo búlhni, “Et ndet nus de kw'us whúzdli nulh'en t'eh, 'et 'ahoh 'udahni, ‘Dzuh stl'iyaz nawhulhtih.’ 'Ink'ez 'et nduwhút'ih. ");
INSERT INTO cafNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","'Ink'ez n'az tézts'i teh 'et 'udahni, ‘Tube whuntézulh ho' whut'en,’ 'ink'ez 'et nduwhút'ih. ");
INSERT INTO cafNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nuhwheni dune nalh duba nahdzoo aht'ah! Ndi yun k'ut 'ink'ez yat'ah chah dawhutenilh, 'et nt'eoonuhzun. 'Et whunts'ih dáhoont'ah huwa k'an dawhutenilh 'aw nt'eoonuzáhzun? ");
INSERT INTO cafNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","'Ink'ez nuhwhenich'oh dahoont'ah huwa nts'e na'a ts'ah'un na'a 'uhoont'ah, 'et 'aw nt'eoonuzáhzun? ");
INSERT INTO cafNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","'Et ndan nch'a detni, 'en naheyelh but ninyutélhtelh, 'et whuz ah'us hoh 'et tube buts'un lhanaoodonleh hukwa' ont'en. 'Et sih naheyelh but ninyutelhtelh 'ink'ez naheyelh nehúlhghel tl'anyutelhtelh, 'ink'ez nehúlhghel tsak'enyute'alh. ");
INSERT INTO cafNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","'Et ndun whudusni ndi sooneya ntsolyaz whunts'ih, 'i ts'iyawh buk'elha whutelhtsilh, 'et whuts'un tsak'etanda.” ");
INSERT INTO cafNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","'Et hoh da bulunah dune, 'en Sizi 'uhiyulhni nts'e na'a Galilee whut'en hubanghan hubulh dahooja. 'En 'uhint'ah Galilee whut'en Yak'usda ba 'uhudélhk'un hoh Pilate hubanghan 'ink'ez hubuzkai nyoo hidélhk'un, 'i butayunjut. ");
INSERT INTO cafNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","'Et Sizi ndo búlhni, “Ndunnah Galilee whut'en, 'en nts'e na'a 'uhuja dzuh nuhuzde, 'et huwa 'uyoon Galilee whut'en degha nus lubeshi 'uhulh'en nahzun ih? ");
INSERT INTO cafNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'Awundooh nuhwhudúsni! 'Et whunts'ih nuhwheni chah nuhwhubeni lubeshi whuch'a náhandunoohlelh, 'et nduchahnil t'eh, 'et nuhwheni chah ts'iyawh, whuz na'a zeh yatáhdlah! ");
INSERT INTO cafNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","'Et keyah Siloam huwhútni, 'et tse whedi'a, 'i ndunnah lanezi 'o 'at lhk'udinah, 'en hubuk'enínghez hoh ts'iyawh hedúghan. 'Et Jerusalem whut'en, 'en huba nus lubeshi 'uhulh'en 'uhint'ah nahzun ih? ");
INSERT INTO cafNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","'Awundooh nuhwhudúsni! 'Et whunts'ih nuhwheni chah nuhwhubeni lubeshi whuch'a náhandunoohlelh, 'et nducháhnil t'eh, 'et nuhwheni chah ts'iyawh, whuz na'a zeh yatáhdlah!” ");
INSERT INTO cafNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","'Et doo chah Sizi huwa whuts'odul'eh, 'i be hubulh yalhtuk hoh njan ndutni, “Ilhunuh dune 'en mai chun, figs hiyulhni, 'i bumai haníyeh, 'i k'ut, 'et 'ilho ha ínulhyeh. 'Ink'ez 'ilhudzin yumai ka ités'en. 'Ink'ez 'aw mai bughoh hoolah. ");
INSERT INTO cafNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","'Ink'ez 'et bumai haníyeh huwunli ndi yúlhni, ‘Whunilh'en ih? Tat naoodezulh whuts'un ndi mai chun, figs hiyulhni, bumai ka ités'en 'ink'ez 'aw bumai bughoh hoolah. Di ka yun k'ut bulh hóonsol? Ntintselh!’ ");
INSERT INTO cafNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","'Ink'ez 'utni, ‘Moodih whute k'an naoodezulh zeh buts'un ha chaoozí'aih. K'at bunat naooteskalh 'ink'ez bugha soo ha' niyeh, 'i butaíduteslelh. ");
INSERT INTO cafNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","'Et soo bumai whúzdli t'eh, 'et soo' hoont'ah. 'Et ndúchainil t'eh, 'et sih ntooselh.” ");
INSERT INTO cafNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","'Aw 'et dzin nats'ulyis 'et 'ilhunuh Lizwif luglez 'et whubodulh'eh. ");
INSERT INTO cafNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Khunyaz 'et 'ilhunuh ts'eke lanezi 'o 'at lhk'udit naoodezut (18) 'et ntsi' nududeh, 'i lait'ah yulhtsi hoh 'en yudinda. 'Et huwa nachaneti 'ink'ez dich'oh 'aw nduk na'ootneh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sizi yutelh'en ibulh, yuka hunih 'ink'ez 'anih yúlhni, 'ink'ez ndi yúlhni, “Ts'eke lait'ah 'aw 'et mba whulaoodetnik!” ");
INSERT INTO cafNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","'Et yuk'edilnik 'ink'ez 'ahoh lhk'unadesduki 'ink'ez Yak'usda dálhti. ");
INSERT INTO cafNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","'Et nats'ulyis dzin 'et Sizi ndun ts'eke soo na'yinla, 'et hukwa ndun Lizwif luglez whumoodih hunílch'e. 'Ink'ez 'ilhohuwezdel, 'en ndo búlhni, “Lhk'utat dzin (6) 'et dune 'uhoot'en huba' hoont'ah. 'Et huwa 'uts'ut'en dzin 'aw 'et zeh soo na'nohohooleh huba' hoont'ah. 'Et nats'ulyiz dzin 'et huba cha'hoot'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","'Et neMoodihti ndi yúlhni, “Nyun dune nalh duba naindzoo 'unint'ah! 'Alha nuhwheni ilhughun ahli hoh nats'ulyis dzin nuhmusdus dune, k'us nuhmuyool teh musdus bakoo hundelhúya, 'et lhk'unadúh'uk 'ink'ez too k'ez toolhdlooh ghaít'ah ih? ");
INSERT INTO cafNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ndun ts'eke 'ilhunuh Abraham yuts'u haínzut 'ink'ez Satan lanezi 'o 'at lhk'udit (18) naoodezulh hoh yulhghel. Soo cho howu nuni nahzut! 'Alha nats'ulyis dzin 'et 'aw buk'una'óot'uk ghaít'ah hoh ih 'udahni?” ");
INSERT INTO cafNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","'Et Sizi ndi khunek 'et ndudáni hoh yuch'a detni, 'en ts'iyawh hooya huzdli. 'Ink'ez 'onghunnah lhanah 'en hubugha hoonzoo tune' 'ust'en 'et huwa honélhnik. ");
INSERT INTO cafNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","'Et Sizi ndo búlhni, “Yak'usda hubudayi cho unli, 'et nts'e na'a nuhwhuba dahoont'ah? 'Ink'ez di bulh simba nuhwhuba nduwhúlt'ah nahzun? ");
INSERT INTO cafNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ndez na'a nduhoont'ah, ndi mai nintsolyaz butse, 'i mustard hiyulhni, 'i k'una'a 'uhoont'ah. 'I dune yunílhchokw 'ink'ez ha'neyeh whuyína'aih 'ink'ez haneyih. 'Ink'ez duchun cho ulhih. 'Et dut'aiyaz buzooschum tah 'ut'o nilih.” ");
INSERT INTO cafNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","'Ink'ez doo chah ndo búlhni, “Nts'e na'a simba whunwhunoolhtun Yak'usda buk'úne' whut'en? Ndez na'a Yak'usda buk'úne' whut'en 'et. ");
INSERT INTO cafNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Lhes ntuldoh, 'i dunt'ah. Ndai ts'eke yílhchukw 'ink'ez lhes nudúdzaih, 'i ta tsetsai be yúnde'oolhdzih, 'i dezbun. 'I ntuldoh, 'i bulh 'ilho be yandzai, 'ink'ez yunelhlhus. 'Et hukw'elh'az 'udun ninínkai hoh untelhúdo.” ");
INSERT INTO cafNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","'Et hukw'elh'az Sizi Jerusalem whuz tezya. 'Ink'ez keyah whuti 'ink'ez keyah whuyaz 'et dune hoh uyalh 'ink'ez dune hoodulh'eh. ");
INSERT INTO cafNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","'Et 'ilhunuh ndi yúlhni, “Nemoodihti bulunah zeh ih hudutejih?” 'Ink'ez Sizi ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Hoondot ndati hukwa 'óohneh. 'Et ndun whudúsni lhanah 'et ndati dahátedulh hukwa' huntezilh, 'et whunts'ih 'aw 'uhooneh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","'Et 'ilho bukoo whumoodih didinya 'ink'ez ndati dána'dentan, 'et nuhwheni 'az nudelhúya 'ink'ez ndati whudulhghalh 'ink'ez 'udahni, ‘Moodihti, moodihti neba dá'dutentih!’ 'Et 'un whudóoni, ‘'Aw nt'enohwhunuzúszun nts'ez de háhdel.’ ");
INSERT INTO cafNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","'Ink'ez 'udoohni, ‘Nyulh 'uts'u'alh 'ink'ez nyulh 'úts'utnai. 'Ink'ez nekeyah whuti 'et da whuneoodilh'e inle.’ ");
INSERT INTO cafNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","'Et whunts'ih 'udóoni, ‘Nuhwhudusni, nuhwheni 'ink'ez nts'ez de háhdel 'aw t'enowhunuzúszun. Sch'a nasáhdelh! Nuhwheni ts'iyawh tink'us ne'zaht'en!’ ");
INSERT INTO cafNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abraham, Isaac, Jacob, 'ink'ez nus whunilh'en, 'en ts'iyawh, ndet Yak'usda hubudayi cho unli, 'et hudutélts'ilh 'et hubunoolh'en. 'Et whunts'ih nuhwheni tinanohonilhdel. 'Et tehtso 'ink'ez nuhghoo lhedutelhk'us. ");
INSERT INTO cafNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","'Ink'ez lhanah ndaz de, nus de, nyaz de 'ink'ez nts'iz de, whuz de hahutedulh 'et ndet Yak'usda hubudayi cho unli, 'et nátl'ahudutelts'ilh 'uhute'alh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","'Et ndóohoont'ah, bulunah 'udechoo hinli, 'en 'udek'ah hutele. 'Ink'ez bulunah 'udek'ah hinli, 'en 'udechoo hinli nahutedleh.” ");
INSERT INTO cafNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","'Et dzin zeh bulunah Pharisee, 'en Sizi highu nindel 'ink'ez 'uhiyúlhni, “Naindalh 'ink'ez njan whuch'a nasindaih. Herod nyutuzelhghelh hukwa' ninzun!” ");
INSERT INTO cafNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","'Ink'ez ndo búlhni, “Ndun 'uyoo nanguz 'en sba dóohni, ‘Sih soo zolhts'ai! K'an dzin 'ink'ez bunt'ah chah ntsi' nududeh, 'i dune ch'a hanánusyukw 'ink'ez dune soo ná'ulh'en, 'ink'ez whulh tat dzin 'et hukwa whusáya 'et lhaoodúlya tesdle.’ ");
INSERT INTO cafNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","'Et whunts'ih k'an dzin, bunt'ah dzin, 'ink'ez 'om bun dzin kedutooszit huba' hoont'ah. 'Alha' hoont'ah, 'aw nus whunilh'en, 'en 'aw keyah Jerusalem whu'az daóotsah huba cha'hóot'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Nuhwheni Jerusalem whaht'en, Jerusalem whut'en, nuhwheni aht'en nus whunilh'en, 'en ahghan. 'Ink'ez ndunnah nuhts'uh whel'a, 'en chah tse be hubahghan. Dant'ah ligok duduzkeh dut'a bugha hubudelhts'i, whuz na'a nuhwheni chah dáwhultsuk hoh 'ilhunanohwutésdlelh hukwa' nuszun, 'et whunts'ih 'aw hukwa cha'náhzun. ");
INSERT INTO cafNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Soo cho whunulh'en, 'aw 'et nuhwheni Jerusalem whut'en nuhkeyah 'aw hoonli hoolah suli hoh nuhwhuba 'et nenáwhults'ut, 'et whuz na'a Yak'usda nuhladutetnih. 'Ink'ez 'alha 'un whudúsni, ndet whusawhútelts'ulh, 'et hoh t'eh 'et ndudútehnilh, ‘Ndun Moodihti boozi be whusateyalh, 'en degha nus hoonzoo bugha whults'ut.’ 'Et ndudútehnilh 'et whutsuh, 'aw sooh'en ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","'Aw 'et 'ilhut dzin 'ilhunuh Pharisee bumoodih bukoo, 'et nats'ulyis dzin, 'et Sizi lhes natet'alh ka danínya. 'Et soo ts'ih hinilh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","'Et khunyaz 'ilhunuh dune buyust'e tah too whudezbun suli, 'et hukw'é nduda, 'en Sizi yubut suyin. ");
INSERT INTO cafNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","'Ink'ez Sizi ndunnah Moses be' dustl'us k'ut, daja ni hoh beni hoonli be yalhtuk, 'ink'ez Pharisee, 'en chah ndo búlhni, “Et neba ts'ah'un 'uhoont'ah ih nats'ulyis dzin dune soo na'ts'oolh'en?” ");
INSERT INTO cafNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","'Et ts'iyawh t'ehudusnih. 'Ink'ez ndun dune yílhchoot 'ink'ez soo na'yinla, 'ink'ez yulanadetnik. ");
INSERT INTO cafNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","'Et ndo búlhni, “Ndunnah 'int'ah nuhtah muyool 'ut'i k'us bumusdus dune tsa k'et 'alts'ut t'eh, 'aw nats'ulyis dzin 'uhoont'ah 'et huwa ih 'ahoh 'aw hanáchahitelhtel nahzun ih?” ");
INSERT INTO cafNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Njan 'et hubugha huboodulhkut, 'aw whe' hudooni hooyal ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ndunnah hubugha nusja k'us hoonzoo 'utahahódet'ai 'ink'ez hubunilh'en ho' hut'en. 'Et huwa whuts'odul'eh, 'i be hubulh yalhtuk hoh njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nts'e dune lhghu tekelh ts'ih nuhghu nusja t'eh, k'us hoonzoo teh natl'adoohdalh gunih. Doo ka nohghan do 'int'ah tulih highu nóya. ");
INSERT INTO cafNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","'Et t'eh ndun nuhghu nuseya, 'en 'un yudooni, ‘Sinda 'et ndun 'et butl'ahóo'aih.’ 'Ink'ez 'et hooya sinli hoh degha nus 'on yuk 'et nanátl'adondalh. ");
INSERT INTO cafNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","'Et whunts'ih nts'e nuhghu nuhúzya whuz toohya 'ink'ez 'ants'ih ndati wheghah nátl'adondalh. 'Et t'eh ndun nuhghu nusiya 'en tulih 'un whudóoni, ‘Sulh dune soo hoonzoo 'et natl'adindaih.’ 'Et ndunnah kw'uzdai k'ut nyulh hudelhts'i, 'en nyahudóolhti. ");
INSERT INTO cafNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Soo cho whunulh'en, ndan ncha na'dudil'i, 'en hooya tele. 'Ink'ez ndan te'dudil'en, 'en ncha hiyoolhtsilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ndun yughu nusiya, 'en Sizi ndi yúlhni, “Ndet dzetniz k'us hulhgha huwa' tan'alh t'eh, khun teh nyulh dunekah, k'us nyulhutsinkah, k'us nyulhtuskah, k'us nghah whut'i ndunnah soode'a 'int'ah, 'en ts'iyawh hubughu nónya gunih. 'En hubughu nusinya t'eh, 'en tulih nghu nunáhooda hoh mba k'elha whutele. ");
INSERT INTO cafNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","'Et whunts'ih huwa' tan'alh t'eh, 'et ndan tehel'en, 'ink'ez dzuh nuhudelh, 'ink'ez hubuyust'e hubodi'ai, 'ink'ez chawhés'en chah, 'en ndunt'ah, 'en zeh hubughu nonya. ");
INSERT INTO cafNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","'Et nyun degha nus hoonzoo nyulh 'úhoneh. 'En 'aw mba k'elha huhoolhtsilh ghaít'ah. 'Ink'ez nk'et'ah dune tsah'un 'int'ah, 'en dináhudidel t'eh, 'et sih mba k'elha whuteleh 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","'Et 'ilhunuh dune kw'uzdai k'ut yulh usda, 'en yudants'o, 'en ndi yúlhni, “Ndet Yak'usda hubudayi cho unli, ndunnah 'en 'uha'alh, 'en degha nus hoonzoo hubugha whutelts'ulh!” ");
INSERT INTO cafNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","'Ink'ez Sizi ndi yúlhni, “Ilhunuh dune hulhgha hooncha hoh huwa' ni'ai. 'Ink'ez lhanah ghu nusiya. ");
INSERT INTO cafNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","'Et hulhgha na'hutet'alh dude 'ulhna yálh'a 'ink'ez ndunnah hubughu nusja ndo budóoni, ‘'Aw 'et ts'iyai lhadúja, dez ahdulh!’ ");
INSERT INTO cafNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ts'iyawh 'ilhunah hinli hoh 'aoonilhka 'aw 'uhooneh ghaít'ah hutni. 'Et 'udechoo njan ndutni, ‘Si yun oket 'ink'ez whuz tesyalh whuntelh'ilh ka, 'et huwa 'aw oosneh ghaít'ah suba dóni.’ ");
INSERT INTO cafNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","'Et 'uyoon dune 'en chah njan ndutni, ‘Skwunlai musdus dune lhuzih ndelhúya oket. 'Ink'ez nantelhú'ilh dant'ah simba, 'et huwa 'aw oosneh ghaít'ah suba doni.’ ");
INSERT INTO cafNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","'Uyoon chah 'et ndutni, ‘K'an zeh 'at ust'i 'et huwa 'aw whuz toosya ghaít'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","'Et hoh 'ulhna yughu nanja 'ink'ez dumoodih 'en hubugha ts'iyawh ndi yúlhni. 'Ink'ez ndun bukoo whumoodih 'aw 'et hunilch'e 'ink'ez dude 'ulhna ndi yúlhni, ‘Soo 'a tsih! Keyah whuti ts'ih inyalh 'ink'ez ti wheyaz ndulhcho hoh ninya 'ink'ez tehel'en, dzuh nuhudelh, chahuwhés'en, 'ink'ez hubuyust'e hubodinla chah, 'en ts'iyawh whusaoobonlelh!’ 'Ink'ez wheyálh'a. ");
INSERT INTO cafNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","'Ulhna whusanája 'ink'ez 'utni, ‘Sumoodih nts'e na'a 'udini, hukw'u na'a 'usja, 'et whunts'ih 'awhuz hooncha whuz'ai.’ ");
INSERT INTO cafNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","'Ink'ez moodih dude 'ulhna ndi yúlhni, ‘'Aw 'et ti whucho ts'un inyalh 'ink'ez ti whuyaz ts'un chah inyalh 'ink'ez dune ts'iyawh dez hutoodelh hukwa' bilh'en, sukoo whudoobun ka. ");
INSERT INTO cafNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","'Alha' dusni hoh nyudusni, ndunnah 'udechoo hubughu nusíya, 'aw 'ilhunuh whunts'ih ndi tet'alh, 'i 'aw chahítesyil.” ");
INSERT INTO cafNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","'Et lhanah 'ilhohuwezdel hiyulh tezdel. 'Et hubuts'u nalhú'a 'ink'ez ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ndan suts'u teyalh se'ut'en k'ah 'uwhutelh'ilh 'ink'ez bu'abá, bu'ama, bu'at, buzkehkah, dulhutsinkah, 'ink'ez dulhtuskah, 'alha 'ink'ez dich'oh hoh yinkak usda chah, ndi njan ts'iyawh si sugha whuladetnik t'eh, 'en 'aw sugha hoodol'eh wule ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","'Ink'ez chah ndan bulhdulalhgus chaidestil 'ink'ez suntezya, 'en 'aw sugha hoodol'e wule ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Soo cho whunulh'en, ndan 'int'ah nuhtah, 'en whedi'a, 'i 'itelilh t'eh, 'en 'udechoo nátl'adeda 'ink'ez daneltsuk whutele neooni'ai, 'i bé lhaoodutenilh. ");
INSERT INTO cafNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Doo ka 'aw nduchaínil t'eh, 'ink'ez koo buk'uwhuz'ai inla, 'et 'aw soo 'uneltsuk ye lhaoodutelilh, 'i chayít'ih t'eh, 'et ndunnah whuhunilh'en, ts'iyawh highu tedloh. ");
INSERT INTO cafNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","'Ink'ez 'uhudooni, ‘Ndun dune whedi'a, 'i whe'yuninle 'ink'ez 'aw lhai dooleh ghaít'ah!’ ");
INSERT INTO cafNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","K'us ndan hubudayi cho 'utenilh 'uyoon hubudayi cho bulh lhuhutedúghan hukwa' ntezilh. 'Alha 'udechoo nátl'adeda 'ink'ez hukw'u nuni noolhdzut datenilh. 'Et soo tulih 10,000 budune, 'en be ndun 'uyoon hubudayi cho 'en 20,000 lhahudughan, 'en soo tulih ndunnah 10,000 be hubududóoya. ");
INSERT INTO cafNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","'Et k'us ndan 'uyoon hubudayi cho 'en 'awhuz nilhdza 'az de hédulh hoh, 'et khunek yuba na'a yuts'u whébahalh'a, nts'e na'a simba ts'ah'un nenáhoho'alh 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","'Et huwa nuhwheni nuhtah 'ilhunah ahli hoh, ts'iyai aht'i, 'i 'aw bulachaduzahnik t'eh, 'aw sugha hoodul'eh wahle ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Lusel 'i unzoo ho' 'int'ah. 'Et whunts'ih 'aw buzachahóolki suli t'eh, nts'e na'a simba doo chah buzahóolki naoodle? ");
INSERT INTO cafNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Lusel buzachahóolki t'eh, 'aw hoonliyaz huba cha'íldzooh ho' 'int'ah. 'Aw yun ba whunts'ih cha'ildzooh. 'Ink'ez 'aw musdus ndálya 'et whunts'ih huba cha'íldzooh ho' 'int'ah. 'I 'ants'ih dune tihíyulhkuk huba 'int'ah. Ndan hubudzo hooni hiyoozólhts'a huba' hoont'ah!” ");
INSERT INTO cafNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","'Aw 'et ndunnah sooneya 'ilhunaoonughés'aih 'ink'ez lubeshi 'uhulh'en, 'en chah ts'iyawh Sizi hiyootuzélhts'ilh ka highu nendel. ");
INSERT INTO cafNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","'Ink'ez ndunnah Pharisee 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz chah highu yawhenilhtuk hoh njan nduhútni, “Nulh'en ndun dune 'en lubeshi 'uhulh'en, 'en hubulh ne'ut'en 'ink'ez hubulh 'á'alh chah 'ut'en.” ");
INSERT INTO cafNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","'Et huwa bugha whuts'odul'eh, 'i be hubulh yalhtuk hoh njan ndutni, ");
INSERT INTO cafNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ndan 'int'ah nuhtah dune 'en sheep 100 ut'i hoh 'ilhuk'i tinta ninya. 'Aw 99 'en chuntah 'aw 'et níbuninla 'ink'ez 'ilhunuh tinta inilhti, 'en naitélhtelh whuts'un yukunúta? ");
INSERT INTO cafNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","'Ink'ez ndet nayilhti hoh duwus k'eyilhti 'ink'ez hootét'i. ");
INSERT INTO cafNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","'Et hoh da bukoo ts'ih lhgha nadija, budunekah 'ink'ez hubeghah huwhut'i, 'en ts'iyawh 'anih hubudani 'ink'ez ndo búlhni, ‘Sulh hoonaht'i. Ndun se'usheepyaz tinch'a nilhti inle, 'en nailhti!’ ");
INSERT INTO cafNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","'Et ndun whudusni, whuz na'a zeh ndan 'ilhunuh dune lubeshi whuch'a bubeni nahundunez'ai, 'en 99 ts'ah'un 'int'ah, 'en 'uda dulubeshi ch'a hubeni nahundunezdla. 'Et whunts'ih ndan 'ilhunuh dune 'en bugha nduk yak'uz hudelhts'i, 'en huba nus 'o nus howun télhnik.” ");
INSERT INTO cafNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Et doo chah zeh 'ilhunuh ts'eke lanezi silver ut'i 'ink'ez lhuk'i tinch'a iné'ai. 'Aw 'et too dezk'un nadulhk'an 'ink'ez bukoo tínawhulhtsas, 'ink'ez nayunté'alh whuts'un yukunúta. ");
INSERT INTO cafNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","'Ink'ez ndet nainí'ai t'eh budusnekah 'ink'ez bughah huwhut'i, 'en 'ilho 'anih hubudani 'ink'ez hubudútenilh, ‘Sulh hóonaht'i! Ndi sooneya lhuk'i tinch'a ne'ai, 'i naní'ai!’ ");
INSERT INTO cafNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Whuz na'a zeh 'un whudúsni, 'ilhunuh lubeshi 'ulh'en bubeni nahundunez'ai t'eh, 'et sihYak'usda hubulizas, 'en ts'iyawh huwhun télhnik.” ");
INSERT INTO cafNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sizi 'et 'utni, “Ilhunuh dune, nanah buye' hooni. ");
INSERT INTO cafNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","'Udek'ah 'et bu'abá ndi yulhni, ‘'Abá ndai suba naootándzilh, 'i k'an ts'iyawh stl'ainle.’ 'Et ndun be'abá ndai buye' buba nayootedzilh, 'i ts'iyawh huba lhk'éyanla. ");
INSERT INTO cafNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","'Et hukw'elh'az 'aw lhat dzin chailah, 'et 'udek'ah yugha ininla, 'i ts'iyawh soo nininla. 'Ink'ez keyah nilhdza ts'ih whinya. 'Et whuz ninya hoh ndai yít'i, 'i ts'iyawh tinta' yunilh'en 'ink'ez hoolah yulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hoh da 'et ndai yuts'u yoozi, 'i ts'iyawh hoolah yulhtsi hoh, 'et nyoh yun k'ut dai cho whúzdli. 'Ink'ez ndun chilh ts'iyai, 'i ye ndunidzit suli. ");
INSERT INTO cafNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","'Et 'ilhunuh dune 'et yun ut'i, 'en 'ut'en yugha ní'ai. 'Ink'ez hanulhyeh ts'ih wheyálh'a, 'et goso ghá' te'aih ka. ");
INSERT INTO cafNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","'Et buye'élts'ul k'et 'et ndunínzun, ndi goso yu'alh, 'i úncha us'alh, ninzun. 'Et whunts'ih 'aw dune yugha cha'us'aih. ");
INSERT INTO cafNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","'Et beni bugha nadelts'ut li'uja 'ink'ez 'utni, ‘Dahúneltsuk se'abá ba 'uhut'en hiya'alh, 'i huba nus 'uneltsuk, 'ink'ez si njan lhe'ust'ah! 'Aw 'et dai súzulhghe! ");
INSERT INTO cafNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dinadoosja 'ink'ez se'abá buts'uh nátoosja 'ink'ez njan ndudóosni, su'abá yak'uz whudulhyah chah lubeshi usdla 'ink'ez nyun mbut chah. ");
INSERT INTO cafNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","'Aw 'o 'at suye' sudutenilh huba soo cha'lhúdzooh. 'Et huwa ndunnah mba 'uhut'en k'una'a 'usolhdzin.’ ");
INSERT INTO cafNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","'Aw 'et be'abá ts'un natesja. 'Awhuz yoo 'az de nádalh, be'abá yutelh'en hoh 'ahoh yugha te'nanzin. Yududelhgai 'ink'ez buye' bushih be na'yilchoot 'ink'ez naindunants'ooz. ");
INSERT INTO cafNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","'Ink'ez buye' ndi yúlhni, ‘Se'abá yak'uz whudulhyah 'ink'ez nyun nyunalh chah lubeshi usdla. 'Aw 'o 'at nye' sudutánilh huba soo cha'lhúdzooh.’ ");
INSERT INTO cafNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","'Et whunts'ih be'abá be 'ustl'en hubuts'un 'et ndutni, ‘Naih degha nus unzoo, 'i whusaoolhchoos 'ink'ez be sóo naidahleh, lande'ai bula nidah'aih 'ink'ez kegwun chah beyúlh'es. ");
INSERT INTO cafNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","'Ink'ez musdusyaz nilhúk'a, 'i ulhchoot 'ink'ez nasulhghe! 'Et 'uts'oo'alh 'ink'ez ts'onóolhnik. ");
INSERT INTO cafNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Suye' dazsai inle 'ink'ez k'an nakhítna li'hoont'ah. Tinta nilhti inle, 'ink'ez k'an nailhti.’ 'Aw 'et ts'iyannah hiyulh whunélhnik. ");
INSERT INTO cafNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","'Et buye', 'udetsah whudelhdzulh, 'en ha'níyeh ts'ih 'ut'en. 'Et koo ts'ih natesja. 'Aw 'et wheghah nadalh hoh 'et shun chah 'ink'ez hanudaih 'et whuduzts'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","'Ink'ez 'ilhunuh 'uski ye 'ulhna 'anih yulhni 'ink'ez yoodulhkut, ‘Dawhutni ho' whutni?’ ");
INSERT INTO cafNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","'Ink'ez ndi yúlhni, ‘Nyulhutsin whusanája. Soo 'int'ah 'ink'ez dáchait'ah hoh whusanája. 'Et huwa nye'abá musdusyaz nilhk'a, 'i naselhghi.’ ");
INSERT INTO cafNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","'Et whunts'ih bulhutsin 'udetsah hunilch'e. 'Ink'ez 'aw koo ts'ih nátooja hukwa cha'nizun. 'Et be'abá tenínya 'ink'ez yughu tedudlih. ");
INSERT INTO cafNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","'Ink'ez be'abá ndi yúlhni, ‘Nilh'en lhe'whuldzuh mba 'ust'en. 'Ink'ez 'aw nghunek lhuk'i whunts'ih k'uchásyus. 'Et whunts'ih 'aw sheepyaz whunts'ih sugha chailhtel sulh dunekah hubulh whúnoolhnik ka. ");
INSERT INTO cafNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","'Et whunts'ih ndun nye', 'en, ndai bugha íni'ai, 'i ts'ekoo 'uhul'en, 'en buk'uz ts'iyai, 'i yulhtsi 'ink'ez musdusyaz nilhúk'a, 'i buba naizélhghi!’ ");
INSERT INTO cafNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","'Ink'ez ndi yúlhni, ‘Suye' 'ahoolhyez sulh 'ínt'ah. 'Ink'ez ndai ust'i, 'i ts'iyawh nyun nye'ildzun 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","'Et ts'ah'un na'a 'uhoont'ah ts'onólhnik 'ink'ez ts'ohót'i huba' hoont'ah. Nyulhutsin dazsai inle, 'en nakhitna. Tintalts'ut inle, 'aw 'et nailhti.” ");
INSERT INTO cafNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","'Ink'ez 'et chah yugha hoodul'eh, 'en ndo búlhni, “Ilhunuh dune soode'a 'int'ah, 'en bukoo whumoodih unli. 'Et 'uyoon 'uhiyulhni, ‘Nkoo whumoodih ndai int'i, 'i tinta' inílh'en.’ ");
INSERT INTO cafNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","'Et 'anih yudani 'ink'ez ndi yúlhni, ‘Daja hutni nyulh udusts'o? Nts'e na'a sukoo whumoodih inli, 'et ts'iyawh suba 'uk'e'ónges. 'Aw 'et sukoo whumoodih inli 'ustl'e' 'inja ho' hoont'ah!’ ");
INSERT INTO cafNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","'Et ndun bukoo whumoodih inle dich'oh na'dudutni, ‘Daoosneh simba? Sumoodih 'aw 'et se'ut'en sughu nayílchoot. 'Aw soo cha'lhútus yun whuteskaih whuba. 'Ink'ez da'dutelhúne chah hukwayá usdli. ");
INSERT INTO cafNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Datésnelh howu nuni nuszut. Ndet se'ut'en njan tinta ní'ai t'eh, dune bukoo ts'ih soo dasuhoolhtelh.’ ");
INSERT INTO cafNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","'Et ndunnah bumoodih 'ilhunah hinli hoh hubuts'ún 'ít'i, ts'iyawh 'anih hubudáni. 'Ink'ez 'udechoo 'en yoodulhkut, ‘Sumoodih daneltsuk buts'un int'i?’ ");
INSERT INTO cafNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'Et ndi yúlhni, ‘Khe 100 bundé'oolhdzai, 'i.’ 'Ink'ez ndi yúlhni, ‘Soo 'a natl'adindaih 'ink'ez bé nts'uh whuz'ai, 'i 50 zeh 'uk'e'inges!’ ");
INSERT INTO cafNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","'Et 'ilhunuh chah ndi yúlhni, ‘Nyun do, daneltsuk buts'ún int'i?’ 'Ink'ez ndi yúlhni, ‘Tl'o mai 100 bundé'oolhdzai, 'i.’ 'Et ndi yúlhni, ‘Bé nts'uh whuz'ai, 'i 80 zeh 'uk'e'inges!’ ");
INSERT INTO cafNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ndun ts'ah'un cha'it'ah bukoo whumoodih, tube 'uyoo unli hoh 'uja. 'Et ndi yúlhni bumoodih, ‘'Aw soo ts'ah'un na'a cha'inil, 'et whunts'ih 'uyoo inli hoh 'inja!” 'Et Sizi ndo búlhni, “Ndez na'a njan nduhoont'ah, ndunnah huba 'alha' cha'hoot'ah, 'en 'uyoo hinli 'int'ah 'ink'ez ndunnah Yak'usda ba be whét'en hinli, 'en huba nus 'uyoo hinli. ");
INSERT INTO cafNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","'Ink'ez ndun whudusni, ndi sooneya, 'i be dulh dunekah nahultsih. 'Ink'ez datéhtsah t'eh, 'et sih, 'ilhuz 'uhoont'ah ts'ih, whuz danánhohoolelh. ");
INSERT INTO cafNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ndai 'aw hoonli chahóolah, 'et ts'ah'un ne'whulh'en t'eh, ndai hooncha 'et chah ts'ah'un ne'whutelh'en. 'Et ndan hoontsolyaz be tink'us 'int'ah, 'en hooncha whuz na'a zeh 'et ndutet'ilh. ");
INSERT INTO cafNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","'Et huwa ndi sooneya, 'i be ts'ah'un nucha'zaht'en t'eh, nts'e na'a simba ndai be soode'a 'uhoont'ah, 'i nuhtl'ayóo'alh? ");
INSERT INTO cafNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","'Et nuhwheni ndai 'uyoon be'ildzun 'i be ts'ah'un cha'áhnel t'eh, 'et ndan simba óoneh ndi nuhbe'ildzun unli, 'i nuhtl'ayóo'alh? ");
INSERT INTO cafNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","'Aw 'ilhunuh 'ustl'en 'en 'aw nanah moodih ba né'oot'en ghaít'ah. 'Et 'ilhunuh 'en yuts'u dutetnik 'ink'ez 'ilhunuh yuk'etetsi'. K'us 'ilhunuh yuk'úne'tet'en 'ink'ez 'ilhunuh yuch'a dútetni. 'Aw Yak'usda k'une' 'int'en 'ink'ez sooneya chah k'une' 'ont'en ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","'Et ndunnah Pharisee, 'en sooneya huba dezti 'uhint'ah. 'En chah soo nts'e na'a daja ni ts'iyawh hidants'o, 'ink'ez highudloh. ");
INSERT INTO cafNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","'Et ndo búlhni, “Nuhwheni ndez na'a njan daht'ah. Dune tah nuhwhenich'oh soo ts'ah'un 'int'ah na'dudulhú'i, 'et whunts'ih Yak'usda nuhdzi dant'ah ts'iyawh soo ts'ah'un nt'eooninzun. Ndai dune ba dezti, 'i Yak'usda yuts'u dutnik ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moses be' dustl'us 'ink'ez nus whunilh'en bube' dustl'us chah ndet whuts'un John dune too be 'ulh'en khuna da, 'et whuts'un dune hik'une' 'oot'en huba' hoont'ah. 'Et whuts'un whudutezut ndet Yak'usda hubudayi cho unli, 'et hubugha khunek unzoo, 'i dune hiye yalhtuk. 'Ink'ez ts'iyannah 'et whuz na'a húkwa' hut'en. ");
INSERT INTO cafNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","'Et tube howa whulna hoh nduk yat'ah 'ink'ez ndi yun chah hoolah whutele. 'Et whunts'ih njan Moses be' dustl'us k'ut degha nus hoontsolyaz hukw'e'éduguz, 'et 'o nus howa whulna hoh hoolah whutele. ");
INSERT INTO cafNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","'Et ndan dune bu'at 'ustl'e' 'inla 'ink'ez 'uyoon ts'eke ghu nasda t'eh, ndun dune 'en lubeshi 'ulh'en. 'Ink'ez ndun ts'eke duki ch'a nasja 'ink'ez 'uyoon dune ghu nasda t'eh, ndun dune 'en chah lubeshi 'ulh'en ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Aw 'et 'ilhunuh dune soode'a 'int'ah, 'en naih dulk'un, dezti, 'ink'ez laiyin dezti, 'i chah, ye dune unli. Dzin totsuk unzoo, 'i zeh yu'alh, ");
INSERT INTO cafNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","'ink'ez 'ilhunuh dune tel'en, 'en Lazarus hiyulhni, 'en buyust'e 'et ndulhcho hoh buka whulhjut. 'Ink'ez ndun dune soode'a 'int'ah, 'en bughu dati 'et hiyulhti. ");
INSERT INTO cafNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ndun soode'a bukw'uzdai k'ut wheghakat, 'i uncha us'alh ninzun. Lhikah 'en whunts'ih highuh nilgok hoh hika k'et whúdlat. ");
INSERT INTO cafNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","'Et ndun dune tel'en dazsai. 'Ink'ez lizas, 'en Abraham zih nihinílhti. 'Ink'ez ndun soode'a 'int'ah chah dazsai. 'Ink'ez wheyih hiyalhti. ");
INSERT INTO cafNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","'Et ndun 'en yaidla tah usda 'ink'ez tube dzuh nuzut. 'Et nduk yutá'en hoh nilhdza 'et Lazarus, Abraham yuzih usda hoh hubutelh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","'Et tube soo cho yuts'u ha huyih 'ink'ez 'uyulhni, ‘Se'abá, Abraham, sugha te'nonzeh! Lazarus 'en suts'ilh'alh! 'Astl'iyaz dulasgek be toot nudoolnih 'ink'ez 'i be sutsoola k'ut nawhunoolhtsul, 'i be nanoosdúk'as! Ndi kwun 'i be dzuh nuszut!’ yulhni. ");
INSERT INTO cafNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","'Et whunts'ih Abraham ndi yúlhni, ‘Suye' yinkak sinda da whunailnih ih? Ts'iyaintsuk unzoo, 'i nghánkat. 'Et whunts'ih Lazarus ntsi' zeh bughankat. 'Ink'ez 'aw 'et 'en hoonzoo bughá whults'ut, 'ink'ez nyun k'an dzuh ninzut. ");
INSERT INTO cafNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","'Ink'ez 'aw 'et zeh ilah, nyun 'ink'ez nuwheni nuhwhéguz tube nadalhdzat ho' hoont'ah. 'Et huwa njan whuts'un 'aw nts'ó tooya ghaít'ah k'us nyun nts'un ts'ih whuts'un chah 'aw dez hutooya ghaít'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","'Et ndi yúlhni, ‘Se'abá Abraham nts'u tedusdli, Lazarus 'en se'abá bukoo ts'ih ilh'alh. ");
INSERT INTO cafNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Skwunlanah sulhutsinkah hooni. Khun teh khunek hubugha óo'alh. Doo ka sih njan dune dzuh nudeh ts'ih hutoodelh.’ ");
INSERT INTO cafNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","'Et Abraham ndi yúlhni, ‘Moses be' dustl'us 'ink'ez nus whunilh'en bube' dustl'us chah hit'i. 'I hiyoozólhts'a da.’ ");
INSERT INTO cafNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","'Ink'ez ndi yúlhni, ‘'Awundooh se'abá Abraham. 'Et 'ilhunuh yaidla tah ts'ih hanája 'ink'ez hubuts'u tezya t'eh, 'et huwa lubeshi whuch'a hubeni nahodunooleh.’ ");
INSERT INTO cafNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","'Ink'ez ndi yúlhni, ‘Moses be' dustl'us 'ink'ez nus whunilh'en bube' dustl'us chah, daja ni 'aw hiyoozólhts'a hukwa cha'hunízun t'eh, 'et nts'e na'a 'ilhunuh dazsai yaidla tuz hanaja t'eh, 'en whunts'ih 'aw hubeni 'uts'un ná'yooleh ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","'Ink'ez Sizi yugha hoodul'eh 'et ndo búlhni, “Njan tink'us uznint'uk 'ahoolhyez 'et whuzdla ho' hoont'ah. 'Et whunts'ih ndun dune bugha tink'us 'úwhut'en, 'en dawhultsi' buts'uh whélts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ndunnah 'uskehyaz 'ink'ez ndun dune 'en bugha tink'us 'úhut'en suli t'eh, 'en dune tse cho hits'ilchun edinguz 'ink'ez soo takhulh tahíyano t'eh, 'et 'o nus whutézoo. ");
INSERT INTO cafNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","'Et huwa soo cho khahdli. 'Et nuhulhutsinkah nuhdulhyah 'uhuja t'eh, 'et hukwa' budóohtni. 'Et hubeni náhudunez'ai t'eh, 'et huba whunaoodoolhúnah. ");
INSERT INTO cafNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","'Et 'ilhut dzin skwunlai 'o at nankoh ndulhyah 'uja t'eh, 'et totsuk nghu nadaih 'ink'ez, ‘Seni náhandune'ai,’ nyúlhni t'eh buba whunaoodolnah.” ");
INSERT INTO cafNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","'Ink'ez ndunnah whel'a, 'en neMoodihti 'uhiyúlhni, “Be néba 'alha' hoont'ah, 'i 'o nus 'ultus neba ilhtsi.” ");
INSERT INTO cafNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","'Et neMoodihti ndo búlhni, “Degha nus haníyeh mai tseyaz, 'i mustard hiyulhni, 'et nuhwhuba 'alha' hoont'ah, 'et 'uwhulcho t'eh, 'et njan duchun, 'i mulberry hiyulhni, 'et Yak'usda boodolhkut, ‘Ndi duchun bughih tubulh hanaílhch'oolh 'ink'ez nye bun cho k'ut 'et whuyuní'aih.’ 'Et Yak'usda nuhk'ah ts'ih 'ooneh. ");
INSERT INTO cafNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","'Ink'ez nuhwheni nuhtah 'ilhunuh nuhwhe'ulhna unli. 'Et ndan 'en haníyeh k'et nawhulhch'ul k'us sheep ghunli. 'Et ndi hanúlhyeh k'us whuz de hanája. 'Et ndez na'a tulih 'udóoni, ‘Soo 'a! Natl'adindaih 'ink'ez na'int'alh!’ ");
INSERT INTO cafNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'Awundooh! K'us ndez na'a njan dudóoni, ‘Hulhgha natest'alh, 'i suba lhadinle, 'ink'ez soo cho soo nadíntneh! 'Ink'ez suba hukw'e'inle, bulh na'test'alh, 'i chah suba hukw'eínkaih. 'Ink'ez na'est'al hukw'elh'az 'et na'ont'alh.’ ");
INSERT INTO cafNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","'Et ndun be 'ulhna ndet yutl'ahonla 'et ts'iyaintsuk lhaoodinla. 'Et nduja 'et huwa ih suchanailya yudutenilh? 'Awundooh nuszun. ");
INSERT INTO cafNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","'Et whuz na'a zeh nuhwheni chah, ndet daóoht'en nuhwhudani, 'et ts'iyawh lhaoodahla t'eh, 'et 'ink'ez njan dudutéhnilh, ‘'Aw 'ilhun whunts'i huba soo cha'ts'ilzooh. Daja nehutni, 'et zeh ne'ts'ut'en.” ");
INSERT INTO cafNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","'Aw 'et Sizi Jerusalem tezya hoh yun k'ut Samaria 'ink'ez yun k'ut Galilee chah wheguz lhuseya. ");
INSERT INTO cafNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","'Et whuz uyalh hoh keyah whuyaz ninínya. 'Et lanezi ndulhcho hoh bukak whulhjut, 'i leprosy hiyúlhni, 'i be hunduda, hidudezdel. 'Ink'ez highu nilhdza nahudelhúya. ");
INSERT INTO cafNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","'Et whuts'un hits'un ha huyih, “Sizi neMoodihti, negha te'ninzeh!” ");
INSERT INTO cafNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","'Et Sizi hubunilh'en 'ink'ez ndo búlhni, “Náwhulnuk buts'un ahdulh.” 'Et 'awhuz whuz hédulh hoh soo na'huja. ");
INSERT INTO cafNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","'Et 'ilhunuh soo na'uja t'ewhunanzin hoh 'et nuhundunezya. 'Et soo tube cho Yak'usda dálhti. ");
INSERT INTO cafNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","'Et Sizi yubut yun 'et nacháneti, 'ink'ez lhk'uz teh suchanailya yulhni. 'En dune Samaria whut'en 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","'Et Sizi ndi yúlhni, “Lanezinah ih soo na'huja? Ndunnah lhuk'i hoolah lanezinah nts'e whehándel? ");
INSERT INTO cafNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","'Et ndun 'udun keyah ts'ih hainya, 'en zeh whusanaja 'ink'ez Yak'usda suchanailya yulhni.” ");
INSERT INTO cafNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","'Ink'ez Sizi ndi yúlhni, “Didinyih 'ink'ez naindalh. Mba 'alha' hoont'ah, 'i be soo na'inja.” ");
INSERT INTO cafNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","'Et bulunah Pharisee, 'en Sizi hiyoodulhkut, “Nket'ah 'uwhutenilh Yak'usda hubudayi cho unli whusaootelts'ulh?” 'Et ndo búlhni, “Yak'usda hubudayi cho unli, 'aw nts'e na'a whusaootelts'ulh, 'et 'aw whunólh'en ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","'Aw 'ilhunuh whunts'ih dooni ghaít'ah, ‘Njan whunulh'en 'et 'uhoont'ah,’ k'us, ‘Nghah 'uhoont'ah.’ 'Et Yak'usda hubudayicho unli 'uda nohwhulh 'uhoont'ah ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","'Ink'ez 'et yugha hoodul'eh ndo búlhni, “Et hoh dzin whusaóotekulh 'ink'ez yinkak dune ye', 'ilhut dzin whuteh'ilh hukwa' ntehzilh, 'et whunts'ih 'aw hooh'en ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","'Et 'onghunnah dune 'en ndun núhwhudooni, ‘'O 'un whunulh'en!’ k'us ‘Njan whunulh'en!’ Khun hubuts'u toohdelh gunih 'ink'ez hubun toohdelh gunih! ");
INSERT INTO cafNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nts'e na'a ditnik kwun 'oolhges teh ndulhcho hoh bé wheóodiltsih, 'et whuz na'a zeh yinkak dune ye', budzin t'eh ndulhcho hoh ts'iyannah ba be hooduteltsilh. ");
INSERT INTO cafNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","'Et whunts'ih 'udechoo lhat hoh dzuh nutezut huba' hoont'ah. 'Ink'ez k'an whudzulh dune, 'en hikacha'unteszil. ");
INSERT INTO cafNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","'Et nts'e na'a Noah budzin whudezulh da, dahoont'ah inle, 'et whuz na'a zeh yinkak dune ye' dzin 'et ndo whútenilh. ");
INSERT INTO cafNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","'Et ts'iyannah 'uha'alh zeh 'uhut'en, 'ink'ez tahunutnai. Dune 'ink'ez ts'ekoo chah lhgho delhts'i. 'Ink'ez hoh da nts'e na'a Noah ts'i cho be ínya 'ink'ez too hadámbun, 'et ts'iyannah too hubanghan. ");
INSERT INTO cafNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","'Ink'ez ndun Lot 'en khuna da whuz na'a 'et ndúhooja. 'Et ts'iyannah 'uha'alh zeh 'uhut'en 'ink'ez tahunutnai. 'Oohooket 'ink'ez 'e'hooket. 'A'hunule 'ink'ez koo 'uhuwhulh'en cha' hut'en. ");
INSERT INTO cafNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","'Et hoh da dzin Lot, 'en keyah Sodom huwhutni huwu whenaja hoh kwun 'ink'ez tse dezk'un, 'i ndus de yak'uz ts'ih naílhtan, 'ink'ez ts'iyawh hoolah hubulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","'Ink'ez ndet dzin 'uwhutenilh yinkak dune ye' be hóoduteltsilh, 'et whuz na'a ndó tenilh. ");
INSERT INTO cafNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","'Et hoh dzin, ndun dune bukoo hukw'ut nalyis hoh, 'en 'aw koo natooja 'ink'ez bukoo ts'ih ye 'int'ah, 'i 'aw nayóolchoot gunih. 'Et whuz na'a zeh ndun dune ha'niyeh k'et 'ut'en, 'en bukoo ts'ih 'aw ye 'int'ah, 'i yukunaóoda gunih. Khun 'uwhuténilh 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot, bu'at 'en bunalhúnih! ");
INSERT INTO cafNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ndan dich'oh ye khuna, 'et 'ududoolyih hukwa 'ut'en, 'en ye khuna, 'i tinta ité'alh. 'Ink'ez ndan dich'oh ye khuna tinta ooní'ai t'eh, 'en 'udutelyih ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","'Et ndun whudusni ndez na'a njan nduwhútenilh, 'et 'ulh'ek nanah lhuk'i kw'usuti k'ut huztez. 'Ilhunuh 'en itélcholh, 'ink'ez 'ilhunuh 'aw 'et ndutét'ilh. ");
INSERT INTO cafNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nanah hite'alh, 'i hidunulhduz. 'Ilhunuh itélhcholh, 'ink'ez 'ilhunuh 'aw 'et ndutét'ilh. ");
INSERT INTO cafNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nanah, 'en haníyeh k'et 'uhut'en. 'Ilhunuh itélhcholh, 'ink'ez 'ilhunuh 'aw 'et ndutét'ilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","'Et hukwa hiyoodulhkut, “NeMoodihti nts'e 'udini?” 'Ink'ez ndo búlhni, “Ndet neyust'e sula, 'et sbalyan 'ilhowútuwédulh.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","'Et Sizi be whuts'odul'eh, 'i bugha ndo búlhni. 'Et ndez na'a whunehodulh'eh hoh njan ndutni, dune 'ahoolhyez tenazdoodli 'ink'ez 'et whulazdootnih gunih. ");
INSERT INTO cafNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","'Et ndo búlhni, “Et 'ilhun keyah, 'et ndun nahéyelh, 'en 'aw Yak'usda yé chaniljut, 'ink'ez dune ba 'ants'ih 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","'Et keyah zeh 'ilhunuh tsandelh, 'en 'ahoolhyez yugheyih 'ink'ez ndi yúlhni, ‘Ndun such'a detni, dásinla suba ts'ah'un na'honleh!’ ");
INSERT INTO cafNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","'Et 'astl'iyaz whuts'un hoont'i hoh 'aw yoozólhts'a ghaít'ah. 'Et 'udek'elh'az na'dudútni, ‘'Aw Yak'usda be chanuzulhújut 'ink'ez dune chah 'ants'ih suba hinli. ");
INSERT INTO cafNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","'Et whunts'ih ndun tsandelh sdabe tesudule, 'et huwa buba ts'ah'un na'whutesdlilh, doo ka sih suk'a'doolhdzas!” ");
INSERT INTO cafNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","'Ink'ez neMoodihti ndo búlhni, “Ndun naheyelh ts'ah'un cha'ít'ah, daja ni oozélhts'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","'Et whuz na'a zeh k'us ndan Yak'usda budune, dzin 'ink'ez 'ulh'ek 'i bulh hits'u tedudlih, 'ink'ez soo hubulh whulh'ai. 'Aw hiyoozólhts'ai ghait'ah nahzun ih? ");
INSERT INTO cafNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","'Et 'un whudusni, 'a cho huba k'utetnilh! 'Et whunts'ih yinkak dune ye' ndi yun k'ut whusanája t'eh, soo ih dune buba 'alha' hoont'ah naootélelh?” ");
INSERT INTO cafNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bulunah ts'ah'un na'a 'ust'ah na'hundunúdzun, 'ink'ez 'onghunnah, 'en hintsi' hubunínzun. 'Et huwa Sizi 'en ndi nawhutnuk 'i be whúts'odul'eh 'i be 'ubulh yalhtuk hoh njan ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nanah dune Lizwif hubuluglez whucho tenahudutedli ka whuz wheha'az. 'Ilhunuh 'en Pharisee 'int'ah, 'ink'ez 'ilhunuh sooneya 'ilhunanowes'aih 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ndun Pharisee 'en dich'oh siyin 'ink'ez tenadudli hoh njan ndutni, ‘Yak'usda suchanailya nyudusni. 'Aw 'uyoon dune dúlh nduchaust'ah. 'Uyoon 'en huwhilhtsi' sooneya be, 'en 'aw ts'ah'un cha'it'ahnah 'uhint'ah, 'ink'ez ts'ekoo k'us dune bulh tínta' 'ut'ihnah. 'Ink'ez ndun sooneya 'ilhunanowes'aih, 'en whunts'ih bunduchalhút'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Hukw'enilhghel 'et totsuk nat sahá'delhuya. 'Ink'ez ndai suba k'elha unli, 'i chah bulah, 10%, luglez huwas'aih,’ ni Pharisee. ");
INSERT INTO cafNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","'Et ndun sooneya 'ilhunanowes'aih, 'en chah 'udun siyin. 'Aw nduk whunts'ih yutóo'en ghaít'ah 'ink'ez yuk nelhú'ai. 'Ink'ez budzi k'ut hoolhchis, ‘Yak'usda sugha te'ninzeh! Lubeshi 'ulh'en 'ust'ah,’ ni.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","'Et Sizi ndo búlhni, “Ndun whudusni ndun sooneya 'ilhunanowes'aih, 'en Yak'usda nalh ts'ah'un na'uja hoh bukoo ts'ih nanja. 'Et 'ilhunuh 'aw nduchaínil. 'Et ndez na'a njan ndúhoont'ah, ndun duba nahúdzoo, 'en hooya yutelhtsilh. 'Ink'ez ndun yuk 'ududildzun, 'en Yak'usda nduk na'yutelilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","'Aw 'et 'uskehyaznah highih hininla khun sih buk'edoolnih ka. 'Et yugha hoodul'eh honilh'en hoh, ‘Dah!’ buhútni. ");
INSERT INTO cafNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","'Et whunts'ih Sizi yugha hoodul'eh 'anih hubúlhni, “Whute 'uskehyaz suts'un toohdelh. Khun teh dah budoohni gunih. Ndunnah Yak'usda hubudayi cho unli whuz hudelhts'i, 'en ndunnah 'uskehyaz hubunduhúlt'ah ho' hint'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Soo ts'ah'un 'alha 'ún whudusni, ndet Yak'usda hubudayi cho unli ts'ih, ndunnah Yak'usda hubudayi cho unli 'aw 'uskehyaz k'una'a chahuhóolhchulh t'eh, ndunnah 'aw whuz dahóoya ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","'Aw 'et 'ilhunuh dune moodih uncha 'en Sizi yoodulhkut, “Dune hoodulh'eh unzoo, nts'e na'a datesnilh hoh 'ilhuz khutesnalh whuch'a ootélhdoh?” ");
INSERT INTO cafNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","'Et Sizi ndi yúlhni, “Di ka' sudini, nuszoo sudini? 'Aw 'ilhunuh unzoo hoolah. Yak'usda 'en zeh unzoo ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ndai Yak'usda khunek dune butl'aida'ai, 'i t'eininzun. Khun teh ts'ekoo bulh tinta 'ooht'en gunih. Dune soolhghelh gunih. 'Undunooht'ih gunih. 'Uyoon ba hohts'it gunih. Nuhwhé'aba 'ink'ez nuhwhe'ama bulh budóolhti.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","'Et ndi yúlhni, “Nusol da whuts'un, ndi ts'iyawh buk'une' zust'en.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","'Et Sizi njan oozalhts'a hoh 'et ndi yúlhni, “Awhuz 'ilhunuh mba 'et whuz'ai. Ndai int'i, 'i ts'iyawh be 'ónket, 'ink'ez tel'ennah hubugha íyo'alh. 'Et sih nduk yak'uz dezti, 'i 'et mba téla. 'Ink'ez 'anih se'ut'en k'ah tune' ónt'en ka sunanyalh.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","'Et whudánts'o hoh tube budzi yuk 'úja. Ndun dune tube soode'a 'int'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","'Et Sizi yunilh'en hoh ndun dune tube budzi nduda suli, 'et 'utni, “Ndunnah soo hude'a 'uhint'ah dahóolhcho huba howa whulna hoh Yak'usda hubudayi cho unli ts'un hutedulh. ");
INSERT INTO cafNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","'Et ndi khunai ncha, 'i camel hiyulhni, 'i buba howa whulna hoh ughabatsoh bulatah bukoní'a hukwutelgwulh. 'Et whuz na'a 'o nus howa whulna hoh ndunnah soo hude'a 'uhint'ah, 'en Yak'usda hubudayi cho unli dahútedulh.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","'Et ndunnah hodants'o 'uhutni, “Ndan zeh simba doojih?” ");
INSERT INTO cafNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","'Et whunts'ih ndo búlhni, “Dune ndai bulh 'uhuhooleh ghaít'ah, 'et whunts'ih Yak'usda ba huwa chahoolnah ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","'Et Peter yatelhtuk hoh Sizi njan ndi yulhni, “Whunilh'en ndai ts'it'i, 'i ts'iyawh bulazdetnik 'ink'ez nye'ut'en k'ah ts'ih ts'oot'en ka nyuts'un tezdel.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","'Ink'ez ndo búlhni, “Alha 'un whudúsni, ndet Yak'usda hubudayi cho unli, 'et huwa dune bukoo huwu tezya t'eh, k'us budusnekah, k'us dulhutsinkah teh, k'us bu'at, buzkeh chah, ndi ts'iyawh huwu tezya t'eh, ");
INSERT INTO cafNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","'et ndan 'et ndúja, 'en 'o nus lhat butl'anaóotedúkulh. 'Et nus de whusawhélts'ut t'eh, 'et 'ilhuz khutena.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","'Aw 'et ndunnah lanezi 'o 'at nanah, 'en 'udun nibuninla 'ink'ez ndo búlhni, “Sih soo zulhts'ai, Jerusalem ts'ih ts'utedulh 'ink'ez yinkak dune ye', ndunnah nus whunilh'en, 'en bugha hik'e'anguz, 'i ts'iyawh lhawhudutenilh. ");
INSERT INTO cafNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Lizwif 'udun yun k'ut whut'en butl'a'duteltelh. 'En highu notelyoh, 'ink'ez highu tedloh, 'ink'ez higha dútezoh. ");
INSERT INTO cafNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hiyootelhtsus 'ink'ez hituzelhghelh. 'Et whulh tat dzin dinadutédalh.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","'Ink'ez njan ndo búlhni, 'aw hubeni tachaóodulhts'it. Bughunek daja ni hubuch'a whuntest'i ho' hoont'ah. 'Aw daja ni ho' 'utni, 'aw t'ehonízun. ");
INSERT INTO cafNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","'Et hukw'elh'az Sizi keyah Jericho wheghah uyalh hoh, dune chawhés'en, 'en ti whuzih usda, 'ink'ez dune ts'un datni. ");
INSERT INTO cafNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","'Et dune lhanah hoh wheghah hudulh hoh 'et hubuduzts'ai. 'Et ndo búlhni. “Et dawhut'en ho' whutni?” ");
INSERT INTO cafNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","'Et 'uhiyúlhni, “Sizi Nazareth whut'en 'en wheghah uyalh.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","'Et hahuyih, “Sizi, David buts'ah hainzut, sugha te'nenzeh!” ");
INSERT INTO cafNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","'Et 'udetsah hedulh khunek ulhtus, 'i be, “T'eduzinih!” hiyúlhni. 'Et whunts'ih 'o nus 'ultus hoh hahuyih, “David buts'ah hainzut, sugha te'ninzeh!” ni. ");
INSERT INTO cafNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","'Et Sizi 'ilhuz nininya 'ink'ez dune chawhés'en duts'un hítoolhte hubúlhni. 'Et Sizi hizih nehinílhti hoh yoodulhkut, ");
INSERT INTO cafNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ndet mba 'uwhutesdlilh hukwa' ninzun?” “Moodihti doo chah whunulh'en nasilhtsi!” ni. ");
INSERT INTO cafNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","'Et Sizi ndi yúlhni, “Ho'en naoondle! Mba 'alha' 'ust'ah 'et huwa soo na'inja.” ");
INSERT INTO cafNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","'Et 'ahoh whunilh'en nasdli, 'ink'ez Sizi yuntezya 'ink'ez Yak'usda délhti. 'Et ts'iyannah, njan 'et honalh'en, 'en chah ts'iyawh Yak'usda hudélhti. ");
INSERT INTO cafNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","'Et Sizi 'aw 'et Jericho ts'ih whutalhuséya. ");
INSERT INTO cafNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","'Ink'ez 'et 'ilhunuh dune 'en 'et usda, Zacchaeus hiyulhni. 'En sooneya 'ilhunanowes'aih hubumoodih, 'ink'ez soode'a. ");
INSERT INTO cafNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","'Ink'ez Sizi ndan 'int'ah yuntelh'ilh hukwa' ninzun. 'Et whunts'ih 'ilhunahuwésdel, 'en bugha 'aw yoo'en ghaít'ah. Ndun dune tube ndukw 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","'Et butsuh telhgai 'ink'ez duchun, Sycamore hiyulhni, yuntelh'ilh ka, 'et hukwa 'i k'ut dugailget. Whuz na'a Sizi hoh wheghah lhuteyalh. ");
INSERT INTO cafNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","'Et Sizi 'et nininya, 'et nduk yútan'en hoh yutelh'en, 'ink'ez ndi yúlhni, “Zacchaeus 'a cho k'an 'ahoh nanaíndaih! K'an dzin nkoo tesdalh huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","'Et 'a cho nanája. 'Ink'ez hoont'i hoh bukoo ts'ih yughu nuséya. ");
INSERT INTO cafNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","'Et ts'iyannah hinalh'en hoh whuts'uh destnih, 'ink'ez howu yahalhtuk hoh 'ulhódutni, “Ndun lubeshi 'ulh'en, 'en yukoo tedalh.” ");
INSERT INTO cafNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","'Et whunts'ih Zacchaeus didinya 'ink'ez Moodihti ndi yúlhni, “SMoodihti whunilh'en, ndai ust'i, 'i ts'iyawh lhulcho tehel'en hubugha itésdlelh. 'Ink'ez ndunnah hubuts'un whusts'it, 'en dit 'et 'uneltsuk, 'i hubutl'anaítes'alh.” ");
INSERT INTO cafNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","'Et Sizi ndi yúlhni, “K'an dzin dune hiye dujih, 'i hoh njan bukoo hudelhts'i hubugha íyults'ut. Ndun 'en chah Abraham yuts'uh hainzut ho' 'int'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","'Alha ndunnah tinta huninkat, 'en yinkak dune ye', 'en hubukúnteta 'ink'ez hubutelhyih ka, 'et whuba whusainya.” ");
INSERT INTO cafNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","'Et njan hidants'o hoh ndai 'uyoo khunek be whúts'odul'eh, 'i be hubulh yawhenílhtuk. Jerusalem wheghah hedulh 'ink'ez ts'iyannah 'uhuninzun ndet Yak'usda hubudayi cho unli, 'aw 'et soo 'ahoh wheóoduteltsilh huninzun. ");
INSERT INTO cafNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","'Et huwa ndez na'a ndo búlhni, “Ilhunuh dune ncha, 'en nilhdza keyah ts'ih teyalh. 'Et whuz ninya t'eh, 'et ndun nts'ez de dukeyah ts'ih hainya, 'et whuz hubudayi cho hitelhtsilh. 'Ink'ez dukeyah ts'ih nátedalh. ");
INSERT INTO cafNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Teyalh whutsuh lanezi dude 'ulhna 'anih hubudani. 'Ink'ez ilhughun hinli hoh sooneya dezti, 'i 'ilhuk'i hoh butl'aína'ai, 'ink'ez ndo búlhni, ‘Whusanátesdalh whuts'un be 'óoht'en 'ink'ez be 'ahóhleh.’ ");
INSERT INTO cafNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","'Et whunts'ih bulh keyah whut'en hika cha'nizil. 'Et whinya hukw'elh'az 'ahoh njan keyah whudune, 'en bulunah 'utahaóobahanla, 'en keyah whunat whuz whebahalh'a huba yahutelhtuk ka, ‘'Aw ndun dune 'aw nedayi cho wule hukwa cha'uznízun,’ hutni. ");
INSERT INTO cafNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","'Et ndun dune hubudayi cho suli hoh whusanája, 'et ndunnah dude 'ulhna, ndunnah sooneya hubutl'ain'ai, 'en 'anih hubúlhni. 'Ilhunah hinli hoh daltsuk hiba inla 'et nahooté'alh hukwa' ninzun. ");
INSERT INTO cafNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","'Et 'udechoo yughu ninya 'ink'ez ndi yúlhni, ‘SMoodih ndi sooneya dezti, 'i suzih niní'ai, 'i be lanezi 'uneltsuk, 'i be mba 'usdla.’ ");
INSERT INTO cafNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","'Ink'ez ndi yúlhni, ‘Se'ulhna, tube soo 'ínja! Ntsolyaz ntl'anádzai, 'i ts'ah'un na'a be ne'zint'en. 'Et huwa lanezi keyah whuti whumoodih tanleh 'et ntl'ahó'ai.’ ");
INSERT INTO cafNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","'Et bulh nanah whusainya 'ink'ez ndi yúlhni, ‘SMoodih nzooneya dezti, 'i suzih nine'ai, 'i be skwunlat 'uneltsuk, 'i be mba 'usdla,’ yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","'Et ndun ndi yúlhni, ‘'Et huwa nyun chah skwunlat keyah whuti whumoodih tanleh, 'et ntl'ahó'ai.’ ");
INSERT INTO cafNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","'Et 'uyoon chah yughu ninya 'ink'ez ndi yúlhni, ‘SMoodih soo zelhts'ai. Nah njan nzooneya dezti, 'i suzih není'ai. 'I dzezoh be be' lhasílhchuz 'ink'ez 'et mba nine'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","'Aw dune gha te'ninzun chaínlah t'enyunúszun, 'et huwa nyenlhújut. Ndai nye'ildzun chailah, 'i whunts'ih nailchukw. Ndai hachanilel, 'i whunts'ih hanínle,’ yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","'Et ndi yúlhni, ‘Nyunch'oh nzek hoh dája dini, 'et hoh mba nahutesyih. Se'ulhna intsi', 'aw huba inzoo hoolah. T'eooninzun dant'ah dune usdli. Ndai 'ilhuchaghuzus'ai 'i whunts'ih 'ulhchukw. 'Ink'ez ndai hachaznílel, 'i whunts'ih hanúsdlih 'ink'ez be sooneya 'ulh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","'Et hoh da di ka ndunnah sooneya lhk'enanduna'aih suzooneya 'en butl'achayí'al? 'Et t'eh da, whusanasja t'eh, 'o 'un be 'ahósdleh?’ ");
INSERT INTO cafNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","'Et t'eh 'onghah nadelhúya ndo búlhni, ‘Ndi sooneya dezti, 'i bugha nailhúchoot. 'Ink'ez ndun lanezi 'inla, 'en bugha ínah'aih.’ ");
INSERT INTO cafNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","'Et whunts'ih 'uhiyulhni, ‘Moodih 'uda 'aw 'et lanezi ut'i.’ ");
INSERT INTO cafNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","'Et ndun hubudayi cho 'en 'utni, ‘Ndunnah hoonliyaz hit'i, 'en 'o 'un lhai bugha itét'alh. 'Ink'ez ndan hoonliyaz chait'ih, ndai 'aw 'i yut'i, 'i whunts'ih bugha nayutélchulh. ");
INSERT INTO cafNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","'Et ndunnah such'a hudetni 'en, sukacha'hunízun hoh hubudayi cho tesdle, 'en ts'iyawh sábahle 'ink'ez soo subut 'et hubahghan.” ");
INSERT INTO cafNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","'Et ndo hubudani hukw'elh'az Sizi Jerusalem ts'ih hutezdel hoh hubutsuh tezya. ");
INSERT INTO cafNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","'Aw 'et dzulhyaz, Olive hiyulhni, 'et keyah whuyaz Bethphage 'ink'ez Bethany huwhutni dzulhyaz zih whuzdla. 'Et dzulhyaz wheghah hedulh hoh nanah yugha hoodul'eh hubutélh'a. ");
INSERT INTO cafNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","'Ink'ez 'utni, “Keyah wheyaz nuhghanch'az ts'ih whuz ah'us. 'Aw 'et keyah wheyaz nenah'az t'eh, 'et 'ilhunuh yeztliyaz, donkey hiyúlhni, whédint'uk, 'i 'aw whutsuh da 'awhuz dune yuk'uchaíduh, 'i teh'ilh. 'I lhk'unadóoh'uk 'ink'ez ndez tóolhdlooh. ");
INSERT INTO cafNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","'Et dune nuhuhóodulhkut t'eh, 'et dant'i ka 'ulh'en lhk'unaduh'uk? 'Et njan ndúdoohni, neMoodihti yuka' ninzun.” ");
INSERT INTO cafNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","'Et ndunnah whebalh'a whuz lhghuhudi'az hoh, soo nts'e na'a daja ni, 'et whuz na'a nahuhoo'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","'Aw 'et ndi yeztliyaz lhk'unaidú'uk hoh ndunnah hubube'ildzun, 'en 'uhútni, “Ndi yeztliyaz dant'i ka 'ulh'en lhk'unaduh'uk?” ");
INSERT INTO cafNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","'Ink'ez 'et ndo buhútni, “NeMoodihti yuka' ninzun.” ");
INSERT INTO cafNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","'Aw 'et Sizi highu hinílhdlukw. 'Ink'ez dich'oh dunaih yeztliyaz hik'ehíyinla, 'ink'ez Sizi hik'ehíyilhti. ");
INSERT INTO cafNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","'Aw 'et tezya hoh ti yun dunaih hiba nehíyuzbuz. ");
INSERT INTO cafNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","'Aw 'et njan dzulhyaz, Olive hiyúlhni, 'aw 'et wheduhándel hoh 'et huwu nilhdukw hoh, 'et lhanah yugha hoodul'eh huhóost'et. 'Et ndet huwa 'ét'en tune'ust'en 'et honalh'en, 'et huwa soo tube cho Yak'usda hidélhti. ");
INSERT INTO cafNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","'Ink'ez 'uhutni, “Hubudayi cho 'en Moodihti boozi be whusainya, 'en degha nus hoonzoo bugha whults'ut! Nduk yak'uz 'et soo whudutéghel, 'ink'ez 'et soo dugha ndoh 'et k'us whudutéti.” ");
INSERT INTO cafNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","'Et bulunah Pharisee hubutah hits'un hahúyih, “Dune hoodulh'eh, ndunnah nye hóodul'eh, 'en hukwa' hubudini!” ");
INSERT INTO cafNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","'Et whunts'ih ndo búlhni, “Ndun whudusni, njan t'ewhudusnih t'eh, tse 'i whunts'ih da 'ahoh yatoolhdih.” ");
INSERT INTO cafNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","'Et keyah whuti wheghah uyalh, 'et Jerusalem whutelh'en hoh howintse. ");
INSERT INTO cafNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","'Ink'ez 'et ndutni, “Nuhwheni Jerusalem whut'en, nuhwheni whunts'ih, k'an dzin soo cho uncha t'eoonahzun nuhdzin 'uhoont'ah. 'Et huwa da t'eoonóhzin nts'e na'a hoh nuhwhuba whudutéghel. 'Et whunts'ih k'an whuts'un nuhna ch'a whuntest'i. ");
INSERT INTO cafNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","'Et hoh t'eh dzin whusawhutelts'ulh ndet nuhch'a detni, 'en nuhna'hutegus. 'Ink'ez lhez lhk'ehitelhkulh nuhnat ndulhcho hoh, 'ink'ez whez ts'ih nuhuhootetun. ");
INSERT INTO cafNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","'Ink'ez njan keyah whuti lhk'unahuhootélhkulh. 'Ink'ez ndunnah whez ts'ih hudelhts'i, 'en chah ts'iyawh hubulh 'uwhútenilh. 'Aw 'ilho tse lhk'udez'ai, 'i nuhwhuba 'et nenachaídutes'al. Nts'oh huwa whudezulh 'uhooja nuhulyis nuhts'un whusateyalh, 'aw t'echaoonáhzil, 'et huwa whuz na'a 'uwhuténilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","'Et luglez whucho whuna'nesdutl'oo daninya 'ink'ez 'uhooket 'ink'ez 'é'hooket, 'en ts'iyawh tináoobunenyoot. ");
INSERT INTO cafNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","'Ink'ez ndo búlhni, “Uk'e'eduguz ho' njan ndutni, ‘Sukoo 'et tenadudli bakoo 'úhoont'ah.’ 'Et whunts'ih 'et chah njan ndutni, ‘'Uhundunut'ih bakoo whuzúlhtsi.” ");
INSERT INTO cafNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","'Ink'ez 'et nyooz luglez whucho dzin totsuk dune hubodulh'eh. 'Et whunts'ih soo nawhulnuk degha nus dézti, 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz, 'ink'ez dune tsuh whudelhdzulh chah, ts'iyawh nts'e na'a hituzelhghelh 'et hukwa hités'en. ");
INSERT INTO cafNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","'Et whunts'ih 'ilhunahuwésdel, ts'iyawh hinat nodelhúya 'ink'ez soo cho hiyoozélhts'ai. 'Et huwa 'aw ndunnah hizoolhghelh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","'Et hoh da 'et 'ilhudzin ndez na'a 'et ndúhooja. Luglez whucho Sizi dune hoodulh'eh hoh khunek unzoo, 'i be hubulh yalhtuk hoh nawhulnuk degha nus dézti, 'ink'ez Moses be' dustl'us 'uk'ununa'usdúguz chah, 'ink'ez ts'iyannah dune netsuh whudelhdzulh, 'en khunek be hik'udughaínya. ");
INSERT INTO cafNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","'Ink'ez 'uhiyúlhni, “Nedini ndai bugha dune bugha ndoh 'int'ah hoh ndi 'ut'en oowaghina? K'us ndan ntl'ahón'ai hoh 'udini?” ");
INSERT INTO cafNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","'Et whunts'ih ndo búlhni, “Si chah 'ilhunuh hukwa nuhoodutelhkut, 'et úsudáhni, ");
INSERT INTO cafNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","nts'e na'a John dune too be 'úlh'en? Ndan yutl'aho'ai dune too be telh'ilh huba? Yak'uz ts'ih tulih hawhélts'ut, k'us ndi yun k'ut dune tulih ts'ih hawhélts'ut?” ");
INSERT INTO cafNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dich'oh lhtah howu yahalhtuk 'ink'ez 'ulhadutni, “Et yak'uz whuts'un tulih hawhélts'ut ts'utni t'eh, 'Et di ka John nuhwhuba 'alha' cha'dusnih, nedóni. ");
INSERT INTO cafNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","'Et whunts'ih dune ts'ih hawhélts'ut, ts'utni t'eh, 'et dune ts'iyannah tse be nehooghan. John 'en nus whunilh'en 'int'ah 'et huba 'alha 'uhoont'ah 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","'Et Sizi ndi hiyulhni, “Aw nts'ez de hawhélts'ut t'ets'onízun.” ");
INSERT INTO cafNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","'Ink'ez Sizi ndo búlhni, “Ndai be dune bugha ndoh 'ust'ah hoh ndi njan nduwhúlh'en, 'et si chah 'aw nuhwhudóosni ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","'Aw 'et 'uyoo khunek be whúts'odul'eh, 'i be hubulh yawhénilhtuk hoh njan ndutni, “Ilhunuh dune haniyeh k'et mai too mai 'ananla. 'En njan haniyeh k'et ndunnah há' nulhyeh bughu whulh'ai, 'ink'ez sa whuts'un nilhdza keyah ts'ih whinya. ");
INSERT INTO cafNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","'Aw 'et mai oonteje néwhuninzut hoh 'ilhunuh 'ulhna hubuts'ú wheyalh'a. 'Et ndai mai buts'ítekulh, 'i bulah higha ínoodzaih. 'Et whunts'ih ndunnah haníyeh k'et bughu whulh'ai, ndun 'ulhna yahíyalhchus 'ink'ez, whenáhinanyoot. ");
INSERT INTO cafNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","'Et doo chah 'uyoon 'ulhna buts'ú whelh'a. 'En chah yahíyalhchus, 'ink'ez hooya hiyulhtsi, 'ink'ez 'en chah, whenáhinanyoot. ");
INSERT INTO cafNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","'Et búlh tanah dude 'ustl'en buts'ú whelh'a. 'En chah nukai hiyulhtsi 'ink'ez tináhinino. ");
INSERT INTO cafNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","'Et haníyeh k'et whut'i 'utni, ‘Daoosneh chah simba? Sich'oh suye' buk'esi', 'en buts'ítoolh'a. 'En tulih hiyan'en t'eh, 'int'ah k'una'a né'hiyoolh'en,’ ni. ");
INSERT INTO cafNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","'Et whunts'ih ndunnah bughu whulh'ai hitelh'en hoh 'et 'ulhódutni, ‘Ndun 'en nyoo haníyeh k'et bube'ildzun 'en buye' 'út'en. Ts'uzoolhghelh! 'Et t'eh ndet buts'ó telts'ulh ts'iyawh 'et ndúwhulcho hoh nets'ó toolts'it.’ ");
INSERT INTO cafNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'Et njan haníyeh k'et tináhinino 'ink'ez hizelhghi. 'Et huwa soo cho 'ún whudusni, ndan haníyeh k'et bube'ildzun hoonli, dabóoleh simba? ");
INSERT INTO cafNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ndez na'a njan dutenilh, whusanátedalh 'ink'ez ndunnah mai k'et bughu whulh'ai, 'en ts'iyawh hoolah hubutelhtsilh. 'Ink'ez bumai haníyeh k'et 'uyoon, 'en bugha íte'alh.” 'Et dune hohodánts'o hoh 'uhutni, “Aw uncha 'et nduchahóonil!” ");
INSERT INTO cafNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","'Et Sizi hubunilh'en 'ink'ez 'utni, “Ndi Yak'usda bughunek daja ni hoh 'uk'e'eduguz, ‘Ndi tse koo 'uwhuhulh'en 'ún hidutelh'uz, 'i koo huk'uwhuz'ai huba soo degha nus tse 'int'ah, 'i suli.’ ");
INSERT INTO cafNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ndunnah ndi tse hik'elts'ut, 'en ts'iyawh yahutelkulh. 'Ink'ez ndunnah ndi tse buk'édilts'ut, ts'iyawh hoolah hutele.” ");
INSERT INTO cafNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ndunnah Lizwif náwhulnuk bumoodih, 'ink'ez ndunnah Moses be' dustl'us 'uk'ununa'úsduguz, 'en chah, 'et soo 'et dzeh 'uhunet'oh, 'en Sizi hiyólhchoot hukwa' hut'en. 'Et whunts'ih ndunnah dune hubé hunuljut 'et hubugha 'aw 'uhooneh ghaít'ah. T'ehoninzun ndi khunek bé whuts'odul'eh, 'i be didut buch'a yalhtuk hoh 'utni 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","'Ink'ez highunli, 'ink'ez ts'ah'un 'int'ah na'dudil'i nunúl'i, 'en hits'un whehíyalh'a. 'En khun teh Sizi ye yalhtuk, 'i bugha hiyoolhgooh. 'Et t'eh yun k'ut whut'en bumoodih yutl'ahíyoolhtelh. 'En 'int'ah hoolhtus tune'út'en ne'ut'en, 'ink'ez ts'iyannah k'une' 'ul'en. ");
INSERT INTO cafNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","'Et nunúl'i hiyoodulhkut, “Whunehodulh'eh t'ets'oninzun ts'ah'un na'a yailhtuk. Ts'iyannah mba lhgha 'int'ah. 'Et ts'ah'un na'a Yak'usda k'una'a dune hodilh'eh. ");
INSERT INTO cafNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nedini ndi yun hik'elha hiyilh'i, 'i tax hiyúlhni, 'i 'et ts'ah'un tulih 'uhoont'ah hoh hubudayi cho Caesar 'en buba k'elha ts'uyoolhtsilh, k'us 'awundooh tulih?” ");
INSERT INTO cafNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","'Et whunts'ih Sizi t'eooninzun 'aoonilhka 'uhutni. 'Ink'ez ndo búlhni, “Di ka sóolhdzih? ");
INSERT INTO cafNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","De' nusooneya sunalhts'et nah'a! Ndan bunen 'ink'ez boozi chah 'uk'une'úsduguz?” 'Et 'uhiyúlhni, “Hubudayi cho Caesar 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","'Et Sizi 'utni, “Et huwa ndai hubudayi cho Caesar bube'ildzun, 'i butl'anáyahle. 'Ink'ez ndai Yak'usda bube'ildzun, 'i chah Yak'usda tl'anáhle.” ");
INSERT INTO cafNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ndai khunek be dune hubulh yailhtuk, 'i bugha 'aw huyoolhgooh ghaít'ah. 'Et njan ts'iyannah nalh hubudáni hoh tube huba hooncha suli, 'ink'ez ndunnah nunúl'i, 'en ts'iyawh t'ehudínil. ");
INSERT INTO cafNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","'Et bulunah Saducee Sizi highu nindel. 'En 'uhutni dats'úzsai 'ink'ez 'aw nats'ukhóotnah ghaít'ah. 'Ink'ez hiyoodulhkut, ");
INSERT INTO cafNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Dune hoodulh'eh njan Moses daztet'ilh neba 'uk'e'anguz ho' hoont'ah. 'Et 'ilhunuh dune buzkeh hoolah hoh dazsai 'ink'ez bu'at khuna t'eh, ndun dune bulhutsin 'en dughe inle yughu naooda huba' hoont'ah. 'Ink'ez bubuzkeh whúzdli t'eh, 'et ndunnah buzkeh ndan dazsai, 'en boozi hiyóolhchoot huba' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","'Et 'uhoont'ah skwunlat 'o 'at nanah lhulhutsinkah hoonli. 'En 'udetsah whudelhdzulh, 'en 'at ut'i. 'Ink'ez 'aw buzkeh hoolah hoh dazsai. ");
INSERT INTO cafNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","'Et bulh nánah 'en ndun ts'eke yughu nasda. 'En chah ndun dune buzkeh hoolah hoh dazsai. ");
INSERT INTO cafNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","'Et bulh tanah, 'en chah yughu nasda. 'Et whuz na'a zeh ts'iyawh skwunlat 'o 'at nanah 'en ts'iyawh ndun ts'eke highu dálts'i. 'Ink'ez ts'iyawh bubuzkeh chahóolel hoh yahadla. ");
INSERT INTO cafNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","'Et 'udek'elh'az ndun ts'eke 'en chah dazsai. ");
INSERT INTO cafNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","'Et ndet dune dinadidel t'eh, ndun ts'eke ndan bu'at tele? Ndunnah skwunlat 'o 'at nanah, 'en ts'iyawh ndun ts'eke 'en hubughinda 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","'Et Sizi ndo búlhni, “Dune 'ink'ez ts'ekoo teh ndi yun k'ut ts'iyawh lhgho delhts'i. ");
INSERT INTO cafNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","'Et ndet hoh t'eh whusawhútelts'ulh hoh ndunnah Yak'usda ba hoonzoo hoh bughá whults'ut yaidla tah dinahudutédulh 'ink'ez yak'uz hutedulh. Whuz 'aw dune lhghu chadílts'ih ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","'Aw doo chah yahódlah ghaít'ah. 'En Yak'usda buzkeh huzdli 'ink'ez lizas hubulh lhugha 'uhint'ah. 'En hudujih 'uhint'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","'Ink'ez Moses 'en ts'ah'un newhuni'ai yaidla dinahudutédulh ho' hoont'ah. 'Et hoh da njan dahooja 'ut'an delhtan, 'i tah whudezk'un 'et whunts'ih 'aw whudóok'un ghaít'ah. 'En Moodihti ghu yalhtuk hoh njan ndutni, ‘Abraham buYak'usda, Isaac chah buYak'usda, 'ink'ez Jacob chah buYak'usda 'int'ah,’ ni. ");
INSERT INTO cafNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nuhwheni 'uts'un na'a 'unahzun. 'Aw yahadla hubuYak'usda chailah, hukhuna hubuYak'usda 'int'ah. Soo cho whunulh'en, 'en be ts'iyannah hukhutena.” ");
INSERT INTO cafNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","'Ink'ez bulunah Moses be' dustl'us 'uk'ununa'úsduguz 'uhiyúlhni, “Dune hoodulh'eh tube soo' denja!” ");
INSERT INTO cafNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","'Et whehunelhújoot k'et 'aw 'o 'un hiyoodolhkut ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","'Ink'ez ndo búlhni, “Nts'e na'a bulunah nduhútni, Christ dahni, 'en David yuts'a hainzut 'int'ah? ");
INSERT INTO cafNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David dich'oh 'et ndutni njan Yak'usda bughunek Shun be' dustl'us k'ut, ‘Moodihti 'en SMoodihti ndi yúlhni, Sunailhni ts'ih sinda, ");
INSERT INTO cafNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hoh t'eh nch'a hudetni, 'en hubuk'ut nke naóolhyis mba huboolhtsilh.’ ");
INSERT INTO cafNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","'Et huwa David, ‘SMoodihti,’ yulhni, nts'e na'a simba Christ 'en yuts'u hainzut wule?” ");
INSERT INTO cafNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","'Et ts'iyannah dune huyoozelhts'ai hoh Sizi yugha hoodul'eh 'et ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Moses be' dustl'us 'uk'ununa'úsduguz, 'en naih nyiz, 'i be húdelhts'i, 'ink'ez ndet ts'uyi, 'i be 'óoket, 'et ts'iyannah hubodélhti hoh dahooja buhútni, 'et huhóont'i. 'Ink'ez Lizwif hubuluglez soo k'us hoonzoo hudutélts'ilh hukwa' huninzun. 'Ink'ez dune ghunuda, soo k'us hoonzoo huteda huka' huninzun. 'Et ndunt'ah soo cho buka tsi hoohli! ");
INSERT INTO cafNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","'En 'uhint'ah tsandelh bukoo hubugha ha'hudunent'ah 'ink'ez bughu huhoolhchukw. 'Ink'ez 'aoonilhka sa cho tenahududli huhoolh'i. Ndunnah, 'en 'o nus 'uwhulcho hoh huba nahutedeh.” ");
INSERT INTO cafNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","'Et doo chah nyoh yutá'en hoh ndunnah soode'a 'uhint'ah ndai sooneya howa híte'alh, 'en sooneya bé kat, 'i be hína'aih, 'et hubunilh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","'Ink'ez 'ilhunuh tsandelh tel'en, 'en ndai 'aw 'iyaz yit'i, 'i nankoh sooneya chaditi, 'i dená'aih. ");
INSERT INTO cafNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","'Ink'ez ndo búlhni, “Alha 'ún whudusni, ndun tsandelh tel'en, ndunnah ts'iyawh huba 'o nus lhai dená'aih ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Soo cho whunulh'en, ndunnah soode'a 'uhint'ah ndai lhai hiyít'i, 'i Yak'usda ba hilah zeh dehína'aih. 'Et ndun tsandelh tel'en 'aw 'i yuk'ehútenalh, 'i ts'iyawh dená'aih.” ");
INSERT INTO cafNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","'Et bulunah 'aw 'et luglez whucho howu yahalhtuk 'ink'ez 'uhútni, “Lhe'whuldzoo tse lhe'ildzoo 'i be 'uhoolya. 'Ink'ez Yak'usda bugha t'aih 'i chah 'i be 'uhoolya.” 'Et Sizi ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ndai ndi ts'iyawh nulh'en, 'et njan whusawhútelts'ut t'eh 'aw lhuk'i tse lhk'uchadutésdlal, ts'iyawh nadúntejulh ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","'Ink'ez hiyoodulhkut, “Whuneoodulh'eh, nts'oht'ah 'uwhuténilh? 'Ink'ez 'aw 'et nilhdukw suli t'eh, dant'i be wheóoduteltsilh, 'i be t'ewhuntehzeh?” ");
INSERT INTO cafNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","'Ink'ez ndo búlhni, “Soo cho howahli. Khun teh dune nanohonoo'ah gunih. Lhanah soozi bugha whusahútedulh 'ink'ez 'uhudutenilh, ‘Si 'en 'ust'ah,’ 'ink'ez 'aw 'et whusawhútekulh, hutni t'eh, khun teh hubuntoohya gunih. ");
INSERT INTO cafNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dune nehughan whulh 'úduzahts'ai t'eh, 'ink'ez dune lhulhdulhyah nehóninla t'eh, njan 'et 'udechoo whusawhútekulh ho' hoont'ah. Khun teh whénoolhujut gunih. 'Awhuz whulatah, 'aw wheghah ilah 'uhoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","'Et ndo búlhni, “Lhulhyoo dédowh, 'en lhch'a nehúdutedulh. 'Ink'ez yinkak ndulhcho hubudayi cho be 'ustl'en, 'en chah lhch'a nehúdutedulh. ");
INSERT INTO cafNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Lhelhdun, 'et chah ndulhcho hoh wheóonujut yun nutughétnah. 'Ink'ez dai chah 'ink'ez lhanah lhelhdun chah dada whutéleh. 'Et nduk yat'ah dune wheoonujut hote'ilh, 'ink'ez hooncha hoh be wheóoduteltsilh chah hote'ilh. ");
INSERT INTO cafNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","'Et nduwhútenilh whutsuh, 'et nanwhútelcholh 'ink'ez dzuh nunóhotelhdeh. Lizwif hubuluglez whumoodih, 'en butl'anóhotelelh 'ink'ez tsak'e nohotelelh. 'Ink'ez hubudayi cho 'ink'ez yun humoodih, si soozi bugha 'en hububut ninuhotelelh. ");
INSERT INTO cafNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","'Et t'eh si sugha khunek unzoo, 'i be yatelhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","'Et hoh t'eh, ‘Daja doosni simba,’ noohzin gunih. ");
INSERT INTO cafNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Khunek 'ink'ez be wháhnih, 'i nuhtl'adutes'alh. 'Et sih ndunnah nuhch'a hudetni, 'en 'aw nuhts'oohoodódlai ghaít'ah. 'Aw 'et buch'a' nilhde 'ink'ez 'aw 'o 'un hoonliyaz 'uhudooni ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","'Ink'ez nuhwhulhdusnekah, 'ink'ez nuhwhulhutsinkah, 'ink'ez nuhwhulhtuskah, 'ink'ez nuhwhulhdunekah, 'en whutl'anóhotelelh 'ink'ez bulunah nuhtah nuhoteghan. ");
INSERT INTO cafNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","'Ink'ez si soozi bugha ts'iyannah nuhts'u dutetnik. ");
INSERT INTO cafNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","'Et whunts'ih Yak'usda 'aw nuhla dootnih ghaít'ah. Nuhtsigha 'aw lhuk'i whunts'ih tinta dóokes ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yak'usda ba soo cho bulh nudelhúya. 'I bugha nuhzul óhtun. ");
INSERT INTO cafNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ndet Jerusalem nehughan whuna'húsduguz, 'et whunulh'en t'eh, 'et huwa t'eoonoohzeh 'aw 'et nilhdukw suli njan keyah whuti hoolah whutelhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","'Et ndúhooja t'eh, 'et Judea whut'en dzulhyaz k'uz ts'ih hutoolhdelh. 'Et ndunnah 'et keyah whuti 'et hudelhts'i, ts'iyawh whuch'a hóodelh. 'Ink'ez ndunnah whunat huwhut'i, 'en chah khun teh keyah whuti ts'ih hutooya gunih. ");
INSERT INTO cafNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","'Alha 'un whudusni 'aw 'et dzuh nutehzut whusawhutelts'ulh ho' hoont'ah. 'Et hubugha 'uk'e'wheduguz, 'et ts'iyawh lhaóodutenilh. ");
INSERT INTO cafNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","'Et hoh dzin ndunnah hélchan chah, 'ink'ez ndunnah hubuzkeh 'e'úlht'ukw chah, 'en huba tube 'o nus whutétsi'. Ndi yun hoontsi' buk'e whudutelts'ulh 'et huwa. 'Ink'ez tube Yak'usda ye húnilch'e, 'i chah ndunnah dune hubuk'eidutelts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","'Et bulunah soh cho buk'a be ts'iyawh hudutedúghan. 'Ink'ez 'onghunnah hitélhcholh 'ink'ez lhelhdun keyah ts'ih hubotelhna. 'Ink'ez 'udun yun k'ut whut'en, huba ni'unduguz, 'et whuts'un, Jerusalem 'et nduhóolhcho hoh hukw'unátedulh. ");
INSERT INTO cafNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Sa, 'ink'ez 'ulh'ek ooza, 'ink'ez sum chah, 'i ts'iyawh hoonliyaz 'i be hóoduteltsilh. 'Et ndi yun k'ut ndulhcho hoh lhenyoonah dune, 'en ts'iyawh tube dzuh natedeh 'aw dahútenilh ts'iyawh t'ehonízun. Hoh t'eh yatoo 'i chah tatsi tadetnik hoh taba ndulhcho yánteghus. ");
INSERT INTO cafNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ndi yun k'ut daóotenilh hukwa tsi húhooli 'ink'ez whehunuljut k'et, bulunah budzi 'ustl'e' 'utenilh. Nduk yat'ah ts'ih be hóolhtus, 'i ts'iyawh ndulhcho nuhówutughetnah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","'Et t'eh, yinkak dune ye' kw'us tah ye úlhtus, 'i be 'ink'ez buts'uh hayánduz, 'i chah, 'et whuz na'a hiyuntelh'ilh hoh whusatéyalh. ");
INSERT INTO cafNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","'Et ndez na'a njan nduwheóonit'en t'eh, nduk yutooh'en 'ink'ez whunoolhnik. Lubeshi buch'a nanhóotekulh 'aw 'et niooninzut suli 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","'Et be náwhutnuk 'i be whuts'odul'eh 'i be hubulh yalhtuk hoh njan ndo búlhni, “Ndi fig hiyulhni buduchun 'ink'ez 'uyoo duchun chah nulh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bindak 'aw 'et hawhenilh'az 'i bugha t'eoonohzin dain 'aw 'et nilhdukw ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","'Et nuhwheni chah whuz na'a nuhnalh 'et nduwhút'en t'eh, 'et huwa t'eoonoohzeh nts'e na'a hoh Yak'usda hubudayi cho unli 'aw 'et nilhdukw ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","'Alha ts'ah'un na'a 'ún whudusni, k'an njan whudezulh, 'en 'aw yachahutésdla 'et njan ndótenilh ts'iyawh 'et lhawhúdutenilh 'et whuts'un. ");
INSERT INTO cafNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yat'ah 'ink'ez ndi yun k'ut 'i chah hoolah whutéleh, 'et whunts'ih ndi sughunek 'aw hoolah chatesdle. ");
INSERT INTO cafNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Et whunts'ih soo cho khahdli. Khun teh stabe zoodulhú'i, 'ink'ez tanahtnai, 'ink'ez ndi yun k'ut hooni 'et zeh huwu nuní nahzut, ndi ts'iyawh 'i be nuhdzi be whudoobun gunih. Doo ka si 'et dzin soo hukwa tsi chawhahlih 'et whusawhútelts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hoh t'eh, ndi yun k'ut ndulhcho hoh whudune lhugooh li'hutenilh whuz na'a khun whusaóotelts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","'Et huwa 'ahoolhyez hukwa tsi hóohli 'ink'ez nts'oh whute daóotenilh nuh'et 'uwhuténilh huba soo 'ulhúdzoo 'ink'ez yinkak dune ye' 'en bubut tehyin, 'et huba tenadoohdli.” ");
INSERT INTO cafNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","'Aw 'et dzin totsuk Sizi luglez whucho dune hubodulh'eh. 'Ink'ez hulhgha totsuk ndoh dzulhyaz, Olive huwhútni, 'et whuz whenádaih, tetelh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","'Et ts'iyannah soo 'uda cho luglez whucho dahúdulh hiyootuzélhts'ilh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","'Aw 'et ndi lhes nachantulhúdoh, 'i nahitet'ulh, 'aw 'et wheghah whezulh. 'Et Hubutus Lhuseya dzin huwhútni. ");
INSERT INTO cafNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","'Ink'ez ndunnah nawhulnuk degha nus dézti, 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz, 'en Sizi hituzilhghelh, 'et hukwánuta. 'Et dune hube hunuljut 'et huwa nonut'i be né'hut'en. ");
INSERT INTO cafNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","'Ink'ez Satan, 'en Judas ye ghínya. 'En 'int'ah Iscariot hiyulhni. Lanezi 'o 'at nanah, 'en hubutah 'ilhunuh 'en 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","'Et náwhulnuk bumoodih 'ink'ez lhuhudúghan bumoodih chah 'en hubuts'uh whinya 'ink'ez hubulh hukw'anótelhye nts'e na'a Sizi hubutl'aitelhtelh 'et. ");
INSERT INTO cafNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","'Ink'ez 'aw 'et huhóost'et hoh ts'ah'un hiyúlh niwhuni'ai 'ink'ez sooneya highan té'alh hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","'Aw 'et Judas buts'uh náhezya nts'e na'a 'ilhuhowezdel hubuch'a hubutl'aitelhtelh, 'et hukwunúta. ");
INSERT INTO cafNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ndet 'aw 'et lhes nachanteldoh, 'i nahitet'alh dzin whusawhélts'ut. 'Et Hubutus Lhuseya 'et whunahulnih hoh ndi sheep k'us unzoo, 'i nahituzelhghelh. ");
INSERT INTO cafNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","'Et Sizi, Peter 'ink'ez John bulh whuz wheoobalh'a 'ink'ez ndo búlhni, “Ah'us 'ink'ez neba lhaoodahleh nts'e Hubutus Lhuseya 'et na'uztet'alh.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","'Ink'ez ndi hiyúlhni, “Nts'e hukwa' ninzun mba lhats'ódutelelh?” ");
INSERT INTO cafNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","'Ink'ez ndo búlhni, “Soo zelhts'ai, ndet keyah whuti nináh'az t'eh, 'et dune nuhdudutéyalh. 'En too be dezbun 'i niya'a. 'En nts'e bukoo danátedalh ts'ih whuz buntóoh'as. ");
INSERT INTO cafNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","'Ink'ez 'et ndun bukoo whumoodih 'en 'udóohni, ‘Whuneodulh'eh njan ndúnyulhni, ndet 'uhoont'ah nkoo dune 'ilhoghudulh 'uha'alh wheni? 'Et sugha hoodul'eh ndi Hubutus Lhuseya hubulh ná'test'alh.’ ");
INSERT INTO cafNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","'Ink'ez 'et nduk yuh hooncha lhaoodint'ah whunóhnoolhtun. 'Et lhaoodahleh.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","'Et whehá'az hoh soo nts'e na'a hubudáni, whuz na'a nahahoo'ai. 'Ink'ez 'et Hubutus Lhuseya 'et wheni lhaháduja. ");
INSERT INTO cafNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","'Aw 'et wheghah whudezulh whusawhélts'ut, 'et ndunnah lanezi 'o 'at nanah whel'a hubulh natl'adeda. ");
INSERT INTO cafNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","'Ink'ez ndo búlhni, “Dzuh nuteszut whutsuh sudzi ndulhcho, 'i be njan Hubutus Lhuseya 'et nohwhulh ná'test'alh tube hukwa' nuszun. ");
INSERT INTO cafNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","'Alha 'ún whudusni, nts'e Yak'usda hubudayi cho unli, 'et ts'iyawh lhaoodutenilh, 'et whuts'un, 'et ndi Butus Lhuseya 'aw 'o 'at naóost'alh ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","'Aw 'et lubot yilhchoot 'ink'ez be'aBá suchanailya yulhni 'ink'ez 'utni, “Ulhchoot 'ink'ez ts'iyawh 'ilho ahtnai. ");
INSERT INTO cafNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ndun whudusni, nts'e Yak'usda hubudayi cho unli, 'et whusawhutelts'ulh 'et whuts'un, doo chah 'aw ndi mai too wusnai ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","'Et lhes yilhchoot. Be'aBá suchanailya yulhni, taídalhkut 'ink'ez butainínla, 'et ndo búlhni, “Ndi suyust'e 'int'ah. Nuhwheni nuhwhuba huwalti. 'Et ndaht'en t'eh, 'et hoh sunaoolhúnih.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","'Uhan'al hukw'elh'az 'et whuz na'a zeh lubot yílhchoot 'ink'ez 'utni, “Ndi lubot 'i suzkai be k'an khunek nuhwhuba lhadúsdla, 'i 'int'ah. Nuhwheni nuhwhuba nadútelt'ih. ");
INSERT INTO cafNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","'Ink'ez soo cho whunulh'en, ndun whu'izyaz dune ch'a detni, 'en njan kw'uzdai gha sulh usda. ");
INSERT INTO cafNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","'Alha' hoont'ah yinkak dune ye', nts'e na'a buba 'et níwhults'ut, 'et whuz na'a 'et 'uwhuténilh. 'Et whunts'ih ndun dune whu'izyaz dune tl'aitelhtelh, 'en dáwhultsi' buts'uh whélts'ulh!” ");
INSERT INTO cafNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","'Ink'ez hedich'oh lhutah lhuhoodulkut, “K'us ndan simba 'uyúlhni, ndan 'utenilh hoh 'utni?” ");
INSERT INTO cafNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","'Et chah 'ilho dich'oh 'ulhtah 'uhútni k'us ndan suba degha nus ncha wule? ");
INSERT INTO cafNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","'Ink'ez Sizi ndo búlhni, “Udun yun k'ut huwhut'en hubudayi cho dune k'une' bul'en 'int'ah. 'Ink'ez ndunnah hubugha ndoh 'int'ah, 'en nets'un hinzoo 'uhint'ah hubuhútni. ");
INSERT INTO cafNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","'Et whunts'ih nuhwheni nuhtah 'en ndóht'e gunih! 'Et k'us nuhtah ndan degha nus 'int'ah wule, 'en 'udek'ah k'una'a wule. Ndan nuhtsuh whudelhdzulh, 'en nuhwhuba ne'út'en k'una'a wule. ");
INSERT INTO cafNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Daja nahzun? K'us ndan degha nus 'int'ah? Ndan kw'uzdai k'usda 'ute'alh ka, k'us yuba ne'út'en? 'Alha 'uhoont'ah ndan kw'uzdai k'usda 'ink'ez 'ute'alh 'en 'int'ah. 'Et whunts'ih nuhwheni nuhtah nuhwhuba ne'út'en, 'en 'ust'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nuhwheni aht'ah ndet dzuh nususzut, 'et nduhóolyez hoh sulh 'éht'e. ");
INSERT INTO cafNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","'Et nts'e na'a se'aBá stl'ahó'ai hoh hubudayi cho usdli, whuz na'a zeh nuhwheni chah hubudayi cho tehleh nuhgha óotet'alh. ");
INSERT INTO cafNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","'Et nts'e hubudayi cho usdli, 'et sukw'uzdai k'ut sulh 'uteh'alh 'ink'ez sulh 'utehtnai. Ndet kw'usuda cho dezti, 'i 'et hukw'u dutelhúts'ilh 'ink'ez lanezi 'o 'at nat Israel hits'uh hainzut bulh dédowh, 'en huba nahutehyeh.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","'Ink'ez neMoodihti 'utni, “Simon, Simon, soo zelhts'ai! Satan tube nuhka' ninzun. Tl'o mai k'una'a lhtahahontéyulh hukwa' ninzun. ");
INSERT INTO cafNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","'Et whunts'ih mba tenadesdli, ndet mba 'alha' 'ust'ah, 'et 'aw nla k'éhahoolts'it ghaít'ah. 'Ink'ez ndet suts'u nanínja t'eh, nyulhutsinkah 'en hilhtus nabolhtsilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","'Et whunts'ih ndi yúlhni, “SMoodihti lhadúst'ah nyulh tesyalh, tsak'edutes'alh k'us mba datésah.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","'Ink'ez 'uyúlhni, “Peter ndi nyudúsni, k'an dzin ligok dune 'uduténilh whutsuh, tat, ‘'Aw ndun t'enuzuszun,’ dutanilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","'Ink'ez ndo búlhni, “Hoh da whénwhalh'a hoh, sooneya zus, 'ezdlai chah, 'ink'ez nuhkesgwut, 'i ts'iyawh be'et. 'Aw ih hoonliyaz whechandunuzáhdzit?” 'Ink'ez, “Hoolah!” hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","'Ink'ez ndo búlhni, “Et k'an ndan sooneya zus 'ink'ez be ne'ughe ut'i, whute yóolhchoot. 'Ink'ez ndan soh cho chait'ih, 'en budzoot ye 'óket 'ink'ez soh cho lhuk'i óket. ");
INSERT INTO cafNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","'Et huwa 'un whudusni, ndet Yak'usda bughunek k'ut si sugha 'uk'une'úsduguz, 'i ts'iyawh lhaóodoneh huba' hoont'ah. 'Et nduwhutni, ‘Ndunnah 'uk'unuchá'hust'en, 'en hubun dult'ah hudooni,’ ni. 'Et huwa si sugha 'uk'une'úsduguz 'et lhawhúdoneh huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","'Ink'ez 'uhiyúlhni, “NeMoodihti njan whunilh'en nankoh soh cho 'et 'ustan.” 'Ink'ez ndo búlhni, “I 'aw 'et soo 'últsuk.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","'Aw 'et tinánja hoh whutsuh da hukw'una'a nyoo dzulhyaz, Olive hiyulhni, 'i yuk'uz whenaja. 'Ink'ez yugha hoodul'eh, 'en chah whehínandel. ");
INSERT INTO cafNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Whuz hunindel hoh 'et ndo búlhni, “Tink'us únteht'uk whuch'a ténadahdli.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nts'e tse nadulh'us, 'et nduwhuldzah ts'ih bughu ninínya. Dugwútsi be ninínya 'ink'ez tenadudli. ");
INSERT INTO cafNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","'Et njan ndutni, “ABá hukwa' ninzun t'eh, ndi be dzuh nuteszut, 'i sughu naoolchoot. 'Et whunts'ih 'aw si hukwa' nuszun k'una'a ilah. Nyun hukwa' ninzun k'una'a 'uhóneh!” ");
INSERT INTO cafNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","'Et khunyaz ndus de yak'uz lizas be hoodiltsai. 'En ulhtus nayúlhtsi. ");
INSERT INTO cafNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tube budzi nduda hoh 'o nus 'íltus hoh tenadedli. 'Uskai k'una'a buts'uh halhdzilh hoh yun nadúluz. ");
INSERT INTO cafNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tenadedli 'istl'e' 'udeja 'ink'ez dinadija hoh yugha hoodul'eh tso k'et nahunéstez hoh bughu nanja, ");
INSERT INTO cafNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","'ink'ez ndo búlhni, “Di ka sahtez? Doo ka sih tink'us nóoht'uk dinadahdelh 'ink'ez whuch'a tenadahdli.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","'Awhuz hubulh yalhtuk hoh khunyaz lhanah dune whuz de údulh. Ndun Judas hiyulhni, 'en butsuh uyalh. 'En lanezi 'o 'at nanah, 'en hubulh 'ilhunuh 'int'ah. 'Et Sizi yughah neninya naiduntets'oos ka. ");
INSERT INTO cafNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","'Ink'ez Sizi ndi yúlhni, “Judas, yinkak dune ye' nadutants'oos 'i be ih whunést'i hoh butl'aítalhtelh?” ");
INSERT INTO cafNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sizi bunat nuhudelhúya, dawhútenilh 'et honalh'en, 'et 'uhiyúlhni, “NeMoodihti soh cho be ih lhts'utedughan?” ");
INSERT INTO cafNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","'Et 'ilhunuh yuzih seyin, 'en Lizwif náwhulnuk degha nus dezti be 'ulhna nalhnih ts'ih yudzo habe' yalht'o. ");
INSERT INTO cafNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","'Ink'ez Sizi ndo búlhni, “Ndez na'a njan dutésnilh, 'et stl'awháh'aih.” 'Ink'ez ndunah budzo yut'agheznai 'ink'ez soo na'yinla. ");
INSERT INTO cafNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","'Ink'ez ndunnah náwhulnuk hubumoodih, luglez whucho nehúghan hubumoodih, 'ink'ez butsuh whudelhdzulh chah, 'en highu nindel, 'ink'ez Sizi ndó bulhni, “Et di ka soh cho chah 'ink'ez tult'oh chah nuhle 'ink'ez 'undunust'ih hukw'una'a sukaóotehdel? ");
INSERT INTO cafNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","'Et dzin totsuk luglez whucho nuhtah sída hoh, 'aw hoh da 'aw sóolhchoot hukwa cha'záht'en inle. 'Et whunts'ih k'an netsudule, tsahólhgus yuh usda, 'en nuhmoodih tele, 'Aw 'et nuhwhuba ní'hunent'o.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","'Aw 'et Sizi hiyilhchoot 'ink'ez náwhulnuk degha nus dezti highu dáhinilhti. 'Ink'ez Peter yoo niz de yuneyalh. ");
INSERT INTO cafNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","'Et naneztl'oo tuz whuniz ts'ih kwun húdulhk'an 'ink'ez 'ilho nátl'ahudelts'i. Peter 'en chah hubutah usda. ");
INSERT INTO cafNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","'Et kwun zih usda hoh 'ilhunuh 'ustl'e ts'ekeyaz 'en soo yunen ts'ih yunilh'en 'ink'ez ndi yúlhni, “Ndun dune 'en chah yulh 'ut'en inle.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","'Et whunts'ih yuts'oodesdlai 'ink'ez ndi yúlhni, “Ts'eke, ndunah dune 'aw nt'echanuzuszun.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","'Et hukw'elh'az 'astl'iyaz inle hoh 'et chah 'ilhunuh dune ndi yúlhni, “Nyun chah hubulh 'ilhunuh 'unint'ah.” 'Et whunts'ih Peter 'utni, “Awundooh!” ");
INSERT INTO cafNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","'Et doo chah 'ilhuh hukw'e'hunint'o 'et doo chah 'ilhunuh ndi yúlhni, “Alha' hoont'ah ndun 'en chah yulh 'ut'en. 'En chah Galilee whut'en 'ilhunuh 'int'ah 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","'Et Peter ndun dune 'en ndi yúlhni, “Aw daja dini 'aw nt'echaoonuzúszun!” 'Et 'awhuz yalhtuk hoh lígok dune 'udéja. ");
INSERT INTO cafNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","'Et neMoodihti Peter yuts'un nalhú'a 'ink'ez soo yunen ts'ih yunalh'en. 'Et Peter 'ahoh neMoodihti yughunek yunalnik daja yudani inle hoh njan ndi yulhni, “Ligok dune 'uduténilh whutsuh tat nt'echasunuzínzun dutanilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","'Et Peter 'az whinya 'ink'ez tube cho intse. ");
INSERT INTO cafNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ndunnah dune Sizi huyilhchoot, 'en highudloh 'ink'ez hiyoolhchis. ");
INSERT INTO cafNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","'Ink'ez hina k'úna'uzguz 'ink'ez hiyoonukat 'ink'ez hiyoodulhkut, “Neba nus whunóolh'en, 'ink'ez nedini ndan 'unyinla nyunezkuk?” ");
INSERT INTO cafNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","'Ink'ez lhat hoontsi' hoh hich'a yalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","'Aw 'et yilhkai ibulh dune tsuh whudelhdzulh, ndunnah nawhulnuk degha nus dézti nahúlt'ah, 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz chah, 'en 'ilhuhowezdel 'ink'ez huba naheyelh but nihinilhti. 'Ink'ez 'uhiyúlhni, ");
INSERT INTO cafNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nyun Christ inli t'eh, nedíni!” 'Et whunts'ih ndo búlhni, “Ndun whudáni t'eh, 'aw nuhwhuba 'alha' doosni ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Si chah hoonliyaz nuhoodulhkut t'eh, 'aw sudóohni ghaít'ah 'ink'ez 'aw sula nadoohtnih ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","'Et 'ink'ez k'an whuts'un yinkak dune ye' 'et nalhnih ts'ih Yak'usda whelhtus whuda.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","'Ink'ez ts'iyawh 'uhutni, “Nyun Yak'usda buYe' ih 'int'ah?” 'Ink'ez ndo búlhni, “Ts'ah'un na'a 'udahni, si 'en 'ust'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","'Ink'ez 'uhutni, “Aw 'o 'un bugha hoonliyaz highun nedóoni hukwa cha'ts'unízun. 'Aw 'et whenich'oh buzek ts'udánts'o.” ");
INSERT INTO cafNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","'Et ndunnah dune 'ilhohuwezdel ts'iyawh dináhudidel 'ink'ez Pilate but nehínilhti. ");
INSERT INTO cafNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","'Aw 'et hik'e whehoni'ai 'ink'ez 'uhutni, “Ndun dune 'en Lizwif tink'us úbunilht'uk 'et bulh náts'uhoo'ai. 'Ink'ez hubudayi cho Caesar ts'un ndi yun hik'elha hiyilh'i, 'i tax hiyulhni, 'et chah whuch'a bunézyoot. 'Ink'ez didut ndun hubudayi cho Christ ts'utni, 'en usdli na'dudútni.” ");
INSERT INTO cafNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","'Et Pilate yoodulhkut, “Nyun ih 'int'ah Lizwif hubudayi cho inli?” 'Et Sizi 'utni, “A, 'alha' dini.” ");
INSERT INTO cafNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","'Ink'ez 'et Pilate, ndunnah Lizwif bumoodih, 'ink'ez 'ilhohuwezdel ts'iyawh ndo búlhni, “Ndun dune 'aw hoonliyaz tinta' 'ant'en bugha nachawhus'al.” ");
INSERT INTO cafNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","'Ink'ez 'et 'o nus huhunílch'e 'ink'ez 'uhutni, “Yun k'ut Judea ndulhcho hoh, Galilee yun k'ut, 'ink'ez njan chah, dune nuhwheni nuhch'a nihudoodelh whuz na'a whebodulh'eh.” ");
INSERT INTO cafNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","'Et Pilate njan oozalhts'a hoh, 'et huboodulhkut, “Alha ih ndun dune Galilee whut'en 'int'ah?” ");
INSERT INTO cafNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","'Et Pilate Sizi hubudayi cho Herod bukeyah be'ildzun unli t'eoonanzin, 'et 'ahoh yuts'u wheyálh'a. Ndun hubudayi cho 'en chah hoh da soo 'et Jerusalem 'ut'en inle. ");
INSERT INTO cafNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","'Et Herod tube hoont'i hoh Sizi yutelh'en. 'Et tube sa whuts'un yuntelh'ilh hukwa' ninzun 'et huwa. 'Et lhat hoh yulh údants'o inle. 'Et huwa khun teh huwa 'ét'en dunalh 'uhooleh. ");
INSERT INTO cafNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","'Ink'ez khunek lhai be yoodulhkut. 'Et whunts'ih Sizi 'aw yuts'un t'édusnih. ");
INSERT INTO cafNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","'Et hoh da zeh njan ndúwhut'en ndunnah nawhulnuk degha nus dézti 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz, ts'iyawh dináhudidel 'ink'ez soo tube cho whúske be hik'ehóo'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","'Et Herod 'ink'ez yuba nehughan, 'en hubulh ts'iyawh hoonliyaz huba chaílah hininzun 'ink'ez highudloh. 'Et hubudayi cho nayits'uz, 'i be híyalhti 'ink'ez Pilate ts'un whunahíyalh'a. ");
INSERT INTO cafNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","'Et soo 'et dzin Pilate 'ink'ez Herod bulh dune nulhuhulhtsi. 'Et whutsuh da lhch'a hudetni inle. ");
INSERT INTO cafNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","'Aw 'et Pilate ndunnah nawhulnuk degha nus dézti, dune k'une' bul'en, 'ink'ez ts'iyannah dune, 'en ts'iyawh ilho hubughezdla, ");
INSERT INTO cafNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","'ink'ez ndo búlhni, “Ndun dune, 'en dune tink'us hubunilht'uk k'una'a, 'en sughu nulhti. 'En nuhwhubut soo ts'ah'un na'a bugha nunéstai. 'Et whunts'ih ndet buk'éwhah'ai 'aw hoonliyaz bugha nachawhús'al. ");
INSERT INTO cafNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","'Awundooh! 'Ink'ez Siz, 'en Herod buts'un nohwhulh whélh'a. 'En chah hoh tink'us 'int'ah yughu nachahóo'al. 'Alha' hoont'ah ndun dune 'aw hoonli hukwa daóotsah hoolah. ");
INSERT INTO cafNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","'Et hiyootelhtsus 'ink'ez bulanadutesnih.” ");
INSERT INTO cafNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","'Et njan butus lhuseya na'hut'alh, 'et naoodezulh totsuk, 'ilhunuh dune tsak'edi'ai, 'en lana'hudutnih. 'Et whuz na'a buk'ah ts'ih 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","'Et 'ilho hits'uh hahúyih 'ink'ez 'uhutni, “Ndun Barabbas neba bulanadintnih, 'ink'ez ndun dune sulhghe!” ");
INSERT INTO cafNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ndun Barabbas 'en bugha lhtahuwhunt'ai hoh 'ilhunuh dune selhghi 'et hukwa tsak'eya'ai inle. ");
INSERT INTO cafNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","'Et whunts'ih Pilate 'en Sizi lanadutetnih hukwa' ninzun, 'et 'ilhohuwezdel doo chah zeh hubulh yaílhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","'Et whunts'ih 'o nus hits'uh hahuyih, “Lhdulalhgus k'eilhtih! Lhdulalhgus k'eilhtih!” hutni. ");
INSERT INTO cafNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","'Ink'ez 'aw 'et whulh tat ndo búlhni, “Et di ka? Ndet dáhoont'ah hoontsi' tinta' 'ant'en? 'Aw hukw'elha daootsah bugha nachawhús'al! 'Et huwa 'ants'ih hiyootelhtsus 'ink'ez bulanadutesnih.” ");
INSERT INTO cafNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","'Et whunts'ih 'aw hiyoozólhts'a ghaít'ah. 'Ink'ez 'et 'o nus hits'uh hahuyih, “Lhdulalhgus k'eilhtih!” Daja hutni 'ink'ez ndunnah nawhulnuk degha nus dézti, 'en chah, daja hutni 'et hoh Pilate hich'a' nilhde. ");
INSERT INTO cafNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","'Et Pilate nts'e na'a hukwa' huninzun hukw'u na'a yuba nahezya. ");
INSERT INTO cafNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","'Ink'ez ndun Barabbas 'en bugha lhtahuwhunt'ai hoh 'ilhunuh dune selhghi, 'et hukwa tsak'eya'ai 'en Pilate hubuts'un yulanadetnik. 'Et whunts'ih Sizi 'en nts'e na'a hukwa' huninzun k'una'a 'uhitelelh ka hubutl'ayálhti. ");
INSERT INTO cafNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","'Aw 'et Sizi hitelhti hoh 'ilhunuh dune Simon hiyulhni, 'en Cyrene whut'en 'int'ah, 'en wheghah keyah ts'ih hainya, 'en Sizi bulhdulalhgus yuba yudutootan ka hiwus k'ehídintan. ");
INSERT INTO cafNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lhanah dune hiyuntezdel, ts'ekoo chah. 'En bugha tso hinli 'ink'ez hutso. ");
INSERT INTO cafNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","'Ink'ez Sizi hubuts'un nalhú'a 'ink'ez ndo búlhni, “Nuhwheni Jerusalem whuts'ekoo, si sughahtso ilah. 'Et k'us nuhwhenich'oh khunahdutso, 'ink'ez nuhwhuzkehkah chah ghahtso. ");
INSERT INTO cafNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Soo cho whunulh'en, dzin whuz de whékulh ho' hoont'ah, 'et 'uhudooni, ‘Ndunnah buzkeh hoolah, ndunnah 'aw cha'hílhtsil, 'ink'ez ndunnah 'aw 'uski yetcha'úlht'ukw 'en 'o nus huba soo 'uwhutet'ilh.’ ");
INSERT INTO cafNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","'Et hoh dune 'uhudooni ‘Ndi dzulh 'i uncha nek'énit'ai 'ink'ez ndi dzulhyaz 'i chah ndulhcho be nek'eoonookat.’ ");
INSERT INTO cafNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","'Alha' hoont'ah, duchun 'awhuz duli hoh 'et whunts'ih 'awhuz njan 'et nduhút'en. Duchun desuz t'eh, dawhútenilh nahzun?” ");
INSERT INTO cafNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","'Et nanah untsi', 'en chah, hiyulh hubutuzelhghelh. ");
INSERT INTO cafNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","'Ink'ez ndet dzulhyaz Calvary huwhútni, 'i 'utsints'un nez'ai huwhutni, whuz hinilhti 'ink'ez lhdulalhgus k'ehiyilhti. Ndunnah dune ntsi', 'en 'ilhunuh nalhnih ts'ih 'ink'ez 'ilhunuh 'intl'as ts'ih, 'en chah lhdulalhgus k'eóobuhilhti. ");
INSERT INTO cafNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","'Aw 'et Sizi 'utni, “ABá huba whunaoodolnah. 'Aw dahút'en t'ehonizun, 'et huwa 'uhut'en.” 'Ink'ez hinaih lhk'ehíyelya 'ink'ez higha 'aínlih. ");
INSERT INTO cafNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","'Et dune hundelhúya 'ink'ez honilh'en. Ndunnah bumoodih, 'en chah buzih nuhudelhúya 'ink'ez highudloh hoh nduhútni, “Uyoon, 'en hubulhyis inle. 'Et huwa ndun 'en Christ ndun Yak'usda 'utahayálhti 'int'ah t'eh, dich'oh 'ududoolyih da!” ");
INSERT INTO cafNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nehughan, 'en chah highudloh. Hizih niníndel 'ink'ez mai too dunink'ooz, 'i hits'un dihidinkai. ");
INSERT INTO cafNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","'Ink'ez 'uhíyulhni, “Lizwif hubudayi cho inli t'eh, nyunch'oh 'ududílyih!” ");
INSERT INTO cafNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Lhustelyaz hik'une'úzguz. 'Udechoo Greek hubughunek k'una'a, Latin hubughunek k'una'a, 'ink'ez Hebrew hubughunek k'una'a chah, 'aw 'et lhdulalhgus k'ut sulhti, higha ndoh ts'ih whehidunilht'o. Ndez na'a njan ndutni, c Ndun 'en Lizwif Hubudayi Cho 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ndunnah nanah hintsi', hizih lhdulalhgus k'ehiyílhti, 'ilhunuh hich'á 'uts'un 'utni hoh 'et di yulhni, “Nyun Christ inli t'eh, 'et nyunch'oh 'ududílyih 'ink'ez nuwheni chah neílhyih!” ");
INSERT INTO cafNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","'Et 'ilhunuh untsi' hukwa' yudáni hoh ndi yúlhni, “Aw Yak'usda whunts'ih bé chanuzíljut hoh ih 'udini? 'Aw nt'eoonuzínzun nts'e na'a huba nahesda, 'et whuz na'a zeh nuwheni chah neba nahesda. ");
INSERT INTO cafNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","'Ink'ez wheni ts'ah'un na'a neba nahesda. Daidút'en 'et huwa k'an lhdulalhgus k'ut neba k'elha sidúlti. 'Et huwa neba 'uk'elha whuzdli. 'Et whunts'ih ndun dune 'aw hoonliyaz tinta cha'ít'il. 'Et whunts'ih wheni nek'una'a zeh huba nahesda.” ");
INSERT INTO cafNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","'Et ndun dune untsi' 'en Sizi ndi yúlhni, “SMoodihti nts'e hubudayi cho inli, whuz lhgha nadinja t'eh, sunaoolnih!” ");
INSERT INTO cafNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","'Et Sizi ndi yúlhni, “Ts'ah'un na'a nyudusni, nts'e degha nus hoonzoo, 'et soo k'an dzin sulh 'útant'ilh.” ");
INSERT INTO cafNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Dzetniz hukw'elh'az 3:00 bat'en 'et whuts'un ndi yun k'ut ndúhoolcho tsahólhgus inle. ");
INSERT INTO cafNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sa chah 'aw chast'en suli. 'Ink'ez luglez whucho dutai, 'i hukwa délhchooz, 'i chah lhulcho lhk'enínch'ul. ");
INSERT INTO cafNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","'Ink'ez Sizi tube cho 'utni, “ABá, suyéghah 'i nts'un bula desnik.” 'Ink'ez 'et ndudéja 'aw 'et 'udek'elh'az hanáji. ");
INSERT INTO cafNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","'Et dahooja ndun nehughan bumoodih whunalh'en hoh Yak'usda yudélhti 'ink'ez 'utni, “Ndun 'alha soo ts'ah'un dune zeh 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","'Et 'ilhohuwezdel ts'iyawh 'et nehunindel howhuntelh'ilh ka, ndet ndulhcho dáhooja howhunalh'en, tso k'et 'et budzi k'ut huhoolhchis 'ink'ez whusanáhedel. ");
INSERT INTO cafNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ndunnah t'ehininzun, 'ink'ez ndunnah ts'ekoo Galilee whuts'un whusanáhinedel, 'en chah nilhdzayaz highu nudelhúya njan ndulhcho hoh dawhut'en honilh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","'Aw 'et 'ilhunuh dune Joseph hiyulhni, ndunnah Lizwif buk'úne' whut'en, 'en 'ilhunuh 'int'ah. Dune unzoo 'ink'ez ts'ah'un dune unli. ");
INSERT INTO cafNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ndunnah buk'úne' whut'en, dahúja, 'aw huba ts'ah'un cha'hoot'ah. Joseph 'en Arimathea whut'en 'int'ah. 'En chah ndet Yak'usda hoh hubudayi cho unli, 'et chah hubalh'i. ");
INSERT INTO cafNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","'Et Joseph, en Pilate ts'un whinya 'ink'ez Sizi buyust'e yuts'u ka ná'dutni dutl'anáyoolhtelh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","'Aw 'et buyust'e nanáyalhti hoh ndi naih dezti, 'i layin hiyulhni, 'i be yugha iwezduz. 'Et tse bet hahuhontsel, 'et whuts'uh da, 'aw 'uyoon 'et 'achadílhtah, 'et wheyíhiyalhti. ");
INSERT INTO cafNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","'Aw 'et njan dzin wheni lhahúdutneh 'uhoont'ah. 'Aw 'et Lizwif nats'ulyis dzin hoolh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","'Ink'ez ndunnah ts'ekoo Galilee whuts'un whusahínandel, 'en Joseph hiyuntezdel, 'et buyust'e 'et wheyihiyalhti 'et hinalh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","'Et whenáhedel. Yoo sooltsun, 'i khe sooltsun, 'i chah ts'iyawh lhahídinla. 'Et nats'ulyis dzin, 'et Yak'usda bughunek be buba' hóonla, 'et dzin nahelyiz. ");
INSERT INTO cafNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","'Aw 'et ndi k'enílhghel 'udechoo dzin 'uhoont'ah. Bundada 'uda, ndunnah ts'ekoo 'ink'ez 'uyoon chah bulh 'et ts'un k'uz ts'ih hutezdel. Ndi yoo sooltsun, 'i lhahídinla, 'i chah hitezdla. ");
INSERT INTO cafNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tse 'uda 'udun dez'ai hoh hotelh'en. ");
INSERT INTO cafNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","'Et dahúnindel 'ink'ez neMoodihti Sizi buyust'e hoolah nahuhoo'ai. ");
INSERT INTO cafNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","'Et ts'iyawh hububa whe' hooja hooyal 'et dáhooja hoh simba 'uhoont'ah. 'Et khunyaz nanah dune buzih siyin. Bunaih soo tube be hoodet'en. ");
INSERT INTO cafNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","'Ink'ez ndunnah ts'ekoo tube whehonelhújoot hoh butsi be nachahúnelya. 'Ink'ez ndunnah dune 'uhutni, “Et di ka yaidla tah dune khuna, 'en bukunáhta? ");
INSERT INTO cafNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","'Aw njan hoolah, dinadija ho' 'int'ah! 'Awhuz Galilee 'ut'en hoh, daja nuhwhulhni, 'aw ih whunachasulhúnik? ");
INSERT INTO cafNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Njan ndun whulhni, ‘Ndez na'a njan ndótenilh, yinkak dune ye', 'en lubeshi 'ulh'en tl'ahítelhtelh 'ink'ez lhdulalhgus k'ehítelhtelh ka. 'Ink'ez whulh tat dzin dinadutédalh.” ");
INSERT INTO cafNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","'Ink'ez 'ahoh highunek hinalnih. ");
INSERT INTO cafNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","'Et ts'un k'uz hanáhedel, 'et ndi ts'iyawh lanezi 'o 'at 'ilhunuh, 'ink'ez 'onghunnah chah, ts'iyannah ndo budáni. ");
INSERT INTO cafNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ndunnah, 'en Mary Magdala whut'en, Joanna chah, Mary, James be'ama chah, 'ink'ez 'uyoon ts'ekoo bulh 'uhut'en, 'en 'uhuja ndunnah whel'a ndo budáni. ");
INSERT INTO cafNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","'Et whunts'ih ndunnah whel'a, 'ants'ih hoh ne'huduni whula 'uhutni hubunínzun 'ink'ez 'aw huba 'alha' cha'hudusnih. ");
INSERT INTO cafNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","'Et whunts'ih Peter didillhah 'ink'ez ts'un k'uz ts'ih whélgai. Yuk lih 'uja 'ink'ez tsa k'et whunilh'en. 'Et naih dezti, 'i zeh 'et sulhchooz hoh yutelh'en. 'Et koo ts'ih whenaja. 'Et howu nuní nuzut 'ink'ez buba hooncha dahooja hoh simba 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","'Aw 'et dzin zeh keyah whuyaz, Emmaus ts'uwhútni, nanah dune whuz hutez'az. Jerusalem whuts'un 7 miles bat'en 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","'Et whuz he'us hoh 'et ndóohoolhcho dawhút'en hoh howu yahulhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","'Awhuz 'et howu yahulhtuk dawhút'en ne'whust'en, 'et Sizi hubughan ninya 'ink'ez hubulh tez'az. ");
INSERT INTO cafNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Buna be hinilh'en 'et whunts'ih 'aw butl'acháhoo'al 'et huwa 'aw t'echahinízil. ");
INSERT INTO cafNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","'Ink'ez ndo búlhni, “Et wheghah ah'us hoh, ndet ho' whudahni? Stabe hubugha nuhdzi nduda hoh howu yalhtuk?” ");
INSERT INTO cafNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","'Et ndun 'ilhunuh, Cleopas hiyulhni, 'en ndi yúlhni, “Aw nyun zeh ilah ih nts'oh teh k'an ne'whust'en, 'aw ih nt'ewhunuzínzun. 'Aw Jerusalem whut'en chainlah ho ih 'udini?” ");
INSERT INTO cafNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","'Et ndo búlhni, “Ndet 'uwhudahni?” 'Ink'ez 'uhiyúlhni, “Sizi Nazareth whut'en, 'en bugha dahooja. Ndun dune nus whunilh'en 'int'ah. Yak'usda 'ink'ez dune chah bunalh ts'iyawh hoolhtus hoh ne'whúst'en 'ink'ez hoolhtus whe chah yaílhtuk. ");
INSERT INTO cafNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","'Ink'ez 'et chah dahooja nawhulnuk degha nus dézti, 'ink'ez nuwheni nemoodih chah, 'en Rome whut'en hiba nahuhooyeh ka butl'ahíyalhti, 'ink'ez lhdulalhgus k'ehíyilhti. ");
INSERT INTO cafNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","'Et whunts'ih 'en úncha Israel hits'uh hainzut nabootekulh uzninzun da. Nts'oh tuné'whust'en 'et whuts'un k'an 'aw 'et whúlh tat dzin 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","A, 'alha 'uhoont'ah, 'ink'ez bulunah ts'ekoo nelh 'uhet'en, daja hutni, tube neba hooncha. Soo 'uda bundada ts'un k'uz huníndel. ");
INSERT INTO cafNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","'Aw hiyust'e nachahíyilhtel. 'Ink'ez lizas ha'en hoh 'en 'uhutni, ‘Khuna ho' 'int'ah!’ ");
INSERT INTO cafNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","'Ink'ez 'et bulunah nelh 'uhut'en, 'en chah ts'un k'uz nahúz'az. Soo nts'e na'a ts'ekoo daja hutni, whuz na'a nahuhoo'ai. 'Et whunts'ih Sizi 'aw chahiyí'il.” ");
INSERT INTO cafNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","'Et Sizi ndo búlhni, “Tube nuhwheni whuzahnik ahli! Ndet ts'iyawh nus whunilh'en daja hutni, tube sa nuhdzi be nuhwhuba 'alha 'uhoneh! ");
INSERT INTO cafNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","'Alha ih 'uhoont'ah Christ, 'en dzuh nutezut huba 'uhoont'ah 'ink'ez 'et hukw'elh'az whudezti ts'ih natedalh?” ");
INSERT INTO cafNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","'Ink'ez soo 'udechoo Moses be' dustl'us 'uk'ununa'úzguz 'ink'ez nus whunilh'en bube' dustl'us chah, ndai hik'une'úzguz 'en bugha, 'i ts'iyawh Yak'usda bughunek yubunelhtan ho 'utni. ");
INSERT INTO cafNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","'Et njan keyah wheyaz hutezdel ts'ih, 'aw 'et wheghah hedulh. 'Ink'ez Sizi 'aoonilhka njan keyah wheghah lhuteyalh li'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","'Ants'ih tube cho duzíh wuda hukwa' hiyulh'en, 'ink'ez 'uhiyúlhni, “Aw 'et sa naín'ai, hulhgha 'uhoont'ah.” 'Ink'ez koo hubulh danánt'az buzih tedalh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","'Et hukw'elh'azyaz natl'ahudelts'i 'ink'ez 'uhute'alh. Sizi lhes yílhchoot 'ink'ez Yak'usda suchanailya yulhni. 'Ink'ez lhtaídalhkut 'ink'ez hubutl'ayánla. ");
INSERT INTO cafNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","'Et khunyaz hitá'en li'huja 'ink'ez nahiyoolhúts'it. 'Ink'ez 'et khunyaz hoolah nasdli. ");
INSERT INTO cafNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","'Et 'ulhódutni, “Nus de ti nelh yalhtuk 'ink'ez Yak'usda bughunek daja ni whunenulhtun hoh 'aw ih nedzi dézk'un lí'ts'int'ah inle?” ");
INSERT INTO cafNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","'Ahoh 'et wheghah 'uhunet'oh hoh dihudíndel 'ink'ez Jerusalem ts'ih nahutesdel. 'Et ndunnah lanezi 'o 'at 'ilhunuh 'ink'ez ndunnah hubulh 'uhut'en, 'en ts'iyawh ndet 'ilhoh 'úhint'ah hoh hubughun nahúndel, ");
INSERT INTO cafNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","'ink'ez njan 'et hudelhts'i, 'en 'uhutni, “Alha neMoodihti dinadija ho' 'int'ah! 'Ink'ez Simon yunalh be hóodiltsai!” ");
INSERT INTO cafNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","'Ink'ez ndunnah nanah njan ti dahooja 'et hubugha hubulh náhohoolnuk nts'e na'a Sizi ndi lhes taídalhkut hoh ndun unli nahiyoolhúts'it. ");
INSERT INTO cafNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","'Awhuz njan howu yahalhtuk hoh, Sizi dich'oh hubuniz be hóodiltsai, 'ink'ez ndo búlhni, “Nohwhulh soo whudooghel.” ");
INSERT INTO cafNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","'Et whunts'ih hubugha ha'nejoot 'ink'ez tube hunelhújoot. Dune dazsai butsen ha'en huninzun. ");
INSERT INTO cafNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","'Ink'ez ndo búlhni, “Et dahoont'ah huwa whenlhujut? 'Ink'ez dahoont'ah huwa nuhdzi yuh hoh nuhwhuba nawh 'uhoont'ah? ");
INSERT INTO cafNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Sula chah 'ink'ez suke chah nulh'en. Si 'ust'ah. St'agháhnaih 'ink'ez sunulh'en! 'Alha nuhwhenich'oh whunulh'en. Suyust'e chah hoonli 'ink'ez suts'un chah. Dune butsen 'aw whuz na'a nduchaít'ah, buyust'e 'ink'ez buts'un chah hoolah, ndi ts'iyawh bulh 'ust'ah.” ");
INSERT INTO cafNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","'Aw 'et ndudáni hoh, dula chah 'ink'ez duke chah hubunalh ts'et niyuzdla. ");
INSERT INTO cafNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Soo ts'ah'un huhóont'i 'ink'ez tube huba hooncha, 'et whunts'ih 'awhuz huba 'alha' cha'hoot'ah. 'Ink'ez ndo búlhni, “Aw njan ts'uyi, 'i cháht'ih?” ");
INSERT INTO cafNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","'Et lhook sut'e, 'i 'ink'ez honey, 'i yoo'alh ka higha híninla. ");
INSERT INTO cafNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","'I yílhchoot 'ink'ez hubunalh ya'al. ");
INSERT INTO cafNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","'Ink'ez ndo búlhni, “Awhuz nohwhulh 'úst'ah da ndi khunek 'i da be nohwhulh yalhtuk, 'et ndi ts'iyawh lhaoodoneh ndai Moses be' dustl'us 'ukune'usdúguz, ndunnah nus whunilh'en, 'ink'ez Yak'usda bughunek Shun be' dustl'us k'ut chah, si sugha 'uk'une'úsduguz.” ");
INSERT INTO cafNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","'Et hubeni t'ehonoozeh ka butl'ahó'ai Yak'usda bughunek t'ehinoozeh ka. ");
INSERT INTO cafNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","'Ink'ez ndo búlhni, “Ndi 'i 'uk'une'úsduguz hoh 'et ndutni, Christ, 'en dzuh nozut huba' hoont'ah, 'ink'ez whulh tat dzin dinadutédalh. ");
INSERT INTO cafNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","'Ink'ez ndunnah boozi be yatelhtuk, 'en boozi bugha nts'e na'a hoh ts'iyannah bulubeshi ch'a bubeni naháhundunooleh, 'ink'ez nts'e na'a hoh bulubeshi huba 'ún tukuk chah, ndi bugha boozi hubugha ts'iyannah ndudóohni huba' hoont'ah. 'Et njan Jerusalem 'et choo whe'dooht'en. 'Et hukw'elh'az t'eh, ts'iyannah yun k'ut nduhoolcho hoh whebodoolh'eh. ");
INSERT INTO cafNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","'Ink'ez nuhwheni njan 'et ts'iyawh dune whúntelhtun ahli hoh aht'ah. ");
INSERT INTO cafNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","'Ink'ez soo zélhts'ai, ndi se'aBá nuhts'u yoozi, 'i nuhts'o tl'adutes'alh. 'Et whunts'ih yak'uz ndus de whelhtus, 'i nuhk'edútelts'ulh 'et whuts'un, njan Jerusalem keyah 'et zeh doolhúts'i.” ");
INSERT INTO cafNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","'Aw 'et keyahyaz Bethany ts'uwhútni, whuz nabuninla. Bula nduk 'uyínla 'ink'ez Yak'usda yoodulhkut hubuts'un wuzoo ka. ");
INSERT INTO cafNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","'Et 'awhuz Yak'usda yoodulhkut hoh hubuts'un wuzoo ka, 'et hubuch'a nduk yak'uz whenabe'whéldzut. ");
INSERT INTO cafNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hits'un teni' nalhdzin, 'ink'ez tube hooncha huhóont'i hoh Jerusalem ts'ih whunáhedel. ");
INSERT INTO cafNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","'Et 'ahoolhyez luglez whucho hudelhts'i hoh Yak'usda hidelhti 'ink'ez dalzoo ho' 'int'ah hutni. 'Et ndoh honeh.");
INSERT INTO cafNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Soo 'udechoo da 'et khunek hoonli 'ink'ez ndi khunek 'i Yak'usda yulh 'int'ah. Ndi khunek 'i Yak'usda 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ndun 'en soo 'udechoo da whuts'un Yak'usda bulh 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","'En bula tah ts'ih ts'iyaitsuk 'ulya ínle. Ndai 'ulya, 'i tah 'aw ilhuk'i cha'yílil hoolah. ");
INSERT INTO cafNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Be ts'úkhuna 'en buts'un haídanzut 'ink'ez ndi be ts'ukhuna 'i ts'iyannah dune huba be whét'en 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ndi be whét'en tsahólhgus yuh ts'ih whéndi 'ink'ez ndi tsahólhgus yuh ts'ih haínya, 'aw yuch'a 'oolhdeh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","'Ilhunuh dune John hiyulhni, 'en Yak'usda whusayálh'a. ");
INSERT INTO cafNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ndun dune 'en ts'iyannah dóni ndi be whét'en, 'i bugha. Hukwa' huninzun t'eh, 'en bugha ts'iyannah huba 'álha 'uhot'e. ");
INSERT INTO cafNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ndun John, 'en 'aw be whét'en ilah 'int'ah. 'En 'int'ah be whét'en, 'i bugha ts'iyannah dóni 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ndun ts'ah'un be whét'en, ts'iyannah dune ndi yun k'ut k'eínya, 'en ndi be whét'en hubugha ite'alh. ");
INSERT INTO cafNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ndi yun k'ut inda. Ndi yun 'uyínla 'et whunts'ih yinkak dune t'ehinóozin hukwa cha'hunízun. ");
INSERT INTO cafNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ndunnah dulh whút'en 'en lhtahaoobanla 'ink'ez hubutaninya hoh 'aw chahayílhcholh. ");
INSERT INTO cafNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","'Et whunts'ih ndan ho' 'int'ah hiyílhchoot, Yak'usda buzkeh huzdli 'et hubugha óoni'ai. Ndan 'uhint'ah ndi boozi huba 'álha' yint'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","'Aw dune hits'u haínzut whu la ts'ih ilah Yak'usda buzkeh huzdli, k'us buyust'e hukwa' nínzun huwa ilah, k'us dich'oh dune hukwa' huninzun huwa chah ilah, Yak'usda 'en bugha zeh huwhuzdli. ");
INSERT INTO cafNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","'Et ndi khunek Yak'usda unli, 'i dune suli 'ink'ez netah dune inle, 'et hoh dadélti ts'onalh'en. Ndi yé dadélti, 'i Yak'usda 'aw 'ilhunuh zeh buYe' yé dezti 'i 'int'ah. Ye unzoo 'i 'ink'ez khunek 'alha' 'int'ah 'i zeh ye dézbun. ");
INSERT INTO cafNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","'En bugha John hubudáni inle, dune bulh yálhtuk hoh, “Ndun 'en nuhghu dáni, sk'elh'az whusatéyalh 'et whunts'ih whutesdleh whutsuh da whunts'ih, 'uda 'et khuna ho' 'int'ah, 'et huwa 'int'ah sugha ndoh 'int'ah,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","'Ink'ez ndai yé dezbun 'i ts'iyawh negha íninla. Dzin totsuk ye unzoo 'i neba 'o 'un 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yak'usda ndi bughunek 'i buk'une'ts'oot'en, 'i Moses 'en bugha netl'aidá'ai ínle. 'Et whunts'ih k'an Sizi Gri 'en bugha ye unzoo, 'i 'ink'ez khunek 'alha' 'int'ah, 'i neghalts'ut. ");
INSERT INTO cafNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","'Aw Yak'usda 'en ya'en, 'et whunts'ih ndunnah 'aw 'ilhunuh buYe', be'aBá degha nus yuk'entsi', 'en Yak'usda bugha 'et wheinélhtan. ");
INSERT INTO cafNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","'Et 'ilhudzin ndan Lizwif Jerusalem whut'en, 'en náwhulnuk 'ink'ez Levitenah, 'en John buts'un wheóobahalh'a hiyoodolhkut ndan unli 'et hukwa. 'Et John ndo búlhni, ");
INSERT INTO cafNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","soo ts'ah'un na'a 'aw whuts'u chaoodídlai hoh hubudáni, “Aw Christ, 'en ílah 'ust'ah,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","'Et doo chah hiyoodulhkut, “Ndan inli? Elijah tulih 'int'ah?” “Awundooh, 'aw 'en ilah 'ust'ah,” hubúlhni. “Ndan Yak'usda be nus whunílh'en hubugha yatuk inle, 'en tulih 'int'ah?” hiyúlhni. 'Et chah, “Awundooh,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","'Et 'uhiyúlhni, “Aw ndan hó' nint'ah. Nyunch'oh daja ho' dini? 'Et ts'ah'un ne'díni, 'et ndez na'a ndunnah whuz denételh'a hubuzdóoni,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","'Et John ndo búlhni, “Si 'ust'ah 'aw dune chahóot'ih ts'ih dultul hoh ts'iyannah dune hubudúsni, neMoodihti lhuteyalh hoonzoo 'ink'ez lhk'owhudez'a huba whulhtsi. 'Et whuz na'a Yak'usda 'en be nus whunilh'en Isaiah ndutni ínle,” ndo búlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","'Et ndunnah John buts'un whets'iyalh'a ndunnah Pharisee bulunah zeh 'uhint'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","'Et doo chah hiyoodulhkut, “Aw Christ, k'us Elijah, k'us ndan Yak'usda 'en be nus whunilh'en, ndunnah ilah 'int'ah t'eh, di ka dune too bé' bilh'en?” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","'Et John ndo búlhni, “Si too zeh 'i be dune too be' 'ulh'en, 'et whunts'ih nuhwhutah 'ilhunuh dune hoonli, 'en 'aw t'enuzáhzun. ");
INSERT INTO cafNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","'En 'int'ah sk'élh'az whusatéyalh sughanus dezti ho' 'int'ah. 'Aw bukechun ketl'oolh buba k'unaídutes'uk, 'et whunts'ih huba soo cha'lhudzooh,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","'Et njan keyah Bethabara huwhútni Jordan took'oh whanch'az whuz'ai, 'et John dune too be' 'óbulh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","'Om bun dzin khunyaz Sizi yuts'un úyalh hoh John yutelh'en, 'ink'ez 'utni, “Nulh'en, Yak'usda busheepyaz 'int'ah. 'En 'ut'en, yinkak dune hubulubeshi hubuts'u hanáyule,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","'En bugha 'un whudúsni sk'elh'az whusatéyalh, 'et whunts'ih whutesdleh whutsu da whunts'ih, 'uda khuna ho' 'int'ah, 'et huwa sughanus dezti ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ndan unli 'aw seni be t'énuzúszun inle, 'et whunts'ih nuhwheni Israel buts'u háhde nuhwhuts'un whuz haya be t'ewhunoolhzeh 'ink'ez too zeh 'i be too be' 'un whulh'en, 'i bugha ndan 'int'ah soo cho t'ewhunoohzeh,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Njan 'et Sizi bugha John ndutni, “Ndoni dut'aiyaz nduwhút'en hoh yak'uz ts'ih hadánde 'ink'ez buyédande, 'et whunalh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Hoh da 'aw seni be t'éoonuzúszun ndun 'int'ah, 'et whunts'ih ndun whuz de sutélh'a too zeh 'i be dune too be' oolh'en ka, 'en sudáni, ‘Ndan Ndoni ndus de yuk'édilts'ut 'ink'ez 'ilhuz yulh 'ínt'ah, 'en 'int'ah Ndoni be dune too be' 'ulh'en unli,’ 'et sudáni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","'Et ndúhooja 'et whunalh'en. Soo ts'ah'un khunek be nuhwhudúsni, 'alha ndun 'en Yak'usda buYe' 'int'ah,” hubúlhni John. ");
INSERT INTO cafNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","'Et 'om bun dzin John 'ink'ez yugha hoodul'eh nanah 'et nahudélhuya. ");
INSERT INTO cafNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Sizi hoh wheghah uyalh hoh John yunilh'en, “Nulh'en ndun Yak'usda busheepyaz 'int'ah!” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","'Et ndunnah nanah dune John yugha hoodul'eh daja ni hidánts'o hoh 'aw 'et Sizi Gri hiyuntez'az. ");
INSERT INTO cafNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","'Et Sizi hubunilh'en hine'us hoh 'et huboodulhkut, “Di kunahta hoh 'aht'en?” hubúlhni. 'Et 'uhiyúlhni, “Rabbi, nts'e hoont'i?” ('Et ndi khunek “Rabbi” 'i Lizwif k'una'a dune hoodulh'eh ni ho' utni.) 'Et Sizi hubúlhni, ");
INSERT INTO cafNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Anih, whunoolh'en si!” hubúlhni. 'Et hiyúlh tez'az 'ink'ez nts'e sída 'et honalh'en. 'Et dzin nduhoolyez hoh hizih hinke 'ink'ez, hoh da 10:00 bat'en 'uhunet'oh. ");
INSERT INTO cafNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","'Et ndunnah nanah dune John hidánts'o huwa Sizi hiyuntez'az, 'en 'ilhunuh, Andrew hiyulhni, 'en Simon Peter bulhutsin 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","'En 'ahoh dulhutsin, Simon hiyulhni, 'en yughu ninya 'ink'ez yudáni, “Ndun Messiah 'aw 'et nats'ilhti,” yúlhni. (Ndi boozi “Messiah,” Christ ni ho' utni.) ");
INSERT INTO cafNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","'Et Sizi 'en yughu inílhti. 'Et soo cho Sizi yunalh'en 'ink'ez ndi yúlhni, “Nyun Simon Jonas buye' 'en 'int'ah, 'et whunts'ih Cephas nyuhuduténilh,” yúlhni. (Ndi Cephas 'i Peter 'i zeh 'int'ah 'ink'ez 'i “tse” ni ho' utni.) ");
INSERT INTO cafNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","'Et 'om bun dzin Sizi Galilee yun k'ut huwhútni ts'ih teyalh hukwa' ninzun. Whuz ninya hoh dune Philip hiyúlhni, 'en nayilhti 'ink'ez “Sunanyalh,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","'Et ndun Philip 'en keyah Bethsaida huwhútni, 'et whut'en 'int'ah. Keyah 'et Andrew 'ink'ez Peter bulh huwhut'i. ");
INSERT INTO cafNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","'Et Philip 'en dune Nathanael hiyúlhni, 'en nayilhti, “Ndun dune Moses dude dustl'us k'ut yugha 'uk'une'úzguz, 'ink'ez Yak'usda be nus whunilh'en highun 'uk'une'úzguz, 'en 'aw 'et nats'ilhti. 'En 'int'ah Sizi, Joseph buye' unli. Keyah Nazareth huwhútni, 'et whut'i,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","'Et Nathanael 'utni, “Nts'e na'a simba hoonliyaz 'unzoo 'i Nazareth ts'ih haóolts'it?” 'Et Philip 'utni, “Anih, sulh ín'us 'ink'ez whunolh'en si!” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","'Et Sizi Nathanael 'az de úyalh yunilh'en 'ink'ez yugha 'et ndutni, “Ndun 'en soo Israel buts'u hainzut 'int'ah, 'aw tínk'us 'uhóont'ah teh nucha'ust'en,” ni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","'Et Nathanael Sizi yoodulhkut, “Dí bugha t'ewhunínzun dant'un dune usdli?” 'Et Sizi 'uyúlhni, “Mai chun t'ah sinda da, Philip 'anih nyuduténilh whutsuh da, 'et 'uda nyunalh'en,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","'Et Nathanael ndi yúlhni, “Rabbi, 'alha' Yak'usda buYe' inli 'ink'ez Israel hits'u hainde, huba hubudayi cho chah inli,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","'Et Sizi ndi yúlhni, “Mai chun t'ah sinda hoh nyunalh'en nyudúsni. 'Et huwa Yak'usda buYe' usdli mba 'álha 'uhoont'ah, 'et whunts'ih 'o nus ts'un 'o nus hooncha, 'et whuntalh'ilh. ");
INSERT INTO cafNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","'Et soo ts'ah'un 'ínt'ah nyudut'esnilh, yak'uz da' dutézkez 'ink'ez Yak'usda hubulizas ndus de hahándel 'ink'ez doo chah whenáhudéde ndun yinkak dune ye' 'en buts'un 'uhut'en, 'et whuntalh'ilh,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","'Et whulh tat dzin suli hoh Galilee yun k'ut 'et 'ilhun keyah Cana huwhútni, 'et keyah 'et k'an nalhgha húsduke huba honélhnik. 'Et Sizi be'ama 'en chah 'et usda. ");
INSERT INTO cafNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Sizi 'ink'ez yugha hóodul'eh 'en chah hubughu nahúzdel. ");
INSERT INTO cafNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","'Et njan lhghahúsduke ba honelhnik whutah 'et ndi mai too ntsol súli. 'Et Sizi be'ama yughu ninya 'ink'ez 'uyúlhni, “Aw mai too cha hít'ih.” ");
INSERT INTO cafNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Sizi 'et ndi yúlhni, “Ts'eke dant'i ka 'uyoon mba 'uhoont'ah 'et si hukwa' sudini, njan 'et 'aw suba 'et nicha'hunest'o!” ");
INSERT INTO cafNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","'Et be'ama ndunnah ustlen, 'en búlhni, “Daja nuhwhúlhni hoh tuné'ooht'en.” ");
INSERT INTO cafNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","'Et njan lhk'uta tse 'oosa' cho, too hiye 'ílhdzun wheni, 'et súla. Lhanah Lizwif hube 'ut'en k'ah hukw'un'a lana'huldeh wheni. ");
INSERT INTO cafNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","'Et Sizi ndunnah ustlen, 'en búlhni, “Ndi tse 'oosa' cho ts'iyawh too be nadulhbun.” 'Et soo ts'iyawh budah whuts'un yanahídelhbun. ");
INSERT INTO cafNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","“Aw 'et buyé' 'ahkaih 'ink'ez ndun njan howunli, 'en buts'un yéhkalh,” hubúlhni. 'Ink'ez bulah hits'un whinkai. ");
INSERT INTO cafNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ndi too mai too suli, 'i 'aw nts'ez de hahuyalhdze ndan howunli 'en t'éoonízun, 'et whunts'ih ndunnah ustlen, 'en hiyínkai, 'en t'ehonínzun. 'Ink'ez ndet huwunli 'en dune 'at ut'i, 'en 'anih yúlhni, ");
INSERT INTO cafNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","'ink'ez ndi yúlhni, “Dune ts'iyannah ndi mai too unzoo, 'i choo howu hínilhdze, 'et hukw'elh'az soo' neltsuk hutni, 'et 'ink'ez hukw'elh'az 'int'ah 'i mai too 'i bughu hínilhdze. 'Et nyun ndi unzoo, 'i 'udek'ah whuts'un ontun!” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Njan keyah Cana Galilee yun k'ut whuz'ai 'et soo 'udechoo Sizi huwa 'ét'en teh whená'dit'en, 'ink'ez dádelti 'et hóbunelhtan. 'I bugha hodul'eh 'en bugha ba 'alha yint'ah suli. ");
INSERT INTO cafNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","'Et ndúhooja hukw'elh'az Sizi keyah Capernaum huwhutni ts'ih whinya. Be'ama chah 'uja, 'ink'ez bulhutsinkah chah, 'ink'ez yugha hoodul'eh chah, 'aw sa ilah 'et hudálts'i. ");
INSERT INTO cafNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","'Aw 'et wheghah whúdezulh ndet da Lizwif bukoo Yak'usda lizas Butus Lhuséya whunahulnih, 'et Sizi Jerusalem ts'ih whénya. ");
INSERT INTO cafNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","'Et luglez whucho whuna'nesdutl'oo wheyah ts'ih tézya 'et dune 'e'óoket hubunílh'en. Khunai cha, musdus cha, sheep cha, 'ink'ez dut'aiyaz cha, dove hiyúlhni, hiye 'óoket, 'ink'ez dune sooneya lhk'enáhudunedzih, 'en chah 'et 'uhut'en. ");
INSERT INTO cafNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tl'oolhyaz be dutsus inla. 'I be khunai ts'iyawh tinaínenyoot. Sooneya lhk'enáhundunedzih chah hubuzooneya nus wheyantsut, 'ink'ez kw'uzdai chah yun tez'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","'Ink'ez dut'aiyaz be 'óoket chah ndó bulhni, “K'an 'aw 'et tiná'nuhle! 'Aw se'aBá bukooyah 'et 'e'óohket bakoo whulhtsi ilah!” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","'Et ndunnah yugha hoodul'eh 'et whunahulnih huwa 'uk'une'huzguz 'i daja ni, 'et ndutni, “Njan nkoo hukwa' nuszun k'et 'ants'ih siyah whudezk'un li'nust'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Lizwif 'uhiyúlhni, “Njan nts'oh teh ne'ínt'en nts'ez na'a 'ínt'en hooncha túne' 'int'en, 'et whunénilhtun?” ");
INSERT INTO cafNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","'Et Sizi ndo búlhni, “Njan bukoo whudézti nuhwheni hoolah whulhtsi 'ink'ez tat dzin inle t'eh, 'et dinaoodutés'alh.” ");
INSERT INTO cafNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","'Et ndunnah Lizwif 'uhiyúlhni, “Njan koo whudézti dit lanezi 'o 'at lhk'utat naoodezut inle hoh lhaoodúlya. 'Et daja ninzun ho' dini, tat dzin whutuh zeh dinaoodutá'alh dini,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","'Et njan Sizi bukoo whudézti howu yalhtuk hoh, dich'oh buyust'e, 'i ghu yalhtuk ho' utni ínle. ");
INSERT INTO cafNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","'Et huwa Sizi Gri dázsai hubutuh dinadija hoh yugha hoodul'eh whunahulnih daja hubúlhni inle da, 'ink'ez ndi Yak'usda bughunek 'uk'une'úsduguz, 'i 'ink'ez khunek 'i Sizi ye yaílhtuk, 'i bulh daja ni ts'iyawh huba 'álha 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","'Awhuz Jerusalem 'et zeh 'ut'en hoh njan Hubutuh Lhusíya, 'et whutah ne'whut'en, bulunah ndunnah Sizi yunilh'en nts'o túne'ut'en, 'et huwa k'us lhanah boozi huba 'alha' yint'ah suli. ");
INSERT INTO cafNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","'Et whunts'ih Sizi dich'oh chah 'aw dune hubut'achanítan, t'eoobunínzun dune dahínt'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","'Ink'ez 'aw 'uyoon dune dahínt'ah 'et ndudóoni ghaít'ah, dich'oh dune dahínt'ah chah t'eoobunínzun 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","'Ilhunuh dune Pharisee bulh dezulh, 'en 'ilhunuh Lizwif hubutsuh whudelhdzulh, 'en Nicodemus hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","'En 'ulh'ek 'et Sizi yughu ninya 'ink'ez ndi yúlhni, “Rabbi, Yak'usda yulh 'int'ah dune, 'en zeh njan huwa 'ét'en tune' oot'en huba 'uhoont'ah. 'Et huwa soo t'ets'onínzun dune hoodulh'eh Yak'usda ts'ih haínya, 'en inli ho' nint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","'Et Sizi 'uyúlhni, “Soo ts'ah'un na'a nyudúsni, dune doo chah zeh whuzdli t'eh, 'et t'eh zeh nts'e Yak'usda 'en hubudayi cho unli whute'ilh.” ");
INSERT INTO cafNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","'Et Nicodemus ndi yúlhni, “Nts'e na'a suba 'ilhunuh dune tube ye'un uzulh, 'en doo chah 'uhóoleh ho' dini? 'Aw whulh nat be'ama yuchan naooja 'ink'ez doo chah 'uhóoleh ghaít'ah!” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","'Et Sizi ndi yúlhni, “Soo ts'ah'un na'a nyudúsni, dune too 'ink'ez Ndoni be chah whuzdli t'eh, 'et zeh nts'e dune Yak'usda dich'oh zeh hubudayi cho unli 'et 'aw dahóoya ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ndun dune bugha whuzdli, 'en dune budune 'int'ah, 'ink'ez ndan Ndoni be whuzdli, 'en Ndoni budune 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","'Et nyudúsni nuhwheni doo chah zeh hóhle huba' hoont'ah. Khun teh 'et huwa mba hócha gunih! ");
INSERT INTO cafNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","'Ants'ih nilhts'i delts'ulh li'hoont'ah. Nilhts'i dints'o 'et whunts'ih nts'ez de hadélts'ut k'us nts'e dutelts'ulh 'aw t'éoonuzínzun. 'Et whuz na'a zeh 'aw t'éoonónzin ghaít'ah nts'e na'a dune Ndoni be whuzdli,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","'Et Nicodemus ndi yúlhni, “Et nts'e na'a 'uwhutét'ilh?” ");
INSERT INTO cafNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","'Et Sizi ndi yúlhni, “Et nyun Israel buts'u hainde whubodilh'eh inli, 'ink'ez nts'e na'a 'int'ah njan 'aw nyeni be t'éoonuzínzun? ");
INSERT INTO cafNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Soo ts'ah'un na'a njan nyudúsni, t'éts'onínzun ndet howu yats'ulhtuk 'ink'ez ts'ah'un na'a nuhwhuts'útni ndai ts'a'en 'ink'ez nuhwheni 'aw neghunek nuhwhuba 'alha' cha'ít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ndi yun k'ut nts'oh tulih né'whut'en, 'et hubugha 'ún whudusni, 'et whunts'ih nuhwhuba 'álha cha'hóot'ah nts'e na'a simba nduk yak'uz né'whut'en, 'et hubugha 'ún whudusni, 'et nuhwhuba 'alha 'uhot'e? ");
INSERT INTO cafNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","'Aw 'ilhunuh dune nduk yak'uz whenya hoolah, 'aw 'ilhunuh zeh 'uja ndus de yak'uz haínya. 'En 'int'ah yinkak dune ye' unli, 'en 'int'ah yak'uz whukeyah whuz'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","'Uda 'aw dune chahahóot'ih 'et Moses 'en tl'ughus k'edéltsi dibe' yudilhtsi inle, whuz na'a yinkak dune ye' dibe na'hidóolhtsih huba 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","'Et huwa ndunnah 'en bugha huba 'alha 'uhoont'ah, 'en 'aw dachatesa, 'ilhuz wule wheni hukhutenalh. ");
INSERT INTO cafNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yak'usda dalhcho 'i be ndi yun k'ut dune húbuk'entsi', 'aw 'ilhunuh zeh buYe' 'en hubugha ínilhti. 'En bugha ndan huba 'alha' yint'ah 'aw dachahútesa, 'ilhuz wheni hukhutena 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","'Aw dune ba nahuteyeh ílah Yak'usda buYe' ndi yun k'uz yutélh'a. 'En bugha ndi yun k'ut whut'en 'en ts'iyannah hudoojih, 'et wheni ndi yun k'uz yutélh'a. ");
INSERT INTO cafNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ndunnah huba 'álha' yint'ah 'en 'aw huba nachahutésyel. 'Et ndunnah 'aw huba 'álha cha'yít'ah, 'en 'uda huba nahézya ho' hint'ah, 'aw Yak'usda buYe' boozi 'aw huba 'alha cha'yít'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","'En 'int'ah be né'hoot'en unli ndi yun k'eínya. 'I 'aw 'i hikacha'nízun njan tsahólhgus yuh 'et 'o nus tinch'a 'uhút'ih, 'et huhóont'i. 'Et huwa huba nahooyeh. ");
INSERT INTO cafNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ndunnah hoontsi' tune'hút'en, 'en ndi be whét'en hits'u dutnik. 'Et huwa ndi be whét'en, 'aw hits'un tóoya ghaít'ah, doo ka tink'us ne'hút'en 'et ts'et haootélts'ulh 'et whuch'a. ");
INSERT INTO cafNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","'Et whunts'ih ndan ts'ah'un na'a 'et'ilh, 'en ndi be whét'en ts'un teyalh, 'et hoh ts'iyannah t'ehonózin, nts'oh tune'út'en, Yak'usda 'en bugha ne'ts'oot'en.” ");
INSERT INTO cafNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Njan hoh túne' whust'en hukw'elh'az Sizi 'ink'ez yugha hoodul'eh Judea yun k'ut ts'ih whehándel. 'Et yugha hoodul'eh higha hudálts'i 'ink'ez dune too be' óobalh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Hoh da zeh John 'en chah keyah Aenon huwhútni, keyah Salem huwhútni wheghah whuz'ai, 'et dune too be 'oobalh'en, 'et too lhai 'et huwa. Dune hits'u lhadulh 'ink'ez bulunah dune too be' binla. ");
INSERT INTO cafNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","'Et John nk'ácha tsak'echalhts'it 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","'Et hoh da John yugha hoodul'eh Lizwif bulh lhk'enahuditdzut Lizwif hube 'ut'en k'ah hukw'una'a lana'huldeh 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","'Et huwa John highu nindel 'ink'ez hiyoodulhkut, “Rabbi ndun dune 'ilhunuh ngha hoodul'eh, Jordan took'oh nyaz ts'ih, 'en dune hubulh yaílhtuk ínle, 'aw 'et 'en dune too be 'úlh'en 'ink'ez ts'iyannah hits'ún lhadulh,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","'Et John ndo búlhni, “Yak'usda yugha óoni'ai t'eh zeh, 'et huwa 'aw 'ants'ih 'et hoonliyaz 'oot'e ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nuhwhenich'oh 'et whunts'ih daja dusni t'éoonáhzun, si 'aw Christ 'en ilah 'ust'ah, 'et whunts'ih 'ilhunuh yutsuh whusál'a, 'en 'ust'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","'Et nduhóont'ah hoh, 'ilhunuh dune ts'eke yughusda, 'en 'at ut'i 'int'ah. 'Et hubuk'entsi' yuzih suyin 'ink'ez yughunek yoozélhts'ai whuz na'a tube yuba hóont'i. 'Et nuhwhúdusni si chah whuz na'a tube cho hoonúst'i. ");
INSERT INTO cafNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","'O nus tube cho hidóolhti 'ink'ez si hukw'elh'ih suba hodóolhti, 'et whuz na'a 'uhót'e huba' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ndun ndus de haínya, 'en ts'iyannah hubugha ndoh 'int'ah 'ink'ez ndan yinkak ts'ih haínya, 'en yinkak dune unli, 'et huwa ndi yun k'ut hoonli, 'i zeh highu yalhtuk. 'Et ndun yak'uz haínya, 'en ts'iyannah hubugha ndoh 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","'Et ndet ndun whunalh'en 'ink'ez whudánts'o, 'et 'uyoon chah hubúlhni, 'et whunts'ih daja hubúlhni 'aw highunek chaílhcholh. ");
INSERT INTO cafNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","'Et whunts'ih ndun yughunek ilhchoot daja ni, 'en 'utni ndun Yak'usda 'en buba 'alha' yint'ah, ni. ");
INSERT INTO cafNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ndun 'en Yak'usda whusayálh'a, 'en 'ink'ez didut Ndoni be yudelhbun, 'et huwa Yak'usda bughunek zeh be yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yak'usda 'en buYe' yuk'entsi' 'et huwa ts'iyaintsuk k'úne' hool'en, 'et yugha óoni'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","'Et ndunnah ndan Yak'usda buYe' buba 'alha yint'ah, 'en 'ilhuz wheni be ts'úkhuna, 'i huyit'i, 'et whunts'ih ndunnah huba 'alha' cha'yít'ah, 'en 'aw honoolh'en ghaít'ah, Yak'usda yé hubulh húnilch'e 'ahoolhyez wheni buk'uz 'uztét'ilh,” ni John. ");
INSERT INTO cafNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","'Et ndunnah Pharisee hiyulh údits'o hoh 'uhíyulhni, “Sizi 'en John degha nus lhanah dune chah yugha hoodul'eh suli, 'ink'ez dune too be' úlh'en chah 'ut'en,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","'Et whunts'ih 'alha Sizi 'aw dich'oh ilah dune too be' bulh'en, yugha hoodul'eh, 'en zeh 'uhut'en. ");
INSERT INTO cafNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","'Et neMoodihti whulh úduzts'ai 'aw 'et Judea yun k'ut whuch'a nasja 'ink'ez Galilee yun k'ut ts'ih natesja. ");
INSERT INTO cafNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","'Et nadalh hoh Samaria yun k'ut hoh lhunátedalh, ");
INSERT INTO cafNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","'ink'ez Samaria yun k'ut keyah Sychar huwhútni ts'ih ninya. Njan keyah 'et yun k'ut Jacob buye' Joseph yugha óoni'ai ínle, 'et wheghah whuz'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","'Et Jacob too k'et 'uhóonla, 'et whuz'ai. 'Et Sizi tube sa nuséya 'ink'ez ninéntsai, 'et huwa too k'et whuzih 'et nátl'adeda. 'Et 6:00 'uhúnet'oh hoh 'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","'Et usda hoh 'ilhunuh ts'eke, Samaria whut'en, 'en too kéya. 'Et Sizi ndi yúlhni, “Too sugha nínkaih!” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Dich'oh zeh 'int'ah, yugha hoodul'eh keyah ts'ih ts'iyi hootekulh ts'ih whehándel 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","'Et ndun Samaria ts'eke 'en 'uyúlhni, “Nyun Lizwif 'int'ah 'ink'ez si Samaria ts'eke 'ust'ah, 'ink'ez di ka dini too suts'un ka' dini?” Lizwif, 'en Samaria whut'en 'aw buka cha'hunízun 'et huwa 'utni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","'Et Sizi ndi yúlhni, “Ndi Yak'usda huwa íni'ai, 'i soo cho t'eninzun t'eh, 'ink'ez ndun 'utni nyulh yálhtuk hoh too nts'u ka 'utni, 'en t'enínzun t'eh, 'et nyun 'uda oodolhkut 'ink'ez ndai too bugha hiye khuna, 'i da nughá yoolhdzeh inle,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","'Et ndun ts'eke ndi yúlhni, “Nyun 'aw be ta'ónkalh 'i chaínt'ih, 'ink'ez njan too k'et nádalhdzat, nts'e na'a ndi too be ts'úkhuna, 'i be 'útankalh? ");
INSERT INTO cafNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Netsuh whudelhdzulh Jacob 'en njan too k'et negha óoni'ai. Didut, buye'kah, 'ink'ez bughunai teh, njan too k'et 'et too hutnai ínle, 'et huwa nyun buba nus incha ninzun ih?” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","'Et Sizi ndi yúlhni, “Ndunnah njan too k'et too utnai, doo chah zeh ta'hóosde hulhih, ");
INSERT INTO cafNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","'et whunts'ih ndunnah too bugha ítelhdzoh, 'i hiyetnai t'eh, 'aw 'o 'at ta'hóde ghaít'ah. Ndun ndi too bugha ínulhdze, 'i too 'ahoolhyez ninli 'int'ah, 'i be 'ahoolhyez wheni hukhutena,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","'Et ts'eke ndi yúlhni, “Hoh ndi too 'udíni 'i sugha nílhdzeh, 'et huwa 'aw 'o 'un tacha'ootuzesde 'ink'ez 'aw 'o 'at njan too ooskalh ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“Nki 'anih díni 'ink'ez 'en bulh dez náht'us,” yúlhni Sizi. ");
INSERT INTO cafNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","'Et ts'eke 'utni, “Aw suki hoolah hoh 'ust'ah.” 'Et Sizi ndi yúlhni, “Soo' dini! Ts'ah'un na'a sudíni, 'aw nki chah hoolah dini. ");
INSERT INTO cafNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","T'éoonúszun skwunlanah nkikah inle, 'ink'ez k'an bughu sinda, 'en chah 'aw nki ilah 'int'ah. 'Et ts'ah'un na'a 'udenja,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","'Et ts'eke ndi yúlhni, “Nyun nus whunilh'en tuli' nint'ah? ");
INSERT INTO cafNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Netsuh whudelhdzulh, 'en ndi dzulh k'ut 'et teni 'uhunilhzun ínle. 'Et nuhwheni 'udúhni Jerusalem 'et 'ilhun whuz'ai, 'et dune teni 'uhunoolhzin huba 'uhoont'ah,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","'Et Sizi ndi yúlhni, “Mba 'alha 'udoosni, 'ilhudzin dez whélts'ulh hoh 'uhoont'ah, 'aw ndi dzulh k'ut k'us Jerusalem 'et zeh ilah Yak'usda 'en buts'u téni 'untelhdzin hoh 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nuhwheni ndai buts'un téni 'unulhdzun 'i 'aw nuhwheni be t'enuzúhzun. Wheni ndun buts'u téni 'uznilhzun t'ezninzun, Lizwif, 'en hubula tah ts'ih zeh dune hudutejih 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ndet whuz de whúdezulh k'an 'et huba 'uhoont'ah, ts'ah'un na'a teni 'uhunilhzun soo ndzi ndulhcho 'i be ts'ah'un na'a Yak'usda hits'un téni 'uhunoolhzin wheni. 'En ndunt'ah, 'en Yak'usda buka' ninzun buts'u téni 'uhunoolhzin ka. ");
INSERT INTO cafNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yak'usda 'en nudúdeh 'i unli ho' 'int'ah. 'Ink'ez ndunnah hits'un téni' hunilhzun, 'en ts'ah'un na'a buyégha be hits'un teni 'unoolhdzin huba' hoont'ah,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","'Et ndan ts'eke ndi yúlhni, “T'éoonúszun ndan Messiah whusatéyalh, ndan Christ hiyúlhni, 'en whusaínya t'eh, dutsuk newhuntelhtun.” ");
INSERT INTO cafNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","'Et Sizi ndi yúlhni, “K'an 'et ndan nyulh yálhtuk, 'en si usdli hoh 'ust'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Soo 'et ndutni 'aw 'et 'ustl'e' 'udeja hoh, yugha hoodul'eh whusanáhedel. Tube huba hooncha Sizi ndun ts'eke 'en yulh yálhtuk, 'et whunts'ih 'aw 'ilhunuh nts'ih chahiyoodulhkut, “Di ka ndun ts'eke 'en bulh yaílhtuk?” k'us, “Ndet 'et nahoote'alh?” chahidínil. ");
INSERT INTO cafNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","'Et ndun ts'eke too ye kuya 'i chah 'aw 'et nínin'ai 'ink'ez keyah ts'ih whenája. 'Et dune ts'iyawh ndó bulhni, ");
INSERT INTO cafNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Anih! Ndun dune noolh'en si! Nts'oh tula né'zust'en inle, ts'iyawh ndusúlhni. 'En tulih Christ 'int'ah?” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","'Et huwa soo ts'iyannah keyah ts'ih hahándel 'ink'ez Sizi highu nindel. ");
INSERT INTO cafNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","'Et ho da yugha hoodul'eh 'uyúlhni, “Rabbi, na'int'alh!” ");
INSERT INTO cafNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","'Et Sizi ndo búlhni, “Uda ndi ts'iyi 'aw nuhwheni t'enuzuhzun, 'i úst'i.” ");
INSERT INTO cafNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","'Et yugha hoodul'eh dich'oh 'úlhodutni, “Uyoon dune yuté'alh 'i yuba whusayánla ho tulih ni?” ");
INSERT INTO cafNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","'Et Sizi ndo búlhni, “Ndun whuz de sutelh'a, ndet suts'u húkwa' ninzun, hoh tune'óost'en 'ink'ez be 'ut'en lhadóosdleh huba 'uhoont'ah. Ndi 'i zeh suts'eyi 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","'Awhuz dink'i sanun whuz'ai, tl'o 'utelilh whuts'un. 'Et whunts'ih 'un whudusni hoh soo zélhts'ai, soo cho nuhwhuna be whunulh'en. Tl'o k'ut 'aw 'et whudezgi tl'o 'utenilh huba. ");
INSERT INTO cafNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ndan whut'as, 'en huba k'elha hóle, 'ink'ez ndan 'ilhodughulhdzeh 'en, 'et ndunnah 'ilhunabughesdle, 'en 'ilhuz wúle hiye khúna, 'i bugha itélts'ulh. 'Et huwa ndan 'a'nule 'ink'ez ndan 'ilhodughulhdzeh, nahúlt'ah 'en hóntelhnik. ");
INSERT INTO cafNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","'Et whuz na'a daja ni 'alha 'utni, ‘'Ilhunuh dune 'en whuye' nule 'ink'ez 'uyoon dune 'en ha' nule.’ 'Et ndi 'utni 'i 'alha 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","'Aw whutsah da cha'záht'en 'et whunts'ih whetélh'a na'oolhdzooh wheni. Whuz whutsuh da 'uyoon suba 'et'en ínle. 'Et k'an nuhli whusáhdel 'ink'ez 'uyoon ha' nanla 'et ha' nilhla,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","'Et ndun ts'eke, njan keyah whut'en, 'en ts'iyannah hubudáni, “Dast'en inle, ts'iyawh ndusúlhni,” ni. 'Et huwa 'en bughunek bugha lhannah Samaria whut'en huba 'alha' yint'ah suli. ");
INSERT INTO cafNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","'Et huwa Samaria whut'en dune Sizi highu nindel hoh hubuzih ónda hiyúlhni. 'Et huwa nat dzin 'et hubuzih inda. ");
INSERT INTO cafNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bughunek 'i bugha tube 'o nus unéltsuk, 'en bugha hububa 'alha 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","'Et ndun ts'eke 'uhiyúlhni, “Aw nyun nghunek 'i bugha zeh ilah neba 'alha' 'int'ah, whenich'oh bughunek ts'udánts'o. 'I bugha 'alha ndun 'en dune telhyis wheni, Christ, 'en ndi yun k'einya t'ets'onanzin,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nat dzin inle hoh Sizi Galilee yun k'ut ts'ih whénya, ");
INSERT INTO cafNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","'ink'ez dich'oh hoh ndútni, “Yak'usda be nus whúnilh'en dich'oh dukeyah inda, 'et whunts'ih, 'aw chahidílhti,” ni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","'Et Galilee yun k'ut ts'ih hainya hoh ndunnah Galilee whut'en 'en dune tube huhóont'i hubughu ninya. Didut chah Jerusalem dzenis whuti nduhóolyez hoh 'et 'uhet'en 'ink'ez Sizi hinilh'en hoh hubunalh hooncha túne' 'ust'en. ");
INSERT INTO cafNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","'Et doo chah Sizi Galilee yun k'ut, keyah Cana huwhútni ts'ih lhunásja. 'Et 'uja too, 'i mai too yulhtsi ínle. 'Et 'ilhunuh dune keyah dune tsuh whudélhdzulh buye' tube únduda keyah Capernaum huwhútni 'et. ");
INSERT INTO cafNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","'Et Sizi Judea yun k'ut ts'ih haínya 'ink'ez Galilee yun k'ut whuz tezya, 'et whulh úduzts'ai hoh yuts'un ninya, Capernaum ts'ih dudulh nátoot'as buye' 'aw 'et datétsah, 'en soo ná'yooleh, 'et hukwa yuts'un tedudlih. ");
INSERT INTO cafNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","'Et Sizi ndi yúlhni, “Nyunalh huwa 'int'en tune' 'ust'en 'ink'ez hooncha tune' 'úst'en t'eh, 'et t'eh zeh mba 'alha 'oost'e.” ");
INSERT INTO cafNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","'Et ndun keyah dune tsuh whudélhdzulh ndi yúlhni, “Sumoodih 'anih soo 'a! Siyaz datétsah whutsah da!” ");
INSERT INTO cafNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","'Et Sizi ndi yúlhni, “Naindalh, nye' khuna.” 'Et ndun dune daja yulhni, Sizi yuba 'alha deja 'ink'ez whenája. ");
INSERT INTO cafNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","'Awhuz bukoo whuts'un nádalh hoh, be' ustle hidudezdel 'ink'ez, “Nye' khuna,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","'Et huboodulhkut, “Soo nts'oh da whudézulh hoh soo na'uja?” 'Et hiyúlhni, “Hulhda 7:00 'uhunit'oh hoh ndi dada buts'u haídelts'ut.” ");
INSERT INTO cafNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","'Et ndun dune t'ewhunínzun soo hoh wheghah whezulh hoh Sizi ndi yúlhni, “Nye' khuna.” 'Et didut 'ink'ez 'on ghoh 'int'ah tubulh, ts'iyawh Sizi bugha hububa 'alha' yint'ah suli. ");
INSERT INTO cafNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","'Et Judea yun k'ut ts'ih haínya 'ink'ez Galilee yun k'ut 'et ninya hoh whulh nat 'i yun k'ut Sizi hooncha tune' 'ust'en. ");
INSERT INTO cafNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Njan hoh tune' whust'en hukw'elh'az 'et Lizwif budzenis whuti 'et wheni Sizi Jerusalem ts'ih whinya. ");
INSERT INTO cafNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nyoh Jerusalem 'et sheep ba da'dentan hoonli, 'et wheghah tádez'ai whuz'ai. Njan tádez'ai, 'et Hebrew k'una'a Bethesda huwhútni, 'et whunat skwunlat bun tsilh t'ah whuzdla. ");
INSERT INTO cafNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Njan bun tsilh t'ah 'et tube lhanah nduda 'et husdla. Bulunah chahuwhés'en, 'ink'ez bulunah hubódin'ai, 'ink'ez bulunah chah nchahúghusna. 'En ndi too nutughetnah, 'et huba hilh'i. ");
INSERT INTO cafNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Soo nenaóodughidzuk te'whut'ih totsuk, lizas ndus de hadúdoh 'ink'ez tadez'ai, 'et too nunáhighelnaih. Ndan soo 'udechoo toot tayih 'en, nts'oh dant'i dada be nduda, 'et whunts'ih soo na'ut'ih. ");
INSERT INTO cafNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","'Ilhunuh dune tat lanezi 'o 'at lhk'udit (38) naóodezut, 'en 'et ndúda. ");
INSERT INTO cafNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","'Et sulhti hoh Sizi yunilh'en. T'ewhunínzun tube sa 'et ilhte. 'Et ndi yúlhni, “Soo ná'tantnilh hukwa' ninzun ih?” ");
INSERT INTO cafNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","'Et 'ahoh dune nduda 'utni, “Ndi too nunaghetnaih teh, 'aw dune tasóolhtelh hoolah. 'Awhuz whuts'un húkwa 'ust'en hoh 'uyoon whusayih 'ink'ez sutsuh tayih.” ");
INSERT INTO cafNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sizi 'et ndí yulhni, “Didinyih, kw'usinti 'i ílhchoot, 'ink'ez nínya!” ");
INSERT INTO cafNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","'Et 'ahoh dune nduda soo ná'uja. Yuk'usti 'i yílhchoot, 'ink'ez tezya. Lizwif nahulyis 'et dzin 'et 'uhóoja. ");
INSERT INTO cafNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ndun dune soo ná'uja, 'en Lizwif ndi hiyúlhni, “K'an dzin nahulyis ho' 'uhoont'ah. 'Aw bukw'usinti 'i 'aw nólhchoos huba chahóot'ah!” ");
INSERT INTO cafNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","'Et ndo búlhni, “Ndan soo ná'sinla, 'en 'usúlhni, ‘Kw'usinti 'i ilhchoot 'ink'ez ninya,’ sulhni.” ");
INSERT INTO cafNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","'Et huwa hiyoodulhkut, “Ndan ho' 'int'ah, ndi kw'usinti 'i ilhchoot 'ink'ez ninya nyúlhni 'en?” ");
INSERT INTO cafNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","'Et ndun dune dich'oh chah 'aw t'eyunízun ndan 'uyínla soo ná'yinla. Tube lhanah dune tadez'ai, 'et 'uhut'en hoh Sizi whu'iz ts'ih whenya, 'et huwa 'aw t'echahinízil. ");
INSERT INTO cafNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Njan 'et ndúhooja hukw'elh'az luglez whucho 'et Sizi ndun nayilhti 'ink'ez ndi yúlhni, “Dahooja, k'an 'aw 'et soo ná'inja. Lubeshi 'ilh'en 'ustl'e' 'oneh, doo ka 'o nus hoontsi' 'et ts'ih ngha hólts'it!” ");
INSERT INTO cafNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","'Et ndun dune whenája 'ink'ez Lizwif hubudáni Sizi 'en 'uyínla soo ná'yinla. ");
INSERT INTO cafNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","'Et huwa Lizwif Sizi dzuh nahídilhdzut 'ink'ez hituzelhghelh 'et hukwa húnuta. Njan nahulyis dzin 'et hoh tune' 'ust'en 'et hukwa. ");
INSERT INTO cafNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","'Et whunts'ih Sizi ndo búlhni, “ABá 'ahoolhyez 'ut'en, 'et huwa si chah 'oost'en huba 'uhoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","'Et hukwa Lizwif 'o nus hituzelhghelh hukwa' huninzun. 'Aw nahulyis dzin lhk'onínyuz 'et huwa zeh ilah, 'ink'ez chah Yak'usda 'en be'aBá yulhni. 'Et ndutni hoh 'et bugha ts'ih Yak'usda yulh lhúgha 'int'ah ni, 'et huwa hituzelhghelh hukwa' huninzun. ");
INSERT INTO cafNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","'Et Sizi 'et ndo búlhni, “Soo ts'ah'un na'a 'un whúdusni, si Yak'usda buYe' usdli, 'et whunts'ih 'aw sich'oh hukwa' nuszun tune' 'oost'en ghaít'ah. Yak'usda se'aBá nts'oh ne'út'en nulh'en, 'et whuz na'a zeh buYe' ne'út'en. ");
INSERT INTO cafNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Se'aBá buYe' yuk'entsi' 'et huwa ts'iyai tsuk be 'ut'en k'ah whénulhtun. det whunalh'en, 'et 'o nus 'ut'en k'ah hooncha, 'et whuyúntelhtun. 'I be tube nuhwhuba hóoncha. ");
INSERT INTO cafNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Se'aBá 'en 'ut'en, yahadla 'en dinabudile 'ink'ez ndunnah hubuka' ninzun, 'en 'ilhuz hiye khúna 'i hubugha yú'aih. Whuz na'a zeh si Yak'usda buYe', ndunnah hubuka' nuszun, 'en 'ilhuz hiye khúna 'i hubugha yús'aih. ");
INSERT INTO cafNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Se'aBá 'en 'aw dune ba nahéyelh ílah, k'us buYe' 'en dune ba nahooyeh, 'et yutl'ahó'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Njan 'et ndúja, 'et huwa buYe' dune ts'iyannah 'en hidóolhti nts'e na'a be'aBá hidélhti hukw'una'a. Ndunnah buYe' chadílhti 'en 'aw be'aBá 'en chah chahidílhti, 'ink'ez 'en 'uyínla buYe' whusayálh'a inle. ");
INSERT INTO cafNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Soo ts'ah'un na'a nuhwhudúsni, ndunnah sughunek ílhchoot 'ink'ez ndun whuz de sútelh'a, 'en hubugha hububa 'alha' 'uhoont'ah, 'en 'ilhuz hiye khúna 'i hiyít'i. 'Aw hubuna'doodeh ghaít'ah, 'uda be dats'útsaih 'i hiye ghóozdel 'ink'ez 'ilhuz hiye khúna, 'i hiyít'i. ");
INSERT INTO cafNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Soo ts'ah'un na'a 'un whudúsni, ndet whuz de whúdezulh k'an 'aw 'et néwhults'ut. K'an 'aw 'et yahadla Yak'usda buYe' bughunek hidutéts'o, 'ink'ez ndan hidánts'o, 'en hukhutenalh. ");
INSERT INTO cafNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Se'aBá 'en dich'oh hiye khúna 'i yit'i. 'Et whuz na'a zeh buYe', 'en chah be khútna 'i dich'oh yít'i, 'et yugha óoni'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","'Ink'ez ts'iyannah hubugha ndoh 'oot'e, 'et chah yugha óoni'ai. Yak'usda buYe' unli 'ink'ez yinkak dune ye' chah unli, 'et huwa ts'iyannah dune huba nahuteyelh huba 'uhóont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Daja 'un whudúsni 'aw nuhwhuba hócha gunih! 'Aw 'et whuz de whúdezulh, 'et ts'un k'ut yahadla chah highunek hidutéts'o, ");
INSERT INTO cafNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","'ink'ez dinahudutédulh. Ndunnah 'ut'en unzoo 'i 'ahiyulh'en, 'en dinábudutélelh 'ilhuz wheni hukhutena, 'ink'ez ndunnah hoontsi' tune' húst'en, 'en chah dinábudutélelh 'ilhuz wheni dzuh nahutezut huba nahuteyeh. ");
INSERT INTO cafNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","'Aw sich'oh ndúhoont'ah whunóolh'en ghaít'ah. 'Aw sich'oh hukwa' nuszun tune' 'óost'en ghaít'ah. Nts'oh tula se'aBá suts'u húkwa' ninzun hoh teh zeh ne'úst'en. 'Et huwa dune ba nahutesyeh t'eh, se'aBá súlhni, 'et whuz na'a zeh dune ba nahusyeh, 'et ts'ah'un na'a 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Sich'oh sugha 'un whudúsni t'eh, 'aw nuhwhuba 'álha cha'zóost'e. ");
INSERT INTO cafNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","'Et 'uyoon 'int'ah, 'en si sugha ts'iyannah dune wheóobunulhtun 'ink'ez si sugha daja ni, 'alha 'uhoont'ah 'et t'ewhunúszun. ");
INSERT INTO cafNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","'Et nuhwheni 'uyoon, 'en John ts'un wheóobalh'a, 'et daja ni, 'et khunek 'alha' 'int'ah 'i be hubudáni. ");
INSERT INTO cafNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","'Aw dune si sugha daja ni, 'et huwa zeh ilah, njan ndúhoont'ah huwa ndun nuhwhudúsni, 'et huwa whedóohjih, 'et huwa ndun whudúsni. ");
INSERT INTO cafNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John 'en too dezk'un 'ink'ez be whét'en, 'i hubut ts'u hayándi 'et ndánt'e. 'Astl'iyaz wheni ndi be né'hoot'en, 'i be ndunwhúlhni inle. ");
INSERT INTO cafNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","'Et whunts'ih John si sugha 'uyoon wheóobunelhtan, 'o nus 'uhóolcho, 'et whust'i. Ndi 'ut'en 'i se'aBá stl'ayá'ai lhadóosdleh wheni, 'i 'ut'en 'aw 'i zeh bughá khusna, 'i bugha 'uyoon t'ehonózin, se'aBá 'en whuz de sútelh'a. ");
INSERT INTO cafNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","'Ink'ez se'aBá, ndun whuz de sútelh'a, 'en dich'oh si sugha ts'ah'un na'a whulhtsi. 'Aw yalhtuk chah suduzahts'o, 'ink'ez dant'ah unli 'aw chaséh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","'Ink'ez bughunek 'aw chaóozahtun. Ndun whuz de yútelh'a 'aw nuhwhuba 'alha' cha'ít'ah, 'et huwa bughunek 'aw nuhwhéyah chadi'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yak'usda bughunek 'uk'une'úsduguz, 'i be 'ilhuz hiye khúna 'i aht'i nahzun, 'et huwa 'áht'en soo cho hoodulhú'eh, 'ink'ez ndi khunek 'uk'une'úsduguz, 'i si sugha zeh 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Si sugha 'ilhuz wule hiye khúna 'i 'ooht'e, 'et whunts'ih 'aw suts'u tóohdelh hukwa cha'nuzuhzun. ");
INSERT INTO cafNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","'Aw dune ye súdelhti 'i wulhchoot ghaít'ah, ");
INSERT INTO cafNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","'et whunts'ih nuhwheni nuhwhugha ts'iyawh t'éoonúszun. Nuhwhuyuh ts'ih daht'ah hoh 'aw Yak'usda buk'echatsi' 'et t'ewhunuszun. ");
INSERT INTO cafNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Se'aBá 'en boozi bugha whusáya, 'et nuhwheni 'aw suka cha'nuzáhzun, 'et whunts'ih 'uyoon teh dich'oh buboozi bugha whusaínya t'eh, 'et t'eh da 'en buka' noohzin. ");
INSERT INTO cafNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nuhwhenich'oh nuhtah chaoodúlhti. 'Et whunts'ih, ndai be 'uzdélhti 'i Yak'usda dich'oh buts'u haídelts'ut, 'i 'aw bakancha'zaht'o 'et huwa nts'e na'a nuhwhuba 'alha' 'uwhutét'ilh? ");
INSERT INTO cafNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Se'aBá 'en bubut nuhk'éhos'alh noohzin gunih! 'Uyoo chah hoonli. Ndi khunek Yak'usda neba lhuhezya, 'i Moses 'en yutl'aída'ai ínle, 'i but'anínuhtan, 'en, 'i nuhk'éhoo'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ndi Moses 'uk'uné'uzguz 'i, nuhwhuba 'alha' 'int'ah t'eh, 'et si sugha chah da nuhwhuba 'alha 'uhót'e, Moses si sugha 'uk'uné'uzguz 'int'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","'Et whunts'ih ndi Moses 'uk'uné'uzguz 'i 'aw nuhwhuba 'alha' cha'ít'ah 'et huwa nts'e na'a suba si sughunek 'i nuhwhuba 'alha 'oot'e?” 'et Sizi ndubulhni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","'Et hukw'elh'az Galilee bun k'ut 'et Sizi nyan whinki, 'i bun k'ut zeh Tiberias cha huwhútni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Hunduda hubutah tube huwa 'ét'en tune' 'úst'en 'et hinilh'en, 'et huwa tube lhanah 'ilhunahuwésdel, 'en 'et nihínudelh. ");
INSERT INTO cafNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","'Et Sizi yasúya hoh yugha hoodul'eh tubulh, 'on ndoh dzulhyaz k'ut 'et nátl'ahúdelts'i. ");
INSERT INTO cafNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","'Aw 'et wheghah whudezulh Lizwif Yak'usda bulizas Hubutus Lhuséya whunahulnih. ");
INSERT INTO cafNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","'Et nyoh dzulhyaz k'ut Sizi whunilh'en tube lhanah dune hits'ú lhadulh, 'et hubunilh'en hoh Philip 'uyúlhni, “Nts'e lhes ts'ootekulh, ndunnah dune hite'alh huba?” ");
INSERT INTO cafNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","'Et Sizi dich'oh daténilh 'et nt'eoonínzun, 'et whunts'ih Philip 'en yóolhdzi ho 'utni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","'Et Philip 'utni, “$200.00 k'ah dustl'us lhes 'aw huba soo cha'níltsuk, 'i 'ilhunuh hinli 'et whunts'ih ntsólyaz hite'alh, 'i hiya'al.” ");
INSERT INTO cafNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","'Et 'ilhunuh Sizi yugha hoodul'eh, Andrew, Simon Peter bulhutsin, 'en Sizi ndi yúlhni, ");
INSERT INTO cafNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Njan 'ilhunuh duneyaz netah 'ut'en, 'en lhes sut'e skwunlai (5) chah 'ink'ez lhookyaz nankoh (2) chah, 'i yit'i, 'et whunts'ih di wule lhe'huneltsuk yute'ulh huba?” ");
INSERT INTO cafNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","'Et Sizi 'utni, “Ts'iyannah nitl'ahudoolts'ilh hubuhútni.” 'Et 'uhut'en tl'oyaz k'ut hoonli, 'et dune 5,000 bat'en hinli hoh 'et natl'áhudelts'i. ");
INSERT INTO cafNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","'Et Sizi lhes yílhchoot, Yak'usda ts'un suchanailya ni hoh tenadédli, 'ink'ez yugha hoodul'eh hubutl'áyanla, hudélhts'i ts'iyawh hubutah niyoowhnih ni. 'Et lhookyaz yílhchoot 'ink'ez 'i chah 'et ndúyinla. Ts'iyannah soo 'uneltsuk hoh hiyílhchoot 'ink'ez hiya'al. ");
INSERT INTO cafNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","'Ink'ez ts'iyannah 'uhunesdai hoh, Sizi yugha hoodul'eh ndo búlhni, “Ndai ts'íhtezkat, 'i soo ts'iyawh 'ilhunawoohlelh, 'et huwa 'aw tintaookat ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","'Et huwa soo ts'iyannah 'an'al hukw'elh'az, ndai highá wéz'al 'i ndi skwunlai lhes sut'e 'ink'ez nankoh lhookyaz bulh, díhtezkat, 'i lhunahighezdla hoh lanezi 'o 'at nankoh (12) hoongwun 'i dezbun. ");
INSERT INTO cafNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","'Et ndunnah dune honalh'en hoh Sizi dahoolcho 'uja, “Et 'alha' hoont'ah hoh ndun 'en nus whunilh'en 'et njan yun k'e teyalh, 'en 'int'ah,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","'Et Sizi t'éwhunínzun hubudayi cho tele, 'et k'ehintét'a hukwa' huninzun, 'et huwa doo chah zeh dich'oh dzulhyaz k'uz whenája. ");
INSERT INTO cafNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","'Aw 'et hulhgha suli hoh yugha hoodul'eh 'en bun k'ut ts'ih whenahedel, ");
INSERT INTO cafNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","'ink'ez ts'i be nahédel nyan keyah Capernaum ts'ih whuz nahutekelh hukwa' huninzun. 'Aw 'et tube tsahólhgus suli 'ink'ez Sizi 'awhuz bughu nachasdak. ");
INSERT INTO cafNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tube nilhtsi ulhtus, 'et huwa too k'ut tatsi díncha suli. ");
INSERT INTO cafNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","'Aw 'et bun k'ut lhulcho 'uhut'en hékelh hoh, Sizi too k'ut uyalh hoh hitelh'en, 'ink'ez 'aw 'et hubuts'i hubughah haínya hoh tube híyenelhujoot. ");
INSERT INTO cafNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","'Et, “Aw senlhujut ílah, si 'ust'en!” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","'Et ndo búlhni hukw'elh'az huhóont'i hoh hubuts'i be naja. 'Et hubughu denája ibulh, 'a hoh nts'e yun k'ut hutézki, whuz yáhuzki. ");
INSERT INTO cafNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","'Om bun dzin 'et ndunnah bun k'ut ts'ih 'ilhohuwezdel ínle ts'iyaz 'ilho zeh 'et hinalh'en ínle, 'et huwa Sizi 'aw yugha hoodul'eh hubughut denachaídal, hi'et whenadúki t'éhonínzun. ");
INSERT INTO cafNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","'Et whunts'ih ndet neMoodihti Yak'usda ts'un lhes ba tenadedli 'ink'ez dune tainínla huyoo'alh wheni, 'et whuzih, 'et hukw'elh'az 'uyoo ts'i chah Tiberias whuz de hainkat. ");
INSERT INTO cafNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","'Et ndet 'ilhohuwezdel ts'iyawh t'ehonanzin Sizi chah hoolah 'ink'ez yugha hoodul'eh chah ts'iyawh chah huhóolah, 'et huwa didut chah ts'iyawh ts'i be hándel 'ink'ez nyan Capernaum ts'ih whehánki Sizi hikunúta wheni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","'Et ndunnah 'ilhohuwezdel bun k'ut nyan nahuninki hoh Sizi nahiyilhti 'ink'ez hiyoodulhkut, “Rabbi nkeda njan 'et nínya?” hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","'Et Sizi ndo búlhni, “Soo ts'ah'un na'a 'un whudúsni, 'aw njan nuhnalh huwa 'ét'en túne' 'ust'en, 'et huwa zeh ilah skunáhta. Ndi lhes nuhgha ní'ai, 'ink'ez be soo 'uhja, 'i ka zeh 'aht'en skunúhta. ");
INSERT INTO cafNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ndi naht'alh 'i hoolah nadleh ho' 'int'ah, 'aw 'i ilah bukunáhta, k'us ndi ah'alh 'i dune 'ilhuz wule beye khútena, 'i zeh bukunóohta. Yinkak dune ye', 'en 'i nuhwhughá yoo'alh, be'aBá Yak'usda 'en yugha óoni'ai, 'en behóodel'en, buYe' 'int'ah 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","'Et 'uhiyúlhni, “Dats'út'en hoh ndi Yak'usda be 'ut'en 'uts'utélh'ilh?” ");
INSERT INTO cafNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","'Et Sizi ndo búlhni, “Ndun dune Yak'usda nuhts'u whusayálh'a, 'en nuhwhuba 'alha 'oot'e. Ndi 'i Yak'usda be 'ut'en, 'i 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","'Et 'uhiyúlhni, “Dant'i 'ut'en 'utalh'ilh? 'Ilhunuh huwa 'ét'en neba 'uhoonleh, 'et t'eh ts'onoolh'en, 'ink'ez neba 'alha 'ont'e. ");
INSERT INTO cafNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wheni netsuh whudelhdzulh 'aw dune chahóot'ih ts'ih manna ndus de hainkat, 'i hiya'al. Yak'usda be' dustl'us k'ut 'uk'une'úsduguz bughunek, 'i 'utni, ‘Lhes yak'uz haínkat, 'i bugha íni'ai hiyoo'alh wheni,” hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","'Et Sizi ndo búlhni, “Soo ts'ah'un na'a 'un whudúsni 'aw Moses 'en bugha ílah ndi lhes yak'uz hainkat, 'i nuhgha yá'aih inle, 'et k'us se'aBá 'en 'ut'en yak'uz whules nuhgha yú'aih. ");
INSERT INTO cafNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ndi Yak'usda bules 'en 'int'ah ndus de yak'uz haínya 'ink'ez yinkak whudune 'ilhuz wheni hiye khútenalh 'i bugha iní'ai.” ");
INSERT INTO cafNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","'Et 'uhiyúlhni, “NeMoodihti, k'an whuts'un 'ahoolhyez ndi lhes 'i negha óon'alh.” ");
INSERT INTO cafNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","'Et Sizi ndo búlhni, “Si 'ust'ah ndi lhes ndai dune yugha khúna 'i usdli. Ndan sughuyih, 'en 'aw 'ilhuz wheni buye'óolts'ilh ghaít'ah, 'ink'ez ndan si buba 'alha' 'ust'ah, 'aw 'ilhuz wheni ta'hóde ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","'Et 'un whudúsni, k'an sunulh'en 'et whunts'ih 'aw nuhwhuba 'alha' cha'úst'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ndunnah 'en se'aBá sugha bunínla, 'en suts'un hútoodelh, 'ink'ez ndan sughuyih, 'aw hubuch'a naóolhu'ah ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","'Et húkwa ndus de yak'uz ts'ih háya. 'Aw sich'oh hukwa' nuszun tuné' test'en huba ilah, ndun whuz de sútelh'a, 'en nts'oh tula daóotenilh hukwa' ninzun, 'i 'ut'en 'óosdleh wheni whusáya. ");
INSERT INTO cafNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","'Ink'ez se'aBá, whuz de sútelh'a, 'en ndunnah sugha buninla 'aw 'ilhunuh whunts'ih yudóonih hukwa cha'nízun, 'ink'ez dek'elh'az dzin t'eh dinabudutélelh. ");
INSERT INTO cafNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ndunnah Yak'usda buYe' t'einínzun 'ink'ez 'en buba 'alha 'uyint'ah, 'ilhuz wheni hiye khúna 'i hiye'tét'ilh, 'ink'ez dek'elh'az dzin t'eh 'en dinabudutélelh. Ndun whuz de sútelh'a njan 'et hukwa' ninzun 'et huwa,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","'Et Lizwif 'en Sizi hich'a yáwhenilhtuk, “Datni hóh 'utni ndi lhes yak'uz ts'ih halts'ut 'i 'ust'ah ni?” ");
INSERT INTO cafNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","'Ink'ez chah 'uhutni, “Nilh'en lhe'hoont'ah k'una'a yalhtuk! Ndun 'utni, 'en Joseph buye' Sizi 'en 'int'ah, 'ink'ez be'abá chah, be'ama chah, t'ébuznínzun. Nts'e na'a 'utni ndus de yak'uz ts'ih háya ni?” hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","'Et Sizi ndo búlhni, “Aw nuhwheni tah sughu yálhtuk ilah! ");
INSERT INTO cafNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ndunnah se'aBá sts'ó bunilht'uk, 'en zeh suts'un hutoodelh, 'ink'ez dek'elh'az dzin t'eh 'en dinahubudutélelh. ");
INSERT INTO cafNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ndun nus honilh'en, 'en ndi 'i hik'une'úzguz ínle, ‘Yak'usda 'en ts'iyannah hubodutelh'eh,’ 'Et huwa ndunnah se'aBá bughunek hidánts'o 'ink'ez 'i bugha huhodul'eh t'eh, 'en 'uhutenilh suts'un hutedulh. ");
INSERT INTO cafNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","'Aw se'aBá ya'en hoolah 'et whunts'ih ndun Yak'usda buts'u haínya 'int'ah, 'en zeh ya'en. ");
INSERT INTO cafNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","'Alha 'un whudúsni, ndunnah si buba 'alha' 'ust'ah, 'en 'ilhuz wule hiye khúna 'i hiyít'i. ");
INSERT INTO cafNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Si 'ust'ah lhes dune ye khúna, 'i usdli. ");
INSERT INTO cafNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nuhtsuh whudelhdzulh, 'en 'aw dune chahóot'ih ts'ih huwhut'i ínle, 'ink'ez manna 'i hiya'al, 'et whunts'ih yahadla. ");
INSERT INTO cafNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","'Et ndi lhes yak'uz ts'ih haínkat, 'i, ndan ya'al t'eh, 'aw dahóotsah ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ndi lhes yak'uz ts'ih haínkat 'i, 'ilhuz wule wheni hiye khúna, 'i 'ust'ah. Ndunnah ndi lhes ya'al t'eh, 'en 'ilhuz wheni hukhutenalh, 'ink'ez ndi lhes nuhgha té'alh, 'i suyust'e 'int'ah. 'Et ndi bugha ités'alh, 'i hubugha yinkak whudune, 'ilhuz wule wheni hukhutenalh,” húbulhni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","'Et doo chah ndunnah Lizwif 'et lhk'enahudidzut 'et nduhútni, “Nts'e na'a ndun dune buyust'e ts'ute'ulh?” hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","'Et Sizi ndo búlhni, “Ts'ah'un ndun whudusni, 'aw ndun yinkak dune ye' buyust'e cháh'ulh 'ink'ez buzkai chah cháhtnil t'eh, 'et ndi 'ilhuz wheni hiye khúna 'i 'aw chatuzeht'ih hoh 'uht'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ndan suyust'e ya'al 'ink'ez suzkai chah yétnai, 'en 'ilhuz wheni hukhutenalh 'ink'ez 'udek'elh'az dzin t'eh dinábudutélelh. ");
INSERT INTO cafNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Suyust'e soo ts'uyi 'i 'int'ah, 'ink'ez suzkai chah soo ts'utnai 'i 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ndan syust'e ya'al, 'ink'ez suzkai chah yetnai, 'en 'ilhuz wheni sulh 'útet'e 'ink'ez si chah bulh 'útest'ilh. ");
INSERT INTO cafNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Se'aBá, 'ilhuz wheni khuna, 'en whuz de sútelh'a. 'En bugha si chah 'ilhuz wheni khusna. 'Et whuz na'a ndan sk'ut dune unli, si sugha 'ilhuz wule hukhutena. ");
INSERT INTO cafNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","'I 'int'ah, ndi soo lhes unli hoh ndus de yak'uz ts'ih haínya. 'Aw manna dulh nduchait'ah nuhtsuh whudelhdzulh 'aw dune chahóot'ih huwhut'i 'ink'ez hiya'al inle, 'et whunts'ih yahadla. Ndi lhes k'an bughu yalhtuk, 'i ndan ya'al, 'ilhuz wheni hukhutenalh,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sizi njan 'et ndutni inle keyah Capernaum huwhútni 'et luglez dune hodul'eh da. ");
INSERT INTO cafNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Lhanah yugha hoodul'eh daja hutni hidánts'o hukw'elh'az 'uhutni, “Njan whuneodulh'eh, 'et neba howu whulna k'una'a 'utni. Nts'e na'a buk'úne' 'uztet'en?” ");
INSERT INTO cafNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sizi dich'oh t'éwhunínzun daja ni 'et huwa hubudzi yuh ts'ih hich'a yalhtuk, 'et huwa yugha hoodul'eh huboodulhkut, “Nuhwhuba dzuh 'udusni ih? ");
INSERT INTO cafNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","'Ink'ez yinkak dune ye' ndoh nts'e whutsuh da usda ts'ih, whuz nadalh nulh'en t'eh, daja ntehzilh? ");
INSERT INTO cafNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ndoni 'en 'ut'en yinkak dune 'en 'ilhuz hukhutenalh bugha whu'aih. Dune yust'e yu'alh, 'aw hoonli chahoolah ho' hoont'ah. Ndi khunek be nóhwhulh yalhtuk, 'i Yak'usda buts'u haídankat, 'i 'int'ah 'ink'ez 'i be 'ilhuz wheni hukhutenalh. ");
INSERT INTO cafNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","'Et whunts'ih nuhtah bulunah 'aw nuhwhuba 'alha' cha'hoot'ah.” Sizi 'uda t'eooninzun ndunnah hububa 'alha' cha'hoot'ah, 'ink'ez ndun ye 'óotekulh, 'et chah t'eoonínzun 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","'Et Sizi 'utni, “Et huwa 'un whudúsni, ndunnah se'aBá bugha óoni'ai, 'en zeh sts'un hutédulh ho' 'ínt'ah,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","'Et whuts'un lhanah yugha hoodul'eh hich'a nasdel 'ink'ez 'aw 'o 'at highah lhúnasdel. ");
INSERT INTO cafNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","'Et Sizi ndunnah lanezi 'o 'at nannah (12) yugha hoodul'eh huboodulhkut, “Nuhwheni chah ih such'a natehdulh hukwa' nahzun?” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","'Et Simon Peter ndi yúlhni, “NeMoodihti, ndan simba buts'uztoodelh? Nyun zeh khunek 'ilhuz wheni be ts'úkhuna, 'i ínt'i, ");
INSERT INTO cafNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","'ink'ez neba 'alha' 'int'ah. T'éts'onínzun nyun Christ 'en 'int'ah. Yak'usda 'ilhuz wheni khuna, 'en buYe' 'int'ah!” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","'Et Sizi ndo búlhni, “Alha nuhwheni lanezi 'o 'at nanah, 'en lhtahanhóla, 'et whunts'ih nuhtah 'ilhunuh 'en netsudule unli. ");
INSERT INTO cafNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas Iscariot, Simon buye', 'en bugha yughi yalhtuk hoh 'utni, 'en 'utenilh, ye 'óotekulh t'éwhunínzun 'et huwa 'utni. 'En chah lanezi 'o 'at nanah 'ilhunuh butuh 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Njan hukw'elh'az Sizi Galilee yun k'ut zeh hoh nuséya. Lizwif hituzelhghelh hukwa' huninzun 'et whuch'a 'aw Judea yun k'ut nóya hukwa cha'nízun. ");
INSERT INTO cafNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lizwif budzenis whuti, 'et 'ulbun be koo nihúwhulih chah huwhútni, 'aw 'et nilhdukw whuz'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","'Et bulhutsinkah khunek be' 'uhiyulhni, “Njan huwinyalh 'ink'ez Judea yun k'ut ts'ih inyalh, 'et ndet ngha hoodul'eh ndai 'ut'en bugha ghína 'et honolh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ndan ts'iyannah t'einóozin hukwa' ninzun 'aw whu'iz ne'oot'en ghaít'ah. 'Alha hooncha túne' 'int'en t'eh, ndi yun k'ut dune ts'iyannah nyun ngha t'ehonóozin huba 'uhoont'ah!” ");
INSERT INTO cafNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bulhutsinkah 'en whunts'ih 'aw ndun Christ 'en 'int'ah 'aw huba 'alha' cha'hóot'ah, 'et huwa hoh tune' hiduni. ");
INSERT INTO cafNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","'Et Sizi ndo búlhni, “Sutsuh whudezulh 'awhuz whusachawhulhts'it, 'et nuhwheni nuhwhuts'u whélts'ulh, 'et 'ahoolhyez lhawhúdint'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ndi yun k'ut dune 'aw nuhwheni nuhwhuts'u dootnik ghaít'ah, 'et si suts'u hudutnik. Tink'us 'úhut'en ts'iyawh 'et hubugha ndo budúsni, 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Whute dzenis whuti ts'ih whuz ahdulh. Sughá whunt'ai 'awhuz 'aw lhachaduzusne, 'et huwa 'awhuz 'aw si dzenis whuti ts'ih toosya ghaít'ah,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Njan 'et ndubúdani hukw'elh'az Galilee yun k'ut 'et inda. ");
INSERT INTO cafNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bulhutsinkah dzenis whuti ts'ih whehandel hukw'elh'az, Sizi dich'oh chah whu'iz 'et whuz whinya, 'aw dune bunalh ilah. ");
INSERT INTO cafNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","'Et nyo dzenis whuti whutuh 'et Lizwif hika ités'en 'ink'ez 'uhutni, “Nts'e 'ut'en ho' 'int'ah?” hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","'Et 'ilhohuwezdel dich'oh dutuh whu'ízyaz hoh highu yalhtuk. Bulunah chah 'en unzoo hutni, 'ink'ez bulunah chah 'awundooh ts'iyannah nana'ah, 'et huwa 'en untsi' hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","'Et 'aw 'ilhunuh whunts'ih ts'et highu yachalhtuk, ndunnah Lizwif moodih hubé hunuljut 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","'Aw 'et dzenis whuti lhuhoolcho bat'en 'uwhét'ilh, 'et Sizi ndoh luglez whucho ts'ih nínya, 'ink'ez dune huboodulh'eh, ");
INSERT INTO cafNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","'ink'ez daja ni Lizwif tube huba hooncha 'ink'ez 'uhutni, “Aw dune hoodul'eh ts'ih inda ilah, 'ink'ez nts'e na'a stabe 'o nus lhat t'éwhunínzun?” ");
INSERT INTO cafNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","'Et Sizi ndo búlhni, “Ndai be hoonwhudulh'eh, 'i 'aw si si'ilhdzun cha ilah 'int'ah. Ndun whuz de sútelh'a, 'en buts'u haídelts'ut, 'i 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ndunnah Yak'usda yuk'úne' tet'ilh hukwa' ninzun, 'en t'ehonózin, ndi khunek Yak'usda buts'u haidelts'ut 'i 'int'ah, k'us sich'oh sughunek be yalhtuk, 'et t'ehonózin. ");
INSERT INTO cafNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","'Et dune dich'oh khuyanaltuk t'eh, dich'oh dutéti 'et zeh hukwunúta hoh 'utni. 'Et whunts'ih dune yalhtuk, ndun whuz de yútelh'a, 'en yudutélhti hukwunúta t'eh, 'en ts'ah'un na'a dune unli hó 'utni 'ink'ez tink'us ne'ut'en 'i 'aw bughi yóolah. ");
INSERT INTO cafNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","'Aw ih Moses 'en ndi khunek buk'úne'ooht'en, 'i nuhwhutl'aída'ai, 'et whunts'ih 'aw hubuk'uncha'zuht'en, 'ink'ez di ka sutuzelhghelh hukwa' nahzun?” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","'Et 'ilhohuwezdel 'uhiyúlhni, “Ntsi' ndúdeh, 'i nyudínda! Ndan nyutuzelhghelh hukwunúta ho' dini?” ");
INSERT INTO cafNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","'Et Sizi ndo búlhni, “Et nats'ulyis dzin 'ilhun 'ut'en, 'i ncha, 'i 'úsdla, 'et nuhwheni tube nuhwhuba hóncha. ");
INSERT INTO cafNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","K'an daja nuhwhudutésnilh 'et hubugha nuní nahzut. Moses, 'en bugha buka dune ahli, 'i óonaht'as ínle. ('Aw Moses 'en bugha zeh ilah, nuhwhutsuh whudelhdzulh, 'en buts'u hawhélts'ut hoh 'uht'en.) 'Ink'ez 'et nats'ulyis dzin 'uskiyaz duneyaz whulih teh, 'o 'at nats'ulyis dzin 'et yuka dune unli, 'i hiyut'as. ");
INSERT INTO cafNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","'Et ndúhoont'ah hoh Moses be' dustl'us k'ut butulhúhesde k'ohyis whuch'a, nats'ulyis dzin 'et dzin whunts'ih 'uskiyaz dune whulih teh yuka dune unli hiyóot'as. 'Ink'ez di ka 'et si dune nats'ulyis, 'et dzin dune soo ná'usdla 'et hukwa sulh húnlhuch'e? ");
INSERT INTO cafNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","'Aw whunulh'en 'et huwa ilah dune ba nahahye, ts'ah'un na'a 'uhoont'ah hukw'una'a zeh dune ba nahoohyeh,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bulunah Jerusalem whut'en 'uhutni, “Ndunnah 'en tulih 'int'ah hituzilhghelh hukwa' huninzun? ");
INSERT INTO cafNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","'Et njan whunulh'en! Dune ts'iyannah tah usda 'ink'ez hubulh yálhtuk, 'et whunts'ih 'aw dune dachahidusnih. 'Aw whuz na'a cha'hoot'ah whutele ndunnah moodih, 'en t'ehonínzun tulih ndunnah 'en 'alha Christ 'int'ah? ");
INSERT INTO cafNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","'Et whunts'ih ndunnah 'en nts'ez de haínya t'ets'onínzun, 'et whunts'ih Christ whusaínya t'eh, nts'ez de hainya, 'aw 'ilhunuh whunts'ih t'ehonózin ghaít'ah,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","'Et 'aw 'et nyo luglez whucho dune hoodulh'eh hoh Sizi soo khunek ti be ndo búlhni, “Nuhwheni t'esunáhzun 'ink'ez nts'ez de haíya chah nt'eoonáhzun, 'aw sich'oh sughá ilah whusáya, 'et whunts'ih ndun whuz de há salh'a, 'en soo ts'ah'un 'en unli ho' 'int'ah, 'en 'aw nuhwheni t'enuzuhzun. ");
INSERT INTO cafNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","'Et 'en buts'u haíya 'et huwa t'enuszun 'ink'ez 'en whuz de ha sálh'a!” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","'Et hukwa hiyóolhchoot hukwa hét'en, 'et whunts'ih buts'un whudelts'ulh 'awhuz whuchasawhulhts'it, 'et huwa 'aw dachahíyilil. ");
INSERT INTO cafNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","'Et 'ilhuhowezdel hubutah lhanah 'en huba 'alha' yint'ah suli 'ink'ez 'uhutni, “Ndun Christ whusaínya t'eh, ndun yenus túlih huwa 'ét'en teh tuné'tet'en? 'Awundooh!” hutni. 'Et huwa 'en Christ 'int'ah huninzun. ");
INSERT INTO cafNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","'Et ndunnah 'ilhohuwezdel whuz na'a Sizi highu yalhtuk hoh Pharisee hubuduzts'ai, 'et Pharisee 'ink'ez náwhulnuk moodih, nélhghel whuz whéoobuhalh'a Sizi hiyóolhchoot ka. ");
INSERT INTO cafNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","'Et Sizi nt'ewhunínzun 'et huwa 'ilhuhowezdel 'en 'obúlhni, “Awhuz sáyaz tele 'et nuhwhulh 'utest'ilh, 'et 'ink'ez ndun whuz de ha sálh'a, 'en buts'un nátesdalh. ");
INSERT INTO cafNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nuhwheni skunúhta 'et whunts'ih 'aw nasóolhtelh ghaít'ah, 'ink'ez nts'e 'ust'ah 'aw nuhwheni whuz toohya ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","'Et Lizwif dich'oh 'ulhódutni, “Nts'e teyalh hoh 'utni? 'Aw nats'óolhtelh ghaít'ah néulhni. 'Udun yun k'ut whut'en, 'en butuz tulih teyalh, whuz Lizwif bulunah hahandel inle, 'ink'ez whuz tulih 'udun yun k'ut whut'en hubodutelh'eh? ");
INSERT INTO cafNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","'Ink'ez njan neúlhni inle, ‘Nuhwheni skunúhta 'et whunts'ih 'aw nasóolhtelh ghaít'ah, 'ink'ez nts'e tesdalh ts'ih 'aw nuhwheni whuz toohya ghaít'ah,’ 'et daja ni hoh 'utni?” hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","'Aw 'et nuhwhújeh cho whutah, 'et 'udek'elh'az dzin, 'et dzin degha nus hooncha. 'Et dzin 'et Sizi hubutah síyin 'ink'ez soo khunekti be hubulh yálhtuk, “Ndan ta'óosde suts'un hutóodelh 'ink'ez tahóotnai! ");
INSERT INTO cafNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ndunnah si huba 'alha' 'ust'ah, Yak'usda bughunek 'uk'une'úsduguz ndutni, ‘Ndi too, 'i 'ilhuz wheni be ts'úkhutena, 'i 'en buts'u haíteli,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","'Et Sizi ndutni hoh Ndoni bugha hubulh yaílhtuk. Ndunnah 'en huba 'alha' yint'ah, 'en buyédutelts'ulh. 'Aw 'ahoh ilah. Sizi huba whudálhti hukw'elh'az t'eh, 'et nduwhútenilh. ");
INSERT INTO cafNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","'Et 'ilhuhowezdel hubutah ndi khunek hidánts'o hoh bulunah 'en 'uhutni, “Alha 'i be ndun 'en ndun ye nus whunilh'en bughu yatuk inle 'en 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","'Et bulunah chah 'uhutni, “Ndun 'en Christ 'en 'int'ah.” 'Et 'uyoon chah 'uhutni, “Awundooh! Ndunnah Christ 'en Galilee ts'ih ih hatéyalh?s ");
INSERT INTO cafNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Yak'usda bughunek 'uk'une'úsduguz, 'i ndutni, David buts'uh haídanzut, 'en keyah Bethlehem huwhútni, David bukeyah ínle, Christ whuz de ha téyalh,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","'Et huwa ndunnah 'ilhuhowezdel ndun 'en bugha lhch'a nehúdendel. ");
INSERT INTO cafNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bulunah, 'en hitélhcholh hukwa' huninzun, 'et whunts'ih dachahíyilil. ");
INSERT INTO cafNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","'Et ndunnah nélhghel ndunnah náwhulnuk moodih 'ink'ez Pharisee 'en whuz wheoobuhalh'a, 'en chah hi'et whuz hanahédel hoh hubuhoodulhkut, “Di ka whuz hachalhtel?” ");
INSERT INTO cafNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","'Et nélhghel 'uhutni, “Aw whutsuh da 'uyoon dune 'en ndun dune k'una'a yachalhtuk.” ");
INSERT INTO cafNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","'Et Pharisee 'uhutni, “Nuhwheni chah nuhwhunan'a ho ih 'udahni? ");
INSERT INTO cafNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nuwheni moodih k'us Pharisee wheni chah neba 'alha' 'int'ah nahzun ih? 'Awundooh! ");
INSERT INTO cafNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","'Et whunts'ih ndunnah 'ilhuhowezdel luglez whucho, 'et ts'iyawh di chahílah 'uhint'ah 'et huwa ndai Moses yuk'uné'uzguz 'i 'aw beni be t'éhinízun!” hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","'Et Nicodemus, 'en 'ilhuh 'úlh'ek Sizi yughu ninya inle, 'en chah Pharisee hubulh 'ilhunuh unli hoh dulh Pharisee hubúlhni, ");
INSERT INTO cafNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Wheni neba khunek butulhúhesde 'i 'utni, dune bughunek uzdánts'o 'ink'ez be 'ut'en uznalh'en t'eh, 'et hoh ih whunts'i buba nats'uhooyeh huba 'uhoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","'Et 'uhiyúlhni, “Nyun chah ih Galilee yun k'ut ts'ih haínya inli? Yak'usda bughunek 'uk'une'usduguz 'i soo cho nilh'en, 'et nts'e nyeni be t'éoonónzin, 'aw 'ilhunuh whunts'ih nus whunilh'en, 'en Galilee yun k'ut ts'ih haínya hoolah!” ");
INSERT INTO cafNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","'Et 'aw 'et ts'iyannah bukoo ts'ih whenáhidel. ");
INSERT INTO cafNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","'Et Sizi dzulhyaz Olive hiyulhni, 'i yúk'uz whinya. ");
INSERT INTO cafNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","'Et 'om bun dzin soo 'uda 'et Sizi luglez whucho ts'ih ninya. Ts'iyannah dune highu nindel. 'Et nátl'adeda 'ink'ez whehobudunilh'e. ");
INSERT INTO cafNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","'Et whubodulh'eh hoh ndunnah Moses be' dustl'us 'uk'ununa'úsduguz, 'ink'ez ndunnah Pharisee teh, ts'eke dune bulh lubeshi 'uleh hoh nahiyulhtus, 'en soo hubuniz 'et nihínilhti. ");
INSERT INTO cafNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","'Et Sizi 'uhiyúlhni, “Neoodulh'eh ndun ts'eke 'en dune bulh lubeshi 'uhuleh hoh soo 'et naoobuts'ulhútus. ");
INSERT INTO cafNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses khunek butulhúhesde, 'i butl'aidét'ai, 'i k'ut 'utni, ‘Ndunnah ndi lubeshi 'ulh'en, 'en tse be hubuts'uzoolhghelh,’ ni. Nyun do 'et hubugha daja dini?” ");
INSERT INTO cafNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","'Et 'aoonilhka hiyóolhzih hoonliyaz hukwa hik'eóote'alh 'et huka 'uhutni. 'Et Sizi nyuk 'uja 'ink'ez dulasgek be yun k'ut hukw'uné'uzguz. ");
INSERT INTO cafNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","'Et 'awhuz hiyoodulhkut hoh 'et njan nduk naja 'ink'ez ndo búlhni, “Nuhwheni nuhtah ndan lubeshi chait'ih, 'en 'udechoo tse be yuts'e 'oolh'is,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","'Et doo chah yuk na'uja 'ink'ez doo chah yun k'ut hukw'u ne'úzguz. ");
INSERT INTO cafNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","'Et ndunnah hodánts'o hoh neyuh ts'ih bugha t'ets'oninzun wheóobunelhtan hedich'oh chah lubeshi 'uhulh'en hínli, 'ink'ez 'ilhunuh hinli hoh hoonyan 'udetsah hedulh hoh ts'iyawh highu whenáhedel 'ink'ez ndun ts'eke dich'oh zeh Sizi yubut séyin suli. ");
INSERT INTO cafNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","'Et Sizi nduk na'uja hoh ndun ts'eke whusahiyálhti 'en 'aw huhoolah honilh'en hoh ndun ts'eke ndi yúlhni, “Ts'eke ndunnah nk'éhoo'ai nts'e whenahedel? 'Aw 'ilhunuh whunts'ih ih mba nahooyeh ghaít'ah?” ");
INSERT INTO cafNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","'Et ts'eke ndi yúlhni, “Awundooh, 'aw 'ilhunuh whunts'ih huhoolah.” 'Et Sizi ndi yúlhni, “Aw si chah mba nahoosyeh ghaít'ah. 'Et huwa naindalh 'ink'ez 'aw whulh nat whuts'un lubeshi cha'zolh'en!” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","'Et Sizi doo chah zeh hubulh yálhtuk hoh ndutni, “Si 'ust'ah yinkak whudune huba be whét'en 'i usdli. Ndan suneyalh, 'en 'aw tsahólhgus yuh hutooya ghaít'ah, k'us ndai be whét'en, 'i higha 'ilhuz wheni hukhutenalh, 'i hitet'i,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","'Et Pharisee 'uhiyúlhni, “Nyun ch'oh khuyanailtuk ho' dini, 'et huwa nghunek daja nedíni, 'i 'aw ts'ah'un cha'ít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","'Et Sizi ndo búlhni, “Nts'ez de háya nt'eoonúszun 'ink'ez nts'e tesyalh chah nt'eoonúszun, 'et huwa daja dusni, si sugha 'alha 'uhoont'ah, sich'oh 'údusni 'et whunts'ih. 'Et nts'ez de háya 'ink'ez nts'e tesyalh nuhwheni 'aw t'éoonuzáhzun. ");
INSERT INTO cafNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nuhwheni dune ba nahehyelh, si 'aw dune ba nahusyeh hoolah. ");
INSERT INTO cafNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","'Et si chah dune ba nahusyeh t'eh, ndi be náhusyeh, 'i ts'ah'un na'a 'int'ah. 'Aw sich'oh zeh ilah 'ust'ah, se'aBá, ndun whuz de sútelh'a, 'en sulh 'int'ah, 'et huwa ndi be dune ba náhesyelh, 'i ts'ah'un na'a zeh 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","'Et whuz na'a zeh 'uk'une'úsduguz ndi khunek nuhwhuba butulhúhesde, 'i k'ut hoh ndutni, ‘Nanah dune ndet huhon'en lhgha 'úhudeja hoh howu yahulhtuk t'eh, 'et ts'ah'un na'a 'uhoont'ah,’ ni hoh 'utni. ");
INSERT INTO cafNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Sich'oh duba yanalhútuk 'ink'ez se'aBá ndun whuz de sútelh'a, 'en chah suba yalhtuk,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","'Et hiyoodulhkut, “Nyu'aBá 'en nts'e usda?” 'Et Sizi ndo búlhni, “Si 'aw t'esunuzáhzun. 'Ink'ez se'aBá 'en chah 'aw t'echanuzáhzun. Si t'esunáhzun t'eh, se'aBá chah da t'enóohzin wule.” ");
INSERT INTO cafNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Sizi ndi khunek 'i be yailhtuk luglez whucho 'et dune hoodulh'eh da. Nts'e sooneya nahulhdzooh, 'et dune hoodulh'eh. 'Et 'awhuz huba whudezulh whuts'un whezulh, 'et huwa 'aw chahiyílhcholh. ");
INSERT INTO cafNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","'Et Sizi doo chah ndo búlhni, “Nuhghu tesyalh. Ska itéh'en, 'et whunts'ih nuhwhulubeshi bulh yatáhdlah, 'et huwa nts'e tesyalh ts'ih nuhwheni chah 'aw whuz toohdelh ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","'Et doo chah ndunnah Lizwif 'ulhódutni, “Ndun dich'oh tulih na'dutuzelghelh? 'Et huwa tulih 'utni, ‘Nts'e tesyalh ts'ih nuhwheni chah 'aw whuz toohdelh ghaít'ah,’ neúlhni?” ");
INSERT INTO cafNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","'Et ndo búlhni, “Nuhwheni ndi yun k'ut ts'ih hahdel, 'et si ndus de háya ho 'ust'ah. Nuhwheni ndi yun k'ut ts'ih hahdel, 'et si 'aw ndi yun k'ut ts'ih haízut ilah ho 'ust'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","'Et huwa ndun whudusni nuhwhulubeshi bulh yatáhdlah. 'Aw nuhwhuba 'alha' cha'hóot'ah si ndun 'ust'ah 'et hubugha, 'et huwa nuhwhulubeshi bulh yatáhdlah,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Ndan inli ho' nint'ah?” hiyúlhni. 'Et Sizi ndo búlhni, “Ndun whudusni soo 'udechoo whuts'un, 'en zeh 'ust'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'Awhuz tube lhat nuhwheni nuhwhugha howu yatélhtuk, 'ink'ez tube lhat nuhwheni nuhwhugha nahutesyeh whuz'ai, 'et whunts'ih ndun whuz de sútelh'a, 'en ts'ah'un na'a 'int'ah. Ndai buts'un whudásts'o, 'et whuz na'a zeh yinkak whudune hubulh yálhtuk,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","'Et whunts'ih 'aw hubeni be t'ehonízun, be'aBá, 'en bugha hubulh yálhtuk ho 'utni. ");
INSERT INTO cafNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","'Et Sizi ndo búlhni, “Yinkak dune ye' nduk dube dibe' dulhtsi t'eh, 'et t'eh soo ts'ah'un ndan usdli, 'en 'ust'ah t'éoonóhzin. 'Ink'ez 'aw sich'oh duba moodih nasdli ílah, se'aBá nts'e na'a whusodalh'i, 'i khunek zeh be yálhtuk, ");
INSERT INTO cafNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","'ink'ez ndun whuz de sútelh'a, 'en sulh 'int'ah. 'Ahoolhyez wheni se'aBá hóont'i zeh hoh ne'úst'en, 'et huwa 'aw such'a nachasdak,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","'Et ndi khunek 'i ye yaílhtuk hoh tube lhanah 'en huba 'alha' int'ah suli. ");
INSERT INTO cafNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","'Et ndunnah Lizwif, ndunnah Sizi yuba 'alha' 'int'ah, 'en ndo búlhni, “Sughunek 'óohtun 'ink'ez buk'úne 'uht'en t'eh, 'alha 'uhoont'ah hoh sugha hoodul'eh ahli. ");
INSERT INTO cafNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","'Ink'ez 'et huwa ndai khunek 'alha' 'int'ah 'i t'enoohzin, 'ink'ez 'i bugha 'aw 'o 'un 'ulhna wahle ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","'Et 'uhiyúlhni, “Nuwheni Abraham buts'u hatsánde 'uts'int'ah. 'Aw whutsuh da 'uyoon ba 'ulhna chats'ílah, 'ink'ez di ka ne'díni, nuhwhula na'dutetnih nedíni?” ");
INSERT INTO cafNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","'Et Sizi ndo búlhni, “Soo ts'ah'un na'a 'un whudúsni, ndunnah lubeshi 'uhulh'en, 'en lubeshi ba 'ulhna hinli. ");
INSERT INTO cafNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ndan koo 'ilhunuh 'ulhna unli, 'en 'aw 'ahoolhyez 'et 'usda ílah, 'et whunts'i ndan koo whudune buye', 'en 'ahoolhyez wheni, 'et 'usda. ");
INSERT INTO cafNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","'Et huwa ndun buYe' lubeshi ch'a nuhwhulanadutnih t'eh, 'et t'eh 'alha 'uhoont'ah 'aw 'o 'un 'ulhna wahle ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","T'ewhunúszun Abraham buts'u háhde ahli, 'et whunts'ih sughunek 'aw buka cha'nuhzun, 'et huwa sutuzelhghelh hukwa' nahzun. ");
INSERT INTO cafNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ndet se'aBá whusunelhtan, 'et 'un whudúsni. 'Et whunts'ih nuhwheni nuhwhé'abá 'unwhúlhni, hoh teh né'aht'en.” ");
INSERT INTO cafNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","'Et 'uhiyúlhni, “Abraham 'en buts'u hats'ánde ts'inli.” 'Et Sizi ndo búlhni, “Abraham 'en buts'ah hahde t'eh, 'en be 'ut'en k'ah zeh da ne'óoht'en. ");
INSERT INTO cafNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","'Et whunts'ih k'an si nts'oh teh 'unuhwhudúsni ts'ah'un na'a 'uhoont'ah hoh Yak'usda ts'un whudásts'o. 'Et whunts'ih nuhwheni sutuzelhghelh hukwa' nahzun. Njan 'et 'aw Abraham be 'ut'en k'ah ilah 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nuhwhe'abá be 'ut'en k'ah 'uwhulh'en.” 'Et doo chah 'uhiyúlhni, “Aw nuwheni nuwhusulhutsi ilah 'uts'int'ah! 'Ilhunuh ne'aBá 'en Yak'usda unli!” ");
INSERT INTO cafNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","'Et Sizi ndo búlhni, “Yak'usda 'en nuhwhu'aBá unli t'eh, si suk'eoohtsi' wule da, Yak'usda buts'un háya 'et huwa. 'Aw sich'oh sughá ilah whusáya, Yak'usda whusásalh'a. ");
INSERT INTO cafNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nts'e na'a nuhwulh yalhtuk, 'aw t'ewhunuzáhzun. Daja nuhwhudúsni 'aw sudóohts'o hukwa cha'nuzáhzun 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Netsudule 'en nuhwhé'abá 'int'ah. Ndet 'en hukwa' ninzun, hoh zeh ne'óoht'en hukwa' nahzun. Soo 'udechoo da whuts'un dune ughan unli. 'Aw ts'ah'un 'uhoont'ah hukwa cha'nizun, 'et huwa 'aw ndi khunek 'alha' 'int'ah 'i bughu yoolah. Nts'oh tula ne'duni tink'us na'a zeh yalhtuk, dich'oh duk'una'a 'utni. Ndi whuts'it 'en 'int'ah, 'ink'ez khunek whuts'it, 'i 'en zeh buts'u haídukat 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","'Et si khunek 'alha' 'int'ah 'aw 'i zeh be yalhtuk, 'et 'aw nuhwhuba 'alha' cha'duzusni. ");
INSERT INTO cafNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","'Aw nuhtah 'ilhunuh whunts'ih si lubeshi 'ulh'en 'úsdli doohtni ghaít'ah. 'Et huwa khunek 'alha' 'int'ah, 'i be 'un whudúsni 'ink'ez, di ka 'et nuhwhuba 'alha' cha'duzusnih? ");
INSERT INTO cafNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ndunnah Yak'usda budune unli, 'en zeh Yak'usda bughunek hidits'o. Nuhwheni 'aw Yak'usda budune cháhlah 'et huwa bughunek 'aw dóohts'o ghaít'ah,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","'Et Lizwif 'uhiyúlhni, “Alha 'i be nts'útni, nyun Samaria whut'en 'int'ah 'ink'ez ntsi' nudúdeh 'i nyudínda!” ");
INSERT INTO cafNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","'Et Sizi ndo búlhni, “Aw ntsi' nudúdeh 'i sughu hoolah hoh, se'aBá 'en délhti, 'et nuhwheni 'aw chasudulhti. ");
INSERT INTO cafNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","'Aw 'uyoon sudóolhti hukwa cha'núszun, 'et 'ilhunuh suba whudutélhti hoonli, 'en naheyelh chah 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Soo ts'ah'un na'a 'un whudúsni, ndan sughunek yoontun, 'en 'aw dahóotsah ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","'Et Lizwif 'uhiyúlhni, “K'an 'aw 'et t'éts'onínzun ntsi' nudúdeh 'i nyudínda! Abraham 'ink'ez nus whúnilh'en yahadla, 'et whunts'ih né'dini, ndunnah nghunek yoontun, 'aw dahóotsah ghaít'ah díni. ");
INSERT INTO cafNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ne'abá Abraham dazsai inle. 'En ba nus 'ilcho hoh ih 'udini? 'Et nus whúnilh'en, 'en chah yahadla. 'En chah huba nus 'ilcho ih? Soo ndan inli dini ho' dini?” ");
INSERT INTO cafNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","'Et Sizi ndo búlhni, “Sich'oh duba nadesduti t'eh, sich'oh be núscha 'ants'ih 'int'ah. 'Et whunts'ih nuhwheni ndun nuhYak'usda dáhni, 'en si se'aBá 'int'ah, 'ink'ez 'en sudélhti. ");
INSERT INTO cafNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","'Et nuhwheni 'aw t'echanáhzil, 'et si t'enuszun. 'Aw si t'enuzuszun dusni t'eh, 'et nuhwheni nuhk'una'a whahts'it usdli ho' dutesnilh. 'Et whunts'i ndun soo t'enuszun 'ink'ez bughunek 'ahoolhyez wheni buk'úne 'ust'en. ");
INSERT INTO cafNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nuhwhé'abá Abraham tube hóont'i whe suts'ó dezulh, 'et whute'ilh. 'Aw 'et whunalh'en 'ink'ez tube whunálhnik.” ");
INSERT INTO cafNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","'Et Lizwif 'uhiyúlhni, “Nilh'en cha'hoont'ah teh ne'dini! 'Awhuz skwunlai lanezi (50) nyeyus k'ut ilah, 'ink'ez 'udini Abraham 'uda in'en dini!” ");
INSERT INTO cafNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","'Et Sizi ndo búlhni, “Soo ts'ah'un na'a 'un whudúsni, Abraham whuteleh whutsuh da, 'et 'uda si usdli ho 'ust'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","'Et ndo búlhni hoh, ts'iyawh tse hiyeni dézgooh, 'i be whusa be' hínalh'uz 'ink'ez hituzelhghelh 'et hukwa. 'Et Sizi hubuch'a untelhú'i 'ink'ez soo hubutah 'et lhunásja hoh luglez whucho 'et tinánja. ");
INSERT INTO cafNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","'Et Sizi uyalh hoh, dune whuzdli da whuts'un chawhés'en yutélh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","'Et yugha hoodul'eh hiyoodulhkut, “Whuneoodilh'eh ndun dune, ndan simba bulubeshi yugha 'úja chawhés'en hoh whuzdli? Dich'oh k'us be'abá k'us be'ama hubulubeshi k'elha tulih 'uja?” ");
INSERT INTO cafNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","'Et Sizi ndo búlhni, “Aw dich'oh bulubeshi bugha, k'us be'abá k'us be'ama hubulubeshi hubugha ilah chawhés'en unli. Yak'usda be 'ut'en k'ah bughá t'ewhunoodzeh, 'et huwa 'uja chawhés'en hoh whuzdli. ");
INSERT INTO cafNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","'Awhuz dzenis whét'en hoh, ndun whuz de sútelh'a, 'en hube 'ut'en oolh'en huba 'uhoont'ah. 'Ulh'ek whusawhutélts'ulh 'ink'ez tsahólhgus yuh suli t'eh, 'aw dune 'oot'en ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","'Awhuz ndi yun k'ut sída hoh, ndi yun k'ut whudune huba be whét'en 'i usdli.” ");
INSERT INTO cafNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","'Et ndúdeja hukw'elh'az yun 'úntezno, buzek too, 'i be whutl'us inla, 'ink'ez ndun dune chawhés'en yuna yé yulhlho, ");
INSERT INTO cafNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","'ink'ez ndi yúlhni, “Nyooz too dez'ai Siloam ts'ih inyalh 'ink'ez ni'nildeh.” 'Et ndi khunek Siloam ni, 'et whél'a, ni ho 'utni. 'Et huwa whuz whinya, ni'nelde, 'ink'ez whunilh'en hoh whusanája. ");
INSERT INTO cafNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","'Et ndun hinat whut'i 'ink'ez 'uyoon chah, ndunnah chawhés'en hoh hinalh'en da, 'en 'ulhódutni, “Ndun 'en da hoh úsda 'ink'ez hubuts'udatso inle, 'en ih 'int'ah?” ");
INSERT INTO cafNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bulunah 'uhutni, “A, 'en 'int'ah.” 'Et bulunah chah 'uhutni, “Awundooh, 'ants'ih yunduwhút'en 'int'ah.” 'Et ndun chawhés'en inle obúlhni, “A, si 'ust'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","'Et 'uhiyúlhni, “Daínja hoh ho'en suli?” ");
INSERT INTO cafNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","'Et ndo búlhni, “Ilhunuh dune, Sizi hiyulhni, 'en whutl'us 'ínla, suna k'ut yé sulhlho, 'ink'ez 'usulhni, ‘Ta dez'ai ts'ih, Siloam huwhútni, whuz inyalh 'ink'ez ni'nildeh.’ Whuz lhgha diya 'ink'ez nine'lhúde hoh whes'en súli.” ");
INSERT INTO cafNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Et doo chah hiyoodulhkut, “Ndun dune, nts'e 'ut'en?” “Aw t'éoonuzúszun,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","'Et ndun chawhés'en inle, Pharisee bughu hinílhti. ");
INSERT INTO cafNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Njan dzin ndun dune Sizi whutl'us 'ínla 'ink'ez whes'en nayulhtsi, 'et nats'ulyis dzin 'uyínla. ");
INSERT INTO cafNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","'Et doo chah zeh Pharisee hiyoodulhkut, “Dáhoont'ah huwa ho'en suli?” 'Et ndo búlhni, “Ndun dune whutl'us 'ínla, suna k'ut yé whulhlho, hukw'elh'az ni'nelhude, 'ink'ez whes'en sili.” ");
INSERT INTO cafNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","'Et ndunnah Pharisee bulunah 'uhutni, “Ndun dune bugha yailhtuk, 'en 'aw Yak'usda buts'u haínya ilah 'int'ah. 'Aw nats'ulyis dzin hukw'u nucha'ust'en 'et huwa.” 'Et 'uyoon chah 'uhutni, “Nts'e na'a 'uwhutét'ilh, 'aw lubeshi 'ulh'en, 'en huwa 'ét'en túne' óot'en ghaít'ah!” 'Et hubugha lhch'a nihudendel. ");
INSERT INTO cafNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","'Et doo chah zeh ndun chawhés'en inle 'uhiyúlhni, “Hó'en nyúlhtsi, 'et huwa 'en bugha daja dini?” “Alha nus whunilh'en 'int'ah,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","'Et whunts'ih Lizwif moodih 'aw hububa 'alha' cha'hóot'ah, chawhés'en inle hoh whuzdli 'ink'ez k'an 'et whe'en, 'et huwa be'abá 'ink'ez be'ama 'anih hubúdani, ");
INSERT INTO cafNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","'ink'ez hubuhútni, “Ndun 'en nuhye' 'int'ah 'ink'ez whuzdli whuts'un chawhés'en nedúhni, 'ink'ez nts'e na'a k'an whe'en?” ");
INSERT INTO cafNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","'Et be'abá 'ink'ez be'ama 'uhutni, “T'ets'onízun ndun 'en neye' 'int'ah 'ink'ez whuzdli whuts'un chawhés'en inle. ");
INSERT INTO cafNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","'Ink'ez ndet huwa k'an whe'en, 'ink'ez ndun whe'en yulhtsi, 'aw t'éts'onízun. 'Aw 'uski chailah ho' 'int'ah, oodilhkut da. Dich'oh ts'ah'un na'a 'unwhudóoni.” ");
INSERT INTO cafNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","'Et be'abá 'ink'ez be'ama t'ehonínzun Lizwif moodih 'uda lhgha 'úhudeja ndunnah Sizi Christ 'int'ah, 'uyoon hudáni t'eh, luglez 'et whuch'a tinabunteyolh. 'Et huwa ndun dune be'abá 'ink'ez be'ama Lizwif moodih hube hunuljut. ");
INSERT INTO cafNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Njan hunuljut, 'et huwa 'uhutni, “Aw 'uski chah ilah ho' 'int'ah, 'en huboodilhkut daja,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","'Et doo chah zeh whulh nat ndun dune chawhés'en inle, “Anih,” hiyúlhni, 'ink'ez 'uhutni, “Njan daínja Yak'usda 'en buba whudélhti, 'aw ndun dune 'en ílah, t'ets'onínzun lubeshi 'ulh'en 'int'ah 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","'Et ndo búlhni, “Lubeshi 'ulh'en tulih 'int'ah, 'aw t'éoonuzúszun. 'Et 'ilhuh nt'éoonúszun, chaoozes'en ínle, 'et k'an naitast'en.” ");
INSERT INTO cafNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","'Et doo chah zeh 'uhiyúlhni, “Danyín la inle? Nts'e na'a hó'en nyulhtsi?” ");
INSERT INTO cafNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","'Et ndo búlhni, “Uda ndun whúdusni 'et whunts'ih 'aw chasóozulhts'ai, di ka 'et doo chah 'un whudóosni hukwa' nahzun? Soo tuzélhts'ilh hukwa' nahzun ih? Nuhwheni chah ih bugha hodutelhu'eh tehleh hukwa' nahzun ih?” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","'Et soo hoontsi' tune' hiduni, “Nyun 'en yugha hoodul'eh inli! 'Et wheni Moses bulh 'út'en ts'inli! ");
INSERT INTO cafNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","T'éts'onínzun Yak'usda 'en Moses yulh yaílhtuk ínle. 'Et ndun 'en, 'aw nts'ez de hainya whunts'ih t'éts'onízun,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","'Et ndun dune chawhés'en inle ndo búlhni, “Ndun dune whes'en sulhtsi 'et whunts'ih nuhwheni 'aw t'éoonuzúhzun nts'ez de haíya duhni! Tube suba hooncha! ");
INSERT INTO cafNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","T'ets'onínzun Yak'usda 'aw lubeshi 'ulh'en chaboozílhts'ai. 'Et ndunnah Yak'usda ts'un téni' nilhzun, 'ink'ez buts'u húkwa' ninzun tune' 'út'en, 'en zeh huboozélhts'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Soo 'udechoo yinkak 'uhóolya whuts'un 'aw dune chawhés'en hoh whuzdli, 'en dune soo ná'yinla whucha'dilhts'o. ");
INSERT INTO cafNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ndun dune 'en 'aw Yak'usda buts'un ilah 'int'ah t'eh, 'aw hoonli whe ndóneh ghaít'ah,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","“Whuzinli da whuts'un nyun lubeshi 'ulh'en zeh inli! Ndun na'dunínzun hoh whuneoodolh'eh hukwa' dini?” hiyúlhni 'ink'ez 'az tináhinino. ");
INSERT INTO cafNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","'Et Sizi whulh údants'o hoh Lizwif ndun dune tináhinino, hukw'elh'az nayilhti, 'et ndi yúlhni, “Yak'usda buYe' bugha mba 'alha 'uhoont'ah ih?” ");
INSERT INTO cafNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","'Et dune 'utni, “Moodihti ndan ho' 'int'ah? Busúnilhtun 'et sih suba 'alha 'uhot'e.” ");
INSERT INTO cafNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","'Et Sizi ndi yúlhni, “Uda ah'en ho' 'int'ah, 'ink'ez 'en 'utni nyulh yálhtuk.” ");
INSERT INTO cafNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","'Et dune yubut nacháneti 'ink'ez, “SMoodihti, suba 'alha' 'int'ah!” yúlhni, 'ink'ez yuts'u teni' nalhzin. ");
INSERT INTO cafNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","'Et Sizi 'utni, “Ndi yun k'ut ts'un whusaíya 'et huwa yinkak dune huba nahooyeh ka. Whusaíya, 'et huwa chawhés'en 'en huwhe'en hutele. 'Et ndunnah whe'en, 'en chah chawhés'en hutéle.” ");
INSERT INTO cafNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","'Et bulunah Pharisee yugha hoodul'eh hidánts'o hoh, 'et 'uhiyúlhni, “Wheni chah chats'uwhes'en dini hoh ih 'udini?” ");
INSERT INTO cafNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","'Et Sizi ndo búlhni, “Chawhuzeh'en t'eh, nuhwheni 'aw lubeshi nuhwhuba hoolah. 'Et 'uduhni, ‘Nuwheni ts'uwhe'en,’ dahni, 'et huwa lubesh nuhwhuba hoonli.” ");
INSERT INTO cafNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","'Et Sizi ndo búlhni, “Soo ts'ah'un na'a 'un whudúsni, ndan sheep ba nanestl'oo 'aw dáti k'et dáchayal 'ink'ez 'ants'ih nanestl'oo tus telhget t'eh, 'en dune 'undunut'ih 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","'Et ndan dáti ts'ih dayih, 'en sheep ghunli 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","'En dáti ghunli yuba da'dututih. 'Et t'eh sheep buboozi be hubuka hunih t'eh, hidits'o huwa t'ehinínzun 'ink'ez 'az hiyuntulh'us. ");
INSERT INTO cafNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tinaóobulih hukw'elh'az, 'et hubutsuh teyih 'ink'ez sheep ts'iyawh hiyunelh'us, highunek t'ehinínzun 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","'Et 'ants'ih hoh neya, 'en 'aw hiyuntoolh'as ghaít'ah. 'Ants'ih hoh núya 'int'ah 'aw bughunek t'ehinízun 'et huwa hich'a nutsilhdelh,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","'Et Sizi ndi higha hódool'eh ka hubulh náwhulnuk, 'et whunts'ih daja ni hoh 'utni 'aw t'ehonízun. ");
INSERT INTO cafNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","'Et huwa doo chah zeh Sizi ndo búlhni, “Soo ts'ah'un na'a 'un whudúsni, Si susheep ba dáti usdli ho 'ust'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ndunnah sutsuh whusahándel, 'en 'undunut'ih 'uhint'ah, 'et huwa 'aw sheep chaboozílhts'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Si datí 'ust'ah. Ndunnah si sugha dahúnindel, 'en ts'iyawh hudutejih. Dahúnindel 'ink'ez whuz 'az whehándel t'eh, tl'o k'ut nahuhóote'alh. ");
INSERT INTO cafNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","'Undunut'ih, 'en 'uduntet'ih 'ink'ez dune tuzelhghelh 'ink'ez tinta óobutélhlilh 'et wheni dayih. 'Et si whusáya hoh 'ilhuz wheni hiye khúna 'i 'utet'ilh 'ink'ez ndi 'ilhuz hiye khúna, 'i hiyit'i t'eh, 'aw hoonli whe ndunoodzit ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Si nuszoo sheep ghusdli 'en 'ust'ah. Sheep ghunli unzoo, 'en ye khúna 'i dude'usheep ba yuladutetnih. ");
INSERT INTO cafNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","'Et lhuhul'a, 'en 'aw sheep ghunli ilah 'int'ah. 'Ants'ih sheep yughole ka 'ul'a. Sheep 'aw busheep ilah 'uhint'ah, 'et huwa yus whuz de úlgwulh yunilh'en t'eh, sheep hubula dutnih 'ink'ez whetsílhyih. 'Et yus bulunah huboogooh 'et 'onghun chah hich'a wheyálwus. ");
INSERT INTO cafNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ndan lhúhul'a, 'en 'ants'ih 'ul'a 'int'ah, 'et huwa sheep 'ants'ih hiba unli 'ink'ez didut bugho whetsílhyih. ");
INSERT INTO cafNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Si nuszoo sheep ghunli 'en 'ust'ah, 'et huwa ndunnah sudune t'ebunúszun 'ink'ez didut chah t'ésanínzun. ");
INSERT INTO cafNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","'Et whuz na'a zeh se'aBá 'en t'ésunínzun 'ink'ez si chah t'enuszun. 'Ink'ez se'usheep be khúsna 'i huba hubula dutesnih. ");
INSERT INTO cafNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","'Uyoo sheep chah 'i 'ust'i. Ndi tah, 'en chahoonli. 'Aw ndi tah ilah. 'En chah whusáboosdlelh huba 'uhoont'ah. Sughunek hidóots'o, 'ink'ez 'ilho 'ulh'us zeh hutele 'ink'ez 'ilhunuh zeh sheep ghunli hutéle. ");
INSERT INTO cafNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Se'usheep ba be khúsna 'i bula dutesnih 'et huwa be khúsna 'i doo chah naoolhúchoot. 'Et huwa se'aBá tube sk'entsi'. ");
INSERT INTO cafNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","'Aw be khúsna 'i dune sughu yóolhchoot hoolah. Sich'oh zeh huwa tés'alh. Ndi be khúsna 'i huwa tés'alh 'ink'ez naitélcholh, 'et sughá whunt'ai hoh 'ust'ah. Se'aBá 'en 'uja ndi khunek stl'aída'ai ndi 'ut'en 'oolh'en ka,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ndi khunek 'i bugha doo chah Lizwif dich'oh dutah lhch'a nínahudéndel. ");
INSERT INTO cafNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tube lhanah, 'en 'uhutni, “Ntsi' nudúdeh 'i yudínda! Whusnik ho' 'utni, di ka oozélhts'ai?” ");
INSERT INTO cafNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","'Et 'onghunnah chah 'uhutni, “Aw ntsi' nudúdeh 'i yughudínda, 'en bughunek ilah 'utni. Nts'e na'a ntsi' nudúdeh, 'i dune chawhés'en 'en chah whe'en yutelhtsilh?” ");
INSERT INTO cafNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","'Aw 'et khi suli. Jerusalem keyah 'et nowhújeh nihoní'ai. 'Et whunahulnih k'ahoondit nahuwhulhtsi huwhútni. ");
INSERT INTO cafNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","'Et luglez whucho bun 'un hayalbun buyah, 'et Solomon bubun 'un hayalbun buyah huwhútni, hoh whéghah Sizi uyalh, ");
INSERT INTO cafNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","'ink'ez Lizwif higha wézdel hoh hiyoodulhkut, “Dahooldzah 'et nech'a nontalh'i. 'Alha hoh Christ 'en 'int'ah t'eh, k'an 'et ts'ah'un na'a nedíni.” ");
INSERT INTO cafNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","'Et Sizi ndo búlhni, “Uda ndun whudúsni 'et whunts'ih 'aw nuhwhuba 'alha' cha'duzusnih. Ndi se'aBá boozi bugha 'ut'en 'ulh'en, 'i bugha si sugha chah t'éwhunóohzin huba 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","'Et whunts'ih nuhwheni 'un whudúsni hukw'un'a 'aw se'usheep ilah 'aht'ah. 'Et huwa ndi 'ut'en 'ulh'en 'i 'aw nuhwhuba 'alha' cha'ít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Si se'usheep t'ébunúszun. Sughunek hidits'o 'ink'ez nusáhunudelh. ");
INSERT INTO cafNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","'Ilhuz hiye khúna, 'i bugha iní'ai. 'Aw yachahutésdlah 'ink'ez 'aw dune sula k'éhaboolelh hoolah. ");
INSERT INTO cafNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Se'aBá, ndan sughá buninla, ts'iyannah sugha ndoh 'int'ah, 'ink'ez ndunnah sudune suli, 'en 'ilhuz sulh 'átet'ilh. 'Aw dune soo 'últus hoolah se'aBá yula k'éhanabutelelh wheni. ");
INSERT INTO cafNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Si 'ink'ez se'aBá bulh 'ilho zeh nidudli,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","'Et doo chah Lizwif tse hiye tuzelhghelh 'i hidílhchoot. ");
INSERT INTO cafNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","'Et Sizi ndo búlhni, “Se'aBá be 'ut'en k'ah hoonzoo lhat si sugha whunulh'en. 'Ink'ez k'us dant'i ka 'usutelhlilh tse be suzoolhghelh hukwa' nuhzun?” ");
INSERT INTO cafNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","'Et Lizwif 'uhiyúlhni, “Aw 'ut'en unzoo, 'i ka ilah tse be nts'utuzelhghelh! Nyun 'ants'ih hoh dune inli 'ink'ez Yak'usda ch'a yaílhtuk. Nyunch'oh Yak'usda na'dudil'i, 'et hukwa tse be nts'útuzelhghelh.” ");
INSERT INTO cafNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","'Et Sizi ndo búlhni, “Soo cho whunalhúnih hoh Yak'usda bughunek k'une'úsduguz 'i nuhtlaida'ai hoh ndutni, ‘Nuhwheni yak'usda ahli?’ ");
INSERT INTO cafNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","T'éts'onínzun 'aw Yak'usda bughunek 'uk'une'úsduguz, 'i k'uyooyis ghaít'ah, 'ink'ez ndunnah Yak'usda bughunek bughi delts'ut, 'en yak'usda hubulhni. ");
INSERT INTO cafNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","'Et Yak'usda buYe' usdli 'un whudúsni, 'et huwa Yak'usda ch'a yalhtuk dahni hoh sk'ehóoh'aih. Se'aBá 'en 'udun nésunilhti hoh ndi yun k'ut ts'ih sutelh'a. ");
INSERT INTO cafNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Se'aBá be 'ut'en cha'zúlh'en t'eh, whute, nuhwhuba 'alha' cha'úst'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","'Et whunts'ih se'aBá be 'ut'en 'ulh'en t'eh, si nuhwhuba 'alha' cha'ust'ah, 'et whunts'ih ndi 'ut'en 'ulh'en, 'i bugha nuhwhuba 'alha 'uhot'e. 'I bugha nuhwheni be t'éwhunóhzin 'ink'ez nuhwhuba 'alha 'uhót'e se'aBá 'en syudínda 'ink'ez si chah buyudúsda,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","'Et doo chah zeh hiyóolhchoot hukwa 'uhuja hoh Sizi butáhanája 'ink'ez hubula k'ah hanaja. ");
INSERT INTO cafNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jordan took'oh nyaz ts'ih ndet da John 'udechoo dune too be 'ulh'en inle, whuz whenaja 'ink'ez 'et inda. ");
INSERT INTO cafNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Lhanah dune highu nindel 'ink'ez 'ulhódutni, “John 'aw huwa 'ét'en teh nucha'it'il, 'et whunts'ih ndun dune 'en bugha daja dani, ts'ah'un 'udani.” ");
INSERT INTO cafNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","'Ink'ez nyoh 'et tube lhanah huba 'álha' yint'ah suli. ");
INSERT INTO cafNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","'Ilhunuh dune Lazarus hiyúlhni, keyah whuyaz Bethany huwhútni, 'et whut'en. 'En nduda suli. Bulhtuskah nanah Mary 'ink'ez Martha bulh hizih whut'i. ");
INSERT INTO cafNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ndun Mary 'en 'uja ínle neMoodihti khe 'i be yuke 'ink'ez butsigha be yuna'alhde ínle. 'En bulhutsin Lazarus 'en nduda. ");
INSERT INTO cafNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bulhtuskah 'en Sizi khunek hits'ó tl'aidá'ai, “NeMoodihti ndun dune buk'entsi', 'en nduda,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","'Et Sizi hoozélhts'ai hoh 'utni, “Aw ndi dada 'ilhuz ye daóotsah ghaít'ah. Njan nduda bugha, 'et hoh Yak'usda buba whudélhti, 'ink'ez 'i bugha Yak'usda buYe', 'en chah ba whudélhti.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","'Et Lazarus nduda Sizi whulh 'udúzts'ai hoh Martha, bulhtus chah, 'ink'ez Lazarus chah tube hubuk'entsi' 'et whunts'ih whut'i 'et, nat dzin, 'et naná'el'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nat dzin 'et whut'í hukw'elh'az 'et yugha hoodul'eh 'et ndo búlhni, “Doo chah Judea yun k'ut ts'ih uztoodelh,” ni. ");
INSERT INTO cafNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","'Et yugha hoodul'eh 'uhiyúlhni, “Rabbi, k'an 'ahoh Lizwif tse be nyotúzelhghelh hukwa' huninzun 'ink'ez di ka whuz natandalh hukwa' ninzun?” ");
INSERT INTO cafNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","'Et Sizi ndo búlhni, “Et 'ilhudzin 'et lanezi 'o 'at nat (12) hukwe'hunít'oh 'uhoont'ah. Ndan dzenis neya, 'en 'aw dughun tooghalh ghaít'ah. Ndi yun k'ut be whét'en, 'i be honílh'en 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","'Et whunts'ih ndunnah 'ulh'ek nuya t'eh, 'en dughun teghulh, 'aw be whét'en 'i bu'et 'int'ah 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","'Et ndo búlhni hukw'elh'az 'et 'utni doo chah, “Ndunnah buk'ets'intsi' Lazarus nanésti 'et whunts'ih buts'u tésyalh 'ink'ez ts'enatelhdzulh.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","'Et yugha hoodul'eh 'uhiyúlhni, “NeMoodihti Lazarus nanesti t'eh, 'et soo na'tetnilh ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","'Et Sizi njan dazsai, 'et howu yalhtuk hoh 'utni. Yugha hoodul'eh, 'en 'ants'ih nanesti 'ink'ez nalyis 'et howu yalhtuk hoh 'utni huninzun. ");
INSERT INTO cafNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","'Et Sizi soo ts'et gaih ndo búlhni, “Lazarus dazsai. ");
INSERT INTO cafNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","'Et nuhwheni nuhwhuba hoonúst'i 'aw 'et chásdah hoh 'uja. 'Et t'eh nuhwhuba 'alha 'oost'e. 'Et whunts'ih k'an 'aw 'et buts'uztoodelh.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","'Et Thomas, 'en 'ut'adánda hiyúlhni, ndunnah yugha hoodul'eh ndo búlhni, “Wa'ih! Bulh úztoodelh! Wheni chah sih, bulh yats'odlah!” ");
INSERT INTO cafNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sizi whuz whenya 'et nahoo'ai Lazarus whiyahiyalhti whuts'un dit (4) dzin inle. ");
INSERT INTO cafNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Njan keyah wheyaz Bethany huwhútni, 'et Jerusalem tube wheghah whuz'ai. Ts'éyalh hoh 'ilhuh (1) hukw'e hunit'oh bat'en 'uhooldzah 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tube wheghah whuz'ai, 'et huwa lhanah Lizwif highu nindel. Mary 'ink'ez Martha bulh hubulhutsin dazsai 'et hoh hinidoolhya ka 'et huwa highu nindel. ");
INSERT INTO cafNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","'Et Sizi whuz de úyalh Martha whulh úduzts'ai hoh yududezya. Mary 'en koo 'aw 'et usda. ");
INSERT INTO cafNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","'Et Martha Sizi ndi yúlhni, “SMoodihti, njan sinda inle t'eh, 'aw da sulhutsin dachatésa wule da. ");
INSERT INTO cafNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","'Et k'an whunts'ih, ndai Yak'usda buts'un kwa' dini, 'i ngha íte'alh, 'et t'éwhunúszun.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","'Et Sizi ndi yúlhni, “Nyulhutsin dinadóoja.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","'Et Martha ndi yúlhni, “T'éwhunúszun 'udek'elh'az dzin t'eh, ts'iyannah dinádutédalh, 'et t'eh 'en chah sih dinadóoja.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","'Et Sizi ndi yúlhni, “Si 'ust'ah dune ts'iyannah dinabudutésdlelh 'ink'ez 'ilhuz wheni hiye khúna 'i hubugha ités'alh. Ts'iyannah ndunnah huba 'alha' 'ust'ah, dahúzsai 'et whunts'ih hukhutenalh. ");
INSERT INTO cafNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","'Ink'ez ndunnah 'awhuz khuna 'ink'ez huba 'alha' 'ust'ah, 'aw dahóotsah ghaít'ah. 'Et mba 'alha 'uhoont'ah ih?” ");
INSERT INTO cafNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","'Et Martha ndi yúlhni, “A sMoodihti, suba 'alha 'uhoont'ah nyun Yak'usda buYe', Christ, ndun ndi yun k'etéyalh, 'en 'unint'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Njan 'et ndudáni hukw'elh'az 'et dulhtus Mary yughu nanja 'ink'ez whe'ízyaz 'uyúlhni, “Whuneodulh'eh whusaínya 'ink'ez nka 'oodulhkut.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Soo whudants'o ibulh didinya 'ink'ez yuts'un whenya. ");
INSERT INTO cafNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Sizi 'awhuz keyah wheyaz whuts'un úyalh hoh, ndet da Martha yududezya, 'et zeh 'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","'Et ndunnah Lizwif, hubutah hudélhts'i, hinidélhya wheni, Mary soo 'a ts'ih didinya 'ink'ez 'az whinya, hinilh'en 'et hiyuntezdel 'ink'ez 'ulhódutni, “Ts'un k'ut ts'ih tétso wheni whuz tezya hoh 'ut'en.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Sizi ndet da 'ut'en Mary whuz ninya. Soo yutelh'en ibulh yubut dugwútsi be nenínya 'ink'ez ndi yúlhni, “SMoodihti, njan 'unint'ah inle t'eh, 'aw da sulhutsin dachaítsal wule da.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","'Et Sizi yunilh'en utso, 'ink'ez Lizwif ndunnah hiyulh nudelh, 'en chah hutso hubunilh'en hoh, tube whuts'u desnih 'ink'ez buyégha hoh huba dzuh 'uhooja, ");
INSERT INTO cafNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","'ink'ez huboodulhkut, “Nts'e wheyalhti?” 'Et 'uhiyúlhni, “Anih, whunolh'en sih!” ");
INSERT INTO cafNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","'Et Sizi intse. ");
INSERT INTO cafNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Lizwif 'et 'ulhódutni, “Nulh'en ndulhcho 'i be yuk'entsi'!” ");
INSERT INTO cafNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","'Ink'ez bulunah 'uhutni, “Chawhés'en 'en whé'en yulhtsi ínle, 'aw ih ndun dune 'en chah datétsah whuch'a 'uyooleh ghaít'ah inle?” ");
INSERT INTO cafNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","'Et Sizi doo chah budzi yuh hoh buba dzuh 'uhooja, 'ink'ez ni suli hoh ts'un k'uz ninya. Njan ts'un k'ut 'et 'an tse whudá'de'ai 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","'Et Sizi ndo búlhni, “Ndi tse 'udun dutah'aih!” 'Et Martha dune dazsai bulhtus, 'en 'utni, “SMoodihti, ndun 'aw 'et dit (4) dzin 'adalhte 'ink'ez 'ulhtsun chah suli.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","'Et Sizi ndi yúlhni, “Aw ih chanyudúsnil inle, si sugha mba 'alha 'uhoont'ah t'eh, 'et t'eh Yak'usda yé dezti 'i tant'ilh?” ");
INSERT INTO cafNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","'Et nyoh ts'un k'ut dune wheyudílhti, tse 'udun hidutez'ai. 'Et Sizi nduk yutá'en 'ink'ez 'utni, “ABá sudánts'o 'et huwa suchanailya nyudúsni. ");
INSERT INTO cafNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","'Ink'ez t'éwhunúszun 'ahoolhyez wheni soozélhts'ai. 'Et whunts'ih njan 'udusni ndunnah 'ilhuhowezdel njan nahudelhúya, 'et huwa nyun whuz de sutélh'a 'alha 'uhot'e.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","'Et ndudéja hukw'elh'az soo khunekti be yatélhtuk, “Lazarus, ndez ínyalh!” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","'Et ndun dune dazsai tsa k'ez ts'ih hanája. Bula 'ink'ez buke chah 'awhuz naih be híyulhti, 'i be bugha' wésduduz, 'ink'ez dzezoh chah bunen 'awhuz bugha' wésduduz. “Buk'una'ah'uk 'ink'ez bula duhnih!” hubúlhni Sizi. ");
INSERT INTO cafNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ndunnah Lizwif, Mary yughu nindel inle, Sizi bunalh 'uja 'et huba 'alha' yint'ah suli. ");
INSERT INTO cafNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","'Et whunts'ih bulunah, 'en Pharisee ts'un whehandel 'ink'ez Sizi nts'oh tune' 'ust'en, 'et ndó ba dani. ");
INSERT INTO cafNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","'Et hukwa náwhulnuk bumoodih 'ink'ez Pharisee yahútelhtuk wheni 'ilhúnahuwesdel 'ink'ez 'uhutni, “Nts'e na'a dáztenilh? Ndun dune stabe lhat hooncha tune' 'út'en! ");
INSERT INTO cafNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Whute 'ut'en ts'ilh'i t'eh, ts'iyannah huba 'alha oot'e 'ink'ez Roman whusahándel hoh njan neluglez whucho 'ink'ez njan neyun k'ut chah negha hahóolhchoot, 'ink'ez ts'iyawh yats'óodelh.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","'Et 'ilhunuh hubutah Caiaphas hiyulhni, 'en 'et naooduzuk wheni náwhulnuk degha nus dezti unli ínle, 'en ndo búlhni, “Aw hoonli t'éwhunuzáhzun! ");
INSERT INTO cafNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","'Aw ih hubuk'ut chanunínulhzut, ts'iyannah ba 'ilhunuh dune zeh dazsai t'eh, 'et t'eh 'o nus soo whutét'ilh, 'et huwa 'aw neyun k'ut hoolah hole ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caiaphas dich'oh ilah ndi khunek yaka ni ntezut, 'et náwhulnuk degha nus dezti unli, 'et naooduzuk huba, 'et huwa whuz na'a nus whunilh'en Sizi 'en 'aw 'et nilhdukw hoh ts'iyannah Lizwif 'et yun k'ut whut'en ba datétsah. ");
INSERT INTO cafNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","'Et 'aw Lizwif hiyúlh dedowh, 'en huba zeh ilah. Ndunnah Yak'usda buzkeh hinli, nts'e hahandel, hoh whut'en, 'en huba chah. 'Et huwa ts'iyawh 'ilho ninaoobutélelh 'ink'ez 'ilho whut'en dune whutéleh. ");
INSERT INTO cafNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Soo 'et dzin whuts'un lhahóduleh hituzelhghelh wheni. ");
INSERT INTO cafNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","'Et wheghah ts'ih Sizi 'aw ts'et Lizwif hubutah nuchásyah. K'us yun k'ut 'aw dune chahóot'ih ts'ih whuzih whuz'ai, 'ilhun keyah Ephraim huwhútni, whuz whinya 'ink'ez yugha hoodul'eh tubulh 'et hudálts'i. ");
INSERT INTO cafNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","'Et doo chah Lizwif budzenis whuti ndet da Hubutus Lhuseya huwhútni, 'aw 'et wheghah whudezulh. 'Et huwa lhanah yun k'ut whut'en Lizwif hubuna'udoh hukw'un'a 'uhutenilh wheni keyah whuti Jerusalem ts'ih hunindel. ");
INSERT INTO cafNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Luglez whucho nahudelhuya 'ink'ez Sizi hika ités'en, 'et 'ulhódutni, “Daja nahzun? 'Aw tulih dzenis whuti wheni whusachásyak nahzun ih?” ");
INSERT INTO cafNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","'Et náwhulnuk bumoodih 'ink'ez Pharisee chah, 'uda dune tah khunek butl'aída'ai Sizi nts'e 'ut'en t'éhonínzun t'eh, 'ahoh ndobadooni, 'et t'eh 'aw 'et hitélhcholh. ");
INSERT INTO cafNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Dzenis whuti Hubutus Lhuseya huwhútni 'awhuz lhk'utat (6) dzin whuz'ai, 'et Sizi keyah wheyaz Bethany huwhútni, 'et 'uja Lazarus dazsai hoh yaidlah tah dinaidilhti inle, 'et Lazarus whut'i, whuz lhugha dínya. ");
INSERT INTO cafNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","'Et hulhgha na'tet'alh wheni hiba lhadúja. Martha 'en huba hukw'e'ile. 'Et Lazarus 'en chah hubulh na'ut'alh. ");
INSERT INTO cafNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","'Et Mary lubot dezbun bat'en, k'unuts'újul soo dezti, 'i khe, nard hiyulhni, 'i luboodai be whusayá'ai. 'I be Sizi yuke yulhlho 'ink'ez dutsigha be yuna'alhde. Bukoo ndulhcho hoh k'unuts'újul be soo whultsun suli. ");
INSERT INTO cafNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","'Et 'ilhunuh yugha hoodul'eh Judas Iscariot, Simon buye', 'en 'utenilh ye 'óotekulh, ");
INSERT INTO cafNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","'en 'utni, “Di ka ndi k'unuts'újul be chá'oohkulh 'ink'ez tel'ennah hubugha chanuzáhdzaih? Tube dezti ho' 'int'ah!” ni. ");
INSERT INTO cafNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","'Et 'aw tel'ennah huba dátni ilah huwa 'et ndutni. Undunut'ih unli 'ink'ez sooneya zus ndai be yúkat, 'i didut buba niyú'a, 'ink'ez hukwa' ninzun totsuk ndai be yúkat 'i 'ants'ih ye hainá'aih 'et huwa 'utni. ");
INSERT INTO cafNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","'Et Sizi 'utni, “Ndun ts'eke buts'áhachaoozah'ak, ndi wheyosuhutelhtelh dzin wheni, 'et yálh'a 'i 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tehul'en 'en 'ahoolhyez nohwhulh 'úhint'ah, 'et si 'ahoolhyez ilah nohwhulh 'útest'ilh.” ");
INSERT INTO cafNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","'Et Lizwif 'en Sizi 'et usda t'éhonanzin hoh, soo tube lhanah 'ilhuhowezdel, 'en whusahándel. 'Aw Sizi 'en bugha zeh ilah, Sizi, 'en Lazarus dinaidilhti inle, 'en huyuntelh'ilh ka. ");
INSERT INTO cafNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","'Et náwhulnuk bumoodih, 'en chah 'ilhuhowezdel Lazarus 'en chah hituzelhghelh 'et howu yahutelhtuk wheni. ");
INSERT INTO cafNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","'En bugha tube lhanah Lizwif hube 'ut'en k'ah whuch'a huzdel 'ink'ez Sizi 'en bugha huba 'alha' yint'ah suli. ");
INSERT INTO cafNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","'Et 'om bun dzin lhanah 'ilhuhowezdel, 'en dzenis whuti wheni Jerusalem ts'ih hunindel Sizi hiyúlh údants'o whuz de úyalh hutni 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","'Ul hidílhchoot 'ink'ez 'i hidelelh hoh hidudezdel 'ink'ez tube cho 'uhutni, “Yak'usda buba whudélhti! Ndun neMoodihti boozi bugha whusaínya, 'en degha nus hoonzoo hubugha whults'ut! 'En Israel buts'u hainde hubudayi cho 'int'ah!” ");
INSERT INTO cafNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","'Et Sizi yeztliyaz hiba whusaílhti 'ink'ez yuk'etl'adida. 'Et whundúlya hoh ndi 'uda bugha 'uk'une'úsduguz, 'i ndutni, ");
INSERT INTO cafNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Zion whut'en nuhdzi ulhtus ulhtsi! Nulh'en nuhwhubudayi cho yeztliyaz k'ut usda 'ink'ez nuhts'un úyalh!” ");
INSERT INTO cafNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","'Et 'udechoo hoh Sizi yugha hoodul'eh 'aw hubeni be t'éhonízun 'i bugha. 'Et yak'uz buba whudélti ts'ih, whenája hukw'elh'az 'et whunahelnik ndi bugha 'uk'une'úsduguz 'i 'et ndutni 'ink'ez 'et Jerusalem whuts'un úyalh hoh didut hoh chah hiba ne'úst'en. ");
INSERT INTO cafNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","'Et ndunnah 'ilhuhowezdel, ndunnah yugha hoodul'eh hoh Lazarus yuka hezya 'ink'ez ts'un k'ut yuhadla tah dinaidilhti hoh hinalh'en inle, 'et howu yawhehunilhtuk. ");
INSERT INTO cafNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","'Et ndunnah 'ilhuhowezdel hooncha túne' 'ust'en whulh 'úhudants'o 'et huwa 'uhuja hidudezdel. ");
INSERT INTO cafNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","'Et Pharisee dich'oh 'ulhódutni, “Nulh'en! 'Aw hoonliyaz cha'ts'uhóolil! Ndi yun k'ut dune, ts'iyawh huyúntezdel!” ");
INSERT INTO cafNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ndunnah dune Jerusalem ts'ih hutezdel, 'en hubutah, bulunah Greek cha 'uhut'en. Dzenis whuti 'et Yak'usda ts'un teni 'uhuntelhzilh, 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Philip, 'en keyah Bethsaida huwhútni, Galilee yun k'ut whuz'ai, 'et whut'en 'int'ah, 'en highu nindel 'ink'ez 'uhiyúlhni, “Wheni chah Sizi ts'ute'ilh hukwa 'uzninzun.” ");
INSERT INTO cafNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","'Et Philip, Andrew yughu ninya 'ink'ez 'uyúlhni, 'ink'ez Andrew Philip bulh Sizi nduhíyulhni. ");
INSERT INTO cafNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","'Et Sizi ndo búlhni, “Aw 'et yinkak dune ye' huba whudutélhti, 'et whusahónzut. ");
INSERT INTO cafNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Soo ts'ah'un 'un whudúsni, haniyeh 'i bumai 'aw yun k'ut nachanílts'ulh t'eh, dant'ah dich'oh 'et zeh ndutet'ilh. 'Et whunts'ih soo ndi yun k'ut ná'nest'ai t'eh, soo lhai bumai, 'i bugha hanantejeh. ");
INSERT INTO cafNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ndan dune ye khuna 'i yuk'entsi' t'eh, 'et t'eh ye khúna 'i tinta ité'alh ho' 'int'ah. 'Et whunts'ih ndan ndi yun k'ut ye khúna 'i buba 'ants'ih yint'ah t'eh, 'ilhuz wule wheni whuz na'a khutena. ");
INSERT INTO cafNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ndan suba né'tet'en hukwa' ninzun, 'en suhuntoodelh 'ink'ez nts'e 'ust'ah suba ne'ut'en chah 'et 'uhutet'ilh. 'Ink'ez ndan suba ne'ut'en unli, 'en se'aBá hubudutélhti. ");
INSERT INTO cafNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“K'an 'aw 'et tube suzul ba dzuh neooninzut, 'ink'ez daja doosni simba? Se'aBá njan sts'un whudelts'ulh whuch'a sula 'ineh doosni ih? 'Awundooh! Njan sts'un whudélts'ulh, 'et wheni whusáya. 'Ink'ez 'udusni, ");
INSERT INTO cafNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“ABá nyoozi 'o nus dezti ílhtsi.” 'Et yak'uz whuts'un khunek huduzts'ai, “Uda soozi dézti 'ink'ez doo chah zeh 'o nus dutésti,” whutni. ");
INSERT INTO cafNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bulunah 'ilhunahuwésdel, 'et nuhúdelhuya 'ink'ez hodánts'o. 'Et ndulhodútni, “Ditnik desni!” 'Et bulunah, “Lizas yulh yálhtuk hoh 'uwhutni,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","'Et Sizi ndo búlhni, “Ndi khunek duzáhts'ai, 'i 'aw si suba ilah 'uwhutni, nuhwheni nuhwhuba 'uwhutni. ");
INSERT INTO cafNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","K'an 'aw 'et yinkak whudune huba nahuteyeh 'ink'ez whutsuh da ndi yun k'ut humoodih, 'en 'ilhuz 'un hítenoh. ");
INSERT INTO cafNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","'Ink'ez ndi yun k'ut dibe' sadunintan t'eh, 'et sih soo ts'iyannah suts'un buntelhut'uk.” ");
INSERT INTO cafNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","'Et ndutni hoh nts'e na'a datétsah, 'et hobunelhtun ni hoh 'utni. ");
INSERT INTO cafNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","'Et 'ilhunahuwésdel 'uhiyulhni, “Moses yuk'une'úzguz inle, 'i bugha whulh 'úzdits'o ndun Christ 'en 'ilhuz khutena. 'Ink'ez dálhti 'udini yinkak dune ye' dibe na'hidóolhtsih huba 'uhoont'ah. Ndan ho' 'int'ah ndan yinkak dune ye'?” hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","'Et Sizi ndo búlhni, “Awhuz sayaz whuz'ai 'et ndi be whét'en 'i nohwhulh 'útet'ilh. 'Awhuz ndi be whét'en 'i nohwhulh 'int'ah hoh ahdulh zeh aht'en. 'Et nduht'en t'eh, 'aw tsahólhgus nuhk'éoodoolts'it ghaít'ah. Ndunnah tsahólhgus yuh hédulh 'aw nts'e hédulh t'éhonízun. ");
INSERT INTO cafNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dáhooldzah ndi be whét'en aht'i, 'ink'ez nuhwhuba 'alha' 'int'ah t'eh, 'et ndi be whét'en 'i buzkeh téhleh.” 'Et Sizi ndo bulhni hukw'elh'az, bughu whenája 'ink'ez buch'a ntelhu'i. ");
INSERT INTO cafNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tube 'ut'en uncha 'i bunalh 'alh'en 'et whunts'ih 'aw huba 'alha' cha'ít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","'Et nus whúnoolh'en Isaiah yuk'úne'uzguz, 'i bugha whuz na'a hoh teh ne'whust'en. Njan ndutni hoh 'uk'une'úzguz, “Moodihti ndi khunek whutl'azdá'ai, 'i ndan zeh buba 'alha yint'ah? NeMoodihti yé ulhtus 'i ndan ts'un ye nénelhtan?” ");
INSERT INTO cafNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","'Et huwa huba 'alha' cha'hóot'ah, Isaiah njan chah ndutni 'et huwa, ");
INSERT INTO cafNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yak'usda, 'en hubuna be chahuwhés'en hubulhtsi, 'ink'ez hubudzi chah duts'un yulhtsi. 'Et 'aw hubuna be honóolh'en ghaít'ah 'ink'ez hubudzi be 'aw t'ehonozin ghaít'ah. ‘Soo na'butésdlilh huba suts'un nahoolyeh ghaít'ah,’ ni Yak'usda.” ");
INSERT INTO cafNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","'Et Isaiah Yak'usda yé dezti 'i yunalh'en hoh 'et yugha ndutni inle. ");
INSERT INTO cafNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","'Et whunts'ih 'alha 'i be lhanah dune gha ndoh 'uhínt'ah, 'en Sizi huba 'alha yint'ah, 'et whunts'ih 'aw hudooni ghaít'ah. 'Et ndo deja t'eh, Pharisee Lizwif hubuluglez whuch'a 'ilhuz tibuhoneh 'et whehunuljut. ");
INSERT INTO cafNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","'En dune Yak'usda buch'a 'onus huba délhti. ");
INSERT INTO cafNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","'Et Sizi khunek ulhtus 'i be ndutni, “Ts'iyannah Ndunnah si huba 'alha' 'ust'ah, 'aw si sugha zeh ílah, ndun whuz de sútelh'a, 'en huba 'alha' yint'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","'Ink'ez ndunnah sunilh'en, 'en ndun whuz de sútelh'a, 'en hinilh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yinkak whudune ba be whét'en 'et hukwa ndi yun k'ut niníya. 'Et huwa ndunnah huba 'alha' 'ust'ah, 'aw tsahólhgus yuh hudoolts'i ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","'Ink'ez ndunnah sughunek hidits'o 'et whunts'ih huba 'alha' cha'yít'ah, 'aw huba nahoosyeh ghaít'ah. Ndi yun k'ut whudune huba nahutesyeh ílah ka whusáya, hubutelhyih ka whusáya. ");
INSERT INTO cafNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ndan sts'u desnih 'ink'ez 'aw sughunek chayílhcholh, 'ilhunuh 'en huba nahuteyeh. Ndi khunek be nohwhulh yalhtuk, 'i khunek zeh 'udek'elh'az dzin t'eh be nuhwhuba nahutedeh. ");
INSERT INTO cafNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","'Aw sich'oh zeh ilah yalhtuk. Se'aBá, ndun whuz de sútelh'a, 'en dich'oh khunek yutulhuhézya, 'i stl'aída'ai daja doosni hoh yaoolhtuk 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","'Ink'ez t'éwhunúszun ndi khunek yutulhúhezya, 'i bugha 'ilhuz be khútna 'i unli. 'Et huwa ndai sich'oh be yálhtuk, 'i nts'e na'a se'aBá sudáni, si chah whuz na'a zeh yalhtuk,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Dzenis whuti ndet hoh da Hubutus Lhuséya huwhútni, 'et whutsuh da Sizi 'aw 'et buts'uh whúdelts'ulh ba 'et newhúninzut t'éwhunínzun ndi yun k'ut howu teyalh 'ink'ez be'aBá ts'un natedalh. Ndi yun k'ut ndan budune 'en ts'iyawh hubuk'entsi'. Soo nts'e whuts'un hubuk'entsi'. ");
INSERT INTO cafNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","'Et hulhgha na'het'al hukw'elh'az 'uda netsudule Judas Iscariot Simon buye' Sizi ye 'ootékulh hukwa' nizun, yudzi yuh nioode'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","'Et Sizi t'éwhunínzun be'aBá ts'iyaitsuk k'úne' yool'en, 'et yugha óoni'ai. 'Ink'ez Yak'usda ts'un haínya 'ink'ez Yak'usda ts'un nátedalh 'et chah t'éwhunínzun. ");
INSERT INTO cafNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","'Et na'het'al 'ink'ez yoo 'az ye dune unli 'i 'udúnininla. Lusima ilhchoot hububut neínílhbal 'ink'ez yulh ts'ú delhú'oo. ");
INSERT INTO cafNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","'Aw 'et be la'ts'uldeh ts'ih too deínyul 'ink'ez yugha hoodul'eh hubuke toonagus 'ink'ez lusima yulh ts'ú delhú'oo, 'i be hubuke yuna'ulhdeh. ");
INSERT INTO cafNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","'Et Sizi Simon Peter yughu ninya hoh 'et Simon Peter ndi yúlhni, “SMoodihti, si chah suke tóona'tangus hoh ih 'int'en?” ");
INSERT INTO cafNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","'Et Sizi ndi yúlhni, “K'an dast'en 'aw nyeni be t'éwhunuzínzun, 'et k'at lih sih t'ewhunonzeh.” ");
INSERT INTO cafNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","'Et Peter ndi yúlhni, “Awundooh! 'Aw suke toonaóongus ghaít'ah!” 'Et Sizi ndi yúlhni, “Aw too nachainyúsgus t'eh, 'aw sulh 'ónt'e ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","'Et Simon Peter ndi yúlhni, “SMoodihti, 'aw suke zeh ilah, sula 'ink'ez sutsi chah too naóongus!” ");
INSERT INTO cafNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","'Et Sizi ndi yúlhni, “Ndan buna'éde, duke zeh toonaoogus huba' hoont'ah. 'Et whunts'ih ndulhcho hoh chadáhtsun hoh aht'ah. 'Et nuhwheni ts'iyawh nuhwhuna'dóodeh 'et whunts'ih nuhtah 'aw ts'iyawh ilah nuhwhuna'déde.” ");
INSERT INTO cafNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","'Et 'uda t'éwhunínzun ndun ye 'ootékulh 'et huwa 'utni, “Aw ts'iyawh ilah nuhwhuna'déde.” ");
INSERT INTO cafNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Hubuke toonagus 'aw 'et lhadúja hoh, ye dune unli 'i yé naja 'ink'ez hubutah nanátl'adeda, 'ink'ez ndo búlhni, “Dahooja, njan k'an danóhusdla, soo cho ih nuhwheni be t'éwhunúhzun? ");
INSERT INTO cafNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Whuneoodulh'eh 'ink'ez Moodihti sudúhni. 'Et 'alha duhni ho' duhni, si 'en 'ust'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","'Et si 'en 'ust'ah dune hodul'eh 'ink'ez Moodihti usdli hoh nuhke toonasíguz, 'et nuhwheni chah whuz na'a nuhwhuke lhuba toonaóohgus huba' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","K'an nuhwhunalh danóhwhusdla whuz na'a nuhwheni chah 'et ndusóolh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Soo ts'ah'un na'a 'un whudúsni, 'aw ustle, 'en bumoodih yugha ndoh cha'ít'ah. 'Et whuz na'a zeh khunek na'a 'aw ndan yughatélh'a yugha ndoh cha'ít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","'Et nuhwheni be t'éwhunáhzun t'eh daja nuhwhudúsni, 'ink'ez danwhúsdla, 'et nuhwheni chah whuz na'a 'aht'en t'eh, 'et tube hooteht'i. ");
INSERT INTO cafNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","'Aw soo ts'iyawh ilah nuhwhugha 'et ndudúsni. Ndan 'utaháoobála, 'en t'ébunúszun. 'En 'utaháoobála, 'et huwa Yak'usda bughunek 'i 'uk'une'úsduguz k'ut dawhútenilh 'et hubugha njan ndutni, ‘Ndan lhes sulh í'al, 'en sch'a nidenya hoh sazoolhghelh hukwa' ninzun.’ ");
INSERT INTO cafNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Njan 'et ndo whútenilh whutsuh 'et nuhwhudúsni. 'Et ndúhooja t'eh, 'et t'éwhunóhzin, 'et ndan usdli, 'en 'ust'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Soo ts'ah'un nuhwhudúsni ndan whuz na'a, 'en budzi yuh hoh hiyílhchoot t'eh, si chah suhílhchoot hoh 'uhoont'ah. 'Et Ndan budzi yuh hoh sílhchoot, 'en ndun whuz de sútelh'a, 'en chah hiyílhchoot hoh 'uhoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","'Et Sizi njan ndudáni hukw'elh'az buyégha hoh buba dzuh 'uhooja. 'Et hubulh yátelhtuk 'ink'ez njan ndo búlhni, “Soo ts'ah'un nuhwhudúsni 'ilhunuh nuhtah 'en se'óotekulh.” ");
INSERT INTO cafNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","'Et yugha hoodul'eh ts'iyawh lhahunul'en k'us ndan simba 'uyúlhni 'aw nt'éhonízun. ");
INSERT INTO cafNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","'Et 'ilhunuh yugha hoodul'eh, Sizi k'us yúk'entsi' soo yuzih k'ut usda, ");
INSERT INTO cafNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","'et Simon Peter yuba núlhni hoh Sizi yoodolhkut, soo ndan simba ndi 'uyúlhni yughu yalhtuk 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","'Et ye chanenti 'ink'ez 'uyúlhni, “SMoodihti, ndan ho' 'int'ah?” ");
INSERT INTO cafNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","'Et Sizi ndi yúlhni, “Ndan ndi lhesyaz toonasí'ai 'ink'ez butl'ayá'ai, 'en 'int'ah.” 'Ink'ez lhesyaz toonayuz'ai 'ink'ez Judas Iscariot Simon buye', 'en yutl'ayá'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","'Et ndi lhesyaz yutl'ayá'ai hoh 'aw 'et Satan ye ghínya. 'Et Sizi ndi yúlhni, “Ndet da 'uwhutanlilh, soo 'ah lhaóodinleh!” ");
INSERT INTO cafNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","'Et 'onghunnah ts'iyawh ndun Sizi yugha hoodul'eh, 'en dant'i ka 'et ndi yulhni 'aw t'éhonízun. ");
INSERT INTO cafNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bulunah, 'en 'uhuninzun Judas 'en sooneya zus nuyá'a 'et huwa ndi dzenis whuti wheni buka nudzun, 'i yoket ka ndi yúlhni. K'us tel'en teh hoonliyaz hubugha 'óo'alh ka ndi yúlhni huninzun. ");
INSERT INTO cafNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","'Aw 'et lhesyaz yílhchoot ibulh, 'ahoh 'a tsih 'az whinya. 'Aw 'et tsahólhgus 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","'Az whénya hukw'elh'az 'et Sizi 'utni, “Aw 'et yinkak dune ye' buba whudélti 'ink'ez 'en bugha Yak'usda buba whudélti. ");
INSERT INTO cafNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","'En bugha Yak'usda buba whudélti t'eh, 'et Yak'usda dich'oh chah yinkak dune ye' soo 'ahoh 'et yuba whudutélhti. ");
INSERT INTO cafNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Suzkehkah 'aw sa ilah nohwhulh 'utést'ilh. Suteh'ilh hukwa' ntehzilh, 'et nts'eh na'a Lizwif hubudáni, whuz na'a nuhwheni chah nuhwhudúsni, nts'e tésyalh ts'ih 'aw nuhwheni chah sulh tóohdelh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","'Ilho khunek k'an 'i nuhwhutl'adá'ai 'ink'ez ndi 'i 'int'ah, ts'iyawh lhk'eoohdutsi'. Nts'e na'a si nuhk'esi', 'et whuz na'a zeh nuhwheni chah lhk'eoohdutsi'. ");
INSERT INTO cafNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ndi be lhk'ezdutsi' 'i nuhtah hoonli t'eh, 'i bugha sugha hoodul'eh ahli ts'iyannah t'éhonóozin.” ");
INSERT INTO cafNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","'Et Simon Peter yoodulhkut, “Moodihti, nts'e tanyalh?” 'Et Sizi ndi yúlhni, “Nts'e tesyalh ts'ih, 'aw k'an suntonya ghaít'ah, 'et whunts'ih nk'at lih, suntanyalh.” ");
INSERT INTO cafNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","'Et Peter ndi yúlhni, “Moodihti, 'et di ka k'an 'et 'aw nyun toosya ghaít'ah? Be khúsna, 'i whunts'ih nyun mba bula dutesnih!” ");
INSERT INTO cafNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","'Et Sizi ndi yúlhni, “Alha ih be khína, 'i suba bula dutatnih? Soo ts'ah'un na'a nyudúsni ligok dune 'uduténilh whutsuh, tat 'et t'ésunuzínzun dutanilh.” ");
INSERT INTO cafNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Khun teh nuhwhudzi ndóoda gunih. Yak'usda nuhwhuba 'alha 'int'ah, whuz na'a si chah nuhwhuba 'alha 'oost'e. ");
INSERT INTO cafNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Se'aBá bukeyah lhat koo whuzdla hoh 'uhoont'ah. 'Aw 'alha cha'hóot'ah t'eh, ndun whudóosni da. Whuz tesyalh nuhwhuba lhawhúdutesdleh wheni. ");
INSERT INTO cafNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Whuz lhadíya 'ink'ez nuhwhuba lhawhúdusdla t'eh, doo chah zeh whusanátesdalh 'ink'ez ts'iyawh nanwhutelhúchulh, ndet sída, 'et si sulh 'óoht'e. ");
INSERT INTO cafNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","'Ink'ez nts'e whéya ts'ih 'ink'ez nts'e ti whého'a 'et t'éwhunáhzun.” ");
INSERT INTO cafNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","'Et Thomas yoodulhkut hoh 'uyúlhni, “Moodihti, nts'e tanyalh 'aw nt'ets'onízun, 'ink'ez nts'e na'a whuz ti nt'éts'ontézin?” ");
INSERT INTO cafNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","'Et Sizi ndi yúlhni, “Si yak'uz ti, 'ink'ez khunek 'alha' 'int'ah 'i chah usdli. 'Ink'ez 'ilhuz wheni be ts'ukhuna, 'i chah 'usdli. 'Et huwa 'aw 'ilhunuh whunts'i se'aBá yuts'un tooya ghaít'ah, si sugha zeh 'et ndutenilh. ");
INSERT INTO cafNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Si t'ésunahzun inle t'eh, 'et se'aBá chah da t'enóohzin wule. 'Et k'an whúts'un, 'en 'aw 'et t'enahzun 'ink'ez ah'en chah áhja.” ");
INSERT INTO cafNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","'Et Philip ndi yúlhni, “Moodihti, nye'aBá bunenilhtun 'ink'ez uznoolh'en, 'aw 'et zeh hukwa' uzninzun.” ");
INSERT INTO cafNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","'Et Sizi ndi yúlhni, “Philip, lhe'hóoldzah nohwhulh 'úst'en, 'et 'awhuz ih t'ésunuzínzun? Ndan sunalh'en, 'en se'aBá chah hinalh'en. 'Ink'ez di ka, ‘Nye'aBá bunenilhtun,’ díni? ");
INSERT INTO cafNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Si se'aBá buyudúsda 'ink'ez se'aBá chah suyudínda. 'Et 'aw ih mba 'alha cha'hóot'ah? Khunek be nohwhulh yálhtuk 'i 'aw si sughunek ilah 'int'ah. Se'aBá ndun suyudínda, 'en ndi 'ut'en 'uyulh'en 'en 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nuhwhuba 'alha 'uhot'e si se'aBá buyudúsda 'ink'ez se'aBá 'en suyudínda. 'Et nuhwhuba 'alha cha'hóot'ah t'eh, ndi 'ut'en ndai 'ulya, 'i bugha si sugha nuhwhuba 'alha 'uhot'e. ");
INSERT INTO cafNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Soo ts'ah'un na'a ndan nuhwhudúsni, ndan buba 'alha 'ust'ah, 'en ndi 'ut'en ndai 'ulh'en, 'i, 'en chah 'uhitelh'ilh. 'Et si se'aBá buts'u nátesdalh 'et huwa si 'ut'en 'ulh'en, 'i, 'o nus 'ílhcho 'ut'en, 'i, 'uhiyoolh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","'Ink'ez ndai si soozi buka' dahni 'i hoh nuhwhuba né'test'en. 'Et huwa se'aBá 'en buYe' buba whudóolhti. ");
INSERT INTO cafNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ndai si soozi buka' dahni, 'et nuhwhuba 'uwhutesdlilh. ");
INSERT INTO cafNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nuhwheni sk'ehtsi' t'eh, ndai ndi khunek nuhtl'ádala, 'i buk'une' 'ooht'en. ");
INSERT INTO cafNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","'Ink'ez se'aBá 'en 'ilhuz wheni nuhLa'tet'ilh, 'en nuhwhugha itélhtelh, 'et buts'u hukwa' doosni. ");
INSERT INTO cafNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","'En Ndoni 'int'ah. Ndai khunek 'alha 'int'ah, 'i zeh buts'u haídults'it. Ndi yun k'ut whudune 'aw bubeni be t'ehinízun, 'et huwa 'aw huyóolhchoot ghaít'ah. 'Et nuhwheni t'enahzun, nohwhulh 'int'ah, 'ink'ez nuhyudutélts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","'Aw ts'unuh ahli li'aht'ah hoh nuhghu toosya ghaít'ah. Nuhts'u tóosya. ");
INSERT INTO cafNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dzuh sayaz inle, 'ink'ez yinkak whudune, chasátes'il, 'et whunts'ih nuhwheni suntelh'ilh. Si khusna 'et huwa nuhwheni chah khutehna. ");
INSERT INTO cafNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","'Et dzin t'eh, 'et t'ewhunohzin si se'aBá buyudúsda 'ink'ez se'aBá chah syudínda 'ink'ez 'o 'un nuhwheni chah nuhyudusda. ");
INSERT INTO cafNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ndan khunek 'et nidéla 'i yuk'úne' 'ut'en, 'en sk'entsi' 'uhint'ah. 'Ink'ez ndan sk'entsi', se'aBá chah buk'etesi', 'ink'ez si chah buk'etesi' 'ink'ez ndan usdli 'et t'ehonozin huboolhtsilh.” ");
INSERT INTO cafNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","'Et Judas, 'aw Judas Iscariot 'en ilah, 'en Sizi ndi yúlhni, “Moodihti, nts'e na'a 'uhoont'ah hoh nyun nyugha t'ets'onózin neba 'uwhutánlilh, 'et whunts'ih yinkak whudune, 'en nyun nyugha 'aw t'éhontészin dini?” ");
INSERT INTO cafNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","'Et Sizi ndi yúlhni, “Ndunnah sk'entsi', 'en sughunek yootetun. 'En se'aBá buk'etesi' 'ink'ez hubulh 'útet'ilh 'et huwa si bulh hubutah óduke. ");
INSERT INTO cafNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ndan sk'echaítsi', 'aw sughunek hik'unucha'ust'en. 'Ink'ez ndi khunek nuhwheni dahts'o, 'i 'aw sich'oh sughunek ilah 'int'ah. Se'aBá, whuz de sútelh'a, 'en bughunek 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","'Awhuz nuhtah 'ust'ah hoh njan 'et nuhwhudúsni. ");
INSERT INTO cafNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","'Et nuhLa'ut'en, 'en Ndoni 'int'ah, 'en si soozi bugha se'aBá 'en nuhts'ítelh'alh, ts'iyaintsuk whunohodutilh'eh 'ink'ez daja nuhwhudáni 'et soo cho whunalhúnih chah nuhwhutélhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Be nedzi dezghel, 'i nuhghu nenánust'ai. 'I sich'oh be sudzi dezghel, 'i nuhgha ní'ai. Ndi be nedzi dezghel nuhgha ní'ai, 'i 'aw yinkak whudune nuhgha húyu'aih, 'i 'aw yulh nduchaílt'ah ho' 'int'ah. Khun teh nuhdzi úndooda 'ink'ez noolhújut gunih! ");
INSERT INTO cafNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Sudahtso hoh 'un whudúsni. 'Aw 'et nuhghu tesyalh 'ink'ez nuhts'u tóosya. Se'aBá 'en sughanus dezti 'et huwa 'en buts'u nátesdalh, 'ink'ez sk'ehtsi' t'eh, k'an daja nuhwhudáni 'et huwa whunóolhnik. ");
INSERT INTO cafNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","'Ink'ez hoh teh ne'whutet'en, k'an nuhwhudáni. 'Et t'eh whusawhélts'ut t'eh, si sugha nuhwhuba 'alha 'uhot'e. ");
INSERT INTO cafNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","'Aw dzuh sayaz 'o 'un nohwhulh yaóolhtuk ghaít'ah. Ndi yun k'ut humoodih 'az de úyalh 'ink'ez si sugha 'aw ntsolyaz 'i whunts'ih buch'a chayílah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","'Aw 'et didahdelh, 'aw 'et njan huwuztoodelh, 'et huwa yinkak whudune t'éhonózin se'aBá buk'esi' 'ink'ez nts'oh tula khunek stl'aidan'ai, hoh tune'út'en ne'úst'en. ");
INSERT INTO cafNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Soo mai chun 'i 'ust'ah 'ink'ez se'aBá 'en mai k'et huwunli unli. ");
INSERT INTO cafNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ndunnah si sugha 'uzooschum unli, 'en 'aw bumai hoolah t'eh, 'et buts'u haídule, 'ink'ez ndunnah bumai lhai, 'en soo 'obulh'en bumai lhai wule ka. ");
INSERT INTO cafNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ndi khunek be nohwhulh yalhtuk, 'i be 'uda nuhwhuna'dede hoh 'aht'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nuhwheni syudoolhúts'i 'ink'ez si chah nuhyudóosda. 'Uzooschum mai chun bunída'a t'eh, bumai whutéleh. 'Et whuz na'a zeh nuhwheni nuhwhugha 'alha 'uhoont'ah. Si syudelhúts'i t'eh, 'et zeh nuhmai whutéleh. ");
INSERT INTO cafNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Si mai chun lí'nust'ah 'ink'ez nuhwheni 'uzooschum lí'aht'ah. Ndunnah si syudínda 'ink'ez si chah buyudúsda, 'en zeh bumai lhai téleh. 'Aw si su'et, 'aw hoonliyaz 'uhuhooleh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ndunnah si syudínda ilah, 'en 'uzooschum k'una'a k'uhídut'us 'ink'ez n'un hidutulht'oh, 'et dugi, 'et nduhínt'ah. 'Uzooschum ts'iyawh nahidulhdzooh 'ink'ez tsuh hidulhkuk 'ink'ez hidélhk'un. ");
INSERT INTO cafNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","'Et si suyudelhúts'i 'ink'ez sughunek nuhyuh dez'ai t'eh, 'et ndet hukwa' nahzun, 'et ts'iyawh nuhwhuba 'et nduwhuténilh. ");
INSERT INTO cafNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","'Ink'ez mai lhai nuhwhuts'u hánulhyeh t'eh, 'et huwa se'aBá 'en buba whudóolti. 'Et huwa sugha hoodul'eh wahle. ");
INSERT INTO cafNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Se'aBá 'en si sk'entsi'. 'Et whuz na'a zeh nuhk'esi', 'et huwa be nuhk'esi' 'i bulh zeh 'ooht'e. ");
INSERT INTO cafNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Se'aBá nts'e na'a suba lhuhézya buk'úne' zust'en 'ink'ez yé sk'entsi', 'i chah bulh 'utést'e. 'Et whuz na'a zeh khunek nuhtl'adála 'i buk'úne' 'aht'en t'eh, 'et huwa be nuhwhuk'esi', 'i bulh 'óoht'e. ");
INSERT INTO cafNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","K'an njan nuwhudúsni, 'et be hóonust'i, 'i be hoonáht'i t'eh, 'et hoonáht'i k'et 'aw 'o 'un 'óoht'e ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ndi sughunek nuhtl'adá'ai 'i ndutni, 'ilho ahli hoh nts'e na'a nuhk'esi', whuz na'a zeh lhk'eoohdutsi'. ");
INSERT INTO cafNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","'Ilhunuh dune yuk'entsi' buk'uz dazsai t'eh, 'aw 'o 'un ye búk'eoots'i' hoolah. ");
INSERT INTO cafNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","'Ink'ez khunek nuhtl'adá'ai 'i buk'úne 'aht'en t'eh, 'et nuhwheni sk'entsi' ahli. ");
INSERT INTO cafNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","'Aw 'o 'un sunane'uht'en chanuwhuduzúsnih. Hubunane'hut'en 'en bumoodih nts'oh tune' 'ut'en, 'aw t'éhonízun. Si nts'oh tula se'aBá bugha whudáts'o, 'et soo ts'iyawh whún whunelhtan, 'et huwa sk'ehtsi' nuhwhudúsni. ");
INSERT INTO cafNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","'Aw nuhwheni 'utahachásulhtel. Si lhtahánhola toohdelh 'ink'ez mai hanóolhyeh 'ink'ez nuhmai 'ilhuz wheni 'óot'e, 'et huwka 'et ninwhunila. 'Et huwa se'aBá ndai si soozi bugha buts'un hukwa' dahni, 'i si nuhgha íyoo'alh. ");
INSERT INTO cafNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","K'an nuhwhudúsni, ts'iyawh lhk'eoohdutsi'. ");
INSERT INTO cafNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ndi yun k'ut whudune nuhts'u hudutnik t'eh, whunalhunih nuhwheni nuhts'o dutetnik whutsuh, 'et 'uda si sts'u hudutnik inle. ");
INSERT INTO cafNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","'En buluh ahli t'ah, 'et da nuhk'ehootsi' wule t'eh, nuhwheni chah hubutah aht'ah 'et huwa. 'Et whunts'ih nuhwheni 'utáhanhóla, 'ink'ez 'aw 'o 'un bulah cháhlah, 'et huwa yinkak whudune nuhts'u hudutnik. ");
INSERT INTO cafNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","'Et huwa daja nuhwhudusni whunalhunih, 'aw hubunane'hut'en, 'en dumoodih gha ndoh cha'ít'ah. Si dzuh nusúhulhdzut t'eh, nuhwheni chah dzuh nunóhotelhdzut. 'Et sughunek hik'úne' 'ust'en t'eh, nuhwheni nuhghunek chah hik'úne' oot'en sih. ");
INSERT INTO cafNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","'Et nuhwheni sudune ahli, 'et huwa hoh teh ne'nohuhoolh'en, ndun whuz de sútelh'a, 'aw t'éhinizun 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","'Aw si whusáchasyal 'ink'ez hubulh yáchalhtih t'eh, lubeshi 'ulh'en hinli 'aw hukwa t'éhonózin ghaít'ah. 'Et k'an whuts'un hubulubeshi 'aw nuhínoolh'i hoolah. ");
INSERT INTO cafNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ndunnah sts'u dutnik, se'aBá 'en chah hits'u dutnik hoh 'uhint'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ndi 'ut'en 'ulh'en 'i 'aw 'uyoon cha'yulh'en, 'i bunalh cha'whuslel t'eh, 'et t'eh lubeshi 'ulh'en hinli 'aw da t'ehonózin. 'Et k'an 'ut'en 'ulh'en, 'i hinalh'en, 'et huwa si 'ink'ez se'aBá bulh nets'u hudutnik. ");
INSERT INTO cafNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","'Ink'ez ndi Yak'usda bughunek buba 'uk'une'úsduguz 'et ndutni, ‘'Aw hoonliyaz huwa ilah sts'u hudutnik.’ Daja ni k'an 'aw 'et ne'whust'en. ");
INSERT INTO cafNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","'Et whunts'ih nuhLa'ut'en, Ndoni, ndai be 'alha 'uhoont'ah 'i buts'u haídelts'ut, 'en 'int'ah, se'aBá buts'un 'en nuhts'un telh'alh, 'en whusainya t'eh, si sugha ts'iyawh whun whunóolhtun, se'aBá yuts'u haínya 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","'Ink'ez nuhwheni chah si sugha 'uyoon whúbuntelhtun, soo 'udechoo da whuts'un sulh 'aht'en 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","'Et Sizi 'o 'un ndo búlhni, “Nuhwhuba 'alha' hoont'ah doo ka si whuladoohtnih, 'et 'un whudúsni. ");
INSERT INTO cafNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Luglez 'et chah tinan whuts'unooyoot. 'Aw 'et whuz de whudezulh, 'et t'eh ndunnah nuhteghan Yak'usda ba 'uhut'en huntezilh. ");
INSERT INTO cafNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Si 'ink'ez se'aBá bulh t'énhonízun 'et huwa ne'nohohoolh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","'Et 'uda 'un whudáni, 'aw 'et ne'nohohulh'en t'eh, 'et whunaoolhúnih. Nohwhulh 'ust'en inle 'et huwa 'aw nduchah nuhwhudusnil. ");
INSERT INTO cafNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","K'an ndun whuz de sútelh'a, 'en buts'un nátesdalh, 'et whunts'ih 'aw 'ilhunuh nuhtah nts'e tésyalh 'et hukwa chasuzoodúzulhkut. ");
INSERT INTO cafNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","'Et njan 'un whudúsni, 'et huwa nuhwhudzi tso be dézbun, ");
INSERT INTO cafNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","'et whunts'ih khunek 'alha' 'int'ah 'i 'ún whudusni, nuhghu natesdalh, 'et nuhwheni nuhwhuba whutézoo. 'Aw whenáchasdal t'eh, nuhLa'tet'ilh, 'en 'aw nuhts'un tooya ghaít'ah. Whenásja t'eh, 'et 'en nuhts'un télh'alh. ");
INSERT INTO cafNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","'Et whusaínya t'eh bubeni tah dez'ai 'i bugha yinkak whudune lubeshi 'uhulh'en hinli t'éhonózin. 'Ink'ez ndai ts'ah'un 'int'ah 'i 'ink'ez Yak'usda ye náhezya 'i chah 'i bugha t'éhonóozin. ");
INSERT INTO cafNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Si sugha 'aw huba 'alha cha'hóot'ah 'et huwa hubunalh t'ewhunoolhzeh lubeshi 'uhulh'en hinli. ");
INSERT INTO cafNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Se'aBá buts'un nátesdalh 'ink'ez 'aw 'o 'un sooh'en ghaít'ah. 'Et 'i bugha ndai ts'ah'un 'int'ah 'i Ndoni, 'en bubut'ewhunoolhzeh. ");
INSERT INTO cafNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ndi yun k'ut humoodih 'en 'uda buba nahezya, 'et huwa ndi be náhudeh 'i ndi yun k'ut whudune, Ndoni 'en whebunoolhtun, 'en chah whuz na'a zeh buba nahutedeh. ");
INSERT INTO cafNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","'Awhuz tube lhat nuhwhudutésnilh whuz'ai, 'et whunts'ih k'an 'aw whulh whuhyin, ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","'Et Ndoni, ndun khunek 'alha' 'int'ah 'i buts'u haídults'it, 'en nuhyudánde t'eh, 'en ndi khunek 'alha' 'int'ah, 'i nuhwheni tah nídoo'alh. 'Et ndi 'i be 'ut'en 'int'ah; 'aw dich'oh bughunek be ilah nohwhulh yátelhtuk, ndet whudánts'o, 'et zeh whunoh untelhtun, 'ink'ez nts'oh teh ne'whutet'en, 'et chah t'ewhunáhzun nuhwhutelhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Se'ut'en k'ah ts'iyawh whútalhchulh 'ink'ez whunóhuntelhtun, 'et si suba whudóolhti. ");
INSERT INTO cafNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ts'iyaitsuk ndai se'aBá be'ilhdzun yinli, 'i si se'ilhdzun 'int'ah. 'Et 'un whúdusni Ndoni 'en ndai se'ut'en k'ah unli, 'i ts'iyawh yutélhchulh 'ink'ez 'i yenewhuntelhtun. ");
INSERT INTO cafNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","'Aw 'et se'aBá buts'u natésdalh 'et huwa 'udusni dzuh sayaz whuts'un, 'aw sooh'en ghaít'ah. 'Et doo chah dzuh sayaz inle t'eh, 'et suteh'ilh.” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","'Et yugha hoodul'eh dich'oh chah lhahoodulkut, “Ndi khunek ye nelh yalhtuk 'i lhe'utni, ‘Se'aBá buts'u natésdalh,’ 'ink'ez, ‘Dzuh sayaz whuts'un, 'et 'aw sooh'en ghaít'ah. 'Et doo chah dzuh sayaz whuts'un, 'et suteh'ilh.’ 'I daja ni hoh 'utni?” ");
INSERT INTO cafNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","'Et 'o 'un chah 'uhutni, “Njan dzuh sayaz whuts'un ní, 'et daja ni hoh 'utni? Wheni 'aw t'ets'onízun.” ");
INSERT INTO cafNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","'Et Sizi hukwa huyoodutélhkut hukwa' huninzun, 'uda t'éwhunínzun 'et ndo búlhni, “Nuhwhudúsni dzuh sayaz whuts'un, 'et 'aw sooh'en ghaít'ah. 'Et doo chah dzuh sayaz inle t'eh, 'et suteh'ilh. 'Et ih nuhwhenich'oh nuhtah hukwa lhoodulhukut? ");
INSERT INTO cafNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Soo ts'ah'un na'a 'un whudúsni, tehtso 'ink'ez 'o 'un chah tube sk'enitehleh, 'et whunts'ih yinkak whudune hontélhnik. Nuhwheni tube tso tehleh, 'et whunts'ih nuhtso 'i bé hoonaht'i 'i tele. ");
INSERT INTO cafNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","'Et whuz na'a ts'eke buyaz whutéleh, 'en k'una'a 'et ndúhoont'ah. 'Aw 'et wheghah whudezulh whuch'a ní unli lhih. 'Et buzki whulih teh, yé ndida 'i yunaoodilnah, 'uski yinkak nenílhti 'et tube hóont'i. ");
INSERT INTO cafNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","'Et whuz na'a zeh nuhwheni k'an tso ahli, 'et whunts'ih nanwhutest'ilh 'ink'ez nuhdzi hóotet'i, 'ink'ez be hóonaht'i 'i 'aw nuhghu hayóolhchoot ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","'Et dzin t'eh, 'aw hoonliyaz suts'u ka' doohtni ghaít'ah. Soo ts'ah'un na'a 'un whudúsni, se'aBá si soozi bugha hoonliyaz buts'u hukwa' dahni t'eh, ndai buka' dahni, 'i nuhgha íte'alh. ");
INSERT INTO cafNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","K'an whuts'un si soozi bugha 'aw buts'o hukwa' dahni hoolah. 'Et se'aBá huboodulhkut, 'et nuhgha whútelts'ulh, 'ink'ez 'et be ts'uhoont'i teht'ilh. ");
INSERT INTO cafNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Whutsuh da khunek whe' hoont'ah hooyah be 'ún whudusni inle. 'Et whunts'ih whuz de whélts'ulh, khunek whe' hoont'ah hooyah be ilah 'udutésnilh. Se'aBá 'en bugha soo ts'et khunek 'i be nuhwhudutésnilh. ");
INSERT INTO cafNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","'Et neóodinzut t'eh, 'aw si ilah se'aBá nuhwhuba bóodolhkut nuhwhudusnih, nuhwhenich'oh si soozi bugha hóobudutelhkut. ");
INSERT INTO cafNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nuhwheni sk'ehtsi' 'et huwa se'aBá dich'oh nuhk'entsi', 'ink'ez Yak'usda ts'un haya 'et nuhwhuba 'alha 'uhoont'ah, 'et huwa nuhwheni nuhk'entsi'. ");
INSERT INTO cafNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Se'aBá 'en buts'u háya hoh ndi yun k'ut niníya. 'Aw 'et ndi yun k'ut whuch'a natesdalh 'ink'ez se'aBá 'en buts'u nátesdalh,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","'Et yugha hoodul'eh 'uhiyúlhni, “K'an 'aw 'et ts'et khunek be nelh yaílhtuk, 'aw khunek whe' hoont'ah hooyah be ilah 'udini. ");
INSERT INTO cafNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","K'an 'aw 'et t'ets'onínzun soo ts'iyaintsuk 'et t'éwhúnínzun 'et huwa 'aw 'o 'un nts'oodólhkut ghaít'ah. Daja nedáni, 'et huwa Yak'usda buts'un hainya neba 'alha 'uhoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","'Et Sizi ndo búlhni, “Soo ih nuhwhuba 'alha 'uhoont'ah? ");
INSERT INTO cafNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nulh'en whuz de whúdezulh 'aw 'et 'et níoodenzut, ndet 'ilhunah ahli hoh lhch'a dutelhuwus 'ink'ez nuhwhenich'oh nuhwhútk'una'a 'uteht'ilh. Si chah sich'oh úsdli hoh sughu téhdulh, 'et whunts'ih 'aw sich'oh ilah 'ust'ah, se'aBá 'en sulh 'int'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","K'an njan 'et hubugha ndi khunek 'i be nohwhulh yálhtuk, daja nuhwhudáni, 'et huwa nedzi be dezghel, 'i 'ooht'e. Ndi yun k'ut tube nuhwhé'huzoola, 'et whunts'ih hóht'ah, ndi yun k'ut humoodih 'ink'ez be 'ut'en k'ah chah, ts'iyawh buch'a' nulhde 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Sizi njan 'et ndudáni hukw'elh'az, nduk yak'uz yuta'en 'ink'ez 'utni, “ABá, 'aw 'et sts'o dezulh 'aw 'et whusawhélts'ut. NYe' buba whudélhti, 'et whuz na'a nYe' chah mba whudólhti. ");
INSERT INTO cafNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","'Et whuz na'a zeh 'et ndineh hoh yinkak whudune ts'iyawh hubugha ndoh oot'e, 'et hubugha óoni'ai, 'et ndunnah sughá buninla 'ilhuz wheni hiye khútenalh 'i hubugha ités'alh. ");
INSERT INTO cafNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","'Et ndez na'a ndi 'ilhuz wheni be khuténalh, nyun zeh ts'ah'un Yak'usda inli, 'ink'ez ndun whuz de haílh'a, Sizi Gri 'en 'int'ah, ndunnah soo hubeni be t'éhonoozeh, ndi 'ilhuz wheni be khuténalh 'et 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","'Ut'en sugha ní'ai 'i 'aw 'et lhadúsdla hoh ndi yun k'ut mba whudálhti. ");
INSERT INTO cafNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","'ABá, ndi yun k'ut 'uwhuténilh whutsuh da, ndai nyun bulh hoh da bé whúdalti, 'i be k'an doo chah zeh suba whudélhti. ");
INSERT INTO cafNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ndunnah ndi yun k'ut whudune hubutah sughá buninla, ts'iyannah nyun ye nehobonelhtan. Nyun hube'ílhdzun hinli hoh si sughá buninla 'ink'ez nghunek hik'úne' 'ust'en. ");
INSERT INTO cafNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ndai sugha nínla, 'i ts'iyawh nyun nts'u haínkat 'i 'int'ah. 'Et k'an bubeni be t'ehonínzun. ");
INSERT INTO cafNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ndai khunek 'en huba stl'aída'ai, 'i chah hubutl'aida'ai. Soo cho hiyílhchoot 'ink'ez hubeni be t'ehonínzun, 'et huwa nyun nts'u háya 'ink'ez nyun whuz de sútelh'a, 'et chah soo hubeni be t'ehonínzun 'ink'ez huba 'alha 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Huba tenadusdli. 'Aw ndi yun k'ut whudune, 'en ilah huba tenadusdli. Ndunnah sughá buninla, 'en zeh huba tenadusdli, nyun hube'ílhdzun hinli 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ndai si se'ílhdzun unli, 'i nyun nye'ílhdzun 'int'ah, 'ink'ez ndai nyun nye'ílhdzun unli, si se'ílhdzun 'int'ah. 'Ink'ez 'en hubugha 'aw 'et suba whudálti. ");
INSERT INTO cafNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","'Aw 'o 'un ndi yun k'ut sída ílah hoh nts'un usyalh, 'et whunts'ih ndunnah, 'en ndi yun k'ut 'uhint'ah. 'ABá, lubeshi bughoh hoolah 'int'ah, 'ink'ez ndunnah sughá buninla, nyoozi be ílhtus, 'i be huboontun, 'i be nyun si bulh 'ilho ídudli, whuz na'a didut chah 'ilho hoole. ");
INSERT INTO cafNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ndunnah sughá buninla, ndi yun k'ut 'awhuz hubulh 'úst'ah da, nyoozi be ílhtus, 'i be huboostun 'ink'ez hubughosdle. 'Et 'aw kwuncho yuh whuye', 'en ilah, 'et huwa nts'oh teh bugha 'uk'une'úsduguz inle, hoh teh whét'en. ");
INSERT INTO cafNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","K'an 'aw 'et nts'un téya. 'Et whunts'ih 'awhuz ndi yun k'ut sída hoh njan 'et howu yalhtuk, 'et soo ts'ah'un na'a ndai be whúnelhnik, 'i be hubudzi doobun. ");
INSERT INTO cafNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nghunek hubugha íde'ai 'ink'ez ndi yun k'ut whudune hubuts'u hudutnik. Nts'e na'a si 'aw ndi yun k'ut whudune hubulh 'ust'ah ilah, 'et whuz na'a 'en chah 'aw ndi yun k'ut whudune hubulh 'uhint'ah ilah. 'Et huwa ndi yun k'ut whudune hubuts'u hudutnik. ");
INSERT INTO cafNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","'Aw ndi yun k'ut whuch'a nabónlelh, 'et ilah nts'u húkwa' dusni, 'et whunts'ih ntsi', 'en ch'a soo cho hubughonle, 'et nts'u húkwa' dusni. ");
INSERT INTO cafNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nts'e na'a 'aw ndi yun k'ut whudune hubulh 'uhint'ah ilah, 'et whuz na'a si chah 'aw ndi yun k'ut whudune hubulh 'ust'ah ilah. ");
INSERT INTO cafNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Khunek 'alha' 'int'ah 'i nts'u hadélts'ut, 'i be nyunch'oh mba 'udun níbuninle. Nghunek 'i khunek 'alha 'int'ah 'i 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nts'e na'a nyun ndi yun k'ut whudune buts'un whesalh'a, 'et whuz na'a 'en ndi yun k'ut whudune buts'un whébalh'a. ");
INSERT INTO cafNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","'Ink'ez 'en hubugha si 'udun ni'dunlhuti, 'et whuz na'a 'en chah soo ts'ah'un na'a nyun mba 'udun nibuninla hoole. ");
INSERT INTO cafNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","'Aw ndunnah, 'en zeh ilah huba tenadusdli, ndunnah bughunek hubugha si sugha huba 'alha 'uwhutét'ilh, 'en chah huba tenadusdli. ");
INSERT INTO cafNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","'Et t'eh soo ts'iyannah 'ilho 'ilhunahuwésdel hoole. 'ABá nts'e na'a nyun syudínda, 'ink'ez si chah nyudúsda, 'et whuz na'a zeh neyuh 'uhoot'e. 'Et hoh yinkak whudune soo ts'ah'un na'a huba 'alha 'uhot'e nyun whuz de sútelh'a, 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","'Ink'ez ndi be dézti sugha ní'ai, 'i 'o 'un hubugha iní'ai. 'I be nyun si bulh da ídut'ah hoh 'ilho idúdli, whuz na'a zeh 'ilho hoole. ");
INSERT INTO cafNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Si 'en hubuyudúsda usdli 'ink'ez nyun si syudínda inli, 'et whuz na'a ndunnah 'ilho hinli hoh lhahádootneh. 'Et huwa yinkak whudune soo bubeni be t'éhonózin nyun whuz de sútelh'a. 'Ink'ez nts'e na'a sk'eintsi', whuz na'a 'en chah hubuk'eintsi'. ");
INSERT INTO cafNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ndi yun k'ut 'owhuténilh whutsuh da sk'eintsi', 'ink'ez bé dézti 'i sugha ní'ai ínle, 'et soo cho ndunnah huwhute'ilh hukwa' nuszun. 'Et huwa 'aBá ndunnah sughá buninla, k'an nts'e 'ust'ah 'et sulh 'úhoot'e hukwa' nuszun. ");
INSERT INTO cafNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","'ABá nyun ts'ah'un 'int'ah inli. 'Et yinkak whudune nyun ngha 'aw soo cho bubeni be t'echanyonízun. 'Et si t'ényunúszun 'ink'ez ndunnah sulh 'út'en chah t'éhonínzun nyun whuz de sútelh'a. ");
INSERT INTO cafNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","'Ink'ez nyun ngha soo cho bubeni be t'ehonózin hubuzílhtsi. 'Ink'ez nyun ngha 'o 'un chah soo cho t'éhontézin hubutélhtsilh. 'Et huwa ndai be sk'entsi' 'i hubuyuh doo'a, 'ink'ez si chah hubuyuh 'utesdalh.” ");
INSERT INTO cafNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Sizi ndi khunek be tenadedli hukw'elh'az, yugha hoodul'eh tubulh took'oh wheyaz Kedron huwhútni, nyan yahunindel. 'Et haniyeh k'et whuz'ai. 'Et yugha hoodul'eh tubulh 'et dahuníndel. ");
INSERT INTO cafNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","'Ink'ez Judas, ndun da ye 'ónket, 'en chah nyo t'éwhunínzun, Sizi yugha hoodul'eh tubulh lhat 'et 'ilhúnahodulh 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","'Et náwhulnuk bumoodih 'ink'ez Pharisee teh, ndunnah nehúghan 'ink'ez nélhghel chah, Judas dulh hubutelhudel. Too dízk'un teh, bé nukwunult'a, 'ink'ez soh cho teh, ts'iyawh hiyelelh. ");
INSERT INTO cafNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sizi nts'oh teh didut bugha ne'whutet'en, soo ts'iyawh t'éwhunínzun, 'et hubududezya 'ink'ez huboodulhkut, “Ndan kunúhta hoh 'aht'en?” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","'Et 'uhiyúlhni, “Sizi Nazareth whut'en, 'en kúznuta.” 'Et Sizi ndo búlhni, “Si 'en 'ust'ah.” 'Et Judas ye 'ónket, 'en chah hubutah súyin. ");
INSERT INTO cafNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ndet Sizi si 'en 'ust'ah hubúlhni hoh, ts'iyawh k'ah na'húja 'ink'ez yun k'ut nahánkat. ");
INSERT INTO cafNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","'Et doo chah zeh huboodulhkut, “Ndan kunúhta hoh 'aht'en?” 'Et 'uhutni, “Sizi Nazareth whut'en, 'en kúznuta.” ");
INSERT INTO cafNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","'Et Sizi ndo búlhni, “Uda ndun whudáni, si 'en 'ust'ah. 'Et si skunáhta t'eh, ndunnah, 'en nahutoodelh hubugha óonah'aih.” ");
INSERT INTO cafNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","'Et Sizi whutsuh da daja tenadedli ínle da, “Sughá buninla 'aw 'ilhunuh whunts'ih tinta chalhtel,” ni, 'et hoh teh whét'en 'et ndo búlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","'Et Simon Peter soh cho ut'i, déhayalhtsus, 'i be náwhulnuk degha nus dezti be 'ustl'en ye yoonilht'o hoh nalhnih ts'ih yudzo habe' yalht'o. 'En 'ustl'en boozi Malchus hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","'Et Sizi Peter ndi yúlhni, “Nyoo soh cho buzus be naíntih. 'Alha ilah lah ndi lubot 'aw chatuzésnil se'aBá stl'ayánkai 'i?” ");
INSERT INTO cafNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","'Et lhuhudúghan bumoodih 'ink'ez Lizwif nélhghel Sizi hiyílhchoot 'ink'ez hiyulhghel. ");
INSERT INTO cafNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Soo 'udechoo Annas 'en cho highu hinílhti. 'En Caiaphas 'et nawhuduzuk huba náwhulnuk degha nus dezti unli ínle, 'ink'ez Annas, 'en buzaz 'int'ah 'et. ");
INSERT INTO cafNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","'Et ndun Caiaphas 'en 'utni ínle, Lizwif hubugha 'utni hoh ndutni, 'ilhunuh dune 'en ts'iyannah dune ba dazsai t'eh, 'et whutézoo ni ínle. ");
INSERT INTO cafNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter 'ink'ez 'ilhunuh yugha hoodul'eh bulh Sizi hiyúntiz'az. Ndun 'ilhunuh yugha hoodul'eh, 'en náwhulnuk degha nus dezti t'einínzun, 'et 'en Sizi nanistl'oo bet yúlh daní'az. ");
INSERT INTO cafNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","'Et Peter ndati yoo 'az ts'ih siyin. 'Et ndun Sizi yugha hoodul'eh 'ilhunuh, ndun náwhulnuk degha nus dezti t'einínzun, 'en 'az tenínya 'ink'ez ndati huwunli yulh yaílhtuk hoh Peter chah daínilhti. ");
INSERT INTO cafNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","'Et ndun ts'ekeyaz, ndati huwunli, 'en Peter ndi yúlhni, “Nyun chah ih ndun dune yugha hoodul'eh 'ilhunuh inli?” 'Et Peter, “Awundooh,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","'Et bulunah 'ustl'en 'ink'ez nélhghel teh whúzk'uz 'et kwun húdulhk'an. Na'danildzilh hoh Peter 'en chah hubutah siyin 'ink'ez na'dunildzilh. ");
INSERT INTO cafNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","'Et ndun náwhulnuk degha nus dezti Sizi yugha hoodul'eh, 'ink'ez hubodulh'eh hukwa yoodulhkut. ");
INSERT INTO cafNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","'Et Sizi ndi yúlhni, “Soo ts'et gaih 'et ndi yun k'ut whudune hubulh yálhtuk. 'Ahoolhyez wheni luglez 'ink'ez luglez whucho nts'e Lizwif 'ilhúnahuwúdulh, 'et dune hóodulh'eh. 'Aw 'ilhuh whu'iz khunek be yachálhtih. ");
INSERT INTO cafNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","'Ink'ez di ka hukwa soodulhkut? Daja dusni ndunnah sudánts'o, 'en huboodulhkut, soo ts'ah'un t'éhonínzun daja dáni 'et.” ");
INSERT INTO cafNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","'Et Sizi njan ndutni hoh, 'ilhunuh nélhghel yuzih siyin, yunen ts'ih yunézkuk 'ink'ez ndi yúlhni, “Ndan na'dunínzun hoh 'udini? Ndun náwhulnuk degha nus dezti, 'en whuz na'a bulh yaílhtuk!” ");
INSERT INTO cafNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","'Et Sizi ndi yúlhni, “Dzuh k'una'a yatélhtuk t'eh, 'et nedini daja dáni. 'Et ts'ah'un na'a 'un dusni t'eh, di ka sunénkuk?” ");
INSERT INTO cafNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","'Et Annas 'awhuz Sizi lhughel hoh náwhulnuk degha nus dezti Caiaphas, 'en ts'un wheyalh'a. ");
INSERT INTO cafNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","'Et Peter 'awhuz tse ba siyin 'ink'ez na'dunildzilh, 'et 'uhiyúlhni, “Nyun chah tulih yugha hoodul'eh hubutah 'ilhunuh inli?” 'Et whuts'oodedlai 'ink'ez, “Awundooh,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","'Et náwhulnuk degha nus dezti be 'ustl'en 'ilhunuh, Peter ndun 'en yudzo haílht'az, 'en bunadun 'int'ah, 'en 'uyúlhni, “Nyun chah tulih haniyeh k'et bulh 'ínt'en hoh nyunalh'en ínle?” ");
INSERT INTO cafNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","'Et doo chah zeh Peter whuts'oodedlai hoh soo 'ahoh lígok dune 'udéja. ");
INSERT INTO cafNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","'Et Sizi, Caiaphas bukoo tínahinilhti, yun k'ut humoodih, Pilate hiyulhni 'en bukoo ts'ih whuz whehíyalhti. Bundada tube 'uda 'uhoont'ah 'ink'ez Lizwif 'aw bukoo dachahídulh. 'Et bukoo dahúnindel t'eh, 'en huba me hoonli. 'Et ndahúja t'eh, 'aw njan Hubutus Lhuseya nayút'et'alh, 'aw 'uhoo'alh ghaít'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","'Et Pilate 'az buts'un teninya 'ink'ez huboodulhkut, “Ndun dune ndet buk'éwhah'ai hoh 'aht'en?” ");
INSERT INTO cafNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","'Et 'uhiyúlhni, “Aw ndun dune tinta cha'ít'il t'eh, 'aw nts'uz toolhte ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","'Et Pilate ndo búlhni, “Ulhchoot 'ink'ez nuwhenich'oh nuhwhuba butulhúhesde 'i k'una'a buba nahahyeh!” 'Et ndunnah Lizwif 'uhiyulhni, “Wheni 'aw dune ts'uzoolhghelh negha chahóot'al.” ");
INSERT INTO cafNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Njan 'et nduhútni hoh Sizi nts'e na'a datétsah howu yailhtuk ínle, hoh teh ne'hóot'en ka' hutni. ");
INSERT INTO cafNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","'Et Pilate bukoo ts'ih whenája. Sizi yukunáwhulh'a 'ink'ez ndi yúlhni, “Nyun ih Lizwif hubudayi cho inli?” ");
INSERT INTO cafNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","'Et Sizi ndi yúlhni, “Nyunch'oh ih 'et ndunínzun, k'us 'uyoon si sugha nyádani?” ");
INSERT INTO cafNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","'Et Pilate 'uyúlhni, “Si ih Lizwif usdli ninzun? Nyunch'oh nyulh dune 'ink'ez náwhulnuk bumoodih, 'en stl'ányuhalhti! Ndet hoh tinta' nínt'en?” ");
INSERT INTO cafNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","'Et Sizi ndi yúlhni, “Nts'e hubudayi cho usdli 'et 'aw ndi yun k'ut ilah 'uhoont'ah. 'Et ndi yun k'ut hubudayi cho usdli t'eh, suhunedulh 'aw da Lizwif tl'achasúhoolhtel wule da. 'Awundooh, hubudayi cho usdli 'aw ndi yun k'ut ilah 'uhoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","'Et Pilate yoodulhkut, “Et t'eh hubudayi cho inli ho' 'int'ah!” 'Et Sizi ndi yúlhni, “Nyun 'alha 'udini hubudayi cho usdli. 'Et wheni whuzídli 'et huwa yinkak whudune soo cho hubeni be khunek 'alha 'int'ah 'i t'éhinoozeh 'et ndi yun k'ut neníya. Ndunnah khunek 'alha' 'int'ah 'i t'ehuninzun, daja dusni soo cho suhoozélhts'ai.” ");
INSERT INTO cafNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","'Et Pilate ndi yúlhni, “Di 'int'ah khunek 'alha' 'int'ah 'i?” 'Et ndudéja hukw'elh'az doo chah zeh Lizwif 'az buts'un tinanja 'ink'ez ndo búlhni, “Aw hoh tínta 'unt'en bugha nachawhus'al! ");
INSERT INTO cafNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","'Et nuhwheni nuwhe'út'en k'ah whuz'ai Nuhtus Lhuséya whutah 'ilhunuh dune buda'de'ai, 'en nuhwhuba bulanadustnih sih. Ndun Lizwif hubudayi cho, 'en ih bula nadutestnih hukwa' nahzun?” ");
INSERT INTO cafNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","'Et soo ts'iyawh sulya hulhtuk hoh 'uhutni, “Barabbas 'en bula nadintnih, 'aw ndun 'en ílah!” 'Et ndun Barabbas 'en 'undunut'ih 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","'Et hukw'elh'az Pilate Sizi hiyilhchoot 'ink'ez hiyolhtsus, ");
INSERT INTO cafNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","'ink'ez nehughan whus cho 'awh nahinelhwut, 'i hitsi nehída'ai, 'ink'ez nalhti dulk'un, 'i higha hiwelhnik, ");
INSERT INTO cafNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","'ink'ez 'uhiyulhni, “Lizwif hubudayi cho sa cho khona.” 'Ink'ez hinen ts'ih hiyoonukat. ");
INSERT INTO cafNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","'Et doo chah zeh Pilate 'az hubuts'un tinanja 'ink'ez ndo búlhni, “Nulh'en, ndun si 'aw hoh tínta 'unt'en bugha nachawhús'al, 'et nuhwhuts'un tinanílhti.” ");
INSERT INTO cafNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","'Et Sizi whus cho butsi niden'ai 'ink'ez nalhti dulk'un 'i naits'uz hoh tínanja Pilate yunilh'en 'et ndo búlhni, “Nulh'en, ndun dune!” ");
INSERT INTO cafNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Náwhulnuk bumoodih 'ink'ez nélhghel teh, hitelh'en ibulh, soo tube cho sulya hulhtuk 'ink'ez, “Lhdulalhgus yundunulht'ah! Lhdulalhgus yundunulht'ah!” hutni. 'Et Pilate ndo búlhni, “Nuhwhenich'oh ulhchoot 'ink'ez lhdulalhgus yundunulht'ah! Si 'aw hoh tínta 'unt'en bugha nachawhús'al 'et huwa!” ");
INSERT INTO cafNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","'Et Lizwif 'uhiyúlhni, “Nuwheni khunek neba butulhúhesde 'i ts'ít'i, 'i k'ut 'utni, daóotsah huba 'uhoont'ah. Lhe'utni Yak'usda buYe' 'ududulhútsi 'et huwa.” ");
INSERT INTO cafNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","'Et Pilate hubuduzts'ai 'et tube nelhújoot. ");
INSERT INTO cafNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","'Et doo chah zeh bukoo ts'ih danánja 'ink'ez Sizi yoodulhkut, “Nts'ez de haínya ho' nint'ah?” yúlhni. 'Et Sizi 'aw yulh yachailhtih. ");
INSERT INTO cafNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","'Et Pilate ndi yúlhni, “Aw ih sulh yaóolhtuk ghaít'ah? 'Aw ih t'éwhunuzínzun lhdulalhgus whunyunduntélht'us sughá whunt'ai k'us nla nadutestnih chah sughá whunt'ai?” ");
INSERT INTO cafNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","'Et Sizi ndi yúlhni, “Aw ndus de yak'uz whuts'un ngha chahóot'al t'eh, 'aw sugha ndoh 'ont'e ghaít'ah. 'Et huwa ndun ntl'asálhti, 'en bulubeshi nyun nlubeshi 'o nus 'ulcho.” ");
INSERT INTO cafNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","'Et Pilate yudúzts'ai hoh Sizi yúla nadootnih, 'et nahó'alh hukwa 'ét'en. 'Et Lizwif sulya hulhtuk 'ink'ez 'uhiyúlhni, “Ndun dune bula nadantnik t'ah, 'aw hubudayi cho Caesar buk'entsi' ilah 'int'ah! Ndan hubudayi cho na'dudil'i, 'en hubudayi cho Caesar yuch'a détni 'int'ah!” ");
INSERT INTO cafNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","'Et Pilate whuduzts'ai hoh kw'usuda yuk'usda hoh dune ba naheyelh, 'i k'enátl'adida. 'Et Sizi hububut neheyóolhtelh ndet Hebrew k'una'a Gabbatha huwhútni, 'i khunek 'utni, Tse Buk'ut Hoonzoo, 'i ni hoh 'utni. 'I k'ut kw'uts'uzda yulh'ai dune ba naheyelh wheni. ");
INSERT INTO cafNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ndet dzin da Hubutus Lhuséya, 'et dzin wheni lhahúdutneh, 6:00 bat'en 'uhúnet'oh, 'et Pilate Lizwif ndo búlhni, “Ndun nuhwhubudayi cho nulh'en!” ");
INSERT INTO cafNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","'Et whunts'ih sulya hulhtuk 'ink'ez 'uhutni, “Awh 'udini! Lhdulalhgus yundunilht'ah!” 'Et Pilate ndo búlhni, “Nuhwhubudayi cho 'en ih lhdulalhgus k'ehítelhtelh?” 'Et náwhulnuk bumoodih 'uhutni, “Hubudayi cho Caesar 'aw 'en zeh nehubudayi cho, 'aw 'uyoon nehubudayi cho hoolah!” ");
INSERT INTO cafNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","'Aw 'et hodánts'o Pilate Sizi lhdulalhgus k'ehúyolhtelh wheni butl'ayálhti. Hiyílhchoot 'ink'ez 'o 'un whenahíyalhti. ");
INSERT INTO cafNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","'Et dulhdulalhgus yudetilh hoh, nts'e da 'Utsin Ts'un huwhútni, whuz ninya. 'Et Hebrew k'una'a Golgotha huwhútni. ");
INSERT INTO cafNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","'Et lhdulalhgus k'ehíyilhti. 'Uyoon nanah chah hiyúlh 'ubihinla. 'Ilhunuh hoh 'ílhk'us ts'ih, 'et 'ilhunuh chah bugha naílhnih ts'ih, 'et Sizi 'en soo buniz 'uhiyínla. ");
INSERT INTO cafNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","'Et Pilate yuk'úne'uzguz, 'i butl'ayá'ai lhdulalhgus hiyundunólht'a ka. 'I k'ut 'utni, ");
INSERT INTO cafNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tube keyah wheghah 'uhiyinla hoh lhdulalhgus k'ehúyilhti 'et huwa, tube lhanah Lizwif ndi Pilate yuk'úne'úzguz 'i hik'eyailhtuk. 'Ink'ez ndi khunek tawh dédowh buk'una'a 'uk'une'úsduguz. Hebrew k'una'a, Greek k'una'a, 'ink'ez Latin k'una'a chah. ");
INSERT INTO cafNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","'Et huwa Lizwif náwhulnuk bumoodih Pilate hiyúlhni, “Aw ndan Lizwif hubudayi cho 'int'ah dini hoh ilah 'uk'e'inges. 'Ants'ih njan ndutni dini, si Lizwif hubudayi cho 'ust'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","'Et Pilate ndo búlhni, “Ndai hukw'une'zíguz, 'i nts'e na'a usdla, 'et whuz na'a 'oot'e ka usdla.” ");
INSERT INTO cafNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","'Et ndunnah nehughan, 'en Sizi lhdulalhgus k'ut whehídunilht'o hukw'elh'az, hinaih hiyílhchoot 'ink'ez dink'i hiyulhtsi hoh'ilhunah hinli hoh lhtahíyulya. 'Et ndi 'ude k'ut ye usda, 'i 'aw lhundunílkai ilah hoh 'ilho zeh unli hoh 'ulya. ");
INSERT INTO cafNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","'I bugha dich'oh 'ulhódutni, “Ndi 'i 'aw yachazdoolhch'oolh. 'Ants'ih buka 'áts'oolih, ndan simba buts'ítooneh.” 'Et nduhútni hoh Yak'usda bughunek soo buk'ah teh né'hoot'en 'et 'uhutni. Ndi khunek 'i ndutni inle, “Sunaih, 'i ts'iyawh lhtahuyulya. 'Et 'ude k'ut be sída, 'i hika 'aínlih.” 'Et soo ndunnah nehughan ne'húst'en. ");
INSERT INTO cafNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","'Et Sizi bulhdulalhgus soo beghah 'et 'ama siyin. 'Ama bulhtus chah, 'ink'ez Mary Clopas bu'at chah, 'ink'ez Mary Magdala whut'en chah. ");
INSERT INTO cafNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sizi 'ama yunilh'en 'ink'ez 'ilhunuh yugha hoodul'eh, soo degha nus yuk'entsi', 'en chah yughah siyin. 'Et Sizi 'ama ndi yúlhni, “Ts'eke, ndun nye' nilh'en.” ");
INSERT INTO cafNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","'Et ndun yugha hoodul'eh, 'en chah yunilh'en hoh 'uyúlhni, “Ndun nyu'ama nilh'en.” Soo 'et whuts'un ndun yugha hoodul'eh Sizi 'ama bukoo daínilhti. ");
INSERT INTO cafNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Njan hoh teh ne'whust'en hukw'elh'az Sizi t'éwhunínzun soo ts'iyaíntsuk lhaoodíja. 'Et didut bugha Yak'usda bughunek 'uk'une'úsduguz 'i daja ni, 'et ndúhoneh 'et huwa, “Ta'óosde,” ni. ");
INSERT INTO cafNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","'Et nyo 'oosa'yaz mai too ts'ulki' 'i 'et sú'ai. 'Et ndi hitabehiyalhnik 'i nyoo mai too huyé tóonahiyuz'ai 'ink'ez duchun hyssop hiyúlhni, 'i higha íwelh'oo, 'ink'ez hizek ts'ih dibe' hidunintan. ");
INSERT INTO cafNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","'Et ndi mai too ts'ulki' 'i yálhka 'ink'ez 'utni, “Aw 'et ts'iyaintsuk lhawhúdija.” Yuk ninent'ai 'ink'ez ye khúna 'i yula detnik. ");
INSERT INTO cafNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","'Et nahulyis dzin huba lhahúdutneh, 'ink'ez nats'ulyis dzin whudézti hoh 'uhoont'ah. Lizwif 'et dzin dune buyust'e 'aw lhdulalhgus k'ut hoolhte hukwa cha'hunízun, 'et huwa Pilate hiyoodulhkut bukechun k'unuhíyooyuz 'ink'ez buyust'e nanáhiyoolhtelh 'et hukwa. ");
INSERT INTO cafNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nehughan whuz lhghahudíndel hoh soo 'udechoo ndunnah nanah Sizi hiyulh lhdulalhgus k'ut sulhti, 'en choo bukechun k'unuhíyuzyuz. ");
INSERT INTO cafNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","'Et Sizi highu nindel hoh 'uda dazsai hinilh'en, 'et 'aw hikechun lhk'uchahayíyus. ");
INSERT INTO cafNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","'Et whunts'ih 'ilhunuh nehughan sohtuz be yuzih k'ut 'et yúzgwut. 'Ahoh 'uskai 'ink'ez tooyaz bulh, 'i buts'u hayéjul. ");
INSERT INTO cafNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","'Et ndun howu yalhtuk, soo 'alha whunalh'en hoh 'utni. 'Ink'ez daja ni soo dich'oh t'éwhunínzun hoh 'utni. 'Et huwa nuhwhuba 'alha 'uhot'e. ");
INSERT INTO cafNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","'Et whuz na'a hoh teh ne'whust'en. 'Et huwa ndai Yak'usda bughunek 'uk'une'úsduguz, 'i k'una'a lhawhúduja hoh ndutni, “Aw 'ilho buts'un 'i whunts'ih k'uchaítih,” ni. ");
INSERT INTO cafNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","'Et Yak'usda be dustl'us 'uk'une'úsduguz, 'i k'ut 'udun 'et chah 'utni, “Ndun huyúzgwut, hinoolh'en,” ni. ");
INSERT INTO cafNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","'Aw 'et hoh teh ne'whust'en hukw'elh'az 'et Joseph, Arimathea whut'en, Pilate yughu ninya 'ink'ez Sizi buyust'e yóolhchoot hukwa yoodulhkut. 'Et ndun Joseph 'en chah Sizi yugha hoodul'eh unli, 'et whunts'ih Lizwif hube nuljut 'et whu'iz Pilate 'aw 'et yugha óoni'ai Sizi buyust'e nayóolchoot 'ink'ez whusainya 'ink'ez buyust'e yílhchoot. ");
INSERT INTO cafNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","'Et Nicodemus, 'en chah yulh whúsain'az. 'En 'uja ínle soo 'udechoo Sizi hoh det'en hoh 'ilhe 'ulh'ek yughu ninya. Yoo sooltsun, 'i myrrh 'ink'ez aloes bulh lhtadilya 'i hoh 100 pounds bat'en 'uldaz, 'i whusayánla. ");
INSERT INTO cafNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","'Et Sizi buyust'e hiyílhchoot 'ink'ez Lizwif hube 'ut'en k'ah hukw'una'a, naih dezti lhuyul 'i hiyílhchoot 'ink'ez yoo sooltsun 'i lhtahidénla 'i hik'únuhíyuzdzai, 'ink'ez Sizi buyust'e higha híwezduz 'ahitelhtelh wheni. ");
INSERT INTO cafNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","'Et nyo ndet da lhdulalhgus ye hidunilht'o, 'et wheghah haniyeh k'et whuz'ai. 'Et k'ahoondit tse be tsa k'et 'aw whutsuh da dune whuyuchadílhti whuz'ai. ");
INSERT INTO cafNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","'Et tube nilhdukw whuz'ai 'et Sizi buyust'e 'et 'uhíyalhti, Lizwif 'et dzin lhahúdutneh 'uhoont'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dimos dzin whutanilhghel 'awhuz tsahólhgus hoh Mary Magdala whut'en, ts'un k'uz tezya. Whuz ninya hoh tse cho ts'un k'ut whudadune'ai, 'i 'udun dunez'ai hoh yutelh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","'Aw 'et Simon Peter 'ink'ez ndun 'ilhunuh Sizi yugha hoodul'eh k'us yúk'entsi', 'en bulh, hubughulgai 'ink'ez ndo búlhni, “NeMoodihti buyust'e hiyílhchoot. 'Uts'un whehíyalhti, 'ink'ez 'aw t'éts'onízun nts'e símba whehíyalhti.” ");
INSERT INTO cafNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","'Et Peter 'ink'ez ndun 'ilhunuh bulh ts'un k'uz ts'ih hutelhgai. ");
INSERT INTO cafNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Whuz lhgha hudilgai. 'Et ndun 'ilhunuh 'en Peter 'a bughanus lhgha dilgai 'et huwa 'udechoo ts'un k'uz lhgha dilgai. ");
INSERT INTO cafNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","'Aw 'et whuz núlhgai hoh, nyuk 'uja 'ink'ez whiyah whunalh'en. 'Et naih dezti 'i 'et sula yunalh'en, 'et whunts'ih 'aw dachaíyal. ");
INSERT INTO cafNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","'Et soo yúnelgih hoh Simon Peter whuz lhadílgai. 'En ts'un k'ut danínya 'ink'ez naih dezti 'i 'et sula yutelh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","'I ndi dzezoh butsigha waiwesdúduz inle, 'i 'aw naih dezti 'i butuh cha hóolah. Soo cho lhénintan 'ink'ez 'udun 'et sulhchooz. ");
INSERT INTO cafNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","'Et ndun 'ilhunuh yugha hoodul'eh 'udechoo ts'un k'uz lhadígai, 'en chah danínya. Soo cho whunalh'en 'ink'ez buba 'alha 'uhooja. ");
INSERT INTO cafNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","'Et 'awhuz soo cho hubeni be t'éhonízun daja ni ndi Yak'usda bughunek 'uk'une'úsduguz 'i k'ut, Sizi yaidla tah dinádutédalh 'et hubugha. ");
INSERT INTO cafNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","'Aw 'et Sizi yugha hoodul'eh bukoo ts'un whenáhet'az. ");
INSERT INTO cafNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","'Et whunts'ih Mary 'en ts'un k'ut 'aw 'et nétl'adinda. Yoo 'az ts'ih siyin 'ink'ez utso. 'Ink'ez utso hoh yuk 'int'ah 'ink'ez ni tse tuz whunilh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Khunyaz nanah lizas soo lhuyul 'i be húzke, njan hoh hubutelh'en. 'Ilhunuh 'en yutsi t'ah, 'et 'ilhunuh chah yuketl'ah ndet Sizi buyust'e ilhte, 'et huzke. ");
INSERT INTO cafNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","'Et hiyoodulhkut, “Ts'eke, di ka intso?” 'Et ndo búlhni, “SMoodihti 'uts'un whehíyalhti 'ink'ez nts'e simba 'ahíyalhti 'aw t'éwhunuzúszun.” ");
INSERT INTO cafNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","'Et ndudéja hukw'elh'az n'un nalhu'a hoh khunyaz Sizi 'et siyin hoh yutelh'en, 'et whunts'ih 'aw Sizi 'int'ah 'aw nachayóolts'ulh. ");
INSERT INTO cafNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","'Et Sizi ndi yúlhni, “Ts'eke, di ghintso? Ndan kunínta hoh 'int'en?” 'Et Mary 'uninzun haniyeh k'et huwunli tulih 'ut'en, 'ink'ez ndi yúlhni, “Nyun ílhchoot 'ink'ez 'uts'un wheílhti t'eh, nts'e ninílhti ndusudóni, 'et t'eh si naoolhúchoot.” ");
INSERT INTO cafNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","'Et Sizi, “Mary,” 'uyúlhni. 'Et Mary 'awh nadelhú'a 'ink'ez, “Rabboni!” yúlhni ('i khunek nehodulh'eh ni hoh 'utni). ");
INSERT INTO cafNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","'Et Sizi ndi yúlhni, “Aw njan soontun ilah. 'Awhuz nduk se'aBá buts'un náchatuzusdak. 'Et whunts'ih sulhutsinkah hubuts'un naíndalh 'ink'ez ndo budíni, nduk se'aBá buts'un nátesdalh. 'En nuhwheni chah nuhwhe'aBá. Si suYak'usda 'ink'ez nuhwheni chah nuhYak'usda unli.” ");
INSERT INTO cafNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","'Et Mary Magdala whut'en Sizi yugha hoodul'eh hubughu nanja 'ink'ez ndi khunek huba whusanaída'ai, 'ink'ez neMoodihti chah ya'en húbulhni. 'Et Sizi daja yudáni hukw'e hubulh náwhulnuk. ");
INSERT INTO cafNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","'Et dzin 'et Dimos dzin whutanilhghel whutah 'uhoont'ah, 'et hulhgha zeh, 'et yugha hoodul'eh 'ilhunahuwésdel. Dulh Lizwif hube hunuljut 'et ndati ts'iyawh dá'denla. Khunyaz Sizi hubutah siyin hitelh'en. 'Et ndo búlhni, “Soo cho nuhdzi dooghel.” ");
INSERT INTO cafNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","'Et ndúbudani hoh bula chah, 'ink'ez buyust'e k'ut chah hubunalh hahonla. 'Et yugha hoodul'eh tube cho huhóost'et hubuMoodihti hiya'en 'et. ");
INSERT INTO cafNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","'Et Sizi doo chah zeh ndo búlhni, “Soo cho nuhdzi dooghel. Nts'e na'a se'aBá whuz de sútelh'a, 'et whuz na'a si chah nuhwhutélh'alh.” ");
INSERT INTO cafNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","'Et ndudéja hukw'elh'az hubuk'uz tésjiz 'ink'ez ndo búlhni, “Ndoni nuhyudóolts'it. ");
INSERT INTO cafNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ndunnah bulubeshi huba 'un telhdel, 'en 'uda huba 'un tezkat ho' 'int'ah. 'Ink'ez ndunnah hubulubeshi huba 'un chatuzulhdel 'aw huba 'un chatikulh ho' 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","'Et ndunnah lanezi 'o 'at nanah (12) hubutah 'ilhunuh, 'ut'udánda, Thomas hiyulhni, 'aw hubutah hoolah hoh Sizi bughu ninya. ");
INSERT INTO cafNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","'Et ndunnah yugha hoodul'eh, 'en Thomas hiyulhni, “NeMoodihti 'en ts'á'en!” 'Et ndo búlhni, “Soo sich'oh suna be bula lutgloo k'ah whunalh'en, 'ink'ez sulasgek be whune'sílhge, 'ink'ez buyust'e 'et sula be buka nudelhunik, 'et k'an zeh sih suba 'alha 'uhot'e,” ni. ");
INSERT INTO cafNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","'Et 'ilhu whutanilhghel inle hoh, doo chah Sizi yugha hoodul'eh koo tuz ts'ih hudelhts'i hoh Thomas 'en chah hubutah usda. Ndati duts'o da'de'ai, 'et whunts'ih khunyaz Sizi hubutah siyin hítelh'en, 'ink'ez ndo búlhni, “Soo cho nuhdzi dooghel.” ");
INSERT INTO cafNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","'Et Thomas 'uyúlhni, “Sula nilh'en 'ink'ez nlasgek be suka k'et nudilnih 'ink'ez nla be suzih k'ut chah nudílnih. 'Et 'o 'un 'aw suts'oodóntlai gunih. Mba 'alha 'uhot'e,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","'Et Thomas ndi yúlhni, “SMoodihti 'ink'ez sYak'usda!” ");
INSERT INTO cafNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","'Et Sizi ndi yúlhni, “Thomas, k'an sa'en, 'et huwa mba 'alha 'uhoont'ah. 'Et whunts'ih ndunnah 'aw chasuhí'il whunts'ih, 'ink'ez huba 'alha 'uhoont'ah, 'en degha nus hoonzoo hubugha whults'ut.” ");
INSERT INTO cafNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","'Et 'o nus lhat yugha hoodul'eh hubunalh Sizi hooncha túne' 'ust'en 'et whunts'ih 'aw ndi dustl'us k'ut 'aw buk'echa'íduguz. ");
INSERT INTO cafNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","'Et ndi zeh kw'uné'usduguz, 'i soo cho bugha t'éwhunohzin 'ink'ez nuhwhuba 'alha 'uhot'e, 'alha Sizi 'en Christ, Yak'usda buYe', 'en 'int'ah. 'Et njan nuhwhuba 'alha 'uhoont'ah hoh 'ilhuz wule be ts'úkhuna, 'i Sizi Gri boozi bugha' téht'ilh. ");
INSERT INTO cafNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Njan hoh teh ne'whust'en hukw'elh'az, doo chah Sizi yugha hoodul'eh 'en hubunalh haínya. Bun k'ut 'et Tiberias huwhútni, 'et 'uja. 'Ink'ez hubunalh haínya hoh njan tuné'whust'en: ");
INSERT INTO cafNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Thomas 'ut'udánda, Nathanael, 'en keyah Cana huwhútni Galilee yun k'ut whuz'ai, 'et whut'en, Zebedee buye'kah chah, 'ink'ez 'uyoon nanah Sizi yugha hoodul'eh chah, 'en ts'iyannah 'ilho hudelhts'i. ");
INSERT INTO cafNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","'Et Simon Peter ndo búlhni, “Lhook ka' test'ilh.” 'Et ts'iyawh 'uhiyulhni, “Wheni chah nyulh ts'utoodelh.” 'Et 'ahoh soo ts'iyawh ts'i cho be hándel. 'Ulh'ek ndúhoolhyez hoh te'huzdla, 'et whunts'ih 'aw cha'hílooh. ");
INSERT INTO cafNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","'Om bundada sa haín'ai hoh khunyaz Sizi taba siyin hitelh'en, 'et whunts'ih ndunnah yugha hoodul'eh 'aw Sizi 'en 'int'ah t'éhonízun. ");
INSERT INTO cafNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","'Et Sizi ndo búlhni, “Suzkeh 'aw ih cha'áhlooh?” “Hoolah,” hiyulhni. ");
INSERT INTO cafNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","'Et doo chah ndo búlhni, “Nuhlhoombil ts'i bugha nalhnih ts'ih tailhkat, 'et sih be 'óohlooh.” 'Et whuz tahiyalhkat, lhook whuz lhai huzdlooh k'et, 'aw lhoombil hanahíyoolelh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","'Et ndun 'ilhunuh Sizi k'us yúk'entsi', 'en Peter 'uyúlhni, “NeMoodihti 'ut'en.” 'Et neMoodihti 'ut'en ni Peter yudánts'o hoh soo 'a cho yoo 'az ts'ih ye usda 'i yé nallhah, 'ankw'us 'ust'et 'int'ah ínle 'et, 'ink'ez bun k'ut tooz tállhah, Sizi ts'un teyalh 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","'Aw taba howu nilhza ilah 'uhut'en, lanezi 'o 'at lanezi (200) negan ghútestnih bat'en 'uwhuldzuh. 'Et ndunnah yugha hoodul'eh ts'iyaz be hándel 'ink'ez lhoombilh lhook tubulh toot hiyégus hoh yahíyulhdlat. ");
INSERT INTO cafNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Yanahúsduki hoh taba kwunyaz dézk'un 'ink'ez lhook buk'ut 'ínt'ah 'ink'ez lhes chah 'et sa'ai hotelh'en. ");
INSERT INTO cafNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","'Et Sizi ndo búlhni, “Nyooz lhook suhlooh 'i bulah ndéz ahlelh.” ");
INSERT INTO cafNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","'Et Simon Peter ts'i yenya, 'ink'ez lhoombilh taba yáyuzguz. Lhook soo ncha 'i zeh dezbun, 153 'uneltsuk. Tube lhai 'ink'ez undaz, 'et whunts'ih lhoombilh 'aw k'uchaích'ulh. ");
INSERT INTO cafNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","'Et Sizi ndo búlhni, “Anih, njan na'aht'alh.” Hiyéntsaz hoh 'aw 'ilhunuh whunts'ih ndan 'int'ah hukwa chahiyoodulhkut, 'uda t'ehonínzun neMoodihti 'en 'int'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Sizi 'et ninínya, lhes yílhchoot 'ink'ez hubugha íni'ai. 'Et whuz na'a zeh lhook chah hubugha íninla. ");
INSERT INTO cafNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","'Aw 'et yaidla tah dinadija whuts'un, whulh tat Sizi yugha hoodul'eh hubunalh hainya. ");
INSERT INTO cafNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","'Aw 'et na'het'al hukw'elh'az, Sizi, Simon Peter yoodulhkut, “Simon Jonas buye', ndunnah, 'en huba degha nús ih sk'eintsi'?” 'Et Peter ndi yúlhni, “A sMoodihti, nyunch'oh t'éwhunínzun nk'esi' 'en usdli.” “Et t'eh susheepyaz hube 'olh'alh,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","'Et doo chah zeh whulh nat yoodulhkut, “Simon Jonas buye', 'usk'eintsi' ih?” 'Et Peter ndi yúlhni, “A sMoodihti, nyunch'oh t'éwhunínzun nk'esi' usdli.” “Et t'eh susheep hubughonle,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","'Et doo chah zeh k'an yoodulhkut, “Simon Jonas buye' 'alha ih sk'entsi' 'en inli?” 'Et Peter tube buba dzuh suli, Sizi whulh tat yoodulhkut hoh ndi yúlhni, “Sk'entsi' inli ih?” ndi yúlhni. 'Et Peter ndi yúlhni, “SMoodihti, nyunch'oh ts'iyaintsuk t'éwhúnínzun. 'Ink'ez nyunch'oh t'éwhunínzun nk'ensi' 'en usdli.” 'Et doo chah Sizi ndi yúlhni, “Susheep hube 'ilh'alh! ");
INSERT INTO cafNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Soo ts'ah'un na'a nyudúsni, soo chilh inli da soo cho soo nadint'ih 'ink'ez nts'e hukwa' ninzun teh ninya inle. 'Et whunts'ih hoonyan sinli t'eh, nla nusnidelnik 'ink'ez 'uyoon dune nla ye'dínguz, 'i t'az nts'e hukwa cha'nínzun, hoh teh whunts'ih ninyutélhte,” yulhni. ");
INSERT INTO cafNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","'Et Sizi ndi yulhni hoh nts'e na'a didut datétsah huwa Moodihti yudutélhti, 'et wheínulhtun hoh 'utni. 'Et ndi dani hukw'elh'az 'et huwa, “Sunanyalh,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","'Et Peter 'awh nadelhú'a hoh ndun Sizi k'us yúk'entsi', 'en 'uja 'udek'elh'az na'hút'alh yuts'un le'uja 'ink'ez yoodulhkut, “SMoodihti, ndan 'uténilh nye'óotekulh?” ");
INSERT INTO cafNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peter ya'en hoh Sizi ndi yúlhni, “SMoodihti, ndun 'en do daténilh?” ");
INSERT INTO cafNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","'Et Sizi ndi yúlhni, “Whusanátesdalh whuts'un 'et khóona hukwa' nuszun t'eh, nyun mba cha'hóot'ah. 'Et nyun sunanyalh.” ");
INSERT INTO cafNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ndunnah lhulhutsinkah suli 'et ndi khunek Sizi ye yátelhtuk 'i ts'iyawh hubutah nidélts'ut, ndun Sizi yuk'entsi' 'aw dachatésa. 'Et whunts'ih Sizi Peter 'aw chadínil ndun 'en 'aw dachatésa. 'Ants'ih yúlhni, “Whusanatésdalh whuts'un 'et 'en khóona hukwa' nuszun t'eh, nyun mba cha'hóot'ah?” ");
INSERT INTO cafNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","'Et ndun yugha hoodul'eh, ndun Sizi degha nus yuk'entsi', 'en 'udani njan howu yailhtuk 'ink'ez 'uk'e'ánguz 'ink'ez daja dani soo 'alha 'uhoont'ah 'et t'éts'onínzun. ");
INSERT INTO cafNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","'O 'un chah tube lhat Sizi ne'úst'en. 'Et hubugha ts'iyawh 'uk'e'ánguz t'eh, dustl'us lhai k'et ndi yun k'ut 'et whunts'ih 'aw soo cha'hoolcho wule t'ah 'et telalh wheni núszun. 'Et ndoh honeh.");
INSERT INTO cafNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Sulh dune Theophilus, dahooja. 'Udechoo khunek 'uk'une'úsduguz, 'i 'uk'une'zíguz, 'i Sizi nts'oh tune'úst'en 'ink'ez nehodulh'eh 'et hubugha ndet bube 'ut'en whe' yudilh'en, ");
INSERT INTO cafNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","'ink'ez ndet dzin nduk yak'uz whenája 'et whuts'un. 'Et nduk yak'uz nateltelh whutsuh, ndunnah dune whel'a 'en hubulhtsi, 'en Ndoni bugha huba nahezya. ");
INSERT INTO cafNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sizi dazsai hukw'élh'az dit lanezi (40) dzin ndoohoolyez lhat hoh hubunalhts'et nusiya, 'et whuz na'a 'alha khuna 'aw whuts'u hoodódlai ghaít'ah. Hinilh'en 'ink'ez Yak'usda dune k'úne' bul'en hubugha hubulh yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","'Et 'ilhoh hudelhts'i, Sizi khúnek bughu nini'ai hoh ndo búlhni, “Jerusalem huwu toohdelh gunih! Se'aBá ye nuhwhuts'un náhezya, 'i huba oolh'i. Ndai nuhgha tet'alh, 'i bugha 'ún whudusni inle. ");
INSERT INTO cafNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","John dune too be 'ulh'en, 'en too, 'i be too be' 'un whulh'en inle, 'et whunts'ih 'aw lhadzin ilah inle t'eh, 'et whusawhútelts'ulh, se'aBá 'en Ndoni nuhts'uh tl'aidute'alh 'ink'ez nuhyudútelts'ulh. 'Et whuz na'a too bé' 'un whutelilh,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","'Et whel'a 'en Sizi teh 'ilhunahuwésdel hoh 'et Sizi hiyoodulhkut, “NeMoodihti, 'aw 'et ih whusahónzut Israel hubuts'uh hainzut doo chah zeh 'uyoon yun k'ut whut'en bumoodih nahutedleh?” ");
INSERT INTO cafNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","'Et Sizi ndo búlhni, “Nts'oh t'eh 'uwhuténilh, 'aw nuhwheni nt'eoonohzin huba cha'hóot'ah. Se'aBá, 'en zeh nt'eooninzun. ");
INSERT INTO cafNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","'Et whunts'ih Ndoni nuhyudélts'ut t'eh, soo nuhdzi ulhtus hoh Jerusalem 'et si suba dune whunulhtun tehle, Judea yun k'ut nduhóolcho, Samaria yun k'ut, 'ink'ez ndi yun k'ut nduhóolcho chah,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","'Et ndi yughu yaílhtuk hoh, 'aw 'et nduk yak'uz whenája. 'Aw 'et hinilh'en hoh, kw'us yuh ts'ih hoolah suli. ");
INSERT INTO cafNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","'Et 'awhuz nduk yak'uz ts'ih hika ités'en hoh khunyaz nanah dune lheyul 'i be dune hinli hubuzih hube hóodiltsai. ");
INSERT INTO cafNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Galilee whut'en, di ka 'et nudelhúya 'ink'ez nduk yaz ts'ih whunulh'en? Ndun Sizi nduk yak'uz ts'ih nuhwhughu whenája k'an nulh'en nduk yak'uz whenája, whuz na'a zeh whusanátedalh,” hubuhútni. ");
INSERT INTO cafNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","'Et whel'a 'en dzulh Olive hiyúlhni, 'i hiye nádidel hoh Jerusalem ts'ih lhgha hudindel keyah whuts'un dzuh nilhdza 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalem ts'ih lhgha hudindel hoh, 'ahoh nduk koo huwhut'i danáhundel. Peter, John, James 'ink'ez Andrew, Philip 'ink'ez Thomas, Bartholomew 'ink'ez Matthew, James Alphaeus buye', Simon Lizwif ba huwu daóodit'ah, 'ink'ez Judas James buye', 'en 'et koo húdelhts'i. ");
INSERT INTO cafNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","'Ahoolhyez 'ilhunahuwudulh tenahudutedli hukwa. Ts'ekoo bulh chah, Sizi bulhutsinkah, 'ink'ez Mary be'ama chah, ts'iyawh tenahududli. ");
INSERT INTO cafNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","'Et hoh da dzin yugha hodil'e 'ilhohuwezdel ('ilho 120 'uhut'en dune). 'En hubutah Peter hubulh yatélhtuk ka didinya, ");
INSERT INTO cafNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","'ink'ez ndo búlhni, “Sulhutsinkah ndi Yak'usda bughunek 'uk'une'úsduguz, 'i 'et lhaóodoneh huba' hoont'ah. Ndet David hó'en Ndoni 'en bugha Judas datenilh 'et yughu yalhtuk. Judas 'en hobunelhtan hoh, hoh da Lizwif Sizi hiyílhchoot inle. ");
INSERT INTO cafNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","'En chah nelh 'óot'en ka 'utuhaílhti inle. 'Et huwa Judas wheni k'una'a en chah whel'a inle.” ");
INSERT INTO cafNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ndi sooneya Judas bugha ínenkat tinta' 'ant'en 'et huwa 'i be yun lhadínt'ah, 'i ye'onket. 'Et Judas nadelduz 'ink'ez buyust'e ndulhcho hoh bé buyáh hawheltal. ");
INSERT INTO cafNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalem whut'en ts'iyawh whulh 'úhudants'o 'et nahahoozi “Akeldama” huwhútni. 'I khunek, “Uskai Yun” ni hoh 'utni. ");
INSERT INTO cafNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peter 'et chah ndutni, “Yak'usda bughunek 'uk'une'uzguz, 'i k'ut “Shun” hiyúlhni, 'i ndutni, ‘Bukoo 'aw dune chahóot'ih hoole.’ 'Ink'ez chah ndutni, ‘Bube 'ut'en k'ah 'uyoon yuk'enadóoja.’ ");
INSERT INTO cafNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Et huwa 'uyoon netaóoya Sizi Gri dinadija hubugha nela ts'ah'un 'udooni ka. Ndun dune 'utaháztelhtelh, 'en 'ahoolhyez huba nelh 'ét'en inle, 'en 'uztelilh. 'Udechoo Sizi neMoodihti nelh tezya da 'et whuts'un, 'et ndet John dune too be 'ulh'en too bé' yinla da 'ink'ez nduk yak'uz negho whenája 'et whuts'un.” ");
INSERT INTO cafNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hukw'elh'az Peter budáni, 'et nanah dune, 'en 'utahaóobahalhti. 'Ilhunuh Joseph 'en Barsabbas hiyúlhni, Justus chah hiyúlhni. 'Et 'ilhunuh chah 'en Matthias hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","'Et tenahududli hoh nduhútni, “NeMoodihti nyun ts'iyannah dune budzi yuh téoonínzun. 'Et huwa whunénilhtun k'us ndan 'en neba 'utuhaílhti. ");
INSERT INTO cafNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judas tinta' 'ant'en hoh nts'e huba 'int'ah ts'ih wheínya, 'et huwa ndan yuk'enádutedalh, 'en whel'a whunénilhtun ndan simba 'uts'ooleh.” ");
INSERT INTO cafNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","'Et nahúlt'ah huboozi tse k'ehanguz 'ink'ez 'un hinduntelhmul, k'us ndan boozi nduk nádelhts'ut, 'en 'utahaitelhtelh. 'Et ndúja hoh Matthias 'en whel'a 'en lanezi 'o 'at 'ilhunuh hinli hoh butanínya. ");
INSERT INTO cafNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","'Et Lizwif budzenis whucho, Pentecost huwhútni, whusawhélts'ut hoh ts'iyannah Sizi huba 'alha' hoont'ah 'ilhunuh bukoo 'ilhuhowezdel. ");
INSERT INTO cafNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Khunyaz nduk yat'ah ts'ih 'uhuduzts'ai, 'ants'ih nilhts'i cho delts'ulh li'whutni. 'Ink'ez nyo koo hudelhts'i nduhóolhcho 'uwhutni. ");
INSERT INTO cafNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","'Ink'ez 'ants'ih kwun li'int'ah, 'i hitelh'en 'ink'ez lhawh tezkat hoh koo hudelhts'i lhuk'inli hoh hubuk'édinkat. ");
INSERT INTO cafNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","'Et hudelhts'i ts'iyawh Ndoni hubuyídelts'ut 'ink'ez khunek whutsuh da t'ehinízun, 'i be yawhehúnilhtuk, 'et Ndoni bugha óoni'ai 'et ndadooni ka. ");
INSERT INTO cafNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","'Aw 'et lhanah Lizwif, Yak'usda hínedulh hinli Jerusalem húdelhts'i nilhdza keyah ts'ih hahándel njan dzenis whucho 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","'Et keyah whut'en 'ants'ih whudutni 'et 'uhudánts'o ka, hoh ts'iyawh lhelhts'un keyah whut'en bughunek be hubulh yawhehúnilhtuk, tube huba hooncha hoh. ");
INSERT INTO cafNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Huba hooncha k'et lht'ah 'ulhahudutni, “Nts'e na'a 'uwhutét'ilh? Ndunnah Galilee whut'en lhe'hutni nek'eyáhulhtuk wheni nek'una'a hubuzdits'o,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","“Wheni Parthia, Media, 'ink'ez Elam whut'en ts'inli. Mesopotamia whuts'un, Judea 'ink'ez Cappadocia whut'en chah ts'inli. Pontus whuts'un, 'ink'ez Asia ts'ih hahandel chah ts'inli. ");
INSERT INTO cafNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia whuts'un, 'ink'ez Pamphylia whut'en chah ts'inli. 'Et Egypt whuts'un, 'ink'ez Lybia whunat Cyrene whuzih whut'en chah, bulunah chah Rome ts'ih hats'ándel. ");
INSERT INTO cafNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","'Ilho Lizwif 'ink'ez 'udun yun k'ut whut'en, ndan Lizwif ts'ih nalhéya, netah bulunah chah Crete 'ink'ez Arabia ts'ih hahandel ts'inli. 'Et whunts'ih dahóolcho 'i be Yak'usda ne'úst'en, 'et nduhóolcho hoh whenich'oh neghunek k'una'a, whuz na'a hubuzdits'o,” 'uhutni. ");
INSERT INTO cafNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bugha hané'nesjoot 'ink'ez 'uhoot'e ts'ih hoolah hoh ts'iyawh lhahóodulkut, “Dawhútenilh hoh simba 'uwhutni?” lhahudutni. ");
INSERT INTO cafNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","'Et 'uyoon, 'en Sizi huba 'alha' 'int'ah ghu hedloh, “Ndunnah dune yatahunatnai,” ho' hutni hubuhútni. ");
INSERT INTO cafNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","'Et Peter whel'a 'en hubutah didinya 'ink'ez 'ilhohuwezdel hubulh whenduniltul, “Sulh dune 'ink'ez nuhwheni Jerusalem whut'en chah ts'iyawh soo zélhts'ai, 'et nuhwhudóosni dáhooja njan 'et hubugha. ");
INSERT INTO cafNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ndunnah dune 'aw tachahunítnai nuhwheni ndunáhzun whunts'ih, 'ink'ez k'an ts'iyai dzetniz whutsuh 9:00 'uhunet'oh 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Njan dawhút'en, 'et ndun Yak'usda ba nus whunilh'en Joel, 'en huwu yailhtuk hoh ndutni, ");
INSERT INTO cafNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nts'e na'a k'an dune ts'inli 'ustl'e' 'uhóoja t'eh, ni Yak'usda, 'et sih suyeghah si sugha 'en ts'iyannah dune yudutélts'ulh. Nuhwhuzkehkah nus daóotenilh 'et huwu yahutelhtuk. Nuhchilhkah chah hubenghun newhúlts'uk t'ehontézin. Nuhduneti 'en chah nahútes hoh t'ehontezeh. ");
INSERT INTO cafNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","'Ink'ez hoh t'eh ndunnah suba 'uhut'en, dune, 'ink'ez ts'ekoo chah ts'iyawh suyeghah si sugha 'en buye ídutelts'ulh, 'et huwa 'en chah nus dawhútenilh huwu yahutelhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ndukyaz 'ink'ez ndi yun k'ut chah huwa 'ét'en tuné'whutet'en. 'Et 'uskai, 'ink'ez kwun chah, 'ink'ez lhut lhai chah whutéleh. ");
INSERT INTO cafNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sa 'i chah tsahólhgus tele, 'ink'ez 'ulh'ek ooza 'i chah 'uskai tele, ndet whéwhunujut 'ink'ez whudézti dzin neMoodihti whusatéyalh 'et whutsuh 'uwhuténilh.’ ");
INSERT INTO cafNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","'Et ndet whusahónzut, 'et whusawhútelts'ulh ndan neMoodihti hudutejih hits'u hukwa 'uhutni, 'en hudutejih.” ");
INSERT INTO cafNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Peter 'et chah ndutni, “Nuhwheni ndun Israel hubuts'uh háhzut, sughunek soo cho oozelhts'ai, Sizi, 'en Nazareth whut'en, Yak'usda nuhts'ítelh'a, 'en Yak'usda bugha huwa 'ét'en tune'út'en, 'et hoh whunelhtan njan nuhtah 'uhoot'en 'ink'ez nuhwheni chah soo cho t'ewhunáhzun. ");
INSERT INTO cafNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yak'usda nanínezut 'ink'ez 'uda t'eooninzun, 'i be 'uda Sizi nuhtl'atéltelh niwhuni'ai. Nuhwheni nuhgha lubeshi 'ulh'en Sizi lhdulalhgus k'ut whehídunilht'o, 'et whuz na'a sélhghi. ");
INSERT INTO cafNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","'Et whunts'ih Yak'usda ninaidilhti. Be dats'útsaih, 'i yuch'a' nilhde, 'aw 'ilhuz daootsah huba cha'hóot'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","'Et 'uda David yughu yailhtuk ínle hoh ndutni, ‘'Ahoolhyez neMoodihti sunen ba nulh'en. Nalhnih ts'ih sunen ba siyin dzuh noszut whuch'a. ");
INSERT INTO cafNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","'Et huwa 'ahoolhyez sudzi hóont'i, 'ink'ez whunénik bulh chah yalhtuk, 'ink'ez si 'astl'iyaz yinkak sída. Datésah t'eh 'aw whenoolhújut ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Naootnilh keyah si suzul 'aw 'et neóolhtelh ghaít'ah 'ink'ez ndunnah Yak'usda be'ildzun, 'en 'aw buyust'e wulhjut ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","'Ilhuz khutesnalh, 'et whusunelhtan. Sulh 'ínt'ah 'et huwa hoonúst'i sutalhtsilh.” ");
INSERT INTO cafNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Peter 'o 'un chah ndutni, “Sulh dune David netsuh da keyah whuduchun unli, 'en bugha ts'ah'un na'a whunwhunoolhtun hukwa' nuszun. David dazsai 'ink'ez 'uhíyalhti 'ink'ez buts'un k'ut 'awhuz nezih whuz'ai. ");
INSERT INTO cafNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","'En Yak'usda ba nus whúnilh'en 'int'ah 'ink'ez Yak'usda ye yúts'u nahezya t'einínzun. 'Ink'ez Yak'usda whuz na'a yuba niwhuni'ai ho' yulhni, ‘David buts'uh haínzut, 'en 'ilhudzin David k'una'a bukw'uts'uzda cho dezti, 'i k'utedalh,’ 'en Christ 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David nus hó'en hoh Yak'usda daténilh t'eoonanzin 'et Christ dinadutédalh 'et huwu yailhtuk hoh ndutni, ‘Yaidla tah 'aw 'et néyoolhtelh ghaít'ah, buyust'e chah 'aw wulhjut ghaít'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","'Et ndun Sizi 'en dazsai hoh Yak'usda nahighilhna inle 'ink'ez wheni bugha hoodul'eh ts'iyawh khuna hoh ts'a'en 'et huwa. 'Alha nakhítna t'ets'onínzun. ");
INSERT INTO cafNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nduk yak'uz degha nus whudézti, 'et Yak'usda bunalhnih ts'ih natl'aidalhda 'ink'ez nets'ú yoozi, 'i bugha Yak'usda buYe' yutl'ahó'ai. 'Et 'en Ndoni nets'ítelh'a 'ink'ez neyudélts'ut. 'Ink'ez 'alha' 'int'ah k'an dzin ndi 'i oozelhts'ai 'ink'ez nulh'en. ");
INSERT INTO cafNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","'Aw David yak'uz nuchaiyal, 'et whunts'ih njan ndutni, ‘Moodihti 'en suMoodihti 'et ndi yulhni, ‘Njan nalhnih ts'ih sughu sinda, ");
INSERT INTO cafNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ndet nch'a hudetni, 'en hubuch'a' nilhde hukw'élh'az 'et 'ilhuz bumoodih onle.’ ");
INSERT INTO cafNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","'Et huwa nuhwheni Israel hubuts'uh háhzut, ts'ah'un nuhwhudúsni, 'alha' ndun Sizi lhdulalhgus k'ut yundunilt'o, Yak'usda, 'en Moodihti 'ink'ez Christ chah yulhtsi.” ");
INSERT INTO cafNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","'Et Peter hidánts'o hoh soo ts'ah'un budzi t'aígheznai. 'Et Peter 'ink'ez 'uyoon whel'a 'en bulh hubuhoodulhkut, “Nelhutsinkah, Peter nedani hubugha dáztenilh?” ");
INSERT INTO cafNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","'Et Peter ndo búlhni, “Ilhunah ahli nuhwhulubeshi whuch'a nuhwhubeni nahadunoohlelh 'ink'ez Sizi Gri boozi bugha too be 'ahneh. 'Et nuhwhulubeshi nuna'doodeh 'ink'ez Ndoni nuhyudóolts'it. ");
INSERT INTO cafNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ndunnah Yak'usda neMoodihti buka' dutenilh, 'ilhunah ahli hoh Ndoni nuhts'ú yoozi inle, nuwhuzkeh chah 'ink'ez nilhza yun k'ut whut'en, 'en whunts'ih.” ");
INSERT INTO cafNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","'Et Peter sa hoh hubulh yaílhtuk 'ink'ez huba nus whúnilht'uk 'ink'ez ndo búlhni, “Ududulhúyis! Ndunnah ntsi' hubuch'a nalhú'ah, 'ink'ez hubulh áht'en ilah, Yak'usda dzuh nobutelhdeh ho' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Lhanah huhóont'i hoh highunek hiyílhchoot 'ink'ez too be' hulya. 3,000 bat'en 'uhint'ah, 'en hubut'aoobuninla. ");
INSERT INTO cafNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","'Ahoolhyez 'ilhuhowudulh, 'ink'ez whel'a 'en hubuhoodulh'eh. Ts'iyawh 'ilho lhulh 'uhut'en. 'Ink'ez 'udek'elh'az hulhgha na'het'al hoh whunahulnih ka lhula'uhut'alh 'ink'ez 'ilho tenahududli. ");
INSERT INTO cafNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Whel'a 'en huwa 'ét'en tuné'hust'en 'et hoh 'o nus ts'iyannah huba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Huba 'alha' hoont'ah ts'iyawh 'ilho nuhúdelh 'ink'ez hiyit'i, 'i ts'iyawh hiyé lhula'dut'en. ");
INSERT INTO cafNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","'Ilhunuh yit'i, 'i be 'óokuk t'eh, 'i ts'iyannah ndunnah 'en ndai hiye dunidzit, 'en ndi sooneya hubutuninunih. ");
INSERT INTO cafNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Lizwif hubuluglez whucho 'et dzin totsuk 'ilhuhowudulh. Koo 'et 'ilho budzi únzoo 'ink'ez huhóont'i hoh lhula na'hut'alh. ");
INSERT INTO cafNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","'Et ndunnah huba 'alha' hoont'ah Yak'usda ba whudélhti, 'ink'ez Jerusalem whut'en, 'en chah buts'un hínzoo. Ndunnah hudujih, 'en neMoodihti dzin totsuk 'o nus 'uhuneltsuk hubulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","'Et 'ilhudzin Peter 'ink'ez John bulh dzetniz hukw'elh'az, 3:00 bat'en 'uhúnet'oh, Lizwif hubuluglez whucho ts'ih hutez'az tenahududli neóoninzut 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Hukwuti hoonzoo huwhútni, 'et dune 'en whuzdli whuts'un 'aw nuchásyah, 'en 'et 'usda. Dzin totsuk whuz nihiyukaih. Ndunnah Lizwif hubuluglez whucho ts'ih tihúdulh 'en sooneya ka hubuts'un dátso. ");
INSERT INTO cafNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","'Et Peter 'ink'ez John bulh bukoo ts'ih hútez'az hoh hubutelh'en 'ink'ez hoonliyaz higha óo'alh ka buts'u dátso. ");
INSERT INTO cafNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Soo cho hinilh'en hoh Peter utni, “Nenilh'en!” yulhni. ");
INSERT INTO cafNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","'Et hubunilh'en hoonli higha te'alh ka hubuts'un tsi hooli. ");
INSERT INTO cafNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","'Et Peter 'uyúlhni, “Aw silver 'ink'ez gold 'i chah chasúst'ih, 'et whunts'ih ndai 'ust'i, 'i ngha tés'alh. Sizi Gri Nazareth whut'en whelhtus 'ink'ez boozi bugha neghá whults'ut huwa didinyih 'ink'ez ninya!” ");
INSERT INTO cafNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","'Ink'ez Peter ndun dune nuchásyah nalhnih ts'ih yula ilhchoot 'ink'ez didilhya ibulh buke, bukechunah tubulh hoolhtus nawhusdli. ");
INSERT INTO cafNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","'Ahoh didillhah 'ink'ez nádinya. 'Et Lizwif hubuluglez whucho ts'ih hubulh tez'az. Nuya hoh nduk túllhuk chah 'ut'en 'ink'ez Yak'usda délhti. ");
INSERT INTO cafNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ts'iyannah yunilh'en nuya 'ink'ez Yak'usda délhti. ");
INSERT INTO cafNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ndun dune nuchásyah nahuyoolhúts'it 'et Lizwif hubuluglez whucho hukwuti hoonzoo 'et 'usda, 'en 'int'ah. Tube huba dahooja hole! Ndun hinilh'en hoh tube huba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Peter, John bulh 'awhuz ndun dune soo na'yinla huboontun zeh 'int'ah hoh, dune ts'iyawh njan Solomon bughu dáti bet huwhútni ts'ih whuz hubuts'un whehélghaz. ");
INSERT INTO cafNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","'Et Peter hubunilh'en 'ink'ez ndo búlhni, “Nuhwheni Israel hubuts'uh háhzut, di ka nenulh'en 'ink'ez nohba dahooja hole ih? 'Aw whenich'oh be ts'inzoo k'us be ts'ílhtus 'i bugha ilah ndun dune nuya nats'úlhtsi. ");
INSERT INTO cafNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Netsuh whudelhdzulh Abraham, Isaac, 'ink'ez Jacob lhan'un teh lhuzkehkah hinli hoh 'uhoont'ah. 'Ink'ez hubuYak'usda Sizi Gri yuk'úne' 'ust'en, 'en ncha yulhtsi 'ink'ez yudélhti. Lizwif howuhinli tl'ahíyalhti. Pilate yulanadutetnih 'et whunts'ih nuhwheni buch'a nídehdel inle. ");
INSERT INTO cafNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","'En lubeshi bughu hoolah 'ink'ez ts'ah'un dune chah unli, 'et whunts'ih buch'a nidehdel 'ink'ez dune selhghi, 'en Pilate nuhts'u yúlanadootni buts'o húkwa' dahni. ");
INSERT INTO cafNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ndun 'ilhuz be ts'ukhutena negha íni'ai, 'en 'ahla sélhghi, 'et whunts'ih Yak'usda naootnilh keyah 'et nahiyílhna, 'et njan nduhooja hoh newhuzneulhtan. ");
INSERT INTO cafNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","'Et Sizi huba 'alha' yint'ah 'ink'ez ndai yé ulhtus 'i bugha ndunnah dune soo ulhtus suli hoh soo ná'uja. 'En 'int'ah nilh'en. 'Alha' 'i be hoont'ah ndun dune nuhbut siyin, 'en Sizi huba 'alha' yint'ah, 'et 'i be buyust'e ndulhcho hoh soo na'uja. ");
INSERT INTO cafNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","'Aw 'et sulhutsinkah t'enwhunúszun nuhwheni 'ink'ez k'une'nuwhuhul'en chah Sizi dálh'en t'éoonuzúhzun, 'et huwa 'éht'en. ");
INSERT INTO cafNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","'Et 'uda hoh Yak'usda dani 'et ndunnah ts'iyannah Yak'usda be nus whúnilh'en, 'et Christ dzuh nutezut, hutni. 'Et whuz na'a 'uhóoja whúlhsi. ");
INSERT INTO cafNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","K'an nuhwhulubeshi whuch'a nuhwhubeni nahadunoohlelh, 'ink'ez Yak'usda buts'u naóolhu'ah, 'aw 'et sih nuhwhulubeshi nuhwhuba yuna'doolhdeh. ");
INSERT INTO cafNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","'Et hoh Yak'usda nuhdzi ulhtus nuhwhuba yoolhtsilh 'ink'ez Sizi Gri 'en chah nuhts'ítoolh'a. Whutsuh whudelhdzulh 'uda 'en yugha nuhwhudáni inle. ");
INSERT INTO cafNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","'En nduk yak'uz 'et 'usda, ndet ts'iyaintsuk doo chah soo ná'whutelelh nasdli 'et whuts'un. 'Uda huwu yuhalhtuk ínle. ");
INSERT INTO cafNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nulh'en 'uda Moses ndutni inle, ‘Yak'usda neMoodihti 'ilhunuh Yak'usda be nus whúnilh'en si sk'una'a 'int'ah, 'en nuhts'útelh'alh. Nuhkeyah 'ilhunuh 'en 'utenilh. Daja nuhwhuduténilh ts'iyawh oozólhts'a. ");
INSERT INTO cafNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ndunnah ndan Yak'usda be nus whúnilh'en chahiyoozílhts'ai, 'en Yak'usda budune buch'a baninla, 'ink'ez hoolah hubutelhtsilh.” ");
INSERT INTO cafNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","'Et Peter 'o 'un ndutni, “Ndunnah Yak'usda be nus whúnilh'en ndet 'uwhuténilh huwu yahalhtuk da, Samuel chah 'ink'ez 'uyoon yuk'élh'az khuna chah, ts'iyawh whuz na'a zeh 'uhutni inle. ");
INSERT INTO cafNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nuhwheni chah Yak'usda be nus whúnilh'en buts'uh háhde 'ink'ez ndai Yak'usda nuhtsuh whudelhdzulh khunek huba lhaídinla, 'i nuhwheni chah nuhwhuba 'int'ah. Ndi khunek huba lhaídinla, 'i Abraham chah tl'adélts'ut inle hoh Yak'usda, Abraham yulhni, ‘Nts'u haínzut, 'en bugha dune ndi yun k'ut huba hoonzoo tele.’ ");
INSERT INTO cafNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","'Ink'ez Yak'usda buYe' Sizi, 'en dinaidilhti hoh nuhwheni 'udechoo 'en nuhts'ú wheyalh'a. 'Et hoontsi' 'i be túne' aht'en, 'i whuch'a nanwhúninla. 'Et huwa Yak'usda Sizi 'udechoo nuhts'ítelh'a hoh nuhwhuba hoonzoo wule ka.” ");
INSERT INTO cafNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","'Et 'awhuz Peter, John bulh dune hubulh yahulhtuk hoh, ndunnah nawhulnuk luglez whucho howuhinli bumoodih, 'ink'ez Sadducee hubuhútni chah, 'en hubugha nindel. ");
INSERT INTO cafNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Whuts'uhudutnik ndunnah nanah whel'a 'en Sizi dazsai 'ink'ez dinidija, 'et hubugha whebuhodulh'eh. 'Et hoh yaidla dinahudutédulh 'alha' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","'Et 'om bun whuts'un tsak'eoobuha'ai 'aw 'et hulhgha ts'un ye 'un whezulh 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","'Et whunts'ih lhanah hubudánts'o Sizi dazsai 'ink'ez dinidija huba 'alha' hoont'ah suli. 'Aw 'et 'ilho huba 'álha' hoont'ah 5,000 bat'en suli. ");
INSERT INTO cafNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","'Aw 'et 'om bun dzin ndunnah Lizwif k'une'buhul'en hubumoYak'usda be nus whúnilh'enodih, hubutsuh whúdelhdzulh, 'ink'ez Moses be' dustl'us 'uk'ununa'úsduguz chah, 'en Jerusalem 'et 'ilhúhowezdel. ");
INSERT INTO cafNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","'Ink'ez náwhulnuk degha nus dezti, Annas hiyúlhni, Caiphas, John, Alexander, 'ink'ez náwhulnuk degha nus dezti ts'ah hahande, 'en chah, ts'iyawh Jerusalem 'et 'ilhuhowezdel. ");
INSERT INTO cafNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Whel'a 'en 'ink'ez ndun soo na'huyinla, 'en chah hububut níboninla 'ink'ez hubuhoodulhkut “Dáhla hoh ahla? Ndai be úlhtus, 'i be 'aht'i? Ndan boozi bugha ndun dune soo na'uhla?” ");
INSERT INTO cafNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ndoni Peter 'o nus ulhtus yulhtsi hoh ndo búlhni, “Israel budune nuhwheni k'une'bulhú'en 'ink'ez hubutsuh whúdelhdzulh chah, ");
INSERT INTO cafNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ndun dune nuchásyah, 'en ba 'ut'en unzoo, 'i 'uts'ínla, 'i 'ink'ez dats'ínla soo ná'ts'inla hoh, 'i k'an buka neoodulhkut. ");
INSERT INTO cafNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","'Et huwa nuhwheni 'ink'ez Israel hits'uh hainzut 'en ts'iyawh soo cho ndun nuhwhudutésnilh, Sizi Nazareth whut'en, 'en lhdulalhgus k'eílhti, 'en Yak'usda nahighílhna. 'En boozi 'ink'ez whélhtus 'i be ndun nuchásyah, 'en soo ná'ts'inla. ");
INSERT INTO cafNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Sizi, 'en 'int'ah Yak'usda be' dustl'us 'uk'une'úzguz, 'i k'ut ndutni hoh bughi yatuk, ‘Nuhwheni koo 'uwhulh'en tse 'ún dutelh'uz, 'i 'uja degha nus tse tube buka daóodit'ah, 'i suli.’ ");
INSERT INTO cafNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yinkak ndulhcho hoh Sizi Gri 'en bugha zeh uzdutejih. 'Aw 'uyoon yé ulhtus, 'i bugha uzdoojih ghaít'ah. 'Et whuz na'a Yak'usda negha ooni'ai.” ");
INSERT INTO cafNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","'Et naheyelh 'en t'ehonínzun Peter 'ink'ez John 'en 'ants'ih hoh dune, 'aw whechahodi'il 'uhint'ah. 'Aw chaníljut hoh yahulhtuk, 'et huwa huba hooncha, 'ink'ez t'ehonanzin Sizi Gri hiyulh nusudel hinli. ");
INSERT INTO cafNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ndun nuchásyah soo ná'uja 'ink'ez Peter John bulh hubuzih siyin hinilh'en hoh 'et huwa 'aw dája hudooni ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","'Et yatuk bakoo tinábonilh'a 'ink'ez hukw'u nahuhúlhye. ");
INSERT INTO cafNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","'Ink'ez lhahoodulkut, “Ndunnah dune daóobuztelilh? Jerusalem whut'en ts'iyawh t'ehonínzun degha nus huwa 'ét'en, 'et 'uhuhóonla. 'Aw whuts'uts'oodódlai ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","'Et huwa 'aw 'o 'un 'uyoon t'eoonoozeh whuch'a, ndunnah dune tube cho bube' ts'oonolhjoot Sizi Gri boozi bugha 'aw 'o 'un 'uyoon dune bulh yáhoolhtuk gunih.” ");
INSERT INTO cafNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","'Et hubukoo danáboninla 'ink'ez hubuhútni, “Nts'oh dáhoont'ah 'et whunts'ih, 'aw Sizi boozi bughi yaoolhtuk, k'us dune húhodoolh'eh ílah!” ");
INSERT INTO cafNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","'Et Peter, John bulh 'uhútni. “Nuhwhenich'oh hukw'u nuní nulhzut, nuhk'una'a tulih k'us Yak'usda buk'una'a tulih 'uztenilh? Ndet Yak'usda nalh ts'ah'un 'uhoont'ah? ");
INSERT INTO cafNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nts'e na'a ts'uho'en 'ink'ez whulh 'uts'udánts'o, 'aw 'i zeh huwu yalhts'oolhtuk huba' hoont'ah?” ");
INSERT INTO cafNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nahéyilh 'en soo khunek ulhtus, 'i be doo chah, “Sizi yughu yaoolhtuk gunih!” hubuhútni, 'ink'ez hubulanahudetnik. 'Aw dzuh nobuhoolhdzut hoolah, dune ts'iyannah Yak'usda ba hodélhti njan dáhooja 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ndun dune huwa 'ét'en 'i be soo ná'huyinla, 'en dit lanezi (40) 'o 'un be naoodezut ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","'Aw 'et Peter, John bulh hubulanahudetnik ibulh, ndunnah náwhulnuk degha nus dezti 'ink'ez hubutsuh whudelhdzulh chah, 'et njan daoobuzdáni, 'et hukw'ú nahuwhulnuk. ");
INSERT INTO cafNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","'Et 'uhudánts'o hoh ts'iyawh lhgha Yak'usda ts'un tenawhehúndunidli, “NeMoodihti nyun Yak'usda 'int'ah t'éts'onínzun, yaz, ndi yun, yatoo, 'ink'ez bun k'ut chah ínla, 'ink'ez ndai bulh 'úhoonla, 'i tubulh. ");
INSERT INTO cafNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Netsuh whudelhdzulh David mba nye'ustlen, Ndoni bugha mba yalhtuk ínle hoh ndutni, ‘'Udun yun k'ut whut'en, di ka howunílch'e? Di ka ndunnah dune Yak'usda ch'a yahálhtuk? ");
INSERT INTO cafNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ndi yun k'ut hubudayi cho, 'en chah lhahudutedughan wheni. 'Ink'ez dune k'une'nuwhuhul'en chah 'ilhúhowezdel Yak'usda 'ink'ez buChrist, 'en hich'a nidendel ho' hut'en.” ");
INSERT INTO cafNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","'Et 'o 'un tenahudedli hoh 'uhutni, “Et 'alha' 'i be njan Jerusalem 'et Herod 'ink'ez Pontius Pilate bulh 'udun yun k'ut whut'en chah, 'et Israel hubuts'uh hainzut 'en chah, ts'iyawh 'ilhuhowezdel hoh nYe' Sizi lubeshi bughoh hoolah, 'en buka tsi hóodli neba yulhtsi, 'en hich'a nidendel 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","'Et 'uda be ilhtus, 'i 'ink'ez nyeni be ndunínzun inle hoh lhawhudinla. 'Et k'an 'et daóotenilh dini ínle, 'et whuz na'a ndunnah 'ilhuhowezdel nduwhútenilh. ");
INSERT INTO cafNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","'Et huwa neMoodihti, ne'hunoolhjoot, k'an dzin hubóozelhts'ai 'ink'ez 'aw chats'uníljut hoh wheni, mba' ts'ut'en, nghunek unzoo, 'i be yats'oolhtuk negha ooni'aih. ");
INSERT INTO cafNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","'Et huwa neMoodihti, be ílhtus 'i be dune soo na'inle 'ink'ez nYe' Sizi, lubeshi bughoh hoolah, 'en boozi be úlhtus, 'i bugha ts'iyannah hubunalhts'et hooncha 'ink'ez huwa 'ét'en tune' whut'en hóle.” ");
INSERT INTO cafNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","'Aw 'et tenahudedli 'ustl'e' 'uhudéja hoh, nyoh 'ilhúhowezdel ndulhcho noghésnai 'ink'ez Ndoni buyídelts'ut hoh 'aw chaníljut hoh Yak'usda bughunek 'i be hubulh yáwhehunilhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Huba 'alha' hoont'ah 'ilho ts'iyannah lhula hudut'en. 'Aw hube'ildzun hoolah. Ndai hiyet'i 'ilho hiyé ne'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","'Aw chaníljut hoh whel'a 'en soo khunek ulhtus, 'i be, “alha' hoont'ah hoh Sizi neMoodihti 'en dinadija,” hutni, 'ink'ez Yak'usda tube hubuts'un únzoo. ");
INSERT INTO cafNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","'Aw 'ilhunuh hubutah ye dunidzit hoolah. Ndunnah bukoo k'us yun lhadínt'ah huyit'i, whe' honket, ");
INSERT INTO cafNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","'et sooneya bugha yúlts'uk, 'i whel'a 'en hubutl'aihinudzih. 'I 'ilho ndunnah 'en yedunidzuk 'en hubutl'áhíyudzih. ");
INSERT INTO cafNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","'Et whuz na'a 'uja 'ilhunuh dune, Joses hiyúlhni, 'en Levite 'int'ah, 'et Cyprus whuzdli, 'en whel'a 'en “Barnabas” hiyúlhni, ndi boozi 'i, “En nedzi ulhtus ilh'i,” ni hoh 'utni. ");
INSERT INTO cafNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","'En chah yun ut'i, 'i be 'ónket 'ink'ez whel'a 'en hubutl'ayándzai. ");
INSERT INTO cafNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","'Et whunts'ih 'ilhunuh dune, Ananias hiyúlhni, 'ink'ez bu'at Sapphira bulh yun hiyít'i, 'i hiyé 'onket, ");
INSERT INTO cafNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","'ink'ez sooneya bulah dich'oh duba yílhchoot. 'Et bu'at chah t'eoonínzun. 'Ink'ez bulah 'i whel'a 'en butl'ayándzai, 'ink'ez ndo búlhni, “Ndi sooneya 'i ts'iyawh 'int'ah.” ");
INSERT INTO cafNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","'Et Peter 'uyúlhni, “Et di ka Satan buk'úne' tant'en hukwa' nizun? 'Ink'ez lhe'dini sooneya buluh ílhchoot 'ink'ez Ndoni ts'un honts'it? ");
INSERT INTO cafNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ndi yun be 'óotehkulh whutsuh nuhwhe'ildzun unli ínle. Be 'óhket hoh buzooneya 'i chah nuhwhe'ildzun 'int'ah. 'Ink'ez di ka ndzi yuh hoh njan tinta' nint'en? Yak'usda ts'un honts'it 'aw dune ts'un ilah!” ");
INSERT INTO cafNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Soo Ananias whudánts'o ibulh, nadélduz 'ink'ez dazsai. Ndunnah whulh údants'o tube cho whehunelhújoot. ");
INSERT INTO cafNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Chilhkah 'en dahuníndel 'ink'ez hiyust'e highá' wezduz, tihinilhti, 'ink'ez whuyéhiyalhti. ");
INSERT INTO cafNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","'Et tat hukw'e' hoonezt'o bat'en inle, 'et bu'at 'aw dáhooja t'echaoonízun hoh danínya. ");
INSERT INTO cafNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","'Et Peter 'uyúlhni, “Sudíni ndi sooneya, nki netl'ayándzai, 'i be 'óhket, 'i buzooneya, ts'iyawh tulih 'int'ah?” “A, ts'iyawh 'int'ah,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","'Et Peter 'uyúlhni, “Et di ka nki bulh Ndoni ólhdzih hukwa' aht'en? Ndunnah chilhkah nki whuyéhiyalhti ndati hundelhúya, nyun chah whuz na'a tinanyotelhtelh!” ");
INSERT INTO cafNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","'Et 'ahoh 'en chah yubut nálts'ut 'ink'ez dazsai. Chilhkah dahuníndel 'ink'ez 'en chah dazsai hinilh'en. 'Et 'en chah tihinilhti 'ink'ez buki hizih whuyéhiyalhti. ");
INSERT INTO cafNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","'Et huba 'alha' hoont'ah 'ink'ez 'uyoon dune tubulh ts'iyawh hodánts'o hoh degha nus whéhunelhújoot. ");
INSERT INTO cafNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","'Et dune tah whel'a 'en lhat huwa 'ét'en tuné'hut'en. Solomon budáti bet huwhútni, 'et ts'iyannah huba 'alha' hoont'ah whuz 'ilhuhowezdel. ");
INSERT INTO cafNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ts'iyannah soo hubughi yahalhtuk, 'et whunts'ih 'aw huba 'alha' hoont'ah 'uyoon dune hubutahoodelh ghaít'ah. Njan lhe'hóoja 'et huwa whehíntsaz. ");
INSERT INTO cafNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Sizi Gri huba 'alha' yint'ah 'o nus hulai suli, dune chah 'ink'ez ts'ekoo chah. ");
INSERT INTO cafNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Whel'a 'en huwa 'ét'en tuné'hut'en 'et huwa ti whuzih nduda hik'usútez 'i bulh tébuhulih, khun sih Peter hoh wheghah uyalh t'eh, butsen 'i whunts'ih buk'ut lhúyolts'it. ");
INSERT INTO cafNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Lhanah hoh dune Jerusalem whunat keyah whut'en, 'en chah whusahándel. Nduda chah 'ink'ez ntsi' nudúdeh buyidélhts'i 'en chah whusábuhule 'ink'ez ts'iyawh soo ná'buhulh'en. ");
INSERT INTO cafNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","'Aw 'et Lizwif náwhulnuk degha nus dezti, 'ink'ez yuts'ú dutnik, 'en Sadducee hinli 'en whel'a 'en tube bughe' hoolnih suli. ");
INSERT INTO cafNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","'Aw 'et whel'a 'en hubuhílhchoot 'ink'ez dune tsak'edelhts'i 'et tsak'ebahanla. ");
INSERT INTO cafNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","'Et whunts'ih 'et 'ulh'ek neMoodihti bulizas tsak'edelhts'i da' duteztan, tinaóobuninla 'ink'ez obúlhni, ");
INSERT INTO cafNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ahdulh 'ink'ez Lizwif hubuluglez whucho nudelhúya 'ink'ez ndi k'an be ts'úkhuna, 'i bugha hubulh yálhtuk.” ");
INSERT INTO cafNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","'Et hidánts'o hoh, soo yilhkai 'et Lizwif hubuluglez whucho dahuníndel 'ink'ez 'aw 'et dune wheoobohódulh'eh. 'Et Lizwif náwhulnuk degha nus dezti 'ink'ez yuts'úh dutnik, 'en Lizwif butsuh whúdelhdzulh, 'ink'ez nahéyelh chah, bughú nahézya yahatelhtuk hubugha. 'Et 'ink'ez whel'a 'en tsak'edelhts'i ts'ih Israel hits'uh haínzut 'en bukuwhenábuhalh'a hububut nibatelelh ka. ");
INSERT INTO cafNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","'Et whuz hunindel hoh whel'a 'en tsak'edelhts'i 'en huhóolah hotelh'en. 'Et nahéyelh buts'un náhundel 'ink'ez ndo badáni, ");
INSERT INTO cafNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Dune tsak'edelhts'i ts'ih lhghazdindel hoh dá'denla 'aw 'et ndóohoont'ah. 'Ink'ez huwuhinli chah 'aw 'et huwuhinli 'et dá'uzdutez'ai hoh, 'aw ndunnah whel'a 'en huhoolah!” ");
INSERT INTO cafNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Luglez whucho huwuhinli bumoodih, Lizwif náwhulnuk degha nus dezti 'ink'ez Lizwif bunáwhulnuk moodih tubulh whulh 'úhudants'o hoh, 'et huwu yahulhtuk, “whel'a 'en dahúja simba 'uhint'ah?” hutni. ");
INSERT INTO cafNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","'Et 'ilhunuh dune danínya 'ink'ez ndo búlhni, “Whunulh'en ndunnah dune tsak'ehudelhts'i 'en nyooz luglez whucho ts'ih dune hubodulh'eh!” ");
INSERT INTO cafNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Luglez whucho huwuhinli bumoodih, budune tubulh whuz whéhandel, 'et ndunnah 'ilhuhowezdel hubé hunulhújut doo ka tse be hubuhooghan, 'et huwa whel'a 'en higha 'ooliyaz hoh nabuhílchoot. ");
INSERT INTO cafNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","'Et whel'a 'en dunábuninla 'ink'ez nahéyelh hububut nebaninla 'ink'ez náwhulnuk degha nus dezti, 'et huboodulhkut, ");
INSERT INTO cafNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Soo khunek ulhtus, 'i be nuhwhuba nats'uhézya ínle ndun Sizi bugha dune huboodulh'eh ílah nuhts'utni inle. K'an whunulh'en lhe'ahja, Jerusalem ndulhcho hoh 'aw 'et hubodilh'eh. Ndun dune dazsai, 'et nuwheni nek'éhoh'alh hukwa 'aht'en!” hutni. ");
INSERT INTO cafNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter 'ink'ez 'uyoon whel'a 'en bulh whuz yahatelhtuk, “Yak'usda zeh buk'úne' ts'oot'en huba' hoont'ah, 'aw dune buk'úne' ts'oot'en huba cha'hóot'ah,” húbulhni. ");
INSERT INTO cafNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","“Et Sizi lhdulalhgus hiyendunilht'o hoh sélhghi, 'et whunts'ih netsuh whudelhdzulh buYak'usda 'en nakhiyílhna. ");
INSERT INTO cafNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","'Et Yak'usda yak'uz whenáyalhti dunalhnih ts'ih buzih 'et yulhda, 'ink'ez Moodihti 'ink'ez neulhyis chah yulhtsi. 'Et Israel hubuts'uh hainzut hubeni náhondunoolelh, 'et sih bulubeshi huba 'ún yutoolhdelh. ");
INSERT INTO cafNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","'Et nuwheni Yak'usda ne'ust'en ho'en ts'inli 'ink'ez huwu yats'ulhtuk. 'Ink'ez Ndoni, 'en Yak'usda k'une' 'ut'en hubugha iní'ai, 'en chah nela'ut'en,” 'et hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","'Et nahéyelh njan hodánts'o hoh, tube cho 'o nus hukwa ha'nilch'e k'et, whel'a 'en hubotuzelhghelh hukwa' huninzun, 'et howu yahalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","'Et whunts'ih 'ilhunuh dune, Gamaliel hiyúlhni, 'en Pharisee unli ts'iyannah ba ncha, 'en hubutah didinya 'ink'ez ndo búlhni, “Astl'iyaz 'az hubehlelh.” ");
INSERT INTO cafNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","'Et nahéyelh ndo búlhni, “Israel whudune huwa 'óohli hoh ndunnah dune né'bulh'en. ");
INSERT INTO cafNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Dzuh sa da inle 'ilhunuh dune Theudas hiyúlhni, 'en ninya ‘Dune ncha usdli,’ ni hoh dune bulh yálhtuk. 'Et 400 bat'en 'en hits'ú nedindel, 'et whunts'ih hizelhghi, 'ink'ez yuts'ú nidendel inle, ts'iyawh 'ants'ih lhtahanindel. 'Et nduhóoja hoh hoolah huzdli. ");
INSERT INTO cafNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","'Et whuz na'a zeh 'uyoon dune chah nduja, Judas Galilee whut'en hiyúlhni, 'et dune naoodulto hoh 'et ninya. 'Et chah lhanah dune hits'ú nidendel. 'En chah hizelhghi 'ink'ez yuts'ú nidendel ínle, 'en chah ts'iyawh lhtanahundel. ");
INSERT INTO cafNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","'Et ndúhooja inle 'et huwa nuhwhudúsni, ndunnah dune hoonli 'oboohleh gunih, hubuts'uh hachaoozah'ak! 'Et dich'oh duba 'uhut'en 'ink'ez whunohodulh'eh t'eh, 'ahoh hoolah naóotedle. ");
INSERT INTO cafNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","'Et whunts'ih Yak'usda ndi 'ut'en k'ah ts'ih hubugha ini'ai t'eh, 'aw buch'a' oolhdeh ghaít'ah, doo ka sih Yak'usda ch'a ne'aht'en wahle.” ");
INSERT INTO cafNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","'Et nahéyelh huba 'alha' deja. Whel'a 'en danábaninla 'ink'ez “Huboolhtsas,” hubuhútni. 'Ink'ez hukw'elh'az, “Sizi boozi bugha dune huhodoolh'eh gunih!” hubuhútni, 'ink'ez bulanahudetnik. ");
INSERT INTO cafNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","'Et whel'a 'en nahéyelh bughu tínahundel. Yak'usda Sizi Gri ba dzuh nuhude 'et huba soo' huldzoo dich'oh 'et na'hundunudzun, 'ink'ez howu nélhnik. ");
INSERT INTO cafNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","'Et dzin totsuk Lizwif luglez whucho 'ink'ez dune bukoo chah, Sizi, 'en Yak'usda buChrist, 'en bugha dune huhodulh'eh 'ink'ez khunek unzoo, 'i be dune hubulh yahúlhtuk, 'aw 'ustl'e' cha'hudínil. ");
INSERT INTO cafNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","'Et hoh da yugha hoodul'eh 'o nus hulai suli. Yugha hoodul'eh Lizwif nawh hudedowh, Greek hubughunek k'eyahalhtuk 'ink'ez Lizwif dich'oh hubughunek k'eyahalhtuk, 'en lhts'un lhenah 'ahúdeja. Greek k'eyahalhtuk hutni, “Netsandelh 'aw hubugha cha'hus'ai dzin totsuk sooneya dune hiye la'ut'en, 'i whutahudzih teh.” ");
INSERT INTO cafNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","'Et lanezi 'o 'at nanah whel'a 'en Sizi Gri yugha hoodul'eh, ts'iyawh 'ilhubuhuwezdla 'ink'ez 'uhutni, “Aw cha'hóozoo Yak'usda bughunek be yats'ulhtuk whulazdutetnih 'ink'ez sooneya dune be la'whut'en, 'i zeh 'uts'oolh'en ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","'Et huwa sulhutsinkah skwunlai 'o 'at nanah dune nuhtah ndunnah t'ebunáhzun Ndoni hubuyidínda 'ink'ez huwhunih chah 'uhint'ah 'utaháoobahle 'en ndi 'ut'en 'uhiyoolh'en wheni 'en huwu hinli hubuts'oolhtsilh. ");
INSERT INTO cafNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","'Et nuwheni tenazdudli 'ink'ez Yak'usda bughunek be yáts'ulhtuk, 'et zeh 'uts'otelh'ilh,” hubuhútni. ");
INSERT INTO cafNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","'Et 'ilhuhowezdel ts'iyawh whel'a 'en huba soo' hudeja, 'et Stephen 'en 'utahahúyalhti soo cho be 'alha' hoont'ah ut'i, 'i 'int'ah 'ink'ez Ndoni buyudínda. 'Et Philip, Prochorus, Nicanor, Timon, Parmenas chah, 'ink'ez Nicolaus, 'en 'udun yun k'ut whut'en, Antioch whut'en 'int'ah, 'en Lizwif ts'ú nenadenja inle, 'en 'utahaóobahanla. ");
INSERT INTO cafNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","'Et whel'a 'en hububut nébaninla hoh whel'a 'en huba tenahudedli 'ink'ez hubuk'událnik. ");
INSERT INTO cafNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","'Ink'ez Yak'usda bughunek 'aw 'et ndulhcho t'enédzin. Yugha hoodul'eh, Jerusalem whut'en chah 'o nus hulai huzdli. Lhanah Lizwif hubunáwhulnuk 'en chah Yak'usda bughunek hiyílhchoot. ");
INSERT INTO cafNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","'Et Stephen be 'alha' hoont'ah 'ink'ez Ndoni ye úlhtus, 'i be dézbun, 'i bugha dune tah hooncha huwa 'ét'en túne'ust'en. ");
INSERT INTO cafNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","'Et whunts'ih bulunah dune hich'a nídendel, 'en Lizwif Cyrene 'ink'ez Alexandria ts'ih hahándel 'uhint'ah. 'En, 'et 'ulhna hinli hubulanadetnik 'ilhunuh luglez 'et whehúhoozi 'et 'ilhuhowezdel. 'Uyoon chah Cilicia 'ink'ez Asia ts'ih hahándel, 'en chah Stephen hiyenah 'utni. ");
INSERT INTO cafNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","'Et whunts'ih Stephen, Ndoni bugha whunih k'et yalhtuk, 'et huwa 'aw hich'a oolhdeh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","'Et 'ants'ih hoh dune, 'en huba k'elha háwhulhtsi Stephen, Moses bughunek 'uk'une'úsduguz, 'i 'ink'ez Yak'usda ch'a yalhtuk hudooni ka. ");
INSERT INTO cafNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","'Et nduhútni hoh, hubutsuh whúdelhdzulh, Moses be' dustl'us 'uk'ununa'úsduguz chah, 'ink'ez 'onghunnah chah huba hodi'ai, 'en ts'iyawh Stephen hiyulh húnilch'e. Highu nindel, hiyílhchoot, 'ink'ez naheyelh hububut nihínilhti. ");
INSERT INTO cafNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","'Et bulunah dune hiba hoots'it ka whusaóobahanla 'ink'ez naheyelh njan ndo buhútni, “Ndun dune neluglez whucho whudezti 'ink'ez Moses huwa néulh'a 'ahoolhyez whuch'a yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Njan ndutni hoh uzdits'o. ‘Ndun Sizi Nazareth whut'en neluglez whucho nawhúdunteyus 'ink'ez Moses khunek netl'aída'ai, 'i chah ts'iyawh 'uts'un na'a zeh na'whutelilh,’ 'et ndutni hoh uzdits'o.” ");
INSERT INTO cafNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ndunnah nahúheyelh ts'iyawh Stephen 'en zeh hínilh'en bunen unzoo k'et 'ants'ih lizas nen 'et ndunt'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","'Et Lizwif bunáwhulnuk degha nus dezti Stephen yoodulhkut, “Et ndunnah 'alha, hutni hoh ih hutni?” ");
INSERT INTO cafNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","'Et Stephen 'uyúlhni, “Sulhutsinkah 'ink'ez 'abákah soo zúlhts'ai! Netsuh whudelhdzulh Abraham 'awhuz Mesopotamia usda, Haran ts'ih natedalh whutsuh hoh, Yak'usda buts'uh hayánduz, 'et bunalhts'et hawhélts'ut. ");
INSERT INTO cafNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","'Et Yak'usda 'uyúlhni, ‘Nyunatnekah 'ink'ez nkeyah chah whuch'a sinyih 'ink'ez nts'e keyah whúnyuntelhtun whuz tonya.’ ");
INSERT INTO cafNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","'Et Abraham, Chaldea yun k'ut whuch'a síya 'ink'ez Haran ts'ih ninya. 'Et hukw'elh'az be'abá dazsai hoh ndi yun k'an buk'udelhúts'i, 'i Yak'usda whuz wheyálh'a. ");
INSERT INTO cafNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","'Aw Yak'usda yun ntsolyaz whunts'ih yughá chai'al, 'et whunts'ih yuts'ú yoozi hoh ndi yulhni, ‘Nyun 'ink'ez ndan nyehudútedulh, 'en ndi yun hubube'hooldzun tele.’ 'Et hoh da Yak'usda ndi yulhni hoh Abraham 'aw buzkeh hoolah inle. ");
INSERT INTO cafNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","'Et Yak'usda ndi yulhni, ‘Nts'ahahutedulh 'uts'un yun k'ut ts'ih whuz 'ulhna huteleh 'ink'ez 400 naoodezut 'et dune dzuh nubutelhdoh.’ ");
INSERT INTO cafNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","'Et Yak'usda ndo búlhni, ‘Ndunnah 'ulhna hubuhit'i sich'oh huba nahutesyeh. 'Et hukw'elh'az whuch'a nahúsdel 'ink'ez njan keyah, si zeh sk'úne' hutet'en.’ ");
INSERT INTO cafNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","'Et Yak'usda Abraham ndi ye yuts'u nahezya, 'i bugha buts'uh huhaínzut, 'en hika dune unli, 'i k'ut hubuhít'us. 'Et whuz na'a Yak'usda hiyulh 'ilhunuh huzdli. 'Et Abraham buye' Isaac whuzdli 'ink'ez whulh lhk'udit dzin 'et hiyúzt'us. 'ink'ez Isaac chah buye' Jacob hoh Jacob, 'en chah ndunnah buye'kah lanezi 'o 'at nanah, 'en chah netsuh whudelhdzulh whunih ndúbuhinla. ");
INSERT INTO cafNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","'Et doo chah nuhtsuh whudelhdzulh, Joseph bulhutsinkah, 'en highe 'oolnih 'et Egypt ts'ih hiye 'ónket 'ulhna tele ka, 'et whunts'ih Yak'usda yulh 'út'en, ");
INSERT INTO cafNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","'ink'ez dzuh nutezut whuch'a nayulhti. 'Et Pharaoh, Egypt hubudayi cho, yubut ninínya hoh Yak'usda whunih chah yulhtsi, 'ink'ez hubudayi cho yót'i ka 'et chah yugha óoni'ai. 'Et huwa hubudayi cho Pharaoh 'en bukoo chah 'ink'ez keyah dulhcho hoh chah whumoodih yulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","'Et Egypt 'ink'ez Canaan whulh dulhcho hoh dai whuzdli. Tube dune dzuh nudeh k'et netsuh whudelhdzulh 'aw ts'uyi, 'i nahóolelh ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","'Et whulh údants'o Egypt ts'ih whuz ts'uyi, 'i 'ilhówezdla 'et buzkeh, netsuh whudelhdzulh, 'en 'udetsah whuz whebalh'a. ");
INSERT INTO cafNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Whúlh nat hanahedel hoh 'et Joseph bulhutsinkah ts'un t'éoonedzin 'ink'ez hubudayi cho Pharaoh 'en Joseph bulh dunékah whulh údants'o. ");
INSERT INTO cafNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","'Et Joseph be'abá Jacob yuts'ótl'a khunek i'ai, dich'oh 'ink'ez dunatnékah teh ts'iyawh whusahóodelh, hubúlhni. 'Ilho skwunlai 'o 'at nankoh lanezi 'o 'at skwunlanah, (75) 'en hinli. ");
INSERT INTO cafNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","'Et Jacob Egypt ts'ih hunindel, didut chah 'ink'ez netsuh whudelhdzulh chah 'et hudálts'i 'et keyah yahadla. ");
INSERT INTO cafNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Buyust'e 'et keyah Shechem huwhútni ts'ih whuz lhghu naoobadinla. 'Et whutsuh da Abraham 'et keyah, ndunnah Hamor whut'en hubuts'un yunyaz onket inle, 'i k'ut whuyo buhanla. ");
INSERT INTO cafNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","'Et ndi yun Yak'usda Abraham ye yúts'u nahezya, 'i beghah whúdezulh 'ink'ez nedune Egypt hudelhts'i 'o nus hulai suli. ");
INSERT INTO cafNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","'Et 'ants'ih 'uyoon hubudayi cho suli. 'En 'aw Joseph be 'ut'en k'ah 'aw t'éwhunúszun. 'En Egypt whut'en bumoodih suli. ");
INSERT INTO cafNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nedune hubé' whulhts'it 'ink'ez netsuh whudelhdzulh dzuh nubulhdeh hoh k'anya huhonle 'en tébuhoolelh yahódlah ka, 'et whuz na'a hubudayi cho Pharaoh hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","'Et hoh da Moses whuzdli, 'en tube dune unzoo 'ink'ez tat sanun 'et be'abá bukoo hinalhyi. ");
INSERT INTO cafNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","'Aw 'et téhinilhti hoh Pharaoh butse' 'en ílhchoot 'ink'ez dich'oh buyaz k'una'a yunelhyi. ");
INSERT INTO cafNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Egypt whut'en ndai hiyé whunih, 'i ts'iyawh whehiyoodalh'i. 'Et dune ncha suli bughunek bugha 'ink'ez be 'ut'en chah. ");
INSERT INTO cafNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","'Et dit lanezi be naoodezulh suli hoh ndun Israel hubuts'uh hainzut Moses, 'en dudulh whut'en, 'en hubutah nanátedalh hukwa' nínzun. ");
INSERT INTO cafNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","'Et whuz ninya hoh 'ilhunuh bulh whút'en, 'en yunilh'en hoh ndun Egypt whut'en dzuh nuyulhdzut 'en yuk'ut duneh hoh k'ut duja 'ink'ez ndun Egypt whut'en yuzelhghi. ");
INSERT INTO cafNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses dich'oh ndunínzun, ‘Sudune 'en njan t'ewhunuszun si Yak'usda buts'un sútelh'a, si sugha hubulánáhúdútetnih ka.’ 'Et whunts'ih 'aw t'echaoohonízil Moses Yak'usda buts'ú wheyalh'a. ");
INSERT INTO cafNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","'Et 'om bun dzin 'et nanah Israel hubuts'uh huhanzut lhehút'us 'et, ‘Dah!’ hubúlhni, ‘Soo zúlhts'ai sulh dune lhulhutsin ahli, di ka lhéht'us?’ hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","'Et ndun bughá whut'en Moses 'un be' yunilhtsut 'ink'ez, ‘Ndan nemoodih 'ink'ez nahéyilh nyulhtsi hoh 'int'en? ");
INSERT INTO cafNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Hulhda ndun Egypt whut'en lhé'inla sélhghi! Whuz na'a si chah sutuzalhghelh ninzun ho ih 'int'en?’ yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","'Et Moses whudánts'o hoh, 'et whetsílhya, 'ink'ez keyah Midian huwhútni ts'ih whuz whinya, 'et dune unli, 'ink'ez 'et nanah buye'kah whúzdli. ");
INSERT INTO cafNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","'Et doo chah dit lanezi naoodezulh nadle hoh, nyooz dzulh Sinai hiyúlhni, 'i buzih dune chahóot'ih ts'ih 'et whus delhtan, 'i dézk'un 'i tah neMoodihti bulizas yá'en. ");
INSERT INTO cafNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","'Et Moses ba hooncha ho'en 'et whuz wheínya, soo cho whuntelh'ilh ka. 'Et Yak'usda yulh yatélhtuk hoh ndutni, ");
INSERT INTO cafNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Si 'ust'ah, ntsuhda hubuYak'usda usdli. Abraham 'en buYak'usda 'ust'ah, Isaac, 'inkez Jacob chah buYak'usda 'usdli.’ Moses nuljut k'et dulduz 'ink'ez 'aw whunoolh'en ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","'Et Yak'usda ndi yulhni, ‘Ke hain'es, njan yun whudézti 'int'ah hukw'usinyin. ");
INSERT INTO cafNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egypt hudelhts'i sudune hubunulh'en ndulhcho, 'i be dzuh nuhudeh 'ink'ez hubudústs'o lhe'hoolcho, 'i be tehududlih 'en hubutelhyih 'et wheni 'usja ndus háya. 'Anih 'aw 'et Egypt ts'ih nyutélh'alh.” ");
INSERT INTO cafNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","'Et Stephen 'o 'un ndutni, “Moses 'en 'int'ah Israel hubuts'uh huhanzut hich'a nalhúya inle, ‘Ndan nemoodih 'ink'ez nahéyilh nyulhtsi ho ih 'int'en?’ hiyúlhni inle. 'En 'uyínla Yak'usda hubuts'ítelh'a ndun lizas whus dézk'un, 'i tah ya'en, 'en yula'ut'en hoh Moses bumoodih 'ink'ez whuch'a nabuzdla yulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","'Et hooncha 'ink'ez huwa 'ét'en tune'út'en, 'et huwa Egypt whut'en hubula k'éhanabanla, 'et yatoo dulk'un huwhútni, 'ink'ez 'et dit lanezi naoodezulh (40), 'et dune chahóot'ih hoh nahudelh inle. ");
INSERT INTO cafNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses 'en 'int'ah Israel hubuts'uh huhanzut hubúlhni hoh ndutni, ‘Yak'usda be nus whúnilh'en, sundult'ah, 'en Yak'usda nuhts'ítelh'alh. Nuhkeyah 'ilhunuh 'en 'utenilh. 'En hubóozolhts'a.’ ");
INSERT INTO cafNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses 'en dune chahóot'ih 'et Israel hubuts'uh huhanzut hiyulh 'ílhodulh inle. Netsuh whudelhdzulh hubutah 'et'en 'ink'ez 'en zeh 'int'ah Sinai dzulh k'ut lizas yulh yaílhtuk inle Yak'usda bughunek netl'aídoo'alh ka. Ndi Yak'usda bughunek bulatah hoolah ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","'Et whunts'ih netsuh whudelhdzulh Moses hik'éne' oot'en hukwa cha'hunízun, hich'a nalhúya, 'ink'ez Egypt ts'ih nahutedulh zeh hukwa' hunínzun. ");
INSERT INTO cafNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","'Et huwa Aaron 'uhiyúlhni, ‘'Uk'éltsi neba inleh! Neba yak'usda wule huba. 'Et ntse newhuntelhtun. Ndun Moses newhusaínla, 'en dája simba 'aw t'ets'onízun 'et huwa.’ ");
INSERT INTO cafNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Hoh da 'et musdusyaz k'edeltsi 'uhínla inle 'ink'ez Yak'usda bukw'uzdai k'ut hits'e' delhk'un. 'Et huhóont'i hoh honélhnik, hubula be nyoo 'uhiyínla 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","'Et Yak'usda hubuch'a nálhú'a 'ink'ez n'un hubutelhdel nduk yaz sum 'i hits'un téni' noolhzin ka. 'Et hukwa Yak'usda be nus whúnilh'en 'i k'ut 'uk'une'úsguz inle hoh ndutni, ‘Dune Israel buts'u huhanzut, njan dune chahóot'ih dit lanezi naoodezulh whutah ndi khunai uhghan 'aw si suts'un ilah Yak'usda bukw'uzdai k'ut dulhk'un ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","'Et nuhyak'usda Moloch 'i nuhwhuba luglez 'ulh'en nuhle 'ink'ez sum k'edeltsi 'i chah nuhyak'usda Rephan hiyulhni, 'i 'int'ah hoh 'uk'eltsi 'uhla, 'i buts'un téni'nulhzun, 'et huwa 'aw 'et Babylon 'o 'un ts'ih nuhwhutelh'alh.” ");
INSERT INTO cafNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","'Et Stephen 'o 'un ndutni, “Et netsuh whudelhdzulh dune chahóot'ih ts'ih bun choyah Yak'usda hubeghah 'int'ah, 'i nahíyule. 'Et nts'e na'a Moses Yak'usda ndi yúlhni hoh whuz na'a 'uyínla, nts'e na'a 'uk'e'whéltsi 'et Moses whínelhtan inle. ");
INSERT INTO cafNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","'Ink'ez k'at le netsuh whudelhdzulh bun choyah hububákah hubutl'ahúho'ai. 'Et Yak'usda 'udun yun k'ut whut'en yun k'unábuntézyoot hoh hubudune ndi yun hiyílhchoot inle. 'Ink'ez ndi bun choyah 'et whuz'ai Joshua hiyulh tezdel David whusatéyalh whuts'un. ");
INSERT INTO cafNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","'En Yak'usda ba unzoo, 'en 'et Yak'usda yoodulhkut, ‘'Aw ih 'udun koo mba níhos'alh ghaít'ah? 'Ilhuz wheni 'et whuté'alh.’ Ndun Yak'usda 'en netsuh whudelhdzulh Jacob, 'en buYak'usda 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","'Et whunts'ih Solomon 'en 'uja Yak'usda ba koo 'uhóonla inle. ");
INSERT INTO cafNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","'Et whunts'ih degha nus Yak'usda dezti 'aw dune bukoo 'uhóonla chaídah. 'Et Yak'usda be nus whúnilh'en inle 'et ndutni, ");
INSERT INTO cafNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Moodihti utni, yak'uz whuts'un ts'iyawh k'úne' whul'en 'ink'ez ndi yun suke buk'usíla huba' 'int'ah. Nts'e na'a 'usutelhlilh koo suba 'uwhutehlilh 'ink'ez nts'e na'a natelhúyis, 'et suba niootéh'alh? ");
INSERT INTO cafNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","'Aw t'eóonuzáhzun sich'oh ts'iyaintsuk 'usdla inle,’ ni hoh utni.” ");
INSERT INTO cafNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","'Et Stephen 'o 'un ndo búlhni, “Ndi Yak'usda bughunek be nohwhulh yalhtuk, tube 'uts'un únuhzun ahli hoh 'aw oozólhts'a hukwa cha'nuzáhzun 'ink'ez Yak'usda 'aw bulh 'ilhunuh cháhlah! Nuhwheni chah nuhtsuh whudelhdzulh dahánt'e 'et ndaht'ah. Ndoni buk'úne' teht'en 'aw hukwa cha'náhzun! ");
INSERT INTO cafNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ts'iyannah Yak'usda be nus whúnilh'en, 'en nuhtsuh whudelhdzulh hube' huzúla inle. 'Ink'ez ndunnah Yak'usda be nus whúnoolh'en, ndun Yak'usda ba ts'ah'un na'a 'int'ah whusatéyalh hubugha hubunalh hútni hoh, nuhtsuh whudelhdzulh hizelhghi inle. Ndun 'en 'int'ah be 'óhket 'ink'ez sélhghi inle. ");
INSERT INTO cafNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nuhwheni 'uht'ah, Yak'usda bughunek bulizas nuhtl'aída'ai 'et whunts'ih 'aw buk'únucha'aht'il!” hubúlhni Stephen. ");
INSERT INTO cafNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","'Et dune nahéyelh Stephen hidánts'o hoh 'o nus huyulh húnilch'e k'et 'et huwa hituzelhghelh hukwa' huninzun. ");
INSERT INTO cafNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","'Et whunts'ih Ndoni Stephen soo ye yudílts'ut, nduk yak'uz ts'ih yutá'en hoh Yak'usda buts'uh hayánduz yutelh'en 'i bulh 'ink'ez Sizi Yak'usda nalhnih ts'ih yughu siyin. ");
INSERT INTO cafNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","'Ink'ez utni, “Nduk lhe'hóoja whunulh'en, yak'uz da'dutézkez 'ink'ez yinkak dune ye' Yak'usda nalhnih ts'ih yughu siyin hoh whunulh'en!” ");
INSERT INTO cafNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","'Et soo 'uhultus hoh 'uhúldzul 'ink'ez hubudzo whudahúdelhnik 'ink'ez ts'iyawh 'ilho hiyúlh telhtsut. ");
INSERT INTO cafNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","'Et Jerusalem 'et tinahínino, 'ink'ez tse be whehiyoonilh'uz. 'Et ndunnah Stephen nehínulh'uz nahiyits'uz, 'i ts'ahahiyelya, 'et dune chilh, Saul hiyúlhni, 'en zih nihíninla yughole ka. ");
INSERT INTO cafNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","'Et whuz na'a zeh Stephen tse be nuhínulh'uz 'ink'ez neMoodihti yulh yálhtuk, “Sizi neMoodihti suzul ilhchoot!” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","'Et dugwútsi be nenínya 'ink'ez soo 'ultus 'utni, “SMoodihti ndi lubeshi 'uhiyínla, 'i huba 'un yutolhdelh!” Ndudeja 'ink'ez dazsai. ");
INSERT INTO cafNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","'Et ndun Saul hiyeni k'una'a 'ayínla. 'Et dzin zeh Jerusalem ts'ih Sizi ba 'ilhuhowezdel bube' túzelalh 'ink'ez dzuh nobutelhzut. 'Et ts'iyannah huba 'alha' hoont'ah Judea 'ink'ez Samaria whut'en bukeyah ts'ih whuz ts'iyawh whutabanényoot. Whel'a, 'en zeh 'aw 'et hudelhts'i. ");
INSERT INTO cafNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bulunah soo Yak'usda ts'un téni' hunilhzun, Stephen whuyihiyalhti tube hubugha budzi únduda 'ink'ez hutso. ");
INSERT INTO cafNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","'Et whunts'ih Saul, Sizi Gri bugha 'ilhuhowezdel hoolah hubutelhtsilh hukwa' ninzun. Koo totsuk dune 'ink'ez ts'e koo chah tíbugus 'ink'ez tsak'eoobulih. ");
INSERT INTO cafNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","'Aw 'et huba 'alha' hoont'ah ndulhcho hoh nuhúdelh 'ink'ez ndi khunek unzoo, 'i hiye yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","'Et Philip 'en keyah Samaria whuz'ai whuz ninya 'ink'ez Christ, 'en bugha dune hubulh yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","'Et 'ilhuhowezdel Philip yalhtuk hidánts'o 'ink'ez huwa 'ét'en tune'út'en chah hinilh'en hoh, ts'iyawh t'ehudusnih 'ink'ez hiyoozélhts'ai. ");
INSERT INTO cafNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ntsi' nududeh, 'i buyáh hanainanyoot hoh 'ahúlzul. 'Ink'ez lhanah dune dechadusnik chah 'ink'ez dzuh nuhudelh chah, 'en soo naóo'balh'en. ");
INSERT INTO cafNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","'Et huwa nyoh keyah Samaria whuz'ai ts'iyawh huhóont'i. ");
INSERT INTO cafNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","'Et whunts'ih whuz 'ilhunuh dune, Simon hiyúlhni, 'et usda. 'En 'ahoolhyez duyun 'ink'ez huba né'dulhde 'et hoh, “Si dune uncha 'ust'ah!” hubúlhni hoh Samaria whut'en huba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","'Ink'ez ts'iyannah keyah hudelhts'i soode'a 'int'ah 'ink'ez tel'ennah chah hinilh'en 'ink'ez hiyoozélhts'ai. 'Et, “Ndun Simon 'en 'int'ah Yak'usda ba hooncha túne'ut'en unli,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Soo sa hoh huba duyun unli 'ink'ez huba hooncha 'et huwa bughunek tube hiyoontun. ");
INSERT INTO cafNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","'Et whunts'ih Philip ndi khunek unzoo Yak'usda dune k'úne' bul'en hubugha 'ink'ez Sizi Gri boozi bugha, 'i chah ye hubulh yalhtuk inle, 'en 'o nus huba 'alha 'utni, 'et huwa dune 'ink'ez ts'ekoo chah, ts'iyawh too bé' hulya. ");
INSERT INTO cafNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","'Et huwa Simon 'en chah buba 'alha' hoont'ah suli. 'Et too be' úlya hoh Philip yulh zeh 'ut'en. Nts'oh huwa 'ét'en 'ink'ez hooncha tune'út'en ts'iyawh 'et hubugha Simon buba hóoncha. ");
INSERT INTO cafNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","'Et whel'a 'en Jerusalem ts'ih whulh 'uhúdants'o Samaria whut'en Yak'usda bughunek hiyílhchoot, 'et Peter 'ink'ez John bulh whuz whebahalh'a. ");
INSERT INTO cafNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","'Et whuz huni'az hoh 'et buba 'alha' hoont'ah Ndoni buyudóolts'it ka huba tenahudedli. ");
INSERT INTO cafNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","'Awhuz Ndoni buyúdults'it, Sizi boozi 'i bugha zeh too be' hulya. ");
INSERT INTO cafNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","'Et Peter 'ink'ez John bulh buk'ehúdilnik hoh 'aw 'et Ndoni buyídelts'ut. ");
INSERT INTO cafNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","'Et Simon hubunilh'en whel'a 'en dune hubuk'ut delhúnik t'eh Ndoni hubuyídults'uk. 'Et Peter John bulh sooneya hubugha óo'alh hukwa' bulh'en. ");
INSERT INTO cafNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","'Ink'ez ndo búlhni, “Si chah ndi be ts'ílhtus, 'i sughu náh'aih 'et huwa ndan buk'udelhúnik 'en chah Ndoni buyudóolts'it.” ");
INSERT INTO cafNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","'Et whunts'ih Peter 'uyúlhni, “Ndi Yak'usda negha óoni'ai sooneya be ootankulh ninzun t'eh, nyun 'ink'ez nyuzooneya bulh hukw'elha dutéhk'un ho' hoont'ah! ");
INSERT INTO cafNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ndi ne'ut'en 'aw nela'olh'en huba cha'ínt'ah 'ink'ez Yak'usda nalh 'aw ndzi ts'ah'un cha'ít'ah 'et huwa, 'ink'ez 'aw nets'ún dentni ilah cha' 'unint'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Njan tink'us na'a nuní ninzut lht'ananindaih 'ink'ez neMoodihti buts'un ténadinli njan dunínzun, khun teh mba 'ún whutoolhdelh. ");
INSERT INTO cafNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Whuz na'a t'enyunúszun, daint'ah 'oolnih ntsi' dembun 'ink'ez lubeshi 'ustl'e' onleh ghaít'ah!” ");
INSERT INTO cafNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","'Et Simon, 'en John 'ink'ez Peter ndo búlhni, “NeMoodihti ts'un sba tenadahdli njan daootenilh dahni, 'et 'aw sts'un nducha hosne.” ");
INSERT INTO cafNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Soo bughunek ulhtus hoh neMoodihti bughunek ghu yáhálhtuk hukw'elh'az John 'ink'ez Peter bulh Jerusalem ts'ih nahunt'az. He'us hoh Samaria whutah keyah whuyaz totsuk khunek unzoo, 'i be dune bulh yahúlhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","'Et neMoodihti bulizas, 'en Philip yulh yátelhtuk hoh ndi yúlhni, “Lhadíntneh 'ink'ez ndet Jerusalem ts'ih ti n'az Gaza ts'ih, whuz ti inyalh,” whuz dune chahóot'ih ts'ih. ");
INSERT INTO cafNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","'Et Philip lhadúja 'ink'ez whuz whenya. 'Et sih Ethiopia dune, 'en eunuch hubuhútni, 'en koo ts'ih nádalh. Ethiopia hubudayi cho ts'eke 'en ba sooneya ghunli dune ncha hiyilh'i. Jerusalem ts'ih Yak'usda ts'un teni' noolhdzin ka whuz nusíya, wagon be whuz de hanaja. Hoh wheghah élhbus hoh Isaiah, Yak'usda ba nus whúnoolh'en, 'en yuk'une'úzguz, 'i yuk'uyalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","'Et Ndoni Philip yulh yailhtuk, “Whuz buts'ínyalh 'ink'ez wagon buzih k'ut tonya,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","'Et Philip yughulgai 'ink'ez Isaiah yuk'úne'uzguz 'i k'ut 'uk'eyalhtuk yuduzts'ai, 'et yoodulhkut, “Ndai buk'uyailhtuk 'i daja ni, 'et nt'eoonínzun ih?” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“Nts'e na'a t'entészin? Dune hiye súnulhtun t'eh, 'et sih daja ni hoh 'utni nahós'alh,” yúlhni. 'Ink'ez Philip, “Sughu denyih, 'ink'ez suzih sinda,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ndi Yak'usda bughunek buk'une'úsduguz, 'i 'ilhunuh 'et hukw'e yalhtuk ndutni hoh, “Sheep hituzelhghelh ts'ih hítelhti, 'i soo dant'ah, 'ink'ez sheepyaz hahiteghus teh t'edusnih, 'et ndunt'ah 'aw yachatílhtih. ");
INSERT INTO cafNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ts'iyannah nalh 'et hooncha hoh hukwayá hoonli tuné' hiyulh'en, 'ink'ez 'aw ts'ah'un na'a nucha'hiyilh'il. Ndi yun k'ut ye khúna 'i hubugha yílchoot, 'et huwa híts'u hainde 'aw dune t'ehinóozin ghait'ah.” ");
INSERT INTO cafNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","'Et ndun eunuch Philip 'ulhni, “Sudíni ndan Yak'usda be nus whúnilh'en ndan 'ulhni, dich'oh tulih na'dudútni k'us 'uyoon dune tulih 'ulhni?” ");
INSERT INTO cafNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","'Et Philip yawhénilhtuk ndi dune yuk'uyailhtuk, 'i Yak'usda bughunek 'et ho' dini hoh khunek unzoo, 'i Sizi bugha ts'iyawh yudáni. ");
INSERT INTO cafNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","'Uhelhbus hoh too hoonli 'uhunilhbaz. 'Et ndun moodih 'utni, “Njan too hooni. Dáhoont'ah huwa 'aw too be' 'óosneh ghaít'ah?” ");
INSERT INTO cafNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","'Et Philip 'uyúlhni, “Ndzi ndulhcho, 'i be, be 'alha' hoont'ah int'i t'eh, 'et too be' talnilh.” 'Et 'uyúlhni, “Sizi Gri 'en Yak'usda buYe' 'int'ah, 'et suba 'álha' hoont'ah!” ");
INSERT INTO cafNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","'Et ndun eunuch be ne'ulbas 'ilhuz nenintan 'ink'ez nahult'ah Philip ndun eunuch bulh dehahá'az 'ink'ez tahá'az. 'Et Philip ndun eunuch too be' yinla. ");
INSERT INTO cafNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","'Et tooz hanáhet'az ibulh Philip Ndoni be whedánde 'ink'ez ndun eunuch 'aw 'o 'at nachayít'il hoh didut tube cho whunelhnik hoh dukeyah ts'ih whena'elbaz. ");
INSERT INTO cafNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","'Ink'ez Philip keyah Azotus huwhútni 'et nuya hoh hitelh'en. 'Et whunat keyah wheyaz whut'en keyah Caesarea ts'ih teyalh whuts'un, ts'iyawh khunek unzoo, 'i be hubulh yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","'Et whezulh hoh Saul neMoodihti yugha hoodul'eh húnilch'e k'et ts'iyawh hubuteghan huwu yailhtuk, 'et Lizwif náwhulnuk degha nus dezti ts'ú whenya, ");
INSERT INTO cafNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","'ink'ez yoodulhkut keyah Damascus huwhutni ts'ih Lizwif hubuluglez be nawhulnuk duba buts'un k'e'ooges buts'u húkwa' 'utni, ndan Sizi k'una'a nuninuzut ts'iyawh dune 'ink'ez ts'ekoo chah tsak'eoobutelelh, 'ink'ez Jerusalem ts'ih nabatoola ka 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","'Et Saul keyah Damascus wheghah uyalh hoh, 'et khunyaz ndus de ts'un bunat tube kwun ulhtus ndult'ah, 'i hadanat. ");
INSERT INTO cafNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","'I bughah yun 'et nálts'ut 'ink'ez 'uwhutni, “Saul di ka dzuh nusílhdzut hoh 'int'en?” ");
INSERT INTO cafNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Moodihti ndan inli?” ni Saul. “Si Sizi 'ust'ah. Si 'usilh'en dzuh nusílhdzut. Ndan tutsus nulé buk'únucha'zint'en t'eh, nyunch'oh zeh dzuh nuná'dudildzut,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","'Et dulduz, buba hooncha, 'ink'ez 'utni, “SMoodihti ndet datésnilh suts'u hukwa' ninzun?” 'Ink'ez neMoodihti ndi yúlhni, “Dinadindaih 'ink'ez keyah ts'ih ínyalh. 'Et dune daténilh nyudóoni,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ndunnah dune Saul bulh nuhudelh 'ilhuz nehúnindel 'ink'ez t'ehudínel, 'aw dune chawhes'en 'et whunts'i njan yatuk 'et 'uhoozélhts'ai. ");
INSERT INTO cafNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul dinadija 'ink'ez yutá'en hoh chawhés'en suli. 'Et hila ilhchoot 'ink'ez Damascus ts'ih lhgha hidilhya. ");
INSERT INTO cafNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tat dzin 'et 'aw chawhés'en. 'Et nduhoolyez hoh 'aw cha'us'al 'ink'ez too whunts'ih chayusnai. ");
INSERT INTO cafNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","'Et keyah Damascus 'et 'ilhunuh buba 'alha' hoont'ah, Ananias hiyúlhni, 'en bunalh hawhelts'ut hoh neMoodihti yulh yailhtuk 'ink'ez ndutni, “Ananias” yúlhni. 'Et 'ahoh Ananias, “SMoodihti, njan sida,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","'Et neMoodihti 'uyúlhni, “Lhadíntneh 'ink'ez ti lhts'eoodez'a huwhutni ts'ih whuz inyalh Judas bukoo ts'ih, 'ink'ez dune Tarsus whut'en, Saul hiyúlhni, 'en buka 'oodolhkut. 'En tenadudli ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","'En chah bunalh hawhelts'ut hoh Ananias hiyúlhni, 'en daninya yunilh'en 'ink'ez yutsi k'edilnik whe'en naoodle ka.” ");
INSERT INTO cafNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias 'et 'uyúlhni, “NeMoodihti nts'e na'a 'utesnilh, lhanah dune ndun Saul 'en bugha whulh 'udats'o. Njan 'et ndúja, Jerusalem whut'en, dune nye'ildzun, 'en lhe'holhcho 'i be dzuh nobulhdeh ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","'Et 'ink'ez ndez Damascus ts'ih ninya náwhulnuk moodih ndunnah huba 'alha' hoont'ah ilhchoot 'ink'ez nyoozi be yalhtuk, ts'iyawh tsak'eboolelh ka higha óoni'ai.” ");
INSERT INTO cafNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","NeMoodihti 'et 'uyúlhni, “Inyalh 'ink'ez dája nyudúsni 'uhonleh. Saul 'utahaílhti ho' 'int'ah, suba' tet'ilh 'et wheni. 'Udun yun k'ut whut'en, hubudayi cho, 'ink'ez Israel hits'uh hainde chah ts'iyawh si sugha t'ehonózin 'et whúbuntelhtun 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","'Et 'ink'ez njan si sugha dahóolhcho whe dzuh nutezut 'et whuntelhtun.” ");
INSERT INTO cafNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","'Et Ananias whuz whenya 'ink'ez koo danínya hoh Saul yuk'édilnik 'ink'ez ndutni, “Saul, sulhutsin, neMoodihti sutelh'a, Sizi dich'oh, ndez ínyalh hoh ti nyeghah be hóodilts'ai, 'en sutelh'a whe'en naoondle 'ink'ez Ndoni nyudóolts'it ka.” ");
INSERT INTO cafNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","'Et 'ahoh hoonliyaz dugoos li'int'ah, 'i Saul buna k'eháyankat, 'ink'ez 'ahoh whe'en nasdli. Didinya 'ink'ez too bé' 'ulya. ");
INSERT INTO cafNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","'Et hukw'elh'az 'an'al 'ahoh ulhtus nasdli. 'Et Saul, ndunnah Sizi yugha hoodul'eh 'en dzuh sayaz Damascus 'et hubuzih inda. ");
INSERT INTO cafNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","'Et 'ahoh Lizwif hubuluglez ts'ih danínya 'ink'ez Christ bugha hubulh yáwhenilhtuk, “En Yak'usda buYe' 'int'ah,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ndan hiduzts'ai ts'iyawh huba hooncha 'ink'ez 'ulhahudutni, “Ndun dune Jerusalem 'en ndi yoozi be yahalhtuk, 'en hubanghan 'en 'int'ah 'ink'ez 'et huwa zeh ndez ninya ndunnah hubutélhchulh 'ink'ez náwhulnuk moodih ts'ih nábutelelh 'et wheni.” ");
INSERT INTO cafNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","'Et whunts'ih Saul bughunek 'o nus ulhtus hoh dune hubulh yalhtuk 'ink'ez Sizi 'en Christ 'int'ah ts'ah'un huba 'álha' hoont'ah hubulhtsi k'et, Lizwif Damascus whut'en 'aw dája hidooni ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","'Et lhat dzin inle hoh Lizwif 'ilhúhowezdel 'ink'ez Saul nts'e na'a hituzelhghelh hubugha wheni lhahóduleh. ");
INSERT INTO cafNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Dzin 'ink'ez 'ulh'ek ibulh njan keyah hukwuti 'ahoolhyez huwu hinli hituzelhghelh ka, 'et whunts'ih Saul dahítelilh 'et nt'eoonanzin. ");
INSERT INTO cafNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","'Et 'ilhuh 'ulh'ek Sizi yugha 'eh, 'en Saul hiyílhchoot 'ink'ez keyah whunasú'a, 'i bukoni'a, whuz hukwa hínilhti 'ink'ez k'its'ai cho be híyalhti 'ink'ez yoo 'az ts'ih nahíyalhbal. ");
INSERT INTO cafNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","'Et Saul Jerusalem ts'ih ninya 'ink'ez Sizi yugha hoodul'eh hubuts'un nidooya hukwa' 'ut'en, 'et whunts'ih 'en 'aw Sizi yugha hoodul'eh 'int'ah cha'hunizun, 'ink'ez tube hiyé nuljut. ");
INSERT INTO cafNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","'Et Barnabas yughu ninya 'ink'ez yula 'uja hoh whel'a 'en yughi nilhti 'ink'ez hubudáni dája hoh Saul ti uyalh hoh neMoodihti i'en 'ink'ez yulh yaílhtuk chah 'uja. 'Ink'ez ndo búlhni dat'en hoh 'aw chaníljut hoh Damascus whut'en Sizi boozi bugha hubulh yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","'Et Saul hubuzih nitl'adenda 'ink'ez Jerusalem nduhoolhcho hoh neya, 'aw chaníljut hoh neMoodihti Sizi boozi bugha Yak'usda bughunek be hubulh yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ndunnah Lizwif, Greek k'eyahulhtuk, 'en chah hubulh yálhtuk 'ink'ez hubulh hukw'u náhulhye, 'et whunts'ih hizoolhghelh hukwa' hiyulh'en. ");
INSERT INTO cafNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","'Et whunts'i huba 'alha' hoont'ah náhuhoo'ai t'eh, Saul keyah Caesarea ts'un buch'a whehiyalhti. 'Ink'ez dukeyah Tarsus huwhútni whuz whehíyalh'a. ");
INSERT INTO cafNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","'Et ndulhcho Judea, Galilee, 'ink'ez Samaria bulh Sizi ba 'ilhúhowezdel 'aw dzuh nulhahuldeh hoolah. 'Et hoh huba hoonzoo hoh lhódezut 'ink'ez chah Ndoni bugha huba 'alha' hoont'ah ulhtus úbulhtsi. 'Et huwa 'o nus lhanah huzdli 'ink'ez neMoodihti zeh hudélhti suli. ");
INSERT INTO cafNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","'Aw 'et Peter soo ndulhcho hoh nuya. 'Et keyah Lydda dune Yak'usda bube'ildzun, 'en 'et hudelhts'i, ");
INSERT INTO cafNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","'en buts'un nuya hoh 'ilhunuh dune, Aeneas hiyúlhni, yughu ninya. 'En lhk'udit naoodezulh (8) whuts'un déchadusnik 'ink'ez sulhti zeh 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","'Et Peter 'uyúlhni, “Aeneas Sizi Gri soo na'unyinla! Dinadindaih 'ink'ez nyukw'usti k'ut soo ná'hoonleh,” yúlhni. 'Ahoh Aeneas didinya. ");
INSERT INTO cafNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ndunnah keyah Lydda 'ink'ez Sharon huwhutni whut'en ndun dune Aeneas hiya'en hoh ts'iyawh neMoodihti hits'u nalhíya. ");
INSERT INTO cafNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","'Et keyah Joppa huwhútni 'ilhunuh ts'eke 'et whut'en, Tabitha hiyulhni. 'En buba 'alha' hoont'ah. Boozi Greek k'una'a “Dorcas” hiyúlhni, 'et “Yests'e” ni hoh 'utni. 'En 'ahoolhyez hoonzoo túne'ut'en, 'ink'ez tel'ennah chah la'ut'en. ");
INSERT INTO cafNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","'Et hoh da nduda suli 'ink'ez dazsai. Buyust'e toonáhiyulhti 'ink'ez huwhut'i 'et dúlhya 'et nehinílhti. ");
INSERT INTO cafNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Joppa, Lydda whuts'un 'aw chanilhdza, 'et Sizi yugha hoodul'eh, Peter, Lydda usda whulh 'úhudants'o nanah dune, 'en whuz wheoobahalh'a, “Soo 'a nets'ínyalh!” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","'Et 'ahoh Peter lhadúja 'ink'ez hubulh whenát'az. Whuz ninya hoh ndoh dune whut'i dulhyah ts'ih, whuz whenya. Ts'iyawh tsandelh higha wézdel, hutso hoh ndun ts'eke, Dorcas hiyúlhni, khuna da dzoozt'an 'ink'ez dzoot chah huba 'uyalh'en, 'i hinalhts'et nihíyule. ");
INSERT INTO cafNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","'Et Peter ts'iyannah 'az whenaóobalh'a, dugwútsi be nenínya 'ink'ez tenadudli. Nyoo buyust'e yuts'un nalhú'a 'ink'ez 'utni, “Tabitha, didinyih!” 'Et yutá'en ibulh Peter yutelh'en hoh 'ahoh nduk ninatl'adenda. ");
INSERT INTO cafNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","'Et Peter yula ilhchoot 'ink'ez didílhya. 'Et dune Yak'usda bube'ildzun, 'en tsandelh tubulh, hubuka' dani 'ink'ez khuna hoh hubutl'anaiyalhti. ");
INSERT INTO cafNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","'Et Joppa dulhcho hoh njan whulh 'úhudants'o hoh lhanah neMoodihti huba 'álha' yint'ah suli. ");
INSERT INTO cafNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","'Et Peter, Simon 'uzuz 'úlh'en, 'astl'iyaz yuzih inda. ");
INSERT INTO cafNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Caesarea 'et 'ilhunuh dune Cornelius hiyúlhni 'et usda. Roman nehughan, 'en, “Italy hudedoh” hubuhútni, 'en ndun bumoodih unli. ");
INSERT INTO cafNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","'En teni' nilhdzun dune unli, 'ink'ez Yak'usda yénuljut 'int'ah. Didut 'ink'ez bukoo hudelhts'i ts'iyawh Yak'usda zeh hídelhti. Lizwif tehel'en, 'en chah tube hubula 'ut'en 'ink'ez 'ahoolhyez Yak'usda ts'un tenadudli. ");
INSERT INTO cafNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Dzetniz hukw'elh'az, 3:00 bat'en, 'et 'uja hoonliyaz bunalh hawhelts'ut. 'Et soo ts'ah'un Yak'usda hubulizas 'ilhunuh 'en danínya 'ink'ez, “Dahooja Cornelius,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Tube hubugha ha'nejoot hoh lizas yunilh'en 'ink'ez, “Dáhooja?” yúlhni. 'Et lizas utni, “Yak'usda ntenadudli yudánts'o, 'ink'ez nye 'ugha té'nezih chah unzoo, 'et huwa Yak'usda nyunalnik. ");
INSERT INTO cafNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","'Aw 'et Joppa ts'ih 'ilhunuh dune Simon, 'en Peter chah hiyúlhni, 'en bukunáwhulh'a. ");
INSERT INTO cafNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ndun dune, 'uzuz 'úlh'en, 'en chah Simon hiyúlhni, yatoo taba whut'i, 'en zih usda, 'ink'ez daténilh, 'et hubugha nyuduténilh.” ");
INSERT INTO cafNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","'Et hukw'elh'az ndun lizas yulh yaílhtuk whenádede hoh Cornelius nanah bukoo 'uhut'en, dich'oh budune, 'ink'ez 'ilhunuh nehughan, 'en soo Yak'usda zeh délhti, 'en chah dich'oh yunat ne'út'en taháyalhti. ");
INSERT INTO cafNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Daja hubugha ts'iyawh hubudáni 'ink'ez Joppa ts'un whébalh'a. ");
INSERT INTO cafNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","'Et 'om bun dzin ndunnah tanah keyah Joppa 'aw 'et wheghah hedulh, 'et wheghah whezulh hoh Peter 'en chah Joppa usda hoh, dzetniz bat'en 'et nduk bun k'ut whuz hukw'eínya tenadutedli 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","'Et Peter buye'élts'ul, 'ute'ulh hukwa' ninzun. Ts'uyi lhahíduleh whutah, 'et hoonliyaz bunalh hawhelts'ut. ");
INSERT INTO cafNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nduk yaz ts'ih lhch'az 'úhooja 'ink'ez nalhti cho ndult'ah, 'i dit lhch'az bunedest'uk, 'i t'az ndus de haímbal, 'ink'ez yun ninimbal. ");
INSERT INTO cafNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","'I bet 'et khunai lhelhyoo dedowh, 'i tl'ughus, 'ink'ez yinkak dut'ai chah, 'i ts'iyawh yedelhts'i. ");
INSERT INTO cafNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","'Ink'ez, “Peter didinyih, 'inghan, 'ink'ez 'in'alh,” whutni. ");
INSERT INTO cafNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","'Et whunts'ih Peter ndutni, “SMoodihti ndi khunai, ‘Me’ ts'útni buch'a 'unenjoot ho' 'int'ah, 'et huwa 'aw wus'alh ghaít'ah!” ");
INSERT INTO cafNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","'Et doo chah zeh 'uwhútni, “Ndai Yak'usda in'alh nyulhni t'eh, 'i 'aw, ‘Me 'int'ah,’ dini ilah!” ");
INSERT INTO cafNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Soo tat whucho 'et njan bunalh hawhelts'ut 'ink'ez ndi naímbal inle, 'i nduk whenalts'ut. ");
INSERT INTO cafNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","'Et Peter njan bunalh hawhelts'ut, 'et dawhút'en ho' whut'en, 'et huwu nuní nuzut hoh 'ink'ez ndunnah Cornelius whuz whebalh'a nts'e Simon bukoo 'et t'ehonanzin 'ink'ez hukwuti 'et nahudelhúya. ");
INSERT INTO cafNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Hahuhuyih 'ink'ez 'uhoodulhkut, “Aw ih Simon, 'en Peter chah hiyúlhni, njan chaidah?” ");
INSERT INTO cafNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","'Et Peter 'awhuz njan ho'en beni taóodoolts'it hukwa' 'ut'en hoh Ndoni 'uyúlhni, “Oozélhts'ai, njan tanah dune, 'en nkahites'en. ");
INSERT INTO cafNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dinadindaih 'ink'ez nyuk naíndalh. 'Aw mba dahot'e gunih hubulh 'útanilh, si whuz whebalh'a ho' hut'en,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","'Et Peter nanája 'ink'ez ndunnah dune ndo búlhni, “Si 'ust'ah, dune bukaitéh'en. Di ka ndez tehdel?” ");
INSERT INTO cafNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","'Et 'uhiyúlhni, “Nehughan moodih, Cornelius, 'en netélh'a ho' ts'ut'en. Dune unzoo 'ink'ez 'ahoolhyez Yak'usda ts'un ténadudli, Lizwif chah ts'iyawh hidélhti. Yak'usda bulizas 'ilhunuh 'en bukoo ts'ih nka' doni yulhni, 'ink'ez dája dutenilh 'et nyootuzélhts'ilh wheni.” ");
INSERT INTO cafNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","'Et Peter koo daóobuninla 'ink'ez 'et hantez. 'Et 'om bun dzin lhadúja 'ink'ez hubúlh nátest'az hoh bulunah huba 'alha' hoont'ah Joppa whut'en, 'en chah hubulh lhghu nahudidel. ");
INSERT INTO cafNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","'Et 'om bun dzin Caesarea ts'ih ninya. 'Et Cornelius yubalh'i, bukoo hudelhts'i 'ink'ez bulh dunekah chah, “Anih,” hubudáni. ");
INSERT INTO cafNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Soo Peter bukoo ts'ih tezya hoh Cornelius yududezya 'ink'ez yubut nacháneti. ");
INSERT INTO cafNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","'Et Peter, “Dinadindaih. 'Ants'ih hoh dune 'ust'ah,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","'Et bukoo ts'ih hute'us whuts'un Peter, 'en Cornelius bulh yálhtuk zeh 'utni, 'ink'ez bukoo ts'ih huni'az hoh lhanah dune 'ilhúhowezdel 'et hubunilh'en. ");
INSERT INTO cafNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","'Et ndo búlhni, “Nuhwhenich'oh soo cho t'éoonáhzun, Lizwif whuch'a' hunenyoot 'udun yun k'ut whut'en bukoo dats'óoya 'ink'ez hubulh né'ts'oot'en huba cha'hóot'ah. 'Et whunts'ih, Yak'usda whusúnelhtan 'aw 'uyoon dune ‘Me’ suba hinli doosni ghaít'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","'Et huwa skunaóozulh'a hoh 'aw 'uts'un cha'dusnil hoh nuhts'u whúsaya. 'Et nuhóodulhkut di ka 'ahja skunaóozulh'a?” ");
INSERT INTO cafNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","'Et Cornelius utni, “Et ndoh wheghah whezulh bat'en tat dzin inle hoh dzetniz hukw'elh'az 3:00 bat'en 'uk'e' hunint'o hoh sukoo sahá'delhuya, 'ink'ez tenadesdli hoh khunyaz dune naih soo lheyul, 'i be usda, ");
INSERT INTO cafNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","subut suyin 'ink'ez 'usúlhni, ‘Cornelius, Yak'usda ntenadudli yudánts'o, 'ink'ez whunalnih nts'ena'a dune ba teni'nilhzun. ");
INSERT INTO cafNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","'Aw 'et Joppa ts'ih 'ilhunuh dune Simon, 'en Peter chah hiyúlhni, 'en bukunáhoolh'a. Ndun dune 'uzuz 'ulh'en, 'en chah Simon hiyúlhni, yatoo taba whut'i, 'en zih usda, 'ink'ez whusaínya t'eh nyulh yátelhtuk,’ 'et njan lizas ndusúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","'Et huwa 'ahoh nka whenahólh'a, 'ink'ez soo 'inja nets'u whúsainya. 'Ink'ez njan 'aw 'et ts'iyawh Yak'usda bulh 'úts'int'ah mba ts'ilh'i dája neMoodihti huwá nyulh'a bugha nelh yátalhtuk.” ");
INSERT INTO cafNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","'Aw 'et Peter yawhénilhtuk hoh ndutni, “Soo ts'ah'un t'éooneszin 'et 'álha' hoont'ah 'ilho lhgha Yak'usda nenilh'en. 'Aw 'ilhunuh dune 'o nus yuts'u dutnik hoolah. ");
INSERT INTO cafNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ndunnah ndi yun k'ut Yak'usda zeh delhti 'ink'ez tink'us 'utet'ilh whénuljut, 'en Yak'usda buka' dani nts'oh 'udun yun k'ut whut'en 'et whunts'ih. ");
INSERT INTO cafNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Israel hubuts'uh huhanzut hubulh 'údahts'o dahúja hoh khunek unzoo, 'i butl'aidélts'ut 'ink'ez Sizi Gri, 'en bugha, dahúja hoh ndi khunek unzoo, 'i be hubudzi dinghel, 'en ts'iyannah dune buMoodihti unli ho' 'int'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","'Ink'ez chah Israel hubuts'uh huhanzut bukeyah ndulhcho hoh nts'oh teh hooncha tune' whust'en, ndet John too be' ts'ul'ih huwu yailhtuk hoh Galilee 'et whuts'un ho' whe'dit'en, ts'iyawh t'éoonáhzun. ");
INSERT INTO cafNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","T'enahzun Sizi, Nazareth whut'en, 'en daja hoh Yak'usda, Ndoni 'ink'ez be ts'ílhtus, 'i chah ye yudá'ai, 'et huwa ndulhcho nuya hoonzoo tune'út'en 'ink'ez ndunnah netsudule k'une' bul'en 'en chah soo na'bulh'en, Yak'usda, Sizi yulh 'int'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Lizwif bukeyah nts'oh tuné'ust'en t'ets'onínzun, nenalh 'úwhet'en 'ink'ez Jerusalem 'et lhdulalhgus ye híndunilht'o hoh hizelhghi. ");
INSERT INTO cafNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","'Et whunts'ih, whulh tat dzin 'et Yak'usda nahiyílhna 'ink'ez nenalhts'et neya yulhtsi, ");
INSERT INTO cafNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","dune ts'iyawh ilah, wheni zeh ndunnah nenalh 'úwhet'en Yak'usda 'utahanenla ínle. Dinadija hukw'elh'az bulh 'uts'a'al 'ink'ez bulh 'uts'étnai inle. ");
INSERT INTO cafNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","'Et huwa ndi khunek unzoo, 'i dune be hubulh yáts'oolhtuk, huwa nélh'a 'ink'ez 'et 'uzdooni Yak'usda, Sizi 'en 'utahayálhti dune yaidla 'ink'ez khuna chah huba nahooyeh ka. ");
INSERT INTO cafNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yak'usda be nus whúnilh'en, 'en ts'iyawh highu yailhtuk ndunnah huba 'alha' hoont'ah Sizi Gri 'en bugha bulubeshi huba 'ún yutelhdulh.” ");
INSERT INTO cafNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","'Et Peter 'awhuz yalhtuk hoh ndunnah yoozélhts'ai Ndoni hubuyídelts'ut. ");
INSERT INTO cafNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ndunnah Lizwif huba 'alha' hoont'ah, Peter bulh whusahandel, huba hooncha 'uhooja hoh 'udun yun k'ut whut'en whunts'ih Ndoni buts'ó tl'aidelts'ut 'ink'ez buyidélts'ut. ");
INSERT INTO cafNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","'Ink'ez 'en khunek whutsuh da t'ehinízun, 'i be yawhehúnilhtuk Yak'usda hidélhti hoh hubudíts'o. 'Ink'ez 'et Peter huboodulhkut, ");
INSERT INTO cafNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ndunnah, 'en chah wheni nek'una'a Ndoni buyidélts'ut. Ndunnah too be' telnilh t'eh, ndan dah dutenilh?” ");
INSERT INTO cafNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","'Et huwa khunek hubugha óoni'ai neMoodihti boozi bugha too be' hutelnilh. 'Et hukw'elh'az Cornelius, Peter yughu tedudlih 'astl'iyaz yuzih wuda ka. ");
INSERT INTO cafNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","'Et whel'a, 'en 'ink'ez ndunnah huba 'alha' hoont'ah, 'en Judea ndulhcho hoh 'udun yun k'ut whut'en, 'en chah Yak'usda bughunek hiyílhchoot 'ink'ez hits'un nalhúya 'et whulh úhudants'o. ");
INSERT INTO cafNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","'Et Peter, Jerusalem ts'ih ninya, bulunah Lizwif huba 'alha' hoont'ah Peter hiyenah 'uhutni, ");
INSERT INTO cafNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Udun yun k'ut whut'en, Lizwif chailah, 'en hubuzih hoont'i 'ink'ez hubula 'an'al chah 'inja inle,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","'Et Peter ndulhcho hoh 'udechoo whuts'un bulh dahooja hubugha ts'iyawh hubulh náwhelnuk. ");
INSERT INTO cafNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Keyah Joppa 'et tenadusdli hoh hoonliyaz sugha ha whelts'ut, nalhti cho dit bunedest'uk, 'i ndus de haímbal 'ink'ez suzih nenimbal. ");
INSERT INTO cafNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Soo cho nulh'en hoh khunai lhelhyoo dédowh hoh tl'ughus, 'ink'ez yinkak dut'ai chah, 'i yedelhts'i nulh'en. ");
INSERT INTO cafNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","'Ink'ez khunyaz khunek duzíts'ai 'i 'utni, ‘Peter didinyih, 'inghan, 'ink'ez 'in'alh,’ whutni. ");
INSERT INTO cafNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","'Et whunts'ih, ‘SMoodihti 'awundooh, ndi khunai ‘Me’ ts'útni, buch'a 'unenjoot ho' hoont'ah, 'et huwa 'aw wus'alh ghaít'ah,’ dusni. ");
INSERT INTO cafNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","'Et doo chah zeh ndus de 'úwhutni, ‘Ndai Yak'usda in'alh nyulhni, 'i 'aw, ‘Me 'int'ah,’ dini ilah!’ ");
INSERT INTO cafNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Soo tat whucho 'et njan bunalh ha whelts'ut 'ink'ez ndi naímbal inle, 'i nduk whenalts'ut. ");
INSERT INTO cafNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","'Et wheghah whezulh whuzeh, tanah dune Caesarea whuts'un suts'ú botelh'a, 'aw 'et koo sida ts'ih hunindel. ");
INSERT INTO cafNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","'Et Ndoni 'usúlhni, ‘'Aw buch'a 'uts'un cha'duzinih hoh hubulh í'us.’ 'Ink'ez ndunnah lhk'utánah (6) huba 'alha' hoont'ah, 'en chah Caesarea ts'ih sulh hútezdel 'ink'ez ts'iyawh Cornelius bukoo ts'ih dáznindel. ");
INSERT INTO cafNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","'Et nedáni ndun lizas bukoo siyin hoh yunilh'en 'ink'ez 'uyúlhni, ‘Joppa ts'ih whuz ndun dune Simon Peter hiyúlhni, 'en bukunáhoolh'a. ");
INSERT INTO cafNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","'En ndun whuduténilh datéhnilh 'et hoh nyun 'ink'ez nkoo hudelhts'i chah hudutejih.’ ");
INSERT INTO cafNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","'Aw 'et yawhénilhtuk hoh, 'udechoo nuwheni lhe'ts'uja, whuz na'a 'en chah Ndoni hubuyídelts'ut. ");
INSERT INTO cafNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","'Et whunalhúnih nts'ena'a neMoodihti 'et ndutni inle, ‘John dune too be 'ulh'en, 'en too be, too be' 'un whulh'en inle, 'et whunts'ih Ndoni 'en be too be 'un whutelilh.’ ");
INSERT INTO cafNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","'Et 'alha' hoont'ah wheni danénla inle Sizi Gri neba 'alha' 'int'ah suli hoh Yak'usda hoonzoo negha óoni'ai, ndunnah 'udun yun k'ut whut'en, 'en chah whuz na'a 'obínla. Ndan usdli ka suba Yak'usda buch'a doosni?” ");
INSERT INTO cafNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","'Et ndunnah Jerusalem huba 'alha' hoont'ah hodánts'o hoh Peter hich'a yálhtuk 'ustl'e' 'uhudeja 'ink'ez 'en chah Yak'usda hidelhti. 'Ink'ez njan nduhútni, “Udun yun k'ut whut'en, 'en chah hubulubeshi whuch'a hububeni lht'anahídunezdla, 'ink'ez 'ilhuz hukhutena. 'Et whuz na'a Yak'usda hubugha óoni'ai,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stephen hizelhghi hukw'elh'az ndunnah Yak'usda k'une' hut'en hube húzula, 'et whula gha ts'ih ts'iyawh lhch'a huzdel. 'Et bulunah nilhza Phonecia ts'ih, Cyprus 'ink'ez Antioch ts'ih chah whehándel. Ndi khunek unzoo, 'i ndunnah Lizwif 'aw 'en zeh be hubulh yahúlhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","'Et whunts'ih bulunah huba 'alha' hoont'ah dune noo cho Cyprus hiyúlhni, 'ink'ez Cyrene ts'ih hahándel, 'en Antioch ts'ih whehándel 'ink'ez 'et 'udun yun k'ut whut'en, ndunnah Greek hubughunek k'una'a yahalhtuk, 'en Sizi neMoodihti 'en bugha ndi khunek unzoo hubulh yahúlhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","NeMoodihti hiye úlhtus, 'i bugha íni'ai, 'et hoh lhanah dune neMoodihti bughunek hílhchoot 'ink'ez hits'u nalhúya. ");
INSERT INTO cafNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","'Et Jerusalem huba 'alha' hoont'ah, 'en whulh 'úhudants'o, 'et Barnabas 'en Antioch ts'ih whehíyalh'a. ");
INSERT INTO cafNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","'Et whuz ninya whunilh'en daja hoh Yak'usda ndunnah dune ye unzoo, 'i be hubuts'un unzoo. 'Et hóost'et 'ink'ez huba nus whúnilht'uk, “Nts'oh dáhoont'ah 'et whunts'ih neMoodihti soo bulh zeh 'ooht'e,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas 'en soo Ndoni yudínda 'ink'ez tube dune buba 'álha' hoont'ah. 'Ink'ez lhanah dune neMoodihti hits'u nalhúya. ");
INSERT INTO cafNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","'Et Barnabas keyah Tarsus ts'ih whenya Saul 'en yukúnuta. ");
INSERT INTO cafNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","'Et nayilhti 'ink'ez Antioch ts'ih nainílhti. 'Et 'ilhuh naoodezut hoh nahúlt'ah dune Sizi Gri yugha hoodul'eh hubutah lhanah dune whehubahoodalh'i. 'Ink'ez Antioch 'et Sizi Gri yugha hoodul'eh, 'en 'udechoo Sizi Gri budune hubuhútni. ");
INSERT INTO cafNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","'Et hoh da zeh Yak'usda be nus whúnilh'en Jerusalem whehúdindel hoh Antioch ts'ih húnindel. ");
INSERT INTO cafNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","'Et hubutah 'ilhunuh Agabus hiyúlhni, 'en didinya 'ink'ez Ndoni bugha hubúlhni, “Aw 'et nilhdukw yun k'ut ndulhcho hoh dai whútele.” 'Et Claudius hubudayi cho degha nus dezti unli hoh 'et ndúhooja. ");
INSERT INTO cafNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","'Et Sizi Gri yugha hoodul'eh lhgha 'úhudeja hoh, 'ilhunuh hinli hoh hubulh huba 'alha' hoont'ah, Judea hudelhts'i, ndet 'úhint'ah hoh hubula' hutet'ilh hutni. ");
INSERT INTO cafNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","'Et nduhúja hoh, Barnabas 'ink'ez Saul bulh ndi sooneya hubutl'ahínudzih hoh hubuhútni, “Ndi sooneya nelh huba 'alha' hoont'ah be hubúla'teht'ilh, dune tsuh whudelhdzulh hubutl'ayóoh'alh.” ");
INSERT INTO cafNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","'Et hoh da bat'en hubudayi cho Herod ndunnah huba 'alha' hoont'ah hube' zúla suli. ");
INSERT INTO cafNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","'Et James, John bulhutsin, 'en tes cho be hízelhghi. ");
INSERT INTO cafNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","'Et Herod nt'eoonanzin Lizwif huhóont'i hoh honilh'en, 'et Peter 'en chah tsak'ehiya'ai, lhes nachantildoh, 'i ut'alh whehúnahulnih, 'et 'uhooja inle. ");
INSERT INTO cafNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","'Et Peter hiyílhchoot hukw'élh'az, tsak'ehiya'ai huwunli dinah nehughan lhk'enáhudedulh, 'en highole ka hubutl'ahíyalhti. Njan Hubutus Lhuseya hukw'elh'az ts'iyannah nalh hiyootélhzih 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","'Et Peter tsak'ehiya'ai 'et whunts'ih huba 'alha' hoont'ah soo ndet 'úhint'ah, 'et hiba tenadudli. ");
INSERT INTO cafNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","'Aw 'et Peter 'en Herod yubut niteyalh whutsuh, 'ulh'ek 'et Peter nanah highunli 'en tes be lhughel hoh hube guz nanesti, 'ink'ez hukwuti 'et chah nanah nehughan huwuhinli. ");
INSERT INTO cafNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Khunyaz neMoodihti bulizas bughah be hóodiltsai, bukoo chah whét'en suli. 'Et lizas Peter 'ún be yulhnih hoh ts'enainílhzut 'ink'ez, “Soo 'ah didinyih!” yúlhni. 'Et 'ahoh ndi tes tl'ool be lhúghel, 'i bula buts'u hayánkat. ");
INSERT INTO cafNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","'Et lizas, “Tsunadil'ooh 'ink'ez ke nadil'ooh chah 'ineh,” yúlhni. 'Et Peter ndúja 'et lizas, “Nyunaits'uz chah t'unásilchoos, 'ink'ez sunanyalh,” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","'Et Peter tsak'ehiya'ai hubughu téninya 'ink'ez yuneyalh, 'aw nt'éhonízun dat'en ndun lizas 'alha tulih 'int'ah k'us 'ants'ih hubunalh hawhélts'ut ninzun. ");
INSERT INTO cafNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","'Udechoo huwuhinli zih lhunáhust'az, 'et whulh nat chah. 'Et tes dádentan, 'i cho keyah dati huwa ni'az hoh dich'oh ndi dati huba da'dutezkez. 'Et tináhant'az 'ink'ez ti hutez'az ibulh lizas hoolah suli. ");
INSERT INTO cafNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","'Et Peter beni nawhusdli 'ink'ez 'uninzun, “Aw 'et nt'eoonazin 'alha' hoont'ah, neMoodihti bulizas whusayálh'a 'ink'ez Herod Lizwif tubulh dzuh nusátelhzut, 'et whuch'a sulhyih.” ");
INSERT INTO cafNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","'Et njan huwu ninínizut hoh Mary bukoo 'et howu ninya, 'en John Mark be'ama. 'Et lhanah dune 'ilhúhowezdel 'ink'ez tenahudedli. ");
INSERT INTO cafNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","'Et Peter yoo 'az ts'ih ndati whudulhghalh hoh ts'ekeyaz 'et 'ut'en, Rhoda 'en hiyúlhni, 'et ndati ninínya hoh yudánts'o. ");
INSERT INTO cafNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","'Et 'ahoh Peter 'utni natsíyoodelhúts'it hoh hóont'i k'et, 'aw dacha'dutítil 'ink'ez 'ants'ih koo danálgai 'ink'ez, “Peter ndati siyin!” húbulhni. ");
INSERT INTO cafNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Nyeni hoolel hoh 'udini,” hiyúlhni. 'Et whunts'ih, “Alha' dusni,” ni zeh 'utni hoh, “Awundooh, bulizas 'ut'en,” hutni. ");
INSERT INTO cafNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","'Et whutah Peter ndati whudulhghalh zeh 'utni. 'Udek'elh'az hoh hiba da'duteztan, tube huba hooncha hitelh'en hoh. ");
INSERT INTO cafNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","'Et huba núlhni hoh t'ehudoosnih hubúlhni 'ink'ez huba hukw'u nuhúlhye daja hoh neMoodihti tsak'ehiya'ai hoh tenaínilhti. “James 'ink'ez 'o 'unnah huba 'alha' hoont'ah ts'iyawh hubudóohni,” hubúlhni. 'Aw 'et 'uts'un hubughu whenája. ");
INSERT INTO cafNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","'Et bundada nehughan huwuhinli Peter hik'énentai hoh whewhunujut whe lhtahúwhunt'ai, “Peter 'en dája,” lhahudútni. ");
INSERT INTO cafNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","'Et Herod, “Peter hikunoota,” hubúlhni. 'Aw nahayólhtelh ghaít'ah 'et ndunnah yughinle hubuhoodalhkut 'ink'ez, “Huboohooghan,” hubúlhni. 'Et hukw'elh'az Herod, Judea ts'ih whenya 'et whuts'un Caesarea ts'ih chah 'ét'en. ");
INSERT INTO cafNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","'Et ndunnah nat keyah Tyre 'ink'ez Sidon whut'en, 'en Herod tube cho hubulh húnilch'e, 'et lhanah hinli Herod highu nindel. Ndun Blastus 'en hubudayi cho bukoo yuba huwunli, 'en ts'ún nehidelti. 'Et 'ants'ih Herod highu nindel 'ink'ez huba soo' hooleh hits'u húkwa' 'utni, hubudayi cho bukeyah ts'ih whuz de zeh hiya'alh, 'i whuz hakat 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","'Et dzin huba hoozi Herod 'et hubudayi cho naih yé naja 'ink'ez kw'uts'uzda buba yint'ah, 'i yuk'etl'adida. 'Et whuts'un dune hubulh yálhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","'Et ndunnah dune 'ahúlzul hoh hahuyih, “Aw dune ilah 'int'ah yalhtuk, Yak'usda unli 'utni!” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","'Et Herod 'aw Yak'usda chadílhti, 'et huwa Yak'usda bulizas khunyaz Herod nduda yulhtsi 'ink'ez 'usgoo yulh haneldo, 'et hukw'e dazsai. ");
INSERT INTO cafNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Yak'usda bughunek ndulcho hoh t'enudzun suli, 'ink'ez lhanah dune huba 'alha' yint'ah suli. ");
INSERT INTO cafNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas, Saul bulh 'uhuwhulh'en lhahódinla hoh, Jerusalem ts'ih hanáhedel, John Mark 'en dulh 'uhíyul'en. ");
INSERT INTO cafNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","'Et keyah Antioch Sizi bugha 'ilhuhowezdel bulunah Yak'usda be nus whúnilh'en 'ink'ez bulunah Yak'usda bughunek hubuhodulh'eh 'en chah 'et hudélhts'i. Ndunnah dune, 'en bulunah 'uhint'ah, Barnabas, 'ink'ez Simeon, 'en dune dulhgus hiyúlhni, Lucius chah, Cyrene whut'en 'int'ah, Manaen, 'en yun whu moodih, Herod yulh nézyi, 'ink'ez Saul chah 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Soo saha'húdelya 'ink'ez neMoodihti hiba 'út'en whutah, Ndoni ndo búlhni, “Barnabas 'ink'ez Saul bulh suba 'udun nébutalhtelh, ndi 'ut'en hubugha iní'ai, 'i 'uhiyooleh 'et wheni.” ");
INSERT INTO cafNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","'Et doo chah zeh soo saha'húdelya 'ink'ez tenahudedli hoh hubutsi k'ehudalnik 'ink'ez whébahalh'a. ");
INSERT INTO cafNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","'Et Ndoni hubutélh'a hoh Barnabas 'ink'ez Saul bulh Seleucia ts'ih hunindel, 'et whuts'un noo Cyprus hiyúlhni whuz huninki. ");
INSERT INTO cafNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","'Et keyah Salamis ts'ih hunindel hoh Lizwif hubuluglez 'et Yak'usda bughunek be yáhalhtuk. John Mark 'en chah bula 'ut'en 'et wheni dulh 'uhíyul'en. ");
INSERT INTO cafNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","'Et ndi noo ndulyez hoh hiye oosudel 'ink'ez Paphos ts'ih hunindel. 'Et ndun duyun, Joshua buye' hiyúlhni, Lizwif unli, 'en Yak'usda be nus whunílh'en la'dudil'i, 'en chah 'et 'usda. ");
INSERT INTO cafNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","'Ink'ez njan noo k'ut whumoodih, Sergius Paulus hiyúlhni, 'en dune whunih 'int'ah, 'en ndun duyun yulh dune unli. 'En Barnabas, Saul bulh, “Anih,” hubudáni Yak'usda bughunek dutéts'o hukwa' ninzun 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","'Et whunts'ih ndun duyun Greek bughunek k'una'a Elymas chah hiyúlhni, 'en Yak'usda bughunek yuch'a yunílht'uk 'et hukwa' yulh'en. ");
INSERT INTO cafNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","'Et Saul, 'en Paul chah hiyúlhni, Ndoni k'une' yul'en hoh soo cho yunen ts'ih yunilh'en ");
INSERT INTO cafNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","'ink'ez 'uyúlhni, “Netsudule buye', ndai unzoo, 'i ts'iyawh buch'a déntni. Soo hoontsi' hoh dune naní'ah ts'iyawh hoont'i, Yak'usda bughunek 'i chah whuts'it khunek naoolhtsilh hukwa 'ílh'en. ");
INSERT INTO cafNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yak'usda nyulh húnilch'e 'et hoh 'aw chaooza'en tanleh 'astl'iyaz wheni!” 'Et 'ahoh ndun Elymas, dulhgus, 'i buna k'eínde, 'ink'ez chawhés'en suli. 'Ink'ez dune yula t'az nítelhyalh hukwa hahuyih. ");
INSERT INTO cafNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","'Et noo k'ut whumoodih njan dahooja ho'en hoh, Yak'usda buba 'alha' yint'ah suli. Ndai neMoodihti bugha whehiyoodalh'i 'i tube huba hooncha. ");
INSERT INTO cafNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","'Et Paul 'ink'ez yulh nudelh tubulh Paphos 'et nus nihuzki hoh Perga 'et Pamphylia whuz'ai whuz huninki. 'Et John Mark buk'enaja 'ink'ez Jerusalem ts'un whenája. ");
INSERT INTO cafNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","'Et Perga whehúdindel hoh 'o 'un Antioch, Pisidia whuz'ai, whuz hunindel. 'Et Lizwif nahulyis dzin hubuluglez dahúnindel 'ink'ez nátl'ahudelts'i. ");
INSERT INTO cafNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moses bughunek 'uk'une'úsduguz, 'i 'ink'ez Yak'usda be nus whúnilh'en bughunek chah hik'eyailhtuk hukw'elh'az, Lizwif luglez whumoodih Paul, Barnabas chah, 'en hubuhútni, “Nelhutsinkah, khunek hiye úlhtus, 'i aht'i t'eh, ndunnah dune hubulh yátelhtuk hukwa' uzninzun.” ");
INSERT INTO cafNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","'Et Paul didinya 'ink'ez buts'un didílnik hoh hubulh yáwhenilhtuk 'ink'ez ndó bulhni, “Sulh dune 'ink'ez 'udun yun k'ut whut'en chah, k'us ndan Yak'usda delhti, 'en soo zelhts'ai. ");
INSERT INTO cafNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel hubuts'uh huhanzut buYak'usda 'en netsuh whudelhdzulh 'utaháoobanla 'ink'ez Egypt whut'en bunalh hincha hubulhtsi. 'Et hukw'elh'az Yak'usda whelhtus 'et hoh ndunnah Egypt whut'en bukeyah whuts'ahanaóobanla. ");
INSERT INTO cafNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","'Ink'ez dune chahóot'ih ts'ih 'et dit lanezi naoodezulh whutah, 'et hich'a ne'ut'en, 'et whunts'ih k'úne' bul'en hoh inle. ");
INSERT INTO cafNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","'Et skwunlai 'o 'at nat dédowh (7), 'en Canaan whuyun k'ut whuzdla, 'et hudelhts'i, 'en Yak'usda hoolah hubulhtsi, 'ink'ez 'et ndunnah budune, 'et bukeyah whulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","'Et 450 naoodezut whutah 'et dune hanle. 'Et hukw'elh'az Yak'usda be nus whunílh'en Samuel whusatéyalh whuts'un lhanah hoh bumoodih inle. ");
INSERT INTO cafNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","'Et hubudayi cho ka' hutni hoh, Saul, Kish buye', 'en Yak'usda bugha inílhti. 'En Benjamin yek'edínzut 'ilhunuh 'int'ah, 'ink'ez dit lanezi naoodezulh 'et hubudayi cho inle. ");
INSERT INTO cafNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","'Et Saul Yak'usda whusanáyalhti hukw'elh'az hoh 'et David 'en hubudayi cho yulhtsi 'ink'ez Yak'usda 'en yughi yalhtuk hoh ndutni, ‘David, Jesse buye', 'en sudzi k'ah ts'ih dune unli. Ts'iyaintsuk hoh suk'úne' tet'en ho' 'int'ah.’ ");
INSERT INTO cafNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Sizi, David yuts'uh haínzut, 'en Israel hubuts'uh huhanzut hubutelhyis wheni Yak'usda hubuts'ítelh'a hubuts'úyoozi inle 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","'Et Sizi whe'dutet'ilh whutsuh 'et John dune too be 'ulh'en Israel hubuts'uh huhanzut hubulh yálhtuk, lubeshi whuch'a hubeni náhondunoolelh 'ink'ez too be' hoolneh, hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","'Aw 'et John dune too be 'ulh'en dude 'ut'en lhai whutele hoh 'et hubúlhni, ‘Ndan usdli nahzun? 'Aw ndun buba ilh'i, 'en ílah 'ust'ah, 'et whunts'ih whunulh'en, sunteyalh ho' 'int'ah. Buke hana'tesdlelh 'et wheni whunts'ih 'aw huba soo cha'lhudzooh,” hubúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","'Et Paul 'o 'un ndo búlhni, “Sulhutsinkah, Abraham yekédinzut, 'ink'ez 'udun yun k'ut whut'en, ndunnah Yak'usda ts'un tenadudli, nuhwheni ts'iyawh, wheni chah, ndi khunek 'i netelhyis wheni nets'ó tl'adelts'ut. ");
INSERT INTO cafNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem 'et whut'i 'ink'ez k'une'nuwhuhul'en chah 'aw t'ehinízun neulhyis 'int'ah. Lizwif nahulyis dzin totsuk ndi Yak'usda be nus whunilh'en 'uk'une'úsduguz buk'eyatuk, 'et whunts'ih 'aw hubeni tachaoodulhts'it. Sizi datétsah ts'ih be' highenya, 'et huwa Yak'usda be nus whunilh'en bughunek 'alha' 'int'ah hiyulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","'Et 'aw hukwa hizoolhghelh hoolah, 'et whunts'ih Pilate 'en highu tédudli hizoolhghelh ka. ");
INSERT INTO cafNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","'Et ndi bugha 'uk'une'úsduguz, 'i dája ni hoh tune'hiyulh'en hoh lhdulalhgus k'ut nihinilhti, 'ink'ez wheyehíyalhti. ");
INSERT INTO cafNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","'Et whunts'ih Yak'usda yaidla tah nahighílhna. ");
INSERT INTO cafNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","'Et Galilee 'ink'ez Jerusalem whuts'un yúlh lhusudel, 'en hukw'elh'az lhat dzin whuts'un hiya'en. 'En Israel hubuts'uh huhanzut whébontelhtun hinli. ");
INSERT INTO cafNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","'Et wheni njan whusats'ándel khunek unzoo, 'i buk'unats'otelnuk. 'I Yak'usda netsuh whudelhdzulh, 'en buts'un datenilh ni, k'an wheni, buts'uh hats'ánde nenalh 'et 'en Sizi nahighílhna. 'Ink'ez ndi bulh nankoh Shun 'uk'une'úsduguz, 'i chah ndutni, ‘Nyun Si suYe' 'unint'ah, k'an dzin, nye'aBá síli,’ ni. ");
INSERT INTO cafNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","'Et Sizi nahighílhna 'ink'ez 'aw buyust'e telhjut ts'ih natoolts'it ghaít'ah. 'Et hubugha Yak'usda njan ndutni, ‘Ndai bugha 'ét'en unzoo, 'i David buts'un yóozizi inle, 'i k'an nuhgha tés'alh.’ ");
INSERT INTO cafNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","'Et 'udun 'uk'une'úsduguz, 'i chah ndutni, ‘Yak'usda 'aw dulh 'int'ah dezti buyust'e wulhjut ghaít'ah yulhtsi.’ ");
INSERT INTO cafNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","'Et David soo hoh Yak'usda k'úne' 'ust'en khuna whutah. 'Et dazsai hoh ndunnah butsuh whudelhdzulh 'uhudinla, 'et whuyihiyalhti 'ink'ez ílhjut. ");
INSERT INTO cafNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","'Et whunts'ih ndun Yak'usda nahighílhna, 'en 'aw buyust'e chaílhjut.” ");
INSERT INTO cafNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","'Et Paul 'o 'un ndutni, “Sulhutsinkah nuhwheni, ts'iyawh, 'alha' hoont'ah ndun Sizi dája 'et huwa nuhwhulubeshi nawhuná'dutedoh. 'Et t'ewhunóhzin ndai Moses ye náhezya, 'i bugha 'aw ts'ah'un dune tehle ghaít'ah inle. 'Et whunts'ih k'us ndan Sizi Gri huba 'alha' yint'ah, 'en hubulubeshi ts'iyawh hoolah huba whulhtsi hoh ts'ah'un dune tele. ");
INSERT INTO cafNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Huwahli ndet Yak'usda be nus whunilh'en huwu yahalhtuk, 'et nohwhulh 'uhóneh gunih! ");
INSERT INTO cafNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","'Et ndutni, ‘Ughuhedloh ndet huwú ni untehzut, 'ink'ez yatéhdlah. Ndi yun k'ut delhúts'i whutah, 'i lhk'uz teh whunwhunelhtan, 'et whunts'ih 'aw nuhwhuba 'alha hot'e ghaít'ah tele.” ");
INSERT INTO cafNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","'Et Paul, Barnabas bulh Lizwif luglez huwu nahutest'az hoh 'udun yun k'ut whut'en, “Nats'ulyis dzin t'eh nets'u nátooht'as, 'ink'ez doo chah zeh ndi khunek bugha yalhtuk, 'i bugha nelh yaóolhtuk,” hubuhútni. ");
INSERT INTO cafNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","'Et lhtahanahedel hukw'elh'az Paul, Barnabas bulh nahutest'az hoh Lizwif 'ink'ez 'udun yun k'ut whut'en, ndan Lizwif ts'ih nalhíya hiyuntezdel. 'Et Paul, Barnabas bulh, hubulh yahúlhtuk, “Yak'usda nuhts'un yé unzoo, 'i zeh bugha yinkak doolhúts'i,” hubuhútni. 'Et hoh budzi ulhtus hubuhulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","'Et 'o 'at nats'ulyis dzin 'ankw'us ts'iyawh keyah hudelhúts'i, 'en Yak'usda bughunek hiyootuzélhts'ilh wheni 'ilhuhowezdel. ");
INSERT INTO cafNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","'Et Lizwif 'ilhuhowezdel hubunilh'en, 'oonih zeh ye dezbun suli hoh Paul hiye dúdulh 'ink'ez hiba whuts'it. Daja ni, 'et chah whuch'a yáhalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","'Et whunts'ih Paul Barnabas bulh 'o nus hoolhtus hoh yahulhtuk, “Ndi Yak'usda bughunek 'i nuhwheni choo be nohwhulh yaóolhtuk huba' hoont'ah. 'Et whunts'ih bukacha'nuzáhzun t'eh, 'ink'ez 'ilhuz khutehna huba soo cha'lhudzooh na'dunáhdzun t'eh, 'ants'ih nuhwhuba 'uhoont'ah náhzun, 'et whute! 'Aw 'et 'udun yun k'ut whut'en, 'en buts'un tadút'us! ");
INSERT INTO cafNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","'Et ndi khunek 'i neMoodihti ye néts'u nahezya 'i 'int'ah, 'et njan ndutni, ‘Nuhwheni ndunnah 'udun yun k'ut whut'en be whét'en, 'i huba tehle. 'Et whuz na'a yun k'ut ndulhcho hoh chah nuhgha dune hudutejih,” ni, Paul. ");
INSERT INTO cafNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","'Et 'udun yun k'ut whut'en 'uhudánts'o hoh, huhoont'i hoh neMoodihti bughunek hiba whudélhti 'ink'ez ndunnah 'ilhuz khutena huba 'utahálya huba 'alha' hoont'ah suli. ");
INSERT INTO cafNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ndulhcho hoh 'et keyah neMoodihti bughunek nudúlts'ut suli. ");
INSERT INTO cafNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","'Et ndunnah dune hincha, 'ink'ez ndunnah ts'ekoo hincha soode'a 'uhint'ah, 'en, Yak'usda ts'un tenahududli hinli, bulunah Lizwif bughe' hoolnih 'uts'un húbonilht'uk hoh Paul, Barnabas bulh hube húzula suli, 'ink'ez dukeyah k'unabontezyoot. ");
INSERT INTO cafNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","'Et huwa 'et keyah whulez ch'a hubukegwun nahíyanghat 'ink'ez keyah Iconium ts'ih huni'az. ");
INSERT INTO cafNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","'Et Sizi yugha hoodul'eh Antioch hudelhts'i Ndoni be hilhtus súli 'ink'ez tube cho honélhnik. ");
INSERT INTO cafNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","'Et Iconium ts'ih huni'az hoh 'et chah nduhóoja. Paul, Barnabas bulh Lizwif luglez ts'ih huni'az hoh degha nus soo hubulh yáhalhtuk, 'et huwa tube lhanah Lizwif 'ink'ez 'udun yun k'ut whut'en chah Sizi huba 'alha' 'int'ah huzdli. ");
INSERT INTO cafNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","'Et whunts'ih ndunnah Lizwif be 'alha' hoont'ah chahiyílhchulh, 'en ndunnah 'udun yun k'ut whut'en hubeni 'uts'un hubunilht'uk hoh ndunnah huba 'alha' hoont'ah buch'a nahulhúya. ");
INSERT INTO cafNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","'Et whunts'ih ndunnah whel'a 'en sa 'et hanke. 'Aw chahuníljut hoh neMoodihti bugha hubulh yahúlhtuk daja hoh Yak'usda ndunnah dune ye únzoo, 'i be hubuts'un únzoo howu yahalhtuk. 'Et Yak'usda njan hooncha 'ink'ez huwa 'ét'en tuné'hut'en hubulhtsi. 'Et huwa bughunek 'alha' 'int'ah t'ehonínzun suli. ");
INSERT INTO cafNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","'Et keyah 'ilhohuwezdel bulunah, 'en Lizwif ts'un nihudendel 'ink'ez bulunah chah whel'a 'en ts'un nihudendel. ");
INSERT INTO cafNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","'Et 'udun yun k'ut whut'en, Lizwif chah, 'ink'ez k'une'nuwhuhul'en tubulh, whel'a 'en tenabe' whebonilh'en 'ink'ez tse be hubotuzelhghelh hukwa' huninzun. ");
INSERT INTO cafNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","'Et whel'a 'en whulh 'úhudants'o hoh, keyah Lystra 'ink'ez Derbe, Lycaonia hoh whuzdla, whuz buch'a whetsihalhdel, 'et whunat chah. ");
INSERT INTO cafNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Whuz khunek unzoo, 'i be hubulh yahúlhtuk Lystra 'ink'ez Derbe whut'en whel'a 'en khunek unzoo, 'i be hubulh yahúlhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lystra 'et 'ilhunuh dune buke déchadusnik 'et whut'i, 'en whuzdli whuts'un 'aw nuchasyah. ");
INSERT INTO cafNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","'Et usda 'ink'ez Paul yalhtuk yoozélhts'ai. 'Et Paul yunilh'en, t'éoonínzun ndun dune buba 'alha' hoont'ah 'et hoh soo ná'tetnilh ninzun, 'et soo cho yunen ts'ih yunilh'en hoh ");
INSERT INTO cafNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","soo 'ultus 'uyúlhni, “Didinyih 'ink'ez ts'ah'un na'a sinyin!” 'Et ndunnah dune didillhah 'ink'ez 'aw 'et nádinya. ");
INSERT INTO cafNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","'Et ndunnah 'ilhuhowezdel Paul daja hinilh'en hoh soo 'ultus hubughunek, Lycaonia k'una'a, 'uhutni, “Neyak'usda, 'en chah yinkak dune k'una'a 'uhint'ah huzdli 'ink'ez ndus de nets'un hahá'az.” ");
INSERT INTO cafNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabas 'en hubuyak'usda Zeus be náhiyoozi 'ink'ez Paul chah 'uyoon hubuyak'usda Hermes hiyúlhni, 'en be náhiyoozi, 'en yalhtuk 'int'ah 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Hubuyak'usda Zeus hiyúlhni 'en bunáwhulnuk, soo keyah yoo 'az ts'ih 'et luglez huwhulh'ai, 'en musdus dune 'ink'ez 'indak 'i keyah dati 'et nihíninla. Ndunnah 'ilhuhowezdel whel'a 'en hubuts'i hidutélhk'un 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","'Et Barnabas, Paul bulh 'aw 'et ndunnah dune dahútenilh whulh 'úhudants'o hoh, huba dzuh k'et dunaih k'uhídutelhúch'ul 'ink'ez 'ilhuhowezdel nus buniz 'et nihúlgai 'ink'ez soo 'ultus 'uhutni, ");
INSERT INTO cafNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Di ka 'et ndaht'en? Nuwheni chah nuhk'una'a dune ts'inli, 'aw Yak'usda chats'ílah ho' ts'int'ah. Njan khunek unzoo, 'i nuhghá uzte'alh 'et wheni whusaidút'az. Ndi be natsi' unli, 'i nuhyak'usda buch'a naóolhuyeh 'ink'ez Yak'usda khuna 'en buts'un naóolhuyeh. 'En 'int'ah yaz, ndi yun k'ut, yatoo chah, 'ink'ez ndai buk'ut hoonli, 'i ts'iyawh 'uyínla ho' 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","'Et whuts'uh da k'úne' hut'en, 'et whunts'ih húbuts'u hachawhus'ak. ");
INSERT INTO cafNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","'Et whunts'ih 'ahoolhyez dunábunultun hoh ndus de 'ut'en unzoo, 'i 'uyulh'en, 'i be ndi chan nalhtih, 'i 'ink'ez hanéyeh 'i chah soo 'et 'ut'en yílh'i. 'Et whuz na'a ts'uyi, 'i chah nuhghat'aih hoh nuhdzi chah hoont'i yílh'i.” ");
INSERT INTO cafNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ndunnah 'ilhuhowezdel whel'a 'en buts'un hidut'élhk'un, 'et whuch'a 'ankw'us hubuhotun ghaít'ah, 'et whunts'ih Paul bughunek be k'ah hubuhoontun. ");
INSERT INTO cafNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","'Et bulunah Lizwif Antioch Pisidia whuz'ai 'ink'ez keyah Iconium chah, 'et keyah Lystra ts'ih haníndel 'ink'ez ndunnah Lystra whut'en 'ilhuhowezdel, 'en ts'iyawh hits'un nint'uk hukwa' hut'en. 'Et huwa Paul tse be hízelhghi 'ink'ez dazsai zeh hininzun. 'Et keyah yoo 'az ts'ih 'et nihininguz. ");
INSERT INTO cafNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","'Et whunts'ih Sizi Gri yugha hoodul'eh higha wezdel hoh dinadíja 'ink'ez keyah ts'ih whenaja. 'Et 'om bun dzin Barnabas bulh keyah Derbe ts'un whehá'az. ");
INSERT INTO cafNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","'Et Paul, Barnabas bulh keyah Derbe 'et khunek unzoo, 'i be hubulh yahúlhtuk hoh lhanah Sizi k'úne' hut'en huzdli. 'Aw 'et Lystra ts'ih whenáhet'az. 'Et Iconium ts'ih chah 'ink'ez Antioch, Pisidia whuz'ai hoh wheghah chah lhuhúz'az. ");
INSERT INTO cafNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ndunnah yugha hoodul'eh soo budzi ulhtus hoh ndet huba 'alha' hoont'ah whulh hóoyin hubuhulhtsi, 'ink'ez ndo bahútni, “Lhat hoh dzuh nuts'ude, 'et whunts'i whuz na'a nts'e Yak'usda hubudayi cho unli 'et dáztedulh huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ndet Sizi Gri bugha 'ilhuhowezdel dune tsuh whudelhdzulh huba 'utaháoobanla. 'Et tenahududli 'ink'ez saha'húdelya hoh whuz na'a neMoodihti huba 'alha' hoont'ah 'en tl'ábahanla. ");
INSERT INTO cafNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","'Et Pisidia whuyun k'ut lhuhuz'az hukw'elh'az 'et Pamphylia ts'ih huni'az. ");
INSERT INTO cafNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","'Et Perga whut'en chah Yak'usda bughunek be hubulh yahúlhtuk 'ink'ez nyoh Attalia ts'un huni'az, ");
INSERT INTO cafNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","'ink'ez 'et whuts'un Antioch ts'ih nahúsduki. Ndet keyah Paul Barnabas bulh Yak'usda be 'ut'en k'ah butl'aháhonla inle. 'Aw 'et ndi 'ut'en lhahídinla hoh 'uhoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","'Et Antioch ts'ih nahunt'az hoh Sizi Gri yugha hoodul'eh, ts'iyawh 'ilhóhubughezdla 'ink'ez nts'oh teh Yak'usda bugha ne'húst'en 'ink'ez 'udun yun k'ut whut'en chah be 'alha' hoont'ah, 'i hiyít'i suli hutni hoh hubulh nahuwhulnuk. ");
INSERT INTO cafNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Sa yugha hoodul'eh hubutah hanke. ");
INSERT INTO cafNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","'Et bulunah dune Judea whehudíndel keyah Antioch ts'ih hunindel 'ink'ez ndunnah huba 'alha' hoont'ah Moses bughunek 'uk'une'úsduguz, 'i bugha buka dune ahli, 'i k'ut nuwhuhúzt'us t'eh, 'aw 'et t'eh zeh dutehjih, whuz na'a wheooboohoodalh'i. ");
INSERT INTO cafNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paul, Barnabas bulh tube cho Moses bughunek 'uk'une'úsduguz, 'i bugha dája hutni 'et hubugha lhenah nihúwhunt'ai, ndunnah Judea ts'ih hahándel tubulh. 'Et huwu lhgha 'úhudeja hoh Paul, Barnabas, 'ink'ez 'uyoon Antioch whut'en tubulh, Jerusalem ts'ih toodelh 'ink'ez whel'a 'en ndunnah dune tsuh whudelhdzulh hubulh huwu yahoolhtuk hubuhútni. ");
INSERT INTO cafNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","'Aw 'et Sizi Gri bugha 'ilhuhowezdel, ndunnah whel'a 'en whebahalh'a. 'Et Phoenicia 'ink'ez Samaria whutuh lhuhúz'az hoh 'udun yun k'ut whut'en dahúja Yak'usda ts'un náhulhéya hubuhútni hoh tube cho ndunnah Sizi Gri k'úne' hut'en huhóont'i suli. ");
INSERT INTO cafNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","'Et Jerusalem ts'ih huni'az hoh ndunnah Sizi Gri bugha 'ilhuhowezdel tube cho hubanelhnik. Ndunnah whel'a 'en 'ink'ez dune tsuh whudelhdzulh, 'en hubulh náhuwhulnuk Yak'usda bugha nts'oh teh ne'whust'en 'et hubugha. ");
INSERT INTO cafNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","'Et bulunah huba 'alha' hoont'ah, Pharisee hubulh hudedoh, 'en dihudíndel 'ink'ez 'uhutni, “Udun yun k'ut whut'en hika dune unli, 'i k'ut hubatet'us 'ink'ez ndi Moses bughunek 'uk'une'úsduguz, 'i k'úne' hóot'en hubadooni huba' hoont'ah.” ");
INSERT INTO cafNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","'Et whel'a 'en 'ink'ez dune tsuh whudelhdzulh ts'iyawh 'ilhuhowezdel 'ink'ez njan 'uhutni hukw'u nuhúhulhye. ");
INSERT INTO cafNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Sa hukw'u nuhúhulhya hoh Peter didinya 'ink'ez ndo búlhni, “Sulhutsinkah t'eoonáhzun 'uda hoh Yak'usda nuhtáhasálhti Yak'usda bughunek unzoo, 'i bugha 'udun yun k'ut whut'en hubulh yaóolhtuk ka, khun si sudóots'o 'ink'ez huba 'alha hot'e ka. ");
INSERT INTO cafNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","'Ink'ez Yak'usda dune dahínt'ah t'eoobunínzun, 'et huwa 'udun yun k'ut whut'en, 'en chah hubuk'entsi' hoh wheni danénla da whuz na'a ndunnah chah Ndoni hubuyudélts'ut ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wheni Lizwif ts'inli 'ink'ez 'en 'udun yun k'ut whut'en hinli 'et whunts'ih 'aw lhelhts'un na'a lhene'ílhdzun. 'Et hoh ndunnah Sizi Gri huba 'alha' hoont'ah suli 'et huwa bulubeshi huba yuna'dalhde. ");
INSERT INTO cafNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ndi Moses bughunek 'uk'une'úsduguz, 'i wheni 'ink'ez netsuh whudelhdzulh, 'en whunts'ih 'aw ts'ah'un na'a hukw'ú nucha'hit'il inle. 'Et 'ink'ez k'an di ka Yak'usda 'en óolhdzih ho' dahni? Ndunnah yugha hoodul'eh 'uhót'e ghaít'ah teh huba né'dahni. ");
INSERT INTO cafNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","'Et nts'e na'a 'uwhutét'ilh? Neba 'alha' hoont'ah 'ink'ez nts'e na'a 'uhint'ah, whuz na'a wheni chah Sizi Gri neMoodihti ye únzoo, 'i be uzdoojih ka neghá whunt'ai.” ");
INSERT INTO cafNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","'Et soo hudelhts'i ts'iyawh t'ehudusnih, Barnabas, Paul bulh nahuwhulnuk whutah 'udun yun k'ut whut'en hubutah nts'e na'a Yak'usda bugha hooncha 'ink'ez huwa 'ét'en tuné'hust'en 'et hubugha. ");
INSERT INTO cafNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","'Et yahulhtuk 'ustl'e' 'uhudeja hoh James didinya 'ink'ez utni, “Sulhutsinkah soo sih soo zélhts'ai! ");
INSERT INTO cafNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon k'an nuhwhudáni, nts'e na'a Yak'usda 'udechoo ndunnah 'udun yun k'ut whut'en dinabunelhútan hoh dune hubutah 'utahaóobanla. 'En 'uhuja Yak'usda boozi dezti hiyulhtsi.” ");
INSERT INTO cafNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","'Et James 'o 'un ndutni, “Et Yak'usda be nus whunilh'en hubughunek 'uk'une'úsduguz, 'i ts'iyawh lhgha 'uhudeja hoh ndutni, ");
INSERT INTO cafNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘'Et hukw'elh'az whusanátesdalh,’ ni neMoodihti, ‘'Ink'ez David bukoo naoonankat, 'et dinaoodutés'alh 'ink'ez yahónkat chah soo ná'whutesdlilh, 'ink'ez lhanaooduteslilh. ");
INSERT INTO cafNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","'Et whuz na'a ndunnah dune 'et nenínkat chah skahunóota 'ink'ez 'udun yun k'ut whut'en, ndunnah sich'oh suba 'udunébunila soozi be hiyozi ka, 'en chah skahúnoota, neMoodihti utni. 'En 'int'ah ndi ts'iyawh 'uhóonla. ");
INSERT INTO cafNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Yak'usda ndi yun 'itelilh 'et whutsuh whudelhdzulh nus de dawhútet'ilh 'et ts'iyawh t'eoonínzun.” ");
INSERT INTO cafNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","'Et James 'o 'un ndo búlhni, “Si 'et ndunúszun ndunnah 'udun yun k'ut whut'en, ndunnah Yak'usda ts'un nalhúya, 'aw huba hoontsi' ts'ih 'uhot'e huba cha'hóot'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","'Et whunts'ih buts'ó k'e'ts'ooges 'ink'ez hubuzdóoni, ‘Ndai ts'uyi, 'i hubuyak'usda 'uk'eltsi, 'i hits'un hítulhdelh 'et buch'a' nenjoot ho' 'int'ah, khun teh wah'alh gunih. Ts'ekoo k'us dune bulh tinta' 'ooht'en gunih. Khunai buze 'úsduguz, 'i 'ink'ez 'uskai tananji, 'i wah'alh gunih, 'ink'ez 'uskai chah wahnai gunih.’ ");
INSERT INTO cafNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","'Et 'alha' hoont'ah Lizwif luglez 'et nats'ulyis dzin totsuk sa whuts'un Moses bughunek 'uk'une'úsduguz, 'i buk'eyatuk 'ink'ez keyah totsuk chah bughunek hiye búbulh yalhtuk,” ni, James. ");
INSERT INTO cafNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","'Et ndunnah whel'a 'en chah, dune tsuh whudelhdzulh, 'ink'ez Sizi Gri bugha 'ilhohuwezdel tubulh lhulh lhugha 'úhudeja hoh Paul, Barnabas bulh Antioch ts'ih hubulh te'us 'utahábotelhtelh. 'Et Judas, 'en Barsabbas hiyúlhni, 'en Silas bulh 'utahaóobahalhti. 'Et huba 'alha' hoont'ah hubutah ndunnah nanah, 'en soo whunih hinli. ");
INSERT INTO cafNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","'En ndi hik'une'úzguz, 'i hubutl'ahíya'ai, 'i ndutni, “Wheni whel'a 'en, dune tsuh whudelhdzulh, 'ink'ez huba 'alha' hoont'ah chah Jerusalem delhúts'i, wheni ts'iyawh nuhts'o k'e'ts'uges, newhulhutsinkah, 'udun yun k'ut whuzdli, keyah Antioch, Syria 'ink'ez Cilicia yun k'ut delhts'i, Dahooja nuhts'utni. ");
INSERT INTO cafNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Whulh 'úzdits'o bulunah dune netahaíndel nuhts'un hunindel 'ink'ez tink'us na'a 'unohuhútni. ‘Moses bughunek 'uk'une'úsduguz, 'i buk'une' 'ooht'en 'ink'ez buka dune ahli, 'i k'ut nahuhoot'us.’ Ndi khunek 'i be tink'us nahonilht'uk, 'aw wheni ndo buts'útni 'ilah ho' hutni. ");
INSERT INTO cafNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","'Et huwa 'ilhuts'owezdel 'ink'ez ts'iyawh lhgha 'úzdeja hoh dune whunih 'en nuhts'un uztelh'alh 'utahaóobats'alhti 'ink'ez soo ndunnah hubuk'ets'intsi' Barnabas 'ink'ez Paul bulh hubulh hútoo'as 'et wheni. ");
INSERT INTO cafNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","'En 'uhuja Sizi Gri, neMoodihti, bughunek be yáhalhtuk hukw'é dahootsah tulih t'ehonanzun 'et whunts'ih. ");
INSERT INTO cafNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","'Et Judas 'ink'ez Silas nuhts'ú buztelh'alh, 'en dich'oh daja ts'utni hoh nuhts'un k'e'ts'anguz, 'et ts'iyawh buzek whe ndun whuduteni. ");
INSERT INTO cafNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","'Et Ndoni 'en bulh lhgha 'úzdeja 'aw 'o 'un chah howu whúlna nuhwhuba ts'uhólh'i hukwa cha'uznízun. Ndet k'an nuhghá whunt'ai whuz na'a zeh 'ooht'e hukwa' uzninzun. ");
INSERT INTO cafNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ts'uyi, 'i hubuyak'usda k'edeltsi ts'un tulhdelh, 'i wah'alh gunih! 'Uskai chah, khunai buze 'úsduguz, 'i buzkai tananji, 'i chah wah'alh gunih! 'Ink'ez ts'ekoo k'us dune bulh tinta' 'ooht'en gunih! 'Et whuch'a khahdli t'eh, 'et sih soo 'óoht'e. 'Aw 'et zeh.” ");
INSERT INTO cafNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","'Et khunek na'a 'en whéoobahalh'a hoh Antioch ts'ih hunindel. 'Et ts'iyawh huba 'alha' hoont'ah 'ilhobughezdla 'ink'ez dustl'us hubutl'ahíya'ai. ");
INSERT INTO cafNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","'Et ndi hubuts'un k'ehanguz 'i hik'eyailhtuk hoh buk'une'úsduguz, 'i bugha hubudzi ulhtus nasdli 'ink'ez tube huhóont'i. ");
INSERT INTO cafNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","'Et Judas, Silas bulh hedich'oh chah Yak'usda ba nus whunilh'en hinli, 'ink'ez huba 'alha' hoont'ah sa hoh Yak'usda bughunek be hubulh yahalhtuk, 'et hoh soo hubudzi unzoo 'ink'ez hilhtus chah hubuhulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","'Et hukw'elh'az dzuh sa hubuzih hudelhts'i. 'Et huba 'alha' hoont'ah ndunnah khunek na'a 'en nts'ez de hahándel ts'ih whuz hubudzi hoont'i hoh whel'a 'en hubuts'un whenábahalh'a. ");
INSERT INTO cafNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","'Et whunts'ih Silas 'en 'aw 'et teda buba hoonzoo ho' hoont'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","'Et Paul, Barnabas bulh Antioch 'et chah 'et hanke, 'uyoon chah hubulh khunek unzoo, 'i be hubulh yahúlhtuk 'ink'ez neMoodihti bughunek bugha wheóobuhodulh'eh. ");
INSERT INTO cafNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","'Et hukw'elh'az dzin Paul, Barnabas 'uyúlhni, “Nts'e keyah totsuk neMoodihti bughunek be yats'ulhtuk, nelhutsinkah hubuts'un nunaoodút'as 'ink'ez nahot'alh dahínt'ah simba.” ");
INSERT INTO cafNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","'Et Barnabas, John, Mark hiyulhni, 'en dudulh tóo'as hukwa' ninzun, ");
INSERT INTO cafNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","'et whunts'ih Paul 'aw ts'ah'un buba cha'hóot'ah. Hoh da Pamphylia bughu whenája 'ink'ez 'ut'en hubulh lhachaídilil, 'et huwa hubulh 'útenilh, 'aw Paul hukwa cha'nízun. ");
INSERT INTO cafNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","'Et tube lhenah 'ahudeja k'et, lhch'a nahust'az. Barnabas, Mark dulh 'iyílya 'ink'ez Cyprus ts'ih whenahedúki. ");
INSERT INTO cafNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","'Et Paul, Silas hubutahaíyalhti 'ink'ez huba 'alha' hoont'ah Yak'usda tl'aóobahanla ye únzoo, 'i be hubughole ka, 'et hukw'elh'az whenáhet'az. ");
INSERT INTO cafNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","'Et Syria 'ink'ez Cilicia whuyun k'ut whutah lháhuz'az, 'ink'ez Sizi Gri bugha 'ilhuhowezdel 'o nus hubudzi ulhtus hubuhulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","'Et Paul 'en keyah Derbe 'ink'ez Lystra ts'ih ninya. Whuz 'ilhunuh dune buba 'alha' hoont'ah Timothy hiyúlhni, 'en hoh whut'en. Be'ama chah buba 'alha' hoont'ah, 'en Lizwif 'int'ah, 'et be'abá, 'en Greek 'int'ah. ");
INSERT INTO cafNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Keyah Lystra 'ink'ez Iconium whut'en, ndunnah huba 'alha' hoont'ah, 'en Timothy soo highu yalhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","'Et Paul 'en Timothy dulh yutél'us hukwa' ninzun, 'et yuka dune unli, 'i k'ut hiyúzt'us. 'Et ndihiyínla hoh Lizwif hoh whut'en, 'en Timothy be'abá Greek unli t'ehinínzun 'et huwa. ");
INSERT INTO cafNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","'Et keyah whutuh hedulh hoh 'et huba 'alha' hoont'ah ndai whel'a 'en 'ink'ez dune tsuh whudelhdzulh Jerusalem 'et highu nahezya, 'i zeh k'úne' 'ooht'en hubuhútni. ");
INSERT INTO cafNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","'Et Sizi Gri bugha 'ilhohuwezdel hoh be 'alha' hoont'ah, 'i be 'o nus hilhtus huzdli, 'ink'ez 'et huwa dzin totsuk nus lhe'huneltsuk. ");
INSERT INTO cafNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","'Et Phrygia 'ink'ez Galatia yun k'ut wheghah lhuhúzdel hoh Asia yun k'ut 'et Yak'usda bughunek be yáhutelhtuk, 'et Ndoni whuch'a hubunezyoot. ");
INSERT INTO cafNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","'Aw 'et Mysia yun k'ut wha'az nihúnindel, Bithynia yun k'ut ts'un hútoodelh hukwa' hut'en, 'et whunts'ih Ndoni 'aw hubugha chahóo'al. ");
INSERT INTO cafNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","'Et Mysia yun k'ut wheghah lhuhúzdel hoh keyah Troas ts'ih hunindel. ");
INSERT INTO cafNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","'Et 'ulh'ek Paul hoonli bunalh ha whélts'ut hoh dune Macedonia yun k'ut whut'en yunilh'en 'et siyin 'ink'ez yughu tédudlih, “Macedonia yun k'ut ts'ih nets'ínyalh 'ink'ez nela'ineh!” yúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Soo njan bunalh ha whélts'ut ibulh lhazduja Macedonia yun k'uz ts'ih uztekelh 'ink'ez ndunnah 'et whut'en khunek unzoo, 'i be hubulh yats'oolhtuk ka. NeMoodihti neka dani t'ets'onínzun 'et whuz na'a 'uts'uja. ");
INSERT INTO cafNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","'Et Troas 'et ts'i cho be nus ts'utezki, 'et soo ts'ihyan whuz Samathrace ts'ih yats'úzki, 'ink'ez 'om bun dzin 'et Neapolis ts'ih ts'utezki. ");
INSERT INTO cafNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","'Et whezdindel hoh keyah Philippi ts'ih ts'unindel. 'I yun k'ut Macedonia 'udechoo keyah whudézti 'et whuz'ai. 'Et Roman keyah be'ilhdzun hoonli ho' hoont'ah. 'Et keyah Philippi lhat dzin 'et na'ts'alh'ai. ");
INSERT INTO cafNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","'Et Lizwif nats'ulyis dzin hoh keyah whuch'a ts'uzdel 'ink'ez took'oh taba ts'ih ts'unindel. 'Et Lizwif tenahudedli hoonli 'uzninzun, 'et huwa 'et nátl'azdelts'i 'ink'ez ts'ekoo 'ilhohuwezdel 'en bulh yáts'ulhtuk. ");
INSERT INTO cafNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","'Ilhunuh ts'eke, Thyatira whut'en Lydia hiyúlhni, 'en chah nedánts'o. 'En naih dulk'un dezti be 'óoket unli, 'ink'ez 'ahoolhyez Yak'usda ts'un teni' nilhdzun. 'Et huwa neMoodihti Paul Yak'usda bughunek ye yálhtuk, 'i soo cho yoozélhts'ai 'ink'ez beni taóodoolts'it yulhtsi. ");
INSERT INTO cafNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","'Et didut 'ink'ez bukoo hudelhts'i, bulh dunekah chah, ts'iyawh too be' hulya. 'Et hukw'elh'az neghunséya, 'ink'ez neundulhni, “NeMoodihti soo cho but'anunestan nuhwhuba 'alha' hoont'ah t'eh, 'anih sukoo ts'ih suzih doolhúts'i.” 'Ink'ez 'ilhuz 'udeja hoh bulh 'utezdel. ");
INSERT INTO cafNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","'Et 'ilhudzin nts'e tenazdedli ts'ih ts'enindel hoh, 'ilhunuh 'ulhna, 'en ts'eke nedudezya. 'En ntsi' nudúdeh, 'i buyídinda 'i be nus whunilh'en 'ink'ez nus daóotenilh ts'iyawh ndo búlhni. 'Et ndunnah yughunli 'en lhai sooneya hiye 'úlh'en. ");
INSERT INTO cafNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","'Et 'ut'en Paul 'ink'ez wheni teh nenunéya 'ink'ez 'alzul hoh utni, “Ndunnah dune degha nus nduk Yak'usda budune hinli. Nts'e na'a dutehjih hoh teh nuhwhuba nuhúhuyeh!” ");
INSERT INTO cafNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Lhat dzin ndut'en, 'udek'elh'az Paul tube taídeznih, yuts'un nálhu'a 'ink'ez ntsi' nududeh, 'i njan díyulhni, “Sizi Gri boozi bugha buyúh hanaindaih!” 'Et 'ahoh ntsi' nududeh, 'i yeyúh hanadede. ");
INSERT INTO cafNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","'Ink'ez ndunnah ts'eke bumoodih t'ehonanzin ndet hoh sooneya 'uhulh'en, 'ustl'e' 'uhooja, 'et Paul, Silas bulh hubuhúzgooh 'ink'ez huba' hoont'ah, 'et keyah k'une'nuwhuhul'en hububut nébanilhti. ");
INSERT INTO cafNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","'Et lhahudughan moodih but nebanilhti 'ink'ez hubuhutni, “Ndunnah Lizwif 'uhint'ah. Netah 'ahoolhyez dune tehudule. ");
INSERT INTO cafNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ndet wheni hubugha neba nahesda ts'iyawh whuch'a na'a whubuhodulh'eh. Wheni Roman 'uts'int'ah 'et huwa 'aw buk'ah ts'ih 'uts'ooneh ghaít'ah 'ink'ez hoh tuné'ts'oot'en ghaít'ah.” ");
INSERT INTO cafNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","'Et 'ilhuhowezdel ts'iyawh hubuch'a nihúdendel, nehughan moodih Paul, Silas bulh hubunaih hubuk'uhidutelhch'ul 'ink'ez hubuholht'ah hubuhútni. ");
INSERT INTO cafNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","'Et soo tube hubuholht'o hoh nts'e dune tsak'eha'aih, whuz tsak'ebaha'ai, 'ink'ez ndun huwunli, 'en, “Hubuch'a dana'doo'alh,” hiyúlhni. ");
INSERT INTO cafNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","'Et tsak'edinla ghunli hiyúlhni hoh 'ahoh soo bez tsak'edi'ai 'et tsak'ehiya'ai 'ink'ez duchun dindaz huba' 'int'ah, 'i bukechun ghu níhininla 'ink'ez hiduna'denla. ");
INSERT INTO cafNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","'Et tuzniz bat'en Paul, Silas bulh Yak'usda ts'un tenahududli 'ink'ez hujun. 'Et ndunnah tsak'ehudelhts'i hubuhoozélhts'ai. ");
INSERT INTO cafNT_vpl VALUES 