﻿USE sofia;
DROP TABLE IF EXISTS sofia.cac_vpl;
CREATE TABLE cac_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cac_vpl WRITE;
INSERT INTO cac_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","A d'a yichb'anil, a Dios ix b'oan satchaan̈ yed' lum luum. ");
INSERT INTO cac_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","A d'a jun tiempoal chi' malaj stzolal yaj jun yolyib'an̈q'uinal tic, tz'inan yilji. Ton̈ej pan̈an ec' a a' d'a yib'an̈ luum. Q'uic'olinac yilji masanil d'a yib'an̈ a', axo Yespíritu Dios tz'ec' d'a yib'an̈ a' chi'. ");
INSERT INTO cac_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ix lajvi chi' ix yalan Dios icha tic: Ayocab' saquilq'uinal, xchi. Icha chi' b'ian ix sacb'iq'uinal. ");
INSERT INTO cac_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ix yilan Dios to vach' jun saquilq'uinal chi', ix spojanel saquilq'uinal chi' d'a scal q'uic'alq'uinal. ");
INSERT INTO cac_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","A saquilq'uinal chi', c'ualil ix sb'iejcan yuuj, axo q'uic'alq'uinal chi', d'ac'valil ix sb'iejcani. Ix q'uic'b'iemi, ix sacb'i, ix eq'uel jun b'ab'el c'u. ");
INSERT INTO cac_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ix lajvi chi' ix yalan Dios icha tic: Ayocab' junoc tas scan d'a yib'an̈ sat luum tic yic spojan snan̈al a a', xchi. ");
INSERT INTO cac_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Icha chi' b'ian, a Dios ix b'oan jun chi'. Cha macan̈ ix ajcanel a a' chi' yuuj: Jun macan̈ a' ix can d'a sat lum tic, junxo macan̈ a' ix q'uecan d'a yib'an̈. Ichaton chi' ix aji. ");
INSERT INTO cac_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","A jun ix can chi' “satchaan̈” ix sb'iejcani. Ix q'uic'b'ixiemi, ix sacb'ixi, ix ec' schab'il c'ual. ");
INSERT INTO cac_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ix lajvi chi' ix yalan Dios icha tic: Junxon̈ejocab' tz'aj a a' ay d'a yalan̈ satchaan̈ yic scheclajcan lum luum d'a taquin̈al, xchi. Ichaton chi' ix aji. ");
INSERT INTO cac_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","A b'aj ix checlajcan staquin̈al chi', “luum” ix sb'iejcani, axo a a' junn̈ej ix aj chi', “mar” ix sb'iejcan a'. Axo ix yilan Dios chi', te vach' ix aji. ");
INSERT INTO cac_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ix lajvi chi' ix yalan icha tic: Pac'ocab' an̈ an̈c'ultac d'a sat lum luum yed' te te' syac' sat. A d'a sat te' chi' yed' an̈ an̈c'ultac chi', ata' ay yin̈atil ato syala' tas macan̈il, xchi. Ichaton chi' ix aji. ");
INSERT INTO cac_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ichaton chi' ix aj spac' an̈ an̈c'ultac d'a sat lum luum tic, aton an̈ an̈c'ultac yed' te te' syac' sat ato syala' tas in̈atil. Axo ix yilan Dios te vach' ix aji. ");
INSERT INTO cac_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ix q'uic'b'ixiemi ix sacb'ixi, ix ec' yoxil c'ual. ");
INSERT INTO cac_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Ix lajvi chi' ix yalan Dios icha tic: Ayocab' juntzan̈ saquilq'uinal d'a satchaan̈ yic syac' saquilq'uinal d'a sat luum tic, yic sch'oxanel c'ualil yed' d'ac'valil, yic scheclaj junjun c'u, junjun ab'il yed' juntzan̈ tiempoal, xchi. Ichaton chi' ix aji. ");
INSERT INTO cac_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","A Dios ix b'oan chab' nivac saquilq'uinal. A jun nivan sc'ac'al ix och yopisio d'a c'ualil, axo jun quenn̈ej sc'ac'al ix och yopisio d'ac'valil, aton c'u yed' q'uen uj. Ix sb'oanpax masanil q'uen c'anal. ");
INSERT INTO cac_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ix yac'anoch juntzan̈ saquilq'uinal chi' d'a satchaan̈ yic syac' yoc d'a sat luum tic ");
INSERT INTO cac_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","d'a c'ualil yed' d'ac'valil yuj spojanpaxel saquilq'uinal d'a q'uic'alq'uinal. Ix yilan Dios chi' te vach' ix aji. ");
INSERT INTO cac_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ix q'uic'b'ixiemi, ix sacb'ixi, ix ec' schan̈il c'ual. ");
INSERT INTO cac_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ix lajvi chi' ix yalanxi Dios icha tic: Pitzvocab' noc' noc', noc' ay d'a yol a a' yed' masanil macan̈il noc' much tz'ec' jen̈en̈oc, xchi. ");
INSERT INTO cac_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ix sb'oan noc' nivac noc' Dios chi', noc' ay d'a yol a' mar yed' masanil macan̈il noc' noc' ay d'a yol a' chi' yed' masanil macan̈il noc' much. Axo ix yilani te vach' ix aji. ");
INSERT INTO cac_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ix yac'an svach'c'olal d'a yib'an̈ noc' noc' chi', ix yalan icha tic: Yune'ejocab' sb'a noc', q'uib'ocab' sb'isul noc', b'ud'jocab'el yol a' mar yuj noc'. An̈ejtona' noc' much, q'uib'ocab' sb'isul noc' d'a yolyib'an̈q'uinal tic, xchi. ");
INSERT INTO cac_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ix q'uic'b'ixiemi, ix sacb'ixi, ix ec' yoil c'ual. ");
INSERT INTO cac_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Ix lajvi chi' ix yalan Dios icha tic: Pitzvocab' chaan̈ masanil macan̈ noc' noc' d'a sat luum tic, noc' molb'etzal noc', noc' c'ultaquil noc' yed' noc' tz'ec' n̈ern̈onoc ma tz'ec' jachjon d'a sat luum, xchi. Ichaton chi' ix aji, ix sb'oan masanil macan̈il noc' noc' ay d'a sat luum tic. Ix yilani, te vach' ix aji. ");
INSERT INTO cac_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ix lajvi chi' ix yalan Dios icha tic: A ticnaic co b'oec anima icha on̈ tic yic vach' tz'och eb' yajalil d'a yib'an̈ noc' chay ay d'a yol a' mar, d'a yib'an̈ masanil noc' much, d'a yib'an̈ noc' molb'etzal noc', d'a yib'an̈ noc' c'ultaquil noc' yed' pax d'a yib'an̈ noc' tz'ec' n̈ern̈onoc ma tz'ec' jachjon d'a sat luum tic, xchi. ");
INSERT INTO cac_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ichato chi' ix b'oji eb' anima chi' yuj Dios, icha val Dios chi' ix aj eb'. Ix b'ojican vin̈ vinac yed' ix ix yuuj. ");
INSERT INTO cac_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ix lajvi chi' ix yac'an svach'c'olal Dios d'a yib'an̈ eb'. Ix yalan d'a eb' icha tic: Aljocab' eyuninal, q'uib'ocab' e b'isul, b'ud'jocab'el sat lum luum tic eyuuj, ochan̈ec yajalil d'a yolyib'an̈q'uinal tic. Ochan̈ec yajalil d'a yib'an̈ noc' chay ay d'a yoltac a a', d'a yib'an̈ noc' much sjen̈vi yed' d'a yib'an̈ masanil noc' tz'ec' n̈ern̈onoc ma tz'ec' jachjon d'a sat lum tic, xchi. ");
INSERT INTO cac_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ix lajvi chi', ix yalanxi d'a eb' anima chi' icha tic: A in svac' masanil macan̈il an̈ an̈c'ultac ay yin̈atil yed' masanil te te' syac' sat e lo'o yic syac' yip d'a e nivanil. ");
INSERT INTO cac_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Masanil noc' molb'etzal noc', noc' c'ultaquil noc', noc' tz'ec' n̈ern̈onoc ma tz'ec' jachjon d'a sat luum yed' noc' much, a in svac' an̈ an̈c'ultac yed' xiltac te te' svaeloc noc', xchi. Icha chi' ix aji. ");
INSERT INTO cac_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ix yilanoch Dios, te vach' ix aj masanil tas ix sb'o'o. Ix q'uic'b'ixiemi, ix sacb'ixi, ix ec' svaquil c'ual. ");
INSERT INTO cac_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","2","D'a vaque' c'ual ix sb'o satchaan̈ Dios, lum luum yed' masanil tastac ay d'ay. Axo d'a yuquil c'ual, ix och vaan smunlaji. ");
INSERT INTO cac_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ix sic'anel jun yuquil c'ual chi' Dios, to yicn̈ej tz'ajcani, yic tz'ochcan svach'iloc eb' anima, yujto a d'a jun c'u chi' ix b'oelc'och masanil tas ix sb'o chi'. ");
INSERT INTO cac_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Aton yab'ixal tas ix aj sb'o satchaan̈ yed' lum luum tic. Ayic ix sb'oan satchaan̈ Jehová Dios yed' lum luum tic, ");
INSERT INTO cac_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","mantalaj junoc te te' ma junoc an̈ an̈c'ultac sq'uib'i, yujto mantalaj n̈ab' syac' d'a yib'an̈ luum yuj Jehová. Mantalaj pax mach smunlaj d'a sat luum. ");
INSERT INTO cac_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ton̈ej xob'anq'ueul a a' d'a sat luum yic sch'ayxi luum. ");
INSERT INTO cac_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","A d'a jun tiempoal chi', ix sb'o jun anima Jehová Dios. A spococal lum luum ix yac'lab'ej sb'oani. Ix lajvi chi', axo yic' ix spuoch d'a yol sn̈i'. Icha chi' ix aj spitzvi vin̈ anima chi'. ");
INSERT INTO cac_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ix yavej juntzan̈ avb'en te' Jehová Dios d'a jun lugar scuch Edén, d'a stojolal b'aj sjavi c'u. Ata' ix yac'canoch vin̈ vinac ix sb'o chi'. ");
INSERT INTO cac_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ix yac'an q'uib' masanil te te' te vach' yilji, man̈xo jantacoc svach'il sat te' syac'a', te vach' sloji. A d'a snan̈al jun avb'en te' chi', ay jun te' tz'ac'an q'uinal, ay pax junxo te' tz'ac'an nachajel b'aj ay vach'il yed' chucal. ");
INSERT INTO cac_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A d'a Edén chi', sq'ueul jun a a' tz'ac'anoch yal masanil te' avb'en te' chi'. Axo tz'el a' d'a Edén chi', chan̈e' tz'aj yel sc'ab' a'. ");
INSERT INTO cac_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","A jun a' b'ab'el, Pisón sb'i a', aton a' tz'ec' oyoyoc d'a yol lum scuch Havila b'aj ay q'uen oro. ");
INSERT INTO cac_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","A q'uen oro ay d'a jun lugar chi', te vach' q'ueen. Ay pax juntzan̈ te te' ay stzatajil te sumumi sjab'. Ay pax juntzan̈ q'uen q'ueen scuchan ónice te caro stojol. ");
INSERT INTO cac_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Axo a' schab'il, Gihón sb'i a'. Aton a' tz'ec' oyoyoc d'a yol lum scuchan Cus. ");
INSERT INTO cac_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Axo a' yoxil, Tigris sb'i a'. Aton a' tz'ec' oyoyoc d'a stojolal b'aj sjavi c'u d'a lum Asiria. Axo a' schan̈il, aton a' Éufrates. ");
INSERT INTO cac_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ix yac'ancan vin̈ vinac Jehová Dios d'a scal te' avb'en te' d'a Edén chi' yic smunlaj vin̈ yic stan̈vanpax vin̈. ");
INSERT INTO cac_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ix yalan Dios d'a vin̈ icha tic: —Syal a lo'an sat te te' tic smasanil. ");
INSERT INTO cac_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Axo pax te' tz'ac'an nachajel b'aj ay vach'il yed' chucal, man̈ a lo sat te'. Tato ol a lo sat te' chi', d'a val yel ol ach chamoc, xchi Dios d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ix yalanxi Jehová Dios icha tic: Man̈ vach'oc yajec' vin̈ vinac tic sch'ocoj. Ol in b'o junoc yetb'eyum vin̈ to smoj val scolvaj yed'oc, xchi. ");
INSERT INTO cac_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Masanil noc' noc' ix sb'o Dios d'a sat lum tic, noc' c'ultaquil noc' yed' masanil noc' much, ix ic'jib'at noc' yuj Dios d'a vin̈ vinac chi' yic say sb'i junjun noc' vin̈. A sb'i junjun noc' ix say vin̈, aton ix sb'iejcan noc'. ");
INSERT INTO cac_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ix say sb'i masanil noc' vin̈, noc' c'ultaquil noc', noc' much yed' noc' molb'etzal noc'. Palta malaj junoc noc' d'a scal noc' chi' tz'acan tz'aj scolvaj yed' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Axo Dios ix ac'ancot jun nivan vayan̈ d'a vin̈. Ayic chamnac el vin̈ svay chi', ix ic'jielta jun sb'aquil scostil vin̈ yuj Dios. Ix lajvi chi' ix smacanxi b'aj ix yiq'uelta jun b'ac chi'. ");
INSERT INTO cac_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Aton sb'aquil scostil vin̈ chi' ix b'oji ixal yuj Dios. Ix lajvi chi', ix ac'jicanoch ix d'a yol sc'ab' vin̈aj Adán chi' yuj Dios. ");
INSERT INTO cac_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Axo yic ix yilanoch ix vin̈, ix yalan vin̈ icha tic: —Aton val jun tic val yel in b'aquil, in b'ac'chil, yujto a d'ayin ix elta yuj Dios. Yuj chi' “Ix” ol sb'iejcani, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yuj chi' a vin̈ vinac, ol yactejcan smam snun vin̈ yic junxon̈ej tz'ajcan vin̈ yed' ix yetb'eyum, junxon̈ej nivanil tz'ajcan eb' schavan̈il. ");
INSERT INTO cac_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Malaj spichul eb' schavan̈il, palta max q'uixvilaj eb' d'ay junjun. ");
INSERT INTO cac_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","A noc' chan, yelxo val te jelan noc' d'a yichan̈ masanil noc' c'ultaquil noc' ix sb'o Jehová Dios. Ix yalan noc' d'a ix ix: —¿Tom yel ix yal Dios to max yal e loan sat masanil te' avb'en te' tic? xchi noc'. ");
INSERT INTO cac_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ix tac'vi ix d'a noc' icha tic: —Masanil te' syal co loan sat, ");
INSERT INTO cac_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","an̈ej jun te' ay d'a snan̈al te' avb'en te' tic, ix yal Dios to max yal-laj co loan sat te', ma co yamani, yic vach' max on̈ chami, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ix tac'vi noc' chan chi' d'a ix: —Ton̈ej syal Dios chi'. Man̈ ol ex chamlaj. ");
INSERT INTO cac_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Palta yojtac Dios, ayic ol e loan sat te' chi', ol tz'acvoc e pensar, lajan ol ex ajcan yed'oc, ol nachajel vach'il yed' chucal eyuuj, xchi noc' d'a ix. ");
INSERT INTO cac_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Axo ix yilanoch sat te' chi' ix, te vach' am sloji, te vach' yiljiochi, ix snib'anoch ix, yic vach' stz'acviel spensar ix snaani. Yuj chi' ix sb'ixanelta jun sat te' chi' ix, ix sloan ix. Ix lajvi chi' ix yac'anpax ix d'a vin̈ yetb'eyum chi', ix sloanpax te' vin̈ yed' ix. ");
INSERT INTO cac_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","A d'a jun rato chi', ix nachajel yuj eb', ix yilanoch sb'a eb' to b'eranel eb', yuj chi' a xil te' higo ix smol eb', ix stz'isan eb' spichuloc, yic tz'och d'a snan̈al eb'. ");
INSERT INTO cac_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Axo ix yab'an vin̈ vinac chi' yed' ix ix chi' to van yec' Jehová Dios d'a scal te avb'en te' chi' d'a yemxoc'ualil, yic sicxo c'u, ix el lemnaj eb' sc'ub'ejel sb'a d'ay d'a scal te avb'en te' chi'. ");
INSERT INTO cac_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Axo ix avtaj vin̈ yuj Jehová Dios: —Ach Adán, ¿b'ajtil ayach eq'ui? xchi. ");
INSERT INTO cac_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ix tac'vi vin̈: —Ina vajec' tic, ix vab'i to van ec' d'a scal te' avb'en te' tic, ix in xivb'ati yujto b'eran in eli, yuj chi' ix in c'ub'ejel in b'a, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ix sc'anb'an Dios d'a vin̈: —¿Mach ix alan d'ayach to b'eran ach eli? Tope ix a lo sat te te', te' ix val d'ayach to max yal-laj a loani, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ix tac'vixi vin̈ icha tic: —A ix ix, ix ac' vetb'eyumoc, a ix, ix ac'an te' d'ayin, yuj chi' ix in lo te', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ix sc'anb'an Dios d'a ix: —¿Tas yuj icha chi' ix a c'ulej? xchi. Ix tac'vi ix: —A noc' chan in ac'an musansatil, yuj chi' ix in lo te', xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yuj chi' ix yalan Jehová Dios d'a noc' chan chi': —Yujto icha tic ix a c'ulej, yuj chi' tzach in catab'ejcan d'a scal masanil noc' molb'etzal noc' yed' noc' c'ultaquil noc'. D'a juneln̈ej a yalan̈ a c'ool ol n̈ervoc. A spococal lum luum ol a lo'o. ");
INSERT INTO cac_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ol vac'canoch ajc'olal d'a a cal yed' ix ix tic yed' masanil in̈tilal yed' pax yin̈tilal ix. A yin̈tilal ix chi' ol mac'anpoj a jolom. A ach xo, ol a chi yich yoc yin̈tilal ix chi', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ix yalanxi Dios d'a ix icha tic: —Ol vac' a yaelal ayic yab'ix ach, axo yic ol aljoc une', ol vac'an nivtaj a yaelal chi'. Vach'chom ay yaelal ol ila', ol a nib'ejn̈ejoch vin̈ etb'eyum. A vin̈ ol och ajaloc, xchi Dios. ");
INSERT INTO cac_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ix yalanpax Jehová Dios d'a vin̈aj Adán chi' icha tic: —Yujto ix a c'anab'ajej ix etb'eyum tic a loan sat te te' ix vala' to max a lo'o, a ticnaic jun, uuj tzin catab'ejcan lum luum tic, yuj chi' d'a scal yaelal ol ach vaoc yacb'an ayach ec' d'a yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ol q'uib'chaan̈ te' q'uiix yed' an̈ an̈c'ultac ay sq'uixal d'a sat lum luum tic. A yuj juntzan̈ aval in̈at ol ic'an yec' tiempo eyuuj. ");
INSERT INTO cac_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ol el alil a munlaji, icha chi' ol aj a va'i masanto ol ach meltzajxoc och luumal. Yujto d'a lum ix ach coti, lum ach taxoni, yuj chi' ol ach meltzajxoc och luumal, xchi Jehová d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Eva ix yac' vin̈aj Adán sb'ioc ix yetb'eyum chi', yujto d'a ix, ix pitzvi masanil anima. ");
INSERT INTO cac_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","A stz'umal noc' noc' ix sb'o Jehová Dios spichuloc vin̈ vinac yed' ix yetb'eyum, ix yac'anoch spichuloc eb'. ");
INSERT INTO cac_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ix yalan Jehová Dios: A ticnaic, icha on̈ tic, icha chi' ix aj eb' anima. Tzaxo nachajel yuj eb' b'aj ay vach'il yed' chucal. Yuj chi' ay smay sloan sat te te' eb', aton te' tz'ac'an q'uinal yic pitzann̈ej eb' d'a masanil tiempo, xchi Dios. ");
INSERT INTO cac_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Yuj chi' ix pechjielta eb' d'a Edén chi' yuj Jehová, ix ochcan vin̈aj Adán chi' smunlaj d'a sat luum b'aj ix cot snivanil. ");
INSERT INTO cac_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ix lajvi yelcancot eb', ix ac'jicanoch juntzan̈ querubín yuj Jehová d'a stojolal b'aj sjavi c'u yed' jun q'uen espada tz'ititi yel sc'ac'al yec' oyoyoc, yic man̈xa junoc mach syal yochi yic sloan sat te te' tz'ac'an q'uinal chi'. ");
INSERT INTO cac_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ix yil-lan sb'a vin̈aj Adán yed' ix Eva, ix och ix yab'ixal. Ix alji jun yune' ix, ix yac'an ix scuch Caín. Axo ix yalan ix: Toxo ix ja jun in vinac unin yujto a Jehová ix och ved'oc, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ix lajvi chi', ix aljipax vin̈aj Abel yuc'tac vin̈aj Caín. A vin̈aj Abel chi', moloj calnel ix sc'ulej vin̈, axo pax vin̈aj Caín chi', ix munlaj vin̈ d'a sat lum luum. ");
INSERT INTO cac_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ix ec' junoc tiempoal, ay jun c'u ix yic'b'at silab' vin̈aj Caín d'a Jehová, aton tas ix yic' vin̈ d'a smunlajel. ");
INSERT INTO cac_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ix yic'anpaxb'at silab' vin̈aj Abel chi' d'a yichan̈ Jehová, aton noc' b'ab'el yune' calnel, noc' te b'aq'uech. Ix stzalaj Jehová yed' vin̈ yed' silab' ix yac' chi'. ");
INSERT INTO cac_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Palta maj tzalajlaj Jehová yed' vin̈aj Caín yed' pax silab'. Yuj chi', ix te chichon sc'ol vin̈, te ov ix aj sat vin̈. ");
INSERT INTO cac_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Axo ix yalan Jehová d'a vin̈ icha tic: ¿Tas yuj ste chichon a c'ool, te ovxon̈ej a sat? ");
INSERT INTO cac_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Tato vach' tza c'ulej, tzalajc'olal am ayach eq'ui, palta to chuc ix a c'ulej, yuj chi' a a chucal chi', ayxon̈ejoch d'a ib'an̈ yic tzach em d'a chucal yuuj, palta tzato yal scan chucal chi' d'a yalan̈ uuj, xchi Dios. ");
INSERT INTO cac_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ay jun c'u, a vin̈aj Caín ix avtan vin̈aj Abel yic sb'at eb' b'eyelec'. Ayic ayec' eb' b'aj ix c'och chi', ix b'at jucnaj vin̈aj Caín d'a vin̈ yuc'tac chi', ix smac'anchamoc. ");
INSERT INTO cac_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ix lajvi chi', ix sc'anb'an Jehová d'a vin̈aj Caín chi': —¿B'ajtil ay vin̈ uc'tac aj Abel? xchi d'a vin̈. Axo ix tac'vi vin̈: —Man̈ vojtacoclaj. ¿Tom yilumal vin̈ vaji? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ix yalanpax Jehová d'a vin̈: —¿Tas yuj icha chi' ix a c'ulej? A schiq'uil vin̈ uc'tac ix em d'a sat lum tic uuj, ichato syal sb'a d'ayin to tzin b'o yaj ed'oc. ");
INSERT INTO cac_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","A ticnaic, catab'il achxo, svic'canel opisio d'a sat lum luum tic, aton lum ix uc'anem schiq'uil vin̈ uc'tac ix a mac'cham chi'. ");
INSERT INTO cac_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ayic ol ach munlaj d'a sat luum, malaj jab'oc tas ol ic'a', ton̈ej ol ixtej a b'a, ton̈ej ol ach comon b'eyec' d'a sat luum, xchi Dios d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ix tac'vi vin̈ icha tic: —Te nivan jun yaelal scotcan tic d'a vib'an̈, man̈ ol techajlaj vuuj. ");
INSERT INTO cac_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ina ix iq'uel vopisio d'a sat lum tic, ix in ic'anel d'a ichan̈ d'a juneln̈ej, toxon̈ej ol in comon b'eyec'oc. Yalxon̈ej mach ol in chalaj in b'a yed'oc, ol in smac'chamoc, xchi vin̈ d'a Dios. ");
INSERT INTO cac_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Axo ix tac'vi Jehová: —Maay. Tato ay junoc mach ol ach mac'anchamoc, a jun chi', uquel ol ec' spac d'ay, xchi d'a vin̈. Ix yac'anoch Jehová jun yechel vin̈aj Caín chi', yic vach' tato ay mach schalaj sb'a vin̈ yed'oc, max mac'jicham vin̈ yuuj. ");
INSERT INTO cac_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ix lajvi chi', ix el vin̈aj Caín b'aj ix lolon eb' chi', ix b'at cajnaj vin̈ d'a jun lugar scuch Nod, d'a stojolal b'aj sjavi c'u d'a Edén. ");
INSERT INTO cac_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ix yil-lan sb'a vin̈aj Caín yed' ix yetb'eyum, ix och ix yab'ixal. Ix alji jun yune' ix, Enoc ix sb'iej. Ix sb'oan jun chon̈ab' vin̈aj Caín chi', axo sb'i yuninal vin̈ chi' ix yac'och sb'ioc. ");
INSERT INTO cac_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","A vin̈aj Enoc smam vin̈aj Irad. Axo vin̈aj Irad smam vin̈aj Mehujael, axo vin̈aj Mehujael smam vin̈aj Metusael, axo vin̈aj Metusael smam vin̈aj Lamec. ");
INSERT INTO cac_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","A vin̈aj Lamec chi', chavan̈ ix aj yetb'eyum vin̈. Ay jun ix scuch Ada, axo junxo ix scuch Zila. ");
INSERT INTO cac_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","A ix Ada chi', ix alji jun svinac unin ix, Jabal ix sb'iej. Aton vin̈ ix b'ab'laj b'eyec' yed' spat mantiado yic smolan noc' snoc'. ");
INSERT INTO cac_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","A vin̈aj Jabal chi', ay jun yuc'tac vin̈ scuchan Jubal. A vin̈ ix b'ab'laj ac'an te' arpa yed' spu'an flauta. ");
INSERT INTO cac_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Axo ix Zila chi', ix aljipax jun yune' ix, vinac unin, Tubal-caín ix sb'iej. B'oum q'ueen ix aj vin̈. Ay tas ix sb'o vin̈ d'a q'uen bronce yed' d'a q'uen hierro. Ay jun ix yanab' vin̈ scuchan Naama. ");
INSERT INTO cac_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ay junel ix yal vin̈aj Lamec d'a eb' ix yetb'eyum icha tic: Ex vetb'eyum, ach Ada yed' ach Zila, ab'ec tas ol vala': Ix in mac'cham jun vin̈ quelem, yujto in lajvi smac'an vin̈. ");
INSERT INTO cac_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Tato uquel spactzitaj yic vin̈aj Caín, oc in xom a in tic, 77-el ol pactzitaj d'a eb' tzin tzuntzani, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Axo vin̈aj Adán ix alji junxo yuninal vin̈ yed' ix Eva. Set ix sb'iej yuj ix snun chi'. Ix yalan ix icha tic: A Dios ix ac'an junxo vune' tic sq'uexuloc vin̈aj Abel mac'b'ilcham yuj vin̈aj Caín, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Axo vin̈aj Set chi', ix alji jun yuninal vin̈, Enós ix yac' vin̈ sb'ioc. Atax d'a jun tiempoal chi', ix schael yich yalan sb'a eb' anima d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Aton yab'ixal eb' yin̈tilal vin̈aj Adán tic d'a stzolal. Ayic ix b'oji eb' anima yuj Dios, icha Dios ix aj eb'. ");
INSERT INTO cac_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ix b'oji vin̈ vinac yed' pax ix ix, ix yac'anpax svach'c'olal d'a yib'an̈ eb'. Atax d'a jun c'u chi' ayic ix b'ojiel eb' yuuj, anima ix sb'iejcan eb' yuuj. ");
INSERT INTO cac_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","A vin̈aj Adán chi', 130 ab'il sq'uinal vin̈ ayic ix alji junxo yuninal vin̈ scuchan Set, lajan ix aj yed' smam chi'. ");
INSERT INTO cac_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ix lajvi chi', 800 ab'ilto ix yil vin̈aj Adán chi'. Ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","930 ab'il ix yil vin̈, ix cham vin̈ b'ian. ");
INSERT INTO cac_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","A vin̈aj Set chi', 105 ab'il sq'uinal vin̈ ayic ix alji jun yuninal vin̈ scuchan Enós. ");
INSERT INTO cac_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ix lajvi chi', 807 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","912 ab'il ix yil vin̈, ix cham vin̈ b'ian. ");
INSERT INTO cac_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","A vin̈aj Enós chi', 90 ab'il sq'uinal vin̈ ayic ix alji jun yuninal vin̈ scuchan Cainán. ");
INSERT INTO cac_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ix lajvi chi', 815 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","905 ab'il ix yil vin̈, ix cham vin̈ b'ian. ");
INSERT INTO cac_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","A vin̈aj Cainán chi', 70 ab'il sq'uinal vin̈ ayic ix alji jun yuninal vin̈ scuchan Mahalalel. ");
INSERT INTO cac_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ix lajvi chi', 840 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","910 ab'il ix yil vin̈, ix cham vin̈ b'ian. ");
INSERT INTO cac_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","A vin̈aj Mahalalel chi', 65 ab'il sq'uinal vin̈ ayic ix alji jun yuninal vin̈ scuchan Jared. ");
INSERT INTO cac_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ix lajvi chi', 830 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","895 ab'il ix yil vin̈, ix cham vin̈ b'ian. ");
INSERT INTO cac_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","A vin̈aj Jared chi', 162 ab'il sq'uinal vin̈ ayic ix alji jun yuninal vin̈ scuchan Enoc. ");
INSERT INTO cac_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ix lajvi chi', 800 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","962 ab'il ix yil vin̈, ix cham vin̈ b'ian. ");
INSERT INTO cac_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","A vin̈aj Enoc chi', 65 ab'il sq'uinal vin̈ ayic ix alji jun yuninal vin̈ scuchan Matusalén. ");
INSERT INTO cac_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Yictax ix alji yuninal vin̈ chi', 300 ab'il ix sc'anab'ajej Dios vin̈. D'a jun tiempoal chi', ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","365 ab'il ix yil vin̈. ");
INSERT INTO cac_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ix sb'eyb'alej val vin̈ icha sgana Dios, yuj chi' ay jun c'u ix satem vin̈, yujto a Dios ix ic'anb'at vin̈ yed'oc. ");
INSERT INTO cac_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","A vin̈aj Matusalén chi', 187 ab'il sq'uinal vin̈ ayic ix alji jun yuninal vin̈ scuchan Lamec. ");
INSERT INTO cac_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ix lajvi chi' 782 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","969 ab'il ix yil vin̈, ix cham vin̈ b'ian. ");
INSERT INTO cac_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","A vin̈aj Lamec chi', 182 ab'il sq'uinal vin̈ ayic ix alji jun yuninal vin̈. ");
INSERT INTO cac_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Noé ix sb'iej yuj vin̈ yujto ix yal vin̈: A Jehová ix catab'an lum luum tic, yuj chi' te ya co munlaj d'a sat luum, palta a vin̈ unin tic ol ac'an snivanil co c'ool, xchi vin̈aj Lamec chi'. ");
INSERT INTO cac_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ayic toxo ix alji vin̈aj Noé chi', 595 ab'ilto ix yil vin̈aj Lamec chi', ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","777 ab'il ix yil vin̈, ix cham vin̈ b'ian. ");
INSERT INTO cac_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","A vin̈aj Noé chi', 500 ab'il sq'uinal vin̈ ayic ix syamanoch yalji eb' yuninal vin̈, aton vin̈aj Sem, vin̈aj Cam yed' vin̈aj Jafet. ");
INSERT INTO cac_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ayic ix te q'uib' sb'isul eb' anima d'a sat luum tic, ay pax yisil eb' vin̈ vinac ix alji. ");
INSERT INTO cac_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Axo eb' vin̈ yuninal Dios, ayic ix yilan eb' ix yisil eb' anima chi' eb' vin̈, te vach' yilji eb' ix, ix laj sic'lan eb' vin̈ machtac eb' ix syic' eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yuj chi' ix yal Jehová: Man̈xo ol vac' sq'uinal eb' anima tic yuj spital. Chamelb'a anima yaj eb', yuj chi' axon̈ej 120 ab'il olto ec' eb' d'a yolyib'an̈q'uinal tic, xchi. ");
INSERT INTO cac_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ayic ix b'eycot tiempo, ix yic'lan sb'a eb' vin̈ yuninal Dios yed' eb' ix yisil eb' anima chi', axo yuninal eb' scuch Nefilim. A eb' chi' te tec'an eb', te b'inajnac eb' d'a pecatax chi'. ");
INSERT INTO cac_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ix yilan Jehová to yelc'olal sq'uib' schucal eb' anima d'a sat luum tic, to axon̈ej tas malaj svach'il ayec' d'a spensar eb'. ");
INSERT INTO cac_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yuj chi' ix yala': Octom maj in b'olaj juntzan̈ anima tic. Te ya svab' yuj eb'. ");
INSERT INTO cac_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ol in satel juntzan̈ anima ix in b'o d'a sat luum tic yed' pax noc' molb'etzal noc', noc' c'ultaquil noc' yed' noc' tz'ec' n̈ern̈onoc ma tz'ec' jachjon d'a sat luum yed' pax noc' much. Ste tac val in c'ool yujto ix in b'o masanil juntzan̈ tic, xchi Dios. ");
INSERT INTO cac_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","An̈ej val vin̈aj Noé vach' d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Aton yab'ixal vin̈aj Noé tic: A vin̈aj Noé chi', te vach' ix yutej sb'a vin̈ d'a yichan̈ Dios, an̈ej vin̈ vach' spensar d'a scal eb' anima d'a jun tiempoal chi'. Ix sb'eyb'alej vin̈ icha sgana Dios. ");
INSERT INTO cac_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ay oxvan̈ yuninal vin̈, aton vin̈aj Sem, vin̈aj Cam yed' vin̈aj Jafet. ");
INSERT INTO cac_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Axo eb' anima, ix te chucb'i eb' d'a yichan̈ Dios, comonxon̈ej syixtej yetanimail eb', smil-lajcham sb'a eb'. ");
INSERT INTO cac_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ix yilan Dios to masanil anima ix te juvieli, axon̈ej ixtoj anima sc'ulej eb'. ");
INSERT INTO cac_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Yuj chi' ix yal Dios d'a vin̈aj Noé chi': Toxo ix in na' to ol in satel masanil anima tic. Yujto axon̈ej ixtoj anima sc'ulej eb', yuj chi' ol in satel eb' yed' masanil yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","A ticnaic, tza b'o junoc te' nivan barco. A te te' ay stzatajil, a te' tzac'och ste'aloc te'. Macquiltac tzutej yool te', vach' tzutej ac'anoch tzataj chi' b'aj snub'laj sb'a te'. Tzac'och d'a spatic yed' d'a yool, yic vach' malaj b'aj ol och a' d'a yol te'. ");
INSERT INTO cac_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","135 metro tzutej sc'atul te', 22 metro yed' nan̈alxo tzutej sat te', 13 metro yed' nan̈alxo steel te'. ");
INSERT INTO cac_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Oxe' piso tzutej te'. Axo d'a sjajq'uec'och te', ata' scan jacan smasanil, nan̈al metro tz'ajcan schaan̈il, scanpax junoc spuertail d'a junoc pac'an̈. ");
INSERT INTO cac_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Yujto ol vac'cot jun oval a' yic smucan sat luum tic, ol b'ud'joccanel yuj a', axo satel jantac tas syic' yic' d'a yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","An̈ej ed'oc tzin b'ocan jun in trato tic. A d'a yol te' nivan barco chi' ol ach ochcan yed' ix etb'eyum, eb' uninal yed' pax eb' ix alib'. ");
INSERT INTO cac_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ol ochpax noc' noc' eyed'oc, junjun mojan̈ noc' d'a junjun macan̈ ay d'a yolyib'an̈q'uinal tic, yic vach' ol colchajcan noc' eyed'oc. ");
INSERT INTO cac_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Chatacvan̈ noc' d'a junjun macan̈ tz'ochcani: Noc' much, noc' molb'etzal noc', noc' c'ultaquil noc' yed' noc' tz'ec' n̈ern̈onoc ma tz'ec' jachjon d'a sat luum, yic vach' man̈ ol satel noc'. ");
INSERT INTO cac_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ol a molancanoch jantac tas ol vajoc, yic vach' ay tas tze va yed' tas sva noc', xchi Dios d'a vin̈aj Noé chi'. ");
INSERT INTO cac_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ix sc'anab'ajan vin̈aj Noé chi' masanil tas ix yal Dios. ");
INSERT INTO cac_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Axo yic ix c'och sc'ual sjavi jun oval a' mucvajum chi', ix yalan Jehová Dios d'a vin̈aj Noé chi' icha tic: Ochan̈ d'a yol te' nivan barco tic yed' ix etb'eyum, eb' uninal yed' eb' ix alib', yujto a achn̈ej ix a c'anab'ajej d'ayin d'a scal masanil eb' anima d'a jun tiempoal tic. ");
INSERT INTO cac_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ic'och uc mojan̈oc noc' noc' syal yoch silab'oc sn̈uschaji, axo pax masanil noc' comon noc', junjunn̈ej mojan̈ noc' tz'ochi. ");
INSERT INTO cac_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ic'paxoch uc mojan̈oc junjun macan̈ noc' much, yic vach' max lajviel yin̈tilal noc'. ");
INSERT INTO cac_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Yic val ucub'ix ticnaic, ol vaq'uem n̈ab'. Chavinac c'u, chavinac ac'val ol yac'a'. Icha chi' ol aj in satanel masanil tas ix vac' pitzvoc d'a sat lum tic, xchi Jehová d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ichaton chi' ix aj sc'anab'ajan vin̈aj Noé masanil tas ix yal Jehová chi' d'ay. ");
INSERT INTO cac_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ayic ix ja jun oval a' mucvajum chi', 600 ab'il sq'uinal vin̈aj Noé chi'. ");
INSERT INTO cac_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ix ochcan vin̈ d'a yol te' nivan barco chi' yed' ix yetb'eyum, eb' yuninal yed' eb' ix yalib', yic scolchaj eb' d'a jun oval a' mucvajum chi'. ");
INSERT INTO cac_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ix ochpax noc' noc': Noc' syal yoch silab'il sn̈usji, noc' comon noc', noc' much yed' noc' tz'ec' n̈ern̈onoc ma tz'ec' jachjon d'a sat luum. ");
INSERT INTO cac_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Junjun mojan̈ ix aj sjavi noc' yic tz'och noc' d'a yol barco chi' yed' vin̈, icha ix aj yalan Dios d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Axo d'a yuquil c'ual chi' ix javi secnaj jun oval a' mucvajum chi' d'a sat luum. ");
INSERT INTO cac_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","A val stz'acvi 600 ab'il sq'uinal vin̈aj Noé chi', yic 17 yoch schab'il ujal, ix q'ueul d'in̈naj a' nivac a' d'a yol luum, ix cotpax secnaj a' nivac a' d'a satchaan̈. ");
INSERT INTO cac_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","40 c'ual, 40 ac'val ix yac' n̈ab' d'a sat luum tic. ");
INSERT INTO cac_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","A d'a sc'ual scot n̈ab' chi', ata' ochnaccan vin̈aj Noé d'a yol te' barco yed' oxvan̈ eb' yuninal vin̈, aton vin̈aj Sem, vin̈aj Cam yed' vin̈aj Jafet yed' ix yetb'eyum vin̈ yed' oxvan̈ eb' ix yalib' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ayxo och masanil macan̈il noc' noc' yed' vin̈, noc' molb'etzal noc', noc' c'ultaquil noc', noc' tz'ec' n̈ern̈onoc ma tz'ec' jachjon d'a sat luum yed' pax noc' much. ");
INSERT INTO cac_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Masanil noc' noc' syic' yic', chatacvan̈il ix aj sjavi noc' d'a vin̈aj Noé chi' yic tz'ochcan noc' d'a yol te' barco chi', ");
INSERT INTO cac_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","jun noc' smam, jun noc' snun. Icha chi' ix aj yoch masanil macan̈il noc', icha ix aj yalan Dios d'a vin̈aj Noé chi'. Ix lajvi chi', a val Jehová ix macancan spuertail te' nivan barco chi'. ");
INSERT INTO cac_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Chavinac c'ualxo sq'ue sib'ib'oc a a' chi', ix cuchjichan̈ te' barco chi' yuj a'. ");
INSERT INTO cac_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ix mucchaj jantac nivac vitz yuj a'. ");
INSERT INTO cac_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ix q'uen̈ej a', ay am uqueoc metro ix ec' a' d'a yib'an̈ lum nivac vitz. ");
INSERT INTO cac_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ichaton chi' ix aj scham masanil anima ay d'a yolyib'an̈q'uinal tic yed' masanil noc' noc', noc' much, noc' molb'etzal noc', noc' c'ultaquil noc' yed' noc' tz'ec' n̈ern̈onoc ma tz'ec' jachjon d'a sat luum. ");
INSERT INTO cac_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Masanil tastac syic' yic' d'a sat luum tic, pilan ix chameli. ");
INSERT INTO cac_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Axon̈ej vin̈aj Noé yed' eb' ayoch yed' d'a yol te' barco chi' yed' noc' noc' ix colchaji. Axo anima smasanil, ix satel eb'. ");
INSERT INTO cac_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Oye' ujal ix can pan̈an a' d'a yib'an̈ luum. ");
INSERT INTO cac_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Yujto naan vin̈aj Noé chi' yuj Dios yed' masanil noc' noc' ayoch yed' vin̈ d'a yol te' barco chi', yuj chi' ix ac'jicot jun ic' te ov yuj Dios d'a yib'an̈ a a' chi', yic vach' stupem a'. ");
INSERT INTO cac_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ix macchaj masanil sjaj a a', a' sq'ueul d'a yol luum yed' jantac a' nivac a' scot sequecoc d'a satchaan̈. Ix och vaan yac'an n̈ab'. ");
INSERT INTO cac_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Oye' ujal ix can a', ix och ijan stupxiem a', c'ojanc'olal ix tupem a'. ");
INSERT INTO cac_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","17 c'ualxo yoch yuquil uj, ix can b'achnaj te nivan barco chi' d'a sjolom jun lum vitz d'a yol yic Ararat. ");
INSERT INTO cac_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Numumi yem a a' chi'. A d'a b'ab'el c'ual yic lajun̈exo ujal, chequelxo sjolom lum nivac vitz. ");
INSERT INTO cac_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Axo yic ix ec' 40 c'ualxo, ix sjacan te' ventena vin̈aj Noé b'ob'il yuj d'a te' barco chi'. ");
INSERT INTO cac_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ix yactanelta jun noc' joj vin̈, ix ec' jen̈en̈oc noc' stan̈van stupem a' d'a sat luum. ");
INSERT INTO cac_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ix yactanpaxelta jun noc' uch vin̈ yic syil noc' tato taquin̈xo sat luum. ");
INSERT INTO cac_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Axo noc' uch chi', ix c'ochxi noc' d'a te' barco chi', yujto malaj b'aj syal scan vaan noc'. Te sib'anto ec' a' d'a sat luum chi'. Ix yac'anelta sc'ab' vin̈ yic schaanxioch noc' vin̈ d'a yol te' barco chi'. ");
INSERT INTO cac_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ixto stan̈vej uquexo c'ual vin̈aj Noé chi', ix yac'anelta noc' uch chi' vin̈ junelxo. ");
INSERT INTO cac_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Numumixo sq'uic'b'i ix c'ochxi noc', n̈ac'b'ilxo jun te' xil olivo yaxxo yuj noc'. Icha chi' ix aj yojtacanel vin̈ to van stacji sat luum. ");
INSERT INTO cac_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Uqueto c'u ix stan̈vej vin̈, ichato chi' ix sjacanelta noc' vin̈ junelxo, palta majxo c'ochxoclaj noc'. ");
INSERT INTO cac_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","601 ab'ilxo sq'uinal vin̈aj Noé chi', ayic ix tacjixi lum luum chi'. Ayic b'ab'el c'u yoch b'ab'el uj ix yic'anel yib'an̈ te' barco chi' vin̈, axo ix yilan vin̈ to taquin̈xo luum. ");
INSERT INTO cac_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Axo d'a 27-xo c'ual yoch yic schab'il ujal, te taquin̈xo luum. ");
INSERT INTO cac_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Axo ix yalan Dios d'a vin̈: ");
INSERT INTO cac_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Elan̈cot d'a yol te' barco yed' ix etb'eyum yed' eb' uninal yed' eb' ix alib'. ");
INSERT INTO cac_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Tzic'anelta masanil macan̈il noc' noc' ayoch ed'oc: Noc' much, noc' molb'etzal noc', noc' c'ultaquil noc', noc' tz'ec' n̈ern̈onoc ma tz'ec' jachjon d'a sat luum. Unevocab' noc' yic sb'ud'jixi sat luum tic yuj noc', xchi Dios. ");
INSERT INTO cac_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ix lajvi chi', ix elta vin̈aj Noé chi' yed' ix yetb'eyum yed' eb' yuninal yed' eb' ix yalib' d'a yol te' barco chi'. ");
INSERT INTO cac_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ix elixta noc' noc' chi' smasanil d'a junjun macan̈. ");
INSERT INTO cac_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ix lajvi chi', ix sb'oan jun altar vin̈ d'a yichan̈ Jehová. Ix yic'ancot noc' molb'etzal noc' vin̈ yed' noc' much, aton noc' smoj yoch silab'il d'a Dios. D'a junjun macan̈ noc' chi' ix yic'canel junjun noc' vin̈ sn̈ustz'a silab'oc d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Te vach' sjab' noc' silab' chi' ix yab' Jehová. Yuj chi' ix yalan icha tic: Man̈xo ol in catab'ej lum luum tic yuj smul eb' anima, yujto yictax unin anima eb', an̈ej chucal sgana eb' sc'ulej. Man̈xa b'aq'uin̈ ol in satel masanil tas pitzan, icha ix vutej d'a junel tic. ");
INSERT INTO cac_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Yacb'an ayto ec' yolyib'an̈q'uinal tic, ol avchaj sat aval in̈at, ol molchajpax sat. Ay stiempoal c'ac', ay stiempoal siic. Ay stiempoal n̈ab'il q'uinal, ay stiempoal varesma. Ay c'ualil, ay pax d'ac'valil, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ix lolon Dios d'a vin̈aj Noé yed' d'a eb' yuninal vin̈, ix yalani to ol yac' syaxil d'a yib'an̈ eb'. Ix yalan icha tic: Tzijtumocab' eyuninal tz'alji, b'ud'jocab' yolyib'an̈q'uinal tic yuj eb'. ");
INSERT INTO cac_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Masanil noc' noc' ay d'a sat luum tic yed' noc' much yed' noc' ay d'a yol a' mar ol xiv noc' d'ayex. Masanil juntzan̈ noc' tic scan noc' d'a yol e c'ab'. ");
INSERT INTO cac_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","A ticnaic syal e chi'an masanil noc' noc' tic. A in svac' noc' d'ayex icha ix aj vac'an an̈ itaj e chi'a. ");
INSERT INTO cac_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Palta ay jun tas man̈ ol yal-laj e chi'ani, aton noc' chib'ej syuc' schiq'uil, yujto a d'a schiq'uil noc' chi' ay sq'uinal. ");
INSERT INTO cac_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","A in ol in ch'olb'itej eb' anima smilancham junoc yetanimail. A noc' noc' smilancham anima, ol miljocpaxcham noc'. ");
INSERT INTO cac_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","A mach smilancham yetanimail, anima pax ol milanchamoc, yujto a ex anima ex tic, icha on̈ tic, icha chi' ex cutej co b'oani. ");
INSERT INTO cac_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Tzijtumocab' eyuninal tz'alji, b'ud'jocab'el yolyib'an̈q'uinal tic eyuuj, xchi Dios. ");
INSERT INTO cac_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ix yalanpax Dios d'a vin̈aj Noé yed' d'a eb' yuninal icha tic: ");
INSERT INTO cac_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","A ticnaic, svac'can jun in trato tic eyed'oc yed' masanil eb' eyin̈tilal, ");
INSERT INTO cac_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","yed' masanil noc' noc' ix elta eyed'oc d'a yol te' barco tic: Noc' much, noc' molb'etzal noc', noc' c'ultaquil noc' yed' masanil noc' noc' ay d'a yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","A jun in trato ol vac' eyed'oc tic, man̈xo ol in q'uexa'. Man̈xo ol in satel anima yed' noc' noc' yuj junoc oval a' mucvajum. Man̈xo ol jax jun oval a' mucvajum yic satxiel sat luum tic, icha jun ix ec' tic. ");
INSERT INTO cac_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Aton yechel in trato tic svac'can eyed'oc yed' masanil noc' noc' d'a masanil q'uinal. ");
INSERT INTO cac_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Svac'och jun chacpan d'a cal asun, a jun chi', aton yechel in trato yed' yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ayic svac'ancot asun axo scheclaj jun chacpan chi' d'a scal, ");
INSERT INTO cac_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ata' tzin nacot in trato ix vac' eyed'oc yed' noc' noc', yuj chi' man̈xo ol ex in satel yuj junoc oval a' mucvajum. ");
INSERT INTO cac_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ayic svilan jun chacpan chi', tzin naancoti to ay jun in trato ix vac' d'a juneln̈ej eyed'oc yed' masanil noc' noc' ay d'a yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Aton yechel in trato tic ix in b'o eyed'oc yed' jantac noc' noc', xchi Dios d'a vin̈aj Noé chi'. ");
INSERT INTO cac_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","A eb' yuninal vin̈aj Noé ix elta d'a yol te' barco yed'oc: Aton vin̈aj Sem, vin̈aj Cam yed' vin̈aj Jafet. Ay jun yuninal vin̈aj Cam chi' scuchan Canaán. ");
INSERT INTO cac_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","A eb' tic yuninal eb' vin̈aj Noé, axo d'a yin̈tilal eb' ix pitzvielta jantac chon̈ab' ay d'a sat luum tic. ");
INSERT INTO cac_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","A vin̈aj Noé ix munlaj vin̈ d'a sat luum. A te' uva ix sb'ab'laj avej vin̈. ");
INSERT INTO cac_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ay jun c'u ix yuc' yal sat te' uva chi' vin̈, ix q'ue d'a sjolom vin̈, ix satel sc'ool vin̈ yuuj. Ix squichel spichul vin̈, ix can pac'jab' vin̈ d'a yol smantiado. ");
INSERT INTO cac_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Axo ix yilan vin̈aj Cam, smam vin̈aj Canaán to b'eranel vin̈aj Noé chi', van stzetzan vin̈ smam vin̈ chi' ayic ix yalan vin̈ yab' eb' yuc'tac chi' schavan̈il. ");
INSERT INTO cac_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ayic ix yab'an eb' yuc'tac vin̈ chi', ix yac'ancot jun c'apac sábana eb' d'a sjolom sjen̈jab'. Ix b'eyb'at eb' d'a spatic, ix ochc'och eb' b'aj ay smam chi', ix spichan vin̈ eb' d'a c'apac sábana chi'. Ch'oc b'aj q'uelanb'at eb' yic vach' max yil snivanil smam eb' chi'. ");
INSERT INTO cac_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Axo yic ix nachajxi sc'ol vin̈aj Noé chi', ix yab'an vin̈ tas ix yutej sb'a vin̈aj Cam chi', aton vin̈ schab'il yuninal. ");
INSERT INTO cac_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Yuj chi' ix yalan vin̈ icha tic: Tzin catab'ejcan vin̈aj Canaán. Checab' emnaquil ol ajcan vin̈ d'a eb' yuc'tac, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ix yalanxi vin̈ icha tic: Yac'ocab' svach'c'olal Jehová co Diosal d'a yib'an̈ vin̈aj Sem, axo vin̈aj Canaán tz'ochcan schecab'oc vin̈. ");
INSERT INTO cac_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nivanocab' tz'ajcan slum vin̈aj Jafet yuj Dios. Cajnajocab' Dios d'a scal yin̈tilal vin̈aj Sem, axo vin̈aj Canaán tz'ochcan schecab'oc vin̈aj Jafet chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ayic ix lajvi yec' jun oval a' mucvajum chi', 350 ab'ilto ix ec' vin̈aj Noé chi', ");
INSERT INTO cac_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","yuj chi' 950 ab'il sq'uinal vin̈ ayic ix cham vin̈. ");
INSERT INTO cac_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","A yab'ixal eb' yin̈tilal vin̈aj Noé tic: Aton vin̈aj Sem, vin̈aj Cam yed' vin̈aj Jafet. Ayic ix lajvi yec' jun oval a' mucvajum chi', ix laj alji yuninal eb'. ");
INSERT INTO cac_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","A sb'i eb' yuninal vin̈aj Jafet: Aton vin̈aj Gomer, vin̈aj Magog, vin̈aj Madai, vin̈aj Javán, vin̈aj Tubal, vin̈aj Mesec yed' vin̈aj Tiras. ");
INSERT INTO cac_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","A sb'i eb' yuninal vin̈aj Gomer: Aton vin̈aj Askenaz, vin̈aj Rifat yed' vin̈aj Togarma. ");
INSERT INTO cac_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","A sb'i eb' yuninal vin̈aj Javán: Aton vin̈aj Elisa, vin̈aj Tarsis, vin̈aj Quitim yed' vin̈aj Dodanim. ");
INSERT INTO cac_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Aton eb' tic yin̈tilal vin̈aj Jafet. Ix cajnaj eb' d'a stitac a' mar, junjun macan̈ yin̈tilal eb' yed' smacb'en yed' sti' syala'. ");
INSERT INTO cac_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","A sb'i eb' yuninal vin̈aj Cam: Aton vin̈aj Cus, vin̈aj Mizraim, vin̈aj Fut yed' vin̈aj Canaán. ");
INSERT INTO cac_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","A sb'i eb' yuninal vin̈aj Cus: Aton vin̈aj Seba, vin̈aj Havila, vin̈aj Sabta, vin̈aj Raama yed' vin̈aj Sabteca. A sb'i eb' yuninal vin̈aj Raama: Aton vin̈aj Seba yed' vin̈aj Dedán. ");
INSERT INTO cac_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","A vin̈aj Cus ay yuninal vin̈aj Nimrod. A vin̈aj Nimrod chi' b'ab'el ix och yajalil d'a scal eb' chon̈ab'. ");
INSERT INTO cac_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Te julum noc' vin̈ d'a yichan̈ Jehová, yuj chi' ay jun lolonel d'a scal eb' anima tz'alan icha tic: Lajan vin̈ icha vin̈aj Nimrod, vin̈ te julum noc' d'a yol sat Jehová, xchi jun lolonel chi'. ");
INSERT INTO cac_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","A d'a sb'ab'elal, yajal yaj vin̈aj Nimrod d'a yib'an̈ Babel, Erec, Acad yed' Calne. A d'a yol smacb'en Sinar ata' ay juntzan̈ chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ix lajvi chi', ix b'at vin̈ d'a Asiria. Ata' ix sb'o chan̈exo nivac chon̈ab' vin̈: Aton chon̈ab' Nínive, Rehobot, Cala ");
INSERT INTO cac_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","yed' Resén, aton jun chon̈ab' ay d'a scal Nínive yed' Cala. A chan̈e' chon̈ab' chi', junxon̈ej nivan chon̈ab'il ix aji. ");
INSERT INTO cac_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Axo d'a vin̈aj Mizraim ix cot eb' Ludim, eb' Anamim, eb' Lehabim, eb' Naftuhim, ");
INSERT INTO cac_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","eb' Patrusim, eb' Casluhim yed' eb' Caftorim. A d'a eb' chi' ix cot eb' filisteo. ");
INSERT INTO cac_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","A vin̈aj Canaán smam vin̈aj Sidón yed' vin̈aj Het. A vin̈aj Sidón chi', b'ab'el unin vin̈. ");
INSERT INTO cac_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","A vin̈aj Canaán chi' smam icham eb' jebuseo, eb' amorreo, eb' gergeseo, ");
INSERT INTO cac_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","eb' heveo, eb' araceo, eb' sineo, ");
INSERT INTO cac_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","eb' arvadeo, eb' zemareo, eb' amateo. Ayic ix b'ey tiempo ix saclemcanb'at eb' cananeo chi'. ");
INSERT INTO cac_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","A sluum eb', tzato c'och d'a smojonal Sidón masanto d'a stojolal Gerar, masanto d'a Gaza. Scumlajxib'at luum d'a yol smacb'en chon̈ab' Sodoma, Gomorra, Adma yed' Zeboim masanto sc'och lum d'a chon̈ab' Lasa. ");
INSERT INTO cac_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ata' ix cajnaj eb' yin̈tilal vin̈aj Cam, junjun macan̈ yin̈tilal eb' d'a yol smacb'en yed' sti' syala'. ");
INSERT INTO cac_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Axo pax vin̈aj Sem, vin̈ b'ab'el vinac d'a vin̈aj Jafet, ay pax yuninal vin̈. A on̈ masanil on̈ tic, yin̈tilal on̈ vin̈aj Heber, cotnac on̈ d'a yin̈tilal vin̈aj Sem. ");
INSERT INTO cac_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","A eb' yuninal vin̈aj Sem chi', aton vin̈aj Elam, vin̈aj Asur, vin̈aj Arfaxad, vin̈aj Lud yed' vin̈aj Aram. ");
INSERT INTO cac_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Axo eb' yuninal vin̈aj Aram, aton vin̈aj Uz, vin̈aj Hul, vin̈aj Geter yed' vin̈aj Mas. ");
INSERT INTO cac_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","A vin̈aj Arfaxad ay yuninal vin̈aj Sala, axo vin̈aj Sala chi' ay yuninal vin̈aj Heber. ");
INSERT INTO cac_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Axo vin̈aj Heber chi', chavan̈ yuninal vin̈, Peleg sb'i jun vin̈. A d'a yol stiempoal vin̈ tic ix pucaxcanb'at eb' anima d'a sat lum luum tic. Axo junxo vin̈ scuchan Joctán. ");
INSERT INTO cac_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","A vin̈aj Joctán chi' ay yuninal vin̈aj Almodad, vin̈aj Selef, vin̈aj Hazar-mavet, vin̈aj Jera, ");
INSERT INTO cac_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","vin̈aj Adoram, vin̈aj Uzal, vin̈aj Dicla, ");
INSERT INTO cac_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","vin̈aj Obal, vin̈aj Abimael, vin̈aj Seba, ");
INSERT INTO cac_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","vin̈aj Ofir, vin̈aj Havila yed' vin̈aj Jobab. Masanil eb' tic, a vin̈aj Joctán ay yuninal eb'. ");
INSERT INTO cac_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ix cajnaj eb' d'a lum scot d'a Mesa, masanto sc'och d'a Sefar d'a tzalquixtac d'a stojolal b'aj sjavi c'u. ");
INSERT INTO cac_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ata' ix cajnaj eb' yin̈tilal vin̈aj Sem, junjun macan̈ yin̈tilal eb' d'a yol smacb'en yed' sti' syala'. ");
INSERT INTO cac_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Masanil juntzan̈ anima tic, a eb' yuninal vin̈aj Noé ay yin̈tilal eb', junjun macan̈ yin̈tilal eb' yed' smacb'en. Ayic ix lajvi yec' jun oval a' mucvajum chi', ix saclemcanb'at eb'. A d'a eb' tic ix pitzvi juntzan̈ nación ay d'a yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","2","A d'a peca', ayic toxo ix ec' jun oval a' mucvajum chi', junn̈ej ti'al syal eb' anima. Ayic van sb'at eb' d'a stojolal b'aj sjavi c'u, ix c'och cajan eb' d'a jun nivan ac'lic d'a yol yic Sinar. Ata' ix cajnaj eb'. ");
INSERT INTO cac_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ay jun c'u ix yal-laj yab' eb' icha tic: Co b'oec lum ladrillo, sco mucan chacb'oc luum, xchi eb'. A lum ix yac'lab'ej eb' sq'uexuloc q'uen q'ueen. Axo spixul luum, ay jun sq'ueta d'a yol luum, te tat, axo stacji, te tzatz tz'aji, asfalto sb'i, a jun chi' ix yac'lab'ej eb'. ");
INSERT INTO cac_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ix lajvi chi', ix yalan eb' vin̈ icha tic: Caq'uec quip co b'oec junoc co nivan chon̈ab'. Sco b'oanecpax junoc nivan torre, te chaan̈ tz'ajq'ue d'a satchaan̈ yic vach' tzon̈ te b'inaji. Junxon̈ej scutej co b'a, man̈ ol on̈ saclemb'at d'a yolyib'an̈q'uinal tic, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Axo Jehová ix emul yil jun chon̈ab' yed' jun torre van sb'oan eb' chi'. ");
INSERT INTO cac_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ix yalan icha tic: Ix el yich jun munlajel yuj eb' anima tic. Malaj tas scachanoch vaan eb' vin̈ yic sb'oan eb' tas nab'il yuuj, yujto junn̈ej chon̈ab'il yaj eb', junn̈ej ti' syal eb'. ");
INSERT INTO cac_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","A ticnaic, con̈ emec d'a scal eb' yic sco somchitan sti' eb', yic vach' man̈xo ol nachajel yuj eb' tastac syal junjun, xchi Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Icha chi' ix aj saclemcanb'at eb' yuj Jehová d'a sat luum tic. Ix yactan eb' sb'oan jun chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Aton ta' ix somchajcanb'at sti' eb' anima chi' yuj Jehová. Yuj chi' ix saclemcanb'at eb' d'a smasanil yolyib'an̈q'uinal tic. Yuj chi' Babel ix sb'iejcan jun chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Aton yab'ixal vin̈aj Sem tic: Schab'ilxo ab'il yec'b'at jun oval a' mucvajum chi', ayic 100 ab'ilxo sq'uinal vin̈aj Sem, ix alji jun yuninal vin̈ scuchan Arfaxad. ");
INSERT INTO cac_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ix lajvi chi', 500 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","35 ab'il sq'uinal vin̈aj Arfaxad chi' ayic ix alji jun yuninal vin̈ scuchan Sala. ");
INSERT INTO cac_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ix lajvi chi', 403 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","30 ab'il sq'uinal vin̈aj Sala chi' ayic ix alji jun yuninal vin̈ scuchan Heber. ");
INSERT INTO cac_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ix lajvi chi', 403 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","34 ab'il sq'uinal vin̈aj Heber chi' ayic ix alji jun yuninal vin̈ scuchan Peleg. ");
INSERT INTO cac_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ix lajvi chi', 430 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","30 ab'il sq'uinal vin̈aj Peleg chi' ayic ix alji jun yuninal vin̈ scuchan Reu. ");
INSERT INTO cac_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ix lajvi chi', 209 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","32 ab'il sq'uinal vin̈aj Reu chi' ayic ix alji jun yuninal vin̈ scuchan Serug. ");
INSERT INTO cac_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ix lajvi chi', 207 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","30 ab'il sq'uinal vin̈aj Serug chi' ayic ix alji jun yuninal vin̈ scuchan Nacor. ");
INSERT INTO cac_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ix lajvi chi' 200 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","29 ab'il sq'uinal vin̈aj Nacor chi' ayic ix alji jun yuninal vin̈ scuchan Taré. ");
INSERT INTO cac_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ix lajvi chi', 119 ab'ilto ix yil vin̈, ayto yuninal vin̈ yed' yisil vin̈ ix alji. ");
INSERT INTO cac_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","70 ab'il sq'uinal vin̈aj Taré chi' ayic ix alji jun yuninal vin̈ scuchan Abram. Ix lajvi chi', ix alji vin̈aj Nacor yed' vin̈aj Harán, aton eb' oxvan̈ yuninal vin̈aj Taré chi'. ");
INSERT INTO cac_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Aton yab'ixal vin̈aj Taré tic: Aton vin̈ smam vin̈aj Abram, vin̈aj Nacor yed' vin̈aj Harán. A vin̈aj Harán chi' smam vin̈aj Lot. ");
INSERT INTO cac_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ix cham vin̈aj Harán chi' d'a chon̈ab' Ur d'a yol yic Caldea, ayic mantzac cham vin̈aj Taré chi'. A b'aj aljinac vin̈ chi', ata' chamnacpax vin̈. ");
INSERT INTO cac_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ix yic'lan sb'a vin̈aj Abram yed' ix Sarai. Axo vin̈aj Nacor ix yic'laj sb'a yed' ix Milca, yisil vin̈aj Harán, snulej sb'a ix yed' ix Isca. ");
INSERT INTO cac_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","A ix Sarai chi' max unevilaj ix. ");
INSERT INTO cac_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ix el vin̈aj Taré chi' d'a chon̈ab' Ur d'a yol yic Caldea, yic scotcan vin̈ d'a yol yic Canaán yalani. Ix yic'ancot vin̈ yuninal vin̈ yed'oc, aton vin̈aj Abram yed' pax vin̈aj Lot, aton yixchiquin vin̈ yuninal vin̈aj Harán chamnac. Ix yic'paxcot ix yalib' vin̈, aton ix Sarai. Axo yic ix javi eb' d'a chon̈ab' Harán, ix cajnajcan eb' ta'. ");
INSERT INTO cac_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","A d'a Harán chi' ix cham vin̈aj Taré chi'. 205 ab'il sq'uinal vin̈ ayic ix cham vin̈. ");
INSERT INTO cac_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ayxotax yalan Jehová d'a vin̈aj Abram icha tic: Actejcan a lum tic yed' jantac eb' ay uj a b'a yed'oc yed' eb' ayec' d'a spat a mam, ol ach b'at d'a jun luum ol in ch'ox d'ayach. ");
INSERT INTO cac_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","A in̈tilal ol och nivac nacional vuuj, ol in ch'oxan in vach'c'olal d'ayach. Yelxo val nivan ol aj a b'inaji, uuj ol scha vach'c'olal masanil eb' anima. ");
INSERT INTO cac_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ol vac' in vach'c'olal d'a eb' vach' syutej sb'a d'ayach, ol in catab'ejpax eb' chuc syutej sb'a. Uujn̈ej ol vac' in vach'c'olal d'a yib'an̈ masanil eb' anima d'a yolyib'an̈q'uinal tic, xchi Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Yuj chi' ix el vin̈aj Abram d'a yol yic Harán chi', icha ajnac yalancan Jehová d'a vin̈. 75 ab'il sq'uinal vin̈ ayic ix el vin̈ d'a yol yic Harán chi'. Ix yic'ancot ix yetb'eyum vin̈ yed'oc, aton ix Sarai. Ix yic'paxcot vin̈aj Lot vin̈, aton vin̈ yunin vin̈ yuc'tac vin̈ chamnac. Ix yic'paxcot eb' schecab' vin̈ yed' jantac tas ix aj d'a vin̈ ayic ix ec' vin̈ d'a Harán chi'. Icha chi' ix aj sja vin̈ d'a yol yic Canaán. ");
INSERT INTO cac_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ix cotn̈ej vin̈ d'a yol yic Canaán chi' masanto ix javi vin̈ d'a Siquem b'aj ay jun te' ji d'a yol yic More. A jun te' chi' chajul yuj eb' cananeo cajan ta'. ");
INSERT INTO cac_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ata' ix sch'ox sb'a Jehová d'a vin̈aj Abram chi', ix yalan d'a vin̈ icha tic: Masanil jun luum tic ol vac' d'a eb' in̈tilal, xchi d'a vin̈. Yuj chi' ix sb'o jun altar vin̈aj Abram chi' d'a yichan̈ Jehová, yujto ata' ix sch'ox sb'a d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ix lajvi chi', ix b'at vin̈ d'a tzalquixtac d'a snan̈al chon̈ab' Betel yed' chon̈ab' Hai. Ata' ix sb'oq'ue smantiado vin̈. A chon̈ab' Betel chi', a d'a stojolal b'aj tz'em c'u ay. Ata' ix sb'o junxo altar vin̈ yic syal sb'a vin̈ d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ix lajvi chi' c'ojanc'olal ix cotxi vin̈ masanto ix javi vin̈ d'a yol yic Neguev. ");
INSERT INTO cac_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","A d'a jun tiempoal chi', ix ja jun nivan vejel d'a jun lugar b'aj ayec' vin̈aj Abram chi'. Yuj chi' ix b'at cajan vin̈ jun tiempoal d'a Egipto. ");
INSERT INTO cac_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ayic van sc'och vin̈ d'a Egipto chi', ix yalan vin̈ d'a ix yetb'eyum chi' aton ix Sarai: A ticnaic ay jun tas tzin na'a: A ach tic te vach' ilji. ");
INSERT INTO cac_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Yuj chi' ayic ol ach yilan eb' vin̈ aj Egipto tic, ol am yal eb' vin̈ icha tic: A ix tic yetb'eyum ton val vin̈ tic ix, yuj chi' co mileccham vin̈ yic scan ix qued'oc, xcham eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Yuj chi' sval d'ayach to vanab' ach alani, yic vach' xajan ol in aj yuj eb' vin̈, man̈ ol in smilcham eb' vin̈ uuj, xchi vin̈ d'a ix. ");
INSERT INTO cac_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ayic ix c'och vin̈ d'a Egipto chi', ix yilanoch eb' vin̈ cajan ta' to a ix Sarai chi' te vach' yilji ix. ");
INSERT INTO cac_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ix yilanpax eb' ay yopisio yed' vin̈ rey to te vach' yilji ix, ix b'at yalan eb' vin̈ d'a vin̈ rey chi'. Yuj chi' ix yic'anb'at ix eb' vin̈ d'a spat vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Yuj ix Sarai chi', te xajan ix aj vin̈aj Abram yuj vin̈ rey chi'. Tzijtum noc' calnel, noc' vacax, noc' mam b'uru yed' noc' snun yed' noc' camello ix siaj d'a vin̈ yuj vin̈ rey chi'. Ay pax eb' vin̈ vinac yed' eb' ix ix, ix ac'ji schecab'oc vin̈. ");
INSERT INTO cac_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Palta yujn̈ej ix, tzijtum yaelal ix javi d'a yib'an̈ vin̈ rey yed' eb' cajan yed' vin̈ d'a spat yuj Jehová. ");
INSERT INTO cac_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Yuj chi' ix schec vin̈ rey chi' avtajcot vin̈aj Abram chi', ix yalan vin̈ icha tic: ¿Tas yuj icha tic tzin utej? ¿Tas yuj maj al d'ayin tato etb'eyum ix tic? ");
INSERT INTO cac_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ina ix ala' to anab' ix, yuj chi' ix in na to tz'och ix vetb'eyumoc. A ticnaic jun, ic'b'at ix, ixiquec, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ix lajvi chi' ix yalan vin̈ rey chi' d'a eb' schecab' to tz'ic'jiel vin̈aj Abram d'a yol smacb'en Egipto chi' yed' ix yetb'eyum yed' masanil tas ay d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ayic ix el vin̈aj Abram yed' ix yetb'eyum d'a Egipto chi' yed' masanil tas ay d'a vin̈, ix meltzaj eb' d'a yol yic Neguev. Ix meltzajpax vin̈aj Lot yed' eb'. ");
INSERT INTO cac_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","A vin̈aj Abram chi', te b'eyumxo vin̈, ay q'uen oro, q'uen plata yed' jantac noc' noc' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ix elxi vin̈ d'a Neguev chi'. C'ojanc'olal ix c'ochxi vin̈ d'a yol yic Betel b'aj ec'nac d'a sb'ab'elal, aton d'a scal Betel yed' Hai. ");
INSERT INTO cac_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ata' b'ob'ilcan jun altar yuj vin̈ d'a yalan̈taxo. Ata' ix yalxi sb'a vin̈ d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","A vin̈aj Lot chi' junn̈ej tz'ec' vin̈ yed' vin̈aj Abram chi'. Tzijtum pax noc' scalnel vin̈ yed' noc' svacax. Tzijtum pax eb' schecab' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Maxtzac yab'laj lugar b'aj sva noc' snoc' eb' chi' yujto te tzijtum noc'. Yuj chi', maxtzac yal-laj junn̈ej tz'ec' eb'. ");
INSERT INTO cac_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","A eb' vin̈ stan̈vumal noc' smolb'etz noc' vin̈aj Abram chi', syac' oval eb' yed' eb' vin̈ stan̈vumal noc' yic vin̈aj Lot chi'. A d'a jun tiempoal chi', aytoec' cajan eb' cananeo yed' eb' ferezeo ta'. ");
INSERT INTO cac_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ay jun c'ual ix yal vin̈aj Abram d'a vin̈aj Lot chi' icha tic: Ina ayto cuj co b'a, man̈ vach'oc tato scac' oval, vach'chom a eb' stan̈vumal noc' co molb'etzal noc' tic, man̈ vach'oc tato syac' oval eb'. ");
INSERT INTO cac_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Masanil jun lugar tic colan yaji. Syal a sic'lani b'ajtil tzach cani, yic vach' sco poj co b'a. Tato tzach elcan d'a yelc'och chi', a inxo tzin ochcan d'a yochc'och chi'. Tato tzach ochcan d'a yochc'och chi' jun, a inxo tzin elcan d'a yelc'och chi', xchi vin̈aj Abram chi' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ix b'at d'an̈an vin̈aj Lot chi' d'a jun nivan ac'lic ay d'a sti' a' Jordán masanto sc'och d'a chon̈ab' Zoar. Te yax sat jun ac'lic chi' yuj a a' chi', lajan yilji icha jun avb'en te' b'ob'il yuj Jehová, icha yilji yol yic Egipto ix yil vin̈. Ayic ix sb'oan strato vin̈aj Abram yed' vin̈aj Lot chi', manto satel-laj chon̈ab' Sodoma yed' Gomorra yuj Jehová. ");
INSERT INTO cac_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","A jun ac'lic d'a sti' a' Jordán chi' ix sic'canel vin̈aj Lot chi', ix b'at cajnaj vin̈ d'a stojolal b'aj sja c'u. Icha chi' ix aj spojlan sb'a vin̈aj Abram yed' vin̈aj Lot chi'. ");
INSERT INTO cac_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Yuj chi' ix can vin̈aj Abram d'a yol smacb'en Canaán, axo pax vin̈aj Lot chi', ix cajnaj vin̈ d'a scal juntzan̈ chon̈ab' d'a yac'lical sti' a' Jordán, d'a slac'anil chon̈ab' Sodoma. ");
INSERT INTO cac_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","A d'a jun chon̈ab' chi', te chuc sb'eyb'al eb' anima, man̈ jantacoc chucal sc'ulej eb' d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ayic toxo ix b'at vin̈aj Lot chi', ix yalan Jehová d'a vin̈aj Abram chi' icha tic: A ticnaic ilb'at d'a ichan̈, d'a a patic yed' d'a a tz'eytac. ");
INSERT INTO cac_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Masanil juntzan̈ luum van ilanb'at chi', svac' d'ayach d'a juneln̈ej yed' d'a eb' in̈tilal. ");
INSERT INTO cac_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Icha val spococal lum luum, malaj mach syal sb'isani, icha chi' ol aj in̈tilal. ");
INSERT INTO cac_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","A ticnaic q'uean̈ vaan yic tza b'eytzitan yoc jun lum tic yed' sc'atul, yujto svac' jun luum tic d'ayach, xchi Jehová d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ix lajvi chi' ix yic'anchaan̈ scampamento vin̈aj Abram chi', ix b'at cajnaj vin̈ d'a slac'anil juntzan̈ te' ji d'a yol smacb'en jun vin̈ scuch Mamre d'a slac'anil chon̈ab' Hebrón. Ix sb'oan jun altar vin̈ b'aj syal sb'a d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","A d'a jun tiempoal chi', ix yac' oval cha macan̈ eb' vin̈ rey. Jun macan̈ eb' vin̈: Aton vin̈aj Amrafel sreyal Sinar, vin̈aj Arioc sreyal Elasar, vin̈aj Quedorlaomer sreyal Elam yed' vin̈aj Tidal sreyal Goim. Junxo macan̈ eb': Aton vin̈aj Bera sreyal Sodoma, vin̈aj Birsa sreyal Gomorra, vin̈aj Sinab sreyal Adma, vin̈aj Semeber sreyal Zeboim yed' vin̈ sreyal Bela, aton jun chon̈ab' Zoar ticnaic. ");
INSERT INTO cac_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","A ovan̈ eb' vin̈ rey chi' ix slajtiej sb'a eb' vin̈, junxon̈ej ix yutej soldado eb' vin̈ d'a jun ac'lic scuch Sidim b'aj ay a' mar Muerto ticnaic. ");
INSERT INTO cac_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","A eb' vin̈ rey chi', slajchavilxo ab'il yajoch eb' vin̈ d'a yalan̈ smandar vin̈aj rey Quedorlaomer. Axo ix ec' junxo ab'il majxo yac'laj q'uen tumin eb' vin̈ syac'taxon d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Yuj chi' d'a junxo ab'il ix b'at vin̈ rey chi' yed' oxvan̈xo eb' vin̈ rey ayoch yed'oc d'a yol yic Astarot Karnaim. Ata' ix ac'ji ganar eb' refaíta yuj eb' vin̈. Ix ac'jipax ganar eb' zuzita yuj eb' vin̈ d'a yol yic Ham. Ix ac'jipax ganar eb' vin̈ emita yuj eb' vin̈ d'a yol yic Save-quiriataim. ");
INSERT INTO cac_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ix ac'jipax ganar eb' horeo yuj eb' vin̈ d'a jun tzalan scuch Seir, ix pechji eb' masanto d'a jun ac'lic Parán, d'a slac'anil jun lum taquin̈ luum. ");
INSERT INTO cac_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ayic ix meltzajxi vin̈aj rey Quedorlaomer yed' eb' vin̈ ayoch yed'oc, ix javi eb' vin̈ d'a En-mispat, an̈eja' jun lugar chi' scuchanpax Cades. Ix satel masanil tas ay d'a yol yic eb' amalecita yuj eb' vin̈ yed' tas ay d'a eb' amorreo ay d'a yol yic Hazezon-tamar. ");
INSERT INTO cac_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Axo ovan̈ eb' vin̈ rey, aton vin̈ yic Sodoma, vin̈ yic Gomorra, vin̈ yic Adma, vin̈ yic Zeboim yed' vin̈ yic Bela, ix b'at eb' vin̈ d'a ac'lic Sidim. Ata' ix yac' oval eb' vin̈ yed' chan̈van̈xo eb' vin̈ rey chi', aton vin̈aj Quedorlaomer, vin̈aj Tidal, vin̈aj Amrafel yed' vin̈aj Arioc. ");
INSERT INTO cac_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","A d'a yac'lical Sidim chi', tzijtum b'ajtac sq'ueta jun asfalto te tzayayi. Yuj chi' ayic ix b'at vin̈ sreyal Sodoma yed' vin̈ yic Gomorra elelal, ay eb' soldado eb' ix b'atcan d'a scal asfalto chi', ay juntzan̈xo eb' ix b'atcan elelal d'a jolomtac vitz. ");
INSERT INTO cac_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","A chan̈van̈ eb' vin̈ rey ix ac'an ganar chi', ix b'at eb' vin̈ yiq'uelta masanil tas svaji yed' masanil tas te ay stojol d'a Sodoma yed' d'a Gomorra chi', ix b'at eb' vin̈ b'ian. ");
INSERT INTO cac_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","A vin̈aj Lot, sc'ab' yoc vin̈aj Abram, cajan d'a Sodoma chi', ix ic'jib'at vin̈ yuj eb' vin̈ yed' masanil tas ay d'ay. ");
INSERT INTO cac_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Palta ay jun vin̈ ixto yac' ganar yeli, ix b'at yalan vin̈ d'a vin̈aj Abram vin̈ hebreo to ix ic'jib'at vin̈aj Lot chi'. A vin̈aj Abram chi' cajan vin̈ d'a slac'anil juntzan̈ te' ji d'a yol smacb'en vin̈aj Mamre vin̈ amorreo, yuc'tac sb'a yed' vin̈aj Escol yed' vin̈aj Aner. A eb' chi' vach' yac'an eb' yed' vin̈aj Abram chi'. ");
INSERT INTO cac_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ayic ix yab'an vin̈aj Abram to ix ic'jib'at vin̈aj Lot chi', ix smolb'an masanil eb' schecab' vin̈ c'ayb'ab'il d'a oval, aton eb' ix alji d'a yol scuenta vin̈, 318 eb' smasanil. Ix b'at eb' d'a spatic eb' chan̈van̈ rey chi' masanto b'aj ay chon̈ab' Dan ticnaic, ata' ix yamchaj eb' yuj eb'. ");
INSERT INTO cac_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Axo d'ac'valil ix spojanb'at masanil eb' svinac vin̈aj Abram chi', ix och eb' vin̈ yac' oval yed' chan̈van̈ eb' vin̈ rey chi'. Ix pechji eb' vin̈ yuj eb' vin̈, masanto d'a Hoba d'a yichan̈b'at chon̈ab' Damasco ix c'och eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ix yic'anxiec' vin̈aj Abram jantac tastac ix yiq'uec' eb' chi', ix ec'xican vin̈aj Lot yed' masanil tas ay d'ay yed' pax eb' ix ix yed' juntzan̈xo eb' ix ic'jib'at yuj eb' vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ayic toxo ix ac'ji ganar vin̈aj rey Quedorlaomer yed' eb' vin̈ rey ayoch yed'oc yuj vin̈aj Abram chi', ix meltzajxi vin̈ yed' eb' ix colchajcan chi' yuuj. Axo vin̈ sreyal Sodoma ix elta d'a yol b'e scha vin̈ d'a jun ch'olan scuch Save, Ch'olan yic eb' Rey sb'i paxi. ");
INSERT INTO cac_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","A vin̈aj Melquisedec, sreyal Salem, sacerdoteal Dios Axon̈ej Nivan Yelc'ochi, a vin̈ ix ac'an ixim pan yed' vino d'a vin̈aj Abram chi'. ");
INSERT INTO cac_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ix yalan vach' lolonel vin̈ d'a yib'an̈ vin̈ icha tic: Yac'ocab' svach'c'olal Dios d'a ib'an̈, aton Dios Axon̈ej Nivan Yelc'ochi, aton ix b'oan satchaan̈ yed' sat luum. ");
INSERT INTO cac_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Aljocab' vach' lolonel d'a Dios ix ac'anoch eb' ajc'ol d'a yol a c'ab', xchi vin̈ d'a vin̈aj Abram chi'. Ix lajvi chi', a jantac tastac ix yiq'uec' vin̈aj Abram d'a eb' vin̈ rey chi', ix yac'an sdiezmoal vin̈ d'a vin̈aj Melquisedec chi'. ");
INSERT INTO cac_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Axo ix yalan vin̈ sreyal Sodoma d'a vin̈aj Abram chi' icha tic: —An̈ej eb' anima tzac' meltzaj d'ayin, axo masanil tastac, canocab' d'ayach, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Axo ix yalan vin̈aj Abram chi' icha tic: —Toxo ix vac' in ti' d'a Jehová, aton Dios Axon̈ej Nivan Yelc'ochi, jun ix b'oan satchaan̈ yed' yolyib'an̈q'uinal tic, ");
INSERT INTO cac_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","to malaj jab'oc tas scan d'ayin, malaj val jab'oc ch'al ma junoc ch'an̈al xan̈ab' scan d'ayin, yic vach' man̈ ol ala' to uuj tzin och b'eyumal. ");
INSERT INTO cac_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Malaj jab'oc tas ix b'at viq'uec' tic tzin nib'ej scan d'ayin, an̈ej tas ix sva eb' in checab'. Axo eb' ajun ved' tic, aton vin̈aj Aner, vin̈aj Escol yed' vin̈aj Mamre, a eb' vin̈ tic, schaocab' yic eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ix lajvi juntzan̈ chi', ix lolon Jehová d'a vin̈aj Abram icha d'a vayichal, ix yalan icha tic: —Ach Abram man̈ ach xivoc, a in ol ach in colo', te nivan spac ol vac' d'ayach, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Ix tac'vi vin̈aj Abram icha tic: —Ach Jehová Vajalil, ¿tas val yopisio jun spac chi' vuuj? Ojtac val to malaj junoc vuninal ix ac'a' yic ata' svac'xican jantac tas ay d'ayin, yuj chi' a junoc in checab' ol chaancan masanil tas ay d'ayin, aton vin̈aj Eliezer aj Damasco, a vin̈ sat yaj d'a eb' in checab' smasanil, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ix yalanxi Jehová d'a vin̈: —Maay, a d'a junoc uninal ol canoc, man̈oclaj d'a vin̈ comon anima chi' ol canoc, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ix lajvi chi', ix ic'jielta vin̈ yuj Dios d'a sti' smantiado, ix yalan d'a vin̈ icha tic: —Q'uean̈ q'uelan d'a satchaan̈. B'isto juntzan̈ c'anal chi' naic, tato syal a b'isani. Ichaton chi' ol aj sb'isul eb' in̈tilal, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ix yac'och vin̈aj Abram chi' d'a sc'ool tas ix yal Jehová chi', yuj chi' vach' ix can vin̈ d'a yichan̈. ");
INSERT INTO cac_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ix yalanxi Jehová icha tic: —A in ton Jehová in ach viq'uelta d'a chon̈ab' Ur d'a yol yic Caldea yic svac' jun luum tic d'ayach yic tziquej, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","—Palta ach Jehová Vajalil, ¿tas val tz'aj vojtacaneli tato sviquejcan jun luum tic? xchi vin̈aj Abram chi'. ");
INSERT INTO cac_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ix yalanxi Jehová: —Ic'cot junoc noc' cob'es vacax d'ayin yed' junoc noc' chiva yed' junoc noc' ch'ac calnel, oxe' ab'il sq'uinal junjun noc'. Tzic'anpaxcot junoc noc' cuvajte' yed' junoc noc' paramuch, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ix yic'cancot juntzan̈ noc' noc' chi' vin̈ d'a yichan̈ Jehová chi', ix lajvi chi' ix schapojan snan̈al junjun noc' vin̈. Jilip noc' ix can d'a stz'ey jilipxo noc'. Axo noc' much chi', maj schapojejlaj snan̈al noc' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Tz'em noc' ostoc d'a yib'an̈ noc', axo vin̈aj Abram chi' spechan noc'. ");
INSERT INTO cac_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ayic vanxo sq'uic'b'i, ix te sat sc'ol vin̈aj Abram chi' svayi, ix ja jun nivan xivelal d'a yib'an̈ vin̈ yuj jun nivan q'uic'alq'uinal. ");
INSERT INTO cac_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ix lajvi chi' ix yalan Jehová d'a vin̈: —Yovalil tzojtaquejeli to a eb' in̈tilal, ol b'atcan cajan eb' d'a junocxo ch'oc chon̈ab'il, ol ochcan eb' checab'oc, chan̈e' ciento ab'il ol ixtaj eb'. ");
INSERT INTO cac_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Palta a in ol vac'och yaelal d'a yib'an̈ jun chon̈ab' b'aj ayoch eb' checab'oc chi'. Slajvi chi', ol elta eb' yed' jantac sb'eyumal. ");
INSERT INTO cac_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Palta a ach tic junc'olal ol aj a chami ayic ol ach och icham vinaquil. ");
INSERT INTO cac_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Chan̈ macan̈xo in̈tilal ix eq'ui, ichato chi' ol meltzajxicot eb' d'a tic, yujto manto tz'acvoc schucal eb' amorreo d'a tic, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ayic d'ac'valilxo, ix sch'oxan sb'a jun c'ac' culcon sq'uei, b'acaqui sq'ue stab'il. Tz'ec' d'a scal noc' noc' chapoj yaj chi'. ");
INSERT INTO cac_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Aton d'a jun ac'val chi' ix sb'o strato Jehová yed' vin̈aj Abram chi', ix yalan icha tic: —A jun luum tic ol vac' d'a eb' in̈tilal, schacot lum d'a jun smelemal a' d'a yic Egipto, masanto d'a a' Éufrates, ");
INSERT INTO cac_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","aton sluum eb' ceneo, eb' cenezeo, eb' cadmoneo, ");
INSERT INTO cac_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","eb' hitita, eb' ferezeo, eb' refaíta, ");
INSERT INTO cac_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","eb' amorreo, eb' cananeo, eb' gergeseo yed' eb' jebuseo, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","A ix Sarai, yetb'eyum vin̈aj Abram, max unevilaj ix, palta ay jun ix scriada ix manb'il yuuj, aton ix Agar, ix aj Egipto. ");
INSERT INTO cac_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ix yalan ix Sarai d'a vin̈ yetb'eyum chi' icha tic: —Ina malaj vune' syac' Jehová, yuj chi' tzin tevi d'ayach to tzach vay yed' ix in criada tic, talaj tz'alji junoc yune' ix yic tz'och vuneoc, xchi ix. Ix sc'anab'ajan vin̈aj Abram tas ix yal ix chi'. ");
INSERT INTO cac_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Slajun̈ilxo ab'il ayec' eb' d'a Canaán, ix yac'anoch ix scriada ix chi' d'a yol sc'ab' vin̈ yetb'eyum chi', yic tz'och ix schab'iloc yetb'eyum vin̈. ");
INSERT INTO cac_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ayic ix vay vin̈aj Abram yed' ix Agar chi', ix scuchcanoch yune' ix. Axo ix yab'an ix to yed'nacxo yune' ix, ix spaticanel ix Sarai chi' ix, man̈xalaj tz'och ix d'a ix. ");
INSERT INTO cac_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ix lajvi chi', ix yalan ix Sarai d'a vin̈aj Abram chi' icha tic: —Uujn̈ej emnaquil tzin yutejcan ix in criada tic. Tic pax ix vac' ix etb'eyumoc, axo ticnaic yujto ix yab' ix to yed'nacxo yune' ix, tzin spaticanel ix. Vach' tzon̈ sch'olb'itej Jehová, ¿tom a ach ay a mul, mato a in? xchi ix Sarai chi'. ");
INSERT INTO cac_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ix tac'vi vin̈aj Abram chi' icha tic: —A ix a criada tic, yol a c'ab' ayoch ix. A ach tza na' tas tzutej ix, xchi vin̈ d'a ix. Yuj chi' ix och ix Sarai ajc'olal d'a ix masanto ix elta ix. ");
INSERT INTO cac_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Palta axo Yángel Jehová ix schalaj sb'a yed' ix d'a tz'inan luum d'a slac'anil jun a a' b'aj sb'atcan sb'eal Sur d'a yol yic Egipto. ");
INSERT INTO cac_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ix sc'anb'an d'a ix icha tic: —Ach Agar, scriada ix Sarai, ¿b'ajtil a petoj? ¿b'ajtil tzach b'ati? xchi d'a ix. —To tzin el d'a ix Sarai, ix in patrona, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ix yalan Yángel Jehová chi' d'a ix icha tic: —Meltzajan̈ d'a ix a patrona chi', emnaquil tzutej a b'a d'a ix, xchi d'a ix. ");
INSERT INTO cac_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ix yalanpax Yángel Jehová chi': Ol vic'chaan̈ sb'isul in̈tilal, malaj mach ol yal sb'isani. ");
INSERT INTO cac_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ayxo unin ed'nac, yuj chi' ayic ol aljoc jun une' chi', Ismael ol ac' sb'iej, yujto ix yab' Jehová oc' yuj a cusc'olal. ");
INSERT INTO cac_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Icha noc' noc' te itz'at ol aj jun une' chi', icha junoc noc' caltacte'al b'uru. Ol yac' oval vin̈ yed' eb' anima, ol yac'anpax oval eb' anima yed' vin̈. Ol cajnaj vin̈ b'aj syac' sgana, vach'chom max schalaj sc'ol eb' ayto yuj sb'a chi' yed'oc, xchi jun ángel chi'. ");
INSERT INTO cac_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Yujto ix lolon ix Agar chi' yed' Jehová, yuj chi' icha tic ix yac' ix sb'ioc Jehová chi': A Dios Tzin ilani. Ix yalan ix icha tic: Toton val yel ix vil Dios tzin ilani, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","A a' uc'b'ila' yic Dios Pitzan, Jun Tzin Ilani, icha chi' ix yac' ix sb'ioc jun a' uc'b'ila' chi'. A d'a scal Cades yed' Bered, ata' ay a'. Ix lajvi chi' ix meltzajxi ix b'aj aytaxoneq'ui. ");
INSERT INTO cac_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ix alji jun yune' ix Agar yed' vin̈aj Abram chi'. Ismael ix yac' vin̈ sb'iej. ");
INSERT INTO cac_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","86 ab'ilxo sq'uinal vin̈aj Abram chi' ayic ix alji vin̈aj Ismael chi'. ");
INSERT INTO cac_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ayic 99 ab'il sq'uinal vin̈aj Abram ix sch'oxanxi sb'a Jehová d'a vin̈, ix yalan icha tic: —A in ton Dios in, syal vuj masanil, vach'n̈ej tzutej a b'a d'a vichan̈. ");
INSERT INTO cac_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ol vac' jun in trato ed'oc, tzijtum in̈tilal ol eloc, xchi. ");
INSERT INTO cac_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ix lajvi chi' ix em n̈ojan vin̈aj Abram chi' d'a sat luum yacb'an van slolon Dios yed' vin̈. Ix yalan icha tic: ");
INSERT INTO cac_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","—Aton jun in trato tic ol vac' ed'oc: Ol ach och smam yichamoc tzijtumal nación. ");
INSERT INTO cac_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Man̈xo ol a cuch Abram, palta Abraham xo ol a b'iej, yujto ol ach vac'och smam yichamoc tzijtumal nación. ");
INSERT INTO cac_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Tzijtum ol aj vic'anchaan̈ sb'isul in̈tilal, tzijtum nación ol pitzvoc yuj eb'. A d'a scal in̈tilal chi', ay eb' rey ol elta. ");
INSERT INTO cac_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","A jun in trato svac' ed'oc tic yed' masanil eb' in̈tilal chi' to a Diosal in, sDiosal in pax eb' in̈tilal chi' d'a juneln̈ej. ");
INSERT INTO cac_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","A ticnaic paxyalvum ach d'a lum Canaán tic, palta masanil luum tic ol vac' iquej yed' eb' in̈tilal d'a juneln̈ej, sDiosal in pax eb', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ix yalanxi Dios d'a vin̈: —A achxo tic, c'anab'ajej jun in trato tic, yovalil sc'anab'ajej pax eb' in̈tilal chi' ayic ol b'eyn̈ejb'at tiempo. ");
INSERT INTO cac_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","A jun in trato van in b'oan tic eyed'oc to yovalil tze c'anab'ajej. Masanil eb' vinac unin, ochocab' yechel snivanil eb'. ");
INSERT INTO cac_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Yuj chi' ic'jocab'el stz'umal sjolom svinaquil eb' e vinac unin. A jun chi' yechel in trato yaj eyed'oc. ");
INSERT INTO cac_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Yucub'ixial yaj junjun vinac unin tz'och jun yechel chi' d'a eb', vach'chom eyuninal ma yuninal eb' e checab'. Yovalil tz'ac'jipaxoch jun yechel chi' d'a eb' e checab', eb' manb'il d'a ch'oc chon̈ab'il. Yovalil tz'och jun yechel chi' d'ayex, max yal yec'b'ati. Icha chi' b'ian, a jun in trato tic eyed'oc nivan chequel ol aj d'a e nivanil d'a juneln̈ej. ");
INSERT INTO cac_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Yaln̈ej mach junoc vinac to malaj jun yechel chi' d'ay, yovalil tzeyiq'uel d'a e cal, yujto max sc'anab'ajej in trato ix vac' eyed'oc, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ix yalanxi Dios d'a vin̈aj Abraham chi' icha tic: —Ayic ol b'eyb'at tiempo tic, man̈xo Sarai-oc ol sb'iej ix etb'eyum, palta Sara ol sb'iej ix. ");
INSERT INTO cac_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ol vac' in vach'c'olal d'a yib'an̈ ix, ol aljoc junoc uninal yed' ix. Val yel ol vac' in vach'c'olal d'a yib'an̈ ix. Nunab'il ol aj ix d'a tzijtumal nación. Tzijtum eb' vin̈ sreyal chon̈ab' ol elta d'a scal yin̈tilal ix chi', xchi. ");
INSERT INTO cac_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ayic ix yab'an jun chi' vin̈aj Abraham chi', ix em n̈ojan vin̈ d'a sat luum, ix och ijan vin̈ stzevaji, ix och ijan vin̈ snaub'tan̈ani: ¿Tom olto aljoc vuninal? cien ab'ilxo in q'uinal, 90 ab'ilxo sq'uinal ix Sara, ¿tom olto val aljoc yune' ix? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ix lajvi chi' ix yalan vin̈ d'a Dios icha tic: —Tzin c'an d'ayach, tzoc el val d'a a c'ool tzac' sq'uinal vin̈aj Ismael tic yic vach' ol elc'och vin̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ix tac'vi Dios chi' d'a vin̈ icha tic: —Toxo ix val d'ayach to ol aljoc junoc uninal yed' ix Sara. Isaac ol ac' sb'iej, aton yed' vin̈ ol vaq'uelc'och jun in trato tic d'a masanil q'uinal yed' eb' yin̈tilal vin̈. ");
INSERT INTO cac_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","A pax vin̈aj Ismael jun, toxo ix vab' tas ix ala', ol vac' in vach'c'olal d'a yib'an̈ vin̈, yuj chi' tzijtum ol aj yin̈tilal vin̈. Ol q'uib'chaan̈ sb'isul yin̈tilal vin̈. A d'a scal yin̈tilal vin̈ chi', ol elta lajchavan̈ eb' nivac yajal. A yin̈tilal vin̈ chi', nivac nación ol ajoc. ");
INSERT INTO cac_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Palta a in trato ix vac' ed'oc, ol vaq'uelc'och yed' vin̈aj Isaac vin̈ uninal ol aljoc d'a ix Sara d'a junxo ab'il icha tiempo tic, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ayic ix lajvi slolon Dios yed' vin̈, ix paxq'uei. ");
INSERT INTO cac_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Aton d'a jun c'u chi' ix schec vin̈aj Abraham ac'jioch jun yechel chi' d'a vin̈aj Ismael yed' d'a masanil eb' vin̈ schecab' vin̈, eb' aljinac d'a yol scuenta vin̈ yed' masanil eb' vin̈ manb'il yuj vin̈ yed' masanil eb' cajan yed' vin̈. Ix ac'jioch yechel eb' smasanil, icha ix aj yalan Dios d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","A vin̈aj Abraham chi', 99 ab'il sq'uinal vin̈, axo vin̈aj Ismael 13 ab'il sq'uinal vin̈ ayic ix ac'jioch jun yechel chi' d'a eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","A d'a jun c'u chi' ix ac'jioch jun yechel chi' d'a eb' vin̈ schavan̈il ");
INSERT INTO cac_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","yed' d'a masanil eb' vin̈ ayec' yed' vin̈aj Abraham chi', eb' schecab' vin̈ aljinac d'a yol scuenta yed' eb' manb'il yuj vin̈ d'a juntzan̈xo ch'oc chon̈ab'il. ");
INSERT INTO cac_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ix lajvi chi' ix sch'oxanxi sb'a Jehová d'a vin̈aj Abraham d'a slac'anil juntzan̈ te' ji d'a yol yic vin̈aj Mamre. Chimc'ualil am val c'ojanelta vin̈ d'a sti' smantiado. ");
INSERT INTO cac_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Axo ix yilan vin̈, lin̈jab' ec' oxvan̈ vinac d'a yichan̈b'at vin̈. Ayic ix yilan eb' chi' vin̈, ix b'at lemnaj vin̈ schacot eb', ix emc'och n̈ojnaj vin̈ d'a sat lum d'a yichan̈ eb'. ");
INSERT INTO cac_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ix yalan vin̈ icha tic: —Ach mamin, tato vach' in tzila', tzin tevi d'ayach to man̈ b'en̈ejoc tzex eq'ui. ");
INSERT INTO cac_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Tan̈vejec, b'at vala' yic tz'ic'chajcot jab'oc a a' yic tze b'iquel eyoc, tzeyic'an eyip d'a yich te te' tic. ");
INSERT INTO cac_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Yacb'an ayex ec' d'a in tz'ey tic, tzin b'at vic'cot jab'oc tas ol e va, yic vach' tz'och eyip, ichato chi' ol ex b'atxoc, xchi vin̈ d'a eb'. —Ixic an, xchi eb' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ix ochb'at lemnaj vin̈ d'a yol smantiado. Ix yalan vin̈ d'a ix Sara icha tic: —Lem, ic'cot junoc coxtal ixim harina te vach', tza b'oan jantacoc pan staji d'a cal tzac'ac', xchi vin̈ d'a ix. ");
INSERT INTO cac_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ix b'at lemnaj vin̈ b'aj ay noc' svacax, ix b'at yic'ancot jun noc' quelem vacax vin̈ te vach', ix yac'an noc' vin̈ d'a jun vin̈ schecab' yic sb'o noc' vin̈ d'a elan̈chamel yic schichaj noc'. ");
INSERT INTO cac_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ix yic'ancot mantequilla vin̈ yed' lech yed' noc' chib'ej ix b'ochaj chi', ix yic'anb'at vin̈ d'a yichan̈ eb' yic sva eb'. Yacb'an van sva eb' chi', ix och tec'tec' vin̈ d'a stz'ey eb' d'a yich te te' chi'. ");
INSERT INTO cac_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ix sc'anb'an eb' d'a vin̈ icha tic: —¿B'ajtil ayec' ix Sara ix etb'eyum? xchi eb'. —Ayoch ix d'a yol co mantiado tic, xchi vin̈ d'a eb'. ");
INSERT INTO cac_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ix yalan junoc eb' icha tic: —Yab' icha tic junab', svac'anxi a paxyal, ata' ol aljoc junoc yune' ix etb'eyum tic, vinac unin, xchi d'a vin̈. Yacb'an a ix Sara chi' van smaclan yab' ix tas syala', ayec' ix d'a sti' smantiado eb' d'a spatic vin̈aj Abraham chi'. ");
INSERT INTO cac_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","A vin̈aj Abraham yed' ix Sara chi' te ichamtac animaxo eb'. A ix Sara chi' pecatax man̈xalaj yechel unin syil ix, ");
INSERT INTO cac_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","yuj chi' ton̈ej ix tzevaj ix d'a yol sc'ool. Ayic ix yab'an ix yalji jun chi', ix snaan ix icha tic: ¿Tasto val ol aj in nib'anoch jun tic, ina te chichim inxo, te ichamxo pax vin̈ vetb'eyum? xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yuj chi' ix yalan Jehová d'a vin̈ icha tic: —¿Tas yuj ton̈ej stzevaj ix etb'eyum chi'? ¿Tzam sna' ix yujto chichimxo ix maxtzac yal yalji junoc yune' ix? ");
INSERT INTO cac_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Tom ay tas ajaltac d'ayin tze na'a? Yab' icha tic junab', tzin jax junelxo, svac'anxi a paxyal. Ata' ol aljoc jun yune' ix Sara chi', vinac unin, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ayic ix yab'an jun chi' ix Sara chi', ix te xiv ix, ix yalan ix icha tic: —Malaj in tzin tzevaji, xchi ix. Axo ix tac'vi Jehová d'a ix icha tic: —Vojtac to ix ach tzevaji, xchi. ");
INSERT INTO cac_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ix lajvi chi' ix b'at eb' oxvan̈ chi' d'a sb'eal Sodoma. Ix b'at vin̈aj Abraham yed' eb' yic stac'lancan sb'a eb' yed' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ix yalan Jehová icha tic: Max yal-laj in c'ub'anel d'a vin̈aj Abraham tic tas toxo ol in c'ulej. ");
INSERT INTO cac_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ina to a vin̈ ol och smam yichamoc jun nivan nación te tec'an ol ajoc. Toxo ix vac' in ti' to yuj vin̈ ol scha' in vach'c'olal masanil nación d'a yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","A in ix in siq'uelta vin̈, yic vach' syalel in checnab'il vin̈ d'a masanil yuninal yed' eb' cajan yed'oc, yic vach' sc'anab'ajej eb' sb'eyb'alan masanil tas vach' yed' tojolal, yic vach' svaq'uelc'och jantac in lolonel ix val d'a vin̈, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Yuj chi' ix yalan d'a vin̈aj Abraham chi' icha tic: —Masanil anima ay d'a Sodoma yed' d'a Gomorra, yalxon̈ej b'aj te chuc yel specal eb', axon̈ej val chucal sc'ulej eb'. ");
INSERT INTO cac_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","A ticnaic, tic tzin b'at vila', tato yel axon̈ej chucal chi' sc'ulej eb' icha tz'aj yalchaj chi' d'ayin yic ol vojtaquejeli tas yaji, xchi Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ay chavan̈ eb' b'en̈ej ix b'atcan d'a Sodoma, axo vin̈aj Abraham chi' ix loloncan vin̈ yed' Jehová. ");
INSERT INTO cac_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ix snitzanb'at jab'xo sb'a vin̈ d'a stz'ey Jehová chi', ix sc'anb'an vin̈ icha tic: ¿Tom ol a satel eb' anima malaj smul yed' eb' ay smul? ");
INSERT INTO cac_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Q'uinaloc ay 50-oc eb' vach' d'a jun chon̈ab' chi', ¿tom ol a satel eb'? ¿tom man̈ ol ac' nivanc'olal yuj eb' 50 malaj smul chi'? ");
INSERT INTO cac_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Man̈ ol yal utan icha chi'. Tato tza satel eb' malaj smul yed' eb' ay smul chi', ichato lajan smul eb' smasanil syal chi'. Man̈ utej icha chi'. A ach tic Juez ach d'a yolyib'an̈q'uinal tic, ¿tocval ol a c'ulej junoc tas man̈ tojoloc? xchi vin̈ d'ay. ");
INSERT INTO cac_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ix tac'vi Jehová d'a vin̈ icha tic: —Tato ay 50-oc eb' vach' d'a chon̈ab' Sodoma chi', yuj eb' svac' nivanc'olal masanil eb' cajan d'a jun chon̈ab' chi', xchi. ");
INSERT INTO cac_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ix yalanxi vin̈aj Abraham chi' icha tic: —Ac' nivanc'olal d'ayin ach Vajalil yuj tas sval tic d'ayach, yujto a in tic, anima inn̈ej. ");
INSERT INTO cac_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Q'uinaloc ayxon̈ej ovan̈oc max tz'acvi 50 anima vach', ¿tom yujxon̈ej ovan̈ chi', tza satel jun chon̈ab' chi' smasanil? xchi vin̈. Ix tac'vixi Jehová icha tic: —Tato ay 45-oc eb' vach', max in satel-laj jun chon̈ab' chi', xchi. ");
INSERT INTO cac_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ix yalanxi vin̈aj Abraham chi' icha tic: —Q'uinaloc an̈ej 40-oc eb' vach', xchi vin̈. —Yuj eb' 40 chi', man̈ ol in satel-laj jun chon̈ab' chi', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ix yalanxi vin̈aj Abraham chi' icha tic: —Ach Vajalil tzin tevi d'ayach, mocab' cot oval svalan d'ayach. Q'uinaloc an̈ej 30-oc eb' vach' tz'ilchaj uuj, xchi vin̈. Ix tac'vixi Jehová chi' icha tic: —A yuj eb' 30 chi', ol vac' nivanc'olal jun chon̈ab' chi', xchi. ");
INSERT INTO cac_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Axo vin̈aj Abraham chi' ix ochn̈ej ijan vin̈ yalani: —Mamin Vajalil, tzin tevi val d'ayach, ¿tas tzutej ta axon̈ej 20-oc eb' vach'? xchi vin̈. Ix tac'vixi Jehová chi' icha tic: —A yuj eb' 20 chi', man̈ ol in satel-laj jun chon̈ab' chi', xchi. ");
INSERT INTO cac_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ix yalanxi vin̈aj Abraham chi': —Ac'val nivanc'olal d'ayin ach Vajalil, mocab' cot oval d'ayin, axon̈ej junel tic tzin tevi d'ayach, man̈xa tas ol vala': ¿Tas tzutej, q'uinaloc tato axon̈ej lajun̈van̈oc eb' vach' sb'eyb'al tz'ilchaj uuj? xchi vin̈. Ix yalanxi Jehová chi' icha tic: —Q'uinaloc ay lajun̈van̈oc eb' vach' sb'eyb'al, man̈ ol in satel-laj jun chon̈ab' chi', xchi. ");
INSERT INTO cac_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Axo ix lajvi slolon eb' chi', ix b'at Jehová, ix smeltzajcan vin̈aj Abraham chi' d'a smantiado. ");
INSERT INTO cac_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ayic vanxo sq'uic'b'i ix c'och chavan̈ eb' ángel chi' d'a chon̈ab' Sodoma. A vin̈aj Lot c'ojanec' vin̈ d'a spuertail chon̈ab' chi'. Ix yilan vin̈ to van sja eb', ix q'ue vaan vin̈ b'at schacot eb'. Ix em n̈ojnaj vin̈ d'a yichan̈ eb'. ");
INSERT INTO cac_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ix yalan vin̈: —Ex mamin, tzin tevi d'ayex, coyec ved' d'a in pat. Ay a a' b'aj ol e b'iquel eyoc, ay pax b'aj vach' ol ex can d'a jun ac'val tic, axo q'uic'an spet ex b'ati, xchi vin̈ d'a eb'. Ix tac'vi eb' icha tic: —Yuj val dios d'ayach, palta a on̈ tic ol on̈ can d'a calle tic, a tic ol on̈ vayoc, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Palta ix och val tean vin̈aj Lot chi' d'a eb', masanto ix b'at eb' d'a spat vin̈ chi'. Axo ix c'och eb', ix sb'oan ixim pan vin̈ malaj yich sva eb', ix va eb' sic'lab'il. ");
INSERT INTO cac_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ayic mantzac vay eb', ix c'och masanil eb' vin̈ vinac cajan chi' ta', ix oymaj eb' vin̈ d'a spatictac spat vin̈aj Lot chi'. ");
INSERT INTO cac_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ix och ijan eb' vin̈ yavajoch d'a vin̈aj Lot chi', ix yalan eb' vin̈ icha tic: —¿B'ajtil ayec' juntzan̈ eb' vin̈ vinac ix jacan d'a a pat tic d'a jun ac'val tic? Iq'uelta eb' vin̈ d'ayon̈ yic squixtej eb', xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ayic ix yab'an juntzan̈ lolonel vin̈aj Lot chi', ix elta vin̈ yil eb' vin̈. Vach' ix yutej vin̈ smacancanelta te' puerta chi' d'a spatic. ");
INSERT INTO cac_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ix yalan vin̈: —Ex vetanimail, tzin tevi d'ayex to man̈ e c'ulej jun chucal chi'. ");
INSERT INTO cac_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ay chavan̈ eb' ix visil cob'estac, mantalaj vinac tz'ec' d'a spatic eb' ix, syal vic'anelta eb' ix d'ayex yic tze c'ulej icha e gana chi' yed' eb' ix. Palta a yed' eb' vin̈ tic, max yal-laj, yujto ton̈ej ix jacan eb' vin̈ d'a in pat tic, xchi vin̈ d'a eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ix yalan eb' vin̈: —Man̈ ac'och a b'a, elan̈ d'a quichan̈. A ach tic ch'oc chon̈ab'il ach, ¿tom a ach ijan tzala'? A ticnaic ec'b'al ol ach quixtej d'a yichan̈ eb' vin̈, xchi eb' vin̈. Ix och ijan eb' vin̈ yecanel vin̈aj Lot chi' yic sc'och eb' vin̈ d'a te' puerta chi', yic smac'anpoj te' eb' snaani. ");
INSERT INTO cac_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Palta a chavan̈ eb' ángel chi', ix yaq'uelta sc'ab' eb' yic tz'ic'jioch vin̈aj Lot chi' yuj eb' d'a yol pat chi', ix smacanelta te' puerta chi' eb'. ");
INSERT INTO cac_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ix yac'an q'uic'yatax eb' anima ayec' d'a patic pat chi' eb', eb' icham vinac yed' eb' quelemtac, ix te c'unb'i eb' sayanec' sti' te' pat chi'. ");
INSERT INTO cac_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ix lajvi chi', ix yalan eb' chavan̈ chi' d'a vin̈aj Lot: —Tato ayto eb' ay uj a b'a yed'oc d'a tic, eb' vin̈ uninal, eb' ix isil, eb' a n̈i', ma eb' a c'ab'oc, iq'uel eb' d'a tic. ");
INSERT INTO cac_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Yujto ol co satel jun chon̈ab' tic. Yujto ix te' q'uec'och schucal eb' d'a yichan̈ Jehová, yuj chi' on̈ scheccoti yic tzul co satel juntzan̈ anima tic, xchi eb' ángel chi'. ");
INSERT INTO cac_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Yuj chi', ix b'at vin̈aj Lot chi' yal d'a eb' vin̈ d'in̈an yic'lan sb'a yed' eb' ix yisil chi', ix yalan vin̈: —Pilec eyip, con̈ elec, yujto a jun chon̈ab' tic ol satel yuj Jehová, xchi vin̈ d'a eb'. Palta maj schalaj yab' eb' tas ix yal vin̈aj Lot chi'. Ton̈ej spuchan vin̈ snaan eb'. ");
INSERT INTO cac_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Palta axo yic vanxo sacb'i, ix yalan eb' ángel chi' d'a vin̈aj Lot chi': —Pil ip tato max yal a c'ol tzach satel yed' jun chon̈ab' tic. Ic'b'at ix etb'eyum tic yed' eb' ix isil tic schavan̈il, xchi eb' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Palta a vin̈aj Lot chi', max spil-laj yip vin̈ yeli. Yuj chi' a eb' ángel chi' ix quetzan sc'ab' eb' schan̈van̈il, yic tz'ic'jiel eb', yujto tz'oc' sc'ol Jehová d'a eb'. Icha chi' ix aj yic'jiel vin̈aj Lot yed' ix yetb'eyum yed' eb' ix yisil d'a yol chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ayic toxo ix el eb' d'a stiel chon̈ab' chi', ix yalan junoc eb' ángel chi' d'a eb': —Yelc'olal tzex b'ati, man̈ ex meltzajcot q'uelan d'a e patic. Man̈ ex och vaan e b'ey d'a jun ac'lic tic, q'uean̈ec d'a jolomtac vitz, tato max yal e c'ol tzex sateli, xchi d'a eb'. ");
INSERT INTO cac_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ix tac'vi vin̈aj Lot chi': —Maay mamin, yuj val dios d'ayex. ");
INSERT INTO cac_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Te nivanxo e vach'c'olal ix e ch'ox d'ayin, ina ix in eyiq'uelta yic max in chami. Palta max yal-laj in b'atcan d'a jolomtac vitz chi', tecan tzin yamchajc'och yuj jun yaelal chi', tzin chami. ");
INSERT INTO cac_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","A d'a slac'anil tic ay jun yune' chon̈ab', tzam yal in b'atcan d'ay. ¿Tom max yala' tzin e chab'at ta' yic tzin col in b'a? Val yel yunen̈ej jun chon̈ab' chi', xchi vin̈aj Lot chi'. ");
INSERT INTO cac_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ix yalan jun ángel chi': —Toxo ix vab'i, yic'ocab' icha tzal chi'. Man̈ ol in satel jun chon̈ab' ix al chi'. ");
INSERT INTO cac_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Elan̈chamel e b'ati, yujto malaj tas syal in b'oani ta maxto ex c'och ta', xchi jun ángel chi'. Yuj chi' Zoar ix sb'iejcan jun chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ayic van sjavi c'u ix c'och vin̈aj Lot chi' d'a jun chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ix lajvi chi' ix yac'ancot c'ac' Jehová yed' azufre d'a satchaan̈ d'a yib'an̈ chon̈ab' Sodoma yed' Gomorra chi'. ");
INSERT INTO cac_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ix satel juntzan̈ chon̈ab' chi' yed' masanil eb' cajan d'ay yed' masanil jun nivan ac'lic chi' yed' tas sq'uib' d'ay. ");
INSERT INTO cac_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","A ix yetb'eyum vin̈aj Lot chi', najat tzac'anto scot ix, ix meltzajxicanb'at q'uelan ix d'a spatic. Ata' ix ochcan ix atz'amil. ");
INSERT INTO cac_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Axo d'a yevial slolon vin̈aj Abraham yed' Jehová, d'a q'uin̈ib'alil, ix b'at vin̈ b'aj lolon eb' chi'. ");
INSERT INTO cac_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Axo ix yilan vin̈ to a Sodoma yed' Gomorra yed' masanil jun ac'lic chi', b'acaquixon̈ej sq'ue stab'il icha sq'ue stab'il junoc nivan horno. ");
INSERT INTO cac_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ayic ix satjiel juntzan̈ chon̈ab' chi' yuj Dios d'a jun nivan ac'lic b'aj ix ec' cajan vin̈aj Lot chi', ix snaancot Dios tas ix sc'an vin̈aj Abraham, yuj chi' ix colchaj vin̈aj Lot chi' d'a scal jun nivan yaelal chi'. ");
INSERT INTO cac_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ix lajvi chi', ix xiv vin̈aj Lot scajnaj d'a chon̈ab' Zoar chi', yuj chi' ix q'uecan vin̈ d'a jolomtac vitz yed' eb' ix yisil schavan̈il, ix cajnaj eb' d'a yol jun q'uen n̈aq'ueen. ");
INSERT INTO cac_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ay jun c'ual ix yal ix b'ab'el ix d'a ix snulej: —A vin̈ co mam tic, te ichamxo vin̈, malaj junoc vinac d'a jun lugar tic syal quic'lan co b'a yed'oc icha sb'eyb'al eb' anima. ");
INSERT INTO cac_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Yuj chi' cac' yuc' an̈ vin̈ co mam tic, yic ol on̈ vay yed' vin̈, yic vach' ol can yin̈tilal vin̈ qued'oc, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","A d'a jun ac'val chi', ix yac' an̈ eb' ix yuc' vin̈, ix q'ue an̈ d'a sjolom vin̈. Yuj chi' a ix b'ab'el ix, ix vay yed' vin̈. Maj yab' vin̈ janic' ix vay ix yed'oc, maj yab'pax vin̈ janic' ix q'uexvan ix d'a stz'ey. ");
INSERT INTO cac_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Axo d'a junxo c'u ix yalan ix b'ab'el chi' d'a ix snulej chi': —A q'uiq'ui d'ac'val ix in vay yed' vin̈ co mam tic, axo ticnaic cac'xi an̈ yuc' vin̈ yic vach' tzach vay yed' vin̈ yic ol can yin̈tilal vin̈ qued' co chavan̈il, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Yuj chi' d'a jun ac'val chi', ix yac'anxi an̈ eb' ix yuc' vin̈ smam chi', axo ix schab'il chi' ix vay yed' vin̈. Palta a vin̈aj Lot chi', maj yab' vin̈ janic' ix vay ix yed'oc, maj yab'pax vin̈ janic' ix q'uexvan ix. ");
INSERT INTO cac_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Icha chi' ix aj yochcan eb' ix yisil vin̈ chi' schavan̈il yab'ixal yuuj. ");
INSERT INTO cac_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","A ix b'ab'el, ix alji yune' ix, Moab ix yac' ix sb'iej, aton vin̈ aycan yin̈tilal eb' moabita ticnaic. ");
INSERT INTO cac_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ix aljipax yune' ix schab'il chi', Ben-ammi, ix yac' ix sb'iej, aton vin̈ aycan yin̈tilal eb' amonita ticnaic. ");
INSERT INTO cac_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ix el vin̈aj Abraham chi' d'a yol yic vin̈aj Mamre, ix b'atcan cajan vin̈ d'a yol yic Neguev d'a jun chon̈ab' scuch Gerar. A d'a scal Cades yed' Shur, ata' ay Gerar chi'. ");
INSERT INTO cac_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ayic ayec' vin̈ ta', ix yal vin̈ to man̈ yetb'eyumoc ix Sara vin̈, yanab' ix vin̈ yalani. A vin̈aj Abimelec sreyal Gerar chi', ix schec vin̈ ic'chajcot ix Sara chi' yic tz'och ix yetb'eyumoc yalani. ");
INSERT INTO cac_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ay jun ac'val, ix lolon Dios d'a vin̈ rey chi' d'a svayich icha tic: Ol ach chamoc, yujto a ix ix, ix ic'cot etb'eyumoc alani, ay yetb'eyum ix, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Palta manto vaylaj vin̈ yed' ix Sara chi', yuj chi' ix yalan vin̈: Mamin, malaj in mul, ¿tom tzin a satel yed' in chon̈ab' tic? ");
INSERT INTO cac_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Yujto a vin̈aj Abraham chi' ix alan d'ayin to yanab' ix vin̈. Ix yalanpax ix d'ayin: In nulej vin̈, xchi ix. A in tic ix in c'ulej d'a smasanil in c'ool, man̈oc chucal naan vuuj, xchi vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ix tac'vi Dios d'a vin̈: Vojtac to ix a c'ulej jun tic d'a stojolal, yuj chi' maj in cha a yam ix, yic vach' max och a mul d'ayin. ");
INSERT INTO cac_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","A ticnaic, ac' meltzaj ix d'a vin̈ yetb'eyum chi', yujto in checab' yaj vin̈. Syal slesalvi vin̈ uuj yic max ach chami. Palta tato max ac' meltzaj ix jun, val yel ol ach chamoc, ol champax jantac eb' cajan ed'oc, xchi Dios d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Axo ix q'uin̈ib'i, ix q'ue vaan vin̈ rey chi', ix yavtancot masanil eb' schecab' vin̈, ix yalan vin̈ d'a eb' tas ix svayichej chi'. Ayic ix yab'an jun chi' eb', ix te xiv eb'. ");
INSERT INTO cac_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ix lajvi chi' ix schecan vin̈ rey chi' avtaj vin̈aj Abraham chi', ix yalan vin̈: —¿Tas yuj icha tic ix in utej? ¿Tas in mul d'ayach, yuj chi' ijan tzic'cot jun nivan mul tic d'a vib'an̈ yed' d'a yib'an̈ jantac eb' in chon̈ab' tic? Man̈ vach'oc ix in utej. ");
INSERT INTO cac_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿Tas ix a na' yuj chi' icha tic ix a c'ulej? xchi vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ix tac'vi vin̈aj Abraham chi' d'a vin̈: —A in naani to a d'a jun lugar tic malaj mach xiv d'a Dios. Q'uinaloc ay mach tzin mac'ancham yuj ix vetb'eyum tic in naani. ");
INSERT INTO cac_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Val yel vanab' ix, yisil ix vin̈ in mam, palta ch'oc snun ix, yuj chi' ix yal vic'lan in b'a yed' ix. ");
INSERT INTO cac_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ayic ix yalan Dios to tzin el d'a spat vin̈ in mam, ix in c'anan pavor d'a ix to sch'ox svach'c'olal ix d'ayin, yuj chi' yaln̈ej b'aj tzon̈ eq'ui, syal ix to vanab' ix, xchi vin̈aj Abraham chi'. ");
INSERT INTO cac_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ix yac'anxi meltzaj ix Sara chi' vin̈ d'a vin̈aj Abraham chi'. Ix ac'jipax noc' calnel, noc' vacax, eb' vin̈ checab' yed' eb' ix checab' d'a vin̈ yuj vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ix yalanxi vin̈ rey chi' d'a vin̈: —Ina in macb'en tic, syal a sic'lani b'ajtil syal a cajnaji, xchi vin̈ rey chi' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ix yalanpax vin̈ rey chi' d'a ix Sara: —Ix vac' mil siclo q'uen plata d'a vin̈ a nulej tic, yic tz'och spacoc d'ayach, yic sco ch'oxaneli to malaj a mul ix ochi, yic vach' malaj mach syal yalan chucal d'a a patic, xchi vin̈ d'a ix. ");
INSERT INTO cac_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ix lajvi chi' ix lesalvi vin̈aj Abraham chi' d'a Dios yuj vin̈aj Abimelec chi'. Yuj chi' ix yic'xiel scatab' Dios chi' d'a yib'an̈ vin̈ yed' ix yetb'eyum yed' eb' ix schecab' vin̈, yic tz'aljixi yune' eb' ix. ");
INSERT INTO cac_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Yujto yujn̈ej ix Sara chi', man̈xa junoc eb' ix ayec' d'a spat vin̈aj Abimelec chi' ixto unevi junoc tiempoal yuj Jehová. ");
INSERT INTO cac_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Icha ix aj yalan Jehová Dios d'a ix Sara to ol aljoc junoc yune' ix, icha chi' ix aj yelc'ochi. ");
INSERT INTO cac_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ix scuchoch yune' ix, ix alji ayic te icham vinacxo vin̈aj Abraham chi'. Ix alji jun svinac unin ix, icha val stiempoal alb'ilcan yuj Dios. ");
INSERT INTO cac_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Isaac ix sb'iej yuj vin̈aj Abraham chi'. ");
INSERT INTO cac_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Yucub'ixial yalji vin̈ unin chi', ix ac'jioch yechel strato Dios d'a snivanil vin̈ yuj vin̈aj Abraham chi' icha yaj yalan Dios d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Cien ab'ilxo sq'uinal vin̈aj Abraham chi' ayic ix alji vin̈aj Isaac. ");
INSERT INTO cac_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ix yalan ix Sara icha tic: Ix in yac' tzevaj co Mam Dios. Masanil eb' tz'ab'ani to ay vune', ol tzevajpax eb' ved'oc. ");
INSERT INTO cac_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","¿Toc ay eb' anima ix alan d'a vin̈aj Abraham, tato olto vac' chunoc unin? Palta ixto alji vune' yed' vin̈ vach'chom icham vinacxo vin̈, xchi ix Sara chi'. ");
INSERT INTO cac_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ix q'uib' vin̈aj Isaac, ix el vin̈ d'a yim, yuj chi' ix yac'och jun nivan q'uin̈ vin̈aj Abraham chi'. ");
INSERT INTO cac_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Axo ix yilan ix Sara to a jun yuninal vin̈aj Abraham yed' ix Agar, ix aj Egipto, sb'uchvaj d'a vin̈aj Isaac chi'. ");
INSERT INTO cac_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Yuj chi' ix ac'ji sc'ol vin̈aj Abraham yuj ix Sara chi', ix yalan ix: Pechb'at ix criada tic yed' vin̈ yune' tic, yujto malaj in gana ol yic' yic vin̈ d'a tastac ol ac'can d'a vin̈ vune' aj Isaac tic, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","A jun lolonel tic te ya ix och d'a vin̈aj Abraham chi', yujto yuninal pax vin̈aj Ismael chi' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Axo Dios ix alan d'a vin̈: Man̈ ach cus yuj vin̈ unin tic yed' pax ix a criada tic. C'anab'ajejn̈ej tas syal ix Sara chi', yujto a d'a vin̈aj Isaac tic ol b'eyn̈ejb'at jantac in̈tilal, icha ix aj valan d'ayach. ");
INSERT INTO cac_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","A pax vin̈ yune' ix criada chi' jun, a in ol in b'o jun nivan nación d'a yin̈tilal vin̈ yujto uninal pax vin̈, xchi Dios. ");
INSERT INTO cac_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Axo d'a junxo c'u te ac'valto, ix yic'ancot vael vin̈aj Abraham chi' yed' jun noc' tz'uum yed'tal a' b'ud'an, ix yac'an vin̈ scuch ix Agar chi', ix ac'jipax vin̈ yune' ix d'a yol sc'ab', ix tac'ajb'at eb' yuj vin̈. Ix b'at ix, ix satb'eyec' ix d'a jun tz'inan luum d'a yol yic Beerseba. ");
INSERT INTO cac_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ayic ix lajvi a a' d'a yol noc' tz'um chi', ix yactancan vin̈ yune' ix chi' d'a yich jun te' yune' te'. ");
INSERT INTO cac_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Najattac ix b'at ix, ix em c'ojan ix, yic vach' max yil ix scham vin̈ yune' chi' snaani. Ayic ix em c'ojan ix chi', ix q'ue sjaj vin̈ yoq'ui. ");
INSERT INTO cac_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ix yab'an Dios yoc' vin̈, ato d'a satchaan̈ ix lolonemta yángel Dios d'a ix Agar chi', ix yalani: Ach Agar, ¿tas tzach ic'ani? Man̈ ach xivoc, a Dios toxo ix ab'an yel yav vin̈ une' chi' yoc' b'aj ix actejcan chi'. ");
INSERT INTO cac_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ixic b'at il vin̈, tzic'anq'ue van vin̈, tza montan vin̈, yujto a yed' yin̈tilal vin̈ ol in b'o jun nivan nación, xchi. ");
INSERT INTO cac_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Axo Dios ix ac'an yil jun sjaj a a' ix Agar chi', ix b'at ix, ix yac'an b'ud'joc noc' tz'uum chi' ix d'a a', ix yac'an a' ix yuc' vin̈ yune' chi'. ");
INSERT INTO cac_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","A Dios ix och yed' vin̈aj Ismael chi', ix q'uib' vin̈. Ix cann̈ej vin̈ d'a jun tz'inan lum d'a yol yic Parán. Te julum noc' ix aj vin̈. Axo ix snun vin̈ ix sayan jun ix aj Egipto yic'a'. ");
INSERT INTO cac_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","A d'a jun tiempoal chi', ix javi vin̈aj Abimelec d'a vin̈aj Abraham, ajun vin̈aj Ficol yajal yaj d'a eb' soldado yed' vin̈. Ix yalan vin̈aj Abimelec d'a vin̈aj Abraham chi' icha tic: —Ix quila' to a Dios ayn̈ejoch ed'oc d'a masanil tas tza c'ulej. ");
INSERT INTO cac_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Yuj chi' ac' a ti' d'ayin d'a yichan̈ Dios d'a jun lugar tic, to man̈ ol ac' chucal d'ayin, d'a eb' vuninal yed' pax d'a eb' vin̈tilal. Tzac'an a ti' to vach'n̈ej ol utej a b'a d'ayin, icha ix vutej in b'a d'ayach. Icha pax chi' ol utej a b'a d'a eb' anima cajan d'a jun chon̈ab' b'aj janac ach cajan tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ix tac'vi vin̈aj Abraham chi': —Svac' in ti'. ");
INSERT INTO cac_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Palta ay jun a' uc'b'ila' in chec joychajnac ix yiq'uec' eb' vin̈ a checab', xchi vin̈ d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ix tac'vixi vin̈aj Abimelec chi': —Val yel man̈ vojtacoc tas yaj jun chi', malaj tas tzal d'ayin, ato ticnaic svab'i. Mach am ix c'ulan jun chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Yuj chi' ix yic'ancot noc' calnel vin̈aj Abraham chi' yed' noc' vacax, ix yac'an noc' vin̈ d'a vin̈aj Abimelec chi'. A d'a jun c'u chi' ix sb'ocan jun strato eb' chi' schavan̈il. ");
INSERT INTO cac_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","A vin̈aj Abraham chi' ix yiq'uelta ucvan̈ noc' cob'estac calnel vin̈ d'a scal noc' scalnel. ");
INSERT INTO cac_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Yuj chi' ix sc'anb'an vin̈aj Abimelec chi': —¿Tas yuj tziq'uelta noc' calnel chi'? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ix yalan vin̈aj Abraham chi' icha tic: —Cha noc' d'ayin, a noc' sch'oxani to a in in joynac jun a' uc'b'ila' tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Yuj chi' Beerseba ix sb'iejcan jun lugar chi', yujto ata' ix yac'can sti' eb' d'ay junjun. ");
INSERT INTO cac_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Icha chi' ix aj sb'oancan jun strato eb' d'a Beerseba chi'. Ix lajvi chi' ix meltzaj vin̈aj Abimelec yed' vin̈aj Ficol d'a schon̈ab', aton schon̈ab' eb' filisteo. ");
INSERT INTO cac_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","A d'a Beerseba chi', ix yavej jun te te' vin̈aj Abraham scuch tamarisco. A d'a Beerseba chi' ix yal sb'a vin̈ d'a Jehová, aton Dios ayn̈ejec' d'a juneln̈ej. ");
INSERT INTO cac_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Najtil ec'nac vin̈ d'a smacb'en eb' filisteo chi'. ");
INSERT INTO cac_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ix lajvi yec' jun tiempoal, ix ac'ji proval vin̈aj Abraham yuj Dios, ix avtaj vin̈, ix tac'vi vin̈ icha tic: —Ina vajec' tic Mamin, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ix yalan Dios d'a vin̈ icha tic: —Ic'b'at vin̈aj Isaac jun pitan̈ uninal te xajan uuj, tzach b'at d'a lum Moriah. Ayic tzach c'och d'a sjolom lum tzalan ol in ch'ox d'ayach, ata' ol a n̈ustz'a vin̈ silab'il d'ayin, xchi Dios. ");
INSERT INTO cac_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Axo d'a junxo c'u, te ac'valto ix q'ue vaan vin̈aj Abraham chi'. Ix yac'anoch stz'um noc' sb'uru vin̈, ix xican te' sc'atzitzal jun silab' chi' vin̈. Ix yic'anb'at vin̈aj Isaac yuninal yed' chavan̈ eb' schecab', ix b'at vin̈ yed' eb' d'a jun lugar ix yal Dios chi'. ");
INSERT INTO cac_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Axo d'a schab'jial, najatto ix yilb'at lum tzalan chi' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ix yalan vin̈ d'a eb' schecab' chi': —Canan̈ec d'a tic yed' noc' b'uru tic, a inxo yed' vin̈ vuninal tic, ol on̈ b'at d'a chi', yic scaq'uem co b'a d'a co Mam Dios. Slajvi chi', ol on̈ jax d'ayex, xchi vin̈ d'a eb'. ");
INSERT INTO cac_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ix lajvi chi' ix yac'an te' c'atzitz chi' vin̈ scuch vin̈aj Isaac chi', ix yic'anb'at scuchilub' vin̈ yed' sc'ac', ix b'at eb' schavan̈il. ");
INSERT INTO cac_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Quenanto val sb'at eb', ix yalan vin̈aj Isaac chi' d'a vin̈ smam chi' icha tic: —Mamin, xchi vin̈. —¿Tas xchi vuninal? xchi vin̈aj Abraham chi'. —Ina qued'nac co c'atzitz yed' co c'ac', ¿b'aj ay pax noc' calnel ol och silab'il chi'? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","—Ach vuninal, a Dios ol ac'an noc', xchi vin̈. Ix b'eyn̈ejb'at eb'. ");
INSERT INTO cac_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Axo ix c'och eb' b'aj ix yal Dios chi', ix sb'oan jun altar vin̈aj Abraham chi', ix sb'oanq'ue te' c'atzitz chi' vin̈ d'a yib'an̈. Ix lajvi chi' ix tzuyan vin̈ yuninal vin̈ chi', ix yac'anq'ue vin̈ d'a yib'an̈ te' c'atzitz chi'. ");
INSERT INTO cac_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ix yic'ancot q'uen cuchilub' chi' vin̈ yic smilancham yuninal vin̈ chi' silab'il. ");
INSERT INTO cac_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Axo yángel Jehová ix avajemta d'a satchaan̈ icha tic: —Abraham, Abraham, xchi. —¿Tas xchi Mamin? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ix yalan jun ángel chi': —Man̈ ac'och a c'ab' a milancham vin̈ uninal chi'. Ix vojtaquejeli to ay velc'och d'a yol a sat, yujto maj a tenec' ac'an jun pitan̈ uninal chi' d'ayin, xchi yángel Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ix b'at q'uelnaj vin̈aj Abraham chi' d'a spatic, ix yilan vin̈ ayec' jun noc' ch'ac calnel sud'ancan sch'ac d'a scal jun te' q'uiix. Ix b'at lemnaj vin̈ yic'cot noc', ix sn̈usan noc' vin̈ silab'il sq'uexuloc vin̈ yuninal chi'. ");
INSERT INTO cac_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ix yac'ancan sb'i jun lugar chi' vin̈: A Jehová tz'ac'an tas tz'och cuuj. Yuj chi' syaln̈ej eb' anima icha tic: A d'a lum vitz a Jehová tz'ac'an tas tz'och cuuj, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ix yalanxiemta yángel Jehová chi' d'a vin̈: ");
INSERT INTO cac_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","—A in ton Jehová in svala': Yujto ix a c'anab'ajej a c'ulan jun tic, maj a tenec' ac'an jun pitan̈ uninal d'ayin, yuj chi' svac' in ti', ");
INSERT INTO cac_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","d'a val yel ol vac' in vach'c'olal d'a ib'an̈. Ol vac' q'uib' sb'isul in̈tilal, icha q'uen c'anal d'a satchaan̈, ma icha pax yarenail sti' a' mar. An̈ejtona' pax eb' in̈tilal ol yac' ganar eb' ayoch ajc'olal d'a eb'. ");
INSERT INTO cac_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Yujto ix a c'anab'ajej tas ix vala', yuj chi' masanil nación d'a yolyib'an̈q'uinal tic ol scha in vach'c'olal yuj eb' in̈tilal, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ix lajvi chi', ix meltzajxi vin̈aj Abraham chi' yed' vin̈ yuninal b'aj aycan chavan̈ eb' schecab', junxon̈ej ix aj smeltzaj eb' d'a Beerseba chi', ata' ix cajnajcan eb'. ");
INSERT INTO cac_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ayic ix ec' jun tiempo, ix yab'an specal vin̈aj Abraham chi' to ayxo yuninal vin̈ yuc'tac vin̈, aton vin̈aj Nacor yed' ix Milca. ");
INSERT INTO cac_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","A vin̈ sb'ab'el unin eb', Uz sb'i vin̈. A vin̈ schab'il Buz sb'i vin̈, axo vin̈ yoxil Kemuel sb'i vin̈, aton vin̈ smam yichamcan eb' Aram. ");
INSERT INTO cac_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Ix aljipax vin̈aj Quesed, vin̈aj Hazo, vin̈aj Pildas, vin̈aj Jidlaf yed' vin̈aj Betuel. ");
INSERT INTO cac_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Aton vajxacvan̈ eb' vin̈ tic yune' ix Milca yed' vin̈aj Nacor chi'. A vin̈aj Betuel chi', aton vin̈ smam ix Rebeca. ");
INSERT INTO cac_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ay juntzan̈xo eb' yuninal vin̈aj Nacor yed' junxo ix yetb'eyum scuch Reúma, aton vin̈aj Teba, vin̈aj Gaham, vin̈aj Tahas yed' vin̈aj Maaca. ");
INSERT INTO cac_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","A ix Sara 127 ab'il sq'uinal ix, ");
INSERT INTO cac_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ayic ix cham ix d'a chon̈ab' Quiriat-arba, aton Hebrón d'a yol yic Canaán. Ix te oc' vin̈aj Abraham yuj schamel ix Sara chi', ix ochcan vin̈ d'a cusc'olal yuj ix. ");
INSERT INTO cac_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ix can snivanil ix yetb'eyum vin̈ chi', ix b'at vin̈ d'a eb' hitita cajan d'a jun lugar chi', ix yalan vin̈ d'a eb' icha tic: ");
INSERT INTO cac_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","—Vach'chom ch'oc chon̈ab'il vajec' d'a e cal, palta elocab' d'a e c'ol tze chon̈ jab'oc in luum b'aj tzin muc snivanil ix vetb'eyum chi', xchi vin̈ d'a eb'. ");
INSERT INTO cac_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ix tac'vi eb' d'a vin̈: ");
INSERT INTO cac_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","—Mamin, ab' tas ol cal d'ayach, a ach tic te nivan elc'och d'a co cal tic, yuj chi' syal a mucan a chamnac chi' b'aj te vach' d'a co campusante. Malaj junoc on̈ max co cha a muc snivanil ix etb'eyum chi' d'a q'uen q'ueen joyb'ilel yool, xchi eb' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Axo vin̈aj Abraham chi', ix q'ue lin̈an vin̈, ix em n̈ojnaj vin̈ yic sch'oxan vin̈ to ay yelc'och eb' vin̈ d'a sat vin̈. ");
INSERT INTO cac_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ix yalan vin̈: —Tato yel tz'el d'a e c'ol tzin muc snivanil ix vetb'eyum chi' d'a tic, alec d'a vin̈aj Efrón, yuninal vin̈aj Zohar ");
INSERT INTO cac_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","to schon̈ q'uen n̈aq'ueen vin̈ d'ayin d'a Macpela d'a stitac sluum vin̈. Ol in tup d'a vin̈ icha stojol yic sviquejcan jun lugar chi' b'aj tzin muc in chamnac d'a e cal, xchi vin̈aj Abraham chi'. ");
INSERT INTO cac_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ayec' vin̈aj Efrón hitita chi' d'a scal eb'. Ix tac'vi vin̈. Te chaan̈ ix yal vin̈ yic vach' syab' masanil eb' yetchon̈ab' molanec' chi' yed' eb' tz'och d'a yol chon̈ab' chi'. Ix yalan vin̈: ");
INSERT INTO cac_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","—Maay mamin, sval d'ayach to a jun n̈aq'ueen yed' lum luum chi' ton̈ej tzin siej d'ayach. Testigo tz'ajcan eb' vetchon̈ab' tic to ton̈ej tzin siej jun lum chi' d'ayach. Muc ix etb'eyum chi' ta', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Yuj chi' ix emxi n̈ojnaj vin̈aj Abraham chi' d'a yichan̈ eb' ayec' chi', ");
INSERT INTO cac_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ix yalan vin̈ d'a vin̈aj Efrón d'a yichan̈ eb' smasanil: —Ab' val tas sval d'ayach to tza cha stojol luum, ichato chi' ol in mucan ix vetb'eyum chi' ta', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ix tac'vi vin̈aj Efrón chi': ");
INSERT INTO cac_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","—Ab' jun mamin, 400 siclo q'uen plata stojol luum. Yujto a ach, svac' lum d'ayach icha jun stojol chi', toxon̈ej b'at a muc ix, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ix scha sc'ol stojol lum chi' vin̈aj Abraham icha ix yal vin̈ d'a yichan̈ masanil eb' vin̈ hitita chi'. Ix stupan lum vin̈ icha ix aj strato eb' chi'. ");
INSERT INTO cac_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Icha chi' ix aj yochcan lum sluum vin̈aj Efrón chi' yicoc vin̈aj Abraham chi', lum Macpela d'a slac'anil lum yic vin̈aj Mamre, b'aj ay q'uen n̈aq'ueen yed' te te'. Ix yiquejcan masanil juntzan̈ chi' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ix yiquejcan lum vin̈aj Abraham chi' d'a yichan̈ masanil eb' vin̈ hitita molanec' ta'. Masanil eb' tz'och d'a spuertail chon̈ab' chi', testigo pax ix ajcan eb' d'a jun trato chi'. ");
INSERT INTO cac_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ix lajvi chi', ix smucancan ix yetb'eyum vin̈ chi' d'a q'uen n̈aq'ueen d'a lum Macpela chi', d'a slac'anil slum vin̈aj Mamre d'a Hebrón d'a yol yic Canaán. ");
INSERT INTO cac_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Icha chi' ix aj schon̈ancanel slum eb' vin̈ hitita yed' q'uen olan q'ueen d'a vin̈aj Abraham b'aj smuc schamnac. ");
INSERT INTO cac_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Te icham vinacxo vin̈aj Abraham, axo Jehová ix yac' svach'c'olal d'a yib'an̈ vin̈ yed' d'a yib'an̈ masanil tas ay d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ay jun schecab' vin̈ te ichamxo, sat yaj d'a juntzan̈xo eb' schecab', ayoch yilumaloc masanil tastac ay d'a vin̈. Ay jun c'ual ix avtaj vin̈ yuj vin̈aj Abraham chi', ix yalan vin̈: —Ac'och a c'ab' d'a yalan̈ in xub' tic, ");
INSERT INTO cac_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","tzac'an a ti' d'a yichan̈ Jehová Dios yajal satchaan̈ yed' yolyib'an̈q'uinal tic, to man̈ ol a saylaj ix yetb'eyum vin̈ vuninal d'a scal eb' aj Canaán, b'aj cajan on̈ tic, ");
INSERT INTO cac_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","palta d'a in chon̈ab' tzach b'ati, b'at a say junoc ix yetb'eyum vin̈ d'a scal eb' in c'ab' voc, xchi vin̈ d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ix tac'vi vin̈ schecab' vin̈ chi': —Q'uinaloc max stac'cot sb'a ix ved'oc, ¿tas svutej? ¿Yovalil am svic'b'at vin̈ b'aj cotnac ach chi'? xchi vin̈ schecab' chi'. ");
INSERT INTO cac_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ix tac'vi vin̈aj Abraham chi': —Maay, man̈ ic'b'at vin̈. ");
INSERT INTO cac_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","A Jehová sDiosal satchan̈ ix in ic'anelta b'aj ay spat in mam yed' d'a in chon̈ab' b'aj ec'nac in. Ix yac'an sti' d'ayin yac'an jun lum tic d'a vin̈tilal. An̈eja', a' ol checanb'at yángel ed'oc, yic vach' tzic'cot ix yetb'eyum vin̈ vuninal tic ta'. ");
INSERT INTO cac_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Palta tato max yal sc'ol ix scot ed'oc jun, colan tzach ajcan d'a jun co trato scac' tic. Palta juneln̈ej max yal-laj ic'anb'at vin̈ vunin tic ta', xchi vin̈ d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ix lajvi chi', ix yac'anoch sc'ab' jun vin̈ checab' chi' d'a yalan̈ xub' vin̈aj Abraham chi', ix yac'an sti' vin̈ to ol sc'anab'ajej vin̈ masanil tas ix yal vin̈ spatrón chi'. ");
INSERT INTO cac_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ix lajvi chi', ix sic'anelta juntzan̈ silab' vin̈ d'a scal masanil tastac ay d'a vin̈ spatrón chi', juntzan̈ te vach'. Ix yic'anb'at lajun̈van̈ noc' camello vin̈ scuchumaloc, ix b'at vin̈ d'a chon̈ab' b'aj ec'nac vin̈aj Nacor chamnac, d'a yol yic Mesopotamia. ");
INSERT INTO cac_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ayic ix c'och vin̈ checab' d'a stiel chon̈ab' chi', yic vanxo sq'uic'b'i, ix yic' yip vin̈ yed' noc' camello d'a sti' jun a' uc'b'ila'. A d'a jun hora chi' tz'ec' eb' ix cob'estac yic' yaal. ");
INSERT INTO cac_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","D'a jun rato chi', ix och ijan vin̈ slesalvi d'a Dios d'a spixan icha tic: Mamin Jehová, ach co Diosal yed' vin̈aj Abraham in patrón, tzin c'an d'ayach to vach'ocab' tz'elc'och jun in checnab'il tic, tza ch'oxan a vach'c'olal d'a vin̈ in patrón chi'. ");
INSERT INTO cac_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tic tzin can d'a sti' jun a' uc'b'ila' tic, yacb'an sja eb' ix cob'estac aj chon̈ab' tic ul yic' yaal. ");
INSERT INTO cac_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Elocab' d'a a c'ol to a junoc ix cob'es ol ja yic' yaal, ol val d'a ix icha tic: Tzin tevi d'ayach, iq'uemta a ch'ub' chi', tzac'an jab'oc a'al chi' vuc'u', xin cham d'a ix. Axo ol yalan ix: Uc' a', ol vac'anpax a' yuc' noc' a camello tic, xcham ix, aocab' ix chi' tza siq'ueli yic tz'och yetb'eyumoc vin̈aj Isaac a checab'. Icha chi' ol aj snachajel vuuj to ay a vach'c'olal d'a vin̈ in patrón, xchi vin̈ checab' chi' d'a slesal. ");
INSERT INTO cac_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Manto lajvilaj slesalvi vin̈, ix yilan vin̈ scot jun ix cob'es, ayq'ue sch'ub' ix d'a sjolom sjen̈jab', aton ix Rebeca yisil vin̈aj Betuel. A vin̈aj Betuel chi' yunecan vin̈ ix Milca yed' vin̈aj Nacor, vin̈ yuc'tac vin̈aj Abraham. ");
INSERT INTO cac_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","A ix Rebeca chi' te vach' yilji ix, cob'es ton val ix, mantalaj junoc vinac sc'uman ix. Ix em ix b'aj ay a' uc'b'ila' chi' yic syic'q'ueta a' yaal ix, ix yac'an b'ud'joc sch'ub' ix chi'. Ayic van spax ix, ");
INSERT INTO cac_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ix b'at lemnaj vin̈ checab' chi' stzac'vej ix, ix yalan vin̈ d'a ix icha tic: —Tzin tevi d'ayach, ac' vuc' jab'oc a'al d'a yol a ch'ub' chi', xchi vin̈ d'a ix. ");
INSERT INTO cac_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","—Uq'uej a' mamin, xchi ix. Elan̈chamel ix yaq'uem sch'ub' ix chi', ix yac'an a' ix yuq'uej vin̈. ");
INSERT INTO cac_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ix lajvi yuc'an a' vin̈, ix yalan ix icha tic: —Syalpax vic'anq'ueta a' yuc' noc' a camello tic, ato syala' jantac syuc' noc', xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Elan̈chamel ix sequem a' ix d'a yol jucub' b'aj syuc'taxon a' noc' noc'. Tzijtum el ix yac' ix yic'anq'ueta a' masanto ix yuc' a' noc' smasanil. ");
INSERT INTO cac_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Axo vin̈ checab' chi' jun, ton̈ej ix och q'uelan vin̈ d'a ix. Malaj tas ix yal vin̈, an̈ej to sna vin̈ yic syojtaquejeli tas van sc'ulan Jehová yic vach' tz'elc'och jun schecnab'il chi'. ");
INSERT INTO cac_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Axo ix lajvi yuc'an a' noc' camello chi', ix yic'anq'ueta jun q'uen oro vin̈ icha uchiquin, nan̈al siclo yalil, ix yac'anoch vin̈ d'a sn̈i' ix, ix yac'anpax chab' q'uen brazalete vin̈ d'a ix, nab'a oro q'ueen, ec'b'al 10 siclo yalil q'ueen. ");
INSERT INTO cac_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ix yalan vin̈: —Tzin tevi d'ayach to tzal d'ayin mach ayach yico', talaj colan tzon̈ vaycan d'a spat vin̈ a mam chi' d'a jun ac'val tic, xchi vin̈ d'a ix. ");
INSERT INTO cac_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ix yalan ix: —Yisil in vin̈aj Betuel, yuninal vin̈aj Nacor yed' ix Milca. ");
INSERT INTO cac_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","A d'a co pat colan tzex vayi. Ay pax tas ol sva noc' a camello tic, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ix yab'an vin̈ checab' chi', ix em cumnaj vin̈, ix yalan vach' lolonel vin̈ d'a Jehová, ix yac'an yuj diosal vin̈ d'ay. ");
INSERT INTO cac_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ix yalan vin̈: Alchajocab' vach' lolonel d'a Jehová co Diosal yed' vin̈aj Abraham in patrón. Yelton val ayn̈ejoch Jehová yed' vin̈, ayn̈ej svach'c'olal d'a vin̈, yuj chi' ix in scuchb'ej d'a yoltac b'e tic masanto d'a scal eb' sc'ab'yoc vin̈ in patrón chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Axo ix Rebeca ix b'at lemnaj ix d'a spat snun, yic syalan masanil tas ix yal vin̈ checab' chi' d'ay. ");
INSERT INTO cac_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ay jun vin̈ snulej ix scuch Labán, elan̈chamel ix b'at lemnaj vin̈ b'aj ay a' uc'b'ila' chi' yic syic'cot vin̈ checab' chi'. ");
INSERT INTO cac_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Yujto ix yiloch q'uen oro vin̈, q'uen ayoch d'a sn̈i' ix yed' q'uen brazalete ayoch d'a sc'ab' ix yanab' chi', yuj chi' ix b'at vin̈ b'aj ayec' vin̈ schecab' vin̈aj Abraham chi' yed' noc' camello. ");
INSERT INTO cac_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ix yalan vin̈ d'a vin̈ checab' chi': —Mamin, con̈ ved'oc b'aj ay in pat, yujto ay svach'c'olal Jehová d'ayach. Max yal tzach can d'a tic. Toxo ix in b'o b'aj ol ach vayoc, ay pax b'aj vach' ol can noc' a camello tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ix lajvi chi', ix b'at vin̈ checab' chi' d'a spat vin̈. Ix colvaj vin̈aj Labán chi' yic'anel yicatz noc' camello chi'. Ix yac'an va noc' vin̈. Elan̈chamel ix yic'cot a a' vin̈ yic sb'icchaj yoc vin̈ checab' chi' yed' eb' ajun yed'oc. ");
INSERT INTO cac_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ayic ix ac'ji va eb', ix yalan vin̈ checab' chi': —Manto ol in valaj, yovalil ol valcan tas in checnab'il ved'nac, xchi vin̈. —Lolonan̈ an mamin, xchi vin̈aj Labán chi'. ");
INSERT INTO cac_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ix yalan vin̈ checab' chi': —A in tic schecab' in vin̈aj Abraham. ");
INSERT INTO cac_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ix yac' svach'c'olal Jehová d'a yib'an̈ vin̈. B'eyum val vin̈ sic'lab'il. Ay noc' scalnel vin̈, ay noc' svacax vin̈, ay noc' scamello vin̈, ay noc' sb'uru vin̈, ay pax q'uen oro yed' q'uen plata d'a vin̈. Ay pax eb' vin̈ schecab' vin̈ yed' eb' ix schecab' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","An̈ejtona' ix Sara yetb'eyum vin̈, yicxo val schichimal, ix alji jun yune' ix. Axo masanil tas ay d'a vin̈ in patrón chi', yicn̈ejton vin̈ yuninal vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","A vin̈ in patrón chi' ix yal vin̈ to svac' in ti' yic tzin c'anab'ajej schecnab'il. Ix yal vin̈ icha tic: Man̈ ol yal-laj yic'lan sb'a vin̈ vuninal tic yed' junoc eb' ix aj Canaán b'aj ay on̈ ec' tic. ");
INSERT INTO cac_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Yuj chi', tzach b'at a say ix yetb'eyum vin̈ vuninal tic d'a scal eb' in c'ab' voc. Ata' tzach b'ati, xchi vin̈ d'ayin. ");
INSERT INTO cac_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ix valan d'a vin̈ in patrón chi': A junoc ix ix sb'at vic'cot chi', tato max stac'cot sb'a ix ved'oc, ¿tas vach' svutej? xin chi. ");
INSERT INTO cac_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ix tac'vi vin̈ d'ayin: A in tic, emnaquiln̈ej svutej in b'a d'a Jehová. A' ol schecb'at yángel ed'oc yic vach'n̈ej ol aj yelc'och jun a checnab'il chi', yic tzic'ancot junoc ix yetb'eyum vin̈ vuninal tic d'a scal eb' in c'ab' voc. ");
INSERT INTO cac_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Axon̈ej tato a eb' chi' max ac'an ix cob'es chi' d'ayach, colan ach b'aj ix ac' a ti' d'ayin, xchi vin̈ in patrón chi' d'ayin. ");
INSERT INTO cac_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Icha chi' jun, ix in ja d'a sti' a' uc'b'ila' chi' ticnaic, ix in lesalvi d'a Dios icha tic: Ach Jehová co Diosal yed' vin̈aj Abraham in patrón, tato yel ayach och ved'oc, tato vach' ol elc'och jun in checnab'il tic, ");
INSERT INTO cac_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","tzin tevi d'ayach, yacb'an ayinec' d'a sti' a' uc'b'ila' tic, axo ol ajoc, to a ix cob'es ol ja ic'oj a', ol valan d'a ix: Tzin tevi d'ayach to tzac' vuc' jab'oc a'al d'a yol a ch'ub' chi', xin cham d'a ix. ");
INSERT INTO cac_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Axom ol yalan ix chi': Uc'a', svic'paxq'ueta a' yuc' noc' a camello tic, xchampax ix. Aton val ix chi' ix a siq'ueli yic tz'och yetb'eyumoc vin̈ yuninal vin̈ in patrón, xin chi d'a in lesal chi'. ");
INSERT INTO cac_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ayto val slajvi in lesal chi' d'a esalil, ix vilani, ix c'och ix Rebeca tic, ix em ix b'aj ay a' uc'b'ila', ayq'ue sch'ub' ix d'a sjolom sjen̈jab'. Ix valan d'a ix: Tzin tevi d'ayach, ac' vuc' jab'oc a'al chi', xin chi d'a ix. ");
INSERT INTO cac_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","D'a elan̈chamel ix yiq'uemta sch'ub' ix, ix yalan ix: Uq'uej a' mamin, yed' pax noc' a camello, ol vac'pax yuc'a' noc', xchi ix. Icha chi' jun, ix yac'an a' ix vuq'uej, ix yac'anpax a' ix yuc' noc' in camello chi'. ");
INSERT INTO cac_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ix in c'anb'an d'a ix: ¿Mach ayach yisil? xin chi d'a ix. Ix yalan ix d'ayin: Yisil in vin̈aj Betuel, yuninal vin̈aj Nacor yed' ix Milca, xchi ix. Ix vac'anoch jun q'uen icha uchiquin d'a sn̈i' ix, ix vac'anpaxoch junjun q'uen brazalete d'a junjun sc'ab' ix. ");
INSERT INTO cac_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ix lajvi chi' ix in em cumnajoc, ix valan in b'a d'a Jehová in Diosal yed' vin̈ in patrón d'a lesal, ix vac'an yuj diosal d'ay yujto ayn̈ejoch ved'oc yic in cot d'a yol b'e. Vach'n̈ej ix aj in coti, yic tzul vic'an ix yetb'eyum vin̈ yuninal vin̈ in patrón d'a e cal a ex sc'ab' yoc ex vin̈ tic. ");
INSERT INTO cac_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","A ticnaic jun, lolonan̈ec. ¿Vach'n̈ej am ol eyutej e pensar d'a vin̈ in patrón chi'? Tato maay jun, alecpax d'ayin, yic vach' snachajel vuuj tas tzin c'ulej, xchi vin̈ checab' chi'. ");
INSERT INTO cac_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ix lajvi chi' ix yalan vin̈aj Labán yed' vin̈aj Betuel: —Masanil juntzan̈ tic ix cot d'a Jehová, a on̈ tic man̈xalaj tas vach' calan d'ayach. ");
INSERT INTO cac_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ina ix tic, ic'b'at ix, b'atocab' ix yetb'eyumoc vin̈ yuninal vin̈ a patrón chi', icha val ix aj snaan Jehová, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Axo yic ix yab'an vin̈ checab' chi' jun, ix em cumnaj vin̈ d'a yichan̈ Jehová, ix yac'an yuj diosal vin̈ d'ay. ");
INSERT INTO cac_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Elan̈chamel ix yic'q'ueta jantac silab' vin̈, aton q'uen oro, q'uen plata yed' pichul, ix yac'an vin̈ d'a ix Rebeca yed' d'a vin̈ snulej ix yed' pax d'a ix snun ix. ");
INSERT INTO cac_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ix lajvi chi', ix va vin̈ yed' eb' ajun yed'oc, ata' ix vaycan eb' d'a jun ac'val chi'. Axo yic ix q'ue vaan eb' d'a q'uin̈ib'alil d'a junxo c'u, ix yalan vin̈ checab' chi': —A ticnaic jun, chequecb'at ix ved'oc d'a vin̈ in patrón, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ix tac'vi vin̈ snulej ix yed' ix snun ix chi', ix yalan eb': —Canocab' jayeocxo c'ual ix qued'oc, ichato chi' ol b'at ix ed'oc, xchi eb' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Axo ix tac'vi vin̈ checab' chi': —Man̈xo in eyamoch vaan. A Jehová ayn̈ejoch ved'oc, yuj chi' vach' ix aj yelc'och jun in checnab'il tic. Chaec in pax d'a vin̈ in patrón, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ix yalan eb': —Avtejeccot ix cob'es chi', ol cab'i tas xchi ix, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ix avtajcot ix Rebeca chi', ix sc'anb'an eb' d'a ix: —¿Tzam yal a c'ol tzach b'at yed' jun vin̈ vinac tic? xchi eb'. —I' syala', ol in b'atoc, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ix lajvi chi', ix yac'anb'at ix Rebeca chi' eb' vin̈ yed' jun ix ix, ix ilan q'uib' ix yed' vin̈ checab' chi' yed' eb' yetb'eyum vin̈ yed'nac. ");
INSERT INTO cac_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ix yalan vach' lolonel eb' d'a ix Rebeca icha tic: Yac'ocab' svach'c'olal Jehová Dios d'a ib'an̈, ol ach och snunoc jantac smillonal anima. A jantac eb' ol och ajc'olal d'a eb' une' ol aljoc, ol can eb' d'a yalan̈ yuj eb' une' chi', xchi eb'. ");
INSERT INTO cac_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ix lajvi chi', ix q'ue ix Rebeca yed' eb' ix schecab' d'a yib'an̈ noc' camello, ix och tzac'an eb' d'a spatic vin̈ schecab' vin̈aj Abraham chi'. Ichaton chi' ix aj yic'anb'at ix Rebeca vin̈ checab' chi', ix b'at eb' b'ian. ");
INSERT INTO cac_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ayic van slac'anvi ja eb' d'a Beerseba, a vin̈aj Isaac, toxo ix meltzaj vin̈ d'a jun a' uc'b'ila' scuch A Dios Pitzan Tzin Ilani. A d'a yol yic Neguev cajan vin̈. ");
INSERT INTO cac_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Axo yic vanxo yem c'u, van sb'eyec' vin̈, van snaub'tan̈an vin̈, axo ix yilan vin̈ to ay juntzan̈ noc' camello scoti. ");
INSERT INTO cac_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","65","An̈ejtona' ix Rebeca, ix b'at q'uelan ix, ix yilanb'at vin̈aj Isaac chi' ix. Ix sc'anb'an ix d'a vin̈ checab' chi': —¿Mach jun vin̈ vinac scot d'a quichan̈ tic? xchi ix. Ix yalan vin̈ checab' chi': —Aton vin̈ in patrón chi', xchi vin̈. Yuj chi', ix yic'anemta smusil sat ix, elan̈chamel ix emta ix d'a yib'an̈ noc' camello chi'. ");
INSERT INTO cac_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ix yalan vin̈ checab' chi' d'a vin̈aj Isaac tas ix aj yelc'och schecnab'il. ");
INSERT INTO cac_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ix ic'jib'at ix Rebeca yuj vin̈aj Isaac d'a smantiado ix Sara, ix snun vin̈ chamnac, ix yic'lan sb'a vin̈ yed' ix. Te xajan ix Rebeca chi' yuj vin̈. Icha chi' ix aj yec' scusc'olal vin̈ yuj schamel ix snun. ");
INSERT INTO cac_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ixto yic' junxo ix yetb'eyum vin̈aj Abraham chi' scuchan Cetura. ");
INSERT INTO cac_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","A eb' yuninal vin̈ ix alji yed' ix, aton vin̈aj Zimram, vin̈aj Jocsán, vin̈aj Medán, vin̈aj Madián, vin̈aj Isbac yed' vin̈aj Súa. ");
INSERT INTO cac_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","A vin̈aj Jocsán smam vin̈aj Seba yed' vin̈aj Dedán. A pax eb' yin̈tilal vin̈aj Dedán jun, aton eb' asureo, eb' letuseo yed' eb' leumeo. ");
INSERT INTO cac_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Axo pax eb' yuninal vin̈aj Madián chi', aton vin̈aj Efa, vin̈aj Efer, vin̈aj Hanoc, vin̈aj Abida yed' vin̈aj Elda. Masanil juntzan̈ eb' tic yin̈tilal vin̈aj Abraham chi' yed' ix Cetura. ");
INSERT INTO cac_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ix yac' vin̈ masanil tas ay d'ay smacb'enoc vin̈aj Isaac. ");
INSERT INTO cac_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Axo pax yune' juntzan̈xo eb' ix chi' jun, axon̈ej silab' ix ac'chaj d'a eb' yuj vin̈. Ayic pitzanto vin̈, ix och ijan vin̈ schecancanel eb' vin̈ chi' vin̈ d'a stz'ey vin̈aj Isaac chi'. Ix checjib'at eb' vin̈ d'a stojolal b'aj sjavi c'u. ");
INSERT INTO cac_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","A vin̈aj Abraham chi', 175 ab'il sq'uinal vin̈ ayic ix cham vin̈. ");
INSERT INTO cac_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ichamilxo ix ic'an scham vin̈. ");
INSERT INTO cac_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","A eb' yuninal vin̈, aton vin̈aj Isaac yed' vin̈aj Ismael xid' mucan vin̈ d'a q'uen olan q'ueen d'a Macpela, d'a slac'anil lum sluum vin̈aj Mamre d'a lum yiquejnac junel vin̈aj Efrón yuninal vin̈aj Zohar, vin̈ hitita. ");
INSERT INTO cac_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Aton lum chi' manb'ilcan yuj vin̈aj Abraham d'a eb' hitita. A b'aj mucb'il ix Sara, ata' ix mucchaj vin̈aj Abraham chi'. ");
INSERT INTO cac_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Axo yic toxo ix cham vin̈, ix yac'ancot svach'c'olal Dios d'a yib'an̈ vin̈aj Isaac. Ix can cajan vin̈ d'a slac'anil a' uc'b'ila' scuchan A Dios Pitzan Tzin Ilani. ");
INSERT INTO cac_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Aton yab'ixal eb' yin̈tilal vin̈aj Ismael yuninal vin̈aj Abraham yed' ix Agar, ix aj Egipto, aton ix ec'nac criadail d'a ix Sara. ");
INSERT INTO cac_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Aton stzolal tic, tas ix aj yalji eb': Vin̈aj Nebaiot, aton vin̈ b'ab'el unin chi', slajvi chi' vin̈aj Cedar, vin̈aj Adbeel, vin̈aj Mibsam, ");
INSERT INTO cac_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","vin̈aj Misma, vin̈aj Duma, vin̈aj Masa, ");
INSERT INTO cac_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","vin̈aj Hadar, vin̈aj Tema, vin̈aj Jetur, vin̈aj Nafis yed' vin̈aj Cedma. ");
INSERT INTO cac_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Aton sb'i eb' lajchavan̈ yuninal vin̈aj Ismael tic. A sb'i eb' vin̈ chi' ix och sb'ioc sluum b'aj ix cajnaji. Junjun eb', yajal ix ajcan eb' d'a junjun chon̈ab'. ");
INSERT INTO cac_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","A vin̈aj Ismael chi', 137 ab'il sq'uinal vin̈, ayic ix cham vin̈. ");
INSERT INTO cac_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","A masanil eb' yin̈tilal vin̈ chi', ix c'ochcan cajan eb' d'a scal Havila yed' Shur, d'a yichan̈cot lum Egipto b'aj sb'at b'eal Asiria. Ata' ix cajnaj eb', vach'chom malaj sgana eb' sc'ab' yoc eb'. ");
INSERT INTO cac_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Aton yab'ixal vin̈aj Isaac yuninal vin̈aj Abraham: ");
INSERT INTO cac_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","40 ab'il sq'uinal vin̈aj Isaac chi' ayic ix yic'lan sb'a vin̈ yed' ix Rebeca yisil vin̈aj Betuel, yanab' vin̈aj Labán arameo, aton vin̈ cajan d'a Padán-aram. ");
INSERT INTO cac_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","A ix Rebeca chi' malaj yune' ix. Axo vin̈aj Isaac ix lesalvi d'a Jehová yic tz'ac'ji yune' eb' yuuj. Icha chi' jun, ix ab'ji slesal eb' yuj Jehová, ix och ix Rebeca yab'ixal. ");
INSERT INTO cac_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","A eb' unin chi', tiox eb'. Ix yac' oval eb' d'a yol sc'ool snun chi'. Yuj chi' ix sna' ix: ¿Tas yuj sja jun tic d'a vib'an̈? xchi ix. Ix lajvi chi' ix b'at yalan sb'a ix d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ix tac'vi Jehová chi' d'a ix: Chab' chon̈ab'il ol aj yin̈tilal eb' chavan̈ ed'nac chi'. Yictax manto aljoc eb', ol och eb' ajc'olal d'ay junjun. Jun te ay yip, te tec'an d'a yichan̈ junxo. A vin̈ b'ab'el, ol can vin̈ d'a yalan̈ smandar vin̈ tzac'an, xchi d'a ix. ");
INSERT INTO cac_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ix c'och sc'ual yalji eb' yune' ix Rebeca chi', tiox eb' unin ix alji chi'. ");
INSERT INTO cac_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","A vin̈ b'ab'el ix alji, te chac tzeminac yilji vin̈, te ay xil snivanil vin̈, Esaú ix yac' eb' sb'iej vin̈. ");
INSERT INTO cac_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Tzac'an ix alji junxo yuc'tac chi', yub'yub' och d'a sjaj yoc vin̈aj Esaú chi', yuj chi' Jacob ix yac' eb' sb'iej. 60 ab'il sq'uinal vin̈aj Isaac chi' ayic ix alji eb' yune' ix Rebeca chi'. ");
INSERT INTO cac_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ix q'uib'n̈ej chavan̈ unin chi'. A vin̈aj Esaú pechoj noc' ix sc'ulej vin̈. An̈ej caltac te' snib'ej vin̈ tz'eq'ui. Axo pax vin̈aj Jacob chi', malaj b'aj tz'ec' vin̈ d'a najat, ayn̈ejec' vin̈ d'a scampamento. ");
INSERT INTO cac_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Te xajan vin̈aj Esaú yuj vin̈aj Isaac chi' yujto snib'ej vin̈ schi noc' c'ultaquil noc' sja yuj vin̈. Axo pax vin̈aj Jacob jun, te xajan vin̈ yuj ix Rebeca. ");
INSERT INTO cac_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ay jun c'ual, van stz'an̈an jun vael vin̈aj Jacob chi' ayic ix jax vin̈aj Esaú chi' b'eyelec' d'a caltac te', te ay svejel vin̈. ");
INSERT INTO cac_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ix yalan vin̈ d'a vin̈aj Jacob chi': Ac' val jab'oc jun a vael chac yilji tic d'ayin, yujto tzin cham yuj vejel, xchi vin̈. (Yuj chi' Edom ix ac'ji sb'iej vin̈.) ");
INSERT INTO cac_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","—D'a sb'ab'elal, ac'can a derecho yic b'ab'el vinaquil d'ayin, ichato chi' ol vac'ani, xchi vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ix yalanxi vin̈aj Esaú chi': —Ina van in cham yuj vejel, yilxo jun in derecho yic b'ab'el vinaquil chi', ¿tas val ol och vuuj? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","—Ac'can a ti' d'ayin d'a jun rato tic, xchi vin̈aj Jacob chi'. —Inye, xchi vin̈aj Esaú chi'. Ix yac'an sti' vin̈ yic sch'oxaneli to syac'can sderecho vin̈ yic sb'ab'el vinaquil d'a vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ix lajvi chi' ix yac'an ixim pan yed' jun plato vael vin̈aj Jacob chi' d'a vin̈. Axo yic ix lajvi sva vin̈, ix q'ue vaan vin̈, ix b'at vin̈. Malaj yelc'och jun derecho yic b'ab'el uninal chi' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","A d'a junel ix ja jun nivan vejel d'a jun lugar chi', icha jun yac'nac d'a yol stiempoal vin̈aj Abraham. Yuj chi' ix b'atcan vin̈aj Isaac d'a yol yic Gerar, b'aj ayec' vin̈aj Abimelec sreyal eb' filisteo. ");
INSERT INTO cac_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ata' ix sch'ox sb'a Jehová d'a vin̈, ix yalani: Man̈ ach b'at d'a Egipto, canan̈ b'aj sval d'ayach. ");
INSERT INTO cac_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","A ticnaic, vach' ajec' d'a jun lugar tic, ayinn̈ej ec' ed'oc, ol in ch'oxn̈ej in vach'c'olal d'ayach, yujto a jun lum tic ol vac' d'ayach smasanil yed' d'a masanil in̈tilal, yic vach' tz'elc'och masanil tas valnaccan d'a vin̈ a mam aj Abraham. ");
INSERT INTO cac_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Man̈ jantacoc ol vutej eb' in̈tilal, icha sb'isul q'uen c'anal d'a satchaan̈ icha chi' ol aj eb'. Ol vac'an jun luum tic smasanil d'a eb'. Yujn̈ej in̈tilal chi' ol scha in vach'c'olal masanil nación, ");
INSERT INTO cac_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","yujto a vin̈ a mam aj Abraham chi', sc'anab'ajejnac vin̈ tas valnac. Masanil in checnab'il, in ley yed' in c'ayb'ub'al vac'nac d'a vin̈, sc'anab'ajejnac vin̈, xchi Jehová d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Yuj chi' ix cann̈ej vin̈aj Isaac chi' d'a Gerar chi'. ");
INSERT INTO cac_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Axo yic ix sc'anb'an eb' vin̈ aj lugar chi' yuj ix yetb'eyum vin̈, ix yal vin̈ to yanab' ix vin̈. Ix xiv vin̈ yalani tato yetb'eyum ix vin̈, yujto ix sna' vin̈ ta icha chi' smiljicham vin̈ yuj eb', syic'anec' ix eb', yujto a ix Rebeca chi' te vach' yilji ix. ");
INSERT INTO cac_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ata' ix ec' tiempo yuj eb'. Ay jun c'ual ix yilelta vin̈ rey chi' d'a yol jun ventena to chelcheloch vin̈aj Isaac chi' d'a ix Rebeca ix yetb'eyum chi'. ");
INSERT INTO cac_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ix b'at checjicot vin̈ yuj vin̈ rey chi', ix yalan vin̈ d'a vin̈: —Toxo ix vila' to etb'eyum ix ix tic, ¿icham chi', ma to maay? ¿Tas yuj ix ala' to anab' ix? xchi vin̈. Ix yalan vin̈aj Isaac chi': —Ix in na' q'uinaloc tzin smilcham eb' aj chon̈ab' tic yuj ix, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ix yalan vin̈ rey chi': —¿Tas yuj icha chi' ix a c'ulej? Jab'xon̈ej maj on̈ ac'b'at d'a yol sc'ab' chucal. Q'uinaloc ay junoc vin̈ ix vay yed' ix, uujn̈ej am val tz'och co mul, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Yuj chi', ix yalan vin̈ rey chi' d'a masanil chon̈ab': —Tato ay junoc mach stzuntzan jun vin̈ vinac tic, ma ix yetb'eyum vin̈, ol miljocchamoc, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","D'a jun ab'il chi' ix avvi trigo vin̈aj Isaac d'a jun lugar chi'. Lajun̈e' quintal trigo ix yic' vin̈ d'a junjun almul in̈at, yujto ix yac' val svach'c'olal Jehová d'a yib'an̈ vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Yuj chi' man̈ jantacoc ix aj sb'eyumal vin̈. Man̈ jantacoc tas ix yic' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ix te aj noc' scalnel vin̈, noc' svacax vin̈ yed' schecab' vin̈. Yuj val chi' ix te chichon sc'ol eb' vin̈ filisteo chi' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ayic pitzanto vin̈aj Abraham smam vin̈aj Isaac chi', ix sjoyancan juntzan̈ uc'b'ila' eb' schecab' vin̈ b'aj syuc'a' noc' smolb'etzal noc' chi'. Axo eb' vin̈ filisteo chi' ix b'ud'anxi juntzan̈ uc'b'ila' chi'. ");
INSERT INTO cac_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ix yalan vin̈ rey chi' d'a vin̈aj Isaac chi': —Elan̈ d'a tic, yujto ix a te iq'uej ipoc d'a quib'an̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ix lajvi chi', ix b'at vin̈aj Isaac chi', ix c'och cajan vin̈ d'a sch'olanil yic Gerar. Ata' ix cajnaj vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ix sjoyanxi juntzan̈ a' uc'b'ila' chi' vin̈, a' b'ob'ilcan yuj vin̈ smam vin̈ chi', aton juntzan̈ a' ix smuc eb' vin̈ filisteo ayic toxo ix cham vin̈ smam vin̈ chi'. A sb'i a' aycanoch yuj vin̈ smam vin̈ chi', an̈eja' ix yac'canoch vin̈ sb'ioc a'. ");
INSERT INTO cac_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ay jun c'ual, a eb' vin̈ schecab' vin̈aj Isaac chi', ipan sjoyan jun a' uc'b'ila' eb' vin̈ d'a ac'lic chi', axo ix aji, ix ilchaj jun sjaj a' yuj eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Axo juntzan̈xo eb' vin̈ tan̈vum calnel aj Gerar chi', ix yal eb' vin̈ to yic jun a' chi' eb' vin̈, yuj chi' ix yac' oval eb' vin̈ yed' eb' vin̈ stan̈vumal scalnel vin̈aj Isaac chi'. Yuj chi' ix yac' sb'iej jun a' chi' vin̈aj Isaac Chaclajb'ail, yujto ix schaclaj sb'a eb' vin̈ yuj a'. ");
INSERT INTO cac_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ix lajvi chi', ix sjoyan junxo a' eb' vin̈ schecab' vin̈aj Isaac chi'. An̈eja' ix schaclajxi sb'a eb' vin̈ yuj a'. Yuj chi' Ajc'olal ix sb'iejcan a' yuj vin̈aj Isaac chi'. ");
INSERT INTO cac_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ichato chi' ix b'at cajnaj vin̈aj Isaac chi' d'a najat. Ata' ix sjoyxi junxo a' uc'b'ila' vin̈, palta man̈xalaj oval yuj a', yuj chi' B'ecan ix sb'iejcan a' yuj vin̈. B'ecan on̈ yuj Jehová yic tzon̈ q'uib'chaan̈ d'a lum tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ix lajvi yel vin̈aj Isaac chi' ta', ix c'och vin̈ d'a Beerseba. ");
INSERT INTO cac_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","A d'a jun ac'val chi', ix sch'ox sb'a Jehová d'a vin̈, ix yalani: A in sDiosal in vin̈ a mam aj Abraham. Man ach xivoc, ayin och ed'oc. Yujn̈ej to in checab' vin̈aj Abraham chi', yuj chi' ol vac' in vach'c'olal d'a ib'an̈, man̈ jantacoc ol aj vic'anchaan̈ sb'isul in̈tilal, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ata' ix sb'o jun altar vin̈aj Isaac chi', yic syal sb'a vin̈ d'a Jehová, axo scajnajcan vin̈ chi' ta'. Axo eb' schecab' vin̈ ix joyan junxo a' uc'b'ila' chi'. ");
INSERT INTO cac_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ay jun c'ual ix cot vin̈aj rey Abimelec d'a Gerar, ajun jun vin̈ yamigo vin̈ scuch Ahuzat yed'nac. Ajun pax vin̈aj Ficol yajal eb' soldado vin̈ yed'nac. Ix ulec' vin̈ lolonel yed' vin̈aj Isaac chi'. ");
INSERT INTO cac_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ix yalan vin̈aj Isaac chi' d'a eb' vin̈: —A ex tic, malaj tzin och eyuuj, ix in e pechel d'a sat e luum chi', ¿tasto yuj tzul in eyila'? xchi vin̈ d'a eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ix tac'vi eb' vin̈ d'a vin̈: —Toxo ix quila' to ayoch Jehová ed'oc, yuj chi' ix co na' to smoj sco b'o junoc co trato ed'oc. A jun trato ol co b'o chi', aton jun tic: ");
INSERT INTO cac_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Malajocab' b'aq'uin̈ tzon̈ ixtej, yujto a on̈ tic, maj cac' chucal d'ayach, a tas ix aji, to xajan ach cuuj, d'a junc'olalil ix ach co chequeli. Squila' to ayn̈ej svach'c'olal Jehová d'a ib'an̈, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ayic ix lajvi slolon eb', ix sb'oan jun nivan vael vin̈aj Isaac chi', ix va eb' d'a tzalajc'olal. ");
INSERT INTO cac_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","A d'a junxo c'u, ix q'ue van eb' d'a q'uin̈ib'alil, ix yac'lancan sti' eb' d'ay junjun. Ix lajvi chi' ix stac'lancan sb'a eb' d'a junc'olal, ix paxb'at eb' d'a slugar. ");
INSERT INTO cac_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Axo d'a jun c'u chi', ix ja eb' schecab' vin̈aj Isaac chi', ix ul yalan eb' d'a vin̈ to a d'a jun jul joyb'ilcan yuj eb' vin̈, ayxo a a' d'a yool. ");
INSERT INTO cac_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Yuj chi' Seba ix sb'iejcan jun a' uc'b'ila' chi' yuj vin̈aj Isaac chi', yuj chi' a jun chon̈ab' ay chi' ta' an̈eja' scuch Beerseba. ");
INSERT INTO cac_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","40 ab'il sq'uinal vin̈aj Esaú ayic ix yic'lan sb'a vin̈ yed' ix Judit, yisil vin̈aj Beeri hitita. Ix yic'anpax ix Basemat vin̈, yisil ix vin̈aj Elón, hitita paxi. ");
INSERT INTO cac_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ix ac'jioch scusc'olal vin̈aj Isaac yed' ix Rebeca yuj eb' ix chavan̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ix ec'n̈ej tiempo, ix ichamvinacax vin̈aj Isaac chi', maxtzac ujilaj yilan vin̈. Ay jun c'ual ix yavtejcot vin̈aj Esaú vin̈, aton vin̈ sb'ab'el yuninal vin̈, ix yalan vin̈ d'a vin̈: —Ach vuninal, xchi vin̈. —¿Tas xchi mamin? xchi vin̈aj Esaú chi'. ");
INSERT INTO cac_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","—Tic val tzila' te icham vinac inxo. Man̈ vojtacoc, q'uinaloc sja lemnaj in chamel q'uic'an chab'ej. ");
INSERT INTO cac_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Yuj chi' tzin nib'ej tzach b'at a say junoc noc' d'a caltac te' yic tzic'cot in chi'a. Ic'b'at a jul-lab' yic tza jul junoc vico'. ");
INSERT INTO cac_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Tza b'oan junoc in vael te vach', icha val in gana. Ayic toxo ix b'oi, tzic'ancot d'ayin. Yacb'an tzin va'i, ol valancan vach' lolonel d'a ib'an̈ yacb'an manto in chamoc, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Axo ix Rebeca, ix yab' ix tas ix yal vin̈ d'a vin̈aj Esaú chi', yuj chi' ayic toxo ix b'at vin̈aj Esaú chi' d'a caltac te' say schib'ej smam chi', ");
INSERT INTO cac_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ix yalan ix d'a vin̈aj Jacob, vin̈ schab'il yune' ix: —A ticnaic ach vune', ix vab' val yalan vin̈ a mam d'a vin̈ uc'tac aj Esaú icha tic: ");
INSERT INTO cac_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Ixic say junoc c'ultaquil noc' in chi'a, tza b'oan junoc in vael, te vach' tzutej. Yacb'an tzin va'i ol vac'ancan yaxilal d'ayach, ol valancan vach' lolonel d'a ib'an̈ d'a yichan̈ Jehová yacb'an manto in chamoc, xchi vin̈ a mam chi' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Yuj chi' ach vune', c'anab'ajej val tas ol val tic. ");
INSERT INTO cac_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ixic b'aj ay noc' calnel, tzic'ancot chavan̈oc noc' yunetac chiva te vach', ol in b'oan junoc svael vin̈ a mam chi', te vach' ol vutej icha val tas snib'ej vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","A achxo ol ic'b'at d'a vin̈. Ayic van sva vin̈, ol yalancan vach' lolonel vin̈ d'a ib'an̈ yacb'an manto cham vin̈, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ix yalan vin̈aj Jacob d'a ix snun chi': —A vin̈ vuc'tac chi', ay xil snivanil vin̈, palta a in tic malaj in xiil. ");
INSERT INTO cac_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Q'uinaloc ol in smaslej vin̈ in mam chi', ol nachajel yuj vin̈, ol snaan vin̈ to ton̈ej svixtej vin̈, axo catab' ol cotcan d'a vib'an̈, man̈xooc yaxilal ol vic'cani, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ix tac'vi ix snun vin̈ chi' icha tic: —Maay ach vune', tato ay catab' syalcan vin̈, aocab' d'a vib'an̈ scotcani. A ticnaic, an̈ej to tza c'anab'ajej tas svala'. Ixic, ic'cot chavan̈oc noc' yunetac chiva chi', xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ix b'at vin̈aj Jacob chi' yic'cot noc' yunetac chiva chi', ix yac'an noc' vin̈ d'a ix snun chi'. Vach' ix aj jun vael chi' yuj ix, icha val snib'ej vin̈aj Isaac chi'. ");
INSERT INTO cac_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ix lajvi chi', ix yic'anelta spichul vin̈aj Esaú chi' ix, vin̈ sb'ab'el yune' ix, juntzan̈ pichul te vach', sic'b'ilb'at b'aj ay smantiado, ix yac'anoch ix d'a vin̈aj Jacob vin̈ schab'il unin chi'. ");
INSERT INTO cac_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Axo d'a stz'umal noc' chiva chi' ix spich sc'ab' vin̈ ix yed' sjaj vin̈ b'aj malaj xiil. ");
INSERT INTO cac_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ix yac'an ixim pan ix yed' vael ix sb'o chi', ix yic'anb'at vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Axo ix ochb'at vin̈ b'aj ayec' vin̈ smam chi', ix yalan vin̈ icha tic: —Mamin, xchi vin̈. —Oy, ¿mach ach ach vuninal? xchi vin̈aj Isaac chi'. ");
INSERT INTO cac_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","—A in Esaú in, a b'ab'el unin in. Toxo ix in b'o a vael icha ix al d'ayin. Q'uean̈ c'ojan, va'an̈. Ab'lej val jab'oc noc' c'ultaquil noc' ix b'at in jul tic, tzalancan vach' lolonel d'a vib'an̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ix sc'anb'an vin̈aj Isaac chi' d'a vin̈ icha tic: —¿Tas val ix utej yamchaj noc' d'a elan̈chamel, ach vuninal? xchi vin̈. —A Jehová co Diosal ix och ved'oc, yuj chi' d'a elan̈chamel ix ilchaj noc' vuuj, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ix yalanpax vin̈aj Isaac chi' d'a vin̈ icha tic: —Nitzcot a b'a d'a in tz'ey, ol ach in maslej, ta yel a ach ach vuninal Esaú, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ix snitzanoch sb'a vin̈ d'a stz'ey vin̈ smam chi', ix och ijan vin̈ smaslan vin̈ tato ay xiil vin̈. Ix lajvi chi', ix yalan vin̈ smam vin̈ chi' icha tic: Icha val yoch sjaj vin̈aj Jacob svab'i, an̈ej jun to ay xil a c'ab' svab'i icha val yic vin̈aj Esaú, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Maj nachajel-laj yuj vin̈ smam vin̈ chi', yujto ay xiil sc'ab' vin̈ icha val yic vin̈aj Esaú chi', yuj chi' ix yalancan vach' lolonel vin̈ d'a yib'an̈ vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ix sc'anb'anxi vin̈aj Isaac chi' icha tic: —¿Yel am val a ach, ach vuninal Esaú? xchi vin̈. —I', a in ton Esaú in, xchi vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","—Ach vuninal, ic'cot in vael chi' an, yacb'an tzin chi noc' c'ultaquil noc' xid' ic'cot chi', ol valancan vach' lolonel d'a ib'an̈, xchi vin̈. Ix yac'an vin̈aj Jacob svael vin̈ smam chi', ix yic'anpaxcot vino vin̈, ix yuc'an vin̈ smam vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ix yalan vin̈aj Isaac chi' icha tic: —Nitzcot a b'a d'a in tz'ey ach vuninal, tza tz'ub'anelta in ti', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ix snitzanb'at sb'a vin̈aj Jacob chi', ix tz'ub'anelta sti' vin̈ smam vin̈ chi'. Ix suc'lan spichul vin̈ vin̈aj Isaac chi', ix yalan vach' lolonel chi' vin̈ d'a yib'an̈ vin̈ icha tic: Icha sjab' an̈ an̈c'ultac ay d'a caltac te' tz'ac'ji syaxil yuj Jehová, icha val chi' sjab' vin̈ vuninal. ");
INSERT INTO cac_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ac'jocab' n̈ab' d'a yib'an̈ lum a luum yuj Dios yic te vach' ol aj sat avb'en. Man̈xo jantacoc ixim trigo yed' vino ol ic'a'. ");
INSERT INTO cac_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Tzijtum anima ol ach ac'an servil. Masanil nación ol yaq'uem sb'a d'ayach. Yajal ol ach aj d'a yib'an̈ eb' yin̈tilal vin̈ uc'tac. Ol yaq'uem sb'a eb' d'ayach. Ol can scatab' Dios d'a yib'an̈ eb' chuc syutej sb'a d'ayach, palta ol yac' svach'c'olal d'a yib'an̈ eb' vach' syutej sb'a d'ayach, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Axo yic ix lajvi yalancan masanil vach' lolonel chi' vin̈ d'a yib'an̈ vin̈aj Jacob chi', ato val yelta vin̈ chi' b'aj ayec' vin̈ smam chi', ix jax vin̈aj Esaú chi' juloj noc' chi'. ");
INSERT INTO cac_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ix sb'oan jun vael vin̈ te vach'. Ix lajvi chi' ix yic'anpaxb'at vin̈ d'a vin̈ smam chi', ix yalan vin̈ icha tic: —Q'uean̈ vaan mamin, tic in javi. Chi' noc' c'ultaquil noc' ix b'at vic'cot tic, tzalancan vach' lolonel chi' d'a vib'an̈, xchi vin̈ d'a vin̈ smam chi'. ");
INSERT INTO cac_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Axo ix sc'anb'an vin̈aj Isaac chi' icha tic: —¿Mach ach? xchi vin̈. —A in ton Esaú in, a b'ab'el unin in, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ix te sat sc'ol vin̈aj Isaac chi', ix och ijan vin̈ slucloni, ix yalan vin̈ icha tic: —¿Mach pax jun vin̈ ix b'at ic'ancot noc' d'a sb'ab'elal jun, ix yic'ancot jun vael chi' d'ayin? Toxo ix in va'i, ayic manto ach ja ach tic, yuj chi' toxo ix valcan in vach' lolonel d'a yib'an̈ vin̈ chi'. Toxonton a vin̈ ol chaan in vach'c'olal chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ayic ix yab'an vin̈aj Esaú tas ix yal vin̈ smam chi', ix el veq'uec'oc yav vin̈ yoq'ui, ix yalan vin̈ icha tic: —Alpax vach' lolonel d'a vib'an̈ mamin, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ix yalan vin̈aj Isaac chi' icha tic: —A vin̈ uc'tac ix ul in ixtanoc, toxo ix yic'b'at masanil vach' lolonel vin̈ ictaxon yaji, xchi vin̈. Axo ix tac'vi vin̈aj Esaú chi': ");
INSERT INTO cac_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Te vach' val ochnaccan Jacob d'a vin̈. Schaelalxo in yixtan vin̈ tic. D'a sb'ab'elal ix yiq'uec' in derecho vin̈ d'a yic in b'ab'el uninal, axo pax ticnaic syic'anpaxec' yaxilal vin̈ to victaxon yaj uuj. Mamin, ¿man̈xom val junocxo yaxil ix a c'ub'ejcan d'ayin? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ix yalan vin̈aj Isaac chi' d'a vin̈: —Ina ix vac' yopisio vin̈aj Jacob d'a ib'an̈, masanil eb' in̈tilal ol ochcan schecab'oc vin̈. An̈eja' toxo ix valcani to te vach' ol yac' ixim strigo vin̈ yed' svino. Man̈xalaj tas vach' ach vutan ach vuninal, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ix tevin̈ejoch vin̈aj Esaú chi' icha tic: —Mamin, ¿man̈xom val junoc vach' lolonel syal alancan d'a vib'an̈ jun? Alcan junocxo a vach' lolonel d'ayin, xchi vin̈. Ix elxi veq'uec'oc yav vin̈ yoq'ui. ");
INSERT INTO cac_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Yuj chi' ix yalan vin̈aj Isaac chi' d'a vin̈ icha tic: Te najat tzach elcan d'a sat lum luum yax sat yed' b'aj syac' n̈ab'. ");
INSERT INTO cac_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","An̈ej q'uen espada ol ac'och yipoc a c'ool, checab' ol ach ajcan d'a vin̈ uc'tac chi'. Axo yic ayxo ip jun, ol a col a b'a d'a vin̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Atax ta' ix chichoncanoch sc'ool vin̈aj Esaú d'a vin̈aj Jacob chi' yuj tas ix alchajcan d'a yib'an̈ vin̈ yuj smam chi'. Yuj chi' ix snaan vin̈aj Esaú chi' icha tic: Toxo ol cham vin̈ in mam tic, ol lajvoc chi' ol in milancham jun vuc'tac chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Axo yic ix yab'an ix Rebeca tas van yalan vin̈aj Esaú chi', ix yavtancot vin̈aj Jacob chi' ix, ix yalan ix d'a vin̈ icha tic: —Ach vune', a vin̈aj Esaú vin̈ uc'tac, sgana vin̈ ol ach smilchamoc yic syaq'uec' spac vin̈ d'ayach. ");
INSERT INTO cac_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Yuj val chi', ab' val tas svala': Elan̈ d'a tic, tzach b'atcan d'a Harán, tzach aj yed' vin̈aj Labán vin̈ in nulej. ");
INSERT INTO cac_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Tzach cann̈ej yed' vin̈ junoc tiempoal masanto tz'ec' yoval sc'ool vin̈ uc'tac tic. ");
INSERT INTO cac_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Axo yic ol sat d'a sc'ol vin̈, ol valanb'at ab'i, ichato chi' ol ach paxta. Max yal in c'ool to junn̈ej c'ual tzex cham e chavan̈il, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ix lajvi chi', ix yalan ix Rebeca d'a vin̈aj Isaac icha tic: —Tzin te cus yuj eb' ix hitita, eb' ix yetb'eyum vin̈aj Esaú tic. Yuj chi' tato syic'laj sb'a vin̈aj Jacob tic yed' junoc eb' ix hitita cajan d'a Canaán tic, vach' ama tato tzin chami, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Yuj chi' ix avtajcot vin̈aj Jacob yuj vin̈aj Isaac chi', ix och ijan vin̈ yalancan vach' lolonel d'a yib'an̈ vin̈, ix yalancan jun checnab'il vin̈ d'a vin̈ icha tic: Malaj b'aq'uin̈ ol ic' junoc ix etb'eyum d'a scal eb' ix aj Canaán tic. ");
INSERT INTO cac_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","A d'a yol yic Padán-aram d'a spat vin̈ a mam icham aj Betuel tzach b'ati, tzic' a b'a yed' junoc eb' ix yisil vin̈aj Labán, snulej ix a nun. ");
INSERT INTO cac_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Axo Dios Syal Yuj Masanil, ol yac' svach'c'olal d'a ib'an̈, man̈ jantacoc ol aj sb'isul in̈tilal. A d'a scal eb' in̈tilal chi' tzijtum nación ol pitzvoc. ");
INSERT INTO cac_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ol yac' svach'c'olal Dios d'ayach yed' masanil eb' in̈tilal icha ix aj yac'ancan sti' yac'an d'a vin̈aj Abraham vin̈ co mam, yic vach' ol och jun luum b'aj ayon̈ ec' tic icoc. A val Dios chi' aljinaccan d'a vin̈ co mam chi', xchi vin̈aj Isaac d'a vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ix lajvi chi', ix checchajcanb'at vin̈aj Jacob yuj vin̈aj Isaac d'a Padán-aram. Ix b'atcan vin̈ d'a spat vin̈aj Labán, yuninal vin̈aj Betuel arameo, snulej ix Rebeca, ix snun vin̈ yed' vin̈aj Esaú. ");
INSERT INTO cac_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Axo ix yab'an vin̈aj Esaú to ix yal vach' lolonel vin̈aj Isaac d'a yib'an̈ vin̈aj Jacob, ix schecanpaxb'at vin̈ d'a Padán-aram yic tz'och ix yetb'eyum vin̈ ta'. Ix yab'an vin̈ to ayic ix yalan vach' lolonel vin̈aj Isaac chi' d'a vin̈, ix yalan vin̈ to max yal yic'lan sb'a vin̈ yed' eb' ix aj Canaán chi'. ");
INSERT INTO cac_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ix sc'anab'ajej vin̈aj Jacob sb'atcan d'a Padán-aram icha ix aj yalan vin̈ smam yed' ix snun. ");
INSERT INTO cac_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Icha chi' ix aj snachajel yuj vin̈aj Esaú to a vin̈ smam vin̈ chi' max scha sc'ol eb' ix aj Canaán vin̈. ");
INSERT INTO cac_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Yuj chi', ix b'at vin̈ yil vin̈aj Ismael aton vin̈ yuc'tac vin̈ smam vin̈ chi'. Ix yic'an jun ix yisil vin̈aj Ismael chi' vin̈, Mahalat sb'i ix, ix och ix yetb'eyumoc vin̈ yed' eb' ix aytaxoneq'ui. A ix Mahalat chi' ay jun vin̈ snulej ix scuchan Nebaiot. ");
INSERT INTO cac_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ayic ix el vin̈aj Jacob d'a Beerseba, ix b'at vin̈ d'a sb'eal Harán. ");
INSERT INTO cac_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ix c'och vin̈ d'a jun lugar, yujto toxo ix em c'u, yuj chi' ata' ix vaycan vin̈ d'a jun ac'val chi'. Ayic toxo svay vin̈, ix yic'ancot jun q'ueen vin̈ sc'an̈ jolomoc, ix ec' jichan vin̈. ");
INSERT INTO cac_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","A d'a jun ac'val chi', ix och jun svayich vin̈, ix yilan vin̈ to ay jun b'e icha c'ooch. Schaq'ue d'a sat lum tic, masanto sq'uec'och d'a satchaan̈. Ix yilan vin̈ to a eb' yángel Dios sq'uei, tz'emta eb' d'a jun b'e chi'. ");
INSERT INTO cac_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ix yilanpax vin̈ to a Jehová lin̈anec' b'aj sq'uec'och jun b'e chi', ix yalan icha tic: A in ton Jehová sDiosal in vin̈ a mam icham aj Abraham yed' vin̈aj Isaac a mam. Ol vac' jun lum b'aj jichan ach ec' tic d'ayach yed' d'a masanil eb' in̈tilal. ");
INSERT INTO cac_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","A in̈tilal chi' man̈ jantacoc ol aj sb'isul icha spococal lum luum. Ol pucaxcanb'at eb' d'a stojolal b'aj sjavi c'u yed' b'aj tz'em c'u, d'a stojolal norte yed' d'a sur. Masanil nación d'a yolyib'an̈q'uinal tic, ol scha svach'ilal eb' uuj yed' pax yuj in̈tilal. ");
INSERT INTO cac_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ayinn̈ej och ed'oc, ol ach in tan̈vejn̈ej b'aj ol ach b'atoc, ol ach vic'an meltzaj d'a jun lum tic junelxo. Man̈ ol ach vactejcanlaj, palta ol vaq'uelc'och b'aj ix vac' in ti' d'ayach, xchi. ");
INSERT INTO cac_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ayic ix el svayan̈ vin̈, ix snaan vin̈ icha tic: D'a val yel ayec' Jehová d'a jun lugar tic, man̈ vojtacoclaj, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ix xiv chaan̈ vin̈, ix snaan vin̈: Te ay smay jun lugar tic, spat Dios yaji, spuertail pax satchan̈ yaji, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ayic ix sacb'i d'a junxo c'u, ix pet q'ue vaan vin̈, ix yic'ancot q'uen q'ueen ix yac'och vin̈ sc'an̈ jolomoc chi, ix yac'ancanq'ue lin̈an q'uen vin̈, ix can q'uen yecheloc, ix secanq'ue aceite vin̈ d'a yib'an̈ q'ueen. ");
INSERT INTO cac_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","A d'a jun lugar chi', ata' ay jun chon̈ab' yictax peca', Luz sb'i, axo vin̈aj Jacob ix q'uexan sb'i, ix yac'an vin̈ scuch Betel. ");
INSERT INTO cac_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ata' ix yac'can sti' vin̈aj Jacob, ix yalan vin̈ icha tic: Tato a Dios ol in tan̈vanoc, ol ochn̈ej ved'oc b'aj van in b'at tic, ol yac'n̈ej in vael yed' in pichul, ");
INSERT INTO cac_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","vach' in c'ool ayic ol in meltzajpaxcot d'a spat in mam, tato icha chi' a Jehová tic ol och in Diosaloc. ");
INSERT INTO cac_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","A b'aj ix vavejcan q'uen q'ueen tic, icha spat Dios tz'ajcani, ol viq'uel sdiezmoal masanil tas ol yac' d'ayin, ol vac'an d'ay, xchi vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Icha chi' ix aj sb'atcan vin̈aj Jacob, ix c'ochcan vin̈ d'a slum eb' vin̈ cajan d'a stojolal b'aj sjavi c'u. ");
INSERT INTO cac_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ayic ix c'och vin̈ ta', ix yilanb'at jun a' uc'b'ila' vin̈. A d'a slac'anil a' chi', ayec' ox uman̈ noc' calnel, yujto a a' syuc' noc', ay jun nivan q'uen ayoch smaculoc sti' a'. ");
INSERT INTO cac_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ayic smolb'an sb'a masanil noc' calnel chi' ta', axo eb' vin̈ stan̈van noc' tz'ic'anel q'uen smacul sti' a' chi', syac'an a' eb' vin̈ yuc' noc', slajvi chi' smacanxican sti' a' eb'. ");
INSERT INTO cac_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ix sc'anb'an vin̈ d'a eb' tan̈vum calnel chi' icha tic: —¿B'ajtil ayex ex vetanimail? xchi vin̈. —A d'a Harán ayon̈, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","—¿Eyojtac am vin̈aj Labán yixchiquin vin̈aj Nacor? xchi vin̈. —Cojtacton vin̈, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","—¿Vach' am sc'ol vin̈ eyila'? xchi vin̈. —Vach' sc'ol vin̈. Ina a ix Raquel yisil vin̈ van scot yed' noc' scalnel chi', xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ix yalan vin̈aj Jacob chi' d'a eb' vin̈: —Ayto c'u, ¿tas yuj man̈ ton̈ejoc tzeyac' yuc'a' noc' e calnel tic, tze tan̈van va jab'ocxo noc'? xchi vin̈ d'a eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ix yalan eb' vin̈: —Max yal-laj, yovalil sco tan̈vej smolb'an sb'a noc' smasanil, ichato chi' ol quic'anel q'uen nivan smacul sti' a' tic, yic syal yuc'an a' noc' smasanil, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Vanto slolon vin̈aj Jacob chi' yed' eb' vin̈, ix ja ix Raquel yed' noc' yic vin̈ smam, yujto a ix stan̈van noc'. ");
INSERT INTO cac_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ayic ix yilan vin̈ sja ix yed' noc' yic vin̈ smam chi', aton vin̈ snulej ix snun vin̈, elan̈chamel ix b'at lemnaj vin̈, ix yic'anel q'uen smacul sti' a a' chi' vin̈, ix yac'an yuc' a' noc' calnel chi' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","D'a elan̈chamel ix yac'an stzatzil sc'ol ix Raquel chi' vin̈, ix tz'ub'elta sti' ix vin̈, ix oc'q'ue vin̈. ");
INSERT INTO cac_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ix och ijan vin̈ yalan icha tic: Yune' in ix Rebeca, ix yanab' vin̈ a mam, xchi vin̈. Axo ix yab'an ix Raquel icha chi', ix b'at lemnaj ix yal d'a vin̈ smam chi'. ");
INSERT INTO cac_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Axo ix yab'an vin̈aj Labán sb'inaj vin̈aj Jacob yune' yanab', ix b'at lemnaj vin̈ schacot vin̈. Ix och lac'naj vin̈ d'a vin̈, ix tz'ub'anelta sti' vin̈, ix yic'anb'at vin̈ vin̈ d'a spat chi'. Ix och ijan vin̈aj Jacob chi' yalani tas ix aj scoti. ");
INSERT INTO cac_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ix yalan vin̈aj Labán chi' d'a vin̈ icha tic: Val yel te a on̈to och ed'oc, xchi vin̈. Jun ujal ix can vin̈ yed' vin̈aj Labán chi'. ");
INSERT INTO cac_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ayic ix ec' jun uj chi', ix yalan vin̈aj Labán chi' d'a vin̈ icha tic: —A ticnaic vach'chom ayto cuj co b'a, palta max yal-laj nab'an̈ej ol ach munlaj d'ayin. Al d'ayin jantac ol ach in tupu', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ay chavan̈ yisil vin̈aj Labán chi': A ix b'ab'el, Lea sb'i ix, axo ix schab'il Raquel. ");
INSERT INTO cac_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","A ix Lea chi', icha yilji taxon eb' ix ix yilji ix, an̈ej yol sat ix vach' yilji. Axo pax ix Raquel jun, te vach' yilji sat ix yed' snivanil smasanil. ");
INSERT INTO cac_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Axo vin̈aj Jacob chi', ix can sgana vin̈ d'a ix Raquel chi', yuj chi' ix yal vin̈ icha tic: —Tzin can uqueoc ab'il in caj ix Raquel, ix chab'il isil tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ix yalan vin̈aj Labán chi': —Canan̈, vach' ol vac' ix d'ayach, ¿tas gana ch'oc b'aj svac' ix? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Icha chi' ix aj scajan uque' ab'il ix vin̈. Maj yab' vin̈ yec' jun tiempoal chi', yujto te ay sgana vin̈ d'a ix. ");
INSERT INTO cac_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Axo yic ix ec' uque' ab'il chi', ix yalan vin̈ d'a vin̈aj Labán chi' icha tic: —A ticnaic, ix lajvi co trato yic tzin caj ix. Ac' ix vetb'eyumoc yic svic'an in b'a yed' ix, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Axo vin̈aj Labán chi' ix avtancot masanil eb' cajan d'a slac'anil chi', ix yac'anoch sq'uin̈al snupnajel ix yisil vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ayic toxo ix q'ue ac'val ix yic'ancot ix Lea vin̈aj Labán d'a vin̈aj Jacob chi', ix vay vin̈ yed' ix. ");
INSERT INTO cac_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ix ac'ji jun scriada ix yuj vin̈aj Labán chi', a ix chi' Zilpa sb'i ix. ");
INSERT INTO cac_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ayic ix sacb'i, ix yilanelta vin̈aj Jacob chi' to a ix Lea ix vay yed' vin̈, ix b'at yalan vin̈ d'a vin̈aj Labán chi' icha tic: —¿Tas yuj icha tic ix in utej? A ix Raquel ix in caj d'ayach, ¿tas yuj tzin ixtej? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ix yalan vin̈aj Labán chi' d'a vin̈ icha tic: —A co b'eyb'al d'a co cal tic, max yal-laj to a ix tzac'anto sb'ab'laj och vin̈ yetb'eyum d'a ix b'ab'el. ");
INSERT INTO cac_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","C'anab'ajejcan jun semana sq'uin̈ nupnajel yic ix Lea tic, ol ic'anpax ix Raquel chi' tato tzac' a ti' a cajan uqueocxo ab'il ix d'ayin, xchi vin̈aj Labán chi'. ");
INSERT INTO cac_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ix schaan sc'ol vin̈aj Jacob jun lolonel chi'. Ix sc'anab'ajan jun semana q'uin̈ nupnajel vin̈ yed' ix Lea chi'. Ix lajvi chi', ix yac'anpax ix Raquel vin̈aj Labán chi' yic tz'och ix yetb'eyumoc vin̈. ");
INSERT INTO cac_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ix yac'anpax jun ix scriada ix Raquel chi' vin̈ aton ix Bilha. ");
INSERT INTO cac_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ix yic'lan sb'a vin̈aj Jacob yed' ix Raquel chi', yelxo val xajanab'il ix aj ix yuj vin̈ d'a yichan̈ ix Lea chi'. Yuj chi' uqueto ab'il ix scaj ix vin̈. ");
INSERT INTO cac_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ayic ix yilan Jehová to chab'c'olab'il ix Lea chi', ix yac'an svach'c'olal d'a yib'an̈ ix yic tz'aj yune' ix. Axo pax ix Raquel, malaj yune' ix. ");
INSERT INTO cac_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Axo ix Lea chi', ix och ix yab'ixal, ix alji jun yune' ix, Rubén ix yac' ix sb'iej, ix yalan ix: A Jehová ix yila' to paticab'il in el yuj vin̈ vetb'eyum, axo ticnaic xajan ol in yil vin̈, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ix lajvi chi' ix alji junxo yune' ix, Simeón ix yac' ix sb'iej, ix yalan ix icha tic: Ix yab' Jehová to chab'c'olab'il vaji, yuj chi' ix yac' junxo vune' tic, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ix aljipax junxo yune' ix, Leví ix yac' ix sb'iej, ix yalan ix: A ticnaic junxon̈ej ol aj vin̈ vetb'eyum tic ved'oc, yujto oxvan̈xo vune' yed' vin̈, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ix alji junxo yune' ix, Judá ix yac' ix sb'iej, ix yalanpax ix: A ticnaic, svic'chaan̈ sb'i Jehová, xchi ix. Axon̈ej chi', ix och vaan yilan sat unin ix. ");
INSERT INTO cac_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Axo ix Raquel chi' ix pitzvichaan̈ ajc'olal d'a spensar ix, ix och ix ajc'olal d'a ix Lea chi' yujto malaj yune' ix, ix yalan ix d'a vin̈ yetb'eyum chi' icha tic: —Ac' vune'. Tato maay, tic tzin chami, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yuj chi' ix cot yoval vin̈aj Jacob, ix yalan vin̈ d'a ix icha tic: —¿Tocval Dios in? A Dios chi' max ac'anlaj une' chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ix yalanxi ix d'a vin̈: —Vayan̈ yed' ix in criada Bilha, ayic ol aljoc yune' ix chi', icha val vune' ol ajoc, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ix yac'an ix scriada ix chi' d'a vin̈, ix yic'lan sb'a vin̈ yed' ix. ");
INSERT INTO cac_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Axo ix alji jun yune' ix Bilha chi', ");
INSERT INTO cac_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ix yalan ix Raquel icha tic: Dan ol sb'iej vin̈ unin tic, yujto ix yab' in lesal Dios, ix in sch'olb'itani, yuj chi' ix yac' jun unin tic d'ayin, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ix lajvi chi', ix alji junxo yune' ix Bilha yed' vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ix yalanxi ix Raquel chi': A jun unin tic Neftalí ol sb'iej, yujto ix in telaj in b'a yed' ix in nulej ix Lea, axo ticnaic ix can ix yalan̈ vuuj, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Axo yic ix yilan ix Lea to man̈xalaj yune' ix, ix yac'anpax ix scriada ix, aton ix Zilpa d'a vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ix alji jun yune' ix yed' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","—Vach' vico' yuj chi' Gad svac' sb'iej vin̈ unin tic, xchi ix Lea chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ix lajvi chi', ix alji junxo yune' ix Zilpa chi' yed' vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ix yalanpax ix Lea chi' icha tic: Te tzalajc'olal vico', axo eb' ix vetixal ol alanoc to ay in tzalajc'olal, yuj chi' Aser ol sb'iej vin̈ unin tic, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ay jun c'u ix b'at vin̈aj Rubén b'eyelec' d'a caltac te', ayic van sjochchaj ixim trigo. Ata' ix ilchaj juntzan̈ sat an̈c'ultac yuj vin̈ to sloji, mandrágora sb'i. Ix yic'anb'at an̈ vin̈ d'a ix Lea, aton ix snun vin̈. Axo yic ix yilan an̈ ix Raquel chi', ix yalan ix d'a ix Lea icha tic: —Tzin tevi d'ayach to tzac' junoc an̈ mandrágora ix yic'cot vin̈ une' chi' d'ayin, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ix yalan ix Lea chi' icha tic d'a ix: —¿Tom man̈ c'ocb'iloc ix iq'uec' vin̈ vetb'eyum, axo ticnaic, snib'ej a c'ol tza c'anec' an̈ mandrágora ix yic'cot vin̈ vune' tic? xchi ix. —Ac' an̈ d'ayin, tato icha chi' syal svay vin̈aj Jacob ed'oc d'a jun ac'val tic, xchi ix Raquel chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Axo yic van sq'uic'b'i ix jax vin̈aj Jacob d'a smunlajel, ix b'at ix Lea schacot vin̈, ix yalan ix d'a vin̈ icha tic: —A ticnaic ol ach vay ved'oc, d'a val yel ix vac' an̈ mandrágora ix yic'cot vin̈ vune' d'a ix in nulej ix Raquel a tojoloc, xchi ix. Yuj chi' ix vay vin̈aj Jacob chi' yed' ix d'a jun ac'val chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","A Dios ix ab'an slesal ix, yuj chi' ix alji junxo yune' ix yed' vin̈, yoil uninxo. ");
INSERT INTO cac_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ix yalan ix: Isacar ol sb'iej vin̈ unin tic, yujto ix spactzitej Dios d'ayin, yujto ix vac' ix in criada d'a vin̈ vetb'eyum, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ix lajvi chi', ix alji junxo yune' ix yed' vin̈aj Jacob chi', aton svaquil unin eb'. ");
INSERT INTO cac_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ix yalan ix: Ix yac' Dios jun silab' man̈xo jantacoc svach'il d'ayin, yuj chi' ol in sxajanej vin̈ vetb'eyum tic. Svaquilxo jun unin tic svil yed' vin̈, yuj chi' Zabulón ol sb'iej, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Yicxo slajvub'al ix yilan sat jun ix unin ix, Dina ix yac' ix sb'iej. ");
INSERT INTO cac_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Axo ix Raquel chi', ix nachajcot ix yuj Dios, ix ab'ji slesal ix yuuj, ix javi yune' ix. ");
INSERT INTO cac_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ayic ix alji jun sb'ab'el unin ix, ix yalan ix: A in q'uixvelal, toxo ix yiq'uel Jehová, yujto toxo ix yac' jun vune' tic. ");
INSERT INTO cac_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Tzoc val el d'a sc'ool syac'pax junocxo vune', xchi ix. Yuj chi' José ix sb'iej jun unin chi' yuj ix. ");
INSERT INTO cac_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ayic toxo ix alji vin̈aj José, ix yalan vin̈aj Jacob d'a vin̈aj Labán icha tic: —A ticnaic, cha in pax d'a in chon̈ab'. ");
INSERT INTO cac_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ac' eb' vuninal yed' eb' ix vetb'eyum, c'ocb'ilocxob' in cajan eb' ix d'ayach, smojxo val tzin paxi. Ojtac val tas ix aj in munlaj d'ayach, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Axo ix yalan vin̈aj Labán chi' d'a vin̈ icha tic: —Maay, tzin tevi d'ayach to vach'n̈ej ajec' ved'oc, yujto ix in naeli to uujn̈ej ay svach'c'olal Jehová d'a vib'an̈. ");
INSERT INTO cac_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Al d'ayin jantac val tzach in tupu', xchi vin̈aj Labán chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ix yalanxi vin̈aj Jacob chi': —Ojtac val tas ix aj in munlaj ed'oc yed' tas ix aj vilan noc' a molb'etzal noc' tic. ");
INSERT INTO cac_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ojtac to jayvan̈n̈ej noc' a molb'etzal noc' tic ayic in janac, axo ticnaic toxo ix q'uib' sb'isul noc'. Atax val yic in janac chi' syamannacoch Jehová yac'an svach'c'olal d'a ib'an̈. Axo ticnaic, ¿b'aq'uin̈ ol in chael yich vilan vic yed' eb' ix vetb'eyum tic yed' eb' vuninal? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","—¿Jantac a tojol tza c'ana'? xchi vin̈aj Labán chi'. —Malajocab' in tojol tzac'a', an̈ejto svil jab'ocxo noc' a calnel tic, tato ol scha a c'ol tas ol vala'. ");
INSERT INTO cac_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Cha in och d'a scal noc' a calnel yed' noc' a chiva ticnaic, yic tzin sic'anel masanil noc' tz'ib'iltac, noc' jasquiltac stz'ib'ul, noc' yunetac q'uiq'uic'. A noc' chi' ol och in tojoloc. ");
INSERT INTO cac_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Yuj chi' jun, ayic tzach c'och il noc' a noc' chi', noc' svic' in tojoloc chi', icha chi' ol aj ilancot in tojolal. Tato a d'a scal noc' vic chi' ay noc' chiva, ma noc' calnel chi' man̈ tz'ib'iltacoc, mato man̈ q'uiq'uic'oc, van ach velc'an syal chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","—Vach'ocab'i. Scha in c'ol tas tzal chi', xchi vin̈aj Labán chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","An̈ejtona' d'a jun c'ual chi' ix sic'anel masanil noc' mam chiva tz'ib'iltac vin̈aj Labán chi' yed' noc' jasquiltac stz'ib'ul, noc' nun chiva soman jab'oc saquil yed' masanil noc' calnel q'uiq'uic' yilji, ix yac'an noc' vin̈ d'a eb' yuninal. ");
INSERT INTO cac_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ix yic'anb'at noc' eb' yuninal vin̈ chi' d'a najat, oxe' c'ual stec'nab'il b'aj ix can vin̈aj Jacob chi'. Ix cann̈ej vin̈ stan̈vej juntzan̈xo noc' scalnel vin̈aj Labán chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Elan̈chamel ix sna vin̈aj Jacob chi', ix stzepel sc'ab'tac te te' scuch álamo vin̈, te' almendro yed' te' castaño. Tz'ib'iltac ix yutej te' vin̈ sjosan stz'umal. Ay sac yed' q'uiq'uic' ix aj yilji te' yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Ix yac'anoch juntzan̈ te' c'ab'tac te' chi' vin̈ d'a yichan̈ noc' calnel chi', b'aj syuc'a' noc', aton ta' stajni noc'. D'a yichan̈ noc' aypaxoch te te' tz'ib'iltac yilji chi', yuj chi' ayic tz'aj yune' noc', tz'ib'iltac yilji yune' noc' chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","A masanil noc' tz'ib'iltac tz'aj chi', ix sic'canel noc' vin̈ d'a scal noc' yic vin̈aj Labán chi'. Icha chi' ix yutej vin̈ sic'anel noc' scalnel chi' d'a scal noc' yic vin̈aj Labán chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Masanil noc' te vach', ayic stajni noc', syac'anoch te te' vin̈aj Jacob chi' d'a yichan̈ noc' b'aj xid'ec' noc' yuc'a', yic vach' syil te te' chi' noc' ayic stajni noc' chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Axo yic sjavi noc' yatac val ay, max yaq'uem te te' chi' vin̈ d'a yichan̈ noc'. Yuj chi', a noc' tz'ontac yic vin̈aj Labán chi', axo noc' vach' yic vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Icha chi' ix aj yoch vin̈aj Jacob chi' b'eyumal. Man̈ jantacoc noc' svacax vin̈, noc' scalnel vin̈ yed' noc' schiva vin̈. Man̈ jantacoc noc' scamello vin̈ yed' noc' sb'uru vin̈ yed' pax eb' vin̈ schecab' vin̈ yed' eb' ix schecab' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ayic ix yab'an vin̈aj Jacob to a eb' vin̈ yuninal vin̈aj Labán, vanxo yalanq'ue eb' vin̈ icha tic: B'eyumxo vin̈aj Jacob tic yuj jantac tas ix yiq'uec' d'a vin̈ co mam, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ix nachajel yuj vin̈aj Jacob chi' to man̈xo vach'oc snaan vin̈aj Labán chi' d'a spatic icha d'a yalan̈taxo. ");
INSERT INTO cac_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Axo Jehová ix alan d'a vin̈ icha tic: Meltzajan̈ d'a slum a mam icham b'aj ayec' eb' a c'ab' oc, ol in b'atn̈ej ed'oc, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ix lajvi chi' ix yac'anb'at sti' vin̈ d'a eb' ix yetb'eyum, aton ix Raquel yed' ix Lea, yic vach' scot eb' ix, sja eb' ix b'aj stan̈vi calnel vin̈. ");
INSERT INTO cac_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ayic ix ja eb' ix, ix yalan vin̈ d'a eb' ix: —Ex vetb'eyum, a ticnaic toxo ix vila' to a vin̈ e mam, chucxolaj in yilan vin̈, man̈ ichoc d'a yalan̈taxo, palta a sDiosal vin̈ in mam, ayn̈ej val och ved'oc. ");
INSERT INTO cac_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","A ex tic eyojtac val to ix in munlaj d'a vin̈ e mam d'a svach'ilal d'a smasanil in c'ool. ");
INSERT INTO cac_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Axo vin̈ icha val to tzin yixtej vin̈, lajun̈elxo ix sq'uex in tojol vin̈, palta a Dios jun, max in xcha ixtajoc. ");
INSERT INTO cac_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ayic ix yalan vin̈ e mam chi': Ol ach in tup d'a noc' calnel, noc' tz'ib'iltac, xchi vin̈, axo yic ix alji yune' noc', nab'a tz'ib'iltac yune' noc' ix alji. Ayic ix yilan vin̈ to icha chi', ix yalanxi vin̈: A noc' jasquiltac stz'ib'ul ol vac' a tojoloc, xchi vin̈, axo ix alji yune' noc', nab'a jasquiltac stz'ib'ul noc' yune' tz'alji. ");
INSERT INTO cac_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Icha chi' ix aj yic'jiec' noc' smolb'etzal noc' vin̈ e mam chi' yuj Dios, ix yac'an d'ayin. ");
INSERT INTO cac_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","A junel ay jun in vayich, a ix vilani to van stajni noc'. Ix vilani to a noc' mam chiva ix tajni yed' noc' nunab'il chi', nab'a tz'ib'iltac noc', ay pax noc' jasquiltac stz'ib'ul. ");
INSERT INTO cac_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Axo d'a jun in vayich chi', ix in yavtej Jun yángel Dios, ix in tac'vi d'ay: Oy, ina vajec' tic, xin chi d'ay. ");
INSERT INTO cac_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ix yalan d'ayin icha tic: Scham val ilani to a noc' smam stajni yed' noc' snun, tz'ib'iltac noc', jasquiltac pax stz'ib'ul noc', yujto ix vil masanil tas ix ach utaj yuj vin̈aj Labán. ");
INSERT INTO cac_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","A in Dios in tic, ix in ch'ox in b'a d'ayach d'a Betel, b'aj ix a seccanq'ue aceite d'a yib'an̈ q'uen q'ueen ix ac'canq'ue lin̈an, aton b'aj ix ac'can a ti' d'ayin. A ticnaic, actejcan jun lugar tic, tzach pax d'a a luum b'aj aljinac ach, xchi Dios d'ayin, xchi vin̈aj Jacob chi' d'a eb' ix yetb'eyum chi'. ");
INSERT INTO cac_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ix tac'vi ix Raquel yed' ix Lea chi' d'a vin̈ icha tic: —A on̈ tic, man̈xo jab'oc tas ol quic' d'a vin̈ co mam. ");
INSERT INTO cac_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Yujto icha comon anima caj d'a vin̈. Ina ix on̈ schon̈el vin̈, ix slajanel co tojol chi' vin̈, aton ix ac' d'a vin̈ yic ix quic'lan co b'a ed'oc. ");
INSERT INTO cac_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","D'a val yel masanil b'eyumal ix yiq'uec' Dios d'a vin̈ co mam chi', quicxo yed' eb' cune'. Yuj chi' jun, masanil tas toxo ix yal Dios d'ayach, yic'ocab'i, xchi eb' ix. ");
INSERT INTO cac_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Ix yac'an lista sb'a vin̈aj Jacob yic spaxta vin̈ d'a Canaán b'aj ayec' cajan vin̈ smam vin̈, aton vin̈aj Isaac. Ix yac'anq'ue eb' yuninal vin̈ yed' eb' ix yetb'eyum vin̈ d'a yib'an̈ noc' camello. Ix yic'ancot masanil tastac vin̈, ix b'at vin̈ yed' masanil noc' noc' ix yic' d'a spatic smunlajel d'a Padán-aram chi'. ");
INSERT INTO cac_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Yacb'an ayb'at vin̈aj Labán chi' d'a junxo lugar joxoj calnel, axo ix Raquel ix elc'ancot sdiosal vin̈ ayoch d'a yol spat. ");
INSERT INTO cac_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","An̈eja' d'a jun tiempoal chi' ix el vin̈aj Jacob d'a elc'altac, majxo yalcan quilcob'a vin̈ d'a vin̈aj Labán arameo chi'. ");
INSERT INTO cac_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Icha chi' ix aj yic'ancot masanil tastac vin̈. D'a elan̈chamel ix ec'ta vin̈ b'aj ay a' nivan Éufrates, ix cotn̈ej vin̈ d'a yichan̈ masanto ix javi vin̈ d'a juntzan̈ tzalquixtac d'a yol yic Galaad. ");
INSERT INTO cac_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Schab'jialxo scot vin̈aj Jacob chi', ix yab'an vin̈aj Labán to ix cot vin̈. ");
INSERT INTO cac_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Axo vin̈aj Labán chi' ix ic'ancot eb' sc'ab' yoc yed'oc, ix cot eb' syam vin̈. Yicxo svac'jial chi' ix javi eb' d'a spatic vin̈ d'a juntzan̈ tzalquixtac d'a yol yic Galaad. ");
INSERT INTO cac_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","A d'a jun ac'val chi', ix sch'ox sb'a Dios d'a vin̈aj Labán chi' d'a svayich. Ix yalan Dios d'a vin̈ icha tic: Scham val a naani tas ol al d'a vin̈aj Jacob chi'. Man̈ comonoc ol ach lolonoc, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Axo d'a junxo c'u, ix yamchaj vin̈aj Jacob yuj vin̈aj Labán chi' d'a tzalquixtac d'a yol yic Galaad, d'a scampamento vin̈. Ata' ix sb'opax scampamento vin̈aj Labán chi' yed' eb' vin̈ yed'nac chi'. ");
INSERT INTO cac_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ix och ijan vin̈aj Labán chi' yalanoch d'a sat vin̈aj Jacob chi' icha tic: —¿Tas ix a c'ulej? ¿Tas yuj ix in ac'can musansatil? Elelalxon̈ej ix utej ic'ancot eb' ix visil, ichato d'a scal oval ix yamchaj eb' ix uuj. ");
INSERT INTO cac_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Majxo alcan jab'oc d'ayin. Man̈xo jab'oc ix vab'i, tato maay, ix am ex in taq'uejcot d'a tzalajc'olal, ix am och son yed' yunetac tan̈b'il yed' arpa ayic ex coti. ");
INSERT INTO cac_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Maj in tz'ub'canelta sti' eb' ix visil yed' eb' vin̈ vi in chiquin. Ichato malaj jab'oc a pensar, yuj chi' icha chi' ix utej a b'a. ");
INSERT INTO cac_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","A in tic syal vac'an chucal d'ayex, tato syal in c'ool, palta a q'uiq'ui d'ac'val ix sch'ox sb'a sDiosal vin̈ a mam d'ayin, ix yalani: Scham val a naani tas ol al d'a vin̈aj Jacob chi'. Man̈ comonoc tzach loloni, xchi d'ayin. ");
INSERT INTO cac_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Tato tza te naejb'at b'aj ay vin̈ a mam, yuj chi' icha chi' ix a c'ulej, palta ¿tas yuj ix elq'uejcot juntzan̈ in diosal? xchi vin̈aj Labán chi'. ");
INSERT INTO cac_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ix tac'vi vin̈aj Jacob chi' icha tic: —Ix in el d'ayach d'a elc'altac yujto ix in xivi. A ix aj in naani, talaj tzac' pural ic'ancanec' eb' ix isil tic d'ayin. ");
INSERT INTO cac_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tato a junoc eb' ayec' d'a tic b'aj ayec' a diosal chi', syaln̈ej schami. A eb' ayec' qued'oc tic syal yac'an testigoal eb'. Say ila', tato ay jab'oc a tastac ix vic'coti, syal ic'anpaxoc, xchi vin̈aj Jacob chi'. Palta man̈ yojtacoc vin̈aj Jacob chi' tato a ix Raquel ix elc'ancot sdiosal vin̈ smam chi'. ");
INSERT INTO cac_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ix ochb'at vin̈aj Labán d'a yol smantiado vin̈aj Jacob chi', ix ochpax vin̈ d'a smantiado ix Lea yed' d'a yic eb' ix chavan̈ criada, palta malaj tas ix ilchaj yuj vin̈. Ix lajvi yelta vin̈ d'a yol smantiado ix Lea chi', ix ochxi vin̈ d'a yic ix Raquel. ");
INSERT INTO cac_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Axo ix ix c'ub'an el juntzan̈ yechel chi' d'a yalan̈ stz'um noc' camello, ix emcan c'ojan ix d'a yib'an̈. Ix ec'chaj vin̈aj Labán say d'a masanil mantiado, palta maj ilchajlaj sdiosal vin̈ chi' yuuj. ");
INSERT INTO cac_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ix yalan ix Raquel d'a vin̈ icha tic: —Mamin, mocab' cot oval d'ayin, yujto max yal-laj in q'ue van d'a ichan̈, yujto a ticnaic ya'ay in yuj sb'isul uj, xchi ix, ton̈ej ix tz'ac yal ix. Axo vin̈aj Labán jun, ix ec'chaj vin̈ say sdiosal chi', palta maj ilchajlaj. ");
INSERT INTO cac_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yuj chi' ix cot yoval vin̈aj Jacob, ix yalan vin̈: —¿Tas val in mul ix och d'ayach? ¿B'ajtil ay in mul chi' yuj chi' tzac' val och d'a a c'ool in a sayaneq'ui? ");
INSERT INTO cac_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Masanil in c'ael tza say ila', ¿tas junoc ic ix ilchaj uj ticnaic? Ch'ox d'a yichan̈ eb' vin̈ ed'nac tic yed' d'a yichan̈ pax eb' vin̈ ved'nac tic, yic vach' a eb' vin̈ syal yalani mach on̈ yel scala'. ");
INSERT INTO cac_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","A d'a 20 ab'il ix in munlaj ed'oc, malaj val junoc noc' a calnel, malaj val junoc noc' smam a chiva ix in chib'ati, malaj val noc' snun ton̈ej ix ec' sti'. ");
INSERT INTO cac_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Malaj b'aj ix vic'cot jilipoc noc' a calnel ix chiji yuj noc' oques d'ayach, yujto a noc' satb'ati tzin tupoch noc' d'ayach. Vach'chom c'ualil ma d'ac'valil ix b'at noc' yuj elc'um, ina to ix a c'an stojol noc' d'ayin. ");
INSERT INTO cac_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","A d'a c'ualil, tzin te tz'a yuj c'ac', axo d'ac'valil, tzin potzel yuj siic, max ochlaj in vayan̈ tz'ec' ac'val. ");
INSERT INTO cac_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","20 ab'il ix in ec' ed'oc, palta ix vac'n̈ej techajoc. 14 ab'il ix in caj eb' ix isil tic, axo vaquexo ab'il jun, ix in munlaj yuj noc' a molb'etz, aton noc' ix ac' in tojoloc. Cotac scal ix in a q'uexan̈ tiej yuj in tojol. ");
INSERT INTO cac_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ta val man̈ ayoc och Dios ved'oc, aton sDiosal vin̈ in mam icham aj Abraham, aton Dios b'aj slesalvipax vin̈ in mam aj Isaac, val yel, malaj am jab'oc tas d'a yol in c'ab' tzin paxta. Palta a Dios ix ilan in yaelal yed' tas ix aj yelc'och in munlajel, yuj chi' aton ix ach cachanoch vaan q'uiq'ui d'ac'val chi'. ");
INSERT INTO cac_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ix yalan vin̈aj Labán d'a vin̈aj Jacob chi' icha tic: —Visil eb' ix tic, vi in chiquin pax eb' tic yed' noc' calnel tic, vic noc' smasanil. Masanil tas ayec' tic, vico'. Palta jun, ¿tasto val svutej eb' ix visil yed' yune' eb' ix? ");
INSERT INTO cac_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yuj chi', cotan̈ co b'o junoc co trato ticnaic yic ch'oxnab'il tz'ajcan d'a co cal co chavan̈il, xchi vin̈aj Labán chi'. ");
INSERT INTO cac_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ix yic'ancot jun q'uen q'ueen vin̈aj Jacob chi', ix yac'anq'ue lin̈an q'uen vin̈ yic ch'oxnab'il tz'aj q'ueen. ");
INSERT INTO cac_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ix yalan vin̈ d'a masanil eb' schecab' icha tic: —Molb'ejec q'uen q'ueen, xchi vin̈. Masanil eb' ix molb'an q'ueen. Jun val juyan̈ ix yutej q'uen eb', ix va eb' d'a stz'ey q'ueen. ");
INSERT INTO cac_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ix yac'anoch vin̈aj Labán chi' sb'iej jun juyan̈ q'uen chi' d'a sti' eb' syala': Jegar Sahaduta Axo pax vin̈aj Jacob chi' jun, Galaad ix yac' vin̈ scuch jun q'uen chi' d'a sti'. ");
INSERT INTO cac_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ix lajvi chi' ix yalan vin̈aj Labán chi' icha tic: —A ticnaic, a jun juyan̈ q'ueen tic testigo tz'ajcan cuj co chavan̈il, xchi vin̈. Yuj chi' Galaad sb'i jun lugar chi'. ");
INSERT INTO cac_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Mizpa ix sb'iejpaxi yujto ix yal vin̈aj Labán chi' icha tic: —A Jehová tzon̈ ilan co chavan̈il yic man̈xo ol yal quil-lan co b'a junjun on̈. ");
INSERT INTO cac_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Tato ol ixtej eb' ix visil tic, mato ol a say juntzan̈ocxo eb' ix ol och etb'eyumoc, vach'chom malaj mach tz'ac'an testigoal, palta a Dios testigo, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ix yalanpax vin̈ d'a vin̈aj Jacob chi': —Ina q'uen b'ul q'uen tic yed' q'uen ix q'uecan lin̈an, aton val q'uen ix vac'can d'a co cal co nan̈al co chavan̈il. ");
INSERT INTO cac_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","A val q'uen tic tz'ac'an testigoal d'ayon̈ to man̈xo ol yal co c'axpitan jun mojon tic yic scac'an chucal d'ayon̈ junjun on̈. ");
INSERT INTO cac_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Aocab' sDiosal vin̈aj Abraham a mam icham yed' pax sdiosal vin̈aj Nacor in mam icham, aocab' tzon̈ ilan co chavan̈il, xchi vin̈aj Labán chi'. Ix lajvi chi' ix yac'an sti' vin̈aj Jacob chi' d'a sb'i Dios, aton Dios b'aj syaq'uem sb'a vin̈aj Isaac, vin̈ smam vin̈. ");
INSERT INTO cac_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ix yac'an juntzan̈ silab' vin̈ d'a Dios d'a schon jun tzalan chi', ix yavtancot eb' ajun yed'oc chi' vael. Masanil eb' ix va'i, a d'a chon tzalan chi' ix ec' ac'val yuj eb'. ");
INSERT INTO cac_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Axo yic ix sacb'i d'a junxo c'u, ix q'ue vaan vin̈aj Labán chi', ix tz'ub'ancan sti' eb' yixchiquin vin̈ yed' eb' ix yisil vin̈, ix yalancan vach' lolonel vin̈ d'a yib'an̈ eb', ix meltzaj vin̈ d'a spat yed' eb' ajun yed'oc. ");
INSERT INTO cac_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ix lajvi chi', ix b'eycot vin̈aj Jacob chi'. Axo ix aji, ix schalaj sb'a vin̈ yed' juntzan̈ eb' yángel Dios. ");
INSERT INTO cac_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ayic ix yilan eb' ángel chi' vin̈, ix yalan vin̈: Scampamento eb' yejército Dios jun tic, xchi vin̈. Yuj chi' Mahanaim ix yac' vin̈ sb'iej jun lugar chi'. ");
INSERT INTO cac_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ix schecancot juntzan̈ eb' schecab' vin̈ d'a lum Seir, d'a yol yic Edom, yic scot eb' yal d'a vin̈ yuc'tac vin̈, aton vin̈aj Esaú to vanxo scot vin̈ d'a yol b'e. ");
INSERT INTO cac_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ix yalan vin̈ d'a eb' schecab' chi' icha tic: Alec d'a vin̈ vuc'tac aj Esaú icha tic: A vin̈ uc'tac aj Jacob syac'och sb'a vin̈ d'a yalan̈ a mandar. Tzeyalanpaxi to a yed' vin̈aj Labán ix in ec' jun tiempoal tic. ");
INSERT INTO cac_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","A ticnaic ay noc' in vacax, noc' in calnel, noc' in chiva, noc' in b'uru. Ay eb' vin̈ in checab' yed' eb' ix in checab'. Svalb'at jun ab'ix tic d'ayach mamin vuc'tac, yujto tzin nib'ej tzin och junc'olal ed'oc, xchicot vin̈aj Jacob, xe chi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Axo yic ix jax eb' vin̈ checab' chi', ix yalan eb' vin̈ d'a vin̈aj Jacob icha tic: —Toxo ix on̈ xid'ec' d'a vin̈ uc'tac, tic van sja vin̈ ul ach scha'a. Chan̈e' ciento val vinac yed'nac vin̈, xchi eb' vin̈ schecab' vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ayic ix yab'an juntzan̈ chi' vin̈aj Jacob chi', ix xiv chaan̈ vin̈, ix te och vin̈ ilc'olal. Ix lajvi chi' ix spojan b'at eb' anima vin̈ yed'nac. Cha macan̈ ix yutej vin̈ yed' noc' vacax, noc' calnel yed' noc' camello. ");
INSERT INTO cac_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yujto ix sna vin̈: Tato sjavi vin̈aj Esaú d'a junoc macan̈, yacb'an syac' oval vin̈ yed'oc, axo junxo macan̈ syal yeli, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ix lajvi chi' ix lesalvi vin̈ icha tic: Ach Jehová in Diosal, sDiosal ach vin̈ in mam icham aj Abraham yed' vin̈ in mam aj Isaac. A ach ix ala' to tzin meltzajcot d'a in luum, d'a scal eb' in c'ab' voc. Ix alani to ayachn̈ej och ved'oc yic vach'n̈ej tzin elc'ochi. ");
INSERT INTO cac_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Te man̈ in mojoc to tzin a xajanej, man̈ in mojoc pax to ayn̈ejoch a vach'c'olal ved'oc. Ayic vec'nacb'at d'a yol a' Jordán, an̈ej jun in c'ococh ved'nac, axo ticnaic, chab'xo campamentoal ix in elc'ochi, te ayxo tastac d'ayin. ");
INSERT INTO cac_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Tzin tevi d'ayach to tzin a col d'a yol sc'ab' vin̈ vuc'tac chi'. Tzin te xivi, q'uinaloc sja vin̈ d'ayin, smilancham eb' ix ix yed' eb' unin tic vin̈. ");
INSERT INTO cac_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","A ach ix ala' to vach'n̈ej ol in elc'och uuj. Ix alanpaxi to man̈ jantacoc ol ajelc'och sb'isul vin̈tilal, icha val yarenail a' mar to max yal sb'ischaji, xchi vin̈ d'a slesal chi'. ");
INSERT INTO cac_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","A d'a jun ac'val chi', ix vaycan vin̈ ta'. Ayic ix sacb'i, a d'a scal masanil tas yed'nac vin̈, ix siq'uel tastac vin̈ yic siej vin̈ d'a vin̈ yuc'tac chi': ");
INSERT INTO cac_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 noc' nun chiva yed' 20 noc' mam chiva. 200 noc' nun calnel yed' 20 noc' ch'ac calnel. ");
INSERT INTO cac_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 noc' nun camello yed' noc' yune' toto ix alji, 40 noc' nun vacax yed' lajun̈van̈ noc' toro, 20 noc' nun b'uru yed' lajun̈van̈ noc' mam b'uru. ");
INSERT INTO cac_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","D'a elan̈chamel ix yac' vin̈aj Jacob junjun macan̈ noc' d'a eb' vin̈ schecab', macquiltac ix yutej vin̈, ix yalan vin̈ d'a eb' icha tic: —B'ab'lajan̈ec yed' junjun macan̈ noc', najtic tzeyutej scal junjun macan̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","A d'a vin̈ ed'jinac noc' b'ab'el, ix yal vin̈ icha tic: —Ayic ol a chaan a b'a yed' vin̈ vuc'tac chi', tato sc'anb'ej vin̈: ¿Mach a patrón? ¿B'ajtil tzach b'ati? ¿Mach yic noc' noc' ed'nac tic? tato xchi vin̈ d'ayach, ");
INSERT INTO cac_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","tzalan d'a vin̈ icha tic: Mamin Esaú, a juntzan̈ tic silab' vin̈aj Jacob a checab' d'ayach. Tzac'anpax vin̈ vuuj, xa chi, xchi vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Icha chi' ix aj yalan vin̈ d'a vin̈ ed'jinac noc' schab'il macan̈ yed' d'a vin̈ ed'jinac noc' yoxil macan̈. Icha chi' ix aj yalan vin̈ d'a masanil eb' vin̈ ed'jinac junjun macan̈ noc' noc' chi': —Ayic ol e chalan e b'a yed' vin̈aj Esaú chi', jun lajann̈ej ol eyutej eyalani. ");
INSERT INTO cac_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Tzeyalani: Tzac'an vin̈aj Jacob a checab' cuuj, xe chi, xchi vin̈ d'a eb' vin̈ schecab' chi'. Icha tic ix yutej snaan vin̈aj Jacob chi': Tecan ol emta yoval sc'ol vin̈aj Esaú yuj in silab' ix vac' b'ab'laj d'a vichan̈, ol vilan val och in b'a yed' vin̈. Tato icha chi' tecan ol in scha vin̈ d'a vach'il, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Yuj chi', ix schec b'ab'laj masanil silab' vin̈aj Jacob chi'. Axo vin̈ jun, ixto can junxo ac'val vin̈ d'a scampamento chi'. ");
INSERT INTO cac_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","A d'a jun ac'val chi' ix q'ue van vin̈aj Jacob, ix yic'anb'at eb' ix yetb'eyum vin̈ schavan̈il yed' eb' ix chavan̈ criada yed' uxluchvan̈ yuninal vin̈, ix ec'ta eb' d'a sjayil jun a' scuchan Jaboc yed' masanil tastac yed'nac. ");
INSERT INTO cac_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Axo yic ix can vin̈ sch'ocojil, ix yac'an oval vin̈ yed' jun vinac masanto ix sacb'i. ");
INSERT INTO cac_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Axo jun vinac chi', ix yila' to max ac'ji ganar vin̈aj Jacob chi' yuuj, yuj chi' ix mac'jiel yacan̈il xub' vin̈aj Jacob chi' yuuj. Ix el chinnaj xub' vin̈ chi' ayic ix yac'an oval eb'. ");
INSERT INTO cac_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ix yalan jun vinac chi' d'a vin̈ icha tic: —Actej in eli yujto vanxo sacb'i, xchi. Ix yalan vin̈aj Jacob d'ay icha tic: —Man̈ ol ach vactejeli, tato man̈ ol alcan junoc vach' lolonel d'a vib'an̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","—¿Tas a b'i? xchi jun vinac chi' d'a vin̈. —Jacob in b'i, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ix yalan d'a vin̈ icha tic: —A ticnaic man̈xo Jacob-oc ol a b'iej, palta Israelxo, yujto ix yal ac'an oval yed' Dios yed' pax anima, xchi. ");
INSERT INTO cac_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","—A ticnaic al d'ayin tas a b'i ach tic, xchi vin̈aj Jacob chi'. Axo ix yalan jun vinac chi' icha tic: —¿Tas yuj tza c'anb'ej in b'i? xchi. Ata' ix yalcan vach' lolonel d'a yib'an̈ vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yuj chi' Peniel ix sb'iejcan jun lugar chi' yuj vin̈aj Jacob chi', ix yalan vin̈ icha tic: Ix vil sat Dios, palta ina pitzan into, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Vanxo yec'b'at vin̈aj Jacob d'a Peniel chi', ix javi c'u. Yujto ix el chinnaj xub' vin̈, yuj chi' tz'em sb'ey vin̈. ");
INSERT INTO cac_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yuj chi' a eb' yin̈tilal Israel, max schilaj sch'an̈al sc'ojnub' xub' noc' noc' eb', yujto a d'a xub' vin̈aj Jacob chi' yab'nac syail. ");
INSERT INTO cac_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Axo ix yilan vin̈aj Jacob to van sja vin̈aj Esaú yed' 400 svinac, ix spojanec' eb' unin vin̈ d'a scal eb' ix ix, aton ix Lea yed' ix Raquel yed' pax eb' ix chavan̈ scriada eb' ix. ");
INSERT INTO cac_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","A eb' ix criada chi', ix b'ab'laj b'at eb' ix yed' yune' chi'. Ichato chi' ix b'at ix Lea yed' eb' yico'. Tzac'anto ix b'at ix Raquel yed' vin̈aj José. ");
INSERT INTO cac_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","D'a elan̈chamel ix b'ab'lajb'at vin̈aj Jacob d'a yichan̈ eb' ix. Uquel ix em n̈ojnaj vin̈ masanto ix c'och vin̈ d'a yichan̈ vin̈ yuc'tac chi'. ");
INSERT INTO cac_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ix javi lemnaj vin̈aj Esaú chi', ix och lac'naj vin̈ d'a sjaj vin̈ yuc'tac chi', ix och tz'ub'naj vin̈ d'a sti' vin̈, ix oc' eb' vin̈ schavan̈il. ");
INSERT INTO cac_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ix lajvi chi' ix yilanoch eb' ix ix yed' eb' unin vin̈aj Esaú chi', ix sc'anb'an vin̈ icha tic: —A juntzan̈ eb' tic, ¿mach ay yic eb'? xchi vin̈. —Vuninal eb', ix yac' Dios d'ayin yuj svach'c'olal, xchi vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ichato chi' ix snitzancot sb'a eb' ix criada yed' eb' yune' d'a yichan̈ vin̈aj Esaú chi', ix em n̈ojan eb' d'a sat luum. ");
INSERT INTO cac_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ix snitzanpaxcot sb'a ix Lea yed' eb' yune', ix empax n̈ojan eb'. Tzac'anto ix javi vin̈aj José yed' ix snun, aton ix Raquel, ix empax n̈ojan eb'. ");
INSERT INTO cac_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ix sc'anb'an vin̈aj Esaú d'a vin̈aj Jacob chi' icha tic: —¿Tas tza na d'a yib'an̈ juntzan̈ noc' noc' ix in cha d'a yol b'e? xchi vin̈. —Ic yaj noc' smasanil yic tz'och junc'olal d'a co cal, xchi vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","—Maay vuc'tac, te tzijtum pax noc' vico', canocab' noc' ed'oc, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Palta ix och ijan vin̈aj Jacob chi' yalan d'a vin̈ icha tic: —Maay vuc'tac, tato vach' in d'a ichan̈, cha juntzan̈ silab' svac' tic d'ayach, icha val to a Dios svilochi ayic tzach vilan tic, yujto d'a vach'c'olalil ix in a cha'a. ");
INSERT INTO cac_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tzin tevi d'ayach to tza cha juntzan̈ silab' ix vic'cot d'ayach, yujto a Dios ix el d'a sc'ol yac'an in b'eyumal tic, malaj jab'oc tas syac' palta d'ayin, xchi vin̈aj Jacob chi'. Ix ochn̈ej tean vin̈ d'a vin̈ yuc'tac chi', yuj chi' ix scha noc' silab' chi' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ix yalan vin̈aj Esaú chi' icha tic: —A ticnaic, coyec. A in tzin b'ab'laj d'a eyichan̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ix tac'vi vin̈aj Jacob chi': —Ach vuc'tac, ojtac to a eb' unin, c'un sc'unb'i eb', tzin naanpax yuj noc' calnel yed' noc' vacax nenetacto yune', tato tzin pech noc' ay smay junn̈ej c'ual scham noc' smasanil. ");
INSERT INTO cac_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Yuj chi' vach' tzach b'ab'laj vuuj. A inxo tic, c'ojanc'olaln̈ej ol in b'atoc, icha syal sb'ey eb' unin yed' noc' noc' tic. Olxo ach vilc'och d'a Seir, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","—Yic'ocab' icha tzal chi'. Syal scan jayvan̈oc eb' vin̈ in checab' tic yic scolvaj ed'oc, xchi vin̈aj Esaú chi'. Palta ix yalan vin̈aj Jacob chi' icha tic: —Maay, yuj val dios, man̈ ac' pensar vuuj, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","A d'a jun c'u chi', ix meltzaj vin̈aj Esaú d'a lum Seir. ");
INSERT INTO cac_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Axo vin̈aj Jacob, ix jacan vin̈ d'a jun ac'lic. Ata' ix sb'o spat vin̈, ix sb'oanpax juntzan̈ yunetac lechpat vin̈ b'aj ix och noc' smolb'etzal noc'. Yuj chi' Sucot ix yac' vin̈ sb'iej jun lugar chi'. ");
INSERT INTO cac_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ayic ix paxta vin̈aj Jacob d'a Padán-aram masanto ix javi vin̈ d'a yol yic Canaán, malaj tas ix ic'an vin̈, vach' sc'ol vin̈ ix jaxi. Ix sb'oan scampamento vin̈ d'a yichan̈b'at chon̈ab' Siquem. ");
INSERT INTO cac_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","100 q'uen plata ix yac' vin̈ yic smanan jun lum luum chi' vin̈ d'a eb' yuninal vin̈aj Hamor, vin̈ ix ic'anel yich chon̈ab' Siquem. Ata' ix sb'oq'ue scampamento vin̈. ");
INSERT INTO cac_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ix lajvi chi' ix sb'oanq'ue jun altar vin̈, El-Elohe-Israel ix yac' vin̈ sb'iej. ");
INSERT INTO cac_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","A ix yune' ix Lea yed' vin̈aj Jacob, aton ix Dina, ix b'at ix paxyal d'a scal eb' ix ix d'a Siquem chi'. ");
INSERT INTO cac_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","A vin̈aj Hamor heveo, yajal yaj d'a jun chon̈ab' chi'. Ay jun yuninal vin̈ scuchan Siquem. Ayic ix yilanoch ix Dina vin̈aj Siquem chi', ix ixtaj ix yuj vin̈ d'a ac'b'il puralil. ");
INSERT INTO cac_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Yujto te ay sgana vin̈ d'a ix, yuj chi' ix montaj ix yuj vin̈ d'a vach'il. ");
INSERT INTO cac_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ix yalan vin̈ icha tic d'a vin̈ smam chi': —Mamin, octom b'at a c'an jun ix cob'es tic. In gana svic' in b'a yed' ix, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","8","Vach'chom ix yab' vin̈aj Jacob to toxo ix ixtaj ix yisil vin̈ yuj vin̈aj Siquem chi', malaj tas ix yal vin̈ masanto ix jax eb' yuninal vin̈ tan̈voj calnel. A ix yab'an eb' vin̈ yuninal vin̈ chi' tas ix uji, ix meltzajcot eb' vin̈, ix te cus eb' vin̈. Ix cotpax yoval eb' vin̈, yujto te q'uixvelal ix utaj eb' yin̈tilal vin̈aj Israel, aton vin̈aj Jacob, yuj vin̈aj Siquem chi', yujto ix ixtaj ix yisil vin̈. Man̈ vach'oc tas ix sc'ulej vin̈aj Siquem chi'. Axo vin̈aj Hamor chi' ix b'at lolon yed' vin̈aj Jacob chi'. Ix lolonpax vin̈ yed' eb' yuninal vin̈, ix yalan vin̈: —A vin̈ vuninal aj Siquem te ay val sgana vin̈ d'a ix eyanab', yuj chi' elocab' d'a e c'ool yic syic'laj sb'a ix yed' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ichato ol co c'ab'coquej co b'a. Ol quic'laj co b'a yed' eb' ix eyisil, a ex xo ol eyic'laj e b'a yed' eb' ix quico'. ");
INSERT INTO cac_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Cajnajan̈ec d'a co cal tic, colan tzex aj d'a sat co luum tic, aq'uecoch e chon̈, manec e luum, xchi vin̈aj Hamor chi'. ");
INSERT INTO cac_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ix yalanpax vin̈aj Siquem chi' d'a vin̈ smam ix Dina chi' yed' d'a eb' vin̈ snulej ix: —Yaln̈ej tas tze c'an d'ayin ol vac' d'ayex. ");
INSERT INTO cac_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Vach'chom nivan tas svac' d'a yib'an̈ tas syac'taxon eb' anima yed' pax tzijtumoc silab' syal vac'ani, palta malaj tz'ochi, an̈ej tato scha e c'ool svic' in b'a yed' ix, xchi vin̈aj Siquem chi'. ");
INSERT INTO cac_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yujto toxo ix yixtej ix yanab' eb' vin̈ chi' vin̈, ix tac'vi eb' vin̈ d'a chab'satil d'a vin̈ yed' d'a smam vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ix yalan eb' vin̈ icha tic: —Max yal cac'an ix canab' tic d'a junoc vinac to man̈ ac'b'iloc circuncidar, q'uixvelal tzon̈ ajcan icha chi'. ");
INSERT INTO cac_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","An̈ej tato scha e c'ol icha caj a on̈ tic, tecan am scac' ix d'ayex, yujto a on̈ tic, circuncidado on̈. Tato syal e c'ool tzex ac'ji circuncidar yed' masanil eb' vin̈ vinac ay d'a e cal chi', ");
INSERT INTO cac_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ichato chi' syal eyic'an eb' ix quisil a on̈ tic, syalpax quic'an eb' ix eyico'. Ichato chi' syal caj d'a e cal, junxon̈ej chon̈ab'il tzon̈ aj eyed'oc. ");
INSERT INTO cac_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tato max scha e c'ol tze c'anab'ajej jun circuncisión chi' jun, ol on̈ el d'a tic, ol quic'anb'at ix canab' tic qued'oc, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Yuj chi' ix scha sc'ool vin̈aj Hamor yed' vin̈ yuninal tas ix yal eb' vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Majxo ec' val nivan tiempo, yujto ay sgana vin̈ d'a ix yisil vin̈aj Jacob chi'. A vin̈aj Siquem chi' an̈ej vin̈ nivan yelc'och d'a scal eb' yuninal vin̈aj Hamor yed' d'a scal eb' sc'ab'yoc. ");
INSERT INTO cac_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","D'a elan̈chamel ix b'at vin̈ yed' vin̈ smam chi' d'a spuertail chon̈ab' b'aj smolb'ej sb'a eb' anima, ix och ijan eb' yalan icha tic d'a eb' vin̈ vinac: ");
INSERT INTO cac_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","—A juntzan̈ vinac tic vach' spensar eb', ol cajnaj eb' d'a co cal tic, ol yac'anoch schon̈ eb' d'a co chon̈ab' tic. Te ay lum luum b'aj vach' yaj eb' vin̈. Syal quic'an co b'a yed' eb' ix yisil eb' vin̈, syalpax yic'an sb'a eb' vin̈ yed' eb' ix quico'. ");
INSERT INTO cac_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","An̈ej to snib'ej eb' vin̈ to co masanil a on̈ vinac on̈ tic, sco cha jun circuncisión icha yaj eb' vin̈, icha chi' junn̈ej chon̈ab'il tzon̈ aj yed' eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","A masanil stastac eb' vin̈ yed' masanil noc' smolb'etzal noc' eb' vin̈, quicxo smasanil, an̈ej tato sco tac'vej d'a eb' vin̈, yic vach' scan eb' vin̈ d'a co cal, xchi vin̈aj Hamor yed' vin̈aj Siquem chi'. ");
INSERT INTO cac_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Masanil eb' vin̈ tz'acanxo spensar ix scha sc'ol eb' vin̈ tas ix yal eb' chavan̈ chi', yuj chi' ix ac'ji circuncidar eb' vin̈ masanil. ");
INSERT INTO cac_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Axo vin̈aj Simeón yed' vin̈aj Leví, yuninal vin̈aj Jacob, snulej ix Dina chi', ix b'at eb' vin̈ d'a chon̈ab' chi' d'a schab'jial. Yacb'an yato ay eb' vin̈ vinac chi' yuj b'aj ix ac'ji circuncidar chi', ix c'och eb' vin̈ chavan̈ chi' d'a yol chon̈ab' chi'. Ix och ijan eb' vin̈ smilancham eb' vin̈ ya yaj chi' smasanil d'a q'uen espada, yujto man̈ naanoc yuj eb' aj chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ix miljicham vin̈aj Hamor yed' vin̈aj Siquem yuj eb'. Ix lajvi chi' ix yic'anelta ix Dina eb' vin̈ d'a yol spat vin̈aj Siquem chi', ix paxta eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ix lajvi chi' ix c'och masanil eb' vin̈ yuninal vin̈aj Jacob chi', ix yic'anelta masanil tastac ay d'a eb' chamnac chi' eb' vin̈. Icha chi' ix aj spactzitan eb' vin̈ yuj b'aj ix ixtaj ix yanab' chi'. ");
INSERT INTO cac_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Masanil tas ay d'a yol chon̈ab' chi' yed' tas ayel d'a najat ix yic'b'at eb' vin̈, noc' calnel, noc' vacax yed' noc' b'uru. ");
INSERT INTO cac_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ix yelc'anb'at eb' vin̈ masanil tas ay d'a yoltac pat, ix ic'jipaxb'at eb' cotac unin yed' eb' ix ix yuj eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Palta ix yalan vin̈aj Jacob d'a vin̈aj Simeón yed' d'a vin̈aj Leví chi' icha tic: —Tic val a ex tzeyac' somchajel in c'ool. A ticnaic, masanil eb' vin̈ cajan d'a juntzan̈ lugar tic, aton masanil eb' vin̈ cananeo yed' eb' vin̈ ferezeo, ol te och chian sc'ool eb' vin̈ d'ayon̈. Tecan ol smolb'ej sb'a eb' vin̈, ol yac'an oval eb' vin̈ qued'oc. Jayvan̈n̈ej co vinac ayec' qued'oc, tecan ol on̈ smilcham eb' vin̈ co masanil, xchi vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ix tac'vi eb' vin̈ icha tic: —¿Tom ay sleyal syixtej ix canab' tic vin̈, syutan ix vin̈ icha junoc ix ajmul ix? xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ix yalan Dios d'a vin̈aj Jacob: Elan̈ d'a tic, ixic cajnajancan d'a Betel. Ata' tza b'oq'ue jun altar d'ayin. Ata' in ch'oxnac in b'a d'ayach ayic elnac d'a vin̈ uc'tac aj Esaú, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ix yalan vin̈aj Jacob chi' d'a eb' ix yetb'eyum yed' d'a eb' yuninal yed' d'a masanil eb' vin̈ ajun yed'oc: —Iq'uequel masanil juntzan̈ comon dios d'a e cal, tze b'icanel e b'a, tze q'uexanel e pichul e masanil. ");
INSERT INTO cac_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Coyec elan̈chamel d'a Betel. Ata' ol in b'oq'ue jun altar yic svic'chaan̈ sb'i Dios, aton jun ix colvaj ved'oc ayic ay in och d'a ilc'olal yed' b'ajtac in eq'ui, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Icha chi' ix aj yac'an juntzan̈ comon dios yed'nac eb' d'a vin̈aj Jacob yed' q'uen yuchiquin eb'. Axo vin̈ ix b'at mucanem d'a yich jun te' ji ayec' d'a slac'anil Siquem. ");
INSERT INTO cac_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ayic ix el eb' ta', a Dios ix ac'an xivc'olal d'a yib'an̈ masanil juntzan̈ chon̈ab' ayec' d'a slac'anil chi', yuj chi' man̈xalaj mach ix pechan eb'. ");
INSERT INTO cac_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ix c'och vin̈aj Jacob chi' yed' masanil eb' anima yed'nac d'a jun lugar scuch Luz, d'a yol yic Canaán. An̈ejtona' jun chon̈ab' chi' scuchan Betel. ");
INSERT INTO cac_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ata' ix sb'oq'ue jun altar vin̈, El-Betel ix sb'iejcan jun lugar chi' yuj vin̈, yujto ata' ix sch'ox sb'a Dios d'a vin̈ ayic ix el vin̈ d'a vin̈ yuc'tac. ");
INSERT INTO cac_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","An̈ejtona' ata' ix cham ix Débora, aton ix ilannac q'uib' ix Rebeca. Ix smucanem ix eb' d'a yich jun te' ji d'a slac'anil Betel chi'. Axo vin̈aj Jacob chi' ix sayan sb'i jun lugar chi', Te' Ji yic Cusc'olal, xchi. ");
INSERT INTO cac_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ayic ix jax vin̈ d'a Canaán, spetoj vin̈ d'a Padán-aram, ix sch'oxanxi sb'a Dios d'a vin̈, ix yalan vach' lolonel d'a yib'an̈ vin̈. ");
INSERT INTO cac_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ix yalan icha tic: A ach tic Jacob a b'i, palta a ticnaic, man̈xo ichocta' ol a b'iej, Israel ol a b'iejcani, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ayic ix lajvi sq'uexan sb'i vin̈ chi', ix yalan d'a vin̈ icha tic: A in ton Dios in Syal Vuj Smasanil, man̈ jantacoc ol aj uninal yed' in̈tilal. A d'ayach ol pitzvoc jun nación, tzijtum chon̈ab'il ol ajpax elc'ochi. D'a scal in̈tilal chi' ay eb' ol och reyal. ");
INSERT INTO cac_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","A lum luum ix vala' to ol vac'can d'a vin̈aj Abraham yed' d'a vin̈aj Isaac, svalpax ticnaic to ol vac'can d'ayach yed' d'a eb' in̈tilal, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ix lajvi chi' ix el Dios b'aj ix lolon yed' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ix sayan jun nivan q'uen vin̈aj Jacob chi', nivan yaj c'atan q'ueen, ix sb'oancanq'ue lin̈an q'uen vin̈ b'aj ix lolon Dios yed'oc. Ix secanq'ue aceite yed' vino vin̈ d'a yib'an̈ q'ueen, yic syac' vin̈ silab'oc d'a Dios. ");
INSERT INTO cac_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Betel ix sb'iejcan jun lugar chi' yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ix lajvi chi' ix yactancan jun lugar chi' eb'. Ayto sc'och eb' d'a Efrata, ix alji jun yune' ix Raquel. ");
INSERT INTO cac_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Yic val ayoch ix d'a ilc'olal yuj yab'an syail, axo ix vetz'vajum ix alani: Man̈ ach xivoc, toxo ix alji junxo a vinac unin, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Palta ayic vanxo scham ix yuj jun unin chi', ix sayancan sb'i ix, Ben-oni ix sb'iejcani. Axo vin̈aj Jacob chi' jun, Benjamín ix yac' vin̈ sb'iej. ");
INSERT INTO cac_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ata' ix chamcan ix Raquel chi'. Ix mucchajcan ix d'a sb'eal Efrata, aton jun lugar chi' scuch Belén ticnaic. ");
INSERT INTO cac_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ix sb'oanq'ue lin̈an jun cimiento vin̈aj Jacob d'a yib'an̈ b'aj ix mucchaj snivanil ix chi', aton jun chi' sch'oxancan b'ajtil mucan ix. ");
INSERT INTO cac_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ix b'atn̈ej vin̈aj Israel chi', ix sb'oan scampamento vin̈ d'a yichan̈b'at Torre yic Edar. ");
INSERT INTO cac_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yacb'an cajan ec' eb' d'a jun lugar chi', axo vin̈aj Rubén, yuninal vin̈aj Israel chi' ix vay vin̈ yed' ix Bilha, schab'il yetb'eyum vin̈ smam chi'. Ix yab' vin̈aj Israel chi' tas ix sc'ulej vin̈ yunin chi'. Lajchavan̈ eb' vin̈ yuninal vin̈aj Jacob chi': ");
INSERT INTO cac_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","A eb' vin̈ yuninal vin̈ yed' ix Lea: Aton vin̈aj Rubén, vin̈ b'ab'el unin, vin̈aj Simeón, vin̈aj Leví, vin̈aj Judá, vin̈aj Isacar yed' vin̈aj Zabulón. ");
INSERT INTO cac_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Axo eb' vin̈ yuninal vin̈ yed' ix Raquel: Aton vin̈aj José yed' vin̈aj Benjamín. ");
INSERT INTO cac_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Axo eb' yuninal vin̈ yed' ix Bilha, ix scriada ix Raquel: Aton vin̈aj Dan yed' vin̈aj Neftalí. ");
INSERT INTO cac_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Axo pax eb' yuninal vin̈ yed' ix Zilpa, ix scriada ix Lea: Aton vin̈aj Gad yed' vin̈aj Aser. Aton eb' tic yuninal vin̈aj Jacob ix alji d'a Padán-aram. ");
INSERT INTO cac_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ix b'at vin̈aj Jacob yil vin̈ smam, aton vin̈aj Isaac, cajan d'a lum Mamre, d'a chon̈ab' Arba, Hebrón pax sb'i. Ata' ec'nac vin̈aj Abraham yed' vin̈aj Isaac chi'. ");
INSERT INTO cac_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","180 ab'il sq'uinal vin̈aj Isaac chi' ayic ix cham vin̈. ");
INSERT INTO cac_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Te ichamxo vin̈, axo vin̈aj Esaú yed' vin̈aj Jacob, aton eb' vin̈ yuninal vin̈, a eb' vin̈ ix mucancan vin̈. ");
INSERT INTO cac_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Aton yab'ixal yin̈tilal vin̈aj Esaú, Edom pax sb'i. ");
INSERT INTO cac_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ix yic'laj sb'a vin̈aj Esaú yed' eb' ix aj Canaán: Aton yed' ix Ada, yisil vin̈aj Elón hitita yed' pax ix Aholibama yisil vin̈aj Aná, yixchiquin vin̈aj Zibeón heveo. ");
INSERT INTO cac_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ix yic'anpax ix Basemat vin̈, ix yisil vin̈aj Ismael. Ay jun vin̈ snulej ix Basemat chi' scuchan Nebaiot. ");
INSERT INTO cac_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","A yune' ix Ada yed' vin̈aj Esaú, aton vin̈aj Elifaz. Axo pax ix Basemat ix alji yune' ix, aton vin̈aj Reuel. ");
INSERT INTO cac_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Axo pax ix Aholibama ix alji eb' yune' ix: Aton vin̈aj Jeús, vin̈aj Jaalam yed' vin̈aj Coré. Aton eb' yuninal vin̈aj Esaú tic ix aj d'a yol yic Canaán, ayic cajantoec' vin̈ ta'. ");
INSERT INTO cac_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ix lajvi chi', ix yic'anb'at eb' ix yetb'eyum vin̈aj Esaú chi' yed' eb' yuninal yed' masanil eb' cajanec' yed'oc. Ix b'at eb' d'a junxo lugar, yic tz'el vin̈ d'a stz'ey vin̈aj Jacob, vin̈ yuc'tac. Ix yic'anel masanil noc' smolb'etzal noc' vin̈ d'a Canaán chi'. ");
INSERT INTO cac_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Yujto tzijtumxo tas ay d'a eb' vin̈ schavan̈il, yuj chi' max yal-laj junn̈ej tz'aj eb' vin̈, yujto max yab'laj lum luum b'aj sva noc' smolb'etzal noc' eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yuj chi' ix b'at vin̈aj Esaú chi', ix b'at cajnaj vin̈ d'a tzalquixtac d'a yol yic Seir. ");
INSERT INTO cac_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Aton tic yab'ixal eb' yin̈tilal vin̈aj Esaú, aton eb' smam yicham eb' vin̈ edomita, eb' vin̈ ix cajnajec' d'a tzalquixtac d'a Seir. ");
INSERT INTO cac_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Aton sb'i eb' yin̈tilal vin̈aj Esaú: Vin̈aj Elifaz, yune' ix Ada, vin̈aj Reuel yune' ix Basemat. ");
INSERT INTO cac_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Aton eb' tic yuninal vin̈aj Elifaz: Vin̈aj Temán, vin̈aj Omar, vin̈aj Zefo, vin̈aj Gatam yed' vin̈aj Cenaz. ");
INSERT INTO cac_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ay jun ix schab'il yetb'eyum vin̈aj Elifaz chi', Timna sb'i ix. Ix alji jun yune' ix, Amalec ix yac' ix sb'iej. Aton eb' tic yixchiquin ix Ada, ix yetb'eyum vin̈aj Esaú. ");
INSERT INTO cac_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","A eb' yuninal vin̈aj Reuel: Vin̈aj Nahat, vin̈aj Zera, vin̈aj Sama yed' vin̈aj Miza, aton eb' tic yixchiquin ix Basemat, junxo ix yetb'eyum vin̈aj Esaú. ");
INSERT INTO cac_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Aholibama sb'i junxo ix yetb'eyum vin̈aj Esaú chi', axo eb' yune' ix aton vin̈aj Jeús, vin̈aj Jaalam yed' vin̈aj Coré. A ix Aholibama chi' yisil ix vin̈aj Aná, yixchiquin vin̈aj Zibeón. ");
INSERT INTO cac_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","A eb' yajalil chon̈ab' ix el d'a scal yin̈tilal vin̈aj Esaú, aton eb' tic: A eb' ix el d'a yin̈tilal vin̈aj Elifaz, b'ab'el yuninal vin̈aj Esaú: Aton vin̈aj Temán, vin̈aj Omar, vin̈aj Zefo, vin̈aj Cenaz, ");
INSERT INTO cac_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","vin̈aj Coré, vin̈aj Gatam yed' vin̈aj Amalec. A juntzan̈ eb' vin̈ yajal tic ix el d'a yin̈tilal vin̈aj Elifaz d'a yol yic Edom. Masanil juntzan̈ eb' vin̈ tic, yixchiquin eb' vin̈ ix Ada. ");
INSERT INTO cac_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","A d'a scal eb' yuninal vin̈aj Reuel yuninal vin̈aj Esaú, a eb' ix och yajaliloc chon̈ab': Aton vin̈aj Nahat, vin̈aj Zera, vin̈aj Sama yed' vin̈aj Miza. A eb' yajal tic ix el d'a yin̈tilal vin̈aj Reuel d'a yol yic Edom. Masanil juntzan̈ eb' vin̈ tic, yixchiquin eb' vin̈ ix Basemat yetb'eyum vin̈aj Esaú. ");
INSERT INTO cac_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","A eb' yune' ix Aholibama yisil vin̈aj Aná, yetb'eyum vin̈aj Esaú, ix och yajaliloc chon̈ab': Aton vin̈aj Jeús, vin̈aj Jaalam yed' vin̈aj Coré. ");
INSERT INTO cac_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Masanil juntzan̈ eb' vin̈ yajal tic, yin̈tilal eb' vin̈aj Esaú. ");
INSERT INTO cac_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","A eb' yuninal vin̈aj Seir horeo, a eb' cajan d'a jun lugar chi' ayic manto c'och vin̈aj Esaú: Aton vin̈aj Lotán, vin̈aj Sobal, vin̈aj Zibeón, vin̈aj Aná, ");
INSERT INTO cac_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","vin̈aj Disón, vin̈aj Ezer yed' vin̈aj Disán. Aton eb' tic yajalil chon̈ab' d'a scal eb' horeo, eb' yin̈tilal Seir, d'a yol yic Edom. ");
INSERT INTO cac_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Axo eb' yuninal vin̈aj Lotán, aton eb' tic: Vin̈aj Hori yed' vin̈aj Hemam. Timna sb'i ix yanab' vin̈aj Lotán chi'. ");
INSERT INTO cac_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","A eb' yuninal vin̈aj Sobal, aton eb' tic: Vin̈aj Alván, vin̈aj Manahat, vin̈aj Ebal, vin̈aj Sefo yed' vin̈aj Onam. ");
INSERT INTO cac_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Eb' yuninal vin̈aj Zibeón, aton vin̈aj Aja yed' vin̈aj Aná. Ayic ix stan̈van noc' sb'uru vin̈ smam vin̈aj Aná chi' d'a tz'inan luum, ix ilchaj jun sjaj a a' yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Axo vin̈aj Aná chi', ay jun yuninal vin̈ scuchan Disón, ay pax jun ix yisil vin̈ scuchan Aholibama. ");
INSERT INTO cac_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","A eb' yuninal vin̈aj Disón, aton eb' tic: Vin̈aj Hemdán, vin̈aj Esbán, vin̈aj Itrán yed' vin̈aj Querán. ");
INSERT INTO cac_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","A eb' yuninal vin̈aj Ezer, aton eb' tic: Vin̈aj Bilhán, vin̈aj Zaaván yed' vin̈aj Acán. ");
INSERT INTO cac_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","A eb' yuninal vin̈aj Disán, aton vin̈aj Uz yed' vin̈aj Arán. ");
INSERT INTO cac_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","A eb' yajalil chon̈ab' d'a scal eb' horeo d'a yol yic Seir, aton eb' tic: Vin̈aj Lotán, vin̈aj Sobal, vin̈aj Zibeón, vin̈aj Aná, vin̈aj Disón, vin̈aj Ezer yed' vin̈aj Disán. ");
INSERT INTO cac_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Aton eb' vin̈ tic ix yac' yajalil d'a Edom, ayic mantalaj sreyal eb' israel. ");
INSERT INTO cac_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","A vin̈aj Bela, yuninal vin̈aj Beor aj Dinaba, ix yac' reyal vin̈ d'a Edom. ");
INSERT INTO cac_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ayic ix cham vin̈, ix ochcan vin̈aj Jobab yuninal vin̈aj Zera aj Bosra reyal sq'uexuloc vin̈. ");
INSERT INTO cac_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ayic ix cham vin̈aj Jobab chi', axo vin̈aj Husam aj Temán, ix ochcan reyal sq'uexuloc vin̈. ");
INSERT INTO cac_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ayic ix cham vin̈aj Husam chi', axo vin̈aj Hadad yuninal vin̈aj Bedad aj chon̈ab' Avit ix ochcan reyal sq'uexuloc vin̈. Aton vin̈ ix ac'an ganar eb' aj Madián d'a yol yic Moab. ");
INSERT INTO cac_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ayic ix cham vin̈aj Hadad chi', axo vin̈aj Samla aj Masreca ix ochcan reyal sq'uexuloc vin̈. ");
INSERT INTO cac_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ayic ix cham vin̈aj Samla chi', axo vin̈aj Saúl aj chon̈ab' Rehobot ix ochcan reyal sq'uexuloc vin̈. A jun chon̈ab' Rehobot chi', a d'a sti' a' nivan Éufrates ay. ");
INSERT INTO cac_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ayic ix cham vin̈aj Saúl chi', axo vin̈aj Baal-hanán yuninal vin̈aj Acbor ix ochcan reyal sq'uexuloc vin̈. ");
INSERT INTO cac_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ayic ix cham vin̈aj Baal-hanán chi', axo vin̈aj Hadad aj Pau ix ochcan reyal sq'uexuloc vin̈. Axo ix yetb'eyum vin̈aj Hadad chi', Mehetabel sb'i ix, yune' ix ix Matred, yixchiquin vin̈aj Mezaab. ");
INSERT INTO cac_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Aton sb'i eb' yajalil chon̈ab' ix el d'a yin̈tilal vin̈aj Esaú tic: Vin̈aj Timna, vin̈aj Alva, vin̈aj Jetet, vin̈aj Aholibama, vin̈aj Ela, vin̈aj Pinón, vin̈aj Cenaz, vin̈aj Temán, vin̈aj Mibzar, vin̈aj Magdiel yed' vin̈aj Iram. An̈ejtona' a sb'i eb' ix och d'a junjun lugar b'aj ix ec' eb'. A vin̈aj Esaú chi' Edom pax sb'i vin̈, aton smam yicham eb' edomita. ");
INSERT INTO cac_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","A vin̈aj Jacob ix cann̈ej cajan vin̈ d'a Canaán b'aj ec'nac cajan smam. ");
INSERT INTO cac_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Aton yab'ixal vin̈aj Jacob tic. A vin̈aj José yuninal vin̈aj Jacob, 17 ab'il sq'uinal vin̈, tan̈voj calnel syac' vin̈ yed' eb' vin̈ yuc'tac. A eb' vin̈ yuc'tac vin̈ chi', aton eb' vin̈ yune' ix Bilha yed' ix Zilpa, eb' ix chab'il yetb'eyum vin̈aj Jacob. A vin̈aj José chi' tz'ic'ancot ab'ix d'a vin̈ smam tato man̈ vach'oc syutej sb'a eb' vin̈ yuc'tac vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Te xajan vin̈aj José chi' yuj vin̈ smam d'a yichan̈ juntzan̈xo eb' vin̈ yuc'tac chi', yujto yolxo yichamvinaquil ix alji vin̈. Yuj chi' ix sb'o jun spichul vin̈, tz'ib'iltac yilji. ");
INSERT INTO cac_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","A ix yilan juntzan̈xo eb' vin̈ yuc'tac vin̈ chi' to yelxo val te xajan vin̈aj José chi' yuj vin̈ smam chi', ix te chichon sc'ol eb' vin̈ d'a vin̈, te chuc slolon eb' vin̈ d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","8","Ay jun svayich vin̈aj José chi' ix ochi, ix yalan vin̈ d'a eb' vin̈ yuc'tac chi' icha tic: —Ab'ec val in vayich. Ix in vayichej to van co jochvi trigo, junjun on̈ qued' junjun manoja quico'. D'a jun rato chi' ix q'ue lin̈an ixim vico' yed' ixim eyic chi', axo ixim eyic chi' ix em n̈ojan ixim d'a spatic yichan̈ ixim vic chi', xchi vin̈. Ix tac'vi eb' vin̈ yuc'tac vin̈ chi' icha tic: —¿Am syalelc'och jun tzal chi' to ol ach och co reyaloc? ¿A ach am ol ala' tas ol co c'ulej? xchi eb' vin̈. Ix te cot yoval eb' vin̈ yuj svayich vin̈ ix yal chi'. ");
INSERT INTO cac_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ix lajvi chi' ix och junxo svayich vin̈aj José chi', ix yalanxi vin̈ d'a eb' vin̈ yuc'tac chi' icha tic: —Ay val junxo in vayich ix ochi. A d'a jun in vayich chi' ix vila', to a c'u yed' q'uen uj yed' uxluche' c'anal ix em n̈ojan d'ayin, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ayic ix yalan svayich vin̈ chi' d'a vin̈ smam yed' d'a eb' vin̈ yuc'tac chi', ix cot yoval vin̈ smam vin̈ chi, ix yalan vin̈ d'a vin̈ icha tic: —¿Tas syalelc'och jun a vayich chi? ¿Tom ol in em n̈ojan yed' ix a nun yed' eb' vin̈ uc'tac tic d'a ichan̈? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Icha chi' ix aj sq'ue vaan schichonc'olal eb' vin̈ yuc'tac vin̈ chi' d'a spatic, palta axo vin̈ smam vin̈ chi', ix snaub'tan̈ej val vin̈ tas val syalelc'och jun svayich vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ay jun c'ual ix b'at eb' vin̈ yuc'tac vin̈aj José chi' d'a Siquem say b'aj vach' sva noc' scalnel vin̈ smam eb' vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ix lajvi chi', ix yalan vin̈aj Israel d'a vin̈aj José chi' icha tic: —A ticnaic a eb' vin̈ uc'tac, a d'a Siquem ayec' eb' vin̈ tan̈voj calnel, tzin nib'ej tzach b'at il eb' vin̈, xchi vin̈. —Inye, ol in b'atoc, xchi vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","—Vach' jun, ixic, yic vach' tzila' chajtil yaj eb' vin̈ yed' noc' calnel chi', tzul alan vab'i, xchi vin̈ smam vin̈ chi'. D'a sch'olanil lum Hebrón ayec' vin̈aj José chi' ayic ix checjib'at vin̈ yuj vin̈ smam. Axo yic ix c'och vin̈ d'a yol yic Siquem, ");
INSERT INTO cac_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ix ec'chaj vin̈ sayec' eb' vin̈ yuc'tac chi' ta'. Ay jun vin̈ vinac ix schalaj sb'a vin̈ yed'oc, ix sc'anb'an vin̈ vinac chi' icha tic: —¿Tas tzec' a saya'? xchi vin̈ d'a vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","—To tzin ec' in say eb' vin̈ vuc'tac. ¿Maj am ila' b'ajtil stan̈vej noc' calnel eb' vin̈? xchi vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","—Toxo ix b'at eb' vin̈ d'a tic. Ix vab' yalan eb' vin̈: Vach' tzon̈ b'at d'a Dotán, xchi eb' vin̈ ix vab'i, xchi vin̈ vinac chi'. Ix b'atn̈ej vin̈aj José chi', ix ilchaj eb' vin̈ yuc'tac vin̈ chi' yuj d'a Dotán chi'. ");
INSERT INTO cac_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ayic ix yilanb'at vin̈ eb' vin̈ d'a najat, ayto val sc'och vin̈ d'a eb' vin̈, ix slajtian sb'a eb' vin̈ tas syutej eb' vin̈ smilancham vin̈. ");
INSERT INTO cac_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ix yalan eb' vin̈ icha tic: —Ina sja vin̈ svayichani. ");
INSERT INTO cac_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Co mileccham vin̈, ol co julancanb'at vin̈ d'a yol junoc jul, ol calani to a am junoc noc' noc' chium anima ix chianb'at vin̈. Ol quilan b'ian tas ol aj yelc'och juntzan̈ svayich vin̈ chi', xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ayic ix yab'an juntzan̈ lolonel chi' vin̈aj Rubén, ix snaan vin̈ tas vach' syutej scolanel vin̈aj José chi' d'a yol sc'ab' eb' vin̈, ix yalan vin̈ icha tic: —Maay, man̈ co milecchamlaj vin̈. ");
INSERT INTO cac_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Mocab' och schamel vin̈ chi' co muloc. An̈ejto scaq'uem vin̈ d'a yol junoc yed'tal a' joyb'il d'a tz'inan lum tic. Mocab'a junoc on̈ tz'och co c'ab' d'a vin̈, xchi vin̈. Ix yal jun lolonel chi' vin̈aj Rubén chi', yujto snib'ej vin̈ scolcan vin̈aj José chi', yic vach' syac' meltzaj vin̈ vin̈ d'a vin̈ smam. ");
INSERT INTO cac_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Axo ix c'och vin̈aj José b'aj ayec' eb' vin̈ yuc'tac chi', elan̈chamel ix tzac'jicot vin̈ yuj eb' vin̈. Ix yic'anel spichul vin̈ eb' vin̈ ayochi, aton jun tz'ib'iltac yilji. ");
INSERT INTO cac_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ix lajvi chi' ix ac'jiem vin̈ yuj eb' d'a yol jun yed'tal a' jul yich, malaj a a' d'a yool. ");
INSERT INTO cac_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ix lajvi chi' ix em c'ojan eb' vin̈ vael. Yacb'an chi' jun, ix yilan eb' vin̈ scot jun n̈ilan̈ eb' vin̈ ismaelita ix cot d'a Galaad. A perfume, bálsamo yed' mirra ayoch yib'an̈ scamello eb' vin̈, sb'at eb' vin̈ schon̈ d'a Egipto. ");
INSERT INTO cac_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ix yalan vin̈aj Judá d'a eb' yuc'tac chi' icha tic: —¿Tas scac' ganar sco milancham vin̈ cuc'tac tic, sco c'ub'aneli to maj quila' b'aj ix cham vin̈? ");
INSERT INTO cac_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Vach' ama to sco chon̈b'at vin̈ d'a eb' vin̈ ismaelita van sja tic. Mocab' co milcham vin̈ yujto cuc'tac co b'a yed' vin̈, xchi vin̈. Ix schaan sc'ol eb' vin̈ chi' tas ix yal vin̈aj Judá chi'. ");
INSERT INTO cac_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Axo yic ix ec' eb' vin̈ aj Madián chi', elan̈chamel ix ic'chajq'ueta vin̈aj José d'a yol jun jul chi', ix schon̈anb'at vin̈ eb' vin̈ d'a eb' vin̈ chon̈vajum chi'. 20 siclo plata ix yac' eb' vin̈ d'a eb' vin̈ stojoloc. Icha chi' ix aj yic'chajb'at vin̈aj José chi' d'a Egipto. ");
INSERT INTO cac_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ayic ix jax vin̈aj Rubén chi', ix b'at vin̈ yil d'a sti' jun jul chi', man̈xalaj vin̈aj José chi' ayeq'ui. Ix sn̈ic'chitanb'at sjaj spichul vin̈ yuj scusc'olal. ");
INSERT INTO cac_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ix b'at lemnaj vin̈ d'a eb' vin̈ yuc'tac chi', ix yalan vin̈ icha tic: —Man̈xo ayoquem vin̈ cuc'tac d'a jun jul chi'. ¿Tas vach' tzin c'ulej ticnaic? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","A d'a jun rato chi', ix smilancham jun noc' yune' chiva eb' vin̈. Ix yic'anelta schiq'uil noc' eb' vin̈, ix sb'on̈anoch eb' vin̈ d'a spichul vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ix yac'anb'at jun pichul chi' eb' vin̈ d'a vin̈ smam, ix yalanb'at eb' vin̈ icha tic: Ix ilchaj jun pichul tic cuuj, ilnab'i talaj a spichul vin̈ uninal, xchib'at eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ayic ix yilan vin̈aj Jacob, to aton spichul vin̈aj José, ix yalan vin̈ icha tic: Ay... aton val spichul vin̈ vuninal tic. Ay am val junoc noc' schi'an anima ix tzilchitanb'at vin̈, ix schianb'at vuninal, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ix lajvi chi', ix sn̈ic'chitanel spichul vin̈, ix yac'anoch jun pichul vin̈ yic cusc'olal. Te nivan tiempo ix oc' vin̈ yuj vin̈ yunin chi'. ");
INSERT INTO cac_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Masanil eb' yuninal vin̈ yed' eb' ix yisil vin̈, ix yac'lej eb' yac'an snivanil sc'ol vin̈, palta max yal-laj sc'ol vin̈ tz'ac'ji snivanil sc'ool. Tz'oc'n̈ej vin̈ yuj vin̈ yuninal chi'. Ix yalan vin̈ icha tic: Ol te cusn̈ej val in c'ool yuj vin̈ vuninal masanto ol in b'at b'aj ayec' vin̈ d'a scal eb' chamnac, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Axo eb' vin̈ aj Madián chi', ayic ix c'och eb' vin̈ d'a Egipto chi', ix schon̈anxib'at vin̈aj José chi' eb' vin̈ d'a vin̈aj Potifar, yajal eb' stan̈van vin̈ rey d'a Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","A d'a jun tiempoal chi', a vin̈aj Judá ix spojel sb'a vin̈ d'a eb' yuc'tac, ix b'at cajnaj vin̈ d'a slac'anil jun vin̈ vinac scuchan Hira, aj chon̈ab' Adulam. ");
INSERT INTO cac_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ata' ix yiloch ix yisil jun vin̈ aj Canaán scuchan Súa vin̈, ix yic'lan sb'a vin̈ yed' ix. ");
INSERT INTO cac_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ix scuchanoch yune' ix. Ayic ix alji yune' ix chi', Er ix sb'iej. ");
INSERT INTO cac_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ix lajvi chi' ix scuchanxioch yune' ix. Ayic ix alji yune' ix chi', Onán ix yac' ix sb'iej. ");
INSERT INTO cac_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ix scuchanoch junxo yune' ix. Ayic ix alji, Sela ix yac' ix sb'iej. A d'a Quezib ayec' vin̈aj Judá chi' ayic ix alji vin̈ unin chi'. ");
INSERT INTO cac_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Axo yic ix quelemax vin̈aj Er b'ab'el unin chi', ix sayji yetb'eyum vin̈ yuj vin̈aj Judá chi', ix yic'an ix Tamar vin̈. ");
INSERT INTO cac_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Te chuc ix yutej sb'a vin̈aj Er chi' d'a yichan̈ Jehová, yuj chi' ix cham vin̈ yuuj. ");
INSERT INTO cac_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ix lajvi chi' ix yalan vin̈aj Judá d'a vin̈aj Onán icha tic: —Ic'laj a b'a yed' ix yetb'eyum vin̈ uc'tac chamnac, tza c'anab'ajej co ley, ichato yin̈tilal vin̈ uc'tac chi' ol elcan uuj yed' ix, xchi vin̈aj Judá chi'. ");
INSERT INTO cac_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Palta yojtac vin̈aj Onán chi' to a unin ol aljoc chi', man̈ yicoc vin̈ ol aj yed' ix smu' chi', yuj chi' juntac el svay vin̈ yed' ix, axo yin̈atil vin̈ syac'canem vin̈ d'a sat luum yic max och ix yab'ixal, yic vach' max elcanlaj yin̈tilal vin̈ yuc'tac vin̈ chi' snaani. ");
INSERT INTO cac_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","A tas ix sc'ulej vin̈ chi', chuc d'a sat Jehová, yuj chi' ix cham vin̈. ");
INSERT INTO cac_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ix lajvi chi', ix yalan vin̈aj Judá d'a ix yalib' chi' icha tic: —A ticnaic vach' tzach paxcan yed' a mam a nun. Malaj junocxo vinac vach' tzic'a'. Ato yic ol c'och sq'uinal vin̈aj Sela vuninal, ichato chi' ol yal ic'an a b'a yed' vin̈, xchi vin̈aj Judá chi'. Ton̈ej ix yal vin̈ icha chi', q'uinaloc schampax vin̈aj Sela chi' snaan vin̈, icha ix aj scham chavan̈ eb' vin̈ yuc'tac. Icha chi' ix aj sb'at ix Tamar yic scajnaj ix yed' smam snun. ");
INSERT INTO cac_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Pecatax chi' ix cham ix yetb'eyum vin̈aj Judá chi', ix yisil vin̈aj Súa. Ix lajvi yec'b'at scusc'olal vin̈, ix b'at vin̈ d'a chon̈ab' Timnat b'aj van sjoxchajel xil noc' scalnel, axo jun vin̈ yamigo vin̈ scuchan Hira ix b'at yuc'levoc. ");
INSERT INTO cac_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Axo yic ix yab'an specal ix Tamar to van sb'at vin̈aj Judá d'a Timnat yil sjoxchajel noc' scalnel, ");
INSERT INTO cac_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","d'a elan̈chamel ix yiq'uel spichul ix, aton c'apac syac'och eb' ix chamnac yetb'eyum. Ix yac'anoch jun smusil sat ix, yic vach' malaj mach snaaneli tato a ix. Ix em c'ojan ix d'a stiel chon̈ab' b'aj sc'och sb'eal chon̈ab' Enaim, d'a sb'eal Timnat chi'. Ix sc'ulej jun tic ix, yujto ix nachajel yuj ix to a vin̈aj Sela ix q'uib'el vin̈, palta maxto yic'laj sb'a vin̈ yed' ix. ");
INSERT INTO cac_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ayic ix yilanb'at ix vin̈aj Judá chi', ix snaan vin̈ to ajmul ix jun ix chi', yujto musab'il sat ix. ");
INSERT INTO cac_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ix el vin̈aj Judá chi' d'a yol b'e, ix b'at vin̈ yilb'at ix. Man̈ yojtacoc vin̈ tato a ix yalib' vin̈. Ix yalan vin̈ d'a ix icha tic: —¿Max am yal a c'ool tzin vay ed'oc? xchi vin̈. —Tato syal in c'ool ¿tas junoc tzac' d'ayin? xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","—Ol vac'cot junoc yune' a chiva, xchi vin̈ d'a ix. —Tzam yala', an̈ej tato ay junoc tas tzac'can d'ayin ticnaic. Ayic sjavi noc' in yune' chiva chi', svac'anxi meltzaj d'ayach, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","—¿Tas pax tza nib'ej svac'can d'ayach? xchi vin̈aj Judá chi'. —Ac'can a sello yed' sch'an̈al yed' a c'ococh ed'nac, xchi ix. —Syala', canocab'i, xchi vin̈. Ix lajvi chi' ix vay vin̈ yed' ix, ix scuchancanoch yune' ix. ");
INSERT INTO cac_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ix lajvi chi', ix b'at ix, ix yic'anel smusil sat ix chi', ix yac'anxioch sc'apac ix syac'och eb' ix chamnac yetb'eyum. ");
INSERT INTO cac_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ayic ix c'och vin̈aj Judá b'aj ayec' noc' scalnel chi', ix schecancot vin̈ yamigo vin̈, aton vin̈ aj Adulam, ix b'at yac'ancan noc' yune' chiva chi' vin̈ d'a ix ix chi' yic syic'paxta tas aycan chi' d'a ix yuj vin̈aj Judá chi' yalani, palta majxo ilchajlaj ix yuj vin̈ schecab' vin chi'. ");
INSERT INTO cac_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ix sc'anb'anec' vin̈ d'a eb' aj chon̈ab' chi' icha tic: —¿B'ajtil ay jun ix ajmul ix d'a tic, jun ix tz'emn̈ej c'ojan d'a sti' sb'eal Enaim tic? xchi vin̈ checab' chi'. —Malaj junoc ix ajmul ix d'a tic, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ix lajvi chi' ix meltzajxi vin̈ d'a vin̈aj Judá chi', ix yalan vin̈: —Majxo ilchajlaj ix vuuj, ix yal eb' vin̈ ayec' chi' ta' to malaj junoc ix ajmul ix b'aj ay eb' chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ix tac'vi vin̈aj Judá icha tic: —Canocab' ix yed' juntzan̈ chi', yic vach' max el co q'uixvelal. Ix in c'anab'ajej, ix vac'anb'at noc' yune' chiva, an̈ej to majxo ilchaj ix uuj, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Yoxil xom ujal chi', ix b'at alchaj d'a vin̈aj Judá icha tic: —A ix Tamar, ix alib', ay am mach ix sc'umej ix, yuj chi' yab'ixxo ix ticnaic, xchi eb' vin̈ d'a vin̈. Ix yalan vin̈: —Iq'uequel ix d'a stiel chon̈ab' yic tze n̈usantz'a ix, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ayic van yic'jielta ix yuj eb' vin̈, ix yac'anb'at schecab' ix d'a vin̈aj Judá chi', ix yalan icha tic: A vin̈ ay yic juntzan̈ svac'b'at tic, aton vin̈ ay yic unin ved'nac tic. B'eyc'olej mach ay yic jun sello yed' sch'an̈al tic yed' jun c'ococh tic, xchib'at ix d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ayic ix yilanoch vin̈aj Judá to yic masanil juntzan̈ chi' vin̈, ix yalan vin̈ icha tic: A ix ix chi' vach' tas ix sc'ulej ix. A in chuc tas ix in c'ulej. Ay in mul. Maj vac'laj yic' sb'a ix yed' vin̈ vuninal aj Sela, xchi vin̈. Yuj chi' maj n̈usjitz'alaj ix. Majxo vaylaj vin̈ yed' ix junelxo. ");
INSERT INTO cac_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Axo ix b'o sc'ol ix Tamar chi', tiox eb' unin ix alji chi'. ");
INSERT INTO cac_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ayic van yalji eb' unin chi', ayic ix elul sc'ab' jun b'ab'el, ix spixanoch jab' chac ch'al ix vetz'vajum d'a sjaj sc'ab' jun unin chi', ix yalan ix: Aton jun b'ab'el tic, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Palta ix yic'anxioch sc'ab' jun nene' chi', axo junxo yuc'tac chi' ix alji sb'ab'elal, yuj chi' Fares ix sb'iej yuj ix vetz'vajum chi'. Ix yalan ix: ¿Tas yuj ix a b'ab'laj equejelta a b'a? xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ix lajvi chi' ix alji vin̈ nene' ayoch an̈ chac ch'al chi' d'a sjaj sc'ab', Zara ix sb'iej yuj ix. ");
INSERT INTO cac_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ayic ix c'och vin̈aj José yuj eb' vin̈ ismaelita d'a Egipto chi', ay jun vin̈ scuch Potifar ix mananel vin̈. A jun vin̈ chi', nivan yopisio vin̈ d'a vin̈ sreyal Egipto, yajal yaj vin̈ d'a eb' soldado stan̈van vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","A Jehová ayoch yed' vin̈aj José chi', te vach'n̈ej yajec' vin̈ d'a spat vin̈ spatrón chi'. ");
INSERT INTO cac_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ix nachajel yuj vin̈ spatrón vin̈ chi' to ay val och Jehová yed' vin̈, vach'n̈ej tz'elc'och vin̈ d'a smasanil. ");
INSERT INTO cac_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yuj chi', te vach'n̈ej vin̈aj José d'a yichan̈ vin̈ spatrón chi'. Ix yac'och vin̈ vin̈ stan̈vumaloc spat yed' masanil tastac ay d'ay. ");
INSERT INTO cac_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Yictax ix yac'anoch vin̈ vin̈aj Potifar chi' stan̈vumaloc spat chi', ix yac' svach'c'olal Jehová d'a yib'an̈ vin̈aj Potifar chi' yed' masanil tas ay d'a vin̈. Yujn̈ej vin̈aj José chi' ix q'uechaan̈ svach'c'olal d'a spat vin̈ yed' d'a najateli. ");
INSERT INTO cac_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ix cann̈ej vin̈aj José chi' stan̈vumaloc smasanil, yuj chi' man̈xalaj tas ix sna' vin̈aj Potifar chi', palta an̈ej tas tz'aj sb'o svael vin̈ syila'. Te vach' yilji vin̈aj José chi', te vach' pax snivanil vin̈ smasanil. ");
INSERT INTO cac_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ix ec' jab'oc tiempoal, axo ix yetb'eyum vin̈aj Potifar chi', ix te can sgana ix d'a vin̈aj José chi'. Ix yalan ix d'a vin̈ icha tic: —Octom val syal a c'ool tzach vay ved'oc, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Te maj schalaj sc'ol vin̈aj José tas ix yal ix chi'. Ix yalan vin̈ icha tic: —Maay, ojtac ach tic to ix in yac'och vin̈ etb'eyum stan̈vumaloc masanil stastac d'a tic. Ina man̈xo jab'oc tas sna' vin̈ yuj masanil stastac yacb'an ay in eq'ui. ");
INSERT INTO cac_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Malaj junocxo mach nivan yelc'och d'a vichan̈ d'a jun pat tic. Masanil tastac ayoch d'a yol in c'ab', an̈ej d'ayach a ach tic, max yal-laj vac'anoch in c'ab', yujto yetb'eyum ach vin̈ in patrón, ¿tom ol yal in c'ulan jun nivan chucal, yic tz'och in mul d'a sat Dios? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ix ochn̈ej ijan ix stevioch d'a vin̈. Junjun c'u syal ix to svay vin̈ yed' ix, palta juneln̈ej max ochlaj d'a sc'ol vin̈ svay yed' ix, max yalpaxlaj sc'ol vin̈ sc'och b'aj ayec' ix. ");
INSERT INTO cac_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ay jun c'u ix och vin̈aj José chi' d'a yol pat yic smunlaji, malaj junocxo mach ayeq'ui, an̈ej ix. ");
INSERT INTO cac_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Axo ta' ix och tzuctzuc ix d'a spichul vin̈, ix yalan ix icha tic: —Vayan̈ ved'oc, xchi ix. Axo ix yab'an jun chi' vin̈, ix spich'anel sb'a vin̈ d'a yol sc'ab' ix. Ix elta lemnaj vin̈ d'a ti pat, axo spichul vin̈ ix can d'a yol sc'ab' ix. ");
INSERT INTO cac_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ayic ix yilan ix to ix el lemnaj vin̈, ix can spichul vin̈ d'a yol sc'ab' ix, ");
INSERT INTO cac_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ix el yav ix, ix yavtancot eb' munlajvum ix d'a slac'anil pat chi', ix yalan ix: —Ilec val jun vin̈ hebreo ix yic'cot vin̈ vetb'eyum tic. A vin̈ tic, snib'ej vin̈ tzin yixtej. Ix ochul lemnaj vin̈ d'a yol pat tic, snib'ej vin̈ svay ved'oc, palta chaan̈ ix el vav. ");
INSERT INTO cac_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ayic ix yab'an vin̈ yel vav chi', ix el lemnaj vin̈, axon̈ej spichul vin̈ ix cani, xchi ix. ");
INSERT INTO cac_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ix sic'ancan jun spichul vin̈ chi' ix masanto ix jax vin̈ spatrón vin̈ chi' d'a spat. ");
INSERT INTO cac_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ix yalan ix icha ix aj yalan d'a sb'ab'elal chi': —A vin̈ hebreo ix ic'cot checab'oc tic, ix ochul vin̈ d'a yol in cuarto, sgana vin̈ ix vay ved'oc. ");
INSERT INTO cac_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Palta te chaan̈ ix el vav, yuj chi' ix el lemnaj vin̈, axon̈ej spichul vin̈ ix yactejcan d'a tic. ");
INSERT INTO cac_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Icha val chi' ix in yutej jun vin̈ a checab' tic, xchi ix. Axo vin̈ spatrón vin̈aj José chi', ix te cot yoval vin̈ sic'lab'il ayic ix yab'an vin̈ tas ix yal ix yetb'eyum chi'. ");
INSERT INTO cac_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ix schecan yamjoc vin̈aj José chi' vin̈, ix yalan vin̈ to tz'och vin̈ d'a preso b'aj ayoch juntzan̈ eb' vin̈ d'a preso yuj vin̈ rey. ");
INSERT INTO cac_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Palta ayn̈ejoch Jehová yed' vin̈aj José chi', ix sch'oxn̈ej svach'c'olal d'a vin̈. Yuj chi' te vach' ix elc'och vin̈ d'a yol sat vin̈ tan̈vum preso chi'. ");
INSERT INTO cac_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Axo vin̈ tan̈vum preso chi' ix ac'anoch vin̈ stan̈vumaloc eb' yetpresovumal chi'. Ix ac'jipaxoch vin̈ yilumaloc tastac ix sb'o eb' d'a preso chi'. ");
INSERT INTO cac_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","A vin̈ stan̈vumal preso chi', man̈xalaj tas sna vin̈, masanil tas aycanoch d'a yol sc'ab' vin̈aj José chi' yuj vin̈. Yujto ayn̈ejoch Jehová yed' vin̈, yuj chi' vach'n̈ej ix elc'och smasanil. ");
INSERT INTO cac_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ix lajvi chi', ay chavan̈ vinac ix och preso: A jun vin̈, yajal yaj vin̈ d'a eb' vin̈ tz'ac'an svino vin̈ rey, axo junxo vin̈, yajal yaj vin̈ d'a eb' vin̈ b'oum pan sva vin̈ rey chi'. Ay smul eb' vin̈ ix och d'a vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Yuj chi' ix cot yoval vin̈ d'a eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ix yalan vin̈ rey to tz'ac'jioch eb' vin̈ d'a preso d'a spat vin̈ yajal d'a eb' soldado stan̈van vin̈, aton ta' aypaxoch vin̈aj José d'a preso. ");
INSERT INTO cac_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","An̈eja' d'a yol sc'ab' vin̈aj José chi' ix can eb' vin̈ chavan̈ smunlajvum vin̈ rey chi' yuj vin̈ yajal preso chi' yic a vin̈ tz'ac'an servil eb' vin̈. Ix can eb' vin̈ jun tiempoal d'a preso chi'. ");
INSERT INTO cac_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Axo d'a jun ac'val ix och svayich eb' vin̈ chavan̈ chi', junjun vayich chi' ay syalelc'ochi. ");
INSERT INTO cac_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Axo ix sacb'i ix c'och vin̈aj José yil eb' vin̈. Ix yilan vin̈ to te ayoch eb' vin̈ d'a ilc'olal. ");
INSERT INTO cac_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ix sc'anb'an vin̈ d'a eb' vin̈: —¿Tas yuj te cuseltac yilji e sat? xchi vin̈ d'a eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","—Ay val co vayich ix och d'a jun ac'val tic, palta malaj mach d'a tic tz'alan d'ayon̈ tas syalelc'ochi, xchi eb' vin̈. —¿Tom man̈oc Dios syal yalani tas syalelc'och vayich? Alec d'ayin tas ix e vayichej chi', xchi vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Yuj chi' a vin̈ yajal yaj d'a eb' vin̈ tz'ac'an svino vin̈ rey, ix och ijan vin̈ yalan svayich chi' d'a vin̈aj José icha tic: —A d'a in vayich, ix vil jun te' uva, ");
INSERT INTO cac_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ay oxe' sc'ab' te'. Ix vil sq'ueta svol, ix yac'an xumaquil, axo xumaquil chi', ix och b'uyan sat, te q'uin̈xo. ");
INSERT INTO cac_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","A ix vilani to yamb'ilq'ue scopa vin̈ rey vuuj, ix vic'ancot sat te' uva chi', ix in pitz'anem yal d'a yol scopa vin̈ rey chi', ix vac'anoch d'a yol sc'ab' vin̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ix yalan vin̈aj José d'a vin̈ icha tic: —Ichaton tic syalelc'och a vayich chi': A oxe' sc'ab' te' uva ix il chi', oxe' c'ual syala'. ");
INSERT INTO cac_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ayic chab'ej ticnaic ol sb'eyc'olej a mul vin̈ rey chi'. Ol lajvoc chi' ol ach yac'anxioch vin̈ d'a a munlajel, ol ac'xi scopa vin̈ chi' icha d'a yalan̈taxo. ");
INSERT INTO cac_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ayic ol elc'och jun sval tic, tzin a naancot d'a vin̈ rey chi', yic vach' tzin elpax d'a yol preso tic. Oc'ocab' a c'ol d'ayin. ");
INSERT INTO cac_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","A in tic ichato elc'ab'il in cot d'a scal eb' vin̈ hebreo. Man̈ in mojoc ay in och d'a preso tic, yujto malaj jab'oc tas chuc ix in c'ulej, xchi vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ayic ix yab'an vin̈ yajalil eb' vin̈ sb'oan ixim pan to a vin̈aj José vach' ix aj yalanel svayich vin̈ chi' vin̈, ix yalanpax vin̈ icha tic: —A in tic ix in vayichej to ayq'ue oxe' mooch ixim pan d'a in jolom. ");
INSERT INTO cac_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","A d'a yol jun yune' mooch d'a jun yoxil ayq'ue d'a in jolom chi', tzijtum macan̈il ixim pan ayem d'a yool yic sva vin̈ rey, palta axo noc' much ix javi ix stzoc'anq'ueta ixim noc' d'a yol te' mooch chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ix yalanxi vin̈aj José d'a vin̈ icha tic: —A tas syalelc'och a vayich chi', aton tic: A oxe' mooch chi' sch'oxcot oxe' c'ual. ");
INSERT INTO cac_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Yuj chi' yic chab'ej ticnaic, ol sb'eyc'olej vin̈ rey tas yaj a mul. Slajvi chi' ol schecan vin̈ ic'chajel a jolom, a a nivanil ol ac'jocq'ue d'a schon jun te te', axo noc' ostoc ol ja schib'at a nivanil chi', xchi vin̈aj José chi' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Schab'jial val yalan svayich eb' vin̈ chavan̈ chi' vin̈aj José chi', ix yac'an sq'uin̈al yab'ilal vin̈ rey. Ix yavtancot vin̈ masanil eb' vin̈ nivac vinac ayoch yajalil yed'oc. D'a yichan̈ eb' vin̈ nivac yajal chi' ix checji ic'chajelta eb' vin̈ chavan̈ ayoch d'a preso chi'. ");
INSERT INTO cac_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","A vin̈ tz'ac'an svino vin̈ rey, ix ac'chajxioch vin̈ d'a smunlajel. ");
INSERT INTO cac_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Axo vin̈ yajal yaj d'a eb' sb'oan ixim pan, ix yal vin̈ rey to smiljicham vin̈ icha val ix aj yalan vin̈aj José. ");
INSERT INTO cac_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Palta majxo nachajcot vin̈aj José yuj vin̈ tz'ac'an svino vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Axo yic toxo ix ec'b'at chab' ab'il, ay jun ac'val ix och svayich vin̈ rey. Ix yil vin̈ to lin̈anec' vin̈ d'a sti' a' nivan Nilo. ");
INSERT INTO cac_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A d'a yol a' chi', ix q'ueul ucvan̈ noc' vacax te vach', te b'aq'uech, sva noc' d'a sti' a' chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ix lajvi chi' ix q'ueul ucvan̈xo noc' vacax te chuclaj yilji, te b'ac, ix b'at noc' d'a slac'anil noc' b'aq'uech chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ix och ijan noc' b'ac chi' schianb'at noc' b'aq'uech chi'. Ix lajvi chi', ix el svayan̈ vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ix vayxib'at vin̈. Axo ix yilan vin̈ to ay jun pitan̈ ixim trigo ix q'uib'i, uque' val ix aj sjolom ixim, te vach', b'ud'an val yuj sat. ");
INSERT INTO cac_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ix yilanpax vin̈ d'a spatictac ixim b'ab'el chi', ix elpaxcot uquexo jolom trigo te malaj sat, nab'a pach'uch'tac, malaj jab'oc svach'il. ");
INSERT INTO cac_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","A uque' jolom trigo te pach'uch'tac chi', a' ix c'uxanb'at ixim uque' te ay sat chi'. Axo yic ix el svayan̈ vin̈ rey chi', ix nachajel yuj vin̈ to van svayichan vin̈. ");
INSERT INTO cac_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Axo ix sacb'i, te tacnaquel sc'ol vin̈ yuj svayich chi'. Ix schecan vin̈ avtajcot masanil eb' syal snaan el lolonel d'a Egipto yed' eb' te yojtac yalani. Ix och ijan vin̈ rey chi' yalan svayich chi' d'a eb', palta malaj junoc eb' syal yalani tas syalelc'och svayich vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Yuj chi' axo vin̈ yajal yaj d'a eb' tz'ac'an svino vin̈ rey chi' ix alan d'a vin̈ icha tic: —Ato val ticnaic sja d'a in c'ool to ay jun in paltail ix vac'ochi. ");
INSERT INTO cac_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ayic ix cot oval d'ayin yed' vin̈ yajal eb' b'oum pan, ix on̈ ac'och d'a yol sc'ab' vin̈ yajal eb' tzach tan̈vani, ix on̈ ochcan d'a preso. ");
INSERT INTO cac_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ay jun ac'val ix och co vayich co chavan̈il, junjun co vayich chi' ay syalelc'ochi. ");
INSERT INTO cac_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ata' ayec' jun vin̈ quelem hebreo, schecab'ejnac vin̈ yajal eb' vin̈ tzach tan̈van chi'. Ix calan co vayich chi' d'a vin̈. Te vach' ix yutej vin̈ yalan tas syalelc'och co vayich chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Icha val ix aj yalan vin̈ chi', icha chi' ix aj yelc'ochi. Ina ix in ochxi d'a in munlajel, axo junxo vin̈ ved'nac chi, ix ac'jiq'ue d'un̈an snivanil vin̈, xchi vin̈ yac'umal svino vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ix lajvi yab'an jun ab'ix vin̈ rey chi', ix schecan vin̈ ic'jielta vin̈aj José d'a yol preso. Elan̈chamel ix b'at ic'chajelta vin̈, ix yac'an joxchajel sb'a vin̈, ix sq'uexanel spichul vin̈, ix b'at vin̈ d'a yichan̈ vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ix yalan vin̈ rey chi' d'a vin̈ icha tic: —Ay val jun in vayich. Malaj junoc eb' vin̈ ay d'a tic snachajel yuuj tas syalelc'ochi. Ix vab' specal tob' snachajel uuj tas syalelc'och vayich, xchi vin̈ rey chi' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","—A jun chi' man̈ yoloc vic snachajel vuuj, palta a Dios ol alanoc tas tz'elc'och a vayich chi' yic tz'och a vach'iloc, xchi vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ix och ijan vin̈ rey yalan svayich d'a vin̈aj José chi' icha tic: —A ix vilani to lin̈an in ec' d'a sti' a' Nilo. ");
INSERT INTO cac_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","D'a yol a' chi' ix q'ueul ucvan̈ noc' vacax te vach', te b'aq'uech. Ix vaec' noc' d'a stitac a' chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ix lajvi chi' ix q'uepaxul ucvan̈xo noc' te b'ac, chuclaj yilji noc'. Manta b'aj svil junoc vacax chuclaj yilji icha noc' chi' d'a Egipto tic. ");
INSERT INTO cac_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","A ucvan̈ noc' b'ac chi', a noc' ix chianb'at ucvan̈ noc' b'aq'uech b'ab'el ix q'ueul chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ayic ix lajviel noc' b'aq'uech schianb'at noc' b'ac chi', an̈eja' b'ac ix ajcan noc', maj b'aq'uechb'oclaj jab'oc noc'. Ix lajvi chi', ix el in vayan̈. ");
INSERT INTO cac_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ix cotxi in vayan̈, ix in vayichanxi. Ix vilani, ay jun pitan̈ ixim trigo uque' val sjolom ix yac'a', te b'ud'an yuj sat. ");
INSERT INTO cac_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ix lajvi chi' ix elpaxul uquexo sjolom, palta ton̈ej pach'uch'tac, malaj sat. ");
INSERT INTO cac_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Axo ixim chi' ix c'uxanb'at ixim vach' ay sat chi'. Ix val in vayich tic d'a eb' vin̈ snachajel yuj yalani, palta malaj val junoc eb' vin̈ syal snachajel yuj tas syalelc'ochi, xchi vin̈ rey chi' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ix yalan vin̈aj José chi' icha tic: —Mamin rey, a chab' a vayich chi', junn̈ej tas syalelc'ochi. A Dios ix ac'an a vayichej tas nab'il yuuj. ");
INSERT INTO cac_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","A val syalelc'och noc' ucvan̈ vacax b'aq'uech chi', uque' ab'il sch'oxo'. An̈eja' uque' sjolom ixim trigo te vach' chi', an̈ejtona' chi' syala'. ");
INSERT INTO cac_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","A pax ucvan̈ noc' vacax te b'ac, chuclaj yilji ix q'ueul chi', an̈eja' uque' ab'il pax sch'oxo'. An̈eja' ixim jolom trigo te pach'uch'tac, malaj jab'oc sat, uque' ab'il vejel syalelc'ochi. ");
INSERT INTO cac_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","A tas ix val d'ayach tic, ichaton chi' syalelc'och a vayich chi'. A Dios ix ac'an a vayichej tas nab'ilxo yuuj. ");
INSERT INTO cac_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ol ja uque' ab'il, te vach' ol aj sat avb'en d'a Egipto tic. ");
INSERT INTO cac_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ol lajvoc chi', ol ja uque' ab'il vejel. Ayic chi' man̈xa mach ol naancot jantac sat avb'en ix yac' sobre d'a Egipto tic ayic yec'nac uque' d'a yalan̈taxo, yujto a vejel chi' ol ixtancanb'at jun chon̈ab' tic. ");
INSERT INTO cac_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Te nivan vejel ol yutej sb'a. Man̈xalaj b'aj ol checlaj jab'ocxo tas ix yac' sobre d'a jun tiempoal vach' ix ec' chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Chael val ix aj yoch a vayich chi' yic vach' snachajel uj sic'lab'il to nab'ilxo yuj Dios to ol elc'och d'a elan̈chamel. ");
INSERT INTO cac_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Yuj chi, vach' tato tza say junoc vinac te jelan, te ay spensar. Tzac'anoch vin̈ yajalil d'a yol nación tic. ");
INSERT INTO cac_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Tza sayanpax jayvan̈ocxo eb' vin̈ ol och yajalil, sb'at eb' vin̈ d'a masanil yol nación yic tz'ec' eb' vin̈ smol chab' almul d'a junjun quintal avb'en tz'el d'a sat luum chi' d'a junjun ab'il, masanto slajvi uque' ab'il ol ste aq'uej sat avb'en chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Masanil jantac syac' sobre smolb'an eb' vin̈ chi', syac'can eb' vin̈ d'a yol a c'ab', sic'chajcanb'at d'a junjun chon̈ab' d'a yol yic Egipto tic, yic vach' ay tas sva eb' anima. ");
INSERT INTO cac_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Masanil tas ol sic'chajcanb'at chi', a' ol sva eb' anima ayic ol ja uque' ab'il vejel chi', yic vach' max ixtaxel jun chon̈ab' tic yuj vejel, xchi vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","A jun ix yal vin̈aj José chi', ix scha sc'ol vin̈ rey yed' masanil eb' ayoch yajalil yed'oc. ");
INSERT INTO cac_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ix yalan vin̈ rey chi' d'a eb' icha tic: —Ma chequel tato ay b'aj ol chax junocxo vinac cuuj to ayoch Yespíritu Dios yed'oc icha val jun vin̈ tic, xchi vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ix yalan vin̈ d'a vin̈aj José chi' icha tic: —Malaj mach jelan, malaj mach ay spensar icha ach tic, yujto a Dios tz'ac'an ojtaquejel masanil juntzan̈ tic. ");
INSERT INTO cac_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","A ach ol ach ochcan yajalil d'a in despacho tic. Masanil anima ol c'anab'ajan tas ol ala'. A inxon̈ej nivan velc'och d'a ichan̈, yujto rey in. ");
INSERT INTO cac_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","A in tzach vac'och gobernadoral d'a masanil yol yic Egipto tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ayic ix yalan jun lolonel chi' vin̈, ix yic'anel scolc'ab' vin̈ ayoch d'a sc'ab' b'aj ayoch sello, ix yac'anoch vin̈ d'a sc'ab' vin̈aj José chi'. Ix schecan vin̈ rey chi' ac'jioch spichul vin̈aj José chi' to a lino te vach'. Tz'ac'jioch junoc cadena nab'a oro d'a sjaj vin̈. ");
INSERT INTO cac_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ix checchajq'ue vin̈ d'a yol carruaje, aton jun schab'il yic vin̈ rey chi', ix schecan vin̈ to schecjiel eb' anima d'a yol b'e ayic tz'ec' vin̈aj José chi'. Icha chi' ix aj yochcan vin̈aj José chi' gobernadoral yed' yilumaloc masanil chon̈ab' Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ix lajvi chi' ix yalan vin̈ rey d'a vin̈aj José chi' icha tic: —A in tic rey in, palta malaj junoc mach syal yalan d'a yol chon̈ab' tic, tato man̈oc ach tzala', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Zafnat-panea ix yac' vin̈ rey sb'iej vin̈aj José chi', ix yac'an vin̈ rey chi' yic'laj sb'a vin̈ yed' ix Asenat, yisil jun vin̈ Potifera sb'i, sacerdote yaj vin̈ d'a yol chon̈ab' On. 30 ab'il sq'uinal vin̈aj José chi' ayic ix ic'jib'at vin̈ d'a yichan̈ vin̈ rey chi'. Ix lajvi chi', ix elta vin̈aj José chi' d'a yichan̈ vin̈ rey chi', ix b'at vin̈ d'a yol masanil chon̈ab' d'a yol yic Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","A d'a uque' ab'il, man̈ jantacoc sat masanil avb'en ix yac'a'. ");
INSERT INTO cac_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Masanil ixim trigo ix yac' sobre d'a uque' ab'il chi', ix sic'chajb'at ixim d'a junjun chon̈ab' yuj vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Icha yarenail sti' a' mar, icha val chi' yilji ixim trigo ix molchaj yuj vin̈. Te nivanxo ixim trigo chi', yuj chi' majxo echtajlaj ixim, maxtzac yal-laj sb'ischaji. ");
INSERT INTO cac_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ayic manto el yich jun nivan vejel chi', chavan̈xo yuninal vin̈aj José yed' ix Asenat chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","A vin̈ b'ab'el unin, Manasés ix yac' vin̈ sb'iej, ix yalan vin̈: A Dios ix ac'an sat d'a in c'ol masanil syaelal ix ec'b'at d'a vib'an̈ yed' in cusc'olal yuj eb' ayto vuj in b'a yed'oc, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Axo jun vin̈ schab'il unin, Efraín ix yac' vin̈ sb'iej, ix yalan vin̈: A Dios ix ac'an svach'c'olal d'ayin d'a jun lugar b'aj ix vab' syaelal tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ix lajvi yec' uque' ab'il ayic man̈ jantacoc svach'il ix aj sat avb'en d'a Egipto, ");
INSERT INTO cac_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ix schaanel yich uque' ab'il vejel chi', icha ix aj yalan vin̈aj José. Ix japax nivan vejel d'a yol masanil nación d'a slac'anil chi'. Axo d'a masanil yol smacb'en Egipto ay tas sva eb' anima. ");
INSERT INTO cac_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Axo yic ix em vejel chi', tzijtum eb' aj Egipto chi' sc'och d'a vin̈ rey c'anb'oj trigo. Syalan vin̈ rey chi' d'a eb': Ixiquec d'a vin̈aj José. Masanil tas syal vin̈ a tze c'anab'ajej, xchi vin̈ d'a eb'. ");
INSERT INTO cac_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Masanil yol yic Egipto chi' ayem vejel, yuj chi' ix jacvi masanil yed'tal b'aj sic'an ixim trigo yuj vin̈aj José chi', ix chon̈ji ixim d'a eb' aj Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Masanil juntzan̈xo nación ix ja manoj trigo d'a vin̈ yujto masanil b'aj ay vejel, man̈xalaj tas sva eb' anima. ");
INSERT INTO cac_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","A vin̈aj Jacob cajan vin̈ d'a Canaán, ix yab' specal vin̈ to te ay ixim trigo d'a Egipto. Yuj chi' ix yal vin̈ d'a eb' vin̈ yuninal icha tic: ¿Tas tze c'ulej, ton̈ej tzeyil-lajoch e b'a? ");
INSERT INTO cac_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ix vab' specal to te ay ixim trigo d'a Egipto. Ixiquec e man tas sco va yic vach' max on̈ cham yuj vejel, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yuj chi', ix b'at lajun̈van̈ yuc'tac vin̈aj José manoj trigo d'a Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Axo vin̈aj Benjamín, yuc'tac vin̈aj José chi', maj chajib'atlaj vin̈ yuj vin̈aj Jacob chi', yujto ix sna' vin̈: Ay talaj tas tz'ic'an vin̈ vuninal tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Tzijtum juntzan̈xo eb' vin̈ manum trigo ix b'at yed' eb' vin̈ yuninal vin̈aj Israel chi', yujto d'a masanil yol yic Canaán chi', ix te em vejel. ");
INSERT INTO cac_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","A vin̈aj José yajal yaj d'a yol yic Egipto chi', a vin̈ tz'ac'anelta ixim trigo d'a eb' manvajum sc'och chi'. Ayic ix c'och eb' yuc'tac vin̈ chi' d'a yichan̈, ix em n̈ojjab' eb' vin̈ d'a sat luum. ");
INSERT INTO cac_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","D'a jun rato chi, ix yiloch eb' yuc'tac vin̈aj José chi', palta axo ix yutej sb'a vin̈ ichato man̈ yojtacoc vin̈, ov ix yutej vin̈ slolon d'a eb' vin̈: —¿B'ajtil ix ex cot a ex tic? xchi vin̈. —Aj Canaán on̈, to tzon̈ javi manoj trigo, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Vach'chom a vin̈aj José chi' yojtac vin̈ to yuc'tac sb'a vin̈ yed' eb' vin̈, axo pax eb' vin̈ jun, maj nachajel-laj yuj eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ichato chi' ix snaancot vin̈aj José tas ix svayichej d'a yib'an̈ eb' vin̈ d'a yalan̈taxo. Ix yalan vin̈: —A ex tic ton̈ej tzul on̈ eyileli, ton̈ej tzex javi eyila' tato ay b'aj syal yochul eb' ajc'ol d'a yol jun chon̈ab' tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","—Maay mamin, a on̈ a checab' on̈ tic, manoj trigon̈ej tzon̈ javi. ");
INSERT INTO cac_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","A on̈ tic junn̈ej co mam, cuc'tacn̈ej co b'a, vach'n̈ej co pensar, malaj b'aj ton̈ej tzec' quileli, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","—Val yel a ex tic ton̈ej tzex ja eyilb'ati ta secojtac tz'ochul eb' ajc'ol d'a tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ix tac'vi eb' vin̈ icha tic: —Maay mamin, a on̈ a checab' on̈ tic, lajchavan̈ on̈, cuc'tacn̈ej co b'a, junn̈ej co mam, cajan on̈ d'a Canaán. A vin̈ cuc'tac tzac'an unin, aycan vin̈ yed' vin̈ co mam chi', ay junxo vin̈, man̈xo ayoc ec'laj vin̈, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","—Val yel svala', a ex tic ton̈ej tzex ja eyileli tas yaj d'a tic. ");
INSERT INTO cac_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ol to yal sb'a tas ol aj jun tic: Tzin loc sb'i vin̈ rey to man̈ ol ex actajeloc tato man̈ ol eyic'cot vin̈ eyuc'tac tzac'an unin chi'. ");
INSERT INTO cac_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","A ticnaic tzex b'at junoc ex eyic' vin̈, a exxo tic ol ex cann̈ej preso d'a tic, yic vach' squila' tato yel tzeyala'. Tato ton̈ej tzeyala', toxo ix in loc sb'i vin̈ rey to ton̈ej tzul on̈ eyileli, xchi vin̈aj José chi. ");
INSERT INTO cac_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","18","Ix och eb' vin̈ preso yuj vin̈. Ato d'a schab'jial chi' ix yalan vin̈aj José chi' d'a eb' vin̈ icha tic: —A in tic tzin xiv d'a Dios. Tato tze c'anab'ajej jun tas sval tic, tzex colchajcani. ");
INSERT INTO cac_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Tato yel vach' ex, junxon̈ej ex tzex can d'a yol preso tic, tzex b'at e masanil d'a e chon̈ab' chi', tzeyic'anb'at ixim trigo sva eb' ix eyetb'eyum yed' eyuninal van scham yuj vejel chi'. ");
INSERT INTO cac_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Slajvi chi', tzeyic'ancot vin̈ eyuc'tac tzac'an unin chi'. Ichato chi' ol vilani tato yel tzeyala', man̈ ol ex chamlaj, xchi vin̈aj José chi'. Ichocab' ta', xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ix yalan eb' vin̈ d'ay junjun icha tic: —A yuj tas cutejnac vin̈ cuc'tac, yuj chi' sja jun yaelal tic d'a quib'an̈. Val yel te chuc cutejnac co b'a d'a vin̈, man̈ co chanacoc cab'i ayic stevinac vin̈ d'ayon̈ to tz'oc' co c'ol d'a vin̈, vach'chom quilnac to te cusnac vin̈, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ix yalanpax vin̈aj Rubén d'a eb' vin̈ yuc'tac chi' icha tic: —Valnac d'ayex to max eyutej e b'a d'a vin̈ icha chi', palta man̈ e chanacoc eyab'i tas valnac chi'. A ticnaic, tic val scot d'a quib'an̈ yuj schamel vin̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Maj nachajel yuj eb' vin̈ tato van yab'an vin̈aj José tas syal eb' vin̈ chi', yujto d'a sti' eb' aj Egipto slolon vin̈, an̈ej to ay junoc mach tz'alaneli tas syal vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ix el vin̈aj José chi' d'a stz'ey eb' vin̈, ix och ijan vin̈ yoq'ui. Ix jax vin̈, ix lolonxi vin̈ yed' eb' vin̈. Ix yic'anel vin̈aj Simeón vin̈, d'a yichan̈ eb' vin̈ ix tzec'chajcan vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ix lajvi chi', ix yalan vin̈aj José chi' to tz'ac'ji b'ud'joc scoxtal eb' vin̈, ix ac'jiem q'uen stumin eb' vin̈ d'a yol sti' scoxtal chi', ix ac'jib'at svael eb' vin̈ yic yol sb'e. Icha chi' ix sc'ulej vin̈ yed' eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ix lajvi chi', ix yac'anoch yicatz noc' sb'uru eb' vin̈, ix paxta eb' vin̈ b'ian. ");
INSERT INTO cac_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Axo ix c'och eb' vin̈ b'aj ol vayoc, ix sjacan scoxtal junoc eb' vin̈ yic syic'anq'ueta chab'oc strigo noc' sb'uru vin̈ chi' yalani. Axo ix yilan vin̈ to ayem q'uen tumin d'a yol sti' scoxtal, q'uen ix yac'lab'ej eb' vin̈ smanan ixim strigo chi'. ");
INSERT INTO cac_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ix yalan vin̈ d'a eb' vin̈ yuc'tac chi' icha tic: —Ilecnab'i, ix ac'jixi meltzaj q'uen in tumin. Ay val em q'uen d'a yol sti' in coxtal tic, xchi vin̈. Masanil eb' vin̈ ix ib'xiq'ue yuj xivelal, ix yalan eb' vin̈ icha tic: —¿Tas yuj icha tic tzon̈ yutej Dios? xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Axo yic ix jax eb' vin̈ d'a yol yic Canaán chi', ix yalan eb' vin̈ d'a vin̈ smam tastac ix ec' d'a yib'an̈. Ix yalan eb' vin̈ icha tic: ");
INSERT INTO cac_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","—A vin̈ ayoch yajalil d'a jun chon̈ab' chi', te ov ix yutej vin̈ slolon d'ayon̈. Ix yalan vin̈ to ton̈ej on̈ xid' quilelta tas yaj schon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ix calani to vach' on̈, man̈ chucoc co pensar tzon̈ eq'ui, malaj b'aj ton̈ej tzec' quilel tas yaj eb'. ");
INSERT INTO cac_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ix calani to lajchavan̈ co b'eyi, junn̈ej co mam, jun vin̈ cuc'tac man̈xo ayoquec'laj, axo vin̈ tzac'an unin, aycan vin̈ yed' vin̈ co mam d'a Canaán, xco chi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ix lajvi chi', ix yalan vin̈ icha tic: Tato yel vach' ex, canocab' junoc vin̈ eyuc'tac d'a tic, tzeyic'anb'at jab'oc ixim trigo d'a eb' ix eyetb'eyum yed' d'a eyuninal van scham yuj vejel chi'. ");
INSERT INTO cac_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Slajvi chi', tzeyic'ancot junxo vin̈ eyuc'tac tzac'an unin chi' vil d'a tic. Ichato chi' ol vojtacaneli to man̈ chucoc e pensar syal chi'. Masanto sjavi junxo vin̈ eyuc'tac tzac'an unin chi', ol in jacanelta vin̈ eyuc'tac ix can d'a preso tic, yic icha chi' libre ex e b'eyeq'ui, xchi vin̈, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Axo ix sjacan scoxtal eb' vin̈ chi', ix yilan eb' vin̈ to ayem junjun yunetac mucuc tumin yol sti' coxtal chi', aton q'uen tumin chi' ix yac'lab'ej eb' vin̈ smanan ixim trigo. Ix ac'chajxi meltzaj q'ueen. Ix te xiv chaan̈ eb' vin̈, ix te xivpax vin̈ smam eb' vin̈ chi. ");
INSERT INTO cac_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ix lajvi chi' ix yalan vin̈ d'a eb' vin̈ icha tic: —Te chuc tzeyutej e b'a d'ayin. Man̈xo junoc vuninal scan eyuuj. Vin̈aj José, man̈xo ayoquec'laj vin̈, vin̈aj Simeón, ix can vin̈ d'a preso, e gana tzeyic'paxb'at vin̈aj Benjamín. A mach tz'ab'an syail, a in toni, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ix yalan vin̈aj Rubén d'a vin̈ smam chi' icha tic: —Man̈ ach xiv mamin. Ac'b'at vin̈ cuc'tac tzac'an unin tic qued'oc. A in svac' in b'a yuj vin̈, tato man̈xo ol jax vin̈ vuuj, vach'chom tza mac'cham chavan̈ vuninal tic yuj vin̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ix tac'vi vin̈aj Jacob chi' icha tic: —Man̈ ol b'atlaj vin̈ vuninal tic eyed'oc, axon̈ej vin̈ ayec' ved'oc. Ina vin̈ yuc'tac vin̈, chamnacxo vin̈, talaj ay tas tz'ic'anpax junxo vin̈ tic d'a yol b'e, tic a ex val tzeyac'och e mul yic tzin cham yuj cuselal, xchi vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Te ov yac'an vejel d'a yol schon̈ab' eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ix lajviel ixim trigo xid' yic' eb' vin̈ chi' svaan vin̈aj Jacob yed' yuninal, ix yalanxi vin̈ d'a eb' vin̈ icha tic: —Ixiquecxi d'a Egipto, b'at manec jab'ocxo tas sco va'a, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ix yalan vin̈aj Judá icha tic: —Te jichan ix yutej vin̈ schon̈an ixim trigo chi' yalani: Tato max eyic'cot vin̈ eyuc'tac tzac'an unin chi', man̈xo ol eyil in sat d'a tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Yuj val chi', tato sb'at vin̈ cuc'tac tic qued'oc, tzon̈ b'at manoj trigo chi'. ");
INSERT INTO cac_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tato max a chab'at vin̈ qued' jun, man̈xo ol on̈ b'atlaj, icha ix aj yalan vin̈ chon̈um trigo chi': Tato max eyic'cot vin̈ eyuc'tac tzac'an unin chi', man̈xo ex javoclaj d'a vichan̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ix yalan vin̈aj Israel chi' icha tic: —¿Tas yuj ix eyal d'a jun vin̈ chi' to ay junocxo eyuc'tac? Tzin eyac' val och d'a ilc'olal, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ix tac'vi eb' vin̈ icha tic: —Ix sc'anb'ej vin̈ tastac caji, mach ayon̈ yin̈tilal. Ix sc'anb'anpax vin̈ tato aytoec' co mam, tato aytopax cuc'tac. Yuj chi' ix cal d'a vin̈ to aytoec' co mam, aytopax junxo cuc'tac. ¿Tocval cojtac tato ol yal vin̈ to squic'b'at vin̈ cuc'tac tic? xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ix yalanxi vin̈aj Judá d'a vin̈ smam chi': —Tato max yal a c'ol tzon̈ cham yuj vejel co masanil, chab'at vin̈ cuc'tac tic qued'oc. A in tzin tec'b'ej in b'a in tan̈van vin̈, tato icha chi', tic tzon̈ b'at d'a elan̈chamel. ");
INSERT INTO cac_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","A in tzin tec'b'ej in b'a tato ay tas tz'ic'an vin̈, tato man̈xo ol ja vin̈ vuuj, te chuc ol in can d'a a sat. ");
INSERT INTO cac_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Tato maj ec' co tiempo d'a tic, toxo ix cac' chaeloc naic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ix tac'vi vin̈ smam eb' vin̈ chi' icha tic: —Tato man̈xa tas vach' scutej, yic'ocab' icha tzeyal chi', ixiquec. Iq'uecb'at jab'oc e silab' d'a vin̈. A juntzan̈ tas vach' sq'uib' d'a tic, a' tzeyic'b'ati: Aton bálsamo, noc' yalchab', perfume, mirra, te' nueces yed' te' almendras. ");
INSERT INTO cac_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Iq'uecb'at e tumin yic tze manan ixim trigo chi', tzeyic'anxib'at q'uen tumin ix yac' meltzaj eb' vin̈ d'ayex d'a sti' e coxtal chi', tecan ton̈ej ix sat sc'ol eb' vin̈, yuj chi' ayem q'ueen. ");
INSERT INTO cac_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Iq'uecb'at vin̈ eyuc'tac tic, tzex b'atxi eyil vin̈ yajal chi'. ");
INSERT INTO cac_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","A Dios Syal Yuj Smasanil, a' ol och d'a spensar vin̈ yic ol actajel vin̈ eyuc'tac aj Simeón. Vach' ol aj smeltzajcot vin̈aj Benjamín tic eyed'oc. A inxo tic, tato tzin can man̈ uninal, in canocab'i, ¿tasto val ol vutej? xchi vin̈ smam eb' vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ix lajvi chi', ix yac'anem silab' eb' vin̈ chi' d'a yol scoxtal yed' q'uen tumin. Ix yic'anb'at vin̈aj Benjamín eb' vin̈, ix b'atxi eb' vin̈ d'a Egipto chi'. Axo yic ix c'och eb' vin̈ d'a yichan̈ vin̈aj José, ");
INSERT INTO cac_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ix yilan vin̈ to ajun vin̈aj Benjamín chi'. Ix yalan vin̈ d'a vin̈ yilumal spat icha tic: —Ic'b'at juntzan̈ eb' vin̈ tic d'a in pat, tzac'an miljoccham junoc noc' vacax, yic sb'o junoc vael, to ol va eb' vin̈ ved'oc d'a chimc'ualil tic, xchi vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ix lajvi chi', ix ic'jib'at eb' vin̈ yuj vin̈ ilum pat chi', ix sc'anab'ajan vin̈ tas ix yal vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ix te xiv chaan̈ eb' vin̈ yujto ix ic'chajb'at eb' vin̈ d'a spat vin̈, ix yal-lan yab' eb' vin̈ icha tic: —Chuc tas sna vin̈ d'a quib'an̈. Tecan yuj q'uen tumin ix yac' meltzaj eb' vin̈ d'ayon̈, yuj chi' tzon̈ ic'chajcot d'a tic. Tecan ol on̈ yac'och vin̈ schecab'oc yed' noc' co chej tic, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Yuj chi', ayic ix c'och eb' vin̈ d'a spuertail pat chi', ix och tean eb' vin̈ d'a vin̈ yilumal te' chi'. ");
INSERT INTO cac_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ix yalan eb' vin̈ icha tic: —Mamin, ina a on̈ tic, ix on̈ ulec' manoj trigo junel, ");
INSERT INTO cac_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","axo yic ix on̈ meltzaji, ix on̈ vay d'a yol b'e. Ayic ix co jacan co coxtal, ix quilani tz'acan yajem q'uen tumin d'a sti' co coxtal chi', aton q'uen ix co c'ana' ayic ix co manan ixim co trigo. Ix quic'anxi meltzaj q'uen tumin chi' ticnaic, tz'acan ol cutej cac'anxi q'uen d'ayach. ");
INSERT INTO cac_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Man̈ cojtacoc mach ix ac'anem q'uen d'a yol sti' co coxtal chi'. Ch'oc ix quic'paxcot q'uen stojol ixim ol co man chi' ticnaic, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ix yalan vin̈ chi' icha tic: —Man̈ eyac' pensar yuj jun chi'. Man̈ ex xivoc. A sDiosal e mam yed' ex paxi, a ix ac'anem q'uen d'a sti' e coxtal chi'. A in ix in cha q'uen tumin ix eyac' stojoloc ixim e trigo ix eyic' chi', xchi vin̈ d'a eb' vin̈. Ix lajvi chi', ix ic'jielta vin̈aj Simeón d'a yol preso yuj vin̈ yilumal chi', ix elul vin̈ b'aj ayec' eb' yuc'tac chi'. ");
INSERT INTO cac_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ix ic'chajb'at eb' vin̈ smasanil yuj vin̈ d'a spat vin̈aj José chi', ix yac'an a a' vin̈ yic sb'iquel yoc eb' vin̈, ix ac'jipax yan̈ schej eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ix lajvi chi', ix yic'anq'ueta silab' eb' vin̈ d'a yol scoxtal ol yac' d'a vin̈aj José ayic ol c'och vin̈ d'a chimc'ualil chi', yujto yojtacxo eb' vin̈ to ol va eb' vin̈ yed' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Axo ix c'och vin̈aj José chi', ix yac'an silab' eb' vin̈ chi' d'a vin̈, ix em n̈ojjab' eb' vin̈ d'a sat lum d'a yichan̈ vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ix lajvi chi' ix sc'anb'an vin̈ d'a eb' vin̈ tato vach'n̈ej sc'ol eb' vin̈, ix yalan vin̈: —¿Janic' sc'ol vin̈ e mam, vin̈ te ichamxo ix eyal d'ayin? ¿Pitzan tom vin̈? xchi vin̈ d'a eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ix em n̈ojan eb' vin̈, ix yalan eb' vin̈: —A vin̈ co mam chi', aytoec' vin̈, vach'to sc'ol vin̈, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Axo ix yilanoch vin̈aj Benjamín vin̈, aton vin̈ junn̈ej snun vin̈ yed'oc, ix yalan vin̈: —¿A am vin̈ eyuc'tac tzac'an unin ix eyal tic d'ayin? xchi vin̈. —Aton vin̈, xchi eb' vin̈. —Yac'ocab' svach'c'olal Dios d'a ib'an̈, xchi vin̈ d'a vin̈aj Benjamín chi'. ");
INSERT INTO cac_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ix lajvi yalan jun chi' vin̈, ix te sat val sc'ol vin̈ yilan vin̈ yuc'tac chi'. Ix och pitz'an d'a spixan vin̈, ijan val ix oc' vin̈. Elan̈chamel ix b'at lemnaj vin̈ d'a yol scuarto yic sb'at oc' ta'. ");
INSERT INTO cac_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Axo yic ix ec'b'at scusc'olal vin̈ chi', ix sb'icanel sat vin̈, ix elta vin̈, ix yalan vin̈ d'a eb' schecab': Iq'uequelta co vael chi' chinaic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Jun smexa vin̈aj José chi' sch'ocojil. Ch'oc junxo mexa b'aj ix och eb' vin̈ yuc'tac vin̈ chi', ch'oc pax junxo mexa b'aj sva eb' vin̈ aj Egipto chi', aton eb' svataxon yed' vin̈aj José chi', yujto a eb' vin̈ aj Egipto chi' ay yovalil tato junn̈ej sva eb' vin̈ yed' eb' vin̈ hebreo chi'. ");
INSERT INTO cac_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","A eb' vin̈ yuc'tac vin̈aj José chi', d'a stzolal ix aj yac'jiem c'ojan eb' vin̈ yuj vin̈ schecab' vin̈aj José chi', ato syala' jantac sq'uinal junjun eb' vin̈, yujto icha chi' ix aj yalan vin̈aj José chi'. Vin̈ b'ab'el masanto vin̈ tzac'an unin. Toxon̈ej ste sat sc'ol eb' vin̈ yil-lanoch sb'a. ");
INSERT INTO cac_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","A vael ay d'a smexa vin̈aj José chi', a' ix ac'ji d'a eb' vin̈. Axo pax d'a vin̈aj Benjamín chi', oye'to macan̈ ec'b'al yic vin̈ ix ac'ji d'a yichan̈ yic juntzan̈xo eb' vin̈ chi'. Ichato chi' ix va eb' vin̈, ix yuc'an vino eb' vin̈ d'a tzalajc'olal. ");
INSERT INTO cac_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ix lajvi chi', ix yalan vin̈aj José d'a vin̈ yilumal spat: —Ac' b'ud'joc scoxtal eb' vin̈ tic d'a ixim trigo, yaln̈ej jantac syal yic'anb'at eb' vin̈. Tzac'anpaxem q'uen tumin d'a yol sti' scoxtal junjun eb' vin̈, aton q'uen b'aj sman ixim trigo chi' eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Tzac'anpaxem q'uen in copa plata yed' q'uen tumin d'a yol sti' scoxtal vin̈ tzac'an unin, xchi vin̈. Ix sc'anab'ajan vin̈ tas ix yal vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ayic ix ja copnaj yoc c'u d'a q'uin̈ib'alil, ix chaji meltzaj eb' vin̈ yed' noc' schej d'a schon̈ab'. ");
INSERT INTO cac_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Quenanto val sb'at eb' vin̈, ix yalan vin̈aj José d'a vin̈ yilumal spat chi' icha tic: —Ixic tzac'an yuj eb' vin̈ chi'. Ayic syamchaj eb' vin̈ uuj, tzalani: ¿Tas yuj a svach'c'olal vin̈ in patrón, chucxo tzeyutej e pactzitancani? ¿Tas yuj ix eyelq'uejcot scopa vin̈, aton jun nab'a plata, ");
INSERT INTO cac_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","jun scopa vin̈ b'aj syuc' svino, sc'ananpax vin̈ yic snaanel junoc lolonel? Te chuc ix eyutej e b'a a ex tic, xa chi d'a eb' vin̈, xchi vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ix b'at vin̈ yilumal spat vin̈aj José chi' b'ian. Axo yic ix yamchaj eb' vin̈ yuj vin̈, ix yalan vin̈ d'a eb' vin̈ icha ix aj yalan vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ix tac'vi eb' vin̈ d'a vin̈: —Mamin, ¿tas yuj icha chi' tzutej alan d'ayon̈? ¿Tom malaj co pensar, yuj chi' ol quelq'uejcot junoc tasi? ");
INSERT INTO cac_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ina ato d'a Canaán cajan on̈. D'a sb'ab'el, a q'uen tumin ix checlaj d'a sti' co coxtal, ix quic'xicot q'ueen. ¿Tom ato val junoc plata ma oro yic vin̈ a patrón chi' ol quelq'uejcot d'a spat? ");
INSERT INTO cac_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","A junoc on̈ b'aj scheclajelta q'uen copa chi' d'a yol scoxtal, vach' tato smiljichamoc, a on̈xo co masanil, tzon̈ ochcan a checab'oc, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ix tac'vi vin̈ icha tic: —Yic'ocab' icha tzeyal chi', palta an̈ej vin̈ b'aj ol ilchajelta jun copa chi' vuuj, a vin̈ chi' ol ochcan in checab'oc. A exxo tic, e masanil libre ex, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","D'a elan̈chamel ix yaq'uem scoxtal eb' vin̈ chi' smasanil, ix stijan sti' eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ix sayan yil masanil yoltac coxtal chi' vin̈. D'a stzolal ix say yil vin̈, ix sb'ab'laj sayej yil yic vin̈ b'ab'el vinac vin̈ masanto d'a vin̈ tzac'an unin. Axo d'a yol yic vin̈ tzac'an unin chi' ix q'ueta q'uen copa chi', aton vin̈aj Benjamín. ");
INSERT INTO cac_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ix och ijan eb' vin̈ sn̈ic'chitan spichul yuj scusc'olal. Ix yac'anxioch yicatz noc' sb'uru eb' vin̈ chi', ix meltzajxi eb' vin̈ d'a spatic. ");
INSERT INTO cac_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ayto ec' vin̈aj José chi' d'a spat, ix c'och vin̈aj Judá yed' eb' yuc'tac chi', ix em n̈ojan eb' vin̈ d'a sat luum d'a yichan̈ vin̈. ");
INSERT INTO cac_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ix yalan vin̈ d'a eb' vin̈ icha tic: —¿Tas yuj icha chi' tzeyutej e b'a? ¿Tom man̈ eyojtacoc to a junoc vinac ay yopisio icha in tic, syal snachajel junoc tas yuuj? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ix tac'vi vin̈aj Judá icha tic: —Mamin, ¿tasto val ol aj co tac'vi d'ayach? ¿Tasto ol cutoc quilanoch co b'a tato vach' on̈ calani? Ay co mul d'a yichan̈ co Mam Dios, tic ayon̈ ec' d'a ichan̈. Syal tzon̈ och a checab'oc yed' vin̈ b'aj ix ilchajelta q'uen copa chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ix yalanxi vin̈aj José chi' icha tic: —Maay, an̈ej vin̈ b'aj ix ilchajelta q'uen in copa chi', an̈ej vin̈ scan in checab'oc. A exxo tic, meltzajan̈ec d'a junc'olal b'aj ay vin̈ e mam, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ix snitz val b'at sb'a vin̈aj Judá d'a stz'ey vin̈aj José chi', ix yalan vin̈: —Mamin, tzoc el val d'a a c'ool svalan d'ayach tas in pensar. Tzin tevi d'ayach, mocab' cot oval d'ayin, vach'chom icha ach vin̈ rey. ");
INSERT INTO cac_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","A ach val ix a c'anb'ej d'ayon̈ tato aytoec' vin̈ co mam a on̈ tic, tato aytopax junocxo cuc'tac. ");
INSERT INTO cac_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Yuj chi', ix calan d'ayach to aytoec' vin̈ co mam, an̈ejto te icham vinacxo vin̈. A junxo vin̈ cuc'tac tzac'an unin, d'a yicham vinaquilxo vin̈ co mam chi' ix alji vin̈. Axo junxo vin̈ junn̈ej snun vin̈ yed'oc, chamnacxo vin̈, yuj chi' te xajan vin̈ yuj vin̈ co mam chi', yujto axon̈ej vin̈. ");
INSERT INTO cac_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","A ach ix ala' to squic'cot vin̈, yic tzojtaquejel vin̈. ");
INSERT INTO cac_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ix calan d'ayach to max yal sc'ol vin̈ co mam chi' tz'elta vin̈ d'a stz'ey, yujto ijanxo scham vin̈ yuj cusc'olal yalani tato tz'el vin̈ d'a stz'ey vin̈. ");
INSERT INTO cac_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Palta ix alpax d'ayon̈ tato max quic'cot vin̈, maxtzac yal co jax d'a ichan̈ alani. ");
INSERT INTO cac_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ayic ix on̈ c'och d'a co pat chi', ix calan d'a vin̈ co mam chi' tas ix aj alan d'ayon̈. ");
INSERT INTO cac_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Axo vin̈ ix alan d'ayon̈ to tzon̈ cotxi manoj trigo. ");
INSERT INTO cac_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ix calan d'a vin̈ icha tic: Max on̈ b'atlaj tato max quic'b'at vin̈ cuc'tac tzac'an unin tic, yujto tato max b'at vin̈ qued'oc, maxtzac yal-laj co c'och d'a yichan̈ vin̈ yajal chi', xco chi. ");
INSERT INTO cac_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ix yalan vin̈ co mam chi' d'ayon̈: Eyojtac to chavan̈n̈ej vuninal ix vil yed' ix vetb'eyum chamnac. ");
INSERT INTO cac_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Jun vin̈ juneln̈ej b'atnaccani, man̈xa b'aj ix vil sat vin̈, ay am val junoc noc' noc' chium anima chi'annacb'at vin̈. ");
INSERT INTO cac_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tato tzeyic'xib'at junxo vin̈ tic, tato ay pax tas tz'ic'an vin̈, eyuj am val tzin cham yuj cusc'olal, xchi vin̈ d'ayon̈. ");
INSERT INTO cac_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Yuj chi', icha val to sq'uinal vin̈ co mam chi' yajoch vin̈ vuc'tac tic. Tato man̈xo ol meltzaj vin̈ qued'oc ");
INSERT INTO cac_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ol cham vin̈ co mam yuj cusc'olal, a on̈ tic tz'och co mul. ");
INSERT INTO cac_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","A in ix in tec'b'ej in b'a yuj vin̈ d'a vin̈ in mam chi', ix valani: Tato man̈xo ol jax vin̈ vuuj, te chuc tzin can d'a yol a sat d'a juneln̈ej, xin chi d'a vin̈ in mam chi'. ");
INSERT INTO cac_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Yuj val chi' tzin tevi d'ayach, tato syala', a in tzin can sq'uexuloc vin̈ vuc'tac tic a checab'oc. Yuj chi' tzactejel vin̈, spax vin̈ yed' eb' vin̈ vuc'tac tic. ");
INSERT INTO cac_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Tato maay jun, ¿tasto val ol aj in b'at vil vin̈ in mam chi', tato man̈oc jun vin̈ ved'oc? Man̈ jab'oc syal in c'ol svil scusc'olal vin̈ in mam tato icha chi' tzuji, xchi vin̈aj Judá chi'. ");
INSERT INTO cac_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Majxo techaj yuj vin̈aj José chi', ijanxo tz'oc'q'ue vin̈ d'a yichan̈ masanil eb' vin̈ smunlajvum, yuj chi' te chaan̈ ix yal vin̈: Elan̈ec d'a tic, xchi vin̈. Yuj chi' man̈xo junoc eb' vin̈ munlajvum chi' ix can ta, ix yalan vin̈ d'a eb' vin̈ yuc'tac chi' to yuc'tac sb'a vin̈ yed' eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ichato chi', ix oc'val vin̈ sic'lab'il. Masanil eb' vin̈ aj Egipto ix ab'ani. Ix c'och specal jun chi' d'a spalacio vin̈ rey. ");
INSERT INTO cac_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ix yalan vin̈aj José chi' d'a eb' vin̈ yuc'tac chi' icha tic: —A in ton tic José in, cuc'tac co b'a. ¿Yel am val to pitzanto vin̈ co mam chi'? xchi vin̈. Ix te xiv chaan̈ eb' yuc'tac vin̈ chi' d'a yichan̈. Majxo yal-laj slolon eb' vin̈ yuj xivelal. ");
INSERT INTO cac_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ix yalan vin̈aj José chi: —Sval d'ayex ticnaic, nitzeccot e b'a d'a in tz'ey tic, xchi vin̈. Axo yic ix snitzanb'at sb'a eb' vin̈, ix yalan vin̈ d'a eb' vin̈ icha tic: —A in ton José in, vuc'tac in b'a eyed'oc. A in ton tic e chon̈nac in cot d'a eb' vin̈ ismaelita chon̈vajum d'a Egipto tic. ");
INSERT INTO cac_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Palta mocab' chab'ax e c'ool, mocab' cot eyoval d'ayex junjun ex yuj b'aj in e chon̈naccot chi'. Spensar Dios yaj jun chi' yic tzin b'ab'lajcot d'a eyichan̈, yic tzijtum anima scolchaji, yuj chi' icha chi' ix aji. ");
INSERT INTO cac_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Schab'ilto ab'il yel yich vejel d'a yolyib'an̈q'uinal tic. Oye'to ab'il ol yac'a', man̈ ol yac' sat aval in̈at, vach'chom ay mach ol avanoc, palta malaj jab'oc sat ol yac'a'. ");
INSERT INTO cac_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","B'ab'el ix in checjicot yuj Dios yic ol ex in colcan d'a jun nivan vejel tic, yic vach' max satel eyin̈tilal d'a yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Yuj chi' a Dios checannac in cot d'a jun lugar tic, man̈oquexlaj eyac'nac in coti. A Dios ix in ac'anochi yic svac' sna vin̈ rey, yic tzin ochpax yajalil d'a masanil tas ay d'a spat vin̈ yed' d'a masanil yol yic Egipto tic. ");
INSERT INTO cac_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","A ticnaic pilec eyip, ixic alec d'a vin̈ co mam chi' icha tic: Icha tic ix aj yalan vin̈aj José uninal: A Dios ix in ac'anoch yajalil d'a yol yic Egipto tic, yuj chi' cotan̈ d'a elan̈chamel, yic tzul in ilan d'a tic. ");
INSERT INTO cac_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","A d'a lum Gosén ol ach cajnajoc yic vach' d'a in lac'anil ol ach aj yed' masanil eb' uninal, eb' iachiquin yed' noc' a molb'etzal noc' yed' masanil tastac ay d'ayach. ");
INSERT INTO cac_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ol vac'an a vael yed' masanil eb' vin̈ vuc'tac yed' masanil eb' ayec' ed'oc, yujto oye'to ab'il ol yac' jun vejel tic. Yuj chi' man̈ ol ach och meb'ail yed' masanil eb' ayec' ed'oc, xchi vin̈, xe chi d'a vin̈ co mam chi'. ");
INSERT INTO cac_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Testigo yaj vin̈ vuc'tac aj Benjamín tic yed' ex pax tic, to a in val sval jun lolonel tic. ");
INSERT INTO cac_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Alec d'a vin̈ co mam chi' to a in tic te nivan velc'och d'a yol yic Egipto tic. Tzeyalan d'a vin̈ yuj masanil tastac ix eyil d'a tic. Yuj chi' ixiquec eyic'cot vin̈ co mam chi' d'a elan̈chamel, xchi vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ix lajvi chi', ix b'at lac'naj vin̈aj José chi' d'a vin̈aj Benjamín chi', ix och ijan vin̈ yoq'ui. An̈ejtona' ix oc'pax vin̈aj Benjamín chi'. ");
INSERT INTO cac_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ix lajvi chi', ix stz'ub'anelta sti' eb' vin̈ yuc'tac vin̈ chi' smasanil. Ayic lac'lac' och vin̈ d'a eb' vin̈, ix och ijan vin̈ yoq'ui. Ix lajvi juntzan̈ chi', ix stec'b'an sb'a eb' vin̈ slolon yed' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ix c'och specal d'a spalacio vin̈ rey to yuc'tac sb'a vin̈aj José yed' eb' vin̈ ix c'och chi'. Ix te tzalaj vin̈ rey chi' yed' masanil eb' ayoch d'a yopisio yed' vin̈ d'a spalacio chi' ayic ix yab'an eb'. ");
INSERT INTO cac_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ix yalan vin̈ rey d'a vin̈aj José chi' icha tic: —Al d'a eb' vin̈ uc'tac chi', yac'ocab'och yicatz noc' schej eb' vin̈ yic smeltzaj eb' vin̈ d'a Canaán chi'. ");
INSERT INTO cac_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Syic'ancot yetb'eyum eb' vin̈ yed' eb' yuninal yed' vin̈ a mam chi' d'ayin. A lum luum te vach' d'a Egipto tic ol vac' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Al d'a eb' vin̈ to syic'b'at carreta eb' vin̈ d'a tic, yic vach' syic'cot yetb'eyum eb' vin̈ yed' eb' yuninal yed' vin̈ a mam chi'. ");
INSERT INTO cac_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Mocab' yac' pensar eb' vin̈ yuj tastac ay ticnaic, yujto a tas vach' ay d'a Egipto tic, a' ol vac' d'a eb' vin̈, xchi vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Icha chi' ix yutej eb' vin̈ yuninal vin̈aj Israel chi'. Axo vin̈aj José chi' ix ac'an carreta chi' d'a eb' vin̈ yed' tastac sva eb' d'a yol b'e icha ix yutej vin̈ rey yalani. ");
INSERT INTO cac_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ix ac'jipax pichul ac'to d'a eb' vin̈ yic tz'och sq'uex c'apacoc eb' vin̈. Axo d'a vin̈aj Benjamín, 300 siclo plata ix ac'ji, ix ac'jipax oye' mojan̈ spichul vin̈. ");
INSERT INTO cac_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ix yac'anb'at lajun̈van̈ noc' b'uru vin̈aj José chi' d'a vin̈ smam. Te al ix ajb'at noc' yuj masanil tas vach' ay d'a Egipto chi'. Ix b'atpax lajun̈van̈xo noc' nun b'uru ix ic'anb'at ixim trigo yed' ixim pan yic sva vin̈ d'a yol b'e yic scoti. ");
INSERT INTO cac_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ayic ix stac'anb'at eb' yuc'tac vin̈aj José chi', ix yalan vin̈: —Mocab' eyac' oval d'a yoltac b'e, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ix el eb' vin̈ d'a Egipto chi', ix c'och eb' vin̈ d'a Canaán b'aj ay vin̈ smam chi'. ");
INSERT INTO cac_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Axo ix yalan eb' vin̈ d'a vin̈ smam chi' to pitzanto vin̈aj José, to ayoch vin̈ schab'il yajalil d'a Egipto. Ix te sat sc'ol vin̈ yab'ani, maj schalaj vin̈ tas ix yal eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Palta ichato ix pitzvixi vin̈ ayic ix yab'an masanil tas ix yalcot vin̈aj José chi', ix yilanpaxoch jantac carreta ix yac'cot vin̈ yic tz'ic'jib'at vin̈. ");
INSERT INTO cac_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ichato chi' ix yalan vin̈: C'ocb'iln̈ej ix vab'i to pitzanto vin̈ vuninal chi'. Ol b'at vil vin̈ yacb'an manto in chami, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ix lajvi chi', ix b'at vin̈aj Jacob yed' masanil eb' yico' yed' masanil tastac ay d'ay. Ayic ix c'och vin̈ d'a Beerseba, ix sn̈usan silab' vin̈ d'a sDiosal, aton sDiosal vin̈ smam vin̈. ");
INSERT INTO cac_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","A d'a jun ac'val chi', ix lolon Dios d'a vin̈ d'a svayich, ix avtaj vin̈ yuuj: —Jacob, xchi. Ix tac'vi vin̈: —Oy, ina vajec' tic Mamin, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ix yalan Dios d'a vin̈ icha tic: —A in ton a Diosal in yed' vin̈ a mam, man̈ ach xiv a b'at d'a Egipto chi'. Yacb'an ayex ec' ta' ol in b'o jun nivan chon̈ab' d'a in̈tilal. ");
INSERT INTO cac_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ol in b'atn̈ej ed'oc d'a Egipto chi', axo yic ol c'och stiempoal, ol in ochn̈ej yed' eb' in̈tilal ayic ol meltzajxicot eb' d'a jun lugar tic. Axo yic ol ach chamoc, a vin̈ uninal aj José chi', ayec' vin̈ d'a a tz'ey, xchi Dios d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ix lajvi chi', ix ac'jiq'ue vin̈ yuj eb' vin̈ yuninal d'a yol carreta ix yac'cot vin̈ sreyal Egipto chi'. Ix yac'anpaxq'ue eb' unin yed' eb' ix yetb'eyum eb' vin̈. Ichato chi' ix el eb' vin̈ d'a Beerseba chi'. ");
INSERT INTO cac_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ix cot eb' vin̈ d'a Egipto, ix yic'ancot noc' scalnel eb' vin̈ yed' noc' svacax yed' masanil tastac ix yic' eb' vin̈ d'a Canaán chi'. ");
INSERT INTO cac_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ix yic'ancot masanil eb' vin̈ yuninal vin̈aj Jacob chi' yed' eb' ix yisil yed' eb' yixchiquin. ");
INSERT INTO cac_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","15","A eb' yin̈tilal vin̈ yed' ix Lea ix cot yed'oc d'a Egipto, 33 eb' d'a smasanil, ayoch eb' vinac yed' eb' ix ix sb'isuloc. A eb' yuninal vin̈ yed' ix, aton eb' tic: Vin̈aj Rubén, aton vin̈ b'ab'el unin, vin̈aj Simeón, vin̈aj Leví, vin̈aj Judá, vin̈aj Isacar, vin̈aj Zabulón yed' ix Dina. A eb' tic ix alji ayic ayec' vin̈ d'a Padán-aram. A eb' yuninal vin̈aj Rubén: Aton vin̈aj Hanoc, vin̈aj Falú, vin̈aj Hezrón yed' vin̈aj Carmi. A eb' yuninal vin̈aj Simeón: Aton vin̈aj Jemuel, vin̈aj Jamín, vin̈aj Ohad, vin̈aj Jaquín, vin̈aj Zohar yed' vin̈aj Saúl, vin̈ yune' jun ix aj Canaán. A eb' yuninal vin̈aj Leví: Aton vin̈aj Gersón, vin̈aj Coat yed' vin̈aj Merari. A eb' vin̈ yuninal vin̈aj Judá: Aton vin̈aj Er, vin̈aj Onán, vin̈aj Sela, vin̈aj Fares yed' vin̈aj Zara. (A vin̈aj Er yed' vin̈aj Onán chi', chamnacxo eb' vin̈ d'a Canaán). A eb' yuninal vin̈aj Fares chi', aton vin̈aj Hezrón yed' vin̈aj Hamul. A eb' yuninal vin̈aj Isacar: Aton vin̈aj Tola, vin̈aj Fúa, vin̈aj Job yed' vin̈aj Simrón. A eb' yuninal vin̈aj Zabulón: Aton vin̈aj Sered, vin̈aj Elón yed' vin̈aj Jahleel. ");
INSERT INTO cac_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","18","A eb' yin̈tilal vin̈aj Jacob chi' yed' ix Zilpa, 16 eb' d'a smasanil. A ix Zilpa chi', aton ix scriada ix Lea ix ac'ji yuj vin̈ sman, aton vin̈aj Labán. A eb' yuninal vin̈ yed' ix, aton eb' tic: Vin̈aj Gad yed' vin̈aj Aser. A eb' yuninal vin̈aj Gad: Aton vin̈aj Zifión, vin̈aj Hagui, vin̈aj Ezbón, vin̈aj Suni, vin̈aj Eri, vin̈aj Arodi yed' vin̈aj Areli. A eb' yuninal vin̈aj Aser: Aton vin̈aj Imna, vin̈aj Isúa, vin̈aj Isúi, vin̈aj Bería yed' ix yanab' eb' vin̈ scuchan Sera. A eb' yuninal vin̈aj Bería chi', aton vin̈aj Heber yed' vin̈aj Malquiel. ");
INSERT INTO cac_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","22","A eb' yin̈tilal vin̈aj Jacob chi' yed' ix Raquel, 14 eb' d'a smasanil. A eb' yuninal vin̈ yed' ix: Aton vin̈aj José yed' vin̈aj Benjamín. A eb' yuninal vin̈aj José chi' yed' ix Asenat yisil vin̈aj Potifera sacerdote d'a chon̈ab' On: Aton vin̈aj Manasés yed' vin̈aj Efraín, aton eb' ix alji d'a Egipto. A eb' yuninal vin̈aj Benjamín chi': Aton vin̈aj Bela, vin̈aj Bequer, vin̈aj Asbel, vin̈aj Gera, vin̈aj Naamán, vin̈aj Ehi, vin̈aj Ros, vin̈aj Mupim, vin̈aj Hupim yed' vin̈aj Ard. ");
INSERT INTO cac_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","A eb' yin̈tilal vin̈aj Jacob chi' yed' ix Bilha, ucvan̈ eb'. A ix Bilha chi', aton ix scriada ix Raquel ix ac'ji yuj vin̈aj Labán. A eb' yuninal vin̈ yed' ix, aton eb' tic: Vin̈aj Dan yed' vin̈aj Neftalí. A yuninal vin̈aj Dan chi', an̈ej vin̈aj Husim. A eb' yuninal vin̈aj Neftalí chi': Aton vin̈aj Jahzeel, vin̈aj Guni, vin̈aj Jezer yed' vin̈aj Silem. ");
INSERT INTO cac_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","66 eb' yin̈tilal vin̈aj Jacob chi' d'a smasanil, aton eb' tic ajun yed' vin̈ ayic ix c'och vin̈ d'a Egipto. Aton val eb' tic yin̈tilal vin̈, ch'oc pax eb' ix alib'al. ");
INSERT INTO cac_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ch'oc pax yaj vin̈aj José yed' chavan̈ eb' yuninal ix alji d'a Egipto chi', yuj chi' 70 sb'isul vin̈aj Jacob chi' yed' eb' yin̈tilal ayic ayxoec' vin̈ ta'. ");
INSERT INTO cac_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ix b'ab'lajb'at vin̈aj Judá yuj vin̈aj Jacob chi', yic sb'at vin̈ yal yab' vin̈aj José chi' to scot vin̈ chaval d'a yol yic Gosén. Axo yic ix c'och eb' d'a Gosén chi', ");
INSERT INTO cac_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ix schecan vin̈aj José chi' ac'chaj lista scarruaje yic b'at schaan vin̈ smam vin̈ d'a Gosén chi'. Ayic ix c'och vin̈ d'a yichan̈ vin̈ smam chi', ix och lac'naj vin̈ d'a vin̈. Te junip ix em n̈ojan vin̈ yoc' d'a sjolom sjen̈jab' vin̈ smam chi'. ");
INSERT INTO cac_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Axo ix yalan vin̈ smam vin̈ chi' icha tic: —A ticnaic, tic val ix vilxioch a sat, tic val pitzan achto, junc'olalxo ol in cham ticnaic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ix lajvi chi', ix yalan vin̈aj José chi' d'a eb' vin̈ yuc'tac yed' d'a masanil eb' ayec' yed' vin̈ smam vin̈ chi': —Tic tzin b'at val d'a vin̈ rey: Masanil eb' vin̈ vuc'tac yed' masanil eb' yin̈tilal vin̈ in mam ay d'a Canaán, toxo ix ja eb' ved'oc. ");
INSERT INTO cac_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Yed'nac masanil noc' scalnel eb', noc' svacax yed' masanil tas ay d'a eb', yujto a smunlajel eb' aton moloj calnel yed' moloj vacax, xin chama. ");
INSERT INTO cac_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Yuj chi', ayic ol ex avtajb'at yuj vin̈ rey chi', ol sc'anb'an vin̈ d'ayex tas b'aj tzex munlaji, ");
INSERT INTO cac_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","tzeyalani to moloj calnel yed' moloj vacax tze c'ulej. An̈ej noc' calnel co molb'etz yaji yictax on̈ cotoch uninal icha val eb' co mam quicham, xe chi. Yuj chi' ol ex can d'a lum Gosén tic, yujto a eb' vin̈ aj Egipto tic ay yovalil tato junn̈ej tz'aj eb' vin̈ yed' eb' vin̈ molum calnel, xchi vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ix lajvi chi', ix b'at vin̈aj José yal d'a vin̈ rey chi' icha tic: A vin̈ in mam yed' eb' vin̈ vuc'tac toxo ix javi eb' vin̈ d'a Gosén. Ix cot eb' vin̈ d'a Canaán, yed'nac noc' scalnel eb' yed' noc' svacax yed' masanil tas ay d'a eb', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Sic'b'ilxoel ovan̈ eb' vin̈ yuc'tac vin̈ chi' yuuj yic sb'at eb' vin̈ d'a yichan̈ vin̈ rey chi' yic tz'ojtacajel eb' vin̈ yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ix sc'anb'an vin̈ rey chi' d'a eb' vin̈ icha tic: —¿Tas munlajelal syal eyuuj? xchi vin̈. Ix yalan eb' vin̈: —Mamin, a on̈ a checab' on̈ tic, molum calnel on̈ icha eb' co mam quicham. ");
INSERT INTO cac_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ix on̈ ja d'a jun lugar tic yujto a d'a Canaán b'aj cajan on̈ te ay vejel, man̈xa b'aj vach' sva noc' co calnel, yuj chi' tzon̈ tevi d'ayach, comonoc scha a c'ol tzon̈ cajnaj d'a lum Gosén, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ix lajvi chi', ix yalan vin̈ rey chi' d'a vin̈aj José: —Yacb'an ix ja vin̈ a mam yed' eb' vin̈ uc'tac ed'oc, ");
INSERT INTO cac_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","vach' tz'ajcan eb' vin̈ d'a tic. Ac' lum Gosén chi' d'a eb' vin̈. A val luum chi' te vach' d'a yol yic Egipto tic, syal scajnaj eb' vin̈ ta'. Tato ay eb' vin̈ uc'tac chi' te jelan d'a iloj noc' chi', syal tzac'och eb' vin̈ yilumaloc noc' in molb'etzal noc', xchi vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ix yic'anpaxb'at vin̈ smam vin̈aj José d'a yichan̈ vin̈ rey chi', yic vach' tz'ojtacajel vin̈ yuj vin̈. Ichato chi' ix yac'an stzatzil sc'ol vin̈ rey chi' vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ix sc'anb'an vin̈ rey chi' d'a vin̈: —¿Jayexo ab'il a q'uinal? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ix tac'vi vin̈aj Jacob chi' icha tic: —Quenanto in q'uinal, an̈ejanto 130 ab'il, ton̈ej tzin b'eyeq'ui, palta d'a yataquil ix aj yec'b'at janic' tiempoal tic vuuj. Manto c'ochlaj in q'uinal icha val ix aj yab'ilal eb' in mam vicham, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ix lajvi chi', ix yalan vach' lolonel vin̈ d'a yib'an̈ vin̈ rey chi', ix elixta vin̈ d'a yol sdespacho vin̈. ");
INSERT INTO cac_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ichato chi', ix yac'an lum luum te vach' vin̈aj José d'a vin̈ smam yed' d'a eb' yuc'tac d'a yol yic Egipto chi', aton lum ay d'a slac'anil chon̈ab' Ramesés, icha ix yutej vin̈ rey chi' yalani. ");
INSERT INTO cac_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ayn̈ejoch vin̈aj José chi' yac'an svael eb', ato syala' jantac sb'isul junjun eb'. ");
INSERT INTO cac_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ix te em vejel d'a masanil yol yic Egipto chi' yed' d'a yol yic Canaán, man̈xalaj ixim trigo, junlajanxon̈ej van scham eb' anima yuj vejel. ");
INSERT INTO cac_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Masanil q'uen stumin eb' aj Egipto yed' eb' aj Canaán chi', ix b'at yac'can eb' yuj ixim trigo. Masanil q'uen ix sic'b'at vin̈aj José d'a yol sdespacho vin̈ rey. ");
INSERT INTO cac_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Axo yic ix lajviel q'uen tumin d'a Egipto yed' d'a Canaán chi', ix b'at yalan eb' vin̈ aj Egipto chi' d'a vin̈aj José icha tic: —A ticnaic mamin, na'a tas tzon̈ aji. Toxo ix lajvib'at q'uen co tumin, ac' tas sco va'a, yic vach' max on̈ chami, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ix tac'vi vin̈aj José d'a eb' vin̈ icha tic: —Tato man̈xa q'uen e tumin chi', iq'ueccot noc' e molb'etzal noc', syal vac'an ixim e trigo sq'uexuloc noc', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Yuj chi', a d'a jun ab'il chi', ix yac' noc' schej eb' vin̈, noc' scalnel eb' vin̈, noc' svacax eb' vin̈ yed' noc' sb'uru eb' vin̈ sq'uexuloc ixim trigo chi'. ");
INSERT INTO cac_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","A yuj noc' molb'etzal noc' ix ec' jun ab'il chi', palta an̈eja' ay vejel. Ix b'at yalanxi eb' vin̈ d'a vin̈aj José chi': —Max yal-laj co c'ub'anel d'ayach mamin, man̈xalaj q'uen co tumin, man̈xa paxlaj noc' co molb'etzal noc', icxo noc' smasanil. Man̈xa tas syal cac'an d'ayach, axon̈ej to scac'och co b'a yed' co luum d'a yol a c'ab'. ");
INSERT INTO cac_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Colvajan̈ d'ayon̈, yic vach' max on̈ chami, max canlaj co luum tic d'a ichn̈ejta'. Vach' tzon̈ a manel yed' luum, tzon̈ cann̈ej schecab'oc vin̈ rey, syiquejcanel lum luum vin̈ b'aj tzon̈ munlaj chi'. An̈ej to tzac' ixim trigo co va'a yed' in̈at scavej d'a sat luum, yic max on̈ chami, yic max canpax tz'inan luum, xchi eb' vin̈ d'a vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","21","Icha chi' ix yutej vin̈aj José smanancanel masanil lum luum d'a eb' vin̈ aj Egipto chi' yic tz'ochcan lum yicoc vin̈ rey. Yuj jun nivan vejel chi', ix schon̈canel sb'a eb' yed' sluum chi'. Masanil eb' ix ochcan schecab'oc vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","An̈ej sluum eb' sacerdote maj smanel-laj vin̈aj José chi', yujto tz'ac'ji strigo eb' sva yuj vin̈ rey chi', yuj chi' malaj slum eb' vin̈ chi' ix schon̈eli. ");
INSERT INTO cac_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ix yalan vin̈aj José chi' d'a eb' anima icha tic: —A ticnaic yic exxo vin̈ rey yed' lum e luum, yujto ix ex in mancaneli. Iq'uecb'at ixim in̈at, yic tzeyavej ixim. ");
INSERT INTO cac_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ato syala' jantac tzeyic' d'a luum, tzeyac'an chab' almul d'a junjun quintal d'a vin̈ rey, axo d'a ixim vajxaque' almul, ata' ol elta ixim in̈at ol eyavej, an̈ejtona' ata' ol elta ixim ol e va yed' eyuninal yed' masanil mach ayec' eyed'oc, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Yuj chi', ix yalan eb' vin̈ icha tic: —Te vach' a pensar mamin, uuj man̈ ol on̈ chamoc. A ticnaic, tic tzon̈ ochcan schecab'oc vin̈ rey chi', xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ichaton chi' ix yutej vin̈aj José yac'an jun ley chi', chab' almul yic vin̈ rey d'a junjun quintal syac' eb' anima cajan d'a masanil yol yic Egipto chi'. Icha chi' ix ajcan jun ley chi'. An̈ej eb' vin̈ sacerdote max ac'anlaj stojol chi', yujto maj schon̈el-laj slum eb' d'a vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Masanil eb' yin̈tilal vin̈aj Israel, ix can eb' d'a Egipto, ix smaccan lum luum eb' d'a Gosén. Ata' ix te q'uib'chaan̈ sb'isul eb'. ");
INSERT INTO cac_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","17 ab'il ix ec' vin̈aj Israel d'a Egipto chi', yuj chi', 147 ab'il sq'uinal vin̈. ");
INSERT INTO cac_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ayic toxo val scham vin̈ syab'i, ix schecan vin̈ avtajcot vin̈aj José. Ix yalan vin̈ d'a vin̈ icha tic: —Tato xajan in val uuj, ac'och a c'ab' d'a yalan̈ in xub' tic, tzac'an a ti' d'a yichan̈ Dios to ol a c'anab'ajej tas ol val tic. Tzin tevi d'ayach to man̈ ol in a muc d'a Egipto tic, ");
INSERT INTO cac_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","a d'a stz'ey b'aj mucan eb' in mam vicham, ata' tzeyic'b'at in nivanil tic, tze mucanem b'aj mucan eb' chi', xchi vin̈. —Icha chi' ol vutej mamin, xchi vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ix yalanxi vin̈ to syac' sti' vin̈aj José chi' d'a Dios, ix yac'an sti' vin̈ chi'. Ix lajvi chi' ix em n̈ojan vin̈aj Israel chi' d'a sjolom sch'at, ix yac'an yuj diosal vin̈ d'a Dios. ");
INSERT INTO cac_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ix ec' jab'oc stiempoal, ix alchaj d'a vin̈aj José chi' to penaxoay vin̈ smam vin̈. Yuj chi' ix b'at vin̈ yil vin̈, ix yic'anb'at eb' yuninal vin̈ schavan̈il yed'oc, aton vin̈aj Manasés yed' vin̈aj Efraín. ");
INSERT INTO cac_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ayic ix alchaj d'a vin̈aj Israel to toxo ix ja vin̈aj José chi' yila', ix yac' pural sb'a vin̈ sq'ue c'ojan d'a sti' sch'at. ");
INSERT INTO cac_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ix yalan vin̈ icha tic: —A Dios Syal Yuuj Masanil, a' ix sch'ox sb'a d'ayin d'a chon̈ab' Luz, d'a yol yic Canaán. Ata' ix yal vach' lolonel d'a vib'an̈, ix yalan icha tic: ");
INSERT INTO cac_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ab' jun, tzijtum sb'isul in̈tilal ol vac'a'. A jantac in̈tilal, tzijtum nación ol ajelc'ochoc. Ol vac'anpax jun luum tic d'ayach yed' d'a masanil eb' in̈tilal chi', ol eyiquej lum d'a juneln̈ej, xchi Dios chi'. ");
INSERT INTO cac_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yuj chi', a val chavan̈ uninal ix alji d'a Egipto tic ayic manto in javoc, aton vin̈aj Manasés yed' vin̈aj Efraín, victaxon yaj eb' vin̈, icha vuninal tz'ajcan eb' vin̈, icha val yaj vin̈aj Rubén yed' vin̈aj Simeón. ");
INSERT INTO cac_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","A jantacto eb' uninal toto ol aljoc, icxo ol aj eb', a d'a smacb'en chavan̈ eb' yuc'tac eb' tic ol yic' yic eb'. ");
INSERT INTO cac_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ayic in meltzajnac d'a Padán-aram, chamnaccan ix a nun d'a Canaán ayic manto in javilaj d'a Efrata. A d'a sb'eal Efrata chi' ix in muccan ix, xchi vin̈. (A jun lugar chi' Belén sb'i ticnaic.) ");
INSERT INTO cac_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ix lajvi chi', ix b'at q'uelan vin̈aj Israel chi' d'a eb' vin̈ chavan̈ yuninal vin̈aj José chi', ix sc'anb'an vin̈ icha tic: —A eb' vin̈ tic, ¿mach eb' vin̈? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","—A eb' vin̈ vuninal ix yac' Dios d'ayin d'a Egipto tic, xchi vin̈aj José chi'. Ix lajvi chi, ix yalan vin̈ smam vin̈ chi': —Elocab' d'a a c'ool, snitzocab'cot sb'a eb' vin̈ d'a in tz'ey tic yic vach' ol valcan vach' lolonel d'a yib'an̈ eb' vin̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yujto te icham vinacxo vin̈aj Israel chi', maxtzac yal-laj yilan vin̈. Yuj chi' ix nitzchajcot eb' vin̈ yuj vin̈aj José chi' d'a stz'ey vin̈. Ix och lac'lac' vin̈ d'a eb' vin̈, ix tz'ub'jielta sti' eb' vin̈ yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ix lajvi chi' ix yalan vin̈ d'a vin̈aj José icha tic: —Te maxtzac in nalaj tato olto ach vila'. Tic val man̈oc achn̈ej tzato ach vila', palta ix el d'a sc'ol Dios to ixto val viloch eb' vin̈ uninal tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ix lajvi chi', ix yic'anelta eb' vin̈ vin̈aj José chi' d'a scal yoc vin̈ smam chi', ix em n̈ojan vin̈ d'a yichan̈ vin̈ smam chi. ");
INSERT INTO cac_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ix yic'anxib'at eb' vin̈ yuninal vin̈ chi': A vin̈aj Efraín d'a svach' vin̈, axo vin̈aj Manasés d'a sq'uexan̈ vin̈. Ix yic'anb'at eb' vin̈ b'aj ay vin̈ smam chi'. Yuj chi' a vin̈aj Efraín chi' ix can d'a sq'uexan̈ vin̈aj Israel chi', axo vin̈aj Manasés ix can d'a svach' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ayic ix yac'anb'at sc'ab' vin̈ chi' d'a yib'an̈ eb' vin̈, culus ix yutejb'at sc'ab' vin̈ chi' d'a yib'an̈ eb' vin̈. Yuj chi', a svach' vin̈ ix c'och d'a yib'an̈ vin̈aj Efraín chi', axo sq'uexan̈ vin̈ ix c'och d'a yib'an̈ vin̈aj Manasés chi', vach'chom b'ab'el vinac vin̈aj Manasés chi'. ");
INSERT INTO cac_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ix yalan vach' lolonel vin̈ d'a yib'an̈ vin̈aj José chi', icha tic: A Dios aton jun ix c'anab'ajaj yuj vin̈ in mam icham aj Abraham yed' vin̈ in mam aj Isaac, a' tzin tan̈vani yictax ix in alji yed' pax ix in b'eyn̈ejcoti. ");
INSERT INTO cac_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","A jun yángel Dios ix in colan d'a syaelal. Yac'ocab' svach'c'olal Dios d'a yib'an̈ eb' vin̈ chavan̈ tic, yujocab' eb' vin̈ tzin nachajcoti, nachajocab'paxcot vin̈ in mam icham aj Abraham yed' vin̈ in mam aj Isaac. Tzijtum ol aj sb'isul yin̈tilal eb' vin̈ chavan̈ tic d'a sat lum luum b'aj ol cajnajoc, xchi vin̈aj Israel chi'. ");
INSERT INTO cac_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Max schalaj sc'ol vin̈aj José chi' to a d'a yib'an̈ vin̈aj Efraín chi' ix yac'q'ue svach' c'ab' vin̈ smam chi'. Yuj chi' ix yac'lej vin̈ yic'anel svach' c'ab' vin̈ smam chi' d'a yib'an̈ vin̈aj Efraín chi', ix yac'anq'ue vin̈ d'a yib'an̈ vin̈aj Manasés yalani. ");
INSERT INTO cac_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ix yalan vin̈ icha tic: —Maay mamin, man̈ ichocta' tzutej, a d'a vin̈ b'ab'el tic, ata' tzac'q'ue a vach' c'ab', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Maj yal-laj sc'ol vin̈ smam vin̈ chi', ix yalan vin̈ icha tic: —Vojtacxo ach vuninal. A vin̈ tic, nivan chon̈ab' ol aj yelc'och vin̈ d'a b'aq'uin̈, palta a vin̈ tzac'an tic yelxo val nivan ol aj yelc'och vin̈ d'a vin̈ b'ab'el tic, axo yin̈tilal vin̈, tzijtum nación ol ajelc'ochoc, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ix lajvi chi', ix yalan vach' lolonel vin̈ d'a yib'an̈ eb' schavan̈il: —Icha tic ol aj e b'inaj yuj eb' e c'ab' eyoc d'a b'aq'uin̈ ayic ol snib'ej eb' yalan vach' lolonel d'a yib'an̈ junoc anima: Yac'ocab' svach'c'olal Dios d'a ib'an̈, icha ix aj yac'an d'a vin̈aj Efraín yed' d'a vin̈aj Manasés, xcham eb', xchi vin̈aj Israel chi'. A d'a aloj vach' lolonel chi', b'ab'el ix yac' b'inaj vin̈aj Efraín chi' vin̈ d'a yichan̈ vin̈aj Manasés chi'. ");
INSERT INTO cac_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","D'a elan̈chamel ix yalanxi vin̈ d'a vin̈aj José chi': —Ach vuninal, a in tic toxo ol in chamoc, palta ayn̈ejoch Dios eyed'oc, ayn̈ejpaxoch yed' eb' eyin̈tilal. A ol ex ic'an meltzaj d'a slum co mam quicham. ");
INSERT INTO cac_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Svac' junxo macan̈ macb'en d'ayach ec'to d'a yichan̈ yic eb' uc'tac, aton lum pac'an ix vic'canec' d'a eb' amorreo d'a scal oval, xchi vin̈aj Israel chi' d'a vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ix lajvi chi' ix yavtancot eb' yuninal vin̈aj Jacob chi' smasanil, ix yalan vin̈: Ex vuninal, nitzeccot e b'a d'a in tz'ey. Ab'ec tas ol ex aj d'a yic b'aq'uin̈: ");
INSERT INTO cac_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Nitzeccot e b'a d'a in tz'ey, ol valan d'ayex. Ab'ec tas ol val a in Israel e mam in tic: ");
INSERT INTO cac_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ach Rubén, a ach ton in b'ab'el unin ach, sch'oxel sb'a vip d'ayach. A ach tic toxonton ay a may, nivan elc'och d'a yichan̈ eb' uc'tac. ");
INSERT INTO cac_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","A ticnaic, man̈xalaj ol aj elc'ochi, yujto lajan ach icha junoc eluma', yujto q'uixveltac ix in utej d'a in vaynub' ayic ix ach vay yed' ix schab'il vetb'eyum. ");
INSERT INTO cac_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","A ach tic ach Simeón yed' ach tic Leví, eyuc'tac e b'a, a eyamc'ab' yic oval ix eyac'lab'ej ayic ix e c'ulan chucal. ");
INSERT INTO cac_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Juneln̈ej malaj in gana tzin c'och b'aj tz'och e molchajel, yujto ayic ix cot oynaj ix eyila', ix e milcham anima. Ina ayic ix cot eyoval ix e mac'q'uichaj yoc noc' mam vacax. ");
INSERT INTO cac_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Cotocab'can catab' d'a eyib'an̈ yuj yoval e jolom chi', ina man̈ jab'oc tz'oc' e c'ool. Yuj chi' ol ex in saclemejcanb'at d'a scal eb' eyetchon̈ab' Israel. ");
INSERT INTO cac_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ach vuninal Judá, ol alchaj val vach' lolonel d'ayach yuj eb' uc'tac tic. Ol ach och b'inb'in d'a sjaj eb' ayoch ajc'olal d'ayach. Ol em n̈ojjab' eb' uc'tac tic d'ayach. ");
INSERT INTO cac_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Lajan ach val icha junoc noc' quelem choj, ayic slajvi schianb'at junoc noc' noc' ix smila', spaxta d'a sn̈aq'ueen. Tz'em n̈ojan, tz'em cutzan d'a sat lum. Icha val junoc nivaquil choj, ¿mach val junoc ol stec'b'ej sb'a ach stzuntzani? ");
INSERT INTO cac_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Malaj mach syal yic'anec' snivanil elc'ochi. Malaj mach syal yic'anec' a c'ococh d'a yol a c'ab', masanto ol ja jun Mach ay yico', jun mach to masanil nación ol c'anab'ajanoc. ");
INSERT INTO cac_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ol yetzb'anoch sb'uru d'a jun yib' te' uva yelxo val vach', ol sjuc'an spichul d'a yal uva. ");
INSERT INTO cac_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","A yol sat, te q'uic' yilji d'a yichan̈ vino, axo q'uen ye, yelxo val te sac d'a yichan̈ noc' lech. ");
INSERT INTO cac_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","A achxo tic ach Zabulón, a d'a sti' a' mar b'aj sc'och te' barco ol ach cajnajoc. A stz'acan̈il lum a luum, ol c'och d'a Sidón. ");
INSERT INTO cac_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","A achxo tic ach Isacar, lajan ach icha junoc noc' b'uru cuchum icatz syic' yip d'a yol macte'. ");
INSERT INTO cac_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ayic ol ilanochi to te vach' junoc lugar, vach' ol ic' ip ta', tzac'anoch yich a patic d'a yalan̈ icatz, man̈xalaj tas tzala' tzach ochxon̈ejcan checab'oc. ");
INSERT INTO cac_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","A achxo tic ach Dan, a ach val ol a ch'olb'itej a chon̈ab' icha val smojal tz'aj sch'olb'itaj junoc macan̈ eb' etisraelal. ");
INSERT INTO cac_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","A ach tic, lajan tzutej a b'a icha val junoc noc' ajavchan tz'ec' b'ac'ac'oc d'a ti b'e, to schiji yoc noc' chej yuj noc', yuj chi' sjulcanel noc' mach ayq'ue d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Mamin Jehová tzin tan̈vej in a colani. ");
INSERT INTO cac_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","A achxo tic ach Gad, sc'och eb' ajc'ol yac' oval ed'oc, palta slajvub'alxo ol ac' ganar eb'. ");
INSERT INTO cac_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","A achxo tic ach Aser, ol yac'n̈ej sobre tas ol a va'a. Ol ac'anpax tas ol sva eb' vin̈ rey. ");
INSERT INTO cac_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","A achxo tic ach Neftalí, libre aj icha junoc noc' cob'es c'ultaquil chej. A val vach' pensaril ol ala'. ");
INSERT INTO cac_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","A achxo tic ach José, lajan ach val icha junoc te te' ay d'a sti' junoc a a', ste el c'uyan, man̈ jantacoc sat syac'a', sc'axpajec' sc'ab' d'a yib'an̈ smacte'al. ");
INSERT INTO cac_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Te ajc'ol syutej sb'a eb' anima d'ayach, sjulvaj eb' yed' sjul-lab' d'ayach, tz'och val ijan eb' ach stzuntzani. ");
INSERT INTO cac_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","A ach tic, te ay val yip a c'ab', te vach' yaj a jul-lab' yuj val yip in Diosal Syaln̈ej yuuj, aton Vilumal yed' in Columal a in Israel in tic, ");
INSERT INTO cac_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","yuj val yip in Diosal, aton ol ach colanoc. A Dios Syal Yuj Smasanil ol yac' svach'c'olal d'a ib'an̈, aton n̈ab' scot d'a satchaan̈ yed' syaxil sat lum luum. Yuj svach'c'olal ol q'uib' sb'isul eb' uninal yed' noc' a molb'etzal noc'. ");
INSERT INTO cac_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ach José, masanil juntzan̈ vach' lolonel svalcan tic d'a ib'an̈ a in a mam in tic, yelxo val te nivan yelc'och d'a yichan̈ vach' lolonel ix yalcan in mam d'a vib'an̈, yelxo val nivan d'a yichan̈ juntzan̈ vitz aytax ec' d'a peca'. A masanil juntzan̈ tic svalcan d'a ib'an̈, to sic'b'ilachcanel d'a scal eb' vin̈ uc'tac tic. ");
INSERT INTO cac_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","A achxo tic ach Benjamín, lajan ach val icha junoc noc' oques te ov. Ayic van sacb'i q'uinal schianb'at schib'ej noc' smila', ayic q'uic'b'alilxo spucanb'at tas tz'ilchaj yuuj, xchi vin̈aj Israel chi'. ");
INSERT INTO cac_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Aton val stzolal eb' lajchavan̈ yuninal vin̈aj Israel tic. Masanil juntzan̈ lolonel tic ix yal vin̈ ayic ix yalancanel vach' lolonel vin̈ d'a yib'an̈ junjun eb' vin̈ yuninal chi', icha val smojal tas ol aj junjun eb'. ");
INSERT INTO cac_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ix lajvi chi', ix yalan vin̈ d'a eb' vin̈ yuninal chi': Toxo val ol in chamoc, yuj chi' a b'aj mucb'il eb' in mam vicham tzin e mucu', aton lum manb'il d'a vin̈aj Efrón hitita ");
INSERT INTO cac_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","d'a yol yic Canaán. A tas ix val tic, syalelc'ochi, aton d'a q'uen olan q'uen yic Macpela d'a slac'anil lum yic vin̈aj Mamre, manb'ilcan yuj vin̈ co mam quicham aj Abraham yic b'aj smucchaj schamnac vin̈. ");
INSERT INTO cac_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ata' smucnaccan ix Sara vin̈, aton ix yetb'eyum vin̈. Ata' mucchajnacpax vin̈. Ata' mucancan vin̈ co mam aj Isaac yed' ix co nun ix Rebeca. Ata' in mucnacpaxcan ix Lea. ");
INSERT INTO cac_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","A jun lum chi' yed' q'uen olan q'uen chi', manb'ilcan d'a eb' vin̈ hitita, xchi vin̈ d'a eb' vin̈ yuninal chi'. ");
INSERT INTO cac_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ix lajvi yalan vin̈ d'a eb' vin̈ yuninal chi' yuj tas ol aj smucchaj snivanil yuj eb' vin̈, ix ec' jichan vin̈, ix cham vin̈ b'ian. ");
INSERT INTO cac_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ix b'at lac'naj vin̈aj José chi' d'a snivanil vin̈ smam chi', ix och ijan vin̈ yoq'ui, ix stz'ub'anelta sti' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ix lajvi chi', ix yalan vin̈ d'a eb' vin̈ smunlajvum to syac'och remeyo eb' vin̈ d'a snivanil vin̈ smam chi'. Ix ac'jiochi, yic vach' max c'a snivanil vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","40 c'ual ix yic'a' yic tz'ac'jioch remeyo chi'. 70 c'ual ix cus eb' vin̈ aj Egipto chi' yuj schamel vin̈aj Jacob chi'. ");
INSERT INTO cac_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ix lajvi 70 c'ual chi', ix b'at lolon vin̈aj José chi' yed' eb' vin̈ ayoch d'a yopisio yed' vin̈ rey, ix yalan vin̈: —Tato vach' in d'a e sat, oc'ocab' e c'ol d'ayin, b'at ex lolon d'a vin̈ rey vuuj. ");
INSERT INTO cac_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Yujto ayic toxo scham vin̈ in mam, ix yalan vin̈ d'ayin to svac' in ti' yic b'at in muccan vin̈ d'a jun b'aj sb'onaccan d'a yol yic Canaán. Yuj chi' tzin tevi to tzin b'at in muccan vin̈ in mam chi'. Slajvi in mucancani, tzin paxta, xchi vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ix tac'vi vin̈ rey chi' d'a vin̈ icha tic: —Ixic, ix muccan snivanil vin̈ a mam chi', icha val ix aj alan chi' ayic ix ac'an a ti' d'a vin̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ix lajvi chi', ix b'at vin̈aj José chi' smuccan snivanil vin̈ smam chi'. Masanil eb' ayoch d'a yopisio yed' vin̈ rey d'a yol yic Egipto chi', ix b'at eb' mucval yed' vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Masanil eb' ayec' d'a yol spat vin̈aj José chi' ix b'ati. Ix b'atpax eb' vin̈ yuc'tac vin̈ chi' yed' masanil eb' ayec' d'a spat vin̈aj Jacob chi'. Axon̈ej eb' cotac unin ix can d'a Gosén yed' pax noc' noc'. ");
INSERT INTO cac_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ay pax mach yed'nac scarruaje ix b'at mucval chi', ay pax mach ayq'ue d'a yib'an̈ chej ix b'ati, yuj chi' tzijtum anima ix b'at mucval chi'. ");
INSERT INTO cac_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ayic ix c'och eb' d'a Goren-ha-atad d'a slac'anil a' nivan Jordán, ata' ix sch'ox val scusc'olal eb' mucvajum chi' masanil. Uque' c'ual ix oc' vin̈aj José yuj vin̈ smam d'a jun lugar chi'. ");
INSERT INTO cac_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ayic ix yilan eb' cananeo d'a jun lugar chi' tas ix yutej sb'a eb' aj Egipto yed' schamnac, ix yalan eb' icha tic: A eb' aj Egipto tic, te nivan syutej eb' yilvi ac'val yuj schamnac, xchi eb'. Yuj chi', Abel-mizraim ix yac' eb' sb'iej jun lugar chi'. A d'a slac'anil a' nivan Jordán ay jun lugar chi'. ");
INSERT INTO cac_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Masanil tas ix sc'ancan vin̈aj Jacob d'a eb' yuninal, ix sc'anab'ajej eb' sc'ulani. ");
INSERT INTO cac_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ina to ix yic'b'at snivanil vin̈ eb' d'a yol yic Canaán. Ix smucancan eb' d'a q'uen olan q'ueen d'a Macpela, aton q'uen manb'ilcan yed' lum luum yuj vin̈aj Abraham d'a vin̈aj Efrón hitita. A jun chi' ix och scampusanteoc eb' vin̈. A jun lum b'aj ay q'uen olan q'uen chi', a d'a slac'anil lum yic vin̈aj Mamre chamnac ay. ");
INSERT INTO cac_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ix lajvi smucancan vin̈ smam vin̈aj José chi', ix paxta vin̈ yed' eb' vin̈ yuc'tac yed' masanil eb' vin̈ ajun yed'oc, ix c'ochxi eb' vin̈ d'a Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ayic ix lajvi scham vin̈aj Jacob chi', ix och ijan eb' vin̈ yuc'tac vin̈aj José snaani, ix yalan eb' vin̈: A ticnaic tecan ol cot yoval vin̈aj José tic d'ayon̈, tecan ol spactzitej vin̈ masanil tas cutejnac, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Yuj chi' ix yac'b'at sti' eb' vin̈, ix yalan icha tic: Ayic manto cham vin̈ co mam, ix yalancan vin̈ to scal d'ayach icha tic: ");
INSERT INTO cac_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Tzin tevi d'ayach to tzac' nivanc'olal d'a yib'an̈ eb' vin̈ uc'tac tic, yuj tas chuc sc'ulejnac eb' vin̈ d'ayach. Icha chi' ix aj yalancan vin̈. Yuj chi' a on̈ schecab' on̈ co Diosal yed' co mam chi', scalb'at d'ayach to tzon̈ ac' nivanc'olal yuj jantac chucal co c'ulejnac d'ayach, xchib'at eb' vin̈. Ayic ix yalan schecnab'il eb' vin̈ checab' chi', ix oc'q'ue vin̈aj José chi'. ");
INSERT INTO cac_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Axo ix c'och eb' vin̈ yuc'tac vin̈ chi' d'a yichan̈, ix em n̈ojjab' eb' vin̈ d'a sat luum, ix yalan eb' vin̈ icha tic: —A on̈ tic cuc'tac, a checab' caji, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ix tac'vi vin̈aj José chi' icha tic: —Man̈xo e na jun chi', max yal-laj vac'anoch in b'a sq'uexuloc Dios. ");
INSERT INTO cac_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","A ex val tic, te chuc e pensar, ix e c'ulan juntzan̈ chuc pensaril chi' d'ayin, palta a Dios ix q'uexan jun e chuc pensaril chi' d'a vach'il, yic tzijtum eb' anima scolchajeli, ichaton van quilan tic. ");
INSERT INTO cac_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Yuj chi', man̈ ex och ilc'olal yuj jun chi'. Ol viln̈ej tas ol aj yec' eyuuj yed' eb' eyuninal, xchi vin̈ d'a eb' vin̈. Yuj chi', ix stzalajb'ixi sc'ol eb' vin̈, yujto vach' ix yutej vin̈ slolon d'a eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ixto ec' vin̈aj José yed' eb' sc'ab'yoc d'a Egipto chi'. 110 ab'il ix yil vin̈. ");
INSERT INTO cac_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ixto val yil eb' schab'il yixchiquin vin̈aj Efraín vin̈aj José chi'. Icha pax chi' eb' yuninal vin̈aj Maquir, yuninal vin̈aj Manasés, ixto yil vin̈aj José yochcan eb' stz'acub'oc d'a yol spat. ");
INSERT INTO cac_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ay jun c'ual ix yal vin̈aj José chi' d'a eb' vin̈ yuc'tac icha tic: Toxo val ol in chamoc, palta a Dios ol och eyed'oc, ol ex yic'anel d'a jun lugar tic, ol ex yic'an meltzaj d'a lum luum yaltejnaccan d'a vin̈ co mam quicham aj Abraham yed' d'a vin̈ co mam quicham aj Isaac yed' pax d'a vin̈ co mam aj Jacob, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ix yalan vin̈ d'a eb' vin̈ sc'ab'yoc to syac' sti' eb' vin̈ d'a yichan̈ Dios, ix yalan vin̈: Val yel, a Dios ol ochn̈ej eyed'oc. Ol colvajn̈ej eyed'oc. A d'a jun tiempoal ayic ol ex b'at chi', tzeyic'b'at in nivanil tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ayic ix cham vin̈aj José chi' d'a Egipto, 110 ab'il sq'uinal vin̈. Vach' ix aj yoch remeyo d'a snivanil vin̈, ix ac'jiem vin̈ d'a yol scaxail d'a Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Aton sb'i eb' yuninal vin̈aj Israel tic, eb' ajun yed' vin̈ ayic sc'ochnac vin̈ d'a Egipto yed' yal yuninal junjun eb': ");
INSERT INTO cac_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Aton vin̈aj Rubén, vin̈aj Simeón, vin̈aj Leví, vin̈aj Judá, ");
INSERT INTO cac_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","vin̈aj Isacar, vin̈aj Zabulón, vin̈aj Benjamín, ");
INSERT INTO cac_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","vin̈aj Dan, vin̈aj Neftalí, vin̈aj Gad yed' vin̈aj Aser. ");
INSERT INTO cac_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ay 70 sb'isul eb' yin̈tilal vin̈aj Jacob chi' d'a smasanil. A vin̈aj José, aytaxon ec' vin̈ d'a Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","A vin̈aj José chi' yed' masanil eb' yuc'tac yed' eb' ajun yed' vin̈aj Jacob chi', junjunal ix laj chamel eb', ");
INSERT INTO cac_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","palta tzijtumto yin̈tilal eb' ix elcani, ix te q'uib' sb'isul eb'. Yelxo val te ay smay ix aj eb'. Ix b'ud'jiel masanil yol yic Egipto chi' yuj eb'. ");
INSERT INTO cac_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Nivanxo tiempo ayec' eb' ta', axo ix aji, ix och junxo vin̈ rey d'a Egipto chi'. Man̈xo yojtacoc jab'oc yab'ixal vin̈aj José chi' vin̈. Ix yalan vin̈ d'a smasanil eb' chon̈ab': ");
INSERT INTO cac_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Tzam eyil ticnaic te tzijtum ix aj juntzan̈ eb' israel tic, yelxo val ay smay eb' d'a quichan̈. ");
INSERT INTO cac_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","A ticnaic yovalil sco na' tas tz'aj eb', yic vach' man̈ ol te q'uib' sb'isul eb', yujto talaj ay b'aq'uin̈ ay mach scot ul yac' oval d'ayon̈, syac'anoch sb'a eb' yed' eb' cajc'ol chi', axo eb' vin̈ smolan sb'a yac'an oval chi' qued'oc. Tzam elcan eb' libre d'a tic, xchi vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Yuj chi', ix ac'jioch yilumal eb' israel chi', ix ac'jioch eb' d'a munlajel te ya. Ix checji sb'o eb' juntzan̈ chon̈ab' te nivac, aton Pitón yed' Ramesés. A d'a juntzan̈ chon̈ab' chi' ix smolb'ej ixim trigo vin̈ rey. ");
INSERT INTO cac_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Vach'chom te ya tz'ec' eb' israel yuj eb' aj Egipto chi', palta an̈eja' ste q'uib' sb'isul eb', yuj chi' ix te xiv eb' aj Egipto chi' d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ix ac'jioch eb' d'a munlajel te ya. ");
INSERT INTO cac_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Yelxo te ya tz'utaj eb' vin̈ d'a munlajel. Ix ac'chajoch eb' d'a tec'oj soc'om yed' b'o'oj xan. Man̈ocn̈ej chi', ay eb' smunlajpax d'a avoj trigo yed' juntzan̈xo munlajel. Yelxo val ilb'ajc'ol tz'utaj eb'. ");
INSERT INTO cac_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ay val junxo ix utaj eb' yuj vin̈ rey chi'. Ay jun checnab'il ix yac' vin̈ d'a ix Sifra yed' d'a ix Fúa, aton eb' ix vetz'vajum yaj d'a scal eb' ix hebrea (ma eb' ix israel), ix yalan vin̈ icha tic: ");
INSERT INTO cac_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","—Ayic tzeyilan sb'o sc'ol eb' ix hebrea chi', tzan̈ej val alji jun nene' unin chi', tzeyilani tato vinac, tze mac'chamoc. Tato ix, q'uib'ocab'i, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Palta a eb' ix vetz'vajum chi', xiv eb' ix d'a Dios. Maj sc'anab'ajejlaj eb' ix icha ix yal vin̈ rey chi', ton̈ej syiloch eb' ix ayic tz'alji eb' vinac unin chi'. ");
INSERT INTO cac_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ayic ix yab'an jun chi' vin̈ rey, ix avtaj eb' ix yuj vin̈, ix yalan vin̈ d'a eb' ix: —¿Tas yuj ton̈ej tzeyiloch juntzan̈ vinac unin tz'alji chi'? xchi vin̈ d'a eb' ix. Yuj chi' ix yalan eb' ix: ");
INSERT INTO cac_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","—Mamin, man̈ lajanoc eb' ix hebrea yed' eb' ix quetchon̈ab'. A eb' ix hebrea chi' te ay yip snivanil eb' ix, manto on̈ c'ochlaj, sb'o sc'ol eb' ix, xchi eb' ix. ");
INSERT INTO cac_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","A yuj jun tas ix sc'ulej eb' ix vetz'vajum chi', ix te q'uib' sb'isul eb' israel. Yelxo val ay smay eb'. ");
INSERT INTO cac_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Yujto ay yelc'och Dios d'a yol sat eb' ix vetz'vajum chi', yuj chi' ix yac' svach'c'olal Dios chi' d'a yib'an̈ eb' ix. ");
INSERT INTO cac_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ayic ix yilan vin̈ rey to max yal-laj icha chi', ix yalan vin̈ d'a eb' yetchon̈ab' smasanil icha tic: Masanil eb' vinac unin tz'alji d'a scal eb' hebreo tic, tzeyumcanb'at eb' d'a yol a' Nilo. Tato ix unin jun, q'uib'ocab'i, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","A d'a jun tiempoal chi', ay jun vin̈ vinac d'a scal eb' yin̈tilal vin̈aj Leví, ix yic' jun ix ix vin̈, an̈eja' yin̈tilal pax ix vin̈aj Leví chi'. Ay chavan̈ yune' eb'. ");
INSERT INTO cac_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ix alji junxo svinac unin ix, ix yilan ix to te vach' yilji, oxe' ujal ix sc'ub'ejel ix. ");
INSERT INTO cac_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Axo yic majxo yal-laj sc'ub'anel jun nene' unin chi' ix jun, ix yic'ancot jun xuuc ix, ix yac'anoch juntzan̈ asfalto ix d'ay icha tzataj yic snub'laj sb'a, yic vach' max ochlaj a' d'a yool. Ix lajvi chi' ix yac'anem vin̈ nene' unin chi' ix d'a yool, ix b'at yac'ancan ix d'a scal juntzan̈ te te' icha te' aj d'a sti' a' nivan Nilo. ");
INSERT INTO cac_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Axo jun ix yanab' vin̈ unin chi', najatto ix can ix yic syilb'at ix tas ol aj vin̈. ");
INSERT INTO cac_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Axo ix aji, ix c'och ix yisil vin̈ rey sb'ic sb'a d'a sti' a' chi'. Yacb'an van sb'eyec' eb' ix schecab' ix d'a stitac a' chi', ix yilanb'at ix d'a scal juntzan̈ te' icha te' aj chi' to ayec' jun te' xuuc ta', ix schecanb'at jun ix schecab' ix yic b'at yic'ancot jun xuuc chi'. ");
INSERT INTO cac_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ayic ix sjacan te' ix, ix yilan ix to nene' unin jun ayem d'a yool, van yoq'ui, yuj chi' ix oc' sc'ol ix d'ay, ix yalan ix: —Yic am eb' ix hebrea jun unin tic, xchi ix. ");
INSERT INTO cac_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Axo ix yanab' vin̈ unin chi', ix c'och ix d'a ix yisil vin̈ rey chi', ix yalan ix: —¿Ma max yal a c'ol b'at vavtej junoc ix hebrea yic vach' syac' chunoc jun nene' unin tic ix d'ayach? xchi ix. ");
INSERT INTO cac_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","—Ixic, avtej junoc ix, xchi ix d'a ix unin chi'. Yuj chi' ix b'at ix yal d'a ix snun. Axo ix ja ix nunab'il chi', ix yalan ix yisil vin̈ rey chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","—Ic'b'at jun nene' unin tic, tzilan q'uib'oc, ol ach in tupu', xchi ix. Ix yic'anb'at vin̈ nene' unin chi' ix snun chi', ix sq'uib'tzitan vin̈ ix. ");
INSERT INTO cac_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Axo yic vach'tacxo vin̈, ix b'at ac'jican vin̈ yuj ix snun chi' d'a ix yisil vin̈ rey chi'. Axo ix yisil vin̈ rey chi', icha val yune' ix ix yutej vin̈. Moisés ix yac' ix sb'ioc. Ix yalan ix icha tic: —Yujto a d'a yol a a' ix vic'q'ueta jun unin tic, yuj chi' Moisés ol sb'iej, xchi ix. ");
INSERT INTO cac_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ayic tec'anxo vin̈aj Moisés chi', ix b'at vin̈ yil eb' yetisraelal chi', ix yilan vin̈ to te ya munlajel b'aj ayoch eb'. Van smac'jipax jun vin̈ yetchon̈ab' vin̈ yuj jun vin̈ aj Egipto ix yilan vin̈. ");
INSERT INTO cac_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ix ec' q'ueleloc vin̈, malaj mach van yilani. Yuj chi' ix smac'cham jun vin̈ aj Egipto chi' vin̈, ix smucancanem vin̈ d'a scal q'uen arena. ");
INSERT INTO cac_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Axo d'a junxo c'u ix b'atxi vin̈ yil eb' yetchon̈ab' chi', axo ix yilan vin̈ van yac'an oval chavan̈ eb' vin̈ yetchon̈ab' vin̈ chi'. Ix sc'anb'an vin̈ d'a vin̈ ix mac'vaj chi': —¿Tas yuj tza mac' vin̈ etchon̈ab' tic? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ix tac'vi vin̈ chi': —¿Mach ix ach ac'anoch yajalil, ma juezal d'a co cal tic? ¿Mato tza nib'ej tzin a mac'cham icha utej vin̈ aj Egipto evi? xchi vin̈. Ayic ix yab'an vin̈ tas ix yal vin̈ chi', ix xiv vin̈, yujto ix nachajel yuj vin̈ to ix el specal to ix smac'cham vin̈ aj Egipto chi' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","A ix yab'an specal jun chi' vin̈ rey, ix yac'anb'at sayumal vin̈aj Moisés chi' vin̈ yic smiljicham vin̈. Yuj chi' ix b'at vin̈aj Moisés chi' elelal d'a yol yic Madián. Ayic ix c'och vin̈ d'a sti' jun a' uc'b'ila', ix em c'ojan vin̈ ta'. ");
INSERT INTO cac_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ay jun vin̈ sacerdote scuchan Reuel cajan d'a jun lugar chi', ay ucvan̈ yisil vin̈. Ix xid'ec' eb' ix d'a a' uc'b'ila' chi', yic syac'an b'ud'joc te' jucub' eb' ix yic syuc' a' noc' scalnel vin̈ smam eb' ix chi'. ");
INSERT INTO cac_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ix javi juntzan̈ eb' vin̈ tan̈vum calnel, ix spechanel eb' ix eb' vin̈ ta'. Ix yilan vin̈aj Moisés, ix q'ue jucnaj vin̈, ix b'at vin̈ scol eb' ix, ix yac'an a' vin̈ yuc' noc' scalnel eb' ix chi'. ");
INSERT INTO cac_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ayic ix c'ochxi eb' ix d'a vin̈ smam chi', aton vin̈aj Reuel, ix sc'anb'an vin̈ d'a eb' ix: —¿Tas yuj ix pet ex jax ticnaic? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Axo ix tac'vi eb' ix: —Ay jun vin̈ aj Egipto ix on̈ colan d'a eb' vin̈ tan̈vum calnel, ix yic'anq'ueta a' vin̈ yuc' noc' co calnel tic, xchi eb' ix. ");
INSERT INTO cac_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","—¿B'ajtil ix can vin̈ eyuuj? ¿Tas yuj maj eyic'cot vin̈ d'a tic? Ixiquec elan̈chamel eyavtejcot vin̈ yic ol va vin̈, xchi vin̈ mamab'il chi'. ");
INSERT INTO cac_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Icha chi' ix aj sc'ochcan vin̈aj Moisés d'a spat vin̈aj Jetro chi'. Ayic ix ec'b'at jab'oc tiempo, ix yac'an jun yisil vin̈ yetb'eyumoc vin̈aj Moisés chi', aton ix Séfora. ");
INSERT INTO cac_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ix alji jun yune' ix, Gersón ix yac' vin̈aj Moisés chi' sb'iej, ix yalan vin̈: Ch'oc chon̈ab'il vaj d'a jun lugar tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ayic ayxo tiempo yajec' vin̈ d'a Madián chi', ix cham vin̈ sreyal Egipto. Palta axo eb' israel an̈eja' yab'an syail eb' yujto checab' yaj eb' ta'. Ichato chi' b'ian, ix ab'ji scusc'olal eb' yed' syaelal yuj Dios. ");
INSERT INTO cac_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ix ab'ji yoc' eb' yuuj, ix snaancot strato yed' vin̈aj Abraham, vin̈aj Isaac yed' vin̈aj Jacob. ");
INSERT INTO cac_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Yuj chi' ix ilji syaelal eb' yuj Dios, ix oc' sc'ol d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","A vin̈aj Moisés chi' tan̈voj calnel ix yac' vin̈ yuj vin̈ sn̈i', aton vin̈aj Jetro, sacerdote d'a eb' aj Madián. Ay jun c'u ix b'at vin̈aj Moisés chi' tan̈voj calnel, ix c'axpajec' vin̈ d'a tz'inan luum masanto ix c'och vin̈ d'a yich jun lum vitz scuchan Horeb aton d'a jun lum vitz chi' b'aj ix sch'ox sb'a Dios d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ata' ix sch'ox sb'a jun yángel Jehová d'a scal jun te' q'uiix ayoch sc'ac'al. Vach'chom te ov sq'ue tin̈ton sc'ac'al te', palta max tz'aemlaj te'. ");
INSERT INTO cac_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ix snaan vin̈aj Moisés chi': Te satub'tac yilji jun tic, tas yuj max tz'aem jun te' q'uiix chi'. Tecan b'at vila', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ayic ix yilan Jehová to van snitzancot sb'a vin̈, ix avajelta d'a scal te' c'ac' chi': —Moisés, Moisés, xchi. —Oy, Mamin, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ix yalan Jehová: —Man̈ a nitzcot a b'a d'a tic. Iq'uel a xan̈ab' yujto a jun lugar tic vico', a in ayinec' d'ay. ");
INSERT INTO cac_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","A in tic, sDiosal in a mam, sDiosal in pax eb' a mam icham, aton vin̈aj Abraham, vin̈aj Isaac yed' vin̈aj Jacob, xchi. Ayic ix yab'an vin̈aj Moisés icha chi', ix smacan sat vin̈, yujto ix xiv vin̈ yoch q'uelan d'a Dios chi'. ");
INSERT INTO cac_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ix yalan Jehová chi' d'a vin̈: —Svil val to ilb'ajc'ol tz'utaj eb' in chon̈ab' d'a Egipto. Yelxo val svab' yoc' eb' yuj tas tz'utaj yuj eb' ayoch yilumaloc. Vojtac to yelxo val ilb'ajc'ol sc'ulej in chon̈ab' ta'. ");
INSERT INTO cac_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Yuj chi' ix in emuli, tzin colanel eb' d'a yol sc'ab' eb' aj Egipto chi'. Ol viq'uel eb' d'a jun lugar chi', ol vic'anb'at eb' d'a junxo lum luum yelxo te vach', levan, te yax sat. A eb' cajan d'a sat jun luum chi', aton eb' cananeo, eb' hitita, eb' amorreo, eb' ferezeo, eb' heveo yed' pax eb' jebuseo. ");
INSERT INTO cac_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Yelc'olal sq'ue yav eb' in chon̈ab' Israel stevi d'ayin, yujto te ya yaj eb' d'a chon̈ab' Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Yuj chi', tzach b'at ticnaic, tzach vac'b'at d'a yichan̈ vin̈ sreyal Egipto chi', yic sb'at ach lolonoc yed' b'at ic'anelta in chon̈ab' d'a Egipto chi', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ix yalan vin̈aj Moisés chi': —¿Tas vaj a in tic, yuj chi' ol yal b'at in lolon d'a yichan̈ vin̈ rey chi', yic ol vic'anelta eb' vetchon̈ab' chi'? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Yuj chi' ix tac'vixi Jehová icha tic: —Man̈ ac' pensar, a in ol in och ed'oc. Tic svac' junoc ch'oxnab'il d'ayach to a in tzach in checb'ati: Ayic toxo ix iq'uelta in chon̈ab' d'a Egipto chi', ol ex ja eyaq'uem e b'a d'ayin d'a jun vitz tic, xchi. ");
INSERT INTO cac_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ix tac'vixi vin̈aj Moisés chi' icha tic: —A ol aj jun tic, q'uinaloc b'at in lolon d'a eb' vetisraelal, ol valan d'a eb' to a co Diosal yed' eb' co mam quicham, a ix in checancot d'ayex, ta xin chi d'a eb', axom ol yalan eb' d'ayin: ¿Tas sb'i jun mach tzal chi'? xcham eb' d'ayin. ¿Tas svutejpax tac'voc in b'a? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Yuj chi' ix tac'vi Jehová d'a vin̈: A IN TIC AYIN TAXON EQ'UI. Icha tic tzutej alan d'a eb' etchon̈ab' chi': A jun mach A IN TON TIC sb'i, a' tzin checancot d'ayex, xa chi, xchi Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ix yalanxi Jehová chi' d'a vin̈aj Moisés chi': —Tzalpax d'a eb' etchon̈ab' chi' icha tic: A Jehová co Diosal yed' eb' co mam quicham, aton vin̈aj Abraham, vin̈aj Isaac yed' vin̈aj Jacob, a' ix in checancoti yic tzul in colvaj d'ayex, xa chi d'a eb'. A jun in b'i tic ay d'a juneln̈ej, aton in b'i tic ol b'inaj yuj eb' eyin̈tilal ayic ol b'eyn̈ejb'atoc. ");
INSERT INTO cac_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ixic, tza molb'an eb' yichamtac vinaquil Israel, tzalani: A Jehová co Diosal yed' eb' co mam quicham, aton vin̈aj Abraham, vin̈aj Isaac yed' vin̈aj Jacob, a' ix sch'ox sb'a d'ayin, ix yalani to syila' tas tzex utaj d'a Egipto tic. ");
INSERT INTO cac_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ix yalan d'ayin to ol ex scolel d'a syaelal d'a tic, ol ex yic'anb'at d'a jun lum luum te vach', te ay syaxil sat, aton lum b'aj cajan eb' cananeo, eb' hitita, eb' amorreo, eb' ferezeo yed' eb' jebuseo, xa chi d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ol scha yab' eb' yichamtac vinaquil chon̈ab' chi' tas ol ala', ol b'at och eb' ed'oc b'aj ay vin̈ sreyal Egipto chi'. Ol alani: A Jehová co Diosal a on̈ hebreo on̈ tic, a' ix sch'ox sb'a d'ayon̈. Yuj chi' tzon̈ a chab'at d'a tz'inan luum yic scac' co silab' d'a co Diosal a on̈ tic. ");
INSERT INTO cac_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Vach'chom tzin chec al jun tic, palta vojtac to man̈ ol ex chajiel-laj yuj jun rey chi'. An̈ej d'a ac'b'il puralil ol aj ex schaanel vin̈. ");
INSERT INTO cac_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Yuj chi' ol in ch'ox val vipalil d'a vin̈, ol vac' yaelal d'a yib'an̈ nación Egipto yuj tas satub'tac ol in c'ulej ta', axo eyactajelta chi' yuj vin̈ b'ian. ");
INSERT INTO cac_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Yuj pax chi', a in ol vac'och d'a spensar eb' aj Egipto chi' yic nivan ol aj eyelc'och d'a yol sat eb'. Yuj chi' ayic ol ex el chi' nivan silab' eb' ol yac' d'ayex, man̈ ton̈ejoc ol e much' e c'ab' ol ex b'atoc. ");
INSERT INTO cac_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Junjun eb' ix israel ol sc'an tastac ay d'a eb' ix aj Egipto cajan d'a slac'anil, ma yaln̈ej mach ixal cajan ta', yic syac' plata eb', ma oro, ma pichul yic tzeyac'och yed' eyuninal. Icha chi' ol aj eyic'anb'at sb'eyumal eb' aj Egipto chi', xchi Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ix tac'vi vin̈aj Moisés d'a Jehová: —Man̈ ol yac'ochlaj eb' d'a sc'ool, man̈ ol sc'anab'ajejlaj eb' tas ol vala', axom ol yutej eb' yalan d'ayin: Mato val yel ix sch'ox sb'a Jehová chi' d'ayach mato maay, scham eb' d'ayin, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","—¿Tas jun ed'nac chi'? xchi Jehová d'a vin̈. —A te' in c'ococh, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","—Actejem te' d'a sat lum chi', xchi Jehová chi'. Ix yactanem te' sc'ococh vin̈ chi' d'a sat luum, elan̈chamel ix och te' chanil. Ayic ix yilan jun chi' vin̈aj Moisés chi', ix el lemnaj vin̈. ");
INSERT INTO cac_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ix yalanxi Jehová d'a vin̈: —Yam sn̈e noc' chan chi', xchi. Ix syaman sn̈e noc' chi' vin̈, ix ochxi sc'ocochoc vin̈. ");
INSERT INTO cac_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","—Yuj tas toxo ix il tic, ol yac'och eb' d'a sc'ol to ix in ch'ox in b'a d'ayach, a in ton Jehová a Diosal in, sDiosal in pax eb' e mam eyicham, aton vin̈aj Abraham, vin̈aj Isaac yed' vin̈aj Jacob, xchi. ");
INSERT INTO cac_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ix yalanxi Jehová chi' d'a vin̈: —A ticnaic, aq'uem a c'ab' d'a sn̈i' a c'ool, xchi. Ix yac'anem sc'ab' vin̈ chi' d'a sn̈i' sc'ool, axo ix yic'anelta sc'ab' vin̈ chi', ayxo och yab'il lepra d'ay, toxon̈ej sacvequinac yilji icha q'uen cheev. ");
INSERT INTO cac_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ix yalanxi Jehová chi': —Ac'xiem a c'ab' chi' d'a sn̈i' a c'ool, xchi. Ix yac'anxiem sc'ab' vin̈aj Moisés chi' d'a sn̈i' sc'ol chi', axo ix yic'anxiq'ueta sc'ab' vin̈ chi', te vach'xo icha val snivanil vin̈ smasanil. ");
INSERT INTO cac_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ix yalan Jehová: —Tato max yac'och eb' anima chi' d'a sc'ol tas tzala', tato max sc'anab'ajej pax eb' yuj jun b'ab'el ch'oxnab'il tic, yuj jun schab'il ol yac'och eb' d'a sc'ool. ");
INSERT INTO cac_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Palta tato max yac'och eb' d'a sc'ool, max schaanpax eb' yab' yuj chab' ch'oxnab'il tic, tzic'q'ueta jab'oc a a' d'a a' nivan Nilo, tza secanem a' d'a sat luum, tzan̈ej val em a' d'a sat lum chi', tz'och a' chic'al, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ix lajvi chi', ix yalan vin̈aj Moisés chi' d'a Jehová icha tic: —Ay, ach Mamin Vajalil. Comonoc man̈oc in tzin a checb'ati, yujto yelxo val max yal-laj in loloni, man̈octo tzalan d'ayin tic svalani, palta toxonton in c'olb'al, teveln̈ej syal in loloni, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ix tac'vi Jehová chi': —¿Mach yuj syal slolon eb' anima tza na'a? ¿Tom man̈ vujoc slolon eb'? An̈ejtona' in svac' chacan̈b'oc eb' yed' eb' max yal sloloni yed' eb' max yal yilani. A in svac' yil eb' vach' yilani. ");
INSERT INTO cac_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Yuj chi, ixic, ol in ochn̈ej ed'oc ayic ol ach lolonoc. An̈eja' in ol val tas ol ala', xchi Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ix tac'vixi vin̈aj Moisés chi', ix yalan vin̈: —Ay Mamin Vajalil, comonoc man̈oc in tzin a checb'ati. Vach' tza say junocxo mach, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ix cot yoval Jehová d'a vin̈ ix yalani: —A d'a Egipto chi', ata' ayec' vin̈ uc'tac aj Aarón, yin̈tilal vin̈aj Leví. Vojtac to b'ecan sc'ool vin̈ sloloni. Ol cot vin̈ ach scha'a. Ol te tzalaj vin̈ ayic ol ach yilani. ");
INSERT INTO cac_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","A ach ol ach lolon d'a vin̈. Ol alani tas ol yutoc vin̈ sloloni. A inxo ol val d'ayex ayic van e lolon chi', ol vac'an e nael masanil tas ol e c'ulej. ");
INSERT INTO cac_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","A ach tzach lolon d'a vin̈aj Aarón chi' in q'uexuloc, axo vin̈ ol lolon d'a eb' chon̈ab' a q'uexuloc. ");
INSERT INTO cac_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ic'b'at te' a c'ococh chi', yujto a te' ol ac'lab'ej ayic ol a ch'oxan juntzan̈ ch'oxnab'il ix val d'ayach. ");
INSERT INTO cac_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ix meltzaj vin̈aj Moisés d'a spat vin̈ sn̈i', aton vin̈aj Jetro, ix yalan vin̈: —Ol in meltzaj d'a Egipto yic sb'at vilan eb' ayto vuj in b'a yed'oc, yic svila' tato pitzanto eb', xchi vin̈. —Ixic, tzil val a b'a d'a yoltac b'e, xchi vin̈aj Jetro chi'. ");
INSERT INTO cac_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ayic aytoec' vin̈aj Moisés d'a yol yic Madián chi', ix yalanxi Jehová d'a vin̈: —Ixic d'a Egipto, man̈ ach xiv a b'ati, yujto chamnacxo eb' sgana ach smilanchamoc, xchi. ");
INSERT INTO cac_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ix yic'anb'at ix yetb'eyum vin̈aj Moisés yed' eb' yuninal, ix yac'anq'ue eb' vin̈ d'a yib'an̈ noc' b'uru, ix b'at eb' d'a Egipto chi'. Yed'nac te' sc'ococh vin̈, aton te' ix yal Dios to ol och yopisio yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ix yalan Jehová d'a vin̈: —Ayic ol ach c'och d'a Egipto chi', naann̈ej uuj to ol a ch'ox juntzan̈ ch'oxnab'il te satub'tac d'a yichan̈ vin̈ rey, aton juntzan̈ ix vac' a c'ulej. Palta a in ol vac' pitb'oquel spensar vin̈, yuj chi' man̈ ol ex schael-laj vin̈. ");
INSERT INTO cac_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Slajvi chi', ol alan d'a vin̈: Icha tic yalan Jehová: A jun chon̈ab' Israel tic, icha val to sb'ab'el vuninal yaji. ");
INSERT INTO cac_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Toxo ix val d'ayach to tza chab'at eb' vuninal tic yic tz'och eb' ejmelal d'ayin. Palta toxonton malaj a gana tzactejeli, yuj chi' ol in milcham vin̈ a b'ab'el unin, xchi Jehová, xa chi. ");
INSERT INTO cac_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ix lajvi chi', ix b'at vin̈aj Moisés d'a Egipto chi'. A d'a yoltac b'e b'aj d'in̈an svay vin̈ yed' eb' ajun yed'oc, ata' ix sch'ox sb'a Jehová d'a vin̈, ijan ix miljicham vin̈ yuuj. ");
INSERT INTO cac_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Elan̈chamel ix yic'cot jun cuchilub' ix Séfora, nab'a comon q'ueen, ix spolanel stz'umal sjolom svinaquil vin̈ yune' ix, ix sjulanoch ix d'a yoc vin̈aj Moisés chi', ix yalan ix: Yujto vetb'eyum ach, yuj chi' locan in d'a jun chic' tz'el tic, xchi ix. ");
INSERT INTO cac_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ix lajvi chi' majxo miljichamlaj vin̈ yuj Jehová. ");
INSERT INTO cac_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ix yalan Jehová d'a vin̈aj Aarón: —Ixic b'at a cha vin̈ uc'tac aj Moisés d'a tz'inan luum, xchi d'a vin̈. Yuj chi' ix cot vin̈aj Aarón scha vin̈aj Moisés chi' d'a jun vitz b'aj ix sch'ox sb'a Dios. Axo yic ix schalan sb'a eb' vin̈, ix yac'lan stzatzil sc'ol eb' vin̈, ix stz'ub'lanelta sti' eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ix lajvi chi', ix och ijan vin̈aj Moisés yalan d'a vin̈aj Aarón chi' masanil tas ix schec Jehová yala' yed' juntzan̈ ch'oxnab'il ix checchaj sch'ox vin̈. ");
INSERT INTO cac_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ix b'at eb' vin̈ schavan̈il, ix smolb'an eb' yichamtac vinaquil chon̈ab' Israel eb' vin̈ d'a Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ix lajvi chi', ix och ijan vin̈aj Aarón yalan d'a eb' smasanil tas ix yal Jehová d'a vin̈aj Moisés chi', ix sch'oxanpax juntzan̈ ch'oxnab'il vin̈ yil eb' chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Yuj chi', ix yac'och eb' d'a sc'ool tas ix yal eb' vin̈. Ayic ix yab'an eb' to ix iljicot eb' yuj Jehová, yujto te ilb'ajc'ol tz'utaj eb', yuj chi' ix em n̈ojan eb' ejmelal d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ayic ix lajvi yec'canb'at juntzan̈ chi', ix b'at lolon vin̈aj Moisés yed' vin̈aj Aarón d'a yichan̈ vin̈ sreyal Egipto chi', ix yalan eb' vin̈: —Mamin rey, icha val tic yalan Jehová co Diosal a on̈ hebreo on̈ tic d'ayach: Chab'at in chon̈ab' d'a tz'inan luum yic tzin yic'anchaan̈ eb' yed' junoc q'uin̈, xchi Jehová, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ix tac'vi vin̈ rey chi': —Man̈ vojtacoc jun Jehová tzeyal chi'. ¿Tas yuj tzin c'anab'ajej tas syala', tzin chaanb'at jun chon̈ab' Israel tic? Max in chab'at-laj eb', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ix yalan eb' vin̈: —A co Diosal a on̈ hebreo on̈ tic, ix sch'ox sb'a d'ayon̈. Yuj chi' chaon̈b'at d'a tz'inan luum yic b'at cac'an co silab' d'a Jehová co Diosal, oxe' c'ual stec'nab'il b'aj ol on̈ b'at chi'. Tato max on̈ b'ati, axo talaj tz'aji tzon̈ yac'ancham co Diosal chi' yuj junoc yaelal, ma yuj oval, xchi eb' vin̈ d'a vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Yuj chi' ix yalan vin̈: —¿Tas yuj tzeyiq'uec' tiempo d'a juntzan̈ eyetchon̈ab' tic d'a smunlajel? A ex pax tic, ixiquec d'a e munlajel. ");
INSERT INTO cac_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","¿Tom max eyila' to tzijtum eb' eyetchon̈ab' d'a yol chon̈ab' Egipto tic? ¿Tas yuj tzeyamoch vaan eb' d'a smunlajel? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","An̈ejtona' d'a jun c'ual chi' ix yalb'at vin̈ rey d'a eb' vin̈ yajal munlajel yed' pax d'a eb' vin̈ caporal icha tic: ");
INSERT INTO cac_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","—Man̈xo eyac' an̈ ac yic sb'at d'a scal lum soc'om d'a eb' vin̈ israel chi', ichataxon tz'aji, palta to axo eb' vin̈ ol b'at sayan yico'. ");
INSERT INTO cac_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Palta an̈eja' sb'isul lum xan chi' sb'o eb' vin̈ ichataxoni. Yujto sjaraganail eb' vin̈ tz'ic'ani, yuj chi' tzijtum yavaj eb' icha tic: To tzon̈ b'at cac' co silab' d'a co Diosal, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Aq'uecoch más munlajel d'a yib'an̈ eb', yic vach' man̈xalaj stiempo eb' yab'an juntzan̈ esal lolonel tz'alchaj chi', xchib'at vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Yuj chi' ix yal eb' vin̈ aj Egipto ayoch yajal munlajel d'a eb' israel ayoch caporalil yic syal eb' d'a eb' munlajvum chi' icha tic: —Toxo ix yal vin̈ rey to man̈xo ol ac'chaj an̈ ac d'ayex. ");
INSERT INTO cac_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","A ticnaic a exxo ol b'at e say eyic ol e c'ana', palta an̈eja' sb'isul lum xan ol e b'o'o, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Icha chi' ix aj saclem eb' vin̈ israel d'a masanil yol yic Egipto sayoj yoc trigo yic sc'an eb' vin̈ sq'uexuloc an̈ ac chi'. ");
INSERT INTO cac_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Vach'chom icha chi' ix aji, palta a eb' yajalil eb' caporal chi', syal eb' to an̈eja' sb'isul lum xan yovalil sb'o eb', icha sb'o eb' ayic tz'ac'chaj an̈ ac d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Slaj mac'ji eb' israel ayoch d'a caporalil yuj eb' ayoch yajalilal d'a yib'an̈ eb' yuj vin̈ rey. Syalan eb' vin̈ icha tic d'a eb': ¿Tas yuj man̈ tz'acanoc e b'o lum e xan evi yed' ticnaic ichataxon e b'oan luum? xchi eb' vin̈ yajalil eb' chi'. ");
INSERT INTO cac_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ix b'at eb' vin̈ caporal yal d'a vin̈ rey icha tic: —Mamin rey ¿tas yuj ob'iltacxon̈ej tzon̈ utej a on̈ a checab' on̈ tic? ");
INSERT INTO cac_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Maxtzac ac'jilaj an̈ ac d'ayon̈ yic tz'och scaloc lum co xan sco b'o'o, tob' yovalil tz'acan sco b'opax luum icha d'a yalan̈taxo, tzon̈ mac'ji. A on̈ tic malaj co mul, palta a eb' vin̈ a checab' ay smul, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ix tac'vi vin̈ rey chi': —A ex tic yuj e jaraganail icha chi' tzeyala'. Tzon̈ b'at cac' co silab' d'a Jehová, xe chi. ");
INSERT INTO cac_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ixiquec munlajel, vach'chom a ex tze say an̈ ac tzeyac'och d'a scal lum xan chi', an̈eja' icha sb'isul lum tze b'o'o, xchi vin̈ rey chi' d'a eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Yuj chi' a eb' vin̈ israel ayoch d'a caporalil chi', yelxo val ix chab'ax sc'ol eb' vin̈, yujto ix alchaj d'a eb' vin̈ to an̈eja' sb'isul lum xan chi' sb'o eb' vin̈ d'a junjun c'u. ");
INSERT INTO cac_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ayic ix elta eb' vin̈ caporal chi' d'a yol sdespacho vin̈ rey chi', ix schalan sb'a eb' vin̈ yed' vin̈aj Moisés yed' pax vin̈aj Aarón, van stan̈vaj eb' vin̈ yuj eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ix yalan eb' vin̈ caporal chi': —Olxom yil Jehová tas ol ex yutoc, yujto a ex ay e mul, yuj chi' a vin̈ rey yed' eb' vin̈ ay yopisio yed' vin̈, tzon̈ syaj val eb' ticnaic. Ichato a ex ix eyac' q'uen espada d'a eb' vin̈ yic tzon̈ smilancham eb' vin̈, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ix lajvi chi', ix yalan vin̈aj Moisés d'a slesal: —Mamin Jehová, ¿tas val yuj te ya tzutej eb' a chon̈ab' tic? ¿Tas yuj ix in a checcoti? ");
INSERT INTO cac_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Atax in xid'nac lolonel d'a vin̈ rey chi' uuj, yelxo val ilb'ajc'ol tz'utaj eb' a chon̈ab' tic yuj vin̈, maxto ach colvajlaj jab'oc, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ix tac'vi Jehová: —Olto val ila' tas ol vutoc vin̈ sreyal Egipto tic. Yed' vipal ol ex yactanel vin̈. A in ol vac' pural vin̈, ol ex spechanel vin̈ d'a yol schon̈ab' tic, xchi. ");
INSERT INTO cac_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ix lolonxi Jehová yed' vin̈aj Moisés, ix yalani: —A inton Jehová in. ");
INSERT INTO cac_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","In ch'oxnac in b'a d'a vin̈aj Abraham, d'a vin̈aj Isaac yed' d'a vin̈aj Jacob, d'a in b'i, Dios Syal Yuj Smasanil. Palta a in b'i JEHOVÁ, maj vac'laj yojtaquejel eb' vin̈ tas syalelc'ochi. ");
INSERT INTO cac_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","In b'onac in trato yed' eb' vin̈, vac'annac in ti' vac'an lum Canaán d'a eb' vin̈, aton lum b'aj ec'lejnac cajan eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","A ticnaic, toxo ix vila' to te ilb'ajc'ol tz'utaj eb' in chon̈ab' d'a Egipto tic, yelxo val tz'ixtaj eb' d'a munlajel yuj eb' aj Egipto tic. Yuj chi', ix in nacot in trato yed' eb' e mam eyicham chi'. ");
INSERT INTO cac_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","A ticnaic, b'at al d'a eb' etisraelal chi': A Jehová tz'alan icha tic: A in Jehová in, ol ex in colel b'aj ayex och checab'oc tic, b'aj ilb'aj ex c'ol yuj munlajel d'a Egipto tic. Ol in ch'ox val vipalil, ol vac'anoch nivac yaelal d'a yib'an̈ jun chon̈ab' tic. Icha val chi' ol aj ex in colanel d'a yol sc'ab' jun chon̈ab' tic. ");
INSERT INTO cac_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ol ex och in chon̈ab'oc, a inxo ol in och e Diosaloc. Icha chi' ol aj eyojtacaneli to a in Jehová e Diosal in tzex in colel d'a yol sc'ab' eb' aj Egipto tic b'aj ayex och d'a syaelal yuj munlajel. ");
INSERT INTO cac_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ol ex vic'anb'at d'a sat lum luum b'aj vac'nac in ti' vac'an d'a vin̈aj Abraham, d'a vin̈aj Isaac yed' d'a vin̈aj Jacob. A inxo Jehová in tic svalpax d'ayex to eyic ol aj luum, xchi Jehová, xa chi d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Masanil tas ix yal Jehová, a' ix yal vin̈aj Moisés d'a eb' yetisraelal chi', palta maj schalaj yab' eb', yujto te somchajnaquel sc'ol eb' yuj syail munlajel. ");
INSERT INTO cac_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ix lajvi chi, ix yalanxi Jehová d'a vin̈aj Moisés chi': ");
INSERT INTO cac_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","—Ixic al d'a vin̈ sreyal Egipto chi' to tzex yactejel vin̈ d'a sat sluum tic, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ix tac'vi vin̈aj Moisés chi' d'ay: —Ina max schalaj yab' eb' vetchon̈ab' tas svala', ocxom val vin̈ rey, tom ol scha yab' vin̈, ina to max val yal-laj in loloni, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yuj chi' ix checjib'at vin̈ yed' vin̈aj Aarón yuj Jehová yic b'at lolon eb' vin̈ d'a eb' yetisraelal yed' d'a vin̈ rey, yujto alb'ilxo d'a eb' to ol yiq'uelta eb' yetchon̈ab' eb' d'a Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Aton sb'i eb' yajal d'a junjun macan̈il eb' yin̈tilal Israel d'a stzolal: A vin̈aj Rubén sb'ab'el yuninal vin̈aj Israel. Axo eb' yuninal vin̈, aton eb' tic: Vin̈aj Hanoc, vin̈aj Falú, vin̈aj Ezrón yed' vin̈aj Carmi. Aton eb' tic yajal yaj d'a scal junjun macan̈ yin̈tilal vin̈aj Rubén chi'. ");
INSERT INTO cac_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","A eb' yuninal vin̈aj Simeón, aton eb' tic: Vin̈aj Jemuel, vin̈aj Jamín, vin̈aj Ohad, vin̈aj Jaquín, vin̈aj Zohar yed' vin̈aj Saúl yune' jun ix aj Canaán. Aton eb' tic yajal yaj d'a scal junjun macan̈ yin̈tilal vin̈aj Simeón chi'. ");
INSERT INTO cac_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","A vin̈aj Leví, 137 ab'il ix ec' vin̈. A sb'i eb' yuninal vin̈ d'a stzolal aton eb' tic: Vin̈aj Gersón, vin̈aj Coat yed' vin̈aj Merari. ");
INSERT INTO cac_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","A eb' yuninal vin̈aj Gersón, aton eb' tic: Vin̈aj Libni yed' vin̈aj Simei. Aton eb' tic yajal yaj d'a junjun macan̈. ");
INSERT INTO cac_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","A vin̈aj Coat chi', 133 ab'il ix ec' vin̈. A sb'i eb' yuninal vin̈, aton tic: Vin̈aj Amram, vin̈aj Izhar, vin̈aj Hebrón yed' vin̈aj Uziel. ");
INSERT INTO cac_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Eb' yuninal vin̈aj Merari, aton eb' tic: Vin̈aj Mahli yed' vin̈aj Musi. Aton eb' tic yajal yaj d'a junjun macan̈ yin̈tilal vin̈aj Leví yed' yuninal eb'. ");
INSERT INTO cac_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","A vin̈aj Amram ix yic'laj sb'a vin̈ yed' ix Jocabed yanab' vin̈ smam vin̈, aton eb' ay yic vin̈aj Aarón yed' vin̈aj Moisés. A vin̈aj Amram chi' 137 ab'il ix yil vin̈, ix cham vin̈. ");
INSERT INTO cac_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","A eb' yuninal vin̈aj Izhar, aton eb' tic: Vin̈aj Coré, vin̈aj Nefeg yed' vin̈aj Zicri. ");
INSERT INTO cac_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","A eb' yuninal vin̈aj Uziel, aton eb' tic: Vin̈aj Misael, vin̈aj Elzafán yed' vin̈aj Sitri. ");
INSERT INTO cac_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","A vin̈aj Aarón ix yic' sb'a vin̈ yed' ix Elisabet, yisil vin̈aj Aminadab, yanab' vin̈aj Naasón. Axo yuninal eb', aton eb' tic: Vin̈aj Nadab, vin̈aj Abiú, vin̈aj Eleazar yed' vin̈aj Itamar. ");
INSERT INTO cac_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Eb' yuninal vin̈aj Coré, aton eb' tic: Vin̈aj Asir, vin̈aj Elcana yed' vin̈aj Abiasaf. Aton eb' tic yajal yaj d'a junjun macan̈ eb' yin̈tilal vin̈aj Coré. ");
INSERT INTO cac_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Axo vin̈aj Eleazar yuninal vin̈aj Aarón, ix yic' sb'a vin̈ yed' ix yisil vin̈aj Futiel. Ix alji jun yune' ix, aton vin̈aj Finees. Aton eb' tic yajal yaj d'a junjun macan̈ eb' yin̈tilal vin̈aj Leví. ");
INSERT INTO cac_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Axo vin̈aj Aarón yed' vin̈aj Moisés sb'inaj d'a jun lista tic, aton d'a eb' vin̈ tic ix yal Jehová to a eb' vin̈ ol ic'anelta eb' israel d'a Egipto d'a stzolal. ");
INSERT INTO cac_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Aton eb' vin̈ ix xid'ec' lolonel yed' vin̈ sreyal Egipto yic vach' syactejelta eb' chon̈ab' israel chi' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ix lolon Jehová d'a vin̈aj Moisés d'a Egipto, ix yalani: ");
INSERT INTO cac_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","—A in ton Jehová in. Al d'a vin̈ sreyal Egipto masanil tastac sval tic d'ayach, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ix tac'vi vin̈aj Moisés chi' icha tic: —Mamin, yelxo val max yal-laj in loloni, ¿tas val ol aj yab'an vin̈ rey tas ol vala'? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ix yalan Jehová chi' d'a vin̈: —Man̈ ac' pensar, a ach tzach och d'a yichan̈ jun vin̈ rey chi' in q'uexuloc, axo vin̈ uc'tac aj Aarón ol lolon a q'uexuloc. ");
INSERT INTO cac_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Masanil tas tzin chec ala', al d'a vin̈ uc'tac chi', axo vin̈ ol lolon d'a yichan̈ vin̈ rey chi' yic tzex yactanel vin̈ d'a smacb'en tic. ");
INSERT INTO cac_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","A inxo ol vac' pitb'oquel spensar vin̈ rey chi' yic ol stec'b'ej sb'a vin̈. Yuj chi' tzijtum tas satub'tac ol in ch'ox d'a Egipto tic. ");
INSERT INTO cac_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Yujto man̈ ol schalaj yab' vin̈ rey chi' tas ol eyala', yuj chi', a in ol in ch'ox val vipalil vac'an yaelal d'a Egipto tic. Icha chi' ol aj ex vic'anelta d'a stzolal a ex in chon̈ab' Israel ex tic. ");
INSERT INTO cac_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ayic toxo ix in ch'ox vipalil chi', ayic toxo pax ex viq'uelta, ichato chi' ol nachajel yuj eb' aj Egipto tic to a in ton Jehová in, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ix sc'anab'ajej vin̈aj Moisés yed' vin̈aj Aarón tas ix yal Jehová. ");
INSERT INTO cac_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","A vin̈aj Moisés chi', 80 ab'il sq'uinal vin̈, axo vin̈aj Aarón chi', 83 ab'il sq'uinal vin̈ ayic ix lolon eb' vin̈ d'a yichan̈ vin̈ sreyal Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ix yalanxi Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","—Tato sc'an vin̈ rey chi' yil junoc ch'oxnab'il, tzalan d'a vin̈aj Aarón tic to syactejem te' sc'ococh vin̈ d'a sat luum d'a yichan̈ vin̈ rey chi', ol och te' chanil, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ix lajvi chi', ix b'atxi eb' vin̈ schavan̈il d'a vin̈ rey chi', ix sc'anab'ajan eb' vin̈ sc'ulan icha ix yal Jehová. Ix yactanem te' sc'ococh vin̈aj Aarón d'a yichan̈ vin̈ rey yed' d'a yichan̈ masanil eb' ay yopisio yed' vin̈, elan̈chamel ix och te' chanil. ");
INSERT INTO cac_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ayic ix yilan vin̈ rey icha chi', ix schec vin̈ avtaj eb' vin̈ aj Egipto, eb' vin̈ jelan yed' juntzan̈ yic yajb'alil, ix sc'ulan eb' vin̈ icha ix sc'ulej vin̈aj Aarón chi'. ");
INSERT INTO cac_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ix yactejpaxem sc'ococh eb' vin̈ d'a sat luum, ix ochpax chanil, palta ix turjib'at sc'ococh eb' vin̈ chi' yuj yic vin̈aj Aarón chi'. ");
INSERT INTO cac_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Vach'chom icha chi' ix aji, palta man̈ jab'oc ix scha yab' vin̈ rey chi'. Ix yac'n̈ej pitb'oquel spensar vin̈ icha ix aj yalan Jehová. ");
INSERT INTO cac_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ix lajvi chi', ix yalanxi Jehová d'a vin̈aj Moisés chi': —Ix pitb'iel spensar vin̈ rey chi', maj actajel eb' in chon̈ab' Israel yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ayic sacb'inaj q'uic'an, tzex b'at d'a sti' a' nivan Nilo, tze tan̈van sc'och vin̈ achanvel ta'. Tzeyic'anb'at te' c'ococh ix och chanil. ");
INSERT INTO cac_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ata' tzeyal d'a vin̈ icha tic: A Jehová co Diosal a on̈ hebreo on̈ tic, a checannac on̈ cot ul cal d'ayach to tzon̈ actejel a on̈ schon̈ab' on̈ tic, yic b'at on̈ och ejmelal d'ay d'a tz'inan luum. Palta masanto ticnaic man̈ jab'oc tza cha ab'i. ");
INSERT INTO cac_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Yuj chi' ix yalanxi to ay tas ol sch'ox ila' yic tzojtaquejeli to a Jehová chi' an̈ejton Dios Aytaxoneq'ui. Ayic ol in mac'an sat a a' tic yed' te' in c'ococh yamb'ilq'ue vuj tic, ol och a' chic'al. ");
INSERT INTO cac_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Masanil noc' chay ol chamoc, ol q'ue sjab' a', man̈xo ol yal-laj eyuc'an jab'oc a' tic, xa chi d'a vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","—Tzalpax d'a vin̈aj Aarón to syac'b'at te' sc'ococh vin̈ d'a yib'an̈tac sjaj a a' d'a Egipto tic: D'a yib'an̈ a' cotac yed' a' nivac melem yed' d'a yib'an̈ a' n̈ajab' ton̈ej molan. Masanil a a' ay d'a yol yic Egipto tic ol laj och a' chic'al yed' masanil a' ayem d'a yol yed'tal yed' d'a yoltac jucub', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Icha val ix aj yalan Jehová chi', icha chi' ix yutej vin̈aj Moisés yed' vin̈aj Aarón chi'. Ix yic'anq'ue te' sc'ococh vin̈aj Aarón chi', ix smac'an sat a a' vin̈ d'a yichan̈ vin̈ rey yed' d'a yichan̈ masanil eb' vin̈ ayoch yajalil yed' vin̈. D'a val jun rato chi' ix och a' chic'al. ");
INSERT INTO cac_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Masanil noc' chay ay d'a yol a' Nilo chi', ix laj cham noc'. Ix q'ue sjab' a', majxo yal-laj yuc'an a' eb' aj Egipto chi'. Masanil a a' ay ta', chic'xon̈ej ix aj a'. ");
INSERT INTO cac_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Icha pax chi' ix yutej eb' vin̈ ay d'a yol yic Egipto chi', yujto ay tas tzuji yuj eb' vin̈ yuj tas c'ayb'ab'il yuuj. Icha chi' ix aj spitanxi sb'a vin̈ rey icha ix aj yalan Jehová. Maj schalaj yab' vin̈ tas ix yal vin̈aj Moisés yed' vin̈aj Aarón chi'. ");
INSERT INTO cac_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Malaj val jab'oc yelc'och tas ix yal eb' vin̈ chi' d'a yol sat vin̈ rey chi', ix meltzaj vin̈ d'a sdespacho. ");
INSERT INTO cac_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Masanil eb' anima d'a Egipto chi', ix sjoy a a' eb' yic syuq'uej d'a stitac a a' chi', yujto masanil a a' chi' maxtzac yal-laj yuc'ji. ");
INSERT INTO cac_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Yucub'ixial yoch a' chic'al, ");
INSERT INTO cac_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ix yalan Jehová d'a vin̈aj Moisés icha tic: —Ixic, b'at il vin̈ rey chi', tzalan d'a vin̈ icha tic: A Jehová tz'alan icha tic: Actejel eb' in chon̈ab' yic b'at och eb' ejmelal d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Tato man̈ ol actejel in chon̈ab' tic, ol vac'och yaelal d'a ib'an̈, ol vac' pitzvocq'ue noc' pajtza' d'a masanil a macb'en tic. ");
INSERT INTO cac_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ol vac' pitzvoc noc' d'a yol a a' smasanil, ol laj och noc' d'a yol a despacho yed' b'aj tzach vayi. Ol laj q'ue noc' d'a sat a ch'at. Ol laj och noc' d'a yoltac spat eb' ay yopisio ed'oc, d'a yoltac spat masanil anima, d'a yoltac horno b'aj sb'o ixim pan tza va'a yed' d'a sattac ac'ante' b'aj syotz'chaj ixim pan chi'. ");
INSERT INTO cac_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ol laj q'ue noc' d'a ib'an̈ yed' d'a yib'an̈ eb' ay yopisio ed'oc yed' d'a yib'an̈ masanil eb' etchon̈ab', xchi Jehová, xa chi d'a vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ix lajvi chi', ix yalanxi Jehová d'a vin̈aj Moisés chi': —Al d'a vin̈aj Aarón to syac'b'at te' sc'ococh vin̈ d'a yib'an̈ smasanil a a': A cotac a' yed' a nivac n̈ajab', yic sq'ueta b'ulnaj noc' pajtza'. Ol majel yol yic Egipto tic yuj noc', xchi Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ix yac'anb'at te' sc'ococh vin̈aj Aarón chi' d'a yib'an̈ a a' chi'. Ix q'ueul b'ulnaj noc' pajtza' chi', ix majel masanil yoltac chon̈ab' chi' yuj noc'. ");
INSERT INTO cac_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","An̈eja' icha chi' ix yutejpax eb' vin̈ ay tas tzuji yuuj yed' tas c'ayb'ab'il yuj eb', ix japax noc' d'a yol chon̈ab' chi' yuj eb'. ");
INSERT INTO cac_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ix laj te pucax noc', yuj chi' ix avtaj eb' vin̈ chavan̈ chi' yuj vin̈ rey chi', ix yalan vin̈ d'a eb' vin̈: —C'anec d'a Jehová, yic ol yiq'uel noc' pajtza' tic d'a co cal, ol vactanel e chon̈ab' tic, yic sb'at eb' yac' silab' d'ay, xchi vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ix tac'vi vin̈aj Moisés d'a vin̈: —A ach ol ala' b'aq'uin̈ tzin lesalvi d'a Jehová yic syic'anel noc' pajtza' tic d'ayach yed' d'a eb' ay yopisio ed'oc yed' d'a scal masanil anima yed' d'a yoltac e pat. Axon̈ej d'a yol a' Nilo ol can noc', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","—Q'uic'an, xchi vin̈ rey chi'. Ix yalanxi vin̈aj Moisés chi': —Icha chi' ol ajoc, yic ol ojtaquejeli to malaj junocxo lajan spoder icha Jehová co Diosal a on̈ tic. ");
INSERT INTO cac_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Icha chi' ol aj yel noc' d'a a despacho yed' d'a yol spat eb' ayoch yajalil ed'oc yed' d'a scal masanil anima. Ol cann̈ej noc' d'a yol a' Nilo, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ix lajvi chi, ix elta eb' vin̈ chavan̈ chi' d'a yichan̈ vin̈ rey chi'. Ix sc'anan vin̈aj Moisés d'a Jehová to tz'el noc' pajtza' chi'. ");
INSERT INTO cac_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ix sc'anab'ajej Jehová tas ix sc'an vin̈ chi'. Ichato chi' ix laj och ijan scham masanil noc' pajtza' d'a yoltac pat, d'a amac' yed' d'a caltac te'. ");
INSERT INTO cac_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Axo eb' anima ix laj molb'an noc' chamnac pajtza' chi' d'a junjun b'ulan̈, chuclaj ix aj sjab' yuj noc'. ");
INSERT INTO cac_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ayic ix yilan vin̈ rey to man̈xalaj yaelal ayoch d'a yib'an̈ vin̈, ix yac'anxi pitb'oquel spensar vin̈, icha val ix yutej Jehová yalani, maj sc'anab'ajejlaj vin̈ tas ix yal d'a eb' vin̈ chavan̈ chi'. ");
INSERT INTO cac_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ix yalanxi Jehová d'a vin̈aj Moisés chi': —Al d'a vin̈aj Aarón to syic'chaan̈ te' sc'ococh vin̈, smac'an spococal lum luum vin̈ yed' te' yic smeltzajoch lum pococ chi' cotac usal d'a masanil yol yic Egipto tic, xchi. ");
INSERT INTO cac_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ichaton chi' ix yutej vin̈aj Aarón chi'. Ix smac'q'ue vaan lum pococ chi' vin̈ yed' te' sc'ococh, yuj chi' masanil lum pococ ay d'a yol yic Egipto chi', ix laj och lum cotac usal, ix och noc' d'a anima yed' d'a noc' noc'. ");
INSERT INTO cac_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","An̈eja' eb' vin̈ ay tas tzuji yuj yalani, icha ix yutej vin̈aj Aarón chi' icha chi' ix yutejpax eb' vin̈ snaani. Ix snib'ej eb' vin̈ ix och lum pococ chi' cotac usal, palta maj yal-laj yuj eb' vin̈. Ix chiji eb' anima yed' noc' noc' yuj noc' us chi'. ");
INSERT INTO cac_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Yuj chi', ix yal eb' vin̈ ay tas tzuji yuj yalani d'a vin̈ rey chi': —A jun tic, a Dios tz'utani, xchi eb' vin̈. Palta ix pitb'iel spensar vin̈ rey chi', icha val ix yutej Jehová yalani. Maj schalaj yab' vin̈ tas ix yal vin̈aj Moisés yed' vin̈aj Aarón chi'. ");
INSERT INTO cac_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: —A q'uic'an d'a sacb'inaji, sb'at vin̈ rey chi' d'a sti' a a', yuj chi' pet ex q'ue vaan, b'at eyalan d'a vin̈: Icha tic yalan Jehová: Actejel eb' in chon̈ab' yic tz'och eb' ejmelal d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Palta tato man̈ ol actejel eb', ol vac'cot junoc uman̈ noc' cach icha tab' d'a ib'an̈, d'a yib'an̈ masanil eb' ay yopisio ed'oc yed' pax d'a yib'an̈ masanil a chon̈ab'. Ol b'ud'joquel masanil yol e pat yed' masanil sat luum yuj noc'. ");
INSERT INTO cac_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ayic ol ujoc juntzan̈ chi', man̈xalaj junoc noc' cach chi' ol ec' d'a yol yic Gosén b'aj ayec' eb' in chon̈ab'. Icha val chi' ol aj ojtacaneli to a in Jehová in, Dios in d'a masanil yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ata' ol ojtaquejeli to ch'oc yel in chon̈ab' tic d'a yichan̈ a chon̈ab' chi' d'a yol in sat. A q'uic'an, max ec'b'atlaj saclemb'at noc' cach, xchi Jehová, xa chi d'a vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Icha chi' ix yutej Jehová. Ichaxo val tab' yec' noc' cach chi', ix ochc'och noc' d'a yol sdespacho vin̈ rey yed' d'a yoltac spat eb' ay yopisio yed' vin̈ yed' masanil d'a yol smacb'en Egipto. Juneln̈ej ix yixtejb'at yol chon̈ab' chi' noc'. ");
INSERT INTO cac_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ix lajvi chi', ix avtajxicot eb' vin̈ chavan̈ chi' yuj vin̈ rey chi', ix yalan vin̈ d'a eb' vin̈: —Ixiquec, ix aq'uec e silab' d'a e Diosal chi', palta man̈ ex el d'a yol yic Egipto tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Axo ix tac'vi vin̈aj Moisés chi': —Max yal-laj icha chi', yujto a noc' noc' scac' d'a silab'il d'a Jehová co Diosal chi', nivan yelc'och noc' d'a yol sat eb' etchon̈ab' tic. Yuj chi, tato syil eb' anima chi' co milancham noc' a on̈ tic, val yel tzam on̈ sjulq'uenej eb'. ");
INSERT INTO cac_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Yuj chi', yovalil tzon̈ b'at d'a tz'inan luum, oxe' c'ual stec'nab'il b'aj tzon̈ b'at chi'. Ato ta' b'at cac' co silab' d'a Jehová co Diosal, icha ix yutej yalani, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ix yalanpax vin̈ rey chi': —Syal e b'at d'a tz'inan lum chi', yic b'at eyac' e silab' d'a Jehová e Diosal chi', an̈ej tato yel man̈ najatoc tzex b'ati, tze c'anan d'a e Diosal chi' vuj a in tic, xchi vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ix tac'vi vin̈aj Moisés chi' d'a vin̈: —An̈ej val tzin el d'a tic, tzin c'anan d'a Jehová to a q'uic'an tz'el noc' cach tic d'ayach, d'a eb' ay yopisio ed'oc yed' d'a masanil a macb'en tic. Palta man̈xoocab' on̈ ixtej, man̈xaocab'pax tas ol al d'ayon̈ ayic ol b'at cac'an co silab' d'a Jehová chi', xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ixn̈ej val elta vin̈aj Moisés d'a yol sdespacho vin̈ rey chi', ix sc'anan vin̈ d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ix yab'an Jehová tas ix sc'an vin̈ chi', ix yic'anel noc' cach d'a vin̈ rey chi' yed' d'a eb' ay yopisio yed' vin̈ yed' d'a masanil eb' anima. Man̈xa junoc noc' ix cani. ");
INSERT INTO cac_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Palta an̈eja' ix spitejxi sb'a vin̈ rey chi', maj chajiel-laj eb' israel chi' yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ix lajvi chi, ix yalanxi Jehová d'a vin̈aj Moisés chi': —Ixic d'a vin̈ rey chi', tzalan d'a vin̈: Icha val tic yalan Jehová co Diosal a on̈ hebreo on̈ tic: Chab'at in chon̈ab' tic yic tz'och eb' ejmelal d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Tato man̈ ol a chab'at eb', tato ol a yamn̈ejoch vaan eb', ");
INSERT INTO cac_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ol cot voval, ol vac'anelta yab'il d'a noc' e molb'etzal noc', ol cham noc' yuj yab'il chi', aton noc' chej, noc' vacax, noc' camello, noc' b'uru, noc' calnel yed' noc' chiva. ");
INSERT INTO cac_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Palta ol in ch'oxo' to ch'oc yel eb' israel d'a vichan̈, yuj chi' malaj junoc noc' snoc' eb' ol chamoc, xchi Jehová, xa chi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ix yalancan sc'ual Jehová chi', ix yalani: —A q'uic'an svac'cot jun yaelal chi', xchi. ");
INSERT INTO cac_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Axo d'a junxo c'u chi', ix yac'ancot yab'il Jehová d'a noc' noc' chi'. Tzijtum noc' smolb'etzal noc' eb' aj Egipto chi' ix chami, axo pax eb' aj israel, malaj junoc noc' yic eb' ix chami. ");
INSERT INTO cac_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","D'a elan̈chamel ix b'at schecan iljoc vin̈ rey tato malaj noc' yic eb' israel chi' ix chami. Vach'chom malaj junoc noc' ix chami, palta ix spitejxi spensar vin̈ rey chi', maj actajel eb' israel chi' yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ix lajvi chi, ix yalan Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón: —Ixiquec, iq'ueccot junoc votz q'uen tic'aq'uil taan̈ d'a yol junoc horno. A ach tic ach Moisés tza tzipq'ue q'ueen d'a chaan̈ d'a yichan̈ vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Icha chi', ol saclemcanb'at q'uen icha pococ d'a masanil yol smacb'en Egipto, yuj q'ueen ol q'ue yab'il yaxc'a d'a masanil anima chi' yed' d'a noc' noc', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ix lajvi chi, ix b'at vin̈aj Moisés yed' vin̈aj Aarón yic'cot q'uen taan̈ d'a junoc horno, ix b'at eb' vin̈ yil vin̈ rey chi'. Ayic ix c'och eb' vin̈ d'a yichan̈ vin̈, ix stzipanq'ue q'ueen vin̈aj Moisés d'a chaan̈. Ix lajvi chi', ix pitzviq'ue yab'il yaxc'a d'a masanil anima chi' yed' d'a masanil noc' noc'. ");
INSERT INTO cac_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Axo eb' ay tas tzuji yuj yalani, majxo yal-laj sch'oxan sb'a eb' d'a yichan̈ vin̈aj Moisés chi', yujto ya ay eb' yuj yab'il yaxc'a icha yaj masanil eb' anima d'a Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ix pitb'ixiel spensar vin̈ rey chi' yuj Jehová, maj schalaj yab' vin̈ tas ix yal eb' vin̈ chavan̈ chi', icha ix yutej yalan Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ix lajvi chi', ix yalan Jehová d'a vin̈aj Moisés: —Spet ex q'ue vaan q'uic'an, b'at ex lolon d'a vin̈ rey chi', tzeyalan d'a vin̈: Icha val tic yalan Jehová co Diosal a on̈ hebreo on̈ tic: Actejel eb' in chon̈ab' yic b'at och eb' ejmelal d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","A d'a jun tiempoal tic ol vac'cot juntzan̈ yaelal tic d'a ib'an̈ yed' d'a yib'an̈ eb' ay yopisio ed'oc yed' d'a yib'an̈ eb' a chon̈ab', yic vach' tzojtaquejeli to man̈xa junoc mach lajan spoder icha in tic d'a yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Tato syal in c'ool, tzin ch'ox vipalil d'ayach, svac'anoch yaelal d'a ib'an̈ yed' d'a yib'an̈ masanil eb' anima d'a a macb'en tic. Syal tzex in satel d'a yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ocxo, manto ol ach in satel-laj, yujto ix ach vac'och d'a opisio yuj in ch'oxanel in poder yuj tas ol ach vutoc, yic te nivan ol aj in b'inaj d'a scal masanil anima d'a yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Vach'chom tzijtum yaelal tzin ch'ox ila', palta tza pitejn̈ej a b'a, an̈eja' max actejel-laj in chon̈ab' tic. ");
INSERT INTO cac_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Yuj chi, a q'uic'an yab' val icha hora tic, svac'anem q'uen sacb'at d'a yib'an̈ chon̈ab' tic. Mantalaj b'aj tz'em q'uen sacb'at yelxo val nivac icha q'uen tz'em chi' yictax ix el yich chon̈ab' Egipto tic. ");
INSERT INTO cac_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Yuj chi', al d'a eb' vin̈ a checab' to a masanil noc' molb'etzal noc' yed' masanil tas ay d'a scal a munlajel to tz'ochcan d'a yoltac lechpat, yujto ayic ol ja q'uen nivac sacb'at chi', masanil noc' noc' yed' masanil anima malaj yen̈ul, ol cham yuj q'ueen, xchi Jehová, xa chi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ay eb' vin̈ ay yopisio yed' vin̈ rey, ix xivcanq'uei ayic ix yab'an eb' yuj tas ix yal Jehová. Yuj chi, ix yac'q'ue yen̈ul noc' smolb'etzal snoc' eb' vin̈. Ix ochpaxcan masanil schecab' eb' vin̈ d'a yoltac lechpat chi'. ");
INSERT INTO cac_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ay juntzan̈xo eb' maj yac'och d'a sc'ol tas ix yal Jehová chi', ix can noc' smolb'etzal noc' yed' eb' schecab' eb' d'a ichn̈ejta'. ");
INSERT INTO cac_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ix lajvi chi', ix yalan Jehová d'a vin̈aj Moisés: —Ic'chaan̈ a c'ab' yic tz'em q'uen nivac sacb'at d'a yib'an̈ masanil anima, d'a yib'an̈ masanil noc' noc' yed' d'a yib'an̈ masanil tas avab'il ay d'a yol smacb'en Egipto tic, xchi. ");
INSERT INTO cac_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Yuj chi' ix yic'anchaan̈ sc'ococh vin̈aj Moisés chi', ix mac'vaj c'u, ix ec' copoljoc leb'lon, ix cot q'uen nivac sacb'at d'a masanil sat lum d'a yol yic Egipto chi' yuj Jehová. ");
INSERT INTO cac_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Maxtzac ochlaj vaan yem q'uen sacb'at yed' smac'vaj c'u yed' yec' copoljoc leb'lon. Malaj ton b'aj ix b'inaj yac'an juneloc sacb'at d'a yol yic Egipto d'a yalan̈taxo icha jun oval sacb'at ix yac' chi'. ");
INSERT INTO cac_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Masanil tastac ay d'a Egipto chi', ix ixtaxb'at yuj q'uen nivac sacb'at ix yac' chi'. Ix cham eb' anima yed' noc' noc' aycan d'a spatictac pat yed' masanil tastac ay d'a scaltac munlajel ix lajvicanel yuj q'ueen, yed' masanil te te' ix laj ixtaxcanb'at te'. ");
INSERT INTO cac_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Axon̈ej d'a yol yic Gosén b'aj ayec' eb' israel, malaj val junoc c'otan̈ q'uen sacb'at chi' ix emi. ");
INSERT INTO cac_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Yuj chi' ix schecan vin̈ rey avtajxicot eb' vin̈ chavan̈ chi', ix yalan vin̈: —Toxo ix nachajel vuuj ticnaic to a in ay in mul yed' in chon̈ab' tic. Palta a Jehová, te tojoln̈ej syutej. ");
INSERT INTO cac_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Toxo ix ec' yib'an̈ smac'vaj c'u yed' yem q'uen nivac sacb'at. Yuj chi', man̈xo ol viq'uec' e tiempo, syal e b'at b'aj syal e c'ool, an̈ej jun, comonoc tz'el d'a e c'ol tze c'an d'a Jehová yic syiq'uel jun yaelal tic, xchi vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ix tac'vi vin̈aj Moisés chi' d'a vin̈: —An̈ej val tzin elcan d'a yol chon̈ab' tic, tzin mojb'an in c'ab' in lesalvi d'a Jehová, tzin c'anan d'ay yic syactan yac'ancot q'uen sacb'at tic, yic man̈xo ol mac'vaj c'u, yic vach' snachajel uuj to yic Jehová yaj masanil yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Palta vojtac sic'lab'il to a ach tic yed' eb' ay yopisio ed'oc, manta yelc'och Jehová Dios d'a yol e sat, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","A jantac tas avab'il, icha an̈ lino yed' ixim cebada, masanil ix ixtaxcanb'ati, yujto a ixim cebada ayxo sat ixim, an̈eja' an̈ lino ayxo xumaquil an̈. ");
INSERT INTO cac_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Axo pax ixim trigo yed' ixim centeno, malaj tas ix ic'an ixim, yujto tzac'anxo tz'elul ixim. ");
INSERT INTO cac_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ayic ix lajvi slolon vin̈aj Moisés yed' vin̈ rey chi', ix el vin̈ d'a yol chon̈ab' chi', ix yic'anchaan̈ sc'ab' vin̈, ix lesalvi vin̈ d'a Jehová. A val d'a jun rato chi', ix vanaj yem q'uen sacb'at yed' n̈ab' yed' smac'vaj c'u. ");
INSERT INTO cac_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Axo ix yilan vin̈ rey to maxtzac emlaj n̈ab', maxtzac emlaj q'uen sacb'at, man̈xalaj c'u sc'an̈i, an̈eja' ix ochxi smul vin̈, ix pitb'ixiel spensar vin̈ yed' eb' ay yopisio yed'oc. ");
INSERT INTO cac_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Yuj chi', majxo actajel-laj chon̈ab' Israel chi' yuj vin̈, icha ix aj yalan Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: —Ixic il vin̈ rey chi', ix vac' pitb'oquel spensar vin̈ yed' eb' ay yopisio yed'oc, yic vach' tzin ch'ox juntzan̈ tas satub'tac tic d'a scal eb', ");
INSERT INTO cac_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","yic vach' syal eyalan d'a eb' eyuninal yed' d'a eb' eyi e chiquin masanil tastac ix aj vixtan eb' aj Egipto tic yed' juntzan̈ satub'tac ix in c'ulej d'a scal eb'. Icha val chi' tz'aj eyojtaccaneli to a in ton Jehová in, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ix lajvi chi', ix b'atxi vin̈aj Moisés yed' vin̈aj Aarón chi' yilxi vin̈ rey chi', ix yalan eb' vin̈ d'a vin̈: —Icha val tic yalan Jehová co Diosal a on̈ hebreo on̈ tic: ¿Jantacto val tiempo ol a pitej a b'a, yic max iq'uem a b'a d'a vichan̈? Actejel in chon̈ab' yic b'at och eb' ejmelal d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Tato manto ol a chab'at in chon̈ab' tic, a q'uic'an svic'ancot noc' c'ulub' d'a yib'an̈ a chon̈ab' tic. ");
INSERT INTO cac_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ol majel sat lum tic smasanil yuj noc'. Man̈xa jab'oc luum ol checlajoc. Ol svach' c'uxejb'at noc' jantacto maj lajvoccanel yuj q'uen sacb'at chi' yed' masanil te te' satani ol sc'uxpaxb'at noc'. ");
INSERT INTO cac_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ol b'ud'joccanel yol a despacho yuj noc' yed' yoltac spat eb' ay yopisio ed'oc yed' masanil yoltac pat d'a yol yic Egipto tic. Malaj b'aj ix yil eb' e mam eyicham junoc icha tic yictax ix ja cajan eb' d'a jun lugar tic, xchi Jehová, xchi vin̈aj Moisés chi'. Ayic ix lajvi yalan juntzan̈ tic vin̈, ix elixta eb' d'a yol sdespacho vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ix yalan eb' vin̈ ay yopisio yed' vin̈ rey chi': —¿B'aq'uin̈ ol yactej juntzan̈ vinac tic on̈ stzuntzani? ¿Tas yuj max actejel jun chon̈ab' chi' yic sb'at och eb' ejmelal d'a Jehová sDiosal chi'? ¿Tom max nachajvalel jab'oc uuj, ina toxo ix juvicanb'at co chon̈ab' tic? xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Yuj chi', ix avtajxicot eb' chavan̈ chi' yuj vin̈ rey chi': —Ixiquec yic b'at ex och ejmelal d'a Jehová e Diosal chi', palta tzeyalcan d'ayin machtac ex ol ex b'at chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ix tac'vi vin̈aj Moisés chi': —Co masanil ol on̈ b'atoc. Ol quic'b'at eb' cotac unin yed' eb' icham anima, eb' vin̈ cuninal yed' eb' ix quisil. Masanil noc' co calnel, noc' co vacax yed' noc' chiva, masanil noc' co molb'etzal noc' ol quic'b'ati, yujto te nivan q'uin̈ ol cutej quic'anchaan̈ Jehová co Diosal, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Yuj chi' ix yalanxi vin̈ rey chi': —Vach'chom ayoch Jehová e Diosal chi' eyed'oc, ¿tzam e nalaj to ol ex in chab'at yed' eyetb'eyum yed' eyuninal? Man̈ val jab'oc. Tob'an chuc tas tze na'a. ");
INSERT INTO cac_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","A exn̈ej vinac ex tic b'at ex och ejmelal d'a e Diosal chi', ina to a jun chi' tze c'ana', xchi vin̈. Ix lajvi chi', ix pechjielta vin̈aj Moisés yed' vin̈aj Aarón chi' d'a yichan̈ vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ix yalanxi Jehová d'a vin̈aj Moisés chi': —Ic'chaan̈ a c'ab' d'a yib'an̈ chon̈ab' Egipto tic, yic sjavi noc' c'ulub' ul sc'uxb'at masanil tastac ixto can yuj q'uen sacb'at chi', xchi. ");
INSERT INTO cac_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Icha chi' ix aj yic'anchaan̈ sc'ococh vin̈aj Moisés chi' d'a yib'an̈ Egipto chi', ix yac'ancot jun nivan oval ic' Jehová, ix cot d'a stojolal b'aj sjavi c'u. Jun val c'u yed' jun ac'val ix yac' jun oval ic' chi', axo d'a junxo c'ual, a jun ic' chi' ix ic'ancot noc' c'ulub' chi'. ");
INSERT INTO cac_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Masanil yol yic Egipto chi' ix majel yuj noc'. Malaj b'aj ix uji juneloc yictax yalan̈taxo, man̈xa b'aj olto ujoc icha junel tic. ");
INSERT INTO cac_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ix te majel sat lum yuj noc'. Man̈xo chequeloc jab'oc luum. A jantacto tas ix can yuj q'uen sacb'at, ix lajviel yuj noc'. Man̈xa jab'oc tas yaax yilji ix can yuj noc' d'a yol yic Egipto chi', man̈xa pax sat te te' yed' schontac te'. Pilan ix lajviel smasanil, axon̈ej ste'al ix cani. ");
INSERT INTO cac_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","D'a elan̈chamel ix avtajxicot eb' vin̈ chavan̈ chi' yuj vin̈ rey chi', ix yalan vin̈ d'a eb' vin̈ icha tic: —Ix och in mul d'a sat Jehová e Diosal yed' d'ayex. ");
INSERT INTO cac_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Tzin tevi d'ayex to tzeyac' nivanc'olal d'a in patic yuj in mul tic, axon̈ej d'a junel tic. Tze c'anan d'a Jehová e Diosal, yic tz'el jun yaelal to ed'jinac chamel ayec' d'a yol in macb'en tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","A val yic ix elta vin̈aj Moisés d'a sdespacho vin̈ rey chi', ix lesalvi vin̈ d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ix lajvi chi', ix yac'ancot jun ic' Jehová te ov. A b'aj sb'at c'u, ata' ix cot jun ic' chi'. Ix b'atcan noc' c'ulub' chi' d'a yol a' Chacchac Mar yuuj, man̈xa junoc noc' ix can d'a yol yic Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ix pitb'ixiel spensar vin̈ rey chi' yuj Jehová, maj actajel-laj chon̈ab' Israel yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ix yalanxi Jehová d'a vin̈aj Moisés chi': —A ticnaic, ic'chaan̈ a c'ab', yic vach' sq'uic'b'iq'uinal d'a masanil yol yic Egipto tic. Yelxo val to q'uic'alq'uinal ol ajoc, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ix yic'anchaan̈ sc'ab' vin̈ chi', ix ja jun nivan q'uic'alq'uinal d'a masanil yol yic Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Oxe' c'ual ix q'uic'b'i, man̈xa junoc eb' syal yilanoch eb' cajan d'a slac'anil, maxtzac yal-laj sb'eyec' eb'. Palta axo b'aj cajan eb' israel sacq'uinal. ");
INSERT INTO cac_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Yuj chi', ix avtajxicot vin̈aj Moisés yuj vin̈ rey chi', ix yalan vin̈: —Syal b'at eyoch ejmelal d'a Jehová, iq'uecb'at eyetb'eyum yed' eyuninal. An̈ej to tzeyactejcan masanil noc' e molb'etzal noc', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ix yalan vin̈aj Moisés chi': Yovalil tzon̈ a chab'at yed' noc' co molb'etzal noc' chi', yujto a noc' co noc' chi' ol cac' co silab'oc d'a Jehová co Diosal. ");
INSERT INTO cac_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Masanil noc' co noc' chi' ol quic'b'at qued'oc, man̈xo junoc noc' ol cactejcani, yujto d'a scal noc' ol co siq'uel noc' ol cac' co silab'oc d'a Jehová co Diosal. Ayic manto on̈ c'ochlaj ta', maxto nachajel-laj cuuj mach noc' ol cac' co silab'oc chi', xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","An̈eja' ix pitb'ixiel spensar vin̈ rey chi' yuj Jehová, yic max actajel eb' chon̈ab' israel yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Yuj chi' ix yalanxi vin̈ rey chi' d'a vin̈aj Moisés chi': —Elan̈ d'a vichan̈. Man̈xo a na'a to svil a sat junelxo d'a tic, yujto ta tzach javi junelxo d'a vichan̈ tic, a d'a jun c'ual chi' tzach chamxon̈ej, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ix tac'vi vin̈aj Moisés chi' icha tic: —Ichaton val tzal chi', man̈xa b'aq'uin̈ ol vil a sat junelxo, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: —Ol vac'cot junocxo yaelal d'a yib'an̈ vin̈ rey tic yed' d'a yib'an̈ masanil anima d'a yol yic Egipto tic. Ol lajvoc yec' jun tic, man̈ ton̈ejoc ol ex actajel yuj vin̈ rey tic, palta to a val lac'an vin̈ ol ex pechanel d'a tic d'a juneln̈ej. ");
INSERT INTO cac_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Yuj chi' al d'a masanil eb' israel, eb' vin̈ vinac yed' eb' ix ix to sc'an q'uen oro eb' yed' q'uen plata d'a eb' aj Egipto cajan d'a slac'anil, xchi. ");
INSERT INTO cac_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Axo Jehová ix lolon d'a spensar eb' anima aj Egipto chi', yic syac'an svach'c'olal eb' d'a eb' israel. An̈eja' eb' vin̈ ay yopisio yed' vin̈ rey, ix yalan eb' vin̈ to nivan yelc'och vin̈aj Moisés d'a yol sat eb' vin̈. An̈eja' icha chi' ix aj yalan masanil eb' anima d'a Egipto chi'.) ");
INSERT INTO cac_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ayic manto eltalaj vin̈aj Moisés chi', ix yalanxican vin̈ d'a vin̈ rey chi': —Icha tic yalan Jehová: Ayic ol och chimilac'val, ol in ec' d'a masanil yol yic Egipto tic, ");
INSERT INTO cac_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","yic svac'ancham masanil eb' b'ab'el unin d'a junjun patil eb' aj Egipto. Ol schael yich d'a vin̈ a b'ab'el uninal, vin̈ d'in̈an yochcan a q'uexuloc d'a a despacho tic, masanto schampax sb'ab'el unin eb' ix a checab' van scheni d'a q'uen cha'. Ol champax noc' sb'ab'el yune' noc' noc'. ");
INSERT INTO cac_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","A d'a masanil yol yic Egipto tic, man̈xo jantacoc oq'uel ol ujoc, malaj b'aj ix uji d'a yalan̈taxo, man̈xa pax b'aj olto ujoc. ");
INSERT INTO cac_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Axo eb' israel malaj tas ol ic'an eb', malaj pax tas ol ic'an noc' smolb'etzal noc' eb', yic tzeyojtaquejeli to ch'oc yel eb' israel d'a yichan̈ eb' a chon̈ab' d'a yol in sat a in Jehová in tic, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ichato val chi' ol javoc juntzan̈ eb' vin̈ ay yopisio ed'oc yic ol ul in yilani, ol em cuman eb', ol yalan eb' d'ayin: Ixic yed' masanil mach tzac'anoch uuj, xcham eb'. Yuj chi', ato ta' ol on̈ b'atoc, xchi vin̈aj Moisés chi'. Yelxo val te yoval vin̈ ayic ix elixta vin̈ d'a yichan̈ vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yalnacpax Jehová d'a vin̈: —Man̈ton val ol schalaj yab' vin̈ rey tas ol eyala'. Yuj chi' tzijtumto tas satub'tac ol in c'ulej d'a Egipto tic, xchinaccani. ");
INSERT INTO cac_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","A vin̈aj Moisés yed' vin̈aj Aarón ix laj sc'ulejn̈ej eb' masanil tastac ix laj alchaj tic to satub'tac d'a yichan̈ vin̈ rey, palta toton val a Jehová ix ac'ann̈ej pitb'oquel spensar vin̈ rey chi', yuj chi' maj actajel eb' israel yuj vin̈ d'a yol smacb'en chi'. ");
INSERT INTO cac_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ix yalan Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón d'a Egipto icha tic: ");
INSERT INTO cac_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","A jun uj tic nivanocab' yelc'och d'ayex, b'ab'el uj d'a yol junjun ab'il tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","5","Alec jun checnab'il tic d'a masanil eb' eyetisraelal: A d'a slajun̈il c'ual yoch jun uj tic, junjun vinac ol yic'cot junoc noc' yune' calnel, ma junoc noc' yune' chiva yic schi'an yed' masanil eb' cajan yed'oc. A noc' noc' chi' junjun ab'il ocab' sq'uinal noc', mocab'a jab'oc spaltail noc', an̈ej to smam noc'. Tato man̈ tzijtumoc anima d'a yol spat, max tzac'van eb' schi'an noc', syal yavtan vin̈ aj pat chi' mach cajan d'a slac'anil yic scolvaj eb' schi'an noc' yed'oc, to spucchajec' noc' ato syala' jantac sb'isul anima, ma jantac schi junjun eb'. ");
INSERT INTO cac_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Tze sic'canel noc' masanto d'a 14 yoch jun uj tic. Tze milcham noc' d'a yemc'ualil d'a jun c'u chi'. ");
INSERT INTO cac_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Junjun eb' aj pat chi' sb'on̈och schiq'uil noc' d'a smarcoal spuertail spat b'aj ol chijoc noc' chi', d'a te' yib'an̈ yed' d'a stz'eytac te'. ");
INSERT INTO cac_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","A d'a jun ac'val chi' ol schi noc' chib'ej chi' eb' anima, palta ton̈ej ol b'olchaj noc', ol schi an̈ itaj eb' c'a' yed' noc', axo ixim pan malaj yich ayb'at ol sva eb'. ");
INSERT INTO cac_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Malaj jab'oc noc' tze chi d'a yaxto, mato tz'an̈b'il. Masanil noc' sb'olchaji. A sjolom noc', yoc noc' yed' yol sc'ol noc', b'olb'iln̈ej tz'aji, tze chi'ani. ");
INSERT INTO cac_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Man̈xo eyac'can jab'ocxo noc' d'a junxo c'u. Tato ayto noc' max lajvi eyuj jun, tze n̈uscantz'a noc'. ");
INSERT INTO cac_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ayic ol ex va chi', tzec'b'ilocab' e nan̈al, ayocab'och e xan̈ab', yamb'ilocab'q'ue e c'ococh eyuuj, d'a elan̈chamel ol aj e chi'an noc'. Aton ta' tzeyac'och q'uin̈, yic tzin eyic'anchaan̈ a in Jehová in tic, yujto ol in ec' d'a stitac e pat. ");
INSERT INTO cac_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","A in Jehová in svala' to a val d'a jun ac'val chi' ol in ec' d'a yol yic Egipto smasanil, yic tzin mac'ancham masanil b'ab'el unin d'a junjun pat yed' noc' sb'ab'el yune' noc' noc'. Ol vac' checlajeloc to malaj yelc'och masanil sdiosal eb' aj Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","A schiq'uil noc' noc' chi', tze b'on̈och d'a spuertail sti' e pat b'aj cajan ex ec' chi'. A' ol ch'oxanoc to ayic ol in ec' in mac'cham masanil eb' b'ab'el unin yic eb' aj Egipto chi', malaj junoc ex ol ex chamoc. Ayic ol vilanoch chic' chi', b'en̈ej ol in ec'b'atoc. ");
INSERT INTO cac_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Aton val jun c'ual chi' nivan ol ajcan yelc'och d'ayex, tzeyac'anoch junoc nivan q'uin̈ yic tzin eyic'anchaan̈ a in Jehová in tic. Masanil tiempo tze nacoti. Yed' eb' eyuninal ol snacot jun tic eb'. Ley tz'ajcan jun tic d'a e cal d'a masanil tiempo. ");
INSERT INTO cac_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","A ixim pan tze va d'a uque' c'u, mocab'a yich ayb'at d'a scal ixim. Yuj chi' a d'a sb'ab'el c'ual tzeyiq'uelta masanil yan̈al yich pan d'a e pat junjun ex. Tato ay junoc mach svaan ixim pan ay yich d'a juntzan̈ c'ual chi', tze satel d'a e cal. ");
INSERT INTO cac_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","A d'a b'ab'el c'u tze molb'ej e b'a tzex och ejmelal d'ayin. Icha pax chi' tzeyutej d'a yuquil c'ual, an̈eja' tze molb'ejpax e b'a. A d'a chab' c'ual chi' malaj mach smunlaji, an̈ej e b'oan va e b'a syala'. ");
INSERT INTO cac_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Yovalil tze c'anab'ajej jun q'uin̈ yic ixim pan malaj yich, yujto a d'a jun c'ual chi', stzolal ol ex viq'uelta e masanil d'a yol yic Egipto tic. Junjun ab'il tzeyac'och jun q'uin̈ chi'. Ley ol ajcanoc, yovalil sc'anab'ajej eb' eyin̈tilal yic ol b'eyn̈ejb'atoc. ");
INSERT INTO cac_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Tz'el yich e vaan ixim pan malaj yich chi' d'a 14 yoch b'ab'el uj d'a yemc'ualil masanto d'a 21 yoch jun uj chi' d'a yemc'ualil. ");
INSERT INTO cac_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","A d'a uque' c'ual chi' malaj junoc mach ayec' yich pan d'a spat. Tato ay junoc mach svaan ixim pan to ay yich d'a juntzan̈ c'ual chi', tze satel d'a e cal, vach'chom junoc ch'oc chon̈ab'il cajanec' d'a e cal, ma junoc ex israel ex, satjieli. ");
INSERT INTO cac_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Yuj chi' man̈ e va tastac ayb'at yich b'aj cajan ex eq'ui, an̈ej ixim pan malaj yich tze va'a, xa chi, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ix avtaj eb' vin̈ yajalil chon̈ab' d'a scal eb' yetisraelal yuj vin̈aj Moisés chi', ix yalan vin̈: Ixiquec, tzeyiq'uelta junjunoc noc' quelemtac calnel, ma noc' chiva yic tze chi yed' eb' cajan eyed'oc d'a yol e pat. Tze milcham noc', ol e chi'an noc' d'a jun nivan q'uin̈ ol ochoc. ");
INSERT INTO cac_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Tze chaan schiq'uil noc' d'a yol junoc palangana. Tzeyic'ancot junoc tob'an̈ te c'ab'tac hisopo, tze lab'anem d'a scal schiq'uil noc' chi', tze b'on̈anoch d'a smarcoal yib'an̈ e puerta yed' d'a stz'eytac. Malaj junoc ex tzex elta d'a yol spuertail e pat d'ac'valil. ");
INSERT INTO cac_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ayic ol ec' Jehová d'ac'valil chi', yic smac'ancham eb' b'ab'el yuninal eb' aj Egipto, ol yilanoch chic' d'a spuertail e pat chi', b'en̈ej ol ec'b'atoc, man̈ ol schaochlaj jun ángel ol mac'ancham eb' b'ab'el unin d'a yol e pat. ");
INSERT INTO cac_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","A jun checnab'il tic ol e c'anab'ajejn̈ej, ol sc'anab'ajejn̈ej eb' eyin̈tilal, icha ley tz'ajcan d'a juneln̈ej. ");
INSERT INTO cac_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Vach'chom ayic ayexxo ec' d'a lum luum ix yac' sti' Jehová yac'an d'ayex, yovalil ol eyac'och jun q'uin̈ tic. ");
INSERT INTO cac_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ayic ol sc'anb'an eb' eyuninal d'ayex: ¿Tas syalelc'och jun q'uin̈ tic? tato xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","A exxo tic ol eyal d'a eb' icha tic: A jun noc' calnel sco milcham tic, yic sq'uin̈al yic sco naancot sc'ual ayic b'en̈ej ix ec' Jehová d'a sti' co pat ayic ix smac'ancham eb' b'ab'el yuninal eb' aj Egipto, axo d'a stitac co pat, b'en̈ej ix ec'b'ati. Icha val chi' ix yutej scolancanel cuninal Jehová d'a jun tiempoal chi', xe cham d'a eb', xchi vin̈aj Moisés chi'. Ayic ix lajvi yalan juntzan̈ tic vin̈, ix em cumuljoc eb' israel ejmelal d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","A val d'a jun rato chi' ix sc'anab'ajan eb' icha val ix aj yalan Jehová d'a vin̈aj Moisés chi' yed' d'a vin̈aj Aarón. ");
INSERT INTO cac_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","A d'a chimilac'val, ix ec' Jehová smac'cham eb' b'ab'el unin d'a Egipto d'a junjun patil. Syalelc'ochi to ix cham jun sb'ab'el unin vin̈ rey, vin̈ d'in̈an yochcan sq'uexuloc vin̈ d'a sdespacho, masanto ix champax sb'ab'el yuninal eb' vin̈ ayoch d'a preso. An̈eja' icha chi' ix aj schampax sb'ab'el yune' noc' smolb'etzal noc' eb'. ");
INSERT INTO cac_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Masanil eb' anima d'a Egipto ix q'ue vaan d'a jun ac'val chi'. Tz'oc' vin̈ rey yed' eb' ay yopisio yed'oc yed' eb' anima smasanil, yujto man̈xa junoc pat b'aj malaj chamnac. ");
INSERT INTO cac_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","A val d'a jun ac'val chi', ix avtaj vin̈aj Moisés yed' vin̈aj Aarón yuj vin̈ rey chi', ix yalan vin̈ d'a eb' vin̈: —A ticnaic ixiquec, iq'uecb'at masanil eb' eyetchon̈ab', b'esequel e b'a d'a scal eb' vetchon̈ab' tic, sb'at eyac'anem e b'a d'a Jehová icha eyalan chi'. ");
INSERT INTO cac_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Iq'uecb'at masanil noc' e molb'etzal noc': Noc' calnel, noc' vacax yed' noc' chiva, icha ix aj eyalan chi'. Ixiquec, tzex tevipax d'a Jehová vuuj, xchi vin̈ rey chi'. ");
INSERT INTO cac_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ajun eb' aj Egipto chi' ix checanel eb' israel, yic tz'el eb' d'a elan̈chamel d'a yol schon̈ab' eb' chi', yujto ix sna eb' talaj scham eb' smasanil. ");
INSERT INTO cac_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","A ixim harina ayxo och yalil, ayem d'a yol yed'tal, manto somchajb'atlaj yich pan d'a scal, toxon̈ej ix spichoch eb' d'a yol sábana yed' scajonal, ix yic'anb'at eb' d'a sjen̈jab'. ");
INSERT INTO cac_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ix sc'anan q'uen oro, q'uen plata eb' israel chi' yed' pichul d'a eb' aj Egipto icha yalnac vin̈aj Moisés d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","A Jehová ix q'uexan spensar eb' aj Egipto chi', yuj chi' vach'xon̈ej ix yutej sc'ol eb' d'a eb' israel chi'. Masanil tastac ix sc'an eb' israel chi' ix yac' eb'. Icha val chi' ix aj yic'anec' eb' israel tastac ay d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ix el eb' israel d'a Ramesés, ix c'och eb' d'a Sucot. Ay am 600 miloc eb' vin̈ stiempo val yoch d'a soldadoal, max ochlaj eb' ix ix yed' eb' cotac unin sb'isuloc. ");
INSERT INTO cac_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Tzijtum noc' scalnel eb' ix yic'b'ati, noc' chiva yed' noc' vacax. Tzijtum pax anima ch'oc chon̈ab'il ix b'at yed' eb'. ");
INSERT INTO cac_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Man̈xalaj tiempo yic ix sb'oan svael eb', yujto elan̈chamel ix pechjiel eb' yuj eb' aj Egipto chi', yuj chi' toxon̈ej ix sb'ol ixim pan eb', aton ixim malaj yich yed'nac eb'. ");
INSERT INTO cac_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","41","A eb' israel schon̈ab' Jehová chi', 430 ab'il ec'nac eb' d'a Egipto chi'. A val d'a jun c'u yic ix tz'acvi 430 ab'ilxo yajec' eb' ta' ix el eb'. ");
INSERT INTO cac_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","A val d'a jun ac'val chi', ix munlaj Jehová yic syic'anelta schon̈ab'. Yuj chi' a d'a jun ac'val chi' d'a junjun ab'il, pitzan masanil eb' israel yic syic'anchaan̈ Jehová eb' d'a masanil tiempo. ");
INSERT INTO cac_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ix yalan Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón: A sleyal q'uin̈ yic tze naancoti, ayic b'en̈ej ix in ec' d'a sti' e pat, aton svalcan d'ayex tic: Malaj junoc eb' ch'oc chon̈ab'il syal schi'an noc' silab'. ");
INSERT INTO cac_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","A eb' e checab' manb'il eyuuj, syal schi'an noc' eb', an̈ej tato ac'b'ilxo circuncidar eb'. ");
INSERT INTO cac_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","A pax junoc eb' anima ch'oc chon̈ab'il ayec' d'a e cal, paxyalvum, ma munlajel syac' d'a e cal, max yal-laj schi'an noc' eb'. ");
INSERT INTO cac_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","An̈ej d'a yol pat b'aj sb'oji noc', an̈ej ta' syal schiji noc'. Max yal-laj yic'jib'at noc' d'a junocxo pat, max yalpaxlaj smac'jipoj sb'aquil noc'. ");
INSERT INTO cac_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","A jun ley tic masanil eb' israel ol c'anab'ajanoc. ");
INSERT INTO cac_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Talaj ay junoc ch'oc chon̈ab'il snib'ej syac'och jun q'uin̈ chi' d'a e cal yic tzin yic'anchaan̈, b'ab'el tz'ac'ji circuncidar eb' vin̈ vinac d'a jun patil anima chi'. Ichato chi' syal schi'an noc' yic jun q'uin̈ chi' eb'. Ichato eyetchon̈ab' yaj eb'. A pax junoc vin̈ to manto ac'b'iloc circuncidar jun, max yal-laj schi'an noc' silab' chi' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","A jun ley tic, yovalil sc'anab'ajej eb' anima tz'alji d'a e cal yed' eb' anima ch'oc chon̈ab'il ayec' cajan d'a e cal, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Masanil tas ix checji yal vin̈aj Moisés yed' vin̈aj Aarón chi', ix sc'anab'ajej eb' anima chi'. ");
INSERT INTO cac_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","A val d'a jun c'ual chi', d'a stzolal ix aj yelta eb' israel yuj Jehová d'a yol smacb'en Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi': ");
INSERT INTO cac_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Ch'oc tzeyiq'uel eb' b'ab'el vinac d'a e cal yic tzin yac' servil eb', yujto vic yaj eb' b'ab'el unin d'a scal eb' etchon̈ab'. An̈eja' pax sb'ab'el yune' noc' e molb'etzal noc', vic yaji, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Yuj chi' ix yal vin̈aj Moisés d'a masanil eb' yetchon̈ab': Yovalil sco naeccot jun q'uin̈ tic d'a junjun ab'il, yuj co naancoti to a Jehová ix on̈ ic'anelta yed' yipalil d'a yol yic Egipto, b'aj ayon̈ och d'a checab'oc. Mocab' co va ixim pan ayb'at yich d'a scal. ");
INSERT INTO cac_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","A ticnaic, d'a jun uj Abib tic ix on̈ el d'a Egipto tic. ");
INSERT INTO cac_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ayic ol on̈ c'och yuj Jehová d'a lum luum yax sat, aton lum b'aj cajan eb' cananeo, eb' hitita, eb' amorreo, eb' heveo yed' eb' jebuseo, aton lum yalnac Jehová d'a eb' co mam quicham to ol yac' d'ayon̈, an̈eja' d'a jun uj tic ol cac'och q'uin̈ yic sco naancoti. ");
INSERT INTO cac_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","D'a uque' c'ual ol co va ixim pan malaj yich. Axo d'a yuquil c'ual chi', aton ta' tzon̈ och ejmelal yuj quic'anchaan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","A d'a uque' c'ual chi', malaj ixim pan ayb'at yich ol co va'a. Man̈ ol ilchaj yich pan d'a co pat, man̈ ol ilchajpaxlaj d'a masanil yol co macb'en. ");
INSERT INTO cac_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","A d'a juntzan̈ c'ual chi', ol cal d'a eb' cuninal: A jun q'uin̈ tic yic sco nacoti tas ix yutej Jehová sch'oxan svach'c'olal d'ayon̈, ayic ix on̈ yic'anelta d'a Egipto, xco chama. ");
INSERT INTO cac_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","A jun q'uin̈ tic ol ch'oxaneloc to ch'oc queli, ichato ayoch junoc quechel d'a co c'ab', ma d'a snan̈al co sat. A yuj jun q'uin̈ tic ol co nacoti to a Jehová ix on̈ ic'anelta d'a Egipto yuj spoder, yuj chi' ol caln̈ej sc'ayb'ub'al Jehová, ol co c'anab'ajanpaxi. ");
INSERT INTO cac_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Yuj chi' junjun ab'il ol cac'och jun q'uin̈ tic d'a jun uj tic. ");
INSERT INTO cac_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Ayic ol on̈ c'och yuj Jehová d'a lum sluum eb' cananeo, lum yac'nac sti' yac'an d'a eb' co mam quicham yed' d'ayon̈, ");
INSERT INTO cac_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ata' ol co sic'canel eb' co b'ab'el vinac unin yed' noc' vinac sb'ab'el yune' noc' co molb'etzal noc' yic scac' d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","An̈ejtona' ayic tz'alji sb'ab'el yune' noc' b'uru, tato vinac noc', syal yoch junoc noc' yune' calnel, ma junoc noc' yune' chiva sq'uexuloc noc'. Palta tato max ac'ji noc' calnel chi', smac'ji can̈chaj sjaj noc' yune' b'uru chi'. Axo pax yuj eb' b'ab'el vinac unin, yovalil tz'ac'chaj junoc noc' yune' calnel sq'uexuloc eb'. ");
INSERT INTO cac_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ayic ol sc'anb'an eb' eyuninal d'a b'aq'uin̈ tas syalelc'och juntzan̈ tic, tzeyalani: Sch'oxnab'il yaj b'aj yic'nacon̈elta Jehová yed' spoder d'a Egipto b'aj ayon̈ och checab'oc. ");
INSERT INTO cac_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","A val yic ix pitb'iel spensar vin̈ rey, maj yal sc'ol vin̈ ix on̈ yactejeli, axo Jehová ix mac'ancham sb'ab'el unin eb' aj Egipto yed' sb'ab'el yune' noc' smolb'etzal noc' eb'. Yuj chi' a noc' sb'ab'el yune' noc' co molb'etzal noc' tic, sco milcham noc' silab'oc d'a Jehová. Scac'anpax junjun noc' sq'uexuloc eb' co b'ab'el unin, xe chi d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","A jun tic ol ch'oxaneloc to ch'oc queli ichato ayoch junoc quechel d'a co c'ab', ma d'a snan̈al co sat. A yuuj ol co nacoti to a Jehová ix on̈ ic'anelta d'a Egipto yuj spoder, xchi vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","A ix yactanel eb' chon̈ab' israel vin̈ rey d'a yol smacb'en Egipto, maj ic'jib'atlaj eb' yuj Dios d'a sb'e eb' vin̈ filisteo, vach'chom d'in̈an jun b'e chi', yujto ix sna'a to man̈ vach'oc syac' oval eb' israel yed' eb', talaj sna meltzaj sb'a eb' d'a Egipto ayic ol yilan eb' to ay oval. ");
INSERT INTO cac_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Yuj val chi', ix ec'n̈ej oyoyoc eb' yuj Jehová d'a tz'inan luum yed' d'a stitac a' Chacchac Mar. Ayic ix el eb' d'a yol yic Egipto chi', yed'nac syamc'ab' eb' yic oval. ");
INSERT INTO cac_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ix yalan vin̈aj Moisés to tz'ic'chajb'at snivanil vin̈aj José, yujto ayic pitzanto vin̈ yalannac vin̈ d'a eb' yetchon̈ab' to syac' sti' eb' to ol sc'ulej eb' d'a icha chi'. Yalnaccan vin̈ d'a eb': Val yel a Dios ol colvaj eyed'oc. Yuj chi', ayic ol ujoc jun tic, ol eyic'b'at in nivanil eyed'oc, xchinaccan vin̈. ");
INSERT INTO cac_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ix el eb' israel chi' d'a chon̈ab' Sucot, ix c'och eb' d'a chon̈ab' Etam d'a stitac taquin̈ luum. ");
INSERT INTO cac_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","A d'a c'ualil, b'ab'el Jehová d'a yichan̈ eb', sch'oxan sb'a d'a jun topan̈ asun, a' sch'oxan b'e d'a eb'. Axo d'ac'valil, an̈eja' d'a jun asun chi' b'aj sch'ox sb'a Jehová, ayoch sc'ac'al jun asun chi' yic syac'an saquilq'uinal d'a eb' anima chi', yic vach' syal sb'ey eb' d'a c'ualil ma d'ac'valil. ");
INSERT INTO cac_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","A jun asun chi', b'ab'eln̈ej sb'at d'a yichan̈ eb' israel d'a c'ualil, axo d'ac'valil ayoch sc'ac'al. Man̈ val jab'oc ix el d'a yichan̈ eb'. ");
INSERT INTO cac_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ix yalan Jehová d'a vin̈aj Moisés: ");
INSERT INTO cac_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Al d'a eb' etchon̈ab' tic to smeltzaj jab'oc eb' d'a spatic, sc'och eb' d'a Pi-hahirot, d'a scal Migdol yed' a' mar, d'a yichan̈ Baal-zefón. A d'a slac'anil sti' a' mar chi' tze b'o e campamento. ");
INSERT INTO cac_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ol snaan vin̈ sreyal Egipto icha tic: A eb' israel man̈ yojtacoc eb' b'ajtil sb'ati, ix b'atcan macan eb' d'a taquin̈ luum, xcham vin̈. ");
INSERT INTO cac_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Yuj chi', ol vac'xi pitb'oquel spensar vin̈, ol tzac'laj vin̈ d'a e patic. Yuj tas ol vutoc vin̈ rey yed' eb' soldado chi', ol checlajoc to te' nivan velc'ochi. Ol yojtaquejpaxel eb' anima d'a Egipto chi' to a in Jehová in tic, a inn̈ej Dios in, xchi Jehová d'a vin̈aj Moisés chi'. Yuj chi' ix meltzaj jab'oc eb' israel d'a spatic. ");
INSERT INTO cac_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Axo ix c'och specal d'a vin̈ rey to toxo ix el eb' israel chi', ix snaanxi sb'a sc'ol vin̈ yed' eb' ay yopisio yed'oc, ix yalan eb': Man̈xo jantacoc co quistalil, yuj chi' ix co chab'at eb' israel cac'umal servil, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Yuj chi' d'a elan̈chamel ix schec vin̈ rey chi' to sb'ochaj scarruaje vin̈ yic oval yed' eb' soldado. ");
INSERT INTO cac_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Masanil carruaje yic Egipto ix yic'cot vin̈ yed' 600 carruaje vach' d'a scal juntzan̈ chi', ajun eb' capitán yed' junjun scarruaje. ");
INSERT INTO cac_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ix pitb'i spensar vin̈ rey chi' yuj Jehová, yuj chi' ix tzac'laj vin̈ d'a spatic eb' israel chi'. Palta axo eb' israel chi', ayic ix elta eb' d'a yol smacb'en Egipto chi' ix yic' val chaan̈ sb'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ix tzac'laj eb' aj Egipto d'a spatic eb' israel chi': Eb' soldado yed' noc' chej stoc'an carruaje yed' jantac anima ayoch d'a yol carruaje chi'. Ijan ix yamchaj eb' yuj eb' aj Egipto chi' d'a sti' a' mar d'a slac'anil Pi-hahirot, d'a yichan̈cot Baal-zefón yujto ata' ay scampamento eb' israel chi'. ");
INSERT INTO cac_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Axo ix yilanb'at eb' israel to tzac'anxooch vin̈ rey yed' eb' soldado d'a spatic eb', ix xivq'ue eb', ix q'ue yav eb' d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ix yalan eb' d'a vin̈aj Moisés chi': —¿Tom malaj campusante d'a Egipto, yuj chi' a d'a jun lum taquin̈ luum tic ix on̈ ic'coti yic tzon̈ cham d'a tic? ¿Tas val yuj ix on̈ iq'uelta d'a Egipto? ");
INSERT INTO cac_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ixto cal d'ayach ayic ayon̈to ec' ta' to man̈ iq'uec' tiempo d'ayon̈. B'ecan co c'ol co munlaj d'a eb' aj Egipto chi'. Yelxo val vach' to d'a eb' aj Egipto chi' tzon̈ munlajn̈ej, d'a yichan̈ pax to d'a lum tz'inan lum tic tzul on̈ chamoc, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ix tac'vi vin̈aj Moisés d'a eb' anima chi': —Man̈ ex xivoc, tec'b'ejec e b'a. Ol eyilnab'i tas ol yutoc Jehová scolvaj qued'oc ticnaic. Man̈xa b'aj ol eyil juntzan̈ eb' aj Egipto tic, axon̈ej ticnaic tzeyil eb'. ");
INSERT INTO cac_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Mocab' eyac' somchaj e pensar, yujto a Jehová ol ac'an oval eyuuj, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ix yalan Jehová d'a vin̈aj Moisés chi': —¿Tas yuj tzach avaj d'ayin? Al d'a eb' etisraelal chi' to sb'eyn̈ejb'at eb' d'a yichan̈. ");
INSERT INTO cac_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","A tzex c'och d'a sti' a' mar chi', tzic'anchaan̈ te' a c'ococh, tzac'anb'at te' d'a yib'an̈ a', ol spojan sb'a a', ol checlajq'ue staquin̈al luum b'aj ol ex ec' d'a yol a' chi'. ");
INSERT INTO cac_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ol vac'an pitb'oquel spensar eb' aj Egipto chi'. Ol tzac'laj eb' d'a e patic yalani. Yuj tas ol vutoc vin̈ rey yed' eb' soldado chi', eb' soldado yed' jantac carruaje yed' masanil chej yed'naccot vin̈ yed' eb' anima ajun yed' eb' chi', ol checlajoc to te nivan velc'ochi. ");
INSERT INTO cac_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ayic ol vac'an ganar eb' chi' smasanil, ichato val chi' ol yojtacanel eb' anima aj Egipto to a in Jehová in tic, a inn̈ej Dios in, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","A d'a jun rato chi', a Yángel Jehová yed' jun nivan topan̈ asun b'ab'el d'a yichan̈ eb' israel chi', ix meltzaj d'a spatic eb', ix och d'a scal eb' yed' eb' aj Egipto chi'. ");
INSERT INTO cac_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Yuj chi' yelxo val q'uic'q'uinal ix aj d'a yichan̈ eb' aj Egipto chi', axo pax d'a scal eb' israel chi', yelxo val sacq'uinal smasanil. Yuj chi' maj yamchajlaj eb' israel chi' yuj eb' aj Egipto d'a jun ac'val chi'. ");
INSERT INTO cac_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ix yac'anb'at sc'ab' vin̈aj Moisés d'a yib'an̈ a' mar chi'. Axo Jehová ix ac'ancot jun nivan ic' d'a stojolal b'aj sjavi c'u. Masanil d'a jun ac'val chi' te ov ic', yuj chi' ix poj snan̈al a' mar yuuj, ix checlaj staquin̈al lum luum d'a snan̈al a'. ");
INSERT INTO cac_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Te taquin̈ jun b'e b'aj ix ec' eb' israel d'a yol a' mar chi'. A d'a scal b'aj cha macan̈ ix aj a' chi', ata' ix ec' eb', icha tz'alq'ueen ix aj yochcan vaan a' d'a stz'eytac jun b'e d'a snan̈al a' chi'. ");
INSERT INTO cac_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Axo eb' aj Egipto yed' scarruaje vin̈ rey yed' masanil eb' yed'naccot scarruaje chi', ix cot eb' d'a spatic eb' israel d'a yol a' chi', masanto d'a snan̈al a' ix ochc'och eb'. ");
INSERT INTO cac_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ayic toxo sacb'i, a d'a scal c'ac' yed' d'a scal asun ix iljiemta eb' aj Egipto chi' yuj Jehová, ix ac'ji somchajb'at eb' yuuj. ");
INSERT INTO cac_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ix elta sruedail scarruaje eb', maxtzac yal-laj sb'ey eb', yuj chi' ix yalan eb': —Elocon̈ec lemnaj d'a eb' israel tic, yujto a Jehová tz'ac'an oval qued'oc yuj eb', xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ix yalan Jehová d'a vin̈aj Moisés chi': —Ac'xib'at a c'ab' d'a yib'an̈ a' mar yic syil-lajxi sb'a a' d'a yib'an̈ masanil eb' aj Egipto chi', d'a yib'an̈ scarruaje eb' yed' d'a yib'an̈ eb' ed'jinac noc' schej, yic smucchajcan yuj a', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ix yac'anxib'at sc'ab' vin̈aj Moisés chi' d'a yib'an̈ a' mar chi'. Ayic ix sacb'i, ix yil-lajxi sb'a a' ichataxon yaji. A ix meltzaj eb' vin̈ aj Egipto chi' yalani, toxo pax ix yil-lajxi sb'a a' d'a yichan̈ eb', yuj chi' ix mucchajcanem eb' d'a yol a' yuj Jehová. ");
INSERT INTO cac_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Icha chi' ix aj yil-lanxi sb'a a' ichataxon yaji. Yuj chi' a scarruaje eb' vin̈ yed' eb' ayq'ue d'a yib'an̈ chej yed' masanil eb' soldado vin̈ rey ix b'at tzac'an yuj eb' israel chi', ix mucchajcan eb' d'a yol a'. Man̈xo junoc ix cani. ");
INSERT INTO cac_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Axo pax masanil eb' israel jun, te vach'n̈ej ix aj yec' eb' d'a yol jun b'e taquin̈ d'a yol a' chi'. A d'a stz'eytac jun b'e chi', icha tz'alq'ueen ix aj yochcan vaan a'. ");
INSERT INTO cac_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Aton d'a jun c'ual chi' ix colji eb' israel yuj Jehová d'a yol sc'ab' eb' aj Egipto chi'. Jantac eb' soldado aj Egipto ix cham chi', ix ilji eb' yuj eb' israel d'a sti' a' mar chi'. ");
INSERT INTO cac_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Icha val chi' ix aj yilan eb' israel jantac spoder Jehová ix sch'ox yuj satanel eb' aj Egipto chi', yuj chi' ix xiv eb', ix yac'an val och Jehová chi' eb' yipoc sc'ool, ix yac'anpaxoch vin̈aj Moisés eb' d'a sc'ool to schecab' Dios yaj vin̈. ");
INSERT INTO cac_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ix lajvi chi', ix sb'itan jun b'it vin̈aj Moisés chi' yed' masanil eb' israel d'a yichan̈ Jehová, ix yalani: Sco b'itej sb'i Jehová, yujto te satub'tac ix aj yac'an ganar oval. Ix mucchajcan noc' chej d'a yol a' mar yed' eb' vin̈ ed'jinac noc'. ");
INSERT INTO cac_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","A jun co b'it tic yic Jehová, yujto a co Columal yaji, yuj chi' squic'chaan̈. Ol cal vach' lolonel d'a co Diosal, sDiosal pax eb' co mam quicham, yuj chi' smoj val quic'anchaan̈. ");
INSERT INTO cac_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Te jelan yac'an oval, Jehová ton val sb'i. ");
INSERT INTO cac_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ix mucchajcanem scarruaje vin̈ sreyal Egipto yed' eb' soldado d'a yol a' yuj Jehová. Yed' eb' capitán nivan yelc'ochi, ix b'atcan eb' d'a yich a' Chacchac Mar. ");
INSERT INTO cac_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Icha val q'uen q'ueen ix aj sb'atcan eb' d'a yich a', ix mucchajcanem eb'. ");
INSERT INTO cac_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Mamin Jehová, yelxo val ay a poder. Ix ac' ganar eb' ayoch ajc'olal d'ayon̈. ");
INSERT INTO cac_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","A yed' a nivan poder ix a mac' telvoc eb' sgana syac' oval ed'oc. Ayic ix cot oval, icha val stz'ab'at an̈ ac, icha chi' ix aj slajvicanel eb' uuj. ");
INSERT INTO cac_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Yed' ipalil ix a pu'anb'at ic', yuj chi' ix spojb'at sb'a a' mar. Icha tz'alq'ueen ix ajcan a' d'a junjun stitac jun b'e taquin̈ chi', icha val to tzatzxon̈ej ix ajcan a'. ");
INSERT INTO cac_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ix yalan eb' ajc'ol chi' icha tic: Ol on̈ tzac'laj d'a spatic eb' masanto ol yal syamchaj eb' cuuj. Ol quic'anec' tastac ay d'a eb', ol co pucaneq'ui, ichato ol cac' b'ud'joc co c'ool yuuj. Ol quic'anq'ueta q'uen quespada d'a yol yatut, ol co satanel eb', xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ayic ix a pu'anb'at ic' d'a yib'an̈ a' mar, ix mucchajcan eb' vin̈ yuj a', ix b'atcan eb' vin̈ d'a yich a' icha q'uen plomo. ");
INSERT INTO cac_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Mamin Jehová, malaj junoc dios syal slajb'an sb'a ed'oc. Nivan elc'ochi, yujto a achxon̈ej ochi. Man̈xa junocxo mach syal sch'oxan milagro yed' tas satub'tac icha tza c'ulej. ");
INSERT INTO cac_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ix a ch'ox a poder, ichato ix turjib'at eb' yuj a' mar. ");
INSERT INTO cac_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Yuj a nivan vach'c'olal tzon̈ a cuchb'an a on̈ a chon̈ab' on̈ ix a colcanel tic. Yed' a poder tzon̈ ic'anb'at d'a a cajnub' to ictaxon yaji. ");
INSERT INTO cac_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ayic ol yab'an jun tic juntzan̈xo nación, ol ib'xocq'ue eb' yuj xivelal, ol xivcanq'ue eb' filisteo. ");
INSERT INTO cac_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","A eb' yajalil eb' aj Edom, ol satcanb'at sc'ol eb'. A eb' yajal d'a Moab, ol lucloncan eb' yuj xivelal. Icha pax chi' eb' cananeo, ol laj sc'ub'ejel sb'a eb', ");
INSERT INTO cac_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","yujto ol te xivcanq'ue eb', ol sicb'occanel eb'. Mamin Jehová, icha q'uen q'ueen ol ajcan eb' yuj a poder, masanto ol on̈ ec'b'at a on̈ a chon̈ab' on̈ colb'ilel uj tic. ");
INSERT INTO cac_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Mamin Jehová, ol on̈ ic'b'at a on̈ a chon̈ab' on̈ tic ed'oc d'a jun vitz to ic yaji, jun lugar to a ach ix a sic'caneli b'aj ol ach ajoc, aton jun a cajnub' to a nanaccani. ");
INSERT INTO cac_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ach Jehová, Rey ach d'a masanil tiempo, xchi eb' israel d'a sb'it. ");
INSERT INTO cac_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ayic ix cot scarruaje vin̈ sreyal Egipto yed' juntzan̈ eb' ed'jinac noc' chej d'a yol a' mar, ix mucjicanem eb' d'a yol a' yuj spoder Jehová. Axo pax eb' israel jun, yelxo val vach' ix aj yec' eb' d'a yol jun b'e taquin̈ d'a snan̈al a'. ");
INSERT INTO cac_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Yuj chi', a ix María schecab' Dios, yanab' vin̈aj Aarón, ix yic'q'ue jun spandereta ix. Masanil eb' ix yetisraelal ix yed'nacq'ue spandereta eb' ix, ix q'ue cheneljoc eb' ix yed' ix. ");
INSERT INTO cac_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ix b'itan ix María d'a yichan̈ eb' ix icha tic: Co b'itejec sb'i Jehová, yujto te satub'tac ix aj yac'an ganar oval. Ix mucchajcan noc' chej d'a yol a' mar yed' eb' vin̈ ed'jinac noc', xchi ix. ");
INSERT INTO cac_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ix lajvi chi', ix yic'anel eb' israel vin̈aj Moisés d'a sti' a' Chacchac Mar chi', ix cot eb' d'a taquin̈ luum yic Shur. Oxe' c'ual ix b'ey eb', malaj b'aj ix ilchaj a a' yuj eb'. ");
INSERT INTO cac_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ix lajvi chi', ix javi eb' d'a jun scuch Mara. Ay jun a' ta', palta maj yal-laj yuc'an a' eb' yujto yelxo val te c'a' a', yuj chi' Mara ix sb'iejcan jun lugar chi' yuj eb'. ");
INSERT INTO cac_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ix och ijan eb' anima chi' schichon sc'ol d'a spatic vin̈aj Moisés chi', ix laj yalan eb': ¿Tas ol cuc' ticnaic? xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Yuj chi', ix sc'anan scolval Jehová vin̈aj Moisés chi'. Axo Jehová chi' ix ch'oxan jun te te' d'a vin̈, ix yac'anem te' vin̈ d'a yol a', ix b'o a' yuj te'. Ata' ix yac' jun sley Jehová d'a eb' israel, yic syila' tato sc'anab'ajej eb'. ");
INSERT INTO cac_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ix yalan Jehová: Tato tze c'anab'ajej tas sval a in Jehová in tic, tze c'ulan tas syal in checnab'il yed' masanil in c'ayb'ub'al, man̈ ol vac'cotlaj ilya d'a eyib'an̈ icha juntzan̈ ix vac'cot d'a yib'an̈ eb' aj Egipto, yujto a in Jehová in tzex van̈tej, xchi. ");
INSERT INTO cac_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ix lajvi chi', ix javi eb' d'a Elim b'aj ay lajchave' sjaj a a' yed' 70 te' palma. Ata' ix sb'oq'ue scampamento eb' d'a stitac a a' chi'. ");
INSERT INTO cac_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ix lajvi chi', ix el eb' israel d'a Elim chi', ix javi eb' d'a tz'inan lum yic Sin, d'a scal Elim yed' Sinaí. A d'a jun c'u chi' nan̈al schab'il ujalxo yelta eb' d'a Egipto. ");
INSERT INTO cac_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ayic ayec' eb' ta', masanil eb' ix alub'tan̈an d'a spatic vin̈aj Moisés yed' d'a spatic vin̈aj Aarón. ");
INSERT INTO cac_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ix yalan eb' icha tic: —Comonoc ix el d'a sc'ol Dios to a d'a Egipto on̈ chamcani. Ata' tzon̈ em c'ojan d'a stz'ey lum chenal chib'ej, tzon̈ va'i, masanto tzon̈ te b'ud'ji. Palta a exxo tic ix on̈ eyic'cot d'a taquin̈ luum tic yic tzon̈ cham co masanil yuj vejel, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yuj chi', ix yalan Jehová d'a vin̈aj Moisés chi': —A d'a satchaan̈ ol vac'cot tas ol e va'a. Junjun c'u ol b'at e molanq'ue tas ol e va'a, yuj chi' ol vila' tato ol e c'anab'ajej in checnab'il, mato maay. ");
INSERT INTO cac_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Axo d'a svaquil c'ual, tze molancanq'ue yic chab'oc c'ual, tze b'oancan yic jun c'u chi' yed' yic yuquil c'ual, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ix yalan vin̈aj Moisés yed' vin̈aj Aarón chi' d'a eb' chon̈ab': —A d'a jun yemc'ualil tic ol eyojtaquejeli to yel a Jehová ix ex ic'anelta d'a Egipto. ");
INSERT INTO cac_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Axo d'a q'uin̈ib'alil ol eyilan stziquiquial, yujto ix yab'i tas ix eyutej e lolon d'a spatic. Palta a on̈ tic, ¿toc ay quelc'ochi, yuj chi' tzeyal co pecal? xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ix yalanpax vin̈aj Moisés chi': —A d'a yemc'ualil tic ol yac' noc' chib'ej Jehová e chi'a. Axo d'a junjun q'uin̈ib'alil, ol yac'an e vael ato syala' jantac tze va'a, yujto ix yab'i tas tzeyalub'tan̈ej d'a spatic. Vach'chom d'a co patic tzeyalub'tan̈ej eyalani, palta malaj quelc'och a on̈ tic. Val yel a d'a spatic Jehová tzeyalub'tan̈ej, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","A d'a jun rato chi' ix yal vin̈aj Moisés chi' d'a vin̈aj Aarón: —Al d'a eb' smasanil to snitzcot sb'a eb' d'a yichan̈ Jehová, yujto ix yab'i tas ix yalub'tan̈ej eb', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","A val yic van slolon vin̈aj Aarón d'a eb' yetisraelal chi', ix yilanb'at eb' d'a tz'inan luum, ix sch'oxanq'ue sb'a stziquiquial Jehová d'a scal jun topan̈ asun. ");
INSERT INTO cac_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ix yalan Jehová d'a vin̈aj Moisés chi': ");
INSERT INTO cac_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","—Ix vab' val tas ix yal eb' israel tic d'a in patic. Yuj chi' al d'a eb' to a ticnaic d'a q'uic'b'alil, ol vac' noc' schib'ej eb', axo sq'uin̈ib'i q'uic'an svac' tas sva eb', masanto sb'ud'ji val sc'ol eb'. Icha chi' ol aj yojtacanel eb' to a in ton Jehová e Diosal in, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","A d'a jun yemc'ualil chi', ix javi n̈ilnaj noc' ub', ix majel b'aj ay scampamento eb' yuj noc'. Axo d'a q'uin̈ib'alil d'a junxo c'u, ix em yal ac'val d'a spatictac scampamento eb' chi'. ");
INSERT INTO cac_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ayic ix tacji yal ac'val chi', ay juntzan̈ tas te cotac ix can d'a sat luum, icha q'uen cheev yilji. ");
INSERT INTO cac_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Man̈ yojtacoc juntzan̈ chi' eb'. Ayic ix yilanoch eb', ix yal-lan eb' d'ay junjun: ¿Tastaxlaj juntzan̈ tic? xchi eb'. Ix yalan vin̈aj Moisés: —Aton e vael syac' Jehová tic. ");
INSERT INTO cac_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Aton jun checnab'il ix yac' tic: Syal e molanchaan̈ d'a junjun c'u, icha jantac tz'och eyuj yuj jayvan̈ ex d'a yol e pat. Iq'uecq'ue junjunoc echlab' yic junjun anima, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ichaton chi' ix yutej eb' anima chi'. Ay mach nivan ix molanq'uei, ay pax mach quenn̈ej. ");
INSERT INTO cac_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ato a yechlab'il ix ac'chaji, maj yac' sobre d'a eb' nivan ix molanq'uei, an̈eja' c'ocb'il ix yab'pax d'a eb' quenn̈ej ix molanq'uei. Junjun mach ix smolq'ue jantac sva d'a junjun c'u. ");
INSERT INTO cac_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ix yalan vin̈aj Moisés d'a eb': —Max yal-laj e molancan yic e q'uic'an, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ay mach maj c'anab'ajanlaj tas ix yal vin̈, ix smolancan jab'ocxo yic sva eb' q'uic'an yalani. A tas ix smolcan eb' chi', ix och a'ayaxoc, ix q'ue sjab' d'a junxo c'u, yuj chi' ix cot yoval vin̈aj Moisés chi' d'a eb' maj c'anab'ajan chi'. ");
INSERT INTO cac_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Junjun q'uin̈ib'alil smolanq'ue eb' jantac sva d'a jun c'u chi', axo yic sja yoc c'u tz'ulaxb'ati. ");
INSERT INTO cac_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Axo d'a svaquil c'ual, junjunto echlab' sobreal syic'q'ue eb' yic sva junjun eb', syalelc'ochi to chab'chab' echlab' yic junjun eb'. Axo eb' ayoch yajalil d'a scal eb' anima chi', ix b'at yal eb' d'a vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Yuj chi' ix yalan vin̈: —A jun chi' a Jehová ix alani, yujto a q'uic'an sc'ual ic'oj ip. A jun ic'oj ip chi' sc'ual yic tz'ic'jichaan̈ Jehová. Tze tz'an̈can tas stz'an̈chaji yic tze va q'uic'an, tze mayancan tas smaychaji, tze sic'ancan yic e q'uic'an chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ix sc'anab'ajan eb' anima tas ix yal vin̈aj Moisés chi'. Ix sic'ancanb'at masanil tas sva eb' d'a junxo c'u. Maj ixtaxb'atoc, maj ochpax a'ayaxoc. ");
INSERT INTO cac_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Axo d'a junxo c'u, ix yalan vin̈aj Moisés chi': —Vaec e vael can eyuj evi, yujto sc'ual ic'oj ip ticnaic, tze c'anab'ajej eyic'anchaan̈ Jehová. A d'a jun c'ual tic, malaj jab'oc tas tze va chi' tz'ilchaj eyuj d'a spatictac campamento tic. ");
INSERT INTO cac_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Yujto an̈ej d'a vaque' c'u d'a yol semana syal e molan tas tze va'a, axo d'a yuquil c'ual, man̈xalaj tas sjavi, yujto sc'ual ic'oj ip, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Palta ay eb' ix b'at sayan yic d'a yuquil c'ual chi', palta malaj jab'oc tas ix ilchaj yuj eb'. ");
INSERT INTO cac_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ix yalan Jehová d'a vin̈aj Moisés chi': —Yelxo val max e c'anab'ajej, ¿tom ol ex ochn̈ej ijan e tenanec' in checnab'il yed' in c'ayb'ub'al? ");
INSERT INTO cac_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Naec val sic'lab'il, a in Jehová in svala' to yovalil tze c'anab'ajej sc'ual ic'oj ip. Yuj chi' a d'a svaquil c'ual, svac' vael d'a chab' c'ual, yuj chi' a d'a jun c'ual chi', vach'n̈ej eyajec' d'a yol b'ajtac ayex, malaj mach sb'at munlajel, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ichaton chi' ix aji, ix yic'an yip eb' anima d'a yuquil c'ual chi'. ");
INSERT INTO cac_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Maná ix yac' eb' israel scuch juntzan̈ vael ix smol chi'. Sacsac yilji icha val sat an̈ culantro. Te chi' svaji, icha ixim c'oxox pan ayoch yalchab' d'ay. ");
INSERT INTO cac_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ix lajvi chi', ix yalan vin̈aj Moisés: —Ix yal Jehová d'ayin icha tic: Siq'uecb'at junoc echlab' maná, yic ol yil eb' eyuninal d'a b'aq'uin̈. Ol yil e vael eb' ix vac' e va d'a lum tz'inan luum tic, ayic ix ex vic'anelta d'a Egipto, xchi Jehová, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Yuj chi', ix yalan vin̈ d'a vin̈aj Aarón: —Ic'cot junoc chen, tzac'anem junoc echlab' maná d'a yool icha yalan Jehová. Slajvi chi', tza sic'ancanb'at d'a yichan̈ Jehová chi', yic vach' ol yil eb' quin̈tilal, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Icha ix yutej Jehová yalan d'a vin̈aj Moisés chi', icha chi' ix yutej vin̈aj Aarón, ix sic'ancanb'at vin̈ d'a stz'ey q'uen q'ueen b'aj tz'ib'ab'ilcan strato Jehová. ");
INSERT INTO cac_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","D'a 40 ab'il ix sva maná eb' israel, masanto ix c'och eb' d'a lum cajnub'al d'a smojonal Canaán. ");
INSERT INTO cac_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","A jun echlab' chi', Gomer sb'i, ay am nan̈aloc yoxil litro a a' tz'em d'a yool. ");
INSERT INTO cac_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Masanil eb' israel ix el d'a lum tz'inan luum yic Sin, c'ojanc'olal ix aj sb'ey eb', ato syal tas tz'aj sch'oxan Jehová. Ix lajvi chi', ix javi eb' d'a Refidim, palta malaj a a' ta'. ");
INSERT INTO cac_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Yuj chi' ix cotxi yoval eb' d'a vin̈aj Moisés chi': —A ticnaic, ac' a a' cuq'uej, xchi eb'. —¿Tas yuj scot eyoval d'ayin? ¿Tas yuj tzeyac' proval Jehová? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Palta axo eb' chon̈ab' yelc'olal scham eb' yuj taquin̈tial, yuj chi' ix q'ue yav eb' d'a vin̈aj Moisés chi', ix yalan eb': —¿Tas yuj ix on̈ iq'uelta d'a Egipto? ¿Tom yuj co cham yuj taquin̈tial yed' eb' cuninal yed' pax noc' co molb'etzal noc'? xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Yuj chi' ix tevi vin̈aj Moisés chi' d'a Jehová icha tic: —Mamin, ¿tas val svutej eb' anima tic? Ijan val tzin sjulq'uenej eb', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ix tac'vi Jehová d'a vin̈: —A ticnaic, b'ab'lajan̈ d'a yichan̈ eb' anima chi', tzic'anb'at jayvan̈oc eb' yichamtac vinaquil chon̈ab' chi' ed'oc. Tzic'anpaxb'at te' a c'ococh, te' ac'lab'ejnac a mac'an sat a' Nilo. ");
INSERT INTO cac_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","A in ol in b'ab'laj d'a ichan̈ d'a q'uen tenam d'a Horeb, axo ol ach c'och ta', tza mac'an sat q'ueen yed' te' a c'ococh chi', ol elul a' d'a sat q'ueen, ol yuc'an a' eb' anima chi', xchi d'a vin̈. Icha chi' ix yutej vin̈aj Moisés chi' d'a yichan̈ eb' yichamtac vinaquil chon̈ab' Israel. ");
INSERT INTO cac_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Meriba ix yac' vin̈ sb'iej jun lugar chi', yujto chuc ix yal eb' d'a spatic vin̈. Masah pax ix yac' vin̈ sb'iej, yujto ix yac' proval Jehová eb', ix yalan eb': Mato val ayec' Jehová d'a co cal, mato maay, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ayic ayec' eb' israel d'a Refidim chi', ata' ix c'och eb' amalecita yac' oval yed' eb'. ");
INSERT INTO cac_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Yuj chi' ix yal vin̈aj Moisés d'a vin̈aj Josué: —Siq'uel jantacoc eb' co soldado yic sb'at eb' yac' oval yed' eb' amalecita. A q'uic'an tzin b'at d'a chon tzalan, ved'nac te' c'ococh, te' syac'lab'ej Dios, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ix sc'anab'ajan vin̈aj Josué chi', ix b'at yac'an oval vin̈ yed' eb' amalecita chi'. Axo vin̈aj Moisés chi' yed' vin̈aj Aarón yed' pax vin̈aj Hur, ix b'at eb' vin̈ d'a chon tzalan chi'. ");
INSERT INTO cac_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","A syic'anq'ue sc'ab' vin̈aj Moisés d'a chaan̈, scan eb' amalecita d'a yalan̈ yuj eb' israel. Axo syic'anxiem sc'ab' vin̈, ijan scan eb' vin̈ israel d'a yalan̈. ");
INSERT INTO cac_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Palta ste c'unb'i sc'ab' vin̈ sb'at jecan, yuj chi' ix say jun q'uen q'ueen vin̈aj Aarón yed' vin̈aj Hur chi'. A d'a yib'an̈ q'ueen ix em c'ojan vin̈aj Moisés chi', axo eb' vin̈ ix yamanq'ue sc'ab' vin̈ chi', junjun eb' vin̈ d'a stz'eytac vin̈ masanto ix b'at c'u. ");
INSERT INTO cac_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Icha chi' ix aj yac'an lajvoc eb' amalecita vin̈aj Josué chi'. ");
INSERT INTO cac_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ix lajvi chi', ix yalan Jehová d'a vin̈aj Moisés chi': —Tz'ib'chajocab'can jun ab'ix tic yic ol nachajcotoc. Tzalanpax d'a vin̈aj Josué chi' to a in ol in satel masanil eb' amalecita d'a juneln̈ej, man̈xa b'aj ol nachajcot eb', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ix lajvi chi', ix sb'oanq'ue jun altar vin̈aj Moisés chi', ix yac'an vin̈ sb'iej icha tic: A Jehová b'ab'el cuuj d'a oval. ");
INSERT INTO cac_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ix yalan vin̈ icha tic: Yujto ix yic'chaan̈ sc'ab' eb' yin̈tilal vin̈aj Amalec yac'an oval yed' Jehová, yuj chi' ol yac'n̈ej oval Jehová yed' eb' aj Amalec d'a masanil tiempo, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","A vin̈aj Jetro, sn̈i' vin̈aj Moisés, sacerdote yaj d'a Madián. Ix yab' vin̈ jantac tas ix sc'ulej Dios yed' vin̈aj Moisés yed' pax chon̈ab' Israel, ayic ix ic'jielta eb' yuuj d'a Egipto. ");
INSERT INTO cac_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","A vin̈aj Moisés chi', yac'nac meltzaj ix yetb'eyum vin̈, aton ix Séfora yed' chavan̈ yuninal vin̈ d'a vin̈aj Jetro chi'. Ix chaji eb' yuj vin̈aj Jetro chi'. ");
INSERT INTO cac_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","(A vin̈ sb'ab'el unin vin̈aj Moisés chi', Gersón sb'i vin̈, yujto ix yal vin̈: Ton̈ej tzin b'eyec' d'a scal eb' ch'oc chon̈ab'il, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Axo vin̈ schab'il scuch Eliezer, yujto ix yal vin̈: Ayn̈ejoch sDiosal in mam ved'oc, a ix in colanel d'a q'uen yespada vin̈ sreyal Egipto, xchi vin̈.) ");
INSERT INTO cac_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Axo ix yab'an vin̈aj Jetro to a d'a tz'inan luum ay scampamento vin̈aj Moisés chi', d'a yich vitz b'aj sch'ox sb'a Dios. Ata' ix b'at vin̈aj Jetro chi' yil vin̈ yed'nac ix Séfora yetb'eyum vin̈aj Moisés chi' vin̈. Yed'nacpax eb' yuninal vin̈aj Moisés chi' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Ix yalanb'at vin̈ d'a vin̈aj Moisés chi': —A in Jetro a n̈i' in tic, van in c'och ach vila', ajun ix etb'eyum ved'oc yed' pax eb' vin̈ eyuninal schavan̈il, xchib'at vin̈. ");
INSERT INTO cac_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","D'a elan̈chamel ix elta vin̈aj Moisés scha vin̈ sn̈i' chi', ix em n̈ojan vin̈ d'a yichan̈ vin̈, ix stz'ub'anelta sti' vin̈. Ix lajvi yac'lan stzatzil sc'ol eb', ix och eb' d'a yol smantiado vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ix yalan vin̈aj Moisés chi' d'a vin̈ sn̈i' chi' tas ix utaj vin̈ sreyal Egipto yed' masanil eb' aj Egipto yuj Jehová ayic ix scolanel eb' chon̈ab' israel. Ix yalanpax vin̈ yuj jantac yaelal ix yil yed' eb' anima chi' d'a yoltac b'e yed' tas ix aj scolji eb' yuj Jehová. ");
INSERT INTO cac_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ix te tzalaj sc'ol vin̈aj Jetro chi', a ix yab'an scolval Dios vin̈ d'a chon̈ab' Israel, ayic ix scolanelta eb' d'a yol sc'ab' eb' aj Egipto. ");
INSERT INTO cac_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ix yalan vin̈: —Alchajocab' vach' lolonel d'a Jehová, aton ix ex colanel d'a yol sc'ab' eb' aj Egipto yed' d'a yol sc'ab' vin̈ rey, ix ex yic'anelta d'a yalan̈ smandar eb'. ");
INSERT INTO cac_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","A ticnaic sic'lab'il val snachajel vuuj to a Jehová yelxo val ec'al d'a yib'an̈ juntzan̈xo dios, yujto ix ex coljiel yuj d'a yol sc'ab' eb' aj Egipto, vach'chom ix ste iq'uejchaan̈ sb'a eb' d'a yichan̈, xchi vin̈aj Jetro chi'. ");
INSERT INTO cac_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ix lajvi chi', ix sn̈usan jun noc' silab' vin̈aj Jetro chi' d'a Dios, ix yac'anpax juntzan̈xo silab' vin̈ d'ay. Ix ja vin̈aj Aarón yed' eb' yichamtac vinaquil chon̈ab' b'aj ayec' vin̈ sn̈i' vin̈aj Moisés chi', ix va eb' d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Axo d'a junxo c'ual, ix em c'ojan vin̈aj Moisés, ix och ijan vin̈ sch'olb'itan tastac yaj yoval eb' chon̈ab'. Pilan c'u ayec' eb' anima chi' d'a yichan̈ vin̈. ");
INSERT INTO cac_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ayic ix yilan vin̈aj Jetro yuj tas syutej vin̈aj Moisés sb'oan yaj yoval eb' anima chi', ix yalan vin̈ d'a vin̈: —¿Tas yuj icha chi' tzutej eb' anima tic? ¿Tas yuj a achn̈ej tza b'o yaj yoval eb' smasanil? Ay eb' ton̈ej tz'ec' tiempo d'ay, pilan c'u stan̈vej eb', xchi vin̈aj Jetro chi'. ");
INSERT INTO cac_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ix tac'vi vin̈aj Moisés chi': —Sjavi eb' anima tic d'ayin yic tzin c'anb'an d'a Dios yuj eb'. ");
INSERT INTO cac_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ayic syac'an oval eb' sjavipax eb' d'ayin, tzin ch'olb'itan mach tz'ec' d'a yib'an̈ yed' mach yel syala', slajvi chi' svalan schecnab'il yed' sc'ayb'ub'al Dios d'a eb', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ix yalan vin̈ sn̈i' vin̈ chi': —Man̈ vach'oc icha tzutej chi'. ");
INSERT INTO cac_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tzach te c'unb'i, ste c'unb'ipax eb' anima tic. Yelxo tz'ec' yib'an̈ a munlaji, an̈ejtona' man̈ ol ach tzac'vanpaxlaj a ch'ocoj. ");
INSERT INTO cac_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ab' tas ol val d'ayach, a Dios ol colvaj ed'oc. A ach tzach och d'a yichan̈ Dios yuj eb' anima, tzalan d'ay yuj tastac sc'ulej eb'. ");
INSERT INTO cac_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Vach' to tza c'ayb'ej eb' d'a sley Jehová, tzalani tas ol aj sb'eyb'at eb' yed' tas ol sc'ulej eb'. ");
INSERT INTO cac_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","A jun tas vach' tza c'ulej ticnaic to tza siq'uel jayvan̈oc eb' vin̈ ay xivc'olal d'a Dios, eb' vin̈ jelan spensar, eb' vin̈ tojol spensar, eb' vin̈ man̈ comonoc sc'ananel tumin d'a anima. Tzac'anoch yopisio eb' vin̈ d'a yib'an̈ junjunoc macan̈ anima. Ay eb' vin̈ tzac'och yajaliloc d'a junoc mil anima, ay pax eb' vin̈ tzac'och yajaliloc d'a junoc cien, ay pax eb' vin̈ an̈ej d'a junoc 50 b'aj tzac'ochi, ay pax eb' vin̈ an̈ej d'a lajun̈van̈oc b'aj tzac'ochi. ");
INSERT INTO cac_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","A eb' vin̈ tic ol b'oan yaj yoval eb' anima. Tato quenn̈ej yaj yoval anima chi', sb'o'ocab' yaj eb' vin̈. Tato nivan yaj jun, yic'ocab'cot eb' d'a ichan̈. Tato icha chi' ol utej, ol colvaj jab'oc eb' yic'anel jun munlajel tic d'a ib'an̈. ");
INSERT INTO cac_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Tato tza c'anab'ajej a c'ulan jun tic, tato schapax sc'ol Dios to icha chi' ol ajoc, icha chi' ol aj stechaj uuj. An̈ejtona' eb' anima tic ol meltzaj eb' d'a tzalajc'olal d'a yed'tal junjun, xchi vin̈aj Jetro chi'. ");
INSERT INTO cac_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ix sc'anab'ajan vin̈aj Moisés tas ix yal vin̈ sn̈i' chi'. ");
INSERT INTO cac_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Yuj chi' ix sic'anel eb' te ay spensar vin̈, eb' jelan d'a scal eb' yetchon̈ab', ix yac'anoch yopisio eb' vin̈ d'a yib'an̈ junjun mil anima, d'a yib'an̈ cien, d'a yib'an̈ 50 yed' d'a yib'an̈ lajun̈vaan̈. ");
INSERT INTO cac_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","A eb' vin̈ chi' ayn̈ejoch d'a yib'an̈ sch'olb'itan yaj eb' anima. A oval te nivan yaji, tz'ic'chajb'at d'a yichan̈ vin̈aj Moisés chi'. Axo pax oval quenn̈ej yaj jun, a eb' vin̈ sb'oan yaji. ");
INSERT INTO cac_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ix stac'lancan sb'a vin̈aj Jetro yed' vin̈aj Moisés chi', ix pax vin̈ d'a schon̈ab'. ");
INSERT INTO cac_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","A val stz'acvi yoxil ujal yel eb' israel d'a Egipto, ix ja eb' d'a taquin̈ luum b'aj ay lum Sinaí, ");
INSERT INTO cac_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","spetoj eb' d'a Refidim. A ix ja eb' ta' ix sb'oan scampamento eb' d'a yich vitz Sinaí. ");
INSERT INTO cac_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ix avtajq'ue vin̈aj Moisés yuj Jehová Dios d'a jolom vitz chi' yic slolon yed' vin̈. Ix yalan icha tic: —Al juntzan̈ lolonel tic d'a eb' yin̈tilal vin̈aj Jacob, aton eb' etisraelal: ");
INSERT INTO cac_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Scham val eyilan tas ix vutej eb' anima d'a Egipto yed' tas ix vutej ex vic'anelta, ayic ex vic'ancot b'aj ayex ec' tic. Ichato yib'an̈ sc'axil noc' nivac ch'acb'a ayexq'uei ayic ix ex ja d'a tic. ");
INSERT INTO cac_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Tato te c'anab'ajum tzeyutej e b'a d'ayin, tze c'anab'ajan in trato, in chon̈ab' ex toni, sic'b'il ex el vuj d'a scal juntzan̈xo chon̈ab'. Vic jun yolyib'an̈q'uinal tic smasanil, ");
INSERT INTO cac_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","palta a exxo tic, jun chon̈ab'il sacerdote tzex ajcani yic tzin eyac'an servil, jun chon̈ab' anima to vicn̈ej yaji, xchi Jehová, xa chi d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ix lajvi chi', ix emixta vin̈aj Moisés d'a jolom vitz Sinaí chi', ix yavtancot eb' yichamtac vinaquil chon̈ab' vin̈. Ix och ijan vin̈ yalan tas ix yal Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Masanil eb' israel ix tac'vi icha tic: —Masanil tas schec Jehová co c'ulej, ol co c'ulejn̈ej, xchi eb'. Ix lajvi chi', ix b'at yalanxi vin̈aj Moisés d'a Jehová tas ix yal eb' chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ix yalanxi Jehová chi' d'a vin̈: —A ticnaic, ol in ch'ox in b'a d'ayach d'a scal jun nivan q'uic'al asun, ol in lolon ed'oc, yic vach' ol yab' eb' anima, ol ach yac'anoch eb' d'a sc'ool d'a masanil tiempo, xchi. Ix yalanxi vin̈aj Moisés chi' d'a Jehová tas ix yutej yalan eb' chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ix yalanxi Jehová: —Ixic, tzal d'a eb' anima to sacb'itej sb'a eb' ticnaic yed' q'uic'an, sjuc'anel spichul eb' yujto ol och eb' ejmelal d'a vichan̈. ");
INSERT INTO cac_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Axo chab'ej tzin emuli, tzin ch'oxan in b'a d'a masanil chon̈ab' d'a jolom vitz Sinaí. ");
INSERT INTO cac_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Tzaq'uem yechel d'a yichtac vitz tic, tzalan d'a eb' to nivanocab' yelc'och jun vitz tic d'a yol sat eb'. Max yal-laj sq'ueta eb' d'ay, max yal ste javi eb' d'a stz'ey, tato ay junoc mach sjavi d'a stz'ey, yovalil schami. ");
INSERT INTO cac_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Malaj mach syal smac'ancham jun anima chi' yed' sc'ab'. Sjulq'uenaj chami, ma sjuljicham yed' jul-lab'. Taxon̈ej anima ma junoc noc' noc', tojoln̈ej schami. Ato ol puchaj sch'aac noc' calnel, ichato chi' syal snitzancot sb'a eb' anima d'a slac'anil lum vitz tic, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ix lajvi chi', ix paxta vin̈aj Moisés d'a jolom vitz chi', ix ul yalan vin̈ d'a eb' israel chi' to sacb'itej sb'a eb', sjuc'anpaxel spichul eb'. ");
INSERT INTO cac_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ix yalan vin̈aj Moisés chi' d'a eb': —A ticnaic sacb'itejec e b'a, yujto tzex och ejmelal d'a Jehová chab'ej. Man̈xo ex vay yed' eb' ix eyetb'eyum d'a chab' c'ual tic, xchi vin̈ d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Axo ix sacb'i d'a schab'jial, ix ec' copnaj leb'lon, ix mac'vaj c'u, ay jun nivan asun q'uic' d'a jolom vitz chi'. Ix lajvi chi, ix yab'an eb' anima te chaan̈ ix oc' jun q'uen trompeta d'a jolom vitz chi'. Masanil eb' anima ayec' d'a yol campamento chi', ix xivq'ue eb'. ");
INSERT INTO cac_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ix lajvi chi', ix yic'anb'at masanil eb' anima vin̈aj Moisés chi' d'a spatiquel campamento chi', ix b'at schaan Dios eb', ix can oyan eb' d'a slac'anil yich lum vitz chi'. ");
INSERT INTO cac_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ix te q'ue stab'il lum vitzal Sinaí chi', ix emul Jehová d'a scal jun nivan c'ac'. Icha val sq'ue stab'il junoc horno, icha val chi' sq'ue stab'il, ix te ib'xiq'ue jun vitz chi'. ");
INSERT INTO cac_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Axo q'uen trompeta chi', juntac el spuji q'ueen, ste q'uechaan̈ sjaj q'ueen. Aton ta' ix lolon vin̈aj Moisés yed' Jehová. Te chaan̈ syutej tac'voc sb'a Jehová chi' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","A val d'a schaan̈il sjolom lum vitz chi', ata' ix emul Jehová, ix yalan d'a vin̈aj Moisés chi' to sq'ue vin̈ b'aj ayec' chi', yuj chi' ix q'ue vin̈. ");
INSERT INTO cac_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ix yalan Jehová d'a vin̈: —A ticnaic eman̈ d'a yich vitz chi', b'at alan d'a eb' anima to max ec'ta eb' in yil b'aj aycanem jun yechel, axo talaj tz'aji, tzijtum eb' schami. ");
INSERT INTO cac_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","An̈eja' eb' sacerdote tz'ochtaxon d'a in lac'anil, yovalil sacb'itej sb'a eb'. Tato maay, axo talaj tz'aji, svach' satel eb', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ix tac'vi vin̈aj Moisés chi' d'ay: —A eb' chon̈ab' chi', max yal-laj sq'ueta eb' d'a lum vitz tic, yujto a ach ix ala' to tz'em yechel b'aj syal sjavi eb' yuj sch'oxani to nivan yelc'ochi, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ix yalanxi Jehová d'a vin̈ icha tic: —Eman̈xi, axo tzach q'ueuli ed'nacocab' vin̈aj Aarón. Axo eb' sacerdote yed' masanil eb' chon̈ab', max c'axpajec'talaj eb' b'aj aycanem yechel chi' uuj, yic max javi eb' b'aj ayinec' tic, tato maay, xim miltachamlaj eb', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ix emta vin̈aj Moisés chi', ix ul yalan vin̈ d'a eb' chon̈ab' tas ix yal Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ix lolon Dios d'a eb' israel, ix yalan d'a eb' icha tic: ");
INSERT INTO cac_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","A in ton Jehová e Diosal in, ix ex viq'uelta d'a yol yic Egipto b'aj ayex och checab'oc, b'aj man̈ eyicoc e b'a. ");
INSERT INTO cac_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Malajocab' junocxo dios b'aj tzex och ejmelal, palta an̈ejocab' d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Man̈ e b'o yechel junoc tas e diosaloc, junoc tas ay d'a satchaan̈, tas ay d'a sat luum tic, ma tastac ay d'a yoltac a a'. ");
INSERT INTO cac_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Man̈ ex em n̈ojan d'ay, man̈ eyac'paxem e b'a d'ay, yujto a in Jehová e Diosal in, ste cot voval d'ayex tato tzex och ejmelal d'a junocxo tasi. Ol vac'och syaelal eb' mamab'il malaj velc'och d'ay. Ol vac'anpax yaelal d'a yib'an̈ yuninal eb', yixchiquin eb' yed' yin̈tilal eb'. ");
INSERT INTO cac_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Axo eb' tzin xajanani, eb' sc'anab'ajan in checnab'il, ol in xajanej eb' yed' eb' yin̈tilal eb' yic ol b'eyn̈ejb'atoc. ");
INSERT INTO cac_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Man̈ comonoc tze loc in b'i a in Jehová e Diosal in tic, ma tzeyac' b'inaj in b'i d'a junoc tas d'a ichn̈ej ta', yujto ol vac' yaelal d'a mach icha chi' sc'ulej. ");
INSERT INTO cac_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Nivanocab' yelc'och sc'ual ic'oj ip d'ayex yuj in eyic'anchaan̈. ");
INSERT INTO cac_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Vaque' c'ual tzex munlaj d'a e munlajel, ");
INSERT INTO cac_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","axo d'a yuquil c'ual, sc'ual ic'oj ip. A jun c'u chi' vic yaji. Man̈ ex munlaj d'a jun c'u chi' yed' eb' eyuninal, eb' eyisil, ma eb' vin̈ e checab', ma eb' ix e checab', ma noc' e molb'etzal noc', noc' smunlaji, ma eb' ch'oc chon̈ab'il ayec' d'a e cal, mocab' munlaj eb'. ");
INSERT INTO cac_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Yujto a in Jehová in tic, d'a vaque' c'ual ix in b'o satchaan̈ yed' sat luum yed' a' mar yed' masanil tastac ay d'ay. Axo d'a yuquil c'ual, ix och vaan in munlaji, yuj chi' a jun yuquil c'ual chi' vic yaji, yuj yochpax e vach'iloc. ");
INSERT INTO cac_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ayocab' yelc'och e mam e nun d'a e sat, yic vach' snajatb'i e q'uinal d'a sat lum luum ol vac' d'ayex. ");
INSERT INTO cac_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Man̈ e milcham eb' eyetanimail. ");
INSERT INTO cac_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Man̈ ex em ajmulal d'a yol sc'ab' eyetb'eyum junjun ex. ");
INSERT INTO cac_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Man̈ ex elc'anoc. ");
INSERT INTO cac_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Man̈ e naq'ue lolonel d'a spatic eb' eyetanimail. ");
INSERT INTO cac_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Man̈ e nib'ejoch spat eb' eyetanimail. Man̈ e nib'ejpaxoch ix yetb'eyum eb', vin̈ schecab' eb', ma ix schecab' eb', noc' svacax eb', noc' sb'uru eb', ma junocxo tas ay d'a eb' eyetanimail chi', man̈ e nib'ejochi, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Masanil eb' israel ix yab' val eb' smac'vaj c'u. Ix yilan eb' yec' copoljoc c'ac', ix yab'anpax eb' te chaan̈ ix puji jun q'uen trompeta. Ix yilan val eb' sq'ue stab'il lum vitzal Sinaí, ix ib'xiq'ue eb' yuj xivelal, ix snitzanel sb'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Yuj chi' ix yal eb' d'a vin̈aj Moisés: —A ach tzach lolon d'ayon̈. Ol co c'anab'ajan tas ol yal Jehová Dios chi' d'ayach. Mocxob' lolon d'ayon̈, tato maay, ol on̈ chamoc, xchi eb' anima chi'. ");
INSERT INTO cac_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ix tac'vi vin̈aj Moisés chi': —Man̈ ex xivoc, ton̈ej tzulec' Dios chi' yic tzex yac'an proval, yic vach' ayn̈ej e xivc'olal d'ay, yic man̈ ol ochn̈ej e mul, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Yuj chi' a eb' chon̈ab' chi', najat ayel eb', axo vin̈aj Moisés chi' ix snitzb'at sb'a vin̈ d'a slac'anil jun asun q'uic' b'aj ayec' Dios chi'. ");
INSERT INTO cac_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ix yalan Jehová d'a vin̈aj Moisés chi': Al juntzan̈ lolonel tic smasanil d'a eb' etisraelal: A ex tic ix eyila' chajtil ix vutej in lolonemta d'ayex d'a satchaan̈. ");
INSERT INTO cac_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Man̈ e b'o q'uen oro ma q'uen plata e diosaloc yic b'aj tzex och ejmelal, icha tz'aj eyac'anem e b'a d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","B'oec junoc altar d'ayin, nab'a luum tzeyac'och d'ay, yic b'aj tze n̈ustz'a noc' calnel, ma noc' vacax tzeyac' silab'il d'ayin, ma b'aj tze n̈ustz'a ofrenda yic e junc'olal ved'oc. Yaln̈ej b'aj ol in ch'ox d'ayex yic tzex och ejmelal d'ayin, ata' ol vac' in vach'c'olal d'a eyib'an̈. ");
INSERT INTO cac_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Tato a q'uen q'ueen tzeyac'och d'a junoc altar chi', man̈ e tzeylaj q'ueen, tato tzeyac'och q'uen tzeyb'il chi', man̈ vach'oc d'a yol in sat. ");
INSERT INTO cac_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","A jun altar tze b'o chi', man̈ eyac'och sc'oochal b'aj tzex q'uei, yic vach' max ilji e nivanil, xa chi d'a eb', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi': A juntzan̈ ley tic ol al d'a eb' etchon̈ab' yic sc'anab'ajej eb': ");
INSERT INTO cac_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Tato ay junoc vin̈ eyetchon̈ab' tze mana' yic tz'och e checab'oc, an̈ej vaque' ab'il smunlaj vin̈ eyed'oc, axo d'a yuquil ab'il tzeyac'anel vin̈ d'a libre, yicxo sb'a vin̈. Malaj tumin syac' vin̈ yic tzeyac'anel vin̈ d'a libre chi'. ");
INSERT INTO cac_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Tato sch'ocojiln̈ej vin̈ c'ochnac d'ayex, an̈eja' sch'ocojil vin̈ sb'ati. Tato ay ix yetb'eyum vin̈ yed'nac jun, an̈eja' syic'b'at ix vin̈ yed'oc. ");
INSERT INTO cac_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Tato a ex ix e man vin̈ chi', a ex ix eyac'och yetb'eyum vin̈, scan ix ix chi' yed' eb' unin eyed'oc, sch'ocoj vin̈ sb'ati. ");
INSERT INTO cac_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Tato syal vin̈ checab' chi' jun: Malaj in gana tzin el d'a libre yujto xajan vin̈ in patrón yed' ix vetb'eyum yed' pax eb' vuninal vuuj, tato xchi vin̈, ");
INSERT INTO cac_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","tzeyic'b'at vin̈ d'a yichan̈ eb' yajal. Tz'och lin̈an vin̈ d'a smarcoal spuertail sdespacho eb' vin̈ yajal chi', tzeyolan schiquin vin̈ d'a q'uen ol-lab', tz'ochcan yechel vin̈ to scan vin̈ eyed'oc d'a juneln̈ej. ");
INSERT INTO cac_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Tato ay junoc mach schon̈el yisil d'a checab'oc, max yal-laj yac'jiel eb' ix d'a libre ichoc eb' vin̈ vinac. ");
INSERT INTO cac_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Tato a vin̈ spatrón ix chi' maj chaanlaj sc'ol yoch ix yetb'eyumoc icha yaj strato eb' yujto malaj sgana vin̈ d'a ix, syal smanjixiel ix yuj junoc sc'ab'yoc. Vach'chom malaj sgana vin̈ patrón chi' syic'laj sb'a yed' ix, palta max yal-laj schon̈an ix vin̈ d'a junoc ch'oc chon̈ab'il. ");
INSERT INTO cac_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Tato a vin̈ patrón chi' smanan ix yic tz'och ix yetb'eyumoc junoc yuninal, ichaocab' yisil syutej ix. ");
INSERT INTO cac_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Palta tato a vin̈ spatrón ix chi' tz'ic'an ix yetb'eyumoc, syic'an junocxo ix vin̈, mocab' emnaquil tz'aj ix b'ab'el chi', palta yovalil syac' svael ix vin̈ yed' spichul ix, svaypax vin̈ yed' ix. ");
INSERT INTO cac_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Tato max sc'anab'ajej vin̈ yac'an oxe' tastac tic, tz'actajel ix, man̈xa pax tas stup ix yic tz'actajeli. ");
INSERT INTO cac_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","A mach smilancham junoc anima, yovalil smiljipaxchamoc. ");
INSERT INTO cac_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Palta tato man̈ sc'anoc sc'ol ix milvaji, tato stiempoalxo scham jun anima chi', a in Jehová in ol val d'ayex b'aj ol b'at sc'ub'ejel sb'a jun mach ix milancham anima chi'. ");
INSERT INTO cac_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Palta a mach scham val snaani smilancham yetanimail, vach'chom b'aj ay valtar sb'at scol sb'a, tz'ic'chajelta, smiljichamoc. ");
INSERT INTO cac_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","A mach smac'an smam ma snun, yovalil schami. ");
INSERT INTO cac_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Tato ay mach tz'elc'anb'at junoc anima, tato toxo ix schon̈b'ati, ma aytoec' yed'oc, ayic syamchaj jun elc'um anima chi', yovalil schami. ");
INSERT INTO cac_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","A mach sb'ajan smam snun, mac'jocab' chamoc. ");
INSERT INTO cac_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Tato ay chavan̈oc syac' oval, tato ay junoc vin̈ slajvi yuj junxo vin̈ chi', taxon̈ej q'ueen syac'lab'ej vin̈, ma yed' sc'ab', an̈ejto max chami, palta te nivan ix aj yab'an syail, ");
INSERT INTO cac_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","axo d'a jayeoc c'ual tzaxo yal yec'xi yed' sc'ococh. A vin̈ smac'vaj chi', yovalil stup vin̈ b'aj tz'an̈taj vin̈ slajvi chi' yed' pax sc'u vin̈, palta max ac'jiochlaj chamel d'a yib'an̈ vin̈. ");
INSERT INTO cac_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Tato ay junoc vin̈ patrón smac'an schecab' yed' te te', taxon̈ej vinac ma ix, axo tz'aji schami, yovalil tz'och chamel d'a yib'an̈ vin̈. ");
INSERT INTO cac_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Palta tato tzato ec' jun checab' chi' chab' oxeocxo c'ual, ichato chi' schami, maxtzac ac'jiochlaj chamel d'a yib'an̈ vin̈ patrón chi', yujto yic yaj jun schecab' chi'. ");
INSERT INTO cac_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Tato ay chavan̈oc vinac van yac'an oval, syamchajc'och junoc ix ix to yab'ixxo d'a scal oval chi' yuj eb', tz'el unin chi' d'a spatic ix, palta malaj jab'oc tz'ic'an ix, a vin̈ tz'och smul chi' stupan jantac sc'an vin̈ yetb'eyum ix, an̈ejton pax a', ato syala' tas tz'aj sch'olb'itaj yuj eb' vin̈ juez. ");
INSERT INTO cac_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Palta tato ay tas tz'ic'an ix jun, ato syala' tas tz'ic'an ix chi', icha pax chi' tz'utajpax vin̈ tz'och smul chi'. Tato scham ix, schampax vin̈. ");
INSERT INTO cac_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Tato tz'ixtax yol sat ix, ma q'uen ye ix, ma sc'ab' ix, ma yoc ix, ");
INSERT INTO cac_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ta stz'a ix, ma slajvi ix, ma ton̈ej syaxla' snivanil ix, an̈eja' icha val tz'utaj ix chi', icha val chi' tz'utajpax vin̈ vinac chi'. ");
INSERT INTO cac_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Tato ay junoc mach smac'anpoj yol sat junoc vin̈ schecab', ma junoc ix schecab', tz'actajel vin̈ checab' ma ix checab' sq'uexuloc jun yol sat ix poj chi'. ");
INSERT INTO cac_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Tato ay junoc mach smac'anel q'uen ye junoc schecab', tz'actajel jun checab' chi' sq'uexuloc q'uen ye chi'. ");
INSERT INTO cac_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Tato ay junoc noc' toro stecancham junoc anima, yovalil sjuljicham noc', max chijilaj schib'ejal noc', palta malaj tas tz'och d'a yib'an̈ vin̈ yajal noc' chi'. ");
INSERT INTO cac_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Palta tato yojtac vin̈ yajal noc' chi' to ovtaxon noc' d'a anima, max yetzb'anpax noc' vin̈, tato stecjicham junoc anima yuj noc', yovalil sjuljicham noc', schampax vin̈ yajal noc' chi'. ");
INSERT INTO cac_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Tato schaji tupchaj jun chamel chi', stup vin̈ yajal noc' chi', ato syala' jantac sc'an eb' aj chamnac chi', tato icha chi' maxtzac chamlaj vin̈. ");
INSERT INTO cac_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Aton val juntzan̈ ley tic tz'och yopisio tato ay junoc uninab'il ma isilab'il stecjicham yuj noc' vacax. ");
INSERT INTO cac_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Tato a junoc vin̈ checab', ma junoc ix checab' stecjicham yuj noc', yovalil tz'ac'chaj 30 siclo q'uen plata d'a vin̈ spatrón jun checab' chi', sjuljipaxcham noc' vacax chi'. ");
INSERT INTO cac_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Q'uinaloc ay junoc mach max smacchej sti' a' yuc'lab' a', ma sjoy junoc olan, max smacchejpax sti', sb'at junoc noc' vacax, ma junoc noc' b'uru d'a yool, ");
INSERT INTO cac_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","yovalil stup vin̈ ay yic jun olan chi' d'a vin̈ aj noc' chi', scan noc' ix cham chi' d'a vin̈ ay yic olan chi'. ");
INSERT INTO cac_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Tato ay junoc noc' storo junoc mach stecancham noc' storo junocxo, yovalil schon̈jiel noc' ix tecvaj chi', spucanec' q'uen stojol noc' chi' eb' d'a spatic. An̈eja' spucpaxec' noc' ix tecjicham chi' eb'. ");
INSERT INTO cac_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Tato yojtacxo vin̈ ay yic noc' ix tecvaj chi' to toxonton ov noc', max stan̈vanpax noc' vin̈, yovalil syac' junocxo noc' vin̈ sq'uexuloc noc' ix cham chi', scan noc' chamnac chi' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Tato ay junoc mach tz'elc'an junoc noc' vacax, ma junoc noc' calnel, yic smilcham noc', ma yic schon̈b'at noc', tato syamchaj vin̈ d'a yelc'al chi', ovan̈xo sq'uexul noc' vacax chi' syac' vin̈. Tato calnel noc' jun, chan̈van̈xo pax sq'uexul noc' syac' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","A junoc mach tz'elc'ani, yovalil stup tas syelq'uej chi'. Tato malaj stumin jun elc'um chi', yovalil schon̈chajeli, axo d'a stojol b'aj schon̈chaj chi', ata' stup tas syelq'uej chi'. Tato tz'ilchaj noc' noc' elc'ab'il chi', yovalil stupchaj noc', chavan̈xo tz'aj stupchaj noc', taxon̈ej junoc noc' vacax, ma junoc noc' b'uru, ma junoc noc' calnel. Tato tz'ilchaj junoc elc'um d'ac'valil, van yoch d'a junoc pat yic syelc'an junoc tas, tato smac'jicham yuj vin̈ aj pat chi', malaj tz'aji. Max ochlaj d'a spatic vin̈ smilvaj chi'. Tato d'a c'ualil tzuji jun, tz'och d'a spatic vin̈ smilvaj chi'. ");
INSERT INTO cac_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Tato ay junoc mach stan̈van va noc' smolb'etzal noc' d'a sluum, palta axo d'a scal yavb'en te' junocxo mach sc'och noc' vael chi', yovalil syac' sq'uexul mach ay yic noc' chi'. A val sat yavb'en te vach' syac' sq'uexuloc. ");
INSERT INTO cac_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Tato ay junoc mach van sn̈usan spatan, tz'el c'ac' yuuj, stz'ab'at strigo junoc mach, vach'chom molb'ab'ilxo ixim, mato manto jochchajlaj ixim, a mach tz'actanel c'ac' chi', yovalil stup smasanil tas tz'ab'at chi'. ");
INSERT INTO cac_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Tato ay junoc mach syac'b'at stumin, ma junocxo tas ay stojol sic'b'at junocxo, axo tz'aji tz'elc'ajelta d'a yol spat vin̈ sic'jinac chi', tato tz'ilchaj vin̈ elc'um chi', cha macan̈xo tz'aj yac'an sq'uexul vin̈. ");
INSERT INTO cac_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Tato max yamchaj vin̈ elc'um chi' jun, tz'ic'chajb'at vin̈ aj pat chi' d'a yichan̈ vin̈ juez yic tz'ilji tato man̈oc vin̈ ix yaman q'uen tumin chi', ma juntzan̈ tastac tz'ac'ji sic'canb'at vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Tato ay junoc anima smacq'ue junoc tas yicoc: Noc' vacax, noc' calnel, noc' b'uru, ma junoc pichul, ma junocxo tas ton̈ej satb'ati, syalan junocxo to yico', tz'ic'chajb'at eb' chavan̈ chi' d'a yichan̈ eb' juez. A jun mach tz'esan chi', yovalil chab' tz'aj yac'an sq'uexul d'a mach ay yic chi'. ");
INSERT INTO cac_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Tato ay junoc mach ton̈ej syac'can ab'enal junoc noc' b'uru, ma junoc noc' vacax, ma junoc noc' calnel, ma yaln̈ej tas molb'etzal noc' d'a junocxo mach, axo tz'aji, a noc' noc' chi' scham noc', ma slajvi noc', ma tz'elc'ajb'at noc'. Tato malaj mach tz'ilani, ");
INSERT INTO cac_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","syac' sti' vin̈ anima chi' d'a yichan̈ Jehová yed' d'a yichan̈ vin̈ ay yic noc' noc' chi' to man̈oc vin̈ ix yaman noc'. Axo vin̈ ay yic noc' chi' schaan yab' tas ix yal vin̈ chi', yuj chi' max stuplaj noc' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Palta tato q'uelanoch vin̈ tz'elc'ajb'at noc', yovalil stup vin̈ d'a vin̈ yajal noc' chi'. ");
INSERT INTO cac_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Tato schijib'at noc' yuj noc' choj, ma yuj noc' oques, yovalil syic'cot jab'ocxo noc' vin̈, yic vach' syil vin̈ yajal noc' chi'. Tato icha chi', max stuplaj noc' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Tato ay junoc mach sc'anan junoc noc' noc' smajnej: Noc' chej, noc' vacax, talaj scham noc', ma slajvi noc', palta max yil-laj vin̈ yajal noc' chi', yovalil stup noc' mach ix majnan chi'. ");
INSERT INTO cac_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Palta tato q'uelanoch vin̈ yajal noc' chi' scham noc', max stuplaj noc' vin̈ smajnan noc' chi', yujto strato eb' yaji, an̈ej smajananub'al noc' syac' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Q'uinaloc ay junoc vinac tz'ac'an musansatil junoc ix cob'es mantalaj b'aj ay strato, svay vin̈ yed' ix, yovalil syac' q'uen tumin vin̈ yic stojoloc ix d'a smam ix, ichataxon b'eyb'al. Yovalil syic' ix vin̈. ");
INSERT INTO cac_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Tato max yal sc'ol smam ix to syic' jun vin̈ chi' ix, palta yovalil syac' q'uen tumin vin̈ d'a smam ix ix chi', ichataxon sb'eyb'al eb' anima a smojc'aj eb' ix cob'estac. ");
INSERT INTO cac_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Masanil eb' ajb'aal, yovalil scham eb'. ");
INSERT INTO cac_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Tato ay mach smulan yed' noc' noc', yovalil schami. ");
INSERT INTO cac_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Tato ay mach syac' silab' d'a comon dios, to man̈oc d'ayin a in Jehová in tic syac'a', yovalil smac'jichamoc. ");
INSERT INTO cac_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Man̈ eyixtej eb' anima ch'oc chon̈ab'il ton̈ej ayec' d'a e cal, yujto ex ec'pax d'a ch'oc chon̈ab'il d'a Egipto. ");
INSERT INTO cac_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Man̈ eyixtej eb' ix chamnacxo yetb'eyum, ma eb' unin man̈xalaj smam. ");
INSERT INTO cac_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Tato tzeyixtej eb', a d'ayin ol yal sb'a eb', ol vab' tas syal eb' chi' d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ol cot voval d'ayex, ol ex vic'anb'at d'a junoc oval. Icha chi' ol aj ex vac'anchamoc. Yuj val chi', a eb' ix eyetb'eyum scan eb' ix d'a man̈ etb'eyumal, scanpax eb' eyuninal d'a meb'ail. ");
INSERT INTO cac_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Tato tzeyac' q'uen tumin majanil d'a junoc eyetchon̈ab' meb'a' anima, man̈ e c'an yune' q'uen d'ay icha syutej sb'a eb' tz'ac'antaxon q'uen majanil. ");
INSERT INTO cac_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Tato syac'can junoc spichul, yujto smajnej q'uen tumin chi', tzeyac' meltzaj d'ay a tz'emxican c'u, ");
INSERT INTO cac_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","talaj an̈ej jun spichul chi' syac'och yuj siic, an̈ej syac'och d'ac'valil. Yuj chi', tato syal sb'a d'ayin, d'a elan̈chamel tzin colvaj d'ay, yujto a in tic elan̈chamel tz'oc' in c'ol d'a anima. ");
INSERT INTO cac_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Man̈ eyal chucal lolonel d'a spatic eb' juez, ma d'a spatic vin̈ yajal e chon̈ab'. ");
INSERT INTO cac_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Mocab' najtilax eyic'ancot eyofrenda d'ayin, aton sb'ab'el sat eyavb'en. A eb' e b'ab'el vinac unin tzeyac' eb' d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Icha chi' tz'ajpax noc' b'ab'el yune' noc' e vacax yed' noc' e calnel. Scan uqueoc c'ual noc' yed' snun, axo d'a svajxaquil c'ual yalji noc', tzeyac'an noc' d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Vic eyaj a ex tic. Yuj chi' man̈ e chi' schib'ejal noc' noc' milb'ilcham yuj noc' c'ultaquil noc', palta a d'a noc' tz'i' tzeyac' noc'. ");
INSERT INTO cac_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Man̈ eyal esal lolonel d'a spatic eb' eyetanimail. Man̈ junn̈ejoc tzeyutej e b'a yed' junoc mach chuc spensar yic tzeyac'anoch e b'a testigoal d'a tas man̈ yeloc. ");
INSERT INTO cac_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Man̈ eyac'och e b'a yed' eb' sc'ulan chucal. Man̈ eyac'och e b'a testigoal d'a es yed' eb' anima sc'ulan chucal. ");
INSERT INTO cac_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Vach'chom meb'a' junoc anima, palta tato ay smul, man̈ eyac' och e b'a yed'oc. ");
INSERT INTO cac_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Tato a junoc vin̈ ayoch ajc'olal d'ayex ay junoc noc' svacax, ma noc' sb'uru satnacb'ati, tz'ilchaj noc' eyuuj, iq'uecb'at noc' d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Yovalil tzex colvaj d'a mach schichonoch sc'ol d'ayex. Tato tzeyila' to stelvi noc' sb'uru d'a yalan̈ yicatz, tzeyic'q'ue vaan noc' yed'oc. ");
INSERT INTO cac_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Tato ay junoc anima meb'a' snib'ej sch'olb'itaj yaj yoval, man̈ e tenec' d'ay. ");
INSERT INTO cac_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Man̈ e cha junoc esal lolonel d'a spatic junoc anima. Man̈ eyac'och chamel d'a yib'an̈ junoc anima malaj smul, yujto a in ol vac' spac d'a mach icha chi' sc'ulej. ");
INSERT INTO cac_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Man̈ e cha q'uen tumin d'a elc'altac yic tze b'oan yaj junoc oval, yujto a yuj q'uen tumin chi' tzeyac' musansatil e b'a, tze q'uexancan tas tojol d'a tas man̈ tojoloc. ");
INSERT INTO cac_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Man̈ eyixtej anima ch'oc chon̈ab'il, yujto a ex tic najtil ix ex ec' d'a ch'oc chon̈ab'il d'a Egipto. Eyojtacxo syaelal tz'utaj anima d'a ch'oc chon̈ab'il. ");
INSERT INTO cac_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Vaque' ab'il tzex munlaj d'a sat lum luum, tze molanq'ue sat tas tzeyavej. ");
INSERT INTO cac_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Axo d'a yuquil ab'il, tzeyactancan luum. A jantacto tastac sq'uib'q'ue d'a sat luum, yicxo eb' meb'a' ayec' d'a yol e chon̈ab' chi' yed' noc' c'ultaquil noc'. Vach'chom te' eyuva ma te' eyolivo, man̈xo e mesa'. ");
INSERT INTO cac_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Vaque' c'ualn̈ej tzex munlaji, axo d'a yuquil c'ual tzeyic'an eyip. Yed' pax noc' e vacax, noc' e b'uru yed' eb' e checab' tz'alji d'a yol e cuenta yed' eb' ch'oc chon̈ab'il smunlaj eyed'oc syic'pax yip. ");
INSERT INTO cac_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","C'anab'ajejec masanil tas ix val tic d'ayex. Man̈ eyal e b'a d'a juntzan̈ comon dios, man̈ e locpax sb'i. ");
INSERT INTO cac_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Oxel tzeyac'och q'uin̈ d'a yol junjun ab'il yic tzin eyic'anchaan̈. ");
INSERT INTO cac_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","A d'a uj Abib tzeyac'och sq'uin̈al ixim pan malaj yich, icha ix vutej valan d'ayex. D'a uque' c'ual tze va ixim pan malaj yich, yujto a d'a jun uj chi' ix ex elta d'a Egipto. Malajocab' junoc mach sja d'a vichan̈ tato malaj jab'oc yofrenda yed'nac. ");
INSERT INTO cac_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Tzeyac'anpaxoch q'uin̈ ayic tz'elul sb'ab'el sat tas tzeyavej. An̈eja' tzeyac'anpaxoch junxo q'uin̈ ayic slajvicanq'ue masanil sat tastac tzeyavej chi'. ");
INSERT INTO cac_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","A in Jehová e Yajalil in tic svala' to a d'a oxe' q'uin̈ chi' yovalil sjavi masanil eb' vin̈ vinac d'a vichan̈. ");
INSERT INTO cac_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ayic tzeyac'an noc' noc' silab'il d'ayin, man̈ eyac'laj schiq'uil noc' yed' ixim pan ayb'at yich. Man̈ e sic'b'at xepual noc' silab' chi' d'a junocxo c'ual. ");
INSERT INTO cac_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","A val sb'ab'el sat eyavb'en vach' tz'el d'a sat lum luum, a' tzeyic'b'at d'a in cajnub', a in Jehová e Diosal in svala'. Man̈ e tz'an̈ noc' yunetac chiva d'a scal yal yim snun. ");
INSERT INTO cac_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ol in checb'at jun vángel d'a eyichan̈ yic vach' tzex tan̈vaj yuj d'a yoltac b'e, ol ex yic'anb'at d'a jun lugar b'aj vach'xo yaj vuuj, b'aj ol ex ajoc. ");
INSERT INTO cac_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Scham val eyilani, man̈ e pitej e b'a d'ay, palta tze c'anab'ajej tas syala'. Ichato a' ol munlaj in q'uexuloc, man̈ ol ex yac'laj nivanc'olal tato man̈ ol e c'anab'ajej d'ay. ");
INSERT INTO cac_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Tato tze c'anab'ajej d'ay, tze c'ulan tas syal d'a in q'uexuloc, ol in och ajc'olal d'a mach ayoch ajc'olal d'ayex. Ol in och tec'tec' d'a yichan̈ mach sgana stec'b'ej sb'a d'a eyichan̈. ");
INSERT INTO cac_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","A jun vángel chi' ol b'ab'laj d'a eyichan̈. Ol ex yic'anb'at d'a sat lum sluum eb' amorreo, eb' hitita, eb' ferezeo, eb' cananeo, eb' heveo yed' eb' jebuseo. Juneln̈ej ol in satcanel eb'. ");
INSERT INTO cac_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Man̈ ex em n̈ojan d'a yichan̈ sdiosal juntzan̈ chon̈ab' chi'. Man̈ ex empax cuman d'ay, man̈ e b'eyb'alej sb'eyb'al eb' chon̈ab' chi' d'a eyic'anchaan̈ sdiosal eb'. A tas smoj tze c'ulej, to tze mac'poj sdiosal eb' chi' yed' masanil q'uen q'ueen ayoch d'ay. ");
INSERT INTO cac_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","A inn̈ej Jehová e Diosal in b'aj tzeyaq'uem e b'a. Tato icha chi' tzeyutej e b'a, ol vac' tas tze va'a yed' tas tzeyuq'uej. Najat pax ol viq'uel ilya d'a e cal. ");
INSERT INTO cac_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Najat pax ol vutoc e q'uinal. A d'a yol junjun e chon̈ab'il chi', malaj junoc ix ix ton̈ej ol el yune', man̈ junoc eb' ix to man̈ ol unevoc. ");
INSERT INTO cac_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ol vac' xivq'ue sc'ol eb' anima tzex chacani. Ol vac' somchaj spensar eb' chon̈ab' tzeyac' oval yed'oc yed' masanil eb' ayoch ajc'olal d'ayex, ol el lemnaj eb' d'ayex. ");
INSERT INTO cac_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ol vac' somchaj sc'ol eb' eyajc'ool yuj xivelal ayic manto ex c'ochlaj, yuj chi' ol el lemnaj eb' heveo, eb' cananeo yed' pax eb' hitita d'ayex. ");
INSERT INTO cac_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Man̈ junocn̈ej ab'il ol aj vic'anel eb' d'a eyichan̈, yic vach' max ixtaxb'at lum luum yic man̈ ol te q'uib'pax sb'isul noc' c'ultaquil noc' tz'ac'an chucal d'ayex. ");
INSERT INTO cac_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","C'ojanc'olaln̈ej ol aj vic'anel eb' anima chi' d'a sat luum, masanto ayic ol q'uib' e b'isul, yic tze macan lum masanil. ");
INSERT INTO cac_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Toxo ix vac'canem stz'acan̈il b'aj ol ec' lum e luum chi'. Schael yich b'aj ay a' Chacchac Mar, masanto sc'och d'a a' Éufrates, sb'atxon̈ej d'a a' mar Mediterráneo, masanto d'a taquin̈ luum. Ol vac'anoch eb' cajan d'a sat luum chi' d'a yol e c'ab'. A exxo ol e pechel eb' d'a sat luum chi'. ");
INSERT INTO cac_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Man̈ val e b'o junoc e trato yed' eb', man̈ ex ochpax ejmelal d'a sdiosal eb'. ");
INSERT INTO cac_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Man̈xo pax e chacan eb' d'a yol e chon̈ab', yic vach' max ex scuchb'ej eb' e c'ulan chucal d'ayin. Tato tzeyaq'uem e b'a d'a sdiosal eb' chi', a ex val tzeyixtejb'at e b'a syal chi', xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ix yalan Jehová d'a vin̈aj Moisés chi' icha tic: —Tzach q'ueta d'a lum vitz b'aj ayinec' tic yed' vin̈aj Aarón, vin̈aj Nadab yed' vin̈aj Abiú yed' pax 70-oc eb' yichamtac vinaquil e chon̈ab'. A eb' chi' najatto scan eb' yaq'uem sb'a d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","A achxon̈ej syal a q'ueul d'a in tz'ey, axo pax eb' vin̈ chi', max yal-laj sq'ueta eb' vin̈ yed' pax eb' chon̈ab' max yal-laj sq'ueta eb' ed'oc, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ix lajvi chi', ix emixta vin̈aj Moisés chi', ix yalan vin̈ d'a eb' anima tas leyal ix yac' Jehová yed' tas ix yutej yalani. Axo masanil eb' anima chi', junn̈ej ix aj stac'vi eb'. —Masanil tas ix yal Jehová chi', ol co c'anab'ajej, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ix lajvi chi', ix stz'ib'an vin̈aj Moisés masanil tas ix yal Jehová. Axo ix sacb'inaj d'a junxo c'u, ix q'ue vaan vin̈, ix sb'oan jun altar vin̈ d'a yich vitz chi', ix yac'anq'ue lin̈an lajchave' q'uen q'ueen vin̈. A junjun q'uen q'ueen chi', junjun macan̈ yin̈tilal Israel sch'ox q'ueen. ");
INSERT INTO cac_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","D'a elan̈chamel ix schecan juntzan̈ eb' vin̈ quelemtac vinac vin̈aj Moisés chi' yic smilan noc' toro eb' silab'oc yic stz'a d'a smasanil yed' juntzan̈xo silab' yic sch'oxan sjunc'olal eb' yed' Jehová. ");
INSERT INTO cac_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Axo vin̈aj Moisés chi' ix chaan nan̈al schiq'uil noc', ix yac'anem vin̈ d'a yol juntzan̈ yed'tal, axo nan̈alxo, ix stzicanoch vin̈ d'a altar chi'. ");
INSERT INTO cac_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ix yic'anq'ue vin̈ b'aj tz'ib'ab'il strato Dios, ix yavtan vin̈ d'a scal eb' chon̈ab'. Ix lajvi yavtan vin̈, ix yalan eb' chon̈ab' chi' icha tic: —Masanil tas syal Jehová, ol co c'anab'ajej, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ix lajvi chi', ix yic'ancot schiq'uil noc' vin̈, aton ix yac'canem vin̈ d'a yol juntzan̈ yed'tal chi', ix stzicanb'at vin̈ d'a yib'an̈ eb' anima chi'. Ix yalan vin̈ icha tic: —A jun chic' tic sch'oxani to tz'ochcan yopisio jun strato Jehová ix sb'o qued'oc tic, aton masanil tas ix yal d'ayon̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ix lajvi chi', ix q'uex vin̈ d'a lum vitzal Sinaí chi'. Ajun vin̈aj Aarón, vin̈aj Nadab, vin̈aj Abiú yed' pax 70 eb' yichamtac vinaquil chon̈ab' ix q'ue yed' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ata' ix yil sDiosal eb' vin̈. A d'a yalan̈ yoc, toxon̈ej scopopi icha q'uen zafiro te vach' yilji, icha syaxil satchaan̈. ");
INSERT INTO cac_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Malaj tas ix utaj eb' vin̈ yuj yipalil Dios. Ix yil Dios eb' vin̈, ix va eb' vin̈, ix yuc'an a' eb' vin̈ d'a yichan̈. ");
INSERT INTO cac_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ix yalan Jehová d'a vin̈aj Moisés chi' icha tic: —Q'uean̈cot d'a jolom vitz b'aj ayinec' tic, tza tan̈van ta', ata' ol vac' chab' q'uen q'ueen d'ayach, aton q'uen b'aj tz'ib'ab'iloch juntzan̈ checnab'il vuuj, yic tz'och e c'ayb'ub'aloc, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ix q'ue vin̈aj Moisés d'a lum vitz chi' yed' vin̈aj Josué vin̈ scolvaj yed' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ayic manto b'atlaj vin̈, ix yalan vin̈ d'a eb' yichamtac vinaquil chon̈ab' chi': —Canan̈ec d'a tic masanto ol on̈ emxuloc. Ayec' vin̈aj Aarón yed' vin̈aj Hur eyed'oc. Tato ay tas e gana sb'oi, a eb' vin̈ tic ol b'oan d'ayex, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ix lajvi chi', ix q'ue eb' vin̈ schavan̈il. D'a elan̈chamel ix och moynaj jun asun d'a lum vitz chi'. ");
INSERT INTO cac_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Axo stziquiquial Jehová ix javi d'a yib'an̈ lum vitzal Sinaí chi', vaque' val c'ual ix och oyan asun d'a luum. Axo d'a yuquil c'ual ix avtajq'ue vin̈aj Moisés yuj Jehová d'a scal asun chi'. ");
INSERT INTO cac_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ix sch'ox sb'a stziquiquial Jehová d'a scal jun asun d'a lum vitz chi', d'a yichan̈ eb' chon̈ab'. A stziquiquial chi', lajan yilji icha junoc c'ac' te ov stz'ab'at smasanil yuuj. ");
INSERT INTO cac_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ix lajvi chi', ix b'at vin̈aj Moisés d'a scal jun asun chi'. Ix q'ue vin̈ d'a slajvub'alxo sjolom lum vitz chi'. 40 c'ual yed' 40 ac'val ix can vin̈ ta'. ");
INSERT INTO cac_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ix yalan Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Al d'a eb' etisraelal to syac' junoc ofrenda eb' d'ayin. A jun ofrenda chi', tz'ic'jichaan̈ d'a scal eb' to tz'el val d'a sc'ol yac'ani. ");
INSERT INTO cac_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","A tastac ol ic'chajq'ue vaan chi', aton juntzan̈ tic: Q'uen oro, q'uen plata, q'uen bronce, ");
INSERT INTO cac_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","an̈ ch'al q'uic'mutz'inac, an̈ ch'al yaxmaquinac, an̈ chac ch'al, an̈ ch'al lino yelxo val vach', xil noc' chiva ch'alb'il, ");
INSERT INTO cac_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","stz'umal noc' ch'ac calnel uc'nac yed' chacchac, noc' tz'uum te' lab'ab'i, pax te' acacia, ");
INSERT INTO cac_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","aceite sc'anji d'a candil, perfume, yaceiteal sat te' olivo sc'anji ayic sic'chajcanoch junoc mach, ma junoc tas vicoc, incienso suc'uq'ui sjab', ");
INSERT INTO cac_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","q'uen cornalina yed' juntzan̈xo q'uen q'ueen te vach' yilji tz'och d'a c'apac schaleca vin̈ sat sacerdote yed' d'a c'apac ayoch d'a sn̈i' sc'ol spichul vin̈. ");
INSERT INTO cac_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Tze b'oan junoc in cajnub', yic vach' tzin cajnaj d'a e cal. ");
INSERT INTO cac_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Palta a b'aj ol in ec' cajan chi' yed' masanil tastac ol c'anchaj d'a yool, yovalil ol e b'o icha val yaj yechel ol in ch'ox d'ayach. ");
INSERT INTO cac_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","B'oocab' junoc caxa, a te' acacia tz'och d'ay. Jun metro yed' 10 centímetro tz'aj sc'atul, 70 centímetro tz'aj sat, 70 centímetro pax tz'aj schaan̈il. ");
INSERT INTO cac_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Tz'och q'uen oro te vach' d'a yool yed' d'a spatic, tz'och q'uen d'a stitac d'a yib'an̈ b'aj tzalanq'uei. ");
INSERT INTO cac_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Sb'opax chan̈eoc q'uen argolla nab'a oro, tz'och d'a yoc schan̈il, chab' d'a junjun pac'an̈. ");
INSERT INTO cac_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Sb'ochajpaxoch sb'achlab'il. A te' acacia tz'ochi, tz'ochpax q'uen oro d'a spatic te'. ");
INSERT INTO cac_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Tz'ecchajec' te' d'a yol juntzan̈ q'uen argolla tz'och d'a spac'ultac te' caxa chi', aton yed' juntzan̈ te' chi' syal sb'achjiq'ue te' caxa chi'. ");
INSERT INTO cac_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Scan te' d'a yol q'uen argolla ayoch d'a te' caxa chi', maxtzac ic'chajel-laj te'. ");
INSERT INTO cac_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","A d'a yol te' caxa chi' tzac'canem q'uen q'ueen b'aj ayoch in trato ol vac' d'ayach. ");
INSERT INTO cac_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Sb'ochajpax smacul te' caxa chi'. Aton d'a smacul te' chi' stzicjiec' chic' yic tz'ac'ji tup mul. A q'uen oro te vach' tz'och d'ay, jun metro yed' 10 centímetro tz'aj sc'atul, 70 centímetro tz'aj sat. ");
INSERT INTO cac_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Axo d'a chab' stitac jun smacul chi', tz'och junjun yechel querubín, nab'a oro tz'aji, stenjib'o d'a q'uen martillo. ");
INSERT INTO cac_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","A jun smacul chi' yed' juntzan̈ yechel querubín chi', junn̈ej tz'aji. Junjun juntzan̈ querubín chi' scan d'a junjun sti' jun smacul chi'. ");
INSERT INTO cac_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","D'an̈d'umb'a tz'aj juntzan̈ querubín chi', tz'em q'uelan d'a yib'an̈ jun smacul te' caxa chi'. Axo sc'axil, syil-laj sb'a sn̈i' d'a yib'an̈ smacul chi'. ");
INSERT INTO cac_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","A q'uen q'ueen b'aj ayoch in trato ol vac' chi' d'ayach, a d'a yol te' caxa chi' ol ac'canem q'ueen, ichato chi' tzac'anoch smacul te' chi'. ");
INSERT INTO cac_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","A d'a scal juntzan̈ yechel querubín ay d'a yib'an̈ smacul te' caxa chi', ata' ol in ch'ox in b'a d'ayach, ol vac' ojtaquejel smasanil checnab'il ol vac' a c'anab'ajej yed' eb' etisraelal. ");
INSERT INTO cac_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Sb'ochajpax junoc te' mexa, a te' acacia b'aj sb'o te'. 90 centímetro tz'aj sc'atul, 45 tz'aj sat, 65 tz'aj steel. ");
INSERT INTO cac_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Tz'och q'uen oro d'a te', sb'opax junoc nab'a oro tz'ec' oyan d'a spatic te' yoc schan̈il. ");
INSERT INTO cac_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Sb'opaxq'ue stitac te', tz'ec' oyan d'a yib'an̈, uque' centímetro sq'uei, tz'och q'uen oro d'ay. ");
INSERT INTO cac_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Sb'opax chan̈eoc argolla nab'a oro tz'och d'a schiquintac schan̈il. ");
INSERT INTO cac_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","A d'a slac'anil b'aj ayem stitac chi', ata' tz'och juntzan̈ q'uen argolla chi'. A d'a yol q'uen argolla chi' tz'ec' sb'achlab'il te', yic syal yic'chajb'at te' mexa chi'. ");
INSERT INTO cac_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","A te' sb'achlab'il te' mexa chi', a d'a te' acacia b'aj sb'o te', tz'ochpax q'uen oro d'a te'. ");
INSERT INTO cac_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Sb'opax plato, nivac cuchara, xalu yed' uc'ab' b'aj schaji ofrenda a' yaji. Nab'a oro tz'och d'a juntzan̈ tic smasanil. ");
INSERT INTO cac_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Sb'ojiem jun mexa chi' d'a vichan̈, tz'em ixim pan vic yaj d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Sb'ochajpax junoc sb'achnub'al candil, nab'a oro tz'aji. A d'a q'uen martillo stenchaj b'o'oc. A sc'ojnub' b'aj tz'em b'achan yed' ste'al yed' pax scopail, icha sfloral tz'ajochi, junn̈ej yaman tz'aji. ");
INSERT INTO cac_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","A d'a stz'eytac, oxox sc'ab' tz'elta. ");
INSERT INTO cac_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","A d'a junjun sc'ab' tz'elta d'a jun ste'al chi', yovalil ay oxe' sfloral icha sfloral te' almendro. ");
INSERT INTO cac_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","An̈eja' d'a jun ste'al chi', ay chan̈e' sfloral icha sfloral te' almendro chi'. ");
INSERT INTO cac_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","A d'a yalan̈ b'aj ayelta junjun sc'ab' chi', scan junjun sfloral. ");
INSERT INTO cac_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","A juntzan̈ sfloral yed' sc'ab' chi', junn̈ej tz'aj yed' jun sb'achnub'al chi', nab'a oro tz'aji, stenjib'o d'a q'uen martillo. ");
INSERT INTO cac_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Sb'ochajpax uque' candil, tz'ac'chajem d'a yed'tal yic syac' saquilq'uinal d'a yichan̈. ");
INSERT INTO cac_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","A q'uen syamlab'il b'aj tz'ic'chajel stan̈il c'apac b'aj tz'och sc'ac'al yed' q'uen splatoal, nab'a oro tz'aji. ");
INSERT INTO cac_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Tz'och oxeoc arroba oro d'a jun b'achnub' candil chi' yed' syamc'ab'il. ");
INSERT INTO cac_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Scham val ilani to icha yaj yechel tzin ch'ox d'ayach d'a jolom vitz tic, icha chi' tz'aj sb'oi. ");
INSERT INTO cac_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Tza b'oanpax in cajnub' d'a lajun̈eoc jen̈an c'apac c'apac nab'a lino b'ayb'il te vach'. Sb'ojioch yechel querubín d'a c'apac yuj junoc mach jelan sb'oani. A d'a an̈ ch'al q'uic'mutz'inac, an̈ ch'al yaxmaquinac yed' d'a an̈ chac ch'al sb'ojioch yechel querubín chi'. ");
INSERT INTO cac_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Masanil juntzan̈ c'apac chi', lajan tz'aji: 12 metro yed' nan̈alxo tz'aj steel, chab' metro tz'aj sat. ");
INSERT INTO cac_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Slajvi chi' stz'ischaj syam sb'a oyeoc jen̈an c'apac, junxon̈ej tz'aji. An̈eja' icha chi' tz'ajpax oyexo c'apac chi'. Chab' jen̈an tz'ajcan c'apac. ");
INSERT INTO cac_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Tz'ochpax xoyjab' ch'al q'uic'mutz'inac syamnub'oc d'a jun pac'an̈oc sti' jun jen̈an c'apac b'ab'el. An̈eja' icha chi' tz'ajpax junxo jen̈an c'apac schab'il chi'. ");
INSERT INTO cac_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","A d'a c'apac b'ab'el jen̈an yed' pax d'a c'apac schab'il, yovalil sb'ochajoch xoyjab' 50-oc juntzan̈ ch'al q'uic'mutz'inac chi', yic vach' junxon̈ej tz'aj schalan sb'a c'apac schab'il. ");
INSERT INTO cac_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Sb'opax 50-oc syamnub'al nab'a oro, yic syal syamlan sb'a c'apac schab'il jen̈an, icha chi' tz'aj sb'oel junoc jen̈an tz'och d'a yib'an̈ in cajnub'. ");
INSERT INTO cac_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Sb'ochajpax uxluche'oc jen̈an xil noc' chiva jalb'il yic sb'at d'a yib'an̈ c'apac ayoch d'a yib'an̈ in cajnub' chi'. ");
INSERT INTO cac_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Masanil juntzan̈ chi', lajann̈ej tz'aji, 13 metro yed' nan̈alxo tz'aj steel, axo sat chab' metro tz'aji. ");
INSERT INTO cac_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Slajvi chi', stz'ischaj syam sb'a oyeoc jen̈an, junn̈ej jen̈an tz'ajcani. Stz'ischajpax syam sb'a vaquexo jen̈an chi'. A jun svaquil jen̈an, nan̈al spacchajemta d'a yichan̈ mantiado chi'. ");
INSERT INTO cac_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Sb'ochajoch xoyjab' 50-oc syamnub'al d'a jun pac'an̈oc stitac jun b'ab'el jen̈an, tz'ochpax 50-oc syamnub'al d'a jun pac'an̈oc sti' d'a jun schab'il jen̈an. ");
INSERT INTO cac_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Sb'opax 50-oc syamnub'al nab'a bronce, yic syal syamlan sb'a schab'il jen̈an, yic junxon̈ej jen̈an tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Yujto uxluche' jen̈an yaj xil noc' chiva chi', yuj chi' ayto nan̈alxo jen̈an tz'emcan pacan d'a spatic yed' d'a yichan̈. ");
INSERT INTO cac_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","A jun chi', ec'to jun metro steel d'a yichan̈ c'apac yalan̈, nan̈al metro ec'to d'a junjun stitac, yic smuschaj stitac c'apac aycan d'a yalan̈ chi'. ");
INSERT INTO cac_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Sb'ojipax stz'umal noc' calnel uc'nac d'a chacchac, yic sq'ue d'a yib'an̈ jun jen̈an xil noc' chiva chi' yed' junocxo macan̈ tz'uum te' lab'ab'i yic tz'och d'a yib'an̈ jun chi'. ");
INSERT INTO cac_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Sb'ochajpax juntzan̈ te' marco yic tz'och d'a spatic in cajnub', lin̈an tz'ajoch junjun te'. Masanil te', a te' acacia b'aj tz'elta te'. ");
INSERT INTO cac_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Nan̈al yoil metro tz'aj steel junjun te', 65 centímetro tz'aj sat te'. ");
INSERT INTO cac_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Scan chab'chab'oc yoc te' b'aj tz'em lin̈an. Lajann̈ej tz'ajcan scal. Icha chi' tz'aj te' tz'och d'a spatic in cajnub' chi' smasanil. ");
INSERT INTO cac_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ayic sb'oel te' chi', 20 te' tz'och d'a stojolal sur, ");
INSERT INTO cac_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","sb'ojiem 40 sb'achnub' yich te' nab'a plata tz'aji, chab'chab' tz'ajcan d'a yalan̈ junjun te', junjun d'a junjun yoc te'. ");
INSERT INTO cac_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Icha chi' tz'ajpax junxo pac'an̈ d'a stojolal norte, 20 pax te' sb'ojiochi. ");
INSERT INTO cac_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","An̈eja' 40 sb'achnub' yich te' sb'oji, nab'a plata tz'aji, chab'chab' tz'emcan d'a yich junjun te'. ");
INSERT INTO cac_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Axo d'a junxo pac'an̈ yol schiquin d'a stojolal b'aj tz'em c'u, vaque' te' sb'ojiochi. ");
INSERT INTO cac_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Sb'opax chab'ocxo te', junjun te' tz'och d'a junjun yesquinail jun pac'an̈ chi'. ");
INSERT INTO cac_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","A chab' te' marco chi', nub'ub'i tz'aj te', d'a yich masanto sq'uec'och b'aj syil-laj sb'a yuj junoc argolla, aton te' chi' tz'och d'a chab' yesquinail d'a jun pac'an̈ chi'. ");
INSERT INTO cac_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","A yuj chab'xo te' chi', vajxaque' tz'aj te' marco chi' d'a smasanil yed' 16 sb'achnub' yich te'. Chab'chab' sb'achnub' yich junjun te'. ");
INSERT INTO cac_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Sb'ochajpax oyeoc te' regla tz'och d'a spatic te' marco d'a junoc pac'an̈ in cajnub'. A te' acacia sb'ochaj reglail chi'. ");
INSERT INTO cac_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Sb'ochajpax oyeoc te' tz'och d'a junxo pac'an̈. An̈ejtona' sb'ochaj oyeoc te' tz'och d'a jun pac'an̈ d'a spatic, d'a stojolal b'aj tz'em c'u. ");
INSERT INTO cac_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","A te' regla tz'ec' d'a snan̈al te' marco chi', sb'at te' d'a jun schiquin masanto sc'axpajec'c'och te' d'a junxo schiquin. ");
INSERT INTO cac_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Slajvi chi', tz'och q'uen oro d'a spatictac te' marco chi', tz'ochpax q'uen argolla nab'a oro b'aj tz'ec' te' regla chi'. Tz'ochpax q'uen oro d'a te' regla chi'. ");
INSERT INTO cac_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Sb'ochajq'ue in cajnub' icha yaj yechel tzin ch'ox d'ayach d'a jolom vitz tic. ");
INSERT INTO cac_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Sb'ochajpax junoc c'apac cortina nab'a lino b'ayb'il. Sb'ojioch yechel querubín d'a c'apac yuj junoc mach jelan sb'oani. A d'a an̈ q'uic'mutz'inac ch'al, an̈ ch'al yaxmaquinac yed' pax an̈ chac ch'al sb'ojioch yechel querubín chi'. ");
INSERT INTO cac_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Slajvi chi', sq'ue locan c'apac d'a chan̈e' te' oy ayq'ue q'uen gancho nab'a oro d'a schon. A te' oy chi' a te' acacia, yovalil tz'ochpax q'uen oro d'a spatic te', tz'empax te' d'a yib'an̈ chan̈e' sb'achnub' yich nab'a plata. ");
INSERT INTO cac_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","A jun c'apac cortina chi' smacan snan̈al jun lugar scuch Vic Yaji yed' junxo lugar scuch A Inn̈ej Ay Vico'. Sq'ue locan c'apac d'a yalan̈ b'aj ayoch q'uen syamnub'al nab'a oro ayoch d'a yib'an̈, axo d'a spaticoch c'apac cortina chi' tz'ac'chajoch te' scaxail trato. ");
INSERT INTO cac_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Slajvi chi', tza macan te' scaxail trato yed' smacul, tz'ochcan te' d'a jun lugar scuch A Inn̈ej Ay Vico'. ");
INSERT INTO cac_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","A d'a yichan̈elta c'apac cortina chi', a d'a co vach' scan te' mexa yic ixim pan. Axo pax d'a co q'uexan̈ scan jun b'achnub' candil, q'uelc'umb'a tz'aj yed' te' mexa chi'. ");
INSERT INTO cac_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Axo d'a sti' in cajnub' chi', ata' sb'ojioch junoc c'apac cortina nab'a lino b'ayb'il. Yed' an̈ q'uic'mutz'inac ch'al, an̈ ch'al yaxmaquinac, an̈ chac ch'al sb'ochaj yelvanub' yuj junoc jelan sb'oani. ");
INSERT INTO cac_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Sb'opax oye' te' oy d'a te' acacia, tz'och q'uen oro d'a spatic te'. An̈ejtona' tz'ochpax q'uen gancho nab'a oro d'a schon te' yic vach' sq'ue locan c'apac cortina chi'. Sb'ojipaxem oye' b'achnub' yich nab'a bronce b'aj tz'em te' oy chi'. ");
INSERT INTO cac_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Sb'ochajpax junoc altar d'a te' chemte' nab'a acacia, lajann̈ej tz'aj yechel schan̈il pac'an̈. Chab' metro yed' 25 centímetro tz'aj junjun pac'an̈, jun metro yed' 25 centímetro tz'aj schaan̈il. ");
INSERT INTO cac_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Sb'ochajq'ue junjun sch'aac d'a junjun schiquintac. A juntzan̈ sch'aac chi' yaman tz'aj yed' jun altar chi', spichchaj te' d'a q'uen bronce. ");
INSERT INTO cac_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Masanil jantac syamc'ab'il altar chi', nab'a bronceocabi: Aton yed'tal b'aj tz'ic'chajel q'uen tic'aq'uil taan̈, q'uen pala, q'uen nivac uc'ab', q'uen tenedor yed' pax yed'tal b'aj tz'em te tzac'ac'. ");
INSERT INTO cac_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Sb'opax junoc q'uen malla nab'a bronce, tz'ochpax junjun argolla bronce d'a junjun yesquinail q'ueen. ");
INSERT INTO cac_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Tz'elc'och q'uen yesquinail chi' d'a spatictac jun altar chi' d'a yalan̈ jun oyanoch d'a stitac. A q'uen malla chi', d'a snan̈al jun altar chi' sb'ojiem q'ueen. ");
INSERT INTO cac_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Sb'opax juntzan̈oc sb'achlab'il jun altar chi'. A te' acacia tz'ochi, tz'ochpax bronce d'a spatic te'. ");
INSERT INTO cac_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","A te' sb'achlab'il chi', yovalil tz'ec' te' d'a yol q'uen argolla ayoch d'a schab'il pac'an̈ yic vach' sb'achjib'ati. ");
INSERT INTO cac_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","A jun altar chi', olan tz'ajcan yool, icha yechel ix in ch'ox d'ayach d'a jolom vitz tic. ");
INSERT INTO cac_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Sb'ochajpax c'apac cortina lino te vach' b'ayb'il, yic tz'och oyan smaculoc yamaq'uil ay d'a spatictac in cajnub' chi'. A d'a jun pac'an̈ d'a stojolal sur, 45 metro tz'ajb'at d'in̈an c'apac cortina chi'. ");
INSERT INTO cac_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Tz'och 20 te' oy, 20 pax sb'achnub'al yich nab'a bronce, axo d'a schon junjun te' oy chi', tz'em jun q'uen nab'a plata ayoch juntzan̈ argolla d'ay. ");
INSERT INTO cac_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Icha pax chi' d'a stojolal norte, yovalil tz'ochpax c'apac cortina d'a sc'atul chi' smasanil. 45 metro tz'aji, 20 pax te' yoyal tz'ochi yed' 20 sb'achnub'al yich nab'a bronce, tz'em jun q'uen nab'a plata, ayoch juntzan̈ argolla d'ay d'a schon junjun te' oy chi'. ");
INSERT INTO cac_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Axo d'a stojolal b'aj tz'em c'u, a c'apac cortina tz'och d'ay, 22 metro yed' nan̈alxo tz'aj sat yed' lajun̈e' yoyal yed' pax lajun̈e' sb'achnub'al yich. ");
INSERT INTO cac_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Axo pax d'a stojolal b'aj sjavi c'u d'a jun amac' chi', 22 metro yed' nan̈alxo sat. Tz'ochpax c'apac cortina d'ay. ");
INSERT INTO cac_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","A d'a jun pac'an̈ sti' amac' chi', ay uque' metro c'apac cortina tz'ochi yed' oxe' yoyal yed' pax oxe' sb'achnub'al yich. ");
INSERT INTO cac_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","An̈eja' d'a junxo pac'an̈ sti', ay pax uque' metro c'apac cortina tz'ochi, ay oxe' oy yed' oxe' sb'achnub'al yich. ");
INSERT INTO cac_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Axo d'a sti' amac' chi', ata' sb'ojioch junoc c'apac cortina nab'a lino b'ayb'il, nan̈al sb'alun̈il metro sat c'apac. Sb'oji yelvanub' c'apac yuj junoc jelan sb'oani. A d'a an̈ q'uic'mutz'inac ch'al, an̈ ch'al yaxmaquinac, an̈ chac ch'al sb'ochaj yelvanub' chi'. ");
INSERT INTO cac_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Masanil te' oy d'a spatic yichan̈ amac' chi', tz'em q'uen q'ueen nab'a plata ayoch argolla d'ay d'a schon te'. Axo pax sb'achnub'al yich te', nab'a bronce. ");
INSERT INTO cac_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","A jun amac' chi', 45 metro sc'atul, 22 metro yed' nan̈alxo sat, lajann̈ej schapac'an̈il. Axo pax c'apac cortina ayq'ue d'a chaan̈, chab' metro yed' 25 centímetro steel c'apac. A c'apac cortina chi', aton lino vach' b'ayb'il. Axo sb'achnub' yich te oy chi', nab'a bronce. ");
INSERT INTO cac_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Masanil yestacail in cajnub' chi' yed' estaca ayoch d'a amac' chi', nab'a bronce tz'aji. ");
INSERT INTO cac_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Al d'a eb' etisraelal to syic'cot aceite eb', aton aceite vach' tz'el d'a sat te' olivo, yic vach' ayn̈ej yaceiteal juntzan̈ candil. ");
INSERT INTO cac_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","A vin̈aj Aarón yed' eb' yuninal ayoch d'a yib'an̈ sb'oanoch sc'ac'al candil chi', yic vach' copanel sc'ac'al d'a vichan̈ tz'ec' ac'val d'a yol mantiado b'aj tzin ch'ox in b'a d'a yichan̈elta c'apac cortina ayoch yen̈uloc te' scaxail in trato. A jun tic, juneln̈ej ley tz'ajcan d'a e cal a ex israel ex tic yed' pax d'a eb' eyin̈tilal. ");
INSERT INTO cac_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ix yalanpax Jehová icha tic: Avtej vin̈ uc'tac aj Aarón yed' eb' yuninal, aton vin̈aj Nadab, vin̈aj Abiú, vin̈aj Eleazar yed' vin̈aj Itamar. Tza siq'uel eb' vin̈ d'a scal eb' etisraelal, yic vach' tz'och eb' vin̈ sacerdoteal d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Sb'ochaj spichul vin̈ uc'tac aj Aarón. Aton junoc pichul yicn̈ej yopisio vin̈ yaji, yic vach' tz'aj yilji vin̈, yic scheclajpaxeli to nivan yelc'och vin̈. ");
INSERT INTO cac_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Al d'a eb' te ay sjelanil, aton juntzan̈ eb' ix vac' sjelanil d'a b'o'oj c'apac, yic sb'oan spichul vin̈aj Aarón chi' eb', yic ol och vin̈ sacerdoteal d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","A juntzan̈ pichul sb'o chi', aton juntzan̈ tic: A c'apac smacul sn̈i' sc'ool yed' c'apac chaleca. Sb'opax jun pichul jucan yed' junxo pichul yelxo val te jucan ol och d'a yool, tz'och yelvanub'. Sb'opax sc'oxal sjolom sb'ac'chajochi yed' stzec'ul snan̈al. Yuj chi', b'ochajocab' pichul to yicn̈ej yopisio vin̈aj Aarón chi'. Sb'ochajpax spichul eb' yuninal vin̈ chi', yic vach' tz'och eb' d'a yopisio d'a sacerdoteal d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ayic sb'ochaj juntzan̈ pichul chi', tz'och an̈ lino b'ayb'il, yovalil tz'och q'uen oro icha ch'al d'a scal yed' lana chac ch'al. ");
INSERT INTO cac_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","A jun chaleca chi', a an̈ lino b'ayb'il sb'ochaj yuj junoc jelan sch'alvi, tz'och oro icha ch'al d'a scal yed' lana ch'al q'uic'mutz'inac, yaxmaquinac yed' chacchac. ");
INSERT INTO cac_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Tz'ec' b'ac'an sc'ab' d'a sjolom sjen̈jab' yic syil-laj sb'a c'apac yichan̈ yed' c'apac spatic. ");
INSERT INTO cac_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Sb'opax jun stzec'ul yic stzec'jioch jun chaleca chi', junn̈ej tz'aj yed'oc. A jun stzec'ul chi', a an̈ lino b'ayb'il b'aj sb'oji. Tz'och q'uen oro icha ch'al d'a scal yed' lana ch'al q'uic'mutz'inac, yaxmaquinac yed' chacchac. ");
INSERT INTO cac_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Tzac' b'o chab'oc cotac pachan̈ q'uen cornalina te vach'. A d'a q'uen tz'och sb'i eb' yuninal vin̈aj Israel. ");
INSERT INTO cac_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Stzolal tz'aj yochi icha ix aj yalji eb', vaque' tz'och d'a junjun q'ueen. ");
INSERT INTO cac_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","A mach tz'ac'anoch juntzan̈ b'i chi' d'a q'ueen, aton junoc toxonton smunlaj d'a b'o'oj q'ueen, te vach' tz'aj sb'oi. Icha yajoch sletrail junoc sello, icha val chi' tz'ajoch b'i chi' d'a q'ueen. ");
INSERT INTO cac_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","A d'a c'apac sjolom sjen̈jab' jun chaleca chi' tz'ac'jioch q'ueen. A yopisio juntzan̈ q'uen chi' yic snachajcot eb' yin̈tilal Israel. Icha chi' tz'aj yic'anec' sb'i eb' israel chi' vin̈aj Aarón d'a sjolom sjen̈jab' ayic tz'ochc'och vin̈ d'a vichan̈ yic tzin naancot eb'. ");
INSERT INTO cac_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Sb'ochajpax chab' syamlab'il q'uen chi', nab'a oro tz'och d'ay. ");
INSERT INTO cac_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Sb'ochajpax chab' cadena nab'a oro c'otzotzi tz'aj spach'uch'aji, tz'och d'a juntzan̈ syamlab'il chi'. ");
INSERT INTO cac_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Axo c'apac yic sn̈i' sc'ool, tz'och yopisio yic snachajel tas in gana, lajan val tzutej icha val tz'aj sb'o chaleca chi'. A an̈ lino b'ayb'il tz'och d'ay, aton an̈ b'ob'il yuj junoc jelan sch'alvi. Tz'och q'uen oro icha ch'al d'a scal yed' lana ch'al q'uic'mutz'inac, yaxmaquinac yed' chacchac. ");
INSERT INTO cac_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Cha pacan̈ tz'aji, lajann̈ej sat stitac schan̈il, 22 centímetro junjun stitac chi'. ");
INSERT INTO cac_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Tz'och q'uen q'ueen te' vach' yilji d'a c'apac sn̈i' sc'ool chi', chan̈ tzol tz'ajoch q'ueen. A d'a b'ab'el tzol, tz'och junoc q'uen rubí, junoc q'uen crisólito yed' junoc q'uen esmeralda. ");
INSERT INTO cac_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Axo d'a schab'il tzol, tz'och junoc q'uen granate, junoc q'uen zafiro yed' junoc q'uen jade. ");
INSERT INTO cac_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Axo pax d'a yoxil tzol, tz'och junoc q'uen jacinto, junoc q'uen ágata yed' junoc q'uen amatista. ");
INSERT INTO cac_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Axo pax d'a schan̈il tzol, tz'och junoc q'uen topacio, junoc q'uen cornalina yed' pax junoc q'uen jaspe. Masanil juntzan̈ q'ueen chi', oron̈ej syamlab'il tz'ochi. ");
INSERT INTO cac_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Yovalil lajchave' juntzan̈ q'ueen chi' sb'oi, yujto lajchave' sb'i eb' yin̈tilal Israel. A d'a junjun q'uen q'ueen chi', ata' tz'och sb'i junjun macan̈ eb', icha yajoch sletrail junoc sello, icha val chi' tz'aj yoch b'i chi' d'a q'ueen. ");
INSERT INTO cac_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","A juntzan̈ q'uen cadena oro pach'uch'ab'il toxo ix b'inaji, aton q'uen tz'och yopisio d'a c'apac sn̈i' sc'ool. ");
INSERT INTO cac_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Sb'ochajpax chab' argolla nab'a oro, tz'och d'a chab' schiquin c'apac sn̈i' sc'ol chi' d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Tz'och q'uen cadena oro chi' schab'il d'a chab' argolla chi'. ");
INSERT INTO cac_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Tz'och chab' sn̈i' q'uen cadena chi' d'a q'uen syamlab'il q'uen q'ueen ayoch d'a sjolom sjen̈jab' c'apac chaleca, yic scan c'apac sn̈i' sc'ol chi' d'a yichan̈. ");
INSERT INTO cac_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Sb'opax chab' argolla nab'a oro, tz'och d'a chab' schiquin c'apac smacul sn̈i' sc'ol chi' d'a yalan̈, junn̈ej scan yed' jun chaleca chi'. ");
INSERT INTO cac_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Sb'ochajpax chab' argolla oro, tz'och d'a sn̈itac c'apac tz'ec' d'a sjolom sjen̈jab' c'apac chaleca d'a yichan̈. Junn̈ej scan q'uen yed' b'aj tz'emc'och stz'isul sti' c'apac chi', palta d'a yib'an̈q'ueta b'aj tz'ec' stzec'ul snan̈al c'apac chaleca, aton jun tzec'ul te vach' yilji. ");
INSERT INTO cac_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Icha chi' schalan sb'a q'uen argolla yic c'apac sn̈i' sc'ool yed' q'uen yic c'apac chaleca chi'. A junoc an̈ ch'al pach'uch'ab'il q'uic'mutz'inac tz'och sch'an̈aloc yic syam sb'a, yic vach' a c'apac sn̈i' sc'ol chi' scan d'a yib'an̈q'ueta stzec'ul snan̈al c'apac chaleca chi', yic max yactej sb'a c'apac. ");
INSERT INTO cac_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Yuj chi', ayic tz'och vin̈aj Aarón chi' d'a yol in cajnub' d'a vichan̈ yed'nac sb'i eb' yin̈tilal Israel vin̈, yic tzin nacot eb' d'a masanil tiempo, yujto ayoch sb'i eb' d'a c'apac smacul sn̈i' sc'ool. A yopisio c'apac smacul sn̈i' sc'ol chi', yic tz'ojtacajeli tas snib'ej in c'ool. ");
INSERT INTO cac_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Tzac'paxoch q'uen Urim yed' q'uen Tumim d'a yol c'apac smacul sn̈i' sc'ol chi', yuj chi' yed'nac q'ueen vin̈aj Aarón d'a sn̈i' sc'ool ayic tz'och vin̈ d'a vichan̈. Icha chi' tz'aj yic'anb'at juntzan̈ chi' vin̈ d'a vichan̈, yic syal snachajeli tas snib'ej in c'ool sc'ulej eb' etchon̈ab'. ");
INSERT INTO cac_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","A junoc c'apac pichul jucan q'uic'mutz'inac, a tzac' b'ojoc, yic ol yac'och vin̈aj Aarón chi' d'a yol c'apac chaleca. ");
INSERT INTO cac_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Scan yolanil d'a snan̈al b'aj sq'ue sjolom vin̈. A d'a stitac b'aj tz'olji sjaj c'apac chi', ata' tz'och junoc c'apac stz'uliloc sti', yic vach' max n̈ic'chaji. ");
INSERT INTO cac_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","A jun c'apac pichul jucan q'uic'mutz'inac chi', tz'och yelvanub' c'apac d'a masanil stitac d'a yoctac. Icha sat te' granado yilji yelvanub' c'apac stitac tz'och chi'. Sb'oji yelvanub' c'apac chi' d'a lana ch'al q'uic'mutz'inac yed' lana ch'al yaxmaquinac yed' pax lana ch'al chacchac. Tz'ochpax yunetac campana nab'a oro d'a scal yechel sat te' granado d'a smasanil stitac chi'. ");
INSERT INTO cac_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ayic tz'och vin̈aj Aarón d'a vichan̈ d'a in cajnub', yovalil ayoch jun c'apac chi' yuj vin̈ yic sc'an̈ juntzan̈ yunetac campana ayoch d'a stitac c'apac chi', ayic tz'och vin̈ yed' pax yic tz'elta vin̈, yic vach' max cham vin̈. ");
INSERT INTO cac_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Tzac'an b'ojoc junoc q'uen oro jaylechinac yelvanub'oc, tz'och juntzan̈ lolonel tic d'a q'ueen, icha junoc sello: Yicn̈ej Jehová Yaji, xchi. ");
INSERT INTO cac_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Tz'och jun q'uen oro jaylechinac chi' d'a snan̈al sat sc'ox vin̈aj Aarón chi', stzec'chajoch q'uen yed' junoc ch'al b'ayb'il q'uic'mutz'inac. ");
INSERT INTO cac_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Yed'nacocab'n̈ej q'uen vin̈aj Aarón d'a snan̈al sat yic tzin cha yofrenda eb' etchon̈ab' syac' d'ayin a in Jehová in tic, vach'chom man̈ ichaoc d'a smojal syutej eb' yac'ani, palta yuj jun q'ueen chi', tzin cha yofrenda eb' chi'. ");
INSERT INTO cac_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Tzac' b'ojoc junocxo c'apac pichul yelxo val te jucan. A lino vach' tz'och d'ay, lino pax junoc c'ox b'ayb'il sb'oi. An̈eja' c'apac tzec'ul, vach' tz'aj yochpax stz'ib'ul c'apac yuj junoc jelan stz'isani. ");
INSERT INTO cac_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Tzac'pax b'ojoc spichul eb' yuninal vin̈aj Aarón chi', aton sjucan pichul eb', stzec'ul eb' yed' sc'ox eb'. Yic vach' yilji eb', yic nivan pax yelc'och eb'. ");
INSERT INTO cac_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Icha chi' tzutej ac'anoch spichul vin̈ uc'tac aj Aarón chi' yed' eb' yuninal. Slajvi chi' tzac'anq'ue aceite d'a sjolom eb', yic tz'ochcan yopisio eb' d'a sacerdoteal d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Tzac'anpax b'ojoc yol svex eb', tz'emc'och d'a xub' eb', sq'uepaxc'och d'a snan̈al eb', yic vach' tz'aj smuschaj snivanil eb'. Lino c'apac tz'och d'a yol svex eb' chi' ");
INSERT INTO cac_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Syac'och c'apac yolvex chi' vin̈aj Aarón chi' yed' eb' yuninal ayic tz'och eb' d'a yol mantiado b'aj tzin ch'ox in b'a, ma ayic tz'och eb' d'a slac'anil altar d'a yol mantiado chi' ayic ayoch eb' d'a yopisio, yic vach' max och smul eb' yic max cham eb'. A jun tic, ley tz'ajcan d'a vin̈aj Aarón yed' d'a yin̈tilal d'a masanil tiempo. ");
INSERT INTO cac_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ix yalanxi Jehová: Ayic schaanel yich yopisio vin̈aj Aarón yed' eb' yuninal d'a sacerdoteal d'ayin, aton juntzan̈ tic tza b'o yuj eb': Tzic'cot junoc noc' quelem vacax yed' chavan̈oc noc' ch'ac calnel malaj jab'oc spaltail. ");
INSERT INTO cac_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Yed' ixim harina yic trigo te vach', malaj yich sb'at d'a scal, aton d'a ixim tzac' b'ojoc ixim pan yed' c'oxox pan calab'il yed' aceite yed' pax c'oxox pan jay sb'on̈chajoch aceite d'ay. ");
INSERT INTO cac_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Slajvi chi' tz'em ixim d'a yol junoc yune' mooch, tzic'anb'at d'a in cajnub' yed' noc' quelem vacax yed' pax chavan̈ noc' ch'ac calnel chi'. ");
INSERT INTO cac_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Slajvi chi', tzic'anb'at vin̈aj Aarón yed' eb' yuninal d'a yichan̈ mantiado b'aj tzin ch'ox in b'a. Ata' sb'iquel sb'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Slajvi chi', tzic'anpaxb'at c'apac pichul yic sacerdoteal. Tzac'anoch c'apac d'a vin̈aj Aarón chi', aton c'apac pichul yelxo val te jucan yed' junxo c'apac jucan, c'apac chaleca yed' c'apac smacul sn̈i' sc'ool, tzac'anoch stzec'ul snan̈al jun chaleca chi'. ");
INSERT INTO cac_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Slajvi chi', tza b'ac'anoch sc'ox vin̈ d'a sjolom. A d'a snan̈al sat sc'ox vin̈ chi' tzac'och jun oro jay lechinac, aton sch'oxan yechel to vic yaj vin̈. ");
INSERT INTO cac_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Slajvi chi' tzic'ancot aceite sc'anchaji ayic sic'chajel junoc mach tz'ochcan vicoc. Tzac'anq'ue d'a sjolom vin̈aj Aarón chi' yic tz'ochcan vin̈ sacerdoteal. ");
INSERT INTO cac_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Slajvi chi', sjapax eb' yuninal vin̈ chi' d'a a tz'ey, tzac'anoch spichul eb' jucan. ");
INSERT INTO cac_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Tza b'oanoch stzec'ul vin̈aj Aarón yed' eb' yuninal, tza b'oanq'ue sc'ox eb'. Ichaton chi' tz'aj yochcan yopisio eb' d'a masanil tiempo. ");
INSERT INTO cac_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Slajvi chi', tzic'anb'at noc' quelem vacax d'a yichan̈ mantiado b'aj tzin ch'ox in b'a, yic vach' syac'q'ue sc'ab' vin̈aj Aarón yed' eb' yuninal d'a sjolom noc'. ");
INSERT INTO cac_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","A d'a yichan̈ mantiado chi' tza milcham noc' d'a vichan̈. ");
INSERT INTO cac_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Tzic'anq'ueta jab'oc schiq'uil noc' yed' yiximal a c'ab', tza sucanoch d'a sch'ac altar ayq'ue d'a schiquintac, axo masanil chic' scan chi', tza tob'canec' d'a yichtac altar chi'. ");
INSERT INTO cac_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Axo masanil xepu' ayoch d'a sch'an̈tza' noc' yed' d'a yib'an̈ seyub' noc' yed' pax d'a stut noc', tz'iq'ueli tza n̈usantz'a d'a yib'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Axo noc' chib'ej chi' yed' stz'umal noc', stza' noc', masanil juntzan̈ chi' tza n̈ustz'a d'a spatiquel campamento, yujto a jun noc' chi' silab' yaj yic tz'ac'ji tup mul. ");
INSERT INTO cac_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Slajvi chi', tzic'ancot junoc noc' ch'ac calnel, syac'anq'ue sc'ab' vin̈aj Aarón yed' eb' yuninal chi' d'a sjolom noc'. ");
INSERT INTO cac_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Tza milancham noc', tza tzicanoch schiq'uil noc' d'a schan̈il pac'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Slajvi chi', tza cotac xicanb'at noc', smaxchajel noc' yol sc'ool, noc' yoc, junn̈ej tz'aj yed' noc' cotac xicab'il chi' yed' pax noc' sjolom. ");
INSERT INTO cac_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Tza n̈usantz'a noc' silab'il d'a yib'an̈ altar d'a vichan̈ yuj vic'jichaan̈, aton jun silab' sn̈usjitz'a smasanil, sumumi sjab' svab'i. ");
INSERT INTO cac_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Slajvi chi', tzic'ancot junxo noc' calnel, syac'anq'ue sc'ab' vin̈aj Aarón yed' eb' yuninal d'a sjolom noc', ");
INSERT INTO cac_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","tza milancham noc'. Tzic'anq'ue jab'oc schiq'uil noc', tza sucanec' d'a sjayil schiquin vin̈aj Aarón yed' eb' yuninal. Aton d'a schiquin eb' d'a svach'. Tza sucpaxec' jab'oc d'a smam sc'ab' eb' yed' d'a smam yoc eb' d'a svach'. Slajvi chi' tza tzicancanem masanil schiq'uil noc' ch'ac calnel chi' d'a spatictac altar chi'. ");
INSERT INTO cac_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Axo schiq'uil noc' calnel ayoch d'a yib'an̈ altar chi' tzic'q'ue jab'oc, tza tzicanb'at d'a yib'an̈ vin̈aj Aarón yed' d'a spichul vin̈ yed' d'a yib'an̈ eb' yuninal vin̈ yed' pax d'a spatictac spichul eb'. Icha pax chi' tz'utaj aceite sc'anchaji yic sic'chaj junoc mach tz'ochcan vicoc. Icha val chi' tz'aj sic'chajcanel vin̈aj Aarón yed' eb' yuninal yed' spichul eb'. ");
INSERT INTO cac_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Slajvi chi', tzic'anel xepu' ayoch d'a sn̈e noc' ch'ac calnel chi', d'a noc' sch'an̈tza' yed' d'a yib'an̈ seyub' noc', tzic'anpaxcot chab' noc' stut yed' pax xepu' ayoch d'ay yed' pax noc' sb'ac'chil xub' d'a svach' yujto a jun noc' ch'ac calnel chi', aton noc' sc'anchaji yic tz'ochcan eb' sacerdote d'a yopisio. ");
INSERT INTO cac_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Tzic'anpaxq'ueta ixim pan malaj yich, aton ixim ayem d'a yol mooch d'a vichan̈, junoc ixim pan setan setan yaji, junoc ixim calab'il yed' aceite yed' junoc ixim c'oxox. ");
INSERT INTO cac_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Masanil juntzan̈ chi' tzac'och d'a yol sc'ab' vin̈aj Aarón yed' d'a eb' yuninal, sb'achchajoch d'a vichan̈. ");
INSERT INTO cac_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Slajvi chi', tzic'anec' d'a yol sc'ab' eb', tza n̈usantz'a d'a yib'an̈ altar chi'. Junn̈ej tz'aj stz'a yed' noc' ch'ac calnel van stz'a silab'il, sumumi sjab' svab'i. Sn̈usjitz'a jun ofrenda chi' yuj vic'jichaan̈. ");
INSERT INTO cac_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","A noc' ch'ac calnel sc'anchaji ayic tz'och vin̈aj Aarón d'a yopisio, tzic'canel sn̈i' sc'ol noc'. Tza b'achanq'ue d'a vichan̈ a in Jehová in tic, yujto ic tz'ajcan jun macan̈ noc' chib'ej chi'. ");
INSERT INTO cac_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Tza pojanel noc' sn̈i' sc'ol yed' noc' xub' ix a b'achq'ue d'a vichan̈, aton yic noc' ix och yopisio ayic ix ochcan vin̈aj Aarón yed' eb' yuninal d'a sacerdoteal. ");
INSERT INTO cac_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","A chab' macan̈ noc' chib'ej chi', yic vin̈aj Aarón yed' eb' yuninal tz'ajcani, aton ofrenda syac' eb' eyetisraelal. Aton chab' macan̈ noc' chi' syac' eb' d'ayin yofrendaoc yic junc'olal. ");
INSERT INTO cac_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","30","A spichul vin̈aj Aarón syac'och d'a yopisio, scann̈ej d'a eb' yin̈tilal vin̈. A junoc yin̈tilal vin̈ scan d'a yopisio, ayic tz'och d'a yol mantiado b'aj tzin ch'ox in b'a, yuj in yac'an servil d'a yol jun lugar A Inn̈ej Ay Vico', an̈ej juntzan̈ pichul chi' syac'och eb' d'a uque' c'ual ayic tz'ochcan eb' sacerdoteal. ");
INSERT INTO cac_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Tzic'anpaxb'at noc' calnel ix b'inaji yic tz'ochcan yopisio eb'. A d'a jun lugar sic'b'ilpaxeli, ata' tza tz'an̈ noc'. ");
INSERT INTO cac_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","A vin̈aj Aarón yed' eb' yuninal schi'an noc' chib'ej chi', svaanpax juntzan̈ ixim pan ayem d'a yol jun yune' mooch chi' d'a yichan̈ mantiado b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Aton eb' schi'an noc' ix ac'ji yic tz'ac'ji tup schucal eb', aton yic ix sic'chajel eb' yed' schaancan yopisio eb' d'a sacerdoteal, palta malaj junoc ch'oc animail syal schi'an juntzan̈ chi', yujto vic yaji. ");
INSERT INTO cac_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Tato ayto noc' chib'ej chi' yed' ixim pan chi' scan d'a jun c'u chi', tza n̈uscantz'aoc. Malaj junocxo mach syal schi'ani ma svaani, yujto vic yaji. ");
INSERT INTO cac_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Masanil juntzan̈ tic tza b'o d'a vin̈aj Aarón yed' d'a eb' yuninal icha val tz'aj valan d'ayach tic. Uque' c'ual syic' yuj ac'ancanoch yopisio eb' chi'. ");
INSERT INTO cac_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Junjun noc' quelem vacax tzac' silab'il d'a junjun c'u, yic tz'ac'ji lajvoc smul eb'. Icha chi' tz'aj a sacb'itan altar d'a vichan̈, tza sucanpaxoch aceite d'a yib'an̈ yic tz'ochcan yopisio. ");
INSERT INTO cac_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Uque' c'ual tzac' silab' d'a yib'an̈ altar chi', yic tz'ac'ji lajvoc mul. Icha val chi' tz'aj yochcan jun altar chi' vicoc, tz'och d'a yopisio. Yaln̈ej tastac tz'och tennaj d'a jun altar chi', vicxo tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Junjun c'u yovalil sn̈usji chavan̈ noc' calnel jun ab'il sq'uinal silab'il d'a yib'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Jun noc' tza n̈ustz'a d'a q'uin̈ib'alil, junxo noc' tza n̈ustz'a d'a yemc'ualil. ");
INSERT INTO cac_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Tzac' chan̈eoc libra harina te vach' yed' noc' stz'a d'a q'uin̈ib'alil chi', tza calej ixim harina chi' yed' junoc litro aceite yic sat te' olivo, tza secanem junoc litro vino ofrendail. ");
INSERT INTO cac_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","An̈eja' icha chi' tzutejpax junxo noc' calnel chi' d'a yemc'ualil, ixim harina yed' vino ofrendail. A juntzan̈ ofrenda sn̈usjitz'a chi', te sumumi sjab' svab'i. ");
INSERT INTO cac_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","A juntzan̈ silab' chi', ol sn̈usn̈ejtz'a eb' d'a vichan̈ d'a masanil tiempo d'a stojolal sti' mantiado b'aj tzin ch'ox in b'a, ayic tzin lolon eyed'oc. ");
INSERT INTO cac_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ata' ol in ch'ox in b'a d'a eb' etisraelal, yuj chi' vic ol ajcan jun mantiado chi', yuj in tziquiquial. ");
INSERT INTO cac_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","A in val tzin sic'canoch jun mantiado chi' vicoc yed' yaltaril. Tzin sic'paxcanel vin̈aj Aarón yed' eb' yuninal chi' yic tz'ochcan eb' sacerdoteal d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ol in cajnaj d'a scal eb' etisraelal, yujto e Diosal in. ");
INSERT INTO cac_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Icha val chi' ol aj snachajel yuj eb' to a in ton Jehová in sDiosal in eb' ed'oc, a in ix ex viq'uelta d'a Egipto yic tzin cajnaj d'a e cal, a in Jehová e Diosal in tic, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Ix yalanxi Jehová: Ac' b'ojoc junoc altar b'aj stz'a incienso. A te' acacia tz'och d'ay. ");
INSERT INTO cac_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","A sc'atul 45 centímetro tz'aji, 45 centímetro tz'ajpax sat, axo steel, 90 centímetro tz'aji. An̈eja' sb'oq'ue sch'ac altar chi' d'a junjun schiquintac, yaman tz'aj yed' altar chi'. ");
INSERT INTO cac_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Tz'och q'uen oro yelxo val vach' d'a altar chi': D'a yib'an̈ yed' d'a spatictac schan̈il pac'an̈ yed' d'a sch'aac chi', sq'uepax tzalan q'uen oro chi' d'a yib'an̈ stitac. ");
INSERT INTO cac_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","A d'a yalan̈ stitac chi', ata' tz'och chab'chab'oc argolla nab'a oro d'a schab'il pac'an̈. A d'a yool chi' tz'ec' te' sb'achlab'il yic syal sb'achchaji. ");
INSERT INTO cac_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","A te' b'achlab' chi', a te' acacia tz'ochi, tz'och q'uen oro d'a spatic te'. ");
INSERT INTO cac_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Tzaq'uem jun altar chi' d'a yichan̈elta c'apac cortina ayoch yen̈uloc scaxail in trato, aton te' caxa ay smacul b'aj tz'ac'ji tup mul. Ata' ol in ch'ox in b'a d'ayex. ");
INSERT INTO cac_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","A vin̈aj Aarón ol n̈usantz'a incienso sumumi sjab' d'a yib'an̈ altar chi', junjun q'uin̈ib'alil ayic sb'ochajoch candil. ");
INSERT INTO cac_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Sn̈usanpax vin̈ a tz'emxican c'u, aton d'a yorail yoch sc'ac'al candil. A jun tic ol ujocn̈ej d'a vichan̈ ayic ol b'eyn̈ejb'at tiempo. ");
INSERT INTO cac_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Malaj junoc comon incienso ol n̈usjoctz'a d'a yib'an̈ jun altar chi', malaj pax junoc silab', ofrenda d'a ixim trigo, ma ofrenda d'a yic secchajem vino ol sn̈uschaj d'ay. ");
INSERT INTO cac_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","An̈ej junel d'a yol ab'il stzicoch chic' vin̈aj Aarón d'a sch'ac altar chi', aton schiq'uil noc' silab' smiljicham yuj yac'ji lajvoc mul. Junjun ab'il tzuji jun tic d'a masanil tiempo. A jun altar chi', vic yaji, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Ayic ol ic'anchaan̈ sb'isul eb' etchon̈ab' israel chi', junjun eb' ol stup d'ayin yuj sq'uinal, yic malaj junoc ilya te ov ol javoc d'a yib'an̈ eb' to scham eb' yuuj, yuj b'aj sb'ischaj chi'. ");
INSERT INTO cac_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Masanil eb' stz'ib'chaj chi', yovalil nan̈al siclo q'uen plata syac' eb' yic stupan eb' d'ayin, icha q'uen siclo sc'anchaj d'a in cajnub', aton 20 gera. ");
INSERT INTO cac_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Masanil eb' stz'ib'chaj sb'i chi', aton eb' 20 ab'il sq'uinal sb'eyn̈ejb'ati, aton eb' chi' tz'ac'an jun b'aj stupchaj chi' d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ayic stupan eb' chi' d'ayin yuj sq'uinal, vach'chom eb' b'eyum, ma eb' meb'a' lajann̈ej tz'aj yac'an eb'. Nan̈al siclo syac' junjun eb'. ");
INSERT INTO cac_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ichato chi' smolchaj masanil q'uen plata syac' eb' anima chi' stojoloc yuj sq'uinal. A d'a mantiado b'aj tzin ch'ox in b'a tz'och yopisio q'ueen. A yuj chi', ol ex in nacoti, aton yuj tas tzeyac' yuj e q'uinal chi', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","19","Ac' b'ojoc junoc q'uen nivan palangana yed' sb'achnub' yich, nab'a bronce tz'aji. A d'a scal snan̈al altar yed' mantiado b'aj tzin ch'ox in b'a scan q'ueen. Sb'ud'chaj q'uen yed' a a'. Ata' syic'q'ueta a' vin̈aj Aarón yed' eb' yuninal yic sb'ican sc'ab' eb' yed' yoc. ");
INSERT INTO cac_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ayic tz'och eb' d'a yol mantiado, ma ayic sc'och eb' d'a altar yic sn̈usan yofrenda d'a vichan̈, yovalil sb'ic sc'ab' eb' yed' yoc, yic max cham eb'. ");
INSERT INTO cac_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","A jun tic, ley tz'ajcan d'a yib'an̈ vin̈aj Aarón yed' yin̈tilal, ayic ol b'eyn̈ejb'at tiempo, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Sic'chajocab'el juntzan̈oc avb'en te' man̈xo jantacoc svach'il sjab': Lajchaveoc libra stzatajil te' mirra te vach', vaqueoc libra canela, vaqueoc libra te' cálamo yelxo val vach', ");
INSERT INTO cac_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","25","yed' pax lajchaveoc libra te' casia. A echlab' sc'anchaj d'a juntzan̈ chi', aton icha echlab' sc'anchaj d'a in cajnub'. Scalaj juntzan̈ chi' yed' nan̈aloc schan̈il litro aceite yic te' olivo, icha val tz'aj sb'oan junoc b'oum perfume. Icha chi' tz'aj a b'oan aceite sc'anchaji a sic'chajel junoc mach ma junoc tas to vic tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Succhajoch aceite chi' d'a mantiado b'aj tzin ch'ox in b'a, d'a te' caxa yic trato, ");
INSERT INTO cac_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","d'a te' mexa yed' d'a syamc'ab'il d'a sb'achnub' candil yed' syamc'ab'il, d'a altar yic incienso, ");
INSERT INTO cac_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","d'a altar b'aj stz'a silab' yed' syamc'ab'il yed' pax d'a jun q'uen nivan palangana yed' sb'achnub'al. ");
INSERT INTO cac_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Icha chi' tz'aj a sic'ancanoch masanil juntzan̈ chi' yic vach' vic tz'ajcani. Masanil tastac tz'och tennaj d'ay, vicxo tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","A jun aceite chi' tza sucpaxoch d'a vin̈aj Aarón yed' pax d'a eb' yuninal vin̈. Icha chi' tz'aj sic'chajcanoch eb' sacerdoteal d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Tzalan d'a masanil eb' etisraelal: Ayic ol b'eyn̈ejb'at tiempo, aton jun aceite tic ol c'anchaj d'a tastac to vic ol ajcanoc. ");
INSERT INTO cac_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Man̈ comonoc succhajoch d'a junoc comon anima. Man̈ comonoc sb'oji junocxo macan̈ aceite lajan yed' jun tic. A jun tic vic tz'ajcani, yuj chi' man̈ comonoc tze yama'. ");
INSERT INTO cac_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Tato ay junoc mach sb'oan junocxo macan̈ aceite lajan yed' jun tic, ma sucoch d'a junoc comon anima, a jun chi' yovalil tz'ic'jicanel d'a scal eb' yetchon̈ab', xchi Jehová, xa chi d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: Ic'chajocab'cot masanil juntzan̈ tastac chi', lajann̈ej ol aj yechlab'il: Stzatajil te' estacte, sjoxal noc' mic' scuch uña, stzatajil te' gálbano te vach' sjab' yed' pax stzatajil te' incienso yelxo val te vach'. ");
INSERT INTO cac_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","A yed' juntzan̈ chi' tzac' b'ojoc incienso. Vach' tz'aj scalaji, icha val tz'aj sb'oji yuj junoc b'oum perfume. Vach' tz'aj sb'at yatz'amil, malajocab' spaltail, yujto vic yaji. ");
INSERT INTO cac_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Choc' tz'aj stenjipoj jab'oc, tzac'anoch d'a yol mantiado d'a yichan̈ te' scaxail in trato b'aj tzin ch'ox in b'a d'ayex. A jun incienso chi', nivanocab' yelc'och d'a yol e sat. ");
INSERT INTO cac_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Man̈ e b'o junocxo icha val jun ix e b'o tic. Tze nacoti to a inn̈ej ay vico'. ");
INSERT INTO cac_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Tato ay junocxo mach sb'oan d'a yol yico', yic syab' sjab', a jun chi' tojoln̈ej yic'jicanel d'a scal eb' yetchon̈ab', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Ab'i, a d'a scal yin̈tilal vin̈aj Judá ix in sic'canel vin̈aj Bezaleel, yuninal vin̈aj Uri, yixchiquin vin̈aj Hur. ");
INSERT INTO cac_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Toxo ix vac'och Vespíritu d'a vin̈, yic jelan snaanel vin̈, yic ol yal sb'oanq'ue yaln̈ej tastac vin̈. ");
INSERT INTO cac_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ol snaanelta vin̈ sb'oan yechel jantac munlajel ol b'o'oc, icha d'a q'uen oro, d'a q'uen plata yed' d'a q'uen bronce, ");
INSERT INTO cac_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","yed' pax sb'oan q'uen q'ueen vin̈ vach' yilji, sb'oan te te' d'a yaln̈ej tas munlajelal. ");
INSERT INTO cac_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Axo vin̈aj Aholiab, yuninal vin̈aj Ahisamac, yin̈tilal vin̈aj Dan, a vin̈ ol colvaj yed' vin̈aj Bezaleel chi'. Masanil eb' aytaxon sjelanil, ix in vach' aq'uej sjelanil eb' yic a eb' ol b'oan masanil tastac sval tic d'ayach: ");
INSERT INTO cac_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Aton c'apac mantiado b'aj tzin ch'ox in b'a, te' scaxail in trato yed' smacul b'aj tz'ac'ji tup mul, masanil syamc'ab'il d'a yol mantiado chi', ");
INSERT INTO cac_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","te' mexa yed' jantac syamc'ab'il, jun sb'achnub' candil nab'a oro yed' syamc'ab'il, jun altar b'aj sn̈uschaj incienso, ");
INSERT INTO cac_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","jun altar b'aj stz'a silab' yed' syamc'ab'il, jun nivan palangana yed' sb'achnub' yich, ");
INSERT INTO cac_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","c'apac pichul jalb'il nivan yelc'ochi, aton spichul vin̈aj sacerdote Aarón yed' pax spichul eb' yuninal vin̈, aton pichul sc'an eb' d'a yopisio. ");
INSERT INTO cac_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Sb'opax aceite eb' sc'anchaji ayic tz'ochcan junoc mach, ma junoc tas vicoc. Sb'opax incienso man̈xo jantacoc svach'il sc'anchaj d'a in cajnub'. A juntzan̈ chi', yovalil sb'o eb' icha val ix aj valan d'ayach, xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ix yalanxi Jehová d'a vin̈aj Moisés chi': ");
INSERT INTO cac_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Al d'a eb' etchon̈ab' to yovalil sc'anab'ajej jun sc'ual ic'oj ip eb', yujto vic yaji. Yujto a jun c'u chi' yechel in trato yajcanoch d'a co cal eyed'oc d'a masanil tiempo yic vach' tzeyojtaquejeli to a in Jehová in tic ix ex in sic'canel vicoc. ");
INSERT INTO cac_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Nivanocab' yelc'och jun sc'ual ic'oj ip chi' d'a yol e sat. A mach max c'anab'ajan jun c'ual ic'oj ip chi', yovalil schami. Yaln̈ej mach smunlaj d'a jun c'u chi', yovalil schami. ");
INSERT INTO cac_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Vaquen̈ej c'ual tzex munlaji, axo d'a yuquil c'ual, sc'ual ic'oj ip, vicn̈ej yaji. Yaln̈ej mach smunlaj d'a jun c'u chi', tojoln̈ej schami. ");
INSERT INTO cac_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","17","Yuj chi', yovalil tze c'anab'ajej jun c'ual ic'oj ip chi'. A jun chi' yechel in trato tz'ajcan d'a masanil tiempo d'a co cal eyed'oc, yujto a in Jehová in d'a vaque' c'ual in b'onac satchaan̈ yed' sat luum tic, axo d'a yuquil c'ual vochnac vaan in munlaji, vic'annac vip, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ayic ix lajvi slolon Jehová yed' vin̈aj Moisés d'a jolom vitz Sinaí, ix yac'an chab' pachan̈ q'ueen d'a vin̈, b'aj tz'ib'ab'iloch strato, to a val Dios ix tz'ib'ani. ");
INSERT INTO cac_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Axo yic ix yilan eb' chon̈ab' israel to a vin̈aj Moisés chi' an̈eja' max emxul-laj vin̈ b'aj ayec' eb' chi', ix smolb'an sb'a eb' smasanil, ix yalan eb' d'a vin̈aj Aarón: —A ticnaic, co gana to tza b'o juntzan̈oc co diosal tzon̈ cuchb'ani, yujto a vin̈aj Moisés, vin̈ ix on̈ ic'anelta d'a Egipto, man̈ cojtacoc tas ix ic'an vin̈, xchi eb' chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ix tac'vi vin̈aj Aarón chi' d'a eb': —A ticnaic, molb'ejeccot masanil q'uen uchiquin nab'a oro yic eb' ix eyetb'eyum yed' yic eb' eyuninal, eb' ix eyisil, tzeyic'ancot d'ayin, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Masanil anima ix yiq'uel yuchiquin, ix yic'ancot eb' d'a vin̈aj Aarón chi'. ");
INSERT INTO cac_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ix schaanec' vin̈, ix yac'an ulax q'uen vin̈ d'a scal te' c'ac', ix yac'anem vin̈ d'a yol jun smoldeal, ix b'o jun yechel jun quelem vacax. Ix ochn̈ej ijan vin̈ svach' b'oan jun yechel vacax chi'. Ix yalan eb' chon̈ab' chi' smasanil: —Ex quetchon̈ab' israel, a jun co diosal tic ix on̈ ic'anelta d'a Egipto, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ayic ix yilan jun chi' vin̈aj Aarón chi', ix sb'oanq'ue jun altar vin̈ d'a yichan̈ jun yechel vacax chi', te chaan̈ ix yal vin̈: —A q'uic'an scac'och junoc nivan q'uin̈ d'a yichan̈ Jehová, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Axo ix q'uin̈ib'i d'a junxo c'u, ix smolb'an sb'a anima smasanil, ix sn̈usan juntzan̈ silab' eb' yed' silab' yic junc'olal. Ix lajvi chi' ix em c'ojjab' eb', ix va eb', ix yuc'an a' eb'. Ix lajvi chi', ix q'ue b'ulnaj eb' schan̈alvi yed' sc'ulan chucal d'a yichan̈ sdiosal chi'. ");
INSERT INTO cac_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Yuj chi', ix yalan Jehová d'a vin̈aj Moisés chi': —Ixic, eman̈xi yujto a eb' a chon̈ab' ix iq'uelta d'a Egipto, toxo ix sjuel sb'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Yelxo val d'a elan̈chamel ix yiq'uel sb'a eb' d'a tas ix vala'. D'a elan̈chamel ix sb'o jun yechel quelem vacax eb', syac'anem sb'a eb' ejmelal d'ay. Syac'an silab' eb', syalan eb': Ex quetchon̈ab' israel, a val jun co diosal tic ix on̈ ic'anelta d'a Egipto, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Toxo ix vila' to a juntzan̈ anima tic, yelxo val pit spensar eb'. ");
INSERT INTO cac_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","A ticnaic man̈xo ach tevoc d'ayin yuj eb', scot val voval d'a juntzan̈ anima tic. Ol in satel eb' smasanil, an̈ej ed'oc ol in b'o jun nivan nación yed' eb' in̈tilal, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Axo vin̈aj Moisés chi', ix och ijan vin̈ sc'anan nivanc'olal d'a Jehová sDiosal yuj eb' schon̈ab', ix yalan vin̈: —Mamin Jehová, ¿tas val yuj scot yoval a c'ol d'a yib'an̈ a chon̈ab' to a ach ix iq'uelta d'a Egipto yed' ipalil? ");
INSERT INTO cac_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","¿Tas val yuj ol a cha ach yal eb' aj Egipto chucal? Ol am yal eb' icha tic: Tob'an chuc spensar Dios d'a eb', yuj chi' ix yiq'uel eb' d'a tic, sb'at smilancham eb' d'a jolomtac vitz, satjiel eb' yuuj d'a sat lum luum tic, xcham eb'. Yuj chi' comonoc max te cot yoval a c'ol d'a yib'an̈ eb', mocab' ac'och yaelal d'a yib'an̈ eb'. ");
INSERT INTO cac_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Comonoc tza nacot eb' a checab', aton vin̈aj Abraham, vin̈aj Isaac yed' vin̈aj Israel. A locnac a b'i ac'annac a ti' d'a eb', alannac icha tic: Ol vic'chaan̈ e b'isul yed' eyuninal. Lajan ol aj sb'isul eb' icha q'uen c'anal d'a satchaan̈. An̈eja' jun lum luum tic, toxo ix vala' to ol vac' d'a eyin̈tilal d'a masanil tiempo, xa chinac d'a eb', xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Yuj chi' ix snaan Jehová to man̈xo ol satel-laj schon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ix meltzajemta vin̈aj Moisés d'a jolom vitz chi', yed'nacxo chab' pachan̈ q'ueen vin̈ b'aj tz'ib'ab'iloch checnab'il yuj Jehová, d'a schab'il pac'an̈ q'ueen. ");
INSERT INTO cac_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","A val Jehová ix b'oan q'uen q'ueen chi' schab'il, ix stz'ib'anoch letra chi' d'a q'ueen. ");
INSERT INTO cac_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Axo yic ix yab'an vin̈aj Josué yel yav eb' anima, ix yalan vin̈ d'a vin̈aj Moisés chi': —A val scab'an yel yav eb' anima chi', icha val to ayoch oval d'a yol campamento, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ix tac'vi vin̈aj Moisés chi': —A juntzan̈ av tz'och scab' chi', man̈ avoc yic tzalajc'olal yic tz'ac'ji ganar junoc oval, man̈ avocpax yic cusc'olal yic tz'ac'ji ganar anima yuj eb' ajc'ool, palta b'it tz'och svab'i, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Axo yic ix javi vin̈aj Moisés chi' d'a slac'anil campamento chi', ix yilanoch jun yechel quelem vacax chi' vin̈, axo eb' anima van schan̈alvi eb'. Ix te cot yoval vin̈, ix syumanel q'uen q'ueen b'aj tz'ib'ab'iloch checnab'il chi' vin̈, yuj chi' ix pojb'at q'uen d'a yich vitz chi'. ");
INSERT INTO cac_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ix lajvi chi', ix b'at stzac'anelta jun yechel vacax chi' vin̈, ix syumanoch vin̈ d'a scal c'ac'. Ix lajvi chi' ix smac'anpoj vin̈, choc'xon̈ej ix aji, ix yac'anem vin̈ d'a scal a a', ix schecan vin̈ yuc' eb' anima chi'. ");
INSERT INTO cac_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ix yalan vin̈ d'a vin̈aj Aarón chi': —¿Tas yuj ach montaj yuj juntzan̈ anima tic ix a cuchb'an eb' sc'ulan jun nivan chucal tic? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ix yalan vin̈aj Aarón chi': —Mamin, mocab' cot oval d'ayin, ojtac val sic'lab'il to a jun chon̈ab' tic, sganan̈ej eb' sc'ulan chucal. ");
INSERT INTO cac_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","A eb' ix alan d'ayin: B'o junoc co diosal tzon̈ cuchb'ani, yujto a vin̈aj Moisés ix on̈ ic'anelta d'a Egipto, ma chequel tas ix ic'an vin̈, max jaxlaj vin̈, xchi eb' d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Yuj chi' ix valan d'a eb': Machtac ex ay q'uen oro d'ayex, ma q'uen uchiquin, iq'uequeli, tzeyic'ancoti, xin chi d'a eb'. Ix lajvi chi', ix yic'ancot eb' d'ayin, ix vac'an ulax d'a cal c'ac', axo ix aji ix comon elta jun yechel vacax tic, xchi vin̈ d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ix nachajel yuj vin̈aj Moisés chi' to a eb' anima chi', b'ecanxon̈ej sc'ol eb' yac'an q'uixvelal sb'a d'a yichan̈ eb' chon̈ab' ayoch ajc'olal d'a eb', axo vin̈aj Aarón chi' maj scachoch vaan jab'oc eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Yuj val chi' ix och tec'tec' vin̈aj Moisés chi' d'a sti' campamento chi', ix yalan vin̈: —A ticnaic a mach syal sc'ol syac'och sb'a d'a yol sc'ab' Jehová, cotocab' d'a in tz'ey tic, xchi vin̈. Masanil eb' yetlevitail vin̈, ix snitzcot sb'a eb' d'a stz'ey vin̈. ");
INSERT INTO cac_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ix lajvi chi', ix yalanpax vin̈ d'a eb': —Ix schec Jehová co Diosal val d'ayex to junjun ex tzeyic'b'at eyespada, tzex b'at d'a campamento, tzex ec' d'a caltac mantiado, tze milancham eb' eyuc'tac, eb' eyamigo yed' eb' cajan d'a e lac'anil, xchi Jehová, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ix sc'anab'ajej checnab'il eb' vin̈ levita ix yac' vin̈. Yuj chi', ay am oxeoc mil anima ix smilcham eb'. ");
INSERT INTO cac_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ix lajvi chi', ix yalanxi vin̈aj Moisés chi': —A ticnaic ix eyac'och e b'a d'a yol sc'ab' Jehová, ina to a ex ix e milcham eyuninal yed' eyuc'tac. Yuj val chi', ol yac' svach'c'olal Jehová d'a eyib'an̈, xchi vin̈ d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Axo d'a junxo c'u, ix yalan vin̈aj Moisés chi' d'a eb' anima: —Te nivan e mul ix ochi. A ticnaic tic tzin b'atxi d'a jolom vitz b'aj ayec' Jehová. Ata' ol in lolon yed'oc, talaj ol yac' lajvoc e mul chi' d'a eyib'an̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ix lajvi chi', ix b'at vin̈ d'a jolom vitz b'aj ayec' Jehová chi'. Ix yalan vin̈: —Val yel Mamin, te nivan smul jun chon̈ab' tic ix och d'a ichan̈, ix sb'o jun sdiosal eb' oro yic syaq'uem sb'a eb' d'ay. ");
INSERT INTO cac_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Yuj val chi' tzin tevi d'ayach to tzac' lajvoc smul eb' chi'. Tato max ac' nivanc'olal smul eb' chi' jun, tza sucsat in b'i d'a yol ch'an̈ libro b'aj tz'ib'ab'il sb'i eb' to icxo yaji, xchi vin̈ d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Axo ix tac'vi Jehová chi' d'a vin̈: —A eb' tz'och smul d'ayin, aton eb' chi' tzin sucsat sb'i d'a yol ch'an̈ libro chi'. ");
INSERT INTO cac_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Yuj chi' ixic, tzic'anb'at eb' chon̈ab' chi' d'a jun lugar ix val d'ayach. A jun vángel ol b'ab'laj eyuuj, palta ol c'och sc'ual yic ol vac'anoch syaelal eb' anima tic yuj smul, xchi. ");
INSERT INTO cac_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ix lajvi chi', a Jehová ix ac'ancot jun nivan ilya to smilvaj d'a yib'an̈ eb' chon̈ab' israel chi', yujto ix yac'och sb'a eb' sb'oan jun yechel vacax, aton jun ix sb'o vin̈aj Aarón chi'. ");
INSERT INTO cac_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi': —A ticnaic elan̈ d'a tic yed' eb' chon̈ab' ix iq'uelta d'a Egipto, tzic'anb'at eb' d'a sat lum luum valnac d'a vin̈aj Abraham, d'a vin̈aj Isaac yed' d'a vin̈aj Jacob to ol vac' d'a yin̈tilal eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","A in ol in chec b'ab'laj jun vángel d'a eyichan̈. A' ol ex cuchb'anb'atoc. A juntzan̈ chon̈ab'il anima, aton eb' cananeo, eb' amorreo, eb' hitita, eb' ferezeo, eb' heveo yed' eb' jebuseo, ol viq'uel eb' d'a sat luum chi'. ");
INSERT INTO cac_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ixiquec d'a jun lum te yax sat chi', palta man̈ ol in b'atlaj d'a e cal, yujto te pit ex, ay smay tzex in satel d'a yoltac b'e, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ayic ix yab'an eb' anima jun lolonel cuseltac yalji chi', ix och eb' d'a ilc'olal, man̈xalaj mach ix yac'och yuchiquin yed' ston̈. ");
INSERT INTO cac_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yujto a Jehová ix alan d'a vin̈aj Moisés chi': —Al d'a eb' etisraelal tic: A ex tic te pit ex. Tato tzin c'och d'a e cal junoc rato, ay smay tzex in sateli. A ticnaic iq'uequel eyuchiquin chi' yed' e ton̈ d'a e jaj chi', ol vilani tas ol ex vutoc, xa chi, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Yuj val chi', atax ix el eb' d'a yich vitz Horeb, man̈xo junoc eb' ix yac'och ston̈ yed' yuchiquin. ");
INSERT INTO cac_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ix yac' b'ochajq'ue jun mantiado vin̈aj Moisés d'a stib'at campamento. Ix yac'an vin̈ scuch jun mantiado chi': D'a B'aj Sch'ox Sb'a Jehová. Tato ay junoc mach sb'at sc'anb'ej junoc tas d'a Jehová, yovalil sb'at d'a jun mantiado chi'. ");
INSERT INTO cac_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ayic sb'at vin̈aj Moisés d'a mantiado chi', tz'elta lin̈an eb' anima smasanil d'a stitac smantiado, sb'at q'uelan eb' d'a vin̈ masanto tz'ochcan vin̈ d'a yol mantiado chi'. ");
INSERT INTO cac_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ayic tz'och vin̈, tz'emul moynaj jun asun d'a sti' mantiado chi' yacb'an slolon Jehová yed' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","A syilan eb' anima chi' yemul moynaj jun asun chi', tz'em n̈ojan eb' smasanil ejmelal d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Q'uelc'umb'a val tz'aj Jehová slolon yed' vin̈aj Moisés chi', icha val tz'aj co lolon yed' junoc co vach'c'ool. Slajvi slolon vin̈ yed' Jehová chi', sjax vin̈ d'a campamento. Palta axo vin̈ scolvaj yed' vin̈aj Moisés chi', aton vin̈aj Josué quelem vinac, yuninal vin̈aj Nun, scann̈ej vin̈ d'a yol mantiado chi'. ");
INSERT INTO cac_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ix yalan vin̈aj Moisés chi' d'a Jehová: —Mamin Jehová, a ach ix al d'ayin to a in tzin cuchb'ej jun a chon̈ab' tic, palta maj al-laj d'ayin mach ol a chec colvaj ved'oc. Ix alani to ojtac in to ay a tzalajc'olal ved'oc alani. ");
INSERT INTO cac_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Yuj chi', tato yel icha chi', ac' vojtaquejeli tas nab'il uuj, yic cham tzach vojtaquejeli, ol vac'ann̈ej tzalajb'oc a c'ool. Ojtac val to a jun chon̈ab' tzac'canoch d'a yol in c'ab' tic to a chon̈ab' yaji, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","—A in val lac'an ol in b'at ed'oc, ol ex vac' cajnaj d'a junc'olal d'a lum luum chi', xchi Jehová d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Yuj val chi', ix tac'vi vin̈aj Moisés chi': —Yel val Mamin, tato max ach b'at qued'oc, vach' to max on̈ iq'uel d'a tic. ");
INSERT INTO cac_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Tato max ach b'at qued' ticnaic, ¿tas val tz'aj yojtacajeli, tato ay a tzalajc'olal ved'oc yed' d'a eb' a chon̈ab' tic? Tato ayachn̈ejoch qued'oc jun, ol checlajeloc to a chon̈ab' ton caji, sic'b'il on̈ el uuj d'a scal masanil chon̈ab', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","—A juntzan̈ lolonel tzal tic ol in c'ulej, yujto te ay in tzalajc'olal ed'oc, vojtac val a pensar sic'lab'il, xchi Jehová d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","—Mamin, tzin tevi val d'ayach to tza ch'ox snivanil elc'och d'ayin, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ix tac'vi Jehová d'a vin̈: —Masanil in vach'c'olal ol in ch'ox d'ayach. A val d'a ichan̈ ol valel in vach'il to a in ton Jehová in, ol vac' in vach'c'olal d'a eb' b'aj syal in c'ol svac'a', ol oc' in c'ool d'a eb' b'aj syal in c'ool. ");
INSERT INTO cac_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Palta sval d'ayach to man̈ ol yal-laj och q'uelan d'a in sat, yujto malaj junoc mach syal yilan in sat. Tato tz'och q'uelan junoc mach d'ayin, elan̈chamel schami. ");
INSERT INTO cac_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ina d'a in lac'anil ay jun lugar b'aj ol yal a q'uecan lin̈an d'a yib'an̈ jun nivan q'ueen. ");
INSERT INTO cac_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ayic ol ec'b'at in tziquiquial ta', ol ach vac'anoch d'a yol spojelal q'uen q'ueen chi', ol ach in macchancanoch yed' in c'ab' yacb'an tzin ec'canb'ati. ");
INSERT INTO cac_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ayic ol lajvoc vec'cani, ol vic'anel in c'ab', axon̈ej in patic ol yal ilani, axo in sat man̈ val jab'oc ol yal ilani, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ix yalan Jehová d'a vin̈aj Moisés chi': —A ticnaic a achxo ol a tzey chab'oc q'uen q'ueen, icha val q'uen ix vac' d'ayach d'a sb'ab'elal, aton q'uen ix a mac'pojoc. Ol in tz'ib'anxioch d'a q'ueen, icha val tas ix in tz'ib'ejoch d'a q'uen b'ab'el chi'. ");
INSERT INTO cac_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Tza b'oan a b'a d'a q'uin̈ib'alil q'uic'an, tzach javi d'a vichan̈ d'a jolom vitz tic. ");
INSERT INTO cac_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Malaj junoc mach syal sq'ueta ed'oc, malaj junoc mach syal yec' d'a spatictac lum vitz tic. Max yalpaxlaj yec' noc' calnel yed' noc' vacax vael d'a yichtac luum, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ix lajvi chi, ix stzeyan chab' q'uen q'ueen vin̈ icha q'uen ix scha' d'a sb'ab'elal d'a Jehová. Axo d'a q'uin̈ib'alil d'a junxo c'u, ix yic'anb'at q'uen vin̈, ix b'at vin̈ d'a jolom vitz Sinaí, icha val ix yutej Jehová yalan d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ix lajvi chi', ix emul Jehová d'a stz'ey vin̈ d'a scal asun d'a jolom vitz chi', ix yalan sb'i d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ix ec'b'at Jehová d'a yichan̈ vin̈, te chaan̈ ix yal icha tic: —A in ton Jehová in. Jehová in b'i. Te vach' in c'ool, tz'oc' in c'ol d'a anima. Man̈ elan̈chameloc scot voval. Te nivan tzin xajanej eb' anima, svac'n̈ejelc'och tas svala'. ");
INSERT INTO cac_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","A tas vach' valnaccan d'a eb' e mam eyicham, ol vac'n̈ejelc'och d'ayex a ex yin̈tilexcan eb' tic d'a masanil tiempo. Svac'an nivanc'olal e chucal e mul yed' e pital. Palta max ec'b'atlaj vac'an syaelal junoc mach yuj smul b'aj juneln̈ej pit syutej sb'a d'ayin, svac'n̈ejcan yaelal d'a yib'an̈ yuninal yed' yixchiquin, masanto d'a schan̈il macan̈ yin̈tilal, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","D'a elan̈chamel ix em n̈ojan vin̈aj Moisés chi', ix emc'och snan̈al sat vin̈ d'a sat luum d'a yichan̈ Jehová chi', ix yalan vin̈ icha tic: ");
INSERT INTO cac_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","—Mamin Vajalil, tato yel tzach tzalaj ved'oc, tzach b'atn̈ej qued'oc, vach'chom a jun chon̈ab' tic te pit, palta ac' nivanc'olal co chucal tz'och d'a ichan̈, tzon̈ a chaancan a chon̈ab'oc, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ix yalan Jehová d'a vin̈aj Moisés chi': —Chaab' tas ol vala': A ticnaic, tzin b'ocan jun in trato tic d'a yichan̈ masanil eb' etchon̈ab'. Ol in b'o tastac te satub'tac to mantalaj b'aj tzuji d'a junocxo nación d'a yolyib'an̈q'uinal tic. Ol yil masanil eb' etchon̈ab' eb' ajun tic ed'oc tastac ol in c'ulej eyuuj, to satub'tac yilji. ");
INSERT INTO cac_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","C'anab'ajejec masanil tas svalcan tic d'ayex. A in ol viq'uel eb' amorreo, eb' cananeo, eb' hitita, eb' ferezeo, eb' heveo yed' eb' jebuseo d'a eyichan̈. ");
INSERT INTO cac_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ayic ol ex c'och d'a sat lum luum chi', malajocab' b'aq'uin̈ tze b'o junoc e trato yed' eb' anima ta'. Tato scan eb' d'a e cal, yel ol ex yixtejel eb'. ");
INSERT INTO cac_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","A val tas ol e c'ulej to ol e mac'poj yaltar eb' yed' yechel sdiosal eb'. Tze ch'acanel te te' yechel sdiosal eb' scuchan Asera. ");
INSERT INTO cac_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Man̈ ex lesalvoc d'a junoc comon dios, yujto a in Jehová in, yelxo val te ov in d'a juntzan̈ chi'. Yelxo val ste cot voval d'ayex tato tzex och ejmelal d'a junoc ch'oc diosal. ");
INSERT INTO cac_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Man̈ e b'olaj junoc e trato yed' eb' anima ayec' d'a sat lum chi'. Tato tze b'o e trato chi' yed' eb' axo yic tz'och eb' ejmelal d'a sdiosal chi', syac'an silab' eb' d'ay, tzex yavtej eb', tze vaan tas syac' eb' silab'oc chi'. ");
INSERT INTO cac_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Talaj syic'laj sb'a yisil eb' yed' eb' eyuninal, axo yic tz'em n̈ojan eb' ix d'a sdiosal chi', scuchb'ajem n̈ojan eb' eyuninal chi' yuj eb' ix d'a juntzan̈ comon dios chi'. Tato icha chi' man̈xalaj tz'aj velc'och d'a yol sat eb' eyuninal chi'. ");
INSERT INTO cac_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Man̈ e b'o junoc e diosal yed' q'uen q'ueen sb'ochaj d'a molde. ");
INSERT INTO cac_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Tze yac'och q'uin̈ yic ixim pan malaj yich. Uque' c'ual tze va jun pan chi', icha val ix aj vac'an e c'ayb'ej. A stiempoal, chequel yajcani, aton uj Abib, yujto a d'a jun uj chi' elnaquexcot d'a Egipto. ");
INSERT INTO cac_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Masanil eb' b'ab'el vinac unin, vic yaj eb'. Vicpax sb'ab'el yune' noc' e vacax, yune' noc' e calnel yed' yune' noc' e chiva tato vinac. ");
INSERT INTO cac_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Axo pax sb'ab'el yune' noc' e b'uru, syal yac'ji junoc yune' calnel sq'uexuloc noc'. Tato malaj junoc sq'uexul noc' tzeyac'a', yovalil smac'ji q'uichaj sjaj noc'. An̈eja' pax yuj e b'ab'el vinac unin, yovalil tzeyac' junoc noc' yune' calnel sq'uexuloc. Malaj junoc mach sja d'ayin d'a q'uin̈ tato malaj jab'oc yofrenda yed'nac. ");
INSERT INTO cac_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","D'a vaque' c'ual tzex munlaji, axo d'a yuquil c'ual tzeyic'an eyip, vach'chom stiempoal munlajel, ma stiempoal smolchajq'ue sat eyavb'en, yovalil tzeyic' eyip. ");
INSERT INTO cac_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Tzeyac'och q'uin̈ yic sb'ab'el sat ixim e trigo sc'anb'i, aton q'uin̈ Pentecostés. Tzeyac'anpaxoch junxo q'uin̈ yic slajviq'ue ixim yic lajvub' ab'il. ");
INSERT INTO cac_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Masanil eb' vinac, yovalil oxel sjavi eb' d'a vichan̈ d'a yol junjun ab'il d'a juntzan̈ q'uin̈ tic, a in Jehová e Diosal in tic svala'. ");
INSERT INTO cac_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ol viq'uel masanil juntzan̈xo nación d'a eyichan̈, ol vac' levanb'oc e luum. Malaj mach syal yic'anec' lum e luum chi', yacb'an ayec' eb' vinac d'a vichan̈ oxel d'a yol ab'il. ");
INSERT INTO cac_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Ayic tzeyac'an e silab' d'ayin, man̈ eyac' schiq'uil noc' noc' yed' ixim pan ayb'at yich d'a scal. A noc' silab' yic jun q'uin̈ yic tze naancoti ayic ex vic'annaquelta d'a Egipto, tato ayto noc' scani, man̈ e sic'canb'at d'a junxo c'u. ");
INSERT INTO cac_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","A sb'ab'el sat eyavb'en yovalil tzeyic'cot d'a in cajnub'. Man̈ e tz'an̈ noc' yunetac chiva d'a scal yal yim snun, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ix yalanxi Jehová d'a vin̈aj Moisés chi': Tz'ib'ej masanil juntzan̈ lolonel tic, yujto a ayoch yichb'aniloc in trato ix vac' ed'oc yed' pax eb' etchon̈ab', xchi. ");
INSERT INTO cac_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","A vin̈aj Moisés chi', 40 c'ual yed' 40 ac'val ix ec' vin̈ yed' Jehová d'a jolom vitz Sinaí. Malaj val jab'oc tas ix sva vin̈, malaj pax jab'oc tas ix yuq'uej vin̈ d'a jun tiempoal chi'. Ix stz'ib'anoch slolonelal strato Jehová yed' eb' chon̈ab' israel d'a q'uen q'ueen, aton lajun̈e' checnab'il. ");
INSERT INTO cac_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ix lajvi chi, ix emixta vin̈aj Moisés chi' d'a jolom vitz Sinaí chi', yed'nacxopax chab' pachan̈ q'uen q'ueen vin̈, aton q'uen b'aj tz'ib'ab'iloch checnab'il chi'. Man̈ yojtacoc vin̈ tato toxon̈ej sveei yilji sat, yujto ix lolon vin̈ yed' Jehová. ");
INSERT INTO cac_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Axo ix yilan vin̈aj Aarón yed' masanil eb' yetchon̈ab' to toxon̈ej sveei yilji sat vin̈, ix te xivq'ue eb' smasanil sc'och d'a stz'ey vin̈. ");
INSERT INTO cac_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ix yavtancot eb' anima chi' vin̈, ichato chi' ix snitzanoch sb'a vin̈aj Aarón yed' eb' yichamtac vinaquil chon̈ab' d'a stz'ey vin̈, ix lolon vin̈ d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ix lajvi chi', ix snitzancot sb'a masanil eb' chon̈ab', ix och ijan vin̈ yalan masanil checnab'il ix yac' Jehová d'a vin̈, aton juntzan̈ ix b'at schaemta vin̈ d'a jolom vitz Sinaí chi'. ");
INSERT INTO cac_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","A ix lajvi slolon vin̈ d'a eb' anima chi', ix smacan sat vin̈ d'a jun c'apac. ");
INSERT INTO cac_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Axo yic tz'och vin̈ yic slolon yed' Jehová, syiq'uel jun c'apac chi' vin̈. Axo tz'elxul vin̈, syalanxi vin̈ d'a eb' chon̈ab' tas checnab'ilal schec Jehová chi' yal d'a eb'. ");
INSERT INTO cac_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ayic van slolon vin̈ d'a eb' chi', syilan eb' to veei yilji sat vin̈. Slajvi yalan schecnab'il Jehová vin̈ d'a eb', smacanxi sat vin̈ d'a jun c'apac chi'. Ato yic tz'och vin̈ lolonel d'a yichan̈ Jehová, syic'anxiel vin̈. ");
INSERT INTO cac_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Ix smolb'ancot masanil eb' chon̈ab' israel vin̈aj Moisés chi', ix yalan vin̈ d'a eb' icha tic: Ix yac' juntzan̈ checnab'il tic Jehová d'ayin, to ol e c'anab'ajej. ");
INSERT INTO cac_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Vaque' c'ual tzex munlaji, axo yuquil c'ual, yicxo Jehová yaji. E masanil d'a jun c'u chi' tzeyic' eyip, tzeyic'anchaan̈ Jehová. A mach smunlaj d'a jun c'u chi' yovalil schami. ");
INSERT INTO cac_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Vach'chom e c'ac', max yal-laj eyac'anoch d'a jun c'ual chi' yaln̈ej b'aj cajan ex, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ix yalanxi vin̈aj Moisés chi' d'a masanil eb' chon̈ab' israel icha tic: A juntzan̈ tic ix yal Jehová: ");
INSERT INTO cac_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Tzeyac' junoc ofrenda d'ay. A mach tz'el val d'a sc'ol yac'ani, syal yic'ancot q'uen oro, q'uen plata yed' q'uen bronce, ");
INSERT INTO cac_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","an̈ ch'al q'uic'mutz'inac, an̈ yaxmaquinac, an̈ chac ch'al, an̈ lino te vach' yed' xil noc' chiva b'ayb'il. ");
INSERT INTO cac_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Syalpax eyic'ancot stz'umal noc' ch'ac calnel uc'nac yed' chacchac, noc' tz'uum te lab'ab'i yed' pax te' acacia. ");
INSERT INTO cac_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Tzeyic'paxcot yaceiteal sat te' olivo tz'em d'a yol candil, perfume sb'at d'a scal aceite tz'ac'jioch d'a junoc tz'ochcan yicoc Jehová, sb'atpax d'a scal incienso suc'uq'ui sjab'. ");
INSERT INTO cac_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Tzeyic'paxcot q'uen cornalina yed' juntzan̈ q'uen q'ueen yelxo val vach' yilji tz'och yelvanub'oc schaleca vin̈ sat sacerdote, tz'ochpax yelvanub' jun smacul sn̈i' sc'ool vin̈. ");
INSERT INTO cac_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Masanil eb' vin̈ vinac jelan sb'oan tastac vach' yilji, cotocab' eb' vin̈, yic sb'oan tas eb' vin̈ ix schec Jehová sb'oi: ");
INSERT INTO cac_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Aton mantiado scajnub' Jehová yed' pax juntzan̈ tz'och d'a yib'an̈ yed' pax sganchoal, smarcoal, sreglail, yoyal yed' sb'achnub'al yich. ");
INSERT INTO cac_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Sb'opax te' scaxail trato, sreglail tz'och sb'achlab'iloc, smacul b'aj tz'ac'ji tup mul, junoc cortina tz'och smaculoc, ");
INSERT INTO cac_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","te' mexa yed' regla tz'och sb'achlab'iloc yed' pax syamc'ab'il, ixim pan tz'ac'jioch d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Sb'opax sb'achnub'al candil yed' masanil syamc'ab'il yed' pax uque' candil yed' aceite tz'em d'a yol juntzan̈ candil chi'. ");
INSERT INTO cac_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Sb'ojipax altar yic incienso, regla tz'och sb'achlab'iloc, aceite sc'anchaji yic tz'och d'a junoc tz'ochcan yicoc Jehová, incienso suc'uq'ui sjab', c'apac cortina yic smacul sti' scajnub' Jehová. ");
INSERT INTO cac_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Sb'opax junoc altar b'aj stz'a silab', smallail jun altar chi' nab'a bronce yed' sreglail yed' masanil syamc'ab'il. Sb'o jun palangana yed' sb'achnub'al. ");
INSERT INTO cac_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Sb'opax c'apac cortina tz'ec' oyan d'a spatic yamaq'uil scajnub' Jehová chi' yed' yoyal yed' pax sb'achnub'al yich yed' c'apac cortina tz'och smaculoc sti' amac' chi'. ");
INSERT INTO cac_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Sb'o yestacail yed' sch'an̈al syamanem d'a spatictac jun scajnub' Jehová chi' yed' d'a yamaq'uil. ");
INSERT INTO cac_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Sb'opax c'apac pichul jalb'il syac'och eb' sacerdote d'a yol scajnub' Jehová. Aton pichul syac'och vin̈aj sacerdote Aarón to yicn̈ej yopisio vin̈ yaji yed' pax spichul eb' yuninal vin̈, aton syac'och eb' a tz'och eb' d'a yopisio, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ix lajvi yalan masanil juntzan̈ chi' vin̈aj Moisés chi', ix b'at eb' smasanil d'a yoltac smantiado. ");
INSERT INTO cac_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","A eb' ix el val d'a sc'ool, ix laj yac' silab' eb' yic sb'oji scajnub' Jehová, aton b'aj sch'ox sb'a yed' masanil tas tz'och yopisio yed' c'apac pichul yic yopisio eb' sacerdote. ");
INSERT INTO cac_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ix laj javi eb' vin̈ vinac yed' eb' ix ix yed' silab' d'a Jehová, ato syala' jantac ix el d'a sc'ol eb' yac'ani, ix ul yac'an eb' d'a vin̈aj Moisés chi'. Ix yic'ancot q'uen yelvanub' pichul eb', q'uen colc'ab', q'uen ton̈, q'uen uchiquin yed' juntzan̈ocxo nab'a oro. Ix yac'an eb' d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Masanil eb' ay ch'al q'uic'mutz'inac d'ay, ch'al yaxmaquinac, chac ch'al, lino te vach', xil noc' chiva b'ayb'il, stz'umal noc' ch'ac calnel uc'nac yed' chacchac yed' pax noc' tz'uum te lab'ab'i, ix laj yic'cot eb' d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ay pax mach ix el d'a sc'ool yic'ancot q'uen plata yed' q'uen bronce yofrendaoc d'a Jehová. A eb' ay te' acacia d'ay, ix yic'paxcot te' eb', yic sc'anchaj te' d'a scajnub' Dios. ");
INSERT INTO cac_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Axo eb' ix ix syal sb'oan an̈ ch'al, ix yic'cot ch'al q'uic'mutz'inac eb' ix, ch'al yaxmaquinac, chac ch'al yed' lino te vach'. ");
INSERT INTO cac_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ay eb' ix ix jelan ix el val d'a sc'ool, ix och ijan eb' ix sb'oan xil noc' chiva d'a ch'alil. ");
INSERT INTO cac_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Axo eb' yichamtac vinaquil chon̈ab', ix yic'cot q'uen cornalina eb' yed' pax juntzan̈xo q'uen q'ueen te vach' yic tz'och yelvanub'oc schaleca vin̈ sat sacerdote yed' yochpax yelvanub'oc jun smacul sn̈i' sc'ool vin̈. ");
INSERT INTO cac_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ix yic'paxcot perfume eb', aceite sc'anchaj d'a candil, aceite sc'anchaj d'a junoc tz'ochcan yicoc Jehová yed' incienso suc'uq'ui sjab'. ");
INSERT INTO cac_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Masanil eb' chon̈ab' israel, eb' vin̈ vinac yed' eb' ix ix to ix el val d'a sc'ool, ix yac' scolval eb' d'a masanil jun munlajel ix yal Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ix yal vin̈aj Moisés d'a masanil eb' yetchon̈ab': A Jehová toxo ix sic'anel vin̈aj Bezaleel, yuninal vin̈aj Uri, yixchiquin vin̈aj Hur, d'a yin̈tilal Judá. ");
INSERT INTO cac_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ix yac'anoch Yespíritu Dios chi' d'a vin̈ yic syac'an sjelanil spensar vin̈ yed' yojtacanel vin̈ yic syalpax snachajel yuj vin̈ ");
INSERT INTO cac_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","sb'oan yechel tas sb'o'o, icha d'a q'uen oro, q'uen plata yed' q'uen bronce. ");
INSERT INTO cac_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Ix ac'jipax sjelanil vin̈ yic sb'oanpax q'uen q'ueen yelxo val vach', yic sb'oanpaxem yechel te te' yelxo val vach' tz'aji yed' yoch yelvanub' te'. ");
INSERT INTO cac_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ix yac'an sjelanil Jehová d'a vin̈ yed' d'a vin̈aj Aholiab, yuninal vin̈aj Ahisamac, d'a yin̈tilal Dan, yic sc'ayb'an juntzan̈xo eb' scolvaj yed' eb'. ");
INSERT INTO cac_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ix ac'ji sjelanil eb' yuj Jehová, yic sb'oan masanil tastac eb' to yelxo val vach' yilji: Yic sb'oan yechel, yic sb'oanoch yelvanub' yed' an̈ ch'al q'uic'mutz'inac, an̈ ch'al yaxmaquinac, an̈ chac ch'al yed' lino ch'al te vach'. Ix ac'ji sjelanil eb' sb'oan junoc tas vach' yed' sch'oxan yechel junocxo yaln̈ej tas munlajelal. ");
INSERT INTO cac_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Yuj chi' a vin̈aj Bezaleel, vin̈aj Aholiab yed' pax juntzan̈xo eb' vin̈ vinac ix ac'ji sjelanil yuj Jehová sb'oan tastac vach' yilji, a eb' vin̈ ol b'oan masanil tas tz'och yopisio d'a scajnub' Jehová icha ix aj yalani, xchi vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Axo vin̈aj Moisés ix avtancot vin̈aj Bezaleel yed' vin̈aj Aholiab chi' yed' pax masanil eb' vin̈ ix ac'ji sjelanil spensar yuj Jehová yic sb'oan yaln̈ej tastac vach' yilji, aton eb' tz'el d'a sc'ol scolvaj d'a jun munlajel chi'. ");
INSERT INTO cac_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","A eb' vin̈ chi' ix chaan masanil ofrenda ix yic'cot eb' chon̈ab' israel d'a vin̈aj Moisés, yic tz'el yich munlajel yuj sb'o scajnub' Dios. Axo eb' tz'el val d'a sc'ol yac'an yofrenda, junjun q'uin̈ib'al syic'ancot yofrenda eb' chi'. ");
INSERT INTO cac_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Axo eb' vin̈ munlajvum chi', ix yactejcan smunlajel eb' vin̈, ix b'at eb' vin̈ yal d'a vin̈aj Moisés chi': ");
INSERT INTO cac_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Toxo ix ec' yib'an̈ yic'ancot yofrenda eb' anima, man̈ ol lajvoclaj masanil tas ix yic'cot eb' tic d'a munlajel ix yal Jehová to sb'oi, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ayic ix yab'an vin̈aj Moisés to icha chi', ix yalanel vin̈ d'a scal anima d'a campamento to maxtzac yic'cotlaj yofrenda eb' yuj sb'o scajnub' Dios. Icha chi' ix aj svanaj yic'ancot yofrenda eb' chi', ");
INSERT INTO cac_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","yujto toxo ix tz'acvi jantac tas ol och d'a scajnub' Dios, aytopax tas olto canoc. ");
INSERT INTO cac_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","A d'a scal eb' munlajvum chi', ata' ay eb' jelan spensar sb'oanq'ue scajnub' Dios. Lajun̈e' jen̈an c'apac lino b'ayb'il sch'alil ix sb'o eb'. D'a an̈ ch'al q'uic'mutz'inac, an̈ ch'al yaxmaquinac yed' pax an̈ chac ch'al ix sb'o'och yechel querubín eb' d'a junjun jen̈an lino chi'. ");
INSERT INTO cac_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","A junjun jen̈an chi', 12 metro steel yed' nan̈alxo, chab' metro sat. Lajann̈ej ix aj yechel smasanil. ");
INSERT INTO cac_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Oye' jen̈an c'apac ix tz'ischaj yam sb'a yic junxon̈ej jen̈an tz'aji. An̈eja' icha chi' ix aj stz'ischaj syam sb'a oyexo jen̈an. ");
INSERT INTO cac_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ix lajvi chi', ix tz'ischajoch xoyjab' an̈ q'uic'mutz'inac ch'al d'a sti' c'apac b'ab'el jen̈an chi' yic syamnub'aloc. An̈eja' icha chi' ix aj yochpax d'a sti' junxo schab'il jen̈an chi'. ");
INSERT INTO cac_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ix och xoyjab' 50 q'uic'mutz'inac ch'al d'a jun pac'an̈ sti', junjun jen̈an c'apac lajann̈ej ix aj schalan sb'a c'apac. ");
INSERT INTO cac_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ix b'opax 50 q'uen syamnub'al nab'a oro yic syal yil-lan sb'a c'apac chab' jen̈an chi' yic vach' junxon̈ej tz'ajcan c'apac. ");
INSERT INTO cac_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ix b'oxi uxluche' jen̈an xil noc' chiva, yic a tz'och d'a yib'an̈ scajnub' Dios. ");
INSERT INTO cac_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ay 13 metro steel yed' nan̈alxo yed' chab' metro sat. Lajann̈ej ix aj yechel smasanil. ");
INSERT INTO cac_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ix tz'ischaj yam sb'a oye' jen̈an yic junxon̈ej tz'aji. Ix tz'ischajpax syam sb'a vaquexo, yic junxon̈ej pax jen̈an tz'aji. ");
INSERT INTO cac_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ix och xoyjab' 50 syamnub'al d'a jun pac'an̈ sti' jun b'ab'el jen̈an. Ix ochpax 50 syamnub'al d'a sti' junxo schab'il jen̈an chi'. ");
INSERT INTO cac_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ix b'opax 50 syamnub' nab'a bronce, yic syil-laj sb'a chab' jen̈an chi', yic junxon̈ej jen̈an tz'aji. ");
INSERT INTO cac_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ix b'ojipax stz'umal noc' ch'ac calnel uc'nac yed' chacchac, yic tz'em d'a yib'an̈ jun jen̈an xil noc' chiva chi' yed' junxo macan̈ tz'uum te lab'ab'i yic tz'em d'a yib'an̈ jun jen̈an stz'umal noc' ch'ac calnel chi'. ");
INSERT INTO cac_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ix sb'opax juntzan̈ te' marco eb', yic tz'och d'a spatic scajnub' Dios, lin̈an tz'ajoch junjun te'. Masanil te', a te' acacia b'aj ix el te'. ");
INSERT INTO cac_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Nan̈al yoil metro steel junjun te' marco chi', axo slevanil sat te', 70 centímetro. ");
INSERT INTO cac_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ix can chab'chab' yoc junjun te' marco chi' yic tz'em lin̈an. Lajann̈ej ix ajcan scal yoc te' chi'. Icha chi' ix aj te' marco chi' smasanil tz'och d'a spatic scajnub' Dios chi'. ");
INSERT INTO cac_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ay 20 te' ix sb'o eb' yic tz'och d'a stojolal sur. ");
INSERT INTO cac_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ix b'oji 40 q'uen plata sb'achnub'oc yich te' 20 chi' yuj eb', chab'chab' q'uen d'a yich junjun te', junjun q'uen d'a junjun yoc te'. ");
INSERT INTO cac_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","An̈ejtona' ix b'oji 20-xo te' marco chi' yic tz'och d'a jun pac'an̈xo, aton d'a stojolal norte. ");
INSERT INTO cac_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","An̈eja' 40 q'uen plata ix b'o sb'achnub'oc yich te', yic chab'chab' q'uen tz'och d'a yich junjun te'. ");
INSERT INTO cac_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Axo yic jun pac'an̈ yol schiquin d'a stojolal b'aj tz'em c'u, vaque' te' marco chi' ix b'oji. ");
INSERT INTO cac_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Ix sb'opax chab' te' marco chi' eb' yic tz'och te' d'a junjun yesquinail jun pac'an̈ chi'. ");
INSERT INTO cac_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","A chab' te' marco chi', nub'ub'i ix aj te', d'a yich masanto sq'uec'och b'aj syil-laj sb'a yuj junoc argolla, aton te' chi' ix och d'a chab' yesquinail. ");
INSERT INTO cac_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Vajxaque' te' marco ix b'oi yic tz'och d'a jun schiquin chi' yed' 16 sb'achnub'al yich nab'a plata, chab'chab' sb'achnub'al yich junjun te'. ");
INSERT INTO cac_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ix sb'oanpax oye' te' regla eb' d'a te' acacia, te' tz'och d'a spatic te' marco d'a junoc pac'an̈ cajnub' chi'. ");
INSERT INTO cac_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Oye' pax te' yic tz'och d'a junxo pac'an̈ yed' oye' pax te' yic tz'och d'a junxo pac'an̈ d'a yol schiquin d'a spatic, d'a stojolal b'aj tz'em c'u. ");
INSERT INTO cac_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","A te' regla tz'och chi', a d'a snan̈al te' marco chi' tz'ec' junoc te' masanto sc'axpajec'c'och te' d'a junxo schiquin. ");
INSERT INTO cac_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ix och q'uen oro d'a spatictac te' marco chi'. Ix b'opax q'uen argolla nab'a oro b'aj tz'ec' te' regla chi'. Ix ochpax q'uen oro d'a spatictac te' regla chi'. ");
INSERT INTO cac_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ix sb'opax jun c'apac cortina eb' yed' an̈ lino. Ix b'ojioch yechel querubín d'a c'apac yuj junoc jelan sb'oani. A d'a an̈ ch'al q'uic'mutz'inac, an̈ yaxmaquinac yed' an̈ chac ch'al ix b'ojioch yechel querubín chi'. ");
INSERT INTO cac_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ix sb'oan chan̈e' te oy eb' d'a te' acacia, ix yac'och q'uen oro eb' d'a spatic te'. Ix b'opax chan̈e' sb'achnub'al yich te', nab'a plata ix aji. Ix yac'anoch q'uen gancho nab'a oro eb' d'a schon te' yic sq'ue locan c'apac cortina chi'. ");
INSERT INTO cac_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ix sb'oanpax jun c'apac cortina eb' yic tz'och smaculoc mantiado chi'. A jun c'apac cortina chi' d'a an̈ lino ch'al ix sb'o eb'. Yed' an̈ ch'al q'uic'mutz'inac, an̈ ch'al yaxmaquinac yed' an̈ chac ch'al, ix b'ochajoch stz'ib'ul yuj junoc jelan sb'oani. ");
INSERT INTO cac_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ix b'ojipax oye' te' oy, ix em q'uen oro d'a schon te' yed' pax sganchoal. Ix b'opax oye' sb'achnub'al yich te', nab'a bronce ix aji. ");
INSERT INTO cac_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Ix sb'oan te' scaxail strato Dios vin̈aj Bezaleel. A te' acacia ix och d'ay. Jun metro yed' 10 centímetro ix aj sc'atul, 70 centímetro ix aj sat. An̈eja' 70 centímetro ix ajpax schaan̈il. ");
INSERT INTO cac_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ix och q'uen oro d'a yool yed' d'a spatic yed' d'a stitac tzalanq'uei. ");
INSERT INTO cac_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ix b'opax chan̈e' argolla nab'a oro tz'och d'a yoc schan̈il, chab'chab' d'a junjun pac'an̈. ");
INSERT INTO cac_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ix b'opax juntzan̈ te sb'achlab'il d'a te' acacia, ix ochpax q'uen oro d'a spatictac te'. ");
INSERT INTO cac_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ix lajvi chi', ix ecchajec' te' d'a yol q'uen argolla chi', yic vach' syal sb'achchaj te'. ");
INSERT INTO cac_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ix b'opax jun smacul nab'a oro b'aj tz'ac'ji tup mul, jun metro yed' 10 centímetro sc'atul, 70 centímetro sat. ");
INSERT INTO cac_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ay chab' yechel querubín nab'a oro tenb'il d'a q'uen martillo ix och d'a yib'an̈ jun smacul chi'. ");
INSERT INTO cac_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Junn̈ej ix aj jun smacul chi' yed' chab' yechel querubín chi', junjun ix can d'a stitac jun smacul chi', ");
INSERT INTO cac_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","d'an̈d'umb'a ix aji. Ix em q'uelan juntzan̈ querubín chi' d'a yib'an̈ smacul te' scaxail trato chi', axo sc'axil, syil-laj sb'a sn̈i' d'a yib'an̈, ichato yen̈ul yaji. ");
INSERT INTO cac_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ix sb'opax jun te' mexa vin̈aj Bezaleel chi'. An̈eja' te' acacia ix och d'a te'. 90 centímetro ix aj sc'atul, 45 centímetro ix aj sat, 70 ix ajq'ue steel. ");
INSERT INTO cac_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ix och q'uen oro d'a te', ix b'opax jun tz'ec' oyan d'a spatic yoc te' schan̈il, nab'a oro ix aji. ");
INSERT INTO cac_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ix b'opax q'ue stitac ix ec' oyan d'a yib'an̈, uque' centímetro ix ajq'uei, ix och oro d'ay. ");
INSERT INTO cac_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ix b'opax chan̈e' argolla nab'a oro, ix och d'a te' yoc schan̈il d'a yesquinail. ");
INSERT INTO cac_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ix och juntzan̈ argolla chi' d'a slac'anil b'aj ayem stitac chi'. A d'a yol juntzan̈ chi' ix ec' te' sb'achlab'il yic syal yic'chajb'at te' mexa chi'. ");
INSERT INTO cac_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","A te' sb'achlab'il chi', aton te' acacia, ix ochpax q'uen oro d'a spatictac te'. ");
INSERT INTO cac_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ix b'ochajpax syamc'ab'il nab'a oro sc'anchaj d'a jun mexa chi', aton juntzan̈ tic: Q'uen plato, nivac cuchara, xalu yed' uc'ab' b'aj schaji ofrenda a' yaji. ");
INSERT INTO cac_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ix sb'opax jun sb'achnub' candil vin̈aj Bezaleel chi', nab'a oro ix aji, ix tenchaj d'a q'uen martillo. A sc'ojnub' b'aj tz'em b'achan, ste'al yed' scopail icha sfloral, junn̈ej yaman ix aji. ");
INSERT INTO cac_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Oxox sc'ab' ix elta d'a stz'eytac. ");
INSERT INTO cac_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Junjun juntzan̈ sc'ab' ayelta d'a ste'al chi', ay oxe' sfloral icha yic te' almendro. ");
INSERT INTO cac_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","A jun ste'al chi', ay pax chan̈e' sfloral icha yic te' almendro chi'. ");
INSERT INTO cac_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","A d'a yalan̈ b'aj ayelta chab'chab' sc'ab' chi', ay junjun sfloral. ");
INSERT INTO cac_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","A juntzan̈ sfloral yed' sc'ab' chi', junn̈ej ix aj yed' sb'achnub'al chi'. A jun chi', nab'a oro ix aji, tenb'il d'a q'uen martillo. ");
INSERT INTO cac_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ix b'opax uque' candil, an̈ejtona' ix b'opax q'uen q'ueen tz'ic'anel stan̈il c'apac b'aj tz'och sc'ac'al yed' splatoal. Nab'a oro ix aj smasanil. ");
INSERT INTO cac_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","A jantac q'uen oro ix och d'a jun b'achnub' candil chi' yed' syamc'ab'il, oxe' arroba ix ochi. ");
INSERT INTO cac_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ix sb'oanpax jun altar yic incienso vin̈aj Bezaleel chi' d'a te' acacia. Lajann̈ej ix aj d'a schan̈il pac'an̈, 45 centímetro ix aji, axo pax steel, 90 centímetro ix ajq'uei. Ix b'opax juntzan̈ sch'aac d'a junjun yesquinail, yaman ix aj yed' jun altar chi'. ");
INSERT INTO cac_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ix och q'uen oro yelxo val vach' d'a yib'an̈ yed' d'a spatictac schan̈il pac'an̈ yed' d'a sch'aac chi'. Ix q'uepax tzalan q'uen oro chi' d'a yib'an̈ stitac. ");
INSERT INTO cac_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","A d'a yalan̈ stitac chi', ata' ix och chab'chab' argolla nab'a oro d'a schab'il pac'an̈. Ix ec' te' sb'achlab'il d'a yool yic syal sb'achchaji. ");
INSERT INTO cac_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","A te' sb'achlab'il ix och chi', aton te' acacia, ix ochpax q'uen oro d'a te'. ");
INSERT INTO cac_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ix b'ojipax aceite sc'anchaji yic sic'chajel junoc mach, ma junoc tas tz'ochcan yicoc Dios. Ix b'opax incienso te vach', icha tz'aj sb'oan eb' b'oum perfume. ");
INSERT INTO cac_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ix sb'oanpax jun altar vin̈aj Bezaleel chi', aton jun b'aj stz'a silab'. D'a te' acacia ix sb'o vin̈. Lajann̈ej ix aj yechel schan̈il pac'an̈, chab' metro yed' 25 centímetro junjun pac'an̈. Jun metro yed' 25 centímetro ix ajq'ue schaan̈il. ");
INSERT INTO cac_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ix b'ojipaxq'ue chan̈e' sch'aac d'a schiquintac schan̈il, yaman ix aj yed' jun altar chi'. Ix pichchaj te' d'a q'uen bronce. ");
INSERT INTO cac_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Masanil syamc'ab'il jun altar chi', nab'a bronce ix aji: Aton yed'tal b'aj tz'ic'chajel q'uen taan̈, q'uen pala, q'uen nivac uc'ab', q'uen tenedor yed' yed'tal te' tzac'ac'. ");
INSERT INTO cac_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ix b'ojipax jun q'uen malla nab'a bronce, ix ac'jioch q'uen d'a yalan̈ sti' d'a yool. D'a snan̈al jun altar chi' ix och q'ueen. ");
INSERT INTO cac_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ix b'opax chan̈e' argolla nab'a bronce, ix och d'a junjun yesquinail q'uen malla chi'. Ix elc'och q'uen d'a spatic jun altar chi', a d'a yol q'uen tz'ec' te' sb'achlab'il. ");
INSERT INTO cac_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ix b'opax sb'achlab'il jun altar chi' d'a te' acacia, ix ochpax q'uen bronce d'a spatictac te'. ");
INSERT INTO cac_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ix ecchajec' te' d'a yol q'uen argolla ayoch d'a stz'eytac jun altar chi' yic syal sb'achchaji. A jun altar chi', chemte' ix och d'ay, ix can yolanil d'a yool. ");
INSERT INTO cac_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","A yed' q'uen nen nab'a bronce sc'an eb' ix ix ayoch yilumaloc sti' c'apac mantiado, a yed' q'uen ix sb'o jun nivan palangana vin̈aj Bezaleel yed' sb'achnub'al yich. ");
INSERT INTO cac_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ix sb'opax c'apac cortina vin̈aj Bezaleel yic tz'och smaculoc spatictac amac' d'a scajnub' Dios. A d'a stojolal sur, ix och 45 metro c'apac cortina chi', aton ch'al lino b'ayb'il ayoch d'a c'apac. ");
INSERT INTO cac_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ix b'opax 20 yoyal yed' 20 pax sb'achnub'al yich nab'a bronce. Axo d'a schon te' ix em juntzan̈ q'uen q'ueen nab'a plata yed' yargollail. ");
INSERT INTO cac_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ix b'opax c'apac cortina yic stojolal norte, 45 metro c'apac yed' 20 oy yed' pax sb'achnub'al yich nab'a bronce yed' q'uen ayem d'a schon yoyal nab'a plata yed' yargollail. ");
INSERT INTO cac_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ix b'opax c'apac cortina yic stojolal b'aj tz'em c'u, 22 metro yed' nan̈alxo sat c'apac yed' lajun̈e' yoyal yed' pax sb'achnub'al yich yed' q'uen ayem d'a schon yoyal nab'a plata yed' yargollail. ");
INSERT INTO cac_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","An̈ejtona' d'a stojolal b'aj sq'ueul c'u, 22 metro yed' nan̈alxo sat, ix b'opax c'apac cortina yic tz'och d'ay. ");
INSERT INTO cac_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","A d'a jun pac'an̈ b'aj tzon̈ ochi, ay uque' metro c'apac cortina ayochi yed' oxe' yoyal yed' pax sb'achnub'al yich. ");
INSERT INTO cac_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Axo pax d'a junxo pac'an̈, ay pax uque' metro c'apac yed' oxe' yoyal yed' pax sb'achnub'al yich. ");
INSERT INTO cac_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Masanil juntzan̈ c'apac cortina chi', ch'al lino b'ayb'il ayoch d'a c'apac. ");
INSERT INTO cac_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Masanil pax sb'achnub'al yich oy chi', nab'a bronce ix aji. Axo q'uen ayem d'a schon oy chi' nab'a plata yed' yargollail. ");
INSERT INTO cac_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","A c'apac cortina ix och smaculoc sti' amac' chi', nan̈al sb'alun̈il metro sat c'apac, axo steel c'apac, chab' metro yed' 25 centímetro. B'ob'ilpaxoch yelvanub' c'apac, jalb'il d'a an̈ ch'al q'uic'mutz'inac, an̈ ch'al yaxmaquinac, an̈ chac ch'al yed' pax lino ch'al b'ayb'il. Lajann̈ej yed' masanil c'apac ayoch d'a amac'. ");
INSERT INTO cac_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ay chan̈e' yoyal yed' chan̈e' sb'achnub'al yich nab'a bronce, axo q'uen ayem d'a schon yoyal, nab'a plata yed' yargollail. ");
INSERT INTO cac_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Masanil yestacail scajnub' Dios chi' yed' yic c'apac cortina ayoch d'a spatictac amac', nab'a bronce. ");
INSERT INTO cac_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ix yalanxi vin̈aj Moisés chi' to sb'o slistail jantac q'uen oro, q'uen plata yed' q'uen bronce ix och d'a scajnub' Jehová, aton b'aj sic'chaj scaxail trato. A eb' levita ix b'oan slistail chi'. A vin̈aj Itamar yuninal vin̈aj Aarón ix cuchb'an eb'. ");
INSERT INTO cac_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","A vin̈aj Bezaleel, yuninal vin̈aj Uri, yixchiquin vin̈aj Hur, yin̈tilal Judá ix b'oan masanil tastac ix yal Jehová d'a vin̈aj Moisés to sb'oi. ");
INSERT INTO cac_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Axo vin̈aj Aholiab yuninal vin̈aj Ahisamac, yin̈tilal Dan ix colvaj yed' vin̈aj Bezaleel chi'. A vin̈aj Aholiab chi' tenum q'ueen vin̈, jalum c'apac vin̈, syalpax sb'oanoch yelvanub' yed' an̈ ch'al q'uic'mutz'inac vin̈, an̈ ch'al yaxmaquinac, an̈ chac ch'al yed' an̈ lino ch'al te vach'. ");
INSERT INTO cac_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Masanil q'uen oro ix c'anchaji yic ix b'o scajnub' Dios, d'a ofrendail ix aj smoljiem q'ueen. A q'uen oro chi', 21 quintal yed' 95 libraxo q'ueen, icha yalil q'uen echlab' sc'anchaj d'a scajnub' Dios. ");
INSERT INTO cac_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Axo q'uen plata ix molchajemi, a ix ic'chajq'ue vaan sb'isul eb' anima, 75 quintal yed' chab'xo arroba q'ueen, icha yalil q'uen echlab' sc'anchaj d'a scajnub' Dios. ");
INSERT INTO cac_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Masanil eb' vinac ix tz'ib'chaji, eb' 20 ab'ilxo sq'uinal, 603 mil yed' 550 eb' d'a smasanil. Junjun eb' chi' nan̈al siclo plata ix yac' eb', icha yalil q'uen echlab' sc'anchaj d'a scajnub' Dios. ");
INSERT INTO cac_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","A q'uen plata ix och d'a sb'achnub'al yich smarcoal yed' sb'achnub'oc yoyal b'aj tz'och c'apac cortina, 75 quintal q'ueen d'a smasanil. Masanil juntzan̈ q'uen plata chi' ix och d'a cien sb'achnub'al chi', syalelc'ochi 75 libra ix och d'a junjun. ");
INSERT INTO cac_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","A yed' chab'xo arroba plata chi' ix sb'o q'uen gancho vin̈aj Bezaleel ix och d'a te' oy yed' smacul sjolom oy chi' yed' q'uen argolla. ");
INSERT INTO cac_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Masanil q'uen bronce ix ac'chaj ofrendail d'a Jehová, ay am 53 quintal yed' lajun̈exo libra q'ueen. ");
INSERT INTO cac_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","A d'a q'uen bronce chi' ix b'o sb'achnub'al yich yoyal b'aj ix can sti' mantiado b'aj sch'ox sb'a Dios. An̈ejtona' d'a q'uen ix b'o jun altar nab'a bronce yed' pax smallail. Nab'a bronce smasanil syamc'ab'il jun altar chi', ");
INSERT INTO cac_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","yed' pax sb'achnub'al yich yoyal smacul spatictac amac' yed' yestacail oyanoch d'a scajnub' Dios yed' yestacail spatictac yamaq'uil cajnub' chi'. ");
INSERT INTO cac_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","A spichul eb' vin̈ sacerdote sc'an d'a yopisio d'a scajnub' Dios, jalb'il d'a lana ch'al q'uic'mutz'inac, d'a ch'al yaxmaquinac yed' d'a chac ch'al. Ix b'opax spichul vin̈aj Aarón yicn̈ej yopisio yaji, icha val ix aj yalan Jehová d'a vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ayic ix b'o schaleca vin̈aj Aarón chi', ix och oro ch'al d'ay, lana ch'al q'uic'mutz'inac, yaxmaquinac, chacchac yed' an̈ lino ch'al b'ayb'il. ");
INSERT INTO cac_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ix sten q'uen oro eb', te jay ix aji. Ix lajvi chi' ix scotac polan q'uen eb', icha an̈ ch'al ix aj q'ueen yic syal sjalanb'at eb' d'a scal juntzan̈xo ch'al chi', aton sb'oji yuj eb' vach' sb'oani. ");
INSERT INTO cac_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ix sb'oan c'apac tz'ec' b'ac'an eb' d'a sjolom sjen̈jab' jun chaleca chi', yic schalaj sb'a c'apac yichan̈ yed' c'apac spatic. ");
INSERT INTO cac_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ix sb'oanoch jun tzec'ul eb' d'a jun chaleca chi', an̈ejpaxa' ix och oro ch'al d'ay, lana ch'al q'uic'mutz'inac, yaxmaquinac yed' chacchac yed' pax an̈ lino ch'al b'ayb'il, icha val ix aj yalan Jehová d'a vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ix yac'anoch q'uen cornalina eb' d'a syamnub'al nab'a oro. Ayoch sb'i eb' yuninal vin̈aj Israel d'a q'ueen, icha yajoch sletrail junoc sello. ");
INSERT INTO cac_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ix yac'anoch q'uen vin̈aj Bezaleel d'a sjolom sjen̈jab' jun chaleca chi', yic snajicot eb' yuninal vin̈aj Israel chi', icha ix aj yalan Jehová d'a vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Axo pax c'apac smacul sn̈i' sc'ol vin̈, ix b'ojioch stz'ib'ul yuj junoc jelan sb'oani, icha yic c'apac chaleca: Ayoch oro ch'al d'ay yed' lana ch'al q'uic'mutz'inac, yaxmaquinac, chacchac yed' pax lino ch'al b'ayb'il. ");
INSERT INTO cac_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Cha pacan̈ ix aji, lajann̈ej ix aj stitac schan̈il ayic pacb'ilxo. 22 centímetro junjun stitac chi'. ");
INSERT INTO cac_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","A jun chi', chan̈ tzol ix aj yoch q'uen q'ueen te vach' yilji d'ay. A d'a jun b'ab'el tzol, ayoch q'uen rubí, q'uen crisólito yed' q'uen esmeralda. ");
INSERT INTO cac_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Axo d'a schab'il tzol, ayoch q'uen granate, q'uen zafiro yed' q'uen jade. ");
INSERT INTO cac_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Axo d'a yoxil tzol, ayoch q'uen jacinto, q'uen ágata yed' q'uen amatista. ");
INSERT INTO cac_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Axo d'a schan̈il tzol, ayoch q'uen topacio, q'uen cornalina yed' q'uen jaspe. Axo q'uen oro ayoch syamlab'iloc juntzan̈ q'ueen chi'. ");
INSERT INTO cac_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Lajchave' q'ueen, aton lajchave' sb'i eb' yuninal vin̈aj Israel. Junjun sb'i eb' lajchavan̈ chi' ayoch d'a q'ueen, icha yajoch sletrail junoc sello. ");
INSERT INTO cac_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","A d'a c'apac smacul sn̈i' sc'ol chi' ix b'ojioch juntzan̈ cadena nab'a oro pach'uch'ab'il. ");
INSERT INTO cac_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ix b'ojipax chab' syamlab'il d'a q'uen oro yed' chab' argolla nab'a oro. Ix och chab' argolla chi' d'a chab' schiquin c'apac smacul sn̈i' sc'ol chi' d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ix ochpax chab' cadena oro d'a chab' argolla chi'. ");
INSERT INTO cac_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","A sn̈i' chab' cadena chi' ix och d'a chab' syamlab'il nab'a oro, ix och d'a chab' sjolom sjen̈jab' c'apac chaleca d'a yichan̈. ");
INSERT INTO cac_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ix b'opax chab'xo argolla nab'a oro, ix och d'a yol chab' schiquin c'apac smacul sn̈i' sc'ol chi' d'a yalan̈, junn̈ej ix aj yed' c'apac chaleca. ");
INSERT INTO cac_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ix b'oji chab'xo argolla nab'a oro, ix och d'a sn̈itac c'apac tz'ec' d'a sjolom sjen̈jab' c'apac chaleca, tz'emc'och d'a yichan̈. Junn̈ej ix can yed' b'aj tz'emc'och stz'isul yed' d'a yib'an̈q'ueta b'aj tz'ec' stzec'ul c'apac chaleca chi'. ");
INSERT INTO cac_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ix lajvi chi', junxon̈ej ix ajem q'uen argolla ayoch d'a c'apac yed' q'uen ayoch d'a c'apac smacul sn̈i' sc'ol chi'. Ix tzec'chaj syam sb'a q'uen d'a lana ch'al q'uic'mutz'inac, yic vach' a c'apac smacul sn̈i' sc'ol chi' scan d'a yib'an̈q'ue jun tzec'ul ayoch d'a c'apac chaleca chi', yic vach' max yactej sb'a c'apac. Ix b'o icha ix aj yalan Jehová d'a vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","A jun c'apac pichul jucan ayoch d'a yol c'apac chaleca chi', ix jalchaj b'o c'apac yed' ch'al q'uic'mutz'inac. ");
INSERT INTO cac_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ix can yolanil sjaj c'apac d'a snan̈al, ix och stz'ulil sti' d'a sjaj chi' yic max n̈ic'chaji. ");
INSERT INTO cac_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ix och yelvanub' c'apac d'a stitac d'a yoctac, icha yechel sat te' granado, ix b'oji yed' lana ch'al q'uic'mutz'inac, yaxmaquinac, chacchac yed' pax lino ch'al b'ayb'il. ");
INSERT INTO cac_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ix b'ochajpax yunetac campana, nab'a oro ix aji. Ix och d'a scal yechel sat te' granado ayoch d'a yoctac c'apac pichul chi', ");
INSERT INTO cac_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","syalelc'ochi, jun yechel sat te' granado chi', jun yune' campana, d'a stzolal ix ajochi, icha ix aj yalan Jehová d'a vin̈aj Moisés. Aton c'apac pichul jucan chi' sc'an vin̈aj Aarón ayic tz'och vin̈ d'a yopisio. ");
INSERT INTO cac_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","A c'apac spichul vin̈aj Aarón yelxo val te jucan c'apac yed' c'apac yic eb' yuninal vin̈, nab'a lino ch'al jalb'il yuj junoc jalum c'apac, a ix och d'ay. ");
INSERT INTO cac_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","An̈eja' ix b'ojipax c'apac c'ox sb'ac'chaji yed' pax juntzan̈xo sc'oxal yed' c'apac yolvex. Lino ch'al b'ayb'il ix och d'a juntzan̈ chi' smasanil. ");
INSERT INTO cac_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","An̈eja' d'a jun tzec'ul, lino ch'al b'ayb'il ix och d'ay, ix b'ojioch yelvanub' yuj junoc jelan sb'oani. D'a an̈ lana ch'al q'uic'mutz'inac, yaxmaquinac yed' chacchac ix b'ojioch yelvanub' chi', icha val ix aj yalan Jehová d'a vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ix sb'oanpax jun yelvanub' nab'a oro eb', sch'oxnab'il yopisio d'a sat sacerdoteal, ix och juntzan̈ lolonel tic d'ay icha sello: Yicn̈ej Jehová yaji, xchi. ");
INSERT INTO cac_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ix lajvi chi', ix och jun lana ch'al q'uic'mutz'inac d'ay, yic syal stzec'jioch jun yelvanub' chi' d'a snan̈al sat c'apac c'ox sb'ac'chajochi, icha val ix aj yalan Jehová d'a vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Icha chi' ix aj sb'ochajq'ue scajnub' Dios b'aj sch'ox sb'a. Icha val ix aj yalan Jehová d'a vin̈aj Moisés chi', icha val chi' ix aj sb'oan eb' israel chi'. ");
INSERT INTO cac_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Masanil syamc'ab'il scajnub' Dios ix yic'cot eb' d'a vin̈aj Moisés chi', aton tic: Syamnub'al, smarcoal, sreglail, yoyal yed' pax sb'achlab'il yich. ");
INSERT INTO cac_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","C'apac c'apac tz'och d'a yib'an̈, noc' tz'umal calnel uc'nac d'a chacchac, noc' tz'uum te lab'ab'i yed' pax jun c'apac cortina tz'och smaculoc te' scaxail trato. ");
INSERT INTO cac_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Ix yic'anpaxcot te' caxa chi' eb' yed' te' regla tz'och sb'achlab'iloc yed' smacul b'aj tz'ac'ji tup mul, ");
INSERT INTO cac_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","te' mexa yed' syamc'ab'il yed' ixim pan tz'och d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Ix yic'anpaxcot jun sb'achnub' candil nab'a oro eb' yed' pax candil ayoch d'a yib'an̈ d'a stzolal yed' masanil syamc'ab'il yed' aceite yic tz'och sc'ac'al candil chi'. ");
INSERT INTO cac_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Ix yic'anpaxcot jun altar nab'a oro eb' yed' pax aceite sc'anchaji ayic sic'chajel junoc mach, ma junoc tas tz'ochcan yicoc Dios yed' incienso suc'uq'ui sjab', jun c'apac cortina yic smacul sti' mantiado, ");
INSERT INTO cac_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","jun altar bronce yed' smallail to bronce paxi, sreglail tz'och sb'achlab'iloc, syamc'ab'il, jun palangana yed' pax sb'achnub' yich. ");
INSERT INTO cac_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Ix yic'anpaxcot c'apac cortina eb', aton c'apac tz'och d'a spatictac amac' yed' yoyal yed' pax sb'achnub' yich, c'apac cortina tz'och d'a sti' amac' yed' pax sch'an̈al, yestacail d'a spatictac amac' chi' yed' masanil yamc'ab' sc'anchaj d'a scajnub' Jehová b'aj sch'ox sb'a. ");
INSERT INTO cac_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Ix yic'anpaxcot c'apac pichul eb', aton c'apac sc'an eb' sacerdote d'a yopisio d'a yol scajnub' Dios, aton pichul yic yopisio vin̈aj sacerdote Aarón yed' spichul eb' yuninal vin̈ syac'och d'a yopisio chi'. ");
INSERT INTO cac_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Masanil ix sb'o eb' israel icha val ix aj yalan Jehová d'a vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ayic ix yilan vin̈aj Moisés chi' to icha chi' ix aj sb'oel yuj eb', ix yalan vach' lolonel vin̈ d'a yib'an̈ eb'. ");
INSERT INTO cac_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ix lolon Jehová d'a vin̈aj Moisés, ix yalan d'a vin̈ icha tic: ");
INSERT INTO cac_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","D'a b'ab'el c'ual yic b'ab'el uj, ata' sb'oq'ue in cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Slajvi chi', tz'ac'chajoch te' scaxail trato d'a yool chi', tz'ac'chajoch c'apac cortina smaculoc. ");
INSERT INTO cac_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Tz'ac'chajpaxoch te' mexa yed' tas tz'em d'a yib'an̈ yed' sb'achnub' candil, tz'ochpax sc'ac'al candil chi'. ");
INSERT INTO cac_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","A d'a yichan̈ scaxail trato tz'och altar oro b'aj stz'a incienso, slocb'ajq'ue c'apac cortina d'a sti' mantiado chi'. ");
INSERT INTO cac_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Sb'ochajpaxem jun altar b'aj stz'a silab' d'a yichan̈elta sti' mantiado chi'. ");
INSERT INTO cac_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Tz'ac'chajem jun nivan palangana d'a scal mantiado yed' altar, tz'ac'ji b'ud'joc yed' a a'. ");
INSERT INTO cac_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Slajvi chi', sb'ochajoch c'apac cortina smaculoc spatictac yamaq'uil, axo c'apac tz'och d'a sti' yamaq'uil chi' sq'uepax locan c'apac. ");
INSERT INTO cac_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Tzic'ancot aceite sc'anchaji a sic'chajel junoc mach, ma junoc tas. Tza secanem d'a yib'an̈ in cajnub' yed' d'a masanil tastac ayoch d'a yool. Icha chi' tz'aj yochcan masanil syamc'ab'il d'a yopisio, yic vach' vicxo tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Tza secanpaxem aceite chi' d'a yib'an̈ altar b'aj stz'a silab' yed' masanil syamc'ab'il. Icha chi' tz'aj yochcan d'a yopisio, yuj chi' a jun altar chi' vicxo tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Tza secanpaxem aceite chi' d'a yib'an̈ jun nivan palangana yed' sb'achnub'al yich yic vach' vicxo tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Slajvi chi', tzic'anb'at vin̈aj Aarón yed' eb' yuninal d'a sti' mantiado chi', tza checan sb'ic sb'a eb' ta'. ");
INSERT INTO cac_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Slajvi chi', tzac'anoch spichul vin̈aj Aarón chi' yic yopisio. Tzac'anoch aceite d'a vin̈ yic tz'ochcan yopisio vin̈ d'a sacerdoteal d'ayin. ");
INSERT INTO cac_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Sjapax eb' yuninal vin̈ chi' d'a a tz'ey, tzac'anoch spichul eb'. ");
INSERT INTO cac_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Tzac'anpaxoch aceite d'a eb' icha tzutej vin̈aj Aarón chi', yic vach' tz'ochcan eb' sacerdoteal d'ayin. Tz'ac'jioch aceite chi' d'a eb' yic scan jun opisio chi' d'a yol sc'ab' eb', ol b'eyn̈ejb'at d'a yin̈tilal eb' d'a masanil tiempo, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Icha ix aj yalan Jehová, icha val chi' ix aj sb'oan vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ayic ix schaanel yich yic schab'il ab'il yelta eb' d'a Egipto, d'a val sb'ab'el c'ual yic b'ab'el uj ix b'ojiq'ue scajnub' Dios. ");
INSERT INTO cac_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Ix yalan vin̈aj Moisés chi' to tz'ac'jiem q'uen sb'achnub'al yich, ix ac'jiem te' marco d'a yib'an̈ q'ueen, ix ac'jipaxoch sreglail, ix ic'jiq'ue vaan te' oy d'a yib'an̈ sb'achnub'al ayxoem chi'. ");
INSERT INTO cac_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ix ac'jib'at jen̈an c'apac mantiado d'a yib'an̈ scajnub' Dios chi', ix ac'jib'at juntzan̈xo d'a yib'an̈ mantiado icha ix aj yalan Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ix lajvi chi, ix yac'anem chab' pachan̈ q'uen q'ueen vin̈aj Moisés chi' d'a yol scaxail trato, aton q'uen b'aj tz'ib'ab'iloch lajun̈e' checnab'il. Ix yac'anoch te' sb'achlab'il te' caxa chi' vin̈, ix yac'anpaxem smacul te' vin̈, aton b'aj tz'ac'ji tup mul. ");
INSERT INTO cac_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ix lajvi chi', ix ic'jib'at te' d'a yol scajnub' Dios, ix ac'jioch c'apac cortina d'a snan̈al yol scajnub' chi', yic tz'och smaculoc te' caxa chi', icha ix aj yalan Jehová d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ix ac'jipaxoch te' mexa d'a co vach' d'a yol mantiado b'aj sch'ox sb'a Dios. ");
INSERT INTO cac_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Vach' ix aj yac'jiem ixim pan d'a sat te' mexa d'a yichan̈ Jehová, icha ix aj yalan d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ix ac'jipaxoch q'uen sb'achnub' candil d'a co q'uexan̈ d'a yichan̈ mexa d'a yol mantiado b'aj sch'ox sb'a Dios. ");
INSERT INTO cac_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ix ac'jioch sc'ac'al candil d'a yichan̈ Jehová, icha ix aj yalan d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ix ac'jipaxoch altar oro d'a yichan̈elta c'apac cortina chi'. ");
INSERT INTO cac_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Ix sn̈usantz'a incienso vin̈aj Moisés chi' d'a yib'an̈ altar chi', icha ix aj yalan Jehová. ");
INSERT INTO cac_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ix lajvi chi', ix ac'chajoch c'apac cortina smaculoc b'aj tz'och eb' sacerdote d'a yol cajnub' chi'. ");
INSERT INTO cac_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ix ac'chajem altar b'aj sn̈usjitz'a silab' d'a yichan̈elta sti' mantiado b'aj sch'ox sb'a Jehová. Ix lajvi chi' ix sn̈usantz'a noc' silab' vin̈aj Moisés chi' yed' ixim harina icha ix aj yalan Jehová. ");
INSERT INTO cac_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ix ac'jioch q'uen nivan palangana d'a scal mantiado yed' altar. Ix ac'ji b'ud'joc q'uen d'a a a' yic sb'ic sc'ab' eb' yed' yoc. ");
INSERT INTO cac_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","A d'a a a' chi' ix sb'ic sc'ab' vin̈aj Moisés chi' yed' yoc. An̈eja' pax vin̈aj Aarón yed' eb' yuninal sb'ic sc'ab' eb' yed' yoc, ");
INSERT INTO cac_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ayic tz'och eb' d'a yol mantiado. Sb'icpax sc'ab' eb' yed' yoc chi' ayic tz'och eb' d'a altar, icha val ix aj yalan Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","D'a slajvub'alxo ix b'ochajoch yamaq'uil spatic yichan̈ scajnub' Dios yed' altar. Ix lajvi chi' ix ac'chajoch c'apac c'apac smaculoc d'a sti' amac' chi'. Icha val chi' ix aj sb'ocanel masanil tas ix alchaj d'a vin̈aj Moisés chi' yuj Jehová. ");
INSERT INTO cac_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ayic ix lajvi sb'oel smasanil, ix emul asun d'a yib'an̈ mantiado b'aj sch'ox sb'a Jehová, ix em stziquiquial d'a yib'an̈ scajnub' chi' yed' d'a yool. ");
INSERT INTO cac_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Yuj chi' maj yal-laj yoch vin̈aj Moisés d'a yool chi', yujto ayec' jun asun chi' d'a yib'an̈, macb'il yool chi' yuj stziquiquial Jehová. ");
INSERT INTO cac_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ayic sq'ue vaan asun chi' d'a yib'an̈ scajnub' Jehová chi' syic'anq'ue vaan smantiado eb' israel, sb'eyb'at eb'. ");
INSERT INTO cac_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Tato max q'ue vaan asun chi' jun, max yic'q'uelaj vaan scampamento eb', ato sq'ue vaan ichato chi' sb'at eb'. ");
INSERT INTO cac_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Yaln̈ej b'ajtil ayec' eb' israel d'a yol b'e, syil val jun asun chi' eb' d'a yib'an̈ scajnub' Jehová d'a c'ualil, axo d'ac'valil ayoch sc'ac'al asun chi' syil eb'. ");
INSERT INTO cac_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ix avtaj vin̈aj Moisés yuj Jehová d'a yol mantiado, ix schecan yal juntzan̈ checnab'il vin̈ d'a eb' yetisraelal. ");
INSERT INTO cac_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Yuj chi' ix yalan vin̈aj Moisés chi' icha tic: Tato ay junoc ex tzeyic'cot junoc noc' noc' yic sn̈uschajtz'a smasanil silab'il d'a Jehová, a d'a scal noc' e vacax, d'a scal noc' e calnel ma d'a scal noc' e chiva, ata' tzeyic'cot noc'. ");
INSERT INTO cac_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Tato vacax noc' tze n̈ustz'a silab'il chi', yovalil a junoc noc' toro malaj spaltail tzeyic'coti. A jun silab' stz'ai, a jun chi' to stz'ab'at noc' noc' chi' smasanil. A d'a yichan̈ mantiado b'aj sch'ox sb'a Jehová, ata' tzeyac'och silab' chi' yic vach' schaji yuj Jehová. ");
INSERT INTO cac_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Yovalil tzeyac'q'ue e c'ab' d'a sjolom noc', yic schaji noc' yuj yac'ji lajvoc e mul. ");
INSERT INTO cac_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","A mach ay yic noc' chi', a smilancham noc' d'a yichan̈ Jehová, axo eb' sacerdote yuninal vin̈aj Aarón tz'ic'ancot schiq'uil noc', stzicanoch eb' d'a schan̈il pac'an̈ jun altar ayec' d'a yichan̈ mantiado. ");
INSERT INTO cac_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","An̈eja' vin̈ ay yic noc' chi' spatz'anel noc', schoc' xicanb'at noc' vin̈. ");
INSERT INTO cac_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Axo eb' sacerdote yuninal vin̈aj Aarón chi', syac'q'ue te' c'atzitz eb' d'a yib'an̈ te' tzac'ac' d'a altar chi' yic sq'ue sc'ac'al. ");
INSERT INTO cac_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Tz'ac'jiq'ue noc' chib'ej cotac xicab'il chi' d'a yib'an̈ te' c'atzitz chi' yed' noc' sjolom yed' noc' xepu' tz'ic'jiel d'a noc' yol sc'ool. ");
INSERT INTO cac_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","A mach tz'ac'an noc' silab' chi', yovalil a smaxan noc' yol sc'ool, sb'icanel noc' yoc, axo vin̈ sacerdote sn̈usantz'a jun silab' chi' smasanil d'a yib'an̈ altar. Suc'uq'ui sjab' jun silab' stz'a chi' syab' Jehová. ");
INSERT INTO cac_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Tato calnel, ma chiva noc' tzeyac' silab'il chi', yovalil ch'aac noc', malajocab' jab'oc spaltail noc'. ");
INSERT INTO cac_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","A d'a stojolal norte d'a jun altar chi', ata' smiljicham noc' yuj mach tz'ac'an noc' chi' d'a yichan̈ Jehová. Axo eb' yuninal vin̈aj Aarón chi' stzicanoch schiq'uil noc' d'a schan̈il pac'an̈ jun altar chi'. ");
INSERT INTO cac_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Slajvi chi' slaj cotac xicajb'at noc', axo vin̈ sacerdote tz'ac'anq'ue noc' cotac xicab'ilxo yaj chi' d'a yib'an̈ c'ac' d'a yib'an̈ altar yed' noc' sjolom yed' noc' xepu' tz'el d'a noc' yol sc'ool. ");
INSERT INTO cac_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Axo jun mach tz'ac'an noc' silab' chi', yovalil a smaxan noc' yol sc'ool, sb'icanpaxel noc' yoc, axo vin̈ sacerdote sn̈usantz'a smasanil d'a yib'an̈ altar. Suc'uq'ui sjab' jun silab' stz'a chi' syab' Jehová. ");
INSERT INTO cac_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Tato much noc' silab' sn̈usjitz'a smasanil d'a yichan̈ Jehová, yovalil a junoc noc' paramuch yaln̈ej tas macan̈il. ");
INSERT INTO cac_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","A vin̈ sacerdote tz'ic'ancot noc' silab' chi' d'a altar, stoc'anel sjolom noc' vin̈, sn̈usjitz'a noc'. Axo schiq'uil noc', stzicoch vin̈ d'a spac'ul altar. ");
INSERT INTO cac_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Tz'ic'jielta masanil yooch noc' yed' tas ay d'a yool, syumjicanb'at d'a stz'eyb'at altar d'a stojolal b'aj sjavi c'u, aton b'aj smolchaj q'uen tic'aq'uil taan̈. ");
INSERT INTO cac_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Slajvi chi' syamji sc'axil noc' yic sjecchitanb'at jab'oc noc' vin̈, palta max chab'axlaj snan̈al noc', sn̈usantz'a noc' vin̈ sacerdote d'a yib'an̈ te' c'atzitz ayq'ue d'a yib'an̈ altar chi'. Suc'uq'ui sjab' jun silab' stz'a chi' syab' Jehová. ");
INSERT INTO cac_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Tato ay junoc ex tzeyic'cot ixim harina ofrendail d'a Jehová, a val ixim harina te vach' tzeyic'coti. A d'a yib'an̈ ixim chi' tzeyaq'uem aceite yed' incienso, ");
INSERT INTO cac_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","tzeyic'ancot d'a eb' sacerdote yin̈tilal vin̈aj Aarón. A junoc eb' sacerdote ayoch d'a yopisio tz'ic'anq'ue junoc b'echan̈ ixim harina yed' aceite yed' pax masanil incienso. Slajvi chi' sn̈usjitz'a jun silab' chi' d'a yib'an̈ altar, yuj sch'oxchaji to a' silab' chi' yic Jehová yaji. Suc'uq'ui sjab' jun ofrenda chi' syab' Jehová. ");
INSERT INTO cac_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Axo jab'ocxo jun ofrenda chi' yicxo eb' vin̈ sacerdote yaji. Nivan yelc'ochi, yujto yetb'eyum sb'a yed' jun silab' sn̈usjitz'a d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","A tz'ac'ji junoc ofrenda c'anb'inac d'a yol horno, aocab' ixim harina te vach', malaj yich sb'at d'a scal. Syal pim tz'aj sb'oji, scalaj yed' aceite, syalpax yoch d'a c'oxoxal to malaj yich, succhajec' aceite d'ay. ");
INSERT INTO cac_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Tato a jun ofrenda chi' mayb'il d'a yol xalten, aocab' ixim harina yelxo val te vach', calab'il yed' aceite, palta mocab'a yich ayb'ati. ");
INSERT INTO cac_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Scotac xepchitaji, slajvi chi' tz'och aceite d'ay, yujto ofrenda d'a tas svaji. ");
INSERT INTO cac_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Tato tzeyac' junoc ofrenda tajinac d'a scal aceite, aocab' yed' ixim harina te vach', calab'il yed' aceite tzeyac'a'. ");
INSERT INTO cac_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ayic toxo ix b'oel jun ofrenda chi', tzeyic'ancot d'a Jehová, tzeyac'an d'a vin̈ sacerdote, axo vin̈ tz'ic'anb'at d'a altar. ");
INSERT INTO cac_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Ata' sn̈ustz'a jab'oc jun ofrenda chi' vin̈ yic ch'oxnab'il to a ofrenda chi' yic Jehová yaji. Suc'uq'ui sjab' jun silab' chi' syab' Jehová. ");
INSERT INTO cac_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Axo jab'ocxo jun ofrenda chi', yic eb' sacerdote tz'ajcani. Nivan yelc'ochi, yujto yetb'eyum sb'a yed' juntzan̈ ofrenda sn̈usjitz'a d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Masanil juntzan̈ ofrenda tzeyac' d'a Jehová d'a tastac svaji, malajocab' yich ayb'at d'a scal. Max yal-laj sn̈usjitz'a tas silab'il d'a yichan̈ Jehová tato ayb'at yich pan, ma noc' yalchab' d'a scal. ");
INSERT INTO cac_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Syal eyac'an ixim pan ayb'at yich d'a scal yed' tas ayb'at noc' yalchab' d'a scal d'a ofrendail a tz'ac'ji b'ab'el sat avb'en, palta max n̈usjitz'alaj d'a yib'an̈ altar silab'il b'aj stz'a silab' suc'uq'ui sjab' syab' Jehová. ");
INSERT INTO cac_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Masanil ofrenda tzeyac' d'a tas svaji, yovalil sb'at yatz'amil, malaj junoc ofrenda chi' to max b'at yatz'amil, yujto a atz'am atz'am chi' sch'oxanel co trato yed' co Diosal. Yuj chi' masanil ofrenda tzeyac' d'a tas svaji chi', ayn̈ejocab'och yatz'amil. ");
INSERT INTO cac_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Tato tzeyac' junoc ofrenda d'a Jehová d'a sb'ab'el sat eyavb'en, yovalil a jayeoc jolom trigo sc'anb'i d'a scal c'ac', yaxto val svuchchajeli. ");
INSERT INTO cac_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","A d'a yib'an̈ jun ofrenda chi', tzeyac'och aceite yed' incienso, yujto a ofrenda chi' a ixim trigo, ma ixim cebada. ");
INSERT INTO cac_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","A junoc vin̈ sacerdote sn̈usantz'a jab'oc ixim vuchb'ilel chi' yed' aceite yed' pax masanil incienso. A jab'oc chi' sch'oxani to a ofrenda chi' yic Jehová yaji. ");
INSERT INTO cac_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Tato ay junoc ex tzeyac' junoc snun e vacax, ma junoc noc' toro silab'oc yic tze ch'oxani to ay e junc'olal yed' Jehová, yovalil tzeyic'cot noc' d'a yichan̈ Jehová. A jun noc' noc' chi' yovalil malaj jab'oc spaltail noc'. ");
INSERT INTO cac_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ayic tzeyac'an junoc ofrenda chi', tzeyic'b'at noc' d'a yichan̈ mantiado b'aj sch'ox sb'a Jehová. Ata' tzeyac'q'ue e c'ab' d'a sjolom noc', slajvi chi' tze milancham noc'. Axo junoc eb' vin̈ sacerdote stzicanoch schiq'uil noc' d'a schan̈il pac'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Tato ay junoc ex tzeyac' junoc noc' silab' yic junc'olal, tzeyiq'uel junoc macan̈ d'a noc' silab' chi', yic sn̈usjitz'a d'a yichan̈ Jehová, aton juntzan̈ tic tzeyiq'ueli: Masanil xepu' ayoch d'a noc' yol sc'ool, ");
INSERT INTO cac_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","chab' stut noc' yed' xepual, xepu' ayoch d'a spatictac sb'aquil yich spatic noc' yed' xepu' ayoch d'a yib'an̈ seyub' noc'. ");
INSERT INTO cac_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Axo junoc eb' vin̈ sacerdote sn̈usantz'a masanil juntzan̈ chi' silab'il d'a yib'an̈ junxo silab' van stz'a d'a yib'an̈ te' c'atzitz d'a yib'an̈ altar, suc'uq'ui sjab' syab' Jehová. ");
INSERT INTO cac_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Tato tzeyac' junoc noc' calnel ma junoc noc' chiva d'a Jehová silab'il yic tze ch'oxan e junc'olal yed'oc, syal eyac'an noc' ch'aac ma noc' snun, an̈ej tato malaj jab'oc spaltail noc'. ");
INSERT INTO cac_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ayic tzeyac'an noc' calnel chi' silab'il d'a yichan̈ Jehová, ");
INSERT INTO cac_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","tzeyac'q'ue e c'ab' d'a sjolom noc'. Slajvi chi' tze milancham noc' d'a yichan̈ mantiado b'aj sch'ox sb'a Jehová. Axo junoc eb' vin̈ sacerdote stzicanoch schiq'uil noc' d'a schan̈il pac'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","A junoc mach ex tzeyac' junoc noc' silab' chi', tzeyiq'uel junoc macan̈ d'a noc' yic sn̈usjitz'a d'a yichan̈ Jehová, aton juntzan̈ tic tz'ic'jieli: Xepual sn̈e noc', vach' tz'aj yic'jiel smasanil yed' xepu' ayoch d'a noc' yol sc'ool, ");
INSERT INTO cac_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","stut noc' yed' pax xepu' ayoch d'ay, xepu' ayoch d'a yich spatic noc' yed' xepu' ayoch d'a yib'an̈ seyub' noc', junn̈ej tz'aj yic'jiel yed' noc' stut chi'. ");
INSERT INTO cac_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Slajvi chi', axo vin̈ sacerdote sn̈usantz'a juntzan̈ chi' smasanil silab'oc d'a yichan̈ Jehová to icha junoc vael yaji. ");
INSERT INTO cac_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Tato chiva noc' tzeyac' e silab'oc chi', tzeyic'cot noc' d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Axo mach ex tzeyac' noc' chi', tzeyac'q'ue e c'ab' d'a sjolom noc', tze milancham noc' d'a yichan̈ mantiado. Axo eb' vin̈ sacerdote stzicanoch schiq'uil noc' d'a schan̈il pac'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","15","A ex mach ex tzeyac' junoc noc' silab' chi', tzeyiq'uel junoc macan̈ d'a noc', yic sn̈usjitz'a d'a yichan̈ Jehová, aton juntzan̈ tic: Masanil xepu' ayoch d'a noc' yol sc'ool, d'a spatictac sb'aquil yich spatic noc' yed' xepu' ayoch d'a spatic seyub' noc' yed' stut noc' schab'il yed' xepual. ");
INSERT INTO cac_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Axo vin̈ sacerdote sn̈usantz'a juntzan̈ chi' smasanil d'a yib'an̈ altar, icha junoc vael sn̈usjitz'aoc, suc'uq'ui sjab' syab' Jehová. Masanil xepual noc' yic Jehová yaji. ");
INSERT INTO cac_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Man̈ e chi xepu' yed' pax schiq'uil noc'. A jun tic ley tz'ajcan d'ayex d'a juneln̈ej yed' d'a eyin̈tilal, yaln̈ej b'ajtil ayex eq'ui, xa chi, xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' to syal juntzan̈ checnab'il tic vin̈ d'a eb' yetisraelal. Yuj chi' ix yal vin̈ icha tic: ");
INSERT INTO cac_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Tato ay mach tz'och smul, man̈ sc'anoc sc'ool, sc'ulan tastac ay yovalil, ato a' syal schecnab'il Jehová, yovalil sc'anab'ajej masanil juntzan̈ tastac ol val tic: ");
INSERT INTO cac_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Tato a vin̈ sat sacerdote tz'och smul ayic ayoch vin̈ d'a yopisio, a smul vin̈ chi' tz'empax d'a yib'an̈ eb' chon̈ab', yovalil syac' junoc noc' quelem vacax vin̈ silab'oc d'a Jehová yuj smul chi'. A noc' vacax syac' vin̈ chi', a noc' malaj jab'oc spaltail. ");
INSERT INTO cac_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Syic'ancot noc' vin̈ d'a yichan̈ mantiado b'aj sch'ox sb'a Jehová. Syac'anq'ue sc'ab' vin̈ d'a sjolom noc', smilancham noc' vin̈ d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","A vin̈ tz'ic'ancot jab'oc schiq'uil noc' syic'anoch vin̈ d'a yol mantiado chi'. ");
INSERT INTO cac_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Syaq'uem yiximal sc'ab' vin̈ d'a scal schiq'uil noc' chi'. Uquel stziquem vin̈ d'a yichan̈ Jehová d'a yichan̈elta c'apac cortina ayoch b'aj ay lugar An̈ej Jehová Ay Yico'. ");
INSERT INTO cac_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Sucanoch jab'oc schiq'uil noc' chi' vin̈ d'a sch'ac altar yic incienso ayoch d'a yichan̈ Jehová d'a yol mantiado. Axo masanil chic' tzato can chi', seccanem vin̈ d'a yichtac yoc altar b'aj sn̈usjitz'a silab', aton jun ayem d'a yichan̈ mantiado chi'. ");
INSERT INTO cac_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Slajvi chi' tz'ic'jiel masanil xepu' d'a noc' yol sc'ool, ");
INSERT INTO cac_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","yed' chab' stut noc' yed' xepual yed' pax masanil xepual sb'aquil yich spatic noc' yed' xepu' ayoch d'a yib'an̈ seyub' noc', ");
INSERT INTO cac_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","icha val tz'aj yic'jiel d'a noc' vacax tz'ac'ji silab'oc yic sch'oxan junc'olal yed' Dios. Slajvi chi', sn̈usjitz'a d'a yib'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Axo noc' stz'umal, noc' sb'ac'chil, noc' sjolom, noc' xub', noc' yoc, masanil noc' yol sc'ool yed' masanil sch'an̈tza' noc', ");
INSERT INTO cac_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","syalelc'ochi masanil noc' silab' chi', tz'ic'jiel d'a junoc lugar to vach' yaj d'a spatiquel campamento, aton b'aj secchajtaxonel q'uen tic'aq'uil taan̈. Ata' sn̈usjitz'a noc' d'a yib'an̈ te' c'atzitz. ");
INSERT INTO cac_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Tato co masanil a on̈ chon̈ab' israel on̈ tic tz'och co mul, man̈ sc'anoc co c'ool, malaj pax junoc on̈ snachajel cuuj to man̈ ichoc yalan schecnab'il Jehová ix co c'ulej, yuj chi' tz'och co mul, ");
INSERT INTO cac_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ayic squilancot co b'a to ix och co mul, yovalil scac' junoc noc' quelem vacax silab'il co masanil yic tz'ac'ji tup co mul chi' d'a quib'an̈. Squic'anb'at noc' d'a yichan̈ mantiado b'aj sch'ox sb'a Jehová. ");
INSERT INTO cac_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Ata' syac'q'ue sc'ab' eb' yichamtac vinaquil chon̈ab' d'a sjolom noc' d'a yichan̈ Jehová, smiljicham noc' ta'. ");
INSERT INTO cac_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Axo vin̈ sat sacerdote tz'ic'ancot jab'oc schiq'uil noc' chi' d'a yol junoc yed'tal syic'anoch vin̈ d'a yol mantiado, ");
INSERT INTO cac_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","slab'anem yiximal sc'ab' vin̈ d'a scal schiq'uil noc' chi' stzicanem uqueloc vin̈ d'a yichan̈ Jehová d'a yichan̈elta c'apac cortina. ");
INSERT INTO cac_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Sucanec' jab'oc schiq'uil noc' chi' vin̈ d'a sch'ac altar b'aj stz'a incienso, aton ayec' d'a yichan̈ Jehová d'a yol mantiado chi'. Axo jantacto schiq'uil noc' tzato cani, stob'jicanec' d'a yich yoc altar b'aj sn̈usjitz'a silab', aton jun ayec' d'a yichan̈ mantiado chi'. ");
INSERT INTO cac_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Slajvi chi' tz'ic'jiel masanil xepual noc' silab' chi', sn̈usjitz'a d'a yib'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Syalelc'ochi, to icha val tz'aj noc' quelem vacax syac' vin̈ sat sacerdote yuj smul icha chi' tz'ajpax noc' tz'ac'ji chi' yuj smul eb' anima smasanil. Icha chi' syutej vin̈ sat sacerdote chi' sb'oan silab' yuj slajvicanel co mul d'a quib'an̈ a on̈ tic. ");
INSERT INTO cac_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Slajvi chi' tz'ic'jiel noc' silab' chi' d'a spatiquel campamento. Ata' sn̈usjitz'a noc', icha val tz'utaj noc' b'ab'el quelem vacax chi', yujto a jun silab' chi' tz'ac'ji yuj yac'ji lajvoc co mul co masanil. ");
INSERT INTO cac_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Tato ay junoc vin̈ yajal tz'och smul, man̈ sc'anoc sc'ol vin̈ yic sc'ulan tastac to man̈ ichocta' yalan schecnab'il Jehová, ");
INSERT INTO cac_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ayic snachajel yuj vin̈ to ix och smul vin̈, yovalil syic'cot junoc noc' mam chiva vin̈ silab'il yuj smul ix och chi'. A noc' syic'cot vin̈ chi' a noc' malaj jab'oc spaltail. ");
INSERT INTO cac_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Syac'q'ue sc'ab' vin̈ d'a sjolom noc', smilancham noc' vin̈ d'a yichan̈ Jehová, aton b'aj smiljitaxon noc' noc' sn̈usjitz'a silab'il, yujto silab' yuj smul vin̈ yaj noc'. ");
INSERT INTO cac_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Axo junoc vin̈ sacerdote tz'ic'ancot schiq'uil noc' silab' chi', sucanoch vin̈ d'a sch'ac altar b'aj sn̈usjitz'a silab', axo jantacto chic' scani, stob'ancanec' vin̈ d'a yich yoc altar chi'. ");
INSERT INTO cac_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Sn̈usjitz'a smasanil xepual noc' d'a yib'an̈ altar, icha val tz'aj silab' tz'ac'ji yuj sch'oxji junc'olal yed' Dios. Icha chi' syutej vin̈ sacerdote sb'oan jun silab' chi' yic tz'ac'ji tup smul jun vin̈ yajal d'a chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Tato ay junoc comon anima tz'och smul, man̈ sc'anoc sc'ool yic sc'ulan tastac to man̈ ichocta' yalan schecnab'il Jehová, ");
INSERT INTO cac_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ayic snachajel yuuj to ix och smul, yovalil syic'cot junoc noc' nun chiva silab'il yuj smul ix och chi'. A noc' syic'cot chi', a noc' malaj jab'oc spaltail. ");
INSERT INTO cac_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Syac'q'ue sc'ab' d'a sjolom noc', slajvi chi' smilancham noc' b'aj smiljitaxoncham noc' noc' sn̈usjitz'a silab'il. ");
INSERT INTO cac_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Axo junoc vin̈ sacerdote tz'ic'ancot schiq'uil noc', sucanoch vin̈ d'a sch'ac altar b'aj sn̈usjitz'a silab', axo jantacto schiq'uil noc' scani, stob'ancanec' vin̈ d'a yich yoc altar chi'. ");
INSERT INTO cac_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Slajvi chi' tz'ic'jiel masanil xepual noc' silab' chi', icha val tz'aj yic'jiel yic noc' silab' tz'ac'ji yuj sch'oxan sjunc'olal yed' Dios. Sn̈usjitz'a xepual noc' chi' silab'il d'a yichan̈ Jehová to suc'uq'ui sjab'. Icha chi' syutej vin̈ sacerdote sb'oan jun silab' chi' yic tz'ac'ji tup smul jun anima chi'. ");
INSERT INTO cac_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Tato a noc' calnel syic'cot jun mach tz'ac'an jun silab' chi', a junoc noc' snun malaj jab'oc spaltail syic'coti. ");
INSERT INTO cac_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Yovalil syac'q'ue sc'ab' d'a sjolom noc' calnel chi', smilancham noc' b'aj smiljitaxoncham noc' noc' sn̈usjitz'aoc. ");
INSERT INTO cac_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Axo junoc vin̈ sacerdote tz'ic'ancot schiq'uil noc', sucanoch vin̈ d'a sch'ac altar b'aj sn̈usjitz'a silab', axo jantacto schiq'uil noc' scani, stob'canec' vin̈ d'a yich yoc altar chi'. ");
INSERT INTO cac_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Slajvi chi' tz'ic'jiel masanil xepual noc' silab' chi', icha val tz'aj yic'jiel yic noc' silab' tz'ac'ji yuj sch'oxan sjunc'olal yed' Dios. Sn̈usjitz'a xepual noc' chi' d'a yib'an̈ altar, d'a yib'an̈ juntzan̈xo silab' to stz'ataxon d'a yichan̈ Jehová. Icha chi' syutej jun vin̈ sacerdote sb'oan jun silab' chi' yic tz'ac'ji tup smul jun anima chi'. ");
INSERT INTO cac_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Q'uinaloc ay junoc mach tz'avtaj yuj yalani ma yac'an testigoal sb'a d'a junoc tas ix yila', ma ix yab'i, palta tato max yalelta yuj tas ix yil chi', ma tas ix yab' chi', a jun chi' tz'och smuloc scann̈ej d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","An̈ejtona' tato ay junoc mach syaman junoc tas man̈ vach'oc icha yalan ley, tz'och smul. Q'uinaloc suquec' sb'a d'a snivanil junoc chamnac noc', vach'chom caltacte'al noc', ma molb'etzal noc', ma junoc noc' tz'ec' n̈ern̈onoc, a junoc mach icha chi' sc'ulej, man̈ vach'oc tz'aji. Tz'och smul, vach'chom max yab'i tato ix suquec' sb'a d'a noc' chamnac noc' chi'. ");
INSERT INTO cac_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Q'uinaloc ay mach syaman junoc tas tz'el d'a anima, man̈ vach'oc tz'ajcan yuuj icha yalan ley, max nachajel yuj d'a jun rato chi', palta ayic snachajel yuuj, tz'och jun chi' smuloc. ");
INSERT INTO cac_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Q'uinaloc ay junoc mach syac' sti' d'a yalxon̈ej tas lolonelal d'a elan̈chamel, tato max cham val snaani syac'an sti' chi', max yaq'uelc'och tas ix yal chi', palta ayic snachajel yuuj, toxo ix och juntzan̈ chi' smuloc. ");
INSERT INTO cac_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","A mach tz'och junoc smul d'a juntzan̈ tastac tic, yovalil scha smuloc, ");
INSERT INTO cac_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","syac'an junoc noc' nun calnel silab'oc yuj smul ix och chi', ma junoc noc' nun chiva. A jun silab' chi', sn̈ustz'a vin̈ sacerdote yic slajvicanel smul jun anima chi'. ");
INSERT INTO cac_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Tato malaj stumin jun anima chi' b'aj sman junoc noc' calnel, ma junoc noc' chiva chi', yovalil syic'cot chavan̈oc noc' paramuch, yaln̈ej tas macan̈il d'a yichan̈ Jehová yuj smul ix och chi'. Jun noc' tz'och yuj smul chi', junocxo noc' sn̈usjitz'a smasanil silab'il. ");
INSERT INTO cac_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","B'ab'el sn̈usjitz'a noc' tz'ac'ji yuj smul chi' yuj vin̈ sacerdote, ton̈ej sch'umjiel sjaj noc', palta max el-laj d'a juneln̈ej. ");
INSERT INTO cac_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Slajvi chi', sucjioch jab'oc schiq'uil noc' d'a spatictac altar, axo jantacto schiq'uil noc' scani, tz'ac'jicanoch d'a yich yoc altar chi', yujto silab' yuj mul yaji. ");
INSERT INTO cac_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Axo junxo noc' schab'il chi', sn̈usjitz'a noc' icha sleyal. Icha chi' tz'aj sb'oan silab' vin̈ sacerdote yuj slajvican smul jun anima chi'. ");
INSERT INTO cac_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Tato malaj stumin jun anima chi' b'aj sman chavan̈oc noc' paramuch chi', yovalil syic'cot chan̈eoc libra ixim harina te vach', max b'atlaj aceite yed' incienso d'a scal, yujto ofrenda yuj mul yaji. ");
INSERT INTO cac_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Yovalil syic'cot d'a vin̈ sacerdote, axo vin̈ tz'ic'ancot junoc b'echan̈ ixim harina chi' yic stz'a d'a yib'an̈ altar yuj sch'oxaneli to masanil jun ofrenda chi' yic Jehová yaji. Sn̈usjitz'a d'a altar d'a yib'an̈ juntzan̈xo ofrenda van stz'a d'a yichan̈ Jehová. A jun ofrenda chi' yuj mul tz'ac'ji. ");
INSERT INTO cac_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Icha chi' tz'aj sb'oan jun silab' chi' junoc vin̈ sacerdote yuj slajvicanel smul jun anima chi'. A jantacto scani, yicxo vin̈ sacerdote chi', icha sc'ulej yed' juntzan̈ vael tz'ac'ji d'a ofrendail, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ix schec Jehová yal vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Q'uinaloc ay junoc mach max ic'ancot tastac yictaxon Jehová yaji, vach'chom man̈ sc'anoc sc'ool tz'och smul. A jun anima chi' yovalil syic'cot junoc noc' ch'ac calnel malaj jab'oc spaltail, syac'an noc' silab'il d'a Jehová yuj smul chi'. Yovalil snaji jantac stojol noc' ch'ac calnel chi' d'a q'uen plata, icha q'uen sc'anchaj d'a scajnub' Dios. ");
INSERT INTO cac_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","A jun anima chi' yovalil stup tastac yictaxon Jehová yaj maj yic'cot chi', syac'an jab'ocxo stojol d'a yib'an̈ juntzan̈ toxo ix yac' chi' d'a vin̈ sacerdote yed' noc' calnel tz'ac'ji d'a silab'il yuj smul chi'. Icha chi' tz'aj sb'oan silab' jun vin̈ sacerdote yuj slajvicanel smul jun anima chi'. ");
INSERT INTO cac_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Q'uinaloc ay junoc mach tz'och smul d'a checnab'il ix yac' Jehová vach'chom man̈ sc'anoc sc'ool, a jun chi' ayxo och smuloc. ");
INSERT INTO cac_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Yuj chi' syic'cot junoc silab' d'a junoc eb' vin̈ sacerdote yic stupan smul chi'. Syic'cot junoc noc' ch'ac calnel malaj jab'oc spaltail. A vin̈ sacerdote chi' snaani to c'ocb'il syab' stojol noc' chi' d'a icha val stojol tas stupchaj chi', an̈eja' vin̈ sb'oan jun silab' chi'. Icha chi' tz'aj slajvicanel smul ix och chi'. ");
INSERT INTO cac_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Aton silab' yuj stupchaj smul chi', yujto a jun anima chi' ay smul d'a yichan̈ Jehová, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ix schec Jehová yal vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Q'uinaloc ay junoc mach tz'och smul d'a yichan̈ Jehová, yic syixtan yetanimail d'a junoc tas scan ab'enal d'ay, ma syelq'uej junoc tasi, mato ton̈ej sc'ub'ejeli, ");
INSERT INTO cac_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","mato sic' junoc tasi stec'b'an sb'a yalani to malaj tas syila', ma stec'b'an sb'a yalan junoc tas man̈ yeloc, ma sc'ulej junocxo chucal sc'ulej eb' anima icha juntzan̈ tic, yovalil syac' junoc silab'. ");
INSERT INTO cac_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","Axo yic snachaji to ay smul d'a junoc juntzan̈ tic, yovalil syac'xi masanil stojol d'a mach ay yico', syac'an jab'ocxo stojol d'a yib'an̈ juntzan̈ toxo ix yac' chi' d'a mach ay yico'. Syac'anpax junoc silab' d'a Jehová yuj smul tz'och chi'. ");
INSERT INTO cac_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","A silab' syac' chi', aton junoc noc' ch'ac calnel malaj jab'oc spaltail, ma a tumin icha stojol junoc noc' ch'ac calnel chi' tz'ac'ji d'a vin̈ sacerdote. ");
INSERT INTO cac_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Axo vin̈ tz'ac'anoch jun silab' chi' d'a yichan̈ Jehová yuj smul jun anima ix och chi', axo jun mul chi' slajvicanel d'a yib'an̈, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ix schec Jehová yal vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Al d'a vin̈aj Aarón yed' d'a eb' yuninal yuj tas tz'aj yac'ji jun silab' to sn̈usjitz'a smasanil d'a junjun yemc'ualil. A noc' noc' sn̈usjitz'a smasanil d'a silab'il chi', yovalil ayq'ue noc' d'a yib'an̈ c'ac' tz'ec' ac'val yic stz'ab'at noc'. ");
INSERT INTO cac_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Axo d'a junxo q'uin̈ib'alil, a junoc vin̈ sacerdote yovalil syac'och junoc spichul vin̈ te vach' yed' yol svex to lino. Slajvi chi', smolanq'ue stan̈il noc' noc' ix n̈usjitz'a d'a yib'an̈ altar chi' vin̈, syac'anem vin̈ d'a stz'eyb'at altar chi'. ");
INSERT INTO cac_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Slajvi chi', sq'uexanel spichul vin̈ chi', sb'at yac'ancan stan̈il noc' silab' chi' vin̈ d'a jun lugar sic'b'ilel d'a spatiquel campamento. ");
INSERT INTO cac_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","13","A jun c'ac' ayoch d'a yib'an̈ altar chi', ayn̈ejocab'och masanil tiempo, malajocab' b'aq'uin̈ stupi. Yovalil tz'ac'jioch te' c'atzitz yuj eb' sacerdote d'a junjun q'uin̈ib'alil, aton d'a yib'an̈ c'ac' chi' tz'ac'jiq'ue noc' silab' stz'a d'a junjun q'uin̈ib'alil. Ata' stz'apax xepual noc' silab' yic junc'olal. ");
INSERT INTO cac_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","A juntzan̈xo checnab'il tz'alji tic, aton tas tz'aj yac'ji tas svaji d'a ofrendail: A vin̈ sacerdote tz'ac'an d'a Jehová d'a yichan̈ altar, ");
INSERT INTO cac_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","syic'ancot junoc b'echan̈ ixim harina yed' aceite, junn̈ej tz'ajb'at yed' masanil incienso yic ofrenda chi', stz'a b'aj stz'ataxon ofrenda, yuj sch'oxani to a masanil jun ofrenda chi' yic Jehová yaji, te suc'uq'ui sjab' syab'i. ");
INSERT INTO cac_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","17","Axo jantacto ofrenda chi' scani, sb'olchaji, malaj yich pan sb'at d'a scal. Sva eb' vin̈ sacerdote d'a junoc lugar to yic Jehová yaji, aton d'a yamaq'uil mantiado b'aj sch'ox sb'a Jehová. A juntzan̈ ofrenda chi', yicn̈ej Jehová yaji, icha yaj silab' yuj yac'ji lajvoc mul, icha pax yaj silab' yuj stupchaj mul. Ix yac'can juntzan̈ ofrenda tic Jehová d'a eb' sacerdote d'a scal juntzan̈ ofrenda tz'ac'ji d'ay to sn̈usjitz'a d'a yib'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","A sleyal jun ofrenda chi' ol cann̈ej d'a masanil tiempo. A ofrenda to yic Jehová yaji, sn̈usjitz'aoc, syaln̈ej svaan masanil eb' vinac d'a yin̈tilal vin̈aj Aarón. Yaln̈ej tastac tz'och tennaj d'a juntzan̈ ofrenda chi' yic Jehová tz'ajcani, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Ix checji yal vin̈aj Moisés chi' yuj Jehová icha tic: ");
INSERT INTO cac_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Aton jun ofrenda tic yovalil syac' vin̈aj Aarón yed' eb' yuninal d'a Jehová, d'a sc'ual sic'chajoch eb' d'a sacerdoteal: Chan̈e' libra ixim harina te vach', yujto ofrenda tz'ac'ji d'a tas svaji. Nan̈al tz'ac'ji d'a q'uin̈ib'alil, axo nan̈alxo, a d'a yemc'ualil tz'ac'ji d'a jun c'u chi'. ");
INSERT INTO cac_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","A d'a yol junoc xalten sb'oji jun ofrenda chi', vach' tz'aj sc'anb'i d'a scal aceite, slajvi chi' spojchaji, tz'ac'ji d'a ofrendail to suc'uq'ui sjab' syab' Jehová. ");
INSERT INTO cac_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Icha chi' ol yutejn̈ej junjun yin̈tilal vin̈aj Aarón ol laj ochn̈ej sq'uexuloc d'a sacerdoteal. Yicn̈ej Jehová yaj jun ofrenda chi', yuj chi' sn̈usjitz'a smasanil d'a yichan̈. ");
INSERT INTO cac_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Masanil ofrenda syac' eb' sacerdote d'a tas svaji, yovalil sn̈usjitz'a smasanil. Malaj junoc mach syal svaani, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Ix lolon Jehová d'a vin̈aj Moisés chi', ix yalani: ");
INSERT INTO cac_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Al masanil juntzan̈ c'ayb'ub'al tic d'a vin̈aj Aarón yed' d'a eb' yuninal, yuj tas tz'aj sn̈usjitz'a silab' yuj yac'ji tup mul: A junoc noc' silab' tz'ac'ji yuj mul chi', yovalil smiljicham noc' d'a yichan̈ Jehová, d'a jun lugar b'ajtaxon smiljicham noc' sn̈usjitz'aoc. A jun silab' chi' yic Jehová yaji. ");
INSERT INTO cac_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","A vin̈ sacerdote tz'ac'an jun silab' yuj yac'ji tup mul chi', syal schi'an vin̈ d'a jun lugar yic Jehová yaji, aton d'a yamaq'uil mantiado b'aj sch'ox sb'a Jehová. ");
INSERT INTO cac_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Yaln̈ej tastac tz'och tennaj d'a noc' chib'ej chi' yic Jehová tz'ajcani. Tato tz'och tzitnaj schiq'uil noc' d'a junoc pichul, yovalil sjuc'jiel d'a junoc lugar to yic Jehová yaji. ");
INSERT INTO cac_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","An̈eja' lum chen b'aj stz'an̈ji noc' silab' chi', yovalil smac'jipoj luum, palta ta a d'a yol junoc chen bronce stz'an̈ji, an̈ej to sn̈icjiel smical, vach' tz'aj sb'icchaji. ");
INSERT INTO cac_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","A jun silab' chi' yic Jehová yaji. Yaln̈ej mach junoc vinac d'a yin̈tilal eb' sacerdote syal schi'ani. ");
INSERT INTO cac_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Palta tato tz'ic'jicot schiq'uil d'a yol mantiado d'a jun lugar to yic Jehová yaji, yuj yac'ji tup mul, max yal-laj schiji noc'. A jun silab' chi' yovalil sn̈usjitz'a smasanil. ");
INSERT INTO cac_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Yic Jehová yaj silab' tz'ac'ji yuj stupchaj mul. Aton val checnab'il yuj tas tz'aj yac'ji tic: ");
INSERT INTO cac_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","A junoc noc' noc' tz'ac'ji yuj stupchaj mul, yovalil smiljicham noc' b'aj schamtaxon noc' sn̈usjitz'aoc, axo schiq'uil noc' stzicjioch d'a schan̈il pac'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Tz'ac'ji masanil xepual noc', aton xepu' ayoch d'a noc' sn̈e, d'a noc' yol sc'ool, ");
INSERT INTO cac_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","yed' noc' stut schab'il yed' xepu' ayoch d'a yich spatic noc' yed' pax xepu' ayoch d'a yib'an̈ seyub' noc', junn̈ej tz'aj yel yed' noc' stut chi'. ");
INSERT INTO cac_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Axo junoc eb' sacerdote sn̈usantz'a juntzan̈ chi' d'a yib'an̈ altar silab'il to sn̈usjitz'a d'a yichan̈ Jehová yuj stojoloc mul. ");
INSERT INTO cac_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Yaln̈ej mach eb' vinac d'a yin̈tilal eb' sacerdote syal schi'an jun silab' chi', palta an̈ej d'a jun lugar to yic Jehová yaji, yujto a jun chi' nivan yelc'ochi. ");
INSERT INTO cac_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","A checnab'il yuj silab' yic stupchaj mul, lajann̈ej yed' yic silab' tz'ac'ji yuj mul. A noc' chib'ej yic juntzan̈ silab' chi', scan yicoc vin̈ sacerdote ix ac'anoch d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","An̈ejton pax a' stz'umal jun noc' silab' stz'a syac' eb' anima chi', yic vin̈ sacerdote chi' tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Icha pax chi' masanil ofrenda sc'anb'i d'a horno, ma d'a yol xalten, ma staji d'a yoltac nivac chen, yicn̈ej jun vin̈ sacerdote tz'ac'anoch jun ofrenda chi' d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Icha chi' tz'aj yac'ji masanil ofrenda tz'ac'ji d'a tas svaji, icha ixim trigo jaxb'il calab'il yed' aceite, mato c'anb'inac. A juntzan̈ chi' yicn̈ej eb' yin̈tilal vin̈aj Aarón, lajann̈ej tz'aj spucanec' eb' d'a spatic. ");
INSERT INTO cac_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Aton val sleyal tas tz'aj yac'ji silab' d'a yichan̈ Jehová sch'oxan junc'olal yed'oc: ");
INSERT INTO cac_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Tato a junoc noc' silab' chi' tz'ac'ji yuj ac'oj yuj diosal, tz'ac'jipax ixim pan malaj yich, scalaj yed' aceite yed' c'oxox pan tz'och aceite d'ay to malaj pax yich yed' juntzan̈ pan b'ob'il d'a ixim harina te vach' calab'il yed' aceite. ");
INSERT INTO cac_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","A yed' jun silab' chi', tz'ac'jipax ixim pan ay yich. ");
INSERT INTO cac_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Tz'ic'jiel junoc pan, tz'ac'jioch d'a yichan̈ Jehová. Slajvi chi' scan jun pan chi' d'a yol sc'ab' vin̈ sacerdote, aton vin̈ stzicanem schiq'uil noc' silab' chi'. ");
INSERT INTO cac_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","A noc' noc' tz'ac'ji silab'il yic sch'oxan junc'olal yed' Dios yuj ac'oj yuj diosal, a d'a jun c'ual tz'ac'ji noc' chi' schijicanb'ati, man̈xa jab'oc noc' sic'jicanb'at d'a junxo c'u. ");
INSERT INTO cac_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","A pax tato a jun silab' tz'ac'ji yujto yac'nac sti' mach yac'ani, ma ton̈ej tz'el d'a sc'ol yac'ani, a juntzan̈ chi' schiji d'a jun c'ual chi', tato ayto noc' scani, syal schiji d'a junxo c'u. ");
INSERT INTO cac_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Palta tato ayto noc' d'a schab'jial, ata' yovalil sn̈usjitz'a noc'. ");
INSERT INTO cac_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Tato ay mach schi'an jun noc' silab' chi' d'a schab'jial, a jun silab' chi' maxtzac chajilaj, maxtzac ochpaxlaj yopisio. A jun chi' man̈ vach'oc tz'ajcan d'a yol sat Jehová. Yuj chi' a mach schi'an jun chi', scan jun mul chi' d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Tato ay noc' chib'ej yic junoc silab' tic tz'och tennaj d'a junoc tas man̈ vach'oc yaj icha yalan ley, maxtzac yal-laj schiji noc', palta to sn̈usjitz'a noc'. A mach vach' yaj icha yalan ley, syal schi'an juntzan̈ silab' chi'. ");
INSERT INTO cac_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","21","A junoc anima man̈ vach'oc yaj icha yalan ley, yujto ix syam junoc tas to man̈ vach'oc, vach'chom d'a anima scoti, ma junoc noc' noc', ma junocxo tas man̈ vach'oc, tato a jun anima chi' schi'anpax noc' silab' yic junc'olal to yic Jehová yaji, a jun anima chi', man̈xaocab' yalan yic d'a co cal, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Al masanil juntzan̈ tic d'a eb' etchon̈ab': Max yal-laj e chi'an xepual noc' noc', noc' vacax, noc' calnel, ma noc' chiva, ");
INSERT INTO cac_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","yed' pax xepual noc' noc' ton̈ej syac'cham sb'a, ma noc' smiljicham yuj noc' caltacte'al noc'. Syal sc'anchaj d'a junocxo tasi, palta max yal-laj schiji. ");
INSERT INTO cac_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Yaln̈ej mach schi'an xepual noc' noc' to syal sn̈usjitz'a d'a ofrendail d'a Jehová, man̈xaocab' yalan yic d'a co cal. ");
INSERT INTO cac_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Yaln̈ej b'ajtil ayex eq'ui, max yal tze chi' schiq'uil noc' noc', aton noc' nivac noc' yed' noc' much. ");
INSERT INTO cac_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","A junoc anima schi'an schiq'uil noc' noc' chi', man̈xaocab' yalan yic d'a co cal, xa chi, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Al jun checnab'il tic d'a eb' etchon̈ab': A junoc mach tz'ac'an junoc silab' yic sch'oxan sjunc'olal yed' Jehová, yovalil syic'cot d'a yichan̈. ");
INSERT INTO cac_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","A tz'ic'ancot jab'oc noc' sn̈usjitz'a d'a yichan̈, aton xepual noc' yed' noc' sn̈i' sc'ool. A noc' sn̈isc'ol chi' sb'achchajoch d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","A noc' xepu' chi' sn̈usjitz'a d'a altar yuj junoc sacerdote, axo noc' sn̈i' sc'ool, yic vin̈aj Aarón yed' eb' yuninal yaj noc'. ");
INSERT INTO cac_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","33","A xub' noc' silab' chi' d'a svach' yic vin̈ sacerdote tz'ac'an schiq'uil noc' yed' xepual noc' d'a silab'il yuj junc'olal. ");
INSERT INTO cac_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","A noc' sn̈i' sc'ool sb'achchajec' d'a yichan̈ Jehová yed' noc' xub' d'a svach', a Jehová chi' tz'ac'an noc' d'a vin̈aj Aarón yed' d'a eb' yin̈tilal d'a masanil tiempo. A juntzan̈ chi' yicn̈ej eb' yaj d'a noc' silab' yic junc'olal syac' eb' israel chi'. ");
INSERT INTO cac_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","A d'a noc' silab' sn̈usjitz'a d'a yichan̈ Jehová, yac'nac noc' sn̈i' sc'ool yed' noc' xub' d'a vin̈aj Aarón yed' d'a eb' yin̈tilal, atax d'a sc'ual a ix sic'chajcanoch eb' d'a sacerdoteal. ");
INSERT INTO cac_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Atax d'a jun c'u chi' yalnaccani to yovalil tz'ac'ji juntzan̈ chi' d'a eb'. A jun checnab'il tic, yovalil sco c'anab'ajej d'a masanil tiempo yed' eb' quin̈tilal d'a b'aq'uin̈. ");
INSERT INTO cac_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ichaton tic sleyal masanil juntzan̈ silab' tz'ac'ji d'a Dios: Aton silab' sn̈usjitz'a smasanil, ofrenda tz'ac'ji d'a tas svaji, silab' tz'ac'ji yuj mul yed' pax yuj stupchaj mul yed' junoc mach tz'ochcan yicoc Dios yed' silab' sch'oxan junc'olal yed' Dios. ");
INSERT INTO cac_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","A juntzan̈ ley tic ix yac' Jehová d'a vin̈aj Moisés d'a jolom vitz Sinaí d'a tz'inan luum, aton val d'a jun c'u chi' ix alchaji, to ol yac' silab' eb' israel d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Ic'cot vin̈aj Aarón yed' eb' yuninal, tzic'anpaxcot spichul eb' syac'och d'a yopisio d'a sacerdoteal. Tzic'paxcot aceite sc'anchaji a sic'chajcanoch eb' d'a yopisio chi'. Tzic'paxcot junoc noc' quelem vacax ol ac'chaj silab'il yuj mul yed' chavan̈oc noc' ch'ac calnel yed' junoc yune' mooch ixim pan malaj yich. ");
INSERT INTO cac_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Tza molb'an eb' etchon̈ab' smasanil d'a sti' mantiado b'aj tzin ch'ox in b'a, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Ix sc'anab'ajej vin̈aj Moisés chi' icha val ix aj yalan Jehová, ix molchaj anima smasanil d'a sti' mantiado chi'. ");
INSERT INTO cac_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Ix yalan vin̈ d'a eb' icha tic: Aton juntzan̈ tic ix yal Jehová to ol co c'ulej, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Ix lajvi chi' ix yalan vin̈ to snitzcot sb'a vin̈aj Aarón yed' eb' yuninal d'a stz'ey. Ix b'icjiel eb' yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ix lajvi chi', ix ac'jioch scamix vin̈aj Aarón chi' yed' stzec'ul yuj vin̈ yed' pax c'apac pichul jucan, c'apac chaleca yed' c'apac stzec'ul tz'isb'iloch yelvanub'. ");
INSERT INTO cac_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Axo d'a spatic c'apac chi', ix yac'paxoch jun c'apac smacul sn̈isc'ol vin̈, a d'a yol c'apac chi' ix yac'och q'uen Urim vin̈ yed' q'uen Tumim. ");
INSERT INTO cac_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ix lajvi chi' ix ac'jiq'ue sc'ox vin̈, aton jun c'apac ix b'ac'jioch d'a sjolom vin̈. Axo d'a snan̈al sat vin̈, ix ac'jioch jun q'uen yelvanub' nab'a oro, aton sch'oxani to sic'b'iloch vin̈ d'a sacerdoteal, icha val ix aj yalan Jehová. ");
INSERT INTO cac_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ix lajvi chi' ix yic'anchaan̈ aceite vin̈aj Moisés chi', aton sc'anchaji a sic'chajoch junoc mach, ma junoc tas tz'ochcan yicoc Jehová. Ix stzicanem vin̈ d'a yib'an̈ scajnub' Jehová yed' d'a yib'an̈ masanil tastac ayoch d'a yool chi'. Icha val chi' ix aj yochcan masanil tastac chi' yicoc Jehová. ");
INSERT INTO cac_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","An̈eja' jun aceite chi', ix tzicjiem uquel d'a yib'an̈ altar yed' d'a yib'an̈ masanil syamc'ab'il, d'a yib'an̈ jun nivan palangana yed' sb'achnub' yich. Icha chi' ix aj yochcan yicoc Jehová. ");
INSERT INTO cac_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ix lajvi chi' ix yac'anpaxq'ue aceite vin̈aj Moisés d'a sjolom vin̈aj Aarón yuj yochcan vin̈ yicoc Jehová. ");
INSERT INTO cac_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ix yic'anpaxcot eb' yuninal vin̈aj Aarón chi' vin̈ d'a stz'ey. Ix ac'jioch spichul eb' jucan, stzec'ul eb' yed' sc'ox eb' yuj vin̈, icha val ix aj yalan Jehová. ");
INSERT INTO cac_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ix lajvi chi', ix yic'ancot noc' quelem vacax vin̈, noc' ol och d'a silab'il yuj mul. A vin̈aj Aarón yed' eb' yuninal, ix yac'q'ue sc'ab' eb' d'a sjolom noc'. ");
INSERT INTO cac_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Ix lajvi chi' ix smilancham noc' vin̈. Ix yic'anb'at schiq'uil noc' vin̈, ix sucanoch vin̈ yed' yiximal sc'ab' d'a sch'ac altar ayq'ue d'a schiquintac schan̈il, yic vach' chab'il yuj Dios. Axo jantacto chic' ixto can chi', ix stob'canem vin̈ d'a yichtac altar chi'. Icha chi' ix aj yochcan yicoc Jehová, yic vach' slajvicanel chucal ta'. ");
INSERT INTO cac_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ix lajvi chi' ix yic'anelta masanil xepual noc' vin̈ ayoch d'a noc' yol sc'ool yed' d'a yib'an̈ seyub' noc', noc' stut schab'il yed' xepual ayoch d'ay. Masanil juntzan̈ chi' ix sn̈ustz'a vin̈ d'a yib'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Axo jantacto noc' vacax chi' ix cani, aton stz'umal noc' yed' sb'ac'chil noc' yed' sch'an̈tza' noc', ix ac'chajcanoch sc'ac'al d'a spatiquelta campamento, icha ix aj yalan Jehová. ");
INSERT INTO cac_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Ix yac'anpax ic'joccot noc' calnel vin̈ sn̈usjitz'a smasanil silab'il. Axo vin̈aj Aarón yed' eb' yuninal chi', ix yac'q'ue sc'ab' eb' d'a sjolom noc'. ");
INSERT INTO cac_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ix lajvi chi' ix smilancham noc' vin̈aj Moisés chi', ix stzicanoch schiq'uil noc' vin̈ d'a schan̈il pac'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ix scotac xiquej noc' vin̈, ix sn̈usantz'a sjolom noc' vin̈ yed' noc' choc' yaj chi' yed' sxepual noc'. ");
INSERT INTO cac_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ix lajvi chi' ix smaxan noc' yol sc'ool vin̈ yed' noc' yoc. Ix sn̈usantz'a noc' vin̈ smasanil silab'il d'a yib'an̈ altar. A jun ofrenda chi' te suc'uq'ui sjab' ix yab' Jehová, icha val ix aj yalani. ");
INSERT INTO cac_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ix lajvi chi' ix yac'an ic'joccot junxo noc' ch'ac calnel vin̈ yic sc'anchaji yic tz'ochcan eb' d'a yopisio. Axo vin̈aj Aarón yed' eb' yuninal chi', ix yac'q'ue sc'ab' eb' d'a sjolom noc'. ");
INSERT INTO cac_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Ix lajvi chi', ix smilancham noc' vin̈, ix yic'anb'at jab'oc schiq'uil noc' vin̈, ix sucanoch vin̈ d'a sjayil schiquin vin̈aj Aarón d'a svach', d'a smam sc'ab' vin̈ d'a svach' yed' d'a yiximal smam yoc vin̈ d'a svach'. ");
INSERT INTO cac_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ix lajvi chi' ix yalan vin̈ to snitzcot sb'a eb' yuninal vin̈aj Aarón chi' d'a stz'ey, ix yac'anpaxoch schiq'uil noc' chi' vin̈ d'a sjayil schiquin eb' d'a svach' yed' d'a smam sc'ab' eb' d'a svach' yed' d'a yiximal smam yoc eb' d'a svach'. Ix lajvi chi' ix stzicanoch vin̈ jantacto chic' ixto can d'a schan̈il pac'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ix lajvi chi' ix yic'anelta xepu' vin̈ ayoch d'a noc' sn̈e yed' ayoch d'a noc' yol sc'ool, xepu' ayoch d'a yib'an̈ seyub' noc' yed' noc' stut schab'il yed' xepu' ayoch d'ay yed' noc' xub' d'a svach'. ");
INSERT INTO cac_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ix yic'ancot jun yune' mooch ixim pan vin̈ malaj yich, ix yac'och vin̈ d'a yichan̈ Jehová. Ix yic'anq'ueta jun ixim pan chi' vin̈ d'a yol mooch chi' yed' junxo ixim calab'il yed' aceite yed' jun ixim c'oxox b'ob'il d'a ixim harina, ix yac'anq'ue vin̈ d'a yib'an̈ noc' xepu' chi' yed' d'a yib'an̈ noc' xub' d'a svach'. ");
INSERT INTO cac_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ix lajvi chi' ix yac'an masanil juntzan̈ tic vin̈ d'a yol sc'ab' vin̈aj Aarón yed' eb' yuninal, yic sb'achanec' eb' d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ix lajvi chi' ix yic'anpaxec' masanil juntzan̈ chi' vin̈ d'a yol sc'ab' eb', ix sn̈usantz'a vin̈ smasanil d'a yib'an̈ altar yed' noc' silab' ix n̈usjitz'a d'a yichan̈ Jehová, yuj sic'chajoch eb' d'a yopisio. Te suc'uq'ui sjab' ix yab' Jehová. ");
INSERT INTO cac_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Ix yic'anpaxcot sn̈isc'ol noc' calnel vin̈ ix ac'ji yuj sic'chajcanoch eb' d'a yopisio. Ix sb'achanoch eb' d'a yichan̈ Jehová. A jun chi' ix yic'can vin̈aj Moisés chi' icha ix aj yalan Jehová. ");
INSERT INTO cac_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ix lajvi chi', ix yic'ancot aceite vin̈ yed' chic' ayec' d'a yib'an̈ altar. Ix stzicanq'ue vin̈ d'a yib'an̈ vin̈aj Aarón yed' d'a spichul. Ix tzicanpaxq'ue vin̈ d'a yib'an̈ eb' yuninal vin̈aj Aarón chi' yed' d'a spichul eb'. Icha chi' ix aj yochcan eb' yicoc Jehová yed' spichul smasanil. ");
INSERT INTO cac_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ix yalan vin̈ d'a vin̈aj Aarón yed' d'a eb' yuninal chi': Tz'an̈jocab' noc' chib'ej d'a yichan̈ mantiado b'aj sch'ox sb'a Jehová. Ata' tze chi noc' yed' ixim pan ayem d'a yol jun yune' mooch, aton ixim ix ac'ji yic tzex ochcan d'a eyopisio. Icha ix aj valani: A vin̈aj Aarón yed' eb' yuninal ol sva jun vael tic eb', xin chi, ix valani. ");
INSERT INTO cac_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","A jantacto man̈ ol lajvoc noc' chib'ej chi' yed' ixim pan chi' eyuuj, ol e n̈uscantz'aoc. ");
INSERT INTO cac_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","A d'a yichan̈ c'apac mantiado b'aj sch'ox sb'a Jehová, an̈ej ta' tzex aj uqueoc c'ual masanto sc'och sc'ual eyochcan d'a eyopisio. ");
INSERT INTO cac_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","A ticnaic toxo ix b'o icha val ix aj schecan Jehová co c'ulej yic slajvicanel e mul. ");
INSERT INTO cac_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Yuj chi' a d'a yichan̈ mantiado, ata' tzex can uqueoc c'ual yed' uqueoc ac'val. Tze c'anab'ajan masanil juntzan̈ schecnab'il Jehová yic vach' max ex chami, yujto icha chi' ix aj yalan Jehová chi' d'ayin, xchi vin̈ d'a eb'. ");
INSERT INTO cac_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Icha chi' ix aj sc'anab'ajan vin̈aj Aarón yed' eb' yuninal masanil tas ix schec Jehová yal vin̈aj Moisés chi' d'a eb'. ");
INSERT INTO cac_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","D'a yevial slajvi uque' c'ual yochcan vin̈aj Aarón d'a yopisio chi', ix avtaj vin̈ yed' eb' yuninal yed' eb' yichamtac vinaquil chon̈ab' yuj vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ix yalan vin̈ d'a vin̈aj Aarón chi': Ic'cot junoc noc' quelem vacax yic tz'och noc' silab'il yuj a mul yed' junoc noc' ch'ac calnel, aton noc' malaj jab'oc spaltail. Tza n̈ustz'a smasanil silab'il uuj, tzac'och noc' d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Alpax d'a eb' quetisraelal to syic'cot junoc noc' mam chiva eb' silab'il yuj smul. Syic'anpaxcot junoc noc' quelem vacax eb' yed' junoc noc' calnel, yuj sn̈usjitz'a noc' smasanil silab'il, jun ab'il sq'uinal junjun noc', malajocab' jab'oc spaltail noc'. ");
INSERT INTO cac_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Syic'anpaxcot junoc noc' vacax eb' yed' junoc noc' ch'ac calnel smiljicham d'a yichan̈ Jehová silab'il yic sch'oxan sjunc'olal eb' yed'oc. Syic'anpaxcot junoc ofrenda eb' d'a tas svaji, calab'il yed' aceite, yujto ol sch'ox sb'a Jehová d'ayex ticnaic, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ix yic'ancot eb' d'a yichan̈ mantiado masanil tastac ix checji yic'cot yuj vin̈aj Moisés chi'. Masanil chon̈ab' ix javi molan, ix och lin̈jab' eb' d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Axo ix yalan vin̈aj Moisés chi' d'a eb' icha tic: Aton val juntzan̈ tic schec Jehová e c'ulej yic vach' ol sch'ox val stziquiquial d'ayex, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Ix lajvi chi', ix yalanxi vin̈ d'a vin̈aj Aarón chi': Nitzcot a b'a d'a slac'anil altar tic, tzac'an noc' noc' silab'oc yuj a mul yed' noc' silab' sn̈usjitz'a smasanil. Icha chi' ol aj yac'ji lajvoc a mul. Tzac'anpax noc' silab' yuj yac'ji lajvoc co mul a on̈ israel on̈ tic, icha val ix aj yalan Jehová, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Yuj chi' ix javi vin̈aj Aarón d'a slac'anil altar chi', ix smilancham noc' quelem vacax ix yac' vin̈ silab'il yuj smul chi'. ");
INSERT INTO cac_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ix lajvi chi' ix japax eb' yuninal vin̈ yed' schiq'uil noc' silab' chi', ix yac'anem yiximal sc'ab' vin̈ d'a scal chic' chi', ix sucanoch vin̈ d'a sch'ac altar chi'. Axo jab'ocxo chic' ixto can chi', ix seccanem vin̈ d'a yich altar chi'. ");
INSERT INTO cac_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ix lajvi chi' ix sn̈usantz'a smasanil xepual noc' vin̈ d'a yib'an̈ altar yed' pax stut noc' yed' xepual ayoch d'a yib'an̈ seyub' noc', aton noc' silab' yuj mul, icha ix aj yalan Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Axo pax sb'ac'chil noc' yed' stz'umal, ix n̈usjitz'a d'a spatiquel campamento. ");
INSERT INTO cac_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ix smilanpaxcham noc' silab' vin̈aj Aarón chi', noc' sn̈usjitz'a smasanil, axo eb' yuninal vin̈ ix ic'ancot schiq'uil noc', ix stzicanoch vin̈ d'a schan̈il pac'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ix lajvi chi', ix yic'anpaxcot sjolom noc' eb' yed' noc' ix xicchajb'at chi', ix sn̈usantz'a vin̈ d'a yib'an̈ altar chi'. ");
INSERT INTO cac_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ix maxchaj noc' yol sc'ool yed' noc' yoc, ix sn̈usanpaxtz'a vin̈ d'a yib'an̈ altar chi', d'a yib'an̈ noc' vanxo stz'a chi'. ");
INSERT INTO cac_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ix lajvi chi', ix yac'an silab' vin̈ yuj eb' yetchon̈ab'. Ix yic'ancot noc' chiva vin̈, aton noc' silab' tz'ac'ji yuj smul eb' yetchon̈ab' chi'. Ix smilancham noc' vin̈, ix yac'an noc' vin̈ silab'il icha ix yutej yac'an noc' b'ab'el chi'. ");
INSERT INTO cac_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ix lajvi chi', ix yac'an junxo noc' silab' vin̈ to stz'a smasanil icha sleyal. ");
INSERT INTO cac_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ix yac'anpax ofrenda vin̈ d'a tas svaji. Ix yic'b'at jun b'echan̈ ixim harina vin̈, ix sn̈usantz'a vin̈ d'a yib'an̈ altar yed' silab' sn̈usjitz'a d'a junjun q'uin̈ib'alil. ");
INSERT INTO cac_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ix yac'anpax noc' vacax vin̈ yed' noc' ch'ac calnel ix yic'cot eb' yetchon̈ab' chi' silab'il yuj sch'oxan sjunc'olal eb' yed' Dios. A eb' yuninal vin̈ ix ic'ancot schiq'uil noc', axo vin̈ ix tzicanoch d'a schan̈il pac'an̈ altar chi'. ");
INSERT INTO cac_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ix yac'anpax xepual noc' vacax eb' yed' xepual noc' ch'ac calnel chi', aton xepu' ayoch d'a sn̈e noc', d'a noc' yol sc'ool yed' d'a noc' stut yed' xepu' ayoch d'a yib'an̈ seyub' noc'. ");
INSERT INTO cac_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Junn̈ej ix aj noc' xepu' chi' yed' noc' sn̈i' sc'ool. Axo vin̈aj Aarón ix n̈usantz'a noc' xepual chi' d'a yib'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Axo pax noc' sn̈isc'ol chi' yed' noc' xub' d'a svach', ton̈ej ix b'achjiec' d'a yichan̈ Jehová, icha ix aj yalan vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ix lajvi chi' ix yic'anchaan̈ sc'ab' vin̈aj Aarón chi', ix yalan vach' lolonel vin̈ d'a yib'an̈ eb' yetchon̈ab' chi'. Ayic toxo ix lajvi sn̈usantz'a silab' vin̈ yuj mul yed' silab' sn̈usjitz'a smasanil yed' silab' yic sch'oxan sjunc'olal yed' Dios, ix emixta vin̈ b'aj ay altar chi'. ");
INSERT INTO cac_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Ix lajvi chi' ix och vin̈aj Moisés yed' vin̈ d'a mantiado b'aj sch'ox sb'a Jehová. Axo ix elta eb' vin̈, ix yalan vach' lolonel eb' vin̈ d'a yib'an̈ eb' yetchon̈ab' chi'. Ix lajvi chi' ix sch'oxan stziquiquial Jehová d'a masanil eb' israel chi'. ");
INSERT INTO cac_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ix elta c'ac' d'a yichan̈ Jehová chi', ix sn̈usantz'a noc' silab' yed' xepual noc' ayq'ue d'a yib'an̈ altar, ix tz'ab'at smasanil. A ix yilan masanil jun chi' eb' chon̈ab' chi', ix el yav eb' d'a tzalajc'olal, ix em n̈ojjab' eb', ix emc'och snan̈al sat eb' d'a sat luum. ");
INSERT INTO cac_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","A vin̈aj Nadab yed' vin̈aj Abiú, eb' vin̈ yuninal vin̈aj Aarón, ix yic'cot junjun chaynub' yic incienso eb' vin̈, ix yac'anoch sc'ac'al eb' vin̈, ix yac'anpaxem incienso eb' vin̈ d'a yib'an̈, ix yac'anoch eb' vin̈ d'a yichan̈ Jehová, to man̈oclaj ix alani. ");
INSERT INTO cac_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Yuj chi' ix elta c'ac' d'a yichan̈ Jehová chi' d'a eb' vin̈, ix tz'ab'at eb' vin̈, ix cham eb' vin̈ d'a yichan̈ Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Ix lajvi chi', ix yalan vin̈aj Moisés chi' d'a vin̈aj Aarón: —Aton jun tic syalelc'och slolonel Jehová ix yala': A yuj eb' tzin ac'an servil, ol in ch'ox in b'a, to A inxon̈ej ochi. A d'a masanil in chon̈ab' ol in ch'ox in tziquiquial, xchi Jehová, xchi vin̈. Ix em numnaj vin̈aj Aarón chi', man̈xalaj tas ix yal vin̈. ");
INSERT INTO cac_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ix lajvi chi', axo vin̈aj Moisés chi' ix avtan vin̈aj Misael yed' vin̈aj Elzafán, eb' yuninal vin̈aj Uziel yicham vin̈aj Aarón chi', ix yalan vin̈ d'a eb' vin̈: —Nitzeccot e b'a a ex tic d'a sti' mantiado b'aj ayec' snivanil eb' e c'ab' eyoc chi', iq'uequel eb' d'a spatiquel campamento, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ix javi eb' vin̈, ix yic'anel eb' chamnac chi' eb' vin̈ d'a spatiquel campamento icha ix aj yalan vin̈aj Moisés chi'. Aytooch spichul eb' chamnac chi' d'ay, aton c'apac sc'antaxon eb' d'a yopisio. ");
INSERT INTO cac_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ix lajvi chi' ix yalan vin̈aj Moisés d'a vin̈aj Aarón yed' d'a chavan̈xo eb' yuninal vin̈, aton vin̈aj Eleazar yed' vin̈aj Itamar: —Man̈ eyiq'uel e c'ox ayq'ue d'a e jolom, man̈ e n̈ic'chitejb'at e pichul yuj e ch'oxanel e cusc'olal. Axo talaj tz'aji, tzex champaxi, axo scot yoval sc'ol Jehová d'a quib'an̈ co masanil a on̈ israel on̈ tic. Palta a masanil eb' quetchon̈ab' tic syal yoc' sc'ol eb' yuj mach ix satel Jehová yed' c'ac'. ");
INSERT INTO cac_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Man̈ ex elpax d'a yichan̈ mantiado b'aj sch'ox sb'a Jehová yic vach' man̈ ol ex chamoc, a ex tic sic'b'il ex eli, ac'b'iloch aceite to yic Jehová d'ayex, xchi vin̈. Icha val ix aj yalan vin̈aj Moisés chi', icha chi' ix sc'ulej eb'. ");
INSERT INTO cac_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Ix yalanpax Jehová d'a vin̈aj Aarón chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","—Ayic ol ach och a ach tic, ma eb' uninal d'a yol mantiado b'aj tzin ch'ox in b'a, man̈ eyuc' vino, ma tastac pajb'inacxo, axo talaj tz'aji tzex chami. A jun tic ley tz'ajcan d'a e cal d'a masanil tiempo. ");
INSERT INTO cac_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Man̈ e c'ulej juntzan̈ chi' yujto yovalil snachajel eyuuj, tastac vach' icha yalan ley yed' tastac man̈ vach'oc. ");
INSERT INTO cac_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Yovalil tze c'ayb'ejpax eb' eyetchon̈ab' d'a juntzan̈ ley ix in chec yal vin̈aj Moisés d'ayex tic, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Ix lajvi chi' ix yalanpax vin̈aj Moisés chi' d'a vin̈aj Aarón yed' pax d'a eb' yuninal vin̈, aton vin̈aj Eleazar yed' vin̈aj Itamar: —Iq'ueccot ixim harina ixto can d'a ofrenda ix tz'a d'a yichan̈ Jehová, tze b'oan ixim pan malaj yich d'a yichan̈ altar, yujto a jun ofrenda chi' yic Jehová yaji. ");
INSERT INTO cac_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Tze vaan d'a junoc lugar to yic Jehová yaji, yujto a ofrenda sn̈usjitz'a d'a yichan̈ Jehová ic yaj yed' eb' uninal. Aton juntzan̈ tic ix alji d'ayin. ");
INSERT INTO cac_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Axo pax noc' sn̈isc'ol sb'achchajec' d'a yichan̈ Jehová yed' noc' xub', tz'ic'chajel noc', a juntzan̈ chi' eyictaxon yaji. Tza chi yed' eb' uninal yed' eb' isil d'a junoc lugar to vach' yaji icha syal ley, yujto a juntzan̈ chi' eyictaxon yaj d'a silab' sch'oxan sjunc'olal eb' quetchon̈ab' yed' Dios. ");
INSERT INTO cac_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Yujto a noc' xub' tz'ic'jiel chi' yed' noc' sn̈isc'ol sb'achjiec' d'a yichan̈ Jehová, junn̈ej tz'aj yac'ji yed' noc' xepu' sn̈usjitz'aoc. A cha macan̈ noc' chi', ic yed' eb' uninal d'a masanil tiempo icha ix aj yalan Jehová d'ayin, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Ix sc'anb'anpax vin̈aj Moisés chi' yuj noc' chiva ix ac'ji silab'il yuj mul. Axo ix yalan eb' vin̈ to toxo ix sn̈ustz'a noc' eb' vin̈. Yuj chi' ix cot yoval vin̈ d'a vin̈aj Eleazar yed' d'a vin̈aj Itamar, ix yalan vin̈ icha tic: ");
INSERT INTO cac_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","—¿Tas yuj maj e chi noc' silab' d'a yamaq'uil scajnub' Jehová? A jun macan̈ silab' chi', yic Jehová yaji, yuj chi' ix ac'ji d'ayex, yuj e chi'an noc', yic tz'ic'jiel smul eb' molanec' d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Yujto a schiq'uil noc' silab' chi', maj ic'jib'at d'a yol scajnub' Jehová, yuj chi' yovalil to ix e chi noc' d'a yamaq'uil chi', icha ix aj valan d'ayex, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Ix yalan vin̈aj Aarón icha tic: —A ticnaic ix yac' silab' eb' yuj smul yed' silab' to stz'a smasanil, vach'chom icha chi', palta ina val tas ix javi d'a vib'an̈. Tato ix in chi noc' silab' ix ac'ji yuj mul chi', ¿tom chab'il in yuj Jehová tza na'? xchi vin̈aj Aarón chi'. ");
INSERT INTO cac_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ayic ix yab'an vin̈aj Moisés icha chi', ix schaan sc'ol vin̈. ");
INSERT INTO cac_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Ix yalan Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón icha tic: ");
INSERT INTO cac_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Alec d'a masanil eb' eyetchon̈ab' to a d'a scal masanil noc' noc' ay d'a sat luum tic, aton juntzan̈ noc' tic syal e chi'ani: ");
INSERT INTO cac_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Noc' sjax yan̈ cha xechan̈ yech. ");
INSERT INTO cac_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Palta a juntzan̈xo noc' ol val tic, man̈ ol yal-laj e chi'an noc', vach'chom sjax yan̈ noc', palta man̈ cha xechan̈oc yech noc': Noc' camello sjax yan̈ noc', palta man̈ cha xechan̈oc yech noc', a noc' chi' max yal-laj e chi'an noc'. ");
INSERT INTO cac_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Yed' pax noc' tejón, sjax yan̈ noc', palta tzijtum yech noc', a noc' chi' max yal-laj e chi'an noc'. ");
INSERT INTO cac_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Yed' pax noc' nivac chich, sjax yan̈ noc', palta tzijtum yech noc', yuj chi' max yal-laj e chi'an noc'. ");
INSERT INTO cac_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Yed' pax noc' chitam, vach'chom cha xechan̈ yech noc', palta max sjaxpax svael noc', yuj chi' max yal-laj e chi'an noc'. ");
INSERT INTO cac_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Max yal e chi'an juntzan̈ noc' noc' chi', max yalpax eyaman noc' ayic toxo ix cham noc', yovalil tze na'a to man̈ vach'oc noc' icha yalan ley. ");
INSERT INTO cac_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Axo pax noc' ay d'a yoltac a a', noc' ay d'a yol a' mar, ma d'a yoltac a nivac a', syal e chi'an noc' ay sc'axil yed' stuminal spatic. ");
INSERT INTO cac_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Axo pax noc' malaj sc'axil, malaj pax stuminal spatic, max yal-laj e chi'an noc'. A noc' chi' yajb'entac noc', vach'chom a d'a yol a' mar ma d'a yoltac a' ay noc'. ");
INSERT INTO cac_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Yujto yajb'entac noc', man̈ e chi noc', man̈ eyampax noc' chamnacxo. ");
INSERT INTO cac_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Masanil noc' malaj sc'axil yed' stuminal spatic ay d'a yoltac a', yajb'entacocab' yaj noc' d'a yol e sat. ");
INSERT INTO cac_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","An̈eja' pax d'a scal noc' much, man̈ ol yal-laj e chi'an juntzan̈ noc' ol val tic, yujto man̈ vach'oc noc': Icha noc' d'iv, noc' vacavoc, noc' ch'acb'a yic a a', ");
INSERT INTO cac_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","noc' xulem, noc' milano yed' masanil macan̈il noc' xulem chi', ");
INSERT INTO cac_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","yed' masanil macan̈il noc' joj, ");
INSERT INTO cac_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","noc' avestruz, noc' nivac tonton, noc' xalun̈e yed' masanil macan̈il noc' ch'acb'a, ");
INSERT INTO cac_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","noc' cujub', noc' cormorán, noc' ibis, ");
INSERT INTO cac_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","noc' pech, noc' julum chay, noc' ostoc, ");
INSERT INTO cac_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","noc' cigüeña yed' masanil macan̈il noc' garza yed' noc' abubilla yed' noc' sotz'. ");
INSERT INTO cac_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","An̈ejtona' pax masanil noc' cotac noc' tz'ec' jen̈en̈oc d'a jun petan̈il sb'ey d'a sat luum, yajb'entacocab' noc' d'a yol e sat. ");
INSERT INTO cac_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Axo pax tato a noc' ay yip yoc sq'ue tz'itnajoc, vach'chom sjen̈vi noc', sb'eypax noc' d'a sat luum, syal schiji noc'. ");
INSERT INTO cac_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","A d'a scal noc' chi' syal e chi'an smasanil macan̈il noc' c'ulub', noc' nivac c'ulub' yed' noc' chil. ");
INSERT INTO cac_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Axo masanil juntzan̈xo noc' cotaquil noc' tz'ec' jen̈en̈oc, ma tz'ec' d'a sat luum tic, yovalil tzeyaj noc'. ");
INSERT INTO cac_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","Tato tze yam juntzan̈ noc' noc' sval tic ayic chamnacxo noc', man̈ vach'oc tzex ajcani icha yalan ley, masanto sq'uic'b'iemi. Masanil noc' noc' ay yech palta man̈ chaxechan̈oclaj, max sjaxpax yan̈, a juntzan̈ noc' chi' nachajocab' el eyuuj to man̈ vach'oc noc'. Yaln̈ej tas noc'al to chan̈e' yoc palta tzijtum yech mocab' vach'oc noc' d'a yol e sat. Yuj chi' yaln̈ej mach syaman junoc noc' noc' chi' tato chamnacxo noc', man̈ vach'oc tz'ajcani, icha yalan ley. Icha pax chi' junoc mach tz'ic'anchaan̈ noc' chamnac noc' chi', yovalil sjuq'uel spichul, palta manto vach'oc tz'ajcani masanto sq'uic'b'iemi. Man̈ vach'oc juntzan̈ noc' chi' icha yalan ley. ");
INSERT INTO cac_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","Axo masanil noc' noc' tz'ec' d'a sat luum, nachajocab' el eyuuj to max yal schiji juntzan̈ noc' tic: Icha noc' c'uxum boton, noc' ch'oov, noc' c'oc'on yed' masanil macan̈il noc' pajtza' yed' masanil macan̈il noc' tz'ec' n̈ern̈onoc ma tz'ec' jachjonoc: Aton noc' ayin, noc' lagarto, noc' patix yed' noc' tzalajc'ab'. ");
INSERT INTO cac_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","A d'a scal masanil noc' noc', a juntzan̈ noc' tic, nachajocab' el eyuuj to man̈ vach'oc noc' icha yalan ley, yuj chi' yaln̈ej mach syaman noc' ayic toxo ix cham noc', man̈ vach'oc tz'ajcani masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Q'uinaloc ay junoc tas b'aj tz'em noc' chamnac noc' chi', a jun chi', man̈ vach'oc tz'ajcani, icha yalan ley: Vach'chom a junoc te te', junoc pichul, junoc tz'uum, junoc coxtal, ma junoc yamc'ab' yic munlajel, tato tz'em junoc noc' chamnac noc' chi' d'a yib'an̈, yovalil slab'chajem d'a scal a a'. Palta manto vach'oc tz'ajcani, masanto sq'uic'b'iemi, ichato chi' vach' tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Tato tz'em junoc noc' noc' chi' d'a yol junoc lum chen ayic toxo ix cham noc', a tas ayem d'a yol lum chi', man̈ vach'oc tz'ajcani, axo jun chen chi', yovalil smac'jipoj luum. ");
INSERT INTO cac_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Yaln̈ej tas chib'il vailal yed' yal ayem d'a yol jun chen chi', ma uq'uem, man̈ vach'oc tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Yuj chi' tato tz'em junoc noc' chamnac noc' chi' d'a yib'an̈ junoc tasi, man̈ vach'oc tz'ajcani, vach'chom a junoc horno, ma junoc yed'tal b'aj tz'och c'ac', yovalil spojjieli. A jun yamc'ab' chi' man̈xo vach'oc icha yalan ley, yuj chi' man̈xo vach'oc pax d'a yol e sat. ");
INSERT INTO cac_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Palta a sjaj a a', ma a' uc'b'ila' vach'chom tz'em noc' chamnac noc' d'a yol a', vach'n̈ej yaj a', an̈ej jun mach tz'ic'anq'ueta noc' chamnac noc' chi' d'a yol a' man̈ vach'oc tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Q'uinaloc tz'em junoc noc' chamnac noc' chi' d'a yib'an̈ junoc macan̈ in̈at tz'avchaji, a jun macan̈ in̈at chi' max ixtaxel-laj. ");
INSERT INTO cac_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Palta tato a jun macan̈ in̈at lab'anxo, tz'em junoc chamnac noc' chi' d'a yib'an̈, a juntzan̈ in̈at chi' man̈xo vach'oc tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Q'uinaloc scham junoc noc' noc' to schiji, a mach syaman noc', man̈ vach'oc tz'ajcani masanto sq'uic'b'icanemi. ");
INSERT INTO cac_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","A mach schi'an sb'ac'chil noc' chamnac noc' chi' yovalil sjuq'uel spichul, man̈ vach'oc tz'ajcani masanto sq'uic'b'icanemi. A mach tz'ic'anelta junoc chamnac noc' chi' yovalil sjuq'uel spichul, man̈ vach'oc tz'ajcani masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Man̈ e chi juntzan̈ noc' noc' sn̈ervi, ma sjachvi d'a sat luum, yujto man̈ vach'oc noc'. ");
INSERT INTO cac_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Masanil noc' noc' sn̈ervi, ma sjachvi d'a sat luum, vach'chom noc' sb'ey yed' schan̈il yoc, ma noc' tzijtum yoc, masanil juntzan̈ noc' chi' man̈ vach'oc noc' icha yalan ley, yuj chi' man̈ e chi noc'. ");
INSERT INTO cac_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Man̈ e juel e b'a a ex tic yuj noc' noc' man̈ vach'oc chi', yujto man̈ vach'oc tzex ajcan yuj noc'. ");
INSERT INTO cac_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","A in ton Jehová e Diosal in, yuj chi' b'esequel e b'a d'a juntzan̈ man̈ vach'oc chi', yujto vach' inn̈ej, yuj chi' te max yal eyixtanb'at e b'a yed' juntzan̈ noc' chi'. ");
INSERT INTO cac_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","A in Jehová in, ix ex viq'uelta d'a Egipto, e Diosal in, yuj chi' te vach'ocab'n̈ej tzeyutej e b'a yujto vach' inn̈ej. ");
INSERT INTO cac_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Aton val masanil juntzan̈ checnab'il tic d'a masanil noc' noc', noc' much yed' masanil noc' noc' ay d'a yoltac a a' yed' masanil noc' tz'ec' jachachoc d'a sat luum tic, sval d'ayex ");
INSERT INTO cac_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","yic vach' snachajel eyuuj b'ajtil ay noc' vach' syal schiji yed' noc' man̈ vach'oc max yal schiji, xchi Jehová, xe chi. ");
INSERT INTO cac_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ix yalan Jehová d'a vin̈aj Moisés icha tic: ");
INSERT INTO cac_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Al masanil juntzan̈ tic d'a eb' etisraelal: Tato a junoc ix ix tz'aj junoc svinac unin, yovalil uque' c'ual man̈ sacoc yaj ix icha sleyal, ichataxon yic syilan sb'islab' uj ix d'a juntac el. ");
INSERT INTO cac_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","D'a val yucub'ixial yaj jun vinac unin chi', tz'ac'ji circuncidar. ");
INSERT INTO cac_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Axo pax ix nunab'il chi', 33 c'ualto man̈ vach'oc tz'ajcan ix, ichato vanto sacb'itan sb'a ix, max yal-laj syaman junoc tas ix to vic yaji, max yalpax sb'at ix b'aj ay in cajnub' ayic manto tz'acvoc juntzan̈ c'ual chi'. ");
INSERT INTO cac_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Palta tato ix unin tz'aj jun, 14 c'ual tz'eq'ui ayic manto sacoc yaj ix, ichataxon tz'aj d'a sb'islab' uj d'a juntac el, slajvi chi' 66 c'ual scan ix yic sacb'itan sb'a. ");
INSERT INTO cac_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Ayic stz'acvi juntzan̈ c'ual yic sacb'itan sb'a ix yuj yune' ix alji chi', vach'chom vinac unin ma ix unin, yovalil syic'cot junoc noc' quelem calnel jun ab'il sq'uinal ix silab'il yed' junoc noc' yaln̈ej macan̈il paramuch, syac' ix silab'il yuj yac'ji tup smul. A juntzan̈ chi' tz'ac'ji d'a junoc vin̈ sacerdote d'a yichan̈ mantiado. ");
INSERT INTO cac_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Axo jun vin̈ sacerdote chi' tz'ac'an d'ayin silab'il yic vach' tz'ac'ji tup smul ix. Icha chi' tz'aj sacb'ixican ix. Aton juntzan̈ sleyal tic ayic tz'alji vinac unin, ma ix unin. ");
INSERT INTO cac_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Palta tato a ix nunab'il chi' malaj junoc noc' scalnel chi' syal yac'ani, syic'cot chavan̈oc noc' paramuch ix yaln̈ej tas macan̈il, jun noc' stz'a silab'il, jun noc' tz'ac'ji silab'il yuj yac'ji tup mul. Axo junoc vin̈ sacerdote tz'ac'an silab'il yic vach' tz'ac'ji tup smul ix. Icha chi' tz'aj sacb'ixican ix, xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Ix yalan Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón: ");
INSERT INTO cac_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Tato ay junoc anima smalq'ue snivanil, ma sq'ue vochjab', ma chac sulinac tz'aj yilji snivanil, talaj lepra jun yab'il chi', yovalil tz'ic'jicot d'a vin̈aj Aarón, ma d'a juntzan̈ocxo eb' sacerdote yin̈tilal vin̈. ");
INSERT INTO cac_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Axo vin̈ sacerdote chi' tz'ilan jun yab'il chi'. Tato a xiil b'aj ay jun yab'il chi', sacxo, ma nivan chequel to man̈ocn̈ej d'a stz'umal ay jun yab'il chi', palta julxo yich, a jun yab'il chi' lepraxo. Ayic toxo ix ilji jun anima chi' yuj vin̈ sacerdote, a vin̈ tz'alani to maxtzac yal-laj yajec' jun anima chi' d'a scal yetanimail. ");
INSERT INTO cac_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Tato sacxo yilji stz'umal b'aj ay jun yab'il chi', palta to an̈ej d'a stz'umal ayochi, man̈ sacoc pax xiil chi' ta', yovalil smacchaj jun anima chi' yuj vin̈ sacerdote chi' uqueoc c'ual. ");
INSERT INTO cac_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Axo slajvi uque' c'ual chi', sayjixi iljoc jun anima chi'. Tato a jun yab'il chi' an̈eja' max b'eyb'ati, smacchajxi uqueocxo c'ual. ");
INSERT INTO cac_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ayic slajvi uquexo c'ual chi', sayjixi iljoc jun anima chi' yuj vin̈ sacerdote chi'. Tato a jun yab'il chi' vanxo sateli, maxtzac b'eyb'at d'a stz'umal jun anima chi', ichato chi' syalan vin̈ sacerdote chi' to man̈ lepraoc tz'ic'ani, comon yab'iln̈ej. Slajvi chi' sjuc'anel spichul jun penaay chi', vach'xo tz'ajxicani. ");
INSERT INTO cac_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Palta tato a jun yab'il d'a snivanil junoc anima chi' sb'at leb'eb'oc, vach'chom toxo ix yal vin̈ sacerdote to man̈ lepraoc, yovalil scotxi d'a vin̈ sacerdote chi' yic sayanxi yil vin̈. ");
INSERT INTO cac_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Tato a syilan vin̈ sacerdote chi' to van sb'at leb'eb'oc jun yab'il chi', syal vin̈ to a jun yab'il chi' lepra toni. ");
INSERT INTO cac_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Tato ay junoc anima ay lepra d'ay, yovalil tz'ic'jicot d'a vin̈ sacerdote. ");
INSERT INTO cac_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","A vin̈ sacerdote chi' tz'ilani tato van smalq'uei, sacxo yilji sat chi', vanxo pax sacb'i xiil d'a sat chi', chequelxo sb'ac'chil. ");
INSERT INTO cac_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Tato icha chi', aton jun chi' scuchan lepra, cotac scal sch'oxanq'ue sb'a d'a stz'umal chi', yuj chi' syalan vin̈ sacerdote chi' to maxtzac yal-laj yajec' d'a scal eb' yetanimail. Man̈xo yovaliloc smacchaj d'a uqueocxo c'ual. ");
INSERT INTO cac_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Tato elan̈chamel sb'at leb'naj jun yab'il chi', smajel snivanil chi' yuuj, ato a' tz'aj yilanoch vin̈ sacerdote chi', ");
INSERT INTO cac_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ayic slajvi yilan vin̈, tato toxo ix majel snivanil chi', sacxon̈ej yilji jun anima chi', syalan vin̈ to man̈xalaj smay. ");
INSERT INTO cac_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Tato ay junoc c'ual scheclajq'ue sb'ac'chil d'a scal jun yab'il chi', maxtzac yal-laj yajec' jun anima chi' d'a scal eb' yetanimail. ");
INSERT INTO cac_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Axo vin̈ sacerdote tz'ilan jun yab'il chi', tato ay b'aj tz'el tochnaj stz'umal ichn̈ej ta', syalan vin̈ to lepra tz'ic'ani, maxtzac yal-laj yajec' d'a scal eb' yetanimail. ");
INSERT INTO cac_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Palta tato sacb'ixiel b'aj ix el tochnaj chi', yovalil scot jun anima chi' d'a vin̈ sacerdote, ");
INSERT INTO cac_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","yic vach' say yil vin̈. A vin̈ sacerdote chi' tz'ilani tato sacxo yilji jun yab'il chi', syalan vin̈ to man̈xalaj smay jun yab'il chi'. ");
INSERT INTO cac_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Tato ay mach ayq'ue junoc yab'il mal d'ay, stacjixiemi, ");
INSERT INTO cac_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","axo d'a sat chi' smali, sac yilji, ma chac sulinac yilji, a jun chi' yovalil scot d'a yichan̈ vin̈ sacerdote. ");
INSERT INTO cac_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Axo vin̈ sacerdote chi' tz'ilani, tato man̈ocn̈ej d'a stz'umal ayoch jun yab'il chi', tato sacxo xiil d'a sat jun yab'il chi', a vin̈ tz'alani to lepra jun yab'il chi', yuj chi' maxtzac yal-laj yajec' jun anima chi' d'a scal eb' yetanimail. ");
INSERT INTO cac_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Tato syil vin̈ sacerdote chi', to max sacb'ilaj xiil b'aj ay sat chi' to d'a satn̈ej stz'umal ayochi, vanxo stacji, a jun anima chi' yovalil smacchaj uqueoc c'ual. ");
INSERT INTO cac_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ayic slajvi uque' c'ual chi', tato yelc'olaln̈ej sb'at leb'eb'oc jun yab'il chi' d'a stz'umal jun anima chi', syalan vin̈ sacerdote chi' to lepra tz'ic'ani, maxtzac yal-laj yajec' d'a scal eb' yetanimail. ");
INSERT INTO cac_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Palta tato max b'at leb'eb'oc jun yab'il chi', syalelc'ochi to an̈ej sjech'al aycani, syalan vin̈ sacerdote chi' to man̈xalaj smay jun yab'il chi'. ");
INSERT INTO cac_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Q'uinaloc ay junoc mach ay yaxc'a d'a snivanil, tato scheclaj sb'ac'chil jun anima b'aj ay yaxc'a chi', axo d'a sb'ac'chil chi' scheclajpaxq'ue junoc setan̈ sacsac, ma chac sulinac to sb'at leb'eb'oc. ");
INSERT INTO cac_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","A vin̈ sacerdote tz'ilani, tato a xiil vanxo sacb'i, vanxo sb'at yich jun setan̈ b'aj ay sat chi', tato icha chi', lepra ix checlajq'ue b'aj ay yaxc'a chi', axo vin̈ sacerdote chi' tz'alani to maxtzac yal-laj yajec' jun anima chi' d'a scal eb' yetanimail. ");
INSERT INTO cac_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Tato a syilan vin̈ sacerdote to malaj junoc xil van sacb'ieli, to man̈ vanoc sb'at yich jun yab'il chi', palta to van stacjiemi, yovalil smacchaj jun anima chi' d'a uqueoc c'ual. ");
INSERT INTO cac_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Slajvi chi', sayanxi yil vin̈ sacerdote chi', tato toxo ix b'at leb'eb'oc d'a snivanil jun anima chi', syalan vin̈ to lepra tz'ic'ani, maxtzac yal-laj yajec' d'a scal eb' yetanimail. ");
INSERT INTO cac_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Palta tato a b'aj setquixtac chi', vaanochi, vanxo sb'oxi, ton̈ej smal yuj b'aj stz'ai, syalan vin̈ sacerdote chi' to a jun yab'il chi' malaj smay, an̈ej sjech'al b'aj stz'a chi' scani. ");
INSERT INTO cac_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Tato a d'a junoc vinac ma d'a junoc ix ix sq'ue yab'il yaxc'a d'a sjolom, ma d'a yuc'ti', ");
INSERT INTO cac_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","a vin̈ sacerdote yovalil sayan yil jun chi'. Tato a jun yab'il chi' van sb'at yich, mato van sc'anb'iel xiil yuuj, syalan vin̈ sacerdote chi' to lepra jun ayoch chi' d'a jun anima chi'. ");
INSERT INTO cac_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Palta tato max b'atlaj yich jun yab'il chi', man̈ q'uic'oc val xiil b'aj ay yab'il chi', yovalil smacchaj jun anima chi' uqueoc c'ual. ");
INSERT INTO cac_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Axo slajvi uque' c'ual chi', sayanxi yil vin̈ sacerdote chi', maxtzac b'atlaj leb'eb'oc jun yab'il chi', malaj yich, max c'anb'iel-laj xiil, ");
INSERT INTO cac_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","syalan vin̈ to sjoxjiel stitac yab'il, palta max joxjiel-laj d'a sat yab'il, smacchaj uqueocxo c'ual jun anima chi'. ");
INSERT INTO cac_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Axo yic toxo ix ec'b'at uquexo c'ual chi', sayanxi yil vin̈ sacerdote chi'. Tato max b'at leb'eb'oc, max b'at yich yuuj, syalan vin̈ to malaj smay jun yab'il chi', an̈ej to sjuq'uel spichul jun anima chi', vach' tz'ajxicani. ");
INSERT INTO cac_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Palta tato ayic toxo ix alchaji to vach' sc'ol jun anima chi', sb'atxi leb'eb'oc jun yab'il chi', ");
INSERT INTO cac_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","yovalil sayxi yil vin̈ sacerdote chi'. Tato a jun yab'il chi' van sb'at leb'eb'oc d'a stz'umal, man̈ yovaliloc c'an yilji xiil, lepra tz'ic'ani. ");
INSERT INTO cac_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Palta tato vanxo stacji, q'uic' scotxi xiil, a vin̈ sacerdote chi' tz'alani to vach'xo sc'ol jun anima chi'. ");
INSERT INTO cac_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Tato a junoc vinac ma junoc ix ix setquixtac sacsac d'a stz'umal, ");
INSERT INTO cac_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","a vin̈ sacerdote tz'ilan stz'umal chi', tato sactac val yilji, palta man̈ copopioclaj, comon yab'il tz'ic'an jun anima chi' syal chi', malaj smay. ");
INSERT INTO cac_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Tato ay junoc vinac sc'ajb'anel xil sjolom ma an̈ej d'a snan̈al sat sc'ajb'anel xiil, man̈xalaj xiil scani, a jun chi' malaj smay. ");
INSERT INTO cac_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","44","Palta tato sq'ue junoc yab'il yaxc'a b'aj man̈xalaj xiil chi', yovalil syil vin̈ sacerdote. Tato chac sulinac yilji jun yaxc'a chi' icha yab'il lepra, aton lepra ayoch d'ay. Syalan vin̈ sacerdote chi' to a jun anima chi', maxtzac yal-laj yajec' d'a scal yetanimail yuj jun yab'il chi'. ");
INSERT INTO cac_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","A mach penaay yuj lepra, yovalil a pichul n̈ic'chimtac syac'ochi, malaj smusil sjolom syac'q'uei, smusan nan̈aloc sat. Tato sb'at d'a scal anima, tz'el yav, syalan icha tic: Elan̈ec, chuc vaji, chuc vaji, xchi. ");
INSERT INTO cac_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ayic ayoch jun yab'il chi' d'ay, yovalil sch'ocoj tz'aj d'a spatiquel campamento. ");
INSERT INTO cac_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ayic c'ustumtac yilji junoc pichul lana, ma lino, ");
INSERT INTO cac_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","yaln̈ej tas macan̈il, pach'uch'ab'il, ma jalb'il, ma junoc tz'uum to yamc'ab' yaji, ");
INSERT INTO cac_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","50","tato yaax yilji, ma chacchac yilji juntzan̈ sc'ustumtaquil chi', aton jun macan̈ to tz'el leb'eb'oc. A jun chi' yovalil sch'oxji d'a vin̈ sacerdote yic syilan jun setan̈ sc'ustumtaquil chi' vin̈, smacchaj jun chi' uqueoc c'ual. ");
INSERT INTO cac_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Axo slajvi uque' c'ual chi', tz'iljixi. Tato toxo ix b'at leb'eb'oc d'a jun pichul chi', ma d'a junoc tz'um sc'anji chi', a jun chi' aton juntzan̈ c'ustumtac tz'el leb'eb'oc, a juntzan̈ yamc'ab' chi' ay smay. ");
INSERT INTO cac_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Yaln̈ej tas yamc'ab'il to ayxo jun chi' d'ay, yovalil sn̈usjitz'a smasanil, yujto a jun chi' tzijtum tas syixtejb'ati. ");
INSERT INTO cac_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Palta tato ayic syilan vin̈ sacerdote chi' to max b'eylaj juntzan̈ sc'ustumtaquil chi', ");
INSERT INTO cac_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","syalan vin̈ to sjuc'chajel jun yamc'ab' chi', smacchajcan uqueocxo c'ual. ");
INSERT INTO cac_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ayic toxo ix juc'chajel jun yamc'ab' chi', ichato chi' syilanxi vin̈ sacerdote chi'. Tato max q'uexmaj yilji jun setan̈ sc'ustumtaquil chi', vach'chom max el leb'eb'oc, yovalil sn̈usjitz'aoc, vach'chom a jun sc'ustumtaquil chi' ayoch d'a spatic ma d'a yool, yujto yelxo ay smay jun chi'. ");
INSERT INTO cac_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Tato a syilan vin̈ sacerdote chi' ayic toxo ix juc'chajel chi', vanxo satel jun sc'ustumtaquil chi', slod'chajel b'aj ayoch chi'. ");
INSERT INTO cac_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Palta tato scheclajxiq'ue sc'ustumtaquil jun chi', yovalil sn̈usjitz'aoc. ");
INSERT INTO cac_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","A juntzan̈ tastac b'aj satel juntzan̈ c'ustumtac chi' ayic sjuc'chajeli, yovalil sjuc'chajel junelxo, icha chi' syal sc'anchajxi. ");
INSERT INTO cac_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Aton juntzan̈ checnab'il tic d'a c'ustum tz'och d'a junoc pichul pach'uch'ab'il, ma jalb'il, lana, ma lino, ma junoc tz'uum. Icha chi' tz'aj scheclajcaneli tato vach' yaji, mato man̈ vach'oc yaji, xchi Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón chi'. ");
INSERT INTO cac_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ix schec Jehová yal juntzan̈ ley tic vin̈aj Moisés, ix yalani: ");
INSERT INTO cac_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","4","Aton val jun ley tic sc'anab'ajej junoc anima ec'nac lepra d'ay: Ayic snaani to ix b'oxi sc'ool, yovalil syavtej vin̈ sacerdote d'a spatiquel campamento chi' yic syilan vin̈ tato man̈xa lepra chi' d'ay. Tato syil vin̈ sacerdote chi' to toxo ix el jun yab'il chi', schecan vin̈ ic'chajcot chavan̈oc noc' much d'a spitzanil, aton noc' vach' icha yalan ley. Scotpax jab'oc te' c'ute', lana ch'al q'uic' schaquil yed' te' hisopo. ");
INSERT INTO cac_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Schecan miljoccham junoc noc' much chi' vin̈ sacerdote d'a yib'an̈ a a' ayem d'a yol junoc lum chen, aton a' scot b'aj sq'ueul sjaj junoc a a'. ");
INSERT INTO cac_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Slajvi chi' tz'ic'jicot junxo noc' much chi' d'a spitzanil, te' c'ute' yed' lana ch'al q'uic' schaquil yed' te' hisopo, slab'chajem d'a scal schiq'uil noc' chamnacxo chi' calan yed' a a'. ");
INSERT INTO cac_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Uquel stzicjioch d'a jun mach b'aj ec'nac jun yab'il chi', syalan vin̈ sacerdote chi' to vach'xo jun anima chi'. Axo noc' much pitzan chi' tz'actajcanel noc'. ");
INSERT INTO cac_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","A jun mach tz'ilji to vach'xo, yovalil sjuq'uel spichul, sb'icanpaxel sb'a, sjoxanel xil sjolom smasanil, yic vach'xon̈ej tz'ajcani. Ichato chi' syalxo yoch d'a yol campamento, palta uqueto c'ual scan ichn̈ej ta', maxto yal-laj yoch d'a yol b'aj cajantaxoni. ");
INSERT INTO cac_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Axo d'a yuquil c'ual chi', vach' tz'aj sjoxjiel sjolom. Vach' tz'aj sjoxanel xil sti' yed' sc'u sat yed' pax masanil xil ay d'a snivanil, sjuc'anel spichul, sb'icanpaxel sb'a. Icha chi' tz'aj sb'oxicani. ");
INSERT INTO cac_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Axo d'a junxo c'u, syic'ancot chavan̈oc noc' quelemtac calnel yed' junoc noc' cob'es calnel, jun ab'il sq'uinal junjun noc', malaj jab'oc spaltail noc'. Scotpax nan̈al yuquil libra ixim harina te vach' calab'il yed' aceite, tz'ac'ji ofrendail yed' pax oxeoc octavo aceite. ");
INSERT INTO cac_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Axo vin̈ sacerdote chi' schecanoch lin̈an jun anima yed' yofrenda chi' d'a yichan̈ Jehová d'a stielxo scajnub' b'aj sch'ox sb'a. ");
INSERT INTO cac_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Slajvi chi', tz'ic'jicot jun noc' quelem calnel chi' yed' aceite, sb'achchajb'at d'a yichan̈ Jehová silab'il yuj smul jun anima chi'. ");
INSERT INTO cac_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","A b'aj schamtaxon noc' tz'ac'ji silab'il yuj mul yed' noc' silab' stz'a smasanil, ata' smiljicham noc' quelem calnel chi', yujto a noc' tz'ac'ji yuj mul, yic vin̈ sacerdote tz'ajcan noc', icha noc' tz'ac'ji yuj stupcanel mul, a juntzan̈ tic yic Jehová yaji. ");
INSERT INTO cac_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Slajvi chi' a vin̈ sacerdote chi' tz'ic'ancot jab'oc schiq'uil noc' silab' yuj mul, sucanoch vin̈ d'a sjayil schiquin d'a svach' jun mach sb'oxi sc'ol chi', d'a smam sc'ab' d'a svach' yed' d'a yiximal smam yoc d'a svach'. ");
INSERT INTO cac_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Syic'anpaxcot jab'oc aceite vin̈ sacerdote chi', secanem vin̈ d'a yol sc'ab' d'a sq'uexan̈, ");
INSERT INTO cac_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","slab'anem jun sb'ab'el yiximal sc'ab' vin̈ d'a svach' d'a scal aceite, stziquem uqueloc aceite chi' vin̈ d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","A aceite tzato can d'a sc'ab' vin̈ sacerdote chi', sucoch vin̈ d'a jun anima ix b'oxi sc'ool chi', an̈eja' d'a sjayil schiquin d'a svach', d'a smam sc'ab' d'a svach' yed' pax d'a yiximal smam yoc d'a svach', aton b'aj ayxo och schiq'uil noc' silab' yuj smul. ");
INSERT INTO cac_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Axo jab'ocxo aceite tz'ac'jicanq'ue d'a sjolom jun anima chi'. Icha chi' tz'aj stupcan smul d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Slajvi chi' syac'anpax noc' silab' vin̈ sacerdote chi', aton noc' silab' yuj yac'ji tup mul. Icha chi' tz'aj stupcanel smul jun anima chi'. Slajvi chi', smiljicham noc' calnel stz'a smasanil silab'il. ");
INSERT INTO cac_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Junn̈ej tz'aj yac'jiq'ue noc' d'a yib'an̈ altar yed' ofrenda tz'ac'ji d'a tas svaji. Icha val chi' tz'aj stupcanel smul jun anima chi' d'a yichan̈ Jehová, sb'oxicani. ");
INSERT INTO cac_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Tato meb'a' jun anima b'aj ix ec' jun yab'il chi', malaj stumin yic syac' noc' silab' sc'anchaj chi', an̈ej junoc noc' quelem calnel syic'coti yic sb'achchajoch silab'il d'a yichan̈ Jehová yuj smul, chab'n̈ej libra ixim harina te vach' calab'il yed' aceite syac'a' yed' oxeoc octavo aceite. ");
INSERT INTO cac_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Syic'paxcot chavan̈oc noc' paramuch yaln̈ej tas macan̈il, ato a' jantac stzac'van smanani. Jun noc' tz'ac'ji silab'il yuj yac'ji tup smul, jun noc' sn̈usjitz'aoc. ");
INSERT INTO cac_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","A d'a svajxaquil c'ual syic'ancot masanil juntzan̈ tic jun anima chi' d'a vin̈ sacerdote yic sacb'icaneli. A juntzan̈ tic tz'ac'jioch d'a yichan̈ Jehová d'a stielxo scajnub' b'aj sch'ox sb'a. ");
INSERT INTO cac_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Slajvi chi' syic'ancot jun noc' calnel vin̈ sacerdote yed' aceite chi', sb'achanec' vin̈ d'a yichan̈ Jehová d'a silab'il yuj yac'ji tup smul jun anima chi'. ");
INSERT INTO cac_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Smilancham noc' quelem calnel chi' vin̈, syic'anq'ue jab'oc schiq'uil noc' vin̈, sucanoch vin̈ d'a sjayil schiquin jun anima chi' d'a svach', d'a smam sc'ab' d'a svach' yed' d'a yiximal smam yoc d'a svach'. ");
INSERT INTO cac_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Slajvi chi' syac'anq'ue jab'oc aceite chi' vin̈ d'a yol sc'ab' d'a sq'uexan̈. ");
INSERT INTO cac_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Yed' sb'ab'el yiximal sc'ab' vin̈ d'a svach', stzicanem uqueloc aceite ayem d'a yol sc'ab' vin̈ chi' d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Syac'paxoch jab'oc aceite chi' vin̈ d'a schiquin jun anima chi' d'a svach', d'a smam sc'ab' d'a svach' yed' d'a yiximal smam yoc d'a svach', aton b'aj toxo ix och schiq'uil noc' silab' chi'. ");
INSERT INTO cac_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Axo jab'ocxo aceite chi' scani, syac'q'ue vin̈ sacerdote chi' d'a sjolom jun anima chi', yic stupcanel smul d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Slajvi chi', smilancham noc' paramuch chi' vin̈ sacerdote chi' schavan̈il. ");
INSERT INTO cac_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","A junoc noc' paramuch chi' tz'ac'ji silab'il yuj yac'ji tup mul, axo junxo noc' sn̈usjitz'aoc yed' pax ixim harina tz'ac'jipax d'a ofrendail. Icha chi' tz'aj stupcan smul jun anima ix b'oxi chi' d'a yichan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Aton sleyalil tic d'a junoc mach ix ec' lepra d'ay, yic tz'alchaji to ix sacb'ixicani tato max tzac'van yac'an juntzan̈ silab' icha val sleyalil, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Ix yalan Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón: ");
INSERT INTO cac_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Ayic ayexxo ec' d'a lum Canaán, aton lum ol vac' eyicoc, talaj svac'b'at junoc tas c'ustac yilji tz'el leb'eb'oc d'a yol e pat ta', ");
INSERT INTO cac_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","a mach ay yic te' pat chi' yovalil scot d'a junoc vin̈ sacerdote syalani: Ay juntzan̈ c'ustumtac yilji van yel leb'eb'oc d'a yol in pat, xchama. ");
INSERT INTO cac_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ayic manto och vin̈ sacerdote d'a yol pat chi', yovalil syal vin̈ to tz'elta masanil tastac ay d'a yol te', yic vach' max can juntzan̈ c'ael chi' d'a yol pat tato syal vin̈ sacerdote chi' to man̈ vach'oc yaj jun pat chi'. Slajvi chi' tz'och vin̈ yil tas yilji jun c'ustum tz'el leb'eb'oc chi'. ");
INSERT INTO cac_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Tato ayic syilanoch vin̈ to a d'a sattac pat chi' ay juntzan̈ nivac c'ustum leb'quiltac, yaax yilji, ma chac yilji, yelc'olal to sb'at d'a yol sattac pat chi', ");
INSERT INTO cac_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","axo tz'elxita vin̈ d'a yol te' pat chi', syalan vin̈ to smacchajcan te' uqueoc c'ual. ");
INSERT INTO cac_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ayic slajvi uque' c'ual chi', sb'atxi vin̈ sacerdote chi' yila'. Tato toxo ix te b'at leb'eb'oc jun sc'ustumtaquil chi' d'a sattac pat chi', ");
INSERT INTO cac_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","yovalil syal vin̈ sacerdote chi' to slipjielta masanil q'uen q'ueen b'aj toxo ix och juntzan̈ leb'quiltac chi', b'at yumchajcan d'a junoc lugar man̈ vach'oc d'a stiel chon̈ab'. ");
INSERT INTO cac_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Syalanpax vin̈ to sjoschajel masanil sattac yol te' pat chi', axo masanil spococal tz'el d'a yool chi', sb'at yumchajcan d'a junoc lugar man̈ vach'oc d'a stiel chon̈ab'. ");
INSERT INTO cac_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ch'ocxo q'uen q'ueen tz'ochpaxcan sq'uexuloc q'uen tz'ic'chajelta chi', ch'ocxo lum luum tz'ochpax d'a sattac yol pat chi'. ");
INSERT INTO cac_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Tato scheclajxiq'ue juntzan̈ c'ustum leb'quiltac chi' ayic toxo ix ic'jiel q'uen q'ueen chi' yed' toxo ix joschajel sattac pat chi', toxo ix ochpaxcan sq'uexul, ");
INSERT INTO cac_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","sb'at yilanxi vin̈ sacerdote chi'. Tato toxo ix el leb'eb'oc jun sc'ustumtaquil chi', man̈xo vach'oc tz'ajcan jun pat chi'. ");
INSERT INTO cac_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Yuj chi', a jun pat chi' yovalil spojchajemi. Masanil te te', q'uen q'ueen yed' lum luum ayoch d'a jun pat chi', b'at ac'jican d'a junoc lugar to man̈ vach'oc d'a stiel chon̈ab'. ");
INSERT INTO cac_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Yaln̈ej mach tz'och d'a yol jun pat chi' d'a uque' c'ual ayic toxo ix yal vin̈ sacerdote to smacchajcani, man̈ vach'oc tz'ajcani icha yalan ley, masanto d'a sq'uic'b'icanemi. ");
INSERT INTO cac_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Yaln̈ej mach sva'i, ma svay d'a jun pat chi', yovalil sjuq'uel spichul. ");
INSERT INTO cac_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Palta tato ayic tz'och vin̈ sacerdote yil jun pat chi', syilan vin̈ to a juntzan̈ leb'quiltac chi' max b'eyb'ati yictax ix b'ojican yol te' pat chi', syal vin̈ to vach'xo jun pat chi'. ");
INSERT INTO cac_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Yic sacb'ixican te' pat chi', tz'ic'jicot chavan̈oc noc' much yed' jab'oc te' c'ute' yed' lana ch'al q'uic' schaquil yed' te' hisopo. ");
INSERT INTO cac_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Smilancham junoc noc' much chi' vin̈ sacerdote d'a yib'an̈ a a' ayem d'a yol jun lum chen, aton a' scot b'aj sq'ueul sjaj junoc a a'. ");
INSERT INTO cac_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Slajvi chi' syic'anb'at te' c'ute' chi' vin̈ yed' te' hisopo yed' lana ch'al q'uic' schaquil yed' junxo noc' much pitzanto, slab'anem vin̈ d'a scal a a' calanxo yaj yed' schiq'uil noc' much ix miljicham chi' d'a yol lum chen chi'. Uquel stzicoch vin̈ d'a te' pat chi'. ");
INSERT INTO cac_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Icha chi' tz'aj sacb'ixican jun te' pat chi' yuj schiq'uil noc' much chi' yed' a a' sq'ueul sjaj, yuj noc' much pitzanto, yuj te' c'ute', yuj te' hisopo yed' lana ch'al q'uic' schaquil. ");
INSERT INTO cac_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Slajvi chi', tz'actajcanb'at jun noc' much pitzan chi' d'a stiel chon̈ab'. Icha chi' tz'aj sc'anab'ajaj sleyalil d'a junoc pat, vach' tz'ajcani, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","57","Aton juntzan̈ checnab'il tic d'a yib'an̈ lepra smalq'uei, mato d'a yaxc'ail, mato d'a leb'quiltac sacsac yilji, mato d'a juntzan̈ c'ustumtac d'a pichul yed' d'a spatictac te' pat. Icha chi' tz'aj snachajel tastac to man̈ vach'oc yed' tastac to vach'. Aton d'a tic slajvican checnab'il d'a juntzan̈ tic. ");
INSERT INTO cac_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ix yalan Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón ");
INSERT INTO cac_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","to syal masanil juntzan̈ checnab'il tic eb' vin̈ d'a eb' yetisraelal. Yuj chi' ix yalan eb' icha tic: Tato ay junoc vinac ay junoc yab'il d'a snivanil, yuj chi' ay tas tz'el d'a svinaquil, a jun chi' man̈ vach'oc yaji icha yalan ley. ");
INSERT INTO cac_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Vach'chom tz'eln̈ej juntzan̈ chi', ma ay b'aj tz'och vaan jayeoc c'ual tz'elxi, man̈ vach'oc yaji, icha yalan ley. ");
INSERT INTO cac_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Yaln̈ej tas vaynub'al b'aj svay vin̈ vinac chi', ma yaln̈ej tas c'ojnub'al b'aj tz'em c'ojan vin̈, man̈ vach'oc tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Yaln̈ej mach syaman svaynub' jun vinac chi', yovalil sjuq'uel spichul sb'icanpaxel sb'a, palta man̈ vach'oc tz'ajcani masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Yaln̈ej mach tz'em c'ojan b'aj ix em c'ojan jun vinac chi', yovalil sjuq'uel spichul, sb'icanpaxel sb'a, palta man̈ vach'oc tz'ajcani masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Yaln̈ej mach syaman junoc vinac ay tas tz'el d'ay, yovalil sjuq'uel spichul, sb'icanpaxel sb'a, palta man̈ vach'oc yaji masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Tato a junoc vinac ay tas tz'el d'ay chi', stzub'anoch d'a junocxo anima, a jun anima b'aj ix och stzub' chi', yovalil sjuq'uel spichul, sb'icanpaxel sb'a, palta man̈ vach'oc tz'ajcani masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Tato a jun vinac ay tas tz'el d'ay chi' sq'ue d'a yib'an̈ chej, a stz'um noc' chi' man̈ vach'oc tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Yaln̈ej mach syaman junoc tas b'aj tz'em c'ojan jun vinac to ay tas tz'el d'ay chi', man̈ vach'oc tz'ajcani masanto sq'uic'b'iemi. Yaln̈ej mach tz'ic'anb'at junoc juntzan̈ tastac chi', yovalil sjuc' spichul, sb'icanpaxel sb'a, palta man̈ vach'oc tz'ajcani, icha yalan ley masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Tato a jun vinac ay tas tz'el d'ay chi', max sb'iclaj sc'ab' syaman junocxo mach, a jun ix yamji yuj chi', yovalil sjuq'uel spichul, sb'icanpaxel sb'a, palta man̈ vach'oc tz'ajcani masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Tato ay junoc chen syam jun vinac ay tas tz'el d'ay chi', yovalil smac'jipoj jun chen chi'. Tato a junoc te te' yamc'ab' yaj syam jun vinac chi', ton̈ej sb'icchajel te'. ");
INSERT INTO cac_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Tato sb'oxi sc'ol jun vinac chi, man̈xa tas tz'el d'ay, yovalil stan̈vej uqueoc c'ual, ichato chi' scanxi vach'il d'a yichan̈ ley. Slajvi chi' sjuc'anel spichul, sb'icanel sb'a d'a a a' sq'ueul sjaj. Icha chi' tz'aj sb'oxicani, icha yalan ley. ");
INSERT INTO cac_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Axo d'a svajxaquil c'ual, yovalil syic'cot chavan̈oc noc' paramuch yaln̈ej tas macan̈il, scot d'a yichan̈ Jehová sc'och d'a stielxo scajnub' b'aj sch'ox sb'a, syac'an noc' d'a junoc vin̈ sacerdote. ");
INSERT INTO cac_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Jun noc' syac' vin̈ sacerdote chi' silab'il yuj yac'ji tup smul jun anima chi', axo junxo noc' sn̈usjitz'aoc. A vin̈ sacerdote chi' tz'ac'anoch masanil juntzan̈ chi' d'a yichan̈ Jehová, yic sacb'ixican jun vinac ec'nac jun yaelal chi' d'ay. ");
INSERT INTO cac_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Tato a junoc vinac ton̈ej tz'el yin̈atil, yovalil sb'iquel sb'a, palta man̈ vach'oc tz'ajcani, icha yalan ley, masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Yaln̈ej tas c'apaquil ma tz'uum b'aj ix och yin̈atil jun vinac chi', yovalil sjuc'jieli, man̈ vach'oc tz'ajcani, icha yalan ley masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Tato a junoc vin̈ vinac yed' junoc ix ix ay tas sc'ulej, yovalil sb'iquel sb'a eb', palta man̈ vach'oc tz'ajcan eb', icha yalan ley masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Tato a junoc ix ix ayoch d'a stiempoal sb'islab' uj, man̈ vach'oclaj yaj ix d'a uqueoc c'ual. Yaln̈ej mach syaman ix, man̈ vach'oc tz'ajcani, icha yalan ley masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Yaln̈ej tas vaynub'al b'aj tz'ec' jichan ix ayic ayoch ix d'a stiempoal chi', ma yaln̈ej tas c'ojnub'al b'aj tz'em c'ojan ix, man̈ vach'oclaj tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Yaln̈ej mach syaman b'aj ix ec' jichan ix chi', ma syaman junoc tas b'aj tz'em c'ojan ix, man̈ vach'oclaj tz'ajcani. Yovalil sjuq'uel spichul, sb'icanel sb'a, palta man̈ vach'oc tz'ajcani masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Tato ay junoc vin̈ vinac svay yed' ix, sb'on̈chaj vin̈ yuj tas tz'el chi' d'a ix, man̈ vach'oclaj tz'ajcan vin̈ d'a uque' c'ual, an̈ejtona' man̈ vach'oc tz'ajcan vaynub' b'aj svay vin̈ vinac chi'. ");
INSERT INTO cac_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Tato ay junoc ix ix tz'ilan uj d'a man̈ stiempoaloc, mato te nivan tiempo syac' ix yilani, a jun ix chi' man̈ vach'oc tz'ajcan ix ayic ayto tas tz'el chi' d'a ix, icha val to aytooch ix d'a yilan uj. ");
INSERT INTO cac_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Yaln̈ej tas vaynub'al b'aj svay ix, ma c'ojnub' b'aj tz'em c'ojan ix ayic ayto tas tz'el chi' d'a ix, man̈ vach'oc tz'ajcan juntzan̈ chi', ichato ayoch ix d'a sb'islab' uj chi'. ");
INSERT INTO cac_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Yaln̈ej mach syaman juntzan̈ tastac chi', man̈ vach'oclaj tz'ajcani, yovalil sjuq'uel spichul, sb'icanpaxel sb'a, palta man̈ vach'oc tz'ajcani masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ayic svanaj yilan uj ix chi', uque' c'ual stan̈vej ix, slajvi chi' sb'oxican ix, icha yalan ley. ");
INSERT INTO cac_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Axo d'a svajxaquil c'ual, syic'ancot chavan̈oc noc' paramuch ix yaln̈ej tas macan̈il, syic'ancot ix d'a junoc vin̈ sacerdote, d'a stielxo scajnub' b'aj sch'ox sb'a Jehová. ");
INSERT INTO cac_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Jun noc' syac' vin̈ sacerdote chi' silab'il yuj yac'ji tup smul ix, axo junxo noc' sn̈usjitz'a noc'. Icha chi' tz'aj yac'anoch jun silab' chi' vin̈ sacerdote chi' d'a yichan̈ Jehová yic tz'ac'ji tup smul ix, yuj tas ix el d'ay. ");
INSERT INTO cac_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Icha chi' tz'aj co sacb'itan co b'a a on̈ israel on̈ tic d'a tas tzon̈ ic'ani, yic max quixtejel scajnub' Jehová ayec' d'a co cal tic, tato maay tzon̈ chami, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Aton juntzan̈ checnab'il tic d'a eb' vinac ay tas tz'el d'ay, ma ton̈ej tz'el yin̈atil, yuj chi' man̈ vach'oc tz'ajcan yuuj ");
INSERT INTO cac_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","yed' d'a eb' ix ix ayoch d'a sb'islab' uj. A juntzan̈ checnab'il tic, yovalil sc'anab'ajaj yuj eb' ay syaelal icha chi', vinac, ma ix. Tz'ochpax jun ley chi' d'a yib'an̈ junoc vinac svay yed' ix ix to man̈ vach'oc yaji, icha yalan ley. ");
INSERT INTO cac_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ix lolon Jehová d'a vin̈aj Moisés ayic ix lajvi scham chavan̈ eb' yuninal vin̈aj Aarón, yujto ix scomon nitzejb'at sb'a eb' d'a slac'anil Jehová, ");
INSERT INTO cac_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ix yalan d'a vin̈aj Moisés chi' icha tic: Al d'a vin̈ uc'tac aj Aarón to max comon och vin̈ d'a yol in cajnub' d'a jun lugar Vicn̈ej Yaji, aton jun lugar ay d'a spaticoch c'apac cortina. Max yal-laj scomon c'och vin̈ b'aj ay smacul b'aj tz'ac'ji tup mul, aton smacul te' scaxail in trato, yic max cham vin̈, yujto a in ol in ch'ox in b'a d'a scal asun d'a yib'an̈ smacul scaxail in trato chi'. ");
INSERT INTO cac_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Ayic tz'och vin̈aj Aarón d'a yol jun lugar chi', yovalil syic'cot junoc noc' quelem vacax vin̈ yic tz'och silab'oc yuj smul yed' junoc noc' ch'ac calnel sn̈usjitz'a smasanil. ");
INSERT INTO cac_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Syac'och spichul vin̈ nab'a lino, aton spichul vin̈ jucan, yol svex vin̈, c'apac stzec'ul snan̈al vin̈ yed' sb'ac'ul sjolom vin̈. A juntzan̈ pichul chi' te nivan yelc'ochi, yuj chi' b'ab'el sb'iquel sb'a vin̈ ichato chi' syac'anoch vin̈. ");
INSERT INTO cac_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Axo eb' eyetisraelal syic'cot chavan̈oc noc' mam chiva eb' yic tz'ac'ji noc' silab'il yuj smul eb', syic'paxcot junoc noc' ch'ac calnel eb' yic sn̈usjitz'aoc. ");
INSERT INTO cac_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Syic'ancot noc' quelem vacax chi' vin̈aj Aarón chi' yic tz'och noc' silab'oc yuj smul. A jun noc' chi' yic noc' vin̈, yuj yac'ji tup smul vin̈ yed' masanil eb' ayec' d'a yol spat. ");
INSERT INTO cac_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Slajvi chi' syic'anpaxcot chavan̈ noc' mam chiva chi' vin̈ d'a yichan̈ in cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Syac'anoch suerte vin̈ d'a yib'an̈ noc' chiva chi' schavan̈il: Jun noc' tz'ac'ji silab'oc d'ayin, axo junxo noc', tz'ac'chajcanoch mul d'a yib'an̈ noc', spechchajcanb'at noc' d'a tz'inan luum. ");
INSERT INTO cac_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","A noc' tz'em suerte d'a yib'an̈ to vico', syic'cot noc' vin̈aj Aarón chi' silab'oc yic stupcanel smul eb' israel. ");
INSERT INTO cac_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Axo junxo noc' chiva chi', d'a spitzanil noc' tz'och d'a vichan̈, tz'ac'jicanoch mul d'a yib'an̈ noc', tz'actajcanb'at noc' d'a tz'inan luum syic'ancanb'at smul eb' israel chi' noc'. ");
INSERT INTO cac_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Ayic listaxo yaj juntzan̈ tic smasanil, smilancham noc' quelem vacax vin̈aj Aarón chi', syac'an noc' vin̈ silab'il yic tz'ac'ji tup smul yed' smul masanil eb' ayec' yed' vin̈ d'a yol spat. ");
INSERT INTO cac_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Slajvi chi', syic'ancot jun chaynub' yic incienso vin̈, b'ud'an yed' stzac'aq'uil altar ay d'a vichan̈ yed' cha b'echan̈oc incienso suc'uq'ui sjab', syic'anoch vin̈ d'a yoloch c'apac cortina ayoch d'a snan̈al in cajnub'. ");
INSERT INTO cac_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Syac'anem incienso chi' vin̈ d'a yib'an̈ tzac'ac' d'a vichan̈, axo d'a yib'an̈ smacul b'aj tz'ac'ji tup mul, aton smacul scaxail in trato, tz'och moyan stab'il incienso chi' yic vach' max cham vin̈. ");
INSERT INTO cac_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Syic'ancot jab'oc schiq'uil noc' quelem vacax chi' vin̈, slab'anem yiximal sc'ab' vin̈ d'a scal chic' chi', stzicanb'at vin̈ d'a yib'an̈ smacul caxa chi' b'aj tz'ochc'och vin̈ chi', uquel stzicoch chic' chi' vin̈ d'a yichan̈ smacul chi'. ");
INSERT INTO cac_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Slajvi chi', tz'elxita vin̈, smilancham noc' chiva vin̈, aton noc' tz'och silab'il yuj smul eb' israel, syic'anoch schiq'uil noc' vin̈ d'a yoloch c'apac cortina chi', stzicanpaxem schiq'uil noc' chi' vin̈ d'a yib'an̈ smacul caxa chi' yed' d'a yichan̈, icha syutej schiq'uil noc' quelem vacax vin̈ d'a sb'ab'elal. ");
INSERT INTO cac_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Icha val chi' syutej vin̈aj Aarón chi' sacb'itan jun lugar Vicn̈ej Yaji yuj yalxon̈ej tas chucal yed' spitalil eb' israel tic. Icha chi' ol aj sacb'ican masanil in cajnub' b'aj tzin ch'ox in b'a, aton jun ayec' eyed'oc d'a scal chucal tze c'ulej. ");
INSERT INTO cac_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Malaj junoc mach ayec' d'a yol in cajnub' yacb'an ayoch vin̈aj Aarón chi' d'a jun lugar Vicn̈ej Yaji yic syac'an silab' vin̈ yic stup smul yed' smul masanil eb' ayec' yed' vin̈ d'a yol spat yed' smul eb' chon̈ab' masanil. ");
INSERT INTO cac_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Slajvi yelxita vin̈, sacb'itan altar vin̈ ayec' d'a vichan̈, aton b'aj sn̈usjitz'a silab', syic'anelta jab'oc schiq'uil noc' vacax chi' vin̈ yed' jab'oc yic noc' mam chiva, syac'anoch vin̈ d'a sch'ac altar ay d'a schiquin schan̈il. ");
INSERT INTO cac_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Stzicanoch uquel schiq'uil noc' noc' chi' vin̈ yed' yiximal sc'ab' d'a yib'an̈ altar chi', icha chi' tz'aj sacb'itan altar chi' vin̈ yuj e mul a ex israel ex tic. ");
INSERT INTO cac_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Slajvi sacb'ican jun lugar Vicn̈ej Yaji, in cajnub' yed' pax altar yuj vin̈, schecan vin̈ ic'joccot noc' mam chiva pitzan chi'. ");
INSERT INTO cac_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Slajvi chi', syac'anb'at sc'ab' vin̈ schab'il d'a sjolom noc', tz'och ijan vin̈ yalanem smul yed' spitalil eb' yetchon̈ab' d'a yib'an̈ noc'. Icha chi' tz'aj scan smul eb' d'a yib'an̈ noc'. Axo jun vin̈ sic'b'ilxoel b'at ac'ancan noc' d'a tz'inan luum b'aj te najat. ");
INSERT INTO cac_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Stijancanb'at noc' vin̈ ta', satcanb'at noc' d'a taquin̈ lum chi'. Icha chi' tz'aj yic'jicanb'at smul chon̈ab' Israel yuj noc', aton b'aj man̈xalaj anima tz'eq'ui. ");
INSERT INTO cac_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Slajvi chi' tz'ochixta vin̈aj Aarón d'a yol in cajnub' yic sq'uexanel spichul vin̈ ayochi, c'apac nab'a lino, c'apac ayoch yuj vin̈ a tz'ochta d'a yol jun lugar to Vicn̈ej Yaji, syac'ancan c'apac vin̈ ta'. ");
INSERT INTO cac_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","An̈eja' d'a yol in cajnub' chi' sb'iquel sb'a vin̈, syac'anoch spichul vin̈ syac'taxonoch d'a yopisio. Slajvi chi', sn̈usantz'a silab' vin̈, aton yic vin̈ yed' silab' yic eb' israel chi' smasanil. Icha chi' tz'aj stupcanel smul vin̈ yed' yic eb' yetchon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","A jantac xepual noc' silab' yuj mul, sn̈usjipaxtz'a d'a yib'an̈ altar. ");
INSERT INTO cac_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Axo vin̈ b'at ac'ancan noc' mam chiva d'a taquin̈ lum chi', ayic sjax vin̈, sjuq'uel spichul vin̈, sb'icanpaxel sb'a vin̈. Ichato chi' syal yochta vin̈ d'a yol campamento. ");
INSERT INTO cac_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","A noc' quelem vacax yed' noc' mam chiva smiljicham silab'il yuj stupcanel mul, aton noc' tz'ic'jicot schiq'uil d'a yol jun lugar to Vicn̈ej Yaji, tz'ic'jicanb'at snivanil noc' d'a spatiquel campamento. Ata' sn̈usjitz'a noc' yed' stz'umal yed' masanil snivanil. ");
INSERT INTO cac_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","A vin̈ sn̈usantz'a noc' chi', yovalil sjuq'uel spichul vin̈, sb'icanpaxel sb'a vin̈, ichato chi' syal yochta vin̈ d'a yol campamento. ");
INSERT INTO cac_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","A jun tic ley tz'ajcan d'a e cal d'a masanil tiempo ex israel ex, ma eb' ch'oc chon̈ab'il ayec' d'a e cal. A d'a slajun̈il c'ual d'a yuquil uj, tzex och d'a tzec'ojc'olal, malaj mach smunlaj d'a jun c'ual chi', ");
INSERT INTO cac_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","yujto a jun c'ual chi', sc'ual yac'ji silab' yuj e mul yic vach' stupcanel e mul d'a vichan̈. ");
INSERT INTO cac_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","A jun c'ual chi', sc'ual ic'oj ip tz'ajcani yed' tzec'ojc'olal, ley tz'ajcan d'a e cal d'a masanil tiempo. ");
INSERT INTO cac_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","A yuj chi' a ol cham vin̈ sat sacerdote, axo junoc eb' yuninal vin̈ tz'ochcan sq'uexuloc. Tz'ac'chajq'ue aceite d'a sjolom, tz'ac'jipax silab' yuj yochcan yopisio, syac'anoch spichul te nivan yelc'ochi. ");
INSERT INTO cac_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","A tz'ac'an silab' yic sacb'itan jun lugar to Vicn̈ej Yaji, in cajnub' b'aj tzin ch'ox in b'a yed' altar. Syac'anpax silab' yic stup smul eb' sacerdote yed' ex israel ex tic. ");
INSERT INTO cac_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","A jun tic ley tz'ajcan d'a e cal d'a masanil tiempo. Junel tz'ac'ji silab' tic d'a yol junjun ab'il yic slajviel e mul a ex chon̈ab' israel ex tic, xchi Jehová. Icha val ix aj yalan Jehová, icha chi' ix yutej vin̈aj Moisés chi' yalani. ");
INSERT INTO cac_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Al d'a vin̈aj Aarón yed' d'a eb' yuninal yed' d'a masanil eb' etchon̈ab' to in checnab'il juntzan̈xo tic: ");
INSERT INTO cac_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Yaln̈ej mach smilancham junoc noc' vacax, junoc noc' calnel, ma junoc noc' chiva silab'oc d'a spatiquel campamento, ma d'a yool, ");
INSERT INTO cac_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","palta max yic'cotlaj noc' d'a stielxo in cajnub' b'aj tzin ch'ox in b'a, yovalil man̈xa yalan yic d'a e cal. A jun chi' scotcan d'a yib'an̈, yujto ton̈ej stob'canem schiq'uil noc' ta'. ");
INSERT INTO cac_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Icha chi' tz'aj valani yic mantzac e comon milej noc' noc' silab'il d'a spatiquel campamento, palta to tzeyic'cot noc' d'a stiel in cajnub', axo junoc vin̈ sacerdote tz'ac'anoch noc' silab'il yic junc'olal d'a vichan̈. ");
INSERT INTO cac_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","A vin̈ sacerdote chi' stzicanoch schiq'uil noc' d'a spatictac altar d'a vichan̈, aton d'a stielxo in cajnub', sn̈ustz'a xepual noc' vin̈ d'a vichan̈, suc'uq'ui sjab' svab'i. ");
INSERT INTO cac_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Man̈xa b'aq'uin̈ tzeyac' junocxo silab' d'a eb' enemigo, aton juntzan̈ b'aj ochnac ex ejmelal. Yujn̈ej juntzan̈ chi' ex juviel d'a vichan̈. A jun tic ley tz'ajcan d'a e cal d'a masanil tiempo. ");
INSERT INTO cac_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Yaln̈ej mach eb' eyetisraelal, ma ch'oc chon̈ab'il cajanec' d'a e cal, tato syac' junoc silab' stz'ai, ma yaln̈ej tas silab'il, ");
INSERT INTO cac_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","palta to max yic'cotlaj d'a stielxo in cajnub' b'aj tzin ch'ox in b'a yic tz'ac'ji d'ayin, a jun anima chi', man̈xa yalan yic d'a e cal. ");
INSERT INTO cac_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Te ay val yoval in c'ol d'a yaln̈ej mach eyetisraelal ma junoc ch'oc chon̈ab'il ayec' d'a e cal schi'an schiq'uil noc' noc'. A in val ol in och ajc'olal d'ay, ol in satanel d'a e cal. ");
INSERT INTO cac_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Yujto masanil noc' noc' yed' anima, a yuj schiq'uil pitzan, yuj chi' ix vala' to stob'jioch schiq'uil noc' d'a spatictac altar yic slajvicanel mul. Yujto a d'a schiq'uil noc' chi' ay sq'uinal yuj chi' syal yac'an tup mul chi'. ");
INSERT INTO cac_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Yuj chi' sval d'ayex israel ex tic to malaj junoc ex, ma eb' ch'oc chon̈ab'il ayec' cajan d'a e cal syal chi'an schiq'uil noc' noc'. ");
INSERT INTO cac_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Yaln̈ej mach ex ma eb' ch'oc chon̈ab'il ayec' cajan d'a e cal syamchaj junoc noc' noc' yuuj, ma junoc noc' much, aton noc' toxonton schiji, yovalil syic'canel schiq'uil noc', smucancan yed' lum luum. ");
INSERT INTO cac_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Yujto a chic' chi' ic'an pitzan noc', yuj chi' sval d'ayex to max yal-laj schiji noc' chib'ej aytooch schiq'uil. Yaln̈ej mach schi'ani, satjiel d'a e cal. ");
INSERT INTO cac_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Yaln̈ej mach ex, ma ch'oc chon̈ab'il schi'an noc' chib'ej to ton̈ej schami, mato smiljicham yuj junoc noc' chium noc', yovalil sjuq'uel spichul, sb'icanel sb'a, palta man̈ vach'oc tz'ajcani masanto sq'uic'b'iemi. ");
INSERT INTO cac_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Palta tato max sjuq'uel spichul, mato max sb'iquel sb'a, scann̈ej smul chi' d'a yib'an̈, xa chi, xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Al juntzan̈ checnab'il tic smasanil d'a eb' etisraelal: A in Jehová e Diosal in. ");
INSERT INTO cac_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Man̈ e b'eyb'alej sb'eyb'al eb' aj Egipto, aton jun chon̈ab' b'aj ec'nac ex cajan. Man̈ e b'eyb'alejpax sb'eyb'al eb' aj Canaán, aton b'aj van ex vic'anb'ati. ");
INSERT INTO cac_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","C'anab'ajejec in checnab'il, tze c'anab'ajan e b'eyb'alan in c'ayb'ub'al. A in ton Jehová e Diosal in svala'. ");
INSERT INTO cac_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","B'eyb'alejec in checnab'il yed' in c'ayb'ub'al. A mach ol c'anab'ajanoc, ol schan̈ej sq'uinal yuuj. A in ton Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Malajocab' junoc vin̈ vinac smulan yed' junoc ix ix to ayto yuj sb'a yed'oc. A inton Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Malajocab' junoc mach syac' q'uixvelal smam, smulan yed' snun, yelxo val te chuc yujto snun ton val. ");
INSERT INTO cac_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Malajocab' junoc vin̈ vinac smulan yed' ix yetb'eyum smam yic max yac' q'uixvelal smam chi'. ");
INSERT INTO cac_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Malajocab' junoc vin̈ vinac smulan yed' yanab': Yanab' yuj smam, ma yuj snun, vach'chom d'a yol spat aljinac ix, mato ch'oc b'aj aljinac, man̈ smojoc smulan yed' ix. ");
INSERT INTO cac_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Malajocab' junoc vin̈ vinac syac' q'uixvelal sb'a smulan yed' ix yixchiquin, yixchiquin yuj yuninal, ma yuj yisil. Max yal-laj smulan yed'oc. ");
INSERT INTO cac_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Malajocab' junoc vin̈ vinac smulan yed' ix yune' ix yisil smam, yisil val smam chi', schab'il yanab' yaj ix, max yal-laj smulan yed' ix. ");
INSERT INTO cac_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Malajocab' junoc vin̈ vinac smulan yed' ix yanab' smam, yujto a' och smam chi' yed' ix. ");
INSERT INTO cac_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Malajocab' junoc vin̈ vinac smulan yed' ix snulej ix snun, yujto a' och ix snun vin̈ chi' yed' ix. ");
INSERT INTO cac_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Malajocab' junoc vin̈ vinac syac' q'uixvelal yuc'tac smam smulan yed' ix yetb'eyum vin̈, yujto ichato ayto yuj sb'a yed' ix. ");
INSERT INTO cac_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Malajocab' junoc vin̈ vinac smulan yed' ix yalib', yujto yetb'eyum ix vin̈ yuninal vin̈, max yal-laj smulan vin̈ yed' ix. ");
INSERT INTO cac_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Malajocab' junoc vin̈ vinac syac' q'uixvelal yuc'tac yuj smulan yed' ix yetb'eyum vin̈ yuc'tac chi'. ");
INSERT INTO cac_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Tato ay junoc vin̈ vinac tz'ic'an junoc ix ix, max yal-laj smulan vin̈ yed' ix yune' ix, to schab'il yisil yaj ix. Max yalpaxlaj smulan vin̈ yed' ix yixchiquin ix, yixchiquin yuj junoc vin̈ yune' ix, ma yuj junoc ix yune' ix. Yelxo val te chuc icha chi', yujto yicn̈ej ix yaj eb' chi'. ");
INSERT INTO cac_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Malajocab' junoc vin̈ vinac syic'q'ue snulej yetb'eyum, max yal-laj yic'ani yacb'an pitzanto ix yetb'eyum chi', yic vach' max och ajc'olal d'a scal eb' ix. ");
INSERT INTO cac_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Malajocab' junoc vin̈ vinac ay tas sc'ulej yed' junoc ix ix ayic ayoch ix d'a stiempoal yic sb'isan uj. ");
INSERT INTO cac_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Malajocab' junoc vin̈ vinac smulan yed' ix yetb'eyum junocxo vinac, man̈ vach'oc scan eb' d'a yichan̈ ley. ");
INSERT INTO cac_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Malajocab' junoc vin̈ vinac sn̈usantz'a junoc yuninal silab'oc d'a jun comon dios scuchan Moloc. Tato sc'ulej icha chi', malaj velc'och d'a yol sat. A in Jehová in sval tic. ");
INSERT INTO cac_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Malajocab' junoc vin̈ vinac smulan yed' junoc yetvinaquil, icha sc'ulej yed' junoc ix ix, a jun chi' te yajb'entac. ");
INSERT INTO cac_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Malajocab' junoc vin̈ vinac smulan yed' noc' noc', malajocab' junoc mach syixtejb'at sb'a d'a icha chi'. Malajocab' pax junoc ix ix smulan yed' junoc noc' noc', yujto yelxo val man̈xo smojoc. ");
INSERT INTO cac_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Malajocab' mach syixtejb'at sb'a yed' juntzan̈ tic, yujto a d'a smasanil juntzan̈ tic, syixtejb'at sb'a juntzan̈ anima ol viq'uel d'a eyichan̈ tic. ");
INSERT INTO cac_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Yuj juntzan̈ chi', man̈xo pax vach'oc yaj sluum eb', van vac'an yovalil d'a eb', van vac'an satjocpaxel eb' d'a sluum chi'. ");
INSERT INTO cac_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","28","Masanil juntzan̈ chi', sb'eyb'alej juntzan̈ anima cajan d'a jun luum chi', ayic manto ex c'och cajan a ex tic. Yuj chi' yelxo val man̈ vach'oc yaj jun luum chi' yuj eb'. Palta a ex israel ex tic yed' eb' ch'oc chon̈ab'il ayec' cajan d'a e cal, yovalil tze b'eyb'alej, tze c'anab'ajanpax in checnab'il tic. Man̈ e c'ulej masanil juntzan̈ tastac man̈ vach'oc sc'ulej eb' chi', yic vach' max ex satjipax el a ex tic d'a jun luum chi'. ");
INSERT INTO cac_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","A mach sb'eyb'alan juntzan̈ tastac yajb'entac chi', yovalil satjiel d'a e cal. ");
INSERT INTO cac_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Yuj val chi' b'eyb'alejec in checnab'il, man̈ e b'eyb'alej juntzan̈ b'eyb'al yajb'entac chi', aton juntzan̈ sb'eyb'alaji ayic manto ex c'ochlaj ta', man̈ eyixtejb'at e b'a d'a icha chi'. A in Jehová e Diosal in svala', xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Al masanil juntzan̈ lolonel tic d'a eb' etisraelal: Vach'n̈ej tzeyutej e b'a, yujto a in Jehová in tic vach' inn̈ej. ");
INSERT INTO cac_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","C'anab'ajejec e mam e nun. Tze c'anab'ajej sleyal juntzan̈ sc'ual ic'oj ip to vic yaji. A in ton Jehová e Diosal in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Man̈ eyac'och e pensar d'a juntzan̈ yechel comon dios, man̈ e b'opaxq'ue q'uen q'ueen e diosaloc. A in ton Jehová e Diosal in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Ayic tzeyac'an silab' yic e junc'olal ved'oc, tze c'anab'ajej val icha sleyal, yuj chi' ol in cha d'ayex. ");
INSERT INTO cac_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","A noc' schib'ejal noc' tzeyac' silab'il chi', tze chi noc' d'a sc'ual chi' yed' d'a junxo c'u. Tato ayto noc' scan d'a schab'jial, sn̈uschajtz'a noc'. ");
INSERT INTO cac_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Tato tzato e chi noc' d'a schab'jial chi', chucxo d'a yol in sat, maxtzac in chalaj silab' chi' d'ayex. ");
INSERT INTO cac_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","A mach schi'an noc' d'a schab'jial chi', max tuplaj smul chi' d'a yib'an̈, yujto comon ix yutej tastac to vic yaji. A jun mach chi', man̈xalaj yalan yic d'a e cal. ");
INSERT INTO cac_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Ayic tze molanq'ue sat tas tzeyavej d'a e luum, man̈ pilanoc tzeyutej e molanq'ue d'a stitac, man̈ ex ec' d'an̈an̈ e sic'anq'ue ixim jolom trigo scan eyuuj. ");
INSERT INTO cac_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ayic tze molan sat te' uva, man̈ ex meltzaj e say eyil d'a schaelal, man̈ e sic'q'ue sat sc'ajb'anemi. A juntzan̈ chi' canocab'i, yicxo eb' meb'a' yed' eb' ch'oc chon̈ab'il yaji. A in ton Jehová e Diosal in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Man̈ ex elc'anoc, man̈ eyal esal lolonel, man̈ eyac' musansatil eb' eyetanimail. ");
INSERT INTO cac_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Man̈ e loc in b'i d'a es. Tato icha chi' tze c'ulej ichato malaj velc'och d'ayex. A in ton Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Man̈ comonoc tzeyixtej eb' eyetanimail, man̈ e toq'uec' tastac ay d'a eb'. Man̈ eyala' to ato q'uic'an tze tup sc'u eb' vin̈ e munlajvum smunlaj ticnaic. ");
INSERT INTO cac_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Man̈ e b'aj eb' chacan̈, man̈ eyaq'uem tas d'a yol sb'e eb' max uji yilani, palta ayocab' velc'och d'a yol e sat. A in ton Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Man̈ e b'o tas man̈ tojoloc ayic tze b'oan yaj junoc lolonel. Man̈ eyac'och e b'a yed' eb' meb'a', man̈ eyac'paxoch e b'a yed' eb' nivac yelc'ochi. Te tojoln̈ej tzeyutej e b'oanel tas yaj eb'. ");
INSERT INTO cac_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Man̈ ex alvoc pecal d'a scal eb' eyetchon̈ab'. Man̈ e nachaan̈ esal lolonel d'a yib'an̈ junoc eyetanimail yic smiljichamoc. A in ton Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Mocab' chichonoch e c'ol d'a junoc eyetanimail, palta vach' to tze cacha' tzeyac'an srazón yic vach' max cotcan d'a eyib'an̈ yed'oc. ");
INSERT INTO cac_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Man̈ e pac e b'a, mocab' chichonn̈ejoch e c'ol d'a eb' eyetchon̈ab'. Tze xajanej eb' ay d'a spatic schiquin e pat icha tzeyutej e ya ilan e b'a. A in ton Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","C'anab'ajejec juntzan̈ in checnab'il tic. Man̈ e cha tajnoc noc' e molb'etzal noc' yed' junocxo noc' noc' ch'oc yin̈tilal. Man̈ e som eyin̈at tzeyavej d'a e luum. Man̈ eyac'och c'apac pichul soman sch'alil yed' junocxo macan̈ an̈ ch'al. ");
INSERT INTO cac_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Tato ay junoc ix schecab' junoc mach ayxo strato yed' junocxo vin̈ vinac, palta tato ay junocxo vin̈ smulan yed' ix, tz'ac'ji yovalil d'a eb' schavan̈il. Max miljichamlaj eb', yujto mantzac tupji yic tz'el ix d'a libre. ");
INSERT INTO cac_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","A vin̈ smulan yed' ix chi', yovalil syic'cot junoc noc' ch'ac calnel vin̈ silab'il yuj smul chi' d'a stielxo in cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Smiljicham noc', axo junoc vin̈ sacerdote tz'ac'anoch noc' d'a vichan̈, yuj stupchaj smul vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Ayic ol ex c'och d'a lum Canaán, ol eyavan masanil macan̈il te avb'en te' syac' sat. Oxe' ab'il max eyamlaj junoc sat te' chi' yic tze loani, yujto ay yovalil d'a yol in sat. ");
INSERT INTO cac_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Axo d'a schan̈il ab'il, masanil sat te' syac' chi', tzeyac' masanil d'ayin ofrendail yuj eyac'an yuj diosal, yujto vic yaj te' sat chi'. ");
INSERT INTO cac_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Axo d'a yoil ab'il, eyicxo yaj sat te' chi' yic tze lo'o. Tato ol e c'anab'ajej sleyal tic, yelxo val ol yac' sat te'. A in ton Jehová e Diosal in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Man̈ e chi noc' chib'ej to max el schiq'uil. Man̈ eyac'och e b'a e naanel tas tzuji, man̈ eyac'paxoch e b'a d'a ajchumal. ");
INSERT INTO cac_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Man̈ setansetanoc tz'aj sjoxjiel xil e jolom, man̈ e joxpaxel xil e sat. ");
INSERT INTO cac_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Man̈ eyac' echnaj e b'a yuj cusc'olal yuj junoc chamnac, man̈ eyac'och yechel junoc tas d'a e nivanil. A in ton Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Man̈ eyac' q'uixvelal ix eyisil, tzeyac'anoch ix ajmul ixal d'a stemplo juntzan̈ comon dios, yic vach' max ixtaxel sb'eyb'al eb' anima, yic max ixtaxpaxel e chon̈ab' yuj ajmulal. ");
INSERT INTO cac_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Yovalil tze c'anab'ajej sleyal juntzan̈ sc'ual ic'oj ip to vic yaji. Ayocab' yelc'och in cajnub' d'a yol e sat. A in Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Man̈ ex b'at e c'anb'ej e b'a d'a eb' ajchum, ma d'a eb' sc'uman spixan eb' chamnac yalani, yic vach' max eyixtejb'at e b'a. A in Jehová e Diosal in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Q'uean̈ec lin̈an d'a yichan̈ eb' ichamtac anima, nivanocab' yelc'och eb' d'a yol e sat. Ayocab'pax velc'och d'a yol e sat. A in ton Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Man̈ eyixtej junoc anima ch'oc chon̈ab'il ayec' d'a e cal. ");
INSERT INTO cac_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Xajan tzeyutej eb', ichato eyetchon̈ab' eb'. Ya'ilejec eb', icha tz'aj eya'ilan e b'a. Tze nacoti to a ex tic najtil ec'nac ex d'a ch'oc chon̈ab'il d'a yol yic Egipto. A in ton Jehová e Diosal in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Man̈ eyixtej eb' anima d'a tas tze chon̈o', tz'acanocab' eyechlab' tzeyac'lab'ej, icha e ch'an̈ ayic tzeyechtan e luum ma juntzan̈xo echlab' tze c'ana'. ");
INSERT INTO cac_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","A e libra yed' eyalmul tze c'ana', tz'acanocab'i. A in ton Jehová e Diosal in ix ex viq'uelta d'a Egipto, a in svala'. ");
INSERT INTO cac_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Yuj val chi', yovalil tze c'anab'ajej in b'eyb'al yed' masanil in checnab'il tic. A in ton Jehová in svala', xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Al masanil juntzan̈ checnab'il tic d'a eb' etisraelal: Yaln̈ej mach ex, ma eb' ch'oc chon̈ab'il ayec' cajan d'a e cal tz'ac'an junoc yuninal silab'il d'a comon dios scuchan Moloc, a jun chi' yovalil sjulq'uenajcham yuj eb' yetchon̈ab'. ");
INSERT INTO cac_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Scotpax voval d'a jun anima chi', tzin satel d'a scal eb' yetchon̈ab', yujto ix yixtejb'at in cajnub', ix in spaticaneli, yujto syac' yuninal silab'il d'a jun comon dios chi'. ");
INSERT INTO cac_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Tato a eb' yetchon̈ab' ton̈ej syilochi, max sjulq'uenejcham jun anima chi' eb', ");
INSERT INTO cac_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","a in val ol vac' yovalil d'a jun anima chi', d'a yetb'eyum, d'a yuninal yed' d'a masanil eb' cajan yed' d'a yol spat. Ol in satel eb' d'a scal eb' yetchon̈ab' yed' eb' syaq'uem sb'a d'a comon dios Moloc chi' yed'oc. ");
INSERT INTO cac_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Tato ay mach sb'at sc'anb'ej sb'a d'a eb' ajb'aal, ma d'a eb' sc'uman spixan eb' chamnac yalani, sc'anab'ajan tas syal eb' chi', ol vac' yovalil d'a jun anima chi', ol in satel d'a scal yetchon̈ab'. ");
INSERT INTO cac_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Juneln̈ej tzeyac'och e b'a d'a yol in c'ab', vach'n̈ej tzeyutej e b'a, yujto a in Jehová in tic, e Diosal in. ");
INSERT INTO cac_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","A val in b'eyb'al tze b'eyb'alej, tze c'anab'ajani, yujto a in Jehová in tzex vac'och vicoc. ");
INSERT INTO cac_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Yaln̈ej mach sb'aj smam snun yovalil schami, a val tz'ic'ancot schamel chi' d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Tato ay junoc vin̈ vinac smulan yed' ix yetb'eyum junoc yetanimail, yovalil scham jun vinac chi' yed' jun ix ix chi'. ");
INSERT INTO cac_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Tato ay junoc vin̈ vinac smulan yed' ix yetb'eyum smam, syac' q'uixvelal smam chi'. A jun vinac chi' yovalil schami, schampax ix ix chi', a val eb' tz'ic'ancot schamel d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Tato ay junoc vin̈ vinac smulan yed' ix yalib', yovalil scham eb' schavan̈il, yujto yelxo val te chuc sc'ulej eb'. A val eb' tz'ic'ancot schamel d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Tato ay junoc vin̈ vinac smulan yed' yetvinaquil, icha sc'ulej yed' junoc ix ix, yovalil scham eb' schavan̈il. A val eb' tz'ic'ancot schamel d'a yib'an̈, yujto yajb'entac tas sc'ulej eb' chi'. ");
INSERT INTO cac_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Tato ay junoc vin̈ vinac tz'ic'an junoc ix ix, syic'anpaxq'ue snun ix ix chi' vin̈, te chuc tas sc'ulej eb' chi', yuj chi' a jun vin̈ vinac chi' yed' chavan̈ eb' ix ix chi', sn̈usjitz'a eb'. Yuj chi' man̈xa b'aj ol b'inaj jun b'eyb'al chi' d'a e cal. ");
INSERT INTO cac_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Tato ay junoc vin̈ vinac smulan yed' junoc noc' noc', a vin̈ chi' yovalil scham vin̈, schampax noc' noc' chi'. ");
INSERT INTO cac_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Tato ay pax junoc ix ix smulan yed' junoc noc' noc', a jun ix chi' yovalil scham ix, schampax jun noc' noc' chi'. A val tz'ic'ancot schamel d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Tato ay junoc vin̈ vinac syic' yanab' yetb'eyumoc, yanab' yuj smam ma yanab' yuj snun, a chavan̈ eb' chi', d'a val yichan̈ eb' yetchon̈ab' eb' satjieli, yujto a mach smulan yed' yanab', yelxo val q'uixvelal tas sc'ulej eb' chi', yuj chi' a mach icha chi' sc'ulej, a smul chi' scotcan d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Tato ay junoc vin̈ vinac ay tas sc'ulej yed' junoc ix ix ayic ayoch ix sb'isan uj, malaj yelc'och d'a yol sat vin̈ tas tz'ic'an ix chi', b'ecanpax sc'ol ix sch'oxanel syaelal chi', yuj chi' man̈xaocab' yalan yic eb' schavan̈il d'a e cal. ");
INSERT INTO cac_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Malajocab' junoc vin̈ vinac smulan yed' yanab' smam, ma yed' snulej snun, yujto syac' sq'uixvelal vin̈ mach ayto yuj sb'a yed'oc. A yuj smul eb' chi' scot d'a yib'an̈ schavan̈il. ");
INSERT INTO cac_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Tato ay junoc vin̈ vinac smulan yed' ix yetb'eyum vin̈ yuc'tac smam ma vin̈ snulej snun, syac' val q'uixvelal jun yicham chi', a yuj smul eb' chi' scot d'a yib'an̈ schavan̈il, yuj chi' smiljicham eb', malaj yin̈tilal eb' scani. ");
INSERT INTO cac_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Tato ay junoc vin̈ vinac smulan yed' ix yetb'eyum vin̈ yuc'tac, syac' q'uixvelal vin̈ yuc'tac vin̈ chi', a jun chi' yajb'entac, yuj chi' smiljicham eb', malaj yin̈tilal eb' scani. ");
INSERT INTO cac_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","B'eyb'alejec in b'eyb'al, tze c'anab'ajan masanil in checnab'il tic yic vach' man̈ ol ex in satel d'a lum luum b'aj ol ex c'och cajan chi'. ");
INSERT INTO cac_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Man̈ e b'eyb'alej sb'eyb'al eb' anima ol viq'uel d'a eyichan̈ chi'. A eb' chi', sb'eyb'alej masanil juntzan̈ chucal tic eb', yuj chi' tzin chaquel eb'. ");
INSERT INTO cac_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","A in val ix vac' in ti' to ol vac' eyiquejcan slum eb' chi' e macb'enoc, lum te yax sat. A in Jehová e Diosal in, ex in sic'naquelta d'a scal juntzan̈xo chon̈ab'. ");
INSERT INTO cac_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Yuj chi' yovalil ay sq'uexan̈il noc' noc' vach' yed' noc' man̈ vach'oc d'a yol e sat yed' d'a scal noc' much vach' yed' noc' man̈ vach'oc. Yuj chi' man̈ e juel e b'a d'a vichan̈ yuj e chi'an noc' noc' man̈ vach'oc chi', noc' much, noc' sn̈ervi, ma noc' sjachvi d'a sat lum tic, aton noc' ix vala' to man̈ vach'oc. ");
INSERT INTO cac_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Palta yovalil vach' tzeyutej e b'a d'a vichan̈, yujto vach' inn̈ej a in tic. A in Jehová in tic ix ex in siq'ueli, to ch'oc eyel d'a yichan̈ juntzan̈xo chon̈ab', yic vach' in chon̈ab' tzex aji. ");
INSERT INTO cac_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Tato ay junoc vin̈ vinac ma junoc ix ix d'a e cal sc'uman spixan eb' chamnac yalani, yovalil sjulq'uenajchamoc. A val tz'ic'ancot schamel chi' d'a yib'an̈, xchi Jehová, xa chi, xchi d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: Al d'a eb' sacerdote, eb' yin̈tilal vin̈aj Aarón, mocab' c'och eb' d'a stz'ey junoc chamnac yic man̈ chucoc scan eb' d'a yichan̈ ley, vach'chom ayto yuj sb'a eb' yed' jun chamnac chi'. ");
INSERT INTO cac_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","An̈ej tato a snun, ma smam, ma junoc yuninal, ma junoc yisil, ma junoc yuc'tac, ");
INSERT INTO cac_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ma junoc yanab' eb' cob'es ayec' cajan yed'oc, a schami, syal sc'och eb' d'a stz'ey jun chamnac chi'. ");
INSERT INTO cac_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Palta max yal-laj sc'och eb' d'a stz'ey junoc chamnac sc'ab' yoc ix yetb'eyum eb'. ");
INSERT INTO cac_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Mocab' sjoxel xil sjolom eb', mocab' sjoxpaxel xil sti' eb', mocab' yac'pax echnaj snivanil eb' yuj schamel junoc anima. ");
INSERT INTO cac_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Palta vach'n̈ejocab' syutej sb'a eb' yujto vicn̈ej yaj eb'. Mocab' chucoc in b'inaj yuj eb', yujto a eb' sn̈usantz'a silab', syac'an ixim pan eb' ofrendail d'ayin, yuj chi' yovalil vach'n̈ejocab' syutej sb'a eb'. ");
INSERT INTO cac_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Max yalpaxlaj yic'an junoc ix ajmul ix eb', ma junoc ix ix ayxo vinac ix ec' d'ay, ma junoc ix ix spucnac sb'a yed' yetb'eyum, yujto sic'b'ilel eb' yic tz'ochcan vicoc. ");
INSERT INTO cac_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Ch'ococab' yel eb' d'a yol e sat, yujto a eb' tz'ac'anoch ixim pan ofrendail d'a vichan̈, yujto a in Jehová in vach' inn̈ej, a in ix in sic'canel eb' yic vach' tz'ajcan eb'. ");
INSERT INTO cac_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Tato ay junoc eb' ix yisil junoc eb' sacerdote chi' tz'och d'a ajmul ixal, syac' q'uixvelal smam ix chi', yovalil sn̈usjitz'a ix. ");
INSERT INTO cac_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","A vin̈ sat sacerdote ix ic'jiq'uechaan̈ d'a scal eb' yuc'tac ayic ix ac'jiq'ue aceite d'a sjolom, ayic ix ac'chajoch spichul vin̈ te nivan yelc'ochi, max yal-laj toxon̈ej sb'at tzican xil sjolom vin̈, max yalpaxlaj sn̈ic'anb'at spichul vin̈ yuj sch'oxanel scusc'olal. ");
INSERT INTO cac_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Max yalpaxlaj sc'och vin̈ b'aj ayec' junoc chamnac, vach'chom smam, ma snun yic max yixtejb'at sb'a vin̈. ");
INSERT INTO cac_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","A yuj schamel eb' chi' max yal-laj yel vin̈ d'a in cajnub', max yalpaxlaj to syixtejb'at in cajnub' chi' vin̈, yujto ix ac'jioch aceite d'a vin̈ yic sic'chajcaneli, yic tz'ochcan vicoc. A in Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","A vin̈ sat sacerdote, a junoc ix cob'es mantalaj vinac tz'ec' d'ay, a ix syic' vin̈. ");
INSERT INTO cac_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Max yal-laj yic'lan sb'a vin̈ yed' junoc ix chamnacxo yetb'eyum, ma yed' junoc ix spucnac sb'a yed' yetb'eyum, ma yed' junoc ix ayxo vinac tz'ec' d'ay, ma yed' junoc ix ajmul ix. Palta yovalil a junoc ix cob'es ix syic' vin̈, junoc ix yetchon̈ab' vin̈, ");
INSERT INTO cac_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","yic man̈ malajoc tz'aj yelc'och eb' yuninal vin̈ d'a scal eb' yetchon̈ab', yujto a in Jehová in ix in sic'canel vin̈, xchi Jehová, d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Al d'a vin̈aj Aarón: Ticnaic yed' d'a masanil tiempo, malaj junoc eb' yin̈tilal vin̈ ay palta d'a snivanil ol yal yac'an yofrenda eb' yetchon̈ab' d'ayin. ");
INSERT INTO cac_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","20","Yuj chi' yel val malaj junoc ay spaltail snivanil chi' ol yal yoch d'a jun opisio chi': Aton eb' max yal yilani, eb' tz'em sb'eyi, eb' palta sn̈i' ma schiquin, eb' q'uichajnac xub' ma sc'ab', eb' n̈ojanemi sb'eyi, eb' tzapan steel yujto nenetac yoc eb' yed' sc'ab', eb' ayoch yaax d'a yol sat, eb' aycan sjech'al junoc yab'il d'ay, eb' ay yaxc'a d'a snivanil yed' eb' mac'b'ilpoj sn̈olob' sq'ueen. ");
INSERT INTO cac_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Malaj junoc eb' yin̈tilal vin̈aj Aarón chi' ay palta d'a snivanil syal yoch d'a vichan̈ yed' silab' to sn̈usjitz'aoc. Tato ay palta d'a snivanil chi', max yal-laj yac'an ofrenda d'ayin. ");
INSERT INTO cac_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Syal svaan juntzan̈ ofrenda chi' eb' yed' masanil juntzan̈ tastac to vic yaji, ");
INSERT INTO cac_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","palta max yal-laj yoch eb' d'a in cajnub', ma sc'och eb' d'a stz'ey altar, yic max yixtejb'at in cajnub' chi' eb', yujto a in Jehová in, vic yaj juntzan̈ tastac chi', xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Yuj chi' masanil juntzan̈ tic ix yal vin̈aj Moisés d'a vin̈aj Aarón yed' d'a eb' yuninal vin̈ yed' d'a masanil eb' yetisraelal. ");
INSERT INTO cac_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Ix lolonxi Jehová d'a vin̈aj Moisés chi', ix yalani: ");
INSERT INTO cac_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Al d'a vin̈aj Aarón yed' d'a eb' yin̈tilal to sya'ilej val sb'a eb' yed' ofrenda syac' eb' eyetisraelal d'ayin, yic man̈ chucoc tz'aj in b'inaj yuj eb'. A in val Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Al d'a eb' to a ticnaic yed' d'a masanil tiempo, yaln̈ej mach junoc yin̈tilal eb' tz'ic'ancot juntzan̈ silab' d'a vichan̈, aton juntzan̈ syac' eb' eyetisraelal d'ayin, tato man̈ vach'oc yaj jun tz'ic'ancot jun silab' chi' icha yalan ley, yovalil tz'ic'jiel d'a yopisio d'a vichan̈. A in val Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Malaj pax junoc yin̈tilal vin̈aj Aarón chi' syal svaan tastac to vic yaji tato ay lepra d'ay, ma ay tas tz'el d'a svinaquil, palta ato yic vach'xo yaji icha yalan ley, ichato chi' syal svaani. Tato syam junoc tas to man̈ vach'oc, junoc chamnac, ma junoc vinac tz'el yin̈atil, man̈ vach'oc tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Man̈ vach'oc tz'ajcani tato syam junoc noc' noc' man̈ vach'oc d'a yichan̈ ley, ma syam junoc anima man̈ vach'oc pax yaj yuj yaln̈ej tasi. ");
INSERT INTO cac_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Tato man̈ vach'oc yaji, max yal-laj svaan junoc tas to vic yaji, masanto sb'iquel sb'a. ");
INSERT INTO cac_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ato yic tz'em c'u, vach'xo yaji. Ichato chi' tzaxo yal svaan masanil tas to vic yaji yujto yictaxon yaji. ");
INSERT INTO cac_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","A eb' yin̈tilal vin̈aj Aarón chi' max yal-laj schi'an schib'ejal junoc noc' noc' eb', aton noc' ton̈ej schami, ma noc' scham yuj noc' caltacte'al noc', yic man̈ chucoc scan eb'. A in Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Al d'a eb' to sc'anab'ajej in checnab'il eb', yic max och smul eb', yic max champax eb'. Tato malaj yelc'och in checnab'il chi' d'a yol sat eb', scot juntzan̈ tic d'a yib'an̈ eb', yujto a in Jehová in ix in sic'canel eb'. ");
INSERT INTO cac_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Malaj mach syal svaan tastac to vic yaji tato malaj yuj sb'a yed' eb' vin̈ sacerdote. Eb' ton̈ej ayec' posado d'a eb', ma eb' ton̈ej smunlaj d'a eb', max yal-laj svaan eb'. ");
INSERT INTO cac_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Tato ay junoc schecab' junoc vin̈ sacerdote manb'il yuuj, mato ay pax eb' tz'alji d'a yol scuenta vin̈, a eb' chi' syal svaan eb' masanil tas to vic yaji. ");
INSERT INTO cac_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Tato a ix yisil junoc vin̈ sacerdote syic' junoc vinac ch'oc yel d'a scal eb' sacerdote, maxtzac yal-laj svaan juntzan̈ ofrenda chi' ix, aton juntzan̈ tz'ac'ji d'a eb' vin̈ sacerdote chi'. ");
INSERT INTO cac_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Palta tato chamnacxo vin̈ yetb'eyum ix, mato spucnac sb'a ix yed' vin̈ yetb'eyum chi', malaj pax junoc yune' ix, meltzajnac ix yic scajnajxi ix yed' vin̈ smam chi', ichataxon ayic cob'esto ix, syal svaan svael vin̈ smam ix chi'. Axo pax juntzan̈xo eb' man̈ yin̈tiloc eb' sacerdote, max yal-laj svaan eb'. ");
INSERT INTO cac_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Tato ay junoc mach comonn̈ej schi'an noc' chib'ej to vic yaji, tato man̈ yojtacoc to vic yaji, yovalil syac' sq'uexul d'a jun vin̈ sacerdote chi', syac'an jab'ocxo d'a yib'an̈ jun ix yac' sq'uexul chi'. ");
INSERT INTO cac_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Palta a eb' vin̈ sacerdote yovalil man̈ comonoc scha' eb' vin̈ chijoc tastac syac' eb' eyetchon̈ab' d'ayin. ");
INSERT INTO cac_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Tato ay junoc mach comonn̈ej schi'an noc' chib'ej vic yaj chi', man̈ ton̈ejoc syiloch vin̈ sacerdote chi', palta yovalil a jun ix chi'an noc' chi', syac' noc' silab' yic spacoc jun smul chi', yujto a in Jehová in ix in sic'canel juntzan̈ noc' chib'ej chi' vicoc, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ix yalanxi Jehová d'a vin̈aj Moisés chi': ");
INSERT INTO cac_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Al d'a vin̈aj Aarón yed' d'a eb' yuninal yed' d'a masanil eb' eyetisraelal masanil juntzan̈ tic: Tato ay ex, ma eb' ch'oc chon̈ab'il ayec' cajan d'a e cal, tzeyac' junoc noc' noc' yic sn̈usjitz'a silab'il d'ayin, vach'chom yuj b'aj ix eyac' e ti' eyac'ani, mato ton̈ej tz'el d'a e c'ol eyac'ani, ");
INSERT INTO cac_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","yovalil a junoc noc' smam malaj jab'oc spaltail tzeyac'a' yic vach' tzin cha jun silab' chi'. A junoc noc' toro, ma junoc noc' ch'ac calnel, ma junoc noc' mam chiva tzeyac'a', ");
INSERT INTO cac_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","palta man̈oc junoc noc' ayoch syab'il. Tato ya'ay noc', max in chalaj noc'. ");
INSERT INTO cac_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Yaln̈ej mach ex tzeyac' junoc silab' yic junc'olal d'ayin, vach'chom yuj b'aj ix eyac' e ti' eyac'ani, ma ton̈ej tz'el d'a e c'ol eyac'ani, yovalil a junoc noc' vacax, ma junoc noc' calnel, ma junoc noc' chiva, malaj spaltail tzeyac'a', yic vach' tzin cha d'ayex. ");
INSERT INTO cac_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Man̈ eyac' junoc noc' noc' penaay d'ayin, icha noc' malaj yol sat, noc' lajvinac, noc' q'uiich, noc' elnac junoc macan̈ snivanil, ma ay syaxc'ail, ma junoc yab'il d'ay. A juntzan̈ noc' icha chi', max yal-laj sn̈usjitz'a noc' d'a valtar. ");
INSERT INTO cac_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","A mach ex tz'el d'a e c'ol eyac'an junoc noc' silab' d'ayin, a junoc noc' vacax, ma junoc noc' calnel syal eyac'ani, vach'chom man̈ lajanoc steel yoc noc'. Palta tato a junoc silab' ix eyac' e ti' eyac'ani, max in chalaj noc' icha chi' yaji. ");
INSERT INTO cac_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","A junoc noc' lajvinac sq'ueen, ma pojnac, ma ic'b'ilel sq'ueen noc' chi', max yal-laj eyac'an noc' silab'il d'ayin. Man̈ e b'eyb'alej eyac'an juntzan̈ noc' chi' silab'il d'ayin. ");
INSERT INTO cac_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Man̈ e cha juntzan̈ noc' noc' icha chi' d'a eb' ch'oc chon̈ab'il yic tz'och silab'il d'ayin, yujto man̈ tz'acanoc yaj noc', max in chapaxlaj noc', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Ix yalanxi Jehová chi' d'a vin̈: ");
INSERT INTO cac_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Ayic tz'alji junoc noc' yune' vacax, ma junoc noc' yune' calnel, ma junoc noc' yune' chiva, uque' c'ual yovalil scan noc' yed' snun, axo d'a svajxaquil c'ual, tzaxo yal sn̈usjitz'a noc' silab'il d'a vichan̈. ");
INSERT INTO cac_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Max yal-laj junn̈ej c'ual tz'aj smiljicham junoc noc' snun yed' noc' yune'. ");
INSERT INTO cac_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Tato tz'ac'ji junoc silab' d'ayin yuj ac'oj yuj diosal, ujocab' icha d'a sleyal yic vach' tzin cha'a. ");
INSERT INTO cac_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","An̈ejtona', tze chib'at noc' d'a jun c'ual chi', max yal-laj scan noc' d'a junocxo c'u. A in Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","B'eyb'alejec in checnab'il, tze c'anab'ajanpaxi. A in Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Mocab' chucoc tz'aj in b'inaj eyuuj, palta to tzin eyic'chaan̈, yujto a in val ix ex in sic'caneli, ");
INSERT INTO cac_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ix ex vic'anelta d'a Egipto yic tzin och e Diosaloc. A in Jehová in svala', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi': ");
INSERT INTO cac_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Al d'a eb' etisraelal to a in sval icha tic: A juntzan̈ q'uin̈ tic, valnaccani to vicn̈ej yaji, aton yic tze molb'an e b'a yic tzin eyic'anchaan̈. ");
INSERT INTO cac_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Vaque' c'ual tzex munlaji, axo d'a yuquil c'ual man̈xa junoc tas tze c'ulej. Tzeyic' eyip, tze molb'an e b'a eyoch ejmelal d'ayin yaln̈ej b'aj ayex eq'ui. Aton jun c'ual ic'oj ip chi' vicn̈ej yaji. ");
INSERT INTO cac_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Aton juntzan̈ q'uin̈ tic nivan yelc'ochi yuj in eyic'anchaan̈ ayic tze molb'an e b'a eyoch ejmelal d'a sc'ual valnaccani. ");
INSERT INTO cac_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","A q'uin̈ yic tze naancoti ayic ex vic'anelta d'a Egipto, tz'el yich d'a yemc'ualil d'a 14 yoch b'ab'el uj. Aton jun q'uin̈ chi' tzeyac'ochi yic tzin eyic'anchaan̈. ");
INSERT INTO cac_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Axo d'a 15 yoch jun uj chi', tzeyac'anpaxoch q'uin̈ yic ixim pan malaj yich yuj in eyic'anchaan̈. Uque' c'ual an̈ej ixim pan malaj yich tze va'a. ");
INSERT INTO cac_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","A val d'a sb'ab'el c'ual chi', tze molb'anoch e b'a ejmelal d'a vichan̈. Malaj junoc macan̈ munlajel tze b'o d'a jun chi'. ");
INSERT INTO cac_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","A d'a uque' c'ual chi', tze n̈usn̈ejtz'a silab' d'ayin. A d'a yuquil c'ual tze molb'anoch e b'a ejmelal d'ayin. Malaj junoc macan̈ munlajel tze b'o'o, xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Ix yalanpax Jehová d'a vin̈aj Moisés chi': ");
INSERT INTO cac_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Al d'a eb' etisraelal icha tic: Ayic ayexxo ec' d'a sat lum luum ol vac' chi' d'ayex, ayic ol e chaanel yich e jochan ixim e trigo, a jun b'ab'el manoja tze joch chi', tzeyic'cot d'a eb' vin̈ sacerdote. ");
INSERT INTO cac_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Axo d'a junxo c'u ayic slajvicanec' sc'ual ic'oj ip, syac'an eb' sacerdote chi' ofrendail tas tzeyac' chi', sb'achanochta eb' d'a vichan̈, yic vach' tzin cha d'ayex. ");
INSERT INTO cac_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","A d'a sc'ual tzeyac' ixim e trigo chi' ofrendail d'ayin, ata' tze n̈uspaxtz'a junoc noc' calnel silab'il d'a vichan̈, noc' jun ab'il sq'uinal, mocab'a jab'oc spaltail noc'. ");
INSERT INTO cac_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Tzeyic'anpaxcot lajun̈eoc libra ixim harina te vach' calab'il yed' aceite, yic stz'a ofrendail to suc'uq'ui sjab' svab'i. Tzeyac'anpax junoc litro vino ofrendail, secjiem d'a yib'an̈ juntzan̈ ofrenda chi'. ");
INSERT INTO cac_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","A ixim ac' trigo sjochchaj chi', max yal-laj e vaan ixim d'a panil. Max yalpaxlaj e b'olan ixim e c'uxu', ma eyax c'uxani, masanto d'a jun sc'ual a tzeyac'an ixim b'ab'el manoja ofrendail d'ayin e Diosal in. A jun tic ley tz'ajcan d'ayex d'a masanil tiempo yaln̈ej b'aj ayex eq'ui. ");
INSERT INTO cac_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Axo d'a junxo c'u ayic toxo ix lajvicanec' sc'ual ic'oj ip, ayic tzeyic'ancot jun manoja ixim trigo ofrendail, aton d'a jun c'u chi' tze b'is uque' semana. ");
INSERT INTO cac_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Axo d'a junxo c'u, ma d'a 50 c'ual yic toxo ix tz'acvi uque' c'ual ic'oj ip chi', ata' tzeyac'pax junocxo ofrenda d'a ixim trigo chi' d'ayin. ");
INSERT INTO cac_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Tzeyic'cot chab'oc ixim pan ofrendail ichataxon ixim eyic tze va'a. Vajxaque' libra ixim harina te vach' tz'och d'a junjun ixim, ayocab' b'at yich d'a scal ixim. A ixim pan chi' sb'achjioch ixim d'a vichan̈ ofrendail d'a ixim b'ab'el tz'eluli yaln̈ej b'aj cajan ex eq'ui. ");
INSERT INTO cac_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Yed' ixim pan chi', syac' ucvan̈oc noc' quelemtac calnel eb' eyetchon̈ab', jun ab'il sq'uinal junjun noc' yed' jun noc' quelem vacax yed' pax chavan̈oc noc' ch'ac calnel. Malajocab' jab'oc spaltail juntzan̈ noc' noc' chi'. A noc' chi' sn̈usjitz'a smasanil d'ayin Jehová in tic, junn̈ej tz'aj stz'a yed' ixim eyofrenda trigo yed' pax ofrenda d'a vino. A jun ofrenda stz'a chi' suc'uq'ui sjab' svab'i. ");
INSERT INTO cac_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Tzeyac'anpax junoc noc' mam chiva silab'il yuj stupcanel e mul. Tzeyac'anpax chavan̈oc noc' calnel junjun ab'il sq'uinal ofrendail yuj e ch'oxanel e junc'olal ved'oc. ");
INSERT INTO cac_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","A vin̈ sacerdote sb'achanoch chavan̈ noc' calnel d'a vichan̈ a in Jehová in tic yed' ixim pan ix b'o d'a ixim trigo ix b'ab'laj jochchaji, a jun ofrenda chi' vic yaji, scan d'a vin̈ sacerdote chi'. ");
INSERT INTO cac_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","A d'a sc'ual jun q'uin̈ chi' malaj junoc macan̈ munlajel syal e b'oani. Tze molb'anoch e b'a eyoch ejmelal d'ayin. A jun tic ley tz'ajcan d'a e cal yed' d'a scal eyin̈tilal d'a masanil tiempo yaln̈ej b'ajtil ayex eq'ui. ");
INSERT INTO cac_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Ayic sc'och stiempoal e jochan ixim e trigo, man̈ e sic'q'ue ixim scan d'a scal yoc yed' ixim ay d'a stitac, yujto a juntzan̈ chi' yic eb' meb'a' yaji yed' eb' ch'oc chon̈ab'il ayec' d'a e cal. A in Jehová e Diosal in svala', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Ix yalanpax Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Al d'a eb' etchon̈ab' icha tic: A d'a sb'ab'el c'ual yic yuquil uj, tzeyic' eyip, tze molb'anoch e b'a ejmelal d'ayin, spuji q'uen trompeta yic tze naancot in vach'c'olal. ");
INSERT INTO cac_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Yovalil tze n̈ustz'a junoc noc' silab' d'ayin. Malaj junoc ex tzex munlaj d'a jun c'u chi', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Ix yalanpax Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","A d'a slajun̈il c'ual yoch yuquil uj, aton d'a sc'ual yic tz'ac'jican lajvoc e mul, tze molb'ejoch e b'a ejmelal d'ayin. Tzex ochpax d'a tzec'ojc'olal, tze n̈usantz'a ofrenda silab'il d'ayin a in Jehová in tic. ");
INSERT INTO cac_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Man̈ ex munlaj d'a jun c'u chi', yujto a val d'a jun c'u chi' stupcanel e mul d'a vichan̈ a in Jehová e Diosal in tic. ");
INSERT INTO cac_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Tato ay junoc mach max c'anab'ajan yoch d'a tzec'ojc'olal d'a jun c'u chi', yovalil satjiel d'a e cal. ");
INSERT INTO cac_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","An̈ejtona', yaln̈ej mach smunlaj d'a jun c'u chi', tzin sateli. ");
INSERT INTO cac_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Malaj junoc mach smunlaj d'a junoc yaln̈ej tas munlajelal d'a jun c'u chi'. A jun tic ley tz'ajcan d'a e cal yed' d'a scal eb' eyin̈tilal d'a masanil tiempo yaln̈ej b'ajtil ayex eq'ui. ");
INSERT INTO cac_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","A jun c'u chi', aton val yic tzeyic'an eyip, yic tzex ochpax d'a tzec'ojc'olal, tz'el yich d'a val sb'alun̈il c'ual yoch uj d'a q'uic'b'alil, masanto d'a q'uic'b'alil d'a junxo c'u, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Ix yalanpax Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Al d'a eb' etchon̈ab': Ayic 15 yoch yuquil uj, tze chaan uque' c'ual sq'uin̈al chinama yuj in eyic'anchaan̈. ");
INSERT INTO cac_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Tze molb'anoch e b'a ejmelal d'a b'ab'el c'u. A d'a jun c'ual chi', malaj junoc mach smunlaji. ");
INSERT INTO cac_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","A d'a uque' c'ual chi', junjun c'u tze n̈usantz'a silab' d'ayin, axo d'a svajxaquil c'ual, tze molb'anoch e b'a ejmelal, tze n̈usantz'a silab', yujto in q'uin̈ yaji, malaj junoc mach smunlaji. ");
INSERT INTO cac_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(Aton d'a juntzan̈ q'uin̈ tic tzin eyic'chaan̈ a in Jehová in tic. Tze molb'anoch e b'a ejmelal, tze n̈usantz'a silab'. Ay silab' sn̈usjitz'aoc yed' ofrenda d'a tas svaji. Tz'ac'jipax vino silab'il yed' ofrendail. Junjun macan̈ juntzan̈ silab' tic tz'ac'ji, ato a' sc'ual alb'ilcani. ");
INSERT INTO cac_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ch'oc yel juntzan̈ silab' chi' d'a yichan̈ juntzan̈ tz'ac'ji d'a sc'ual ic'oj ip valnac. Ch'oc yel juntzan̈ silab' chi' d'a yichan̈ silab' tz'ac'jitaxoni. Ch'oc yel pax d'a yichan̈ e silab' tzeyac' e ti' eyac'ani yed' d'a eyofrenda tz'el d'a e c'ol eyac'an d'ayin a in Jehová in tic.) ");
INSERT INTO cac_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Axo d'a 15-xo yoch yuquil uj, ayic toxo ix molchaj sat avb'en tz'el d'a sat lum luum, tzeyac'anoch sq'uin̈al d'a vichan̈ d'a uque' c'ual. A b'ab'el c'u, sc'ual ic'oj ip, an̈ejtona' pax d'a yucub'ixial. ");
INSERT INTO cac_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","A d'a b'ab'el c'u chi', tzeyic'cot sattac te te' te vach', xiltac apac', sc'ab' te' tac'u ay d'a titac a' yed' sc'ab' juntzan̈xo te' c'ayum xiil yic tzeyac'anoch q'uin̈ yic chinama. Icha val chi' tz'aj eyac'an tzalajb'oc e c'ol d'a uque' c'ual chi' d'a vichan̈ a in Jehová e Diosal in tic. ");
INSERT INTO cac_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","D'a yuquil uj d'a junjun ab'il, tzeyac'anoch jun q'uin̈ chi' d'a uque' c'ual yuj in eyic'anchaan̈. A jun tic ley tz'ajcan d'a e cal yed' d'a scal eb' eyin̈tilal d'a masanil tiempo. ");
INSERT INTO cac_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","A d'a uque' c'ual chi', e masanil a ex israel ex tic, yovalil tzex cajnaj d'a yoltac chinama, ");
INSERT INTO cac_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","yic vach' syojtaquejn̈ejel eb' eyin̈tilal b'aq'uin̈ to a d'a yoltac chinama ix ex cajnaji ayic ix ex vic'anelta d'a Egipto. A in Jehová e Diosal in svala', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Icha val chi' ix aj yac'an vin̈aj Moisés yojtacanel eb' chon̈ab' israel juntzan̈ nivac q'uin̈ tz'ochi yuj yic'jichaan̈ Jehová. ");
INSERT INTO cac_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ix yalanpax Jehová d'a vin̈aj Moisés chi': ");
INSERT INTO cac_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Al d'a eb' etisraelal to syic'cot aceite eb' d'ayach, aton aceite te vach' yic sat te' olivo yic vach' ayn̈ejoch sc'ac'al candil. ");
INSERT INTO cac_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Axo vin̈aj Aarón sb'oanoch sc'ac'al, yic vach' ayn̈ejoch sc'ac'al tz'ec' ac'val d'a vichan̈ b'aj ay in cajnub' b'aj tzin ch'ox in b'a, d'a yichan̈elta c'apac cortina b'aj ay scaxail in trato. A jun tic ley tz'ajcan d'ayex d'a masanil tiempo. ");
INSERT INTO cac_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Vach' tz'aj sb'ojioch juntzan̈ candil chi' d'a vichan̈ d'a yib'an̈ sb'achnub'al nab'a oro. ");
INSERT INTO cac_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Tzeyic'cot ixim harina te vach', sb'o lajchaveoc ixim pan, chan̈e' libra ixim harina tz'och d'a junjun ixim. ");
INSERT INTO cac_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Slajvi chi' tz'ac'chajq'ue ixim d'a sat jun mexa nab'a oro d'a vichan̈, cha tzol tz'ajq'ue latz'an ixim, vactac ixim d'a junjun latz'an. ");
INSERT INTO cac_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Tzac'anpaxem incienso te vach' d'a yib'an̈ junjun latz'an ixim pan chi'. A incienso chi' sn̈usjitz'a d'a vichan̈, yic sch'oxani to vic yaj ixim pan chi'. ");
INSERT INTO cac_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","D'a junjun c'ual ic'oj ip tz'ac'jiem ixim pan chi' d'a vichan̈, yuj sc'anab'ajan eb' etchon̈ab' israel in trato eyed'oc d'a masanil tiempo. Yovalil a ixim q'uixin tz'ac'jiemi. ");
INSERT INTO cac_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Axo juntzan̈ ixim pan tz'ic'jiel chi', yic vin̈aj Aarón yed' eb' yin̈tilal yaj ixim d'a masanil tiempo. A eb' chi' svaan ixim pan chi' d'a junoc lugar to vic yaji, yujto te nivan yelc'och ixim d'a scal juntzan̈xo silab' yictaxon eb' sacerdote tz'ic'jiel d'a juntzan̈ ofrenda sn̈usjitz'a d'a vichan̈, xchi Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Ay jun vin̈ aljinac d'a scal eb' israel chi', israel snun vin̈, axo smam vin̈ aj Egipto. Selomit sb'i ix snun vin̈ chi', yisil vin̈aj Dibri, yin̈tilal Dan. A jun vin̈ chi' ix yac' oval vin̈ yed' jun vin̈ mero val israel d'a campamento. A d'a jun oval chi', a vin̈ yune' ix israel chi' ix och smul vin̈ yujto ix yal chuc vin̈ d'a sb'i Jehová, yuj chi' ix ic'jicot vin̈ d'a yichan̈ vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ix tan̈vaj vin̈ masanto ix yal Jehová tas yovalil tz'utaj vin̈. ");
INSERT INTO cac_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ix yalan Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Iq'uequelta vin̈ chuc ix alan chi' d'a yol campamento, axo masanil eb' ix ab'an tas ix yal vin̈ chi', yac'ocab'q'ue sc'ab' eb' d'a sjolom vin̈, axo masanil eb' chon̈ab' sjulq'uenancham vin̈. ");
INSERT INTO cac_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","16","Al juntzan̈ tic d'a eb' etisraelal: A mach tz'alan chuc d'a in b'i a in Jehová e Diosal in tic, tz'och smul, yovalil scham yuj smul chi'. Masanil eb' yetchon̈ab' sjulanchamoc. Vach'chom ch'oc chon̈ab'il, ma eyetchon̈ab', tato syal chuc d'a in b'i, yovalil tz'och chamel d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","A mach smac'ancham junoc yetanimail, yovalil tz'ochpax chamel d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","A mach smac'ancham noc' smolb'etzal noc' junocxo mach, yovalil an̈eja' noc' noc' chi' tz'ac'jipax sq'uexuloc. ");
INSERT INTO cac_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","A mach smac'an junoc yetanimail, tato tz'echnaj yuuj, icha tas syutej chi', icha chi' tz'utajpaxi. ");
INSERT INTO cac_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Tato sq'uichaj yuuj, yovalil smac'jipax q'uichajoc. Tato tz'elta yol sat yuuj, yovalil tz'elpaxcot yico', tato tz'el ye junoc mach chi' yuuj, yovalil tz'elpax yico'. Icha val tas syutej junoc anima chi', icha pax chi' tz'utajxi. ");
INSERT INTO cac_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","A mach smac'ancham noc' smolb'etzal noc' junocxo anima, yovalil syac' sq'uexul noc'. Palta a mach smac'ancham junoc yetanimail, a jun chi' yovalil schami. ");
INSERT INTO cac_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","An̈eja' jun ley tic tz'och yopisio d'a eb' ch'oc chon̈ab'il yed' d'a eb' chon̈ab' israel. A in Jehová e Diosal in svala', xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Icha chi' ix aj yalan juntzan̈ chi' vin̈aj Moisés d'a eb' yetisraelal, yuj chi' ix ic'jielta vin̈ ix alan chuc d'a sb'i Jehová chi' yuj eb' d'a spatiquel campamento. Ata' ix julq'uenajcham vin̈. Ix sc'anab'ajej eb' sc'ulan icha val ix aj yalan Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Ix yalan Jehová d'a vin̈aj Moisés chi' d'a lum svitzal Sinaí icha tic: ");
INSERT INTO cac_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Al masanil juntzan̈ tic d'a eb' etisraelal: Ayic ayexxo ec' d'a sat lum luum ol vac' d'ayex chi', yovalil ol yic' yip luum, yic tzin eyic'chaan̈ a in Jehová in tic. ");
INSERT INTO cac_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","An̈ej vaque' ab'il tzex munlaj d'a sat e luum, axo d'a vaque' ab'il chi' syal e mesan te' eyuva, tze molan sat. ");
INSERT INTO cac_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Axo d'a yuquil ab'il, yovalil scan lum yic' yip sat yuj in eyic'anchaan̈. Malaj jab'oc tas tzeyavej d'a jun ab'il chi', max yal-laj e mesan te' eyuva. ");
INSERT INTO cac_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Max yal-laj e jochanq'ue vaan ixim trigo munil sq'uib'i, ayic toxo ix ec' stiempoal jochoj trigo. Max yalpaxlaj e molan sat te' eyuva chi' to maj e mesa', yujto syic' yip lum d'a jun ab'il chi'. ");
INSERT INTO cac_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Masanil tastac sq'uib' d'a sat lum d'a jun ab'il yic syic' yip lum chi', syal e vaani, syalpax svaan eb' anima eyed'oc, aton eb' vin̈ e checab', eb' ix e checab' yed' eb' smunlaj eyed'oc yed' eb' ch'oc chon̈ab'il ayec' d'a e cal, ");
INSERT INTO cac_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","yed' pax noc' e molb'etzal noc' yed' noc' caltacte'al noc' ay d'a jun lugar chi'. Yuj chi', masanil tas sq'uib' d'a sat lum d'a jun ab'il chi', a' ol e va yed' noc' noc' chi'. ");
INSERT INTO cac_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Uquel sb'ischaj d'a uctac ab'il. A uque' ab'il chi' sb'ischaj d'a uquel, tz'elc'och d'a 49 ab'il. ");
INSERT INTO cac_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Axo d'a slajun̈ilxo c'ual yoch yuquil uj, aton jun c'u ayic tz'ac'ji tup mul, ata' spuji q'uen trompeta d'a masanil yol e chon̈ab'. ");
INSERT INTO cac_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Axo ab'il 50, a yab'ilal yoch q'uin̈ yic tz'el masanil tas d'a libre. A d'a jun ab'il chi' tz'alchajel yuj yel anima masanil d'a libre d'a yol e chon̈ab', aton eb' schon̈nac sb'a checab'vumal, yic vach' spaxta eb' smasanil d'a scal sc'ab' yoc. An̈ejtona' eb' schon̈naquel sluum scanxi lum yicoc eb'. ");
INSERT INTO cac_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Axo jun ab'il 50 chi' eyic yaj a ex tic, yuj eyel d'a libre. A d'a jun ab'il chi', malaj tas tzeyavej, max e jochq'uelaj vaan ixim trigo ton̈ej sq'uib'chaan̈ d'a ichn̈ej ta'. Man̈ e mes te' eyuva, man̈ e molpax sat te'. ");
INSERT INTO cac_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Nivanocab' yelc'och jun ab'il chi' d'a yol e sat. A tastac munil syac' d'a lum luum chi' tze va'a. ");
INSERT INTO cac_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Ayic sc'och jun ab'il chi', junjun ex tze chaxi e lum e chon̈naquel chi'. ");
INSERT INTO cac_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Yuj chi', tato ayex tze chon̈o', ma tze man e lum d'a junoc eyetanimail, man̈ e na' eyac' ganar d'a spatic jun lum chi' junjun ex. ");
INSERT INTO cac_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","A mach smanan chi', yovalil stupu', ato syala' jantac tiempoal ix ec'b'at yab'ilal yoch q'uin̈ yic tz'el tas d'a libre chi'. Axo mach schon̈vaj chi', yovalil scha stojol luum, ato syala' jayeto ab'il ol molchaj sat tas avab'il yic ol jax junxo ab'il yic tz'el tas d'a libre chi'. ");
INSERT INTO cac_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ato syala', tato nivanto yab'ilal ol molchaj sat avb'en chi', icha chi' ol aj stupchaj d'ay. Tato quenxon̈ej yab'ilal jun, quenxon̈ej pax stojol lum ol ac'chaj d'ay, yujto a sat avb'en chi' schon̈chaji, ato syala' jayeto ab'il smolchaji. ");
INSERT INTO cac_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Man̈ e comon sayej chajtil tz'aj eyac'an ganar d'a spatic eb' eyetanimail. Palta tze ch'oxeli to ay velc'och d'a yol e sat, yujto a in ton Jehová e Diosal in. ");
INSERT INTO cac_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Scham val e c'anab'ajan in checnab'il yed' e b'eyb'alan in b'eyb'al tic. Tato ol e c'anab'ajej, junc'olal ol ex ec' d'a sat lum luum chi'. ");
INSERT INTO cac_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Te vach' ol aj sat tas ol eyavej d'a luum. Tzalajc'olal ol ex cajnaj d'a sat luum, ol eyab'lej sat tas ol eyavej chi' masanto ol ex b'ud'joc. ");
INSERT INTO cac_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Talaj ol eyala': ¿Tasto ol cab'lej d'a yuquil ab'il chi', tato man̈ ol on̈ avalvoc, tato man̈ ol yalpax co molan sat tas avab'il chi'? ta xe chi. ");
INSERT INTO cac_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Man̈ eyac' pensar, yujto ol vaq'uem in vach'c'olal d'a yib'an̈ tas tzeyavej d'a svaquil ab'il chi'. Ol ste aq'uej sat, yuj chi' a jun chi' c'ocb'il syab' eyab'lan d'a oxeoc ab'il, ");
INSERT INTO cac_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","yuj chi' ol eyab'lej sat tas tzeyavej ol e molcan chi', yacb'an tzex avvi d'a svajxaquil ab'il. Olto eyab'lej tas molb'ab'il chi' eyuj yacb'an tz'elul sat tas tzeyavej d'a sb'alun̈il ab'il. ");
INSERT INTO cac_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","A lum luum chi', max yal-laj e chon̈anel lum d'a juneln̈ej, yujto vic luum. A ex tic ton̈ej paxyalvum eyaj d'a sat luum, majan lum eyaj d'ayin. ");
INSERT INTO cac_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Tato ay junoc mach schon̈el sluum, syal smananxiel slum chi' tato syal yuuj. ");
INSERT INTO cac_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Tato ay junoc eyetchon̈ab' slajviel masanil tas ay d'ay, yuj chi' schon̈b'at slum d'a junocxo, a junoc te ayto yuj sb'a yed' jun schon̈an slum chi' syal smananxiel jun lum chi' b'aj schon̈nac chi'. ");
INSERT INTO cac_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Palta tato ay junoc mach man̈xalaj junoc sc'ab' yoc syal smananel sluum chi', tato smolchaj stumin sch'ocoj, syal smananxiel sluum chi'. ");
INSERT INTO cac_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","An̈ej to snaji, jantacxo stiempoal schon̈anel luum, syac'anxi meltzaj jantac q'uen tumin d'a vin̈ manjinac luum chi', ato syala' jantacto tiempo ayic ol ja jun ab'il yic tz'och q'uin̈ yel tastac d'a libre, syic'anxi slum chi'. ");
INSERT INTO cac_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Palta tato max aj q'uen tumin chi' yuuj yic smananxiel smacb'en chi', a lum sluum chi' scann̈ej lum d'a yol sc'ab' jun mach ix manan el chi', masanto sc'och junxo yab'ilal yoch q'uin̈ yic tz'el tas d'a libre. Ato ta' librexo luum, syic'anxican lum vin̈ ix chon̈an chi'. ");
INSERT INTO cac_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Tato ay mach schon̈an junoc spat d'a yol nivac chon̈ab' ayoch smuroal, syal smananxieli ayic manto el-laj yab'ilal schon̈aneli. ");
INSERT INTO cac_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Palta tato maxto yal-laj smananel jun pat chi' ayic manto c'och jun ab'il chi', a jun pat chi', scanxon̈ej d'a vin̈ ix manan chi' d'a juneln̈ej yed' d'a eb' yin̈tilal. Maxtzac yal-laj yactajel d'a yab'ilal q'uin̈ yic tz'el tas d'a libre. ");
INSERT INTO cac_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","A pax te' pat b'aj man̈ ayococh smuroal chon̈ab', lajann̈ej ichoc comon luum. Syal smanjixieli, ma yactajel d'a yab'ilal q'uin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Axo eb' levita, syal smananxiel spat eb' d'a yaln̈ej tas tiempoal vach'chom ay d'a yol smuroal schon̈ab' eb'. ");
INSERT INTO cac_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Tato ay junoc levita max yal-laj smananxiel spat d'a yol smacb'en schon̈ab', axo yic sjax yab'ilal yoch q'uin̈ chi', syal yic'anxican spat chi', yujto a eb' levita chi' an̈ej spat eb' ayoch smacb'enoc d'a yoltac e chon̈ab'. ");
INSERT INTO cac_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","A lum luum b'aj sva scalnel eb' levita d'a spatictac chon̈ab' chi', max yal-laj schon̈anel eb', yujto svalab' scalnel eb' yajcan yuj schon̈ab'. ");
INSERT INTO cac_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Tato ay junoc eb' eyetchon̈ab' cajan d'a e lac'anil man̈xalaj jab'oc tas ay d'ay, yovalil tzex colvaj d'ay yic vach' ayn̈ejec' d'a e cal, icha tz'aj e colvaj d'a junoc ch'oc chon̈ab'il sb'eyec' d'a e cal. ");
INSERT INTO cac_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Man̈ e c'an yune' e tumin, ma stupil tastac ix eyac' majanil d'a jun eyetchon̈ab' chi'. An̈ej to tze ch'oxo' to ay velc'och d'a yol e sat, yic vach' ayn̈ejec' jun eyetchon̈ab' chi' eyed'oc. ");
INSERT INTO cac_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Man̈ e c'an yune' q'uen tumin tzeyac' majanil d'a jun eyetchon̈ab' chi', man̈ e mac'paxq'ue stojol vael uq'uel tzeyac' sq'uexa'. ");
INSERT INTO cac_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Yujto a in Jehová e Diosal in svala', a in ix ex viq'uelta d'a Egipto yic svac' lum Canaán d'ayex yic tzin och e Diosaloc. ");
INSERT INTO cac_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Tato ay junoc eyetchon̈ab' ayec' eyed'oc, man̈xa jab'oc tas ay d'ay, yuj chi' schon̈ sb'a d'ayex, man̈ eyutoc icha junoc e checab' ch'oc chon̈ab'il, ");
INSERT INTO cac_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","palta ichaocab' junoc munlajvum tzeyutej, ma icha junoc ton̈ej sb'eyeq'ui. Syal smunlaj eyed'oc masanto sjax yab'ilal yoch q'uin̈ yic tz'el tas d'a libre. ");
INSERT INTO cac_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Slajvi chi, tzaxo yal yel yed' yuninal d'a yol e pat, spax d'a scal eb' sc'ab' yoc b'aj aytaxon sluum. ");
INSERT INTO cac_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Yujto a ex tic, in checab' eyaji. A in ix ex viq'uelta d'a Egipto, yuj chi' man̈ smojoc to tzex chon̈chajel d'a checab'vumal. ");
INSERT INTO cac_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Man̈ te yajaloc tzeyutej e b'a d'a eb' eyetisraelal schon̈ sb'a d'ayex. An̈ej to ayocab' velc'och d'a yol e sat a in e Diosal in tic. ");
INSERT INTO cac_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Tato e gana tze man e checab', vinac ma ix, syal e manan d'a scal juntzan̈xo nación d'a e lac'anil. ");
INSERT INTO cac_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Syalpax e manan eb' ch'oc nacional ayec' d'a e cal, ma yuninal eb' ix alji d'a e cal, syal e manan eb' eyicoc d'a juneln̈ej. ");
INSERT INTO cac_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Axo yic tzex chami scan eb' yicoc eb' eyuninal. Syal yoch eb' chi' schecab'oc eb', palta malaj junoc eyetisraelal tic syal eyac'anoch e b'a yajalil d'a yib'an̈, yujto eyetchon̈ab' eb'. ");
INSERT INTO cac_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Tato ay junoc ch'oc chon̈ab'il, ma junoc anima ayec' d'a e cal tic tz'och b'eyumal, axo junoc eyetchon̈ab' junn̈ej cajan yed'oc tz'och meb'ail, schon̈an sb'a d'a jun ch'oc chon̈ab'il ayec' d'a slac'anil chi', ma d'a junocxo ayto yuj sb'a yed' jun ch'oc chon̈ab'il chi', ");
INSERT INTO cac_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","syal smananxiel sb'a, mato smanjiel yuj junoc sc'ab' yoc, ");
INSERT INTO cac_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ma yuj junoc to ayto yuj sb'a yed'oc. Tato tzaxo techaj yuj jun, syal smananel sb'a sch'ocojil. ");
INSERT INTO cac_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Syic' scuenta eb' d'a yab'ilal ayic ix schon̈anel sb'a chi', masanto sjax yab'ilal q'uin̈ yic tz'el tas d'a libre. A stojol tz'ac'ji, ato syala' jantacxo yab'ilal chi'. Icha chi' tz'aj yic'anpax scuenta jantac tumin tz'och d'a spatic smunlajel, icha stojol sc'u eb' munlajvum. ");
INSERT INTO cac_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Tato ayto sc'ochxi yab'ilal chi' jun, smananxiel sb'a, syac'an meltzaj jab'ocxo q'uen tumin, ato syala' jantac ix scha'a ayic ix schon̈anel sb'a chi'. ");
INSERT INTO cac_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Palta tato quenxon̈ej tiempo sc'och yab'ilal yic q'uin̈ chi', axon̈ej jab'xo chi' stupu'. ");
INSERT INTO cac_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Lajanocab' tz'utaj icha junoc eb' smunlaj d'a yab'ilal d'a junoc patrón, icha pax chi' tz'utaj yuj jun ch'oc chon̈ab'il chi'. Man̈ e cha ixtaj jun eyetchon̈ab' chi' d'a eyichan̈. ");
INSERT INTO cac_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Tato max yal smananel sb'a jun, axo yic sc'och yab'ilal q'uin̈ chi', ata' tz'actajel yed' eb' yuninal. ");
INSERT INTO cac_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Yujto in checab' eyaj a ex israel ex tic, a in val ix ex viq'uelta d'a Egipto. A in ton Jehová e Diosal in svala', xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ix yalanpax Jehová d'a vin̈aj Moisés chi' yic syal vin̈ d'a eb' yetchon̈ab' icha tic: Man̈ e b'o yechel juntzan̈ comon dios e diosaloc. Man̈ e molb'ejq'ue q'uen q'ueen tz'alji macsejal, ma q'uen q'ueen tzeyb'il ayoch juntzan̈ icha yechel d'ay. Man̈ ex em n̈ojan ejmelal d'ay, yujto a in ton Jehová e Diosal in. ");
INSERT INTO cac_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","A sc'ual ic'oj ip ix val d'ayex, nivanocab' yelc'och d'a yol e sat. Nivanocab' pax yelc'och in cajnub' d'a yol e sat, a in val Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Tato ol e b'eyb'alejn̈ej in c'ayb'ub'al, tze c'anab'ajan in checnab'il, ");
INSERT INTO cac_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ol vac'b'at n̈ab' d'a stiempoal, axo yac'an sat te' eyavb'en te' yed' tas avab'il d'a lum luum chi'. ");
INSERT INTO cac_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Vanto e tec'an ixim e trigo, toxo pax ix q'uin̈b'i sat eyuva. Vanto e molan sat te' eyuva chi', toxo ix japax stiempo yavchaj trigo junelxo, yuj chi' ol ex vaoc, masanto ol ex b'ud'joc. Ol eyac' val tzalajb'oc e c'ol d'a yol e macb'en. ");
INSERT INTO cac_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Te vach'xon̈ej ol ex ajec' ta'. Ol ex vay d'a junc'olal, malaj mach ol ex xib'tanoc. Ol ex in col d'a noc' chium noc' yed' d'a oval. ");
INSERT INTO cac_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ol el lemnaj eb' ayoch ajc'olal d'ayex, yuj eyespada ol cham eb', ol can teljab' eb' d'a eyichan̈. ");
INSERT INTO cac_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","A d'a ovan̈oc ex, ol el lemnaj 100-oc eb' ajc'ol chi'. Axo d'a junoc 100 ex, ol el lemnaj 10 miloc eb'. A eb' ajc'ol chi' ol cham eb' d'a eyichan̈ yuj eyespada. ");
INSERT INTO cac_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Te vach'c'olal ol aj ex vilanochi. Ol vic' val chaan̈ e b'isul, ol vaq'uelc'och in trato eyed'oc. ");
INSERT INTO cac_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Vanto e vaan ixim trigo molb'ilcan eyuj yictax junab'i, ol e b'esancanel ixim yic ol e latz'anpaxoch ixim ac'to chi'. ");
INSERT INTO cac_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ol in cajnajn̈ej eyed'oc, man̈ ol ex in chaquel-laj. ");
INSERT INTO cac_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ol in ajn̈ejec' d'a e cal. A in e Diosal in, a exxo tic in chon̈ab' eyaji. ");
INSERT INTO cac_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","A in Jehová e Diosal in, ix ex viq'uelta d'a Egipto, yic vach' max ex cann̈ej checab'oc ta'. A in ix viq'uel jun munlajel man̈xo jantacoc syail ayoch d'a eyib'an̈. Yuj val chi' man̈xo n̈ojanoc ex emi tzex b'eyeq'ui. ");
INSERT INTO cac_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Palta tato a ex tic man̈ ol e c'anab'ajej, man̈ ol e b'eyb'alej in checnab'il, ");
INSERT INTO cac_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","tato ol e patiquejel in b'eyb'al tic, tato malaj yelc'och juntzan̈ in checnab'il tic d'ayex, tzeyixtanb'at in trato ix in b'o eyed'oc, ");
INSERT INTO cac_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","a in pax tic, aton juntzan̈ tic ol in c'ulej eyed'oc: Ol vac'b'at xivc'olal d'a eyib'an̈. Ol vac'b'at juntzan̈ yab'il man̈xa yan̈al yed' c'ac'al yab'il ol cot d'ayex syixtan yol e sat, ol pax yip e nivanil. Nab'axon̈ej ol eyavej tastac, yujto a eb' ayoch ajc'olal d'ayex ol vaanb'at sat tas tzeyavej chi'. ");
INSERT INTO cac_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ol in och ajc'olal d'ayex, ol ex satel yuj eb' eyajc'ol chi'. Ol ex can d'a yalan̈ yuj eb'. Toxon̈ej ol ex el lemnajoc, vach'chom malaj mach tzex pechani. ");
INSERT INTO cac_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Tato an̈eja' max in e c'anab'ajej, vach'chom toxo ix javi juntzan̈ tic d'a eyib'an̈, masn̈ej ol q'uechaan̈ eyaelal vuj yuj e mul. ");
INSERT INTO cac_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ol vac' lajvoquem eyac'umtaquil. Man̈xo ol yac'laj n̈ab', yuj chi' man̈xa tas ol yal sq'uib' d'a sat lum e lum chi'. ");
INSERT INTO cac_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Nab'axon̈ej ol eyixtej e b'a e munlaji, man̈xalaj tas ol q'uib' d'a sat lum luum chi'. Man̈xo ol yac'pax sat te' eyavb'en te'. ");
INSERT INTO cac_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Tato te pit ol eyutej e b'a d'ayin, man̈ ol in e c'anab'ajejn̈ej, ol te q'uechaan̈ yaelal d'a eyib'an̈ vuuj, ato syala' jantac e mul. ");
INSERT INTO cac_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ol vac'b'at noc' chium noc' d'a e cal, ol schianb'at eyuninal noc' yed' noc' e molb'etzal noc', axo yemta e b'isul chi' yuj noc', yuj chi' man̈xa mach ol b'eyec' d'a yoltac b'e. ");
INSERT INTO cac_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Tato an̈eja' max e na e b'a yuj juntzan̈ chi', pitn̈ej tzeyutej e b'a d'ayin, ");
INSERT INTO cac_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","a in xo, te nivan yaelal ol vac'b'at d'a eyib'an̈ yuj e mul chi'. ");
INSERT INTO cac_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ol vac'b'at oval d'ayex eyaelaloc, yuj in pacan d'ayex yujto max e c'anab'ajej in trato. Toxon̈ej ol ex b'at lemnaj e col e b'a d'a e chon̈ab', palta ata' ol vac'b'at c'ac'al yab'il, icha chi' ol aj e can d'a yalan̈ yuj eb' vin̈ eyajc'ol chi'. ");
INSERT INTO cac_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ayic ol vic'anemta yel e vael, lajun̈van̈ val eb' ix ix, junn̈ej ol sb'o svael d'a junoc c'ac'. Axon̈ej d'a echlab'il ol aj yec' e vael chi' d'a e patic. Ol ex vaoc, palta man̈ ol ex b'ud'joclaj. ");
INSERT INTO cac_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Vach'chom ix eyil juntzan̈ yaelal chi', palta tato an̈eja' max e na e b'a, an̈eja' tze pitejn̈ej e b'a, ");
INSERT INTO cac_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","a in pax tic ol vac' yovalil d'ayex yed' val yoval in c'ool. Masn̈ej ol q'uechaan̈ eyaelal vuuj yuj e mul. ");
INSERT INTO cac_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ichato val chi' ol e chianb'at eb' eyuninal yed' eb' eyisil. ");
INSERT INTO cac_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ol in pojem juntzan̈ lugar b'aj tzex och ejmelal d'a e diosal, ol in mac'poj eyaltar yic incienso. Ol in molb'ejq'ue b'ulan e nivanil d'a yib'an̈ juntzan̈ e diosal man̈ pitzanoc chi', yujto ol ex in chaqueli. ");
INSERT INTO cac_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ol laj in jucanb'at e chon̈ab' yed' spatil e diosal chi'. Man̈xo ol in tzalaj yuj suc'uq'uial sjab' e silab'. ");
INSERT INTO cac_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ol vac' lajvoquem e chon̈ab' chi', axo eb' ajc'ol ol jacan cajan d'ay, ol sat sc'ol eb' yilan jun chi'. ");
INSERT INTO cac_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ol ex vac'an saclem d'a scal masanil nación. Tzac'an vespada d'a e patic ol ex b'atoc. A e chon̈ab' chi', cuseltac ol ajcanoc, xivc'olaltac ol aj sjuvicanb'ati. ");
INSERT INTO cac_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Ichato val chi' vach' ol aj scan lum sch'ocojil d'a masanil tiempo ayic ayextoec' d'a juntzan̈xo nación ayoch ajc'olal d'ayex chi'. Icha val chi' ol aj yic'ancan yip luum, icha stiempoal to maj yic' yip lum eyuj d'a yalan̈taxo ayic ayex ec' cajan ta'. ");
INSERT INTO cac_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","A eb' eyin̈tilal pitzanto b'aj ay slugar eb' eyajc'ol chi', ol vac' val och xivc'olal d'a yib'an̈ eb'. Ol el lemnaj eb' ayic ol yab'an eb' yem c'otnaj junoc te' xil te'. Ol el eb' ichato ay junoc mach tzac'anoch yed' espada d'a spatic eb'. Toxon̈ej ol comon telvoc eb', vach'chom malaj mach spechan eb'. ");
INSERT INTO cac_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ol comon telvocb'at junjun eb', ichato van yel eb' d'a oval, vach'chom malaj mach spechan eb'. Man̈xalaj junoc eb' ol to stec'b'ej sb'a d'a yichan̈ eb' ajc'ool. ");
INSERT INTO cac_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ol lajvoquem eb' d'a scaltac juntzan̈ nación chi', ichato a slugar eb' ajc'ol chi' ol satanel eb'. ");
INSERT INTO cac_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","A mach d'a scal eb' eyin̈tilal pitzantocanec' d'a schon̈ab' eb' eyajc'ol chi', ata' ol cham eb' yujn̈ej schucal, yuj pax smul eb' smam yicham eb'. ");
INSERT INTO cac_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","Ayic toxo ix in och ajc'olal d'ayex chi', ayic toxo pax ex vac'canb'at d'a schon̈ab' eb' eyajc'ool, yujto ix e pitej e b'a d'ayin, tato ata' sna sb'a sc'ol eb' eyin̈tilal b'aj ix spitej sb'a eb' chi' d'ayin, tato syaq'uem sb'a eb' d'a vichan̈ yic syalanq'ueta smul eb' yed' e mul a ex tic, ");
INSERT INTO cac_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","tato icha chi', ol in naancot in trato vac'nac to ol vac' lum luum d'a vin̈aj Jacob, d'a vin̈aj Isaac yed' d'a vin̈aj Abraham. ");
INSERT INTO cac_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Palta a d'a yalan̈to chi', ol ex el d'a sat e luum chi'. Ol can tz'inan luum, ol yic'an yip luum ayic man̈ ex ayoc ec' ta'. Tz'acan ol aj e tupan el e mul, yujto ix e patiquejel in b'eyb'al yed' in checnab'il. ");
INSERT INTO cac_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Vach'chom icha chi' tzex vutej, ayic ayec' eb' eyin̈tilal d'a schon̈ab' eb' yajc'ol eb' chi', man̈ ol in patiquejel-laj eb'. Man̈ ol in satel-laj eb' yic man̈ ol lajvoquec' in trato ix vac' yed' eb' yujto a in Jehová in, sDiosal in eb'. ");
INSERT INTO cac_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Axo ol ajoc to yuj svach'iloc eb', ol in nacot in trato ix in b'o eyed'oc ayic ix ex vic'anelta d'a Egipto. D'a val yichan̈ juntzan̈xo chon̈ab' ix ex viq'uelta, yic vach' tzin och e Diosaloc. A in ton Jehová in svala', xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Aton juntzan̈ b'eyb'al tic, checnab'il yed' c'ayb'ub'al ix yac' Jehová d'a jolom vitz Sinaí d'a vin̈aj Moisés yic sc'anab'ajan eb' chon̈ab' israel. ");
INSERT INTO cac_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Al juntzan̈ tic d'a eb' etisraelal: Tato ay mach tz'ac'an sti' yac'an junoc anima d'ayin Jehová in tic, palta snib'ej smananel jun anima chi', yovalil syac' stojol, stupu' icha yalan jun lista tic, ");
INSERT INTO cac_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","4","icha echlab' sc'anchaj d'a in cajnub': A eb' 20 ab'il sq'uinal masanto d'a 60 ab'il, tato vinac, yovalil tz'ac'ji 50 siclo q'uen plata stojoloc. Tato ix, 30 siclo plata syac'a'. ");
INSERT INTO cac_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Axo yuj eb' oye' ab'il sq'uinal masanto d'a 20, tato vinac, 20 siclo q'uen plata syac'a'. Tato ix jun, 10 siclo q'uen syac'a'. ");
INSERT INTO cac_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Axo yuj eb' unin jun ujal sq'uinal masanto d'a oye' ab'il, tato vinac, oye' siclo q'uen plata syac'a'. Tato ix jun, oxe' siclo q'uen syac'a'. ");
INSERT INTO cac_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Axo yuj eb' icham anima ec'xo d'a 60 ab'il, tato vinac, 15 siclo q'uen plata syac'a', tato ix jun, 10 siclo q'uen syac'a'. ");
INSERT INTO cac_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Tato ay junoc anima yelxo val meb'a' jun, max yal-laj yac'an icha sb'isul q'uen to chequel yaj chi', tz'ic'chajcot d'a yichan̈ junoc vin̈ sacerdote, snaji jantac val syal yac'ani. ");
INSERT INTO cac_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Axo pax yuj noc' noc' to tz'ac'jitaxon silab'il d'ayin, masanil noc' tz'ac'ji d'ayin chi', chequel tz'ajcan noc'. ");
INSERT INTO cac_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Max yal-laj sq'uexji noc' yed' junocxo noc', vach'chom vach' noc', ma chuctac val noc'. Palta tato sq'uexji noc', a noc' sq'uexul chi', scanxon̈ej noc' yed' noc' chequeltaxon yaj chi'. ");
INSERT INTO cac_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Axo pax yuj junoc noc' noc' man̈ vach'octaxon yoch silab'il d'ayin jun, a noc' chi' tz'ic'jicot d'a junoc vin̈ sacerdote, ");
INSERT INTO cac_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","yic vach' snaji jantac stojol noc', ato syala' chajtil yilji noc'. Icha stojol noc' ix naji yuj vin̈ sacerdote chi', ichan̈ej chi' tz'ajcan stojol noc' yic schon̈chaj yuj yochcan stojol noc' yicoc in cajnub'. ");
INSERT INTO cac_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Tato an̈eja' mach ay yic noc' chi' sgana smananpaxel noc' jun, yovalil syac' stojol noc' nab'ilxo chi', syac'an jab'ocxo más d'a yib'an̈ stojol noc' chi'. ");
INSERT INTO cac_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Tato ay mach syac' spat d'ayin, tato vach' yaji, mato chuctac val yaji, a junoc vin̈ sacerdote snaani jantac val stojol. Icha chi' tz'ajcan stojol chi' d'a juneln̈ej. ");
INSERT INTO cac_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Palta tato a mach ay yic jun pat chi' sgana smananeli, yovalil syac' jab'ocxo más d'a yib'an̈ icha stojol ix najican chi', ichato chi' syic'anxi spat chi'. ");
INSERT INTO cac_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Tato ay junoc mach syac' junoc macan̈ sluum d'ayin, a stojol lum luum chi' snaji, ato a' jantac sat tas tz'el d'a sat luum. Tato b'alun̈e' arroba ixim cebada tz'elta d'a luum, 50 siclo plata stojol luum. ");
INSERT INTO cac_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Tato tz'ac'ji lum luum chi' d'a yol yab'ilal yoch q'uin̈ yic tz'el tas d'a libre, scanxon̈ej stojol lum icha ix aj snajican chi'. ");
INSERT INTO cac_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Palta tato ayic toxo ix lajviec' jun ab'il chi' tz'ac'ji luum, a vin̈ sacerdote syal snaani jantac q'uen plata syal yac'ji. Tz'ic'jiemta jab'oc stojol luum, ato syala' jayeto ab'il yic ol jax junxo ab'il q'uin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Tato a junoc mach ix yac' slum chi' d'ayin, sgana smananpaxeli, yovalil syac' jab'ocxo más d'a yib'an̈ icha stojol nab'ilcani. Ichato chi' syal yic'anxican sluum chi'. ");
INSERT INTO cac_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Tato max smanel lum mach ix ac'an chi', palta to schon̈b'at lum d'a junocxo anima, tato icha chi', maxtzac yal smananxiel luum. ");
INSERT INTO cac_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ayic scan lum luum chi' d'a libre d'a yab'ilal e chaan q'uin̈ yic tz'el tas d'a libre, a jun lum chi', vic tz'ajcan luum, axo eb' sacerdote smacb'enancan luum. ");
INSERT INTO cac_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Tato ay mach syac' sti' yac'an junoc lum luum d'ayin to manb'il yuuj, man̈ smacb'enoctaxon yaji, ");
INSERT INTO cac_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","a junoc vin̈ sacerdote snaan stojol yed' jun anima chi' masanto sjax yab'ilal q'uin̈ yic tz'el tas d'a libre. A d'a jun c'u chi' syac' stojol lum jun anima chi', ato a' jantac ix aj snaji, tz'ochcan q'uen tumin chi' vicoc. ");
INSERT INTO cac_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Axo yic sjax jun ab'il chi', smeltzajxi lum d'a mach ix chon̈an chi', syalelc'ochi aton jun mach aytaxon yic luum. ");
INSERT INTO cac_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","A stojol junoc tas sna eb' sacerdote stupchaj icha q'uen tumin sc'anchaj b'aj ay in cajnub'. 20 geras yalil junjun siclo q'uen plata. ");
INSERT INTO cac_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","A sb'ab'el yune' noc' vacax, ma noc' calnel, ma noc' chiva, victaxon yaj a in Jehová in tic. Malaj mach syal yac'an juntzan̈ noc' chi' yofrendaoc d'ayin yujto a sb'ab'el yune' noc' victaxon yaji. ");
INSERT INTO cac_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Tato a sb'ab'el yune' junoc noc' to man̈ vach'oc icha yalan ley, syal smanjixiel noc' yuj mach tz'ac'an chi', ato syal jantac stojol noc' ix naji, syac' jab'ocxo más d'a yib'an̈ icha stojol chi'. Tato man̈oc mach ay yic noc' chi' smananeli, an̈eja' icha stojol noc' nab'ilxo chi', syal schon̈jiel yuj eb' sacerdote. ");
INSERT INTO cac_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Yaln̈ej tas tz'ac'ji d'ayin d'a juneln̈ej, junoc anima, ma junoc noc' molb'etzal noc', ma junoc lum luum to smacb'entaxon yaj jun mach tz'ac'an chi', ma junocxo tasi, max yal-laj schon̈chaji, max yalpax smanjiel yuj mach ix ac'ani. Vicxo yaj d'a juneln̈ej. ");
INSERT INTO cac_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Axo pax junoc anima toxonton ayoch chamel d'a yib'an̈, max yal-laj smanjieli. A jun anima chi' yovalil tz'ochxon̈ej chamel chi' d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","A sdiezmoal sat masanil tas tz'avchaj d'a sat lum luum tic, vach'chom sat ixim, ma sat te te', victaxon yaji. ");
INSERT INTO cac_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Tato ay junoc mach sgana smananel jun diezmo chi', yovalil syac' jab'ocxo más d'a yib'an̈ icha stojol chi'. ");
INSERT INTO cac_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Jun d'a lajlajun̈van̈ noc' vacax, ma noc' calnel, ma noc' chiva, aton noc' chi' scan d'a diezmoal d'ayin tato vach' noc', ma ay spaltail noc'. ");
INSERT INTO cac_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Max yal-laj sic'laj noc', ma sq'uexchaj noc' yed' junocxo noc' ch'oc yeli. Tato ay mach sgana sq'uexan noc', a noc' b'ab'el chi' yed' pax noc' tz'ac'ji sq'uexuloc noc' chi', scanxon̈ej noc' schavan̈il. Max yalpaxlaj smanjiel noc', xchi Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","A d'a jolom vitz Sinaí ix yac' juntzan̈ checnab'il tic Jehová d'a vin̈aj Moisés chi', yic chon̈ab' Israel yaji. ");
INSERT INTO cac_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","A d'a b'ab'el c'ual, d'a schab'il uj yic schab'il ab'il yelta eb' israel d'a Egipto, ix lolon Jehová d'a vin̈aj Moisés d'a tz'inan lum Sinaí, aton b'aj ay scajnub' Jehová Dios b'aj sch'ox sb'a. Ix yalan icha tic: ");
INSERT INTO cac_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Ic'chaan̈ sb'isul eb' vinac d'a scal eb' etchon̈ab' israel, ato syal junjun macan̈ yaj eb' aton eb' ayto yuj sb'a, yic vach' tz'ilji jantac eb' yed' tastac sb'i eb'. ");
INSERT INTO cac_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Sb'ischaj eb' 20 ab'il sq'uinal, sb'eyn̈ejb'ati, aton eb' smoj val sb'at d'a oval, tz'ac'chajoch eb' d'a macquiltaquil. Colvajocab' vin̈aj Aarón ed'oc, ");
INSERT INTO cac_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","yed' pax junjun yajalil junjun in̈tilal. ");
INSERT INTO cac_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","15","Aton sb'i juntzan̈ eb' yajal yovalil scolvaj ed'oc tic: A d'a yin̈tilalcan vin̈aj Rubén, aton vin̈aj Elisur yuninal vin̈aj Sedeur. A d'a yin̈tilalcan vin̈aj Simeón, aton vin̈aj Selumiel yuninal vin̈aj Zurisadai. A d'a yin̈tilalcan vin̈aj Judá, aton vin̈aj Naasón yuninal vin̈aj Aminadab. A d'a yin̈tilalcan vin̈aj Isacar, aton vin̈aj Natanael yuninal vin̈aj Zuar. A d'a yin̈tilalcan vin̈aj Zabulón, aton vin̈aj Eliab yuninal vin̈aj Helón. A d'a eb' yin̈tilalcan vin̈aj José, a d'a eb' yic vin̈aj Efraín, aton vin̈aj Elisama yuninal vin̈aj Amiud, a d'a eb' yic vin̈aj Manasés, aton vin̈aj Gamaliel yuninal vin̈aj Pedasur. A d'a yin̈tilalcan vin̈aj Benjamín, aton vin̈aj Abidán yuninal vin̈aj Gedeoni. A d'a yin̈tilalcan vin̈aj Dan, aton vin̈aj Ahiezer yuninal vin̈aj Amisadai. A d'a yin̈tilalcan vin̈aj Aser, aton vin̈aj Pagiel yuninal vin̈aj Ocrán. A d'a yin̈tilalcan vin̈aj Gad, aton vin̈aj Eliasaf yuninal vin̈aj Deuel. A d'a yin̈tilalcan vin̈aj Neftalí, aton vin̈aj Ahira yuninal vin̈aj Enán, xchi Dios. ");
INSERT INTO cac_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Aton juntzan̈ eb' yajal tic ix sic'chajel d'a scal masanil yin̈tilal Israel. ");
INSERT INTO cac_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","18","A d'a b'ab'el c'ual d'a schab'il ujal yic jun ab'il chi', ix smolb'ej juntzan̈ eb' vin̈ tic vin̈aj Moisés yed' vin̈aj Aarón, to satil tz'ajcan eb' vin̈ yuj Dios. An̈eja' ix molb'ajpax masanil eb' chon̈ab'. Icha chi' ix aj yic'jichaan̈ sb'isul eb' israel. D'a stzolal ix aj stz'ib'chaj sb'i eb', aton eb' 20 ab'il sq'uinal, sb'eyn̈ejb'ati, ato a' smacan̈il d'a junjun in̈tilal, ");
INSERT INTO cac_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","icha ix aj yalan Jehová d'a vin̈aj Moisés. A d'a tz'inan luum d'a Sinaí ix ic'jichaan̈ sb'isul eb' chi'. ");
INSERT INTO cac_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","A d'a junjun in̈tilal, d'a junjun macquiltaquil, ix ic'jichaan̈ sb'isul eb' chi'. Ix tz'ib'chaj sb'i eb' yed' sb'isul eb' vinac tz'acanxo yab'ilal d'a 20 ab'il, yuj chi' aton val ix aj yelc'och tic: A d'a yin̈tilal vin̈aj Rubén, aton sb'ab'el yuninal vin̈aj Israel, 46 mil 500 eb' vinac smoj sb'at d'a oval. ");
INSERT INTO cac_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","A d'a yin̈tilal vin̈aj Simeón, ay 59 mil 300. ");
INSERT INTO cac_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","A d'a yin̈tilal vin̈aj Gad, ay 45 mil 650. ");
INSERT INTO cac_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","A d'a yin̈tilal vin̈aj Judá, ay 74 mil 600. ");
INSERT INTO cac_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","A d'a yin̈tilal vin̈aj Isacar, ay 54 mil 400. ");
INSERT INTO cac_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","A d'a yin̈tilal vin̈aj Zabulón, ay 57 mil 400. ");
INSERT INTO cac_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","35","Axo d'a yin̈tilalcan vin̈aj José: Ay 40 mil 500 d'a yin̈tilal vin̈aj Efraín, ay pax 32 mil 200 d'a yin̈tilal vin̈aj Manasés. ");
INSERT INTO cac_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","A d'a yin̈tilal vin̈aj Benjamín, ay 35 mil 400. ");
INSERT INTO cac_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","A d'a yin̈tilal vin̈aj Dan, ay 62 mil 700. ");
INSERT INTO cac_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","A d'a yin̈tilal vin̈aj Aser, ay 41 mil 500. ");
INSERT INTO cac_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","A d'a yin̈tilal vin̈aj Neftalí, ay 53 mil 400. ");
INSERT INTO cac_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Aton ix aj yelc'och juntzan̈ sb'isul ix yic'chaan̈ vin̈aj Moisés tic, vin̈aj Aarón yed' lajchavan̈xo eb' yajal yaj d'a scal eb' israel d'a junjun in̈tilal. ");
INSERT INTO cac_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Ix q'ue vaan juntzan̈ sb'isul chi' d'a junjun in̈tilal, d'a junjun macquiltaquil. A eb' israel, 20 ab'il sq'uinal sb'eyn̈ejb'ati, aton eb' chi' smoj sb'at d'a oval. ");
INSERT INTO cac_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","A d'a smasanil ay 603 mil 550 eb'. ");
INSERT INTO cac_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","A yin̈tilal vin̈aj Leví, maj ac'jiochlaj eb' sb'isuloc, ");
INSERT INTO cac_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","yujto a Jehová ix alan d'a vin̈aj Moisés: ");
INSERT INTO cac_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Ayic ol ic'anq'ue vaan sb'isul chon̈ab' Israel tic, man̈ ol ac'ochlaj yin̈tilal vin̈aj Leví sb'isuloc. ");
INSERT INTO cac_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Yujto a ex yin̈tilalexcan vin̈aj Leví chi', ol ex och yac'umaloc servil in cajnub' b'aj ayec' scaxail in trato yed' masanil syamc'ab'il. An̈eja' ex ol eyic'n̈ej b'ey in cajnub' chi' yed' masanil syamc'ab'il. Yovalil ol ex ajn̈ej cajan d'a spatic yichan̈ in cajnub' chi'. ");
INSERT INTO cac_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ayic tz'ic'jib'at d'a juntac el, a ex tze xuyemi, tze b'oanpaxq'ue b'aj sc'och chi'. Yaln̈ej mach junoc anima man̈ levitaoc sjavi d'a slac'anil jun in cajnub' chi', tojoln̈ej schami. ");
INSERT INTO cac_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Axo masanil juntzan̈xo yin̈tilal Israel ol cajnaj icha d'a stzolal, junjun eb' ol aj d'a scampamento, d'a yalan̈ sbandera. ");
INSERT INTO cac_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","A exxo pax yin̈tilal ex can vin̈aj Leví chi' jun, a d'a spatic yichan̈ in cajnub' ol ex ajoc. A ex ol e tan̈vej, yic vach' max cot voval d'a in chon̈ab' Israel, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ix sc'anab'ajej eb' israel sc'ulan icha val ix aj yalan Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ix yalan Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón icha tic: ");
INSERT INTO cac_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Ayic sb'oanq'ue scampamento eb' israel d'a junoc lugar, junjun tz'aj d'a yalan̈ sbandera yed' junjun macquiltaquil, yovalil najattac val tz'ajel eb' d'a spatic yichan̈ mantiado, aton b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","A d'a stojolal b'aj sjavi c'u, ata' tz'aj scampamento oxe' in̈tilal ed'jinac sbandera yin̈tilal Judá. A eb' soldado yic yin̈tilal Judá chi', a vin̈aj Naasón yuninal vin̈aj Aminadab ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ato a' yalan sb'isul, ay 74 mil 600 eb' soldado. ");
INSERT INTO cac_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Junn̈ej tz'aj scampamento yin̈tilal Isacar yed' eb'. A vin̈aj Natanael yuninal vin̈aj Zuar ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ato a' yalan sb'isul, ay 54 mil 400 eb' soldado. ");
INSERT INTO cac_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ata' tz'ajpax scampamento yin̈tilal Zabulón. A vin̈aj Eliab, yuninal vin̈aj Helón ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Ato a' yalan sb'isul, ay 57 mil 400 eb' soldado. ");
INSERT INTO cac_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Yuj chi' a b'aj ay scampamento yin̈tilal Judá chi', ay 186 mil 400 eb' soldado, aton eb' b'ab'el sb'at d'a yichan̈ eb' chon̈ab' israel. ");
INSERT INTO cac_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Axo d'a stojolal sur, ata' tz'aj scampamento oxe' in̈tilal ed'jinac sbandera yin̈tilal Rubén. A eb' soldado yic yin̈tilal Rubén chi', a vin̈aj Elisur yuninal vin̈aj Sedeur ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ato a' yalan sb'isul, ay 46 mil 500 eb' soldado. ");
INSERT INTO cac_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Junn̈ej tz'aj scampamento yin̈tilal Simeón yed' eb'. A vin̈aj Selumiel yuninal vin̈aj Zurisadai ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ato a' yalan sb'isul, ay 59 mil 300 eb' soldado. ");
INSERT INTO cac_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ata' tz'ajpax scampamento yin̈tilal Gad yed' eb'. A vin̈aj Eliasaf yuninal vin̈aj Reuel ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ato a' yalan sb'isul, ay 45 mil 650 eb' soldado. ");
INSERT INTO cac_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Yuj chi' a b'aj ay scampamento yin̈tilal Rubén chi', ay 151 mil 450 eb' soldado, aton eb' sb'ey d'a yic schab'il macan̈. ");
INSERT INTO cac_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Sb'atpax eb' levita d'a scal chan̈e' campamento. A eb' ed'jinac smantiadoal b'aj tzin ch'ox in b'a. A chan̈e' campamento chi', d'a stzolal tz'aj sb'eyi icha tas yajec' eb' d'a scampamento, junjun eb' d'a yalan̈tac sbandera. ");
INSERT INTO cac_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Axo d'a stojolal b'aj sb'at c'u, ata' tz'aj scampamento oxe' in̈tilal ed'jinac sbandera yin̈tilal Efraín. A eb' soldado d'a yin̈tilal Efraín chi', a vin̈aj Elisama yuninal vin̈aj Amiud ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ato a' yalan sb'isul, ay 40 mil 500 eb' soldado. ");
INSERT INTO cac_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Junn̈ej tz'aj yin̈tilal Manasés yed' eb'. A vin̈aj Gamaliel yuninal vin̈aj Pedasur ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ato a' yalan sb'isul, ay 32 mil 200 eb' soldado. ");
INSERT INTO cac_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ata' tz'ajpax scampamento yin̈tilal Benjamín. A vin̈aj Abidán yuninal vin̈aj Gedeoni ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ato a' yalan sb'isul, ay 35 mil 400 eb' soldado. ");
INSERT INTO cac_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Yuj chi' a b'aj ay scampamento yin̈tilal Efraín chi', ay 108 mil 100 soldado, aton eb' sb'ey d'a yoxil macan̈. ");
INSERT INTO cac_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Axo d'a stojolal norte, ata' tz'aj scampamento oxexo in̈tilal ed'jinac sbandera yin̈tilal Dan. A eb' soldado d'a yin̈tilal Dan chi', a vin̈aj Ahiezer yuninal vin̈aj Amisadai ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ato a' yalan sb'isul, ay 62 mil 700 eb' soldado. ");
INSERT INTO cac_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Junn̈ej tz'aj scampamento yin̈tilal Aser yed' eb'. A vin̈aj Pagiel yuninal vin̈aj Ocrán ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ato a' yalan sb'isul, ay 41 mil 500 eb' soldado. ");
INSERT INTO cac_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ata' tz'ajpax scampamento yin̈tilal Neftalí yed' eb'. A vin̈aj Ahira yuninal vin̈aj Enán ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ato a' yalan sb'isul, ay 53 mil 400 eb' soldado. ");
INSERT INTO cac_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Yuj chi' a b'aj ay scampamento yin̈tilal Dan chi', ay 157 mil 600 eb' soldado. Aton eb' sb'eyb'at d'a spatic sbandera yin̈tilal Dan chi', aton eb' tzac'anto sb'ati, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","A sb'isul eb' israel, ay 603 mil 550 eb' soldado d'a smasanil. ");
INSERT INTO cac_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Palta maj och eb' yin̈tilalcan vin̈aj Leví sb'isuloc, icha val ix aj yalan Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ix sc'ulej eb' israel icha val ix aj yalan Jehová. Junn̈ej ix aj eb' d'a yalan̈tac sbandera, ix b'eyb'at eb' d'a stzolal, ato syal junjun macquiltaquil. ");
INSERT INTO cac_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Aton eb' yin̈tilal vin̈aj Aarón yed' eb' yin̈tilal vin̈aj Moisés tic, ayic ix lolon Jehová d'a vin̈aj Moisés chi' d'a jolom vitz Sinaí. ");
INSERT INTO cac_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","A eb' yuninal vin̈aj Aarón chi': Vin̈aj Nadab b'ab'el vinac, vin̈aj Abiú, vin̈aj Eleazar yed' vin̈aj Itamar. ");
INSERT INTO cac_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","A eb' chan̈van̈ tic, ix sic'jiel eb', ix ochcan yopisio eb' sacerdoteal. ");
INSERT INTO cac_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Palta a vin̈aj Nadab yed' vin̈aj Abiú chi', ix cham eb' vin̈ d'a yichan̈ Jehová d'a tz'inan lum Sinaí, yujto ix yac'och jun c'ac' eb' vin̈ icha ofrenda d'a yichan̈ Jehová to man̈ smojoc. Mantalaj yuninal eb' ta', yuj chi' axon̈ej vin̈aj Eleazar yed' vin̈aj Itamar ix munlaj sacerdoteal d'a yalan̈ smandar vin̈aj Aarón aton smam eb'. ");
INSERT INTO cac_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ix lolonxi Jehová d'a vin̈aj Moisés chi', ix yalan icha tic: ");
INSERT INTO cac_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Avtej masanil eb' vin̈ vinac d'a yin̈tilal Leví, yic scolvaj eb' yed' vin̈aj sacerdote Aarón icha ol yal vin̈. ");
INSERT INTO cac_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","8","A eb' chi' ayoch yopisio d'a yichan̈ vin̈aj Aarón chi' yed' d'a yichan̈ chon̈ab' d'a mantiado b'aj tzin ch'ox in b'a. Stan̈vanpax masanil yamc'ab' yic mantiado chi' eb'. Icha chi' tz'aj yac'ji servil masanil chon̈ab' Israel yuj eb' d'a masanil munlajel b'aj ay in cajnub'. ");
INSERT INTO cac_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ic'chajocab'el eb' levita d'a scal eb' eyetchon̈ab' smasanil yic vach' syac' servil vin̈aj Aarón eb' yed' d'a masanil yin̈tilal vin̈. ");
INSERT INTO cac_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","An̈ej d'a yib'an̈ vin̈ yed' yin̈tilal tz'ochcan yopisio yac'an sacerdoteal. Tato ay junoc mach man̈ yin̈tiloc vin̈ chi' syecoch sb'a d'a jun opisio chi', yovalil schami, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Toxo ix ex in sic'canel a ex levita ex tic sq'uexuloc junjun eb' b'ab'el vinac unin d'a scal eb' etisraelal, yuj chi' vic eyaji. ");
INSERT INTO cac_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Ayic ix vac'ancham masanil eb' b'ab'el vinac unin d'a Egipto, ix vac'can sb'ab'el vinac unin eb' etisraelal yic tz'ochcan vicoc, icha pax chi' noc' b'ab'el yune' noc' e molb'etzal noc' vic yaji. A in Jehová in svala', xchi d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ix lolon Jehová d'a vin̈aj Moisés chi' d'a tz'inan luum Sinaí, ix yalani: ");
INSERT INTO cac_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Ic'q'ue vaan sb'isul eb' etlevitail, icha junjun macquiltaquil, masanil eb' vinac d'a e cal. Tza chael yich d'a eb' jun ujal sq'uinal sb'eyn̈ejb'ati, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Yuj chi' ix yic'chaan̈ sb'isul eb' vin̈aj Moisés chi', icha ix aj yalan Jehová. ");
INSERT INTO cac_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","A eb' yuninal vin̈aj Leví: Aton vin̈aj Gersón, vin̈aj Coat yed' vin̈aj Merari. ");
INSERT INTO cac_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Axo eb' yuninal vin̈aj Gersón chi': Aton vin̈aj Libni yed' vin̈aj Simei, aton eb' vin̈ tic sb'inajn̈ej d'a yin̈tilal. ");
INSERT INTO cac_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","A eb' yuninal vin̈aj Coat: Aton vin̈aj Amram, vin̈aj Izhar, vin̈aj Hebrón yed' vin̈aj Uziel, aton eb' vin̈ tic sb'inajn̈ej d'a yin̈tilal. ");
INSERT INTO cac_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","A eb' yuninal vin̈aj Merari: Aton vin̈aj Mahli yed' vin̈aj Musi, aton eb' vin̈ tic sb'inajn̈ej d'a yin̈tilal. A eb' vin̈ tic, yajal yaj eb' vin̈ d'a junjun macan̈ yin̈tilalcan vin̈aj Leví. ");
INSERT INTO cac_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","A eb' yin̈tilalcan vin̈aj Gersón, cha macan̈ yaj eb', aton eb' yin̈tilalcan vin̈aj Libni yed' eb' yin̈tilalcan vin̈aj Simei. ");
INSERT INTO cac_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","A sb'isul eb' vinac d'a smasanil, ix chajiel yich d'a eb' jun ujal sq'uinal sb'eyn̈ejb'ati, ay 7 mil 500. ");
INSERT INTO cac_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Masanil eb' tic, a d'a stojolal b'aj tz'em c'u, d'a spatic scajnub' Jehová tz'aj scampamento eb'. ");
INSERT INTO cac_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","A pax mach yajal yaj d'a yin̈tilalcan vin̈aj Gersón, aton vin̈aj Eliasaf yuninal vin̈aj Lael. ");
INSERT INTO cac_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Aton eb' tz'ilan juntzan̈ smacul yib'an̈ scajnub' Jehová b'aj sch'ox sb'a yed' c'apac cortina ayoch d'a sti' scajnub' chi', ");
INSERT INTO cac_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","c'apac scortinail amac' oyanoch d'a spatic scajnub' Jehová yed' b'aj ay altar, c'apac cortina ayoch d'a sti' amac' chi' yed' sch'an̈al ayoch d'a spatic syamc'ab'il. ");
INSERT INTO cac_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","A eb' yin̈tilalcan vin̈aj Coat, chan̈ macan̈ yaj eb': Aton eb' yin̈tilalcan vin̈aj Amram, eb' yin̈tilalcan vin̈aj Izhar, eb' yin̈tilalcan vin̈aj Hebrón yed' eb' yin̈tilalcan vin̈aj Uziel. ");
INSERT INTO cac_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","A sb'isul masanil eb' vinac ix schael yich d'a eb' jun ujal sq'uinal sb'eyn̈ejb'ati, ay 8 mil 600 eb', aton eb' tz'ilan scajnub' Jehová. ");
INSERT INTO cac_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Masanil eb' tic, a d'a stz'eyel scajnub' Jehová d'a stojolal sur tz'aj scampamento eb'. ");
INSERT INTO cac_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","A yajalil juntzan̈ eb', aton vin̈aj Elizafán yuninal vin̈aj Uziel. ");
INSERT INTO cac_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Aton eb' tic tz'ilan te' scaxail trato, te' mexa, sb'achnub' candil, chab' altar yed' masanil jantac syamc'ab'il sc'anchaj d'a yol scajnub' Jehová yed' pax c'apac cortina ayoch d'a yool. ");
INSERT INTO cac_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","A jun sat yajal yajoch d'a scal eb' levita chi', aton vin̈aj Eleazar yuninal vin̈aj sacerdote Aarón, a vin̈ tz'ilan masanil eb' smunlaj d'a scajnub' Jehová. ");
INSERT INTO cac_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","A eb' yin̈tilalcan vin̈aj Merari, cha macan̈ yaj eb', aton eb' yin̈tilalcan vin̈aj Mahli yed' eb' yin̈tilalcan vin̈aj Musi. ");
INSERT INTO cac_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","A sb'isul masanil eb' vinac, tz'el yich d'a eb' jun ujal sq'uinal sb'eyn̈ejb'ati, ay 6 mil 200 eb'. ");
INSERT INTO cac_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","A yajalil eb', aton vin̈aj Zuriel yuninal vin̈aj Abihail. Tz'aj scampamento eb' d'a stz'eyel scajnub' Jehová d'a stojolal norte. ");
INSERT INTO cac_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Aton eb' tic tz'ilan te' smarcoal, sreglail, yoyal, sb'achnub'al, masanil syamc'ab'il, ");
INSERT INTO cac_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","yed' pax yoyal oyanoch d'a spatictac amac', sb'achnub'al, yestacail yed' masanil sch'an̈al. ");
INSERT INTO cac_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Axo pax d'a stojolal b'aj sjavi c'u d'a yichan̈b'at scajnub' Jehová tz'aj scampamento vin̈aj Moisés yed' vin̈aj Aarón yed' eb' yuninal vin̈aj Aarón chi', aton eb' tz'ac'vi servil d'a yol scajnub' Jehová chi' yuj svach'iloc eb' israel. Tato ay junoc mach sc'och d'a slac'anil cajnub' chi' to man̈ yopisiooc yaji, tojoln̈ej schami. ");
INSERT INTO cac_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ayic ix yic'anchaan̈ sb'isul eb' levita vin̈aj Moisés yed' vin̈aj Aarón d'a stzolal icha ix aj yalan Jehová, a sb'isul eb' vinac d'a smasanil, ay 22 mil, tz'el yich d'a eb' jun ujal sq'uinal sb'eyn̈ejb'ati. ");
INSERT INTO cac_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: Ic'chaan̈ sb'isul yed' sb'i eb' b'ab'el vinac unin d'a scal eb' etchon̈ab', tz'el yich d'a eb' jun ujal sq'uinal sb'eyn̈ejb'ati. ");
INSERT INTO cac_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","A eb' levita tic, vic yaj eb' sq'uexuloc eb' b'ab'el unin chi'. An̈eja' vicpax tz'ajcan masanil noc' smolb'etzal noc' eb' sq'uexuloc noc' sb'ab'el yune' noc' smolb'etzal noc' eb' israel tic. A in ton Jehová in svala', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Yuj chi' ix ic'jichaan̈ sb'isul masanil eb' b'ab'el vinac unin d'a scal chon̈ab' Israel yuj vin̈aj Moisés chi', icha ix aj yalan Jehová. ");
INSERT INTO cac_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Masanil eb' vinac unin jun ujal sq'uinal sb'eyn̈ejb'ati, ay 22 mil 273 eb'. ");
INSERT INTO cac_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Ac'canoch eb' levita tic sq'uexuloc eb' b'ab'el vinac unin d'a scal chon̈ab' Israel. An̈eja' pax noc' smolb'etzal noc' eb' tz'ochcan sq'uexuloc noc' smolb'etzal noc' eb' yetisraelal, yujto vic yaj eb' levita tic. A in ton Jehová in svala'. ");
INSERT INTO cac_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","47","Palta ec'al sb'isul eb' b'ab'el unin d'a chon̈ab' Israel d'a yichan̈ eb' levita chi', yuj chi' a d'a junjun eb' 273 b'ab'el unin syac' sobre chi', tza c'an oyeoc siclo q'uen plata, icha jantac yalil q'uen sc'anchaj d'a in cajnub', aton 20 geras yalil. ");
INSERT INTO cac_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Tzac'an juntzan̈ q'uen tumin chi' d'a vin̈aj Aarón yed' d'a eb' yuninal, aton tz'och sq'uexuloc eb' b'ab'el unin syac' sobre chi', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Icha chi' ix aj smolanq'ue q'uen tumin vin̈aj Moisés ix och sq'uexuloc eb' b'ab'el unin d'a scal chon̈ab' Israel syac' sobre chi'. ");
INSERT INTO cac_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Ix molchaj mil 365 siclo q'uen plata, icha jantac yalil q'uen sc'anchaj d'a scajnub' Jehová. ");
INSERT INTO cac_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Ix lajvi chi', ix yac'an q'uen vin̈aj Moisés d'a vin̈aj Aarón yed' d'a eb' yuninal, icha ix aj yalan Jehová. ");
INSERT INTO cac_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Ix lolon Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón, ix yalan icha tic: ");
INSERT INTO cac_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Ic'q'ue vaan sb'isul eb' yin̈tilalcan vin̈aj Coat d'a stzolal d'a scal eb' levita, ");
INSERT INTO cac_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","aton eb' 30 ab'il sq'uinal sc'och d'a 50. Aton eb' tic smoj val smunlaj d'a in cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","A smunlajel eb' yin̈tilalcan vin̈aj Coat chi', to a juntzan̈ tastac vicn̈ej yaji, a stan̈vej eb', aton juntzan̈ tic: ");
INSERT INTO cac_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ayic sb'atxi eb' chon̈ab', a ach ach Aarón yed' eb' uninal, tzeyiq'uel c'apac cortina ayoch smaculoc jun Lugar Vicn̈ej Yaji, tze musan te' scaxail in trato d'a c'apac. ");
INSERT INTO cac_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Axo d'a yib'an̈ tzeyac'b'at jun tz'uum te lab'ab'i smusiloc. Axo d'a yib'an̈ jun chi' tzeyac'b'at jun c'apac q'uic'mutz'inac, tzeyac'anoch te' b'achlab' yic tz'ic'jib'ati. ");
INSERT INTO cac_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Tzeyac'anpaxb'at jun c'apac q'uic'mutz'inac c'apac d'a sat mexa ay d'a vichan̈, axo d'a yib'an̈ jun chi' tzeyaq'uem q'uen plato, juntzan̈ q'uen nivac cuchara, uc'ab' yed' juntzan̈ xalual vino tz'ac'ji d'a ofrendail yed' ixim pan tz'ac'jitaxoni. ");
INSERT INTO cac_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","A d'a yib'an̈ masanil juntzan̈ chi' tzeyac'b'at jun chacchac c'apac, tze musan d'a jun tz'uum te lab'ab'i chi', tzeyac'anpaxoch te' b'achlab' yic tz'ic'jib'ati. ");
INSERT INTO cac_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Tzeyic'anpaxcot junxo q'uic'mutz'inac c'apac, tze musan jun sb'achnub' candil yed' juntzan̈ candil chi', q'uen q'ueen tz'ic'anel staan̈il c'apac c'apac b'aj tz'och sc'ac'al candil yed' platillo yed' masanil yed'tal sc'anchaj yed' aceite. ");
INSERT INTO cac_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Masanil juntzan̈ chi' tze musej d'a jun noc' tz'uum te lab'ab'i, tzeyac'anq'ue d'a yib'an̈ te b'achlab'. ");
INSERT INTO cac_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Tzeyac'anpaxb'at junxo q'uic'mutz'inac c'apac d'a yib'an̈ altar nab'a oro. Tze pichan d'a juntzan̈ noc' tz'uum lab'ab'i, tzeyac'anpaxoch ste'al yic sb'achchaji. ");
INSERT INTO cac_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Tze molanpax q'ue vaan masanil yamc'ab' sc'anchaj d'a yol in cajnub', tze pichanoch d'a yol jun q'uic'mutz'inac c'apac, tzeyac'anoch juntzan̈xo noc' tz'uum lab'ab'i d'ay, tzeyac'anq'ue d'a yib'an̈ te b'achlab'. ");
INSERT INTO cac_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Yovalil tzeyiq'uel jantac q'uen taan̈ calan yed' xepu' stz'a d'a altar, slajvi chi' tze musan altar chi' d'a jun c'apac c'apac yaxmaquinac. ");
INSERT INTO cac_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Axo d'a yib'an̈ tz'ac'jib'at masanil tastac sc'anchaj d'a altar chi': Aton yed'tal tzac'ac' yed' juntzan̈ q'uen tenedor, q'uen pala, q'uen nivac uc'ab' yed' juntzan̈xo yaln̈ej tas yamc'ab'il. A d'a yib'an̈ masanil juntzan̈ chi' tz'ac'jib'at noc' tz'uum te lab'ab'i, tzeyac'anpaxoch te te' yic sb'achchaji. ");
INSERT INTO cac_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Ayic slajvi e pichan masanil juntzan̈ tastac nivan yelc'och chi', vach'xo yaji yic tz'ic'jib'ati, scot eb' yin̈tilalcan vin̈aj Coat yic syic'anb'at eb'. Masanil juntzan̈ tastac to vic yaj chi', max yal-laj syaman eb' yic max cham eb' yuuj. Masanil jantac syamc'ab'il yic in cajnub' b'aj tzin ch'ox in b'a, a eb' yin̈tilalcan vin̈aj Coat yovalil tz'ic'anb'ati. ");
INSERT INTO cac_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","A vin̈aj Eleazar, vin̈ uninal a ach sacerdote Aarón, a vin̈ tz'ilan tas yaj aceite yic candil, incienso vach' sjab', ofrenda yic ixim trigo to yovalil tz'ac'ji d'ayin yed' aceite sc'anchaji a sic'chajel junoc mach, ma junoc tas tz'ochcan vicoc. A vin̈ stan̈van in cajnub' yed' masanil syamc'ab'il, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ix yalanxi Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Mocab' satel eb' yin̈tilalcan vin̈aj Coat d'a scal eb' eyetlevitail. ");
INSERT INTO cac_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Yic max javi chamel d'a yib'an̈ eb', yuj syaman eb' tastac to vicn̈ej yaji, yovalil tze b'eyb'alej juntzan̈ tic: Ach Aarón yed' eb' uninal, yovalil tzex och yed' eb' d'a yol in cajnub'. A ex tzeyal d'a eb' tastac syic'b'at junjun eb'. ");
INSERT INTO cac_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Yuj chi', max och eb' junoc rato yil tastac to vic yaji, yic max cham eb' yuuj, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Ic'chaan̈ sb'isul eb' yin̈tilalcan vin̈aj Gersón d'a stzolal, ");
INSERT INTO cac_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","aton eb' 30 ab'il sq'uinal sc'och d'a 50, aton eb' smoj val smunlaj d'a in cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Aton smunlajel eb' yin̈tilalcan vin̈aj Gersón tic d'a mantiado chi': ");
INSERT INTO cac_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","A eb' yovalil tz'ic'anb'at c'apac smacul yib'an̈ in cajnub' yed' chab'xo jen̈an smacul yib'an̈, noc' tz'um lab'ab'i ayoch smaculoc yib'an̈, c'apac cortina ayoch d'a smaculoc sti', ");
INSERT INTO cac_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","c'apac cortina ayoch d'a spatictac yamaq'uil in cajnub' b'aj ay altar, c'apac cortina ayoch b'aj ay sti' yamaq'uil chi' yed' syamc'ab'il yed' jantac sch'an̈al ayochi yic tz'och d'a yopisio. A eb' ayoch d'a yib'an̈ yilan juntzan̈ ix b'inaj tic. ");
INSERT INTO cac_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","A vin̈aj Aarón yed' eb' yuninal, a eb' scuchb'an masanil eb' yin̈tilalcan vin̈aj Gersón chi' d'a munlajel sc'ulej yed' yic'anb'at tastac eb' to tz'ic'jib'ati. A eb' tic sch'oxan tastac syic'b'at junjun eb'. ");
INSERT INTO cac_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Aton val yopisio eb' yin̈tilalcan vin̈aj Gersón tic ayic smunlaj eb' d'a in cajnub' b'aj tzin ch'ox in b'a. Sc'anab'ajejocab' masanil tas syal vin̈aj Itamar eb', aton vin̈ yuninal vin̈aj sacerdote Aarón. ");
INSERT INTO cac_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Ic'chaan̈ sb'isul eb' yin̈tilalcan vin̈aj Merari d'a stzolal, ");
INSERT INTO cac_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","aton eb' 30 ab'il sq'uinal sc'och d'a 50, aton eb' smoj val smunlaj d'a in cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","A smunlajel eb', aton yic'anb'at masanil ste'al mantiado chi' eb', aton smarcoal, sreglail, yoyal yed' sb'achnub'al, ");
INSERT INTO cac_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","masanil yoyal oyanoch d'a spatictac yamaq'uil in cajnub', sb'achnub'al yich, yestacail, sch'an̈al yed' masanil syamc'ab'il sc'anchaji. A ex tzeyala' tastac yovalil syic'b'at junjun eb'. ");
INSERT INTO cac_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","A jun munlajel tic scan d'a yol sc'ab' eb' yin̈tilalcan vin̈aj Merari. A vin̈aj Itamar yuninal vin̈aj sacerdote Aarón, a vin̈ tz'alani tas sc'ulej eb', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","A vin̈aj Moisés, vin̈aj Aarón yed' eb' yajalil chon̈ab', a eb' ix ic'anchaan̈ sb'isul eb' levita smoj val smunlaj d'a scajnub' Jehová b'aj sch'ox sb'a, aton eb' 30 ab'il sq'uinal sc'och d'a 50. Aton eb' tic: Eb' yin̈tilalcan vin̈aj Coat, vin̈aj Gersón yed' vin̈aj Merari. D'a stzolal ix ic'jichaan̈ sb'isul eb' icha ix aj yalan Jehová d'a vin̈aj Moisés chi'. A eb' yin̈tilalcan vin̈aj Coat, icha stzolal, ay 2 mil 750 eb' d'a smasanil. A eb' yin̈tilalcan vin̈aj Gersón, icha stzolal, ay 2 mil 630 eb' d'a smasanil. A eb' yin̈tilalcan vin̈aj Merari, icha stzolal, ay 3 mil 200 eb' d'a smasanil. Axo sb'isul eb' levita chi' ix yic'chan̈ vin̈aj Moisés, vin̈aj Aarón yed' eb' yajal yaji, icha syal stzolal, aton eb' 30 ab'il sq'uinal sc'och d'a 50 to smoj val smunlaj d'a scajnub' Jehová b'aj sch'ox sb'a, ay 8 mil 580 eb' d'a smasanil. ");
INSERT INTO cac_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","A jun sb'isul tic, ix ic'chajq'ue vaan, ix alchaj d'a junjun eb' tastac sc'ulej yed' tastac syic'b'ati, icha ix aj yalan Jehová d'a vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Al d'a masanil eb' etisraelal to a eb' anima penaay yuj lepra, eb' tz'el yin̈atil yuj junoc ilya ayoch d'ay, ma eb' syaman junoc chamnac, yovalil tz'ic'jiel eb' d'a spatiquel campamento. ");
INSERT INTO cac_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Masanil juntzan̈ anima chi', tz'ic'jiel eb', eb' vin̈ vinac ma eb' ix ix, yic malaj tas man̈ vach'oc d'a yol campamento b'aj ayinec' eyed'oc, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Ix sc'anab'ajej eb' israel yic'anelta juntzan̈ eb' anima chi', icha ix aj yalan Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Al juntzan̈ tic d'a eb' etchon̈ab': Tato ay junoc vinac, ma junoc ix ix max in c'anab'ajani, syixtan yetanimail, van yoch smul. ");
INSERT INTO cac_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Yovalil syojtaquejel spaltail chi'. An̈ejtona', yovalil syac'xi sq'uexul tastac ix yixtejb'at chi', syac'an jab'ocxo d'a yib'an̈ stojol juntzan̈ chi'. ");
INSERT INTO cac_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Tato toxo ix cham jun mach ix ixtajb'at tastac ay d'ay chi', man̈xa pax junoc ayto yuj sb'a smoj schaan sq'uexul junoc tas chi', a jun chi', tz'ochcan vicoc, axo d'a yol sc'ab' eb' sacerdote scani. An̈ejtona' syac'anpax junoc noc' ch'ac calnel silab'il yic tz'ac'ji tup smul ix och chi'. ");
INSERT INTO cac_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Masanil ofrenda syac' eb' etisraelal d'ayin, tz'ic'jib'at d'a eb' sacerdote. A juntzan̈ chi', yic eb' sacerdote chi' yaji. ");
INSERT INTO cac_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Masanil tastac syac' junoc etisraelal d'ayin, tato tz'ac'ji d'a junoc vin̈ sacerdote, yic vin̈ tz'ajcani, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Ix yalanxi Jehová d'a vin̈aj Moisés ");
INSERT INTO cac_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","to syal juntzan̈ tic vin̈ d'a eb' yetisraelal: Talaj ay junoc vinac sna d'a spatic ix yetb'eyum to ay smul ix say d'a yol sc'ab', ");
INSERT INTO cac_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","14","to smulan ix yed' junoc vinac, palta max nachajel-laj yuj vin̈ tato toxo ix mulan ix, yujto max yal ix, malaj pax junoc mach ix ilan smulan ix. Mato ay pax junoc vinac ton̈ej snaanq'ue icha chi' d'a spatic ix yetb'eyum chi', vach'chom malaj smul ix syac'och d'a yol sc'ab' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","A d'a cha macan̈ lolonel icha chi', a vin̈ vinac chi', syal yic'anb'at ix yetb'eyum vin̈ d'a yichan̈ junoc vin̈ sacerdote. Syac'an chan̈eoc libra ixim harina cebada vin̈ ofrendail yuj ix, palta max secjiemlaj aceite d'a yib'an̈ ixim, max ac'jipaxlaj incienso yed' ixim, yujto a jun ofrenda chi', ofrenda yic c'ac'alc'olal, yopisio yic scheclajelta mul. ");
INSERT INTO cac_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Axo vin̈ sacerdote chi' tz'alani to snitzcot sb'a ix ix chi', tz'ic'jioch ix d'a vichan̈ a in Jehová in tic. ");
INSERT INTO cac_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Elan̈chamel syic'cot jab'oc a a' vin̈ sacerdote chi' d'a yol junoc lum uc'ab', aton a a' vicn̈ej yaji. Syic'anpaxq'ue jab'oc pococ vin̈, aton lum ay d'a in cajnub', syac'anb'at vin̈ d'a scal a a' chi'. ");
INSERT INTO cac_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Tz'och lin̈an ix ix chi' yuj vin̈ sacerdote chi' d'a vichan̈ a in Jehová in tic, syic'anel sc'ox ix, tz'ac'jipaxoch jun ofrenda yuj c'ac'alc'olal chi' d'a yol sc'ab' ix. Axo vin̈ sacerdote chi' ed'jinacq'ue a a' c'a' tz'ic'ancot yaelal, ");
INSERT INTO cac_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","schecan vin̈ yac' sti' ix. Syalan vin̈ d'a ix icha tic: Tato yel maj ach mulan yed' junocxo vinac d'a yol sc'ab' vin̈ etb'eyum tic, malaj tas ol ach ic'anoc a ol uc'anem jun a a' c'a' ed'jinac yaelal tic. ");
INSERT INTO cac_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Palta tato ix ach mulan yed' junocxo vin̈ vinac jun, ix och a mul d'a yol sc'ab' vin̈ etb'eyum, ");
INSERT INTO cac_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","a Jehová ol ach ac'ancanoch ch'oxnab'iloc d'a yichan̈ eb' etchon̈ab'. Ol ach b'inaj yuj eb' d'a chucal, ol malq'ue a c'ool, ol tacjoc yib' a xub'. ");
INSERT INTO cac_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Aton val jun yaelal chi' ol javoc d'a ib'an̈ a ol uc'anem jun a a' tic, yujto a a' ed'jinac yaelal, xcham vin̈ sacerdote chi' d'a ix. Axo stac'vi ix ix chi': Ujocab' icha chi', xcham ix. ");
INSERT INTO cac_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","A juntzan̈ catab' chi', tz'ib'chajocab'can yuj vin̈ sacerdote. Slajvi chi' sb'icanel vin̈ yed' a a' c'a' tz'em d'a yol uc'ab' chi'. ");
INSERT INTO cac_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Slajvi chi' syuc'anem a' ix ix chi', axo yic slajvi yuc'an a' ix, scotcan yaelal d'a yib'an̈ ix. ");
INSERT INTO cac_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Schaanec' ixim harina cebada ofrenda yuj c'ac'alc'olal vin̈ sacerdote chi' d'a yol sc'ab' ix. A jun ofrenda chi' sb'achoch vin̈ sacerdote chi' d'a vichan̈ a in Jehová in tic. ");
INSERT INTO cac_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Syic'anq'ue jun votzoc jun ofrenda vin̈ sacerdote chi', sn̈usantz'a vin̈ d'a yib'an̈ altar yuj sch'oxancot masanil jun ofrenda chi'. Ayic toxo ix yuq'uej a a' c'a' chi' ix, ");
INSERT INTO cac_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","tato ay smul ix d'a yol sc'ab' vin̈ yetb'eyum chi', scot yaelal d'a yib'an̈ ix yuj a a' syuq'uem chi'. Smalq'ue sc'ool ix, stacji yib' xub' ix, tz'ochcan ix ch'oxnab'iloc yed' sb'inaj d'a chucal d'a scal chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Palta tato yel malaj jab'oc smul ix, malaj jab'oc tas tz'ic'an ix, yuj chi' scheclajeli to malaj smul ix, syaln̈ej yalji yune' ix. ");
INSERT INTO cac_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Aton jun ley tic tz'och d'a yib'an̈ ix ix smulan d'a yol sc'ab' vin̈ yetb'eyum, yuj chi' tz'och vin̈ yetb'eyum ix chi' d'a c'ac'alc'olal. ");
INSERT INTO cac_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Tato ay junoc vinac ton̈ej tz'ec' d'a yib'an̈ yac'an c'ac'alc'olal d'a ix yetb'eyum, a jun vinac chi' yovalil syic'cot ix yetb'eyum vin̈ chi' d'a vichan̈ a in Jehová in tic, yic sb'oan vin̈ sacerdote chi' masanil tas syal jun ley tic. ");
INSERT INTO cac_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Tato yel ay smul ix ix chi', a d'a yib'an̈ ix scan smul chi'. Axo d'a yib'an̈ vin̈ vinac chi' malaj tas scani, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Al juntzan̈ tic d'a eb' etchon̈ab': Tato ay junoc vinac ma junoc ix ix syac' sti' yac'anoch sb'a d'a yol in c'ab' d'a nazareoal, ");
INSERT INTO cac_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","maxtzac yal-laj yuc'an vino, ma yuc'an junocxo tas to pajb'inac. Maxtzac yalpax yuc'an vino ochnac vinagreal, ma vinagre pajb'inac. Max yalpax yuc'an yal sat uva, ma sloan sat, ma sloan sat d'a taquin̈al. ");
INSERT INTO cac_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","A d'a jantac tiempo ix yac' sti' chi', man̈ val jab'oc syal yab'lan masanil tastac tz'el d'a te' uva, vach'chom sq'uenal ma stz'umal. ");
INSERT INTO cac_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Max yalpax sjoxanel xil sjolom masanto slajvi jantac tiempo ix yac' sti' chi' d'ayin, schan̈ej q'uib' xil sjolom yujto vic yaj a in Jehová in tic. ");
INSERT INTO cac_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","A d'a jun tiempoal chi', max yal-laj sc'och d'a stz'ey junoc chamnac, ");
INSERT INTO cac_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","vach'chom a smam, ma snun schami, ma junoc yuc'tac, ma junoc yanab', palta max yal-laj sc'och d'a stz'ey yic vach' max can d'a chucal icha yalan ley. Yovalil vach'n̈ej yaji yujto vic yaji. ");
INSERT INTO cac_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","A d'a masanil tiempo b'aj ix yac' sti' chi', juneln̈ej vicn̈ej yaji. ");
INSERT INTO cac_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Talaj ay junoc mach junn̈ej ayec' yed'oc schami, a xil sjolom to vic yaj chi', man̈xo vach'oc tz'ajcan icha yalan ley. Yuj chi' ayic slajvi yec'b'at uqueoc c'ual ayic sb'oxican icha yalan ley, ichato chi' sjoxjiel xil sjolom chi'. ");
INSERT INTO cac_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Axo d'a yucub'ixial, syic'anb'at chavan̈oc noc' paramuch yaln̈ej tas macan̈il d'a junoc vin̈ sacerdote d'a yichan̈ in cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","A vin̈ sacerdote chi' tz'ac'an junoc noc' chi' silab'il yuj smul jun anima chi'. Axo junxo noc' sn̈usjitz'a noc' smasanil silab'il. Icha chi' tz'aj yac'ji tup smul yuj b'aj ix cham jun anima chi' d'a stz'ey. A d'a jun c'u chi', a xil sjolom sq'uib'xi, vic tz'ajxicani. ");
INSERT INTO cac_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Tz'elxi yich jun tiempoal b'aj ix yac' sti' d'ayin. A jantac tiempo ix ec'b'at d'a yalan̈tax chi', maxtzac ochlaj sb'isuloc, yujto a xil sjolom vic yaji, ix ixtaxeli. An̈ejtona' yovalil syic'paxb'at junoc noc' calnel jun ab'il sq'uinal silab'il d'a vichan̈ a in Jehová in tic yuj stupan tas ix sc'ulej chi'. ");
INSERT INTO cac_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ayic slajvi jantac tiempoal ix yac' sti' jun anima chi', yovalil sb'at d'a sti' in cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Ata' syac'och jun silab' d'a vichan̈, sn̈usjitz'a smasanil, aton junoc noc' quelem calnel jun ab'il sq'uinal, malaj jab'oc spaltail. An̈eja' syac'pax junoc noc' nun calnel jun ab'il sq'uinal, malaj jab'oc spaltail. A jun chi' silab' yaj yuj yac'ji tup mul. Tz'ac'ji junoc noc' ch'ac calnel malaj jab'oc spaltail silab'il yic junc'olal. ");
INSERT INTO cac_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","An̈ejtona', yovalil syac' junoc yune' mooch ixim pan malaj yich, a ixim harina te vach' ayoch d'ay calab'il yed' aceite. Syac'pax ixim c'oxox pan malaj yich, ayoch aceite d'ay. Junn̈ej tz'aj yac'an yed' yofrenda d'a ixim trigo yed' vino d'in̈antaxon yac'ani. ");
INSERT INTO cac_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","A junoc vin̈ sacerdote tz'ac'anoch jun silab' yuj mul chi' d'a vichan̈ a in Jehová in yed' silab' to sn̈usjitz'a smasanil. ");
INSERT INTO cac_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Syac'anpax noc' calnel silab'il yic junc'olal. Junn̈ej tz'aj yac'an yed' ixim pan malaj yich chi'. Syac'anpax ofrenda d'a ixim trigo yed' pax vino. ");
INSERT INTO cac_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","A jun ix yac' sti' d'a nazareoal chi', sjoxchajel xil sjolom. A d'a yichan̈ in cajnub' sjoxchajeli. Smolq'ue xil sjolom ayoch ch'oxnab'iloc to vic yaji, sn̈usjitz'a d'a cal c'ac', aton c'ac' b'aj stz'a silab' yic junc'olal. ");
INSERT INTO cac_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Ayic slajvi sjoxjiel xil sjolom chi', a vin̈ sacerdote tz'ic'anq'ue sjen̈jab' noc' calnel tajinacxo chi' yed' jun ixim pan malaj yich ayem d'a yol jun yune' mooch chi' yed' pax jun ixim c'oxox pan malaj yich, syac'anoch vin̈ masanil d'a yol sc'ab' jun ix yac'och sb'a nazareoal chi'. ");
INSERT INTO cac_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Slajvi chi', sb'achanoch juntzan̈ chi' vin̈ sacerdote chi' d'a vichan̈ a in Jehová in tic. A juntzan̈ chi' sic'b'ilel vicoc, yic eb' sacerdote chi' yaji yed' pax sn̈isc'ol noc' sb'achchajoch d'a vichan̈, xub' noc' to sic'chajcaneli, yic vin̈ sacerdote chi' yaji. Ayic toxo ix lajvi masanil juntzan̈ chi', a jun yac'nacoch sb'a nazareoal chi', tzaxo yal yuc'an vino. ");
INSERT INTO cac_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Aton juntzan̈ checnab'il tic d'a eb' nazareo: Tato ay junoc nazareo chi' syac' sti' yac'an junoc ofrenda ec'to d'a yichan̈taxon sleyal, yovalil sc'anab'ajej sc'ulan icha b'aj ix yac' sti' chi', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Al d'a vin̈aj Aarón yed' d'a eb' yuninal, ayic syalan vach' lolonel eb' d'a yib'an̈ eb' eyetisraelal, syal eb' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Yac'ocab' svach'c'olal Jehová d'a eyib'an̈, tzex stan̈vani. ");
INSERT INTO cac_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ex yilocab'och Jehová d'a tzalajc'olal, sch'oxocab' svach'c'olal d'ayex. ");
INSERT INTO cac_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Xajanocab' tzex yiloch Jehová, yac'ocab' junc'olal d'ayex, xchiocab' eb'. ");
INSERT INTO cac_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Icha chi' ol yutej eb' in yac'an b'inaj d'a yib'an̈ eb' etisraelal. A inxo ol vac' in vach'c'olal d'a yib'an̈ eb', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ayic ix lajvi sb'oanq'ue scajnub' Jehová vin̈aj Moisés, ix yac'anoch aceite vin̈ d'ay yed' d'a masanil syamc'ab'il yed' d'a yib'an̈ altar yed' syamc'ab'il. ");
INSERT INTO cac_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","A d'a jun c'u chi' a eb' yajal yaj d'a junjun in̈tilal, aton eb' colvajnac yic'anchaan̈ sb'isul eb' vinac, ");
INSERT INTO cac_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ix yac' yofrenda eb' d'a Jehová: Vaque' carreta ayq'ue yen̈ul yib'an̈ yed' lajchavan̈ noc' mam vacax smunlaj ix yac' eb'. Syalelc'ochi, junjun carreta d'a chatacvan̈ eb' yajal chi', junjun pax noc' vacax chi' d'a junjun eb'. Masanil juntzan̈ chi' ix yac'och eb' d'a yichan̈ scajnub' Jehová. ");
INSERT INTO cac_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Yuj chi' ix yalan Jehová d'a vin̈aj Moisés chi': ");
INSERT INTO cac_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Cha juntzan̈ carreta yed' juntzan̈ noc' vacax smunlaj chi', tzac'an d'a eb' levita yic sc'an eb' d'a munlajel d'a in cajnub' b'aj tzin ch'ox in b'a, icha tastac munlajelal sc'ulej junjun eb', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ix schaan juntzan̈ carreta chi' vin̈, ix schaanpax noc' vacax smunlaj chi' vin̈, ix spojanec' vin̈ d'a scal eb' levita. ");
INSERT INTO cac_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","A d'a eb' yin̈tilalcan vin̈aj Gersón, chab' carreta yed' chan̈van̈ noc' vacax chi' ix yac' vin̈, icha syal smunlajel eb'. ");
INSERT INTO cac_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Axo d'a eb' yin̈tilalcan vin̈aj Merari, chan̈e' carreta yed' vajxacvan̈ noc' vacax chi' ix yac' vin̈, icha syal smunlajel eb' b'aj scuchb'aj yuj vin̈aj Itamar yuninal vin̈aj sacerdote Aarón. ");
INSERT INTO cac_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Axo d'a yin̈tilalcan vin̈aj Coat, malaj carreta, malaj pax noc' vacax ix ac'ji, yujto a eb' sb'achanb'at masanil yamc'ab' yic scajnub' Jehová d'a sjolom sjen̈jab'. ");
INSERT INTO cac_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ayic ix ac'jicanoch yopisio altar, ix yic'b'at yofrenda eb' yajal d'a junjun in̈tilal d'a yichan̈ altar chi'. ");
INSERT INTO cac_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Ix yalan Jehová d'a vin̈aj Moisés chi': A d'a junjun c'u ch'occh'oc eb' yajal d'a junjun in̈tilal ol yic'cot yofrenda yuj yochcan yopisio altar, xchi. ");
INSERT INTO cac_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","A d'a b'ab'el c'u, ix yic'ancot yofrenda vin̈aj Naasón yuninal vin̈aj Aminadab, yajal d'a yin̈tilal Judá. D'a schab'il c'ual, ix yic'ancot yic vin̈aj Natanael yuninal vin̈aj Zuar, yajal d'a yin̈tilal Isacar. D'a yoxil c'ual, ix yic'ancot yic vin̈aj Eliab yuninal vin̈aj Helón, yajal d'a yin̈tilal Zabulón. D'a schan̈il c'ual, ix yic'ancot yic vin̈aj Elisur yuninal vin̈aj Sedeur, yajal d'a yin̈tilal Rubén. D'a yoil c'ual, ix yic'ancot yic vin̈aj Selumiel yuninal vin̈aj Zurisadai, yajal d'a yin̈tilal Simeón. D'a svaquil c'ual, ix yic'ancot yic vin̈aj Eliasaf yuninal vin̈aj Deuel, yajal d'a yin̈tilal Gad. D'a yuquil c'ual, ix yic'ancot yic vin̈aj Elisama yuninal vin̈aj Amiud, yajal d'a yin̈tilal Efraín. D'a svajxaquil c'ual, ix yic'ancot yic vin̈aj Gamaliel yuninal vin̈aj Pedasur, yajal d'a yin̈tilal Manasés. D'a sb'alun̈il c'ual, ix yic'ancot yic vin̈aj Abidán yuninal vin̈aj Gedeoni, yajal d'a yin̈tilal Benjamín. D'a slajun̈il c'ual, ix yic'ancot yic vin̈aj Ahiezer yuninal vin̈aj Amisadai, yajal d'a yin̈tilal Dan. D'a yuxluchil c'ual, ix yic'ancot yic vin̈aj Pagiel yuninal vin̈aj Ocrán, yajal d'a yin̈tilal Aser. Axo d'a slajchavil c'ual, ix yic'ancot yic vin̈aj Ahira yuninal vin̈aj Enán, yajal d'a yin̈tilal Neftalí. Lajann̈ej yofrenda junjun eb' vin̈ ix yic'coti. Aton junjun plato nab'a plata, 130 siclo yalil junjun yed' pax junjun q'uen nivac uc'ab' nab'a plata, 70 siclo yalil junjun, icha echlab' sc'anchaj d'a scajnub' Jehová. A juntzan̈ yed'tal chi' te b'ud'an yuj ixim harina te vach' calab'il yed' aceite, aton syac' eb' d'a ofrendail. Ix yac'anpax junjun q'uen nivac cuchara nab'a oro eb', 10 siclo yalil junjun, b'ud'an yed' incienso. Ix yac'anpax junjun noc' quelem vacax eb', junjun noc' ch'ac calnel, junjun noc' quelem calnel jun ab'il sq'uinal yic sn̈usjitz'a d'a silab'il. Ix yac'anpax junjun noc' mam chiva eb' yic tz'och silab'il yuj mul. Stzac'anilxo ix yac' silab' yic junc'olal eb', chavan̈ noc' toro, ovan̈ noc' ch'ac calnel, ovan̈ noc' mam chiva yed' pax ovan̈ noc' quelemtac calnel jun ab'il sq'uinal ix yac' junjun eb'. ");
INSERT INTO cac_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Masanil ofrenda ix yac' eb' yajal yaj d'a yin̈tilalcan Israel, ayic ix ochcan yopisio altar, aton juntzan̈ tic: Lajchave' q'uen plato nab'a plata, lajchave' uc'ab' nab'a plata yed' lajchave' nivac cuchara nab'a oro. ");
INSERT INTO cac_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Junjun plato chi' 130 siclo yalil, junjun uc'ab' 70 siclo yalil, yuj chi' a q'uen plata chi' d'a smasanil, ay 2 mil 400 siclo yalil, icha echlab' sc'anchaj d'a scajnub' Jehová. ");
INSERT INTO cac_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ay pax lajchave' q'uen nivac cuchara nab'a oro b'ud'an yuj incienso, 10 siclo yalil junjun, icha echlab' sc'anchaj d'a scajnub' Jehová. A q'uen oro d'a smasanil, ay 120 siclo q'ueen. ");
INSERT INTO cac_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","A sb'isul masanil noc' noc' ix n̈usjitz'a silab'il chi', aton tic: Lajchavan̈ noc' quelemtac vacax, lajchavan̈ noc' ch'ac calnel, lajchavan̈ noc' quelemtac calnel jun ab'il sq'uinal, ayn̈ej ixim trigo tz'ac'ji ofrendail yed'oc yed' pax lajchavan̈ noc' mam chiva tz'ac'ji silab'il yuj mul. ");
INSERT INTO cac_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Axo pax noc' noc' ix ac'ji silab'il yuj junc'olal, 24 noc' toro d'a smasanil, 60 noc' ch'ac calnel, 60 noc' mam chiva yed' 60 noc' quelemtac calnel jun ab'il sq'uinal. Aton masanil juntzan̈ ofrenda chi' ix ac'chaji ayic ix ochcan yopisio altar ayic toxo ix ochcan yicoc Jehová. ");
INSERT INTO cac_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ayic tz'och vin̈aj Moisés chi' d'a scajnub' Jehová b'aj sch'ox sb'a yic slolon vin̈ yed' Jehová chi', syab' val vin̈ slolon Jehová yed'oc d'a snan̈al chab' yechel querubín ayoch d'a yib'an̈ b'aj tz'ac'ji tup mul, aton smacul scaxail trato. ");
INSERT INTO cac_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Al d'a vin̈aj Aarón to ayic ol yac'anoch sc'ac'al uque' candil vin̈, a d'a yichan̈ sb'achnub' candil chi' syac' yoc, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Ix sc'anab'ajej vin̈aj Aarón chi' sb'oanoch sc'ac'al juntzan̈ candil chi' yic syac'an yoc d'a yichan̈, icha ix aj yalan Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","A jun b'achnub' candil chi' nab'a oro, tenb'il d'a q'uen martillo, sb'at d'a yich masanto d'a sfloral d'a schon. Ix b'oji jun b'achnub' candil chi' icha val yechel ix sch'ox Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Ic'canel eb' levita d'a scal eb' eyetisraelal tic, tza sacb'itan eb' icha yalan ley. ");
INSERT INTO cac_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Icha tic ol aj a sacb'itan eb': Tza tzicoch a a' d'a eb' yic sacb'ican eb', sjoxjiel masanil xil snivanil eb'. Slajvi chi', sjuc'an spichul eb'. Icha chi' tz'aj sacb'ican eb'. ");
INSERT INTO cac_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Elan̈chamel tzic'cot junoc noc' quelem vacax yed' junoc echlab' ixim harina te vach', calab'il yed' aceite tz'ac'ji ofrendail d'a ixim trigo. Tz'ac'jipax junocxo noc' quelem vacax silab'il yuj mul. ");
INSERT INTO cac_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Tzalan d'a eb' levita to sja eb' smasanil d'a slac'anil cajnub' b'aj tzin ch'ox in b'a, tza molb'anpax masanil eb' eyetisraelal. ");
INSERT INTO cac_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","A eb' levita chi' tz'och eb' d'a vichan̈. Axo ta' ol yac'q'ue sc'ab' eb' eyetchon̈ab' d'a sjolom eb'. ");
INSERT INTO cac_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","A vin̈aj Aarón ol ac'anoch eb' levita chi' d'a vichan̈ a in Jehová in tic yofrendaoc eb' eyetisraelal chi'. Icha chi' ol aj scan eb' in yac'an servil. ");
INSERT INTO cac_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Slajvi chi', syac'anq'ue sc'ab' eb' levita chi' d'a sjolom chavan̈ noc' quelemtac vacax chi'. Jun noc' tz'ac'ji silab'il yuj yac'ji tup mul, axo junxo noc' sn̈usjitz'a smasanil silab'il d'ayin. Icha chi' tz'aj stupcanel smul eb'. ");
INSERT INTO cac_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Slajvi chi' tzac'anoch eb' d'a yichan̈ vin̈aj Aarón yed' eb' yuninal yuj yac'jican eb' d'ayin. ");
INSERT INTO cac_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Icha chi' ol utoc ic'ancanel eb' d'a scal eb' eyetisraelal yic tz'ochcan eb' vicoc. ");
INSERT INTO cac_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Ayic toxo ix lajvi sacb'ican eb' icha yalan ley yed' yac'jicanoch eb' d'a yol in c'ab', tzaxo yal sja eb' d'a in cajnub' b'aj tzin ch'ox in b'a yic smunlaji. ");
INSERT INTO cac_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Aton eb' tic vic tz'ajcan d'a juneln̈ej d'a scal eb' eyetisraelal sq'uexuloc eb' b'ab'el vinac unin. ");
INSERT INTO cac_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Yujto vic yaj masanil sb'ab'el vinac yune' eb' ix eyetchon̈ab' tz'alji yed' pax sb'ab'el yune' noc' e molb'etzal noc' tato vinac noc'. Ayic ix in milancham masanil eb' b'ab'el unin d'a Egipto, ata' ix vac'can masanil eb' b'ab'el vinac unin yic tz'ochcan eb' vicoc. ");
INSERT INTO cac_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Yuj chi' a eb' levita tic tzin cha sq'uexuloc eb' b'ab'el unin chi' ticnaic. ");
INSERT INTO cac_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","A in ix in sic'canel eb' levita tic d'a e cal a ex israel ex tic. Ix vac' eb' d'a vin̈aj Aarón yed' d'a eb' yuninal vin̈ yic a eb' tzin ac'an servil e q'uexuloc d'a in cajnub' b'aj tzin ch'ox in b'a yuj vac'an tup e mul d'a eyib'an̈. A eb' sja d'a vichan̈ e q'uexuloc yic max ex chami tato tzex ja d'a stz'ey in cajnub', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Icha chi' ix aj sc'anab'ajan vin̈aj Moisés, vin̈aj Aarón yed' masanil eb' israel masanil tas ix yal Jehová d'a vin̈aj Moisés chi' yuj eb' levita. ");
INSERT INTO cac_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Ix sacb'itan sb'a eb' levita chi', ix sjuc'anel spichul eb', axo vin̈aj Aarón ix ac'anoch eb' d'a yichan̈ Jehová d'a ofrendail. Ix yac'anpax silab' vin̈ yic stupcanel smul eb'. ");
INSERT INTO cac_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ayic ix lajvi juntzan̈ chi' smasanil, ix och eb' levita chi' b'aj ay scajnub' Jehová b'aj sch'ox sb'a yic smunlaj eb' ta'. A vin̈aj Aarón yed' eb' yuninal scuchb'an eb'. Icha ix aj yalan Jehová d'a vin̈aj Moisés chi', icha chi' ix aj sc'anab'ajan eb' sc'ulan yed' eb' levita chi'. ");
INSERT INTO cac_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Ol och eb' levita d'a yopisio d'a in cajnub' b'aj tzin ch'ox in b'a, ayic 25 ab'ilxo sq'uinal eb'. ");
INSERT INTO cac_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Axo yic slajvi 50 ab'il sq'uinal eb', tz'el eb' d'a yopisio d'a juneln̈ej. ");
INSERT INTO cac_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ayic sc'och sq'uinal eb' d'a icha chi', syal scolvaj eb' yed' eb' smunlaj d'a mantiado chi', palta maxtzac munlaj eb' d'a smunlajel ichataxon ix sc'ulej. Icha chi' tzutej ac'anoch eb' levita d'a smunlajel, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Ayic ix lajvi yab'ilal yelta eb' israel d'a Egipto, yic b'ab'el uj d'a yol schab'il ab'il, ix yalan Jehová d'a vin̈aj Moisés chi' d'a tz'inan lum Sinaí icha tic: ");
INSERT INTO cac_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Al d'a eb' etchon̈ab' israel to syac'och q'uin̈ eb' yic snaancot eb' ayic yelnac eb' d'a libre ichataxon sc'ual to chequel yajcani. ");
INSERT INTO cac_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Tzeyac'och jun q'uin̈ chi' d'a jun c'u chi' ayic vanxo yem c'u, aton yic 14 yoch jun uj tic, tze c'anab'ajan masanil icha yajcan d'a sleyal, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ichato chi' ix yalan vin̈aj Moisés d'a eb' yetisraelal to tz'och jun q'uin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ix yac'och jun q'uin̈ chi' eb' d'a yemc'ualil d'a 14 yoch jun uj chi' d'a tz'inan lum Sinaí, icha ix aj yalan Jehová d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Palta a d'a scal eb' chi', ay juntzan̈ eb' vin̈ man̈ vach'oc yaj icha yalan ley, yujto ix syam junoc chamnac eb' vin̈, maj yal-laj yac'anoch q'uin̈ eb' vin̈ d'a jun c'ual chi'. Yuj chi' ix c'och eb' vin̈ d'a vin̈aj Moisés yed' d'a vin̈aj Aarón d'a jun c'u chi' yic sc'anb'an eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Ix yalan eb' d'a vin̈aj Moisés chi' icha tic: —A on̈ tic ix co yam jun chamnac, yuj chi' man̈ vach'oc caj icha yalan ley. ¿Tocval man̈ ol chajoc cac' cofrenda d'a Jehová d'a jun c'u tic yed' masanil eb' quetchon̈ab'? xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Ix tac'vi vin̈aj Moisés chi' icha tic: —Tan̈vejec, ol vab' tas xchi Jehová eyuuj, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ix yalan Jehová d'a vin̈aj Moisés chi' icha tic: Al juntzan̈ tic d'a eb' etisraelal. ");
INSERT INTO cac_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","E masanil a ex tic yed' eb' eyin̈tilal, yovalil tzeyac'och jun q'uin̈ tic yic tze naancoti ayic vic'annac ex el d'a libre a in Jehová in tic. A mach man̈ vach'oc yaj icha yalan ley, yujto ix syam junoc chamnac, ma eb' najat ayb'at d'a junoc b'aj schec sb'a, ");
INSERT INTO cac_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ol xo yac'och q'uin̈ eb' d'a 14 yoch schab'il uj d'a yemc'ualil. Yovalil schi noc' silab' eb' yed' an̈ itaj c'a' yed' ixim pan malaj yich. ");
INSERT INTO cac_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Malaj jab'ocxo noc' scan yuj eb' d'a junxo c'ual, max smac'poj sb'aquil noc' eb'. Icha ix aj valani, icha val chi' tz'aj eyac'anoch q'uin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Palta tato ay mach max ac'anoch jun q'uin̈ chi', vach'chom vach' yaj icha yalan ley, mato man̈ ayocb'at d'a junoc b'aj schec sb'a, man̈xaocab' yalan yic d'a e cal, yujto maj yac' yofrenda d'ayin d'a jun c'u to chequel yajcan chi', scan smul chi' d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Tato ay eb' ch'oc chon̈ab'il ayec' cajan d'a e cal, sgana eb' syac'och jun q'uin̈ chi' eyed'oc yic tzin yic'anchaan̈, yovalil sc'anab'ajej eb' icha sleyal ix vala'. A ley ix vac' e c'anab'ajej chi', a' sc'anab'ajej pax eb' ch'oc chon̈ab'il ayec' cajan chi' d'a e cal, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","A d'a sc'ual ayic ix b'ojiq'ue scajnub' Jehová, syalelc'ochi aton Mantiado yic trato, ix och jun asun d'a yib'an̈. Ayic ix emcan c'u, lajan ix aj yilji icha c'ac', masanto ix sacb'i d'a junxo c'u. ");
INSERT INTO cac_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ichan̈ej chi' ix aji. Ayn̈ejoch jun asun chi' d'a yib'an̈ cajnub' chi' a tz'ec' c'u, axo d'ac'valil ichato ayoch sc'ac'al jun asun chi'. ");
INSERT INTO cac_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ayic sq'ue vaan jun asun chi' d'a yib'an̈ cajnub' chi', sb'eyb'at eb' israel chi'. Axo b'aj tz'ochxi vaan, ata' sb'oxiq'ue scampamento eb'. ");
INSERT INTO cac_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","A Jehová sch'oxan d'a eb' tato sb'eyb'at eb', mato tz'och vaan eb'. A b'aj tz'och vaan jun asun chi' d'a yib'an̈ scajnub' Jehová, ata' scann̈ej eb'. ");
INSERT INTO cac_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Tato nivan tiempo tz'och vaan jun asun chi', sc'anab'ajej eb' d'a Jehová scan ta'. ");
INSERT INTO cac_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Tato jun chab'n̈ej c'ual tz'ec' jun asun chi' jun, icha chi' sc'ulejpax eb', slajvi chi' sb'eypaxb'at eb', icha tz'aj sch'oxan Jehová d'a eb'. ");
INSERT INTO cac_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ay b'aj junn̈ej ac'val tz'ec' jun asun chi', axo d'a q'uin̈ib'alil sb'atxi, icha chi' tz'aj sb'eyxib'at eb'. Tato d'a c'ualil ma d'ac'valil sb'at jun asun chi', sb'atpax eb'. ");
INSERT INTO cac_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Tato scann̈ej vaan jun asun chi' d'a yib'an̈ scajnub' Jehová chab'oc c'ual, ma junoc ujal, ma junoc ab'il, ata' scann̈ej eb', max b'atlaj eb'. Tato sb'atxi jun asun chi', sb'atxi eb'. ");
INSERT INTO cac_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Masanto a' Jehová tz'alani, tz'och vaan eb'. An̈eja' tz'alanpaxi, sb'atxi eb'. Ix sc'anab'ajejn̈ej eb' d'a Jehová, icha ix aj yalan d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Ix lolonxi Jehová d'a vin̈aj Moisés chi', ix yalan icha tic: ");
INSERT INTO cac_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","B'ochajocab' chab'oc q'uen trompeta nab'a plata, stenchaj d'a q'uen martillo. A juntzan̈ q'uen trompeta chi' spuchaji a tze molb'an eb' anima, ayic tzex b'eypaxb'ati. ");
INSERT INTO cac_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","A spuji chab' q'uen trompeta chi', masanil chon̈ab' sja molan d'a ichan̈ b'aj ay in cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Palta tato junn̈ej q'uen spuji, an̈ej eb' yajal yaj d'a junjun macan̈il in̈tilal smolb'ej sb'a. ");
INSERT INTO cac_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Tato junip syac' spuji q'uen trompeta chi', sq'ue vaan campamento ay d'a stojolal b'aj sjavi c'u b'aj ay in cajnub' syal chi'. ");
INSERT INTO cac_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Axo yic spuchaj q'uen d'a schaelal sb'at eb' ayec' d'a stojolal sur. Yuj chi' a spuchaj q'uen trompeta d'a icha chi', ch'oxnab'il yaji ayic sb'eyb'at eb' chon̈ab'. ");
INSERT INTO cac_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Tato man̈ junipoc syac' spuchaj q'ueen, syalelc'ochi to ton̈ej smolb'aj anima. ");
INSERT INTO cac_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","A mach spu'an q'uen trompeta chi', aton eb' sacerdote yin̈til vin̈aj Aarón. A jun tic ley tz'ajcan d'ayex d'a masanil tiempo. ");
INSERT INTO cac_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Tato ay eb' ajc'ol sjavi yac' oval d'ayex d'a yol e macb'en, tzex el eyac' oval chi' yed' eb', elan̈chamel spuchaj q'uen trompeta, yic tzex in nacot a in Jehová e Diosal in tic, tzex in colanel d'a eb' ajc'ol chi'. ");
INSERT INTO cac_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Axo d'a sc'ual ay e tzalajc'olal, icha d'a sc'ual q'uin̈, ma d'a yic tz'alji q'uen uj, tze pu'an q'uen trompeta chi' yic tzeyac'an silab' stz'ai, ma silab' yic junc'olal. Icha chi' tzex in nacoti. A in ton Jehová e Diosal in tic svala', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ayic 20 yoch schab'il uj yic schab'il ab'il yelta chon̈ab' Israel d'a Egipto, ix q'ue vaan jun asun d'a yib'an̈ cajnub' yic trato. ");
INSERT INTO cac_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ichato chi' ix el eb' israel d'a tz'inan lum yic Sinaí, c'ojanc'olal ix b'eycot eb' masanto ix javi eb' d'a tz'inan lum yic Parán, yujto ata' ix och vaan jun asun chi'. ");
INSERT INTO cac_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Sb'ab'elalto sb'ey eb' tic d'a stzolal icha val ix aj yalan Jehová d'a vin̈aj Moisés. ");
INSERT INTO cac_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","B'ab'el eb' soldado ed'jinac sbandera yin̈tilal Judá. A vin̈aj Naasón yuninal vin̈aj Aminadab ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Axo d'a yichan̈ eb' soldado yic yin̈tilal Isacar, ata' ayoch vin̈aj Natanael yuninal vin̈aj Zuar. ");
INSERT INTO cac_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","A vin̈aj Eliab yuninal vin̈aj Helón ayoch d'a yichan̈ eb' soldado yic yin̈tilal Zabulón. ");
INSERT INTO cac_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ix lajvi chi', ix xuyanq'ue vaan scajnub' Jehová eb', axo eb' yin̈tilalcan vin̈aj Gersón yed' eb' yin̈tilalcan vin̈aj Merari ix ic'anb'ati, yujto a eb' ayoch d'a yib'an̈ yic'anb'eyoc. ");
INSERT INTO cac_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ichato chi' ix cot eb' soldado ed'jinac sbandera yin̈tilal Rubén. A vin̈aj Elisur yuninal vin̈aj Sedeur ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","A vin̈aj Selumiel yuninal vin̈aj Zurisadai ayoch d'a yichan̈ eb' soldado d'a yin̈tilal Simeón. ");
INSERT INTO cac_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","A vin̈aj Eliasaf yuninal vin̈aj Deuel ayoch d'a yichan̈ eb' soldado d'a yin̈tilal Gad. ");
INSERT INTO cac_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Tzac'anto scotpax eb' yin̈tilalcan vin̈aj Coat. A eb' ed'jinac masanil syamc'ab'il scajnub' Jehová. Axo ix c'och eb', toxo ix b'ojiq'ue scajnub' Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ichato chi' ix cot eb' soldado ed'jinac sbandera yin̈tilal Efraín. A vin̈aj Elisama yuninal vin̈aj Amiud ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","A vin̈aj Gamaliel yuninal vin̈aj Pedasur ayoch d'a yichan̈ eb' soldado d'a yin̈tilal Manasés. ");
INSERT INTO cac_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","A vin̈aj Abidán yuninal vin̈aj Gedeoni ayoch d'a yichan̈ eb' soldado d'a yin̈tilal Benjamín. ");
INSERT INTO cac_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Slajvub'alxo masanil juntzan̈ soldado chi', ix cot eb' ed'jinac sbandera yin̈tilal Dan. Aton eb' stan̈van eb' chon̈ab' d'a spatic chi'. A vin̈aj Ahiezer yuninal vin̈aj Amisadai ayoch yajaliloc eb'. ");
INSERT INTO cac_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","A vin̈aj Pagiel yuninal vin̈aj Ocrán ayoch d'a yichan̈ eb' soldado d'a yin̈tilal Aser. ");
INSERT INTO cac_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Axo vin̈aj Ahira yuninal vin̈aj Enán ayoch d'a yichan̈ eb' soldado d'a yin̈tilal Neftalí. ");
INSERT INTO cac_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Icha chi' tz'aj stzolan sb'a eb' israel ayic sb'eyb'at eb'. ");
INSERT INTO cac_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ay jun c'ual, ix yal vin̈aj Moisés d'a vin̈ sb'aluch, aton vin̈aj Hobab yuninal vin̈aj Ragüel aj Madián, vin̈ sn̈i' vin̈aj Moisés chi' icha tic: —A on̈ tic van co b'at d'a jun luum ix yac' sti' Jehová yac'an d'ayon̈. Con̈ qued'oc, vach' ol ach quila', yujto ix yac' sti' Jehová on̈ syailani, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Palta ix yalan vin̈aj Hobab chi' icha tic: —Maay, a in tic ol in paxcan d'a in chon̈ab', b'aj ay masanil eb' in c'ab' voc, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ix yalanxi vin̈aj Moisés chi' d'a vin̈: —Man̈ on̈ actejcani, yujto a ach tic ojtac yec' masanil juntzan̈ lugar b'aj vach' coch vaan d'a tz'inan luum tic, a ach ol on̈ a cuchb'ej. ");
INSERT INTO cac_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Tato tzach b'at qued'oc, a tastac vach' ol yac' Jehová d'ayon̈, ol cac'pax ico', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ix lajvi chi', ix el eb' d'a Sinaí, aton jun tzalan b'aj ix sch'ox sb'a Jehová. Oxe' c'ual ix b'ey eb'. B'ab'el te' scaxail strato Jehová yuj eb', a sch'oxan junoc b'aj vach' syic' yip eb'. ");
INSERT INTO cac_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ayic sb'eyb'at eb', tz'och jun asun yic Jehová d'a yib'an̈ eb' d'a c'ualil. ");
INSERT INTO cac_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ayic tz'ic'jib'at te' caxa chi' syalan vin̈aj Moisés chi' icha tic: Q'uean̈ van Mamin Jehová. Pech saclem eb' ayoch ajc'olal d'ayach. A eb' malaj sgana d'ayach, elocab' lemnaj eb' d'a ichan̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ayic tz'och vaan te' caxa chi', syalanxi vin̈ icha tic: Eman̈cot Mamin Jehová, ajan̈ d'a co cal a on̈ israel man̈xo jantacoc on̈ tic, man̈xo on̈ b'ischajb'enoc, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ay jun c'u ix och ijan eb' israel yalan chucal lolonel d'a Jehová yuj yaelal tz'ec' d'a yib'an̈ eb'. A ix yab'an juntzan̈ lolonel chi' Jehová chi', ix te cot yoval d'a eb', ix yac'cot jun nivan c'ac' d'a scal eb', ix tz'ab'at eb' cajan d'a stitaquel campamento chi'. ");
INSERT INTO cac_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ix q'ue yav eb' chon̈ab' d'a vin̈aj Moisés chi', ix sc'anan scolval vin̈ eb'. Axo vin̈ ix c'anan d'a Jehová, ix tup jun c'ac' chi'. ");
INSERT INTO cac_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Yuj chi' Tabera ix scuchcan jun lugar chi', yujto ata' ix yac' pitzvoc jun c'ac' chi' Jehová d'a scal eb'. ");
INSERT INTO cac_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Tzijtum eb' ch'oc chon̈ab'il ayxo och d'a scal eb' israel. A jun macan̈ anima chi', an̈ej vael naan yuj eb'. Ajun pax eb' israel ix alub'tan̈ani, ix oc'q'ue eb', ix yalan eb' icha tic: Comonoc val ay mach tz'ac'an jab'oc noc' chib'ej co chi'a. ");
INSERT INTO cac_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Sco navalcoti to te ay noc' chay max co manlaj ix co chi' d'a Egipto. Ay pax an̈ pepino, te' melón, an̈ puerro, an̈ cebolla yed' an̈ axux, masanil juntzan̈ chi' ix cab'lej. ");
INSERT INTO cac_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Axo pax d'a tic, te man̈xa jab'oc tas scab'lej, toxon̈ej squixtej co c'ool co vaan jun maná tic, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(A juntzan̈ maná chi', lajan yilji icha sat an̈ culantro, c'an yilji icha stzatajil te' taj. ");
INSERT INTO cac_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Axo sjab', lajan icha sjab' ixim c'oxox pan sb'o yed' aceite. A tz'em yal ac'val, tz'emcan maná chi' d'a scampamento eb'. Ayic sacb'i tz'elta eb' anima chi' smol yico', sjaxan chojoc eb', sb'oan eb' icha tz'aj sb'o ixim pan d'a horno. Ay b'aj stenpoj eb', stz'an̈an eb'.) ");
INSERT INTO cac_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ix yab' vin̈aj Moisés yoc' masanil eb' israel d'a sti' smantiado junjun. Ix te cot yoval Jehová, an̈eja' ix te ja schab'c'olal vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Ix yalan vin̈ d'a Jehová icha tic: —¿Tas yuj tzac' vil yaelal a in a checab' in tic? ¿Tas val yoval a c'ol d'a in patic, yuj chi' tzac' jun chon̈ab' tic in tan̈vej? ");
INSERT INTO cac_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Tocval mamab'il nunab'il vaji, yuj chi' tzala' to tzin chelb'at eb' icha junoc nene' unin d'a sat lum luum alnaccan d'a eb' co mam quicham. ");
INSERT INTO cac_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","¿B'ajtil sb'at vic' noc' chib'ej svac' schi juntzan̈ anima tic? Tz'oc' val eb', tzul yalan eb' d'ayin: Ac'cot noc' chib'ej yic sco chi'a, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Maxtzac yal-laj in tac'vanoch d'a vib'an̈ vic'anb'at jun chon̈ab' tic. Icha junoc icatz te al, icha val chi' yaj svab'i. ");
INSERT INTO cac_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Tato ol ac'n̈ej jun yaelal tic d'ayin, vach' ama tzin ac' chamoc. Tato xajan in uuj jun, iq'uinel d'a scal tzijtum yaelal tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ix yalan Jehová chi' d'a vin̈ icha tic: —Molb'ej 70-oc eb' yichamtac vinaquil chon̈ab', eb' vin̈ nivac yelc'och d'a scal eb' anima tzila', tzic'ancot eb' vin̈ d'a sti' in cajnub' b'aj tzin ch'ox in b'a, tzin a tan̈van ta' yed' eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Axo yic ol in c'ochoc, ol in lolon ed'oc. Ol viq'uel jab'oc espíritu ayoch d'ayach, ol vac'anoch d'a eb' vin̈, yic vach' ol colvaj eb' vin̈ yilan eb' anima tic ed'oc, yic man̈ a ch'ocojoc ol il eb'. ");
INSERT INTO cac_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Slajvi chi', tzalan d'a eb' anima chi' to sb'o sb'a eb', yujto a q'uic'an schi noc' chib'ej eb' ix sc'an chi'. Toxo ix vab' yoc' eb', ix vab'an yalan eb': Comonoc ay jab'oc chib'ej sco chi'a. Te vach'n̈ej cajec' d'a Egipto, xchi eb'. Yuj chi' ol vac' noc' schib'ej eb' chi'. ");
INSERT INTO cac_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Man̈ junn̈ejoc c'ual, man̈ chab'oc c'ual, man̈ oyeoc c'ual, man̈ lajun̈eoc c'ual, man̈ junq'uin̈oc, ");
INSERT INTO cac_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","palta jun ujal ol schi noc' chib'ej chi' eb'. Ol schi noc' eb' masanto ol xej eb' yuj noc'. Ol laj ja noc' d'a yoltac sn̈i' eb', masanto ol syaj noc' eb'. Yujto emnaquiltac ix in yutej eb' a in Jehová in ayinec' d'a e cal. Tz'oc' eb' d'a vichan̈ syalan eb': ¿Tas yuj ix on̈ iq'uelta d'a Egipto? xchi eb', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ix tac'vi vin̈aj Moisés chi' icha tic: —Mamin Jehová, a eb' anima ved'nac tic, ay 600 mil eb' vinac stiempoal yoch soldadoal. Ch'oc pax yaj eb' ix ix yed' eb' cotac unin, tzalani to jun ujal ol ac' noc' chib'ej co chi'a. ");
INSERT INTO cac_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","¿B'ajtil ol cot jantacoc noc' calnel yed' jantacoc noc' vacax sco milchamoc yic syab' schi'an juntzan̈ anima tic? Yed' pax cac'an noc' chay schi eb', vach'chom slajviq'ueta noc' smasanil d'a yol a' mar, an̈ejtona' max yab'laj noc', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ix tac'vi Jehová chi' d'a vin̈ icha tic: —¿Am a naani to jab'n̈ej in poder? A ticnaic ol ila' tato ol elc'och icha sval tic, mato maay, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ix lajvi chi', ix elta vin̈aj Moisés yal d'a scal eb' anima tas ix yal Jehová. Ix smolb'an 70 eb' yichamtac vinaquil chon̈ab' vin̈, ix och oyan eb' vin̈ d'a spatictac scajnub' Dios yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ix lajvi chi', ix emul Jehová d'a scal asun, ix lolon yed' vin̈aj Moisés chi'. Ata' ix ic'jiel jab'oc espíritu ayoch d'a vin̈ yuj Jehová, ix yac'anoch d'a eb' vin̈ 70 ichamtac vinac chi'. Ata' ix och ijan eb' vin̈ slolon icha eb' yalumalel slolonel Dios, palta an̈ej junel chi' ix lolon eb' vin̈ icha chi'. ");
INSERT INTO cac_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ay chavan̈ eb' vin̈ ayoch sb'isuloc eb' vin̈ 70 chi', jun vin̈ scuch Eldad, axo junxo vin̈ scuchan Medad. A eb' vin̈ chavan̈ chi', ix can eb' vin̈ d'a campamento, maj b'atlaj eb' vin̈ d'a scajnub' Dios. Ajun pax eb' vin̈ ix chaan espíritu chi', ix och ijan eb' vin̈ yalanel slolonel Dios d'a campamento chi'. ");
INSERT INTO cac_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Axo ix yab'an jun vin̈ quelem, ix b'at lemnaj vin̈ yal d'a vin̈aj Moisés chi' icha tic: —A vin̈aj Eldad yed' vin̈aj Medad, van slolon eb' vin̈ b'aj ay campamento, ichato yalumalel slolonel Dios eb' vin̈, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yuj chi' a vin̈aj Josué yuninal vin̈aj Nun, vin̈ scolvaj yictax d'a squelemal yed' vin̈aj Moisés chi', ix yal vin̈ icha tic: —Mamin Moisés, a ticnaic alb'ati to scachjioch vaan eb' vin̈ chi' sloloni, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ix tac'vi vin̈aj Moisés chi' icha tic: —¿Tom a gana a inn̈ej nivan velc'och d'a scal eb' anima tic? Comonoc tz'el d'a sc'ol Jehová to syac' Yespíritu d'a masanil anima tic yic vach' tz'ochcan eb' schecab'oc, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ix lajvi chi', ix meltzaj vin̈ yed' eb' yichamtac vinaquil chon̈ab' b'aj ay campamento chi'. ");
INSERT INTO cac_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Junanto val rato chi' ix cot jun ic' te ov d'a yol a' mar yuj Jehová, axo jun ic' chi' ix ic'ancot noc' tzijtumal much scuchan ub'. Ix em noc' d'a yol campamento yed' d'a spatictac, ay am junoc c'ual stec'nab'il spatictac campamento chi' b'aj ix c'och c'aman yem noc'. Junxon̈ej am val metro schaan̈il tz'ec' jen̈en̈oc noc' d'a yib'an̈ luum. ");
INSERT INTO cac_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Masanil d'a jun c'u chi' yed' masanil jun ac'val yed' masanil d'a junxo c'u ix syam noc' eb' anima chi'. A mach quenn̈ej noc' ix yamchaj yuuj, ayn̈ejam lajun̈eoc b'ulan̈ noc' ix syama'. Masanil eb' anima ix och ijan sb'oan noc', ix yac'an tacjoc noc' eb' d'a spatictac campamento chi'. ");
INSERT INTO cac_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ayic van schi'an noc' ub' chi' eb', ix cot yoval sc'ol Jehová d'a eb', ix yac'ancot jun yaelal d'a yib'an̈ eb'. Te nivan eb' ix chami. ");
INSERT INTO cac_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Yuj chi' ix scuchcan jun lugar chi' Quibrot-hataava, yujto ata' ix mucchajcan eb' pec'chib'ej chi'. ");
INSERT INTO cac_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ix lajvi chi', ix el eb' d'a Quibrot-hataava chi', ix b'at eb', ix c'och eb' d'a jun lugar scuch Hazerot. Ata' ix cajnajcan eb' jun tiempoal. ");
INSERT INTO cac_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Ix och ijan ix María yed' vin̈aj Aarón yalan specal vin̈aj Moisés, yujto yic'nac jun ix cusita vin̈ yetb'eyumoc. ");
INSERT INTO cac_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","An̈eja' ix yalanpax eb': Tocval an̈ej d'a vin̈aj Moisés chi' slolon Jehová. Slolonpax d'ayon̈, xchi eb'. Palta ix yab' Jehová tas ix yal eb' chi'. ");
INSERT INTO cac_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","D'a val yel, an̈ej vin̈aj Moisés te emnaquil syutej sb'a d'a scal eb' anima d'a yolyib'an̈q'uinal tic. ");
INSERT INTO cac_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Yuj chi', elan̈chamel ix yal Jehová d'a vin̈aj Moisés, d'a vin̈aj Aarón yed' d'a ix María chi' icha tic: Cotan̈ec eyoxvan̈il d'a sti' in cajnub' b'aj tzin ch'ox in b'a, xchi. Yuj chi' ix c'och eb' yoxvan̈il. ");
INSERT INTO cac_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ix lajvi chi' ix emul Jehová d'a scal jun nivan asun, ix och moyan d'a sti' scajnub' chi', ix avtaj vin̈aj Aarón yed' ix María chi' yuuj. Axo ix c'och eb' d'a yichan̈, ix yalan icha tic: ");
INSERT INTO cac_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ab'ec val tas ol vala': Ayic svac'ancot junoc in checab' d'a e cal, a in tzin ch'ox in b'a d'ay, tzin lolonpax d'a vayichal d'ay. ");
INSERT INTO cac_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Axo pax yed' vin̈ in checab' aj Moisés tic, man̈ ichocta' svutej, yujto an̈ej vin̈ c'anab'ajum syutej sb'a d'a scal eb' vic yaji. ");
INSERT INTO cac_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Q'uelc'umb'a tzin aj yed' vin̈ tzin loloni, te jichichi tz'aj in loloni yed' in yilan vin̈. Tato q'uelc'umb'a tz'aj in sat in lolon yed' vin̈ ¿tas val yuj tze tec'b'ej e b'a eyalan specal vin̈? xchi d'a eb'. ");
INSERT INTO cac_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ix te cot yoval Jehová d'a eb', ix lajvi chi' ix b'ati. ");
INSERT INTO cac_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ayic ix q'ue vaan asun chi' d'a yib'an̈ scajnub' Dios, axo ix María chi' sacvequinac yilji snivanil ix yuj lepra. Ix och q'uelan vin̈aj Aarón chi' d'a ix, ix yilan vin̈ to ayxo och lepra d'a ix. ");
INSERT INTO cac_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Yuj chi' ix yalan vin̈ d'a vin̈aj Moisés chi' icha tic: Mamin, ac' val nivanc'olal d'ayon̈, yujto yuj co man̈ pensaril ix och co mul. ");
INSERT INTO cac_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Comonoc tz'el d'a a c'ol max can ix icha junoc nene' unin chamnacxo ayic tz'alji, ixtaxnacxob'at snivanil, xchi vin̈aj Aarón chi'. ");
INSERT INTO cac_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ix lajvi chi', ix och ijan vin̈aj Moisés chi' yalan d'a Jehová: Mamin, tzin tevi d'ayach to tziq'uel jun ilya tic d'a ix vanab' tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ix tac'vi Jehová chi' d'a vin̈: Q'uinaloc tato a smam ix stzub'anoch d'a sat, ¿tom max can ix q'uixvelal uqueoc c'ual? Ocxom yuj jun smul ix ix och tic, yovalil tz'el ix uqueoc c'ual d'a spatiquel campamento. Slajvi chi', schajixioch ix, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Yuj chi' uque' c'ual ix ic'jiel ix María chi' d'a spatiquel campamento chi'. Ayic ayelta ix d'a spatiquel campamento chi', maj b'eyb'atlaj eb' chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Axo yic ix ochxi ix d'a yol campamento chi', ix el eb' chon̈ab' chi' d'a Hazerot, ix b'at eb' d'a tz'inan luum d'a yol yic Parán. ");
INSERT INTO cac_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ix yalan Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Ac'b'at jayvan̈oc eb' vin̈ vinac, yic sb'at eb' vin̈ yil lum Canaán, lum ol vac' d'ayex. Tza siq'uel junjunoc eb' vin̈ yajal yaj d'a junjun in̈tilal, tza checanb'at eb' vin̈, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ix sc'anab'ajej vin̈aj Moisés checnab'il ix yal Jehová chi'. Ix schecb'at eb' vin̈ ix siq'uel vin̈ chi', ix el eb' vin̈ d'a tz'inan lum d'a yol yic Parán, ix b'at eb' vin̈ yila' tas yilji lum Canaán chi'. Yajal yaj eb' vin̈ smasanil d'a scal eb' yetisraelal. ");
INSERT INTO cac_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Icha tic sb'i eb' vin̈ yed' tastac yin̈tilal: ");
INSERT INTO cac_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","15","A vin̈aj Samúa yuninal vin̈aj Zacur, d'a yin̈tilal Rubén. A vin̈aj Safat yuninal vin̈aj Horí, d'a yin̈tilal Simeón. A vin̈aj Caleb yuninal vin̈aj Jefone, d'a yin̈tilal Judá. A vin̈aj Igal yuninal vin̈aj José, d'a yin̈tilal Isacar. A vin̈aj Oseas yuninal vin̈aj Nun, d'a yin̈tilal Efraín. A vin̈aj Palti yuninal vin̈aj Rafú, d'a yin̈tilal Benjamín. A vin̈aj Gadiel yuninal vin̈aj Sodi, d'a yin̈tilal Zabulón. A vin̈aj Gadi yuninal vin̈aj Susi, d'a yin̈tilal José, syalelc'ochi d'a yin̈tilal Manasés. A vin̈aj Amiel yuninal vin̈aj Gemali, d'a yin̈tilal Dan. A vin̈aj Setur yuninal vin̈aj Micael, d'a yin̈tilal Aser. A vin̈aj Nahbi yuninal vin̈aj Vapsi, d'a yin̈tilal Neftalí. A vin̈aj Geuel yuninal vin̈aj Maqui, d'a yin̈tilal Gad. ");
INSERT INTO cac_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Aton sb'i eb' vin̈ ix schecb'at vin̈aj Moisés yil lum Canaán. (Ix q'uexvi sb'i vin̈aj Oseas yuninal vin̈aj Nun yuj vin̈aj Moisés chi', Josué ix sb'iejcan vin̈ yuj vin̈.) ");
INSERT INTO cac_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ayic ix yac'anb'at eb' vin̈ ilum luum vin̈aj Moisés chi' d'a Canaán, ix yal vin̈ d'a eb' vin̈ icha tic: —Ixiquec, a d'a Neguev tzex b'ati, tzex q'uec'och d'a tzalquixtac, ");
INSERT INTO cac_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","tzeyilani tas yilji luum. Tzeyilanpaxi tas yilji anima cajan ta', tec'an am eb' mato maay. Scham eyilanpaxi, tzijtum am eb' mato jayvan̈n̈ej eb'. ");
INSERT INTO cac_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Tzeyilani, yoltac am mantiado cajan eb' anima chi' mato oyanoch muro d'a spatic schon̈ab' eb'. Tato vach' luum mato maay, ");
INSERT INTO cac_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","tato yax sat luum mato taquin̈. Tzeyilani tato ay ste'al luum. Tzeyac' eyip eyic'ancot sat tas avab'il d'a sat luum chi', tzeyic'cot jab'oc quila', xchi vin̈ d'a eb' vin̈. A d'a stiempoal sb'ab'el sat te' uva, ata' ix xid'ec' eb' vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ix el eb' vin̈ d'a lum tz'inan lum yic Zin masanto ix c'och eb' vin̈ d'a Rehob d'a slac'anil Hamat. ");
INSERT INTO cac_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ix q'uec'och eb' vin̈ d'a Neguev masanto ix c'och eb' vin̈ d'a Hebrón. Ata' ay schon̈ab' vin̈aj Ahimán, vin̈aj Sesai yed' vin̈aj Talmai, yin̈tilalcan vin̈aj Anac. A chon̈ab' Hebrón chi', uquexo ab'il sb'oi ayic sb'onac chon̈ab' Zoán d'a Egipto. ");
INSERT INTO cac_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ayic ix c'och eb' vin̈ d'a jun ch'olan scuch Escol, ata' ix xiquel jun c'ojlab' sat te' uva eb' vin̈, ix stzec'anoch eb' vin̈ d'a jun te te'. Chavan̈ eb' vin̈ ix ic'ancoti, ix yac'anq'ue eb' vin̈ d'a sjolom sjen̈jab'. Ix yic'anpaxcot sat te' granado eb' vin̈ yed' sat te' higo. ");
INSERT INTO cac_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Escol ix scuchcan jun ch'olan chi', yujto ata' ix xiquel jun c'ojlab' sat te' uva chi' eb' vin̈ ilum luum chi'. ");
INSERT INTO cac_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ix lajvi yilan lum luum chi' eb' vin̈ d'a 40 c'ual, ix meltzaj eb' vin̈ ");
INSERT INTO cac_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","d'a Cades, d'a tz'inan lum d'a yol yic Parán. Ata' ayec' vin̈aj Moisés yed' vin̈aj Aarón yed' masanil eb' yetisraelal eb' vin̈. Ix lajvi chi', ix och ijan eb' vin̈ yalani chajtil yilji lum luum chi', ix sch'oxan sat te' avb'en te' ix yic'cot eb' vin̈ chi' d'a luum. ");
INSERT INTO cac_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ix yalan eb' vin̈ d'a vin̈aj Moisés chi' icha tic: —Toxo ix b'at quil lum luum ix ala', val yel te vach' luum, te yax sat luum, ina sat tastac tz'el d'a sat lum tic. ");
INSERT INTO cac_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Palta a eb' anima cajan ta' te tec'an eb', yelxo val nivac chon̈ab' yilji schon̈ab' eb'. Ayoch smuroal spatictac schon̈ab' eb' chi'. An̈ejtona' ix quilpax eb' vin̈ vinac te chaan̈ steel, aton eb' yin̈tilalcan vin̈aj Anac. ");
INSERT INTO cac_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","A eb' amalecita cajan d'a sat lum Neguev, axo d'a siquil lum yed' d'a tzalquixtac, ata' cajan eb' hitita yed' eb' jebuseo yed' pax eb' amorreo. Axo pax d'a stitac a a' mar yed' d'a stitac a' Jordán, a eb' cananeo cajan d'ay, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ix yalan vin̈aj Caleb d'a masanil eb' israel lin̈anoch d'a yichan̈ vin̈aj Moisés chi' to numan tz'aj eb', ix yalan vin̈ icha tic: —A ticnaic coyec, quicxo yaj luum. Ol eln̈ej eb' vin̈ chi' cuuj, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ix tac'vi juntzan̈ eb' vin̈ ix xid'ec' chi' icha tic: —Man̈ ol yal-laj cac'an oval yed' eb' chon̈ab' chi' yujto te tec'an eb' d'a quichan̈, xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ix yalan eb' vin̈ d'a scal eb' chon̈ab' israel chi' to a jun lum luum ix b'at yil eb' vin̈ chi' chuclaj luum. Ix yalanpax eb' vin̈: —A lum xid' quil chi', scham anima yuj luum. Masanil eb' anima ix quil ta', te nivac vinacn̈ej eb'. ");
INSERT INTO cac_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ix quilanpax eb' te chaan̈ steel, eb' yin̈tilalcan vin̈aj Anac. A tzon̈ och lin̈an d'a stz'ey eb', lajan tzon̈ ajcan ichoc noc' chil d'a scal yoc eb'. An̈eja' icha chi' tzon̈ yutej yilanpaxoch eb', xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","A ix yab'an juntzan̈ chi' eb' israel, ix q'ue yav eb' smasanil, oq'ueln̈ej yaj eb' ix ec' jun ac'val chi'. ");
INSERT INTO cac_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ix laj q'ue n̈ilnaj eb' yalan chucal lolonel d'a vin̈aj Moisés chi' yed' d'a vin̈aj Aarón, ix yalan eb' icha tic: Vach' am val tato a d'a Egipto on̈ chamcani, ma jun d'a tz'inan lum tic tzon̈ chami. ");
INSERT INTO cac_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","¿Tas yuj tzon̈ yic'b'at Jehová d'a jun lum luum chi', a am yuj co cham d'a scal oval ta', yic scan eb' ix quetb'eyum yed' eb' cuninal d'a yol sc'ab' eb' cajan ta'? Yelxom val vach' tato tzon̈ meltzaj d'a Egipto, xchi eb' israel chi'. ");
INSERT INTO cac_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ix lajvi chi', ix och ijan eb' smol alan icha tic: Co say junoc mach tzon̈ cuchb'an meltzaj d'a Egipto, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Yuj chi' ix em n̈ojan vin̈aj Moisés yed' vin̈aj Aarón d'a sat lum d'a yichan̈ eb' anima chi' smasanil. ");
INSERT INTO cac_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Axo pax vin̈aj Josué yuninal vin̈aj Nun yed' vin̈aj Caleb yuninal vin̈aj Jefone, aton eb' vin̈ ix xid'ec' iloj luum chi', ix sn̈ic'chitejel spichul eb' vin̈ yuj sch'oxanel scusc'olal. ");
INSERT INTO cac_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Ix yalan eb' vin̈ d'a eb' anima smasanil icha tic: —A lum luum ix b'at quil chi', te vach' luum. ");
INSERT INTO cac_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Te yax sat luum. Tato tz'el d'a sc'ol Jehová scolvaj qued'oc, ol quic'n̈ej luum, a' ol ac'an lum d'ayon̈. ");
INSERT INTO cac_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Yuj val chi', man̈ eyiq'uel e b'a d'a spatic Jehová, man̈ ex xiv d'a eb' anima ay d'a jun luum chi'. Icha co vaan junoc pan, icha chi' ol aj co satanel eb'. ¿Toc ay mach ol colan eb' d'ayon̈? A on̈xo pax tic ayoch Jehová qued'oc. Man̈ ex xiv d'a eb', xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Yuj chi' a eb' anima chi' ix yal eb' to sjulq'uenej eb' vin̈ chavan̈ chi' eb'. D'a val jun rato chi', d'a yichan̈ eb' chon̈ab' smasanil, ix sch'ox sb'a Jehová yed' stziquiquial d'a sti' scajnub' b'aj sch'ox sb'a. ");
INSERT INTO cac_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ix yalan d'a vin̈aj Moisés chi' icha tic: —¿B'aq'uin̈ ol yactej juntzan̈ anima tic in spaticaneli? ¿B'aq'uin̈ ol yactej eb' in schab'c'olani, tic val syil eb' jantac tas satub'tac ix in ch'ox d'a scal eb'? ");
INSERT INTO cac_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","A ticnaic ol vac'cot junoc nivan ilya d'a yib'an̈ jun chon̈ab' tic yic sateli. A d'ayach ol el junoc chon̈ab' vuuj to yelxo nivan, te tec'an ol aj d'a yichan̈ eb' chon̈ab' tic, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Palta ix tac'vi vin̈aj Moisés chi' d'a Jehová icha tic: —Yojtac val eb' aj Egipto jantac a poder ayic ix elta eb' chon̈ab' tic d'a scal eb'. Ayic ol yab'an eb' to tza satel eb' a chon̈ab' tic, ");
INSERT INTO cac_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ol yalan a pecal eb' d'a eb' anima ay d'a yol yic Canaán. A eb' chi', ix yab'pax eb' to a ach Jehová ach tic, ayach ec' d'a co cal, q'uelc'umb'a tzach aj qued'oc tzach loloni. Ayachn̈ej ec' d'a scal jun asun ayec' d'a quib'an̈. D'a c'ualil ayachoch d'a scal jun nivan topan̈ asun chi', tzach b'eyn̈ej d'a quichan̈. Axo d'ac'valil, d'a scal jun nivan c'ac' ayachochi, tzach b'eyn̈ej d'a quichan̈ a on̈ a chon̈ab' on̈ tic. Masanil juntzan̈ tic ix yab' specal eb' aj Canaán chi', ");
INSERT INTO cac_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","palta tato juneln̈ej tza satel eb' a chon̈ab' tic, icha tz'aj satel junoc anima, axo eb' anima ol ab'an specal, tzijtum tas ol yal eb'. Olam yal eb' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Maj yal-laj yic'jioch eb' anima yuj Jehová d'a sat lum b'aj ix yac' sti' yac'an d'a eb', yuj chi' ix satjiel eb' yuuj d'a tz'inan luum, xcham eb'. ");
INSERT INTO cac_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Yuj chi', a ticnaic Mamin Jehová, tzin tevi d'ayach to tza ch'ox a poder, icha b'aj ix ac' a ti', ix alani ");
INSERT INTO cac_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","to max cotlaj oval d'a elan̈chamel, te xajan eb' anima uuj, tz'ac'an nivanc'olal smul eb' chuc yed' eb' pit. Palta max ec'b'atlaj ac'an syaelal junoc mach yuj smul b'aj juneln̈ej pit syutej sb'a d'ayach, tzac'n̈ejcan yaelal d'a yib'an̈ yuninal yed' yixchiquin, masanto d'a schan̈il macan̈ yin̈tilal. ");
INSERT INTO cac_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ac' nivanc'olal smul juntzan̈ anima tic, icha val a nivan vach'c'olal d'a yib'an̈ eb', icha ix aj ac'an nivanc'olal eb' yictax on̈ el d'a Egipto masanto ix on̈ ja d'a tz'inan lum tic, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ix tac'vi Jehová d'a vin̈aj Moisés chi' icha tic: —Ujocab'i, svac' nivanc'olal smul eb' anima tic icha val alan chi'. ");
INSERT INTO cac_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Palta svac'och in b'a testigoal yed' in poder te nivan yelc'ochi to chequel d'a masanil yolyib'an̈q'uinal, ");
INSERT INTO cac_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","vach'chom a jantac eb' tic ix yil in poder eb' yed' juntzan̈ tas satub'tac ix in b'o d'a Egipto yed' d'a tz'inan lum tic, palta ma chequel jayelalxo in yac'an proval eb', max sc'anab'ajejn̈ej eb' tas svala'. ");
INSERT INTO cac_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Yuj chi' man̈ ol c'ochlaj eb' d'a lum ix vac' in ti' vac'an d'a smam yicham eb'. Malaj junoc eb' tzin paticanel tic ol c'och d'a sat luum. ");
INSERT INTO cac_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Palta an̈ej vin̈ in checab' aj Caleb ol c'och d'a sat luum chi', yujto c'anab'ajum vin̈ d'ayin, vach'n̈ej spensar vin̈. A vin̈ ol macb'enan lum yed' eb' yuninal, aton lum ix xid' yil vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Cajan eb' amalecita yed' eb' cananeo d'a ch'olquixtac d'a lac'an tic, yuj chi' q'uic'an tzex meltzaji. Axo d'a tz'inan lum d'a stojolalb'at a' Chacchac Mar tzex b'ati, xchi Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ix yalanxi d'a vin̈aj Moisés yed' d'a vin̈aj Aarón icha tic: ");
INSERT INTO cac_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","—¿Jantacto tiempo ol techaj juntzan̈ anima malaj svach'il spensar tic vuuj? Ix vab' yalan in pecal eb'. ");
INSERT INTO cac_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ixiquec, alec d'a eb' icha tic: A in Jehová in, ix vac' in ti' to ol elc'och icha ix aj vab'an eyalan chi'. ");
INSERT INTO cac_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Masanil eb' vin̈ vinac ec'xo sq'uinal d'a 20 ab'il, eb' vin̈ ix ic'jiq'ue vaan slistail, aton eb' vin̈ ix alan chuc d'a in patic, ol cham eb' vin̈. Ol can c'otjab' sb'aquil eb' d'a tz'inan luum tic. ");
INSERT INTO cac_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","An̈ej vin̈aj Caleb yuninal vin̈aj Jefone yed' vin̈aj Josué yuninal vin̈aj Nun, ol och d'a lum luum ix vac' in ti' vac'an chi' d'ayex. A exxo e masanil, mach ex to chuc tas ix eyal d'a in patic, man̈ ol ex ochlaj d'a luum. ");
INSERT INTO cac_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","A eb' eyuninal ix eyala' to ol ochcan eb' d'a yol sc'ab' eb' ajc'ool, a eb' ol vac'och d'a lum luum maj schalaj e c'ol chi'. Ol yac' tzalajb'oc sc'ol eb' ta'. ");
INSERT INTO cac_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","A exxo pax tic jun, ol can e nivanil d'a tz'inan luum tic. ");
INSERT INTO cac_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","A eb' eyuninal tic, 40 ab'il ol ec' eb' tan̈voj calnel d'a tz'inan luum tic, icha chi' ol aj stupanel e mul chi' eb', aton b'aj ix in e patiquejel chi', masanto ol ex chamcan d'a tic e masanil. ");
INSERT INTO cac_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","D'a 40 c'ual ix eyila' tas yilji lum xid' eyil chi', yuj chi' 40 ab'il ol och yaelal d'a eyib'an̈, syalelc'ochi junjun ab'il d'a junjun c'u. Icha chi' ol aj eyojtaccaneli to svac' syaelal eb' tz'och ajc'olal d'ayin. ");
INSERT INTO cac_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","A in Jehová in tic svala', icha chi' ol vutoc d'ayex. Yujto ix e molb'ejoch e b'a ajc'olal d'ayin, yuj chi' a d'a tz'inan lum tic ol ex satcaneloc, xchi Jehová d'a eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","A eb' vin̈ ix xid'ec' iloj lum yuj vin̈aj Moisés chi', chucn̈ej ix aj yalan eb' vin̈ tas yaj luum, yuj chi' ix b'uchvaj eb' anima d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Axo Jehová ix ac'ancot jun ilya d'a yib'an̈ eb' vin̈ ilum luum chi', yuj chi' ix cham eb' vin̈. Axon̈ej vin̈aj Josué yuninal vin̈aj Nun yed' vin̈aj Caleb yuninal vin̈aj Jefone maj chamlaj yuj jun ilya chi'. ");
INSERT INTO cac_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ayic ix yalan vin̈aj Moisés d'a eb' israel tas ix yal Jehová, masanil eb' ix cusq'ue sc'ool. ");
INSERT INTO cac_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Axo ix sacb'i d'a junxo c'u, ix pet q'ue vaan eb', ix snaan eb' to sb'at eb' yac' oval yed' eb' anima cajan d'a tzalquixtac. Yuj chi' ix yal eb' d'a vin̈aj Moisés chi' icha tic: —A ticnaic, val yel coyec d'a sat lum b'aj ix yac' sti' Jehová to ol yac' d'ayon̈. Yeltoni ix och co mul, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ix yalan vin̈ d'a eb' icha tic: —¿Tas yuj tze tenec' tas ix yal Jehová? A jun tas tze na chi', man̈ vach'oc ol elc'ochoc. ");
INSERT INTO cac_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Man̈ ex b'atoc, yujto man̈ ol ochlaj Jehová eyed'oc, ol ex ac'joc ganar yuj eb' ajc'ool. ");
INSERT INTO cac_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Maclab'ilexxo yuj eb' amalecita yed' eb' cananeo, to ol yac' oval eb' eyed'oc. Ol ex smilcham eb' yujto ix eyiq'uel e pensar d'a Jehová, yuj chi' man̈xo ayocochlaj eyed'oc, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Palta ix spitejn̈ej sb'a eb', ix b'at eb' d'a tzalquixtac. Axo te' scaxail strato Jehová yed' vin̈aj Moisés chi', maj eltalaj d'a yol campamento. ");
INSERT INTO cac_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ayic ix b'at eb' vin̈ chi', maclab'il sq'uec'och eb' vin̈ yuj eb' amalecita yed' eb' cananeo, yuj chi' ix yac' oval eb'. Axo ix aji, ix ac'ji ganar eb' israel, ix pechchaj eb' masanto d'a Horma. ");
INSERT INTO cac_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Ix lolon Jehová d'a vin̈aj Moisés chi', ix yalan icha tic: ");
INSERT INTO cac_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Al juntzan̈ tic d'a eb' etisraelal: Ayic ol ex c'och d'a lum luum ol vac' d'ayex yic tzex cajnaj d'ay, ");
INSERT INTO cac_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","4","tato ayex tze n̈ustz'a junoc noc' vacax, ma junoc noc' calnel, ma junoc noc' chiva silab'il, mato yic tze c'anab'ajan b'aj tzeyac' e ti' eyac'ani, ma ton̈ej tz'el d'a e c'ool, ma yuj junoc q'uin̈ yuj chi' tzeyac'a', yovalil tzeyac'pax chab'oc libra harina te vach' calab'il yed' junoc litro aceite yed' silab' chi'. A jun silab' chi' te suc'uq'ui sjab' svab' a in Jehová in tic. ");
INSERT INTO cac_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","A yed' juntzan̈ silab' toxo ix val chi' tzeyac' junoc litro vino ofrendail yed' junjun noc' calnel chi'. ");
INSERT INTO cac_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Tato a junoc noc' ch'ac calnel tzeyac' silab'il, tzeyac'pax vajxaqueoc libra harina scalaj yed' junoc litro aceite yed' jab'ocxo, ");
INSERT INTO cac_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ec'topax jun litro vino tzeyac' yed'oc. Te suc'uq'ui sjab' jun ofrenda chi' svab'i. ");
INSERT INTO cac_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Tato a junoc noc' quelem vacax tzeyac' silab'il to stz'ai, ma silab'il yic tze c'anab'ajej b'aj tzeyac' e ti', ma silab'il yic junc'olal, ");
INSERT INTO cac_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","tzeyac'pax lajchaveoc libra harina, chab'oc litro aceite ");
INSERT INTO cac_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","yed' pax chab'oc litro vino ofrendail yed'oc. A jun ofrenda chi' suc'uq'ui sjab' svab' a in Jehová in tic. ");
INSERT INTO cac_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Aton juntzan̈ tic yovalil tzeyac' yed' junjun noc' vacax chi', ma yed' junjun noc' ch'ac calnel, ma yed' junjun noc' yunetac calnel, ma yed' junjun noc' yunetac chiva. ");
INSERT INTO cac_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Icha sb'isul noc' tzeyac' silab'il chi', icha pax chi' sb'isul juntzan̈xo ofrenda chi' tzeyac' yed'oc. ");
INSERT INTO cac_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","E masanil a ex israel ex tic, yovalil tze c'anab'ajej juntzan̈ ley tic smasanil ayic tze n̈usantz'a eyofrenda suc'uq'ui sjab' svab' a in Jehová in tic. ");
INSERT INTO cac_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Tato ay junoc ch'oc chon̈ab'il ton̈ej sb'eyec' d'a e cal, mato cajan eyed'oc, tato sgana sn̈usantz'a junoc silab' to suc'uq'ui sjab' svab'i, yovalil sc'anab'ajej masanil sleyal icha tze c'anab'ajej a ex tic. ");
INSERT INTO cac_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","A jun ley chi' tz'och yopisio eyuuj yed' eb' ch'oc chon̈ab'il ayec' cajan eyed' chi'. A jun ley chi' ol b'eyn̈ejb'at d'a e cal d'a masanil tiempo. A ex tic yed' eb' ch'oc chon̈ab'il, lajan eyelc'och d'a yol in sat a in Jehová in tic. ");
INSERT INTO cac_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Junn̈ej ley eyic yaj yed' eb' ch'oc chon̈ab'il chi', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Al juntzan̈ tic smasanil d'a eb' etisraelal: Ayic cajanexxo ec' d'a lum b'aj ol ex vic'b'ati, ");
INSERT INTO cac_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","a ixim trigo syac' d'a lum luum chi' ol e va'a, yovalil tzeyic'canel jab'oc ixim d'a ofrendail yic tzeyac' d'ayin, ");
INSERT INTO cac_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","icha tz'aj yac'chaj ixim sb'ab'laj tec'jieli, icha chi' tz'aj eyac'an ixim d'ayin. An̈ejtona' tzeyac'pax jun b'ab'el pan sb'o d'a ixim harina yic ixim ac' trigo chi' ofrendail d'ayin. ");
INSERT INTO cac_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","A jun macan̈ ofrenda chi' ol eyac'n̈ej d'ayin a in Jehová in tic d'a masanil tiempo. ");
INSERT INTO cac_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Talaj sb'at satc'olal eyuj e c'ulan junoc checnab'il ix val d'a vin̈aj Moisés tic d'a sb'ab'elal, ");
INSERT INTO cac_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","yuj chi' maxtzac e c'anab'ajej yed' pax eb' eyin̈tilal ayic ol b'eyn̈ejb'atoc, aton tic ol e c'ulej: ");
INSERT INTO cac_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Tato ay junoc checnab'il sb'at satc'olal eyuj e c'ulan e masanil, yovalil sn̈usjitz'a junoc noc' quelem vacax eyuj e masanil d'a silab'il to suc'uq'ui sjab' svab' a in Jehová in tic yed' ixim trigo yed' vino tzeyac'taxon ofrendail yed' silab' chi', icha d'a sleyal. Tzeyac'an junoc noc' mam chiva silab'il yuj yac'ji tup e mul. ");
INSERT INTO cac_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Axo junoc vin̈ sacerdote sb'oan jun chi' eyuj e masanil ichataxon d'a sleyal yic stupcanel e mul d'a eyib'an̈. A in ton svac' tupel e mul chi' yujto man̈ sc'anoc e c'ool tze c'ulani, yujto ix eyac'pax silab' yuj e mul. ");
INSERT INTO cac_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","A yuj e silab' chi', stupcanel e mul chi' d'a eyib'an̈ a ex israel ex tic yed' eb' ch'oc chon̈ab'il ayec' d'a e cal, yujto e masanil ix och e mul. ");
INSERT INTO cac_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Palta tato junn̈ej anima tz'och smul, yuj sb'at satc'olal yuuj sc'anab'ajan junoc checnab'il, a yuj smul chi', yovalil syac' junoc noc' cob'es chiva jun ab'il sq'uinal silab'il. ");
INSERT INTO cac_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Axo junoc vin̈ sacerdote tz'ac'anoch jun silab' chi' d'a vichan̈ ichataxon d'a sleyal yuj smul jun anima ix och chi', ayic toxo ix ac'chaj jun silab' chi', stupcanel smul jun anima chi' d'a yib'an̈. ");
INSERT INTO cac_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","An̈eja' jun ley chi' tz'och yopisio eyuuj yed' eb' ch'oc chon̈ab'il ayec' d'a e cal, ayic tz'och e mul to man̈ sc'anoc e c'ool. ");
INSERT INTO cac_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Palta tato ay mach tz'och smul to sc'an sc'ool, vach'chom eyetchon̈ab', ma junoc ch'oc chon̈ab'il, a d'ayin Jehová in tic tz'och smul yuj spitalil. Yuj chi' man̈xaocab' yalan yic jun anima chi' d'a e cal. ");
INSERT INTO cac_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Yujto ix spatiquejel in lolonel, ix stenanec' in checnab'il, yuj chi' man̈xaocab' yalan yic d'a e cal d'a juneln̈ej, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ayic ayec' eb' israel d'a tz'inan luum, ay jun vin̈ israel chi' van yec' c'atzitz d'a sc'ual ic'oj ip ix yilan eb'. ");
INSERT INTO cac_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ix ic'jib'at vin̈ d'a yichan̈ vin̈aj Moisés, d'a yichan̈ vin̈aj Aarón yed' d'a yichan̈ masanil eb' chon̈ab' yuj eb' ix ilan chi'. ");
INSERT INTO cac_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ix tan̈vaj vin̈ yuj eb' yujto manto chequeloc tas ol utaj vin̈. ");
INSERT INTO cac_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Yuj chi' ix yalan Jehová d'a vin̈aj Moisés chi' icha tic: A jun vin̈ tic yovalil ol cham vin̈. Masanil eb' chon̈ab' tic sjulq'uenan vin̈ d'a spatiquel campamento, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Yuj chi' ix yiq'uel vin̈ eb' d'a spatiquel campamento chi'. Ata' ix sjulq'uenejcham vin̈ eb' icha ix aj yalan Jehová. ");
INSERT INTO cac_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Al juntzan̈ tic d'a eb' etisraelal: A ex tic yed' eb' eyin̈tilal, yovalilocab' tz'och yelvanub' stitac e pichul. A juntzan̈ yelvanub' tz'och chi', a an̈ ch'al tzec'b'il topan, stz'ischajoch d'a e pichul chi' yed' an̈ ch'al q'uic'mutz'inac. ");
INSERT INTO cac_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ayic ol eyilanoch juntzan̈ yelvanub' chi', ol e naancot masanil checnab'il ix vala' to yovalil tze c'anab'ajej, yic vach' man̈ ol ex cuchb'ajb'at d'a juntzan̈ tas malaj svach'il yuj e pensar, ma yuj tas e gana d'a yol eyico'. ");
INSERT INTO cac_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Icha val chi' ol aj e naancot in checnab'il, ol e c'anab'ajani. Icha chi' ol aj eyac'anoch e b'a d'ayin to vic ex, a in e Diosal in. ");
INSERT INTO cac_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","A in Jehová e Diosal in ix ex viq'uelta d'a Egipto yic tzin och e Diosaloc, yuj chi' sval juntzan̈ tic d'ayex, xchi d'a vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","A vin̈aj Coré yuninal vin̈aj Izhar yin̈tilalcan vin̈aj Coat, d'a yin̈tilal Leví yed' oxvan̈xo eb' d'a yin̈tilal Rubén, aton vin̈aj Datán, vin̈aj Abiram yuninal eb' vin̈aj Eliab yed' pax vin̈aj On yuninal vin̈aj Pelet, ix meltzajoch eb' vin̈ ajc'olal d'a vin̈aj Moisés. Ix stec'b'ej sb'a eb' vin̈ smolb'an 250-xo eb' yetisraelal. A eb' vin̈ ix yac'och sb'a chi', yajalil chon̈ab' yaj eb' vin̈, ayoch eb' vin̈ sb'isuloc eb' vin̈ tz'ac'an slajtial junoc lolonel d'a yol chon̈ab' chi'. ");
INSERT INTO cac_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Masanil eb' vin̈ chi' ix smolb'ej sb'a, ix b'at eb' vin̈ yil vin̈aj Moisés yed' vin̈aj Aarón, ix yalan eb' vin̈ d'a eb' vin̈ icha tic: —C'ocb'ilxo eyic'anchaan̈ e b'a, yujto co masanil on̈ a on̈ tic, yicxo Jehová caji, aypaxec' d'a co cal co masanil. ¿Tas yuj tzeyac'och e b'a yajalil d'a quib'an̈ a on̈ schon̈ab' on̈ Jehová tic? xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","A ix yab'an juntzan̈ chi' vin̈aj Moisés chi', ix em n̈ojan vin̈ d'a sat luum. ");
INSERT INTO cac_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ix yalan vin̈ d'a vin̈aj Coré yed' d'a masanil eb' vin̈ tzac'anoch yuj vin̈ chi' icha tic: —Ato q'uic'an sch'ox Jehová d'ayon̈ mach eb' yico'. An̈ej eb' sic'b'ilel yuj ol yal yoch d'a stz'ey yac'an servil d'a altar. ");
INSERT INTO cac_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","A d'a q'uin̈ib'alil q'uic'an, tzeyic'cot e chaynub' yic incienso, tzeyac'anem tzac'ac' d'a yool yed' incienso, tzeyac'anoch d'a yichan̈ Jehová. A mach sic'canel Jehová chi', aton jun chi' sic'b'iltaxonel yuuj. C'ocb'ilxo eyic'anchaan̈ e b'a a ex ex vetlevitail tic, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Ix yalanxi vin̈ d'a vin̈aj Coré chi' icha tic: —A ex ex vetlevitail tic, ab'ec tas ol vala': ");
INSERT INTO cac_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","¿Tom te jab'n̈ej yelc'och jun tic e naani, sic'b'il ex el yuj co Diosal d'a scal eb' quetchon̈ab', ix ex yac'anoch d'a slac'anil yic tze tan̈vej scajnub' yed' eyac'an servil eb' eyetchon̈ab'? ");
INSERT INTO cac_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ix el d'a sc'ool Jehová to tzex och d'a slac'anil, axo ticnaic e gana tzex ochxon̈ej sacerdoteal. ");
INSERT INTO cac_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Val yel a vin̈aj Aarón malaj yelc'och vin̈, ¿tas yuj tzeyal chucal lolonel d'a spatic vin̈ yed' masanil eb' ajun eyed' tic? A d'a Jehová chuc tzex loloni ayic tzeyalan chuc d'a spatic vin̈aj Aarón chi', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","D'a elan̈chamel ix schec vin̈aj Moisés chi' b'at ic'joccot vin̈aj Datán yed' vin̈aj Abiram yuninal vin̈aj Eliab, palta ix yalancot eb' vin̈ chi' icha tic: —Max on̈ b'atlaj. ");
INSERT INTO cac_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","¿Tom jab'n̈ej tas tzon̈ utej? Ix on̈ iq'uelta d'a Egipto b'aj te vach', man̈ jantacoc tas ay d'a sat luum, ix on̈ ic'ancoti yic tzon̈ cham d'a tic. A gana to tzac'och a b'a yajalil d'a tic. ");
INSERT INTO cac_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","A ach tic man̈oc d'a junoc lum luum te ay tas d'a sat b'aj ix on̈ ic'coti, malaj jab'oc co luum tzac'a yic scavej jab'oc co uva. ¿Tom te quistal on̈ tzila'? Actejxo on̈ ac'an musansatil. Man̈ ol on̈ b'atlaj cab' tas tzal chi', xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Yuj chi', ix te cot yoval vin̈aj Moisés chi', ix yalan vin̈ d'a Jehová icha tic: —Man̈ a cha yofrenda eb' vin̈ chi'. A in tic, te malaj tas svutej eb' vin̈, malaj junoc sb'uru eb' vin̈ sviq'ueq'ui, xchi vin̈ d'a Jehová. ");
INSERT INTO cac_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Ix lajvi chi' ix yalanxi vin̈ d'a vin̈aj Coré chi' icha tic: —A ach tic a q'uic'an tzach och d'a yichan̈ Jehová yed' eb' vin̈ 250 ajun ed'oc. An̈eja' pax vin̈aj Aarón, sc'ochpax vin̈ ta'. ");
INSERT INTO cac_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","A ach tic yed' vin̈aj Aarón chi', tzeyic'b'at e chaynub' yic incienso, tzeyac'anem incienso d'a yool. An̈eja' icha chi' syutejpax eb' vin̈ ajun eyed'oc tic, tzeyac'anoch d'a yichan̈ Jehová, xchi vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Axo d'a junxo c'u chi', ix yic'ancot schaynub' eb' vin̈ chi', ix yac'anem tzac'ac' eb' vin̈ d'a yool yed' incienso. Ix smolb'anoch sb'a eb' vin̈ d'a stz'ey vin̈aj Moisés yed' vin̈aj Aarón d'a sti' cajnub' b'aj sch'ox sb'a Jehová. ");
INSERT INTO cac_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","A vin̈aj Coré chi' toxo ix smolb'ejoch eb' vin̈ ajun yed'oc chi' d'a sti' scajnub' Dios, aton eb' vin̈ ayxo och ajc'olal d'a vin̈aj Moisés yed' d'a vin̈aj Aarón chi'. D'a val jun rato chi' ix sch'oxan stziquiquial Jehová d'a yichan̈ eb' chon̈ab' chi' smasanil. ");
INSERT INTO cac_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ix yalan Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","—B'esequel e b'a d'a scal juntzan̈ anima tic. D'a jun rato tic ol in satel eb', xchi. ");
INSERT INTO cac_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Yuj chi' ix em n̈ojjab' eb' vin̈ d'a sat luum, ix yalan eb' vin̈ icha tic: —Mamin, yajal aj d'a sq'uinal masanil anima, ¿tom tza satel masanil eb' anima tic yuj smul junoc? xchi eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ix tac'vi Jehová d'a vin̈aj Moisés chi': ");
INSERT INTO cac_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","—A ticnaic al d'a masanil eb' molanec' tic to sb'esel sb'a eb' smasanil d'a spatictac smantiado vin̈aj Coré, vin̈aj Datán yed' vin̈aj Abiram, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ix q'ue vaan vin̈aj Moisés chi', ix b'at vin̈ b'aj ayec' vin̈aj Datán yed' vin̈aj Abiram chi', ix b'at masanil eb' yichamtac vinaquil eb' israel yed' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ix yalan vin̈ d'a masanil eb' chon̈ab' chi' icha tic: —B'esequel e b'a d'a smantiado jun macan̈ eb' anima chuc spensar tic. Malaj junoc tas ay d'a eb' tzeyama', tato maay, ol ex cham yuj syaelal smul eb', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Yuj chi' ix sb'esel sb'a eb' anima smasanil d'a spatictac smantiado vin̈aj Coré, vin̈aj Datán yed' vin̈aj Abiram chi'. A vin̈aj Datán yed' vin̈aj Abiram chi', ix elta lin̈an eb' vin̈ d'a sti' smantiado yed' eb' ix yetb'eyum yed' eb' yuninal. ");
INSERT INTO cac_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Ix och ijan vin̈aj Moisés yalan icha tic: —Icha tic ol aj eyojtaccaneli to a Jehová schecan in c'ulej masanil juntzan̈ tic, man̈ yoloc vic tzin c'ulej. ");
INSERT INTO cac_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Tato ilya tz'ic'an scham eb' tic, ichataxon tz'aj scham anima, syalelc'ochi to man̈oc Jehová tzin ac'anoch d'a jun opisio tic. ");
INSERT INTO cac_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Palta tato ay junoc tas to mantalaj b'aj tzuji ol sc'ulej Jehová, ol spoj sb'a lum luum tic, axo eb' anima tic pitzanto eb' ol b'atcan eb' d'a yol luum yed' masanil tas ay d'ay. Tato icha chi' ol aj scham eb', ol eyojtaquejeli to ix spatiquejel Jehová eb', xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ayic ix lajvi yalan juntzan̈ chi' vin̈aj Moisés chi', ix pax levnaj lum luum d'a yalan̈ eb' vin̈ chi'. ");
INSERT INTO cac_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Ix emcan eb' vin̈ d'a yol luum yed' yalyuninal smasanil. Icha val chi' ix aj satel masanil eb' junn̈ej ix aj spensar yed' vin̈aj Coré chi' yed' masanil tastac ay d'a eb'. ");
INSERT INTO cac_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Pitzan eb' anima chi' smasanil ix b'atcan eb' d'a yol luum chi' yed' masanil tastac ay d'a eb'. Ix lajvi chi', ix snub'anxi sb'a luum. Icha chi' ix aj satcanel jun macan̈ anima chi' d'a scal eb' yetisraelal. ");
INSERT INTO cac_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Ayic ix yab'an eb' anima oyanec' d'a spatictac chi', ix el yav eb', ix b'at eb' elelal, ix yalan eb': Mocab' b'atpax levnaj lum d'a calan̈ a on̈ tic, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","An̈eja' ix yac'paxcot c'ac' Jehová yic ix tz'apaxb'at eb' 250 ix n̈usan incienso, aton eb' ix yac'och sb'a yed' vin̈aj Coré, vin̈aj Datán yed' vin̈aj Abiram chi'. ");
INSERT INTO cac_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Ix yalanxi Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Al d'a vin̈aj Eleazar yuninal vin̈aj Aarón to syiq'uelta juntzan̈ schaynub' yic incienso eb' vin̈ ix tz'ab'at chi' vin̈, aton juntzan̈ nab'a bronce. Slajvi chi' najat sb'at vin̈ stob'canel tzac'ac' ayem d'a yool. ");
INSERT INTO cac_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","A schaynub' yic incienso juntzan̈ anima ix cham yuj smul tic, vicxo ix ajcani, yujto ix c'anchaji a ix yac'an incienso eb' d'ayin. Yuj chi', a juntzan̈ yamc'ab' chi' tze b'ooch d'a laminail yic tz'och smusiloc altar, yic vach' ayic syilanoch eb' israel, snaancot eb' tas ix aj scham eb' yuj schucal, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ix smolb'ancot masanil chaynub' yic incienso nab'a bronce vin̈aj sacerdote Eleazar chi', aton juntzan̈ ix sc'an eb' ix tz'ab'at yuj c'ac' chi', ix yalan vin̈ to tz'ac'ji ulaxoc, sb'oji d'a laminail yic tz'och smusiloc altar. ");
INSERT INTO cac_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","A jun tic ix cani yic snaancot eb' israel yed' yojtacanel eb' to an̈ej eb' yin̈tilalcan vin̈aj Aarón syal yoch d'a yichan̈ altar yic sn̈usan incienso eb' d'a yichan̈ Jehová. Tato ay junocxo comonn̈ej sc'ulej icha chi', scham icha ix aj scham vin̈aj Coré yed' eb' ajun yed'oc. Icha val ix yutej Jehová yalan d'a vin̈aj Moisés, icha chi' ix sc'ulej vin̈aj Eleazar chi'. ");
INSERT INTO cac_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Axo d'a junxo c'u, masanil eb' israel ix och ijan yavaj chaan̈ d'a vin̈aj Moisés yed' d'a vin̈aj Aarón, ix yalan eb' icha tic: —A ex tic, ix e milcham eb' schon̈ab' Jehová, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ayic van smolb'an sb'a eb' chon̈ab' smasanil d'a spatic vin̈aj Moisés yed' vin̈aj Aarón chi', ix b'at q'uelan eb' d'a scajnub' Dios. D'a val jun rato chi' ix och moynaj asun d'a scajnub' chi', ix sch'oxan stziquiquial Jehová. ");
INSERT INTO cac_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Yuj chi', ix snitzanb'at sb'a vin̈aj Moisés yed' vin̈aj Aarón d'a yichan̈ cajnub' chi'. ");
INSERT INTO cac_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Ix yalan Jehová d'a vin̈aj Moisés chi': ");
INSERT INTO cac_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","—Elan̈ec d'a stz'ey juntzan̈ anima tic, yujto a d'a jun rato tic ol in satel eb' d'a juneln̈ej, xchi. Ixn̈ej val yab' eb' vin̈ icha chi', ix em n̈ojjab' eb' vin̈ d'a sat luum. ");
INSERT INTO cac_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Ix yalan vin̈aj Moisés d'a vin̈aj Aarón chi' icha tic: —Ic'cot a chaynub' yic incienso, tzac'an b'ud'joc yed' tzac'ac' ayec' d'a yib'an̈ altar. Tzac'anpaxem incienso d'a yool, tzach b'at d'a scal eb' anima d'a elan̈chamel. Tza c'anan nivanc'olal yuj smul eb', yujto toxo ix cot yoval Jehová. Toxo ix ja ilya yic scham anima smasanil, xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Ix sc'anab'ajan vin̈aj Aarón chi', elan̈chamel ix b'at lemnaj vin̈ d'a scal eb' anima b'aj ayec' molan chi'. A yuj jun ilya ix yac'cot Jehová chi' toxo ix yamchajoch scham anima. D'a val jun rato chi', ix yac'anem incienso vin̈ yic tz'ac'ji nivanc'olal eb' anima chi' yuj Jehová. ");
INSERT INTO cac_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ix och vin̈ d'a scal eb' anima toxo ix chami yed' eb' pitzanto. Ichato chi' ix och vaan jun ilya chi'. ");
INSERT INTO cac_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","A d'a jun rato chi', 14 mil 700 eb' anima ix chami. Ch'oc pax yaj juntzan̈ eb' toxo ix cham yed' vin̈aj Coré yuj schucal. ");
INSERT INTO cac_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ato yic ix och vaan scham anima chi', ix meltzaj vin̈aj Aarón b'aj ayec' vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Ix lajvi chi', ix yalan Jehová d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Al d'a eb' vin̈ yajalil chon̈ab' d'a junjun in̈tilal to syic'cot junjunoc sc'ococh eb' vin̈, syalelc'ochi to lajchave' te' scot d'a smasanil, tz'och sb'i junjun eb' vin̈ d'a te' sc'ococh chi'. ");
INSERT INTO cac_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","A te' yic yin̈tilal Leví, a sb'i vin̈aj Aarón tz'och d'a te', yujto junjun sc'ococh eb' vin̈ yajalil junjun in̈tilal ol cotoc. ");
INSERT INTO cac_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Tzac'canoch te' d'a yichan̈ scaxail trato ay d'a yol in cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Ata' ol vac' volan sc'ococh mach syal in c'ool to ol in sic'caneli, yuj chi' ol och vaan eb' anima tic yalan e pecal, xchi Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ix lajvi chi' ix yalan vin̈aj Moisés d'a eb' vin̈ yajalil chon̈ab' d'a junjun in̈tilal. Ix yac'an sc'ococh junjun eb' vin̈ d'a vin̈, lajchave' te' d'a smasanil. Aypaxoch te' yic vin̈aj Aarón chi' d'a scal te'. ");
INSERT INTO cac_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ix yac'anoch te' c'ococh chi' vin̈aj Moisés chi' d'a yichan̈ Jehová d'a yol cajnub' yic trato. ");
INSERT INTO cac_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Axo d'a junxo q'uin̈ib'alil ix c'och vin̈ ta', ix yilanoch te' sc'ococh vin̈aj Aarón chi' vin̈ d'a yic yin̈tilal Leví, toxo ix elta svol te', ayxo xumaquil yed' pax sat, q'uin̈xo te' almendro chi'. ");
INSERT INTO cac_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ix lajvi chi', ix yic'anelta te' c'ococh chi' vin̈ d'a yichan̈ Jehová, ix sch'oxan te' vin̈ d'a masanil eb' yetisraelal. Axo ix lajvi yilan te' eb', ix yac'anxi junjun te' yic eb' vin̈ chi' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ix lajvi chi', ix yalan Jehová d'a vin̈ icha tic: Ac'canoch te' sc'ococh vin̈aj Aarón d'a yichan̈ scaxail trato. Sic'canb'at te' ta' yic snacot juntzan̈ anima te pit tic. Yuj chi' ol yactej eb' yalan chucal lolonel d'ayin yic max cham eb', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Ix sc'anab'ajej vin̈aj Moisés sc'ulan masanil tas ix yal Jehová chi'. ");
INSERT INTO cac_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Axo ix yalan eb' chon̈ab' chi' d'a vin̈ icha tic: Juneln̈ej chamnac on̈xo el co masanil. ");
INSERT INTO cac_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Tato jichan scham masanil eb' snitzcot sb'a d'a scajnub' Jehová, ol on̈ cham co masanil syal chi', xchi eb'. ");
INSERT INTO cac_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Ix yalan Jehová d'a vin̈aj Aarón icha tic: Tato tz'och junoc palta d'a in cajnub', a yaelal sja yuj jun chi', a d'a ib'an̈ yed' eb' uninal yed' d'a yib'an̈ eb' etlevitail sjavi. Palta a junoc paltail d'a eyopisio d'a sacerdoteal, an̈ej d'a ib'an̈ yed' eb' uninal sjavi yaelal yuj jun chi'. ");
INSERT INTO cac_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Tzic'cot eb' etlevitail yic scolvaj eb' ed'oc ayic ayachoch yed' eb' uninal d'a eyopisio d'a yol in cajnub' yic trato. ");
INSERT INTO cac_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Aton eb' smunlaj ed'oc d'a in cajnub' chi', palta chequeln̈ej yaj yopisio eb'. Max yal-laj sjavi eb' d'a slac'anil altar, max yalpaxlaj syaman syamc'ab'il in cajnub' chi' eb' yic vach' max cham eb' yed' ex pax tic. ");
INSERT INTO cac_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ajun eb' smunlaj eyed'oc, palta a ex tzeyala' tas sc'ulej eb' ayic sb'oan masanil smunlajel eb' d'a in cajnub' b'aj tzin ch'ox in b'a. Malaj junocxo comon anima syal sja d'a e lac'anil. ");
INSERT INTO cac_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","A exn̈ej tic ayoch d'a eyib'an̈ e b'oan masanil munlajel d'a in cajnub' yed' d'a altar yic man̈xo ol cot voval d'a masanil eb' etchon̈ab'. ");
INSERT INTO cac_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","A in ix vic'canel eb' etlevitail d'a scal masanil eb' etisraelal. Ix vac'an eb' d'ayex yic smunlaj eb' eyed'oc d'a in cajnub'. ");
INSERT INTO cac_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Palta a achn̈ej yed' eb' uninal tzil munlajel b'aj ay altar yed' d'a spaticoch c'apac cortina. A juntzan̈ opisio chi' ix vala' to a exn̈ej tic tzeyila', yujto a in ix vac' eyopisio. Tato ay junoc mach man̈ ayococh sacerdoteal d'a yib'an̈ snitzanoch sb'a d'a slac'anil juntzan̈ yamc'ab' chi', a jun chi' tojoln̈ej schami, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Ix yalanpax Jehová d'a vin̈aj Aarón chi' icha tic: A in svac' opisio a chaan masanil juntzan̈ ofrenda tz'ac'ji d'ayin yuj eb' etisraelal tic. Masanil tas syic'cot eb' chi' d'ayin, ic tz'ajcan yed' eb' uninal. A jun tic ley tz'ajcan d'a e cal d'a masanil tiempo. ");
INSERT INTO cac_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Masanil ofrenda tz'ac'ji d'ayin, a in svac' d'ayach yed' d'a eb' uninal, aton juntzan̈ max tz'alaj: Ofrenda yic ixim trigo, silab' yuj yac'ji tup mul yed' silab' yuj stupchaj mul. ");
INSERT INTO cac_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Masanil eb' vinac d'a e cal tic, syal schi'an juntzan̈ silab' chi' eb', an̈ej d'a junoc lugar vic yaji, ata' schi eb'. Yovalil tze na'a to vic yaj juntzan̈ silab' chi'. ");
INSERT INTO cac_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Svac'pax d'ayach yed' d'a ix etb'eyum yed' d'a eb' uninal juntzan̈ ofrenda syic'cot eb' etisraelal d'ayin, aton juntzan̈ sb'achchajoch d'a vichan̈. A jun ley tic scan d'a masanil tiempo, yaln̈ej mach eb' ayec' cajan eyed'oc to vach' yaj icha yalan ley, syaln̈ej schi'an eb'. ");
INSERT INTO cac_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","A sb'ab'el sat tastac tz'avchaji aton syic'cot eb' etisraelal d'ayin d'a junjun ab'il, svac'canpax d'ayach: Aton aceite te vach', vino te vach' yed' ixim trigo te vach', ");
INSERT INTO cac_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","yed' pax sb'ab'el sat masanil te' avb'en te' syic'cot eb' d'ayin. A juntzan̈ chi' ic yaj yed' masanil eb' ayec' cajan ed'oc. Tato vach' yaj eb' icha yalan ley, syal svaan eb'. ");
INSERT INTO cac_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Masanil ofrenda syac' eb' etisraelal d'ayin, icn̈ej yaji. ");
INSERT INTO cac_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Masanil eb' sb'ab'el vinac unin eb' etisraelal yed' pax sb'ab'el yune' noc' smolb'etzal noc' eb' syac' d'ayin, icn̈ejpax yaji. Palta a yuj eb' b'ab'el vinac unin chi' yed' sb'ab'el yune' noc' noc' max ochtaxon silab'il, yovalil tz'ac'ji q'uen tumin sq'uexuloc. ");
INSERT INTO cac_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ayic junxo ujal yalji, tz'ac'ji q'uen tumin chi' sq'uexuloc. A yuj eb' unin chi', oye' siclo q'uen plata tz'ac'ji, icha q'uen sc'anchaj d'a in cajnub', 20 geras yalil. ");
INSERT INTO cac_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Palta man̈ a cha ac'joc tumin sq'uexuloc sb'ab'el yune' noc' vacax, noc' calnel yed' noc' chiva, yujto a juntzan̈ noc' chi', vic yaj noc'. Yovalil tze milcham noc', tze tzicanoch schiq'uil noc' d'a altar, axo xepual noc' tze n̈ustz'aoc yic tz'och d'a ofrendail to suc'uq'ui sjab' svab'i. ");
INSERT INTO cac_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ic tz'ajcan masanil schib'ejal noc' chi', icha ix aj vac'an schib'ejal juntzan̈xo noc' silab' d'ayach, aton noc' sn̈i' sc'ool sb'achchajq'ue d'a yichan̈ altar yed' sb'ac'chil xub' noc' d'a svach'. ");
INSERT INTO cac_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Masanil yofrenda eb' etisraelal syiq'ueli to vic yaji, svac' d'ayach yed' d'a ix etb'eyum yed' d'a eb' uninal. A jun tic, ley tz'ajcan d'a masanil tiempo, a in tzin b'ocan eyed'oc yed' masanil eyin̈tilal, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ix yalanxi Jehová d'a vin̈aj Aarón chi': A ach tic malaj lum luum ol a macb'enej d'a scal eb' etisraelal tic, yujto a in tic icha a macb'en vaji. ");
INSERT INTO cac_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","A eb' levita, a masanil sdiezmoal sat yavb'en eb' eyetisraelal, a ix vac' smacb'enej eb'. Aton ayoch stojoloc masanil smunlajel eb' d'a cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Axo masanil juntzan̈xo eb' etisraelal, max yal comonn̈ej sjavi eb' d'a slac'anil cajnub' chi'. Tato icha chi' sc'ulej eb', tz'ochcan chamel d'a yib'an̈ eb' yuj smul chi'. ");
INSERT INTO cac_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Yuj chi' an̈ej eb' levita ay yalan yic yilan masanil tas yic in cajnub' chi'. Tato tz'och junoc spaltail eb' d'a smunlajel chi', an̈ej d'a yib'an̈ eb' scotcan yaelal. A jun tic ley tz'ajcan d'a masanil tiempo. A eb' levita malaj slum eb' ol scha d'a scal eb' eyetisraelal. ");
INSERT INTO cac_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Yic eb' yaj masanil sdiezmoal tas syavej eb' eyetisraelal syac' d'ayin a in Jehová in tic. Yuj chi' ix vala' to malaj slum eb' ol scha'a, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ix yalanxi Jehová d'a vin̈aj Moisés icha tic: ");
INSERT INTO cac_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Al d'a masanil eb' levita to a in Jehová in sval icha tic: Ayic ol e chaan masanil sdiezmo eb' eyetisraelal, yovalil tzeyic'paxcanel sdiezmoal yic tzeyac'an d'ayin, yujto a juntzan̈ chi' ayoch e macb'enoc. ");
INSERT INTO cac_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","A jun diezmo tzeyac' chi', icha sdiezmoal sat smunlajel eb' eyetisraelal syac'a'. ");
INSERT INTO cac_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","A d'a diezmo tze cha d'a eb' eyetisraelal chi', ata' tzeyic'paxel eyofrenda tzeyac' d'ayin. A d'a vin̈aj sacerdote Aarón tzeyac'a'. ");
INSERT INTO cac_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Yuj chi' masanil tastac tz'ac'ji d'ayex, yovalil tzeyic'canel junoc macan̈ d'ay, tzeyac'an d'ayin. A jun macan̈ tzeyac' d'ayin chi', yovalil aton val svach'il. ");
INSERT INTO cac_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Ayic toxo ix eyic'canel svach'il to vic yaj chi', axo jantacto scani, eyicxo tz'ajcani ichato a ex ay e munlajel. ");
INSERT INTO cac_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Syalxo e vaan yed' eyal eyuninal yalxon̈ej b'aj cajan ex. E tojol yaj yuj b'aj tzex munlaj d'a in cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ayic toxo ix eyic'canel jun macan̈ te vach' chi' d'ayin, tzaxo yal e vaan jantacto scan chi', malaj e mul tz'och yuj e vaani. A d'a icha chi', max eyixtejb'atlaj yofrenda eb' eyetisraelal to vic yaji. Yuj chi' maxtzac javilaj chamel d'a eyib'an̈, xchi Jehová, xa chi d'a eb'. ");
INSERT INTO cac_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Ix yalanxi Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón icha tic: ");
INSERT INTO cac_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","A in Jehová in svac' jun checnab'il tic. Alec d'a eb' eyetchon̈ab' to syic'cot junoc noc' cob'es chacchac vacax eb' malaj jab'oc spaltail, manto juneloc smunlaji. ");
INSERT INTO cac_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","A ex tic tzeyac' noc' d'a vin̈aj sacerdote Eleazar. Tz'ic'jiel noc' d'a spatiquel campamento, axo vin̈aj Eleazar chi' schecan miljoccham noc' d'a yichan̈. ");
INSERT INTO cac_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Syic'anq'ue schiq'uil noc' vin̈ yed' yiximal sc'ab', stzicanb'at uqueloc vin̈ d'a stojolal in cajnub' b'aj tzin ch'ox in b'a. ");
INSERT INTO cac_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Slajvi chi', sn̈usjitz'a noc' vacax chi' smasanil d'a yichan̈ vin̈, stz'umal noc', sb'ac'chil noc', schiq'uil noc' yed' yol sc'ool noc'. ");
INSERT INTO cac_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Yacb'an van stz'a noc' chi' syic'anpaxq'ue te' c'ute' vin̈ sacerdote chi' yed' junoc sc'ab' te' hisopo yed' noc' chacchac lana, syac'anoch vin̈ smasanil d'a yol c'ac' b'aj van stz'a noc' chi'. ");
INSERT INTO cac_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Slajvi chi, sjuc'anel spichul vin̈, sb'icanpaxel sb'a vin̈, tz'ochxi vin̈ d'a yol campamento chi', vach'chom manto vach'oc yaj vin̈ icha yalan ley masanto d'a yemc'ualil. ");
INSERT INTO cac_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Axo vin̈ ix n̈usantz'a noc' vacax chi', sjuc'paxel spichul vin̈, sb'icanpaxel sb'a vin̈, palta manto vach'oc yaj vin̈ icha yalan ley masanto d'a yemc'ualil. ");
INSERT INTO cac_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Axo junocxo vin̈ vinac vach' yaj icha yalan ley, a' vin̈ smolanq'ue staan̈il noc' vacax chi', sic'anb'at vin̈ d'a junoc lugar to vach' yaj d'a spatiquel campamento. A juntzan̈ taan̈ chi' sc'an eb' eyetisraelal ayic sb'oan a a' eb' sc'anchaji yic sacb'itaj eb' icha yalan ley. Masanil juntzan̈ tic sc'ulaji yic syic'anel mul. ");
INSERT INTO cac_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","A mach ix molanq'ue juntzan̈ taan̈ chi', yovalil sjuq'uel spichul, sb'icanpaxel sb'a, palta manto vach'oc yaj icha yalan ley masanto d'a yemc'ualil. A jun ley tic scann̈ej d'a juneln̈ej, tz'och yopisio eyuuj a ex israel ex tic yed' yuj eb' ch'oc chon̈ab'il ayec' d'a e cal. ");
INSERT INTO cac_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","A mach syaman snivanil junoc chamnac, man̈ vach'oc yaj d'a uque' c'ual icha yalan ley. ");
INSERT INTO cac_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","A d'a schab'jial syaman junoc chamnac chi' yed' d'a svac'jial, yovalil sacb'itej sb'a yed' a a' sc'anchaji yic sacb'i icha yalan ley, ichato chi' vach' tz'ajcani. Tato max sacb'itej sb'a d'a schab'jial yed' d'a svac'jial, manto vach'oc syal chi'. ");
INSERT INTO cac_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Yuj chi' a junoc mach syaman junoc chamnac, tato max sacb'itej sb'a, a jun chi' syixtejel in cajnub'. Yuj chi' yovalil man̈xa yalan yic d'a e cal d'a juneln̈ej, yujto maj tzicjioch a a' chi' d'ay, yuj chi' man̈ vach'oc yaj icha yalan ley. ");
INSERT INTO cac_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Aton juntzan̈ sleyal tic d'a junoc mach scham b'aj ay scajnub': Yaln̈ej mach tz'och ta', ma junoc ayec' ta', man̈ vach'oc tz'ajcan d'a uque' c'ual. ");
INSERT INTO cac_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Masanil chen to man̈ vach'oc yaj smacji, man̈xo vach'oc tz'ajcani. ");
INSERT INTO cac_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Axo mach syaman junoc chamnac d'a stiel chon̈ab', taxon̈ej mac'b'ilchamoc, ma ton̈ej scham ichataxon tz'aj scham anima, mato syam sb'aquil junoc chamnac, ma junoc b'aj smucchaj eb' chamnac, a jun chi' man̈ vach'oc yaj d'a uque' c'ual. ");
INSERT INTO cac_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","A yuj masanil juntzan̈ chi' tz'ic'chajq'ue jab'oc staan̈il noc' vacax tz'anac yuj yic'anel mul, tz'ac'chajem d'a yol junoc yed'tal, tz'ac'jiem a a' d'a yib'an̈, aton a' sq'ueul sjaj. ");
INSERT INTO cac_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Axo junoc vin̈ vinac vach' yaj icha yalan ley, a vin̈ tz'ic'anq'ue junoc sc'ab' te' hisopo, slab'anem vin̈ d'a scal a a' chi', stzicanoch vin̈ d'a yib'an̈ jun cajnub' chi' yed' masanil tas ay d'a yool yed' d'a yib'an̈ eb' anima ayec' ta', an̈ejtona' stzicanpaxb'at vin̈ d'a yib'an̈ mach ix yaman sb'aquil chamnac, ma junoc b'aj smucchaj eb' chamnac chi', ma snivanil junoc anima mac'b'ilchamoc, ma junoc ton̈ej ix cham ichataxon tz'aj scham anima. ");
INSERT INTO cac_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","A jun anima vach' yaj chi', a' stzicanb'at a a' chi' d'a yib'an̈ eb' man̈ vach'oc yaj chi' d'a schab'jial yed' d'a svac'jial. Slajvi chi', a d'a svac'jial chi', sjuc'anel spichul eb', sb'icanpaxel sb'a eb' yic sacb'ican eb'. Icha chi' vach'xo tz'ajcan eb' d'a yemc'ualil. ");
INSERT INTO cac_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Tato ay junoc anima max sacb'itej sb'a icha yalan ley, man̈xaocab' yalan yic d'a e cal d'a juneln̈ej yujto syixtejb'at in cajnub'. Yujto maj tzicjioch a a' d'ay yic sacb'i, yuj chi' man̈ vach'ocn̈ej yaji. ");
INSERT INTO cac_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","A jun ley tic scann̈ej d'a juneln̈ej: A mach stzicanoch a a' chi' d'a junocxo, yovalil sjuq'uel spichul. A mach syaman a a' tz'ac'an sacb'oc junoc mach chi', vach'xo tz'ajcan d'a yemc'ualil. ");
INSERT INTO cac_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Masanil mach syamji yuj junoc anima man̈ vach'oc yaji, ma junoc syaman junoc anima man̈ vach'oc yaji, a jun chi' man̈ vach'oc tz'ajcan icha yalan ley masanto d'a yemc'ualil, xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","A d'a b'ab'el uj, ix c'och eb' israel d'a tz'inan luum scuch Zin. Ix aj eb' jun tiempoal d'a yol yic Cades. Ata' ix cham ix María yanab' vin̈aj Moisés, ix mucchajcanem ix ta'. ");
INSERT INTO cac_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Yujto te malaj a a' syuc' eb' israel chi', yuj chi' ix q'ue yav eb' smasanil d'a vin̈aj Moisés yed' d'a vin̈aj Aarón. ");
INSERT INTO cac_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ix yalan eb' d'a vin̈aj Moisés chi' icha tic: —Octom on̈ chamcan yed' eb' quetchon̈ab' ix chamcan yuj Jehová. ");
INSERT INTO cac_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","¿Tas yuj ix on̈ eyic'cot d'a taquin̈ luum tic? ¿Tom e gana tzon̈ champax a on̈ tic yed' noc' co molb'etzal noc'? ");
INSERT INTO cac_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","¿Tas yuj ix on̈ eyiq'uelta d'a yol yic Egipto, ix on̈ eyic'ancot d'a jun lugar man̈xo jantacoc schucal tic? A d'a tic max yac'laj ixim trigo, te' higo, te' uva, te' granado, malaj pax jab'oc a a' syal cuc'ani, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Ayic ix yab'an juntzan̈ lolonel chi' vin̈aj Moisés yed' vin̈aj Aarón chi', ix snitzanel sb'a eb' vin̈, ix b'at eb' vin̈ d'a sti' scajnub' Jehová. Ata' ix b'at em n̈ojan eb' vin̈ d'a sat luum. Axo d'a jun rato chi' ix sch'ox sb'a stziquiquial Jehová d'a slac'anil eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ix yalan Jehová chi' d'a vin̈aj Moisés chi' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","—Ic'b'at te' a c'ococh, tzalan d'a vin̈ uc'tac aj Aarón chi' to tz'och vin̈ ed'oc yic tze molanb'at eb' anima, tzex b'at b'aj ay jun q'uen nivan tenam. D'a yichan̈ eb' tzal d'a q'ueen to tz'elta a a' d'a sat q'ueen, axo d'a yichan̈ masanil eb' anima chi' ol elul a', ol yuc'an a' eb' yed' noc' smolb'etzal noc' chi', xchi Jehová. ");
INSERT INTO cac_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ix yic'anelta te c'ococh vin̈aj Moisés d'a yichan̈ Jehová icha ix aj yalani. ");
INSERT INTO cac_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Ix smolb'anb'at eb' anima chi' eb' vin̈ d'a yichan̈ q'uen tenam chi'. Ix yalan vin̈aj Moisés chi' d'a eb' icha tic: —Ab'ec, a ex to te pit ex tic: ¿Yovalil am val squiq'uelta a a' d'a sat q'uen tenam tic, scac'an a' eyuq'uej? xchi vin̈. ");
INSERT INTO cac_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ix lajvi yalan vin̈ icha chi', ix yic'anchaan̈ sc'ab' vin̈, ix spajanoch chael te' sc'ococh vin̈ d'a sat q'uen tenam chi', ix elul chulnaj a a' chi'. Ix yuc'an a' eb' yed' noc' smolb'etzal noc' chi'. ");
INSERT INTO cac_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ix lajvi chi', ix yalan Jehová d'a vin̈aj Moisés yed' d'a vin̈aj Aarón chi' icha tic: —Yujto a ex tic max in eyac' val och d'a e c'ool, maj e ch'ox d'a yichan̈ eb' eyetchon̈ab' tic to A inxon̈ej Ochi, yuj chi' man̈oc exlaj ol eyic'och eb' anima tic d'a sat lum luum chi' b'aj ix vala' to ol vac' d'ayex, xchi d'a eb' vin̈. ");
INSERT INTO cac_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Meriba ix sb'iejcan jun lugar chi', yujto ata' ix yalub'tan̈ej eb' israel d'a spatic Jehová. Ix sch'oxan Jehová chi' to Axon̈ej Ochi. ");
INSERT INTO cac_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Ayic ayec' vin̈aj Moisés d'a Cades, ix schecanb'at jayvan̈ eb' vin̈ vinac vin̈ d'a vin̈ sreyal Edom yic b'at yalan eb' vin̈ icha tic: A on̈ israel on̈ tic, ayto cuj co b'a ed'oc, scalb'at d'ayach: Ojtac jantac syail ix quil d'a Egipto. ");
INSERT INTO cac_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","An̈ejtona' ojtacpaxi tas aj sc'ochnaccan eb' co mam quicham ta' d'a peca'. Axo d'a slajvub'alxo tic, ix yac' val och yaelal eb' vin̈ aj Egipto chi' d'a yib'an̈ eb' co mam quicham yed' d'a quib'an̈. ");
INSERT INTO cac_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Yuj chi' ix co c'an scolval Jehová qued'oc. Ix yab' yel cav, yuj chi' ix yac'ancot yángel yic ix on̈ yic'anelta d'a Egipto chi'. A ticnaic ayon̈ ec' d'a chon̈ab' Cades b'aj ay smojonal a macb'en. ");
INSERT INTO cac_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Yuj chi' scal d'ayach, tope val tz'el d'a a c'ool tzon̈ a chaec' d'a yol a macb'en tic. Man̈ ol on̈ ec'laj d'a scal yavb'en eb' anima ay d'a yol a macb'en tic. Malaj a a' d'a eyuc'b'il a' ol cuq'uej. An̈ej d'a yol nivan b'e ol on̈ b'atoc. Malaj b'aj ol on̈ el b'esnaj d'a yol nivan b'e chi' masanto ol on̈ c'axpajec' d'a yol a nación tic, xchib'at vin̈aj Moisés chi'. ");
INSERT INTO cac_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ix tac'vi vin̈ sreyal Edom chi' icha tic: —Man̈ ex c'axpajec' d'a yol in nación tic. Tato ol ex ec' d'a yib'an̈, ol ex c'axpajec'oc, ol in elb'at d'a e patic yed' eb' in soldado, xchi vin̈ d'a eb'. ");
INSERT INTO cac_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ix yalanpax eb' israel chi' icha tic: —Maay, a on̈ tic an̈ej d'a yol nivan b'e ol on̈ b'atoc. Tato ay b'aj ol cuq'uej a a' yed' noc' co molb'etzal noc' d'a eyuc'lab'a, ol co tup d'ayach. An̈ej val to co gana tzon̈ c'axpajec' d'a a lugar tic d'a vach'il, xchib'at eb'. ");
INSERT INTO cac_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ix tac'vixi vin̈ sreyal Edom chi' icha tic: —Malaj permiso e c'axpajeq'ui, xchi vin̈. Ix b'at vin̈ yed' masanil eb' soldado smac eb' israel chi'. Yed'nac syamc'ab' eb' soldado chi' yic oval, te tec'anpax eb'. ");
INSERT INTO cac_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Yuj chi' ix say junxo b'e eb' israel b'aj ix b'ati. ");
INSERT INTO cac_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Masanil eb' israel ix el eb' d'a Cades, ix cot eb' d'a stojolal lum vitzal Hor d'a sat smojonal Edom. ");
INSERT INTO cac_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ata' ix yal Jehová d'a vin̈aj Moisés yuj vin̈aj Aarón icha tic: ");
INSERT INTO cac_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","A ticnaic, toxo ol cham vin̈aj Aarón, man̈ ol c'ochlaj vin̈ d'a sat lum ix vala' to ol vac' d'ayex, yujto a ex tic e chavan̈il ix e pitej e b'a d'a in checnab'il ix vac' d'ayex d'a sti' a' Meriba. ");
INSERT INTO cac_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","A ticnaic, ic'b'at vin̈aj Aarón chi' yed' vin̈ yuninal scuch Eleazar d'a jolom vitz Hor chi'. ");
INSERT INTO cac_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ata' ol iq'uel spichul vin̈aj Aarón chi' sc'an d'a sacerdoteal, tzac'ancanoch d'a vin̈aj Eleazar chi', yujto a vin̈aj Aarón chi' ol cham vin̈ ta', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Ix sc'anab'ajan vin̈aj Moisés tas ix yal Jehová chi', d'a val yichan̈ masanil anima ix ic'jib'at vin̈aj Aarón yed' vin̈aj Eleazar chi' yuj vin̈ d'a jolom vitz Hor chi'. ");
INSERT INTO cac_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ata' ix yiq'uel spichul vin̈aj Aarón chi' vin̈, ix yac'anoch vin̈ d'a vin̈aj Eleazar d'a jolom vitz chi'. Ata' ix chamcan vin̈aj Aarón chi'. Ix lajvi chi', ix emixta vin̈aj Moisés yed' vin̈aj Eleazar chi'. ");
INSERT INTO cac_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Axo ix yab'an masanil eb' israel to toxo ix cham vin̈aj Aarón chi', jun ujal ix och eb' d'a cusc'olal yuj vin̈. ");
INSERT INTO cac_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ayic ix yab'an vin̈ sreyal eb' cananeo ay d'a Arad d'a yol yic Neguev to van scot eb' israel d'a yol b'e sc'och d'a Atarim, ix elta vin̈ yac' oval yed' eb'. Ay eb' ix yamchaj yuj vin̈ ix yic'anb'at eb' vin̈ d'a preso. ");
INSERT INTO cac_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ix lajvi chi', ix yac'an sti' eb' israel d'a Jehová, ix yalan eb' icha tic: Tato ol ach colvaj qued'oc yic scac'an ganar jun nación chi', ol co satcanel junjun chon̈ab' d'a yol smacb'en chi' d'a juneln̈ej, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ix sc'anab'ajej Jehová scolvaj icha ix aj sc'anan eb' chi', yuj chi' ix yac' ganar eb' cananeo chi' eb'. Ix satcanel eb' cananeo chi' smasanil yed' schon̈ab'il, yuj chi' Horma ix sb'iejcan jun lugar chi'. ");
INSERT INTO cac_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ix el eb' israel d'a yich vitz Hor chi', ix ec' eb' d'a b'e tz'ec' d'a a' Chacchac Mar. Najat ix ec' yoy sb'a eb' yujto maj c'axpajec' eb' d'a lum Edom. Ayic ayoch eb' d'a yol b'e chi', ix chab'axq'ue sc'ool eb', ");
INSERT INTO cac_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ix cot yoval eb' d'a Dios yed' d'a vin̈aj Moisés. Ix yalan eb' icha tic: —¿Tas yuj ix on̈ iq'uelta d'a Egipto? ¿Tom yuj co cham yuj vejel d'a taquin̈ luum tic? Malaj tas sco va'a, malaj pax tas scuq'uej. Maxtzac techaj co vaan juntzan̈ chucal vael tic, xchi eb'. ");
INSERT INTO cac_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Yuj val chi' ix ac'jicot juntzan̈ noc' chan te ov yuj Jehová, yic schiji eb' anima chi' yuj noc'. Tzijtum eb' israel chi' ix cham yuj noc'. ");
INSERT INTO cac_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ayic ix yilan eb' icha chi', ix b'at yalan eb' d'a vin̈aj Moisés chi' icha tic: —Toxo ix och co mul a on̈ tic, ix cal chucal lolonel d'a Jehová yed' d'ayach. A ticnaic c'an d'a Jehová to syiq'uel noc' chan tic d'a co cal, xchi eb'. Ix sc'anan vin̈aj Moisés chi' d'a Jehová to syac' nivanc'olal d'a yib'an̈ eb' anima chi'. ");
INSERT INTO cac_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ix yalan Jehová chi' d'a vin̈ icha tic: —B'o junoc yechel chan d'a q'uen bronce icha yilji juntzan̈ noc' chi', tzac'anq'ue d'a schon junoc te te' chaan̈ steel, yic vach' ayic schiji eb' anima yuj noc' chan chi', tato sq'ue q'uelan eb' d'a jun yechel chan chi', maxtzac chamlaj eb' yuj noc', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ix sb'oan jun yechel chan nab'a bronce vin̈aj Moisés chi', ix yac'anq'ue vin̈ d'a schon jun te te'. Yuj chi' yaln̈ej mach schiji yuj noc' chan chi', sq'ue q'uelan eb' d'a jun yechel chan chi', sb'oxican eb'. ");
INSERT INTO cac_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Ix b'eyn̈ejcot eb' israel, ix javi eb' d'a Obot. ");
INSERT INTO cac_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ix elpax eb' d'a Obot chi', ix b'eyn̈ejcot eb' d'a yichan̈, ix javi eb' d'a Ije-abarim d'a tz'inan luum d'a stojolal b'aj sjavi c'u d'a yol yic Moab. ");
INSERT INTO cac_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ix cotn̈ej eb', ix javi eb' d'a jun a' eluma' scuch Zered. ");
INSERT INTO cac_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ix b'eyn̈ejcot eb', ix javi eb' d'a sc'axepalb'at jun a a' scuch Arnón. A jun a a' chi' tz'ec' d'a tz'inan lum d'a yol yic eb' amorreo. Aton jun a' chi' ayoch mojonal yuj eb' Moab yed' eb' amorreo chi'. ");
INSERT INTO cac_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Aton juntzan̈ lugar chi' sb'inaj b'aj tz'ib'ab'ilcan yab'ixal oval yic Jehová, b'aj syal icha tic: On̈ ec'ta d'a chon̈ab' Vaheb d'a yol yic Sufá, d'a yoltac a' Arnón. ");
INSERT INTO cac_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","A jun pac'an d'a stitac a a' chi' ayoch smojonaloc yic Moab, sc'och d'a chon̈ab' Ar, xchi. ");
INSERT INTO cac_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Ix el eb' d'a a' Arnón chi', ix cotn̈ej eb' masanto ix javi eb' d'a Beer. Aton ta' ay jun a' uc'b'ila' b'aj ix yal Jehová d'a vin̈aj Moisés icha tic: Molb'ej masanil anima, a in ol vac' a a' yuq'uej eb', xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Aton d'a jun tiempoal chi' ix b'itan eb' israel icha tic: Ix q'ueul a a' b'aj molan. Q'ueocab'cot b'urnaj a a'. To ol on̈ b'itanec yuj a a' ix q'ueul b'urnaj tic. ");
INSERT INTO cac_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","A eb' vin̈ yajal ix joyanq'ueta a' yed' sc'ococh. A eb' vin̈ nivac yajal d'a yol schon̈ab', a yed' sc'ococh eb' vin̈ ix sjacq'ueta a a', xchi eb' d'a sb'it chi'. Ix b'eyn̈ejcot eb' d'a tz'inan luum masanto ix javi eb' d'a Matana. ");
INSERT INTO cac_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Ix el eb' d'a Matana chi', ix javi eb' d'a Nahaliel. Ix el eb' d'a Nahaliel chi', ix javi eb' d'a Bamot. ");
INSERT INTO cac_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Ix el eb' d'a Bamot chi', ix javi eb' d'a jun ch'olan ay d'a yol yic Moab, d'a stojolal lum nivac vitz d'a yol yic Pisga, aton ta' nivan chequel lum tz'inan luum. ");
INSERT INTO cac_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Ix yac'b'at schecab' eb' israel d'a vin̈aj Sehón sreyal eb' amorreo, ix yalanb'at eb' icha tic: ");
INSERT INTO cac_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","¿Tom max on̈ a chaec' d'a yol a macb'en? Malaj jab'oc tas ol ec' co lob'at d'a scal eyavb'en yed' d'a scal eyuva, man̈ ol cuc' a a' d'a eyuc'b'il a', an̈ej d'a yol nivan b'e ol on̈ ec'oc, xchi eb' checab' chi'. ");
INSERT INTO cac_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Maj scha sc'ol vin̈aj Sehón chi' yec' eb' israel d'a yol smacb'en chi'. An̈ej to ix smolb'ej masanil eb' soldado vin̈, ix elta vin̈ yac' oval yed' eb' d'a tz'inan luum, d'a Jahaza ix yac' oval eb'. ");
INSERT INTO cac_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ix yac'an oval eb' israel chi' yed' eb', ix ac'ji ganar vin̈aj Sehón yed' eb' soldado yuj eb'. Ix ic'jiec' lum sluum eb' chi' yuj eb' israel chi'. Sb'atn̈ej d'a sti' a' Arnón, masanto sc'och d'a sti' a' Jaboc, masanto b'aj tz'ec' smojonal sluum eb' amonita. A jun luum chi' te vach' yaj smacchaj yuj eb' amonita chi'. ");
INSERT INTO cac_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Icha chi' ix aj yochcan slum eb' amorreo yicoc eb' israel chi'. Ix cajnaj eb' israel d'a chon̈ab' Hesbón yed' d'a juntzan̈xo chon̈ab' ay d'a spatictac. ");
INSERT INTO cac_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","A Hesbón chi', aton jun chon̈ab' b'aj ec'nac vin̈aj Sehón sreyal eb' amorreo. A vin̈aj Sehón chi' ix yac'n̈ej oval vin̈ yed' eb' vin̈ sreyal Moab d'a yalan̈taxo. Ix ic'jiec' jun macan̈ slum eb' yuj vin̈ sc'ochn̈ej d'a a' Arnón. ");
INSERT INTO cac_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Yuj chi' ix yal eb' slolon d'a poesía icha tic: Cotan̈ec d'a Hesbón, aton d'a schon̈ab' vin̈aj rey Sehón. B'oecxiq'ue d'a schaelal, vach' tzeyutej e b'oanoch smuroal. ");
INSERT INTO cac_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Ato d'a Hesbón, d'a schon̈ab' vin̈aj rey Sehón ix cot eb' ix n̈usantz'a chon̈ab' Ar d'a yol yic Moab yed' eb' nivac yajal yaj d'a jun chon̈ab' d'a pac'an d'a yib'an̈q'ue a' Arnón. ");
INSERT INTO cac_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ex aj Moab, ob'iltac ex. Toxo ix ex lajviel ex schon̈ab' dios Quemos. Aton jun e diosal chi' maj yal-laj scolvaji, yuj chi' ix el lemnaj eb' soldado smasanil, axon̈ej eb' ix ix, ix can d'a yol sc'ab' vin̈aj rey Sehón. ");
INSERT INTO cac_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Toxo ix lajviel yipalil chon̈ab' Hesbón. Ix satel eb' ay d'a chon̈ab' Dibón masanto ix satel eb' ay d'a Nofa yed' pax Medeba, xchi jun poesía chi'. ");
INSERT INTO cac_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Icha chi' ix aj yic'ancan lum luum eb' israel macb'il yuj eb' amorreo. ");
INSERT INTO cac_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Ix lajvi chi' ix yac'anb'at schecab' vin̈aj Moisés d'a chon̈ab' Jazer yic sb'eytzitej eb' tas yaji. Ix ac'ji ganar jun chon̈ab' chi' yuj eb' israel yed' masanil juntzan̈ chon̈ab' ay d'a spatictac. Ix pechjiel masanil eb' cajan ta' yuj eb', aton eb' amorreo. ");
INSERT INTO cac_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ix meltzaj eb', ix b'at eb' d'a stojolal lum Basán, palta ix elta vin̈aj Og sreyal Basán chi' yed' masanil eb' soldado yac' oval yed' eb' d'a Edrei. ");
INSERT INTO cac_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Yuj chi' ix yal Jehová d'a vin̈aj Moisés chi' icha tic: Man̈ ex xiv d'a vin̈aj Og chi', a in ol vac'och vin̈ yed' eb' soldado yed' smacb'en tic d'a yol e c'ab'. Icha ix eyutej vin̈aj Sehón sreyal eb' amorreo ay d'a Hesbón, icha chi' ol eyutejpax vin̈aj Og tic, xchi d'a vin̈. ");
INSERT INTO cac_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Icha chi' ix aj scham vin̈aj Og yed' yuninal yed' masanil eb' soldado yuj eb' israel, man̈xo junoc eb' ix cani. Ix ochcan sluum eb' yicoc eb' israel chi'. ");
INSERT INTO cac_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Ix lajvi chi', ix b'eyn̈ejcot eb' israel chi', i