﻿USE sofia;
DROP TABLE IF EXISTS sofia.cabNT_vpl;
CREATE TABLE cabNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cabNT_vpl WRITE;
INSERT INTO cabNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Niján jíri linébaanfaangu Jesucrístu le jádaangiñebei meja ladǘgawagun Davíd lúma Abrahám. ");
INSERT INTO cabNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahám lúguchibei Isáac, Isáac lúguchi Jacób, Jacób lúguchi Judá jáu lamúlenu, ");
INSERT INTO cabNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá lúguchi Fáres lúma Zára, Támar tugúya jáguchu, Fáres lúguchi Esróm, Esróm lúguchi Arám, ");
INSERT INTO cabNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arám lúguchi Aminadáb, Aminadáb lúguchi Naasón, Naasón lúguchi Salmón, ");
INSERT INTO cabNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón lúguchi Booz, Raháb lúguchu, Booz lúguchi Óbed, Rut lúguchu, Óbed lúguchi Isaí, ");
INSERT INTO cabNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí lúguchi urúei Davíd, urúei Davíd túma tó meja lúmari Urías, jagía lagǘbürigubaña Salomón. ");
INSERT INTO cabNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón lúguchibei Roboám, Roboám lúguchi Abías, Abías lúguchi Ása, ");
INSERT INTO cabNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ása lúguchi Josafát, Josafát lúguchi Jorám, Jorám lúguchi Uzías, ");
INSERT INTO cabNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías lúguchi Jótam, Jótam lúguchi Ácaz, Ácaz lúguchi Ezequías, ");
INSERT INTO cabNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías lúguchi Manasés, Manasés lúguchi Amón, Amón lúguchi Josías, ");
INSERT INTO cabNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías lúguchi Jeconías jáu lamúlenu lídan dan le janáanwagunbei Israelítagu adáürawagua Babilónia. ");
INSERT INTO cabNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Lárigiñe le, Jeconías lúguchibei Salatiél, Salatiél lúguchi Zorobabél, ");
INSERT INTO cabNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabél lúguchi Abiúd, Abiúd lúguchi Eliaquím, Eliaquím lúguchi Azór, ");
INSERT INTO cabNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azór lúguchi Sadóc, Sadóc lúguchi Aquím, Aquím lúguchi Eliúd, ");
INSERT INTO cabNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliúd lúguchi Eleázar, Eleázar lúguchi Matán, Matán lúguchi Jacób, ");
INSERT INTO cabNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacób lúguchi José le túmari María, tugúyati lúguchuboun Jesúsu le gíribei Crístu. ");
INSERT INTO cabNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Catoúrusuñanu lubeíti linébaanfaangu Jesúsu lúmagiñe Abrahám lúmoun Davíd, catoúrusu lúmagiñe Davíd lúmoun janáanwagúniwa Israelítagu Babilónioun, catoúrusu lúmagiñe dan ligía lúmoun lagǘriajoún Crístu. ");
INSERT INTO cabNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ítara líña ligáburi lagǘriajoún Jesucrístu. María to lúguchu, gadáraduñoun lúma José lun tamárieidun lúma, lubáragiñeti jaganoún jámagua, lubáragiñe lasúbudirunun quei wǘri, ába tadáriragun túngua láu dagáñu tíña lan láu lubáfu Sífiri Sándu. ");
INSERT INTO cabNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Quei ában lubeí wügǘri buídu tigáburi José le tadári, májati lasúbudirúniwa le asúseredubei tun María, busénrügüti lígirunun, míchugunga tidúnrun. ");
INSERT INTO cabNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dan le niján lubeí arítagua luágu cátei le, ligía larúfudagun ában láni Wabúreme Búngiu ánjeli lúngua lun lídan luwénedi, ába laríñagun lun. —José, ladǘgawagun Davíd, manúfudebá lun berésibirunun María queísi búmari, ladǘga irájü le lúnbei tagáraüduni, lúmagiñe Sífiri Sándu liábin. ");
INSERT INTO cabNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tagáraüduba ában irájü, ábame bíchuguni líri Jesúsu. Ítara lúba líri ladǘga lasálbarubaña lan lumútuniña lídaangiñe jafígoun. ");
INSERT INTO cabNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Lasúseredunbei sun cátei le lun lagúnfulirun dimúrei le laríñagubei Wabúreme Búngiu liyúmulugugiñe proféta. ");
INSERT INTO cabNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tadágeinaduba ában irájü, ábame tagáraüdun ában irájü, Emanuél, ligíaba líri, líla íri ligía, “Búngiu wáma”. ");
INSERT INTO cabNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Dan le lagágudunbei José lídaangiñe uwénedi ligía, ába ladǘgüni le lubeíbei ánjeli ligía lun, ába lerésibirunun María queísi lúmari, ");
INSERT INTO cabNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","masúbudirúngaloún queísi wǘri darí tagǘriajani furúmiñeti tiraǘ, ába líchuguni líri Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Lídan fulásu le gíribei Belén, lumúanrugu Judéa, ñi lagǘriajoúa Jesúsu dán meja le Heródes lan urúeibei lídan jageíra juríu. Ábati jachǘlürün fiú wügǘriña chu táu ubúrugun Jerusalén lueígiñe oúbaü le ñígiñe lubeí laboúcha wéyu. ");
INSERT INTO cabNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ába jálügüdajan. —¿Jageísan jarúeite juríu le agǘriajoúbei? Aríja wamáaru luwáruguman le ñígiñe lubeí láfuara wéyu, wayábiñati lun wájuduragun lun. ");
INSERT INTO cabNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Dan le lagáambuni urúei Heródes cátei le, ába medéraguagüdünjaali lan, jáu sun Jerusalénna. ");
INSERT INTO cabNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ábati lagúarun joun sun jábutigu fádirigu lídan jafíñen juríu, jáma ja arúfudajabalin lilúrudun Moisés joun gürígia, ába lálügüdaguniña jalíabei lan libíti fulásu lagǘriajoúa Crístu. ");
INSERT INTO cabNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ába jaríñagun lun. —Belén, le lumúanrugubei Judéa, ladǘga ítara líña labǘrüdüni proféta. ");
INSERT INTO cabNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Amǘrü Belén, lumúanruguna Judéa, amǘrü ában lídaangiñe ubúrugu weírigutimaati lídan múa le, láu sun biñǘraü, ladǘga láfuriduba ában ábuti bídaangiñe le lúnbei loúnigiruniña numútuniña ja Israelítagu. ");
INSERT INTO cabNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ábati lagúarun Heródes joun chu táu arámudaguarügü, ába lálügüdüniña luágutima dan le tarúfudaguagüle warúguma túngua joun. ");
INSERT INTO cabNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ábati loúnajaniña Belén, laríñaga joun. —Jeíba, ábame jáluajani irájü le buídu, dánme le darí jumaali, jawísaraname, ñǘdün námuga gíñe ájuduragua lun. ");
INSERT INTO cabNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Lárigiñe jagáambuni chu táu lerérun urúei, ába joúdin. Warúguma bugáti to jaríjuboun le ñígiñe lubeí láfuara wéyu, ába tídin jabá jabá, darí taráramun loúgiñe fulásu le ñí lubei irájü le. ");
INSERT INTO cabNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Dan le jaríjinun chu táu ja warúguma, ába jagúndaaragun sarágu. ");
INSERT INTO cabNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dánti le jebélurun tídoun múna, ába jaríjini irájü le túma lúguchu to María. Ábati jájuduragun, ába jabúluchagun lun. Ába jánjunrenchunun jagáfun, ába jedéweejan gólu lúma cupáli jémeti lun, lúma ában luwúyeri árani gífiti. ");
INSERT INTO cabNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Lárigiñe, ába jawísarúniwa lídan jawénedi lun magíribudun jamá ñígiñe lubeí Heródes, ába jagíribudun jageíroun lídaangiñe ámu ǘma. ");
INSERT INTO cabNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Lárigiñe joúdin chu táu jagía, ába larúfudagun ába láni Búngiu ánjeli lúngua lun José lídan luwénedi, ába laríñagun lun. —Sarába, barǘbei irájü le táu sun lúguchu, anúrabá Ejíptoun, ábame beréderun ñi daríme nawísarunibu, ladǘga láluajaali Heródes irájü le lun láfaruni jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ábati lásaarun José, ába lanǘgüni irájü táu sun lúguchu áriebu ligía, ába lídin jáu Ejíptoun. ");
INSERT INTO cabNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ába jeréderun ñi darí loúnwen Heródes. Lasúseredunbei sun le lun lagúnfulirun le laríñagubei Búngiu liyúmulugugiñe proféta. “Sagá numuti Niraǘ Ejíptogiñe.” ");
INSERT INTO cabNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Dan le ladáriragun Heródes lúngua luágu yéegua jamá lan chu táu, ába lagáñidun, ába loúnajan áfaraguaña sun irájüñü ja biáma tíña irúmu jáu lun ǘnabun, ja aganoúbaña Belén lúma sun fulásu geyégua láu, según dan le jaríñagubei chu táu luágu lagǘriajoúniwa irájü ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ítara líña lagúnfulirun le labǘrüjabei proféta Jeremías. ");
INSERT INTO cabNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Agaambúati lagúarajan ában umálali Ramá láu oúnwenbun igárigu, umálali ligía tumálali Raquél, to ayájuboun járigi tirájüñü, mabúseeruntu lun támalijoún ladǘga jilágua jamá. ");
INSERT INTO cabNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Lárigiñe loúnwen Heródes, ába liábin ába láni Búngiu ánjeli lun José lídan luwénedi yágüta Ejípto, ába laríñagun lun. ");
INSERT INTO cabNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Sarába, barǘbei irájü le táu sun lúguchu, giríbu jumá jageíroun Israelítagu ladǘga jilágua ja abúseerubaña meja jáfaruni irájü le. ");
INSERT INTO cabNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ába lásaarun José, ába lanǘgüni irájü táu sun lúguchu jageíroun Israelítagu. ");
INSERT INTO cabNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Dan le lasúbudiruni José luágu Arqueláo lan agúmadijabei Judéa lewéñegua Heródes le lúguchi, ába lanúfudedun lídin ñíjin, ába laríñawagúniwa lun lídan uwénedi lun lídin Galiléoun. ");
INSERT INTO cabNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Lachǘlürün ñi, ába lídin agánawa lídan fulásu le gíribei Nazarét, le lumúanrugubei Galiléa. Lasúseredunbei sun cátei le lun lagúnfulirun le jaríñagubei profétagu luágu Nazarétna lan Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lídoun dan ligía, ába liábin Juan le abásteragüdajabei apúrichija lídan fulásu mageírawati, Judéa, ");
INSERT INTO cabNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ába laríñagun lídan lapúrichijan. —Sáansi jumeí joúserun, ladǘga yaráfaali larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan le, ligía le uágubei meja labǘrüja proféta Isaías ítara. Agaambúati lumálali ában gürígia agúaraja lídan fulásu mageírawati ítara. “Aráanse jumoún janígi lubá liábin Wabúreme, queísi ladárarúniwa ǘma surúti.” ");
INSERT INTO cabNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Lanáangun Juan, láutu lúra caméyu, liábin lagǘrüga liránaagua, guéru, chigángaru leígubaña lúma síruudu le áraabuna. ");
INSERT INTO cabNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ábaja jayábin ubúrugugiñe Jerusalén, lúma Judéagiñe, lúma lubádugiñe dúna Jordán agáambei lapúrichijan, ");
INSERT INTO cabNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","dántija le jagúfeseruni jafígoun, ába labásteragüdüniña lídan dúna le gíribei Jordán. ");
INSERT INTO cabNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Dan le laríjin Juan luágu sarágu jáña lan gürígia lídaangiñetiña jadámurin fariséogu jáma saduséogu ñǘbintiña lun jabásterun, ába laríñagun joun. —¡Jarásan jéwe jugúya le! ¿Ca awísarubadün lun janúrajan lueí lanárime afáyeiragülei luágu figoú le lúnbei liábin? ");
INSERT INTO cabNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Oúsera jumá buídu, arijúa lámuga furáangu luágu sáansigua lan ligáburi joúserun. ");
INSERT INTO cabNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mapántajan jugúyame, aríñaga jídaangua. “Linébaanfaangu Abrahám wagía”, ladǘga naríñajare jun luágu gayára lan ladǘgün Búngiu linébaanfaangu Abrahám lídaangiñe dǘbü le. ");
INSERT INTO cabNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Madíseeli lagúnfulirun le laríñagubei Búngiu, luágu yaráfaali lan lidáani abeichúni luágu figoú, aráanseeru jaráwa lun lánchuajoún wéwe, áni sun wéwe le mabuídunti lin, chaǘnwati, ába lagudún. ");
INSERT INTO cabNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Áu, láu dúna nabásteragüdaün, arúfudei luágu sáansi jumáali lan ligáburi joúserun, ánjeinti le lúnbei liábin nárigi, labásteragüdübadün láu Sífiri Sándu, áni lafáyeiragüdübadün luágu figoú queísi láu wátu geméti. Gabáfuti nueí darí lun madǘna nan ni lun narágachunun ligeídin. ");
INSERT INTO cabNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nújeinjaru lichóbulin lújaburugu, larúmadagüdübei türígu, ábame lanúadiruni lídaangiñe sagádi mábeijali. Ábame lareíduni türígu, ábame láguduni sagádi le mábeijali lídan wátu geméti le méñeguchadibei. ");
INSERT INTO cabNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Dan le liábin Jesúsu Galiléagiñe, ába lachǘlürün luágun dúna le gíribei Jordán le ñí lubei Juan lun labásteragüdüni. ");
INSERT INTO cabNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Májati yebéti Juan labásteragüdüni, ába laríñagun lun Jesúsu. —Nugúya lúnbei babásteragüdünina, ¿amǘrü lubeí ñǘbin nun lun nabásteragüdünibu? ");
INSERT INTO cabNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ába laríñagun Jesúsu lun. —Ítara lúba guetó, ladǘga lúnti wadǘgüni le lubeíbei Búngiu. Ába labásteragüdüni Juan Jesúsu, ");
INSERT INTO cabNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","lárigiñe labásterun Jesúsu, ába láfuridun dúnarugugiñe. Sódini ába lánjunrenchagun siélu, ába laríjini Jesúsu Sífiri Sándu larárirun camá ában únjun liábin luágun. ");
INSERT INTO cabNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ába lagaambún ába umálali siélugiñe le aríñagubei. —Niraǘ le jínsiñebei nun le, le áubei oúnwenbun lan nugúndan. ");
INSERT INTO cabNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ába lanǘgüni Sífiri Sándu Jesúsu lídoun fulásu mageírawati lun loúchaguni Máfia. ");
INSERT INTO cabNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Lárigiñe leréderun Jesúsu bián-wein wéyu lúma bián-wein áriebu meíginga, ába lalámachun. ");
INSERT INTO cabNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ábati liábin Máfia lubádun, ába laríñagun lun lun loúchaguni. —Ánjein liraǘ bubei Búngiu, salíguagüdabeí dǘbü le feínme. ");
INSERT INTO cabNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ába loúnabun Jesúsu. —Taríñajare Lerérun Búngiu. “Mámarügübei táu fein labágarida gürígia, labágariduba gíñe láu sun dimúrei le laríñagubei Búngiu.” ");
INSERT INTO cabNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ábati lanǘgüni Máfia Jesúsu Jerusaléoun, ubúrugu le sándubei joun juríu, ába laweínragüdüni tábulugun témpulu, ");
INSERT INTO cabNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ába laríñagun lun. —Ánjein liraǘ bubei Búngiu, chubába yágiñe lun ǘnabun, ladǘga taríñajare Lerérun Búngiu. Laríñaguba Búngiu joun láni ánjeligu lun joúnigirunibu. Janǘgübadibu jájaburugu lun machúgeragun lan bugúdi luágu dǘbü. ");
INSERT INTO cabNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ába loúnabuni Jesúsu. —Aríñagatu gíñe Lerérun Búngiu. “Moúchaguabeí Babúreme Búngiu.” ");
INSERT INTO cabNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ába lanǘgüni Máfia Jesúsu luágun ában wǘbü íñuti, ába larúfuduni sun arúeijani le uboúagubei lun, lúma buri luweírigun, ");
INSERT INTO cabNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ába laríñagun lun. —Níchugubei sun le bun ánjabu ájuduragua nun. ");
INSERT INTO cabNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ábati laríñagun Jesúsu lun. —¡Beíba nueí, Máfia! ladǘga taríñajare Lerérun Búngiu. “Lúnrügüba Babúreme Búngiu bájuduragua, lúnrügüba gíñe besériwida.” ");
INSERT INTO cabNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ábati ladísedun Máfia lueí, ába jayábin ánjeligu esériwidei. ");
INSERT INTO cabNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dan le lagáambunbei Jesúsu luágu níjein lan Juan furísunrugu, ába lídin lárigoún Galiléoun. ");
INSERT INTO cabNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Merédeti Nazarét, ába lídin agánawa Capernaúm, ában fulásu le lárubei dúna lídan jageíra rása le Zabulón lúma Neftalí. ");
INSERT INTO cabNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Lasúseredunbei sun le lun lagúnfulirun le labǘrüjabeí meja Isaías, lé meja proféta. ");
INSERT INTO cabNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Lageíra Zabulón lúma Neftalí, lídan ǘma lubádu barána, lueígiñe oúbaü le ñígiñe lubeí láfuara wéyu libíti Jordán, Galiléa le ñí lubei jagánawa ja mámabaña juríu. ");
INSERT INTO cabNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Jugúya lé meja lídaanbei lubúriga aríjaadün ában oúnwenbun larúgounga, jugúya lé meja lídaanbei lamúñounga le lánina oúweni, jarúgoungagüdawaali jáu. ");
INSERT INTO cabNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Lúmagiñe dan ligía, ába lagúmeserun Jesúsu apúrichija ñi ítara. —Sáansi jumeí jigáburi, ladǘga yaráfaali larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Eíbugeina líña Jesúsu láru láru dúna Galiléa, ligía laríjin bián gamúlenuguátiña, ában jádaangiñe, Simón le méme gíribei Pédro, le ában, Andrés. Esénijani jabágaribei, jáguruñati. ");
INSERT INTO cabNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ábati laríñagun Jesúsu joun. —Falá jumana, ábame mesénijanjadün lan úduraü, anáajarügaadünme gürígia nun lun nánigume. ");
INSERT INTO cabNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Furése furése ába jígirunun jasénin, ába joúdin lúma. ");
INSERT INTO cabNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Lubáruaguoun mémeraü Jesúsu, ábaya laríjin bián gamúlenuguátiña, Jacóbo lúma Juan, lirájüñü Zebedéo. Tídaañanu ában ugúnein lúma jáguchi arámadajoun jasénin. Ába lagúarun Jesúsu joun lun lánime disípulugu, ");
INSERT INTO cabNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","lídan óra ligía ába jígirunun ugúnein, ígira jáguchi, ába joúdin lúma Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ábajei leíbuguni Jesúsu sun Galiléa arúfudajeina tídan buri jalígilisin juríu to lídaanboun ságü fulásu. Ábaja lapúrichijani ugánu buíti luágu larúeijan Búngiu, areídaguagüda ligía sun luwúyeri sándi le jawáguti gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ába lagaambúniwa luágu Jesúsu lídan sun Síria, ába janǘgüniña sun ja asúfurirubaña láu ámuñegueinarügü sándi, igárigu, ja gawágubaña lagǘbüri espíritu, ja goúwejadibaña, jáma ja derégüdaaña úgubu, ába lareídaguagüdüniña. ");
INSERT INTO cabNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Sarágu jáña gürígia afálaruti Galiléagiñe, lídaangiñé buri fulásu Decápolisna, Jerusaléngiñe, loúbawagugiñe Judéa, lúma lueígiñe oúbaü le ñígiñe lubeí laboúcha wéyu libíti Jordán. ");
INSERT INTO cabNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Dan le laríjinbaliña Jesúsu sun gürígia jagía, ába laweínrun luágun ában wǘbü, ába lañúurun ñi. Ábati joúndaragun láni disípulugu geyégua láu, ");
INSERT INTO cabNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ába lagúmeserun arúfudaja joun ítara. ");
INSERT INTO cabNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Fuleíseiwatün jugúya le asúbudirubalin luágu mégei jumáni lídejan Búngiu lun jadǘgüni le labúseerubei, ladǘga méreengunbei jun lun jebélurun lídoun larúeijan Búngiu siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","‘Fuleíseiwatün jugúya le jírubei, ladǘga líchuguba Búngiu gurásu jun. ");
INSERT INTO cabNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","‘Fuleíseiwatün jugúya le ǘnabugubei, ladǘga jerésibirubei le uágubei laríñaga Búngiu luágu líchugubei lan jun. ");
INSERT INTO cabNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","‘Fuleíseiwatün jugúya le weíribei jabúseerun lúaradagun jabágaridun, ladǘga líderagubadün Búngiu lun jadǘgüni. ");
INSERT INTO cabNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","‘Fuleíseiwatün jugúya le gudémejabubei, ladǘga gudémebadün gíñe lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","‘Fuleíseiwatün jugúya le jarúmabei anígi, ladǘga jaríjubei Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","‘Fuleíseiwatün jugúya le áfaagubei lun jámalijan sun cátei, ladǘga lagúarubadün Búngiu queísi lirájüñü. ");
INSERT INTO cabNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","‘Fuleíseiwatün jugúya le asúfurirubei eíbaajoúni luágu lúaragun jibágari, ladǘga jebéluruba lídoun larúeijan Búngiu siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","‘Fuleíseiwatün dan le janábagunün gürígia, eíbaaja jamaǘn, aríñaga jagía sun luwúyeri iyéeni juágu, nueígiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gúndaañu jumá, ladǘga jerésibiruba ában oúnwenbun fáyeiti siélu, ítara liñá meja gíñe jeíbaajoúniwa profétagu ja ñǘbinbaña jubáragiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ába lasígirun Jesúsu aríñaga. —Ítara jíña quei sálu joun lílana uboú le lun jeréderuniña lueí jagádeirun, ánjein leféridira sálu lubásuan, ¿cábagi un ju lan? Úaalime ju lan ni ca un lueídügüya lun lágurúniwa, ábame jadǘgüraguni gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‘Ítara jíña quei lámpu joun lílana uboú le. Ában ubúrugu le luáguti ában wǘbü siñáti larámudagun, furáanguti larijoúniwa. ");
INSERT INTO cabNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mebedúnti gíñe ában lámpu lun líchugúniwa tábugiñe ában gáfu, luágu dábula líchugúa lun larúgoungadágüdün jáu sun ja múnadabaña. ");
INSERT INTO cabNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ítara jumá gíñe, durúnguagüda jumeí jilámpun jádan gürígia, lun dánme lan jaríjini buíti le jadǘgübei, ábame gíñe jadímurejan buíti luágu Wáguchi Búngiu le siélubei. ");
INSERT INTO cabNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","‘Marítagua jumátia luágu niábiña lan agídarei lilúrudun Moisés, ni le jarúfudajabei profétagu, máma niábiña agídarei, niábiña arúfudei líla le tímatimaati. ");
INSERT INTO cabNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ninárün lubeíti jáu luágu níjeingua rügáali ligía lan siélu lúma uboú, magídarúnwabei ni ában púntu, ni ában létüra lídaangiñe lilúrudun Moisés daríme suséreeli le lúnbei lasúseredun. ");
INSERT INTO cabNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ligía, le lubeí íchuguti mebéreseni luágu furúmierügü gumádi lídaangiñe lúrudu, íbini le lan ñǘraütimaabei lídaangiñe, arúfudaja ligía joun gürígia lun jadǘgüni líbe le ladǘgübei, ñǘraüraübei lanügǘniwa yágüta siélu lídan larúeijan Búngiu. Ánjeinti le ñǘdünbei láu sún buri gumádi lídan lúaragun, ítara gíñe larúfudajan, weíribei lanügǘniwa yágüta siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Naríñajare jun luágu ánjein lan mabuídun ligáburi joúserun sarágu weíyaasu jaweí arúfudajatiña lilúrudun Moisés, jáma fariséogu, mebélubadün lídoun larúeijan Búngiu siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‘Agáamba jumáali luágu aríñawagúa lán meja joun binádu jagǘbürigu lun máfarajan jamá, ladǘga furúmieguarügü lan le áfarajati, lagúseragüdǘwaba. ");
INSERT INTO cabNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Wel, naríñajare jun luágu furúmieguarügü lan le agáñiduti lúma gürígia líledi lagúseragüdǘwaba. Le anábuti gürígia líledi lagúseragüdǘbei luweírin-ágei lúrudu, le aríñaguti lun gürígia líledi, “ibídiougua táu”, luáguñein ǘma lun máfiougatin. ");
INSERT INTO cabNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ítara líña lubeíti, ánjein banǘga bedéweejan luágun láni Búngiu latárü, báu ñi ába barítaguni luágu níjein lan cátei lídan furúmieguarügü gürígia bubá, ");
INSERT INTO cabNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ígirabeí le lúnbei bedéweejani ñi ligíbugiñe latárü, ábame bídin aráandara lúma gürígia ligía. Lárigiñemeti, gayáraajalíme bagíribudun luágun latárü íchigei bedéweejan. ");
INSERT INTO cabNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‘Ánjein abúseera ában gürígia lanǘgünibu ligíbugiñoun lúrudu, belúba lídoun úarani lúma luágu jeíbuguniwagu lueí ledéregerunibu lun agúseragüdüti, ledéregerabume agúseragüdüti lun polisía, ábame badaürǘn. ");
INSERT INTO cabNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ninárün báu, máfuridunbadibu ñígiñe darí bafáyeiruni lagúmujoún gáwanün. ");
INSERT INTO cabNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘Agáambaadün luágu aríñawagúa lán meja. “Magámarida jumá jámari ámu, adultériu líra.” ");
INSERT INTO cabNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Áu naríñajare jun luágu furúmieguarügü lan le awámadirutu ában wǘri, adǘgaali adultériu túma tídan lanígi. ");
INSERT INTO cabNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","‘Ánjabu lubeíti lafígoungüda bágu le lueígiñebei boúnwenren, sagábei, fíbei díse, buítimaati lun beféridirun ában lídaangiñe umégeguni le buágubei sügǘ láu bídin láu sun búgubu máfiougatin. ");
INSERT INTO cabNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ánjein bújabu lubeí le boúnwenren afígoungüdübadibu, dürǘbei, fíbei díse, buítimaati lun leféridirún ában lídaangiñe umégeguni le buágubei sügǘ láu bídin láu sun búgubu máfiougatin. ");
INSERT INTO cabNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‘Aríñawagúati meja gíñe luágu furúmieguarügü lan le ígirutu lúmari lúnti líchugun gárada lánina ígiraguni tun. ");
INSERT INTO cabNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Áu naríñajare jun luágu furúmieguarügü lan wügǘri ígirutu lúmari, ánjein máma lubeí ladǘga tagámaridun ligíbuagun, ába taganoún lúma ámu wügǘri, adǘgagüda lumútu furúmiñeti wügǘri adultériu. Le gíñe agámaridutu wǘri ígiraguaaru ladǘgüña gíñe adultériu. ");
INSERT INTO cabNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‘Agáambaadün gíñe luágu aríñawagúa lán meja joun binádu agǘbürigu lun jagúnfulirun láu le jaríñagubei láu áfiñuruni ligíbugiñe Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Áu naríñajare jun luágu moún lumuti lan jáfiñurun ni ca uágu—ni luágu siélu ladǘga ñi lan lañúura Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni luágu múa ladǘga ñi lan líchigei Búngiu lugúdi, ni luágu Jerusalén ladǘga ligía lubúrugutebei Warúeite Búngiu le weírigubei, ");
INSERT INTO cabNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ni luágu jichǘgü ladǘga siñáti ni jájarudagüdün ni jáuridagüdün ában ídiburi. ");
INSERT INTO cabNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aríñagarügü jumá “ánja” o “uá”, máfiñurunga ni ca uágu, ámu cátei lueí líra lúmagiñeti Máfia. ");
INSERT INTO cabNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘Agáambaadün luágu aríñawagúa lán meja. “Águu luágu águu, ári luágu ári.” ");
INSERT INTO cabNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Áu naríñajare jun lun máguyugüdün jumá wuríbani luágu wuríbani, lubáragiñe líra, ánjein íchiga mútu agúfudein luágu ában loúba jigíbu, rúya jumeí le ában oúbaü lun. ");
INSERT INTO cabNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Le áluguti lanǘgünün ligíbugiñoun lúrudu tueígiñe jisímisin, ígira jumeí lun gíñe lanǘgünun jabíte. ");
INSERT INTO cabNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ánjaün lafósura ában gürígia lun janǘgün ában anǘgüni ában máili, barǘjumei bián máili. ");
INSERT INTO cabNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Furúmieguarügü le amúriajati ában cátei júma, rújumei lun, míchiga jumeí gíñe janágan luágun le afúredeijati júma. ");
INSERT INTO cabNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘Agáambaadün gíñe luágu aríñawagúa lán meja. “Jínsiñelá bumáda bun, liyéreegudame bágani bun.” ");
INSERT INTO cabNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Áu naríñajare jun. Jínsiñe jamá jáganiñu jun, buídulá jayúmajan jabá ja wuríbabei jayúmajan jubá, adǘga jumá buíti joun ja iyéreejabúbaña jun, ayúmuragua jumá lun Búngiu jawágu ja anábagubadün, ja wuríbabei oúserunün. ");
INSERT INTO cabNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ítara lúba jagáburiduña lan queísi lirájüñü Júguchi Búngiu le siélubei, ligía oúnaja lumúti wéyu joun buítiña jáma wuríbatiña, oúnajaleí júya dándu joun múaraantiña queísi joun úaratiña. ");
INSERT INTO cabNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ánjein já rügǘbaña lubeí jínsiñejabúbaña jun ínsiñeda jun, ¿cábagi fáyeiti jerésibira luágu líra? Adǘga jamúti gíñe ja agúburajabalin liseínsuna gumádi ítara. ");
INSERT INTO cabNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ánjein joún rügǘñein lubeí jumádagu jayoúragua, ¿ca buíti jadǘgübei láu líra? Íbini ja ibídiñejabubaña lun Búngiu adǘga jamúti líra. ");
INSERT INTO cabNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Úaragua jumá le gumúti queísi úaragua lan Júguchi Búngiu le siélubei. ");
INSERT INTO cabNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ába lasígirun Jesúsu arúfudaja joun gürígia wǘbüwaügügiñe, laríñaga. —Toúnigi jumá lueí jadǘgün cátei buíti jagíbugiñe gürígia lúnrügü jaríjinün. Ánjein jadǘga ítara, míchubei Júguchi Búngiu le siélubei fáyeiti buíti jun. ");
INSERT INTO cabNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ligía, dánme lubeí jíderagun ában gudémeti, masúbudiragüda jumeí lun sun uboú quei jadǘga ja biánguabaña igíbu ligílisirugu lúma ǘmadarugu. Jagía, jadǘgüni líra lúnrügü jadímurejan gürígia buídu jawágu. Ninárün jáu luágu láu lan jadǘgüni líra, ibíja jamáali jafáyeiruája. ");
INSERT INTO cabNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dan le jíchugun ában cátei lun gudémeti, masúbudiraleí ni lubuídun-ágei jumáda, ");
INSERT INTO cabNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","adǘga jumeí lábugiñe libídiñewa. Júguchi Búngiu le aríjubalin le jadǘgübei lábugiñe libídiñewa, líchuguba jafáyeiruája. ");
INSERT INTO cabNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‘Dan gíñe le jayúmuragun lun Búngiu, mítaran jumá quei ja biánguabaña igíbu ja jínsiñebei joun lun jayúmuragun rára tídan jalígilisin juríu lúma lídan legéyedun ǘma lun jaríjiniña gürígia. Ninárün jáu luágu láu lan jadǘgüni líra ibíja jamáali jafáyeiruája. ");
INSERT INTO cabNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Dan le jayúmuragun lun Búngiu, belújuma jirúmurugun, darú jumeíme jubéneri, ábame jayúmuragun lun Júguchi Búngiu le lábuguabei júma ñi. Júguchimeti Búngiu, le aríjubalin le jadǘgübei lídan límanin, líchuguba jafáyeiruája. ");
INSERT INTO cabNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Lídan le jayúmuragun, máguyuguagüda jumá luágu dimúrei le málati quei jadǘga ja ibídiñejabubaña lun Búngiu, jarítaguatiñati luágu lagáambubaña lan Búngiu ladǘga líbe jadímurejan. ");
INSERT INTO cabNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mítaran jumá lubeíti quei jagía, ladǘga lubáragiñe jayúmuragun lun Búngiu subúdi láali ca lan jabúseerubei. ");
INSERT INTO cabNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ítara lúba lubeíti jayúmuragun. Wáguchi Búngiu le siélubei, inébewalá bíri. ");
INSERT INTO cabNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nǘbinlá bidáani lun barúeijan ya uboúagu, adügǘwalá bugúndan uboúagu quei ladügǘniwa bugúndan siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Rúba fein buídurügütu woun lun wéyu le ugúñebei, ");
INSERT INTO cabNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ferúdunabeí wuríbati le adǘga wamáalibei quei ferúduna wamániña ja adǘgübaña wuríbati woun. ");
INSERT INTO cabNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mígira báwa lun wáburujan lídoun wuríbani, dísegüdarügü báwa lueí, ladǘga amǘrü le arúeijabei, amǘrü le Súntibei Gabáfu, amǘrü le weírigubei lun sun dan. Ítaralá. ");
INSERT INTO cabNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‘Ítara líña lubeíti, ánjaña ferúduna jumá ámu luágu wuríbati le adǘga jamáalibei jun, ferúduna lubádün gíñe Júguchi Búngiu le siélubei, ");
INSERT INTO cabNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ánjein úa ferúduna jumá ámu, úabei gíñe ferúduna láani Júguchi Búngiu jifígoun. ");
INSERT INTO cabNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ába laríñagun Jesúsu. —Jugúya, dánme le jayúnarun, marúfuda jumá lírun igíbu quei jadǘga biángua tigíbu, jagía jadǘgünbalin ítara lun jaríjini gürígia luágu jayúnaruña lan. Ninárün jáu luágu láu lan jadǘgüni líra ibíja jamáali jafáyeiruája. ");
INSERT INTO cabNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ánjein jugúya, dan le jayúnarun, amúriga jumeí jídiburi, chibá jumeíme jigíbu, ");
INSERT INTO cabNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","meféen jamámuga gürígia luágu jayúnaruña lan. Júguchirügǘba Búngiu le júmabei ñi geféen luágu jayúnaruña lan, ábameti líchugun jafáyeiruája. ");
INSERT INTO cabNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","‘Moúndaragua jumá irísini ya uboúagu le ñí lubei gayára lan jájüchün jamútiri áni gayára ligía lagájüdün ámu luwúyeri irísini, le gíñe ñíjin lubeí gayára lan jebélurun jíwerutiña lun jíwerujan. ");
INSERT INTO cabNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Oúndaragua jumá irísini siélu, le ñí lubei siñá lan jájüchün jamútiri, magájüdadi ni cáta, mebélu jagía jíwerutiña íweruja ñi. ");
INSERT INTO cabNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Le ñí lumuti jirísin, ñíñoun gíñe janígi. ");
INSERT INTO cabNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","‘Ítara líña bágu quei ában lámpu lun búgubu, ánjein lubeíti buídu lubeí bágu, aríja ligía luágun irísini siélu, camá jamuga jarúgoungabei gíñe láu sun búgubu, áni buídubei gíñe sun bigáburi. ");
INSERT INTO cabNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ánjein sándi lubeí bágu, aríja ligía luágun irísini ya uboúagu, camá jamuga lídaanbei lubúriga sun búgubu, áni wuríbabei gíñe bigáburi. Ánjein ñǘbin larúgounga le bídaanbei lun lubúrigame, ¡luweírin méfuna líwurin lubúriga ligía! ");
INSERT INTO cabNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‘Úati ni ában gayáraati lesériwidun joun biáma iyúbudirigu, ladǘga lísiñeduba ában jádaangiñe lun, liyéreegudáme le ában lun, úaraguabei lúma ában jádaangiñe, líchigame mebéreseni luágu le ában. Siñáti lesériwidúniwa lun Búngiu lúma lun seínsu. ");
INSERT INTO cabNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","‘Naríñajare lubeíti jun, madíjeri jumá luágu cába lan jeíga o cába lan játa lun jabágaridun, ni tuágu anáanguni to lúnboun jadáürunun. ¿Máfunagi gebégitimaati ibágari sügǘ láu eígini, gebégi úgubu sügǘ táu anáanguni? ");
INSERT INTO cabNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Aríja jumá joun dunúru ja ájamajabaña garábalirugu. mábunagun jáña, malúbajan, mareídun jameí alúbajani lídan lágei, láu sun líra, rúti Júguchi le siélubei eígini joun. ¡Sarágu gebégitima jumá sügǘ jáu dunúru! ");
INSERT INTO cabNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Cáteigi jídaangiñe gayáraabei líchugun bián ugúdi lánwoun lúgubu, ca lan lanárimebei láfaagun luágu? ");
INSERT INTO cabNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‘¿Ca uágu jadíjerida tuágu anáanguni? Aríja jumá ída líña lan laweínamudun fulúri. láu sun mawádigimari lan, madǘgün ligía gamísa, ");
INSERT INTO cabNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ni méja urúei Salomón láu sun luwéndegun, mawéndentí meja ladáüragun quei fulúri. ");
INSERT INTO cabNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ánjeinti daǘguagüda lubálin Búngiu jíduru ítara le ugúñebei lájücha, jarúgabei yebe lagudúña, ¿gúbumésan líderaguajün loúgua tafíñen jugúya le? ");
INSERT INTO cabNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Madíjerida jumá lubeíti aríñaga. “¿Cába weíga?” o “¿Cába wáta?” o “¿Cába wadáüra?” ");
INSERT INTO cabNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gürígia ja lánigu uboú le, luágu rügüñeín buri cátei le jarítagua, ánjein jugúya, níjein júguchi Búngiu siélu le subúdijabúbei cátei lan jemégeirubei. ");
INSERT INTO cabNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Seríwi jumá lun Búngiu furúmiñe, áluaja jumeí ibágari surúti le áubei lagúndaara, ábame líchuguni sun le jemégeirubei jun. ");
INSERT INTO cabNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Madíjerida jumá lubeíti luágu jarúga, ladǘga barǘ lumuti gíñe jarúga lidíjeridüna lúmagua. Ságü ában wéyu gíbeti cátei lun. ");
INSERT INTO cabNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ába lasígirun Jesúsu aríñaga joun gürígia wǘbüwaügügiñe. —Míchiga jumá jadúnrun ámu, míchugun lámuga gíñe Búngiu jidúnrun, ");
INSERT INTO cabNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ladǘga quei ligáburi jíchugun jadúnrun ámu, ítara lúba gíñe líchugun Búngiu jidúnrun, le áubei jamísuraja, láuba gíñe lamísurajaün Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Ída lubásan gayára lan jaríjini liraǘraü ífei le lídaanbei lágu jamúlen áni masándi jumúti durúsu le lídaanbei jágu? ");
INSERT INTO cabNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿O ída lúba gayára lan jaríñagun lun jamúlen. “Sagánei liraǘraü ífei le lídaanbei bágu,” áni níjein ában durúsu lídan jágu? ");
INSERT INTO cabNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Biángua tigíbu jugúya le! Sagájumei durúsu le lídaanbei jágu furúmiñe, ítara lúba gayára lan jaríjin buídu lun jaságaruni liraǘraü ífei le lídaanbei lágu jamúlen. ");
INSERT INTO cabNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‘Míchiga jumeí arúfudajani luáguti asálbaruni joun gürígia ja gáñitiña, garábagua jáñein juágun quei oúnli lun jágürünün. Míchiga jumeí gíñe arúfudajani ligía le gebégibei sarágu joun gürígia ja büírujuduátiña, dügǘgua jañálin. ");
INSERT INTO cabNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","‘Jamúriaja lúma Búngiu, ábame líchugun jun, jáluaja, ábame jadárirun, daǘnjuma luágu béna, ábame lánjunrenchún jun. ");
INSERT INTO cabNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ladǘga le amúriajati, abíjati, le áluguti, daríti, le adaǘnjati luágu béna, jurénwati lun. ");
INSERT INTO cabNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‘¿Níjein funági ában jídaangiñe gayáraati líchugun ában dǘbü lun lisáani dan le lamúriajan fein lúma? ");
INSERT INTO cabNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿o líchugun lan ában jéwe lun dan le lamúriajan úduraü lúma? ");
INSERT INTO cabNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ánjein lubeíti láu lubeí sun wuríba jumá, gíchigaditün cátei buíti joun jisáanigu, ¡gúbuméti líchiga Júguchi Búngiu le siélubei cátei buíti joun ja amúriajatiña lúma! ");
INSERT INTO cabNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‘Súnwandanlá lubeíti jadǘgün joun ámu quei le jabúseerubei lun jadǘgüni jun, ladǘga ligía laríñagubei lilúrudun Moisés túma jalíburun profétagu. ");
INSERT INTO cabNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","‘Belújuma lídaangiñe béna le bürǘraübei. Béna lúma ǘma le anǘgübei gürígia lídoun féridi, tuléburi líña, gabáranouga ñi, áni sarágu jáña ebélurutiña lídaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ánjeinti béna lúma ǘma le anǘgübei gürígia lídoun ibágari le magúmuchaditi, bürǘraü líña, murúgua, míbetiñati adáriruti. ");
INSERT INTO cabNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","‘Toúnigi jumá jaweí yéetiña ja aríñagubaña luágu lerérun lan Búngiu jadímureja. Jayábin jun quei mudún boúgudigiñe jabíti, ánjein múnadagiñe, ítara jáña quei anímaalu gáñitiña. ");
INSERT INTO cabNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jugúya, gayáraabei jasúbudiruniña luágu le jadǘgübei, malúbajoúntu beíbei lídaangiñe jíyu, ni ígo lídaangiñe guríbiyuwa. ");
INSERT INTO cabNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sun lubeíti wéwe le buíti, buíti lin, wéwe le wuríbati, wuríbati lin. ");
INSERT INTO cabNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Wéwe le buíti, siñáti wuríba lan lin, wéwe le wuríbati, siñáti gíñe buídu lan lin. ");
INSERT INTO cabNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sun wéwe le mabuídunti lin, chaǘnwati, ába lágudúniwa. ");
INSERT INTO cabNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jasúbudirubaña lubeíti yéetiña jagía luágu le jadǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘Máma sun ja aríñagutiña nun. “Nabúreme, Nabúreme,” jebéluruba lídoun arúeijani le siélubei,’ líña Jesúsu. ‘Ja rügǘbaña adǘgübalin lugúndan Núguchi Búngiu le siélubei ebélura. ");
INSERT INTO cabNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Dánme lachǘlürün wéyu lánina agúseragüdüni, sarágubaña aríñagutiña nun. “Wabúreme, Wabúreme, apúrichijatiwa mejátia luágu bíri, sagá wagía espíritugu wuríbatiña lídan bíri, adǘga wagía sarágu miláguru lídan bíri.” ");
INSERT INTO cabNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ábameti naríñagun joun. “Ibídiñegubeiñadün nun, díse jumá nueí, jugúya le adǘga jumáalibei le wuríbabei.” ");
INSERT INTO cabNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","‘Le agáambutina, adǘgaleí le nubeíbei, ítara líña quei ában wügǘri gunfaráandati le adǘgübei lúban ligíbuagu dǘbü. ");
INSERT INTO cabNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ába liábingua júya, ába liñúrun dúna, fúgua garábali tuágun múna tugúya, meíguaduntu ladǘga luáguñein lan dǘbü tuágaburi. ");
INSERT INTO cabNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ánjeinti le agáambutina, madǘgün lumúti le nubeíbei, ában wügǘri ibídiougua táu ligía, le ábunagubei ligíbuagu ságoun. ");
INSERT INTO cabNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ába liábingua júya, iñúra dúna, fúgua garábali tuágun múna tugúya, ¡ma lanárime táburujan! ");
INSERT INTO cabNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Dan lásurun ladímurejan Jesúsu, ¡ma luweírin janígi gürígia láu le larúfudajabei! ");
INSERT INTO cabNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ladǘga láu lan ubáfu larúfudaja, máma quei arúfudajatiña lilúrudun Moisés. ");
INSERT INTO cabNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Dan le larárirunbei Jesúsu lueígiñe wǘbü, sarágu jáña gürígia afálaruti. ");
INSERT INTO cabNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ába liábin ában wügǘri gawáguti gumeín le mareídaguadibei, ába lájuduragun ligíbugiñe Jesúsu, ába laríñagun lun. —Nabúreme, ánjabu busén, gayáraati bareídaguágüdünina. ");
INSERT INTO cabNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ábati lagúurun Jesúsu luágu láu lújabu, aríñageina ligía. —Buséntina, areídaguagüda numútibu. Quei laríñagun ítara, ába lareídagun sánditi ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ába laríñagun Jesúsu lun. —Maríñaga beítia ni ca un, ñǘdünrügübá arúfudagua búngua lun fádiri, rúbeíme edéweejani le uágubei laríñaga Moisés, lun jaríjini gürígia luágu areídaguaadibu lan. ");
INSERT INTO cabNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dan le lebélurun Jesúsu lídoun fulásu le gíribei Capernaúm, ába liábin ában gumándan Rómana lubároun, ");
INSERT INTO cabNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ába layúmuragun lun ítara. —Nabúreme, níjein numúsun roun láu sándi le derégüdaü, lúma sarágu gáriti luágu. ");
INSERT INTO cabNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ába laríñagun Jesúsu lun. —Neíbuga agáranija lun. ");
INSERT INTO cabNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ába loúnabun gumándan. —Nabúreme, madǘnatina lun bebélurun núbiñoun, aríñagarügübeí dimúrei, ábame lareídagun numúsun. ");
INSERT INTO cabNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Naríñagubaalin líra ladǘga nugúya lábugiñeñadina gíñe gumádi le íñutimaati, áni añájein gíñe súdaara lábugiñe nagúmadijan. Dan le naríñagun lun ában jádaangiñe lun lídin, ñǘdünti, dan le naríñagun lun ában lun liábin, ñǘbinti, dan le naríñagun lun numúsun lun ladǘgün furúmieguarügü cátei, adǘga lumúti. Ítara lúba, luágu berérun mósu lídin sándi lueí numúsun. ");
INSERT INTO cabNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Dan le lagáambunbalin Jesúsu le laríñagubei gumándan ligía ába laweíridun lanígi, ába laríñagun joun ja afálarubalin. —Ninárün jáu luágu madárigidina lan wügǘri weíri tafíñen ni jádan numútuniña Israelítagu quei wügǘri le. ");
INSERT INTO cabNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Naríñajare jun luágu sarágujaba lan já meja ibídiñejabubaña lun Búngiu ñǘbintiña lueígiñe oúbaü le ñígiñe lubeí laboúcha wéyu, jáma le ñígiñe lubeí lálüda, ábame jañúurun eíga lúma Abrahám, Isáac lúma Jacób lídan arúeijani le lánina siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ánjeinti já yebe lúnbaña lídan jamá arúeijani ligía jaságarúba bougudín, ábame jádarúniwa lídoun luweírin-ágei lubúriga, ábame jayájuajan, ábame lacǘnrinjan jári le luweírin jagárigu. ");
INSERT INTO cabNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ába laríñagun Jesúsu lun gumándan ligía. —Beíba búbiñoun, le uágubei bafíñera, ladügǘba bun. Ába lareídagun músu ligía lídan óra ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ába lídin Jesúsu lúbiñe Pédro, ába ladárirunun límenidi Pédro roun láu abíruaü. ");
INSERT INTO cabNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ába lagúurun luágu tújabu, ába lagídarun abíruaü tueí, ába tásaarun, ába tagúmeserun esériwidaña. ");
INSERT INTO cabNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dan le lagúñedunbei, ába janǘgün sarágu gürígia ja gawágutiña espíritugu wuríbatiña lun Jesúsu, ába laságajaniña espíritugu wuríbatiña jagía jaweí láurügü ában dimúrei, areídaguagüda láña sun ja sándibaña. ");
INSERT INTO cabNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Lasúseredunbei sun le lun lagúnfulirun lé meja uágubei ladímureja proféta Isaías dan le laríñagunbei luágu Jesúsu. “Barǘ lumuti wadébilin, gidálei wasándigu.” ");
INSERT INTO cabNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Dan le laríjin Jesúsu luágu sarágu jáña lan gürígia geyégu láu, ába líchugun dimúrei lun jájiñuragun ligía jáma láni disípulugu loubáfurugun dúna. ");
INSERT INTO cabNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ába layárafadun ában arúfudajati lilúrudun Moisés lun Jesúsu, ába laríñagun lun. —Maésturu, buséntina nafálarunibu le ñíjin lumúti bídin. ");
INSERT INTO cabNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ába loúnabuni Jesúsu. —Darítiña gasígamu júyu lun jaganoún ñi, gádibutiña gíñe dunúru, ánjeinti áu le Wügǘri Garaǘwarügüti, madáritina ni jalíaba lan nabálachagüdei nichǘgü. ");
INSERT INTO cabNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Laríñaga ában jádaangiñe láni disípulugu lun. —Nabúreme, buséntina nafálarunibu, lárigiñeme loúnwen núguchi, buná neíme, ábame nafálarunibu. ");
INSERT INTO cabNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ába loúnabuni Jesúsu. —Falábana guetó, ígira báña ja jiláñubaña lun cátei le lánina larúeijan Búngiu lun jábununiña jegéburi. ");
INSERT INTO cabNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ába ládinun Jesúsu tídoun ugúnein, ába joúdin láni disípulugu lúma. ");
INSERT INTO cabNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sódini ába láfuragun ában garábali jéreti, ába lebélujan lugúdi barána tídoun ugúnein. Larúmuguñati Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ába jagágudajani láni disípulugu, ába jaríñagun lun. —¡Wabúreme, séfu báwa! ¡Wadíbiragua! ");
INSERT INTO cabNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ába loúnabuniña. —¿Cásan uágu janúfudeda? ¡Loúgua tafíñen jugúya le! Ába lásaarun, ába ladeínjan lun garábali lúma barána, ába lagálumadun. ");
INSERT INTO cabNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ába laweíridun janígi, ába jaríñagun. —¿Cáteisan wügǘri le, agáamba lubálin garábali lúma barána? ");
INSERT INTO cabNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Dan le lachǘlürün Jesúsu loubáfurugu dúna, jageíroun Gadárana, ába jáfuridun bián wügǘriña lídaangiñe buri umúajaü achigíti luágu dǘbü, ába jayábin luágun. Biángubei jagía, jáuñanu espíritugu wuríbatiña áni janárimetiti jagáñi darí lun siñá lan jásügürün gürígia lídaangiñe ǘma ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ábati jagúarajan ítara. —¿Cásan uágu bemétera wámoun, Jesúsu Liraǘ Búngiu? ¿Biábiña asúfuriragüdawa lubáragiñe dan le lánina asúfuriruni? ");
INSERT INTO cabNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ñíñanu sarágu büíruju eíga madíse ñígiñe, ");
INSERT INTO cabNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ába jayúmuragun espíritugu wuríbatiña ja lun Jesúsu, jaríñaga lun. —Ánjawa baságara, ígirabá lun webélurun jádoun büíruju ja. ");
INSERT INTO cabNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ába laríñagun Jesúsu joun. —¡Jeíbati jádoun! Ába jáfuridun espíritugu wuríbatiña jagía jádaangiñe wügǘriña jagía, ába jebélurun jádoun büíruju, ába jáguragun büíruju jagía joúngua lueígiñe ában gudúungu, ába jáburujan dúnarugun, ába jañáradagun. ");
INSERT INTO cabNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ába janúfudedagun ja oúnigirubaliña büíruju, ába jeíbaagun, jachǘlün aǘdübü, ába jabájüdaguni le asúseredubei joun büíruju lúma joun wügǘriña já buga jáubaña espíritugu wuríbatiña. ");
INSERT INTO cabNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ábati jayábin sun lílana fulásu ligía lúmoun Jesúsu, ába jayúmuragun lun lun láfuridun jageíragiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ábati ládinun Jesúsu tídoun ugúnein tugúya, ába lánjiñuragun loubáfurugun dúna, ába lachǘlürün lageíroun. ");
INSERT INTO cabNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ába janǘgün ában wügǘri derégüdaali lun, roun tídan lubárari. Dan le laríjinbalin Jesúsu luweírin jafíñen, ába laríñagun lun sánditi ligía. —Ragǘba gurásu, niraǘ, ferúdunawati bifígoun. ");
INSERT INTO cabNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ñíñanuti jádaangiñe arúfudajatiña lilúrudun Moisés, aríñagutiña joúnguarügü. “Lanábaguñeigan wügǘri le Búngiu láu dimúrei le laríñagubei.” ");
INSERT INTO cabNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Queíti subúdi lubálin Jesúsu le uágubei jasáminara, ába laríñagun joun. —¿Cásan uágu luríbanbei jisáminan ítara? ");
INSERT INTO cabNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Cátimasan ménreengúnbei laríñawagúniwa. “Ferúdunawati bifígoun”, ódi “Sarába, beíbuga”? ");
INSERT INTO cabNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Narúfudaaliti jun luágu gabáfu nan, áu le Wügǘri Garaǘwarügüti, lun ferúduna nan figoú. Ába laríñagun lun sánditi ligía. —Sarába, budáboun bubárari, beíba búbiñoun. ");
INSERT INTO cabNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ába lásaarun sánditi ligía, ába lídin lúbiñoun. ");
INSERT INTO cabNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Dan le jaríjinbaalin gürígia cátei le, ába laweíridun janígi, ába jadímurejan buíti luágu Búngiu luágu líchuguni ubáfu le joun wügǘriña. ");
INSERT INTO cabNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ába lídin Jesúsu ñígiñe, ába laríjinina, áu le gíribei Matéo, le abǘrüjabarun líburu to. Agúburajatina meja liseínsuna gumádi, ñun níña lídan nubára lánina agúburajani wéyu ligía dán le lásügürünbei Jesúsu ñígiñe. Ába laríñagun nun. —Falábana, queímoun núma queísi náni disípulu. Ába násaarun, ába nafálaruni. ");
INSERT INTO cabNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Lárigiñe, ñun líña Jesúsu eíga, sarágu jáña giñéti ja agúburajabalin liseínsuna gumádi jáma ámu gafígountiña eíga lúma úara jáma láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dánti le jaríjini fariséogu cátei le, ába jaríñagun joun láni Jesúsu disípulugu. —¿Ída liñásan leíginbei jumáesturun jáma agúburajatiña liseínsuna gumádi lúma jáma ámu gafígountiña? ");
INSERT INTO cabNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ába lagáambuni Jesúsu, ába laríñagun joun. —Ja magádiebaña mabúseeruntiña surúsia, ja sándibaña, jagía busénbaña surúsia. ");
INSERT INTO cabNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Furéndei jumeí ca lan laníchigubei le uágubei laríñaga Búngiu tídan Lerérun. “Buséntina lun gudémejabu jumá, máma lun jadágaragüdün anímaalu nun.” Máma niábiña áluajaña ja magádiebaña ligíbugiñe Búngiu, niábiña áluajaña gafígountiña lun jasáansiruni ligáburi joúserun. ");
INSERT INTO cabNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ábati jayábin ja láni Juan le abásteragüdajabei disípulugu, ába jaríñagun lun Jesúsu. —¿Ánsan wagía jáma fariséogu ayúnara wabeí sarágu, ánjaña báni disípulugu mayúnaruntiña? ");
INSERT INTO cabNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ába líchuguni Jesúsu jémpulu le joun luágu iséri larúfudajan lúma binádu, laríñaga. —¿Gayáraati funági jíruñu jamá ja amísurajoúbaña lídoun ában maríei dan le niján lan adári jáma ñi? Lachǘlürüba wéyu lun lúadun adári jáma, ligíaalime jayúnarun. ");
INSERT INTO cabNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‘Siñáti táfadajoún gamísa ñulújaru táu murúsun to derégiru ladǘga dánme le tacháwaragun to derégiruboun ábame tajeíridagun to ñulújaruboun, ábatimámeti laweíridun jeíriti. ");
INSERT INTO cabNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Siñáti gíñe léserúniwa bínu le isérigili lídoun guéru le binádujali, ánjein adügǘwa ítara, ábame lafaǘnchün guéru dánme le liñúrun bínu, féridiwa ligíameti gúeru, féridiwa bínu. Ligía lúnti lubeí léserúniwa bínu iséri lídoun guéru iséri, ítara lúba lesériwidun biángubei. ");
INSERT INTO cabNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Dan ñíñein lan Jesúsu arúfudajei sún buri cátei le, ligía liábin ában ábuti jádaangiñe juríu, ába lájuduragun ligíbugiñe, ába laríñagun lun. —Sun líña toúnwen nisáani, ánjabu ñǘdün lun bíchuguni bújabu tuágu, táguyuguba. ");
INSERT INTO cabNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ába lásaarun Jesúsu, ába lídin lúma ñi jáma láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ñíñounti ában wǘri ǘmada sánditu, dúusu irúmu táu láu lésejan jítaü tídaangiñe, ába tayárafadun lun Jesúsu lanágangiñe, ába tagúurun luágu táru lanáangun, ");
INSERT INTO cabNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","taríñaga túnguarügü. “Láurügü nagúurun tuágu lanáangun nareídaguba.” ");
INSERT INTO cabNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ába lagáraragun Jesúsu, ába laríjinun, ába laríñagun tun. —Ragǘba gurásu niraǘ, areídaguaadibu ladǘga bafíñen. Lúmagiñe óra ligía ába tareídagun. ");
INSERT INTO cabNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Dan le lachǘlürün Jesúsu lúbiñoun buga ábuti ligía, dan le laríjiniña íñaajatiña aráanseña lun ábunajani, añája gürígia areíncha, ");
INSERT INTO cabNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ába laríñagun joun. —Furíjuma yágiñe, moúnwengiru irájü to, tarúmuguña. Ába jéjerajan láu. ");
INSERT INTO cabNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Dan le furígüda láaña sun gürígia, ába lebélurun, ába lárügüdüni tújabu irájü tugúya, ába tásaarun. ");
INSERT INTO cabNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ába labúruchagun luágu le asúseredubei lídan sun fulásu ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Dan láfuridun Jesúsu ñígiñe, ába joúdin bián wügǘriña maríjintiña lárigi, agúarajeina ítara. —¡Gudéme wamá bun, amǘrü le ladǘgawagun Davíd! ");
INSERT INTO cabNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dan lebélurun Jesúsu múnadoun, ába jachǘlürün maríjintiña jagía lúmoun, ába laríñagun joun. —¿Afíñetün luágu gayára lan nareídaguagüdünün? Ába jaríñagun. —Ánja, afíñetiwa, Wabúreme. ");
INSERT INTO cabNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ába lagúuruni Jesúsu jágu, ába laríñagun joun. —Ítaralá quei ligáburi jafíñen. ");
INSERT INTO cabNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ába léfegechun jágu, ába léredun Jesúsu jawágu lun joúchun lun masúbudirúniwa lan luágu ligía lan agáranijabei joun. ");
INSERT INTO cabNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Quei jáfuridun ñígiñe, ába jabájüdaguni le ladǘgübei Jesúsu lídan sun fulásu geyégua láu. ");
INSERT INTO cabNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Dan le áfurideina jamá, ligía jayábin fiú gürígia láu ában wügǘri meréngaditi, gawáguti ában espíritu wuríbati, ába jayábin láu lun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Lárigiñe laságaruni Jesúsu espíritu wuríbati ligía lueí meréngaditi ligía, ába lagúmeserun adímureja. Ába laweíridun janígi gürígia, ába jaríñagun. —Maríjiñajágidiwa líbe le jageíra Israelítagu. ");
INSERT INTO cabNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Jaríñagaídan sun fulásu geyégua ti fariséogu luágu láu lan lubáfu Máfia le jábuti espíritugu wuríbatiña laságaja Jesúsu espíritugu wuríbatiña. ");
INSERT INTO cabNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Eíbuga lumúti meja Jesúsu sun fulásu arúfudajeina tídan jalígilisin juríu, apúrichijei ugánu buíti luáguti arúeijani le lánina siélu, areídaguagüdeina sun luwúyeri sándi lúma gáriti. ");
INSERT INTO cabNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Dan laríjiniña gürígia, ába jagúdemedagun lun, ladǘga nidíjeri jamá, magúraasun jagía, camá mudún ja moúniritiña. ");
INSERT INTO cabNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ába laríñagun joun láni disípulugu jabǘgürü gürígia jagía. —Sarágu jáña gürígia buséntiña jagáambuni ugánu luáguti asálbaruni, ítara jáña quei nádü lun lalúbajoún, áni loúguatiña ñadágimeintiña. ");
INSERT INTO cabNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Lúnti lubeíti jamúriajan lúma Labúreme nádü lun loúnajan ñadágimeintiña lun japúrichijan joun. ");
INSERT INTO cabNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ába lagúarun Jesúsu joun dúusu láni disípulugu, ába líchugun ubáfu joun lun gayára lan jaságajan espíritugu wuríbatiña jaweí gürígia lúma lun jareídaguagüdün sun luwúyeri sándi lúma gáriti. ");
INSERT INTO cabNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Niján jíri dúusu láni Jesúsu disípulugu jagía. Furúmiñeti, Simón le méme gíribei Pédro, lúma Andrés le lamúlen, Jacóbo lúma Juan le lamúlen—lirájüñü Zebedéo, ");
INSERT INTO cabNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felípe, Bartolomé, Tomás, núma, áu Matéo le agúburajabeí meja liseínsuna gumádi, Jacóbo le liraǘ Álfeo, Lébeo, le méme gíribei Tadéo, ");
INSERT INTO cabNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón—ában meja wügǘri áfaaguti lun jawáanserun juríu, lúma Júdas Iscarióte, le alúgurubalin Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dan loúnajabaliña Jesúsu dúusu ja apúrichija, ába laríñagun joun ítara. —Mídin jumá le ñí jamuti ja mámabaña juríu, mebélu jugúyame lídoun buri fulásu le láni Samária, ");
INSERT INTO cabNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","jabǘgürülá gürígia féridijaña ja Israelítagu jídin. ");
INSERT INTO cabNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jeíba, apúrichijeina luágu yaráfaali lan larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Areídaguagüda jumáña ja gawágutiña gumeín luágu jára, jáma ja gawágutiña ámu luwúyeri sándi, sarágüda jumá jiláaña, sagá jumaña espíritugu wuríbatiña. Mafáyeijántün lun jibíjini ubáfu le, magúburaja jumá gíñe luágu. ");
INSERT INTO cabNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","‘Manǘga jumá seínsu, ");
INSERT INTO cabNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","manǘgün jugúyame lágei ni cáta. Ábanrügütá simísi janǘga, manǘgün jugúyame sabádu ni bádun, ladǘga le ñadágimeinbei garíchati lun leígin lídaangiñe luwádigimari. ");
INSERT INTO cabNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‘Dánme le jachǘlürün lídoun ában ubúrugu o ában lan liraǘraü fulásu, ábame jálugun gürígia ja ánjatiña lun jerésibirunün ñi, ábame jeréderun jáma jábiñe darí jídin. ");
INSERT INTO cabNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Dánme jebélurun tídoun ában múna, ábame jabúsurun, ayúmuragueina magádiei jawágu tílana múna tugúya. ");
INSERT INTO cabNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ánjaün jerésibira tílana múna tugúya, ígira jumeí jabúsurun jáma, ánjaün merésibirun jamá, giríbugüda jumeí busúguaü ligía lun úa lan magádiei joun. ");
INSERT INTO cabNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ánjaünti merésibirun jamá, mája jagía jagáambunün, ábame jáfuridun tídaangiñe múna tugúya o lídaangiñe lan fulásu ligía, ábame jáfuruduni calíqui lueígiñe jugúdi lun jarúfuduni luágu mabuídun lan jagáburi gürígia jagía, ígira jumáña quei jadáriragun joúngua. ");
INSERT INTO cabNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ninárün jáu luágu dánme lan le lachǘlürün wéyu lánina agúseruni, weíritimaabei jasúfurirun lílana fulásu ligía sügǘ láu jasúfurirun lílana Sodóma lúma Gomórra. ");
INSERT INTO cabNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","‘Noúnajaadüntia quei mudún jagánaguoún anímaalu gáñitiña. Aráanseñu jumá lubeíti ítara quei jéwe, áni ítara jumá quei únjun madǘgünga wuríbani. ");
INSERT INTO cabNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Toúnigi jumá ladǘga j juríu. ");
INSERT INTO cabNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Janügǘwaba jagíbugiñoun gumádimatiña lúma jagíbugiñoun urúeigu lueígiñe jesériwidun nun, ítara lúba gayára lan jadímurejan nuágu jagíbugiñe, lúma jagíbugiñe ja mámabaña juríu. ");
INSERT INTO cabNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Dánme le jedéregerúniwa joun lúrudugu, májüchüra jumá luágu cába lan jaríñaga o ída lúba lan jaríñaguni, ladǘga dánme lachǘlürün óra lun jadímurejan, líchugubei Búngiu le lúnbei jaríñaguni jun. ");
INSERT INTO cabNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mámaba jugúya adímureja, láni Júguchi Búngiu Espíritu, ligíaba adímureja jídaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‘Jalúgurubaña wügǘriña jabíriña guánarü lun jafarún jilágubei, alúgura jamáñame agǘbürigu jasáanigu, garábagua jagíame isáanigu jawágun jagǘbürigu lun jáfaragüdüniña. ");
INSERT INTO cabNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jeyéreegudúba lun sun uboú nueígiñe, áni le derégüdaguati darí lúmoun lagúmuchun libágari, lebéluruba siélun. ");
INSERT INTO cabNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Dánme le jeíbaajoún lídan ában fulásu, ábame janúrajan lídoun ámu, ninárün jáu, niábinyaba, áu le Wügǘri Garaǘwarügüti, lubáragiñe jeíbuguni sún buri jabúrugute Israelítagu. ");
INSERT INTO cabNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‘Úati disípulu íñuguti lueí lumáesturun ni músu lueí liyúbudiri, ánjana asúfurira, lúnti gíñe jasúfurirun. ");
INSERT INTO cabNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lúnti gúndan lan disípulu láu lachǘlürün ítarada quei lumáesturun, lúma músu quei liyúbudiri. Ánjein aríñawagúa lubeí nuágu luágu jábutiná máfianu, gúbume janábawagua ja afálarubalina. ");
INSERT INTO cabNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","‘Ligía manúfudeda jumá lubeí jaweí gürígia,’ líña Jesúsu joun láni disípulugu lubáragiñe loúnajaniña apúrichija. ‘Úati cátei darúguati láu lun machǘlaagunbei lan, úa ni cáta le arámudagúati lun masúbudirúnwabei lan. ");
INSERT INTO cabNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Le naríñagubei jun lídan lubúriga aríñaga jumeí lídan larúgounga, le naríñagubei jun ibídiñoun joun ámu, wágua jumeí íñugiñe tibíti múna. ");
INSERT INTO cabNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Manúfudeda jumá jaweí ja gayáraabei jáfaruni úgubu jilágubei áni siñáti jáfarunun uwáni, Búngiu le gayáraabei lasúfuriragüdüni úgubu túma uwáni máfiougati lun sun dan, ligía lúnbei janúfudedun lueí. ");
INSERT INTO cabNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","‘¿Malúgurúntiña funági bián jarájüñü dunúru luágu ában liraǘraü seínsu? Áni máburujantu ni ában jádaangiñe múarugun ánjein mabúseerun lubeí Júguchi Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ásta ídiburi le jábulugubei, abájüdǘwati ában ában. ");
INSERT INTO cabNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Manúfude jumá lubeíti, gebégitün sügǘ jáu dunúru. ");
INSERT INTO cabNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‘Sun ja arúfudagutiña joúngua jagíbugiñe gürígia luágu númagiñeñánu lan, naríñaguba gíñe ligíbugiñe Núguchi Búngiu le siélubei luágu nánigu jamá. ");
INSERT INTO cabNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ja ayéedagutiña náu jagíbugiñe gürígia, nayéedaguba gíñe jáu ligíbugiñe Núguchi Búngiu le siélubei. ");
INSERT INTO cabNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‘Marítagua jumátia luágu niábiña lan lúnrügü níchugun gáluma uboúagu, máma niábiña íchiga gáluma, niábiña íchiga wuríbu. ");
INSERT INTO cabNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Láu niábin, jafánreinraguba ja mafíñebaña nuágu jáma ja afíñebaña nuágu, lawúribujaba wügǘri lúma lúguchi, isáani túma túguchu, ídiñu túma tágürü, ");
INSERT INTO cabNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","lagáganiraguba cáda ában jáma lidújeñu. ");
INSERT INTO cabNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‘Le jínsiñejabuti lun lúguchi o lúguchu sügǘ láu nísiñe lun, madǘna lumúti nánigu lan, le jínsiñejabuti joun lirájüñü sügǘ láu nísiñe lun, madǘna lumúti gíñe nánigu lan. ");
INSERT INTO cabNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Le mawándunti asúfuriruni líbe lasúfurirúniwa luágu gurúwa lun lafálarunina, madǘna lumúti nánigu lan. ");
INSERT INTO cabNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Le busénbei leséfuragun lúngua ya uboúagu leféridirubei ibágari le magúmuchadibei siélu, ánjein le ánjabei leféridiragun lúngua ya uboúagu nueígiñe, libíjubei ibágari magúmuchaditi siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","‘Le erésibirutün resíbi lumútina, le erésibirutina resíbi lumúti le oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Le erésibiruti ában proféta ladǘga liábin láu líri Búngiu, lerésibirubei afáyeiruajaü le libíjubei ában proféta, le erésibiruti ában wügǘri buíti ladǘga lubuídun, lerésibirubei afáyeiruajaü le lerésibirubei ában wügǘri buíti. ");
INSERT INTO cabNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Furúmieguarügü le íchuguti ában wéru dúna dilíti lun ában jádaangiñe ǘnabugutiña ja ladǘga nánigu jamá, libíjuba lafáyeiruaja lúmagiñe Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Dan le lásurunbei laríñaguni Jesúsu le lúnbei jadǘgüni láni disípulugu, ába lídin ñígiñe lun larúfudajan, apúrichija ligíame lídan buri fulásu geyégua láu ubúrugu le Capernaúm. ");
INSERT INTO cabNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Dan ligía, furísunruguñein Juan, ába lagáambun luágu sun le ladǘgübei Crístu. ");
INSERT INTO cabNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ába loúnajan biáma jádaangiñe láni disípulugu aríjei Jesúsu lun jálügüdüni ítara. —¿Amǘrü Crístubei le lúnbei liábin ódi lúnti wagúrabajan ámu? ");
INSERT INTO cabNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ába laríñagun Jesúsu joun. —Jeíba jaríñageime le jaríjubei lúma le jagáambubei lun Juan. ");
INSERT INTO cabNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jabájüdaguáme lun luágu aríjaaña lan já meja maríjinbaña, eíbuga já meja meíbugunbaña, areídagua jagía já meja gawágubaña gumeín luágu jára, agáamba já meja magáambubaña, sará jagía jiláaña, apúrichijoúa luágu ugánu buíti le lánina asálbaruni joun gudémetiña. ");
INSERT INTO cabNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Áni fuleíseiwati le meféridirunbalin lafíñen nuágu. ");
INSERT INTO cabNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Dan le joúdin, ába lagúmeserun Jesúsu adímureja joun gürígia luágu Juan, ába laríñagun. —¿Cásan jídinbei meja aríja lídan fulásu le mageírawati? ¿Ában wügǘri le medéraaguagüdünti larítagun queísi ában mabúru le lánjingichun garábali? ");
INSERT INTO cabNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ánjein máma lubeí líña, ¿cáti jídinbei aríja? ¿Ában wügǘri wéndeti ladáüragun? Subúsiti jun luágu ja lan wéndebaña adáüragun, tídaañanu lan jában urúeigu. ");
INSERT INTO cabNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Cáteiti jídinbei aríja? ¿Ában proféta? Ánja, ligía, áni ában wügǘri weíriguti sügǘ láu ában proféta Juan. ");
INSERT INTO cabNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ligía le uágubei taríñaga Lerérun Búngiu. Noúnajañein noúnagüle bubáragiñe, lun laráansejani ǘma bubá. ");
INSERT INTO cabNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ninárün jáu, jádan sun gürígia, úagili ni ában weíriguti lueí Juan le abásteragüdajabei, láu sun líra, le ǘnabutimaabei lídan arúeijani le siélubei weíritimaati lueí le anǘgarügübalin ugánu luágu arúeijani ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","‘Lúmagiñe dan le liábinbei Juan le abásteragüdajabei darí lúmoun dan le, murúgu jáña gürígia áluga jebélurun lídoun larúeijan Búngiu. Ja ebélurubaña, ragǘ jamuti jabára ñi queísi ában cátei le gebégiti sarágu. ");
INSERT INTO cabNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Lilúrudun Moisés jáma sun profétagu, adímurejatiñá meja luágu larúeijan Búngiu, láu liábin Juan, ába lagúmeserun jerérun profétagu jagía luágu larúeijan Búngiu agúnfulira. ");
INSERT INTO cabNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ánjeinti busén jubeí jafíñerun, Juan ligía proféta Elías lé meja lúnbei liábin lubáragiñe liábin arúeijani ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ja garígeirugubaña lun jagáambun, agáamba jamá. ");
INSERT INTO cabNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‘¿Cábasan úma núaradaguágüdaña gürígia ja lánina dan le? Magúndaatiña ni ca áu, ítara jáña quei irájüñü ja añúurubaña adíbirija mágidirugu, ába jagúarajan joun jíbirigu ítara. ");
INSERT INTO cabNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Íñaajatiwa fídu jun, mabínajantün, erémuja wagía urému jírutu jun, mayájuntün.” ");
INSERT INTO cabNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ladǘga liábin Juan meígin líña buídu quei leígin furúmieguarügü, mátun, ába jaríñagun luágu níjein lan espíritu wuríbati lídan. ");
INSERT INTO cabNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Lárigiñe, ába niábin, áu le Wügǘri Garaǘwarügüti, jou áu quei leígin furúmieguarügü, gurá, ába jaríñagun luágu geígadi nan, gátadi, jamáda áu gafígountiña jáma agúburajatiña liseínsuna gumádi. Wel, ja chúbaña áu, subúdi jamúti luágu buídu lan le ladǘgübei Búngiu láu lichú láu. ");
INSERT INTO cabNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ábati lagúmeserun Jesúsu adeínja joun gürígia lídan fulásu buri le ñi lubeí meja ladǘgei líbe-ágei láni miláguru, ladǘga masáansirun jamágili lan joúserun. Ába laríñagun. ");
INSERT INTO cabNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Fugiábu jugúya Corazínna! ¡Fugiábu jugúya Betsáidana! Lun jamúga lídan lan ubúrugu le gíribei Tíro lúma Sidón ladügǘwa miláguru buri le adügǘbei jagánagua, binárü jamúga lasáansiragua jagáburi lílana, ába jamúga jarúfuduni láu jadáüragun lúdu lúma balígi. ");
INSERT INTO cabNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Naríñajare jun luágu dánme lan lachǘlürün wéyu lánina agúseraguni, weíritimaabei jabeichún sügǘ jáu ja Tírobaña jáma ja Sidónbaña. ");
INSERT INTO cabNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Amǘrüti ubúrugu le Capernaúm, ¿jarítaguatibu luágu weírigubadibu lan queísi siélu? Maweírigúnbadibu ítara quei maweírigun lan máfiougati. Ladǘga lun jamúga lídan lan ubúrugu Sodóma ladügǘwa miláguru le adügǘbei bídan, níjeingua jamúga fulásu ligía lúmoun dan le. ");
INSERT INTO cabNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Naríñajare jun luágu lídan lánme wéyu lánina agúseraguni, weíritimaabei jabeichún sügǘ jáu Sodómana. ");
INSERT INTO cabNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Lídan dan ligía, ába laríñagun Jesúsu lun Búngiu. —Adímurejatina buíti buágu, Núguchi le Labúremebei siélu lúma uboú, ladǘga barámuduni buri cátei le jaweí chu táu jáma gunfaráandatiña, ába barúfuduni joun ja mafúnrendeirungiñábaña queísi irájüñü. ");
INSERT INTO cabNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ánja, Núguchi, ladǘga ítara líña lan babúseeruni. ");
INSERT INTO cabNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","‘Derége láali Núguchi sun cátei nun. Ibídiñeti Búngiu Irájü ni ca un buídu buídu lueídügüya lun Búngiu Úguchili, ibídiñeti gíñe Búngiu Úguchili ni ca un buídu buídu lueídügüya lun Búngiu Irájü jáma ja únbaña labúseera Búngiu Irájü lasúbudiragüdüni. ");
INSERT INTO cabNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jigoúgu númoun, sun jugúya ja bucháañabaña uágu lárigi juwádigimari lúma lijǘrü janǘgün, eméraaguagüda námugaün. ");
INSERT INTO cabNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Resíbi jumeí narúfudajan, furéndei jugúyame númagiñe, láu gagúraasun nan, ñulú tugúya nanígi, ábame jadárirun eméraaguni tun juwáni. ");
INSERT INTO cabNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ménreengunti lun jesériwidun nun, juáliti gíñe anǘgüni le níchugubei jun lun janǘgüni. ");
INSERT INTO cabNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Luágu ában wéyu le eméraaguagülei eíbugeina líña Jesúsu jáma láni disípulugu labádinagua nádü. Ába jalámachun láni disípulugu, ába játünjan lílewe türígu, ába jeígini líla. ");
INSERT INTO cabNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Dan le jaríjini fariséogu cátei le, ába jaríñagun lun Jesúsu. —Añájatia báni disípulugu adǘga wadágimanu le moún lumuti ladügǘn lídan wéyu le eméraaguagülei. ");
INSERT INTO cabNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ába laríñagun joun. —¿Malíijangidün luágu lé meja ladǘgübei Davíd luágu ában dan, dan le lalámachunbei, ligía jáma ja úarabaña lúma? ");
INSERT INTO cabNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ába lebélurun tídoun lúban Búngiu, ába leígin tídaangiñe fein to sagráuboun to moun luboún yebe leíginun, ni ligía ni ja úarabaña lúma, fádirigu rügǘñanu lun jeíginun fein tugúya según lilúrudun Moisés, áni mámati figoú le ladǘgübei Davíd ligíbugiñe Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ódi malíijangidün lídan lilúrudun Moisés luágu ñadágimein jamá fádirigu tídan lúban Búngiu lídan wéyu le eméraaguagülei áni máma figoú? ");
INSERT INTO cabNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Naríñajare jun luágu níjein lan ában weíriguti sügǘ táu lúban Búngiu ya, áu. ");
INSERT INTO cabNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jugúya, úagili gunfaráanda jumáni le laríñagubei Búngiu tídan Lerérun. “Jímein numúti lun gudémejabu jumá sügǘ láu jadágaragüdün anímaalu nun.” Lun jamúga gunfaráanda jumáni, madímurejaantün jamúga wuríbati jawágu gürígia ja madǘgünbaña ni cáta wuríbati. ");
INSERT INTO cabNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gabáfutina gíñe, áu le Wügǘri Garaǘwarügüti, lun naríñagun cába lan gayára ladügǘniwa lídan wéyu le eméraaguagülei. ");
INSERT INTO cabNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ába lídin Jesúsu ñígiñe, ába lebélurun tídoun jalígilisin juríu. ");
INSERT INTO cabNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ñíñein ában wügǘri jiláali ában lújabu, queíti busén jamá fariséogu jáma arúfudajatiña lilúrudun Moisés jadárirun lichára Jesúsu, ába jaríñagun lun. —¿Gayáraatísan lagáranijoún lun ában sánditi lídan wéyu le eméraaguagülei? ");
INSERT INTO cabNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ába laríñagun Jesúsu joun. —¿Ca jídaangiñe, ánjein galǘgün lubeí ában mudún, ába teíguadun lídoun ában wélu wéyu le eméraaguagülei, lun mídinbei lan aságaroun? ");
INSERT INTO cabNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Ma gebégitimaati ában wügǘri sügǘ táu ában mudún! Gayáraati lubeíti ladügǘn buíti lídan wéyu le eméraaguagülei. ");
INSERT INTO cabNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ába laríñagun lun wügǘri ligía. —Tulébei bújabu. Dan le látuleruni, ába lareídagun quei le ában. ");
INSERT INTO cabNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ába jáfuridunga fariséogu, ába jagúmeserun áluaja ída lúba lan jáfaruni Jesúsu jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Dan lasúbudirunbalin Jesúsu cátei le, ába lídin ñígiñe, ába jafálaruni sarágu gürígia, ába lareídaguagüdüniña sun sánditiña. ");
INSERT INTO cabNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ábaja laríñagun joun lun maríñagun jamáni cáteiñein lan. ");
INSERT INTO cabNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Lasúseredunbei líra lun lagúnfulirun lé meja laríñagubei proféta Isaías. ");
INSERT INTO cabNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Niján numútun le nanúadirubei lun lesériwidun nun, le jínsiñebei nun, le áubei nagúndaara, líña Búngiu. Níchugubei náni Espíritu luágu, ábame larúfudajani joun ja mámabaña juríu ída lúba lan gayára lan júaradun nigíbugiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mageíndagunbei, magúaragun, mareínjabei ǘmada. ");
INSERT INTO cabNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gudémejabubei joun gürígia ja gudémebaña queísi ában mabúru le barúguaali, lúma joun ja débilibaña lídan jafíñen queísi ában lámpu le ñegúmemeeli. Ítara méme lúba daríme adǘga láali larúeijan le úaraguabei. ");
INSERT INTO cabNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ábame jíchuguni ja mámabaña juríu jeménigi luágu. ");
INSERT INTO cabNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ábati lanügǘniwa ában wügǘri lun Jesúsu, maríjin líña, madímurejan, láuñein ában espíritu wuríbati. Ába laságaruni Jesúsu espíritu wuríbati lídaangiñe, ába laríjin, adímureja ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ába laweíridun janígi sun ja ñíbaña, ába jaríñagun. —¿Niján funásan ladǘgawagunbei Davíd? ");
INSERT INTO cabNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Dan le jagáambunbalin fariséogu cátei le, ába jaríñagun. —Wügǘri le, láu lubáfu Beelzebú, le Máfia, le jábuti espíritugu wuríbatiña laságajaña. ");
INSERT INTO cabNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Quei subúdi láani Jesúsu le jarítagubei, ába laríñagun joun. —Furúmieguarügü arúeijani le afánreinraguti lun jageíndagun jámagua, lagǘnrinchaguba, ánjaña gíñe afáreinragua lílana ában ubúrugu o ában lan família ladǘga wuríbu, siñábei jadúrarun. ");
INSERT INTO cabNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ítara líña giñéti, ánjein laságara Máfia máfia guánarügü, ligía guánarügü afánreinragubei, áni ¿ída lubáti ladúrarun lubáfu ítara? ");
INSERT INTO cabNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Jugúya, aríñagatün luágu láu lan lubáfu Beelzebú, o Máfia, naságaja espíritugu wuríbatiña, ánjein ítara líña lubeí, ¿cáti íchugubei ubáfu joun ja jánigu jugúya lun jaságajaniña, Máfia ódi Búngiu? Jagía guánarügü arúfuda jamúti luágu bulíeigua jumá. ");
INSERT INTO cabNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Áu, láu lubáfu láni Búngiu Espíritu naságaja espíritugu wuríbatiña. Arúfuda lumúti líra luágu chülǘjali lan larúeijan Búngiu jídoun. ");
INSERT INTO cabNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","‘¿Ída lubági gayára lan lebélurun ában gürígia lúbiñoun ában wügǘri jéreti lun lanǘgüni lílagu ánjein magǘragun lan furúmiñe? Ítara rügǘñein lun gayára lan lanǘgüni lílagu. ");
INSERT INTO cabNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‘Le mámabei númagiñe, náganiñein, le míderagun lumútina, güríngua lumúti le nadǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","‘Jugúya aríñagatün luágu láu lan lubáfu Máfia naságaja espíritugu wuríbatiña, áni láu lubáfu Sífiri Sándu naságajaña. Ligía naríñagunbei jun luágu gayára lan ferúdunawa lan sun figoú lúma sun wuríbati le jaríñagubei gürígia, ánjein lun jadímurejan wuríbati luágu Sífiri Sándu, siñábei ferúdunawa lan figoú líra. ");
INSERT INTO cabNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Furúmieguarügü gíñe le aríñaguti furúmieguarügü cátei wuríbati nuágu, áu le Wügǘri Garaǘwarügüti, gayáraati ferúdunawa lan, ánjeinti le adímurejati wuríbati luágu lubáfu Sífiri Sándu le nídaanbei, úabei ferúdunawa lan ni lídan uboú le, ni lídan le ában. ");
INSERT INTO cabNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","‘Ánjein buídu lubeí ídibu, buídubei gíñe lin, ánjein mabuídun lubeí ídibu, mabuídunbei gíñe lin. Luágu lin ídibu lasúbudirúa ca lan luwúyeribei. ");
INSERT INTO cabNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Jarásan jéwe jugúya le! Siñáti jadímurejan cátei buíti, wuríbatüngan. Cátei le buínbei tídan anígi, ligía laríñagubei iyúmaü. ");
INSERT INTO cabNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wügǘri le buídubei, cátei buíti laríñagubei ladǘga tídaañein lan lanígi ubuíduni, wügǘri le wuríbabei, cátei wuríbati laríñagubei ladǘga tídaañein lanígi wuríbani. ");
INSERT INTO cabNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Naríñajare jun luágu dánme lan lachǘlürün luwéyuri agúseruni, sun gürígia geféenbaña luágu sun dimúrei málati le jaríñagubei, ");
INSERT INTO cabNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ladǘga luáguba le baríñagubei bagúseragüdǘwa, ligíaba arúfudei ánjein gadúnrun bubeí lúmoun madúnrun ban. ");
INSERT INTO cabNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ába jaríñagun jádaangiñe fariséogu jáma arúfudajatiña lilúrudun Moisés lun Jesúsu. —Maésturu, buséntiwa waríjin badǘgün ában seíni le láuti miláguru luágu lúmagiñe lan Búngiu biábin. ");
INSERT INTO cabNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ába laríñagun Jesúsu joun. —Gürígia wuríbatiña áni magúnfuliruntiña amúriajatiña seíni láuti miláguru, míchugúnbei ámu seíni joun lueí le asúseredubei lun proféta Jonás. ");
INSERT INTO cabNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ladǘga queí leréderun Jonás ǘrüwa wéyu ǘrüwa áriebu lurágeirugu údu, ítara lúba gíñe neréderun, áu le Wügǘri Garaǘwarügüti, lídan numúaja ǘrüwa wéyu, ǘrüwa áriebu, según ligáburi jabájüdüni juríu dan. ");
INSERT INTO cabNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Já meja aganoúbaña Nínive jásaaruba lídan luwéyuri agúseruni dánme jagúseragüdǘniwa gürígia ja lánina dan le, ábame jíchugun jadúnrun ladǘga sáansiguati jagáburi Nínivena dan le lapúrichijanbalin Jonás lugánute Búngiu joun, áni anája áu, ában weíriguti sügǘ láu Jonás, áni májatün jagáambunina. ");
INSERT INTO cabNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tásaaruba gíñe lurúeitena Súru lídan luwéyuri agúseruni dánme le jagúseragüdǘniwa gürígia ja lánina dan le, ábame tíchugun jadúnrun, ladǘga ñǘbintu lídaangiñe lidíse-ágei uboú lun tagáambuni lichú láu Salomón, áni anája áu, ában weíriguti sügǘ láu Salomón, áni májatün jagáambunina. ");
INSERT INTO cabNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","‘Dan le láfuridun ában espíritu wuríbati lídaangiñe ában gürígia, ába eíbugañaja lan lídan fulásu mábeiti áluaja leméraagun, dan madári láani, ába laríñagun lúnguarügü. ");
INSERT INTO cabNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Nagíribuda tídoun núban to ñígiñe lubeí náfurida.” Dan le lagíribudun, ába ladáriruni gürígia buga ligía queísi ában múna to málatu, abuídajoúaaru, aráanserúa. ");
INSERT INTO cabNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ábati lídin, ába liábin jáu sédü espíritugu wuríbatimaatiña sügǘ láu, ába jebélurun sun jagía agánawa lídan gürígia ligía, wuríbatimájaliti le gádaanbalin sügǘ láu meja furúmiñe. Ítara lúba giñéti lasúseredun joun gürígia wuríbatiña ja lánina dan le. ");
INSERT INTO cabNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ñígili Jesúsu adímureja joun gürígia, ligía tiábin lúguchu jáu lamúlenu. Ába jeréderun boúgudi, buséntiña yébe jadímurejan lúma. ");
INSERT INTO cabNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ába laríñawagún lun Jesúsu. —Nuján búguchu jáma bamúlenu ya boúgudi, buséntiña jadímurejan búma. ");
INSERT INTO cabNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ába laríñagun Jesúsu lun le awísarubalin. —¿Ca núguchuboun, ca namúlenubaña? ");
INSERT INTO cabNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ába larúfudun jawágun láni disípulugu, ába laríñagun. —Añája núguchubaña, jagía gíñe namúlenubaña, ");
INSERT INTO cabNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ladǘga furúmieguarügü le adǘgüti lugúndan Núguchi le siélubei, ligía namúlenbei, nítu, núguchu. ");
INSERT INTO cabNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wéyu ligía, ába láfuridun Jesúsu múnadagiñe, ába lañúurun láru dúna. ");
INSERT INTO cabNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Quei jagíbedagun gürígia le ñí lubei, ába ládinun tídoun ában ugúnein, ába lañúurun, ába jeréderun sun gürígia láru dúna. ");
INSERT INTO cabNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ába larúfudajan sarágu cátei joun láu jémpulu, ába laríñagun. —Ñíñein ában ábunaguti, ába láfuridun ábunagua. ");
INSERT INTO cabNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Lídan afúrujeina láani líla nádü, ába láburujan lídaangiñe luágun ǘma, ába jayábin dunúru, ába jeígini. ");
INSERT INTO cabNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Líbiri, ába láburujan labádinaguoún dǘbü le ñí lumuti úa lan sarágu múa, ába laboúchun furése ladǘga majúlilin lan múa. ");
INSERT INTO cabNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Dan le lásüdün wéyu, ába lásaürün queíti málagüle lan, ába loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Líbiri ílaü, ába láburujan labádinaguoún jíyu, ába laweínamudun jíyu úara lúma, ába láfaruni. ");
INSERT INTO cabNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ñíñein lídaangiñe, áburujati lídoun múa buíti, alúbajoúati buídu, níjein lídaangiñe, íchuguti san águu luágu cáda ában águu, líbiri rúti ǘrüwa-wein, líbiri darándi. ");
INSERT INTO cabNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jugúya le garígeirugubei lun jagáambun, agáamba jumána. ");
INSERT INTO cabNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ábati jayábin disípulugu, ába jaríñagun lun Jesúsu. —¿Cásan uágu badímureja joun gürígia láu jémpulu? ");
INSERT INTO cabNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ába laríñagun joun. —Jugúya, subúdigüda láali Búngiu sun cátei arámudaguati le lánina larúeijan jun, ánjein jagía, siñáti jasúbudiruni. ");
INSERT INTO cabNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Le agúnfuliruti lúma inárüni le lagáambubei, líchugúba lánwoun lun, ánjein le maténirunti lun, gidáwarügübei murúsun larúgounga le lúmabei lueí. ");
INSERT INTO cabNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ligía nadímurejanbei joun láu jémpulu ladǘga aríja jamáni le nadǘgübei, ába jeréderun camá maríjintiña, agáamba jameí le naríñagubei, ába jeréderun úaga gunfaráanda jamá camá jamuga magáambuntiña. ");
INSERT INTO cabNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jawágu lagúnfulira lé meja laríñagubei proféta Isaías dan laríñagunbei. Jugúya, jagáambuba, úabei gunfaráanda jumá, jaríjuba, ibídiñebei jun ca lan lílabei le jaríjubei, ");
INSERT INTO cabNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ladǘga deréeru janígi, wuríbaaliti jagáambun, murúñu líña jágu, lun maríjin jumá láu, magáambun láu jarígeirugu, úa gunfaráanda jumá táu janígi, magáraragun jugúyame nun lun nareídaguagüdünün. ");
INSERT INTO cabNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","‘Ánjeinti jugúya le nánigubei, fuleíseiwatün ladǘga aríjatün láu jágu, agáamba jugúya láu jarígeirugu. ");
INSERT INTO cabNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ninárün jáu, sarágu jañá meja profétagu jáma ámu gürígia gúnfulitiña lúma Búngiu abúseerutiña jamúga jaríjinina quei jaríjinina jugúya guetó, maríjin jamútina, buséntiña jamúga meja jagáambuni le jagáambubei jugúya, magáambun jamúti. ");
INSERT INTO cabNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","‘Agáamba jumeíti le lílabei jémpulu luáguti ábunaguti. ");
INSERT INTO cabNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ja agáambubalin ugánu luáguti arúeijani le lánina siélu áni úati gunfaráanda jamáni, ítara jáña quei ǘma le ídounbei láburuja lídaangiñe líla nádü, ába liábin Máfia, ába laságaruni ugánu buíti le ábunúbei tídaangiñe janígi. ");
INSERT INTO cabNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Dǘbü le ñíjin lubeí láburuja ílaü, ítara líña quei gürígia ja agáambubalin ugánu, ába jerésibiruni láu ugúndani, ");
INSERT INTO cabNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","quei márügüdün lubeí buídu tídan janígi, madúrati jádan. Dánti le lachǘlürün dan lun joúchawagún lúma jeíbaajoún lueígiñe ugánu ligía, ába leíguadun jarǘna. ");
INSERT INTO cabNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jíyu le ñíjin lubeí láburuja ílaü, ítara líña quei gürígia ja agáambubalin ugánu, weíritimaati jafúudun luágu cátei le lánina ibágari le, ába leyéeduniña irísini. Sun le, ába láfaruni ugánu tídaangiñe janígi, mígiruntiti lun lalúbajoún jádan gürígia jagía. ");
INSERT INTO cabNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Múa buíti le ñíjin lubeí láburuja ílaü, ítara líña quei gürígia ja agáambubalin ugánu, ába gunfaráanda jamáni, ába jíchugun ában alúbajoúni buíti. Añájein, ítara jáña quei ílaü le íchugubei san águu luágu ában, jíbiri quei le íchugubei ǘrüwa-wein, jíbiri quei le íchugubei darándi. ");
INSERT INTO cabNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ábaya líchuguni Jesúsu jémpulu le joun. —Arúeijani le lánina siélu, ítara líña quei ában wügǘri le ábunagubei ílaü buíti lídan lufúlasun, ");
INSERT INTO cabNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","dan añája lan sun ja ñíbaña arúmuga, ába lebélurun ában lágani labúreme fulásu ligía, ába lábunun jíduru wuríbati labádinagua türígu, ába lídin. ");
INSERT INTO cabNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dan le laweínamudun türígu ába legélewejan, ába gíñe lachǘlaagun jíduru wuríbati. ");
INSERT INTO cabNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ába joúdin músu, ába jaríñagun lun jayúbudiri. “Wayúbudiri, ánjein buídu lubeí ílaü le bábunagubei bumúanrugu, ¿jalíagiñésan lasálira jíduru wuríbati le?” ");
INSERT INTO cabNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ába laríñagun iyúbudiri joun. “Ladǘga ában ágani le.” Ábati jaríñagun músu lun. “¿Buséntibu lun wájulajani jíduru wuríbati le?” ");
INSERT INTO cabNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ába laríñagun joun. “Uá, ladǘga dánme jájulajani jíduru wuríbati, julá jíñein lin gíñe türígu úara lúma. ");
INSERT INTO cabNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ígiragubei jumeí lun laweínamudun úara daríme lidáani alúbajani, ábame naríñagun joun ñadágimeintiña lun jájulajani jíduru wuríbati furúmiñe, ábame jagǘraguni lun lágudúniwa, lárigiñeme, ábame jareíduni türígu tídan lágei.” ");
INSERT INTO cabNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Rúlumuti gíñe Jesúsu jémpulu le joun. —Ítara líña arúeijani lánina siélu quei ában tíla mostása le lábunubei ában wügǘri lufúlasunrugu. ");
INSERT INTO cabNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tíla mostása, ligía ílaü ñǘraütimaabei lídaangiñe sun ílaü, áni dan laboúchun, ligía weíritimaabei lídaangiñe sun nádü, ába liábin lun ábanbei lan wéwe weíriti darí lun jayábin dunúru adǘga jádibu luágu lilímun. ");
INSERT INTO cabNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Rúlumuti gíñe jémpulu le joun. —Ítara líña arúeijani le lánina siélu quei ísi le tagúbudubei ában wǘri tídan ǘrüwa líburu fulúwaaru, ába terésirun sun fulúwaaru tugúya. ");
INSERT INTO cabNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Láu jémpulu laríñagei Jesúsu sun cátei le joun gürígia, maríñagunti ni cáta joun mayúsurunga jémpulu. ");
INSERT INTO cabNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sun cátei le, lun lagúnfulirun le laríñagubeí meja Búngiu liyúmulugugiñe proféta. Nadímurejaba láu jémpulu jun, nafúnraanguagüdübei cátei lé buri meja arámudaguabei jun lúmagiñe nadǘgüni uboú. ");
INSERT INTO cabNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ába loúnajaniña Jesúsu gürígia jábiñoun, ába lebélurun múnadoun, ába jayábin láni disípulugu, ába jaríñagun lun. —Furáanguagüdabeí jémpulu le luáguti jíduru wuríbati woun. ");
INSERT INTO cabNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ába laríñagun Jesúsu joun. —Áu le Wügǘri Garaǘwarügüti, áu le ábunagubalin ílaü buíti, ");
INSERT INTO cabNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","múa, ligía uboúbei, ílaü buíti, jagía gürígia ja lílana larúeijan Búngiu, jíduru wuríbati, jagía gürígia ja lánigu Máfia, ");
INSERT INTO cabNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","áganiti le ábunubalin jíduru wuríbati, Máfia méme, alúbajani, ligía lagúmuchunbei uboú, ja alúbajabaña, ánjeligu. ");
INSERT INTO cabNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ítara quei labúdajoúniwa jíduru wuríbati ába lágurún wáturugun lun lágudun, ítara lúba gíñe lasúseredun dánme lagúmuchun uboú, ");
INSERT INTO cabNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","áu le Wügǘri Garaǘwarügüti, noúnajabaña náni ánjeligu aságaraña sun ja afígoungüdübaña ámu, jáma ja adǘgübaña wuríbati, lídaangiñe narúeijan, ");
INSERT INTO cabNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ábame jácharaguniña lídoun wátu geméti lánina máfiougati. Ábame jayájuajan ñi, ábame lacǘnrinjan jári. ");
INSERT INTO cabNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jámeti adǘgübalin le lubeíbei Búngiu, ábame jámiridun quei wéyu lídan larúeijan Wáguchi Búngiu. Agáamba jumána, jugúya le garígeirugubei lun jagáambun. ");
INSERT INTO cabNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","‘Ítara líña arúeijani le lánina siélu quei irísini le arámudúañubei lábugiñe múa. Ladárirei ában wügǘri irísini ligía, ábaya larámuduni ñi méme, le luweírin lugúndan, ába lídin, ába lalúguruni sun le lúmabei, ába lagáñijani fulásu ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","‘Ítara líña gíñe arúeijani le lánina siélu quei ában alúgurajati le eíbugañajabei áluaja pérla fínuti, ");
INSERT INTO cabNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","dánti ladárirun ában le weíriti lebégi, ába lídin, ába lalúguruni sun le lúmabei, ába lagáñijani pérla ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","‘Ítara líña gíñe arúeijani le lánina siélu quei ában séni to agurúboun baránaja, ába tañúgun sun jawúyeri úduraü. ");
INSERT INTO cabNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Dan tabuínchun, ába jacháwarunun esénijatiña lárun béya, ába jañúurun ñi anúadajaña úduraü, ába jareíduniña ja buídubaña, ába jachágaruniña ja wuríbabaña. ");
INSERT INTO cabNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ítara lúba dánme lagúmuchun uboú, jayábiba ánjeligu lun jafánreinruniña ja buídubaña jádaangiñe ja wuríbabaña. ");
INSERT INTO cabNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ábame jádaruniña ja wuríbabaña lídoun wátu geméti lánina máfiougati, ñíba lubeí jayájuaja, acǘnrijame jári. ");
INSERT INTO cabNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ábati lálügüdüniña Jesúsu, laríñaga joun. —¿Gunfaráanda jumútisan sun cátei le? Ába jaríñagun. —Ánja, Wabúreme. ");
INSERT INTO cabNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ábati laríñagun joun. —Dan le liábin ában arúfudajati lilúrudun Moisés lun gunfaráanda láni luáguti arúeijani le lánina siélu, ába ítara lan quei ában iyúbudiri le gaságaraditi cátei iséri buri lúma cátei binádu buri lídaangiñe lirísin lun líchuguni joun tílana lúban dan le jemégeiruni, queígubeirügü, gayáraati larúfudajan joun gürígia luágu lilúrudun Moisés lúma gíñe luágu cátei le narúfudajabei, áu le Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Dan lagúmuchunbei líchuguni Jesúsu jémpulu buri le, ába lídin ñígiñe, ");
INSERT INTO cabNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ába lachǘlürün lageíroun. Ába lagúmeserun arúfudaja tídan jalígilisin juríu to lídaanboun fulásu ligía, ába laweíridun janígi gürígia, ába jaríñagun. —¿Jalíasan lafúnrendeirei wügǘri le sun lichú áu le? ¿Ída liñásan gayára láani miláguru buri le adǘga? ");
INSERT INTO cabNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Liraǘga saráfangei le, María lúguchuboun, líbugaña Jacóbo, José, Simón lúma Júdas, ");
INSERT INTO cabNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ya gíñe jagánawa lamúlenu jáma lítunu wádan. ¿Jalíagiñeti lasúbudirei sun le? ");
INSERT INTO cabNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ába jamájarun lun jerésibiruni. Ába laríñagun Jesúsu joun. —Sun gürígia jínsiñeti ában proféta joun, mámarügaali ligía lídaangiñeti fulásu le ñí jabeí o tílana lan jában. ");
INSERT INTO cabNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Madǘgüntiti sarágu miláguru ñi ladǘga mafíñen jamá luágu. ");
INSERT INTO cabNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lídan dan ligía, ába lagáambun Heródes, le gumándan lídan fulásu le gíribei Galiléa, luágu Jesúsu, ");
INSERT INTO cabNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ába laríñagun joun ja lúmabaña. —Juan le abásteragüdajabei le, sará jádaangiñe jiláaña, ligía gabáfu lubeí lun ladáagun miláguru. ");
INSERT INTO cabNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Lé meja suséreelibei, daǘlumuti meja Heródes Juan, ába lagǘraguágüdüni láu güríngüri tueígiñe Heródias tó meja lúmari Felípe, le lamúlen. ");
INSERT INTO cabNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Aríñagaalí meja Juan lun Heródes luágu moun láni lagámaridunun lúmari lamúlen, madǘgünti Heródes gásu láu. ");
INSERT INTO cabNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Busénti yebéti Heródes láfaruni Juan jilágubei, ladǘga lanúfude jaweí gürígia, madǘgun lumúti ladǘga sun lan gürígia afíñetiña luágu proféta lan Juan. ");
INSERT INTO cabNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Dánti le efédujani luágu lagúnfulirun Heródes irúmu, ába tiábin tiraǘ Heródias, ába tabínajan jagíbugiñe amísurajoútiña, léti línsiñe tabínajan lun Heródes, ");
INSERT INTO cabNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ába laríñagun tun láu fiñún luágu líchugubei lan furúmieguarügü cátei le tamúriajan lúma tun. ");
INSERT INTO cabNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ábati taríñagun túguchu tun lun tamúriajani lábulugu Juan le abáste jilágubei, ladǘga, lun jíchuguni tun lídan ában asíedu, ába tamúriajani lúma ítara. ");
INSERT INTO cabNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ába lírudagun Heródes lueígiñe cátei le, quei aríñaga láali lan láu fiñún, agáamba jameí amísurajoútiña, ába laríñagun lun líchugúniwa tun. ");
INSERT INTO cabNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ábati laríñagun lun ladǘrürǘniwa lábulugu Juan furísunrugu, ");
INSERT INTO cabNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ába janǘgüni lídan ában asíedu, ába líchugúniwa tun irájü tugúya, ába tíchuguni tun túguchu. ");
INSERT INTO cabNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ábati jayábin l-íñagun tun láu fiñún luágu lanigu Juan, ába janǘgüni lúgubu, ába jábununi, lárigiñe, ába joúdin awísarei Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Dan lagáambuni Jesúsu cátei le, ába lídin ñígiñe jáurügü láni disípulugu tídan ában ugúnein lídoun ában fulásu mageírawati. Ába jasúbudiruni gürígia, ába jáfuridun lídaangiñé buri aǘdü, ába joúdin lárigi, eíbu. ");
INSERT INTO cabNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Dan larárirun Jesúsu tídaangiñe ugúnein, ába laríjin luágu sarágu jaña lan gürígia jagía, ába jagúdemedagun lun, ába lareídaguagüdüniña ja sándibaña jádan. ");
INSERT INTO cabNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Queíti agúñedeinaali lubeí, ába jaríñagun láni Jesúsu disípulugu lun. —Dárüjalitia áni úatiña gürígia aganoútiña lídan fulásu le. Oúnaja báña gürígia ja, ñǘdün jamámuga lídoun buri lirájüñü fulásu yaráfa agáñija eígini lun jeígin. ");
INSERT INTO cabNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ába laríñagun Jesúsu joun. —Mídinbaña, rújuma eígini joun. ");
INSERT INTO cabNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ába jaríñagun lun. —Seíngü rügǘñoun fein wáma ya, jáma bián úduraü. ");
INSERT INTO cabNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ába laríñagun Jesúsu joun. —Barǘjumoun nun ñájoun. ");
INSERT INTO cabNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ába laríñagun joun gürígia lun jañúurun luágu jíduru. Ába lanǘgünun seíngü fein jáma bián úduraü jagía lújaburugu, ába laríjin siélun, ába leteíngiruni Búngiu tuágu. Ábati lagúbachagunun fein, ába líchugunun joun láni irun Jesúsu tídaangiñe ugúneidisípulugu, ába jafánreinjanun jádan gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sun jagía joútiña quimúle, lárigiñe, ába jabuínchagüdün dúusu faníñe táu to ígiragutu. ");
INSERT INTO cabNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Seíngüñanu mílu wügǘriña eígitiña, mabájüdünga würíña jáma irájüñü. ");
INSERT INTO cabNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ába loúnajaniña Jesúsu láni disípulugu lubá tídan ugúnein tugúya lun jánjiñuragun loubáfurugun sun niján lan oúnajaña gürígia águyu. ");
INSERT INTO cabNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Lásun loúnajaniña, ába laweínrun lábugua luágun wǘbü ayúmuragua lun Búngiu. Dan le lagúñedunbei, ñíñein Jesúsu lábugua, ");
INSERT INTO cabNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","sun núnguran tan ugúnein lamídan dúna. Ába láfarajan lugúdi barána tuágu ugúnein ladǘga tubárouñein lan garábali. ");
INSERT INTO cabNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ába liábin Jesúsu jawágun lubá larúgan, eíbugeina ligíbuagu dúna. ");
INSERT INTO cabNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Dan jaríjini láni disípulugu eíbugeina ligíbuagu dúna, ába janúfudedagun, ába jagúaragun láu anúfudei. —¡Úfiaü! ");
INSERT INTO cabNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ába ladímurejan Jesúsu joun, ába laríñagun joun. —¡Ragǘjuma anígi, áu le, manúfudeda jumá! ");
INSERT INTO cabNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ába laríñagun Pédro lun. —Nabúreme, ánjein amǘrü lubeí, eíbugagüda bána gíñe ligíbuagu dúna chülǘ le ñí bubei. ");
INSERT INTO cabNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ába laríñagun Jesúsu lun. —Jigábuti. Ába larárirun Pédro tídaangiñe ugúnein, ába lagúmeserun eíbuga le ñíjin lubeí Jesúsu ligíbuagu dúna. ");
INSERT INTO cabNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Dan le lasándiruni lére garábali ába lanúfudedagun, ába lagúmeserun abúlucha, ába lagúaragun. —¡Séfu bána Nabúreme! ");
INSERT INTO cabNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ába lárügüdüni Jesúsu lújabu, ába laríñagun lun. —¡Loúguati gíñe bafíñen! ¿Ca uágu laloúguada bafíñen? ");
INSERT INTO cabNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Dan jádinun tídoun ugúnein, ába lagálumadun garábali. ");
INSERT INTO cabNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Játi buga tídaanbaña ugúnein, ába jájuduragun ligíbugiñe Jesúsu, ába jaríñagun. —Inárüni luágu Liraǘ ban Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ába jánjiñuraguni dúna, ába jachǘlürün Genésaret. ");
INSERT INTO cabNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dan le jíchugunbei lílana fulásu fe luágu Jesúsu lan, ába jabúruchaguagüdüni lídan sun fulásu ligía, ába janǘgüniña sun sánditiña le ñíjin lubeí. ");
INSERT INTO cabNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ába jayúmuragun lun lun lígirun lúnrügü jagúuruni táru lanáangun, sun ja agúurubarun, areídaguátiña. ");
INSERT INTO cabNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ába jayábin fiú fariséogu jáma arúfudajatiña lilúrudun Moisés, ñǘbintiña ubúrugugiñe Jerusalén lúmoun Jesúsu, ába jaríñagun lun. ");
INSERT INTO cabNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Ánsan jájalachagunbalin báni disípulugu binádu jagáburi weíyaaña mútu? Magúnfuliruntiña láu lachibúniwa újabu lubá eígini, según wagáburi. ");
INSERT INTO cabNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ába laríñagun Jesúsu joun. —¿Ánti gíñe jájalachagunbalin lerérun Búngiu lun jafálaruni binádu jigáburi? ");
INSERT INTO cabNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Laríñajare Búngiu. “Inébe jamá bagǘbürigu bun, le anábagubaliña lagǘbürigu, jilála.” ");
INSERT INTO cabNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ánjeinti jugúya, aríñagatün luágu gayára lan laríñagun ában gürígia lun lúguchi o tun lúguchu. “Siñáti níderagunibu ladǘga sun le númabei, aríñagaadina luágu lun lan níchuguni lun Búngiu”, ");
INSERT INTO cabNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","luágu furúmieguarügü lan le aríñaguti ítara, mámaali lan lúnti líderaguniña lagǘbürigu. Láu líra mebégigüda jumáali lagúmadijan Búngiu lun jafálaruni binádu jigáburi. ");
INSERT INTO cabNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Biángua tigíbu jugúya le! Linárün proféta Isaías laríñagunbei juágu ítara. ");
INSERT INTO cabNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Jayumárurügü gürígia ja jíchiga inébesei nun, líña Búngiu, ánjein tídan janígi, mebéresentiña náu. ");
INSERT INTO cabNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Málati jájuduragun nun, ladǘga le rügǘñein jagúmadijan wügǘriña jarúfudaja. ");
INSERT INTO cabNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ábati lagúarun joun gürígia, ába laríñagun joun. —Agáamba jumá, gunfaráanda jugúyame. ");
INSERT INTO cabNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Máma eígini le leígubei gürígia adǘgübalin lun marúman lan ligíbugiñe Búngiu, dimúrei wuríbati le laríñagubei wügǘri, ligía adǘgübalin lun marúman lan. ");
INSERT INTO cabNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ábati jayábin disípulugu lúmoun Jesúsu, ába jaríñagun lun. —¿Subúditisan bun luángiu lun jafálaruni binádu jiggu wuríba lan láburujan dimúrei le baríñagubei joun fariséogu? ");
INSERT INTO cabNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ába laríñagun joun. —Furúmieguarügü nádü to máma lábunun Núguchi Búngiu le siélubei, lájulúba láu sun lílagüle. ");
INSERT INTO cabNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ígira jumáña, maríjintiña ja adúndejatiña maríjintiña jáledi jagía. Áni ánjein adúndeja ában maríjinti ában maríjinti líledi, jeíguaduba biángubei jagía lídoun ában júyu. ");
INSERT INTO cabNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ábati laríñagun Pédro lun Jesúsu. —Furáangugüdabeí jémpulu le woun. ");
INSERT INTO cabNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ába laríñagun Jesúsu. —¿Úati gíñe gunfaráanda jumá? ");
INSERT INTO cabNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Úati gunfaráanda jumá luágu sun lan le ebélurubei lídoun iyúmaü, ába lídin lídoun urágei, lárigiñe ába láfuridun lídaangiñe úgubu? ");
INSERT INTO cabNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ánjein dimúrei le áfuridubei lídaangiñe iyúmaü, tídaangiñe anígi liábin, ligíati ádügübalin wügǘri lun marúman lan ligíbugiñe Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ladǘga tídaangiñe anígi láfurida samínaü wuríbati, áfarajani, adultériu, salúfuri, íweru, iyéeni, marásualugu. ");
INSERT INTO cabNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ligía buri cátei le adǘgübalin wügǘri lun marúman lan, ánjeinti leigíniwa machibúnga újabu según jagáburi juríu marúmadagüdün lumúti ligíbugiñe Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ába láfuridun Jesúsu ñígiñe, ába lídin lídoun buri fulásu geyégua láu fulásu le Tíro lúma Sidón. ");
INSERT INTO cabNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ñíñoun ában wǘri jádaangiñetu Cananítagu aganoúti lídan fulásu ligía, ába tiábin luágun Jesúsu agúarajeina. —¡Nabúreme, ladǘgawagun Davíd, gudémená bun! Níjein ában espíritu wuríbati tuágu nisáani, weíriti tasúfurirun lurúma. ");
INSERT INTO cabNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Moúnabun lumútu Jesúsu. Ábati jayábin disípulugu, ába jayúmuragun lun, ába jaríñagun. —Adǘgabeí le tamúriajabei búma, ladǘga nuteíntia agúarajeina wárigi. ");
INSERT INTO cabNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ába laríñagun Jesúsu. —Joún rügǘñein gürígia féridijaña ja Israelítagu loúnajana Búngiu lun níderaguniña. ");
INSERT INTO cabNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ába tiábin wǘri tugúya, ába tájuduragun ligíbugiñe, ába taríñagun. —¡Nabúreme, íderagua bána! ");
INSERT INTO cabNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ába laríñagun Jesúsu tun. —Lúnti níderaguniña numútuniña ja juríu furúmiñe, mabuídunti lun tagídarúniwa fein jaweí isáanigu lun tíchugúniwa joun oúnli. ");
INSERT INTO cabNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ába taríñagun. —Ánja, Nabúreme, láu sun líra, gayáraati jeígini oúnli ífei le áburujati lueígiñe jadábulan jabúriña. ");
INSERT INTO cabNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ábati laríñagun Jesúsu tun. —Wǘri, ¡weíriti gíñe bafíñen! Susérelá le babúseerubei. Lúmagiñe óra ligía, ába tareídagun tisáani. ");
INSERT INTO cabNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ába láfuridun Jesúsu ñígiñe, ába lachǘlürün lárun dúna Galiléa, lárigiñe, ába laweínrun luágun ában wǘbü, ába lañúurun ñi. ");
INSERT INTO cabNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ába jayábin sarágu gürígia le ñíjin lubeí barüína jagía meíbuguntiña, maríjintiña, maríñaguntiña, danímaati jarǘna, jáma sarágu jawúyeri sánditiña. Ába jíchuguniña lubádu lugúdi Jesúsu, ába lareídaguagüdüniña. ");
INSERT INTO cabNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ába laweíridun janígi gürígia láu jaríjin adímurejaña jamá já meja maríñagadibaña, areídagua ja danímaabaña arǘna, eíbuga ja meíbuguñajabaña, aríja ja maríjiñajabaña. Ába jagúmeserun adímureja weírigu luágu Jabúngiute Israelítagu. ");
INSERT INTO cabNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ábati lagúarun Jesúsu joun láni disípulugu, ába laríñagun joun. —Gudémetiña gürígia ja nun ladǘga ǘrüwaali wéyu jáu núma ya áni úaali ni cáta jáma lun jeígin. Mabúseeruntina noúnajaniña jábiñoun meíginga, dagá líñein falálaü jawágu ǘmada. ");
INSERT INTO cabNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ábati jaríñagun láni disípulugu lun. —¿Ída lubáti wadárirun eígini joun sarágu gürígia ya lídan fulásu le ñí lumuti úa jamá aganoútiña? ");
INSERT INTO cabNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ába lálügüdüniña Jesúsu. —¿Átiriñoun fein júma? Ába jaríñagun. —Sédü, jáma biánraü úduraü. ");
INSERT INTO cabNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ába laríñagun joun gürígia lun jañúurun múarugu, ");
INSERT INTO cabNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ába lanǘgünun sédü fein jáma úduraü jagía lújaburugu, ába leteíngiruni Búngiu. Ába lagúbachagunun fein, ába líchugunun joun láni disípulugu jáu sun úduraü, ába jafánreinjanun joun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Joútiña súngubei quimúle, buíngüda gíñe sédü faníñe táu to ígiraguboun. ");
INSERT INTO cabNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","¡Gádürüñanu mílu wügǘriña eígitiña, mabájüdünga würíña jáma irájüñü! ");
INSERT INTO cabNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lárigiñe, ába loúnajaniña Jesúsu gürígia águyu, ába ládinun tídoun ugúnein, ába lídin loúbawagun Mágdala. ");
INSERT INTO cabNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ába joúdin fariséogu jáma saduséogu aríjei Jesúsu. Lun jáburugüdüni tídoun sádara, ába jaríñagun lun lun larúfudun ában seíni láuti miláguru le siélugiñeti joun, afíñe jamámuga luágu lúmagiñe lan Búngiu liábin. ");
INSERT INTO cabNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ába laríñagun joun. —Rábounwéyu, ába jaríñagun. “Buídubei dan ladǘga funáti siélu.” ");
INSERT INTO cabNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Bináafin, ába jaríñagun. “Wuríbabei dan ugúñe ladǘga funáñu líña siélu áni jamúñounga.” ¡Biángua tigíbu jugúya le! Subúditi luáguti ligáburi dan jun, áni ibídiñeti jun luágu chülǘjali lan lidáani asálbaruni. ");
INSERT INTO cabNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gürígia wuríbatiña, múaraantiña ja, amúriajatiña seíni láuti miláguru lun jafíñerun luágu áu lan anǘgübei asálbaruni joun gürígia. Wel, marúfudúnbei ámu seíni joun lueí liseíni Jonás. Ába lígiruniña, ába lídin. ");
INSERT INTO cabNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Dan le jájiñuragunbei disípulugu lúma Jesúsu loubáfurugun dúna, bulíei jamúti janǘgün fein. ");
INSERT INTO cabNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ábati laríñagun Jesúsu joun. —Toúnigigua jumátia júngua lueí jísite fariséogu jáma saduséogu. ");
INSERT INTO cabNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ába jagúmeserun disípulugu aríñaga jámagua. —Ladǘgatia manǘgün wamá fein laríñagunbei ítara. ");
INSERT INTO cabNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ába lasúbudiruni Jesúsu, ába laríñagun joun. —¿Ca uágu jadíjerida luágu úa tan fein júma? ¡Loúguati gíñe jafíñen! ");
INSERT INTO cabNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Úagili gunfaráanda jumá, marítagun jugúya tuágu seíngü fein to nafánreinjaboun jádan seíngü mílu wügǘriña lúma átiriñein lan faníñe táu ígiragutu? ");
INSERT INTO cabNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Bulíeiguatün funásan tuágu sédü fein to nafánreinjaboun jádan gádürü mílu wügǘriña lúma átiriñein lan faníñe táu ígiragutu? ");
INSERT INTO cabNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ída liñági meféen jubeí luágu máma lan tuágu fein nadímureja dan le naríñagunbei jun lun joúnigiragun júngua lueí jísite fariséogu jáma saduséogu? ");
INSERT INTO cabNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ába gunfaráanda jamáni luágu máma lan luágu tísitena fein laríñaga joun, lueí lan arúfudajaní le jáni fariséogu jáma saduséogu lawéridiraña. ");
INSERT INTO cabNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Dan le lachǘlürün Jesúsu ubúrugu Cesaréa le Filípo ába lálügüdüniña láni disípulugu. —¿Cátanasan lídan jarítagun gürígia, áu le Wügǘri Garaǘwarügüti? ");
INSERT INTO cabNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ába jaríñagun. —Añájein aríñagutiña luágu Juan lan lé meja abásteragüdajabei amǘrü, jíbiri aríñaga luágu Elías ban, añájeingua aríñagutiña luágu Jeremías ban o ámu lan proféta. ");
INSERT INTO cabNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ábati laríñagun joun. —Ánti jugúya, ¿cátanati lídan jarítagun? ");
INSERT INTO cabNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ába laríñagun Simón Pédro lun. —Crístu le Liraǘ Búngiu le wínwanbei amǘrü, le ñǘbinbei asálbaraña gürígia uboúagu. ");
INSERT INTO cabNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ába laríñagun Jesúsu lun. —Fuleíseiwatibu Simón, liraǘ Jonás, ladǘga máma lasúbudirágüdün ni ába gürígia cátei le bun, lasúbudiragüdün Núguchi Búngiu le siélubei bun. ");
INSERT INTO cabNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Naríñajare bun luágu Pédro lan amǘrü, líla íri ligía, “dǘbü”, luáguba ébuu le nábunaguoun nilígilisin, áni ni íbini oúweni mabáfubei tuágu. ");
INSERT INTO cabNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Níchugubei ligélen arúeijani le lánina siélu bun, le cátei le uáguti baríñaga luágu moun lan jadǘgüni afíñetiña, ligía gíñe uágubei laríñaga Búngiu luágu siñá lan ladügǘniwa, le cátei le uáguti baríñaga luágu gayára lan ladügǘniwa, ligía gíñe le uágubei laríñaga Búngiu luágu gayára lan ladügǘniwa. ");
INSERT INTO cabNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ábati laríñagun Jesúsu joun láni disípulugu lun maríñagun jamá ni ca un luágu ligía lan Crístubei. ");
INSERT INTO cabNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lúmagiñe dan ligía, ába lagúmeserun Jesúsu aríñaga joun láni disípulugu furáangu luágu lúnti lan lídin Jerusalén, luágu gíñe jasúfuriragüdübei lan wügǘriña weírigutiña lídan jafíñen juríu, jáma jábutigu jafádirigun juríu, jáma arúfudajatiña lilúrudun Moisés. Aríñagati joun luágu láfarúba lan jilágubei, áni lásaaruba lan luágu lǘrüwan wéyu. ");
INSERT INTO cabNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ába ladíñurun Pédro láu Jesúsu ñígiñe murúsun, ába laríñagun lun táu sun lanígi. —¡Mabúseeraleí Búngiu líra, Nabúreme! ¡Siñáti lasúseredun cátei le bun! ");
INSERT INTO cabNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ába lagáraragun Jesúsu, ába laríñagun lun Pédro. —¡Dísebá nueí, Máfia! Babúseerúña beréderuni ladügǘniwa lugúndan Búngiu. Masáminaruntibu quei Búngiu, basáminarun quei wügǘri. ");
INSERT INTO cabNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ábati laríñagun Jesúsu joun láni disípulugu. —Le busénti lafálarunina, bulíeileí cáteiñein lan, awándaleí sun luwúyeri asúfuriruni le lúnbei liábin lun nueígiñe queísi lanǘgüni ában wügǘri lugúruwan, falálana. ");
INSERT INTO cabNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ladǘga le abúseeruti leséfuragun lúngua ya uboúagu leféridirubei ibágari le magúmuchaditi, ánjein le ánjabei leféridiruni libágari ya uboúagu nueígiñe, libíjubei ibágari le magúmuchaditi siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Cági ju lan lun gürígia lagáñeiruni sun le lánina uboú le, leféridireime lubára siélu? Úati ni cáta lánina uboú le áuti gayára lan lagáñijan gürígia ubáraü siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nagíribuduba, áu le Wügǘri Garaǘwarügüti, úara jáma náni ánjeligu, niábinba láu uweíriguni le meme láni Núguchi. Ábameti nafáyeiruniña gürígia quei ligáburi le adǘga jamáalibei. ");
INSERT INTO cabNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ninárün jáu luágu añájein lan jádaangiñe ja yábaña guetó, moúnwenbaña daríme jaríjini liábin narúeijan, áu le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sísi wéyu lárigiñe, ába lanǘgüniña Jesúsu Pédro, Jacóbo, lúma Juan le lamúlen Jacóbo, ába lídin jáu luágu ában wǘbü íñuti, jagía rügǘñanu ñi. ");
INSERT INTO cabNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ába lámuñedagun larijín Jesúsu ñi jagíbugiñe, ába lámiridun ligíbu quei wéyu, ába tájarudun lanáangun quei larúgounga. ");
INSERT INTO cabNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sódini ába jaríjini Moisés lúma Elías (já meja abágaridubaña lídan dan le sügǘjalibei) ayánuja lúma Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ába laríñagun Pédro lun Jesúsu. —Nabúreme, ¡lídan dan awánja lan ya! Ánjabu busén, adǘga wagíame ǘrüwa dibásein ya, ában bun, ában lun Moisés, ában lun Elías. ");
INSERT INTO cabNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dan niján lan Pédro adímureja, ába liábin ában juánriñu miríti, ába loúburaguniña, ába lagaambúniwa ában umálali lídaangiñe juánriñu ligía le aríñagubei. —Niján niraǘ le jínsiñebei nun, le aúbei oúnwenbun lan nugúndan, adǘga jumeí le lubeíbei. ");
INSERT INTO cabNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Dan jagáambuni disípulugu, ába jabúluchagun láu jagíbu múarugu le luweírin janúfude. ");
INSERT INTO cabNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ába liábin Jesúsu jawágun, ába lagúrurun jawágu, ába laríñagun joun. —Sarájuma, manúfudeda jumá. ");
INSERT INTO cabNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Dan le jaríjinbei, maríjinjaña ámu lueídügü Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dan le arárireina jamáni wǘbü, ába laríñagun Jesúsu joun. —Mabájudagua jumeítia cátei le aríja jumáalibei lun ni ában daríme saráadina, áu le Wügǘri Garaǘwarügüti, lídaangiñe oúweni lúnya nabágaridun. ");
INSERT INTO cabNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ábati jaríñagun disípulugu lun Jesúsu. —Guetó subúdi wamáali luágu amǘrü lan Crístubei. Quei ítara líña lubeí, ¿cáti uágu jaríñaga arúfudajatiña lilúrudun Moisés luágu lúnti lan liábin Elías lubáragiñe liábin Crístu? ");
INSERT INTO cabNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ába laríñagun Jesúsu joun. —Inárüni luágu liábinba lan Elías, ábame líchugun sun cátei lídoun lubúdubu, ");
INSERT INTO cabNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","áni naríñajare jun luágu ñǘbinjali lan Elías, masúbudirun jamúti gürígia, adǘgarügü jamúti sun le jabúseerubei láu. Ítara lúba gíñe jasúfuriragüdünina, áu le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ábati jasúbudiruni disípulugu luágu Juan lan lé meja abásteragüdajabei, ligía lan Elíasbei le uágubei ladímureja Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Dan le jachǘlürünbei le ñíjin jabeí gürígia, ába liábin ában wügǘri lúmoun Jesúsu, ába lájuduragun ligíbugiñe, ába laríñagun lun. ");
INSERT INTO cabNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Nabúreme, gudémelá nisáani bun, goúwejaditi, weírititi lasúfurirun, níjein dan jeíguati wáturugun, níjein dan dúnarugun. ");
INSERT INTO cabNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Barǘ numuti ñájoun joun báni disípulugu, siñá jamuti areídaguagüda. ");
INSERT INTO cabNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ába loúnabun Jesúsu. —¡Gürígia mafíñeraditiña, gürígia wuríbatiña! ¿Átiribeísan dan lun neréderuni júma lubá gayára lan jafíñerun nuágu? ¿Ídame lagúmucha mafíñeni le jídaanbei? Barǘjumei irájü ligía ñájoun. ");
INSERT INTO cabNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ábati ladeínjan Jesúsu lun espíritu wuríbati ligía, ába láfuridagüdüni lídaangiñe lúmagiñe óra ligía, ába lareídagun irájü le. ");
INSERT INTO cabNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Lárigiñe, ába jadímurejan disípulugu lúma Jesúsu jábugua, ába jálügüdüni. —¿Cásan uágu siñá wabalin espíritu wuríbati ligía aságara? ");
INSERT INTO cabNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ába laríñagun Jesúsu joun. —Ladǘga liloúguan jafíñen. Ninárün jáu luágu ánjein lan ibíja jubeí fe íbini ñǘraüraü lan quei ában tágu mostása, jaríñaguba lun wǘbü le. “Gidába yágiñe, beíba lídoun ámu fulásu”, ábame lagídarun wǘbü ligía. Úabei ni cáta jásiñerun ánjein ibíja jubeí fe le tímatimaati. ");
INSERT INTO cabNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ánjeinti jíbe espíritugu ja, láu rügǘñein ayúmuraguni lun Búngiu lúma ayúnaruni gayára lan jaságarúniwa. ");
INSERT INTO cabNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dan le eíbugeina jamá úara loúbawagu Galiléa, ába laríñagun Jesúsu joun luágu ledéregerúaba lan, ligía le Wügǘri Garaǘwarügüti, jájaburugun wügǘriña wuríbatiña, ");
INSERT INTO cabNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ábame jáfaruni jilágubei, áni lásaaruba lan lídaangiñe oúweni luágu lǘrüwan wéyu. Ába jírudagun sarágu dan le jagáambuni cátei le. ");
INSERT INTO cabNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Dan lachǘlürün Jesúsu jáma láni disípulugu Capernaúm, ába joúdin ja agúburajabalin tiseínsuna témpulu to Jerusalénboun lúmoun Pédro, ába jaríñagun lun. —¿Mafáyeijantisan jumáesturun tiseínsuna témpulu? ");
INSERT INTO cabNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ába loúnabun Pédro, ába laríñagun lun. —Afáyeijati. Dánti lebélurun Pédro múnadoun, ába lálügüdüni Jesúsu Pédro lubáragiñe gayára lan ladímurejan. —¿Ída líña baríjin lun líra, Simón? ¿Cátaña jagúburajabaña urúeigu ja lánina uboú le, jásan lílana fulásu ódi ja teréncha? ");
INSERT INTO cabNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ába laríñagun Pédro lun. —Ja teréncha. Ába laríñagun Jesúsu lun. —Játi lílana fulásu jáledi moún lumuti lubeíti jafáyeijan, áu le Liraǘ Búngiu, moún lumuti nafáyeijan tiseínsuna lúban Núguchi. ");
INSERT INTO cabNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lun magáñidagüdün wamá ni ában, beíba, ábame bachǘrunun bürǘnjüre dúnarugun, ábame badígini furúmiñeti úduraü le eígiti bun. Badáriruba ában seínsu liyúmulugu úduraü ligía, buídurügübei lun bafáyeijan wawoúgua láu, ábame bafáyeiruni. ");
INSERT INTO cabNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lídan dan ligía, ába jayábin disípulugu lúmoun Jesúsu, ába jálügüdüni. —¿Cáteisan weírigutimaabei lídan larúeijan Búngiu? ");
INSERT INTO cabNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ába lanǘgün Jesúsu ában irájü, ába líchuguni jamídan jámagua, ");
INSERT INTO cabNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ába laríñagun. —Ninárün jáu luágu ánjaün lan mayábin lun jítaradun quei irájüñü, mebélubadün lídoun larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ítara líña lubeíti, le ñǘraüti lanáangun lúngua, ñǘbin ligía lun ítarabei lan quei ában irájü, ligía weírigutimaabei lídan arúeijani le lánina siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Gürígia gíñe le erésibiruti ában irájü lídan níri resíbi lumútina gíñe. ");
INSERT INTO cabNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‘Furúmieguarügü le afígoungüdüti ában jádaangiñe ja isérigiñabaña lídan jafíñen nuágu, buítimaati jamúga lun lun lagurúniwa baránajoún láu ában oúnwenbun dǘbü le amúligülei güráñu luágu ligíina sügǘ láu ladǘgüni cátei líra. ");
INSERT INTO cabNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Wuríbati lun uboú, níjein lán buri cátei le afígoungüdübaliña gürígia! Súnwandan ñíbei lan, áni ¡fugiábu le wügǘri le lébunabei! ");
INSERT INTO cabNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","‘Ligía ánjein lubeí lafígoungüdǘbadibu lubeí bújabu o bugúdi lan, dürǘbei, fíbei díse buáriua, buítimaati lun bebélurun siélun májabuga o magúdiga, sügǘ láu badarún láu biángubei bújabu lúma biángubei bugúdi máfiougatin le ñí lubei wátu le méñeguchadibei. ");
INSERT INTO cabNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ánjein bágu lubeí afígoungüdǘbadibu, sagábei, fíbei díse buáriua, buítimaati lun bebélurun siélun máguga sügǘ láu badarún láu biángubei bágu máfiougatin. ");
INSERT INTO cabNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‘Manǘga jumá ni ában jádaangiñe ja ǘnabugububaña ja quei ni cáta. Naríñajare jun luágu ligíbugiñeñanu lan Núguchi Búngiu le siélubei ánjeligu ja aríjubaña jáu afíñetiña ja súnwandan. ");
INSERT INTO cabNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ladǘga asálbarei le féridijalibei yebe niábin, áu le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","‘¿Ída líña jaríjin lun? Ánjein añájein lubeí san mudún lúma ában wügǘri, teféridira ában jádaangiñe, ¿ma lígirubaña jíbiri luágu wǘbü, ábame lídin áluajoun to ayúridaguboun? ");
INSERT INTO cabNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ánjounti ladárira, choúruti luágu gúndaabei lan táu sügǘ jáu ja mayúridagunbaña. ");
INSERT INTO cabNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ítara líña giñéti, mabúseerunti Júguchi Búngiu le siélubei lun leféridirun ni ában jádaangiñe ǘnabugutiña ja. ");
INSERT INTO cabNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","‘Ánjein adǘga bidúje ában wuríbani bun, badímureja lúma jábuguarügü, ábame basúbudiragüdüni lidúnrun lun. Ánjein adǘga gásu báu, gamádaguayáadün. ");
INSERT INTO cabNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ánjein madǘgün gásu báu, ábame banǘgün ában o bián gürígia jánwoun lun sun lan le aríñawagúti, añájein jamámuga ámu geféentiña luágu. ");
INSERT INTO cabNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ánjein madǘgün gásu jáu, ábame baríñaguni lun jadámurin afíñetiña, ánjein madǘgün gásu láu adámurini, ábame banǘgüni quei ában mafíñeti luágu Búngiu o quei lan ában agúburajati liseínsuna gumádi, gayára lámuga lasáansiruni luríban ligáburi. ");
INSERT INTO cabNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‘Ninárün jáu luágu le lan cátei le uáguti jaríñaga jugúya disípulugu luágu moun lan jadǘgüni afíñetiña, ligía gíñe uágubei laríñaga Búngiu luágu siñá lan ladügǘniwa, le cátei le uágubei jaríñaga luágu gayára lan ladügǘniwa, ligía gíñe le uágubei laríñaga Búngiu luágu gayára lan ladügǘniwa. ");
INSERT INTO cabNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","‘Naríñajare gíñe jun luágu ánjaña lan úarada biáma jídaangiñe ya uboúagu lun jamúriajan ában cátei lúma Búngiu le siélubei, líchugubei jun, ");
INSERT INTO cabNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ladǘga le ñí jamuti biáma o ǘrüwa oúndaragu lídan níri, anájein ñi jamídaangua. ");
INSERT INTO cabNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ába layárafadun Pédro lun Jesúsu, ába laríñagun lun. —Nabúreme, ¿átiribeísan weíyaasu ladǘgün nibíri ában wuríbani nun lun ferúduna méme náani? Darí sédü weíyaasu? ");
INSERT INTO cabNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ába laríñagun Jesúsu lun. —Maríñaguntina bun luágu darí lan sédü weíyaasu lúnti ferúduna báani, darí ǘrüwa-wein-díisi weíyaasu sédü. ");
INSERT INTO cabNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","‘Ligía ítara líña lubeí arúeijani le lánina siélu quei ában urúei le ñǘbinbei lun laráansejan luágu seínsu jáma lumúsuniña. ");
INSERT INTO cabNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lagúmesera adǘgei, ába janǘgün ában le adúweirubalin sarágu míñun fiádürü, ");
INSERT INTO cabNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","quei maseínsun lan lun lafáyeijan, ába laríñagun urúei lun lalúgurúniwa idámunime táu sun lúmari, lirájüñü, lúma sun le lúmabei lun lafáyeiruni ladúweijan. ");
INSERT INTO cabNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ába lájuduragun músu ligía ligíbugiñe urúei, ába layúmuragun lun ítara. “Nabúreme, gagúraasunbá nubá, nafáyeirubei sun le nadúweirubei bun.” ");
INSERT INTO cabNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ába lagúdemedagun lun urúei, ába ferúduna láani ladúweiruni, ába lígiragüdüni. ");
INSERT INTO cabNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Quei láfuridun músu ligía ñígiñe, ítara ladúnragun lúma ában músu líledi le adúweirubalin átiri fiádürü. Ába lárügüdüni lueígiñe ligíina, ába lagúmeserun achócurei, ába laríñagun lun. “Fáyeibeí le badúweirubalina.” ");
INSERT INTO cabNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ábati lájuduragun ligíbugiñe, ába layúmuragun lun ítara. “Gagúraasunbá nubá, nafáyeirubadibu.” ");
INSERT INTO cabNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Májati le ában, ñǘdünrügü ligía ába ládaruni furísunrugun darí lafáyeiruni ladúweijan. ");
INSERT INTO cabNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Dan le jaríjinbaalin ja jíbiri músu cátei le, ába lagáridun joun sarágu, ába joúdin, ába jabájüdaguni lun urúei. ");
INSERT INTO cabNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ába loúnajan urúei oúgei, ába laríñagun lun. “¡Músu wuríbati! Ferúduna numúti sun badúweijan ladǘga bayúmuragun nun. ");
INSERT INTO cabNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Lúnti yebe gíñe gudéme lan boúba bun quei bagúdemedun nun.” ");
INSERT INTO cabNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ába lagáñidun urúei sarágu, ába líchugun dimúrei lun jasúfuriragüdüni daríme lafáyeiruni sun ladúweijan. ");
INSERT INTO cabNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ába lásurun Jesúsu aríñageina. —Ítara lúba gíñe ladǘga Núguchi Búngiu le siélubei jun ánjaün úa ferúduna láani cáda ában jídaangiñe libíri tídaangiñe lanígi. ");
INSERT INTO cabNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lárigiñe laríñaguni Jesúsu sun cátei le, ába lídin Galiléagiñe lun loúbawagun Judéa le lueígiñebei oúbaü le ñígiñe lubeí laboúcha wéyu libíti Jordán. ");
INSERT INTO cabNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Sarágu jáña gürígia afálaruti, ába lareídaguagüdüniña sánditiña ñi. ");
INSERT INTO cabNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ábati jayábin fiú fariséogu lúmoun Jesúsu áluga jáburugüdüni tídoun sádara, ába jálügüdüni. —¿Según barítagun, gayáraatísan lígirunun gürígia lúmari lueígiñe furúmieguarügü cátei? ");
INSERT INTO cabNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ába loúnabun Jesúsu. —¿Malíijangidün tídan Lerérun Búngiu luágu lúmagiñe lan furúmiñeti dan, dan le ladǘgünbaliña Búngiu gürígia, adǘga lumúti wügǘri, adǘga wǘri? ");
INSERT INTO cabNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aríñagati gíñe. “Ligía lígirubei lubeí wügǘri lúguchi túma lúguchu lun laganoúniwa túma lúmari, ábame jeréderun quei ábanrügü.” ");
INSERT INTO cabNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mámaaña lubeíti biáma, ábanrügaaña. Ligía moún lubei lafánreinraguni wügǘri le ladúnraguagüdübei Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ábati jálügüdüni. —¿Cáti uágu laríñaga lilúrudun Moisés lun lan tíchugúniwa gárada lánina ígiraguni tun wǘri lun tigirún? ");
INSERT INTO cabNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ába laríñagun Jesúsu joun. —Ladǘga tidére janígi lánjarunbei Búngiu lun jígiragun jáma júmarigu, máma líña meja furúmiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Naríñajare jun luágu furúmieguarügü lan le ígirutu lúmari ába lagámaridun ámu, ladǘgüña adultériu, mámarügaali ligía ladǘga tagámaridun ligíbuagun, le gíñe agámariduti wǘri to ígiraguaaru, ladǘgüña gíñe adultériu. ");
INSERT INTO cabNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ábati jaríñagun láni disípulugu lun. —Ánjein ítara líña lubeí luáguti wügǘri túma lúmari, buítimaati lubeí lun magámaridun jamá gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ába laríñagun Jesúsu joun. —Másutiña gayára jabágaridun mámariga, ja rügǘñanu únbaña rújali lan Búngiu ubáfu. ");
INSERT INTO cabNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ámuñegueinarügüti lébuna magámaridun jamá wügǘriña, añájein, ítaragubeíñanu lúmagiñe jagǘriajoún, jíbiri, adügǘwarügüti joun, jíbiri, reídeitiña magámaridunga lun jedéregeragun joúngua le gumúti lun jesériwidun lun Búngiu. Le gabáfubei lun magámaridun lan, magámaridalá. ");
INSERT INTO cabNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ába janügǘniwa irájüñü lun Jesúsu lun líchuguni lújabu jawágu lúma lun layúmuragun lun Búngiu jawágu, ába jagúmeserun disípulugu adeínja joun ja anáajabaliña. ");
INSERT INTO cabNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ába laríñagun Jesúsu joun. —Ígira jumá lun jayábin irájüñü nun, mamájara jumá, ladǘga ja jarúmabaña afíñe quei irájüñü, jagía lílana arúeijani le lánina siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ába líchuguni lújabu jawágu irájüñü jagía, lárigiñe, ába lídin lídaangiñe fulásu ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ába lídin ában wügǘri ñǘraügili aríjei Jesúsu, ába laríñagun lun. —Maésturu buíti, ¿cásan cátei buíti lúnbei nadǘgüni lun nibíjini ibágari le magúmuchaditi? ");
INSERT INTO cabNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ába laríñagun Jesúsu lun. —¿Ca uágu baríñaga nun “buíti”? Ában rügǘñein buíti, Búngiu. Ánjein busén bubei bibíjini ibágari magúmuchaditi, gúnfulibá lúma gumádi. ");
INSERT INTO cabNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ába laríñagun wügǘri ligía lun. —¿Cáteigi buri? Ába laríñagun Jesúsu lun. —Máfarajabá, magámaridabá wǘri gámaritu, míwerujabá, madímurejabá iyéeni luágu ni ában, ");
INSERT INTO cabNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","inébe jamá bagǘbürigu bun, jínsiñe jagíame gürígia bíledigu bun quei bínsiñegua búngua. ");
INSERT INTO cabNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ába laríñagun lun. —Gúnfuli numúti sun le lúmagiñe ñǘraügidina, ¿cági ámu nemégeirubei? ");
INSERT INTO cabNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ába laríñagun Jesúsu lun. —Ánjein busén bubei buídu ban le gumúti, alúgurabeí sun le búmabei, ábame bíchuguni lebégi joun gudémetiña, ábame bibíjin irísini siélu, ábameti biábin, ábame bafálarunina. ");
INSERT INTO cabNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dan lagáambunbalin wügǘri ligía cátei le, májati, ladǘga weíribalin Jesúsu cába lan ladǘgti lirísin, ába lídin láu íruni. ");
INSERT INTO cabNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ábati laríñagun Jesúsu joun láni disípulugu. —Ninárün jáu luágu jénreengu lan lun lebélurun ában rísiti lídoun arúeijani le lánina siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aríñagaya numúti jun luágu ménreenguntima lan lásügürün ában caméyu lídaangiñe lujúyun ában agúsa, sügǘ láu lebélurun ában rísiti lídoun arúeijani le lánina siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Dan jagáambuni disípulugu cátei le, ába laweíridun jan-balin Jesúsu cába lan ladǘgigi sarágu, ába jálügüdagun jámagua. —¿Cáteiti gayáraabei lasálbarun? ");
INSERT INTO cabNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ába laríaguniña Jesúsu, ába laríñagun joun. —Siñáti jasálbaragun gürígia joúngua, ánjein Búngiu, gayára lumúti sun cátei adǘga. ");
INSERT INTO cabNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ábati laríñagun Pédro lun. —Nabúreme, wagía, ígira wamáali sun lé meja wámabei lun wafálarunibu. ¿Cábasanti wabíja? ");
INSERT INTO cabNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ába laríñagun Jesúsu joun. —Ninárün jáu luágu lídan lánme dan ligía dánme iséri lan sun cátei, dánme le nañúurun, áu le Wügǘri Garaǘwarügüti luágu nála yágüta siélu lun narúeijan láu sun nuweírigun, jugúya le afálarubalina jañúuruba gíñe luágu dúusu jalaǘ lun jagúseragüdüniña dúusugubei láni Israél türíbu. ");
INSERT INTO cabNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Súnti ja ígiraañábaña jában, o jamúlenu, o játunu, o jagǘbürigu, o jasáanigu, o jamúan, nuágu, jerésibiruba san weíyaasu lánwoun, resíbi jameíme ibágari magúmuchaditi. ");
INSERT INTO cabNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Áni sarágu jáña ja furúmiñetiñábaña guetó, jagíaba agúmujoúni, sarágu ja agúmujoúnibaña guetó, jagíaba furúmiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ába laríñagun Jesúsu. —Ítara líña arúeijani le lánina siélu quei ában labúreme ichári le áfuridubei bináafingua áluaja ñadágimeintiña lun talúbajoún linádirigu. ");
INSERT INTO cabNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ába ladǘgün darádu jáma ñadágimeintiña lun líchugun fiádürü joun luágu wéyu, ába loúnajaniña ñadágimein lichárirugu. ");
INSERT INTO cabNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Lárigiñe, ábaya láfuridun queí buri ladaǘnrün néfu bináafin, ábaya ladárirun ámu wügǘriña mafísiutetiña, mágidirugu. ");
INSERT INTO cabNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ába laríñagun joun. “Jeíba gíñe ñadágimein nichárirugu, ábame nafáyeiruni lebégi juwádigimari jun.” Ába joúdin. ");
INSERT INTO cabNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ábaya láfuridun amídirugu, furí ligía ladaǘnrün ǘrüwa rábounwéyu, ligía méme ladǘga. ");
INSERT INTO cabNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Queí buri ladaǘnrün seíngü rábounwéyu, ábaya lídin mágidirugu, ábaya ladárirun wügǘriña mafísiutetiña ñi, ába laríñagun joun. “¿Cásan uágu yá jubei sun wéyu mawádigimariga?” ");
INSERT INTO cabNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ába jaríñagun lun. “Úagili ni ában álugutiwa.” Ába laríñagun joun. “Jeíba gíñe ñadágimein nichárirugu, ábame nafáyeiruni lebégi juwádigimari jun.” ");
INSERT INTO cabNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Dan le lagúñedunbei, ába laríñagun labúreme ichári lun jábuti ñadágimeintiña. “Wába joun ñadágimeintiña, fáyei bámugaña, bagúmeserame jámagiñe ja atátirubaña agúmujoúni, bagúmuchame jáma ja atátirubaña furúmiñe.” ");
INSERT INTO cabNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ábati jayábin ja atátirubaña ñadágimein queí buri ladaǘnrün seíngü rábounwéyu, ába jibíjin fiádürü cáda ában. ");
INSERT INTO cabNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lárigiñe, dan le lachǘlürün jadáani ja atátirubaña furúmiñe, ába jarítagun luágu gíbetimaabei lan jabíjin. Ába gíñe jabíjin fiádürü cáda ában. ");
INSERT INTO cabNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dan le jerésibiruni jaseínsun, ába magúndan jamá lúma labúreme ichári, ");
INSERT INTO cabNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ába jaríñagun. “Ja ñǘbinbaña agúmujoúni, ában rügǘñein óra jawádigimari, ában lábu bafáyeiruniña quei wagía, wagía le awándubalin wadágimanu lúma lísüga sun wéyu.” ");
INSERT INTO cabNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ába loúnabun labúreme ichári, ába laríñagun lun ában jádaangiñe. “Numáda, máma nadǘgüña ni murúsun maríchaü jun. ¿Ma funági luágu ában fiádürü jadǘga darádu núma? ");
INSERT INTO cabNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Barǘjumei jiseínsun, jeíba. Nafáyeiruñanu ja atátirubaña agúmujoúni quei nafáyeirunün ladǘga ítara líña lan nabúseerun. ");
INSERT INTO cabNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Maríchatina funági lun nadǘgüni le nabúseerun láu niseínsun? ¿Ódi gimúgatün ladǘga nubuídun?” ");
INSERT INTO cabNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ítara líña lubeíti, sarágu jáña ja agúmujoúnibaña guetó, jagíaba furúmiñetiña, sarágu jáña gíñe ja furúmiñetiñábaña guetó, jagíaba agúmujoúni. Ladǘga sarágu jáña agúarútiña áni míbetiña anúadirútiña. ");
INSERT INTO cabNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Dan le niján lan Jesúsu luágu ǘma lun Jerusaléoun, ába ladíñurun jáu láni dúusu disípulugu jaweí ja jíbiri gürígia ja luágubaña ǘma úara jáma, ába laríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Quei lubeí jaríjini, aweínreina wáña Jerusaléoun le ñíba lubeí nedéregerúa, áu le Wügǘri Garaǘwarügüti, joun jábutigu jafádirigun juríu lúma joun arúfudajatiña lilúrudun Moisés, ja lúnbaña jasíadirunína lun noúnwen. ");
INSERT INTO cabNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ábame jedéregerunina joun ja mámabaña juríu lun jéjerajan náu, áfara jamáname, ábame jádaragunina luágu gurúwa, áni násaaruba lídaangiñe oúweni luágu lǘrüwan wéyu. ");
INSERT INTO cabNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ábati tiábin jáguchu Jacóbo láu Juan, ja lisáanigu Zebedéo, lúmoun Jesúsu jáu tisáanigu, ába tájuduragun lun tamúriajan ában fuleísei lúma. ");
INSERT INTO cabNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ába laríñagun tun. —¿Ca babúseerubei? Ába taríñagun lun. —Aríñagabá lun jañúurun bián nisáanigu ja, ában lueígiñe boúnwenren, ában lueígiñe bubaǘna yágüta lídan barúeijan. ");
INSERT INTO cabNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ába laríñagun Jesúsu joun. —Ibídiñeti jun ca lan jamúriajabei. ¿Gayáraati jawánduni luweírin igárigu le lúnbei nawánduni, gayára ligíame júaradun núma lídan nasúfurirun? Ába jaríñagun. —Gayára wabeí. ");
INSERT INTO cabNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ába laríñagun joun. —Inárüni, lúnti jawánduni igárigu le lúnbei nawánduni, úara jugúyame núma lídan nasúfurirun, ánjeinti lun jañúurun lueígiñe noúnwenren lúma lueígiñe nubaǘna, máma áu lúnbei níchuguni, líchugúaba joun ja ubáabaña laráanserei Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Dan le jagáambunbalin jíbiri díisi disípulugu cátei le, ába jagáñidun jáma bián amúlenugu jagía. ");
INSERT INTO cabNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ába lagúarun Jesúsu joun, ába laríñagun joun. —Queísi jasúbudiruni, ja agúmadijabaña jádan ja mámabaña juríu arúfudaguatiña joúngua camá jamuga jabúriña lílana fulásu ligía, játi weínamubaña jádan, arúfuda jamúti jabáfu. ");
INSERT INTO cabNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ánjein jídan, máma lúba, le abúseeruti lun weíri lan jídan, lúnti lesériwiduniña jíbiri. ");
INSERT INTO cabNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Furúmieguarügü jídaangiñe le abúseeruti lun ligíaba lan furúmiñeti, lúnti idámuni lan joun jíbiri ");
INSERT INTO cabNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ítara quei máma lan niábiña, áu le Wügǘri Garaǘwarügüti, lun nesériwidúniwa, niábiña lun nesériwidun lúma lun níchuguni nibágari lebégime jasálbarun sarágu. ");
INSERT INTO cabNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Dan le áfurideina jabeí Jesúsu jáma láni disípulugu Jericógiñe, sarágu jáña gürígia afálaruti Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ñíñanu bián maríjintiña ñun láru ǘma, dan le jagáambun luágu Jesúsu lan le ásügürübei, ába jagúaragun. —¡Wabúreme, ladǘgawagun Davíd, gudéme wamá bun! ");
INSERT INTO cabNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ába jadeínjan gürígia joun lun jámanichun, ligíatima jagúaragun. —¡Wabúreme, ladǘgawagun Davíd, gudéme wamá bun! ");
INSERT INTO cabNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ába leréderagun Jesúsu, ába lagúarun joun, ába laríñagun joun. —¿Ca jabúseerubei nadǘgün jun? ");
INSERT INTO cabNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ába jaríñagun lun. —Wabúreme, buséntiwa waríjin. ");
INSERT INTO cabNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ába jagúdemedagun lun Jesúsu, ába lagúurun luágu jágu. Lúmagiñe óra ligía ába jaríjin, ába jafálaruni. ");
INSERT INTO cabNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Dan le yaráfaaña lubeí lun Jerusalén, ába jachǘlürün ligíbugiñe fulásu le gíribei Betfajé, le ǘnabubei libíti wǘbü le Olívos, ");
INSERT INTO cabNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ába laríñagun Jesúsu joun biáma jádaangiñe láni disípulugu. —Jeíba lídan liraǘraü fulásu le wagíbugiñebei, jadáriruba ában burígü güráñu ñi láu ában liraǘraü burígü túma, ábame jafáragaduniña, ábame janǘgüniña nun. ");
INSERT INTO cabNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ánjein ñi adímurejati jun lueígiñe jadǘgüni, ábame jaríñagun lun luágu busén lániña Jesúsu, luágu láguyugüdübaña lan. ");
INSERT INTO cabNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Lasúseredunbei líra lun lagúnfulirun lé meja laríñagubei proféta dan le labǘrüjanbei ítara. ");
INSERT INTO cabNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Aríñaga jumá lun ubúrugu Sión. “Niteín Burúeite bun láu ǘnabuni, waríñu lanágawagu ában burígü, waríñu luágu ában liraǘraü burígü, anímaalu anáajati ílaü.” ");
INSERT INTO cabNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ába joúdin disípulugu, ába jadǘgüni quei laríñaguni Jesúsu joun. ");
INSERT INTO cabNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ába janǘgünun burígü tugúya láu sun tiraǘ, ába jíchugunun janáangun jawágu, ába lawárirun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sarágu jañáti gürígia, ába jábudunun janáangun luágu ǘma, jíbiri, ába jáchuajan tilímun wéwe, ába jíchaajani luágu ǘma. ");
INSERT INTO cabNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dándu gürígia ja ubáraübaña quei ja árigibaña, ába jagúmeserun agúaraja. —¡Uweíriguni lun ladǘgawagun urúei Davíd! ¡Biníwati wügǘri le ñǘbinbei lídan líri Wabúreme Búngiu! ¡Uweíriguni lun Búngiu! ");
INSERT INTO cabNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Dan lebélurun Jesúsu ubúrugun Jerusalén, ába jafúudun sun ja ñíbaña, ába jaríñagun sarágu. —¿Cáteisan gürígia le? ");
INSERT INTO cabNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ába jaríñagun gürígia. —Jesúsu le, le Nazarétna, fulásu le lídaanbei Galiléa. Ligía ában proféta. ");
INSERT INTO cabNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Lárigiñe, ába lebélurun Jesúsu tídoun láni Búngiu témpulu, ába labúgaguniña sun alúgurajatiña jáma agáñijatiña ja ñíbaña. Ába lagárabaguni dábula buri le jadábulan asáansijabaña seínsu ñi joun gürígia, lúma jála ja alúgurajabaña únjun. ");
INSERT INTO cabNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ába laríñagun joun. —Laríñajare Búngiu tídan Lerérun. “Núban fulásu le ñí lubei gayára lan jayúmuragun gürígia nun”, ánjein jugúya, barǘ jumaaru quei jában jíwerutiña. ");
INSERT INTO cabNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ába jayábin fiú maríjintiña jáma danímaatiña lúmoun Jesúsu ñi témpulurugu, ába lareídaguagüdüniña. ");
INSERT INTO cabNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Dan le jaríjinbaalin jábutigu fádirigu jáma arúfudajatiña lilúrudun Moisés miláguru buri le ladáagubei, lúma dan le jagáambuni jagúarajan irájüñü témpulurugu. “¡Uweíriguni lun ladǘgawagun urúei Davíd!”, ába jagáñidun. ");
INSERT INTO cabNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ába jaríñagun lun Jesúsu. —¿Agáamba bumútisan le jaríñagubei ja? Ába laríñagun Jesúsu joun. —Ánja, agáamba numúti. ¿Malíijan jumágili tídan Lerérun Búngiu le ñí lubei laríñawagúa lun Búngiu. Adǘgaadibu lun jerémujan ñǘbürigiña jáma irájüñü ja machǘlaagiña, cátei buíti buágu? ");
INSERT INTO cabNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ába lígiruniña, ába lídin ubúrugugiñe lun Betánioun, ába lásügürüni áriebu ñi. ");
INSERT INTO cabNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Larúgan bináafin, dan le lagíribudun Jesúsu ubúrugun, ába lalámachun. ");
INSERT INTO cabNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ába laríjin ában tídibu ígo láru ǘma, ába lídin tuágun, madáriti ni cáta tuágu lueídügüya ubánaü. Ába laríñagun tun tídibu ígo tugúya. —¡Magíindadügüyabá! Lídan óra ligía ába tásaürün. ");
INSERT INTO cabNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Dan jaríjini disípulugu cátei le, ába laweíridun janígi, ába jaríñagun lun Jesúsu. —¿Ída liñásan tásaürübei tídibu ígo to ítara oúfun? ");
INSERT INTO cabNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ába laríñagun Jesúsu joun. —Ninárün jáu, ánjaün afíñe le gumúti, mámarügübei líbe le nadǘgübei tun tídibu ígo to gayára jumá adǘga, gayáraabei jaríñagun lun wǘbü le. “Gidába yágiñe, dabúba baránajoun”, ábame lasúseredun. ");
INSERT INTO cabNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Súnme gíñe cátei le jamúriajan lúma Búngiu, ánjein afíñe jubeí, jibíjubei. ");
INSERT INTO cabNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ábati lebélurun Jesúsu témpulurugun, dan niján lan arúfudaja ñi, ába jayábin jábutigu fádirigu jáma wügǘriña ábutigu lídan jafíñen juríu, ába jaríñagun lun. —¿Aríñagabeí woun ca lan biríchabei lun badǘgüni cátei le? ¿Ca íchugubalin ubáfu le bun? ");
INSERT INTO cabNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ába laríñagun Jesúsu joun. —Nálügüdaadün gíñe ában cátei, ánjein joúnaba nun, ábame naríñaguni jun ca lan áu ubáfu nadǘgei buri cátei le. ");
INSERT INTO cabNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ca oúnajabalin Juan abásteragüdaja? ¿Búngiu, ódi wügǘriña? Ába jagúmeserun adímureja jámagua, ába jaríñagun. —Ánjawa aríñaga luágu Búngiu lan oúnajabalin, laríñaguba woun ca lan uágu mafíñerun wabeí lun. ");
INSERT INTO cabNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ánjawa aríñaga luágu joúnajan lan wügǘriña, joúserubadiwa gürígia wuríba ladǘga súngubei afíñetiña luágu proféta lán. ");
INSERT INTO cabNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ábati jaríñagun lun Jesúsu. —Ibídiñeti woun. Ába giñeti laríñagun joun. —Maríñagun nubeí giñéti jun ca lan áu ubáfu nadǘgei buri cátei le. ");
INSERT INTO cabNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ába laríñagun Jesúsu joun. —Nabájüdaguá ában cátei jun, jaríñageime nun ída líña lan jaríjin lun. Ñíñein ában wügǘri, biámañanu lisáanigu. Ába laríñagun lun ában jádaangiñe. “Niraǘ, beíba ñadágimein ugúñe lídan talúbajoún ninádirigu.” ");
INSERT INTO cabNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ába laríñagun lisáani lun. “Mabúseeruntina nídin.” Lárigiñe, ába lasáansiragun larítagun, ába lídin ñadágimein. ");
INSERT INTO cabNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Lárigiñe, ába lídin úguchili aríjei le ában, aríñageinaleí le méme laríñagubeí buga lun le furúmiñeti lun. Ába loúnabun le. “Ánja, nídiba.” Mídinti. ");
INSERT INTO cabNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Aríñaga jumeí nun, ¿cági jádaangiñe biángubei adǘgübalin le labúseerubei úguchili? Ába jaríñagun. —Le furúmiñebei. Ábati laríñagun Jesúsu joun. —Ninárün jáu luágu choúrutima lan jebélurun agúburajatiña liseínsuna gumádi jáma jórugu lídoun larúeijan Búngiu sügǘ jáu, ");
INSERT INTO cabNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ladǘga ñǘbinti Juan le abásteragüdajabei arúfudaja jun ída lúba lan ligáburi jabágaridun, mafíñeruntün lun, ánjañati ja agúburajabaña liseínsuna gumádi jáma jórugu, afíñeratiña lun. Jugúya, láu sun aríja jumáni sun líra, masáansiragunti jigáburi lun jafíñerun lun. ");
INSERT INTO cabNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","‘Agáamba jumeí ábaya jémpulu le. Luáguti ában wügǘri labúreme ában ichári, ában lábunagun tídibu beíbei lichárirugu, ába ladǘgün baríeru láu, adǘga ligía ában ágei lun laríbichawagún tíra beíbei lídoun lúma ában wáyelesi lun gayára lan loúnigiruni sun cátei. ‘Ába lájayajani ichári joun ñadágimeintiña, ába lídin adǘga weíyaasu. ");
INSERT INTO cabNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Dan le lachǘlürün dan lun alúbajani, ába loúnajan jádaangiñe lumúsuniña amúriajei lufánran jámagiñe ñadágimeintiña. ");
INSERT INTO cabNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ábarüga járügüdüniña ñadágimeintiña músu jagía, buleísei jameí ában, áfara jameí ában jilágubei, rúgua jagía dǘbü luágu le ában. ");
INSERT INTO cabNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ábaya loúnajan labúreme ichári gíbetimaajaña sügǘ jáu ja loúnajabaña furúmiñe, ligía méme jadǘga ñadágimeintiña joun. ");
INSERT INTO cabNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","‘Agúmujoúni, ába loúnajani liraǘ, ába laríñagun lúnguarügü. “Inébebei niraǘ joun.” ");
INSERT INTO cabNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Dan le jaríjinbaalin ñadágimeintiña liraǘ, ába jaríñagun jámagua. “Nijánba le erésibirei alágan, wáfaraali jilágubei, reídei wamámuga láu alágan.” ");
INSERT INTO cabNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ábati járügüdüni, ába jaságaruni lídaangiñe ichári, ába jáfaruni jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ába lálügüdajan Jesúsu. —Dánmeti liábin labúreme ichári, ¿cábagi ladǘga jáu ñadágimeintiña ja? ");
INSERT INTO cabNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ába jaríñagun lun. —Láfaragubaña wuríbatiña jagía jilágubei, magúdemedagúnbaña lun, ábame lájayajani ichári joun ámu ñadágimeintiña ja lúntiña jedéregeruni lufánran lun lídaangiñe alúbajani lídan dan. ");
INSERT INTO cabNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ábati laríñagun Jesúsu joun. —¿Malíijañaja jumágiru Lerérun Búngiu? Taríñajare nuágu. Le meja dǘbü le mabúseerun jabeí ábunagutiña, ligíaali furúmiñeti. Wabúreme Búngiu adǘgübalin lun furúmiñebei lan, áni aríja wamúti quei ában cátei weíriguti. ");
INSERT INTO cabNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ligía naríñagunbei jun luágu lagídarúaba lan larúeijan Búngiu jueí, jugúya le weírigubei lídan jafíñen juríu, ábame líchugúniwa joun gürígia ja edéregeruti alúbajani le láni larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ánjeinti áu, le dǘbü ligía, furúmieguarügü le eíguaduti nuágun lañaǘrudagúba, léti uáguti leíguada nigáñi, lagúmuchaguagüdübei. Ligíaba asúsereda joun gürígia ja májabaña nun. ");
INSERT INTO cabNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Dan le jagáambunbalin jábutigu fádirigu jáma fariséogu jémpulu buri le líchugubei Jesúsu, ába jasúbudiruni luágu jawágu lan ladímureja. ");
INSERT INTO cabNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ábati jabúseerún yebe járügüdüni, madǘgün jamúti ladǘga janúfude jaweí gürígia, ladǘga afíñe jamá gürígia luágu proféta lan. ");
INSERT INTO cabNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ábaya lagúmeserun Jesúsu adímureja joun láu jémpulu, ába laríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Nijánya ában jémpulu luáguti arúeijani le lánina siélu. Ñíñein ában urúei adǘgüti ában fédu lubá lamárieidun lisáani. ");
INSERT INTO cabNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ába loúnajaniña lumúsuniña oúgaña amísurajoútiña, májatiña amísurajoútiña jayábin. ");
INSERT INTO cabNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ábaya loúnajan ámu músu, ába laríñagun joun. “Aríñaga jumá joun amísurajoútiña luágu aráanseeli lan eígini. Áfaragüda náaña bágasu jáma nilǘgüniña anímaalugu dibúnetiña, aráanseeli sun cátei, lun jayábin maríeirugu.” ");
INSERT INTO cabNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Madǘgüntiña amísurajoútiña gásu. Ába lídin ában jádaangiñe lichárigu, ñǘdün ában adǘga ámu wadágimanu, ");
INSERT INTO cabNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ja jíbiri, ába járügüdüniña lumúsuniña urúei, ába joúseruniña wuríba, ába jáfaraguniña jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ábati lagáñidun urúei sarágu, ába loúnajaniña lisúdaaranigu áfaraguaña gáfarajatiña jagía jilágubei lúma águdei jageíra. ");
INSERT INTO cabNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ába laríñagun joun lumúsuniña. “Aráanseeli sun cátei lun maríei, áni amísurajoútiña jagǘra madǘnamatiña lun jamísurajoúniwa. ");
INSERT INTO cabNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jeíba lubeíti luágu buri larígei ǘma, ábame jamísurajaniña sun ja úmatiña jadúnragua.” ");
INSERT INTO cabNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ába joúdin músu luágu buri ǘma, ába joúndaruniña sun ja úmabaña jadúnragua, buítiña jáma wuríbatiña, ába tabuínchun múna jáu gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‘Ábati lebélurun urúei aríjaña amísurajoútiña, ába laríjin ában wügǘri le madáüragunti quei lun ában maríei ñi. ");
INSERT INTO cabNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ába laríñagun lun. “Numáda, ¿ída liñági bebélurunbei ñájoun madáüragunga quei lun ában maríei?” Maní ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ába laríñagun urúei joun ja eténirubaña lún buri dábula. “Gürágua jumeí lugúdi lúma lújabu, fíjumei lídoun lubúriga le boúgudibei, le ñíba lubeí layájuaja, acǘnrijame lári.” ");
INSERT INTO cabNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ába laríñagun Jesúsu joun ja agáambubalin. —Gíbetiña agúarútiña lun jebélurun lídoun larúeijan Búngiu, míbetiña anúadiruña. ");
INSERT INTO cabNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ába joúdin fariséogu, ába júaradun aríja cába lan gayára lan jadǘgün lun jaríñagagüdüni Jesúsu cátei le uáguti gayára lan jadárirun lidúnrun. ");
INSERT INTO cabNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ábati joúnajan jádaangiñe jánigu úara jáma jádaangiñe lánigu Heródes, aríñaga lun Jesúsu. —Maésturu, subúdi wamúti luágu inárüni lan baríñagubei, luágu gíñe arúfuda báani lémeri Búngiu láu inárüni, manúfudeiga lueí ni ában, ladǘga ni cáta lan luweírigun gürígia bun. ");
INSERT INTO cabNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Rúbei lubeíti barítagun woun. ¿Buítisan lun lafáyeirúniwa seínsu lun urúei Rómana ódi mabuídunti? ");
INSERT INTO cabNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aríagu líña Jesúsu lun luríba jayúmajan, ába laríñagun joun. —¡Biángua tigíbu jugúya le! ¿Ca uágu jíchaaja sádara nubá? ");
INSERT INTO cabNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Arúfuda jumeí seínsu le áubei lafáyeijoúa liseínsuna gumádi nun. Ába janǘgün ában seínsu le denáriu lun. ");
INSERT INTO cabNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Dan laríjini, ába lálügüdüniña. —¿Ca iyáwa le luágubei seínsu le, lúma íri le bürǘwañubei luágu? ");
INSERT INTO cabNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ába jaríñagun lun. —Láni urúei Rómana. Ábati laríñagun Jesúsu joun. —Rújumeiti láni urúei lun urúei, rújumeime láni Búngiu lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dan jagáambunbalin le, ába laweíridun janígi, ába jígiruni, ába joúdin. ");
INSERT INTO cabNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wéyu méme ligía, ába joúdin fiú saduséogu aríjei Jesúsu. Jaríñajare saduséogu luágu úa lan ásaaruni lídaangiñe oúweni. Ábati jaríñagun lun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maésturu, aríñagatí meja Moisés luágu ánjein lan oúwe ában wügǘri le maríeiti masáaniguga táu lúmari, lúnti lan lamárieidun lamúlen túma wǘri to ueíboun loúwe, lun gasáanigu lan táu lun líbugaña le oúwebei. ");
INSERT INTO cabNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wel, ñíñanu méjati sédü gamúlenuguátiña ya wádan, ába lamárieidun le furúmiñeti, ába loúnwen. Quei masáanigu lubeí táu lúmari, ába lígirunun lun lamúlen. ");
INSERT INTO cabNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ligía méme suséreti lun jabíaman, lárigiñe lun jǘrüwan darí lúmoun jasédün. ");
INSERT INTO cabNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lárigiñe, ába gíñe toúnwen wǘri. ");
INSERT INTO cabNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dánmeti jásaarun lídaangiñe oúweni, ¿cábati úmari wǘri tugúya jádaangiñe sédü gamúlenuguátiña ja, lárigiñe maríei jamá sun jagía túma? ");
INSERT INTO cabNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ába laríñagun Jesúsu joun. —Bulíeiguatün ladǘga libídiñe tuáguti Lerérun Búngiu jun, ni luáguti lubáfu Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Dánme le jásaarun jiláaña lúnya jabágaridun, ámujalime jabágari, magámaridun jába, míchugun jamáñame jasáanigu lun maríei, queísi magámaridun jamá ánjeligu siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ánjeinti luágu sará jamá jiláaña lúnya jabágaridun, ¿malíijan jumágili le laríñagubei Búngiu gúanarü jun? ítara líña laríñagun. ");
INSERT INTO cabNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Áu Lubúngiutebei Abrahám, Lubúngiute Isáac, Lubúngiute Jacób.” Ítara líña lubeíti, ánjein jamúga jiláañu jáña lubeí wügǘriña jagía lun sun dan, maríñagunti jamúgati Búngiu luágu Jabúngiute lan, ladǘga máma Jabúngiute jiláguaaña Búngiu, Jabúngiute wínwangiña. ");
INSERT INTO cabNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dan jagáambunbalin gürígia cátei le, ába laweíridun janígi láu le larúfudajabei. ");
INSERT INTO cabNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Dan le jasúbudirunbalin fariséogu luágu manígüda láaña lan Jesúsu saduséogu, ába joúndaragun, ");
INSERT INTO cabNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ñíñein ában jádaangiñe le arúfudajati lilúrudun Moisés, abúseeruti laríjin lábun Jesúsu, ába laríñagun lun. ");
INSERT INTO cabNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maésturu, ¿cásan gumádi weírigutimaabei lídan lilúrudun Búngiu? ");
INSERT INTO cabNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ába laríñagun Jesúsu lun. —“Jínsiñelá Babúreme Búngiu bun táu sun banígi, táu sun buwáni, láu sun bisáminan.” ");
INSERT INTO cabNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Niján gumádi weírigutimaabei, furúmiñeti gíñe lídaangiñe sun lugúmadin Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Áni le libíaman lídan uweíriguni lenége le, ítara líña. “Jínsiñe jamá bíbirigu bun quei bínsiñegua búngua.” ");
INSERT INTO cabNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bián gumádi le, ligía ébuubei lun sun lilúrudun Moisés lúma jarúfudajan profétagu. ");
INSERT INTO cabNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sun añája lan fariséogu oúndaragu, ");
INSERT INTO cabNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ába laríñagun Jesúsu joun. —¿Cásan jarítagubei libǘgürü Crístu le lanúadirubei Búngiu lun lasálbaruniña gürígia? ¿Cásan adǘgawagun? Ába jaríñagun lun. —Ladǘgawagun Davíd. ");
INSERT INTO cabNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ábati laríñagun Jesúsu joun. —¿Ída liñáti lagúarunbalin Davíd quei Abúremein, láu lubáfu Sífiri Sándu? Aríñagatiga Davíd. ");
INSERT INTO cabNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Laríñajare Búngiu lun Nabúreme. “Ñurúba núma lueígiñe noúnwenren daríme níchuguniña báganiñu bújaburugun.” ");
INSERT INTO cabNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Ída lubáti ladǘgawagun lan Davíd Crístu ánjein wá lubali Davíd guánarü Crístu Nabúreme? ");
INSERT INTO cabNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Úati ni ában gayáraati loúnabun ni ában dimúrei, lúmagiñeti wéyu ligía, manígiti ni ában lun liábin álügüdaguei. ");
INSERT INTO cabNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ábati laríñagun Jesúsu joun láni disípulugu jáma jíbiri gürÍgia ja ñíbaña. ");
INSERT INTO cabNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Gabáfutiña arúfudajatiña lilúrudun Moisés jáma fariséogu lun jafúnraanguagüdüni líla lilúrudun Moisés. ");
INSERT INTO cabNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Agáamba jumáña lubeíti, adǘga jumeíme sun le jaríñagunbei jun, le jadǘgübei, mafálara jumeí ladǘga aríñagatiña ában cátei, jadǘga ámu. ");
INSERT INTO cabNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rújamuti gumádi joun gürígia queísi anǘgüni jǘrüti le siñábei lanügǘniwa, ánjein jagía, madǘgüntiña ni cáta lun jíderaguniña gürígia luágu buri anǘgüni lánina lúrudu le jíchugubei jawágu. ");
INSERT INTO cabNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jadǘgüni sun cátei lun jaríjiña gürígia. Jínsiñeti joun lun jíchugun tirájüñü gáfu táu Lerérun Búngiu jeréberugu lúma luágu buri jarǘna, lúma lun jadáüragun anáanguni to durúrutu. ");
INSERT INTO cabNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Buséntiña járügüdüni lubuídun-ágei ubáraü lídan eígini lúma jalaǘ le jála weírigutiña tídan jalígilisin. ");
INSERT INTO cabNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Buséntiña lun jabúsurun gürígia joun láu sarágu inébesei ǘmada, lun gíñe lagúarúniwa joun, “maésturugu”. ");
INSERT INTO cabNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‘Ánjein jugúya, mígira jumá lun laríñawagúniwa jun, “maésturugu”, ladǘga sun jugúya ában jáu, áni ában rügǘñein gíñe Jumaésturun, áu le Crístubei. ");
INSERT INTO cabNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Maríñaga jumá gíñe “núguchi” lun ni ában wügǘri uboúagu lídan ligáburi jagúaruni Búngiu le siélubei “Núguchi”. ");
INSERT INTO cabNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mígirun jugúyame lun laríñawagúniwa jun “ábutigu” ladǘga Crístu rügǘñein Jábuti. ");
INSERT INTO cabNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Le esériwidubei joun jíbiri, ligía weírigutimaabei jídan, ");
INSERT INTO cabNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ladǘga le anáanguti lúngua weíri, lǘnabudagüdǘwaba, ánjein le anáanguti lúngua ǘnabu, laweíridagüdǘwaba. ");
INSERT INTO cabNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‘¡Fugiábugu jugúya arúfudajatiña lilúrudun Moisés jáma fariséogu! ¡Biángua tigíbu!, ladǘga darú jumuti lubéneri arúeijani le lánina siélu lueí jebélurun ámu, mebélu jugúyati, mígirun lun jebélurun ja busénbaña jebélurun. ");
INSERT INTO cabNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","‘¡Fugiábugu jugúya, arúfudajatiña lilúrudun Moisés jáma fariséogu! ¡Biángua tigíbu! Gidá jumutu jában würíña ja jiláaña úmari jaweí, lúnti ibídiñewa lan, ába jadáagun ayúmuraguni lun Búngiu le migínaguti. Ligía weíritimaabei lubeí jasúfurirun lueígiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‘¡Fugiábugu jugúya arúfudajatiña lilúrudun Moisés jáma fariséogu! ¡Biángua tigíbu! Eíbuga jumúti múa, áfayaja jumeí barána áluaja gürígia lun jánigume, dánti le ibíja jumáali le jabúseerubei, ába jadǘgüniña gürígia jagía bián weíyaasu lúntima joúdin máfiougati sügǘ jáu. ");
INSERT INTO cabNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‘¡Fugiábugu jugúya, adúndejatiña maríjintiña! Aríñagatün luágu le lan gürígia íchuguti dimúrei, ánjein áfiñura tuágu témpulu mála lan líra, áni ánjein lan áfiñura luágu tigóluna témpulu, aná lan líra, lúnti lan lagúnfulirun. ");
INSERT INTO cabNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ibídiougua líña jáu, maríjin! ¿Cági weírigutimaabei, gólu ódi témpulu to adǘgüboun lun sagráubei lan gólu? ");
INSERT INTO cabNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aríñagatün gíñe luágu ánjein lan íchiga gürígia dimúrei lun láfiñurun luágu latárü, mála lan líra, áni ánjein lan áfiñura luágu cátei le adágaragüdǘwabei luágu latárü, aná lan líra, lúnti lan lagúnfulirun. ");
INSERT INTO cabNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ibídiougua líña jáu, maríjin! ¿Cági weírigutimaabei, cátei le luágubei latárü ódi latárü le adǘgübalin cátei ligía lun sagráubei lan? ");
INSERT INTO cabNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Le áfiñurubei luágu latárü, máma rügǘñein luágu latárü láfiñurun, láfiñuruña gíñe luágu sun le ligíbuagubei latárü. ");
INSERT INTO cabNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Le gíñe áfiñurubei tuágu témpulu, máma rügǘñein gíñe tuágu témpulu láfiñura, láfiñuruña gíñe luágu Búngiu le aganoúbei tídan. ");
INSERT INTO cabNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Le gíñe áfiñurubei luágu siélu, láfiñuruña gíñe luágu lála Búngiu, lúma gíñe luágu Búngiu le añúurubei luágu jalaǘ ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‘¡Fugiábugu jugúya arúfudajatiña lilúrudun Moisés jáma fariséogu! ¡Biángua tigíbu! Adǘgatün díisi fáreinti láu jíduru le ménta, anísi, lúma comíno lun jíchugun ában fáreinti lun Búngiu, áni mebéresentün láu arúfudajani le weírigutimaabei lídan lilúrudun Búngiu, queí buri lun jadǘgüni sun cátei láu úaraguni, lúma lun jagúdemedun gürígia jun, lúma lun jagúnfulirun lúma Búngiu. Ligía buri cátei le lúnbei jadǘgüni, mígirunga jumeíme jadǘgüni le líbiri. ");
INSERT INTO cabNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Jugúya, adúndejatiña maríjintiña jugúya le, áseija jumúti ában minímini áni julútün ában caméyu! ");
INSERT INTO cabNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‘¡Fugiábugu jugúya arúfudajatiña lilúrudun Moisés jáma fariséogu! ¡Biángua tigíbu! Adǘgatün lun jarítagun gürígia luágu buídu lan jigáburi. Ítara jíña quei wéru lúma asíedu le jachíbubei boúgudigiñe libíti, ánjein múnadagiñe jibíti, buin jíña láu buri luweínamu-águu lúma íweruni. ");
INSERT INTO cabNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariséogu maríjintiña. jarúmagüda jumeí wéru lúma asíedu lurágeirugugiñe furúmiñe, ábame gíñe larúmadun boúgudigiñe libíti. ");
INSERT INTO cabNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‘¡Fugiábugu jugúya arúfudajatiña lilúrudun Moisés jáma fariséogu! ¡Biángua tigíbu! Ítara jíña quei umúajaü le afeíndijoúti láu jarúti boúgudigiñe libíti, buídumeraüti larijín, ánjein lurágeirugugiñe, buín líña láu jábu jiláaña lúma sun luwúyeri iwíyei. ");
INSERT INTO cabNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ítara jíña, boúgudigiñe jibíti, ma lubuídun jarijíniwa jagíbugiñe gürígia, ánjein múnadagiñe, buín jíña láu iyéerejabuni lúma wuríbani. ");
INSERT INTO cabNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‘¡Fugiábugu jugúya arúfudajatiña lilúrudun Moisés jáma fariséogu! ¡Biángua tigíbu! Rújumuti dǘbü arítaguagüleime luágu jamúaja profétagu, wéndegüda jumeí umúajaü le jáni gürígia já meja buídubaña. ");
INSERT INTO cabNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ábati jaríñagun. “Lun jamúga meja awánjeinjadiwa lan le jadáani binádu wagǘbürigu, míderagun wamútiña jamúga áfaraguaña profétagu.” ");
INSERT INTO cabNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Láu líra, subúdiguatün júngua luágu jádaangiñetün lan ja áfaragubaliña profétagu jagía. ");
INSERT INTO cabNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Gumújumeiti jadǘgüni lé meja jagúmeserubei binádu jagǘbürigu adǘga! ");
INSERT INTO cabNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","‘¡Jéwegu! ¡Jarásan jéwegu! ¿Ída lubásan jeséfurun lueí asúfuriruni le lánina máfiougati? ");
INSERT INTO cabNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ligía noúnajaba lubeí profétagu, jáma ja chúbaña áu, jáma arúfudajatiña, jun. Áni jugúya, jáfaragubaña jádaangiñe, dágua jumáñame jíbiri luágu gurúwa, bei jumáñame jíbiri tídan jalígilisin juríu, eíbaaja jumáñame lídan sun fulásu. ");
INSERT INTO cabNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ítara lúba láburujan dúru juágun luágu sun jítaü le áwiyurubei jádaangiñe sun wügǘriña buítiña ja jáfarawagúbaña, lúmagiñé meja Abél le richáguabei darí lúmoun Zacarías, liraǘ Berequías lé meja jáfarubei tabádinagua témpulu lúma latárü. ");
INSERT INTO cabNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ninárün jáu luágu láburujaba lan dúru jawágun gürígia ja lánina dan le luágu buri sun cátei le. ");
INSERT INTO cabNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","‘¡O jugúya Jerusalénna! ¡Áfaragua jumáaña profétagu, chǘgua jugúya dǘbü jawágun ja loúnajabaña Búngiu láu ugánu buíti jun! ¡Sarágu weíyaasu nálugun natoúnigirunün quei tatoúnigiruniña gáyu tirájüñü lábugiñe tarǘna, májatün! ");
INSERT INTO cabNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ígira láadün Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","áni naríñajare jun luágu maríjindügüya jumáadina lan queísi jasálbaragüle daríme lachǘlürün dan lun jaríñagun. “Biníwati le ñǘbinbei lídan líri Wabúreme Búngiu.” ");
INSERT INTO cabNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Dan le láfuridun Jesúsu témpulurugugiñe, leíbuga yebe, ligía jayábin láni disípulugu lúmoun, ába jarúfudun tuágun témpulu lun. ");
INSERT INTO cabNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ába laríñagun Jesúsu joun. —¿Aríja jumútu sun to? Ninárün jáu luágu merédebei lan ni ában dǘbü ligíbuagu dǘbü, tagǘnrichawagúba sun to. ");
INSERT INTO cabNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ábati joúdin luágu wǘbü Olívos, dánti ñun lan Jesúsu ñi, ába joúdin láni disípulugu agǘlülüja lúma, ába jaríñagun lun. —Buséntiwa lun baríñaguni woun ídaba lan tagǘnrinchawagúa témpulu. ¿Cába liseíni bagíribudun uboúagun, lúma lagúmuchagüle? ");
INSERT INTO cabNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ába laríñagun Jesúsu joun. —Toúnigi jumá lun úa lan ayéedutün, ");
INSERT INTO cabNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ladǘga sarágujaba ñǘbintiña aríñageina. “Áu Crístubei”, áni sarágujaba jayéedun. ");
INSERT INTO cabNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jugúya jagáambuba lamúri wuríbu yaráfa jun lúma ugánu luágutí buri wuríbu díseti jueí, manúfudedagua jumá. Lúnti ítara lan, mámagilíme lagúmuchagüle uboú líra. ");
INSERT INTO cabNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Lageíndaguba ában ageíraü lúma ában, lawúribujaba ában fulásu lúma ában, ñíbei ilámaü, sándi, járabaganáli lídan sarágu fulásu. ");
INSERT INTO cabNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sun líra lagúmesejarügügili le lúnbei lasúfurirúniwa. ");
INSERT INTO cabNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","‘Jugúyati, jedéregerúaba lun lúrudu lun jasúfurirawagüdǘn, lun gíñe jáfarawagúniwa jilágubei, jiyéreegudúba lun sun uboú nueígiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lídaanme dan ligía, sarágujaba eféridiruti jafíñen nuágu, ábame jeyéreegudún joúniwagua, ábame jalúguragun joúniwagua. ");
INSERT INTO cabNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jachǘlaaguba sarágu yéetiña aríñaga luágu profétagu jamá áni sarágujaba gürígia jayéedun. ");
INSERT INTO cabNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ñíbei sarágu wuríbani daríme lun jeféridiruni sarágu jádaangiñe lánigu Búngiu ínsiñejabuni jádaangua. ");
INSERT INTO cabNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Le asígiruti derégüdagu darí lúmoun lagúmujoún, lasálbarúba. ");
INSERT INTO cabNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Lapúrichijoúba ugánu buíti le luáguti larúeijan Búngiu lídan sun uboú lun lasúbudirúniwa lídan sun fulásu, ligíaalímeti lagúmuchun uboú. ");
INSERT INTO cabNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‘Abǘrüjatí meja proféta Daniél luágu cátei iyéreeguti le gagǘnrinchaguagüdadibei, dánme le jaríjin chülǘjali lan cátei le lídoun fulásu le sánduti—le alíijabei, gunfaráandalá—, ");
INSERT INTO cabNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","jámeti Judéabaña, lúntime janúrajan luágun buri wǘbü. ");
INSERT INTO cabNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Léme tábulugubei lúban wéyu ligía, maráriralá aságara ni cáta múnadagiñe, ");
INSERT INTO cabNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","le áraabubei, magíribudalá ni abúdoun lanáangun. ");
INSERT INTO cabNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Fugiábugume würíña ja dageínatiña o ja lan gasáanigutiña ja gurágiña lídounme wéyu ligía! ");
INSERT INTO cabNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Amúriaja jumá lúma Búngiu lun máma lan lídan lidíliga ni lídan luwéyuri eméraaguni janúraja. ");
INSERT INTO cabNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ladǘga ñíbei sarágu súfuri le úagili líbe lúmagiñe lagúmeserun uboú, úabei gíñe lárigiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Lun jamúga madǘraagun lubeí lan Búngiu dan ligía, úati jamúga ni ában asálbaruti, ladǘraagubei jawágurügü ja lanúadirubaña lun lánigu jamá. ");
INSERT INTO cabNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‘Ánjein lubeíti aríñawagua jun. “Niján Crístu” o “Ningitán lan”, mafíñera jumá, ");
INSERT INTO cabNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ladǘga jayábinba ayéejatiña lun jarúfudagun joúngua camá Crístu, camá buri profétagu, áni jadáaguba oúnwenbun buri seíni lúma miláguru lun jeyéedaguniña ja anúadira láañabaña Búngiu ánjaña gayára. ");
INSERT INTO cabNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Aríñaga náali le jun lubáragiñe lasúseredun, ");
INSERT INTO cabNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ligía lubeíti, ánjein aríñawagua jun. “Níjein Crístu yára lídan fulásu le mageírawati”, mídin jumá ñi, ánjaña aríñaga jun. “Niján ya rúmurugu”, mafíñera jumá. ");
INSERT INTO cabNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Quei larijíniwa labírichagun lueígiñe ában oúbaü libíti siélu lun luágun le ában, ítara lúba dánme le niábin, aú le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ábame láburujan ligáñi Búngiu jawágun gafígountiña quei wadúbi luágun úgubu jiláali. ");
INSERT INTO cabNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘Lárigiñerügüme lásügürün wéyu buri lánina súfuri ligía, ábame labúrigadun wéyu, marúnijalime játi, ábame jeíguadúnga warúguma ja siélubaña, ábame ladádagarun sun siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ábameti jaríjini niseíni siélu, súnme gürígia wuríbatiña uboúagu, jayájuajaba láu jaríjini niábinya, áu le Wügǘri Garaǘwarügüti, lídan juánriñu siélugiñe láu oúnwenbun ubáfu lúma uweíriguni. ");
INSERT INTO cabNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dánme línwirúniwa fídu rein, ábame noúnajaniña náni ánjeligu ja siélubaña lun joúndaruniña nánigu ja anúadira náañabaña lídaangiñe gádürü larígei uboú. ");
INSERT INTO cabNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","‘Furéndei jumeí jémpulu le tuáguti tídibu ígo. Dan le ñulúgili tilímun, ába laboúchun tubána, subúdi jumúti luágu yaráfaali lan lubáchouga. ");
INSERT INTO cabNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ítara méme, dánme gíñe jaríjini sún buri cátei le, subúdi jumeí luágu yaráfaali lan niábin. ");
INSERT INTO cabNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ninárün jáu, luágu lagǘnrinchawagúba lan sun ubúrugu le Jerusalén lubáragiñe joúwegun gürígia ja lánina dan le. ");
INSERT INTO cabNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lagúmuchaguba siélu lúma uboú, ánjein nerérun, merédebei magúnfulirúnga. ");
INSERT INTO cabNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‘Ánjeinti luágu wéyu lúma óra le lúnbei nagíribudun uboúagun, ibídiñeti ni ca un, ni joun ánjeligu ja siélubaña, ni nun, áu le Liraǘ Búngiu, Búngiu rügǘñein Úguchili asúbudirei. ");
INSERT INTO cabNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","‘Ítara queí meja lasúseredun lídan meja lidáani Noé, ítara lúba gíñe dánme le niábin, áu le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Lídan meja dan ligía, lubáragiñe ladíbirun uboú, jerédera meja gürígia eíga, áta, amárieidagua, íchaajaña jasáanigu lun maríei, darí wéyu le lebélurunbei Noé tídoun ugúnein. ");
INSERT INTO cabNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Meféentiña, darí ladíbirun uboú, ába jañáradagun súngubei. Ítara lúba gíñe dánme niábinya, áu le Wügǘri Garaǘwarügüti uboúagun. ");
INSERT INTO cabNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Lídaanme dan ligía, ñíbaña bián wügǘriña áraabu, lanügǘba ában, igirúame le ában según jafíñen nuágu. ");
INSERT INTO cabNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ñíbaña bián würíña amúlija, tanügǘba ában, igirúame to ában. ");
INSERT INTO cabNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‘Agágudúañu jumá, ladǘga ibídiñeti jun cába lan óra niábin, áu le Jabúreme. ");
INSERT INTO cabNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Subúdi jumeí le, luágu ánjein lan jamúga lasúbudira tabúreme ában múna cába lan óra liábin jíweruti áriebu, leréderuña jamúga marúmugunga, mígirunti jamúga lun lebélurúniwa íweruja lúbiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ligía aráanseñu jumá lubeí, ladǘga léme óra magáradajan jumá, ligíame niábin, áu le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‘Ítara jumá queísi músu úaraguati, gunfaráanda ligía, le lígirubei liyúbudiri lun laríjin jáu ja lúbiñebaña lun líchugun eígini joun lídan dan. ");
INSERT INTO cabNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Gúndaabei músu le dánme le liábin liyúbudiri ánjein ladárira agúnfulira lúma lifísiute. ");
INSERT INTO cabNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ninárün jáu luágu líchugubei lan liyúbudiri lun laríjin láu sun lumégen. ");
INSERT INTO cabNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ánjein ában lubeí wügǘri wuríbati músu ligía, ábame larítagun luágu lǘgili lan liábin liyúbudiri, ");
INSERT INTO cabNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ábame lagúmeserun oúseraña jíbiri músu wuríba, reídei ligíame eíga lúma áta jáma bacháruatiña, ");
INSERT INTO cabNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ábameti liábin liyúbudiri lídan wéyu le magúrabun láani, lídan óra le ibídiñeti lun. ");
INSERT INTO cabNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ábame líchuguni luweírin-ágei abeichúni luágu, lasíadireime lun máfiougatin úara jáma biángua tigíbu, ábame layájun, acǘnrijame lári. ");
INSERT INTO cabNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ába laríñagun Jesúsu. —Ítara lubáti arúeijani le lánina siélu quei díisi würíña irájüñü ja anǘgübaña jalámpun le gálati gási, ába jáfuridun lun jadúnragun lúma adári, ñǘdün jamámuga úara lúma maríeirugun. ");
INSERT INTO cabNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Seíngü jádaangiñe, maráanseruntiña, seíngü aráansetiña. ");
INSERT INTO cabNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ja maráanserunbaña, dan le janǘgünbalin jalámpun, manǘgüntiña ámu gási lueí le lídaanbei jalámpun, ");
INSERT INTO cabNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ánjañati ja aráansebaña, barǘtiña jabúdein láu gási boúgudin lueí le lídaanbei jalámpun. ");
INSERT INTO cabNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Queísiti ladárasarun adári, ába ladábudunga jágu súngubei, ába jarúmugun. ");
INSERT INTO cabNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Queí buri luágu amídi áriebu, ligía lagaambúniwa agúaraguni. “Niteín adári, furíjuma adúnraguei.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Sun würíña irájüñü jagía, ába jásaarunga, ába jagúmeserun aráansejei jalámpun. ");
INSERT INTO cabNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ába jaríñagun ja maráanserunbaña joun ja aráansebaña. “Rújuma murúsun lídaangiñe jigásin woun, ladǘga léñeguchuña walámpun.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ába jaríñagun ja aráansebaña joun. “Siñáti, ladǘga loúguabei woun, loúguame jun. Jeíbagubei le ñí lubei lalúgurajoúa agáñija jumámuga júngua.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Léti añángüra lan ja maráanserunbaña agáñija gási, ligía liábin adári. Játi aráansebaña, ába jebélurun lúma maríeirugun, ába ladaurúniwa béna. ");
INSERT INTO cabNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Lárigiñe, ligía jachǘlürün jíbiri würíña irájüñü jagía, ába jaríñagun. “¡Wabúreme, wabúreme, darábei béna wabá! ");
INSERT INTO cabNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ába laríñagun joun. “Ninárün jáu, ibídiñetün nun.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ábati laríñagun Jesúsu joun. —Agágudúañu jumá, ladǘga ibídiñeti jun cába lan wéyu, ni cába lan óra nagíribudun, áu le Wügǘri Garaǘwarügüti, uboúagun. ");
INSERT INTO cabNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","‘Ítara líña arúeijani le lánina siélu quei ában wügǘri le dan lébei laráansejan lun ladǘgün weíyaasu lídoun ámu fulásu, ába lagúarun joun lumúsuniña, ába líchuguni liseínsun lábugiñoun jaríaajan. ");
INSERT INTO cabNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","‘Lun ában jádaangiñe, rúti queí buri seíngü-mílu fiádürü, queí buri bián-mílu lun ában, queí buri mílu lun ában. Lafánreinjani joun quei jabáfu lun jawádigimariduni. Ábati lídin luágu luweíyasun. ");
INSERT INTO cabNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Le músu le erésibirubei seíngü-mílu fiádürü, ába luwádigimariduni, ába lagáñeirun seíngü-mílu fiádürü ligíbuagun. ");
INSERT INTO cabNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ítara méme le erésibirubei bián-mílu, gáñeiti bián-mílu lánwoun. ");
INSERT INTO cabNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ánjeinti le erésibirubei mílu, ába lídin, ába lachígin ában júyu, ába larámuduni liseínsun liyúbudiri ñi. ");
INSERT INTO cabNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‘Sarágu dan lárigiñe, ába lagíribudun iyúbudiri, ába lagúmeserun aráanseja jáma luágu seínsu. ");
INSERT INTO cabNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Furúmiñe, ába liábin le erésibirubei seíngü-mílu fiádürü, ába ledéregeruni lun liyúbudiri láu seíngü-mílu le lagáñeirubei ligíbuagun, ába laríñagun lun. “Niyúbudiri, seíngüñein-mílu fiádürü bíchugun nun, niján seíngü-mílu nagáñeirun ligíbuagun.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ába laríñagun iyúbudiri lun. “Buíti, ában músu buíti amǘrü, úaragua, quei úaragua bubeí lídan le murúsunrügüti, níchiga gíbetimaati lábugiñe baríaajan. Queímoun, gúnda amǘrüme úara núma.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Lárigiñe, ába liábin le erésibirubei bián-mílu fiádürü, ába laríñagun. “Niyúbudiri, biámañein-mílu fiádürü bíchugun nun, niján bián-mílu nagáñeirun ligíbuagun.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ába laríñagun liyúbudiri lun. “Buíti, ában músu buíti amǘrü, úaragua, quei úaragua bubeí lídan le murúsunrügüti, níchiga gíbeti lábugiñe baríaajan. Queímoun, gúnda amǘrüme úara núma.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ligía liábin le erésibirubei mílu fiádürü, ába laríñagun lun liyúbudiri. “Niyúbudiri, subúdigubei numúti luágu wügǘri ban jéreguti, alúbaja ban le ñí lumuti mábunagun ban, abúdaja amǘrü le ñí lumuti machágarun ban ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ligía nanúfudedunbei, ába nídin arámudei biseínsun lábugiñe múa. Niján le báni.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ába laríñagun iyúbudiri lun. “Músu wuríbati, moúnti. Subúdigubei bíñein luágu alúbaja nan le ñí lubei mábunagun nan, abúdaja áu le ñí lubei machágajan nan ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ligía lúnti lubeí jamúga bíchuguni niseínsun báncürugun lun dan lan jamúga nagíribudun, nerésibiruni le náni láu agáñeiruni.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ába laríñagun joun ja ñíbaña. “Gidájumei seínsu le lúmabei lueí, rújumei lun le láubei díisi-mílu, ");
INSERT INTO cabNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ladǘga le adǘgübei buíti láu le lúmabei, líchugúba lánwoun lun, ábanme lígiragun lun, ánjein le madǘgübei buíti láu murúsun le lúmabei, lagídarúaba lueí. ");
INSERT INTO cabNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Músuti moúnti le, fíjumei lídoun lubúriga le boúgudibei, le ñíba lubeí layájuaja, acǘnrijame lári.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","‘Dánme nagíribudun, áu le Wügǘri Garaǘwarügüti, uboúagun, niábinba quei urúei geyégu ánjeligu náu, ábame nañúurun luágu nála láu uweíriguni lun nagúseragüdüniña sun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ábame joúndaragun gürígia ja lílana sun fulásu nigíbugiñe, ábame nafánreinraguniña jawáriuagua quei lafánreinraguniña joúniri mudún, mudún jádaangiñe gábara. ");
INSERT INTO cabNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ja richáguabaña ligíbugiñe Búngiu, ábame níchuguniña lueígiñe noúnwenren, ja wuríbabaña ligíbugiñe Búngiu, lueígiñebaña nubaǘna. ");
INSERT INTO cabNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Naríñagame joun ja lueígiñebaña noúnwenren. “Jigoúgu, jugúya le biní laalíbei Núguchi, resíbi jumeí arúeijani le aráanserúbei jubá lúmagiñe ladǘgüni Búngiu uboú. ");
INSERT INTO cabNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ladǘga dan le nalámachunbei, rútün eígini nun, dan le namágürabudunbei, rútün dúna nun, dan le eíbugañaja nubeí quei chülǘdügüti, rútün múna nun. ");
INSERT INTO cabNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Dagáti manáanguni nuágu, rútün anáanguni nun, dan le nasándirunbei, ñǘdüntün aríjana, dan le nadaürǘnbei, ñüdǘntün aríjana.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ábameti jaríñagun richáguatiña jagía nun. “Wabúreme, ¿ída bugagí waríjabu láu ilámaü, ába wíchugun eígini bun? ¿ída bugagí waríjabu láu mágürabu, ába wíchugun dúna bun? ");
INSERT INTO cabNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ída bugagí waríjabu quei chülǘdügüti, ába wíchugun múna bun? ¿o manáangunga, ába wíchugun anáanguni bun? ");
INSERT INTO cabNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ída bugagí waríjabu láu sándi o furísunrugu, ába woúdin aríjabu?” ");
INSERT INTO cabNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ábame naríñagun joun. “Ninárün jáu, furúmieguarügü cátei le jadǘgübei lun ában jádaangiñe namúlenu, ca lan lǘnabunbei, nun méme jadǘgei.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","‘Naríñagameti joun ja lueígiñebaña nubaǘna. “Díse jumá nueí, jugúya le lúnbei jasúfurirun lun sun dan, jeíba lídoun wátu geméti le méñeguchadibei, le aráanserúbei lubá Máfia jáu lánigu. ");
INSERT INTO cabNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ladǘga dan le nalámachunbei, míchutün eígini nun, dan le namágürabudunbei, míchutün dúna nun. ");
INSERT INTO cabNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Eíbugatina quei chülǘdügüti, míchutün múna nun, mégeitina anáanguni, míchutün nun, sánditina, daǘwa áu, mídintün aríjana.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ábame jaríñagun wuríbatiña jagía nun. “Wabúreme, ¿ída bugagí waríjabu láu ilámaü o mágürabu, o quei chülǘdügüti, o manáangunga, o láu sándi, o furísunrugu, míderagun wamútibu?” ");
INSERT INTO cabNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Naríñagame joun. “Ninárün jáu, luágu furúmieguarügü lan cátei le madǘgün jubeí joun gürígia, ca lan lǘnabunbei, madǘgün jumúti gíñe nun.” ");
INSERT INTO cabNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ábameti joúdin ja máfiougatin lun jasúfurirun ñi lun sun dan, jámeti richáguabaña ligíbugiñe Búngiu, ábame joúdin siélun lun jagúndaarun ñi lun sun dan. ");
INSERT INTO cabNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Dan aríñaga láali Jesúsu sun cátei le, ába laríñagun joun láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Quei jasúbudiruni, bián wéyu lárigiñe le, ligíame fédu le páscua, áni nedéregerúaba, áu le Wügǘri Garaǘwarügüti, lun nádarawagún luágu gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ába joúndaragun jábutigu fádirigu, arúfudajatiña lilúrudun Moisés, jáma wügǘriña weírigutiña lídan jafíñen juríu tigíbugiñe lúban Gáifasi, fádiri le íñutimaabei. ");
INSERT INTO cabNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ñi jaráanseja luágu Jesúsu lun járügüdüni láu yéguaü, lun jáfaruni jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jaríñagati. —Máma látia fédurugu lueí jachágaragun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betániañein Jesúsu, lúbiñe Simón lé meja gawágubei gumeín luágu sun lúra, ");
INSERT INTO cabNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ába tiábin ában wǘri luágun, gámeina tugúya ában lágei ibíñei le weíriti lisérun. Dan luáguñein lan dábula Jesúsu, ába téseruni ibíñei ligía lábulugun. ");
INSERT INTO cabNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Dan jaríjinbaalin disípulugu cátei le, ába jamágundarun, ába jaríñagun. —¿Cámesan leféridirúa le ítara? ");
INSERT INTO cabNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Gayáraati jamúgagu lalúgurúniwa le luágu sarágu seínsu lun jíderawagún gudémetiña. ");
INSERT INTO cabNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ába lagáambuni Jesúsu le jaríñagubei, ába laríñagun joun. —¿Ca uágu jañáwurija tun wǘri to? Cátei buíti le tadǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Súnwandan yábaña lan gudémetiña júma, ánjein áu, mámaba súnwandan júma nan. ");
INSERT INTO cabNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Le tadǘgübei wǘri to láu téseruni ibíñei le nuágun, taráanseruñádina lubá nábunúniwa. ");
INSERT INTO cabNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ninárün jáu luágu le lan ñí lumuti lapúrichijoúa ugánu luáguti asálbaruni lídan sun uboú, labájüdawagúaba gíñe le tadǘgübei wǘri to, lun larítawagún tuágu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ába lídin ában jádaangiñe dúusu disípulugu, le gíribei Júdas Iscarióte, adímureja jáma jábutigu fádirigu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ába laríñagun joun. —¿Atiribei jíchugun nun ánjein nedéregera Jesúsu jun? Ába jíchugun darándi murúsun pláta lun. ");
INSERT INTO cabNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Lúmagiñeti óra ligía, ába láluajan Júdas ída lúba lan luwúyeri ledéregeruni Jesúsu joun. ");
INSERT INTO cabNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Le furúmiñeti wéyu lídan fédu le ñí lubei teigúa fein magánatu ísi, ába jayábin disípulugu lúmoun Jesúsu, ába jaríñagun lun. —¿Jalía babúseera waráanserun lun ñíba lan wadǘgei eígini le lánina páscua? ");
INSERT INTO cabNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ába laríñagun joun. —Jeíba ubúrugu, lúbiñe ítaga wügǘri, ábame jaríñagun lun. “Ítara líña laríñagun Maésturu. Yaráfaali nórate, búbiñeba nefédujei páscua jáma náni disípulugu.” ");
INSERT INTO cabNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ába jadǘgüni disípulugu quei laríñaguni Jesúsu joun, ába jaráanseruni eígini le lánina páscua. ");
INSERT INTO cabNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dan le lagúñedunbei, ába lañúurun Jesúsu luágu dábula jáma láni dúusu disípulugu, ");
INSERT INTO cabNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","súnti añája lan eíga, ába laríñagun joun. —Ninárün jáu luágu lalúgurubadina lan ában jídaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ábati jajírudagun, ába jagúmeserun álügüdei ában ában. —Nabúreme, ¿nugúya funásan? ");
INSERT INTO cabNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ába laríñagun joun. —Le éderutu leígan fein núma lídan asíedu, ligiába alúgurana. ");
INSERT INTO cabNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nídiña, áu le Wügǘri Garaǘwarügüti, luágu ǘma le uágubei taríñaga Lerérun Búngiu, áni ¡fugíabutia wügǘri le alúgurutina! Buítimaati jamúga lun magǘriajoúagubei lan. ");
INSERT INTO cabNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ábati ladímurejan Júdas, ába lálügüdajan. —Maésturu, ¿nugúya funásan? Ába laríñagun Jesúsu lun. —Ánja, bugúya. ");
INSERT INTO cabNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dan añája lan eíga, ába lanǘgünun Jesúsu fein lújaburugu, ába leteíngiruni Búngiu tuágu, lásun lagúbachagunun, ába líchugunun joun láni disípulugu, aríñageina. —Joújuma, núgubu le. ");
INSERT INTO cabNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Lárigiñe, ába lárügüdün ában wéru buin táu diweín lújaburugu, ába leteíngiruni Búngiu tuágu, ába lásügüragüdüni joun, aríñageina. —Gurájuma lídaangiñe le, sun jugúya. ");
INSERT INTO cabNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Níta le, le añúuragüdübalin iséri darádu, le gíñe áwiyurubei joun sarágu gürígia lun ferúdunawa lan jafígoun. ");
INSERT INTO cabNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Naríñajare jun luágu mátundügüyaadina lan diweín daríme wéyu le lúnbei nátunun iséri tuwúyeri diweín júma lídan larúeijan Núguchi Búngiu yágüta siélu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Lárigiñe jerémujani urému luágu Búngiu, ába joúdin luágu wǘbü Olívos. ");
INSERT INTO cabNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ába laríñagun Jesúsu joun láni disípulugu. —Sun jugúya, jasándiraguba júngua láu magúraasuni nuágu áriebu le, ladǘga laríñajare tídan Lerérun Búngiu. “Náfarubei joúniri mudún jilágubei, ábame jeréderun mudún chagágu.” ");
INSERT INTO cabNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lárigiñeme násaarun lídaangiñe oúweni lúnya nabágaridun, nídiba Galiléa jubáragiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ába laríñagun Pédro lun. —Gayáraati járügüdün súngubei magúraasuni buágu, nugúya no. ");
INSERT INTO cabNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ábati laríñagun Jesúsu lun. —Ninárün báu luágu áriebu méme lan le, lubáragiñe layúgurujan gáyu, beyéedaguba náu ǘrüwa weíyaasu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ába laríñagun Pédro lun. —Gayáraati noúnwen búma, meyéedagunbadina báu. Ligía méme gíñe jaríñaga sun disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ábati lachǘlürün Jesúsu jáu láni disípulugu lídoun ában fulásu gíriti Getsemaní, ába laríñagun joun. —ñurújuma ya, neíbuga ayúmuragua lun Búngiu yára. ");
INSERT INTO cabNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ába lanǘgüni Pédro jáma bián lirájüñü Zebedéo lúmagua, ába jagúmeserun asándira íruni lúma tigári anígi. ");
INSERT INTO cabNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ábati laríñagun joun. —Sandítina ában íruni le lánina oúweni tídan nuwáni. Reídei jumá ya, agágudúañu jugúyame núma. ");
INSERT INTO cabNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ábati lídin Jesúsu lubáruaguoún mémeraü, ába lájuduragun láu ligíbu múarugun, ába layúmuragun lun Búngiu ítara. —Núguchi, ánjein gayára lubeí, adǘgabá lun masúfurirun náani cátei le lúnbei nasúfuriruni, mámalá quei nabúseerun, queílá babúseerun. ");
INSERT INTO cabNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ábati lagíribudun le ñíjin jabeí láni disípulugu, ába ladáriruniña arúmuga, ába laríñagun lun Pédro. —¿Siñátisán buga jeréderun agágudúañu núma ni ában óra? ");
INSERT INTO cabNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Agágudúañu jumá, ayúmuragua jugúyame, máburujan jumámuga lídoun ínchajoúni lun jeféridiruni jafíñen nuágu. Inárüni luágu ánja tan juwáni lun cátei le buídubei, ánjeinti júgubu, débiliti. ");
INSERT INTO cabNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ábaya lídin luágu libíaman weíyaasu, ába layúmuragun ítara. —Núguchi, ánjein siñá lubei masúfurirun náani le lúnbei nasúfuriruni, adügǘwalá bugúndan. ");
INSERT INTO cabNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ábaya lagíribudun, ábaya ladáriruniña láni disípulugu arúmuga ladǘga weírijali lidábu jágu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ába lígiruniña, ábaya lídin ayúmuragua luágu lǘrüwan weíyaasu, aríñageina méme dimúrei ligía. ");
INSERT INTO cabNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ábati lídin le ñíjin jabeí láni disípulugu, ába laríñagun joun. —¿Jarúmuguña mémesan, eméraagua jugúya? Chülǘjali óra lun nedéregeruníwa, áu le Wügǘri Garaǘwarügüti, jájaburugun gafígountiña. ");
INSERT INTO cabNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sarájuma, queímoun lubároun le lúnbei lalúgurunina, níteeli. ");
INSERT INTO cabNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ñígili Jesúsu adímureja, ligía liábin Júdas, le ábanbei jádaangiñe dúusu disípulugu, jáu sarágu gürígia táu efeín lúma wéwe. Jayábin lueígiñe joúbadina jábutigu fádirigu jáma wügǘriña weírigutiña lídan jafíñen juríu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aríñagaaliti buga Júdas joun. —Le nachúurun, ligía, járügüdeime. ");
INSERT INTO cabNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ábati layárafadun lun Jesúsu, ába laríñagun. —¡Buíti gúñoun, maésturu! Ába lachúuruni. ");
INSERT INTO cabNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ába laríñagun Jesúsu lun. —Numáda, ¿ca bálugubei? Ábati jayábin, ába járügüdüni Jesúsu, ába janǘgüni adáüra. ");
INSERT INTO cabNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ábati laságarunun ában jádaangiñe láni Jesúsu disípulugu lefeínte, ába láchuguni ában larígei lumúsun fádiri le íñutimaabei. ");
INSERT INTO cabNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ába laríñagun Jesúsu lun. —Areídaboún befeínte, ladǘga sun ja áfarajatiña táu efeín, táuba gíñe efeín jáfarúa. ");
INSERT INTO cabNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ibídiñeti bun luágu ánjana lan jamúga busén, gayára lan namúriajan ǘrüwa-wein-díisi-mílu jádaangiñe láni Núguchi ánjeligu, áni loúnajañanu lan jamúga? ");
INSERT INTO cabNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lun jamúga nadǘgüni ítara, ¿ída lubági lagúnfulirun le tídaanbei Lerérun Búngiu to aríñaguboun luágu lúnti lan lasúseredun le ítara? ");
INSERT INTO cabNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ábati laríñagun Jesúsu joun mútu jagía. —¿Jiábin táu efeín lúma wéwe lun járügüdünina camá jamuga jíwerutina? Ságüñaja wéyu nañúurun témpulurugu jagánagua arúfudaja, madaǘ jumútina. ");
INSERT INTO cabNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wel, lasúseredunbei sun le lun lagúnfulirun le jaríñagubei profétagu tídan Lerérun Búngiu. Ábati jígiruni sun disípulugu Jesúsu lábugua, ába janúrajan. ");
INSERT INTO cabNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ja adáürübalin Jesúsu, ába janǘgüni ligíbugiñoun Gáifasi, fádiri le íñutimaabei, le ñí lubei adámurigu jamá arúfudajatiña lilúrudun Moisés jáma wügǘriña weírigutiña lídan jafíñen juríu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ánjeinti Pédro, falá lumuti dísegiñe darí tübǘrürürugun lúban fádiri le íñutimaabei le ñíjin lubeí lebélura, ába leréderun ñun jáma oúnigirutiña témpulu lun laríjin jalíaba lan lébeda cátei le. ");
INSERT INTO cabNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jáluajati jábutigu fádirigu, jáma sun jíbiri líñun-ágei lúrudu lidúnrun Jesúsu láu iyéeni lun gayáraabei lan jasíadiruni lun loúnwen, ");
INSERT INTO cabNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","madáritiña, láu sun sarágu jáña lan gürígia ñǘdüntiña aríñaga iyéeni luágu. Agúmujoúni, ligía jayábin biáma yéetiña íchiga fe luágu, ");
INSERT INTO cabNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ába jaríñagun. —Aríñagati wügǘri le luágu gayára lan lagǘnrichagunun láni Búngiu témpulu, ábaya lánme laráramagüdǘnun lídan ǘrüwa wéyu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ábati laráramun fádiri le íñutimaabei, ába laríñagun lun Jesúsu. —¿Moúnabuntíbusan ni cáta? ¿Cáteigi le, le aríñawagúbei buágu? ");
INSERT INTO cabNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Reídeiti Jesúsu maníñu. Ábati laríñagun fádiri le íñutimaabei lun. —Luágu líri Búngiu le wínwanbei báfiñura lun baríñaguni inárüni. Aríñagabeí woun ánjein amǘrü lubeí Crístubei le Liraǘ Búngiu, le lanúadirubei Búngiu lun lasálbaruniña gürígia uboúagu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ába laríñagun Jesúsu lun. —Ánja, áu, quei baríñaguni. Aríñagatina gíñe jun luágu jaríjubadina lan, áu le Wügǘri Garaǘwarügüti, ñun lueígiñe loúnwenren Búngiu le Súnti Gabáfu, jaríjubei gíñe niábin lídan juánriñu siélugiñe. ");
INSERT INTO cabNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ábati lajeíridagunun fádiri le íñutimaabei lanáangun, le ligáñi, ába laríñagun. —¡Anába láali wügǘri le Búngiu láu lerérun! Mabúseerunjadiwa ámu lun líchugun fe luágu, agáamba jumáali anábuni le laríñagubei, ");
INSERT INTO cabNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿ída líña jaríjin lun? Ába jaríñagun. —Gadúnrunti, lúnti loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ábati jásueraguni ligíbu, buleísei jameí, jíbiri, ába jagáyuajan ligíbuagun, ");
INSERT INTO cabNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ába jaríñagun lun. —Quei amǘrü lan Crístubei, ¡aríñaga beígia ca lan agáyuajabei buágu! Jaríñagunbei lun ítara ladǘga gürágu líña lan lágu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Súnti lasúseredun sun cátei le, ñun líña Pédro boúgudi tübǘrürürugu lúban fádiri le íñutimaabei, ába tiábin ában esériwijatu luágun, ába taríñagun lun. —Bugúya, lúmañadibútia giñéñaja Jesúsu le Galiléana. ");
INSERT INTO cabNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ába leyéedagun Pédro jagíbugiñe súngubei, ába laríñagun. —Ibídiñeti nun ca lan uágu badímureja. ");
INSERT INTO cabNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Leíbuga yebe Pédro luágun béna, ligía taríjini ábanya, ába taríñagun joun ja ñíbaña. —Eyéri le, lúmañajañein gíñe Jesúsu le Nazarétna. ");
INSERT INTO cabNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ábaya leyéedagun Pédro láu fiñún, ába laríñagun. —Ibídiñeti wügǘri ligía nun. ");
INSERT INTO cabNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Murúsun lueígiñe, ába jayábin ja ñíbaña lúmoun Pédro, ába jaríñagun lun. —Inárüni luágu ában lan jádaangiñe amǘrü, arijúati luágu ligáburi badímurejan. ");
INSERT INTO cabNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ába lagúmeserun íñaragua lúngua aríñaga láu fiñún. —¡Ibídiñeti gürígia ligía nun! Lídan méme óra ligía, ába layúgurujan ában gáyu. ");
INSERT INTO cabNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ábati larítagun Pédro luágu le laríñagubei Jesúsu lun. “Beyéedaguba náu ǘrüwa weíyaasu lubáragiñe layúgurujan gáyu.” Ába láfuridun Pédro ñígiñe, ába layájuajan láu igárigu. ");
INSERT INTO cabNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Dan larúgadunbei, ába jadámuridagun sun jábutigu fádirigu jáma wügǘriña weírigutiña lídan jafíñen juríu aríja cába lan jadǘga lun lasíadirúniwa Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ába janǘgüni gürágu, ába jedéregeruni lun Póncio Piláto le gumádimati. ");
INSERT INTO cabNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Dan le laríjinbei Júdas, le alúgurubalin Jesúsu, luágu siádi jamáali lan Jesúsu lun loúnwen, ába laságürijan, ába láguyugüdüni darándi murúsun pláta ligía joun jábutigu fádirigu lúma joun wügǘriña weírigutiña, ");
INSERT INTO cabNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ába laríñagun joun. —Afígounjaadina láu nedéregerun ában wügǘri madúnrunti lun loúnwen. Ába jaríñagun lun. —¿Cámegi le warúma? ¡Bugúya lun baríjini líra! ");
INSERT INTO cabNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ába lachágaruni Júdas seínsu ñi témpulurugu, ába lídin átigiragua lúngua. ");
INSERT INTO cabNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ába jabúduni jábutigu fádirigu seínsu ligía, ába jaríñagun. —Siñáti wíchuguni seínsu le tídoun gáfu to lágei liseínsuna Búngiu ladǘga lebégi oúweni. ");
INSERT INTO cabNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ába júaradun lun lagáñijoún lufúlasun ában wügǘri le adáagubei barámbi láu seínsu ligía lun jábunajoún teréncha ñi. ");
INSERT INTO cabNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ligía Lufúlasun Jítaü lubeí líribei fulásu ligía chülǘ lúmoun dan le. ");
INSERT INTO cabNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ítara líña lagúnfulirun lé meja laríñagubei proféta Jeremías. “Barǘ jamuti darándi murúsun pláta ligía, ebégi le jíchugubei Israelítagu luágu wügǘri ligía, ");
INSERT INTO cabNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ába jagáñijani lufúlasun ában wügǘri le adáagubei barámbi láu, quei laríñaguni Nabúreme nun.” ");
INSERT INTO cabNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Barǘwati Jesúsu ligíbugiñoun gumádimati, le gíribei Piláto, le álügüdübalin. —¿Amǘrüsan Jarúeitebei Juríu? Ába laríñagun Jesúsu lun. —Ánja, áu quei baríñaguni. ");
INSERT INTO cabNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Dán buriti jíchugun jábutigu fádirigu jáma wügǘriña weírigutiña lidúnrun, moúnabuntija Jesúsu ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ábati laríñagun Piláto lun. —¿Magáambun bumútisan le jaríñagubei buágu? ");
INSERT INTO cabNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Moúnabunti Jesúsu ni cáta, ábati laweíridun lanígi gumádimati. ");
INSERT INTO cabNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gagáburi lumúti mejáti gumádimati lígiragüdǘn ában adaürǘti joun gürígia lídan fédu, furúmieguarügü adaürǘti le jamúriajan lúma. ");
INSERT INTO cabNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ñíñeinti ában adaürǘti, díseti leíbaajan líri, gíriti Barabási, ");
INSERT INTO cabNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","dánti le adámuriñujaña lan sun gürígia, ába lálügüdüniña Piláto. —¿Ca jabúseerubei nígiragüdün jun, Barabási, ódi Jesúsu le únbei laríñawagua Crístu? ");
INSERT INTO cabNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Líridubalin gíñe Jesúsu ladǘga subúdi láali lan luágu ladǘga lan jagímugan lun jedéregerei. ");
INSERT INTO cabNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sun ñun lan Piláto luágu lála le lánina agúseruni, ába toúnajan lúmari aríñaga lun. “Madǘgabá ni cáta láu gürígia úaraguati le, ladǘga gewéneditina buga ában uwénedi wuríbati áriebu buga ladǘga gürígia le.” ");
INSERT INTO cabNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ába jádaruni jábutigu fádirigu jáma wügǘriña weírigutiña jádoun gürígia lun jamúriajan lun láfuridun Barabási, lun lafarún Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ábaya ladímurejan gumádimati joun sun gürígia jagía, ába laríñagun joun. —¿Ca jádaangiñe biángubei jabúseerubei lun nígiragüdüni jun? Ába jaríñagun. —Barabási. ");
INSERT INTO cabNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ába laríñagun Piláto joun. —¿Cábati nadǘga láu Jesúsu le únbei laríñawagúa Crístu? Ába joúnabun súngubei. —¡Dáguabeí luágu gurúwa! ");
INSERT INTO cabNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ába laríñagun Piláto joun. —¿Cáti wuríbati ladǘgübei? Ábatima jagúaragun. —¡Dáguabeí luágu gurúwa! ");
INSERT INTO cabNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dan le laríjinbalin Piláto luágu siñá lan ladǘgün ni cáta lueídügüya chagáguaü, ába lamúriajan dúna, ába lachíbuni lújabu jagíbugiñe gürígia, aríñageina. —Máma áu lúnbei naríjin láu loúnwen wügǘri madúnrunti le, jugúya lun jaríjini ñi. ");
INSERT INTO cabNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ába jaríñagun sun gürígia. —¡Wagía jáma warájüñü, wanǘgüba furúmieguarügü dúru wawoúguoun luágu loúnwen! ");
INSERT INTO cabNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ábati lígiragüdüni Piláto Barabási, ába loúnajan abeíchei Jesúsu, ába ledéregeruni lun ládarawagún luágu gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Lárigiñe, ába janǘgüni lisúdaaranigu gumádimati Jesúsu tídoun lúban Piláto, ába joúndaraguagüdüniña sun súdaara geyégua láu. ");
INSERT INTO cabNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ába jarágachunun lanáangun, ába jíchugun ában anáanguni funátu luágu, ");
INSERT INTO cabNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ába jíchugun ában rídi láuti jíyu lábulugu, lúma ában mabúru lújaburugu le loúnwenren. Ábati jájuduragun ligíbugiñe, ába jéjerajan láu, ába jaríñagun lun. —¡Gabágarilá Jarúeite Juríu! ");
INSERT INTO cabNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ába gíñe jásueraguni, janǘgeija mabúru ligía, jíchaaguei lábulugu. ");
INSERT INTO cabNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lárigiñe jéjerajan láu ítara, ába jagídarunun anáanguni funátu lueí, ába jadáürünun lanáangun luágu. Ába janǘgüni lun ládarawagún luágu gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dan le áfurideina jáña lan, ába jadúnragun lúma ában wügǘri Cirénena, gíriti Simón, ába jafósuruni lun lanǘgüni lugúruwan Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ítara líña jachǘlürün lídoun ában fulásu gíriti Gólgota, líla líra, Lufúlasun Lábu Ichǘgü. ");
INSERT INTO cabNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ñi jíchiga diweín láu árani tídan lun Jesúsu lun látunun, joúcharügü lumútu, mátun lumútu. ");
INSERT INTO cabNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dan le dágua jamáali luágu gurúwa, ába jájurerun súdaara ubúnuruni lun jafánreinjanun lanáangun Jesúsu jádaangua. Ítara líña lagúnfulirun lé meja labǘrüjabei proféta. “Ájureratiña ubúnuruni lun jaríjin cába lan jádaangiñe erédera táu nanáangun.” ");
INSERT INTO cabNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ába jañúurun ñi lun joúnigiruni. ");
INSERT INTO cabNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ába jíchugun ában abǘrüjoúni loúgiñe lichǘgü le ñí lubei laríñaga ca lan lidúnrunbei. Abǘrüjoúni ligía ítara líña. “Jesúsu le, le jarúeitebei juríu.” ");
INSERT INTO cabNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dáwaguatiña gíñe bián jíwerutiña luágu gurúwa lúma, ában lueígiñe loúnwenren, ában lueígiñe lubaǘna. ");
INSERT INTO cabNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Já buriti ásügürübaña ñígiñe, ába janábuni, ába jánjingichuni jachǘgü, ");
INSERT INTO cabNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","aríñageina. —Bugúya le gayáraabei bágurunun témpulu ábaya baráramagüdünun lídan ǘrüwa wéyu, sálbaguabá búngua. Ánjein Liraǘ bubei Búngiu, raríba lueígiñe gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ítara líña gíñe jéjerajan jábutigu fádirigu jáma arúfudajatiña lilúrudun Moisés, fariséogu, jáma wügǘriña weírigutiña, láu, ábaja jaríñagun jámagua. ");
INSERT INTO cabNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Sálbati ámu, ánjein lúngua, siñáti lasálbaragun. Ánjein ligía lubeí Jarúeitebei Israelítagu, raríla lueígiñe gurúwa, afíñe wamámuga luágu. ");
INSERT INTO cabNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Rúlaali lafíñen luágu Búngiu, sálbaleíti Búngiu guetó ánjein inárüni lubeí luágu jínsiñe lan lun, quei aríñagaali lan woun luágu Liraǘ lan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Anába jamúti gíñe jíwerutiña ja dáwaguñubaña luágu jagúruwan úara lúma. ");
INSERT INTO cabNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ábati labúrigadun sun fulásu lúmagiñe amídirugu darí ladaǘnrün ǘrüwa rábounwéyu. ");
INSERT INTO cabNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Queí buri óra méme ligía, ába lagúaragun Jesúsu jére. —Elí, Elí, ¿láma sabáctani? —líla líra. Nubúngiute, Nubúngiute, ¿cásan uágu bígirana? ");
INSERT INTO cabNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ñíñanu agáambuti jádaangiñe ja ñíbaña, ába jaríñagun. —Lagúajaña wügǘri le lun proféta Elías. ");
INSERT INTO cabNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ába lídin ában jádaangiñe eíbaagueina anǘga ában mudúsi, lárigiñe ladǘdüragüdüni táu diweín garǘjütu ába líchuguni luágu ában wéwe, ába línchunun lun lun lachúrunun. Ába lachúrunun. ");
INSERT INTO cabNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ába jaríñagun ja jíbiri. —Ígirabeí, waríja ánjein ñǘbin Elías asálbarei. ");
INSERT INTO cabNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ábaya ladǘgün Jesúsu ában agúaraguni jéreti, ábati loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lídan óra ligía, ába tajeíridagun tubélun témpulu lídan bián murúsun, íñugiñe lun ǘnabun. Ába ladágarun ában járabaganáli, ába láwarajan dǘbü. ");
INSERT INTO cabNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ába lánjunrenchúnga umúajaü, águyuguatiña sarágu jádaangiñe afíñetiña luágu Búngiu já meja jiláguaañábaña. ");
INSERT INTO cabNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ába jáfuridunga lídaangiñe jamúaja lárigiñe lásaarun Jesúsu lídaangiñe oúweni. Ába jebélurun lídoun ubúrugu Jerusalén le biníwabei, le ñí lubei jaríjaña sarágu gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Léti jábuti súdaara jáma súdaara ja oúnigirubalin Jesúsu, dan jasándirunbalin járabaganáli lúma dan jaríjinbaalin líbiri buri cátei le asúseredubei, ába janúfudedagun sarágu, ába jaríñagun. —Inárüni, Liraǘ Búngiu wügǘri le. ");
INSERT INTO cabNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ñíñanu sarágu würÍña aríagua dísegiñe, ja afálarubalin Jesúsu lúmagiñe Galiléagiñe íderagua jameí. ");
INSERT INTO cabNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ñíñoun María Magdaléna jádan, María to lúguchu Jacóbo lúma José, túma jáguchu lirájüñü Zebedéo. ");
INSERT INTO cabNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dan le agúñedeina líña lubeí, ába liábin ában wügǘri rísiti gíriti José, lídaangiñeti fulásu le gíribei Arimatéa, jádaangiñeti gíñe ja afálarubalin Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ábati lídin aríjei Piláto, ába lamúriajani lúgubu Jesúsu lúma. Ábati laríñagun Piláto lun líchugúniwa lun, ");
INSERT INTO cabNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ába lanǘgüni José, ába loúburaguni tídan ában gamísa jarúmatu. ");
INSERT INTO cabNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ába líchuguni lídoun lumúaja iséri lé yebe lachígagüdübei lubárua luágu dǘbü. Lárigiñe ladáuruni umúajaü láu ában dǘbü weíriti luágu lubéneri, ába lídin. ");
INSERT INTO cabNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ñíñounti María Magdaléna túma to ában María ñun ligíbugiñe umúajaü. ");
INSERT INTO cabNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Larúgan, lárigiñe aráansejani lubá luwéyuri eméraaguni, ába joúdin jábutigu fádirigu jáma fariséogu aríjei Piláto, ");
INSERT INTO cabNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ába jaríñagun lun. —Wábuti, jarítagua wamúti luágu aríñaga lán meja yéeti ligíra dán meja moúnwengili luágu lásaaruba lan luágu lǘrüwan wéyu lárigiñe loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Oúnajagubeibá achoúrurei umúajaü daríme lǘrüwan wéyu, mayábin jamámuga láni disípulugu áriebu íwerujei lúgubu, ábame jaríñagun joun gürígia luágu saráali lan. Weíritimaajalímeti lagúmujoún iyéeni le sügǘ láu le furúmiñeti. ");
INSERT INTO cabNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ába laríñagun Piláto joun. —Barǘjuma fiú súdaara, jeíba choúru jumeí umúajaü le lubuídun-ágei juáraati. ");
INSERT INTO cabNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ábati joúdin, ába jachoúruruni dǘbü le luágubei umúajaü, ába jígiruniña súdaara lun joúnigiruni. ");
INSERT INTO cabNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dan le lásügürünbei luwéyuri eméraaguni áni arúgadeina líña dimáasu, ába joúdin María Magdaléna túma to ában María aríjei umúajaü. ");
INSERT INTO cabNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sódini, ába ladágarun ában járabaganáli jéreti óra ligía láu larárirun ában láni Wabúreme ánjeli siélugiñe, ába liábin luágun umúajaü, ába lagídaruni dǘbü le áubei ladaurúa, ába lañúurun luágu. ");
INSERT INTO cabNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Miríti ánjeli ligía quei ában labírijanoúga, tiábin lanáangun, jarú jarú. ");
INSERT INTO cabNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dan le jaríjinbalin súdaara, ába jadádagarun láu anúfudei, ába jeréderun camá jiláguaaña. ");
INSERT INTO cabNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ábati laríñagun ánjeli ligía joun würíña jagía. —Manúfude jumá. Subúsiti nun luágu jáluajañein lan Jesúsu le ádarawagúbei luágu gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Úati ya, saráali quei laríñaguni. Jigoúgu jaríjei fulásu le ñíjin lubeí líchugúa, ");
INSERT INTO cabNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ábame jídin furése, ábame jaríñagun joun láni disípulugu luágu saráali lan, luágu níngiran lan jubá jubá Galiléoun, ñíba jaríjei. Niján ugánu lé buga lúnbei naríñaguni jun. ");
INSERT INTO cabNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ába joúdin würíña jagía oúfudagueina, láu anúfudei lúma sarágu ugúndani, ába joúdin eíbaagueina aríñagei joun disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Súnti añája lan luágu ǘma, ligía larúfudagun Jesúsu lúngua joun, ába labúsurun joun. Ábati jayárafadun lun, ába jájuduragun lun, ába joúburuni lugúdi. ");
INSERT INTO cabNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ába laríñagun joun. —Manúfude jumá. Jeíba awísaraña nánigu lun joúdin Galiléoun, luágu ñíba lan jaríjana. ");
INSERT INTO cabNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Dan le joúdiña lubeí würíña, ligía joúdin jádaangiñe súdaara ja oúnigirubaña, ába joúdin ubúrugu, ába jabájüdaguni le asúseredubei joun jábutigu fádirigu. ");
INSERT INTO cabNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ába joúdin ábutigu ja adímureja jáma wügǘriña weírigutiña lídan jafíñen juríu lun jebélurun jáma lídoun ában úarani, ába jíchugun sarágu seínsu joun súdaara, ");
INSERT INTO cabNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ába jaríñagun joun. —Jaríñagame luágu dan lan le anjǘnja lan arúmuga áriebu, ába lan jayábin láni Jesúsu disípulugu, ába jíwerujani lúgubu. ");
INSERT INTO cabNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ánjein lasúbudira gumádimati cátei le, wadímurejaba luágu jáni fuleísei lúma lun madügǘn lan ni cáta jáu. ");
INSERT INTO cabNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ábati jerésibiruni súdaara jagía seínsu, ába joúdin adǘgei le uágubei laríñawagúa joun. Ítara liñáti jaríñaguni juríu chülǘ lúmoun dan le. ");
INSERT INTO cabNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ába lubeíti joúdin únsu disípulugu Galiléoun luágu wǘbü lé meja uágubei laríñaga Jesúsu joun lun joúdin. ");
INSERT INTO cabNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Dánti le jaríjinbalin Jesúsu, ába jájuduragun lun, láu sun añájein lan jádaangiñe, loúguati jafíñen luágu ligía lan. ");
INSERT INTO cabNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ába liábin Jesúsu jawágun, ába laríñagun joun. —Rúaali sun ubáfu nun siélu lúma uboúagu. ");
INSERT INTO cabNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jeíbati jabǘgürü gürígia ja lílana sun fulásu, adǘga jumáña nánime disípulugu, badíseigüda jumáña lídan líri Búngiu Úguchili, Búngiu Irájü, lúma líri Sífiri Sándu. ");
INSERT INTO cabNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Arúfudaja jugúyame joun lun gagáambadi jamá lun sun le uágubei naríñaga jun. Subúdi jumeí luágu anájein lan júma ságü wéyu daríme lagúmuchun uboú. Ítaralá.");
INSERT INTO cabNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Niján ugánu buíti luágu Jesucrístu, le Liraǘ Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","latátira láu lagúnfulirúniwa dimúrei lé meja labǘrüjabei proféta Isaías, laríñaga. Niján noúnagüle, líña Búngiu, noúnajañein bubáragiñe, amǘrü le Niraǘ, lun laráansejanun janígi gürígia lubá biábin. ");
INSERT INTO cabNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lagúarajaba lídan fulásu mageírawati. “Aráanse jumoún janígi lubá liábin Wabúreme, queísi ladárarúniwa ǘma surúti.” ");
INSERT INTO cabNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Lun lagúnfulirúniwa dimúrei ligía liábinbei Juan lídoun fulásu mageírawati, ábaja laríñagun joun gürígia ja ñǘbinbaña lun luágu lúnti lan jasáansiruni ligáburi joúserun lun ferúdunawa lan jafígoun, badísei jagíame. ");
INSERT INTO cabNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ábatija jayábin lídaangiñe sun Judéa lúma sun Jerusalén agáambei lapúrichijan. Dántija le jagúfeseruni jafígoun, ábajei labásteragüdüniña Juan lídan dúna le gíribei Jordán. ");
INSERT INTO cabNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Mebégitu lanáangun Juan, láutu lúra caméyu, lagǘrüga lamídan, guéru, chigángaru leígibaña lúma síruudu le áraabuna. ");
INSERT INTO cabNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Laríñagaja joun gürígia lídan lapúrichijan. —Liábinba ában le gabáfutimaati nárigiñe, weíriti lubáfu nueí darí lun madǘna nan ni lun nélemuchun afáragadei tagǘrüga ligeídin. ");
INSERT INTO cabNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Áu, láu dúna nabásteragüdaün, ánjein ligía, labuínchagüdübadün láu lubáfu Sífiri Sándu. ");
INSERT INTO cabNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lídoun buga dan ligía, ába lídin Jesúsu Nazarétgiñe, fulásu le lídaanbei lumúan Galiléa, ába labásteragüdüni Juan lídan dúna le Jordán. ");
INSERT INTO cabNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Dan le láfuridunbei dúnarugugiñe, ába lánjunrenchagun siélu lun, ába laríjini Juan larárirun Sífiri Sándu luágu Jesúsu quei jamúga ában únjun. ");
INSERT INTO cabNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ában lagaambúniwa ában umálali siélugiñe aríñaguti. —Amǘrü niraǘ le jínsiñebei nun, gúndaatina báu. ");
INSERT INTO cabNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Lárigiñe, ába lanǘgüni Sífiri Sándu Jesúsu lídoun fulásu mageírawati, ");
INSERT INTO cabNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ába leréderun Jesúsu bián-wein wéyu ñi jagánagua anímaalugu janárimetiña. Sun dan le láubei ñi, ába loúchaguni Máfia, lárigiñe, ába jayábin ánjeligu lun jeténirun lun. ");
INSERT INTO cabNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Lárigiñe ladaürǘniwa Juan, ába lídin Jesúsu Galiléa apúrichijei ugánu buíti lúmagiñeti Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ába laríñagun. —Chülǘjali dan lun lagúmeserun larúeijan Búngiu, sáansi jumeí ligáburi joúserun, afíñe jumá luágu ugánu le lánina asálbaruni lídaangiñe figoú. ");
INSERT INTO cabNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Luágu ában wéyu, eíbugeina líña Jesúsu láru láru dúna le gíribei Galiléa, ába laríjini Simón lúma Andrés le lamúlen. Esénijani lubeígia jawádigimaribei, jáguruñati óra ligía. ");
INSERT INTO cabNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ába laríñagun joun. —Jigoúgu nárigi, falá jumana, madíajanjadünme úduraü, gürígiajañame jadíaja nun. ");
INSERT INTO cabNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ába jígirunun jasénin furése furése, ába joúdin lúma. ");
INSERT INTO cabNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ábati leíbugun Jesúsu murúsunraüya, ába laríjini Jacóbo le liraǘ Zebedéo, láu sun Juan le lamúlen, tídaañanu ában ugúnein arámadajoun jasénin. ");
INSERT INTO cabNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ába lagúarun joun, ába jígiruni jáguchi tídan ugúnein jáma ja íderagubaliña, ába joúdin lúma Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ába jachǘlürün lídoun fulásu le gíribei Capernaúm lídan wéyu le eméraaguagülei, ába lebélurun Jesúsu tídoun jalígilisin juríu, ába lagúmeserun arúfudaja joun. ");
INSERT INTO cabNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Weíriti janígi gürígia láu sun le laríñagubei Jesúsu joun ladǘga larúfudajan joun láu ubáfu, máma quei arúfudajatiña lilúrudun Moisés. ");
INSERT INTO cabNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ñíñein ában wügǘri tídan ligílisi tugúya láu ában espíritu wuríbati, ába lagúaragun. ");
INSERT INTO cabNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Cámesan bemétera wámoun, Jesúsu Nazarétna? ¿Biábiñasan lun bagǘnrichaguníwa? Subúdi numúti cátabu lan, láu amǘrü lan Búngiu Irájü le sándubei. ");
INSERT INTO cabNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ába ladeínjan Jesúsu lun espíritu wuríbati ligía, ába laríñagun lun. —¡Maníba, furíba lídaangiñe gürígia le! ");
INSERT INTO cabNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ába loúwejagüdüni espíritu wuríbati gürígia ligía, ába láfuridun lídaangiñe, wágueina. ");
INSERT INTO cabNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sun ja ñíbaña, ába laweíridun janígi, ába jálügüdagun jámagua. —¿Cáteisan le? ¿Cáteisan iséri arúfudajani le? ¡Gürígia le, gabáfuti lun gíñe lagúmadiruniña espíritu wuríbatiña áni agáamba jamúti! ");
INSERT INTO cabNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ába lagaambúniwa luágu Jesúsu lídan sun Galiléa furése. ");
INSERT INTO cabNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Dan le jáfuridunbei tídaangiñe ligílisi tugúya, ába lídin Jesúsu lúma Jacóbo láu Juan jábiñe Simón lúma Andrés. ");
INSERT INTO cabNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Roun tiñáti límenidi Simón, tabíruajaña, ába jaríñagun lun Jesúsu luágu sándiñoun lan. ");
INSERT INTO cabNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ábati lídin tuágun, ába lárügüdüni tújabu, ába liñúragunun, lídan meme óra ligía ába tareídagun, ába tásaarun, ába teténirun joun. ");
INSERT INTO cabNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Dan le lálüdün wéyu, gúñeeli, ába janügǘniwa sun sánditiña jáma sun ja gawágubaña espíritugu wuríbatiña lun Jesúsu, ");
INSERT INTO cabNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ába joúndaragun sun lílana fulásu lubádu béna. ");
INSERT INTO cabNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Areídaguagüdati Jesúsu sarágu sánditiña ja láutiña ámuñegueinarügü luwúyeri sándi, sagá ligía sarágu espíritugu wuríbatiña jaweí gürígia. Mígiruntijati lun jadímurejan espíritugu jagía, ladǘga subúdi jamáni cáteiñein lan. ");
INSERT INTO cabNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lubá larúgan, dan le búrigagili, ába lásaarun Jesúsu, ába láfuridun boúgudin lueí ubúrugu lídoun ában fulásu le mageírawati lun layúmuragun lun Búngiu ñi. ");
INSERT INTO cabNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ába lídin Simón jáma líbirigu áluajei. ");
INSERT INTO cabNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Dan le jadáriruni, ába jaríñagun lun. —Añájeintia sarágu gürígia áluajabu. ");
INSERT INTO cabNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ába laríñagun joun. —Queímoun lídoun buri líbiri fulásu le yaráfabei, apúrichija námuga gíñe ñi, ladǘga lun napúrichijan lídan sun fulásu niábin uboúagun. ");
INSERT INTO cabNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ítara líña lubeíti eíbuga lumúti Jesúsu sun Galiléa apúrichijeina tídan buri jalígilisin juríu lídan sun fulásu, aságajeina ligía espíritugu wuríbatiña jaweí gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ába liábin ában gürígia sánditi láu gumeín luágu sun lúra, ába lájuduragun ligíbugiñe Jesúsu, ába layúmuragun lun, laríñaga. —Gayáraati bareídaguágüdünina ánjabu busúen. ");
INSERT INTO cabNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ába lagúdemedagun lun Jesúsu, ába lagúuruni láu lújabu, ába laríñagun. —Láu sun nugúndan, areídaguabá. ");
INSERT INTO cabNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Quei laríñagun ítara, ába lareídagun sánditi ligía. ");
INSERT INTO cabNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ábati loúnajani Jesúsu ñígiñe láu ában furése, aríñageina lun. ");
INSERT INTO cabNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Mabájüdaguabeítia lun ni ában, ñǘdünrügübá arúfudagua búngua lun jafádirin juríu, ábame bíchuguni badágaragüdün luágu barúmadun queísi laríñaguni lilúrudun Moisés. Ítara lúba jaríjini gürígia luágu areídaguaadibu lan. ");
INSERT INTO cabNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ábarüga lídin, ába labájüdaguni sun le asúseredubei lun joun sun gürígia, ligía lébubei siñá lan leréderun Jesúsu furáangu lídan ni ában fulásu, ába leréderun le ñí lumuti úa jamá gürígia. Láu sun líra, ñǘbin mémetiña lídaangiñe sun fulásu aríjei. ");
INSERT INTO cabNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Átiri wéyu lárigiñe, ába lagíribudun Jesúsu Capernaúm, ába jagáambun gürígia luágu giríbujali lan. ");
INSERT INTO cabNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ába joúndaragun sarágu gürígia darí lun mabáraaña lan ni bénabu, ába lapúrichijani ugánu buíti lúmagiñeti Búngiu luágu jasálbarun joun. ");
INSERT INTO cabNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ñíñein apúrichija, ligía jayábin gádürü wügǘriña barüína jagía ában wügǘri le derégüdaali lúgubu. ");
INSERT INTO cabNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Queísiti siñá lubei jachǘlürün le ñí lubei Jesúsu ladǘga jíbe gürígia, ába jagídarun murúsun lueígiñe tábulugu múna loúgiñe le ñí lubei Jesúsu, ába jarárigüdüni sánditi ñígiñe tídan lubárari. ");
INSERT INTO cabNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Dan le laríjinbalin Jesúsu jafíñen, ába laríñagun lun le sándibei. —Niraǘ, ferúdunawaali bifígoun. ");
INSERT INTO cabNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ñíñanu jádaangiñe arúfudajatiña lilúrudun Moisés ja ñúnbaña ñi, ába jasáminarun. ");
INSERT INTO cabNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Cásan uágu ladímureja gürígia le ítara? Lanábaguñeiga le Búngiu, ladǘga úati ni ában gayáraati ferúduna lan figoú lueídügüya Búngiu.” ");
INSERT INTO cabNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Subúdi lumúti Jesúsu le jasáminarubei, ába laríñagun joun. —¿Cásan uágu jasáminara ítara? ");
INSERT INTO cabNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Cáteitimasan ménreengunbei laríñawagún lun sánditi le. “Ferúdunawaali bifígoun”, o laríñawagún lun. “Sarába, budáboun bubárari, beíba”? ");
INSERT INTO cabNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Narúfudaaliti jun luágu gabáfu nan, áu le Wügǘri Garaǘwarügüti lun ferúduna nan figoú. Ába laríñagun lun sánditi. ");
INSERT INTO cabNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Sarába, budáboun bubárari, beíba águyu. ");
INSERT INTO cabNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ába lásaarun sánditi lídan óra ligía, ába labúdunun lubárari, ába láfuridun ñígiñe, aríagu sun ja ñíbaña lun. Weíriti janígi ja ñíbaña luágu cátei le, ába jíchugun uweíriguni lun Búngiu, aríñageina. —¡Maríjiñajágidiwa cátei ítara buriti! ");
INSERT INTO cabNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ñígiñe, ábaya lídin Jesúsu láru dúna, dan le jayárafadun sarágu gürígia lubádun, ába larúfudajan joun. ");
INSERT INTO cabNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lásun larúfudajan joun, ába lasígiruni leíbugun, ába laríjini Leví, le liraǘ Álfeo, ñun líña le ñí lubei lagúburajoúa liseínsuna gumádi. Ába laríñagun lun. —Falábana, queímoun núma queísi náni disípulu. Ába lásaarun Leví, ába lafálaruni. ");
INSERT INTO cabNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Murúsun óra lárigiñe, ñíñein Jesúsu eíga lúbiñe Leví, ñíñanu gíñeti sarágu agúburajatiña liseínsuna gumádi, jáma ámu gafígountiña ñun luágu dábula úara lúma, jáma láni disípulugu, ladǘga sarágu jáña afálaruti. ");
INSERT INTO cabNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ja arúfudajatiña lilúrudun Moisés, jáma fariséogu, dan le jaríjinbalin eíga jáma sun wuríbatiña jagía (según jagía), ába jaríñagun joun láni disípulugu. —¿Ída liñásan leíginbei jumáesturun áni gurá ligía jáma agúburajatiña liseínsuna gumádi lúma jáma ámu gafígountiña? ");
INSERT INTO cabNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Dan le lagáambunbalin Jesúsu cátei le, ába laríñagun. —Ja magádiebaña mabúseerúntiña surúsia, ja sándibaña, jagía busénbaña surúsia. Máma lubeíti niábiña áluaja gürígia buítiña ligíbugiñe Búngiu, niábiña áluajaña ja gafígounbaña lun lasáansirún joúserun. ");
INSERT INTO cabNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Luágu ában wéyu, dan le jayúnarun lánigu Juan jáma jánigu fariséogu lun jagúnfulirun lúma Búngiu, ába jayábin fiú gürígia álügüdei Jesúsu. —¿Cásan uágu jayúnara lánigu Juan jáma jánigu fariséogu lun jagúnfulirun lúma Búngiu, ánjaña báni disípulugu mayúnaruntiña? ");
INSERT INTO cabNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ába loúnabun Jesúsu láu jémpulu luágu iséri larúfudajan lúma binádu, laríñaga. —¿Gayáraati funági jayúnarun amísurajoútiña lídan ában maríei dan le níjein lan adári ñi jáma? Ánjein níjein lubeí adári ñi, siñáti jayúnarun, lúnti jeígin. ");
INSERT INTO cabNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lachǘlürüba dan lun lanügǘniwa adári jámagiñe, ligíameti jadáani lun jayúnarun. ");
INSERT INTO cabNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","‘Máfadajoúntu anáanguni binádujaru táu gamísa to macháwaragungiru, ladǘga le méme tífe gamísa to macháwaragungiru tajeíridaguboun to binádujaruboun dánme le tacháwaragun, laweíridatimaabati jeíriti. ");
INSERT INTO cabNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Meserúnwati gíñe bínu le isérigili lídoun ában ágei guéru le binádujali ladǘga laboúchagubei bínu iséri guéru binádu dánme le liñúrun. Féridimeti bínu, féridi guéru. Bínu iséri lúnti leserúniwa lídoun guéru iséri. ");
INSERT INTO cabNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ában wéyu le eméraaguagülei, eíbugeina líña Jesúsu jáu láni disípulugu labádinagua bunáguaü, ába játüjan láni disípulugu türígu dan le jásügürün. ");
INSERT INTO cabNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ába jaríñagun fariséogu lun Jesúsu. —¡Aríjabá joun bánigu! ¿Cásan uágu jadǘga wadágimanu le moún lumuti ladügǘniwa lídan wéyu le eméraaguagülei? ");
INSERT INTO cabNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ába laríñagun joun. —¿Malíijangidün luágu le ladǘgübei Davíd luágu ában dan, dan le lalámachunbei, ligía jáu sun líbirigu? ");
INSERT INTO cabNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ába lebélurun ligílisirugun dan le Abiatár lan fádiri le íñutimaabei, ába leíginun fein to sagráuboun, to majoúaboun jeíginun ámu gürígia jaweídügüya fádirigu según lilúrudun Moisés, áni ru ligía joun gürígia ja lúmabaña. Mámati figoú le ladǘgübei Davíd ligíbugiñe Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ába gíñe laríñagun Jesúsu joun. —Lun wügǘri ladügǘwa wéyu le eméraaguagülei, máma wügǘri adügǘwabei lun wéyu ligía. ");
INSERT INTO cabNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ligía gabáfutina gíñe, áu le Wügǘri Garaǘwarügüti, lun naríñagun cába lan gayára ladügǘniwa lídan wéyu le eméraaguagülei. ");
INSERT INTO cabNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ábaya lebélurun Jesúsu tídoun ában jalígilisin juríu, ñíñeinti ában wügǘri jiláali ában lújabu. ");
INSERT INTO cabNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jaríjati ja ñíbaña ánjein lagáranijaba lubeí Jesúsu lun lídan wéyu le eméraaguagülei, lun jadárirun lidúnrun. ");
INSERT INTO cabNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ába laríñagun Jesúsu lun le jiláalibei újabu. —Sarába, ráramabá ya jagíbugiñe súngubei. ");
INSERT INTO cabNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ába lálügüdüniña ja jíbiri. —¿Cátei lúnbei ladügǘniwa lídan wéyu le eméraaguagülei, lun jíderawagúniwa gürígia ódi lun ladügǘniwa wuríbati joun, lun leséfurúniwa jabágari ódi lun jígirúniwa lun joúnwen? Sun jagía, ába jámanichun. ");
INSERT INTO cabNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ábati laríaguniña Jesúsu láu igáñi lúma íruni ladǘga tidére janígi. Ába laríñagun lun wügǘri ligía. —Tulébei bújabu. Ába látuleruni, ába lareídagun. ");
INSERT INTO cabNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ába jáfuridun fariséogu, ába jagúmeserun adímureja jámagua jáma gíñe lánigu Heródes ída lúba lan jáfaruni Jesúsu jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ába lídin Jesúsu jáu láni disípulugu lárun dúna, ába jafálaruni sarágu gürígia Galiléana. ");
INSERT INTO cabNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Dan le lagaambúnbei luágu oúnwenbun buri cátei le ladǘgübei, ába jayábingua gürígia Judéagiñe, Jerusaléngiñe, Iduméagiñe, loubáfurugugiñe dúna le Jordán, Tírogiñe, lúma Sidóngiñe lun jaríjini. ");
INSERT INTO cabNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ligía laríñagunbei Jesúsu joun láni disípulugu lun aráanseñu jamá ában ugúnein lubá lueí jámuruduni sarágu gürígia jagía, ");
INSERT INTO cabNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ladǘga queí gíbeeña lan lareídaguagüdün, sun sánditiña, ába jáguragun joúngua luágun lúnrügü jagúuruni lun lareídaguagüdüniña. ");
INSERT INTO cabNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Dántija le jaríjini ja gawágubaña espíritugu wuríbatiña, ábaja jájuduragun ligíbugiñe, ába jagúaragun espíritugu jádaangiñe. —Liraǘ Búngiu amǘrü. ");
INSERT INTO cabNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ába lewéridiruniña Jesúsu lun maríñagun jamá cáteiñein lan. ");
INSERT INTO cabNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Lárigiñe, ába lamúdeirun Jesúsu luágun ában wǘbü ñí lubei lagúara joun ja labúseerubaña queísi loúnagülegu, ába jayábin lun. ");
INSERT INTO cabNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ába lanúadirun dúusu jádaangiñe lun lúmabaña lan súnwandan lúma lun japúrichijani ugánu buíti lánina asálbaruni. ");
INSERT INTO cabNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ába líchugun ubáfu joun lun jareídaguagüdün sánditiña lúma lun jaságajan espíritugu wuríbatiña. ");
INSERT INTO cabNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Niján jíri dúusu wügǘriña jagía. Simón, le únbei lagúaja Jesúsu Pédro, ");
INSERT INTO cabNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacóbo láu Juan le lamúlen, ja lirájüñü Zebedéo, ja únbaña lagúaja Jesúsu Boanérges—míni lan líra, Lirájüñü Wayújururu, ");
INSERT INTO cabNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felípe, Bartolomé, Matéo, Tomás, Jacóbo le liraǘ Álfeo, Tadéo, Simón—ában meja wügǘri le áfaaguti lun jawáanserun juríu, ");
INSERT INTO cabNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","lúma Júdas Iscarióte le alúgurubalin Jesúsu. Lárigiñe, ába jagíribudun járigoún, ába jebélurun tídoun ában múna, ");
INSERT INTO cabNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ábaya joúndaragun sarágu gürígia ñi darí lun madáani jamá ni lun jeígin. ");
INSERT INTO cabNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Dan le jasúbudirunbalin lidújeñu Jesúsu ca lan ásügürübei, ába jayábin lún yebe janǘgüni, ladǘga jaríñagun gürígia luágu wuríbaali lan lichǘgü. ");
INSERT INTO cabNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ñíñanu arúfudajatiña lilúrudun Moisés ja achǘlürübaña Jerusaléngiñe, ába jaríñagun. —Wügǘri le, níjein Beelzebú, le Máfia, le jábuti espíritugu wuríbatiña, lúma, láu lubáfu Máfia laságaja espíritugu wuríbatiña. ");
INSERT INTO cabNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ábati lagúarun Jesúsu joun lun jayárafadun lubádun, ába líchugun ában jémpulu joun, ába laríñagun. —¿Ída lúba gayára lan laságaruni Máfia Máfia guánarügü? ");
INSERT INTO cabNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Furúmieguarügü arúeijani le afánreinraguti lun jageíndagun jámagua, lagǘnrinchaguba, ");
INSERT INTO cabNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","áni ánjein fánreingujaña lubeí idújeñu ladǘga wuríbu jádaangua, siñábei jadúrarun idújeñu jagía queísi idújeñu. ");
INSERT INTO cabNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ánjein lubeí jamúgati afáreinragua Máfia, lageíndaguame lúmagua, siñábei ladúrarun, lagúmuchagülerügübei le. ");
INSERT INTO cabNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","‘Úati ni ában lun lebélurun lúbiñoun ában wügǘri le jéreti lun lanǘgüni lílagu ánjein magǘragun lan wügǘri jéreti ligía furúmiñe. Ítara rügǘñein gayára lan lanǘgüni lílagu. ");
INSERT INTO cabNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","‘Láu sun ninárün naríñagun jun luágu gayára lan ferúdunawa lan sun figoú lúma sun wuríbani le laríñagubei gürígia, ");
INSERT INTO cabNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","lueídügüya lun jadímurejan wuríbati luágu Sífiri Sándu, siñábei ferúdunawa lan figoú líra, leréderuba lidúnrun lun sun dan. ");
INSERT INTO cabNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Laríñagunbalin Jesúsu líra, ladǘga jaríñagun luágu lubáfu lan Máfia lubáfu Sífiri Sándu le luágubei. ");
INSERT INTO cabNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lárigiñe, ába tachǘlürün lúguchu Jesúsu jáu lamúlenu tubádun múna to ñí lubei Jesúsu, ába jeréderun boúgudi, ába joúnagüdün luágu. ");
INSERT INTO cabNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Játi ñúnbaña geyégu láu Jesúsu, ába jaríñagun lun. —Nurántia búguchu jáu bamúlenu boúgudi, jáluajañádibu. ");
INSERT INTO cabNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ába laríñagun joun. —¿Cági núguchuboun jáu namúlenu? ");
INSERT INTO cabNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ába laríagun jawágun ja ñúnbaña geyégu láu, ába laríñagun. ");
INSERT INTO cabNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","—Añája núguchu jáu namúlenu, ladǘga furúmieguarügü ja adǘgüti lugúndan Búngiu, jagía namúlenubaña, nítunu, núguchu. ");
INSERT INTO cabNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ábaya lagúmeserun Jesúsu arúfudaja láru dúna, ába joúndaragun sarágu gürígia le ñí lubei. Quei gíbeyaaña lan gürígia ñi, ába ládinun Jesúsu tídoun ában ugúnein to ñíboun dúnarugu. Ába lañúurun ñi, ába jeréderun sun gürígia láru béya. ");
INSERT INTO cabNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ábati larúfudajan sarágu cátei joun láu jémpulu, laríñaga joun. ");
INSERT INTO cabNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Agáamba jumána. Ñíñein ában ábunaguti, ába láfuridun ábunagua. ");
INSERT INTO cabNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Lídan afúrujeina láani líla nádü, ába láburujan murúsun lídaangiñe luágun ǘma, ába jayábin dunúru, ába jeígini. ");
INSERT INTO cabNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Líbiri, ába láburujan labádinaguoún dǘbü le ñí lumuti úa lan sarágu múa, ába laboúchun furése ladǘga majúlilin lan múa. ");
INSERT INTO cabNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Dan le lásüdün wéyu, ába lásaürün, queíti málagüle lan, ába loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Líbiri ílaü, ába láburujan labádinaguoún jíyu, ába laweínamudun jíyu úara lúma, ába lañáradaguagüdüni, magíinduntiti nádü ligía. ");
INSERT INTO cabNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Níjeinti lídaangiñe, áburujati lídoun múa buíti, ába laboúchun, ába laweínamudun, ¡ma lubuídun alúbajoúti lídaangiñe! Níjein lídaangiñe, íchuguti darándi águu luágu cáda ában águu, líbiri rúti ǘrüwa-wein, líbiri, san. ");
INSERT INTO cabNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ábati laríñagun joun. —Ja garígeirugubaña lun jagáambun, agáamba jamá. ");
INSERT INTO cabNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Lárigiñe, dan le leréderunbei Jesúsu lábugua, ába jayábin láni dúusu disípulugu jama jíbiri lánigu, ába jálügüdüni ca lan lílabei jémpulu le. ");
INSERT INTO cabNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ába laríñagun joun. —Jugúya, subúdigüda láali Búngiu cátei arámudaguati le lánina larúeijan jun, ánjaña ja mebéresenbaña láu lerérun, láu jémpulu laríñawagúa cátei luáguti larúeijan joun, ");
INSERT INTO cabNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","lun dánme lan jaríjin, ibídiñe lámuga joun ca lan laníchigubei cátei le jaríjubei, dánme jagáambun, úa lámuga gunfaráanda jamá, lun lásiñerun jagíribudun lun Búngiu lun ferúdunawa lan jafígoun. ");
INSERT INTO cabNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ába laríñagun joun. —¿Úatisan gunfaráanda jumáni le? ¿Ída lubági gunfaráanda jumáni líbiri jémpulu? ");
INSERT INTO cabNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Le ábunagubalin líla nádü, ítara líña quei le apúrichijabalin Lerérun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Añájein gürígia, ítara jáña quei ǘma le uágunbei láburuja lídaangiñe líla nádü, ába jagáambuni Lerérun Búngiu, lárigiñe jagáambuni, ába liábin Máfia, ába lagídaruni dimúrei le abunúbei tídan janígi. ");
INSERT INTO cabNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jíbiri gürígia, ítara jáña quei dǘbü le abádinaguoúnbei láburuja lídaangiñe líla nádü, ába jagáambuni Lerérun Búngiu, ába jerésibiruni láu ugúndani. ");
INSERT INTO cabNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Quei márügüdün lubeí Lerérun Búngiu tídan janígi buídu, madúrati jádan, dánti le larijíniwa jábun, o jeíbaajoúniwa lan lueígiñe Lerérun Búngiu, magúraasuntiña. ");
INSERT INTO cabNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jayábin jíbiri, ítara jáña quei jíyu le abádinaguoúnbei láburuja lídaangiñe líla nádü, ába jagáambuni Lerérun Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","weíritimaati jafúudun luágu cátei le lánina ibágari le, ába leyéeduniña irísini. Sun le, ába láfaruni Lerérun Búngiu tídaangiñe janígi, mígiruntiti lun lalúbajoún jádan gürígia jagía. ");
INSERT INTO cabNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Añájein gíñe gürígia, ítara jáña quei múa buíti le ídounbei láburuja lídaangiñe líla nádü, ába jagáambuni Lerérun Búngiu, ába jerésibiruni, alúbajoúati cátei buíti jádaangiñe. Buíti jagáburi quei líla nádü le íchugubei darándi águu luágu ában, o ǘrüwa-wein, o san. ");
INSERT INTO cabNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ába laríñagun joun. —¿Béwati funági ában lámpu lun líchugúniwa tábugiñe ában gáfu o tábugiñe lan gabána? ¡Uá! Luágu dábula líchugúa lun larúgoungadágüdün múnada. ");
INSERT INTO cabNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Úati lubeíti ni cáta le arámudaguati lun mafúnraangudúnbei lan, úa ligía ni cáta le ibídiñewati lun masúbudirúnwabei lan. ");
INSERT INTO cabNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Agáamba jumána, jugúya le garígeirugubei lun jagáambun. ");
INSERT INTO cabNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aríñagati gíñe joun. —Toúnigi jumátia lun jagúnfulirun lúma inárüni le jagáambunbei. Láuba jagúnfuliruni, gunfaráandatima jumáni le naríñagubei jun. ");
INSERT INTO cabNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ítara líña, gürígia le aténirubei buídu lun nerérun, gunfaráandatima lumúti, ánjeinti le meténibei lun, labúlieidubei sun le agáamba láalibei. ");
INSERT INTO cabNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Aríñagati gíñe Jesúsu. —Ítara líña larúeijan Búngiu quei le asúseredubei lun ában wügǘri le ábunubei líla nádü lábugiñe múa, ");
INSERT INTO cabNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","áriebu buri lúma wéyuagu lídan le larúmugun ábunaguti ligía, sará ligía quei léchun, chülǘ dan ába laboúchun nádü, ába laweíridun, ibídiñeti lun ábunaguti ída líña lan lasúseredun. ");
INSERT INTO cabNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Múa guánarügü aráandarati, furúmiñe ába láfuridun ídibu, ñígiñe ába legélewejan, ñígiñe ába labuínchun ílewei láu ílaü. ");
INSERT INTO cabNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Dánti le funáali líla nádü, ába látüjoúniwa ladǘga chülǘjali lan dan lun lalúbajoún. ");
INSERT INTO cabNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Aríñagati gíñe Jesúsu. —¿Cásan lenégebei larúeijan Búngiu, o ca jamúga jémpulu gayáraabei wíchuguni lúmoun? ");
INSERT INTO cabNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ítara líña quei ában tíla mostása le abunúti lábugiñe múa. Tíla mostása, ligía ában lídaangiñe ílaü le ñǘraütimaabei uboúagu, ");
INSERT INTO cabNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","dan le labunún, ába laweíridun, ligía weíritimaabei tídaangiñe sun nádü, weínamuti lilímun darí lun gayára lan jeméraagun dunúru lábugiñe lamúñounga le líchugubei. ");
INSERT INTO cabNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ítara liñájei larúfudajan Jesúsu luágu larúeijan Búngiu joun láu sarágu jémpulu líbe le darí le ñí lumuti gayára lan gunfaráanda jamá. ");
INSERT INTO cabNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Marúfudajaanti ni cáta joun luágu larúeijan Búngiu mayúsurunga jémpulu. Ába lafúnraanguagüdüni sun jémpulu joun láni disípulugu dan le jagíarügü lan lúma. ");
INSERT INTO cabNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wéyu méme ligía, dan le lagúñedunbei, ába laríñagun Jesúsu joun láni disípulugu. —Queímoun loubáfurugun dúna. ");
INSERT INTO cabNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ábati jígiruniña bürǘbünu gürígia jagía, ába janǘgüni Jesúsu tídan ugúnein to gádaanbaliña. Ñíñoun buri gíñe ámu ugúnein úara jáma. ");
INSERT INTO cabNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ába láfuragun ában garábali jéreti, ába lebélujan lugúdi barána tídoun ugúnein darí lún yebe tabuínchun láu dúna. ");
INSERT INTO cabNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Larúmuguñati Jesúsu tiyúna ugúnein baláñu tuágu ában ichǘgübarari. Ába jagágudajani, ába jaríñagun lun. —¡Maésturu! ¿Mebéreseguntibusan láu wadíbiragua lan? ");
INSERT INTO cabNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ába lásaarun Jesúsu, ába ladeínjan lun garábali, ába laríñagun lun barána. —¡Maníba! ¡Derégüdaguabá! Ába lagálumadun garábali, ába darángila lan sun cátei. ");
INSERT INTO cabNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ábati laríñagun joun láni disípulugu. —¿Cásan uágu luweírinbei janúfude? ¿Cásan uágu mafíñen jubeí? ");
INSERT INTO cabNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ába jeréderun láu luweírin janígi, ába jálügüdagun jámagua. —¿Cátei funásan le, garábali lúma barána ñǘdüntiña láu le lubeíbei? ");
INSERT INTO cabNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ába jachǘlürün loubáfurugun dúna lídoun fulásu le gíribei Gadára. ");
INSERT INTO cabNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lárigiñerügü láfuridun Jesúsu tídaangiñe ugúnein, ába liábin ában gürígia lídaangiñe ában umúajaü achigíti luágu dǘbü luágun, wügǘri ligía gawáguti ában espíritu wuríbati. ");
INSERT INTO cabNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Lídan jabára jiláaña lagánoua áni úati ni ában gayáraati lagǘraguni, ni láu güríngüri. ");
INSERT INTO cabNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Güráguañája jamáali láu güríngüri luágu lugúdi lúma luágu lújabu, súnwandan látumuraguni, úati ni ában gayáraati lámuruduni. ");
INSERT INTO cabNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Súnwandanja leíbugun áriebu wéyuagu agúarajeina luágu buri wǘbü lúma buri lídan jabára jiláaña íbiagua lúngua láu dǘbü. ");
INSERT INTO cabNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Dan le laríjinbalin gürígia ligía Jesúsu dísegiñein, ába leíbaagun lubároun, ába lájuduragun ligíbugiñe, ");
INSERT INTO cabNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ába lagúaragun lun. —¿Cásan uágu bemétera númoun, Jesúsu Liraǘ Búngiu le Íñutimaabei? Ayúmuraguatina bun luágu líri Búngiu lun masúfuriragüdün bánina. ");
INSERT INTO cabNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Laríñagunbei ítara ladǘga guméseeli lan Jesúsu aríñaga lun. —¡Espíritu wuríbati, ígirabeí gürígia le! ");
INSERT INTO cabNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ába lálügüdüni Jesúsu. —¿Ca bíri? Ába loúnabun. —Lejión níña ladǘga gíbetiwa. ");
INSERT INTO cabNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ába jayúmuragun espíritugu jagía lun Jesúsu lun moúnajan lániña boúgudin lueí fulásu ligía. ");
INSERT INTO cabNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Queíti ñíñanu lan sarágu büíruju eíga ñi luágu wǘbü, ");
INSERT INTO cabNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ába jayúmuragun espíritugu wuríbatiña jagía lun. —Oúnaja báwa jádoun büíruju jára, rúba ǘma woun lun webélurun jádoun. ");
INSERT INTO cabNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ábati líchugun Jesúsu ǘma joun, ába jáfuridun lueí gürígia ligía, ába jebélurun jádoun büíruju. Ñíñanu jawára bián-mílu büíruju. Ába jáguragun büíruju jagía joúngua lueígiñe ában gudúungu, ába jáburujan baránajoun, ába jañáradagun. ");
INSERT INTO cabNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ábati janúfudedagun ja oúnigirubaliña büíruju jagía, ába jeíbaagun abájüdaguei le asúseredubei ubúrugu lúma áraabu. Ába jayábingua gürígia aríjei ca lan asúseredubei. ");
INSERT INTO cabNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Dan le jachǘlürünbei le ñí lubei Jesúsu, ába jaríjini gürígia lé meja gawágubei espíritugu wuríbatiña ñun líña, táuñein gíñe lanáangun, areídaguaali, ába janúfudedagun. ");
INSERT INTO cabNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Játi aríjubalin, ába jabájüdaguni le asúseredubei lun gürígia lé buga gawágubei espíritugu wuríbatiña lúma jawáguti büíruju, joun. ");
INSERT INTO cabNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ábati jayúmuragun lun Jesúsu lun láfuridun lídaangiñe jageíra. ");
INSERT INTO cabNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dan le ládinun Jesúsu tídoun ugúnein, ába layúmuragun wügǘri lé buga gawágubei espíritugu wuríbatiña lun lun lídin lúma, ");
INSERT INTO cabNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","májati Jesúsu, aríñagarügüti lun. —Beíba júbiñoun jámoun bidújeñu, ábame babájüdaguni sun le ladǘgübei Babúreme Búngiu báu, ída líña lan bagúdemedun lun. ");
INSERT INTO cabNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ába lídin, ába lagúmeserun abájüdaguei sun le ladǘgübei Jesúsu láu lídan sun fulásu Decápolis, ába laweíridun janígi súngubei. ");
INSERT INTO cabNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Dan le lagíribudunbei Jesúsu tídan ugúnein loubáfurugun dúna, ába jayábingua bürǘbünu gürígia le ñíjin lubeí, ába leréderun ñi láru dúna. ");
INSERT INTO cabNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ábati liábin ában jádaangiñe tábuti jalígilisin juríu, gíriti Jáiro. Dan le laríjinbalin wügǘri le Jesúsu, ába lájuduragun lubádu lugúdi, ");
INSERT INTO cabNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ába layúmuragun lun ítara. —Nújein niraǘ toúwe, queímoun bíchigei bújabu tuágu, areídagua támuga, moúnwen támuga. ");
INSERT INTO cabNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ába lídin Jesúsu lúma, sarágu jáña gürígia afálarutiña, ába buriti jámurudaguni Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jádaanti sarágu gürígia ja, ñíñoun ában wǘri sánditu, dúusu irúmu táu láu lésejan jítaü tídaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Súfurijaru sarágu jámagiñe surúsiagu áni gásta táali sun le túmati, mareídaguntu, gáwoun gueínarügü. ");
INSERT INTO cabNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ligía tagáambun ladímurejoún luágu Jesúsu, ába tiábin lanágangiñe jádan sarágu gürígia, ába tagúurunun lanáangun, ");
INSERT INTO cabNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ladǘga taríñagun túnguarügü. “Láurügüme nagúurunun lanáangun nareídaguba.” ");
INSERT INTO cabNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Lídan óra ligía, ába leréderun lésejan jítaü tueí, ába tasándiragun túngua luágu areídaguaaru lan. ");
INSERT INTO cabNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ábati lasándiruni Jesúsu luágu areídaguagüdaali lan gürígia láu lubáfu, ába lagáraragun jawágun gürígia ja lanágangiñébaña, ába lálügüdajan. —¿Ca agúurubei tuágu nanáangun? ");
INSERT INTO cabNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ába jaríñagun láni disípulugu lun. —Aríagu biñátia lun jíbe gürígia ya luágu murúgu jáña lan, ¿álügüdajágidibu ca lan agúurubei buágu? ");
INSERT INTO cabNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ába laríaajan Jesúsu áluaja ca lan agúurubei luágu. ");
INSERT INTO cabNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ába tiábin wǘri tugúya adádagareina láu anúfudei, subúdiñuteí le asúseredubei tun, ába tájuduragun ligíbugiñe, ába taríñaguni sun inárüni lun. ");
INSERT INTO cabNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ába laríñagun Jesúsu tun. —Niraǘ, areídaguaadibu ladǘga bafíñen. Beíba láu darángilaü, areídaguañu lídaangiñe bisándi. ");
INSERT INTO cabNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ñígili Jesúsu adímureja, ligía jayábin lúbiñegiñe wügǘri lé buga ñǘdünbei oúgei luágu tisándi liraǘ, ába jaríñagun lun túguchi irájü tugúya. —Jilátia biraǘ, ¿ca uágu bebéreseja lun maésturu guetó? ");
INSERT INTO cabNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Agáamba lumúti Jesúsu le jaríñagubei, ába laríñagun lun wügǘri ligía. —Manúfudedabá, afíñerügübá. ");
INSERT INTO cabNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Májatiti joúdin ámu lúma lueídügüya Pédro, Jacóbo lúma Juan le lamúlen Jacóbo. ");
INSERT INTO cabNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Dan le lachǘlürünbei lúbiñoun wügǘri ligía, ába laríjini chagáguaü jáma gürígia ja ayájubaña, agúaraja. ");
INSERT INTO cabNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ába lebélurun, ába laríñagun joun. —¿Cásan uágu jareíncha, ayájua buri jugúya ítara? Moúnwentutia irájü to, tarúmuguña. ");
INSERT INTO cabNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ába jéjerajan láu. Ábati láfuridagüdǘniña Jesúsu súngubei ñígiñe, ába lanǘgüni túguchi irájü túma túguchu jáma ja ñǘdünbaña lúma, ába lebélurun le ñíjin tubeí irájü. ");
INSERT INTO cabNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ába lárügüdüni tújabu, ába laríñagun tun. —Talíta, cúmi—líla líra. Niraǘ, sarába. ");
INSERT INTO cabNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Lídan óra ligía, ába tásaarun irájü tugúya, ába teíbugun. Weíyaraüjaru, dúusu irúmu táu. Ába laweíridun janígi gürígia ja ñíbaña. ");
INSERT INTO cabNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ába líchugun Jesúsu dimúrei derégüdati joun lun mabájüdagun jamáni ni ca un, ába laríñagun joun lun jíchugun eígini tun. ");
INSERT INTO cabNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ába lídin Jesúsu ñígiñe, ába lagíribudun lageíroun, ába joúdin láni disípulugu lúma. ");
INSERT INTO cabNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Dan lachǘlürün wéyu le eméraaguagülei, ába larúfudajan tídan jalígilisin juríu, sarágu jáña gürígia agáambei, ába laweíridun janígi láu larúfudajan, ába jaríñagun. —¿Jalía funásan lafúnrendeirei gürígia le sun le? ¿Cáteisan lichú áu le luágubei? ¿Ída liñásan gayára lubeí ladáagun miláguru? ");
INSERT INTO cabNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Saráfangeiga le tiraǘ María le, líbugaña Jacóbo, José, Júdas, lúma Simón, ñáñanu gíñe lítunu wáma. Ába jíchugun mabájüdüni luágu. ");
INSERT INTO cabNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ába laríñagun Jesúsu joun. —Sun gürígia, gúndaatiña láu ában proféta jaweídügüya ja lupaísanun jáma lidújeñu, jáma ja tílana lúban, jagía rügǘñanu íchiga mabájüdüni luágu. ");
INSERT INTO cabNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ligía lásiñerunbei ladǘgün ámu miláguru ñi lueídügüya líchugun lújabu jawágu biñáraü sánditiña, ába lareídaguagüdüniña. ");
INSERT INTO cabNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Weírititi lanígi láu mafíñen jamá. Lárigiñe, ába leíbuguni lirájüñü fulásu, arúfudajeina. ");
INSERT INTO cabNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ába loúnajan jawágu láni dúusu disípulugu lun lagúmeserun oúnajaña bián bián, ába líchugun ubáfu joun lun gayára lan jaságarun espíritugu wuríbatiña. ");
INSERT INTO cabNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Rúti dimúrei joun lun manǘgün jamá ni cáta luágu jeíbugun lueídügüya bádun, moún lumuti janǘgün ni fein, ni ságü, ni seínsu, ");
INSERT INTO cabNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","lun geídi tan jasábadun, lun mabíaman tan jasímisin. ");
INSERT INTO cabNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ába gíñe laríñagun joun. —Dánme le jebélurun lídoun ában fulásu apúsaraja, reídei jumá ñi tídan ában méme múna darí jáfuridun lídaangiñe fulásu ligía. ");
INSERT INTO cabNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ánjaünti merésibirúniwa lídan ában fulásu, mája jagía jagáambunün, furíjuma ñígiñe, ábame jáfuruduni calíqui lueígiñe jugúdi, liseínime magúndani jáu lílana fulásu ligía, ígira jumáña quei jadáriragun joúngua. Le ninárün jáu luágu dánme lan lachǘlürün luwéyuri Búngiu lun lagúseragüdüniña sun gürígia, maweíribei jabeichúniwa Sodómana jáma Gomórrana quei lílana fulásu le merésibirunbalün. ");
INSERT INTO cabNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ábati jáfuridun, ába japúrichijan joun gürígia luágu lúnti lan jasáansiruni ligáburi joúserun. ");
INSERT INTO cabNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sagátiña gíñe sarágu espíritugu wuríbatiña jaweí gürígia, jurúgua jagía aíli jawágu sarágu sánditiña, ába jareídaguagüdüniña. ");
INSERT INTO cabNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Queíti eíbaajali lubeí luáguti Jesúsu lídan sun fulásu, ába gíñe lachǘlürün lábun lagáambun urúei Heródes. Sarágu jáña aríñagutiña. —Saráya Juan le abásteragüdajabei lídaangiñe oúweni, ligía luweírinbei lubáfu. ");
INSERT INTO cabNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jaríñaga jíbiri. —Elías lé meja proféta le. Jíbiri aríñaga. —Ában proféta quei ja binádu. ");
INSERT INTO cabNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dan le lagáambunbalin Heródes sun le, ába laríñagun. —Juan le, le nadǘrüragüdübei ichǘgü, saráaya lídaangiñe oúweni. ");
INSERT INTO cabNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Lé meja asúseredubei, oúnajali meja Heródes adáürei Juan, ába lagǘraguni láu güríngüri furísunrugu tadǘga Heródias. Wǘri tugúya, lúmari meja Felípe, le lamúlen Heródes, ába lanǘgünun Heródes lúmarime. ");
INSERT INTO cabNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ába meja laríñagun Juan lun Heródes. —Moún lumuti bagámaridunun lúmari bamúlen. ");
INSERT INTO cabNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ába liyéreegudun Juan tun Heródias, ába tabúseerun táfaruni jilágubei, ");
INSERT INTO cabNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","siñá tumuti ladǘga subúdi lan lun Heródes luágu ában lan wügǘri le eíbuguti buídu lúma Búngiu Juan, áni ában lan wügǘri esériwiduti lun Búngiu, janúfudetiti lueí. Ligía mája lubeí lun tadǘgün ni cáta láu. Láu sun úa lan gunfaráanda láani Heródes le laríñagubei Juan lun buídu, agáamba lumúti láu ugúndani. ");
INSERT INTO cabNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ába tadáriruni Heródias ticháansin dan le lagúnfulirun Heródes irúmu, ába ladǘgün fédu joun gumádimatiña jáma jábutigu súdaara jáma ámu buri gürígia weírigutiña ja Galiléabaña. ");
INSERT INTO cabNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ába tebélurun tiraǘ Heródias ñí lubei fédu le, ába tabínajan, gúndaatiti Heródes jáma sun ja ñíbaña eíga lúma láu tabínajan irájü to, ába laríñagun tun. —Amúriajabeí le babúseerun núma, níchugubei bun. ");
INSERT INTO cabNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Rúlumuti lerérun tun luágu líchugubei lan furúmieguarügü cátei le tamúriajan lúma tun, gayára lan lamídan lan fulásu le ñí lubei larúeijan tamúriaja. ");
INSERT INTO cabNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ába táfuridun, ába taríñagun tun túguchu. —¿Cábasan namúriaja lúma? Ába taríñagun tun. —Amúriajabeí lábulugu Juan le abásteragüdajabei lúma. ");
INSERT INTO cabNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ába tebélurun irájü to furése le ñíjin lubeí urúei, ába taríñagun lun. —Buséntina lun bíchuguni lábulugu Juan le abásteragüdajabei nun lídan ában asíedu guelé guelé. ");
INSERT INTO cabNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ába lajírudagun urúei sarágu, quei rúlaali lan lerérun áni agáambagu jáña amísurajoútiña lun, májati lun míchu lubeí lan le tamúriajabei lúma tun. ");
INSERT INTO cabNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Furése furése, ába loúnajan urúei ában súdaara láu dimúrei lun lanǘgüni lábulugu Juan lun. ");
INSERT INTO cabNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ába lídin súdaara ligía furísunrugu, ába ladǘrürüni lábulugu Juan, ába lanǘgüni lídan ában asíedu. Ába líchuguni tun irájü tugúya, ába tíchuguni tun túguchu. ");
INSERT INTO cabNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Dan le jagáambunbalin lánigu Juan, ába jayábin lun janǘgüni lúgubu, ába jábununi. ");
INSERT INTO cabNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Lárigiñe jagíribudun láni Jesúsu apóstolugu, ába joúndaragun lúma, ába jabájüdaguni sun le jadǘgübei lúma le jarúfudajabei, lun. ");
INSERT INTO cabNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ába laríñagun Jesúsu joun. —Jigoúgu, queímoun weméraagua lídan ában fulásu le mageírawati. Laríñagubaalin líra ladǘga ñíñanu sarágu gürígia, jíbiri ñǘdün, jíbiri ñǘbin, darí lun madáani lan Jesúsu jáma láni disípulugu ni lun jeígin. ");
INSERT INTO cabNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ába joúdin tídan ába ugúnein lídoun ában fulásu mageírawati. ");
INSERT INTO cabNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sarágu jáña aríjiti joúdin, dan le jasúbudiruni luágu níjein lan Jesúsu jádan, ába jeíbaagun geyégua láu lagúnu lídaangiñe sun lirájüñü fulásu, ába jachǘlürün lubáragiñe lachǘlürün Jesúsu jáu láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Dan le larárirunbei Jesúsu tídaangiñe ugúnein, ába laríjin sarágu gürígia jagúrabajañein, ába jagúdemedagun lun ladǘga ítara jáña lan quei mudún ja moúniritiña. Ába lagúmeserun arúfudaja sarágu cátei joun. ");
INSERT INTO cabNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Dan le dárüjali, ába jayábin láni disípulugu, ába jaríñagun lun. —Dárüjalitia áni úatiña aganoútiña lídan fulásu le. ");
INSERT INTO cabNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Oúnaja báña gürígia ja lun joúdin lídoun buri lirájüñü fulásu le yaráfabei lun jagáñijan fein, ladǘga úati ni cáta ya lun jeígin. ");
INSERT INTO cabNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ába laríñagun Jesúsu. —Rújuma eígini joun. Ába jaríñagun lun. —¿Gayáraati funági woúdin agáñija fein joun? Busénwati jamúga lebégi bián-san wéyu wadágimanu lun wabíjini seínsu lun wíchugun fein joun súngubei. ");
INSERT INTO cabNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Laríñaga Jesúsu joun. —¿Átiriñoungi fein júma? Jeíba aríjoun. Dan le jaríjinun, ába jaríñagun lun. —Seíngü fein jáma bián úduraü. ");
INSERT INTO cabNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ába lañúuragüdüniña gürígia sagádirugu. ");
INSERT INTO cabNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ába jañúurun san san lúma dimí dimí san, queísi laríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ába lanǘgünun Jesúsu seíngü fein to lújaburugu jáma bián úduraü ja, ába laríjin siélun, ába leteíngiruni Búngiu tuágu, ába lagúbachagúnun, lárigiñe, ába lamúrusujanun lun líchugunun joun láni disípulugu lun jafánreinjanun jádan gürígia jagía, fánrein jamáña gíñe bián úduraü jagía jádan súngubei. ");
INSERT INTO cabNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Joútiña sun jagía químule. ");
INSERT INTO cabNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Lárigiñe, ába jabuínchagüdün dúusu faníñe láu tífe fein lúma úduraü ígiragúti. ");
INSERT INTO cabNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Seíngüñanu mílu wügǘriña eígitiña, mabájüdünga würíña jáma irájüñü. ");
INSERT INTO cabNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ába ládinagüdüniña Jesúsu láni disípulugu tídoun ugúnein lun jánjiñuragun lubá lun jachǘlürün Betsáida, sun niján lan ayoúragua joun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Dan le ñǘdünjaña, ába lídin luágu wǘbü ayúmuragua lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Dan le lagúñedunbei, lamídaanjaru dúna ugúnein jáu disípulugu, Jesúsu rugáali lábugua múarugu. ");
INSERT INTO cabNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ába laríjin luágu jénreenguja lan joun lun jénjunjan ladǘga jabárouñein lan garábali. Lubá larúgan, ába lídin Jesúsu jawágun eíbugeina ligíbuagu dúna, lásügürá yebe jáu. ");
INSERT INTO cabNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Dan le jaríjini eíbuga ligíbuagu dúna, ába jarítagun luágu úfiaü lan, ába jagúaragun, ");
INSERT INTO cabNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ladǘga sun jagía aríja jamúti, ába janúfudedagun. Ába ladímurejan joun, ába laríñagun. —¡Ganígi jumá! ¡Manúfude jumá, áu le! ");
INSERT INTO cabNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ába ládinun tídoun ugúnein jámoun, ába lagálumadun garábali. Ába laweíridun janígi láu, ");
INSERT INTO cabNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ladǘga úagili lan gunfaráanda jamáni miláguru le ladǘgübei táu fein, luágu gabáfu lan lun sun cátei, derégili jachǘgü. ");
INSERT INTO cabNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ába jánjiñuraguni dúna, ába jachǘlürün Genésaret, ába jagǘrünun ugúnein láru dúna. ");
INSERT INTO cabNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Quei jaráriragun tídaangiñe ugúnein, ítara jasúbudiruni lílana fulásu luágu Jesúsu lan. ");
INSERT INTO cabNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ába jeíbaagun lídoun sun fulásu aríñaga luágu chülǘjali lan, ába jagúmeserun gürígia anáaja sánditiña tídan jabárari le ñíjin lubeí jagáamba luágu níjein lan Jesúsu ñi. ");
INSERT INTO cabNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Súnti fulásu ñíjin lumúti lebélura, ubúrugu yébe, lirájüñü yébe fulásu, áraabu yébe, ába jíchaajoún sánditiña ǘmada, ába jamúriajan lúma lun lígiruniña lúnrügü jagúurun sánditiña jagía luágu táru lanáangun. Súnti ja agúurubaña luágu, areídaguatiña. ");
INSERT INTO cabNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ába jayábin fariséogu jáma jádaangiñe arúfudajatiña lilúrudun Moisés ja ñǘbinbaña Jerusaléngiñe, luágun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ába jaríjin luágu añájein lan jádaangiñe disípulugu machíbun jamúti jájabu lubá jeígin según jagáburi juríu. ");
INSERT INTO cabNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Falá jamuti fariséogu jáma jíbiri juríu binádu jagáburi binádu jagǘbürigu lun meígin jamá, machíbunga jameí jájabu sarágu weíyaasu. ");
INSERT INTO cabNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Dan le jayábin mágidirugugiñe, meíginbaña magúnfulirunga jagía láu jachíbuni jájabu. Níjein buri gíñe sarágu luwúyerigu igáburi jafálarun, queí buri lachibúniwa wéru, soúdieru, boúlu, asíedu.) ");
INSERT INTO cabNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ábati jálügüdüni fariséogu jáma arúfudajatiña lilúrudun Moisés jagía, Jesúsu. —¿Cásan uágu mafála jabálin báni disípulugu binádu jagáburi binádu wagǘbürigu, jeíginbei láu liwíye jájabu? ");
INSERT INTO cabNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ába loúnabuniña Jesúsu. —Linárün proféta Isaías, dan le laríñagunbei juágu luágu ámu lan jigáburi lueí le áubei jarúfudagua júngua. Aríñagati. Gürígia ja, jayumárurügü jíchiga inébesei nun, líña Búngiu, ánjein tídan janígi, mebéresentiña náu. ");
INSERT INTO cabNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Málati jájuduragun nun, ladǘga lé rügǘñein jagúmadijan wügǘriña jarúfudaja. ");
INSERT INTO cabNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ába laríñagun Jesúsu. —Ígira jumáali lagúmadijan Búngiu lun jafálaruni binádu jagáburi binádu gürígia. lachibúniwa soúdieru, wéru, lúma cátei líbeina líra. ");
INSERT INTO cabNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","¡Maésturugu gíñe buítiña jugúya, ígira jumúti lagúmadijan Búngiu lun jafálaruni binádu jigáburi! ");
INSERT INTO cabNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Aríñagatí meja Moisés. “Inébe jamá bagǘbürigu bun, le anábagubaliña lagǘbürigu, jilála.” ");
INSERT INTO cabNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ánjeinti jugúya, aríñagatün luágu gayára lan laríñagun ában gürígia lun lúguchi o tun lúguchu. “Siñáti níderagunibu ladǘga sun le númabei, aríñagaadina luágu lun lan níchuguni lun Búngiu”, ");
INSERT INTO cabNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","luágu furúmieguarügü lan le aríñaguti ítara, mámaali lan lúnti líderaguniña lagǘbürigu. ");
INSERT INTO cabNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Láu líra, mebégigüda jumáali lagúmadijan Búngiu lun jafálaruni binádu jigáburi, adǘga jugúya sarágu cátei líbeina líra. ");
INSERT INTO cabNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ábaya lagúarun Jesúsu joun gürígia ja ñíbaña, ába laríñagun joun. —Agáamba jumána, sun jugúya, gunfaráanda jumáname. ");
INSERT INTO cabNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Úati ni cáta ebéluruti lídoun gürígia lun laríbadagüdüni ligíbugiñe Búngiu, le áfuridubei tídaangiñe lanígi gürígia, ligía aríbadagüdübalin ligíbugiñe Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jugúya le garígeirugubei lun jagáambun, agáamba jumána. ");
INSERT INTO cabNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Dan le lígiruniña Jesúsu gürígia jagía, ába lebélurun múnadoun, ába jálügüdüni láni disípulugu luágu jémpulu le. ");
INSERT INTO cabNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ába laríñagun joun. —¿Úati lubeí gíñe gunfaráanda jumá? ¿Úati gunfaráanda jumáni luágu sun lan le ebélurubei boúgudigiñe lídoun gürígia siñá lan laríbadagüdüni ");
INSERT INTO cabNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ladǘga mebéluti tídoun lanígi, lurágeirugun lebélura, ñígiñe ábaya láfuridun lídaangiñe? Láu líra laríñaguña luágu sun lan eígini, jarúmati. ");
INSERT INTO cabNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aríñagati gíñe. —Le áfuridubei lídaangiñe gürígia, anáti líra, wuríbagüda lumúti, ");
INSERT INTO cabNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ladǘga lídaangiñe gürígia o tídaangiñe lanígi láfurida lagǘbüri samínaü, adultériu, salúfuri, áfarajaní, ");
INSERT INTO cabNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","íwerujaní, wámajabúni, iyéreejabúni, iyéeni, marícharagun lan ibágari, gimúgaü, marásualugú, anáanguni únguaü, medéraaguaguduni. ");
INSERT INTO cabNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sún buri cátei wuríbati le, tídaangiñe lanígi gürígia liábin, ligíati mabuídundagüdübalin ligíbugiñe Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ába lídin Jesúsu ñígiñe loúbawagun Tíro lúma Sidón. Ába lebélurun tídoun ában múna áni mabúseerunti yebe lun lasúbudiruni ni ában. Siñáti larámudagun, ");
INSERT INTO cabNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","furése, ába tagáambun ában wǘri luágu, túguchu ában irájü gawágutu ában espíritu wuríbati. Ába tiábin, ába tájuduragun ligíbugiñe Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Wǘri tugúya, máma juríu, Síro-Feniciána. Ába tamúriajan lúma Jesúsu lun laságaruni espíritu wuríbati le tueí tiraǘ. ");
INSERT INTO cabNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ába laríñagun Jesúsu tun. —Lúnti níderaguniña numútuniña ja juríu furúmiñe, mabuídunti lun tagídarúniwa fein jaweí isáanigu lun tíchugúniwa joun oúnli. ");
INSERT INTO cabNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ába toúnabuni. —Ánja Nabúreme, oúnli ja lábugiñebaña dábula gayáraati gíñe jeígin tídaangiñe tífe fein to jágujaboun isáanigu. ");
INSERT INTO cabNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ábati laríñagun Jesúsu tun. —Adímurejadibu buídu, gayáraajali bídin, furíja espíritu wuríbati tídaangiñe biraǘ. ");
INSERT INTO cabNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dan le tachǘlürün múnada, ába tadárirunun irájü tídan gabána, furíjali espíritu wuríbati tídaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ába láfuridun Jesúsu loúbawagugiñe Tíro, ába lásügürün Sidóngiñe lúma lídaangiñé buri fulásu lánina Decápolis, ába lachǘlürün luágun barána Galiléa. ");
INSERT INTO cabNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ñi janǘga ában wügǘri magáambaditi, dagádaga lerérun lun, ába jamúriajan lúma lun líchuguni lújabu luágu lun lareídaguagüdüni. ");
INSERT INTO cabNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ába ladíñurun Jesúsu ñígiñe láu jaweí gürígia, ába ládaruni bián lirájüñü lújabu larígeirugun, ába lásuerun, ába lájurudunun liñéñe láu arǘrei. ");
INSERT INTO cabNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ába laríjin siélun, ába lawáragun, ába laríñagun. —¡Efata! —míni lan líra. ¡Junrénba! ");
INSERT INTO cabNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ába lánjunrenchun larígeirugu magáambaditi ligía, ába tánjingichun liñéñe lun ladímurejan buídu. ");
INSERT INTO cabNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ába laríñagun Jesúsu joun lun mabájüdagun jamáni ni ca un, létima laríñagun joun lun mabájüdagun jamáni, ligíatima jabájüdaguni. ");
INSERT INTO cabNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ábatí buri laweíridun janígi sarágu, ába jaríñagun. —Adǘga lumúti sun cátei buídu, darí lun lagáambagüdüniña magáambaditiña, adímuregüda láña maríñagaditiña. ");
INSERT INTO cabNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lídan dan ligía, ábaya joúndaragun sarágu gürígia áni úati ni cáta jáma lun jeígin. Ába lagúarun Jesúsu joun láni disípulugu, ába laríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Gudémetiña gürígia ja nun ladǘga ǘrüwa wéyu jáu núma ya áni úaali ni cáta jáma lun jeígin. ");
INSERT INTO cabNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ánjaña noúnaja águyu meíginga, ladágaruba falálaü jawágu ǘmada, ladǘga añájein jádaangiñe, díseti ñígiñe lumúti jayábin. ");
INSERT INTO cabNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ába joúnabuni láni disípulugu. —¿Ída lubáti jeígagüdüniwa ya lídan fulásu le mageírawaguti? ");
INSERT INTO cabNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ába lálügüdüniña Jesúsu. —¿Átiriñoun fein júma? Ába jaríñagun lun. —Sédü. ");
INSERT INTO cabNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ába lañúuragüdüniña gürígia múarugu, ába lanǘgünun sédü fein tugúya lújaburugu, ába líchugun eteíngiruni lun Búngiu. Ába lagúbachagunun, ába lamúrusujanun, ába líchugunun joun láni disípulugu, ába jafánreinjanun jádan gürígia jagía. ");
INSERT INTO cabNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ñíñanu gíñe átiri jarájüñü úduraü jáma, ába líchugun eteíngiruni jawágu, ába lafánreinragüdüniña. ");
INSERT INTO cabNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Joútiña sun jagía químule, buíngüdagíña sédü faníñe táu tífe to ígiraguboun. ");
INSERT INTO cabNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yaráfañanu joun gádürü mílu wügǘriña. Ába loúnajaniña Jesúsu águyu, ");
INSERT INTO cabNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ába ládinun tídoun ugúnein jáma láni disípulugu, ába joúdin Dalmanutoún. ");
INSERT INTO cabNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ába jayábin fariséogu, ába jagúmeserun asígeneja lúma Jesúsu. Lúnti jaríjin lábun, ába jamúriajan lun larúfudun ában miláguru joun, siélugiñe. ");
INSERT INTO cabNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ába lawáragun Jesúsu weíri, ába laríñagun. —¿Cásan uágu jamúriaja gürígia ja lánina dan le ában miláguru? Ninárün jáu luágu marúfudúnbei lan miláguru jun. ");
INSERT INTO cabNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ába lígiruniña Jesúsu, ábaya ládinun tídoun ugúnein, ába lídin loubáfurugun dúna. ");
INSERT INTO cabNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bulíei jamútiti disípulugu janǘgün eígini, ában rügǘñoun fein jáma tídan ugúnein. ");
INSERT INTO cabNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ába lewéridiruniña Jesúsu, laríñaga joun. —Toúnigi jumátia lueí jísite fariséogu lúma lísite Heródes. ");
INSERT INTO cabNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ába jaríñagun disípulugu jádaangua. —Ladǘgatia meígan wamá fein laríñagubei ítara. ");
INSERT INTO cabNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ába lasúbudiruni Jesúsu jarítagun, ába laríñagun joun. —¿Ca uágu jaríñaga luágu meígan jumá fein? ¿Úagili gunfaráanda jumá, meféen jugúya? ¿Ítara lidére jichǘgü? ");
INSERT INTO cabNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Maríjintün láu jágu, magáambun jugúya láu jarígeirugu? ¿Marítagun jumáali? ");
INSERT INTO cabNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Dan le nafánreinjanbarun seíngü fein jádan seíngü mílu wügǘriña, ¿átiriñoun faníñe táu tífe jabúdun? Ába jaríñagun. —Dúusu. ");
INSERT INTO cabNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ángi dan le nafánreinjanun sédü fein jádan gádürü mílu, ¿átiriñeingi faníñe buin jabúdun? Ába jaríñagun. —Sédü. ");
INSERT INTO cabNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ába laríñagun joun. —¿Úagili gunfaráanda jumá luágu máma lan tuágu fein nadímureja? ");
INSERT INTO cabNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Lárigiñe, ába jachǘlürün Betsáidoun, ába lanügǘniwa ában marijínti lun Jesúsu, ába jayúmuragun lun lun lagúurun luágu. ");
INSERT INTO cabNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ítara líña lárügüdüni Jesúsu maríjinti ligía, ába lanǘgüni bougudín lueí fulásu ligía. Ába lájurudagun arǘrei luágu lágu, ába líchuguni lújabu luágu, ába lálügüdüni ánjein gayáraaraü lubeí laríjin. ");
INSERT INTO cabNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ába laríjin, ába laríñagun. —Aríja numútiña wügǘriña, naríjiniña quei tídibu wéwe, eíbugeina. ");
INSERT INTO cabNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ábaya líchuguni Jesúsu lújabu luágu lágu, ába laríjin gürígia ligía láu goúnigi, ába lareídagun, ába laríjini sun cátei furáangu. ");
INSERT INTO cabNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ába loúnajani Jesúsu águyu, aríñageina lun. —Mebélurabátia ubúrugun, maríñagunbeíme lun ni ában ñi. ");
INSERT INTO cabNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Lárigiñe, ába lídin Jesúsu jáu láni disípulugu lídoun buri lirájüñü fulásu le geyéguabei láu ubúrugu Cesaréa le Filípo. Ǘmada, ába lálügüdüniña láni disípulugu, laríñaga joun. —¿Cátanasan jaríñagun gürígia? ");
INSERT INTO cabNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ába joúnabun. —Añájein aríñagutiña luágu Juan lan le abásteragüdajabei lan amǘrü, jíbiri aríñaga proféta Elías ban, añájeingua aríñagutiña luágu ámu lan proféta amǘrü. ");
INSERT INTO cabNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ába laríñagun. —Ánti jugúya, ¿cátanati lídan jarítagun? Ába laríñagun Pédro lun. —Amǘrü Crístubei, le loúnajabei Búngiu lun lasálbaruniña gürígia lídaangiñe jafígoun. ");
INSERT INTO cabNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ába laríñagun Jesúsu joun lun maríñagun jamáni lun ni ában. ");
INSERT INTO cabNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ába lagúmeserun Jesúsu, le Wügǘri Garaǘwarügüti, arúfudaja joun luágu lúnti lan lasúfurirun sarágu, luágu weíribei lan jíchugun wügǘriña weírigutiña lídan jafíñen juríu mebéreseni láu, ítara lúba gíñe joúseruni jábutigu fádirigu jáma arúfudajatiña lilúrudun Moisés. Aríñagati joun luágu láfarúaba lan jilágubei, áni lásaaruba lan lídaangiñe oúweni lúnya labágaridun luágu lǘrüwan wéyu. ");
INSERT INTO cabNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Furáanguti laríñaguni le joun. Ábati lanǘgüni Pédro Jesúsu ñígiñe, ába lagúmeserun adeínja lun. ");
INSERT INTO cabNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ába lagáraragun Jesúsu, ába laríjin jawágun láni disípulugu, ába lébechuni Pédro, ába laríñagun lun. —¡Díseba nueí, Máfia! Bugúya, masáminaruntibu quei Búngiu, basáminarun quei wügǘriña. ");
INSERT INTO cabNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ábati lagúarun Jesúsu joun láni disípulugu jáma jíbiri gürígia lun jayárafadun lun, ába laríñagun joun. —Le busénti lafálarunina, bulíeileí cáteiñein lan, awándaleí sun luwúyeri asúfuriruni le lúnbei liábin lun nueígiñe queísi lanǘgüni ában wügǘri lugúruwan, falálana. ");
INSERT INTO cabNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ladǘga le abúseeruti leséfuragun lúngua ya uboúagu leféridirubei ibágari le magúmuchaditi, ánjeinti le ánjabei leféridiruni libágari ya uboúagu nueígiñe, libíjubei ibágari le magúmuchaditi siélu. ");
INSERT INTO cabNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Cági ju lan lun gürígia lagáñeiruni sun le lánina uboú, leféridireime lubára siélu? ");
INSERT INTO cabNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Úati ni cáta lánina uboú le áuti gayára lan lagáñijan gürígia lubára siélu. ");
INSERT INTO cabNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Le anǘgüti busíganu nuágu lúma luágu nerérun jagíbugiñe gürígia múaraantiña áni gafígountiña ja, nanǘgüba gíñe busíganu láu, áu le Wügǘri Garaǘwarügüti, dánme le niábin siélugiñe láu luweírigun Núguchi, geyégu jáu ánjeligu ja sándubaña. ");
INSERT INTO cabNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aríñagati gíñe Jesúsu joun. —Ninárün jáu, luágu añájein lan jádaangiñe ja yábaña guetó, moúnwenbaña darí jaríjini lachǘlürün larúeijan Búngiu láu ubáfu. ");
INSERT INTO cabNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sísi wéyu lárigiñe, ába lanǘgüni Jesúsu Pédro, Jacóbo, lúma Juan, ába lídin jáu luágu ában wǘbü íñuti le ñí lumuti gayára lan jábugua jamá, ába lámuñedagun larijín ñi jagíbugiñe. ");
INSERT INTO cabNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ába támiridun lanáangun jarú quei jeméreedu, weíriti tíjarun chülǘ lúmoun úa jamá ni gürígia uboúagu gayáraati jachíbun gamísa lun tájarudun ítara. ");
INSERT INTO cabNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ába jaríjini Elías lúma Moisés ayánuja lúma Jesúsu, ");
INSERT INTO cabNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ába laríñagun Pédro lun Jesúsu. —Maésturu, ¡lídan dan awánja lan ya! Adǘga wamá ǘrüwa dibásein, ában bun, ában lun Moisés, ában lun Elías. ");
INSERT INTO cabNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Laríñagubaalin líra ladǘga janúfude disípulugu, áni ibídiñeti lun Pédro ca lan laríñagubei. ");
INSERT INTO cabNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ába larárirun ában juánriñu le ñíjin jabeí, ába ladáuragun jáu, ába lagaambúniwa ában umálali lídaangiñe juánriñu ligía le aríñagubei. —Niján Niraǘ le jínsiñebei nun, jeíba láu le lubeíbei. ");
INSERT INTO cabNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Lídan óra ligía, dan le jaríjin geyégu ñi, maríjinjaña ámu ñi lueídügüya Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dan le arárireina jamá lueígiñe wǘbü, ába léredun Jesúsu jawágu lun mabájüdagun jamáni le jaríjibei lun ni ában daríme saráali lídaangiñe oúweni lúnya labágaridun, ligía le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ligía jareídunbalin jádaangua, álügüdajárügütiña jámagua cátei lán funa ásaarunibei lídaangiñe oúweni. ");
INSERT INTO cabNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ábati jálügüdüni Jesúsu. —¿Cásan uágu jaríñaga arúfudajatiña lilúrudun Moisés luágu lúnti lan liábin Elías furúmiñe lubáragiñe liábin le Crístubei? ");
INSERT INTO cabNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ába loúnabuniña. —Inárüni le jaríñagubei luágu Elíasba lan ñǘbin furúmiñe áni laráanserubei lan sun cátei. ¿Cági taríñagubei Lerérun Búngiu nuágu, áu le Wügǘri Garaǘwarügüti? Aríñagatu luágu nasúfuriruba lan sarágu áni mabájüdǘnbadina lan. ");
INSERT INTO cabNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Naríñajare jun luágu ñǘbinjali lan Elías, ába jadǘgüni gürígia sun le jabúseerunbei láu, quei taríñaguni Lerérun Búngiu luágu ítara lúba lan lasúseredun lun. ");
INSERT INTO cabNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Lárigiñe, ába jagíribudun le ñíjin jabeí jíbiri disípulugu, ába jaríjin sarágu gürígia geyégu jáu. Ñíñanu gíñe arúfudajatiña lilúrudun Moisés asígeneja jáma. ");
INSERT INTO cabNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Dan le jaríjinbalin Jesúsu, ába laweíridun janígi láu jaríjini ñi, ába jeíbaagun abúsura lun. ");
INSERT INTO cabNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ábati lálügüdüniña, laríñaga joun. —¿Ca uágu jasígeneja jáma? ");
INSERT INTO cabNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ába loúnabun ában jádaangiñe ja ñíbaña, ába laríñagun. —Maésturu, niján niraǘ nanǘgün bun, níjein ában espíritu wuríbati luágu, merérunjali ladǘga. ");
INSERT INTO cabNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ñí lumuti lárügüdei espíritu wuríbati ligía, lájuchuruni múarugun, ába láfurijan jacútaü liyúmulugugiñe, ába lacǘnrinjan lári. Ledébiliduñati ítara. Amúriajaadina jáma báni disípulugu lun jaságaruni espíritu wuríbati le lueí, siñá jamuti. ");
INSERT INTO cabNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ába loúnabun Jesúsu, ába laríñagun. —¡Gürígia mafíñeraditiña! ¿Átiribeísan dan lun neréderuni júma lubá gayára lan jafíñerun nuágu? ¿Ídame lagúmucha mafíñeni le jídaanbei? Barǘjumei irájü ligía ñájoun. ");
INSERT INTO cabNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ába janǘgüni lun. Dan le laríjinbalin espíritu wuríbati ligía Jesúsu, ába loúwejagüdüni irájü ligía, ába leíguadun múarugun, ába lagárabajan, ába láfurijan jacútaü liyúmulugugiñe. ");
INSERT INTO cabNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ába lálügüdüni Jesúsu lúguchi, ába laríñagun lun. —¿Átiri dan lueígiñe ítara lan? Ába laríñagun lúguchi. —Lúmagiñe ñǘraügili. ");
INSERT INTO cabNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Gíbeeli weíyaasu lájuchuruni espíritu wuríbati ligía wáturugun o dúnarugun lan lún yebe láfaruni jilágubei. Ánjein lubeíti níjein lubeí gayára bumúti adǘga, gudéme wamá bun, íderagua báwa. ");
INSERT INTO cabNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ába laríñagun Jesúsu lun. —¿Ca uágu baríñaga ítara? Inárüni luágu gayára lan nadǘgüni. Sun cátei gayáraati lun le afíñebei. ");
INSERT INTO cabNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ába lagúaragun lúguchi irájü ligía. —¡Afíñetina, íderagua bána lúntima nafíñerun! ");
INSERT INTO cabNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dan le laríjinbei Jesúsu luágu furésetimájali lan jagíbedun gürígia, ába ladeínjan lun espíritu wuríbati ligía, ába laríñagun. —Espíritu magáambaditi, maríñagadi, aríñagatina bun lun báfuridun, ígirabeí irájü le áni mebéluradügüyabá lídoun. ");
INSERT INTO cabNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ába lagúaragun espíritu, ábaya loúwejagüdüni irájü ligía, ába láfuridun, ába leréderun irájü ligía camá jiláali. Sarágu jáña aríñagutiña luágu jilá lan. ");
INSERT INTO cabNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ába lárügüdüni Jesúsu lueígiñe lújabu, ába liñúraguni, ába laráramun. ");
INSERT INTO cabNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ábati lebélurun Jesúsu múnadoun, ába jálügüdüni láni disípulugu dan le jábuguarügaña lúma, ába jaríñagun lun. —¿Cásan uágu siñá wabalin espíritu wuríbati ligía aságara? ");
INSERT INTO cabNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ába laríñagun joun. —Ladǘga líbe espíritu le, láu rügǘñein ayúmuraguni lun Búngiu lúma ayúnaruni gayára lan láfuridun. ");
INSERT INTO cabNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Dan le joúdin ñígiñe, ába jásügürün Galiléagiñe, ");
INSERT INTO cabNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","mabúseeruntiti Jesúsu lun lasúbudirúniwa jalíñañein lan ladǘga larúfudajaña lan joun láni disípulugu, aríñageina ligía luágu ledéregerúaba lan, ligía le Wügǘri Garaǘwarügüti, jájaburugun wügǘriña wuríbatiña áni jáfarubei lan jilágubei, ábame lásaarun lídaangiñe oúweni luágu lǘrüwan wéyu lúnya labágaridun. ");
INSERT INTO cabNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Úati gunfaráanda jamáni le laríñagubei joun, áni janúfudetiña lun jálügüdüni. ");
INSERT INTO cabNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ába jachǘlürün ubúrugu Capernaúm, múnada, ába lálügüdüniña Jesúsu. —¿Cásan buga uágu jadímureja le eíbugeina jumá? ");
INSERT INTO cabNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ába jeréderun maníñu ladǘga ǘmada adímurejeina jañá buga luágu ca lan jádaangiñe weírigutimaabei. ");
INSERT INTO cabNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ábati lañúurun Jesúsu, ába lagúarun joun dúusugubei disípulugu lubádun, ába laríñagun joun. —Le abúsueruti ligía lan furúmiñeti, lúnti agúmujoúni lan jádan súngubei, lun gíñe lesériwidun joun súngubei. ");
INSERT INTO cabNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ába lanǘgün ában irájü, ába líchuguni jamídaangua, ába lanǘgüni lújaburugu, ába laríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Gürígia le erésibiruti ában irájü quei le lídan níri, resíbi lumútina, áni máma rügǘñein áu lerésibira, resíbi lumúti gíñe Núguchi le oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ába laríñagun Juan lun. —Maésturu, aríjatiwa ában wügǘri aságajati espíritugu wuríbatiña lídan bíri, quei máma lan wámañein, ába wawéridiruni lun madǘgündügüya láani. ");
INSERT INTO cabNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ába laríñagun Jesúsu. —Mawéridira jumeí, ladǘga úati ni ában le adǘgüti miláguru lídan níri lun ladímurejan wuríba nuágu. ");
INSERT INTO cabNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Le mámabei wágani, wámagiñeñein. ");
INSERT INTO cabNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ninárün jáu luágu furúmieguarügü lan le íchuguti ában wéru dúna jun lídan níri ladǘga láni jumá Crístu, libíjuba afáyeiruajaü buíti. ");
INSERT INTO cabNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","‘Furúmieguarügü le afígoungüdüti ában jádaangiñe ja isérigiñabaña lídan jafíñen nuágu, buítimaati jamúga lun lun lágurúniwa baránajoún láu ában oúnwenbun dǘbü le amúligülei güráñu luágu ligíina sügǘ láu ladǘgüni cátei líra. ");
INSERT INTO cabNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ánjabu lafígoungüda bújabu guánarü, buítimaati jamúga lun báchuguni, ladǘga buítimaati jamúga bídin siélun láurügü ában újabu sügǘ láu jamúga badarún láu biángubei bújabu máfiougatin, ");
INSERT INTO cabNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ñí lubei moúnwen jamá jéweraü ja eígibalin jágubu jiláaña, méñeguchadi wátu. ");
INSERT INTO cabNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ánjabu gíñe lafígoungüda bugúdi guánarü, buítimaati jamúga gíñe lun báchuguni, ladǘga buítimaati jamúga bebélurun siélun láu ában ugúdi sügǘ láu badarún máfiougatin láu biángubei bugúdi, ");
INSERT INTO cabNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","le ñí lubei moúnwen jamá jéweraü, méñeguchadi ligía wátu. ");
INSERT INTO cabNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ánjabu gíñe lafígoungüda bágu, buítimaati lun baságaruni, ladǘga buítimaati jamúga bebélurun lídoun larúeijan Búngiu láu ában águu sügǘ láu jamúga badarún máfiougatin láu biángubei bágu, ");
INSERT INTO cabNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","le ñí lubei moúnwen jamá jéweraü, méñeguchadi ligía wátu. ");
INSERT INTO cabNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‘Sun gürígia ja lánigubaña Búngiu, jouchúaba quei lau wátu geméti jawágu lun jarúmadagüdǘniwa, queísigubeirügü líchugúniwa sálu luágu cátei adágaragüdǘwati lun Búngiu, arúfuda lámuga luágu jarúma lan, buídu ligía lun lareidúniwa. ");
INSERT INTO cabNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Buíti sálu, ánjein leféridira lubásuan, ¿cábagi un ju lan? Ítara líña lubeíti, awánda jumeí sun ouchúni lubá jarúmadun ligíbugiñe Búngiu, lídan jumá úaraguni júmagua. ");
INSERT INTO cabNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ába láfuridun Jesúsu Capernaúmgiñe, ába lídin loúbawagun Judéa lúma luágun oúbaü le ñígiñe lubeí láfuacha wéyu libíti dúna le Jordán. Ábaya joúndaragun gürígia le ñí lubei, ábaya larúfudajan joun queíñaja ligáburi. ");
INSERT INTO cabNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ábati jayábin jádaangiñe fariséogu luágun Jesúsu áluga járügüdüni tídan jasádaran láu jálügüdüni ánjein maríban lubeí lun lafánreinragun wügǘri túma lúmari. ");
INSERT INTO cabNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ába laríñagun Jesúsu joun. —¿Cá mejagi laríñagubei Moisés jun? ");
INSERT INTO cabNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ába jaríñagun lun. —Aríñagati Moisés luágu gayára lan tíchugúniwa gárada lánina ígiraguni tun úmari. ");
INSERT INTO cabNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ába laríñagun Jesúsu joun. —Líchugunbaalin Moisés gumádi líra jun ladǘga tidére janígi. ");
INSERT INTO cabNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ánjein méja, dan le ladǘgünbalin Búngiu sun cátei, “adǘga lumútiña wügǘri túma wǘri”. ");
INSERT INTO cabNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Ligía lígirubei lubeí wügǘri lúguchi túma lúguchu lun laganoúniwa túma lúmari, ");
INSERT INTO cabNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ábame jeréderun quei ábanrügü.” Mámaña lubeíti biáma, ábanrügaaña. ");
INSERT INTO cabNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ligía moún lubei lafánreinraguni wügǘri le ladúnraguagüdübei Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dan le múnada jamá, ábaya jálügüdüni disípulugu luágu cátei le, ");
INSERT INTO cabNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ába laríñagun Jesúsu joun. —Le ígirutu lúmari, ába lagámaridun ámu, ladǘgüña adultériu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ánjein gíñe tígira wǘri túmari, ába tagámaridun ámu, tadǘgüña gíñe adultériu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ába janáajan gürígia irájüñü lun Jesúsu lun lagúurun jawágu, ába jagúmeserun disípulugu adeínja joun ja anáajabaliña. ");
INSERT INTO cabNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Dan le laríjini Jesúsu, magúndaati láu, ába laríñagun joun. —Ígira jumá lun jayábin irájüñü númoun, mamájara jumá, ladǘga ja jarúmabaña afíñe quei irájüñü, jagía lílanabaña larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ninárün jáu luágu le lan marúfudunti ában igáburi ǘnabugubuti queísi ában irájü, siñábei lebélurun lídoun larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ába lanǘgüniña lújaburugu, ába labíniruniña láu lújabu jawágu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dan le lasígirunbalin Jesúsu luweíyasun, ába liábin ában wügǘri eíbaagueina lubároun, ába lájuduragun ligíbugiñe, ába lálügüdüni ítara. —Maésturu buíti, ¿cásan cátei buíti lúnbei nadǘgüni lun nibíjini ibágari le magúmuchaditi? ");
INSERT INTO cabNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ába laríñagun Jesúsu lun. —¿Ca uágu baríñaga nun “buíti”? Ában rügǘñein buíti, Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Subúditi gumádi bun. “Maganoúabá túma ában gámaritu ámu, máfarajabá, míwerujabá, madímurejabá iyéeni luágu ni ában, mayéeda báña gürígia, inébe jamá bagǘbürigu bun.” ");
INSERT INTO cabNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ába laríñagun wügǘri ligía. —Maésturu, gúnfulitina láu sun le lúmagiñe ñǘraügidina. ");
INSERT INTO cabNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ába laríaguni Jesúsu láu ínsiñeni, ába laríñagun lun. —Ában cátei mégeibei lun badǘgüni. beíba, alúgurabeí sun le búmabei, ábame bíchuguni lebégi joun gudémetiña, ábame bibíjin irísini siélu. Ábame bagíribudun, ábame bafálarunina. ");
INSERT INTO cabNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dan le lagáambunbalin gürígia le cátei le, ába lírudagun, ába lídin láu íruni ladǘga rísiti buídu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ába laríjin Jesúsu geyégu jawágun súngubei, ába laríñagun joun láni disípulugu. —¡Jénreenguti lun jebélurun rísitiña lídoun larúeijan Búngiu! ");
INSERT INTO cabNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ába laweíridun janígi disípulugu láu le laríñagubei, ábaya laríñagun joun. —Nirájüñü, ¡jénreenguti lun jebélurun ja íchubalin jafíñen luágu jarísin lídoun larúeijan Búngiu! ");
INSERT INTO cabNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Méreenguntimaati lun ában caméyu lun lásügürün lídaangiñe lujúyun ában agúsa sügǘ láu lebélurun ában rísiti lídoun larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dan jagáambunbalin cátei le, ába laweíridun janígi, ába jálügüdagun jámagua. —¿Cáteiti gayáraabei lasálbarun? ");
INSERT INTO cabNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ába laríaguniña Jesúsu, ába laríñagun joun. —Siñáti jasálbaragun gürígia joúngua, ánjein Búngiu, gayáraati, ladǘga úati ni cáta siñáti lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ábati laríñagun Pédro. —Wabúreme, wagía, ígira wamáalitia sún meja le wámabei lun wafálarunibu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ába laríñagun Jesúsu. —Ninárün jáu luágu furúmieguarügü lan le ígirutu lúban, o lamúlenu, o líbugañanu, o lítunu, o lúguchi, o lúguchu, o lirájüñü, o lufúlasun nueígiñe o lueígiñe lan ugánu le lánina asálbaruni, ");
INSERT INTO cabNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","lerésibiruba san weíyaasu sügǘ láu guetó lídan uboú le. múna, amúlenu, íbugañanu, ítunu, úguchurunu, isáanigu, lúma fulásu, láu sun leíbaajoúniwa, resíbi ligíame ibágari magúmuchaditi siélu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sarágu jáña ja furúmiñetiñábaña guetó, jagíaba agúmujoúni yágüta siélu, áni sarágu ja agúmujoúnibaña, jagíaba furúmiñetiña. ");
INSERT INTO cabNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Luáguñanu ǘma lun Jerusaléoun, Jesúsu jabá jabá láni disípulugu, láuñanu luweírin anígi, áni jíbiri gürígia ja afálarubaliña, láuñanu anúfudei. Ábayati ladíñurun Jesúsu jáu láni dúusu disípulugu jaweí jíbiri gürígia, ába lagúmeserun aríñagei le lúnbei lasúseredun lun joun. ");
INSERT INTO cabNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ába laríñagun joun. —Quei lubeí jaríjini, luáguñadiwa ǘma lun Jerusaléoun, le ñíba lubeí nedéregerúa, áu le Wügǘri Garaǘwarügüti, joun jábutigu jafádirigun juríu lúma joun arúfudajatiña lilúrudun Moisés, ja lúnbaña jasíadirunina lun noúnwen. ");
INSERT INTO cabNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ábame jedéregerunina joun ja mámabaña juríu lun jéjerajan náu, jabeíchubadina, jásueragubadina, ábame jáfarunina jilágubei, luágume lǘrüwan wéyu, ábame násaarun lídaangiñe oúweni lúnya nabágaridun. ");
INSERT INTO cabNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ábati jayábin Jacóbo lúma Juan, ja lirájüñü Zebedéo, ába jaríñagun lun Jesúsu. —Maésturu, buséntiwa lun badǘgün ában fuleísei woun. ");
INSERT INTO cabNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ábati laríñagun joun. —¿Cági jabúseerubei lun nadǘgün jun? ");
INSERT INTO cabNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ába jaríñagun lun. —Lun dánme lan barúeijan láu sun buweírigun, lun bañúuragüdüníwa, ában lueígiñe boúnwenren, ában lueígiñe bubaǘna. ");
INSERT INTO cabNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ába laríñagun Jesúsu joun. —Ibídiñeti jun ca lan jamúriajabei. ¿Gayáraabei jawánduni luweírin igárigu le lúnbei nawánduni, gayára ligíame júaradun núma lídan nasúfurirun? ");
INSERT INTO cabNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ába joúnabun. —Gayára wabeí. Ába laríñagun joun. —Lúnti jawánduni igárigu le lúnbei nawánduni, úara jugúyame núma lídan nasúfurirun, ");
INSERT INTO cabNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ánjein lun jañúurun ában lueígiñe noúnwenren, ában lueígiñe nubaǘna, máma áu lúnbei níchuguni, líchugúba joun ja ubáabaña laráanserei Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Dan le jagáambunbalin ja jíbiri díisi disípulugu, ába jagáñidun lúma Jacóbo láu Juan. ");
INSERT INTO cabNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ába lagúarun Jesúsu joun súngubei lubádun, ába laríñagun joun. —Quei jasúbudirun, ja agúmadijabaña jádan ja mámabaña juríu, arúfudaguatiña joúngua camá jamuga jabúriña lílana fulásu ligía, játi weínamubaña jádan, arúfuda jamúti jabáfu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ánjein jídan, máma lúba, le abúseeruti lun weíri lan jídan, lúnti lesériwiduniña jíbiri. ");
INSERT INTO cabNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Furúmieguarügü jídaangiñe le abúseeruti lun ligíaba lan furúmiñeti, lúnti idámuni lan joun jíbiri, ");
INSERT INTO cabNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ítara quei máma lan niábiña, áu le Wügǘri Garaǘwarügüti, lun nesériwidúniwa, niábiña lun nesériwidun lúma lun níchuguni nibágari lebégime jasálbarun sarágu gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ábati jachǘlürün Jericó. Dan le áfurideina lan Jesúsu lídaangiñe fulásu ligía jáu láni disípulugu jáma sarágu gürígia, ñíñein ában maríjinti gíriti Bartiméo, liraǘ Timéo, ñun láru ǘma amúriaja seínsu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Dan le lagáambunbei luágu yaráfaali lan Jesúsu le Nazarétna, ába lagúmeserun maríjinti ligía agúaraja. —¡Jesúsu, ladǘgawagun Davíd, gudémená bun! ");
INSERT INTO cabNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sarágu jáña adeínjatiña lun lun lámanichun, ligíatima lagúaragun. —¡Ladǘgawagun Davíd, gudémená bun! ");
INSERT INTO cabNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ába leréderagun Jesúsu, ába laríñagun. —Wájuma lun lun liábin nun. Ába jagúarun lun maríjinti ligía, ába jaríñagun lun. —Ragǘba gurásu, sarába, lagúajaña bun. ");
INSERT INTO cabNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ába lachǘürunun labíte, ába ladǘgün ában chubaǘ, ába layárafadun lun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ába lálügüdüni Jesúsu. —¿Ca babúseerubei nadǘgün bun? Ába loúnabun maríjinti ligía. —Maésturu, buséntina naríjin. ");
INSERT INTO cabNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ába laríñagun Jesúsu lun. —Gayáraati bídin, areídaguaadibu ladǘga afíñeedibu nuágu. Lídan óra ligía, ába gayára lan laríjin maríjinti ligía, ába lídin lárigi Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Dan le yaráfaaña lubeí lun Jerusalén, ába jachǘlürün ligíbugiñe fulásu buri le Betfajé lúma Betánia, le ǘnabubei libíti wǘbü le Olívos, ába laríñagun Jesúsu joun biáma jádaangiñe láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Jeíba lídan liraǘraü fulásu le wagíbugiñebei, dánme le jachǘlürün ñi, jadáriruba ában burígü güráñu le maweinjoúngili ni ában weíyaasu. Jafáragadeíme, ábame janǘgüni ñájoun. ");
INSERT INTO cabNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ánjaün álügüdǘwa ca lan uágu jadǘgei le, jaríñagame lun luágu busén láni Jesúsu, luágu láguyugüdübei lan furése. ");
INSERT INTO cabNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ába joúdin, ába jadáriruni burígü ligía güráñu lubádu ában béna, boúgudi lídan ǘma, ába jafáragaduni. ");
INSERT INTO cabNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ába jaríñagun jádaangiñe ja ñíbaña ǘmadarugu joun. —¿Ca jadǘgübei? ¿Cáme jafáragadei burígü le? ");
INSERT INTO cabNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ába joúnabuniña quei laríñaguni Jesúsu joun, ába jígiruniña lun joúdin láu. ");
INSERT INTO cabNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ába janǘgüni burígü lun Jesúsu, ába jíchugunun jabíte luágu burígü ligía, ába laweínruni Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sarágu jáña átulerutu jabíte luágu ǘma, jíbiri, ába jánchuajan tilímun wéwe, ába jachágajani luágu ǘma lubá lásügürün Jesúsu ligíbuagugiñe. ");
INSERT INTO cabNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ja ubáraübaña jáma ja árigibaña, ába jagúmeserun agúaraja. ¡Glória! ¡Biníwati wügǘri le ñǘbinbei lídan líri Wabúreme Búngiu! ");
INSERT INTO cabNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Biníwati arúeijani le ñǘbinbei, le lúnbei ítara lan queísi meja larúeijan wáguchi Davíd. ¡Uweíriguni lun Búngiu lídan líñun-ágei siélu! ");
INSERT INTO cabNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Lárigiñe, ába lebélurun Jesúsu Jerusaléoun, belú ligía témpulurugun, lárigiñe laríjini sun cátei, ába lídin Betánia jáu dúusu disípulugu ladǘga dárüjali lan. ");
INSERT INTO cabNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Larúgan, dan le jáfuridunbei Betániagiñe, ába lalámachun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dísegiñe, ába laríjin ában tídibu ígo gabánatu. Ába lídin aríja ánjein gin tubeí, ubánaü rügǘñein ladárira tuágu ladǘga mámagili lan tidáani ígo. ");
INSERT INTO cabNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ábati laríñagun Jesúsu lun tídibu ígo ligía. —Magíindadügüyabá. Ába jagáambuni láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Lárigiñe, ába jachǘlürün Jerusaléoun, ába lebélurun Jesúsu témpulurugun, ába laságajaniña ja alúgurajabaña jáma ja agáñijabaña ñi. Ába lagárabajani jadábulan ja asáansijabaña seínsu joun gürígia lúma jála ja alúgurajabaña únjun. ");
INSERT INTO cabNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mígirun lumútu témpulu lun ǘmame. ");
INSERT INTO cabNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ába laríñagun lídan larúfudajan joun. —Laríñajare Búngiu tídan líburu to Lerérun. “Núban, fulásu le ñí lubei gayára lan jayúmuragun sun gürígia nun, ánjein jugúya, barǘ jumaaru quei jában jíwerutiña.” ");
INSERT INTO cabNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ába jagáambun jábutigu fádirigu jáma arúfudajatiña lilúrudun Moisés luágu le laríñagubei, ába jagúmeserun áluaja ída lúba lan jáfaruni jilágubei, ladǘga janúfudetiña lueí, quei sun lan gürígia weíriti janígi luágu le larúfudajabei. ");
INSERT INTO cabNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Dan le lagúñedunbei, ába láfuridun Jesúsu fulásurugugiñe. ");
INSERT INTO cabNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Larúgan bináafin, sügǘti Jesúsu jáma láni dúusu disípulugu lueígiñe méme ǘma ligía, ába jaríjinun tídibu ígo saǘja lúmagiñe tílagüle. ");
INSERT INTO cabNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ába larítaguni Pédro, ába laríñagun lun Jesúsu. —Maésturu, ¡aríjabá tun tídibu ígo to bíñaraguboun gúñaarü, saǘja! ");
INSERT INTO cabNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ába laríñagun Jesúsu joun súngubei. —Afíñe jumá luágu Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ninárün jáu luágu furúmieguarügü lan le aríñaguti lun wǘbü le. “Gidába yágiñe, dabúba baránajoun”, ánjein úa lubeí liloúguan afíñeni tídan lanígi áni afíñe ligía luágu lagúnfuliruba lan le laríñagubei, ítara lúba. ");
INSERT INTO cabNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ligía naríñagunbei jun luágu sun lan le jamúriajan lúma Búngiu, ánjein afíñe jubeí luágu resíbi jumáali lan, ítara lúba. ");
INSERT INTO cabNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Dan le jayúmuraguña lan lun Búngiu, ánjein níjein lubeí ladǘga ában gürígia jun le mísiñeti jun, ferúduna jumeí lun gíñe ferúduna lánün Júguchi Búngiu le siélubei. ");
INSERT INTO cabNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ánjein úa ferúduna jumá, úabei gíñe ferúduna láani Júguchi Búngiu le siélubei jifígoun. ");
INSERT INTO cabNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ába jagíribudun Jerusaléoun. Dan le eíbugeina lubeí Jesúsu témpulurugu, ába jayábin jábutigu fádirigu, arúfudajatiña lilúrudun Moisés, jáma ámu wügǘriña ja weírigutiña lídan jafíñen juríu, ");
INSERT INTO cabNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ába jálügüdüni. —¿Cáteisan biríchabei lun bádaragun búngua lídoun cátei le tánina témpulu? ¿Ca íchugubalin ubáfu le bun? ");
INSERT INTO cabNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ába loúnabuniña Jesúsu, aríñageina ligía joun. —Nálügüdaadün gíñe ában cátei, ánjana joúnaba, naríñagubei jun ca lan áu gumádi nadǘgei buri cátei le. ");
INSERT INTO cabNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ca oúnajabalin Juan abásteragüdaja? ¿Búngiu, ódi wügǘriña? ");
INSERT INTO cabNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ába jagúmeserun adímureja jámagua, ába jaríñagun. —Ánjawa aríñaga luágu Búngiu lan oúnajabalin, laríñaguba woun ca lan uágu mafíñerun wabeí lun Juan. ");
INSERT INTO cabNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Ódi waríñaguba funági luágu joúnajan lan wügǘriña? Lun jamúga joúnabun ítara, janúfudetiña jaweí gürígia, ladǘga subúdi jamáni sun gürígia luágu proféta lán Juan. ");
INSERT INTO cabNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ábati jaríñagun lun Jesúsu. —Ibídiñeti woun. Ábati gíñe laríñagun Jesúsu. —Maríñagun nubeí gíñe jun ca lan áu gumádi nadǘgei cátei le. ");
INSERT INTO cabNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ábati lagúmeserun Jesúsu adímureja joun gürígia ja ñíbaña láu jémpulu, ába laríñagun joun. —Ñíñein meja ában wügǘri, ábunaguti tídibu beíbei lufúlasunrugu. Ába ladǘgün baríeru láu, adǘga ligía ában ágei lun laríbichawagún tíra beíbei lídoun lúma ában wáyelesi lun gayára lan loúnigiruni sun cátei. Ába lájayajani lichári joun ñadágimeintiña, ába lídin adǘga weíyaasu. ");
INSERT INTO cabNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Dan le lachǘlürünbei dan lun alúbajani, ába loúnajan ában lumúsun amúriajei lufánran jámagiñe ñadágimeintiña. ");
INSERT INTO cabNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ábarüga járügüdüni músu ligía, ába jabúleiseiruni, ába joúnajani lárigoún, míchutiña ni cáta lun. ");
INSERT INTO cabNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ábaya loúnajan labúreme ichári ábanya músu, ába jíchaagun dǘbü luágu, boúgua jameí lábulugu, anába. ");
INSERT INTO cabNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ábaya loúnajan labúreme ichári ábanya, ába jáfaruni jilágubei. Lárigiñe, ába loúnajan sarágu, ában lárigi ában, buleísei jamáña jíbiri, áfaragua jíbiri jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Níjeinguati ában lun loúnajani, ában liraǘ jínsiñeti lun buídu, lagúmujoún óra ába loúnajani, ába larítagun luágu inébebei lan joun ladǘga liraǘ lan. ");
INSERT INTO cabNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ába jaríñagun ñadágimeintiña jámagua. “Niján le lúnbei libíjini alágan, wáfaraali jilágubei, wagía lámuga labúriña sun cátei.” ");
INSERT INTO cabNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ábati járügüdüni, ába jáfaruni jilágubei, ába jaságaruni lúgubu lídaangiñe fulásu ligía. ");
INSERT INTO cabNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ábati lálügüdajan Jesúsu. —¿Cábati ladǘga labúreme ichári? Liábinme, ábame láfaraguniña ñadágimeintiña jilágubei, ábame líchuguni ichári joun ámu. ");
INSERT INTO cabNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Malíijan jumágilisan le taríñagubei Lerérun Búngiu nuágu? Taríñajare. Lé meja dǘbü le mabúseerun jabeí ábunagutiña, ligíaali furúmiñeti. ");
INSERT INTO cabNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Wabúreme Búngiu adǘgübalin lun furúmiñetibei lan, áni aríja wamúti quei ában cátei weíriguti. ");
INSERT INTO cabNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ába jabúseerún yebe jadáürüni Jesúsu ladǘga jasúbudiruni luágu jawágu lan layúsurei jémpulu le. Quei janúfudebei jaweí gürígia, ába jígiruni lúngua, ába joúdin. ");
INSERT INTO cabNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lárigiñe, ába joúnajoúniwa jádaangiñe fariséogu jáma jádaangiñe lánigu Heródes lúmoun Jesúsu lun jaríñagagüdüni som cátei le lúnti gayára lan jíchuguni lidúnrunme. ");
INSERT INTO cabNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ába jayábin, ába jaríñagun lun. —Maésturu, subúditi woun luágu aríñaga báani inárüni, manúfudeiga lueí ni ában ladǘga ni cáta lan luweírigun gürígia bun, áni barúfudajani lémeri Búngiu láu inárüni. Áríñagabá ában cátei woun. ¿Buítisan lun lafáyeijoún seínsu lun warúeite le Rómana ódi mabuídunti? ");
INSERT INTO cabNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Subúdi lumúti Jesúsu luágu biánguañein lan jagíbu, ába laríñagun joun. —¿Cámesan jíchaajan sádara nubá? Barǘjuma ában lídaangiñe seínsu ligía nun, aríja námugei. ");
INSERT INTO cabNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ába janǘgüni lun. Dan le laríjini, ába lálügüdüniña. —¿Cági iyáwa lúma íri le luágubei? Ába jaríñagun lun. —Láni urúei Rómana. ");
INSERT INTO cabNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ába laríñagun joun. —Rújumeiti láni urúei lun urúei, rújumeime láni Búngiu lun Búngiu. Ába laweíridun janígi láu ligáburi loúnabuniña. ");
INSERT INTO cabNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ába joúdin fiú saduséogu aríjei Jesúsu. Afíñetiña saduséogu luágu úa lan ásaaruni lídaangiñe oúweni. Ába lubeíti jaríñagun lun. ");
INSERT INTO cabNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maésturu, aríñagatí meja Moisés luágu ánjein lan oúwe ában wügǘri le maríeiti masáaniguga táu lúmari, lúnti lan lamárieidun lamúlen túma wǘri to ueíboun loúwe, lun gasáanigu lan táu lun líbugaña le oúwebei. ");
INSERT INTO cabNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ñíñanu mejati sédü gamúlenuguátiña, le furúmiñeti, ába lamárieidun, ába loúnwen marájüñüga. ");
INSERT INTO cabNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Le jabíaman, ába lamárieidun túma wǘri tó buga lúmari líbugaña, ába gíñe loúnwen marájüñütiña, ligía méme asúsereda lúma le jǘrüwan. ");
INSERT INTO cabNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Maríeitiña sédügubei jagía túma, úati ni ában garaǘti táu. Lagúmujoún óra, ába gíñe toúnwen wǘri tugúya. ");
INSERT INTO cabNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Niján le uágubei wálügüdaja. Dánme le jásaarun jiláaña lídaangiñe oúweni lúnya gabágari jamá, ¿cábagi úmari wǘri tugúya jádaangiñe sédü gamúlenuguátiña ja, lárigiñe maríei jamá sun jagía túma? ");
INSERT INTO cabNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ába laríñagun Jesúsu joun. —Bulíeiguatün ladǘga libídiñe tuáguti Lerérun Búngiu jun, ni luáguti lubáfu Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Dánme le jásaarun jiláaña lúnya jabágaridun, ámujalime jabágari, magámaridun jába, míchugun jamáñame jasáanigu lun maríei, queísi magámaridun jamá ánjeligu siélu. ");
INSERT INTO cabNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ánjeinti luágu sará jamá jiláaña lúnya jabágaridun, ¿malíijan jumágiru lilíburun Moisés luágu ladímurejan Búngiu lun lídaangiñe ában búbugati durúngu umúti? Laríñajare lun. “Áu Lubúngiutebei Abrahám, Lubúngiute Isáac, Lubúngiute Jacób.” ");
INSERT INTO cabNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ítara líña lubeíti, ánjein jamúgati jiláañu jáña wügǘriña jagía lun sun dan, maríñagunti jamúga Búngiu luágu Jabúngiute lan, ladǘga máma Jabúngiute jiláguaaña Búngiu, Jabúngiute wínwangiña. Ítara líña lubeíti, jugúya weíriti jabúlieidágun. ");
INSERT INTO cabNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ñíñein ában jádaangiñe arúfudajatiña lilúrudun Moisés le agáambubalin jadímurejan, queíti subúdi láani luágu oúnaba lániña Jesúsu buídu, ába liábin lubároun, ába lálügüdüni. —¿Cáteisan lídaangiñe lilúrudun Búngiu weírigutimaabei? ");
INSERT INTO cabNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ába laríñagun Jesúsu lun. —Niján le weírigutimaabei. “Agáamba jumána, jugúya Israelítagu, Wabúreme Búngiu, ligía rügǘñein Abúremein. ");
INSERT INTO cabNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jínsiñelá lubeíti Babúreme Búngiu bun táu sun banígi, táu sun buwáni, láu sun bisáminan, láu sun bére.” Ligía gumádi le weírigutimaabei, ");
INSERT INTO cabNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","áni le libíaman lídan uweíriguni lenége le furúmiñeti. “Jínsiñe jamá bíbirigu bun quei bínsiñegua búngua.” Úati ámu gumádi weíriguti lueí biáma le. ");
INSERT INTO cabNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ába laríñagun arúfudajati ligía lun. —Buíti baríñaguni, maésturu. Binárün luágu ában rügǘñein lan Búngiu, luágu úa lan ámu, ");
INSERT INTO cabNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","áni lúnti jínsiñe lan Búngiu woun táu sun wanígi, láu sun wasáminan, táu sun wawáni, láu sun wére, lun gíñe jínsiñe jamá wíbirigu woun queísi wínsiñegua woúngua. Gebégiti sun líra ligíbugiñe sügǘ láu sun wadágaragüdün lun lúma sun cátei le agudúbei luágu latárü. ");
INSERT INTO cabNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Dánti le lagáambun Jesúsu loúnabun láu lichú áu, ába laríñagun lun. —Madíseedibu lueí lílana ban larúeijan Búngiu. Manígijaña lun jálügüdajan. ");
INSERT INTO cabNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Larúfudajaña Jesúsu témpulurugu, laríñaga. —¿Ída liñásan jaríñagunbei arúfudajatiña lilúrudun Moisés luágu ladǘgawagun lan Davíd Crístu? ");
INSERT INTO cabNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davíd guánarügü láu lubáfu Sífiri Sándu aríñagati ítara. Laríñajare Abúremein lun Nabúreme. “Ñurúba núma lueígiñe noúnwenren daríme níchuguniña báganiñu bújaburugun.” ");
INSERT INTO cabNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Ída lubáti ladǘgawagun lan Davíd Crístu ánjein wa lubálin Davíd guánarü Crístu, “Nabúreme”? Ába jagáambuni bürǘbünu gürígia jagía láu ugúndani. ");
INSERT INTO cabNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ábaja laríñagun Jesúsu joun lídan larúfudajan. —Toúnigi jumátia jaweí arúfudajatiña lilúrudun Moisés, jínsiñeti joun lun jeíbugun táu anáanguni durúrutu lúma lun labúsurúniwa joun ǘmada láu sarágu inébesei. ");
INSERT INTO cabNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Áluaja jamúti jalaǘ le jála weírigutiña tídan jalígilisin juríu, lúma lubuídun-ágei ubáraü lídan eígini. ");
INSERT INTO cabNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Gidá jamutu jában würíña ja jiláaña úmari jaweí, lúnti jadáuragun láu sun líra, ába jadǘgün afúrieiduni le migínaguti. Weíribei jasúfurirun luágu sun le jadǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Luágu ában wéyu, ñun líña Jesúsu témpulurugu tigíbugiñe gáfu to lágei seínsu, aríaguei jíchaajan gürígia seínsu tídoun. Gíbetiña rísitiña íchugutiña sarágu seínsu. ");
INSERT INTO cabNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ligía tiábin ában fugiábu wǘri to jiláali túmari, ába tíchugun bián gáwanün tídoun gáfu tugúya. ");
INSERT INTO cabNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ába lagúarun Jesúsu joun láni disípulugu lubádun, ába laríñagun joun. —Ninárün jáu luágu gíbetima lan tíchugun wǘri to sügǘ jáu sun ja íchugubaña seínsu tídoun gáfu to, ");
INSERT INTO cabNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ladǘga sun jagía, lídaangiñe le ígiragubei jáma jíchiga, ánjoun tugúya, láu tugúdemegun rútumuti sun lé túmabei lun tawínwandun. ");
INSERT INTO cabNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Dan le láfuriduña lan Jesúsu témpulurugugiñe, ába laríñagun ában jádaangiñe láni disípulugu lun. —¡Maésturu, aríjabá tun tubuídun watémpulun lúma buri dǘbü le áubei tadügǘwa! ¡Máma tanárime buri! ");
INSERT INTO cabNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ába loúnabuni Jesúsu. —¿Aríagu jíña tun tanárime témpulu to? Merédebeítia ni ában dǘbü ligíbuagu ában, lagǘnrinchaguba sun le. ");
INSERT INTO cabNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ábati joúdin luágu wǘbü le gíribei Olívos le tigíbugiñebei témpulu. Dánti le ñun líña lan Jesúsu ñi, ába jayábin Pédro, Jacóbo, Juan lúma Andrés, ába jaríñagun lun, jagíaguarügü. ");
INSERT INTO cabNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Buséntiwa lun baríñaguni woun ídame lan lasúsereda sun le tun témpulu to. ¿Cábasan seíni luágu chülǘjali lan dan lun lagúnfulirun sún buri cátei le? ");
INSERT INTO cabNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ába laríñagun Jesúsu joun. —Toúnigi jumá, mayéedagualaǘn ni ában, ");
INSERT INTO cabNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ladǘga sarágujaba ñǘbintiña, jaríñagame. “Áu Crístubei”, áni sarágujaba jayéedun. ");
INSERT INTO cabNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","‘Jugúya, dánme le jagáambuni lamúri wuríbu yaráfa jun lúma ugánu luágutí buri wuríbu díseti jueí, manúfudedagua jumá, ladǘga ñíbei wuríbu súnwandan, mámagili lagúmuchun uboú líra. ");
INSERT INTO cabNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lageíndaguba ában fulásu lúma ában, awúribuja ligíame ában ageíraü lúma ámu. Ñíbei járabaganáli lídan sarágu fulásu, ilámaü, chagáguaü, áni súnme buri cátei le, lagúmesejarügügilime le lúnbei lasúfurirúniwa. ");
INSERT INTO cabNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‘Toúnigigua jumá júngua ladǘga jedéregerúaba lun lúrudu, ábame jabúleiseirunün tídan buri jalígilisin juríu, janügǘba lun jagúseragüdǘniwa jagíbugiñe gumádimatiña lúma jagíbugiñe urúeigu, nueígiñe, ítara lúba gayára lan jadímurejan nuágu, jagíbugiñe. ");
INSERT INTO cabNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lubáragiñe lagúmuchun uboú, lapúrichijoúba ugánu luáguti asálbaruni lídan sun fulásu. ");
INSERT INTO cabNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Dánmeti le janügǘniwa lun jedéregerúniwa joun lúrudugu, magíbedalá jarítagun luágu cába lan jaríñaga, masáminaragubei jumeí. Aríñaga jumeí le laríñagun Búngiu jun lídan óra ligía, ladǘga mámaba jugúya adímureja, Sífiri Sándu, ligíaba adímureja. ");
INSERT INTO cabNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Jedéregerubaña wügǘriña jamúlenu jáma jábugaña lun jáfarúniwa jilágubei, deréga jamáñame agǘbürigu jasáanigu, jagáraabaguba isáanigu jawágun jagǘbürigu lun jedéregerúniwa lun jáfaruniwa jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jiyéreeguduba lun sun uboú nueígiñe, le asígiruti úaragu darí lúmoun lagúmujoún, lasálbaruba. ");
INSERT INTO cabNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‘Abǘrüjati proféta Daniél luágu cátei iyéreeguti le gagǘnrinchaguagüdadibei, dánme le jaríjini cátei ligía le ñí lubei moun lan lun ñi lan—le alíijabei, gunfaráandalá—jámetia Judéabaña, lúntimétia janúrajan luágun wǘbü. ");
INSERT INTO cabNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Le gürígia le boúgudibei, mebélura látia múnadoun aságara ni cáta, ");
INSERT INTO cabNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","le áraabubei, magíribudalá águyu ni anǘgoun lanáangun. ");
INSERT INTO cabNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Fugiábugume würíña ja dageínatiña lídoun wéyu ligía jáma ja garájüñütiña ja gurágiña. ");
INSERT INTO cabNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Amúriaja jumá lúma Búngiu lun máma lan lídan lidáani lidíliga jeíbaagua, ");
INSERT INTO cabNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ladǘga lidáanibei asúfuriruni quei le masúseredungili lúmagiñe ladǘgüni Búngiu uboú, masúseredundügüyaalime giñe lárigiñe. ");
INSERT INTO cabNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ánjein jamúga madǘraagun lánme Jabúreme Búngiu dan ligía, úabei jamúga ni ában eséfuruti, ladǘraagubei luágu jínsiñe lánigu lun, ja anúadaja láañabaña. ");
INSERT INTO cabNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","‘Ánjeinti aríñawagua jun. “Aríja jumá, niján Crístubei”, o “Nirán”, mafíñera jumá, ");
INSERT INTO cabNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ladǘga jayábiba eyéejatiña aríñaga jawoúgua luágu Crístu lan jagía, jíbiri, aríñaga jagíame luágu profétagu jamá, áni jayéeni. Jadǘgüba seíni lúma miláguru lun jayéedaguniña ásta ja anúadaja láañabaña Búngiu ánjein gayára. ");
INSERT INTO cabNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aráanseñu jumá, rúnaadün luágun jugúdi. ");
INSERT INTO cabNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","‘Lídounme wéyu ligía, lárigiñeme dan ligía le lánina asúfuriruni, ábame labúrigadun wéyu, marúnidunjálime játi. ");
INSERT INTO cabNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Jeíguaduba warúguma siélugiñe, ábame ladádagarun sun siélu. ");
INSERT INTO cabNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ábameti narijíniwa, áu le Wügǘri Garaǘwarügüti, niábin lídan juánriñu láu oúnwenbun ubáfu lúma uweíriguni, ");
INSERT INTO cabNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ábame noúnajaniña ánjeligu oúndaraña sun ja nanúadajabaña lídaangiñe gádürü larígei uboú, lúmagiñe lidíse-ágei uboú darí lúmoun lidíse-ágei siélu. ");
INSERT INTO cabNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","‘Gunfaráanda jumeí jémpulu le tuáguti tídibu ígo. Dan le ñulúgili tilímun, ába laboúchun tubána, subúdi jumúti luágu níteeli lan lidáani lubáchouga. ");
INSERT INTO cabNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ítara meme, dánme gíñe jaríjini sún buri cátei le, subúdi jumeí luágu yaráfaali lan niábin. ");
INSERT INTO cabNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ninárün jáu, luágu lagǘnrinchawagúba lan sun ubúrugu le Jerusalén lubáragiñe joúwegun gürígia ja lánina dan le. ");
INSERT INTO cabNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lagúmuchaguba siélu lúma uboú, ánjein nerérun, merédebei magúnfulirunga. ");
INSERT INTO cabNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","‘Ánjeinti wéyu lúma óra le lúnbei lasúseredun sun cátei le, ibídiñeti ni ca un, ni joun láni Búngiu ánjeligu ja siélubaña, ni lun Liraǘ, Búngiu rügǘñein le Úguchili asúbudirei. ");
INSERT INTO cabNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Lúnti lubeíti agágudúañu jumá, aríaaja, ayúmuragua lun Búngiu, ladǘga ibídiñeti jun ídame lan lachǘlüra óra ligía. ");
INSERT INTO cabNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ítara lúba quei ában wügǘri le ñǘdünbei luágu ában weíyaasu díse, lubáragiñe láfuridun lúbiñegiñe, ába líchuguni sun cátei jájaburugun lumúsuniña áni ru ligía jawádigimari, aríñaga ligía lun le luágubei béna lun loúnigirun. ");
INSERT INTO cabNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Áu queísi tabúreme múna tugúya, furésebei nagíribudun. Agágudúañu jumá lubeíti, ladǘga ibídiñeti jun cába lan óra nachǘlüra, ánjein gúñounba lubeí lúmoun áriebuba lan, o lubá lan larúgan o bináafin lan, ");
INSERT INTO cabNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ñǘbindügü níñein sódini, ábame nadárirunün arúmuga. ");
INSERT INTO cabNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Le naríñagubei jun aríñaga numúti joun súngubei. Agágudúañu jumá. ");
INSERT INTO cabNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bián rügáali wéyu lubá fédu le arítaguagülei luágu meja dan le lásügürünbei láni Búngiu ánjeli áfaraguáña jarájüñü Ejíptona, máfarawaguntiña jarájüñü Israelítagu, lidáani gíñe fédu le ñí lubei teigúa fein to magánatu ísi. Ábanti jáluajan jábutigu fádirigu jáma arúfudajatiña lilúrudun Moisés ída lúba lan járügüdüni Jesúsu láu eyéerawaguni lun jáfaruni jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ába jaríñagun. —Márügüda wameí fédurugu lueí jafúudun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betániañein Jesúsu lúbiñe Simón lé meja gawágubei gumeín luágu lúra, dánti le ñun líña lan luágu dábula, ába tiábin ában wǘri láu ában budeín buin láu ibíñei le jémeti, le séruti. Ába tájalachuni ligíina budeín, ába téseruni ibíñei lábulugun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ába jagáñidun jádaangiñe ja ñíbaña, ába jaríñagun jámagua. —¿Cámesan leféridirúa ibíñei jémeti le? ");
INSERT INTO cabNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gayáraati jamúgagu lalúgurun luágu sügǘ láu lebégi ában irúmu wadágimanu, lun jíderawagún gudémetiña. Ába jébechunun, ");
INSERT INTO cabNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ába laríñagun Jesúsu. —Ígira jumoún. ¿Ca uágu jañáwurija tun? Ában cátei buíti le tadǘgübei nun. ");
INSERT INTO cabNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Súnwandan ñíbaña lan gudémetiña júma lun jíderaguniña dan le jabúseerun, ánjein áu, mámaba súnwandan júma nan. ");
INSERT INTO cabNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Adǘga táali wǘri to le tiáraabei, jurúguaaru ibíñei luágu núgubu lubá nábunajoún, ");
INSERT INTO cabNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","áni ninárün jáu luágu lídan lan furúmieguarügü fulásu lídan sun uboú le ñí lumuti lapúrichijoúa ugánu le lánina asálbaruni labájüdawagúba gíñe le tadǘgübei wǘri to lun jarítagun tuágu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ábati lídin Júdas Iscarióte, le ában jádaangiñe dúusu láni Jesúsu disípulugu, adímureja jáma jábutigu fádirigu lun ladǘgün darádu jáma lun ledéregeruni Jesúsu joun. ");
INSERT INTO cabNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dan le jagáambubalin, ába jagúndaaragun, ába jaríñagun lun luágu jíchuguba lan seínsu lun. Ába lagúmeserun Júdas áluaja ída lúba lan ledéregeruni Jesúsu joun. ");
INSERT INTO cabNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Le furúmiñeti wéyu lídan fédu le ñí lubei teigúa fein to magánatu ísi, luwéyuri lafarún mudún le lánina fédu le páscua, ába jálügüdüni disípulugu Jesúsu. —¿Jalíagi babúseera lun woúdin aráansera wabárua lun weígini eígini le lánina fédu? ");
INSERT INTO cabNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ába loúnajan biáma jádaangiñe láni disípulugu, ába laríñagun joun lubáragiñe joúdin. —Jeíba ubúrugu, jadúnraguba lúma ában wügǘri ñi táu ában dináa láu dúna, ");
INSERT INTO cabNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","jídinme lárigi le ñíjin lumúti lebélura, ábame jaríñagun lun tabúreme múna. “Ítara líña maésturu, ¿jagoún nege rúmu to lúnboun ñi lan leígei eígini le lánina fédu jáu láni disípulugu?” ");
INSERT INTO cabNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ábame larúfudun ában rúmu weíritu jun, toúgiñegua múna, to aráanseñu tíña, ábameti jaráanseruni eígini woun ñi. ");
INSERT INTO cabNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ába jáfuridun disípulugu, ába jachǘlürün ubúrugun, ába jadáriruni súngubei quei laríñaguni Jesúsu joun, ába jaráanseruni eígini lánina fédu ñi. ");
INSERT INTO cabNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Dan le lagúñedunbei, ába lachǘlürün Jesúsu jáu dúusu disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dánti le luágu jamá dábula eíga, ába laríñagun joun. —Ninárün jáu luágu lalúgurubadina lan ában jídaangiñe le eígibei núma. ");
INSERT INTO cabNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ábati jajírudagun, ába jagúmeserun álügüdaguei ában ában. —¿Áu funásan? ");
INSERT INTO cabNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ába laríñagun Jesúsu joun. —Ában jídaangiñe jugúya dúusu le éderutu leígan fein lídan asíedu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Anángüraadina lubeíti, áu le Wügǘri Garaǘwarügüti, luágu ǘma le uágubei taríñaga Lerérun Búngiu, áni ¡fugiábutia wügǘri le alúgurutina! Buítimaati jamúga lun wügǘri ligía lun magǘriajoúniwa lan. ");
INSERT INTO cabNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Dan le añája lubeí eíga, ába lanǘgünun Jesúsu jeígan fein lújaburugu, ába leteíngiruni Búngiu tuágu, lárigiñe lagúbachagunun ába líchugunun joun, ába laríñagun joun. —Joújuma, núgubu le. ");
INSERT INTO cabNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Lárigiñe, ába lanǘgün ában wéru táu diweín lújaburugu, lárigiñe leteíngiruni Búngiu tuágu, ába líchugunun joun, ába játun sun jagía tídaangiñe diweín tugúya. ");
INSERT INTO cabNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ába laríñagun joun. —Níta le, le añúuragüdübalin iséri darádu, le gíñe áwiyurúabei joun sarágu gürígia lun ferúdunawa lan jafígoun. ");
INSERT INTO cabNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ninárün jáu luágu mátundügüyaadina lan diweín daríme wéyu le lúnbei nátunun iséri tuwúyeri diweín lídan larúeijan Búngiu siélu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Lásun jerémujani urému luágu Búngiu, ába joúdin luágun wǘbü le gíribei Olívos. ");
INSERT INTO cabNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ábati laríñagun Jesúsu joun. —Sun jugúya janúrajaba, ígira jumáname áriebu le, ladǘga taríñajare Lerérun Búngiu. “Náfarubei joúniri mudún jilágubei, ábame jeréderun mudún chagágu.” ");
INSERT INTO cabNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lárigiñeme násaarun lídaangiñe oúweni lúnya nabágaridun, nídiba Galiléa jubáragiñe. ");
INSERT INTO cabNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ábati laríñagun Pédro lun. —Gayáraati jígirunibu sun ja, nugúya, mígirun nubádibu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ába laríñagun Jesúsu lun. —Ninárün báu, áriebu meme le, lubáragiñe layúgurujan gáyu bián weíyaasu, ǘrüwaalime weíyaasu baríñagun luágu ibídiñe nan bun. ");
INSERT INTO cabNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ába laríñagun. —Ni ánjein lun lubeí noúnwen búma, maríñagubadina luágu ibídiñe ban nun. Ligía méme gíñe jaríñaga súngubei. ");
INSERT INTO cabNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ábati jachǘlürün lídoun ában fulásu gíriti Getsemaní, ába laríñagun Jesúsu joun láni disípulugu, —Ñurújuma ya, neíbuga ayúmuragua lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ába lanǘgüniña Pédro, Jacóbo, lúma Juan lúmagua. Ába ladíjeridun larítagun buídu, sandí ligía ában igárigu weíriti tídan lanígi. ");
INSERT INTO cabNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ába laríñagun. —Sandítina ában íruni weíriti le lánina oúweni tídan nuwáni. Reídei jumá ya, áni agágudúañu jumá. ");
INSERT INTO cabNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ábati lídin Jesúsu lubáruaguoún mémeraü, ába labúluchagun múarugun, ába lamúriajan lúma Búngiu ánjein gayára lubeí masúfurirun láani le lúnbei lasúseredun lun lídan óra ligía. ");
INSERT INTO cabNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ába laríñagun lídan layúmuragun. —Núguchi, gayára bumúti sun cátei, séfu bána lueí nasúfuriruni cátei le, máma quei nabúseerun, quei babúseerun. ");
INSERT INTO cabNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ába lídin, ába ladáriruniña disípulugu arúmuga, ába laríñagun lun Pédro. —Simón, ¿barúmuguñasan? ¿Siñátisán buga beréderun ni ában óra agágudúañu? ");
INSERT INTO cabNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Agágudúañu jumá, ayúmuragua jugúyame lueí jeíguadun lídoun ínchajoúni lun jeféridiruni jafíñen nuágu. Inárüni luágu benéfa lan jáni espíritu lun le buídubei, ánjein júgubu, débiliti. ");
INSERT INTO cabNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ábaya lídin ayúmuragua lun Búngiu, aríñageinaleí méme dimúrei le laríñagubei furúmiñe. ");
INSERT INTO cabNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dánya lagíribudun, ábaya ladáriruniña arúmuga ladǘga luweírin lidábu jágu. Ibídiñetiti joun cába lan joúnabagüle lun. ");
INSERT INTO cabNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ábaya lídin lǘrüwan weíyaasu, ába laríñagun joun. —¿Jarúmuguña mémesan, eméraagua jugúya? Buídürügaali, chülǘja óra lun nedéregerúniwa, áu le Wügǘri Garaǘwarügüti, jájaburugun gafígountiña. ");
INSERT INTO cabNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sarájuma, queímoun, níteeli le lúnbei ledéregerunina. ");
INSERT INTO cabNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ñígili Jesúsu adímureja, ligía lachǘlürün Júdas, le ában jádaangiñe dúusu disípulugu, liábin jáu sarágu mútu táu efeín lúma wéwe. Joúnajan jábutigu fádirigu, arúfudajatiña lilúrudun Moisés, jáma ámu wügǘriña weírigutiña lídan jafíñen juríu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aríñagalíti buga Júdas joun ítara. —Le wügǘri le nachúurun, ligía, ábame járügüdüni, ábame janǘgüni, joúnigireime buídu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ítara líña lubeíti, dan le lachǘlürünbei, ába layárafadun Júdas lun Jesúsu, ába laríñagun lun. —Maésturu. Ába lachúuruni. ");
INSERT INTO cabNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ábati járügüdüni Jesúsu, ába janǘgüni adaürǘwa. ");
INSERT INTO cabNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ñíñein ában jádaangiñe ja ñíbaña, ába láluguchunun lefeínte, ába líbuguni ában larígei lumúsun fádiri le íñutimaabei. ");
INSERT INTO cabNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ábati laríñagun Jesúsu joun mútu jagía. —¿Jiábin táu efeín lúma wéwe lun janǘgünina adáüra, camá jamuga jíwerutina? ");
INSERT INTO cabNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ságüñaja wéyu júma nan témpulurugu arúfudaja jun, madaǘ jumútina. Wel, lasúseredunbei le lun lagúnfulirun Lerérun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ábati jígiruni sun disípulugu Jesúsu lábugua, ába janúrajan. ");
INSERT INTO cabNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ñíñein ában wügǘri ñǘraügili afálaruti Jesúsu, darúgu loúgua táurügü ában sídi, ában járügüdüni. ");
INSERT INTO cabNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ába lasáfarun jaweí, ába leíbáagun surúsu, ígira sídi. ");
INSERT INTO cabNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ábati janǘgüni Jesúsu ligíbugiñoun fádiri le íñutimaabei, ába joúndaragun sun jábutigu fádirigu jáma arúfudajatiña lilúrudun Moisés, jáma ámu wügǘriña ja weírigutiña lídan jafíñen juríu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ábati lafálaruni Pédro Jesúsu dísegiñe chülǘ tübǘrürürugun lúban fádiri le íñutimaabei, ába leréderun ñun jáma oúnigirutiña témpulu abácharagua larǘgürügü wátu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jáluajati jábutigu fádirigu lúma sun líñun-ágei lúrudu lidúnrun Jesúsu lun gayáraabei lan jasíadiruni lun láfarúniwa jilágubei, madáritiña lidúnrun. ");
INSERT INTO cabNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sarágu jáña yebe adímurejatiña iyéeni luágu, múaradúntiña láu le jaríñagubei. ");
INSERT INTO cabNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ñíñanu yéetiña ásaarutiña aríñaga. ");
INSERT INTO cabNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Agáambatiwa laríñagun. “Nagǘnrinchaguboun témpulu to, to jadǘgüboun wügǘriña, ábame naráramagüdün ában témpulu lídan ǘrüwa wéyu to máma jadǘga wügǘriña.” ");
INSERT INTO cabNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ni ítara, múaradúntiña láu le jaríñagubei. ");
INSERT INTO cabNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ábati lásaarun fádiri le íñutimaabei jádaangiñe sun jagía, ába laríñagun lun Jesúsu. —¿Moúnabuntíbusan ni cáta? ¿Cáteisan le, le jaríñagubei buágu? ");
INSERT INTO cabNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ába leréderun Jesúsu maníñu, moúnabunga ni cáta. Ábaya lálügüdüni fádiri íñutimaati. —¿Amǘrüsan Crístubei le Liraǘ Búngiu, le lúnbei lasálbaruniña gürígia lídaangiñe jafígoun? ");
INSERT INTO cabNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ába laríñagun Jesúsu lun. —Ánja, áu. Áni jugúya, jaríjubadina, áu le Wügǘri Garaǘwarügüti, ñun lueígiñe loúnwenren Súnti Gabáfu, aríja jumeíme niábin lídan juánriñu siélugiñe. ");
INSERT INTO cabNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ábati lajeíridagunun fádiri íñutimaati lanáangun, le ligáñi, ába laríñagun. —¿Ca ámu wabúseerubei lun líchugun fe luágu guetó? ");
INSERT INTO cabNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Agáamba jumúti lanábaguni Búngiu láu lerérun. ¿Ída líña jaríjin lun líra? Ába jabúdujan súngubei lun láfarúniwa jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ábatí buri jagúmeserun jíbiri ásueraguei, adáuragua láu ligíbu, abúleiseirei, jaríñagati. —¡Aríñaga beígia cátei lan áfarubalibu! Ába buri jagáyuajan súdaara luágu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ñíñein Pédro bürǘrürugu, ligía tiábin ában lumúsun fádiri le íñutimaabei. ");
INSERT INTO cabNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Dan le taríjini abácharagua larǘgürügü wátu, ába taríaguni, ába taríñagun lun. —¿Ma gíñe buga lúmañadibu Jesúsu le Nazarétna? ");
INSERT INTO cabNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ába leyéedagun Pédro, laríñaga. —Ibídiñeti gürígia ligía nun, ibídiñegubeíti nun ca lan uágu badímureja. Ába lígiruni fulásu le ñí lubei labácharagua lun yaráfa lan lun lebéneri baríeru, ábati layúgurujan ában gáyu. ");
INSERT INTO cabNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ábaya taríjini músu tugúya, ába taríñagun joun ja ñíbaña. —Ába giñétia jádaangiñe lánigu Jesúsu le. ");
INSERT INTO cabNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ábaya leyéedagun. Murúsun óra lueígiñe, ábaya jaríñagun ja ñíbaña lun Pédro. —Inárüni, amǘrü ában jádaangiñe, ladǘga Galiléana amǘrü, ítara líña badímurejan quei jagía. ");
INSERT INTO cabNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ába líñaragun Pédro lúngua ánjein máma lubeí inárüni le laríñagubei. Ábaya laríñagun. —Ibídiñeti gürígia le uágubei jadímureja nun. ");
INSERT INTO cabNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lídan óra ligía, ába layúgurujan gáyu libíaman weíyaasu. Ábati larítagun Pédro luágu le laríñagubei buga Jesúsu lun. “Lubáragiñe layúgurujan gáyu bián weíyaasu, beyéedaguba náu ǘrüwa weíyaasu.” Dánti le larítagun luágu, ába layájun. ");
INSERT INTO cabNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Larúgan bináafin, ába joúndaragun jábutigu fádirigu jáma arúfudajatiña lilúrudun Moisés, jáma ámu wügǘriña ja weírigutiña lídan jafíñen juríu lúma sun líbiri líñun-ágei lúrudu, aríja cába lan jadǘga lun lasíadirúniwa Jesúsu. Ába janǘgüni gürágu, ába jedéregeruni lun Pilato. ");
INSERT INTO cabNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ába lálügüdüni Piláto Jesúsu. —¿Amǘrü Jarúeitebei Juríu? Ába loúnabun Jesúsu. —Ánja, ítara líña quei baríñaguni. ");
INSERT INTO cabNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ába buríti jíchugun jábutigu fádirigu sarágu lidúnrun. ");
INSERT INTO cabNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ábayati lálügüdüni Piláto, ába laríñagun lun. —¿Moúnabuntíbusan ni cáta? ¿Aríjabá átiriñein lan bidúnrun íchuguti? ");
INSERT INTO cabNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Moúnabun mémeti Jesúsu ni cáta, ába laweíridun lanígi Piláto láu líra. ");
INSERT INTO cabNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jéchutiti Piláto ígiragüda ában adaürǘti ságü fédu le lánina páscua, le jamúriajan gürígia jádaangiñe adaürǘtiña. ");
INSERT INTO cabNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ñíñeinti ában adaürǘti gíriti Barabási úara jáma ámu ja áfarajabaña gürígia jilágubei lídan iñúraguni luágu gumádi. ");
INSERT INTO cabNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ábati jayábin gürígia, ába jaríñagun lun Piláto lun ladǘgüni queíñaja ladǘga. ");
INSERT INTO cabNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ába lálügüdüniña. —¿Buséntün lun nígiragüdüni Jarúeite Juríu? ");
INSERT INTO cabNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Laríñagubaalin Piláto líra ladǘga busén lán yebe lígiragüdüni Jesúsu, subúdi lumúti luágu ladǘga lan gimúgaü jedéregerei jábutigu fádirigu. ");
INSERT INTO cabNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Fúgüda jamáña jábutigu fádirigu gürígia, jaríñaga joun lun jamúriajan lun lígiragüdüni Barabási, máma Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ábati laríñagun Piláto. —¿Cáti jabúseerubei nadǘgün láu le uágubei jaríñaga Jarúeite Juríu? ");
INSERT INTO cabNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ába jagúaragun. —¡Dáguabeí luágu gurúwa! ");
INSERT INTO cabNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ába laríñagun Piláto joun. —¿Cáti wuríbati ladǘgübei? Ábaya jagúaragun. —¡Dáguabeí luágu gurúwa! ");
INSERT INTO cabNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Queíti busúen lan Piláto leréderun buídu jáma gürígia, ába lígiragüdüni Barabási, lárigiñeti loúnajan abeíchei Jesúsu, ába ledéregeruni lun ládarawagún luágu gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ábati janǘgüni súdaara lídoun tübǘrürü lúban urúei, ába joúndarúniwa sun súdaara. ");
INSERT INTO cabNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ába jadáüraguagüdüni táu ában anáanguni funátu, ába jadǘgün ában rídi láuti jíyu, ába jíchuguni leréberugu. ");
INSERT INTO cabNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ába jagúmeserun agúaraja lun. —¡Gabágarilá Jarúeite Juríu! ");
INSERT INTO cabNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ába jagáyuajan lábulugun láu ában wéwe, ába jásueraguni, ába jájuduragun abúsura lun. ");
INSERT INTO cabNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Lárigiñe jéjerajan láu ítara, ába jarágachunun anáanguni to jadáürüboun luágu lueí, ába jadáürünun lanáangun luágu. Ába jaságaruni lun jádaraguni luágu gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ñíñein ában wügǘri Cirénena, gíriti Simón, lúguchi Alejándro lúma Rúfo, liábiña áraabugiñe, dan le lásügürün ñígiñe, ába jafósuruni lun lanǘgüni lugúruwan Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ába janǘgüni Jesúsu lídoun ában fulásu gíriti Gólgota, míni lan líra, Lufúlasun Lábu Ichǘgü. ");
INSERT INTO cabNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ába jíchugun diweín láu ában luwúyeri árani gíriti mírra tídoun lun, mátun lumútu. ");
INSERT INTO cabNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ábati jádaraguni luágu gurúwa, ába jájurerun súdaara ubúnuruni lun jaríjin cába lan jádaangiñe erédera táu lanáangun. ");
INSERT INTO cabNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ladaǘnrün néfu bináafin, ligía jádaraguni luágu gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ába labǘrüdǘniwa lidúnrun ñi. “Jarúeite Juríu.” ");
INSERT INTO cabNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Dáguatiña gíñe bián jíwerutiña luágu gurúwa úara lúma, ában lueígiñe loúnwenren, ában lueígiñe lubaǘna. ");
INSERT INTO cabNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Láu líra lagúnfulira le taríñagubei Lerérun Búngiu. “Abájüdǘwati jáma wuríbatiña.” ");
INSERT INTO cabNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dan le buríti jásügürün gürígia, ába jájinjani jachǘgü láu, ába janábuni, jaríñaga. —¡Bugúya le aríñagubei luágu fíbounme lan témpulu, ábaya lánme baráramagüdünun lídan ǘrüwa wéyu, ");
INSERT INTO cabNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","séfuguabá búngua, raríba lueígiñe gurúwa! ");
INSERT INTO cabNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ába gíñe jéjerajan jábutigu fádirigu jáma arúfudajatiña lilúrudun Moisés láu, ába jaríñagun jámagua. —¡Séfuti ámu, ánjein ligía, siñáti leséfuragun lúngua! ");
INSERT INTO cabNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Raríla Crístu, Jarúeite Israelítagu, lueígiñe gurúwa guetó wagíbugiñe, afíñe wamámuga luágu! Ja dáwaguñubaña luágu gurúwa úara lúma, anába jamúti gíñe. ");
INSERT INTO cabNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Amídirugu, ába labúrigadun sun uboú darí ladaǘnrün ǘrüwa rábounwéyu. ");
INSERT INTO cabNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ligía lagúaragun Jesúsu. —Eloí, Eloí, ¿láma sabáctani? —míni lan líra. Nubúngiute, Nubúngiute, ¿cásan uágu bígirana? ");
INSERT INTO cabNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ñíñanu jádaangiñe ja ñíbaña agáambuti, ába jaríñagun. —Agáamba jumá, lagúajaña lun proféta Elías. ");
INSERT INTO cabNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ába leíbaagun ában jádaangiñe, ába ladǘdüragüdün ában mudúsi táu diweín garǘjütu, ába líchuguni luágu ában wéwe, ába línchuni lun Jesúsu lun lachúurunun, ába laríñagun. —Ígira wameí guetó, waríja ánjein ñǘbin Elías aráriragüdei. ");
INSERT INTO cabNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ábati ladǘgün Jesúsu ában agúaraguni jéreti, ába loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ába tajeíridagun tubélun témpulu lídan bián murúsun íñugiñe lun ǘnabun. ");
INSERT INTO cabNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Dan lagáambuni jábuti súdaara Rómana le rárabei ligíbugiñe Jesúsu lagúaragun, aríjaleí ída líña lan loúnwen, aba laríñagun. —Inárüni luágu Liraǘ lan Búngiu wügǘri le. ");
INSERT INTO cabNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ñíñanu gíñe würíña, aríagutiña dísegiñe, ñíñoun María Magdaléna, María to lúguchu Jacóbo le ñǘraütimagilíbei, lúguchu gíñe José, ñíñoun gíñe Salomé. ");
INSERT INTO cabNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Würíña ja, falá jamuti Jesúsu áni íderagua jamúti dán meja le Galiléañein lan. Ñíñanu gíñe sarágu ámu würíña ja ñǘbinbaña Jerusaléoun úara lúma Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Lubáragiñe lálüdün wéyu, ába liábin José, ában wügǘri inébewati jádaangiñe líñun-ágei lúrudu, le agúrabajabaalin lagúmeserun larúeijan Búngiu táu sun lanígi, lílana fulásu le gíribei Arimatéa. Queíti luwéyuri lubeí lan aráansejani, le ában wéyu lubá wéyu le eméraaguagülei, ába lebélurun le ñíjin lubeí Piláto amúriajei lúgubu Jesúsu, úouga ni murúsun anúfudei lídan. ");
INSERT INTO cabNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ába laweíridun lanígi Piláto dan le lagáambun luágu jilá lan Jesúsu, ába loúnajan luágu ában jábuti súdaara lun lálügüdüni ánjein inárüni lubeí luágu jilá lan. ");
INSERT INTO cabNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Dan le laríñagunbei lun luágu inárüni lan, ába líchuguni Piláto lúgubu Jesúsu lun José. ");
INSERT INTO cabNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ábati lagáñijan José ában gamísa fínutu, ába larárigüdüni lúgubu Jesúsu lueígiñe gurúwa, ába loúburaguni táu. Ába líchuguni lídoun ában umúajaü achigíti luágu dǘbü, ába ladáuruni láu ában dǘbü. ");
INSERT INTO cabNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ába tídin María Magdaléna túma María to lúguchu José aríjei fulásu le ñí lubei labunúa Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dan le lásügürünbei wéyu le eméraaguagülei, ába jagáñijan María Magdaléna, María to lúguchu Jacóbo, túma Salomé ibíñei lun joúdin ájurudei luágu lúgubu Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dimáasu, láfunaduña larúgan, ába joúdin luágu lumúaja, ");
INSERT INTO cabNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ábati jaríñagun jámagua. —¿Cábasan agídarei dǘbü lueígiñe lubéneri umúajaü? ");
INSERT INTO cabNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Dan le jaríjinbei, úaali oúnwenbun dǘbü ligía lídan lilúgaarun. ");
INSERT INTO cabNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ába jebélurun lídoun umúajaü, ába jaríjin ában wügǘri ñǘraügili ñun ñi lueígiñe loúnwenren táu ában goúnu jarútu. Ába janúfudedagun, ");
INSERT INTO cabNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ába laríñagun joun. —Manúfudedagua jumá, jáluajañein Jesúsu le Nazarétna le ádarawagúbei luágu gurúwa, úati ya, sará lídaangiñe oúweni. Aríja jumeísan fulásu le ñí lubei líchugúa. ");
INSERT INTO cabNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jeíba, jaríñagame joun láni disípulugu, lúntima Pédro, luágu níngiran lan luágu ǘma lun Galiléoun jubáragiñe. Jaríjibei ñi quei laríñaguni jun. ");
INSERT INTO cabNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ába joúdin würíña jagía anúrajeina ñígiñe ladǘga lebélurun ában luweírin anúfudei joun. Maríñaguntiñati ni cáta ni ca un ladǘga janúfude. ");
INSERT INTO cabNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Lárigiñe lásaarun Jesúsu lídaangiñe oúweni, dimáasu bináafin, ába larúfudagun lúngua furúmiñe tun María Magdaléna, to méja ueíboun laságara sédü espíritugu wuríbatiña. ");
INSERT INTO cabNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ába tídin, ába tawísaruniña ja eíbugubaña meja lúma. Dan le tadárirunbáliña, jayájuajaña ladǘga lanárime íruni jádan luágu loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Dan le jagáambun luágu wínwanya lan, luágu aríja táani, mafíñetiña. ");
INSERT INTO cabNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Lárigiñe, ába larúfudagun Jesúsu lúngua joun biáma jádaangiñe já meja eíbugubaña lúma, joúdiña áraabun. Ibídiñetí yebe joun luágu Jesúsu lan. ");
INSERT INTO cabNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ába joúdin, ába jawísaruniña ja jíbiri, ni jagía, mafíñetiña. ");
INSERT INTO cabNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lárigiñe, ligía larúfudagun Jesúsu lúngua joun únsu disípulugu jagía dan le ñun jamá luágu dábula, ába celadeínjan joun luágu liloúguan jafíñen lúma lidére jachǘgü, ladǘga mafíñen jamá joun ja aríjubalin lárigiñe lásaarun. ");
INSERT INTO cabNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ába laríñagun joun. —Jeíba lídan sun fulásu apúrichija jumeí ugánu le luáguti asálbaruni joun sun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ja afíñerutiña luágu, badísei jagíame, jasálbaruba, ja mafíñetiña, jeféridiruba lídaanme luwéyuri agúseragüdüni. ");
INSERT INTO cabNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Niján cátei le lúnbei jarúfuduni ja afíñebaña nuágu, lun lasúbudirúniwa luágu Búngiu lan oúnajabaliña. Jaságaruba espíritugu wuríbatiña jaweí gürígia lídan níri, jadímurejaba ámu dimúrei lueí jerérun, ");
INSERT INTO cabNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ánjaña árügüda jéwe jájaburugu o ánjaña lan áta cátei le gáfarajati, madǘgünbei wuríbani joun, lánwoun sun líra, jíchugubei jájabu jawágu sánditiña, ábame jareídagun. ");
INSERT INTO cabNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Lárigiñe ladímurejan joun, ába líñurúniwa Jesúsu siélun, ába lañúurun lueígiñe loúnwenren Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ába jáfuridun disípulugu, ába japúrichijani ugánu le lánina asálbaruni lídan sun fulásu. Jesúsu méme íderagua lumútiña, áni choúrugüdaleí ugánu le japúrichijabei láu miláguru lé buri jadǘgübei.");
INSERT INTO cabNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lun Teófilo le weírigubei. Gíbeeña gürígia oúchutiña jabǘrüjani cátei lé buri luáguti wasálbarun lé meja asúseredubei wagánagua lídan lúaragun, ");
INSERT INTO cabNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","áfaaguatiña jabǘrüjani ítara quei jarúfudajani ja aríjubalin buri cátei ligía lúmagiñe lagúmeserun, apúrichija jagía luágu, woun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Áu gíñe, álügüdajaadina gíñe buídu buídu libǘgürü sun cátei le asúseredubei lúmagiñe lagúmeserun, áni afíñetina luágu maríban lan lun nabǘrüjanun gárada to bun quei lubúdubu, ");
INSERT INTO cabNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","subúdi bámugei linárün cátei le arúfudúaalibei bun buídu buídu. Niján le asúseredubei. ");
INSERT INTO cabNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dán meja le Heródes lan urúeibei Judéa, ñíñein meja ában fádiri lánina jafíñen juríu, gíriti Zacarías, jádaangiñeti fádirigu ja lánigu Abías. Elisabét tíribei lúmari, jádaangiñetu giñe ladǘgawagun Aarón. ");
INSERT INTO cabNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Biángubei jagía, richáguatiña ligíbugiñe Búngiu, gúnfulitiña lúma, adǘga jameí sun le lubeíbei darí lun siñá lan laríñawagún ni cáta wuríbati jawágu. ");
INSERT INTO cabNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Masáanigutiña ladǘga siñá lan tagáragüdün Elisabét, áni derébugugaaña gíñe jagía biángubei. ");
INSERT INTO cabNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Luágu ában wéyu, lídan lidáani jesériwidun lánigu Zacarías quei fádirigu ligíbugiñe Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ába jabúdujan según jagáburi fádirigu juríu, lun jasúbudiruni cába lan ebélura lídoun fulásu le sándutimaabei témpulurugu águdaja cupáli ligíbugiñe Búngiu, ába láburujan luágun Zacarías. ");
INSERT INTO cabNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sun niján lan cupáli águdajoúa, añája gürígia boúgudi ayúmuragua lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ábati lasáliragun ában láni Wabúreme ánjeli lun Zacarías, rára lueígiñe loúnwenren latárü le ñí lubei cupáli. ");
INSERT INTO cabNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Dan le laríjini Zacarías ánjeli ligía, ába laweíridun lanígi, ába lebélurun anúfudei lídoun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ába laríñagun ánjeli ligía lun. —Manúfudebá, Zacarías, ladǘga agáamba láali Búngiu bayúmuragun, tagáraüduba búmari ában irájü, ábame bíchuguni líri Juan. ");
INSERT INTO cabNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tabuínchuba banígi láu ugúndani luágu, áni sarágujaba gíñe agúndaarutiña láu lagǘriajoún, ");
INSERT INTO cabNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ladǘga weírigubei biraǘ ligíbugiñe Búngiu. Mátunbei diweín ni bínu, áni ñíbei Sífiri Sándu lúma lúmagiñe lubáragiñe lagǘriajoún lun ladúndejani lídan sun cátei. ");
INSERT INTO cabNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ladǘgüba lun jagíribudun sarágu jádaangiñe Israelítagu lun jagáambuni Jabúngiute, ");
INSERT INTO cabNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","lesériwiduba lun Búngiu láu sarágu ubáfu queí meja ladǘgüni Elías. Laráansejaba lubá Jesúsu láu laráandaragüdüniña agǘbürigu jáma isáanigu, láu gíñe larúfudajan joun ja magáambadibaña lun Búngiu lun júaradun lúma queísi gürígia richáguatiña. Ítara lúba laráanseruniña lubá jerésibiruni Jabúreme Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ába laríñagun Zacarías lun ánjeli ligía. —¿Ída lubági nachoúruni cátei le? Áu táu sun númari, derébugugaadiwa. ");
INSERT INTO cabNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ába laríñagun ánjeli ligía lun. —Gabriél áu, áni nesériwiduña lun Búngiu, ligía oúnajabalina adímureja bun lun níchuguni ugánu buíti le bun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Guetó, quei mafíñerun bubeí luágu le naríñagubei bun, berédera merérunga, siñábei badímurejan daríme lagǘriajoún biraǘ. Lagúnfuliruba cátei le lídan lidáani. ");
INSERT INTO cabNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sun dan le, añájati buga gürígia boúgudi agúrabajei Zacarías, weírititi janígi luágu lílü témpulurugu. ");
INSERT INTO cabNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Dan le láfuridunbei, siñá ladímurejan joun, ábati jasúbudiruni luágu salígua lan som cátei lun, témpulurugu. Ladímurejati joun láu seíni, meréngadijaali. ");
INSERT INTO cabNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Dan le lagúmuchun dan le lúnbei lesériwidun Zacarías témpulurugu, ába lídin lúbiñoun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Lárigiñe cátei le, ába tadágeinadun Elisabét, to lúmari, ába máfuridun tan jábiñegiñe luágu seíngü játi, teréngati túnguarügü. ");
INSERT INTO cabNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ladǘgüñein Búngiu lubuídun cátei le nun guelé lun lagídaruni nibúsigari jagíbugiñe gürígia.” ");
INSERT INTO cabNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sísi játi lárigiñe, ába loúnajani Búngiu ánjeli Gabriél lídoun ában ubúrugu láni Galiléa, gíriti Nazarét, ");
INSERT INTO cabNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","lun lídin bisídoun ában wǘri irájügiru, gíritu María. Wǘri tugúya, gadáraduñoun lúma ában wügǘri gíriti José lun tamárieidun lúma, wügǘri ligía, linébaanfan urúei Davíd. ");
INSERT INTO cabNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ába lebélurun ánjeli ligía le ñíjin tubeí, ába laríñagun tun. —¡Báfaguagüle, María! Níjein Búngiu búma, binílaadibu sügǘ jáu sun würíña. ");
INSERT INTO cabNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dan le tagáambuni ánjeli ligía, ába tájüchürün láu le laríñagubei, ába tálügüdagun túngua ca lan uágu labúsura tun ítara. ");
INSERT INTO cabNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ábati laríñagun ánjeli ligía tun. —Manúfudebá María, fuleísei láadibu Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","badágeinada, ábame bagǘriajan ában irájü, ábame bíchuguni líri Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Weírigubei, Liraǘ Búngiu le íñubei lúba lagúarúniwa, áni larúeigüdübei Wabúreme Búngiu quei larúeigüdüni Davíd, le binádu lidúje. ");
INSERT INTO cabNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Lagúmadirubei linásiñun Israél lun sun dan, áni magúmuchadibei lagúmadijan. ");
INSERT INTO cabNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ábati taríñagun María lun ánjeli ligía. —¿Ída lubági lasúseredun cátei le, mámarigidinagu? ");
INSERT INTO cabNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ába laríñagun ánjeli tun. —Liábinba Sífiri Sándu buágun, ábame loúburagunibu lubáfu Búngiu. Ligía sándubei lubeí irájü le lúnbei bagǘriajani, Liraǘ Búngiu lúba lagúarún. ");
INSERT INTO cabNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tiábin bidúje to Elisabét, dageínaaru gíñe lau sun weíyaaru lan, tagáraüdüba ában wügǘri irájü, ítara líña lubeíti, tó meja uáguboun jaríñaga luágu siñá lan tagáraüdun, níjein sísi játi dageínaü tuágu. ");
INSERT INTO cabNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Úati ni cáta siñáti lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ábati taríñagun María. —Lidámun Nabúreme Búngiu nugúya, adǘgaleí le baríñagubei náu. Lárigiñe, ába lídin ánjeli. ");
INSERT INTO cabNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lídoun dan ligía, ába tídin María furése lídoun ában ubúrugu le labádinaguabei buri wǘbü Judéa, ");
INSERT INTO cabNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ába tebélurun lúbiñoun Zacarías, ába tabúsurun tun Elisabét. ");
INSERT INTO cabNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Dan le tagáambuni Elisabét tabúsurun, ába lánjingichagun tiraǘ turágeirugu, ába liábin Sífiri Sándu tuágun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ábati taríñagun láu umálali le jéreti. —Binílaadibu Búngiu sügǘ jáu sun jiñáriñu, binílaali gíñe biraǘ. ");
INSERT INTO cabNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Cátanañadina lun tiábin lúguchu Nabúreme bisídana? ");
INSERT INTO cabNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Láu nagáambuni babúsurun, ába lánjingichagun niraǘ nurágeirugu láu ugúndani. ");
INSERT INTO cabNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gúndaatibu bugúya le afíñerubei, luágu lagúnfuliruba lan cátei le laríñagubei Wabúreme bun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ábati taríñagun María. Rútu nuwáni uweíriguni lun Nabúreme, ");
INSERT INTO cabNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","gúndaagua tugúya nanígi luágu Búngiu le Nasálbaragüle, ");
INSERT INTO cabNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","lugúndun gudémejabujaali nun, nugúya le lidámun. Lúmagiñe guelé, jaríñaguba sun gürígia luágu fuleíseiwaadina lan, ");
INSERT INTO cabNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ladǘga adǘgaali Búngiu, le Súnti Gabáfu, cátei weínamuti nun, sánduti líri. ");
INSERT INTO cabNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Súnwandan gudémebaña lan ja inébejabúbaña lun, lun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Adúgaali oúnwenbun buri cátei, adǘgaali lun ni cáta jamá ja barǘguabaña joúngua. ");
INSERT INTO cabNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Gidálaaña ja gabáfubaña lídaangiñe jaweírigun, ja ǘnabubaña, ába ladǘgüniña lun weírigu jamá. ");
INSERT INTO cabNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Já buga lamábaña, quimúlegüda lumútiña, ánjeinti ja rísibaña, míchugunti ni cáta joun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Íderagua lumútiña linásiñun Israél, ja esériwidubaña lun, mabúlieidun lumúti lun gudémejabu lan, ");
INSERT INTO cabNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","queí meja lidáradun jáma binádu wagǘbürigu— Abrahám jáma ladǘgawagun—lun gudémejabu lan joun lun sun dan. ");
INSERT INTO cabNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ába teréderun María ǘrüwa játi ñi, lárigiñe, ába tagíribudun jábiñoun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ába lagúnfulirun dan lun tagǘriajan Elisabét, ába tagǘriajan ában wügǘri irájü. ");
INSERT INTO cabNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Dan le jagáambun tubésinanigu jáma tidújeñu luágu lubuídun cátei le ladǘgübei Búngiu tun, ába jagúndaarun úara túma. ");
INSERT INTO cabNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Luágu liwídün wéyu, ába lerésibiruni circuncisión, le liseíni luágu láni lan Búngiu irájü ligía. Buséntiña yebéti jíchuguni líri lúguchi luágu, le Zacarías, ");
INSERT INTO cabNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ába taríñagun lúguchu. —Uá, Juánba líri. ");
INSERT INTO cabNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ába jaríñagun tun. —¿Cági uágu? Úati ni ában jádaangiñe binébaanfaangu gíriti Juan. ");
INSERT INTO cabNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ába jálügüdüni lúguchi irájü láu seíni ca lan íri labúseerubei líchugun luágu. ");
INSERT INTO cabNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ába lamúriajan ában murúsun fuláansu, ába labǘrüdün luágun. “Juan líribei.” Ába laweíridun janígi súngubei láu cátei le. ");
INSERT INTO cabNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lídan méme óra ligía, ába gayáraajaali lan ladímurejan Zacarías, ába líchugun uweíriguni lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ába laweíridun janígi besínagu láu cátei le, ába labájüdawagún cátei le lídan sun fulásu geyégua jáu. ");
INSERT INTO cabNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sun ja agáambubalin, ába jeréderun asáminara, ába jálügüdagun jámagua, jaríñaga. —¿Cáteibeí funasan irájü le? Ladǘga biní lumútija Búngiu le tímatimaati. ");
INSERT INTO cabNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ába liábin Sífiri Sándu luágun Zacarías, le lúguchi irájü ligía, ába ladímurejani Zacarías dimúrei le laríñagubei Búngiu lun, ába laríñagun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Buídulá ladímurejoún luágu Wabúreme le Jabúngiutebei gürígia ja Israelítagu, ladǘga ñǘbinjali woun, wagía le lánigu, áni sálba láadiwa. ");
INSERT INTO cabNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Rújali ában Asálbaragülei le gabáfuti woun jádaangiñe linébaanfaangu Davíd, lé meja esériwidubei lun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ítara líña meja laríñaguni Búngiu jádaangiñe láni profétagu ja edéregeragubaña joúngua lun, lúmagiñe meja binádu dan, ");
INSERT INTO cabNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","luágu lasálbarubádiwa lan jaweí wáganiñu lúma jaweí sun ja iyéreejabúbaña woun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ítara líña gudémejabu lan Búngiu joun binádu wagǘbürigu, arúfudaleí luágu mabúlieidagun lan lueí lidáradun le sándubei jáma. ");
INSERT INTO cabNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Niján lé meja laríñagubei lun wáguchi Abrahám. ");
INSERT INTO cabNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","luágu leséfurubadíwa lan jaweí wáganiñu, lun gayáraabei lan wesériwidun lun manúfudeiga, ");
INSERT INTO cabNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","láu úarani, derégeguñu wagía woúngua lun, sun dan le wabágaridubei. ");
INSERT INTO cabNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Áni bugúya nisáaniraü, láni Búngiu le íñubei proféta lúba bagúarúniwa, ladǘga baráansejaba lubá Wabúreme, ");
INSERT INTO cabNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","subúdi lámuga ǘma lánina asálbaruni joun lánigu, le áubei ferúdunawa lan jafígoun. ");
INSERT INTO cabNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wabúngiute, láu lísiñejabu lúma lugúdemejabu, loúnajabei Crístu wámoun siélugiñe ");
INSERT INTO cabNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","lun larúgoungadágüdün jáu ja lídaanbaña lubúriga lúma jáu ja luágubaña ǘma le oúwenibei lébeja, lúma lun ladúndejani wapásun lídoun ǘma le anǘgübaliwa lídoun darángilaü. ");
INSERT INTO cabNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aweírideina ligíati irájü ligía, afáragadagueina gíñe lídan láni espíritu. Ába laganoún lídan fulásu mageírawati darí lúmoun wéyu le lagúmeserun luwádigimari lun Búngiu jagánagua lumútuniña Búngiu ja Israelítagu. ");
INSERT INTO cabNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lídoun buga dan ligía, ába laríñagun urúei Augústo lun jabájüdǘn sun gürígia ja Rómabaña. ");
INSERT INTO cabNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Furúmiñe meja jadǘgüni cátei le, dán meja le Cirénio lan agúmadijabei Síria. ");
INSERT INTO cabNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Súnti gürígia mósu joúdin jageíra lun ñi lan jabájüdǘwa. ");
INSERT INTO cabNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ligía láfuridunbei José Nazarétgiñe, loúbawagugiñe Galiléa, ába lídin loúbawagun Judéa lídoun fulásu le gíribei Belén, le ñí lubei lagǘriajoúa Davíd, quei linébaanfan lubeí Davíd José. ");
INSERT INTO cabNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ába lídin Belén lun labájüdǘn úara túma María to gadáradunboun lúma lun jamárieidun, áni dageínañoun. ");
INSERT INTO cabNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Dánti le añája lan ñi Belén, ába lachǘlürün dan lun tagǘriajan María. ");
INSERT INTO cabNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ába tagǘriajani furúmiñeti tiraǘ ñi, ába toúburaguni tídan lágei, ába taroúnragüdüni ñi tídan jában anímaalu ladǘga úati ubáraü joun tídan jában chülǘdügütiña. ");
INSERT INTO cabNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Lídan áraabu boúgudi lueí Belén, ñíñanu joúniri mudún, bou larúgan jáu oúnigiraña jalǘgüniña mudún. ");
INSERT INTO cabNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sódini, ába lasáliragun ában láni Wabúreme Búngiu ánjeli siélugiñe joun, ába jaríjin ában oúnwenbun larúgounga le lánina Búngiu geyégua jáu, ába janúfudedagun. ");
INSERT INTO cabNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ába laríñagun ánjeli ligía joun. —Manúfudeda jumá, ladǘga níjein ugánu buíti nanǘgün jun, lébunabei sarágu ugúndani joun sun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","luágu agǘriajoúaali lan ában asálbaragülei jun ugúñe, lageíra Davíd, Crístu le Jabúreme. ");
INSERT INTO cabNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jadárirubei irájü ligía joúburagu tídan lágei, roun tídan jában anímaalu. ");
INSERT INTO cabNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lídan óra ligía, ába jasáliragun sarágu ánjeligu lubádu furúmiñeti ánjeli, ába jíchugun uweíriguni lun Búngiu, jaríñaga. ");
INSERT INTO cabNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Uweíriguni lun Búngiu lídan líñutima siélu, darángilaü múarugu jádan gürígia ja ibíjubalin lufúleisein! ");
INSERT INTO cabNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Dánti le jagíribudun ánjeligu járigoún siélun, ába jaríñagun joúniri mudún jámagua. —Queímoun Belén aríjei cátei le asúseredubei, le uágubei lasúbudiragüda Wabúreme Búngiu woun. ");
INSERT INTO cabNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ába joúdin furésegueina, ába jadárirunun María lúma José, lúma irájü roun tídan jában anímaalu. ");
INSERT INTO cabNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Dan le jaríjinbalin, ába jabájüdaguni le laríñagubei ánjeli joun libǘgürü le. ");
INSERT INTO cabNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Súnti ja agáambuliña, weíriti janígi láu le jaríñagubei. ");
INSERT INTO cabNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Áni María, areídañu tíñein sun cátei le tídan tanígi, arítagua luágu. ");
INSERT INTO cabNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ábati jagíribudun joúniri mudún, adímurejeina weíri luágu Búngiu, luágu sun le jagáambubei lúma le jaríjibei, ladǘga suséreti ítara quei laríñawagúniwa joun. ");
INSERT INTO cabNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Luágu liwídün wéyu, ába lerésibiruni circuncisión, ába jíchuguni líri Jesúsu, íri méme le líridubei ánjeli tun María lubáragiñe tadágeinadun. ");
INSERT INTO cabNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Dan le lagúnfulirunbei lidáani jarúmadun lagǘbürigu Jesúsu según igáburi lídan lilúrudun Moisés, ába janǘgüni irájü ligía ubúrugun Jerusalén lun jedéregeruni lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jadǘgünbalin líra ladǘga laríñajare tídan lilúrudun Búngiu. “Sun furúmiñeti wügǘri irájü agǘriajoúti lúnbei Búngiu.” ");
INSERT INTO cabNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ába lubeíti joúdin adágaragüda le uágubei laríñaga lilúrudun Búngiu. bián wagúgua o bián lan únjun. ");
INSERT INTO cabNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lídan meja dan ligía, ñíñein meja ában wügǘri Jerusalén gíriti Simeón. Wügǘri ligía ában wügǘri buíti, weíriti ledéregeragun lúngua lun Búngiu, áni agúraba lumúti liábin Crístu, le lúnbei lasálbaruniña Israelítagu. Ñíñein Sífiri Sándu lúma Simeón, ");
INSERT INTO cabNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","áni arúfuda láali lun luágu moúnwenbei lan maríjingaleí Crístu le lúnbei loúnajani Wabúreme Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ába lídin wügǘri ligía témpulurugun, ladúndejan Sífiri Sándu. Dánti le janǘgünbalin lagǘbürigu Jesúsu Jesúsu témpulurugun lun jadǘgüni le laríñagubei lúrudu láu, ");
INSERT INTO cabNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ába loúyuajani Simeón, ába líchugun eteíngiruni lun Búngiu, aríñageina ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Nabúreme, gayáraajali bígirunina lun noúnwen láu darángilaü, nugúya le esériwidubei bun, ladǘga gúnfuli báali le baríñagubei nun. ");
INSERT INTO cabNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Aríja náali Wasálbaragüle láu nágu, ");
INSERT INTO cabNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Asálbaragülei le boúnajabei joun sun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ítara lúba queísi ában lámpu lun larúfuduni inárüni joun ja mámabaña juríu, ru ligíame uweíriguni joun Israelítagu, ja bánigu. ");
INSERT INTO cabNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ába laweíridun lanígi José táu sun María láu le laríñagubei Simeón luágu irájü le. ");
INSERT INTO cabNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ábati labíniruniña Simeón, ába laríñagun tun María, to lúguchu Jesúsu. —Irájü le, lébunabei achúgeraguni joun sarágu Israelítagu, lébunabei gíñe asálbaruni joun jíbiri. Ítara lúba queísi ában seíni le lúnbei gíbe jamá májatiña jerésibiruni. ");
INSERT INTO cabNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ítara lúba lasúbudirúniwa le larítagubei cáda ában tídan lanígi luágu Crístu. Áni ítara lúba sun cátei le bun quei ában efeín to ácharurutu tuágu buwáni. ");
INSERT INTO cabNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ñíñoun gíñe ában wǘri proféta, gíritu Ána, wǘri tugúya liraǘ Fanuél, jádaangiñe ladǘgawagun Áser. Weíriyaaru wǘri tugúya, ñǘraügiru meja tamárieidunbei, sédüñein irúmu táu lúma túmari, ába loúnwen, ");
INSERT INTO cabNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","guetó, gádürü-weín-gádürü irúmu táu. Máfuriduntuti témpulurugugiñe, terédera ñi esériwida lun Búngiu áriebu wéyuagu, ayúnara lúma ayúmuragua lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ába tiábin Ána jawágun María, José, lúma Jesúsu lídan méme óra ligía, ába teteíngiruni Búngiu luágu irájü ligía, adímureja tugúya luágu Jesúsu joun sun ja agúrabajabaalin lasálbarún Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Lárigiñeti jagúnfulirun láu sun le laríñagubei lilúrudun Búngiu, ába jagíribudun María, José, lúma Jesúsu Galiléoun lídoun jabúrugute le Nazarét. ");
INSERT INTO cabNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aweírideina ligíati irájü le, éredeina ligía, afáragadagueina lídan lichú áu, biní lumútijati Búngiu sarágu. ");
INSERT INTO cabNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ságüja irúmu joúdin lagǘbürigu Jesúsu ubúrugu Jerusalén lubá fédu le páscua, ");
INSERT INTO cabNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","áni dan le lagúnfulirunbei Jesúsu dúusu irúmu, ába joúdin súngubei Jerusalén quei le jagáburi lídan fédu ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Dánti le jagíribudun lárigiñe lagúmuchagun fédu, ába leréderun irájü ligía Jerusalén, ibídiñoun tun lúguchu ni lun José, ");
INSERT INTO cabNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","jarítagún yebe luágu níten lan jádan gürígia ja jámarigubaña luágu ǘma. Ítara líña jadǘgün ában wéyu eíbuguni, dan le jáluajani jádan jadújeñu lúma jádan jasúbudiraagun, ");
INSERT INTO cabNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","madári jamúti. Ábati jagíribudun ubúrugun Jerusalén áluajei ñi. ");
INSERT INTO cabNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ǘrüwa wéyu lueígiñe, ligía jadáriruni témpulurugu ñun jádan arúfudajatiña lilúrudun Moisés, agáambajaña, álügüdaguaña. ");
INSERT INTO cabNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Súnti ja agáambubalin, weíriti janígi luágu lichú láu lúma luágu buri loúnabagüle. ");
INSERT INTO cabNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Dan le jaríjinbalin lagǘbürigu, ába laweíridun janígi, ába taríñagun lúguchu lun. —¿Cáme badǘgei cátei le woun, niraǘ? Nugúya lúma búguchi, wáluajañadibutia láu idíjeri. ");
INSERT INTO cabNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ábati laríñagun Jesúsu joun. —¿Cági uágu jáluajana? ¿Ibídiñeti jun luágu lúnti lan neténirun lun cátei le láni Núguchi? ");
INSERT INTO cabNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Úati gunfaráanda jamáni le laríñagubei joun. ");
INSERT INTO cabNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ábati lagíribudun jáma, Nazarétün, ába lasígirun láu meme lagáambadi joun. Ábatí buri tareíduni lúguchu sun cátei le tarítagunrugun. ");
INSERT INTO cabNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Niján mémeti Jesúsu aweírideina dándu lúgubu queísi lisáminan, áni buítiti dándu ligíbugiñe Búngiu quei jagíbugiñe gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Lídan liqueínsin lirúmuduri lagúmadijan Tibério César, Póncio Piláto ligía meja gumándanbei Judéa, Heródes gumándan Galiléa, Felípe, le lamúlen, ligía gumándan Itúrea lúma Traconíte, Lisanías gumándan Abilínia, ");
INSERT INTO cabNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás lúma Gáifasi, jagía fádirigu íñutimáabaña lídan jafíñen juríu. Ábati líchugun Búngiu ában ugánu lun Juan, le liraǘ Zacarías, lídan fulásu mageírawati, ");
INSERT INTO cabNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ába leíbuguni Juan sun fulásu buri le lubádubei dúna le Jordán, aríñagueina joun gürígia luágu lúnti lan jaságürijan luágu jafígoun, sáansi jameíme jagáburi lun ferúdunawa lan jafígoun, badísei jagíame. ");
INSERT INTO cabNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Suséreti cátei le ítara queí meja labǘrüdüni proféta Isaías, laríñaga. Agaambúati lumálali ában agúarajati lídan fulásu mageírawati ítara. “Aráanseja jumoún janígi lubá liábin Wabúreme, queísi ladárarúniwa ǘma surúti. ");
INSERT INTO cabNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Labuínchagüdǘwaba sun gudúungu, sun wǘbü, lagurúaba, ǘma buri le segéti, lásururuba, ǘma buri le múaragunti, lúwaradaguba. ");
INSERT INTO cabNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Larijúbei sun uboú Wasálbaragüle, le loúnajabei Búngiu woun.” ");
INSERT INTO cabNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ñǘbintiña sarágu gürígia lun Juan lun labásteragüdǘniña, ába laríñaga joun. —¡Jarásan jéwe jugúya le! ¿Ca awísarubalün lun jeíbaagun lueí lanárime lafáyeiragüle figoú le yaráfaalibei? ");
INSERT INTO cabNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ígira jumeí binádu jigáburi, abágarida jumá lun gayára lan larijín buídu luágu sáansiguaali lan jigáburi. Maríñaga jumá jídaangua. “Linébaanfaangu Abrahám wagía”, ladǘga quei naríñaguni jun, gayáraati ladǘgün Búngiu linébaanfaangu Abrahám lídaangiñe buri dǘbü le. ");
INSERT INTO cabNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yaráfaali dan lun jafáyeijan luágu jifígoun queísi taráanserún jaráwa lun tánchuguni tídibu wéwe. Sun ídibu le mabuídunti lin lánchugúba, ábame lagudún. ");
INSERT INTO cabNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ábati jaríñagun gürígia jagía lun. —¿Cáteiti lúnbei wadǘgüni? ");
INSERT INTO cabNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ába laríñagun Juan joun. —Le biámabei isímisin, lúnti líchugun ában lun le úaboun ni ában lúma, le geíginbei, lúnti lafánreinraguni lúma le meíginbei. ");
INSERT INTO cabNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ñǘbintiña gíñe agúburajatiña liseínsuna gumádi lun jabásterun, ába jaríñagun lun. —Maésturu, ¿ca cátei lúnbei wadǘgüni? ");
INSERT INTO cabNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Laríñaga Juan joun. —Magúburaja jumá loúgiñe le uágubei laríñaga lúrudu. ");
INSERT INTO cabNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aríñagatiña gíñe fiú súdaara lun. —Ángi wagía, ¿cági lúnbei wadǘgüni? Laríñaga joun. —Magídara jumá ni cáta ni ca ueí, ni láu siádi, ni láu jíchugun lidúnrun mútu le madǘgün lumúti, gufúruma jumá láu jafáyeiruaja. ");
INSERT INTO cabNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Añájati gürígia madéraguagüdünja arítagua luágu fágua lan Juan Crístubei, ");
INSERT INTO cabNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ába laríñagun Juan joun súngubei. —Áu, láu dúna nabásteragüdaün, nítenbei ában le lúnbei labásterágüdünün láu Sífiri Sándu lúma láu queísi wátu geméti, ligía Crístubei. Gabáfutimaati nueí darí lun madǘna nan ni lun nafáragaduni tagǘrüga ligeídin. ");
INSERT INTO cabNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Dánme liábin, jafánreinrúaba gürígia ja lánigubaña jádaangiñe ja wuríbabaña queísigubeirügü lagídarúniwa ífei lídaangiñe türígu buíti, ába loúndarún türígu buíti tídoun lágei, ába lagudún ífei lídan wátu geméti le méñeguchati. ");
INSERT INTO cabNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Láu igáburi le lúma láu buri ámu ewéridijani líchigei Juan ugánu buíti joun gürígia luágu wasálbaragüle. ");
INSERT INTO cabNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Erérati gíñe lun gumándan Heródes luágu laganoún túma Heródias, to lúmari Felípe, le lamúlen, lúma luágu ámu buri cátei wuríbati le ladǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Lubáragiñe ladǘgün Heródes gásu láu, adǘgarügü ligía ában cátei wuríbatimaati. ládaruni Juan furísunrugun. ");
INSERT INTO cabNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Lubáragiñe ladaürǘniwa Juan, dan le labásteragüdüniña gürígia, badíseiti gíñe Jesúsu. Dánti le niján lan Jesúsu ayúmuragua lun Búngiu, ába lánjunrenchagun juánriñu, ");
INSERT INTO cabNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ába larijíniwa larárirun Sífiri Sándu luágun camá jamuga ában únjun, ába lagaambúniwa laríñagun ában umálali siélugiñe. —Amǘrü Niraǘ le jínsiñebei nun, gúndaatina báu. ");
INSERT INTO cabNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Queí burí darándi irúmu láu Jesúsu dan le lagúmeserunbalin luwádigimari le uágubei loúnajei Búngiu. Jarítawagúati luágu liraǘ lan José, José, liraǘ Elí, ");
INSERT INTO cabNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí, liraǘ Matát, Matát, liraǘ Leví, Leví, liraǘ Melquí, Melquí, liraǘ Jána, Jána, liraǘ José, ");
INSERT INTO cabNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José, liraǘ Matatías, Matatías, liraǘ Amós, Amós, liraǘ Nahúm, Nahúm, liraǘ Eslí, Eslí, liraǘ Nagaí, ");
INSERT INTO cabNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaí, liraǘ Maat, Maat, liraǘ Matatías, Matatías, liraǘ Semeí, Semeí, liraǘ José, José, liraǘ Judá, ");
INSERT INTO cabNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá, liraǘ Joána, Joána, liraǘ Résa, Résa, liraǘ Zorobabél, Zorobabél, liraǘ Salatiél, Salatiél, liraǘ Néri, ");
INSERT INTO cabNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Néri, liraǘ Melquí, Melquí, liraǘ Adí, Adí, liraǘ Cosám, Cosám, liraǘ Elmodám, Elmodám, liraǘ Er, ");
INSERT INTO cabNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er, liraǘ Josué, Josué, liraǘ Eliézer, Eliézer, liraǘ Jorím, Jorím, liraǘ Matát, ");
INSERT INTO cabNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matát, liraǘ Leví, Leví, liraǘ Simeón, Simeón, liraǘ Judá, Judá, liraǘ José, José, liraǘ Jonán, Jonán, liraǘ Eliaquím, ");
INSERT INTO cabNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquím, liraǘ Meléa, Meléa, liraǘ Mainán, Mainán, liraǘ Matáta, Matáta, liraǘ Natán, ");
INSERT INTO cabNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán, liraǘ Davíd, Davíd, liraǘ Isaí, Isaí, liraǘ Obéd, Obéd, liraǘ Booz, Booz, liraǘ Salmón, Salmón, liraǘ Naasón, ");
INSERT INTO cabNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón, liraǘ Aminadáb, Aminadáb, liraǘ Arám, Arám, liraǘ Esróm, Esróm, liraǘ Fáres, Fáres, liraǘ Judá, ");
INSERT INTO cabNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá, liraǘ Jacób, Jacób, liraǘ Isáac, Isáac, liraǘ Abrahám, Abrahám, liraǘ Taré, Taré, liraǘ Nacór, ");
INSERT INTO cabNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacór, liraǘ Serúg, Serúg, liraǘ Ragáu, Ragáu, liraǘ Pelég, Pelég, liraǘ Héber, Héber, liraǘ Sála, ");
INSERT INTO cabNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sála, liraǘ Cainán, Cainán, liraǘ Arfaxád, Arfaxád, liraǘ Sem, Sem, liraǘ Noé, Noé, liraǘ Laméc, ");
INSERT INTO cabNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Laméc, liraǘ Matusalén, Matusalén, liraǘ Enóc, Enóc, liraǘ Jaréd, Jaréd, liraǘ Mahalaléel, Mahalaléel, liraǘ Cainán, ");
INSERT INTO cabNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán, liraǘ Enós, Enós, liraǘ Set, Set, liraǘ Adán, Adán, liraǘ Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ába lígiruni Jesúsu fulásu loúbawagu dúna Jordán, buin láu lubáfu Sífiri Sándu, ába lanǘgüni Sífiri Sándu lídoun fulásu mageírawati. ");
INSERT INTO cabNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Reídeiti Jesúsu bián-wein wéyu ñi láu Máfia oúchaguei ánjein áburuja lídoun wuríbani. Meíginti ni cáta lídan sun bián-wein wéyu ligía, ába lasándirun ában oúnwenbun ilámaü. ");
INSERT INTO cabNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ábati laríñagun Máfia lun. —Ánjein Liraǘ bubei Búngiu, salíguagüdabeí dǘbü le feínme. ");
INSERT INTO cabNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Laríñaga Jesúsu lun. —Taríñajare Lerérun Búngiu. “Mámarügüba táu fein jabágarida gürígia, jabágariduba gíñe láu jagúnfulirun láu sun dimúrei le laríñagubei Búngiu.” ");
INSERT INTO cabNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Lárigiñe, ába lanǘgüni Máfia Jesúsu luágun ában wǘbü íñuti, ába larúfuduni sun fulásu le uboúagubei lun lídan ában. ");
INSERT INTO cabNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ába laríñagun Máfia lun. —Níchugubei sun ubáfu lúma sun uweíriguni le bun ");
INSERT INTO cabNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ánjabu ájuduragua nun lun banǘgünina quei bubúngiute, bánibei súngubei, ladǘga ibíja náali sun le, áni gayáraati níchuguni lun le únti nabúseera. ");
INSERT INTO cabNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ába laríñagun Jesúsu lun. —Dísebá nueí, Máfia, ladǘga taríñajare Lerérun Búngiu. “Judúguabá lun Búngiu le Babúreme, lúnrügülá besériwida.” ");
INSERT INTO cabNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Lárigiñe, ába lanǘgüni Máfia ubúrugun Jerusalén, ába laweínragüdüni tábulugu témpulu, ába laríñagun lun. —Ánjein Liraǘ bubei Búngiu, chǘguabá búngua yágiñe lun ǘnabun, ");
INSERT INTO cabNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ladǘga taríñajare Lerérun Búngiu. Loúnajabaña Búngiu láni ánjeligu lun joúnigiruníbu, ");
INSERT INTO cabNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","janǘgübadibu jájaburugu lueí labúleiseirun bugúdi luágu dǘbü. ");
INSERT INTO cabNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ába laríñagun Jesúsu lun. —Taríñajare gíñe Lerérun Búngiu. “Moúchaguabeí Búngiu le Babúreme.” ");
INSERT INTO cabNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Dánti le madárijali Máfia cába lan luwúyeri oúchawagúni ladǘga lun Jesúsu, ába lígiruni lúngua luágu átiri dan. ");
INSERT INTO cabNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ába lagíribudun Jesúsu Galiléoun buin láu lubáfu Sífiri Sándu, ába buríti ladímurejoún luágu lídan sun fulásu geyégua. ");
INSERT INTO cabNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Arúfudajatija tídan jalígilisin juríu lídan sun fulásu, buíti jadímurejan sun gürígia luágu. ");
INSERT INTO cabNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ábati lídin Jesúsu Nazarétün, le fulásu le ñí lubei lagǘriajoúa, ába lebélurun tídoun jalígilisin juríu lídan wéyu le eméraaguagülei quei ligáburi yebu, ába laráramun lun lalíijan tídan Lerérun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ába jíchugunun lilíburun proféta Isaías lun, dan le ladárarunun, ába ladáriruni le ñí lubei laríñaga ítara. ");
INSERT INTO cabNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Níjein láni Búngiu Sífiri Sándu nuágu, ladǘga anúadaja láadina lun níchuguni ugánu buíti joun gudémetiña, oúnaja láadina lun námalijaniña ja nidíjeribaña tídan janígi, lun náfuridagüdüniña adaürǘtiña, lun níchugun aríjini joun maríjintiña, lun neséfuruniña ja ouserúabaña wuríba, ");
INSERT INTO cabNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","lun nadímurejan luágu dan le fuleíseijabu lan Búngiu joun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ába ladáurunun Jesúsu líburu, ába líchugunun lun ídejati tánina ligílisi, ába lañúurun. Queíti jasígirun sun ja ñíbaña aríaguei, ");
INSERT INTO cabNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ába lagúmeserun adímureja, laríñaga. —Ugúñe guánarü gúnfulijali cátei le jigíbugiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Adímurejatiña sun jagía buíti luágu Jesúsu, weírititi janígi luágu lubuídun buri dimúrei le laríñagubei. Jálügüdagua buríti jámagua. —¿Mámasan le liraǘ José le? ");
INSERT INTO cabNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ába laríñagun Jesúsu joun. —Subúsiti nun luágu jaríñagubei lan cátei le nun. “Surúsia, agáraniguabá búngua”, jaríñaguba giñe nun. “Agáambaadiwa luágu buri cátei le adǘga báalibei Capernaúm, adǘgabeí gíñe ya bageíra.” ");
INSERT INTO cabNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ába lasígirun adímureja, laríñaga. —Ninárün jáu luágu úa lan ni ában proféta erésibirúati buídu lageíra. ");
INSERT INTO cabNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Choúru numúti luágu añájein lán meja sarágu würíña ja jiláguañábaña jámarigu jádan Israelítagu lídan meja lidáani proféta Elías, dan le májuyun lubeí júya luágu ǘrüwa irúmu dimí, ába ñi lan sarágu ilámaü fulásurugu, ");
INSERT INTO cabNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","áni moúnajan lumúti Búngiu Elías túmoun ni ában jádaangiñe würíña jiláguaaña jámarigu jagía ja aganoúbaña Israél, loúnajei túmoun ában to aganoúboun Sarépta, yaráfa lun ubúrugu Sidón. ");
INSERT INTO cabNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ñíñanu meja gíñe sarágu gawágutiña gumeín luágu jára ñi Israél lídan lidáani proféta Eliséo, úati ni ában jádaangiñe areídawaguagüdüti lueídügüya Naamán le Síriana. ");
INSERT INTO cabNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Dan le jagáambunbalin sun ja ñíbaña ligílisirugu cátei le, ába jagáñidun sarágu. ");
INSERT INTO cabNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ába jásaarun, ába jaságaruni Jesúsu bougudín lueí fulásu, ába janǘgüni lábulugun wǘbü le gagíbuagubalin fulásu lun jájuchuruni ñígiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ába lásügürün Jesúsu jamídaanguágiñe jámagua, ába lídin. ");
INSERT INTO cabNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ábati lídin Jesúsu Capernaúm, ában fulásu le lídaanbei Galiléa, ába larúfudajan joun gürígia ñi lídan wéyu le eméraaguagülei. ");
INSERT INTO cabNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Weírititi janígi láu ligáburi larúfudajan, ladǘga láu ubáfu ladímureja. ");
INSERT INTO cabNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ñíñeinti ában wügǘri ligílisirugu, gawáguti espíritu wuríbati, ába lagúaragun ítara. ");
INSERT INTO cabNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Ígira báwa, ¿ca uágu bemétera wámoun, Jesúsu le Nazarétna? ¿Biábiña agǘnrinchaguawa? Subúdi numútibu, áni subúdi numúti luágu amǘrü lan Liraǘ Búngiu le sándubei. ");
INSERT INTO cabNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ába ladeínjan Jesúsu lun espíritu wuríbati ligía, ába laríñagun lun. —¡Maníba, furíba lídaangiñe gürígia le! Ábati lájuchuruni espíritu wuríbati wügǘri ligía múarugun jagíbugiñe súngubei, ába láfuridun lídaangiñe, mabúleiseirunga. ");
INSERT INTO cabNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ába laweíridun janígi súngubei, ába jaríñagun jámagua. —¿Cáteisán buri dimúrei le? ¡Adímurejati wügǘri le láu gumádi lúma ubáfu joun espíritugu wuríbatiña, ába jáfuridun! ");
INSERT INTO cabNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Adímurejoúatiti buri luágu Jesúsu lídan sun fulásu geyégua. ");
INSERT INTO cabNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ábati láfuridun Jesúsu tídaangiñe jalígilisin juríu, ába lídan lúbiñoun Simón. Sándiñounti límenidi Simón, tabíruajaña, ába jayúmuragun lun Jesúsu lun lareídaguagüdünun. ");
INSERT INTO cabNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ába lélemuchun Jesúsu tuágun, ába ladeínjan lun abíruaü, ába lagídarun abíruaü tueí. Lídan méme óra ligía ába tásaarun, ába tagúmeserun eténira joun. ");
INSERT INTO cabNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sun ja añájeinbaña sánditiña jábiñe, dan le láfuachun wéyu ába janǘgüniña lun Jesúsu, ába líchuguni lújabu jawágu cáda ában jádaangiñe, ába lareídagun furúmieguarügü sándi le jawáguti. ");
INSERT INTO cabNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sarágu jaña gíñe ja gawágutiña espíritugu wuríbatiña, ába jagídarúniwa jaweí, ába buri jagúaragun ítara. —Amǘrü le Liraǘbei Búngiu. Ába ladeínjan Jesúsu joun espíritugu wuríbatiña, mígirun lumútiña lun jadímurejan, ladǘga subúdi jamúti luágu ligía lan Crístubei. ");
INSERT INTO cabNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Dan le larúgadunbei, ába láfuridun Jesúsu bougudín lueí ubúrugu lídoun ában fulásu mageírawati. Ába jáluajani gürígia, ába jachǘlürün le ñíjin lubeí, buséntiña yebe jeréderuni lueí lídin, ");
INSERT INTO cabNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ába laríñagun joun. —Gásu gíñe níchuguni ugánu le luáguti larúeijan Búngiu joun lílana líbiri fulásu, ladǘga lun líra noúnajoúa. ");
INSERT INTO cabNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ítara líña lídin apúrichijeina tídan buri jalígilisin juríu, Galiléa. ");
INSERT INTO cabNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Luágu ában dan, ñíñein Jesúsu láru dúna le Genesarét, ábati jayábingua sarágu gürígia darí lun jámurudaguni, ladǘga busén jamá jagáambuni lerérun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ába laríjin Jesúsu bián ugúnein málatu dúnarugu yaráfa lun láru béya, raríguaaña esénijatiña tídaangiñe, jachíbuñounti jasénin. ");
INSERT INTO cabNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ábati ládinun Jesúsu tídoun ában tídaangiñe ugúnein tugúya to lugúneboun Simón, ába laríñagun lun lun ladísedun murúsun lueí láru béya. Ábati lañúurun Jesúsu tídan ugúnein, ába lagúmeserun arúfudaja joun gürígia ñígiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Dan le lásurunbei ladímurejan, ába laríñagun lun Simón. —Jeíba méme anágün, ábame jágurun ñi. ");
INSERT INTO cabNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Laríñaga Simón lun. —Maésturu, ñadímeinjadiwa sun áriebu, mañúguntiwa ni cáta, quei amǘrü lubeí aríñagubalin, wágura. ");
INSERT INTO cabNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ába jágurun, dan le jiñúragunbárun séni, ñíñanu sarágu úduraü tídan darí yebe lun tajeíridagun. ");
INSERT INTO cabNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ábati jadǘgün seíni joun jíbirigu ja tídaanbaña to ában ugúnein lun jayábin íderaguaña. Ába jayábin, ába jabuínchagüdünun biángubei ugúnein darí yebe lun tadíbiragun. ");
INSERT INTO cabNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Dan le laríjini Simón Pédro cátei le, ába lájuduragun ligíbugiñe Jesúsu, ába laríñagun lun. —Ígira bána, Nabúreme, ladǘga ában wügǘri gafígounti nugúya. ");
INSERT INTO cabNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Laríñagubaalin Simón líra ladǘga laweíridun lanígi, jáu sun ja úarabaña lúma, luágu añúguni le jadǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Weíriti gíñe janígi Jacóbo lúma Juan, ja lirájüñü Zebedéo, ja lúmabaña Simón. Ába laríñagun Jesúsu lun Simón. —Manúfudebá, lúmagiñe guetó buwádigimarida adíaja gürígia nun. ");
INSERT INTO cabNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Lárigiñeti játürün, ába jígiruni sun cátei, ába joúdin lúma Jesúsu lun láni jamá disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Luágu ában dan, lídaañein ában fulásu Jesúsu, le ñí lubei ában wügǘri gawáguti gumeín luágu sun lúra. Dan le laríjinbalin wügǘri ligía Jesúsu, ába lájuduragun dagá ligíbu múarugun, ába layúmuragun lun ítara. —Nabúreme, ánjabu busén, gayáraati bareídaguágüdünina. ");
INSERT INTO cabNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ábati lagúruruni Jesúsu láu lújabu, ába laríñagun. —Buséntina, areídaguabá. Quei laríñagun ítara, ába lagídarun gumeín lueí wügǘri ligía, ");
INSERT INTO cabNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ábati laríñagun Jesúsu lun lun mabájüdagun láani cátei le ni ca un. Laríñaga lun. —Ñǘdünrügübá, arúfudagua búngua lun fádiri, rúbeíme edéweejani le uágubei laríñaga lilúrudun Moisés luágu barúmadun, aríja jamámugei gürígia luágu areídaguaadibu lan. ");
INSERT INTO cabNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Eíbu dan, eíbu labúruchaguntima luágu Jesúsu, sarágu jañátija gürígia oúndaragutiña lun jagáambuni lúma lun lareídaguágüdüni jasándi. ");
INSERT INTO cabNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ábaja lídin Jesúsu le ñíjin lumúti úa jamá gürígia lun layúmuragun lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Luágu ában wéyu, ñíñein Jesúsu arúfudaja, ñíñanuti fariséogu jáma arúfudajatiña lilúrudun Moisés, ñǘbintiña lídaangiñe lirájüñü buri fulásu le láni Galiléa, Judéa lúma Jerusalén. Nijánti lubáfu Búngiu arijúa luágu Jesúsu láu lareídaguagüdüniña sánditiña. ");
INSERT INTO cabNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ábati jayábin fiú wügǘriña barǘina ában wügǘri fadáguaali tídan ában ubárari, jálugati jebélaagüdüni le ñíjin lubeí Jesúsu lun laríjini. ");
INSERT INTO cabNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Madáritiña jalíagiñeba lan jebélura ladǘga jíbe gürígia, ábati jaweínrun tábulugun múna, ába jagídarun murúsun lueígiñe loúgiñe le ñí lubei Jesúsu, ába jarárigüdüni sánditi tídan lubárari ligíbugiñoun. ");
INSERT INTO cabNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Dan le laríjinbalin Jesúsu afíñeni le jawágubei, ába laríñagun lun sánditi ligía. —Wügǘri, ferúdunawaali bifígoun. ");
INSERT INTO cabNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ábati jaríñagun arúfudajatiña lilúrudun Moisés jáma fariséogu joúnguarügü. —¿Cáteisan gürígia le, le minébenejabubei lun Búngiu láu ligáburi ladímurejan? Úati ámu gayáraati ferúduna lan figoú lueídügüya Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Subúdi lumúti Jesúsu ca lan jasáminabei, ába laríñagun joun. —¿Ca uágu jasáminara ítara? ");
INSERT INTO cabNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Cátima méreengúnbei laríñawagun. “Ferúdunawaali bifígoun”, ódi “Sarába, beíbuga”? ");
INSERT INTO cabNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Narúfudaaliti jun luágu gayára lan ferúduna nan figoú, áu le Wügǘri Garaǘwarügüti. Ábati laríñagun lun le sándibei. —Sarába, barǘboun bubárari, beíba búbiñoun. ");
INSERT INTO cabNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lídan óra ligía, ába lásaarun sánditi ligía jagíbugiñe, ába labúdunun lubárari tó buga ídaanboun laroúnra, ába lídin lúbiñoun adímurejeina luágu luweírigun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ába laweíridun janígi súngubei, ába jadímurejan luágu luweírigun Búngiu, ába jaríñagun láu luweírin janígi. —Aríjaadiwa cátei weíriguti ugúñe. ");
INSERT INTO cabNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Lárigiñe cátei le, ába láfuridun Jesúsu lídaangiñe fulásu ligía, ába laríjin ában agúburajati liseínsuna gumádi, gíriti Leví, ñun líña lídan fulásu le ñí lubei lagúburaja, ába laríñagun Jesúsu lun. —Falábana, queímoun núma queísi náni disípulu. ");
INSERT INTO cabNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ába lásaarun Leví, ába lígiruni sun cátei lánina binádu libágari, ába lídin lúma Jesúsu queísi láni disípulu lúmagiñe óra ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lárigiñe, ába ladǘgün Leví ában oúnwenbun fédu lun Jesúsu, lúbiñe, ñíñanuti sarágu agúburajatiña liseínsuna gumádi jámaya ámu gürígia ñun luágu dábula jáma. ");
INSERT INTO cabNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ába jagúmeserun fariséogu jáma arúfudajatiña lilúrudun Moisés adímureja luágu Jesúsu jáma láni disípulugu, ába jaríñagun joun. —¿Cásan uágu jeíginbei jáma agúburajatiña liseínsuna gumádi lúma jáma ámu gafígountiña? ");
INSERT INTO cabNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Laríñaga Jesúsu joun. —Ja magádiebaña, memégeirúntiña surúsia, aná ja sándibaña. ");
INSERT INTO cabNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Máma niábiña áluaja magádietiña ligíbugiñe Búngiu, niábiña áluaja gafígountiña lun lasáansirún joúserun. ");
INSERT INTO cabNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ábati jaríñagun lun Jesúsu. —¿Ída liñásan ayúnara jabeí lánigu Juan jáma fariséogu, ayúmuragua jagía sarágu lun Búngiu, ánjaña báni disípulugu, joútiña, gurá jagía súnwandan? ");
INSERT INTO cabNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ába laríñagun Jesúsu joun. —¿Gayáraati funági jayúnaragüdüniña gürígia ja jamísurajan lídoun ában maríei sun niján lan adári jáma ñi? ");
INSERT INTO cabNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lachǘlürüba dan lun lídin adári, ligíameti jayúnarun. ");
INSERT INTO cabNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Rúti gíñe Jesúsu ában jémpulu joun luágu iséri larúfudajan lúma binádu, laríñaga. —Úati íbuguti murúsun gamísa tueígiñe ában anáanguni isérigiru lun láfadajan ában anáanguni ñulújaru, ánjein ladǘga ítara, lagádeiruboun to isérigiruboun, áni merédebei gíñe murúsun gamísa iséri ligía buídu tuágu anáanguni ñulújaru tugúya. ");
INSERT INTO cabNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Michugúntu gíñe diweín iséri lídoun guéru ñulújali, ánjein adügǘwa ítara, tajeíridagubei diweín iséri guéru ñulújali, féridiméti diweín, féridi guéru. ");
INSERT INTO cabNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ligía lúnti lubeí tíchugún diweín iséri lídoun guéru iséri, ítara lúba lesériwidun guéru, seríwi diweín. ");
INSERT INTO cabNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Úati gíñe átuti diweín to binádu lun labúseerunun to iséri lárigiñe, laríñaguba. “Buítimaatu to binádu.” ");
INSERT INTO cabNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Luágu ában wéyu le eméraaguagülei, eíbugeina líña Jesúsu labádinagua nádü jáma láni disípulugu, átüjeina jagíati disípulugu lin türígu, ába jéferejani láu jájabu, ába jeígini líla. ");
INSERT INTO cabNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ábati jaríñagun jádaangiñe fariséogu joun. —¿Cásan uágu jadǘga wadágimanu le moún lumuti ladügǘn lídan wéyu le eméraaguagülei? ");
INSERT INTO cabNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Laríñaga Jesúsu joun. —¿Malíijangidün luágu le ladǘgübei Davíd luágu ában dan, dan le lalámachunbei jáu sun ja úarabaña lúma? ");
INSERT INTO cabNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ába lebélurun tídoun lúban Búngiu, ába lanǘgün tídaangiñe fein to sagráuboun, jou ligía tídaangiñe, ru ligía joun ja úarabaña lúma, láu sun fádirigu rügǘñanu lán yebe lúnbaña jeígin tídaangiñe fein tugúya, según lilúrudun Moisés, áni máma figoú le ladǘgübei Davíd ligíbugiñe Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Aríñagati gíñe joun. —Gabáfutina, áu le Wügǘri Garaǘwarügüti, lun naríñagun cába lan gayára ladügǘniwa wéyu le eméraaguagülei. ");
INSERT INTO cabNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lídaanya ában wéyu le eméraaguagülei, ába lebélurun Jesúsu tídoun jalígilisin juríu, ába lagúmeserun arúfudaja. Ñíñein ában wügǘri jiláali lújabu le loúnwenren, ");
INSERT INTO cabNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","añájati arúfudajatiña lilúrudun Moisés jáma fariséogu aríaajei Jesúsu ánjein lagáranijaba lubeí lun lídan wéyu le eméraaguagülei, lun jadárirun lidúnrun. ");
INSERT INTO cabNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Subúdi lumúti ca lan jarítagubei, ába laríñagun lun wügǘri le jiláalibei újabu. —Sarába, ráramabá wagíbugiñe. Ába lásaarun, ába laráramun ñi. ");
INSERT INTO cabNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ábati laríñagun Jesúsu joun jíbiri. —Nálügüdaadün ában cátei. ¿Ca cátei gayáraabei ladügǘn lídan wéyu le eméraaguagülei, buídu ódi wuríbani, lasálbarun ibágari ódi lagídarún? ");
INSERT INTO cabNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ábati laríaguniña Jesúsu sun ja geyégubaña láu, ába laríñagun lun wügǘri ligía. —Tulébei bújabu. Ába látuleruni, ába lareídagun. ");
INSERT INTO cabNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ja jíbiri, ába jagáñidun sarágu, ába jagúmeserun álügüdagua jámagua ída lúba lan gayára lan jagúmuchun láu Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lídoun dan ligía, ába lídin Jesúsu luágun ában wǘbü ayúmuragua lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Dan le larúgadunbei, ába lagúarun joun láni disípulugu, ába lanúadajan dúusu jádaangiñe, ja únbaña lagúara apóstolugu. ");
INSERT INTO cabNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Niján jíribei. Simón, le méme líchubei Pédro, Andrés, le lamúlen Simón, Jacóbo lúma Juan, Felípe lúma Bartolomé, ");
INSERT INTO cabNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matéo lúma Tomás, Jacóbo, le liraǘ Alféo, Simón, le áfaaguti lun jawáanserun juríu, ");
INSERT INTO cabNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Júdas, le lamúlen Jacóbo, lúma Júdas Iscarióte, le alúgurubalin Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ába larárirun Jesúsu jáu lueígiñe wǘbü, ába leréderagun jáu láni disípulugu lídan ában fulásu le ñí lumuti sagádi wásati, ñíñanu gíñe sarágu gürígia ñǘbintiña loúbawagugiñe Judéa, Jerusalén, lúma lárurugugiñe Tíro lúma Sidón. Sun gürígia ja, jayábiña lun jagáambuni lapúrichijan Jesúsu lúma lun lareídaguagüdüni jasándi. ");
INSERT INTO cabNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Já buri asúfurirubaña jáu espíritugu wuríbatiña, areídaguátiña gíñe. ");
INSERT INTO cabNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Álugatiña sun gürígia jagúrurun luágu Jesúsu, ladǘga areídaguagüda lumútiña súngubei láu lubáfu. ");
INSERT INTO cabNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ábati laríjin Jesúsu jawágun láni disípulugu, ába laríñagun joun. —Fuleíseiwatün, jugúya le mégeibei, ladǘga ménreengúnbei jun lun jebélurun lídoun larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","‘Fuleíseiwatün, jugúya le áfaagubei ilámaü guetó, ladǘga jaquímuleduba. ‘Fuleíseiwatün, jugúya le ayájubei guetó, jéjerajaba lárigiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","‘Fuleíseiwatün dan le iyéreegu jumá joun gürígia nueígiñe, dan le jabúgagunün jawáriua, dan le janábagunün, dan le janǘgüni jíri queí ni cáta, quei cátei wuríbati, nueígiñe, áu le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gúnda jumá sarágu, buin jumá láu ugúndani lídan wéyu ligía, ladǘga jibíjuba ában oúnwenbun afáyeiruajaü siélu, ítara méme líña meja jadǘga binádu jagǘbürigu gürígia ja joun profétagu. ");
INSERT INTO cabNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‘Fugiábugu jugúya, jugúya le rísibei, ladǘga ibíja jumáali sun ugúndani le lúnbei jibíjini. ");
INSERT INTO cabNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","‘Fugiábugu jugúya, jugúya le químulebei, ladǘga jalámachuba. ‘Fugiábugu jugúya le éjerajabei guetó, ladǘga jayájuajaba láu íruni. ");
INSERT INTO cabNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","‘Fugiábugu jugúya dan le sun jamá gürígia adímureja buíti juágu, ítara liñá meja jadímurejan binádu jagǘbürigu buíti jawágu profétagu yéetiña. ");
INSERT INTO cabNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‘Niján nerérun jun, Jugúya le agáambubalina. Jínsiñe jamá jáganiñu jun, adǘga jumá buíti joun ja iyéreejabúbaña jun, ");
INSERT INTO cabNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","biní jumaña ja íñaragutün, ayúmuragua jumá jawágu ja anábagutün. ");
INSERT INTO cabNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ánjabu láfara ában gürígia luágu ában loúba bigíbu, rúbei gíñe le ában loúba lun, le anǘgütu babíte bueí, rúboun gíñe bisímisin lun. ");
INSERT INTO cabNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Furúmieguarügü le amúriajati búma, rúba lun, le anǘgüti bumégen, máluajabeí lúma. ");
INSERT INTO cabNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Le cátei le babúseerubei ladügǘn bun, ligíalá badǘga joun ámu. ");
INSERT INTO cabNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","‘Ánjein já rügǘñanu lubeí jínsiñejabúbaña jun jínsiñe jun, ¿ca buíti jadǘgübei láu líra? Ásta gafígountiña, ítara líña jadǘga. ");
INSERT INTO cabNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","O ánjaün lan adǘga buíti joúnrügü ja adǘgübaña buíti jun, ¿ca buíti jadǘgübei láu líra? Ítara líña gíñe jadǘgün gafígountiña. ");
INSERT INTO cabNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ánjaün afúredeija joúnrügü ja úmagiñebaña jarítagua jibíjin som cátei, ¿ca buíti jadǘgübei láu líra? Afúredeijatiña gíñe ja wuríbabaña joun wuríbatiña jáledi, agúrabañu jagía gíñe jabíjin som cátei jámagiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ánjein jugúya, lúnti jínsiñe jamá jáganiñu jun, adǘga jugúyame buíti, afúredeija jugúyame, magúrabajaanga ni cáta lewéñegua. Ítara lúba weíri lan jafáyeiruaja lúmagiñe Búngiu le íñugubei, áni lirájüñübadün gíñe le tímatimaati, ladǘga ligía, fuleíseijabúti gíñe joun ja meteíngiradibaña lúma joun ja wuríbabaña. ");
INSERT INTO cabNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gudémejabu jumá, quei gudémejabu lan júguchi Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‘Madímureja jumá wuríba jawágu ámu, ábame gíñe maríñagun lan Búngiu luágu wuríba lan jigáburi. Míchiga jumá jadúnrun ámu, míchun lámuga gíñe Búngiu jidúnrun. Ferúduna jumá, ferúduna lámugaün gíñe Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Rújuma joun ámu, ru lámuga gíñe Búngiu jun. Líchuguba Búngiu sarágu jun, ladǘgüba jun queígubeirügü jadǘga joun ámu. ");
INSERT INTO cabNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Rúlumuti Jesúsu jémpulu le joun. —¿Gayáraati funági ladúndejan ában maríjinti ában maríjinti líledi? ¿Ma jeíguaduba biángubei lídoun ában meme júyu? ");
INSERT INTO cabNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Úati ni ában disípulu weíriguti lueí lumáesturun, íbini ánjein lagúmucha latúriajan, chülǘrügübei quei lumáesturun. ");
INSERT INTO cabNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‘¿Ída líña gayára bubálin liraǘraü ífei le lídaanbei lágu bíbugaña aríja, áni masándi bumúti durúsu le lídaanbei bágu? ");
INSERT INTO cabNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Ída líña gayára lubeí baríñagun lun bíbugaña. “Sagánei liraǘraü ífei le bágurugubei”, áni masándi bumúti durúsu le bágurugubei? ¡Biánguañein bigíbu! Sagábei durúsu le bágurugubei furúmiñe, gayára lámuga baríjini liraǘraü ífei le lágurugubei bíbugaña buídu lun baságaruni. ");
INSERT INTO cabNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","‘Úati tídibu wéwe buíti lun wuríba lan lin, úati gíñe tídibu wéwe wuríbati lun buídu lan lin. ");
INSERT INTO cabNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sun tídibu wéwe subúdiwati luágu lin, mátüjoúntu ígo lueígiñe jíyu, ni beíbei lueígiñe guríbiyuwa. ");
INSERT INTO cabNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Gürígia le buídubei, cátei buíti laríñagubei ladǘga cátei lan buíti tídaanbei lanígi, gürígia le wuríbati, cátei wuríbati laríñagubei ladǘga cátei lan wuríbati tídaanbei lanígi. Luágu le laríñagubei gürígia lasúbudirúa ca lan tídaanbei lanígi. ");
INSERT INTO cabNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","‘¿Ca uágu jaríñaga luágu áu lan Jabúremebei áni madǘgün jumúti le nubeíbei? ");
INSERT INTO cabNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Naríñagaali jun ída líña lan le ñǘbinbei nun áni adǘgaleí le nubeíbei. ");
INSERT INTO cabNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ítara líña quei ában wügǘri le ábunagubei ában múna, achíajati julíli furúmiñe, ába lábununi wagábu labádinagua dǘbü derébuguti. Dan le liñúrunbei dúna, ába liábin fulúdu láu érei tuágun múna tugúya, siñá lumutu ánjingicha ladǘga luáguñoun lan ébuu derébuguti. ");
INSERT INTO cabNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ánjeinti le agáambubalina áni madǘgün lumúti le nubeíbei, ítara líña quei ában wügǘri le ábunagubei lúban ligíbuagu ságoun, mawágaburiga, dánti le liñúrunbei dúna, ába liábin fulúdu láu érei tuágun, ába teíguadun, ába tagǘnrinchagun le gumúti. ");
INSERT INTO cabNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Dan le lásurunbei ladímurejan Jesúsu joun gürígia, ába lídin Capernaúm. ");
INSERT INTO cabNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ñíñein ában gumándan Rómana ñi, láu ában lumúsun jínsiñeti lun sarágu, sándiñein músu ligía, yaráfa lun loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Dan le lagáambunbei gumándan ligía luágu Jesúsu, ába loúnajan fiú jádaangiñe wügǘriña weírigutiña lídan jafíñen juríu lun jayúmuragun lun Jesúsu lun lídin areídaguagüdei lumúsun. ");
INSERT INTO cabNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ába joúdin lúmoun Jesúsu, ába jagúmeserun ayúmuragua lun táu sun janígi, jaríñaga lun. —Buíti lun bíderaguni gumándan le, ");
INSERT INTO cabNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ladǘga jínsiñetiwa wagía juríu lun, ligía guánarügü ábunaguagüdübarun walígilisin. ");
INSERT INTO cabNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ábati lídin Jesúsu jáma, dan le yaráfaaña tun lúban gumándan ligía, ába loúnajan gumándan jádaangiñe lumádagu aríñaga lun Jesúsu. —Nabúreme, ítara líña gumándan lun manǘgün ban bubéresegun ñǘdün lúbiñe, luágu nege madǘna lan lun bebélurun lúbiñoun, ");
INSERT INTO cabNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ligía nege mídin lubeí lúngua álugabu. Rúrügübeí dimúrei, ábame lareídagun lumúsun. ");
INSERT INTO cabNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ladǘga ligía nege gíñe lábugiñeñein gumádi íñutimaati, áni añájein gíñe súdaara lábugiñe lagúmadijan. Dan lé nege laríñagun lun ában jádaangiñe lun lídin, ñǘdünti, dan le laríñagun lun le ában lun liábin, ñǘbinti, áni dan le loúnajani lumúsun adǘga som cátei, adǘga lumúti. Ítara lúba nege, luágu berérun mósu lídin sándi lueí lumúsun. ");
INSERT INTO cabNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Dan le lagáambunbalin Jesúsu cátei le, weíriti lanígi láu wügǘri ligía, ába laríjin jawágun gürígia ja afálarubalin, aba laríñagun joun. —Ninárün jáu, ni íbini jádan Israelítagu madárigidina afíñeni weíriti quei lafíñen wügǘri le. ");
INSERT INTO cabNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Dánti le jachǘlürünbei wügǘriña ja ñǘdünbaña álugei Jesúsu járigoún lúbiñoun gumándan, areídaguaali lumúsun. ");
INSERT INTO cabNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Lárigiñe cátei le, lídiña Jesúsu lídoun ában ubúrugu gíriti Naín, úareina jáña láni disípulugu lúma, jáma sarágu gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Dan le lachǘlürünbei yaráfa lun lubéneri ubúrugu ligía, ába laríjin joúdin ábunaja ában jiláali le ligíarügüti tiraǘ lúguchu to jiláali túmari. Sarágu jáña lílana fulásu ñǘdün ábunaja túma. ");
INSERT INTO cabNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dan le laríjinbarun Wabúreme Jesúsu, ába tagúdemedagun lun, ába laríñagun tun. —Mayájuabá. ");
INSERT INTO cabNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ába layárafadun, ába lagúrurunun gánjoun, ába jaráramagun ja anǘgübaña. Ába laríñagun lun jiláali. —Irájü, ¡naríñaguña bun lun básaarun! ");
INSERT INTO cabNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ábati lásaarun lé buga jiláalibei, ába lagúmeserun adímureja. Ába ledéregeruni Jesúsu tun lúguchu. ");
INSERT INTO cabNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dan le jaríjinbalin gürígia cátei le, ába laweíridun janígi, ába jagúmeserun adímureja buíti luágu Búngiu, jaríñaga. —Chülǘgua ában proféta weíriguti wádoun. Aríñagatiña gíñe. —Ñǘbinja Búngiu íderaguawa, wagía le lumútuniña. ");
INSERT INTO cabNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ába lagaambúniwa cátei le ladǘgübei Jesúsu lídan sun Judéa lúma geyégua láu. ");
INSERT INTO cabNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Agáambati Juan luágu sun cátei le, abájüdagua jamúti lánigu lun. Ábati lagúarun joun biáma jádaangiñe, ");
INSERT INTO cabNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ába loúnajaniña álügüdei Wabúreme Jesúsu ánjein ligía lubeí Crístubei le lúnbei liábin, o ánjein jagúrabajaba lubeí ámu. ");
INSERT INTO cabNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Dan le jachǘlürünbei le ñí lubei Jesúsu, ába jayárafadun, ába jaríñagun lun. —Loúnajañadiwa Juan le abásteragüdajabei álügüdabu ánjein amǘrü lubeí Crístubei le lúnbei liábin, o ánjein lun lubeí wagúrabun ámu. ");
INSERT INTO cabNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lídan méme óra ligía, areídaguagüdati Jesúsu sarágu gürígia lídaangiñe jasándi lúma jasúfurirun, lúma jádaangiñe espíritugu wuríbatiña, aríjagüda ligía gíñe sarágu maríjintiña. ");
INSERT INTO cabNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ába lubeíti laríñagun joun. —Jeíba, jaríñageime le jaríjubei lúma le jagáambubei lun Juan. Jabájüdaguáme lun luágu jaríjin maríjintiña, jeíbugun meíbuguntiña, jareídagun láutiña gumeín luágu jára, jagáambun magáambaditiña, jáguyugun jiláaña, lúma luágu líchugún ugánu luáguti asálbaruni joun gudémetiña. ");
INSERT INTO cabNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Gúndaati gíñe gürígia le meféridirun lumúti lafíñen nuágu. ");
INSERT INTO cabNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lárigiñe joúdin já buga loúnajabaña Juan, ába lagúmeserun Jesúsu adímureja luágu Juan joun gürígia, laríñaga. —¿Cásan jídinbei aríja lídan fulásu mageírawati? ¿Ában mabúru le lánjinjan garábali? ");
INSERT INTO cabNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ánjein máma lubeí ítara líña, ¿cáti jídinbei aríja? ¿Ában wügǘri táu anáanguni wéndegutu? Máma ligía, subúdi jumúti luágu ja lan wéndegubaña adáüragun, agánawa jagía buídu, tídaañanu jában urúeigu. ");
INSERT INTO cabNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lídan linárün cátei, ¿ca jídinbei aríja? ¿Ába proféta? Ánja, inárüni, áni ában weíriguti sügǘ láu proféta. ");
INSERT INTO cabNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan, ligía oúnagülei le uágubei taríñaga Lerérun Búngiu. Noúnajañein noúnagüle bubáragiñe lun laráansejani ǘma bubá. ");
INSERT INTO cabNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Quei naríñaguni jun, jádan sun gürígia, úagili proféta weíriguti lueí Juan, áni láu sun líra, weíriguti le ǘnabutimaabei lídan larúeijan Búngiu sügǘ láu le anǘgarügübalin ugánu luágu arúeijani ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Dan le jagáambunbalin sun gürígia, ásta ja agúburajabaña liseínsuna gumádi, cátei le, ába jaríñagun luágu richá lan Búngiu láu laríñagun liyúmulugugiñe Juan luágu lúnti lan jasáansiraguni jagáburi. Gürígia jagía, resíbi jamáali meja labásteragüdajan Juan, ");
INSERT INTO cabNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ánjañati jíbe-ágei fariséogu jáma arúfudajatiña lilúrudun Moisés, májatiña meja lun jadǘgüni le lubeíbei Juan, merésibirun jamúti lé yebe labúseerubei Búngiu ladǘgün luágu jafúleisein. ");
INSERT INTO cabNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ába laríñagun Jesúsu. —¿Ída liñásan jagáburi gürígia lánina dan le? ¿Cásan lenégebei? ");
INSERT INTO cabNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ítara jáña quei irájüñü ja añúurubaña mágidirugu ájurera, ába jagúaragun joun jíbegu. “Íñaajatiwa fídu jun, mabínajantün, erémujatiwa urému jíruti jun, mayájuntün.” ");
INSERT INTO cabNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ladǘga ñǘbinti Juan le abásteragüdajabei, lé meja meíginbei fein, mátun ligía diweín, aríñagatün luágu gawágu lan espíritu wuríbati. ");
INSERT INTO cabNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Lárigiñe, ába niábin, áu le Wügǘri Garaǘwarügüti, joútina áni gurá áu. Jaríñaga luágu geígadina, gátadi, jamáda áu nege gafígountiña jáma agúburajatiña liseínsuna gumádi. ");
INSERT INTO cabNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wel, ja chúbaña áu, subúdi jamúti luágu buídu lan le ladǘgübei Búngiu láu lichú láu. ");
INSERT INTO cabNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ába lamísurajani ában jádaangiñe fariséogu Jesúsu lun lídin eíga lúbiñe, ába lídin Jesúsu lúbiñe fariséo ligía, ába lañúurun eíga luágu lidábulan. ");
INSERT INTO cabNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ñíñounti ában wǘri wuríbati témeri lídan ubúrugu ligía, dan le tagáambunbei luágu lídin Jesúsu eíga lúbiñe fariséo ligía, ába tídin láu ában lágei ibíñei jémeti. ");
INSERT INTO cabNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ába taráramun lanágangiñe Jesúsu, lubádu lugúdi, ába tadǘdüragüdüni lugúdi láu táguira. Nuján ayájuaja, nuján arágajei láu tídiburi, nuján achújei lugúdi, ába téseruni ibíñei luágun. ");
INSERT INTO cabNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Dan le laríjinbalin fariséo le amísurajabalin Jesúsu cátei le, laríñaga lúnguarügü. “Lun jamúga inárüni lan luágu proféta lan wügǘri le, lasúbudiruñein jamúga ca lan to agúruruboun luágu lúma ca lan tuwúyeri gürígia tugúya, luágu wuríba lan témeri.” ");
INSERT INTO cabNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ábati laríñagun Jesúsu lun fariséo ligía. —Simón, níjein ában cátei lun naríñaguni bun. Laríñaga fariséo. —Aríñagabeí nun, maésturu. ");
INSERT INTO cabNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Laríñaga Jesúsu lun. —Níñanu bián wügǘriña dúweitiña seínsu lun ában afúredeijati. Ában jádaangiñe, dúweiti seíngü-san denáriu, le ában, dimí-san. ");
INSERT INTO cabNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Queíti siñá lubei jafáyeiruni, ába ferúduna láani afúredeijati ligía jadúweijan biángubei. Aríñagabeíti nun. ¿cábagi jádaangiñe jínsiñejabutima lun afúredeijati ligía? ");
INSERT INTO cabNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Laríñaga Simón lun. —Lídan narítagun, le gíbetimaabei adúweijan. Laríñaga Jesúsu lun. —Richátibu. ");
INSERT INTO cabNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ába laríjin Jesúsu tuágun wǘri tugúya, ába laríñagun lun Simón. —¿Aríagu bíña tun wǘri to? Belútina búbiñoun, míchutibu dúna nun lun nachíbuni nugúdi, ánjounti wǘri to, ágawagüda tumúti nugúdi láu táguira, ába tamábeidagüdüni láu tídiburi. ");
INSERT INTO cabNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Machú bumútina, ánjoun tugúya, lúmagiñe nebélurun, merédegili tachújani nugúdi. ");
INSERT INTO cabNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Míchutibu aíli nábulugu, ánjoun tugúya, túguatu ibíñei jémeti luágu nugúdi. ");
INSERT INTO cabNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ligía naríñagunbei bun luágu arúfuda láani luweírin tínsiñejabu luágu ferúdunawa lan líbe tifígoun, ánjeinti gürígia le míbeti ferúdunawa lan, míbeti ínsiñeni larúfudun. ");
INSERT INTO cabNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ábati laríñagun Jesúsu tun wǘri tugúya. —Ferúdunawaali bifígoun. ");
INSERT INTO cabNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ábati jagúmeserun amísurajoútiña ja ñúnbaña lúma ñi aríñaga jámagua. —¿Cáteisan wügǘri le, ferúduna lubeí gíñe figoú? ");
INSERT INTO cabNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ába laríñagun Jesúsu tun wǘri tugúya. —Sálbawádibu lídaangiñe bifígoun ladǘga bafíñerun nuágu, beíba darángilañu. ");
INSERT INTO cabNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lárigiñe cátei le, ñǘdünti Jesúsu lídoun sarágu ubúrugu lúma buri lirájüñü fulásu íchigei ugánu buíti luágu larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ñǘdütiña dúusu apóstolugu lúma jáma würíña ja lareídaguagüdübaña jádaangiñe espíritugu wuríbatiña lúma sándi. Ñíñoun María to gíriboun Magdaléna jádan, to ídaangiñeboun jáfurida sédü espíritugu wuríbatiña, ");
INSERT INTO cabNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ñíñoun gíñe Juána, to lúmari Chúza, le oúnigirubarun lúban Heródes, ñíñoun Susána, jámaya sarágu ámu ja íderagubálin láu le jámati. ");
INSERT INTO cabNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sarágu jáña gürígia ñǘbinburitiña lídaangiñe sarágu fulásu lun jaríjini Jesúsu, dánti le oúndaraguaaña, ába ladímurejan Jesúsu joun láu jémpulu. Laríñaga joun. ");
INSERT INTO cabNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Furíti ában ábunaguti ábunagua líla nádü, dan le afúrujeina láani, ába láburujan lídaangiñe luágun ǘma, ába jadǘgüraguni ásügürütiña, ába jeígini dunúru. ");
INSERT INTO cabNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Líbiri, ába láburujan labádinaguoún dǘbü, dánti le laboúchun, ába lásaürün ladǘga lumábei fulásu. ");
INSERT INTO cabNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ába láburujan líbiri labádinaguoún jíyu, ába láfaruni jíyu le ájüchübei úara lúma. ");
INSERT INTO cabNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ñíñein gíñe lídaangiñe, áburujati lídoun múa buíti, dan le laweínamudun, gin ligía, buíti lalúbajoún, cáda ílaü rúti san águu. Lárigiñe laríñaguni Jesúsu cátei le, ába laríñagun joun láu umálali jéreti. —Jugúya le garígeirugubei lun jagáambun, agáamba jumána. ");
INSERT INTO cabNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ábati jálügüdüni láni disípulugu ca lan lílabei jémpulu le. ");
INSERT INTO cabNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Laríñaga joun. —Jugúya, subúdigüda láali Búngiu cátei arámudaguati le luágutibei larúeijan jun, ánjaña ja mebéresenbaña láu lerérun, láu jémpulu laríñawagúa cátei luáguti larúeijan joun lun ibídiñebei lan líla cátei le jaríjibei joun, lun gíñe úa lan gunfaráanda jamáni cátei le jagáambubei. ");
INSERT INTO cabNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ába laríñagun Jesúsu joun. —Niján líla jémpulu ligía. Líla nádü, ligía lerérun Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ǘma le ñíjin lubeí láburuja lídaangiñe líla nádü, jagía gürígia ja agáambubalin lerérun Búngiu, ába liábin Máfia, ába lagídaruni tídaangiñe janígi lun mafíñerun jamá, masálbarun jagíame. ");
INSERT INTO cabNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Dǘbü le ñíjin lubeí láburuja líbiri líla nádü, jagía gürígia ja agáambubalin lerérun Búngiu, ába jerésibiruni láu ugúndani, áni márügüdünti jádan buídu, afíñetiña luágu murúsun dan, áni dan le joúchawagún, mawándun jamúti, ába jeféridiruni jafíñen luágu Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jíyu le ñíjin lubeí láburuja líbiri líla nádü, jagía gürígia ja agáambubalin lerérun Búngiu, ába jasígiruni binádu jagáburi, ába jasígirun arítagua luágu irísini lúma ugúndani le lánina uboú le, úati fulásu jarítagurugun lun lerérun Búngiu, siñátiti laságarún cátei buíti jádaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ánjeinti múa buíti le ñíjin lubeí láburuja líbiri líla nádü, jagía gürígia ja agáambubalin lerérun Búngiu táu anígi buítu, adǘga jagía gásu láu lerérun, eíbuga jagía quei lubúdubu, sagáwati cátei buíti jádaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ába laríñagun Jesúsu. —Úati gürígia ébeduti lámpu, ába ladáuragun láu láu som cátei o líchuguni lan tábugiñe gabána, íñu líchigei lun larúgoungadágüdün múnada, lun gayára lan jaríjin ja ebélurubaña jabárua. ");
INSERT INTO cabNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Úati lubeíti ni cáta arámudaguati lun mafúnraangudun lan, úa ni cáta le ibídiñewati lun machǘlürün lan dan lun lasúbudirúniwa lúma lun lafúnraangudun. ");
INSERT INTO cabNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","‘Gagáambadi jumá lubeíti buídu lun lerérun Búngiu, le gámati lerérun Búngiu tídan lanígi, libíjuba lánwoun le lúmabei, ánjeinti le úabei ni cáta lídaangiñe lerérun Búngiu tídan lanígi, íbini le uágubei larítagua luágu níjein lan lúma, lagídarúaba lueí. ");
INSERT INTO cabNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ábati tachǘlürün lúguchu Jesúsu jáma lamúlenu le ñíjin lubeí Jesúsu, siñáti jayárafadun lun ladǘga jíbe gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ába laríñawagún lun. —Nujántia búguchu jáma bamúlenu boúgudi áni buséntiña jaríjinibu. ");
INSERT INTO cabNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ába laríñagun joun. —Ja agáambubalin lerérun Búngiu, úara jagía lúma, jagía núguchubaña jáma namúlenu. ");
INSERT INTO cabNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Luágu ában wéyu, ába ládinun Jesúsu tídoun ában ugúnein jáu láni disípulugu, ába laríñagun joun. —Queímoun loubáfurugun lagúnu. Ába joúdin. ");
INSERT INTO cabNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dan le añája lan ánjiñuragua, ába larúmugun Jesúsu. Ába láfurun ában garábali jéreti jáu, lagúnurugu, ába lagúmeserun dúna ebéluja tídoun jagúne yaráfa lun jadíbiragun. ");
INSERT INTO cabNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ábati joúdin agágudajei Jesúsu, ába jaríñagun lun. —¡Maésturu! ¡Maésturu! ¡Wadíbiragua! Ábati lásaarun Jesúsu, ába ladeínjan lun garábali lúma lugúdi barána, ába lagálumougadun, ába darángila lan sun cátei. ");
INSERT INTO cabNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ábati laríñagun joun disípulugu. —¿Ca susérebei lun jafíñen? Ába jálügüdagun jámagua láu anúfudei lúma luweírin anígi, jaríñaga. —¿Cátei funásan wügǘri le, gumádi lubáli garábali lúma lugúdi barána áni agáamba jameí? ");
INSERT INTO cabNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ába jachǘlürün loúbawagun Gadára, le loubáfurugubei lagúnu, ligíbugiñe Galiléa. ");
INSERT INTO cabNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Dan le larárirunbei Jesúsu, ába liábin ában wügǘri lílana fulásu ligía lubádun. Lǘjali wügǘri ligía gawágu espíritugu wuríbatiña. Madáüti anáanguni, maganoún ligía tídan múna, lídan buri jabára jiláaña le achigíti luágu dǘbü lagánawa. ");
INSERT INTO cabNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Dan le laríjinbalin wügǘri ligía Jesúsu, ába lájuduragun ligíbugiñe, ába lagúaragun. —¿Ca uágu bemétera númoun, Jesúsu Liraǘ Búngiu le Íñugutimaabei? Ayúmuraguatina bun lun masúfuriragüdün bánina. ");
INSERT INTO cabNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Laríñagunbei ítara ladǘga lagúmadiruñein lan Jesúsu espíritu ligía lun láfuridun lídaangiñe. Saráguja weíyaasu lárügüdüni espíritu wuríbati ligía, ábaja jagǘraguni gürígia lújabu lúma lugúdi láu güríngüri lun ledéraguagüdün, ábaja látumuraguni, ába lanúragüdüni espíritu lídoun fulásu le mageírawati. ");
INSERT INTO cabNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ába laríñagun Jesúsu lun. —¿Ca bíri? Ába laríñagun. —Lejión níribei. Laríñagunbei luágu ligía lan líribei ladǘga gíbeeña espíritugu wuríbatiña ja ebélurubaña lídoun. ");
INSERT INTO cabNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ába jamúriajan espíritugu jagía lúma Jesúsu lun moúnajan lániña máfiougatin. ");
INSERT INTO cabNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Queíti ñíñanu jamá sarágu büíruju eíga luágu ában wǘbü yaráfa, ába jayúmuragun espíritugu jagía lun lun loúnajaniña jádoun büíruju jagía, ába lánjarun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ábati jáfuridun espíritugu wuríbatiña jagía lueí wügǘri ligía, ába jebélurun jádoun büíruju, ábati jáguragun büíruju jagía joúngua lueígiñe ában gudúungu, ába jáburujan lídoun lagúnu, ába jañáradagun. ");
INSERT INTO cabNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Dan le jaríjinbalin ja oúnigirubaliña büíruju cátei le asúseredubei, ába janúfudedagun, ába jeíbaagun abájüdaguei ubúrugu lúma áraabu. ");
INSERT INTO cabNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ábati joúdingua gürígia aríjei cátei le asúseredubei. Dan le jachǘlürünbei le ñí lubei Jesúsu, ába jadáriruni wügǘri le ídaangiñebei jáfurida espíritugu wuríbatiña ñun lubádu lugúdi Jesúsu, táu lanáangun, areídaguaali, ába janúfudedagun. ");
INSERT INTO cabNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Játi buga aríjubalin, ába jabájüdaguni luáguti lareídagun wügǘri lé buga gawágubei espíritugu wuríbatiña joun, ");
INSERT INTO cabNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ába jayúmuragun lílana fulásu ligía lun Jesúsu lun lídin ñígiñe, ladǘga janúfude. Ábati ládinun Jesúsu tídoun ugúnein lun lídin, ");
INSERT INTO cabNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ába layúmuragun wügǘri le ídaangiñebei jáfurida espíritugu lun lun lídin lúma, ába laríñagun Jesúsu lun lun leréderun, laríñaga lun. ");
INSERT INTO cabNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Giríbubá búbiñoun, ábame babájüdaguni sun le ladǘgübei Búngiu bun. Ába lídin, ába labájüdaguni le ladǘgübei Jesúsu lun lídan sun fulásu ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Dan le lagíribudunbei Jesúsu loubáfurugun lagúnu, ába jerésibiruni gürígia láu ugúndani ladǘga sun jagía agúrabañu jáñein. ");
INSERT INTO cabNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ábati liábin ában wügǘri gíriti Jáiro, le ábanbei jádaangiñe tábutigu jalígilisin juríu, ába lájuduragun lubádu lugúdi Jesúsu, ába layúmuragun lun lun lídin lúbiñe, ");
INSERT INTO cabNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ladǘga ában rügǘñoun liraǘ, queí buri dúusu irúmu táu, toúwe. Dan le lídinbei Jesúsu, ába jafálaruni sarágu gürígia darí lun jámurudaguni. ");
INSERT INTO cabNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ñíñounti ában wǘri jádan, dúusu irúmu táu láu lésejan jítaü tídaangiñe. Gásta táali sun tiseínsun jawágu surúsiagu, siñá jamutu areídaguagüda. ");
INSERT INTO cabNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ába tayárafadun lun Jesúsu lanágangiñe, ába tagúruruni táru lanáangun, lídan méme óra ligía ába tareídagun. ");
INSERT INTO cabNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ábati laríñagun Jesúsu. —¿Ca agúrurubei nuágu? Quei sun lan jagía aríñaga luágu magúrurúnwa lan luágu, ába laríñagun Pédro jáma líbirigu. —Maésturu, murúgu wañátia ya lurúma jíbe gürígia, ¿álügüdajagidibu ca lan agúrurubei buágu? ");
INSERT INTO cabNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ába laríñagun Jesúsu. —Gurúwaali nuágu, ladǘga sandí numuti luágu areídaguagüdaadina lan gürígia láu nubáfu. ");
INSERT INTO cabNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dan le tasúbudiruni wǘri tugúya luágu subúdiwaali lan, aba tiábin adádagareina, ába tájuduragun lubádu lugúdi Jesúsu, ába tagúfeserun lun jagíbugiñe sun gürígia ca lan lébubei tagúrurun luágu áni ába lan tareídagun lídan méme óra ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ábati laríñagun Jesúsu tun. —Niraǘ, areídaguaadibu ladǘga bafíñerun nuágu. Beíba darángilañu. ");
INSERT INTO cabNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ñígili Jesúsu adímureja, ligía lachǘlürün ában lúbiñegiñe Jáiro, ába laríñagun lun Jáiro. —Jilá biraǘ, mebéresejadügüyabá lun Maésturu. ");
INSERT INTO cabNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Dan le lagáambunbalin Jesúsu le, ába laríñagun lun. —Manúfudedabá, afíñerügübá, ábame tareídagun biraǘ. ");
INSERT INTO cabNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Dan le lachǘlürünbei Jesúsu lúbiñoun Jáiro, mígirunti lun jebélurun ámu lúma lueídügüya Pédro, Jacóbo lúma Juan jáma tagǘbürigu irájü tugúya. ");
INSERT INTO cabNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jayájuña sun ja ñíbaña tárigi, ába laríñagun Jesúsu joun. —Mayájua jumá, moúnwentu, tarúmugarügüña. ");
INSERT INTO cabNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ába jéjerajan láu ladǘga subúdi jamáni luágu jilá tan. ");
INSERT INTO cabNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ábati lárügüdüni Jesúsu tújabu, ába laríñagun láu umálali jéreti. —Irájü, sarába. ");
INSERT INTO cabNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ába táguyugun, ába tásaarun lídan méme óra ligía, ába laríñagun Jesúsu lun jíchugun eígini tun. ");
INSERT INTO cabNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Weíriti janígi tagǘbürigu, ába laríñagun Jesúsu joun lun mabájüdagun jamáni le asúseredubei ni ca un. ");
INSERT INTO cabNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ába loúndaruniña Jesúsu dúusu láni apóstolugu, ába líchugun ubáfu joun lun jaságarun sun jawúyeri espíritugu wuríbatiña lúma lun jareídaguagüdün sánditiña. ");
INSERT INTO cabNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ába loúnajaniña apúrichijei ugánu luáguti larúeijan Búngiu lúma areídaguagüdaña sánditiña. ");
INSERT INTO cabNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Laríñaga joun. —Manǘga jumá ni cáta júmagua luágu juweíyasun—ni bádun, ni ságü, ni fein, ni seínsu. Ábanrügütá símisi janǘgün. ");
INSERT INTO cabNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Furúmieguarügü múna to ñíjin lumúti jachǘlüra, reídei jumá ñi darí jídin lídaangiñe fulásu ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Le ñí lumuti merésibirúniwa jumá, dánme le jáfuridun lídaangiñe fulásu ligía, ábame jáfuruduni calíqui lueígiñe jugúdi, arúfuda jumámugei luágu magúndan jumá láu jagáburi lílana fulásu ligía, ígira jumáña quei jadáriragun joúngua. ");
INSERT INTO cabNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ábati jáfuridun apóstolugu jagía, ába jeíbuguni sun lirájüñü fulásu apúrichijeinei ugánu luáguti asálbaruni, areídaguagüdeina jagía sánditiña lídan sun fulásu le ñí lumuti joúdin. ");
INSERT INTO cabNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ába lagáambun gumádimati Heródes luágu sun cátei le ladǘgübei Jesúsu, ibídiñetiti lun cába lan larítagua, ladǘga ñíñanu aríñagutiña luágu saráali lan Juan lídaangiñe oúweni, ");
INSERT INTO cabNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","jíbiri aríñaga luágu proféta Elías lan achǘlaagubei, jíbiri aríñaga luágu ában lan jádaangiñe jíbiri binádu profétagu le ásaaruti lídaangiñe oúweni. ");
INSERT INTO cabNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ába laríñagun Heródes. —Áu guánarügü oúnajabei adǘrürei lichǘgü Juan. ¿Cátei funáti le, le uágubei nagáamba labájüdawagún sarágu cátei? Ábati loúchun Heródes laríjini Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Dan le jagíribudun apóstolugu, ába jabájüdagun lun Jesúsu luágu sun le jadǘgübei. Ábati lanǘgüniña lídoun fulásu mageírawati yaráfa lun Betsáida. ");
INSERT INTO cabNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Dan le jasúbudirunbalin gürígia, ába jafálaruni, ába lerésibiruniña Jesúsu, ába ladímurejan joun luágu larúeijan Búngiu, areídaguagüda láña sánditiña. ");
INSERT INTO cabNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dan le lagúmeserunbei adárüda, ába jayábin láni Jesúsu dúusu apóstolugu lúmoun, ába jaríñagun lun. —Oúnaja báña gürígia ja, ñǘdün jamámuga áluga jabára lun jeméraagun, áluaja jagíame eígini lídan buri lirájüñü aǘdü lúma lídan buri fulásu yaráfati, ladǘga úati ni cáta ya. ");
INSERT INTO cabNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Laríñaga Jesúsu joun. —Rújuma eígini joun. Jaríñaga lun. —Seíngü rügǘñoun fein wáma jáma bián úduraü, ánjawa gubeírügü ñǘdün agáñija eígini joun sun gürígia ja. ");
INSERT INTO cabNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yaráfañanu joún seíngü mílu wügǘriña ñi, mabájüdünga würíña jáma irájüñü. Ába laríñagun Jesúsu joun láni disípulugu. —Ñurúgüda jumáña dimí dimí-san. ");
INSERT INTO cabNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ába jadǘgüni ítara, ába jañúurun súngubei. ");
INSERT INTO cabNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ábati lanǘgünun Jesúsu seíngü fein lújaburugu jáma bián úduraü, ába laríjin siélun, ába líchuguni eteíngiruni lun Búngiu. Lárigiñe lagúbachagunun fein lúma úwi, ába líchuguni joun láni disípulugu lun jafánreinjani jádan gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Joútiña súngubei quimúle, dan le jabúdajanun ígiragutu, buíngüdatiña dúusu faníñe láu. ");
INSERT INTO cabNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Luágu ában wéyu dan le layúmuraguña lan Jesúsu lábugua, ñíñanu láni disípulugu díseraü lueí, ába laríñagun joun. —¿Ída liñásan jarítagun gürígia nuágu? ¿Cátanasan, según jagía? ");
INSERT INTO cabNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ába jaríñagun lun. —Añájein, aríñagutiña luágu Juan lan le abásteragüdajabei amǘrü, jíbiri, aríñaga Elías, añájeingua aríñagutiña luágu ában lan jádaangiñe binádu profétagu ásaaruti lídaangiñe oúweni amǘrü. ");
INSERT INTO cabNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ábati laríñagun joun. —Ángi jugúya, ¿cátanagi lídan jarítagun? Laríñaga Pédro lun. —Crístu, le loúnajabei Búngiu lun lasálbaruniña gürígia, amǘrü. ");
INSERT INTO cabNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ába laríñagun Jesúsu joun láu éregu lun maríñagun jamáni cátei le ni ca un. ");
INSERT INTO cabNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ába laríñagun joun. —Nasúfuriruba sarágu, áu le Wügǘri Garaǘwarügüti. Janǘgübadina wügǘriña weírigutiña lídan jafíñen juríu, jábutigu fádirigu, jáma arúfudajatiña lilúrudun Moisés, quei ni cáta. Nafarúaba jilágubei, ábame násaarun lídaangiñe oúweni luágu lǘrüwan wéyu lúnya nabágaridun. ");
INSERT INTO cabNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Lárigiñe, ába laríñagun joun súngubei. —Le busénti nánigu lan, bulíeileí cáteiñein lan, awándaleí sun luwúyeri asúfuriruni le lúnbei liábin lun, nueígiñe, queísi lanǘgüni ában wügǘri lugúruwan, falálana. ");
INSERT INTO cabNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ladǘga le abúseeruti leséfuragun lúngua ya uboúagu leféridirubei ibágari le magúmuchaditi, ánjein le ánjabei leféridiruni libágari ya uboúagu nueígiñe, libíjubei ibágari le magúmuchaditi siélu. ");
INSERT INTO cabNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Cági ju lan lun gürígia lagáñeiruni sun le lánina uboú, leféridireime lubára siélu o lagǘnrinchaguba lan lúngua? ");
INSERT INTO cabNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Le anǘgüti busíganu nuágu lúma luágu nerérun, áu le Wügǘri Garaǘwarügüti, nibúsigaribadina gíñe láu dánme le niábin quei urúei láu luweírigun Núguchi jáma ánjeligu ja sándubaña. ");
INSERT INTO cabNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ninárün naríñaguni jun luágu añájein lan jádaangiñe ja yábaña guetó, moúnwenbaña maríjinga jameí larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Queíburi wídü wéyu lárigiñe laríñaguni Jesúsu cátei le, ába laweínrun luágun ában wǘbü ayúmuragua lun Búngiu, barǘ lumútiña Pédro, Jacóbo, lúma Juan lúmagua. ");
INSERT INTO cabNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dan le niján lan Jesúsu ayúmuragua, ába lámuñedagun ligíbu, ába tájarudun lanáangun, ába támiridun. ");
INSERT INTO cabNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ábati jasáliragun Moisés lúma Elías ayánuja lúma, ");
INSERT INTO cabNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","geyégu líña ában larúgounga weíriti jáu, jayánujaña libǘgürü oúweni le lúnbei lasúfuriruni Jesúsu, Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Láu sun luweírin lidábu lágu Pédro jáma líbirigu, marúmuguntiña, aríja jamúti luweírigun Jesúsu jáma bián wügǘriña ja lúmabaña. ");
INSERT INTO cabNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dan le adísedeinaña bián wügǘriña jagía lueí Jesúsu, ába laríñagun Pédro lun. —Maésturu, ¡lídan dan awánja lan ya! Adǘga wamá ǘrüwa dibásein ya—ában bun, ában lun Moisés, túma ában lun Elías. Ibídiñeti lun Pédro ca lan laríñagubei. ");
INSERT INTO cabNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Súnti niján lan adímureja, ába liábin ában juánriñu oúburaguaña, ába janúfudedagun ladǘga jadáriragun joúngua lurágeirugu juánriñu ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ábati jagáambun ában umálali aríñaguti lídaangiñe juánriñu ligía. —Niraǘ le jínsiñebei nun le, agáamba jumeí le lubeíbei. ");
INSERT INTO cabNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lárigiñe ladímurejan umálali ligía, ába jaríjin disípulugu luágu lábugua rügáali lan Jesúsu. Reídeitiña maníñu, maríñagun jamúti cátei le jaríjubei lun ni ában lídan dan ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Larúgan, dan le jarárirunbei lueígiñe wǘbü, sarágu jáña gürígia ñǘdüntiña lubároun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ábati lagúaragun ában wügǘri jádaangiñe láu umálali jéreti, laríñaga. —Maésturu, fuleíseijabubá nun, aríjabeí niraǘ le ligía rügǘñeibei, ");
INSERT INTO cabNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","níjein ában espíritu wuríbati luágu, dan le lárügüdüni, ába lagúaraguagüdüni, ába loúwejan, ába láfurijan jacútaü liyúmulugugiñe. Añáwurija lumúti, májati lígiruni. ");
INSERT INTO cabNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ayúmuraguaadina joun báni disípulugu lun jaságaruni espíritu wuríbati le lueí, siñá jamuti. ");
INSERT INTO cabNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ába loúnabun Jesúsu, laríñaga. —¡Jugúya gürígia mafíñeraditiña, wuríbatiña! ¿Átiribeísan dan lun neréderuni júma lubá gayára lan jafíñerun nuágu? ¿Ídame lagúmucha mafíñeni le jídaanbei? Barǘbei biraǘ ñájoun. ");
INSERT INTO cabNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dán yebe le lídin irájü ligía lun, ába lájuchuruni espíritu wuríbati múarugún, ába loúwejagüdüni, ába ladeínjan Jesúsu lun espíritu wuríbati ligía, ába lareídaguagüdüni irájü, ába ledéregeruni lun lúguchi. ");
INSERT INTO cabNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ába laweíridun janígi súngubei láu luweírigun Búngiu. Sun añája lan láu luweírin janígi láu le ladǘgübei Jesúsu, ába laríñagun joun láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Agáamba jumeí cátei le buídu. nedéregerúaba, áu le Wügǘri Garaǘwarügüti, jájaburugun náganiñu. ");
INSERT INTO cabNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Úati gunfaráanda jamáni disípulugu le laríñagubei, ladǘga darúñu líña jasáminan lun cátei le, áni janúfudetiñati lun jaríñagun lun lun lafúnraanguagüdüni le laríñagubei, joun. ");
INSERT INTO cabNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ábati jagúmeserun disípulugu asígeneja jámagua luágu ca lan weírigutimaabei jádan, ");
INSERT INTO cabNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","quei lasúbudiruni Jesúsu jasáminan, ába lanǘgün ában irájü lubáduagun, ");
INSERT INTO cabNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ába laríñagun joun. —Le erésibiruti ában irájü queísi irájü le lídan níri, resíbi lumútina, le erésibirutina, resíbi lumúti gíñe le oúnajabalina. Le lubeíti ǘnabugutimaabei jídan, ligía weírigutimaabei. ");
INSERT INTO cabNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ábati laríñagun Juan lun Jesúsu. —Maésturu, aríjatiwa ában wügǘri aságajati espíritugu wuríbatiña lídan bíri, ába wewéridiruni ladǘga máma lan ában wádaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Laríñaga Jesúsu lun. —Mewéridira jumeí, ladǘga le mámabei wágani, wámagiñeñein. ");
INSERT INTO cabNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dan le layárafadun dan lun lanügǘniwa Jesúsu siélun, ába ladǘgüni luweíyasun Jerusaléoun láu anígi. ");
INSERT INTO cabNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ába loúnajan loúnagülegu lubá, ába joúdin lídoun ában liraǘraü fulásu láni Samária lun jáluajan múna lubá, ");
INSERT INTO cabNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","májatiña Samariána jerésibiruni ladǘga jaríjin luágu leíbuga lan Jerusaléoun. ");
INSERT INTO cabNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Dan le jaríjinbalin Jacóbo lúma Juan luágu mája jamá Samariána jerésibiruni, ába jaríñagun lun. —Wabúreme, ¿buséntibu lun wamúriajan lun larárirun wátu geméti siélugiñe lun lagúmuchun jáu queí meja ladǘgüni proféta Elías? ");
INSERT INTO cabNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ábati ladígiragun Jesúsu jawágun, ába ladeínjan joun, laríñaga. —Ibídiñeti jun luágu wuríba lan cátei le jayúmajabei. ");
INSERT INTO cabNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Máma niábiña, áu le Wügǘri Garaǘwarügüti, agǘnrinchaguei jabágari gürígia, niábiña asálbarei. Ábati joúdin lídoun ámu liraǘraü fulásu. ");
INSERT INTO cabNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dan le luágu jamá ǘma, ába laríñagun ában wügǘri lun Jesúsu. —Nabúreme, buséntina nafálarunibu le ñíjin lumúti bídin. ");
INSERT INTO cabNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Laríñaga Jesúsu lun. —Darítiña gasígamu júyu lun jaganoún ñi, gádibu jagía dunúru, ánjein áu le Wügǘri Garaǘwarügüti, úati ni jalíaba lan nabálachagüdei nichǘgü. ");
INSERT INTO cabNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Laríñagaya Jesúsu lun ában. —Falábana. Laríñaga lun. —Nabúreme, lárigiñeme loúnwen núguchi, buná neíme, ábame neíbugun búma. ");
INSERT INTO cabNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ába loúnabuni Jesúsu. —Falábana guetó, ígira báña ja jiláñubaña lun cátei le lánina larúeijan Búngiu lun jábununiña jegéburi, ánjein bugúya, beíba apúrichijei ugánu luáguti larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ábayati laríñagun ában lun. —Nabúreme, buséntina nafálarunibu, neíba yebe ayoúragua joun ja wábiñebaña. ");
INSERT INTO cabNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Laríñaga Jesúsu lun. —Le íchuguti lújabu luágu awoújagülei, lárigiñe ába laríjin lárigoún, mabuídunti lun lílaname larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lárigiñe cátei le, ába lanúadajan Jesúsu ǘrüwa-wein-díisi jádaangiñe lánigu, ába loúnajaniña lubá, bián bián, lídoun sun ageíraü lúma fulásu le lúnbei lídin ñi. ");
INSERT INTO cabNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Laríñaga joun. —Inárüni, gíbetiña gürígia ja aráanseñabaña lun jagáambuni ugánu luáguti asálbaruni, jagía, ítara jáña queísi nádü le lúnbei lalúbajoúniwa, áni loúguatiña ñadágimeintiña. Ligía lúnti lubeí jamúriajan lúma Búngiu lun loúnajan ñadágimeintiña jagánaguoún. ");
INSERT INTO cabNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jeíba, noúnajañadün quei mudún jádoun anímaalu gáñitiña. ");
INSERT INTO cabNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Manǘga jumá ságü júmagua, ni seínsu, ni geídi, meréderagun jugúyame ayánuja ni ca úma luágu ǘma. ");
INSERT INTO cabNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Dánme le jebélurun tídoun ában múna, busújuma furúmiñe, jaríñagame. “Darángilaü joun tílana múna to.” ");
INSERT INTO cabNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ánjein añájein lubeí gürígia jínsiñejabutiña lun darángilaü tídan múna tugúya, jerésibirubadün láu ugúndani, joúnbei abúsuruni lánina darángilaü. Ánjein úa jabeí gürígia jínsiñejabutiña lun darángilaü tídan múna tugúya, giríbugüda jumeí abúsuruni. ");
INSERT INTO cabNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Reídei jumá tídan múna tugúya to ñí lubei jerésibirúa, jou jumeíme, gurá le íchugúti jun úouga busíganu, ladǘga garíchati ñadágimeinti lun lafáyeiruaja. Masáansija jumá múna. ");
INSERT INTO cabNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Dánme le jachǘlürün lídoun ában ageíraü le ñí lumuti jerésibirúa, joújumei le íchugúti jun, ");
INSERT INTO cabNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","areídaguagüda jumáña sánditiña ja ñítiña, jaríñagame joun lílana fulásu ligía. “Subúdigüdáwaali luáguti larúeijan Búngiu jun.” ");
INSERT INTO cabNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ánjaün achǘlüra lídoun ában ageíraü le ñí lumuti merésibirúniwa jumá, furíjuma lídoun buri ǘma, jaríñagame. ");
INSERT INTO cabNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ásta licáliquin jageíra le luágubei wagúdi furú wamuti lun warúfuduni jun luágu magúndan wamá láu jigáburi, áni subúdi jumeí luágu subúdigüdáwaali lan luáguti larúeijan Búngiu jun.” ");
INSERT INTO cabNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Naríñajare jun luágu lídan lánme luwéyuri lagúseragüdüniña Búngiu gafígountiña, janárimetimaabei jabeichúniwa lílana fulásu le merésibirunbadün sügǘ láu jabeichún lílana ubúrugu le Sodóma. ");
INSERT INTO cabNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","‘¡Fugiábu jugúya lílana Corazín! ¡Fugiábu jugúya lílana Betsáida! Ladǘga lun jamúga ubúrugu lan Tíro o Sidón ladügǘwa buri miláguru le adügǘbei lídan jubúrugute, binárü jamúga lasáansiragua jagáburi lílana, ába jamúga jarúfuduni láu jadáüragun lúdu lúma balígi. ");
INSERT INTO cabNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ánjein jugúya, lídaanme luwéyuri agúseruni, weíritimaabei jabeichúniwa sügǘ jáu gürígia Tírona jáma Sidónna. ");
INSERT INTO cabNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Amǘrüti, ubúrugu le Capernaúm, ¿jarítaguatibu luágu liñurúaba lan bíri queísi líñun siélu? Larárirawagüdǘwaba bíri ǘnabun queísi lǘnabun máfiougati. ");
INSERT INTO cabNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ába laríñagun Jesúsu joun ǘrüwa-wein-díisi disípulugu ja loúnajañabaña apúrichija luágu larúeijan Búngiu. —Le agáambutün, agáamba lumútina, le májati lagáambunün, májati gíñe lagáambunina, áni le májati lagáambunina, májati gíñe lagáambuni Núguchi le oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ába jagíribudun ǘrüwa-wein-díisi disípulugu jagía lídaangiñe jaweíyasun láu ugúndani, aríñageina jagía. —Wabúreme, ásta espíritugu wuríbatiña agáamba jamútiwa dan le waságaruniña lídan bíri. ");
INSERT INTO cabNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Laríñaga Jesúsu joun. —Ánja, aríja numúti ligáburi leíguadun Máfia siélugiñe quei ában labírijanouga. ");
INSERT INTO cabNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Rújadina ubáfu jun lun jadǘgüragun jéwe jáma águru, masúfurirunga ni cáta, lúma lun jére lan jubáfu lueí lubáfu Máfia. ");
INSERT INTO cabNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Láu sun líra, magúndaara jumá luágu jagáambunün espíritugu, gúnda jumá luágu níjein lan jíri bürǘwañu tídan lilíburun Búngiu siélu. ");
INSERT INTO cabNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lídan óra ligía, ába labuínchagüdüni Sífiri Sándu Jesúsu láu ugúndani, ába laríñagun. —Núguchi, le Labúremebei siélu lúma múa, iñúragüda numúti bíri, ladǘga arámuda báali cátei luáguti barúeijan jaweí chútiña áu jáma furéndeitiña, ába bafúraanguagüdüni joun ja loúguabaña ufúrendei queísi irájüñü. Ánja, Núguchi, ladǘga ítara líña babúseeruni. ");
INSERT INTO cabNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","‘Derége láali Núguchi sun cátei nun. Úati ni ában subúdijabuti cátana lan lueídügüya Núguchi, úati gíñe ni ában subúdijabuti cáteiñein lan Núguchi nueídügüya jáma ja úntiña nabúseera nasúbudiragüdüni. ");
INSERT INTO cabNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ábati ladígiragun adímureja joúnrügü láni disípulugu, laríñaga. —Fuleíseiwatiña ja aríjubalin cátei le jaríjubei jugúya, ");
INSERT INTO cabNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ladǘga naríñajare jun luágu sarágu jáña urúeigu jáma profétagu abúseerutiña yebe meja jaríjini le jaríjubei jugúya guetó, maríjin jamúti, busén jagía yebé meja jagáambuni le jagáambubei guetó, magáambun jamúti. ");
INSERT INTO cabNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lídan ában guríriguaü, ñíñein ában arúfudajati lilúrudun Moisés, abúseeruti loúchaguni Jesúsu, ába lásaarun, ába laríñagun lun. —Maésturu, ¿cábasan nadǘga lun gayára lan nibíjini ibágari magúmuchaditi? ");
INSERT INTO cabNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Laríñaga Jesúsu lun. —¿Cáteigi bürǘwañubei lídan lilúrudun Moisés? ¿Ída liñágia balíijan ñi? ");
INSERT INTO cabNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ába loúnabun, laríñaga. —Jínsiñelá Babúreme Búngiu bun táu sun banígi, táu sun buwáni, láu sun bére, lúma láu sun bisáminan, jínsiñe jagíame bíbirigu bun quei bínsiñegua búngua. ");
INSERT INTO cabNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ábati laríñagun Jesúsu lun. —Oúnabaadibu buídu, ánjein badǘga ítara, bibíjubei ibágari magúmuchaditi. ");
INSERT INTO cabNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Queíti busén lan arúfudajati ligía larúfuduni luágu buídu lan lálügüdajan, ába laríñagun lun Jesúsu. —¿Cátañagi níbirigubaña? ");
INSERT INTO cabNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ábati loúnabuni Jesúsu, laríñaga lun. —Ñíñein ában wügǘri arágachuti Jerusaléngiñe lun ubúrugun Jericó, luágu luweíyasun ába járügüdüni jíwerutiña, ába jíwerujani sun le lúmabei ásta lanáangun, buleísei jameí, ába jígiruni jilá mémeeli. ");
INSERT INTO cabNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ába lásügürün ában jafádirin juríu lídaangiñe méme ǘma ligía, dan le laríjinbalin wügǘri ligía, mebéresenti láu, ába lasígiruni leíbugun loubáfurugugiñe ǘma. ");
INSERT INTO cabNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sügǘ ligía ában jádaangiñe ladǘgawagun Leví ñígiñe, dan gíñe le laríjini wügǘri buleíseiwaali ligía, ába gíñe lasígiruni leíbugun loubáfurugugiñe ǘma, mebéresenga gíñe láu. ");
INSERT INTO cabNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ábati lásügürün ában wügǘri Samariána aweíyasujati lídaangiñe ǘma ligía, dan le laríjinbalin, ába lagúdemedagun lun. ");
INSERT INTO cabNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ába liábin, ába lagáranijan lun bíti buri le luágubei láu aíli túma diweín, ába lagǘraguni. Ába laweínragüdüni luágu lilǘgün burígü, ába lanǘgüni tídoun jában chülǘdügütiña, ába ladǘgüni le liyáraati lun. ");
INSERT INTO cabNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Larúgan, dan le leíbuga lan Samariána ligía, ába láluguchun bián seínsu le denáriu, ába líchuguni lun tabúreme múna, laríñaga lun. “Toúnigibeí wügǘri le, ánjabu agástara ámu lueí le níchugubei bun luágu, nafáyeirubei bun dánme le nagíribudun.” ");
INSERT INTO cabNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ábati lálügüdüni Jesúsu arúfudajati ligía. —¿Cáteiti jádaangiñe ǘrüwa wügǘriña ja líbiribei le ueíbei líwerujoúa, lídan barítagun? ");
INSERT INTO cabNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Laríñaga lun. —Le gudémejabubei lun. Laríñagati Jesúsu lun. —Ítaralá gíñe badǘga. ");
INSERT INTO cabNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ába lasígirun Jesúsu luágu luweíyasun jáma lánigu, ába lachǘlürün lídoun ában liraǘraü fulásu le ñí lubei terésibirei ában wǘri gíritu Márta, túbiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ñíñoun ában tamúlelua Márta gíritu María, ába tañúurun lubádu lugúdi Jesúsu lun tagáambuni le laríñagubei, ");
INSERT INTO cabNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ánjounti Márta, weíriti teténirun lun tubéresegun. Ába taríñagun Márta lun Jesúsu. —Nabúreme, ¿mebéresentibusan láu tígirunina namúlelua adǘgei sun berésegu nábugua? Aríñagabá tun lun tíderagunina. ");
INSERT INTO cabNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ába loúnabunun Jesúsu, laríñaga tun. —Márta, bafúuduña luágu sarágu cátei, ");
INSERT INTO cabNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","buídurügüti murúsun lun weígin. Anúadaja táali María lubuídun-ágei cátei le lúnbei ladügǘniwa, áni úabei ni ában lun lagídaruni tueí. ");
INSERT INTO cabNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Luágu ában wéyu, layúmuraguña Jesúsu lun Búngiu lídan ában fulásu, dan le lásurun, ába laríñagun ában jádaangiñe láni disípulugu lun. —Nabúreme, arúfudajabá ayúmuraguni woun quei larúfudajan Juan joun láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Laríñaga Jesúsu lun. —Dánme le jayúmuragun lun Búngiu, jaríñagame ítara. Wáguchi Búngiu le siélubei, inébewalá bíri. Ñǘbinlá bidáani lun barúeijan ya uboúagu, adügǘwalá bugúndan uboúagu quei ladügǘn bugúndan siélu. ");
INSERT INTO cabNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Rúboun fein buídurügütu woun lun wéyu le ugúñebei. ");
INSERT INTO cabNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ferúdunabeí wuríbati le adǘga wamáalibei quei ferúduna wamániña ja adǘgübaña wuríbati woun. Mígira báwa lun wáburujan lídoun wuríbani, dísegüdarügü báwa lueí. ");
INSERT INTO cabNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aríñagati gíñe Jesúsu joun. —Niján ában jémpulu jun. lídin jamúga ában jídaangiñe lúbiñe ában lumáda amídi áriebu, ába laríñagun lun. “Numáda, furédeibá ǘrüwa fein nun, ");
INSERT INTO cabNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ladǘga sun líña lachǘlürün ában numáda núbiñoun áni úati ni cáta núma lun níchugun lun.” ");
INSERT INTO cabNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ába jamúgati loúnabun le ában múnadagiñe, laríñaga jamúga. “Mebéreseja bána, darúnaali nubéneri, áni roúnjadina jáu sun nisáanigu, siñáti násaarun íchiga ni cáta bun.” ");
INSERT INTO cabNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Naríñaguña jun luágu íbini lan jamúga másaarun lan íchigoun lun ladǘga lumáda lan, lásaaruña jamúga íchigoun lun lueí lasígirun ebéreseja lun. ");
INSERT INTO cabNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Aríñagatina lubeíti jun. Jamúriaja, ábame líchugun Búngiu jun, jáluaja, ábame jadárirun, jadaǘnja luágu béna, ábame lánjunrenchúniwa jun. ");
INSERT INTO cabNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ladǘga sun le amúriajati, ibíjati, le áluajati, daríti, le adaǘnjati luágu béna, junrénwati lun. ");
INSERT INTO cabNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","‘¿Gayáraabei funági líchugun ában úguchili jídaangiñe dǘbü lun liraǘ dan le lamúriajan fein lúma? ¿o líchugun lan ában jéwe lun dan le lamúriajan úduraü? ");
INSERT INTO cabNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿o líchugun lan ában águru lun dan le lamúriajan gañeín? ");
INSERT INTO cabNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gíchigadijadün ligía cátei buíti joun jirájüñü láu sun juríban, ¡gúbumeti líchigei Júguchi Búngiu le siélubei Sífiri Sándu joun ja amúriajati! ");
INSERT INTO cabNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ñíñein Jesúsu aságara ában espíritu wuríbati lueí ában wügǘri le madímuregüdün láalibei yebe espíritu ligía, dánti le láfuridunbei espíritu wuríbati ligía, ába gayára lan ladímurejan meréngaditi ligía. Ába laweíridun janígi gürígia láu cátei le. ");
INSERT INTO cabNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ñíñanu gíñe, aríñagutiña. —Láu lubáfu Beelzebú, le Máfia, le jábuti máfianu, laságaja wügǘri le espíritugu wuríbatiña. ");
INSERT INTO cabNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jíbiri, lun joúchaguni, ába jamúriajan miláguru lúma lun larúfuduni luágu lúmagiñe lan Búngiu liábin lubáfu. ");
INSERT INTO cabNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Queíti subúdi láani le jarítagubei, ába laríñagun joun. —Furúmieguarügü arúeijani le afánreinraguti lun jageíndagun jámagua, lagǘnrinchaguba, ában gíñe família fánreinguatiña ladǘga wuríbu, jagǘnrinchaguba gíñe. ");
INSERT INTO cabNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ánjein gíñe níjein lubeí fánreinguaü jádan Máfia jáma lánigu, ¿ída lubági ladúrarun lubáfu? Naríñagunbalin le, ladǘga jaríñagun luágu láu lan lubáfu Máfia naságaja espíritugu wuríbatiña ja ebélagüdübaña Máfia guánarügü jádoun gürígia, ");
INSERT INTO cabNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","áni ánjein ítara líña lubeí, ¿cági íchugubei ubáfu joun ja jánigu jugúya lun jaságajan espíritugu wuríbatiña, Máfia ódi Búngiu? Láu líra, jagía guánarügü arúfuda jamúti luágu bulíeigua jumá. ");
INSERT INTO cabNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Le inárünibei, láu lubáfu Búngiu naságaja espíritugu wuríbatiña, áni arúfuda lumúti líra luágu chülǘjali lan larúeijan Búngiu lídoun fulásu le. ");
INSERT INTO cabNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","‘Ába wügǘri jéreti, dan le aráanseñu lan, toúnigi lúban buídu, sun le lúbiñebei choúruti. ");
INSERT INTO cabNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ánjein ñǘbin ában jéretimaati lueí ába lásiiraguni, lagídaruboun sun lárumate to uáguboun leménigida lueí, ábame lanǘgüni le labúseerun, ába lafánreinraguni jáma lumádagu. ");
INSERT INTO cabNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","‘Le mámabei númagiñe, náganiñein, le míderagun lumútina, güríngua lumúti le nadǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ába laríñagun Jesúsu. —Dan le láfuridun ában espíritu wuríbati lídaangiñe ában gürígia, eíbugañajádügü líña lídan buri fulásu mábeiti áluaja leméraagun, dánti le madári láani, ába laríñagun lúnguarügü. “Nagíribudayá tídoun núban to ñígiñe lubeí náfurida.” ");
INSERT INTO cabNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dánti le lagíribudun, ába ladáriruni gürígia buga ligía quei ában múna to buídawaru, aráanserúa. ");
INSERT INTO cabNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ábati lídin, ába liábin jáu sédü espíritugu wuríbatimaatiña lueí, ába jebélurun agánawa lídan gürígia ligía, wuríbatimaajaliti le gádaanbalin wügǘri ligía lueí buga furúmiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Dan le niján lubeí Jesúsu aríñagei cátei le, ába tagúaragun ában wǘri jádaangiñe gürígia, taríñaga. —¡Fuleíseiwatu jiñáru to agǘriajabalibu, fuleíseiwatu to átagüdübalibu! ");
INSERT INTO cabNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ába laríñagun Jesúsu. —¡Fuleíseiwatimaatiña ja agáambubalin le lubeíbei Búngiu áni abájüda jameí! ");
INSERT INTO cabNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Añája méme gürígia oúndaragua geyégu láu Jesúsu, ába lagúmeserun adímureja, laríñaga. —Wuríbatiña gürígia ja lánina dan le, áni jamúriaja miláguru núma lun narúfuduni luágu Búngiu lan oúnajabalina, wel, míchugúnbei ámu seíni joun lueí le luáguti meja proféta Jonás. ");
INSERT INTO cabNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ítara queí meja le asúseredubei lun Jonás ában seíni joun ja aganoúbaña Nínive luágu Búngiu lan oúnajabalin, ítara lúba gíñe le lúnbei lasúseredun nun, áu le Wügǘri Garaǘwarügüti, ligíaba ában seíni joun gürígia ja lánina dan le luágu Búngiu lan oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dánme le lidáani agúseruni, dánme le lagúseragüdüniña Búngiu gürígia ja lánina dan le, ábame tásaarun lurúeite Súru lun tasíadiruniña, ladǘga tugúya, ñǘbintu lídaangiñe lidíse-ágei uboú lun tagáambuni lichú láu Salomón, áu, weírigutimaatina sügǘ láu Salomón áni májatün jagáambunina. ");
INSERT INTO cabNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Lídan mémeme agúseruni ligía, ábame gíñe jásaarun já meja aganoúbaña ubúrugu Nínive, ábame jasíadiruniña ja lánina dan le, ladǘga sáansiguati jagáburi Nínivena lárigiñe lapúrichijani Jonás ugánu le láni Búngiu joun, áni áu ában le weíriguti sügǘ láu Jonás, áni májatün lun jagáambunina. Ába lasígirun Jesúsu aríñaga. ");
INSERT INTO cabNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—Úati ébeduti ában lámpu líchigei lídan fulásu arámudaguati, ni tábugiñe ában gáfu, íñuba líchigei lun larúgoungadun joun ja ebélurutiña. ");
INSERT INTO cabNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ítara líña águu quei ában lámpu lun úgubu, ánjein buídu lubeí bágu, aríja ligía luágun cátei lánina Búngiu, camá jamuga jarúgoungabei gíñe láu sun búgubu, áni buídubei gíñe sun bigáburi. Ánjein sándi lubeí bágu, aríja ligía luágun cátei lánina uboú, camá jamuga lídaanbei lubúriga sun búgubu, wuríbabei gíñe bigáburi. ");
INSERT INTO cabNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Toúnigibá lun mabúrigadun lan bilámpun. ");
INSERT INTO cabNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ánjein jarúgounga lubeí láu sun búgubu, úaga ni murúsun lubúriga, baríjubei sun cátei furáangu quei dan le durúngu líña lan lámpu báu. ");
INSERT INTO cabNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Dan le lagúmuchunbei ladímurejan Jesúsu, ába lamísurajani ában fariséo eíga lúbiñe. Ába lebélurun Jesúsu, ába lañúurun luágu dábula. ");
INSERT INTO cabNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ába laweíridun lanígi fariséo ligía láu magúnfulirun lan Jesúsu láu igáburi le lánina lachibún újabu lubá eígini. ");
INSERT INTO cabNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ába laríñagun Wabúreme Jesúsu lun. —Jugúya fariséogu ragá jumuti wéru lúma asíedu boúgudigiñe libíti, múnadagiñe jibíti, wíyetün, buin jíña láu luweínamu águu lúma sarágu luwúyeri wuríbani. ");
INSERT INTO cabNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Deré tagáambun jugúya le! ¿Ibídiñeti jun luágu le lan adǘgübalin le boúgudigiñebei, ligía lan gíñe adǘgübalin le múnadagiñebei? ");
INSERT INTO cabNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Jarúma jumá múnadagiñe jibíti láu jíchugun joun gudémetiña, ítara lúba jarúma jumá gíñe boúgudigiñe jibíti. ");
INSERT INTO cabNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","‘¡Fugiábugu jugúya fariséogu! Adǘgatün díisi fánreinti láu jíduru le ménta, rúda, lúma ámu luwúyeri nádü lun jíchugun ában fánreinti lun Búngiu, áni madǘgüntün gásu láu ísuruni lúma línsiñejabu Búngiu. Ligía lúnbei jadǘgüni, mígirunga jumeíme jadǘgüni le ában. ");
INSERT INTO cabNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‘¡Fugiábugu jugúya fariséogu! Buséntün járügüdüni ubáraü le jabára ja weírigutimaabaña tídan jilígilisin, busén jugúya lun labúsurún jun láu sarágu inébesei ǘmada. ");
INSERT INTO cabNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","‘¡Fugiábugu jugúya fariséogu, biángua tigíbu!, ladǘga ítara jíña quei umúajaü le marijínti, sügǘ jagía gürígia ligíbuagugiñe ibídiñoun joun. ");
INSERT INTO cabNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ábati loúnabun ában jádaangiñe arúfudajatiña lilúrudun Moisés, laríñaga. —Maésturu, banábaguñadiwa gíñetia dan le baríñaguni le. ");
INSERT INTO cabNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ába laríñagun Jesúsu. —¡Fugiábugu gíñe jugúya, arúfudajatiña lilúrudun Moisés! Jíchigei lilúrudun Búngiu queísi ában anǘgüni jǘrüti joun ámu, áni jugúya, májatün janǘgün ni murúsun lídaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","‘¡Fugiábugu jugúya!, ladǘga rújumuti dǘbü arítaguagüleime luágu jamúaja profétagu já meja jáfaragubaña binádu jagǘbürigu. ");
INSERT INTO cabNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Láu líra, arúfuda jumúti luágu gúnda jumá láu le jadǘgübei binádu jagǘbürigu, jagía áfaragubaliña, jugúya wéndegüda jumúti jamúaja. ");
INSERT INTO cabNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","‘Ligía laríñagunbei meja Búngiu láu lichú láu. “Noúnajaba profétagu jáma apóstolugu joun, ábame jáfaraguniña jíbiri jilágubei, eíbaaja jamáñame jíbiri.” ");
INSERT INTO cabNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ligía lagúseragüdübaña lubeí Búngiu gürígia ja lánina dan le luágu játa profétagu ja áfarawagúbaña lúmagiñe ladügǘn uboú, ");
INSERT INTO cabNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","lúmagiñe líta Abél lúmoun líta Zacarías le jáfarubei labádinagua latárü túma témpulu. Ligía naríñagunbei jun luágu lagúseragüdübaña lan Búngiu gürígia ja lánina dan le luágu joúwegun profétagu. ");
INSERT INTO cabNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","‘¡Fugiábugu jugúya arúfudajatiña lilúrudun Moisés!, ladǘga ragǘ jumaali ligélen lubéneri subúdi, mebélurun jíña, mígirun jugúya lun jebélurun ja busénbaña jebélurun. ");
INSERT INTO cabNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Dan le laríñagunbalin Jesúsu cátei lé buri joun arúfudajatiña lilúrudun Moisés jáma fariséogu, ába jagáñidun lúma, lárigiñe láfuridun lúbiñegiñe fariséo ligía, ába jagúmeserun ebéresejei láu sarágu buri álügüdajani ");
INSERT INTO cabNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","lun jaríjin ánjaña adárira lidúnrun. ");
INSERT INTO cabNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ába joúndaragun sarágu mílu gürígia, gíbetiña darí lun jachúinragun joúngua. Ába lagúmeserun Jesúsu aríñaga joúntima láni disípulugu. —Toúnigi jumátia jaweí fariséogu, ítara líña jagáburi quei ísi—biánguañein jagíbu. ");
INSERT INTO cabNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Úati ni cáta lábugiñeti lubúriga lun mafúnraangudunbei lan, úa ni cáta arámudaguati lun masúbudirúnwabei lan. ");
INSERT INTO cabNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ítara líña lubeíti, sun le jaríñagubei lábugiñe lubúriga, lagaambúaba lídan larúgounga, le jaríñagubei lanágangiñe béna, lagúarajoúba tábulugugiñe múna. ");
INSERT INTO cabNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","‘Naríñajare jun, numádagu, moún lumuti janúfudedun jaweí gürígia ja gabáfubaña lun jáfarunün jilágubei, lárigiñe líra siñá jadǘgün ámu cátei jun. ");
INSERT INTO cabNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Naríñagaali jun ca lan ueí lúnbei janúfudedun. Janúfude jumá lueí Búngiu le gabáfugilibei lun loúnajanun juwáni máfiougatin lárigiñe lagídaruni jibágari. Lueílá janúfudeda. ");
INSERT INTO cabNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","‘¿Ma alúgurúatiña seíngü dunúru luágu bián gáwanün? Láu sun mebégi jamá sarágu, mabúlieidunti Búngiu ni ában jádaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ánjeinti jugúya, íbini ídiburi le jábulugubei abájüda láali Búngiu ában ában. Manúfude jumá lubeíti, gebégitün sügǘ jáu sarágu dunúru ligíbugiñe Búngiu, áni loúnigiruñádün. ");
INSERT INTO cabNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‘Naríñajare jun luágu sun lan ja aríñagubaña jagíbugiñe gürígia luágu nánigu jamá, naríñaguba gíñe luágu nánigu jamá jagíbugiñe láni Búngiu ánjeligu. ");
INSERT INTO cabNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ánjaña ja aríñagubaña jagíbugiñe gürígia luágu máma jamá nánigu, naríñaguba gíñe jagíbugiñe láni Búngiu ánjeligu luágu máma jamá nánigu. ");
INSERT INTO cabNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","‘Furúmieguarügü le aríñaguti cátei wuríbati nuágu, áu le Wügǘri Garaǘwarügüti, gayáraati ferúdunawa lan, ánjein le anábaguti Sífiri Sándu, siñáti ferúdunawa lan. ");
INSERT INTO cabNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‘Dánme le janügǘn ligíbugiñoun lúrudu lun jagúserun, o jagíbugiñoun lan tábutigu jalígilisin juríu, madíjerida jumá luágu cába lan joúnaba o cába lan jaríñaga, ");
INSERT INTO cabNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","dánme le lachǘlürün óra lun jadímurejan, larúfudubei Sífiri Sándu le lúnbei jaríñaguni jun. ");
INSERT INTO cabNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ába laríñagun ában jádaangiñe gürígia jagía lun Jesúsu. —Maésturu, aríñagabá lun níbugaña lun líchuguni nufánran nun lídaangiñe alágan. ");
INSERT INTO cabNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Laríñaga Jesúsu lun. —¿Cági íchubalina quei agúseragüdüti o quei afánreinjati jídan? ");
INSERT INTO cabNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aríñagati gíñe ítara. —Toúnigigua jumá júngua lueí luweínamu águu, ladǘga máma lueígiñe líbe lúmati gürígia labágarida sarágu dan. ");
INSERT INTO cabNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ábati líchuguni jémpulu le joun, laríñaga. —Ñíñein méja ában wügǘri rísiti, ába líchugun lichári alúbajoúni buíti. ");
INSERT INTO cabNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ábati laríñagun rísiti le lúnguarügü. “¿Cábasán funa nadǘga? Ibídiñeti nun jalíaba lan nareídei sun le nalúbajabei.” ");
INSERT INTO cabNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ába lasáminarun, ába laríñagun. “Subúdi náali cába lan nadǘga, nagǘnrinchaguaru sun náni lágei líla nádü, ábame nadǘgün ámu weínamutimaatu, ábame nareíduni nalúbajan lúma sun le númabei tídan. ");
INSERT INTO cabNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ábameti naríñagun núniwagua. Buíti dan bun, níjein sarágu cátei areídañu búma lun sarágu dan, eméraaguabá, joúba, gurába, gúndaabá.” ");
INSERT INTO cabNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Laríñaga Búngiu lun. “Wügǘri deré tagáambun, boúwe áriebu le, sun le búmabei areídañu, ¿cábasan un lerédera?” ");
INSERT INTO cabNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ítara líña lasúseredun lun gürígia le adámuridaguagüdüti irísini lánina uboú le lúngua, ába leréderun gudémeñu lídan cátei le luáguti Búngiu, líña Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ába laríñagun Jesúsu joun láni disípulugu. —Aríñagatina lubeíti jun. Madíjerida jumá luágu cába lan le lúnbei jeígini lun jawínwandun, ni tuágu anáanguni to lúnboun jadáürünun. ");
INSERT INTO cabNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gebégitimaati ibágari sügǘ láu eígini, gebégi úgubu sügǘ táu anáanguni. ");
INSERT INTO cabNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Aríja jumá joun dunúru. mábunaguntiña, malúbajan, mágei ligía jeígin, láu sun líra, joúgüda lumútiña Búngiu. ¡Gebégitimaatün sügǘ jáu dunúru! ");
INSERT INTO cabNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Úati ni ában jídaangiñe gayáraati líchugun lánwoun libágari láu sun luweírin lidíjeri luágu. ");
INSERT INTO cabNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ánjein lubeíti siñá lubei jadǘgüni le míbebei, ¿ca uágu jadíjerida luágu buri líbiri cátei? ");
INSERT INTO cabNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‘Aríja jumá ída líña lan laboúchun buri fulúri. mawádigimariti, májüchagun ligía lanáangun, áni láu sun líra, quei naríñaguni jun, ni urúei Salomón láu sun luwéndegun, mawéndedunti quei ában fulúri. ");
INSERT INTO cabNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ánjeinti ítara líña lubeí ladáüraguagüdüni Búngiu jíduru, le níjeinbei ugúñe, jarúga lagudúña, ¡ladáüraguagüdatimabadün, loúgua tafíñen jugúya le! ");
INSERT INTO cabNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Madíjerida jumá lubeíti luágu ni cáta, ni luágu cába lan jeíga, ni luágu cába lan játa. ");
INSERT INTO cabNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ladǘga lirájüñü uboú le, lárigiñanu buri cátei le, ánjein jugúya, níjein ában Júguchi le subúdijabúbei lun sun jemégeirun. ");
INSERT INTO cabNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Áluaja jumá lun jesériwidun lun furúmiñe, ábame líchuguni sun le jemégeirubei jun. ");
INSERT INTO cabNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","‘Manúfude jumá, nirájüñü, láu sun míbe jumá, gúndaati Búngiu lun líchugun ában ubáraü jun lídan larúeijan. ");
INSERT INTO cabNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Alúgura jumeí le júmati, jíchigeime lebégi joun gudémetiña, láu líra, jadǘgüñoun lágei seínsu to maweíyadaditu, irísini siélu le magúmuchaditi, le ñí lubei siñá lan jebélurun jíwerutiña anǘgei jirísin, úa jagía jamútiri ñi lun jeígini. ");
INSERT INTO cabNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Naríñagubalin le jun ladǘga le ñí lumuti jirísin, ñíñoun gíñe janígi. ");
INSERT INTO cabNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","‘Aráanseñu jumá lubá nagíribudun siélugiñe, durúngu jilámpun. ");
INSERT INTO cabNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ítara jumá quei músu ja agúrabañubaña liábin jayúbudiri lídaangiñe ában maríei lun jadáraruni béna lubá, óra lagúarun. ");
INSERT INTO cabNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Buídubei dan joun músu ja ladárirubaña jayúbudiri agágudúañu dan le lachǘlürün, ninárün jáu, iyúbudiri meme ligía laráanseruba, ábame lañúuragüdüniña luágu dábula, ábame lesériwiduni jeígin joun. ");
INSERT INTO cabNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Íbini amídi áriebu lan lachǘlüra o lubá lan larúgan, ánjaña ladárira agágudúañu, buídubei dan joun músu jagía. ");
INSERT INTO cabNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Subúdi jumeí luágu lun lan jamúga subúdi láni tabúreme múna cába lan óra lachǘlüra jíweruti íweruja, leréderuña jamúga agágudúañu, mígirunti jamúga lun tadárarún lúban lun líwerujoún lumégegun. ");
INSERT INTO cabNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jugúya, aráanseñu jumá gíñe, ladǘga lídaanme magáradajan jumá ligíame nagíribudun, áu le Wügǘri Garaǘwarügüti, uboúagun. ");
INSERT INTO cabNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ábati lálügüdüni Pédro Jesúsu, laríñaga lun. —Nabúreme, ¿woúnrügü bíchigei jémpulu le ódi joun súngubei? ");
INSERT INTO cabNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Laríñaga Wabúreme Jesúsu lun. —Lun furúmieguarügü oúnigiruti úarati, gunfaráanda ligía, le lígirubei liyúbudiri lun laríjin jáu tílana lúban, lun leígagüdüniña lídan dan. ");
INSERT INTO cabNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Buídubei dan lun músu le ladárirubei liyúbudiri agúnfulira láu luwádigimari dan le lachǘlürün. ");
INSERT INTO cabNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ninárün jáu, luágu líchugubei lan liyúbudiri lun ligía lan aríja láu sun le libíjubei. ");
INSERT INTO cabNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ánjein arítagua músu ligía luágu lǘgili lan liábin liyúbudiri, ábame lagúmeserun oúseraña jíbiri músu ja lábugiñebaña laríaajan wuríba, leréderame eíga, áta, abácharuada, ");
INSERT INTO cabNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ligíame liábin liyúbudiri lídan magáradajan lan, lídan ában óra le ibídiñeti lun. Ábame líchuguni luweírin-ágei abeíchuni luágu, lasíadireime lun lasúfuriruni le jasúfurirubei ja múaraanbaña, máfiougati. ");
INSERT INTO cabNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‘Músu le subúdijabúbei lun ca lan labúseerubei liyúbudiri áni maráanserunti, mabájüdünleí, labeichúba sarágu. ");
INSERT INTO cabNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ánjeinti músu le ibídiñeti lun, ába ladǘgün cátei lé buri lúnti labeichún lueígiñe, maweíribei labeichún. Le únti líchugúa gíbeti, gíbebei amúriajoúti lúmagiñe, le gíbeti ígirúti lábugiñe laríaajan, gíbetimaabei amúriajoúti lúmagiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","‘Láu niábin uboúagun, ñíbei fánreinguaü uboúagu queísi wátu geméti. ¡Busénjadina jamúga durúnguaali lan wátu ligía! ");
INSERT INTO cabNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Lúnti nasúfurirun le gumúti, ¡meménija nanígi lagúmuchun! ");
INSERT INTO cabNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Jarítaguatǘnsan luágu barǘ nán meja darángilaü númagua dan le niábinbei uboúagun? Manǘgütina darángilaü, fánreinguaü nanǘgübei. Jafánreinraguba ja mafíñebaña nuágu jáma ja afíñebaña nuágu, ");
INSERT INTO cabNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","lúmagiñe guetó, seíngügua tídan ában múna, jafánreinraguba ǘrüwa jaweí biáma, biáma jaweí ǘrüwa, nueígiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lagárabaguba úguchili luágun liraǘ, isáani luágun úguchili, úguchuru tuágun tiraǘ, isáani tuágun túguchu, ímenidi tuágun ágürü, ágürü tuágun ímenidi. ");
INSERT INTO cabNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aríñagati gíñe Jesúsu joun gürígia ítara. —Dan le jaríjin labúrigadun siélu, ába jaríñagun luágu lájuya lan júya, áni ligía asúsereda. ");
INSERT INTO cabNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dánti le láfurun garábali lueígiñe suédi, ába jaríñagun luágu lárougada lan, áni ligía asúsereda. ");
INSERT INTO cabNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Biángua tigíbu jugúya le! Subúdi jumúti luáguti ligáburi lasáansiragun dan siélu lúma múarugu, ¿ca uágu ibídiñe lubeí luáguti ligáburi dan le gádaanbalün jun? ");
INSERT INTO cabNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‘¿Ca uágu siñá lubei jasúbudiruni cátei le úaraguabei júngua? ");
INSERT INTO cabNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ánjein agúaragüda ában gürígia buágu, ába bídin lúma ligíbugiñe lúrudu, joúchabá baráanseragun búngua lúma luágu ǘma lubáragiñe jachǘlürün, manǘgün lámugabu ligíbugiñoun agúseragüdüti, lueí ledéregerunibu agúseragüdüti lun polisía, ábame ládarunibu furísunrugun. ");
INSERT INTO cabNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Naríñajare bun luágu máfuridunbadibu lan ñígiñe darí bafáyeiruni lagúmujoún bigáwanün. ");
INSERT INTO cabNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lídoun méja dan ligía, ába jayábin gürígia abájüdagua lun Jesúsu jawágu wügǘriña Galiléana ja láfaragubaña Piláto úara jáma anímaalu ja áfarawagúbaña lun adágaragüdüni lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ába laríñagun Jesúsu joun. —¿Jarítaguatǘnsan luágu ladǘga lan luweírin jafígoun Galiléana jagía sügǘ jáu ja jíbiri lílana jageíra lasúseredunbei le joun? ");
INSERT INTO cabNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Máma lueígiñe líra, láu sun líra, naríñajare jun luágu ánjein lan masáansirun jumá jigáburi, joúweguba gíñe sun jugúya. ");
INSERT INTO cabNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ángi díisi-wídü jagǘra ja oúwegubaña dan le láburujanbei wáyelesi le Siloébei jawágun— ¿jarítaguatün luágu weíritima lan jadúnrun sügǘ jáu ja jíbiri ja aganoúbaña Jerusalén? ");
INSERT INTO cabNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Máma líña gíñe, láu sun líra, naríñajare jun luágu ánjein lan masáansirun jumá jigáburi, joúweguba gíñe sun jugúya. ");
INSERT INTO cabNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ábati labájüdaguni Jesúsu jémpulu le joun, laríñaga. —Ñíñein ában wügǘri, ganádiriti ában tídibu wéwe to ígo, ába lídin aríja ánjein gín tubei, madáriti ni cáta tuágu. ");
INSERT INTO cabNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ábati laríñagun lun le oúnigirubalin ichári. “Aríjabásan, ǘrüwaali irúmu gabǘgürügua niábin áluaja ígo tuágu ídibu to, madáritina. Chaǘnboun, ¿cába uágu terédera ñi luágu ni cáta?” ");
INSERT INTO cabNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ába loúnabuni le oúnigirubalin ichári, ába laríñagun. “Niyúbudiri, ígirayaboún irúmu le, nañúludagüdali múa táu, awoúja áume táu. ");
INSERT INTO cabNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Fágua tagíindun ítara, ánjoun magíindun, ábame tánchugún.” ");
INSERT INTO cabNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Luágu ában wéyu le eméraaguagülei, ñíñein Jesúsu arúfudaja tídan jalígilisin juríu, ");
INSERT INTO cabNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ñíñounti ában wǘri, díisi-wídü irúmu táu láu ában espíritu wuríbati tuágu, ígira láaru espíritu ligía lemúñu, siñá tásururun ni murúsun. ");
INSERT INTO cabNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Dan le laríjinbarun Jesúsu, ába lagúarun tun, ába laríñaga tun. —Wǘri, areídaguaadibu. ");
INSERT INTO cabNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ábati líchuguni lújabu tuágu, lídan óra ligía ába tásururun, ába tagúmeserun adímureja buíti luágu Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ábati lagáñidun tábuti ligílisi ladǘga lareídaguagüdünun Jesúsu lídan wéyu le eméraaguagülei, ába laríñagun joun gürígia ja ñíbaña. —Níjein sísi wéyu lídan dimáasu lun gayára lan luwádigimaríniwa, lídan sísi wéyu ligía lun jiábin lun lagáranijoún jun, máma lídan wéyu le eméraaguagülei. ");
INSERT INTO cabNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ába laríñagun Wabúreme Jesúsu lun. —¡Biángua tigíbu jugúya le!, ¿ma farára jumúti sun jugúya jilǘgün bágasu o jilǘgün lan burígü lun janǘgün áta dúna lídan wéyu le eméraaguagülei? ");
INSERT INTO cabNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wǘri to, linébaanfan Abrahám, ragǘlaaru Máfia láu sándi, díisi-wídü irúmu táu láu, ¿moún lumuti funági yebe lun tareídawaguagüdǘn lídan wéyu le eméraaguagülei? ");
INSERT INTO cabNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Dan le laríñagunbalin Jesúsu cátei le, ába nibúsigarigua jamá sun láganiñu, ánjaña sun jíbiri gürígia, gúndaatiña láu cátei lé buri weíriguti le ladǘgübei Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ábati laríñagun Jesúsu. —¿Ída líña ligáburi larúeijan Búngiu? ¿ca cátei úmounbei gayára lan níchuguni? ");
INSERT INTO cabNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ítara líña quei ában liraǘraü tíla mostása le lábunubei ában wügǘri lichárirugu, ába laboúchun, ába laweíridun darí lun liábin lun ábanme lan tídibu wéwe weíriti, darí lun jadǘgün dunúru jádibu luágu tuburébu. ");
INSERT INTO cabNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ábaya laríñagun Jesúsu. —¿Ca cátei úmounbei gayára lan níchuguni larúeijan Búngiu? ");
INSERT INTO cabNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ítara líña quei ísi le tíchugubei ában wǘri tídoun ǘrüwa líburu fulúaaru, ába terésirun súngubei. ");
INSERT INTO cabNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ába lasígiruni Jesúsu luweíyasun Jerusaléoun, arúfudajeina ligía lídan buri sun aǘdü lúma lirájüñü fulásu le ídaangiñebei lásügüra. ");
INSERT INTO cabNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ába laríñagun ában wügǘri lun Jesúsu. —Nabúreme, míbetiñásan ja lúnbaña jasálbarun? Ába loúnabun Jesúsu, ába laríñagun. ");
INSERT INTO cabNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Bürǘraüti lubéneri siélu, joúcha jumá lun gayáraabei lan jebélurun lídaangiñe, ladǘga quei naríñaguni jun, sarágujaba busúentiña jebélurun, siñábei. ");
INSERT INTO cabNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lárigiñe ladáuruni tabúreme múna lubéneri, jugúya le boúgudibei jadaǘnjaba luágu béna, jaríñagame. “Wabúreme, darába béna wabá.” Ábame loúnabunün, laríñagame jun. “Ibídiñetün nun, ibídiñe gíñe nun jalíana jumá.” ");
INSERT INTO cabNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ábameti jagúmeserun aríñaga. “Joújadiwa, gurá wagía búma, arúfudaja amǘrü woun ǘmadarugu.” ");
INSERT INTO cabNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ábameti loúnabunün, laríñagame. “Aríñaga náali jun luágu ibídiñe jumá nun, ibídiñe nun jalíana jumá. Díse jumá nueí, sun jugúya le adǘgübei wuríbani.” ");
INSERT INTO cabNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ligíaba jayájuajan, acǘnrijame jári dánme jaríjini Abrahám, Isáac, lúma Jacób, jáma jíbiri profétagu lídan larúeijan Búngiu, jugúyame aságarúa boúgudin. ");
INSERT INTO cabNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Jayábiba gürígia lueígiñe oúbaü le ñígiñe lubeí láfuara wéyu lúma lueígiñe le ñígiñe lubeí lálüda, lueígiñe núru lúma lueígiñe suédi lun jañúurun eíga lídan larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ñíbañati jádaangiñe ja agúmujoúnibaña guetó, jagíaba furúmiñetiña, jámeti furúmiñetiña guetó, jagíaba agúmujoúni. ");
INSERT INTO cabNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lídan méme wéyu ligía, ába jayábin fariséogu, ába jaríñagun lun Jesúsu. —Beíba yágiñe, ladǘga busénti Heródes láfarunibu jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ába laríñagun joun. —Jeíba, jaríñagame lun wügǘri bíbuti ligía. “Ugúñe lúma jarúga naságajan espíritugu wuríbatiña jádaangiñe gürígia, areídaguagüda áu sánditiña, lárigiñe jarúga, lásurun nuwádigimari. ");
INSERT INTO cabNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Lúnti nasígiruni nuweíyasun ugúñe, jarúga, lúma lárigiñe jarúga, ladǘga máma lúnti lafarúniwa ában proféta jilágubei boúgudi lueí Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ába layájun Jesúsu jawágu lílana Jerusalén ítara. —¡O jugúya Jerusalénna! Áfaragua jumáaña profétagu, chǘgua jugúya dǘbü jawágun ja loúnajabaña Búngiu láu ugánu buíti jun! ¡Sarágu weíyaasu nálugun natoúnigirunün quei tatoúnigiruniña gáyu tirájüñü lábugiñe tarǘna, májatün! ");
INSERT INTO cabNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ígira láadün Búngiu, áni naríñajare jun luágu maríjindügüya jumáadina lan daríme lachǘlürün dan lun jaríñagun. “Biníwati le ñǘbinbei lídan líri Wabúreme.” ");
INSERT INTO cabNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Luágu ában wéyu le eméraaguagülei, ába lídin Jesúsu eíga lúbiñe ában fariséo weíriguti, sun ja ñíbaña, jaríaguñein Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ñíñein gíñe ában wügǘri láu sándi le ílu, ");
INSERT INTO cabNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ábati lálügüdüniña Jesúsu arúfudajatiña lilúrudun Moisés jáma fariséogu, laríñaga joun. —¿Gayáraati lareídawaguágüdün ában wügǘri lídan wéyu le eméraaguagülei ódi siñáti? ");
INSERT INTO cabNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ába jeréderun maníñu. Ábati lanǘgüni Jesúsu sánditi ligía, ába lareídaguagüdüni, ába laríñagun lun lun lídin. ");
INSERT INTO cabNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ába laríñagun joun fariséogu. —Furúmieguarügü jídaangiñe, ánjein eíguada lilǘgün bágasu o lilǘgün lan burígü lídoun ában wélu lídan wéyu le eméraaguagülei, laságarubei ñígiñe furése. ");
INSERT INTO cabNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Maríñagun jáña ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Dan le laríjini Jesúsu janúadajani amísurajoútiña ubáraü buri le joúnbei ja weírigubaña, ába laríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Dánme le bamísurajoún lídoun ában fédu lánina maríei, máluajabeí lubuídun-ágei ubáraü, ñǘbin liñeín ábanya amísurajoúti weírigutimáati bueí, ");
INSERT INTO cabNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ábame liábin le amísurajabalün, laríñagame bun. “Rúbei bubára lun wügǘri le.” Ábameti bídin láu busíganu añúura lídan lǘnabun-ágei ubáraü. ");
INSERT INTO cabNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Dánme le bamísurajoún lídoun ában fédu, ñurúba lídan lǘnabun-ágei ubáraü, lun dánme lan le liábin le amísurajabalibu, laríñagame bun. “Numáda, sügǘba lídoun ában ubáraü weírigutimaati.” Ítara lúba berésibirun inébesei jagíbugiñe sun ja ñúnbaña luágu dábula. ");
INSERT INTO cabNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Le anáanguti lúngua weíri, lǘnabudúba, le ǘnabuti lanáangun lúngua, weíribei lanügǘn. ");
INSERT INTO cabNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Aríñagati gíñe lun wügǘri le amísurajabalin. —Dánme le bíchugun ában adíneruni o fédu, mamísuraja báña bumádagu, ni bamúlenu, ni bíbugañanu, ni jíbiri bidújeñu, ni bubésinanigu ja rísitiña, ladǘga jamísurajabadibu gíñe, bibíjubati bafáyeiruaja. ");
INSERT INTO cabNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Dánme le badǘgün fédu, amísuraja báña gudémetiña, siñáguatiña úngua, danímaatiña, maríjintiña. ");
INSERT INTO cabNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ábame gúnda ban, ladǘga siñáti jafáyeirunibu, bibíjubeiti bafáyeiruaja lídaanme le jásaarun ja richáguabaña ligíbugiñe Búngiu lídaangiñe oúweni. ");
INSERT INTO cabNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Dan le lagáambunbalin ában jádaangiñe ja ñúnbaña luágu dábula cátei le, ába laríñagun lun Jesúsu. —Gúndaabaña gürígia ja eígibaña lídan larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ábati laríñagun Jesúsu lun. —Ñíñein ában wügǘri, íchuguti ában oúnwenbun adíneruni, ába loúnajan amísuraja sarágu gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Óra lun adíneruni, aba loúnajani lumúsun aríñaga joun amísurajoútiña. “Queímoun, aráanseeli sun cátei.” ");
INSERT INTO cabNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Súngubei, ába jaríñagun luágu siñá lan joúdin. Laríñaga furúmiñeti. “Sun líña nagáñijan ában fulásu, mósu nídin aríjei, ferúduna bána, siñáti nídin.” ");
INSERT INTO cabNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Laríñaga ában. “Agáñijaadina seíngü féru bágasu lánina wadágimanu, neíbuga oúchaña, adǘgabá fuleísei nun, ferúduna bána, siñáti nídin.” ");
INSERT INTO cabNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Laríñagaya ában. “Sun líña namárieidun, ligía siñá lubei nídin.” ");
INSERT INTO cabNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Dan le lagíribudun músu, ába labájüdaguni sun cátei le lun liyúbudiri. Ábati lagáñidun liyúbudiri, ába laríñagun lun músu. “Beíba lídan sun ǘma le ubúrugubei, banǘgañame gudémetiña, siñáguatiña úngua, danímaatiña, jáma maríjintiña.” ");
INSERT INTO cabNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Lárigiñe ladǘgüni, ába laríñagun músu lun liyúbudiri. “Nabúreme, adǘga náali le bubeíbei nun, níjein mémegua ubáraü.” ");
INSERT INTO cabNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ábati laríñagun iyúbudiri lun músu ligía. “Beíba lídan sun ǘma boúgudin lueí ubúrugu, lúma sun fulásu geyégua láu, ábame bafósuruniña sun ja badárirun lun jayábin lídoun nufédun, buin támuga núban. ");
INSERT INTO cabNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ladǘga naríñajare jun luágu úabei lan ni ában jádaangiñe ja namísurajabaña eígiti lídan nadíneragüdün.” ");
INSERT INTO cabNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sarágu jáña gürígia afálaruti Jesúsu, ába lagáraragun, ába laríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Siñáti nánigubei lan le jínsiñejabutimaati lun lúguchi, o lúguchu, o lúmari, o lisáanigu, o líbugañanu jáma lamúlenu, o lítunu, o libágari guánarügü, sügǘ náu. ");
INSERT INTO cabNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Le gíñe májabei lasúfurirun nueígiñe queísigubeirügü jamúga ában wügǘri le anǘgüti lugúruwan, siñáti náni lan disípulu. ");
INSERT INTO cabNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ánjein arítagua ában jídaangiñe ladǘgün ában wáyelesi, ¿ma funági lañúuruba furúmiñe asáminara átiribei lan lagástarun lun laríjini ánjein gabáfu lubeí lun lagúmuchuni? ");
INSERT INTO cabNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ladǘga ánjein líchiga ébuu, lárigiñeme lásiñerei wadágimanu agúmucha, jéjerajaba ja aríjubalin láu, ");
INSERT INTO cabNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","jaríñagame. “Guméseti wügǘri le ában wadágimanu, siñá lumuti agúmucha.” ");
INSERT INTO cabNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ánjein lawúribuja lubeí ában urúei lúma ámu urúei, ¿ma funági ñurúti furúmiñe lun lasáminarun ánjein gayáraabei lubeí lageíndagun jáu díisi mílu súdaara lúma le jáubei wein mílu? ");
INSERT INTO cabNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ánjeinti arítagua luágu siñábei lan, dánme le dísegili le ában urúei, ábame loúnajan aríñaga lun lun mawúribujan jamá, lun jebélurun lídoun idíli. ");
INSERT INTO cabNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ítara líña lubeíti, furúmieguarügü jídaangiñe le mígirunti sun le lúmabei lun lafálarunina, siñáti nánibei lan disípulu. ");
INSERT INTO cabNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","‘Buíti sálu, ánjein leféridira lubásuan, ¿cábagi un ju lan? ");
INSERT INTO cabNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mabuídunjali ni lun lábunawagún nádü lídan, ni lun lidérebugu múa, fíwarügaalime. Agáamba jumána, jugúya le garígeirugubei lun jagáambun. ");
INSERT INTO cabNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Luágu ában wéyu, ába jayárafadun sarágu agúburajatiña liseínsuna gumádi jáma gafígountiña lun Jesúsu lun jagáambuni. ");
INSERT INTO cabNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ába jadímurejan fariséogu jáma arúfudajatiña lilúrudun Moisés luágu Jesúsu lueígiñe cátei le, jaríñaga. —Wügǘri le, resíbi lumútiña gafígountiña, jou ligía jáma. ");
INSERT INTO cabNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ábati líchuguni Jesúsu jémpulu le joun, laríñaga. ");
INSERT INTO cabNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Ca jídaangiñe, lun jamúga galǘgüniña lan san mudún, leféridira ában jádaangiñe, mígirun lubáña gádürü-wein-díisi-néfu ñi, lubárua, lun lídin áluajoun mudún to eféridiruboun? ");
INSERT INTO cabNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Dan le ladárirunun, ába lanǘgünun légewagu láu ugúndani. ");
INSERT INTO cabNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Dan le lachǘlürün lúbiñoun, ába loúndaruniña lumádagu jáma lubésinanigu, laríñaga joun. “Gúnda jumá úara núma, ladǘga darína nilǘgün mudún tó yebe eféridiruboun nueí.” ");
INSERT INTO cabNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Naríñajare jun luágu ítara méme líña weíritima lan ugúndani siélu luágu ában gafígounti le asáansiruti luríban ligáburi lun lafálaruni Búngiu, sügǘ láu jawágu gádürü-wein-díisi-néfu gürígia richágutiña ligíbugiñe Búngiu ja memégeirunbaña jasáansiruni jagáburi. ");
INSERT INTO cabNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","‘¿Ca wǘri to níjeinti jamúga díisi murúsun seínsu túma, leféridira ában lídaangiñe tueí, lun mébedun tan lámpu, ába tabuídajanun múna áluajei buídu darí lun tadáriruni? ");
INSERT INTO cabNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Dan le tadáriruni, ába toúndaruniña tumádagu jáma tubésinanigu, taríñaga joun. “Gúnda jumá núma, ladǘga darína seínsu lé yebe neféridirubei.” ");
INSERT INTO cabNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Naríñajare jun luágu ítara líña lan gíñe ugúndani jádan láni Búngiu ánjeligu luágu ában gafígounti le asáansiraguti luríban ligáburi lun lafálaruni Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Rúlumuti gíñe Jesúsu jémpulu le joun, laríñaga. —Ñíñein méja ában wügǘri jáu bián lirájüñü. ");
INSERT INTO cabNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ába laríñagun le amúleñein lun lúguchi. “Núguchi, rúbei alágan le yúbei nun nun guetó.” Ába lafánreinjani úguchili alágan jádan biángubei. ");
INSERT INTO cabNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Málüti lueígiñe, ába loúndaruni amúleñein sun lumégegun, ába lídin díse lídoun ámu fulásu, ába lagástaruni liseínsun ñi lídan ában ibágari mabuídunti. ");
INSERT INTO cabNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Dan le gumújali sun liseínsun, ába ladágarun ában lemégeirun eígini lídan fulásu ligía, ába ladáiragun lúngua lídan ában oúnwenbun mégei. ");
INSERT INTO cabNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ábati lídin áluaja wadágimanu lúma ában lílana fulásu ligía, ába loúnajani wügǘri ligía oúnigiraña lilǘgüniña büíruju. ");
INSERT INTO cabNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Weíriti liláma darí lun lawámadun lun lun leígini jeígin büíruju, míchugúnwati lun. ");
INSERT INTO cabNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ábati lasáminarun, laríñaga lúnguarügü. “¡Sarágu ñadágimeintiña lúbiñe núguchi ígiraguati eígini joun, áu ya, oúwe niláma! ");
INSERT INTO cabNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nagíribuda le ñíjin lubeí núguchi, naríñagame lun. Núguchi, afígounjaadina ligíbugiñe Búngiu lúma bigíbugiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Madǘnaali lun nanáangun núngua quei biraǘ, barǘbana quei ában jádaangiñe ñadágimeintiña búma.” ");
INSERT INTO cabNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ába lárügüdün ǘma lun lagíribudun lúbiñoun lúguchi. ‘Dísegi líña, ába laríjini úguchili irájü le, ába lagúdemedun lun. Ába leíbaagun lubároun, ába loúburuni, ába lachúuruni. ");
INSERT INTO cabNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ábati laríñagun isáani lun. “Núguchi, afígounjaadina ligíbugiñe Búngiu lúma bigíbugiñe, madǘnaali lun nanáangun núngua quei biraǘ.” ");
INSERT INTO cabNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ába laríñagun úguchili joun lumúsuniña. “Sagájumoun tubuídun-ágei anáanguni furése, daǘguagüda jumeí. Daǘjuma giñe ában bágü luágu lújabu túma geídi luágu lugúdi. ");
INSERT INTO cabNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Áfara jumeí liraǘraü bágasu le dibúnetimaabei. ¡Weíga, eféduja wagíame!, ");
INSERT INTO cabNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ladǘga niraǘ le, rúnaali yebe quei jiláali áni chülǘguaya, féridijalí yebe áni daríwama.” Ába jagúmeserun eféduja. ");
INSERT INTO cabNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‘Súnti buga dan le, níjeinti buga íbugañaü áraabu. Dánti le lagíribudun, dan le lachǘlürün tubádun múna, ába lagáambuni áfaruni lúma abínajani. ");
INSERT INTO cabNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ábati lagúarun lun ában jádaangiñe músu, ába lálügüduni ca lan susérebei. ");
INSERT INTO cabNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ába laríñagun lun. “Chülǘjali bamúlen, áfaragüdalá búguchi liraǘraü bágasu le dibúnetimaabei, ladǘga lachǘlürün láu magádiei.” ");
INSERT INTO cabNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ába lagáñidun íbugañaü, májaali lebélurun. Ába láfuridun lúguchi, ába layúmuragun lun lun lebélurun. ");
INSERT INTO cabNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ába laríñagun lun lúguchi. “Subúdi bumúti luágu seríwijadina lan bun sarágu dan, madǘraagunganeí le bubeíbei ni ában weíyaasu, míchugidibu ni ában liraǘraü gábara nun lun nefédujan jáma numádagu. ");
INSERT INTO cabNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Guetóti, láu liábin biraǘ le, le achágarubalin biseínsun jáma würíña wuríbatiña, ¡áfaragüdabá bágasu le dibúnetimaabei!” ");
INSERT INTO cabNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ábati laríñagun úguchili lun. “Niraǘ, amǘrü númañadibu súnwandan, sun le náni, báni. ");
INSERT INTO cabNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ánjein guetó, lúnti wadǘgün fédu lúma lun wagúndaarun ladǘga bamúlen lé yebe rúwamaalíbei quei jiláali, chülǘguaya, féridijalí yebe, áni daríwama.” ");
INSERT INTO cabNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Aríñagati gíñe Jesúsu joun láni disípulugu. —Ñíñein méja ában iyúbudiri rísiti, ñíñein gíñe ában loúniri lumégegun, ába jayábin aríñaga lun luágu lachágaruñein lan oúnigiruti ligía lirísin. ");
INSERT INTO cabNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ábati lagúarun iyúbudiri lun, ába laríñagun lun. “Ída liñásan cátei le, le aríñawagúbei nun buágu? Rúba fe nun luágu buwádigimari, ladǘga masígijadibu oúnigirei nílagu.” ");
INSERT INTO cabNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ábati leréderun oúnigiruti ligía asáminara, laríñaga lúnguarügü. “¿Cábati nadǘga guetó lárigiñe gidála lan niyúbudiri wadágimanu nueí? Méretina lun nadǘgün wadágimanu jǘrüti, áni nibúsigaritina lun namúriajan. ");
INSERT INTO cabNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Subúdi náali cába lan nadǘga lun ñí jama erésibirutina jábiñe dánme mawádigimarijadina.” ");
INSERT INTO cabNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ába loúnajan jawágu ja adúweirubalin liyúbudiri lun jayábin lun ában ában. Ába lálügüdüni le furúmiñeti, laríñaga lun. “¿Átiri badúweiruni niyúbudiri?” ");
INSERT INTO cabNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ába laríñagun lun. “Dúwei numúti san barín agǘlei.” Ábati laríñagun oúnigiruti ligía lun. “Nuján bigáradan, ñurúba furése, badǘgame ában luágurügü dimí-san.” ");
INSERT INTO cabNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Lárigiñe, ábaya lálügüdün ában, laríñaga lun. “Ángi amǘrü, ¿átiri badúweijan?” Laríñaga lun. “San ságü türígu.” Laríñagati lun. “Nuján bigáradan, adǘgabá ában luágurügü gádürü-wein.” ");
INSERT INTO cabNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ába lasúbudiruni iyúbudiri luágu chu lan láu oúnigiruti ligía lídan ligáburi ladǘgüni cátei. Ligía laríñagun Jesúsu. —Gürígia wuríbatiña ja lánina uboú le, chúti jáu lídan jáni jáma ámu sügǘ jáu ja lánina larúgounga, ja lirájüñü Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Siñáti leménigidún luágu irísini lánina uboú le, aríñagatina lubeíti jun lun jayúsuruni jirísin lun jadǘgün buíti, lun dánme lan le lagúmuchun jibágari, jerésibirúba tídan múna to magúmuchaditu, yágüta siélu. ");
INSERT INTO cabNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","‘Le adǘgüti buíti láu le murúsunrügüti, ladǘgüba gíñe buíti láu le gíbeti, le madǘgünti buíti láu le murúsunrügüti, madǘgünbei gíñe buíti láu le gíbeti. ");
INSERT INTO cabNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ánjaün lubeíti madǘgün buíti láu buri irísini le láni uboú le, le uágubei siñá lan leménigidún, ¿cábagi afíñera juágu lun ledéregerun irísini inárüniti lábugiñe jaríaajan? ");
INSERT INTO cabNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ánjaünti madǘgün buíti láu jemégen ámu, ¿cábagi íchigei le jáni guánarügü jun? ");
INSERT INTO cabNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‘Siñáti lesériwidun ában gürígia joun bián iyúbudirigu, ladǘga liyéreeguduba ában lun, línsiñedame le ában lun, o úarabei lan lun ában, lanǘgeime le ában quei ni cáta. Siñáti lesériwidúniwa lun Búngiu lúma lun seínsu. ");
INSERT INTO cabNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Agáambagu jáña fariséogu lun sun cátei le, ába jéjerajan láu Jesúsu, ladǘga jínsiñe lan seínsu joun. ");
INSERT INTO cabNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ábati laríñagun Jesúsu joun. —Jugúya gürígia ja arúfudagubaña joúngua quei buítiña jagíbugiñe gürígia, ánjeinti Búngiu, subúdi lumútu janígi luágu wuríba tan. Le cátei le janǘgübei gürígia quei weíriti cátei, iyéreeguti lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","‘Níjein meja lilúrudun Moisés lúma jarúfudajan profétagu darí lúmoun lidáani Juan. Lúmagiñe dan ligía, lapúrichijoún ugánu buíti le luáguti larúeijan Búngiu, sun gürígia joúchatiña lun jebélurun lídoun. ");
INSERT INTO cabNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","‘Méreenguntimaati lun lagúmuchagun siélu lúma uboú, máma lun magúnfulirun lan liñǘraü-ágei dimúrei lídaangiñe lilúrudun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","‘Ánjoun lígira ában wügǘri lúmari, lagámarida ámu, ladǘgüñein figoú le gíribei adultériu, le gíñe agámariduti ában wǘri to ígiraguaaru, ladǘgüña gíñe adultériu. ");
INSERT INTO cabNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Aríñagati gíñe Jesúsu. —Ñíñein méja ában wügǘri rísiti, anáanguni fínutu to wéndegutu ladáüraguboun, ságüja wéyu ladáagun fédu láu sarágu wéndegu. ");
INSERT INTO cabNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ñíñein gíñe ában gudémeti gíriti Lázaro, sun lúra láu gumeín, ");
INSERT INTO cabNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","lañúurati buri múarugu tubéneri lúban rísiti ligía áluga leígini lífe eígini le eíguaduti lueígiñe lidábulan rísiti. Weíriti lasúfurirun darí lun lawánduni jayábin oúnli éjelujei lugúmein. ");
INSERT INTO cabNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Luágu ában wéyu, ába loúnwen fugiábu ligía, ába janǘgüni ánjeligu lúmoun Abrahám, le ñíjin jabeí jiláaña buítiña, ába gíñe loúnwen rísiti, ába lábunajoún. ");
INSERT INTO cabNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Dan le lasúfuriruña lan rísiti ligía lídan fulásu le ñíjin jabeí jiláaña wuríbatiña, ába liñúruni laríjin, ában laríjini Abrahám dísegiñe, láu Lázaro lúma. ");
INSERT INTO cabNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ábati lagúaragun, laríñaga. “¡Núguchi Abrahám, gudémená bun! Oúnajabeí Lázaro lun ladǘdüragüdüni ligíbu lújabu láu dúna, ñǘbin lámuga éderei tuágu niñéñe, ladǘga nasúfuriruña sarágu lídan wátu geméti le.” ");
INSERT INTO cabNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ába laríñagun Abrahám lun. “Niraǘ, jarítaguabá luágu buídu lán meja dan bun lídan bibágari, ánjein lun Lázaro, wuríbati meja dan. Guetó, buíti dan lun ya, bugúya asúfurira. ");
INSERT INTO cabNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Boúgudigiñe lueí sun le, níjein ában baráangu afánreinraguáwa júma, ja jamúga buséntiña joúdin yágiñe lun ñíjin, siñáti, ni ja ñíbaña, siñáti jayábin ñájoun.” ");
INSERT INTO cabNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ábati laríñagun rísiti. “Amúriajatina búma, Núguchi Abrahám, lun boúnajani Lázaro lúbiñe núguchi, ");
INSERT INTO cabNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","añájein seíngü namúlenu ñi, lun ladímurejan joun, mayábin jamámuga gíñe lídoun fulásu lánina asúfuriruni le.” ");
INSERT INTO cabNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ába laríñagun Abrahám lun. “Níjein le labǘrüjabei Moisés jáma profétagu jáma ñi, ¡adǘga jamá gásu láu!” ");
INSERT INTO cabNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ába loúnabun rísiti, ába laríñagun. “Binárün, núguchi Abrahám, láu sun líra, ánjein ñǘdün ában jádaangiñe jiláaña adímureja joun, lasáansiraguba jagáburi.” ");
INSERT INTO cabNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Laríñaga Abrahám lun. “Ánjein mája jabeí jadǘgün gásu láu le laríñagubei Moisés jáma profétagu, mafíñebañá giñe láu sun lásaarun ában jádaangiñe jiláaña lun lídin adímureja joun.” ");
INSERT INTO cabNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ába laríñagun Jesúsu joun láni disípulugu. —Súnwandan níjeinbei lán buri cátei afígougüdüti gürígia, ¡áni fugiábu gürígia le afígougüdüti ámu! ");
INSERT INTO cabNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Buítimaati jamúga lun lun lagurún baránajoun láu ában dǘbü le lamúlija awási güráñu luágu ligíina sügǘ láu lafígoungüdün ában jádaangiñe ja ñǘbürigiñabaña lídan jafíñen nuágu. ");
INSERT INTO cabNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ítara líña lubeíti toúnigi jumá. ‘Ánjein adǘga bamúlen o bíbugaña wuríbani bun, wéridibeí, ánjein asáansiragua ligáburi, ferúdunabeí, ");
INSERT INTO cabNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ánjein adǘga wuríbani bun sédü weíyaasu lídan ában wéyu, sédü weíyaasu liábin aríñaga bun luágu madǘgündügüya láali lan, lúnti ferúduna báni. ");
INSERT INTO cabNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ába jaríñagun apóstolugu lun Jesúsu. —Wabúreme, rúba lánwoun wafíñen. ");
INSERT INTO cabNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ábati laríñagun Wabúreme Jesúsu joun. —Lun jamúga níjein lan murúsuraü afíñeni jídan—gayáraati jamúga ñǘraüraü lan queísi ában tíla mostása—gayáraati jamúga jaríñagun tun tídibu wéwe to. “Gidába yágiñe láu sun bílagüle, beíba ájücha baránaja”, áni lasúsereduña jamúga. ");
INSERT INTO cabNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","‘Ánjein níjein lubeí lumúsun ában jídaangiñe, dan le lagíribudun áraabugiñe lárigiñe lawoújan o loúnigirun lan anímaalu, ¿laríñaguba funági lun músu ligía. “Belúba, ñurúba eíga”? ");
INSERT INTO cabNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Uá, aríñagarügübei lun. “Aráansebeí neígin, aráanseñu amǘrüme lun beténirun nun sun anája lan eíga lúma áta, lárigiñeme, gayáraajalíme beígin lúma bátun.” ");
INSERT INTO cabNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Teínqui lumúti funági iyúbudiri músu luágu ladǘgüni le lubeíbei lun? Uá. ");
INSERT INTO cabNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jugúya giñéti, dánme lásurun jadǘgüni le uágubei laríñaga Búngiu jun lun jadǘgüni, lúnti jaríñagun. “Músu moúntiña wagía, ladǘga lé rügǘñein lúnbei wadǘgüni wadǘga.” ");
INSERT INTO cabNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Lídan lasígiruni Jesúsu luweíyasun Jerusaléoun, ába lásügürün labádinaguagiñe Samária lúma Galiléa. ");
INSERT INTO cabNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Dan le lachǘlürünbei lídan ában liraǘraü fulásu, ába jayábin díisi wügǘriña gawágutiña gumeín, lubároun. Ába jeréderun díse lueí, ");
INSERT INTO cabNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ába jagúaragun lun ítara. —¡Jesúsu, Maésturu, gudéme wamá bun! ");
INSERT INTO cabNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Dan le laríjinbaliña Jesúsu, ába laríñagun joun. —Jeíba arúfudagua júngua joun fádirigu. Dánti le ídirina jamá, ába jareídagun. ");
INSERT INTO cabNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ñíñeinti ában jádaangiñe, dan le laríjinbei luágu areídaguaali lan, ába lagíribudun le ñíjin lubeí Jesúsu, adímurejeina buíti luágu Búngiu láu umálali jéreti. ");
INSERT INTO cabNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ába lájuduragun dagá ligíbu múarugu lun líchuguni eteíngiruni lun. Áni Samariána wügǘri ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ábati laríñagun Jesúsu. —¿Ma díisiñanu areídagutiña? ¿Jagáñagi ja jíbiri néfu? ");
INSERT INTO cabNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Niján gubeírügü teréncha le agíribuda eteíngirei Búngiu? ");
INSERT INTO cabNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ábati laríñagun lun wügǘri ligía. —Sarába, beíba, areídaguaadibu ladǘga bafíñen. ");
INSERT INTO cabNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ába jálügüdüni fariséogu Jesúsu ídaba lan lagúmesera larúeijan Búngiu, ába laríñagun joun. —Dánme le lagúmeserun larúeijan Búngiu, marijínbei, ");
INSERT INTO cabNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","maríñawagúnbei. “Niján”, o “Níngitan”, ladǘga lídan linárün cátei, níjeinjali larúeijan Búngiu jagánagua. ");
INSERT INTO cabNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ábati laríñagun joun láni disípulugu. —Lachǘlürüba dan lun meménija lánme janígi lun júmabadina lan, íbini luágurügü ában wéyu, masúseredunbei lídan dan ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Laríñawagúba jun. “Niján Crístu ya”, o “Níngitan yágüta.” Iyéenibei, mídin jumá járigi, mafálarun jumáñame. ");
INSERT INTO cabNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ladǘga ítara quei larijín ában labírijaníga lueígiñe ában loúba siélu lun luágun le ában, ítara lúba dánme le nagíribudun uboúagun, áu le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lúnti nasúfurirun sarágu furúmiñe, mebéresen jagíame gürígia ja lánina dan le náu. ");
INSERT INTO cabNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Queí meja lasúseredun lídan lidáani Noé, ítara lúba gíñe lasúseredun lídan búrime wéyu le niábingüle, áu le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Dán meja ligía, jerédera meja gürígia eíga, áta, agámarida, íchaajaña jarájüñü lun jamárieidun darí wéyu le lebélurun Noé tídoun ugúnein to árca. Ába liábin gúnran, ába jañáradagun súngubei. ");
INSERT INTO cabNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ítara lúba gíñe quei lasúseredun lídan lidáani Lot. jerédera gürígia eíga, áta, agáñija, alúguraja, ábunagua, adáagua múna. ");
INSERT INTO cabNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Dan le láfuridunbei Lot ubúrugugiñe Sodóma, ába láburujan wátu geméti lúma súfuru siélugiñe, ába láfaraguniña súngubei. ");
INSERT INTO cabNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ítara lúba dánme le niábin, áu le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","‘Lídaanme wéyu ligía, le gürígia le boúgudibei tueí lúban, ánjein níjein lubeí lumégegun múnada, mebéluralá aságarei. Le gürígia le áraabubei lídan óra ligía, magíribudalá lúbiñoun. ");
INSERT INTO cabNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Jarítagua jumá luágu le asúseredubei tun lúmari Lot. ");
INSERT INTO cabNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Le áluguti leséfuruni libágari ya uboúagu, leféridirubei ibágari magúmuchaditi, le ánjabei leféridiruni libágari ya uboúagu, nueígiñe, libíjuba ibágari magúmuchaditi. ");
INSERT INTO cabNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","‘Naríñajare jun luágu áriebu lánme ligía, ñíbaña biáma gürígia arúmuga tídan ában meme gabána, lanügǘba ában jádaangiñe, ígirúame le ában según jafíñen nuágu. ");
INSERT INTO cabNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ñíbaña biáma würíña amúlija lídan ában, tanügǘba ában jádaangiñe, ígirúame to ában. ");
INSERT INTO cabNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ñíbaña biáma wügǘriña áraabu, lanügǘba ában jádaangiñe, igirúame le ában. ");
INSERT INTO cabNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dan le jagáambunbalin cátei le, ába jálügüdüni, jaríñaga lun. —¿Jalíabasan lasúsereda buri cátei le, Wabúreme? Laríñaga joun. —Le ñí lumuti lúgubu jiláali, ñíba joúndaragua wadúbi. ");
INSERT INTO cabNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ába labájüdagun Jesúsu ában jémpulu joun, lun larúfudajan joun luágu lúnti lan jayúmuragun lun Búngiu súnwandan, láu gurásu. ");
INSERT INTO cabNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Laríñaga joun. —Ñíñein meja ában agúseragüdüti lídan ában fulásu, minébe líña Búngiu lun, mebéresen ligía láu ni ában gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ñíñoun gíñe ában wǘri lídan fulásu ligía, jilá meja túmari, ságü wéyu tídin lúmoun agúseragüdüti le lun líchuguni tirícha tun luágu ában tuwúribun lúma tágani. ");
INSERT INTO cabNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Luágu sarágu dan, májati yebe leténirun tun, lárigiñe, ába laríñagun lúnguarügü. “Láu sun minében lan Búngiu nun, mebéresen áu láu ni ában, ");
INSERT INTO cabNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","quei nuján méme lan wǘri to ásüdagüda nichǘgü, neséfuraaru, jebé lámuga tiábin, gumú líñein nugúraasun.” ");
INSERT INTO cabNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ába laríñagun Jesúsu. —Niján laríñagubei agúseragüdüti le wuríbabei, ");
INSERT INTO cabNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","gúbumeti leséfuraña Búngiu lánigu ja ayúmuragutiña lun wéyuagu, áriebu. ¿Lǘbei lubá líderaguniña? ");
INSERT INTO cabNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Uá, madárasanbei. Láu sun le, dánme le nagíribudun, áu le Wügǘri Garaǘwarügüti, uboúagun, ¿nadáriruba funásan afíñeni jádan gürígia ja yábaña, nuágu? ");
INSERT INTO cabNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Rúyati Jesúsu ában jémpulu joun ja jarítaguabaña luágu richágua jamá ligíbugiñe Búngiu, janǘgaña ámu gürígia quei ni cáta. Laríñaga. ");
INSERT INTO cabNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ñǘdütiña bián wügǘriña témpulurugu ayúmuragua lun Búngiu, ában fariséo, ában agúburajati liseínsuna gumádi. ");
INSERT INTO cabNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Le fariséo, rára líña layúmuragun, laríñaga. “Búngiu, teínqui numútibu luágu mítaran nan quei jíbiri gürígia—jíwerutiña, wuríbatiña, salúfuritiña, mítaraantina gíñe quei agúburajati liseínsuna gumádi le. ");
INSERT INTO cabNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ayúnaratina bián weíyaasu lídan dimáasu lun nagúnfulirun búma, rúnumuti gíñe díisi gáwanün lídaangiñe ságü fiádürü le ebélurubei nun, bun.” ");
INSERT INTO cabNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ánjeinti agúburajati liseínsuna gumádi, ába leréderun díse, mabúseerunti ni lun liñúruni laríjin siélun, le luweírin lǘnabun lanáangun lúngua. Aboújarügüleí laníguagu láu igárigu, laríñaga. “¡Búngiu, gudémená bun, nugúya le gafígounti!” ");
INSERT INTO cabNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Naríñajare jun luágu giríbu lan agúburajati ligía lúbiñoun, resíbiñuleí Búngiu, máma fariséo ligía. Ladǘga le anáanguti lúngua weíri, ñǘraübei lanügǘn, ánjein le ñǘraübei lanáangun lúngua, weíribei lanügǘn. ");
INSERT INTO cabNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Anaajoúatiña gíñe irájüñü lun Jesúsu lun lagúrurun jawágu, dan le jaríjinbalin disípulugu cátei le, ába jadeínjan joun ja anáajabaliña irájüñü. ");
INSERT INTO cabNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ába laríñagun Jesúsu joun lun jasígirun anáajaña jarájüñü lun, ába laríñagun joun lánigu. —Ígira jumá lun jayábin irájüñü nun, mewéridija jumá lueí, ladǘga ja ítarabaña quei jagía, jagía lílanabaña larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ninárün jáu luágu le lan merésibirun lumúti larúeijan Búngiu láu afíñeni jarúmati líbe jafíñen irájüñü, mebélubei lídoun. ");
INSERT INTO cabNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ába lálügüdüni ában jádaangiñe ábutigu Jesúsu, laríñaga lun. —Maésturu buíti, ¿ca lúnbei nadǘgüni lun gayára lan nibíjini ibágari le magúmuchaditi? ");
INSERT INTO cabNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Laríñaga Jesúsu lun. —¿Ca uágu baríñaga nun “buíti”? Ában rügǘñein buíti, Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Subúdi bumúti gumádi. Maganoúabá túma wǘri gámaritu, máfarajabá, míwerujabá, mayéejabá luágu ni ában, inébe jamá bagǘbürigu bun. ");
INSERT INTO cabNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Laríñaga wügǘri ligía lun. —Gúnfulitina láu sun le lúmagiñe ñǘraügidina. ");
INSERT INTO cabNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Lídan le lagáambunbalin Jesúsu cátei le, ába laríñagun lun. —Mégeigili ában cátei lun badǘgüni. alúgurabeí sun le búmabei, ábame bíchuguni lebégi joun gudémetiña, ábame garísin ban siélu. Ábame bagíribudun, ábame bafálarunina. ");
INSERT INTO cabNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Dan le lagáambunbalin wügǘri ligía cátei le, ába lírudagun, ladǘga rísiti buídu. ");
INSERT INTO cabNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Dan le laríjini Jesúsu lírudagun, ába laríñagun. —¡Jénreenguti lun jebélurun rísitiña lídoun larúeijan Búngiu! ");
INSERT INTO cabNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Méreenguntimaati lun lásügürün ában caméyu lídaangiñe lujúyun ában agúsa sügǘ láu lebélurun ában rísiti lídoun larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ába jaríñagun ja agáambubalin. —¿Cáteiti gayáraabei lasálbarun? ");
INSERT INTO cabNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Laríñaga Jesúsu joun. —Le jásiñerubei gürígia adǘga, gayára lumúti Búngiu, ladǘga úati ni cáta siñáti lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Laríñaga Pédro lun. —Wabúreme, wagía, ígira wamáali sun le wámati lun wafálarunibu. ");
INSERT INTO cabNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ába laríñagun Jesúsu joun. —Ninárün jáu luágu furúmieguarügü lan le ígiruti lúban, o lagǘbürigu, o líbugañanu, o lamúlenu, o lúmari, o lirájüñü luágu larúeijan Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","libíjubatíma sarágu weíyaasu loúgiñe lídan uboú le, ibíjaleíme ibágari magúmuchaditi yágüta siélu. ");
INSERT INTO cabNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ába lagúarun Jesúsu joun láni dúusu apóstolugu jábugua, ába laríñagun joun. —Weíbuga Jerusalén guetó, le ñíba lubeí lagúnfulira sun le jabǘrüjabei profétagu nuágu, áu le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jedéregerubadina joun ja mámabaña juríu, jéjerajaba náu, anába jamáname, suégua. ");
INSERT INTO cabNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Jabeíchubadina, lárigiñeme, ábame jáfarunina jilágubei, áni násaaruba lídaangiñe oúweni luágu lǘrüwan wéyu lúnya nabágaridun. ");
INSERT INTO cabNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Úati gunfaráanda jamá ni cáta lídaangiñe cátei le, ibídiñegubeíti joun ca lan uágu ladímureja joun, darúguati laníchigu cátei le laríñagubei, joun. ");
INSERT INTO cabNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Dan le achǘlüreinaali Jesúsu ubúrugun Jericó, ñíñein ában maríjinti ñun láru ǘma amúriaja. ");
INSERT INTO cabNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Dan le lagáambunbei maríjinti ligía jásüüjan sarágu gürígia, ába lálügüdajan ca lan susérebei. ");
INSERT INTO cabNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ába jaríñagun lun luágu niján lan Jesúsu Nazarétna ásügüra ñígiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ábati lagúaragun, laríñaga. —¡Jesúsu, le ladǘgawagun Davíd, gudémená bun! ");
INSERT INTO cabNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ja lubá lubáabaña, ába jadeínjan lun lun lámanichun, ligíatima lagúaragun. —¡Ladǘgawagun Davíd, gudémená bun! ");
INSERT INTO cabNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ábati laráramagun Jesúsu, ába loúnajan anǘgei. Dan le yaráfaali lun, ába laríñagun lun. ");
INSERT INTO cabNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ca babúseerubei nadǘgün bun? Ába laríñagun lun. —Nabúreme, buséntina naríjin. ");
INSERT INTO cabNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Laríñaga Jesúsu lun. —¡Ibíjabeí baríjin! Areídaguaadibu ladǘga bafíñen. ");
INSERT INTO cabNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lídan meme óra ligía, ába laríjin maríjinti ligía, ába lafálaruni Jesúsu adímurejeina buíti luágu Búngiu. Sun gürígia ja aríjubalin cátei le, ába gíñe jadímurejan buíti luágu Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ábati lebélurun Jesúsu fulásurugun Jericó, ába lásügürün ubúrugugiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ñíñein ában wügǘri rísiti, gíriti Zaquéo, jábuti agúburajatiña liseínsuna gumádi. ");
INSERT INTO cabNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Buséntiti Zaquéo laríjini Jesúsu lun lasúbudiruni, siñáti laríjini ladǘga ñǘraüraüti lúgubu, áni gíbetiña gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Lúnti gayára lan laríjini, ába leíbaagun ubáraü, ába laweínrun tuágun ában tídibu wéwe sicómoro yaráfa lun le ñígiñeba lubeí lásügüra Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Dan le lásügürün Jesúsu ñígiñe, ába laríjin íñun, ába laríñagun lun Zaquéo. —Zaquéo, raríba furése, ladǘga lúnti neréderun búbiñe ugúñe. ");
INSERT INTO cabNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ábati larárirun Zaquéo furése, ába lerésibiruni Jesúsu lúbiñe láu ugúndani. ");
INSERT INTO cabNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dánti le jaríjini jíbiri gürígia cátei le, ába jagúmeserun adímureja luágu lídin Jesúsu erédera lúbiñe ában gafígounti. ");
INSERT INTO cabNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ábati laráramun Zaquéo, ába laríñagun lun Jesúsu. —Nabúreme, níchiga lamídan le númabei joun gudémetiña, áni ánjein íwerujaadina lubeí lueí ában gürígia láu eyéeraguni, náguyugüdüba gádürü weíyaasu sügǘ láu lun. ");
INSERT INTO cabNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Laríñaga Jesúsu lun. —Sálbañu jáña tílana múna to ugúñe, ladǘgawagun gíñe Abrahám amǘrü. ");
INSERT INTO cabNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ligía niábinbei uboúagu, áu le Wügǘri Garaǘwarügüti, lun náluajaniña lúma asálbaraña já yebe féridijañabaña. ");
INSERT INTO cabNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dan le añája lubeí gürígia agáambajei laríñaguni buri Jesúsu cátei le, ába labájüdagun ában jémpulu joun, ladǘga ayárafadeinaali lan lun Jerusalén áni jarítaguatiñáti luágu lagúmesera lan larúeijan Búngiu dan ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ábati laríñagun joun. —Ñíñein ában wügǘri íñugutiña lidújeñu, leíbugati wügǘri ligía lídoun ámu fulásu díseti lun líchugúniwa lurúeiteme lageíra, ábayame lagíribudun. ");
INSERT INTO cabNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Lubáragiñe láfuridun, ába loúnajan jawágu díisi jádaangiñe lumúsuniña, ába ledéregerun ában seínsu le gebégiti sarágu lun cáda ában, ába laríñagun joun. “Agárabaja jumeí seínsu le darí nagíribudun.” ");
INSERT INTO cabNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Queíti liyéreegunbei wügǘri ligía joun lílana fulásu, ába joúnajan lárigi lun jaríñagun lun le lúnbei líchuguni ubáraü lun luágu mabúseerun jamáni lun jarúeiteme. ");
INSERT INTO cabNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Láu sun líra, resíbiwati lun urúeime, ába lagíribudun lageíroun. Dan le lachǘlürün, ába loúnajan jawágu lumúsuniña já buga únbaña líchigei seínsu lun lasúbudiruni átiriñein lan lagáñirun cáda ában. ");
INSERT INTO cabNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ába liábin le furúmiñeti, ába laríñagun. “Nabúreme, gáñeitina díisi weíyaasu ligíbuagun biseínsun.” ");
INSERT INTO cabNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Laríñaga urúei lun. “Buíti, ában músu buíti bugúya. Quei úara bubeí lídan le murúsunrügüti, níchigaadibu agúmadija lídan díisi fulásu.” ");
INSERT INTO cabNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ábaya liábin ában, ába laríñagun. “Nabúreme, gáñeitina seíngü weíyaasu ligíbuagun biseínsun.” ");
INSERT INTO cabNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ába gíñe laríñagun lun. “Bagúmadija lídan seíngü fulásu.” ");
INSERT INTO cabNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ábati liábin ában, ába laríñagun. “Nabúreme, niján biseínsun, areída numúti tídan ában músue ladǘga nanúfude bueí, ");
INSERT INTO cabNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ladǘga ában ban wügǘri derégüdati, reídeitibu láu cátei le mawádigimaritibu luágu, alúbaja amǘrü le ñí lumuti mábunagun ban.” ");
INSERT INTO cabNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ábati laríñagun urúei lun. “Músu wuríbati, luágu guánarügü berérun nagúseragüdábu. Quei subúdi bubálin luágu ában nan wügǘri derégüdati, luágu reídei nan láu cátei le mawádigimaritina luágu, alúbaja áu le ñí lumuti mábunagun nan, ");
INSERT INTO cabNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿cáti uágu míchububalin niseínsun báncürugun lun jamúga lagánwoundun dan le nagíribudun?” ");
INSERT INTO cabNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ába laríñagun joun ja ñíbaña. “Gidájumei seínsu lueí, rújumei lun le díisibei lúma.” ");
INSERT INTO cabNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ába jaríñagun lun. “Wabúreme, níjeinga díisi seínsu lúma.” ");
INSERT INTO cabNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ába laríñagun urúei. “Naríñajare jun luágu sun lan le adǘgati buíti láu le lúmabei, libíjuba lánwoun, ánjein le madǘgünti ni cáta buíti láu murúsun le lúmabei, lagídarúaba murúsun ligía lueí. ");
INSERT INTO cabNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Játi náganiñu, já yebe mabúseerúnbaña lun urúei nan, barǘjumaña ñájoun, áfaragua jumáña jilágubei nigíbugiñe.” ");
INSERT INTO cabNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Lárigiñe laríñaguni Jesúsu cátei le, ába lasígiruni luweíyasun Jerusaléoun jáu lánigu, ligía jabá jabá. ");
INSERT INTO cabNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dan le chülǘ mémeeli lídoun buri fulásu le Betfajé lúma Betánia, yaráfa lun wǘbü le gíribei Olívos, ");
INSERT INTO cabNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ába laríñagun joun biáma jádaangiñe láni disípulugu. —Jeíba lídan liraǘraü fulásu le wagíbugiñebei, dánme le jachǘlürün ñi, jadáriruba ában burígü güráñu le maweinrúngili. Jafáragadeíme, ábame janǘgüni ñájoun. ");
INSERT INTO cabNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ánjaün álügüdǘwa ca lan uágu jafáragadei, jaríñagame luágu busén láani Jabúreme. ");
INSERT INTO cabNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ába joúdin, ába jadáriruni ítara quei laríñaguni Jesúsu joun. ");
INSERT INTO cabNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Dánti le añája lubeí afáragadei burígü, ába jálügüdüniña labúriña, jaríñaga joun. —¿Ca uágu jafáragadei burígü le? ");
INSERT INTO cabNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ába joúnabuniña. —Ladǘga busén láani Wabúreme. ");
INSERT INTO cabNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ábati janǘgüni lun Jesúsu, ába jíchugunun janáangun lanágawagun burígü, ába jaweínragüdüni Jesúsu luágun. ");
INSERT INTO cabNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Quei awáansereina lan Jesúsu, átulejeina jamoún janáangun luágu ǘma lubá. ");
INSERT INTO cabNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Dan le jayárafadun lun larárirún wǘbü le Olívos, ába jagúmeserun sun lánigu Jesúsu ja afálarubalin agúaraja láu ugúndani lúma adímureja luágu luweírigun Búngiu, luágu buri miláguru le jaríjibei. ");
INSERT INTO cabNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jaríñaga. —¡Biníwati urúei le ñǘbinbei lídan líri Wabúreme Búngiu! ¡Níjein ñurúguaü siélu, lúma uweírigu lun Búngiu! ");
INSERT INTO cabNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ábati jaríñagun fariséogu ja ñíbaña jádan gürígia lun. —Maésturu, aríñagabá joun bánigu lun jámanichun. ");
INSERT INTO cabNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Laríñaga Jesúsu joun. —Ninárün jáu luágu ánjaña lan ámanichaja ja, lagúarajaba lán buri dǘbü nuágu. ");
INSERT INTO cabNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Dan le layárafadun lun Jerusalén, dan le laríjini ubúrugu ligía, ába layájuajan jawágu lílana fulásu ligía, laríñaga. ");
INSERT INTO cabNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—¡Lun jamúga gunfaráanda jumáni ugúñe luágu áu lan ǘmabei lun ñurúguaü jun, buíti jamúga! Májatün. ");
INSERT INTO cabNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ligía lachǘlürüba lubeí wéyu buri wuríbati jun, jadǘgame jáganiñu ában baríeru geyégua láu jubúrugute lun siñá lan jáfuridun ñígiñe, ábame jageíndagun júma lídaangiñe sun oúbaü. ");
INSERT INTO cabNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Jagǘnrinchagubei jufúlasun le gumúti, mígirunbaña ni ában dǘbü ligíbuagu dǘbü, jáfarúaba sun jugúya, ladǘga mebéresen jumá láu óra le liábinbei Búngiu asálbaraün. ");
INSERT INTO cabNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ábati lebélurun Jesúsu témpulurugun, ába laságaruniña ja alúgurajabaña jáma ja agáñijabaña ñi. ");
INSERT INTO cabNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Laríñaga joun. —Laríñajare tídan Lerérun Búngiu. “Núban, fulásu le ñí lubei gayára lan jayúmuragun gürígia nun”, ánjein jugúya, barǘjumaaru quei jában jíwerutiña. ");
INSERT INTO cabNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ságü buri wéyu larúfudajan Jesúsu témpulurugu, añájati jábutigu jafádirigun juríu jáma arúfudajatiña lilúrudun Moisés, jáma gíñe lábutigu fulásu áluaja ída lúba lan jáfaruni jilágubei, ");
INSERT INTO cabNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","madáritiña ída lúba lan jadǘgüni ladǘga weíri lan joúrabajoúniwa sun gürígia lun jagáambuni lerérun. ");
INSERT INTO cabNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Luágu ában wéyu, dan le témpuluruguñein lubeí Jesúsu arúfudaja joun gürígia, apúrichijei ugánu luáguti asálbaruni, ligía jayábin jábutigu jafádirigun juríu, jáma arúfudajatiña lilúrudun Moisés, jáma wügǘriña weírigutiña lídan jafíñen juríu, ");
INSERT INTO cabNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ába jaríñagun lun. —Aríñagabeí woun ca lan biríchabei lun badǘgüni cátei le. ¿Ca íchugubalin ubáfu le bun? ");
INSERT INTO cabNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ábati laríñagun Jesúsu joun. —Nálügüdáadün gíñe ában cátei, oúnaba jumána. ");
INSERT INTO cabNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ca oúnajabalin Juan abásteragüdaja? ¿Loúnajan Búngiu ódi joúnajan wügǘriña? ");
INSERT INTO cabNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ába jagúmeserun aríñaga jámagua. —¿Cába waríñaga? Ánjawa aríñaga luágu loúnajan lan Búngiu, laríñagame woun ca lan uágu mafíñerun wabeí lun. ");
INSERT INTO cabNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ánjawa aríñaga luágu joúnajan lan wügǘriña, jachámuraguba gürígia dǘbü wawágun, ladǘga choúru jamúti luágu proféta lán meja Juan. ");
INSERT INTO cabNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ábati jaríñagun luágu ibídiñe lan joun ca lán meja oúnajabalin Juan abásterágüdaja. ");
INSERT INTO cabNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ábati laríñagun Jesúsu joun. —Maríñagun nubeí gíñe jun ca lan áu ubáfu nadǘgei buri cátei le. ");
INSERT INTO cabNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ába lagúmeserun Jesúsu adímureja joun gürígia, ába labájüdagun ában úraga le gíbebei laníchigu, joun. Niján úraga ligía. —Ñíñein meja ában wügǘri ábunaguti beíbei lichárirugu, lárigiñe, ába lájayajani lichári joun ñadágimeintiña, ába lídin lídoun ámu fulásu luágu sarágu dan. ");
INSERT INTO cabNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Dan le lachǘlürün lidáani alúbajani, ába loúnajan ában lumúsun anǘgei lufánran, ába jabúleiseiruni ñadágimeintiña músu ligía, ába joúnajani lárigoún, míchugunga ni cáta lun. ");
INSERT INTO cabNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ábayati loúnajan ábanya músu, ába gíñe janábuni, buleísei jameí, oúnaja jameí, míchugunga ni cáta lun. ");
INSERT INTO cabNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ábaya loúnajan ábanya, ábaya gíñe jabúleiseiruni, ába jabúguni ñígiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‘Ába laríñagun labúreme ichári lúnguarügü. “¿Cábasán funa nadǘga? Noúnajaali niraǘ le jínsiñebei nun, dánme le jaríjini, fágua inébebei joun.” Ába loúnajani. ");
INSERT INTO cabNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dan le jaríjinbalin, ába jaríñagun jámagua. “Niján le lúnbei lerésibiruni alágan, wáfaraali jilágubei, wagía lámuga labúriña sun cátei.” ");
INSERT INTO cabNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ábati jaságaruni lídaangiñe fulásu ligía, ába jáfaruni jilágubei. Ábati lálügüdajan Jesúsu, laríñaga. —¿Cábati ladǘga labúreme ichári? ");
INSERT INTO cabNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Liábinme, ábame láfaraguniña ñadágimeintiña jagía jilágubei, ábame líchuguni ichári joun ámu. Dan le jagáambunbalin cátei le, ába jaríñagun. —¡Masúsereda lámuga ítara! ");
INSERT INTO cabNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ába laríaguniña Jesúsu, ába laríñagun joun. —¿Cáti lílabei le bürǘñubei tídan Lerérun Búngiu le ñí lubei laríñaga. Lé meja dǘbü le mabúseerun jabeí ábunagutiña, ligíaali furúmiñeti? ");
INSERT INTO cabNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Furúmieguarügü le achúgeraguti luágu dǘbü ligía lagǘnrinchaguba, léti uágunti láburuja, labúrechagúbei. Áu dǘbü ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Lídan meme óra ligía, ába jálugun jábutigu jafádirigun juríu jáma arúfudajatiña lilúrudun Moisés járügüdüni Jesúsu, ladǘga jasúbudiruni luágu jawáguti lan jémpulu le laríñagubei, madǘgün jamúti ladǘga janúfude jaweí gürígia. Ábati jagúrabajan ámu dan. ");
INSERT INTO cabNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ábati joúnajan gürígia ja ásügürütiña joúngua camá jamuga jarúmatiña lun jaríaajani Jesúsu, lun jaríñagagüdüni cátei le gawáguti gayára lan jíchugun lidúnrun lun jedéregeruni lun gumádimati. ");
INSERT INTO cabNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ligía jálügüdünbalin, jaríñaga lun. —Maésturu, subúdi wamúti luágu richá lan le baríñagubei lúma gíñe le barúfudajabei, manúfudetibu gíñe lueí ni ában, ladǘga ni cáta lan luweírigun gürígia bun, áni láu inárüni barúfudajei lémeri Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Aríñagabá ában cátei woun. ¿buíti lun lafáyeijoún seínsu lun warúeite César ódi mabuídunti? ");
INSERT INTO cabNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ába lasúbudiruni Jesúsu luríban jarítagun, ába laríñagun joun. —¿Ca uágu jabúseera jíchugun sádara nubá? ");
INSERT INTO cabNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Arúfuda jumá ában lídaangiñe seínsu ligía nun. ¿Cá iyáwa lúma íri le bürǘñubei luágu? Jaríñaga lun. —Láni César. ");
INSERT INTO cabNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ábati laríñagun joun. —Le láni César rújumei lun César, le láni Búngiu rújumei lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Siñá jamútiti áburugüda tídoun jasádaran láu lé buri laríñagubei jagíbugiñe gürígia, weírirügüti janígi láu loúnabagüle joun. Ába jámanichun. ");
INSERT INTO cabNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Lárigiñe, ába joúdin saduséogu aríjei Jesúsu. Jaríñajare saduséogu luágu másaarunbaña lan jiláaña lídaangiñe oúweni lúnya jabágaridun. Ábati jaríñagun lun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maésturu, laríñajare Moisés woun tídan lilíburun, luágu ánjein lan oúwe ában wügǘri, ába lígirunun lúmari marájüñüga ligía táu, lúnti lan lamárieidun lamúlen túma lun garájüñü lan táu, gadǘgawagun lámuga líbugaña le oúwebei. ");
INSERT INTO cabNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Wel, ñíñanu mejáti sédü wügǘriña gamúlenuguátiña, ába lamárieidun le furúmiñeti, ába loúnwen marájüñüga. ");
INSERT INTO cabNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ába lamárieidun le jabíaman túma buga lúmari íbugañaü, ába gíñe loúnwen marájüñüga. ");
INSERT INTO cabNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ábati lamárieidun le jǘrüwan túma, chülǘ lúmoun le jasédün, jilágua meme jagía, marájüñüga táu. ");
INSERT INTO cabNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ába gíñe toúnwen wǘri tugúya. ");
INSERT INTO cabNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Aríñagabá ában cátei woun. dánmeti le jásaarun lídaangiñe oúweni lúnya jabágaridun, ¿cábati úmari wǘri to jádaangiñe, quei maríei tubeí jáma sédügubei? ");
INSERT INTO cabNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ába laríñagun Jesúsu joun. —Lídan uboú le, maríeitiña wügǘriña jáma würíña, ");
INSERT INTO cabNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ánjein lídaanme dan le lúnbei liábin, úabei agámariduni siélu jádan ja garíchabaña lun ásaaruni lídaangiñe oúweni lúma lun jebélurun siélun agánawa ñi lun sun dan. Magámaridubaña ñi, míchaajan jamáñame jarájüñü lun maríei, ");
INSERT INTO cabNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ladǘga moúnwendügüyaaña gürígia siélu, ítaraañame quei ánjeligu, lirájüñü jañáme Búngiu ja saráaña lídaangiñe oúweni. ");
INSERT INTO cabNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisés guánarügü arúfuda lumúti luágu níjein lan ásaaruni lídaangiñe oúweni lídan le labǘrüjanbei luágu búbugati geméti. Laríñajare ñi luágu Búngiu lan Lubúngiutebei Abrahám, Isáac lúma Jacób. ");
INSERT INTO cabNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Láu dimúrei ligía, arúfuda lumúti Moisés luágu wínwangiña lan Abrahám, Isáac lúma Jacób, láu sun jilá lan jágubu, ladǘga máma Jabúngiute jiláaña Búngiu, Jabúngiute ja wínwangiñabaña. Wínwangiña lanǘgüniña Búngiu sun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ábati jaríñagun arúfudajatiña lilúrudun Moisés. —Buíti baríñaguni, Maésturu. ");
INSERT INTO cabNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ába málügüdagun jamáali lan. ");
INSERT INTO cabNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ába laríñagun Jesúsu joun. —¿Ída liñásan jaríñagunbei luágu ladǘgawagun lan Davíd Crístu? ");
INSERT INTO cabNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Laríñajare Davíd guánarügü tídan líburu to gíriboun Sálmos. Aríñagati Búngiu lun Nabúreme. “Ñurúba lueígiñe noúnwenren, ");
INSERT INTO cabNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","daríme níchuguniña báganiñu bújaburugun.” ");
INSERT INTO cabNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Ída lubáti ladǘgawagun lan Davíd Crístu, áni aríñagati Davíd guánarügü lun Crístu “Nabúreme”? ");
INSERT INTO cabNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ñíñanu sarágu gürígia agáambajei Jesúsu, ába jagáambun laríñagun joun láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Toúnigigua jumá júngua jaweí arúfudajatiña lilúrudun Moisés, ganígitiña jeíbugun táu anáanguni durúrutu, busén jagía lun labúsurún joun láu inébesei ǘmadarugu, áluaja jameí ubáraü le jabára weírigutiña tídan ligílisi, lúma lubuídun-ágei ubáraü lídan eígini. ");
INSERT INTO cabNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Gidá jamutu gíñe jában würíña ja jiláaña úmari jaweí, lúnti jadáuragun láu, ába jadǘgün furíeigi migínaguti. Weíribei jasúfurirun luágu sun le jadǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ába laríjin Jesúsu jíchaajan rísitiña seínsu tídoun buri gáfu to lágei seínsu témpulurugu, ");
INSERT INTO cabNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","aríja lumúti gíñe tíchugun ában wǘri jiláali túmari, gudémetu, bián gáwanün tídoun gáfu. ");
INSERT INTO cabNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ába laríñagun Jesúsu. —Ninárün jáu luágu gíbetima lan tíchugun fugiábu wǘri to sügǘ jáu súngubei, ladǘga sun jagía, lídaangiñe le ígiragubei jáma jíchiga, ");
INSERT INTO cabNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ánjoun tugúya, láu tugúdemegun tíchigei sun le túmabei lún yebe tawínwandun. ");
INSERT INTO cabNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jadímurejaña fiú gürígia tuágu témpulu, luágu tubuídunmeraü láu lubuídun buri tidǘbüri lúma buri cátei le jíchugubei gürígia lun tawéndedun. Ábati laríñagun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Lachǘlürüba wéyu lun lagǘnrinchawagún sun le jaríagubei tuágu témpulu to guetó, merédebei ni ában dǘbü ligíbuagu dǘbü. ");
INSERT INTO cabNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ábati jálügüdüni, jaríñaga lun. —Maésturu, ¿ídamé san lasúseredá buri cátei le? ¿Cábasan seíni waríja luágu dánjali lan lun lasúseredun? ");
INSERT INTO cabNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ába laríñagun Jesúsu. —Toúnigi jumá, mayeedúa jumá. Jayábinba sarágu aríñageina luágu áu lan jagía, jaríñagame. “Áu Crístubei”, “Niján dan ligía.” Mafíñera jumá joun, mafálara jumáña. ");
INSERT INTO cabNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dánme le jagáambun ladímurejoún luágu awúribujani lúma jawágu gürígia agárabagua luágun jarúeite, manúfudedagua jumá, lasúsereduba le furúmiñe, mámagilíme lagúmuchun uboú líra. ");
INSERT INTO cabNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ába lasígirun aríñaga joun. —Lageíndaguba ában fulásu lúma ában, awúribuja ligíame ában ageíraü lúma ámu. ");
INSERT INTO cabNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ñíbei oúnwenbun buri járabaganáli, ilámaü, sándi, lídan ámuñegueinarügü fulásu, larijúba buri cátei janúfunati siélu lúma oúnwenbun buri seíni. ");
INSERT INTO cabNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","‘Lubáragiñe lasúseredun sun le, járüjoúba, eíbaajoúa jugúyame. Janügǘba agúsera tídan jalígilisin juríu, jádarawagúba furísunrugun, barǘwa jugúyame jagíbugiñoún urúeigu jáma gumádimatiña, nueígiñe, lun jagúseragüdünün, ");
INSERT INTO cabNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ligíame jidáani lun jadímurejan luágu nufúleisein. ");
INSERT INTO cabNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aráanse jumeí jarítagun lun madíjeri jumá cába lan jaríñaga jueígiñegua, ");
INSERT INTO cabNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","níchuguba dimúrei lúma lichú áu jun le lásiñerun ni ában jádaangiñe jáganiñu asígenera ni oúnaba. ");
INSERT INTO cabNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Jalúgurubadün jagǘbürigu guánarügü, jíbugañanu, jamúlenu, jidújeñu, jumádagu. Jáfarúba jídaangiñe, ");
INSERT INTO cabNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","jiyéreeguduba joun sun gürígia, nueígiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lídaanme sun líra, latoúnigirubadün Búngiu le gumúti, ");
INSERT INTO cabNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","áni ánjaün meme derégüdagua lídan jafíñen nuágu, jibíjibei ibágari magúmuchaditi. ");
INSERT INTO cabNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","‘Dánme jaríjin geyégua jamá lan súdaara ubúrugu Jerusalén, subúdi jumeí luágu yaráfaali lan lagǘnrinchagun ubúrugu ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jámeti gürígia ja Judéabaña, lúnti janúrajan luágun buri wǘbü, ja ubúrugubaña Jerusalén, lúnti jáfuridun ñígiñe, ja áraabubaña, magíribuda jamá ubúrugun. ");
INSERT INTO cabNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Luwéyuri buríbei jafáyeirun gürígia luágu wuríbati le jadǘgübei, dánme le lagúnfulirún sun le bürǘwañubei tídan Lerérun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Fugiábugume würíña ja dageínatiña lídan dan ligía, o ja lan garájüñütiña ja gurágiña! Ladǘga ñíbei sarágu igárigu uboúagu, larúfudubei Búngiu luweírin ligáñi luágu jafígoun gürígia ja juríu. ");
INSERT INTO cabNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ñíbaña oúwegutiña wuríburugu, jíbiri janáawaguba adáürawagua lídoun ámu ageíraü, ábame jagǘnrinchaguni ja mámabaña juríu ubúrugu Jerusalén daríme lagúmuchun dan le íchugúbei joun lun jadǘgüni. ");
INSERT INTO cabNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","‘Lasáliragubáti buri seíni luágu wéyu, luágu játi lúma jawágu warúguma, ábame laweíridun janígi néchaanigu uboúagu, ábame janúfudedagun luágu lanárime lajúujan lúma laboúnjan lugúdi barána. ");
INSERT INTO cabNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ladágaruba falálaü jawágu gürígia láu anúfudei, láu jasáminarun luágu cátei le lúnbei lasúseredun, ladǘga járügüdüba lan warúguma ámu ǘma. ");
INSERT INTO cabNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ábameti larijín niábin, áu le Wügǘri Garaǘwarügüti, lídan juánriñu láu sun nubáfu lúma oúnwenbun nuweírigun. ");
INSERT INTO cabNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dánme le lagúmeserún buri cátei le asúsereda, ragǘjuma dǘgüdaguaü, iñúra jumeíme jichǘgü, ladǘga madíseelime jasálbarun. ");
INSERT INTO cabNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Rúlumuti gíñe jémpulu le joun. —Aríja jumoún tídibu ígo, o furúmieguarügü tídibu wéwe. ");
INSERT INTO cabNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Dan le jaríjin laboúchun tubána, subúdi jumúti luágu yaráfaali lan lidáani lubáchouga. ");
INSERT INTO cabNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Dánme gíñe le jaríjini lasúseredun buri cátei le, subúdi jumeí luágu madíseeli lan lidáani Búngiu lun larúeijan. ");
INSERT INTO cabNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","‘Ninárün jáu luágu lagǘnrinchawagúba lan sun ubúrugu le Jerusalén lubáragiñe joúwegun gürígia ja lánina dan le. ");
INSERT INTO cabNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lagúmuchaguba siélu lúma uboú, ánjein nerérun, ladúraruba lun sun dan. ");
INSERT INTO cabNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‘Toúnigi jumá, mígira jumá lun tabuínchun janígi láu cátei málati quei sarágu afúuduni, bacháruaü, lúma buri idíjeri luágu buri cátei lánina ibágari le, márügüdün lámugaün wéyu nagíribudagüle uboúagun lídan magáradajan jumá, ");
INSERT INTO cabNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","quei ában sádara to adárurutu. Ladǘga ítara lúba liábin wéyu ligía jawágun sun ja aganoúbaña lídan sun fulásu ya uboúagu. ");
INSERT INTO cabNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aráanseñu jumá lubeíti, ayúmuragua jumá lun Búngiu sun dan, gayára lámuga jibíjin ubáfu lun jawánduni sún buri cátei le lúnbei lasúseredun, lun giñe gayáraabei lan jarúfudagun júngua nigíbugiñe táu tarúman anígi. ");
INSERT INTO cabNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ábaja larúfudajan Jesúsu témpulurugu wéyuagua, áriebu, ábaja lídin erédera luágu wǘbü le Olívos. ");
INSERT INTO cabNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ábaja chülǘgiñe jamá gürígia témpulurugun ságü bináafin lun jagáambuni. ");
INSERT INTO cabNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yaráfaali fédu le lidáani teigíniwa fein to magánatu ísi, fédu le jarítaguagüle juríu luágu meja dan le lásügürünbei láni Búngiu ánjeli áfaraguaña jígirama Ejíptona, máfaragun lumútiña jígirama Israélitagu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ábati jáluajan jafádirigun juríu jáma arúfudajatiña lilúrudun Moisés ída lúba lan jáfaruni Jesúsu jilágubei, ibídiñounga joun gürígia, ladǘga janúfude jaweí. ");
INSERT INTO cabNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ábati lagáñeiruni Máfia larítagun Júdas Iscarióte, le ában jádaangiñe láni Jesúsu dúusu apóstolugu, ");
INSERT INTO cabNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ába lídin adǘga darádu jáma jábutigu jafádiriñegu juríu jáma jábutigu tisúdaarana témpulu lun ledéregeruni Jesúsu joun. ");
INSERT INTO cabNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ába jagúndaaragun, ába jaríñagun lun Júdas luágu jíchuguba lan seínsu lun, ");
INSERT INTO cabNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ába lañúurun darádu, ába lagúmeserun áluaja ída lúba lan gayára lan ledéregeruni joun dánme le úa jamá gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ába lachǘlürün fédu le ídaanbei teigúa fein magánatu ísi, ñí lubei gíñe ladágarawagüdǘwa mudún le lánina fédu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ába laríñagun Jesúsu lun Pédro lúma Juan. —Jeíba aráanserei eígini le lánina fédu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ába jálügüdüni. —¿Jalíagi babúseera waráanseruni? ");
INSERT INTO cabNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Laríñaga joun. —Dánme le jebélurun ubúrugun, jadúnraguba lúma ában wügǘri táu ában dináa láu dúna, jafálareime chülǘ tídoun múna to ñíjin lumúti lebélura. ");
INSERT INTO cabNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jaríñagame lun tabúreme múna. “Laríñajare Maésturu. ¿Jigóun rúmu to ñí lubei gayára lan neígini eígini le lánina fédu jáu náni disípulugu?” ");
INSERT INTO cabNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ábame larúfudun ában rúmu weíritu jun toúgiñegua múna, aráanseñu tíña, jaráansereime eígini ñi. ");
INSERT INTO cabNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ába joúdin, ába jadáriruni sun cátei quei laríñaguni Jesúsu joun, ába jaráanseruni eígini lánina fédu ñi. ");
INSERT INTO cabNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Dan le lachǘlürünbei óra, ába lañúurun Jesúsu jáu láni disípulugu luágu dábula, ");
INSERT INTO cabNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ábati laríñagun joun. —¡Oúnwenbun nabúseerun neígini eígini lánina fédu le júma lubáragiñe noúnwen! ");
INSERT INTO cabNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ladǘga naríñajare jun luágu meígindügüya náali lan eígini lánina fédu le daríme lagúnfulirún laníchigu lídan larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ábati lanǘgün ában wéru táu diweín lújaburugu, ába leteíngiruni Búngiu, laríñaga. —Barǘjumei le, fánreingua jumeí jídaangua, ");
INSERT INTO cabNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","naríñajare jun luágu mátundügüyaadina lan diweín daríme liábin larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Lárigiñe, ába lanǘgünun fein lújaburugu, ába leteíngiruni Búngiu tuágu, ába lagúbachagunun, ába líchugunun joun, aríñageina. —Núgubu le, le lúnbei ledéregerún juágu. Lúmagiñe guetó, adǘga jumeí le, jarítaguagüleme nuágu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ítara meme gíñe, lárigiñe jeígin, ába lanǘgüni wéru táu diweín, ába laríñagun. —Niján níta le lúnbei láwiyurun lídaangiñe núgubu juágu, lun lañúurun iséri darádu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","‘Niján wügǘri le lúnbei ledéregerunina wáma ya luágu dábula, ");
INSERT INTO cabNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","luáguñadina ǘma le lúnbei nanǘgüni, áu le Wügǘri Garaǘwarügüti, áni ¡fugiábutia wügǘri le lúnbei lalúgurunina! ");
INSERT INTO cabNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ábati jagúmeserun álügüdagua jádaangua cába lánfuna alúgurei. ");
INSERT INTO cabNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ába jasígenejan lánigu luágu cába lan jádaangiñe weírigutimá. ");
INSERT INTO cabNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ába laríñagun Jesúsu joun. —Lídan arúeijani lánina uboú le, agúmadijatiña já buri lurúeitena fulásu, camá jamuga labúreme jagía, já buri lábutigu fulásu, aríñawagúati jawágu luágu wügǘriña jamá ja gadǘgatiña fuleísei joun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ánjein lídan narúeijan, mítaraanti, lubáragiñe líra, le weírigutimaabei le tímatimaati jídan lúnti lanáangun lúngua quei le ǘnabutimaabei, le agúmadijabei, lúnti ítara lan quei le esériwijabei. ");
INSERT INTO cabNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Cági weírigutimaabei, le añúurubei eíga luágu dábula, ódi le esériwijabei? ¿Ma le añúurubei luágu dábula? Áni áu, ítara níña jídan quei le esériwijabei. ");
INSERT INTO cabNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","‘Jugúya úarabañája núma lídan noúchawagun, ");
INSERT INTO cabNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ligía níchugunbadün lun jarúeijan quei líchugunina Núguchi lun narúeijan. ");
INSERT INTO cabNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Jeígiba, gurá jugúyame luágu nidábulan yágüta siélu lídan narúeijan, ñurú jugúyame luágu buri lála urúei lun jagúseragüdüniña jadǘgawagun dúusu lirájüñü Israél. ");
INSERT INTO cabNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Aríñagati gíñe Wabúreme Jesúsu. —Simón, Simón, amúriajaali Máfia ǘma lúma Búngiu lun gayáraabei lan loúchagunün quei lawánijoún türígu, ");
INSERT INTO cabNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ibíja lumúti, áni ayúmuraguaadina buágu lun Búngiu lun meféridirun báani bafíñen nuágu lídaanme óra ligía. Áni dánme le bagíribudun nun, rúba dǘgüdaguaü joun bíbirigu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Laríñaga Simón lun. —Nabúreme, aráansetina lun nídin búma furísunrugun, o lun lan noúnwen búma. ");
INSERT INTO cabNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Laríñaga Jesúsu lun. —Pédro, ugúñe méme, beyéedaguba náu ǘrüwa weíyaasu lubáragiñe layúgurujan gáyu, baríñaguba luágu ibídiñe nan bun. ");
INSERT INTO cabNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ábati laríñagun Jesúsu joun. —Dan le noúnajanbalün maságüteiga, ni láu lágei seínsu, ni geídi, ¿ñíñein funági jemégeirun? Ába jaríñagun. —Uá Maésturu, memégeiruntiwa ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ábati laríñagun joun. —Ánjeinti guetó, le gaságüteti, barǘloun, barǘ ligíame lágei seínsu, le mefeínteti, alúguraloún labíte lun lagáñijan lefeínte, ladǘga wuríbati dan le. ");
INSERT INTO cabNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Naríñajare jun luágu lagúnfuliruba lan le taríñagubei Lerérun Búngiu nuágu. “Ába jabájüdüni jádan wuríbatiña.” Sun le bürǘwañubei nuágu lagúnfuliruña guetó. ");
INSERT INTO cabNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ábati jaríñagun. —Wabúreme, nuján bián efeín ya. Ába laríñagun joun. —Buíti. ");
INSERT INTO cabNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ábati láfuridun Jesúsu, ába lídin luágun wǘbü le Olívos quei ligáburiñaja, ába joúdin láni disípulugu lúma. ");
INSERT INTO cabNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Dan le jachǘlürün lídan fulásu ligía, ába laríñagun joun. —Jayúmuragua, meféridirun jumámugei jafíñen nuágu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ába ladísedun Jesúsu jaweí murúsunraü, ába lájuduragun ayúmuragua lun Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","laríñaga. —Núguchi, ánjabu busén, séfu bána lueí oúnwenbun asúfuriruni le lúnbei nasúfurirun, madügǘwalá le nabúseerubei, le la babúseerubei adügǘwa. ");
INSERT INTO cabNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ábati liábin ában ánjeli siélugiñe lun líchugun érei lun. ");
INSERT INTO cabNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Dan létima laweíridun ligárigu, ligíatima layúmuragun láu érei, lédedejati lísüga lueí camá jamuga oúnwenbun lédedejan jítaü, múarugun. ");
INSERT INTO cabNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Dan le lásaarun lídaangiñe layúmuragun, ába ladáriruniña disípulugu arúmuga, larúmagüdün íruni. ");
INSERT INTO cabNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ábati laríñagun joun. —¿Ca uágu jarúmuga? Sarájuma, jayúmuragua, meféridirun jumámugei jafíñen nuágu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ñígili Jesúsu adímureja, ligía jayábin sarágu gürígia, Júdas, le ában jádaangiñe dúusu disípulugu, jabá jabá. Aba layárafadun lun Jesúsu lun lachúuruni. ");
INSERT INTO cabNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ábati laríñagun Jesúsu lun. —Júdas, ¿láu ában chúuti balúgurana, áu le Wügǘri Garaǘwarügüti? ");
INSERT INTO cabNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Játi lúmabaña Jesúsu, dan le jaríjinbalin cába lan asúsereda, ába jaríñagun lun. —Wabúreme, ¿ageíndagua wamáña táu efeín? ");
INSERT INTO cabNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ába lánchuguni ában jádaangiñe lánigu Jesúsu larígei lumúsun fádiri íñutimaati, le loúnwenren. ");
INSERT INTO cabNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ába laríñagun Jesúsu. —Ígira jumáña, buídurügaali. Ábati lagúruruni Jesúsu larígei músu ligía, ába lareídagun. ");
INSERT INTO cabNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ába laríñagun joun jábutigu fádirigu, joun wügǘriña weírigutiña lídan jafíñen juríu, lúma joun jábutigu tisúdaarana témpulu, ja ñǘbinbaña anǘgei. —¿Jiábin nuágu táu efeín lúma wéwe camá jamuga jíwerutina? ");
INSERT INTO cabNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Dan lé meja júma nan témpulurugu ságü wéyu, magúrugubeitün nuágu, wel, niján jidáani lun jadǘgüni jugúndan náu, óraali lun lagúmadijan le labúremebei lubúriga. ");
INSERT INTO cabNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ábati járügüdüni Jesúsu, ába janǘgüni lúbiñoun fádiri le íñutimaabei, ábati lafálaruni Pédro dísegiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ába jáfuragun wátu ñi lamídaangua baríeru, ába jañúurun geyégu láu, ába gíñe lañúurun Pédro jádan. ");
INSERT INTO cabNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Queíti taríjini ában músu ñun larǘgürügü wátu, ába teréderun aríaguei, ába taríñagun. —Lúmañein buga gíñe Jesúsu gürígia le. ");
INSERT INTO cabNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ába leyéedagun Pédro, laríñaga. —Ibídiñeti wügǘri ligía nun. ");
INSERT INTO cabNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Murúsun lueígiñe, ábaya laríjini ában, ába laríñagun. —Jánigu gíñe amǘrü. Ába laríñagun Pédro. —Máma jánigu áu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Queí buri ában óra lárigiñe, ábaya laríñagun ában. —Inárüni luágu lúmañajañein lan wügǘri le ladǘga Galiléana gíñe. ");
INSERT INTO cabNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ábati laríñagun Pédro. —Ibídiñeti nun ca lan uágu badímureja. Lídan meme óra ligía, dan le nijángua lan Pédro adímureja, ába layúgurujan ában gáyu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ába ladígiragun Wabúreme Jesúsu aríja luágun Pédro, ába larítagun Pédro luágu lé buga laríñagubei Jesúsu lun. “Lubáragiñe layúgurujan gáyu ugúñe, beyéedaguba náu ǘrüwa weíyaasu.” ");
INSERT INTO cabNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ábati láfuridun Pédro, ába layájun láu igárigu. ");
INSERT INTO cabNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ja wügǘriña ja oúnigirubalin Jesúsu, ába jéjerajan láu, bei jameí. ");
INSERT INTO cabNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ába jagǘraguni lágu, ába jagáyuajan ligíbuagun, aríñageina jagía. —¡Bugúya le profétabei, aríñagabeígia ca lan agáyuajabei buágu! ");
INSERT INTO cabNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ába buri jaríñagun sarágu ámu cátei anábei. ");
INSERT INTO cabNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Dan le larúgadunbei, ába joúndaragun wügǘriña weírigutiña lídan jafíñen juríu, jábutigu jafádirigun juríu, jáma arúfudajatiña lilúrudun Moisés, ába janǘgüni Jesúsu ligíbugiñoún jadámurin le líñun-ágei lúrudu. Ába jaríñagun lun ñi. ");
INSERT INTO cabNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Aríñagabeí woun, ¿amǘrüsan Crístubei le lúnbei lasálbaruniña gürígia? Ába laríñagun joun. —Ánjana aríñaga jun luágu ánja lan, mafíñebadün nun, ");
INSERT INTO cabNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ánjaün nálügüdagua, moúnabun jubádina, mígiragüdün jumáname. ");
INSERT INTO cabNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Naríñaga ában cátei jun. lúmagiñe guetó, nañúuruba, áu le Wügǘri Garaǘwarügüti, lueígiñe loúnwenren Búngiu le Súnti Gabáfuti. ");
INSERT INTO cabNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ábati jálügüdüni súngubei. —¿Amǘrü lubeíti Liraǘbei Búngiu? Ába laríñagun Jesúsu joun. —Ánja, áu, quei jaríñaguni jugúya guánarügü. ");
INSERT INTO cabNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ábati jaríñagun. —Mabúseerunjadiwa geféen jamá ámu woun, agáamba wamáali lídaangiñe guánarügü liyúma. ");
INSERT INTO cabNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ábati jásaarun sun líñun-ágei lúrudu, ába janǘgüni Jesúsu ligíbugiñoun Piláto, ");
INSERT INTO cabNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ába jagúmeserun íchiga lidúnrun, jaríñaga. —Darí wamaali wügǘri le achágaraguágüdaña gürígia, laríñajare luágu moun lan lun wafáyeijan seínsu lun urúei Rómana, aríñagati gíñe luágu ligía lan Crístubei le lanúadirubei Búngiu lun lasálbaruniña gürígia, aríñaga ligía luágu urúei lan ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ábati laríñagun Piláto lun. —¿Amǘrüsan Jarúeitebei Juríu? Laríñaga Jesúsu lun. —Ánja, ítara líña quei baríñaguni. ");
INSERT INTO cabNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ábati laríñagun Piláto joun jábutigu fádirigu lúma joun jíbiri gürígia. —Madáritina dúru luágu wügǘri le. ");
INSERT INTO cabNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ábatima jaríñagun jére. —Lachágaraguágüdüñanu sun gürígia Judéana láu ligáburi larúfudajan, lagúmesera Galiléagiñe, niján mémegua adǘgei chülǘ ñájoun. ");
INSERT INTO cabNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Dan le lagáambunbalin Piláto cátei le, ába lálügüdajan ánjein Galiléana lubeí wügǘri ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Dánti le jaríñagun lun luágu Galiléana lan, ába loúnajani lun Heródes, le gumándan Galiléa, ladǘga ñíñein Heródes Jerusalén lídan dan ligía. ");
INSERT INTO cabNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ába lagúndaaragun Heródes dan le laríjini Jesúsu, ladǘga agáambañajaali lan luágu áni lǘja labúseerun laríjini, agúrabatiti laríjin ladǘgün ában miláguru. ");
INSERT INTO cabNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ába lálügüdaguni luágu sarágu cátei, moúnabunti Jesúsu ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ñíñanu jábutigu fádirigu jáma arúfudajatiña lilúrudun Moisés, magúmuti jíchugun lidúnrun. ");
INSERT INTO cabNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ábati loúseruni Heródes jáu lisúdaaranigu quei ni cáta, éjeraja jagía láu. Ábati jadáüraguagüdüni táu anáanguni wéndegutu quei lanáangun urúei, ábaya loúnajani Heródes lun Piláto. ");
INSERT INTO cabNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Wéyu ligía, ába gamádagua lan Heródes lúma Piláto, lubáragiñe líra, gáganiguañajatiña. ");
INSERT INTO cabNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ábati loúndaruniña Piláto jábutigu fádirigu jáma lúrudugu, jáma buri ámu gürígia, ");
INSERT INTO cabNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ába laríñagun joun. —Jugúya anǘgübalin wügǘri le nun, jaríñaga luágu chagáguagüda lániña gürígia, álügüdagua náali jigíbugiñe, áni aríja jumúti luágu madári nan ni murúsun dúru luágu lídaangiñe le jaríñagubei luágu. ");
INSERT INTO cabNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Madáriti gíñe Heródes lidúnrun, giríbugüdalá woun. Aríja jumáali luágu madǘgün lan ni cáta le lúnti lafarún jilágubei lueígiñe, ");
INSERT INTO cabNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","nabeíchagüdali lubeíti, lárigiñeme, ábame nígiragüdüni. ");
INSERT INTO cabNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Gagáburititi Piláto lúnja lígiragüdün ában adaürǘti fédurugu, ");
INSERT INTO cabNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ába jagúarajan súngubei lídan ában. —¡Áfarabeí le! ¡Ígiragüdabeí Barabási! ");
INSERT INTO cabNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabási ligía, ladaürǘña lueígiñe ligía lan ában jádaangiñe ja iñúragubaña joúngua luágu gumádi, lúma lueígiñe láfarajan. ");
INSERT INTO cabNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Busénti yebe Piláto lígiragüdüni Jesúsu, ábaya ladímurejan joun, ");
INSERT INTO cabNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ligíatima jagúaragun. —¡Dáguabeí luágu gurúwa! ¡Dáguabeí luágu gurúwa! ");
INSERT INTO cabNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ába laríñagun Piláto joun luágu lǘrüwan weíyaasu. —¿Cáti wuríbati ladǘgübei? Madáritina ni cáta le lúnti lafarún jilágubei lueígiñe. Nabeíchagüdali, ábame nígiragüdüni. ");
INSERT INTO cabNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ábatima jagúarajan lun ládarawagún luágu gurúwa, jéretiti jagúarajan jagía jáma jábutigu fádirigu, ába jabíjini le jabúseerubei. ");
INSERT INTO cabNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ábagubeíti ladǘgüni Piláto le jabúseerubei, ");
INSERT INTO cabNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ábati lígiragüdüni wügǘri le jabúseerubei, le adaürǘbei lueígiñe iñúraguni lúma áfarajani, ábati ledéregeruni Jesúsu joun lun jadǘgüni jagúndan láu. ");
INSERT INTO cabNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dan le joúdiña lan láu Jesúsu lun ládarawagún luágu gurúwa, ába járügüdün ában wügǘri Cirénena gíriti Simón, liábiña áraabugiñe, ába janǘgagüdüni gurúwa lun, ába lídin láu lárigi lárigi Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Sarágu jáña gürígia afálaruti jáma sarágu würíña jádan ayájuajeina, agúarajeina láu íruni luágu. ");
INSERT INTO cabNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ába ladígiragun Jesúsu jawágun, ába laríñagun joun. —Würíña Jerusalénna, mayájua jumá nuágu, jayájua juoúgua lúma jawágu jirájüñü, ");
INSERT INTO cabNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ladǘga liábinba buri wéyu dánme le laríñawagún. “Fuleíseiwatiña ja siñábei jagáraüdun jáma gíñe ja marájüñüjañábaña, jáma ja mátagüdajanbaña.” ");
INSERT INTO cabNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ábameti jaríñagun gürígia lun wǘbü íñuti. “Áburujabá wawágun”, aríñaga jagíame lun wǘbü ǘnabuti. “Darúguabá wáu.” ");
INSERT INTO cabNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ladǘga ánjein adǘgajabalin sun le láu tídibu wéwe le dǘdügili, ¿cábagi madǘgün jamá láu le mábeijali? (Ítara líña ladímurejan luoúgua, le madúnrunbei, lúma jawágu ja gadúnrunbaña.) ");
INSERT INTO cabNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Barǘtiña gíñe biáma gadúnruntiña lun jafarún úara lúma Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dan le jachǘlürünbei lídoun fulásu le gíribei Lufúlasun Lábu Ichǘgü, ába jádaraguni Jesúsu luágu gurúwa jáma gíñe biáma wuríbatiña jagía, ában lueígiñe loúnwenren, ában lueígiñe lubáüna. ");
INSERT INTO cabNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Dánti le añája lan ádaraguei Jesúsu luágu gurúwa, ába laríñagun. —Núguchi, ferúduna báña ladǘga ibídiñeti joun ca lan jadǘgübei. Ába jájurerun súdaara ubúnuruni lun jaríjin cába lan un jádaangiñe terédera lanáangun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ñíñanu gürígia aríagua, ñíñanu gíñe lúrudugu jéjerajaña láu, jaríñaga. —Sálbati ámu, sálbagualá gíñeti lúngua, ánjein inárüni lubeí luágu ligía lan Crístubei le lanúadirubei Búngiu lun lasálbaruniña gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Éjerajatiña gíñe súdaara láu, láu jayárafadun íchiga tagǘbüri diweín lun lun látunun, ");
INSERT INTO cabNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","jaríñaga buri lun. —Ánjein Jarúeite bubeí juríu, sálbaguabá búngua. ");
INSERT INTO cabNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ñíñeinti ában abǘrüjoúni loúgiñe lichǘgü, laríñajare ñi. “Niján Jarúeite Juríu.” ");
INSERT INTO cabNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ába lanábuni ában jádaangiñe wuríbatiña ja dáwagubaña luágu gurúwa ñi Jesúsu, laríñaga. —Ánjein bugúya lubeí Crístubei, sálbaguabá búngua, sálba báwame. ");
INSERT INTO cabNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ába ladeínjan le ában lun loúba, laríñaga lun. —¿Manúfudetibusan lueí Búngiu, bugúya le lábugiñebei ában meme súfuri lúma? ");
INSERT INTO cabNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wagía, garíchatiwa lun wasúfurirun ladǘga wafáyeijaña luágu wadǘga, ánjeinti wügǘri le, madǘgünti ni cáta wuríbati. ");
INSERT INTO cabNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ábati laríñagun. —Jesúsu, barítaguame nuágu dánme le lagúmeserun barúeijan. ");
INSERT INTO cabNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Laríñaga Jesúsu lun. —Ninárün báu luágu númabadibu lan siélu, ugúñe méme. ");
INSERT INTO cabNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Amídirugu, ába labúrigadun sun fulásu darí ladaǘnrün ǘrüwa rábounwéyu. ");
INSERT INTO cabNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ába labúrigadun wéyu, ába tajeíridagun tubélun témpulu tamídan túmagua. ");
INSERT INTO cabNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ábati lagúaragun Jesúsu ítara. —Núguchi, deréga numútu nuwáni bújaburugun. Quei laríñagun ítara, ába loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Dan le laríjinbalin jábuti súdaara Rómana le asúseredubei, ába ladímurejan weírigu luágu Búngiu, laríñaga. —Inárüni, madúnrunti buga wügǘri le. ");
INSERT INTO cabNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Sun gürígia ja ñíbaña, ja aríjubalin le asúseredubei, ába joúdin ñígiñe, áfarajeina jameí janíguagu, le jagárigu. ");
INSERT INTO cabNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ánjaña sun lumádagu Jesúsu jáma giñe würíña ja ñǘbinbaña úara lúma Galiléagiñe, ába jeréderun díse aríjei buri cátei le. ");
INSERT INTO cabNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ñíñein ában wügǘri gíriti José, lídaangiñeti fulásu le gíribei Arimatéa, le jafúlasun juríu. Buíti ligáburi wügǘri ligía, richáguati ligíbugiñe Búngiu, lídaañein líñun-ágei lúrudu le jáni juríu. ");
INSERT INTO cabNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Agúrabañu líñein larúeijan Búngiu, magúndaanti lubeíti láu cátei le ladǘgübei líñun-ágei lúrudu láu Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ábati lídin lúmoun Piláto, ába lamúriajani lúgubu Jesúsu lúma. ");
INSERT INTO cabNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Lárigiñe laráriragüdüni lueígiñe gurúwa, ába loúburaguni táu ában gamísa, ába lácharuni lídoun ában umúajaü achigíti luágu ában dǘbü le ñí lubei úagili lan ni ában abunúti. ");
INSERT INTO cabNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wándaradi wéyu ligía, luwéyuri aráansejani lubá luwéyuri eméraaguni joun juríu, áni agúñeeli gumése. ");
INSERT INTO cabNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ába jafálaruni würíña já meja ñǘbinbaña lúma Jesúsu Galiléagiñe José, aríja jameí umúajaü, aríja jameí buídu ída líña lan líchugún lúgubu Jesúsu lídoun umúajaü. ");
INSERT INTO cabNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dan le jagíribudunbei jábiñoun, ába jaráanseruni ibíñei buri le íchugúbei jawágu jiláaña, ábati jeméraagun lídan wéyu le eméraaguagülei quei laríñaguni lilúrudun Moisés. ");
INSERT INTO cabNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wéyu dimáasu, ába jagíribudun würíña luágun umúajaü, bináafingua, barǘina jameí ibíñei le jaráanserubei jámagua. ");
INSERT INTO cabNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dan le jachǘlürünbei, mámaali lídan lubára dǘbü le lidaǘ umúajaü. ");
INSERT INTO cabNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ába jebélurun lídoun umúajaü ligía, madári jamúti lúgubu Wabúreme Jesúsu ñi. ");
INSERT INTO cabNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Súnti añája lan ñi arítagua jageí lánfuna, ligía jaríjin bián wügǘriña rára jarúgabu táu anáanguni mirítu. ");
INSERT INTO cabNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Queíti jélemuchun láu jagíbu ǘnabun, buin láu anúfudei, ába jaríñagun wügǘriña jagía joun. —¿Ca uágu jáluajei le wínwanbei jádan jiláaña? ");
INSERT INTO cabNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Úati ya, saráali lídaangiñe oúweni. Jarítagua jumá luágu lé meja laríñagubei jun dan le Galiléañein lán meja, luágu le lúnbei lasúseredun lun, ligía le Wügǘri Garaǘwarügüti, ");
INSERT INTO cabNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","luágu ledéregerúaba lan jájaburugun gafígountiña, ábame jádaraguni luágu gurúwa, ábame lásaarun lídaangiñe oúweni luágu lǘrüwan wéyu. ");
INSERT INTO cabNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ábati jarítagun luágu dimúrei le laríñagubei Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Lárigiñeti jagíribudun umúajaürugúgiñe, ába jabájüdaguni sun cátei le asúseredubei joun únsu apóstolugu lúma joun jíbiri lánigu Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ja anǘgübalin ugánu le joun apóstolugu, María Magdaléna, Juána, María to lúguchu Jacóbo, jáma ja jíbiri würíña. ");
INSERT INTO cabNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Dan le jaríñagunbalin buri cátei le joun apóstolugu, ába janǘgüni quei lílülün áu, mafíñetiña joun. ");
INSERT INTO cabNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ába láfuridun Pédro, ába lídin eíbaagueina luágun umúajaü, dan le laríjinbei lurágeirugun, gamísa rügǘñoun ñi, úaali úgubu. Ába lídin lúbiñoun láu luweírin anígi láu cátei le laríjubei. ");
INSERT INTO cabNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Luágu méme wéyu ligía, joúdiña biáma jádaangiñe lánigu Jesúsu lídoun ában liraǘraü fulásu gíriti Emaús, ǘrüwa óra eíbuguni Jerusaléngiñe, ");
INSERT INTO cabNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","adímurejeina jáña luágu sun cátei lé buri asúseredubei. ");
INSERT INTO cabNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Súnti adímurejeina jamá, ába layárafadun Jesúsu joun, ába lagúmeserun eíbuga úara jáma. ");
INSERT INTO cabNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Láu sun aríja jamáni, siñáti jasúbudiruni luágu Jesúsu lan. ");
INSERT INTO cabNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ábati laríñagun joun. —¿Cásan le uágubei jadímureja, sun eíbugeina jumá? ");
INSERT INTO cabNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ába jaráramagun láu íruni jagíbuagu, ába loúnabun ában jádaangiñe, gíriti Cleofás, ába laríñagun. —Sun gürígia subúdi jamúti le asúseredubei Jerusalén lídoun buri wéyu le. ¿Amǘrü rügǘñein jádaangiñe ja ñíbaña ibídiñejabu lun? ");
INSERT INTO cabNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ábati laríñagun joun. —¿Cági asúseredubei? Jaríñaga lun. —Luáguti Jesúsu le Nazarétna, ában meja proféta láu ubáfu luágu le ladǘgübei lúma luágu lerérun ligíbugiñe Búngiu lúma jagíbugiñe sun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ábati jedéregeruni jábutigu wafádiriñegu jáma walúrudungu lun siádiwa lan lun oúweni lúma lun ládarawagún luágu gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Rúwamutí yebe wafíñen luágu ligíaba lan eséfurei linásiñun Israél. Ǘrüwa wéyu guetó lueígiñe lasúseredun cátei le. ");
INSERT INTO cabNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Láu sun líra, weírigüda jamáali jádaangiñe würíña ja wámabaña wanígi láu joúdin luágun umúajaü lubá buga larúgan, ");
INSERT INTO cabNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","queíti madári jamáni lúgubu ñi, ába jayábin abájüdagua woun luágu aríja jamá ánjeligu ñi, aríñaga jamá joun luágu wínwan lan Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ába joúdin jádaangiñe wíbirigu aríjei umúajaü, ába jadáriruni ítara quei jaríñaguni würíña jagía, maríjin jamúti Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ábati laríñagun Jesúsu joun. —¡Loúguati gíñe gunfaráanda jumá, lǘti gíñe lubá jafíñerun luágu lé meja jaríñagubei profétagu! ");
INSERT INTO cabNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ma funági lúnti meja lasúfuriruni Crístu sun cátei le lubáragiñe lerésibiruni luweírigun? ");
INSERT INTO cabNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ábati lagúmeserun afúnraanguágüdei sun le taríñagubei Lerérun Búngiu luágu joun, lagúmesera túmagiñe buri lilíburun Moisés túmoun sun jalíburun profétagu. ");
INSERT INTO cabNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Dan le jachǘlürün lídoun fulásu le ñíjinbaña lubeí, ába ladǘgün Jesúsu camá jamuga lasígiraali leíbugun. ");
INSERT INTO cabNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ába jéredun luágu lun leréderun jáma, jaríñaga lun. —Reídeibá wáma, ladǘga ladáruduña áni gúñemémeeli. Ábati lebélurun Jesúsu lun leréderun jáma. ");
INSERT INTO cabNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Dánti le ñurújali jáma luágu dábula, ába lanǘgünun fein lújaburugu, ába leteíngiruni Búngiu tuágu, ába lagúbachagunun, ába líchugunun joun. ");
INSERT INTO cabNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lídan óra ligía, ába léfegechun jágu, ába jasúbudiruni luágu Jesúsu lan, ába lagúmuchagun jagíbugiñe. ");
INSERT INTO cabNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ábati jaríñagun jámagua. —¿Ma sandítiwa tásüdün wanígi le wagúndan dan le adímurejeina lubeí woun luágu ǘma, aríñagaleí tíla Lerérun Búngiu woun? ");
INSERT INTO cabNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ábati magúrabajaanjaña lan, ába járügüdün ǘma lun jagíribudun ubúrugun Jerusalén le ñí lubei jadáriraña únsu apóstolugu oúndaragu jáma gíñe jíbiri lánigu. ");
INSERT INTO cabNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ába jaríñagun ja oúndaraguñubaña ñi joun. —Inárüni luágu saráali lan Wabúreme Jesúsu lídaangiñe oúweni lúnya labágaridun, aríja láali Simón. ");
INSERT INTO cabNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ábati jabájüdaguni bián wügǘriña jagía le asúseredubei joun luágu ǘma, lúma luágu jasúbudiruni luágu Jesúsu lan dan le lagúbachagúnbarun fein. ");
INSERT INTO cabNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ñígiña adímureja luágu buri cátei le, ligía lasáliragun Jesúsu jamídaangua, ába labúsurun joun, aríñageina. —Ñurúguaü jun. ");
INSERT INTO cabNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ába tájüchürün janígi láu sarágu anúfudei, jarítagun luágu pántu lan jaríjubei. ");
INSERT INTO cabNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ába laríñagun Jesúsu joun. —¿Ca uágu tájüchüra janígi? ¿Ca uágu níjein lubeí liloúguan afíñeni le tídan janígi? ");
INSERT INTO cabNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Aríja jumeí nújabu lúma nugúdi, áu méme le. Gurújumana, pántu, mágürügüti, mábu ligía, anáti áu. ");
INSERT INTO cabNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Dan laríñaguni líra, ába larúfuduni lújabu lúma lugúdi joun. ");
INSERT INTO cabNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Queíti mafíñen mémegiña lan ladǘga ugúndani lúma luweírin anígi le jawágubei, ába laríñagun Jesúsu joun. —¿Níjeinsan eígini júma ya? ");
INSERT INTO cabNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ába jíchugun murúsun úduraü sǘti lun lúma síruudu, ");
INSERT INTO cabNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ába lanǘgüni, ába leígini jagíbugiñe sun jagía. ");
INSERT INTO cabNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Lárigiñe, ába laríñagun joun. —Le asúseredubei nun, ligía lé meja uágubei naríñaga jun dán meja le júmagidina, luágu lagúnfulirúaba lan sun le bürǘwañubei nuágu tídan lilíburun Moisés, tídan jalíburun profétagu, lúma tídan líburu to gíriboun Sálmos. ");
INSERT INTO cabNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ábati gunfaráandagüda lánun Lerérun Búngiu joun, ");
INSERT INTO cabNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ába laríñagun joun. —Bürǘwañu líña luágu lúnti lan loúnwen Crístu, ába lánme lásaarun lídaangiñe oúweni lúnya labágaridun luágu lǘrüwan wéyu, ");
INSERT INTO cabNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","lúnti lan gíñe lapúrichijoún lídan líri joun sun gürígia uboúagu lun jasáansiruni joúserun lun ferúdunawa lan jafígoun, lagúmeseruña apúrichijani ligía ubúrugugiñe Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jugúya geféentün luágu buri cátei le. ");
INSERT INTO cabNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Noúnajabei Sífiri Sándu, le uágubei laríñaga Núguchi Búngiu jun, ítara líña lubeíti, reídei jumá ya ubúrugu Jerusalén daríme jerésibiruni ubáfu lúmagiñe Búngiu le siélubei. ");
INSERT INTO cabNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ábati lanǘgüniña Jesúsu boúgudin lueí ubúrugu chülǘ Betánia, ába liñúruni lújabu, ába ln ferúdunawa laabíniruniña. ");
INSERT INTO cabNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Dánti labíniruniña, ába lamúdeirun jaweí, ába lanügǘniwa siélun. ");
INSERT INTO cabNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Lárigiñe jájuduragun lun, ába jagíribudun járigoún ubúrugun Jerusalén, ¡ma jagúndan! ");
INSERT INTO cabNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Súnwandánti témpulurugúñanu lan íchiga uweíriguni lun Búngiu.");
INSERT INTO cabNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dan le lagúmeserunbei sun cátei, níjeinjali meja Dimúrei (le ámu íri lun Búngiu Irájü), lúmañein Búngiu le Dimúreibei, áni Búngiu méme ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Lídan lubeíti lagúmeserunbei sun cátei, lúmañein Búngiu Úguchili Búngiu Irájü. ");
INSERT INTO cabNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Lídaangiñe ladǘgei Búngiu sun cátei, úati ni cáta adügǘti le máma ladǘga. ");
INSERT INTO cabNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ligía íchugubei ibágari lun sun cátei, áni ligía arúgoungadagüdübei jáu gürígia. ");
INSERT INTO cabNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Rúti larúgounga queísi lámpu lídan lubúriga, áni lásiñerubei lubúriga lámpu ligía éñegucha. ");
INSERT INTO cabNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ñíñein meja ában wügǘri loúnajan Búngiu, gíriti Juan, le ñǘbinbei lun líchugun fe luágu Búngiu Irájü le lúnbei liábin uboúagun lun larúgoungadágüdün jáu gürígia. ");
INSERT INTO cabNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juan, lúnti líchugun fe luágu, lun gayáraabei lan jafíñerun sun gürígia luágu cátei le lúnbei laríñaguni dánme le liábin. ");
INSERT INTO cabNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Máma Juan le lúnbei larúgoungadágüdün jáu gürígia, ában wügǘri ligía le oúnajoúbei lun ladímurejaba lan luágu. ");
INSERT INTO cabNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Búngiu Irájü, le queísigubeirügübei ában lámpu le tímatimaati lun larúgoungadágüdün jáu sun gürígia, lachǘlürüña meja uboúagun lídan dan ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ñǘbinti uboúagun, áni láu sun lídaangiñe lan ladǘgei Búngiu uboú, manǘgün jamúti lirájüñü uboú quei Búngiu Irájü. ");
INSERT INTO cabNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Lageíroun yebe liábin, merésibirun jamúti lílana lageíra. ");
INSERT INTO cabNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Láu sun líra, añájein erésibiruti, ába jafíñerun luágu, ába líchugun ubáfu joun lun lirájüñübaña lan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mítaraantiñatia quei jasáanigu agǘbürigu ja gürígiabaña, ja agǘriajoútiña quei furúmierügü gürígia o láu lan lugúndan ában wügǘri, lirájüñü Búngiu jagía. ");
INSERT INTO cabNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ligírati meja le Dimúreibei, le méme Búngiu Irájübei, ñǘbinti lun ítara lúba lan quei furúmierügü gürígia, ába laganoúniwa wádan. Aríja wamúti luweírigun, uweíriguni le ladǘnabei Liraǘ Búngiu le ábanrügüti, le buínbei láu areíni lúma inárüni. ");
INSERT INTO cabNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Adímurejati Juan luágu, ába laríñagun. —Niján léñaja uágubei nadímureja jun dan le naríñagunbei luágu le lan ubábei naráanseja ǘma, weírigutima lan sügǘ náu, ladǘga níjeinjali lán meja lubáragiñebei nagǘriajoún. ");
INSERT INTO cabNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sun wagía ibíjaadiwa sarágu abíniruni lídaangiñe luweírin lirísin. ");
INSERT INTO cabNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Lúmagiñe Moisés lerésibirúa lilúrudun Búngiu, ánjeinti ínsiñeni lúma inárüni, lídaangiñe Jesucrístu liábin. ");
INSERT INTO cabNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Úagili ni ában aríjiti Búngiu, Liraǘ le ábanrügübei le yaráfabei tun lanígi, ligía arúfudubalin woun ída líña lan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ába joúnajan juríu ja Jerusalénna fádirigu jáma wügǘriña jádaangiñe ladǘgawagun Leví álügüdei Juan cáteiñein lan. ");
INSERT INTO cabNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ába laríñagun joun furáangu. —Máma áu Crístu. ");
INSERT INTO cabNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ábayati jálügüdüni. —¿Cátabuti? ¿Proféta Elías amǘrü? Laríñaga joun. —Uá, máma áu. Ábaya jaríñagun lun. —¿Amǘrü proféta ligíra le lúnbei liábin? Ába laríñagun joun. —Máma gíñe áu. ");
INSERT INTO cabNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ábati jaríñagun lun. —¿Cátabuti? Mósutia wanǘgüni boúnabagüle joun ja oúnajabaliwa. ¿Cági gayáraabei baríñagun woun buoúgua? ");
INSERT INTO cabNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ába loúnabuniña láu méme dimúrei lé meja laríñagubei proféta Isaías. —Áu ában le agúarajabei lídan fulásu le mageírawati. “Aráanse jumoún janígi lubá liábin Wabúreme queísi ladárarúniwa ǘma surúti.” ");
INSERT INTO cabNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ja ñǘdünbaña adímureja lúma Juan, lánigu jadámurin fariséogu, ");
INSERT INTO cabNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ábati jaríñagun lun. —Ánjeinti máma bubeí Crístu, ni Elías, ni proféta ligía, ¿cáti uágu babásteragüdaja? ");
INSERT INTO cabNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ába laríñagun joun. —Áu, láu dúna nabásteragüdaja, níjein ában ibídiñeti jun jagánagua, ");
INSERT INTO cabNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","liábinba nárigiñe, wügǘri ligía, madǘnatina ni lun jamúga nafáragaduni tagǘrüga ligeídin. ");
INSERT INTO cabNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Sun cátei le, lídan fulásu le gíribei Betábara lasúsereda, luágu oúbaü le ñígiñe lubeí láfuara wéyu libíti dúna Jordán, le ñí lubei labásteragüdaja Juan. ");
INSERT INTO cabNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Larúgan, ába laríjin Juan liábin Jesúsu ayárafadeina lun, ába laríñagun joun lánigu. —Niján le loúnajabei Búngiu lun loúnwen luágu jafígoun gürígia queísi meja lafarúniwa mudún lídan dan ligíra luágu jafígoun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Luáguñaja nadímureja dan le naríñagunbei. “Liábinba ában wügǘri nárigiñe le weíriguti sügǘ náu, ladǘga níjeinjali lán meja lubáragiñe nagǘriajoún.” ");
INSERT INTO cabNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ni áu, ibídiñetí meja wügǘri ligía nun, abásteragüdajádina láu dúna lun jasúbudiruni Israelítagu. ");
INSERT INTO cabNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Aríñagati gíñe Juan. —Aríja numúti Sífiri Sándu camá ában únjun, larárirun siélugiñe, ába laráramagun lábulugu. ");
INSERT INTO cabNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ibídiñetí yebe nun cátei lan wügǘri ligía, aríñagarügaali meja le oúnajabalina abásteragüdaja láu dúna, nun. “Dánme le baríjin larárirun Sífiri Sándu ábame laráramun lábulugu ítaga wügǘri, ligía wügǘri ligía le abásteragüdajabei láu Sífiri Sándu.” ");
INSERT INTO cabNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aríja náaliti, geféen áu luágu ligía lan Liraǘbei Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Larúgan, ñíñeinya Juan jáma biáma jádaangiñe lánigu. ");
INSERT INTO cabNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Dan le laríjinbei Juan lásügürün Jesúsu, ába laríñagun. —Niján wügǘri le lanúadirubei Búngiu lun lagídaruni jafígoun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ába jagáambuni biáma lánigu Juan laríñagun ítara, ába jafálaruni Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ábati ladígiragun Jesúsu lárigoún, quei laríjin jafálaruni, ába laríñagun joun. —¿Ca jabúseerubei núma? Ába jaríñagun lun. —Maésturu, ¿jalía bagánawa? ");
INSERT INTO cabNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ába laríñagun Jesúsu joun. —Jigoúgu jaríjei. Ába joúdin, ába jaríjini jalía lan lagánawa, ába jásügürüni líbiri wéyu ligía lúma, ladǘga queíburijali lan gádürü rábounwéyu óra ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrés, le lamúlen Simón Pédro, ligía ában jádaangiñe biáma ja agáambubalin le laríñagubei Juan ába jafálaruni Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Lubáragiñe ámu cátei, ába lídin Andrés álugei Simón Pédro le líbugaña, ába laríñagun lun. —Darí wamaali Mesías, le Crístu, le lanúadirubei Búngiu lun lasálbaruniña gürígia lídaangiñe jafígoun. ");
INSERT INTO cabNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ába lanǘgüni Andrés Simón le ñíjin lubeí Jesúsu, ába laríaguni Jesúsu Simón ligíbuagun, ába laríñagun lun. —Simón, amǘrü le liraǘ Jonás, guetó Céfasba bíri, míni lan íri le. Pédro, o dǘbü. ");
INSERT INTO cabNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Larúgan, ába larítagun Jesúsu lídin loúbawagun Galiléa, ába ladúnragun lúma Felípe, ába laríñagun lun. —Falábana. ");
INSERT INTO cabNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felípe ligía, Betsáidana le ñí lubei gíñe lagánawa Andrés láu sun Pédro. ");
INSERT INTO cabNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ábati lídin Felípe áluajei Natanaél, ába laríñagun lun. —Aríja wamáali wügǘri le uágubei labǘrüja Moisés tídan líburu to lánina lilúrudun Búngiu, le gíñe uágubei jabǘrüja profétagu—Jesúsu le liraǘ José le Nazarétna. ");
INSERT INTO cabNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ába laríñagun Natanaél. —¿Níjein funági Nazarétna buíti? Ába laríñagun Felípe lun. —Jigábu baríja. ");
INSERT INTO cabNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Dan le laríjin Jesúsu layárafadun Natanaél, ába laríñagun. —Nitén ában ladǘgawagun Israél le tímatimaati, úati yéguaü lídan. ");
INSERT INTO cabNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ába laríñagun Natanaél lun. —¿Ída liñági basúbudirunina? Ába laríñagun Jesúsu lun. —Aríja numútibu lubáragiñe lagúarun Felípe bun, dan le tábugiñeñadibu lan tídibu ígo. ");
INSERT INTO cabNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ábati laríñagun Natanaél lun. —Maésturu, amǘrü Liraǘbei Búngiu, amǘrü jarúeitebei Israelítagu. ");
INSERT INTO cabNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ába laríñagun Jesúsu lun. —¿Bafíñerunbei nun ladǘgarügü naríñagun bun luágu aríja nánibu tábugiñe tídibu ígo? Baríjubati cátei weínamutimáati lueí le. ");
INSERT INTO cabNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aríñagati gíñe Jesúsu. —Ninárün jáu, luágu jaríjubei lan siélu junréñu, añájame láni Búngiu ánjeligu aweínja lúma arárija noúgiñe, áu le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ǘrüwa wéyu lárigiñe, ñíñein ában maríei lídan ában fulásu gíriti Caná, le lídaanbei Galiléa. Ñíñounti lúguchu Jesúsu, ");
INSERT INTO cabNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","amísurajoúati gíñeti Jesúsu jáu sun láni disípulugu lídoun maríei ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ába tagúmuchun diweín, ába taríñagun lúguchu Jesúsu lun. —Gumújatia diweín. ");
INSERT INTO cabNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ába laríñagun Jesúsu tun. —¿Cági uágu baríñagei le nun, núguchu? Machǘlügili dan lun nídejan lídan cátei le. ");
INSERT INTO cabNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ába taríñagun joun ja éjeeragubaña. —Adǘga jumeí sun le laríñagunbei jun. ");
INSERT INTO cabNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ñíñoun sísi dináa láutu dǘbü tíbe to jayúsuruboun juríu lun jachíbagun joúngua según jagáburi. Ságü ában dináa tugúya, barǘtu wein o darándi gálun dúna. ");
INSERT INTO cabNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ába laríñagun Jesúsu joun éjeeragutiña. —Buíngüda jumoún sun dináa to láu dúna. Ába jabuínchagüdünun buídu buídu. ");
INSERT INTO cabNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ábati laríñagun Jesúsu joun. —Dabú jumati murúsun tídaangiñe, ábame janǘgüni lun le aríjubei láu fédu. Ába jadǘgüni ítara. ");
INSERT INTO cabNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ábati loúchuni le aríjubei láu fédu dúna ligía salígua lun diweínme, ibídiñoun lun jalíagiñeti lan, ja rügǘñanu éjeeragubaña asúbudirei, ladǘga jagía lan adáburubalin dúna. Ábati lagúarun le aríjubei láu fédu lun le amárieidubei, ");
INSERT INTO cabNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ába laríñagun lun. —Sun gürígia seríwi jamútu tubuídun-ágei diweín furúmiñe, dánti le guráaña amísurajoútiña gíbe, ligía jéjeeragun diweín to furúmieguarügü, ánjeinti amǘrü, ába bareídunun tubuídun-ágei diweín darí guetó baságaroun. ");
INSERT INTO cabNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Cátei le, le ladǘgübei Jesúsu lídan fulásu le gíribei Caná le lídaanbei Galiléa, ligía furúmiñetibei miláguru le áubei larúfudei luweírigun, ába jafíñerun láni disípulugu luágu. ");
INSERT INTO cabNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Lárigiñe cátei le, ába lídin lídoun fulásu le gíribei Capernaúm, úara túma lúguchu, lamúlenu, jáma láni disípulugu, ába jeréderun átiri wéyu ñi. ");
INSERT INTO cabNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ábati lídin Jesúsu ubúrugu Jerusalén ladǘga yaráfaali lan jafédun juríu le lánina páscua. ");
INSERT INTO cabNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ñi ladáriraña ja alúgurajabaña bágasu, mudún, únjun, jáma buri ja ñúnbaña lídan jabára le ñí lubei jasáansija seínsu joun gürígia. Lídan tübǘrürü témpulu ladáriraña sun gürígia ja. ");
INSERT INTO cabNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dan le laríjinbalin Jesúsu cátei le, ába ladǘgün ában labeíjagüle láu gúrudu, ába labúgaguniña sun jagía lídaangiñe tübǘrürü témpulu jáu sun jalǘgüniña mudún jáma bágasu. Chagálei jaseínsun ja asáansijabaña seínsu, garábagualeí jadábulan. ");
INSERT INTO cabNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ába laríñagun joun ja alúgurajabaña únjun. —¡Sagájumei sun cátei le yágiñe! ¡Manǘga jumoún lúban Núguchi lun jalúguraagüleme! ");
INSERT INTO cabNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ábati jarítagun láni disípulugu luágu laríñawagún tídan líburu to Lerérun Búngiu. “Jángitina táu búban táu sun nanígi.” ");
INSERT INTO cabNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ábati jaríñagun juríu lun. —¿Ca miláguru barúfudubei woun lun wasúbudiruni ánjein garícha bubeí lun badǘgüni cátei le? ");
INSERT INTO cabNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ába laríñagun Jesúsu joun. —Güríngua jumoún témpulu to, naráramagüdáyaboun lídan ǘrüwa wéyu. ");
INSERT INTO cabNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ába jaríñagun juríu lun. —Bián-wein-sísi irúmu janǘgün adǘgoun témpulu to, ¿lun biyáraaboun lan aráramagüda lídan ǘrüwa wéyu? ");
INSERT INTO cabNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lúgubu guánarü Jesúsu témpulu to uáguboun ladímureja joun. ");
INSERT INTO cabNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ligía dan lubeí le lásaarun lídaangiñe oúweni, ába jarítagun luágu dimúrei lé meja laríñagubei, ába jafíñerun luágu sun le tídaanbei líburu to Lerérun Búngiu lúma luágu dimúrei buri lé meja laríñagubei joun. ");
INSERT INTO cabNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Dan le Jerusalén lubeí Jesúsu lídan fédu le lánina páscua, sarágu jáña afíñerutiña luágu dan jaríjinbaalin miláguru buri le ladáagubei lun larúfuduni luágu ligía lan Crístubei. ");
INSERT INTO cabNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ánjeinti Jesúsu, míchaagunti lúngua jájaburugun ladǘga subúdi lániña cátañañanu lan. ");
INSERT INTO cabNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mabúseerunti laríñawagúniwa lun ída jáña lan gürígia, ligía lúngua subúdi lumúti cátei lan tídaanbei janígi. ");
INSERT INTO cabNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ñíñein ában wügǘri lánina jadámurin fariséogu, ába jádaangiñe jábutigu juríu, gíriti Nicodémo. ");
INSERT INTO cabNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ába lídin Nicodémo ayánuja lúma Jesúsu gúñoun, ába laríñagun lun. —Maésturu, subúdi wamúti luágu Búngiu lan oúnajabalibu arúfudaja woun, ladǘga úati ni ában lun gayára lan larúfuduni lubáfu láu miláguru quei badǘgüni ánjein úa lubeí Búngiu lúma. ");
INSERT INTO cabNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ába laríñagun Jesúsu lun. —Ninárün báu luágu le lan magǘriajoúnwayati, siñáti lebélurun lídoun larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ába laríñagun Nicodémo lun. —¿Ída lubági lagǘriajoúnwaya ában wügǘri weíriyaali? ¿Gayáraati funági lebélurunya turágeirugun lúguchu lúnya tagǘriajani? ");
INSERT INTO cabNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ába laríñagun Jesúsu lun. —Ninárün báu luágu le lan magǘriajoúnti lídaangiñe dúna lánina abásteruni, lúma lídaangiñe Sífiri Sándu, siñáti lebélurun lídoun larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Le agǘriajoúbei jádaangiñe agǘbürigu ja gürígiabaña, ítara líña ligáburi queísi jagáburi gürígia, le agǘriajoúbei lídaangiñe Sífiri Sándu, ítara líña ligáburi queísi ligáburi Sífiri Sándu. ");
INSERT INTO cabNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Maweíridalá banígi luágu naríñagun bun luágu lúnti lánya jagǘriajoúniwa sun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ítara quei láfurun garábali le ñígiñe lumúti labúseera, agáambabei lamúri, ibídiñeti bun jalíagiñe lan liábin ni jalíñoun lan lídin, ítara jáña gíñe sun ja agǘriajoúbaña lídaangiñe Sífiri Sándu. ");
INSERT INTO cabNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ábayati laríñagun Nicodémo lun. —¿Ída lubásan cátei le? ");
INSERT INTO cabNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ába laríñagun Jesúsu lun. —Ába oúnwenbun maésturu Israélna amǘrü, ¿ibídiñeti cátei le bun? ");
INSERT INTO cabNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ninárün báu luágu le lan wasúbudirubei, ligía lan wadímurejabei, geféen wagía luágu le aríja wamáalibei, jugúya fariséogu, mafíñetün luágu le waríñagubei jun. ");
INSERT INTO cabNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ánjein mafíñen jubeí nun dan le nadímurejan jun luágu buri cátei le lánina uboú, ¿ída lubági jafíñera luágu le lánina siélu? ");
INSERT INTO cabNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","‘Úagili ni ában amúdeiruti siélun, lárigiñe ába larárirun ñígiñe lun gayára lan geféen lan luágu nueídügüya, áu le Wügǘri Garaǘwarügüti, le gábanbei siélu. ");
INSERT INTO cabNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ítara queí meja liñúrunun Moisés tiyáwa jéwe luágu wéwe lídan fulásu mageírawati lun jasálbaruba lan sun ja aríjitiña tuágun, ítara liñá giñe niñurúaba lan luágu gurúwa ");
INSERT INTO cabNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","lun sun lan le afíñeruti nuágu, mídin lámuga máfiougati, siélun lámuga lídin abágarida ában ibágari le magúmuchaditi. ");
INSERT INTO cabNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","‘Weíriti jínsiñe gürígia ja uboúagubaña lun Búngiu darí lun loúnajanina, áu le Liraǘ le ábanrügüti, lun noúnwen luágu jafígoun, lun sun lan ja afíñerutiña nuágu, mídin jamámuga máfiougati, siélun lámuga joúdin, abágarida ában ibágari le magúmuchaditi. ");
INSERT INTO cabNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Moúnajan lumútina Búngiu áu le Liraǘ uboúagun lun níchugun jadúnrun gürígia, loúnajanina lun jasálbarun ja uboúagubaña nuágu. ");
INSERT INTO cabNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","‘Le afíñeti nuágu, áu le Liraǘ Búngiu, barǘ lumuti Búngiu quéisi madúnrunti, ánjein le mafíñeti, gadúnrunjali ligíbugiñe Búngiu ladǘga mafíñen lan nuágu, áu le Liraǘ Búngiu le ábanrügüti. ");
INSERT INTO cabNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ja mafíñebaña, gadúnrunjaña ligíbugiñe Búngiu ladǘga dán buga le niábinbei uboúagun lun narúgoungagüdün láu, gúndaatimaatiña lílana ubóu láu lubúriga sügǘ láu larúgounga, ladǘga cátei lan wuríbati jadáagubei. ");
INSERT INTO cabNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sun ja adǘgübaña cátei wuríbati, iyéreeguti larúgounga joun, ába jadísedun lueí larúgounga ligía, lueí lasúbudirúniwa cátei wuríbati le jadǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ja adǘgübalin lugúndan Búngiu, jínsiñeti joun lun lídan jamá larúgounga lun larijíniwa luágu jarúma lan le jadǘgübei, láu lubáfu Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Lárigiñe sun cátei le, ába lídin Jesúsu jáu láni disípulugu Judéoun, ába leréderun átiri dan ñi, abásteragüdaja. ");
INSERT INTO cabNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ñíñein gíñe Juan abásteragüdaja lídan fulásu le gíribei Enón, yaráfa lun Sálim, ladǘga ñíñein lan sarágu dúna, ába buríti jayábingua gürígia, ába jabásterun. ");
INSERT INTO cabNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Lubáragiñe ladaürǘn Juan lasúsereda sun cátei le. ");
INSERT INTO cabNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ábati jagúmeserun jádaangiñe lánigu Juan asígeneja jáma juríu luágu igáburi le lánina arúmaduni. ");
INSERT INTO cabNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ábati joúdin aríñaga lun Juan. —Aríjabásan maésturu, wügǘri lé buga búmabei luágu óubaü le ñígiñe lubeí láfurida wéyu libíti dúna Jordán, le ligíra lé meja uágubei badímureja woun, guetó labásteragüdajaña gürígia áni jafálaruñeíti sun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ába laríñagun Juan joun. —Siñáti níjein lan ni cáta lúma ni ában gürígia ánjein máma lubeí líchugun Búngiu lun. ");
INSERT INTO cabNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Agáamba jumúti lubeígia naríñagun jun furáangu luágu máma lan áu Crístubei, luágu áu lan ában le oúnajoúbei lubá. ");
INSERT INTO cabNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Lídan ában maríei, adári ligía táubei ladári. Léti lumáda adári, le ñíbei agáambei, oúnwenbun lugúndan láu lagáambuni ladímurejan. Ítara níña gíñeti, oúnwenbun nugúndan luágu Jesúsu, ");
INSERT INTO cabNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ligía lúnti laweírigudúntima, áu lun nǘnabuduntima. ");
INSERT INTO cabNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","‘Jesúsu, le ñǘbinbei siélugiñe, joúgiñeñein sun gürígia. Áu, múaruguna áu, áni lérügüñein lánina uboú gunfaráanda nan. Ánjein le ñǘbinbei siélugiñe, joúgiñeñein sun gürígia, ");
INSERT INTO cabNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","luágu gíñe le aríja láalibei lúma le agáamba láalibei ladímureja, míbetiña afíñerutiña luágu le laríñagubei. ");
INSERT INTO cabNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ánjeinti le afíñeruti, lachoúrurubei luágu inárüni lan le laríñagubei Búngiu, láu lafíñerun. ");
INSERT INTO cabNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Le loúnajabei Búngiu, lerérun Búngiu ladímurejabei, ladǘga mébejati líchuguni Búngiu láni Espíritu lun. ");
INSERT INTO cabNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jínsiñeti Liraǘ Búngiu lun, rúlaali gíñe sun cátei lújaburugun. ");
INSERT INTO cabNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Le afíñebei luágu Liraǘ Búngiu, gabágariti le magúmuchaditi, ánjeinti le májabei lafíñerun luágu Liraǘ Búngiu, mabágaribei líbe ibágari ligía áni mebélurunbei siélun, láburujarügüba ligáñi Búngiu luágu. ");
INSERT INTO cabNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Aba jagáambun fariséogu luágu gíbetima jamá lánigu Jesúsu sügǘ jáu lánigu Juan, áni gíbetima gürígia ñǘbintiña lun, lun jabásterun, ");
INSERT INTO cabNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","láu sun máma lan Jesúsu abásteragüdajabaliña, lánigu abásteragüdajabaña. ");
INSERT INTO cabNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Dan le lasúbudirunbalin Jesúsu cátei le, ába láfuridun Judéagiñe lun lagíribudun Galiléoun. ");
INSERT INTO cabNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Lídan weíyaasu ligía lásügürübati loúbawagugiñe Samária. ");
INSERT INTO cabNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ítara liñáti lachǘlürün lídoun ában fulásu lídan Samária gíriti Sícar, yaráfa lun múa lé meja lígirubei Jacób lun José le liraǘ, le ában jádaangiñe binádu wagǘbürigu. ");
INSERT INTO cabNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ñíñein wélu le únbei jagúara luwélun Jacób, queíti buchá lan luágu Jesúsu eíbuga, ába lañúurun láru wélu ligía. Queí buri amídirugu óra ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tiábijati ában wǘri Samariána adábura dúna lídaangiñe wélu le, ába laríñagun Jesúsu tun. —Rúba dúna nun. ");
INSERT INTO cabNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Añángüratí buga láni disípulugu agáñija eígini ubúrugu. ");
INSERT INTO cabNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ábati taríñagun wǘri Samariána to lun Jesúsu. —¿Ída liñági bamúriajanbei dúna núma, lárigiñe juríu ban, nugúya Samariána? (Mínsiñeguatiñati juríu joúngua jáma Samariána.) ");
INSERT INTO cabNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Aba laríñagun Jesúsu tun. —Lun jamúga subúdi báni edéweejani le líchugubei Búngiu, subúdibeí jamúga cátei lan le amúriajabei dúna búma, bamúriajaña jamúga núma, ába jamúga níchugun ában luwúyeri dúna le gayáraati líchugun ibágari bun, bun. ");
INSERT INTO cabNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ába taríñagun lun. —Úagubeíti cába lan áu badábura dúna áni julíliti wélu le, ¿ída lubáti bíchuguni luwúyeri dúna ligía nun? ");
INSERT INTO cabNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jacób, lé meja binádu wadǘgawagun, ígirubalin wélu le woun, guráti meja dúna lídaangiñe jáu sun lirájüñü jáma lilǘgüniña. ¿Weírigutibu funági sügǘ láu Jacób? ");
INSERT INTO cabNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ába laríñagun Jesúsu tun. —Sun ja átubaña lídaangiñe dúna le, jamágürabudayaba, ");
INSERT INTO cabNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ánjein le átuti lídaangiñe dúna le níchugubei, mamágürabudundügüyaali, ladǘga dúna le lúnbei níchuguni lun, géseséenbei lídan lun líchugun ibágari magúmuchaditi lun. ");
INSERT INTO cabNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ábati taríñagun lun. —Rúbei dúna ligía nun, masándirundügǘyaadina lámuga mágürabu, miábin nugúyame ya wélurugu adábura dúna. ");
INSERT INTO cabNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ába laríñagun Jesúsu tun. —Beíba oúgei búmari le úmabei bamárieida, ábame biábin. ");
INSERT INTO cabNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ába taríñagun lun. —Mámaritina le maríeitina lúma. Ábati laríñagun Jesúsu tun. —Binárün láu baríñagun luágu mámari ban le maríeiti búma, ");
INSERT INTO cabNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ladǘga seíngüjáña wügǘriña úmatiña bagánawa, áni mamárieiduntibu lúma wügǘri le úmabei bagánawa guetó. Aríñagaadibu inárüni. ");
INSERT INTO cabNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dan tagáambubalin wǘri to cátei le, ába taríñagun lun. —Afíñetina luágu proféta ban. ");
INSERT INTO cabNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Binádu wagǘbürigu ja Samariána, judúguatiña meja lun Búngiu ya luágu wǘbü lígita, ánjein jugúya juríu, aríñagatün luágu Jerusalén lan fulásu le lúnbei ñi lan wájuduragua lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ába laríñagun Jesúsu tun. —Afíñebá nun luágu nítebei lan dan lun jájuduragun lun Búngiu mídinga jugúya luágun wǘbü lígita, ni jídin Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jugúya Samariána, ibídiñeti jun ca lan un jájuduragua, ánjein wagía, subúdi wamúti ca lan un wájuduragua ladǘga lídaangiñe warásan wagía juríu liábin asálbaruni. ");
INSERT INTO cabNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lachǘlürüba óra, áni niján óra ligía, lun mebéresenwa lan jalía lan jájuduragua gürígia lun Búngiu. Le lúnbei lebéreserunwa láu, ída líña lan ligáburi jájuduragun lun. lúnti jadǘgüni táu sun janígi lídan ában luwúyeri le áuti lagúndaara Búngiu, según lerérun. Niján luwúyeri ájuduraguni le láluajabei Búngiu jámagiñe gürígia. ");
INSERT INTO cabNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Espíritu Búngiu, ja ájuduragubaña lun, lúnti jadǘgüni láu sun janárün, mebéresenga láu cátei le arijúati. ");
INSERT INTO cabNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ába taríñagun lun. —Subúditi nun luágu liábinba lan Mesías le gíribei Crístu, dánmeti liábin, lafúnraanguagüdübei sun cátei woun. ");
INSERT INTO cabNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ába laríñagun Jesúsu tun. —Áu Mesías ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ligíati jachǘlürün láni disípulugu, ába laweíridun janígi láu jadáriruni Jesúsu adímureja túma ában wǘri, úati ni ában ganígiti lun lálügüdajan ca lan tabúseerubei o ca lan uágu layánuja túma. ");
INSERT INTO cabNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ábati tígirunun wǘri tugúya tidína, ába tídin ubúrugu oúgaña gürígia, ába taríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Jigoúgu jaríja ában eyéri aríñaguti sun cátei le adǘga náalibei nun. ¿Mámadügü funásan ligía Crístubei? ");
INSERT INTO cabNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ábati joúdingua ubúrugugiñe lun le ñíjin lubeí Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Añájati buga disípulugu ayúmuragua lun Jesúsu lun leígin. ");
INSERT INTO cabNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Laríñaga joun. —Níjein cátei lun neígini le ibídiñeti jun. ");
INSERT INTO cabNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ábati jagúmeserun disípulugu álügüdagua jámagua, ába jaríñagun. —¿Máfuna barǘjaña eígini lun? ");
INSERT INTO cabNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ába laríñagun Jesúsu joun. —Nadǘgüni lugúndan le oúnajabalina, agúmuchei luwádigimari, ligía neíginbei. ");
INSERT INTO cabNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jugúya aríñagatün. “Níjeingua gádürü játi lubá alúbajani.” Ánjein áu, naríñajare jun. Aríja jumeí nádü, dánjali lun lalúbajoún. ");
INSERT INTO cabNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Le ñadágimeinbei alúbaja, ibíja lumúti lafáyeiruaja, áni cáteiti le lalúbajabei, gürígia, lun jabíjini ibágari le magúmuchaditi siélu, lun lagúndaarun le ábunagubei úara lúma le alúbajabei. ");
INSERT INTO cabNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Quei le lubeíbei laríñawagún. “Ámu le ábunagubei, ámu le alúbajabei.” ");
INSERT INTO cabNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Oúnaja náadün alúbaja le ñí lubei mábunagun jumá, ámu ábunagubaña, jugúya alúbaja. ");
INSERT INTO cabNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sarágu jáña lílana fulásu ligía le láni Samária afíñerutiña luágu Jesúsu láu taríñagun wǘri tugúya joun luágu aríñaga láni sun le adǘga táalibei tun. ");
INSERT INTO cabNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Dánti le jachǘlürünbei Samariána le ñí lubei Jesúsu, ába jayúmuragun lun lun leréderun jáma. Ába leréderun bián wéyu ñi, ");
INSERT INTO cabNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ábaya jafíñerun sarágu gürígia dan le jagáambunbalin le laríñagubei. ");
INSERT INTO cabNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ábati jaríñagun tun wǘri tugúya. —Mámarügaali luágu le baríñagubei woun wafíñera, ladǘga agáamba wamáali gíñe lúmagiñe, áni subúdi wamúti luágu ligía lan Crístubei le lasálbaja ubóu. ");
INSERT INTO cabNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Bián wéyu lárigiñe, ába láfuridun Jesúsu Samáriagiñe, ába lasígiruni luweíyasun loúbawagun Galiléa, ");
INSERT INTO cabNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","mídinti lageíra quei laríñaguni Jesúsu guánarü luágu madügǘniwa lan gásu láu ában proféta lídan guánarü lageíra. ");
INSERT INTO cabNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Dan lachǘlürünbei Galiléa, resíbi jamúti lílana fulásu buídu, ladǘga ñǘdün jamá gíñe lídan fédu le lánina páscua Jerusalén áni aríja jamúti sun le ladǘgübei lídan fédu ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ábayati lagíribudun Jesúsu lídoun fulásu le Caná le lídaanbei Galiléa, le ñí lubei lasáliraguagüda dúna lun diweínme. Ñíñeinti ában wügǘri weíriguti, ñadágimeinti lúma urúei, níjein ában liraǘ sánditi lídan fulásu le gíribei Capernaúm. ");
INSERT INTO cabNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Dan lagáambunbei wügǘri ligía luágu ñǘbinjali lan Jesúsu Judéagiñe lun Galiléoun, ába lídin aríjei, ába layúmuragun lun lun lídin lúbiñe lun lareídaguagüdüni liraǘ, ladǘga madíseeli lan lun loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ába laríñagun Jesúsu lun. —Jugúya, ánjaün maríjin miláguru, mafíñetün. ");
INSERT INTO cabNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Laríñaga wügǘri ligía lun. —Queímoun furése lubáragiñe loúnwen niraǘ. ");
INSERT INTO cabNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ábati laríñagun Jesúsu lun. —Giríbubá búbiñoun, areídagua biraǘ. Ába lafíñerun wügǘri ligía luágu le laríñagubei Jesúsu lun, ába lídin. ");
INSERT INTO cabNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dan layárafadun tun lúban, ába jayábin lumúsuniña lubároun, ába jaríñagun lun. —Magádieeli biraǘ. ");
INSERT INTO cabNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ába lálügüdüniña ca lan óra lagúmesera liraǘ areídagua, ába jaríñagun lun. —Gúñaarü ladaǘnrün ában rábounwéyu lagídara abíruaü lueí. ");
INSERT INTO cabNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ába larítaguni luágu ligía lan óra laríñagun Jesúsu lun luágu areídaguaali lan liraǘ, ába lafíñerun luágu Jesúsu jáu sun lufámilian. ");
INSERT INTO cabNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ligía libíaman miláguru le ladǘgübei Jesúsu dan le lagíribudunbei Judéagiñe lun Galiléoun. ");
INSERT INTO cabNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Lárigiñe cátei le, jadǘgüña juríu ában fédu, ába lagíribudun Jesúsu Jerusaléoun luágu fédu ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ñi Jerusalén, yaráfa lun béna le gíribei Jabéneri Mudún, níjein ában dúna, Betésda líribei lídan jerérun juríu, seíngüñein lubéneri. ");
INSERT INTO cabNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Sarágu jáña sánditiña roun ñi múarugu, ñíñanu maríjintiña, meíbuguntiña, jáma derégüdaña, jagúrabajañein lánjingichagun dúna. ");
INSERT INTO cabNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ladǘga níjeinja dan, liábin ában ánjeli siélugiñe, ába lánjingichaguni dúna ligía, léti furúmiñeti sánditi le adáburuti lídoun dúna ligía lárigi lánjingichagun, ába lareídagun furúmieguarügü sándi le luágubei. ");
INSERT INTO cabNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ñíñeinti ában wügǘri, darándi-wídü irúmu láu láu sándi, ");
INSERT INTO cabNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","dan laríjinbalin Jesúsu wügǘri ligía roun, subúdileí átiri lan dan láu ítara, ába laríñagun lun. —¿Buséntibu bareídagun? ");
INSERT INTO cabNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ába loúnabun le sándibei. —Úati cába lan anǘgana lídoun dúna dan le lánjingichagun. Ságü nálugun nadáburun, dabújali ámu nubáragiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ába laríñagun Jesúsu lun. —Sarába, budáboun bubárari, beíba. ");
INSERT INTO cabNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lídan óra ligía, ába lareídagun, ába labúdunun lubárari, ába lagúmeserun eíbuga. Queíti lidáani lubeí eméraaguni wéyu ligía, ");
INSERT INTO cabNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ába jaríñagun juríu lun le areídagubei. —Wéyu le eméraaguagülei ugúñe, moún lumuti banǘgünun bubárari buoúgua. ");
INSERT INTO cabNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ába laríñagun joun. —Le areídaguagüdübalina aríñagubei nun. “Budáboun bubárari, beíba.” ");
INSERT INTO cabNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ába jaríñagun lun. —¿Cáteigi le aríñagubei bun. “Budáboun bubárari, beíba”? ");
INSERT INTO cabNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ibídiñetiti lun ca lan areídaguagüdübalin, ladǘga gíbetiña gürígia ñi áni ñǘdünja bugáti Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Lárigiñe, ába ladúnragun Jesúsu lúma, témpulurugu, ába laríñagun lun. —Guetó, quei areídaguaadibu lubeí, mafígounjadügüyabá lueí ladágarun ámu cátei janárimetimaati buágu. ");
INSERT INTO cabNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ábati lídin, ába lawísaruniña juríu luágu Jesúsu lan areídaguagüdübalin. ");
INSERT INTO cabNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ligía lébubei jeíbaajani juríu Jesúsu lun jáfaruni jilágubei ladǘga buri ladáaguni cátei líbe le lídan wéyu le eméraaguagülei. ");
INSERT INTO cabNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ába laríñagun Jesúsu joun. —Ñadágimeinti Núguchi chülǘ lúmoun dan le, áu ñadágimeintina gíñe. ");
INSERT INTO cabNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ligíatimaati jabúseerunbei juríu jáfaruni jilágubei, mámarügü ladǘga lájalachaguni lúrudu le lánina wéyu le eméraaguagülei, ladǘga gíñe líchaagun lúngua quei Búngiu láu laríñagun luágu Lúguchi lan. ");
INSERT INTO cabNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ábati laríñagun Jesúsu joun. —Ninárün jáu, luágu siñá lan nadǘgün, áu le Liraǘ Búngiu, ni cáta láu náni núngua, le rügǘñein naríjubei ladǘgün Núguchi, nadǘga. Sun le ladǘgübei Búngiu Úguchili, adǘga numúti gíñe, áu le Búngiu Irájü, ");
INSERT INTO cabNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ladǘga jínsiñetina lun Búngiu, arúfuda lumúti sun le ladǘgübei nun, áni larúfuduba cátei weínamutimaati nun, le lúnti laweíridun janígi láu. ");
INSERT INTO cabNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ítara quei lásaaragüdüniña Búngiu Úguchili jiláaña lídaangiñe oúweni ába líchugun ibágari joun, ítara líña gíñe níchugun, áu le Búngiu Irájü, ibágari joun ja nabúseerun. ");
INSERT INTO cabNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Magúseragüdünti Búngiu ni ában, rúrügü lumúti sun ubáfu nun, áu le Liraǘ, lun nadǘgüni, ");
INSERT INTO cabNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","lun sun lan gürígia íchigei ában méme inébesei le jíchugubei lun Búngiu Úguchili nun. Le míchuti inébesei nun, áu le Búngiu Irájü, míchuti gíñe inébesei lun Búngiu Úguchili le oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","‘Ninárün jáu, luágu le lan eténiruti lun le naríñagubei lun, afíñe ligía luágu le oúnajabalina, gabágariti le magúmuchaditi, masíadirúnwabei giñe, sügǘjali lídaangiñe féridi lídoun ibágari le magúmuchaditi. ");
INSERT INTO cabNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ninárün jáu luágu nítebei lan dan, áni niján dan ligía, dánme le jagáambuni jiláaña numálali, ja ñǘdünbaña láu le nubeíbei, gabágaribaña. ");
INSERT INTO cabNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ladǘga gabáfuti Búngiu Úguchili lun líchugun ibágari, rújali gíñe ubáfu nun, áu le Búngiu Irájü, lun níchugun ibágari, ");
INSERT INTO cabNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","rújali gíñe ubáfu nun lun nagúseragüdüniña gürígia ladǘga Wügǘri Garaǘwarügüti áu. ");
INSERT INTO cabNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Maweíridalá janígi luágu le, ladǘga lachǘlürüba dan lun jagáambuni sun jiláguaaña numálali, ");
INSERT INTO cabNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ábame jáfuridunga lídaangiñe jamúaja. Já meja arúfudubalin luágu nánigu jamá láu jadǘgüni buíti uboúagu, jásaaruba lun jaganoún lúma Búngiu lun sun dan, ánjañati ja arúfudubalin luágu lánigu jamá Máfia láu jadǘgüni wuríbani, jásaaruba lun jasíadirúniwa lun máfiougati lun sun dan. ");
INSERT INTO cabNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","‘Siñáti nadǘgün ni cáta láu náni núngua. Quei laríñawagúniwa nun, ítara líña nagúseragüdün, áni buíti ligáburi nagúseragüdün ladǘga moúchun nan lun nadǘgüni le nabúseerubei, lueídügüya le labúseerubei Núguchi le oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ánjein áuba lubeí geféen nuoúgua, moúnti le naríñagubei. ");
INSERT INTO cabNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Níjein ámu le geféenbei luágu náni fuleísei, áni subúditi nun luágu le lan laríñagubei nuágu, gebégiti. ");
INSERT INTO cabNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jugúya oúnajatün álügüdei Juan nuágu, áni le loúnabagülebei jun, inárüni. ");
INSERT INTO cabNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Áu magúrabuntina ladímurejan ni ában wügǘri luágu nufúleisein, narítaguagüda rügǘñaadün luágu le laríñagubei Juan nuágu lun gayáraabei lan jafíñerun nuágu lun jasálbaruba lan. ");
INSERT INTO cabNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ítara liñá meja Juan quei ában lámpu le durúnguati, ru ligía larúgounga, áni jugúya aráanseñu jíña méjati lun jerésibiruni larúgounga ligía luágu murúsun dan. ");
INSERT INTO cabNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Níjein ában cátei luágu nufúleisein buítimaati sügǘ láu le laríñagubei Juan. Lé buri cátei le nadǘgübei, le méme buri uágubei laríñaga Núguchi nun lun nadǘgüni, arúfuda lumúti luágu Núguchi lan oúnajabalina le tímatimaati. ");
INSERT INTO cabNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Núguchi le oúnajabalina, arúfuda láali luágu áu lan Liraǘ le oúnajoúbei lun nasálbaruniña gürígia uboúagu, láu sun magáambun jumágili lan lumálali Búngiu, maríjin jumeí. ");
INSERT INTO cabNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mebélugili lerérun jídoun, ladǘga mafíñetün nuágu, áu le loúnajabei. ");
INSERT INTO cabNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Atúriaja jumútu Lerérun Búngiu láu sarágu goúnigi, ladǘga agúraba jumá jadáriruni ibágari le magúmuchaditi tídan, láu sun líra, líburu tugúya adímurejaboun nuágu, ");
INSERT INTO cabNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","áni májatün jiábin númoun lun jibíjini ibágari ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","‘Máluajantina lun janǘgünina gürígia weírigu. ");
INSERT INTO cabNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Gáma lúmoun, subúdi numútün, áni subúdi numúti luágu mísiñen lan Búngiu jun. ");
INSERT INTO cabNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Áu, lueígiñe loúbadina Núguchi niábin, áni jugúya, merésibirun jumútina, ánjein ñǘbin ámu láu láni lúngua, ligíaba jerésibira. ");
INSERT INTO cabNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Ída lubásan jafíñerun nuágu, resíbitünga uweíriguni júmagiñegua, máluajan jumúti uweíriguni le lúmagiñeti Búngiu le ábanrügüti? ");
INSERT INTO cabNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Marítagua jumátia luágu níchuguba lan jidúnrun ligíbugiñe Núguchi, Moisés guánarügüba íchiga jidúnrun, le guánarügü uágubei jíchigei jeménigin. ");
INSERT INTO cabNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ladǘga, lun jamúga afíñe jumá luágu le laríñagubei Moisés, jafíñeruña jamúga gíñe nun, ladǘga abǘrüjati Moisés nibǘgürü. ");
INSERT INTO cabNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ánjein mafíñen jubeí luágu le labǘrüjabei, ¿ída lubáti jafíñerun luágu le naríñagubei jun? ");
INSERT INTO cabNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Lárigiñe, ába lídin Jesúsu loubáfurugun dúna le Galiléa, le méme gíñe dúna le gíribei Tibérias. ");
INSERT INTO cabNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sarágu jáña gürígia afálarei ladǘga jaríjini buri miláguru le ladáagubei, láu lareídaguagüdüniña sánditiña. ");
INSERT INTO cabNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ábati laweínrun Jesúsu luágun ában wǘbü, ába lañúurun ñi jáma láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yaráfaaliti páscua, le jafédun juríu. ");
INSERT INTO cabNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Dan laríjinbei Jesúsu luágu sarágu jáña lan gürígia afálaruti, ába laríñagun lun Felípe. —¿Jalíabasan wagáñija eígini joun sun gürígia ja? ");
INSERT INTO cabNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Laríñagunbalin líra lúnrügü lagáambun cába lan laríñaga Felípe, Jesúsu, subúdi láali cába lan ladǘga. ");
INSERT INTO cabNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ábati laríñagun Felípe lun. —Ni bián-san fiádürü fein loúguaboun lun tafánreinjoúniwa murúsun murúsun jádan sun gürígia ja. ");
INSERT INTO cabNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ábati laríñagun Andrés, ában gíñe jádaangiñe disípulugu, le lamúlen Simón Pédro, lun. ");
INSERT INTO cabNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Niján ában irájü ya, nújein seíngü fein lúma, jáma bián úduraü, loúguabei líra joun sarágu gürígia. ");
INSERT INTO cabNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ábati laríñagun Jesúsu. —Aríñaga jumá joun súngubei lun jañúurun. Ñíñanuti jawára seíngü mílu wügǘriña boúgudin jaweí würíña jáma irájüñü. Queíti ñíñein lan sarágu sagádi lídan fulásu ligía, ába jañúurun. ");
INSERT INTO cabNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ábati lanǘgünun Jesúsu fein lújaburugu, lárigiñe líchugun eteíngiruni lun Búngiu, ába líchugunun joun láni disípulugu, ába jafánreinjanun disípulugu jádan sun ja ñúnbaña. Ligía méme ladǘga jáu úduraü, ruínaleí sun le jabúseerubei joun. ");
INSERT INTO cabNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Dan le quimúleña, ába laríñagun Jesúsu joun láni disípulugu. —Abúdaja jumeí sun le ígiragubei, mabúlegu lámuga ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ába jabúdajani, ába jabuínchagüdün dúusu faníñe láu tífe fein le ígiragubei tídaangiñe seíngü fein. ");
INSERT INTO cabNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Dánti le jaríjinbalin gürígia miláguru le, le ladǘgübei Jesúsu, ába jaríñagun. —Inárüni luágu niján lan proféta lé meja lúnbei liábin uboúagun. ");
INSERT INTO cabNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Queíti lasúbudiruni Jesúsu luágu busén jamá janǘgüni láu érei lun jadǘgüni urúeime, ába lídin lábugua luágun wǘbü. ");
INSERT INTO cabNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Dan le lagúñedunbei, ába jarágachun láni Jesúsu disípulugu lárun dúna, ");
INSERT INTO cabNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ába jádinagun tídoun ában ugúnein, ába jagúmeserun ánjiñuragua lun jachǘlürün Capernaúm. Búrigaaliti, machǘlüti Jesúsu jámoun. ");
INSERT INTO cabNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ába lagúmeserun garábali áfuragua jére, ába lérougadun. ");
INSERT INTO cabNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Dan le awáanseña luára seíngü o sísi quilómetros, ligía jaríjin liábin Jesúsu tuágun ugúnein, eíbugeina ligíbuagu dúna, ába janúfudedagun. ");
INSERT INTO cabNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ába laríñagun joun. —Manúfudeda jumá, áu le. ");
INSERT INTO cabNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ábati jerésibiruni láu ugúndani tídan ugúnein, ába jachǘlürün lídoun fulásu le ñíjin lubeí joúdin lídan murúsun óra. ");
INSERT INTO cabNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Larúgan, ába jaríjin gürígia ja eréderubaña loubáfurugu luágu ñǘdünja jamá buga disípulugu tídan ugúnein to ñíboun áni tugúya rügǘñoun ñi, áni mídin lan Jesúsu jáma. ");
INSERT INTO cabNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Súnti dan ligía, ába tiábingua ugúnein ubúrugugiñe Tibérias lun lídoun ában fulásu yaráfa lun le ñí lubei jeígoun fein lárigi leteíngirun Jesúsu tuágu. ");
INSERT INTO cabNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Dánti jaríjini gürígia luágu úa lan Jesúsu ñi, ni láni disípulugu, ába jádinagun tídoun ugúnein buri tugúya, ába joúdin Capernaúm áluajei. ");
INSERT INTO cabNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Dan le jachǘlürünbei loubáfurugu dúna, ába jadáriruni Jesúsu, ába jaríñagun lun. —Maésturu, ¿ída búgasan biábin? ");
INSERT INTO cabNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ába laríñagun Jesúsu joun. —Ninárün jáu luágu ladǘga lan jeígin darí lun jaquímuledun jáluajana, máma ladǘga gunfaráanda jumáni laníchigu buri miláguru. ");
INSERT INTO cabNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Madíjerida jumá luágu eígini le gagúmuchaditi le lúntibei júgubu, áluaja jumeí eígini tun juwáni, le íchugubei ibágari magúmuchaditi. Ligía eígini le lúnbei níchuguni jun, áu Wügǘri Garaǘwarügüti, ladǘga rúlaali Búngiu Úguchili ubáfu nun lun níchuguni ibágari ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ábati jaríñagun lun. —¿Ída lubásan wadǘga lun woúdin láu le lubeíbei Búngiu? ");
INSERT INTO cabNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ába laríñagun Jesúsu joun. —Le labúseerubei Búngiu, lun jafíñerun nuágu, áu le loúnajabei. ");
INSERT INTO cabNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jaríñagati lun. —¿Cábagi seíni gayára barúfudun woun lun wafíñerun buágu? ¿Cági cátei badǘgübei? ");
INSERT INTO cabNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Binádu wagǘbürigu joútiña meja fein to gíriboun maná lídan fulásu mageírawati, quei taríñaguni Lerérun Búngiu. “Joúgüda lumútiña Búngiu fein to siélugiñetu.” ");
INSERT INTO cabNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ába laríñagun Jesúsu joun. —Ninárün jáu luágu máma lan Moisés íchugubarun fein siélugiñetu tugúya joun, Núguchi íchugubei fein joun áni ligía gíñe íchugubarun fein siélugiñetu jun to tímatimaatu. ");
INSERT INTO cabNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ladǘga fein to líchuguboun Búngiu, tugúya to aráriruboun siélugiñe áni rúti gíñe ibágari joun lílana uboú. ");
INSERT INTO cabNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ábati jaríñagun lun. —Rúboun fein tugúya woun súnwandan. ");
INSERT INTO cabNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ába laríñagun Jesúsu joun. —Áu fein to íchuguboun ibágari. Le ñǘbinti númoun, malámadügüyaarume luwáni, le afíñeruti nuágu, mamágürabudügüyaaru giñe luwáni. ");
INSERT INTO cabNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Quei le nubeíbei jun, jugúya mafíñetün láu sun aríja jumáadina lan. ");
INSERT INTO cabNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sun gürígia ja líchugubaña Núguchi nun, ñǘbintiña nun, játi ñǘbintiña númoun mabúgun nubáña. ");
INSERT INTO cabNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Máma niábiña siélugiñe lun nadǘgüni nugúndan, le náni núngua, niábiña lun nadǘgüni lugúndan le oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Léti labúseerubei Núguchi le oúnajabalina, lun meféridirun nan ni ában jádaangiñe ja líchugubaña nun, lun sarágüdarügü nániña lídaangiñe oúweni lídaanme lagúmujoún wéyu. ");
INSERT INTO cabNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Le labúseerubei le oúnajabalina, lun sun lan ja anǘgütina quéisi Liraǘ Búngiu, afíñe jagía nuágu, lun gabágari jamá le magúmuchaditi, áni násaaragüdübaña lídaangiñe oúweni lídan lagúmujoún wéyu. ");
INSERT INTO cabNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ába jagúmeserun juríu adímureja wuríba luágu Jesúsu ladǘga laríñagun luágu ligía lan fein to aráriruboun siélugiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ába jaríñagun. —¿Ma funági Jesúsu le liraǘ José le? Subúdi wamúti lúguchi túma lúguchu. ¿Ída liñáti laríñagunbei luágu siélugiñe lan larárira? ");
INSERT INTO cabNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ábati laríñagun Jesúsu joun. —Madímureja jumá nuágu. ");
INSERT INTO cabNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Siñáti liábin ni ában númoun ánjein máma lubeí lanǘgün Búngiu Úguchili le oúnajabalina, áni násaaragüdübei lídaangiñe oúweni lídan lagúmujoún wéyu. ");
INSERT INTO cabNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Laríñajare tídan líburu to jerérun profétagu. “Larúfudajaba Búngiu joun súngubei.” Sun lubeíti ja agáambubalin Búngiu Úguchili, furéndei jagía lúmagiñe, ñǘbintiña númoun. ");
INSERT INTO cabNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","‘Máma jamúgatia luágu níjein lan aríjiti Búngiu Úguchili. Áu le ñǘbinbei lúmagiñe Búngiu, áu rügǘñein aríjei. ");
INSERT INTO cabNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ninárün jáu luágu le lan afíñeti nuágu, gabágariti le magúmuchaditi. ");
INSERT INTO cabNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Áu fein to íchuguboun ibágari. ");
INSERT INTO cabNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Joútiña binádu jagǘbürigu fein to maná lídan fulásu mageírawati áni láu sun luwúyeri jiláguatiña. ");
INSERT INTO cabNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Áu, tuágu fein to aráriruboun siélugiñe nadímureja, lun ja lan eígitu, lúmounbaña Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Áu méme fein wínwantu tugúya to aráriruboun siélugiñe, le eígiti tídaangiñe fein tugúya, labágariduba le tímatimaati lúma Búngiu lun súnwandan. Fein to lúnboun níchugunun, núgubu guánarü, níchugubei lun gayáraabei lan jabágaridun gürígia lun sun dan lúma Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ábati jeréderun juríu adímureja jámagua, ába jaríñagun. —¿Ída lubásan leígagüdüni le lúgubu guánarü woun? ");
INSERT INTO cabNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Laríñaga Jesúsu joun. —Ninárün jáu luágu ánjaün lan meígin lídaangiñe núgubu, áu Wügǘri Garaǘwarügüti, mátun jumeíme níta, mabágaribadün. ");
INSERT INTO cabNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Le eígiti núgubu, gurálei níta, gabágariti tímatimaati le magúmuchaditi, áni násaaragüdübei lídaangiñe oúweni lídan lagúmujoún wéyu. ");
INSERT INTO cabNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ladǘga eígini le tímatimaati núgubu, uníñein le tímatimaati níta. ");
INSERT INTO cabNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Le eígiti núgubu, gurálei níta, lídaañein ában núma, áu lúma. ");
INSERT INTO cabNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Úguchili le oúnajabalina, gabágariti, áni áu, gabágaritina gíñe lídaangiñe, ítara méme líña, le awínwanduti nídaangiñe, gabágaribei nídaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tuágu fein to aráriruboun siélugiñe nadímureja. Mítaraantu fein to quei maná le jeígubei binádu jagǘbürigu, láu lan sun luwúyeri jiláguatiña, le eígiti tídaangiñe fein to, labágariduba tímatimaati lun sun dan lúma Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Lídan adámuridaguni tídan jalígilisin juríu to Capernaúmboun, ñi larúfudajei Jesúsu cátei le. ");
INSERT INTO cabNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sarágu jáña jádaangiñe ja afálarubalin Jesúsu, dan le jagáambunbalin arúfudajani le, ába jaríñagun. —Cátei le laríñagubei, jénreenguti lerésibirúniwa, ¿cábasan adǘga gásu láu? ");
INSERT INTO cabNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ába lasúbudiruni Jesúsu luágu jadímurejaña lan luágu cátei ligía, ába laríñagun joun. —¿Wuríbati láburujan líra jun? ");
INSERT INTO cabNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Cába jamúga funáti asúsereda ánjana jamúga jaríja, áu Wügǘri Garaǘwarügüti, awárira nárigoún siélun lé meja ñí nubei furúmiñe? ");
INSERT INTO cabNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Náni Espíritu, ligía íchugubei ibágari tímatimaati, núguburügü, siñáti líderagunün. Áni sún buri cátei le naríñagubei jun, máma luáguti eígini le lúnti jurágeirugu, luáguti eígini le túnti juwáni, le íchugubei ibágari magúmuchaditi. ");
INSERT INTO cabNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Áni añájeingua jídaangiñe, mafíñetiña. Ladǘga lúmagiñe furúmiñeti dan, subúdi láña Jesúsu cátaña lan mafíñebaña, lúma cátei lan le lúnbei lalúguruni. ");
INSERT INTO cabNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ába laríñagun. —Ligía naríñagunbei jun luágu siñá lan liábin ni ában númoun ánjein máma lubeí Núguchi Búngiu agúarubei lun. ");
INSERT INTO cabNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Lúmagiñe dan ligía, sarágu jáña jádaangiñe ja afálarubalin Jesúsu, ába jígiruni, ába meíbugunjaña lan lúma. ");
INSERT INTO cabNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ábati laríñagun Jesúsu joun dúusu disípulugu. —Ángi jugúya, ¿buséntün gíñe jídin nueí? ");
INSERT INTO cabNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ába loúnabun Simón. —¿Cábagi úmoun woúdin? Dimúrei buri le baríñagubei, lánina ibágari tímatimaati le magúmuchaditi. ");
INSERT INTO cabNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wagía afíñeediwa, áni subúdi wamúti luágu amǘrü lan Crístubei le Liraǘ Búngiu wínwanti. ");
INSERT INTO cabNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ába laríñagun Jesúsu joun. —¿Másan áu anúadajabalün dúusugubei jugúya? Láu sun líra, níjein ában jídaangiñe láni Máfia. ");
INSERT INTO cabNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Dan laríñagunbalin Jesúsu líra, luáguñein Júdas, le liraǘ Simón Iscarióte, ladǘga ligíaba lan alúgurei, láu sun ában lan jádaangiñe dúusu disípulugu ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Lárigiñe sun cátei le, ába eíbugañaja lan Jesúsu loúbawagu Galiléa, mabúseerunti leréderun Judéa ladǘga ñi buséntiña juríu jáfaruni jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Queíti yaráfaali lan ában lídaangiñe jafédun juríu le gíribei tufédun dibásein, ");
INSERT INTO cabNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ába jaríñagun lamúlenu lun. —Meréderabá ya, beíba Judéoun aríja jamámugei gíñe bánigu ja ñíbaña cátei lé buri badǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Dan le busén lan ában gürígia lasúbudirúniwa, madǘgün lumúti buri cátei arámudaguarügü. Queíti adǘga ban cátei líbeina le, adǘgabeí ligíbugiñe sun uboú. ");
INSERT INTO cabNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ni íbini lamúlenu mafíñetiña luágu. ");
INSERT INTO cabNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ábati laríñagun Jesúsu joun. —Machǘlügili dan lun nídin Jerusalén luágu fédu ligía, ánjein jun, buíti furúmierügü óra. ");
INSERT INTO cabNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Siñáti jiyéreegudún joun ja lánina uboú le, anáti áu, iyéreegutina joun, ladǘga geféentina luágu wuríba lán buri cátei le jadǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jeíba lídan fédu, áu mídinbadina guetó, machǘlügili nidáani lun nídin. ");
INSERT INTO cabNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Lárigiñe laríñaguni sun le joun, ába leréderun Galiléa. ");
INSERT INTO cabNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Lárigiñe joúdin lamúlenu, ligía lídin Jesúsu lídan fédu ligía, mafúnraangunrügü líña, camá jamuga mabúseerunti larijoúniwa. ");
INSERT INTO cabNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ítara líña jáluajani juríu lídan fédu ligía, ába jaríñagun. —¿Jageí funásan wügǘri le? ");
INSERT INTO cabNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Sarágu jañáti adímurejatiña luágu jádan gürígia. Ñíñanu aríñagutiña luágu ában lan wügǘri buíti ligía, jíbiri aríñaga. “Mabuídunti, yéegua lumútiña gürígia.” ");
INSERT INTO cabNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Úati ni ában adímurejati furáangu luágu, ladǘga janúfude jaweí juríu. ");
INSERT INTO cabNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Lamídounjali fédu lúmagua, ligía lebélurun Jesúsu témpulurugun, ába lagúmeserun arúfudaja. ");
INSERT INTO cabNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ába laweíridun janígi juríu, ába jaríñagun. —¿Ída liñásan lasúbudirunbei le sarágu cátei, matúriajaanga ligía? ");
INSERT INTO cabNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ába laríñagun Jesúsu joun. —Le narúfudajabei, máma nídaangiñeti, lídaangiñeti le oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ánjein níjein lubeí ában le aráanseti lun ladǘgüni le labúseerubei Búngiu, lasúbudirubei ánjein lúmagiñeti lubeí Búngiu le narúfudajabei lúmoun luágu lan náni núngua nadímureja. ");
INSERT INTO cabNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Le adímurejabei luágu láni lúngua, ladǘgüni lun janǘgüni gürígia weíri, le oúchubei lun lanügǘniwa le oúnajabalin weíri, ligía aríñagubalin inárüni, áni máma ligía biángua tigíbu. ");
INSERT INTO cabNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","‘¿Ma inárüni luágu rúlaani Moisés lúrudu jun? Láu sun líra, úati ni ában jídaangiñe úaraduti lúma lúrudu ligía. ¿Ca uágu jabúseera jáfarunina jilágubei? ");
INSERT INTO cabNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ába jaríñagun lun. —Níjein espíritu wuríbati bídan, ¿ca busénbei láfarunibu jilágubei? ");
INSERT INTO cabNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ába laríñagun Jesúsu joun. —Luágurügü ában cátei le nadǘgübei lídan wéyu le eméraaguagülei laweírida janígi sun jugúya. ");
INSERT INTO cabNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Arúfudaja lumúti Moisés luáguti jagáburi juríu le circuncisión, (láu sun máma lan ligía agúmeserubalin igáburi ligía, jagúmeserun binádu lagǘbürigu lubáragiñe), ligía lébubei lerésibirun ában irájü circuncisión íbini lídan lan wéyu le eméraaguagülei. ");
INSERT INTO cabNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ánjein adǘga jubálin líra íbini lídan lan wéyu le eméraaguagülei lueírügü jadǘraaguni lilúrudun Moisés, ¿cáti uágu jagáñida núma lueígiñe nareídaguagüdüni lúgubu ában wügǘri dayárugubei lídan wéyu le eméraaguagülei? ");
INSERT INTO cabNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Masáminara jumá luágu cátei quéisi larijíniwa, samína jumá luágu quéisi lubeí. ");
INSERT INTO cabNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ábati jagúmeserun jádaangiñe ja aganoúbaña Jerusalén álügüdaja. —¿Másan niján le jáluajabei lun jáfaruni jilágubei? ");
INSERT INTO cabNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nijánga adímureja ligíbugiñe guríriguaü, áni úati ni ában aríñaguti ni cáta lun. ¿Léfunasan afíñe jamá gumádimatiña luágu wügǘri lan le Crístubei? ");
INSERT INTO cabNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Subúditi woun jalíagiñe lan liábin le, ánjeinti dánme le liábin Crístu, ibídiñebei ni ca un jalíagiñe lan liábin. ");
INSERT INTO cabNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Dan lagáambubalin Jesúsu cátei le, dan larúfudajaña lubeí témpulurugu, ába laríñagun rein. —¡Subúdi jumútina lubeíti, subúdi jumeí jalíagiñe lan niábin! Máma láu náni núngua niábin, ában le inárünibei luágu níjein lan, ligía oúnajabalina, áni ibídiñeti jun. ");
INSERT INTO cabNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Áu, subúdi numúti ladǘga lúmagiñe lan niábin, áni ligía oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ába yebéti jabúseerun jadáürüni, úati ni ában agúuruti luágu ladǘga machǘlügili lan dan lun loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sarágu jáña afíñerutiña luágu, ába jaríñagun. —Dánme le liábin Crístu, ¿ladǘgüba funági ámu miláguru sügǘ láu wügǘri le? ");
INSERT INTO cabNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ába jagáambuni fariséogu le jaríñagubei gürígia luágu Jesúsu, jagía jáma jábutigu fádirigu, ába joúnajan polisía témpulurugugiñe lun jadáürüni. ");
INSERT INTO cabNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ábati laríñagun Jesúsu. —Murúsunrügübei dan neréderun júma ya, ábame nagíribudun lúmoun le oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jáluajabadina, madári jubádina, ladǘga siñábei lan jídin le ñíjinbadina lubeí. ");
INSERT INTO cabNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ábati jagúmeserun juríu álügüdagua jámagua. —¿Jalíñounba funásan lídin le siñábei lubeí nege wadáriruni? ¿Leíbuga funa jámoun juríu ja jagánaguabaña gürígia ja güriégu, lun larúfudajan joun güriégu? ");
INSERT INTO cabNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ca míni lan láu laríñagun woun. “Jáluajabadina, madári jubádina ladǘga siñábei lan jídin le ñíbadina lubeí”? ");
INSERT INTO cabNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Le lagúmujoún wéyu lídan fédu ligía, ligíatima weírigubei. Lídaanti wéyu ligía, ába laráramun Jesúsu, ába laríñagun láu umálali reínti. —Le mágürabutu luwáni, ñǘbinlá númoun, gurála. ");
INSERT INTO cabNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Le afíñeti nuágu, láwiyujaba dúna wínwanti tídaangiñe lanígi, quei taríñaguni Lerérun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Laríñaguña Jesúsu láu líra luágu ja lan afíñerutiña luágu, jerésibirubei lan Sífiri Sándu, dan ligía, miábingili Sífiri Sándu ladǘga magíribudungili lan Jesúsu larigoún siélun lídoun luweírigun. ");
INSERT INTO cabNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ñíñanu jádaangiñe gürígia, dan le jagáambunbalin cátei le, ába jaríñagun. —Inárüni luágu niján lan proféta lé meja lúnbei liábin. ");
INSERT INTO cabNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jaríñaga jíbiri. —Niján Crístubei. Jaríñaga jíbiri. —¿Ída lubásan Galiléanabei lan Crístu? ");
INSERT INTO cabNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Taríñajare Lerérun Búngiu luágu ladǘgawagunbei lan urúei Davíd Crístu, áni Beléngiñetibei lan, fulásu meme le ñígiñeti lubeí Davíd. ");
INSERT INTO cabNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ába lubeíti jafánreinragun gürígia lueígiñe Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ñíñanu yebe abúseerutiña jadáürüni, úati ni ában adǘgüti. ");
INSERT INTO cabNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ába jagíribudun polisía ja tánina témpulu jarigoún jámoun fariséogu jáma jábutigu fádirigu. Ába jaríñagun joun polisía. —¿Ca uágu manǘgün jubálin? ");
INSERT INTO cabNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ába jaríñagun polisía. —¡Úagili ni ában adímurejati quei ladímurejan wügǘri le! ");
INSERT INTO cabNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ábati jaríñagun fariséogu joun. —¿Ígiraguagüdaadün gíñe júngua lun leyéedunün? ");
INSERT INTO cabNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Níjein funági ában jádaangiñe wábutigu o jádaangiñe lan fariséogu afíñeruti luágu? ");
INSERT INTO cabNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ánjaña gürígia ja, ja afálarubalin wügǘri ligía, ja ibídiñejabubaña lun lúrudu, íñarawagúaaña. ");
INSERT INTO cabNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodémo, le ñǘdünbei adímureja lúma Jesúsu gúñoun, ligía ában jádaangiñe fariséogu, ába laríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Según walúrudun, siñáti wasíadiruni ában wügǘri magáambunga wameí furúmiñe lun wasúbudiruni ca lan lidúnrunbei. ");
INSERT INTO cabNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ábati jaríñagun lun. —¿Galiléana gíñe amǘrü, badímurejaanbei luágu lufúleisein? Atúriajaboún Lerérun Búngiu, basúbudirubei luágu úagili lan ni ában proféta Galiléana. ");
INSERT INTO cabNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ába joúdin cáda ában jábiñoun. ");
INSERT INTO cabNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ánjeinti Jesúsu, ába lídin luágun wǘbü le gíribei Olívos. ");
INSERT INTO cabNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Larúgan bináafin, ába lagíribudun témpulurugun, ába jayábin sun gürígia lubádun, ába lañúurun, ába lagúmeserun arúfudaja joun. ");
INSERT INTO cabNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ábati janǘgün arúfudajatiña lilúrudun Moisés jáma fariséogu ában wǘri jadáriragun lúma ámu wügǘri lueí túmari. Ába jíchugunun jamídaangua ja ñíbaña jámagua, ");
INSERT INTO cabNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ába jaríñagun lun Jesúsu. —Maésturu, nuján wǘri to, wadáriragun lúma ámu wügǘri lueí túmari. ");
INSERT INTO cabNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Laríñajare lilúrudun Moisés jawágu jíbe würíña ja, lun jáfarawagún jilágubei láu dǘbü. ¿Cági baríñagubei? ");
INSERT INTO cabNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jaríñagunbalin líra lun jaríjin lábun, lun gébuna lan jíchugun lidúnrun. Ábati lélemuchun Jesúsu, ába labǘrüjan múarugu láu lújabu. ");
INSERT INTO cabNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Queíti jasígirun álügüdaguei, ába laráramun, ába laríñagun joun. —Furúmiñeguarügü jídaangiñe le mafígounti, chǘleí furúmiñeti dǘbü tuágu. ");
INSERT INTO cabNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ábaya lélemuchun, ába lasígirun abǘrüja múarugu. ");
INSERT INTO cabNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jagía, le jagáambubalin le laríñagubei, ába jasándiragun joúngua luágu gafígoun jamá, ába jáfuridunga ában ában, jagúmesera jámagiñe ja weínamutimáajañabaña. Dánti le furíjaña súngubei, ába ladáriragun Jesúsu lúngua lábugua túma wǘri tugúya quei teréderunbei ñi. ");
INSERT INTO cabNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ábati liñúraguni Jesúsu lichǘgü, ába laríñagun tun. —¿Jagáñasán buga ja íchugubaña bidúnrun? ¿Úati ni ában asíadirutibu lun boúnwen? ");
INSERT INTO cabNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ába taríñagun lun. —Uá, úati ni ában. —Ábati laríñagun Jesúsu tun. —Ni áu, masíadirun nubádibu, beíba, madǘgadügüyabá figoú. ");
INSERT INTO cabNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ábaya ladímurejan Jesúsu joun gürígia, ába laríñagun. —Áu lilámpunbei uboú, le afálarutina, libíjubei larúgounga le anǘgübei gürígia lídoun ibágari magúmuchaditi, áni meíbugunbei lídan lubúriga. ");
INSERT INTO cabNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ábati jaríñagun fariséogu lun. —Amǘrü, badímurejaña buíti buoúgua, mebégiti líra. ");
INSERT INTO cabNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ába laríñagun Jesúsu joun. —Le naríñagubei gebégiti, láu sun áu lan adímurejabei buíti nuoúgua. Áu, subúdi numúti jalíagiñe lan niábin lúma jalíñounba lan nídin, ánjein jugúya, ibídiñeti jun jalíagiñe lan niábin ni jalíñounbadina lan. ");
INSERT INTO cabNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jugúya, jasáminarun nuágu queísi luwúyeri lasáminarun uboú, áu, magúseragüdüntina ni ában. ");
INSERT INTO cabNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ánjana jamúga agúseragüda, nadǘgüñein jamúga láu úarani, ladǘga mámarügüba áu agúseragüda, Núguchi le oúnajabalina lagúseragüdüba gíñe núma. ");
INSERT INTO cabNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Bürǘwati lídan jilúrudun luágu dan lan geféen jamá bián gürígia luágu ában méme cátei, lúnti lan lafíñerún joun. ");
INSERT INTO cabNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ítara liñáti áu ában le geféenbei luágu náni fuleísei, Núguchi le oúnajabalina, ligía gíñe ában le geféenbei nuágu. ");
INSERT INTO cabNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ábati jaríñagun lun. —¿Jageígi Búguchi? Ába laríñagun joun. —Jugúya, ibídiñetina jun, ni Núguchi, ibídiñeti giñe jun, lun jamúga subúdi jumánina, subúditi jamúga giñe Núguchi jun. ");
INSERT INTO cabNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Lídan laríñagubalin Jesúsu cátei le, larúfudajaña témpulurugu lídan fulásu le ñí tubeí buri gáfu to lágei seínsu. Madáürün lumúti ni ában ladǘga machǘlügili lan lidáani lun loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ábaya laríñagun Jesúsu joun. —Áu, neíbuga, jugúya jáluajabadina, joúweguba gafígounga, siñáti jídin le ñíjinba lubeí nídin. ");
INSERT INTO cabNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ábati jaríñagun juríu. —¿Láfaragua funa lúngua, laríñagunbei luágu siñá lan woúdin le ñíjinba lubeí lídin? ");
INSERT INTO cabNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ábati laríñagun Jesúsu joun. —Jugúya, ǘnabuna jugúya, ánjein áu, yágütana íñu áu. Láni uboú le jugúya, ánjein áu, máma láni uboú le áu. ");
INSERT INTO cabNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ligía naríñagunbei jun luágu joúweguba lan gafígounga, ladǘga ánjein mafíñen jubeí luágu áu lan áu, joúweguba ítara. ");
INSERT INTO cabNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ábati jaríñagun lun. —¿Cátabuti? Ába laríñagun joun. —Aríñaga náali jun lúmagiñe binárü. ");
INSERT INTO cabNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Gayáraati jamúga naríñagun gíbeti jun luágu luríban jigáburi lun nadeínjan jun, le oúnajabalina aríñaga lumúti inárüni, áni cáteirügübei le nagáambubei lúmagiñe le oúnajabalina naríñaga joun ja lílana uboú. ");
INSERT INTO cabNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ánjein jagía, úati gunfaráanda jamáni láu luágu lan Búngiu ladímureja Jesúsu joun. ");
INSERT INTO cabNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ligía laríñagunbei joun. —Dánme le jiñúrunina, áu Wügǘri Garaǘwarügüti, ligíame jasúbudiruni luágu áu lan le uágubei naríñaga luágu áu lan, áni madǘgün nan ni cáta luágu náni núngua, lueídügüya le larúfudajabei Núguchi nun. ");
INSERT INTO cabNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ladǘga númañein le oúnajabalina, mígirun lágidina Núguchi nábugua, ladǘga adǘga náni le áubei lagúndaara súnwandan. ");
INSERT INTO cabNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Dan le laríñagunbalin Jesúsu le, ába jafíñerun sarágu luágu. ");
INSERT INTO cabNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ába laríñagun Jesúsu joun juríu ja ánjarubaña lun lerérun. —Ánjaün asígira lun jídin surúñu láu le nubeíbei jun, jiábinba lun náni jumá disípulugu le tímatimaati. ");
INSERT INTO cabNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ábame jasúbudiruni inárüni, ábame lafúnraanguagüdünün inárüni. ");
INSERT INTO cabNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ába jaríñagun lun. —Linébaanfaangu Abrahám wagía, áni merédegidiwa idámunime ni ca un. ¿Ída liñáti baríñagunbei luágu furáangujadiwa lánme? ");
INSERT INTO cabNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ába laríñagun Jesúsu joun. —Ninárün jáu, luágu sun lan ja adáagubaña figoú, lidámun figoú jagía. ");
INSERT INTO cabNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ában idámuni, máma jádaangiñeti família, ánjeinti ában isáani, jádaangiñeti família súnwandan. ");
INSERT INTO cabNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ánjaün lubeíti nafúnraanguagüda, áu le Búngiu Irájü, lídaangiñe idámuni lun figoú, furáangubadün le tímatimaati. ");
INSERT INTO cabNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Subúdi náali luágu linébaanfaangu jumá Abrahám, láu sun líra, buséntün jáfarunina, ladǘga mája jumá lun le nubeíbei jun. ");
INSERT INTO cabNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Áu nadímurejan luágu le larúfudubei Núguchi nun, jugúya jadǘgüni le jafúnrendeirubei lúmagiñe júguchi, le Máfia. ");
INSERT INTO cabNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ába jaríñagun lun. —Abrahám wáguchibei. Ába laríñagun Jesúsu joun. —Lun jamúga inárüni lan luágu lirájüñü jumá Abrahám, jadǘgüñein jamúga le ladǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Láu sun aríñaga náali lan inárüni le larúfudajabei Búngiu nun jun, buséntün jáfarunina. ¡Madǘgünti meja Abrahám ni cáta líbe líra! ");
INSERT INTO cabNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Le méme ladǘgübei júguchi, ligía jadǘgübei. Ábati jaríñagun lun. —Mámatia wagía bástadi, ában rügǘñein wáguchi, Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ába laríñagun Jesúsu joun. —Ánjein jamúga Búngiu lubeí júguchibei, jínsiñetina jamúga jun ladǘga lúmagiñe Búngiu niábin, áni anája ya. Máma láu náni núngua niábin, Búngiu oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ca uágu lásiñerunbei gunfaráanda jumáni le naríñagubei? Ladǘga mabúseerun jumá jagáambuni náni ugánu. ");
INSERT INTO cabNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Máfia júguchibei, lánigu jugúya, áni buséntün jadǘgüni lugúndan. Gáfarajadigubeiñein Máfia lúmagiñe furúmiñeti dan. Márügüdünti lueígiñe inárüni, maríñagunti gíñe inárüni. Lídan le laríñagun iyéeni, ladímurejaña quei ligáburi, ladǘga yéeti áni ligía lúguchibei iyéeni. ");
INSERT INTO cabNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ánjeinti áu, quei inárüni lubeí naríñagubei, mafíñetün nun. ");
INSERT INTO cabNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ca jídaangiñe gayáraabei larúfuduni luágu gafígoun nan? Ánjeinti inárüni lubeí naríñagubei, ¿cáti uágu mafíñen jubeí nun? ");
INSERT INTO cabNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Le lánigu Búngiu, agáamba lumúti lerérun Búngiu, ánjeinti jugúya, quei máma jubeí lánigu Búngiu, ligía mája jubeí jagáambuni. ");
INSERT INTO cabNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ábati jaríñagun juríu lun. —Wanárün láu waríñagun luágu máma ban ámu jaweí jagǘbüri Samariána, luágu gíñe níjein lan ában espíritu wuríbati bídan. ");
INSERT INTO cabNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ába laríñagun Jesúsu joun. —Úati espíritu wuríbati nídan. Le nadǘgübei, níchuguña inébesei lun Núguchi, jugúya, íchiga minébeni nun. ");
INSERT INTO cabNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Máluajaantina inébesei núngua, láu sun níjein lan ában áluga lumúti ninébese, áni ligía le agúseragüdübei. ");
INSERT INTO cabNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ninárün jáu luágu le lan adǘgüti gásu láu le nubeíbei, moúnwenbei lan. ");
INSERT INTO cabNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ábati jaríñagun juríu lun. —Anáti guetó, choúru wamáali luágu níjein lan espíritu wuríbati bídan. Jiláti Abrahám, jilágua profétagu, áni aríñagagibu luágu le lan adǘgüti gásu láu le bubeíbei, moúnwenbei lan. ");
INSERT INTO cabNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Cátabuñadíbugi lúmoun wáguchi Abrahám? Jiláti Abrahám, jilágua profétagu. ¿Ída liñáti banáangun búngua? ");
INSERT INTO cabNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ába laríñagun Jesúsu joun. —Ánjana íchiga uweíriguni nuoúgua, málabei, ánjeinti Núguchi, le méme uágubei jaríñaga luágu ligía lan Jubúngiutebei, ligía íchugubei uweíriguni nuágu. ");
INSERT INTO cabNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Jugúya, ibídiñeti Búngiu jun, anáti áu, subúditi nun, áni ánjana jamúga aríñaga luágu ibídiñe lan nun, yéetina jamúga gíñe quei jugúya. Subúditi Búngiu nun le tímatimaati, áni adǘga numúti le lubeíbei. ");
INSERT INTO cabNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abrahám lé meja binádu júguchi, gúndaati meja láu lasúbudiruni luágu lachǘlürüba lan nuwéyuri lun niábin uboúagun queísi asálbaragülei, buin líña láu ugúndani dan laríjini wéyu ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ábati jaríñagun juríu lun Jesúsu. —Úagubeigili ni dimí-san irúmu báu, ¿aríñagatibu luágu aríja báni Abrahám? ");
INSERT INTO cabNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ába laríñagun Jesúsu joun. —Ninárün jáu luágu lubáragiñe lan ñi lan Abrahám, anájeinjadina. ");
INSERT INTO cabNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ába jabúdajan dǘbü lun jachǘraguni luágu, ába larámudagun, ába láfuridun témpulurugugiñe, ába lásügürün jamídaangiñe, ába lídin. ");
INSERT INTO cabNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lídan le lásügürün Jesúsu lídaangiñe ában fulásu, ába laríjin ában wügǘri maríjinti lúmagiñe lagǘriajoún. ");
INSERT INTO cabNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ába jaríñagun láni disípulugu lun. —Maésturu, ¿cásan uágu lagǘriajoúnbei wügǘri le maríjinga? ¿Ladǘgasan jafígoun lagǘbürigu, o ladǘga lifígoun guánarü? ");
INSERT INTO cabNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ába laríñagun Jesúsu joun. —Máma ladǘga lifígoun, máma gíñe ladǘga jafígoun lagǘbürigu, lasúseredunbei ítara lun larijoúniwa le luáraabei Búngiu adǘga láu lareídagun wügǘri ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Lúnti nadǘgüni luwádigimari Búngiu le oúnajabalina sun wínwangidina lan, jiláadina ligíame, siñáme nadǘgüni. ");
INSERT INTO cabNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sun dan anája lan ligíbuagu uboú le, áu lilámpunbei uboú. ");
INSERT INTO cabNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Lárigiñe laríñaguni Jesúsu cátei le, ába lásuerun múarugun, ába ladǘgün murúsun gubégubeti láu larǘre, ába lájuruduni luágu lágu le maríjinbei. ");
INSERT INTO cabNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ába laríñagun lun. —Beíba achíbei bigíbu lídan dúna le gíribei Siloé —míni lan líra, Oúnajoúti. Ába lídin maríjinti ligía, ába lachíbuni ligíbu ñi, dan le lagíribudunbei, aríjaali. ");
INSERT INTO cabNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Játi lubésinanigu jáma gürígia já meja aríjubalin amúriaja, ába jaríñagun. —¿Másan nijáñaja le añúurubei amúriaja seínsu? ");
INSERT INTO cabNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ñíñanu aríñagutiña. —Ánja, ligía. Jaríñaga jíbiri. —Máma ligía, lenége. Ába laríñagun wügǘri ligía. —Ánja, áu. ");
INSERT INTO cabNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ábati jaríñagun lun. —¿Ída liñáti aríjaadibu lubeí? ");
INSERT INTO cabNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ába laríñagun joun. —Wügǘri le gíribei Jesúsu, ligía adǘgübei murúsun gubégubeti, ába lájuruduni luágu nágu, ába laríñagun nun. “Beíba lídan dúna le gíribei Siloé, ábame bachíbuni bigíbu ñi.” Ábati nídin, lásun nachíbuni nigíbu, ába naríjin. ");
INSERT INTO cabNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ábati jaríñagun lun. —¿Jageígi wügǘri ligía? Laríñaga joun. —Ibídiñeti nun jageí lan. ");
INSERT INTO cabNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ábati janǘgüni wügǘri lé meja maríjinbei jagíbugiñoún fariséogu. ");
INSERT INTO cabNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Queíti lídan lan wéyu le eméraaguagülei ladǘgei Jesúsu gubégubeti le áubei lareídaguagüdei maríjinti ligía, ");
INSERT INTO cabNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ába gíñe jálügüdüni fariséogu wügǘri ligía ída líña lan gayáraajali lubeí laríjin. Ába laríñagun joun. —Ába líchugun gubégubeti luágu nágu, ába nachíbuni nigíbu, guetó aríjaadina. ");
INSERT INTO cabNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ábati jaríñagun jádaangiñe fariséogu. —Le wügǘri le adǘgübalin cátei le, siñáti loúnagüle lan Búngiu ladǘga minébenti wéyu le eméraaguagülei lun. Jaríñagati jíbiri. —¿Ída liñáti ladáaguni buri miláguru le, ánjein gafígoun lubeí? Ába lubeíti ñi lan fánreinguaü jádan. ");
INSERT INTO cabNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ábaya jálügüdüni lé meja maríjinbei. —Ángi bugúya, ¿cági baríñagubei luágu wügǘri le, queísi bugúya lubeí le laríjagüdübei? Ába laríñagun. —Nugúya, naríñagun luágu ában lan proféta. ");
INSERT INTO cabNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Májatiña yebe fariséogu jafíñerun luágu maríjin lán meja wügǘri ligía áni aríjaali lan guetó, darí lun jagúarun joun lagǘbürigu, ");
INSERT INTO cabNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ába jaríñagun joun. —¿Nijánsan jiraǘ le uágubei jaríñaga luágu maríjin gubeíñein lan lúmagiñe lagǘriajoún? ¿Ída liñáti aríjaali lubeí guetó? ");
INSERT INTO cabNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ába jaríñagun lagǘbürigu. —Subúdi wamúti luágu waraǘ lan le, áni maríjin lan dan le lagǘriajoúnbei, ");
INSERT INTO cabNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ibídiñeti woun ída líña lan aríjaali lubeí, ni ca lan areídaguagüdübalin lágu. Álügüda jumeí, weíriyaali, gayáraati loúnabun lueígiñegua. ");
INSERT INTO cabNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Anúfudeiti aríñagagüdübalin líra joun lagǘbürigu wügǘri ligía, ladǘga aríñagaaña lan fariséogu luágu sun lan ja afíñerutiña luágu Jesúsu lan Crístubei, jabugúba lan tídaangiñe jalígilisin juríu. ");
INSERT INTO cabNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ligía jaríñagunbei lagǘbürigu. “Álügüda jumeí, weíriyaali.” ");
INSERT INTO cabNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ábayati jagúarun juríu lun wügǘri lé meja maríjinbei, ába jaríñagun lun. —Aríñagabeí inárüni woun ligíbugiñe Búngiu, wagía, subúditi woun luágu gafígoun lan wügǘri líra. ");
INSERT INTO cabNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ábati laríñagun joun. —Ibídiñeti nun ánjein gafígoun lubeí lúmoun mafígoun lan. Le nasúbudirubei, luágu maríjin nán meja, áni guetó aríjaadina. ");
INSERT INTO cabNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ábaya jaríñagun lun. —¿Cásan ladǘgübei báu? ¿Ída liñásan ladǘga lun laríjagüdünibu? ");
INSERT INTO cabNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ába laríñagun joun. —Aríñaga náali jun, mebéreseguntün náu, ¿cáti uágu jabúseera naríñaguniya jun? ¿Ódi buséntün gíñe jafálaruni? ");
INSERT INTO cabNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ábati janábuni, ába jaríñagun lun. —Bugúya, falá bumuti larúfudajan wügǘri ligía, ánjein wagía, larúfudajan Moisés wafálarubei. ");
INSERT INTO cabNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Subúditi woun luágu adímureja lán meja Búngiu lun Moisés, ánjein le, ibídiñegubeíti woun jalíagiñeti lan. ");
INSERT INTO cabNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ábati laríñagun wügǘri ligía joun. —¡Ámuti gíñe cátei le! ¡Ibídiñeti jun jalíagiñeti lan, áni aríjagüda lána! ");
INSERT INTO cabNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Subúditi woun luágu magáambun lániña Búngiu gafígountiña, ja rügǘñanu ájuduragubaña lun jáma ja adǘgübalin lugúndan, lagáamba. ");
INSERT INTO cabNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Magáambuñajagili luágu ni ában aríjagüdǘti ában gürígia le agǘriajoúti maríjinga. ");
INSERT INTO cabNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Lun jamúga máma lan lúmagiñe Búngiu liábin wügǘri le, siñáti jamúga ladǘgün ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ábati jaríñagun lun. —¿Bugúyasan le agǘriajoúbei buin láu figoú, buséntibu barúfudajan woun? Ába jabúguni tídaangiñe jalígilisin. ");
INSERT INTO cabNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ába lagáambuni Jesúsu luágu bugá jamaani maríjinti meja ligía, dánti le ladúnragun lúma, ába laríñagun lun. —¿Afíñetibu luágu Liraǘ Búngiu? ");
INSERT INTO cabNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ába laríñagun wügǘri ligía lun. —Aríñagabeí nun cátei lan, afíñe námuga luágu. ");
INSERT INTO cabNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ába laríñagun Jesúsu lun. —Aríja báali, áu le úmabei badímureja. ");
INSERT INTO cabNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ába lájuduragun ligíbugiñe Jesúsu, ába laríñagun. —Afíñetina, Nabúreme. ");
INSERT INTO cabNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ába laríñagun Jesúsu. —Niábinbei ñájoun uboúagun lun néfegechagǘdüni jágu ja ibídiñejabubaña lun cátei lánina Búngiu, lun gíñe narúfuduni luágu ja lan aríñagubaña luágu fegé lan jágu luágu buri cátei lánina Búngiu, maríjin jamá ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Dan le jagáambunbalin jádaangiñe fariséogu ja ñíbaña cátei le, ába jaríñagun lun. —¿Baríñaguñati luágu darúñu líña lan gíñe wágu lun cátei le luáguti Búngiu? ");
INSERT INTO cabNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Laríñaga Jesúsu joun. —Lun jamúga ibídiñe lan cátei lánina Búngiu jun, madúnruntün jamúga luágu jifígoun, quei jaríñagun luágu subúdi jumáni, gadúnruntün. ");
INSERT INTO cabNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","‘Ninárün jáu luágu le lan mebéluti lídaangiñe lubéneri jabárierun mudún, lun lebélurun lídaangiñe ámu oúbaü, jíweruti. ");
INSERT INTO cabNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ánjeinti le ebélurubei lídaangiñe béna, ligía le oúnigirubaliña mudún. ");
INSERT INTO cabNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ába lánjunrenchuni le oúnigirubalin béna béna lun, lun lebélurun, subúdi jamúti gíñe mudún lumálali. Ába lagúajan joun láu jíri, ába laságaraguniña baríerurugugiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lárigiñe laságaraguniña súngubei, ába lídin eíbugeina jabá jabá, ába jafálaruni ladǘga subúdi jamáni lumálali. ");
INSERT INTO cabNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mídintiña lárigi ában le ibídiñeti joun, anúrajarügütiña lueí ladǘga ibídiñeti jamálali ámu mútu joun. ");
INSERT INTO cabNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Rúlumuti Jesúsu jémpulu le joun, úati gunfaráanda jamáni le labúseerubei laríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ábayati laríñagun Jesúsu joun. —Ninárün jáu, áu béna le ñígiñe lubeí gayára lan jayábin gürígia lun lánigu jamá Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ja ñǘbinbaña nubáragiñe, ítara jáña queísi jíwerutiña mudún ladǘga iyéeni lan jarúfudajabei, madǘgütiña lánigu Búngiu gásu jáu. ");
INSERT INTO cabNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Áu bénabei, le ebéluruti nueígiñe, lasálbarúaba. Ítara lúba quei ában mudún le ebéluruti furí ligía baríerurugugiñe, darí ligía sagádi lun leígin. ");
INSERT INTO cabNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","‘Jíweruti, liábin rügǘña lun líwerujan, lun láfarajan lúma lun lagǘnrinchagun, ánjein áu, niábiña lun jibíjin ibágari, áni lun jibíjini gíbe. ");
INSERT INTO cabNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Áu, ítara níña queísi ában joúniri mudún le buíti, le gayáraati líchuguni libágari jawágu lilǘgüniña mudún. ");
INSERT INTO cabNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ánjein le ñadágimeinrügüti luágu fáyeiti, dan le laríjin liábin anímaalu le jabísa mudún, ába lígiruniña mudún, ába leíbaagun, ladǘga máma lan oúnigiruti buíti ligía, máma gíñe lilǘgüniña mudún. Ábati liábin jabísa mudún, ába lawáraüdaguagüdüniña. ");
INSERT INTO cabNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wügǘri ligía eíbaaguati ladǘga luwádigimariña lan luágurügü fáyeiti, mebéresegúnti jáu mudún. ");
INSERT INTO cabNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","‘Áu oúnigirutibei buíti. Ítara quei nisúbudin lun Núguchi áni subúdi Núguchi nun, ítara líña gíñe jasúbudin nánigu nun, subúdi jamána gíñe queísi subúdi jamáni mudún joúniri. Rúnumuti nibágari jawágu queísi líchuguni oúnigiruti mudún libágari jawágu lilǘgüniña mudún. ");
INSERT INTO cabNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Añájein gíñe ámu gürígia ja lúnbaña nánigu jamá ja mámabaña juríu, lúnti gíñe nanǘgüniña lun nánigu jamá. Jagáambubadina, ábame jeréderun súngubei lídan ában lúma ában oúnigiruti. ");
INSERT INTO cabNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","‘Jínsiñetina lun Núguchi, ladǘga níchugubei nibágari luágu uboú, ligía ábayame nibíjini. ");
INSERT INTO cabNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Magída lubeí ni ában gürígia nibágari, láuba nugúndan níchigei. Garíchatina lun níchuguni lúma lúnya nerésibiruni. Ligía cátei le laríñagubei Núguchi nun. ");
INSERT INTO cabNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Dan le jagáambubalin juríu dimúrei buri le, ábaya jafánreinragun. ");
INSERT INTO cabNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sarágu jáña jádaangiñe aríñagutiña. —¿Cásan uágu jadǘga gásu láu, níjeingusan espíritu wuríbati lídan áni lǘlüjali láu? ");
INSERT INTO cabNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jaríñaga jíbiri. —Úati ni ában le láuti espíritu wuríbati lun gayára lan ladímurejan ítara. ¿Gayáraati funági laríjagüdün espíritu wuríbati maríjintiña? ");
INSERT INTO cabNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Dan ligía lidáani luríbouga, ladügǘñati fédu le lánina tedéregerún témpulu Jerusalén lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ñíñeinti Jesúsu eíbugañaja témpulurugu luágu corredór le gíribei Láni Salomón corredór. ");
INSERT INTO cabNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ába jagúriridagun juríu láu, ába jaríñagun lun. —¿Darísan ídaba bígirawa láu machoúruni? Ánjein amǘrü lubeí Crístubei, aríñagabeí furáangu. ");
INSERT INTO cabNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ába laríñagun Jesúsu joun. —Aríñaga náali, mafíñetün nun. Sún buri cátei le nadáagubei láu lugúmadin Núguchi, arúfuda lumúti furáangu. ");
INSERT INTO cabNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Jugúya, mafíñetün ladǘga máma jumá jádaangiñe nilǘgüniña mudún quei bugája naríñaguni jun. ");
INSERT INTO cabNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Subúdi jamúti nilǘgüniña mudún numálali, subúdi numútiña gíñe, áni falá jamutina. ");
INSERT INTO cabNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Rútina ibágari magúmuchaditi joun áni meféridirubaña, úabei gíñe agídarutiña nújaburugugiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Núguchi le weíribei jaweí súngubei, ligía íchugubaliña nun, áni úati ni ában lun lagídaruniña lújaburugugiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Áu lúma Búngiu Úguchili ában méme wagía. ");
INSERT INTO cabNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ábayati jabúdajan juríu dǘbü lun jachǘraguni luágun. ");
INSERT INTO cabNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ába laríñagun Jesúsu joun. —Gíbeeli cátei buíti nadǘga jigíbugiñe láu lubáfu Búngiu, ¿cábagi lídaangiñe uágu jíchaagua dǘbü nuágu? ");
INSERT INTO cabNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ába jaríñagun juríu lun. —Míchaagunbadiwa dǘbü buágu luágu ni cáta buíti badǘga, ladǘga anába báali lan Búngiu láu berérun. Wügǘri rügǘñadibu, áni bíchaaguña búngua quei Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ábati laríñagun Jesúsu joun. —Bürǘwati lídan jilúrudun luágu aríñaga lan Búngiu. “búngiu buri jugúya”. ");
INSERT INTO cabNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Subúditi woun luágu siñá lan leyéedawagún láu le taríñagubei Lerérun Búngiu, áni aríñagatu líburu tugúya luágu wa lániña Búngiu gürígia ja erésibirubalin lerérun lun jíchuguni joun gürígia, quei búngiugu. ");
INSERT INTO cabNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ánjeinti anúadaja lubálina Búngiu, ába loúnajanina uboúagun, ¿ída liñáti jaríñagunbei luágu anába náni láu naríñagun luágu Liraǘ nan Búngiu? ");
INSERT INTO cabNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ánjein madǘgün nan cátei lé buri ladǘgübei Núguchi, mafíñera jumá nun, ");
INSERT INTO cabNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ánjein nadǘga, íbini mafíñerun jumá nun, afíñe jumá luágu buri cátei le nadǘgübei, subúdi jumámugei luágu níjein lan Núguchi nídan, áni anájein lan gíñe lídan Núguchi. ");
INSERT INTO cabNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ábaya jálugun jadáürüni, ába leséfurun jaweí. ");
INSERT INTO cabNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ábati lagíribudun Jesúsu loubáfurugun dúna Jordán, ába leréderun ñi lídan fulásu le ñí lubeí meja labásteragüdaja Juan. ");
INSERT INTO cabNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Sarágu jáña gürígia ñǘdüntiña aríjei, ába buri jaríñagun. —Láu sun madǘgün lan Juan ni ában miláguru, inárüni sun le laríñagubei luágu wügǘri le. ");
INSERT INTO cabNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ába jafíñerun sarágu gürígia luágu Jesúsu lídan fulásu ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ñíñein ában wügǘri sánditi, gíriti Lázaro, lílana fulásu le gíribei Betánia, le tageíra María túma Márta to tíbugaña. ");
INSERT INTO cabNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María tugúya, to lítu Lázaro le sándibei, tugúya to éseruboun ibíñei luágun lugúdi Jesúsu, ába tarágajani láu tídiburi. ");
INSERT INTO cabNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ábati joúnajan bián ítunu ja, aríñaga lun Jesúsu. —Jesúsu, sándiñeintia bumáda. ");
INSERT INTO cabNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Dan lagáambunbalin Jesúsu cátei le, ába laríñagun. —Mámabei oúweni lébeja cátei lídaangiñe sándi le, lúntibei larijíniwa luweírigun Búngiu, lúma gíñe lun larijíniwa luweírigun Liraǘ Búngiu lídaangiñe sándi ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Láu sun weíri lan jínsiñe Márta, María, lúma Lázaro lun Jesúsu, ");
INSERT INTO cabNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","dan le jaríñawagúnbei lun luágu sándiñein lan Lázaro, reídeigili bián wéyu lídan fulásu le ñí lubei. ");
INSERT INTO cabNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Lárigiñe, ába laríñagun joun láni disípulugu. —Queímounya Judéa. ");
INSERT INTO cabNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ábati jaríñagun lun. —Maésturu, málügili lueígiñe jálugun juríu jáfarunibu láu dǘbü ñi, ¿busényadibu bídin ñi? ");
INSERT INTO cabNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ába laríñagun Jesúsu joun. —¿Ma dúusuñein óra lídan ában wéyu? Ánjein lubeíti eíbuga ában gürígia wéyuagu, machúgeragúnbei, ladǘga laríjubei lan larúgounga le yábei uboúagu, ");
INSERT INTO cabNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ánjein eíbuga áriebu, lachúgeraguba ladǘga lubúriga. ");
INSERT INTO cabNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Lárigiñe, ába laríñagun Jesúsu joun. —Arúmuga wamáda Lázaro, neíbuga agágudajei. ");
INSERT INTO cabNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ábati jaríñagun disípulugu lun. —Maésturu, ánjein arúmuga lubeí, lareídaguárügü líña. ");
INSERT INTO cabNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Míni lánti Jesúsu luágu jilá lan Lázaro, jarítagunti disípulugu luágu luágu lan furúmieguarügü arúmuguni ladímureja. ");
INSERT INTO cabNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ábati laríñagun Jesúsu joun, furáangu. —Jilá Lázaro. ");
INSERT INTO cabNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Gúndaatina láu úa nan ñi, ladǘga buítimaati ítara jun, afíñe jumámuga. Queímoun waríjei. ");
INSERT INTO cabNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ábati laríñagun Tomás, le únbei jaríñaga Mádou, joun jíbiri disípulugu. —Queímoun gíñe, jilá wamámuga úara lúma. ");
INSERT INTO cabNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Dan le lachǘlürünbei Jesúsu, gádürüjali wéyu lueígiñe labunún Lázaro. ");
INSERT INTO cabNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Lidíse Betánia lueí Jerusalén quei bián quilómetros dimí. ");
INSERT INTO cabNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Sarágu jáñati jádaangiñe juríu ñǘdüntiña Jerusaléngiñe bisídoun Márta túma María lun jíchugun ñurúguaü joun luágu loúnwen jamúlen. ");
INSERT INTO cabNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Dan tagáambunbei Márta luágu níteeli lan Jesúsu achǘlüreina, ába táfuridun lubároun, ánjoun María, ába teréderun múnada. ");
INSERT INTO cabNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ába taríñagun Márta lun Jesúsu. —Lun jamúga ya ban, moúnwenti jamúga namúlen, ");
INSERT INTO cabNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","áni subúditi nun luágu líchugubei lan Búngiu sun le bamúriajan lúma bun. ");
INSERT INTO cabNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Laríñaga Jesúsu tun. —Labágaridayaba bamúlen. ");
INSERT INTO cabNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Taríñaga Márta lun. —Ánja, subúditi nun luágu labágaridayaba lan lídaanme jásaarun jiláguaaña lídan lagúmujoún wéyu. ");
INSERT INTO cabNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ábati laríñagun Jesúsu tun. —Áu le ásaaragüdübaliña jiláaña, rúneí jabágari joun lárigoún. Le afíñeti nuágu, gayáraati loúnwen, labágaridayaba, ");
INSERT INTO cabNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","áni sun le wínwangilibei áni afíñeti nuágu, labágariduba gíñe lúma Búngiu súnwandan. ¿Afíñetibu? ");
INSERT INTO cabNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Taríñaga lun. —Ánja, Nabúreme, afíñetiña luágu bugúya lan Crístubei le Liraǘ Búngiu, lé meja lúnbei liábin uboúagun. ");
INSERT INTO cabNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Lárigiñe taríñaguni Márta le, ába tídin oúgoun María, ába taríñagun tun joúnguarügü. —Níjein Maésturu ya lún nege bídin lun. ");
INSERT INTO cabNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Quei tagáambuni María cátei le, ába tásaarun, ába tídin furése aríjei Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mebélugiliti Jesúsu ubúrugun, lídaañein fulásu le ñí lubei tadárirei Márta. ");
INSERT INTO cabNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Dan le jaríjinbei juríu ja ñíbaña múnada túma María ámalijoun tásaarun ába táfuridun furésegueina, ába joúdin tárigi, jarítagun luágu teíbuga lán yebe luágu umúajaü ayájua. ");
INSERT INTO cabNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Dánti le tachǘlürünbei María le ñíjin lubeí Jesúsu, ába tájuduragun ligíbugiñe, ába taríñagun. —Nabúreme, lun jamúga ya ban, moúnwenti jamúga namúlen. ");
INSERT INTO cabNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Dan le laríjin Jesúsu tayájun María jáma juríu ja ñǘbinbaña túma, ába lírudagun tídan lanígi, ");
INSERT INTO cabNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ába laríñagun joun. —¿Jalíasan jábunei? Ába jaríñagun lun. —Jigábu baríjei. ");
INSERT INTO cabNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ába layájun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ábati jaríñagun juríu. —¡Aríja jumá luweírin meja línsiñe lun! ");
INSERT INTO cabNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ñíñanu jádaangiñe aríñagutiña. —Niján le aríjagüdübalin wügǘri le maríjinbei, ¿siñáti jamúga funásan ladǘgün lun moúnwen lan Lázaro? ");
INSERT INTO cabNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ábaya tírudagun lanígi Jesúsu, ába layárafadun lun umúajaü. Umúajaü ligía ában júyu luágu dǘbü, ñíñein ában dǘbü lidaǘme. ");
INSERT INTO cabNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ába laríñagun Jesúsu. —Gidájumei dǘbü. Ába taríñagun Márta lun. —Mósutia jíngiaali lan ladǘga gádürü wéyu lueígiñe loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ába laríñagun Jesúsu tun. —¿Másan aríñagatina bun luágu ánjabu lan afíñe nuágu, baríjubei lan luweírigun Búngiu? ");
INSERT INTO cabNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ábati jagídaruni dǘbü, ába laríjin Jesúsu siélun, ába laríñagun. —Núguchi, teínqui numútibu luágu bagáambunina. ");
INSERT INTO cabNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Subúdi numúti luágu agáamba bánina súnwandan, naríñaguñein líra jawágu gürígia ja, ja yábaña, lun jafíñerun luágu amǘrü lan oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Lárigiñe laríñaguni cátei le, ába lagúaragun. —¡Lázaro, furíba ñígiñe! ");
INSERT INTO cabNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ába láfuridun jiláali láu lújabu lúma lugúdi gürágu táu gamísa, lúma ligíbu táu ában gamísa. Ába laríñagun Jesúsu joun. —Farára jumeí, ígira jumeí lun lídin. ");
INSERT INTO cabNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Láu lasúseredun líra, sarágu jádaangiñe juríu ja ñǘdünbaña túma María, aríja jameí le ladǘgübei Jesúsu, ába jafíñerun luágu. ");
INSERT INTO cabNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ñíñanu jádaangiñe, ába joúdin jámoun fariséogu, ába jabájüdaguni le ladǘgübei Jesúsu joun. ");
INSERT INTO cabNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ábati jayábin fariséogu jáma jábutigu fádirigu, ába joúndaragun jáma jíñun-ágei agúmadijatiña, ába jaríñagun. —¿Cábasan wadǘga? Ladáaguñatia wügǘri le sarágu miláguru. ");
INSERT INTO cabNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ánjeinti wígira ítara, jafíñeruba sun gürígia luágu, ábameti jayábin gumádimatiña Rómana, ábame jagúmuchaguagüdünun walígilisin láu sun warásan. ");
INSERT INTO cabNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ñíñein ában jádaangiñe, gíriti Gáifasi, ligía jábutibei fádirigu lídan irúmu ligía, ába laríñagun joun. —Ibídiñeti ni cáta jun, ");
INSERT INTO cabNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","maríjin jumeí luágu buítima lan woun lun loúnwen ábanrügü wügǘri jawágu jíbiri, máma lun lagǘnrinchawagún sun warásan. ");
INSERT INTO cabNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Máma láu láni Gáifasi lúngua laríñagei líra, ladǘga quei ligía lan fádiri le íñutimaabei lídan irúmu ligía, ába laríñagagüdüni Búngiu lun, luágu loúweba lan Jesúsu jawágu juríu, ");
INSERT INTO cabNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","áni mámarügü jawágu juríu, lun giñe loúndaruniña sun lirájüñü Búngiu ja díseguabaña jawáriuagua. ");
INSERT INTO cabNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Lúmagiñeti wéyu ligía, ába jagúmeserun agúmadijatiña aráanseja lun jáfaruni Jesúsu jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ligía ába lubeí meíbugunjaali lan Jesúsu furáangu jádan juríu, ába láfuridun Judéagiñe, ába lídin lídoun ában fulásu gíriti Efraín, yaráfa lun fulásu mageírawati. Ába leréderun ñi jáma láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yaráfaaliti jafédun juríu le gíribei páscua, sarágu jáña gürÍgia ñǘdün Jerusalén lun jadǘgüni igáburi le lánina jarúmadun lubáragiñe fédu ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jáluajañeinti Jesúsu, dánti le témpulurugúñanu lan, ába jálügüdajan jámagua. —¿Ca jaríñagubei? ¿Liábinba lídan fédu, ódi miábinbei? ");
INSERT INTO cabNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Rújañati fariséogu jáma jábutigu fádirigu dimúrei lun le lan asúbudiruti jalíañein lan Jesúsu, lun lan laríñaguni, barǘ jamámugei adáüra. ");
INSERT INTO cabNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sísi wéyu lubáragiñe páscua, ába lídin Jesúsu Betánia, le ñí lubei lagánawa Lázaro le lásaaragüdübei jádaangiñe jiláaña lúnya labágaridun. ");
INSERT INTO cabNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ába jadǘgün ában adíneruni ñi luágu láni fuleísei, Márta, tugúya éjeeraguboun, Lázaro ában jádaangiñe ja ñúnbaña luágu dábula lúma Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ábati tanǘgün María ában paénti ibíñei le séruti, ába tájurudaguni lugúdi Jesúsu láu, ába tarágajani láu tídiburi, ába lejémougadun ibíñei ligía sun ñi múnada. ");
INSERT INTO cabNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ába laríñagun Júdas Iscarióte, le liraǘ Simón, ában jádaangiñe láni Jesúsu disípulugu, le méme lúnbei lalúguruni. ");
INSERT INTO cabNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Ánsan malúgurún lubeí ibíñei le luágu ǘrüwa-san fiádürü lun jíderawagún gudémetiña? ");
INSERT INTO cabNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Laríñagunbei Júdas ítara, máma luágu berése lan jáu gudémetiña, laríñagunbei ítara ladǘga jíweru lan, áni queíti ligía lan gámabarun lágei seínsu, ábaja líwerujan lídaangiñe le íchugúbei tídoun. ");
INSERT INTO cabNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ábati laríñagun Jesúsu lun. —Ígiraboún, taráanseruñadina lubá lachǘlürün luwéyuri nábunúniwa. ");
INSERT INTO cabNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Súnwandan ñíbaña lan gudémetiña jídan, ánjeinti áu, mámaba súnwandan júma nan. ");
INSERT INTO cabNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ába jasúbudiruni sarágu jádaangiñe juríu luágu níjein lan Jesúsu Betánia, ába joúdin ñi, mámarügü lun jaríjini, lun giñe jaríjini Lázaro le lásaaragüdübei Jesúsu jádaangiñe jiláaña. ");
INSERT INTO cabNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ába giñéti juáradun jábutigu fádirigu lídan ában lun gíñe jáfaruni Lázaro, ");
INSERT INTO cabNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ladǘga sarágu jáña lan juríu adíseduntiña jaweí lun jafíñerun luágu Jesúsu, lídaangiñeti Lázaro. ");
INSERT INTO cabNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sarágu jáña gürígia ñǘdüntiña Jerusalén lubá fédu le páscua, larúgan, ába jasúbudiruni luágu lachǘlürüba lan Jesúsu ñíjin ubúrugun. ");
INSERT INTO cabNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ábati játüjan tubána fáluma, ába jáfuridun lubároun Jesúsu agúarajeina. —¡Uweíriguni lun Búngiu! ¡Biníwati le ñǘbinbei lídan líri Wabúreme! ¡Biníwati lurúeite Israél! ");
INSERT INTO cabNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ába ladárirun Jesúsu ában burígü, ába laweínruni quei laríñagun tídan Lerérun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Manúfudebá, ubúrugu le Sión, níten burúeite waríñu luágu ában burígü. ");
INSERT INTO cabNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Úati yebe gunfaráanda jamáni láni disípulugu cátei le wéyu ligía, lárigiñe, dan le belújali Jesúsu lídoun luweírigun yágüta siélu, ába jarítagun luágu bürǘwa lan sun cátei le luágu, áni ítara líña lan lasúseredun lun. ");
INSERT INTO cabNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ja gürígia ja ñíbaña dan le lagúarun Jesúsu lun Lázaro lídaangiñe lumúaja, ába lásaaragüdüni lídaangiñe oúweni, abájüdagua jamúti le jaríjubei. ");
INSERT INTO cabNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ligía lébubei jáfuridun gürígia erésibirei Jesúsu, ladǘga jagáambun luágu miláguru le ladǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ábati jaríñagun fariséogu jámagua. —Aríja jumáali luágu, siñá lan ladügǘniwa ni cáta, sun gürígia añágüran lúma. ");
INSERT INTO cabNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ñíñanu güriégu jádan gürígia ja ñǘdünbaña Jerusalén lun jájuduragun lun Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ába jayábin güriégu jagía lúmoun Felípe, le Betsáidana, ñi Galiléa, ába jaríñagun lun. —Buséntiwa waríjini Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ába lídin Felípe, ába laríñaguni lun Andrés, ába joúdin biángubei jagía abájüdaguei lun Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ábati laríñagun Jesúsu joun. —Chülǘja óra lun líchugúniwa uweíriguni nun, áu le Wügǘri Garaǘwarügüti. ");
INSERT INTO cabNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ninárün jáu luágu ánjein lan máburujan ában lágu türígu múarugun lun loúnwen, ában mémebei águu, ánjein oúwe, lalúbajoúba sarágu lídaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Le jínsiñejabuti lun libágari, leféridirubei, ánjein le mebéresenti láu libágari lídan uboú le, lareídubei lubá ibágari le magúmuchaditi, siélu. ");
INSERT INTO cabNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Le busénti lesériwidunina, lúnti lafálarunina, áni le ñí numuti, ñíbei gíñe le esériwidubalina. Le esériwidutina, líchuguba Núguchi uweíriguni lun. ");
INSERT INTO cabNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","‘Níjein ában oúnwenbun líbe samínaü nuágu guetó. ¿Cábasan naríñaga? ¿Naríñaga funa. “Núguchi, sálba bána lídaangiñe le lúnbei lasúseredun nun guetó”? Uá, lun líra niábin. ");
INSERT INTO cabNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Núguchi, iñurúalá bíri nídaangiñe. Ábati lagaambúniwa ában umálali siélugiñe le aríñagubei. —Iñúra náali níri bídaangiñe, áni niñúruyabei. ");
INSERT INTO cabNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ábati jaríñagun gürígia ja ñíbaña agáambaja luágu wayújururu lan, jíbiri aríñaga. —Ában ánjeli adímurejabei lun. ");
INSERT INTO cabNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ábati laríñagun Jesúsu joun. —Mámatia luágu nufúleisein lagaambúa umálali le, luágu jufúleisein. ");
INSERT INTO cabNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Niján dan ligía lun lagúserawagüdǘn uboú, áni guetóba leféridirei Máfia, le agúmadijabei lídan uboú le, lubáfu. ");
INSERT INTO cabNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Dánmeti le niñurúniwa múarugugíñe, nanǘgübaña súngubei númoun. ");
INSERT INTO cabNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Láu líra laríñaguñein luágu loúweba lan luágu ában gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ába jaríñagun gürígia lun. —Agáambaadiwa laliijoún tídan walíburun to lánina lilúrudun Moisés luágu labágariduba lan Crístu lun sun dan. ¿Ída liñáti baríñagunbei luágu liñurúaba lan Wügǘri Garaǘwarügüti? ¿Cáteigi Wügǘri Garaǘwarügüti ligía? ");
INSERT INTO cabNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ábati laríñagun Jesúsu joun. —Níchiga mémebei larúgounga jun luágurügü murúsun dan. Eíbuga jumá lídan larúgounga ligía sun anájagua lan júma lun gayáraabei lan jachǘlürün le ñíjin lubeí jabúseera jachǘlürün, márügüdün lámugaün lubúriga, ladǘga le eíbuguti lídan lubúriga, ibídiñeti lun jalíñouñein lan. ");
INSERT INTO cabNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Afíñe jumá lubeíti nuágu sun anájagua lan júma lun lirájüñü jumá larúgounga. Lárigiñe laríñaguni Jesúsu sún buri cátei le, ába lídin, ába larámudagun jaweí. ");
INSERT INTO cabNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Láu sun adǘga lan Jesúsu sarágu miláguru jagíbugiñe, mafíñetiña luágu. ");
INSERT INTO cabNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Láu líra jagúnfulirei le laríñagubei proféta Isaías. ¿Cásan afíñerubei luágu wáni ugánu? ¿Ca un larúfudei Wabúreme Búngiu lubáfu? ");
INSERT INTO cabNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Quei mafíñerun jabeí, ába lasúseredun le ámu dimúrei le laríñagubei Isaías tídan labǘrüjan, joun. ");
INSERT INTO cabNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Darú lumuti Búngiu jaríjin, derégüda loun janígi, lun maríjin jamá láu jágu, úame gunfaráanda jamá, mayábin jagíame nun lun nareídaguagüdüniña. ");
INSERT INTO cabNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Laríñagunbalin Isaías le luágu Jesúsu ladǘga aríja láali lan luweírigun. ");
INSERT INTO cabNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Láu sun líra, sarágu jáña jádaangiñe juríu afíñerutiña luágu Jesúsu ásta jádaangiñe ábutigu, áni maríñagun jamúti boúgudi, le janúfude jaweí fariséogu, lueí jabúguniña tídaangiñe jalígilisin. ");
INSERT INTO cabNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ladǘga gúndaatimaatiña láu inébesei le jíchugubei gürígia sügǘ láu le líchugubei Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ába laríñagun Jesúsu láu umálali jéreti. —Le afíñeti nuágu, máma rügǘñein nuágu lafíñera, afíñeti gíñe luágu Núguchi le oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Le gíñe aríjitina, laríjiñein gíñe le oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Áu lámpubei, niábinbei uboúagun lun sun lan ja afíñetiña nuágu, merédera jamámuga lídan lubúriga. ");
INSERT INTO cabNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ánjein le agáambuti nerérun áni madǘgünti gásu láu, máma áu asíadirubalin, ladǘga máma niábiña lun nasíadiruniña gürígia uboúagu, niábiña asálbaraña. ");
INSERT INTO cabNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Le mebéresenti náu, madǘgün ligía gásu láu nerérun, níjein lúnti lasíadiruni. dimúrei buri le aríñaga náalibei, ligíaba asíadirei lídaanme lagúmujoún wéyu. ");
INSERT INTO cabNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ladǘga madímurejaantina luágu náni núngua, Núguchi le oúnajabalina, ligía aríñagubalin le lúnbei naríñaguni nun lúma le lúnbei narúfudajani. ");
INSERT INTO cabNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Áni subúdi numúti luágu barǘ lan lugúmadin Núguchi ibágari magúmuchaditi joun ja adǘgübalin le lubeíbei. Le lubeíti naríñagubei, naríñaguni quei laríñaguni Núguchi nun. ");
INSERT INTO cabNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ábanrügaali wéyu lubá fédu le páscua. Subúdi láali Jesúsu luágu chülǘja lan óra lun lígiruni uboú le lun lídin lúmoun Lúguchi. Súnwandan meja jínsiñe jamá lánigu ja uboúagubaña lun, guetó larúfuduñeinti línsiñejabu lídan luweírin-ágei. ");
INSERT INTO cabNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Dálaalíti Máfia larítagun tídoun lanígi Júdas Iscarióte lun ledéregeruni Jesúsu joun láganiñu. Jesúsu, láu sun subúdi láni luágu lúmagiñe lan Búngiu liábin, luágu lúmounba lan gíñe Búngiu lagíribuda, luágu gíñe rúlaali lan Úguchili sun cátei lújaburugun, ába larúfuduni luweírin-ágei ǘnabuni le luágubei. Dan lubeíti jadíneruña lan, ába lásaarun lueígiñe dábula, ába larágachunun gamísa to tigíbuaguboun ladáüragun, ába lagǘrün ában tuáya liránaagua. ");
INSERT INTO cabNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ába líchugun dúna lídoun ában dabárasi, ába lachíbuni jagúdi disípulugu, ába larágachuni táu tuáya to liránaaguaboun. ");
INSERT INTO cabNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Dán yebe le lachíbaali lan lugúdi Simón Pédro, ába laríñagun lun. —Nabúreme, ¿bachíbaalisan nugúdi? ");
INSERT INTO cabNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ába laríñagun Jesúsu lun. —Guetó, úati gunfaráanda báni le nadǘgübei, gunfaráanda bubeí lárigiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ába laríñagun Pédro lun. —¡Machíbun bubeí nugúdi! Laríñaga Jesúsu lun. —Ánjein machíbun nan bugúdi, siñábei gafánran ban núma. ");
INSERT INTO cabNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ába laríñagun Simón Pédro lun. —Mámarügülá nugúdi bachíba, chibábei gíñe nújabu lúma nigíbu. ");
INSERT INTO cabNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Laríñaga Jesúsu lun. —Le sun liñábei lágoun, lugúdi rügǘñein abúseera lachibúniwa, ladǘga jarúmati líbiri lúgubu. Jugúya, jarúmatün, mámarügü líña sun jugúya. ");
INSERT INTO cabNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Le laríñagunbei luágu máma lan sun jagía jarúmatiña, ladǘga subúdi láni cába lan edéregerei. ");
INSERT INTO cabNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Lásun lachíbuni Jesúsu jagúdi, ábaya ladáürunun gamísa to larágachuboun, ábaya lañúurun luágu dábula, ába laríñagun joun. —¿Gunfaráanda jumútisan le nadǘgübei jun? ");
INSERT INTO cabNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jugúya agúajatün nun Maésturu, lúma Nabúreme, áni richátün ladǘga áu ligía, ");
INSERT INTO cabNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ánjeinti chibá nubálin jugúdi láu sun Jumáesturun nan áni Jabúreme, lúnti gíñe jachíbuni jugúdi júmagua. ");
INSERT INTO cabNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Rújadina ában jémpulu jun lun jadǘgüni líbe méme le nadǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ninárün jáu luágu míñugun lan ni ában músu lueí liyúbudiri, ni ában le oúnajoúti lueí le oúnajabalin. ");
INSERT INTO cabNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ánjein gunfaráanda jumá buri cátei le áni adǘga jumeíme, gúndaabadün. ");
INSERT INTO cabNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","‘Mámatia nadímurejaña juágu sun jugúya, subúdi numútiña cátaña lan nanúadirubaña lun nánigume le tímatimaati. Áni lúnti lagúnfulirún le tídaanbei Lerérun Búngiu. “Garábagua le eígubei núma, nuágun.” ");
INSERT INTO cabNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Naríñaguñein le jun lubáragiñe lasúseredun, lun dánme lan le lasúseredun, afíñe jumámuga luágu áu lan Crístubei. ");
INSERT INTO cabNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ninárün jáu luágu le lan erésibiruti le noúnajan, resíbi lumútina gíñe, áni le erésibirutina, resíbi lumúti gíñe le oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Lásun laríñaguni Jesúsu sun cátei le, ába lasándirun sarágu íruni tídan lanígi, ába laríñagun furáangu. —Ninárün jáu luágu ledéregerubadina lan ában jídaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ábati jagúmeserun disípulugu aríagua jawoúguoún, ibídiñounga joun ca lan jádaangiñe uágubei ladímureja Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Áu Juan, le abǘrüjabarun gárada to, ában jádaangiñe disípulugu, le weíribei ínsiñe lun Jesúsu, loúbagiñeñádina lídan adíneruni, ");
INSERT INTO cabNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ába ladǘgün Simón Pédro seíni nun lun nálügüdüni Jesúsu ca lan jádaangiñe uágubei ladímureja. ");
INSERT INTO cabNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ábati nayárafaduntima lun Jesúsu, ába naríñagun lun. —Nabúreme, ¿cáteisan lúnbei ledéregerunibu? ");
INSERT INTO cabNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ába laríñagun Jesúsu nun. —Nadǘdüragüda murúsun fein, le únti níchigoun, ligíaba edéregerana. Ábati ladǘdüragüdün murúsun fein, ába líchugunun lun Júdas Iscarióte, le liraǘ Simón. ");
INSERT INTO cabNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Quei lárügüdünun Júdas fein tugúya, ítara lebélurun Máfia tídoun lanígi. Ábati laríñagun Jesúsu lun. —Le lúnbei badǘgüni, adǘgabeí furése. ");
INSERT INTO cabNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Úati gunfaráanda láni ni ában jádaangiñe ja eígibaña luágu dábula ca lan uágu laríñagei Jesúsu líra lun. ");
INSERT INTO cabNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Quei Júdas lubeí táubei lágei seínsu, sun jaríñagun yebéti laríñaguña Jesúsu lun lun lagáñijani le jabúseerubei lubá fédu, o lun lan líchugun seínsu joun gudémetiña. ");
INSERT INTO cabNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Lárigiñe leíginun Júdas fein, ába láfuridun. Gúñeeli óra ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Lárigiñe láfuridun Júdas, ába laríñagun Jesúsu. —Larijúa nuweírigun, áu le Wügǘri Garaǘwarügüti, guetó, arijúame luweírigun Úguchili nuágu. ");
INSERT INTO cabNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ánjeinti arúfuda nubálin luweírigun Búngiu, larúfudubei gíñe Búngiu nuweírigun, áni ladǘgübei madíse. ");
INSERT INTO cabNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nirájüñü, úaadináme júma sarágu dan. Jáluajabadina, le méme naríñagubei joun juríu naríñagayaali jun guetó. Siñábei jídin le ñíjinba lubeí nídin. ");
INSERT INTO cabNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Níchigaali iséri gumádi le jun. lun jínsiñegua jumá júngua. Ítara quei jínsiñe nun, lúnti gíñe jínsiñegua jumá júngua. ");
INSERT INTO cabNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ánjaün jínsiñegua júngua, jasúbudirubei sun gürígia luágu náni jumá disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ába laríñagun Simón Pédro lun Jesúsu. —¿Jalíñounbadibusan, Nabúreme? Ába laríñagun Jesúsu lun. —Siñáti bafálarunina le ñíjinbadina lubeí guetó, lachǘlürüba wéyu lun bafálarubadina lan. ");
INSERT INTO cabNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Laríñaga Pédro lun. —¿Ca uágu siñá lubei nafálarunibu guetó? Aráanseedina lun níchuguni nibágari buágu. ");
INSERT INTO cabNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Laríñaga Jesúsu lun. —¿Binárün luágu aráanse ban lun bíchuguni bibágari nuágu? Ninárün báu luágu beyéedaguba lan náu ǘrüwa weíyaasu lubáragiñe layúgurujan gáyu. ");
INSERT INTO cabNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","‘Merédera jumá láu líbe samínaü, afíñe méme jumá luágu Búngiu, afíñe méme jugúyame nuágu. ");
INSERT INTO cabNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Níjein sarágu ubáraü tídan lúban Núguchi lun jaganoún gürígia ñi, lun jamúga máma lan ítara líña, aríñaga náali jamúga jun. Neíbuga lubeíti aráanseja ában ubáraü jubá. ");
INSERT INTO cabNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Lárigiñeme nídin, aráanse neíme ubáraü ligía, ábame nagíribudunya lun nanǘgünün númagua, lun ñi jumá le méme ñí numuti. ");
INSERT INTO cabNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Subúdi jumúti jalíñounbadina lan, subúdi jumúti gíñe ǘma. ");
INSERT INTO cabNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Laríñaga Tomás lun. —Nabúreme, ibídiñeti woun jalíñounbadibu lan, ¿ída lubáti wasúbudiruni ǘma? ");
INSERT INTO cabNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Laríñaga Jesúsu lun. —Lun lachǘlürǘniwa lúmoun Búngiu, áu ǘmabei, áu inárüni, áu ibágari. Nueígiñe rügǘñein gayára lan lachǘlürǘniwa lúmoun Búngiu Úguchili. ");
INSERT INTO cabNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Lun jamúga subúdi nan jun buídu, subúdi jumúti jamúga gíñe Núguchi, subúdi jumáaliti lúmagiñe guetó, ladǘga aríjañaja jumáali láu jaríjinina. ");
INSERT INTO cabNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Laríñagati Felípe lun. —Arúfudabeí Úguchili woun, buídurügaalime woun. ");
INSERT INTO cabNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Laríñaga Jesúsu lun. —Felípe, lǘjadina júma, ¿ibídiñegidina bun? Le aríjitina, laríjiñein gíñe Búngiu Úguchili, ¿cáti uágu baríñaga nun lun narúfuduni Búngiu Úguchili jun? ");
INSERT INTO cabNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Mafíñetibusan luágu anájein lan lídan Búngiu Úguchili, níjein lan gíñe Búngiu Úguchili nídan? Lé buri cátei le naríñagubei jun, máma lan láu náni núngua naríñagei, Búngiu Úguchili le aganoúbei nídan, ligía adǘgübalin luwádigimari guánarü. ");
INSERT INTO cabNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Afíñe jumá nun luágu anájein lan lídan Búngiu Úguchili, áni lan níjein gíñe Búngiu Úguchili nídan, íbini luágurügü cátei lé buri nadǘgübei, afíñe jumá nun. ");
INSERT INTO cabNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ninárün jáu, luágu le lan afíñeti nuágu, ladǘgübei lan cátei lé buri nadǘgübei, ladǘgüba buri cátei weínamutimaati, ladǘga áu, neíbuga le ñíjin lubeí Núguchi. ");
INSERT INTO cabNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Sun le jamúriajan lídan níri, nadǘgübei, arúfuda námugei luweírigun Núguchi. ");
INSERT INTO cabNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nadǘgübei furúmieguarügü cátei le jamúriajan lídan níri. ");
INSERT INTO cabNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","‘Ánjein jínsiñe nubeí jun, gúnfuli jumá láu le nubeíbei, ");
INSERT INTO cabNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ábame nayúmuragun lun Núguchi lun loúnajan ámu jun newéñegua lun líderagunün, lun gíñe líchugun gurásu jun. Ligíaba Sífiri Sándu le subúdijabúbei lun sun inárüni, júmabei súnwandan. ");
INSERT INTO cabNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ja lánigu uboú le, siñáti jerésibiruni Sífiri Sándu ligía, ladǘga siñá lan jaríjini ni jasúbudiruni, ánjein jugúya, subúdi jumáali, ladǘga níjein júma áni leréderuba jídan. ");
INSERT INTO cabNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mígirun nubádün jábugua, nagíribudayaba lun júma nan. ");
INSERT INTO cabNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Málüjadina ánjana maríjin jamá gürígia, ánjein jugúya, jaríjubadina, áni gabágaribadün ladǘga wínwañu níña lan. ");
INSERT INTO cabNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lárigiñeme liábin Sífiri Sándu lun júma lan lun sun dan, jasúbudirubei luágu anájein lan lídan Núguchi, jugúya nídan, áu gíñe jídan. ");
INSERT INTO cabNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Le subúdijabuti lun nugúmadin áni úaragu ligía lúma, arúfuda lumúti luágu jínsiñe nan lun le tímatimaati. Áni jínsiñejabúbei Núguchi lun le jínsiñejabuti nun, jínsiñebei gíñe nun, arúfudagua áume núngua lun. ");
INSERT INTO cabNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ába laríñagun Júdas (mámatia le Iscarióte). —¿Cásan uágu barúfudaguba lubeí búngua woun, máma joun gürígia ja lánigu uboú le? ");
INSERT INTO cabNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Laríñaga Jesúsu lun. —Le jínsiñejabuti nun, adǘgati gásu láu le nubeíbei, áni línsiñeduba lun Núguchi, ábame wayábin, áu lúma Núguchi, agánawa lúma. ");
INSERT INTO cabNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Le mínsiñejabuti nun, madǘgünti gásu láu le nubeíbei. Dimúrei le naríñagubei, máma náni, láni Núguchi le oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‘Naríñaguñein sun le jun láu anájagua lan júma, ");
INSERT INTO cabNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Sífiri Sándu le lúnbei loúnajani Núguchi lídan níri lun líderagunün, larúfudajaba jun, larítaguagüdübadün gíñe luágu sun le aríñaga náalibei jun. ");
INSERT INTO cabNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","‘Neíbuga júmagiñe, nígiraali ñurúguaü júma—ában luwúyeri ñurúguaü le áurügübei gayára lan níchiguni. Mítaraanti queísi ñurúguaü le líchugubei uboú. Magíbedalá jisáminan, manúfude jugúyame. ");
INSERT INTO cabNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Agáamba jumáali naríñagun luágu neíbuga lan, áni nagíribudayaba lan lun júma nan, lun jamúga jínsiñe nan jun láu jinárün, gúndaatün jamúga láu jasúbudiruni luágu neíbuga lan lúmoun Núguchi, ladǘga ligía íñugutimaati nueí. ");
INSERT INTO cabNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ligía aríñaga gíñe nubálin le jun, lun dánme lan lasúseredun, afíñe jumámuga. ");
INSERT INTO cabNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","‘Madímurejaanjadina sarágu júma, ladǘga níteeli le agúmadijabei lídan uboú le. Láu sun mabáfu lan nuágu, ");
INSERT INTO cabNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","lúnti ítara lúba lan lun lasúbudiruni uboú luágu jínsiñe lan Núguchi nun, áni adǘga náni le lubeíbei nun. Sarájuma, queímoun yágiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Laríñaga Jesúsu. —Ítara níña quei ában tídibu beíbei le tímatimaati, Núguchi, ítara líña quei le oúnigirubarun nádü. ");
INSERT INTO cabNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Chaǘn lumuti furúmieguarügü lídaangiñe nilímun le míinti, atírimuja lumúti le gíinbei, jarúmagüdaleí lúntima lagíindun. ");
INSERT INTO cabNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jugúya, jarúmaadün lárigi narúfudajan jun. ");
INSERT INTO cabNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Lídan méme jumá ában núma quei lídaañadina lan ában júma. Ában límu siñáti lagíindun ánjein mámañein lubeí luágu ídibu, ítara jíña gíñe, siñáti jagíindun ánjein máma lubeí badǘleñu jíña nuágu. ");
INSERT INTO cabNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","‘Áu ídibubei, jugúya límu. Le badǘleñuti nuágu, badǘleñu áu luágu, lagíinduba gíbe, siñáti jadǘgün ni cáta úouga áu. ");
INSERT INTO cabNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Le merédeti badǘleñu nuágu, lágurúba boúgudin, ábame lamábeidun queí buri límu le abúdajoúbei lun lagudúniwa. ");
INSERT INTO cabNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","‘Ánjaün asígira badǘleñu nuágu, mabúlieidun jumeíme le narúfudajabei, gayáraabei jamúriajani le jabúseerun, áni jibíjubei. ");
INSERT INTO cabNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ibíjati Núguchi inébesei dan le gíbe lan jagíindun, áni arúfuda jumúti luágu náni jumá disípulugu ja tímatimaatiña láu líra. ");
INSERT INTO cabNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jínsiñetün nun ítara quei nínsiñe lun Núguchi, ítara méme jumá lubeíti lídan ínsiñeni le nánibei jun. ");
INSERT INTO cabNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ánjaün ñǘdün láu le nubeíbei, lídan mémebadün ínsiñeni le nánibei jun, ítara quei nídin láu le lubeíbei Núguchi, áni lídan mémeñadina ínsiñeni le lánibei nun. ");
INSERT INTO cabNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","‘Nadímurejánbei jun ítara lun gayára lan jasúbusiruni úgundani le níchugubei, le gumúti. ");
INSERT INTO cabNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Niján nugúmadinbei. lun jínsiñegua jumá júngua quei jínsiñe nun. ");
INSERT INTO cabNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Luweírin-ágei ínsiñeni le gayáraabei gáni láni gürígia, lun líchuguni libágari jawágu lumádagu. ");
INSERT INTO cabNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Numádagu jugúya, ánjein jadǘga le nubeíbei. ");
INSERT INTO cabNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Manǘgün náadün quei músu, ladǘga ibídiñeti le ladǘgübei liyúbudiri músu lun, nanǘgünün quei numádagu ladǘga subúdigüda náali sun le laríñagubei Núguchi nun jun. ");
INSERT INTO cabNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Máma jugúya anúadajabalina, áu anúadajabalün, áni rújadina dimúrei jun lun jagíindun gíbe, lun gíñe ladúrarun jin. Ítara lúba líchuguni Núguchi sun le jamúriajan lúma lídan níri jun. ");
INSERT INTO cabNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ítara líña lubeíti nugúmadin jun lun jínsiñegua jumá júngua. ");
INSERT INTO cabNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","‘Ánjaün iyéreeguda lun uboú, subúdi jumeí luágu áu lan iyéreegudubei lun furúmiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Lun jamúga lánigu jumá uboú, jínsiñetün jamúga joun gürígia ja lánigu uboú quei jínsiñe jánigu joun. Anúadaja numútün jádaangiñe ja lánigu uboú, ligía jiyéreegunbei lun uboú ladǘga mámaadün lan láni uboú. ");
INSERT INTO cabNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Jarítagua jumá luágu le naríñagubei jun. “Úati músu íñuguti lueí liyúbudiri.” Ánjein eíbaaja jamáadina lubeí, jeíbaajabadün gíñe, ánjein giñéti madǘgün jabeí gásu láu narúfudajan, madǘgünbaña gíñe gásu jáu. ");
INSERT INTO cabNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jadǘgübei sun le jun, nueígiñe, ladǘga ibídiñe lan le oúnajabalina joun. ");
INSERT INTO cabNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","‘Lun jamúga meja miábin nan adímureja joun, madúnruntiña jamúga luágu jamájarun lun jerésibirunina, queísiti niábin joun, gadúnruntiña lubeíti luágu figoú ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ja iyéreejabúbaña nun, iyéreeguti gíñe Núguchi joun. ");
INSERT INTO cabNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Madúnruntiña jamúga lun jamúga madǘgün nan ni cáta le úagili adǘgüti jagánagua, guetó aríja jamáali buri cátei ligía áni láu sun líra iyéreegugidina joun, iyéreegu gíñe Núguchi joun. ");
INSERT INTO cabNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Wel, lasúseredunbei le ladǘga lúnti lan lagúnfulirun dimúrei le bürǘwañubei lídan jalúrudun. “Ába niyéreegudun joun, mébunouga.” ");
INSERT INTO cabNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","‘Dánme liábin Sífiri Sándu le lúnbei líderagunün, Espíritu le lánina inárüni le lúnbei noúnajani luágu loúbadina Núguchi, ligíaba adímureja luágu náni fuleísei. ");
INSERT INTO cabNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jugúya, jadímurejaba gíñe luágu náni fuleísei, ladǘga númañadün lan lúmagiñe furúmiñeti dan. ");
INSERT INTO cabNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","‘Naríñaguñein buri cátei le jun lun moúnwen lan jafíñen nuágu. ");
INSERT INTO cabNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jabúgagubadün tídaangiñe jalígilisin, wuríbabei dan jun daríme lun ánjaün lan láfaragua furúmierügü gürígia jilágubei, larítaguba luágu lesériwiduñein lan Búngiu láu líra. ");
INSERT INTO cabNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jadǘgübei líra ladǘga masúbudirun jamágili lan Núguchi, masúbudirun jamána. ");
INSERT INTO cabNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Naríñaguñein le jun, lun dánme lan le lachǘlürün dan ligía, lun jarítagun luágu aríñaga náali lán meja jun. ‘Maríñagun numúti meja le jun lúmagiñe binárü ladǘga meja júmañadina lan, ");
INSERT INTO cabNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ánjein guetó, neíbuga lúmoun le oúnajabalina. Málügüdün lumútina ni ában jídaangiñe jalíñounbadina lan, ");
INSERT INTO cabNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","jírurügütün luágu naríñaguni cátei lé buri jun. ");
INSERT INTO cabNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Inárüni naríñagubei jun. buítimaati jun lun nídin, ladǘga ánjana mídin, miábinbei Sífiri Sándu júmoun lun líderagunün, áni ánjana ñǘdün, noúnajabei. ");
INSERT INTO cabNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Dánme liábin, ladáriraguagüdübaña gürígia ja uboúagubaña joúngua luágu gafígoun jamá, luágu gíñe níjein lan ában ǘma le lánina úarani, luágu gíñe lagúseragüdübaña lan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Larúfudubei joun luágu gafígoun jamá láu mafíñen jamá nuágu, ");
INSERT INTO cabNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","lasúbudiragüdübei joun luágu úaragua nan, láu larúfuduni joun luágu nídiba lan le ñíjin lubeí Núguchi dánme le nígirunün. ");
INSERT INTO cabNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Líchuguba fe joun luágu lagúseragüdün Búngiu, ladǘga agúseragüda láali Máfia, le agúmadijabei lídan uboú le. ");
INSERT INTO cabNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","‘Gíbegili lúnti naríñaguni jun, jásiñerubei gunfaráanda guetó. ");
INSERT INTO cabNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Dánme liábin Sífiri Sándu le lánina inárüni, larúfudajabei sun inárüni jun, ladǘga madímurejanbei luágu láni lúngua, le lagáambubei, ligíaba laríñaga. Lasúbudiragüdübei cátei lé buri lúnbei lasúseredun jun. ");
INSERT INTO cabNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Líchuguba inébesei nun, ladǘga lerésibiruba lídaangiñe ninárün, ábame lasúbudiragüdüni jun. ");
INSERT INTO cabNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sun le lúmabei Núguchi, náni gíñe, ligía naríñagunbei luágu lerésibiruba lan Sífiri Sándu lídaangiñe ninárün, ábame lasúbudiragüdüni jun. ");
INSERT INTO cabNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","‘Málüjadina, ánjana maríjin jumá, múrusunmeya dan lárigiñe, ábayame jaríjinina, ladǘga neíbuga le ñíjin lubeí Núguchi. ");
INSERT INTO cabNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ábati jálügüdagun jádaangiñe láni disípulugu jámagua, ába jaríñagun. —¿Cásan míni lan le? Laríñaga woun luágu málüjali lan ánjein maríjin wamá, múrusunya lánme dan lárigiñe, ábayame lan waríjini, ladǘga leíbuga lan le ñíjin lubeí Lúguchi. ");
INSERT INTO cabNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ca míni lan láu “murúsun dan lárigiñe le”? Úati gunfaráanda wamáni ca lan uágu ladímureja. ");
INSERT INTO cabNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ába lasúbudiruni Jesúsu luágu busén jama jálügüdaguni, ába laríñagun joun. —Aríñagatina jun luágu málüjadina lan ánjana maríjin jumá, murúsun lánme dan lárigiñe, ábaya lánme jaríjinina. ¿Ligía le uágubei jálügüdagua júmagua? ");
INSERT INTO cabNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ninárün jáu luágu jayájuba lan, jírugua jugúyame, ánjañati gürígia ja láni uboú le, jagúndaaruba. Láu sun líra, íbini jíru jumá, lasáansiraguba jírun lun ugúndanime. ");
INSERT INTO cabNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Dan le tagǘriajan lan ában wǘri, súfuritu ladǘga chülǘja lan lórate igári, lásun agǘriajoúaali lan irájü, marítagunjaru luágu igári, ladǘga ugúndani le tasándirubei luágu agǘriajaaru lan ában irájü uboúagu. ");
INSERT INTO cabNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ítara líña gíñe, jugúya jírutün guetó, naríjayabadün, ábameti tabuínchun janígi láu ugúndani, ában ugúndani le úati gayáraati lagídaruni jueí. ");
INSERT INTO cabNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Lídaanme wéyu ligía, málügüdün jumádiname luágu ni cáta. Ninárün jáu luágu líchugubei lan Núguchi sun le jamúriajabei lídan níri lúma, jun. ");
INSERT INTO cabNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Chülǘ lúmoun dan le, mamúriajangidün ni cáta lídan níri, jamúriaja, ábame jibíjin, buin jumámuga láu ugúndani. ");
INSERT INTO cabNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Aríñaga náali buri cátei le jun láu jémpulu, inítebei dan lun madímurejaanjadina lánme jun láu jémpulu, ábame nadímurejan furáangu jun luágu Búngiu Úguchili. ");
INSERT INTO cabNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lídaanme wéyu ligía, jamúriajaba lúma lídan níri, maríñaguntina luágu nayúmuraguba lan lun Núguchi juágu, ");
INSERT INTO cabNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ladǘga ligía guánarü jínsiñetün lun. Jínsiñetün lun ladǘga jínsiñe nan jun, afíñeedün gíñe luágu lúmagiñe lan Búngiu niábin. ");
INSERT INTO cabNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Lúmagiñe Búngiu Úguchili náfurida, ába niábin lídoun uboú le, guetó nígiraali uboú le, neíbugaya lúmoun Núguchi. ");
INSERT INTO cabNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ába jaríñagun láni disípulugu. —Anáti guetó, badímurejaña furáangu, mayúsurunga jémpulu. ");
INSERT INTO cabNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Aríja wamáali guetó luágu subúdi lan sun cátei bun, moún lumuti bálügüdǘn luágu ni cáta ladǘga subúdi báni jarítagun gürígia. Luágu líra wafíñera luágu lúmagiñe lan Búngiu biábin. ");
INSERT INTO cabNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ába laríñagun Jesúsu joun. —¿Afíñedünti guetó? ");
INSERT INTO cabNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Iníteeli óra, áni guetó guetó, dánme le jachágaragun sun jugúya, cáda ában luágu loúbadina, ábame jígirunina nábugua, láu sun máma lan nábuguañadina ladǘga níjein Núguchi núma. ");
INSERT INTO cabNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Naríñagunbalin sun le jun, lun jadárirun ñurúguaü lídan jafíñerun nuágu. Jasúfuriruba uboúagu, ganígi jumá, ¡sirígua náali uboú! ");
INSERT INTO cabNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Lárigiñe laríñaguni Jesúsu sun cátei le, ába laríjin siélun, ába laríñagun. —Núguchi, chülǘja nidáani, rúba inébesei luágu Biraǘ, ru lámuga gíñe Biraǘ inébesei bun. ");
INSERT INTO cabNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Rújadibu ubáfu lun Biraǘ jawágu sun gürígia lun líchugun ibágari magúmuchaditi joun ja bíchugubaña lun. ");
INSERT INTO cabNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Niján lébunabei ibágari le magúmuchaditi, lun jasúbudirunibu gürígia amǘrü le Búngiu ábanrügüti, le inárüti, lúma lun jasúbudirunina, áu Jesucrístu le boúnajabei. ");
INSERT INTO cabNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","‘Rújadina uweíriguni bun ya uboúagu, gumú nan gíñe le uágubei boúnajana. ");
INSERT INTO cabNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Guetóti Núguchi, rúbei uweíriguni le méme méja nánibei nun biñǘwarü lubáragiñe meja ñi lan uboú. ");
INSERT INTO cabNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","‘Subúdigüda náali joun ja baságarubaña lídaangiñe uboú lun bíchuguniña nun, cátabu lan. Bánigu meja, ába bíchuguniña nun, ñǘdüntiña láu le bubeíbei. ");
INSERT INTO cabNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Guetó, subúdi jamáali luágu sun lan le bíchugubei nun búmagiñe lan liábin, ");
INSERT INTO cabNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","rúnaali ugánu le bíchugubei nun joun áni resíbi jamúti, subúdi jamáali luágu inárüni lan luágu búmagiñe lan niábin, afíñeeña gíñe luágu amǘrü lan oúnajabalina. ");
INSERT INTO cabNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","‘Ayúmuraguatina bun jawágu, mayúmuraguntina jawágu lánigu uboú, nayúmuragun jawágu ja bíchugubaña nun, ladǘga báni jamá. ");
INSERT INTO cabNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Sun le náni, báni, le báni, náni, arijúati nuweírigun jawágu. ");
INSERT INTO cabNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","‘Áu, merédeedina uboúagu, ánjein jagía, jeréderuba. Áu, neíbuga búmoun. Núguchi sánduti, toúnigi báña ja bíchugubaña nun láu bubáfu lueí jeíguadun, lun lídan jamá ában le tímatimaati quei áu búma. ");
INSERT INTO cabNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dán meja le jáma nan uboúagu, toúnigi numútiña meja ja bíchugubaña nun láu bubáfu, meféridiruntina ni ában jádaangiñe lueídügü Júdas, lun lagúnfulirun le bürǘwañubei tídan Berérun. ");
INSERT INTO cabNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","‘Guetó, neíbuga le ñíjin bubeí, luágu anájagua lan uboúagu aríñaga numúti buri cátei le lun jabuínchun láu ugúndani méme le nuágubei. ");
INSERT INTO cabNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Rúnaali berérun joun, ába jeyéreegudún lun uboú, ladǘga máma jamá lánigu uboú ítara queísi máma lan lánigu uboú áu. ");
INSERT INTO cabNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mamúriajaantina búma lun baságaruniña uboúagugiñe, namúriajan búma lun batoúnigiruniña lueí Máfia. ");
INSERT INTO cabNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ítara quei máma lan láni uboú áu, máma gíñe láni uboú jagía. ");
INSERT INTO cabNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Derégeguagüda báña joúngua bun, láu lubáfu berérun le inárütibei. ");
INSERT INTO cabNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Quei boúnajanina jádoun lánigu uboú láu ugánu lánina asálbaruni, ítara gíñe noúnajaniña jádoun lánigu uboú láu ugánu ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Áni derégeguatina núngua bun jawágu, lun gíñe jedéregeragun joúngua bun le tímatimaati. ");
INSERT INTO cabNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","‘Máma rügǘñein jawágu namúriaja búma, amúriajatina gíñe jawágu ja lúnbaña jafíñerun nuágu dánme le jagáambuni ugánu lánina asálbaruni jámagiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Amúriajatina búma lun lídan jamá ában sun jagía, lun ában méme jamá cátei wáma quei áu búma, amǘrü núma, lun lídan jamá ában buídu buídu, lun lafíñerun uboú luágu boúnajan nan. ");
INSERT INTO cabNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Rúnaali uweíriguni le méme bíchugubei nun joun, lun ában méme jamá cátei quei ában méme wamá cátei áu búma, ");
INSERT INTO cabNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","áu jádan, amǘrü nídan, lun jayábin lun ában mémebaña lan buídu buídu, subúdi lámugei uboú luágu boúnajan lan áu, áni jínsiñe jamá bun sarágu quei nísiñe bun. ");
INSERT INTO cabNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","‘Núguchi, amǘrü íchugubaliña nun, buséntina lun númabaña lan le ñí numuti, lun jaríjini uweíriguni le bíchugubei nun, ladǘga jínsiñegubeiñadina bun lubáragiñe ladügǘniwa uboú. ");
INSERT INTO cabNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Núguchi richáguati, ibídiñetibu lun uboú, subúditibu nun, subúdi jamáali gíñe wügǘriña ja luágu boúnajan lan áu. ");
INSERT INTO cabNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Subúdigüda náali joun cátabu lan, áni nasúbudiragüda mémebadibu, lun ñi lan ínsiñeni le buágubei nun jádan, lun gíñe ñi nan já dan. ");
INSERT INTO cabNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Lárigiñe laríñaguni Jesúsu cátei le, ába láfuridun jáu láni disípulugu lun joúdin loubáfurugun dúna le cedrón. Ñíñein ában fulásu lé buri ñí lumuti tídibu olívos, ñíjin lubeí lebélura Jesúsu jáu láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Subúdi lumúti gíñe Júdas le alúgurubalin Jesúsu, fulásu ligía, ladǘga oúndaraguañajaali Jesúsu ñi jáma láni disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ába lubeíti lachǘlürün Júdas ñíjin jáu sarágu súdaara jáma polisía ja tánina témpulu, joúnajan jábutigu fádirigu jáma fariséogu. Gárumatetiña, barǘtiña gíñe lámpu lúma tóchi. ");
INSERT INTO cabNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Quei subúdi láali lan Jesúsu le lúnbei lasúseredun lun, ába láfuridun, ába laríñagun joun. —¿Ca jáluajabei? ");
INSERT INTO cabNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ába jaríñagun lun. —Wáluajañein Jesúsu le Nazarétna. Laríñaga Jesúsu joun. —Áu Jesúsu ligía le jáluajabei. Ñíñeinti Júdas le edéregerubalin jáma. ");
INSERT INTO cabNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Dan laríñagunbei Jesúsu joun luágu ligía lan le jáluajabei, ába jeíguadunga múarugún janagoún. ");
INSERT INTO cabNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ábaya laríñagun Jesúsu joun. —¿Ca jáluajabei? Ába jaríñagun lun. —Wáluajañein Jesúsu le Nazarétna. ");
INSERT INTO cabNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ábati laríñagun Jesúsu joun. —Aríñagaadinatia jun luágu áu lan. Ánjein áu lubeí jáluajabei, ígira jumáña ja lun joúdin. ");
INSERT INTO cabNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Lasúseredunbei líra lun lagúnfulirun le laríñagubei Jesúsu guánarügü. “Meféridirúnti ni ában jádaangiñe ja líchugubaña Núguchi nun.” ");
INSERT INTO cabNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ábati laságarunun Simón Pédro lefeínte, ába líbuguni larígei ában lumúsun fádiri le íñutimaabei gíriti Málco. ");
INSERT INTO cabNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ába laríñagun Jesúsu lun Pédro. —Dáboun befeínte tárigoún. ¿Jarítaguatibu funági luágu moun lan nasúfuriruni oúchawagúni le líchugubei Núguchi lun nasúfuriruni? ");
INSERT INTO cabNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ábati janǘgüni súdaara, lúma gumándan, jáma japolisían juríu, Jesúsu adáüra, ába jagǘraguni. ");
INSERT INTO cabNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Lárigiñe, ába janǘgüni lúbiñoun Anás. Anás ligía limédamurubei Gáifasi, fádiri le íñutimaabei lídan irúmu ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Gáifasi ligía, le méme meja aríñagubei joun juríu luágu buítima lan joun lun loúnwen ában wügǘri jawágu sun mútu. ");
INSERT INTO cabNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ába woúdin, áu Juan lúma Simón Pédro, lárigi lárigi Jesúsu. Áu, subúditina lun fádiri le íñutimaabei, ábati nebélurun lúma Jesúsu lídoun tübǘrürü lúban fádiri, ");
INSERT INTO cabNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ánjeinti Pédro, ába leréderun boúgudi luágu béna. Ligía náfuridunbei, ába nadímurejan túma to oúnigirubalin béna, ába nebélaagüdüni Pédro. ");
INSERT INTO cabNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ábati tálǘgüdüni oúnigirutu béna Pédro. —¿Ma bugúya ában jádaangiñe láni gürígia le disípulugu? Laríñaga Pédro. —Uá, máma áu. ");
INSERT INTO cabNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Queíti dilíga lubeí, fúguatiñati músu jáma polisía wátu, rára jañáti ñi abácharagua. Ñíñein gíñe Pédro jáma, abácharagua larǘgürügü wátu. ");
INSERT INTO cabNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ába lagúmeserun fádiri le íñutimaabei álügüdaguei Jesúsu cátaña lan lánibaña disípulugu, cátei lan gíñe larúfudajabei. ");
INSERT INTO cabNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Laríñaga Jesúsu lun. —Boúgudi nadímureja ligíbugiñe sun uboú, súnwandan narúfudajan tídan ligílisi lúma témpulurugu le ñí lubei joúndaragua sun juríu, madǘgüngidina lubeíti ni cáta arámudaguati. ");
INSERT INTO cabNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ca uágu bálügüdana? Álügüda báña ja agáambubalina, jagíalá aríñagei le uágubei nadímureja joun. Subúdi jamúti le naríñagubei joun. ");
INSERT INTO cabNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Dan laríñaguni Jesúsu cátei le, ába liábin ában jádaangiñe polisía ja tánina témpulu, ába lagáyuajan ligíbuagun, ába laríñagun lun. —¿Ítara lúba boúnabuni fádiri le íñutimaabei? ");
INSERT INTO cabNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Laríñaga Jesúsu lun. —Ánjein aríñaga nubeí wuríbati, aríñagabeí jalíañein lan luríban, ánjeinti buídu lubeí le naríñagubei, ¿ca uágu bagáyuaja nuágu? ");
INSERT INTO cabNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ábati loúnajani Anás gürágu lun Gáifasi, fádiri le íñutimaabei lídan irúmu ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sun dan le, nijágua Pédro abácharagua larǘgürügü wátu, ába jaríñagun lun. —¿Másan amǘrü ában jádaangiñe láni gürígia le disípulugu? Ába leyéedagun Pédro, ába laríñagun. —Uá, máma áu. ");
INSERT INTO cabNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ábati lálügüdüni ában jádaangiñe lumúsuniña fádiri le íñutimaabei, ában lidúje le líbugubei Pédro arígei. —¿Máfunagi aríja numútibu lúma lídan fulásu lé buri ñí lumuti tídibu olívos? ");
INSERT INTO cabNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ábaya leyéedagun Pédro, lídan óra ligía, ába layúgurujan gáyu. ");
INSERT INTO cabNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ábati janǘgüni Jesúsu lúbiñegiñe Gáifasi lun lúbiñoun gumándan. Arúgadeina liñáti, mebélutiñati juríu palásiurugún lueí marúma jamá, siñáme gádan lániña adíneruni le lánina páscua. ");
INSERT INTO cabNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ligía láfuridunbei Piláto lun ladímurejan jáma, ába laríñagun joun. —¿Cásan lidúnrunbei gürígia le jurúma? ");
INSERT INTO cabNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ába jaríñagun lun. —Lun jamúga madǘgün lan wuríbani, medéregerun wamúti jamúga bun. ");
INSERT INTO cabNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ábati laríñagun Piláto joun. —Barǘjumei, agúseragüda jumeí quei laríñaguni jilúrudun guánarü. Jaríñaga juríu lun. —Wagía juríu, maríchatiwa lun wáfarun ni ában jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ítara líña lagúnfulirún le laríñagubei Jesúsu luágu ligáburi ída lúba lan loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ábaya lebélurun Piláto palásiurugun, ába lagúarun lun Jesúsu, ába laríñagun lun. —¿Amǘrü Jarúeitebei Juríu? ");
INSERT INTO cabNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ába laríñagun Jesúsu lun. —¿Luágu báni búngua bálügüdaja luágu líra, ódi ladǘga jaríñaguni ámu bun nuágu? ");
INSERT INTO cabNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Laríñaga Piláto lun. —¿Juríu funági áu? Binásiñun jáma jábutigu fádirigu, jagía edéregerubalibu nun. ¿Cági bidúnrunbei? ");
INSERT INTO cabNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ábati laríñagun Jesúsu lun. —Narúeijan máma lánina uboú le, lun jamúga ítara líña lan, jageíndaguña jamúga nánigu lun medéregerúniwa nan joun juríu. Máma yána narúeijan. ");
INSERT INTO cabNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ábati laríñagun Piláto lun. —¿Urúei lubeíti amǘrü? Laríñaga Jesúsu lun. —Urúei áu quei baríñaguni. Agǘriajoúatina, ñǘbin áu lídoun uboú le lun naríñaguni le inárünibei. Sun ja gagáambadibaña lun inárüni, agáamba jamúti le naríñagubei. ");
INSERT INTO cabNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Laríñaga Piláto lun. —¿Cáteiti inárünibei? Lárigiñe ladǘgüni Piláto álügüdajani le, ábaya láfuridun adímureja jáma juríu, ába laríñagun joun. —Madáritina ni murúsun dúru luágu wügǘri le. ");
INSERT INTO cabNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Quei jéchu jumá lun nígiragüdün ában adaürǘti jun lídan fédu le láni páscua, ¿buséntün lun náfuridagüdüni Jesúsu le jarúeitebei juríu? ");
INSERT INTO cabNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ábaya jagúaragun sun jagía. —¡Mígiragüdabeí le! ¡Barabáslá bígiragüda! Barabási ligía, ában jíwer uti. ");
INSERT INTO cabNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ábati lanǘgüni Piláto Jesúsu, ába loúnajan abeíchagüdei, ");
INSERT INTO cabNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ába jíchugun ában súdaara ába rídi láuti jíyu leréberugu Jesúsu, ába jadáüraguagüdüni táu ában anáanguni colóru gúchu. ");
INSERT INTO cabNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ába jayárafadun lubádun dan méme aríñageina. —¡Gabágarilá Jarúeite Juríu! Ába jagáyuajan ligíbuagun. ");
INSERT INTO cabNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ábayati láfuridun Piláto, ába laríñagun joun juríu. —Naságaraali ñájoun lun jasúbudiruni luágu madári nan dúru luágu. ");
INSERT INTO cabNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ába láfuridun Jesúsu láu rídi láuti jíyu lábulugu, táu lanáangun colóru gúchu. Ábati laríñagun Piláto joun. —¡Niján wügǘri ligía! ");
INSERT INTO cabNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dan jaríjinbalin jábutigu fádirigu jáu sun polisía, ába jagúmeserun agúaraja. —¡Dáguabeí luágu gurúwa! ¡Dáguabeí luágu gurúwa! Laríñaga Piláto joun. —Barǘjumeiti, dágua jumeí luágu gurúwa, ladǘga áu, madáritina ni murúsun dúru luágu. ");
INSERT INTO cabNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ába jaríñagun juríu lun. —Wagía galúruduntiwa áni según walúrudun, lúnti loúnwen ladǘga laríñagun luoúgua luágu Liraǘ lan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Dan lagáambunbalin Piláto le, ábatima lanúfudedun. ");
INSERT INTO cabNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ábaya lebélurun palásiurugun, ába laríñagun lun Jesúsu. —¿Jalíanasan amǘrü? Moúnabunti Jesúsu ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ábati laríñagun Piláto lun. —¿Moúnabun bumútina? ¿Ibídiñetísan bun luágu gabáfu nan lun nígiragüdünibu, gabáfu áu lun nádaraguagüdünibu luágu gurúwa? ");
INSERT INTO cabNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Laríñaga Jesúsu lun. —Úati jamúga ni murúsun ubáfu búma nuágu lun jamúga míchu láni Búngiu bun, ligía weíritima lubeí lidúnrun le edéregerubalina bun sügǘ báu. ");
INSERT INTO cabNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Lúmagiñe óra ligía, ába lálugun Piláto ída lúba lan lígiragüdüni Jesúsu. Ába jagúaragun juríu lun. —¡Ánjein bígiragüda, máma amǘrü lumáda urúei Rómana! ¡Furúmieguarügü le aríñaguti luoúgua luágu urúei lan, lágani urúei Rómana! ");
INSERT INTO cabNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Dan lagáambunbalin Piláto líra, ába loúnajan aságarei Jesúsu, ába lañúurun luágu jalaǘ le agúseragülei, ubáraü le únbei jaríñaga Dǘbü, Gabáta lídan jerérun juríu. ");
INSERT INTO cabNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Queí buri amídirugujaali, le ában wéyu lubá páscua. Ábati laríñagun Piláto joun juríu. —¡Niján jurúeite! ");
INSERT INTO cabNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ába jagúaragun. —¡Jilála! ¡Jilála! ¡Dáguabeí luágu gurúwa! Laríñaga Piláto joun. —¿Buséntün nádaraguni jurúeite luágu gurúwa? Jaríñaga jábutigu fádirigu lun. —Marúeitetiwa ámu lueí urúei Rómana. ");
INSERT INTO cabNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Láu líra, aba ledéregeruni Piláto joun lun ládarawagún luágu gurúwa, ába janǘgüni. ");
INSERT INTO cabNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ábati láfuridun Jesúsu barǘinaleí lugúruwan lun lídin lídoun fulásu le únbei jaríñaga Lufúlasun Lábu Ichǘgü, Gólgota lídan jerérun juríu. ");
INSERT INTO cabNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ñi jádaraguei luágu gurúwa, dágua jagía bián wügǘriña úara lúma, ában lueígiñe cáda loúba. ");
INSERT INTO cabNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ába loúnajan Piláto íchigagüda ában abǘrüjoúni luágu gurúwa, laríñaga ñi. “Jesúsu Nazarétna, Jarúeite Juríu”. ");
INSERT INTO cabNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sarágu jáña jádaangiñe juríu alíijati abǘrüjoúni ligía ladǘga fulásu le ñí lubei jádaraguei Jesúsu luágu gurúwa, madíseti ubúrugugiñe, áni abǘrüjoúati abǘrüjoúni ligía lídan buri dimúrei hebréo, güriégu, lúma latín. ");
INSERT INTO cabNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ligía jaríñagunbei jábutigu jafádirin juríu lun Piláto. —Mabǘrüdabá ñi “Jarúeite Juríu”, bürǘba “Le aríñagubei luágu Jarúeite lan Juríu.” ");
INSERT INTO cabNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ába laríñagun Piláto joun. —Le bürǘnaalíbei bürǘnaalíbei, ítara lúba. ");
INSERT INTO cabNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Lárigiñe jádaraguni súdaara Jesúsu luágu gurúwa, ába janǘgünun lanáangun, ába jadǘgün gádürü fánreinti táu, ába fánreinti lun cáda súdaara. Ába gíñe janǘgünun lisímisin, quei májüchawagún tubeí, ában rügǘñoun fiésu íñugiñe lun ǘnabun, ");
INSERT INTO cabNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ába jaríñagun súdaara jámagua. —Majeíridagua wamoún, ájurera wamá tuágu, aríja wamámuga cába lan agáñiroun. Ítara líña lagúnfulirun le taríñagubei Lerérun Búngiu. “Fánreingua jamútu nanáangun jádaangua, ájurera jagía tuágu nisímisin cába lan agáñiroun.” Ítara líña lubeíti jadǘgüni súdaaragu. ");
INSERT INTO cabNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ñíñoun lúguchu Jesúsu yaráfa lun gurúwa túma tamúlelua, María to lúmari Cléofas, túma María Magdaléna. ");
INSERT INTO cabNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Dan laríjinbarun Jesúsu lúguchu rára nubádu, áu le disípulu lé jínsiñebei lun sarágu, ába laríñagun tun lúguchu. —Núguchu, nirán biraǘ. ");
INSERT INTO cabNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ába laríñagun nun. —Nurán búguchu. Lúmagiñe óra ligía, ába nerésibirunun núbiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Lárigiñe sun cátei le, quei subúdi láni Jesúsu luágu gúnfulijali lan láu sun le lúnbei ladǘgüni luágu wasálbarun, ába laríñagun, lun lagúnfulirún le taríñagubei Lerérun Búngiu. —Mágürabujadina. ");
INSERT INTO cabNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ñíñein ában fúdu táu diweín garǘjütu, ába jadǘdüragüdün ában mudúsi tídan diweín tugúya, ába jíchuguni luágu ában wéwe, ába jiñúruni luágun liyúma. ");
INSERT INTO cabNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ába látunun Jesúsu diweín garǘjütu tugúya, ába laríñagun. —Gúnfulija sun cátei. Ába larábachun ligíina, ába loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Wéyu ligía, ában wéyu lubá páscua, mabúseeruntiñati juríu lun leréderun jágubu gürígia luágu gurúwa lídan wéyu le eméraaguagülei, ladǘga weíriti wéyu ligía. Ligía jamúriajaanbei lúma Piláto lun loúnajan ájalajei járuna ja dáwaguñubaña luágu gurúwa, lun gíñe lagídarún jágubu ñígiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ábati joúdin súdaara, ába jájalachuni lúruna furúmiñeti, jalá jameí lúruna le ában le dáwaguñubei luágu gurúwa úara lúma Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Dan le jayárafadunbei lun Jesúsu, ába jaríjin luágu jiláali lan, ligía májalachun jamáali lubeí lúruna. ");
INSERT INTO cabNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ába liábin ában súdaara, ába límiruni Jesúsu loúbawagun táu ában efeín, ába láfuridun jítaü lúma dúna ñígiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Áu Juan, le abǘrüjabalin le, ában le aríjubalin, áni aríñaga numúti inárüni, subúdi numúti luágu aríñaga náni inárüni lun gíñe jafíñerun jugúya. ");
INSERT INTO cabNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ladǘga lasúseredunbei buri cátei le, lun lagúnfulirun le taríñagubei Lerérun Búngiu. “Májalachúnwabei ni ában ábuu luágu.” ");
INSERT INTO cabNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aríñagati gíñe tídan Lerérun Búngiu. “Jaríjubei le jímiragubei.” ");
INSERT INTO cabNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Lárigiñe sun cátei le, ñíñein ában wügǘri Arimatéana, gíriti José, falá lumuti meja wügǘri ligía Jesúsu, láu sun arámudaguarügü lan ladǘga lanúfude jaweí juríu, ába lamúriajani lúgubu Jesúsu lúma Piláto. Ába líchuguni lun, ába lanǘgüni José lúgubu Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ába gíñe liábin Nicodémo, lé meja ñǘdünbei ayánuja lúma Jesúsu gúñoun, ába liábin láu sarágu ibíñei. ");
INSERT INTO cabNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ábati janǘgüni José lúma Nicodémo lúgubu Jesúsu, ába joúburaguni táu gamísa to túaguatu láu ibíñei ligía según jagáburi juríu lubá jábunajan. ");
INSERT INTO cabNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ñíñein ában fulúri-ágei lídan fulásu le ñí lubei jádaraguei Jesúsu luágu gurúwa, lídaanti fulásu ligía, ñíñein ában umúajaü iséri le mayúsurungili. ");
INSERT INTO cabNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ñíjin jíchigei lúgubu Jesúsu, ladǘga yaráfa lan umúajaü ligía, ladǘga gíñe agúñeeli lan, gumése wéyu le eméraaguagülei. ");
INSERT INTO cabNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wéyu dimáasu, lubá larúgan dan le búrigagili, ába tídin María Magdaléna aríjei umúajaü, dan tachǘlürünbei ñi, úaali dǘbü le lidaǘ umúajaü ñi. ");
INSERT INTO cabNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ába tídin eíbaagueina le ñíjin wabeí áu lúma Simón Pédro, ába taríñagun woun. —Barǘjama Jesúsu lídaangiñe lumúaja, ibídiñeti woun jalía lan jíchigei. ");
INSERT INTO cabNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ábati wáfuridun, ába woúdin luágun umúajaü. ");
INSERT INTO cabNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Úara woúdin biángubei wagía eíbáagueina, furésetina lueí Pédro, ába nachǘlürün furúmiñe luágu umúajaü. ");
INSERT INTO cabNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ába nélemuchun aríja ñíjin, gamísa rügǘñoun naríja ñi, mebélutina. ");
INSERT INTO cabNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Lárigiñe, ába lachǘlürün Simón Pédro, ába lebélurun lídoun umúajaü. Gamísa to aúboun lagǘrawagua Jesúsu, tugúya rügǘñoun gíñe laríja ñi. ");
INSERT INTO cabNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Gamísati to áuboun loúbarawagúa lichǘgü Jesúsu, máma lídaañoun ában túma tó buri áuboun lagǘrawagúa, joúburagu tíña, tábugua. ");
INSERT INTO cabNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ába giñéti nebélurun, ába naríjini le asúseredubei, ába nafíñerun luágu saráali lan Jesúsu lídaangiñe oúweni. ");
INSERT INTO cabNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ligíaaliti gunfaráanda náni le taríñagubei Lerérun Búngiu luágu lásaaruba lan Jesúsu lídaangiñe oúweni. ");
INSERT INTO cabNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ábati wagíribudun wábiñoun. ");
INSERT INTO cabNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ánjounti María, ába teréderun boúgudi ayájuaja lubádu umúajaü. Sun nuján lan ayájua, ába télemuchun aríja lídoun umúajaü, ");
INSERT INTO cabNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ába taríjin bián ánjeligu, jarútu jadáüragun, ñun le ñí lubeí buga lúgubu Jesúsu, ában lichǘgügiñe, ában lugúdigiñe. ");
INSERT INTO cabNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ába jaríñagun ánjeligu jagía tun. —¿Ca uágu bayájua? Taríñaga joun. —Barǘjama Nabúreme, ibídiñeti nun jalía lan jíchigei. ");
INSERT INTO cabNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Quei taríñagun ítara, ába tadígiragun, ába taríjini Jesúsu, niján lan ñi, ibídiñeti tun luágu ligía lan. ");
INSERT INTO cabNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ábati laríñagun Jesúsu tun. —¿Ca uágu bayájuaja? ¿Ca báluajabei? Sun taríñaguti le oúnigirubalin fulúri-ágei adímurejabei tun, ába taríñagun lun. —Ánjein banǘgün lubeí, aríñagabeí nun jalía lan bíchigei, barǘ námugei. ");
INSERT INTO cabNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ábati laríñagun Jesúsu tun. —¡María! Ába tagáraragun, ába taríñagun lun lídan jerérun juríu. —¡Rabóni! —míni lan líra, Maésturu. ");
INSERT INTO cabNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Laríñaga Jesúsu tun. —Márügüdabá nuágu, ladǘga maweínrungidina le ñíjin lubeí Núguchi. Beíba, baríñagame joun náni disípulugu luágu neíbuga lan le ñíjin lubeí Núguchi, le gíñe Júguchi, Nubúngiute le gíñe Jubúngiute. ");
INSERT INTO cabNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ábati tídin María Magdaléna awísaraña disípulugu luágu aríja táali lan Jesúsu, áni aríñaga láni buri cátei le tun lun taríñaguni joun. ");
INSERT INTO cabNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wéyu méme ligía gúñoun, oúndaragu jáña disípulugu, darúgu béna jáu ladǘga janúfude jaweí juríu. Ába lebélurun Jesúsu, ába laráramun jamídaangua, ába labúsurun joun ítara. —Níjeinlá darángilaü jídan. ");
INSERT INTO cabNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Lárigiñe laríñaguni líra, ába larúfuduni lújabu lúma loúba joun. Ába jagúndaaragun disípulugu láu jaríjini Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ábaya laríñagun Jesúsu joun. —Níjeinlá darángilaü jídan. Ítara quei loúnajanina Núguchi, ítara líña gíñe noúnajanün. ");
INSERT INTO cabNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ábati láfurun jawágun, ába laríñagun joun. —Resíbi jumeí Sífiri Sándu. ");
INSERT INTO cabNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ánjein ferúduna jumá jafígoun ámu, ferúdunawaali, ánjein úa ferúduna jumáni, reídeijali, úouga ferúdunawa lan. ");
INSERT INTO cabNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás, ában jádaangiñe dúusu disípulugu le únbei jaríñaga Mádou, úatiti jáma dan le liábinbei Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Lárigiñe, ába jaríñagun ja jíbiri disípulugu lun. —Aríja wamáali Wabúreme Jesúsu. Ába laríñagun Tomás joun. —Ánjein maríjin nan lárigi gürábu luágu lújabu, da neíme liraǘraü nújabu lídoun júyu le lárigi gürábu, da nújabu lídoun loúba, siñábei nafíñerun. ");
INSERT INTO cabNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wídü wéyu lárigiñe, oúndaragu jáñaya disípulugu tídan ában múna, ñíñeinti Tomás jáma dan ligía. Láu sun darúgu líña lan béna jáu, ába lebélurun Jesúsu, ába laráramun jamídaangua, ába labúsurun joun ítara. —Níjeinlá darángilaü jídan. ");
INSERT INTO cabNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ába laríñagun lun Tomás. —Dábei liraǘraü bújabu ñájoun, aríja beíme nújabu, da beíme bújabu lídoun noúba. Masígirabá láu liloúguan afíñeni, afíñebá luágu áu lan. ");
INSERT INTO cabNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ábati laríñagun Tomás. —¡Nabúreme, Nubúngiute gíñe! ");
INSERT INTO cabNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Laríñaga Jesúsu lun. —Tomás, afíñeedibu guetó, ladǘga aríja báadina lan, gúndaatiña ja afíñerubaña, maríjinga jamána. ");
INSERT INTO cabNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Adǘgayati Jesúsu ámu sarágu miláguru jagíbugiñe láni disípulugu, le úabei bürǘñu tídan líburu to. ");
INSERT INTO cabNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Labǘrüdǘnbei buri le lun jafíñerun luágu Jesúsu lan Crístubei, le Liraǘ Búngiu, lun gíñe láu lan jafíñerun, gabágari jumá queísi lánigu. ");
INSERT INTO cabNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Lárigiñe, ábaya larúfudagun Jesúsu lúngua joun láni disípulugu láru dúna le gíribei Tibérias. Niján ligáburi ladǘgüni. ");
INSERT INTO cabNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Lídaañanu ában Simón Pédro, Tomás le únbei jaríñaga Mádou, Natanaél, le lílana Caná le láni Galiléa, lirájüñü Zebedéo, jámaya bián jádaangiñe láni Jesúsu disípulugu. ");
INSERT INTO cabNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ába laríñagun Simón Pédro joun. —Neíbuga esénija. Ába jaríñagun lun. —Weíbuga gíñe búma. Ába jádinun tídoun jagúne, ába joúdin, mañúguntiña ni cáta áriebu ligía. ");
INSERT INTO cabNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Dan le arúgadeina lan, ába jaríjini Jesúsu ñi láru dúna, ibídiñetí yebe joun disípulugu luágu Jesúsu lan. ");
INSERT INTO cabNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ábati laríñagun joun. —Numádagu, ¿mañúgungidünsan? Jaríñaga lun. —Ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ábati laríñagun Jesúsu joun. —Fíjuma lueígiñe toúnwenren ibíti ugúnein, jañúguba. Ába jágurun, lárigiñe siñá yebe jacháwarunun séni dúnarugugiñe le jíbe úduraü tídan. ");
INSERT INTO cabNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ábati naríñagun, aú Juan, lun Pédro. —¡Jesúsutia le! Quei lagáambun Simón Pédro luágu Jesúsu lan, ába ladáürunun lanáangun, ába lachúbarun dúnarugun. ");
INSERT INTO cabNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ja jíbiri disípulugu, ába joúdin lárun béya táu ugúnein, adúrujeina jamoún séni buin jáu úduraü, quei ában rügǘñein lan san bádun jadíse lueí béya. ");
INSERT INTO cabNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Dan le jarárirun múarugun, ába jadárirun wátu geméti láu eñéguraü, láu ában úduraü ligíbuagu túma fein. ");
INSERT INTO cabNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ába laríñagun Jesúsu joun. —Barǘjuma fiú jádaangiñe úduraü ja sun liñábei jañúguniña. ");
INSERT INTO cabNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ába ládinun Simón Pédro tídoun ugúnein, ába ladúrujanun séni lárun béya buin jáu úduraü weínamutiña, san dimí-san ǘrüwañanu, láu sun jíbe, majeíridaguntu séni. ");
INSERT INTO cabNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ábati laríñagun Jesúsu joun. —Jigoúgu, játa bacháti. Úati ni ában jádaangiñe disípulugu álügüdüti cátei lan, ladǘga subúdi jamáni luágu Jesúsu lan. ");
INSERT INTO cabNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ába liábin, ába lanǘgünun fein lújaburugu, ába líchugunun joun, ligía méme ladǘga láu úduraü. ");
INSERT INTO cabNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ligía lǘrüwan larúfudagun Jesúsu lúngua joun láni disípulugu lárigi lásaarun lídaangiñe oúweni lúnya labágaridun. ");
INSERT INTO cabNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Lárigiñe játun bacháti, ába laríñagun Jesúsu lun Simón Pédro. —Simón, Liraǘ Jonás, ¿jínsiñetinasan bun sügǘ jáu ja? Laríñaga Pédro lun. —Ánja, Nabúreme, subúditi bun luágu jínsiñe ban nun. Ába laríñagun Jesúsu lun. —Toúnigi báñati nánigu queísi ában joúniri mudún buíti. ");
INSERT INTO cabNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ábaya lálügüdüni luágu libíaman weíyaasu. —Simón, liraǘ Jonás, ¿jínsiñetinasan bun le tímatimaati? Laríñaga Pédro lun. —Ánja, Nabúreme, subúditi bun luágu jínsiñe ban nun. Laríñaga lun. —Toúnigi báñati nánigu. ");
INSERT INTO cabNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ábaya lálügüdüni luágu lǘrüwan weíyaasu. —Simón, liraǘ Jonás, ¿jínsiñetinasan bun? Ába lírudagun Pédro ladǘga lálügüdüni Jesúsu luágu lǘrüwan weíyaasu ánjein jínsiñe lubeí lun, ába laríñagun lun. —Nabúreme, subúsiti sun cátei bun. Subúsiti bun luágu jínsiñe ban nun. Ába laríñagun Jesúsu lun. —Toúnigi báñati nánigu queísi ában joúniri mudún buíti. ");
INSERT INTO cabNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ninárün báu, luágu dan lán meja ñǘraütimagidibu, ábaja badáüragun, ába bídin le ñíjin lumúti babúseera, dánme le weíyaadibu, iñúrarügübalime barǘna, ábame ladáüraguagüdünibu ámu, ábame lanǘgünibu le ñíjin lumúti mabúseerun ban bídin. ");
INSERT INTO cabNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Láu laríñaguni Jesúsu cátei le, lasúbudiragüdüñein ída lúba lan ligáburi loúnwen Pédro, lun líchugun uweíriguni lun Búngiu láu. Lárigiñe, ába laríñagun lun. —¡Falábana! ");
INSERT INTO cabNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Dan ladígiragúnbei Pédro, ába laríjinina, áu Juan, anángüran lan járigi, áu le jínsiñebei sarágu lun Jesúsu, le méme añúurubei loúbagiñe Jesúsu lídan adíneruni, le gíñe álügüdübalin Jesúsu cába lan wádaangiñe edéregerei. ");
INSERT INTO cabNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Dan laríjinbalina Pédro, ába laríñagun lun Jesúsu. —Nabúreme, ánsan le, ¿cábasan asúsereda lun? ");
INSERT INTO cabNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Laríñaga Jesúsu lun. —Ánjana busén labágaridun daríme nagíribudun, ¿cámegi burúma? Amǘrü, falábana. ");
INSERT INTO cabNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ábati leíbaagun dimúrei jádan jíbiri lánigu Jesúsu luágu moúnwenbadina lán nege, maríñagunti Jesúsu luágu moúnwenbadina lan, aríñagarügüti. “Ánjana busén labágaridun darí lúmoun nagíribudun, ¿cámegi burúma?” ");
INSERT INTO cabNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Áu méme disípulu le, le achoúrurubalin buri cátei le, abǘrüja náaru gíñe gárada to jalíijaboun guetó. Áni subúdiwati luágu inárüni lan le naríñagubei. ");
INSERT INTO cabNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Níjein gíñe sarágu cátei ladǘga Jesúsu, ánjein jamúga abǘrüjoúa ában ában, afíñetina luágu mábara tan jamúga buri líburu to abǘrüjoútu láu lídan sun uboú.");
INSERT INTO cabNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Lun teófilo. Abǘrüjatina bun tídan furúmiñetu nigáradan luágu sun le ladǘgübei Jesúsu, lúma le larúfudajabei, lúmagiñe dan le lagúmeserunbalin luwádigimari ");
INSERT INTO cabNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","darí lúmoun wéyu le lamúdeirúnbei siélun. Lubáragiñebei lídin siélun, láu lubáfu Sífiri Sándu aríñaga lumúti cátei lé buri labúseerubei lun jadǘgüni apóstolugu já meja lanúadajabaña, lárigiñe lídin jámagiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Lídan bián-wein wéyu le láubei uboúagu lárigiñe lásaarun lídaangiñe oúweni, arúfudaguati lúngua furáangu joun sarágu weíyaasu luágu wínwan lan. Ába buríti ladímurejan joun luágu larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Dán meja le níjeingua lan Jesúsu jáma láni apóstolugu, aríñagati meja joun lun máfuridun jamá lídaangiñe ubúrugu Jerusalén, laríñaga joun. —Agúraba jumá lagúnfulirun dimúrei le líchugubei Núguchi jun, le uágubei naríñaga jun. ");
INSERT INTO cabNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Subúdi jumúti luágu badíseigüda lan Juan láu dúna, nasúbudiragüdüñein jun luágu málüjadün lan giñe ánjaün badísei láu Sífiri Sándu. ");
INSERT INTO cabNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Dan le oúndaragujaña lubeí lúma Jesúsu, ába jaríñagun lun. —Wabúreme, ¿Nijánsan dan le lúnbei bíchuguniya linásiñun Israél lun larúeijan? ");
INSERT INTO cabNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Laríñaga Jesúsu joun. —Siñáti jasúbudiruni ídame lan o cába lan dan ladǘgei Núguchi cátei le buri, ligía rügǘñein gayára laríñagun ídame lan ladǘgei. ");
INSERT INTO cabNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ánjein dánme le liábin Sífiri Sándu juágun, jibíjuba ubáfu lun geféen jumá nuágu, dándu Jerusalén quei sun loúbawagu Judéa, Samária, chülǘ lúmoun lidíse-ágei fulásu uboúagu. ");
INSERT INTO cabNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Lárigiñe laríñaguni Jesúsu cátei le, sun añája lan aríaguei, ába liñurúniwa lun lanügǘniwa siélun, ába liábin ában juánriñu, ába ladáuragun láu, ába maríjin jamáali lan. ");
INSERT INTO cabNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ñíñanu aríagua siélun sun amúdeireina lan Jesúsu, ligía jasáliragun bián wügǘriña, jarútu jadáüragun jarúgabu, ");
INSERT INTO cabNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ába jaríñagun joun. —Wügǘriña Galiléana, ¿ca uágu jerédera aríagua siélun? Jesúsu méme le, le amúdeirubei siélun júmagiñe, liábiyaba ítara quei jaríjin lídin. ");
INSERT INTO cabNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ábati jagíribudun disípulugu lueígiñe wǘbü le gíribei Olívos lun ubúrugun Jerusalén, lidíse ában kilómetro. ");
INSERT INTO cabNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Dan le jachǘlürünbei ubúrugun, ába jamúdeirun tídoun rúmu to ñí lubei jagánawa. Ñíñein Pédro jádan, Jacóbo, Juan, Andrés, Felípe, Tomás, Bartolomé, Matéo, Jacóbo le liraǘ Álfeo, Simón le lídaanbei adámurini le gíribei Cananísta, lúma Júdas le lamúlen Jacóbo. ");
INSERT INTO cabNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Oúndaraguátiñaja sun jagía súnwandan lun jayúmuragun lun Búngiu jáma lamúlenu Jesúsu, túma María to lúguchu, jáma ja jíbiri würíña. ");
INSERT INTO cabNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Luágu ában wéyu lídan dan ligía, ába laráramun Pédro jagíbugiñe sun afíñetiña ja ñíbaña—jawára san-wein gürígia—ába laríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Nidújeñu, lúnti buga lagúnfulirun le laríñagubei Sífiri Sándu liyúmulugugiñe Davíd tídan Lerérun Búngiu, lídan le ladímurejánbei luágu Júdas, le adúndejabáliña ja anǘgübalin Jesúsu adáüra. ");
INSERT INTO cabNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ában meja jádaangiñe wánigu, Júdas, áni seríwiti lun Jesúsu úara wáma. ");
INSERT INTO cabNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ába lídin, ába lagáñijan ában fulásu láu seínsu le afáyeirúbei lun luágu wuríbani le ladǘgübei. Ába láburujan láu lábulugu ǘnabun, ába lafáünchün, ába láfuridun sun litíripan. ");
INSERT INTO cabNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Dan le jagáambunbalin gürígia ja aganoúbaña Jerusalén, ába jagúajan lun fulásu ligía, Acéldama, míni lan lídan jerérun, Fulásu Láni Jítaü. ");
INSERT INTO cabNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ába lasígirun Pédro aríñaga. —Bürǘwañu líña dimúrei buri le luágu Júdas tídan líburu to gíriboun Sálmos. Laríñajare ñi. Reídeitá lúban málouga, úa jamá aganoútiña tídan. Aríñagati gíñe ñi. Rúalá lubára lun ámu. ");
INSERT INTO cabNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","‘Ítara líña lubeíti, lúnti wanúadajan ában wügǘri wádaangiñe lé meja wámati sun dan le wáma lubeí Jesúsu, ");
INSERT INTO cabNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","lúmagiñe dan le labásterágüdünbalin Juan Jesúsu darí lúmoun dan le lamúdeirúnbei siélun, lun lewéñegua lan Júdas. Wügǘri ligía, líchuguba fe úara wáma luágu lásaarun Jesúsu lídaangiñe oúweni lúnya labágaridun. ");
INSERT INTO cabNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ábati jíridun bián jádaangiñe. José, le méme gíribei Barsabási, le méme gíñe gíribei Jústo, lúma Matías. ");
INSERT INTO cabNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ába jayúmuragun lun Búngiu ítara. —Wabúreme, amǘrü le subúdijabúbei tun janígi sun gürígia, arúfudabei woun ca lan jádaangiñe bián wügǘriña ja anúadira báalibei ");
INSERT INTO cabNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","lun lesériwidunibu queísi apóstolu lewéñegua Júdas. Ladǘga féridi láali Júdas lubára ladǘga lafígounjan, áni ñǘdünja lídoun fulásu le ladǘnabei. ");
INSERT INTO cabNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ábati jíchaajan ubúnuruni, ába láburujan luágun Matías. Lúmagiñe óra ligía, ába ábanjali lan jádaangiñe apóstolugu. ");
INSERT INTO cabNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Dan lachǘlürünbei luwéyuri fédu le Pentecostés, oúndaragu jáña sun lánigu Jesúsu lídan ában fulásu. ");
INSERT INTO cabNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sódini ába lagaambún ában ireíni ñǘbinti siélugiñe quei dan le láfurun ában garábali jéreti, ába lagaambún tídan sun múna to ñí jabei. ");
INSERT INTO cabNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ábati lasáliragún buri cátei joun camá ligémeri wátu, afánreinjoúañu lun ñi lan ában murúsun loúgiñe lábulugu cáda ában jádaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ába jabuínchun sun jagía láu Sífiri Sándu, ába jagúmeserun adímureja lídan buri ámu luwúyeri dimúrei lueí jerérun quei ladímuregüdüniña Sífiri Sándu. ");
INSERT INTO cabNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lídoun buri dan ligía, ñíburiñanu juríu Jerusalén ja gúnfulitiña lídan jafíñen, ñǘbintiña lídaangiñe sun fulásu uboúagu. ");
INSERT INTO cabNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Dan le jagáambunbalin ireíni ligía, ába joúndaragunga gürígia, ibídiñeja joun cába lan jasáminara ladǘga cáda ában jádaangiñe gürígia jagía, agáamba jamútiña lánigu Jesúsu adímureja lídan jerérun guánarü. ");
INSERT INTO cabNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ába laweíridun janígi, ába jaríñagun jámagua. —¿Ma funági Galiléana ja adímurejabaña? ");
INSERT INTO cabNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Ída liñáti wagáambubaliña adímureja lídan lerérun cáda ában wádaangiñe? ");
INSERT INTO cabNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Añájein gürígia Pártiana ya, Médiana, Elámna, Mesopotámiana, Judéana, Capadóciana, Póntona jáma Ásiana, ");
INSERT INTO cabNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Fríjiana, Panfíliana, Ejíptona lúma lídaangiñe buri fulásu África le yagǘroun mémebei lueí Ciréne. Añájein giñe Rómana aganoútiña ya, añájein jádaangiñe, juríu ladǘga juríu jamá jagǘbürigu, jíbiri, barǘ jamaali ligáburi jafíñen juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Añájein gíñe gürígia Crétana jáma Arábiana, sun wagía agáamba wamútiña adímureja luágu luweírigun Búngiu lídan werérun guánarü. ");
INSERT INTO cabNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Weíriti janígi súngubei, ibídiñeja joun cába lan jasáminara, ába buri jálügüdagun jámagua. —¿Cásan míni lan sun le? ");
INSERT INTO cabNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Jíbiri, ába jéjerajan jáu lánigu Jesúsu, ába jaríñagun. —Bacháruañanúrügü jáña. ");
INSERT INTO cabNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ábati laráramun Pédro jáma ja jíbiri únsu apóstolugu, ába laríñagun láu umálali jéreti. —Wügǘriña Judéana jáma sun ja aganoúbaña Jerusalén, agáamba jumeí le lúnbei naríñaguni jun buídu, subúdi jumámugei ca lan lílabei cátei le jaríjubei. ");
INSERT INTO cabNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mabácharuántiña wügǘriña ja quei jarítagun, néfugubeigili bináafin guetó. ");
INSERT INTO cabNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Cátei le, le jaríjubei, ligía lé meja uágubei ladímureja Joél, le proféta, dan le laríñagunbei. ");
INSERT INTO cabNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Lídoun buríme lagúmujoun wéyu, líña laríñagun Búngiu, noúnajabei náni Espíritu jádoun sun gürígia, nadímurejaba jayúmulugugiñe jisáanigu. Nayáwadaguba joun irájüñü, lúma joun weíyaaña mútu. ");
INSERT INTO cabNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Noúnajabei gíñe náni Espíritu jádoun ja esériwidubaña nun lídoun buri wéyu ligía, wügǘriña jáma würíña, ábame nadímurejan jayúmulugugiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Narúfuduba buri cátei garíyawaseti siélu, narúfuduba seíni uboúagu. láubei jítaü seíni buri ligía, láu wátu geméti, lúma láu juánriñu láuti gumúlali. ");
INSERT INTO cabNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Labúrigaduba wéyu, láfuarame játi funáti quei jítaü, lubáragiñe lachǘlürün luwéyuri Wabúreme, le lúnbei ában lan wéyu weíriti, le marijíngilíbei líbe. ");
INSERT INTO cabNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Áni sun ja amúriajatiña asálbaruni lúmagiñe Búngiu, jasálbaruba. ");
INSERT INTO cabNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","‘Agáamba jumeí lubeíti le lúnbei naríñaguni, jugúya wügǘriña Israelítagu. Jesúsu le Nazarétna, ában meja wügǘri le larúfudubei Búngiu jigíbugiñe quei wügǘri úaraguati láu buri cátei weínamuti, miláguru, lúma buri seíni le ladǘgübei Búngiu jagánagua lídaangiñe, quei le jisúbudin. ");
INSERT INTO cabNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Láu sun líra, dan le ledéregerúnbei jun, quei ligáburi aráansejani le larítagubei Búngiu lúmagiñe furúmiñeti dan, ába jáfaruni jilágubei láu jedéregeruni joun wügǘriña wuríbatiña lun jádaraguni luágu gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ába leséfuruni Búngiu lídaangiñe lubáfu oúweni, sarágüda lumúti lúnya labágaridun, ladǘga siñá lan gabáfu lan oúweni luágu. ");
INSERT INTO cabNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Laríñajare urúei Davíd, dan le ladímurejan luágu Jesúsu. Subúdi numúti luágu númabei lan Nabúreme Búngiu súnwandan, noúbagiñeñein lun úa lan ni cáta lun lebélaagüdün anúfudei nídoun. ");
INSERT INTO cabNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ligía lébubei téjerajan nanígi, ába nadímurejan luágu ugúndani le nídaanbei. Láu sun wügǘri nan garaǘwarügüti, jeménigitina buágu luágu nabágaridayaba lan, ");
INSERT INTO cabNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ladǘga mígirun bubóun nuwáni lídan jabára jiláaña, mígirun amǘrüme lun lañáladun núgubu, áu le bánigu le jínsiñebei bun. ");
INSERT INTO cabNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Arúfuda bumúti ǘma le anǘgübei gürígia lídoun ibágari magúmuchaditi nun, áni babuínchagüdǘbadina láu ugúndani láu abúnja lan nubádu. ");
INSERT INTO cabNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","‘Nidújeñu, cátei furáanguti le, luágu jilá lan meja wadúje Davíd, bunáwa ligía, gayáraagili waríjini lumúaja chülǘ lúmoun wéyu le. ");
INSERT INTO cabNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Davíd, ában meja proféta ligía, áni subúdi lumúti meja luágu aríñaga láali lan Búngiu lun luágu jádaangiñeba lan linébaanfan liábin Crístu, le lúnbei lañúurun luágu lála. ");
INSERT INTO cabNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Adímurejati lubeíti Davíd luágu lásaarun Crístu lídaangiñe oúweni, luágu gíñe merédeboun lan luwáni lídan jabára jiláaña, mañáladun ligíame lúgubu. Ítara líña ladímurejan Davíd luágu Crístu camá jamuga aríagu líña lun, áni ítara líña lasúseredun. ");
INSERT INTO cabNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Sarágüda lumúti Búngiu Jesúsu méme le lídaangiñe oúweni, sun wagía geféentiwa luágu líra. ");
INSERT INTO cabNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ñurúgüda lumúti Búngiu lueígiñe loúnwenren láu sarágu uweíriguni, ába lerésibiruni Sífiri Sándu lúmagiñe Búngiu queísi laríñaguni Búngiu lun, lun gayáraabei lan loúnajani méme Sífiri Sándu ligía joun sun lánigu uboúagu. Ligía cátei le aríja jumáalibei lúma le agáamba jumáalibei guetó. ");
INSERT INTO cabNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Máma Davíd amúdeirubei siélun, aríñagati Davíd guánarügü. Laríñajare Búngiu lun Nabúreme. “Ñürǘba lueígiñe noúnwenren, ");
INSERT INTO cabNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","daríme níchuguniña báganiñu lábugiñoun bubáfu.” ");
INSERT INTO cabNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","‘Lúnti jasúbudiruni sun jugúya linásiñun Israél luágu Jesúsu méme lan le, le jádaragubei luágu gurúwa, adǘga láali lan Búngiu lun ligíaba lan Wasálbaragüle, ligíame gíñe Wabúreme. ");
INSERT INTO cabNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Dan jagáambunbalin cátei le, ába lebélurun igárigu tídoun janígi, ába jaríñagun lun Pédro lúma joun jíbiri apóstolugu. —Wadújeñu, ¿cábasan wadǘga? ");
INSERT INTO cabNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ába laríñagun Pédro joun. —Sáansi jumeí jigáburi ligíbugiñe Búngiu, badísei jugúyame cáda ában lídan líri Jesucrístu, ferúdunawa lámuga jifígoun, ru lámugei Búngiu Sífiri Sándu jun. ");
INSERT INTO cabNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ladǘga aríñagaali Búngiu luágu líchugubei lan giñe Sífiri Sándu jun, lúma joun jadǘgawagun, lúma joun ja aganoúbaña díse, lúma joun sun ja lagúarubaña Búngiu lun lánigu jamá. ");
INSERT INTO cabNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Láu buri dimúrei le lúma buri ámu, ladímureja Pédro joun, ába laríñagun joun. —Séfu jumá lueí asúfuriruni le lúnbei liábin jawágun gürígia wuríbatiña ja. ");
INSERT INTO cabNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ítara liñáti ába jabásterun, ja adǘgübaña gásu láu lerérun, ába jayábin queí buri ǘrüwa mílu gürígia lun jafíñerun luágu Jesucrístu wéyu ligía. ");
INSERT INTO cabNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ába jedéregeragun joúngua lun jafúnrendeiruni le jarúfudajabei apóstolugu joun, aganoúa jagía lídan úarani jámagua, ayúmuragua jagía buri lun Búngiu, oúndaragua jagía lun jeíginun fein to arítaguagülei luágu loúnwen Jesúsu, queísi meja laríñaguni joun apóstolugu lun jadǘgüni. ");
INSERT INTO cabNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Súngubei láuñanu luweírin anígi luágu buri seíni lúma buri miláguru le ladǘgübei Búngiu jádaangiñe apóstolugu. ");
INSERT INTO cabNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Sun ja afíñerubaña, lídaañanu ában, ába buríti jafánreinjani le jámati jádaangua. ");
INSERT INTO cabNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jalúgurajeí buri jafúlasun lúma le jámati, ába jafánreinjani lebégi según lemégeirun cáda ában. ");
INSERT INTO cabNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ságü wéyu joúndaragun témpulurugu lun jájuduragun lun Búngiu. Lárigiñe, ába joúndaragun lúbiñe ában jádaangiñe lun jeíginun fein to arítaguagülei luágu loúnwen Jesúsu, lúma lun jeígin le lánina ságü wéyu, lídan ában láu ugúndani lúma gudémegu. ");
INSERT INTO cabNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ábaja jadímurejan weírigu luágu Búngiu, ábati jínsiñe jamá joun gürígia, ábatija anáajeina lániña Búngiu ja asálbareinabaña jánwoun. ");
INSERT INTO cabNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Luágu ában wéyu, ába lídin Pédro lúma Juan témpulurugu ladaǘnrün ǘrüwa rábounwéyu, le lórate ayúmuraguni lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ságü wéyu, ñíñein lan ában wügǘri meíbugunti lúmagiñe lagǘriajoún, barǘwarügütíja añúura lubádu tubéneri témpulu le gíribei “Béna Buídumeraüti” lun lamúriajan seínsu jáma ebélurutiña témpulurugun. ");
INSERT INTO cabNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Dan le laríjinbaliña meíbugunti ligía Pédro lúma Juan jebélura lan témpulurúgun, ába lamúriajan seínsu jáma. ");
INSERT INTO cabNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ábati jaríjin Pédro lúma Juan luágun, ába laríñagun Pédro lun. —Aríjabá wawágun. ");
INSERT INTO cabNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ába laríjin jawágun, agúraba yebe jíchugun seínsu lun. ");
INSERT INTO cabNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ába laríñagun Pédro lun. —Maseínsutina, níchigaali le númati bun. lídan líri Jesucrístu le Nazarétna, sarába, beíbuga. ");
INSERT INTO cabNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ábati lárügüdüni Pédro lueígiñe lújabu le loúnwenren, ába liñúraguni, óra ligía, ába ledérebugudun lugúdi lúma lumúrugute. ");
INSERT INTO cabNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ábati lachúbarun lun laráramun, ába leíbugun. Ába lebélurun jáma témpulurugun, eíbugeina, achúbajeina, adímurejeina luágu luweírigun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ába jaríjini sun gürígia eíbuga lúma adímureja luágu luweírigun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Weírititi janígi luágu le asúseredubei lun, quei subúdi jabálin wügǘri ligía, subúdi jameí luágu ligía lan léñaja añúurubei amúriaja tubéneri témpulu le gíribei “Béna Buídumeraüti”. ");
INSERT INTO cabNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mígiragüdün lumútiñati meíbugunti le areídagubei Pédro lúma Juan, súnti gürígia, ába jeíbaagun láu luweírin janígi luágun tubáranda témpulu le gíribei Salomón, le ñí jabei. ");
INSERT INTO cabNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Dan le laríjini Pédro cátei le, ába laríñagun joun gürígia. —Jugúya Israelítagu, ¿ca uágu laweírida janígi? ¿Ca uágu jaríaguawa camá jamuga wagía areídaguagüdübalin wügǘri le, eíbugagüdei láu wabáfu o láu lan wagúnfulin lúma Búngiu? ");
INSERT INTO cabNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Máma líña, Búngiu, le Jabúngiute binádu wagǘbürigu Abrahám, Isáac lúma Jacób, ligía areídaguagüdübalin wügǘri le lun líchuguni líñun-ágei uweíriguni lun Jesucrístu le Liraǘ, ligíra lé meja jedéregerubei joun lúrudugu, áni dan lálugan Piláto lígiragüdüni, májatün. ");
INSERT INTO cabNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Lubáragiñe jamúriajan lun lígirawagüdǘn Jesúsu le jarúmabei áni richágua, amúriajarügü jugúya lun lígirawagüdǘn ában gáfarajati. ");
INSERT INTO cabNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ítara líña jáfaruni le íchugubalin ibágari tímatimaati. Ába lásaaragüdüni Búngiu lídaangiñe oúweni, áni geféentiwa luágu líra. ");
INSERT INTO cabNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Niján wügǘri le jaríjubei áni subúdi jumeí, láu lubáfu méme Jesúsu ligía, lerésibira érei. Wafíñen luágu Jesúsu, ligía areídaguagüdübalin buídu buídu quei jaríjini. ");
INSERT INTO cabNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‘Subúdi náali, nidújeñu, luágu ibídiñe lán meja jun ca lan jadǘgübei dan le jáfarunbálin Jesúsu, jugúya jáma jábutinu. ");
INSERT INTO cabNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Láu sun líra, gúnfuli lumúti Búngiu lé meja laríñagubei jádaangiñe profétagu, luágu lúnti lan lasúfuriruba lan Crístu. ");
INSERT INTO cabNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ligía lubeíti, ígira jumeí binádu jigáburi, giríbu jumá lun Búngiu, chibáwa lámuga jifígoun. ");
INSERT INTO cabNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ábameti gayára lan loúnajan Búngiu eméraaguni tun juwáni, oúnajaya leíme Jesúsu le Crístu, le aráanseelibei lubáragiñe furúmiñeti dan woun. ");
INSERT INTO cabNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Láu sun, lúnti lan leréderun Jesucrístu siélu guetó daríme laráanseruni Búngiu sun cátei quei laríñaguni jádaangiñe profétagu ja derégeguaañabaña joúngua lun, lídan meja dan le binádu. ");
INSERT INTO cabNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ítara líña lubeíti aríñagati meja Moisés joun binádu wagǘbürigu. “Loúnajaba Wabúreme Búngiu ában proféta jídaangiñe guánarügü quei loúnajanina. Ánja jumá lun sun le lúnbei laríñaguni jun, ");
INSERT INTO cabNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ladǘga sun ja amájarutiña lun le laríñagubei proféta ligía, jagídarúba jádaangiñe lánigu Búngiu, ábame jagǘnrinchawagún.” ");
INSERT INTO cabNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","‘Ítara líña lubeíti, sun profétagu lúmagiñe Samuél darí lárigiñe, adímurejatiña libǘgürü buri cátei le lúnbei lasúseredun lídoun buri wéyu le. ");
INSERT INTO cabNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jugúya lúnbei jerésibiruni sun le laríñagubei Búngiu jádaangiñe profétagu, luáguti gíñe jufúleisein darádu lé meja ladǘgübei Búngiu jáma binádu wagǘbürigu dan le laríñagunbei lun Abrahám. “Nabínirubaña sun gürígia ja uboúagubaña láu ában jádaangiñe binébaanfaangu.” ");
INSERT INTO cabNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ába lanúadajani Búngiu Liraǘ lun loúnajani jun furúmiñe, jugúya juríu, lun labínirunün cáda ában jídaangiñe, láu laságarunün lídaangiñe luríban jigáburi. ");
INSERT INTO cabNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ñígiña Pedro lúma Juan adímureja joun gürígia, ligía jayábin jafádirigun juríu, jáma jábutigu súdaara ja oúnigirubárun témpulu, jáma ja lídaanbaña jadámurin saduséogu. ");
INSERT INTO cabNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gáñitiña ladǘga jarúfudajan Pédro lúma Juan joun gürígia, aríñaga jagía luágu arúfudúa lan luágu jásaaruba lan gürígia lídaangiñe oúweni lúnya jabágaridun ladǘga sará lan Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ábati janǘgüniña adáüra, ába jádaruniña furísunrugun darí larúgan quei dárüjali lubeí. ");
INSERT INTO cabNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Sarágu jáña jádaangiñe ja agáambubalin ugánu le jíchugubei apóstolugu afíñerutiña luágu. Ja afíñerubaña járügü wügǘriña, queí buri seíngü mílu. ");
INSERT INTO cabNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Larúgan, ába joúndaragun jábutigu juríu, wügǘriña weírigutiña lídan jafíñen, jáma arúfudajatiña lilúrudun Moisés, Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ñíñein gíñe Anás le fádiri le íñutimaabei, Gáifasi, Juan, Alejándro jáma sun ja jádaangiñebaña lufámilian Anás. ");
INSERT INTO cabNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ábati joúnajan anǘgei Pédro lúma Juan, ába jíchuguniña lamídan jadámurin, ába jaríñagun joun. —¿Ca áu ubáfu, o ca ídan íri jareídaguagüdei wügǘri le? ");
INSERT INTO cabNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Buin líña Pédro láu Sífiri Sándu, ába laríñagun joun. —Jábutigu juríu jáma wügǘriña weírigutiña lídan wafíñen. ");
INSERT INTO cabNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","quei jálügüdüníwa luágu buíti le adügǘbei lun ában wügǘri sánditi, ída líña lan lareídawaguágüdün, ");
INSERT INTO cabNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","buséntiwa lun jasúbudiruni, jugúya jáma sun gürígia ja Israelítagu, luágu láu lan lubáfu Jesucrístu le Nazarétna niján lubeí wügǘri le ya jigíbugiñe areídaguañu. Láu lubáfu Jesucrístu, le meme jádaragubei luágu gurúwa, le lásaaragüdübei Búngiu lídaangiñe oúweni, lareídagua. ");
INSERT INTO cabNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesúsu le, ligía queísi dǘbü le áubei jíchiga mebéreseni, jugúya le queíbaña ábunagutiña múna, áni ñǘbinjali Jesúsu lun ligíaba lan quei dǘbü le mégeiwatimaabei lídan bunáguaü. ");
INSERT INTO cabNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Úati ámu lun lasálbaruníwa lueídügüya Jesucrístu, ladǘga míchuti Búngiu ámu íri uboúagu lun gayára lan wasálbarun lueígiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Dan jaríjini gumádimatiña luágu adímureja jamá Pédro lúma Juan manúfudeiga ni murúsun, áni subúdi jameí luágu máma jamá gürígia atúriajatiña sarágu, luágu gürígia jamá ja furúmieguarügü, ába laweíridun janígi, ábati jasúbudiruni luágu jádaangiñetiña lan já meja eíbugubaña lúma Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Queíti ñíñein lubeí wügǘri le areídawaguágüdübei jáma, rára ligía, siñáti jaríñagun lúrudugu ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ábati joúnajaniña lúrudugu Pédro lúma Juan lúma wügǘri le areídaguaalibei boúgudin lueí jadámurin lun gayáraabei lan jayánujan jámagua. ");
INSERT INTO cabNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Jaríñagati. —¿Cábasan wadǘga jáu wügǘriña ja? Sun ja aganoúbaña Jerusalén subúdi jamúti luágu adǘga jamáali lan miláguru le, áni siñáti wayéedagun láu. ");
INSERT INTO cabNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lun mabúruchagun lan ugánu luágu cátei le lídan sun fulásu, wewéridiraña lun madímurejandügüya jamá ni ca un lídan líri Jesúsu lúmagiñe ugúñe. ");
INSERT INTO cabNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ábati jagúarun joun lun jebélurun, ába jaríñagun joun lun ni lan ca uágu lun madímurejan jamá, marúfudajan jagíame lídan líri Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ába jaríñagun Pédro lúma Juan joun. —Samína jumá júngua ánjein buídu lubeí ligíbugiñe Búngiu lun ladügǘn le jubeíbei, ígira le lubeíbei Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wagía, siñáti wámanichun láu cátei le aríja wamáalibei lúma le agáamba wamáalibei. ");
INSERT INTO cabNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ábayati jewéridiruniña gumádimatiña, ába jígiragüdüniña. Madáritiña ída lúba lan jadǘgün ni cáta jáu ladǘga adímurejatiña buri gürígia buíti luágu Búngiu luágu cátei le asúseredubei. ");
INSERT INTO cabNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Wügǘri le areídagubei láu miláguru ligía, sügǘ láu bián-wein irúmu láu. ");
INSERT INTO cabNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Dan le jáfuridun Pédro lúma Juan furísunrugugiñe, ába joúdin le ñí jabei jíbirigu, ába jabájüdaguni sun le jaríñagubei jábutigu fádirigu jáma wügǘriña weírigutiña joun. ");
INSERT INTO cabNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Dan jagáambubalin, ába jayúmuragun sun jagía lun Búngiu, ába jaríñagun. —Wabúreme, amǘrü Búngiubei le adǘgübalin siélu, uboú, barána lúma sun cátei. ");
INSERT INTO cabNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Amǘrü, aríñagatibu láu lubáfu Sífiri Sándu liyúmulugugiñe Davíd lé meja esériwidubei bun. ¿Ca uágu jagáñida ja mámabaña juríu, samína jagía lun jadǘgüni cátei le siñábei jadǘgüni? ");
INSERT INTO cabNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Iñúraguatiña lurúeitegu uboú joúngua, oúndaraguátiña lábutigu fulásu lun jadǘgün wuríbani lun Wabúreme Búngiu lúma lun Crístu le lanúadajabei. ");
INSERT INTO cabNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","‘Áni suséreti ítara, oúndaraguatiña Heródes luma Póncio Piláto lídan ubúrugu le, jáma ja mámabaña juríu, lúma jáma Israelítagu lun jadǘgün wuríbani lun Biraǘ Jesúsu le sándubei, le banúadajabei. ");
INSERT INTO cabNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Láu líra, adǘga jamúti sun le baráansejabei lun lasúsereduba lan. ");
INSERT INTO cabNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Guetóti, Wabúreme, aríjabeí jasíadiruníwa, rúba anígi woun, wagía le esériwidubalibu, lun wadímurejan buágu manúfudeiga, ");
INSERT INTO cabNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","gayára lámuga gíñe wareídaguágüdün sánditiña, adǘga wagíame miláguru lídan líri Biraǘ Jesúsu le sándubei, láu bubáfu wawágu. ");
INSERT INTO cabNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Dan le lásurun jayúmuragun, ába lánjingichun fulásu le ñí lubei joúndaragua, ába jabuínchun sun jagía láu lubáfu Sífiri Sándu, ába japúrichijani lerérun Búngiu manúfudeiga. ");
INSERT INTO cabNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Sun ja afíñerubaña, ában lábu jarítagun, ában lábu jabúseerun. Úati ni ában aríñaguti luágu lumégen luágu láni lan lábugua, sun cátei jáni súngua luágu. ");
INSERT INTO cabNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ába jasígirun apóstolugu adímureja luágu lásaarun Wabúreme Jesúsu lídaangiñe oúweni láu sarágu ubáfu, ábati labíniruniña Búngiu sun jagía sarágu. ");
INSERT INTO cabNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Úati ni ában jádaangiñe emégeiruti ni cáta ladǘga sun ja gafúlasunbaña o gában, ába buri jalúgurunun, ába janǘgüni tebégi, ");
INSERT INTO cabNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ába jadéregeruni joun apóstolugu lun lafánreinjoún jádan ja emégeirutiña. ");
INSERT INTO cabNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Queíburi, ñíñein ában jádaangiñe ladǘgawagun Leví jádan, gíriti José, agǘriajoúti luágu uboúju le gíribei Chípre, ába jáchuni apóstolugu Bernabé, míni lan líra, “Le Íchigubei Gurásu”. ");
INSERT INTO cabNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wügǘri ligía, ába lalúguruni lufúlasun, ába lanǘgüni seínsu edéregera joun apóstolugu. ");
INSERT INTO cabNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ñíñein gíñe ában wügǘri gíriti Ananías, túma Safíra, to lúmari, ába gíñe jalúgurun ában fulásu. ");
INSERT INTO cabNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Wügǘri le, ába lanǘgün lídaangiñe seínsu, ába lídin láu líbiri joun apóstolugu, lafámura camá jamuga ligía rügǘñein libíjin luágu fulásu. Áni subúsititi sun cátei tun lúmari. ");
INSERT INTO cabNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ábati laríñagun Pédro lun. —Ananías, ¿ca uágu bígira lun lagáñiruni Máfia barítagun lun layéejagüdǘnibu lun Sífiri Sándu, lun beréderun láu líbiri seínsu le afáyeirúbei bun luágu fulásu? ");
INSERT INTO cabNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Ma funági bufúlasun meja fulásu? Lárigiñe balúguruni, ¿ma biseínsun lun badǘgüni le babúseerunbei láu? ¿Ca uágu basáminara badǘgüni cátei le? Búngiu bálugubei bayéedagun, máma wügǘriña. ");
INSERT INTO cabNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Dan lagáambuni Ananías cátei le, ába láburujan oúwe. Súnti ja asúbudirubalin cátei le, ába janúfudedagun. ");
INSERT INTO cabNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ábati jayábin wügǘriña, ába joúburaguni Ananías, ába janǘgüni ábuna. ");
INSERT INTO cabNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Queíburi ǘrüwa óra lárigiñe, ába tebélurun lúmari Ananías, ibídiñoun ni cáta tun luágu le asúseredubei. ");
INSERT INTO cabNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ába laríñagun Pédro tun. —Aríñagabeí nun, ¿luágu ebégi le jaríñagubei jalúgurei fulásu? Ába taríñagun. —Ánja, luágu ebégi ligía. ");
INSERT INTO cabNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ábati laríñagun Pédro. —¿Ca san uágu jebélura lídoun úaraduni lun joúchaguni láni Búngiu Espíritu ítara? Añatén ja anǘgübalin búmari ábuna, janǘgadibu gíñe. ");
INSERT INTO cabNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lídan méme óra ligía, ába táburujan oúwe lubádu lugúdi Pédro. Dan jebélurun wügǘriña, jadáriroun jiláaru, ába jaságarunun, ába jábununun loúbagiñe túmari. ");
INSERT INTO cabNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Súnti gürígia ja afíñebaña luágu Crístu jáma sun ja asúbudirubalin cátei le, ába janúfudedagun sarágu. ");
INSERT INTO cabNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Adáaguatiña buri apóstolugu sarágu seíni lúma miláguru jádan gürígia, ábati buri joúndaragun sun afíñetiña lídan fulásu témpulurugu le gíribei “Barandá Salomón”. ");
INSERT INTO cabNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Úati meja ni ában jádaangiñe ja mámabaña afíñetiña lun joúndaragun jáma afíñetiña ladǘga janúfude, láu sun jínsiñe jamá sun afíñetiña joun gürígia, sarágu. ");
INSERT INTO cabNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Eíbu wéyu, eíbu jayábin gürígia lun jafíñerun luágu Jesucrístu, dándu wügǘriña queísi würíña. ");
INSERT INTO cabNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Quei jadǘgüña lan apóstolugu sarágu miláguru, ába jaságaraguniña gürígia sánditiña ǘmadoun tídan jabárari lun dan lan lásügürün Pédro, gayára lan jareídagun láurügü tadágarun liyáwa jawágu. ");
INSERT INTO cabNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ñǘbintiña gíñe sarágu gürígia lídaangiñe buri fulásu yaráfati lun Jerusaléoun jáu sánditiña jáma ja gawágutiña espíritugu wuríbatiña, sun jagía areídaguátiña. ");
INSERT INTO cabNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Léti fádiri le íñutimaabei jáma ja jánigu saduséogu ja lúmabaña, ába jabuínchun láu gimúgaü, ");
INSERT INTO cabNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ába janǘgüniña apóstolugu, ába jadáürüniña. ");
INSERT INTO cabNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ába ladáraruni ában láni Wabúreme Búngiu ánjeli tubéneri furísun áriebu ligía, ába láfuridagüdǘniña, ába laríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Jeíba, jaráramame témpulurugu, ábame jabájüdagun joun ja ñíbaña luágu iséri ibágari le líchugubei Jesucrístu joun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Dan jagáambuni cátei le, ába joúdin témpulurugun bináafingua, ába jagúmeserun arúfudaja. Súnti dan le, le fádiri le íñutimaabei jáma ja lúmabaña, ába joúndaruniña líñun-ágei lúrudu, ja súnbaña Israelítagu weírigutiña, ába joúnajan anǘgaña apóstolugu furísunrugugiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Dan jachǘlürünbei polisía furísunrugu, madári jamútiña ñi. Ába jagíribudun, ");
INSERT INTO cabNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ába jaríñagun. —Darúñu líña wadárirunun furísun, ñíñanu súdaara bénabu oúnigira, dan le webélurunbei, madáritiwa ni ában jádaangiñe apóstolugu ñi múnada. ");
INSERT INTO cabNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dan le jagáambunbalin jábutigu fádirigu lúma jábuti súdaara ja oúnigirubarun témpulu cátei le, ába jálügüdagun joúngua cába lánfuna ídan lébeda cátei le. ");
INSERT INTO cabNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Lídan óra ligía, ligía liábin ában wügǘri, ába laríñagun joun. —Ja wügǘriña ja jádarubaña furísunrugun, añájein témpulurugu arúfudaja joun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ábati lídin jábuti oúnigirutiña jáu súdaara, ába janǘgüniña láu buídu, ladǘga janúfude lueí jachámuragun gürígia dǘbü jawágun. ");
INSERT INTO cabNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Dan jachǘlürün jáu, ába jíchuguniña ligíbugiñe líñun-ágei lúrudu, ába laríñagun fádiri íñutimaati joun. ");
INSERT INTO cabNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Wéridi wamáadün lun marúfudajandügüya jumá lídan líri Jesúsu, áni ¿ca jadǘga? Buíngüda jumá sun Jerusalén láu le jarúfudajabei, áni buséntün jíchuguni dúru wawágun luágu loúnwen wügǘri ligía. ");
INSERT INTO cabNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ábati loúnabun Pédro jáma ja jíbiri apóstolugu, ába laríñagun. —Lúnti wagáambuni Búngiu lun wadǘgüni le lubeíbei lubáragiñe le jabeíbei wügǘriña. ");
INSERT INTO cabNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Le Jabúngiute binádu wagǘbürigu, ligía ásaaragüdǘbalin Jesúsu, le méme jáfarubei láu jádaraguni luágu ában gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Rúlaali Búngiu uweíriguni lun, ñurúgüdaleí lueígiñe loúnwenren, adǘga láali Ábutime lúma Asálbaragülei, gayára lámuga jígiruni Israelítagu binádu jagáburi, lun gíñe ferúdunawa lan jafígoun. ");
INSERT INTO cabNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Geféentiwa luágu líra, geféenti gíñe Sífiri Sándu le líchugubei Búngiu joun ja ñǘdünbaña láu le lubeíbei. ");
INSERT INTO cabNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Dan jagáambunbalin líñun-ágei lúrudu cátei le, ába jagáñidun, ába yebe jabúseerun jáfaraguniña jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ñíñein ában fariséo jádan lúrudugu, gíriti Gamaliél, maésturu lánina lilúrudun Moisés, inébeti joun gürígia sarágu. Ába laráramun, ába laríñagun lun janügǘniwa apóstolugu lídaangiñe adámurini luágu murúsun óra, gayára lámuga ladímurejan jámarügü lúrudu. ");
INSERT INTO cabNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ába laríñagun joun gumádimatiña. —Wügǘriña Israélna, toúnigi jumátia láu le lúnbei jadǘgüni jáu wügǘriña ja. ");
INSERT INTO cabNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Jarítagua jumátia luágu iñúragua lán meja Teudás lúngua aríñaga luágu ában lan wügǘri weíriguti ligía, ába jafálaruni gádürü-san wügǘriña, áni afarúati jilágubei, súnti ja afálarubalin, ába jawáragadagun, ába lagúmuchun sun cátei. ");
INSERT INTO cabNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Lárigiñe, lídan lidáani jabájüdǘniwa gürígia, ligía liñúragun Júdas le Galiléana lúngua, sarágu jáña afálaruti lídan labúseerun yebe lagárabagun luágun gumádi. Áfarúati gíñe, ába gíñe jawáragadagun sun ja afálarubalin. ");
INSERT INTO cabNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ígira jumáña lubeíti wügǘriña ja, memétera jumá jámoun. Ladǘga ánjein jáni lubeí wügǘriña cátei le jarúfudajabei lúma le jadǘgübei, lagúmuchaguba, ");
INSERT INTO cabNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ánjein láni lubeí Búngiu, siñá jubei agǘnrinchagua. Toúnigi jumá, mageíndagua jumá lúma Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ába jánjanrun súngubei láu le laríñagubei. Ábati jebélaagüdüniña apóstolugu, ába jabeíchuniña, ába jaríñagun joun lun jebé lan jadímurejan lídan líri Jesúsu. Lárigiñe, ába jígiragüdüniña, ");
INSERT INTO cabNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ába jáfuridun apóstolugu jámagiñe lúrudugu, gúndaañu láu laríjiniña Búngiu queísi gürígia gadǘnamatiña lun jasúfuriruni busíganu luágu líri Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Merédetiti jarúfudajan témpulurugu lúma tídan buri múna ságü wéyu, aríñaga jagía luágu Jesúsu lan Crístubei le agúrabajoúbei. ");
INSERT INTO cabNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lídan dan ligía, quei agíbedeina jamátima afíñetiña luágu Jesucrístu, ába jagúmeserun ja adímurejabaña güriégu adárira jadúnrun ja adímurejabalin jerérun juríu, ába jaríñagun luágu mibíjin jamá würíña güriégu ja jiláañabaña úmari eígini dan le lafánreinjoúniwa, ságü wéyu. ");
INSERT INTO cabNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ábati joúndaruniña dúusu apóstolugu afíñetiña, ába jaríñagun joun. —Mabuídunti lun wígiruni wapúrichijani lerérun Búngiu lun wagíaba lan afánreinjei eígini. ");
INSERT INTO cabNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ligía lubeíti nidújeñu, áluga jumá sédü wügǘriña jídaangiñe ja gafíñerúati jawágu, ja chúbaña áu, ja derégeguatiña joúngua lun Sífiri Sándu le gumúti, lun jadǘgüni wadágimanu le. ");
INSERT INTO cabNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wagía, wedéregerubei wadáani lun ayúmuraguni lun Búngiu luma lun warúfudajani lerérun. ");
INSERT INTO cabNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ába júaradun súngubei lídan cátei le, ába janúadiruní Estéban, le ában wügǘri buín líña láu afíñeni luágu Jesucrístu áni derégeguañu líña lúngua lun Sífiri Sándu le gumúti, Felípe, Prócoro, Nicanór, Timón, Parménas lúma Nicolás le Antioquíana, lé meja afálarubalin ligáburi jafíñen juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ába janǘgüniña le ñíjin jabeí apóstolugu, ába jayúmuragun lun Búngiu jáu, ába jíchuguni jájabu jawágu lun jabíniruniña. ");
INSERT INTO cabNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ába gíbetimaajaña lan agáambuti lerérun Búngiu lídan sun fulásu, agánwoundeina jagía afíñetiña Jerusalén furése, ába giñe jafíñerun sarágu fádirigu juríu luágu Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Adáaguatíja Estéban, le ábanbei wügǘri le buínbei láu ubáfu lúma abíniruni lúmagiñeti Búngiu, miláguru lúma seíni jádan gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ábati jagúmeserun gürígia asígeneja luágu, gürígia jagía, tídaangiñetiña jalígilisin juríu to gíriboun “Idámunigu Joúnguaaña”, jáma Cirénena, Alejandríana, Cilíciana jáma Ásiana. ");
INSERT INTO cabNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Siñáti joun lúma Estéban, ladǘga láu lichú áu le líchugubei Sífiri Sándu lun ladímureja. ");
INSERT INTO cabNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ábati jafáyeirun wügǘriña lun jaríñagun luágu agáamba jamáani adímureja wuríba luágu Moisés lúma luágu Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ábati jafúdagüdǘniña gürígia, jáma arúfudajatiña lilúrudun Moisés, jáma wügǘriña weírigutiña lídan jafíñen juríu, ába járügüdüni Estéban, ába janǘgüni ligíbugiñoun líñun-ágei lúrudu. ");
INSERT INTO cabNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ába giñe jálugun yéetiña lun jaríñagun luágu lerédera lan adímureja wuríba tuágu témpulu sándu lúma luágu lilúrudun Moisés. ");
INSERT INTO cabNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jaríñaga. —Agáamba wamúti laríñagun luágu lagǘnrinchaguboún lan Jesúsu Nazarétna témpulu, sáansi leíme igáburi le lígirubei Moisés woun. ");
INSERT INTO cabNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Dánti jaríjini lúrudugu jáma sun ja ñíbaña ligíbu Estéban, ítara líña camá ligíbu ában ánjeli. ");
INSERT INTO cabNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ábati laríñagun fádiri le íñutimaabei lun Estéban. —¿Inárüni sun cátei le? ");
INSERT INTO cabNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ába loúnabun. —Nidújeñu, nagǘbürigu, agáamba jumána. Weíriguti Búngiu, arúfudaguáti meja lúngua lun Wáguchi Abrahám dan le Mesopotámia lan, lubáragiñe lídin agánawa Harán. ");
INSERT INTO cabNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ába laríñagun lun. “Ígirabeí bageíra jáma bidújeñu, beíba lídoun fulásu le lúnbei narúfuduni bun.” ");
INSERT INTO cabNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ábati láfuridun Abrahám Caldéagiñe, ába lídin agánawa Harán. Lárigiñe, ába loúnwen lúguchi, ába lanǘgüni Búngiu Abrahám lídoun fulásu le ñí lubei wagánawa guetó. ");
INSERT INTO cabNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Míchuti ni murúsun múa lun lídan fulásu le, aríñagarügüti lun luágu lachǘlürüba lan dan lun lánibei lan ageíraü le jáu sun ladǘgüwagun, láu sún meja marájüñügili lan Abrahám lídan dan ligía. ");
INSERT INTO cabNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Aríñagati Búngiu lun luágu jaganoúba lan ladǘgawagun quei teréncha lídan jageíra ámu, luágu idámunibaña lan ñi, amúdirúa jagíame luágu gádürü-san irúmu. ");
INSERT INTO cabNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Aríñagati gíñe Búngiu lun. “Nagúseragüdübaña lílana fulásu le anǘgübaliña idámunime, lárigiñeme lásügürün gádürü-san irúmu, ábame jáfuridun ñígiñe, ábame jesériwidun nun lídan fulásu le.” ");
INSERT INTO cabNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Adǘgati Búngiu ában darádu lúma Abrahám, ába lerésibiruni Abrahám circuncisión, liseínime darádu ligía. Ligía, dan lubeí lagǘriajoúnbei liraǘ Abrahám le Isáac, ába lerésibiruni circuncisión luágu wídü wéyu láu, ítara gíñe ladǘga Isáac lun Jacób le liraǘ, adǘgaleí Jacób, le méme gíribei Israél, joun dúusu lirájüñü, ja jagǘbürigubaña dúusu türíbu ja gíribaña Israelítagu guetó. ");
INSERT INTO cabNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","‘Lirájüñü Jacób ja, ja binádubaña wagǘbürigu, ába jagímugajan lun José le jamúlen, ába jalúguruni lun lanügǘn Ejíptoun quei idámuni. Ñíñein Búngiu lúma José, ");
INSERT INTO cabNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ába leséfuruni lídaangiñe sun lidíjeri láu líchugun gunfaráandaü lun. Ába lagáñeiragǘdüni lufúleisein Faraón, le lurúeite Ejípto lun, ába líchuguni José ábutime ñi Ejípto lúma tídan lúban Faraón. ");
INSERT INTO cabNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","‘Ábati ladágarun ában ilámaü lídan fulásu le Ejípto lúma Canaán, deréti meja dan ligía, madáritiñati binádu wagǘbürigu cába lan jeíga. ");
INSERT INTO cabNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ába lagáambun Jacób luágu níjein lan eígini Ejípto, ába loúnajaniña lirájüñü, ja binádu wagǘbürigu, ñi. Ligía furúmiñetibei jaweíyasun. ");
INSERT INTO cabNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Le libíaman joúdin, ába larúfudagun José lúngua joun líbugañanu lúma lamúlen, ítara líña lasúbudirúniña urúei lidújeñu José. ");
INSERT INTO cabNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ábati loúnajan José anǘgei Jacób le lúguchi jáu sun lufámilian, Ejíptoun, ǘrüwañanu-wein-queínsi gürígia jagía. ");
INSERT INTO cabNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ítara líña lídinbei Jacób agánawa Ejípto, le ñí lubei loúwe, ñí lubei giñe joúwegua binádu wagǘbürigu. ");
INSERT INTO cabNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Átiri irúmu lárigiñe, ába lanügǘniwa jábu ñígiñe lídoun fulásu le gíribei Síquem, ába jabunún lídan umúajaü lé meja lagáñijabei Abrahám jámagiñe lirájüñü Hamor ñi Síquem. ");
INSERT INTO cabNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","‘Dan le layárafadúnbei dan lun lagúnfulirun dimúrei le líchugubei Búngiu lun Abrahám, gíbeeña ladǘgawagun Israél Ejípto. ");
INSERT INTO cabNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ábati lagúmeserun ában urúei agúmadija Ejípto le ibídiñejabubei lun José. ");
INSERT INTO cabNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ába layéeraguniña urúei ligía warásan juríu, amúdiragua láña binádu wagǘbürigu, águragüdáña jasáanigu ja figígiña joun lun joúwegun, gumúgua lámuga warásan. ");
INSERT INTO cabNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Lídan dan ligía, ligía lagǘriajoún Moisés, ában irájü buídumeraüti, ába jagǘriajani lagǘbürigu jábiñe luágu ǘrüwa játi. ");
INSERT INTO cabNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Dan lachǘlürünbei dan lun jáguruni, ába jáguruni, ába tabúduni liraǘ urúei Ejíptona, ába tagǘriajani quei tiraǘ. ");
INSERT INTO cabNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ligía lafúnrendeirubalin Moisés lichú jáu Ejíptona, áni gabáfutiti lídan le laríñagubei lúma le ladǘgübei. ");
INSERT INTO cabNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","‘Dan le bián-weínjali irúmu láu Moisés, ába lálugun lídin aríjaña lirásan ja ladǘgawagun Israél, ja ñíbaña Ejípto. ");
INSERT INTO cabNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ába laríjin ában Ejíptona amúdiragua ában jádaangiñe, ába lídin Moisés íderaguei lidúje, ába leséfuruni láu láfaruni Ejíptona ligía jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés, jarítaguati luágu jasúbudirúbei lan Israelítagu luágu ligíaba lan layúsura Búngiu lun jésefurún lídaangiñe le gádaanbaliña, jagía, masúbudirun jamúti. ");
INSERT INTO cabNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Larúgan, ába ladúnragun Moisés jáma biáma Israelítagu ageíndagua jámagua, ába yebe labúseerun laráandaragüdüniña jámagua. Ítara líña laríñagunbei joun. “Ában mémetia mútu jugúya, ¿ca uágu jageíndagua júmagua?” ");
INSERT INTO cabNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ábati ládaruni wügǘri le áluajabei wuríbu lúma le ában, ába laríñagun lun. “¿Ca íchubalibu ábutime lúma agúseragüdütime wádan? ");
INSERT INTO cabNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Buséntibu gíñe báfarunina quei báfaruni Ejíptona ligíra gúñaarü?” ");
INSERT INTO cabNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Dan lagáambuni Moisés cátei le, ába lanúrajan, ába lídin Madiáoun. Ába leréderun agánawa ñi quei teréncha, ába jáguchi lan bián irájüñü ñi. ");
INSERT INTO cabNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","‘Bián-wein irúmu lárigiñe, ába lasáliragun ában ánjeli lun lídan fulásu mageírawati, yaráfa lun wǘbü le gíribei Sinaí, liábin lun quei wátu geméti lídan ában búbugati. ");
INSERT INTO cabNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ába laweíridun lanígi Moisés láu cátei le laríjubei, dánti layárafadun lúntima laríjini buídu, ába lagáambun laríñagun lumálali Wabúreme Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Áu Jabúngiute binádu bagǘbürigu, Lubúngiute Abrahám, Lubúngiute Isáac lúma Jacób.” Ábati lagúmeserun Moisés adádagara láu anúfudei, májaali ni lun laríjin ñíjin. ");
INSERT INTO cabNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ába laríñagun Búngiu lun. “Gidáboun bigeídin lueígiñe bugúdi, ladǘga fulásu le ñí bubei rára, fulásu sánduti. ");
INSERT INTO cabNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Aríja náali jasúfurirun numútuniña Ejípto, agáamba náali jagúajan láu igárigu, neséfuraaña lubeíti. Jigábu lubeíti, noúnajadibu Ejípto.” ");
INSERT INTO cabNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","‘Láu sun mebéresen jamá láu Moisés, álügüda jameí ca lan íchubalin ábutime lúma agúseragüdütime, oúnaja lumúti Búngiu quei ábuti lúma quei eséfujati, adímurejeina Búngiu lídaangiñe ánjeli le asáliragubei lun lídan búbugati. ");
INSERT INTO cabNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés aságarubaliña binádu wagǘbürigu Ejíptogiñe, adǘga ligía miláguru buri lúma buri cátei weíriguti lídan fulásu ligía, lídan Barána Funáti, lúma lídan fulásu mageírawati, luágu bián-wein irúmu. ");
INSERT INTO cabNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisés meme le, ligía aríñagubei joun Israelítagu. “Loúnajaba Búngiu ában proféta jun jádaangiñe guánarügü jibíriña, quei loúnajanina. Adǘga jumá gásu láu.” ");
INSERT INTO cabNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Lídan le añája lubeí Israelítagu adámurigu lídan fulásu mageírawati, Moisés méme le, ába ladímurejan lúma ánjeli luágu wǘbü le Sinaí, ába lásügüragüdüni lerérun ánjeli ligía joun binádu wagǘbürigu. Ligía le erésibirubalin ugánu le adúrarubei lun sun dan lúmagiñe Búngiu lun lásügüragüdüni woun. ");
INSERT INTO cabNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","‘Májatiña meja binádu wagǘbürigu jagáambuni Moisés, mebéreseruntiña láu, busénrügü jagía jagíribudun Ejíptoun. ");
INSERT INTO cabNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ábati jaríñagun lun Aarón. “Buséntiwa lun badǘgün búngiugu woun lun joúdin wabá wabá, ladǘga ibídiñeti woun ca lan susérebei lun Moisés, le aságarubaliwa Ejíptogiñe.” ");
INSERT INTO cabNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ábati jadǘgün ában tiyáwa bágasu lun jasándunme, ába jáfarun anímaalugu lun jadágaragüdün tun jasándun, ába jadǘgün fédu lun jagúndaarun láu cátei le jadǘgübei láu jájabu. ");
INSERT INTO cabNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ábati ladíreirun Búngiu jaweí, ába lígiruniña lun jájuduragun joun warúguma ja siélubaña. Ítara líña labǘrüdǘn tídan jalíburun profétagu. Jugúya Israelítagu, ¿áfaratün funági anímaalugu lun jadágaragüdün nun lídan bián-wein irúmu le jáubei lídan fulásu mageírawati? ");
INSERT INTO cabNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Madǘgün jumúti líra, lubáragiñe lira, barǘ jumuti jisándun Molóc tídan lágei to jadǘgüboun lun, túma tiyáwa warúguma to gíriboun Renfán, to gíñe janǘgüboun quei jisándun, iyáwaü buri ja jadáagun guánarügü lun jájuduragun joun. Ligía naságarubadǘn lubeí jageíragiñe, noúnajaünme yagǘroun méme lueí Babilónia. ");
INSERT INTO cabNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","‘Lídan fulásu mageírawati, ñíñoun méja lúban Búngiu to gadíñurúwadiboun jáma binádu wagǘbürigu, ñí lubei lerédera Búngiu jáma. Adǘga lumútu Moisés lúban Búngiu tugúya queísi larúfuduni Búngiu lun lun ladǘgünun. ");
INSERT INTO cabNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nújeingua méja múna tugúya jáma jadǘgawagun binádu wagǘbürigu, ába janǘgünun jámawagua lídoun fulásu le ñí lubei wagánawa guetó, dán meja le lagáñeirubalin Josué wuríbu jawágu mútu ja mámabaña juríu já meja aganoúbaña ya. Ítara liña, nújeingua lubeí lúban Búngiu tugúya lídan fulásu le darí lidáani Davíd. ");
INSERT INTO cabNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daríti urúei Davíd fuleísei ligíbugiñe Búngiu, ába labúseerún yebe ladǘgün ában témpulu lun laganoún Lubúngiute Jacób ñi, ");
INSERT INTO cabNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Salomón adǘgübarun témpulu tugúya, ");
INSERT INTO cabNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","láu sun, maganoún lan Búngiu le weírigutimaabei tídan buri ligílisi to jadǘga gürígia, queí meja laríñaguni proféta. ");
INSERT INTO cabNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Siélu nálabei le ñí lubei nañúura lun narúeijan, uboú, le ñí lubei neméraaguagüdei nugúdi. ¿Cába tuwúyeri múna jadǘga nun? líña laríñagun Búngiu. ¿Cátei fulásu le ñí lubei gayára lan neméraagun? ");
INSERT INTO cabNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Ma funági nadǘga sun cátei le láu nújabu? ");
INSERT INTO cabNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ába lasígirun Estéban aríñaga joun. —Ánjein jugúya, derégubeiñóun janígi, magáambaditün lun lerérun Búngiu, ítára jíña quei ja ibídiñejabúbaña lun Búngiu. Súnwandan májatün lun Sífiri Sándu, ítara jíña quei binádu jagǘbürigu. ");
INSERT INTO cabNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Ca jádaangiñe profétagu moúserun jabáña binádu jagǘbürigu wuríba? Ni ában, áfaragua jamútiña já meja adímurejabaña luágu liábin Crístu le richáguabei, guetóti dan liábin, ába jalúguruni joun láganiñu, ába jáfaruni jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Jugúya le erésibirubálin lilúrudun Búngiu jámagiñe ánjeligu, mídintün láu. ");
INSERT INTO cabNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Dan jagáambunbalin cátei le, ába jagáñidun buídu, ába lacǘnrinjan jári luágu Estéban, le jagáñi lun. ");
INSERT INTO cabNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ánjein Estéban, buin líña láu lubáfu Sífiri Sándu, ába laríjin siélun, ába laríjini luweírigun Búngiu, lúma Jesúsu rára lueígiñe loúnwenren Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ába laríñagun joun. —¡Aríja jumá! Aríagu níña lun siélu darágu, lúma Jesúsu le Wügǘri Garaǘwarügüti, lueígiñe loúnwenren Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ába jadáuruni jarígei láu jájabu lueí jagáambuni, ába jayábin sun jagía luágun, agúarajeina. ");
INSERT INTO cabNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ába jaságaruni ubúrugugiñe, ába jígirunun geféentiña janáangun lábugiñe laríaajan ában wügǘri gíriti Sáulo, ába jachámuragun dǘbü luágun Estéban. ");
INSERT INTO cabNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Súnti añája lan achámuragua dǘbü luágun, ába layúmuragun Estéban lun Jesúsu, ába laríñagun. —Nabúreme Jesúsu, resíbiboún nuwáni. ");
INSERT INTO cabNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Lárigiñe, ába lájuduragun, ába lagúaragun. —Nabúreme, míchigabá dúru jawágun lueígiñe figoú le. Lárigiñe laríñaguni le, ába loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sáulo, gúndaatiti láu láfarún Estéban. Wéyu méme ligía, ába lagúmeserun ában oúnwenbun eíbaajoúni jawágun ja afíñebaña luágu Jesucrístu, Jerusalén. Ába janúragun lídoun buri lirájüñü fulásu Judéa lúma Samária le míbetiña gürígia ñi, apóstolugu rügǘñanu manúrajan. ");
INSERT INTO cabNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ába jayábin wügǘriña ja derégeguatiña joúngua lun Búngiu, ába jábununi Estéban láu sarágu íruni luágu loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ábati lasígirun Sáulo eíbaajaña afíñetiña, ábaja lebélurun tídoun sun múna lun laságaruniña wügǘriña jáma würíña adúruujeina, ába loúnajaniña furísunrugun. ");
INSERT INTO cabNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Apúrichija jamúti ja anúrajabaña Jerusaléngiñe ugánu buíti luágu chülǘ lan Jesucrístu lun lasálbaruniña sun gürígia, sun le ñí lumuti joúdin. ");
INSERT INTO cabNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ába lídin ában jádaangiñe, gíriti Felípe, lídoun ában ubúrugu Samária, ába lagúmeserun adímureja joun ja ñíbaña luágu Crístu. ");
INSERT INTO cabNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ábaja joúndaragun gürígia, ru jagía jarígei lun le ladímurejabei Felípe, aríja jameí buri gíñe miláguru le ladáagubei. ");
INSERT INTO cabNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ladǘga sarágu buri gürígia ja gawágutiña espíritugu wuríbatiña, areídaguátiña, ába buri jáfuridun espíritugu wuríbatiña jagía agúarajeina jádaangiñe, areídagua jagía sarágu derégüdaaña jamá, meíbuguntiña. ");
INSERT INTO cabNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Súnti gürígia lídan fulásu ligía, gúndaatiña luágu cátei le. ");
INSERT INTO cabNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ñíñein ában wügǘri lídan fulásu ligía, gíriti Simón, gabíñarajati meja, lǘñajaali ayéejaña gürígia Samariána láu laríñagun joun luágu máma lan furúmieguarügü gürígia ligía. ");
INSERT INTO cabNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Agáambaja jamútitíja sun gürígia buídu, jámagiñe ja gudémegutiña dagá jámoun ja weírigutiña, ába jaríñagun. —Ibíja lumúti gürígia le oúnwenbun lubáfu Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Adǘgatiñatíja gásu láu, ladǘga lǘñajaali ayéejaña láu labíñarajan. ");
INSERT INTO cabNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Dan le jafíñerunbei luágu ugánu le líchugubei Felípe joun luágu larúeijan Búngiu lúma luágu Jesucrístu, dándu wügǘriña quei würíña, ába jabásterún. ");
INSERT INTO cabNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simón meme ligía ába gíñe lafíñerun, ába gíñe labásterún, ába lagúmeserun afálarei Felípe, le luweírin lanígi láu buri oúnwenbun buri miláguru lúma seíni le ladáagubei Felípe. ");
INSERT INTO cabNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Dan le jagáambunbalin apóstolugu ja Jerusalénbaña luágu resíbi jamáali lan Samariána lerérun Búngiu, ába joúnajani Pédro lúma Juan ñi. ");
INSERT INTO cabNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Dan le jachǘlürünbei, ába jayúmuragun jawágu afíñetiña ja Samariána lun liábiba Sífiri Sándu jádoun, ");
INSERT INTO cabNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ladǘga miábingili lan Sífiri Sándu lídoun ni ában jádaangiñe, badíseirügügiña lídan líri Wabúreme Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ábati jíchuguni Pédro lúma Juan jájabu jawágu, ába liábin Sífiri Sándu jádoun. ");
INSERT INTO cabNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Dan le laríjinbei Simón luágu ñǘbin lan Sífiri Sándu jádoun gürígia dan le jíchuguni apóstolugu jájabu jawágu, ába lálugun lagáñijani ubáfu ligía jámagiñe láu seínsu. ");
INSERT INTO cabNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ába laríñagun joun. —Rújumei gíñe ubáfu le nun, lun dánme lan níchuguni nújabu luágu furúmieguárügü, lun gíñe lerésibiruni Sífiri Sándu. ");
INSERT INTO cabNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ábati laríñagun Pédro lun. —Beíba máfiougatin láu sun biseínsun, ladǘga jarítaguatibu luágu gayára lan lagáñijoún cátei le ledéweejan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Maríchatibu, mafánran bugúya lídan wesériwidun lun Búngiu, ladǘga múaraantu banígi ligíbugiñe Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ígirabeí buríban le, ayúmuraguabá lun Búngiu, lun ferúduna lánibu luágu luríban barítagun. ");
INSERT INTO cabNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ladǘga aríja numúti luágu buin tíña lan banígi láu wuríbani, áni ragǘñu liñálibu Máfia. ");
INSERT INTO cabNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ábati laríñagun Simón. —Ayúmuragua jumá lun Búngiu nuágu lun masúseredun lan ni cáta nun lídaangiñe le jaríñagubei. ");
INSERT INTO cabNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Lárigiñe jíchugun fe luágu Jesucrístu lúma jadímurejani lerérun Búngiu lídan fulásu ligía, ába japúrichijani apóstolugu ugánu buíti luáguti lasálbaruniña Jesucrístu gürígia lídaangiñe jafígoun lídan sarágu lirájüñü fulásu Samária, luágu jaweíyasun járigoún Jerusaléoun. ");
INSERT INTO cabNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Lárigiñe cátei le, ába laríñagun láni Wabúreme Búngiu ánjeli lun Felípe. —Aráansebá, beíba luágun sur lídaangiñe ǘma le arárirubei Jerusaléngiñe lun ubúrugun Gáza. Ligía ǘma le ásügürübei lídaangiñe fulásu mageírawati. ");
INSERT INTO cabNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ába laráanserun Felípe, ába lídin. Luágu leíbuguniwágu, ába ladárirun ában wügǘri Etiopíana lubá lubá. Wügǘri ligía siñáti garaǘ lan, ában wügǘri weíriguti, ligía gíñe gamánijaribei láu sun tiseínsun Candáce to lurúeite Etiopía. Liábiñati wügǘri ligía Jerusaléngiñe lárigi lídin ájuduragua lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Lagíribuduñáti lageíroun, ñun tídan ában cárü, alíijeinaloún lilíburun proféta Isaías. ");
INSERT INTO cabNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ábati laríñagun Sífiri Sándu lun Felípe. —Yaráfabá tuágun cárü túra. ");
INSERT INTO cabNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ába leíbaagun tuágun cárü, ába lagáambuni lalíijaña lan tídan lilíburun Isaías, ába laríñagun lun. —¿Gunfaráanda bumútisan le balíijabei? ");
INSERT INTO cabNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ába laríñagun wügǘri ligía lun. —¿Ída lubági gunfaráanda náani, úaga cába lan afúnraanguágüdei nun? Ába laríñagun lun Felípe lun ládinun lúmoun lun lañúurun loúbagiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Niján buri dimúrei le lalíijabei. Quei mudún, lanügǘwa lun lafarún jilágubei, ítara quei leréderun mudún maníñu jagíbugiñe ja ásarubalín líyu, ítara líña gíñe maríñagun lan ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ǘnabuti lanügǘn, áni michugúnwati lirícha lun, siñábei ladímurejoún jawágu ladǘgawagun, ladǘga gumúja lan labágaridun uboúagu. ");
INSERT INTO cabNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ába laríñagun wügǘri ligía lun Felípe. —Adǘgabeí fuleísei nun, aríñagabeí nun, ¿cáteisan le uágubei laríñagei wügǘri le abǘrüjabei dimúrei le, luoúgua, ódi luágu ámu? ");
INSERT INTO cabNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ábati lagúmeserun Felípe arúfudajei Lerérun Búngiu lun, lúmagiñe le ñígiñe lubeí lagúmesera alíija, ába líchuguni ugánu luáguti Jesúsu lun. ");
INSERT INTO cabNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Dánti le jásügürünbei lídaangiñe ában fulásu le ñí lubei dúna, ába laríñagun wügǘri ligía. —Nijántia dúna, ¿siñátisan nabásterun? ");
INSERT INTO cabNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Laríñaga Felípe lun. —Ánjein afíñe bubeí luágu Jesucrístu táu sun banígi, gayáraati babásterun. Laríñaga wügǘri ligía lun. —Afíñetina luágu Jesucrístu lan Liraǘbei Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ábati laráramagüdǘnun cárü, ába jarárirun biángubei jagía dúnarugún, ába labásterágüdüni Felípe. ");
INSERT INTO cabNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Dan jamúdeirun dúnarugugíñe, ába lanǘgüni láni Búngiu Espíritu Felípe ñígiñe, ába maríjin láali lan wügǘri ligía. Ába lasígiruni leíbugun, gúndaañu. ");
INSERT INTO cabNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ába ladáriragun Felípe lúngua Azóto, ába lídin lídaangiñeina fulásu apúrichijeinaleí ugánu luáguti Crístu darí lachǘlürün Cesaréa. ");
INSERT INTO cabNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sun dan ligía, merédeti lasíadiruniña Sáulo afíñetiña luágu Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ligía lídinbei lúmoun fádiri íñutimaati lídan jafíñen juríu amúriaja gárada láutu ubáfu lun lídin tídan buri jalígilisin juríu to Damáscoboun áluajaña ja afálarubalin lémeri Crístu lun lanǘgüniña adáüragua Jerusalén, dándu wügǘriña quei würíña. ");
INSERT INTO cabNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Luágu leíbuguniwágu, dan yaráfaali lun Damásco, sódini ába ladúnraagun ában larúgounga siélugiñe, geyégua láu. ");
INSERT INTO cabNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ábati láburujan Sáulo múarugún, ába lagáambun laríñagun ában umálali lun. —Sáulo, Sáulo, ¿ca uágu beíbaajana? ");
INSERT INTO cabNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ábati laríñagun Sáulo. —¿Cátabusan Nabúreme? Ába laríñagun umálali ligía. —Jesúsu áu, le méme beíbaajabei. ");
INSERT INTO cabNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sarába, belúba ubúrugun, laríñawagúba bun ñi cába lan badǘga. ");
INSERT INTO cabNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wügǘriña ja úarabaña lúma Sáulo lídan luweíyasun, ába jaráramun láu luweírin janígi ladǘga agáamba jamúti umálali, áni maríjin jamúti le adímurejabei. ");
INSERT INTO cabNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ába lásaarun Sáulo múarugugíñe, dan le léfegechúnbalin lágu, maríjinjali. Ábati járügüdüni lújabu, ába janǘgüni ubúrugun Damásco. ");
INSERT INTO cabNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ába leréderun ǘrüwa wéyu ñi maríjinga, meígin líña, mátun ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ñíñein ában afíñeti luágu Jesucrístu ñi Damásco gíriti Ananías, le únbei layáwadagua Wabúreme Jesúsu, ába laríñagun lun. —¡Ananías! Ába loúnabun. —Anája ya, Nabúreme. ");
INSERT INTO cabNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ábati laríñagun Jesúsu lun. —Beíba guetó guetó luágu ǘma le gíribei Surúti, danme le bachǘlürün lúbiñe Júdas, bálügüdajame luágu ában wügǘri Társona gíriti Sáulo. Badárirubei ñi ayúmuragua lun Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","áni ayáwadaguaali ában wügǘri gíriti Ananías lun, ába líchuguni lújabu luágu lun gayára lan laríjin. ");
INSERT INTO cabNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Dan lagáambunbalin Ananías cátei le, ába laríñagun. —Nabúreme, gíbeeñátia abájüdagutiña nun luágu wügǘri ligía lúma luágu sun wuríbani le ladáagubei joun ja afíñebaña buágu, Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Guetó, liábiña ñájoun láu ubáfu jámagiñe jábutigu fádirigu lun ladáüraguniña sun ja bánigubaña. ");
INSERT INTO cabNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ába laríñagun Jesúsu lun. —Beíba, ladǘga anúadira náali wügǘri ligía lun ladímurejan nuágu joun gürígia ja mámabaña juríu lúma joun jarúeitegu, lúma gíñe joun Israelítagu. ");
INSERT INTO cabNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Narúfudubei sarágu cátei le lúnbei lasúfuriruni nueígiñe lun. ");
INSERT INTO cabNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ábati lídin Ananías lídoun fulásu le ñí lubei Sáulo. Ába lebélurun múnadoun, ába líchuguni lújabu luágu, ába laríñagun lun. —Nidúje Sáulo, loúnajañadina Wabúreme Jesúsu le arúfudagubei lúngua bun luágu ǘma le ñígiñe lubeí biábin, lun gayáraaya lan baríjin, lun gíñe berésibiruni Sífiri Sándu. ");
INSERT INTO cabNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Lídan óra ligía, ába leíguadun camá jamuga arúraü lueígiñe lágu, ábaya laríjin. Lídan óra ligía, ába labásterún. ");
INSERT INTO cabNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Lárigiñe, ába leígin, ábaya lejéredun, ába leréderun átiri wéyu jáma afíñetiña ja aganoúbaña Damásco. ");
INSERT INTO cabNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ába lagúmeserun Sáulo apúrichija tídan buri jalígilisin juríu, laríñaga luágu Jesúsu lan Liraǘbei Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Súnti ja agáambubalín, ába laweíridun janígi, jaríñagati. —¿Másan niján wügǘri léñaja eíbaajabáliña ja afálarubalin Jesúsu Jerusalén? ¿Ma ligía méme le ñǘbinbei ya lun lanáanguniña adáüra, lun ledéregeruniña joun jábutigu fádirigu juríu? ");
INSERT INTO cabNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ábatimá lapúrichijan Sáulo láu anígi, arúfudei luágu Jesúsu lan Crístubei le lúnbei lasálbaruniña gürígia lídaangiñe jafígoun, darí lun labúlieidaguágüdün jáu juríu buri ja aganoúbaña Damásco. ");
INSERT INTO cabNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Lárigiñe sarágu wéyu, ába jelédegun juríu lun jáfaruni Sáulo jilágubei, ");
INSERT INTO cabNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ába lasúbudirawagüdün le jabúseerubei jadǘgün lun Sáulo. Wéyuagu, áriebu, jagúrabajanja juríu luágu béna le áfuridagülei le láni ubúrugu Damásco lun jáfaruni jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ába jíchuguni afíñetiña lídoun ában faníñe weíriti, ába jarárigüdǘni áriebu lueígiñe baríeru le geyégubei láu ubúrugu, ába leséfurun. ");
INSERT INTO cabNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Dan le lachǘlürünbei Sáulo Jerusalén, ába yebe lálugun ládaragun lúngua jádoun afíñetiña, sun jagía, janúfudetiña lueí, ladǘga mafíñetiñá yebe luágu afíñejali lan luágu Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ába lanǘgüni Bernabé jagíbugiñoun apóstolugu. Ába labájüdagun joun luágu laríjini Sáulo Jesúsu luágu leíbuguniwágu, lúma luágu ladímurejan Jesúsu lun, lúma luágu lapúrichijan Sáulo furáangu luágu Jesúsu ubúrugu Damásco. ");
INSERT INTO cabNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ábati jerésibiruni Sáulo queísi jánigu, ába leíbugun jáma Jerusalén, ");
INSERT INTO cabNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","apúrichijeina luágu Wabúreme Jesúsu furáangu. Lárigiñe ladímurejan luágu Jesúsu jáma juríu ja adímurejabaña güriégu, asígeneja ligía jáma, ába jabúseerun jáfaruni jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Dan le jasúbudirúnbalin afíñetiña cátei le, ába janǘgüni Sáulo ubúrugun Cesaréa, ñígiñe ába joúnajani Társoun. ");
INSERT INTO cabNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Lídoun buri dan ligía, buíti joúserúniwa afíñetiña luágu Jesucrístu ja aganoúbaña Judéa, Galiléa, lúma Samária. Ába jedérebugudún lídan jafíñen luágu Jesucrístu, falájamei le lubeíbei, resíbi jagía gurásu lúmagiñe Sífiri Sándu. Ába agánwoundeina jamá afíñerutiña. ");
INSERT INTO cabNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Dan le lebélujaña lubeí Pédro lídan buri fulásu lun líderaguniña ja afíñeñaabaña luágu Jesucrístu, ába gíñe lídin aríjaña lánigu Búngiu ja ubúrugubaña Lída. ");
INSERT INTO cabNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ñi ladárira ában wügǘri gíriti Enéas, wídü irúmu láu gabánarugu láu derégüdaü. ");
INSERT INTO cabNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ába laríñagun Pédro lun. —Enéas, areídaguagüda lumútibu Jesucrístu. Sarába, aráanseboún bigábana. Ába lásaarun Enéas óra ligía. ");
INSERT INTO cabNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ába jaríjini sun ja aganoúbaña fulásu buri Lída lúma Sarón, ába jígiruni binádu jafíñen, ába jafíñerun luágu Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Lídan meja dan ligía, ñíñoun meja ában afíñetu aganoútu Jópe, gíritu Tabíta, lídan jerérun güriégu, gíritu Dórcas. Wǘri tugúya, súnwandan táu adǘga buíti, íderagua tugúya gudémetiña. ");
INSERT INTO cabNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lídoun dan ligía, ába tasándirun Dórcas, ába toúnwen, lárigiñe jágawagüdünun, ába jaríwachaguagüdünun. ");
INSERT INTO cabNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yaráfati Jópe lun Lída le ñí lubei Pédro, queíti jagáambuni afíñetiña luágu níjein lan ñi, ába joúnajan bián wügǘriña aríñaga lun. —Queímoun Jópe, oúfuda. ");
INSERT INTO cabNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ábati lídin Pédro jáma. Dan le lachǘlürünbei, ába janǘgüni tídoun rúmu to ñí tubei jiláaru, ába jagúriridágun sun würíña ja jiláguaañábaña úmari láu, ayájuaja tárigi, arúfudajoún buri dínugu túma simísi tó buri tájüchaguboún Dórcas dán meja moúnwengiru, lun. ");
INSERT INTO cabNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ába láfuridagüdǘniña Pédro sun ja ñíbaña, ába lájuduragun, ába layúmuragun lun Búngiu. Ábati laríjin tuágun jiláaru, ába laríñagun tun. —Tabíta, sarába. Ábati téfegechuni tágu, dan taríjini Pédro, ába tiñúragun túngua. ");
INSERT INTO cabNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ába lárügüdüní tújabu, ába lásaaragüdǘnun. Lárigiñe, ába lagúarun joun würíña jagía jáma jíbiri afíñetiña ja ñíbaña, ába larúfudunun joun, wínwañu. ");
INSERT INTO cabNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ába lagaambún cátei le lídan sun ubúrugu Jópe, ába sarágu jamá afíñerutiña luágu Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ába leréderun Pédro sarágu dan lídan ubúrugu ligía, lúbiñe Simón le aráansejabei úraü. ");
INSERT INTO cabNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ñíñein ában wügǘri ubúrugu Cesaréa gíriti Cornélio, gumándan joun súdaara ja Italiána. ");
INSERT INTO cabNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wügǘri ligía jáu sun lufámilian, derégeguatiña joúngua lun Búngiu, judúguatiña lun Búngiu láu sun máma jamá juríu. Rúti buri gíñe sarágu seínsu lun jíderawagún juríu, áni súnwandan layúmuragun lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Luágu ában wéyu, queí buri ladaǘnrün ǘrüwa rábounwéyu, ába lasáliragun ában láni Búngiu ánjeli lun, furáangu, ába laríñagun lun. —¡Cornélio! ");
INSERT INTO cabNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ába leréderun Cornélio aríaguei ánjeli ligía láu sarágu anúfudei, ába laríñagun. —¿Ca babúseerubei, Nabúreme? Ába laríñagun ánjeli ligía lun. —Agáamba láali Búngiu bayúmuragun, aríjaleí buri cátei le badǘgübei lun bíderaguniña gudémetiña. ");
INSERT INTO cabNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Oúnajabá lubeíti wügǘriña ubúrugu Jópe lun joúguni Simón, le gíñe gíribei Pédro, lun liábin bun. ");
INSERT INTO cabNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Lúbiñe Simón le aráansejabei úraü, le gábanbei láru barána. ");
INSERT INTO cabNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Dan le ñǘdünjali ánjeli le adímurejabei lúma Cornélio, ába lagúarun joun biáma jádaangiñe lumúsuniña lúma ában lisúdaaran, súdaara ligía, ában wügǘri derégeguati lúngua lun Búngiu, leménigira Cornélio. ");
INSERT INTO cabNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ába labájüdaguni sun cátei joun, ába loúnajaniña ubúrugu Jópe. ");
INSERT INTO cabNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Larúgan amídirugu, sun ayárafadeina jamá wügǘriña ja lun Jópe, ába lamúdeirun Pédro luágun tábulugu múna le fadábei, ayúmuragua lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Weírijaliti liláma óra ligía, busénjali leígin. Dan le añája lan aráanserei leígin, ába lasáliragun ában cátei lun ítara. ");
INSERT INTO cabNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","aríja lumúti lánjunrenchun siélu, ába tiábin ában cátoun camá jamuga gamísa weíritu gürágu lueígiñe gádürü tarígei, tiábin arárireina múarugun. ");
INSERT INTO cabNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tídan gamísa tugúya, ñíñanu sun jawúyeri anímaalu, gádürügua tugúdi, jéwe, jáma dunúru. ");
INSERT INTO cabNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ábati lagáambun laríñagun ában umálali lun. —Sarába Pédro, áfarabá jádaangiñe anímaalu ja lun beígin. ");
INSERT INTO cabNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ába loúnabun Pédro. —Uá, Nabúreme, meígiñajágidina ni cáta le wanǘgübei quei mabuídunti según lilúrudun Moisés. ");
INSERT INTO cabNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ábayati ladímurejan umálali ligía lun, ába laríñagun lun. —Le cátei le labuíduragüdün Búngiu, maríñagabá luágu luágu mabuídun lan. ");
INSERT INTO cabNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ǘrüwañein weíyaasu lasúseredun cátei le, lárigiñe, ábaya tamúdeirun gamísa tugúya siélun. ");
INSERT INTO cabNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Súnti niján lan Pédro láu luweírin arítaguni luágu, asáminara ca lan laníchigubei cátei le laríjubei, ligía jachǘlürün luwǘgüriñan Cornélio, álügüdajeína tuágu lúban Simón. ");
INSERT INTO cabNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Dan jachǘlürün tubéneri múna, ába jálügüdajan rein ánjein ñí lubei lagánawa ában gíriti Simón le gíñe únbei jaríñaga Pédro. ");
INSERT INTO cabNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Queíti buga nijágua lan Pédro asáminara luágu cátei le asáliragubei lun, ába laríñagun Sífiri Sándu lun. —Añája ǘrüwa wügǘriña álugabu, ");
INSERT INTO cabNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","raríba, oúfudabá, beíba jáma láu afíñeni ladǘga áu lan oúnajabalíña. ");
INSERT INTO cabNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ábati larárirun Pédro le ñíjin jabeí wügǘriña ja loúnajabaña Cornélio, ába laríñagun joun. —Áu le jáluajabei. ¿Ca gabǘgürübalün? ");
INSERT INTO cabNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ába jaríñagun. —Loúnajan gumándan le gíribei Cornélio wagía, ában wügǘri surúti, derégeguati lúngua lun Búngiu, jínsiñeti joun sun juríu. Ñǘbinti ában ánjeli aríñaga lun lun loúnajan oúgabu lun bídin lúbiñe, lun lagáambuni le lúnbei baríñaguni lun. ");
INSERT INTO cabNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ábati lebélaagüdüniña Pédro, ába jeréderun lúma ñi áriebu ligía. Larúgan, ába lídin Pédro jáma, ñǘdüntiña gíñe jádaangiñe afíñetiña ja aganoúbaña Jópe jáma. ");
INSERT INTO cabNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Larúgan, ligía jachǘlürün Cesaréa, le ñí lubei Cornélio agúrabajaña jáu lidújeñu jáma jabuídun-ágei lumádagu ja lamísurajabaña. ");
INSERT INTO cabNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Dan lachǘlürün Pédro, ába láfuridun Cornélio erésibirei, ába lájuduragun ligíbugiñe láu sarágu inébesei. ");
INSERT INTO cabNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ába liñúraguni Pédro, ába laríñagun lun. —Ráramabá, wügǘri giñe áu bíledi. ");
INSERT INTO cabNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Súnti niján lan adímureja lúma, ába lebélurun, ába ladárirun sarágu gürígia adámuriñu ñi. ");
INSERT INTO cabNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ábati laríñagun Pédro joun. —Subúsi jumúti luágu mája lan wafíñen wagía juríu lun joúndaragun juríu jáma ja mámabaña juríu quei jugúya, ni lun webélurun tídoun jában lueí wasálirun mabuídunga ligíbugiñe Búngiu. Wel, arúfuda láali Búngiu nun luágu mabúseerun lan lun noúseruniña ja mámabaña juríu queísi gürígia mabuíduntiña. ");
INSERT INTO cabNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ligía nánjanrunbei niábin dan le boúnajanbei nuágu. Buséntina jamúgati nasúbudiruni ca lan lébubei joúnajan nuágu. ");
INSERT INTO cabNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ábati loúnabun Cornélio. —Ǘrüwa wéyu guetó, queíburi óra le, ñáñadina núbiñe ayúmuragua lun Búngiu ladaǘrün ǘrüwa rábounwéyu, queísi wéchun, ligía lasáliragun ában wügǘri nun táu ában dáüguaü mirítu. ");
INSERT INTO cabNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ába laríñagun nun. “Cornélio, agáamba láali Búngiu bayúmuragun, jarítaguaaliti luágu buri cátei le badǘgübei lun bíderaguniña gudémetiña. ");
INSERT INTO cabNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Oúnajabá lubeíti wügǘriña ubúrugu Jópe oúgei Simón le gíñe gíribei Pédro, lúbiñe ábanya Simón aráansejati úraü, le gábanbei láru barána, ñi lagánawa.” ");
INSERT INTO cabNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ába lubeíti noúnajan oúgabu furése, áni buítiti badǘga biábin. Guetóti awánja sun wagía ya ligíbugiñe Búngiu, buséntiwati wagáambuni le laríñagubei Wabúreme Búngiu bun lun baríñaguni woun. ");
INSERT INTO cabNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ábati lagúmeserun Pédro adímureja, ába laríñagun. —Subúdi náali guetó luágu ában lan lábu lanǘgüniña Búngiu sun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Resíbirügü lumútiña sun ja inébejabúbaña lun áni adǘga jameí le buídubei, dándu juríu quei ja mámabaña juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Adímurejati Búngiu joun ladǘgawagun Israél, adímurejeina ugánu luáguti gayára lan jaráandarun gürígia luma Búngiu lídaangiñe Jesucrístu, le Jabúremebei sun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jugúya, subúdi jumúti cátei le asúseredubei jageíra juríu buídu, le agúmeserubei Galiléa lárigiñe lapúrichijan Juan, áni abásteragüdaja ligía. ");
INSERT INTO cabNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Subúdi jumúti luágu rúlaani Búngiu lubáfu Sífiri Sándu lun Jesúsu Nazarétna, luágu meja gíñe ladáagun buíti, lúma lareídaguagüdüniña ja asúfurirubaña lábugiñe lubáfu Máfia. Ladǘgünbalin buri meja cátei le, ladǘga ñíñein lan Búngiu lúma. ");
INSERT INTO cabNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Wagía geféentiwa luágu sun cátei le ladǘgübei Jesúsu Jerusalén lúma lídan sun líbiri jageíra juríu. Lárigiñe, ába jáfaruni jilágubei láu jádaraguní luágu ában gurúwa. ");
INSERT INTO cabNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Sarágüda lumúti Búngiu lídaangiñe oúweni luágu lǘrüwan wéyu, ába larúfudaguágüdüni lúngua wínwañu woun. ");
INSERT INTO cabNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Marúfudagúnti lúngua joun sun gürígia, lueídügüya woun, wagía le anúadaja láañabaña Búngiu lúmagiñe binárü quei geféentiña luágu lásaarun lídaangiñe oúweni. Joútiwa lúma, gurá wagía lúma lárigiñe lásaarun lídaangiñe oúweni lúnya labágaridun. ");
INSERT INTO cabNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ába loúnajaniwa apúrichija joun gürígia luágu, lun giñe waríñaguni luágu rúlaali lan Búngiu Jesúsu méme le lun lagúseragüdüniña ja wínwangiñabaña jáma ja jiláguaañábaña dánme le lagíribudun uboúagun. ");
INSERT INTO cabNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Adímurejaaña meja gíñe sun profétagu luágu Jesúsu lúmagiñe binárü, luágu sun lan ja afíñebaña luágu, resíbi jamáni ferúdun luágu jafígoun. ");
INSERT INTO cabNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ñígili Pédro adímureja, ligía liábin Sífiri Sándu jádoun ja agáambajabalin ladímurejan. ");
INSERT INTO cabNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Játi juríu ja afíñetiña luágu Jesucrístu ja ñǘbinbaña úara lúma Pédro, ába laweíridun janígi láu liábin Sífiri Sándu jádoun ja mámabaña juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Agáamba jamútiña adímureja dimúrei le mámabei jerérun, adímureja jagía luágu luweírigun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ábati laríñagun Pédro. —¿Majoúabei funági lun jabásterún gürígia ja, quei resíbi jamáali lubeí Sífiri Sándu queígubeirügü wagía? ");
INSERT INTO cabNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ába líchugun dimúrei lun jabásterun lídan líri Jesucrístu. Lárigiñe, ába jayúmuragun lun Pédro lun leréderun átiri wéyu jáma. ");
INSERT INTO cabNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ába jagáambuni apóstolugu jáma jíbiri afíñetiña ja Judéabaña luágu ánjaaña lan gíñe ja mámabaña juríu lun láni Búngiu ugánu luáguti Wasálbaragüle, Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Dánti le lagíribudun Pédro Jerusaléoun, ába jachúrajani juríu ja afíñetiña, ");
INSERT INTO cabNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","jaríñaga. —¿Cámesan bídin aríjaña ja mámabaña juríu, áni jou amǘrü jáma? ");
INSERT INTO cabNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ábati labájüdaguni Pédro sun le asúseredubei joun lúmagiñe lagúmeseja, ába laríñagun. ");
INSERT INTO cabNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Ubúruguñadina Jópe, ayúmuragua lun Búngiu, ligía naríjin ában cátei lasáliragun nun camá jamuga ában gamísa weíritu tarárirun siélugiñe, gürágu lueígiñe gádürü tarígei, tiábin chülǘ le ñí nubei. ");
INSERT INTO cabNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Dan le naríjin tuágun buídu lun naríjin ca lan tídaanbei, ába naríjin anímaalugu gádürügua tugúdi ñi, anímaalugu gáñitiña, jéwe, jáma dunúru. ");
INSERT INTO cabNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ába nagáambun laríñagun ában umálali nun. “Sarába Pédro, áfarabá jádaangiñe, joúbei.” ");
INSERT INTO cabNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ába naríñagun. “Uá, Nabúreme, ladǘga meígiñajágidina ni cáta le wanǘgübei quei mabuídunti según lilúrudun Moisés.” ");
INSERT INTO cabNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ábayati ladímurejan umálali siélugiñeti ligía nun, laríñaga nun. “Le cátei le labuíduragüdün Búngiu, maríñagabá luágu luágu mabuídun lan.” ");
INSERT INTO cabNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ǘrüwañein weíyaasu lasúseredun cátei le, lárigiñe, ábaya tamúdeirun siélun. ");
INSERT INTO cabNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Lídan óra ligía, ligía jachǘlürün ǘrüwa wügǘriña tídoun múna to ñí nubei, oúnajoútiña Cesaréagiñe álugana. ");
INSERT INTO cabNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ába laríñagun Sífiri Sándu nun lun nídin jáma láu afíñeni. Ñǘdüntiñá giñe sísi afíñetiña ja núma. Dan wachǘlürün Cesaréa, ába webélurun sun wagía lúbiñoun ában wügǘri, ");
INSERT INTO cabNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","le abájüdagubei woun luágu nege laríjin ában ánjeli rára lúbiñe, ába lán nege laríñagun ánjeli ligía lun. “Oúnajabá wügǘriña lun joúdin ubúrugu Jópe oúgei Simón le gíñe gíribei Pédro, ");
INSERT INTO cabNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","laríñagubei bun ída lúba lan gayára lan basálbarun jáu sun bufámilian.” ");
INSERT INTO cabNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Dan nagúmeserúnbei adímureja joun, ába liábin Sífiri Sándu jádoun queí meja liábin wádoun furúmiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ábati narítagun luágu lé meja laríñagunbei Wabúreme. “Inárüni luágu badíseigüda lan Juan láu dúna, ánjein Búngiu, labásteragüdübadün láu Sífiri Sándu.” ");
INSERT INTO cabNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ánjeinti ru lubálin Búngiu líbe le líchubei woun, wagía le afíñeelibei luágu Jesucrístu, joun, ¿cátanañadináti lun neréderubei lan le labúseerubei Búngiu ladǘga? ");
INSERT INTO cabNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Dánti le jagáambuni afíñetiña ja Jerusalénbaña cátei le, ába jámanichun. Ába jadímurejan luágu luweírigun Búngiu, ába jaríñagun. —¡Rújali lubeí giñéti Búngiu ubáfu joun ja mámabaña juríu lun jasáansiruni jagáburi, lun gayára lan jabíjin ibágari magúmuchaditi! ");
INSERT INTO cabNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Dan le láfarúnbei Estéban, ába gíñe jagúmeserun eíbaajaña ja jíbiri afíñetiña, ába janúrajan jíbiri chülǘ Fenícia, Chípre, luma Antioquía. Ñi jíchigei ugánu luáguti lasálbaruniña Jesucrístu gürígia lídaangiñe jafígoun joúnrügü juríu, máma joun ámu gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ánjeinti afíñetiña ja Chíprena jáma Cirénena, ába jachǘlürün Antioquía, ába gíñe jadímurejan joun ja mámabaña juríu, ába jíchuguni ugánu luáguti Wabúreme Jesucrístu joun lun jasálbarun. ");
INSERT INTO cabNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ñíñein lubáfu Búngiu jáma afíñetiña jagía, sarágu ja mámabaña juríu, ába jígiruni binádu jafíñen, ába jafíñerun luágu Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Dan lachǘlürünbei ugánu le lábun jagáambun afíñetiña ja Jerusalénbaña, ába joúnajani Bernabé Antioquíoun. ");
INSERT INTO cabNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Dan lachǘlürünbei Bernabé, ába laríjini luágu binílaaña lan Búngiu gürígia ja mámabaña juríu, ába lagúndaarun sarágu. Ába labímejaniña súngubei lun jafálaruni Wabúreme Búngiu táu sun janígi. ");
INSERT INTO cabNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé, ában meja wügǘri buíti, derégeguati lúngua lun Sífiri Sándu le gumúti, buin líña gíñe láu afíñeni luágu Jesucrístu, ítara liña lagáñeirun sarágu gürígia lun Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Lárigiñe, ába lídin Bernabé Társo áluajei Sáulo, dan ladáriruni, ába lanǘgüni Antioquíoun. ");
INSERT INTO cabNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ába jeréderun ñi jáma tílana ligílisi ában irúmu, arúfudaja joun sarágu gürígia. Ñí Antioquía lagúarúa joun afíñetiña “Cristiánugu” furúmiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Lídan dan ligía, ába joúdingua já buri profétagu Jerusaléngiñe lun Antioquíoun. ");
INSERT INTO cabNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ában jádaangiñe, gíriti Ágabo, ába laráramun jádan afíñetiña, ába laríñagun láu le lasúbudirágüdübei Sífiri Sándu lun luágu liábiba lan ában oúnwenbun ilámaü lídan sun uboú, áni suséreti lídan lidáani larúeijan Cláudio. ");
INSERT INTO cabNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ábati joúndaragun afíñetiña ja Antioquíana lun joúnajan seínsu joun afíñetiña ja Judéabaña según le jayáraati íchiga. ");
INSERT INTO cabNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ítara líña jadǘgüni, ába joúnajani seínsu ligía lúma Sáulo joun tábutigu jalígilisin afíñetiña Judéana. ");
INSERT INTO cabNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lídan dan ligía, ába lagúmeserun urúei Heródes eíbaajaña jádaangiñe afíñetiña. ");
INSERT INTO cabNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ába láfaragüdǘni Jacóbo le lamúlen Juan táu efeín, ");
INSERT INTO cabNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","queíti laríjin láu gúnda jamá juríu láu cátei le, ába gíñe lanǘgüni Pédro adáüra. Lídan buri wéyu le fédu le ídaanbei teigúa fein magánatu ísi lasúsereda cátei le. ");
INSERT INTO cabNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Lárigiñe lanǘgüni Heródes Pédro adaǘra, ába ládaruni furísunrugun jáu díisi-sísi súdaaragu oúnigira gádürü gádürü, larítagun lún yebe laságaruni jagíbugiñe lílana fulásu lárigiñe fédu lun lagúserun. ");
INSERT INTO cabNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ñíñein lubeíti Pédro furísunrugu toúnigiwañu buídu, merédeti jayúmuragun tílana ligílisi lun Búngiu luágu. ");
INSERT INTO cabNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Áriebu le lubáragiñe wéyu lé yebe lúnbei laságaruni Heródes Pédro jagíbugiñoun gürígia, larúmuguña Pédro jamídaangua bián súdaara, gürágu ligía láu bián güríngüri, jámaya bián súdaara luágu béna oúnigira. ");
INSERT INTO cabNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sódini, ligía lasáliragun ában láni Wabúreme ánjeli, ába larúgoungadún furísunrugu. Ába lagúuruni ánjeli ligía loúbawagu, ába lagáguduni, ába laríñagun lun. —Sarába furése. Ábati láburujan güríngüri lueígiñe lújabu Pédro, ");
INSERT INTO cabNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ába laríñagun ánjeli ligía lun. —Murúbei bubélitin, daǘbounme bigeídin. Lárigiñe ladǘgüni Pédro sun líra, ába laríñagun ánjeli ligía lun. —Daǘboun babíte, falábana. ");
INSERT INTO cabNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ába láfuridun Pédro lárigi ánjeli ligía, ibídiñoun lun ánjein inárüni lubeí lúmoun máma lan inárüni cátei le ladǘgübei ánjeli ligía. Genégetimáati lun camá gewénediñein. ");
INSERT INTO cabNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ába jásügürün jáu furúmiñetiña oúnigirutiña, sügǘ jamaña jabíaman, dánti le jachǘlürün luágun béna le gürábu le ǘmadagiñebei, ába lánjunrenchun lúngua. Ába jáfuridun, lárigiñe jánjiñuragún ában ǘma, ába lígiruni ánjeli ligía Pédro lábugua. ");
INSERT INTO cabNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ligíaali lárügüdagun Pédro lúngua, ába laríñagun. —Aná guetó, subúdi náali luágu oúnaja láali lan Búngiu ánjeli lun leséfurunina lueí Heródes lúma lueí sun lé yebe jabúseerubei juríu jadǘgün náu. ");
INSERT INTO cabNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Asáminareína ligía Pédro luágu cátei le, ába lídin túbiñoun María to lúguchu Juan Márcos, le ñí jabei sarágu gürígia adámuriñu ayúmuragua lun Búngiu luágu. ");
INSERT INTO cabNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Dan lacaǘjan luágu lubéneri bürǘrü, ába táfuridun ában irájü músu, gíritu Róde, aríja ca lan agúajabei. ");
INSERT INTO cabNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Dan tasúbudiruni luágu Pédro lan luágu lumálali, bulíei tumúti tánjunrenchuni béna, le luweírin tugúndan, ábarüga teíbaagun múnadoun awísaja luágu niján lan Pédro bénabu. ");
INSERT INTO cabNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ábati jaríñagun tun. —¡Lǘlüjaali báu! Ába taríñagun joun luágu choúru tan luágu ligía lan. Ába jaríñagun. —Máma ligía, fágua láfurugu. ");
INSERT INTO cabNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Niján mémeti Pédro acaǘnja luágu béna. Dan jánjunrenchuni, ába laweíridun janígi dan le jaríjini. ");
INSERT INTO cabNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ába líchugun seíni joun láu lújabu lun jámanichun, ába labájüdaguni joun ída líña lan laságaruni Búngiu furísunrugúgiñe, lárigiñe, ába laríñaga joun. —Abájüdagua jumeí cátei le lun Jacóbo lúma joun jíbiri afíñetiña. Ábati láfuridun, ába lídin lídoun ámu fulásu. ");
INSERT INTO cabNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Dan larúgadunbei, niján luwúyerigu samínaü jádan súdaara, ladǘga ibídiñeti joun ca lan susérebei lun Pédro. ");
INSERT INTO cabNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ába loúnajan Heródes áluajei, quei madári jamáni, ába lálügüdaguniña súdaara já buga oúnigirubalin, lárigiñe, ába láfaraguágüdüniña jilágubei. Lárigiñe, aba láfuridun Heródes Judéagiñe, ába lídin agánawa Cesaréa. ");
INSERT INTO cabNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Weíriti ligáñi Heródes jáma gürígia ja aganoúbaña Tíro lúma Sidón, ánjein jagía, ába jebélurun lídoun ában arítaguni lun joúnajan wügǘriña lun jadímurejan lúma luágu jafúleisein. Dan le jachǘlürün, ába jagáñeiruni Blásto, ában wügǘri íñuguti láni Heródes, lun líderaguniña adílijei sun cátei, ladǘga lageíragiñe Heródes jabíja eígini. ");
INSERT INTO cabNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ába lagúaragüdǘn Heródes jawágu luágu ában wéyu, wéyu ligía, ába ladáürunun lanáangun to lanáangun urúei, ába lañúurun luágu lála le ñígiñe lubeí lagúmadija, ába ladímurejan joun. ");
INSERT INTO cabNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ábati jagúmeserun gürígia agúaraja. —¡Máma wügǘri adímurejabei, búngiu adímurejabei! ");
INSERT INTO cabNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Lídan óra ligía, ába lasándiragüdǘni láni Búngiu ánjeli Heródes, ladǘga lanáangun lúngua luágu jerérun gürígia, míchu lumúti linébese Búngiu lun, ába jeígini jéweraü, ába loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Abúruchagueínatimá ligíati ugánu le láni Búngiu, apúrichijoúati lídan sun fulásu. ");
INSERT INTO cabNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Dan jagúmuchuni Bernabé lúma Sáulo jawádigimari, ába jagíribudun Jerusaléngiñe barüína jameí Juan Márcos jámagua. ");
INSERT INTO cabNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Tídan ligílisi to Antioquíaboun, ñíñanu profétagu jáma maésturugu. Wügǘriña jagía. Bernabé, Simón, le únbei jaríñaga Wuríti, Lúcio le Cirénena, Manaén le agǘriarúbei úara lúma Heródes le gumádimati Galiléa, lúma Sáulo. ");
INSERT INTO cabNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Luágu ában wéyu dan le jájuduragun lun Búngiu, ayúnara jagía, ába laríñagun Sífiri Sándu joun. —Dírei jumeí Bernabé lúma Sáulo nun lun wadágimanu le únbei nanúadiraña. ");
INSERT INTO cabNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Lárigiñeti jayúmuragun lúma jayúnarun, ába jíchuguni jájabu jawágu Bernabé lúma Sáulo, ába joúnajaniña luágu jawádigimari. ");
INSERT INTO cabNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ítara líña loúnajaniña Sífiri Sándu Bernabé lúma Sáulo, ába joúdin Seléucia, ñígiñe, jádina lun joúdin luágun uboúju le Chípre. ");
INSERT INTO cabNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Dan jachǘlürün lídan ubúrugu le gíribei Salamína, líbiri méme Chípre, ába jagúmeserun apúrichijei lerérun Búngiu tídan jalígilisin juríu. Ñǘdünti gíñe Juan Márcos jáma, íderaguaaña. ");
INSERT INTO cabNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Eíbuga jamúti sun uboúju ligía chülǘ lúmoun fulásu le gíribei Páfos. Ñi jadárira ában juríu gíriti Barjesús, garíyajati wügǘri ligía, ye ligía, laríñaga luágu proféta lan. ");
INSERT INTO cabNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Garíyajati ligía lúmañein gumádimati le Sérjio Páulo, ában wügǘri janíchiguti. Ába loúnajan gumádimati ligía luágu Bernabé lúma Sáulo ladǘga busén lan lagáambuni lerérun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ánjein garíyajati ligía, le méme gíribei Elímas, sigéne lumútiña lueí yebe lafíñerun gumádimati luágu le jaríñagubei lun luágu Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sáuloti, le méme gíribei Páblo, buin líña láu lubáfu Sífiri Sándu, ába laríaguni Elímas, ");
INSERT INTO cabNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ába laríñagun lun. —¡Yéetibu, buin bíña láu wuríbani, liraǘ Máfia amǘrü, lágani sun le buídubei! ¿Ca uágu meréde lubeí beyéejan luágu lémeri Búngiu le surúbei? ");
INSERT INTO cabNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Guetó láburuja ligáñi Búngiu buágun, berédera maríjinga luágu átiri dan. Lídan óra ligía, ába labúrigadún láu, ába láluajan cába lan árüjei lújabu, ladǘga maríjinjali lan. ");
INSERT INTO cabNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Dan laríjini gumádimati cátei le, ába lafíñerun luágu Jesucrístu, weíriti lanígi láu le jarúfudajabei luágu Wabúreme Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ába láfayarun Páblo jáma líbirigu Páfosgiñe lun ubúrugun Pérge, le lídaanbei fulásu gíriti Panfília. Ánjein Juan Márcos, ába lígiruniña, ába lagíribudun Jerusaléoun. ");
INSERT INTO cabNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lárigiñe, ába jásügürün Pérgegiñe lun ubúrugun Antioquía, le lídaanbei Pisídia. Ába jebélurun lídan wéyu le eméraaguagülei tídoun jalígilisin juríu, ába jañúurun ñi. ");
INSERT INTO cabNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Lárigiñeti taliijoúniwa líburu to lánina lilúrudun Moisés túma buri líburu to jabǘrüjaboun profétagu, ába joúnajan ábutigu aríñaga joun. —Wadújeñu, ánjein níjein lubeí dimúrei lun jaríñaguni joun gürígia ja, aríñaga jumeí guetó. ");
INSERT INTO cabNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ábati lásaarun Páblo, ába ladǘgün seíni joun láu lújabu lun jámanichun, ába laríñagun. —Agáamba jumá, wügǘriña Israelítagu júma jugúya le ájuduragubei lun Wabúngiute. ");
INSERT INTO cabNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Búngiu le Jabúngiute Israelítagu, anúadaja lumútiña meja binádu wagǘbürigu lun lánigubaña lan, ába ladǘgüniña ábanme oúnwenbun násiñun dán meja le añájagua lan agánawa quei teréncha Ejípto, lárigiñe, ába laságaruniña lídaangiñe fulásu ligía láu lubáfu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Awánda lumúti Búngiu luríban jagáburi lídan fulásu mageírawati queí buri bián-wein irúmu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Lárigiñe, ába lagúmuchaguagüdüni sédü násiñun ja aganoútiña Canaán lun líchuguni jafúlasun joun binádu wagǘbürigu luára gádürü-san-dimí irúmu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Lárigiñe, ába líchugun gürígia lun jagúseragüdüniña darí lúmoun lidáani proféta Samuél. ");
INSERT INTO cabNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ábati jamúriajan ában urúei lun ligíaba lan agúmadiraña, ába líchuguni Búngiu Saúl joun jarúeiteme luágu bián-wein irúmu, Saúl ligía, liraǘ Cis, ladǘgawagun Benjamín. ");
INSERT INTO cabNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Lárigiñe, ába lagídaruni Búngiu arúeijani lueí Saúl, ába líchuguni lun Davíd, le uágubei laríñaga. “Darína Davíd, liraǘ Isaí, ában wügǘri le áubei nagúndaara, áni ladǘgübei sun le nabúseerubei.” ");
INSERT INTO cabNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jádaangiñe ladǘgawagun Davíd ligía liábin Jesúsu le loúnajabei Búngiu lun jasálbarun Israelítagu, queí meja laríñaguni. ");
INSERT INTO cabNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Lubáragiñebei liábin Jesúsu uboúagun, apúrichijati Juan joun sun Israelítagu, laríñaga joun luágu lúnti lan jasáansiruni jagáburi, badísei jagíame. ");
INSERT INTO cabNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Dan le layárafadúnbei dan lun loúnwen Juan, ába laríñagun. “Mámatia áu le uágubei jarítagua luágu áu lan, liábiba ában nárigi, ni cáta áu loúbagiñe, madǘnatina ni íbini lun nafáragadunun ligeídin.” ");
INSERT INTO cabNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","‘Nidújeñu, jugúya le jarájüñübei ladǘgawagun Abrahám, júma jugúya le mámabei ladǘgawagun Abrahám, inébejabutün lun Búngiu. wagía gürígia ja únbaña loúnajoúa ugánu le luáguti Wasálbaragüle. ");
INSERT INTO cabNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Já meja gürígia ja aganoúbaña Jerusalén jáu sun jábutigu, ibídiñetí yébe joun ca lan Jesúsubei, úa ligía gunfaráanda jamáni jerérun profétagu, láu sun aliijoúa lan jerérun tídan jalígilisin ságü luwéyuri eméraaguni, jagía guánarügüti gúnfuli jamúti le bürǘwañubei láu jasíadiruni Jesúsu lun loúnwen. ");
INSERT INTO cabNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Láu sun madári jamá lidúnrun Jesúsu lun gayára lan jáfaruni jilágubei, amúriajatiña lúma Piláto lun láfaragüdǘni jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Dánti le adǘga jamáali sun le taríñagubei Lerérun Búngiu luágu, ába jarárigüdǘni lueígiñe gurúwa, ába jíchuguni lídoun lumúaja. ");
INSERT INTO cabNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ába lásaaragüdüni Búngiu lídaangiñe oúweni lúnya labágaridun. ");
INSERT INTO cabNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Arúfudaguati Jesúsu lúngua wínwañu luágu sarágu weíyaasu joun ja ñǘbinbaña lúma luágu luweíyasun Galiléagiñe lun Jerusaléoun, jagíati geféenbaña luágu joun gürígia guetó. ");
INSERT INTO cabNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","‘Wíchiguñein lubeíti ugánu le jun, luágu darádu lé meja ladǘgübei Búngiu jáma binádu wagǘbürigu ");
INSERT INTO cabNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","gúnfuli láali woun, wagía le jadǘgawagun, láu lásaaragüdüni Jesúsu, quei laríñaguni tídan lilíburun, lídan libíaman Sálmo. “Niraǘ amǘrü, rúnaali ubáraü le bun ugúñe.” ");
INSERT INTO cabNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Aríñaga láali meja Búngiu luágu lásaaragüdüni Jesúsu lídaangiñe oúweni lun mañáladun lan lúgubu, dan laríñagun tídan líburu to Lerérun. “Níchugubei abíniruni le uágubei naríñaga lun Davíd bun, gayáraati beménigidun luágu.” ");
INSERT INTO cabNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Laríñaga gíñe Davíd lídan ábanya Sálmo. “Mígirunbadibu lun lañáladun lúgubu Biraǘ le jínsiñebei bun.” ");
INSERT INTO cabNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davíd, seríwiti méja joun ja lánina lidáani quei laríñaguni Búngiu lun, lárigiñe, ába loúnwen, ába labunún le ñí lubei jabunúa lagǘbürigu, ába lañáladun lúgubu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ánjeinti Jesúsu, sarágüda lumúti Búngiu lídaangiñe oúweni, mañáladunti lúgubu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nidújeñu, lúnti lubeíti jasúbudiruni luágu lídaangiñe lan Jesúsu ferúdunawa lan wafígoun. Ligía ugánu wanǘgübei jun. ");
INSERT INTO cabNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Lídaangiñeti gíñe, chibáwaali lubeí sun wafígoun, sun wagía le afíñebei luágu, gidáwa ligía wadúnrun ligíbugiñe Búngiu, cátei lé meja siñá lubei lilúrudun Moisés adǘga. ");
INSERT INTO cabNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Toúnigi jumá lubeíti lueí láburujan ligáñi Búngiu juágun queísi jaríñaguni profétagu dan le jaríñagunbei. ");
INSERT INTO cabNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Jugúya le éjerajabei náu, weírilá janígi, áni gumúgua jumá, ladǘga áu le Búngiubei, nadǘgüba cátei weínamuburiti, daríme lun mafíñen jumá, íbini jabájüdaguni ámu jun. ");
INSERT INTO cabNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Dan le láfuridunbei Páblo jáma lánigu tídaangiñe ligílisi, ába jamúriajan jáma lúnya jadímurejan joun luágu buri cátei le lewéñegua dimáasu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Dan lagúmuchun jadámuridagun ligílisirugu, sarágu jádaangiñe juríu jáma buri ja ígirubalin binádu jafíñen lun jafálaruni jafíñen juríu, ába jafálaruni Páblo lúma Bernabé. Ába jadímurejan Páblo lúma Bernabé jáma, ába jaríñagun joun lun jasígirun eménigira luágu lareídun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lewéñegua dimáasu, le luwéyuri eméraaguni, ába joúndaragun jíbe-ágei lílana fulásu lun jagáambuni lerérun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Láu jaríjin juríu sarágu gürígia agáambajei lerérun Búngiu, ába jeméendüjan, ába jagúmeserun asígenerei Páblo, anába jameí líri Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ábati jadímurejan Páblo lúma Bernabé manúfudeiga, ába jaríñagun. —Lúnti yebe wíchuguni ugánu lúmagiñeti Búngiu luágu Wasálbaragüle jun furúmiñe, jugúya le juríu, quei mabúseerun jumá jerésibiruni ugánu ligía, láu líra jarúfuduñein luágu madǘna jumáni ibágari le magúmuchaditi, ítara líña weíbugagubeíti apúrichija joun ja mámabaña juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ladǘga ítara líña laríñaguni Wabúreme woun. Níchuguñadibu lun bíchuguni larúgounga joun ja mámabaña juríu, lun gayáraabei lan jasálbarun ja aganoúbaña lídan lagúmujoún fulásu uboúagu. ");
INSERT INTO cabNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Dan jagáambuni ja mámabaña juríu cátei le, ába jagúndaaragun, ába jagúmeserun aríñaga luágu buídu lan láni Búngiu ugánu, ába jafíñerun sun ja lúnbaña jafíñerun luágu Jesucrístu, ja lúntiñabaña ibágari le magúmuchaditi. ");
INSERT INTO cabNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ítara liña lapúrichijoún lerérun Búngiu lídan sun fulásu ligía. ");
INSERT INTO cabNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ába jadímurejan juríu jáma würíña gúnfulitiña, inébewa jagía, lúma jáma wügǘriña weírigutiña ñi ubúrugu, ába jínchajániña lun jeíbaajaniña Páblo lúma Bernabé darí lun jabúguniña lídaangiñe fulásu ligía. ");
INSERT INTO cabNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ábati jáfuruduní calíqui lueígiñe jagúdi, arúfudei luágu mabuídun lan joúserun lílana fulásu ligía, ába joúdin ubúrugun Icónio. ");
INSERT INTO cabNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Gúndaañu jáña afíñetiña Antioquía luágu jabágari lúma Crístu, weíriti jedéregeragun joúngua lun Sífiri Sándu. ");
INSERT INTO cabNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ába jebélurun Páblo lúma Bernabé tídoun jalígilisin juríu ubúrugu Icónio, ába japúrichijan, buíti jadímurejan darí lun jafíñerun sarágu, dándu juríu quei máma juríu, luágu Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Juríu ja mafíñebaña luágu Jesucrístu, ába jínchajaniña ja mámabaña juríu, amísiñedagǘdaña afíñetiña joun. ");
INSERT INTO cabNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ligía jeréderunbei Páblo lúma Bernabé sarágu dan ñi, ába jadímurejan furáangu, manúfudeiga, jeménigiñu luágu Búngiu, arúfuda lumúti Wabúreme luágu inárüni lan cátei le japúrichijabei luágu lareídun, láu líchuguni ubáfu joun lun jadáagun seíni lúma miláguru. ");
INSERT INTO cabNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Fánreinguañu jáña lílana ubúrugu ligía, jíbiri jámagiñeñanu juríu, jíbiri jámagiñe apóstolugu. ");
INSERT INTO cabNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Játi juríu jáma ja mámabaña juríu, ába jebélurun lídoun ában arítaguni jáma gumádimatiña lun jeíbaajaniña apóstolugu lúma lun jachámuragun dǘbü jawágun. ");
INSERT INTO cabNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ánjein Páblo lúma Bernabé, ába jasándiruni, ába joúdin lídoun buri fulásu le gíribei Lístra lúma Dérbe, biáma fulásu le láni méme fulásu le Licaónia, lúma geyégua láu, ");
INSERT INTO cabNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","apúrichija jamúti gíñe ugánu luáguti Wasálbaragüle Jesucrístu ñi. ");
INSERT INTO cabNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ñíñein ában wügǘri meíbugunti, Lístra, ñun líña ladǘga ítaragubeíñein lan lúmagiñe lagǘriajoún, meíbugungubeíti. ");
INSERT INTO cabNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Lagáambajañein wügǘri ligía le laríñagubei Páblo, láu laríjin Páblo luágun, ába lasúbudiruni luágu afíñe lan wügǘri ligía luágu gayára lan lareídagun. ");
INSERT INTO cabNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ábati laríñagun Páblo lun láu umálali jéreti. —Ráramabá luágu bugúdi. Ába lachúbarun wügǘri ligía arárama, ába lagúmeserun eíbuga. ");
INSERT INTO cabNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Dan jaríjini gürígia cátei le ladǘgübei Páblo, ába jagúmeserun agúaraja lídan jerérun Licaóniana, jaríñaga. —¡Raríjaña búngiugu quei jagáburi wügǘriña wámoun! ");
INSERT INTO cabNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Jaríñaga luágu Bernabé búngiu Júpiter, luágu Páblo búngiu Mercúrio, ladǘga ligía lan adímurejabei. Nújein lúban jabúngiute Júpiter boúgudiñoun lueí ubúrugu, ");
INSERT INTO cabNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ába liábin lufádirin Júpiter ñígiñe barüína wügǘriña bágasu lúma buri fulúri luágun lubéneri ubúrugu, busénti yebéti ligía jáma buri gürígia lun jáfaruniña bágasu jagía lun jadágaragüdǘn joun Páblo lúma Bernabé. ");
INSERT INTO cabNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Dan jasúbudiruni Páblo lúma Bernabé cátei lan jabúseerunbei gürígia ja jadǘgün, ába jajeíridagunun janáangun le luweírin lubéresen cátei le joun, ába jádaragun joúngua jádoun gürígia agúarajeina. ");
INSERT INTO cabNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¡Wügǘriña! ¿cámesan jabúseera jadǘgüni cátei le? Wügǘriña giñétia wagía quei jugúya, wayábiña aríñaga jun lun jígiruni cátei buri le mabuídunbei, lun jafálaruni Búngiu le wínwanbei, le adǘgübalin siélu lúma uboú, barána lúma sun cátei le lídaanbei. ");
INSERT INTO cabNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Lídan meja dan le sügǘjalibei, ígira lumútiña meja Búngiu gürígia lun jadǘgüni le jabúseerubei, ");
INSERT INTO cabNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","láu sun, arúfuda láani joun gürígia cáteiñein lan láuja buídu le ladǘgübei joun. Rúti júya woun lúma alúbajani buíti, ru ligía eígini buídurügüti woun, belúgüda lumúti ugúndani tídoun wanígi. ");
INSERT INTO cabNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Láu sun aríñaga jamáni Páblo lúma Bernabé sun cátei le joun, jénreengu mémegili jeréderuniña gürígia lueí jáfaruniña bágasu jagía lun jadágaragüdǘn joun. ");
INSERT INTO cabNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ábati jachǘlürün juríu Antioquíagiñe lúma Icóniogiñe, ába jagáñeiruni jarítagun gürígia lun jachámuragun dǘbü luágun Páblo. Lárigiñe, ába jadúruguduní bougudín lueí fulásu, sun jaríñagun luágu jiláali lan. ");
INSERT INTO cabNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Dan le jagúriridágun afíñetiña láu Páblo, ába lásaarun, ábaya lebélurun fulásurugún. Larúgan, ligía lídin lúma Bernabé ubúrugun Dérbe. ");
INSERT INTO cabNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Lárigiñe lapúrichijaní ugánu luáguti Wasálbaragüle ñi Dérbe, le ñí jabei sarágu gürígia afíñerutiña luágu Jesucrístu, ába jagíribudun, ába joúdin Lístra, Icónio lúma Antioquía. ");
INSERT INTO cabNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Rútiña gurásu joun afíñetiña ja lídaanbaña buri fulásu ligía, aríñaga jagía joun lun jasígirun derégüdagu lídan jafíñen, aríñageina jagía joun luágu lúnti lan wasúfurirun sarágu lun gayára lan webélurun lídoun larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Rútiña gíñe ábutigu lídan cáda jadámurin afíñetiña. Lásunti jayúmuragun lúma jayúnarun, ába jedéregeruniña lábun laríaajan Búngiu le uágubei jafíñera. ");
INSERT INTO cabNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Lárigiñe, ába jásügürün Pisídiagiñe, ába jachǘlürün Panfília. ");
INSERT INTO cabNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ába japúrichijaní ugánu luáguti Jesucrístu ubúrugu Pérge, líbiri méme Panfília, ábati joúdin Atálioun. ");
INSERT INTO cabNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ñígiñe jádina, ában joúdin Antioquíoun, le fulásu le ñíjin lubeí joúnajoúa lábugiñe laríaajan Búngiu adǘgei wadágimanu le jagúmuchubei guetó. ");
INSERT INTO cabNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Dan jachǘlürün Antioquía, ába joúndaraguniña tánigu jalígilisin afíñetiña, ába jabájüdaguní sun cátei le ladǘgübei Búngiu jáu joun, lúma luágu lánjunrenchuní Búngiu béna joun ja mámabaña juríu lun gíñe gayáraabei lan jafíñerun luágu Jesucrístu lun jasálbarun. ");
INSERT INTO cabNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ába jeréderun Páblo lúma Bernabé sarágu dan jáma afíñetiña ñi. ");
INSERT INTO cabNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ligía jayábin wügǘriña Judéagiñe lun Antioquíoun, ába jagúmeserun arúfudaja joun afíñetiña luágu lun lan jasálbarún, mósu lan jerésibiruni wügǘriña circuncisión, quei laríñaguni lilúrudun Moisés. ");
INSERT INTO cabNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Barǘti Páblo lúma Bernabé ában sigénei weíriti jáma luágu cátei ligía, lagúmujoún óra, ába loúnajoún Páblo, Bernabé, jámaya ámu wügǘriña Jerusaléoun lun joúdin aráanserei cátei le jáma apóstolugu jáma tábutigu ligílisi to ñíboun. ");
INSERT INTO cabNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ja tánigu ligílisi to Antioquíaboun oúnajabaliña, lídaanti jaweíyasun, ába jásügürün loúbawagugiñe Fenícia lúma Samária, abájüdagueina jagía luágu jígiruni ja mámabaña juríu binádu jafíñen lun jafálaruni Crístu. Ába jagúndaaragun sun afíñetiña láu ugánu le. ");
INSERT INTO cabNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Dan jachǘlürünbei Páblo lúma Bernabé Jerusalén, ába jerésibiruniña tílana ligílisi, jáma apóstolugu, jáma tábutigu ligílisi, ába jabájüdagun Páblo lúma Bernabé joun luágu sun le adǘga láalibei Búngiu jádaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ñíñanu jádaangiñe jadámurin fariséogu ja afíñetiña luágu Crístu, ába jaráramun, ába jaríñagun. —Lúnti jerésibiruni wügǘriña afíñetiña ja mámabaña juríu circuncisión, lúnti gíñe jagúnfulirun lúma lilúrudun Moisés. ");
INSERT INTO cabNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ábati joúndaragun apóstolugu jáma tábutigu ligílisi lun jatúriajaní cátei le. ");
INSERT INTO cabNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Lárigiñe sarágu dimúrei, ába lásaarun Pédro, ába laríñagun. —Nidújeñu, subúdi jumúti luágu binárü lán meja lanúadirana Búngiu jídaangiñe lun níchuguni ugánu le lánina asálbaruni joun ja mámabaña juríu, lun gíñe gayáraabei lan jafíñerun luágu Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Búngiuti, le subúdijabúbei tun anígi, arúfuda lumúti luágu resíbi lániña ja mámabaña juríu láu líchuguni Sífiri Sándu joun quei líchuguni woun. ");
INSERT INTO cabNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Manǘgün lumútiwa Búngiu ámu jaweí, jarúmagüda lumútu gíñe janígi láu jafíñen luágu Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Cáti uágu laloúguada jafíñen guetó luágu le adǘga láalibei Búngiu, ru jugúya ában ijǘrügu jawágun afíñetiña ja, le wásiñerubei wagía guánarügü anǘga—ni wagía ni binádu wagǘbürigu? ");
INSERT INTO cabNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Afíñetiwa luágu sálbaadiwa lan láurügü wafíñerun luágu Jesucrístu, madǘgünga wagía ni ámu cátei lun wabíjini, sálbaadiwa láu lareíni Wabúreme Jesucrístu. Ítara méme líña gíñe jasálbarun ja mámabaña juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ábati jámanichúnga, ába jagáambuni sun le jaríñagubei Bernabé lúma Páblo joun luágu buri seíni lúma miláguru le ladǘgübei Búngiu jádaangiñe, jagánagua ja mámabaña juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Dan le lásurun jadímurejan, ába laríñagun Jacóbo. —Nidújeñu, agáamba jumána. ");
INSERT INTO cabNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Abájüdaguaali Simón Pédro woun ída líña lan fuleísei lániña Búngiu ja mámabaña juríu, láu lanúadajan jádaangiñe lun lánigume. ");
INSERT INTO cabNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ítara líña cátei le quei lé meja jabǘrüjabei profétagu tídan Lerérun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Gumúguaali jarúeijan ladǘgawagun Davíd, queísigubeirügü tagúmuchagun ában múna eíguadutu. Lachǘlürüba wéyu nun, áu le Búngiu, lúnyame naríjin jawágun ladǘgawagun Davíd, ábame níchuguni ubáfu lun ában jádaangiñe lun larúeijan jádan. ");
INSERT INTO cabNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nadǘgübei líra lun gayáraabei lan jayábin sun jíbiri gürígia lun jáluajanina queísi Jabúreme, lun jayábin sun ja mámabaña juríu nun, ja anúadaja náñabaña lun nánigume. ");
INSERT INTO cabNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ítara líña naríñagun, áu le Búngiu, le asúbudirágüdübalin cátei le lúmagiñe buga binádu dan. ");
INSERT INTO cabNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","‘Ligía naríñagunbei luágu moun láni wíchugun sarágu lúrudu jawágun ja mámabaña juríu, ja ígirubalín binádu jafíñen lun jafálaruni Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","buídurügüti láu labǘrüjoún joun lun jebé lan jeígin eígini le adágarawagüdǘti joun sándu, madáagun jagíame cátei buri jáma ja úmatiña mamárieidun jamá, meígin jagíame jágürügü anímaalu ja tigíwarügütiña lugúndun máfuridunti játa jádaangiñe, meígin jagíame játa anímaalu. ");
INSERT INTO cabNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Buíti lun jagúnfulirun lúma buri cátei le lun jíchugun inébesei joun juríu, ladǘga lúmagiñe bugája binádu dan, añájein gürígia apúrichijati lilúrudun Moisés lídan ságü fulásu, aliijoúati lúrudu luágu tídan buri jalígilisin juríu ságü luwéyuri eméraaguni. ");
INSERT INTO cabNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ábati jarítagun apóstolugu jáma tábutigu ligílisi jáma sun tílana ligílisi janúadajan wügǘriña jádaangiñe, lun joúnajaniña Antioquía úara lúma Páblo lúma Bernabé. Ába janúadiruni Júdas, le gíribei Barsabási, lúma Sílas, bián wügǘriña weírigutiña jádan afíñetiña. ");
INSERT INTO cabNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ába joúnajan ában gárada jáma, láriñajare tídan gárada tugúya. “Wagía le apóstolugu, tábutigu ligílisi, jáma sun jíbiri afíñetiña, mábuga wáña joun wadújeñu lueígiñe Jesucrístu ja mámabaña juríu ja aganoúbaña Antioquía, Síria, lúma Cilícia. ");
INSERT INTO cabNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Agáambaadiwa luágu añájein lan gürígia ñǘdüntiña yágiñe ibídiñoun woun ebéreseja jun láu jadímurejan, áni dájaña ámu arítaguni jídoun láu jaríñagun jun luágu mósu lan jerésibiruni wügǘriña circuncisión, queísi laríñaguni lilúrudun Moisés. ");
INSERT INTO cabNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ligía wúwaradúnbei lídan warítagun lun wanúadajan gürígia wádaangiñe lun joúdin aríjaün úara jáma wadújeñu Bernabé lúma Páblo ja jínsiñebaña woun sarágu, ");
INSERT INTO cabNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ja rújamaalíbei jabágari lídoun pelíguru lueígiñe Wabúreme Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Woúnajañanu lubeíti Júdas lúma Sílas jun, jadímurejaba júma lun jafúnraanguagüdüni sun cátei le tídaanbei gárada to woúnajaboun jun, jun. ");
INSERT INTO cabNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Maríbaanti larijín lun Sífiri Sándu lúma woun, míchugúniwa lan ámu ijǘrügu jun lueídügüya murúsun cátei le, le lunbei jadǘgüni. ");
INSERT INTO cabNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","lun meígin jumá úwi le jáni anímaalu ja adágarawagüdǘtiña joun sándu, meígin jugúyame jítaü, ni úwi le jáni anímaalu ja tigíwarügütiña, madáagun jugúyame cátei buri jama gürígia ja mamárieidúntiña júma. Ánjaün areídagua júngua lueí buri cátei le, buídubei jadǘga. Buídu lámuga lídin jun.” ");
INSERT INTO cabNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Lárigiñeti joúnajoún luágu jaweíyasun, ába joúdin Antioquía. Dan le jachǘlürünbei ñi, ába joúndaraguniña afíñetiña, ába jíchugunun gárada joun. ");
INSERT INTO cabNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Dánti le jalíijanbarun afíñetiña, ába jagúndaarun sarágu luágu gurásu le tíchugubei joun. ");
INSERT INTO cabNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Quei gíñeti gabáfu jamá Júdas lúma Sílas lun ladímurejan Búngiu jayúmulugugiñe, ába jíchugun gurásu joun afíñetiña láu jadímurejan joun, ru jagía idérebugu lun jafíñen. ");
INSERT INTO cabNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Lárigiñe jásügürün átiri dan ñi, ába jayoúragun afíñetiña joun lubá jagíribudun jámoun já meja oúnajabaliña Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ánjeinti Sílas, ába leréderun. ");
INSERT INTO cabNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Reídeitiña gíñe Páblo lúma Bernabé Antioquía, ába jasígirun arúfudajei lúma apúrichijei ugánu luáguti Crístu, jagía jáma sarágu ámu. ");
INSERT INTO cabNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Átiri dan lárigiñe, ába laríñagun Páblo lun Bernabé. —Queímounya aríjaña afíñetiña lídan sun ubúrugu buri le ñí lubei apúrichija wamáali lan ugánu luágu Crístu, aríja wamámuga ída jáña lan. ");
INSERT INTO cabNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Busénti yebe Bernabé janǘgüni Juan Márcos jámagua, ");
INSERT INTO cabNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","májati Páblo janǘgüni ladǘga meja ígira láaña lan Panfília, masígiti jáma lídan wadágimanu. ");
INSERT INTO cabNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Lárigiñe sarágu sigénei, múaradúntiña luágu cátei le darí lun jafánreinragun jawáriuagua. Ába lanǘgüni Bernabé Márcos, ába joúdin Chípre, ");
INSERT INTO cabNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ába lanǘgüni Páblo Sílas. Lárigiñe jedéregeruni afíñetiña Páblo lúma Sílas lújaburugun Búngiu, ába joúdin, ");
INSERT INTO cabNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ába jásügürün Síriagiñe lúma Cilíciagiñe, íchaajeina gurásu joun afíñetiña ligílisirugu. ");
INSERT INTO cabNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ába jachǘlürün Páblo lúma Sílas lídoun buri fulásu le Dérbe lúma Lístra, le ñí lubei jadárira ában afíñeti gíriti Timotéo, tiraǘ ában wǘri juríu afíñetu luágu Jesucrístu, güriégu lúguchi. ");
INSERT INTO cabNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Afíñetiña ja aganoúbaña Lístra lúma Icónio, buíti jadímurejan luágu. ");
INSERT INTO cabNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Busénti Páblo lun lídiba lan Timotéo jáma, íchigeina ugánu luáguti Crístu, ába lerésibiruni Timotéo circuncisión lueí wuríba lan joun juríu ja aganoúbaña lídan buri fulásu ligía, quei subúdi jamáni luágu merésibirun láani circuncisión ladǘga güriégu lan lúguchi. ");
INSERT INTO cabNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Súnti fulásu le ñígiñe lumúti jásügüra, jasúbudirágüdüni cátei le jaríñagubei apóstolugu jáma tábutigu ligílisi ja Jerusalénbaña joun afíñetiña, ába jéredun jawágu lun jagúnfulirun lúma jagúmadin. ");
INSERT INTO cabNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ába lubeíti jedéraagüdǘn tílana ligílisi lídan jafíñen, ába jagánwoundun afíñetiña ságü wéyu. ");
INSERT INTO cabNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Májati Sífiri Sándu lun jíchugubei lan ugánu luágu Crístu Ásia. Ábati jásügürün labádinaguagiñe Fríjia luma Galácia, ");
INSERT INTO cabNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ába jachǘlürün luágu fadáguaü le Mísia. Ñígiñe yebe jarítagua lun jebélurun loúbawagun Bitínia, májati láni Jesúsu Espíritu le méme Sífiri Sándu lun jadǘgüni. ");
INSERT INTO cabNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ábati joúdin surúrugu Mísioun, ába jarárirun Tróas. ");
INSERT INTO cabNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ñi lasáliragua ában wügǘri Macedóniana lun Páblo, áriebu, rára ayúmuragua lun, laríñaga lun. “Queímoun Macedónia íderagua bámugawa.” ");
INSERT INTO cabNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Lárigiñe lasáliragun wügǘri ligía lun Páblo, ába waráansejan lun woúdin Macedónia láu wafíñen luágu lagúajaña lan Búngiu woun lun wíchuguni ugánu luágu Crístu le Wasálbaragüle joun Macedóniana. ");
INSERT INTO cabNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ábati wáfayarun Tróasgiñe, ába woúdin sügǘlügü luágun uboúju le Samotrácia, larúgan, ligía wachǘlürün Neápolis. ");
INSERT INTO cabNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ñígiñe ába woúdin Filípos, Filípos lábugiñeñein lagúmadijan Róma, ligía gíñe ubúrugu le weírigutimáabei luágu loúba Macedónia. Reídeitiwa átiri wéyu ñi. ");
INSERT INTO cabNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Luágu ában wéyu le luwéyuri eméraaguni, ába wáfuridun boúgudin lueí ubúrugu, lárun dúna, lídan ában fulásu le ñi lubeíja layúmurawagúa lun Búngiu. Ába wañúurun ñi, ába wíchuguni ugánu luáguti Crístu joun würíña ja oúndaragubáña ñi. ");
INSERT INTO cabNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ñíñoun ában jádaangiñe, gíritu Lídia, ubúruguna Tiatíra, tifísiute alúguraja gamísa fínutu to gúchu tágu. Judúguatu wǘri tugúya lun Búngiu, tagáambajañádiwa, ába lánjunrenchunun Búngiu tanígi lun tadǘgün gásu láu le laríñagubei Páblo. ");
INSERT INTO cabNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ába tabásterun jáu sun tílana túban, lárigiñe, ába tayúmuragun woun ítara. —Ánjein afíñe jubeí luágu afíñe nan le tímatimaati luágu Wabúreme Crístu, reídei jumá ya núbiñe. Jéretu wawágu, ába weréderun. ");
INSERT INTO cabNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Luágu ában dan, dan le woúdiña lan lídoun fulásu le ñi lubeíñaja layúmurawagúa lun Búngiu, ába wadúnragun túma ában irájü gawágutu ában espíritu wuríbati le íchugubei ubáfu tun lun tasábiujan. Ában idámuni irájü tugúya, ibíjatutíja sarágu seínsu joun tabúriña láu tasábiujan. ");
INSERT INTO cabNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ába tagúmeserun irájü to afálarawa, wagía lúma Páblo, agúarajeina tugúya ítara. —Gürígia ja, jesériwiduña lun Búngiu le íñubei, jadímurejaña luágu ǘma lánina asálbaruni lídaangiñe figoú jun. ");
INSERT INTO cabNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Gíbeti wéyu táu adǘgei cátei le darí lun tebéresedun lun Páblo, ába lagáraragun, ába laríñagun lun espíritu le tídaanbei. —Lídan líri Jesucrístu, gumádi numútibu lun báfuridun tídaangiñe. Ába láfuridun espíritu ligía tídaangiñe lídan méme óra ligía. ");
INSERT INTO cabNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Dan le jaríjin tabúriña luágu siñáali lan jagáñeirun seínsu tueígiñe, ába járügüdüni Páblo lúma Sílas, ába janǘgüniña jagíbugiñoún ábutigu lamídaangua ubúrugu. ");
INSERT INTO cabNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ába jarúfuduniña jagíbugiñe gumádimatiña, ába jaríñagun. —Wügǘriña juríu ja, jachágaraguñein wabúrugute, ");
INSERT INTO cabNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","jarúfudajaña igáburi le wásiñerubei erésibira ni adǘga ladǘga Rómana wagía. ");
INSERT INTO cabNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ábati jiñúragun gürígia joúngua jawágu, ába jarágachaguágüdüniña gumádimatiña, ába jíchugun dimúrei lun jabeichúniwa láu wéwe. ");
INSERT INTO cabNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Lárigiñe sarágu abeichúni, ába jádaruniña furísunrugún, ába jaríñagun lun oúnigiruti adaürǘtiña lun goúnigi lániña buídu. ");
INSERT INTO cabNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Dan libíjini oúnigiruti lúrudu le, ába ládaruniña lídoun lagúmujoún tarígeirugu furísun, ába legélenchuni jagúdi. ");
INSERT INTO cabNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Queí buri luágun amídi áriebu, ñíñanu Páblo lúma Sílas ayúmuragua lúma erémuja urému lun Búngiu, ja jíbiri, agáambaja. ");
INSERT INTO cabNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Sódini, ába liábin ában oúnwenbun járabaganáli, ába lánjingichuni tuágaburi furísun. Lídan óra ligía, ába lánjunrenchun sun béna, safá ligía sun güríngüri le jawágubei adaürǘtiña. ");
INSERT INTO cabNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ába lagágudun oúnigiruti, dan laríjin luágu júnren líña lan sun tubéneri furísun, ába laságarunun lefeínte lún yebe láfaragun lúngua, sún yebe laríñagun luágu ñǘdüngua jamá adaürǘtiña. ");
INSERT INTO cabNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ába lagúaragun Páblo lun. —Máfaraguabá búngua, awánja ya sun wagía. ");
INSERT INTO cabNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ábati lamúriajan oúnigiruti lámpu, ába lebélurun eíbaagueina, adádagareina láu anúfudei, ába láguragun lúngua lubádu jagúdi Páblo lúma Sílas. ");
INSERT INTO cabNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ába laságaruniña furísunrugugiñe, ába laríñagun joun. —Wügǘriña, ¿ca cátei lúnbei nadǘgüni lun nasálbarun? ");
INSERT INTO cabNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ába jaríñagun lun. —Afíñebá luágu Wabúreme Jesucrístu, ábame basálbarun jáu sun tílana búban. ");
INSERT INTO cabNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ába jíchuguni ugánu luáguti Crístu lun jáu sun ja lúbiñebaña. ");
INSERT INTO cabNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lídan méme óra ligía, láu sun áriebujali lan buídu, ába lachíbuni bíti buri le jawágubei, ábati labásterun jáu sun lufámilian. ");
INSERT INTO cabNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Lárigiñe, ába lanǘgüniña lúbiñoun, ába líchugun eígini joun, ¡máti lugúndan jáu sun lufámilian láu jafíñerun luágu Búngiu! ");
INSERT INTO cabNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Larúgan bináafin, ába joúnajan gumádimatiña polisía aríñaga lun oúnigiruti lun lígiragüdǘniña Páblo lúma Sílas. ");
INSERT INTO cabNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ábati laríñagun oúnigiruti lun Páblo. —Oúnajaaña gumádimatiña aríñaga nun lun nígiragüdünün, gayáraajali lubeíti jídin darángilañu. ");
INSERT INTO cabNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ába laríñagun Páblo joun polisía. —Láu sun Rómana wamá, beíjamutiwa jagíbugiñe gürígia, míchigunga dan woun lun wadímurejan waweígiñegua, dágua jamáwa furísunrugun, ¿guetó buséntiña jígiragüdǘniwa arámudaguárügü? ¡Máfuridunbadiwa! Nǘbin jamá aságarawa. ");
INSERT INTO cabNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ába jabájüdaguni polisía cátei le joun gumádimatiña, ába janúfudedagún gumádimatiña dan le jasúbudiruni luágu Rómana jamá Páblo lúma Sílas. ");
INSERT INTO cabNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ábati joúdin amúriaja ferúdun jáma, ába jaságaruniña, ába jayúmuragun joun lun jáfuridun ñígiñe ubúrugugiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Dan le jáfuridunbei furísunrugugiñe, ába joúdin túbiñe Lídia, lárigiñe jaríjiniña afíñetiña lúma jíchugun idérebugu joun, ába jasígiruni jaweíyasun. ");
INSERT INTO cabNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Lídan jaweíyasun Páblo lúma Sílas, sügǘtiña Anfípolisgiñe lúma Apolóniagiñe, ñígiñe, ába jachǘlürün ubúrugun Tesalónica le ñí tubei ában jalígilisin juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Quei léchun Páblo, ñǘdünti tídan ligílisi tugúya, adímurejati jáma ǘrüwa dimáasu, ságü luwéyuri eméraaguni. ");
INSERT INTO cabNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Arúfudajati joun quei taríñaguni Lerérun Búngiu luágu lúnti lán meja lasúfurirun Crístu, lárigiñeme lan loúnwen, aba lánme lásaarun lídaangiñe oúweni lúnya labágaridun. Laríñaga buri joun. —Jesúsu méme le uágubei nadímureja jun, ligía Crístubei le lúnbei liábin asálbaraña gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ábati jafíñerun jádaangiñe juríu, ába júaradun lúma Páblo lúma Sílas. Afíñetiña gíñe sarágu ja mámabaña juríu ja judúguatiña lun Búngiu, jáma sarágu würíña weírigutiña. ");
INSERT INTO cabNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Juríu ja mafíñebaña luágu Jesúsu lan Crístubei le lunbei liábin, magúndaantiña láu cátei le, ába joúndaragun wügǘriña wuríbatiña ja eíbugañajádügübaña ǘmada, ába jachágaraguágüdüniña gürígia ñi ubúrugu. Ába jaságarajanun lúban Jasón, áluajaña Páblo lúma Sílas lun jaságaruniña lun jedéregeruniña jájaburugún gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Queíti madári jamániña ñi, ába janǘgüni Jasón jáma átiri jádaangiñe afíñetiña jagíbugiñoún gumádimatiña lídan ubúrugu ligía, ába jagúaragun aríñaga. —Wügǘriña ja, ja ebéresejabaña lídan sun fulásu, chülǘjaña gíñe ñájoun, ");
INSERT INTO cabNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","resíbi láaña Jáson lúbiñe. Sun jagía dürǘgua jamúti lilúrudun Urúei César, ladǘga aríñagatiña luágu níjein lan ámu urúei, ában nege gíriti Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Dan jagáambuni gumádimatiña jáma sun jíbiri gürígia cátei le, ába jachágaragun. ");
INSERT INTO cabNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jáson jáma ja jíbiri, ába jafáyeijan, ába jígirawagüdǘniwa. ");
INSERT INTO cabNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Furése furése, dan le labúrigadun, ába joúnajaniña afíñetiña Páblo lúma Sílas ubúrugun Beréa. Quei jachǘlürün ñi, ába joúdin tídoun jalígilisin juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Juríu ja ñíbaña, buítimaati jagáburi jaweí ja Tesalónicabaña, resíbi jamúti ugánu luáguti Crístu láu ugúndani, ságüti wéyu jalíijanun Lerérun Búngiu lun jaríjini ánjein inárüni lubeí le aríñawagúbei joun. ");
INSERT INTO cabNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Sarágu jáña lubeíti afíñerutiña jádaangiñe, afíñe jagía gíñe sarágu ja mámabaña juríu, dándu würíña weírigutiña quei wügǘriña. ");
INSERT INTO cabNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Dan le jasúbudirunbalin juríu ja Tesalónicabaña luágu lapúrichijañein lan gíñe Páblo Lerérun Búngiu Beréa, ába joudin achágaraguágüdaña gürígia ñi. ");
INSERT INTO cabNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ába joúnajani afíñetiña Páblo furése lun lídin lacóstoun, leréderame Sílas lúma Timotéo Beréa. ");
INSERT INTO cabNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ja ñǘdünbaña láu Páblo, ába jáfayajan lúma chülǘ ubúrugu Aténas. Lárigiñe, ába jagíribudun barüína jagía dimúrei lun Sílas lúma Timotéo lun joúdin lárigi Páblo lídan lufúresen. ");
INSERT INTO cabNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Sun niján lan Páblo Aténas agúrabajei Sílas lúma Timotéo, medéraaguágüdünti larítagun láu laríjini ubúrugu ligía buin jáu bürǘbün sándu. ");
INSERT INTO cabNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ligíaja ladímurejaanbei tídan jalígilisin juríu lúma jáma ja mámabaña juríu ja ájuduragubaña lun Búngiu, adímureja ligía buri ságü wéyu jáma gürígia ja ǘmadarugubaña, ñí lubei jadámuridagua. ");
INSERT INTO cabNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ñíñanu jádaangiñe wügǘriña ja atúriajabalin jarúfudajan epicúreogu, jáma ja atúriajabalin jarúfudajan estóicogu, ába jadímurejan lúma. Jaríñaga jíbiri. —¿Cáfunasan laríñagubei wügǘri le woun, líbebei ladímurejan? Jaríñaga jíbiri. —Camátia ladímurejaña jawágu ámu búngiugu. Jaríñagunbeiti ítara ladǘga lapúrichijan Páblo joun luágu Jesúsu lúma luágu ásaaruni lídaangiñe oúweni. ");
INSERT INTO cabNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ábati janǘgüni lídoun ában fulásu gíriti Areópago, le ñi lubeíja joúndaragua lun jagáambagun joúngua, ába jaríñagun lun. —¿Gayáraati wasúbudiruni cátei lan iséri cátei le barúfudajabei? ");
INSERT INTO cabNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Cátei lé buri baríñagubei woun, terénchati woun, buséntiwati wasúbudiruni ca lan laníchigubei. ");
INSERT INTO cabNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Sun Aténasna, jáma teréncha ja aganoúbaña ñi, marítaguntiña luágu ámu cátei lueídügüya luágu jaríñagun lúma jagáambun cátei iséri. ");
INSERT INTO cabNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ábati laráramun Páblo jamídaangua ñi Areópago, ába laríñagun. —Wügǘriña Aténasna, aríja numúti luágu afíñe jumá jawágu jisándun, ");
INSERT INTO cabNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ladǘga dan le aríaajeina nubálin fulásu buri le ñí lubei jájuduragua joun jisándun, darítina ában latárü le ñí lubei bürǘwañu lan dimúrei le. “Lun Búngiu le ibídiñewabei”. Búngiu le, le únbei jájuduragua, le ibídiñebei jun, ligía Búngiu le uágubei nadímureja jun. ");
INSERT INTO cabNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","‘Ligía Búngiu le adǘgübalin uboú lúma sun cátei le uboúagubei, ligía labúremebei siélu luma uboú. Maganoúnti tídan ligílisi to jadǘga gürígia, ");
INSERT INTO cabNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","memégeirun lumúti gíñe le gayáraabei jadǘgüni gürígia luágu lufúleisein, ligía guánarügü íchugubei ibágari lúma garábali, lúma sun cátei woun, sun wagía. ");
INSERT INTO cabNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","‘Lídaangiñe ábanrügü wügǘri ladǘgaña sun néchaanigu lun jaganoún lídan sun fulásu, aráanseleí dan le lúnbei jabágariduni lúma fulásu le lúnbei ñíba lan jagánawa. ");
INSERT INTO cabNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Adǘga lumúti Búngiu sun líra lun gayáraabei lan jáluajani gürígia, gayára lámuga jadáriruni láu jáluajani, láu sun inárüni lan luágu madíse lan Búngiu lueí cáda ában wádaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ladǘga lídaangiñeti Búngiu awánjein lubeí, gabágari wagía, eíbuga wagía ligíbuagu uboú le, quei jaríñaguni poétagu jídaangiñe. “Lirájüñü Búngiu wagía.” ");
INSERT INTO cabNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Queíti lirájüñü wabeí Búngiu, moún lumuti wanǘgüni Búngiu quei ában sándu le gólu, o pláta o dǘbü le jadǘga wügǘriña quei jarítagun luágu ítara líña lan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mebéresegúnti méja Búngiu láu cátei le jadǘgübei gürígia lábugiñe libídiñe joun, ánjein guetó, aríñagati joun sun gürígia lídan sun fulásu lun jasáansiruni joúserun. ");
INSERT INTO cabNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ladǘga anúadajaali Búngiu ában wéyu lun ligíaba lan wéyu lagúseragüdüniña gürígia ja uboúagubaña láu ísuruni láu ában wügǘri le anúadaja láalibei, wügǘri ligía, ligía Jesucrístubei, arúfuda lumúti woun láu lásaaragüdüni Jesúsu lídaangiñe oúweni lúnya labágaridun. ");
INSERT INTO cabNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Dan le jagáambubei luágu ásaaruni lídaangiñe oúweni, ñíñanu jádaangiñe, ába jéjerajan láu, jíbiri ába jaríñagun. —Lídaanbagúbei ámu dan wagáambei badímurejan luágu buri cátei le. ");
INSERT INTO cabNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ábati lígiruniña Páblo. ");
INSERT INTO cabNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ába jafíñerun jádaangiñe luágu Jesucrístu, ába jafálaruni. Ñíñein Dionísio jádan, lé meja ában jádaangiñe ábutigu lídan fulásu le gíribei Areópago, túma gíñe ában wǘri gíritu Dámaris, jámaya ámu gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Lárigiñe cátei le, ába láfuridun Páblo Aténasgiñe, ába lídin ubúrugu Corínto. ");
INSERT INTO cabNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ñi ladárira ában juríu gíritu Aquíla, túma lúmari to gíriboun Priscíla, Póntona jagía. Málügili lueígiñe jayábin Itáliagiñe, jayábinbei ñígiñe ladǘga líchugun urúei Cláudio dimúrei lun jáfuridun sun juríu Rómagiñe. Ába lídin Páblo aríjaña, ");
INSERT INTO cabNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","queíti ában lan lifísiute jáma—tadáawagun quiámpu—ába leréderun jáma lun jawádigimaridun lídan ában. ");
INSERT INTO cabNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ságüti wéyu le lidáani eméraaguni, lídin Páblo tídan jalígilisin juríu adímureja, áni gáñei láaña buri dándu juríu quei ja mámabaña juríu lun jafíñerun luágu Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Dan jachǘlürün Sílas lúma Timotéo Macedóniagiñe, ába líchaagun Páblo lúngua le gumúti apúrichijei Lerérun Búngiu. Aríñagati joun juríu furáangu luágu Jesúsu lan Crístubei le jagúrabajabei lun lasálbaruniña lídaangiñe jafígoun. ");
INSERT INTO cabNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ánjaña juríu, ába jasígeneruni le lubeíbei, anábagua buri jameí. Ábati láfurudunun Páblo labíte jawágun, arúfudei joun luágu mínsiñe lan jagáburi lun, ába laríñagun joun. —Ánjaünme eféridira jídaangiñe, mámaalime nídaangiñeti. Lúmagiñe guetó, neíbuga apúrichija joun ja mámabaña juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ába láfuridun tídaangiñe jalígilisin juríu, ába lídin lúbiñoun ában wügǘri gíriti Jústo, wügǘri ligía, judúguati lun Búngiu, ñi toúbagiñe ligílisi lagánawa. ");
INSERT INTO cabNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Críspo, le tábuti jalígilisin juríu, ába lafíñerun luágu Wabúreme Jesucrístu, jáu sun tílana lúban. Sarágu gíñe jádaangiñe Coríntona, dan jagáambunbalin ugánu luáguti Jesúsu, ába jafíñerun, ába jabásterún. ");
INSERT INTO cabNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ábati lasáliragun Wabúreme Jesúsu lun Páblo luágu ában áriebu, ába laríñagun lun. —Manúfudebá, bapúrichija méme, mámanichabá, ");
INSERT INTO cabNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ladǘga anájein búma, úabei ni ában agúruruti buágu lun ladǘgün wuríbani bun. Añájein sarágu gürígia lídan ubúrugu le ja lúnbaña nánigubaña lan. ");
INSERT INTO cabNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Reídeiti lubeíti Páblo ában irúmu dimí ñi Corínto arúfudajei Lerérun Búngiu joun lílana fulásu. ");
INSERT INTO cabNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lídan dan le Galión lan gumándanbei Acáya, ába joúndaragun juríu lun járügüdüni Páblo. Ába janǘgüni ligíbugiñoun lúrudu lun lagúserawagüdǘn. ");
INSERT INTO cabNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ába jaríñagun lun gumándan. —Wügǘri le, leréde arúfudaja joun gürígia lun jájuduragun lun Búngiu láu ában igáburi le múaraanbei lúma lúrudu. ");
INSERT INTO cabNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Dán yebe ladímureja lan Páblo, ligía laríñagun Galión joun juríu. —Lun jamúga ában lan wuríbani o dúru jǘrüti ladǘgübei wügǘri le, níchaaguña jamúga núngua lun nagáambunün, jugúya juríu, ");
INSERT INTO cabNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","quei luágu lan dimúrei buri, lúma íri, lúma jilúrudun, aráanse jumeí júngua, ladǘga mabúseeruntina nagúseragüdün luágu buri cátei le. ");
INSERT INTO cabNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ába labúgaguniña ñígiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ábati járügüdüni sun güriégugu Sóstenes le tábuti jalígilisin juríu, ába jabúleiseiruni ñi guánarügü ligíbugiñe gumándan. Mebéresegúnti Galión láu líra. ");
INSERT INTO cabNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Lárigiñe líra, ába leréderun Páblo átiri dan ñi Corínto. Lárigiñe, ába layoúragun joun afíñetiña, ába lídin Síria úara túma Priscíla lúma Aquíla. Ába lásaruni lídiburi lídan ubúrugu Céncrea lubáragiñe ládinun, lun lagúnfulirun láu ában méja darádu le ladǘgübei lúma Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Dan le jachǘlürün ubúrugu Éfeso, ába lígiruniña Páblo Priscíla lúma Aquíla lun jeréderun ñi lídan ubúrugu ligía. Lubáragiñe lígiruni Páblo Éfeso, ába lídin ligílisirugu adímureja jáma juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ába jamúriajan lúma lun leréderun méme ñi jáma, májati. ");
INSERT INTO cabNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ábati layoúragun joun, laríñaga joun. —Mósu ñi nan Jerusalén lubá fédu le lúnbei ladügǘn, nagíribudayaba aríjaün ánjein busén Búngiu. Ába ládinun, ába lídin Éfesogiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Türǘti Cesaréa, ñígiñe ába lídin Jerusalén abúsura joun tílana ligílisi, lárigiñe, ába larágachun Antioquíoun. ");
INSERT INTO cabNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Lárigiñe lásügürün átiri dan ñi, ábaya láfuridun, ába leíbuguni sun fulásu Galácia lúma Fríjia ában ában, íchaajeina dǘgüdaguaü joun afíñetiña. ");
INSERT INTO cabNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Lídan dan ligía, ába lachǘlürün ában juríu gíriti Apólos ubúrugun Éfeso, Alejandríana juríu ligía. Gapúrichijati, áni subúdi lumúti gíñe Lerérun Búngiu buídu buídu. ");
INSERT INTO cabNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Subúditi luáguti Asálbaragülei le lúnbei liábin lun, áni apúrichijati luágu Asálbaragülei ligía táu sun tarúman lanígi. Sun le larúfudajabei luágu Jesúsu, inárüni, láu sun loúgua lan lasúbudirun luágu, le rügǘñein larúfudajabei Juan le abásteragüdajabei luágu Jesúsu le lúnbei liábin lárigiñe, lasúbudira. ");
INSERT INTO cabNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Luágu ában wéyu, dan le ladímurejaña lan Apólos tídan jalígilisin juríu láu sarágu ichoúruni, ába jagáambuni Priscíla lúma Aquíla. Dan lagúmuchun lapúrichijan, ába janǘgüni Priscíla luma Aquíla jábiñoun lun jafúnraanguagüdünitima luáguti Jesúsu le Wasálbaragülebei lun, luma luáguti cátei le larúfudajabei. ");
INSERT INTO cabNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Dánti le labúseerunbei Apólos lídin loúbawagun Acáya, lúmagiñeñanu afíñetiña Éfeso lun lídin, ába joúnajan ában gárada joun afíñetiña ja ñíbaña Acáya lun jerésibiruni buídu. Dan lachǘlürünbei Apólos Acáya, íderagua lumútiña ja lafíñeragüdǘbaña Búngiu luágu Jesúsu, láu lareíni, ");
INSERT INTO cabNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","arúfuda lumúti joun gürígia láu richaǘ le siñá jamuti asígenera, luágu marícha lan le jarúfudajabei juríu, arúfudaleí joun tídaangiñe Lerérun Búngiu luágu Jesúsu lan Crístu le jagúrabubei lun lasálbaruniña. ");
INSERT INTO cabNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Sun niján lan Apólos ubúrugu Corínto, ligía lásügürün Páblo labádinaguagiñe buri fulásu, ába lachǘlürün Éfesoun ñi lubeí ladárira sarágu afíñetiña. ");
INSERT INTO cabNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ába laríñagun joun. —¿Resíbi jumútisan Sífiri Sándu dan le jafíñerunbei luágu Jesucrístu? Jaríñaga lun. —Uá, magáambungubeígidiwa yebe luágu níjein lan Sífiri Sándu. ");
INSERT INTO cabNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ábati laríñagun joun. —¿Cáti luwúyeri badísei jerésibirubei? Jaríñaga lun. —Le labásterágüdün Juan. ");
INSERT INTO cabNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Laríñaga Páblo joun. —Labásterágüdüniña méja Juan gürígia, arúfudei luágu sáansi jamáali lan joúserun, aríñagati gíñe joun luágu lúnti lan jafíñerun luágu le lúnbei liábin lárigiñe—luágu Jesúsu le Crístubei, le Jasálbaragüle. ");
INSERT INTO cabNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Dan jagáambuni cátei le, ába jabásterun lídan líri Wabúreme Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Dánti le líchugunbalin Páblo lújabu jawágu, ába liábin Sífiri Sándu jawágun, ában jadímurejan dimúrei buri teréncha, ába buri ladímurejan Búngiu jayúmulugugiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Jawáraañanu dúusu wügǘriña jádan súngubei. ");
INSERT INTO cabNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ǘrüwañein játi láu Páblo abásija tídoun jalígilisin juríu le ñi lubeíja lapúrichija, adímureja ligíaja furáangu luágu larúeijan Búngiu, afíñegüda láña gürígia luágu. ");
INSERT INTO cabNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ñíñanu gíñe, edéreragüdütu janígi, májatiña jafíñerun, adímurejarǘgü jagía wuríba luágu lémeri Crístu jagíbugiñe gürígia. Ábati ladíreirun Páblo jaweí, ába lanǘgüniña ja afíñebaña luágu Jesucrístu tídoun ában lescuéla to ñí lubei larúfudaja ában wügǘri gíriti Tiránno, ábaja ladímurejan ságü wéyu joun, ñi. ");
INSERT INTO cabNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ítara líña lasígirun luágu bián irúmu, súnti ja aganoúbaña loúbawagu Ásia, agáamba jamúti ugánu luáguti Wabúreme Jesúsu, dándu juríu quei ja mámabaña juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Adǘgati buríti Búngiu oúnwenbun buri miláguru lídaangiñe Páblo, ");
INSERT INTO cabNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","darí lun tánügǘniwa buri músue o anáanguni to dagáaru luágu lúra joun sánditiña, ábaja jareídagun, furí jagíaja espíritugu wuríbatiña jádaangiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ñíñanu juríu eíbugañajádügütiña, aságajatiña gíñe espíritugu wuríbatiña jaweí gürígia, álugatiñá yebe jayúsuruni líri Wabúreme Jesúsu lun jaságajaniña, jaríñaga buri joun espíritugu. —Gumádi numútibu lídan líri Jesúsu, le uágubei lapúrichija Páblo, lun báfuridun. ");
INSERT INTO cabNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ñíñanu sédü lirájüñü ában juríu gíriti Escéva, jábuti méja fádirigu, jádan ja adǘgübalin buri cátei le. ");
INSERT INTO cabNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Níjein ában jadǘgüni, ába loúnabuniña espíritu wuríbati ligía. —Subúdi numúti Jesúsu, subúditi gíñe nun cátei lan Páblobei, ánjein jugúya, ¿cátaün? ");
INSERT INTO cabNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ába lachǘragun wügǘri le láubei espíritu wuríbati lúngua jawágun, gabáfuti sügǘ jáu súngubei, ába labúleiseiruniña buídu, ába jeíbaagun ñígiñe surúsu lúma láu buri bíti jawágu. ");
INSERT INTO cabNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Agáamba jamúti sun ja aganoúbaña Éfeso cátei le, juríu jáma máma juríu, ába janúfudedagun, weíriti linébedun líri Wabúreme Jesúsu joun. ");
INSERT INTO cabNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Sarágu gíñe buri jádaangiñe ja afíñerubaña, ába jayábin agúfeserei buri cátei wuríbati lé meja jadǘgübei, ");
INSERT INTO cabNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","sarágu gíñe buri jádaangiñe já meja gabíñarajadibaña, ába janǘgünun jalíburun buri, ába jágudunun jagíbugiñe súngubei. Dan jabájüdünbalin tebégi líburu buri tugúya, gebégitu queí buri dimí-san mílu murúsun seínsu le pláta. ");
INSERT INTO cabNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ítara líña abúruchagueína lan ugánu luáguti Jesúsu, arúfudeinaleí lubáfu lun lasáansiragüdüni jagáburi gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Lárigiñe sun cátei le, ába laráanserun Páblo lun lídin aríjaña afíñetiña Macedónia luma Acáya, lubá lasígiruni luweíyasun Jerusaléoun. Aríñagati gíñe luágu lárigiñe lanme lídin Jerusalén, lídiba lan gíñe Róma. ");
INSERT INTO cabNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ábati loúnajan biáma jádaangiñe ja íderagubalin lubá, Macedónia, wügǘriña jagía, Timotéo luma Erásto, ligía, ába leréderun átiriraüya dan Ásia. ");
INSERT INTO cabNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Lídan dan ligía, ñíñein ában oúnwenbun achágaraguní Éfeso jaweígiñeti ja afálarubalin lémeri Crístu, ");
INSERT INTO cabNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","lídaangiñeti ában wügǘri gíriti Demétrio, ladáawagun cátei láuti pláta lifísiutebei. Wügǘri ligía, adáaguati tirájüñü ligílisi láu pláta to tilígilisin sándu to gíriboun Diána, belútiti sarágu seínsu joun ja ñadágimeinbaña lúma. ");
INSERT INTO cabNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ábati loúndaruniña ja ñadágimeinbaña lúma úara jáma ámu ja ñadágimeintiña ámu físiu le lenége jafísiute, ába laríñagun joun. —Wügǘriña, subúdi jumúti luágu ñulú lan wabágari láu físiu le, ");
INSERT INTO cabNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","agáamba jumáali, aríja jumeí ída líña lan lídin Páblo aríñaga luágu máma jamá búngiugu sándu ja jadǘgübaña wügǘriña, áni gíbeeña gürígia jafíñeragüdǘn, mámarügü ya Éfeso, lídan gíñe líbe-ágei Ásia. ");
INSERT INTO cabNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ñoúnguati cátei le, ladǘga gayáraabei weféridiruni wabísinisin, gayáraabei gíñe teféridiruni tilígilisin búngiu Diána tuweírigun, ábame tanügǘn búngiu Diána to únboun jájuduragua sun gürígia Ásia lúma lídan sun uboú quei ni cáta. ");
INSERT INTO cabNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Dan le jagáambunbalin cátei le, ába jagáñidun buídu, ába jagúaragun. —¡Weírigutu Diána to jabúngiute Éfesona! ");
INSERT INTO cabNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ñíñeinti ában oúnwenbun achágaraguní lídan sun ubúrugu ligía. Ába járügüdüni Gáyo lúma Aristárco, biáma wügǘriña Macedóniana ja úarabaña lúma Páblo, ába jadúruguduniña chülǘ tuágun múna to ñi lubeíja joúndaragua. ");
INSERT INTO cabNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Álugatí yebe Páblo lebélurun lun ladímurejan joun gürígia ñi lun ladílirun sun cátei, mígirun jamúti afíñetiña lun lebélurun. ");
INSERT INTO cabNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ñíñanu gíñe jádaangiñe ábutigu ñi Ásia lumádagu Páblo, oúnajatiña gíñe dimúrei lun lun mebélurun lan ñíjin. ");
INSERT INTO cabNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ñíti lídan adámurini, jíbiri agúaragua ában cátei, jíbiri agúaragua ámu, ladǘga chagágujaña gürígia, jíbe-ágei, ibídiñeti joun ca lan lébubei jadámuridagun. ");
INSERT INTO cabNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ñíñanu jádaangiñe gürígia, ába jafúnraanguágüdüni cátei le lun Alejándro, le jádajabei juríu ligíbugiñoún guríriguaü lun ladímurejan luágu jafúleisein. Ába ladǘgün Alejándro seíni láu lújabu lun jámanichun, lun ladímurejan luágu jafúleisein jagíbugiñe gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Dan jasúbudirunbalin luágu juríu lan, ába jagúarajan sun jagía lídan ában, yaráfa lun bián óra. —¡Weírigutu Diána to jabúngiute Éfesona! ");
INSERT INTO cabNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Dánti le gálumagüda láaña abǘrüjati le láni ubúrugu ligía gürígia, ába laríñagun. —Gürígia Éfesona, sun gürígia subúdi jamúti luágu Éfesona lan oúnigirubárun tilígilisin búngiu Diána, túma tiyáwa to áburujaboun siélugiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Quei úa lan ni ában lun lasígeneruni cátei le, gáluma jumá, madǘga jumá ni cáta masáminarunga jumeí buídu. ");
INSERT INTO cabNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Wügǘriña ja, ja janǘgübaña ñájoun, míwerujan jamágiru jilígilisin, madímurejan jagía wuríbati tuágu jubúngiute. ");
INSERT INTO cabNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ánjein níjein lubeí cátei uáguti labúseera Demétrio jáma ja ñadágimeinbaña lúma líchugun jadúnrun, ligía níjein lubeí agúseragüdüti lúma agúseragülei, gayáraati jídin ligíbugiñoun lúrudu lun ladímurejan cáda ában lueígiñegua. ");
INSERT INTO cabNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ánjein ámu lubeí cátei jamúriajabei, lúnti laráanserún lídan ában adámurini le richáti, ");
INSERT INTO cabNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ladǘga gayáraabei laríñawagúniwa luágu wagúbujaña lan wuríbani ladǘga cátei le asúseredubei ugúñe, ibídiñebei woun cába lan woúnabagüle ánjawa álügüdǘwa luágu chagáguaü le. ");
INSERT INTO cabNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Lárigiñe laríñaguni cátei le, ába lagúmuchaguagüdüni adámuridaguni. ");
INSERT INTO cabNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Dan le lagúmuchunbei chagáguaü Éfeso, ába loúnajan Páblo jawágu afíñetiña lun jayábin lun, gayára lámuga líchugun gurásu joun, ábati loúburuniña, ába layoúragun joun, ába lídin Macedónioun. ");
INSERT INTO cabNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Luágu luweíyasun, chülǘgueina líña jámagiñe afíñetiña lídan buri fulásu le ídaangiñebei lásügüra, ru ligía sarágu dǘgüdaguaü joun láu lerérun. Ítara líña lachǘlürün lídoun ageíraü le Grécia. ");
INSERT INTO cabNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Reídeiti ǘrüwa játi ñi Grécia, ládina yébe ugúnein lun lídin Síria, ligía lagáambun luágu jelédeguña lan juríu lubá. Ábagubeíti laráanserun lun lagíribudun múarugugíñe, sügüína ligíaya Macedóniagiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Gíbetiña wügǘriña ñǘdüntiña úara lúma. Sópater, le liraǘ Pyrrhus, Beréagiñe, Aristárco lúma Segúndo, Tesalónicagiñe, Gáyo, Dérbegiñe, Timotéo gíñe, lúma gíñe Tíquico lúma Trófimo, Ásiana. ");
INSERT INTO cabNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Afíñetiña ja, ába joúdin wabá, ába jagúrabuníwa ubúrugu Tróas. ");
INSERT INTO cabNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Wagía, lárigiñe fédu le teigín fein to magánaboun ísi, ába wáfuridun Filíposgiñe tídan ugúnein, seíngü wéyu lárigiñe, ligía wátürün Tróas, le ñí lubei wúwarada jáma ja ñǘdünbaña wabáragiñe, ába weréderun ñi sédü wéyu. ");
INSERT INTO cabNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Samúdi gúñoun, ába joúndaragun afíñetiña lun jeígin fein le jarítaguagüle luágu loúnwen Crístu, Páblo arúfudajabei joun. Queíti gaweíyasúnbei lan larúgan, ába lasígirun adímureja joun darí lúmoun amídi áriebu. ");
INSERT INTO cabNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Íñuñanu lídan lǘrüwan túbanana múna to ñí lubei joúndaragua, ñíñein sarágu lámpu durúngu. ");
INSERT INTO cabNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ñíñein ában irájü agáambaja, ñun líña luágu funédere, Eútico líribei. Queíti lílübei lapúrichijan Páblo áriebu ligía, ába ladábudun lágu irájü ligía, ába larúmugun ñi, ába leíguadun lídaangiñe lǘrüwan túbanana múna, múarugun. Dan le jarárirunbei lun jiñúraguni, jiláali. ");
INSERT INTO cabNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ábati larárirun Páblo, ába laroúnrun ligíbuagu irájü ligía, ába loúburuni. Ába laríñagun joun afíñetiña. —Madíjeri jumá, gabágariyaali. ");
INSERT INTO cabNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ábayati lawárirun Páblo, ába jafánreinragunun fein, ába jeígin. Ábati lasígirun adímureja darí larúgadun, ligíaali lídin. ");
INSERT INTO cabNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Irájüti buga ligía, ába janǘgüni águyu wínwañu, sun jagía láu ugúndani láu. ");
INSERT INTO cabNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ába gíñe woúdin, ába wádinun tídoun ugúnein, ába woúdin chülǘ Asón, le ñí lubei lúnti lan wabúduni Páblo quei wadáradun, ladǘga busén lan lídin Asón múarugugíñe. ");
INSERT INTO cabNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Dan le wadúnragun lúma ñi Asón, ába ládinun wáma, ába woúdin Mitiléne. ");
INSERT INTO cabNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Larúgan, ába wáfuridun ñígiñe, sügüína wagía ligíbugiñe uboúju Quío, ában wéyu lárigiñe, ligía wachǘlürün uboúju Sámos. Ába weméraagun ubúrugu Trojílio, larúgan, ligía wachǘlürün ubúrugu Miléto. ");
INSERT INTO cabNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Mátürüntiwa ubúrugu Éfeso luágu waweíyasun ladǘga mabúseerun lan Páblo leréderun sarágu dan ageíraü Ásia, busénti lachǘlürün Jerusalén furése lun ñi lan lubá fédu le Pentecostés ánjein gayára. ");
INSERT INTO cabNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Dánti le Milétojadiwa, ába loúnajan Páblo jawágu tábutigu ligílisi Éfeso lun jayábin Miléto aríjei, ");
INSERT INTO cabNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","dan le jachǘlürünbei, ába laríñagun joun. —Subúdi jumúti ída líña lan nigáburi lúmagiñe furúmiñeti wéyu nachǘlürün Ásioun. ");
INSERT INTO cabNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Sun dan le jagánaguañadina lubeí, seríwitina lun Búngiu láu ǘnabuni, láu sarágu águiraü, súfuri áu sarágu láu cátei lé buri jabúseerubei juríu jadǘgün nun. ");
INSERT INTO cabNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Merédeti napúrichijan jun luágu cátei le lúnbei buídubei lan jun, arúfudaja áu jun furáangu lídan guríriguaü lúma júbiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Dándu joun juríu quei joun ja mámabaña juríu, aríñagaadina luágu lúnti lan jasáansiruní joúserun ligíbugiñe Búngiu, lúma lun jafíñerun luágu Wabúreme Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Guetó lubeíti neíbuga Jerusalén, loúnajan Sífiri Sándu. Ibídiñeti nun cába lan asúsereda nun ñi, ");
INSERT INTO cabNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","lé rügǘñein nasúbudirubei, luágu sun lan ubúrugu le ñí lumuti nídin, aríñagati Sífiri Sándu nun luágu nadaürǘba lan, nasúfuriruba sarágu, Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Úati ni cáta lídaangiñe áuti nebéresera, ni nibágari guánarügü, mebégiti ni cáta nun, adǘgarügü náali ligía le uágubei loúnajana Búngiu láu ugúndani darí lúmoun lagúmujoún, lun nadímurejani ugánu buíti luágu línsiñejabu Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","‘Guetó, choúru numúti luágu maríjindügüya láadina lan ni ában jídaangiñe, jugúya lé meja únbei napúrichija luágu larúeijan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ligía naríñagunbei jun ugúñe luágu masándiragun nan núngua láu dúru lueígiñe ni ában jídaangiñe, ");
INSERT INTO cabNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ladǘga subúdigüda náali sun laráansejan Búngiu jun, marámuduntina ni cáta jueí. ");
INSERT INTO cabNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Toúnigigua jumá lubeíti júngua, toúnigi jumáñame afíñetiña ja líchugubaña Sífiri Sándu lun joúnigiruniña, ja tánigu lilígilisin Búngiu, ja lagáñijabaña láu líta Liraǘ guánarügü. ");
INSERT INTO cabNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Subúdi numúti luágu dánme lan nídin, jayábinba lan ámu áluga jagǘnrinchaguni jafíñen, quei lebélurun geígusi jádoun mudún áfaraguaña. ");
INSERT INTO cabNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ñíbaña jídaangiñe guánarügü, lubáragiñe jamúga jarúfudajani inárüni, jarúfudajabei iyéeni lun jafálaruniña afíñetiña. ");
INSERT INTO cabNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Toúnigi jumá lubeíti, jarítagua jumeí luágu ǘrüwa lan irúmu náu ewéridijaün wéyuagu áriebu, ayájua buri áu. ");
INSERT INTO cabNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","‘Guetóti, nidújeñu, derége numútün lun Búngiu lúma lun ugánu le luáguti línsiñejabu, le gabáfubei lun léredagüdüni jafíñen lúma lun líchugun ubáraü jun siélu jádan ja derégeguáañabaña joúngua lun. ");
INSERT INTO cabNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mabúseerun nágili ni liseínsun ni ában, ni lanáangun, ");
INSERT INTO cabNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","lubáragiñe líra, subúdi jumúti luágu ñadágimein nan lun nibíjini le nemégeirubei lúma le jemégeirubei ja númabaña. ");
INSERT INTO cabNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Súnwandan narúfudajan jun luágu ítara líña lan luwádigimariniwa lun jíderawagún ja níjeinbei jemégeirun, luágu gíñe lúnti lan larítawagún luágu dimúrei le laríñagubei Wabúreme Jesúsu dan le laríñagunbei. “Gúndaatimáati le íchugubei sügǘ láu le erésibirubei.” ");
INSERT INTO cabNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Lárigiñe laríñaguni Páblo cátei le, ába lájuduragun, ába layúmuragun lun Búngiu jáma súngubei. ");
INSERT INTO cabNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ába jayájun súngubei láu igárigu, ába joúburuni Páblo, ába jachúuruni. ");
INSERT INTO cabNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Jírutiñati ladǘga laríñagun joun luágu maríjindügüya jamáali lánme. Ába joúdin íchaajei tuágu ugúnein. ");
INSERT INTO cabNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Dan le wígiruniña afíñetiña, ába woúdin sügǘlügü lídoun fulásu le gíribei Cos, larúgan, ában woúdin Ródas, ñígiñe Ródasgiñe woúdin lun Pátara. ");
INSERT INTO cabNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ñi Pátara wadárira ában ugúnein teíbuga Fenícia, ába wádinun tídoun, ába woúdin. ");
INSERT INTO cabNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Dan wásügürün, ába waríjini uboúju le Chípre, ába wígiruni lueígiñe wabaǘna, ába wasígirun darí wachǘlürün Síria. Queíti taráriguágüdüba lan ugúnein lídan ubúrugu le gíribei Tíro, ába warárirun ñi. ");
INSERT INTO cabNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Áluaja wamútiña afíñetiña ja ñíbaña, ába weréderun sédü wéyu jáma ñi. Ába lawísaruniña Sífiri Sándu luágu lasúfuriruba lan Páblo Jerusalén, ába jaríñagun lun lun mídin lan. ");
INSERT INTO cabNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Dan lásügürün sédü wéyu ligía, ába woúdin. Sun afíñetiña jáu jámarigu jáma jasáanigu, ñǘdüntiña íchaajawa chülǘ boúgudi lueí ubúrugu, ñi béyabu ába wájuduragun ayúmuragua lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ábati woúburagun woúngua jáma, ába wádinun tídoun ugúnein, jagía, ába jagíribudun jábiñoun. ");
INSERT INTO cabNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ába wagúmuchuni waweíyasun baránaja lúmagiñe ubúrugugiñe Tíro darí Tolemáida, le ñí lubei wabúsura joun afíñetiña, ába weréderun ában wéyu jáma ñi. ");
INSERT INTO cabNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Larúgan, ába láfuridun Páblo wáma, wagía le lúmabei, ába wachǘlürün ubúrugu Cesaréa. Ñi woúdin lúbiñe Felípe le apúrichijabalin ugánu luáguti Jesucrístu, ába gíñe jádaangiñe sédü wügǘriña já meja anúadajoúbaña Jerusalén lun jeténirun lun le jemégeirubei afíñetiña, ába weréderun lúma. ");
INSERT INTO cabNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Gasáaniguti Felípe gádürü würíña irájüñü ja máfuridungiña, ibíja jamúti ubáfu lúmagiñe Búngiu lun ladímurejan jayúmulugugiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Átiri wéyu wáu ñi, ligía lachǘlürün ában proféta Judéagiñe, gíriti Ágabo, ");
INSERT INTO cabNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","liábiña aríjawa. Ába lanǘgüni lubélitin Páblo, ába lagǘraguni lugúdi guánarü lúma lújabu láu, ába laríñagun. —Laríñajare Sífiri Sándu luágu ítara lúba lan jagǘraguni juríu labúreme béliti le ubúrugu Jerusalén, ábame jedéregeruní joun ja mámabaña juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Dan wagáambuni cátei le, wagía jáma Cesaréana, ába wayúmuragun lun Páblo lun mídin lan Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ába laríñagun Páblo. —¿Ca uágu jayájua, írudagüdána? Aráansetina mámarügü lun nagǘrawagún Jerusalén, aráansetina darí lun noúnwen lueígiñe Nabúreme Jesúsu. ");
INSERT INTO cabNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Quei siñá wamani larítagun agáñeira, ába wígiruni, ába waríñagun lun ladügǘniwa lugúndan Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Dan le gumújali webélujan ñi, ába waráanserun, ába woúdin Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ñǘdütiña jádaangiñe afíñetiña wáma Cesaréagiñe, ñíñein ában Chíprena jádan, gíriti Mnasón, lǘjali lueígiñe lafíñerun luágu Jesucrístu, lúbiñeba wagánawa. ");
INSERT INTO cabNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Dan wachǘlürün Jerusalén, ába jerésibiruníwa afíñetiña láu ugúndani. ");
INSERT INTO cabNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Larúgan, ába woúdin lúma Páblo aríjei Jacóbo, ñíñanu gíñe sun tábutigu ligílisi Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ába labúsurun Páblo joun, ába labájüdaguni sun cátei le ladǘgübei Búngiu lídaangiñe joun, jádan ja mámabaña juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Dan le jagáambunbalin ugánu le, ába jadímurejan luágu luweírigun Búngiu. Ábati jaríñagun lun Páblo. —Wadúje, aríjabásan, añájein sarágu mílu juríu afíñerutiña luágu Jesucrístu, áni sun jagía, aríñagatiña luágu lúnti lan lasígirúniwa lilúrudun Moisés. ");
INSERT INTO cabNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Aríñawagúaali joun luágu arúfudaja ban joun sun juríu ja aganoúbaña lídan jageíra ja mámabaña juríu lun madǘgün jamá gásu luágu lé meja laríñagubei Moisés, áni aríñaga bán nege joun lun merésibirun jamá jasáanigu circuncisión, mafála jameíme wagáburi, wagía juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Cábasan wadǘga? Joúndaragubátia juríu dánme le jasúbudiruni luágu chülǘjadibu lan, lun jadǘgün wuríbani bun. ");
INSERT INTO cabNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Niján cátei le lúnbei badǘgüni. Añájein gádürü wügǘriña ya wádan, gásu jagúnfulirun ában darádu lúma Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Barǘbaña búmagua, ábame barúmadaguágüdün búngua jáma ligíbugiñe Búngiu según wagáburi, wagía juríu, fáyeibeíme le jagástarubei lun jagúnfulirun lúma jadáradun, lárigiñeme gayáraajalíme jásaragüdüni jádiburi. Ítara lúba jaríjini sun juríu luágu iyéeni lan le aríñawagúbei joun buágu, gúnfulirügütibu lan gíñe lúma lilúrudun Moisés quei lubúdubu. ");
INSERT INTO cabNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ánjeinti jawágu ja mámabaña juríu áni afíñejaña luágu Búngiu, abǘrüjaadiwa joun lun madíjeri jamá luágu buri cátei le, lúnrügü meígin jamá úwi le dagágüdawaali joun sándu, ni jítaü, ni anímaalu le tigíwarügüti, lun gíñe úa lan ni ában agámariduti wǘri to mamárieiduntu lúma. ");
INSERT INTO cabNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ábati lanǘgüniña Páblo gádürü wügǘriña jagía, larúgan, ába larúmadaguagüdün lúngua jáma, ába lebélurun témpulurugun awísaja ídaba lan lagúmucha jawéyuri gádürü wügǘriña jagía lun jarúmadun, léme lidáani jadágaragüdün cáda ában jádaangiñe lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Dan lé yebe yaráfaali lun lagúmuchun sédü wéyu ligía lubá lagúmuchun jarúmadun ligíbugiñe Búngiu, ába jaríjini jádaangiñe juríu Ásiana Páblo témpulurugu, ába jachágaraguágüdüniña gürígia. Ába járügüdüni Páblo, ");
INSERT INTO cabNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ába jagúaragun. —¡Wügǘriña Israelítagu, íderagua jumáwa! Niján wügǘri le eíbugubalin sun fulásu arúfudaja joun sun gürígia wuríba luágu wanásiñun, luágu lilúrudun Moisés, lúma tuágu témpulu to, belúgüdaali gíñe gürígia ja mámabaña juríu témpulurugun awíyedei fulásu sándu le ligíbugiñe Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Jaríñagunbei ítara ladǘga meja jaríjini Páblo ubúrugu lúma Trófimo le Éfesona, jarítaguatíñati luágu barǘlaani témpulurúgun. ");
INSERT INTO cabNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ába jachágaragun sun lílana fulásu, ába jayábin gürígia eíbaagueina. Ábati járügüdüni Páblo, ába jadúruguduní boúgudin tueí témpulu, ába jadáuraguni béna furése. ");
INSERT INTO cabNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Busénjaña yebe jáfaruni jilágubei, ligía lachǘlürün ugánu lun gumándan luágu chagágujaña lan sun lílana ubúrugu Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ábati loúndaraguniña gumándan lisúdaaranigu jáma jábutigu, ába lachǘlürün eíbaagueina le ñíjin jabeí gürígia. Dan jaríjini gumándan jáma súdaaragu, ába lásurun jabeíchuni Páblo. ");
INSERT INTO cabNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ábati layárafadun gumándan, ába lárügüdüni Páblo, ába lagǘraguágüdüni láu bián güríngüri, lárigiñe, ába lálügüdajan cátei lan, lúma ca lan lidúnrunbei. ");
INSERT INTO cabNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ámuñegueinarügüti cátei jaríñagun gürígia, siñátiti gunfaráanda lan gumándan ni cáta ladǘga ireíni le jadǘgübei, ába lanǘgagüdüni jábiñoun súdaara. ");
INSERT INTO cabNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Dan le jachǘlürünbei luágu testépute múna, ába janǘgüni súdaara Páblo oúyuajeina lueí jáfaruni gürígia jilágubei, ");
INSERT INTO cabNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ladǘga jayábiña súngubei járigi agúarajeina. —¡Jilála! ");
INSERT INTO cabNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Dan lé yebe jádaraali lan Páblo múnadoun, ába laríñagun lun gumándan le jáubei súdaara. —¿Gayáraati nadímurejan búma? Ába laríñagun gumándan lun. —¿Geréngaditibu güriégu? ");
INSERT INTO cabNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Máma lubeí bugúya Ejíptona lé meja adǘgübei ában mabúchajaü luágu ában dan, ába lanǘgün gádürü mílu wügǘriña gáfarajatiña lídoun fulásu mageírawaguti? ");
INSERT INTO cabNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Laríñagati Páblo lun. —Máma áu, juríu áu, Társona, ában fulásu weíriguti Cilícia. Adǘgabá fuleísei nun lun bígirunina lun nadímurejan joun gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ába líchugun gumándan ǘma lun, ába laráramun Páblo luágu estépu, ába líchugun seíni láu lújabu joun gürígia lun jámanichun. Dan le manígaali, ába ladímurejan joun lídan hebréo, le jerérun juríu, ába laríñagun. ");
INSERT INTO cabNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Nidújeñu jáma jagǘbürigu, agáamba jumeí le lúnbei naríñaguni jun nueígiñegua. ");
INSERT INTO cabNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Dan jagáambun ladímurejan joun lídan jerérun, ábatima jámanichaguágüdün. Ábati laríñagun joun. ");
INSERT INTO cabNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Juríu áu, le gumúti, ubúrugu Társo loúbawagu Cilícia nagǘriajoúa, ya Jerusalén naweírida. Lábugiñe larúfudajan Gamáliel natúriaja, úarati larúfudajan lúma jalúrudun binádu wagǘbürigu. Joúchatina súnwandan lun nesériwidun lun Búngiu táu sun nanígi, queígubeirügü ligáburi jadǘgüni jugúya ugúñe wéyu. ");
INSERT INTO cabNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Áu, eíbaaja numútiña meja lánigu Crístu darí náfaraguniña jilágubei, barǘgua áu wügǘriña furísunrugun. ");
INSERT INTO cabNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Geféenti fádiri íñutimaati jáu sun jábutigu juríu luágu rújama gárada nun joun wapaísanu ja Damáscobaña. Ñǘdüntina ñi áluajaña afíñetiña luágu Crístu lun nanǘgüniña ñájoun lun nasúfuriragüdǘniña. ");
INSERT INTO cabNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","‘Dan luáguñadina lubeí ǘma, yaráfaadina lun nachǘlürün Damásco, queíburi amídirugu, sódini ligía ladúnraagun ában oúnwenbun larúgounga siélugiñe náu, ");
INSERT INTO cabNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ába náburujan múarugun. Ába nagáambun laríñagun ában umálali nun. “Sáulo, Sáulo, ¿ca uágu beíbaajanina?” ");
INSERT INTO cabNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ábati naríñagun. “¿Cátabusan Nabúreme?” Laríñaga nun. “Jesúsu le Nazarétna áu, le méme beíbaajabei.” ");
INSERT INTO cabNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Aríja jamúti ja úarabaña núma larúgounga ligía, ába janúfudedagun, magáambun jamúti lumálali le adímurejabei nun. ");
INSERT INTO cabNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ábati naríñagun. “¿Cábagi nadǘga, Nabúreme?” Ába laríñagun nun. “Sarába, beíba luágu buweíyasun Damáscoun, ñíba laríñawagúa sun le lúnbei badǘgüni bun.” ");
INSERT INTO cabNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Queíti maríjingüda láadina lubeí buga larúgounga ligíra, ába járügüdüni ja númabaña nújabu darí wachǘlürün Damásco. ");
INSERT INTO cabNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","‘Ñiñein ában wügǘri Damásco gíriti Ananías, gúnfuliti buídu lúma lilúrudun Moisés, sun juríu ja aganoúbaña Damásco adímurejatiña buídu luágu wügǘri ligía. ");
INSERT INTO cabNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ába liábin Ananías aríjana, dan lachǘlürün, ába laráramun nubádu, ába laríñagun nun. “Nidúje Sáulo, ibíjayabeí baríjin lárigoún.” Lídan méme óra ligía, ába léfegechun nágu, ába naríjini. ");
INSERT INTO cabNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ábati laríñagun nun. “Anúadaja láadibu Jabúngiute binádu wagǘbürigu lúmagiñe binárü lun basúbudiruni lugúndan, lúma lun baríjini Jesúsu le richáguabei, lun bagáambuni lumálali, ");
INSERT INTO cabNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ladǘga bíchuguba lan fe luágu Jesúsu joun sun gürígia, abájüdaguabeíme le aríja báalibei lúma le agáamba báalibei. ");
INSERT INTO cabNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Guetóti, ¿ca uágu badárasaja? Sarába, badíseibá jeménigiñu luágu Wabúreme lun lachíbun bifígoun.” ");
INSERT INTO cabNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","‘Dan nagíribudun ubúrugun Jerusalén, luágu ában wéyu dan le nídin témpulurugu ayúmuragua, ába lasáliragun Nabúreme Jesúsu nun, ");
INSERT INTO cabNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ába laríñagun nun. “Furíba yágiñe Jerusaléngiñe, oúfuda, ladǘga madǘgünbaña juríu gásu láu le baríñagunbei nuágu lídan fulásu le.” ");
INSERT INTO cabNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ábati naríñagun lun. “Nabúreme, subúdi jamúti luágu ñǘdü nán buri méja tídan sun jalígilisin afíñetiña anáajaña ja afíñebaña buágu furísunurugun, beí buri náña. ");
INSERT INTO cabNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Dan le láfarúnbei Estéban jilágubei, le bánigu lé meja adímurejabei buágu, ñíñadina, gúndaatina láu jáfaruni, áu oúnigirubárun janáangun ja áfarubalín.” ");
INSERT INTO cabNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ába laríñagun Nabúreme nun. “Beíba, ladǘga noúnajadibu díse, apúrichija joun ja mámabaña juríu.” ");
INSERT INTO cabNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Agáamba jamúti chülǘ lúmoun ladímurejan luágu lídin apúrichija joun ja mámabaña juríu, ába jagúmeserun agúaraja. —¡Áfara jumeí jilágubei! ¡Maríchati lun labágaridun! ");
INSERT INTO cabNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Queíti jasígirun agúaraja, achǘjoun buri janáangun, achǘja calíqui íñun le jagáñi, ");
INSERT INTO cabNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ába laríñagun gumándan lun ladarúniwa Páblo jábiñoun súdaara, ába loúnajan abeíchei lun ladímurejan, lun lasúbudirúniwa ca lan uágu jagúaraja gürígia luágu ítara. ");
INSERT INTO cabNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Dan le gürágua jamáali lun jabeíchuni, ába laríñagun Páblo lun jábuti súdaara le ñíbei. —¿Garíchatünsan lun jabeíchun ában wügǘri Rómana, magúserunga ligía? ");
INSERT INTO cabNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Dan le lagáambuni jábuti súdaara cátei le, ába lídin aríñaga lun gumándan. —Toúnigibátia láu le lúnbei badǘgüni, Rómanatia wügǘri le. ");
INSERT INTO cabNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ábati lídin gumándan luágun Páblo, ába laríñagun lun. —¿Inárüni luágu Rómana ban? Laríñaga Páblo lun. —Ánja. ");
INSERT INTO cabNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ábati laríñagun gumándan. —Fáyeitina sarágu seínsu lun Rómana nan. Laríñaga Páblo. —Ánjein áu, ñi nagǘriajoúa. ");
INSERT INTO cabNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ába jígiruni já yebe lúnbei jabeíchuni furése, liábin gíñe gumándan, dan le lasúbudiruni luágu Rómana lan Páblo, ába lanúfudedagun lueígiñe lagǘraguni. ");
INSERT INTO cabNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Larúgan, busénti gumándan lasúbudiruni ca lan lidúnrunbei Páblo jarúma juríu, ába lagídaruni güríngüri lueí, ába loúndaraguágüdüniña jábutigu fádirigu jáma lúrudugu juríu ja íñutimáabaña, ábati laságaruni Páblo, ába líchuguni jagíbugiñe. ");
INSERT INTO cabNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Ába laríjin Páblo jawágun lúrudugu jagía, ába laríñagun joun. —Nidújeñu, jarúmati nasándiragun núngua ligíbugiñe Búngiu chülǘ lúmoun wéyu le. ");
INSERT INTO cabNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ábati loúnajan Ananías, fádiri le íñutimaabei, lun jagáyuajan ja yaráfabaña ñi luágun liyúma Páblo. ");
INSERT INTO cabNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ába laríñagun Páblo lun. —¡Lagáyuajaba Búngiu buágu, biángua tigíbu bugúya le! Ñun bíña ñi lun bagúseragüdünina quei laríñaguni lúrudu, ¿cáti uágu bagáyuagüda nuágu, adǘraaguei lúrudu? ");
INSERT INTO cabNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ába jaríñagun ja ñíbaña lun. —¿Ítara liñásan banábuni fádiri le íñutimaabei le láni Búngiu? ");
INSERT INTO cabNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ába laríñagun Páblo. —Nidújeñu, ibídiñetí yebe nun luágu fádiri lan le íñutimaabei, ladǘga taríñajare Lerérun Búngiu. “Madímurejaanbadibu wuríba luágu ában agúmadijati bageíra.” ");
INSERT INTO cabNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Subúdi lumúti Páblo luágu jánigu lan saduséogu jíbiri ja ñíbaña, jíbiri, jánigu fariséogu, ába laríñagun láu umálali jéreti. —Nidújeñu, fariséo áu, jádaangiñetiña fariséogu nagǘbürigu, áni jagúseragüdǘñadina ladǘga afíñe nan luágu jásaaruba lan jiláaña lídaangiñe oúweni lúnya jabágaridun. ");
INSERT INTO cabNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Dan le laríñagunbálin cátei le, ába jagúmeserun fariséogu jáma saduséogu asígeneja jámagua, ába lafánreinragun adámurini. ");
INSERT INTO cabNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ladǘga jaríñajare saduséogu luágu másaarunbaña lan jiláaña lídaangiñe oúweni, úatiña nege gíñe ánjeligu, ni espíritugu, ánjañati fariséogu, afíñetiña luágu sun cátei le. ");
INSERT INTO cabNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Jareínchati súngubei, ába jásaarun jádaangiñe arúfudajatiña lilúrudun Moisés ja ñíbaña, áni fariséogu gíñe jagía, ába jaríñagun. —Wügǘri le, úati ni cáta wuríbati ladǘga, áni ánjeindügü ában lubeí espíritu adímurejabei lun o ában lan ánjeli, toúnigi wamátia lueí wadárirún oúcha weréderuni luwádigimari Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Weírijali sigénei darí lun lanúfudedun gumándan lueí jáfaruni Páblo jilágubei. Ábati loúnajaniña lisúdaaranigu lun jaságaruni Páblo lídaangiñe adámurini lúnya janǘgüni jábiñoun súdaara. ");
INSERT INTO cabNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Le ában áriebu, ába lasáliragun Wabúreme Jesúsu lun Páblo, ába laríñagun lun. —Manúfudebá, Páblo, ladǘga ítara quei rújadibu lan fe nuágu ya Jerusalén, bíchuguba gíñe fe nuágu, Róma. ");
INSERT INTO cabNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Larúgan, ába jebélurun juríu lídoun úarani lun jáfaruni Páblo jilágubei, ába jaríñagun láu íñaraguni ligíbugiñe Búngiu luágu meíginbaña lan, mátun jagíame ni cáta darí jáfaruni. ");
INSERT INTO cabNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Joúgiñe bián-wein wügǘriña ja aríñagubalin cátei le. ");
INSERT INTO cabNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ábati joúdin jámoun jábutigu fádirigu lúma jámoun wügǘriña weírigutiña jádan juríu, ába jaríñagun. —Aríñagaadiwa láu íñaraguni luágu meíginbadiwa lan ni cáta darí wáfaruni Páblo jilágubei. ");
INSERT INTO cabNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Guetóti, jugúya jáma ja jíbiri lúrudugu íñutimaatiña amúriaja jumá lúma gumándan lun lanǘgüni jun jarúga, jaríñagame lun luágu lun lántima jálügüdüni luágu dúru le rúwaalíbei luágu jabúseera jaríjini. Wagía, aráanseñu wába lun wáfaruni lubáragiñe lachǘlürün. ");
INSERT INTO cabNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ába lachǘlürün cátei le lábun lagáambun tiraǘ lítu Páblo, ába lídin jábiñoun súdaara asúbudiragüdei lun Páblo. ");
INSERT INTO cabNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ábati lagúarun Páblo lun ában jádaangiñe jábutigu súdaara, ába laríñagun lun. —Barǘbei irájü le lúmoun gumándan, níjein cátei lun laríñaguni lun. ");
INSERT INTO cabNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ába lanǘgüni jábuti súdaara lúmoun gumándan, ába laríñagun lun. —Wáti adaürǘti Páblo nun, ába lamúriajan núma lun nanǘgüni irájü le bun ñájoun, níjein nege cátei lun laríñaguni bun. ");
INSERT INTO cabNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ába lárügüdüni gumándan lújabu irájü ligía, ába lanǘgüni lun jábugua jamá, ába laríñagun lun. —¿Ca babúseerubei baríñagun nun? ");
INSERT INTO cabNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ábati laríñagun irájü ligía lun. —Belújaña juríu lídoun úarani lun jamúriajan búma lun banǘgüni Páblo jagíbugiñoun lúrudugu íñutimaatiña lún nege jálügüdünitima luágu lidúnrun. ");
INSERT INTO cabNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Mafíñerabá joun, añájein joúgiñe bián-wein jawǘgüriña arámudagu jabá ǘmada agúrabajei lun jáfaruni jilágubei. Aríñagaaña láu íñaraguni ligíbugiñe Búngiu luágu meíginbaña lan, mátun darí jáfaruni Páblo, guetó aráanseñu jáña, jagúraba rügǘñein boúnabagüle. ");
INSERT INTO cabNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ábati loúnajani gumándan irájü ligía águyu, aríñageina ligía lun lun maríñagun lan ni ca un luágu abájüdagua láali lan cátei le lun. ");
INSERT INTO cabNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ába lagúarun gumándan joun bián jádaangiñe jábutigu súdaara, ába laríñagun joun lun jaráanserun bián-san súdaara lun joúdin Cesaréa eíbu, úara jáma ǘrüwa-wein-díisi ja jawágutiña gabáyu, jáma bián-san ja táutiña efeín, lun joúdin ladaǘnrün néfu gúñoun. ");
INSERT INTO cabNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Aráansegüdáti gíñe gabáyu lun laweínjaniña Páblo, ru ligía dimúrei lun jachǘlüragüdǘni Páblo lúmoun gumádimati Félix láu magádiei. ");
INSERT INTO cabNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Oúnajati ában gárada jáma, laríñajare tídan gárada tugúya. ");
INSERT INTO cabNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Lúmagiñetu Cláudio Lisías lun gumádimati Félix le weírigubei, mábuga níña bun. ");
INSERT INTO cabNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Niján wügǘri le, le noúnajabei bun, daǘjamaali yebe juríu áni jáfaraali yebe jilágubei, dan le nasúbudirúnbalin luágu Rómana lan, ába nídin jáu nisúdaaranigu, ába neséfuruni. ");
INSERT INTO cabNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Queíti nabúseerun nasúbudiruni ca lan lidúnrunbei jarúma, ába nanǘgüni jagíbugiñoun lúrudugu juríu íñutimaatiña. ");
INSERT INTO cabNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Lidúnrun jarúma luáguti buri cátei le luáguti jalúrudun, úati iríchaü lun láfarún jilágubei, ni íbini lun ladaürǘn. ");
INSERT INTO cabNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Quei lachǘlürün lábun nagáambun luágu jaráansejaña lan juríu lun jáfaruni jilágubei, ligía lébubei noúnajani bun madárasajaanga. Aríñagaadina gíñe joun ja íchugubaña lidúnrun lun búma lan jaráanserei le jánibei lúma.” ");
INSERT INTO cabNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ábati janǘgüni súdaara Páblo quei laríñawagúniwa joun, áriebu, chülǘ Antípatris. ");
INSERT INTO cabNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Larúgan, ligía jagíribudun súdaara ja eíbubaña, súdaara ja jawágubaña gabáyu, ába jasígiruni jaweíyasun láu Páblo. ");
INSERT INTO cabNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Dan le jachǘlürünbei Cesaréa, ába jedéregerunun gárada lun gumádimati, derége jameí gíñe Páblo. ");
INSERT INTO cabNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Lárigiñe lalíijanun gumádimati gárada, ába lálügüdajan jalíana lan Páblo, dánti le lasúbudirúnbalin luágu Cilíciana lan, ");
INSERT INTO cabNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ába laríñagun lun. —Nagáambubadibu dánme le jayábin ja íchugubaña bidúnrun. Ábati líchugun dimúrei lun líchugúniwa Páblo tídoun palásiu tó meja lábunaguboun Heródes, jáu oúniri. ");
INSERT INTO cabNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Seíngü wéyu lárigiñe, ába lachǘlürün Ananías, fádiri le íñutimaabei, ubúrugun Cesaréa jáu wügǘriña jádaangiñe juríu weírigutiña, lúma ában wügǘri le subúdijabuti lun lúrudu, gíriti Tértulo. Ába jayábin lúmoun gumádimati lun jíchugun lidúnrun Páblo. ");
INSERT INTO cabNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Dan le lanügǘniwa Páblo jagíbugiñoún, ába lagúmeserun Tértulo íchiga lidúnrun, laríñaga. —Luágu bareíni, gumádimati, lǘjadiwa láu darángilaü ya wageíra, buíti leíbugun sun cátei ya fulásurugu súnwandan lábugiñe lichú báu. ");
INSERT INTO cabNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ibíja wamúti sun le, áni teínqui wamútibu luágu. ");
INSERT INTO cabNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Lun magídarun wamáni bidáani sarágu, amúriajatina búma lun badǘgün murúsun fuleísei woun lun bagáambuníwa luágu murúsun óra. ");
INSERT INTO cabNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Niján wügǘri le Páblo, beréseti, lerédera afánreinraguagüdaña juríu lídan sun fulásu, ligía gíñe ában jádaangiñe lichǘgüdinabei jadámurin nazarénugu. ");
INSERT INTO cabNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Álugati gíñe lawíyedagüdünun témpulu ligíbugiñe Búngiu láu lebélaagüdün ában wügǘri le mámabei juríu tídoun. Ába wárügüdüni, ába yebe wabúseerun wagúseragüdǘni láu ligáburi walúrudun, ");
INSERT INTO cabNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ába leméterun gumándan Lísias ñíjin, ába lagídaruni waweí láu érei, ");
INSERT INTO cabNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ába laríñagun luágu ja lan íchugubaña lidúnrun lúnti lan jayábin búmoun. Gayáraati bálügüdaguni Páblo, subúdi bámugei inárüni luágu sun cátei le, le waríñagubei luágu. ");
INSERT INTO cabNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Juríu buri ja ñíbaña, aríñagatiña gíñe luágu inárüni lan sun le laríñagubei Tértulo. ");
INSERT INTO cabNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ába ladǘgün gumádimati seíni lun Páblo lun ladímurejan, ában laríñagun Páblo. —Lau sun nugúndan nadímureja nueígiñegua bigíbugiñe ladǘga subúdi náani luágu lúmagiñe lan sarágu irúmu bagúseragüdajan lídan fulásu le. ");
INSERT INTO cabNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Gayáraati bálügüdajan ánjein inárüni lubeí le lúnbei naríñaguni bun. Dúusurügügili wéyu lueígiñe nachǘlürün ubúrugun Jerusalén lun nájuduragun lun Búngiu, ");
INSERT INTO cabNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","madárirúnwatina asígeneja ni ca úma, ni achágaraguágüdaña gürígia témpulurugu, ni tídan buri tíbiri jalígilisin juríu, ni lídan buri ámu fulásu ubúrugu. ");
INSERT INTO cabNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Gürígia ja, siñáti jarúfuduni luágu inárüni lan ni ában lídaangiñe sun cátei le jaríñagubei nuágu. ");
INSERT INTO cabNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ában cátei naríñagubei bun, luágu nesériwiduña lan lun Jabúngiute nagǘbürigu quei larúfudajani Jesucrístu, le uágubei jaríñaga luágu marícha lan. Afíñetina luágu sun le bürǘwañubei tídan buri líburu to lánina lilúrudun Moisés lúma lé meja jabǘrüjabei profétagu. ");
INSERT INTO cabNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Níjein gíñe eménigini le jawágubei nuágu luágu Búngiu, luágu lásaaragüdübaña lan jiláaña, dándu ja buídubaña quei ja wuríbabaña. ");
INSERT INTO cabNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ligía náfaagunbei súnwandan lun madúnrun nan ligíbugiñe Búngiu lúma jagíbugiñe gürígia. ");
INSERT INTO cabNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","‘Lárigiñe átiri dan náu eíbugei ámu buri fulásu, ába nagíribudun nageíroun lun nedéregerun seínsu joun gudémetiña Jerusalén lúma lun nadágaragüdün lun Búngiu. ");
INSERT INTO cabNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nadǘgüñein yebe cátei le témpulurugu lárigiñe narúmudaguagüdün núngua quei le igáburi, ligía jadárirunina átiri juríu loúbawaguna Ásia ñi témpulurugu, úatiña sarágu gürígia ñi, ni chagáguaü. ");
INSERT INTO cabNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Jagía lúnbaña jayábin arúfudagua joúngua ya lun jaríñaguni le lúnbei jaríñaguni ánjein níjein lubeí lúnti jaríñaguni nuágu, ");
INSERT INTO cabNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","jaríñaguni lan ja yábaña ánjein darí jabei nidúnrun dan le ligíbugiñe nubeí líñun-ágei lúrudu juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Siñáti jaríñagun ni cáta nuágu, lueídügüya luágu lan ában wéyu dan le jádaañadina lubeí, ába nagúaragun aríñaga. “Jagúseragüdüñadina ugúñe lueígiñe afíñe nan luágu jásaaruba lan jiláaña lídaangiñe oúweni lúnya jabágaridun.” ");
INSERT INTO cabNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Subúsiti sarágu luágu larúfudajan Jesúsu lun gumádimati Félix, ítara líña, dan le lagáambunbalin le laríñagunbei Páblo luágu jásaarun jiláaña, ába lagúmuchaguagüdüni adámurini, aríñageina ligía. —Nagúseragüdübei wügǘri le dánme le lachǘlürün gumándan Lisías. ");
INSERT INTO cabNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ábati laríñagun Félix lun jábuti súdaara lun lasígirun Páblo daǘwañu, lun furáangu lan lun gayára lan joúdin lumádagu aríjei, eténira lun. ");
INSERT INTO cabNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Átiri wéyu lárigiñe, ábaya lachǘlürün Félix túma Drusíla to lúmari, to juríu, ubúrugun Cesaréa, ába lagúaragüdün luágu Páblo lun ladímurejan lun luágu Jesucrístu. ");
INSERT INTO cabNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Dan le ladímurejaanbei Páblo lun luágu ibágari le surúbei, lúma luágu ágüdaagúni únguaü lueí le wuríbabei, lúma luáguti wéyu le lúnbei lagúseragüdüniña Búngiu sun gürígia, ába lanúfudedagun Félix, ába laríñagun lun. —Beíba yebe, dánme le gadáani nan, nagúarayaba bun. ");
INSERT INTO cabNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Agúrabatí yebe giñe Félix lun líchugun Páblo seínsu lun lun lígiragüdüni, ligía, dan méme lubeí wájali luágu lun layánujan lúma. ");
INSERT INTO cabNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Sügǘti bián irúmu ítara, ábati lagúmuchun lagúmadijan Félix, ába lárügüdüni Pórcio Fésto lufúlasun. Queíti busén lan Félix leréderun buídu jáma juríu, ába lígiruni Páblo daǘwañu. ");
INSERT INTO cabNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ábati lachǘlürün Fésto lun lárügüdüní lufúlasun queísi gumádimati, ǘrüwa wéyu lueígiñe, ába lamúdeirun Cesaréagiñe lun ubúrugun Jerusalén. ");
INSERT INTO cabNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ába jachǘlürün jábutigu fádirigu ñíjin jáma juríu ja weírigutimaabaña íchiga lidúnrun Páblo ligíbugiñe Fésto. ");
INSERT INTO cabNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ába jamúriajan fuleísei lúma lun loúnajan anǘgei Páblo Jerusalén. Le jaráansejanbei, lún yebe jáfaruni jilágubei luágu ǘma. ");
INSERT INTO cabNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ába loúnabun Fésto luágu Cesaréa lan ladaürǘwa Páblo, áni jarítagua lan lídin ñi madíse. ");
INSERT INTO cabNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ába laríñagun joun. —Ligía lúnti lubeí joúdin ja weírigutimaabaña jídaangiñe Cesaréa úara núma, áni ánjein adǘgaali lubeí wügǘri ligía dúru, gayáraabei jaríñaguni. ");
INSERT INTO cabNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Wídü rügǘñein o díisi lan wéyu láu Fésto Jerusalén, ába lagíribudun ubúrugun Cesaréa. Larúgan, ába lárügüdüní lufúlasun lun lagúseragüdün, ába loúnajan luágu Páblo. ");
INSERT INTO cabNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Dan le lebélurunbei Páblo, ába jagúriridágun juríu ja ñǘbinbaña Jerusaléngiñe láu, ába jíchugun sarágu lidúnrun le jǘrüti, áni siñáti jarúfuduni luágu inárüni lan ni cáta lídaangiñe le jaríñagunbei. ");
INSERT INTO cabNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ábati laríñagun Páblo lídan ladímurejan lueígiñegua. —Madǘgüngidina ni murúsun dúru ni lun jalúrudun juríu, ni tun témpulu, ni lun urúei César. ");
INSERT INTO cabNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Queíti busén lan Fésto leréderun buídu jáma juríu, ába laríñagun lun Páblo. —¿Buséntibu bídin Jerusalén lun nagúseragüdünibu ñi? ");
INSERT INTO cabNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ába loúnabun Páblo. —Ligíbugiñeñadina lagúseragüle urúei César, le ñí lubei lúnti lan nagúserún. Queísi basúbudiruni buídu, madǘgüngidina dúru joun juríu. ");
INSERT INTO cabNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ánjein adǘgaadina lubeí dúru le garíchati lun nafarún jilágubei lueígiñe, mebéresegúntina noúnwen, ánjein úa lubeí ni cáta lánina inárüni lídan sun le aríñawagúbei nuágu, úati ni ában garíchati lun ledéregerunina joun juríu. Amúriajatina lun César lan agúseragüdána. ");
INSERT INTO cabNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Lárigiñeti layánujan Fésto jáma lánigu cába lan ladǘga láu Páblo, ába laríñagun lun. —Amúriajaadibu lubeígia lun César lan agúseragüdabu, beíbugati lun César. ");
INSERT INTO cabNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Átiri wéyu lárigiñe, ába lídin urúei Agrípa túma Bereníce Cesaréa aríjei Fésto. ");
INSERT INTO cabNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Quei reídei jabeí átiri wéyu ñi, ába labájüdaguni Fésto luáguti lagúserun Páblo lun urúei Agrípa, laríñaga lun. —Níjein ában wügǘri lígirun Félix dáüwañu ya. ");
INSERT INTO cabNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Dan le Jerusalén nubeí, rútiña jábutigu fádirigu jáma wügǘriña juríu weírigutiña lidúnrun nigíbugiñe, amúriajatiña núma lun nasíadiruni. ");
INSERT INTO cabNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ába naríñagun joun luágu magáburi láani lúrudu Rómana lun lasíadirun ában gürígia lun oúweni maríjinga láña ja íchugubaña lidúnrun ligíbugiñe, lun gayára lan ladímurejan lueígiñegua. ");
INSERT INTO cabNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ligía, lídan lubeí le jayábinbei ya úara núma, meféridirúntina dan, larúgan, ába nárügüdüni nufúlasun lídan agúseragülei, ába noúnajan luágu wügǘri ligía. ");
INSERT INTO cabNT_vpl V