﻿USE sofia;
DROP TABLE IF EXISTS sofia.bzj_vpl;
CREATE TABLE bzj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bzj_vpl WRITE;
INSERT INTO bzj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dis da di buk a di famili chree a Jeezas Krais, weh kohn dong fahn Aybraham ahn King Dayvid famili lain. ");
INSERT INTO bzj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aybraham son da-mi Aizak. Aizak son da-mi Jaykop. Jaykop son dehn da-mi Jooda ahn ih breda dehn. ");
INSERT INTO bzj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jooda son dehn da-mi Payres ahn Zera, ahn fi dehn ma da-mi Taymar. Payres son da-mi Hezron. Hezron son da-mi Ram. ");
INSERT INTO bzj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram son da-mi Aminadab. Aminadab son da-mi Nashon. Nashon son da-mi Salmon. ");
INSERT INTO bzj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","6","Salmon son da-mi Bowaz, ahn fi hihn ma da-mi Rayhab. Bowaz son da-mi Obed, ahn fi hihn ma da-mi Root. Obed son da-mi Jesi, Jesi son da-mi King Dayvid. Dayvid son da-mi Salaman, ahn fi hihn ma da-mi Uraiya waif. ");
INSERT INTO bzj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salaman son da-mi Rehobowam. Rehobowam son da-mi Abija. Abija son da-mi Aysa. ");
INSERT INTO bzj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aysa son da-mi Jehoshafat. Jehoshafat son da-mi Joram. Joram son da-mi Uzaiya. ");
INSERT INTO bzj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzaiya son da-mi Jotam. Jotam son da-mi Ayhaz. Ayhaz son da-mi Hezikaiya. ");
INSERT INTO bzj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezikaiya son da-mi Manaaseh. Manaaseh son da-mi Amon. Amon son da-mi Josaiya. ");
INSERT INTO bzj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaiya son da-mi Jekonaiya ahn ih breda dehn. Dehn mi baan rong di taim wen di peepl dehn fahn Babilan mi kyapcha dehn wan fahn Izrel ahn ton dehn intu slayv. ");
INSERT INTO bzj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Now afta dehn kyapcha dehn: Jekonaiya son da-mi Sheyaltyel. Sheyaltyel son da-mi Zerubabel. ");
INSERT INTO bzj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel son da-mi Abiyud. Abiyud son da-mi Elaiyakim. Elaiyakim son da-mi Azor. ");
INSERT INTO bzj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor son da-mi Zaydak. Zaydak son da-mi Akim. Akim son da-mi Eliyud. ");
INSERT INTO bzj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud son da-mi Eliyayza. Eliyayza son da-mi Matan. Matan son da-mi Jaykop. ");
INSERT INTO bzj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jaykop son da-mi Joazef. Joazef waif da-mi Mayri. Mayri da-mi Jeezas ma. Ahn dehn kaal Jeezas di Krais. ");
INSERT INTO bzj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Soh fahn Aybraham tu Dayvid da foateen jenarayshan. Den fahn Dayvid tu di taim wen Izrel mi ton slayv da Babilan da foateen jenarayshan. Ahn fahn da taim tu di taim a Jeezas da wahn nada foateen jenarayshan. ");
INSERT INTO bzj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Dis da how Jeezas Krais mi baan. Ih ma Mayri mi sopoas tu marid tu Joazef, bot bifoa dehn ku geh marid, di Hoali Spirit mek ih geh pregnant. ");
INSERT INTO bzj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Now Joazef weh Mayri mi fi marid tu, da-mi wahn raichos man, ahn ih neva waahn shaym Mayri fronta evribadi, soh ih mek op ih main fi lef ahn widowt nobadi noa. ");
INSERT INTO bzj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Now wail Joazef stil mi-di tink bowt it, wahn aynjel fahn di Laad kohn tu ahn eena wahn jreem ahn tel ahn seh, “Joazef, yoo weh kohn fahn Dayvid famili lain, noh frayd fi marid tu Mayri. Da baybi weh deh eena ih beli da fahn di Hoali Spirit. ");
INSERT INTO bzj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Shee wahn ga wahn son, ahn yu fi naym ahn Jeezas, weh meen ‘Gaad sayv,’ kaa da hihn wahn sayv ih peepl dehn fahn dehn sin.” ");
INSERT INTO bzj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aala dis hapm soh dat weh Gaad mi seh fahn lang taim chroo ih prafit dehn kuda mi kohn chroo. ");
INSERT INTO bzj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ih mi seh, “Wahn verjin wahn ga wahn lee baybi bwai, ahn dehn wahn kaal ahn Imanyuwel,” weh meen “Gaad deh wid wi.” ");
INSERT INTO bzj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Soh wen Joazef wayk op, ih du evriting weh di aynjel mi tel ahn fi du. Ih tek Mayri ahn marid tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bot hihn ahn Mayri neva sleep tugeda til afta di baybi baan; ahn wen di baybi baan, Joazef naym ahn Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Now Jeezas mi baan da wahn tong eena Judeeya weh nayhn Betlihem wen Herod da-mi king. Wahn lee wail afta Jeezas mi baan, sohn waiz man weh stodi di staar dehn kohn fahn sohn konchri weh deh ees fahn Jeroosalem ahn dehn mi-di aks, ");
INSERT INTO bzj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Wehpaa di baybi deh weh baan weh da king a di Jooish peepl dehn? Wen wi mi deh da fi wee konchri, wee si di staar weh da-mi di sain dat hihn mi wahn baan, soh wi kohn kohn wership ahn.” ");
INSERT INTO bzj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wen King Herod yehr dis, hihn ahn aala di teecha dehn a di Laa ahn evribadi da Jeroosalem staat tu wori fi chroo chroo. ");
INSERT INTO bzj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ih kaal aala di cheef prees dehn, ahn aala di teecha dehn a di Laa, ahn aks dehn seh, “Da wehpaa dis Krais fi baan?” ");
INSERT INTO bzj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dehn ansa ahn seh, “Da Betlihem eena Judeeya. Dis da weh di prafit dehn mi rait fahn lang taim: ");
INSERT INTO bzj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ahn yoo Betlihem Tong weh deh eena Judeeya, yoo da noh no smaal taim tong monks di big taim tong dehn da Judeeya, kaa wahn king wahn kohn fahn owta yu ahn da king wahn leed mi peepl a Izrel laik wahn shepad.’” ");
INSERT INTO bzj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Soh Herod gaan ahn hoal wahn seekrit meetn wid di waiz man dehn fi chrai fain owt fahn dehn weh taim dehn mi fos si di staar. ");
INSERT INTO bzj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Den ih sen dehn da Betlihem ahn dis da weh ih tel dehn fi du: “Unu goh ahn luk fi di pikni til unu fain ahn. Wen unu fain ahn, unu mek Ah noa wehpaa ih deh, soh dat Ai ku wership ahn tu.” ");
INSERT INTO bzj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Afta Herod don taak tu dehn, dehn gaan. Pahn di way dehn si di staar agen; da mi di sayhn staar weh dehn mi si fos wichpaa dehn mi kohn fram. Ahn di staar leed dehn di hoal way til ih stap rait oava wehpaa di baybi mi deh. ");
INSERT INTO bzj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Wel, dehn mi oanli glad fi si di staar. ");
INSERT INTO bzj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dehn gaan eena di hows ahn si di baybi wid ih ma, weh da-mi Mayri. Den dehn neel dong ahn wership di baybi. Afta dat dehn oapm dehn ekspensiv gif ahn gi ahn goal ahn frankinsens ahn mer. ");
INSERT INTO bzj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Afta dat dehn gaahn bak da dehn oan konchri bai wahn nada rowt, kaa Gaad waan dehn eena wahn jreem noh fi goh bak tu Herod. ");
INSERT INTO bzj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Afta dehn don gaan, wahn aynjel fahn di Laad taak tu Joazef eena wahn jreem ahn tel ahn seh, “Get op, tek di pikni ahn ih ma, ahn goh da Eejip. Stay deh til Ah tel yu wen fi lef, kaa Herod di luk fi di pikni fi kil ahn.” ");
INSERT INTO bzj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Soh Joazef get op joorin di nait ahn kehr ih waif ahn pikni, ahn ih gaahn da Eejip, ");
INSERT INTO bzj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ahn ih stay deh til Herod ded. Soh weh di prafit mi seh kohn chroo. Ih mi seh, “Ah kaal mi Son owta Eejip.” ");
INSERT INTO bzj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wen Herod fain owt dat di waiz man dehn mi chrik ahn, ih mi beks no miks. Ih gi aadaz fi kil aala di lee bwai pikni dehn weh mi too yaaz ahn anda, weh mi liv da Betlihem ahn aal di ada tong dehn weh mi deh rong deh. Ih du dat kaa di waiz man dehn mi tel ahn dat da mi too yaaz sins dehn mi fos si di staar. ");
INSERT INTO bzj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Wen dis hapm, weh di prafit Jerimaiya mi seh mi did kohn chroo. Ih mi seh, ");
INSERT INTO bzj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Yu yehr wahn vais da Raama di skreem ahn baal. Raychel di baal fi ih pikni dehn ahn nobadi kyaahn kansoal ahn, kaa ih pikni dehn ded.” ");
INSERT INTO bzj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Joazef mi stil deh da Eejip wen Herod ded. Ahn wahn aynjel fahn di Laad taak tu ahn eena wahn jreem agen. ");
INSERT INTO bzj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ih tel ahn seh, “Get op, tek di pikni ahn ih ma ahn goh bak da Izrel, kaa di peepl dehn weh mi-di chrai fi kil yu pikni don ded.” ");
INSERT INTO bzj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Soh Joazef get op ahn ih tek ih pikni ahn ih waif ahn ih gaahn bak da Izrel. ");
INSERT INTO bzj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bot wen ih yehr seh dat Arkelos tek ih pa Herod plays az king a Judeeya, ih mi frayd fi goh deh. Gaad waan ahn eena wahn jreem, soh ih gaahn da Gyalilee insted. ");
INSERT INTO bzj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Dehn gaahn liv da wahn tong weh nayhn Nazaret, soh weh di prafit mi seh kuda mi kohn chroo. Ih mi seh, “Dehn wahn kaal ahn wahn Nazareen.” ");
INSERT INTO bzj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Sohn yaaz afta dat, Jan di Baptis mi deh eena di dezert da Judeeya di preech seh, “Ton fahn unu sin dehn, kaa di kingdom a hevn wahn soon kohn.” ");
INSERT INTO bzj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Dis da di mesinja weh Aizaiya di prafit mi rait bowt wen ih seh, “Hihn da di vais weh di hala owt eena di dezert di seh, ‘Unu geh redi fi wen di Laad kohn, ahn mek di road dehn schrayt far ahn.’” ");
INSERT INTO bzj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jan mi-di wayr kloaz weh mek owta kyamil hyaa, ahn ih mi ga wahn tik leda belt rong ih ways. Ih yoostu eet loakos ahn wail honi. ");
INSERT INTO bzj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Den peepl fahn Jeroosalem ahn fahn Judeeya dischrik, ahn fahn aal oava di konchrisaid rong Jaadn Riva mi-di goh owt tu wehpaa Jan mi deh. ");
INSERT INTO bzj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Afta dehn don kanfes dehn sin dehn tu Gaad, Jan baptaiz dehn eena Jaadn Riva. ");
INSERT INTO bzj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bot wen Jan si lata Farisee ahn Sadyusee di kohn wehpaa ih mi-di baptaiz peepl, ih tel dehn seh, “Unu da snayk ahn unu pa dehn da-mi snayk tu! Da hoo waan unu fi ron fahn Gaad jojment weh di kohn? ");
INSERT INTO bzj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","If unu sari fi unu sin dehn fi chroo, proov it bai di way yu liv. ");
INSERT INTO bzj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ahn noh eevn chrai fool unuself ahn tink seh dat bikaa unu kohn fahn Aybraham famili lain, dat mek unu aarait wid Gaad. Ai di tel unu, Gaad ku tek dehnya stoan dong ya ahn mek Aybraham pikni owta dehn. ");
INSERT INTO bzj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Unu da jos laik chree, ahn Gaad don ga di aks da di root. Ih wahn chap dong ahn bon op eni chree weh noh di bayr. ");
INSERT INTO bzj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ai di baptaiz unu wid waata soh dat unu ku shoa dat unu ton fahn unu sin dehn, bot sohnbadi els weh eevn moa powaful dahn mee wahn kohn. Ai noh eevn gud nof fi bak fi hihn shooz fi hihn. Hihn wahn baptaiz unu wid di Hoali Spirit ahn wid faiya. ");
INSERT INTO bzj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jos laik wahn faama, hihn don ga fi hihn fan eena ih han ahn ih wahn fan aala di chrash owta di weet. Ih wahn gyada op aala di gud paat ahn put it op, ahn ih wahn bon op di chrash eena wahn faiya weh kyaahn owt.” ");
INSERT INTO bzj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Afta dat Jeezas reech Jaadn Riva. Ih mi kohn fahn Gyalilee fi mek Jan baptaiz ahn. ");
INSERT INTO bzj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bot Jan mi-di chrai fi stap ahn. Ih tel Jeezas seh, “Ai noh fi baptaiz yoo; da yoo fi baptaiz mee!” ");
INSERT INTO bzj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bot Jeezas ansa ahn seh, “Lef it soh fi now, kaa laik dis wi wahn di du aal di rait ting dehn weh Gaad waahn wi du.” Soh Jan giv een ahn baptaiz Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Afta Jeezas don geh baptaiz ahn ih kom op owta di waata, sayhn taim hevn oapm op ahn ih si di Hoali Spirit di kohn dong jos laik how wahn dov wuda kohn dong, ahn ih pich pan ahn. ");
INSERT INTO bzj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ahn sayhn taim wahn vais fahn hevn seh, “Yoo da mi Son weh Ah oanli lov, an Ah oanli pleez wid yu.” ");
INSERT INTO bzj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Den di Hoali Spirit leed Jeezas owt eena di dezert soh dat di devl ku temp ahn. ");
INSERT INTO bzj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ih stay deh fi faati dayz ahn faati naits. Ih mi-di faas di hoal taim ih mi dehdeh. Afta dat ih mi hongri bad. ");
INSERT INTO bzj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Den di devl gaahn tu ahn, ahn tel ahn seh, “If yoo da Gaad Son fi chroo, tel dehnya stoan fi ton intu bred.” ");
INSERT INTO bzj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jeezas ansa ahn seh, “Ih rait dong eena di Skripcha seh, ‘Da noh oanli bred yu need fi mek yu liv, bot yu fi liv bai evri werd weh kom owta Gaad mowt.’” ");
INSERT INTO bzj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Afta dat di devl kehr Jeezas da Jeroosalem, weh da-mi di hoali siti, ahn mek ih stan op pahn di tip tap a di templ. ");
INSERT INTO bzj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ih tel ahn seh, “If yoo da Gaad Son fi chroo chroo, chroa dong yuself fahn ya. Aftaraal, ih rait dong eena di Skripcha seh, ‘Gaad wahn gi fi hihn aynjel dehn aadaz fi tek gud kayr a yu, ahn dehn wahn kech yu, soh dat yu noh eevn wahn lik yu fut gens wahn stoan.’” ");
INSERT INTO bzj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jeezas ansa ahn seh, “Di Skripcha seh tu, ‘Yu noh fi chrai tes di Laad yu Gaad.’” ");
INSERT INTO bzj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Den di devl kehr ahn op pahn wahn hai hai mongtin soh dat ih ku luk dong ahn si aala di nayshan dehn a di werl, ahn ih mek ih si how grayt ahn byootiful dehn mi stan. ");
INSERT INTO bzj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ih tel ahn seh, “Ai wahn gi yu aala dis weh yu si ya. Aal weh yu hafu du da bow dong ahn wership mee.” ");
INSERT INTO bzj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Bot Jeezas tel ahn seh, “Goh fahn ya, Saytan. Ih rait dong eena di Skripcha seh, ‘Gaad da di oanli wan yu fi wership, ahn da oanli hihn wan yu fi serv.’” ");
INSERT INTO bzj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Den di devl lef ahn loan ahn sohn aynjel kohn kohn ten tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Now wen Jeezas yehr seh dat dehn mi dash Jan di Baptis eena jayl, ih gaahn bak da Gyalilee. ");
INSERT INTO bzj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ih moov fahn Nazaret Tong ahn gaahn gaahn liv da Kapernyam, weh mi deh bai di lagoon eena di ayrya weh Zebyulon ahn Naftali mi deh. ");
INSERT INTO bzj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Wen Jeezas du dat, weh Aizaiya di prafit mi seh kohn chroo. Hihn mi seh, ");
INSERT INTO bzj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Lisn, unu peepl da Zebyulon ahn Naftali, weh deh bai di see pahn di ada said a Jaadn Riva; ahn unu lisn tu, unu peepl weh da noh Joo weh liv da Gyalilee. ");
INSERT INTO bzj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Unu peepl weh mi-di sidong eena loan daaknis wahn si wahn brait lait; ahn da lait wahn shain pahn dehn wan weh det di heng oava.” ");
INSERT INTO bzj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ahn fahn da taim deh goh bak, Jeezas staat tu preech ih mesij weh seh, “Unu ton fahn unu sin dehn kaa di taim wen unu ku bee paat a di kingdom a hevn deh kloas.” ");
INSERT INTO bzj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ahn wail Jeezas mi-di waak lang di waatasaid da Gyalilee, ih si Saiman, weh dehn mi kaal Peeta, ahn ih breda weh nayhn Anjru. Dehn mi-di chroa owt wahn net eena di lagoon kaa dehn da-mi fishaman. ");
INSERT INTO bzj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Soh Jeezas tel dehn seh, “Unu kungoh lang wid mi, ahn insteda kech fish, Ah wahn mek unu kech peepl fi Gaad.” ");
INSERT INTO bzj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sayhn taim di too breda dehn jrap dehn net ahn gaahn lang wid Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Wahn lee wayz ferda, Jeezas si too moa breda weh mi nayhn Jaymz ahn Jan. Dehn mi-di sidong eena wahn boat, lang wid dehn pa weh nayhn Zebidee, di fiks dehn fishin net. Jeezas kaal dehn tu, ");
INSERT INTO bzj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ahn sayhn taim dehn jomp op ahn lef dehn pa eena di boat, ahn gaahn lang wid Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jeezas gaan aal oava Gyalilee di teech eena dehn meetn plays dehn. Ih mi-di preech di Gud Nyooz bowt how dehn ku bee paat a di kingdom a hevn, ahn ih mi-di heel aal kaina siknis ahn dizeez weh mi deh monks di peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nyooz bowt weh Jeezas mi-di du spred aal oava Siriya, ahn dehn kehr peepl wid aal kaina siknis ahn dizeez tu ahn. Som a dehn mi ga deeman eena dehn, ahn som a dehn mi-di kech fits, ahn sohn kudn waak. Bot Jeezas heel evri wan a dehn. ");
INSERT INTO bzj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Afta dat, wahn hoal krowd a peepl staat tu fala Jeezas. Dehn kohn fahn Gyalilee ahn Dekapolis, ahn Jeroosalem, ahn fahn Judeeya dischrik, ahn fahn kraas Jaadn Riva. ");
INSERT INTO bzj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wen Jeezas si di big krowd a peepl, ih gaan op pahn di said a wahn hil ahn ih sidong. Afta dat ih disaipl dehn gyada kloas tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Den ih staat tu teech dehn seh, ");
INSERT INTO bzj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Gaad bles dehn wan weh noa seh dehn need hihn, kaa di kingdom a hevn da fi dehn. ");
INSERT INTO bzj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Gaad bles dehn wan weh di moan ahn baal, kaa hihn wahn komfert dehn. ");
INSERT INTO bzj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Gaad bles dehn wan weh hombl, kaa di hoal ert wahn bee fi dehn. ");
INSERT INTO bzj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Gaad bles dehn wan weh hongri fi du weh rait, kaa hihn wahn satisfai dehn. ");
INSERT INTO bzj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Gaad bles dehn wan weh ga mersi pahn ada peepl, kaa hihn wahn ga mersi pahn dehn tu. ");
INSERT INTO bzj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Gaad bles aala dehn wan hoofa haat kleen, kaa dehn wahn si hihn. ");
INSERT INTO bzj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Gaad bles dehn wan weh du dehn bes fi help peepl liv eena pees, kaa hihn wahn kaal dehn fi hihn pikni dehn. ");
INSERT INTO bzj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Gaad bles dehn wan weh geh haraas sayka weh dehn di liv rait, kaa di kingdom a hevn da fi dehn. ");
INSERT INTO bzj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Gaad bles unu wen peepl insolt unu ahn haraas unu ahn tel aal kaina lai pahn unu sayka weh unu bilangz tu mee. ");
INSERT INTO bzj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Memba seh dat da di sayhn way dehn mi chreet di prafit dehn weh mi deh bifoa fi unu taim. Soh unu fi rijais ahn unu fi hapi, kaa Gaad di sayv wahn big riwaad eena hevn fi unu. ");
INSERT INTO bzj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Unu da laik saalt fi dis werl. Bot if saalt noh tays saalti nohmoh, da how yu wahn mek it saalti agen? Ih noh gud fi notn. Di oanli ting yu ku du da chroa it weh, ahn den peepl wahn en op di waak op pan it. ");
INSERT INTO bzj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Unu da laik lait fi di peepl dehn a dis werl. Wen wahn siti bil pahn tap a wahn hil, evribadi ku see't. ");
INSERT INTO bzj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Sayhn way unu wudn lait wahn lamp ahn put it anda wahn big bowl. Insteda dat, yu wahn put it hai soh dat ih ku lait op di hoal plays. ");
INSERT INTO bzj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jos laik dat yu fi shain yu lait fronta evribadi, soh dehn ku si di gud ting dehn weh yu du, ahn prayz yu Faada eena hevn. ");
INSERT INTO bzj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Noh tink seh dat Ai kohn fi du weh wid di Laa ahn weh di prafit dehn mi rait. No, Ai noh kohn fi du weh wid dehn, bot Ai kohn fi mek dehn kohn chroo. ");
INSERT INTO bzj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ah di tel unu di chroot, az lang az hevn ahn ert stil deh, di leelis leta er eevn wan lee dat eena di Laa noh wahn geh jrap til evriting weh fi hapm hapm. ");
INSERT INTO bzj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Soh enibadi weh brok eevn di leelis paat a di Laa, ahn teech ada peepl fi du di sayhn ting, wahn bee lees eena di kingdom a hevn. Bot enibadi weh obay di Laa, ahn teech ada peepl fi obay it tu, wahn bee grayt eena di kingdom a hevn. ");
INSERT INTO bzj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ah di tel unu, wen ih kohn tu liv rait, unu hafu kohn beta dan dehn Farisee er di teecha dehn a di Laa, er els unu neva wahn ku get eena di kingdom a hevn. ");
INSERT INTO bzj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Fahn lang taim unu mi yehr seh dehn mi tel peepl, ‘Unu noh fi kil, ahn enibadi weh du it wahn geh joj.’ ");
INSERT INTO bzj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bot now Ai di tel unu, if yu eevn beks wid yu brada fi notn, yu wahn geh joj sayhn way. Ahn if yu kaal yu brada, ‘Schupid!’ yu wahn en op da koat. Ahn wosa, if yu kaal yu breda, ‘Fool!’ yu laiyabl fi en op eena faiya da hel. ");
INSERT INTO bzj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Soh wen yu deh fronta Gaad da di alta di aafa yu gif tu ahn, ahn yu memba seh yu brada ga sohnting gens yu, ");
INSERT INTO bzj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","lef yu gif deh ahn goh mek op wid yu brada fos. Den kohn bak ahn aafa yu gif tu Gaad. ");
INSERT INTO bzj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“If yu enimi di kehr yu da koat fi sohnting, setl unu ting kwik-wan bifoa unu get deh. Adawaiz, ih mait haal yu fronta di joj, ahn den di joj wahn mek polees pich yu eena jayl. ");
INSERT INTO bzj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ah di tel unu di chroot, yu noh wahn get owt til yu pay aaf evri jak sent weh yu hoa. ");
INSERT INTO bzj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Fahn lang taim unu mi yehr seh dehn mi tel peepl, ‘Yu noh fi sleep wid sohnbadi els waif er hozban.’ ");
INSERT INTO bzj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bot now Ai di tel unu, if yu eevn luk pahn wahn uman ahn los afta ahn, yu don gilti aredi kaa yu don du it eena yu haat. ");
INSERT INTO bzj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","If unu rait aiy wahn mek unu sin, dig it owt ahn hib it weh. Ih beta fi liv widowt wan paat a yu badi dan fi mek yu ga yu hoal badi ahn lan op da hel. ");
INSERT INTO bzj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sayhn way, if yu rait han wahn mek yu sin, chap it aaf ahn hib it weh tu. Ih beta fi liv widowt wahn han dan fi yu hoal badi goh da hel. ");
INSERT INTO bzj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Dehn seh, ‘If yu divoas yu waif, yu fi gi ahn wahn pees a paypa weh seh dat unu don divoas.’ ");
INSERT INTO bzj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bot now Ai di tel yu, yu ku oanli divoas yu waif ahn marid tu sohnbadi els if yu waif di cheet pahn yu, ahn noh fi no ada els reezn. Adawaiz yu di mek shee liv eena sin, ahn rait soh, if shee goh geh marid agen, di man weh ih marid tu wahn di liv eena sin tu. ");
INSERT INTO bzj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Fahn lang taim unu mi yehr seh dehn mi tel peepl, ‘Yu noh fi mek oat ahn den brok it; ahn if yu doo mek wahn oat tu Gaad fi du sohnting, mek shoar yu du it.’ ");
INSERT INTO bzj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bot now Ai di tel unu, yu noh fi sway ataal wen yu mek wahn oat. Yu noh fi sway bai hevn kaa dat da Gaad chroan, ");
INSERT INTO bzj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","needa bai ert, kaa dat da Gaad futstool, needa bai Jeroosalem, kaa dat da di siti weh bilangz tu di grayt King. ");
INSERT INTO bzj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Noh eevn sway bai yu oan hed kaa yu kyaahn mek yu hyaa blak er wait. ");
INSERT INTO bzj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aal unu hafu seh da wahn playn ‘yes’ er ‘no.’ If unu seh eniting els, ih wahn di kohn fahn di devl. ");
INSERT INTO bzj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Fahn lang taim unu mi yehr seh dehn mi tel peepl, ‘Yu pay bak wahn aiy fi wahn aiy ahn wahn teet fi wahn teet.’ ");
INSERT INTO bzj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bot now Ai di tel unu noh fi pay peepl bak wen dehn du yu sohnting. If sohnbadi slap yu pahn di rait said a yu fays, ton yu fays mek dehn slap yu pahn di ada said tu. ");
INSERT INTO bzj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Den tu, if sohnbadi kohn kehr yu da koat fi mek yu gi dehn yu shot, gi dehn yu jakit tu. ");
INSERT INTO bzj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ahn den if sohnbadi foas yu fi goh wid dehn wan mail, goh wid dehn too mail insted. ");
INSERT INTO bzj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wen sohnbadi aks yu fi eniting, gi dehn, ahn if dehn aks yu fi len dehn sohnting, len dehn. ");
INSERT INTO bzj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Fahn lang taim unu mi yehr seh dehn mi tel peepl, ‘Yu fi lov yu fren ahn hayt yu enimi.’ ");
INSERT INTO bzj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bot now Ai di tel unu fi lov yu enimi dehn ahn pray fi dehn wan weh chreet unu bad, ");
INSERT INTO bzj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","soh dat unu ku bee di hevnli Faada pikni dehn. Gaad mek di son shain dong pahn di gud ahn pahn di bad, ahn sayhn way ih mek ih rayn pahn peepl weh du rait ahn peepl weh du rang. ");
INSERT INTO bzj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Weh mek yu tink Gaad wahn gi unu eni riwaad if unu oanli lov dehn wan weh lov unu? Eevn di taks kalekta dehn du dat! ");
INSERT INTO bzj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ahn if unu oanli hayl unu fren dehn, unu tink unu di du eniting speshal? Eevn peepl weh noh bileev eena Gaad du dat! ");
INSERT INTO bzj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Soh unu mos bee perfek jos laik how unu Faada eena hevn perfek. ");
INSERT INTO bzj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Wen yu du gud tingz fi Gaad, main dat yu noh du it jos fi shoa aaf fronta peepl. If yu du dat, yu noh wahn geh no riwaad fahn yu Faada weh deh op da hevn. ");
INSERT INTO bzj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Soh wen yu di gi poa peepl eniting, noh bloa yu chrompit fi mek evribadi noa. Dat da weh di hipokrit dehn du pahn schreet kaana ahn eena di plays dehn weh dehn meet. Dehn du it fi mek peepl prayz dehn, bot Ah di tel unu di chroot, dat da aal di riwaad weh dehn wahn geh. ");
INSERT INTO bzj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Soh wen yu di gi poa peepl eniting, noh mek nobadi noa. ");
INSERT INTO bzj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Da way deh ih wahn stay wahn seekrit, ahn unu Faada weh noa evriting weh hapm eena seekrit wahn riwaad unu fi weh unu du. ");
INSERT INTO bzj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Now wen unu pray, noh du it laik dehn hipokrit dehn weh laik stan op ahn pray eena di meetn plays dehn ahn pahn schreet kaana weh evribadi ku si dehn. Ah di tel unu di chroot, dat da aal di riwaad weh dehn wahn geh. ");
INSERT INTO bzj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bot wen unu pray, goh eena unu room ahn shet di doa. Den pray tu unu Faada weh nobadi kyaahn si, ahn unu Faada weh si evriting weh hapm eena seekrit wahn riwaad unu. ");
INSERT INTO bzj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Wen unu pray, noh jos ratl aaf wahn hoal lata ting oava ahn oava laik weh dehn peepl weh noh noa Gaad du. Dehn tink dat sayka weh fi dehn pryaaz soh lang, Gaad wahn yehr dehn. ");
INSERT INTO bzj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Noh du weh dehn du, kaa unu Faada weh deh op da hevn noa egzakli weh unu need eevn bifoa unu aks ahn. ");
INSERT INTO bzj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Soh den, dis da how unu fi pray tu ahn: ‘Fi wee Faada weh deh da hevn, mek wi kip yu naym hoali. ");
INSERT INTO bzj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kohn kohn set op yu kingdom, ahn mek evribadi obay yu pahn ert jos laik how evribadi obay yu da hevn. ");
INSERT INTO bzj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pleez gi wi food evri day. ");
INSERT INTO bzj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ahn fagiv wi fi evriting rang weh wi du jos laik how wee fagiv peepl weh du wee rang. ");
INSERT INTO bzj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kip wi fahn temtayshan, ahn protek wi fahn eevl.’ Da yoo rool yu kingdom, ahn ga aala di powa ahn di gloari fareva ahn eva. Aymen. ");
INSERT INTO bzj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Soh, if unu fagiv peepl weh du unu rang, den unu Faada weh deh op da hevn wahn fagiv unu tu. ");
INSERT INTO bzj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bot if unu noh fagiv ada peepl fi weh dehn du unu, den unu Faada noh wahn fagiv unu needa. ");
INSERT INTO bzj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ahn wen unu di faas, noh put wahn sad luk pahn unu fays laik di hipokrit dehn. Dehn du dat soh evribadi ku noa seh dehn di faas. Bot Ah di tel unu di chroot, dat da aal di riwaad weh dehn wahn geh. ");
INSERT INTO bzj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Soh wen unu di faas, wash unu fays ahn koam unu hyaa. ");
INSERT INTO bzj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Da way deh wen unu di faas, oanli unu Faada weh si evriting weh hapm eena seekrit wahn noa bowt it; nobadi els. Da hihn wahn riwaad unu. ");
INSERT INTO bzj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Yu noh fi put op yu richiz dong ya pahn dis ert, wehpaa insek ku dischrai it, er weh ih ku geh rosti, er weh teef ku tek it. ");
INSERT INTO bzj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Insteda du dat, sayv op richiz eena hevn fi unuself, wichpaa insek kyaahn eet it, ih kyaahn geh rosti, ahn teef kyaahn teef it needa. ");
INSERT INTO bzj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yu si, eniway wehpaa unu richiz deh, da rait deh unu haat wahn deh tu. ");
INSERT INTO bzj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Yu aiy dehn da laik lamp fi yu badi, soh if dehn stodi di luk pahn loan gud ting, di hoal a yu wahn ful op a lait. ");
INSERT INTO bzj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bot if dehn di luk pahn loan bad ting, den da loan daaknis wahn di kom eena yu haat. Ahn if di lait weh deh eena yu ton daaknis, den ih wahn oanli daak fi chroo! ");
INSERT INTO bzj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nobadi kyaahn serv too maasta. Eeda yu wahn hayt wan ahn lov di neks, er yu wahn rispek wan ahn kyaahn stan di neks wan. Rait soh, unu kyaahn serv Gaad ahn moni sayhn taim. ");
INSERT INTO bzj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Soh Ah di tel unu, noh wori bowt laif, laik weh yu wahn eet er jrink; ahn noh wori bowt yu badi, laik weh yu wahn wayr. Laif da moa dahn jos food, ahn yu badi da moa dahn weh yu wahn put aan. ");
INSERT INTO bzj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Man, luk pahn di berd dehn eena di skai; dehn noh hafu goh plaant ner reep. Ahn dehn noh ga food put op eena stoaroom needa, bot yu Faada eena hevn tek kayr a dehn, noh chroo? Unu noh tink unu wot moch moa dahn eni berd? ");
INSERT INTO bzj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wich wan a unu tink seh dat wen unu wori ih wahn mek unu ad aan wan moa owa tu unu laif? ");
INSERT INTO bzj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ahn wai unu wori bowt kloaz? Luk pahn how di wail flowaz dehn groa. Dehn noh werk ner mek kloaz fi wayr, ");
INSERT INTO bzj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","bot Ah di tel unu dis, noh eevn King Salaman, wid aal fi hihn fansi kloaz, neva luk az gud az dehnya flowaz ya. ");
INSERT INTO bzj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Now if Gaad jres op di graas weh groa owt eena di feel dehn, weh deh ya tudeh ahn jrai op ahn geh bon op tumaaro, ih noh mos wahn fain kloaz fi unu tu? Unu fayt leel, sa! ");
INSERT INTO bzj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Soh noh wori ahn aks unuself, ‘Da weh wi wahn eet?’ ahn ‘Weh wi wahn jrink?’ ahn ‘Weh wi wahn put aan?’ ");
INSERT INTO bzj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Dehnya da di ting dehn weh peepl weh noh noa Gaad goh afta. Unu Faada op da hevn don noa dat unu need aala dehn ting deh aredi. ");
INSERT INTO bzj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bot weh unu fi aym fa fos, da fi bee paat a di kingdom a hevn ahn liv rait, laik how hihn waahn. Den hihn wahn gi unu aala dehnya ting weh unu need tu. ");
INSERT INTO bzj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Soh noh wori bowt tumaaro; mek tumaaro wori bowt ihself. Di chrobl weh yu ga tudeh, nof fi tudeh. ");
INSERT INTO bzj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Noh joj ada peepl, er els Gaad wahn joj yoo tu; ");
INSERT INTO bzj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","kaa sayhn way how yu joj ada peepl, Gaad wahn joj yoo. Sayhn way how yu gi, dat da how yu wahn geh bak. ");
INSERT INTO bzj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ahn wai unu wahn wori bowt wahn lee splinta weh deh eena sohnbadi els aiy, ahn noh noatis di big pees a stik weh deh eena fi unu wan? ");
INSERT INTO bzj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","How yu ku seh tu yu brada, ‘Mi brada, mek Ah tek owt dis lee splinta weh deh eena yu aiy,’ wen di hoal taim wahn big pees a stik deh eena fi yoo wan? ");
INSERT INTO bzj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Unu hipokrit unu! Tek owt di big pees a stik weh deh eena yu oan aiy fos, den yu wahn ku si gud nof fi tek owt di splinta weh deh eena yu brada wan. ");
INSERT INTO bzj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Noh tek ting weh oanli sopoas tu bee fi Gaad ahn gi tu peepl weh noh apreeshiayt it. Dat wahn bee jos laik yu di gi it tu di daag dehn, er laik yu di chroa perl tu pig. Ahn weh di daag dehn wahn du, da ton rong ahn bait yu, ahn di pig dehn wahn stamp op pahn di perl dehn. ");
INSERT INTO bzj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kip aan di aks ahn unu wahn geh; kip aan di luk ahn unu wahn fain; kip aan di nak pahn di doa, ahn ih wahn oapm fi unu. ");
INSERT INTO bzj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kaa evribadi weh aks wahn geh; evribadi weh luk wahn fain weh dehn di luk fa; ahn evribadi weh nak pahn di doa, di doa wahn oapm fi dehn. ");
INSERT INTO bzj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Wich wan a unu, wen unu pikni aks unu fi bred wahn gi ahn stoan? ");
INSERT INTO bzj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ahn unu wosa noh wahn gi ahn snayk fi eet wen ih aks unu fi fish. ");
INSERT INTO bzj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","If unu weh soh wikid noa how fi gi unu pikni gud ting, den weh yu tink a yu Faada weh deh op da hevn den? Hihn wahn eevn moa glad fi gi gud ting tu enibadi weh aks ahn. ");
INSERT INTO bzj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Soh eena evriting yu fi chreet ada peepl di sayhn way how yoo waahn dehn chreet yoo. Dat kom op tu di sayhn ting weh Moaziz Laa ahn di oal taim prafit dehn teech. ");
INSERT INTO bzj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Goh chroo di gayt weh naro kaa di gayt waid ahn di road braad weh leed tu hel. Ahn lata peepl gwehn chroo deh. ");
INSERT INTO bzj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Bot di gayt smaal ahn di road naro weh leed yu tu reel laif. Ahn oanli lee bit a peepl wahn fain it. ");
INSERT INTO bzj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ahn unu fi bee kyaaful a dehn faals prafit. Dehn luk inosent laik sheep pahn di owtsaid, bot eensaid dehn da sohn reel wulf weh wahn eet unu op. ");
INSERT INTO bzj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yu wahn noa dehn bai weh dehn du, kaa grayp noh groa pahn prikl bush, ahn fig kyaahn groa pahn brambl. ");
INSERT INTO bzj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Rait soh, wahn chree weh helti wahn bayr gud froot, ahn wahn chree weh noh helti wahn bayr bad froot. ");
INSERT INTO bzj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Wahn helti chree kyaahn bayr bad froot ahn wahn chree weh noh helti kyaahn bayr gud froot needa. ");
INSERT INTO bzj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Eni chree weh noh bayr gud froot wahn geh chap dong ahn geh chroa eena faiya. ");
INSERT INTO bzj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Soh den, yu wahn noa di faals prafit dehn bai how dehn liv. ");
INSERT INTO bzj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Da noh evribadi weh stodi di kaal pahn mi ahn seh, ‘Laad, Laad,’ wahn geh fi bee paat a di kingdom a hevn, yu noh. Da oanli dehn wan weh du weh mai Faada da hevn waahn dehn du. ");
INSERT INTO bzj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wen di Day kohn wen Gaad joj evribadi, wahn lata peepl wahn tel mi seh, ‘Laad, Laad, wee mi-di preech eena yu naym ahn wi eevn jraiv owt deeman ahn du miraklz eena yu naym.’ ");
INSERT INTO bzj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Den Ai wahn tel dehn playn ahn schrayt, ‘Mee noh noa da hoo unu. Get fahn fronta mi, unu wikid peepl unu!’ ");
INSERT INTO bzj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Soh den, evribadi weh noh oanli yehr weh Ah seh, bot du it tu, da laik wahn waiz man weh bil ih hows pahn rak. ");
INSERT INTO bzj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wen di rayn kohn dong ahn flod waata rayz, ahn breez staat tu bloa haad pahn di hows, ih neva jrap dong kaa ih mi bil pahn rak. ");
INSERT INTO bzj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Evribadi weh yehr weh Ah seh, ahn noh du it, da laik wahn fool-fool man weh bil fi hihn hows pahn loan san. ");
INSERT INTO bzj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Wen di rayn kohn dong ahn flod waata rayz, ahn breez staat tu bloa haad pahn di hows, di hoal hows jrap da grong—brigidimbuf!” ");
INSERT INTO bzj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Wen Jeezas don seh aala dehn ting, di krowd kudn bileev weh dehn mi-di yehr, sayka how ih mi-di teech. Hihn mi-di teech laik sohnbadi weh noa egzakli weh dehn mi-di taak bowt, ahn ga aal atariti fi seh it tu. ");
INSERT INTO bzj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Afta Jeezas kohn dong fahn aafa di mongtin, wahn big krowd mi-di fala ahn. ");
INSERT INTO bzj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wen yu luk, wahn man weh mi ga leprosi kohn kohn neel dong fronta Jeezas ahn seh, “Sa, if yoo waahn, yoo ku heel mi.” ");
INSERT INTO bzj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jeezas schrech owt ih han ahn toch di man ahn seh, “Yes, man, Ah waahn heel yu. Yu heel!” Az Jeezas seh dat, di man leprosi geh heel sayhn taim. ");
INSERT INTO bzj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Den Jeezas tel di man, “Si dat yu noh seh notn tu nobadi; bot goh schrayt da di prees mek ih chek yu mek ih si dat yu heel fi chroo. Den goh goh kehr yu gif weh Moaziz Laa seh yu fi kehr, fi shoa evribadi dat yu geh heel.” ");
INSERT INTO bzj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Wen Jeezas reech Kapernyam, wahn aami aafisa kom op tu ahn, ahn bayg ahn seh, “Sa, mi servant deh hoahn sik eena bed kyaahn moov, ahn ih deh eena lata payn.” ");
INSERT INTO bzj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jeezas tel di aafisa, “Ah wahn kohn kohn heel ahn.” ");
INSERT INTO bzj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bot di aafisa seh, “Sa, Ai noh gud nof fi mek yoo kohn da mai hows. Aal yu hafu du da seh di werd, ahn mi servant wahn geh heel. ");
INSERT INTO bzj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ai noa, kaa mee miself ga aafisa oava mee weh gi mee aadaz, an Ai ga soalja weh Ai gi aadaz tu. Ai ku tel eni wan a dehn, ‘Goh!’ ahn ih goh. An Ah ku tel wahn neks wan, ‘Kohn!’ ahn ih kohn. Ai ku tel eni wan a mai servant dehn, ‘Du soch ahn soch,’ ahn ih wahn du it.” ");
INSERT INTO bzj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wen Jeezas yehr dis, ih mi sopraiz. Ih ton tu di krowd weh mi-di fala ahn, ahn seh, “Ah di tel unu di chroot, Ai neva fain nobadi wid soh moch fayt eena di hoal a Izrel yet! ");
INSERT INTO bzj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ah di tel unu dis tu, lata peepl weh da noh Joo wahn kohn fahn ees ahn wes kohn sidong rong di taybl eena di kingdom a hevn ahn eet lang wid Aybraham ahn Aizak ahn Jaykop. ");
INSERT INTO bzj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bot lata di Jooz dehn weh mi fi bee paat a di kingdom eena di fos plays wahn geh pich owt eena daak. Dehn wahn deh owt deh di baal ahn grain op dehn teet.” ");
INSERT INTO bzj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Den Jeezas tel di aami aafisa, “Yu ku goh hoahn now. Sayka yu fayt, yu servant geh heel.” Da sayhn taim deh, di servant geh heel. ");
INSERT INTO bzj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Wen Jeezas gaahn da Peeta hows, ih fain dat Peeta mada-in-laa mi sik eena bed wid wahn feeva. ");
INSERT INTO bzj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jeezas toch ih han, ahn di feeva gaan; den di laydi get op ahn staat tu ten tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Da eevnin deh, dehn bring lata peepl weh mi ga deeman tu Jeezas. Ih jraiv owt di deeman dehn jos bai di werd dehn weh ih seh, ahn ih heel aala dehn wan weh mi sik. ");
INSERT INTO bzj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jeezas du aala dat soh weh Aizaiya di prafit mi seh kohn chroo. Ih mi seh, “Ih tek weh aala wi siknis ahn kehr wi dizeez dehn.” ");
INSERT INTO bzj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Now wen Jeezas si di big krowd rong ahn, ih gi ih disaipl dehn aadaz seh, “Mek wi goh kraas da di neks said a di lagoon.” ");
INSERT INTO bzj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wahn teecha a di Laa kom op tu ahn, ahn seh, “Teecha, Ai wahn fala yoo noh mata wehpaa yu goh.” ");
INSERT INTO bzj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Bot Jeezas tel ahn seh, “Faks ga hoal fi liv eena, ahn berd ga nes, bot di Son a Man noh ga no way fi res ih hed.” ");
INSERT INTO bzj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wahn neks wan a ih falowa dehn tel ahn seh, “Teecha, mek Ah wayt til mi pa ded fos, soh dat Ah ku beri ahn.” ");
INSERT INTO bzj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jeezas tel ahn seh, “Yoo kohn kohn fala mee, ahn mek dehn wan weh ded beri dehn oan ded.” ");
INSERT INTO bzj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Den Jeezas get eena wahn boat ahn ih disaipl dehn gaahn lang wid ahn. ");
INSERT INTO bzj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","25","Sodn-wan wahn bad skwaal kohn pahn di lagoon ahn di wayv dehn geh soh hai dat dehn mi-di wash oava di boat. Bot Jeezas mi deh faas asleep. Soh ih disaipl dehn gaahn gaahn wayk ahn op. Dehn seh, “Laad, sayv wi noh! Wi di luk fi jrongdid ya!” ");
INSERT INTO bzj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jeezas ansa dehn seh, “Da weh mek unu soh fraitn? Unu fayt leel, sa!” Den ih get op ahn taak shaap-wan tu di breez ahn di wayv dehn ahn evriting geh kyaam kyaam. ");
INSERT INTO bzj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Di disaipl dehn kudn bileev dehn aiy ahn dehn seh tu wan anada, “Da weh kaina man dis? Dong tu di breez ahn di waata obay hihn!” ");
INSERT INTO bzj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wen Jeezas mi reech kraas di neks said a di lagoon, wichpaa di Gadareen peepl dehn liv, too man weh mi ga eevl spirit eena dehn mi-di kom owta di bering grong fi kohn meet ahn. Dehn mi soh owta kanchroal dat nobadi kuda mi paas deh. ");
INSERT INTO bzj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Rait den dehn hala owt, “Son a Gaad, da weh yoo waahn wid wee? Yu kohn kohn taacha wi bifoa wi taim?” ");
INSERT INTO bzj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wahn lee wayz aaf wahn lata pig mi-di feed. ");
INSERT INTO bzj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Di deeman dehn bayg Jeezas seh, “If yu chays wi owta dehn man ya, den pleez sen wi eena dehn pig deh noh!” ");
INSERT INTO bzj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jeezas tel dehn seh, “Goh, den.” Ahn rait away di eevl spirit dehn kom owta di man dehn ahn gaan eena di pig dehn, ahn di hoal bonch a dehn rosh dong di said a di hil weh mi wel ahn hai, ahn aala dehn jrap eena di lagoon ahn jrongdid. ");
INSERT INTO bzj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Di man dehn weh mi-di main di pig dehn ron gaahn tel evribadi eena di tong weh hapm, ahn dehn tel dehn bowt di too man dehn weh mi ga eevl spirit tu. ");
INSERT INTO bzj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Evribadi eena di tong gaahn gaahn meet Jeezas. Bot wen dehn si ahn, dehn bayg Jeezas fi goh fahn dehn konchri. ");
INSERT INTO bzj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jeezas get eena wahn boat ahn gaahn bak kraas di lagoon da ih hoamtong. ");
INSERT INTO bzj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Sohn man kohn di bring wahn paralaiz man pahn wahn schrecha. Wen Jeezas si humoch fayt dehn mi ga eena ahn, ih seh tu di paralaiz man, “Noh wori, mi son. Ah fagiv yu sin dehn.” ");
INSERT INTO bzj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Som a di teecha dehn a di Laa seh tu dehnself, “Dis man di play Gaad.” ");
INSERT INTO bzj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jeezas mi don noa weh dehn mi-di tink soh ih aks dehn seh, “Da wai unu di haaba dehn bad taats eena unu haat fa? ");
INSERT INTO bzj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wich wan eeziya fi seh, ‘Ah fagiv yu sin dehn,’ er ‘Get op ahn waak?’ ");
INSERT INTO bzj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ai ga atariti fi fagiv sin pahn ert ya. Bot fi jos seh dat noh proov notn, soh Ah wahn shoa unu an Ah wahn heel di man.” Den Jeezas ton tu di man weh mi paralaiz ahn tel ahn seh, “Get op ahn pik op yu schrecha ahn goh hoahn.” ");
INSERT INTO bzj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Di man get op ahn gaahn hoahn. ");
INSERT INTO bzj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wen di krowd si dat, dehn kudn bileev dehn aiy. Dehn staat tu prayz Gaad sayka weh ih gi da kaina powa tu wahn man. ");
INSERT INTO bzj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Afta Jeezas gaahn fahn deh, ih si wahn man weh nayhn Machyu. Ih mi-di sidong eena di kostom boot di kalek taks. Jeezas tel ahn seh, “Kohn kohn bee wan a mi disaipl dehn.” Sayhn taim Machyu get op ahn gaahn wid ahn. ");
INSERT INTO bzj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Layta Jeezas ahn ih disaipl dehn mi-di eet da Machyu hows, ahn wahn lata taks kalekta ahn sohn ada wan wid bad repyutayshan kohn kohn eet wid dehn. ");
INSERT INTO bzj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bot wen di Farisee dehn si dis, dehn aks Jeezas disaipl dehn seh, “Da how fi unu teecha stan fi eet wid dehn taks kalekta ahn dehn kaina peepl deh?” ");
INSERT INTO bzj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Wen Jeezas yehr weh dehn mi-di seh, ih tel dehn seh, “Da sik peepl weh need dakta, noh dehn wan weh helti. ");
INSERT INTO bzj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Now goh goh fain owt weh dis Skripcha meen: ‘Ah raada unu ga mersi pahn peepl, dan fi aafa animal sakrifais tu mi.’ Ai kohn fi kaal sinaz fi ton fahn dehn sin dehn, noh dehn wan weh tink seh dehn don rait wid Gaad.” ");
INSERT INTO bzj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Den dehn wan weh fala Jan di Baptis kohn da Jeezas ahn aks ahn seh, “Da wai wee ahn di Farisee dehn aal taim faas ahn pray ahn fi yoo disaipl dehn noh faas ataal?” ");
INSERT INTO bzj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jeezas ansa dehn seh, “Unu kyaahn ekspek wahn groom fren dehn fi feel sad wail hihn stil deh wid dehn. Bot di taim wahn kohn wen dehn wahn tek weh di groom fahn dehn, ahn dat da wen dehn wahn faas. ");
INSERT INTO bzj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Wen yu di pach oal kloaz, ih noh mek sens fi yooz klaat weh noh schrink yet fi pach di hoal wid, kaa di nyoo pees a klaat wahn jos schrink ahn pap weh fahn di kloaz dehn weh pach. Den di hoal wahn en op wosa aaf dan how ih mi stan fos. ");
INSERT INTO bzj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Rait soh, nobadi wahn put wain weh jos don mek eena oal leda wain bag. If dehn du dat, di nyoo wain wahn bos di oal wain bag, ahn aala di wain wahn chroh-weh ahn di wain bag wahn kandem. Yu wel ahn noa seh yu hafu put nyoo wain eena nyoo wain bag. Da way deh di too a dehn wahn stay gud.” ");
INSERT INTO bzj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wail Jeezas mi-di seh dehnya ting, wan a di leeda dehn a di sinagag deh kohn ahn neel dong fronta ahn, ahn seh, “Mi lee daata jos ded. Pleez kohn put yu han pan ahn, ahn ih wahn kohn bak tu laif agen.” ");
INSERT INTO bzj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jeezas get op ahn ih gaahn wid ahn, ahn ih disaipl dehn gaahn tu. ");
INSERT INTO bzj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sayhn taim wahn laydi weh mi-di chrobl wid hemrij fi twelv yaaz kom op bihain Jeezas ahn toch di ej a ih kloaz. ");
INSERT INTO bzj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ih seh tu ihself, “If Ah kuda eevn jos toch fi hihn kloaz, Ah wahn geh heel.” ");
INSERT INTO bzj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jeezas ton rong, ahn wen ih si ahn, ih tel ahn seh, “Daata, noh wori bowt notn; sayka yu fayt, yu geh heel.” Da veri minit di bleedn stap! ");
INSERT INTO bzj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","24","Layta, wen Jeezas gaan eena di sinagag leeda hows ahn si dehn wan weh mi-di play floot ahn di krowd a peepl di mek naiz, ih tel dehn seh, “Unu goh fahn ya. Di lee gyal noh ded; ih oanli di sleep!” Bot dehn oanli laaf aata ahn. ");
INSERT INTO bzj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Afta dehn put owt di krowd, Jeezas gaan een ahn ih hoal di lee gyal bai ih han, ahn di lee gyal get op. ");
INSERT INTO bzj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nyooz bowt weh ih du spred aal oava da paat a di konchri. ");
INSERT INTO bzj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Az Jeezas mi-di lef fahn deh, too blain man staat tu fala ahn, ahn dehn mi-di hala owt, “Yoo weh da Dayvid Son, ga piti pahn wi noh!” ");
INSERT INTO bzj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Afta ih gaan eensaid, di too blain man dehn kom op tu ahn. Ih aks deh seh, “Unu bileev Ai ku heel unu?” Dehn ansa ahn seh, “Yes Laad, wi bileev.” ");
INSERT INTO bzj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Den Jeezas toch dehn aiy ahn tel dehn seh, “Sayka di amonk a fayt weh unu ga, unu wahn geh heel.” ");
INSERT INTO bzj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ahn sayhn taim, dehn geh bak dehn sait. Jeezas waan dehn haad seh, “Si dat unu noh tel nobadi bowt dis.” ");
INSERT INTO bzj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bot wen dehn gaan, dehn staat tu tel evribadi bowt ahn eena da paat a di konchri. ");
INSERT INTO bzj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wail Jeezas ahn ih disaipl dehn mi-di lef fahn deh, sohn peepl bring wahn man tu ahn weh mi dom, kaa ih mi ga deeman eena ahn. ");
INSERT INTO bzj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Afta Jeezas jraiv owt di deeman, di man weh mi dom staat tu taak gud gud-wan. Di krowd weh mi dehdeh kudn bileev dehn aiy ahn dehn seh, “Wi neva si notn laik dis hapm eena Izrel yet.” ");
INSERT INTO bzj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bot di Farisee dehn seh, “Da di hed a di deeman dehn gi hihn powa fi jraiv owt deeman.” ");
INSERT INTO bzj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jeezas gaahn da aala di tong ahn di vilij dehn di teech eena dehn meetn plays dehn. Ih preech di Gud Nyooz bowt di kingdom a hevn, ahn ih heel aala dehn siknis ahn aala dehn dizeez dehn. ");
INSERT INTO bzj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wen ih si di krowd a peepl dehn, ih haat gaan owt tu dehn kaa dehn mi kanfyooz ahn dehn neva ga nobadi fi help dehn, sayhn laik dehn sheep weh noh ga nobadi fi main dehn. ");
INSERT INTO bzj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jeezas tel ih disaipl dehn seh, “Lata grayn deh fi pik eena di feel, bot oanli lee bit a peepl deh fi werk. ");
INSERT INTO bzj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Soh pray tu Gaad weh in chaaj a bring een di krap fi mek ih sen moa werkaz fi werk eena fi hihn feel.” ");
INSERT INTO bzj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jeezas kaal ih twelv disaipl dehn tugeda. Ih gi dehn powa fi jraiv owt eevl spirit ahn fi heel aal kaina siknis ahn dizeez. ");
INSERT INTO bzj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Dehnya da di naym a di twelv apasl dehn: fos yu mi ga Saiman, weh dehn yoostu kaal Peeta, ahn fi hihn breda weh nayhn Anjru; ahn Jaymz ahn Jan, weh da-mi Zebidee too son dehn. ");
INSERT INTO bzj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Den yu mi ga Filip ahn Bartalamyoo; ahn Machyu weh da-mi di taks kalekta, ahn Tamas; ahn Jaymz, weh da-mi Alfyos son; ahn Tadyos. ");
INSERT INTO bzj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Di laas too da-mi Saiman, weh mi bilangz tu di Zelat Paati; ahn Joodas Iskariyat, weh mi sel owt Jeezas aftawodz. ");
INSERT INTO bzj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jeezas sen owt dehnya twelv ahn dis da weh ih tel dehn: “Unu noh fi goh monks peepl weh da noh Joo, ahn unu noh fi goh da non a di Samaritan tong dehn. ");
INSERT INTO bzj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Insted, unu fi goh da di peepl a Izrel kaa dehn da sayhn laik sheep weh laas. ");
INSERT INTO bzj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ahn az unu goh, tel dehn dat di kingdom a hevn wahn soon kohn. ");
INSERT INTO bzj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Unu fi heel di sik peepl dehn, bring di ded bak tu laif, heel peepl weh ga leprosi, ahn jraiv owt deeman. Ah neva chaaj unu fi di powa weh Ai gi unu. Soh sayhn way, unu noh fi chaaj nobadi fi weh unu du fi dehn needa. ");
INSERT INTO bzj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Noh kehr no kaina moni eena yu ways bag, weda da goal, silva er kapa; ");
INSERT INTO bzj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","noh kehr no kitbag pahn di jerni, noh eevn wahn chaynj a kloaz er sandalz er waakin stik. Peepl weh werk dizerv fi geh weh dehn need. ");
INSERT INTO bzj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Soh wen unu goh eena wahn tong er wahn vilij, luk fi wahn gud persn weh wahn welkom unu, ahn stay deh til unu redi fi goh da di neks vilij. ");
INSERT INTO bzj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wen unu goh da sohnbadi hows, pay yu rispek. ");
INSERT INTO bzj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","If di peepl dehn deh dizerv it, mek unu blesin stay wid dehn. Bot if dehn noh dizerv it, tek bak unu blesin. ");
INSERT INTO bzj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","If dehn shoa unu bad fays ahn noh waahn lisn tu unu, wen unu lef da hows er da tong, shayk aaf di dos fahn aafa unu fut fronta dehn. ");
INSERT INTO bzj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ah di tel unu di chroot, wen Jojment Day kohn, ih wahn eeziya fi di peepl dehn fahn Sadam ahn Gomora dan fi dehn wan fahn datdeh tong weh rijek mi. ");
INSERT INTO bzj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Unu lisn ya. Ah di sen unu owt laik sheep monks dehn wulf. Soh unu fi bee waiz laik wahn snayk, bot sayhn taim, unu fi bee laik dehn dov weh noh wahn hert nobadi. ");
INSERT INTO bzj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Now unu mos kyaaful a dehn wan weh wahn ares unu ahn jreg unu da koat ahn flag unu eena dehn poblik meetn plays dehn. ");
INSERT INTO bzj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ahn sayka weh unu bileev eena mee, dehn wahn jreg unu fronta govna ahn king; bot dis wahn bee unu chaans fi tel dehn ahn aala dehn peepl weh da noh Joo di chroot bowt mee. ");
INSERT INTO bzj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Soh wen dehn ares unu, noh wori bowt weh unu wahn seh er how unu wahn seh it kaa Gaad wahn mek unu noa weh fi seh wen di taim kohn. ");
INSERT INTO bzj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kaa da noh unu wahn di taak, bot da di Spirit a Gaad unu Faada wahn di taak chroo unu. ");
INSERT INTO bzj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Wen da taim kohn, breda wahn di sel owt dehn oan breda mek dehn put dehn tu det, ahn pa wahn sel owt dehn oan pikni. Ahn pikni wahn ton gens dehn oan ma ahn pa mek dehn put dehn tu det. ");
INSERT INTO bzj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Evribadi wahn hayt unu sayka weh unu bileev eena mee. Bot Gaad wahn sayv enibadi weh stay faytful tu mee tu di en. ");
INSERT INTO bzj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wen peepl haraas unu da wan tong, hori ahn goh da wahn neks wan. Ah di tel unu dis: Di Son a Man wahn kohn bifoa unu wahn ku reech aala di tong dehn eena Izrel. ");
INSERT INTO bzj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Wahn styoodent noh moa impoatant dan dehn teecha, ahn no servant moa impoatant dan dehn baas needa. ");
INSERT INTO bzj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ih gud nof fi mek di styoodent bee sayhn laik ih teecha, ahn fi mek di servant bee sayhn laik ih maasta. If dehn kaal di hed a di famili Biyelzibob, wel, da weh wosa ting dehn wahn seh bowt di res a di famili den? ");
INSERT INTO bzj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Soh noh frayd fi nobadi! Di taim di kohn wen evriting weh deh anda kova wahn kom owt playn playn-wan, ahn evriting weh da seekrit wahn kom owt eena di oapm. ");
INSERT INTO bzj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Eniting weh Ah tel unu eena daak, unu mos taak it owt eena braad daylait, ahn eniting weh dehn wispa eena unu ayz, unu mos hala it owt fahn di howstap. ");
INSERT INTO bzj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Noh frayd fi dehn wan weh oanli ku kil unu badi, bot weh kyaahn kil unu soal. Insted, yu fi frayd fi di Wan weh ku dischrai yu soal ahn yu badi eena hel. ");
INSERT INTO bzj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Too lee berd oanli kaas wan sehn, bot non a dehn jrap da grong widowt yu Faada Gaad noa bowt it. ");
INSERT INTO bzj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hihn eevn konk humoch grayn a hyaa deh pahn yu hed. ");
INSERT INTO bzj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Soh noh frayd, unu wot moa tu hihn dahn wahn hoal flak a berd. ");
INSERT INTO bzj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“If enibadi oan op ahn seh fronta ada peepl dat dehn bilangz tu mee, Ai wahn oan dehn fronta mai Faada eena hevn tu. ");
INSERT INTO bzj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bot if enibadi play laik dehn noh noa mee fronta ada peepl, Ai wahn tel mi Faada dat Ai noh noa dehn needa. ");
INSERT INTO bzj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Unu tink seh Ai kohn fi bring pees pahn dis ert? No, man. Ai kohn fi bring wahn soad. ");
INSERT INTO bzj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ai kohn fi ton ‘son gens pa, ahn daata gens ma, ahn daata-in-laa gens mada-in-laa. ");
INSERT INTO bzj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yu wos enimi dehn wahn bee fahn owta yu oan famili.’ ");
INSERT INTO bzj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Evribadi weh lov dehn ma ahn dehn pa moa dahn mee noh dizerv fi bee mai disaipl. Ahn if dehn lov dehn son ahn dehn daata moa dahn mee, dehn noh dizerv fi bee mai disaipl dehn needa. ");
INSERT INTO bzj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ahn enibadi weh noh wilin fi bak dehn oan kraas ahn fala mee noh gud nof fi bee mai disaipl. ");
INSERT INTO bzj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Enibadi weh chrai fi heng aan tu dehn oan laif wahn en op di laas it, bot enibadi weh giv op dehn laif fi sayka mee wahn fain reel laif. ");
INSERT INTO bzj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Enibadi weh welkom unu welkom mee tu. Ahn enibadi weh aksep mee aksep di Wan weh sen mi. ");
INSERT INTO bzj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Enibadi weh welkom wahn prafit jos kaa ih da wahn prafit wahn geh di sayhn riwaad weh di prafit get. Ahn enibadi weh welkom wahn persn weh raichos jos kaa dehn raichos wahn geh di sayhn riwaad laik da persn deh. ");
INSERT INTO bzj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ah di tel unu di chroot, enibadi weh gi eevn wahn kop a koal waata tu di lees a dehn wan weh fala mi wahn geh dehn riwaad.” ");
INSERT INTO bzj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Afta Jeezas don tel ih twelv disaipl dehn weh fi du, ih gaan ahn staat tu teech ahn preech da di tong dehn. ");
INSERT INTO bzj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Jan di Baptis mi deh eena jayl wen ih yehr bowt aala di ting dehn weh Jeezas mi-di du. Soh Jan sen som a ih disaipl dehn fi goh aks Jeezas seh, “Yoo da di Wan weh fi kohn, er wi fi luk owt fi sohnbadi els?” ");
INSERT INTO bzj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jeezas ansa dehn seh, “Goh tel Jan aal weh unu si ahn aal weh unu yehr: ");
INSERT INTO bzj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Blain peepl geh bak dehn sait, dehn wan weh mi kripl ku waak agen, peepl weh mi ga leprosi geh heel, ahn def peepl ku yehr agen. Ded peepl kohn bak tu laif, ahn di poa geh di Gud Nyooz preech tu dehn. ");
INSERT INTO bzj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tel ahn tu dat Gaad bles enibadi weh noh rijek mi sayka weh aal Ai di du.” ");
INSERT INTO bzj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wen Jan disaipl dehn mi-di lef, Jeezas ton tu di krowd ahn staat tu taak tu dehn bowt Jan. Ih seh, “Da wat egzakli unu mi gaan owt eena di dezert fi si? Wahn lang pees a graas weh di sway eena di breez? ");
INSERT INTO bzj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bot tel mi, weh unu gaahn fi si? Wahn man jres op eena fansi kloaz? If unu waahn fain peepl weh jres op eena fansi kloaz, goh luk eena palis. ");
INSERT INTO bzj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Den weh unu gaahn fi si? Wahn prafit? Yes, unu gaahn fi si wahn prafit fi chroo, bot Ah tel unu, Jan da moch moa dahn jos wahn aadineri prafit. ");
INSERT INTO bzj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Hihn da di sayhn wan weh di Skripcha mi-di taak bowt wen ih seh, ‘Luk, Ah wahn sen mi mesinja heda yu. Hihn wahn mek shoar evriting redi fi yu.’ ");
INSERT INTO bzj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ah di tel unu di chroot, owta aala di pikni weh uman eva baan, non noh deh weh grayta dan Jan; bot in spait a dat, di lees impoatant persn weh da paat a di kingdom a hevn now, ga moa privilij dan Jan. ");
INSERT INTO bzj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Fahn Jan di Baptis dayz til now, di kingdom a hevn di moov faawod schrang-wan, ahn peepl di chrai haad fi foas dehn way eena it. ");
INSERT INTO bzj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aala weh mi hapm op tu Jan taim rait dong eena Moaziz Laa ahn eena aala di buk dehn weh di prafit dehn rait. ");
INSERT INTO bzj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ahn if unu wilin fi bileev weh dehn seh, den unu wahn noa seh dat Jan da Ilaija di prafit weh unu di wayt pan. ");
INSERT INTO bzj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Eni a unu weh ga ayz fi yehr, unu lisn gud! ");
INSERT INTO bzj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Da weh Ah ku tel unu dis jenarayshan stan laik? Dehn da jos laik sohn pikni weh di sidong eena wahn poblik maakit skwyaa di hala tu wan anada seh, ");
INSERT INTO bzj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Wi play floot fi unu ahn unu neva daans. Wi sing ded sang ahn unu neva baal.’ ");
INSERT INTO bzj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Wen Jan di Baptis kohn, hihn neva doz jrink ahn ih mi aalwayz di faas, ahn dehn seh, ‘Hihn mosi ga deeman.’ ");
INSERT INTO bzj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Now di Son a Man kohn di eet ahn jrink, ahn unu seh, ‘Luk how ih kraybm ahn ih da wahn jronkad, ahn ih fren op wid di taks kalekta dehn ahn ada peepl wid bad repyutayshan.’ Bot dehn wan weh fala Gaad wizdom wahn proov fi bee rait eena di langa ron.” ");
INSERT INTO bzj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Eena di tong dehn weh Jeezas mi du moas a ih mirakl dehn, di peepl dehn neva waahn ton fahn dehn sin dehn ahn ton tu Gaad. Soh Jeezas geh beks wid dehn ahn seh, ");
INSERT INTO bzj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Aiy, unu peepl da Korazin ahn Betsayda, unu een fi big chrobl. Kaa if dehn wikid peepl da Taiya ahn Saidan kuda mi si di mirakl dehn weh Ai mi du eena fi unu tong, dehn mi wahn ton fahn dehn sin dehn lang taim. Dehn wuda mi put aan krokos bag ahn sidong eena ashiz fi shoa how sari dehn sari. ");
INSERT INTO bzj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Soh Ah tel unu, ih wahn beta fi dehn wan da Taiya ahn Saidan dan fi unu pahn Jojment Day. ");
INSERT INTO bzj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ahn unu peepl da Kapernyam, unu tink seh Gaad wahn kehr unu da hevn? No, sa! Unu gwehn schrayt da hel! If di peepl dehn da Sadam mi si di mirakl dehn weh unu si, dehn siti mi wahn stil deh ya til tudeh day. ");
INSERT INTO bzj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Soh ih wahn beta fi dehn da Sadam dan fi unu pahn Jojment Day.” ");
INSERT INTO bzj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sayhn taim Jeezas seh, “Faada, yoo weh da di Laad a hevn ahn ert, Ah prayz yu kaa yu neva mek dehn wan weh ejukaytid ahn tink dehn soh smaat andastan aala dehn ting weh Ah jos tel mi disaipl dehn. Insteda dat, yu shoa it tu dehn wan weh hombl jos laik lee pikni. ");
INSERT INTO bzj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yes Faada, ih mek yu hapi fi du it soh.” ");
INSERT INTO bzj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Den ih tel ih disaipl dehn seh, “Mai Faada don gi mi atariti oava evriting. Nobadi noh reeli noa di Son eksep di Faada, ahn nobadi reeli noa di Faada eksep di Son, ahn enibadi els weh di Son waahn shoa ih Faada tu. ");
INSERT INTO bzj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Aala unu weh taiyad a kehr unu hevi load, kohn da mee an Ah wahn mek unu res. ");
INSERT INTO bzj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jos laik how dehn kow tek dehn wud yoak pahn dehn shoalda, tek mai yoak pahn fi yoo wan. Aksep weh Ah teech yu, ahn laan fahn mee kaa Ai payshent ahn jentl, ahn yu wahn fain res fi yu soal. ");
INSERT INTO bzj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Di yoak weh Ah gi yu noh haad fi bak, ahn di load weh Ah gi yu noh hevi ataal.” ");
INSERT INTO bzj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Rong da sayhn taim wen da mi di Sabat, Jeezas ahn ih disaipl dehn mi-di paas chroo sohn weet feel. Ih disaipl dehn mi hongri, soh dehn mi-di pap aaf di tap a som a di weet ahn eet it. ");
INSERT INTO bzj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Wen di Farisee dehn si weh mi-di hapm, dehn tel ahn seh, “Luk deh! Fi yoo disaipl dehn di du ting weh deh gens di Laa pahn di Sabat!” ");
INSERT INTO bzj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jeezas ansa seh, “Unu neva reed weh Dayvid ahn ih kompni dehn mi du wen dehn mi hongri noh? ");
INSERT INTO bzj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ih gaan eena di hows a Gaad ahn tek di hoali bred weh, akaadn tu di Laa, oanli di prees dehn mi sopoas tu eet; ahn hihn ahn ih man dehn eet it. ");
INSERT INTO bzj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ahn unu neva yet reed eena di Laa dat di prees dehn eena di templ brok di Sabat ahn stil dehn neva gilti a no sin? ");
INSERT INTO bzj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ah tel yu, sohnbadi deh ya weh grayta dan di templ. ");
INSERT INTO bzj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Eena di Skripcha Gaad seh, ‘Insteda aafa animal sakrifais tu mi, Ah wuda raada unu shoa peepl mersi.’ If unu mi oanli noa weh dat meen, den unu wudn kandem mi disaipl dehn weh neva du notn rang. ");
INSERT INTO bzj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yu si, di Son a Man ga atariti fi seh weh rait fi peepl du er kyaahn du pahn di Sabat.” ");
INSERT INTO bzj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","10","Jeezas lef fahn deh ahn gaahn da dehn meetn plays, ahn wahn man weh mi ga wahn kripl han mi dehdeh. Dehn mi ga sohn peepl weh mi-di luk fi wahn reezn fi akyooz Jeezas, soh dehn aks ahn seh, “Yoo tink ih rait fi heel sohnbadi pahn di Sabat?” ");
INSERT INTO bzj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jeezas aks dehn seh, “If eni a unu ga wahn sheep weh jrap eena wahn big hoal pahn di Sabat, unu noh wahn grab ahn, ahn haal ahn owt? ");
INSERT INTO bzj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wahn persn wot moch moa dahn wahn sheep. Soh di Laa alow wi fi du gud pahn di Sabat.” ");
INSERT INTO bzj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Den ih seh tu di man, “Schrech owt yu han.” Soh ih schrech owt ih han, ahn ih han kohn bak gud gud-wan, sayhn laik di ada han. ");
INSERT INTO bzj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bot di Farisee dehn lef ahn gaahn gaahn plan how dehn mi wahn kil Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jeezas mi kanchos a weh mi-di hapm, soh ih lef fahn deh. Ahn wahn big big krowd a peepl fala ahn, ahn ih heel aala dehn wan monks dehn weh mi sik. ");
INSERT INTO bzj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ih waan dehn noh fi tel nobadi bowt ahn. ");
INSERT INTO bzj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Dis mi hapm soh dat weh Aizaiya di prafit mi seh mi kohn chroo. Ih mi seh, ");
INSERT INTO bzj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Si mi servant weh Ah pik ya. Hihn da di Wan weh Ah lov tu nohmoh nohmoh an Ah oanli pleez wid ahn. Ah wahn gi ahn mi spirit, ahn hihn wahn joj aala di nayshan dehn. ");
INSERT INTO bzj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mai servant hihn noh wahn kwaaril ner hala; ahn nobadi noh wahn yehr fi hihn vais owta schreet needa. ");
INSERT INTO bzj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Hihn noh wahn step pahn peepl weh week, er goh wid dehn laas lee hoap til ih mek shoar dat jostis win owt pahn di en. ");
INSERT INTO bzj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ahn aala di nayshan dehn wahn put dehn hoap eena hihn.” ");
INSERT INTO bzj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dehn mi ga wahn man weh mi dom ahn blain sayka weh ih mi ga deeman eena ahn, ahn dehn bring ahn da Jeezas mek ih heel ahn. Soh Jeezas heel ahn, ahn den di man kuda mi taak ahn si. ");
INSERT INTO bzj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Di peepl dehn kudn bileev dehn aiy ahn dehn seh, “Yoo tink seh dis da di king weh Gaad pramis fi sen chroo King Dayvid famili lain?” ");
INSERT INTO bzj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Wen di Farisee dehn yehr dis, dehn seh, “Da Biyelzibob, weh da di hed a aala di deeman dehn, gi dis man di powa fi jraiv owt deeman.” ");
INSERT INTO bzj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jeezas mi noa weh dehn mi-di tink, soh ih tel dehn seh, “Evri konchri weh di peepl dehn di fait gens wan anada, ahn evri siti er famili weh di peepl dehn di fait gens wan anada, noh wahn mek it. ");
INSERT INTO bzj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","If Saytan di jraiv owt fi hihn oan deeman dehn, ih di fait gens ih oanself; den da how fi hihn kingdom wahn mek it? ");
INSERT INTO bzj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","If da Biyelzibob gi mee di powa fi jraiv owt deeman, den da hoo gi fi unu peepl dehn powa fi jraiv dehn owt? Da fi unu peepl sayhn wan wahn joj unu. ");
INSERT INTO bzj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bot if da Gaad Spirit di mek Ai jraiv owt deeman, den dat shoa dat hihn don staat fi hihn kingdom monks unu aredi. ");
INSERT INTO bzj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Yoo tink seh yu ku jos goh eena di hows a sohnbadi weh schrang laik Saytan ahn tek weh ih ting dehn? No. Yu hafu tai ahn op fos. Den yu ku tek dehn weh. ");
INSERT INTO bzj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Enibadi weh noh deh wid mi deh gens mi kaa if unu noh di help mi gyada, den unu di skyata. ");
INSERT INTO bzj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Soh Ah di tel unu, Gaad wahn fagiv eni sinful ting weh enibadi du er seh, noh kay how bad ih bad. Bot Gaad wahn neva fagiv nobadi weh taak gens di Hoali Spirit. ");
INSERT INTO bzj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Gaad wahn fagiv dehn wan weh taak gens di Son a Man, bot if enibadi taak gens di Hoali Spirit, Gaad wahn neva fagiv dehn, noh eena dis laif ner di neks.” ");
INSERT INTO bzj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jeezas gaan aan fi seh, “Fi geh gud froot, yu hafu ga wahn helti chree; if yu noh ga wahn helti chree, den yu noh wahn geh gud froot. Peepl ku aalwayz tel weh kaina chree di groa bai di kaina froot weh ih bayr. ");
INSERT INTO bzj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Unu da snayk ahn unu pa dehn da-mi snayk tu! How unu weh soh wikid ku eva seh eniting gud? Wateva unu haat ful op wid, dat da weh wahn kom owta unu mowt. ");
INSERT INTO bzj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wen wahn man haat ful op a loan gud ting, oanli gud ting wahn kom owta it, bot wen ih haat ful op a loan bad ting, den oanli bad ting wahn kom owt deh. ");
INSERT INTO bzj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ah di tel unu, pahn Jojment Day unu wahn gi akonk fi evri wotlis werd weh unu eva seh, ");
INSERT INTO bzj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","kaa da fi unu sayhn werd dehn wahn joj unu az tu weda unu inosent er gilti.” ");
INSERT INTO bzj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sohn Farisee ahn teecha a di Laa seh tu Jeezas, “Teecha, du wahn mirakl mek wi si wahn sain fahn yu noh?” ");
INSERT INTO bzj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jeezas ansa dehn seh, “Disya jenarayshan wikid; dehn noh faytful tu Gaad ataal. Dehn di aks fi wahn sain fahn hevn, bot di oanli sain dehn wahn geh da di sain weh dehn geh fahn weh mi hapm wid Joana. ");
INSERT INTO bzj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jos laik how Joana mi deh eena wahn big fish beli fi chree dayz ahn chree naits, sayhn way di Son a Man wahn deh eena di ert fi chree dayz ahn chree naits. ");
INSERT INTO bzj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Wen Jojment Day kohn, di peepl dehn fahn Niniveh wahn deh rait deh di stan op lang wid unu peepl fahn dis jenarayshan; ahn dehn wahn akyooz unu, kaa wen Joana mi preech tu dehn, dehn ton fahn dehn sin dehn. Now sohnbadi deh ya weh grayta dan Joana. ");
INSERT INTO bzj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wen Jojment Day kohn, di Kween a Sheeba wahn rayz op lang wid di peepl dehn fahn dis jenarayshan ahn shee sayhn wan wahn taak gens dehn; kaa shee chravl way fahn di en a di ert jos fi lisn tu Salaman wizdom. Ahn now sohnbadi grayta dan Salaman deh rait ya soh, ahn unu rifyooz fi lisn tu hihn. ");
INSERT INTO bzj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Now wen wahn eevl spirit kom owta wahn persn, ih wanda bowt eena dehn plays weh emti ahn jrai di luk fi sohnweh fi res. Ahn wen ih noh fain no way fi goh, ih seh, ‘Ah gwehn rait bak weh Ah kohn fram.’ ");
INSERT INTO bzj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Bot wen ih get bak, ih si dat di plays emti ahn kleen ahn wel fiks op. ");
INSERT INTO bzj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Soh ih kehr sebm moa eevl spirit weh wikida dan hihn, lang wid ahn. Ahn aala dehn setl een kwait gud. Soh den, da persn en op wosa aaf dan how ih mi stan fos. Di sayhn ting wahn hapm tu unu wikid peepl weh di liv eena dehnya taim ya.” ");
INSERT INTO bzj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sayhn taim Jeezas mi-di taak tu di krowd dehn, ih ma ahn ih breda dehn kohn ahn stan op owtsaid kaa dehn mi waahn taak tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sohnbadi tel ahn seh, “Yu ma ahn yu breda dehn deh owtsaid ahn dehn waahn taak tu yu.” ");
INSERT INTO bzj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jeezas ansa dehn seh, “Hoo da mi ma? Hoo da mi breda dehn?” ");
INSERT INTO bzj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Den ih paint tu ih disaipl dehn ahn ih seh, “Si mi ma ahn mi breda dehn rait ya. ");
INSERT INTO bzj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Enibadi weh du weh mi Faada eena hevn waahn da mi breda, ahn mi sista, ahn mi ma.” ");
INSERT INTO bzj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Da sayhn day Jeezas gaan owta di hows ahn gaahn sidong bai di lagoon. ");
INSERT INTO bzj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Di krowd weh mi gyada rong ahn mi soh big dat hihn mi hafu get eena wahn boat ahn sidong een deh wail di hoal krowd stan op pahn shoa. ");
INSERT INTO bzj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Den ih yooz sohn lee stoari fi teech dehn lata tingz. Ih seh, “Wahn faama gaahn gaahn plaant sohn seed. ");
INSERT INTO bzj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wail ih mi-di skyata di seed dehn, sohn jrap pahn di lee pikaado road ahn berd kohn ahn eet dehn op. ");
INSERT INTO bzj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Den som a di seed dehn jrap pahn grong weh mi raki ahn oanli lee bit a ert mi dehdeh, soh di seed dehn sprowt op kwik-wan. ");
INSERT INTO bzj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bot wen di son kom op, ih bon op di plaant dehn, ahn laik how oanli lee bit a ert mi dehdeh, dehn neva tek root gud, soh dehn wida weh. ");
INSERT INTO bzj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Sohn ada seed jrap monks sohn prikl bush ahn di prikl bush groa op ahn choak di plaant dehn. ");
INSERT INTO bzj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Now sohn neks seed jrap pahn gud grong ahn dehn bayr gud. Som a dehn bayr wahn honjrid taim moa dahn weh di faama mi plaant, ahn sohn bayr siksti taim moa, ahn sohn bayr terti taim moa. ");
INSERT INTO bzj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Eni a unu weh ga ayz fi yehr, unu lisn gud!” ");
INSERT INTO bzj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Den di disaipl dehn kohn tu Jeezas ahn aks ahn seh, “Da wai yoo yooz dehn lee stoari fi teech di peepl dehn?” ");
INSERT INTO bzj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jeezas ansa dehn seh, “Gaad pik unu fi noa di seekrit bowt fi hihn kingdom, bot dehn ada peepl noh wahn noa it. ");
INSERT INTO bzj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Evribadi weh don ga, wahn geh moa, ahn den dehn wahn ga lat lat lat, bot fi dehn wan weh noh ga notn, eevn di lee bit weh dehn ga wahn geh tek weh fahn dehn. ");
INSERT INTO bzj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ai yooz dehn lee stoari fi teech dehn kaa wen dehn luk, dehn noh wahn si, ahn wen dehn yehr, dehn noh wahn andastan. ");
INSERT INTO bzj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Soh dat shoa dat weh Aizaiya di prafit mi seh bowt dehn kohn chroo. Ih mi seh, ‘Dehnya peepl wahn lisn ahn lisn tu weh Ah seh, bot dehn noh wahn andastan wan ting. Dehn wahn luk ahn luk bot dehn stil noh wahn si. ");
INSERT INTO bzj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Dehn haat geh haad, da sayhn laik stik brok eena dehn ayz, ahn dehn kova op dehn aiy. If dehn neva du dat, den dehn kuda mi si wid dehn aiy, ahn yehr wid dehn ayz. Ahn den dehn kuda mi reeli andastan wid dehn haat ahn ton tu mi fi mek Ah heel dehn.’ ");
INSERT INTO bzj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Gaad bles unu kaa unu ga aiy weh ku si, ahn unu ga ayz weh ku yehr! ");
INSERT INTO bzj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ah tel unu fi chroo, wahn lata dehn oal taim prafit ahn gud peepl mi reeli waahn si ahn yehr di ting dehn weh unu si ahn yehr, bot dehn kudn.” ");
INSERT INTO bzj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Now lisn tu weh di parabl bowt di faama meen. ");
INSERT INTO bzj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wen enibadi yehr di mesij bowt di kingdom a hevn ahn dehn noh andastan it, di devl hori kohn kohn tek it weh fahn owta dehn haat. Dat da laik di seed dehn weh mi jrap pahn di lee pikaado road. ");
INSERT INTO bzj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Di seed dehn weh jrap pahn grong weh raki stan fi dehn wan weh yehr di Werd a Gaad ahn dehn oanli tu hapi fi aksep di mesij rait away. ");
INSERT INTO bzj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bot di seed neva tek no root eena dehn haat. Dehn stik it owt fi wahn lee wail, bot wen lee chroblz er chraiyalz kohn sayka weh dehn bileev di mesij, dehn jrap weh kwik-taim. ");
INSERT INTO bzj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Di seed dehn weh jrap monks di prikl bush dehn stan fi dehn wan weh yehr di Werd a Gaad, bot di woriz a laif ahn sayka weh dehn waahn geh rich soh bad, dehn mek di mesij geh choak owta dehn, ahn notn gud kyaahn kom owta dehn laif. ");
INSERT INTO bzj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bot dehn seed weh jrap pahn di gud grong stan fi dehn peepl weh yehr di Werd a Gaad ahn andastan it. Den dehn bayr fi chroo—moa ahn moa gud ting kom owta dehn laif, jos laik how di faama geh terti ahn siksti ahn honjrid taim moa dahn weh ih mi plaant.” ");
INSERT INTO bzj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Den Jeezas tel dehn dis lee stoari: “Di kingdom a hevn da laik weh hapm wen wahn faama skyata gud seed eena wahn feel. ");
INSERT INTO bzj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bot wail evribadi mi-di sleep, wahn enimi kohn ahn skyata sohn seed fahn wahn paiznos plaant eena di feel, ahn den ih gaan. ");
INSERT INTO bzj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wen di plaant dehn staat tu groa, di bad seed dehn mi-di groa lang wid di gud seed dehn tu. ");
INSERT INTO bzj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Den di faama servant dehn kohn kohn aks ahn seh, ‘Sa, yoo neva skyata gud seed eena yu feel? Da wehpaa dehnya weed dehn kohn fram, den?’ ");
INSERT INTO bzj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ih seh, ‘Wahn enimi du dat.’ “Den ih servant dehn aks ahn seh, ‘Yu waahn wi goh pul owt di weed dehn fi yu?’ ");
INSERT INTO bzj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Di faama ansa dehn seh, ‘No, noh du dat, kaa yu mait pul op di gud plaant dehn lang wid di weed dehn. ");
INSERT INTO bzj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lef dehn loan til taim fi reep di krap. Den Ah wahn mek di werka dehn gyada di weed dehn ahn tai dehn op ahn bon dehn. Bot Ah wahn mek dehn put op di weet dehn eena mi stoaroom.’” ");
INSERT INTO bzj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jeezas tel dehn wahn nada lee stoari. Ih seh, “Di kingdom a hevn da laik wahn lee kungku mostad seed weh sohnbadi plaant eena ih feel. ");
INSERT INTO bzj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Dat da di smaalis seed owta aala di seed dehn, bot wen ih don geh big, da di bigis gyaadn plaant weh yu ku fain, ahn den ih ton intu wahn chree, soh dat di berd dehn eena di skai kohn kohn mek nes eena di branch dehn.” ");
INSERT INTO bzj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Den Jeezas tel dehn wahn neks lee stoari. Ih seh, “Di kingdom a hevn da laik ees weh wahn laydi miks wid wahn hoal lata flowa ahn di ees mek di hoal doa rayz.” ");
INSERT INTO bzj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Wen Jeezas tel di peepl dehn aala dehnya ting, ih yooz loan parabl. Ih neva tel dehn notn widowt yooz dehn lee stoari. ");
INSERT INTO bzj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Soh Gaad pramis mi kohn chroo jos laik weh di prafit mi seh. Ih mi seh, “Ah wahn yooz stoari fi teech mi mesij, ahn fi eksplayn dehn ting weh mi haid sins di biginin a di werl.” ");
INSERT INTO bzj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Afta Jeezas lef di krowd, ih gaan eensaid. Ih disaipl dehn gaahn tu ahn, ahn seh, “Tel wi di meenin a di stoari bowt di weed plaant dehn eena di feel.” ");
INSERT INTO bzj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jeezas ansa dehn seh, “Di wan weh skyata di gud seed da di Son a Man. ");
INSERT INTO bzj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Di feel da di werl ahn di gud seed dehn da di peepl dehn weh bilangz tu di kingdom a hevn. Di weed dehn da dehn peepl weh bilangz tu Gaad enimi, weh da di devl. ");
INSERT INTO bzj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ahn di devl ihself da di wan weh plaant di bad seed dehn. Wen di krap geh reep da di taim wen di en a di werl kohn, ahn dehn wan weh reep di krap dehn da aynjel. ");
INSERT INTO bzj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Dehn wahn gyada di weed dehn ahn bon dehn op. Dat da how ih wahn hapm wen di en a di werl kohn. ");
INSERT INTO bzj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Di Son a Man wahn sen owt ih aynjel dehn, ahn dehn wahn gyada evribadi weh du rang ting er mek ada peepl sin. ");
INSERT INTO bzj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Den di aynjel dehn wahn chroa dehn eena hel weh di faiya hat hat hat, ahn wehpaa peepl wahn di baal ahn grain op dehn teet eena payn. ");
INSERT INTO bzj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bot aala Gaad peepl dehn wahn shain laik di son eena dehn Faada kingdom. Eni a unu weh ga ayz fi yehr, unu lisn gud! ");
INSERT INTO bzj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Di kingdom a hevn da laik chreja weh haid weh eena wahn feel. Den sohnbadi fain it ahn den dehn ton rong ahn haid it weh agen. Di man weh mi fain di chreja mi soh hapi dat ih gaahn gaahn sel evriting weh ih mi ga ahn bai di hoal feel. ");
INSERT INTO bzj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ahn den tu, di kingdom a hevn da laik wahn biznizman weh aalwayz deh pahn di lukowt fi gud perl. ");
INSERT INTO bzj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wen ih fain wan weh wot lata lata moni, ih sel evriting weh ih mi ga ahn gaahn gaahn bai it. ");
INSERT INTO bzj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Den di kingdom a hevn da laik wahn net weh dehn chroa eena di see, ahn da net kech aal kaina fish weh deh. ");
INSERT INTO bzj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wen di net mi ful, dehn haal it op pahn shoa, ahn dehn sidong ahn put aala di gud fish dehn eena baaskit ahn chroh-weh di bad wan dehn. ");
INSERT INTO bzj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Da jos laik dat ih wahn bee wen di en a di werl kohn. Di aynjel dehn wahn kohn ahn separayt di wikid peepl dehn fahn dehn wan weh rait wid Gaad. ");
INSERT INTO bzj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Den dehn wahn chroa di wikid wan dehn eena faiya wichpaa lata baalin wahn deh, ahn peepl wahn di grain op dehn teet.” ");
INSERT INTO bzj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jeezas aks dehn seh, “Unu andastan aala dis?” Dehn ansa seh, “Yes, wi andastan.” ");
INSERT INTO bzj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Den Jeezas tel dehn seh, “Wel dat gud, kaa evri teecha a di Laa weh ton wahn falowa eena di kingdom a hevn wahn di bring owt nyoo teechin ahn oal teechin sayhn laik di oana a wahn hows weh bring owt oal ahn nyoo ting owta ih stoaroom.” ");
INSERT INTO bzj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Soh wen Jeezas don tel di peepl dehn di parabl dehn, ih lef fahn da plays deh. ");
INSERT INTO bzj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Wen ih gaahn da ih oan hoamtong, ih gaahn gaahn teech eena dehn meetn plays, ahn di peepl dehn kudn bileev dehn ayz wen dehn yehr weh ih mi-di seh. Dehn seh, “Da weh dis man geh soh moch wizdom fram? Ahn da weh hihn geh powa fram fi du aala dehn mirakl? ");
INSERT INTO bzj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Dis da noh di kyapmta son? Mayri da noh fi hihn ma? Jaymz ahn Joazef ahn Saiman ahn Joodas da noh fi hihn breda dehn? ");
INSERT INTO bzj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Aala ih sista dehn noh deh rait ya wid wi? Soh da weh hihn geh dehnya ting fram?” ");
INSERT INTO bzj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Afta Jeezas don tel dehn dat, dehn mi feel ofendid. Bot Jeezas tel dehn seh, “Da oanli da ih oan hoamtong ahn eena ih oan hows wahn prafit noh geh no rispek.” ");
INSERT INTO bzj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Soh ih neva du moch mirakl deh sayka weh dehn neva ga no fayt. ");
INSERT INTO bzj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Now nyooz bowt weh aal Jeezas mi-di du get eena King Herod ayz. Hihn da-mi di roola oava Gyalilee. ");
INSERT INTO bzj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ih tel ih servant dehn seh, “Dis da Jan di Baptis weh rayz op bak fahn di ded. Dats wai ih ku du aala dehn mirakl ahn soh.” ");
INSERT INTO bzj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yu si, Herod mi ares Jan ahn tai ahn op ahn put ahn eena jayl sayka Heroadyas, weh doz bee Herod breda Filip waif. ");
INSERT INTO bzj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kaa Jan mi-di tel ahn seh, “Ih gens di laa fi mek yu marid tu shee.” ");
INSERT INTO bzj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod mi waahn kil ahn, bot ih mi frayd fi di peepl dehn kaa dehn mi luk pahn Jan az wahn prafit. ");
INSERT INTO bzj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Bot wen Herod bertday kohn, Heroadyas daata daans fi Herod ahn ih kompni dehn. Herod mi laik how ih daans, soh ih mek wahn oat tu ahn, ahn pramis fi gi ahn eniting weh ih aks fa. ");
INSERT INTO bzj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Di gyal ma tel ahn fi seh dis, “Ah waahn Jan di Baptis hed rait ya pahn wahn chray.” ");
INSERT INTO bzj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Herod mi oanli sari, bot sayka di oat dehn weh ih mi mek, ahn sayka ih ges dehn, ih gi di koman fi mek dehn du weh di gyal mi aks fa. Soh Herod sen fi mek dehn chap aaf Jan hed eena di jayl. ");
INSERT INTO bzj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ahn dehn bring ih hed pahn wahn chray ahn gi di gyal, ahn den shee kehr it da ih ma. ");
INSERT INTO bzj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jan disaipl dehn kohn ahn kehr weh ih badi ahn beri ahn. Den dehn gaahn gaahn tel Jeezas weh hapm. ");
INSERT INTO bzj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Wen Jeezas yehr weh mi hapm, ih gaahn fahn deh eena wahn boat da wahn kwaiyet spat soh ih kuda mi bee bai ihself. Wen di krowd dehn fahn di tong dehn yehr dis, dehn fala ahn pahn fut. ");
INSERT INTO bzj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Wen Jeezas gaahn shoa, ih si wahn big krowd ahn ih mi sari fi dehn ahn ih heel dehn wan weh mi sik. ");
INSERT INTO bzj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Az eevnin mi-di set een, di disaipl dehn kohn tu Jeezas ahn seh, “Dis da wahn dizertid plays, ahn ih don di geh layt. Sen di krowd weh, soh dehn ku goh da di vilij dehn ahn bai sohnting fi dehnself fi eet.” ");
INSERT INTO bzj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bot Jeezas tel dehn seh, “Dehn noh hafu goh no way. Wai unu noh feed dehn?” ");
INSERT INTO bzj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Dehn ansa ahn seh, “Wee oanli ga faiv bred ahn too fish.” ");
INSERT INTO bzj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jeezas seh, “Bring dehn ya fi mi.” ");
INSERT INTO bzj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Den Jeezas mek di peepl dehn sidong pahn di graas. Ih tek di faiv bred ahn too fish ahn luk op da hevn ahn gi Gaad tanks. Den ih brok di bred ahn ih gi di disaipl dehn fi gi di peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Evribadi eet til dehn ful, ahn den di disaipl dehn pik op hoal a twelv baaskit ful a di lee pees a bred dehn ahn fish weh mi lefoava. ");
INSERT INTO bzj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Da mi bowt faiv towzn man aloan weh mi eet bisaidz uman ahn pikni. ");
INSERT INTO bzj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Rait afta dat Jeezas mek ih disaipl dehn get eena di boat ahn goh heda ahn da di neks said a di lagoon wail hihn sen di krowd hoahn. ");
INSERT INTO bzj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wen Jeezas don sen di peepl dehn hoahn, ih gaan op pahn di mongtin bai ihself gaahn pray. Wen eevnin kohn, ih mi dehdeh bai ihself. ");
INSERT INTO bzj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bai dis taim di boat mi deh faar fahn lan, ahn di wayv dehn mi-di beet pan it kaa di breez mi deh gens dehn. ");
INSERT INTO bzj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bowt chree aklak da maanin Jeezas kohn tu dehn di waak pahn di waata tap. ");
INSERT INTO bzj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bot wen di disaipl dehn si ahn di waak pahn di waata tap, dehn mi fraitn no miks, ahn dehn seh, “Da wahn goas!” Dehn mi-di baal owt weh dehn mi soh frayd. ");
INSERT INTO bzj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bot rait away Jeezas tel dehn seh, “Noh hat unu haat. Da mee. Noh frayd.” ");
INSERT INTO bzj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Den Peeta seh, “Laad, if da yoo fi chroo, den tel mi fi kohn tu yu pahn di waata tap.” ");
INSERT INTO bzj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jeezas tel ahn seh, “Kohn!” Soh Peeta klaim owta di boat ahn staat tu waak pahn di waata tap tu Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bot wen ih noatis how haad di breez mi-di bloa, ih geh frayd ahn ih staat tu sink dong eena di waata. Ih hala, “Laad, sayv mi!” ");
INSERT INTO bzj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Rait away Jeezas schrech owt ih han ahn grab ahn. Den ih seh, “Fi yoo fayt leel, sa! Da wai yu mi dowt mi?” ");
INSERT INTO bzj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ahn wen dehn get eena di boat, di breez jrap. ");
INSERT INTO bzj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Den dehn wan weh mi deh eena di boat wership Jeezas ahn seh, “Yoo da Gaad Son fi chroo!” ");
INSERT INTO bzj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ahn wen dehn kraas oava di neks said a di lagoon, dehn gaahn shoa da Genesaret. ");
INSERT INTO bzj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ahn wen di peepl dehn fahn deh rekonaiz Jeezas, dehn sen fi aala di sik peepl dehn eena di ayrya ahn bring dehn tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dehn bayg ahn fi mek dehn ku at lees toch di ej a ih kloaz, ahn evri wan a dehn weh toch ahn geh heel. ");
INSERT INTO bzj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Den sohn Farisee ahn sohn teecha a di Laa kohn tu Jeezas fahn Jeroosalem ahn aks ahn seh, ");
INSERT INTO bzj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Da wai fi yoo disaipl dehn noh goh chroo di washin serimoni bifoa dehn eet, laik how di oal taim peepl dehn doz du?” ");
INSERT INTO bzj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jeezas ansa dehn seh, “Ahn da wai unu brok Gaad komanment jos sayka kip op fi unu oan ting dehn weh unu du? ");
INSERT INTO bzj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kaa Gaad seh, ‘Unu mos aana unu ma ahn unu pa,’ ahn den ih seh, ‘Enibadi weh taak bad bowt dehn ma ahn dehn pa wahn hafu geh put tu det.’ ");
INSERT INTO bzj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bot unu seh dat if sohnbadi tel dehn ma er dehn pa dat wateva dehn mi ga fi gi dehn, dehn gi Gaad insted, ");
INSERT INTO bzj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","den dat meen dat da persn noh wahn hafu aana dehn ma ner dehn pa, ahn soh dehn noh wahn hafu gi dehn notn. Soh sayka fi unu roolz dehn weh unu mek op, unu mek di Werd a Gaad noh meen notn. ");
INSERT INTO bzj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Unu hipokrit unu! Weh Aizaiya di prafit mi seh bowt unu da chroo. Ih mi seh, ");
INSERT INTO bzj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Dehnya peepl aana mi wid dehn mowt, bot dehn haat deh faar fahn mi. ");
INSERT INTO bzj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dehn wership noh meen notn tu mi kaa dehn di teech fi dehn oan roolz, weh dehn mek op laik ih kohn fahn Gaad.’” ");
INSERT INTO bzj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Den Jeezas kaal di peepl dehn tu ahn, ahn ih tel dehn seh, “Unu lisn ahn andastan weh Ah seh. ");
INSERT INTO bzj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Da noh weh goh eena sohnbadi mowt weh mek dehn haat doti, bot weh kom owta dehn mowt, dat da weh mek dehn haat doti.” ");
INSERT INTO bzj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Den di disaipl dehn kohn tu Jeezas ahn tel ahn seh, “Yoo mi noa seh dat di Farisee dehn mi wel ofendid wen dehn yehr weh yoo seh?” ");
INSERT INTO bzj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jeezas ansa seh, “Evri plaant weh mai Faada eena hevn neva plaant wahn geh root op. ");
INSERT INTO bzj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Lef dehn loan; dehn da jos sohn gaid weh blain. Ahn if wahn man weh blain leed rong wahn nada blain man, den too a dehn wahn jrap eena hoal.” ");
INSERT INTO bzj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Den Peeta seh tu ahn, “Tel wi weh yu meen wen yu taak bowt weh mek peepl haat doti.” ");
INSERT INTO bzj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jeezas ansa seh, “Unu stil noh andastan needa? ");
INSERT INTO bzj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Unu noh si seh dat eniting weh goh eena yu mowt paas chroo yu stomok ahn den ih paas owta yu badi? ");
INSERT INTO bzj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bot weh kom owta wahn persn mowt kohn fahn dehn haat, ahn dat da weh mek dehn doti fi chroo. ");
INSERT INTO bzj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kaa weh deh eena wahn persn haat da weh mek dehn tink op fi du aal kaina bad ting, laik merda, ahn cheet pahn dehn hozban er dehn waif, sleep rong, teef, tel lai ahn slanda peepl. ");
INSERT INTO bzj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dehn wikid ting deh da weh doti wahn persn haat. Bot fi eet widowt wash dehn han noh mek dehn haat doti.” ");
INSERT INTO bzj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Den Jeezas lef fahn deh ahn gaahn da di ayrya weh deh kloas Taiya ahn Saidan. ");
INSERT INTO bzj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sayhn taim wahn laydi fahn Kaynan weh mi liv rong deh kom op tu ahn, ahn hala seh, “Laad, yoo weh da Dayvid Son, ga mersi pahn mi noh! Mi daata ga wahn eevl spirit weh di taament ahn.” ");
INSERT INTO bzj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bot Jeezas neva ansa di laydi wan werd. Ih disaipl dehn kom op tu ahn, ahn bayg ahn seh, “Wai yu noh sen shee weh? Shee loan di fala wee ahn di hala ting.” ");
INSERT INTO bzj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Den Jeezas seh tu di laydi, “Gaad oanli sen mee tu dehn peepl da Izrel weh da laik sheep weh laas.” ");
INSERT INTO bzj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Bot di laydi kohn kohn neel dong fronta Jeezas ahn seh, “Laad, help mi noh?” ");
INSERT INTO bzj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jeezas ansa di laydi seh, “Ih noh rait fi tek di pikni dehn bred ahn chroa it fi di daag dehn.” ");
INSERT INTO bzj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Di laydi seh, “Da chroo, Sa, bot eevn di daag dehn eet di kromz weh jrap fahn aafa di maasta taybl.” ");
INSERT INTO bzj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jeezas ansa ahn seh, “Mis, yoo ga lata fayt fi chroo! Yu wahn geh weh yu aks fa.” Ahn sayhn taim di laydi daata geh heel. ");
INSERT INTO bzj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Afta Jeezas lef fahn deh, ih paas lang Gyalilee Lagoon, ahn den ih gaan op di mongtin gaahn sidong. ");
INSERT INTO bzj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Wahn hoal krowd a peepl kohn tu ahn, ahn dehn bring aala dehn wan weh mi kripl, ahn haafa, ahn blain, ahn dom, ahn lat moa. Dehn put dehn bai Jeezas fut, ahn ih heel dehn; ");
INSERT INTO bzj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ahn di krowd dehn mi sopraiz wen dehn yehr dom peepl di taak, ahn dehn kudn bileev dehn aiy wen dehn si dehn wan weh mi haafa geh gud agen, ahn dehn kripl wan di waak, ahn di blain wan dehn di si. Ahn dehn prayz di Gaad a Izrel. ");
INSERT INTO bzj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Den Jeezas kaal ih disaipl dehn tu ahn, ahn seh, “Ah sari fi dis krowd kaa dehn deh wid mi fi chree dayz now, ahn dehn noh ga notn fi eet; an Ah noh waahn sen dehn weh hongri, kaa rekli wen yu luk, dehn jrap dong pahn di way.” ");
INSERT INTO bzj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Di disaipl dehn seh tu Jeezas, “Da weh wi wahn geh soh moch food way owt ya bakabush fi feed dis krowd?” ");
INSERT INTO bzj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Den Jeezas aks dehn seh, “Humoch bred deh?” Dehn seh, “Wel, wi ga sebm bred, ahn wan ahn too lee fish.” ");
INSERT INTO bzj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Soh ih tel di krowd fi sidong pahn di grong. ");
INSERT INTO bzj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ih tek di sebm bred ahn di fish dehn, ahn wen ih don gi Gaad tanks far it, ih brok dehn eena peesiz ahn ih gi ih disaipl dehn fi shayr monks di peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Aala dehn eet til dehn geh nof, ahn dehn gyada op sebm baaskit a brok-op bred weh mi lefoava. ");
INSERT INTO bzj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Di amonk a peepl weh mi eet da day da-mi foa towzn man, bisaidz uman ahn pikni. ");
INSERT INTO bzj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Afta Jeezas sen di krowd hoahn, ih get eena wahn boat ahn gaahn da di ayrya weh dehn kaal Magadan. ");
INSERT INTO bzj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Di Farisee ahn di Sadyusee dehn kohn fi chrai tes owt Jeezas, soh dehn aks ahn fi du wahn mirakl az wahn sain fi shoa dat hihn kohn fahn Gaad. ");
INSERT INTO bzj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jeezas ansa dehn seh, “Wen da eevnin taim unu seh, ‘Di weda wahn gud kaa di skai red.’ ");
INSERT INTO bzj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ahn maanin taim unu seh, ‘Staam wahn deh kaa di skai red ahn ih di blak op.’ Unu noa how fi reed di sain dehn eena di skai, soh how kom unu noh andastan di sain dehn weh shoa weh Gaad di du rait now? ");
INSERT INTO bzj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Disya jenarayshan wikid; dehn noh faytful tu Gaad ataal. Dehn di aks fi wahn sain fahn hevn, bot di oanli sain dehn wahn geh da di sain weh dehn geh fahn weh mi hapm wid Joana.” Den Jeezas lef deh ahn gaan. ");
INSERT INTO bzj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Di disaipl dehn mi faget fi kehr bred wen dehn gaahn kraas di neks said a di lagoon. ");
INSERT INTO bzj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jeezas tel dehn seh, “Unu beta main; kyaaful a di Farisee ahn di Sadyusee dehn ees.” ");
INSERT INTO bzj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Di disaipl dehn mi-di taak bowt it monks dehnself. Dehn seh, “Hihn seh dat kaa wi neva bring no bred.” ");
INSERT INTO bzj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Bot Jeezas mi kanchos a weh dehn mi-di seh, soh ih seh, “Unu fayt leel, sa. Da wai unu di taak monks unuself bowt how unu noh ga no bred? ");
INSERT INTO bzj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Unu stil noh si yet? Unu noh memba di faiv bred weh feed di faiv towzn peepl dehn, ahn humoch baaskit a lefoava bred unu gyada op? ");
INSERT INTO bzj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Er di sebm bred weh mi feed di foa towzn peepl dehn, ahn humoch baaskit unu gyada op? ");
INSERT INTO bzj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Soh da how unu kudn si dat Ah neva mi-di taak bowt bred? Kyaaful a di Farisee ahn Sadyusee dehn ees.” ");
INSERT INTO bzj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Da den dehn mi jos andastan dat Jeezas neva mi-di tel dehn fi kyaaful a di ees weh deh eena bred, bot da mi di teechin a di Farisee ahn di Sadyusee dehn ih mi-di taak bowt. ");
INSERT INTO bzj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Now wen Jeezas kohn tu di ayrya rong Seezareeya Filipai, ih aks ih disaipl dehn, “Da hoo peepl seh da di Son a Man?” ");
INSERT INTO bzj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dehn tel ahn seh, “Sohn peepl seh dat yoo da Jan di Baptis; sohn ada wan seh yoo da Ilaija; ahn stil sohn neks wan dehn seh yoo da Jerimaiya er wan a di prafit dehn.” ");
INSERT INTO bzj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Den Jeezas aks dehn seh, “Bot da hoo yoo seh da mee?” ");
INSERT INTO bzj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saiman Peeta ansa seh, “Yoo da di Krais weh da di Son a di livin Gaad.” ");
INSERT INTO bzj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ahn Jeezas ansa ahn seh, “Saiman, weh da Joana son, Gaad bles yu! Kaa da noh no hyooman been mek yoo noa dat, bot da mai Faada eena hevn. ");
INSERT INTO bzj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Soh Ah wahn kaal yu ‘Peeta,’ weh meen ‘wahn stoan,’ ahn da pahn dis rak Ah wahn bil mi cherch, ahn aala di powa weh deh eena hel noh wahn ku stan op gens it. ");
INSERT INTO bzj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ah wahn gi yu di kee dehn fi di kingdom a hevn, ahn eniting weh yoo alow pahn ert, Gaad wahn alow op da hevn, ahn eniting weh yoo noh alow pahn ert, Gaad noh wahn alow op da hevn needa.” ");
INSERT INTO bzj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Den Jeezas waan ih disaipl dehn noh fi tel nobadi dat hihn da di Krais. ");
INSERT INTO bzj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Fahn da taim goh bak, Jeezas staat tu shoa ih disaipl dehn dat ih mi hafu goh da Jeroosalem ahn sofa lata ting fahn di Jooish leeda dehn, ahn di cheef prees dehn, ahn dehn wan weh teech di Laa. Den dehn mi wahn kil ahn, bot chree dayz layta ih mi wahn rayz op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Den Peeta jraa Jeezas wan said ahn tel ahn shaap-wan fi stap taak laik dat. Ih tel ahn seh, “Gaad wahn neva mek dat hapm tu yu.” ");
INSERT INTO bzj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Bot Jeezas ton tu Peeta ahn seh, “Get fahn fronta mi, Saytan! Yoo di luk pahn aala dis di way peepl see't, noh laik how Gaad see't.” ");
INSERT INTO bzj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Den Jeezas tel ih disaipl dehn seh, “If eni a unu waahn fala mi, unu mos stap goh afta weh unu waahn fi fi unu oanself. Pik op yu kraas ahn fala mee. ");
INSERT INTO bzj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Enibadi weh chrai fi heng aan tu dehn oan laif wahn en op di laas it. Bot if dehn giv op dehn laif fi sayka mee, dehn wahn fain reel laif. ");
INSERT INTO bzj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Weh gud ih wahn du yu if yu oan di hoal werl ahn en op di laas yu soal? Er, da weh yu wahn chaynji yu laif fa? ");
INSERT INTO bzj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Den di Son a Man wahn kom eena di gloari weh ih Faada gi ahn, ahn ih wahn kohn lang wid ih aynjel dehn, ahn ih wahn pay bak evribadi fi weh dehn mi du. ");
INSERT INTO bzj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ah di tel unu di chroot, som a unu weh di stan op rait ya soh, noh wahn ded bifoa unu si di Son a Man kohn fi rool ih kingdom.” ");
INSERT INTO bzj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Siks dayz afta dat, Jeezas kehr Peeta ahn Jaymz ahn fi hihn breda weh nayhn Jan op pahn wahn hai mongtin; oanli dehn wan mi deh op deh. ");
INSERT INTO bzj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ahn wen dehn luk, di hoal a Jeezas chaynj soh dat ih mi luk difrent difrent tu dehn. Ih fays staat tu shain brait brait-wan laik di son, ahn ih kloaz geh wait wait wait, til ih hat dehn aiy anaal. ");
INSERT INTO bzj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sodn-wan Moaziz ahn Ilaija apyaa fronta dehn ahn dehn mi-di taak tu Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Den Peeta seh tu Jeezas, “Laad, ih gud dat wee deh ya. If yu waahn, Ah ku put op chree boot ya, wan fi yoo, wan fi Moaziz, ahn wan fi Ilaija.” ");
INSERT INTO bzj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wail Peeta stil mi-di taak, wahn brait klowd kohn dong oava dehn, ahn dehn yehr wahn vais fahn owta di klowd weh seh, “Dis da mai Son weh Ah oanli lov, an Ah oanli pleez wid ahn. Lisn tu ahn.” ");
INSERT INTO bzj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wen di disaipl dehn yehr dat, dehn mi fraitn no miks, ahn dehn jrap da grong. ");
INSERT INTO bzj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Bot Jeezas kohn ahn toch dehn ahn seh, “Unu get op. Noh frayd.” ");
INSERT INTO bzj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ahn wen dehn luk op, oanli Jeezas wan dehn si. ");
INSERT INTO bzj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Az dehn mi-di kohn bak dong di mongtin, Jeezas aada ih disaipl dehn seh, “Unu noh tel nobadi weh unu si til wen di Son a Man don rayz op bak fahn di ded.” ");
INSERT INTO bzj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Den di disaipl dehn aks ahn seh, “Da wai di teecha dehn a di Laa seh dat Ilaija hafu kohn fos bifoa eniting els wahn hapm?” ");
INSERT INTO bzj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jeezas ansa dehn seh, “Yes, Ilaija hafu kohn fos fi chroo, ahn put evriting eena aada. ");
INSERT INTO bzj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bot Ah di tel unu, Ilaija don kohn aredi, bot di peepl dehn neva rekonaiz ahn, ahn dehn mi don du hihn aal weh dehn mi waahn. Da rait soh dehn wahn du di Son a Man.” ");
INSERT INTO bzj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Da den di disaipl dehn riyalaiz dat Jeezas mi-di taak bowt Jan di Baptis. ");
INSERT INTO bzj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wen dehn gaahn bak tu di krowd, wahn man kohn tu Jeezas ahn neel dong fronta ahn. ");
INSERT INTO bzj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ih seh, “Sa, pleez ga mersi pahn mi son noh! Ih chravl wid fits, ahn ih oanli ponish wid it kaa ih aalwayz di faal dong eena faiya ahn di jrap eena waata. ");
INSERT INTO bzj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ah bring ahn tu yu disaipl dehn bot dehn kudn heel ahn.” ");
INSERT INTO bzj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Den Jeezas seh, “Unu stobant peepl, unu noh ga no fayt. How lang Ai fi deh ya wid unu, di put op wid unu? Bring di bwai ya tu mi.” ");
INSERT INTO bzj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ahn den Jeezas taak shaap-wan tu di deeman, ahn ih kom owta di bwai, ahn di bwai geh heel sayhn taim. ");
INSERT INTO bzj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Den di disaipl dehn kohn tu Jeezas eena praivit ahn seh, “Da wai wee kudn jraiv owt di eevl spirit?” ");
INSERT INTO bzj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jeezas tel dehn seh, “Kaa unu fayt tu leel. Ah di tel unu di chroot, if unu ga fayt di saiz a wahn lee chinchi mostad seed, unu wahn ku tel dis mongtin, ‘Moov fahn ya tu oava deh,’ ahn di mongtin wahn du it; ahn notn wahn impasabl fi unu. ");
INSERT INTO bzj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Di oanli way dehnya kaina spirit wahn kom owt da if unu pray ahn faas.” ");
INSERT INTO bzj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wahn day wen Jeezas ahn ih disaipl dehn mi deh tugeda da Gyalilee, Jeezas tel dehn seh, “Dehn wahn sel owt di Son a Man, ahn han ahn oava tu sohn peepl ");
INSERT INTO bzj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","weh wahn kil ahn. Bot den chree dayz aftawodz ih wahn rayz op bak fahn di ded.” Den di disaipl dehn haat geh hevi hevi. ");
INSERT INTO bzj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wen Jeezas ahn ih disaipl dehn reech Kapernyam, dehn wan weh kalek taks fi di templ kohn kohn aks Peeta seh, “Fi unu teecha noh pay templ taks, noh?” ");
INSERT INTO bzj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peeta ansa seh, “Yes, hihn pay templ taks.” Wen Peeta gaan eensaida di hows, Jeezas da-mi di fos wan fi bring op di ting bowt di taks. Ih aks Peeta seh, “Saiman, da weh yu tink? Di king dehn eena dis werl kalek taks fahn fi dehn oan peepl dehn er fahn farina?” ");
INSERT INTO bzj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peeta ansa seh, “Fahn di farina dehn.” Jeezas tel ahn seh, “Wel den, di king dehn oan peepl dehn noh hafu pay no taks, ");
INSERT INTO bzj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","bot jos soh wi noh ofen nobadi, goh da di lagoon ahn chroa owt yu huk lain; tek di fos fish weh kom op ahn oapm ih mowt, ahn yu wahn fain wahn silva moni een deh. Tek dat ahn pay di taks fi di too a wi.” ");
INSERT INTO bzj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Rong da taim deh, di disaipl dehn kohn tu Jeezas ahn aks ahn seh, “Da hoo da di moas impoatant eena di kingdom a hevn?” ");
INSERT INTO bzj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Jeezas kaal wahn lee pikni tu ahn, ahn put ahn midl a dehn, ahn ih seh, “Ah di tel unu di chroot, if unu noh chaynj ahn bee laik pikni, unu wahn neva bee paat a di kingdom a hevn. ");
INSERT INTO bzj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Enibadi weh hombl dehnself ahn stan laik dis lee pikni ya, da di moas impoatant wan eena di kingdom a hevn. ");
INSERT INTO bzj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ahn enibadi weh welkom eni wan a dehnya lee pikni ya sayka mee, welkom mee tu. ");
INSERT INTO bzj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Bot if enibadi du eniting fi mek eni a dehnya lee pikni ya weh bileev eena mi du eniting rang, den ih wuda beta fi dehn if dehn tai wahn big hevi rakstoan rong dehn nek ahn chroa dehn da batam a di see mek dehn jrongdid. ");
INSERT INTO bzj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Big chrobl wahn kohn pahn di peepl dehn a di werl sayka aala di ting dehn weh mek peepl sin. Dehn ting deh wahn hafu kohn, bot dehn wan weh mek dehn kohn wahn deh eena big chrobl. ");
INSERT INTO bzj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“If yu han er yu fut di mek yu sin, den chap it aaf ahn dash it weh. Ih beta fi kripl ahn liv fareva dan fi ga yu too han ahn yu too fut dehn ahn geh pich eena hel weh di faiya neva owt. ");
INSERT INTO bzj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ahn if wan a yu aiy di mek yu sin, den dig it owt ahn dash it weh; ih beta fi ga wan aiy ahn liv fareva dan fi ga yu too aiy dehn ahn geh pich eena faiya da hel. ");
INSERT INTO bzj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ahn si dat unu noh luk dong pahn non a dehnya lee wan ya, kaa fi dehn aynjel aalwayz deh op da hevn fronta mi Faada fays. ");
INSERT INTO bzj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yu si, di Son a Man kohn fi luk fi dehn wan weh laas soh dat ih ku sayv dehn. ");
INSERT INTO bzj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Now unu noh tink seh if wahn shepad ga wahn honjrid sheep, ahn wan a dehn laas, ih noh wahn lef di nainti-nain sheep pahn di hil ahn goh luk fi di wan weh laas? ");
INSERT INTO bzj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ah di tel unu di chroot, if ih fain ahn, ih wahn rijais oava da wan deh moa dan di nainti-nain weh neva laas. ");
INSERT INTO bzj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sayhn way unu Faada eena hevn noh waahn non a dehnya lee pikni ya geh laas. ");
INSERT INTO bzj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Now if wahn brada du yu eniting, tel ahn bowt it wen unu deh bai unuself. If ih lisn tu yu, den yu win yu brada bak. ");
INSERT INTO bzj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bot if ih noh waahn lisn, den kehr wan er too ada peepl lang wid yu soh dat ‘yu ku ga too er chree witnis tu evri werd weh unu seh.’ ");
INSERT INTO bzj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","If di brada stil noh lisn tu dehn, den yu tel di cherch; ahn if ih noh eevn waahn lisn tu di cherch, den chreet ahn laik sohnbadi weh noh bileev eena Gaad er laik wan a dehn teefin taks kalekta. ");
INSERT INTO bzj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ah di tel unu di chroot, eniting weh unu noh alow pahn ert noh wahn alow da hevn, ahn eniting weh unu alow pahn ert wahn alow da hevn. ");
INSERT INTO bzj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ah di tel unu dis tu, if eni too a unu agree dong ya pahn ert fi aks fi eniting, mai Faada op da hevn wahn du it. ");
INSERT INTO bzj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kaa eniway wichpaa too er chree a mi falowa dehn meet tugeda sayka mee, Ai deh rait deh monks dehn.” ");
INSERT INTO bzj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Den Peeta kohn ahn seh tu Jeezas, “Laad, if mi brada du mi eniting, da humoch taim Ah fi fagiv ahn? Hoal a sebm taim?” ");
INSERT INTO bzj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jeezas ansa ahn seh, “No, noh jos sebm taim, bot semti taimz sebm taim. ");
INSERT INTO bzj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Dis stoari bowt di kingdom a hevn shoa yu wai yu fi fagiv laik dat: “Wahn king mi waahn chek ih buk dehn fi si humoch ih servant dehn mi hoa ahn. ");
INSERT INTO bzj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wen ih staat tu figa weh dehn mi hoa ahn, dehn bring een wahn servant weh mi hoa milyanz a dalaz. ");
INSERT INTO bzj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hihn kudn pay, soh di king gi aadaz fi mek dehn sel hihn, ahn ih waif ahn ih pikni dehn, plos aal weh ih mi ga, soh dat dehn kuda mi ga nof moni fi mek ih pay aaf weh ih mi hoa. ");
INSERT INTO bzj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Soh di servant jrap dong pahn ih nee fronta di king ahn bayg ahn seh, ‘Pleez sa, bayr payshens wid mi noh? Ah wahn pay yu bak evriting.’ ");
INSERT INTO bzj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wel, di king mi feel sari far ahn, soh ih paadn ahn di hoal a di moni weh ih mi hoa ahn let ahn goh. ");
INSERT INTO bzj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Bot wen da sayhn servant lef fahn deh, ih meet wahn nada servant weh mi hoa hihn lee bit a moni. Wel, ih staat tu choak di man ahn tel ahn seh, ‘Pay mee mai moni now!’ ");
INSERT INTO bzj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Den da servant weh mi hoa hihn jrap dong pahn fi hihn nee ahn bayg ahn seh, ‘Pleez bayr payshens wid mi noh? Ah wahn pay yu bak.’ ");
INSERT INTO bzj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Bot di servant rifyooz fi du it, ahn ih pich di wan weh mi hoa ahn di moni eena jayl til ih pay evri sent. ");
INSERT INTO bzj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wen di res a di king servant dehn si weh hapm, dehn neva laik it ataal, soh dehn gaahn tel di king aal weh mi hapm. ");
INSERT INTO bzj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Den di king samanz di man tu ahn, ahn tel ahn seh, ‘Yu wikid servant yu! Ai fagiv yoo fi aal weh yu mi hoa mi kaa yu bayg ahn pleed wid mi. ");
INSERT INTO bzj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yoo noh tink seh yoo shuda mi ga mersi pahn yu felo servant laik how Ai mi ga mersi pahn yoo?’ ");
INSERT INTO bzj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Di king mi soh beks dat ih han ahn oava tu di waadn dehn da jayl mek dehn taacha ahn til ih pay bak evri sent weh ih mi hoa. ");
INSERT INTO bzj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Dat da di sayhn ting weh mai Faada op da hevn wahn du tu evri wan a unu weh noh fagiv yu brada er sista fahn yu haat.” ");
INSERT INTO bzj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Wen Jeezas don seh aala dehn ting, ih lef fahn Gyalilee ahn gaahn da di paat a Judeeya weh mi deh kraas di neks said a Jaadn Riva. ");
INSERT INTO bzj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wahn hoal big krowd a peepl fala ahn, ahn ih heel dehn rait deh. ");
INSERT INTO bzj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Sohn Farisee kohn jos fi tes owt Jeezas. Dehn aks ahn seh, “Ih gens di Laa fi wahn man divoas ih waif fi eni lee ting?” ");
INSERT INTO bzj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jeezas ansa dehn seh, “Ah shoar unu reed eena di Skripcha how ‘Gaad mi mek man ahn uman’ fahn di biginin wen ih mi mek di werl, ");
INSERT INTO bzj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ahn ih mi seh, ‘Dat da wai wahn man fi lef ih ma ahn ih pa ahn jain op wid ih waif, ahn di too a dehn wahn bee laik wan persn.’ ");
INSERT INTO bzj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Soh dehn noh wahn bee too nohmoh, bot wan. Soh noh mek nobadi separayt weh Gaad don jain tugeda.” ");
INSERT INTO bzj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Di Farisee dehn aks Jeezas seh, “Wel den, da wai Moaziz mi tel wi seh dat wahn man ku gi ih waif wahn divoas paypa ahn den put ahn owt?” ");
INSERT INTO bzj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jeezas tel dehn seh, “Da sayka weh unu haat soh haad mek Moaziz mi alow unu fi divoas unu waif. Bot fos dat da neva how ih mi stan. ");
INSERT INTO bzj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ah di tel unu, yu ku oanli divoas yu waif ahn marid tu sohnbadi els if yu waif di cheet pahn yu, ahn noh fi no ada els reezn; adawaiz yu di liv eena sin.” ");
INSERT INTO bzj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Di disaipl dehn seh tu Jeezas, “Wel, if da soh ih stan bitween wahn man ahn ih waif, den beta yu noh marid non ataal.” ");
INSERT INTO bzj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jeezas ansa dehn seh, “Da noh evribadi ku tek weh Ah di seh, oanli dehn wan weh Gaad help. ");
INSERT INTO bzj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yu si, dehn ga sohn man weh ku neva geh wahn laydi pregnant kaa dehn baan soh. Den dehn ga sohn neks wan weh stan soh sayka weh ada peepl du tu dehn. Ahn stil sohn ada wan disaid noh fi marid sayka di kingdom a hevn. Enibadi weh ku aksep dis teechin bowt marij, mek dehn aksep it.” ");
INSERT INTO bzj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Now sohn peepl bring dehn lee pikni tu Jeezas fi mek ih ku put ih han pahn dehn ahn pray fi dehn. Bot di disaipl dehn taak tu dehn shaap-wan ahn tel dehn noh fi bada ahn. ");
INSERT INTO bzj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bot Jeezas seh, “Mek di lee pikni dehn kohn tu mi. Noh stap dehn, kaa peepl weh waahn bee paat a di kingdom a hevn wahn hafu stan jos laik lee pikni.” ");
INSERT INTO bzj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Soh Jeezas put ih han pahn dehn ahn bles dehn, den ih gaan. ");
INSERT INTO bzj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Den sohnbadi kohn tu ahn, ahn seh, “Teecha, da weh kaina gud tingz Ah ku du fi geh fi liv wid Gaad fareva?” ");
INSERT INTO bzj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jeezas aks ahn seh, “Da wai yu di aks mi bowt weh gud? Oanli wan persn deh weh gud. If yu waahn liv fareva, den du weh Gaad komanment dehn seh fi du.” ");
INSERT INTO bzj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Di yong man aks Jeezas seh, “Wich wan a dehn?” Jeezas seh, “Wel, ‘yu noh fi komit merda, yu noh fi cheet pahn yu hozban er yu waif, yu noh fi teef, yu noh fi tel lai pahn nobadi. ");
INSERT INTO bzj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Yu mos aana yu ma ahn yu pa,’ ahn ‘lov yu nayba sayhn laik how yu lov yuself.’” ");
INSERT INTO bzj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Di yong man seh, “Ai di du aala dehn ting deh. Soh wat els Ah hafu du?” ");
INSERT INTO bzj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jeezas tel ahn seh, “If yu waahn bee gud eena Gaad sait, den goh goh sel weh yu ga ahn gi di poa di moni, den yu wahn ga chreja eena hevn. Wen yu don du dat, den yu kohn ahn fala mi.” ");
INSERT INTO bzj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wen di yong man yehr dat, ih gaahn fahn deh sad-wan kaa hihn mi doti rich. ");
INSERT INTO bzj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Den Jeezas tel ih disaipl dehn seh, “Ah di tel unu di chroot, ih haad fi sohnbadi weh rich get eena di kingdom a hevn. ");
INSERT INTO bzj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ah di seh it agen, ih eeziya fi wahn kyamil paas chroo di aiy a wahn needl dan fi wahn rich man get eena Gaad kingdom.” ");
INSERT INTO bzj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wen di disaipl dehn yehr dis, dehn mi oanli shak ahn dehn seh, “Wel, da hoo ku geh sayv den?” ");
INSERT INTO bzj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jeezas luk pahn dehn ahn seh, “Wid man, ih impasabl. Bot wid Gaad, evriting pasabl.” ");
INSERT INTO bzj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Den Peeta ansa ahn seh, “Si, wee lef evriting fi fala yoo. Soh da weh wee wahn get?” ");
INSERT INTO bzj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jeezas tel dehn seh, “Ah di tel unu di chroot, wen Gaad don mek evriting nyoo, di Son a Man wahn sidong pahn fi hihn chroan eena aala ih gloari. Den unu weh mi fala mi wahn sidong pahn chroan, di joj di twelv chraib a Izrel. ");
INSERT INTO bzj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ahn evribadi weh lef hows, er breda, er sista, er pa, er ma, er pikni, er dehn lan sayka fala mee, wahn geh wahn honjrid taim moa, ahn pahn tap a dat, dehn wahn liv wid Gaad fareva. ");
INSERT INTO bzj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bot eena di werl weh di kohn, lata peepl weh da fos now wahn bee laas, ahn dehn wan weh da laas wahn bee fos.” ");
INSERT INTO bzj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jeezas seh, “Now di kingdom a hevn da laik wahn man weh mi gaan owt soon wahn maanin gaahn haiya sohn man fi werk eena ih feel. ");
INSERT INTO bzj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wel, ih agree fi pay di man dehn di yoozhwal pay weh dehn doz geh fi wahn day, ahn ih sen dehn gaahn werk eena ih feel weh mi plaant owt wid grayp. ");
INSERT INTO bzj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Bowt rong nain aklak, di man gaan owt ahn ih si sohn moa man di heng rong di maakit skwyaa jos dehdeh di aidl op dehnself. ");
INSERT INTO bzj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Di oana a di lan tel dehn seh, ‘Unu goh goh werk eena mi feel an Ah wahn gi unu wahn fyaa pay.’ ");
INSERT INTO bzj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Soh dehn gaan. “Di man gaan owt bak rong twelv aklak, ahn ih gaan owt chree aklak agen ahn ih du di sayhn ting. ");
INSERT INTO bzj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Bowt faiv aklak ih fain sohn moa man di stan op rong. Ih aks dehn seh, ‘Da wai unu jos di stan op ya di aidl hoal day?’ ");
INSERT INTO bzj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Dehn tel ahn seh, ‘Kaa nobadi noh haiya wi.’ “Di oana a di lan seh, ‘Unu goh eena mi grayp feel goh werk tu.’ ");
INSERT INTO bzj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Wen eevnin kohn, di oana a di lan tel di man in chaaj a di werkman dehn seh, ‘Kaal aala di werka dehn ahn pay dehn. Pay dehn wan weh staat tu werk laas fos. Den yu goh rait dong til evribadi geh pay.’ ");
INSERT INTO bzj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Wen dehn wan weh dehn haiya faiv aklak kohn, dehn geh pay di yoozhwal pay weh yu geh fi wahn day. ");
INSERT INTO bzj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Now wen dehn wan weh di man mi haiya fos kohn, dehn mi tink seh dehn mi wahn geh moa dan di neks man dehn, bot dehn geh di sayhn pay laik dehn neks wan. ");
INSERT INTO bzj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dehn staat tu grombl tu di oana a di lan. ");
INSERT INTO bzj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Dehn seh, ‘Yoo pay dehn wan weh staat tu werk laas sayhn ting laik weh yu pay wee, ahn wee da di wan dehn weh werk hoal day eena brailin son-hat.’ ");
INSERT INTO bzj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Di oana a di lan seh tu wan a dehn, ‘Mi fren, Ai neva teef yu. Yoo neva agree fi werk fi di yoozhwal pay fi wahn day? ");
INSERT INTO bzj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Soh tek weh da fi yoo ahn goh; da mee mi waahn gi dehn wan weh Ah haiya laas di sayhn ting laik yoo. ");
INSERT INTO bzj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Weh hapm? Ai kyaahn du weh Ai waahn wid mai oan moni? Er da kaa yu jelos kaa Ah soh kain?’ ");
INSERT INTO bzj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Soh yu si, eena di werl weh di kohn, dehn wan weh da laas now wahn bee fos, ahn dehn wan weh da fos wahn bee laas.” ");
INSERT INTO bzj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Now wail Jeezas ahn ih disaipl dehn mi deh pahn dehn way op tu Jeroosalem, ih kehr di twelv a dehn wan said ahn tel dehn seh, ");
INSERT INTO bzj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Luk, wi gwehn op da Jeroosalem weh dehn wahn sel owt di Son a Man tu di cheef prees dehn ahn dehn wan weh teech di Laa. Dehn wahn sentens ahn tu det. ");
INSERT INTO bzj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Den dehn wahn han ahn oava tu peepl weh da noh Joo mek dehn tek ahn mek papishoh, ahn flag ahn, ahn nayl ahn pahn wahn kraas. Bot chree dayz layta ih wahn rayz op bak fahn di ded.” ");
INSERT INTO bzj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Den Zebidee waif kohn tu Jeezas wid ih too son dehn, Jaymz ahn Jan, ahn ih neel dong fronta ahn, ahn aks ahn fi du ahn wahn fayva. ");
INSERT INTO bzj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ahn Jeezas aks ahn seh, “Da weh yu mi waahn?” Di laydi tel ahn seh, “Ai waahn yoo pramis mi fi mek wan a mi son sidong pahn yu rait han said ahn wan pahn yu lef wen yu ton king.” ");
INSERT INTO bzj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jeezas ansa ahn seh, “Unu noh noa weh unu di aks fa. Unu ku jrink di sayhn kop a sofarin weh Ai fi jrink?” Dehn ansa seh, “Yes, wee ku jrink it.” ");
INSERT INTO bzj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jeezas tel dehn seh, “Unu wahn jrink owta di sayhn kop laik mee fi chroo, bot da noh mai plays fi seh hoo wahn sidong pahn mai rait han said ahn lef han said. Mai pa don ga dehndeh plays redi fi dehn wan weh hihn pik fi sidong deh.” ");
INSERT INTO bzj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wen di ada ten disaipl dehn yehr bowt dis, dehn mi wel beks wid di too breda dehn. ");
INSERT INTO bzj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Soh Jeezas kaal aala dehn tugeda ahn tel dehn seh, “Unu noa how dehn king weh da noh Joo laik rool oava fi dehn peepl stif-wan, ahn fi dehn big taim ofishal dehn baas dehn op wid wahn hevi han. ");
INSERT INTO bzj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wel, dat da noh how ih stan wid unu. If eni a unu waahn bee impoatant, unu hafu bee di neks wan dehn servant. ");
INSERT INTO bzj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","28","Ahn if enibadi waahn bee di moas impoatant wan, den dehn wahn hafu bee di neks wan dehn slayv, sayhn laik how di Son a Man mi du. Hihn neva kohn fi mek nobadi serv hihn, bot hihn kohn fi serv ada peepl ahn fi giv op fi hihn laif soh dat lat moa peepl ku geh free fahn dehn sin dehn.” ");
INSERT INTO bzj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Az Jeezas ahn ih disaipl dehn mi-di lef Jeriko, wahn big krowd mi-di fala ahn. ");
INSERT INTO bzj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Too blain man mi-di sidong bai di roadsaid, ahn wen dehn yehr seh Jeezas mi wahn paas, dehn hala, “Dayvid Son, ga piti pahn wi, noh Sa!” ");
INSERT INTO bzj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Di krowd tel dehn fi shet op dehn mowt, bot dehn hala haada, “Dayvid Son, ga piti pahn wi noh!” ");
INSERT INTO bzj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jeezas stap ahn kaal di blain man dehn ahn aks dehn seh, “Da weh Ah ku du fi unu?” ");
INSERT INTO bzj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dehn ansa seh, “Sa, wi waahn si.” ");
INSERT INTO bzj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jeezas haat gaan owt tu dehn, soh ih toch dehn aiy, ahn sayhn taim dehn geh bak dehn sait ahn staat tu fala ahn. ");
INSERT INTO bzj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jeezas ahn ih disaipl dehn mi nayli reech Jeroosalem, ahn dehn mi deh rait da Betfayj, bai di hil weh nayhn di Mongt a Alivz. Jeezas sen too a ih disaipl dehn hed, ");
INSERT INTO bzj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ahn ih tel dehn seh, “Unu goh da di vilij weh deh lee wayz hed, ahn az soon az unu reech, unu wahn fain wahn dongki tai op wid ih yong wan; loos dehn, ahn bring dehn fi mi. ");
INSERT INTO bzj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","If enibadi tel unu eniting, jos tel dehn seh, ‘Di Laad need dehn.’ Den dehn wahn mek unu bring dehn rait away.” ");
INSERT INTO bzj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dis hapm soh dat weh di prafit mi seh mi kohn chroo. Ih mi seh, ");
INSERT INTO bzj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tel di peepl a Jeroosalem: ‘Luk deh! Unu king di kohn tu unu. Luk how ih soh hombl, di raid pahn wahn dongki, wahn lee yong dongki.’” ");
INSERT INTO bzj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Di disaipl dehn gaahn du weh Jeezas mi tel dehn fi du. ");
INSERT INTO bzj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dehn bring di dongki lang wid ih lee yong wan ahn spred dehn jakit ahn ting pahn dehn bak. Den Jeezas get aan. ");
INSERT INTO bzj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lata peepl chroa dong dehn jakit ahn ting pahn di road, ahn sohn ada wan dehn kot sohn branch aafa chree ahn spred dehn pahn di road tu. ");
INSERT INTO bzj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Di krowd weh mi-di goh lang heda Jeezas ahn dehn wan weh mi-di fala baka ahn mi-di hala, “Hozaana tu Dayvid Son! Gaad bles di Wan weh kom eena di naym a di Laad! Prayz tu Gaad eena hevn!” ");
INSERT INTO bzj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wen Jeezas gaahn da Jeroosalem, big rokshan mi dehdeh ahn peepl mi-di aks, “Da hoo dat?” ");
INSERT INTO bzj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Di krowd weh mi-di fala Jeezas ansa seh, “Da da prafit weh nayhn Jeezas weh kohn fahn Nazaret Tong eena Gyalilee.” ");
INSERT INTO bzj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Den Jeezas gaahn da di templ yaad ahn wail owt aala dehn wan weh mi-di bai ahn sel eena di yaad. Ih ton oava di moni chaynja dehn taybl ahn di bench dehn weh dehn wan weh mi-di sel pijin mi-di sidong pan. ");
INSERT INTO bzj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ih tel dehn seh, “Di Skripcha seh, ‘Mai hows sopoas tu bee wahn plays fi pray,’ bot unu ton ahn intu ‘wahn hengowt fi teef.’” ");
INSERT INTO bzj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Peepl weh mi blain ahn weh mi kripl kohn tu Jeezas wen ih mi deh eena di templ yaad, ahn ih heel dehn. ");
INSERT INTO bzj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bot di cheef prees dehn ahn dehn wan weh teech di Jooish Laa mi oanli beks wen dehn si di mirakl dehn weh Jeezas du, ahn wen dehn yehr di pikni dehn di hala, “Hozaana tu King Dayvid Son.” ");
INSERT INTO bzj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Soh dehn seh tu Jeezas, “Yoo yehr weh dehnya pikni di seh?” Ih ansa dehn seh, “Yes, ahn unu neva reed wehpaa di Skripcha seh, ‘Gaad chrayn pikni ahn eevn lee yong baybi fi prayz ahn?’” ");
INSERT INTO bzj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Den Jeezas lef dehn ahn gaan owta di siti ahn gaahn da Betani, ahn ih spen di nait deh. ");
INSERT INTO bzj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Soon di neks maanin wen Jeezas mi-di goh bak da Jeroosalem, ih mi hongri. ");
INSERT INTO bzj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ih si wahn fig chree bai di roadsaid ahn gaan op tu it bot ih neva fain no fig pan it, oanli soasoh leef. Den ih seh tu di fig chree, “Yu wahn neva bayr nohmoh froot eva agen!” Ahn sayhn taim di fig chree jrai op. ");
INSERT INTO bzj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Di disaipl dehn kudn bileev dehn aiy wen dehn si dat hapm, ahn dehn seh, “Da how di fig chree jrai op soh kwik?” ");
INSERT INTO bzj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jeezas ansa dehn seh, “Ah di tel unu di chroot, if unu ga fayt ahn noh dowt, den unu wahn ku du weh unu si Ai du tu di fig chree. Ahn pahn tap a dat, unu wahn ku tel dis mongtin, ‘Hais yuself op ahn hib yuself eena di see,’ ahn ih wahn hapm. ");
INSERT INTO bzj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","If yu ga fayt, yu wahn geh eniting weh yu aks fa wen yu pray.” ");
INSERT INTO bzj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Wen Jeezas gaan eena di templ yaad, di cheef prees dehn ahn di Jooish leeda dehn kohn tu ahn wail ih mi-di preech ahn dehn aks ahn seh, “Da weh atariti yoo ga fi du dehnya ting ya? Da hoo gi yoo dis atariti?” ");
INSERT INTO bzj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jeezas tel dehn seh, “Mek Ai aks unu wahn kweschan tu. If unu ku ansa it, den Ah wahn tel unu weh Ai geh di atariti fi du dehnya ting. ");
INSERT INTO bzj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tel mi, da weh Jan di Baptis geh di atariti fi baptaiz peepl—fahn Gaad er fahn man?” Dehn taak it oava monks dehnself ahn seh, “If wi seh da fahn Gaad, den ih wahn aks wi, ‘Den wai unu neva bileev ahn?’ ");
INSERT INTO bzj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Bot if wi seh da fahn man, wi frayd fi weh di krowd mait du wi.” Di Jooish leeda dehn seh dat kaa evribadi mi bileev seh dat Jan da-mi wahn prafit. ");
INSERT INTO bzj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Soh dehn ansa Jeezas seh, “Wee noh noa.” Soh Jeezas tel dehn seh, “Wel, Ai noh wahn tel unu da hoo gi mee di atariti fi du dehnya ting needa.” ");
INSERT INTO bzj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Den Jeezas aks di cheef prees ahn di Jooish leeda dehn seh, “Weh unu tink bowt dis? Wahn man mi ga too son. Ih gaahn tu di fos wan ahn tel ahn seh, ‘Son, goh goh werk eena mi plantayshan tudeh.’ ");
INSERT INTO bzj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Di son tel ahn seh, ‘No, Ah noh gwehn.’ Bot ih chaynj ih main ahn ih gaan enihow. ");
INSERT INTO bzj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Den di pa gaahn tu di neks son ahn tel ahn di sayhn ting, ahn da son seh, ‘Ah gwehn,’ bot hihn neva gaan ataal. ");
INSERT INTO bzj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Soh da wich wan a dehn son du weh ih pa mi waahn?” Dehn seh, “Di fos wan.” Jeezas tel dehn seh, “Ah di tel unu di chroot, di taks kalekta dehn ahn di prastichoot dehn wahn get eena Gaad kingdom heda unu! ");
INSERT INTO bzj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kaa Jan kohn fi shoa unu how fi get rait wid Gaad ahn unu neva bileev ahn. Bot di taks kalekta dehn ahn di prastichoot dehn mi bileev ahn, ahn eevn afta unu si dat, unu neva chaynj fi unu main ahn bileev Jan tu.” ");
INSERT INTO bzj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Den Jeezas seh, “Now unu yehr dis neks lee stoari: Wahn taim wahn man plaant owt wahn pees a lan wid grayp. Ih fens it op ahn ih dig owt wahn hoal eena wahn big rak wehpaa dehn skweez owt di joos owta di grayp dehn. Afta dat ih bil wahn lukowt towa ahn den ih rent di lan owt tu sohn faama. Den hihn gaahn weh da wahn neks konchri. ");
INSERT INTO bzj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wen di taim kohn fi pik di grayp dehn, di oana a di lan sen ih servant dehn fi kalek fi hihn shayr a di krap fahn di faama dehn. ");
INSERT INTO bzj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Bot di faama dehn grab di servant dehn. Dehn beet op wan a dehn, dehn kil wan, ahn stoan di neks wan. ");
INSERT INTO bzj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Den di oana sen moa servant dan weh ih mi sen fos, ahn di faama dehn chreet dehndeh wan deh sayhn laik how dehn mi chreet di fos wan dehn. ");
INSERT INTO bzj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pahn di laas ih sen ih son tu dehn. Ih seh tu ihself, ‘Dehn mos wahn rispek mi son.’ ");
INSERT INTO bzj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Bot cho! Wen di faama dehn si di oana son di kohn, dehn seh monks dehnself, ‘Dis da di wan weh wahn inherit evriting. Mek wi kil hihn, den evriting wahn bee fi wee.’ ");
INSERT INTO bzj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Soh dehn grab di oana son ahn pich ahn aafa di lan ahn kil ahn. ");
INSERT INTO bzj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Now wen di oana a di lan kohn, da weh ih wahn du tu dehn faama deh?” ");
INSERT INTO bzj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dehn ansa Jeezas seh, “Ih wahn kil dehn wikid man eena di wos kaina way ahn den ih wahn rent owt di lan tu sohn ada faama weh wahn gi ahn fi hihn shayr a di krap wen di taim kohn fi dehn reep it.” ");
INSERT INTO bzj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jeezas aks dehn seh, “Unu neva reed weh di Skripcha seh? Ih seh, ‘Di stoan weh di bilda dehn neva tink mi wot notn ton owt fi bee di kaanastoan, weh da di moas impoatant wan owta aala dehn. Dis da weh di Laad du. Da wahn wandaful ting fi si, noh chroo’? ");
INSERT INTO bzj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Soh Ah di tel unu, Gaad wahn tek weh di rait fi bee paat a ih kingdom fahn unu, ahn ih wahn giv da rait tu dehn peepl weh du weh hihn seh. ");
INSERT INTO bzj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yu si, enibadi weh bok dehn fut pahn datdeh stoan wahn geh brok op eena peesiz; ahn enibadi weh da stoan jrap pan wahn geh mash op fain laik powda.” ");
INSERT INTO bzj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wen di cheef prees dehn ahn di Farisee dehn yehr di lee stoari dehn weh Jeezas mi-di tel, dehn riyalaiz dat da dehn ih mi-di taak bowt. ");
INSERT INTO bzj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dehn mi-di chrai fain wahn way fi ares Jeezas, bot dehn mi frayd fi di krowd kaa di peepl dehn mi luk pahn Jeezas az wahn prafit. ");
INSERT INTO bzj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jeezas mi yooz sohn lee stoari fi teech di peepl dehn agen. Ih seh, ");
INSERT INTO bzj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Di kingdom a hevn da laik wen wahn king mi ga wahn bankwit fi ih son wedn. ");
INSERT INTO bzj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ih sen ih servant dehn fi tel dehn wan weh mi invaitid da di bankwit dat da mi taim fi dehn kohn, bot dehn neva waahn kohn ataal. ");
INSERT INTO bzj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Di king sen sohn neks wan a ih servant dehn tu dehn wan weh mi invaitid fi tel dehn seh, ‘Luk ya, di dina don redi. Mi kow dehn ahn mi kyaaf dehn weh mi-di fatn op don kil aredi ahn evriting don redi; unu mos kohn da di bankwit.’ ");
INSERT INTO bzj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","“Bot di peepl dehn neva pay dehn no main; dehn jos gaahn gaahn du dehn oan ting. Wan gaahn da ih faam, wan gaahn luk afta ih bizniz, ahn di res a dehn grab di servant dehn ahn manhandl dehn ahn kil dehn. ");
INSERT INTO bzj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Wel, di king mi beks no miks! Ih sen ih soalja dehn fi kil aaf dehn merdaraz, ahn bon dong dehn siti. ");
INSERT INTO bzj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Den di king tel ih servant dehn seh, ‘Di dina don redi, bot dehn wan weh mi invaitid neva dizerv fi kohn. ");
INSERT INTO bzj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Soh unu goh owt da aala di schreet kaana dehn ahn invait evribadi weh unu ku fain da di bankwit.’ ");
INSERT INTO bzj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Di servant dehn gaan owt da di schreet dehn ahn haal een aal hoo dehn kuda mi fain, gud ahn bad; soh di wedn haal mi ful op wid ges. ");
INSERT INTO bzj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Bot wen di king kohn kohn meet di ges dehn, ih noatis seh dat wahn man mi dehdeh weh neva mi gat aan di prapa kaina kloaz weh yu fi wayr da wedn. ");
INSERT INTO bzj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Soh ih seh tu di man, ‘Mi breda, da how yoo get een ya widowt di prapa kaina kloaz?’ Di man neva noa weh fi seh. ");
INSERT INTO bzj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Den di king seh tu ih servant dehn, ‘Tai op fi hihn han ahn ih fut dehn ahn pich ahn owt eena daak, weh peepl wahn di baal ahn grain op dehn teet eena payn.’ ");
INSERT INTO bzj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Yu si, lat geh invaitid bot oanli lee bit a peepl geh pik.” ");
INSERT INTO bzj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Den di Farisee dehn gaahn gaahn plan op how fi chrik Jeezas mek ih seh sohnting weh ih noh fi seh. ");
INSERT INTO bzj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Soh dehn sen fi dehn disaipl dehn lang wid sohn peepl weh fala Herod fi aks ahn seh, “Now Teecha, wee noa seh dat yoo da wahn aanis ahn rispektabl man, ahn yoo teech di chroot bowt how Gaad waahn peepl fi liv. Yu chreet evribadi sayhn way noh kay da hoo dehn. ");
INSERT INTO bzj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Soh tel wi weh yoo tink. Ih rait fi pay taks tu Seeza er nat?” ");
INSERT INTO bzj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Bot Jeezas mi noa seh dat dehn mi-di haaba loan wikidnis eena dehn haat, soh ih tel dehn seh, “Unu hipokrit unu! Da wai unu di chrai chrik mi? ");
INSERT INTO bzj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Shoa mi wahn moni weh unu yooz fi pay taks wid.” Dehn gi ahn wahn silva moni. ");
INSERT INTO bzj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Den Jeezas aks dehn seh, “Hoofa hed stamp pahn dis moni, ahn hoofa naym rait pan it?” ");
INSERT INTO bzj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Dehn ansa ahn seh, “Seeza.” Den Jeezas tel dehn seh, “Wel den, unu gi Seeza weh bilangz tu Seeza, ahn gi Gaad weh bilangz tu Gaad.” ");
INSERT INTO bzj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dehn mi shak wen dehn yehr dis, soh dehn lef ahn, ahn gaahn hoahn. ");
INSERT INTO bzj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Da sayhn day deh, sohn Sadyusee kohn tu Jeezas wid wahn kweschan. Dehn da wahn groop weh bileev seh peepl noh wahn rayz op bak fahn di ded. Dehn aks ahn seh, ");
INSERT INTO bzj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Teecha, Moaziz mi seh dat if wahn man ded ahn ih neva did ga no pikni wid ih waif, den ih breda fi marid tu di waif weh hihn ded lef, ahn ga pikni wid shee fi kehr aan di ded breda naym. ");
INSERT INTO bzj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wel, yu mi ga dehnya sebm breda weh wi mi noa bowt. Di fos wan marid ahn ded widowt ga no pikni, soh di sekant breda marid di waif weh hihn ded lef. ");
INSERT INTO bzj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Den da breda ded ahn hihn neva ga no pikni needa, ahn di waif marid tu di neks breda, ahn rait soh ih gaan aan til shee en op di marid tu aala di breda dehn. ");
INSERT INTO bzj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Wel, pahn di en di laydi shee ded tu. ");
INSERT INTO bzj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Soh, wen di day kohn fi ded peepl kohn bak tu laif, hoofa waif shee wahn bee, laik how di hoal sebm a dehn mi marid tu ahn?” ");
INSERT INTO bzj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jeezas ansa dehn seh, “Unu rang kaa unu noh noa di Skripcha ner how powaful Gaad powaful. ");
INSERT INTO bzj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yu si, wen peepl rayz op bak fahn di ded pahn rezorekshan day, nobadi wahn geh marid tu nobadi. Dehn wahn bee sayhn laik di aynjel dehn weh deh da hevn. ");
INSERT INTO bzj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Bot az tu weda peepl wahn rayz op bak fahn di ded, unu neva reed weh Gaad mi seh tu unu? ");
INSERT INTO bzj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ih seh, ‘Ai da di Gaad a Aybraham ahn Aizak ahn Jaykop.’ Hihn da noh di Gaad a ded peepl, bot ih da di Gaad a peepl weh livin.” ");
INSERT INTO bzj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wen di krowd dehn yehr weh Jeezas seh, dehn mi kwait sopraiz bowt weh ih mi-di teech. ");
INSERT INTO bzj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","35","Wen di Farisee dehn yehr seh dat Jeezas mi shet di Sadyusee dehn mowt, dehn gyada tugeda, ahn wan a dehn weh da-mi wahn teecha a di Jooish Laa aks ahn wahn kweschan fi tes ahn. ");
INSERT INTO bzj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ih seh, “Teecha, da wich wan a di komanment dehn eena Moaziz Laa da di moas impoatant wan?” ");
INSERT INTO bzj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jeezas tel ahn seh, “‘Yu fi lov di Laad yu Gaad wid aala yu haat, ahn wid aala yu soal, ahn wid aala yu main.’ ");
INSERT INTO bzj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dis da di fos komanment ahn da di moas impoatant wan. ");
INSERT INTO bzj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ahn di sekant wan impoatant tu. Ih seh, ‘Lov yu nayba sayhn laik how yu lov yuself.’ ");
INSERT INTO bzj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Soh di hoal a Moaziz Laa, ahn evriting weh di oal taim prafit dehn mi rait, kom op tu dehndeh too komanment.” ");
INSERT INTO bzj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Now laik how di Farisee dehn mi stil dehdeh tugeda, Jeezas aks dehn dis kweschan, ");
INSERT INTO bzj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Da weh unu tink bowt di Krais? Da hoofa famili lain hihn wahn kohn fram?” Dehn ansa ahn seh, “Fahn King Dayvid famili lain.” ");
INSERT INTO bzj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Den Jeezas aks dehn seh, “Soh da how kom di Hoali Spirit kaal di Krais ‘Laad’ wen ih mi-di taak chroo Dayvid bak den? Dis da weh Dayvid mi seh: ");
INSERT INTO bzj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Di Laad seh tu mai Laad, “Sidong rait ya pahn mi rait han said til Ah put yu enimi dehn anda yu fut.”’ ");
INSERT INTO bzj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Now if Dayvid mi kaal di Krais ‘Laad,’ den da how di Krais ku kohn dong chroo Dayvid famili lain?” ");
INSERT INTO bzj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Non a dehn kudn ansa ahn, ahn fahn deh goh bak nat anada soal mi dayr aks Jeezas wahn nada kweschan. ");
INSERT INTO bzj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Den Jeezas seh tu di krowd a peepl dehn ahn tu ih disaipl dehn, ");
INSERT INTO bzj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Di Farisee dehn ahn dehn wan weh teech di Jooish Laa ga di atariti fi tel unu weh Moaziz Laa meen. ");
INSERT INTO bzj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Soh unu mos du weh dehn tel unu fi du, bot noh du weh dehn du, kaa dehn dehnself noh du weh di Laa seh. ");
INSERT INTO bzj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dehn pak op peepl wid wahn hoal pail a schrik roolz weh da laik wahn big berdn pahn dehn bak, ahn dehn noh lif wan finga fi mek it eni eeziya fi dehn bayr. ");
INSERT INTO bzj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Dehn du evriting jos fi mek peepl noatis dehn. Dehn mek di lee kays dehn weh dehn kehr rong Skripcha vers eena ekschra big, ahn luk how lang di tasl dehn pahn dehn gong! ");
INSERT INTO bzj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wen dehn goh da bankwit er da di meetn plays dehn, dehn lov fi kak op rait da front seet. ");
INSERT INTO bzj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ahn dehn laik wen peepl hayl dehn op wen dehn waak owta tong, ahn dehn laik wen dehn kaal dehn ‘Teecha.’ ");
INSERT INTO bzj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Bot unu noh fi mek nobadi kaal unu ‘Teecha’ kaa unu oanli ga wan Teecha, ahn aala unu deh pahn di sayhn levl. ");
INSERT INTO bzj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ahn noh kaal nobadi dong ya pahn ert unu ‘Faada’ kaa unu oanli ga wan Faada ahn hihn deh op da hevn. ");
INSERT INTO bzj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Unu noh fi mek dehn kaal unu ‘Maasta’ needa, kaa unu oanli ga wan Maasta ahn hihn da di Krais. ");
INSERT INTO bzj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yu si, di moas impoatant persn monks unu fi bee fi unu servant. ");
INSERT INTO bzj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Gaad wahn hombl enibadi weh prayz op dehnself, ahn hihn wahn prayz op enibadi weh hombl dehnself. ");
INSERT INTO bzj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Bot unu teecha a di Laa ahn unu Farisee, unu een fi big chrobl. Unu hipokrit unu! Da unu kip bak peepl fahn get eena di kingdom a hevn. Unu unuself noh gwehn een, ahn unu noh waahn nobadi els goh een needa. ");
INSERT INTO bzj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Unu teecha a di Laa ahn unu Farisee, unu een fi big chrobl. Unu hipokrit unu! Unu swindl dehn poa lee wido owta dehn hows ahn lat, ahn den unu ton rong ahn seh sohn lang pryaaz jos fi shoa aaf. Sayka dat, unu wosa wahn geh ponish moa dahn enibadi els. ");
INSERT INTO bzj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Unu teecha a di Laa ahn unu Farisee, unu een fi big chrobl. Unu hipokrit unu! Unu chravl kraas lan ahn see jos fi get wan persn fi jain unu rilijan. Den sayka unu, da persn geh soh wikid dat ih dizerv fi goh da hel too taimz az moch az unu. ");
INSERT INTO bzj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Unu een fi big chrobl. Unu sopoas tu leed ada peepl bot unu unuself blain. Unu tel peepl dat if dehn sway ‘bai di templ,’ dehn noh hafu kip dehn oat; dehn oanli hafu kip it if dehn sway ‘bai di goal eena di templ.’ ");
INSERT INTO bzj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Unu blain fool unu! Wich wan grayta, di goal er di templ weh mek di goal hoali? ");
INSERT INTO bzj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ahn unu seh dat da noh notn fi brok wahn oat if unu mi sway ‘bai di alta,’ bot if unu mi sway ‘bai di gif pahn di alta,’ den unu hafu kip di oat. ");
INSERT INTO bzj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Unu blain, sa! Wich wan grayta, di gif er di alta weh mek di gif hoali? ");
INSERT INTO bzj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","21","Soh enibadi weh sway ‘bai di alta’ di sway bai evriting weh deh pan it; ahn enibadi weh sway ‘bai di templ’ di sway bai di templ ahn bai Gaad weh liv deh. ");
INSERT INTO bzj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ahn enibadi weh sway ‘bai hevn’ di sway bai Gaad chroan ahn bai Gaad weh di sidong pan it. ");
INSERT INTO bzj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Unu teecha a di Laa ahn unu Farisee, unu een fi big chrobl. Unu hipokrit unu! Unu gi ten persent a evriting tu Gaad rait dong tu unu seeznin dehn laik mint ahn dil ahn kyoomin. Notn noh rang wid dat kaa dat da weh di Laa seh fi du, bot unu noh pay main tu di ting dehn eena di Laa weh reeli impoatant, laik chreet peepl fyaa, ahn ga mersi ahn fayt. ");
INSERT INTO bzj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Unu da sohn blain gaid. Unu schrayn owt wahn lee flai owta unu jrink, bot unu wahn swala wahn hoal kyamil! ");
INSERT INTO bzj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Unu teecha a di Laa ahn unu Farisee, unu een fi big chrobl. Unu hipokrit unu! Unu mek shoar unu kleen evriting pahn di owtsaid weh peepl ku si, laik unu kop ahn unu playt ahn soh, bot eena unu haat unu greedi ahn selfish no miks! ");
INSERT INTO bzj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Unu blain Farisee unu! Kleen di eensaid a di kop fos, den di owtsaid wahn kleen tu. ");
INSERT INTO bzj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Unu teecha a di Laa ahn unu Farisee, unu een fi big chrobl. Unu hipokrit unu! Kaa unu da sayhn laik dehn grayv weh paynt wait ahn luk priti pahn di owtsaid, bot eensaid dehn ful op a ded peepl boan ahn ting weh di ratn. ");
INSERT INTO bzj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Da sayhn way wid unu—pahn di owtsaid unu luk soh raichos, bot eensaid unu da reel hipokrit ahn unu wikid no miks. ");
INSERT INTO bzj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","“Unu teecha a di Laa ahn unu Farisee, unu een fi big chrobl. Unu hipokrit unu! Kaa unu bil toom fi di prafit dehn ahn unu priti op di grayv dehn fi ada raichos peepl, ahn den unu seh, ‘If wee mi liv eena fi wee ansesta dehn dayz, wee neva mi wahn tek paat lang wid dehn ahn kil di prafit dehn.’ ");
INSERT INTO bzj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Wen unu seh dat, unu agree dat unu kohn dong chroo di famili lain a dehn wan weh mi merda di prafit dehn. ");
INSERT INTO bzj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Wel, unu goh hed ahn finish weh unu ansesta dehn staat den. ");
INSERT INTO bzj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Unu da snayk ahn unu pa dehn da-mi snayk tu! Da how unu wahn get weh fahn geh kandem tu hel? ");
INSERT INTO bzj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Wel, Ah wahn sen sohn prafit tu unu, ahn sohn man weh waiz, ahn sohn teecha a di Laa. Unu wahn nayl som a dehn pahn kraas ahn kil dehn, ahn unu wahn flag sohn eena unu meetn plays dehn ahn ron dehn fahn tong tu tong. ");
INSERT INTO bzj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sayka dat, di blod a aala di inosent peepl dehn weh geh kil pahn ert wahn deh pahn unu hed. Dat meen unu wahn gilti a di blod a Aybl weh mi raichos, rait dong tu Zakaraiya weh da-mi Berakaiya son. Dehn mi kil hihn bitween di templ ahn di alta. ");
INSERT INTO bzj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ah di tel unu di chroot, aala dis wahn kohn pahn dis jenarayshan. ");
INSERT INTO bzj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Aiy Jeroosalem, Jeroosalem, yoo da di siti weh kil aaf di prafit dehn; unu stoan Gaad mesinja dehn! Yu noa humoch taim Ah mi waahn gyada op yu peepl dehn tugeda laik how wahn hen wuda protek ih baybi chikin dehn anda ih wing? Bot unu neva waahn mek Ah du it. ");
INSERT INTO bzj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ahn now si, Gaad noh deh eena yu templ nohmoh. ");
INSERT INTO bzj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kaa Ah di tel unu, unu noh wahn si mi agen til wen unu seh, ‘Gaad bles di Wan weh kom eena di naym a di Laad.’” ");
INSERT INTO bzj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jeezas kom owta di templ ahn az ih mi-di waak weh, ih disaipl dehn kom op tu ahn, ahn staat tu paint owt aala di bildin dehn weh da-mi paat a di templ. ");
INSERT INTO bzj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Den Jeezas aks dehn seh, “Unu si aala dehn bildin ya? Wel, Ah di tel unu di chroot, aala dehnya bildin ya wahn geh nak dong flat; nat wan stoan wahn lef pahn tap a di neks.” ");
INSERT INTO bzj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Layta, wen Jeezas mi-di sidong pahn di hil weh nayhn di Mongt a Alivz, di disaipl dehn kohn tu ahn praivit-wan ahn seh, “Tel wi, da wen aala dehnya ting wahn hapm? Ahn weh wahn hapm fi mek wi noa dat da taim fi yu kohn bak, ahn dat da taim fi di werl kohn tu wahn en?” ");
INSERT INTO bzj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jeezas ansa dehn seh, “Unu wach owt ahn noh mek nobadi fool unu. ");
INSERT INTO bzj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Lata peepl wahn kohn di yooz mai naym di seh, ‘Ai da di Krais,’ ahn dehn wahn fool op lata peepl. ");
INSERT INTO bzj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Unu wahn yehr waar di brok owt kloas tu unu, ahn unu wahn yehr nyooz bowt waar weh di goh aan faar fahn unu. Bot si dat unu noh fraitn kaa ting laik dehnya hafu hapm, bot dat noh meen dat da taim fi di en kohn yet. ");
INSERT INTO bzj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Lata difrent nayshan ahn kingdom wahn waar gens wan anada. Peepl wahn di staav aal oava ahn lata ertwayk wahn deh da difrent plays. ");
INSERT INTO bzj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Aala dehn ting deh da jos di biginin a plenti sofarin, jos laik wen wahn pregnant uman di staat tu goh eena layba. ");
INSERT INTO bzj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Den dehn wahn han unu oava mek dehn persikyoot unu ahn kil unu, ahn sayka weh unu bileev eena mee, aala di nayshan dehn wahn hayt unu. ");
INSERT INTO bzj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Den lata peepl wahn stap bileev eena mi, ahn dehn wahn sel owt wan anada ahn hayt wan anada. ");
INSERT INTO bzj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ahn dehn wahn ga lata faals prafit weh wahn kohn ahn fool op lata peepl. ");
INSERT INTO bzj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sayka weh moa ahn moa wikidnis wahn deh, lata peepl lov wahn geh koal tuwaadz wan anada. ");
INSERT INTO bzj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bot enibadi weh stay faytful tu mee tu di en wahn sayv. ");
INSERT INTO bzj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ahn di Gud Nyooz bowt di kingdom a hevn wahn geh preech oava di hoal werl soh dat aala di nayshan dehn ku yehr di chroot, ahn den di en wahn kohn. ");
INSERT INTO bzj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Di taim wahn kohn wen unu wahn si ‘di harabl ting weh Gaad hayt di moas, weh kaaz dischrokshan,’ di stan op eena di hoali plays. Dis da weh di prafit Danyel mi rait bowt. (Mek evribadi weh reed dis andastan weh ih meen.) ");
INSERT INTO bzj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Wen unu si dat hapm, mek aala dehn wan weh deh eena Judeeya dischrik hori ron goh da di mongtin dehn. ");
INSERT INTO bzj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","If enibadi deh pahn dehn howstap, noh mek dehn bada kohn dong kohn geh notn fahn owta di hows. ");
INSERT INTO bzj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ahn noh mek nobadi weh deh owt eena di feel eevn goh bak goh geh dehn koat. ");
INSERT INTO bzj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Eena dehn dayz deh ih wahn bee harabl fi dehn laydi weh pregnant ahn dehn wan weh ga yong baybi! ");
INSERT INTO bzj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pray Gaad dat dis noh hapm joorin koal weda taim, ");
INSERT INTO bzj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","kaa di chrobl weh di kom eena dehndeh dayz deh wahn bee moa terabl dahn eniting weh mi eva deh fahn di biginin a di werl til tudeh day. Ahn notn laik dat noh wahn eva deh agen. ");
INSERT INTO bzj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bot Gaad mi don kot shaat di amonk a dayz eena dehn taim deh, jos sayka fi hihn speshal wan dehn weh hihn pik. If ih neva du dat, den nobadi wuda lef alaiv. ");
INSERT INTO bzj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Den if enibadi tel unu, ‘Luk! Si di Krais ya!’ er, ‘Si ahn deh!’ unu noh bileev dehn. ");
INSERT INTO bzj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Faals Krais ahn faals prafit wahn kohn ahn perfaam lata big mirakl ahn wandaz fi chrai chrik eevn dehn speshal wan dehn weh Gaad pik, if dat kuda mi hapm. ");
INSERT INTO bzj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Si, Ah don waan unu heda taim. ");
INSERT INTO bzj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Soh if dehn tel unu, ‘Si, luk! Ih deh eena di dezert,’ unu noh fi goh owt goh luk far ahn. If dehn seh, ‘Si, luk! Ih deh eena wahn seekrit plays,’ noh bileev dehn needa. ");
INSERT INTO bzj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kaa sayhn laik how yu si how laitnin flash kraas di skai fahn ees tu wes, da rait soh ih wahn bee wen di Son a Man kohn bak. ");
INSERT INTO bzj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Eniway wehpaa ded badi deh, da rait dehsoh jranko wahn gyada. ");
INSERT INTO bzj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Rait afta dehn dayz a sofarin ‘di son wahn geh daak daak, ahn di moon noh wahn shain. Di staar dehn wahn jrap owta di skai, ahn evriting owt eena spays wahn geh shayk op.’ ");
INSERT INTO bzj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Da taim deh di sain dat di Son a Man di kohn wahn apyaa eena di skai, ahn aala di peepl dehn pahn di ert wahn baal. Dehn wahn si di Son a Man di kom eena di klowd dehn a di skai wid powa, ahn ih wahn di shain eena aala ih gloari. ");
INSERT INTO bzj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ahn ih wahn sen owt ih aynjel dehn wid wahn big chrompit blaas, ahn dehn wahn gyada aala fi hihn speshal peepl dehn weh hihn pik, fahn wan en a di ert tu di neks. ");
INSERT INTO bzj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Now Ah waahn unu laan wahn lesn fahn di fig chree: wen unu si di branch dehn geh saaf ahn green ahn dehn staat tu put owt leef, unu noa seh dat da nayli taim fi soma. ");
INSERT INTO bzj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sayhn way, wen unu si aala dehnya ting di hapm, unu wahn noa seh dat di taim fi di Son a Man kohn bak deh kloas kloas, rait da unu doa mowt! ");
INSERT INTO bzj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ah di tel unu di chroot, di peepl dehn fahn dis jenarayshan noh wahn ded owt til aala dehnya ting don hapm. ");
INSERT INTO bzj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Hevn ahn ert wahn don weh wid, bot weh Ai di seh wahn stay fareva. ");
INSERT INTO bzj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nobadi noh noa di day ner di owa wen dehn ting wahn hapm. Di aynjel dehn eena hevn noh noa, ahn di Son a Man noh noa needa. Oanli di Faada noa dat. ");
INSERT INTO bzj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Sayhn laik how ting mi stan eena Noawa dayz, da rait soh ih wahn bee wen di Son a Man kohn bak. ");
INSERT INTO bzj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Eena dehn dayz bifoa di flod, peepl mi-di eet op ahn jrink op laik notn, ahn dehn mi-di geh marid ahn soh, rait op tu di veri day wen Noawa gaan eena di aak; ");
INSERT INTO bzj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ahn dehn neva noa weh kech dehn til wen di flod kohn ahn wash aala dehn weh. Da rait soh ih wahn bee wen di Son a Man kohn bak. ");
INSERT INTO bzj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Too peepl wahn deh owt eena di feel; wan a dehn wahn geh tek weh ahn di neks wan wahn geh lef bihain. ");
INSERT INTO bzj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Too laydi wahn di grain weet wid wahn han mil; wan a dehn wahn geh tek weh ahn di neks wan wahn geh lef bihain. ");
INSERT INTO bzj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Soh unu kip pahn di lukowt kaa unu noh noa weh day unu Laad di kohn bak. ");
INSERT INTO bzj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bot andastan dis: If di oana a di hows mi noa weh paat a di nait di teef mi wahn kohn, ih mi wahn deh pahn di lukowt ahn ih neva mi wahn mek dehn brok eena ih hows. ");
INSERT INTO bzj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Soh unu mos redi tu, kaa di Son a Man di kohn wen unu lees ekspek. ");
INSERT INTO bzj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Soh da hoo da wahn servant weh waiz, weh ih baas ku pen pan? Da di wan weh ih baas wahn put in chaaj a aala di servant dehn eena ih hows; da servant wahn si tu it dat evribadi weh werk eena ih hows geh dehn food tu taim. ");
INSERT INTO bzj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ih wahn gud fi da servant if ih baas kohn bak ahn fain ahn di du di jab weh ih lef ahn fi du. ");
INSERT INTO bzj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ah di tel unu di chroot, dat da di wan weh di baas wahn put in chaaj a evriting weh ih oan. ");
INSERT INTO bzj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Bot sopoaz da servant wikid ahn ih seh tu ihself, ‘Mai baas hihn di tek lang fi kohn.’ ");
INSERT INTO bzj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Soh ih staat tu beet op di ada servant dehn ahn staat tu eet op ahn jrink op wid ih jronkin fren dehn. ");
INSERT INTO bzj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Soh den, fi hihn baas wahn kohn wahn day ahn wahn taim wen da servant lees ekspek. ");
INSERT INTO bzj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ih baas wahn ponish ahn bad ahn sen ahn sayhn plays weh aala di hipokrit dehn deh. Lata baalin wahn dehdeh ahn peepl teet wahn di nak op gens wan anada. ");
INSERT INTO bzj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Eena dehn taim deh di kingdom a hevn wahn stan jos laik ten braidzmayd weh kehr dehn lamp dehn ahn gaahn fi meet di groom. ");
INSERT INTO bzj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Wel, faiv a di braidzmayd dehn mi schupid, ahn di neks faiv mi ga sens. ");
INSERT INTO bzj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Di faiv schupid wan dehn neva kehr no ail fi dehn lamp, ");
INSERT INTO bzj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","bot di neks wan dehn mi ga nof sens fi kehr ekschra ail wid dehn. ");
INSERT INTO bzj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Wel, di groom mi-di tek lang fi kohn, ahn di braidzmayd dehn mi-di geh sleepi, soh dehn lidong fi tek wahn lee sleep. ");
INSERT INTO bzj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Twelv aklak da nait sohnbadi hala seh, ‘Unu luk! Di groom di kohn! Unu kom owt, kohn meet ahn.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Aal di braidzmayd dehn get op fi geh dehn lamp redi. ");
INSERT INTO bzj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Den di schupid wan dehn aks di ada wan dehn seh, ‘Gi wi som a unu ail noh? Fi wee lamp dehn di owt.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Bot di sensabl wan dehn ansa dehn seh, ‘Wee noh ga nof ail fi aala wi. Unu beta goh da shap goh bai fi unuself.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Bot wail dehn gaahn bai ail, di groom kohn, ahn dehn wan weh mi redi gaan eena di wedn bankwit wid ahn, ahn dehn lak di doa. ");
INSERT INTO bzj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Aftawodz wen di faiv schupid braidzmayd dehn kohn bak, dehn stan op owtsaid di hala, ‘Sa! Oapm di doa fi wi noh?’ ");
INSERT INTO bzj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Bot di groom hala bak seh, ‘Fi tel unu di chroot, mee noh noa da hoo unu!’ ");
INSERT INTO bzj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Soh unu hafu aalwayz bee redi kaa unu noh noa di day ner di owa wen di Son a Man wahn kohn bak. ");
INSERT INTO bzj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ahn den tu, di kingdom a hevn da laik wahn man weh mi gwehn pahn wahn lang chrip. Ih kaal ih servant dehn ahn lef dehn in chaaj a aala weh ih mi ga. ");
INSERT INTO bzj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ih lef moni wid dehn akaadn tu weh dehn kuda mi handl. Ih gi wan a dehn faiv towzn dalaz, wahn neks wan too towzn, ahn wahn nada wan, wan towzn. Den di man gaan. ");
INSERT INTO bzj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Di servant weh mi geh di faiv towzn dalaz gaahn schrayt gaahn inves di moni, ahn ih mek faiv towzn moa dalaz. ");
INSERT INTO bzj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Rait soh, di wan weh mi geh too towzn dalaz gaan ahn mek too moa towzn pahn tap a it. ");
INSERT INTO bzj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bot di wan weh mi geh wan towzn dalaz gaan ahn dig wahn hoal eena di grong ahn haid di moni weh ih baas mi gi ahn. ");
INSERT INTO bzj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Wel, afta wahn lang taim di servant dehn baas kohn bak fi si weh dehn mi du wid ih moni. ");
INSERT INTO bzj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Di fos servant weh mi geh di faiv towzn dalaz kom op ahn seh, ‘Si Sa, yu gi mi faiv towzn dalaz an Ah mek faiv towzn moa pahn tap a it.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Di baas tel ahn seh, ‘Yu du gud! Yu da wahn gud servant weh Ah ku chros. Yu shoa mi seh yu ku handl lee bit a ting, soh Ah wahn put yu in chaaj a lat moa ting. Kohn kohn selibrayt wid mi.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Di servant weh mi geh too towzn dalaz kom op ahn seh, ‘Si Sa, Ah mek too moa towzn dalaz.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ih baas seh, ‘Yoo du gud tu, ahn yoo da wahn gud servant weh Ah ku chros. Yu shoa mi seh yu ku handl lee bit a moni, soh Ah wahn put yu in chaaj a lat moa ting. Kohn kohn selibrayt wid mi.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","“Den di wan hihn weh mi geh wan towzn dalaz kom op ahn seh, ‘Wel Sa, Ah mi noa seh yoo da wahn haad man weh reep wehpaa yu neva plaant, ahn tek owt weh yu neva put een, an Ai mi frayd, soh Ah gaan ahn haid yu moni eena di grong. Si yu moni ya, Sa.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","“Bot ih baas seh, ‘Yu wikid ahn layzi servant, yu! Laik how yu mi noa seh Ah mi reep wichpaa Ah neva plaant, ahn tek owt weh Ah neva put een, den at lees yu kuda mi put mi moni da bank soh dat Ah kuda mi kalek inchres pan it.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","29","“Den di baas seh, ‘Tek weh di moni weh Ah mi gi hihn, ahn gi di servant weh ga ten towzn dalaz. Kaa evribadi weh ga, wahn geh moa, ahn dehn wahn ga lat lat lat. Bot az fi dehn wan weh noh ga notn, eevn weh dehn ga wahn geh tek weh fahn dehn. ");
INSERT INTO bzj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Az fi dis wotlis servant hihn, pich hihn way owtsaid eena daak weh peepl wahn loan di baal ahn grain op dehn teet.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Wen di Son a Man kohn az king eena aala ih gloari, lang wid aala di aynjel dehn, ih wahn sidong pahn ih raiyal chroan. ");
INSERT INTO bzj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Den di peepl dehn fahn aala di nayshan dehn wahn gyada fronta ahn, ahn hihn wahn separayt di peepl dehn fahn wan anada sayhn laik how wahn shepad separayt di sheep dehn fahn di goat dehn. ");
INSERT INTO bzj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ahn ih wahn put dehn peepl weh da laik sheep pahn ih rait han said, ahn dehn wan weh da laik goat pahn ih lef. ");
INSERT INTO bzj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Den di king wahn tel dehn wan weh deh pahn ih rait han said seh, ‘Unu weh mi Faada bles, unu kohn kohn get unu legisi weh da di kingdom weh mi Faada geh redi fi unu fahn wen di werl mi fos mek; ");
INSERT INTO bzj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","kaa Ah mi hongri ahn unu feed mi; Ah mi tersti ahn unu gi mi ting fi jrink; Ah da-mi wahn schraynja ahn unu welkom mi eena unu hows. ");
INSERT INTO bzj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ah mi naykid ahn unu gi mi kloaz; Ah mi sik ahn unu tek kayr a mi; Ah mi deh eena jayl ahn unu kohn kohn luk fi mi.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Den dehn peepl weh rait wid Gaad wahn seh, ‘Laad, da wen wee mi si yoo hongri ahn feed yu, er si yu tersti ahn gi yu ting fi jrink? ");
INSERT INTO bzj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ahn da wen wee mi si yu laik wahn schraynja ahn tek yu een, er si yu naykid ahn gi yu kloaz? ");
INSERT INTO bzj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ahn da wen wi mi si yu sik er eena jayl ahn gaahn luk fi yu?’ ");
INSERT INTO bzj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Den di king wahn ansa dehn seh, ‘Ah di tel unu di chroot, wateva unu du fi eevn di lees a dehn wan weh bilangz tu mee, unu di du it fi mee tu.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Den ih tel dehn wan weh deh pahn ih lef han said seh, ‘Unu weh deh anda Gaad kers, unu get away fahn mi! Unu gwehn eena di faiya weh wahn neva owt—da faiya weh mek fi di devl ahn fi hihn aynjel dehn. ");
INSERT INTO bzj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kaa Ah mi hongri ahn unu neva gi mi notn fi eet; Ah mi tersti ahn unu neva gi mi notn fi jrink; ");
INSERT INTO bzj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ah da-mi wahn schraynja ahn unu neva tek mi een; an Ah mi naykid ahn unu neva gi mi no kloaz; Ah mi sik, an Ah mi eena jayl, ahn unu neva eevn kohn luk fi mi.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Dehn anaal wahn aks ahn seh, ‘Laad, da wen wi mi si yoo hongri er tersti er wahn schraynja er naykid er sik er eena jayl ahn wi neva tek kayr a yu?’ ");
INSERT INTO bzj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Den di king wahn ansa dehn seh, ‘Ah di tel unu di chroot, jos laik how unu neva du it fi nat eevn di lees wan a dehn wan weh bilangz tu mee, unu neva du it fi mee needa.’ ");
INSERT INTO bzj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ahn den dehn wan deh wahn goh tu fi dehn ponishment weh wahn laas fareva, bot dehn wan weh rait wid Gaad wahn goh goh liv wid hihn fareva.” ");
INSERT INTO bzj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wen Jeezas mi don seh aala dehn ting, ih tel ih disaipl dehn seh, ");
INSERT INTO bzj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Unu noa dat di Paasoava selibrayshan wahn staat eena too dayz, ahn dehn wahn han oava di Son a Man fi mek dehn kroosifai ahn.” ");
INSERT INTO bzj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wail dis di goh aan, di cheef prees dehn ahn di Jooish leeda dehn mi-di ga wahn meetn da Kaiyafas di hai prees hows. ");
INSERT INTO bzj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Dehn nak hed tugeda fi chrai fain sohn kaina way fi ares Jeezas ahn kil ahn. ");
INSERT INTO bzj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bot dehn seh, “Wi noh waahn du it wail di selibrayshan di goh aan, kaa dat ku spaak aaf raiyat monks di peepl dehn.” ");
INSERT INTO bzj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Now Jeezas mi deh da Betani da Saiman hows. Saiman da wahn man weh mi ga leprosi. ");
INSERT INTO bzj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Wahn laydi kom op tu Jeezas ahn shee mi ga wahn ekspensiv perfyoom weh mi deh eena wahn batl weh mek owta alabasta stoan. Ih tek di perfyoom ahn poar it pahn Jeezas hed wail ih mi deh rong di taybl. ");
INSERT INTO bzj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wen di disaipl dehn si dat, dehn mi beks no miks, ahn dehn shush monks dehnself seh, “Dat da ways! ");
INSERT INTO bzj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Dehn kuda mi sel dis perfyoom fi wahn lata moni, ahn dehn kuda mi gi di moni tu di poa peepl dehn.” ");
INSERT INTO bzj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jeezas mi don noa weh dehn mi-di seh, soh ih tel dehn seh, “Lef di laydi loan noh? Shee du wahn nais ting fi mi. ");
INSERT INTO bzj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Poa peepl wahn aalwayz deh wid unu, bot unu noh wahn aalwayz ga mee. ");
INSERT INTO bzj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wen shee mi poar owt dis perfyoom pahn mi, ih mi-di geh mi redi fi wen dehn wahn beri mi. ");
INSERT INTO bzj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ah di tel unu di chroot, eniway eena di hoal werl weh dehn preech dis Gud Nyooz, dehn wahn memba shee ahn taak bowt weh shee mi du.” ");
INSERT INTO bzj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Den Joodas Iskariyat, weh da-mi wan a di twelv disaipl dehn, gaahn da di cheef prees dehn. ");
INSERT INTO bzj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ahn Joodas aks dehn seh, “Weh unu wahn gi mi if Ah help unu ares Jeezas?” Dehn konk owt terti pees a silva ahn gi ahn. ");
INSERT INTO bzj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Fahn deh goh bak ih staat tu luk fi di karek taim wen ih kuda mi sel ahn owt tu dehn. ");
INSERT INTO bzj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Now pahn di fos day a di Paasoava selibrayshan wen di Jooish peepl dehn eet bred weh mek widowt ees, di disaipl dehn gaahn tu Jeezas ahn aks ahn seh, “Wehpaa yu waahn wi goh set op fi mek yu eet di Paasoava dina?” ");
INSERT INTO bzj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ih tel dehn seh, “Goh eena di siti tu wahn sertn man ahn tel ahn seh dat di teecha seh ih taim nayli op. Ih gwehn goh selibrayt di Paasoava dina wid ih disaipl dehn eena yu hows.” ");
INSERT INTO bzj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Soh, di disaipl dehn du weh Jeezas mi tel dehn, ahn dehn geh di Paasoava dina redi. ");
INSERT INTO bzj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Wen eevnin kohn Jeezas mi deh rong di taybl wid di twelv disaipl dehn. ");
INSERT INTO bzj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ahn wail dehn mi-di eet, ih seh, “Ah di tel unu di chroot, wan a unu wahn sel mi owt.” ");
INSERT INTO bzj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dis oanli bada di disaipl dehn. Soh wan afta di ada dehn staat aks ahn seh, “Ih kyaahn bee mee, rait Laad?” ");
INSERT INTO bzj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ih ansa dehn seh, “Di wan weh wahn sel mi owt da di wan weh don dip ih bred eena di bowl wid mi. ");
INSERT INTO bzj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Di Son a Man wahn ded jos laik di oal taim prafit dehn mi seh, bot loan bad wahn fala di wan weh sel ahn owt. Ih wuda mi beta fi hihn if ih neva eevn baan!” ");
INSERT INTO bzj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Den Joodas, di sayhn wan weh mi wahn sel ahn owt, seh, “Ih kyaahn bee mee, rait Teecha?” Jeezas ansa ahn seh, “Yes, da yoo sayhn wan.” ");
INSERT INTO bzj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wail dehn mi-di eet, Jeezas pik op di bred ahn tank Gaad far it. Den ih brok it ahn gi ih disaipl dehn ahn seh, “Unu tek it ahn eet it. Dis da mai badi.” ");
INSERT INTO bzj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Den ih tek di kop ahn tank Gaad far it; ahn ih gi ih disaipl dehn ahn ih tel dehn seh, “Aala unu jrink fahn di kop. ");
INSERT INTO bzj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Dis da fi mee blod, weh da di nyoo agreement weh Gaad mek wid ih peepl dehn. Dis blod wahn poar owt fi lata peepl soh dat Gaad ku fagiv dehn sin dehn. ");
INSERT INTO bzj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","“Ah di tel unu, fahn ya goh bak Ah noh wahn jrink nohmoh wain til da day wen Ah jrink nyoo wain wid unu eena mi Faada kingdom.” ");
INSERT INTO bzj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wen dehn don sing wahn him, dehn gaan owt da di hil weh nayhn di Mongt a Alivz. ");
INSERT INTO bzj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Den Jeezas tel dehn seh, “Tunait, tunait aala unu wahn ron weh lef mi, sayka weh wahn hapm tu mee kaa ih rait dong eena di Skripcha seh, ‘Ah wahn schraik dong di shepad, ahn di sheep dehn fahn owta di flak wahn skyata.’ ");
INSERT INTO bzj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Bot afta Ah don rayz op bak fahn di ded, Ah gwehn heda unu da Gyalilee.” ");
INSERT INTO bzj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peeta seh tu Jeezas, “Ai wahn neva ron weh lef yoo sayka weh hapm tu yu, noh kay weh di res a dehn du.” ");
INSERT INTO bzj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jeezas tel ahn seh, “Ah di tel yu di chroot, tunait tunait bifoa di roosta kroa, yoo wahn disoan mee chree taim.” ");
INSERT INTO bzj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peeta ansa ahn seh, “Eevn if Ah hafu ded wid yu, Ah wahn neva disoan yu.” Ahn aala di ada disaipl dehn seh di sayhn ting. ");
INSERT INTO bzj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Den Jeezas ahn ih disaipl dehn gaahn da wahn plays weh nayhn Getsemani, ahn ih tel dehn seh, “Unu sidong ya wail Ai goh oava yaanda goh pray.” ");
INSERT INTO bzj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ih kehr Peeta ahn Zebidee too son dehn lang wid ahn, ahn ih staat tu feel sad sad ahn ih haat geh hevi hevi. ");
INSERT INTO bzj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Den Jeezas tel di disaipl dehn seh, “Mi haat soh hevi dat Ah feel laik Ah wahn ded. Stay ya ahn kip wach wid mi.” ");
INSERT INTO bzj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Den ih gaahn lee wayz hed ahn ih neel dong wid ih fays tu di grong ahn ih pray seh, “Faada, if ih pasabl, pleez noh mek Ah jrink owta dis kop a sofarin. Bot Ai wahn du wateva yoo waahn, noh weh Ai waahn.” ");
INSERT INTO bzj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Den Jeezas gaahn bak da weh di disaipl dehn mi deh ahn ih fain dehn di sleep. Ih aks Peeta seh, “Saiman, yu di sleep? Yu kudn stay op wid mi fi jos wan owa? ");
INSERT INTO bzj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kip wach ahn pray soh dat unu noh giv een tu temtayshan. Di spirit wilin bot di badi week.” ");
INSERT INTO bzj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Den ih gaahn bak wahn sekant taim ahn pray seh, “Faada, if no ada way noh deh eksep fi mek Ah jrink owta dis kop a sofarin, den Ah wahn du weh yoo waahn Ah du.” ");
INSERT INTO bzj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wen Jeezas gaahn bak, ih fain di disaipl dehn di sleep agen kaa dehn jos kudn kip dehn aiy oapm. ");
INSERT INTO bzj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Soh ih lef dehn agen ahn ih gaahn bak gaahn pray fi di terd taim, ahn ih seh di sayhn werd dehn agen. ");
INSERT INTO bzj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Den Jeezas gaahn bak da ih disaipl dehn ahn aks dehn seh, “Unu stil di sleep ahn di tek unu res? Si, da nayli taim fi mek dehn sel owt di Son a Man tu peepl weh wikid. ");
INSERT INTO bzj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Unu get op ahn lesgoh! Di wan weh sel ahn owt di kohn.” ");
INSERT INTO bzj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Wail Jeezas stil mi-di taak, Joodas, weh da-mi wan a di twelv disaipl dehn, kohn. Wahn hoal krowd a peepl mi deh wid ahn, ahn aala dehn mi ga soad ahn klob. Di cheef prees dehn ahn di Jooish leeda dehn mi sen dehn. ");
INSERT INTO bzj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Now di chrayta mi gi dehn wahn sain. Ih seh, “Di wan weh Ah wahn kis da di man. Hihn da di Wan weh unu fi ares.” ");
INSERT INTO bzj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sayhn taim ih waak rait op tu Jeezas ahn seh, “Gud nait, Teecha!” ahn ih kis ahn. ");
INSERT INTO bzj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jeezas tel ahn seh, “Fren, du weh yu deh ya fi du.” Den dehn kom op ahn grab Jeezas ahn ares ahn. ");
INSERT INTO bzj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Wan a dehn wan weh mi deh wid Jeezas haal owt ih soad ahn chap aaf di hai prees servant ayz. ");
INSERT INTO bzj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Den Jeezas tel ahn seh, “Put op yu soad, kaa enibadi weh haal soad, da soad wahn kil dehn. ");
INSERT INTO bzj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Unu noh tink seh Ai ku kaal pahn mai Faada, ahn ih wahn sen towznz a aynjel rait now fi protek mi? ");
INSERT INTO bzj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bot den how di Skripcha weh seh dat aala dis fi hapm wahn kohn chroo?” ");
INSERT INTO bzj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Da sayhn taim deh, Jeezas tel di krowd, “Da weh hapm now? Unu kom owt ya wid soad ahn klob fi ares mi laik Ai da sohn kaina kriminal. Ai sidong eena di templ evri day di teech ahn unu neva ares mi. ");
INSERT INTO bzj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bot aala dis hapm soh dat weh di prafit dehn mi rait eena di Skripcha kuda mi kohn chroo.” Ahn aala di disaipl dehn ton rong ahn ron lef hihn wan deh. ");
INSERT INTO bzj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Dehn wan weh ares Jeezas kehr ahn da Kaiyafas hows. Hihn da-mi di hai prees. Dehn wan weh teech di Jooish Laa ahn di Jooish leeda dehn mi gyada deh. ");
INSERT INTO bzj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bot Peeta mi-di fala ahn fahn faar, ahn ih gaahn rait op tu di hai prees yaad. Aftawodz ih gaan eensaid ahn sidong wid di gyaad dehn kaa ih mi waahn si weh mi wahn hapm. ");
INSERT INTO bzj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Now di cheef prees ahn di hoal Jooish Kongsl mi-di chrai haad fi fain sohn kaina faals evidens gens Jeezas, soh dat dehn kuda mi put ahn tu det. ");
INSERT INTO bzj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bot dehn kudn fain notn, eevn doa lata peepl kohn kohn tel lai pan ahn. Pahn di en, too peepl kohn fronta di Kongsl ");
INSERT INTO bzj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ahn seh, “Dis man seh, ‘Ai ku brok dong Gaad templ ahn bil it bak eena chree dayz.’” ");
INSERT INTO bzj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Den di hai prees stan op ahn aks Jeezas seh, “Yu noh wahn ansa? Da weh dis weh dehnya peepl di seh gens yu?” ");
INSERT INTO bzj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bot Jeezas neva seh wan werd. Den di hai prees tel ahn seh, “Sway tu wi eena di naym a di livin Gaad, ahn tel wi if yoo da di Krais weh da Gaad Son.” ");
INSERT INTO bzj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jeezas tel ahn seh, “Yu rait wen yu seh dat. Bot Ah tel yu, fahn ya goh bak, yu wahn si di Son a Man di sidong da di plays a aana weh deh pahn di rait han said a Gaad Almaiti, ahn ih di kohn dong pahn di klowd dehn fahn hevn.” ");
INSERT INTO bzj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Wen di hai prees yehr dat, ih geh beks ahn tayr ih kloaz. Ih seh, “Hihn di disrispek Gaad! Wi noh need nohmoh witnis. Unu don yehr how ih disrispek Gaad. ");
INSERT INTO bzj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Soh da weh unu tink?” Dehn ansa seh, “Ih dizerv fi ded.” ");
INSERT INTO bzj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Den dehn spit eena Jeezas fays ahn ponch ahn. Sohn ada wan slap ahn, ahn klong ahn seh, “Kohn Krais, laik how yu da prafit, tel wi da hoo nak yu.” ");
INSERT INTO bzj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Now Peeta mi-di sidong owtsaid eena di yaad. Wahn mayd kohn tu ahn, ahn seh, “Yoo anaal mi deh wid Jeezas weh kohn fahn Gyalilee.” ");
INSERT INTO bzj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bot Peeta neva oan op tu it. Ih seh fronta aala dehn, “Ai noh noa weh unu di taak bowt.” ");
INSERT INTO bzj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wen ih gaan owt bai di gayt, wahn neks mayd si ahn, ahn shee tel di peepl dehn weh mi dehdeh, “Dis man mi deh wid Jeezas weh kohn fahn Nazaret.” ");
INSERT INTO bzj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bot agen Peeta seh dat dat da noh chroo. Ih sway anaal ahn seh, “Ah tel yu, Ai noh noa da man!” ");
INSERT INTO bzj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Afta wahn lee wail, di peepl dehn weh mi-di stan op rong deh kom op tu Peeta ahn seh, “Yes, man! Yoo da wan a Jeezas disaipl dehn, kaa jos di way yu taak sel yu.” ");
INSERT INTO bzj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Den Peeta seh, “Ah di sway tu unu seh mee noh eevn noa disya man weh unu di taak bowt! Mek Gaad schraik mi dong if Ah noh di tel di chroot.” Da sayhn taim deh wahn roosta kroa. ");
INSERT INTO bzj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Den Peeta memba weh Jeezas mi tel ahn: “Bifoa di roosta kroa, yu wahn seh dat yu noh noa mi chree taim.” Ahn ih gaan owtsaid gaahn baal ahn baal til ih kudn baal nohmoh. ");
INSERT INTO bzj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Soon di neks maanin, aala di cheef prees dehn ahn di Jooish leeda dehn get tugeda ahn disaid fi kil Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dehn tai ahn op ahn kehr ahn weh, ahn han ahn oava tu Pailat, weh da-mi di Roaman govna. ");
INSERT INTO bzj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Wen Joodas, di wan weh mi sel owt Jeezas, si dat dehn mi wahn kil Jeezas, ih mi oanli feel bad. Soh ih gaan ahn ih kehr bak di terti pees a silva da di cheef prees ahn di Jooish leeda dehn, ahn ih seh, ");
INSERT INTO bzj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Ah du wahn terabl sin bikaa Ah sel owt sohnbadi weh noh du notn rang ataal.” Dehn luk pan ahn, ahn dehn seh, “Weh dat ga fi du wid wee? Dat da fi yoo prablem.” ");
INSERT INTO bzj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Soh Joodas chroa dong di moni eena di templ ahn gaan owt gaahn heng ihself. ");
INSERT INTO bzj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Di cheef prees dehn pik op di moni ahn seh, “Dis moni mi yooz fi pay fi geh wahn man kil, soh wi kyaahn miks it op wid di templ moni.” ");
INSERT INTO bzj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dehn agree fi yooz di moni fi bai wahn feel weh bilangz tu sohnbadi weh mek klay pat. Dehn mi waahn yooz di feel fi beri farinaz eena. ");
INSERT INTO bzj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Dats wai dehn kaal di feel di Feel a Blod eevn op tu tudeh. ");
INSERT INTO bzj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Den weh di prafit Jerimaiya mi seh kohn chroo. Ih mi seh, “Ahn tek di terti silva kain dehn, weh da di prais weh som a di peepl a Izrel dehn tink seh ih wot. ");
INSERT INTO bzj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ahn dehn bai di feel weh bilangz tu sohnbadi weh mek klay pat, jos laik weh Gaad seh.” ");
INSERT INTO bzj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Now Jeezas stan op fronta Pailat, weh da-mi di govna, ahn Pailat aks ahn seh, “Yoo da di king a di Jooz?” Ahn Jeezas ansa seh, “Yu rait wen yu seh dat.” ");
INSERT INTO bzj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bot wen di cheef prees dehn ahn di Jooish leeda dehn akyooz ahn, ih neva ansa nat wan werd. ");
INSERT INTO bzj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Den Pailat seh tu ahn, “Yoo noh yehr humoch ting dehn di akyooz yu a?” ");
INSERT INTO bzj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bot Jeezas neva seh notn. Ih neva ansa tu nat wan a di chaaj dehn weh dehn mi bring gens ahn. Dis mi oanli sopraiz di govna. ");
INSERT INTO bzj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Now dehn mi ga wahn ting weh di govna du evri yaa joorin di Paasoava selibrayshan, weh ih let goh wahn prizna weh di krowd pik. ");
INSERT INTO bzj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Da sayhn taim deh dehn mi ga wahn prizna weh evribadi mi noa weh nayhn Baraabas. ");
INSERT INTO bzj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Soh wen di krowd don gyada, Pailat aks dehn seh, “Da wich wan a dehn prizna unu waahn Ah let goh fi unu? Unu waahn Ah let goh Baraabas, er Jeezas weh dehn seh da di Krais?” ");
INSERT INTO bzj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat mi wel noa dat da mi sayka dehn mi jelos mek dehn mi han Jeezas oava tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wail Pailat mi dehdeh di joj Jeezas kays, ih waif sen wahn mesij weh seh, “Noh ga notn fi du wid da man weh inosent, kaa Ah mi ga wahn bad bad jreem bowt hihn, ahn ih bada mi hoal day.” ");
INSERT INTO bzj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bot di cheef prees ahn di Jooish leeda dehn set op di krowd fi aks fi Baraabas ahn mek dehn kroosifai Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pailat aks dehn seh, “Da wich wan a dehnya too man unu waahn Ah let goh tu unu?” Dehn ansa seh, “Baraabas.” ");
INSERT INTO bzj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Soh Pailat aks dehn seh, “Weh unu waahn mek Ah du wid Jeezas weh dehn kaal di Krais?” Aala dehn hala, “Kroosifai ahn!” ");
INSERT INTO bzj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailat aks dehn seh, “Wai? Ih komit eni kraim?” Bot dehn hala haada, “Kroosifai ahn!” ");
INSERT INTO bzj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Soh wen Pailat si raiyat mi-di brok owt ahn hihn neva mi-di mek no hedway, ih tek waata ahn wash aaf ih han dehn fronta di krowd ahn seh, “Aarait, Ai inosent a dis man blod. Unu du dis unuself.” ");
INSERT INTO bzj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Den aala di peepl dehn hala tugeda ahn seh, “Mek ih blod deh pahn fi wee hed, ahn pahn fi wi pikni dehn hed!” ");
INSERT INTO bzj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Den Pailat let goh Baraabas tu dehn. Bot ih mek di soalja dehn flag Jeezas. Den ih han ahn oava fi mek dehn kroosifai ahn. ");
INSERT INTO bzj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Den di govna soalja dehn kehr Jeezas da di govna hows ahn dehn kaal aala di res a soalja dehn fi gyada rong ahn. ");
INSERT INTO bzj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dehn haal aaf ih kloaz ahn jres ahn op eena wahn red gong; ");
INSERT INTO bzj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ahn den dehn mek wahn krong owta prikl bush ahn put it pahn ih hed. Dehn put wahn stik eena ih rait han ahn neel dong fronta ahn tek ahn mek papishoh. Dehn seh, “Lang liv di king a di Jooz!” ");
INSERT INTO bzj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dehn spit pan ahn, ahn tek di stik ahn wap ahn kraas ih hed oava ahn oava agen. ");
INSERT INTO bzj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wen dehn don tek ahn mek nof papishoh, dehn tek aaf di gong ahn put aan bak ih oan kloaz pan ahn, ahn kehr ahn gaahn kroosifai ahn. ");
INSERT INTO bzj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Az dehn mi-di goh owt, dehn meet wahn man nayhn Saiman fahn Saireen. Dehn foas ahn fi bak Jeezas kraas. ");
INSERT INTO bzj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dehn reech wahn plays weh nayhn Galgota, weh meen “Skol Hil.” ");
INSERT INTO bzj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Dehn gi Jeezas wain weh miks wid wahn kaina bitaz weh nayhn gaal, bot wen ih tays it, ih neva jrink it ataal. ");
INSERT INTO bzj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wen dehn don kroosifai ahn, dehn gyambl fi si how dehn mi wahn shayr op ih kloaz monks dehn. ");
INSERT INTO bzj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Den dehn sidong deh di kip wach oava ahn. ");
INSERT INTO bzj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Dehn put wahn sain oava ih hed weh seh wai dehn mi-di kroosifai ahn. Di sain seh: dis da jeezas, di king a di jooz. ");
INSERT INTO bzj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Too teef mi kroosifai lang wid ahn. Dehn put wan pahn ih rait ahn wan pahn ih lef. ");
INSERT INTO bzj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Di peepl dehn weh mi-di paas mi-di hala aal kaina ting aata Jeezas ahn dehn mi-di shayk dehn hed ahn seh, “Soh, da yoo mi wahn brok dong di templ ahn bil ahn bak eena chree dayz noh? Wel, sayv yuself. Kohn dong fahn aafa di kraas if yoo da Gaad Son.” ");
INSERT INTO bzj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Di sayhn way di cheef prees dehn ahn dehn wan weh teech di Jooish Laa ahn di Jooish leeda dehn mi-di klong ahn. Dehn seh, “Ih mi sayv ada peepl, bot ih kyaahn eevn sayv ih oanself! Sins hihn da di King a Izrel, mek ih kohn dong fahn aafa di kraas, ahn wee wahn bileev eena ahn. ");
INSERT INTO bzj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Hihn chros eena Gaad. Wel den, mek Gaad sayv ahn if ih waahn, kaa da hihn seh, ‘Ai da Gaad Son.’” ");
INSERT INTO bzj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sayhn way, di teef dehn weh mi kroosifai lang wid Jeezas mi-di insolt ahn op tu. ");
INSERT INTO bzj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Fahn big twelv aklak da day rait op til bowt chree aklak da aftanoon di hoal plays geh daak daak. ");
INSERT INTO bzj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bowt chree aklak di aftanoon Jeezas hala owt haad-wan, “Eloi, Eloi, lama sabaktani.” Dat meen, “Oa mai Gaad, mai Gaad! Weh mek yu ton yu bak pahn mi?” ");
INSERT INTO bzj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wen som a dehn weh mi-di stan op deh yehr dat, dehn seh, “Ih di hala fi Ilaija.” ");
INSERT INTO bzj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sayhn taim wan a dehn ron gaahn geh wahn sponj. Ih soak it wid wain vineega ahn hais it op pahn wahn stik ahn gi Jeezas fi jrink. ");
INSERT INTO bzj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bot di nada wan dehn seh, “Wayt, mek wi si if Ilaija wahn kohn kohn sayv ahn.” ");
INSERT INTO bzj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ahn wen Jeezas baal owt haad-wan agen, ih jraa ih laas bret. ");
INSERT INTO bzj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sayhn taim di kertn eena di templ weh paat aaf di hoaliyis paat fahn di res a di templ tayr rait dong fahn tap tu batam. Di grong shayk ahn di rak dehn split oapm. ");
INSERT INTO bzj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Di grayv dehn oapm op tu, ahn lata Gaad peepl kohn bak tu laif. ");
INSERT INTO bzj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Dehn kom owta dehn grayv, ahn afta Jeezas rayz bak fahn di ded, dehn gaahn da Jeroosalem ahn apyaa tu lata peepl. ");
INSERT INTO bzj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Wen di aami aafisa ahn dehn wan weh mi-di gyaad Jeezas si di ertwayk ahn aal weh mi-di hapm, dehn mi fraitn bad ahn dehn seh, “Dis man da-mi Gaad Son fi chroo!” ");
INSERT INTO bzj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Lata laydi mi dehdeh di luk aan fahn faar. Dehn mi fala Jeezas soh dat dehn kuda mi ten tu ahn. Som a di laydi dehn da-mi Mayri Magdaleen ahn Mayri weh da-mi Jaymz ahn Joazef ma, ahn Zebidee son dehn ma. ");
INSERT INTO bzj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Now wahn rich man fahn Arimateeya kohn wen da mi eevnin. Hihn mi nayhn Joazef ahn ih da-mi wan a Jeezas falowa dehn. ");
INSERT INTO bzj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wel, hihn gaahn da Pailat gaahn aks fi Jeezas badi, ahn soh Pailat gi aadaz fi mek dehn gi ahn. ");
INSERT INTO bzj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joazef tek di badi ahn rap it op eena sohn kleen linin klaat. ");
INSERT INTO bzj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ih put it fi lidong eena fi hihn oan nyoo toom weh ih mi dig owta wahn raki hil. Ahn den ih tek wahn big big stoan ahn roal it fronta di hoal, ahn den ih gaan. ");
INSERT INTO bzj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mayri Magdaleen ahn di ada Mayri mi-di sidong pahn di neks said a di toom. ");
INSERT INTO bzj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Now di neks day, weh da-mi di Sabat, di cheef prees ahn di Farisee dehn gaahn da Pailat ahn seh, “Sa, wee jos memba weh da laiyad wan mi seh wen ih mi stil livin. Ih mi seh, ‘Afta chree dayz Ah wahn rayz op bak fahn di ded.’ ");
INSERT INTO bzj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Soh aada dehn fi wach di grayv til di chree dayz op; da way deh yu ku stap di disaipl dehn fahn kohn teef ih badi ahn goh tel di peepl dehn dat ih rayz op bak fahn di ded. If dat hapm, den dis laas lai wahn wosa dan di fos wan.” ");
INSERT INTO bzj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat tel dehn seh, “Tek sohn soalja ahn mek dehn gyaad di toom az gud az dehn ku gyaad it.” ");
INSERT INTO bzj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Soh dehn gaahn da di toom ahn seel it op tait, ahn dehn lef sohn soalja fi gyaad it. ");
INSERT INTO bzj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Soon da Sondeh maanin, wen di Sabat mi don, Mayri Magdaleen ahn di neks Mayri gaahn fi luk pahn di toom. ");
INSERT INTO bzj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sodn-wan di ert staat tu shayk haad-wan, ahn wahn aynjel fahn di Laad kohn dong fahn hevn ahn ih roal weh di stoan fahn fronta di toom ahn sidong pan it. ");
INSERT INTO bzj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ih fays mi brait laik laitnin ahn ih kloaz mi wait laik snoa. ");
INSERT INTO bzj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Di wachman dehn mi soh fraitn dat dehn staat tu chrimbl no miks ahn dehn jrap da grong sayhn laik dehn mi ded. ");
INSERT INTO bzj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Di aynjel tel di laydi dehn seh, “Noh frayd! Ai noa unu di luk fi Jeezas weh dehn mi kroosifai. ");
INSERT INTO bzj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","7","Hihn noh deh ya; hihn don rayz op bak fahn di ded, jos laik weh ih mi seh ih mi wahn du. Si, kohn luk wehpaa dehn mi put ih badi, den unu mikays ahn goh goh tel ih disaipl dehn seh, ‘Jeezas rayz op bak fahn di ded ahn ih gwehn heda unu da Gyalilee. Unu wahn si ahn deh.’ Dat da di mesij weh Ah ga fi unu.” ");
INSERT INTO bzj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Now di laydi dehn tek fut owta dehsoh; dehn mi fraitn ahn glad sayhn taim, ahn dehn ron fi gaahn tel ih disaipl dehn. ");
INSERT INTO bzj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sodn-wan Jeezas meet dehn ahn seh, “Heloa!” Ahn dehn kom op tu ahn, ahn hoal aan tu ih fut ahn wership ahn. ");
INSERT INTO bzj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Den Jeezas tel dehn seh, “Noh frayd; goh goh tel mi brada dehn fi goh da Gyalilee ahn dehn wahn si mi deh.” ");
INSERT INTO bzj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wail di laydi dehn mi deh pahn dehn way, som a di soalja dehn weh mi-di wach di grayv gaahn bak da di siti gaahn gaahn tel di cheef prees dehn evriting weh hapm. ");
INSERT INTO bzj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Di cheef prees dehn mi meet wid di Jooish leeda dehn ahn kom op wid wahn plan. Dehn gi di soalja dehn wahn hoal lata moni ahn tel dehn seh, “Tel di peepl dehn dat di disaipl dehn kohn ahn kehr Jeezas badi wen unu mi-di sleep. ");
INSERT INTO bzj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","If di govna hapm fi yehr bowt dis, wee wahn tek kayr a dat, ahn unu wahn aarait.” ");
INSERT INTO bzj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soh di soalja dehn tek di moni ahn dehn du weh di cheef prees dehn tel dehn fi du. Dehn stoari tek root monks wahn lata di Jooish peepl dehn, ahn dehn stil bileev it op tu tudeh day. ");
INSERT INTO bzj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Den di ilebm disaipl dehn gaahn da Gyalilee da di mongtin weh Jeezas mi tel dehn fi goh. ");
INSERT INTO bzj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Dehn si Jeezas deh ahn dehn wership ahn, bot som a dehn neva bileev. ");
INSERT INTO bzj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jeezas kohn tu dehn ahn tel dehn seh, “Gaad gi mee aal di atariti eena hevn ahn pahn ert; ");
INSERT INTO bzj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","soh unu goh ahn chrayn peepl fahn owta aala di nayshan dehn fi bee mi disaipl dehn. Baptaiz dehn eena di naym a di Faada, di Son ahn di Hoali Spirit, ");
INSERT INTO bzj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ahn teech dehn fi du evriting weh Ah tel unu. Ah wahn aalwayz deh wid unu eevn op tu di en a di werl.”");
INSERT INTO bzj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dis da di biginin a di Gud Nyooz bowt Jeezas Krais weh da Gaad Son. ");
INSERT INTO bzj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aizaiya di prafit mi rait seh dat Gaad mi seh, “Luk, Ah wahn sen mi mesinja heda yu. Hihn wahn mek shoar evriting redi fi yu.” ");
INSERT INTO bzj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Hihn da di vais weh di hala owt eena di dezert di seh, ‘Unu geh redi fi wen di Laad kohn, ahn mek di road dehn schrayt far ahn.’” ");
INSERT INTO bzj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Soh dis mesinja weh Gaad sen da-mi Jan di Baptis. Ih mi deh eena di dezert di baptaiz peepl ahn di tel evribadi, “Unu mos geh baptaiz fi shoa seh dat unu ton fahn unu sin dehn ahn dat Gaad fagiv unu.” ");
INSERT INTO bzj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Evribadi fahn Jeroosalem ahn fahn aal oava Judeeya dischrik mi-di goh owt tu wehpaa Jan mi deh. Ahn afta dehn don kanfes dehn sin dehn tu Gaad, Jan baptaiz dehn eena Jaadn Riva. ");
INSERT INTO bzj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Fi hihn kloaz mi mek owta kyamil hyaa, ahn ih mi gat aan wahn tik leda belt rong ih ways, ahn ih yoostu eet loakos ahn wail honi. ");
INSERT INTO bzj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ahn ih aal taim kip aan di seh, “Sohnbadi els wahn soon kohn weh moa powaful dahn mee. Lang saida hihn, Ai noh eevn gud nof fi stup dong ahn loos fi hihn shooz laysn. ");
INSERT INTO bzj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ai di baptaiz unu wid waata, bot hihn wahn baptaiz unu wid di Hoali Spirit.” ");
INSERT INTO bzj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Noh lang afta dat, Jeezas kohn fahn Nazaret Tong weh deh eena Gyalilee ahn mek Jan baptaiz ahn eena Jaadn Riva. ");
INSERT INTO bzj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Az ih mi-di kom op owta di waata, ih si hevn oapm op ahn di Hoali Spirit di kohn dong pan ahn jos laik how wahn dov wuda kohn dong. ");
INSERT INTO bzj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ahn sayhn taim, wahn vais fahn hevn seh, “Yoo da mi Son weh Ah oanli lov. Ah oanli pleez wid yu.” ");
INSERT INTO bzj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Schrayt fahn deh di Hoali Spirit mek Jeezas gaahn da di dezert, ");
INSERT INTO bzj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ahn ih stay deh faati dayz wail di devl neva play fi temp ahn fi sin. Oanli hihn wan ahn di wail animal dehn mi deh owt deh, ahn di aynjel dehn kohn kohn ten tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Afta dehn dash Jan di Baptis eena jayl, Jeezas gaahn da Gyalilee ahn staat tu preech di Gud Nyooz fahn Gaad. Dis da weh ih mi-di braadkyaas evriway ih goh: ");
INSERT INTO bzj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Di taim soon kohn fi Gaad set op ih kingdom, soh unu ton fahn unu sin dehn ahn bileev dis Gud Nyooz.” ");
INSERT INTO bzj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wahn day az Jeezas mi-di waak lang di waatasaid da Gyalilee, ih si Saiman ahn ih breda weh nayhn Anjru. Dehn mi-di chroa owt dehn fishin net eena di lagoon kaa dehn da-mi fishaman. ");
INSERT INTO bzj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jeezas hala tel dehn seh, “Unu kungoh lang wid mi, ahn insteda kech fish, Ah wahn mek unu kech peepl fi Gaad!” ");
INSERT INTO bzj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sayhn taim di too breda dehn jrap dehn net ahn gaahn lang wid Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wahn lee wayz ferda, Jeezas si Jaymz ahn Jan, weh da-mi Zebidee son dehn. Dehn mi-di sidong eena wahn boat di fiks dehn fishin net. ");
INSERT INTO bzj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ih kaal dehn tu, ahn sayhn taim dehn jomp op ahn lef dehn pa eena di boat wid di werkman dehn, ahn gaahn lang wid Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Dehn gaahn da wahn tong weh nayhn Kapernyam. Jeezas gaahn da di meetn plays pahn di Sabat ahn staat tu teech. ");
INSERT INTO bzj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Di krowd kudn bileev weh dehn mi-di yehr, sayka how ih mi-di teech dehn; kaa hihn neva hafu bara werd laik dehn wan weh teech di Laa. Hihn mi-di teech laik sohnbadi weh noa egzakli weh dehn mi-di taak bowt, ahn ga aal atariti fi seh it tu. ");
INSERT INTO bzj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Wahn man wid eevl spirit eena ahn mi dehdeh, ahn hihn staat tu hala seh, ");
INSERT INTO bzj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jeezas fahn Nazaret, da weh yoo waahn wid wee now? Ai noa hoo yoo! Yoo da di Hoali Wan weh kohn fahn Gaad!” ");
INSERT INTO bzj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jeezas koman di eevl spirit dehn shaap-wan seh, “Shet op! Kom owta ahn rait now!” ");
INSERT INTO bzj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Di eevl spirit dehn mek di man badi shayk op haad-wan, ahn dehn skreem owt, ahn den dehn kom owta ahn. ");
INSERT INTO bzj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wen dis hapm, di peepl dehn kudn bileev dehn aiy ahn dehn seh tu wan anada, “Da weh kaina nyoo teechin dis? Ahn pahn tap a dat, dis man teech wid atariti! Hihn eevn gi di eevl spirit dehn aadaz ahn dehn obay ahn!” ");
INSERT INTO bzj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Di nyooz bowt Jeezas spred faas-wan aal oava Gyalilee. ");
INSERT INTO bzj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Az soon az dehn lef di meetn plays, Jeezas, Jaymz ahn Jan gaahn da Saiman ahn Anjru hows. ");
INSERT INTO bzj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saiman mada-in-laa mi dehdeh sik eena bed wid wahn feeva, ahn dehn tel Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Soh Jeezas gaahn da ih bedsaid, ahn hoal ih han ahn help ahn fi sidong op. Di feeva gaan ahn di laydi staat tu ten tu dehn! ");
INSERT INTO bzj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Bai di taim daak set een da eevnin, peepl bring aala dehn wan weh mi sik ahn ga deeman tu Jeezas. Ih mi luk laik di hoal tong mi gyada owtsaid di luk aan. ");
INSERT INTO bzj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Soh Jeezas heel wahn lata peepl weh mi ga lata difrent kaina dizeez, ahn ih jraiv owt lata deeman owta peepl tu. Bot ih wudn alow di deeman dehn fi seh notn bikaa dehn mi wel ahn noa da hoo hihn. ");
INSERT INTO bzj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Soon soon di neks maanin Jeezas get op bifoa di son mi kom op ahn lef di hows ahn gaan aaf da wahn kwaiyet plays gaahn pray. ");
INSERT INTO bzj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Layta Saiman ahn di res a dehn gaahn luk far ahn, ");
INSERT INTO bzj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ahn wen dehn fain ahn, dehn tel ahn seh, “Evribadi di luk fi yu.” ");
INSERT INTO bzj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jeezas ansa seh, “Mek wi goh da di neks tong dehn soh dat Ah ku preech tu dehn tu. Dat da weh Ai kohn fi du.” ");
INSERT INTO bzj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Soh Jeezas chravl aal oava Gyalilee di preech eena dehn meetn plays dehn ahn di jraiv owt deeman. ");
INSERT INTO bzj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wahn taim, wahn man weh mi ga leprosi kohn tu Jeezas ahn jrap dong pahn ih nee fronta ahn, ahn bayg ahn seh, “Sa, if yoo waahn, yoo ku heel mi.” ");
INSERT INTO bzj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ahn Jeezas mi soh sari far ahn, ih schrech owt ih han ahn toch di man ahn seh, “Yes, man, Ah waahn heel yu. Yu heel!” ");
INSERT INTO bzj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Az Jeezas seh dat, di man geh heel ahn di leprosi disapyaa. ");
INSERT INTO bzj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sayhn taim Jeezas sen ahn weh ahn waan ahn gud seh, ");
INSERT INTO bzj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Si dat yu noh seh notn tu nobadi bowt dis; bot goh schrayt da di prees mek ih chek yu mek ih si dat yu heel fi chroo. Den goh goh aafa di sakrifais weh Moaziz Laa seh yu fi aafa, fi shoa evribadi dat yu geh heel.” ");
INSERT INTO bzj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bot di man gaan aal bowt di braadkyaas tu evribadi how Jeezas heel ahn. Sayka dat, Jeezas kudn goh eena non a di tong dehn ahn mek peepl si ahn. Soh ih stay weh fahn di tong dehn, bot peepl stil fain ahn, ahn kohn tu ahn fahn aal bowt. ");
INSERT INTO bzj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jeezas gaahn bak da Kapernyam sohn dayz layta, ahn di peepl dehn yehr seh ih mi deh hoahn. ");
INSERT INTO bzj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","3","Soh moch peepl mi pak op eena di hows dat no spays neva deh fi hoal evribadi, noh eevn fronta di doa. Jeezas mi-di preech di Gud Nyooz tu dehn wen sohn man kohn ahn bring wahn paralaiz man tu ahn; foa a dehn mi-di bak ahn pahn wahn schrecha, ");
INSERT INTO bzj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","bot dehn kudn reech Jeezas sayka di krowd. Soh dehn gaan op ahn mek wahn hoal eena di howstap rait oava wichpaa Jeezas mi-di stan op, ahn wen di hoal mi big nof, dehn loar di man dong pahn di schrecha. ");
INSERT INTO bzj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wen Jeezas si humoch fayt dehn mi ga eena ahn, ih seh tu di paralaiz man, “Son, Ah fagiv yu sin dehn.” ");
INSERT INTO bzj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Now som a dehn teecha a di Jooish Laa mi-di sidong deh ahn dehn seh tu dehnself, ");
INSERT INTO bzj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Da weh du dis man? Hihn di play Gaad! Oanli Gaad ku fagiv sin!” ");
INSERT INTO bzj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kwik az dat, Jeezas mi don noa weh dehn mi-di tink eena dehn haat, soh ih aks dehn seh, “Da weh unu di tink dehn kaina ting fa? ");
INSERT INTO bzj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wich wan eeziya fi seh tu dis man weh paralaiz, ‘Ah fagiv yu sin dehn,’ er ‘Get op, pik op yu schrecha ahn waak?’ ");
INSERT INTO bzj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ai ga atariti fi fagiv sin pahn ert ya. Bot fi jos seh dat noh proov notn, soh Ah wahn shoa unu an Ah wahn heel di man.” Den Jeezas ton tu di man weh mi paralaiz ahn tel ahn seh, ");
INSERT INTO bzj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Pik op yu schrecha ahn goh hoahn.” ");
INSERT INTO bzj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Di man get op ahn pik op ih schrecha rait fronta aala dehn ahn waak gaan. Di peepl dehn kudn bileev dehn aiy ahn dehn staat tu prayz Gaad ahn seh, “Wi neva si notn laik dis yet eena wi hoal laif!” ");
INSERT INTO bzj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Den Jeezas gaan owt da di waatafront agen ahn staat tu teech di krowd weh mi gyada rong. ");
INSERT INTO bzj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Az ih mi-di waak lang ih si Leevai, Alfyos son, di sidong eena di kostom boot di kalek taks. Jeezas tel ahn seh, “Kohn kohn bee wan a mi disaipl dehn.” Ahn Leevai get op ahn gaahn wid Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Layta Jeezas ahn ih disaipl dehn mi-di eet da Leevai hows, ahn wahn lata taks kalekta ahn ada wan wid bad repyutayshan kohn kohn eet wid dehn. Lata dehn kaina peepl yoostu aalwayz di fala Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bot wen som a di teecha a di Laa, weh da-mi Farisee tu, si ahn di eet wid dehndeh peepl, dehn seh tu ih disaipl dehn, “Da how hihn stan fi eet wid taks kalekta ahn dehn kaina peepl?” ");
INSERT INTO bzj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Wen Jeezas yehr weh dehn mi-di seh, ih tel dehn seh, “Da sik peepl weh need dakta, ahn noh dehn wan weh helti. Ai kohn fi kaal sinaz fi ton fahn dehn sin dehn, noh dehn wan weh tink seh dehn don rait wid Gaad.” ");
INSERT INTO bzj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Now di Farisee dehn ahn dehn wan weh fala Jan mi-di faas ahn pray; ahn sohn peepl kohn kohn aks Jeezas seh, “Da wai dehn wan weh fala Jan ahn dehn wan weh fala di Farisee dehn aal taim faas ahn pray ahn fi yoo disaipl dehn noh faas ataal?” ");
INSERT INTO bzj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jeezas ansa seh, “Unu tink seh di groom fren dehn wahn goh widowt food wail hihn stil deh wid dehn? No, man! Dehn noh wahn du dat az lang az hihn deh wid dehn. ");
INSERT INTO bzj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bot di taim wahn kohn wen dehn wahn tek weh di groom fahn dehn, ahn dat da wen dehn wahn faas. ");
INSERT INTO bzj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wen yu di pach oal kloaz, ih noh mek sens fi yooz klaat weh noh schrink yet fi pach di hoal wid, kaa di nyoo pees a klaat wahn jos schrink ahn pap weh fahn di kloaz weh yu di pach. Ahn den di hoal wahn en op wosa aaf dan how ih mi stan fos. ");
INSERT INTO bzj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Rait soh, nobadi wahn put wain weh jos don mek eena oal leda wain bag. If dehn du dat, di nyoo wain wahn bos di oal wain bag, ahn aala di wain wahn chroh-weh ahn di wain bag wahn kandem. Yu wel ahn noa seh yu hafu put nyoo wain eena nyoo wain bag.” ");
INSERT INTO bzj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wahn day wen da mi di Sabat, Jeezas ahn ih disaipl dehn mi-di paas chroo sohn weet feel. Ih disaipl dehn pap aaf di tap a som a di weet az dehn mi-di goh lang. ");
INSERT INTO bzj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Di Farisee dehn aks Jeezas seh, “Luk deh! Da wai dehn di du ting weh deh gens di Laa pahn di Sabat?” ");
INSERT INTO bzj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jeezas ansa seh, “Unu neva reed weh Dayvid ahn ih kompni dehn mi du wen dehn mi hongri ahn neva ga notn fi eet noh? ");
INSERT INTO bzj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ih gaan eena di hows a Gaad wen Abitar da-mi di hai prees ahn ih tek ahn eet di hoali bred weh, akaadn tu di Laa, oanli di prees dehn mi sopoas tu eet; ahn ih gi ih man dehn sohn fi eet tu. ");
INSERT INTO bzj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Gaad neva mek di Sabat fi mek ih bee wahn berdn pahn peepl, bot fos ih mek peepl ahn den ih gi dehn di Sabat soh dat dehn ku ga wahn day fi res fahn dehn werk. ");
INSERT INTO bzj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Soh dats wai di Son a Man eevn ga atariti fi seh weh rait fi peepl du er kyaahn du pahn di Sabat.” ");
INSERT INTO bzj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wahn neks taim Jeezas gaan eena di meetn plays, ahn wahn man weh mi ga wahn kripl han mi dehdeh. ");
INSERT INTO bzj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Dehn mi ga sohn peepl weh mi-di luk fi wahn reezn fi akyooz Jeezas, soh dehn mi-di wach ahn haad fi si if ih mi wahn heel di man pahn di Sabat. ");
INSERT INTO bzj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jeezas seh tu di man wid di kripl han, “Kohn ya. Kohn stan op fronta evribadi.” ");
INSERT INTO bzj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Den ih ton rong ahn aks dehn seh, “Di Laa alow wi fi du gud er fi du bad pahn di Sabat? Ih alow wi fi sayv laif er fi kil?” Bot nobadi neva seh notn. ");
INSERT INTO bzj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jeezas luk rong pahn di peepl dehn. Ih mi beks wid dehn bot ih mi feel sad fi si how haad dehn haat mi haad. Soh ih seh tu di man, “Schrech owt yu han.” Di man schrech owt ih han ahn ih han kohn bak gud gud-wan! ");
INSERT INTO bzj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Den di Farisee dehn lef ahn gaahn gaahn plan wid King Herod peepl dehn how dehn mi wahn kil Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Meentaim, Jeezas ahn ih disaipl dehn gaan aaf bai di lagoon, bot wen nyooz staat tu spred bowt weh aal Jeezas mi-di du, wahn hoal krowd a peepl staat tu fala dehn. Dehn neva oanli kohn fahn Gyalilee, bot dehn kohn fahn Judeeya dischrik ahn Jeroosalem, ahn fahn Idumeeya, ahn fahn di ada said a Jaadn Riva, ahn fahn Taiya ahn Saidan. ");
INSERT INTO bzj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ih tel ih disaipl dehn fi ga wahn boat redi, jos in kays di krowd geh tu tik fi dehn handl, ");
INSERT INTO bzj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","bikaa lata peepl mi geh heel da day, ahn moa ahn moa sik peepl mi-di shub dehn way chroo di krowd fi chrai toch ahn. ");
INSERT INTO bzj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ahn enitaim dehn eevl spirit weh mi deh eena sohn peepl set aiy pan ahn, dehn jrap dong fronta ahn di hala ahn skreem owt, “Yoo da Gaad Son!” ");
INSERT INTO bzj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ih gi dehn schrik aadaz noh fi tel nobadi bowt ahn. ");
INSERT INTO bzj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Den aftawodz Jeezas gaan op pahn wahn mongtin ahn kaal aala dehn wan weh ih mi waahn fi kohn tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Ih pik owt twelv fahn monks dehn fi bee ih apasl dehn. Dehn mi fi goh rong wid ahn aal di taim. Ih gi dehn powa fi preech ahn jraiv owt deeman. ");
INSERT INTO bzj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Dehnya da dehn naym: Saiman (hoofa naym Jeezas mi chaynj tu Peeta); ahn Jaymz ahn Jan, weh da-mi Zebidee son dehn (Jeezas kaal dehn Bowanajeez, weh meen “Sonz a Tonda”). Den yu mi ga Anjru ahn Filip ahn Bartalamyoo; Machyu, Tamas, ahn Jaymz, weh da-mi Alfyos son; ahn den Tadyos ahn Saiman, weh mi bilangz tu di Zelat Paati, ahn Joodas Iskariyat, weh mi sel owt Jeezas aftawodz. ");
INSERT INTO bzj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Wen Jeezas gaahn bak da di hows weh ih mi-di stay, di krowd flak ahn agen soh dat hihn ahn ih disaipl dehn neva eevn ga wahn chaans fi eet. ");
INSERT INTO bzj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wen ih famili dehn yehr weh mi-di hapm, dehn kohn fi kehr ahn hoahn kaa peepl mi-di seh, “Ih noh soh karek eena ih hed.” ");
INSERT INTO bzj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bot som a di teecha a di Laa weh mi kohn dong fahn Jeroosalem seh, “Da Biyelzibob, weh da di hed a di deeman dehn, di kanchroal hihn. Dats wai ih ku jraiv owt deeman.” ");
INSERT INTO bzj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jeezas kaal di peepl dehn tugeda ahn ih staat taak tu dehn eena parablz. Ih seh, “How Saytan ku jraiv owt Saytan? ");
INSERT INTO bzj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","If di peepl dehn da wahn konchri di fait gens wan anada, dehn noh wahn mek it. ");
INSERT INTO bzj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","If wahn famili di fait gens wan anada, dehn noh wahn mek it. ");
INSERT INTO bzj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ahn if Saytan di jraiv owt fi hihn oan deeman dehn, den fi hihn kingdom noh wahn mek it ahn ih wahn soon finish aaf ihself. ");
INSERT INTO bzj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yoo tink seh yu ku jos goh eena di hows a sohnbadi weh schrang laik Saytan ahn tek weh dehn ting dehn? No. Yu hafu tai dehn op fos. Den yu ku tek dehn weh. ");
INSERT INTO bzj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ah di tel unu di chroot, Gaad wahn fagiv eni sinful ting weh enibadi du er seh, noh kay how bad ih bad. ");
INSERT INTO bzj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bot Gaad wahn neva fagiv nobadi weh taak gens di Hoali Spirit. Dat wahn geh hoal gens dehn fareva.” ");
INSERT INTO bzj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ih tel dehn dat bikaa dehn mi-di seh dat da Saytan gi ahn di powa fi du di mirakl dehn. ");
INSERT INTO bzj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Den Jeezas ma ahn ih breda dehn kohn. Dehn mi-di stan op owtsaid, ahn dehn sen sohnbadi fi kaal ahn. ");
INSERT INTO bzj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wahn krowd mi-di sidong rong ahn, ahn dehn tel ahn seh, “Yu ma ahn yu breda dehn deh owtsaid di luk fi yu.” ");
INSERT INTO bzj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jeezas aks dehn seh, “Hoo da mi ma? Hoo da mi breda dehn?” ");
INSERT INTO bzj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Den ih luk pahn dehn wan weh mi-di sidong rong ahn, ahn ih seh, “Si mi ma ahn mi breda dehn rait ya. ");
INSERT INTO bzj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Enibadi weh du weh Gaad waahn da mi breda, ahn mi sista, ahn mi ma.” ");
INSERT INTO bzj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wahn neks taim Jeezas staat tu teech bai di lagoon, ahn di krowd weh mi gyada rong ahn mi soh big dat hihn mi hafu get eena wahn boat ahn sidong een deh wail di hoal krowd mi deh bai di waatasaid pahn shoa. ");
INSERT INTO bzj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Den ih yooz sohn lee stoari fi teech dehn lata tingz. Ih seh, ");
INSERT INTO bzj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Lisn ya, wahn faama gaahn gaahn plaant sohn seed. ");
INSERT INTO bzj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wail ih mi-di skyata di seed dehn, sohn jrap pahn di lee pikaado road ahn berd kohn ahn eet dehn op. ");
INSERT INTO bzj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Den som a di seed dehn jrap pahn grong weh mi raki, ahn oanli lee bit a ert mi dehdeh, soh di seed dehn sprowt op kwik-wan. ");
INSERT INTO bzj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bot wen di son kom op, ih bon op di plaant dehn, ahn laik how oanli lee bit a ert mi dehdeh, dehn neva tek root gud, soh dehn wida weh. ");
INSERT INTO bzj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Sohn ada seed jrap monks sohn prikl bush, ahn di prikl bush groa op ahn choak di plaant dehn, soh dehn neva bayr notn. ");
INSERT INTO bzj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Now sohn neks seed jrap pahn gud grong. Dehn kom op ahn groa big ahn bayr gud gud. Sohn bayr terti taim moa dahn weh di faama mi plaant, sohn bayr siksti taim moa, ahn sohn bayr wahn honjrid taim moa.” ");
INSERT INTO bzj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Den Jeezas seh, “Eni a unu weh ga ayz fi yehr, unu lisn gud!” ");
INSERT INTO bzj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wen Jeezas mi deh bai ihself, ih twelv disaipl dehn ahn sohn peepl weh mi deh rong kohn kohn aks ahn bowt di lee stoari dehn. ");
INSERT INTO bzj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jeezas seh, “Gaad pik unu fi noa di seekrit bowt fi hihn kingdom, bot fi ada peepl Ah tel dehn evriting eena parabl ");
INSERT INTO bzj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","soh dat, ‘Dehn wahn luk, bot dehn noh wahn si. Dehn wahn yehr, bot dehn noh wahn andastan. Adawaiz dehn wuda ton rong dehn laif ahn geh fagivnis.’” ");
INSERT INTO bzj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Den Jeezas tel dehn seh, “If disya simpl lee stoari pozl unu, den how unu wahn andastan aal di res? ");
INSERT INTO bzj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Di faama da laik enibadi weh spred di Werd a Gaad. ");
INSERT INTO bzj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sohn peepl da laik wen di seed jrap pahn di lee pikaado road; wen dehn yehr di Werd a Gaad, di devl kohn sayhn taim ahn tek weh di Werd a Gaad weh mi plaant eena dehn haat. ");
INSERT INTO bzj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ahn sayhn way dehn seed weh jrap pahn grong weh raki stan fi dehn wan weh yehr di Werd a Gaad ahn dehn oanli tu hapi fi aksep di mesij rait away, ");
INSERT INTO bzj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","bot di seed neva tek no root eena dehn haat. Dehn stik it owt fi wahn lee wail, bot wen lee chroblz ahn chraiyalz kohn sayka weh dehn bileev di mesij, dehn jrap weh kwik-taim. ");
INSERT INTO bzj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Dehn wan weh jrap monks di prikl bush dehn stan fi dehn wan weh yehr di Werd a Gaad, ");
INSERT INTO bzj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bot di woriz a laif ahn sayka weh dehn waahn geh rich soh bad, ahn sayka weh dehn red dehn aiy pahn soh moch ada ting, dehn mek di mesij geh choak owta dehn, ahn notn gud kyaahn kom owta dehn laif. ");
INSERT INTO bzj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Now dehn seed weh jrap pahn di gud grong stan fi dehn peepl weh yehr di Werd a Gaad ahn aksep it. Dehn da di wan dehn weh bayr lata froot—gud ting kom owta dehn laif, jos laik how di faama geh terti, ahn siksti, ahn honjrid taim moa dahn weh ih mi plaant.” ");
INSERT INTO bzj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Den ih aks dehn seh, “Wen sohnbadi lait wahn lamp, dehn noh put it anda wahn bowl er anda di bed, rait? No. Insteda dat, dehn put it hai op pahn wahn stan. ");
INSERT INTO bzj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ahn soh evriting weh da seekrit wahn kom owt playn playn-wan, ahn evriting weh deh anda kova wahn geh bring owt eena di oapm. ");
INSERT INTO bzj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Eni a unu weh ga ayz fi yehr, unu lisn gud! ");
INSERT INTO bzj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Tink gud bowt weh unu yehr. Kaa di sayhn way how yu gi, dat da how yu wahn geh bak, ahn eevn moa. ");
INSERT INTO bzj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Evribadi weh don ga wahn geh moa, bot fi dehn wan weh noh ga notn, eevn di lee bit weh dehn ga wahn geh tek weh fahn dehn.” ");
INSERT INTO bzj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Den Jeezas seh, “Gaad kingdom da laik wahn faama weh plaant owt ih plantayshan ahn lef it ahn gaahn luk bowt ada bizniz. Meenwail di plaant dehn kom op priti widowt nobadi ten tu dehn. ");
INSERT INTO bzj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Di seed dehn stay rait deh eena di grong ahn sprowt. Fos, di lee shoot bos owt, den di hed groa, ahn den di grayn divelop pahn di hed. ");
INSERT INTO bzj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Az soon az ih geh raip, di faama kohn ahn reep ih krap.” ");
INSERT INTO bzj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Den Jeezas seh, “Weh deh weh Ah ku tel unu Gaad kingdom stan laik? Er weh parabl Ah ku yooz? ");
INSERT INTO bzj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Da laik wahn lee kungku mostad seed weh da di smaalis seed weh yu plaant eena di grong. ");
INSERT INTO bzj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bot wen dehn don plaant it, ih ton intu di bigis gyaadn plaant weh yu ku fain, ahn di branch dehn geh soh big dat di berd dehn eena di skai kohn kohn mek nes eena ih shayd.” ");
INSERT INTO bzj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jeezas yooz lata lee stoari laik dat fi teech di peepl dehn az moch az dehn mi redi fi yehr it. ");
INSERT INTO bzj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ih neva tel dehn notn widowt yooz parablz, bot aftawodz, wen hihn ahn ih oan disaipl dehn mi deh bai dehnself, den ih eksplayn evriting tu dehn. ");
INSERT INTO bzj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Az eevnin mi-di set een, Jeezas tel ih disaipl dehn seh, “Mek wi goh kraas da di neks said a di lagoon.” ");
INSERT INTO bzj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Soh dehn pik op sayhn taim, ahn wid wahn fyoo moa boat di fala, lef di krowd bihain, ahn staat tu goh kraas di lagoon. ");
INSERT INTO bzj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wahn bad skwaal kohn pahn di lagoon ahn di wayv dehn staat wash oava di boat til ih mi nayli ful op wid waata. ");
INSERT INTO bzj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Aal di taim Jeezas mi-di sleep komfatabl-wan da baka di boat wid ih hed pahn wahn kushn. Di disaipl dehn wayk ahn op ahn seh tu ahn, “Teecha, wi deh ya di jrongdid, ahn yoo noh kay?” ");
INSERT INTO bzj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ih get op ahn taak shaap-wan tu di breez ahn di wayv dehn seh, “Unu kwaiyet dong!” Rait den di breez stap bloa ahn evriting geh kyaam kyaam. ");
INSERT INTO bzj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ahn ih aks dehn seh, “Da weh mek unu mi soh fraitn? Unu stil noh chros mi yet?” ");
INSERT INTO bzj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dehn mi oanli fraitn bad ahn aks wan anada, “Da hoo dis man? Dong tu di breez ahn di waata obay hihn!” ");
INSERT INTO bzj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Dehn reech kraas di neks said a di lagoon wichpaa di Jeraseen peepl dehn liv. Sayhn taim wen Jeezas mi-di get owta di boat, wahn man weh mi ga eevl spirit eena ahn kom owta di bering grong kohn kohn meet ahn. ");
INSERT INTO bzj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Dis man yoostu liv eena di bering grong ahn ih mi soh owta kanchroal dat nobadi neva deh weh kuda tai ahn op, noh eevn wid chayn. ");
INSERT INTO bzj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kaa lata taim dehn wuda chayn op ih han dehn ahn put aiyan ban rong ih fut dehn, bot ih wuda jos bos op di chayn dehn ahn brok op di aiyan ban dehn eena peesiz. Nobadi neva schrang nof fi hoal ahn dong. ");
INSERT INTO bzj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aal owaz a di day ahn nait ih yoostu wanda bowt monks di grayv dehn ahn ron wail eena di hil dehn, di baal owt ahn kot op ihself wid shaap stoan. ");
INSERT INTO bzj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wen ih sait Jeezas fahn faar, ih ron kohn chroa ihself dong fronta ahn. ");
INSERT INTO bzj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Den di eevl spirit hala haad-wan pahn tap a ih vais, “Jeezas, weh da di Son a di moas hai Gaad, da weh yoo waahn wid mee? Ah bayg yu pleez, fi Gaad sayk, noh taacha mi!” ");
INSERT INTO bzj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ih seh dat kaa Jeezas mi seh tu ahn, “Yoo eevl spirit, kom owta dis man!” ");
INSERT INTO bzj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jeezas aks ahn seh, “Da weh yoo nayhn?” Ih ansa seh, “Mee nayhn Leejan kaa lata wee liv eena dis man.” ");
INSERT INTO bzj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Den di eevl spirit dehn bayg ahn oava ahn oava noh fi sen dehn sohnweh faar fahn deh. ");
INSERT INTO bzj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Now, wahn lata pig mi-di feed pahn di hilsaid bai di lagoon da sayhn taim deh, ");
INSERT INTO bzj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ahn di deeman dehn bayg Jeezas seh, “Pleez sen wi eena dehn pig deh noh?” ");
INSERT INTO bzj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jeezas tel dehn dehn ku goh, ahn di deeman dehn kom owta di man ahn gaan eena di pig dehn, ahn di hoal bonch a dehn, bowt too towzn, rosh dong di said a di hil weh mi wel ahn hai, ahn aala dehn jrap eena di lagoon ahn jrongdid. ");
INSERT INTO bzj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Di man dehn weh mi-di main di pig dehn ron gaahn tel evribadi eena di tong ahn aal oava di konchrisaid weh mi hapm, ahn soh evribadi ron kohn si fi dehnself. ");
INSERT INTO bzj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Wen dehn gaahn da Jeezas, dehn fain di man weh mi ga aala dehn eevl spirit eena ahn rait deh di sidong. Wen dehn si dat ih mi gat aan kloaz, ahn ih mi ga ih gud gud sens, dehn geh frayd. ");
INSERT INTO bzj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dehn wan weh mi si how di hoal ting mi hapm tel evribadi how di man weh mi ga di eevl spirit dehn mi geh kyoar, ahn dehn tel dehn bowt weh mi hapm tu di pig dehn tu. ");
INSERT INTO bzj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Den di krowd staat tu bayg Jeezas fi lef fahn fi dehn dischrik. ");
INSERT INTO bzj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Soh Jeezas get bak eena di boat fi goh. Di man weh Jeezas mi jos jraiv owt di eevl spirit dehn owta bayg ahn fi mek ih goh lang wid ahn. ");
INSERT INTO bzj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bot Jeezas seh, “No, Ah waahn yu goh bak tu yu faamli ahn tel dehn aala di gud ting dehn weh di Laad du fi yu ahn how ih ga mersi pahn yu.” ");
INSERT INTO bzj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Soh di man lef ahn gaahn da di ayrya weh nayhn Dekapolis ahn tel evribadi aal weh Jeezas mi du far ahn, ahn di peepl dehn kuda mi skaysli bileev it. ");
INSERT INTO bzj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wen Jeezas gaahn bak kraas di ada said a di lagoon eena di boat, wahn big krowd gyada rong ahn bai di waatasaid. ");
INSERT INTO bzj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Den wahn man weh mi nayhn Jairos, weh da-mi di hed a di sinagag deh, kohn. Wen ih si Jeezas, ih chroa ihself da ih fut ahn bayg ahn haad seh, “Mi lee daata deh pahn daiyin. Pleez kohn put yu han pan ahn soh dat ih ku geh beta ahn noh ded.” ");
INSERT INTO bzj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Soh Jeezas gaahn wid ahn. Ahn wahn lata peepl mi-di fala ahn, ahn dehn mi-di krowd een pan ahn. ");
INSERT INTO bzj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wahn laydi weh mi-di chrobl wid hemrij fi twelv yaaz mi deh eena di krowd. ");
INSERT INTO bzj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Shee mi deh fahn dakta tu dakta di chrai geh beta til aal ih moni don, ahn insteda geh beta ih jos geh wos. ");
INSERT INTO bzj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Shee mi geh fi yehr bowt Jeezas. Ahn soh ih kom op bihain Jeezas eena di krowd ahn toch ih kloaz, ");
INSERT INTO bzj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","sayka weh ih seh tu ihself, “If Ah kuda eevn jos toch fi hihn kloaz, Ah wahn geh heel.” ");
INSERT INTO bzj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ahn sayhn taim di bleedn stap, ahn ih mi noa seh eena ih oan badi dat shee neva sik agen. ");
INSERT INTO bzj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Az ih hapm, Jeezas riyalaiz seh powa gaan owta ahn, soh ih luk rong ahn ih aks, “Hoo toch mi kloaz?” ");
INSERT INTO bzj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Di disaipl dehn seh, “Wid aala dis krowd di shub op gens yu, how yoo ku aks da hoo toch yu?” ");
INSERT INTO bzj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bot Jeezas stodi mi-di luk rong fi si da hoo mi toch ahn. ");
INSERT INTO bzj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Di laydi mi ful wel noa weh mi hapm tu ahn, soh ih kohn di chrimbl ahn chroa ihself da Jeezas fut ahn tel ahn di chroot bowt evriting weh ih du. ");
INSERT INTO bzj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jeezas tel ahn seh, “Daata, sayka yu fayt, yu geh heel. Goh ahn noh wori bowt notn. Yu free fahn yu sofarin now.” ");
INSERT INTO bzj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wail Jeezas stil mi-di taak tu di laydi, sohn man fahn Jairos hows kohn ahn seh, “Yu daata don ded, soh noh bada di teecha agen.” ");
INSERT INTO bzj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bot Jeezas neva stodi dehn; ih tel Jairos seh, “Noh wori, jos ga fayt.” ");
INSERT INTO bzj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","38","Den Jeezas neva mek nobadi gaahn wid ahn eksep Peeta ahn Jaymz, ahn Jaymz breda weh nayhn Jan. Wen dehn reech Jairos hows, wahn lata komoashan mi deh. Peepl di moan ahn baal kyaahn don! ");
INSERT INTO bzj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Soh ih gaan eensaid ahn aks dehn seh, “Wai aala dis moanin ahn kraiyin? Di lee gyal noh ded; ih oanli di sleep!” ");
INSERT INTO bzj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wen Jeezas seh dat, dehn staat tu laaf aata ahn. Ih ron aala dehn owta di hows, den ih kehr di lee gyal ma ahn pa, ahn di chree disaipl dehn lang wid ahn eena di room weh di lee gyal mi lay owt. ");
INSERT INTO bzj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Den Jeezas hoal di lee gyal bai ih han ahn ih seh tu ahn, “Talita Kumi.” Dat meen “Lee gyal, get op!” ");
INSERT INTO bzj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Rait away di gyal get op ahn staat tu waak rong! Ih mi twelv yaaz oal. Ih pa ahn ih ma kuda haadli bileev dehn aiy. ");
INSERT INTO bzj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jeezas gi dehn schrik aadaz noh fi tel nobadi bowt it, ahn ih tel dehn fi gi di lee gyal sohnting fi eet. ");
INSERT INTO bzj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Den Jeezas lef fahn Gyalilee ahn gaahn bak da ih hoamtong, ahn ih disaipl dehn gaahn lang wid ahn. ");
INSERT INTO bzj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Den ih gaahn da di meetn plays pahn di Sabat ahn staat tu teech. Wahn lata peepl kudn bileev dehn ayz wen dehn yehr weh ih mi-di seh. Dehn aks wan anada seh, “Da weh dis man geh dehnya ting fram? Da weh hihn geh soh moch wizdom fram weh hihn ku du mirakl anaal? ");
INSERT INTO bzj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Dis da noh di kyapmta? Dis da noh Mayri son? Ahn Jaymz, Joazef ahn Saiman ahn Joodas da noh fi hihn breda dehn? Ahn ih sista dehn noh deh rait ya wid wi?” Ahn dehn mi kwait ofendid sayka Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Soh Jeezas tel dehn seh, “Da oanli da ih oan hoamtong, monks ih oan peepl dehn, ahn eena ih oan hows wahn prafit noh geh no rispek.” ");
INSERT INTO bzj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ih kudn du no mirakl deh, eksep heel wan ahn too sik peepl weh ih lay ih han pan. ");
INSERT INTO bzj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ahn Jeezas mi sopraiz how di peepl dehn deh neva ga no fayt. Den ih gaan owt eena da ayrya di teech fahn vilij tu vilij. ");
INSERT INTO bzj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ih kaal ih twelv disaipl dehn tu ahn, ahn ih gi dehn powa oava di eevl spirit dehn. Den ih sen dehn owt too-bai-too. ");
INSERT INTO bzj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Dis da weh ih tel dehn fi du: “Unu noh fi kehr notn pahn di jerni eksep unu waakin stik. Ahn noh kehr notn fi eet, er no kitbag, ahn noh kehr no moni eena unu ways bag needa. ");
INSERT INTO bzj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Unu ku wayr sandalz, bot noh kehr no ekschra kloaz. ");
INSERT INTO bzj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Eni hows weh dehn welkom unu eena fi stay, stay deh til unu redi fi lef da tong deh. ");
INSERT INTO bzj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ahn if di peepl dehn da eni vilij shoa unu bad fays, er if dehn noh waahn yehr weh unu ga fi seh, den wen unu di lef fahn deh, unu mos shayk aaf di dos fahn aafa unu fut az wahn sain gens dehn.” ");
INSERT INTO bzj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Soh di disaipl dehn gaan owt gaahn tel evribadi fi ton fahn dehn sin dehn. ");
INSERT INTO bzj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Dehn jraiv owt deeman owta peepl, ahn put aliv ail pahn wahn lata sik peepl ahn heel dehn. ");
INSERT INTO bzj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Now nyooz bowt Jeezas get eena King Herod ayz kaa evriway yu ton, peepl mi-di taak bowt ahn. Sohn peepl mi-di seh, “Dis da Jan di Baptis weh rayz op bak fahn di ded. Dats wai ih ku du aala dehn mirakl ahn soh.” ");
INSERT INTO bzj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Sohn ada wan seh, “Hihn da Ilaija.” Ahn stil sohn neks wan mi-di seh, “Hihn da wahn prafit jos laik wan a di ada oal taim prafit dehn.” ");
INSERT INTO bzj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bot wen Herod yehr aala dis, ih seh, “Dis da di sayhn Jan di Baptis hoofa hed Ah mi chap aaf. Ahn now ih rayz op bak fahn di ded fi chroo!” ");
INSERT INTO bzj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yu si, Herod seh dat kaa hihn mi marid tu Heroadyas, weh da-mi ih breda Filip waif. Jan mi tel ahn seh ih neva rait fi mek ih marid tu ih breda waif. Soh sayka pleez Heroadyas, Herod mi ares Jan ahn mek dehn tai ahn op ahn put ahn eena jayl. ");
INSERT INTO bzj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jan mi-di tel Herod seh, “Ih gens di laa fi mek yu marid tu yu breda waif.” ");
INSERT INTO bzj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Soh Heroadyas mi gat it een fi Jan, ahn ih mi waahn kil ahn, bot ih kudn du ahn notn kaa Herod mi-di kip Jan sayf. Yu si, Herod mi frayd fi Jan kaa ih mi noa seh dat ih da-mi wahn raichos ahn hoali man. Wen Herod lisn tu Jan, ih mi wel kanfyooz, bot ih mi stil laik lisn tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","22","Den wahn day Heroadyas si ih chaans wen Herod chroa wahn big bertday paati fi ihself. Ih invait aala di big taim peepl dehn ahn di aami aafisa dehn fahn Gyalilee, ahn Heroadyas daata kohn daans fi dehn. Wel, Herod ahn ih ges dehn mi laik how ih daans, soh Herod seh tu di gyal, “Aks fi eniting weh yu waahn an Ah wahn gi yu.” ");
INSERT INTO bzj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ih mek wahn oat tu ahn, ahn pramis ahn seh, “Ah wahn gi yu eniting weh yu aks mi fa, op tu haaf a mi kingdom.” ");
INSERT INTO bzj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Di gyal gaahn aks ih ma, “Da weh Ah shuda aks fa?” Ih ma tel ahn seh, “Aks fi Jan di Baptis hed!” ");
INSERT INTO bzj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ih ron bak ahn tel di king, “Ah waahn Jan di Baptis hed rait now pahn wahn chray!” ");
INSERT INTO bzj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wel, Herod mi oanli sari bad, bot sayka di oat dehn weh ih mi mek, ahn sayka ih ges dehn, ih neva waahn brok ih werd tu di gyal. ");
INSERT INTO bzj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Soh rait den ih sen wan a ih soalja dehn wid aadaz fi bring Jan hed. Soh di soalja gaan ahn chap aaf ih hed eena di jayl. ");
INSERT INTO bzj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ih bring Jan hed pahn wahn chray ahn gi di gyal, ahn shee kehr it da ih ma. ");
INSERT INTO bzj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wen Jan disaipl dehn yehr weh hapm, dehn kohn fi di badi ahn beri ahn eena wahn toom. ");
INSERT INTO bzj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Now di twelv disaipl weh Jeezas mi sen owt gyada rong ahn, ahn ripoat bak tu ahn bowt aal weh dehn mi du ahn weh dehn mi teech. ");
INSERT INTO bzj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sayka weh soh moch peepl mi-di op ahn dong tu dehn, ahn dehn mi haadli ga taim fi dehnself, noh eevn fi eet, Jeezas tel dehn seh, “Lesgoh tek wahn kwaiyet lee brayk wee wan, ahn geh sohn res.” ");
INSERT INTO bzj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Soh dehn gaahn fahn deh eena wahn boat da wahn kwaiyet spat soh dehn kuda mi bee bai dehnself. ");
INSERT INTO bzj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bot wahn lata peepl si wen Jeezas dehn lef ahn dehn rekonaiz dehn. Soh dehn ron gaahn pahn fut fahn aala di tong dehn, ahn dehn reech deh heda dehn. ");
INSERT INTO bzj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wen Jeezas gaahn shoa, ih si wahn big krowd ahn ih mi sari fi dehn bikaa dehn da-mi sayhn laik sheep weh noh ga nobadi fi main dehn. Soh ih gaahn hed ahn teech dehn lata ting. ");
INSERT INTO bzj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Layt-wan di aftanoon, di disaipl dehn kohn tu Jeezas ahn seh, “Dis da wahn dizertid plays, ahn ih don di geh layt. Sen di krowd weh, soh dehn ku goh da di vilij dehn ahn di faam dehn weh deh kloas soh dat dehn ku bai sohnting fi dehnself fi eet.” ");
INSERT INTO bzj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bot Jeezas aks dehn seh, “Wai unu noh feed dehn?” Dehn ansa seh, “Da humoch bred wi wuda hafu bai soh? Ih wuda kaas bowt ayt monts pay fi feed aala dehnya peepl!” ");
INSERT INTO bzj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“Humoch bred unu ga?” Jeezas aks. “Goh chek si.” Dehn kohn bak ahn seh, “Wi oanli ga faiv bred ahn too fish.” ");
INSERT INTO bzj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Den Jeezas mek di krowd sidong eena groops pahn di green graas. ");
INSERT INTO bzj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Som a di groop mi ga fifti peepl, ahn sohn mi ga honjrid. ");
INSERT INTO bzj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Den Jeezas mek di peepl dehn sidong pahn di graas. Ih tek di faiv bred ahn too fish ahn luk op da hevn ahn gi Gaad tanks ahn brok di bred. Den ih gi di disaipl dehn fi gi di peepl dehn. Ahn den ih shayr op di too fish monks dehn tu. ");
INSERT INTO bzj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Evribadi eet til dehn ful, ahn den di disaipl dehn pik op hoal a twelv baaskit ful a di lee pees a bred dehn ahn fish. ");
INSERT INTO bzj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Da mi bowt faiv towzn man deh monks da krowd weh dehn feed deh da day. ");
INSERT INTO bzj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Rait afta dat, Jeezas mek ih disaipl dehn get eena di boat ahn goh heda ahn da di neks said a di lagoon da Betsayda, wail hihn sen di krowd hoahn. ");
INSERT INTO bzj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wen Jeezas don sen di peepl dehn hoahn, ih gaan op pahn di mongtin gaahn pray. ");
INSERT INTO bzj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wen eevnin kohn, di boat mi deh midl a di lagoon, wail Jeezas mi deh hihn wan pahn lan. ");
INSERT INTO bzj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ih noatis dat di disaipl dehn mi-di dig padl kaa di breez mi deh gens dehn. Bifoa day, Jeezas kohn tu dehn di waak pahn di waata tap. Ih mek fi waak rait paas di boat. ");
INSERT INTO bzj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Bot wen dehn si ahn di waak pahn di waata tap, dehn mi tink dat da mi goas, ahn dehn mi-di baal owt kaa aala dehn si ahn, ahn dehn mi fraitn no miks. Bot rait away Jeezas tel dehn seh, “Noh hat unu haat. Da mee. Noh frayd.” ");
INSERT INTO bzj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Den ih klaim eena di boat wid dehn, ahn di breez jrap! Dehn sidong deh laik dehn fool-fool di chrai mek sens a weh mi jos hapm. ");
INSERT INTO bzj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bikaa yu noa, eevn afta di mirakl wid di bred, dehn stil neva riyalaiz da mi hoo Jeezas. Dehn mi jos tu haad-hedid. ");
INSERT INTO bzj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wen dehn kraas oava di neks said a di lagoon, dehn gaahn shoa da Genesaret ahn anka di boat. ");
INSERT INTO bzj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Az dehn gaahn shoa, di peepl dehn rekonaiz Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dehn ron gaahn spred di nyooz rong da hoal ayrya seh Jeezas kohn. Den dehn staat tu bring sik peepl pahn schrecha ahn dehn kehr dehn eniway wichpaa hihn mi deh. ");
INSERT INTO bzj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Evriway ih gaan, weda da vilij er tong er lang di roadsaid, dehn kehr di sik peepl dehn owt eena di maakit ayrya dehn ahn bayg ahn fi mek dehn kud eevn toch di ej a ih kloaz. Ahn evri wan a dehn weh toch ahn geh heel. ");
INSERT INTO bzj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Now som a di Farisee ahn sohn teecha a di Jooish Laa weh mi kohn fahn Jeroosalem gyada rong Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Dehn noatis seh som a ih disaipl dehn mi-di eet widowt wash dehn han fos. ");
INSERT INTO bzj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","(Di Farisee dehn ahn aala di ada Jooish peepl dehn mi ga wahn ting weh dehn goh chroo, wahn serimoni fi wash dehn han gud bifoa dehn eet. Dehn mi ga wahn lata oal taim roolz fi kleenis weh mi deel wid evriting, rait dong tu how dehn wash dehn kop ahn dehn mog ahn dehn pat. Ahn wen dehn kom een fahn maakit, dehn hafu du wahn tara kleen op pahn tap a dat, bifoa dehn ku tek dehn fos bait.) ");
INSERT INTO bzj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Soh di Farisee dehn ahn di teecha a di Laa dehn aks Jeezas seh, “Da wai fi yoo disaipl dehn noh goh chroo di serimoni fi wash dehn han bifoa dehn eet laik how di oal taim peepl dehn doz du? Dehn noh wash dehn han bifoa dehn eet.” ");
INSERT INTO bzj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jeezas tel dehn seh, “Unu hipokrit unu! Weh Aizaiya di prafit mi seh bowt unu da chroo. Ih mi seh, ‘Dehnya peepl aana mi wid dehn mowt, bot dehn haat deh faar fahn mi. ");
INSERT INTO bzj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Dehn wership noh meen notn tu mi kaa dehn di teech fi dehn oan roolz, weh dehn mek op laik ih kohn fahn Gaad.’ ");
INSERT INTO bzj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Unu noh pay no main ataal tu Gaad komanment dehn. Insteda dat, unu fala roolz weh man mek.” ");
INSERT INTO bzj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Den ih tel dehn seh, “Unu ga wahn fain way fi rijek Gaad Laa jos fi kip op fi unu oan ting weh unu du. ");
INSERT INTO bzj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kaa Moaziz seh, ‘Unu mos aana unu ma ahn unu pa,’ ahn den ih seh, ‘Enibadi weh taak bad bowt dehn ma ahn dehn pa wahn hafu geh put tu det.’ ");
INSERT INTO bzj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bot unu seh dat sohnbadi ku tel dehn ma er dehn pa dat wateva dehn mi ga fi gi dehn, dehn gi Gaad insted, kaa da gif da ‘Korban’ (dat meen da wahn gif weh da oanli fi Gaad). Den dat meen dat da persn noh wahn hafu aana dehn ma ner dehn pa. ");
INSERT INTO bzj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Soh den, unu noh alow hihn fi du notn fi fi hihn ma er ih pa. ");
INSERT INTO bzj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Soh sayka fi unu oan roolz dehn weh unu mek op ahn paas dong tu unu pikni dehn, unu mek di Werd a Gaad noh meen notn; ahn unu du lat moa ting laik dat.” ");
INSERT INTO bzj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Den Jeezas kaal di peepl dehn tu ahn, ahn ih tel dehn seh, “Aala unu lisn tu mi ahn andastan weh Ah seh. ");
INSERT INTO bzj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Notn noh deh pahn di owtsaida wahn persn badi weh ku goh eena dehn badi ahn mek dehn haat doti, bot weh kom owta dehn, dat da weh mek dehn haat doti. ");
INSERT INTO bzj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Eni a unu weh ga ayz fi yehr, unu lisn gud!” ");
INSERT INTO bzj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Den ih gaan eena wahn hows ahn lef di krowd owtsaid. Ahn ih disaipl dehn aks ahn di meenin a weh ih mi jos tel dehn. ");
INSERT INTO bzj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Den Jeezas seh, “Unu stil noh andastan needa? Unu noh si seh dat eniting weh goh eena wahn persn fahn owtsaida dehn badi kyaahn doti dehn haat? ");
INSERT INTO bzj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kaa ih noh goh een chroo dehn haat, bot ih goh een chroo dehn stomok ahn den ih paas owta dehn badi.” (Soh den, Jeezas mi-di seh dat aal food gud fi eet.) ");
INSERT INTO bzj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jeezas gaan aan fi seh, “Da weh kom owta wahn persn haat da weh mek dehn doti fi chroo. ");
INSERT INTO bzj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kaa weh deh eena wahn persn haat da weh mek dehn tink op fi du aal kaina bad ting, laik sleep rong, teef, merda, ahn cheet pahn dehn hozban er dehn waif; ");
INSERT INTO bzj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ahn den yu ga red aiy, ahn bad-maindidnis, ahn yu di fool op peepl; yu ga bad livin, ahn greedinis, ahn slanda peepl, ahn praid, ahn schupidnis. ");
INSERT INTO bzj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Aala dehnya wikid ting kohn fahn eensaida wahn persn, ahn da dehndeh da weh mek dehn haat doti.” ");
INSERT INTO bzj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Den Jeezas lef fahn deh ahn gaahn da di ayrya weh deh kloas Taiya. Ih gaan eena wahn hows ahn ih neva waahn nobadi noa ih mi dehdeh; bot eevn soh, ih kudn haid ihself. ");
INSERT INTO bzj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","In fak, wahn laydi hoofa lee gyal mi ga wahn eevl spirit yehr bowt ahn, ahn kohn chroa ihself dong da ih fut. ");
INSERT INTO bzj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Bot shee da neva wahn Joo. Shee mi baan da Foneesha eena Siriya. Wel, shee kohn bayg Jeezas fi jraiv owt di deeman owta ih lee gyal. ");
INSERT INTO bzj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jeezas tel ahn seh, “Mek di pikni dehn eet aal weh dehn waahn fos kaa ih noh rait fi tek di pikni dehn bred ahn chroa it fi di daag dehn.” ");
INSERT INTO bzj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Di laydi ansa seh, “Da chroo, Sa, bot eevn di daag dehn anda di taybl eet di kromz weh jrap fahn di pikni dehn playt.” ");
INSERT INTO bzj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jeezas ansa seh, “Aarait, sayka weh yu seh dat, yu ku goh hoahn kaa di deeman don kom owta yu daata aredi.” ");
INSERT INTO bzj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Soh di laydi gaahn hoahn ahn fain di lee gyal di lidong eena bed, ahn di deeman mi don kom owta ahn. ");
INSERT INTO bzj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jeezas lef fahn di ayrya rong Taiya ahn gaahn chroo Saidan tuwaadz Gyalilee Lagoon. Den ih gaahn chroo di ayrya weh nayhn Dekapolis. ");
INSERT INTO bzj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Dehn bring wahn def man tu ahn weh kudn taak gud, ahn dehn bayg Jeezas fi put ih han pan ahn. ");
INSERT INTO bzj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jeezas kehr di man wahn lee wayz fahn di krowd ahn ih put ih finga eena di man ayz; den ih spit ahn toch di man tong. ");
INSERT INTO bzj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ih luk op tu hevn, den ih sai ahn ih seh, “Efata!” (Eena di Aramayik langwij dat meen “Oapm op!”) ");
INSERT INTO bzj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Fahn da veri minit di man kuda mi yehr ahn taak az gud az enibadi els. ");
INSERT INTO bzj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jeezas tel dehn noh fi tel nobadi weh mi hapm. Bot di moa ih tel dehn, di moa dehn spred di nyooz. ");
INSERT INTO bzj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Dehn kudn bileev weh dehn mi si, ahn dehn kudn stap seh, “Ih du evriting gud! Ih eevn mek di def peepl yehr ahn di dom peepl taak!” ");
INSERT INTO bzj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Rong da sayhn taim deh wahn neks big krowd gyada, ahn no food neva deh fi dehn eet. Soh Jeezas kaal ih disaipl dehn tu ahn, ahn seh, ");
INSERT INTO bzj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ah sari fi dis krowd kaa dehn deh wid mi fi chree dayz now ahn dehn noh ga notn fi eet. ");
INSERT INTO bzj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","If Ah sen dehn hoahn hongri, dehn wahn jrap dong pahn di way kaa som a dehn kohn fahn faar.” ");
INSERT INTO bzj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Di disaipl dehn ansa Jeezas, “Da how wee fi fain food way owt ya bakabush fi feed dehn?” ");
INSERT INTO bzj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jeezas aks dehn seh, “Humoch bred deh?” Dehn ansa seh, “Wi ga sebm bred.” ");
INSERT INTO bzj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Soh ih tel di krowd fi sidong pahn di grong. Den ih tek di sebm bred, ahn wen ih don gi Gaad tanks far it, ih brok dehn eena peesiz, ahn ih gi ih disaipl dehn fi shayr monks di peepl dehn, ahn dat da weh dehn du. ");
INSERT INTO bzj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dehn mi ga wan ahn too lee fish tu, ahn Jeezas bles dehn ahn mek di disaipl dehn shayr dat tu wid evribadi. ");
INSERT INTO bzj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Aala dehn eet til dehn geh nof, ahn dehn gyada op sebm baaskit a brok-op bred weh mi lefoava. ");
INSERT INTO bzj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bowt foa towzn peepl mi deh eena di krowd da day! Afta dehn don eet, Jeezas sen dehn hoahn. ");
INSERT INTO bzj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Rait afta dat Jeezas ahn di disaipl dehn get eena wahn boat ahn gaahn da di Dalmanoota ayrya. ");
INSERT INTO bzj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Di Farisee dehn kohn ahn staat tu aagyu wid Jeezas. Dehn mi-di aks ahn fi shoa dehn wahn sain fahn hevn fi tes ahn owt. ");
INSERT INTO bzj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jeezas gi wahn deep sai ahn aks dehn seh, “Da wai disya jenarayshan di luk fi wahn sain fahn hevn? Ah di tel unu di chroot, dehn noh wahn geh no sain.” ");
INSERT INTO bzj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Den ih lef dehn ahn get bak eena di boat ahn gaahn kraas di ada said a di lagoon. ");
INSERT INTO bzj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Now di disaipl dehn mi faget fi bring bred, ahn dehn mi oanli ga wan bred lef wid dehn eena di boat. ");
INSERT INTO bzj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jeezas waan dehn seh, “Unu beta main; kyaaful a di Farisee dehn ees ahn Herod ees tu.” ");
INSERT INTO bzj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Di disaipl dehn mi-di taak bowt it monks dehnself. Dehn seh, “Hihn seh dat kaa wi neva bring no bred.” ");
INSERT INTO bzj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jeezas mi kanchos a weh dehn mi-di taak bowt, soh ih aks dehn seh, “Da wai unu di taak bowt how unu noh ga no bred? Unu stil noh si er andastan? Unu hed soh haad? ");
INSERT INTO bzj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Unu ga aiy bot unu noh si, ahn unu ga ayz bot unu noh yehr. Unu noh memba wen Ah brok op di faiv bred fi di faiv towzn peepl dehn? Da humoch baaskit a brok-op bred unu mi pik op?” Dehn ansa, “Twelv.” ");
INSERT INTO bzj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ahn fahn di sebm bred weh mi feed di foa towzn peepl dehn, da humoch baaskit a brok-op bred unu mi pik op?” Dehn ansa, “Sebm baaskit.” ");
INSERT INTO bzj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Den Jeezas seh, “Ahn unu stil noh andastan?” ");
INSERT INTO bzj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wen dehn reech Betsayda, dehn bring wahn blain man tu Jeezas ahn bayg ahn fi toch ahn, ahn heel ahn. ");
INSERT INTO bzj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jeezas tek di blain man han ahn leed ahn owta di vilij. Den ih spit pahn ih aiy dehn ahn ih put ih han pan ahn. “Yu ku si eniting now?” Jeezas aks ahn. ");
INSERT INTO bzj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Di man luk rong ahn seh, “Yes! Ah si peepl, bot noh soh gud. Di peepl dehn luk laik chree di waak rong!” ");
INSERT INTO bzj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Den Jeezas put ih han pahn di man aiy dehn agen, ahn di man tek wahn lang haad luk rong, ahn dis taim ih kuda mi si evriting klyaa klyaa. ");
INSERT INTO bzj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jeezas sen ahn hoahn ahn ih aada ahn seh, “Yu mosn goh eena di vilij.” ");
INSERT INTO bzj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jeezas ahn ih disaipl dehn lef ahn gaahn da di vilij dehn weh mi deh rong Seezareeya Filipai. Pahn di way ih aks ih disaipl dehn, “Da hoo peepl seh da mee?” ");
INSERT INTO bzj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Dehn tel ahn seh, “Sohn peepl seh dat yoo da Jan di Baptis, ahn sohn ada wan seh yoo da Ilaija, ahn stil sohn neks wan dehn seh yoo da wan a di prafit dehn.” ");
INSERT INTO bzj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Den Jeezas aks dehn seh, “Bot da hoo yoo seh da mee?” Peeta ansa seh, “Yoo da di Krais.” ");
INSERT INTO bzj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Den Jeezas tel dehn noh fi tel nobadi bowt ahn. ");
INSERT INTO bzj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ih staat tu tel dehn seh dat ih mi wahn hafu sofa lata ting. Ih tel dehn how di Jooish leeda dehn, ahn di cheef prees dehn, ahn dehn wan weh teech di Laa mi wahn rijek ahn. Ih mi wahn hafu geh kil, bot afta chree dayz ih mi wahn rayz op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jeezas mi taak playn-wan bowt aala dis. Wel, Peeta jraa ahn wan said ahn tel ahn seh, “Yu mosn taak laik dat!” ");
INSERT INTO bzj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jeezas ton rong ahn luk pahn aala di disaipl dehn, ahn den ih tel Peeta shaap-wan, “Get fahn fronta mi, Saytan! Yoo di luk pahn aala dis di way peepl see't, noh laik how Gaad see't.” ");
INSERT INTO bzj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Den ih kaal di krowd lang wid ih disaipl dehn ahn tel dehn seh, “If eni a unu waahn fala mi, unu mos stap goh afta weh unu waahn fi fi unu oanself. Pik op yu kraas ahn fala mee. ");
INSERT INTO bzj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Enibadi weh chrai fi heng aan tu dehn oan laif wahn en op di laas it, bot enibadi weh giv op dehn laif fi sayka mee ahn di Gud Nyooz, dehn wahn sayv it. ");
INSERT INTO bzj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Weh gud ih wahn du yu if yu oan di hoal werl ahn en op di laas yu soal? ");
INSERT INTO bzj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Er, da weh yu wahn chaynji yu laif fa? ");
INSERT INTO bzj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Ahn if enibadi shaym a mee ahn fi mee mesij eena dis wikid jenarayshan weh noh faytful tu Gaad ataal, den di Son a Man wahn shaym a dehn tu wen ih kohn bak eena di gloari weh ih Faada gi ahn, ahn wen ih kohn wid di hoali aynjel dehn.” ");
INSERT INTO bzj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Den Jeezas tel dehn seh, “Ah di tel unu di chroot, som a unu weh di stan op rait ya soh, noh wahn ded bifoa unu si Gaad kingdom kohn wid powa!” ");
INSERT INTO bzj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Siks dayz afta dat, Jeezas kehr Peeta ahn Jaymz ahn Jan op pahn wahn hai mongtin. Oanli dehn wan mi deh op deh. Ahn wen dehn luk, di hoal a Jeezas chaynj soh Jeezas mi luk difrent difrent tu dehn. ");
INSERT INTO bzj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ih kloaz ton wait wait wait til ih hat dehn aiy. No washa uman kuda geh kloaz fi kohn soh wait! ");
INSERT INTO bzj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Den Ilaija ahn Moaziz apyaa fronta dehn ahn dehn mi-di taak tu Jeezas! ");
INSERT INTO bzj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Den Peeta seh tu Jeezas, “Teecha, ih gud dat wee deh ya. Mek wi put op chree boot rait ya, wan fi yoo, wan fi Moaziz, ahn wan fi Ilaija.” ");
INSERT INTO bzj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peeta neva noa weh fi seh kaa dehn mi oanli fraitn. ");
INSERT INTO bzj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wahn klowd apyaa ahn kohn dong oava dehn, ahn dehn yehr wahn vais fahn owta di klowd weh seh, “Dis da mai Son weh Ah oanli lov. Lisn tu ahn.” ");
INSERT INTO bzj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sodn-wan, wen dehn luk rong, dehn neva si nobadi els; oanli Jeezas wan mi deh wid dehn. ");
INSERT INTO bzj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Az dehn mi-di kohn bak dong di mongtin, Jeezas aada dehn noh fi tel nobadi weh dehn mi si til afta ih rayz op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Soh dehn neva tel nobadi bowt dis, bot dehn mi-di taak bowt it monks dehnself, ahn dehn mi-di wanda weh dis bizniz bowt “rayz op bak fahn di ded” mi meen. ");
INSERT INTO bzj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Den dehn aks Jeezas seh, “Da wai di teecha dehn a di Laa seh dat Ilaija hafu kohn fos bifoa eniting els wahn hapm?” ");
INSERT INTO bzj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jeezas tel dehn seh, “Yes. Ilaija hafu kohn fos fi chroo, ahn put evriting eena aada. Wel den, da wai dehn rait seh dat dehn wahn rijek di Son a Man ahn ih wahn hafu sofa lata ting? ");
INSERT INTO bzj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Bot Ah di tel unu, Ilaija don kohn aredi ahn dehn don du hihn aal weh dehn mi waahn, jos laik weh di prafit mi rait seh bowt ahn.” ");
INSERT INTO bzj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wen dehn gaahn bak tu di ada disaipl dehn, dehn fain dehn di aagyu wid som a di teecha dehn a di Laa, ahn wahn big krowd mi deh rong dehn. ");
INSERT INTO bzj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Di peepl dehn oanli geh eksaitid wen dehn kech sait a Jeezas di kohn, ahn dehn ron gaahn meet ahn. ");
INSERT INTO bzj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jeezas aks dehn seh, “Da weh unu di aagyu bowt now?” ");
INSERT INTO bzj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wahn man eena di krowd eksplayn ahn seh, “Teecha, Ah mi bring mi son tu yu kaa ih kyaahn taak sayka wahn eevl spirit weh deh eena ahn. ");
INSERT INTO bzj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Enitaihn dis spirit grab ahn, ih dash ahn da grong, ahn ih mek ih schrech owt stif stif-wan, ahn ih staat tu grain ih teet ahn foam da ih mowt. Soh Ah aks yu disaipl dehn fi pleez jraiv di eevl spirit owta ahn, bot dehn kudn du it.” ");
INSERT INTO bzj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jeezas tel dehn seh, “Aiy, unu peepl weh noh ga no fayt! How lang Ai fi deh ya wid unu, di put op wid unu? Bring di bwai ya tu mi.” ");
INSERT INTO bzj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Soh dehn bring di bwai, bot az soon az di spirit si Jeezas, ih chroa di bwai eena fits, ahn di bwai tombl dong ahn ih staat tu roal rong ahn ih staat tu foam da ih mowt. ");
INSERT INTO bzj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jeezas aks ih pa, “How lang sins ih stay laik dis?” Ih ansa seh, “Fahn ih leel, Sa. ");
INSERT INTO bzj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ahn lata taim di spirit mek ih jrap eena faiya er eena waata fi chrai kil ahn. Aiy, sa! Ah bayg yu pleez, sari fi wi noh, ahn help wi if yu kud.” ");
INSERT INTO bzj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jeezas aks ahn seh, “How yu meen ‘if Ai kud’? Eniting pasabl if yu ga fayt.” ");
INSERT INTO bzj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kwik-wan di pa ansa seh, “Yes, Ah ga fayt, Ah ga fayt. Jos help mi fi ga lee moa!” ");
INSERT INTO bzj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Wen Jeezas si dat di krowd mi-di flak ahn, ih taak shaap-wan tu di eevl spirit seh, “Yoo spirit a defnis ahn domnis, Ah aada yu fi kom owta dis bwai ahn noh goh bak eena ahn nohmoh nohmoh!” ");
INSERT INTO bzj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Den di eevl spirit skreem owt haad-wan ahn chroa di bwai eena fits agen, ahn den ih lef ahn. Di poa bwai lidong deh limba limba, sayhn laik ih ded. Di krowd staat tu seh monks dehnself, “Ih ded, di bwai ded!” ");
INSERT INTO bzj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bot Jeezas tek di bwai han ahn haal ahn op pahn ih fut ahn ih stan op. ");
INSERT INTO bzj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Aftawodz, wen Jeezas ahn ih disaipl dehn mi eena di hows bai dehnself, dehn aks ahn seh, “Da wai wee kudn jraiv owt di eevl spirit?” ");
INSERT INTO bzj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jeezas tel dehn seh, “Di oanli way dehnya kaina spirit wahn kom owt, da if unu pray ahn faas.” ");
INSERT INTO bzj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Den Jeezas ahn ih disaipl dehn lef fahn deh ahn gaahn chroo Gyalilee bot ih neva waahn nobadi noa weh dehn mi deh, ");
INSERT INTO bzj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kaa ih mi waahn teech ih disaipl dehn. Ih tel dehn seh, “Dehn wahn sel owt di Son a Man, ahn han ahn oava tu sohn peepl weh wahn kil ahn. Bot den chree dayz aftawodz, ih wahn kohn bak fahn di ded.” ");
INSERT INTO bzj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bot dehn neva andastan weh Jeezas mi-di taak bowt, ahn dehn mi frayd fi aks ahn. ");
INSERT INTO bzj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Den dehn reech Kapernyam, ahn wen dehn setl dong eena di hows, Jeezas aks dehn seh, “Da weh unu mi-di aagyu bowt lang di way?” ");
INSERT INTO bzj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bot dehn neva seh notn kaa pahn di way dehn mi-di taak monks dehnself bowt wich wan a dehn da-mi di moas impoatant wan. ");
INSERT INTO bzj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jeezas sidong, ahn ih kaal aala dehn ahn eksplayn, “Husoeva waahn bee moas impoatant mos bee di lees; ih mos bee evribadi servant!” ");
INSERT INTO bzj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Den ih tek wahn lee pikni ahn put ahn midl a dehn, den ih hog ahn op ahn tel dehn seh, ");
INSERT INTO bzj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Enibadi weh welkom eni a dehnya lee pikni ya sayka mee welkom mee tu; ahn enibadi weh welkom mee welkom di Wan weh sen mi!” ");
INSERT INTO bzj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jan tel ahn seh, “Teecha, wi mi si wahn man di yooz yu naym fi jraiv deeman owta peepl, ahn wi tel ahn fi stap bikaa hihn da noh wan a wee.” ");
INSERT INTO bzj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jeezas seh, “No! Noh stap ahn! If sohnbadi yooz mi naym fi du wahn mirakl, dehn kyaahn ton rong ahn goh gens mi rait afta dat. ");
INSERT INTO bzj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Enibadi weh noh deh gens wi, dehn deh pahn fi wee said. ");
INSERT INTO bzj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ah di tel unu di chroot, if sohnbadi gi yu wahn kop a waata sayka weh yu bilangz tu mee, dehn wahn geh dehn riwaad. ");
INSERT INTO bzj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Bot if enibadi du eniting fi mek eni a dehnya lee pikni ya weh bileev eena mi du eniting rang, den ih wuda beta fi dehn if dehn tai wahn big hevi rakstoan rong dehn nek ahn chroa dehn da batam a di see. ");
INSERT INTO bzj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ahn if yu han di mek yu sin, den chap it aaf. Ih beta fi kripl ahn liv fareva dan fi ga yu too han ahn en op da hel weh di faiya neva owt. ");
INSERT INTO bzj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Wehpaa di wom dehn neva ded, ahn di faiya neva owt. ");
INSERT INTO bzj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“If yu fut di mek yu sin, chap it aaf. Ih beta fi kripl ahn liv fareva dan fi ga too fut ahn geh pich eena hel. ");
INSERT INTO bzj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Wehpaa di wom dehn neva ded, ahn di faiya neva owt. ");
INSERT INTO bzj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ahn if wan a yu aiy di mek yu sin, dig it owt; ih beta fi ga wan aiy ahn liv fareva dan fi ga yu too aiy dehn ahn geh pich eena hel, ");
INSERT INTO bzj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","wehpaa ‘di wom dehn neva ded, ahn di faiya neva owt.’ ");
INSERT INTO bzj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Evribadi weh seezn wid faiya wahn geh kleen jos laik how di sakrifais geh kleen wid saalt. ");
INSERT INTO bzj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Saalt da wahn gud ting, bot if ih noh tays saalti nohmoh, da how yu wahn mek it saalti agen? Soh mek shoar unu stay saalti, ahn liv eena pees wid wan anada.” ");
INSERT INTO bzj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Den Jeezas lef fahn da plays ahn gaahn da di paat a Judeeya weh mi deh kraas di neks said a Jaadn Riva. Di krowd dehn kip aan di kohn, ahn az yoozhwal, ih teech dehn. ");
INSERT INTO bzj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sohn Farisee kohn kohn chrai tes owt Jeezas, soh dehn aks ahn seh, “Ih gens di Laa fi wahn man divoas ih waif?” ");
INSERT INTO bzj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jeezas aks dehn seh, “Da weh Moaziz Laa tel unu fi du bowt dat?” ");
INSERT INTO bzj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dehn ansa seh, “Wel, Moaziz mi alow wahn man fi gi ih waif wahn divoas paypa ahn den put ahn owt.” ");
INSERT INTO bzj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jeezas seh, “Da sayka weh unu haat soh haad mek Moaziz mi alow unu fi divoas unu waif. ");
INSERT INTO bzj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Fahn di biginin, wen Gaad mek di werl, ‘Ih mek man ahn uman.’ ");
INSERT INTO bzj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Dat da wai wahn man fi lef ih ma ahn ih pa ahn jain op wid ih waif, ");
INSERT INTO bzj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ahn di too a dehn wahn bee laik wan persn.’ Soh dehn noh wahn bee too nohmoh, bot wan. ");
INSERT INTO bzj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Soh noh mek nobadi separayt weh Gaad don jain tugeda.” ");
INSERT INTO bzj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Laytaraan, wen dehn mi deh eena di hows wid Jeezas, di disaipl dehn mi aks ahn di sayhn kweschan agen. ");
INSERT INTO bzj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jeezas tel dehn seh, “Enibadi weh divoas dehn waif ahn marid tu wahn neks uman di sin gens dehn waif. ");
INSERT INTO bzj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ahn rait soh, if wahn waif divoas ih hozban ahn marid tu wahn nada man, den shee di liv eena sin tu.” ");
INSERT INTO bzj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Now sohn peepl mi-di bring dehn lee pikni tu Jeezas fi mek ih put ih han pahn dehn fi bles dehn. Bot di disaipl dehn taak tu dehn shaap-wan ahn tel dehn noh fi bada ahn. ");
INSERT INTO bzj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wen Jeezas si weh mi-di hapm, ih neva laik dat ataal ahn ih tel di disaipl dehn, “Mek di lee pikni dehn kohn tu mi. Noh stap dehn, kaa peepl weh waahn bee paat a Gaad kingdom hafu stan jos laik lee pikni. ");
INSERT INTO bzj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ah di tel unu di chroot, enibadi weh noh kohn tu Gaad laik wahn lee pikni wahn neva bee paat a Gaad kingdom.” ");
INSERT INTO bzj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Den ih pik op di lee pikni dehn ahn put ih han pahn dehn ahn bles dehn. ");
INSERT INTO bzj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Az Jeezas mi-di lef, wahn man ron op tu ahn, ahn neel dong fronta ahn, ahn ih aks ahn seh, “Mi gud Teecha, da weh Ah ku du fi geh fi liv wid Gaad fareva?” ");
INSERT INTO bzj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jeezas aks ahn seh, “Da wai yoo di kaal mee gud? Nobadi noh gud; oanli Gaad wan gud. ");
INSERT INTO bzj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yoo noa weh di komanment dehn seh: ‘Yu noh fi komit merda, yu noh fi cheet pahn yu hozban er yu waif, yu noh fi teef, yu noh fi tel lai pahn nobadi, yu noh fi chaans nobadi, ahn yu mos aana yu ma ahn yu pa.’” ");
INSERT INTO bzj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Di man ansa seh, “Teecha, Ai di du aala dehn ting deh fahn Ai da lee bwai.” ");
INSERT INTO bzj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jeezas luk pan ahn wid lov eena ih haat far ahn, ahn ih tel ahn seh, “Oanli wan ting lef fi yu du now den. Goh goh sel evriting weh yu ga ahn gi di poa di moni, den yu wahn ga chreja eena hevn. Wen yu don du dat, den yu kohn ahn fala mi.” ");
INSERT INTO bzj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wen di man yehr dat, ih fays jrap. Ih gaahn fahn deh sad-wan kaa hihn mi doti rich. ");
INSERT INTO bzj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jeezas ton rong ahn tel ih disaipl dehn seh, “Ai! Ih oanli haad fi rich peepl get eena Gaad kingdom.” ");
INSERT INTO bzj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Di disaipl dehn mi shak wen dehn yehr dis, bot Jeezas tel dehn agen, “Ih oanli haad fi rich peepl weh bileev seh moni da evriting get eena Gaad kingdom. ");
INSERT INTO bzj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ih eeziya fi wahn kyamil paas chroo di aiy a wahn needl dan fi wahn rich man get eena Gaad kingdom.” ");
INSERT INTO bzj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Di disaipl dehn mi wosa shak wen dehn yehr dis, soh dehn aks ahn seh, “Wel, da hoo ku geh sayv den?” ");
INSERT INTO bzj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jeezas luk pahn dehn ahn seh, “Wid man ih impasabl, bot noh wid Gaad. Evriting pasabl wid Gaad.” ");
INSERT INTO bzj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Den Peeta tel ahn seh, “Si, wee lef evriting fi fala yoo.” ");
INSERT INTO bzj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jeezas ansa seh, “Ah di tel unu di chroot, enibadi weh lef hows, er breda, er sista, er ma, er pa, er pikni, er lan fi sayka mee ahn fi sayka di Gud Nyooz, ");
INSERT INTO bzj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","dehn wahn geh wahn riwaad. Eena dis laiftaim dehn wahn geh bak honjrid moa hows, ahn breda, ahn sista, ahn ma, ahn pikni, ahn lan. Bot sayhn taim dehn wahn sofa lata haraasment sayka weh dehn bileev. Ahn eena di neks werl di kohn, dehn wahn liv wid Gaad fareva. ");
INSERT INTO bzj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bot eena di werl weh di kohn, lata peepl weh da fos now wahn bee laas, ahn dehn wan weh da laas wahn bee fos.” ");
INSERT INTO bzj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Dehn mi deh pahn dehn way op tu Jeroosalem, ahn Jeezas mi deh lee wayz hed. Di disaipl dehn mi kwait kanfyooz bowt weh Jeezas mi tel dehn, ahn di res a peepl dehn weh mi-di fala baka dehn mi frayd. Jeezas kehr di twelv disaipl dehn wan said ahn staat tu goh oava weh aal mi wahn hapm tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ih tel dehn seh, “Luk, wi gwehn op da Jeroosalem weh dehn wahn sel owt di Son a Man tu di cheef prees dehn ahn dehn wan weh teech di Laa, ahn dehn wahn sentens ahn tu det. Den dehn wahn han ahn oava tu peepl weh da noh Joo. ");
INSERT INTO bzj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Dehn wahn tek ahn mek papishoh, spit pan ahn, ahn flag ahn, ahn kil ahn, bot afta chree dayz ih wahn rayz op bak fahn di ded!” ");
INSERT INTO bzj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Den Jaymz ahn Jan, Zebidee son dehn, kohn tu Jeezas ahn aks ahn seh, “Teecha, wi ga wahn fayva fi aks yu.” ");
INSERT INTO bzj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jeezas aks ahn seh, “Da weh unu waahn mek Ah du fi unu?” ");
INSERT INTO bzj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“Wen taim kohn fi yu rool az king, wi wuda waahn yu mek wan a wi sidong pahn yu rait han said ahn wan pahn yu lef.” ");
INSERT INTO bzj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bot Jeezas ansa seh, “Unu noh noa weh unu di aks fa. Unu ku jrink di sayhn kop a sofarin weh Ai hafu jrink? Er geh baptaiz wid di sofarin weh Ai fi geh baptaiz wid?” ");
INSERT INTO bzj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Dehn ansa seh, “Yes, wee ku jrink it.” Ahn Jeezas seh, “Unu wahn jrink fahn di kop weh Ai jrink, ahn unu wahn geh baptaiz wid di baptizm weh Ai baptaiz wid, ");
INSERT INTO bzj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","bot Ai kyaahn mek unu sidong pahn aida said a mee. Ih don disaid aredi hoo fi geh dehndeh too pozishan.” ");
INSERT INTO bzj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wen di ada ten disaipl geh fi yehr weh dehn mi aks Jeezas fa, dehn mi wel beks wid Jaymz ahn Jan. ");
INSERT INTO bzj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Soh Jeezas kaal aala dehn tugeda ahn tel dehn seh, “Unu noa dat dehn king eena dis werl lov fi shoa dehn powa oava di peepl dehn weh dehn rool oava, ahn fi dehn big taim ofishal dehn baas op dehn wan weh deh anda dehn. ");
INSERT INTO bzj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Wel, dat da noh how ih fi stan wid unu. If eni a unu waahn bee impoatant, unu hafu bee di neks wan dehn servant. ");
INSERT INTO bzj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","45","Ahn if enibadi waahn bee di moas impoatant wan, den dehn wahn hafu bee wahn slayv tu di res sayhn laik how di Son a Man mi du. Hihn neva kohn fi mek nobadi serv hihn, bot hihn kohn fi serv ada peepl ahn fi giv op fi hihn laif soh dat lat moa peepl ku geh free fahn dehn sin dehn.” ");
INSERT INTO bzj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Den Jeezas ahn ih disaipl dehn gaahn da Jeriko. Wen dehn mi-di lef Jeriko, wahn big krowd mi deh lang wid dehn. Wahn blain man weh nayhn Bartimayos, weh da Timayos son, mi-di sidong bai di roadsaid di bayg. ");
INSERT INTO bzj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wen Bartimayos yehr seh Jeezas fahn Nazaret mi-di geh kloas, ih staat wan pees a halarin, “Jeezas, yoo weh da Dayvid Son, ga piti pahn mi!” ");
INSERT INTO bzj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lata peepl tel ahn fi shet op ih mowt, bot hihn hala haada, “Dayvid Son, ga piti pahn mi noh!” ");
INSERT INTO bzj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jeezas stap ahn seh, “Tel ahn fi kohn ya.” Soh dehn kaal di blain man ahn tel ahn seh, “Yu ku feel gud now, bwai, kaa ih di kaal yu. Get op ahn goh!” ");
INSERT INTO bzj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimayos haal aaf ih koat ahn fling it wan said, ahn jomp op ahn gaahn tu Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jeezas aks ahn seh, “Da weh Ah ku du fi yu?” Ih ansa seh, “Aiy, Teecha, Ah waahn si!” ");
INSERT INTO bzj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jeezas seh tu ahn, “Goh; sayka yu fayt, yu geh heel.” Sayhn taim di blain man geh bak ih sait, ahn ih staat tu fala Jeezas lang di road. ");
INSERT INTO bzj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wen dehn mi nayli reech Jeroosalem, ahn dehn mi deh rait da Betfayj ahn Betani, weh da-mi too vilij weh mi deh bai di hil weh nayhn di Mongt a Alivz, Jeezas sen too a ih disaipl dehn hed, ");
INSERT INTO bzj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ahn ih tel dehn seh, “Unu goh da di vilij weh deh lee wayz hed, ahn az unu get deh, unu wahn fain wahn yong dongki weh nobadi neva raid pahn yet tai op. Loos ahn, ahn bring ahn ya. ");
INSERT INTO bzj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","If enibadi aks unu weh unu di du, jos seh, ‘Di Laad need ahn, ahn ih wahn sen ahn bak direkli.’” ");
INSERT INTO bzj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Di too a dehn gaan ahn fain di yong dongki tai op pahn di schreet fronta wahn doa. Az dehn mi-di loos ahn, sohn peepl weh mi deh rong aks dehn seh, “Da weh unu di loos da dongki fa?” ");
INSERT INTO bzj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dehn tel dehn weh Jeezas mi tel dehn fi seh, ahn di peepl dehn lef dehn mek dehn kehr ahn. ");
INSERT INTO bzj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wen dehn get bak da Jeezas wid di dongki, di disaipl dehn chroa dehn jakit ahn ting pahn di dongki bak, ahn den Jeezas get aan. ");
INSERT INTO bzj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Den lata peepl staat tu chroa dong dehn jakit ahn ting pahn di road fi mek Jeezas raid pan, ahn sohn ada wan chroa dong sohn branch weh dehn mi kot fahn eena di feel dehn. ");
INSERT INTO bzj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dehn wan weh mi-di goh lang heda ahn, ahn dehn wan weh mi-di fala baka ahn mi-di hala, “Hozaana! Gaad bles di Wan weh kom eena di naym a di Laad! ");
INSERT INTO bzj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Gaad bles di nyoo kingdom weh di kohn chroo wi ansesta, King Dayvid! Prayz tu Gaad eena hevn!” ");
INSERT INTO bzj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Wen Jeezas gaahn da Jeroosalem, ih gaan eena di templ ahn luk rong gud pahn evriting, bot laik how ih mi don layt aredi, hihn ahn di twelv disaipl dehn gaahn bak da Betani. ");
INSERT INTO bzj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Di neks day wen Jeezas ahn ih disaipl dehn lef fahn Betani, Jeezas mi hongri. ");
INSERT INTO bzj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Fahn faar ih si wahn fig chree weh mi ful a leef, ahn ih gaahn si if eni fig mi deh pan it. Bot non neva deh bikaa da neva fig seezn. ");
INSERT INTO bzj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Soh Jeezas seh tu di chree, “Nobadi noh wahn eva eet froot aafa dis chree agen!” Ahn di disaipl dehn mi yehr ahn wen ih seh dat. ");
INSERT INTO bzj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wen Jeezas ahn di disaipl dehn reech Jeroosalem, Jeezas gaahn da di templ yaad ahn wail owt aala dehn wan weh mi-di bai ahn sel eena di yaad. Ih ton oava di moni chaynja dehn taybl ahn di bench dehn fi dehn wan weh mi-di sel pijin. ");
INSERT INTO bzj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ih ton bak evribadi weh mi-di tek shaatkot chroo di templ yaad wid dehn load. ");
INSERT INTO bzj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Den afta dat ih eksplayn ahn tel di peepl dehn, “Di Skripcha seh, ‘Mai hows sopoas tu bee wahn plays weh peepl fahn aal oava di werl ku kohn pray.’ Bot unu ton ahn intu ‘wahn hengowt fi teef.’” ");
INSERT INTO bzj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Di cheef prees dehn ahn dehn wan weh teech di Jooish Laa yehr weh Jeezas seh ahn dehn staat tu luk fi wahn way how fi kil ahn. Dehn mi frayd far ahn sayka weh di peepl dehn mi reeli intu weh ih mi-di teech. ");
INSERT INTO bzj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wen eevnin kohn, Jeezas ahn ih disaipl dehn lef di siti. ");
INSERT INTO bzj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Di neks maanin, az di disaipl dehn mi-di waak paas di fig chree weh Jeezas mi put mowt pan, dehn noatis seh ih mi jrai rait op, rait dong tu di roots. ");
INSERT INTO bzj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peeta memba weh Jeezas mi seh tu di chree, ahn soh ih seh, “Teecha, luk deh! Di chree weh yu put mowt pahn jrai op ahn ded.” ");
INSERT INTO bzj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jeezas tel ih disaipl dehn seh, “Unu mos ga fayt eena Gaad. ");
INSERT INTO bzj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ah di tel unu di chroot, if enibadi tel dis mongtin, ‘Goh hib yuself eena di see,’ ahn noh dowt eena ih haat, bot bileev dat weh ih seh wahn hapm, ih wahn hapm. ");
INSERT INTO bzj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Soh Ah di tel unu dat eniting weh yu aks fa wen yu pray, bileev dat yu don get it, ahn yu wahn get it. ");
INSERT INTO bzj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Enitaihn yu goh fi pray, if yu ga eniting gens enibadi, yu fi fagiv dehn soh dat yu Faada weh deh op da hevn ku fagiv fi yoo sin dehn tu. ");
INSERT INTO bzj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kaa if yu noh fagiv, Gaad noh wahn fagiv fi yoo sin dehn needa.” ");
INSERT INTO bzj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Den Jeezas ahn ih disaipl dehn reech bak da Jeroosalem. Az Jeezas mi-di waak chroo di templ yaad, di cheef prees dehn ahn dehn wan weh teech di Jooish Laa, ahn di Jooish leeda dehn, dehn kom op tu ahn, ");
INSERT INTO bzj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ahn aks ahn seh, “Da weh atariti yoo ga fi du dehnya ting ya? Da hoo gi yoo dis atariti?” ");
INSERT INTO bzj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jeezas ansa dehn seh, “Mek Ai aks unu wahn kweschan tu. If unu ku ansa it, den Ah wahn tel unu weh Ai geh di atariti fi du dehnya ting. ");
INSERT INTO bzj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Now, da weh Jan di Baptis geh di atariti fi baptaiz peepl—fahn Gaad er fahn man? Ansa mi dat!” ");
INSERT INTO bzj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dehn taak it oava monks dehnself ahn seh, “If wi seh da fahn Gaad, den ih wahn aks wi, ‘Den wai unu neva bileev ahn den?’ ");
INSERT INTO bzj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bot if wi seh da mi fahn man...hmm!” (Dehn mi frayd fi di peepl sayka weh evribadi mi bileev seh dat Jan da-mi wahn chroo chroo prafit.) ");
INSERT INTO bzj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Soh dehn ansa Jeezas seh, “Wee noh noa.” Soh Jeezas tel dehn seh, “Wel, Ai noh wahn tel unu da hoo gi mee di atariti fi du dehnya ting needa.” ");
INSERT INTO bzj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jeezas staat tu taak tu di peepl dehn eena parablz. Ih seh, “Wahn taim wahn man plaant owt wahn pees a lan wid grayp. Ih fens it op ahn ih dig owt wahn hoal eena wahn big rak wehpaa dehn skweez owt di joos owta di grayp dehn. Afta dat ih bil wahn lukowt towa ahn den ih rent di lan owt tu sohn faama. Den hihn gaahn weh da wahn neks konchri. ");
INSERT INTO bzj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Wen di taim kohn fi pik di grayp dehn, di oana a di lan sen ih servant fi kalek fi hihn shayr a di krap fahn di faama dehn. ");
INSERT INTO bzj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bot di faama dehn grab di servant ahn beet ahn op bad, ahn sen ahn bak wid ih too lang han di heng dong da ih said. ");
INSERT INTO bzj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Den di oana sen wahn neks servant, ahn dehn gi hihn wahn bad bos-hed; ih mi shaymful how dehn mi chreet ahn. ");
INSERT INTO bzj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Den ih sen wahn tara man, bot dehn ton rong ahn kil hihn tu. Ahn aala dehn wan weh ih sen afta dat geh kil er beet op bad. ");
INSERT INTO bzj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Pahn di en, di oana mi oanli ga wan moa persn weh ih kuda mi sen, ahn dat da-mi ih son weh ih mi lov bad. Ih seh tu ihself, ‘Dehn mos wahn rispek mi son.’ ");
INSERT INTO bzj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Bot cho! Di faama dehn seh monks dehnself, ‘Dis da di wan weh wahn inherit evriting. Mek wi kil hihn, den evriting wahn bee fi wee!’ ");
INSERT INTO bzj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Soh dehn grab di oana son ahn kil ahn, ahn pich ih badi aafa di lan. ");
INSERT INTO bzj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Now da weh di oana wahn du wen ih yehr weh hapm? Ih wahn kohn kohn kil aala dehn, ahn rent owt di lan tu sohn ada faama. ");
INSERT INTO bzj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yu neva reed weh di Skripcha seh? Ih seh, ‘Di stoan weh di bilda dehn neva tink mi wot notn ton owt fi bee di kaanastoan, weh da di moas impoatant wan owta aala dehn. ");
INSERT INTO bzj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dis da weh di Laad du. Da wahn wandaful ting fi si, noh chroo’?” ");
INSERT INTO bzj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Di Jooish leeda dehn mi-di chrai fain wahn way fi ares Jeezas kaa dehn mi wel noa seh dat wen Jeezas mi-di tel dehn da lee stoari bowt di wikid faama dehn, ih mi-di taak bowt dehn. Bot sayka weh dehn mi frayd fi di krowd, dehn lef ahn loan ahn gaan. ");
INSERT INTO bzj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Afta dat dehn sen sohn Farisee ahn sohn peepl weh fala Herod fi taak wid ahn soh dat dehn ku chrai mek ih seh sohnting weh dehn kuda ares ahn fa. ");
INSERT INTO bzj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","“Now Teecha, wee noa seh dat yoo da wahn aanis ahn rispektabl man, ahn yoo teech di chroot bowt how Gaad waahn peepl fi liv. Yu chreet evribadi sayhn way noh kay da hoo dehn. Soh tel wi weh yoo tink. Ih rait fi pay taks tu Seeza er nat? ");
INSERT INTO bzj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tel wi, yes er no?” Jeezas mi don si chroo dehn toofaystidnis lang taim, soh ih aks dehn seh, “Da wai unu di chrai chrik mi? Bring wahn silva moni, mek Ah see't.” ");
INSERT INTO bzj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wen dehn han ahn di moni, ih aks dehn seh, “Hoofa hed stamp pahn dis moni, ahn hoofa naym rait pan it?” Dehn ansa seh, “Seeza.” ");
INSERT INTO bzj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Den Jeezas tel dehn seh, “Wel den, gi Seeza weh bilangz tu Seeza, ahn gi Gaad weh bilangz tu Gaad!” Dehn mi shak wid Jeezas ansa. ");
INSERT INTO bzj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Den sohn Sadyusee kohn tu Jeezas wid wahn kweschan. Dehn da wahn groop weh bileev seh peepl noh wahn rayz op bak fahn di ded. Dehn aks ahn seh, ");
INSERT INTO bzj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Teecha, Moaziz mi rait wahn laa fi wi weh seh dat if wahn man breda ded lef ih waif, bot ih neva ga no pikni wid ahn, da man fi marid tu ih ded breda wido ahn ga pikni wid ahn soh dat ih ku kehr aan ih breda naym. ");
INSERT INTO bzj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wel, yu mi ga sebm breda. Di fos wan marid ahn ded widowt ga no pikni. ");
INSERT INTO bzj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Di sekant breda marid tu ih breda wido, ahn hihn ded widowt lef no pikni. Ahn di neks breda tu, sayhn ting. ");
INSERT INTO bzj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Wan afta di neks aala di res a breda dehn marid tu di sayhn wido ahn aala dehn ded widowt ga no pikni. Wel, pahn di en di laydi shee ded tu. ");
INSERT INTO bzj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Soh, wen di day kohn fi ded peepl kohn bak tu laif, hoofa waif shee wahn bee, laik how di hoal sebm a dehn mi marid tu ahn?” ");
INSERT INTO bzj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jeezas ansa dehn seh, “Unu rang kaa unu noh noa di Skripcha ner how powaful Gaad powaful. ");
INSERT INTO bzj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yu si, wen peepl rayz op bak fahn di ded pahn rezorekshan day, nobadi wahn geh marid tu nobadi. Dehn wahn bee sayhn laik di aynjel dehn weh deh da hevn. ");
INSERT INTO bzj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bot az tu weda peepl wahn rayz op bak fahn di ded, unu neva reed wehpaa Moaziz rait bowt di taim wen Gaad mi taak tu ahn owta wahn bush weh mi-di bon? Gaad seh tu ahn, ‘Ai da di Gaad a Aybraham ahn Aizak, ahn Jaykop.’ ");
INSERT INTO bzj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hihn da noh di Gaad a ded peepl, bot ih da di Gaad a peepl weh livin. Unu sadli mistaykn.” ");
INSERT INTO bzj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wan a dehn wan weh teech di Jooish Laa mi dehdeh ahn hihn mi yehr di hoal aagyument wid di Sadyusee dehn. Ih mi laik how Jeezas ansa dehn, soh ih aks ahn seh, “Owta aala di komanment dehn, wich wan da di moas impoatant wan?” ");
INSERT INTO bzj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jeezas ansa seh, “Di wan weh seh, ‘Lisn gud, peepl a Izrel! Di Laad wi Gaad, hihn da di Wan ahn oanli Gaad weh deh. ");
INSERT INTO bzj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yu fi lov di Laad yu Gaad wid aala yu haat, ahn wid aala yu soal, ahn wid aala yu main, ahn wid aala yu schrent.’ ");
INSERT INTO bzj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Di neks wan tu dat da: ‘Yu fi lov yu nayba sayhn laik how yu lov yuself.’ No ada komanment moa impoatant dan dehnya too.” ");
INSERT INTO bzj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Di teecha a di Laa seh, “Sa, yu soh rait wen yu seh dat oanli wan Gaad deh ahn oanli hihn wan da Gaad. ");
INSERT INTO bzj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","An Ai noa seh fi chroo dat ih moa impoatant fi lov Gaad wid aala yu haat, ahn wid aala yu main, ahn wid aala yu schrent, ahn yu fi lov yu nayba sayhn laik how yu lov yuself. Dehnya komanment moa impoatant dahn aala di animal sakrifais er eni ada kaina sakrifais weh wi ku eva aafa op tu Gaad.” ");
INSERT INTO bzj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wen Jeezas si how ih ansa mi mek sens, ih seh tu di man, “Yu noh deh faar fahn Gaad kingdom.” Ahn fahn deh goh bak nat anada soal mi dayr aks Jeezas wahn nada kweschan. ");
INSERT INTO bzj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Wail ih mi-di teech da di templ, Jeezas aks, “How kom dehn wan weh teech di Laa seh dat di Krais wahn kohn fahn King Dayvid famili lain? ");
INSERT INTO bzj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Di Hoali Spirit mi-di taak chroo Dayvid wen Dayvid seh, ‘Di Laad tel mai Laad seh, “Sidong rait ya pahn mi rait han said til Ah put yu enimi dehn anda yu fut.” ’ ");
INSERT INTO bzj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Laik how Dayvid mi kaal di Krais ‘Laad,’ den da how di Krais ku kohn dong chroo Dayvid famili lain?” Ahn di krowd mi injai lisn tu Jeezas. ");
INSERT INTO bzj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ahn ih teech dehn lat moa ting tu. Ih tel dehn seh, “Wach owt fi dehn wan weh teech di Laa! Dehn laik waak rong eena lang roab, ahn dehn laik wen evribadi hayl dehn op owta schreet. ");
INSERT INTO bzj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Dehn aalwayz waahn di kak op da front seet da di sinagag dehn er da bankwit ahn soh. ");
INSERT INTO bzj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bot dehn noh shaym fi teef hows ahn lat fahn dehn poa lee oal laydi, ahn dehn ron goh pray evri haaf ton fi chrai fool di poblik seh dehn soh gud ahn hoali. Dehn wahn geh ponish wosa fi sayka dat.” ");
INSERT INTO bzj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Den Jeezas sidong rait kraas fahn di kalekshan baks da di templ. Ih mi-di wach how di peepl dehn mi-di jrap een dehn moni. Lata di rich man dehn put een big moni. ");
INSERT INTO bzj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Den wahn poa lee wido kohn ahn jrap een too wan sehn. ");
INSERT INTO bzj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jeezas kaal ih disaipl dehn tu ahn, ahn tel dehn seh, “Ah di tel unu di chroot, dis poa wido put een moa dahn aala di ada peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Aala dehn peepl gi owta di lat weh dehn ga. Bot eevn eena aala ih poanis, shee gi aal weh ih mi ga fi liv pan.” ");
INSERT INTO bzj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Az Jeezas mi-di lef di templ, wan a ih disaipl dehn seh tu ahn, “Teecha, dehn big bildin ya da sohnting fi luk pan, noh chroo? Wach how big ahn schrang dehn stoan weh di waal mek owta!” ");
INSERT INTO bzj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jeezas ansa dehn seh, “Unu si aala dehn big bildin ya? Wel, aala dehnya bildin ya wahn geh nak dong flat; nat wan stoan wahn lef pahn tap a di neks.” ");
INSERT INTO bzj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Layta Jeezas mi-di sidong pahn di hil weh nayhn di Mongt a Alivz faysn di templ. Peeta, Jaymz, Jan, ahn Anjru aks ahn praivit-wan seh, ");
INSERT INTO bzj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tel wi, da wen aala dehnya ting wahn hapm? Ahn da weh kaina sain wi wahn geh fi mek wi noa wen da taim fi dehn kohn chroo? Wi wahn geh eni waanin bifoa han?” ");
INSERT INTO bzj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Soh Jeezas tel dehn seh, “Unu wach owt ahn noh mek nobadi fool unu. ");
INSERT INTO bzj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Lata peepl wahn kohn di yooz mai naym di seh, ‘Ai da hihn,’ ahn dehn wahn fool op lata peepl. ");
INSERT INTO bzj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Wen unu yehr lata yehrisoh bowt how waar di brok owt aal oava di plays, noh geh fraitn kaa ting laik dehnya hafu hapm, bot dat noh meen dat da taim fi di en kohn yet. ");
INSERT INTO bzj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lata difrent nayshan ahn kingdom wahn waar gens wan anada. Peepl wahn di staav aal oava ahn lata ertwayk wahn deh da difrent plays. Aala dehn ting deh da jos di biginin a plenti sofarin, jos laik wen wahn pregnant uman di staat tu goh eena layba. ");
INSERT INTO bzj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Unu mos deh pahn unu gyaad kaa dehn wahn han unu oava mek dehn jreg unu da koat ahn flag unu eena di poblik meetn plays dehn. Ahn sayka weh unu bileev eena mee, unu wahn hafu goh fronta govna ahn king anaal. Dis wahn bee unu chaans fi tel dehn di chroot bowt mee. ");
INSERT INTO bzj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Di Gud Nyooz bowt Gaad kingdom hafu preech tu aala di nayshan dehn bifoa di en a di werl kohn. ");
INSERT INTO bzj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wen dehn ares unu ahn kehr unu da koat, unu noh fi wori heda taim bowt weh unu wahn seh fi difen unuself. Jos seh weh Gaad tel unu fi seh wen di taim kohn kaa da noh unu wahn di taak den, bot da di Hoali Spirit. ");
INSERT INTO bzj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Breda wahn di sel owt dehn oan breda mek dehn put dehn tu det; pa wahn sel owt dehn oan pikni; ahn pikni wahn ton gens dehn oan ma ahn pa mek dehn put dehn tu det. ");
INSERT INTO bzj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Evribadi wahn hayt unu sayka weh unu bileev eena mee. Bot Gaad wahn sayv enibadi weh stay faytful tu mee tu di en. ");
INSERT INTO bzj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Bot wan a deez dayz unu wahn si ‘di harabl ting weh Gaad hayt di moas weh kaaz dischrokshan’ di stan op eena di templ wehpaa ih noh bizniz. (Mek evribadi weh reed dis andastan weh ih meen.) Wen unu si dis, mek evribadi weh deh eena Judeeya dischrik hori ron goh da di mongtin dehn. ");
INSERT INTO bzj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","If enibadi deh pahn dehn howstap, noh mek dehn bada kohn dong er goh eena dehn hows fi get owt notn. ");
INSERT INTO bzj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ahn noh mek nobadi weh deh owt eena di feel eevn goh bak goh geh dehn koat. ");
INSERT INTO bzj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Eena dehn dayz deh ih wahn bee harabl fi dehn laydi weh pregnant ahn dehn wan weh ga yong baybi! ");
INSERT INTO bzj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pray Gaad dat unu noh wahn hafu di hori ron joorin koal weda taim er pahn di Sabat. ");
INSERT INTO bzj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Dehndeh dayz deh wahn bee moa terabl dahn eniting weh mi eva deh fahn di biginin wen Gaad mek di werl til tudeh day. Ahn notn laik dat noh wahn eva deh agen. ");
INSERT INTO bzj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bot Gaad mi don kot shaat di amonk a dayz eena dehn taim deh, jos sayka fi hihn speshal wan dehn weh hihn pik. If ih neva du dat, den nobadi wuda lef alaiv. ");
INSERT INTO bzj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Den if enibadi tel unu, ‘Luk! Si di Krais ya!’ er ‘Luk! Si ahn deh!’ unu noh bileev dehn. ");
INSERT INTO bzj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Faals Krais ahn faals prafit wahn kohn ahn perfaam lata big mirakl ahn wandaz fi chrai chrik eevn dehn speshal wan dehn weh Gaad pik, if dat kuda mi hapm. ");
INSERT INTO bzj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Soh, unu deh pahn unu gyaad! Ai don waan unu bowt evriting heda taim. ");
INSERT INTO bzj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Wen di taim a sofarin kohn tu wahn en, ‘di son wahn geh daak daak ahn di moon noh wahn shain. ");
INSERT INTO bzj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Di staar dehn wahn jrap owta di skai, ahn evriting owt eena spays wahn geh shayk op.’ ");
INSERT INTO bzj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Da taim deh peepl wahn si di Son a Man di kom eena di klowd dehn wid lata powa, ahn ih wahn di shain eena aala ih gloari. ");
INSERT INTO bzj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ahn ih wahn sen owt ih aynjel dehn fi gyada aala fi hihn speshal peepl dehn weh hihn pik, fahn wan en a di ert tu di neks. ");
INSERT INTO bzj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Now Ah waahn unu laan wahn lesn fahn di fig chree: wen unu si di branch dehn geh saaf ahn green ahn dehn staat tu put owt leef, unu noa seh dat da nayli taim fi soma. ");
INSERT INTO bzj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sayhn way, wen unu si dehnya ting di hapm, unu wahn noa seh dat di taim fi di Son a Man kohn bak deh kloas kloas, rait da unu doa mowt! ");
INSERT INTO bzj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ah di tel unu di chroot, di peepl dehn fahn dis jenarayshan noh wahn ded owt til aala dehnya ting don hapm. ");
INSERT INTO bzj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","“Hevn ahn ert wahn don weh wid, bot weh Ai di seh wahn stay fareva. ");
INSERT INTO bzj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nobadi noh noa di day ner di owa wen dehn ting wahn hapm. Di aynjel dehn eena hevn noh noa, ahn di Son a Man noh noa needa. Oanli di Faada noa dat. ");
INSERT INTO bzj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Soh unu mos deh pahn unu gyaad. Unu kip pahn di lukowt kaa unu noh noa wen da taim wahn kohn. ");
INSERT INTO bzj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Da laik wahn man weh gwehn weh, ahn ih lef ih servant dehn in chaaj a evriting. Ih lef werk fi mek eech wan a dehn du, ahn ih tel di wan weh main di doa fi kip wach fi wen ih kohn bak. ");
INSERT INTO bzj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Soh unu kip pahn di lukowt kaa unu noh noa wen di oana a di hows wahn kohn bak, weda da eevnin er midl nait er wen day di brok, er wen di son don kom op. ");
INSERT INTO bzj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mek shoar seh ih noh kohn fain unu di sleep. ");
INSERT INTO bzj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Soh weh Ah tel unu, Ah tel evribadi els: Kip wach!” ");
INSERT INTO bzj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Da mi jos too dayz bifoa di Jooish peepl dehn selibrayt di Paasoava ahn di fees weh dehn eet bred weh mek widowt ees. Now di cheef prees dehn ahn dehn wan weh teech di Jooish Laa mi-di chrai fain sohn kaina way fi ares Jeezas ahn kil ahn. ");
INSERT INTO bzj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bot dehn seh, “Wi noh waahn du it wail di selibrayshan di goh aan kaa dat ku spaak aaf raiyat monks di peepl dehn.” ");
INSERT INTO bzj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Now Jeezas mi deh da Betani da Saiman hows. Saiman da wahn man weh mi ga leprosi. Wail Jeezas mi deh rong di taybl, wahn laydi kom een wid wahn batl weh mek owta alabasta stoan. Ih mi ga wahn ekspensiv perfyoom weh mek owta loan naad eena di batl. Ih brok oapm di batl ahn poar di perfyoom pahn Jeezas hed. ");
INSERT INTO bzj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Som a dehn weh mi dehdeh neva laik dat ataal ahn dehn staat tu grombl ahn seh, “Dat da ways a di perfyoom! ");
INSERT INTO bzj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Dehn kuda mi sel dis fi moa dahn weh wan man kuda mek eena wahn hoal yaa. Ahn dehn kuda mi gi di moni tu di poa peepl dehn.” Ahn dehn staat tu tel di laydi lata ting. ");
INSERT INTO bzj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jeezas seh, “Lef di laydi loan noh? Shee du wahn nais ting fi mi. Da sohnting gud ih du tu mi. ");
INSERT INTO bzj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Poa peepl wahn aalwayz deh wid unu, bot unu noh wahn aalwayz ga mee. ");
INSERT INTO bzj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dis laydi du weh shee kuda mi du. Ih gaahn hed ahn poar owt dis perfyoom pahn mi fi geh mi redi fi wen dehn wahn beri mi. ");
INSERT INTO bzj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ah di tel unu di chroot, eniway eena di hoal werl weh dehn preech di Gud Nyooz, dehn wahn memba shee ahn taak bowt weh shee mi du.” ");
INSERT INTO bzj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Den Joodas Iskariyat, weh da-mi wan a di twelv disaipl dehn, gaahn da di cheef prees dehn fi mek ih sel owt Jeezas tu dehn. ");
INSERT INTO bzj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dehn mi kwait hapi fi yehr weh ih kohn deh fa, ahn dehn pramis fi gi ahn moni. Soh ih staat tu luk fi di karek taim wen ih kuda mi sel ahn owt tu dehn. ");
INSERT INTO bzj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Now pahn di fos day a di Paasoava selibrayshan, di day wen dehn kil di lam dehn fi di Paasoava dina, Jeezas disaipl dehn aks ahn seh, “Wehpaa yu waahn wi goh set op fi mek yu eet di Paasoava dina?” ");
INSERT INTO bzj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Soh ih sen too a ih disaipl dehn ahn tel dehn seh, “Goh eena di siti, ahn wahn man weh di bak wahn jog a waata wahn meet unu. Fala ahn. ");
INSERT INTO bzj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wen ih reech di hows weh ih gwehn, tel di oana seh, ‘Di teecha sen wi fi aks yu wehpaa di ges room deh weh ih fi eet di Paasoava dina wid ih disaipl dehn.’ ");
INSERT INTO bzj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Den ih wahn kehr unu da wahn big opstayz room weh gat een evriting weh unu wahn need. Da rait deh unu fi geh di dina redi.” ");
INSERT INTO bzj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Di disaipl dehn lef ahn gaahn da di siti, ahn dehn fain evriting jos laik how Jeezas mi tel dehn. Soh dehn geh di Paasoava dina redi. ");
INSERT INTO bzj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wen eevnin kohn, Jeezas ahn di twelv disaipl dehn reech deh. ");
INSERT INTO bzj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wail dehn mi deh rong di taybl di eet, Jeezas seh, “Ah di tel unu di chroot, wan a unu wahn sel mi owt, ahn da wan a unu weh deh rait ya di eet lang wid mi.” ");
INSERT INTO bzj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Evribadi geh sad sad, ahn wan bai wan dehn aks ahn seh, “Ih kyaahn bee mee, rait?” ");
INSERT INTO bzj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ih ansa seh, “Da wan a unu twelv disaipl weh di dip ih bred eena di bowl wid mi rait now. ");
INSERT INTO bzj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Di Son a Man wahn ded jos laik how di oal taim prafit dehn mi seh, bot loan bad wahn fala di wan weh sel ahn owt. Ih wuda mi beta fi hihn if ih neva eevn baan!” ");
INSERT INTO bzj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wail dehn mi-di eet, Jeezas pik op di bred ahn tank Gaad far it. Den ih brok it ahn gi ih disaipl dehn ahn seh, “Unu tek it. Dis da mai badi.” ");
INSERT INTO bzj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Den ih tek di kop ahn tank Gaad far it; den ih gi ih disaipl dehn, ahn aala dehn jrink fahn it. ");
INSERT INTO bzj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ahn ih tel dehn seh, “Dis da fi mee blod, weh da di nyoo agreement weh Gaad mek wid ih peepl dehn. Dis blod wahn poar owt fi lata peepl. ");
INSERT INTO bzj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ah di tel unu di chroot, Ah noh wahn jrink nohmoh wain til da day wen Ah jrink nyoo wain eena Gaad kingdom.” ");
INSERT INTO bzj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wen dehn don sing wahn him, dehn gaan owt da di hil weh nayhn di Mongt a Alivz. ");
INSERT INTO bzj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jeezas tel dehn seh, “Aala unu wahn ron weh lef mi kaa ih rait dong eena di Skripcha seh, ‘Ah wahn schraik dong di shepad, ahn di sheep dehn wahn skyata.’ ");
INSERT INTO bzj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bot afta Ah don rayz op bak fahn di ded, Ah gwehn heda unu da Gyalilee.” ");
INSERT INTO bzj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peeta seh tu ahn, “Ai wahn neva ron weh lef yoo, noh kay weh di res a dehn du!” ");
INSERT INTO bzj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jeezas tel ahn seh, “Peeta, Ah di tel yu di chroot, tudeh, in fak tunait, bifoa di roosta kroa too taim, yoo wahn disoan mee chree taim.” ");
INSERT INTO bzj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peeta ansa Jeezas seh, “Neva! Eevn if Ah hafu ded wid yu, Ah wahn neva disoan yu!” Ahn aala di ada disaipl dehn seh di sayhn ting. ");
INSERT INTO bzj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ahn dehn gaahn da wahn plays weh nayhn Getsemani. Ahn Jeezas tel ih disaipl dehn seh, “Unu sidong ya wail Ai goh pray.” ");
INSERT INTO bzj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ih kehr Peeta ahn Jaymz ahn Jan lang wid ahn, ahn staat tu feel sad sad ahn ih haat geh hevi hevi. ");
INSERT INTO bzj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Soh ih tel dehn seh, “Mi haat soh hevi dat Ah feel laik Ah wahn ded. Stay ya ahn kip wach wid mi.” ");
INSERT INTO bzj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Den Jeezas gaahn lee wayz hed ahn den ih chroa ihself pahn di grong ahn ih staat tu pray seh, “Faada, if ih pasabl, pleez noh mek Ah goh chroo dis taim a sofarin weh di kohn. Ah noa yoo ku du eniting. Noh mek Ah jrink owta dis kop a sofarin. Bot Ai wahn du wateva yoo waahn, noh weh Ai waahn.” ");
INSERT INTO bzj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Den Jeezas gaahn bak da weh di disaipl dehn mi deh, ahn ih fain dehn di sleep. Ih seh, “Saiman! Yu di sleep, man? Yu kudn stay op wid mi fi jos wan owa? ");
INSERT INTO bzj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kip wach ahn pray soh dat unu noh giv een tu temtayshan. Di spirit wilin bot di badi week.” ");
INSERT INTO bzj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Den ih gaahn bak agen ahn pray di sayhn ting oava agen. ");
INSERT INTO bzj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wen Jeezas gaahn bak, ih fain di disaipl dehn di sleep agen kaa dehn jos kudn kip dehn aiy oapm. Dehn neva noa weh fi seh tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Now Jeezas gaahn bak di terd taim ahn ih aks dehn seh, “Unu stil di sleep ahn di tek unu res? Okay, unu sleep nof now. Si, da nayli taim fi mek dehn sel owt di Son a Man tu peepl weh wikid. ");
INSERT INTO bzj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Unu get op! Mek wi goh! Si di wan weh di sel mi owt ya di kohn!” ");
INSERT INTO bzj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Wail Jeezas stil mi-di taak, Joodas, weh da-mi wan a di twelv disaipl dehn, kom op tu ahn. Wahn krowd a peepl mi deh wid ahn, ahn aala dehn mi ga soad ahn klob. Di cheef prees dehn, ahn dehn wan weh teech di Laa, ahn di Jooish leeda dehn mi sen dehn. ");
INSERT INTO bzj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Now di chrayta mi gi dehn wahn sain. Ih seh, “Di wan weh Ah wahn kis da di man. Ares ahn, ahn kehr ahn weh mek ih noh get weh.” ");
INSERT INTO bzj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sayhn taim ih waak rait op tu Jeezas ahn seh, “Teecha!” ahn ih kis ahn. ");
INSERT INTO bzj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ahn dehn grab Jeezas ahn ares ahn. ");
INSERT INTO bzj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sayhn taim wan a dehn wan weh mi-di stan op deh wid Jeezas haal owt ih soad ahn chap aaf di hai prees servant ayz. ");
INSERT INTO bzj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jeezas aks dehn seh, “Da weh hapm now? Unu kom owt ya wid soad ahn klob fi ares mi laik Ai da sohn kaina kriminal. ");
INSERT INTO bzj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ah mi deh wid unu da di templ evri day di teech ahn unu neva ares mi. Bot weh rait eena di Skripcha hafu kohn chroo.” ");
INSERT INTO bzj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ahn aala di disaipl dehn ton rong ahn ron lef hihn wan deh. ");
INSERT INTO bzj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wahn sertn yong man mi-di fala bihain Jeezas. Aal ih mi-di wayr da-mi wahn pees a linin klaat rap rong ahn. Wen dehn grab ahn, ");
INSERT INTO bzj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ih lef di klaat eena dehn han ahn ron gaahn naykid. ");
INSERT INTO bzj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dehn kehr Jeezas da di hai prees hows. Aala di cheef prees dehn ahn di Jooish leeda dehn, ahn dehn wan weh teech di Jooish Laa mi gyada deh. ");
INSERT INTO bzj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Dis taim now Peeta mi-di fala ahn fahn faar, ahn ih gaahn rait eena di hai prees yaad. Ih sidong wid di gyaad dehn di waam ihself bai di faiya. ");
INSERT INTO bzj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Now di cheef prees ahn di hoal Jooish Kongsl mi-di chrai haad fi fain sohn kaina evidens gens Jeezas, soh dat dehn kuda mi put ahn tu det. Bot dehn kudn fain notn. ");
INSERT INTO bzj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Lata peepl kohn kohn tel lai pan ahn, bot dehn stoari oanli kanchradik op wan anada. ");
INSERT INTO bzj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Ahn pahn di en, som a dehn stan op ahn tel dis lai pan ahn. Dehn seh, “Wee sayhn wan yehr ahn seh, ‘Ah wahn brok dong dis templ weh man bil, ahn eena chree dayz Ah wahn bil bak wahn nada wan weh man noh mek.’” ");
INSERT INTO bzj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bot noh eevn da stoari deh dehn kuda mi geh schrayt monks dehnself. ");
INSERT INTO bzj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Den di hai prees stan op fronta di koat ahn aks Jeezas seh, “Yu noh wahn ansa? Da weh dis weh dehnya peepl di seh gens yu?” ");
INSERT INTO bzj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bot Jeezas kip kwaiyet ahn neva seh wan werd, soh di hai prees aks ahn agen seh, “Yoo da di Krais, weh da Gaad Son?” ");
INSERT INTO bzj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jeezas ansa seh, “Da mee. Ahn yu wahn si di Son a Man di sidong da di plays a aana weh deh pahn di rait han said a Gaad Almaiti, ahn ih di kohn dong pahn di klowd dehn fahn hevn.” ");
INSERT INTO bzj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wen di hai prees yehr dat, ih geh beks ahn tayr ih kloaz. Ih seh, “Wi noh need nohmoh witnis. ");
INSERT INTO bzj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Unu don yehr how ih disrispek Gaad! Soh da weh unu tink?” Ahn aala dehn agree seh ih mi gilti ahn ih dizerv fi ded. ");
INSERT INTO bzj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Den sohn staat tu spit pan ahn, ahn dehn blainfoal ahn, ahn ponch ahn, ahn klong ahn seh, “Laik how yoo da prafit, tel wi da hoo nak yu.” Den di gyaad dehn tek ahn, ahn beet ahn. ");
INSERT INTO bzj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Now az Peeta mi deh dongstayz eena di yaad, wan a di hai prees mayd kohn kloas. ");
INSERT INTO bzj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ahn wen ih si ahn deh di kip waam bai di faiya, ih tek wahn gud luk pan ahn, ahn seh, “Yes! Yoo anaal mi deh wid da man weh nayhn Jeezas.” ");
INSERT INTO bzj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bot Peeta wudn oan op tu it. Ih seh, “Ai noh noa ahn an Ai noh andastan weh yu di taak bowt.” Ahn ih gaan oava bai di waakway. Sayhn taim wahn roosta kroa. ");
INSERT INTO bzj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Di mayd si ahn di stan op deh ahn shee ton rong ahn anonks tu evribadi, “Unu si ahn deh! Hihn da wan a Jeezas disaipl dehn!” ");
INSERT INTO bzj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bot agen Peeta seh dat dat da noh chroo. Afta wahn lee wail, di peepl weh mi deh rong staat tu seh tu Peeta, “Yes, man! Yoo da wan a Jeezas disaipl dehn kaa yoo kohn fahn Gyalilee.” ");
INSERT INTO bzj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peeta seh, “Ah di sway tu unu seh mee noh eevn noa disya man weh unu di taak bowt! Mek Gaad schraik mi dong if Ah noh di tel di chroot.” ");
INSERT INTO bzj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Da sayhn minit di roosta kroa di sekant taim. Den Peeta memba weh Jeezas mi tel ahn: “Bifoa di roosta kroa too taim, yu wahn seh dat yu noh noa mi chree taim.” Ahn ih brok dong ahn staat tu baal. ");
INSERT INTO bzj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Soon soon di neks maanin, di cheef prees dehn, lang wid di Jooish leeda dehn, ahn dehn wan weh teech di Jooish Laa, ahn di hoal Jooish Kongsl get tugeda ahn disaid weh dehn wahn du. Dehn tai op Jeezas, ahn kehr ahn weh, ahn han ahn oava tu Pailat. ");
INSERT INTO bzj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat aks ahn seh, “Yoo da di king a di Jooz?” Ahn Jeezas ansa seh, “Yu rait wen yu seh dat.” ");
INSERT INTO bzj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Di cheef prees dehn akyooz ahn a wahn lata ting. ");
INSERT INTO bzj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Soh Pailat aks ahn agen, “Yu noh wahn ansa? Luk humoch bad ting dehn akyooz yu a.” ");
INSERT INTO bzj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bot Jeezas stil neva seh notn, ahn dat mi sopraiz Pailat. ");
INSERT INTO bzj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Now dehn mi ga wahn ting weh di govna du evri yaa joorin di Paasoava selibrayshan weh ih let goh wahn prizna weh di peepl dehn aks fa. ");
INSERT INTO bzj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Now monks di prizna dehn eena jayl, dehn mi ga sohn weh mi kil sohn peepl wen dehn mi-di chrai fi oavachroa di govament, ahn wan a dehn mi nayhn Baraabas. ");
INSERT INTO bzj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wahn krowd a peepl kom op tu Pailat ahn aks ahn fi mek ih du di sayhn ting laik ih aalwayz du evri yaa. ");
INSERT INTO bzj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Soh Pailat aks dehn seh, “Unu waahn mek Ah let goh ‘di king a di Jooz’ fi unu?” ");
INSERT INTO bzj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat mi wel noa dat da mi sayka dehn mi jelos mek di cheef prees dehn mi han Jeezas oava tu ahn. ");
INSERT INTO bzj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bot di cheef prees dehn ster op di krowd soh dat Pailat ku let goh Baraabas insted. ");
INSERT INTO bzj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Soh ih aks dehn seh, “Weh unu waahn mek Ah du wid dis wan unu kaal di king a di Jooz?” ");
INSERT INTO bzj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dehn hala bak, “Kroosifai ahn!” ");
INSERT INTO bzj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat aks dehn seh, “Wai? Ih komit eni kraim?” Bot dehn hala haada, “Kroosifai ahn!” ");
INSERT INTO bzj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Sayka weh Pailat mi waahn satisfai di krowd, ih let goh Baraabas tu dehn. Soh ih mek di soalja dehn flag Jeezas. Den ih han ahn oava fi mek dehn kroosifai ahn. ");
INSERT INTO bzj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Afta dat di soalja dehn kehr Jeezas da di govna hows (weh dehn kaal di Praytoaryom) ahn den dehn kaal aala di res a soalja dehn tugeda. ");
INSERT INTO bzj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dehn jres ahn op eena wahn perpl gong, ahn dehn mek wahn krong owta prikl bush, ahn put it pahn ih hed. ");
INSERT INTO bzj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dehn staat tu hala owt tu ahn, ahn seh, “Lang liv di king a di Jooz!” ");
INSERT INTO bzj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Dehn stodi mi-di wap ahn kraas ih hed wid wahn pees a stik, ahn dehn spit pan ahn, ahn dehn neel dong fronta ahn laik dehn di wership ahn. ");
INSERT INTO bzj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wen dehn don tek ahn mek nof papishoh, dehn tek aaf di perpl gong ahn put aan bak ih oan kloaz pan ahn, ahn kehr ahn gaahn kroosifai ahn. ");
INSERT INTO bzj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Az dehn mi-di goh lang, dehn meet wahn man weh nayhn Saiman di kohn fahn op konchri. Hihn da-mi fahn wahn siti weh nayhn Saireen, ahn ih da-mi Roofos ahn Alegzanda dehn pa. Di soalja dehn foas ahn fi bak Jeezas kraas far ahn. ");
INSERT INTO bzj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Afta wahn wail dehn kehr Jeezas da wahn plays weh nayhn Galgota, weh meen “Skol Hil.” ");
INSERT INTO bzj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dehn gi Jeezas wain weh miks wid wahn kaina bitaz weh nayhn mer fi jrink, bot ih neva jrink it ataal. ");
INSERT INTO bzj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ahn den dehn kroosifai ahn! Dehn gyambl fi si how dehn mi wahn shayr op ih kloaz monks dehn. ");
INSERT INTO bzj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Da mi bowt nain aklak da maanin wen dehn nayl ahn tu di kraas. ");
INSERT INTO bzj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dehn put op wahn sain weh seh wai dehn mi-di kroosifai ahn. Di sain seh: DI KING A DI JOOZ. ");
INSERT INTO bzj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ahn dehn mi kroosifai too teef lang wid ahn. Dehn put wan pahn ih rait ahn wan pahn ih lef. ");
INSERT INTO bzj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Dis da how di ting weh di oal taim prafit dehn mi seh mi kohn fi hapm, dat dehn mi tek ahn fi bee monks di jayl bod dehn. ");
INSERT INTO bzj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Di peepl dehn weh mi-di paas mi-di hala aal kaina ting aata Jeezas, ahn dehn mi-di shayk dehn hed ahn seh, “Soh, da yoo mi wahn brok dong di templ ahn bil ahn bak eena chree dayz noh? ");
INSERT INTO bzj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Wel, kohn dong fahn aafa di kraas ahn sayv yuself!” ");
INSERT INTO bzj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Di sayhn way, di cheef prees dehn ahn dehn wan weh teech di Laa mi-di klong Jeezas monks dehnself. Dehn seh, “Ih mi sayv ada peepl, bot ih kyaahn eevn sayv ih oanself. ");
INSERT INTO bzj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mek dis Krais, weh da di King a Izrel, kohn dong now fahn aafa di kraas soh dat wi ku si ahn bileev fi wi oanself.” Eevn di teef dehn weh mi kroosifai lang wid ahn staat tu insolt ahn op. ");
INSERT INTO bzj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Den big twelv aklak da day di hoal plays geh daak daak rait op til chree aklak di aftanoon. ");
INSERT INTO bzj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ahn wen chree aklak mi kohn, Jeezas hala owt haad-wan, “Eloi, Eloi, lama sabaktani?” Dat meen “Oa mai Gaad, mai Gaad! Weh mek yu ton yu bak pahn mi?” ");
INSERT INTO bzj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wen som a dehn weh mi-di stan op kloas tu ahn yehr dat, dehn seh, “Yehr deh, ih di hala fi Ilaija.” ");
INSERT INTO bzj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wahn man ron gaahn soak wahn sponj wid wain vineega ahn hais it op pahn wahn stik ahn gi Jeezas fi jrink. Di man seh, “Lef ahn loan now. Mek wi si if Ilaija wahn kohn tek ahn dong.” ");
INSERT INTO bzj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ahn Jeezas baal owt haad-wan ahn jraa ih laas bret. ");
INSERT INTO bzj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Meenwail eena di templ di kertn weh paat aaf di hoaliyis paat fahn di res tayr rait dong fahn tap tu batam. ");
INSERT INTO bzj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Wen di aami aafisa weh mi-di stan op fronta Jeezas yehr ih krai owt, ahn si how ih ded, ih seh, “Dis man da-mi Gaad Son fi chroo!” ");
INSERT INTO bzj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sohn laydi mi dehdeh di luk aan fahn faar. Som a di laydi dehn da-mi Salomi, ahn Mayri Magdaleen, ahn Mayri weh da-mi Joazef ahn Jaymz ma. (Jaymz da-mi ih yongis son.) ");
INSERT INTO bzj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Dehn laydi doz goh rong wid Jeezas ahn ten tu ahn enitaihn ih doz deh da Gyalilee, weh dehn mi kohn fram. Ahn dehn, wid wahn lata ada laydi, mi kohn lang wid ahn tu, da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Da mi di day bifoa di Sabat, wen di Jooish peepl dehn geh redi fi di Sabat day. Da sayhn eevnin deh ");
INSERT INTO bzj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","wahn man weh nayhn Joazef weh kohn fahn Arimateeya, gaahn rait op tu Pailat ahn aks fi Jeezas badi. Hihn da-mi wahn big taim memba a di Jooish Kongsl, ahn ih mi-di luk faawod tu di taim wen Gaad mi wahn set op ih kingdom. ");
INSERT INTO bzj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat mi sopraiz wen ih yehr seh Jeezas mi don ded, soh ih aks di aami aafisa if da mi fi chroo. ");
INSERT INTO bzj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Di aafisa tel Pailat dat Jeezas mi don ded soh Pailat tel Joazef fi kehr di badi. ");
INSERT INTO bzj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joazef tek dong di badi fahn aafa di kraas ahn ih rap it op eena sohn linin klaat weh ih mi bai. Den ih put di badi fi lidong eena wahn toom weh dehn mi dig owta wahn raki hil. Ahn den ih tek wahn big big stoan ahn roal it fronta di hoal. ");
INSERT INTO bzj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Now Mayri Magdaleen ahn Mayri, Joazef ma, mi-di wach fi si weh dehn put Jeezas badi. ");
INSERT INTO bzj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Now wen di Sabat mi don, Mayri Magdaleen ahn Salomi ahn Mayri, weh da Jaymz ma, bai sohn sweet aintment fi put pahn Jeezas badi. ");
INSERT INTO bzj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Soon-wan di Sondeh maanin, jos afta di son kom op, di chree a dehn gaahn da di toom. ");
INSERT INTO bzj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pahn di way dehn mi-di aks wan anada, “Hoo wahn roal weh di stoan fahn fronta di toom fi wi?” ");
INSERT INTO bzj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wen dehn get deh, dehn luk gud pahn di toom ahn si dat di stoan mi don roal weh fahn fronta it aredi! Ahn dis da-mi wahn big big stoan! ");
INSERT INTO bzj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wen dehn gaan eensaida di toom, dehn si wahn yong man weh mi gat aan wahn lang wait gong di sidong pahn di rait han said, ahn dehn mi fraitn no miks! ");
INSERT INTO bzj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Di yong man tel dehn seh, “Noh frayd! Ai noa unu di luk fi Jeezas fahn Nazaret weh dehn mi kroosifai, bot hihn noh deh ya; hihn don rayz op bak fahn di ded! Si, luk wehpaa dehn mi put ih badi. ");
INSERT INTO bzj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Now goh goh tel ih disaipl dehn, espeshali Peeta, dat Jeezas gwehn heda dehn da Gyalilee. Unu wahn si ahn deh jos laik weh ih mi tel unu.” ");
INSERT INTO bzj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wel, di laydi dehn tayr it owta di toom. Dehn mi wel kanfyooz ahn dehn mi-di chrimbl anaal. Dehn neva seh notn tu nobadi, sayka weh dehn mi soh fraitn. ");
INSERT INTO bzj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Soon da Sondeh maanin, wen Jeezas mi don rayz op bak fahn di ded, di fos persn ih apyaa tu da Mayri Magdaleen, di sayhn wan weh ih mi jraiv sebm deeman owta. ");
INSERT INTO bzj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Shee gaahn gaahn tel dehn wan weh yoostu bee wid Jeezas. Ih fain dehn di moan ahn baal. ");
INSERT INTO bzj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wen dehn yehr seh Jeezas mi alaiv ahn dat shee mi si ahn, dehn kudn bileev it. ");
INSERT INTO bzj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Aftawodz Jeezas apyaa tu too peepl weh mi lef fahn Jeroosalem ahn mi-di waak owt eena di konchri. Dehn neva rekonaiz ahn bikaa ih mi luk difrent. ");
INSERT INTO bzj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wen dehn fainali riyalaiz seh da mi hihn, dehn gaahn bak fi tel di res, bot dehn neva bileev dehn needa. ");
INSERT INTO bzj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Afta dat, ih apyaa tu di ilebm disaipl dehn az dehn mi-di eet tugeda. Ahn ih skoal dehn shaap-wan bikaa dehn mi tu stobant ahn dehn neva bileev di peepl dehn weh mi si ahn afta ih rayz op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Den ih tel dehn seh, “Ah waahn unu goh rong di hoal werl ahn preech di Gud Nyooz tu evribadi evriway. ");
INSERT INTO bzj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Evribadi weh bileev ahn geh baptaiz wahn sayv. Bot aala dehn wan weh rifyooz fi bileev wahn geh kandem. ");
INSERT INTO bzj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Dehn wan weh bileev wahn ga dehnya kaina sain di fala dehn: Dehn wahn jraiv owt deeman eena mai naym ahn taak eena nyoo tongz. ");
INSERT INTO bzj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","If dehn pik op snayk er jrink paizn, notn wahn hapm tu dehn. Dehn wahn put dehn han pahn sik peepl ahn heel dehn.” ");
INSERT INTO bzj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Afta Jeezas don taak wid dehn, Gaad kehr ahn op da hevn ahn ih tek ih seet pahn Gaad rait han said. ");
INSERT INTO bzj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ahn di disaipl dehn gaan ahn preech evriway. Ahn di Laad mi deh wid dehn, ahn fi shoa seh di mesij dehn mi-di preech da-mi chroo, ih du mirakl chroo dehn.");
INSERT INTO bzj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Dyaa Misa Tiyofilos, Ah noa dat wahn lata ada peepl mi tek it pahn dehnself fi rait dong aala dehn ting weh mi hapm monks wi weh kansaan Jeezas Krais. ");
INSERT INTO bzj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Dehn rait dong egzakli weh wi mi yehr fahn dehn wan weh mi dehdeh fahn di fos staat—dehn wan weh mi si weh aal mi hapm wid dehn oan aiy, ahn hoo doz preech aal weh Jeezas mi teech. ");
INSERT INTO bzj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Mee miself stodi evriting gud gud fahn di staat, soh Ah mi tink dat da mi wahn gud aidyaa fi mek Ah rait dong evriting fi yu eena aada, Sa, soh dat yu ku mek shoar dat aala di ting dehn weh yu mi laan aredi da-mi reeli chroo. ");
INSERT INTO bzj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Now, eena dehn taim wen Herod da-mi king a Judeeya, dehn mi ga wahn prees weh nayhn Zakaraiya. Hihn mi bilangz tu wahn set a prees weh mi nayhn Abija, ahn ih waif mi nayhn Ilizabet. Di too a dehn mi kohn fahn Ayron famili lain. ");
INSERT INTO bzj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wel, dehn da-mi gud peepl. Dehn neva du notn weh wuda mi mek Gaad beks wid dehn. Dehn fala aala ih laa dehn tu a tee. ");
INSERT INTO bzj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bot dehn neva ga no pikni kaa Ilizabet kudn ga non, ahn bisaidz dat, di too a dehn mi don oal aredi. ");
INSERT INTO bzj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wahn day Zakaraiya groop a prees dehn mi deh pahn jooti, ahn da mi fi hihn tern fi serv eena di templ a Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Akaadn tu how dehn yoostu du it, fi hihn naym geh pik fi goh bon insens pahn di alta eena di templ. ");
INSERT INTO bzj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wen di taim kohn fi hihn goh een fi bon di insens, aala di peepl dehn weh mi kohn fi wership stay owtsaid ahn pray. ");
INSERT INTO bzj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sodn-wan, wahn aynjel fahn di Laad apyaa tu Zakaraiya pahn di rait han said a di alta weh dehn di bon di insens. ");
INSERT INTO bzj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Wen Zakaraiya si ahn, ih jomp weh ih mi soh fraitn. ");
INSERT INTO bzj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Di aynjel seh tu ahn, “Zakaraiya, noh frayd, man! Gaad ansa yu pryaaz. Yu waif Ilizabet wahn ga wahn son, ahn yu mos naym ahn Jan. ");
INSERT INTO bzj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ih oanli wahn mek unu hapi ahn unu haat wahn glad, ahn lata peepl wahn glad tu wen di baybi baan, ");
INSERT INTO bzj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","kaa ih wahn bee wahn impoatant man eena di sait a Gaad. Ih noh fi jrink no kaina wain er lika. Eevn fahn bifoa ih kom owta ih ma beli, ih wahn ful op a di Hoali Spirit. ");
INSERT INTO bzj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Sayka hihn, wahn lata di peepl a Izrel wahn ton bak tu di Laad dehn Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jan wahn dehdeh bifoa di Laad kohn, ahn ih wahn ga di sayhn spirit ahn powa weh di prafit Ilaija mi ga, ahn ih wahn mek di pa dehn haat geh saaf tuwaadz dehn pikni agen. Ahn dehn wan weh mi haad-ayz ahn weh mi ton weh fahn Gaad wahn si sens ahn chaynj dehn wayz ahn liv laik how gud peepl sopoas tu liv. Aala dis mi fi hapm fi geh di peepl dehn redi fi wen di Laad kohn.” ");
INSERT INTO bzj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaraiya aks di aynjel, “How Ai wahn noa dat weh yoo di tel mi da chroo? Ai don oal, ahn mi waif da noh no yong gyal needa.” ");
INSERT INTO bzj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Di aynjel ansa ahn seh, “Ai da Gaybral! Ai aalwayz deh rong Gaad, ahn da hihn sen mee tu yoo fi gi yu dis Gud Nyooz. ");
INSERT INTO bzj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bot sayka weh yu neva bileev weh Ah tel yu, yu wahn dom til wen di rait taim kohn fi mek aal weh Ah tel yu kohn chroo.” ");
INSERT INTO bzj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wail dis mi-di goh aan, di peepl dehn weh mi-di wayt owtsaid staat tu wanda weh mek Zakaraiya tek soh lang eena di templ. ");
INSERT INTO bzj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wen ih kom owt, ih fain owt fi chroo dat ih kudn taak. Fahn di taim dehn si ahn di mek sain aata dehn ahn no werd di kom owta ih mowt, dehn figa dat ih mosi mi si wahn vizhan eena di templ. ");
INSERT INTO bzj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wen ih fainali don aala ih jooti da di templ, ih gaahn hoahn bak. ");
INSERT INTO bzj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Soon afta aala dis hapm, Zakaraiya waif Ilizabet geh pregnant, ahn ih stay lak op hoahn fi faiv monts. ");
INSERT INTO bzj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ih seh tu ihself, “Ah noa dat di Laad du dis fi mi. At laas ih smail pahn mi ahn dig shaym owta mi fays.” ");
INSERT INTO bzj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Siks monts afta Ilizabet geh pregnant, Gaad sen di aynjel Gaybral da Nazaret, weh da wahn lee tong eena Gyalilee. ");
INSERT INTO bzj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ih sen ahn tu wahn lee yong laydi weh nayhn Mayri weh da-mi wahn verjin. Shee mi ingayj tu wahn man weh mi nayhn Joazef. Hihn mi kohn fahn King Dayvid famili lain. ");
INSERT INTO bzj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Wen Gaybral apyaa tu Mayri, ih seh, “Heloa! Di Laad deh wid yu, ahn ih oanli di smail pahn yu.” ");
INSERT INTO bzj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mayri mi wel kanfyooz wen ih yehr dat, ahn seh tu ihself, “Ah wanda weh hihn meen bai dat?” ");
INSERT INTO bzj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Bot Gaybral seh, “Noh frayd, Mayri. Gaad pleez wid yu. ");
INSERT INTO bzj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yu wahn ga wahn lee baybi bwai, ahn wen ih baan, yu fi naym ahn Jeezas. ");
INSERT INTO bzj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hihn wahn bee grayt, ahn dehn wahn kaal ahn di Son a di moas hai Gaad. Di Laad Gaad wahn gi ahn ih grayt-grayt-grayt-granfaada Dayvid chroan. ");
INSERT INTO bzj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ih wahn rool oava di peepl a Izrel dehn fareva, ahn fi hihn kingdom wahn neva kohn tu wahn en.” ");
INSERT INTO bzj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mayri aks di aynjel, “Bot da how dis wahn hapm? Ai da stil wahn verjin.” ");
INSERT INTO bzj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Di aynjel seh, “Di Hoali Spirit wahn kohn pahn yu, ahn di powa a di moas hai Gaad wahn kova yu. Dats wai dehn wahn kaal dis hoali baybi Gaad Son. ");
INSERT INTO bzj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Az a mata a fak, eevn yu faamli Ilizabet, weh don oal ahn kudn ga no baybi, siks monts pregnant rait now! ");
INSERT INTO bzj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yu si, notn noh deh weh Gaad kyaahn du.” ");
INSERT INTO bzj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mayri seh, “Ai da di Laad servant. Mek evriting hapm tu mi jos laik how yu seh.” Den di aynjel lef ahn. ");
INSERT INTO bzj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wahn lee wail afta dat, Mayri geh redi ahn ih mikays gaahn da wahn tong weh mi deh monks di hil dehn da Judeeya, ");
INSERT INTO bzj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","weh Zakaraiya ahn Ilizabet mi liv. Wen ih reech dehn hows, ih gaan eensaid ahn hayl Ilizabet. ");
INSERT INTO bzj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Az soon az Ilizabet yehr Mayri vais, di baybi jomp eena ih beli ahn Ilizabet geh ful op a di Hoali Spirit. ");
INSERT INTO bzj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ih bos owt ahn seh, “Gyal, owta aala di laydi dehn, yoo da di wan weh Gaad bles di moas, ahn ih bles di baybi weh yu wahn baan tu. ");
INSERT INTO bzj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Bot da hoo mee soh fi mek mi Laad ma kohn luk fi mee? ");
INSERT INTO bzj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Fahn di taim Ah yehr yu vais, di baybi jomp eena mi beli weh ih mi soh glad. ");
INSERT INTO bzj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gaad bles yu kaa yu bileev dat weh ih tel yu wahn kohn chroo!” ");
INSERT INTO bzj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Den Mayri seh, “Ah prayz di Laad wid aal weh Ah ga, ");
INSERT INTO bzj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ahn mi spirit oanli di rijais sayka Gaad mi Sayvya, ");
INSERT INTO bzj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kaa ih memba mee, weh da ih hombl servant. Fahn ya goh bak, evri jenarayshan wahn seh dat Gaad oanli bles mi. ");
INSERT INTO bzj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kaa Gaad Almaiti du wandaful tingz fi mi, ahn fi hihn naym hoali! ");
INSERT INTO bzj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ih shoa mersi tu evribadi weh rispek ahn, fahn wan jenarayshan tu di neks. ");
INSERT INTO bzj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wid ih oan han ih du wahn lata powaful ting. Dehn hai ahn maiti wan weh tink dehn deh op deh, ih bring dehn dong tu notn. ");
INSERT INTO bzj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ih eevn tek dong king fahn aafa dehn chroan, bot ih rayz op aala dehn wan weh hombl. ");
INSERT INTO bzj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dehn hongri beli wan, ih gi dehn nof gud ting fi eet, bot di rich wan dehn, ih sen dehn weh wid dehn too lang han di heng dong da dehn said. ");
INSERT INTO bzj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ih mi help ih servant Izrel; ih mi memba fi shoa mersi tu ahn. ");
INSERT INTO bzj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kaa ih mi pramis fi help Aybraham ahn shoa mersi tu aala ih jenarayshan dehn kohn rait dong.” ");
INSERT INTO bzj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mayri stay deh wid Ilizabet fi bowt chree monts, den ih gaahn hoahn bak. ");
INSERT INTO bzj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Now di taim kohn fi Ilizabet baan di baybi, ahn ih ga wahn son. ");
INSERT INTO bzj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wen ih nayba ahn ih faamli dehn yehr dat Gaad mi soh kain tu shee, dehn mi oanli rijais lang wid ahn. ");
INSERT INTO bzj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wen di baybi mi ayt dayz oal, dehn kohn fi serkomsaiz ahn, ahn dehn mi waahn naym ahn Zakaraiya, afta ih pa, ");
INSERT INTO bzj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","bot ih ma seh, “No! Ih wahn nayhn Jan.” ");
INSERT INTO bzj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Di peepl dehn seh, “Jan! Bot nobadi eena fi yu faamli nayhn soh.” ");
INSERT INTO bzj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Soh dehn mek sain tu Zakaraiya fi aks ahn weh hihn waahn naym di baybi. ");
INSERT INTO bzj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ih aks fi sohnting fi rait pan, ahn dehn mowt jrap oapm wen ih rait, “Di baybi naym da Jan.” ");
INSERT INTO bzj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Az soon az Zakaraiya rait dong di baybi naym, ih tong geh loos ahn ih kuda mi taak agen, ahn ih staat tu prayz Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aal di nayba dehn mi fraitn no miks sayka weh mi hapm, ahn peepl mi-di taak bowt it aal oava di hil dehn da Judeeya. ");
INSERT INTO bzj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Evribadi weh yehr bowt it mi-di wanda ahn seh, “Da weh kaina pikni dis wan wahn bee?” Kaa Gaad han mi deh pan ahn fi chroo. ");
INSERT INTO bzj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Den di Hoali Spirit tek kanchroal a Zakaraiya, di baybi pa, ahn ih staat tu seh weh Gaad mi tel ahn mi wahn hapm. Ih seh, ");
INSERT INTO bzj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Prayz di Laad Gaad a Izrel, kaa ih kohn tu ih peepl dehn ahn set dehn free. ");
INSERT INTO bzj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ih rayz op wahn maiti Sayvya fahn King Dayvid famili lain, ");
INSERT INTO bzj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","jos laik weh ih mi seh chroo ih hoali prafit dehn fahn way bak. ");
INSERT INTO bzj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ih pramis fi sayv wi fahn aala wi enimi dehn, ahn fahn aala dehn wan weh hayt wi. ");
INSERT INTO bzj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Dat da how ih mi shoa mersi tu wi ansesta dehn, ahn ih neva faget di agreement weh ih mek wid dehn. ");
INSERT INTO bzj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ih mek wahn oat tu wi grayt-grayt-grayt-granfaada Aybraham, ");
INSERT INTO bzj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","fi sayv wi fahn wi enimi soh dat wi ku serv ahn widowt feel frayd, ");
INSERT INTO bzj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ahn wi haat ku bee hoali ahn rait eena Gaad sait fi di hoal a wi laif. ");
INSERT INTO bzj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mi lee son, dehn wahn kaal yu wahn prafit a di moas hai Gaad, bikaa yoo gwehn heda di Laad fi mek di way redi far ahn. ");
INSERT INTO bzj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ahn yu wahn tel ih peepl dehn dat wen Gaad fagiv dehn sin dehn, dehn wahn geh sayv. ");
INSERT INTO bzj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sayka weh Gaad haat saaf ahn weh ih ga lata mersi, ih wahn sen di Lait tu wi fahn hevn, jos laik how ih sen di maanin son fi shain pahn wi. ");
INSERT INTO bzj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Hihn wahn shain brait-wan pahn dehn wan weh di liv eena daaknis, ahn weh det di heng oava laik wahn shado. Ih wahn gaid wi fut fi waak eena wahn peesful way.” ");
INSERT INTO bzj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Soh di lee bwai Jan geh big ahn ih spirit geh schrang. Ih liv owt eena di dezert til wen di taim kohn fi mek ih kom owt ahn preech tu di peepl a Izrel dehn eena poblik. ");
INSERT INTO bzj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Now, wen da mi nayli taim fi Jeezas baan, Seeza Agostos, weh da-mi di king a Roam, mek wahn laa weh seh dat evribadi eena aala di konchri dehn weh di Roaman govament mi-di rool oava, hafu rejista soh dat dehn kuda mi taks dehn. ");
INSERT INTO bzj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Dis da-mi di fos taim dehn mi-di du sohnting laik dat. Da mi eena di taim wen Kireenyos da-mi govna a Siriya. ");
INSERT INTO bzj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Evribadi mi hafu goh bak da dehn oan hoamtong fi goh rejista. ");
INSERT INTO bzj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Soh Joazef mi hafu lef fahn Nazaret Tong eena Gyalilee weh ih mi liv, ahn goh way op da Betlihem Tong weh deh eena Judeeya. Dis da di tong weh King Dayvid mi kohn fram, ahn Joazef gaahn deh kaa hihn mi kohn fahn King Dayvid famili lain. ");
INSERT INTO bzj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Joazef gaahn rejista wid Mayri, weh ih mi ingayj tu. Shee mi pregnant, ");
INSERT INTO bzj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ahn wail dehn mi dehdeh, di taim kohn fi Mayri ga baybi. ");
INSERT INTO bzj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Soh ih ga ih fos pikni, weh da-mi wahn son. Ih rap ahn op ahn put ahn fi lidong eena wahn boad baks weh di animal dehn eet owta kaa no spays neva deh eena di hotel fi dehn stay. ");
INSERT INTO bzj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Now, sohn shepad weh mi-di liv owt eena di feel dehn eena da sayhn ayrya mi-di main dehn sheep joorin di nait. ");
INSERT INTO bzj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sodn-wan wahn aynjel fahn di Laad apyaa fronta dehn ahn di braitnis a Gaad lait op di hoal plays rong dehn. Di shepad dehn mi oanli fraitn. ");
INSERT INTO bzj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bot di aynjel seh, “Unu noh hafu frayd. Ah ga sohn gud nyooz weh oanli wahn mek evribadi hapi. ");
INSERT INTO bzj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tudeh tudeh, rait ya da King Dayvid tong, wahn Sayvya jos baan. Hihn da di Laad, di Krais weh Gaad mi pramis fi sen. ");
INSERT INTO bzj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dis da how unu wahn noa ahn: Unu wahn fain di baybi rap op ahn di lidong eena wahn feedn baks.” ");
INSERT INTO bzj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sodn-wan wahn hoal krowd a aynjel fahn hevn apyaa lang wid di fos wan, ahn aala dehn staat tu prayz Gaad ahn seh, ");
INSERT INTO bzj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mek di hoal werl aana Gaad, weh deh hai op eena hevn! Mek pees kohn tu evribadi pahn ert weh pleez ahn.” ");
INSERT INTO bzj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wen di aynjel dehn lef dehn ahn gaahn bak op da hevn, di shepad dehn seh tu wan anada, “Mek wi goh da Betlihem goh si dis ting weh hapm weh Gaad tel wi bowt.” ");
INSERT INTO bzj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Soh dehn mikays ahn gaan, ahn dehn fain Mayri ahn Joazef, ahn dehn si di baybi di lidong eena di feedn baks fi chroo. ");
INSERT INTO bzj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Afta dehn si di baybi, dehn tel evribadi weh di aynjel mi tel dehn bowt ahn. ");
INSERT INTO bzj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ahn wen evribadi yehr weh di shepad dehn tel dehn, dehn seh, “Wat a ting, ay!” ");
INSERT INTO bzj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Bot Mayri kip een evriting eena ih haat, ahn stodi mi-di tink bowt it tu ihself. ");
INSERT INTO bzj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Di shepad dehn gaahn hoahn bak di prayz ahn aana Gaad fi aal weh dehn mi si ahn yehr kaa evriting hapm jos laik how di aynjel tel dehn. ");
INSERT INTO bzj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ayt dayz afta di baybi baan, da mi taim fi serkomsaiz ahn, ahn dehn naym ahn Jeezas. Dis da di sayhn naym weh di aynjel mi tel Mayri fi gi di baybi bifoa ih mi eevn geh pregnant wid ahn. ");
INSERT INTO bzj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Den di taim kohn fi Mayri ahn Joazef goh op da di templ fi wahn serimoni fi mek Mayri kleen akaadn tu di Laa weh Gaad gi Moaziz. Dehn kehr di baybi da Jeroosalem fi dedikayt ahn tu di Laad, ");
INSERT INTO bzj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kaa Gaad Laa seh, “Evri fos baan bwai pikni bilangz tu di Laad.” ");
INSERT INTO bzj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ahn di Laa seh tu dat di ma ahn pa hafu bring “too dov er too lee yong pijin” fi sakrifais; ahn dat da weh Mayri ahn Joazef du. ");
INSERT INTO bzj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Now dehn mi ga wahn man da Jeroosalem weh mi nayhn Simiyan. Hihn da-mi wahn hoali man weh doz aalwayz obay Gaad ahn ih mi-di luk faawod tu di taim wen Gaad mi wahn mek tingz rait eena Izrel. Di Spirit a Gaad mi deh pahn hihn, ");
INSERT INTO bzj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ahn ih tel ahn dat ih neva mi wahn ded til ih si di Krais weh di Laad Gaad mi pramis fi sen. ");
INSERT INTO bzj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Da sayhn day wen Mayri ahn Joazef kehr Jeezas da di templ fi du weh di Laa seh, di Spirit tel Simiyan fi goh deh tu. ");
INSERT INTO bzj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyan hoal di baybi eena ih han ahn prayz Gaad ahn seh, ");
INSERT INTO bzj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Laad Gaad, now yu ku mek yu servant ded in pees, laik how yu don kip yu pramis tu mi. ");
INSERT INTO bzj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ah don si di Wan weh yu sen fi sayv wi wid mi oan aiy, ");
INSERT INTO bzj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","di Wan weh yu pripyaa fi mek di peepl eena di hoal werl si. ");
INSERT INTO bzj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ih da wahn Lait weh wahn shoa aala di ada nayshan dehn da hoo yoo, ahn ih wahn bring aana tu yu peepl Izrel.” ");
INSERT INTO bzj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jeezas ma ahn pa mi sopraiz fi yehr weh aal Simiyan mi-di seh bowt ahn. ");
INSERT INTO bzj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyan bles dehn, ahn den ih tel Mayri seh, “Sayka dis pikni ya, wahn lata peepl eena Izrel wahn rijek Gaad ahn faal, bot wahn lat wahn ton tu Gaad tu, ahn hihn wahn rayz dehn op. Ih wahn bee wahn sain fi waan peepl, bot lata dehn wahn taak gens ahn. ");
INSERT INTO bzj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Sayka hihn, aala dehn ting weh peepl di hoal deep dong eena dehn haat wahn kom owt eena di oapm. Ahn Mayri, wen aala dehn ting hapm, yoo yuself wahn feel laik dehn shub wahn lang naif eena yu haat.” ");
INSERT INTO bzj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Wahn oal laydi weh nayhn Ana, mi deh da di templ tu. Shee da-mi wahn prafit, ahn fi shee pa da-mi Fanwel fahn di chraib a Asha. Ih mi oanli marid fi sebm yaaz wen ih hozban ded. Now ih mi ayti-foa yaaz oal ahn ih spen aala ih taim da di templ, nait ahn day di faas ahn pray, ahn di wership Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sayhn taim wail Simiyan mi-di taak tu Mayri ahn Joazef, dis Ana kom op tu dehn ahn staat tu prayz Gaad, ahn ih staat taak bowt di pikni tu evribadi weh mi-di luk owt fi wen Gaad mi wahn sayv Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wen Mayri ahn Joazef don du weh Gaad Laa seh fi du, dehn gaahn bak da Nazaret, dehn oan tong da Gyalilee. ");
INSERT INTO bzj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ahn soh di pikni geh big ahn schrang, ahn ih mi oanli waiz. Ahn Gaad bles ahn eena evriting weh ih du. ");
INSERT INTO bzj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Now evri yaa Jeezas ma ahn pa yoostu goh da Jeroosalem fi selibrayt di Paasoava. ");
INSERT INTO bzj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wen Jeezas mi twelv yaaz oal, dehn gaan op fi di selibrayshan laik weh dehn mi aalwayz du. ");
INSERT INTO bzj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Afta di hoal ting don, Mayri ahn Joazef mi deh pahn dehn way bak hoahn. Bot Jeezas stay bak da Jeroosalem widowt dehn mi eevn noa. ");
INSERT INTO bzj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Dehn chravl fi wahn hoal day kaa dehn mi tek it fi grantid dat ih mi-di kohn lang wid di peepl dehn weh dehn mi-di chravl wid. Bot wen dehn staat tu luk far ahn monks dehn faamli ahn fren dehn, ");
INSERT INTO bzj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","da den dehn riyalaiz dat ih misn. Soh dehn ton rong ahn gaahn way bak da Jeroosalem fi luk far ahn. ");
INSERT INTO bzj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Chree dayz layta dehn fain ahn eena di templ, di sidong monks di Jooish teecha dehn. Ih mi-di lisn tu dehn ahn di aks dehn aal kaina kweschan. ");
INSERT INTO bzj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Evribadi weh mi-di lisn tu di lee bwai mi shak fi si how brait ih mi brait, ahn how ih mi-di ansa op aala dehn kweschan. ");
INSERT INTO bzj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ih ma ahn ih pa mi oanli sopraiz wen dehn si ahn, ahn ih ma seh tu ahn, “Son, da weh yu du dis tu wi fa? Yoo neva noa seh dat mee ahn yu pa wuda di wori bowt yu, ahn wi wuda di luk aal oava di plays fi yu?” ");
INSERT INTO bzj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jeezas aks dehn seh, “Da weh unu di luk fi mi fa? Unu noh noa dat Ai hafu deh eena mi Faada hows?” ");
INSERT INTO bzj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bot dehn neva andastan weh ih mi-di taak bowt. ");
INSERT INTO bzj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Eniway, ih gaahn bak da Nazaret wid dehn ahn ih mi obeedyant tu dehn. Ih ma kip aala dehn ting deh weh mi hapm eena ih haat. ");
INSERT INTO bzj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Az Jeezas mi-di geh biga, ih geh waiza ahn waiza, ahn Gaad ahn evribadi mi lov ahn. ");
INSERT INTO bzj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Now Jan, weh da-mi Zakaraiya son, mi-di liv eena di dezert wen ih geh wahn mesij fahn Gaad. Dis hapm fifteen yaaz afta Taibeeryos mi ton king oava di hoal a Roam. Dehnya da di man dehn weh mi deh anda hihn: Ponchos Pailat, weh da-mi govna a Judeeya; Herod, weh mi-di rool Gyalilee; Herod breda Filip, weh mi-di rool oava Itoorya ahn Chrakonaitis; ahn Lisanaiyas, weh mi-di rool Abileen. Da sayhn taim Anas ahn Kaiyafas da-mi di Jooz dehn hai prees. ");
INSERT INTO bzj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Afta Jan geh di mesij fahn Gaad, ih gaan aal oava di konchrisaid rong Jaadn Riva di tel evribadi, “Unu mos geh baptaiz fi shoa seh dat unu ton fahn unu sin dehn ahn dat Gaad fagiv unu.” ");
INSERT INTO bzj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dis da weh Aizaiya di prafit mi rait bowt wen ih seh, “Hihn da wahn vais weh di hala owt eena di dezert di seh, ‘Unu geh redi fi wen di Laad kohn, ahn mek di road dehn schrayt far ahn. ");
INSERT INTO bzj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Evri vali wahn geh ful op, ahn evri mongtin ahn hil wahn geh flatn owt. Aala dehn krukid road wahn geh schraytn owt, ahn di rof plays dehn wahn geh smood. ");
INSERT INTO bzj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Den di hoal werl wahn si dat Gaad sayv peepl fahn dehn sin.’” ");
INSERT INTO bzj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Wahn krowd a peepl mi-di kohn tu Jan fi geh baptaiz, ahn ih tel dehn seh, “Unu da snayk ahn unu pa dehn da-mi snayk tu! Da hoo waan unu fi ron fahn Gaad jojment weh di kohn? ");
INSERT INTO bzj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","If unu sari fi unu sin dehn fi chroo, proov it bai di way yu liv. Ahn noh eevn chrai fool unuself ahn tink seh dat bikaa unu kohn fahn Aybraham famili lain, dat mek unu aarait wid Gaad. Ai di tel unu, Gaad ku tek dehnya stoan dong ya ahn mek Aybraham pikni owta dehn. ");
INSERT INTO bzj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Unu da jos laik chree, ahn Gaad don ga di aks da di root. Ih wahn chap dong ahn bon op eni chree weh noh di bayr.” ");
INSERT INTO bzj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Di krowd aks Jan, “Wel den, da weh wi fi du?” ");
INSERT INTO bzj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jan ansa dehn seh, “Enibadi weh ga too shot, dehn fi shayr wid dehn wan weh noh ga non. Ahn enibadi weh ga ting fi eet, dehn fi shayr wid hoo noh ga.” ");
INSERT INTO bzj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Di taks kalekta dehn anaal mi-di kohn fi geh baptaiz, ahn dehn aks ahn seh, “Teecha, da weh wee fi du?” ");
INSERT INTO bzj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ih tel dehn seh, “Noh kalek moa moni fahn peepl dahn weh unu sopoas tu.” ");
INSERT INTO bzj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Eevn sohn soalja aks ahn seh, “Ahn weh wee fi du?” Jan seh, “Stap di schrang di peepl dehn moni fahn dehn, ahn stap tel lai pahn dehn. Unu mos satisfai wid di pay weh unu geh.” ");
INSERT INTO bzj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Di peepl dehn mi-di staat tu geh eksaitid ahn mi-di wanda if Jan da-mi di Krais weh Gaad mi pramis fi sen. ");
INSERT INTO bzj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Soh Jan tel dehn seh, “Ai di baptaiz unu wid waata, bot sohnbadi els weh eevn moa powaful dahn mee wahn soon kohn. Ai noh eevn gud nof fi loos fi hihn shooz laysn. Hihn wahn baptaiz unu wid di Hoali Spirit ahn wid faiya. ");
INSERT INTO bzj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jos laik wahn faama, ih don gat ih fan eena ih han, ahn ih redi fi fan aala di chrash owta di weet. Ih wahn gyada op aala di gud paat ahn put it op, bot ih wahn bon op di chrash eena wahn faiya weh kyaahn owt.” ");
INSERT INTO bzj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jan tel di peepl dehn wahn lata ada ting fi mek dehn aksep di Gud Nyooz. ");
INSERT INTO bzj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wahn nada taim, Jan mi tel King Herod bowt ihself sayka weh mi-di goh aan bitween Herod ahn Heroadyas, weh da-mi Herod breda waif. Ih mi eevn tel ahn bowt aala di ada bad ting dehn weh ih mi-di du. ");
INSERT INTO bzj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pahn tap a aala di wikidnis weh Herod du, ih pich Jan eena jayl. ");
INSERT INTO bzj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wahn day wen di peepl dehn mi-di geh baptaiz, Jeezas geh baptaiz tu. Wail ih mi-di pray, hevn oapm op, ");
INSERT INTO bzj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ahn di Hoali Spirit kohn dong eena di shayp a wahn dov ahn pich pan ahn. Sayhn taim wahn vais fahn hevn seh, “Yoo da mi Son weh Ah oanli lov, an Ah oanli pleez wid yu.” ");
INSERT INTO bzj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jeezas mi bowt terti yaaz oal wen ih staat di werk weh Gaad sen ahn fi du. Evribadi mi tek it fi grantid dat Jeezas da-mi Joazef son. Joazef da-mi Heli son. ");
INSERT INTO bzj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli da-mi Matat son. Matat da-mi Leevai son. Leevai da-mi Melki son. Melki da-mi Janai son. Janai da-mi Joazef son. ");
INSERT INTO bzj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joazef da-mi Matatayas son. Matatayas da-mi Aymos son. Aymos da-mi Nayhum son. Nayhum da-mi Esli son. Esli da-mi Nagai son. ");
INSERT INTO bzj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai da-mi Maat son. Maat da-mi Matatayas son. Matatayas da-mi Semeyin son. Semeyin da-mi Joasek son. Joasek da-mi Joada son. ");
INSERT INTO bzj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joada da-mi Joanan son. Joanan da-mi Reesa son. Reesa da-mi Zerubabel son. Zerubabel da-mi Sheyaltyel son. Sheyaltyel da-mi Neri son. ");
INSERT INTO bzj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri da-mi Melki son. Melki da-mi Adi son. Adi da-mi Kosam son. Kosam da-mi Elmadam son. Elmadam da-mi Er son. ");
INSERT INTO bzj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er da-mi Jashwa son. Jashwa da-mi Eliyezr son. Eliyezr da-mi Jorim son. Jorim da-mi Matat son. Matat da-mi Leevai son. ");
INSERT INTO bzj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leevai da-mi Simiyan son. Simiyan da-mi Jooda son. Jooda da-mi Joazef son. Joazef da-mi Jonam son. Jonam da-mi Elyakim son. ");
INSERT INTO bzj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim da-mi Meli son. Meli da-mi Mena son. Mena da-mi Matata son. Matata da-mi Naytan son. Naytan da-mi Dayvid son. ");
INSERT INTO bzj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dayvid da-mi Jesi son. Jesi da-mi Obed son. Obed da-mi Bowaz son. Bowaz da-mi Salmon son. Salmon da-mi Nashon son. ");
INSERT INTO bzj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon da-mi Aminadab son. Aminadab da-mi Admi son. Admi da-mi Arni son. Arni da-mi Hezron son. Hezron da-mi Perez son. Perez da-mi Jooda son. ");
INSERT INTO bzj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jooda da-mi Jaykop son. Jaykop da-mi Aizak son. Aizak da-mi Aybraham son. Aybraham da-mi Tera son. Tera da-mi Nayhor son. ");
INSERT INTO bzj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nayhor da-mi Serog son. Serog da-mi Roo son. Roo da-mi Peleg son. Peleg da-mi Eeber son. Eeber da-mi Sheela son. ");
INSERT INTO bzj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sheela da-mi Kaynan son. Kaynan da-mi Arfaksad son. Arfaksad da-mi Shem son. Shem da-mi Noawa son. Noawa da-mi Lamek son. ");
INSERT INTO bzj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek da-mi Metoosela son. Metoosela da-mi Eenak son. Eenak da-mi Jared son. Jared da-mi Mahalalel son. Mahalalel da-mi Kenan son. ");
INSERT INTO bzj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan da-mi Eenosh son. Eenosh da-mi Set son. Set da-mi Adam son. Adam da-mi Gaad son. ");
INSERT INTO bzj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Wen Jeezas kohn bak fahn Jaadn Riva, ih mi ful op wid di Hoali Spirit. Ahn di Spirit leed ahn da di dezert, wehpaa ih stay fi faati dayz. Joorin da hoal taim deh di devl neva play fi temp ahn. Pahn tap a dat, ih mi hongri bad kaa ih mi-di faas fi di hoal faati dayz. ");
INSERT INTO bzj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Di devl seh tu ahn, “If yoo da Gaad Son fi chroo, tel disya stoan fi ton intu bred.” ");
INSERT INTO bzj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jeezas ansa seh, “Ih rait dong eena di Skripcha seh, ‘Da noh oanli bred yu need fi mek yu liv.’” ");
INSERT INTO bzj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Den di devl kehr ahn op da wahn hai hai plays soh dat ih ku luk dong ahn si aala di konchri dehn a di werl, wan lik. ");
INSERT INTO bzj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ih tel ahn seh, “Ai wahn gi yu aala di powa ahn richiz weh yu si ya kaa da fi mee, an Ai ku gi enibadi weh Ai waahn. ");
INSERT INTO bzj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aal weh yu hafu du da bow dong ahn wership mee, den aala dis wahn bee fi yoo.” ");
INSERT INTO bzj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bot Jeezas tel ahn seh, “Ih rait dong eena di Skripcha seh, ‘Gaad da di oanli wan yu fi wership, ahn da oanli hihn wan yu fi serv.’” ");
INSERT INTO bzj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Afta dat di devl leed Jeezas tu Jeroosalem, ahn mek ih stan op pahn di tip tap a di templ ahn tel ahn seh, “If yoo da Gaad Son fi chroo chroo, chroa dong yuself fahn ya. ");
INSERT INTO bzj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Aftaraal, ih rait dong eena di Skripcha seh, ‘Gaad wahn gi fi hihn aynjel dehn aadaz fi tek gud kayr a yu, ");
INSERT INTO bzj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ahn dehn wahn kech yu soh dat yu noh eevn wahn lik yu fut gens wahn stoan.’” ");
INSERT INTO bzj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jeezas ansa seh, “Di Skripcha seh tu, ‘Yu noh fi chrai tes di Laad yu Gaad.’” ");
INSERT INTO bzj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Wen di devl taiyad a chrai fain aal kaina way fi temp ahn, ih lef ahn loan til wahn neks taim. ");
INSERT INTO bzj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jeezas gaahn bak da Gyalilee anda di powa a di Hoali Spirit. Evribadi staat tu taak bowt ahn aal oava di plays. ");
INSERT INTO bzj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ih mi-di teech eena dehn sinagag dehn, ahn evribadi mi-di seh gud tingz bowt ahn. ");
INSERT INTO bzj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ih gaahn bak da Nazaret, weh da-mi ih hoamtong. Ih gaan eena di sinagag pahn di Sabat jos laik how ih doz aalwayz du. Den ih stan op fi reed, ");
INSERT INTO bzj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ahn dehn han ahn di paat a Gaad Werd weh di prafit Aizaiya rait. Ih oapm it op ahn reed fahn di plays weh seh, ");
INSERT INTO bzj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Gaad Spirit deh pahn mi, sayka weh ih pik mi fi preech di Gud Nyooz tu di poa peepl dehn. Ih sen mi fi tel di prizna dehn dat dehn wahn free, ahn fi tel blain peepl dat dehn wahn si. Ahn aala unu weh dehn chaans op wahn geh free. ");
INSERT INTO bzj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Dis da di taim wen Gaad wahn smail pahn ih peepl dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Afta Jeezas don reed, ih roal op di paypa, han it bak tu di man in chaaj, ahn sidong. Evri aiy eena di sinagag mi faasn pan ahn. ");
INSERT INTO bzj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ih tel dehn seh, “Tudeh tudeh, dis sed Skripcha weh unu yehr Ah jos don reed kohn chroo.” ");
INSERT INTO bzj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Evribadi mi taak gud bowt ahn, ahn dehn mi oanli sopraiz bowt aala di nais werd dehn weh mi-di kom owta ih mowt. Bot som a dehn aks, “Bot wayt! Dis da noh Joazef son?” ");
INSERT INTO bzj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jeezas tel dehn seh, “Ah noa unu wahn bring op da praverb weh seh, ‘Dakta, heel yuself.’ Unu wahn tel mi, ‘Wi yehr bowt aal weh yu du da Kapernyam. Soh wai yu noh du di sayhn ting ya da yu oan hoamtong?’” ");
INSERT INTO bzj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Ah di tel unu di chroot, wahn prafit neva geh no rispek da ih oan hoamtong! ");
INSERT INTO bzj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Fi chroo, eena Ilaija dayz, wentaim ih neva rayn fi hoal a chree an a haaf yaaz schrayt ahn notn neva deh no way fi eet, wahn lata ada wido mi deh da Izrel weh Ilaija kuda mi gaahn tu. ");
INSERT INTO bzj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bot Gaad neva sen ahn tu non a dehn. Ih sen ahn tu wan wido weh mi liv way da Zarepat weh deh eena Saidan! ");
INSERT INTO bzj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Joorin Ilaisha di prafit taim, wahn lata peepl da Izrel mi ga leprosi. Bot non a dehn neva geh heel eksep Nayman, weh mi kohn fahn Siriya.” ");
INSERT INTO bzj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wen di peepl dehn weh mi deh da di sinagag yehr dis, dehn geh beks bad! ");
INSERT INTO bzj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dehn jomp op ahn jraiv ahn owta di tong, ahn kehr ahn da tap a di hil weh di tong mi bil pan, fi shub ahn aafa di ej. ");
INSERT INTO bzj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bot Jeezas waak rait chroo di krowd ahn gaahn bowt ih bizniz. ");
INSERT INTO bzj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Afta dat Jeezas gaahn dong da wahn tong eena Gyalilee weh nayhn Kapernyam, ahn ih staat tu teech di peepl dehn pahn di Sabat. ");
INSERT INTO bzj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Dehn kudn bileev weh dehn mi-di yehr, sayka how ih mi-di teech, kaa hihn mi-di teech laik sohnbadi weh noa egzakli weh dehn mi-di taak bowt, ahn ga aal atariti fi seh it tu. ");
INSERT INTO bzj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Wel, wahn man weh mi ga wahn deeman eena ahn mi deh eena di meetn plays. Ih staat tu hala pahn tap a ih vais seh, ");
INSERT INTO bzj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jeezas fahn Nazaret, da weh yoo waahn wid wee now? Ai noa hoo yoo! Yoo da di Hoali Wan weh kohn fahn Gaad!” ");
INSERT INTO bzj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jeezas koman di deeman dehn shaap-wan seh, “Shet op! Kom owta ahn rait now!” Di deeman chroa dong di man pahn di grong fronta evribadi, ahn kom owta ahn widowt hert ahn. ");
INSERT INTO bzj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Di peepl dehn mi shak ahn seh tu wan anada, “Da weh kaina nyoo teechin dis? Dis man ga lata atariti ahn powa! Hihn jos aada di eevl spirit dehn, ahn dehn kom owta peepl!” ");
INSERT INTO bzj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Di nyooz bowt Jeezas spred aal oava di konchrisaid. ");
INSERT INTO bzj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Soh den, Jeezas lef di sinagag ahn gaahn da Saiman hows. Wen dehn reech deh, ih fain Saiman mada-in-laa sik wid wahn hai feeva. Dehn aks Jeezas if ih kuda pleez help ahn. ");
INSERT INTO bzj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jeezas gaan oava bai di laydi ahn aada di feeva fi lef ahn. Rait away di feeva gaan, ahn di laydi get op sayhn taim ahn staat tu ten tu dehn. ");
INSERT INTO bzj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Da eevnin, az di son mi-di goh dong, peepl bring aala dehn wan weh mi sik wid aal difrent kaina dizeez tu Jeezas. Ih put ih han pahn eech wan a dehn ahn heel dehn. ");
INSERT INTO bzj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ih mi eevn chays deeman owta lata peepl, ahn dehn kom owt di hala seh, “Yoo da Gaad Son!” Bot Jeezas taak tu dehn shaap-wan ahn wudn alow dehn fi seh notn kaa dehn mi wel ahn noa dat hihn da-mi di Krais weh mi fi kohn fahn Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wen day mi-di brok, Jeezas gaan aaf da wahn kwaiyet plays. Di peepl dehn gaahn luk far ahn, ahn wen dehn reech wehpaa ih mi deh, dehn chrai stap ahn fahn goh. ");
INSERT INTO bzj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bot ih tel dehn seh, “Ah hafu goh da di ada tong dehn tu fi preech di Gud Nyooz bowt Gaad kingdom. Dats wai Gaad sen mi.” ");
INSERT INTO bzj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Soh Jeezas kip aan di preech eena di meetn plays dehn eena Judeeya dischrik. ");
INSERT INTO bzj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wahn day Jeezas mi-di stan op pahn di banksaid da di Genesaret lagoon monks wahn krowd a peepl. Dehn mi-di shub op gens ahn fi yehr di Werd a Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Sayhn taim ih spat too emti boat da di waatasaid. Di fishaman dehn mi deh saida dehn boat di wash dehn net. ");
INSERT INTO bzj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jeezas get eena wan a di boat, di wan weh mi bilangz tu Saiman. Ahn ih aks ahn fi shub ahn owt lee wayz fahn shoar. Den ih sidong ahn staat tu teech di krowd fahn deh. ");
INSERT INTO bzj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wen ih mi don taak tu dehn, Jeezas tel Saiman, “Shub di boat owt ferda eena di deep, den unu put dong unu net dehn eena di waata fi wahn gud kech.” ");
INSERT INTO bzj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saiman ansa Jeezas seh, “Maasta, wee werk haad aal nait ahn wi noh kech notn. Bot if yoo seh soh, Ah wahn put owt di net dehn agen.” ");
INSERT INTO bzj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wel, wen dehn du dat, dehn kech soh moch fish dat di net dehn staat tu bos! ");
INSERT INTO bzj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dehn mek sain tu dehn paadna dehn eena di ada boat fi kohn help dehn. Wen dehn kohn, dehn ful op di too boat dehn wid soh moch fish dat dehn nayli staat tu sink anaal! ");
INSERT INTO bzj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Wen Saiman Peeta si weh hapm, ih jrap dong pahn ih nee fronta Jeezas ahn seh, “Goh weh fahn mi, Laad. Ai da wahn sinful man.” ");
INSERT INTO bzj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ih seh dat kaa hihn ahn aala ih fren dehn kudn get oava di lata fish weh dehn mi kech. ");
INSERT INTO bzj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ih paadna dehn, weh mi nayhn Jaymz ahn Jan, weh da-mi Zebidee son dehn, mi sopraiz bowt it tu. Ahn Jeezas seh tu Saiman, “Noh frayd. Fahn ya goh bak, insteda kech fish, yu wahn kech peepl fi Gaad.” ");
INSERT INTO bzj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Soh dehn haal op di boat dehn pahn lan, ahn lef evriting deh ahn gaahn lang wid Jeezas. ");
INSERT INTO bzj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wahn taim Jeezas mi deh da wahn sertn tong, ahn wahn man mi dehdeh weh mi kova wid leprosi. Wen ih si Jeezas, ih jrap dong fronta ahn wid ih fays way dong da grong ahn bayg ahn seh, “Sa, if yoo waahn, yoo ku heel mi.” ");
INSERT INTO bzj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jeezas schrech owt ih han ahn toch di man ahn seh, “Yes, Ah waahn heel yu. Yu heel!” Az Jeezas seh dat, di leprosi disapyaa! ");
INSERT INTO bzj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Den Jeezas aada di man seh, “Noh seh notn tu nobadi; bot goh schrayt da di prees mek ih chek yu mek ih si dat yu heel fi chroo. Den goh goh aafa di sakrifais weh Moaziz Laa seh yu fi aafa, fi shoa evribadi dat yu geh heel.” ");
INSERT INTO bzj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bot nyooz bowt weh aal Jeezas mi-di du spred aal oava di plays, soh peepl kohn fahn aal bowt fi yehr ahn, ahn fi geh heel. ");
INSERT INTO bzj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bot Jeezas aalwayz manij fi slip weh, fi deh bai ihself soh dat ih ku pray. ");
INSERT INTO bzj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Now, wahn day wen ih mi-di teech di krowd, sohn Farisee ahn dehn wan weh teech di Jooish Laa mi dehdeh tu. Dehn mi kohn fahn evri vilij eena Gyalilee ahn Judeeya, ahn fahn Jeroosalem Siti tu. Di powa a di Laad mi-di werk schrang chroo Jeezas fi heel di sik peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Wen yu luk, sohn man kohn di bak wahn paralaiz man pahn wahn schrecha. Dehn mi-di chrai bring ahn eena di hows fi put ahn dong fronta Jeezas, bot dehn kudn reech Jeezas sayka di krowd. Soh di man dehn kehr dehn fren op pahn di howstap, ahn tayr op som a di tail dehn ahn loar ahn dong pahn di schrecha, midl a di krowd, rait fronta Jeezas. ");
INSERT INTO bzj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wen Jeezas si humoch fayt dehn mi ga eena ahn, ih seh, “Mi fren, Ah fagiv yu sin dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Di Farisee dehn ahn dehn wan weh teech di Jooish Laa seh tu dehnself, “Da weh du dis man? Hihn di play Gaad! Oanli Gaad ku fagiv sin!” ");
INSERT INTO bzj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jeezas mi don noa weh dehn mi-di tink, soh ih aks dehn seh, “Da weh unu di tink dehn kaina ting eena unu haat fa? ");
INSERT INTO bzj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wich wan eeziya fi seh, ‘Ah fagiv yu sin dehn,’ er, ‘Get op ahn waak’? ");
INSERT INTO bzj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ai ga atariti fi fagiv sin pahn ert ya. Bot fi jos seh dat noh proov notn, soh Ah wahn shoa unu an Ah wahn heel di man.” Den Jeezas ton tu di man weh mi paralaiz ahn tel ahn seh, “Get op ahn pik op yu schrecha ahn goh hoahn.” ");
INSERT INTO bzj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sodn-wan di man jomp rait op fronta aala dehn, ahn pik op di ting weh ih mi-di lidong pan ahn gaahn hoahn di prayz Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nobadi kudn bileev dehn aiy, ahn dehn staat tu prayz Gaad. Dehn mi shak fi si weh aal Gaad mi-di du, ahn dehn seh, “Wee neva si notn laik dis yet eena wi hoal laif!” ");
INSERT INTO bzj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Afta dis, Jeezas gaan owt ahn ih si wahn taks kalekta weh nayhn Leevai. Ih mi-di sidong eena di kostom boot di kalek taks. Jeezas tel ahn seh, “Kohn kohn bee wan a mi disaipl dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sayhn taim Leevai get op, lef evriting, ahn gaahn wid ahn. ");
INSERT INTO bzj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Layta, Leevai mi ga wahn big bankwit da ih hows fi Jeezas, ahn lata taks kalekta ahn sohn ada wan wid bad repyutayshan mi deh rong di taybl wid dehn. ");
INSERT INTO bzj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bot di Farisee ahn di teecha dehn a di Laa weh mi bilangz tu fi dehn groop kohn komplayn tu Jeezas disaipl dehn seh, “Da how unu stan fi eet ahn jrink wid taks kalekta ahn dehn kaina peepl?” ");
INSERT INTO bzj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jeezas ansa dehn seh, “Da sik peepl weh need dakta, ahn noh dehn wan weh helti. ");
INSERT INTO bzj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ai kohn fi kaal sinaz fi ton fahn dehn sin dehn, noh dehn wan weh tink seh dehn don rait wid Gaad.” ");
INSERT INTO bzj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Afta dat dehn seh tu ahn, “Dehn wan weh fala Jan di Baptis aalwayz di faas ahn pray, ahn dehn wan weh fala di Farisee dehn du dat tu, bot dehn wan weh fala yoo jos di eet ahn jrink laik notn.” ");
INSERT INTO bzj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jeezas ansa seh, “Unu kyaahn ekspek di groom fren dehn fi goh widowt food wail hihn stil deh wid dehn. ");
INSERT INTO bzj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bot di taim wahn kohn wen dehn wahn tek weh di groom fahn dehn, ahn dat da wen dehn wahn faas.” ");
INSERT INTO bzj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Den ih tel dehn wahn parabl weh goh laik dis: “Nobadi noh wahn pach wahn oal jakit wid wahn pees a klaat weh kom aafa wahn nyoo wan. If dehn du dat, dehn wahn hambog di nyoo jakit, ahn pahn tap a dat, di nyoo pees a klaat noh wahn mach di oal wan. ");
INSERT INTO bzj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Rait soh, nobadi wahn put wain weh jos don mek eena oal leda wain bag. If dehn du dat, di nyoo wain wahn bos di oal wain bag, ahn aala di wain wahn chroh-weh ahn di wain bag wahn kandem. ");
INSERT INTO bzj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yu wel ahn noa seh yu hafu put nyoo wain eena nyoo wain bag. ");
INSERT INTO bzj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nobadi weh don yoostu di oal wain noh wahn waahn jrink di nyoo wan. Dehn wahn seh, ‘Di oal wain tays beta.’” ");
INSERT INTO bzj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wahn day wen da mi di Sabat, Jeezas ahn ih disaipl dehn mi-di paas chroo sohn weet feel. Ih disaipl dehn pap aaf di tap a som a di weet, ahn rob aaf di chrash wid dehn han ahn eet di weet. ");
INSERT INTO bzj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Som a di Farisee dehn aks dehn seh, “Da wai unu di du ting weh deh gens di Laa pahn di Sabat?” ");
INSERT INTO bzj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jeezas ansa dehn seh, “Unu neva reed weh Dayvid ahn ih kompni dehn mi du wen dehn mi hongri noh? ");
INSERT INTO bzj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ih gaan eena di hows a Gaad ahn tek di hoali bred weh, akaadn tu di Laa, oanli di prees dehn mi sopoas tu eet; ahn ih eet som ahn gi ih man dehn sohn fi eet tu.” ");
INSERT INTO bzj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Den Jeezas tel dehn seh, “Di Son a Man ga atariti fi seh weh rait fi peepl du er kyaahn du pahn di Sabat.” ");
INSERT INTO bzj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pahn wahn nada Sabat, Jeezas gaan eena di sinagag ahn ih mi-di teech. Wahn man mi dehdeh hoofa rait han mi kripl op. ");
INSERT INTO bzj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Di Farisee dehn ahn dehn wan weh teech di Jooish Laa mi-di luk fi wahn reezn fi akyooz Jeezas, soh dehn mi-di wach ahn haad fi si if ih mi wahn heel di man pahn di Sabat. ");
INSERT INTO bzj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wel, Jeezas mi don noa weh dehn mi-di tink, soh ih tel di man wid di kripl han, “Get op ahn stan op fronta evribadi.” Soh di man get op ahn ih stan op fronta dehn. ");
INSERT INTO bzj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Den Jeezas tel dehn seh, “Mek Ah aks unu sohnting. Di Laa alow wi fi du gud er fi du bad pahn di Sabat? Ih alow wi fi sayv laif er fi dischrai it?” ");
INSERT INTO bzj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ih luk rong pahn aala dehn. Den ih seh tu di man, “Schrech owt yu han.” Soh di man schrech owt ih han, ahn ih han kohn bak gud gud-wan! ");
INSERT INTO bzj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Di rilijos leeda dehn mi oanli beks bad. Soh dehn staat tu taak monks dehnself how dehn mi wahn deel wid Jeezas. ");
INSERT INTO bzj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Now joorin da sayhn taim, Jeezas gaan op pahn wahn mongtin fi pray, ahn ih spen hoal nait op deh di taak tu Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wen maanin kohn, ih kaal op aala ih falowa dehn ahn pik owt twelv a dehn fi bee ih apasl dehn. ");
INSERT INTO bzj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Dehnya da-mi dehn naym: Saiman, hoofa naym Jeezas mi chaynj tu Peeta; ahn fi hihn breda, weh nayhn Anjru. Den yu mi ga Jaymz, Jan, Filip ahn Bartalamyoo; ahn Machyu ahn Tamas; ahn wahn nada wan weh nayhn Jaymz tu, weh da-mi Alfyos son; ahn Saiman weh mi bilangz tu di Zelat Paati. Den yu mi ga Joodas, hoofa pa mi nayhn Jaymz tu, ahn Joodas Iskariyat, weh mi wahn sel owt Jeezas aftawodz. ");
INSERT INTO bzj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Afta dat Jeezas kohn dong aafa di mongtin wid ih disaipl dehn, ahn stan op wehpaa di grong mi flat. Wahn hoal krowd a ih falowa dehn mi dehdeh, lang wid wahn lata ada peepl fahn aal bowt. Dehn kohn fahn Jeroosalem, ahn fahn lata ada plays eena Judeeya, ahn fahn Taiya ahn Saidan, weh mi deh lang di see koas. ");
INSERT INTO bzj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Dehn mi kohn fi yehr ahn preech ahn fi geh heel fahn dehn siknis, ahn aala dehn wan weh mi ga eevl spirit eena dehn mi geh kyoar. ");
INSERT INTO bzj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Evribadi eena di krowd mi-di chrai toch ahn kaa powa mi-di kom owta ahn weh mi-di heel aala dehn. ");
INSERT INTO bzj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jeezas luk schrayt pahn di disaipl dehn ahn seh, “Gaad bles unu weh noh ga notn now; kaa Gaad kingdom da fi unu. ");
INSERT INTO bzj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Gaad bles unu weh hongri now; kaa unu beli wahn geh ful. Gaad bles unu weh di krai now; kaa unu wahn laaf. ");
INSERT INTO bzj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Gaad bles unu wen peepl hayt unu, ahn kip unu owta dehn kompni ahn insolt unu, ahn bad-mowt unu sayka weh unu bilangz tu di Son a Man. ");
INSERT INTO bzj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Memba seh dat da di sayhn way fi dehn grayt-grayt-grayt-granfaada dehn mi chreet di oal taim prafit dehn. Soh wen dehn sayhn ting deh hapm tu unu, jomp op ahn daans kaa unu riwaad da hevn wahn big. ");
INSERT INTO bzj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Unu een fi big chrobl, unu rich peepl. Unu beta mek moch a di lee hapinis weh unu di injai rait now, kaa dat da aal weh unu di get. ");
INSERT INTO bzj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Unu een fi big chrobl, unu wan hoofa beli ful rait now, kaa unu wahn geh hongri. Unu een fi chrobl, unu wan weh di laaf rait now, kaa unu wahn put unu han pahn unu hed ahn baal! ");
INSERT INTO bzj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Unu een fi big chrobl wen evribadi taak loan gud ting bowt unu! Da sayhn way unu ansesta dehn mi chreet dehn oal taim faals prafit. ");
INSERT INTO bzj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Bot Ai di tel unu weh di lisn tu mi fi lov yu enimi dehn, ahn enibadi weh hayt unu, chreet dehn gud. ");
INSERT INTO bzj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bles dehn wan weh put mowt pahn unu, ahn pray fi dehn wan weh chreet unu bad. ");
INSERT INTO bzj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","If sohnbadi slap yu pahn wan said a yu fays, ton yu fays, mek dehn slap yu pahn di neks said tu. If dehn tek weh yu jakit, mek dehn tek weh yu shot tu. ");
INSERT INTO bzj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","If enibadi bayg yu fi eniting, gi dehn, ahn if dehn tek eniting fahn yu, noh foas dehn fi gi yu bak. ");
INSERT INTO bzj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yu fi chreet ada peepl di sayhn way how yoo waahn dehn chreet yoo. ");
INSERT INTO bzj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“If unu oanli lov dehn wan weh lov unu, dat di seh eniting fi unu? Eevn sinaz oanli lov dehn wan weh lov dehn. ");
INSERT INTO bzj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ahn if unu oanli chreet dehn wan gud weh chreet unu gud tu, dat du unu eni gud? Eevn sinaz du dat. ");
INSERT INTO bzj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Agen, if unu oanli len ting tu peepl weh ku gi unu bak, dat noh seh notn fi unu. Eevn sinaz oanli len wan anada ting soh dat dehn ku geh bak egzakli weh dehn len. ");
INSERT INTO bzj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Insteda du dat, lov unu enimi ahn du gud tu dehn, ahn len dehn ting widowt ekspek notn bak. If unu du dat, Gaad wahn pay unu bak big, ahn unu wahn bee Gaad pikni kaa hihn eevn shoa kainis tu dehn wan weh angraytful ahn wikid. ");
INSERT INTO bzj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Unu fi shoa mersi pahn peepl jos laik how unu Faada eena hevn shoa mersi pahn aala wi. ");
INSERT INTO bzj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Noh joj nobadi, ahn nobadi wahn joj unu. Noh kohn dong haad pahn peepl, er els dehn wahn kohn dong haad pahn unu tu. Fagiv peepl ahn den Gaad wahn fagiv unu. ");
INSERT INTO bzj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Giv, ahn unu wahn geh bak unu ful amonk, wel pak, shayk dong, ahn di ron oava. Dat da how unu wahn get it poar bak eena unu lap. Kaa di sayhn way how yu gi, dat da how yu wahn geh bak.” ");
INSERT INTO bzj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Den Jeezas tel dehn dis lee parabl: “Unu tink seh dat wahn man weh blain ku leed rong wahn nada blain man? Too a dehn wahn jrap eena hoal. ");
INSERT INTO bzj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wahn styoodent noh moa impoatant dan ih teecha, bot wen ih don geh aala ih chraynin, ih wahn bee jos laik ih teecha. ");
INSERT INTO bzj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ahn wai unu wahn wori bowt wahn lee splinta weh deh eena sohnbadi els aiy, ahn noh noatis di big pees a stik weh deh eena fi unu wan? ");
INSERT INTO bzj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","How yu ku seh tu yu brada, ‘Mi brada, mek Ah tek owt dis lee splinta weh deh eena yu aiy,’ wen yu noh eevn kanchos a di big pees a stik weh deh eena fi yu wan? Unu hipokrit unu! Tek owt di big pees a stik weh deh eena unu oan aiy fos, den yu wahn ku si gud nof fi tek owt di splinta weh deh eena yu brada wan.” ");
INSERT INTO bzj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jeezas gaan aan fi seh, “Wahn chree weh helti ku neva bayr bad froot, ahn wahn chree weh noh helti ku neva bayr gud froot. ");
INSERT INTO bzj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Peepl ku aalwayz tel da weh kaina chree bai di froot weh ih bayr. Unu wuda neva fain fig di groa pahn prikl bush, er grayp pahn brambl. ");
INSERT INTO bzj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sayhn way, wen wahn man haat ful op a loan gud ting, oanli gud ting wahn kom owta it, bot wen ih haat ful op a loan bad ting, den oanli bad ting wahn kom owta it. Soh den, wateva wahn man haat ful op wid, dat da weh wahn kom owta ih mowt. ");
INSERT INTO bzj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Wai unu stodi di kaal pahn mi ahn seh, ‘Laad, Laad’ wen unu noh eevn waahn du weh Ah tel unu fi du? ");
INSERT INTO bzj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mek Ah tel unu weh wahn persn stan laik weh kohn tu mi ahn lisn tu weh Ah teech ahn, ahn den goh du it. ");
INSERT INTO bzj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ih da jos laik sohnbadi weh di bil wahn hows, ahn dehn dig deep dong soh dat dehn ku put di fongdayshan pahn rak. Wen dehn ga flod ahn di riva rayz ahn wap gens di hows, ih stan op schrang kaa ih bil gud pahn rak. ");
INSERT INTO bzj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bot enibadi weh yehr weh Ah seh ahn noh du it, da jos laik wahn man weh bil ih hows pahn di grong widowt fongdayshan. Wen flod kohn ahn wap gens it, ih jrap dong flat ahn brok op eena peesiz.” ");
INSERT INTO bzj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Wen Jeezas don tel di peepl dehn weh ih mi ga fi seh, ih gaahn da Kapernyam. ");
INSERT INTO bzj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wahn aafisa fahn di Roaman aami weh mi liv deh mi ga wahn servant weh ih mi oanli lov bad. Di servant mi sik ahn deh pahn daiyin. ");
INSERT INTO bzj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Wen di aafisa yehr bowt Jeezas, ih sen wan ahn too a di Jooish leeda dehn fi aks Jeezas if ih ku kohn heel ih servant. ");
INSERT INTO bzj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Soh dehn gaahn da Jeezas ahn bayg ahn haad seh, “Dis man dizerv fi mek yu du dis far ahn, kaa ih oanli lov wi Jooish peepl dehn. Ih eevn bil wahn meetn plays fi wi.” ");
INSERT INTO bzj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Soh Jeezas gaahn wid dehn. Bot jos bifoa ih reech di hows, di aami aafisa sen owt som a ih fren dehn fi tel ahn, “Sa, yu noh hafu kohn way eensaida mi hows. Ai noh gud nof fi yoo aana mee soh. ");
INSERT INTO bzj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ah noh gud nof fi eevn kohn meet yu miself. Aal yu hafu du da seh di werd, ahn mi servant wahn geh heel. ");
INSERT INTO bzj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ai noa, kaa mee miself ga aafisa oava mee weh gi mee aadaz, an Ai ga soalja weh Ai gi aadaz tu. Ai ku tel eni wan a dehn, ‘Goh!’ ahn ih goh. An Ah ku tel wahn neks wan, ‘Kohn!’ ahn ih kohn. Ai ku tel eni wan a mai servant dehn, ‘Du soch ahn soch,’ ahn ih wahn du it.” ");
INSERT INTO bzj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Wen Jeezas yehr dis, ih mi soh sopraiz dat ih ton tu di krowd weh mi-di fala ahn, ahn seh, “Ai di tel unu, Ai neva fain nobadi wid soh moch fayt yet, noh eevn monks non a di peepl fahn Izrel!” ");
INSERT INTO bzj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wen di aafisa fren dehn gaahn bak da di hows, dehn fain di servant gud gud-wan, don heel. ");
INSERT INTO bzj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wahn lee wail afta dat, Jeezas gaahn da wahn tong weh nayhn Nayn, ahn ih disaipl dehn ahn wahn big krowd gaahn lang wid ahn. ");
INSERT INTO bzj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Az dehn mi-di kohn kloas tu di gayt a di tong, dehn mi-di bak owt wahn yong man weh mi ded. Da mi wahn wido oanli son, ahn wahn lata peepl mi-di kohn lang wid ahn fi beri ahn. ");
INSERT INTO bzj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wen di Laad si di wido, ih haat gaan owt tu ahn, ahn ih seh tu ahn, “Noh krai, Mis.” ");
INSERT INTO bzj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Den ih gaan op tu di schrecha weh dehn mi-di kehr di badi pan, ahn ih put ih han pan it. Dehn wan weh mi-di bak di schrecha stan op wan plays. Jeezas seh, “Yong man, get op!” ");
INSERT INTO bzj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Di ded man get op ahn staat tu taak! Ahn Jeezas gi ahn bak tu ih ma. ");
INSERT INTO bzj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Evribadi mi fraitn. Afta dat dehn staat tu prayz Gaad ahn seh, “Wahn grayt prafit rayz op monks wi. Gaad kohn tu ih peepl dehn fi help dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Di nyooz bowt aal weh Jeezas du spred aal oava Judeeya dischrik ahn da hoal ayrya rong deh. ");
INSERT INTO bzj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Jan di Baptis disaipl dehn tel ahn bowt evriting weh Jeezas mi-di du. Soh Jan kaal too a ih disaipl dehn ahn sen dehn da di Laad Jeezas fi aks ahn if hihn da di Krais weh Gaad mi pramis fi sen, er if dehn shuda luk fi sohnbadi els. ");
INSERT INTO bzj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wen di man dehn gaahn da Jeezas, dehn seh, “Jan di Baptis sen wi fi aks yu if yoo da di wan weh fi kohn, er wi fi luk owt fi sohnbadi els.” ");
INSERT INTO bzj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sayhn taim wail dehn mi deh rait deh, Jeezas heel wahn lata peepl weh mi ga aal kaina siknis ahn dizeez, ahn ih jraiv owt eevl spirit, ahn mek wahn lata blain peepl si agen. ");
INSERT INTO bzj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Den ih ton tu Jan disaipl dehn ahn seh, “Goh tel Jan aal weh unu si ahn aal weh unu yehr: Blain peepl geh bak dehn sait, dehn wan weh mi kripl ku waak agen, peepl weh mi ga leprosi geh heel, ahn def peepl ku yehr agen. Ded peepl kohn bak tu laif, ahn di poa geh di Gud Nyooz preech tu dehn. ");
INSERT INTO bzj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tel ahn tu dat Gaad bles enibadi weh noh rijek mi sayka weh aal Ai di du.” ");
INSERT INTO bzj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Afta Jan mesinja dehn gaan, Jeezas ton tu di krowd ahn staat tu taak tu dehn bowt Jan. Ih seh, “Da wat egzakli unu mi gaan owt eena di dezert fi si? Wahn lang pees a graas weh di sway eena di breez? ");
INSERT INTO bzj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bot tel mi, weh unu gaahn fi si? Wahn man jres op eena fansi kloaz? If unu waahn fain peepl weh jres op eena fansi kloaz ahn liv laik king, goh luk eena palis. ");
INSERT INTO bzj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Soh, weh unu gaahn fi si? Wahn prafit? Yes, unu gaahn fi si wahn prafit fi chroo, bot Ah tel unu, Jan da moch moa dahn jos wahn aadineri prafit. ");
INSERT INTO bzj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Hihn da di sayhn wan weh di Skripcha mi-di taak bowt wen ih seh, ‘Luk, Ah wahn sen mi mesinja heda yu. Hihn wahn mek shoar evriting redi fi yu.’ ");
INSERT INTO bzj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ah di tel yu, owta aala di pikni weh uman eva baan, non noh deh weh grayta dan Jan; bot in spait a dat, di lees impoatant persn weh da paat a Gaad kingdom now ga moa privilij dan Jan.” ");
INSERT INTO bzj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Evribadi, eevn di taks kalekta dehn, mi agree wid how Gaad mi plan tingz, soh dehn mi mek Jan baptaiz dehn. ");
INSERT INTO bzj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bot di Farisee dehn ahn dehn wan weh teech di Laa mi rijek weh Gaad mi plan fi dehn, soh dehn neva mek Jan baptaiz dehn. ");
INSERT INTO bzj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Den Jeezas aks dehn seh, “Soh, da weh Ah ku tel unu dis jenarayshan stan laik? Weh Ah ku kompyaa dehn wid? ");
INSERT INTO bzj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Dehn da jos laik sohn pikni weh di sidong eena wahn poblik skwyaa di hala tu wan anada seh, ‘Wi play floot fi unu ahn unu neva eevn daans. Wi sing ded sang ahn unu neva baal.’ ");
INSERT INTO bzj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wen Jan di Baptis kohn, hihn neva doz jrink ahn ih mi aalwayz di faas, ahn unu seh, ‘Hihn mosi ga deeman.’ ");
INSERT INTO bzj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Now di Son a Man kohn di eet ahn jrink, ahn unu seh, ‘Luk how ih kraybm ahn ih da wahn jronkad, ahn ih fren op wid di taks kalekta dehn ahn ada peepl wid bad repyutayshan.’ ");
INSERT INTO bzj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bot dehn wan weh fala Gaad wizdom wahn proov fi bee rait eena di langa ron.” ");
INSERT INTO bzj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wan a di Farisee invait Jeezas fi goh eet dina da ih hows, soh Jeezas gaahn tek ih plays da di taybl. ");
INSERT INTO bzj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Wel, wahn laydi weh mi ga bad naym yehr seh Jeezas mi deh da di Farisee hows di eet, soh ih bring wahn ekspensiv perfyoom eena wahn batl weh mek owta alabasta stoan. ");
INSERT INTO bzj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Di laydi kohn bihain Jeezas bai ih fut ahn staat tu krai ahn krai. Jeezas fut dehn geh wet op wid di laydi aiywaata, soh di laydi waip dehn aaf wid ih hyaa, ahn ih stodi mi-di kis ih fut ahn put perfyoom pahn dehn. ");
INSERT INTO bzj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wel, wen di Farisee weh mi invait Jeezas da ih hows si weh aal mi-di hapm, ih seh tu ihself, “If dis man da-mi wahn chroo chroo prafit, ih wuda mi noa weh kaina uman dis weh di toch ahn, dat shee da wahn sina.” ");
INSERT INTO bzj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jeezas taak op ahn ansa weh ih mi-di tink. Ih seh, “Saiman, Ah ga sohnting fi tel yu.” Saiman seh, “Aarait Teecha, goh hed.” ");
INSERT INTO bzj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jeezas seh, “Wahn man len too peepl sohn moni; wan a dehn bowt faiv honjrid dalaz, ahn di ada wan, fifti. ");
INSERT INTO bzj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bot non a dehn kudn pay ahn bak, soh di man fagiv di too a dehn ahn kaal it aaf. Now hoo yoo tink mi lov hihn di moas afta dat?” ");
INSERT INTO bzj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saiman ansa seh, “Ah ges di wan weh mi hoa ahn di moas moni.” “Dats rait,” Jeezas seh. ");
INSERT INTO bzj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ih ton tu di laydi ahn seh tu Saiman, “Luk pahn dis laydi ya. Wen Ah kom eena fi yoo hows, yu neva aafa mi no waata fi wash di dos aafa mi fut, bot shee wash dehn wid ih aiywaata ahn waip dehn wid ih hyaa. ");
INSERT INTO bzj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yoo neva eevn welkom mi wid wahn kis wen Ah kom een, bot shee stodi di kis mi fut dehn fahn Ah fos kom een. ");
INSERT INTO bzj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yoo neva rob mi hed wid no ail, bot shee poar perfyoom pahn mi fut dehn. ");
INSERT INTO bzj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Soh Ah tel yu, shee di shoa mi soh moch lov kaa Ai fagiv ahn a ih sin dehn, ahn da mi wahn lata sin. Yu si, wahn persn weh geh wahn lee bit a sinz fagiv oanli wahn lov lee bit.” ");
INSERT INTO bzj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Den Jeezas seh tu di laydi, “Ah fagiv yu sin dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dehn wan weh mi-di sidong da di taybl wid ahn seh, “Da hoo hihn soh hoo kud eevn fagiv sin?” ");
INSERT INTO bzj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Bot Jeezas seh tu di laydi, “Sayka yu fayt, yu sayv. Goh eena pees.” ");
INSERT INTO bzj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Soon aftawodz Jeezas staat tu goh chroo di siti ahn di vilij dehn di preech di Gud Nyooz bowt how enibadi ku bee paat a Gaad kingdom. Ih mi gat ih twelv disaipl dehn wid ahn, ");
INSERT INTO bzj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","lang wid sohn laydi weh ih mi heel fahn siknis ahn deeman. Monks dehn, yu mi ga Mayri Magdaleen, weh ih mi jraiv sebm deeman owta; ");
INSERT INTO bzj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joaana, weh da-mi Chuza waif (hihn da-mi manija a King Herod bizniz); ahn Soozana, ahn wahn lat moa a dehn. Aala dehn laydi deh doz tek moni fahn owta dehn oan pakit fi tek kayr a Jeezas ahn ih disaipl dehn. ");
INSERT INTO bzj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Peepl mi-di kohn fahn aal difrent tong, ahn wen wahn big krowd mi don gyada, Jeezas tel dehn dis parabl: ");
INSERT INTO bzj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wahn faama gaahn gaahn plaant sohn seed. Wail ih mi-di skyata di seed dehn, sohn jrap pahn di lee pikaado road ahn geh waak op pan, ahn di berd dehn flai dong ahn eet dehn op. ");
INSERT INTO bzj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Den som a di seed dehn jrap pahn grong weh mi raki, ahn az dehn sprowt op, dehn jrai op sayka weh dehn neva ga nof waata. ");
INSERT INTO bzj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Sohn ada seed jrap monks sohn prikl bush, ahn di prikl bush groa op lang wid di plaant dehn ahn choak dehn. ");
INSERT INTO bzj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Now sohn neks seed jrap pahn gud grong, ahn dehn bayr wahn honjrid taim moa dahn weh di faama mi plaant.” Wen Jeezas don seh dis, ih rayz ih vais ahn seh, “Eni a unu weh ga ayz fi yehr, unu lisn gud!” ");
INSERT INTO bzj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Di disaipl dehn aks ahn weh di parabl meen. ");
INSERT INTO bzj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ih seh, “Gaad pik unu fi noa di seekrit bowt fi hihn kingdom, bot Ah taak tu di res a peepl dehn eena parablz kaa di Skripcha seh, ‘Eevn wen dehn luk wid aal dehn aiy, dehn stil noh si, ahn wen dehn yehr weh Ah seh, dehn stil noh andastan.’ ");
INSERT INTO bzj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Now dis da weh di parabl meen: Di seed da di Werd a Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Dehn seed pahn di lee pikaado road da laik sohn peepl weh mi yehr di Werd a Gaad, bot di devl kohn ahn tek it weh fahn owta dehn haat, soh dat dehn noh bileev ahn geh sayv fahn dehn sin. ");
INSERT INTO bzj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Ahn di seed dehn weh jrap pahn grong weh raki stan fi dehn wan weh yehr di Werd a Gaad ahn dehn oanli tu hapi fi aksep di mesij rait away; bot di seed neva tek no root eena dehn haat. Dehn bileev it fi wahn lee wail, bot wen chroblz kohn, dehn jrap weh. ");
INSERT INTO bzj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Ahn az fi dehn seed weh jrap monks prikl, dehn da laik dehn peepl weh yehr, bot az dehn di goh lang, di woriz, ahn di richiz, ahn di plejaz eena laif choak di Werd owta dehn, ahn soh notn gud noh kom owta fi dehn laif. ");
INSERT INTO bzj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Bot dehn seed weh jrap pahn di gud grong, dehn da laik dehn peepl weh yehr di Werd—dehn hoal it tait eena wahn aanis ahn gud haat, ahn sayka weh dehn neva giv op, wahn lata gud ting kom owta fi dehn laif. ");
INSERT INTO bzj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nobadi noh wahn lait wahn lamp ahn kova it op, er put it anda di bed. Insteda dat, dehn wahn put it hai op pahn wahn stan soh dat evribadi weh kom een ku si di lait. ");
INSERT INTO bzj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Evriting weh haid weh wahn geh ekspoaz, ahn evriting weh du eena seekrit wahn kom owt eena di lait, ahn den evribadi wahn noa bowt it. ");
INSERT INTO bzj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Soh main how unu lisn kaa evribadi weh don ga wahn geh moa, ahn fi dehn wan weh noh ga notn, eevn di lee bit weh dehn tink dehn ga wahn geh tek weh fahn dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Wahn taim Jeezas ma ahn ih breda dehn kohn tu ahn, bot dehn kudn geh kloas sayka di krowd a peepl. ");
INSERT INTO bzj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Sohnbadi tel ahn seh, “Yu ma ahn yu breda dehn deh owtsaid ahn dehn waahn si yu.” ");
INSERT INTO bzj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Bot Jeezas tel dehn seh, “Mi ma ahn mi breda da dehn wan weh yehr di Werd a Gaad ahn du weh ih seh.” ");
INSERT INTO bzj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wahn day Jeezas seh tu ih disaipl dehn, “Mek wi goh kraas da di neks said a di lagoon.” Soh dehn get eena wahn boat ahn dehn shub owt. ");
INSERT INTO bzj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wail dehn mi-di goh lang, Jeezas jrap asleep. Wel, wan pees a skwaal kohn dong pahn di lagoon ahn di boat staat tu geh ful op wid waata, ahn dehn mi deh eena big chrobl. ");
INSERT INTO bzj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Soh di disaipl dehn gaahn wayk op Jeezas. Dehn hala, “Maasta! Maasta! Wi di luk fi jrongdid ya!” Jeezas get op ahn ih taak shaap-wan tu di breez ahn di rof waata. Az ih du dat, di breez stap bloa ahn evriting geh kyaam, kyaam. ");
INSERT INTO bzj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Den Jeezas seh tu ih disaipl dehn, “Wehpaa unu fayt deh?” Di disaipl dehn mi feel frayd ahn sopraiz sayhn taim, ahn dehn seh tu wan anada, “Da hoo dis man? Dong tu di breez ahn di waata hihn tel weh fi du, ahn dehn obay ahn!” ");
INSERT INTO bzj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Afta dat dehn sayl kraas di neks said a di lagoon fahn Gyalilee, ahn dehn reech wichpaa di Jeraseen peepl dehn liv. ");
INSERT INTO bzj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Az Jeezas mi-di get owta di boat, wahn man fahn di tong kohn meet ahn. Dis man mi ga deeman eena ahn, ahn fi wahn lang taim ih neva wayr no kloaz, ahn hihn neva liv eena hows needa; hihn mi liv eena bering grong. ");
INSERT INTO bzj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Az soon az ih sait Jeezas, ih baal owt ahn jrap dong fronta ahn, ahn ih hala haad-wan pahn tap a ih vais, “Jeezas, yoo weh da di Son a di moas hai Gaad, da weh yoo waahn wid mee? Ah di bayg yu, noh taacha mi.” ");
INSERT INTO bzj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ih seh dat bikaa Jeezas mi don koman di deeman fi kom owta ahn. Dehn wuda ga di man anda gyaad ahn ga ih han ahn ih fut dehn chayn op, ahn stil lata taim di deeman wuda tek kanchroal a ahn mek ih bos op di chayn dehn laik notn, ahn mek ih ron way owt eena bush weh nobadi noh deh. ");
INSERT INTO bzj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jeezas aks ahn seh, “Da weh yoo nayhn?” Ih ansa seh, “Mee nayhn Leejan,” kaa wahn lata deeman mi liv eena ahn. ");
INSERT INTO bzj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Di deeman dehn bayg Jeezas haad noh fi sen dehn eena di hoal weh noh ga no batam. ");
INSERT INTO bzj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Now yu mi ga wahn lata pig weh mi-di feed pahn wahn hil weh mi deh kloas tu weh dehn mi deh. Di deeman dehn bayg Jeezas fi mek ih sen dehn eena di pig dehn, soh Jeezas tel dehn fi goh. ");
INSERT INTO bzj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Soh di deeman dehn kom owta di man ahn gaan eena di pig dehn, ahn di hoal bonch a dehn rosh dong di said a di hil weh mi wel ahn hai, ahn aala dehn jrongdid eena di lagoon. ");
INSERT INTO bzj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wen di man dehn weh mi-di main di pig dehn si weh hapm, dehn ron gaahn tel evribadi eena di tong ahn aal oava di konchrisaid. ");
INSERT INTO bzj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Soh di peepl dehn gaahn gaahn si weh hapm. Wen dehn gaahn da Jeezas, dehn fain di man weh mi ga di deeman di sidong bai Jeezas fut. Wen dehn si dat ih mi gat aan kloaz, ahn ih mi ga ih gud gud sens, dehn geh frayd. ");
INSERT INTO bzj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Dehn wan weh mi si how di hoal ting mi hapm tel evribadi how di man weh mi ga di eevl spirit dehn mi geh kyoar. ");
INSERT INTO bzj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Den aala di Jeraseen peepl dehn bayg Jeezas fi goh fahn deh kaa dehn mi frayd bad bad. Soh ih get eena di boat fi goh. ");
INSERT INTO bzj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bot di man weh mi ga di deeman dehn gaan ahn bayg Jeezas fi mek ih goh lang wid ahn, bot Jeezas sen ahn weh ahn tel ahn seh, ");
INSERT INTO bzj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Goh bak hoahn ahn tel dehn weh Gaad du fi yu.” Soh di man lef ahn gaan aal oava di tong ahn tel evribadi weh aal Jeezas mi du far ahn. ");
INSERT INTO bzj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Now wen Jeezas get bak fahn Jeraseen, wahn hoal krowd a peepl mi don dehdeh aredi. Dehn mi-di wayt fi welkom ahn. ");
INSERT INTO bzj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Den wahn man weh mi nayhn Jairos, weh da-mi di hed a di sinagag deh, kohn ahn chroa ihself da Jeezas fut. Ih bayg ahn fi kohn da ih hows, sayka weh ih wan lee daata mi deh pahn daiyin. Di lee gyal mi bowt twelv. Az Jeezas mi-di goh wid ahn, di peepl dehn mi-di krowd een pan ahn soh moch dat dehn mi-di luk fi krosh ahn anaal. ");
INSERT INTO bzj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wahn laydi weh mi-di chrobl wid hemrij fi twelv yaaz mi deh eena di krowd. No dakta kudn heel ahn. ");
INSERT INTO bzj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ih kom op bihain Jeezas ahn toch di ej a ih kloaz, ahn sayhn taim di bleedn stap! ");
INSERT INTO bzj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jeezas aks dehn seh, “Hoo toch mi?” Wen nobadi oan op, Peeta tel ahn seh, “Bot Maasta, yoo noh si humoch peepl deh rong yu di shub op gens yu?” ");
INSERT INTO bzj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bot Jeezas seh, “Sohnbadi toch mi. Ah noa kaa powa gaan owta mi.” ");
INSERT INTO bzj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wen di laydi si ih kudn get weh, ih kohn di chrimbl ahn ih chroa ihself da Jeezas fut. Rait fronta evribadi ih seh wai ih mi toch ahn, ahn dat ih geh heel sayhn taim. ");
INSERT INTO bzj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jeezas tel ahn seh, “Daata, sayka yu fayt, yu geh heel. Goh, ahn noh wori bowt notn.” ");
INSERT INTO bzj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Wail ih stil mi-di taak, sohnbadi fahn Jairos hows kohn ahn tel ahn seh, “Yu daata ded. Noh bada di teecha agen.” ");
INSERT INTO bzj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wen Jeezas yehr dis, ih tel Jairos seh, “Noh wori, jos ga fayt ahn yu daata wahn aarait.” ");
INSERT INTO bzj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Soh wen dehn geh da Jairos hows, Jeezas neva mek nobadi gaan een wid ahn, eksep Peeta ahn Jaymz ahn Jan, ahn di lee gyal ma ahn pa. ");
INSERT INTO bzj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Da sayhn taim deh, aala di peepl dehn mi-di moan ahn baal fi di lee gyal. Jeezas tel dehn seh, “Unu stap unu naiz. Di lee gyal noh ded; ih oanli di sleep!” ");
INSERT INTO bzj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dehn staat tu laaf aata ahn kaa dehn mi noa dat di lee gyal mi ded fi chroo. ");
INSERT INTO bzj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bot Jeezas tek ih han ahn seh, “Get op, baybi.” ");
INSERT INTO bzj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Di lee gyal spirit kohn bak eena ahn, ahn sayhn taim ih get op. Jeezas tel dehn fi gi ahn sohnting fi eet. ");
INSERT INTO bzj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ih ma ahn pa mi oanli glad bot fraitn sayhn taim! Jeezas tel dehn noh fi tel nobadi weh mi hapm. ");
INSERT INTO bzj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Wahn day Jeezas kaal ih twelv disaipl dehn tugeda ahn ih gi dehn powa ahn atariti fi jraiv owt aal kaina deeman ahn fi heel dizeez. ");
INSERT INTO bzj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Den ih sen dehn owt fi heel dehn wan weh sik ahn fi tel evribadi bowt how dehn ku bee paat a Gaad kingdom. ");
INSERT INTO bzj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jeezas tel dehn seh, “Ah noh waahn unu kehr notn pahn di jerni—no waakin stik, needa kitbag er ting fi eet, ner moni; noh eevn wahn ekschra shot. ");
INSERT INTO bzj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Eni vilij weh unu goh eena, di fos hows weh dehn invait unu fi stay eena, stay deh til unu redi fi lef da vilij. ");
INSERT INTO bzj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","If di peepl dehn da eni vilij noh welkom unu, den wen unu di lef fahn deh, unu mos shayk aaf di dos fahn aafa unu fut az wahn sain gens dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Soh di disaipl dehn mek dehn rongz a di vilij dehn; ahn evriway weh dehn mi-di goh, dehn mi-di preech di Gud Nyooz ahn heel sik peepl. ");
INSERT INTO bzj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Now nyooz bowt weh aal Jeezas mi-di du get eena King Herod ayz. Hihn da-mi di roola oava Gyalilee. Ih mi-di wanda weh mi-di goh aan kaa sohn peepl mi-di seh dat da Jan di Baptis weh rayz op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Den sohn mi-di seh dat da mosi Ilaija apyaa, ahn stil sohn ada wan mi-di seh dat da sohn ada oal taim prafit weh rayz op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ahn Herod seh, “Bot Ai chap aaf Jan hed. Soh da hoo dis man weh Ai di yehr dehnya schraynj stoari bowt now?” Ahn den Herod chrai ih bes fi si Jeezas. ");
INSERT INTO bzj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wen di apasl dehn kohn bak, dehn tel Jeezas bowt evriting weh dehn mi du. Den ih slip weh wid dehn ahn gaahn da wahn tong weh nayhn Betsayda fi bee bai dehnself. ");
INSERT INTO bzj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bot di krowd fain owt wehpaa ih mi gwehn ahn dehn fala ahn. Jeezas welkom dehn ahn staat tu teech dehn bowt Gaad kingdom; pahn tap a dat, ih heel dehn wan weh mi sik. ");
INSERT INTO bzj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Layt-wan di aftanoon di twelv disaipl dehn kohn tu Jeezas ahn seh, “Sen di krowd weh da di vilij dehn ahn di faam dehn weh deh kloas soh dat dehn ku fain sohnting fi eet ahn lajin fi di nait. Notn noh deh ya fi eet eena disya dizertid plays.” ");
INSERT INTO bzj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bot Jeezas aks dehn seh, “Wai unu noh feed dehn?” Dehn ansa ahn seh, “Wee oanli ga faiv bred ahn too fish. How wee wahn bai nof bred fi feed dis hoal krowd?” ");
INSERT INTO bzj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Bowt faiv towzn man mi dehdeh.) Jeezas tel ih disaipl dehn seh, “Jos tel dehn fi sidong pahn di grong eena groop wid fifti peepl eena wahn groop.” ");
INSERT INTO bzj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Soh dehn du dat, ahn di peepl dehn sidong. ");
INSERT INTO bzj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jeezas tek di faiv bred ahn too fish, ahn luk op da hevn ahn gi Gaad tanks. Ih brok di bred ahn di fish, ahn ih gi di disaipl dehn fi paas owt tu evribadi. ");
INSERT INTO bzj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Di peepl dehn eet til dehn beli ful, ahn den di disaipl dehn pik op hoal a twelv baaskit ful a di lee pees a bred dehn ahn fish weh mi lefoava. ");
INSERT INTO bzj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wahn day Jeezas gaan aaf bai ihself gaahn pray. Ih disaipl dehn neva deh tu faar fahn ahn, soh ih aks dehn seh, “Wen peepl taak bowt mi, da hoo dehn seh da mee?” ");
INSERT INTO bzj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dehn tel ahn seh, “Wel, sohn peepl seh dat yu da Jan di Baptis, ahn sohn seh yu da Ilaija, ahn stil sohn neks wan dehn seh dat yoo da wan a dehn oal taim prafit weh kohn bak fahn di ded.” ");
INSERT INTO bzj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Den ih aks dehn seh, “Ahn da hoo unu seh da mee?” Peeta ansa seh, “Yoo da di Krais weh Gaad sen.” ");
INSERT INTO bzj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jeezas waan dehn haad-wan seh, “Noh tel nobadi da hoo mee ");
INSERT INTO bzj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","bikaa di Son a Man wahn hafu sofa lata ting. Di Jooish leeda dehn, ahn di cheef prees dehn, ahn dehn wan weh teech di Laa wahn rijek ahn. Dehn wahn kil ahn, bot chree dayz layta, ih wahn rayz op bak fahn di ded!” ");
INSERT INTO bzj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Den ih seh tu di krowd, “If eni a unu waahn fala mi, unu mos stap goh afta weh unu waahn fi fi unu oanself. Pik op yu kraas evri day ahn fala mee. ");
INSERT INTO bzj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Enibadi weh chrai fi heng aan tu dehn oan laif wahn en op di laas it, bot enibadi weh giv op dehn laif fi sayka mee wahn sayv it. ");
INSERT INTO bzj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Weh gud ih wahn du yu if yoo oan di hoal werl ahn en op di laas yu soal er dischrai yuself? ");
INSERT INTO bzj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","If enibadi shaym a mee ahn fi mee mesij, di Son a Man wahn shaym a dehn tu wen ih kohn bak eena aala fi hihn gloari, di shain eena aala di braitnis a ih Faada gloari. Ahn aala di hoali aynjel dehn wahn deh rong ahn eena fi dehn gloari tu. ");
INSERT INTO bzj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ah di tel unu di chroot, som a unu weh di stan op rait ya soh, noh wahn ded bifoa unu si Gaad kingdom staat.” ");
INSERT INTO bzj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bowt ayt dayz afta Jeezas seh dehn ting deh, ih kehr Peeta ahn Jaymz, ahn Jan wid ahn op pahn wahn mongtin fi pray. ");
INSERT INTO bzj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ahn az ih mi-di pray, ih hoal fays chaynj ahn ih kloaz geh wait wait wait til ih hat dehn aiy anaal. ");
INSERT INTO bzj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Sodn-wan, too man apyaa ahn wahn brait lait mi deh rong dehn. Dehnya man da-mi Moaziz ahn Ilaija, ahn dehn mi-di taak tu Jeezas bowt how ih mi wahn hafu ded da Jeroosalem fi mek Gaad plan kohn chroo. ");
INSERT INTO bzj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peeta ahn di ada too disaipl dehn jrap asleep kaa dehn mi sleepi bad, bot den dehn wayk op ahn si Jeezas brait-wan eena aala ih gloari, ahn dehn si di too man dehn weh mi deh wid ahn tu. ");
INSERT INTO bzj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jos az Moaziz ahn Ilaija mi-di luk fi goh, Peeta tel Jeezas seh, “Maasta, ih gud dat wee deh ya. Mek wi put chree boot ya, wan fi yoo, wan fi Moaziz, ahn wan fi Ilaija.” Peeta hihn neva eevn noa weh hihn mi-di seh. ");
INSERT INTO bzj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bot sayhn taim ih mi-di seh dat, wahn klowd apyaa oava dehn, ahn dehn mi fraitn no miks wen di klowd kova dehn. ");
INSERT INTO bzj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Den dehn yehr wahn vais fahn owta di klowd weh seh, “Dis da mai Son, di Wan weh Ai pik. Lisn tu ahn.” ");
INSERT INTO bzj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wen di vais don taak, oanli Jeezas wan mi lef deh wid dehn. Di disaipl dehn kip weh mi hapm tu dehnself, ahn dehn neva tel nobadi bowt it til aftawodz. ");
INSERT INTO bzj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Di neks day, afta dehn kohn dong aafa di mongtin, wahn big big krowd mi dehdeh fi meet Jeezas. ");
INSERT INTO bzj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Wahn man eena di krowd hala tu ahn, “Teecha, pleez kohn luk pahn mi lee bwai noh? Ih da mi oanli son. ");
INSERT INTO bzj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wahn eevl spirit stodi grab ahn, ahn mek ih skreem owt sodn. Ih chroa ahn dong eena fits til ih fraat da ih mowt. Den ih stodi di nak ahn op ahn mek ih hat op ihself. Ih noh lef ahn loan ataal. ");
INSERT INTO bzj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ah bayg yu disaipl dehn fi jraiv owt di eevl spirit, bot dehn kudn du it.” ");
INSERT INTO bzj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jeezas seh, “Unu stobant peepl weh noh ga no fayt! How lang Ai fi deh ya wid unu, di put op wid unu? Bring di lee bwai ya tu mi.” ");
INSERT INTO bzj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Az dehn mi-di bring di lee bwai, di deeman chroa ahn dong eena wahn schrang fits. Bot Jeezas taak shaap-wan tu di eevl spirit ahn den ih heel di bwai ahn gi ahn bak tu ih pa. ");
INSERT INTO bzj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Di peepl dehn mi shak wen dehn si di powa a Gaad. Wail evribadi mi-di chrai get oava aala di wandaful ting dehn weh Jeezas mi-di du, Jeezas tel ih disaipl dehn seh, ");
INSERT INTO bzj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Lisn tu mi gud ahn memba weh Ah seh. Dehn wahn sel owt di Son a Man ahn han ahn oava tu sohn peepl.” ");
INSERT INTO bzj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bot di disaipl dehn neva andastan weh Jeezas mi-di taak bowt kaa di reel meenin mi haid fahn dehn soh dat dehn kudn andastan it. Pahn tap a dat, dehn mi frayd fi aks ahn. ");
INSERT INTO bzj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Afta dat, di disaipl dehn staat tu aagyu monks dehnself bowt wich wan a dehn da-mi di moas impoatant wan. ");
INSERT INTO bzj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Bot Jeezas mi don noa weh dehn mi-di tink, soh ih tek wahn lee pikni ahn put ahn saida ahn, ");
INSERT INTO bzj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ahn ih tel dehn seh, “Enibadi weh welkom wahn lee pikni laik dis sayka mee, welkom mee tu, ahn enibadi weh welkom mee, welkom di Wan weh sen mi. Enibadi weh da di lees monks unu da di moas impoatant wan.” ");
INSERT INTO bzj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Den Jan seh tu Jeezas, “Teecha, wi mi si wahn man di yooz yu naym fi jraiv deeman owta peepl, ahn wi tel fi stap bikaa hihn da noh wan a wee.” ");
INSERT INTO bzj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Bot Jeezas seh, “No! Noh stap ahn! Enibadi weh noh deh gens wi, dehn deh pahn fi wee said.” ");
INSERT INTO bzj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wen di taim mi-di geh kloas fi mek Jeezas goh bak da hevn, ih mek op ih main fi goh da Jeroosalem, ");
INSERT INTO bzj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ahn ih sen sohn mesinja heda ahn. Dehn gaahn da wahn Samaritan vilij fi geh tingz redi far ahn. ");
INSERT INTO bzj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bot di peepl da da vilij neva waahn notn fi du wid Jeezas kaa dehn mi noa dat da Jeroosalem ih mi gwehn. ");
INSERT INTO bzj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wen Jaymz ahn Jan si dat di peepl dehn neva waahn Jeezas deh, dehn aks ahn seh, “Teecha, yu tink wi shuda kaal dong faiya fahn hevn fi bon dehn op, er wat?” ");
INSERT INTO bzj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bot Jeezas ton rong ahn skoal dehn shaap-wan. ");
INSERT INTO bzj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Afta dat dehn gaahn da wahn neks vilij. ");
INSERT INTO bzj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wail Jeezas ahn ih disaipl dehn mi-di waak dong di road, sohnbadi seh tu Jeezas, “Ai wahn fala yoo noh mata wehpaa yu goh.” ");
INSERT INTO bzj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Bot Jeezas tel ahn seh, “Faks ga hoal fi liv eena, ahn berd ga nes, bot di Son a Man noh ga no way fi res ih hed.” ");
INSERT INTO bzj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Den ih tel sohnbadi els, “Kohn fala mi ahn bee wan a mi disaipl dehn.” Bot di man seh, “Teecha, mek Ah wayt til mi pa ded fos, soh dat Ah ku beri ahn.” ");
INSERT INTO bzj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jeezas tel ahn seh, “Mek dehn wan weh ded beri fi dehn oan ded. Weh yoo fi du da preech bowt how peepl ku bee paat a Gaad kingdom.” ");
INSERT INTO bzj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wahn neks wan seh, “Ai wahn fala yu, Teecha, bot mek Ah goh da mi faamli fos ahn tel dehn gudbai.” ");
INSERT INTO bzj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Bot Jeezas tel ahn seh, “Enibadi weh staat tu plow dehn feel ahn stodi di luk bihain dehn, noh fit fi serv monks di peepl dehn weh da paat a Gaad kingdom.” ");
INSERT INTO bzj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Afta dis Jeezas pik owt semti moa disaipl. Ahn ih sen dehn owt too-bai-too fi goh heda ahn da eech tong ahn vilij weh ih mi waahn goh. ");
INSERT INTO bzj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ahn ih tel dehn seh, “Lata grayn deh fi pik, bot oanli lee bit a peepl deh fi werk. Soh pray tu Gaad weh in chaaj a bring een di krap fi mek ih sen moa werkaz fi werk eena fi hihn feel. ");
INSERT INTO bzj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Goh! Ah di sen unu owt laik sohn lee lam monks dehn wulf. ");
INSERT INTO bzj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Noh kehr no moni, kitbag er ekschra shooz, ahn noh eevn stap fi hayl nobadi pahn di way. ");
INSERT INTO bzj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Enitaihn unu goh eena enibadi hows, di fos ting unu fi seh da, ‘Gaad bles dis hows.’ ");
INSERT INTO bzj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","If di peepl dehn weh liv deh da peesful peepl, den unu blesin wahn tek, bot if dehn noh peesful, di blesin wahn kohn bak tu unu. ");
INSERT INTO bzj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Oanli stay da wan hows, ahn eet ahn jrink eniting weh dehn gi unu kaa wahn werka dizerv ih pay. Noh di moov fahn hows tu hows. ");
INSERT INTO bzj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Soh wen unu goh da wahn tong ahn dehn welkom unu, eet wateva dehn gi unu. ");
INSERT INTO bzj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","If enibadi dehdeh weh sik, heel dehn. Tel dehn, ‘Now di taim soon kohn fi Gaad set op ih kingdom ahn unu wahn ku bee paat a it.’ ");
INSERT INTO bzj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bot if di peepl dehn eena wahn tong noh waahn unu deh, goh stan op midl schreet ahn seh, ");
INSERT INTO bzj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Wi eevn di waip di dos a unu tong fahn aafa wi fut batam az wahn sain dat unu doom. Bot wi waahn unu noa dat di taim soon kohn fi Gaad set op ih kingdom.’ ");
INSERT INTO bzj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ah di tel unu di chroot, wen Jojment Day kohn, ih wahn eeziya fi di peepl dehn fahn Sadam dan fi dehn wan fahn datdeh tong weh rijek mi. ");
INSERT INTO bzj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Aiy, unu peepl da Korazin ahn Betsayda, unu een fi big chrobl. Kaa if dehn wikid peepl da Taiya ahn Saidan kuda mi si di mirakl dehn weh Ai mi du eena unu tong, dehn mi wahn ton fahn dehn sin dehn lang taim. Dehn wuda mi put aan krokos bag ahn sidong eena ashiz fi shoa how sari dehn sari. ");
INSERT INTO bzj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Soh ih wahn beta fi dehn wan da Taiya ahn Saidan dan fi unu pahn Jojment Day. ");
INSERT INTO bzj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ahn unu peepl da Kapernyam, unu tink seh Gaad wahn kehr unu da hevn? No, sa! Unu gwehn schrayt da hel!” ");
INSERT INTO bzj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Den ih tel di disaipl dehn, “Enibadi weh lisn tu unu lisn tu mee tu. Ahn if dehn rijek unu, den dehn rijek mee tu, ahn enibadi weh rijek mee rijek di Wan weh sen mi.” ");
INSERT INTO bzj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wen di semti disaipl dehn kohn bak, dehn mi oanli hapi, ahn dehn seh, “Maasta, eevn di deeman dehn obay wi wen wi yooz yu naym gens dehn!” ");
INSERT INTO bzj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jeezas tel dehn seh, “Yes! Ah mi si Saytan jrap dong fahn hevn laik laitnin. ");
INSERT INTO bzj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yu si, Ah don gi unu atariti oava aala di powa a di enimi. Unu wahn waak pahn snayk er skyaapyan, ahn dehn noh wahn du unu notn. ");
INSERT INTO bzj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bot noh feel hapi jos sayka weh eevl spirit obay unu. Insteda dat, unu mos feel hapi kaa unu naym rait dong eena hevn!” ");
INSERT INTO bzj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sayhn taim di Hoali Spirit mek Jeezas staat tu rijais ahn ih seh, “Ah prayz yu, Faada, yoo weh da di Laad a hevn ahn ert, kaa yu neva mek dehn wan weh ejukaytid ahn tink dehn soh smaat andastan aala dehn ting weh Ah jos tel mi disaipl dehn, bot yu shoa it tu dehn wan weh hombl laik lee pikni. Yes, Faada, ih mek yu hapi fi du it soh.” ");
INSERT INTO bzj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Den ih tel ih disaipl dehn seh, “Mai Faada don gi mi atariti oava evriting. Nobadi noh reeli noa hoo da di Son eksep di Faada, ahn nobadi reeli noa hoo da di Faada eksep di Son, ahn enibadi els weh di Son waahn shoa ih Faada tu.” ");
INSERT INTO bzj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Den Jeezas ton soh dat oanli ih disaipl dehn kuda mi yehr, ahn ih seh, “Gaad bles di aiy dehn weh si weh unu si fi chroo. ");
INSERT INTO bzj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mek Ah tel unu, wahn lata dehn oal taim prafit ahn king dehn wuda mi oanli waahn si ahn yehr di ting dehn weh unu si ahn yehr, bot dehn kudn.” ");
INSERT INTO bzj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wahn taim wahn teecha a di Jooish Laa get op fi aks Jeezas wahn kweschan jos fi tes ahn. Ih seh, “Maasta, da weh Ah hafu du fi liv wid Gaad fareva?” ");
INSERT INTO bzj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jeezas ansa ahn seh, “Da weh rait eena di Laa? Da how yu andastan it?” ");
INSERT INTO bzj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Di man ansa seh, “‘Yu fi lov di Laad yu Gaad wid aala yu haat, ahn wid aala yu soal, ahn wid aala yu schrent, ahn wid aala yu main,’ ahn ‘yu fi lov yu nayba sayhn laik how yu lov yuself.’” ");
INSERT INTO bzj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jeezas seh, “Dat karek. Yoo du dat ahn yu wahn liv wid Gaad fareva.” ");
INSERT INTO bzj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bot dat neva satisfai di man, kaa hihn neva tink dat Jeezas ansa mi gud nof, soh ih aks ahn seh, “Ahn hoo egzakli da mi nayba?” ");
INSERT INTO bzj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dis da how Jeezas ansa ahn: “Wahn Jooish man mi gwehn fahn Jeroosalem dong da Jeriko wen sohn teef atak ahn. Dehn haal aaf ih kloaz, bos ahn op bad, ahn lef ahn pahn di roadsaid fi ded. ");
INSERT INTO bzj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Now ih hapm dat wahn prees mi-di chravl dong da sayhn road. Wen ih si di poa lee man, ih kraas oava ahn ih paas pahn di nada said. ");
INSERT INTO bzj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sayhn way, wahn man weh werk eena di templ reech wehpaa di man mi deh, ahn wen ih si di man, hihn paas pahn di nada said a di road tu. ");
INSERT INTO bzj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bot wahn Samaritan man weh mi-di chravl pahn di sayhn road, bok op pahn di man. Ahn wen ih si how bad ih mi stan, ih haat gaan owt tu ahn. ");
INSERT INTO bzj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ih gaan oava tu ahn, ahn poar lee aliv ail ahn wain pahn ih kot dehn fi mek ih feel lee beta, ahn den ih ban ahn op. Den ih tek ahn, ahn put ahn pahn fi hihn oan dongki ahn ih kehr ahn da wahn ges-hows soh dat ih kuda mi tek kayr a ahn. ");
INSERT INTO bzj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Di neks day di Samaritan man tek owt sohn moni ahn gi di oana a di ges-hows ahn tel ahn seh, ‘Tek kayr a di man. If ih kaas moa dahn weh Ah lef wid yu, Ah wahn pay yu di res wen Ah kohn bak.’” ");
INSERT INTO bzj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Den Jeezas aks di teecha a di Laa, “Soh wich wan a dehn chree man yoo tink da-mi chroo chroo nayba tu di man weh di teef dehn beet op?” ");
INSERT INTO bzj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Di teecha a di Laa seh, “Di wan weh mi tek piti pan ahn, ahn help ahn.” Soh Jeezas tel ahn seh, “Wel, yoo goh ahn du di sayhn ting.” ");
INSERT INTO bzj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Az Jeezas ahn ih disaipl dehn mi-di goh lang pahn dehn way da Jeroosalem, dehn reech wahn vilij wehpaa wahn laydi weh nayhn Marta liv, ahn shee welkom Jeezas dehn eena ih hows. ");
INSERT INTO bzj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ih mi ga wahn sista weh nayhn Mayri, ahn shee mi-di sidong bai Jeezas fut di lisn tu aal weh ih mi-di teech bowt. ");
INSERT INTO bzj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bot Marta mi-di hasl op ihself wid aala di ting dehn weh ih mi ga fi du. Soh ih gaahn da Jeezas ahn seh, “Teecha, yoo noh kay dat oanli mee wan di du aala di werk wail Mayri shee jos di sidong deh, noh di du notn? Tel ahn fi kohn kohn help mi noh?” ");
INSERT INTO bzj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bot di Laad tel ahn seh, “Aiy, Marta! Yoo di wori ahn opset op yuself aafa tu moch ting. ");
INSERT INTO bzj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Oanli wan ting deh weh reeli impoatant, ahn Mayri don fain it. Nobadi wahn kyaahn tek dat weh fahn shee.” ");
INSERT INTO bzj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wahn taim Jeezas mi deh eena wahn sertn plays di pray. Wen ih don pray, wan a ih disaipl dehn aks ahn seh, “Laad, teech wi fi pray noh, jos laik how Jan teech fi hihn disaipl dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jeezas tel dehn seh, “Wen unu pray, unu fi seh, ‘Faada, mek wi kip yu naym hoali. Kohn kohn set op yu kingdom. ");
INSERT INTO bzj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pleez gi wi di food weh wi need evri day. ");
INSERT INTO bzj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ahn fagiv wi aala di rang ting dehn weh wi du, jos laik how wee fagiv dehn wan weh du wi ting. Ahn kip wi weh fahn temtayshan.’” ");
INSERT INTO bzj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Afta dat Jeezas tel dehn seh, “Sopoaz wan a unu ga wahn fren, ahn yu goh goh wayk ahn op twelv aklak da nait ahn seh, ‘Len mi chree bred noh, ");
INSERT INTO bzj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kaa wan a mi fren kohn pahn mi sodn fahn faar, an Ah noh ga notn fi gi ahn fi eet.’ ");
INSERT INTO bzj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Den di wan eensaid wahn ansa seh, ‘Noh bada mi. Ai kyaahn get op fi gi yoo notn. Ai don lak op aredi, ahn mee ahn aal mi pikni dehn don eena bed.’ ");
INSERT INTO bzj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ah tel unu, ih maitn get op fi gi yu di bred jos kaa ih da yu fren, bot pahn di langa ron, ih wahn gi yu az moch az yu waahn, jos kaa yu stay di nak ahn nak, ahn wudn giv op. ");
INSERT INTO bzj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Soh, dis da weh Ah di tel unu: Stay di aks ahn unu wahn geh; stay di luk ahn unu wahn fain; stay di nak pahn di doa ahn ih wahn oapm fi unu. ");
INSERT INTO bzj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kaa evribadi weh aks wahn geh; evribadi weh luk wahn fain weh dehn di luk fa; ahn evribadi weh nak pahn di doa, ih wahn oapm fi dehn. ");
INSERT INTO bzj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Wich wan a unu pa, wen unu pikni aks unu fi fish, wahn gi ahn snayk? ");
INSERT INTO bzj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Er wen ih aks fi eg, unu wuda gi ahn skyaapyan? ");
INSERT INTO bzj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","If unu weh soh wikid noa how fi gi unu pikni gud ting, den weh yu tink a yu Faada weh deh op da hevn den? Hihn wahn eevn moa glad fi gi di Hoali Spirit tu enibadi weh aks ahn.” ");
INSERT INTO bzj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wahn neks day, Jeezas mi-di jraiv owt wahn deeman owta wahn man. Sayka dis deeman, di man mi dom. Az di deeman kom owta ahn, di man weh mi dom staat tu taak, ahn di krowd kudn bileev weh hapm. ");
INSERT INTO bzj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bot som a dehn seh, “Cho! Da Biyelzibob weh da di hed a aala di deeman dehn gi hihn di powa fi jraiv owt deeman.” ");
INSERT INTO bzj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Sohn ada wan mi-di chrai tes owt Jeezas, soh dehn aks ahn fi gi dehn wahn sain fahn hevn. ");
INSERT INTO bzj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jeezas mi don noa weh dehn mi-di tink, soh ih tel dehn seh, “Eni konchri weh di peepl dehn di fait gens wan anada, ahn eni famili weh di fait gens wan anada noh wahn mek it. ");
INSERT INTO bzj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","How Saytan kingdom wahn mek it if hihn fait gens ih oanself? Ih wosa noh wahn mek it if da Biyelzibob gi mee di powa fi jraiv owt deeman, laik weh unu di seh. ");
INSERT INTO bzj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","If da Biyelzibob gi mee di powa fi jraiv owt deeman, den da hoo gi fi unu peepl dehn fi dehn powa fi jraiv dehn owt? Aks dehn sayhn wan if unu rait. ");
INSERT INTO bzj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bot if da Gaad gi mee di powa fi jraiv owt deeman, den dat shoa dat hihn don staat fi hihn kingdom monks unu aredi. ");
INSERT INTO bzj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Wen sohnbadi weh schrang laik Saytan wel dek dong wid aal kaina wepan di gyaad dehn oan hows, dehn noa dat dehn ting dehn sayf. ");
INSERT INTO bzj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bot wen sohnbadi schranga dan hihn kohn atak ahn, ahn beet ahn op, da schranga man wahn tek weh aala di wepan dehn weh di man mi-di pen pan, ahn shayr op aala ih bilanginz. ");
INSERT INTO bzj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Enibadi weh noh deh wid mi deh gens mi kaa if unu noh di help mi gyada, den unu di skyata. ");
INSERT INTO bzj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Now wen wahn eevl spirit kom owta wahn persn, ih wanda bowt eena dehn plays weh emti ahn jrai di luk fi sohnweh fi res. Ahn wen ih noh fain no way fi goh, ih seh, ‘Ah gwehn rait bak weh Ah kohn fram.’ ");
INSERT INTO bzj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bot wen ih get bak, ih si dat di plays kleen ahn wel fiks op. ");
INSERT INTO bzj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Soh ih kehr sebm moa eevl spirit weh wikida dan hihn, lang wid ahn. Ahn aala dehn setl een kwait gud. Soh den, da persn en op wosa aaf dan how ih mi stan fos.” ");
INSERT INTO bzj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Az Jeezas mi-di seh dehn ting, wahn laydi hala owt fahn eena di krowd, “Gaad bles di uman weh baan yoo ahn bresfeed yu!” ");
INSERT INTO bzj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bot Jeezas ansa ahn seh, “Yes, bot dehn wan weh yehr di Werd a Gaad ahn du weh ih seh stil moa bles dan dat.” ");
INSERT INTO bzj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bai dis taim ya di krowd geh eevn biga, ahn Jeezas tel dehn seh, “Disya jenarayshan wikid; dehn di aks fi wahn sain fahn hevn, bot di oanli sain dehn wahn geh da di sain weh dehn geh fahn weh mi hapm wid Joana. ");
INSERT INTO bzj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Weh mi hapm tu Joana da-mi wahn sain fi proov tu di peepl dehn da Niniveh, dat Gaad mi sen hihn deh. Sayhn way, weh wahn hapm tu di Son a Man wahn bee wahn sain fi dis jenarayshan dat Gaad sen ahn tu. ");
INSERT INTO bzj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Wen Jojment Day kohn, di Kween a Sheeba wahn rayz op lang wid di peepl dehn fahn dis jenarayshan ahn shee sayhn wan wahn taak gens dehn; kaa shee chravl way fahn di en a di ert jos fi lisn tu Salaman wizdom, ahn now sohnbadi grayta dan Salaman deh rait ya soh, ahn unu rifyooz fi lisn tu hihn. ");
INSERT INTO bzj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Rait soh, di peepl dehn fahn Niniveh wahn deh rait deh tu fi kandem dis jenarayshan pahn Jojment Day kaa wen Joana mi preech tu dehn, dehn ton fahn dehn sin dehn. Ahn luk ya! Wan deh ya now weh grayta dan Joana, ahn unu rifyooz fi ton fahn unu sin dehn. ");
INSERT INTO bzj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nobadi noh wahn lait wahn lamp ahn put it anda wahn bowl er eniway els wehpaa nobadi kyaahn see't. No! Insteda dat, dehn wahn put it hai op pahn wahn stan soh dat evribadi weh kom een ku si di lait. ");
INSERT INTO bzj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yu aiy dehn da laik lamp fi yu badi, soh if dehn stodi di luk pahn loan gud ting, di hoal a yu ful op a lait tu. Bot if dehn di luk pahn loan bad ting, den da loan daaknis deh eena yu haat. ");
INSERT INTO bzj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Soh mek shoar dat di lait weh yu tink yu ga da noh reeli daaknis. ");
INSERT INTO bzj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","If yu ful op a lait, ahn no kaina daaknis noh deh eena yu, den di hoal a yu wahn lait op chroo ahn chroo, laik wen wahn brait lait di shain pahn yu.” ");
INSERT INTO bzj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wen Jeezas don taak, wahn Farisee invait ahn fi goh eet da ih hows. Soh Jeezas gaan een gaahn tek ih plays da di dina taybl. ");
INSERT INTO bzj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Di Farisee mi sopraiz dat Jeezas neva goh chroo di serimoni fi wash ih han bifoa ih sidong fi eet. ");
INSERT INTO bzj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bot di Laad seh tu ahn, “Aiy, unu Farisee! Unu mek shoar unu kleen evriting pahn di owtsaid weh peepl ku si, laik unu kop ahn unu playt ahn soh, bot eena unu haat unu greedi ahn wikid no miks! ");
INSERT INTO bzj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Unu fool! Da noh di sayhn wan weh mek di owtsaid mek di eensaid a unu tu? ");
INSERT INTO bzj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Weh unu fi du da shayr weh deh eena unu kop ahn playt wid di poa, den unu wahn kleen fi chroo! ");
INSERT INTO bzj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Unu Farisee, unu een fi big chrobl. Da fi chroo unu gi Gaad ten persent a aal weh unu gat, eevn dong tu di herbz ahn seeznin plaant dehn weh unu groa eena unu gyaadn, bot den unu ton rong ahn noh chreet peepl fyaa, ahn unu noh reeli lov Gaad. Wail ih gud fi gi Gaad fi hihn ten persent, unu fi pay atenshan tu di ada impoatant ting dehn tu. ");
INSERT INTO bzj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Unu Farisee, unu een fi big chrobl. Unu lov fi kak op rait da front seet da di sinagag dehn ahn unu lov wen peepl hayl unu op owta schreet, wen unu di waak owta tong. ");
INSERT INTO bzj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Unu Farisee een fi big chrobl kaa unu da jos laik dehn grayv weh dehdeh rait soh, ahn peepl noh eevn noa seh dehn di waak op pan it, ahn dehn noh noa humoch koropshan deh andaneet.” ");
INSERT INTO bzj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wan a di teecha a di Jooish Laa weh mi-di lisn tu Jeezas seh tu ahn, “Sa, yoo noa dat wen yoo di seh dehn ting, da insolt yoo di insolt wee tu?” ");
INSERT INTO bzj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jeezas ansa hihn ahn seh, “Az fi unu teecha a di Laa, unu een fi big chrobl tu. Unu pak op peepl wid wahn hoal pail a schrik roolz weh dehn bayli ku kip, ahn unu noh eevn chrai fi lif wan finga fi mek it eeziya pahn dehn. ");
INSERT INTO bzj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Unu een fi big chrobl kaa unu bil toom fi aana di prafit dehn, ahn da fi unu grayt-grayt-grayt-granfaada dehn sayhn wan mi kil dehn. ");
INSERT INTO bzj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Soh, unu shoa seh dat unu mi wel agree wid weh dehn du, kaa da fi unu ansesta dehn weh kil aaf di prafit dehn, ahn unu bil toom fi dehn lang afta dehn ded laik unu soh lov dehn. Bot needa unu ner unu ansesta dehn neva obay weh dehn seh. ");
INSERT INTO bzj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Sayka weh Gaad waiz ahn noa evriting, hihn kuda mi seh, ‘Ah wahn sen sohn prafit ahn mesinja tu dehn, ahn dehn wahn kil sohn ahn haraas di res.’ ");
INSERT INTO bzj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Soh den, di blod a aala dehn prafit weh geh kil, fahn di biginin a di werl, wahn deh pahn dis jenarayshan hed. Dat meen aal di prafit dehn, fahn Aybl rait dong tu Zakaraiya, weh dehn mi kil bitween di templ ahn di alta weh deh owt eena di yaad weh dehn sakrifais animal tu Gaad. Yes, Ah di tel unu, aala dehn blod wahn deh pahn dis jenarayshan hed. ");
INSERT INTO bzj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Unu wan weh teech di Laa een fi big chrobl kaa unu haid di chroot bowt Gaad fahn di peepl dehn. Unu unuself noh aksep di chroot, ahn unu kip bak dehn wan weh wuda waahn laan.” ");
INSERT INTO bzj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Wen Jeezas lef di hows, dehn wan weh teech di Laa ahn di Farisee dehn mi soh beks dat dehn staat tu krayzi ahn wid aal kaina kweschan fi chrai pik ih mowt, fi mek ih slip, soh dat dehn kuda mi kech ahn eena sohnting weh dehn kuda yooz gens ahn. ");
INSERT INTO bzj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sayhn taim, towznz a peepl mi-di flak rong soh moch til dehn mi-di mash op wan anada. Jeezas ton tu ih disaipl dehn fos ahn waan dehn seh, “Unu kyaaful a di Farisee dehn ees, weh da toofaystidnis. ");
INSERT INTO bzj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Di taim di kohn wen evriting weh deh anda kova wahn kom owt playn playn-wan, ahn evriting weh da seekrit wahn kom owt eena di oapm. ");
INSERT INTO bzj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Eniting weh yu seh eena daak wahn kom owt eena braad daylait, ahn eniting weh yu wispa eena enibadi ayz eena dehn room, dehn wahn hala fahn di howstap dehn soh dat evribadi ku yehr. ");
INSERT INTO bzj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ah di tel unu dis mi fren, noh frayd fi dehn wan weh oanli ku kil unu badi kaa dehn kyaahn du unu notn afta dat. ");
INSERT INTO bzj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bot Ah wahn tel unu hoo fi frayd fa. Frayd fi Gaad! Hihn ga di powa noh oanli fi kil peepl bot fi hib dehn eena hel tu. Ah di tel unu agen, da hihn unu fi frayd fa. ");
INSERT INTO bzj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Faiv lee berd oanli kaas too sehn. Stil, Gaad noh faget nat wan a dehn. ");
INSERT INTO bzj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hihn eevn konk humoch grayn a hyaa deh pahn unu hed. Soh noh frayd kaa unu wot moa tu hihn dahn wahn hoal flak a berd. ");
INSERT INTO bzj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Mek Ah tel unu sohnting: if enibadi oan op ahn seh fronta ada peepl dat dehn bilangz tu mee, den di Son a Man wahn oan dehn fronta Gaad aynjel dehn! ");
INSERT INTO bzj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bot if enibadi play laik dehn noh noa mee fronta ada peepl, Ai wahn disoan dehn tu, rait fronta Gaad aynjel dehn. ");
INSERT INTO bzj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Stil, Gaad wahn fagiv dehn wan weh taak gens di Son a Man, bot if enibadi taak gens di Hoali Spirit, Gaad wahn neva fagiv dehn. ");
INSERT INTO bzj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ahn wen dehn bring unu fronta di leeda dehn eena di sinagag, ahn chrai unu fronta majischrayt ahn peepl weh ga powa, noh wori bowt weh unu wahn seh er how unu wahn difen unuself. ");
INSERT INTO bzj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Di Hoali Spirit wahn mek unu noa egzakli weh fi seh sayhn taim wen unu di stan op deh.” ");
INSERT INTO bzj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Den sohnbadi fahn di krowd hala owt seh, “Teecha, pleez tel mi breda fi shayr op wi pa legisi wid mi noh?” ");
INSERT INTO bzj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jeezas ansa seh, “Mi fren, nobadi neva sen mee fi bee no joj oava unu er gi mee di rait fi disaid sohnting laik dat.” ");
INSERT INTO bzj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Den ih tel di krowd, “Kyaaful! Main dat da noh jos greedi yu greedi. Noh bikaa yu oan wahn lata tingz dat meen dat yu wahn liv wahn lang ahn hapi laif.” ");
INSERT INTO bzj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jeezas tel dehn dis parabl az wahn egzampl. Ih seh, “Dehn mi ga wahn rich man weh mi ga wahn faam weh oanli mi-di praspa. ");
INSERT INTO bzj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Di man seh tu ihself, ‘Da weh Ah wahn du now? Ah noh ga no way weh big nof fi hoal aala mi krap.’ ");
INSERT INTO bzj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Den ih seh, ‘Ah noa weh Ah wahn du, Ah wahn brok dong dehn stoaroom weh Ah ga ahn bil sohn biga wan. Den Ah wahn ga nof spays fi put mi krap ahn aala mi ada gudz dehn. ");
INSERT INTO bzj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Afta dat, Ah wahn krak bak ahn seh tu miself, “Bwai, yu ga nof ting put op fi laas yu yaaz ahn yaaz! Now tek it eezi! Eet ahn jrink ahn injai yuself!”’ ");
INSERT INTO bzj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Bot Gaad seh tu ahn, ‘Yu oal fool, yu! Tunait tunait yoo wahn ded. Den hoo wahn injai aala dehn ting weh yu put op fi yuself?’” ");
INSERT INTO bzj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Soh Jeezas gaahn hed ahn seh, “Yes, dat da egzakli weh wahn hapm tu enibadi weh pail op richiz oanli fi fi dehn oanself, bot dehn noh pay no main tu di richiz weh kohn fahn Gaad.” ");
INSERT INTO bzj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jeezas ton tu ih disaipl dehn ahn seh, “Soh Ah di tel unu, noh wori bowt laif, laik weh yu wahn eet; ahn noh wori bowt yu badi, bowt weh yu wahn wayr. ");
INSERT INTO bzj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Laif da moa dahn jos food, ahn yu badi da moa dahn weh yu wahn put aan pan it. ");
INSERT INTO bzj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Luk pahn di blakbod dehn; dehn neva hafu plaant ner reep ner put op food eena stoaroom kaa Gaad feed dehn. Ahn unu wot faar moa tu hihn dahn eni berd! ");
INSERT INTO bzj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wich wan a unu tink seh dat wen unu wori ih wahn mek unu ad aan wan moa owa tu unu laif? ");
INSERT INTO bzj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","If wori kyaahn eevn du wahn lee ting laik dat, wel wai yu wahn wori bowt evriting els den? ");
INSERT INTO bzj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Luk pahn how di wail flowaz dehn groa. Dehn noh werk ner mek kloaz fi wayr. Bot Ah di tel unu dis, noh eevn King Salaman, wid aala fi hihn fansi kloaz, neva luk az gud az dehnya flowaz ya. ");
INSERT INTO bzj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Now if Gaad jres op di graas weh groa owt eena di feel dehn, weh deh ya tudeh ahn jrai op ahn geh bon op tumaaro, ih noh mos wahn fain kloaz fi unu tu? Unu fayt leel, sa! ");
INSERT INTO bzj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ahn noh fret unu haat bowt weh unu wahn eet er weh unu wahn jrink; jos noh wori! ");
INSERT INTO bzj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dehndeh kaina ting da weh peepl weh noh noa Gaad goh afta. Unu Faada op da hevn don noa dat unu need aala dehn ting deh aredi. ");
INSERT INTO bzj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bot weh unu fi aym fa fos da fi bee paat a Gaad kingdom, ahn den hihn wahn gi unu aala dehnya ting weh unu need. ");
INSERT INTO bzj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Da oanli wahn lee bit a unu weh di fala mi, bot dat noh meen dat unu hafu frayd kaa unu Faada oanli tu hapi fi gi unu di rait fi rool lang wid ahn. ");
INSERT INTO bzj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Unu mos sel weh unu ga ahn gi tu di poa. Dat da weh wahn mek unu ga richiz eena hevn, ahn dehn pers eena hevn noh ga no hoal! Unu richiz wahn sayf; nobadi kyaahn teef it, ahn no insek kyaahn eet it. ");
INSERT INTO bzj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yu si, eniway wehpaa unu richiz deh, da rait deh unu haat wahn deh tu. ");
INSERT INTO bzj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Aalwayz mek shoar unu redi fi wen Ah kohn bak, sayhn laik dehn servant weh di wayt fi dehn maasta kohn bak fahn wahn wedn. Dehn don jres ahn ga dehn lait di shain, soh dat di minit ih kohn ahn nak pahn di doa, dehn wahn redi fi oapm it ahn let ahn een. ");
INSERT INTO bzj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ih wahn gud fi dehn wan weh di maasta fain redi di wayt fi wen ih kohn bak. Ah di tel unu di chroot, di maasta wahn put aan wahn aypran ahn mek dehn sidong fi eet, ahn serv dehn ihself. ");
INSERT INTO bzj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ih mait kohn midl nait, er jos bifoa maanin, bot enitaihn ih kohn, ih wahn gud fi dehn wan weh redi! ");
INSERT INTO bzj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Bot andastan dis: If di oana a di hows mi noa weh taim di teef mi wahn kohn, ih neva mi wahn mek dehn brok eena ih hows. ");
INSERT INTO bzj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Soh unu mos redi tu, kaa di Son a Man di kohn wen unu lees ekspek.” ");
INSERT INTO bzj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peeta aks ahn seh, “Laad, dis parabl da jos fi wee er fi evribadi?” ");
INSERT INTO bzj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jeezas ansa ahn seh, “Soh da hoo da wahn servant weh waiz, weh ih baas ku pen pan? Da di wan weh ih baas wahn put in chaaj a aala di servant dehn eena ih hows; da servant wahn si tu it dat evribadi weh werk eena ih hows geh dehn food tu taim. ");
INSERT INTO bzj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ih wahn gud fi da servant if ih baas kohn bak ahn fain ahn di du di jab weh ih lef ahn fi du. ");
INSERT INTO bzj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ah di tel unu di chroot, dat da di wan weh di baas wahn put in chaaj a evriting weh ih oan. ");
INSERT INTO bzj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Bot sopoaz da servant seh tu ihself seh, ‘Mai baas hihn di tek lang fi kohn.’ Soh ih staat tu beet op di ada servant dehn, man ahn uman sayhn way, ahn ih staat tu eet op ahn jrink op ahn geh jronk. ");
INSERT INTO bzj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Soh den, fi hihn baas wahn kohn wahn day ahn wahn taim wen da servant lees ekspek. Ih baas wahn ponish ahn bad ahn sen ahn sayhn plays weh aala dehn wan weh noh bileev eena Gaad deh. ");
INSERT INTO bzj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Di servant weh noa weh ih baas waahn ih du ahn ih noh redi ahn wilin fi du it wahn geh ponish bad. ");
INSERT INTO bzj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bot di servant weh du sohnting rang kaa ih neva noa weh ih baas mi waahn ih du, oanli wahn geh wahn lee bit a ponishment. If peepl gi yu wahn lat, dehn ekspek wahn lat fahn yu, ahn di moa dehn gi yu, di moa dehn wahn ekspek bak fahn yu. ");
INSERT INTO bzj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ai kohn fi staat faiya pahn dis ert, an Ah wish dat ih mi don kech. ");
INSERT INTO bzj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Bot Ah ga wahn terabl sofarin fi goh chroo fos, an Ah wahn deh anda lata schres til ih don. ");
INSERT INTO bzj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Unu tink seh Ai kohn fi bring pees pahn dis ert? No, Ah di tel unu, Ai kohn fi mek peepl pik said. ");
INSERT INTO bzj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Fahn ya goh bak wahn famili a faiv peepl wahn split: chree wahn said wid mee, ahn too wahn deh gens mi—er di neks way rong. ");
INSERT INTO bzj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pa wahn deh gens son ahn son gens pa; ma gens daata ahn daata gens ma, mada-in-laa gens daata-in-laa, ahn daata-in-laa gens mada-in-laa.” ");
INSERT INTO bzj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Den Jeezas ton tu di krowd ahn seh, “Wen unu si klowd staat mek op eena di wes, unu seh, ‘Rayn di kohn.’ Ahn unu rait. ");
INSERT INTO bzj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wen breez bloa fahn di sowt, unu seh, ‘Tudeh wahn hat bad.’ Ahn ih hat fi chroo. ");
INSERT INTO bzj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Unu hipokrit unu! Unu noa how fi reed di sain dehn eena di ert ahn di skai, soh how kom unu noh andastan di sain dehn weh shoa weh Gaad di du rait now? ");
INSERT INTO bzj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ahn wai unu kyaahn disaid fi unuself weh rait? ");
INSERT INTO bzj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","If yu enimi di kehr yu da koat, chrai setl unu ting bifoa unu get deh, noh; adawaiz ih mait haal yu fronta di joj, ahn den di joj wahn mek polees pich yu eena jayl. ");
INSERT INTO bzj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ah di tel yu, yu noh wahn get owt til unu pay aaf evri jak sent weh yu hoa.” ");
INSERT INTO bzj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Bowt dis sayhn taim, sohn peepl kohn tel Jeezas bowt how Pailat mi merda sohn peepl fahn Gyalilee wail dehn mi-di mek sakrifais tu Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jeezas aks dehn seh, “Unu tink seh dehn peepl mi sofa soh moch kaa dehn da-mi wosa sina dan di ada peepl dehn fahn Gyalilee? ");
INSERT INTO bzj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","No, sa! Ahn unu wahn ded tu if unu noh ton fahn unu sin dehn ahn ton tu Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ahn how bowt dehn ayteen man weh ded wen di Towa a Siloam jrap pahn dehn? Unu tink seh dehn da-mi di wos sina dehn eena Jeroosalem? ");
INSERT INTO bzj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","No! Ah tel unu agen, if unu noh ton fahn unu sin dehn, unu wahn ded tu.” ");
INSERT INTO bzj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Den Jeezas tel dehn dis parabl: “Wahn man mi ga wahn fig chree eena ih gyaadn ahn ih stodi kohn si if eni froot mi deh pan it. Bot ih neva fain non. ");
INSERT INTO bzj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Lang at laas, ih seh tu ih gyaadna, ‘Now luk ya, fi chree yaaz Ah di kohn luk fi si if eni fig deh pahn dis chree, bot Ah noh fain wahn singl wan. Kot it dong, man. Ih jos di tek op spays weh wi ku yooz fi sohnting els.’ ");
INSERT INTO bzj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Bot di gyaadna tel ahn seh, ‘Maasta, noh giv op pan it yet. Lef it wan moa yaa, an Ah wahn ten tu it, ahn put fertilaiza pan it. ");
INSERT INTO bzj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","If wi geh fig neks yaa, gud. If wi noh get, den Ah wahn kot it dong.’” ");
INSERT INTO bzj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wahn day pahn di Sabat, Jeezas mi-di teech eena wan a di sinagag dehn. ");
INSERT INTO bzj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ih si wahn laydi weh wan eevl spirit mi ga kripl op fi ayteen yaaz. Ih mi ben rait oava ahn kudn eevn schraytn op ihself. ");
INSERT INTO bzj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Soh wen Jeezas si ahn, ih kaal ahn tu ahn, ahn seh, “Mis, yu free fahn yu siknis!” ");
INSERT INTO bzj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Den ih toch ahn, ahn sayhn taim di laydi kuda mi stan op schrayt, ahn ih staat tu prayz Gaad! ");
INSERT INTO bzj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Di hed a di sinagag mi beks laik how Jeezas heel di laydi pahn di Sabat. Ih seh tu di krowd, “Unu ga siks dayz eena di week fi werk. Wai unu noh goh goh geh heel den? Noh goh pahn di Sabat.” ");
INSERT INTO bzj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bot Jeezas ansa seh, “Unu hipokrit unu! Unu anaal werk pahn di Sabat. Unu noh loos unu bul er unu dongki fi goh jrink waata pahn di Sabat? ");
INSERT INTO bzj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wel, dis laydi da wan a unu oan Jooish sista weh Saytan mi ga anda bandij fi hoal a ayteen yaaz. Soh unu noh tink ih rait fi heel ahn pahn di Sabat?” ");
INSERT INTO bzj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wen Jeezas seh aala dis, ih enimi dehn mi shaym, ahn di res a peepl dehn mi glad fi si aala di wandaful ting dehn weh ih mi du. ");
INSERT INTO bzj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Den Jeezas seh, “Now, da weh Ah ku tel unu Gaad kingdom stan laik? Wich lee stoari Ah ku tel fi shoa unu? ");
INSERT INTO bzj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Da laik wahn lee kungku mostad seed weh sohnbadi plaant eena ih gyaadn, ahn ih groa til ih ton intu wahn chree, ahn di berd dehn eena di skai kohn kohn mek nes eena ih branch dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Den Jeezas tel dehn dis agen: “Wat els Ah ku tel unu Gaad kingdom stan laik? ");
INSERT INTO bzj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Da laik ees weh wahn laydi miks wid wahn hoal lata flowa ahn di ees mek di hoal doa rayz.” ");
INSERT INTO bzj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jeezas gaahn chroo di tong ahn di vilij dehn di teech, ahn di hoal taim ih mi-di hed fi reech Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wahn day sohnbadi aks ahn seh, “Laad, da fi chroo oanli lee bit a peepl wahn geh sayv?” Jeezas ansa seh, ");
INSERT INTO bzj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Unu beta chrai unu bes fi get een chroo di gayt weh naro kaa wahn lat wahn chrai, bot dehn wahn kyaahnt. ");
INSERT INTO bzj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wans di hed a di hows don get op ahn lak di doa, unu wahn lef di stan op owtsaid di nak ahn di bayg seh, ‘Laad, oapm di doa fi wi noh?’ “Bot ih wahn tel unu, ‘Mee noh noa da hoo unu er weh unu kohn fram!’ ");
INSERT INTO bzj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Den unu wahn seh, ‘Bot wee yoostu eet ahn jrink wid yoo, ahn yoo doz teech pahn fi wee schreet dehn tu, memba?’ ");
INSERT INTO bzj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ahn di hed a di hows wahn seh, ‘Ah don tel unu aredi, Ai noh noa unu! Get fahn fronta mi, aala unu wikid peepl unu!’ ");
INSERT INTO bzj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Unu wahn si Aybraham ahn Aizak ahn Jaykop, ahn aala di prafit dehn eena Gaad kingdom, bot unu unuself wahn deh owt deh di baal ahn di grain op unu teet, kaa unu wahn geh pich owt! ");
INSERT INTO bzj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Den lata peepl weh da noh Joo wahn kohn fahn naat, sowt, ees ahn wes, kohn sidong rong di taybl fi eet eena Gaad kingdom. ");
INSERT INTO bzj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ahn yehr ya! Som a dehn wan weh peepl luk dong pahn rait now wahn geh hai plays, ahn sohn weh ga hai plays now wahn geh luk dong pan.” ");
INSERT INTO bzj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sayhn taim sohn Farisee seh tu Jeezas, “Yoo beta get owta ya if yu waahn liv kaa Govna Herod waahn kil yu!” ");
INSERT INTO bzj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jeezas ansa seh, “Goh goh tel da faks dat tudeh ahn tumaaro Ah wahn kip di chays owt deeman ahn heel peepl, den pahn di terd day Ah wahn finish weh Ah kohn kohn du. ");
INSERT INTO bzj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ah oanli ga tudeh ahn tumaaro, ahn den di neks day Ah wahn hafu goh pahn mi way, kaa wahn prafit a Gaad noh fi geh kil eena no ada plays eksep Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Aiy Jeroosalem, Jeroosalem, yoo da di siti weh kil aaf di prafit dehn; unu stoan Gaad mesinja dehn! Yu noa humoch taim Ah mi waahn gyada op yu peepl dehn tugeda laik how wahn hen wuda protek ih baybi chikin dehn anda ih wing? Bot unu neva waahn mek Ah du it. ");
INSERT INTO bzj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ahn now si, Gaad noh deh eena yu templ nohmoh. Ah di tel unu, unu noh wahn si mi agen til wen unu seh, ‘Gaad bles di Wan weh kom eena di naym a di Laad.’” ");
INSERT INTO bzj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wahn day, pahn di Sabat, Jeezas mi gaahn da wan a di leeda a di Farisee dehn hows fi eet. Evribadi mi-di wach Jeezas haad fi si weh ih mi wahn du. ");
INSERT INTO bzj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Sayhn taim wahn man kohn fronta ahn wid ih too han ahn ih too fut swel op. ");
INSERT INTO bzj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jeezas aks di Farisee ahn dehn wan weh teech di Laa dehn, “Da weh unu tink? Akaadn tu di Laa, ih rait fi heel peepl pahn di Sabat er nat?” ");
INSERT INTO bzj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dehn neva ansa ahn, soh Jeezas toch di sik man ahn heel ahn, ahn sen ahn pahn ih way. ");
INSERT INTO bzj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Den ih ton tu dehn ahn aks, “If unu pikni er unu kow jrap eena wahn wel, unu noh wahn hori tek ahn owt, eevn if da di Sabat?” ");
INSERT INTO bzj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Agen, dehn kudn ansa. ");
INSERT INTO bzj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wen Jeezas noatis seh aala dehn weh mi kohn da di dina mi-di fait fi sidong da di hed a di taybl, ih gi dehn dis lee advais: ");
INSERT INTO bzj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“If dehn invait unu da wahn wedn, noh ron goh sidong da di bes seet. Sopoaz sohnbadi weh moa impoatant dan yoo mi geh invaitid tu, ");
INSERT INTO bzj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ahn di persn weh invait unu kohn seh tu yu, ‘Mek hihn sidong ya insteda yoo.’ Den yu wahn feel shaym, ahn yu wahn hafu tek di seet weh deh way da di en a di taybl! ");
INSERT INTO bzj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Insteda goh chroo aala dat, wen dehn invait yu, sidong da di en a di taybl. Ahn den di wan weh invait yu wahn tel yu, ‘Mi fren, wahn beta seet deh op ya fi yu!’ Den yu wahn feel gud kaa aala di ada ges dehn wahn aana yu. ");
INSERT INTO bzj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Soh den, aala dehn wan weh tink dehn hai ahn maiti wahn geh bring dong, bot Gaad wahn rayz op dehn wan weh hombl dehnself.” ");
INSERT INTO bzj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Den Jeezas ton tu di man weh invait ahn, ahn ih seh, “Wen yu ga wahn speshal lonch er bankwit, noh invait yu fren ahn yu breda ahn yu faamli, er yu rich nayba dehn; kaa dehn ku invait yu bak da fi dehn hows, ahn dat da how yu wahn geh pay bak fi weh yu du. ");
INSERT INTO bzj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bot wen yu ga wahn bankwit, invait dehn wan weh poa, ahn weh kripl, ahn dehn wan weh haafa, ahn weh blain. ");
INSERT INTO bzj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Den Gaad wahn bles yu kaa yu invait dehn wan weh kudn pay yu bak. Hihn wahn riwaad yu pahn da day wen dehn wan weh raichos wahn rayz op bak fahn di ded.” ");
INSERT INTO bzj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wen wan a di man dehn weh mi-di sidong rong di taybl yehr dis, ih geh eksaitid ahn seh, “Hmm! Di peepl weh wahn eet da di bankwit weh Gaad wahn ga eena ih kingdom wahn hapi!” ");
INSERT INTO bzj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jeezas ansa seh, “Wahn taim wahn man fiks wahn bankwit ahn sen owt werd fi invait wahn lata peepl. ");
INSERT INTO bzj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wen evriting mi don redi, ih sen ih servant fi tel dehn wan weh mi invaitid tu di bankwit seh, ‘Unu ku kohn now; evriting don redi.’ ");
INSERT INTO bzj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Bot den wan afta di ada, peepl staat mek aal kaina ekskyooz. Di fos wan seh, ‘Ai jos bai sohn lan, an Ah hafu goh luk pan it. Soh Ah bayg ekskyooz.’ ");
INSERT INTO bzj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Wahn nada wan seh, ‘Ai jos bai faiv set a kow fi plow mi feel, an Ah waahn chrai dehn owt. Pleez ekskyooz mi.’ ");
INSERT INTO bzj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Stil wahn neks wan seh, ‘Wel, mee jos geh marid, an Ai kyaahn kohn.’ ");
INSERT INTO bzj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Di servant kohn bak ahn tel ih maasta weh di peepl dehn seh. Ih maasta geh soh beks dat ih seh, ‘Mikays ahn goh owt pahn aala di schreet dehn ahn di aali dehn eena di siti, ahn invait aala di poa peepl dehn, ahn peepl weh kripl, ahn weh haafa, ahn dehn wan weh blain.’ ");
INSERT INTO bzj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Wen di servant kohn bak, ih seh, ‘Sa, Ah don du aal weh yu tel mi fi du, ahn wi stil ga spays fi moa peepl.’ ");
INSERT INTO bzj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Soh ih maasta seh, ‘Goh owt pahn di haiway dehn ahn eena aala dehn lee pikaado road, ahn enibadi weh yu ku fain, mek shoar dehn kohn. Ah waahn si mi hows ful ful. ");
INSERT INTO bzj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ah di tel unu, non a dehn wan weh Ah mi invait fos noh eevn wahn geh wahn lee tays a weh Ah mi fiks fi dehn.’” ");
INSERT INTO bzj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wahn big krowd mi-di fala Jeezas. Ih ton rong ahn tel dehn seh, ");
INSERT INTO bzj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“If eni a unu waahn bee wan a fi mee disaipl, unu wahn hafu lov mee moa dan how unu lov unu ma ahn pa, unu waif ahn pikni, er unu breda ahn sista. Unu wahn eevn hafu lov mi moa dan unu oan laif! Adawaiz, unu kyaahn bee mi disaipl. ");
INSERT INTO bzj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ahn nobadi kyaahn bee mi disaipl if dehn noh wilin fi bak dehn oan kraas ahn fala mee. ");
INSERT INTO bzj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Sopoaz eni wan a unu waahn put op wahn bildin. Yu noh wahn sidong fos ahn figa owt humoch ih wahn kaas, fi si if yu ga nof moni fi finish it? ");
INSERT INTO bzj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","If yu noh du dat, yu mait oanli ku don di fongdayshan bifoa yu ron owta moni. Den evribadi weh si wahn laaf aata yu. ");
INSERT INTO bzj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Dehn wuda seh, ‘Luk pahn da wan hihn weh staat da bildin ahn kudn finish it!’ ");
INSERT INTO bzj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Er wich king wuda eva jreem bowt goh da waar widowt sidong fos ahn kansida weda fi hihn aami, weh ga ten towzn man, schrang nof fi beet di enimi weh di kohn gens ahn wid tweni towzn? ");
INSERT INTO bzj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","If ih disaid seh ih kyaahn beet dehn, den ih wahn sen som a ih man dehn fi goh taak pees wail di enimi stil deh faar. ");
INSERT INTO bzj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Soh, nobadi kyaahn bee wan a mi disaipl widowt giv op evriting fi mee. ");
INSERT INTO bzj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Saalt da wahn gud ting, bot if ih noh tays saalti nohmoh, da how yu wahn mek it saalti agen? ");
INSERT INTO bzj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kaa laik dat ih noh gud fi notn, noh eevn fi mek fertilaiza. Dehn jos chroa dat weh. Eni a unu weh ga ayz fi yehr, unu lisn gud!” ");
INSERT INTO bzj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Now aala di man dehn weh kalek taks ahn sohn ada sina dehn staat tu jraa op kloas tu Jeezas fi lisn tu ahn. ");
INSERT INTO bzj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bot sohn Farisee ahn dehn wan weh teech di Laa mi-di grombl seh, “Disya man hihn oanli ku miks op wid di sina dehn, sa. Ih eevn eet lang wid dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Soh Jeezas tel dehn dis stoari. Ih seh, ");
INSERT INTO bzj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Sopoaz wan a unu mi ga wahn honjrid sheep ahn den yu laas wan a dehn. Yu noh tink dat yu wuda lef di nainti-nain weh yu ga eena di paascha ahn goh luk fi di wan weh laas til yu fain ahn? ");
INSERT INTO bzj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ahn wen yu fain ahn, yu wahn oanli feel gud! Yu wahn put ahn pahn yu shoalda ahn bring ahn hoahn. ");
INSERT INTO bzj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wen yu reech hoahn, yu wahn kaal aala yu nayba dehn ahn tel dehn seh, ‘Kohn selibrayt wid mi kaa Ah fain mi sheep weh Ah mi laas.’ ");
INSERT INTO bzj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ah di tel yu, da rait soh ih wahn stay da hevn; moa rijaisin wahn deh oava wan sina weh ton fahn dehn sin dehn, dan nainti-nain a dehn wan weh gud, weh don ton fahn dehn sin dehn aredi. ");
INSERT INTO bzj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Er sopoaz wahn laydi mi ga ten silva kain ahn den ih laas wan a dehn. Yoo noh tink shee wuda lait wahn lamp ahn sweep di hows, ahn saach aal bowt til ih fain it? ");
INSERT INTO bzj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ahn wen ih fain it, ih wahn kaal aala ih fren ahn nayba dehn tugeda ahn tel dehn seh, ‘Kohn selibrayt wid mi kaa Ah fain di kain weh Ah mi laas.’ ");
INSERT INTO bzj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ah di tel unu, sayhn way lata rijaisin wahn deh fronta Gaad aynjel dehn wen eevn wan sina ton fahn ih sin dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Den Jeezas seh, “Dehn mi ga dis man weh mi ga too son. ");
INSERT INTO bzj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Di yonga wan kohn tu ih pa ahn seh, ‘Pa, gi mee fi mee shayr a di legisi.’ Soh ih pa shayr op aal weh ih mi ga bitween di too bwai dehn. ");
INSERT INTO bzj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Sohn dayz layta, di yonga son put tugeda aala weh ih mi gat, ahn gaahn da wahn nada konchri faar fahn hoahn, ahn wen ih get deh, ih ways owt aala ih moni pahn aal kaina doti livin. ");
INSERT INTO bzj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ahn afta ih don ways owt aala ih moni, tingz geh soh bad deh dat peepl mi-di ded fi hongri, ahn hihn staat tu feel di lik tu. ");
INSERT INTO bzj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Soh ih gaahn werk fi wan a di peepl dehn fahn deh weh sen ahn da ih faam fi main pig. ");
INSERT INTO bzj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Di bwai geh soh hongri dat ih akchwali mi-di tink bowt eet di food weh di pig dehn mi-di eet, bot nobadi neva gi ahn notn. ");
INSERT INTO bzj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ahn wen ih kech op ihself, ih seh, ‘Luk humoch ting dehn peepl weh di werk fi mai pa ga fi eet. Dehn ga nof fi stoan daag wid, an Ai deh ya soh di ded fi hongri. ");
INSERT INTO bzj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ah wahn get op ahn goh bak tu mi pa, an Ah wahn tel ahn: Pa, Ah mi sin gens Gaad an Ah sari fi weh Ah du yoo tu. ");
INSERT INTO bzj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Noh kaal mi yu son nohmoh kaa Ah noh gud fi notn. Mek Ah bee laik wan a dehn man weh werk fi yu.’ ");
INSERT INTO bzj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Soh ih get op ahn gaahn bak da ih pa. “Wail ih mi stil deh wahn gud wayz dong di road, ih pa spat ahn di kohn ahn ih haat gaan owt tu ahn. Ih ron tu ahn, ahn hog ahn op tait tait, ahn kis ahn. ");
INSERT INTO bzj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Bot di bwai tel ahn seh, ‘Pa, Ah mi sin gens Gaad an Ah sari fi weh Ah du yoo tu. Noh kaal mi yu son nohmoh kaa Ah noh gud fi notn.’ ");
INSERT INTO bzj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Bot ih pa tel di servant dehn, ‘Mikays ahn bring di bes soot a kloaz ahn put it pan ahn. Put wahn ring pahn ih finga ahn put aan shooz pahn ih fut. ");
INSERT INTO bzj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bring di kyaaf weh wi mi-di fatn op, ahn kil it mek wi eet ahn selibrayt. ");
INSERT INTO bzj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Dis da mai son weh mi gud az ded, bot ih kohn bak tu laif. Ih mi laas, bot now wi gat ahn bak.’ Soh dehn staat tu paati. ");
INSERT INTO bzj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Now di oalda son mi deh da di plantayshan. Az ih mi-di reech hoahn, ih yehr myoozik ahn ih si peepl di daans. ");
INSERT INTO bzj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Soh ih kaal wan a di servant dehn ahn aks ahn seh, ‘Da weh di goh aan een deh?’ ");
INSERT INTO bzj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ih tel ahn seh, ‘Yu breda kohn bak hoahn, ahn soh yu pa kil di kyaaf weh wi mi-di fatn op, sayka weh ih kohn bak sayf ahn song.’ ");
INSERT INTO bzj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Di oalda breda geh soh beks, ih rifyooz fi goh eena di hows. Soh ih pa gaan owt fi koaks ahn fi kom een. ");
INSERT INTO bzj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bot ih ansa ih pa ahn seh, ‘Fi soh lang Ai deh ya di slayv fi yoo, an Ah neva yet gaahn gens weh yu tel mi. Yu neva wan taim seh mek yu gi mi wahn lee yong goat mek Ah ga wahn lee paati wid mi fren dehn. ");
INSERT INTO bzj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bot wen fi yoo son hihn kohn hoahn, weh don ways owt aala yu moni pahn doti livin ahn ting, yu ron gaahn kil di speshal kyaaf weh wi mi-di fatn op!’ ");
INSERT INTO bzj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Bot ih pa seh tu ahn, ‘Son, yoo aalwayz deh wid mi, ahn evriting weh Ah ga da fi yoo. ");
INSERT INTO bzj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Soh wi mi hafu feel gud ahn selibrayt bikaa fi yoo breda weh mi gud az ded kohn bak tu laif. Ih mi laas ahn wi get ahn bak.’” ");
INSERT INTO bzj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jeezas mi-di tel ih disaipl dehn seh, “Dehn mi ga wahn sertn rich man weh mi haiya wahn man ahn put ahn in chaaj a evriting weh ih oan. Afta wahn wail ih reech di baas ayz dat di man mi-di ways owt ih moni. ");
INSERT INTO bzj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Soh di rich man sen kaal di man ahn aks ahn seh, ‘Da weh dis Ai di yehr bowt yoo? Luk ya, Ah wahn hafu let yu goh, bot fos Ah waahn yu gi mi wahn ful ripoat pahn egzakli how yu spen mi moni.’ ");
INSERT INTO bzj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Di man seh tu ihself, ‘Hmm! Da weh Ah wahn du now laik how dehn di faiya mi, goh dig jrayn? Cho! Ai noh schrang nof fi du dat ataal, an Ah shaym fi bayg. ");
INSERT INTO bzj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah-haahn! Ah noa egzakli weh Ah wahn du, soh dat wen dehn faiya mi, peepl wahn glad fi mek Ah kohn liv wid dehn da dehn hows.’ ");
INSERT INTO bzj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Soh wan bai wan, ih sen kaal evribadi weh mi hoa ih baas. Ih aks di fos wan, ‘Da weh yoo hoa mai baas?’ ");
INSERT INTO bzj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Di fos wan tel ahn seh, ‘Ayt honjrid gyalan a aliv ail.’ “Ih tel da wan, ‘Hori sidong ahn chaynj yu bil tu foa honjrid insted.’ ");
INSERT INTO bzj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Den ih seh tu wahn neks wan, ‘Ahn yoo, humoch yoo hoa?’ “Da wan seh, ‘Ai hoa ahn wan honjrid sak a flowa.’ “Ih seh tu da wan, ‘Tek yu bil ahn chaynj it tu ayti.’ ");
INSERT INTO bzj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Eevn doa di man neva aanis, di rich man mi hafu admaiya ahn fi how ih mi yooz ih hed; kaa wen ih kohn tu how dehn handl dehn bizniz, di peepl dehn a dis werl moa braynziya dan di peepl weh serv Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ah di tel unu dis, yu moni noh wahn laas fareva, soh yooz wateva unu ga pahn dis ert fi bee wahn gud fren tu peepl, ahn den Gaad wahn glad fi gi unu wahn hoam op da hevn. ");
INSERT INTO bzj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Unu si, enibadi weh yu ku chros wid di lee ting dehn, yu wahn ku chros wid di big ting dehn tu. Ahn enibadi weh yu kyaahn chros wid di leelis a ting, yu wahn kyaahn chros dehn wid di big ting dehn needa. ");
INSERT INTO bzj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ahn if dehn kyaahn chros unu fi handl richiz weh deh dong ya pahn dis ert, den how enibadi wahn ku chros unu wid di kaina richiz weh deh da hevn? ");
INSERT INTO bzj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","If dehn kyaahn chros unu fi handl ada peepl ting gud, den nobadi wahn waahn gi unu notn fi unuself. ");
INSERT INTO bzj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“No servant kyaahn serv too maasta. Eeda yu wahn hayt wan ahn lov di neks, er yu wahn rispek wan ahn kyaahn stan di neks wan. Rait soh, unu kyaahn serv Gaad ahn moni sayhn taim.” ");
INSERT INTO bzj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Now wen di Farisee dehn yehr aala dis, dehn staat tu tek Jeezas mek papishoh kaa dehn mi oanli lov moni. ");
INSERT INTO bzj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Soh Jeezas tel dehn seh, “Unu laik luk gud fronta peepl, bot Gaad noa egzakli weh deh eena unu haat. Yu si di ting dehn weh peepl tink wot soh moch? Wel, Gaad oanli fain dehn disgostin! ");
INSERT INTO bzj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Op til di taim wen Jan di Baptis kohn, peepl yoostu liv bai Moaziz Laa ahn bai weh di oal taim prafit dehn doz preech. Sins den di Gud Nyooz bowt Gaad kingdom di get owt, ahn now evribadi di du dehn bes fi bee paat a fi hihn kingdom. ");
INSERT INTO bzj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Bot dat noh meen seh Moaziz Laa noh impoatant agen, yu noh. No! Az lang az hevn ahn ert stil deh, di leelis leta er eevn wan lee dat eena di Laa noh wahn geh jrap. ");
INSERT INTO bzj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Enibadi weh divoas dehn waif ahn marid tu wahn neks uman di liv eena sin. Ahn di man weh marid tu wahn uman weh divoas di liv eena sin tu.” ");
INSERT INTO bzj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Den Jeezas seh, “Yu mi ga dis sertn rich man weh doz jres op eena di bes kloaz weh moni kuda mi bai, ahn ih mi ga evriting weh yu kuda mi tink bowt fi eet evri day. ");
INSERT INTO bzj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Dehn mi ga wahn poa poa man weh mi nayhn Lazaros weh mi ful op a soar aal oava ih badi. Dehn yoostu put ahn fi lidong da dis rich man gayt. ");
INSERT INTO bzj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Di poa man mi soh hongri dat ih eevn wuda mi setl fi di skraypinz fahn di rich man taybl. Daag yoostu kohn lik op ih soar dehn anaal. ");
INSERT INTO bzj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Wel, ih soh hapm dat di poa man ded, ahn di aynjel dehn kehr ahn wehpaa Aybraham deh. Di rich man ded tu, ahn ih peepl dehn beri hihn. ");
INSERT INTO bzj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Di rich man gaahn da hel ahn ih mi dehdeh eena taament. Ih luk way op ahn ih si Lazaros weh ih mi deh rait saida Aybraham. ");
INSERT INTO bzj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Ih hala owt, ‘Faada Aybraham! Sari fi mi noh? Sen Lazaros fi dip di tip a ih finga eena waata ahn kohn kool mi tong. Aiy! Ah kyaahn tek dis faiya nohmoh!’ ");
INSERT INTO bzj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Bot Aybraham tel ahn seh, ‘Son, memba eena fi yoo laiftaim, yoo mi ga tingz gud ahn Lazaros mi ga tingz bad. Bot now dehn di komfert hihn, ahn now yoo da di wan weh di ponish. ");
INSERT INTO bzj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bisaidz, wahn big gyap deh bitween weh wee deh ahn weh yoo deh, soh dat nobadi fahn ya kyaahn goh kraas tu weh unu deh, ner non a unu kyaahn kohn wehpaa wee deh.’ ");
INSERT INTO bzj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Di rich man seh, ‘Den Ah bayg yu, Faada Aybraham, pleez sen ahn da mi pa hows, ");
INSERT INTO bzj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kaa Ah ga faiv breda, an Ah waahn Lazaros waan dehn mek dehn noh en op eena disya taament wen dehn ded.’ ");
INSERT INTO bzj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Aybraham ansa ahn seh, ‘Dehn ga aala di ting dehn weh Moaziz ahn di prafit dehn mi rait eena di Skripcha fi waan dehn. Mek dehn lisn tu dehn.’ ");
INSERT INTO bzj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Di rich man seh, ‘No, Faada Aybraham. Dehn noh wahn lisn tu dehn. Bot if sohnbadi goh tu dehn fahn di ded, dehn wahn ton fahn dehn sin dehn.’ ");
INSERT INTO bzj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Aybraham tel ahn seh, ‘If yu breda dehn noh lisn tu Moaziz ahn di prafit dehn, den eevn if sohnbadi kom op fahn di ded, dehn stil noh wahn lisn tu dehn needa.’” ");
INSERT INTO bzj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jeezas seh tu ih disaipl dehn, “Temtayshan fi sin wahn aalwayz deh, bot di persn weh mek sohnbadi els sin wahn eena big chrobl. ");
INSERT INTO bzj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ih wuda beta fi dehn if dehn tai wahn big hevi rakstoan rong dehn nek ahn chroa dehn da see dan fi hihn mek eni wan a dehn lee pikni ya du di rang ting. ");
INSERT INTO bzj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Soh wach yuself now. “If eni a yu brada du eniting rang, tel ahn bowt it. If ih sari fi weh ih du ahn ih waahn chaynj ih wayz, den yu mos fagiv ahn. ");
INSERT INTO bzj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Eevn if ih du eniting fi hert yu sebm taim eena wan day, ahn ih kohn tu yu evri taim ahn seh, ‘Ah noh wahn du it agen,’ stil fagiv ahn.” ");
INSERT INTO bzj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Di apasl dehn seh tu Jeezas, “Laad, gi wi moa fayt.” ");
INSERT INTO bzj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Di Laad tel dehn seh, “If unu ga fayt di saiz a wahn lee chinchi mostad seed, unu wahn ku tel dis big beriz chree, ‘Root op yuself ahn plaant yuself eena di see,’ ahn ih wahn obay yu.” ");
INSERT INTO bzj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Sopoaz wan a unu ga wahn servant weh jos kom een fahn plow yu feel er tek kayr a sheep. Yu tink yu wuda tel ahn seh, ‘Hori kohn ahn tek yu plays da di taybl’? ");
INSERT INTO bzj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","No. Insted, yu wahn tel ahn seh, ‘Kohn kohn fiks tee fi mi. Put aan yu aypran ahn ten tu mi, mek Ah eet ahn jrink; den aftawodz yoo ku eet ahn jrink tu.’ ");
INSERT INTO bzj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yu noh eevn wahn tank ahn fi du weh yu tel ahn. ");
INSERT INTO bzj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Rait soh wid unu, wen unu don du evriting weh unu get aadaz fi du, unu fi seh, ‘Wee da jos aadineri servant; wee oanli du weh da wi jooti.’” ");
INSERT INTO bzj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Wen Jeezas mi deh pahn di way tu Jeroosalem, ih mi-di paas chroo di ayrya bitween Samayrya ahn Gyalilee. ");
INSERT INTO bzj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Az ih mi-di goh eena wahn vilij, ten man weh mi ga leprosi mi-di kohn tuwaadz ahn. ");
INSERT INTO bzj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Dehn stap wahn lee wayz fahn Jeezas ahn hala tu ahn seh, “Teecha, sari fi wi noh!” ");
INSERT INTO bzj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wen Jeezas si di man dehn, ih tel dehn seh, “Goh shoa unuself tu di prees dehn ahn si if unu noh geh heel.” Ahn az dehn mi-di goh lang, dehn skin geh kleen kleen kleen. ");
INSERT INTO bzj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Den wen wan a dehn noatis dat ih geh heel, ih ton bak ahn staat tu prayz Gaad haad-wan. ");
INSERT INTO bzj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ih chroa dong ihself flat da Jeezas fut ahn tank ahn. Ahn fi si ih da-mi wahn Samaritan tu. ");
INSERT INTO bzj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jeezas aks, “Da neva ten a unu geh heel? Soh weh di neks nain deh? ");
INSERT INTO bzj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Da oanli dis man ya weh da wahn farina noa fi kohn bak kohn prayz Gaad?” ");
INSERT INTO bzj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Den Jeezas tel di man, “Get op ahn goh yu way. Sayka yu fayt, yu heel.” ");
INSERT INTO bzj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Now wahn taim di Farisee dehn aks Jeezas seh, “Da wen Gaad wahn kohn kohn set op fi hihn kingdom?” Jeezas ansa dehn laik dis: “Di way how Gaad wahn rool ih peepl dehn, yu wahn kyaahn see't wid yu aiy. ");
INSERT INTO bzj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nobadi noh wahn ku seh, ‘Si, Gaad kingdom deh ya,’ er ‘Ih dehdeh.’ Kaa Gaad di rool rait eensaida unu.” ");
INSERT INTO bzj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Den Jeezas seh tu ih disaipl dehn, “Di day wahn kohn wen unu wahn lang fi spen eevn wan day wid di Son a Man, bot unu wahn kyaahn du it. ");
INSERT INTO bzj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Peepl wahn tel unu, ‘Si ahn deh!’ er ‘Si ahn ya!’ Noh stodi dehn ataal. ");
INSERT INTO bzj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wen di Son a Man kohn bak, dehn wahn ku si ahn playn playn, jos laik how dehn ku si laitnin di flash fahn wan en a di skai tu di neks. ");
INSERT INTO bzj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bot fos ih wahn hafu sofa wahn lata ting, ahn dis jenarayshan wahn rijek ahn. ");
INSERT INTO bzj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Sayhn laik how ting mi stan eena Noawa dayz, da rait soh ih wahn bee wen di Son a Man kohn bak. ");
INSERT INTO bzj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Peepl mi-di eet op ahn jrink op, ahn dehn mi-di geh marid ahn soh, rait op tu di veri day wen Noawa gaan eena di aak; ahn den di flod kohn ahn dischrai aala dehn. ");
INSERT INTO bzj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Sayhn way eena Lat dayz, dehn mi-di eet op ahn jrink op, ahn di bai ahn sel, ahn di du dehn lee faamin ahn di bil hows. ");
INSERT INTO bzj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bot pahn di day wen Lat lef Sadam, faiya ahn brimstoan rayn dong fahn hevn ahn dischrai aala dehn. ");
INSERT INTO bzj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Da rait soh ih wahn bee wen di Son a Man kohn bak. ");
INSERT INTO bzj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Da day deh, if enibadi deh pahn dehn howstap ahn dehn ga eni bilanginz eensaida dehn hows, noh mek dehn eevn tink bowt goh bak een goh get it. Rait soh, if enibadi deh owt eena dehn feel di werk, dehn noh fi eevn tink bowt goh bak hoahn goh geh notn. ");
INSERT INTO bzj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Memba weh hapm tu Lat waif! ");
INSERT INTO bzj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Enibadi weh fait fi heng aan tu dehn oan laif wahn en op di laas it; bot enibadi weh giv op dehn laif fi sayka mee wahn sayv it. ");
INSERT INTO bzj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ah tel unu, da sayhn nait too peepl wahn di sleep eena wan bed; wan a dehn wahn geh tek weh ahn di neks wan wahn geh lef bihain. ");
INSERT INTO bzj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Too laydi wahn di grain weet tugeda; wan a dehn wahn geh tek weh ahn di neks wan wahn geh lef. ");
INSERT INTO bzj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Too man wahn di werk eena di feel; dehn wahn kehr weh wan, ahn di ada wan wahn geh lef bihain.” ");
INSERT INTO bzj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Di disaipl dehn aks Jeezas seh, “Laad, da wehpaa dis wahn hapm?” Jeezas tel dehn seh, “Eniway wehpaa ded badi deh, da rait dehsoh jranko wahn gyada.” ");
INSERT INTO bzj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Den Jeezas tel dehn wahn lee stoari fi shoa dehn dat dehn fi aalwayz pray ahn noh giv op. ");
INSERT INTO bzj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ih seh, “Eena wahn sertn siti dehn mi ga dis joj weh neva ga no rispek fi nobadi—ih neva eevn mi frayd fi Gaad. ");
INSERT INTO bzj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wahn wido mi liv da da sayhn siti ahn ih stodi mi-di kohn da di joj ahn di tel ahn seh, ‘Ah waahn jostis gens mi enimi.’ ");
INSERT INTO bzj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Fi wahn wail di joj rifyooz ahn; bot aftawodz ih seh tu ihself, ‘Ai noh frayd fi Gaad an Ai noh ga no rispek fi nobadi, ");
INSERT INTO bzj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","bot stil dis wido stay di bog mi, soh Ah wahn gi ahn di jostis weh ih waahn jos soh ih noh wayr mi owt weh ih stodi di kohn di bayg mi ahn di bayg mi.’” ");
INSERT INTO bzj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","7","Ahn den di Laad seh, “Unu yehr weh dis joj seh? Hihn wikid ahn ih stil gi di laydi weh ih waahn. Unu noh tink seh Gaad wahn gi jostis tu dehn wan weh hihn pik owt fi ihself, dehn wan weh kaal owt tu ahn day ahn nait? Unu tink seh Gaad wahn tek lang fi help dehn? ");
INSERT INTO bzj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ah tel unu, ih wahn gi dehn jostis kwik-wan. Bot wen di Son a Man kohn bak, Ah wanda humoch peepl ih wahn fain pahn di ert weh ga fayt.” ");
INSERT INTO bzj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Dehn mi ga sohn peepl weh mi reeli tink seh dehn mi schrayt wid Gaad, ahn weh mi-di luk dong pahn evribadi els, soh Jeezas tel dehn dis parabl: ");
INSERT INTO bzj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Too man gaan op da di templ fi pray. Wan da-mi wahn Farisee, ahn di neks wan da-mi wahn taks kalekta. ");
INSERT INTO bzj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Di Farisee gaahn stan op bai ihself ahn staat tu pray laik dis: ‘Gaad, Ah tank yu dat Ai noh stan laik ada peepl weh teef ahn du aal kaina bad ting, ahn weh sleep rong; er noh eevn laik dis teefin taks kalekta ya. ");
INSERT INTO bzj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ai faas too taim fi di week, an Ah gi ten persent a aala di moni weh Ah mek.’ ");
INSERT INTO bzj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Bot di taks kalekta mi-di stan op way da bak, ahn ih neva eevn waahn lif op ih aiy fi luk op da hevn. Ih nak ih ches fi shoa ih mi sari fi ih sin. Ih seh, ‘Gaad, ga mersi pahn mi. Ai da wahn sina.’” ");
INSERT INTO bzj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jeezas seh, “Ah tel unu, wen di taks kalekta gaahn hoahn, hihn mi stan gud wid Gaad, bot noh di ada wan. Unu si, enibadi weh prayz op dehn oanself wahn geh bring dong. Ahn enibadi weh hombl dehnself wahn geh big op.” ");
INSERT INTO bzj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Now peepl mi-di bring dehn lee baybi tu Jeezas fi mek ih put ih han pahn dehn fi bles dehn. Wen di disaipl dehn si dat, dehn taak tu dehn shaap-wan ahn tel dehn noh fi bada ahn. ");
INSERT INTO bzj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bot Jeezas kaal di pikni dehn tu ahn, ahn ih tel di disaipl dehn seh, “Mek di lee pikni dehn kohn tu mi. Noh stap dehn, kaa peepl weh waahn bee paat a Gaad kingdom hafu stan jos laik lee pikni. ");
INSERT INTO bzj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ah di tel unu di chroot, enibadi weh noh kohn tu Gaad laik wahn lee pikni wahn neva bee paat a Gaad kingdom.” ");
INSERT INTO bzj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Now wahn sertn Jooish rilijos leeda aks Jeezas seh, “Mi gud Teecha, da weh Ah ku du fi geh fi liv wid Gaad fareva?” ");
INSERT INTO bzj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jeezas aks ahn seh, “Da wai yoo di kaal mee gud? Nobadi noh gud; oanli Gaad wan gud. ");
INSERT INTO bzj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","“Yoo noa weh di komanment dehn seh: ‘Yu noh fi cheet pahn yu hozban er yu waif, yu noh fi komit merda, yu noh fi teef, yu noh fi tel lai pahn nobadi, ahn yu mos aana yu ma ahn yu pa.’” ");
INSERT INTO bzj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Di leeda seh, “Ai di du aala dehn ting deh fahn Ai da lee bwai.” ");
INSERT INTO bzj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Wen Jeezas yehr ih seh dat, ih seh tu ahn, “Oanli wan ting lef fi yu du now den. Sel evriting weh yu ga ahn gi di poa di moni, den yu wahn ga chreja eena hevn. Wen yu don du dat, den yu kohn ahn fala mi.” ");
INSERT INTO bzj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bot wen di leeda yehr dis, ih geh sad sad kaa hihn mi doti rich. ");
INSERT INTO bzj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Wen Jeezas si dat di man geh sad, ih seh, “Ai! Ih oanli haad fi rich peepl get eena Gaad kingdom. ");
INSERT INTO bzj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Akchwali, ih eeziya fi wahn kyamil paas chroo di aiy a wahn needl dan fi wahn rich man get eena Gaad kingdom.” ");
INSERT INTO bzj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dehn wan weh yehr dis aks Jeezas seh, “Wel, da hoo ku geh sayv den?” ");
INSERT INTO bzj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Bot Jeezas seh, “Weh impasabl wid man pasabl wid Gaad.” ");
INSERT INTO bzj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Den Peeta tel ahn seh, “Si, wee lef evriting weh wi mi ga soh dat wee ku fala yoo.” ");
INSERT INTO bzj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jeezas tel dehn seh, “Ah di tel unu di chroot, enibadi weh lef hows er waif er breda er ma ahn pa er pikni sayka weh dehn waahn bee paat a Gaad kingdom, wahn geh bak lat moa ting eena dis laif. Eena di werl weh di kohn, dehn wahn liv wid Gaad fareva.” ");
INSERT INTO bzj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jeezas kehr di twelv disaipl dehn wan said ahn tel dehn seh, “Lisn, wi gwehn op da Jeroosalem, ahn evriting weh di oal taim prafit dehn mi rait bowt di Son a Man wahn kohn chroo. ");
INSERT INTO bzj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Dehn wahn han ahn oava tu peepl weh da noh Joo weh wahn tek ahn mek papishoh. Dehn wahn insolt ahn op ahn spit pan ahn. Dehn wahn flag ahn, ahn den dehn wahn kil ahn, bot chree dayz layta ih wahn rayz op bak fahn di ded.” ");
INSERT INTO bzj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Di disaipl dehn neva andastan wan ting bowt weh Jeezas mi-di seh. Di meenin mi haid fahn dehn, ahn dehn neva noa weh ih mi-di taak bowt. ");
INSERT INTO bzj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Az Jeezas mi-di geh kloas tu Jeriko, wahn blain man mi-di sidong da di roadsaid di bayg. ");
INSERT INTO bzj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wen ih yehr di naiz a di krowd di paas, ih aks weh mi-di goh aan. ");
INSERT INTO bzj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Dehn tel ahn seh, “Jeezas fahn Nazaret di paas.” ");
INSERT INTO bzj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Di blain man hala owt, “Jeezas, yoo weh da Dayvid Son, ga piti pahn mi!” ");
INSERT INTO bzj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Di peepl dehn weh mi deh fronta ahn tel di blain man fi shet op ih mowt, bot hihn hala haada seh, “Dayvid Son, ga piti pahn mi noh!” ");
INSERT INTO bzj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jeezas stap ahn aada dehn fi bring di blain man tu ahn. Wen ih kohn kloas tu ahn, Jeezas aks di man, ");
INSERT INTO bzj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Da weh Ah ku du fi yu?” Di man ansa ahn seh, “Laad, Ah waahn si.” ");
INSERT INTO bzj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jeezas tel ahn seh, “Geh yu sait bak den. Sayka yu fayt, yu geh heel.” ");
INSERT INTO bzj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sayhn taim di blain man geh bak ih sait, ahn ih staat tu fala Jeezas, ahn ih mi-di prayz Gaad. Wen evribadi si weh hapm, dehn staat tu prayz Gaad tu. ");
INSERT INTO bzj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Ahn soh wen Jeezas reech Jeriko ahn mi-di paas chroo, wahn man weh nayhn Zakeeyos mi dehdeh. Hihn da-mi wan a di big taim taks kalekta dehn, ahn ih mi ga wahn lata moni. ");
INSERT INTO bzj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Hihn mi waahn si hoo da-mi dis Jeezas, bot ih mi soh shaat ih kudn si ahn chroo di lata peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Soh ih ron hed ahn ih klaim op pahn wahn sikamoa fig chree fi si ahn kaa Jeezas mi wahn paas rait deh. ");
INSERT INTO bzj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wen Jeezas reech wehpaa Zakeeyos mi deh, ih luk op eena di chree ahn seh tu ahn, “Zakeeyos, hori op ahn kohn dong, kaa Ah wahn hafu stay da yu hows tudeh.” ");
INSERT INTO bzj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Soh ih hori op ahn kohn dong kaa ih mi oanli tu glad fi mek Jeezas stay da ih hows. ");
INSERT INTO bzj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wen di peepl dehn si dis, dehn staat tu grombl ahn seh, “Ih gaahn gaahn stay da wahn sina hows!” ");
INSERT INTO bzj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bot Zakeeyos stan op ahn seh tu Jeezas, “Yu noa wat, Laad? Ah wahn gi haaf a aal weh Ah ga tu di poa, ahn if Ah oava chaaj peepl pahn taks, Ah wahn gi dehn bak foa taim weh Ah chaaj dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jeezas ansa ahn seh, “Tudeh tudeh Gaad wahn fagiv dis man ahn ih famili kaa ih bileev Gaad jos laik how ih grayt-grayt-grayt-granfaada Aybraham mi bileev ahn. ");
INSERT INTO bzj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yu si, di Son a Man kohn fi luk fi dehn wan weh laas soh dat ih ku sayv dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wail di peepl dehn mi-di lisn tu dis, Jeezas gaan aan fi tel dehn wahn parabl. Ih mi deh kloas Jeroosalem, ahn di peepl dehn don mi-di tink dat Gaad mi wahn kohn set op ih kingdom wen dehn reech deh. ");
INSERT INTO bzj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Soh ih seh, “Wahn man weh mi hai op eena sosaiyati gaahn da farin soh dat dehn ku mek ahn king, ahn den ih mi wahn kohn bak. ");
INSERT INTO bzj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Soh bifoa ih gaan, ih kaal ten a ih servant dehn ahn gi eech a dehn di sayhn amonk a moni. Ih tel dehn seh, ‘Ah waahn unu inves dis moni fi mi til Ah kohn bak.’ ");
INSERT INTO bzj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bot ih oan peepl dehn mi hayt ahn, soh dehn sen sohn peepl da di konchri weh ih mi gwehn fi tel dehn seh, ‘Wee noh waahn dis man bee fi wee king ataal!’ ");
INSERT INTO bzj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Bot ih ton king eniway ahn ih kohn bak hoahn. Den ih sen fi di servant dehn weh ih mi gi di moni tu, fi fain owt weh kaina prafit dehn mek. ");
INSERT INTO bzj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Di fos wan seh, ‘Si, sa? Ai dobl di moni weh yoo gi mee!’ ");
INSERT INTO bzj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Di king seh, ‘Yu du gud! Yu da wahn gud servant! Yu shoa mi seh yu ku handl lee bit a moni, soh Ah wahn put yu in chaaj a ten siti.’ ");
INSERT INTO bzj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Di sekant wan kohn ahn seh, ‘Maasta, yu si di moni weh yu mi gi mi? Wel, Ah mek haaf a di amonk moa pahn tap a it!’ ");
INSERT INTO bzj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Di king tel ahn seh, ‘Aarait, yoo tek chaaj a faiv siti den.’ ");
INSERT INTO bzj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Den wahn nada servant kohn ahn seh, ‘Sa, si yu moni ya. Ah rap it op eena wahn hanki ahn haid it. ");
INSERT INTO bzj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ah mi frayd fi yu kaa yoo da wahn haad man. Yu tek owt weh yu neva put een, ahn yu reep wehpaa yu neva plaant.’ ");
INSERT INTO bzj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Di king tel ahn seh, ‘Ah wahn joj yu bai weh yu seh, yu wikid servant yu! Yu mi noa dat Ai da wahn haad man weh tek owt weh Ah noh put een, an Ah reep weh Ah noh plaant. ");
INSERT INTO bzj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wai yu neva put mi moni da bank den? Ah kuda mi at lees kalek inchres pan it wen Ah kohn bak.’ ");
INSERT INTO bzj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Den ih tel dehn wan weh mi deh rong, ‘Tek weh di moni weh Ah mi gi hihn, ahn gi di wan weh dobl ih moni!’ ");
INSERT INTO bzj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Dehn tel ahn seh, ‘Bot sa, hihn don ga wahn lat aredi.’ ");
INSERT INTO bzj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Den di king seh, ‘Ah di tel yu dat evribadi weh don ga, wahn geh moa, bot fi dehn wan weh noh ga notn, eevn weh dehn ga wahn geh tek weh fahn dehn. ");
INSERT INTO bzj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Bot aal laik dehn wan weh noh laik mi, ahn neva waahn mek Ah bee king oava dehn, bring dehn ahn kil dehn rait ya fronta mi.’” ");
INSERT INTO bzj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Wen Jeezas don seh aala dehn ting, ih gaahn hed fi goh op da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wen ih mi nayli reech Betfayj ahn Betani weh da-mi too vilij weh mi deh bai di hil weh nayhn di Mongt a Alivz, ih sen too a ih disaipl dehn hed ahn ih tel dehn seh, ");
INSERT INTO bzj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Unu goh da di vilij weh deh lee wayz hed. Az unu get deh, unu wahn fain wahn yong dongki tai op weh nobadi neva raid pahn yet. Loos ahn, ahn bring ahn ya. ");
INSERT INTO bzj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","If enibadi aks unu wai unu di loos ahn, tel dehn di Laad need ahn.” ");
INSERT INTO bzj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Soh dehn gaan ahn fain di dongki jos laik how Jeezas mi tel dehn. ");
INSERT INTO bzj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wen dehn mi-di loos ahn, di oana dehn seh, “Ey! Da weh unu di loos da dongki fa?” ");
INSERT INTO bzj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dehn seh, “Di Laad need ahn.” ");
INSERT INTO bzj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Soh dehn bring ahn tu Jeezas, ahn chroa dehn jakit ahn ting pahn di dongki bak ahn mek Jeezas sidong pan it. ");
INSERT INTO bzj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Az ih mi-di goh lang, di peepl dehn jos staat tu chroa dong dehn jakit ahn ting pahn di road fi mek Jeezas raid pan. ");
INSERT INTO bzj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Az soon az ih mi-di geh kloas tu di road weh goh dong fahn di Mongt a Alivz tu Jeroosalem, di hoal krowd a peepl weh mi-di fala ahn staat tu mek lata naiz di prayz Gaad, sayka aala di mirakl dehn weh dehn mi si Jeezas du. Dehn hala: ");
INSERT INTO bzj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Gaad bles di king weh kom eena di naym a di Laad.” “Hihn mek pees kohn dong fahn hevn. Mek wi aana Gaad weh deh hai op eena hevn!” ");
INSERT INTO bzj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bot som a di Farisee dehn weh mi deh eena di krowd seh, “Teecha, mek dehn peepl weh di fala yu stap seh dehn ting, hyaa!” ");
INSERT INTO bzj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Bot Jeezas tel dehn seh, “If dehn shet op, den di stoan dehn wahn staat tu hala!” ");
INSERT INTO bzj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Now az dehn mi-di geh kloas Jeroosalem, Jeezas si di siti ahn ih staat tu baal oava it. ");
INSERT INTO bzj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ih seh, “Aiy Jeroosalem, da wahn piti unu noh noa weh wuda gi unu pees tudeh day, bot now pees di haid fahn unu. ");
INSERT INTO bzj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Di day wahn kohn wen yu enimi dehn wahn bil wahn waal rong yu ahn fens yu een; dehn wahn kloaz een pahn yu pahn aal said. ");
INSERT INTO bzj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Dehn wahn mash yu dong tu di grong ahn kil yu pikni dehn weh deh baka di waal. Dehn noh eevn wahn mek wan stoan lef pahn tap a di ada wan, kaa wen Gaad mi kohn fi sayv unu, unu neva pay ahn no main.” ");
INSERT INTO bzj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Den Jeezas gaahn da di templ yaad ahn wail owt aala dehn wan weh mi-di bai ahn sel eena di yaad. ");
INSERT INTO bzj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ih tel dehn seh, “Di Skripcha seh, ‘Mai hows sopoas tu bee wahn plays fi pray,’ bot unu ton ahn intu ‘wahn hengowt fi teef.’” ");
INSERT INTO bzj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Afta dat ih staat tu teech evri day eena di templ, bot di cheef prees dehn, ahn dehn wan weh teech di Jooish Laa, lang wid di peepl dehn leeda dehn mi-di luk fi wahn way how fi kil ahn. ");
INSERT INTO bzj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Bot dehn kudn fain no way fi du it kaa di peepl dehn mi-di lisn wid aal dehn ayz tu evriting weh ih mi ga fi seh. ");
INSERT INTO bzj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Wahn day wail Jeezas mi deh da di templ yaad di teech di peepl dehn ahn di preech di Gud Nyooz, di cheef prees dehn, ahn dehn wan weh teech di Jooish Laa, ahn di Jooish leeda dehn kom op tu ahn, ahn aks ahn seh, “Tel wi, da weh atariti yoo ga fi du dehnya ting ya? Da hoo gi yoo dis atariti?” ");
INSERT INTO bzj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jeezas ansa dehn seh, “Mek Ai aks unu wahn kweschan tu. Tel mi, ");
INSERT INTO bzj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","da weh Jan di Baptis geh di atariti fi baptaiz peepl—fahn Gaad er fahn man? Ansa mi dat!” ");
INSERT INTO bzj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dehn taak it oava monks dehnself ahn seh, “If wi seh da fahn Gaad, den ih wahn aks wi, ‘Den wai unu neva bileev ahn den?’ ");
INSERT INTO bzj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bot if wi seh da fahn man, di peepl dehn wahn stoan wi tu det kaa dehn bileev seh dat Jan da-mi wahn prafit.” ");
INSERT INTO bzj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Soh dehn ansa Jeezas seh, “Wee noh noa hoo gi Jan di atariti fi baptaiz peepl.” ");
INSERT INTO bzj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jeezas tel dehn seh, “Wel, Ai noh wahn tel unu da hoo gi mee di atariti fi du dehnya ting needa.” ");
INSERT INTO bzj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Den Jeezas gaahn hed ahn tel di peepl dehn dis parabl: “Wahn man plaant owt wahn pees a lan wid grayp ahn rent it owt tu sohn faama, ahn ih gaahn weh fi wahn lang taim. ");
INSERT INTO bzj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wen di taim kohn fi pik di grayp dehn, di oana a di lan sen ih servant dehn fi kalek fi hihn shayr a di krap fahn di faama dehn. Bot di faama dehn beet ahn op bad ahn sen ahn bak wid ih too lang han di heng dong da ih said. ");
INSERT INTO bzj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Di oana sen wahn nada servant, bot dehn beet hihn tu, ahn shaym ahn bad, ahn sen ahn weh widowt notn. ");
INSERT INTO bzj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ih sen wahn terd servant, ahn di faama dehn beet hihn bad ahn pich ahn owta di plays. ");
INSERT INTO bzj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Den di oana a di lan seh, ‘Da weh Ah wahn du now? Ah wahn sen mi son weh Ah lov. Maybi dehn wahn rispek hihn!’ ");
INSERT INTO bzj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Bot cho! Wen di faama dehn si di man son, dehn seh monks dehnself, ‘Dis da di wan weh wahn inherit evriting. Mek wi kil hihn, den evriting wahn bee fi wee!’ ");
INSERT INTO bzj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Soh dehn pich di oana son aafa di lan ahn kil ahn. “Soh da weh unu tink di oana wahn du wid dehn faama? ");
INSERT INTO bzj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ih wahn kohn kohn kil aala dehn ahn rent owt di lan tu sohn ada faama.” Wen di peepl dehn yehr dis, dehn seh, “Hmm! Wee hoap dat neva hapm!” ");
INSERT INTO bzj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jeezas luk schrayt pahn dehn ahn seh, “Wel den, tel mi weh di Skripcha mi meen wen ih seh, ‘Di stoan weh di bilda dehn neva tink mi wot notn ton owt fi bee di kaanastoan, weh da di moas impoatant wan owta aala dehn.’ ");
INSERT INTO bzj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yu si, evribadi weh bok dehn fut pahn datdeh stoan wahn geh brok op eena peesiz; ahn enibadi weh da stoan jrap pan wahn geh mash op fain laik powda.” ");
INSERT INTO bzj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Da sayhn taim, dehn wan weh teech di Laa ahn di cheef prees dehn mi-di chrai fain wahn way fi ares Jeezas, kaa dehn mi wel noa seh dat wen Jeezas mi-di tel dehn da lee stoari bowt di wikid faama dehn, ih mi-di taak bowt dehn. Bot dehn mi frayd fi weh di peepl dehn mi wahn du if dehn mi ares ahn. ");
INSERT INTO bzj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Soh dehn mi-di kip wahn kloas aiy pahn Jeezas. Dehn sen sohn spai weh mi-di priten fi bee hoali ahn raichos fi chrai kech ahn eena sohnting weh ih seh, soh dat dehn kuda ton ahn oava tu di Roaman govna, weh mi ga di powa fi ares ahn. ");
INSERT INTO bzj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Soh di spai dehn kweschan Jeezas seh, “Teecha, wee noa seh dat yoo oanli taak ahn preech weh rait, ahn yu chreet evribadi sayhn way noh kay da hoo dehn, ahn yoo teech di chroot bowt how Gaad waahn peepl fi liv. ");
INSERT INTO bzj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Soh tel wi weh yoo tink. Ih rait fi wee pay taks tu Seeza er nat?” ");
INSERT INTO bzj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jeezas mi don si chroo dehn toofaystidnis lang taim, soh ih tel dehn seh, ");
INSERT INTO bzj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Shoa mi wahn silva moni. Da hoofa hed ahn hoofa naym deh pan it?” ");
INSERT INTO bzj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dehn ansa seh, “Seeza.” Jeezas tel dehn seh, “Den gi Seeza weh bilangz tu Seeza, ahn gi Gaad weh bilangz tu Gaad.” ");
INSERT INTO bzj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Dehn kudn chrik ahn eena notn weh ih mi seh fronta di peepl dehn. Dehn mi soh shak bowt how Jeezas ansa dehn, dat dehn mi hafu shet op dehn mowt. ");
INSERT INTO bzj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Afta dat sohn Sadyusee gaahn da Jeezas. Dehndeh da wahn groop a peepl weh noh bileev dat nobadi wahn rayz op bak afta dehn don ded. ");
INSERT INTO bzj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Wel, dehn gaahn da Jeezas ahn aks ahn dis kweschan: “Teecha, Moaziz mi rait wahn laa fi wi weh seh dat if wahn man breda ded lef ih waif, bot ih neva ga no pikni wid ahn, da man fi marid tu ih ded breda wido ahn ga pikni wid ahn soh dat ih ku kehr aan ih breda naym. ");
INSERT INTO bzj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Now yu mi ga sebm breda; di fos wan marid tu wahn laydi ahn ded widowt ga no pikni wid ahn; ");
INSERT INTO bzj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","den di sekant wan marid ih breda wido; den hihn ded, ahn di terd wan ton rong ahn marid di sayhn laydi. Ahn rait soh ih gaan aan til aal sebm breda ded, ahn non a dehn neva did ga no pikni. ");
INSERT INTO bzj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wel, pahn di en di laydi shee ded tu. ");
INSERT INTO bzj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Soh, wen di day kohn fi ded peepl kohn bak tu laif, hoofa waif shee wahn bee, laik how di hoal sebm a dehn mi marid tu ahn?” ");
INSERT INTO bzj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Soh Jeezas tel dehn seh, “Peepl weh liv pahn dis ert now geh marid. ");
INSERT INTO bzj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bot dehn wan weh Gaad gi di rait fi rayz op bak fahn di ded ahn goh da hevn noh wahn hafu wori bowt marid kaa dehn taim deh nobadi wahn di geh marid tu nobadi. ");
INSERT INTO bzj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Dehn wahn kyaahn ded agen needa, kaa dehn wahn bee jos laik di aynjel dehn. Dehn da Gaad pikni dehn laik how dehn rayz op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ahn Moaziz ihself proov dat peepl wahn rayz op bak fahn di ded kaa wen ih rait bowt di bush weh mi-di bon, ih taak bowt di Gaad weh Aybraham ahn Aizak ahn Jaykop wership. ");
INSERT INTO bzj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hihn da noh di Gaad a ded peepl, bot ih da di Gaad a peepl weh livin. Yu si, az faar az Gaad kansaan, evribadi livin.” ");
INSERT INTO bzj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Den som a dehn wan weh teech di Jooish Laa seh, “Teecha, weh yu seh song gud.” ");
INSERT INTO bzj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ahn nat anada soal mi dayr aks Jeezas wahn nada kweschan. ");
INSERT INTO bzj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Den Jeezas aks dehn seh, “How kom dehn seh dat di Krais wahn kohn fahn King Dayvid famili lain? ");
INSERT INTO bzj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kaa Dayvid ihself seh rait eena Saamz, ‘Di Laad tel mai Laad seh, “Sidong rait ya pahn mi rait han said ");
INSERT INTO bzj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","til Ah put yu enimi dehn anda yu fut laik wahn futstool.” ’ ");
INSERT INTO bzj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Soh if Dayvid mi kaal di Krais, ‘Laad,’ den da how di Mesaiya ku kohn dong chroo Dayvid famili lain?” ");
INSERT INTO bzj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Dis da weh Jeezas tel ih disaipl dehn soh dat evribadi ku yehr: ");
INSERT INTO bzj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kyaaful a dehn wan weh teech di Laa. Dehn laik waak rong eena lang roab, ahn dehn laik wen evribadi di hayl dehn op owta schreet. Dehn aalwayz waahn di kak op rait da front seet da di sinagag dehn er da bankwit ahn soh. ");
INSERT INTO bzj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dehn swindl dehn poa lee wido owta dehn hows ahn lat, den dehn wahn ton rong ahn seh sohn lang pryaaz jos fi shoa aaf. Dehndeh teecha dehn wahn geh ponish moa dahn enibadi els.” ");
INSERT INTO bzj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Wen Jeezas luk op, ih si di rich peepl dehn di put dehn gif eena di kalekshan baks da di templ. ");
INSERT INTO bzj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ih noatis dat wahn poa lee wido jrap een too wan sehn. ");
INSERT INTO bzj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jeezas seh, “Ah di tel unu di chroot, dis poa wido put een moa dahn aala di ada peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yu si, aala dehn peepl gi fi dehn gif owta di lat weh dehn ga. Bot eevn eena aala ih poanis, shee gi aal weh ih mi ga fi liv pan.” ");
INSERT INTO bzj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Som a ih disaipl dehn mi-di taak bowt di templ, how ih mi dekorayt op wid aal kaina priti stoan ahn wid di gif dehn weh peepl mi bring fi gi Gaad. Bot Jeezas seh, ");
INSERT INTO bzj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Unu si aala dehn ting ya? Wel, di taim wahn kohn wen aala dehn wahn geh nak dong flat ahn nat wan stoan wahn lef pahn tap a di neks.” ");
INSERT INTO bzj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dehn aks ahn seh, “Teecha, da wen aala dehnya ting wahn hapm? Ahn da weh kaina sain wi wahn geh fi mek wi noa wen da taim fi dehn hapm?” ");
INSERT INTO bzj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ahn Jeezas ansa dehn seh, “Unu wach owt ahn noh mek nobadi fool unu. Lata peepl wahn kohn di yooz mai naym di seh, ‘Ai da hihn,’ ahn ‘Di taim deh kloas!’ Noh fala dehn. ");
INSERT INTO bzj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wen unu yehr bowt lata waar ahn raiyat, noh geh fraitn, kaa aala dehnya ting wahn hafu hapm fos, bifoa di en kohn.” ");
INSERT INTO bzj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Den ih tel dehn seh, “Lata difrent nayshan ahn kingdom wahn waar gens wan anada. ");
INSERT INTO bzj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Lata big ertwayk wahn deh, ahn eena aal difrent plays peepl wahn di staav, ahn lata dizeez wahn deh. Aal kaina fraitnin ting wahn hapm eena di skai. ");
INSERT INTO bzj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Bot bifoa aala dis hapm, dehn wahn ares unu ahn haraas unu op; dehn wahn han unu oava tu di leeda dehn a di poblik meetn plays dehn fi mek dehn chrai unu, ahn den dehn wahn chroa unu eena jayl. Dehn wahn kehr unu fronta king ahn govna sayka weh unu bileev eena mee. ");
INSERT INTO bzj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Dat wahn gi unu wahn chaans fi tel dehn di chroot bowt mee. ");
INSERT INTO bzj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Noh wori heda taim bowt weh unu wahn seh fi difen unuself, ");
INSERT INTO bzj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kaa Ai wahn gi unu di werd dehn weh unu fi seh, an Ah wahn mek unu soh waiz dat non a dehn wan weh kohn gens unu wahn ku stan op tu unu er kanchradik unu. ");
INSERT INTO bzj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Eevn som a unu ma ahn pa, ahn unu breda, ahn unu relitiv dehn, ahn unu fren dehn wahn sel unu owt. Dehn wahn eevn put som a unu tu det anaal. ");
INSERT INTO bzj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Evribadi wahn hayt unu sayka weh unu bileev eena mee. ");
INSERT INTO bzj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bot unu noh wahn laas nat wan grayn a hyaa. ");
INSERT INTO bzj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Sayka weh unu stay faytful tu mee tu di en, unu wahn geh reel laif weh wahn laas fareva. ");
INSERT INTO bzj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Wen unu si wahn lata soalja di kyamp owt rong ahn rong Jeroosalem, den unu wahn noa dat di taim kohn fi ih geh dischrai. ");
INSERT INTO bzj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mek evribadi weh deh da Judeeya dischrik hori ron goh da di mongtin dehn, ahn mek dehn wan weh deh da di siti kom owt ahn lef it. Rait soh, dehn wan weh deh da konchri mosn goh da di siti needa. ");
INSERT INTO bzj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kaa dehndeh taim wahn bee di dayz wen Gaad wahn tek venjans pahn ih peepl dehn jos laik weh di prafit dehn mi rait eena di Skripcha. ");
INSERT INTO bzj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Eena dehn dayz deh ih wahn bee harabl fi dehn laydi weh pregnant ahn dehn wan weh ga yong baybi! Lata sofarin wahn deh aal oava di lan, ahn Gaad raat wahn poar owt pahn di Jooish peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Di soalja dehn wahn kil som a dehn wid soad, ahn som a dehn wahn geh kyapcha ahn geh kehr aaf da sohn ada nayshan; peepl weh da noh Joo wahn rool op Jeroosalem til wen fi dehn taim kohn fi mek dehn stap. ");
INSERT INTO bzj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Sohn schraynj ting wahn hapm tu di son ahn di moon ahn di staar dehn. Ahn dong ya pahn di ert, peepl fahn aal oava di werl wahn frayd no miks sayka how di see di hib op ahn mek lata naiz. ");
INSERT INTO bzj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Peepl wahn faynt weh sayka weh dehn soh fraitn wen dehn si aal weh di hapm pahn ert, kaa evriting owt eena spays wahn geh shayk op. ");
INSERT INTO bzj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Da taim deh peepl wahn si di Son a Man di kom eena wahn klowd wid powa, ahn ih wahn di shain eena aala ih gloari. ");
INSERT INTO bzj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Now wen dehnya ting staat tu hapm, unu stan op, lif op unu hed, kaa di taim deh kloas fi mek Gaad sayv unu.” ");
INSERT INTO bzj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Den Jeezas tel dehn dis lee parabl: “Luk pahn di fig chree ahn aal dehn res a chree dehn; ");
INSERT INTO bzj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","az soon az leef staat tu sprowt, unu ku si fi unuself ahn noa seh dat da nayli taim fi soma. ");
INSERT INTO bzj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sayhn way, wen unu si dehnya ting di hapm, unu wahn noa seh dat di taim soon kohn fi Gaad set op ih kingdom. ");
INSERT INTO bzj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ah di tel unu di chroot, di peepl dehn fahn dis jenarayshan noh wahn ded owt til aala dehnya ting don hapm. ");
INSERT INTO bzj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Hevn ahn ert wahn don weh wid, bot weh Ai di seh wahn stay fareva. ");
INSERT INTO bzj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Unu main dat unu haat noh geh bag dong wid jronkinis ahn karowzin, ahn di woriz a dis laif, ahn den wen unu luk, da Day kech unu aaf gyaad laik wahn chrap. Kaa da Day wahn kohn pahn evribadi weh liv pahn di hoal ert. ");
INSERT INTO bzj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Unu mos deh pahn unu gyaad aal di taim. Pray dat unu wahn ga di schrent fi goh chroo aala dehn ting weh wahn hapm, ahn dat unu noh wahn frayd fi stan op fronta di Son a Man.” ");
INSERT INTO bzj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Evri day Jeezas mi-di teech eena di templ, ahn den ih wuda goh goh spen di nait pahn di hil weh nayhn di Mongt a Alivz. ");
INSERT INTO bzj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ahn peepl wuda get op soon da maanin fi goh lisn tu ahn da di templ. ");
INSERT INTO bzj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Now da mi nayli taim fi di Jooish peepl dehn kip op di Paasoava, weh da wahn speshal fees day wen dehn eet bred weh mek widowt ees. ");
INSERT INTO bzj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Now di cheef prees dehn ahn dehn wan weh teech di Jooish Laa mi-di chrai fain sohn kaina way fi kil Jeezas kaa dehn mi frayd fi di peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Den Saytan get eena Joodas Iskariyat, weh da-mi wan a di twelv disaipl dehn. ");
INSERT INTO bzj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Soh Joodas gaahn da di cheef prees dehn ahn di hed aafisa fi dehn soalja weh gyaad di templ fi taak bowt how ih ku sel owt Jeezas tu dehn. ");
INSERT INTO bzj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Dehn mi kwait hapi bowt dat, soh dehn mek baagin fi gi ahn moni. ");
INSERT INTO bzj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Joodas agree, ahn ih staat tu luk fi di karek taim wen ih kuda mi sel owt Jeezas tu dehn wen no krowd neva deh rong. ");
INSERT INTO bzj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Den di day kohn wen di Jooish peepl dehn eet bred weh mek widowt ees ahn sakrifais wahn lee lam fi selibrayt di Paasoava, weh dehn eet lang wid bred weh mek widowt ees. ");
INSERT INTO bzj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Soh Jeezas sen Peeta ahn Jan hed, ahn ih tel dehn seh, “Goh hed ahn set op fi mek wi eet di Paasoava dina.” ");
INSERT INTO bzj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Dehn aks ahn seh, “Da wehpaa yu waahn wi fiks it?” ");
INSERT INTO bzj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jeezas tel dehn seh, “Az soon az unu get eena Jeroosalem, wahn man weh di bak wahn jog a waata wahn meet unu. Fala ahn da di hows weh ih goh eena, ");
INSERT INTO bzj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ahn tel di oana seh, ‘Di teecha sen wi fi aks yu wehpaa di ges room deh weh ih fi eet di Paasoava dina wid ih disaipl dehn.’ ");
INSERT INTO bzj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Den ih wahn kehr unu da wahn big opstayz room weh gat een evriting weh unu wahn need. Da rait deh unu fi geh di dina redi.” ");
INSERT INTO bzj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Peeta ahn Jan lef ahn dehn fain evriting jos laik how Jeezas mi tel dehn. Soh dehn geh di Paasoava dina redi. ");
INSERT INTO bzj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wen di taim kohn, Jeezas ahn ih apasl dehn mi deh rong di taybl. ");
INSERT INTO bzj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ih tel dehn seh, “Ah mi oanli waahn eet dis Paasoava dina wid unu bad, bifoa di taim kohn fi mek Ah sofa. ");
INSERT INTO bzj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kaa Ah di tel unu dis, Ah noh wahn eet it agen til di hoal meenin a di Paasoava dina kohn chroo joorin di taim wen Gaad di rool di werl.” ");
INSERT INTO bzj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Den Jeezas pik op wahn kop a wain, ahn ih gi Gaad tanks far it, ahn den ih seh, “Tek dis ahn shayr it monks unuself. ");
INSERT INTO bzj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ah di tel unu, Ah noh wahn jrink nohmoh wain til wen Gaad kingdom kohn.” ");
INSERT INTO bzj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ih pik op di bred ahn tank Gaad far it, ahn den ih brok it ahn gi dehn. Den ih seh, “Dis da mai badi weh Ah di gi fi unu; eet dis bred soh dat unu ku memba mi.” ");
INSERT INTO bzj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Sayhn way, Jeezas tek di kop afta dehn don eet ahn seh, “Dis kop a wain da mai blod, weh da di nyoo agreement weh Gaad mek wid ih peepl dehn. Dis blod wahn poar owt fi unu. ");
INSERT INTO bzj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Bot di sayhn wan weh wahn sel mi owt deh rait ya di sidong rong dis sayhn taybl. ");
INSERT INTO bzj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Di Son a Man wahn ded jos laik weh Gaad mi seh. Bot loan bad wahn fala di wan weh sel mi owt.” ");
INSERT INTO bzj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Den di disaipl dehn staat tu aks wan anada, “Da hoo kuda bee di wan weh wuda du sohnting laik dat?” ");
INSERT INTO bzj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Den dehn staat tu aagyu monks dehnself az tu wich wan a dehn da-mi di moas impoatant wan monks dehn. ");
INSERT INTO bzj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jeezas tel dehn seh, “Dehn king weh da noh Joo laik rool fi dehn peepl stif-wan, ahn dehn wan weh baas dehn op wid wahn hevi han stil ton rong ahn kaal dehnself di peepl dehn ‘fren.’ ");
INSERT INTO bzj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bot unu noh fi stan laik dat. Insted, mek di wan weh da di moas impoatant monks unu bee laik di wan weh deh way dong da batam, ahn mek di wan weh da di leeda bee laik di wan weh da servant. ");
INSERT INTO bzj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hoo moa impoatant, di wan weh sidong rong di taybl, er di wan weh di serv? Unu noh tink dat da di wan weh di sidong rong di taybl? Bot Ai deh monks unu az di Wan weh di serv. ");
INSERT INTO bzj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","29","“Unu da di wan dehn weh stan bai mi said eena aal mi chroblz ahn chraiyalz, soh jos laik how mai Faada gi mee di rait fi rool, Ai di gi unu da sayhn rait deh tu. ");
INSERT INTO bzj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Unu wahn eet ahn jrink rong di taybl wid mi wen Ai di rool, ahn unu wahn sidong pahn chroan ahn joj di twelv chraib a Izrel. ");
INSERT INTO bzj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Aiy, Saiman, Saiman, Saytan aks Gaad fi mek ih siv unu jos laik how dehn siv weet fi separayt di gud fahn di bad. ");
INSERT INTO bzj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bot Ai don pray fi yoo, Saiman, soh dat yu fayt noh wahn fayl yu. Ahn wen yu kohn bak tu mi agen, yu mos schrentn yu felo disaipl dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bot Saiman Peeta ansa ahn seh, “Laad, Ai redi fi goh da jayl wid yoo, eevn fi ded wid yu.” ");
INSERT INTO bzj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Bot Jeezas ansa ahn seh, “Ah tel yu, Peeta, bifoa di roosta kroa tudeh, yoo wahn disoan mee chree taim.” ");
INSERT INTO bzj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Den Jeezas aks di disaipl dehn, “Wen Ah sen unu owt fi preech widowt moni er kitbag er ekschra shooz, unu mi eva need eniting?” Dehn ansa ahn seh, “No, wi neva need notn.” ");
INSERT INTO bzj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jeezas tel dehn seh, “Bot now, if unu ga moni, kehr it, ahn kehr wahn kitbag tu. Ahn if unu noh ga wahn soad, sel unu jakit ahn bai wan. ");
INSERT INTO bzj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ih rait dong eena di Skripcha seh, ‘Dehn mi konk ahn az wahn kriminal.’ Yes, Ah di tel unu dis, weh rait dong bowt mee wahn kohn chroo soon.” ");
INSERT INTO bzj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Di disaipl dehn seh, “Si Laad, wi ga too soad ya.” Jeezas ansa dehn seh, “Dat nof.” ");
INSERT INTO bzj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Den Jeezas gaan op pahn di hil weh nayhn di Mongt a Alivz laik weh ih doz aalwayz du, ahn ih disaipl dehn gaahn lang wid ahn. ");
INSERT INTO bzj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wen dehn reech wehpaa dehn mi gwehn, ih tel dehn seh, “Unu pray soh dat unu noh giv een tu temtayshan.” ");
INSERT INTO bzj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Afta dat ih gaahn wahn lee wayz fahn dehn, bowt az faar az weh yu kuda chroa wahn stoan. Ih neel dong fi pray, ahn ih seh, ");
INSERT INTO bzj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Faada, if yu waahn, pleez noh mek Ah jrink owta dis kop a sofarin. Bot Ai wahn du wateva yoo waahn, noh weh Ai waahn.” ");
INSERT INTO bzj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Den wahn aynjel fahn hevn apyaa tu ahn fi gi ahn schrent. ");
INSERT INTO bzj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ih haat mi sad sad, soh ih pray haada fahn di batam a ih haat til ih swet mi-di jrip pahn di grong, laik sohn big jrap a blod. ");
INSERT INTO bzj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wen Jeezas get op fahn wichpaa ih mi-di pray, ih gaahn bak da ih disaipl dehn ahn ih fain dehn di sleep—di sadnis weh dehn mi-di feel mi taiyad dehn owt. ");
INSERT INTO bzj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ih aks dehn seh, “Wai unu di sleep? Get op ahn pray soh dat unu noh giv een tu temtayshan.” ");
INSERT INTO bzj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Wail Jeezas stil mi-di taak, wahn krowd a peepl kom op tu ahn, ahn di man weh mi nayhn Joodas, weh da-mi wan a di twelv disaipl dehn, mi deh rait da front. Ih waak rait op tu Jeezas ahn kis ahn. ");
INSERT INTO bzj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jeezas aks ahn seh, “Joodas, da wahn kis yu wahn sel owt di Son a Man wid?” ");
INSERT INTO bzj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wen Jeezas disaipl dehn si weh mi wahn hapm, dehn aks ahn seh, “Laad, yu waahn wi fait dehn aaf wid wi soad fi yu?” ");
INSERT INTO bzj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ahn wan a di disaipl dehn chap aaf di hai prees servant rait ayz! ");
INSERT INTO bzj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","“Inof a dat!” Jeezas seh. Den ih toch di man ayz ahn heel ahn. ");
INSERT INTO bzj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Den Jeezas tel di cheef prees ahn di templ gyaad dehn, ahn di Jooish leeda dehn weh mi kohn fi ares ahn, “Da weh hapm now? Unu kom owt ya wid soad ahn klob fi ares mi laik Ai da sohn kaina kriminal. ");
INSERT INTO bzj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ah mi deh wid unu da di templ evri day ahn unu neva eevn put wan han pahn mi. Bot dis da fi unu taim now, wen aala di powaz a daaknis wahn tek oava.” ");
INSERT INTO bzj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dehn grab Jeezas ahn kehr ahn da di hai prees hows. Peeta mi-di fala dehn fahn faar. ");
INSERT INTO bzj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sohn peepl lait wahn faiya midl a di yaad ahn dehn mi-di sidong rong it, ahn Peeta gaahn sidong lang wid dehn tu. ");
INSERT INTO bzj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Wan a di mayd dehn si ahn di sidong rong di faiya, ahn ih tek wahn gud luk pan ahn, ahn seh, “Dis man mi deh wid Jeezas tu!” ");
INSERT INTO bzj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bot Peeta wudn oan op tu it. Ih seh, “Gyal, mee noh eevn noa hihn.” ");
INSERT INTO bzj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Lee layta, sohnbadi els si ahn, ahn seh, “Yoo da wan a Jeezas disaipl dehn tu.” Bot Peeta ansa seh, “No, man. Ai da noh wan a dehn.” ");
INSERT INTO bzj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bowt wan owa afta dat, wahn nada man insis, “Ai noa dis lee bali ya. Hihn mi deh wid Jeezas kaa hihn kohn fahn Gyalilee.” ");
INSERT INTO bzj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peeta ansa ahn seh, “Man, Ai noh noa weh yoo di taak bowt!” Az ih don seh dat, di roosta kroa. ");
INSERT INTO bzj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Di Laad Jeezas ton rong ahn luk schrayt pahn Peeta. Den Peeta memba weh di Laad mi tel ahn: “Bifoa di roosta kroa tudeh, yu wahn seh dat yu noh noa mi chree taim.” ");
INSERT INTO bzj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ahn ih gaan owtsaid gaahn baal ahn baal til ih kudn baal nohmoh. ");
INSERT INTO bzj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Di man dehn weh mi-di gyaad Jeezas staat tu beet ahn, ahn tek ahn mek papishoh. ");
INSERT INTO bzj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Dehn blainfoal ahn, ahn tel ahn seh, “Laik how yoo da prafit, tel wi da hoo nak yu.” ");
INSERT INTO bzj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ahn dehn tel ahn wahn lata ada shaymin ting. ");
INSERT INTO bzj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wen day mi-di brok, aala di Jooish leeda dehn lang wid di cheef prees dehn, ahn dehn wan weh teech di Jooish Laa meet op tugeda, ahn dehn bring Jeezas fronta dehn kongsl. ");
INSERT INTO bzj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Dehn seh, “If yoo da di Krais, tel wi.” Jeezas ansa, “Eevn if Ah tel unu, unu noh wahn bileev mi. ");
INSERT INTO bzj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ahn if Ah aks unu wahn kweschan, unu noh wahn ansa mi eniway. ");
INSERT INTO bzj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bot fahn ya goh bak, di Son a Man wahn di sidong da di plays a aana, weh deh pahn di rait han said a Gaad Almaiti.” ");
INSERT INTO bzj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Den aala dehn aks ahn seh, “Soh yoo da Gaad Son den?” Jeezas ansa, “Unu rait wen unu seh soh.” ");
INSERT INTO bzj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dehn seh, “Wi noh need nohmoh witnis. Wi yehr it owta ih oan mowt.” ");
INSERT INTO bzj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Den di hoal kit a dehn fahn di Kongsl kehr Jeezas fronta Pailat, weh da-mi di Roaman govna. ");
INSERT INTO bzj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ahn dehn staat tu akyooz ahn, ahn seh, “Wi kech dis man di chrai fi ster op fi wee Jooish peepl fi mek dehn ton gens Seeza. Ih di tel dehn dat dehn noh fi pay no taks tu Seeza, ahn ih seh dat hihn da di Krais, wahn king!” ");
INSERT INTO bzj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Soh Pailat aks Jeezas seh, “Yoo da di king a di Jooz?” Jeezas ansa seh, “Yu rait wen yu seh dat.” ");
INSERT INTO bzj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Den Pailat tel di cheef prees dehn ahn di hoal krowd a peepl, “Unu noh ga no kays gens dis man az faar az Ai ku si.” ");
INSERT INTO bzj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bot dehn mi stobant ahn dehn tel Pailat agen, “Bot ih ster op di peepl dehn aal oava Judeeya dischrik wid di ting dehn weh ih teech dehn. Ih staat way da Gyalilee til ih reech ya.” ");
INSERT INTO bzj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Wen Pailat yehr dis, ih aks if Jeezas kohn fahn Gyalilee. ");
INSERT INTO bzj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wen ih fain owt dat Jeezas mi kohn fahn di sayhn ayrya weh King Herod mi-di rool oava, ih sen ahn tu ahn fi mek hihn joj di kays, laik how King Herod mi deh da Jeroosalem da sayhn taim. ");
INSERT INTO bzj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Wen Herod si Jeezas, ih mi glad kaa ih mi waahn meet ahn fahn lang taim. Fahn weh ih mi yehr bowt Jeezas, ih mi-di hoap dat ih maita du wahn lee mirakl far ahn. ");
INSERT INTO bzj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herod krayzi ahn wid lata kweschan, bot Jeezas neva ansa nat wan werd. ");
INSERT INTO bzj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Di cheef prees ahn dehn wan weh teech di Jooish Laa mi deh wan said di lays Jeezas wid fi dehn oan akyoozayshan dehn. ");
INSERT INTO bzj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Den Herod ahn aala ih soalja dehn staat tu insolt Jeezas ahn tek ahn mek papishoh. Den dehn put aan wahn fansi gong pan ahn, ahn sen ahn bak da Pailat. ");
INSERT INTO bzj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bifoa da day deh, Herod ahn Pailat yoostu bee enimi, bot fahn den aan dehn ton fren. ");
INSERT INTO bzj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat kaal aala di cheef prees dehn ahn di ada leeda dehn ahn di peepl dehn tugeda. ");
INSERT INTO bzj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ih tel dehn seh, “Unu bring dis man tu mi ahn unu seh dat ih di ster op di peepl dehn mek dehn ton gens di govament. Wel, Ai chek ahn owt rait fronta unu, an Ai stil seh unu noh ga no kays gens ahn. ");
INSERT INTO bzj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ahn Herod sen ahn bak tu wee, kaa hihn neva fain notn rang wid ahn needa. Az unu ku si, dis man noh du notn fi mek Ah sentens ahn tu det. ");
INSERT INTO bzj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Soh, Ah wahn mek dehn flag ahn, den Ah wahn let ahn goh.” ");
INSERT INTO bzj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Evri yaa Pailat mi sopoas tu let goh wahn prizna tu di peepl dehn joorin di Paasoava selibrayshan. ");
INSERT INTO bzj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bot di hoal krowd a dehn hala tugeda, “Get rid a dis man! Gi wee Baraabas!” ");
INSERT INTO bzj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Now Baraabas da-mi wahn man weh mi gaahn da jayl fi staat raiyat eena Jeroosalem fi chrai fi oavachroa di govament, ahn fi merda.) ");
INSERT INTO bzj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat mi-di chrai bayg fi Jeezas, soh ih taak tu di krowd agen. ");
INSERT INTO bzj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bot dehn stay di hala, “Kroosifai ahn! Kroosifai ahn!” ");
INSERT INTO bzj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Fi di terd taim Pailat aks dehn seh, “Wai? Ih komit eni kraim? Ai noh ga no reezn fi paas wahn det sentens pahn dis man. Soh Ah wahn mek dehn flag ahn, ahn den Ah wahn let ahn goh.” ");
INSERT INTO bzj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Bot di peepl dehn hala haada pahn tap a dehn vais fi mek dehn kroosifai ahn. Sayka weh dehn mi-di hala ahn hala ahn wudn bak dong, Pailat giv een ahn paas di det sentens pahn Jeezas, ahn gi di krowd weh dehn mi waahn. ");
INSERT INTO bzj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ih let goh Baraabas, di man weh dehn mi-di aks fa, di sayhn wan weh mi eena jayl sayka raiyat ahn merda, ahn ih gi Jeezas oava tu dehn fi mek dehn du weh dehn mi waahn wid ahn. ");
INSERT INTO bzj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Az dehn mi-di leed ahn weh, dehn meet wahn man nayhn Saiman weh mi-di kohn fahn op konchri. Hihn kohn fahn wahn siti weh nayhn Saireen. Dehn kalek ahn, ahn foas ahn fi bak Jeezas kraas wail Jeezas waak fronta ahn. ");
INSERT INTO bzj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Wahn big krowd mi-di fala ahn, ahn sohn laydi weh mi-di baal ahn moan far ahn mi deh monks dehn tu. ");
INSERT INTO bzj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bot Jeezas ton rong ahn luk pahn dehn ahn tel dehn seh, “Unu laydi fahn Jeroosalem, noh krai fi mee; krai fi unuself ahn unu pikni. ");
INSERT INTO bzj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kaa di taim wahn kohn wen dehn wahn seh, ‘Ih da wahn gud ting fi dehn laydi weh kyaahn ga no pikni, ahn dehn wan weh neva yet bak baybi, ahn dehn wan weh neva yet bresfeed.’ ");
INSERT INTO bzj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Den dehn wahn seh tu di mongtin dehn, ‘Jrap pahn wi!’ Ahn dehn wahn seh tu di hil dehn, ‘Kova wi op!’ ");
INSERT INTO bzj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kaa if peepl du dehnya ting tu mee weh da laik wahn livin chree, da weh aal wahn hapm tu unu, weh da laik wahn jrai chree?” ");
INSERT INTO bzj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Den di soalja dehn mi-di leed owt too kriminal fi goh geh kroosifai lang wid Jeezas tu. ");
INSERT INTO bzj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wen dehn reech da di plays weh nayhn “Di Skol,” dehn kroosifai Jeezas lang wid di kriminal dehn. Dehn put wan pahn ih rait ahn wan pahn ih lef. ");
INSERT INTO bzj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ahn Jeezas seh, “Faada, fagiv dehnya peepl kaa dehn noh noa weh dehn di du.” Ahn di soalja dehn gyambl fi si how dehn mi wahn shayr op ih kloaz monks dehn. ");
INSERT INTO bzj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aala di peepl dehn mi-di stan op rong di luk op pan ahn, ahn di leeda dehn eevn staat tu klong ahn. Dehn seh, “Ih mi sayv ada peepl; mek ih sayv ihself now, laik how hihn da di Krais weh Gaad mi pik fi sayv wi.” ");
INSERT INTO bzj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Eevn di soalja dehn kom op ahn klong ahn tu. Dehn aafa fi gi ahn wain vineega ahn seh, ");
INSERT INTO bzj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“If yoo da di king a di Jooz, sayv yuself.” ");
INSERT INTO bzj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Wahn sain mi deh oava ih hed weh seh: DIS DA DI KING A DI JOOZ. ");
INSERT INTO bzj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wan a di kriminal dehn weh mi kroosifai saida Jeezas, staat tu insolt op Jeezas ahn seh, “Yoo da noh di Krais? Sayv yuself ahn sayv wee tu.” ");
INSERT INTO bzj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bot di ada wan stap ahn, ahn seh, “Yoo noh frayd fi Gaad eevn doa dehn sentens yoo tu det sayhn laik hihn? ");
INSERT INTO bzj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wee di geh egzakli weh wee joo sayka weh wee du, bot dis man noh du notn rang.” ");
INSERT INTO bzj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Den ih seh, “Jeezas, memba mi wen yu ton King.” ");
INSERT INTO bzj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jeezas ansa ahn seh, “Ah di tel yu di chroot, tudeh tudeh yu wahn deh wid mi eena Paradais.” ");
INSERT INTO bzj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Bai now da mi big twelv aklak da day, ahn di hoal plays geh daak daak til chree aklak da aftanoon, ");
INSERT INTO bzj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kaa di son mi stap shain. Den di kertn weh mi heng op eena di templ tayr rait eena too. ");
INSERT INTO bzj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jeezas hala owt haad-wan, “Faada, Ah di put mi spirit eena yu han.” Az soon az ih don seh dat, ih jraa ih laas bret. ");
INSERT INTO bzj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Di aami aafisa weh mi-di stan op deh si evriting weh mi hapm, ahn ih staat tu prayz Gaad. Ih seh, “Dis da-mi wahn gud man fi chroo.” ");
INSERT INTO bzj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wen aala di peepl dehn weh mi-di stan op rong di luk aan si weh aal mi-di hapm, dehn ton weh ahn gaahn hoahn sad sad. ");
INSERT INTO bzj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bot aala dehn wan weh mi noa Jeezas, eevn di laydi dehn weh mi fala ahn fahn Gyalilee, mi-di stan op fahn faar di luk aan pahn evriting. ");
INSERT INTO bzj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Now dehn mi ga wahn man nayhn Joazef, weh mi kohn fahn Arimateeya. Hihn da-mi wahn gud ahn deesent man ahn ih mi-di luk faawod tu di taim wen Gaad mi wahn set op ih kingdom. Ih da-mi wahn memba a di Jooish Kongsl, bot ih neva agree wid di akshan weh di ada leeda dehn mi tek gens Jeezas. ");
INSERT INTO bzj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wel, dis man gaahn da Pailat ahn aks fi Jeezas badi. ");
INSERT INTO bzj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ih tek dong di badi fahn aafa di kraas ahn rap it op eena sohn linin klaat. Ih put it fi lidong eena wahn toom weh mi dig owta wahn raki hil. Da mi wahn toom weh dehn neva put no ded badi eena yet. ");
INSERT INTO bzj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Da mi soon taim fi di Sabat ahn dehn mi hafu geh redi far it. ");
INSERT INTO bzj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Di laydi dehn weh mi kohn wid Jeezas fahn Gyalilee fala Joazef ahn si weh di toom mi deh ahn how dehn put ih badi fi lidong eena it. ");
INSERT INTO bzj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Den dehn gaahn hoahn fi fiks op sohn aintment ahn perfyoom fi rob pahn Jeezas badi. Bot dehn res pahn di Sabat kaa dehn mi waahn obay weh di Laa seh. ");
INSERT INTO bzj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Soon-wan di Sondeh maanin, di laydi dehn tek di sweet aintment dehn weh dehn mi fiks ahn dehn gaahn da Jeezas toom. ");
INSERT INTO bzj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dehn fain owt dat sohnbadi mi don roal weh di stoan fahn fronta di toom. ");
INSERT INTO bzj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ahn wen dehn gaan eensaid, dehn neva fain di Laad Jeezas badi ataal. ");
INSERT INTO bzj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Wail dehn stil mi-di wanda egzakli weh gaan aan, sodn-wan too man mi dehdeh di stan op saida dehn. Dehn kloaz mi soh wait til ih hat di laydi dehn aiy anaal. ");
INSERT INTO bzj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Weh di laydi dehn mi soh fraitn, dehn hori bow dong fronta di man dehn til dehn fays toch di grong. Bot di man dehn aks dehn seh, “Wai unu di luk fi sohnbadi weh livin monks peepl weh ded? ");
INSERT INTO bzj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hihn noh deh ya; hihn don rayz op bak fahn di ded! Memba weh ih mi tel unu wail ih mi stil deh wid unu da Gyalilee? ");
INSERT INTO bzj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ih mi seh, ‘Di Son a Man wahn hafu geh han oava tu sohn wikid man weh wahn kroosifai ahn. Ahn chree dayz layta ih wahn rayz op bak fahn di ded.’” ");
INSERT INTO bzj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Den di laydi dehn mi jos memba dat Jeezas mi seh dat fi chroo. ");
INSERT INTO bzj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","Di laydi dehn weh mi gaahn da di toom da-mi Mayri Magdaleen, Joaana, Jaymz ma weh nayhn Mayri tu, ahn sohn ada laydi. Wen dehn reech bak, dehn tel di ilebm apasl dehn ahn di res weh mi dehdeh wid dehn aal weh mi hapm. ");
INSERT INTO bzj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bot di disaipl dehn neva bileev wan ting weh di laydi dehn mi tel dehn, kaa ih mi song laik mek-op stoari. ");
INSERT INTO bzj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bot Peeta get op ahn ron gaahn da Jeezas toom. Ih ben dong ahn luk eensaid ahn ih si di loan pees a linin klaat dehn weh dehn mi rap op Jeezas wid. Peeta lef fahn di toom di wanda tu ihself weh mi hapm. ");
INSERT INTO bzj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Now da sayhn day, too man weh doz fala Jeezas mi-di waak gwehn da wahn vilij weh nayhn Emayos, weh mi deh bowt sebm mailz fahn Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Dehn mi-di taak tu wan anada bowt aal weh mi hapm. ");
INSERT INTO bzj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wail dehn mi-di taak ahn diskoas bowt evriting, Jeezas ihself kom op ahn staat tu waak lang wid dehn. ");
INSERT INTO bzj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bot Gaad mek it soh dat dehn neva rekonaiz ahn. ");
INSERT INTO bzj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jeezas aks dehn seh, “Da weh unu di taak bowt wail unu waak lang?” Dehn stap ahn stan op wan plays ahn dehn mi-di luk sad. ");
INSERT INTO bzj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Den wan a dehn weh mi nayhn Kliyopas ansa ahn seh, “Yoo da mosi di oanli persn fahn Jeroosalem weh noh noa weh aal mi hapm dehsoh dehn paas fyoo dayz.” ");
INSERT INTO bzj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jeezas aks dehn seh, “Wai, weh kaina ting hapm deh?” Dehn ansa ahn seh, “Di ting dehn bowt Jeezas weh kohn fahn Nazaret, man. Gaad ahn aala di peepl dehn doz tink moch a ahn, kaa hihn da-mi wahn prafit weh doz du ahn seh wahn lata wandaful ting. ");
INSERT INTO bzj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Den fi wee cheef prees dehn ahn di Jooish leeda dehn mek di Roaman govna sentens ahn tu det ahn kroosifai ahn. ");
INSERT INTO bzj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wee mi-di hoap dat hihn mi wahn bee di Wan weh mi wahn free Izrel, bot da don chree dayz sins aala dis hapm. ");
INSERT INTO bzj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Pahn tap a aala dat, sohn laydi fahn owta wi groop kohn shak wi wen dehn tel wi seh dat dehn gaahn da Jeezas toom soon dis maanin, ahn dehn neva fain ih badi deh. Den dehn kohn bak ahn tel wi dat dehn si wahn vizhan wid sohn aynjel weh tel dehn dat Jeezas mi alaiv. ");
INSERT INTO bzj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Som a dehn wan weh mi deh wid wi gaahn da di toom ahn fain it jos laik how di laydi dehn mi seh, bot dehn neva si Jeezas ihself.” ");
INSERT INTO bzj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Den Jeezas seh tu di too man dehn, “Aiy, da how unu soh simpl, ahn wai ih soh haad fi unu bileev aal weh di oal taim prafit dehn mi seh? ");
INSERT INTO bzj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Unu neva noa seh dat di Krais mi hafu sofa fos, ahn den ih wahn bee taim fi hihn geh fi hihn gloari?” ");
INSERT INTO bzj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Den Jeezas eksplayn evriting weh rait dong eena di Skripcha bowt ihself tu dehn. Ih staat fahn weh Moaziz mi rait, den aala di ada prafit dehn kohn rait dong. ");
INSERT INTO bzj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Az dehn mi-di kohn kloas tu di vilij weh dehn mi gwehn, Jeezas waak heda dehn lee bit ahn du laik ih mi gwehn aan ferda. ");
INSERT INTO bzj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bot di too man dehn bayg ahn haad seh, “Stay wid wi noh? Eevnin soon kohn, ahn di day nayli don.” Soh Jeezas gaahn gaahn stay wid dehn. ");
INSERT INTO bzj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wen Jeezas mi-di sidong rong di taybl wid dehn, ih tek wahn bred, ih bles it ahn brok it, ahn den ih gi dehn fi eet. ");
INSERT INTO bzj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sodn-wan dehn mi riyalaiz da-mi hoo hihn; ahn sayhn taim Jeezas disapyaa fahn fronta dehn. ");
INSERT INTO bzj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Di man dehn seh tu wan anada, “Bwai, yoo neva feel wahn waam feelin eena yu haat wen ih mi-di taak tu wi pahn di road, wen ih mi-di eksplayn di Skripcha tu wi?” ");
INSERT INTO bzj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Di too man dehn get op sayhn taim ahn gaahn bak da Jeroosalem. Dehn fain di ilebm apasl dehn wehpaa dehn mi gyada wid di res a dehn groop. ");
INSERT INTO bzj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Dehn tel di too man dehn, “Di Laad kohn bak fahn di ded fi chroo! Ih apyaa tu Saiman Peeta!” ");
INSERT INTO bzj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Den di too man dehn tel dehn weh mi hapm pahn di way tu Emayos, how dehn mi rekonaiz Jeezas wen ih brok di bred. ");
INSERT INTO bzj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wail dehn mi-di taak bowt weh mi hapm, Jeezas ihself stan op monks dehn ahn seh, “Pees deh wid unu!” ");
INSERT INTO bzj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dehn mi oanli fraitn, ahn dehn mi tink seh dat dehn mi-di si goas! ");
INSERT INTO bzj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jeezas aks dehn seh, “Wai unu di wori unuself? Wai unu neva bileev eena unu haat? ");
INSERT INTO bzj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Luk pahn mi han ahn fut dehn. Si, da mee! Toch mi ahn si. Wahn goas noh ga flesh ahn boan laik weh unu si Ai ga.” ");
INSERT INTO bzj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wen ih seh dat, ih shoa dehn ih han ahn ih fut dehn. ");
INSERT INTO bzj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Di apasl dehn mi oanli sopraiz ahn dehn mi feel glad dat Jeezas neva ded agen, bot dehn stil neva soh bileev, soh Jeezas aks dehn seh, “Unu ga eniting ya fi eet?” ");
INSERT INTO bzj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dehn gi ahn wahn pees a gril fish, ");
INSERT INTO bzj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ahn ih tek it ahn eet it rait fronta dehn. ");
INSERT INTO bzj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jeezas tel dehn seh, “Dis da weh Ah mi tel unu wail Ah mi stil deh wid unu: Evriting hafu hapm weh rait dong bowt mi—evriting weh Moaziz ahn di prafit dehn mi rait, ahn weh rait eena Saamz.” ");
INSERT INTO bzj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Den Jeezas eksplayn tu dehn soh dat dehn kuda mi andastan weh di Skripcha seh. ");
INSERT INTO bzj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ih tel dehn seh, “Dis da weh rait eena di Skripcha: Di Krais wahn sofa, ahn den ih wahn rayz op bak fahn di ded chree dayz aftawodz. ");
INSERT INTO bzj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Staatin fahn Jeroosalem, den tu aala di ada nayshan dehn, dehn wahn preech dat eena fi hihn naym Gaad wahn fagiv evribadi weh ton fahn dehn sin dehn. ");
INSERT INTO bzj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Unu deh ya fi witnis aala dehnya ting weh hapm. ");
INSERT INTO bzj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ah wahn sen di Hoali Spirit weh mi Faada eena hevn mi pramis unu. Bot stay da di siti til powa fahn hevn kohn dong pahn unu.” ");
INSERT INTO bzj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Den Jeezas leed dehn owt az faar az Betani, ahn den ih lif op ih han dehn ahn bles dehn. ");
INSERT INTO bzj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wail ih mi-di bles dehn, ih lef dehn ahn Gaad kehr ahn op da hevn. ");
INSERT INTO bzj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Den dehn wership ahn, ahn den dehn gaahn bak da Jeroosalem ahn dehn oanli mi feel glad. ");
INSERT INTO bzj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Afta dat dehn mi aalwayz deh da di templ di prayz Gaad.");
INSERT INTO bzj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bifoa Gaad mi eva mek eniting ataal, di Wan weh dehn kaal di Werd, hihn mi deh rait deh wid Gaad. In fak, hihn da-mi Gaad ihself. ");
INSERT INTO bzj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yes, di Werd mi deh rait deh lang wid Gaad fahn di biginin. ");
INSERT INTO bzj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dat da di sayhn Werd weh mek evriting, ahn Gaad neva mek notn widowt hihn. ");
INSERT INTO bzj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Di Werd da di Wan weh reel laif kohn fram, ahn da laif da di Lait weh shain pahn peepl fi mek dehn si how fi liv. ");
INSERT INTO bzj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Da Lait di shain pahn evriting weh daak wid sin, ahn di daaknis kyaahn owt it ataal. ");
INSERT INTO bzj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Now, dehn mi ga dis man weh nayhn Jan weh Gaad mi sen. ");
INSERT INTO bzj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dis man Jan mi kohn fi tel evribadi bowt da sayhn Lait soh dat dehn kuda mi yehr bowt ahn, ahn bileev eena ahn. ");
INSERT INTO bzj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Now, Jan ihself da neva di Lait; hihn mi oanli kohn fi tel peepl di chroot bowt di Lait. ");
INSERT INTO bzj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yu si, di Wan weh da di chroo chroo Lait mi-di kom eena di werl ahn shain pahn evribadi. ");
INSERT INTO bzj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Di Werd mi-di liv eena di sayhn werl weh hihn mek, ahn di peepl dehn eena di werl neva eevn noa seh dat da di Werd ihself mi-di liv monks dehn. ");
INSERT INTO bzj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ih kohn tu ih oan konchri, ahn ih oan peepl dehn neva aksep ahn. ");
INSERT INTO bzj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bot dehn mi ga som a dehn weh mi did aksep ahn, ahn bileev eena ahn. Soh hihn gi aala dehn wan deh di rait fi bee Gaad pikni. ");
INSERT INTO bzj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bot dehn neva ton Gaad pikni chroo di yoozhwal way, laik how baybi baan, wid wahn ma ahn wahn pa. Da Gaad ihself da di Wan weh mek dehn fi hihn pikni. ");
INSERT INTO bzj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Wel, di Werd ton hyooman ahn ih kohn kohn liv monks wi. Wee mi si fi hihn gloari, di gloari weh Gaad gi ih wan ahn oanli Son. Hihn lov wi tu nohmoh nohmoh ahn ih shoa wi wahn kainis weh wi noh dizerv, ahn ih mek wi si di reel chroot bowt Gaad. ");
INSERT INTO bzj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jan mi tel evribadi bowt ahn. Ih hala seh, “Dis da di Wan weh Ah mi seh mi wahn kohn. Hihn grayta dahn mee, kaa hihn mi deh bifoa mee mi eevn baan.” ");
INSERT INTO bzj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sayka weh hihn ful op a soh moch lov ahn kainis, wi geh blesin pahn tap a blesin fahn hihn. ");
INSERT INTO bzj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Gaad mi gi Moaziz di Laa fi gi wi, bot Jeezas Krais shoa wi fi hihn kainis weh wi neva dizerv, ahn sayka hihn, wi geh fi noa di chroot. ");
INSERT INTO bzj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nobadi neva si Gaad yet, eksep ih wan ahn oanli Son weh da Gaad ihself, ahn weh deh kloas kloas tu di Faada. Da hihn mek wi noa how Gaad di Faada stan. ");
INSERT INTO bzj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Now di Jooish leeda dehn sen sohn prees ahn som a dehn wan weh werk eena di templ fi aks Jan da hoo hihn. Wel, Jan neva frayd fi dehn ataal; ih mek dehn noa playn-wan seh, “Mee da noh di Krais, yu noh.” ");
INSERT INTO bzj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Soh dehn aks ahn seh, “Wel, da hoo yoo den? Ilaija?” Jan seh, “No, Ai da noh Ilaija.” Den dehn aks ahn seh, “Yoo da di Prafit?” Ih seh, “No.” ");
INSERT INTO bzj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Dehn tel ahn seh, “Wel, da hoo yoo den? Tel wi soh dat wi ku noa weh fi goh bak goh tel dehn wan weh sen wi. Weh yu ga fi seh fi yuself?” ");
INSERT INTO bzj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wel, Jan tel dehn egzakli weh Aizaiya di prafit mi seh bowt hihn. Ih seh, “Ai da di vais weh di hala owt eena di dezert di seh, ‘Mek di road dehn schrayt fi wen di Laad kohn.’” ");
INSERT INTO bzj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Den di Farisee dehn sen sohn man fi aks Jan seh, “Wel, da wai yoo di baptaiz peepl den if yoo da noh di Krais, ner Ilaija, ner di Prafit?” ");
INSERT INTO bzj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jan ansa dehn seh, “Yes, Ai baptaiz peepl wid waata, bot sohnbadi deh rait ya monks unu weh unu noh eevn noa. ");
INSERT INTO bzj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hihn da di Wan weh wahn kohn afta mee; Ai noh eevn gud nof fi loos fi hihn shooz laysn.” ");
INSERT INTO bzj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Aala dis mi hapm da wahn vilij weh nayhn Betani weh mi deh kraas di neks said a Jaadn Riva wehpaa Jan mi-di baptaiz peepl. ");
INSERT INTO bzj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Di neks day Jan di Baptis si Jeezas di kohn tuwaadz ahn, ahn ih seh, “Luk, si di Wan weh da Gaad Lam deh! Da hihn wahn tek weh di powa weh sin ga oava di peepl dehn a di hoal werl. ");
INSERT INTO bzj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Da hihn Ah mi-di taak bowt wen Ah mi seh, ‘Sohnbadi di kohn weh grayta dahn mee kaa hihn deh fahn bifoa mee mi eevn baan.’ ");
INSERT INTO bzj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mee miself neva noa da mi hoo hihn fos. Dats wai Ai mi-di baptaiz peepl wid waata soh dat di hoal a Izrel ku noa da hoo hihn tu.” ");
INSERT INTO bzj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Den Jan seh, “Mee miself si di Hoali Spirit di kohn dong owta hevn, jos laik how wahn dov wuda kohn dong, ahn ih kohn rait dong pan ahn, ahn stay deh. ");
INSERT INTO bzj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Az Ah seh, mee neva noa da hoo hihn, bot wen Gaad sen mi fi baptaiz peepl wid waata, ih tel mi seh, ‘Di wan weh yu si mi Spirit kohn dong pan, ahn stay pan, da hihn da di Wan weh ku baptaiz wid di Hoali Spirit.’ ");
INSERT INTO bzj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Wel, mee miself mi see't fi chroo, an Ai di tel unu dat dis da Gaad Son.” ");
INSERT INTO bzj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Di neks day Jan mi dehdeh agen di stan op wid too a ih falowa dehn, ahn wen ih si Jeezas di paas, ih bos owt ahn seh, “Unu luk deh! Da Gaad Lam dat!” ");
INSERT INTO bzj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wen di too falowa dehn yehr weh Jan seh, dehn gaahn gaahn fala Jeezas. ");
INSERT INTO bzj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Wen Jeezas ton rong ahn si dehn di fala ahn, ih aks dehn seh, “Da wai unu di fala mi?” Dehn seh, “Rabai, da weh yoo liv?” (Rabai meen teecha eena Heebroo.) ");
INSERT INTO bzj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jeezas tel dehn seh, “Kohn si noh?” Soh dehn gaahn gaahn si weh ih mi-di stay. Da mi bowt foar aklak da aftanoon wen dehn gaan, ahn dehn stay wid ahn fi di res a di day. ");
INSERT INTO bzj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Saiman Peeta breda weh nayhn Anjru da-mi wan a di too falowa dehn weh mi yehr weh Jan mi seh bowt Jeezas. Wel, hihn gaahn gaahn jain op wid Jeezas tu. ");
INSERT INTO bzj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Di fos ting weh hihn gaahn du da fain Saiman ahn tel ahn seh, “Bwai! Wee fain di Mesaiya, yu noh!” (Mesaiya meen Krais eena di Greek langwij.) ");
INSERT INTO bzj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Anjru kehr Saiman da Jeezas ahn Jeezas luk pan ahn, ahn seh, “Yoo da Saiman weh da Jan son. Fahn ya goh bak yu wahn nayhn Seefas.” (Seefas meen Peeta, weh meen “rak.”) ");
INSERT INTO bzj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Di neks day Jeezas disaid fi goh da Gyalilee. Ih fain wahn man weh nayhn Filip ahn ih tel ahn seh, “Kohn wid mi, kohn bee wan a mi disaipl dehn.” ");
INSERT INTO bzj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip mi kohn fahn Betsayda weh da di sayhn siti wehpaa Anjru ahn Peeta mi kohn fram. ");
INSERT INTO bzj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Afta dat Filip gaahn fain Natanyel ahn tel ahn seh, “Wee fain di Wan weh Moaziz ahn di res a prafit dehn mi rait bowt eena di Skripcha. Ih da Jeezas weh da Joazef son, ahn ih kohn fahn Nazaret.” ");
INSERT INTO bzj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanyel aks Filip, “Cho! Eniting gud ku kohn fahn Nazaret?” Filip tel ahn seh, “Wel, kohn si fi yuself den.” ");
INSERT INTO bzj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Wen Jeezas si Natanyel di kohn tuwaadz ahn, ih seh dis bowt ahn, “Dis da wan Izrelait weh wuda neva lai tu yu!” ");
INSERT INTO bzj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanyel aks Jeezas seh, “Da weh yoo noa mee fram?” Jeezas tel ahn seh, “Ai si yoo anda di fig chree fahn bifoa Filip gaahn fi yu.” ");
INSERT INTO bzj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanyel tel Jeezas seh, “Teecha, yoo da Gaad Son fi chroo. Yoo da di king a Izrel.” ");
INSERT INTO bzj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jeezas aks ahn seh, “Yoo bileev mi kaa Ai seh how Ah mi si yu anda di fig chree? Yu wahn si biga ting dan dat.” ");
INSERT INTO bzj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Den Jeezas seh, “Ah di tel yu di chroot, yu wahn si hevn oapm op ahn yu wahn si Gaad aynjel dehn di goh op ahn dong pahn di Son a Man.” ");
INSERT INTO bzj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Too dayz afta dat, dehn mi ga wahn wedn da Kayna, weh deh eena Gyalilee. Jeezas ma mi dehdeh, ");
INSERT INTO bzj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ahn Jeezas ahn ih disaipl dehn mi geh invaitid tu di wedn tu. ");
INSERT INTO bzj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wen aala di wain mi don, Jeezas ma gaahn gaahn tel ahn seh, “Dehn noh ga nohmoh wain.” ");
INSERT INTO bzj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jeezas ansa ahn seh, “Ma, dat da noh non a fi wee bizniz, yu noh; ahn bisaidz, mai taim noh kohn yet.” ");
INSERT INTO bzj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ih ma gaahn hed eniway ahn tel di servant dehn seh, “Eniting weh Jeezas tel unu fi du, unu du it.” ");
INSERT INTO bzj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Now siks big stoan kantayna mi dehdeh weh di Jooz dehn mi hafu yooz fi dehn washin serimoni. Dehn kantayna dehn kuda mi hoal bowt tweni tu terti gyalan. ");
INSERT INTO bzj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jeezas tel di servant dehn, “Ful op di kantayna dehn wid waata.” Soh dehn ful op di kantayna dehn rait op tu di rim. ");
INSERT INTO bzj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Den ih tel dehn seh, “Dip op som a di waata ahn kehr it da di man weh in chaaj a evriting ya.” Soh dehn kehr di waata tu ahn, ahn ih tays it. ");
INSERT INTO bzj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bai da taim deh, di waata mi don ton tu wain aredi. Laik how da mi di servant dehn weh mi ful op di kantayna dehn wid waata, dehn mi don noa weh di wain kohn fram, bot di man in chaaj neva noa. Soh ih kaal di groom, ");
INSERT INTO bzj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ahn ih seh tu ahn, “Yoozhwali peepl wuda serv dehn bes wain fos. Den wen evribadi don jrink wahn lat aredi, dat da wen dehn wuda bring owt di cheep wain. Bot yoo neva du dat. Yoo lef di bes wain til laas.” ");
INSERT INTO bzj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Dis mirakl weh Jeezas mi du da Kayna eena Gyalilee da-mi di fos mirakl weh ih mi eva du. Da rait dehsoh dehn mi si how wandaful hihn wandaful; da den ih disaipl dehn geh fi bileev eena ahn. ");
INSERT INTO bzj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Afta dat, Jeezas gaahn dong da Kapernyam, lang wid ih ma ahn ih breda dehn ahn ih disaipl dehn, ahn dehn stay deh fi sohn dayz. ");
INSERT INTO bzj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Da mi nayli taim fi di Jooish selibrayshan weh nayhn di Paasoava, soh Jeezas gaan op da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Wen ih reech deh, ih gaahn da di templ ahn ih fain peepl eena di yaad di sel kow ahn sheep ahn pijin fi sakrifais, ahn di moni chaynja dehn mi dehdeh rong fi dehn taybl tu. ");
INSERT INTO bzj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Soh ih tek roap ahn mek wahn wip, ahn wap evribadi owt, lang wid dehn sheep ahn dehn kow; den ih ton oava di moni chaynja dehn taybl ahn skyata aala dehn moni. ");
INSERT INTO bzj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ih tel dehn wan weh mi-di sel pijin, “Kehr dehn ting owta ya! Stap tek mi Faada hows mek maakit!” ");
INSERT INTO bzj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Rait den, Jeezas disaipl dehn memba dat di Skripcha seh, “Gaad, di lov weh Ah ga fi yu hows di bon eena mi laik faiya.” ");
INSERT INTO bzj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Di Jooish leeda dehn aks ahn seh, “Weh mirakl yoo ku du az wahn sain fi shoa wi dat yoo ga di rait fi goh aan laik dis?” ");
INSERT INTO bzj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Soh Jeezas ansa ahn seh, “Brok dong dis templ, ahn eena chree dayz taim Ai wahn bil it op bak.” ");
INSERT INTO bzj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Dehn aks Jeezas seh, “Ih mi tek hoal a faati siks yaaz fi bil dis templ. Ahn yoo wahn ku bil it bak eena chree dayz?” ");
INSERT INTO bzj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Bot di templ weh Jeezas mi-di taak bowt da-mi fi hihn badi. ");
INSERT INTO bzj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Soh wen Jeezas mi rayz op bak fahn di ded, ih disaipl dehn mi memba dat Jeezas mi did seh dat fi chroo. Den dehn mi bileev weh di Skripcha seh, ahn weh Jeezas mi seh. ");
INSERT INTO bzj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Wen Jeezas mi stil deh da Jeroosalem joorin di Paasoava selibrayshan, wahn lata peepl geh fi bileev eena ahn afta dehn si aala di mirakl dehn weh ih du. ");
INSERT INTO bzj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bot Jeezas neva chros dehn ataal, kaa hihn mi don noa weh mi reeli deh eena dehn haat. ");
INSERT INTO bzj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nobadi neva hafu tel hihn how dehn peepl stay, kaa hihn mi don noa aredi. ");
INSERT INTO bzj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Dehn mi ga dis Jooish rilijos leeda weh da-mi wahn Farisee. Hihn mi nayhn Nikodeemos. ");
INSERT INTO bzj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wahn nait ih gaahn da Jeezas ahn tel ahn seh, “Teecha, wee noa dat da Gaad ihself sen yoo fi teech wi kaa nobadi kyaahn du di mirakl dehn weh yoo di du, eksep Gaad deh wid dehn.” ");
INSERT INTO bzj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jeezas ansa ahn seh, “Ah di tel yu di chroot, nobadi kyaahn bee paat a Gaad kingdom if dehn noh baan oava agen.” ");
INSERT INTO bzj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodeemos aks Jeezas seh, “How yu meen? Da how sohnbadi wahn baan agen if dehn don oal aredi? Ih kyaahn goh bak eena ih ma beli ahn baan oava agen!” ");
INSERT INTO bzj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jeezas tel ahn seh, “Ah di tel yu di chroot, nobadi kyaahn bee wahn paat a Gaad kingdom eksep ih baan chroo waata ahn chroo di Hoali Spirit. ");
INSERT INTO bzj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Flesh ahn blod baan flesh ahn blod, ahn di Hoali Spirit baan spirit. ");
INSERT INTO bzj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Soh noh sopraiz wen Ah tel yu, ‘Yu hafu baan oava agen.’ ");
INSERT INTO bzj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Da oanli Gaad Spirit ku gi nyoo laif. Yu si, di Hoali Spirit da jos laik di breez weh bloa eniway ih waahn, ahn yu ku yehr di song weh ih mek, bot yu noh noa wichpaa ih kohn fram er weh ih gwehn.” ");
INSERT INTO bzj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodeemos aks Jeezas seh, “Bot da how dat ku hapm?” ");
INSERT INTO bzj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jeezas ansa ahn seh, “Yoo da wahn big taim rilijos teecha da Izrel, soh how kom yoo noh andastan dehn ting deh? ");
INSERT INTO bzj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ah di tel yu di chroot, wee taak bowt weh wee noa, ahn wi tel evribadi weh wi si, ahn stil non a unu noh bileev wi. ");
INSERT INTO bzj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","If unu noh bileev wen Ah tel unu bowt ting weh unu noa bowt dong ya pahn ert, den da how unu wahn bileev if Ah tel unu bowt ting weh ga fi du wid Gaad? ");
INSERT INTO bzj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nobadi neva gaan op da hevn yet eksep di Son a Man weh kohn dong fahn hevn. ");
INSERT INTO bzj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Wen Moaziz mi deh eena di dezert, ih mi lif op wahn braas snayk weh ih mi mek ahn put it pahn wahn poas. Da jos laik dat dehn wahn lif op di Son a Man, ");
INSERT INTO bzj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","soh dat enibadi weh put dehn fayt eena ahn wahn liv wid Gaad fareva. ");
INSERT INTO bzj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Yu si, Gaad lov di peepl dehn eena dis werl soh moch dat ih giv op ih wan ahn oanli Son fi dehn, soh dat enibadi weh put dehn fayt eena ahn wahn neva ded; insteda dat, dehn wahn liv wid Gaad fareva. ");
INSERT INTO bzj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gaad neva sen ih Son eena di werl fi kandem peepl, bot ih sen ahn fi sayv dehn. ");
INSERT INTO bzj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Gaad noh wahn kandem non a dehn wan weh put dehn fayt eena ih Son, bot dehn wan weh noh bileev eena ahn don kandem lang taim, kaa dehn neva put dehn fayt eena Gaad wan ahn oanli Son. ");
INSERT INTO bzj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Dis da wai Gaad wahn joj dehn: kaa hihn sen di Lait soh dat peepl ku si how fi goh; bot dehn raada di daaknis moa dan di lait, kaa dehn waahn goh hed ahn du dehn wikidnis. ");
INSERT INTO bzj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kaa aala dehn wan weh laik du wikidnis noh laik it wen lait shain pahn dehn. In fak, dehn hayt it ahn dehn noh waahn kom eena di lait, kaa dehn noh waahn nobadi noa aal di wikidnis weh dehn di du. ");
INSERT INTO bzj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bot dehn wan weh du weh Gaad seh da di rait ting fi du, wahn oanli tu glad fi kom eena di lait, soh dat evribadi ku si dat Gaad deh eena evriting weh dehn du.” ");
INSERT INTO bzj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Afta dat Jeezas ahn ih disaipl dehn gaahn da wahn neks spat eena Judeeya. Ih spen sohn taim deh wid dehn di baptaiz sohn peepl. ");
INSERT INTO bzj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jan di Baptis mi deh da Aynon weh mi deh kloas Saylem di baptaiz peepl tu, kaa lata waata mi dehdeh, ahn peepl stodi mi-di kohn fi geh baptaiz. ");
INSERT INTO bzj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Dat da-mi bifoa dehn lak op Jan eena jayl. ");
INSERT INTO bzj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Now som a Jan falowa dehn mi-di aagyu wid wahn Jooish man bowt di washin serimoni weh di Jooz dehn du. ");
INSERT INTO bzj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dehn kohn tu Jan ahn seh tu ahn, “Teecha, yu si di man weh mi deh wid yu pahn di neks said a Jaadn, di sayhn wan weh yu aalwayz mi-di tel wi bowt? Wel, ih deh ya di baptaiz tu, ahn evribadi di goh tu hihn.” ");
INSERT INTO bzj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jan tel dehn seh, “Nobadi kyaahn geh notn eksep weh Gaad gi dehn. ");
INSERT INTO bzj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Unu unuself da mi witnis dat Ah mi seh, ‘Ai da noh di Krais, bot Gaad sen mee hed fi geh peepl redi fi wen hihn kohn.’ ");
INSERT INTO bzj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Di groom da di wan weh ga di braid. Di groom fren jos dehdeh di lisn fi wen di groom kohn, ahn ih rijais wen ih yehr ih vais. Wel, da di sayhn way wid mee; dats wai Ai oanli glad. ");
INSERT INTO bzj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Di Krais mos geh moa ahn moa impoatant, bot mee, Ai mos geh les ahn les impoatant. ");
INSERT INTO bzj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Gaad Son kohn fahn hevn ahn ih grayta dahn evribadi; aal laik mee, Ai kohn fahn di ert an Ai bizniz ya, soh Ai oanli ku taak bowt ting weh kansaan dong ya. Di wan weh kohn fahn hevn grayta dahn evribadi els. ");
INSERT INTO bzj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hihn taak bowt evriting weh hihn si ahn yehr, bot stilyet, nobadi noh bileev weh ih seh. ");
INSERT INTO bzj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Evribadi weh bileev weh hihn seh fain owt fi chroo dat Gaad noh di tel lai. ");
INSERT INTO bzj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Di wan weh Gaad sen seh aal weh Gaad waahn ih seh, kaa Gaad gi hihn di ful powa a ih Spirit, ahn ih neva hoal notn bak. ");
INSERT INTO bzj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Di Faada lov ih Son, ahn ih gi ahn powa oava evriting. ");
INSERT INTO bzj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Evribadi weh put dehn fayt eena Gaad Son wahn liv fareva; bot enibadi weh noh du weh di Son seh wahn neva ga da laif deh, ahn Gaad jojment wahn aalwayz di heng oava dehn hed.” ");
INSERT INTO bzj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Now di Farisee dehn yehr seh dat Jeezas mi ga moa peepl di fala hihn dan Jan, ahn dat Jeezas mi-di baptaiz moa peepl dan Jan. ");
INSERT INTO bzj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Akchwali, Jeezas ihself neva mi-di baptaiz nobadi; da ih disaipl dehn mi-di du di baptaizin. ");
INSERT INTO bzj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","4","Eniway, wen Jeezas yehr weh dehn mi-di seh, ih lef fahn Judeeya ahn hed bak da Gyalilee. Bot ih mi hafu paas chroo Samayrya. ");
INSERT INTO bzj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jeezas kohn tu wahn tong eena Samayrya weh nayhn Saika, weh mi deh kloas wahn pees a lan weh fahn way way bak Jaykop mi gi ih son weh nayhn Joazef. ");
INSERT INTO bzj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Wahn wel weh Jaykop mi dig mi stil dehdeh pahn da sayhn pees a lan. Jeezas sidong bai di wel fi res kaa ih mi taiyad owt fahn ih jerni. Dat da mi bowt twelv aklak da aftanoon. ");
INSERT INTO bzj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Now wahn laydi fahn Samayrya kohn da di wel kohn bak waata. Jeezas seh tu ahn, “Pleez gi mi sohn waata fi jrink noh?” ");
INSERT INTO bzj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Di disaipl dehn mi gaahn da tong fi bai ting fi eet.) ");
INSERT INTO bzj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Di laydi ansa Jeezas seh, “How kom yoo di aks mee fi waata? Yoo da wahn Joo, an Ai da wahn uman fahn Samayrya.” (Yu si, di Jooz ahn di Samaritan dehn noh miks op miks op ataal.) ");
INSERT INTO bzj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jeezas tel ahn seh, “Yoo noh noa weh Gaad waahn gi yu, ahn yu noh noa da hoo mee weh di aks yu fi waata. If yoo mi noa, den yu wuda mi aks mi fi di waata weh ku gi yu reel laif.” ");
INSERT INTO bzj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Di laydi seh tu Jeezas, “Sa, yoo noh ga no bokit, ahn di wel deep. Da weh yoo wahn geh da waata fram, weh ku gi mee reel laif? ");
INSERT INTO bzj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yoo grayta dan fi wee ansesta Jaykop den? Da hihn gi wee dis wel weh hihn, ahn fi hihn son dehn, ahn dehn animal doz jrink fram.” ");
INSERT INTO bzj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jeezas tel ahn seh, “Evribadi weh jrink fahn dis waata ya weh deh eena dis wel wahn geh tersti agen. ");
INSERT INTO bzj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Bot dehn wan weh jrink fahn di waata weh Ai wahn gi dehn noh wahn geh tersti nohmoh. Di waata weh Ai wahn gi dehn wahn di gosh op eena dehn jos laik dehn waata spring weh di waata neva stap. Disya waata wahn gi dehn reel laif weh wahn neva en.” ");
INSERT INTO bzj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Di laydi seh tu Jeezas, “Wel, Sa, Ai waahn som a da waata den, soh dat Ah wahn neva tersti agen. Den Ah noh wahn hafu di stodi kohn ya fi waata needa.” ");
INSERT INTO bzj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Den Jeezas tel ahn seh, “Goh kaal yu hozban ahn den kohn bak.” ");
INSERT INTO bzj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Di laydi tel ahn seh, “Mee noh ga no hozban.” Den Jeezas tel ahn seh, “Yu rait wen yu seh dat yu noh ga no hozban; ");
INSERT INTO bzj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kaa yu mi ga hoal a faiv hozban, ahn di man weh yu ga now da noh eevn yu hozban. Soh weh yu tel mi da chroo!” ");
INSERT INTO bzj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Di laydi seh, “Sa, Ai si dat yoo da wahn prafit! ");
INSERT INTO bzj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Fi wee ansesta dehn doz wership Gaad pahn dis mongtin, bot unu Jooz seh dat di plays weh peepl mos goh wership da Jeroosalem.” ");
INSERT INTO bzj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jeezas tel ahn seh, “Mis, bileev mi, di taim wahn kohn wen peepl noh wahn wership Gaad di Faada pahn dis mongtin ner da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Unu Samaritan peepl noh eevn noa hoo unu di wership, bot wee Jooish peepl noa hoo wee wership, kaa da chroo di Jooish peepl dehn Gaad sen di Wan weh wahn sayv peepl fahn dehn sin. ");
INSERT INTO bzj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bot di taim wahn soon kohn; in fak, ih don deh ya, wen peepl weh reeli waahn wership Gaad fi chroo wahn wership ahn fahn deep dong eena dehn haat, jos laik how di Spirit a Gaad waahn dehn wership; kaa dat da di kaina peepl weh Gaad di Faada di luk fa fi wership ahn. ");
INSERT INTO bzj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yu si, Gaad da spirit, ahn dehn wan weh wership ahn hafu reeli wership ahn fahn deep dong eena dehn haat, laik how di Spirit a Gaad waahn.” ");
INSERT INTO bzj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Di laydi tel Jeezas seh, “Ai noa dat di Mesaiya wahn kohn.” (Dat da di sayhn wan weh dehn kaal di Krais.) “Wen hihn kohn, hihn wahn mek wi noa evriting.” ");
INSERT INTO bzj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jeezas tel ahn seh, “Yu si mee weh deh ya di taak tu yu? Ai da hihn.” ");
INSERT INTO bzj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sayhn taim Jeezas disaipl dehn kohn bak. Dehn mi sopraiz dat ih mi-di taak tu wahn laydi, bot non a dehn neva seh, “Da weh yoo waahn?” er “Da weh yoo di taak wid shee fa?” ");
INSERT INTO bzj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Den di laydi lef ih waata jog ahn gaahn bak da di siti. Ih tel di peepl dehn seh, “Kohn kohn si wahn man weh tel mi evriting Ah eva du eena mi laif! Unu noh tink dat da hihn da di Krais?” ");
INSERT INTO bzj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Soh aala dehn lef di siti ahn gaahn bai weh Jeezas mi deh. ");
INSERT INTO bzj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Meenwail di disaipl dehn mi-di bayg Jeezas seh, “Teecha, kohn eet sohnting noh?” ");
INSERT INTO bzj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bot Jeezas tel dehn seh, “Ai ga ting fi eet weh unu noh eevn noa bowt.” ");
INSERT INTO bzj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Soh di disaipl dehn seh tu wan anada, “Nobadi neva bring notn fi hihn eet, noh chroo?” ");
INSERT INTO bzj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jeezas seh, “Da jos laik food tu mee wen Ai di du weh Gaad waahn Ai du. Da hihn da di Wan weh sen mee, an Ai hafu finish weh hihn sen mi fi du. ");
INSERT INTO bzj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Unu noh seh, ‘Foa monts moa ahn den da taim fi reep di krap?’ Bot Ai di tel unu, luk rong ahn si how di feel dehn raip raip ahn redi fi reep. ");
INSERT INTO bzj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","In fak, di wan weh di reep di krap don di geh pay aredi. Di krap weh hihn di gyada op da peepl weh wahn liv wid Gaad fareva; soh di wan weh plaant ahn di wan weh reep ku rijais tugeda. ");
INSERT INTO bzj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Da wahn chroo ting weh dehn seh, ‘Wan persn plaant, ahn wahn neks wan reep.’ ");
INSERT INTO bzj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ah sen unu owt eena Gaad feel fi reep weh unu neva plaant. Sohn ada peepl don werk haad fi plaant owt di feel, ahn aal weh unu hafu du now da jos goh een ahn reep weh dehn don plaant.” ");
INSERT INTO bzj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Lata di Samaritan dehn fahn da siti mi bileev eena Jeezas kaa di laydi mi tel dehn seh, “Dis man tel mi evriting weh Ai mi eva du eena mi laif!” ");
INSERT INTO bzj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Soh wen di Samaritan dehn kohn tu Jeezas, dehn bayg ahn fi stay wid dehn lee bit, ahn ih stay fi too dayz. ");
INSERT INTO bzj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Lat moa a dehn mi bileev sayka weh Jeezas tel dehn. ");
INSERT INTO bzj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Dehn tel di laydi seh, “Da noh oanli sayka weh yoo tel wee mek wee bileev, bot now da kaa wee yehr fi fi weeself, ahn wee noa seh dat hihn da di Wan weh wahn sayv di peepl dehn a di werl fi chroo.” ");
INSERT INTO bzj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Afta di too dayz, Jeezas lef fahn deh ahn gaahn da Gyalilee. ");
INSERT INTO bzj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Kaa Jeezas ihself mi seh how wahn prafit noh geh no rispek eena ih oan konchri.) ");
INSERT INTO bzj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wen Jeezas reech Gyalilee, di peepl dehn deh dehn welkom ahn, kaa dehn mi gaahn da di Paasoava selibrayshan tu, ahn dehn mi si weh aal ih mi du deh. ");
INSERT INTO bzj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Afta dat Jeezas gaahn bak da Kayna weh deh da Gyalilee, wehpaa ih mi ton waata intu wain. Wel, wahn govament ofishal weh mi liv da Kapernyam mi ga wahn son weh mi sik bad. ");
INSERT INTO bzj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wen ih yehr seh Jeezas mi kohn da Gyalilee fahn Judeeya, ih gaahn da Kayna Tong ahn bayg ahn haad fi mek ih kohn kohn heel ih son kaa ih mi deh pahn daiyin. ");
INSERT INTO bzj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Den Jeezas seh tu ahn, “Aiy, di oanli way unu wahn bileev da if unu si wahn lata mirakl ahn wandaz.” ");
INSERT INTO bzj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Den di ofishal tel Jeezas seh, “Sa, hori kohn bifoa mi lee bwai ded noh?” ");
INSERT INTO bzj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jeezas seh tu ahn, “Goh man, yu son noh wahn ded.” Di man bileev weh Jeezas tel ahn, ahn staat owt fi goh hoahn. ");
INSERT INTO bzj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Az di man mi-di goh dong tu wichpaa ih mi liv, ih servant dehn kohn meet ahn, ahn dehn tel ahn dat ih lee bwai mi alaiv. ");
INSERT INTO bzj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Di ofishal aks dehn da weh taim egzakli ih pikni mi staat tu feel beta, ahn dehn tel ahn seh, “Bowt wan aklak yestudeh aftanoon di feeva brok.” ");
INSERT INTO bzj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Da den di lee bwai pa kanchos dat dat da-mi di sayhn taim wen Jeezas mi tel ahn seh, “Yu son noh wahn ded.” Soh den, hihn ahn evribadi eena ih hows mi bileev eena Jeezas. ");
INSERT INTO bzj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Now dis da-mi di sekant taim Jeezas du wahn mirakl da Gyalilee afta ih mi kohn fahn Judeeya. ");
INSERT INTO bzj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Afta dat Jeezas gaan op da Jeroosalem fi wahn Jooish rilijos selibrayshan. ");
INSERT INTO bzj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Now wahn pool weh di Jooish peepl dehn kaal Betezda mi deh kloas di Sheep Gayt. Dis pool mi ga faiv varanda. ");
INSERT INTO bzj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Lata sik peepl doz di lidong bowt pahn di varanda dehn—peepl weh mi blain, peepl weh kudn waak gud, ahn dehn wan weh mi paralaiz. Dehn mi dehdeh di wayt fi wen di waata ster op. Kaa evri now ahn den wahn aynjel fahn Gaad wuda kohn dong ahn ster op di waata, ahn di wan weh get een deh fos geh heel. ");
INSERT INTO bzj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wel, wahn man mi dehdeh weh mi sik fi terti-ayt yaaz. ");
INSERT INTO bzj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Wen Jeezas si ahn di lidong deh, ih mi don mi noa dat hihn mi dehdeh fi wahn lang taim, soh ih aks di man, “Yoo waahn geh beta?” ");
INSERT INTO bzj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Di man tel Jeezas seh, “Sa, Ah noh ga nobadi fi help mi get eena di pool wen di waata geh ster op. Enitaim Ai chrai get eena di waata, sohnbadi els aalwayz step dong heda mi.” ");
INSERT INTO bzj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jeezas tel ahn seh, “Get op! Pik op yu mat ahn waak!” ");
INSERT INTO bzj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sayhn taim di man geh heel, ahn ih pik op ih mat ahn staat tu waak. Now da day deh da-mi di Sabat, ");
INSERT INTO bzj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","soh di Jooish leeda dehn seh tu di man weh mi geh heel, “Dis da di Sabat. Yoo noh noa seh yu noh fi di bak yu mat pahn di Sabat?” ");
INSERT INTO bzj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bot di man ansa dehn seh, “Di man weh heel mi tel mi, ‘Tek op yu mat ahn waak.’” ");
INSERT INTO bzj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dehn aks ahn seh, “Ahn da hoo dis man weh tel yoo fi tek op yu mat ahn waak?” ");
INSERT INTO bzj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bot di man weh mi geh heel neva noa da hoo mi tel ahn kaa Jeezas mi don disapyaa eena di krowd weh mi dehdeh. ");
INSERT INTO bzj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Aftawodz Jeezas fain di man eena di templ ahn tel ahn seh, “Yu si how yu geh heel? Wel, stap di sin er els sohnting wosara wahn hapm tu yu.” ");
INSERT INTO bzj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Den di man gaahn gaahn tel di Jooish leeda dehn dat da mi Jeezas weh mi heel ahn. ");
INSERT INTO bzj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Wel den, dehn staat tu haraas Jeezas kaa ih mi-di du ting laik dat pahn di Sabat. ");
INSERT INTO bzj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bot Jeezas ansa dehn seh, “Wel, mai Faada aalwayz di help peepl, an Ai di du di sayhn ting tu.” ");
INSERT INTO bzj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sayka weh Jeezas seh dat, ih mek di Jooish leeda dehn waahn kil ahn moa. Da noh oanli kaa ih mi-di brok di Sabat, bot pahn tap a dat, ih mi-di seh dat Gaad da fi hihn Faada, ahn dat mi-di mek hihn eekwal wid Gaad. ");
INSERT INTO bzj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jeezas tel dehn seh, “Ah di tel unu di chroot, di Son kyaahn du notn pahn ih oan. Ih oanli ku du weh ih si Gaad ih Faada du, kaa eniting weh ih Faada du, hihn du tu. ");
INSERT INTO bzj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Di Faada lov di Son, ahn ih shoa ahn evriting weh hihn ihself di du; ahn ih wahn mek di Son du grayta tingz dahn weh unu si hapm tu dis man ya, ahn unu wahn sopraiz. ");
INSERT INTO bzj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yes, jos laik how di Faada rayz op peepl fahn di ded ahn mek dehn liv agen, sayhn way di Son gi laif tu enibadi weh hihn waahn. ");
INSERT INTO bzj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Yu si, di Faada ihself noh joj nobadi, bot hihn gi di Son aal raits fi joj soh dat evribadi wahn aana di Son jos laik how dehn aana di Faada. Di Faada sen di Son, soh enibadi weh noh aana di Son noh aana di Faada needa. ");
INSERT INTO bzj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ah di tel unu di chroot, enibadi weh yehr weh Ai seh ahn weh bileev di Wan weh sen mi, don ga di laif weh wahn neva en. No jojment noh deh pahn fi dehn hed, kaa dehn don kraas oava fahn det tu laif. ");
INSERT INTO bzj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Ah di tel unu di chroot, di taim di kohn; in fak, ih don deh ya aredi, wen dehn wan weh ded wahn yehr di Son a Gaad vais; ahn aala dehn wan weh yehr ahn, ahn du weh ih seh, wahn liv. ");
INSERT INTO bzj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kaa jos laik how di Faada ga di powa eena hihn fi gi laif, sayhn way hihn gi di Son powa fi gi laif tu; ");
INSERT INTO bzj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ahn di Faada gi di Son aal raits fi joj kaa hihn da di Son a Man. ");
INSERT INTO bzj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","“Noh bee soh sopraiz bowt weh Ah seh, kaa di taim di kohn wen aala dehn wan weh deh eena dehn grayv wahn yehr fi hihn vais ahn kom owt. Dehn wan weh mi du gud wahn rayz op bak ahn liv fareva; ahn dehn wan weh mi du bad wahn rayz op bak fi geh kandem. ");
INSERT INTO bzj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ai kyaahn du notn pahn mi oan. Ai oanli joj weh di Faada tel mi fi joj. Ahn wen Ai joj, Ai joj karek, kaa Ai noh oanli luk fi du weh Ai waahn, bot Ai du weh di Faada sen mi fi du. ");
INSERT INTO bzj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“If oanli mee taak bowt maiself, den weh Ai seh noh wahn wot notn. ");
INSERT INTO bzj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yu ga sohnbadi els weh taak op fi mi, an Ah noa dat weh hihn seh bowt mi da chroo. ");
INSERT INTO bzj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Unu sen aks Jan di Baptis bowt mi, ahn weh hihn tel unu da chroo. ");
INSERT INTO bzj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Da noh weh Ai hafu pen pahn weh eni man seh bowt mi, bot Ah oanli menshan weh Jan seh soh dat Gaad ku sayv unu. ");
INSERT INTO bzj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Now Jan da-mi laik wahn lamp weh mi-di shain brait, ahn weh hihn doz tel unu doz mek unu hapi fi wahn lee wail. ");
INSERT INTO bzj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Bot unu si dehn sayhn mirakl deh weh mai Faada sen mi fi du? Wel, dehndeh grayta dahn weh Jan mi seh bowt mi, kaa dehndeh da weh proov seh dat mai Faada sen mee fi chroo. ");
INSERT INTO bzj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Ahn mai Faada sen mi, ahn hihn ihself taak op fi mee. Unu neva yet yehr ih vais er si how ih luk, ");
INSERT INTO bzj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ahn unu noh aksep weh hihn tel unu ahn kip it eena unu haat, kaa unu noh bileev dat Ai da di Wan weh hihn sen. ");
INSERT INTO bzj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Unu stodi di Skripcha kaa unu tink seh unu wahn fain owt how fi liv fareva; ahn fi si dat da dehndeh sayhn Skripcha taak bowt mee. ");
INSERT INTO bzj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Bot unu stil noh waahn kohn tu mi fi geh reel laif. ");
INSERT INTO bzj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ai noh waahn no hyooman prayz mi. ");
INSERT INTO bzj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Bot Ai noa unu, ahn unu noh ga Gaad lov eena unu ataal. ");
INSERT INTO bzj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ai kom eena mi Faada naym, ahn unu noh aksep mi; if sohnbadi els kom eena fi dehn oan naym, unu wuda aksep dehn doh. ");
INSERT INTO bzj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Unu prifa wen peepl prayz unu. Unu noh kay fi mek di Wan ahn oanli Gaad prayz unu. No wanda unu kyaahn bileev! ");
INSERT INTO bzj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Noh tink seh Ai wahn paint finga pahn unu ahn akyooz unu fronta mi Faada; da Moaziz sayhn wan weh unu tink wahn help unu wahn bee di wan weh wahn akyooz unu. ");
INSERT INTO bzj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","If unu mi bileev Moaziz, den unu shuda bileev mee tu, kaa da hihn sayhn wan mi rait bowt mee. ");
INSERT INTO bzj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bot if unu noh bileev weh hihn mi rait, den how unu wahn bileev weh Ai seh?” ");
INSERT INTO bzj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Afta dat Jeezas gaahn da di neks said a Gyalilee Lagoon, weh sohn peepl kaal Taibeeryos See. ");
INSERT INTO bzj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Wahn big krowd stay mi-di fala ahn kaa dehn mi si aala di mirakl dehn weh ih mi du fi di sik peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jeezas gaan op di hilsaid ahn sidong deh wid ih disaipl dehn. ");
INSERT INTO bzj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Now da mi soon taim fi di Paasoava selibrayshan fi di Jooz dehn. ");
INSERT INTO bzj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Wen Jeezas luk op, ih si wahn big krowd di kohn tuwaadz ahn. Ih seh tu Filip, “Da weh wi wahn bai bred fi mek aala dehnya peepl eet?” ");
INSERT INTO bzj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jeezas oanli seh dat fi tes owt Filip, kaa Jeezas ihself mi don noa weh hihn mi wahn du. ");
INSERT INTO bzj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip ansa Jeezas seh, “Noh eevn ayt monts pay kuda bai nof bred fi mek eech wan a dehnya peepl ya geh wahn lee bit fi eet.” ");
INSERT INTO bzj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Wan a Jeezas disaipl nayhn Anjru, weh da-mi Saiman Peeta breda, seh tu ahn, ");
INSERT INTO bzj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wahn lee bwai deh ya weh ga faiv lee bred ahn too lee fish. Bot weh gud dat wahn du monks soh moch peepl?” ");
INSERT INTO bzj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jeezas seh, “Mek di peepl dehn sidong.” Now di plays mi graasi, graasi, soh dehn sidong. Jos fi konk di man dehn aloan da mi bowt faiv towzn a dehn in aal. ");
INSERT INTO bzj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Den Jeezas tek di bred dehn, ahn wen ih don gi Gaad tanks, ih shayr it owt tu aala dehn weh mi-di sidong; ih du di sayhn ting wid di fish, ahn dehn eet az moch az dehn mi waahn. ");
INSERT INTO bzj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wen dehn geh nof, Jeezas tel ih disaipl dehn seh, “Gyada op aala di lefoavaz soh notn noh ways.” ");
INSERT INTO bzj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wel, fos dehn mi oanli ga faiv bred, bot dehn en op di gyada op hoal a twelv baaskit ful a di lee pees a bred dehn weh mi lefoava afta di peepl dehn mi don eet. ");
INSERT INTO bzj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wen di peepl dehn si di mirakl weh Jeezas mi du, dehn staat tu seh, “Dis da di Prafit weh mi fi kom eena di werl fi chroo!” ");
INSERT INTO bzj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Wen Jeezas si dat di peepl dehn mi-di luk fi foas ahn fi bee king, ih gaahn bak op di hil soh dat ih kuda mi deh bai ihself. ");
INSERT INTO bzj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Wen eevnin mi kohn, Jeezas disaipl dehn mi gaahn dong da di lagoon. ");
INSERT INTO bzj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Dehn get eena wahn boat ahn staat aaf kraas di lagoon fi goh da Kapernyam. Ih mi don daak aredi, ahn Jeezas neva deh wid dehn yet. ");
INSERT INTO bzj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Breez mi-di bloa haad ahn ih mek di waata geh rof rof. ");
INSERT INTO bzj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Afta dehn mi don padl bowt chree er foa mailz, dehn si Jeezas di kohn tuwaadz dehn di waak pahn di waata tap. Wel, dehn mi fraitn no miks. ");
INSERT INTO bzj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bot Jeezas tel dehn seh, “Da mee. Noh frayd.” ");
INSERT INTO bzj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dehn mi oanli glad fi mek ih get eena di boat, ahn sodn-wan, di boat reech shoa sayhn plays weh dehn mi gwehn. ");
INSERT INTO bzj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Di neks day, di krowd weh mi stay pahn di ada said a di lagoon gaahn dong bai di waatasaid. Dehn mi noa seh dat oanli wan boat mi dehdeh di day bifoa, ahn di disaipl dehn mi get eena it ahn gaan, bot Jeezas neva deh wid dehn. ");
INSERT INTO bzj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Den sohn boat fahn Taibeeryos gaahn shoa kloas tu di plays wehpaa di peepl dehn mi eet di bred afta di Laad mi don gi tanks far it. ");
INSERT INTO bzj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Soh wen di krowd si dat needa Jeezas ner ih disaipl dehn mi dehdeh, dehn get eena dehn sayhn boat fahn Taibeeryos ahn gaahn da Kapernyam gaahn luk fi Jeezas. ");
INSERT INTO bzj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wen di krowd fain Jeezas pahn di neks said a di lagoon, dehn aks ahn seh, “Teecha, da wen yoo reech ya?” ");
INSERT INTO bzj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jeezas ansa dehn seh, “Ah di tel unu di chroot, unu noh di luk fi mee sayka di mirakl dehn weh unu si, bot da kaa unu geh unu beli ful. ");
INSERT INTO bzj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Noh bada kil op unuself di werk fi food weh wahn soon spail; insteda dat, werk fi di food weh wahn mek unu liv wid Gaad fareva. Da di Son a Man wahn gi unu da food deh kaa Gaad, weh da mai Faada, don shoa seh dat hihn pleez wid mee.” ");
INSERT INTO bzj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Di peepl dehn aks ahn seh, “Da weh wee fi du now fi mek wi du weh Gaad waahn?” ");
INSERT INTO bzj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jeezas tel dehn seh, “Weh Gaad waahn unu du, da fi bileev eena di Wan weh hihn sen.” ");
INSERT INTO bzj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Soh di peepl dehn seh, “Weh sain yu wahn shoa wi soh dat wi ku see't ahn bileev yu? Da weh yoo wahn du? ");
INSERT INTO bzj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Fi wee ansesta dehn mi eet mana wen dehn mi-di chravl chroo di dezert. Laik weh di Skripcha seh, ‘Hihn gi dehn bred weh kohn fahn hevn fi eet.’” ");
INSERT INTO bzj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jeezas seh, “Ah di tel unu di chroot, da neva Moaziz mi gi dehn da bred weh kohn fahn hevn; da mai Faada mi gi dehn. Now hihn di aafa unu dis chroo chroo bred weh kohn fahn hevn. ");
INSERT INTO bzj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kaa di bred fahn Gaad da di Wan weh kohn dong fahn hevn ahn gi di peepl dehn a di werl laif.” ");
INSERT INTO bzj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Soh dehn seh tu Jeezas, “Sa, gi wi dis bred fahn ya goh bak.” ");
INSERT INTO bzj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Den Jeezas tel dehn seh, “Da mee sayhn wan da di bred weh gi laif. Enibadi weh kohn tu mee wahn neva hongri agen, ahn enibadi weh bileev eena mee wahn neva geh tersti agen. ");
INSERT INTO bzj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bot Ah tel unu dat unu don si mi aredi, ahn unu stil noh bileev. ");
INSERT INTO bzj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Aala dehn wan weh di Faada gi mi wahn kohn tu mi; enibadi weh kohn tu mee, Ai wahn neva ton dehn weh. ");
INSERT INTO bzj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kaa Ai neva kohn dong fahn hevn fi du weh Ai waahn, bot Ai kohn fi du weh di Wan weh sen mi waahn. ");
INSERT INTO bzj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ahn dis da weh di Wan weh sen mi waahn: Ih noh waahn Ah laas non a dehn wan weh hihn gi mi, bot ih waahn Ah rayz dehn op pahn di laas Day. ");
INSERT INTO bzj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aala dehn wan weh si di Son ahn bileev eena ahn wahn liv wid Gaad fareva; an Ai wahn rayz dehn op fahn di ded pahn Jojment Day. Dat da weh mi Faada waahn.” ");
INSERT INTO bzj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Afta dat di Jooish leeda dehn staat tu grombl op monks dehnself bowt Jeezas kaa ih mi seh, “Ai da di bred weh kohn dong fahn hevn.” ");
INSERT INTO bzj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Dehn mi-di seh, “Dis da noh Jeezas, Joazef son? Wee noa fi hihn ma ahn pa. Soh da how kom hihn di seh, ‘Ai kohn dong fahn hevn’?” ");
INSERT INTO bzj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Bot Jeezas ansa dehn seh, “Stap di grombl op monks unuself. ");
INSERT INTO bzj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nobadi kyaahn kohn tu mee, eksep di Faada weh sen mi jraa dehn mek dehn kohn; ahn den Ai wahn rayz dehn op fahn di ded pahn Jojment Day. ");
INSERT INTO bzj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Laik weh di prafit dehn mi seh eena di Skripcha, ‘Gaad ihself wahn teech aala dehn.’ Enibadi weh lisn tu di Faada ahn laan fahn ahn wahn kohn tu mee. ");
INSERT INTO bzj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Dat noh meen dat enibadi don si di Faada, yu noh. Nobadi noh si di Faada yet eksep di Wan weh kohn fahn Gaad; oanli hihn don si ahn. ");
INSERT INTO bzj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Ah di tel unu di chroot, enibadi weh bileev eena mee don ga di laif aredi weh wahn neva en. ");
INSERT INTO bzj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Da mee da di bred weh gi laif! ");
INSERT INTO bzj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Fi unu ansesta dehn mi eet di mana eena di dezert ahn dehn mi stil ded. ");
INSERT INTO bzj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bot enibadi weh eet dis bred weh kohn dong fahn hevn noh wahn ded. ");
INSERT INTO bzj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ai da da bred weh kohn dong fahn hevn weh gi laif. Enibadi weh eet aafa dis bred wahn liv fareva; dis bred da fi mee flesh weh Ai wahn gi fi mek di peepl dehn a dis werl ga reel laif.” ");
INSERT INTO bzj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Di Jooish leeda dehn staat tu aagyu op monks dehnself ahn seh, “Da how dis man wahn gi wee fi hihn flesh fi eet?” ");
INSERT INTO bzj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Soh Jeezas tel dehn seh, “Ah di tel unu di chroot, unu mos eet di Son a Man flesh ahn jrink ih blod; oanli soh unu wahn ga reel laif eena unu. ");
INSERT INTO bzj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aala dehn wan weh eet mai flesh ahn jrink mai blod don ga di laif weh wahn neva en, an Ai wahn rayz dehn bak op pahn Jojment Day; ");
INSERT INTO bzj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","kaa mai flesh da reel food, ahn mai blod da reel jrink. ");
INSERT INTO bzj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Dehn wan weh eet mai flesh ahn jrink mai blod liv eena mee, an Ai liv eena dehn. ");
INSERT INTO bzj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Di Faada weh gi laif sen mee an Ai di liv sayka hihn. Sayhn way, enibadi weh eet mee wahn liv sayka mee. ");
INSERT INTO bzj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ai da noh laik da bred weh unu ansesta dehn mi eet, kaa dehn eet it ahn dehn stil ded. Bot Ai da di bred weh kohn dong fahn hevn, ahn enibadi weh eet dis bred wahn liv fareva.” ");
INSERT INTO bzj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jeezas seh aala dehnya ting wen ih mi-di teech eena di sinagag da Kapernyam. ");
INSERT INTO bzj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Wen Jeezas falowa dehn yehr weh aal ih seh, lata dehn seh, “Hmm, dehndeh da sohn haad teechin fi tek. Da hoo ku aksep dehndeh?” ");
INSERT INTO bzj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bot Jeezas mi kanchos a weh dehn mi-di komplayn bowt, soh ih aks dehn seh, “Weh Ah seh ofen unu noh? ");
INSERT INTO bzj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Den sopoaz unu kuda mi si di Son a Man di goh bak op da di plays weh ih kohn fram den? ");
INSERT INTO bzj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Da di Spirit a Gaad gi reel laif weh neva en; di badi noh wot notn. Di werd dehn weh kom owta mai mowt da fahn Gaad Spirit, soh dehndeh ga laif! ");
INSERT INTO bzj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bot dehn ga sohn monks unu weh noh bileev.” Jeezas seh dat kaa hihn mi don noa fahn lang taim aala dehn wan weh neva mi wahn bileev, ahn hihn mi don noa tu, hoo mi wahn sel ahn owt. ");
INSERT INTO bzj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Soh Jeezas seh, “Dats wai Ai mi tel unu dat nobadi kyaahn kohn tu mee eksep di Faada mek dehn kohn.” ");
INSERT INTO bzj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Fahn deh goh bak, lata Jeezas falowaz ton bak ahn stap goh bowt wid ahn. ");
INSERT INTO bzj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Soh Jeezas aks di twelv disaipl dehn, “Unu waahn goh tu?” ");
INSERT INTO bzj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saiman Peeta ansa ahn seh, “Laad, da hoo els wi gwehn tu? Da yoo ga di werd dehn weh gi laif weh wahn neva en. ");
INSERT INTO bzj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wee bileev eena yoo, ahn wi noa fi shoar dat yoo da di Hoali Wan fahn Gaad.” ");
INSERT INTO bzj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jeezas ansa dehn seh, “Da mee miself mi pik di twelv a unu, ahn wan a unu da devl!” ");
INSERT INTO bzj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ih mi-di taak bowt Joodas weh da-mi Saiman Iskariyat son. Hihn stil mi wahn sel owt Jeezas eevn doa ih da-mi wan a di twelv apasl dehn. ");
INSERT INTO bzj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Afta dat Jeezas gaahn bowt Gyalilee. Ih neva waahn goh da Judeeya dischrik, kaa di Jooish leeda dehn mi-di luk fi wahn chaans fi kil ahn. ");
INSERT INTO bzj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Now da mi nayli taim fi di Jooish selibrayshan weh nayhn di Boot Festival. ");
INSERT INTO bzj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Wel, Jeezas breda dehn tel ahn seh, “Lef ya ahn goh da Judeeya, soh dat yu falowa dehn ku si aala di mirakl dehn weh yu di du; ");
INSERT INTO bzj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","kaa nobadi du ting eena seekrit if dehn waahn peepl noa da hoo dehn. Laik how yu di du aala dehn ting deh, den mek evribadi si weh yu di du.” ");
INSERT INTO bzj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yu si, noh eevn Jeezas oan breda dehn mi bileev eena ahn. ");
INSERT INTO bzj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jeezas ansa dehn seh, “Noh, da noh taim fi Ai goh yet, bot aal laik unu, unu ku goh enitaim ahn ih noh wahn mek no difrens. ");
INSERT INTO bzj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Di peepl a dis werl noh ga no reezn fi hayt unu, bot dehn hayt mee kaa Ai kohn rait owt ahn tel dehn bowt aala di rang ting dehn weh dehn di du. ");
INSERT INTO bzj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Unu goh hed ahn goh da di selibrayshan. Ai noh gwehn da dis wan kaa mi taim noh kohn yet.” ");
INSERT INTO bzj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Wen ih don seh dat, ih stay da Gyalilee. ");
INSERT INTO bzj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bot afta ih breda dehn don gaahn da di selibrayshan, Jeezas stil gaan aftawodz, bot ih gaahn seekrit laik, mek nobadi noh si ahn. ");
INSERT INTO bzj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Di Jooish leeda dehn mi-di luk fi si ahn da di selibrayshan ahn dehn mi-di aks, “Da weh da man deh?” ");
INSERT INTO bzj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lata peepl monks di krowd mi-di taak bowt ahn. Dehn seh, “Ih da wahn gud man.” Sohn neks wan seh, “Noh, aal hihn di du da fool op di peepl dehn.” ");
INSERT INTO bzj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bot nobadi neva waahn taak tu haad bowt ahn kaa dehn mi frayd fi di Jooish leeda dehn. ");
INSERT INTO bzj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Di selibrayshan mi deh bowt haaf way wen Jeezas gaan op da di templ ahn staat tu teech. ");
INSERT INTO bzj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Di Jooish leeda dehn kudn bileev dehn ayz wen dehn yehr ahn, ahn dehn seh, “Da how kom hihn noa soh moch ahn hihn neva gaahn da nobadi fi mek dehn teech ahn?” ");
INSERT INTO bzj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Den Jeezas ansa dehn seh, “Di ting dehn weh Ai di teech da noh fahn mee, bot dehn kohn fahn di Wan weh sen mee. ");
INSERT INTO bzj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","If unu reeli waahn obay Gaad, den unu wahn noa weda er nat di ting dehn weh Ai di teech da fahn Gaad er da fi mee oan ting. ");
INSERT INTO bzj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","If Ai mi waahn aana maiself, den Ah wuda taak fi mai oanself. Bot Ai waahn aana di Wan weh sen mee. Dat da wai Ai tel di chroot; Ai noh tel lai. ");
INSERT INTO bzj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Da hoo mi gi unu di Laa? Da noh Moaziz? Bot non a unu noh du weh ih seh. Soh da wai unu di luk fi wahn chaans fi kil mee den?” ");
INSERT INTO bzj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Di krowd ansa Jeezas seh, “Yoo mosi ga deeman! Hoo di chrai kil yoo?” ");
INSERT INTO bzj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","24","Jeezas ansa dehn seh, “Ah du wan mirakl pahn di Sabat ahn unu di goh aaf! Bot unu werk pahn di Sabat tu wen unu kohn serkomsaiz unu bwai baybi laik weh Moaziz Laa seh. (Akchwali da laa da neva fahn Moaziz, bot ih goh way bak da unu ansesta dehn bifoa hihn.) Wel, wen di day fi serkomsaiz faal pahn di Sabat, unu stil goh hed ahn serkomsaiz unu baybi jos soh dat unu ku kip di Laa weh Moaziz gi. Soh wai unu wahn beks wid mee kaa Ai heel wahn man hoal badi pahn di Sabat? Noh joj nobadi bai how ting luk, bot joj fyaa-wan!” ");
INSERT INTO bzj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Now som a di peepl dehn fahn Jeroosalem mi-di seh, “Bot dis da noh di man weh dehn di chrai kil? ");
INSERT INTO bzj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ahn luk how ih deh ya di taak owt eena poblik, ahn nobadi noh di tel ahn notn! Unu tink dat di leeda dehn don noa dat dis da di Krais fi chroo? ");
INSERT INTO bzj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bot stil, wee noa weh dis man kohn fram; wen di Krais kohn, nobadi noh wahn noa weh ih kohn fram.” ");
INSERT INTO bzj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Den Jeezas hala owt wail ih mi-di teech da di templ, “Unu oanli tink seh unu noa mee, ahn weh Ai kohn fram. Ai noh kohn pahn mai oan, yu noh, bot unu ku chros di Wan weh sen mi. Unu noh noa hihn, bot ");
INSERT INTO bzj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ai noa ahn, kaa Ai da fahn hihn, ahn da hihn sen mee.” ");
INSERT INTO bzj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Wen Jeezas seh dat, som a dehn chrai ares ahn, bot nobadi neva lay wahn finga pan ahn kaa ih taim neva kohn yet. ");
INSERT INTO bzj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Stil, wahn lata peepl eena di krowd mi bileev eena ahn, ahn dehn mi-di seh, “Wen di Krais kohn, yu tink ih wahn du moa mirakl dahn weh dis man don du?” ");
INSERT INTO bzj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Wen di Farisee dehn yehr weh di krowd mi-di mombl seh bowt Jeezas, dehn ahn di cheef prees dehn sen di templ gyaad dehn fi ares ahn. ");
INSERT INTO bzj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Den Jeezas seh, “Ah oanli wahn deh wid unu wahn lee wail langa, den Ah gwehn bak da di Wan weh sen mi. ");
INSERT INTO bzj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Unu wahn luk fi mi, bot unu noh wahn fain mi; ahn wehpaa Ai gwehn, unu kyaahn kohn.” ");
INSERT INTO bzj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Di Jooish leeda dehn seh tu wan anada, “Da weh dis man meen fi goh, soh dat wee wahn kyaahn fain ahn? Yu meen fi seh, ih gwehn tu dehn Jooz weh liv monks di Greek peepl dehn, ahn teech di Greek dehn? ");
INSERT INTO bzj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Da weh hihn meen wen ih seh, ‘Unu wahn luk fi mi, bot unu wahn kyaahn fain mi,’ ahn ‘Wehpaa Ai gwehn, unu kyaahn kohn’?” ");
INSERT INTO bzj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pahn di laas day a di selibrayshan weh da-mi di bigis day, Jeezas stan op ahn ih hala owt, “Enibadi weh tersti, mek dehn kohn tu mi ahn jrink. ");
INSERT INTO bzj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","If dehn bileev eena mee, lata waata weh gi laif wahn poar owt laik wahn riva fahn deep dong eensaida dehn, jos laik weh di Skripcha seh.” ");
INSERT INTO bzj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Wen Jeezas seh dat, ih mi-di taak bowt Gaad Hoali Spirit weh dehn wan weh bileev eena hihn mi wahn geh. Yu si, op tu den, nobadi neva ga Gaad Hoali Spirit di liv eena dehn, kaa Gaad neva rayz op Jeezas eena aala ih gloari yet. ");
INSERT INTO bzj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wen dehn yehr aala dehn ting deh, di krowd seh, “Dis da di Prafit fi chroo.” ");
INSERT INTO bzj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sohn ada wan seh, “Dis da di Krais.” Bot som a dehn aks, “Di Krais ku kohn fahn Gyalilee? ");
INSERT INTO bzj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Di Skripcha neva seh dat di Krais kohn fahn King Dayvid famili lain? Ahn ih neva sopoas tu kohn fahn Betlihem, weh da-mi Dayvid hoamtong?” ");
INSERT INTO bzj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Soh divizhan mi deh monks di peepl dehn sayka Jeezas. ");
INSERT INTO bzj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Som a dehn mi waahn ares ahn, bot nobadi neva toch ahn. ");
INSERT INTO bzj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wen di templ gyaad dehn gaahn bak, di cheef prees ahn di Farisee dehn aks dehn seh, “Wai unu neva ares Jeezas?” ");
INSERT INTO bzj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Di gyaad dehn ansa dehn seh, “Wee neva yehr nobadi taak laik dis man yet!” ");
INSERT INTO bzj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Den di Farisee dehn ansa dehn seh, “Weh hapm, ih ga unu fool tu? ");
INSERT INTO bzj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Unu si eni a di leeda dehn er di Farisee dehn di bileev eena hihn? ");
INSERT INTO bzj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bot dis krowd weh noh eevn noa Moaziz Laa don kandem aredi eniway.” ");
INSERT INTO bzj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Wan a di Farisee dehn weh mi dehdeh da-mi Nikodeemos. Hihn mi gaahn taak tu Jeezas wahn taim. Ih aks dehn seh, “Fi wee Laa noh mek wi kandem peepl bifoa wi yehr weh dehn ga fi seh, rait? Soh wi kyaahn joj dehn bifoa wi noa weh dehn du.” ");
INSERT INTO bzj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Dehn tel ahn seh, “Soh wat, yoo da fahn Gyalilee tu? Yoo chek di Skripcha, ahn yu wahn si dat no prafit kyaahn kohn fahn Gyalilee.” ");
INSERT INTO bzj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Afta dat evribadi gaahn hoahn. ");
INSERT INTO bzj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jeezas gaahn da di hil weh nayhn di Mongt a Alivz, ");
INSERT INTO bzj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","bot soon di neks maanin ih gaahn bak da di templ. Aala di peepl dehn gyada rong ahn, ahn ih sidong ahn staat tu teech dehn. ");
INSERT INTO bzj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","Dehn wan weh teech di Jooish Laa ahn di Farisee dehn bring een wahn uman weh dehn kech eena di ak di cheet pahn ih hozban. Dehn put ahn fi stan op rait fronta evribadi ahn seh tu Jeezas, “Teecha, dehn kech dis uman eena di ak di cheet pahn ih hozban. ");
INSERT INTO bzj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Now Moaziz Laa seh dat wi fi stoan uman laik dis tu det. Now da weh yoo ga fi seh tu dat?” ");
INSERT INTO bzj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Dehn aks Jeezas dat jos fi pik ih mowt fi si if ih mi wahn seh eniting rang weh dehn kuda ares ahn fa. Wel, Jeezas ben dong ahn staat tu rait pahn di grong wid ih finga. ");
INSERT INTO bzj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Wen dehn stodi mi-di kweschan ahn, ih schraytn op ahn tel dehn seh, “Mek eni wan a unu weh noh ga no sin chroa di fos stoan aata dis laydi.” ");
INSERT INTO bzj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Den ih ben dong agen ahn staat tu rait pahn di grong. ");
INSERT INTO bzj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Wen dehn yehr dat, dehn staat tu lef wan bai wan, fahn di oaldis wan goh dong; afta dat oanli Jeezas wan mi lef deh wid di laydi di stan op fronta ahn. ");
INSERT INTO bzj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jeezas stan op ahn aks ahn seh, “Mis, da weh evribadi deh? Nobadi noh kandem yu?” ");
INSERT INTO bzj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Di laydi seh, “Nobadi, Sa.” Ahn Jeezas tel ahn seh, “Wel, Ai noh kandem yu needa. Goh hoahn, ahn fahn ya goh bak, noh sin nohmoh.” ");
INSERT INTO bzj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jeezas staat tu taak tu di Farisee dehn agen ahn seh, “Ai da di Wan weh gi di peepl dehn eena di werl lait. Enibadi weh fala mi wahn ga di lait weh shoa dehn how fi liv, ahn den dehn wahn neva deh eena daak.” ");
INSERT INTO bzj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Di Farisee dehn tel ahn seh, “Da yoo di taak fi fi yoo oanself, soh weh yoo seh noh wot notn.” ");
INSERT INTO bzj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jeezas ansa dehn seh, “Eevn if Ai di taak fi mai oanself, weh Ai seh da chroo kaa Ai noa wehpaa Ai kohn fram, an Ai noa wehpaa Ai gwehn. Bot unu noh noa wehpaa Ai kohn fram er wehpaa Ai gwehn. ");
INSERT INTO bzj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Unu joj peepl jos bai weh unu ku si az hyooman. Mee, Ai noh joj nobadi. ");
INSERT INTO bzj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ahn eevn if Ai joj, mai jojment da di chroo kaina jojment kaa da noh oanli mee wan joj, bot da mee ahn di Faada weh sen mi. ");
INSERT INTO bzj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Fi unu Laa seh dat if too witnis goh da koat di seh di sayhn ting, den weh dehn di seh da chroo. ");
INSERT INTO bzj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ai taak fi mai oanself, ahn di Faada weh sen mi taak fi mee tu.” ");
INSERT INTO bzj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Den di Farisee dehn aks ahn seh, “Wehpaa fi yoo Faada deh?” Jeezas ansa dehn seh, “Unu noh noa mee ner mi Faada. If unu mi noa mee, unu wuda noa mi Faada tu.” ");
INSERT INTO bzj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jeezas seh dehn ting wen ih mi-di teech eena di room da di templ weh di kalekshan baks kip. Bot nobadi neva ares ahn kaa ih taim neva kohn yet. ");
INSERT INTO bzj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jeezas tel dehn agen, “Ai gwehn weh, ahn unu wahn luk fi mi, bot unu wahn ded ahn unu sin stil noh wahn geh fagiv. Unu kyaahn goh wehpaa Ai gwehn.” ");
INSERT INTO bzj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Den di Jooish leeda dehn seh, “Weh hapm? Ih wahn kil ihself er sohnting? Da dat ih meen wen ih seh, ‘Unu kyaahn goh wehpaa Ai gwehn?’” ");
INSERT INTO bzj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jeezas tel dehn seh, “Unu da fahn dong ya; Ai da fahn op da hevn. Unu da fahn dis werl; Ai da noh fahn dis werl. ");
INSERT INTO bzj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ahn if unu noh bileev dat Ai da hoo Ai seh da mee, den unu wahn ded, ahn unu sin stil noh wahn geh fagiv.” ");
INSERT INTO bzj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","26","Den dehn seh tu Jeezas, “Da hoo yoo?” Jeezas tel dehn seh, “Ai da hoo Ah di seh fahn di staat. Ah ga lata ting fi seh bowt unu, ahn lata ting fi kandem unu fa. Bot di Wan weh sen mi noh tel lai, an Ai di tel di hoal werl weh Ai yehr fahn hihn.” ");
INSERT INTO bzj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Dehn neva noa seh dat Jeezas mi-di taak tu dehn bowt di Faada. ");
INSERT INTO bzj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Soh Jeezas seh, “Wen unu lif op di Son a Man pahn di kraas, den unu wahn riyalaiz dat Ai da hoo Ai seh da mee, ahn dat Ai noh du notn pahn mi oan, bot Ai oanli seh weh di Faada mi teech mi. ");
INSERT INTO bzj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Di wan weh sen mee deh wid mi. Hihn noh lef mi bai miself, kaa Ai aalwayz du di ting dehn weh hihn laik.” ");
INSERT INTO bzj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wail Jeezas mi-di seh dehn ting deh, lata peepl bileev eena ahn. ");
INSERT INTO bzj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Den Jeezas tel di Jooz dehn weh mi bileev eena ahn, “Unu da mi chroo chroo falowa dehn if unu kip aan obay aal weh Ah tel unu. ");
INSERT INTO bzj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Unu wahn noa di chroot bowt Gaad, ahn da sayhn chroot wahn mek unu free fi chroo.” ");
INSERT INTO bzj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Di peepl dehn ansa Jeezas seh, “Wee kohn fahn Aybraham famili lain, ahn wee da neva nobadi slayv yet. Soh da weh yoo meen wen yu seh, ‘Unu wahn bee free?’” ");
INSERT INTO bzj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jeezas ansa dehn seh, “Ah di tel unu di chroot, if enibadi stay di sin, den sin ga dehn laik slayv. ");
INSERT INTO bzj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wahn slayv da noh wahn reel memba a di famili weh ih werk fa; bot wahn son wahn aalwayz bilangz tu fi hihn famili. ");
INSERT INTO bzj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Soh den, if Gaad Son mek unu geh free fahn sin, den unu wahn free fi chroo. ");
INSERT INTO bzj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ai noa dat unu kohn fahn Aybraham famili lain; stil, unu di luk fi wahn chaans fi kil mi kaa unu rifyooz fi aksep di ting dehn weh Ah teech unu. ");
INSERT INTO bzj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ai di tel unu di ting dehn weh mai Faada mi shoa mi wen Ai mi deh wid hihn; bot unu du weh fi unu pa tel unu fi du.” ");
INSERT INTO bzj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","40","Dehn ansa Jeezas seh, “Aybraham da fi wee pa.” Jeezas tel dehn seh, “If unu da-mi Aybraham pikni dehn, den unu wuda di du weh Aybraham mi du, bot insteda dat, unu di chrai kil mee, weh di tel unu di chroot weh Ah yehr fahn Gaad. Aybraham neva du notn laik dat. ");
INSERT INTO bzj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Unu di du egzakli weh fi unu pa du fi chroo.” Dehn seh tu Jeezas, “Wee da noh no owtsaid pikni; wee ga wan Faada, ahn dat da Gaad ihself.” ");
INSERT INTO bzj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jeezas tel dehn seh, “If Gaad da-mi reeli fi unu Faada, den unu wuda lov mee kaa Ai kohn fahn Gaad, ahn now Ai deh ya. Ai neva kohn pahn mi oan, bot da hihn sen mi. ");
INSERT INTO bzj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Wai unu noh andastan weh Ah di seh? Da kaa unu rifyooz fi aksep di ting dehn weh Ah di teech unu. ");
INSERT INTO bzj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Unu da fahn fi unu pa weh da di devl, ahn unu waahn du weh hihn seh. Hihn da-mi wahn merdara fahn di staat, ahn hihn neva yet mi waahn ga notn fi du wid di chroot, kaa nat wan pees a chroot noh deh eena hihn. Wen hihn di tel lai, ih di du it kaa da ih naycha fi tel lai, ahn hihn da di pa a aala di lai dehn. ");
INSERT INTO bzj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Bot unu si, now dat Ai di tel unu di chroot, unu noh bileev mi. ");
INSERT INTO bzj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wich wan a unu ku paint finga pahn mee ahn akyooz mi seh Ai sin? Laik how Ai di tel di chroot, wai unu noh bileev mi? ");
INSERT INTO bzj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Enibadi weh da Gaad pikni lisn tu weh Gaad seh. Di reezn wai unu noh yehr weh Gaad seh, da bikaa unu da noh fi hihn pikni.” ");
INSERT INTO bzj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Di Jooish leeda dehn ansa Jeezas seh, “Yoo noh tink seh wee rait wen wee seh dat yoo da fahn Samayrya ahn yoo ga deeman?” ");
INSERT INTO bzj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jeezas ansa dehn seh, “Ai noh ga no deeman, bot Ai aana mai Faada, ahn unu noh di shoa no rispek fi mee. ");
INSERT INTO bzj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Stil, Ah noh waahn aana fi miself, bot da Gaad waahn aana mee, ahn da hihn da di joj. ");
INSERT INTO bzj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ah di tel unu di chroot, enibadi weh du weh Ah tel dehn wahn neva ded.” ");
INSERT INTO bzj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Wen dehn yehr dat, dehn tel Jeezas seh, “Now wi noa fi chroo dat yoo ga deeman! Now Aybraham don ded, ahn di prafit dehn ded tu, ahn stil yoo seh, ‘Enibadi weh du weh Ai tel dehn wahn neva ded’? ");
INSERT INTO bzj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yoo grayta dan fi wee ansesta Aybraham den? Wel, hihn ahn di prafit dehn ded. Soh da hoo yoo tink yoo soh?” ");
INSERT INTO bzj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","55","Jeezas ansa dehn seh, “If Ai prayz op mai oanself, dat noh meen notn. Da mai Faada da di Wan weh prayz mee. Da hihn sayhn wan weh unu seh da unu Gaad, eevn doa unu noh reeli noa ahn. Bot Ai noa hihn. If Ai wuda seh dat Ai noh noa ahn, den Ai wuda laiyad jos laik unu. Bot unu si, Ai doo noa hihn, an Ai du weh hihn seh. ");
INSERT INTO bzj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Fi unu ansesta Aybraham mi oanli glad wen ih si dat di taim mi kohn fi mek Ai kohn.” ");
INSERT INTO bzj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Den di Jooz dehn seh tu Jeezas, “Yoo noh eevn fifti yet. How yoo ku seh yoo si Aybraham?” ");
INSERT INTO bzj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jeezas tel dehn seh, “Ah di tel unu di chroot, bifoa Aybraham mi eevn baan, Ai deh!” ");
INSERT INTO bzj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Soh dehn pik op sohn stoan fi stoan ahn, bot Jeezas slip weh fahn dehn widowt dehn eevn noa, ahn ih lef di templ. ");
INSERT INTO bzj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Az Jeezas mi-di waak lang, ih si wahn man weh mi baan blain. ");
INSERT INTO bzj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ih disaipl dehn aks ahn seh, “Teecha, da wai dis man baan blain? Da kaa hihn sin, er da kaa ih ma ahn ih pa sin?” ");
INSERT INTO bzj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jeezas ansa dehn seh, “Fi hihn blainis noh ga notn fi du wid fi hihn sin er ih ma ahn ih pa sin. Bot hihn mi baan blain soh dat Gaad ku shoa ih powa chroo weh ih wahn du fi dis man. ");
INSERT INTO bzj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Wi hafu du weh di Wan weh sen mi waahn wi du wail da stil day. Nait di kohn, ahn nobadi kyaahn du notn wen nait kohn. ");
INSERT INTO bzj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Az lang az Ai deh ya eena dis werl, Ai da di Lait weh shoa peepl how fi liv.” ");
INSERT INTO bzj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","7","Wen Jeezas don seh dis, ih spit pahn di grong ahn den ih miks op di spit ahn di dert ahn mek lee mod. Den ih spred di mod oava di man aiy dehn, ahn ih tel ahn seh, “Goh goh wash aaf yu aiy dehn eena di pool weh nayhn Sailoam.” (Sailoam meen “di Wan weh dehn sen.”) Soh di man gaahn gaahn wash ih aiy dehn, ahn den ih kuda mi si. Afta dat, ih gaahn bak hoahn. ");
INSERT INTO bzj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Di man nayba dehn ahn aala dehn wan weh doz noa ahn az wahn bega staat tu aks, “Dis da noh di sayhn man weh doz sidong di bayg?” ");
INSERT INTO bzj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Som a dehn mi-di seh, “Da hihn.” Ahn sohn neks wan seh, “No, da noh hihn, da sohnbadi weh oanli luk laik hihn.” Bot di man ihself seh, “Da mee da di sayhn man.” ");
INSERT INTO bzj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bot di peepl dehn aks ahn agen, “Den da how yoo ku si now den?” ");
INSERT INTO bzj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Di man ansa dehn seh, “Da man weh nayhn Jeezas miks op sohn mod ahn spred it oava mi aiy dehn ahn tel mi, ‘Goh da di pool weh nayhn Sailoam ahn wash aaf yu aiy dehn.’ Den Ah gaahn gaahn wash mi aiy dehn ahn den Ah kuda mi si.” ");
INSERT INTO bzj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Den dehn aks di man, “Da weh hihn deh?” Di man seh, “Ai noh noa.” ");
INSERT INTO bzj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dehn kehr di man weh mi blain fronta di Farisee dehn. ");
INSERT INTO bzj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Now di day wen Jeezas miks di mod ahn put it pahn di man aiy dehn da-mi di Sabat. ");
INSERT INTO bzj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Den di Farisee dehn staat tu aks di man aal oava agen da how ih mi geh fi si. Di man tel dehn seh, “Di man put mod pahn mi aiy dehn. Den Ah wash dehn aaf, ahn now Ah ku si.” ");
INSERT INTO bzj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Som a di Farisee dehn seh, “Dis Jeezas hihn da noh fahn Gaad kaa hihn noh kip di Sabat.” Bot sohn neks wan dehn seh, “Bot how sohnbadi weh da wahn sina wahn ku du mirakl laik dehnya?” Ahn soh dehn mi ga divizhan monks dehnself. ");
INSERT INTO bzj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Soh dehn aks di man agen, “Wel, weh yoo ga fi seh bowt di man weh heel yu, laik how da fi yoo aiy dehn ih heel?” Di man seh, “Hihn da wahn prafit.” ");
INSERT INTO bzj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","Di Jooish leeda dehn stil neva bileev seh hihn da-mi di man weh mi baan blain ahn now kuda mi si, soh dehn kaal een ih ma ahn ih pa ahn aks dehn seh, “Dis da fi unu son weh mi baan blain? Ahn how kom ih ku si now?” ");
INSERT INTO bzj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Di man ma ahn pa ansa dehn seh, “Wee noa seh dat dis da fi wee son, ahn dat ih mi baan blain. ");
INSERT INTO bzj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bot wee noh noa da how kom hihn ku si now, er da hoo mek ih ku si. Aks hihn noh? Hihn oal nof fi taak fi fi hihnself.” ");
INSERT INTO bzj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Di man ma ahn ih pa mi seh dat kaa dehn mi frayd fi di Jooish leeda dehn. Yu si, di leeda dehn mi don seh dat enibadi weh seh dat Jeezas da-mi di Krais mi wahn geh kik owta di sinagag. ");
INSERT INTO bzj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Dats wai di man ma ahn pa seh, “Aks hihn noh? Ih oal nof.” ");
INSERT INTO bzj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Soh di Jooish leeda dehn kaal bak di man weh mi blain wahn sekant taim. Dehn tel ahn seh, “Sway fronta Gaad ahn tel di chroot. Dis man weh heel yu da wahn sina, noh chroo?” ");
INSERT INTO bzj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Di man ansa seh, “Ai noh noa weda ih da sina er nat! Di oanli ting Ai noa, Ai mi blain, ahn now Ah ku si.” ");
INSERT INTO bzj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dehn tel ahn seh, “Weh ih du tu yu? Da how ih mek yu si?” ");
INSERT INTO bzj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Di man ansa dehn seh, “Ah don tel unu aredi ahn unu neva waahn lisn. Soh wai unu waahn yehr it agen? Unu waahn bee wan a fi hihn falowaz tu den?” ");
INSERT INTO bzj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Di Jooish leeda dehn staat tu insolt di man. Dehn seh, “Yoo da wan a fi hihn falowa dehn, bot wee fala Moaziz. ");
INSERT INTO bzj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wee noa dat Gaad mi taak tu Moaziz, bot az tu dis man hihn, wee noh noa weh hihn kohn fram.” ");
INSERT INTO bzj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Di man ansa dehn seh, “Yu noa, da wahn foni ting! Unu noh noa weh hihn kohn fram, bot yet hihn mek Ai ku si. ");
INSERT INTO bzj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wi noa dat Gaad noh lisn tu sinaz, bot ih lisn tu dehn wan weh wership ahn, ahn du weh ih seh. ");
INSERT INTO bzj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Fahn di taim di werl mek, nobadi neva yehr yet bowt enibadi di mek wahn persn weh baan blain ku si. ");
INSERT INTO bzj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","If dis man da neva fahn Gaad, hihn kudn du notn.” ");
INSERT INTO bzj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Dehn ansa ahn seh, “Yoo ful op a wikidnis fahn yu baan, ahn now yoo di chrai teech wee?” Ahn wid dat dehn pich ahn owt. ");
INSERT INTO bzj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jeezas yehr seh dehn mi pich owt di man owta di sinagag, ahn wen ih fain ahn, ih seh, “Yoo bileev eena di Son a Man?” ");
INSERT INTO bzj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Di man aks ahn seh, “Da hoo da di Son a Man, Sa? Tel mi soh dat Ah ku bileev eena ahn.” ");
INSERT INTO bzj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jeezas seh, “Yu don si ahn, ahn di Wan weh di taak tu yu, da hihn.” ");
INSERT INTO bzj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Di man seh, “Laad, Ah bileev.” Ahn ih staat tu wership Jeezas. ");
INSERT INTO bzj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jeezas seh, “Ai kom eena dis werl fi ekspoaz peepl sin. Ah kohn soh dat dehn wan weh blain ku si, ahn fi shoa dehn wan weh tink dehn ku si, dat dehn blain.” ");
INSERT INTO bzj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Som a di Farisee dehn weh mi deh kloas yehr weh Jeezas seh, ahn dehn seh tu ahn, “Yoo kyaahn di seh dat wee blain.” ");
INSERT INTO bzj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jeezas tel dehn seh, “If unu mi blain, den unu wudn gilti a no sin. Bot laik how unu seh, ‘Wee ku si,’ dat meen unu stil gilti a unu sin.” ");
INSERT INTO bzj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jeezas seh, “Ah di tel unu di chroot, enibadi weh noh kom eena di sheep pen chroo di gayt, bot chrai fi klaim een wahn neks way, da wahn teef weh di luk fi teef di sheep dehn. ");
INSERT INTO bzj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Di wan weh kom een chroo di gayt da di sheep dehn shepad. ");
INSERT INTO bzj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Di wan weh gyaad di gayt da di wan weh oapm di gayt fi di shepad, ahn di sheep dehn yehr di shepad vais. Hihn kaal fi hihn oan sheep dehn bai dehn naym ahn ih leed dehn owt. ");
INSERT INTO bzj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wen di shepad don bring owt aala di sheep dehn weh bilangz tu hihn, hihn waak heda dehn, ahn di sheep dehn fala hihn kaa dehn noa fi hihn vais. ");
INSERT INTO bzj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Dehn wuda neva fala wahn schraynja. Insteda dat, dehn wuda ron fahn ahn kaa dehn noh noa no schraynja vais.” ");
INSERT INTO bzj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jeezas mi-di taak tu dehn eena parabl bot dehn neva andastan weh ih mi-di tel dehn. ");
INSERT INTO bzj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Soh Jeezas tel dehn agen, “Ah di tel unu di chroot, Ai da di gayt weh di sheep dehn hafu paas chroo. ");
INSERT INTO bzj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Aala dehn wan weh kohn bifoa mee da teef weh di luk fi teef di sheep dehn, bot di sheep dehn neva lisn tu dehn. ");
INSERT INTO bzj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ai da di gayt. Enibadi weh kohn chroo mee wahn bee jos laik sheep, ahn dehn wahn sayf; dehn wahn ku goh een ahn owt ahn dehn wahn fain nais green graas. ");
INSERT INTO bzj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Di teef oanli kohn fi teef ahn kil ahn dischrai. Bot Ai kohn soh dat unu ku ga reel laif—wahn ful laif kyaahn don! ");
INSERT INTO bzj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ai da di gud Shepad weh gi ih laif fi di sheep dehn. ");
INSERT INTO bzj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Di wan weh dehn pay jos fi main di sheep dehn da noh laik di shepad, ahn hihn noh oan di sheep dehn needa. Hihn ku si di wulf di kohn ahn ih wahn lef di sheep dehn rait deh ahn ron lef dehn. Den di wulf wahn kohn ahn atak di sheep dehn ahn skyata dehn. ");
INSERT INTO bzj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Di wan weh dehn jos pay fi main di sheep dehn wahn ron lef dehn kaa hihn noh kay notn bowt di sheep dehn. ");
INSERT INTO bzj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ai da di gud Shepad an Ah gi mi laif fi di sheep dehn. Ai noa aal hoo da mai sheep dehn, ahn dehn noa mee, jos laik how di Faada noa mee an Ai noa hihn. ");
INSERT INTO bzj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ah ga sohn neks sheep weh noh bilangz tu dis flak a sheep ya, an Ah hafu bring dehn een tu. Dehn wahn lisn tu mi vais ahn den aala dehn wahn bee wan flak wid wan shepad. ");
INSERT INTO bzj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Mai Faada lov mee kaa Ai giv op mi laif soh dat Ah ku tek it op bak agen. ");
INSERT INTO bzj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Da noh nobadi tek weh mai laif fahn mee, bot da mee giv it op miself. Ai ga di powa fi giv op mai laif, an Ah ga di powa fi tek it bak agen. Dat da weh mai Faada koman mi fi du.” ");
INSERT INTO bzj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sayka weh Jeezas seh, di Jooish leeda dehn mi ga divizhan monks dehnself agen. ");
INSERT INTO bzj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Lata dehn mi-di seh, “Hihn ga deeman ahn hihn krayzi. Da weh unu di lisn tu hihn fa?” ");
INSERT INTO bzj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sohn neks wan dehn mi-di seh, “Hihn noh taak laik nobadi weh ga deeman. Deeman kyaahn mek wahn blain man si.” ");
INSERT INTO bzj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Da mi winta taim da Jeroosalem, ahn da mi di taim wen dehn selibrayt wen di templ mi dedikayt. ");
INSERT INTO bzj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jeezas mi-di waak eena di ayrya a di templ kraas wahn varanda weh nayhn Salaman Poach. ");
INSERT INTO bzj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wel, di Jooish leeda dehn gyada rong ahn, ahn tel ahn seh, “Da how lang yu wahn ga wi eena sospens? If yoo da di Krais, kom owt playn-wan ahn tel wi.” ");
INSERT INTO bzj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jeezas tel dehn seh, “Ah don tel unu, bot unu noh bileev. Di mirakl dehn weh Ai du eena mai Faada naym dehdeh fi proov da hoo mee. ");
INSERT INTO bzj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bot unu noh bileev kaa unu da noh mai sheep. ");
INSERT INTO bzj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mai sheep dehn yehr mai vais. Ai noa dehn, ahn dehn fala mee. ");
INSERT INTO bzj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ai gi dehn laif weh wahn laas fareva, ahn dehn wahn neva ded. Nobadi noh wahn grab dehn owta mai han. ");
INSERT INTO bzj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mai Faada weh gi mee dehn sheep grayta dahn enibadi els, ahn nobadi noh wahn grab dehn owta fi hihn han needa. ");
INSERT INTO bzj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mee ahn di Faada da wan.” ");
INSERT INTO bzj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Di Jooish leeda dehn pik op stoan fi stoan Jeezas agen, ");
INSERT INTO bzj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","bot Jeezas tel dehn seh, “Ah shoa unu lata gud tingz weh mi Faada gi mi di powa fi du. Da wich wan a dehndeh unu waahn stoan mi fa?” ");
INSERT INTO bzj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dehn ansa ahn seh, “Da noh fi non a dehn gud ting deh wi di stoan yu fa, bot da kaa yu di insolt Gaad. Yoo da oanli hyooman ahn yu di seh dat yoo da Gaad!” ");
INSERT INTO bzj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jeezas ansa dehn seh, “Ih rait dong eena unu oan Skripcha dat Gaad seh, ‘Unu da gaad,’ rait? ");
INSERT INTO bzj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Wi kyaahn chaynj weh di Skripcha seh, ahn Gaad seh dat dehn peepl dehn da gaad—dehn sayhn peepl dehn weh hihn gi ih mesij tu. ");
INSERT INTO bzj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Da Gaad ihself pik mi ahn sen mi eena dis werl, soh wai unu seh dat Ai insolt Gaad wen Ah seh dat Ai da fi hihn Son? ");
INSERT INTO bzj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","If Ai noh di du weh mi Faada waahn, noh bileev mi den. ");
INSERT INTO bzj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bot If Ah di du di ting dehn weh mi Faada waahn, eevn if unu noh bileev mee, den bileev di mirakl dehn weh unu si, soh dat unu ku noa ahn andastan dat mee ahn mi Faada da wan.” ");
INSERT INTO bzj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Den dehn chrai fi ares Jeezas agen, bot ih slip rait owta dehn han. ");
INSERT INTO bzj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jeezas gaahn kraas Jaadn Riva agen, tu di plays wehpaa Jan di Baptis mi-di baptaiz peepl fos. Ih stay deh ");
INSERT INTO bzj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ahn lata peepl kohn deh tu ahn, ahn dehn mi-di seh, “Jan neva du no mirakl, bot evriting ih mi seh bowt dis man ya da-mi chroo.” ");
INSERT INTO bzj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ahn lata peepl bileev eena Jeezas deh. ");
INSERT INTO bzj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Now wahn man nayhn Lazaros mi sik. Hihn ahn ih too sista dehn weh nayhn Mayri ahn Marta mi liv da Betani. ");
INSERT INTO bzj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Dat da-mi di sayhn Mayri weh mi poar perfyoom pahn di Laad ahn waip ih fut wid ih hyaa. Wel, da-mi fi shee breda mi sik. ");
INSERT INTO bzj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Soh di too sista dehn sen mesij tu Jeezas seh, “Laad, yu gud fren weh yu lov sik.” ");
INSERT INTO bzj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bot wen Jeezas yehr dat, ih seh, “Lazaros noh wahn en op di ded sayka dis siknis. Dis hapm soh dat peepl ku si how wandaful Gaad wandaful, ahn dehn wahn ku si how wandaful Gaad Son tu.” ");
INSERT INTO bzj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Jeezas mi lov Mayri ahn Marta ahn dehn breda Lazaros, bot eevn afta ih yehr seh Lazaros mi sik, ih stil stay da di plays wehpaa ih mi deh fi too moa dayz. ");
INSERT INTO bzj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Den afta dat, ih seh tu ih disaipl dehn, “Lesgoh bak da Judeeya dischrik.” ");
INSERT INTO bzj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bot di disaipl dehn tel ahn seh, “Teecha, di Jooish leeda dehn da Judeeya neva jos mi-di chrai stoan yu, ahn yoo waahn goh bak deh agen?” ");
INSERT INTO bzj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jeezas ansa dehn seh, “Da noh twelv daylait owaz eena eech day? Peepl weh waak eena braad daylait noh wahn bok dehn fut pahn notn, kaa dehn ga di lait a dis werl fi si wid. ");
INSERT INTO bzj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bot if dehn waak da nait, den dehn wahn bok dehn fut, kaa dehn noh ga no lait fi help dehn si.” ");
INSERT INTO bzj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Den Jeezas seh, “Wi fren Lazaros gaahn sleep, bot Ah gwehn goh wayk ahn op.” ");
INSERT INTO bzj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Di disaipl dehn seh, “Wel Laad, if ih oanli di sleep, den dat meen ih wahn geh beta.” ");
INSERT INTO bzj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Di disaipl dehn mi tink dat Jeezas mi-di seh dat Lazaros jos gaahn sleep, bot Jeezas mi meen dat ih mi ded fi chroo. ");
INSERT INTO bzj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Den Jeezas kom owt playn-wan ahn tel dehn seh, “Lazaros ded. Fi fi unu sayk, Ah glad Ah neva dehdeh kaa now unu ga di chaans fi bileev. Kohn, mek wi goh si ahn.” ");
INSERT INTO bzj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tamas, hoofa niknaym da-mi di Twin, tel di ada disaipl dehn, “Mek aala wi goh wid Jeezas mek wi ded wid ahn.” ");
INSERT INTO bzj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wen Jeezas reech Betani, ih fain owt seh Lazaros mi don ded ahn eena ih toom fi foa dayz aredi. ");
INSERT INTO bzj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Now Betani mi oanli deh bowt too mailz fahn Jeroosalem, ahn lata di Jooz dehn mi kohn kohn komfert Mayri ahn Marta wen dehn breda ded. ");
INSERT INTO bzj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Wen Marta yehr seh Jeezas mi-di kohn, ih gaahn gaahn meet ahn, bot Mayri stay hoahn. ");
INSERT INTO bzj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","22","Marta seh tu Jeezas, “Laad, if yu mi oanli deh ya, mi breda neva mi wahn ded. Bot eevn now Ai noa dat Gaad wahn gi yoo eniting yoo aks ahn fa.” ");
INSERT INTO bzj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jeezas tel Marta, “Yu breda wahn rayz op bak, yu noh.” ");
INSERT INTO bzj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta seh, “Ai noa dat ih wahn rayz op pahn di laas Day wen evribadi rayz op bak.” ");
INSERT INTO bzj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Jeezas tel ahn seh, “Da mee da di Wan weh rayz op peepl ahn mek dehn liv agen. Enibadi weh bileev eena mee, eevn if dehn ded, dehn stil wahn goh hed liv, ahn enibadi weh livin weh bileev eena mee wahn neva ded. Yoo bileev dat?” ");
INSERT INTO bzj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta ansa seh, “Yes, Laad! Ai mi aalwayz bileev seh yoo da Gaad Son, weh da di Krais weh Gaad mi fi sen.” ");
INSERT INTO bzj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Den Marta lef, ahn gaahn bak gaahn kaal ih sista Mayri. Ih tek ahn wan said ahn tel ahn seh, “Di Teecha deh ya ahn ih di aks fi yu.” ");
INSERT INTO bzj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Wen Mayri yehr dat, ih get op kwik-wan ahn gaahn tu Jeezas. ");
INSERT INTO bzj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Now Jeezas neva reech Betani yet. Ih mi stil deh wehpaa Marta mi meet ahn. ");
INSERT INTO bzj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Som a di Jooish leeda dehn mi deh eena di hows wid Mayri di kansoal ahn. Wen dehn si ih get op kwik-wan ahn gaan, dehn fala ahn. Dehn mi tink seh ih mi gwehn da Lazaros grayv goh baal. ");
INSERT INTO bzj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Wen Mayri reech wehpaa Jeezas mi deh ahn ih si ahn, ih neel dong bai ih fut ahn seh, “Laad, if yoo mi oanli deh ya, mi breda neva mi wahn ded.” ");
INSERT INTO bzj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Wen Jeezas si Mayri di baal, ahn di peepl dehn weh mi deh wid ahn di baal tu, ih mi beks, bot sayhn taim, deep dong eena ih haat ih mi sad. ");
INSERT INTO bzj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jeezas aks dehn seh, “Da wehpaa unu put Lazaros?” Dehn tel ahn seh, “Kohn si, Laad.” ");
INSERT INTO bzj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Den Jeezas staat tu krai. ");
INSERT INTO bzj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Di peepl dehn seh, “Hmm, hihn mosi mi lov Lazaros bad!” ");
INSERT INTO bzj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bot som a dehn seh, “Dis da noh di man weh mi heel di blain man mek ih kuda mi si? Da how kom hihn kudn kip Lazaros fahn ded?” ");
INSERT INTO bzj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jeezas mi don beks agen bai di taim ih reech di toom, weh da-mi wahn kayv, ahn wahn big rak mi deh fronta it. ");
INSERT INTO bzj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jeezas seh, “Moov di rak.” Lazaros sista, Marta, tel ahn seh, “Bot Laad, da don foa dayz sins ih ded ahn ih don stink aredi.” ");
INSERT INTO bzj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jeezas tel ahn seh, “Ah neva tel yu dat if yu bileev, yu wahn si how powaful Gaad powaful?” ");
INSERT INTO bzj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Soh dehn moov di rak. Jeezas luk op eena hevn ahn seh, “Faada, Ah tank yu dat yu don yehr mi. ");
INSERT INTO bzj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ah mi noa seh dat yu aalwayz yehr mi, bot Ah seh dis sayka di krowd weh di stan op ya, soh dat dehn ku bileev dat da yoo sen mi.” ");
INSERT INTO bzj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Wen ih don seh dat, ih hala owt haad-wan, “Lazaros, kom owt!” ");
INSERT INTO bzj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Den di ded man kom owt. Ih han ahn ih fut dehn mi rap op rong ahn rong wid sohn lang pees a klaat, ahn wahn klaat mi rap rong ih fays tu. Jeezas tel dehn seh, “Loos ahn mek ih goh.” ");
INSERT INTO bzj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Lata di Jooz dehn weh mi gaahn lang wid Mayri si weh Jeezas du ahn dehn bileev eena ahn. ");
INSERT INTO bzj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bot som a dehn ron gaahn tel di Farisee dehn weh Jeezas mi du. ");
INSERT INTO bzj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Soh di cheef prees dehn ahn di Farisee dehn kaal op wahn meetn wid di Jooish Kongsl ahn seh, “Da weh wi wahn du now? Dis man di du aala dehn mirakl. ");
INSERT INTO bzj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","If wi mek hihn goh hed laik dat, den evribadi wahn bileev eena ahn, ahn di Roaman soalja dehn wahn kohn ahn dischrai wi templ ahn wi nayshan.” ");
INSERT INTO bzj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Bot wan a dehn weh mi nayhn Kaiyafas, weh da-mi di hai prees da yaa, tel dehn seh, “Unu noh noa notn! ");
INSERT INTO bzj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Unu noh noa seh dat ih beta fi unu fi mek wan man ded fi di peepl dehn dan fi mek di hoal nayshan geh dischrai?” ");
INSERT INTO bzj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","Kaiyafas neva seh dat rait soh, bot laik how hihn da-mi di hai prees da yaa, Gaad mi mek hihn seh heda taim dat Jeezas mi wahn ded fi di nayshan. Bot da neva oanli fi di nayshan; da mi fi gyada aala Gaad peepl dehn weh mi skyata aal oava di werl, mek dehn kohn tugeda az wan peepl. ");
INSERT INTO bzj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Soh fahn da day goh bak, dehn mi-di plan fi kil Jeezas. ");
INSERT INTO bzj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Soh fahn den aan, Jeezas stap goh bowt eena poblik da Judeeya. Ih lef fahn deh ahn gaahn da Eefraym, weh da wahn tong weh mi deh kloas di dezert, ahn ih stay deh wid ih disaipl dehn. ");
INSERT INTO bzj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Now da mi nayli taim fi di Jooish peepl dehn Paasoava selibrayshan. Lata peepl fahn owt konchri gaan op da Jeroosalem sohn dayz bifoa di selibrayshan, kaa dehn mi waahn goh chroo di washin serimoni weh mi wahn mek dehn kleen eena Gaad sait. ");
INSERT INTO bzj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Dehn mi-di luk fi si if dehn mi wahn si Jeezas ahn dehn mi-di aks wan anada seh, “Unu tink ih wahn kohn da di selibrayshan?” ");
INSERT INTO bzj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wel, di cheef prees dehn ahn di Farisee dehn mi don gi aadaz dat if enibadi mi noa wehpaa Jeezas mi deh, dehn mi fi kohn tel dehn soh dat dehn ku ares ahn. ");
INSERT INTO bzj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Da mi siks dayz bifoa di Paasoava selibrayshan wen Jeezas reech Betani, wehpaa Lazaros mi liv. Hihn da di sayhn wan weh Jeezas mi rayz fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Dehn mi-di ga wahn dina deh fi Jeezas, ahn Marta mi-di help serv. Lazaros mi deh monks dehn wan weh mi sidong rong di taybl wid Jeezas. ");
INSERT INTO bzj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wel, Mayri shee kohn ahn tek wahn hoal paint a ekspensiv perfyoom weh mek owta loan naad, ahn ih poar it oava Jeezas fut ahn den ih waip dehn wid ih hyaa. Di hoal hows mi smel sweet, sweet, sweet a di perfyoom. ");
INSERT INTO bzj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Bot wan a di disaipl dehn weh nayhn Joodas Iskariyat, weh mi wahn sel owt Jeezas aftawodz, seh, ");
INSERT INTO bzj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Da wai dehn neva sel dis perfyoom ahn gi di moni tu di poa peepl dehn? Dehn kuda mi geh wahn hoal yaa pay fi dat.” ");
INSERT INTO bzj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Da noh weh Joodas mi kay bowt di poa peepl dehn soh moch, bot da kaa ih da-mi wahn teef. Hihn doz main di moni bag fi di ada disaipl dehn ahn ih doz stay di dip ih han een deh. ");
INSERT INTO bzj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jeezas seh, “Lef di laydi loan noh? Shee mi sopoas tu sayv dis perfyoom fi geh mi redi fi wen dehn wahn beri mi. ");
INSERT INTO bzj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Poa peepl wahn aalwayz deh wid unu, bot unu noh wahn aalwayz ga mee.” ");
INSERT INTO bzj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Lata peepl yehr seh Jeezas mi deh da Betani, soh wahn big krowd gaahn deh gaahn si ahn. Bot dehn neva oanli gaahn fi si Jeezas, bot dehn mi waahn si Lazaros weh ih mi rayz op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Soh di cheef prees dehn mi-di mek plan fi kil Lazaros tu, ");
INSERT INTO bzj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kaa sayka weh mi hapm tu hihn, lata di Jooz dehn mi-di lef dehn ahn staat tu bileev eena Jeezas. ");
INSERT INTO bzj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Di neks day, di krowd weh mi kohn fi di Paasoava selibrayshan yehr seh Jeezas mi-di kohn da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Soh dehn tek sohn paam branch ahn gaahn gaahn meet ahn. Dehn mi-di hala, “Hozaana! Gaad bles di Wan weh kom eena di naym a di Laad! Hozaana tu di king a Izrel!” ");
INSERT INTO bzj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jeezas fain wahn yong dongki ahn sidong pan ahn, ahn dat mek weh di prafit dehn mi rait dong eena di Skripcha kohn chroo. Dehn mi rait seh, ");
INSERT INTO bzj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Unu peepl fahn Jeroosalem noh fi frayd. Si, unu king di kohn di sidong pahn wahn yong dongki.” ");
INSERT INTO bzj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Fos, di disaipl dehn neva andastan non a dehn ting weh mi-di hapm. Bot da afta Jeezas rayz op bak fahn di ded eena aala ih gloari, da den dehn memba seh aala dehn ting mi rait dong eena di Skripcha bowt ahn, ahn dehn mi du aala dehn ting tu ahn fi chroo. ");
INSERT INTO bzj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Wel, di krowd weh mi dehdeh wid Jeezas wen ih kaal Lazaros owta di toom ahn rayz ahn fahn di ded mi-di goh rong di tel evribadi bowt it. ");
INSERT INTO bzj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Dat da-mi di mayn reezn wai soh moch peepl gaahn gaahn meet Jeezas, sayka di mirakl weh ih mi du wid Lazaros. ");
INSERT INTO bzj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Di Farisee dehn seh tu wan anada, “Yu si, unu kyaahn du wan ting. Luk how di hoal werl di goh afta hihn now.” ");
INSERT INTO bzj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Now sohn Greek peepl mi deh monks dehn wan weh gaan op da Jeroosalem fi wership joorin di Paasoava selibrayshan. ");
INSERT INTO bzj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Dehn gaahn da Filip weh mi kohn fahn Betsayda da Gyalilee ahn seh tu ahn, “Sa, wi wuda waahn si Jeezas.” ");
INSERT INTO bzj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip gaahn tel Anjru weh dehn seh, ahn den di too a dehn gaahn tel Jeezas. ");
INSERT INTO bzj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jeezas tel dehn seh, “Di taim kohn fi mek dehn si how wandaful di Son a Man wandaful. ");
INSERT INTO bzj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ah di tel unu di chroot; if nobadi noh plaant wahn seed, den aal ih wahn bee da wahn seed. Bot if dehn plaant it, den ih wahn ded ahn kom op bak ahn bayr lata froot. ");
INSERT INTO bzj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“Aala dehn wan weh lov dehn laif eena dis werl wahn en op di laas it; ahn dehn wan weh noh di chrai heng aan tu dehn laif wahn en op di kip it ahn liv fareva. ");
INSERT INTO bzj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Enibadi weh waahn serv mee hafu fala mee, soh dat dehn ku deh sayhn plays weh Ai deh tu. Ahn mai Faada wahn aana enibadi weh serv mee. ");
INSERT INTO bzj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Now mi haat hevi, hevi, bot Ah kyaahn aks mi Faada fi sayv mi fahn di sofarin weh deh heda mi, kaa dat da egzakli weh Ah kohn fa.” ");
INSERT INTO bzj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Den Jeezas seh, “Faada, mek dehn si how wandaful yu naym.” Den wahn vais kohn fahn owta hevn ahn seh, “Ah don mek dehn si how wandaful mai naym aredi, an Ah wahn du it agen.” ");
INSERT INTO bzj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Di krowd weh mi-di stan op deh yehr di vais, ahn som a dehn mi tink seh dat da-mi tonda. Sohn neks wan seh, “Da wahn aynjel mi-di taak tu ahn.” ");
INSERT INTO bzj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Den Jeezas tel dehn seh, “Da fi fi unu sayk mek da vais kohn, noh fi fi mee sayk. ");
INSERT INTO bzj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Di taim kohn now fi mek Gaad joj di peepl dehn eena di werl, ahn hihn wahn pich owt Saytan, weh da di wan weh di rool dis werl. ");
INSERT INTO bzj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ahn unu si mee? Wen dehn lif mee op pahn di kraas fahn aafa di grong, Ai wahn jraa evribadi tu mee.” ");
INSERT INTO bzj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jeezas seh dis soh dat dehn kuda mi noa weh kaina det ih mi wahn ded. ");
INSERT INTO bzj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Di krowd ansa ahn seh, “Fi wee Skripcha seh dat di Krais wahn liv fareva. Soh how yoo ku seh dat dehn wahn lif op di Son a Man? Da hoo da dis ‘Son a Man’ eniway?” ");
INSERT INTO bzj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jeezas tel dehn seh, “Di lait wahn oanli deh wid unu wahn lee wail langa. Soh unu waak wail di lait stil deh, bifoa daak kohn dong pahn unu, kaa enibadi weh waak eena daak noh noa wichpaa dehn gwehn. ");
INSERT INTO bzj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Soh unu beta bileev eena di Wan weh gi unu lait wail ih stil deh wid unu; den unu wahn bee dehn peepl weh bilangz tu di lait.” Afta Jeezas don seh dat, ih gaahn fahn monks dehn ahn dehn kudn fain ahn no way. ");
INSERT INTO bzj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jeezas mi du wahn lata mirakl monks di peepl dehn, bot dehn stil neva bileev eena ahn. ");
INSERT INTO bzj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Dis mi hapm soh dat weh di prafit Aizaiya mi seh eena di Skripcha kuda mi kohn chroo. Ih mi seh, “Laad, hoo mi bileev weh wi tel dehn? Ahn da hoo di Laad shoa ih powa tu?” ");
INSERT INTO bzj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ahn di peepl dehn stil kudn bileev kaa Aizaiya mi seh wahn neks ting. Ih mi seh, ");
INSERT INTO bzj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Gaad don blain dehn aiy ahn mek dehn haadn dehn haat, soh dehn wahn kyaahn si wid dehn aiy ner andastan wid dehn haat, ahn dehn wahn kyaahn ton tu mi fi mek Ah heel dehn.” ");
INSERT INTO bzj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aizaiya mi seh dis kaa hihn ihself mi si how wandaful Jeezas mi wahn bee, soh hihn mi taak bowt ahn. ");
INSERT INTO bzj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Wel, lata peepl, dong tu som a di Jooish leeda dehn anaal, mi bileev eena Jeezas. Bot dehn neva waahn seh it owt kaa dehn mi frayd seh di Farisee dehn mi wahn pich dehn owta di sinagag. ");
INSERT INTO bzj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yu si, dehn mi lov wen peepl prayz dehn moa dahn wen Gaad prayz dehn. ");
INSERT INTO bzj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Den Jeezas hala owt haad-wan, “Enibadi weh bileev eena mee noh oanli di bileev eena mee, bot dehn di bileev eena di Wan weh sen mi. ");
INSERT INTO bzj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kaa wen unu si mee, unu si di Wan weh sen mi tu. ");
INSERT INTO bzj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ai kom eena di werl laik lait soh dat enibadi weh bileev eena mi noh wahn eena daak nohmoh. ");
INSERT INTO bzj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“If enibadi yehr weh Ah seh ahn noh du it, Ai noh wahn joj dehn, kaa Ai neva kohn fi joj di peepl dehn eena dis werl; Ai kohn fi sayv dehn. ");
INSERT INTO bzj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Dehn wan weh rijek mee, ahn noh du weh Ah tel dehn, don ga wahn joj aredi; pahn di laas day, fi dehn joj wahn bee dehn sayhn ting weh Ah mi teech dehn. ");
INSERT INTO bzj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kaa di ting dehn weh Ai seh da noh fahn mee, bot da mai Faada weh sen mi koman mee weh fi seh. ");
INSERT INTO bzj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","An Ai noa dat weh hihn koman mi fi seh wahn mek peepl liv fareva. Soh Ai seh egzakli weh mai Faada tel mi fi seh.” ");
INSERT INTO bzj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Di eevnin bifoa di Paasoava selibrayshan, Jeezas mi noa seh dat di taim kohn fi mek ih lef dis werl ahn goh bak da ih Faada. Ih mi aalwayz lov aala dehn wan eena dis werl weh bileev eena ahn, soh now ih shoa dehn how schrang ih lov fi dehn. ");
INSERT INTO bzj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Eevn bifoa dehn gaahn fi eet di speshal Paasoava dina, di devl mi don rab Joodas soal fi mek ih sel owt Jeezas. Dis da di sayhn Joodas weh da-mi Saiman Iskariyat son. ");
INSERT INTO bzj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Now Jeezas mi noa dat ih Faada mi don gi ahn aala di powa fi du evriting, ahn ih mi noa dat hihn mi kohn fahn Gaad ahn ih wahn goh bak tu Gaad. ");
INSERT INTO bzj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Soh ih get op fahn rong di taybl ahn tek aaf ih roab ahn put it wan said, ahn rap wahn towil rong ih ways. ");
INSERT INTO bzj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Afta dat ih poar sohn waata eena wahn baysn ahn staat wash ih disaipl dehn fut ahn jrai dehn wid di towil weh ih mi ga rap rong ahn. ");
INSERT INTO bzj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wen ih kohn tu Saiman Peeta, Peeta aks ahn seh, “Laad, yoo wahn wash fi mee fut tu?” ");
INSERT INTO bzj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jeezas ansa ahn seh, “Yu noh andastan weh Ah di du rait now, bot laytaraan yu wahn andastan.” ");
INSERT INTO bzj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peeta seh, “Neva! Yoo noh wahn wash fi mee fut!” Bot Jeezas ansa ahn seh, “If yu noh waahn mek Ah wash yu fut, den yoo noh bilangz tu mee nohmoh!” ");
INSERT INTO bzj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Soh Saiman Peeta seh, “Wel den Laad, noh jos wash mi fut, wash mi han ahn mi hed tu!” ");
INSERT INTO bzj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jeezas ansa seh, “Sohnbadi weh don bayd oanli hafu wash dehn fut sayka weh di hoal a dehn don kleen aredi. Ahn unu kleen, bot noh aala unu.” ");
INSERT INTO bzj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ih mi seh dat, kaa ih mi don noa hoo mi wahn sel ahn owt. ");
INSERT INTO bzj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Wen ih mi don wash dehn fut, ih put aan bak ih roab ahn gaahn bak da ih plays. Ih aks dehn seh, “Unu andastan weh Ah jos don du tu unu? ");
INSERT INTO bzj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Unu kaal mi unu Teecha ahn Maasta ahn dat karek, kaa dat da hoo mee. ");
INSERT INTO bzj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Laik how mee da unu Maasta ahn Teecha an Ai wash unu fut, den aala unu mos wash wan anada fut tu. ");
INSERT INTO bzj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ah du dis fi shoa seh dat aala unu shuda du di sayhn ting fi wan anada. ");
INSERT INTO bzj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ah di tel unu di chroot, wahn servant noh moa impoatant dan ih baas, ahn wahn mesinja noh moa impoatant dan di wan weh sen ahn. ");
INSERT INTO bzj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Unu noa dehnya ting, soh du dehn, ahn Gaad wahn bles unu. ");
INSERT INTO bzj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ah noh di seh dis bowt aala unu; Ai noa evri wan a unu weh Ah pik gud gud. Bot dis da fi mek unu noa dat weh dehn mi seh eena di Skripcha hafu kohn chroo. Di Skripcha mi seh, ‘Di sayhn persn weh di eet mi food rong di taybl wid mi ton gens mi.’ ");
INSERT INTO bzj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ah di tel unu now bifoa ih hapm, soh dat wen ih hapm unu wahn bileev dat da mee da di Wan. ");
INSERT INTO bzj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ah di tel unu di chroot, if eni wan a unu aksep enibadi weh Ai sen, unu di aksep mee; ahn enibadi weh aksep mee aksep di Wan weh sen mi.” ");
INSERT INTO bzj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Wen ih don seh dat, Jeezas haat geh hevi hevi, soh ih tel dehn playn-wan, “Ah di tel unu di chroot, wan a unu wahn sel mi owt.” ");
INSERT INTO bzj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Aal di disaipl dehn luk pahn wan anada, kaa dehn neva noa da wich wan a dehn Jeezas mi-di taak bowt. ");
INSERT INTO bzj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Now di disaipl weh Jeezas mi lov mi-di sidong rait saida ahn. ");
INSERT INTO bzj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saiman Peeta mek sain tu ahn, ahn tel ahn seh, “Aks Jeezas da wich wan a wi ih di taak bowt.” ");
INSERT INTO bzj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Soh di disaipl leen bak gens Jeezas ahn aks ahn seh, “Laad, da hoo yu di taak bowt?” ");
INSERT INTO bzj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jeezas ansa seh, “Ah wahn dip dis pees a bred eena di dish, ahn di persn weh Ah wahn gi di bred tu, hihn da di wan weh wahn sel mi owt.” Soh ih dip di pees a bred ahn gi Joodas, weh da-mi Saiman Iskariyat son. ");
INSERT INTO bzj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Az soon az ih don gi ahn di pees a bred, Saytan gaan eena Joodas. Jeezas tel ahn seh, “Mikays, goh du weh yu gwehn goh du.” ");
INSERT INTO bzj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nobadi rong di taybl mi andastan wai Jeezas mi tel ahn dis. ");
INSERT INTO bzj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Laik how Joodas da-mi di chrejara a di groop, som a dehn mi tink dat Jeezas mi-di sen ahn fi goh bai sohnting weh dehn mi need fi di Paasoava dina, er fi goh bai sohnting fi di poa peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Az soon az Joodas mi don tek di bred, ih gaan owt. Da mi don nait. ");
INSERT INTO bzj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Wen Joodas gaan, Jeezas seh, “Now Gaad wahn shoa evribadi di gloari a di Son a Man, ahn Gaad wahn yooz di Son a Man fi shoa fi hihn gloari! ");
INSERT INTO bzj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ahn if di Son a Man shoa evribadi Gaad gloari, den Gaad ihself wahn shoa dehn di gloari weh kohn fahn di Son a Man. Gaad wahn soon du aala dis. ");
INSERT INTO bzj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Oa mi pikni, Ah wahn deh wid unu oanli wahn lee bit langa. Unu wahn luk fi mi, ahn jos laik how Ah mi tel di Jooish leeda dehn, Ah di tel unu, weh Ai gwehn, unu wahn kyaahn kohn rait now. ");
INSERT INTO bzj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Ah di giv aala unu wahn nyoo koman: Lov wan anada. Unu mos lov wan anada jos laik how Ai lov aala unu. ");
INSERT INTO bzj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","If unu lov wan anada, den evribadi wahn noa dat unu da fi mee disaipl.” ");
INSERT INTO bzj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saiman Peeta aks ahn seh, “Laad, da wehpaa yu gwehn?” Jeezas ansa seh, “Wehpaa Ai gwehn yu kyaahn fala mi rait now, bot laytaraan yu wahn fala mi fi chroo.” ");
INSERT INTO bzj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Soh Peeta aks ahn seh, “Bot Laad, da wai Ah kyaahn goh wid yu now? Ai wuda ded fi yoo!” ");
INSERT INTO bzj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Den Jeezas ansa seh, “Yoo wahn gi fi yoo laif fi mee? Ah di tel yu di chroot, bifoa di roosta kroa, yoo wahn disoan mee chree taim!” ");
INSERT INTO bzj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jeezas seh, “Noh hat unu haat. Chros Gaad ahn chros mee tu. ");
INSERT INTO bzj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lata room deh eena mai Faada hows. Ah gwehn deh goh geh wahn plays redi fi unu. Ah noh mi wahn tel unu dat if da neva chroo. ");
INSERT INTO bzj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Wen Ah don ga evriting redi, Ah wahn kohn bak fi unu ahn kehr unu wid mi soh dat unu ku deh wid mi. ");
INSERT INTO bzj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ahn unu noa di way fi get tu weh Ah gwehn.” ");
INSERT INTO bzj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tamas seh tu ahn, “Laad, wee noh eevn noa wehpaa yu gwehn, soh da how wi ku noa di way fi get deh?” ");
INSERT INTO bzj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jeezas ansa ahn seh, “Da mee da di way, da mee da di chroot, ahn da mee da di laif. Di oanli way peepl ku kohn tu Gaad di Faada da fi kohn chroo mee. ");
INSERT INTO bzj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","If unu mi reeli noa mee, den unu mi wahn noa mi Faada tu. Wel, fahn ya goh bak unu noa hihn fi chroo ahn unu eevn don si hihn aredi.” ");
INSERT INTO bzj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip tel Jeezas seh, “Laad, shoa wi hoo da yu Faada, ahn wi wahn satisfai.” ");
INSERT INTO bzj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jeezas ansa seh, “Filip, Ai deh wid yoo dis hoal taim ahn yoo stil noh noa mi? Enibadi weh don si mee don si mai Faada tu. Soh da how yoo ku seh, ‘Shoa wi hoo da yu Faada’? ");
INSERT INTO bzj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filip, yoo noh bileev seh dat Ai liv eena mai Faada, ahn hihn liv eena mee? Di werd dehn weh Ai seh tu unu da noh weh Ai jos tink op, yu noh; da mai Faada weh liv eena mee di du fi hihn oan werk chroo mee. ");
INSERT INTO bzj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bileev mi wen Ah seh dat Ai liv eena mai Faada, ahn hihn liv eena mee. If unu noh bileev dat, den at lees bileev sayka aala di mirakl dehn weh unu si Ah du. ");
INSERT INTO bzj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Ah di tel unu di chroot, enibadi weh bileev eena mee wahn du di sayhn kaina ting dehn weh Ai du. In fak, dehn wahn du grayta ting dahn weh unu si Ai du, kaa Ai gwehn bak da mi Faada. ");
INSERT INTO bzj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yooz mi naym enitaim unu aks mi fi eniting, an Ah wahn du it, soh dat weh di Son du ku mek peepl si how wandaful mai Faada wandaful. ");
INSERT INTO bzj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Soh yooz mi naym wen unu aks mi fi eniting, an Ah wahn du it. ");
INSERT INTO bzj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“If unu lov mi, unu wahn du aal weh Ah tel unu fi du. ");
INSERT INTO bzj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ah wahn aks mi Faada fi mek ih sen wahn neks persn weh wahn aalwayz deh wid unu fi help unu. ");
INSERT INTO bzj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Da persn da di Hoali Spirit ahn hihn wahn shoa unu di chroot bowt Gaad. Di peepl dehn eena dis werl kyaahn mek di Hoali Spirit kanchroal dehn laif, kaa dehn noh noa hoo hihn ahn dehn wosa noh di luk fi si ahn. Bot unu noa di Hoali Spirit aredi kaa hihn don deh wid unu, ahn hihn wahn di liv rait eensaida unu. ");
INSERT INTO bzj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ah noh wahn lef unu laik dehn pikni weh noh ga nobadi fi main dehn; Ah wahn kohn bak tu unu. ");
INSERT INTO bzj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wahn lee wail moa ahn di peepl dehn eena dis werl noh wahn si mi nohmoh, bot unu wahn si mi doh. Sayka weh Ai wahn liv agen, unu wahn liv tu. ");
INSERT INTO bzj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wen da taim kohn, den unu wahn noa seh dat Ai da wan wid mai Faada, ahn unu da wan wid mee, an Ai da wan wid unu. ");
INSERT INTO bzj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Dehn wan weh noa mi komanment dehn, ahn obay dehn, da di wan dehn weh reeli lov mi fi chroo. Ahn mai Faada wahn lov aala dehn wan weh lov mee, an Ai wahn lov dehn tu, an Ah wahn shoa dehn da hoo mee.” ");
INSERT INTO bzj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Now wahn neks disaipl weh nayhn Joodas (noh Joodas Iskariyat) seh tu Jeezas, “Laad, da weh mek yoo wahn shoa wee da hoo yoo ahn noh shoa di res a di peepl a di werl?” ");
INSERT INTO bzj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jeezas ansa seh, “Dehn wan weh lov mi wahn du weh Ah seh, ahn mai Faada wahn lov dehn, ahn mee ahn hihn wahn kohn liv wid dehn. ");
INSERT INTO bzj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Enibadi weh noh lov mi noh du weh Ah seh. Da noh mee tink op dehn werd weh Ah seh tu unu, bot dehn da fahn mai Faada weh sen mee. ");
INSERT INTO bzj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ah di tel unu dehn ting wail Ah stil deh wid unu. ");
INSERT INTO bzj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bot di Hoali Spirit wahn kohn help unu, kaa mai Faada wahn sen ahn eena mai plays. Hihn wahn teech unu evriting ahn ih wahn mek unu memba aal weh Ah mi tel unu. ");
INSERT INTO bzj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Pees da weh Ah di lef wid unu, ahn da mai oan pees; da noh laik di wan weh di peepl dehn a dis werl gi. Now unu mosn hat unu haat. Noh frayd. ");
INSERT INTO bzj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Unu yehr how Ah tel unu dat Ah gwehn weh, an Ah wahn kohn bak tu unu. Wel, if unu mi lov mi, unu wuda glad dat Ah gwehn da mi Faada, kaa hihn grayta dahn mee. ");
INSERT INTO bzj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Ah tel unu aala dis bifoa ih hapm soh dat wen ih doo hapm, unu ku bileev weh Ah seh. ");
INSERT INTO bzj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ah noh wahn taak wid unu soh moch afta dis, kaa Saytan, weh da di wan weh di rool dis werl, di kohn. Hihn noh ga no powa oava mee. ");
INSERT INTO bzj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ai du weh mai Faada koman mee fi du soh dat di peepl dehn eena dis werl ku noa dat Ai lov mai Faada. “Get op now ahn mek wi goh.” ");
INSERT INTO bzj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jeezas tel ih disaipl dehn seh, “Ai da di chroo chroo vain weh mi Faada ku pen pan fi bayr loan gud froot, ahn mi Faada da di gyaadna weh tek kayr a it. ");
INSERT INTO bzj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Hihn chap weh eni branch weh noh di bayr, bot aala dehn wan weh bayr, ih chrim dehn kleen kleen soh dat dehn ku bayr moa froot. ");
INSERT INTO bzj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Unu don kleen aredi sayka weh unu bileev aala di ting dehn weh Ah mi teech unu. ");
INSERT INTO bzj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Now unu mos stay jain aan tu mi, jos laik how Ai jain aan tu unu. Wahn branch kyaahn bayr no froot if ih stay bai ihself ahn noh jain aan tu di vain. Da rait soh wid unu: notn gud kyaahn kom owta unu laif if unu noh stay jain aan tu mee. ");
INSERT INTO bzj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ai da di vain ahn unu da di branch dehn. Aala dehn wan weh jain aan tu mee, ahn weh Ai jain aan tu, wahn bayr lata froot. Bot if unu noh jain aan tu mee, unu kyaahn du notn. ");
INSERT INTO bzj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Enibadi weh noh jain aan tu mee wahn bee jos laik dehn branch weh dehn chroh-weh ahn den dehn jrai op. Branch laik dehndeh jos gud fi mek peepl gyada op ahn bon op eena faiya. ");
INSERT INTO bzj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","If unu stay jain aan tu mee, ahn aala weh Ai teech unu stay eena unu haat, den eniting weh unu aks fa, unu wahn geh. ");
INSERT INTO bzj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Wen lata gud ting kom owta unu laif, dat wahn shoa dat unu da mi falowa dehn fi chroo, ahn sayka dat, unu wahn di aana mai Faada. ");
INSERT INTO bzj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Sayhn laik how mai Faada mi aalwayz lov mee, dat da di sayhn way Ai mi aalwayz lov unu; soh mek shoar dat unu kip aan di liv eena da sayhn kaina lov tu. ");
INSERT INTO bzj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","If unu du evriting weh Ah tel unu fi du, den unu wahn di kip aan di liv eena mai lov, jos laik how Ai du evriting weh mai Faada tel mi fi du an Ai kip aan di liv eena fi hihn lov. ");
INSERT INTO bzj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ah tel unu aala dehn ting ya soh dat unu ku geh ful op wid aala di sayhn hapinis weh Ai ga deep deep dong eena mai haat. ");
INSERT INTO bzj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Dis da weh Ah waahn unu du: Lov wan anada di sayhn way how Ai lov unu. ");
INSERT INTO bzj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Di bes way wahn persn ku shoa ih fren dehn dat ih lov dehn da fi gi ih laif fi dehn. ");
INSERT INTO bzj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Unu da mi chroo chroo fren dehn if unu du weh Ah tel unu fi du. ");
INSERT INTO bzj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ai noh luk pahn unu laik servant nohmoh kaa wen yu da servant, yu noh noa yu maasta bizniz. Bot insted, Ai chreet unu laik fren, noh laik servant, kaa Ai mek unu noa evriting weh mai Faada tel mi. ");
INSERT INTO bzj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Unu neva pik mee, bot da mee pik unu. Ah sen unu fi bayr froot, di kaina froot weh wahn laas fareva. Den mai Faada ku gi unu eniting weh unu aks ahn fa if unu yooz mai naym. ");
INSERT INTO bzj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Soh Ai waahn unu du dehnya ting soh dat unu ku lov wan anada. ");
INSERT INTO bzj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“If unu fain seh dat peepl eena dis werl weh noh bilangz tu Gaad hayt unu, memba seh dehn mi hayt mee bifoa dehn mi hayt unu. ");
INSERT INTO bzj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","If unu mi stil stan laik dehn, den dehn mi wahn lov unu jos laik how dehn lov dehn oan. Bot unu noh stan laik dehn agen, kaa Ai pik unu owt fahn monks dehn fi bee difrent fahn dehn, ahn dats wai dehn hayt unu. ");
INSERT INTO bzj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Memba weh Ah mi tel unu? Ah seh, ‘Wahn servant noh moa impoatant dan ih baas.’ If dehn mi haraas mee, dehn wahn haraas unu tu. Ahn if dehn mi obay mee, dehn wahn obay unu tu. ");
INSERT INTO bzj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bot dehn wahn du aala dehnya ting sayka weh unu bilangz tu mee, kaa dehn noh noa di Wan weh sen mi. ");
INSERT INTO bzj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yu si, if Ah neva kohn ahn taak tu dehn, den dehn neva mi wahn gilti a du notn rang, bot now dehn noh ga no ekskyooz fi dehn rangdooinz. ");
INSERT INTO bzj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","“Enibadi weh hayt mee hayt mai Faada tu. ");
INSERT INTO bzj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ah du miraklz monks dehn weh nobadi els neva du. If Ah neva du dehndeh, dehn neva mi wahn gilti a du notn rang. Bot dehn si aal weh Ah du ahn dehn stil hayt mee ahn dehn hayt mi Faada tu. ");
INSERT INTO bzj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bot dat mi hapm soh dat fi dehn Skripcha ku kohn chroo weh seh, ‘Dehn mi hayt mi fi notn.’ ");
INSERT INTO bzj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Mai Faada wahn sen sohnbadi weh wahn deh rait deh saida unu fi help unu. Wen hihn kohn, ih wahn taak bowt mee. Da Helpa da di Hoali Spirit weh tel di chroot bowt Gaad. ");
INSERT INTO bzj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Unu fi tel peepl bowt mi tu, kaa unu deh wid mi fahn wen Ah fos staat tu teech. ");
INSERT INTO bzj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ah tel unu aala dehn ting fi mek unu noh schray fahn unu fayt eena mi. ");
INSERT INTO bzj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dehn wahn pich unu owta di sinagag, ahn di taim wahn kohn wen dehn wahn kil unu ahn tink seh dehn di du Gaad wahn fayva. ");
INSERT INTO bzj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Dehn wahn du dat kaa dehn neva noa mee ner mi Faada. ");
INSERT INTO bzj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ai di tel unu dehn ting soh dat wen di taim kohn fi mek ih hapm tu unu, unu wahn memba seh dat Ah mi don waan unu bowt it aredi. Ah neva tel unu dehn ting fos, kaa Ah stil mi wahn deh wid unu lee langa. ");
INSERT INTO bzj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Bot now Ah gwehn bak da di Wan weh sen mi, ahn non a unu stil noh aks mi da weh Ah gwehn. ");
INSERT INTO bzj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Now sayka weh Ah tel unu dehn ting, unu haat geh hevi. ");
INSERT INTO bzj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bot Ah di tel unu di chroot, ih beta fi unu fi mek Ah goh weh; kaa if Ah noh goh, di Helpa, weh da di Hoali Spirit, noh wahn kohn tu unu; bot if Ah goh, den Ah wahn sen ahn tu unu. ");
INSERT INTO bzj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ahn wen hihn kohn, hihn wahn proov tu di peepl dehn a di werl dat dehn rang bowt sin, ahn dehn rang bowt weh ih meen fi bee rait wid Gaad, ahn dehn rang bowt Gaad jojment. ");
INSERT INTO bzj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dehn rang bowt sin, kaa dehn rifyooz fi bileev eena mee. ");
INSERT INTO bzj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Dehn rang bowt weh rait, kaa Ai gwehn da mi Faada ahn unu noh wahn si mi nohmoh. ");
INSERT INTO bzj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Den dehn rang bowt Gaad jojment tu, kaa Saytan, weh da di roola a dis werl, don geh joj aredi. ");
INSERT INTO bzj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ah stil ga lat moa ting fi tel unu, bot unu kyaahn tek it een rait now. ");
INSERT INTO bzj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Bot wen di Hoali Spirit weh shoa di chroot kohn, hihn wahn mek unu noa di hoal chroot bowt Gaad. Hihn noh wahn di taak fi hihn oan ting, bot ih oanli wahn taak weh hihn yehr, ahn hihn wahn tel unu bowt ting weh wahn hapm eena di fyoocha. ");
INSERT INTO bzj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hihn wahn aana mee kaa hihn wahn tek weh Ai seh ahn tel unu. ");
INSERT INTO bzj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Evriting weh mai Faada ga da fi mee. Dats wai Ah seh dat ih wahn tek weh Ai seh ahn tel unu. ");
INSERT INTO bzj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Wahn lee wail moa ahn unu noh wahn si mi nohmoh; den afta wahn nada lee wail, unu wahn si mi agen.” ");
INSERT INTO bzj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Den som a Jeezas disaipl dehn seh tu wan anada, “Da weh hihn meen wen hihn tel wi, ‘Wahn lee wail moa ahn unu noh wahn si mi nohmoh; den afta wahn nada lee wail unu wahn si mi agen’? Ahn weh ih meen wen ih seh, ‘Kaa Ah gwehn da mi Faada’?” ");
INSERT INTO bzj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Den dehn seh, “Da weh hihn meen bai, ‘wahn lee wail’? Wee noh noa weh hihn di taak bowt.” ");
INSERT INTO bzj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jeezas mi noa weh dehn mi waahn aks ahn, soh ih tel dehn seh, “Unu di diskoas monks unuself weh Ah meen wen Ah seh, ‘Wahn lee wail moa ahn unu noh wahn si mi nohmoh, ahn den afta wahn nada lee wail unu wahn si mi agen,’ noh chroo? ");
INSERT INTO bzj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ah di tel unu di chroot, unu wahn krai ahn baal, bot di res a di peepl dehn a di werl wahn rijais. Unu wahn feel sad, bot unu wahn soon feel glad agen. ");
INSERT INTO bzj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Da jos laik wen wahn laydi deh eena layba; ih eena lata payn kaa ih taim kohn. Bot wen di baybi baan, ih faget humoch ih mi-di sofa, kaa ih soh glad dat ih bring wahn baybi eena di werl. ");
INSERT INTO bzj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Da rait soh wid unu. Unu di feel sad rait now, bot Ah wahn si unu agen ahn den unu haat wahn glad, ahn nobadi wahn kyaahn tek weh di gladnis fahn unu. ");
INSERT INTO bzj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Wen da taim kohn, unu noh wahn hafu aks mee fi notn. Ah di tel unu di chroot, unu wahn ku goh schrayt da mai Faada ahn aks hihn fi eniting, ahn hihn wahn gi unu if unu yooz mai naym. ");
INSERT INTO bzj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Op tu now unu neva yet yooz mai naym fi aks fi eniting. Aks, ahn unu wahn geh. Den unu wahn ga hapinis weh wahn kyaahn don deep dong eena unu haat. ");
INSERT INTO bzj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ah mi don taak tu unu aredi bowt dehnya ting eena parablz, bot di taim di kohn wen Ah noh wahn taak soh nohmoh; den Ah wahn taak tu unu playn-wan bowt mai Faada. ");
INSERT INTO bzj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wen da taim kohn, unu wahn yooz mai naym fi aks mai Faada fi eniting. Ai noh wahn hafu aks hihn fi notn fi unu. ");
INSERT INTO bzj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mai Faada ihself lov unu kaa unu mi lov mee ahn unu mi bileev dat Ai mi kohn fahn Gaad. ");
INSERT INTO bzj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yes, Ai kohn fahn mai Faada ahn kom eena di werl; den Ai wahn lef dis werl ahn goh bak da mai Faada agen.” ");
INSERT INTO bzj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Den Jeezas disaipl dehn tel ahn seh, “Yu stap taak tu wi eena parablz, ahn yu jos di taak playn tu wi now! ");
INSERT INTO bzj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Now wi noa dat yoo noa evriting. Nobadi noh eevn hafu aks yoo notn fi mek yoo noa weh dehn di tink! Dats wai wee bileev dat yoo kohn fahn Gaad.” ");
INSERT INTO bzj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jeezas ansa dehn seh, “Soh unu bileev now? ");
INSERT INTO bzj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bot di taim di kohn wen unu wahn skyata ahn goh bak hoahn da unu hows. Unu wahn ron lef mee wan, bot stil Ah noh wahn deh bai miself kaa mai Faada deh wid mee. ");
INSERT INTO bzj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ah tel unu dehnya ting fi mek unu ga pees eena unu haat, kaa mee ahn unu da wan. Unu wahn sofa wahn lat eena dis werl, bot unu tek haat, Ai don win di vikchri oava di wikid powaz eena dis werl aredi.” ");
INSERT INTO bzj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Wen Jeezas don seh dehn ting, ih luk op da hevn ahn pray seh, “Faada, di taim don kohn. Mek peepl si yu Son gloari, soh dat Ai ku shoa dehn fi yoo gloari tu. ");
INSERT INTO bzj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kaa yoo gi mee atariti oava evribadi pahn dis ert, soh dat Ai ku mek aala dehn wan weh yoo gi mi ku liv wid Gaad fareva. ");
INSERT INTO bzj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ahn di way fi mek dehn liv wid Gaad fareva da fi mek dehn noa yoo, weh da di oanli chroo Gaad, ahn fi mek dehn noa Jeezas Krais, weh da di Wan weh yoo sen. ");
INSERT INTO bzj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ai shoa evribadi ya pahn dis ert fi yoo gloari, kaa Ai don du evriting weh yoo sen mi fi du. ");
INSERT INTO bzj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Soh now Faada, gi mi bak di gloari weh Ah mi ga wen Ai mi deh wid yoo fahn bifoa di werl mi eevn staat tu mek. ");
INSERT INTO bzj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Yoo mi gi mi sohn disaipl fahn dis werl an Ai don shoa dehn how yoo stan. Dehn mi bilangz tu yoo; den yoo gi mee dehn, ahn dehn mi du aal weh yoo seh fi du. ");
INSERT INTO bzj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Now dehn noa dat evriting weh Ai ga, da akchwali fahn yoo, ");
INSERT INTO bzj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kaa Ai tel dehn bak di sayhn werd dehn weh yoo tel mee fi seh, ahn dehn aksep it. Dehn noa dat Ai kohn fahn yoo fi chroo, ahn dehn bileev seh dat da yoo sen mee. ");
INSERT INTO bzj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Soh da dehn Ah di pray fa. Ah noh di pray fi di res a peepl dehn eena di werl, bot Ah di pray fi dehn wan ya weh yu gi mi kaa dehn bilangz tu yoo. ");
INSERT INTO bzj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ahn aala dehn wan weh bilangz tu mee da fi yoo tu, ahn dehn wan weh bilangz tu yoo da fi mee. Evribadi ku si mai gloari sayka dehn. ");
INSERT INTO bzj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Ai soon kohn da yoo; Ai noh wahn deh eena dis werl agen, bot dehn wahn stil deh ya. Soh mi Faada weh hoali, Ah aks yu fi protek dehn chroo di powa weh deh eena yu naym, di sayhn naym weh yu gi mee, soh dat dehn ku bee wan jos laik how mee ahn yoo da wan. ");
INSERT INTO bzj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Wail Ai mi deh wid dehn, Ai mi protek dehn chroo di powa weh deh eena di naym weh yoo mi gi mee. Ai mi main dehn gud ahn nat wan a dehn neva faal weh, eksep da wan weh mi bong fi goh da hel. Dat mi hapm soh dat weh di Skripcha mi seh bowt hihn kuda mi kohn chroo. ");
INSERT INTO bzj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Now Ai soon kohn bak tu yoo, bot Ah seh aala dehn ting wail Ah stil deh pahn dis ert, soh dat mi disaipl dehn haat ku ful op a di sayhn hapinis weh deh deep dong eena mai haat. ");
INSERT INTO bzj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ah tel dehn di veri werd dehn weh yoo tel mee, ahn sayka dat, di peepl dehn a di werl hayt dehn. Dehn noh bilangz tu dis werl, jos laik how Ai noh bilangz tu dis werl needa. ");
INSERT INTO bzj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Faada, Ah noh di aks yu fi tek dehn owta dis werl, bot Ah di aks yu fi protek dehn fahn di eevl wan, weh da di devl. ");
INSERT INTO bzj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Jos laik how Ai noh bilangz tu dis werl, dehn noh bilangz tu it needa. ");
INSERT INTO bzj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mek yu werd dehn weh da di chroot mek dehn oanli liv fi yoo wan, kaa fi yoo werd dehn da di chroot. ");
INSERT INTO bzj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sayhn laik how yu mi sen mee eena dis werl, Ai di sen dehn owt eena di werl tu. ");
INSERT INTO bzj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Sayka dehn, Ai gi maiself oava tu yoo fi serv yoo wan soh dat dehn ku gi fi dehnself oava tu yoo fi serv yoo wan tu. ");
INSERT INTO bzj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ai noh oanli di pray fi dehnya disaipl ya, bot Ah di pray fi aala dehn peepl weh wahn bileev eena mee sayka weh dehn wan ya seh bowt mee. ");
INSERT INTO bzj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Faada, Ah pray dat aala dehn ku bee wan sayhn laik how mee ahn yoo da wan. Mek dehn jain aan tu wee sayhn laik how yoo deh eena mee ahn mee deh eena yoo. Den di peepl dehn a di werl wahn ku bileev seh dat da yoo mi sen mee. ");
INSERT INTO bzj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ai di aana dehn sayhn way how yoo aana mee, soh dat dehn ku bee wan sayhn laik how mee ahn yoo da wan. ");
INSERT INTO bzj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ai jain aan tu dehn ahn yoo jain aan tu mee eena wahn perfek way, soh dat di res a di werl ku noa dat yoo mi sen mee, ahn dat yoo mi lov dehn jos laik how yoo lov mee. ");
INSERT INTO bzj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Faada, Ah waahn dehn falowaz weh yu gi mi deh da di sayhn plays weh Ai wahn deh, soh dat dehn ku si how yoo aana mee. Yu aana mi kaa yoo mi lov mee fahn bifoa di werl mi eevn mek. ");
INSERT INTO bzj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Mi Faada, yoo da di Wan weh gud. Di ada peepl dehn eena di werl noh noa yoo ataal, bot Ai noa yoo, ahn dehn wan ya noa seh dat da yoo mi sen mee. ");
INSERT INTO bzj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ai shoa dehn da hoo yoo an Ah wahn kip aan di shoa dehn, soh dat di lov weh yoo ga fi mee ku deh eena dehn, an Ai wahn ku liv eena dehn.” ");
INSERT INTO bzj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Wen Jeezas don seh dis pryaa, hihn ahn ih disaipl dehn lef ahn gaahn kraas Kijron Vali. Wahn gyaadn mi dehdeh ahn Jeezas ahn ih disaipl dehn gaan een. ");
INSERT INTO bzj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Now Jeezas doz aalwayz meet deh wid ih disaipl dehn, soh Joodas, weh mi sel owt Jeezas, mi wel noa wehpaa da plays mi deh. ");
INSERT INTO bzj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Wel, Joodas hihn gaahn da di gyaadn ahn kehr sohn Roaman soalja wid ahn. Di cheef prees dehn ahn di Farisee dehn sen sohn templ gyaad lang wid ahn tu. Aala dehn mi-di kehr lamp ahn toach ahn difrent kaina wepan. ");
INSERT INTO bzj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jeezas mi noa aal weh mi wahn hapm tu ahn, soh ih step owt ahn aks dehn seh, “Da hoo unu di luk fa?” ");
INSERT INTO bzj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Dehn ansa ahn seh, “Wi di luk fi Jeezas, weh kohn fahn Nazaret.” Jeezas seh, “Da mee da hihn.” Joodas, weh mi sel ahn owt, mi deh rait deh di stan op wid dehn. ");
INSERT INTO bzj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Wen Jeezas seh, “Da mee da hihn,” evribadi haal bak ahn jrap da grong. ");
INSERT INTO bzj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jeezas aks dehn agen, “Da hoo unu di luk fa?” Ahn dehn tel ahn seh, “Jeezas fahn Nazaret.” ");
INSERT INTO bzj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jeezas ansa dehn seh, “Ah tel unu aredi dat Ai da hihn. Soh if da mee unu di luk fa, den let goh mi disaipl dehn weh deh ya wid mi.” ");
INSERT INTO bzj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jeezas seh dat soh dat weh hihn ihself mi seh kuda mi kohn chroo. Ih mi seh, “Faada, aala dehn wan weh yu mi gi mi stil deh wid mi.” ");
INSERT INTO bzj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Den Saiman Peeta haal owt ih soad weh ih mi ga ahn chap aaf di hai prees servant rait ayz. Di servant mi nayhn Malkos. ");
INSERT INTO bzj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jeezas tel Peeta, “Put bak yu soad. Yoo tink seh Ai noh wahn jrink owta dis kop a sofarin weh mai Faada don ga set fi mee?” ");
INSERT INTO bzj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Den di soalja dehn ahn dehn aafisa ahn di templ gyaad dehn ares Jeezas ahn tai op ih han dehn. ");
INSERT INTO bzj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Fos, dehn kehr ahn da Anas, weh da-mi Kaiyafas faada-in-laa. Kaiyafas da-mi di hai prees da yaa. ");
INSERT INTO bzj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Hihn da-mi di sayhn Kaiyafas weh mi advaiz di Jooish leeda dehn dat ih mi beta fi mek wan man ded fi evribadi. ");
INSERT INTO bzj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","16","Saiman Peeta ahn wahn neks disaipl mi-di fala Jeezas. Laik how di hai prees mi noa da disaipl, hihn gaan eena di hai prees yaad wid Jeezas, bot Peeta mi-di wayt owtsaid da di gayt. Soh di ada disaipl weh di hai prees mi noa, gaahn bak owtsaid ahn taak tu di gyal weh mi-di main di gayt, ahn den ih bring een Peeta. ");
INSERT INTO bzj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Di gyal da di gayt tel Peeta, “Yoo da noh wan a dis man disaipl?” Peeta seh, “Ai da noh wan a dehn.” ");
INSERT INTO bzj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Now di servant ahn di gyaad dehn mi-di stan op rong wahn faiya weh dehn mi mek fi waam dehnself kaa ih mi koal. Peeta anaal mi-di stan op deh wid dehn di waam ihself. ");
INSERT INTO bzj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Den di hai prees kweschan Jeezas bowt ih disaipl dehn ahn bowt weh aal ih doz teech. ");
INSERT INTO bzj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jeezas ansa ahn seh, “Ah mi aalwayz deh braad-wan eena poblik, di taak tu evribadi; Ah teech eena di sinagag dehn ahn eena di templ weh aala di Jooish peepl dehn gyada. Ah neva yet seh notn eena seekrit. ");
INSERT INTO bzj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bot da weh unu di kweschan mee fa? Aks dehn wan weh yehr weh Ah seh. Dehn noa egzakli weh Ah seh.” ");
INSERT INTO bzj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Az Jeezas don seh dat, wan a di templ gyaad dehn slap ahn kraas ih fays ahn seh, “Da soh yoo di taak tu di hai prees?” ");
INSERT INTO bzj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jeezas ansa seh, “If Ah seh eniting rang, den tel evribadi da weh Ah seh rang. Bot if weh Ah seh rait, den da wai yu lik mi?” ");
INSERT INTO bzj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Den Anas sen Jeezas bak da Kaiyafas, weh da-mi di hai prees. Jeezas mi stil tai op. ");
INSERT INTO bzj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Now Peeta mi stil dehdeh di stan op ahn di waam ihself. Sohn ada peepl aks ahn seh, “Yoo da noh wan a da man disaipl, noh chroo?” Bot Peeta wudn oan op tu it. Ih seh, “Noh man, Ai da noh wan a dehn.” ");
INSERT INTO bzj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Wan a di hai prees servant weh mi rilaytid tu di man hoofa ayz Peeta mi kot aaf, aks ahn seh, “Ai neva si yoo eena di gyaadn wid ahn?” ");
INSERT INTO bzj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bot agen Peeta seh, “Hoo, Mee? No, mee neva dehdeh!” Ahn sayhn taim, wahn roosta staat tu kroa. ");
INSERT INTO bzj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Da mi soon da maanin wen di Jooish leeda dehn mek di templ gyaad dehn kehr Jeezas fahn Kaiyafas plays tu di govna hows. Bot di Jooish leeda dehn neva gaan eensaid, kaa fi dehn Laa seh dat dehn noh wahn kleen eena Gaad sait if dehn goh eena eni hows weh peepl weh da noh Joo deh. If dehn noh kleen, dehn wahn kyaahn selibrayt di Paasoava. ");
INSERT INTO bzj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Soh Pailat, weh da-mi di govna, gaan owtsaid tu dehn ahn seh, “Soh da weh unu di akyooz dis man seh ih du?” ");
INSERT INTO bzj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Dehn ansa seh, “If dis man da neva wahn kriminal, wi neva wuda mi han ahn oava tu yoo.” ");
INSERT INTO bzj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Den Pailat tel dehn seh, “Wel den, unu tek ahn, ahn chrai ahn unuself akaadn tu fi unu oan laa dehn.” Di Jooish leeda dehn ansa seh, “Unu Roamanz noh alow wee fi put nobadi tu det.” ");
INSERT INTO bzj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Wen dehn seh dat, ih mek weh Jeezas mi seh kohn chroo, kaa hihn mi don tel dehn weh kaina det ih mi wahn ded.) ");
INSERT INTO bzj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailat gaahn bak eensaid ahn kaal fi mek dehn bring Jeezas tu ahn. Ih aks ahn seh, “Yoo da di king a di Jooz?” ");
INSERT INTO bzj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jeezas aks ahn seh, “Dat da weh yoo tink, er dat da weh dehn tel yu bowt mi?” ");
INSERT INTO bzj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat ansa seh, “Yoo tink Ai da wahn Joo noh? Da yu oan peepl dehn ahn di cheef prees dehn han yu oava tu mi. Soh da weh yu gaahn gaahn du?” ");
INSERT INTO bzj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jeezas seh, “Ai noh rool laik dehn king weh rool pahn dis ert, yu noh. If Ai mi stan laik dehn, den fi mee falowa dehn mi wahn fait fi mek dehn noh han mi oava tu di Jooish leeda dehn. Bot no, Ai noh rool dong ya pahn dis ert.” ");
INSERT INTO bzj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pailat aks Jeezas seh, “Soh yoo da wahn king den?” Jeezas ansa seh, “Yu rait wen yu seh dat. Ai baan ahn kom eena dis werl fi wan reezn: fi taak bowt di chroot. Ahn evribadi weh lov di chroot lisn tu weh Ai seh.” ");
INSERT INTO bzj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailat aks Jeezas seh, “Soh da weh da chroot?” Wen ih don seh dat, ih gaahn bak owtsaid tu di Jooish leeda dehn ahn seh, “Ai noh fain notn weh dis man du fi mek unu waahn put ahn tu det. ");
INSERT INTO bzj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bot unu ga wahn ting weh unu du evri yaa, weh Ah let goh wahn prizna fi unu joorin di Paasoava selibrayshan. Soh unu waahn mek Ah let goh ‘di king a di Jooz’ fi unu?” ");
INSERT INTO bzj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dehn hala bak seh, “No, noh hihn ataal! Gi wi Baraabas!” (Baraabas da-mi wahn kriminal.) ");
INSERT INTO bzj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Den Pailat mek di soalja dehn flag Jeezas. ");
INSERT INTO bzj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Dehn mek wahn krong owta prikl bush ahn put it pahn ih hed. Den dehn jres ahn op eena wahn perpl gong ");
INSERT INTO bzj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ahn dehn stodi mi-di kom op tu ahn di seh, “Lang liv di king a di Jooz!” Ahn den dehn nak ahn op eena ih fays. ");
INSERT INTO bzj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat gaan owtsaid agen ahn tel di krowd, “Unu luk ya, Ah di bring ahn owt tu unu fi mek unu noa dat Ai noh fain notn weh dis man du fi put ahn tu det.” ");
INSERT INTO bzj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Wen Jeezas kom owt di wayr di krong mek owta prikl bush ahn di perpl gong, Pailat seh, “Si di man ya!” ");
INSERT INTO bzj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wen di cheef prees ahn di templ gyaad dehn si Jeezas, dehn hala, “Kroosifai ahn! Kroosifai ahn!” Pailat tel dehn seh, “Unu tek ahn, ahn kroosifai ahn unuself; Ai noh fain notn rang wid ahn.” ");
INSERT INTO bzj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Di Jooish leeda dehn ansa ahn seh, “Akaadn tu fi wee Laa, ih fi put tu det kaa hihn klaym seh dat hihn da Gaad Son.” ");
INSERT INTO bzj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wen Pailat yehr dat, ih mi wosara frayd. ");
INSERT INTO bzj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ih gaahn bak eensaid ahn aks Jeezas seh, “Da weh yoo kohn fram?” Bot Jeezas neva seh wan werd. ");
INSERT INTO bzj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Soh Pailat seh tu ahn, “Yu noh waahn ansa mi noh? Yu noh noa seh Ai ga di powa fi let yu goh, ahn di powa fi kroosifai yu?” ");
INSERT INTO bzj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jeezas tel ahn seh, “Luk ya, yu oanli ga powa oava mee kaa Gaad gi yu. Soh di wan weh han mi oava tu yu ga wosa sin dan yoo.” ");
INSERT INTO bzj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Fahn deh goh bak, Pailat mi-di chrai haad fi let goh Jeezas, bot di Jooish leeda dehn hala, “If yoo let goh dis man, yoo da noh Seeza fren. Enibadi weh seh dat dehn da king di ton gens Seeza.” ");
INSERT INTO bzj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Wen Pailat yehr dat, ih bring owt Jeezas tu dehn agen. Pailat sidong pahn di jojment seet weh mi deh eena wahn plays weh nayhn “di Stoan Payvment.” Eena di Jooish langwij dehn kaal it “Gabaata.” ");
INSERT INTO bzj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Da mi bowt mid-day pahn di day bifoa di Paasoava selibrayshan. Pailat tel di peepl dehn, “Hahn, si unu king ya!” ");
INSERT INTO bzj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Di peepl dehn hala, “Kehr dis man fahn ya! Kehr ahn! Kroosifai ahn!” Pailat aks dehn seh, “Unu waahn Ah kroosifai unu king?” Di cheef prees dehn ansa seh, “Di oanli king weh wee ga da Seeza.” ");
INSERT INTO bzj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Den Pailat han Jeezas oava tu dehn fi mek dehn kroosifai ahn. Soh di soalja dehn kehr ahn weh. ");
INSERT INTO bzj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jeezas bak ih kraas ihself ahn gaahn da di plays weh nayhn “Skol Hil.” Eena di Jooish langwij, dehn kaal it “Galgota.” ");
INSERT INTO bzj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Da rait dehsoh dehn kroosifai ahn. Too ada man mi geh kroosifai lang wid ahn tu. Dehn put wan pahn eech said, wid Jeezas da midl. ");
INSERT INTO bzj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat mek dehn put wahn sain pahn di kraas weh seh: JEEZAS FAHN NAZARET, DI KING A DI JOOZ. ");
INSERT INTO bzj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Di plays weh dehn kroosifai Jeezas mi deh kloas di siti, ahn weh di sain mi rait eena Heebroo ahn Latn ahn Greek, lata peepl kuda mi reed it. ");
INSERT INTO bzj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Den di cheef prees dehn seh, “Chaynj da sain fahn ‘Di king a di Jooz dehn’ tu ‘Hihn seh dat hihn da di king a di Jooz.’” ");
INSERT INTO bzj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailat seh, “Ah don rait weh Ah don rait!” ");
INSERT INTO bzj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wen di soalja dehn don kroosifai Jeezas, dehn shayr op ih kloaz eena foa, wan pees fi eech soalja. Bot ih roab, weh mi mek owta wan pees a klaat weh dehn weev, neva ga no seem. ");
INSERT INTO bzj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Soh di soalja dehn seh, “Mek wi noh tayr dis pees a kloaz ya, bot wi wahn gyambl fi si hoo get it.” Dis mek di Skripcha kohn chroo weh seh, “Dehn shayr op mi kloaz monks dehn ahn gyambl fi mi roab.” Soh dat da weh dehn du. ");
INSERT INTO bzj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Now Jeezas ma mi-di stan op deh kloas di kraas lang wid fi shee sista, ahn Klopas waif weh nayhn Mayri, ahn Mayri Magdaleen. ");
INSERT INTO bzj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Wen Jeezas si di disaipl weh ih lov di stan op deh saida ih ma, ih seh, “Ma, fahn ya goh bak hihn da yu son.” ");
INSERT INTO bzj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Den ih seh tu di disaipl, “Si yu ma ya.” Ahn fahn den di disaipl kehr Jeezas ma gaahn liv wid ahn da ih hows. ");
INSERT INTO bzj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Bai den Jeezas mi noa dat ih mi don du evriting weh ih Faada mi sen ahn fi du. Soh, fi mek weh di Skripcha seh kohn chroo, Jeezas seh, “Ah tersti.” ");
INSERT INTO bzj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wahn batl a wain vineega mi dehdeh, soh dehn soak wahn pees a sponj eena it ahn put it pahn wahn stik weh kom aafa di hisop plaant, ahn hais it op da Jeezas mowt. ");
INSERT INTO bzj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wen Jeezas don tays di wain, ih seh, “Evriting don now.” Den ih bow ih hed ahn giv op ih spirit ahn ded. ");
INSERT INTO bzj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Laik how da mi di day fi geh redi fi di Paasoava selibrayshan, ahn di neks day da-mi wahn ekschra hoali Sabat, di Jooish leeda dehn neva waahn lef di badi dehn pahn di kraas dehn. Soh dehn aks Pailat fi mek dehn brok dehn fut ahn tek dong di badi dehn. ");
INSERT INTO bzj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Soh di soalja dehn gaahn da di fos man pahn di kraas saida Jeezas ahn brok ih fut dehn. Den dehn gaahn da di neks man ahn brok fi hihn fut dehn tu. ");
INSERT INTO bzj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bot wen dehn kohn tu Jeezas, dehn noatis seh ih mi don ded, soh dehn neva bada brok fi hihn fut dehn. ");
INSERT INTO bzj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Insteda dat, wan a di soalja dehn shub ih spyaa eena ih said, ahn sayhn taim blod ahn waata ron owt. ");
INSERT INTO bzj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Di persn weh mi si aal weh mi hapm di tel evribadi bowt it soh dat dehn ku bileev tu. Weh hihn seh da chroo ahn hihn noa dat hihn di tel di chroot.) ");
INSERT INTO bzj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Di Skripcha mi seh, “Nat wan a ih boan wahn brok.” Wel, aala dehnya ting mi hapm soh dat da Skripcha ku kohn chroo. ");
INSERT INTO bzj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ahn eena wahn neks paat di Skripcha mi seh, “Dehn wahn luk pahn di wan weh dehn juk wid wahn spyaa.” ");
INSERT INTO bzj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Afta aala dehn ting don hapm, Joazef, weh mi kohn fahn Arimateeya, gaahn gaahn aks Pailat fi Jeezas badi. Hihn da-mi wan a Jeezas falowa dehn, bot ih neva mek nobadi noa kaa ih mi frayd fi di Jooish leeda dehn. Wel, Pailat tel ahn ih kuda mi kehr di badi, soh dat da weh ih du. ");
INSERT INTO bzj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Now di sayhn Nikodeemos, weh mi gaahn si Jeezas wahn nait, mi gaahn wid Joazef, ahn hihn bring bowt wahn honjrid pong a aintment weh mek owta mer ahn aloaz miks op. ");
INSERT INTO bzj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dehn rap op Jeezas badi eena sohn lang pees a linin klaat lang wid sohn sweet aintment, jos laik how di Jooish peepl dehn doz du wen dehn beri dehn ded. ");
INSERT INTO bzj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Wahn gyaadn mi deh kloas tu wichpaa Jeezas mi geh kroosifai, ahn rait een dehsoh, wahn toom weh dehn neva put no ded badi eena yet mi deh. ");
INSERT INTO bzj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Soh laik how da mi di day wen dehn mi fi geh redi fi di Sabat ahn di toom mi deh kloas, dehn put Jeezas een deh. ");
INSERT INTO bzj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Soon-wan Sondeh maanin, wen ih mi stil daak, Mayri Magdaleen gaahn da di toom ahn noatis seh di stoan mi don moov fahn fronta di oapnin. ");
INSERT INTO bzj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Soh ih ron gaahn da Saiman Peeta ahn di ada disaipl, di wan weh Jeezas mi lov, ahn tel dehn seh, “Dehn moov di Laad badi fahn owta di toom, ahn wee noh noa wichpaa dehn put ahn.” ");
INSERT INTO bzj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Den Peeta ahn di ada disaipl set owt fi gaahn da di toom. ");
INSERT INTO bzj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Too a dehn mi-di ron tugeda, bot di ada disaipl ron hed faasa dahn Peeta ahn hihn reech di toom fos. ");
INSERT INTO bzj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ih ben dong ahn luk eensaid ahn ih si di loan pees a linin klaat dehn weh dehn mi rap op Jeezas badi wid, bot ih neva gaan een. ");
INSERT INTO bzj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Den Saiman Peeta, weh mi-di kohn bihain hihn, reech di toom ahn gaan eensaid. Peeta si di linin klaat dehn deh, ");
INSERT INTO bzj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ahn ih si di klaat weh mi rap rong Jeezas hed tu, bot da klaat mi deh roal op wan said bai ihself. ");
INSERT INTO bzj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Den di ada disaipl weh mi reech di toom fos, gaan een tu. Hihn si, ahn ih bileev. ");
INSERT INTO bzj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yu si, dehn stil neva andastan di Skripcha weh mi seh how Jeezas mi fi rayz op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Aftawodz di disaipl dehn gaahn bak hoahn. ");
INSERT INTO bzj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Bot Mayri stan op owtsaida di toom di baal. Wail ih mi-di baal, ih stup dong ahn luk eensaid. ");
INSERT INTO bzj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ih si too aynjel jres op eena wait kloaz di sidong rait wichpaa Jeezas badi mi deh, wan bai weh ih hed mi deh, ahn di neks wan weh ih fut mi deh. ");
INSERT INTO bzj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dehn aks Mayri, “Mis, da weh yu di krai soh fa?” Mayri tel dehn seh, “Dehn kehr weh mi Laad badi an Ah noh noa wichpaa dehn put ahn.” ");
INSERT INTO bzj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wen ih don seh dat, ih ton rong ahn si Jeezas di stan op deh, bot ih neva noa dat da mi hihn. ");
INSERT INTO bzj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jeezas aks ahn seh, “Mis, weh yu di krai fa? Da hoo yu di luk fa?” Mayri mi tink seh dat da mi di gyaadna, soh ih tel ahn seh, “Mista, if da yoo kehr ahn, pleez tel mi soh dat Ai ku goh get ahn.” ");
INSERT INTO bzj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jeezas seh tu ahn, “Mayri!” Den Mayri ton tu ahn, ahn seh eena di Jooish langwij, “Raboani!” (Dat meen Teecha.) ");
INSERT INTO bzj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jeezas tel ahn seh, “Yu mosn hoal aan tu mi kaa Ah noh gaan op da mi Faada yet. Soh goh da mi breda dehn ahn tel dehn seh, ‘Ah gwehn op da mai Faada, weh da fi unu Faada tu, an Ah gwehn da mai Gaad, weh da fi unu Gaad tu.’” ");
INSERT INTO bzj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mayri Magdaleen gaahn gaahn tel di disaipl dehn seh, “Ai si di Laad!” Ahn ih tel dehn weh aal Jeezas mi seh tu ahn. ");
INSERT INTO bzj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Da sayhn Sondeh eevnin di disaipl dehn mi meet op tugeda da wahn hows. Dehn mi ga di doa dehn lak op kaa dehn mi frayd fi di Jooish leeda dehn. Sodn-wan Jeezas mi dehdeh di stan op monks dehn ahn ih seh, “Pees deh wid unu.” ");
INSERT INTO bzj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wen ih don seh dat, ih shoa dehn ih too han dehn ahn ih said. Wen di disaipl dehn si seh dat da mi di Laad, dehn mi oanli glad. ");
INSERT INTO bzj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jeezas tel dehn agen, “Pees deh wid unu. Sayhn way how mai Faada sen mee, da rait soh Ai di sen unu.” ");
INSERT INTO bzj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wen Jeezas don seh dat, ih bloa pahn dehn ahn tel dehn seh, “Mek di Hoali Spirit kohn pahn unu. ");
INSERT INTO bzj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Enibadi hoofa sin dehn unu fagiv, dehn don fagiv, bot if unu noh fagiv dehn, den dehn sin dehn wahn jos stay rait dehsoh.” ");
INSERT INTO bzj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Now Tamas, hoofa niknaym da-mi di Twin, da-mi wan a di twelv disaipl dehn, bot ih neva dehdeh wen Jeezas mi kohn. ");
INSERT INTO bzj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Soh di ada disaipl dehn tel ahn seh, “Wi si di Laad, yu noh.” Bot Tamas tel dehn seh, “Di oanli way Ai wahn bileev dat, da if Ai si di hoal dehn weh di nayl dehn lef eena ih han dehn ahn put mi finga eena dehn, ahn if Ah shub mi han eena ih said.” ");
INSERT INTO bzj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ayt dayz afta dat di disaipl dehn mi deh eena di hows agen, ahn dis taim, Tamas mi deh wid dehn. Di doa dehn mi shet ahn stil Jeezas kohn kohn stan op monks dehn ahn seh, “Pees deh wid unu.” ");
INSERT INTO bzj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Den Jeezas seh tu Tamas, “Kohn kohn put yu finga ya ahn luk pahn mi han dehn. Tek yu han ahn put it eena mi said. Stap di dowt, Tamas, ahn bileev.” ");
INSERT INTO bzj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tamas seh, “Mi Laad ahn mi Gaad!” ");
INSERT INTO bzj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jeezas tel Tamas, “Weh hapm? Yoo oanli bileev mi kaa yu si mi? Peepl weh noh si, ahn stil bileev, da di wan dehn weh Gaad bles fi chroo.” ");
INSERT INTO bzj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Now Jeezas mi du lat moa mirakl fronta ih disaipl dehn, bot dehn noh rait dong eena dis buk ya. ");
INSERT INTO bzj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bot aala dehn ting mi rait dong soh dat unu ku bileev dat Jeezas da di Krais, ahn dat hihn da Gaad Son. Ahn wen unu bileev eena hihn, unu wahn ku ga reel laif weh wahn laas fareva. ");
INSERT INTO bzj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Aftawodz Jeezas apyaa tu di disaipl dehn agen bai Gyalilee Lagoon. Dis da how ih du it: ");
INSERT INTO bzj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saiman Peeta ahn Tamas, hoofa niknaym da-mi di Twin, ahn Natanyel, weh kohn fahn Kayna da Gyalilee, ahn Zebidee too son dehn, lang wid too moa a Jeezas disaipl dehn, mi meet op deh. ");
INSERT INTO bzj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saiman Peeta tel dehn seh, “Ai gwehn goh fishin.” Den di res a dehn seh tu ahn, “Mek wi goh wid yu.” Soh dehn gaan owt eena di boat, bot da nait dehn neva kech notn. ");
INSERT INTO bzj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lee bit afta day brok, Jeezas mi-di stan op pahn di shoa, bot di disaipl dehn neva noa dat da mi hihn. ");
INSERT INTO bzj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jeezas hala tel dehn seh, “Mi fren, unu noh kech no fish, noh chroo?” Dehn ansa seh, “No, wi noh kech notn.” ");
INSERT INTO bzj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jeezas tel dehn seh, “Chroa unu net pahn di rait said a di boat, ahn unu wahn kech sohn.” Soh dehn chroa dehn net, ahn dehn kech soh moch fish dat dehn kudn eevn haal it een. ");
INSERT INTO bzj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Di disaipl weh Jeezas mi lov tel Peeta, “Bwai, da di Laad!” Wen Saiman Peeta yehr seh dat da mi di Laad, ih hori haal aan di kloaz weh ih mi tek aaf. Den ih jomp eena di waata. ");
INSERT INTO bzj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bot di ada disaipl dehn mi-di kom eena di boat di jreg di net ful a fish bihain dehn, kaa dehn oanli mi deh bowt wahn honjrid yaad fahn shoa. ");
INSERT INTO bzj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wen dehn reech shoa, dehn si fish di kuk pahn faiya koal. Bred mi dehdeh tu. ");
INSERT INTO bzj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jeezas tel dehn seh, “Bring som a di fish weh unu jos kech.” ");
INSERT INTO bzj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Soh Saiman Peeta gaahn pahn di boat ahn haal di net pahn shoa. Wahn honjrid ahn fifti-chree big fish mi eena di net, ahn stil di net neva bos. ");
INSERT INTO bzj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jeezas tel dehn seh, “Unu kohn kohn jrink tee.” Non a di disaipl dehn neva dayr aks ahn seh, “Da hoo yoo?” kaa dehn mi noa seh dat da mi di Laad. ");
INSERT INTO bzj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Den Jeezas kohn ahn tek di bred ahn gi dehn; den ih gi dehn di fish sayhn way. ");
INSERT INTO bzj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Dis mi mek chree taim Jeezas apyaa tu ih disaipl dehn afta ih mi rayz op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Wen dehn don eet, Jeezas seh tu Saiman Peeta, “Saiman, yoo weh da Jan son, yoo lov mee moa dahn eniting els?” Peeta tel Jeezas seh, “Yes Laad, yoo noa Ai lov yoo.” Jeezas tel ahn seh, “Feed mi lam dehn, den.” ");
INSERT INTO bzj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jeezas aks Peeta wahn sekant taim, “Saiman, yoo weh da Jan son, yoo lov mee?” Peeta ansa seh, “Yes Laad, yoo noa Ai lov yoo.” Jeezas seh, “Wel, ten tu mi sheep dehn den.” ");
INSERT INTO bzj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Den Jeezas aks ahn wahn terd taim seh, “Saiman, yoo weh da Jan son, yoo lov mee?” Peeta mi feel hert kaa Jeezas aks ahn if ih lov ahn chree taim. Peeta tel Jeezas seh, “Laad, yoo noa evriting. Yoo noa Ai lov yoo.” Jeezas seh, “Wel den, feed mi sheep dehn. ");
INSERT INTO bzj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ah di tel yu di chroot, wen yu mi yonga, yu yoostu put aan yu oan kloaz, ahn goh weh yu waahn. Bot wen yu get oal, yu wahn schrech owt yu han dehn ahn den sohnbadi els wahn put aan yu kloaz fi yu, ahn kehr yu weh yu noh waahn goh.” ");
INSERT INTO bzj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jeezas seh dat fi mek Peeta noa weh kaina det ih mi wahn ded, ahn dat da kaina det mi wahn aana Gaad. Afta dat, Jeezas tel Peeta, “Fala mi.” ");
INSERT INTO bzj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peeta ton rong ahn si di disaipl weh Jeezas mi lov di fala dehn. Da mi di sayhn disaipl weh mi leen kloas tu Jeezas wen dehn mi-di eet tugeda. Hihn mi aks Jeezas seh, “Laad, da hoo wahn sel yu owt?” ");
INSERT INTO bzj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Wel, wen Peeta si da disaipl deh, ih aks Jeezas seh, “Laad, da weh wahn hapm tu hihn?” ");
INSERT INTO bzj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jeezas tel ahn seh, “If Ai waahn hihn liv til Ai kohn bak, den weh dat tu yoo? Weh yoo fi du da fala mee!” ");
INSERT INTO bzj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Soh wahn rooma staat tu spred monks di res a Jeezas falowa dehn seh dat da disaipl deh neva mi wahn ded. Main yu, Jeezas neva did seh dat da disaipl neva mi wahn ded, bot ih mi seh, “If Ai waahn hihn liv til Ai kohn bak, da weh dat tu yoo?” ");
INSERT INTO bzj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Dis da di disaipl weh mi si aala dehn ting ahn rait dehn dong, ahn wee noa dat aal weh ih mi rait dong da-mi chroo. ");
INSERT INTO bzj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Lat moa ting mi deh weh Jeezas mi du, bot if dehn wuda chrai fi rait dong aala dehn, Ai ges di hoal werl wudn a ga spays fi hoal aala di buk dehn weh dehn mi wahn hafu rait eena.");
INSERT INTO bzj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Dyaa Misa Tiyofilos, Eena di fos leta weh Ah mi rait tu yu, Ah mi tel yu bowt aala di ting dehn weh Jeezas mi du ahn weh ih mi teech fahn di taim ih mi staat ih werk, ");
INSERT INTO bzj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","til di day ih gaan op da hevn. Bifoa ih gaan op, ih gi di man dehn weh ih mi pik fi bee ih apasl dehn di inschrokshanz weh ih mi geh chroo di Hoali Spirit. ");
INSERT INTO bzj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Fi faati dayz afta ih sofa ahn ded, ih apyaa tu ih disaipl dehn lata taim weh reeli proov fi chroo seh dat hihn, Jeezas, mi rayz op bak fahn di ded. Dehn mi si ahn wid dehn oan too aiy ahn hihn taak wid dehn bowt Gaad kingdom. ");
INSERT INTO bzj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ahn den, wen Jeezas mi-di eet tugeda wid dehn rong di taybl, ih tel dehn seh, “Unu noh fi lef Jeroosalem, bot unu mos wayt fi di gif weh di Faada mi pramis unu, weh Ah mi tel unu bowt. ");
INSERT INTO bzj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jan mi baptaiz unu wid waata, bot eena wahn fyoo dayz taim, Gaad wahn baptaiz unu wid di Hoali Spirit.” ");
INSERT INTO bzj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Wen di disaipl dehn mi kohn tugeda wid Jeezas, dehn aks ahn seh, “Laad, yoo wahn free fi wee peepl now ahn soh gi bak Izrel dehn kingdom?” ");
INSERT INTO bzj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jeezas tel dehn seh, “Unu noh hafu noa dat. Da mai Faada set di taim ahn di day ahn di yaa kaa hihn ga di atariti fi du dat. ");
INSERT INTO bzj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Bot wen di Hoali Spirit kohn pahn unu, unu wahn geh lata powa, ahn unu wahn ku goh aal bowt di plays di tel peepl bowt mee. Unu gwehn da Jeroosalem, ahn di hoal a Judeeya ahn Samayrya, ahn aal oava di werl.” ");
INSERT INTO bzj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Afta Jeezas don seh dat, Gaad kehr ahn op da hevn rait fronta dehn aiy. Den wahn klowd kova ahn op ahn dehn kudn si ahn nohmoh. ");
INSERT INTO bzj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Dehn mi stil di stan op deh di stayr op eena di skai, wen sodn-wan too man jres op eena ful wait stan op saida dehn. ");
INSERT INTO bzj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Dehn seh, “Unu man fahn Gyalilee, da wai unu di stan op deh di luk op eena di skai? Dis sayhn Jeezas weh Gaad tek op fahn monks unu ahn kehr op da hevn, wel hihn wahn kohn bak di sayhn way how unu si ahn gaan op.” ");
INSERT INTO bzj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Den di apasl dehn gaahn bak da Jeroosalem fahn di hil weh nayhn di Mongt a Alivz, weh deh bowt haaf mail fahn Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Wen dehn reech bak, dehn gaan opstayz da di room weh dehn mi-di stay. Dehnya da aal hoo mi dehdeh: Peeta, Jan, Jaymz, Anjru, ahn Filip, ahn Tamas, Bartalamyoo, Machyu, ahn Jaymz, weh da-mi Alfyos son; den yu mi ga Saiman weh da-mi wahn memba a di Zelat Paati, ahn Joodas, weh da-mi Jaymz son. ");
INSERT INTO bzj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Dehn doz get tugeda lata taim fi pray lang wid Mayri weh da-mi Jeezas ma, di ada laydi dehn, ahn Jeezas breda dehn. ");
INSERT INTO bzj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Wahn fyoo dayz layta, dehn mi ga wahn meetn wid aala di bileeva dehn, bowt wan honjrid ahn tweni a dehn in aal. Ahn Peeta get op fi taak. ");
INSERT INTO bzj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ih seh, “Mi bradaz ahn sistaz, di Skripcha hafu kohn chroo weh di Hoali Spirit mi seh lang taim chroo Dayvid bowt Joodas. Ih seh dat hihn mi wahn ak az gaid fi dehn wan weh kohn ares Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Hihn da-mi wan a wi, weh mi shayr eena di werk weh wi di du fi di Laad.” ");
INSERT INTO bzj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Dis man Joodas mi bai wahn pees a lan wid di blod moni weh ih get. Rait deh ih jrap ahn ded, ahn ih badi bos oapm ahn aala ih gots kom owt. ");
INSERT INTO bzj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Evribadi da Jeroosalem yehr bowt it, soh dehn kaal di pees a lan Akeldama, weh meen “Di Feel a Blod” eena fi dehn langwij.) ");
INSERT INTO bzj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peeta gaahn hed ahn seh, “Eena di buk a Saamz, Dayvid rait bowt Joodas seh, ‘Mek ih hows emti, noh mek nobadi liv een deh.’ Ahn den ih seh, ‘Mek sohnbadi els tek ih pozishan.’ ");
INSERT INTO bzj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Soh wi hafu pik sohnbadi fi tek Joodas plays. Ih hafu bee wahn man weh mi-di chravl bowt wid wi wen Jeezas mi deh ya. ");
INSERT INTO bzj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ih mi wahn hafu deh wid wi fahn wen Jan mi-di baptaiz peepl, til di day Jeezas gaan op da hevn; ahn ih mi hafu si Jeezas afta ih mi rayz op bak fahn di ded, soh ih ku tel peepl bowt it.” ");
INSERT INTO bzj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Soh dehn sojes too man: Joazef, weh dehn kaal Barsaabas (dehn doz kaal ahn Jostos tu), ahn Mataiyas. ");
INSERT INTO bzj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Den dehn pray seh, “Laad, yoo noa evribadi haat ahn weh dehn tink. Shoa wi wich wan a dehn yu pik fi bee wahn apasl ahn soh tek Joodas plays eena dis werk, kaa hihn don gaahn weh ih bizniz fi goh.” ");
INSERT INTO bzj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Den dehn jraa lat, ahn fahn dat Mataiyas naym geh pik owt fi jain di ada ilebm apasl dehn. ");
INSERT INTO bzj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Wen di day weh nayhn Pentikaas mi kohn, aala di peepl dehn weh mi bileev eena Jeezas mi deh tugeda da wan plays. ");
INSERT INTO bzj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sodn-wan, dehn yehr wahn naiz fahn di skai weh mi song laik wahn haad breez di bloa. Di song ful op di hoal hows wehpaa dehn mi deh. ");
INSERT INTO bzj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Den dehn si sohnting weh mi luk laik faiya weh divaid op ihself eena lata lee flaym ahn kohn dong ahn setl pahn eech a dehn. ");
INSERT INTO bzj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aala dehn mi geh ful op wid di Hoali Spirit ahn dehn staat taak eena aal kaina difrent tongz. Da di Spirit mi gi dehn di werd dehn fi seh. ");
INSERT INTO bzj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sohn rilijos Jooish peepl fahn aal oava di werl mi-di liv deh da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Wen dehn yehr di naiz, di hoal krowd a dehn gyada tugeda. Dehn mi-di wanda weh mi-di goh aan kaa dehn mi yehr di bileeva dehn di taak eena eech wan a dehn oan langwij. ");
INSERT INTO bzj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Dehn kudn bileev weh dehn mi-di yehr, soh dehn aks, “Aala dehn man da noh fahn Gyalilee? ");
INSERT INTO bzj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Soh da how aala wi ku yehr dehn di taak eena eech a fi wee langwij? ");
INSERT INTO bzj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Yu ga peepl ya fahn aal bowt. Yu ga Paatyanz, ahn Meedz, ahn Eelamaits. Den peepl deh ya fahn Mesopotaymya ahn Judeeya, fahn Kapadosha ahn Pontus, ahn Aysha. Den yu ga peepl fahn Frijya, Pamfilya, ahn Eejip ahn fahn sohn paat a Libya weh deh kloas tu Saireen. Yu ga sohn vizitaz fahn Roam weh da Joo ahn ada peepl weh mi jain di Jooish rilijan, lang wid peepl fahn Kreet ahn Araybya. Wi yehr dehn di taak eena aala wi oan langwij bowt di grayt ting dehn weh Gaad du.” ");
INSERT INTO bzj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Dehn kudn bileev weh mi-di hapm, bot sayhn taim dehn mi kanfyooz. Dehn aks wan anada, “Da weh dis meen now?” ");
INSERT INTO bzj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bot yu mi ga sohn ada peepl weh mi tek di hoal ting mek joak. Dehn seh, “Dehn peepl ya mosi mi-di jrink tu moch wain!” ");
INSERT INTO bzj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Den Peeta stan op wid di ada ilebm apasl dehn ahn staat tu preech haad-wan. “Mi felo Jooz, ahn aala unu ada peepl weh liv ya da Jeroosalem, Ah wahn eksplayn egzakli weh di goh aan rait ya soh; soh unu lisn gud tu weh Ah ga fi seh. ");
INSERT INTO bzj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Dehn peepl weh unu si ya noh jronk laik weh unu di tink, yu noh; kaa da jos nain aklak da maanin. ");
INSERT INTO bzj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Dis weh yu si di hapm ya da weh di prafit Joawel mi taak bowt fahn lang lang taim. Dis da weh Gaad tel Joawel: ");
INSERT INTO bzj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Dis da weh Ah wahn du eena di laas dayz: Ai wahn poar owt mi Spirit pahn evribadi. Unu son ahn unu daata dehn wahn preech weh Ai tel dehn fi preech. Unu yong man dehn wahn si vizhan, ahn unu oal man dehn wahn ga jreemz. ");
INSERT INTO bzj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yes, eevn pahn mi servant dehn, man ahn uman sayhn way, Ah wahn poar owt mi Spirit eena dehndeh dayz. Ahn dehn wahn preech weh Ah tel dehn fi preech! ");
INSERT INTO bzj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ah wahn du aal kaina mirakl ahn wandaz op eena di skai ahn dong ya pahn ert. Blod, faiya, ahn tik smoak wahn deh. ");
INSERT INTO bzj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Di son wahn geh daak daak, ahn di moon wahn ton red laik blod, bifoa di grayt ahn wandaful Day wen di Laad wahn kohn bak. ");
INSERT INTO bzj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ahn enibadi weh kaal owt tu di Laad fi help wahn geh sayv.’” ");
INSERT INTO bzj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Den Peeta gaahn hed ahn seh, “Peepl a Izrel, lisn tu dis! Jeezas fahn Nazaret da-mi wahn man weh Gaad mi proov seh mi kohn fahn hihn, chroo di miraklz ahn wandaz ahn di sain dehn weh Gaad mi gi ahn di powa fi du. Unu noa dis da chroo, bikaa aala dis hapm rait ya monks unu. ");
INSERT INTO bzj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Gaad mi plan fahn lang bifoa taim dat Jeezas mi wahn geh han oava tu unu. Ahn unu, lang wid sohn wikid peepl, mi nayl ahn pahn di kraas ahn kil ahn. ");
INSERT INTO bzj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ih sofa bad wen ih ded, bot Gaad neva lef ahn deh; ih rayz ahn op bak. Det neva ga no powa oava ahn agen, ahn kudn hoal ahn az ih prizna. ");
INSERT INTO bzj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dis da weh King Dayvid mi seh bowt ahn: Ih seh, ‘Ah aalwayz si di Laad fronta mi aal di taim. Sayka weh ih deh rait saida mi, Ah noh hafu wori bowt notn. ");
INSERT INTO bzj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ahn soh mi haat oanli feel glad, ahn mi mowt sing ih prayz. Eevn doa Ah da flesh ahn blod, Ah ga kanfidens dat yoo, Gaad, ");
INSERT INTO bzj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","noh wahn lef mi eena di plays a di ded, ner lef yu Hoali Wan fi ratn eena di grayv. ");
INSERT INTO bzj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yu shoa mi di way weh leed tu laif, ahn bikaa yu deh wid mi, Ah oanli feel hapi.’ ");
INSERT INTO bzj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mi brejrin, Ah shoar seh dat wen wi grayt-grayt-grayt-granfaada King Dayvid mi seh dehndeh ting, ih kudn a mi-di taak bowt ihself bikaa hihn don ded ahn beri, ahn fi hihn grayv stil deh ya wid wi op tu dis day. ");
INSERT INTO bzj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dayvid da-mi wahn prafit, ahn hihn mi noa weh Gaad mi pramis ahn: Gaad mi mek wahn vow dat ih mi wahn mek wan a fi hihn disendant dehn bee wahn king, jos laik hihn. ");
INSERT INTO bzj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dayvid mi-di si weh Gaad mi wahn du eena di fyoocha, ahn soh hihn mi-di taak bowt di day wen di Krais mi wahn rayz op bak fahn di ded. Ih seh, ‘Hihn mi neva geh lef eena di plays a di ded, ahn fi hihn badi neva ratn weh eena di grayv.’ ");
INSERT INTO bzj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Soh Gaad rayz op dis Jeezas fahn di ded, ahn aala wee da witnis tu dis. ");
INSERT INTO bzj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Gaad gi Jeezas di bigis aana wen ih put ahn fi sidong da ih rait han said; ahn ih gi ahn di Hoali Spirit jos laik how ih mi pramis, soh dat hihn ku ful wee op wid ahn tu. Dis da weh unu di si ahn yehr ya tudeh. ");
INSERT INTO bzj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Yu si, da neva Dayvid weh mi gaan op da hevn. In fak, Dayvid mi seh, ‘Di Laad seh tu fi mee Laad, “Sidong rait ya da mi rait han said, ");
INSERT INTO bzj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","til Ah put yu enimi dehn anda yu fut laik wahn futstool.”’ ");
INSERT INTO bzj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Peepl a Izrel, mek Ah mek it klyaa dat di sed Jeezas weh unu mi kroosifai, da hihn Gaad ton rong ahn mek Laad ahn Krais.” ");
INSERT INTO bzj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wen di peepl dehn yehr dis, dehn mi oanli feel bad. Soh dehn aks Peeta ahn di ada apasl dehn, “Mi brejrin, da weh wi fi du?” ");
INSERT INTO bzj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peeta ansa dehn ahn seh, “Unu ton fahn unu sin dehn, aala unu, ahn geh baptaiz eena di naym a Jeezas Krais, soh dat Gaad ku fagiv unu a unu sin dehn, ahn gi unu di Hoali Spirit weh ih mi pramis. ");
INSERT INTO bzj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Dis pramis da fi unu ahn unu pikni, ahn aala dehn wan weh deh da dehn ada konchri weh deh faar fahn ya. Da fi aala wi weh wi Laad Gaad wahn kaal fi fala ahn.” ");
INSERT INTO bzj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peeta tel dehn lata ada ting, ahn waan dehn ahn pleed wid dehn seh, “Sayv unuself fahn di ponishment weh di kohn pahn dis wikid jenarayshan.” ");
INSERT INTO bzj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Dehn wan weh aksep ih mesij mi geh baptaiz. Da day bowt chree towzn mi jain di groop a peepl weh bileev eena Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Dehn kantinyu fi laan fahn di apasl dehn. Dehn shayr dehn laif tugeda, di eet, ahn di taak, ahn di pray. ");
INSERT INTO bzj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Evribadi kudn bileev dehn aiy wen dehn si aala di wandaful ting dehn ahn miraklz weh di apasl dehn mi-di du. ");
INSERT INTO bzj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Aal di bileeva dehn kip tugeda ahn shayr evriting weh dehn mi ga wid wan anada. ");
INSERT INTO bzj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Dehn sel dehn lan ahn ada ting dehn weh dehn mi oan, ahn dehn gi di moni weh dehn mi geh fahn it tu aala dehn wan weh mi need. ");
INSERT INTO bzj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Evri day dehn meet da di templ ahn dehn eet da wan anada hows. Dehn mi hapi fi shayr dehn food ahn dehn mi feel gud eena dehn haat bowt wan anada. ");
INSERT INTO bzj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Dehn mi-di prayz Gaad, ahn ada peepl mi laik si di way how dehn mi-di liv. Ahn evri day di Laad ad aan moa ahn moa peepl weh mi-di geh sayv. ");
INSERT INTO bzj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wahn day, Peeta ahn Jan mi gwehn eena di templ rong chree aklak di aftanoon, weh da mi di set taim fi pray. ");
INSERT INTO bzj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Now dehn mi ga wahn man weh mi kripl fahn di taim ih mi baan. Evri day peepl doz kehr ahn da di templ gayt, weh mi nayhn di Byootiful Gayt, soh dat ih kuda bayg fahn evribadi weh goh eena di templ. ");
INSERT INTO bzj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wen di man si Peeta ahn Jan di kom een, ih aks dehn fi wahn lee moni. ");
INSERT INTO bzj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peeta ahn Jan luk schrayt pan ahn. Den Peeta seh, “Luk pahn wi!” ");
INSERT INTO bzj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Soh di man gi dehn ih ful atenshan. Ih mi-di luk owt fi wahn lee sohnting eena ih han. ");
INSERT INTO bzj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Den Peeta seh, “Ah noh ga no moni, bot weh Ah gat, Ah wahn gi yu. Eena di naym a Jeezas Krais fahn Nazaret, get op ahn waak!” ");
INSERT INTO bzj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Peeta hoal ahn bai ih rait han ahn help ahn op. Sayhn taim di man fut ahn ih ankl geh schrang. ");
INSERT INTO bzj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Di man jomp op ahn staat tu waak. Den ih fala dehn eena di templ, di waak, di jomp op, ahn di prayz Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wen evribadi weh mi dehdeh si di man di waak ahn di prayz Gaad, ");
INSERT INTO bzj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","dehn rekonaiz ahn, ahn seh, “Dat da noh di sayhn man weh yoostu bayg da di Byootiful Gayt?” Wel, dehn kudn bileev dehn aiy ahn oanli mi fraitn wen dehn si weh mi hapm tu ahn. ");
INSERT INTO bzj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Di man weh yoostu bayg grab aan tu Peeta ahn Jan. Di ada peepl dehn mi fraitn ahn ron kohn si weh mi-di goh aan da di plays weh dehn kaal Salaman Varanda. ");
INSERT INTO bzj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Wen Peeta si dis, ih aks dehn seh, “Unu peepl a Izrel, da wai dis sopraiz unu soh? Unu dehdeh di stayr pahn wi laik if wee du dis eena fi wee oan powa, er laik wee soh hoali dat wee mek dis man waak. ");
INSERT INTO bzj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","No! Da Gaad du dat. Hihn da di Gaad a Aybraham, ahn Aizak ahn Jaykop, ahn ih da fi wee ada ansesta dehn Gaad tu. Hihn du dis fi bring gloari tu ih Servant Jeezas. Unu mi waahn ih ded; unu disoan ahn fronta Pailat, di Roaman govna, eevn wen hihn mi disaid fi let ahn goh. ");
INSERT INTO bzj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Da unu sayhn wan disoan sohnbadi weh hoali ahn raichos, ahn unu aks fi dehn free wahn merdara. ");
INSERT INTO bzj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Unu kil di Wan weh mek laif, bot Gaad rayz ahn op fahn di ded. Wee da witnis tu dat. ");
INSERT INTO bzj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Dis man weh unu noa ahn weh unu si ya put ih fayt eena Jeezas, ahn dat mek ahn schrang. Da fayt eena Jeezas naym da weh mek dis man geh heel rait fronta unu. ");
INSERT INTO bzj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Now brejrin, Ah noa seh unu ahn unu leeda dehn neva andastan weh unu mi-di du wen unu kil Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bot fahn way way bak Gaad mi tel di prafit dehn dat dis mi wahn hapm, dat ih Krais mi hafu sofa! Ahn di veri ting weh Gaad mi seh mi kohn chroo fi chroo. ");
INSERT INTO bzj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Soh unu mos ton fahn unu sin dehn ahn ton tu Gaad soh dat Gaad ku waip owt unu sin dehn. Den, sayka weh Gaad deh wid unu, hihn wahn poar blesin pahn unu fi rifresh unu ahn hihn wahn sen Jeezas, weh da di Krais weh Gaad ih oanself mi pik owt fi unu. ");
INSERT INTO bzj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Bot Jeezas wahn stay da hevn til di taim kohn fi mek evriting nyoo. Gaad mi anonks dis chroo ih hoali prafit dehn fahn way bak yaanda. ");
INSERT INTO bzj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moaziz mi seh, ‘Di Laad unu Gaad wahn sen wahn prafit rait fahn monks unu jos laik how ih sen mee. Unu fi du evriting weh ih tel unu fi du.’ ");
INSERT INTO bzj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ahn den ih seh, ‘Enibadi weh noh obay da prafit wahn geh kot aaf fahn Gaad peepl dehn ahn geh dischrai.’ ");
INSERT INTO bzj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ahn aala di prafit dehn weh mi taak fi Gaad, fahn Samwel rait dong tu dehn wan weh kohn afta hihn, aala dehn mi taak bowt dehn taim ya. ");
INSERT INTO bzj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ahn now unu da di peepl weh da di disendant dehn a dehn prafit. Ahn wen Gaad mek wahn agreement fi tek kayr a fi wi ansesta dehn, ih pramis fi tek kayr a unu tu. Gaad tel Aybraham seh, ‘Ah wahn bles aala di peepl dehn eena di werl chroo fi unu disendant dehn.’ ");
INSERT INTO bzj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Soh Gaad pik ih Servant Jeezas, ahn sen ahn tu unu, di Jooish peepl fos, soh dat ih ku bles unu enitaihn unu disaid fi ton unu bak pahn unu wikid wayz.” ");
INSERT INTO bzj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peeta ahn Jan mi-di taak tu di peepl dehn wen sayhn taim di prees dehn, di kyaptin a di templ gyaad dehn, ahn di Sadyusee dehn kom op tu dehn. ");
INSERT INTO bzj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Dehn mi oanli beks bikaa di apasl dehn mi-di teech di peepl dehn, dat sayka weh Jeezas mi kohn bak fahn di ded, dat proov seh dat di ded wahn rayz op bak tu. ");
INSERT INTO bzj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Dehn ares Peeta ahn Jan, bot bikaa da mi eevnin, dehn chroa dehn eena jayl til maanin. ");
INSERT INTO bzj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bot lata dehn weh mi yehr dis mesij mi bileev. Bai dis taim, di apasl dehn mi don ga bowt faiv towzn man eena dehn groop. ");
INSERT INTO bzj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Di neks day, di cheef prees dehn ahn di Jooish leeda dehn, ahn di teecha dehn a di Jooish Laa dehn meet da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas di hai prees mi dehdeh, lang wid Kaiyafas ahn Jan ahn Alegzanda, ahn di ada big taim man dehn weh da-mi paat a di hai prees faamli. ");
INSERT INTO bzj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dehn bring Peeta ahn Jan fronta dehn ahn staat kweschan dehn seh, “Da weh kaina powa unu yooz, ahn eena hoofa naym unu di du aala dis?” ");
INSERT INTO bzj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Peeta mi ful op wid di Hoali Spirit ahn ih tel di membaz a di Jooish Kongsl ahn di Jooish leeda dehn seh, ");
INSERT INTO bzj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“If unu waahn kweschan wi tudeh bowt di gud weh wi du fi di kripl man, ahn waahn noa how ih geh heel, ");
INSERT INTO bzj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","den unu ahn evribadi eena Izrel beta noa dis: Wai dis man stan op fronta unu gud gud-wan da sayka di powa weh deh eena di naym a Jeezas fahn Nazaret. Unu kroosifai ahn, bot Gaad rayz ahn op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jeezas da di Wan weh di Skripcha mi-di taak bowt wen ih seh, ‘Dis stoan weh unu bilda dehn neva tink mi wot notn, ton owt fi bee di moas impoatant wan owta aala dehn.’ ");
INSERT INTO bzj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Unu kyaahn fain salvayshan eena nobadi els eksep Jeezas! Gaad neva giv no ada naym disya said a hevn weh peepl ku kaal pan fi geh sayv!” ");
INSERT INTO bzj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wen dehn si how Peeta ahn Jan neva frayd fi dehn ataal, ahn dehn si dat dehn da-mi jos aadineri peepl, dehn mi sopraiz ahn dehn mi hafu agree dat dehn da-mi Jeezas falowaz fi chroo. ");
INSERT INTO bzj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Di proof a it mi deh rait fronta dehn aiy. Di man weh Peeta ahn Jan mi heel mi-di stan op rait fronta dehn, soh dehn shet op dehn mowt. ");
INSERT INTO bzj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Di Jooish Kongsl tel Peeta ahn Jan fi goh owtsaid soh dehn ku disaid weh fi du. ");
INSERT INTO bzj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Dehn aks wan anada, “Da weh wi wahn du wid dehnya man? Evribadi weh liv da Jeroosalem noa seh dat wahn mirakl mi tek plays, ahn wee hafu agree wid dat. ");
INSERT INTO bzj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bot fi stap dis weh hapm fahn spred rong, wi beta waan dehn man ya dat wee noh waahn yehr dehn seh notn tu nobadi agen eena Jeezas naym.” ");
INSERT INTO bzj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Soh dehn kaal dehn een ahn aada dehn noh fi teech er preech eena Jeezas naym agen. ");
INSERT INTO bzj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bot Peeta ahn Jan tel dehn seh, “Unu joj fi unuself; unu tink seh eena Gaad sait ih beta fi obay man er Gaad? ");
INSERT INTO bzj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wi kyaahn help wiself. Wee hafu taak bowt weh wi si wid wi oan too aiy, ahn weh wi yehr wid wi oan too ayz.” ");
INSERT INTO bzj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dehn chretn Peeta ahn Jan sohn moa, ahn den dehn let dehn goh. Di Kongsl neva noa how fi ponish dehn, sayka weh aala di peepl dehn mi-di prayz Gaad fi di mirakl weh dehn mi si hapm. ");
INSERT INTO bzj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Di man weh Gaad mi du di mirakl fa mi oava faati yaaz oal. ");
INSERT INTO bzj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Peeta ahn Jan gaahn bak da dehn groop ahn dehn tel dehn weh di cheef prees dehn ahn di Jooish leeda dehn mi seh. ");
INSERT INTO bzj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wen dehn yehr, aala dehn staat tu pray haad haad-wan tu Gaad ahn seh, “Gaad, da yoo mek hevn, ahn di ert, ahn di see, ahn evriting weh deh eena it. Yoo da di baas a evriting. ");
INSERT INTO bzj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Dis da weh yu mi tel wi bai di Hoali Spirit chroo yu servant, wi grayt-grayt-grayt-granfaada Dayvid: ‘Da weh di peepl dehn di kik op soh fa? Ahn wai dehn plan aal kaina wikidnis weh kyaahn werk? ");
INSERT INTO bzj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Dehn king ahn dehn roola a di werl dehn set dehnself gens di Laad Gaad ahn di Wan weh ih mi pik.’ ");
INSERT INTO bzj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Herod ahn Ponchos Pailat mi akchwali put hed tugeda gens Jeezas rait ya eena dis siti wid wi oan Jooish peepl dehn, ahn dehn wan weh da noh Joo. Jeezas da yu Hoali Servant, weh yoo mi pik fi bee di Krais. ");
INSERT INTO bzj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Dehn mi-di du egzakli weh yoo mi don disaid fi hapm fahn bifoa taim. Yoo ku disaid dat kaa yoo ga di powa. ");
INSERT INTO bzj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Now Laad, luk how dehn di chretn wi noh! Gi wee, yu hombl servant dehn, lata korij fi preech yu Werd. ");
INSERT INTO bzj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Schrech owt yu han fi heel ahn du mirakl ahn wandaful tingz eena di naym a yu Hoali Servant Jeezas, soh dat peepl ku si yu powa.” ");
INSERT INTO bzj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Den wen dehn finish pray, di plays weh dehn mi deh eena staat tu shayk. Aala dehn geh ful op wid di Hoali Spirit, ahn dehn staat tu preech di Werd a Gaad, ahn dehn neva feel frayd ataal. ");
INSERT INTO bzj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Di bileeva dehn mi ga wan haat ahn main. Nobadi neva seh dat weh dehn oan da fi dehn wan, bot dehn shayr evriting weh dehn mi ga wid wan anada. ");
INSERT INTO bzj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Wid lata powa, di apasl dehn mi-di tel evribadi bowt how di Laad Jeezas kohn bak fahn di ded. Ahn Gaad mi-di poar owt blesin afta blesin pahn aala dehn. ");
INSERT INTO bzj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nobadi eena di groop mi need notn. Dehn wan weh oan lan ahn hows wuda sel dehn ahn bring di moni fahn di sayl, ");
INSERT INTO bzj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ahn gi di apasl dehn. Ahn dehn wuda ton rong ahn shayr op di moni soh dat evribadi geh weh dehn need. ");
INSERT INTO bzj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Dehn mi ga dis wan man nayhn Joazef weh mi kohn fahn di chraib a Leevai. Hihn mi baan eena di konchri a Saipros. Di apasl dehn kaal ahn Baanabas (weh meen “sohnbadi weh inkorij ada peepl.”) ");
INSERT INTO bzj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Hihn sel wahn pees a lan weh ih oan, ahn bring di moni kohn gi di apasl dehn. ");
INSERT INTO bzj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Now wahn neks man weh nayhn Ananaiyas, ahn ih waif Safaira, mi sel wahn pees a lan tu. ");
INSERT INTO bzj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Bot hihn kip bak paat a di moni fi ihself, ahn bring di res, laik if dat da di hoal a it, ahn gi di apasl dehn. Ih waif mi wel ahn noa weh ih mi-di du tu. ");
INSERT INTO bzj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Den Peeta tel ahn seh, “Ananaiyas, luk how yu mek di devl rab yu soal! Yu tel di Hoali Spirit wahn lai afta yu kip bak som a di moni fi yuself weh yu sel di lan fa. ");
INSERT INTO bzj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Di lan neva bilangz tu yoo fahn di fos staat? Ahn wen yu don sel it, di moni da neva stil fi yoo wan? Da wai yu disaid fi du wahn ting laik dis? Yu noh oanli di lai tu man bot yu di lai tu Gaad tu!” ");
INSERT INTO bzj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Wen Ananaiyas yehr dis, ih jrap dong ded! Aala di peepl dehn mi fraitn no miks wen dehn yehr weh hapm. ");
INSERT INTO bzj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Den sohn yong man dehn kohn ahn rap op di badi ahn kehr ahn gaahn beri ahn. ");
INSERT INTO bzj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bowt chree owaz layta, Ananaiyas waif kom een. Shee neva noa weh mi hapm ataal. ");
INSERT INTO bzj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peeta aks ahn seh, “Tel mi sohnting, dat da aala di moni weh yoo ahn yu hozban geh fi di lan?” Ih seh, “Oa yes, dat da aala di moni!” ");
INSERT INTO bzj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peeta seh tu ahn, “How di too a unu ku agree fi lai tu di Spirit a Gaad ahn tink seh unu ku get weh wid it? Luk ya! Di man dehn weh beri yu hozban deh rait ya da di doa, ahn dehn wahn kehr yoo owt tu!” ");
INSERT INTO bzj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sayhn taim Safaira jrap dong ded da Peeta fut! Den di yong man dehn kom een ahn fain ahn ded. Dehn kehr ahn owt ahn beri ahn saida ih hozban. ");
INSERT INTO bzj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Evribadi eena di cherch, ahn evribadi els weh yehr bowt weh mi hapm, mi frayd fi weh Gaad ku du. ");
INSERT INTO bzj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Di apasl dehn mi-di du wahn lata mirakl ahn wandaz fahn Gaad monks di peepl dehn. Aal di bileeva dehn mi-di meet tugeda laik wan famili da wahn plays weh dehn kaal Salaman Varanda. ");
INSERT INTO bzj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ada peepl mi frayd fi meet op wid dehn deh, eevn doa dehn rispek dehn. ");
INSERT INTO bzj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","In spait a dat, moa ahn moa man ahn uman bileev eena di Laad ahn jain dehn. ");
INSERT INTO bzj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sayka weh di apasl dehn mi-di du, di peepl dehn mi-di kip aan di bring dehn sik owt pahn schreet. Dehn bring dehn pahn bed ahn mat soh dat at lees Peeta shado kuda paas oava som a dehn. ");
INSERT INTO bzj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wahn lata peepl mi-di flak deh fahn di tong dehn rong Jeroosalem. Ahn dehn mi-di bring dehn sik, ahn aala dehn wan weh ga eevl spirit, ahn aala dehn mi geh heel. ");
INSERT INTO bzj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Den di hai prees ahn aal ih kompni dehn, weh da paat a di Sadyusee groop, mi oanli jelos bad. ");
INSERT INTO bzj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Dehn ares di apasl dehn ahn hib dehn eena di siti jayl. ");
INSERT INTO bzj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Bot joorin di nait wahn aynjel fahn Gaad kohn oapm di doa a di jayl ahn bring dehn owt. Afta ih bring dehn owt, ih tel dehn seh, ");
INSERT INTO bzj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Unu goh, stan op eena di templ ahn tel di peepl dehn evriting bowt dis nyoo way a livin.” ");
INSERT INTO bzj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Wen day mi-di brok, dehn gaahn da di templ laik weh di aynjel tel dehn, ahn staat tu teech di peepl deh. Wen di hai prees ahn aal ih kompni dehn kohn neks maanin, dehn kaal op wahn meetn wid aala di Jooish leeda dehn ahn di Jooish Kongsl, ahn den dehn sen da di jayl fi di apasl dehn. ");
INSERT INTO bzj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bot wen di aafisa dehn reech da di jayl, di apasl dehn neva dehdeh! Dehn gaahn bak ");
INSERT INTO bzj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ahn seh, “Wi fain di jayl lak op gud gud, wid di gyaad dehn di stan op da di doa, bot wen wi oapm di doa, nobadi neva deh eensaid!” ");
INSERT INTO bzj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wen dehn yehr dis, di hed a di templ polees ahn di cheef prees dehn mi-di wanda weh aal wahn kom owta dis! ");
INSERT INTO bzj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Den sohnbadi kohn ahn seh, “Wach ya! Di man dehn weh unu put eena jayl, dehn deh eena di templ di teech di peepl dehn.” ");
INSERT INTO bzj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Di hed a di templ polees, wid ih gyaad dehn, gaahn fi di apasl dehn, ares dehn agen, ahn kehr dehn bak. Dehn mek shoar seh dat dehn neva yooz no foas bikaa dehn frayd di peepl dehn wuda stoan dehn. ");
INSERT INTO bzj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Dehn bring di apasl dehn fronta di Jooish Kongsl fi mek di hai prees kweschan dehn. Dehn seh, ");
INSERT INTO bzj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Wi neva gi unu schrik aadaz noh fi teech eena di naym a Jeezas? Stilyet, unu gaahn hed ahn preech eena da naym, ahn aala Jeroosalem yehr weh unu ga fi seh, ahn unu mek ih luk laik da wee kil Jeezas. Soh now da wee gilti den?” ");
INSERT INTO bzj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peeta ahn di ada apasl dehn seh, “Wee hafu obay Gaad, noh man. ");
INSERT INTO bzj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Unu mek dehn kil Jeezas wen unu heng ahn pahn da chree, bot di sayhn Gaad weh fi wee grayt-grayt-grayt-granfaada dehn doz wership rayz ahn op fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Gaad rayz ahn rait op ahn put ahn pahn ih rait han said fi bee Prins ahn Sayvya, soh dat hihn ku gi di Jooish peepl dehn di chaans fi chaynj dehn wayz soh dat hihn ku fagiv dehn sin. ");
INSERT INTO bzj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wee ahn di Hoali Spirit, weh Gaad gi tu evribadi weh obay ahn, da witnis tu dehndeh ting dehn.” ");
INSERT INTO bzj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wen di membaz a di Kongsl yehr dis, dehn mi soh beks dat dehn mi waahn kil di apasl dehn rait dehsoh. ");
INSERT INTO bzj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bot wahn Farisee nayhn Gamalyel weh teech di Laa, ahn weh evribadi rispek, stan op fi taak. Ih tel dehn fi mek di apasl dehn goh owtsaid fi wahn lee wail. ");
INSERT INTO bzj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ih tel di Kongsl, “Unu man a Izrel, unu shuda kyaaful how unu handl dehndeh man. ");
INSERT INTO bzj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Unu memba da man Toodas weh mi kohn pahn di seen? Hihn mi tink hihn soh big, ahn bowt foa honjrid man fala ahn. Bot hihn mi geh kil, aala ih man dehn mi skyata, ahn ih hoal moovment gaahn tu notn. ");
INSERT INTO bzj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Afta dat, joorin di taim a di sensos, Joodas fahn Gyalilee kohn pahn di seen. Hihn mi leed wahn krowd fi chrai fi oavachroa di govament. Bot hihn anaal geh kil, ahn fi hihn falowaz skyata tu. ");
INSERT INTO bzj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Soh eena dis kays ya, fi mee advais tu unu da fi unu noh tek no akshan ataal. Lef dehn loan, ahn mek dehn goh bowt dehn bizniz. If weh dehn di plan er weh dehn di du kohn fahn man, ih noh wahn kohn tu notn. ");
INSERT INTO bzj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bot if ih kohn fahn Gaad, unu wahn kyaahn stap dehn ahn unu wahn fain unuself di fait gens Gaad.” ");
INSERT INTO bzj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Di Kongsl disaid fi fala di advais weh Gamalyel gi dehn. Dehn kaal een di apasl dehn, beet dehn, ahn aada dehn noh fi taak bowt Jeezas nohmoh. Den dehn let dehn goh. ");
INSERT INTO bzj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Afta di apasl dehn lef di Jooish Kongsl, dehn mi hapi bikaa dehn sofa shaym fi sayka Jeezas. Dehn mi feel gud dat Gaad pik dehn fi sofa fi hihn. ");
INSERT INTO bzj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ahn evri day dehn goh da di templ, ahn fahn hows tu hows, ahn dehn kantinyu fi teech di peepl dehn ahn preech dis mesij: “Jeezas da di Krais weh unu di luk fa!” ");
INSERT INTO bzj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sohn taim layta, az di nomba a bileeva dehn geh moa ahn moa, wahn kwaaril staat monks di peepl dehn. Dehn wan weh taak Greek komplayn gens di Jooz dehn fahn deh. Di Greek wan dehn mi-di seh dat fi dehn wido dehn neva mi-di geh fi dehn amonk a food weh dehn fi geh evri day. ");
INSERT INTO bzj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Soh di twelv apasl kaal di hoal groop a bileeva dehn tugeda ahn seh, “Ih noh rait fi wee niglek fi preech di Werd a Gaad sayka di luk afta food. ");
INSERT INTO bzj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Soh den, mi brejrin, pik owt sebm man fahn monks unu weh unu noa ful a di Hoali Spirit ahn ga lata gud sens, ahn wi wahn put dehn in chaaj a dis hoal bizniz. ");
INSERT INTO bzj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Den wee wahn ga moa taim fi pray ahn preech.” ");
INSERT INTO bzj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dis mi mek sens tu evribadi, soh dehn pik owt Steeven, wahn man weh mi ga lata fayt ahn ful a di Hoali Spirit. Neks dehn pik Filip, Prokorus, Nikano, Timon, Parmeenas, ahn Nikolas, fahn di tong a Antiyak. (Hihn da neva wahn Joo fos, bot ih mi jain di Jooish rilijan bifoa ih bileev eena Jeezas.) ");
INSERT INTO bzj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Dehn bring dehn fronta di apasl dehn, ahn di apasl dehn pray fi dehn ahn put dehn han pahn dehn ahn bles dehn. ");
INSERT INTO bzj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Soh di mesij a Gaad kantinyu fi spred. Moa ahn moa peepl rong Jeroosalem staat tu bileev di Gud Nyooz bowt Jeezas Krais, ahn wahn lata di Jooish prees dehn staat tu bileev tu. ");
INSERT INTO bzj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Steeven da-mi wahn man weh Gaad mi oanli bles, ahn ih mi ga di powa a Gaad fi du aal kaina mirakl ahn wandaz monks di peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bot dehn mi ga sohn man weh mi deh gens ahn. Dehn mi kohn fahn wahn Jooish sinagag weh mi nayhn Cherch a di Free Slayv. Dehn da-mi Jooz fahn Saireen, Alegzanjriya, Silisya, ahn di dischrik a Aysha. Dehn mi-di aagyu wid Steeven bowt weh ih mi-di teech. ");
INSERT INTO bzj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Bot di Spirit mi gi Steeven di karek werd dehn fi seh, ahn dat shet dehn rait op. ");
INSERT INTO bzj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Soh dehn braib sohn man fi seh, “Wee yehr hihn di taak gens Moaziz ahn gens Gaad.” ");
INSERT INTO bzj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Wen dehn seh dat now, dehn get evribadi beks—di peepl dehn, di Jooish leeda dehn, ahn di teecha dehn a di Jooish Laa. Dehn ares Steeven ahn kehr ahn fronta di Jooish Kongsl. ");
INSERT INTO bzj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Di witnis dehn weh mi-di tel lai seh, “Dis man aalwayz taak gens fi wi hoali templ ahn gens Moaziz Laa. ");
INSERT INTO bzj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Wi yehr ahn seh dat dis Jeezas weh kohn fahn Nazaret wahn tayr dong di templ ahn chaynj aala di rilijos wayz weh kohn dong fahn Moaziz tu wee!” ");
INSERT INTO bzj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Den aala dehn eena di Kongsl staat tu stayr pahn Steeven bikaa ih fays mi-di shain laik wahn aynjel. ");
INSERT INTO bzj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Di hai prees aks Steeven, “Aala dehn ting weh dehn di seh gens yu da chroo?” ");
INSERT INTO bzj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Steeven ansa ahn seh, “Aala unu faadaz ahn bradaz, lisn tu mi. Bifoa wi grayt-grayt-grayt-granfaada Aybraham gaahn gaahn liv da Haran, Gaad apyaa fronta ahn eena aala ih gloari da Mesopotaymya ahn seh, ");
INSERT INTO bzj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Lef yu faamli ahn yu konchri ahn goh da di lan weh Ai wahn shoa yu.’ ");
INSERT INTO bzj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Ahn da soh Aybraham pik op, lef weh ih mi-di liv da Kaldeeya ahn gaahn liv way da Haran. Afta Aybraham pa ded, Gaad mek ih moov tu dis lan ya weh unu liv now. ");
INSERT INTO bzj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Gaad neva gi Aybraham rait deh ahn den notn fi ihself, nat eevn wahn fut a lan, bot Gaad did pramis fi gi ahn di lan eena di fyoocha weh wahn bee fi hihn ahn ih pikni, ahn ih pikni pikni dehn dong di lain. Wen Gaad mek da pramis, Aybraham neva ga no pikni. ");
INSERT INTO bzj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dis da weh Gaad tel ahn: ‘Yu disendant dehn wahn ton schraynja eena wahn konchri weh da noh fi dehn. Ahn fi foa honjrid yaaz dehn wahn bee slayv, ahn di peepl eena da konchri wahn oanli chreet dehn bad. ");
INSERT INTO bzj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Bot Ah wahn ponish di nayshan weh tek dehn fi slayv, ahn den aftawodz dehn wahn lef da konchri ahn wership mi rait ya da Jeroosalem.’ ");
INSERT INTO bzj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Den Gaad gi Aybraham di serimoni weh nayhn serkomsizhan fi wahn sain seh ih mek wahn agreement wid ahn. Soh Aybraham serkomsaiz Aizak ayt dayz afta ih baan. Aizak serkomsaiz fi hihn son, Jaykop, ahn Jaykop serkomsaiz fi hihn twelv son dehn, weh da-mi fi wee faymos grayt-grayt-grayt-granfaada dehn weh staat fi wee Jooish rays. ");
INSERT INTO bzj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jaykop son dehn mi jelos dehn yonga breda Joazef, ahn dehn sel ahn fi slayv da Eejip. Bot Gaad mi deh wid ahn, ");
INSERT INTO bzj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ahn bring ahn sayf chroo aala ih chroblz. Soh wen Joazef kohn fronta Fayro, weh da-mi di king a Eejip, di king mi laik ahn fi ih wayz ahn di wizdom weh Gaad gi ahn. Soh di king mek Joazef ton govna oava di hoal konchri ahn oava ih hoal hows. ");
INSERT INTO bzj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Den wahn famin kohn pahn Eejip ahn Kaynan. No food neva deh. Wi ansesta dehn mi-di sofa bikaa dehn kudn fain no food. ");
INSERT INTO bzj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Wen Jaykop yehr seh dat Eejip mi ga food, ih sen ih son dehn, weh da fi wee ansesta dehn, pahn dehn fos vizit deh. ");
INSERT INTO bzj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Da pahn dehn sekant vizit, Joazef mek dehn noa seh dat hihn da-mi dehn breda, ahn soh Fayro kohn fi noa seh dat Joazef mi ga faamli. ");
INSERT INTO bzj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Soh Joazef sen wahn mesij tu ih pa, Jaykop, fi tel hihn ahn aal ih faamli, semti-faiv a dehn in aal, fi kohn da Eejip. ");
INSERT INTO bzj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Soh Jaykop gaahn da Eejip gaahn liv, ahn hihn ahn ih son dehn ded rait deh. ");
INSERT INTO bzj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Dehn kehr dehn badi bak da Shekem, ahn dehn beri dehn deh eena wahn grayv weh Aybraham mi bai fahn Hamor famili fi wahn sertn amonk a moni. ");
INSERT INTO bzj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Wen di taim mi-di kohn kloas fi Gaad kip ih pramis weh ih mi mek tu Aybraham, di nomba a fi wi peepl da Eejip mi don groa big. ");
INSERT INTO bzj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Lang laas wahn king weh neva noa Joazef ataal mi-di rool da Eejip. ");
INSERT INTO bzj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Hihn chrik fi wee peepl dehn ahn mi kruwil tu dehn. Ih foas dehn fi put dehn baybi owta doa, ahn lef dehn deh fi ded. ");
INSERT INTO bzj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Da rong dis sayhn taim Moaziz mi baan. Hihn da-mi wahn priti baybi eena Gaad sait. Ih ma ahn pa tek kayr a ahn hoam fi chree monts, ");
INSERT INTO bzj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ahn den wen dehn mi hafu put ahn owta di hows, Fayro daata adap ahn, ahn bring ahn op laik da fi shee oan pikni. ");
INSERT INTO bzj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Di Eejipshan dehn teech Moaziz evriting weh dehn mi noa, ahn ih mi powaful eena weh ih seh ahn weh ih du. ");
INSERT INTO bzj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Wen Moaziz mi faati yaaz oal, ih disaid fi fain owt da weh kaina chreetment ih Izrelait peepl dehn mi-di get. ");
INSERT INTO bzj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ih si how wahn Eejipshan mi-di chreet wan a dehn bad, soh ih jomp een fi tek paat far ahn, ahn ih kil di Eejipshan. ");
INSERT INTO bzj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Hihn mi tink seh fi hihn oan peepl mi wahn riyalaiz bai dis dat hihn da-mi di man weh Gaad sen fi set dehn free fahn slayvri. Bot ih neva luk laik dehn mi andastan. ");
INSERT INTO bzj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Di neks day ih si too Izrelait di fait, ahn ih chrai fi mek pees bitween dehn. Ih seh, ‘Lisn man, di too a unu da Izrelait. Da wai unu di fait laik dis?’ ");
INSERT INTO bzj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Bot di wan weh mi-di beet op di neks wan shub Moaziz wan said ahn aks, ‘Da hoo mek yoo roola ahn joj oava wee? ");
INSERT INTO bzj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Yu waahn kil mee tu, jos laik how yu kil di Eejipshan yestudeh?’ ");
INSERT INTO bzj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Wen Moaziz yehr dis, ih ron fahn Eejip ahn gaahn gaahn liv az wahn aylyan da Midiyan. Dehsoh ih mi ga too bwai pikni. ");
INSERT INTO bzj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Afta faati yaaz paas, wahn aynjel kohn tu Moaziz eena di faiya a wahn bush weh mi-di bon eena di dezert kloas tu di mongtin weh nayhn Sainai. ");
INSERT INTO bzj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Wen Moaziz si aala dis, ih mi-di wanda weh mi-di goh aan. Soh ih gaahn kloasa tu di bush fi si lee beta ahn ih yehr di Laad Gaad vais seh, ");
INSERT INTO bzj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mee da di Gaad a yu grayt-grayt-grayt-granfaada dehn, di Gaad a Aybraham ahn Aizak ahn Jaykop.’ Moaziz chrimbl weh ih soh fraitn ahn ih neva eevn waahn luk. ");
INSERT INTO bzj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Di Laad Gaad seh tu ahn, ‘Tek aaf yu sandalz bikaa dis plays weh yu di stan op pan da hoali grong. ");
INSERT INTO bzj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ah si di kruwilnis ahn di sofarin weh mi peepl gaahn chroo da Eejip. Ah yehr dehn groanin an Ah kohn dong fi set dehn free. Kohn now, Ah wahn sen yu da Eejip.’ ");
INSERT INTO bzj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Wel, dis Moaziz da di sayhn wan weh di peepl a Izrel rijek. Dehn mi aks ahn seh, ‘Da hoo mek yoo roola ahn joj oava wee?’ Hihn da di wan weh Gaad sen fi rool di peepl dehn ahn set dehn free wid di help a di aynjel weh mi kohn tu ahn eena di bush weh mi-di bon. ");
INSERT INTO bzj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Da hihn leed di peepl dehn owta Eejip az ih du miraklz ahn wandaz da Eejip, ahn da di Red See, ahn fi faati yaaz eena di dezert. ");
INSERT INTO bzj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Dis da di sayhn Moaziz weh seh tu di peepl a Izrel, ‘Gaad wahn sen unu wahn prafit, jos laik how ih sen mee, ahn dis prafit wahn kohn rait fahn monks unu.’ ");
INSERT INTO bzj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moaziz da di sayhn wan weh mi deh wid di peepl a Izrel eena di dezert. Hihn mi deh rait deh wid di aynjel weh mi taak tu ahn pahn Mongt Sainai. Moaziz mi deh wid wi ansesta dehn wen Gaad gi ahn di komanment dehn weh gi laif fi paas aan tu wi. ");
INSERT INTO bzj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Bot wi ansesta dehn mi rifyooz fi obay Moaziz, ahn dehn shub ahn wan said ahn mi waahn goh bak da Eejip. ");
INSERT INTO bzj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Soh dehn seh tu Ayron, ‘Mek sohn gaad fi wi weh ku leed wi bikaa wee noh noa weh hapm tu da Moaziz hihn, weh bring wi owta Eejip.’ ");
INSERT INTO bzj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Da den dehn mek wahn aidal wid dehn oan han eena di shayp a wahn yong bul ahn aafa sakrifais tu ahn, ahn den dehn ga wahn big paati fi wership ahn. ");
INSERT INTO bzj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Soh Gaad ton ih bak pahn dehn ahn ih lef dehn loan fi mek dehn wership weh dehn waahn. Soh dehn staat tu wership di staarz eena di skai. Dis da weh di prafit dehn di taak bowt wen dehn seh: ‘Peepl a Izrel, da neva fi mee unu mi kil ahn sakrifais dehn animal fi faati yaaz eena di dezert. ");
INSERT INTO bzj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Insteda kehr fi mee tent, unu kehr di tent fi di gaad Molok, ahn di stachu a Refan da-mi unu staar gaad. Dehndeh da-mi di aidal dehn weh unu mi mek fi wership. Soh Ah wahn sen unu weh fahn unu oan konchri,’ eevn ferda dan Babilan.” ");
INSERT INTO bzj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Steeven gaan aan fi seh, “Wen fi wee ansesta dehn mi deh eena di dezert, dehn mi ga di tent lang wid dehn weh Gaad mi deh eena. Dehn mi mek it jos laik how Gaad shoa Moaziz, wid di sayhn patan weh Gaad mi shoa ahn. ");
INSERT INTO bzj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Laytaraan, Jashwa mi leed fi wi ansesta dehn fi kyapcha di lan fahn di ada nayshan dehn. Fi wee peepl dehn tek oava di lan afta Gaad jraiv owt di peepl dehn weh liv deh. Dehn kehr dis sayhn tent wid dehn da di nyoo lan, ahn dat stay deh til King Dayvid taim. ");
INSERT INTO bzj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dayvid mi pleez Gaad, soh ih aks Gaad fi mek hihn bil wahn hows fi Gaad. Da mi di sayhn Gaad weh Jaykop wership. ");
INSERT INTO bzj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Bot da mi Salaman weh en op di bil di hows fi wership Gaad eena. ");
INSERT INTO bzj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Bot di moas hai Gaad noh liv eena hows weh bil wid hyooman han. Az di prafit seh, ");
INSERT INTO bzj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Hevn da fi mee chroan,’ di Laad Gaad seh, ‘Ahn di ert da mi futstool. Da weh kaina hows unu wahn bil fi mee? Weh plays deh fi mee weh Ai kuda liv eena? ");
INSERT INTO bzj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Da noh mee mek aala dehnya ting?’” ");
INSERT INTO bzj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Steeven gaan aan fi seh, “Unu stobant laik myool, ahn unu haat stil wikid. Stik brok eena unu ayz wen ih kohn tu obay weh Gaad seh. Unu aalwayz fait gens di Hoali Spirit jos laik unu grayt-grayt-grayt-granfaada dehn. ");
INSERT INTO bzj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Dehn mi ga eni prafit weh dehn neva chreet laik daag? Dehn kil aala di mesinja dehn weh Gaad sen, weh fahn lang taim mi anonks dat fi hihn Raichos Servant mi-di kohn. Ahn now unu sel ahn owt ahn merda ahn. ");
INSERT INTO bzj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Unu da di wan dehn weh geh Gaad Laa dehn weh kohn dong tu unu chroo aynjel dehn, ahn stilyet unu noh fala it!” ");
INSERT INTO bzj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wen di memba dehn a di Jooish Kongsl yehr weh Steeven mi ga fi seh, dehn geh beks, beks, beks til dehn grain dehn teet weh dehn mi soh beks. ");
INSERT INTO bzj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Bot Steeven mi ful op a di Hoali Spirit. Ih luk op da hevn ahn ih si di braitnis a Gaad ahn ih si Jeezas di stan op pahn di rait han said a Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ih seh, “Luk deh! Ah si hevn oapm op an Ah si Jeezas, di Son a Man, di stan op pahn di rait han said a Gaad.” ");
INSERT INTO bzj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Di memba dehn a di Kongsl kudn tek it, soh dehn staat tu mek naiz ahn kova op dehn ayz wid dehn han. Den aala dehn rosh aata Steeven sayhn taim. ");
INSERT INTO bzj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Dehn chroa ahn owta di siti ahn stoan ahn. Aal di witnis dehn weh mi deh rong gi wahn yong man weh nayhn Saal dehn koat fi hoal. ");
INSERT INTO bzj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Dehn kantinyu fi stoan Steeven wail ih krai owt tu di Laad seh, “Laad Jeezas, tek mi spirit!” ");
INSERT INTO bzj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ih neel dong ahn baal owt haad haad seh, “Laad! Noh mek dis sin kohn gens dehn!” Ih seh dat ahn jrap dong ded. ");
INSERT INTO bzj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ahn Saal mi deh rait deh di injai di hoal ting. Pahn da sayhn day big taim persikyooshan brok owt gens di cherch da Jeroosalem. Aal di bileeva dehn, eksep di apasl dehn, mi skyata aal oava di konchrisaid a Judeeya ahn Samayrya. ");
INSERT INTO bzj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Sohn ada man weh reeli lov Gaad kohn beri Steeven ahn dehn moan far ahn wid haad baalin. ");
INSERT INTO bzj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Bot Saal mi-di chrai fi waip owt aala di bileeva dehn. Ih mi-di goh fahn yaad tu yaad ahn jreg owt di bileeva dehn, man ahn uman, ahn dash dehn eena jayl. ");
INSERT INTO bzj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Di bileeva dehn weh geh skyata gaan aal bowt ahn staat preech di mesij bowt Jeezas Krais evriway. ");
INSERT INTO bzj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip, weh da wan a di bileeva dehn, gaahn dong da wahn siti weh mi deh eena Samayrya, ahn ih mi tel dehn bowt Jeezas, weh da di Krais. ");
INSERT INTO bzj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Wen di peepl dehn si aala di mirakl dehn weh Filip mi-di du, dehn staat tu lisn ahn tek een evriting weh ih mi-di seh. ");
INSERT INTO bzj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Eevl spirit dehn kom owta wahn lata peepl, ahn dehn kom owt di baal. Ahn peepl weh mi paralaiz ahn kripl geh heel. ");
INSERT INTO bzj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Soh evribadi eena da siti mi hapi hapi. ");
INSERT INTO bzj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Eena da sayhn siti, dehn mi ga wahn man nayhn Saiman, weh da-mi wahn oabyaman fi wahn lang taim. Di Samaritan peepl kudn bileev aala di ting dehn weh ih mi-di du wid ih oabya. Sayka dis, hihn mi oanli tink ihself aal hai ahn maiti. ");
INSERT INTO bzj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ahn evribadi eena di siti, rich ahn poa, mi laik gi ahn dehn rispek ahn atenshan. Dehn seh, “Dis man da mosi weh yu kaal ‘Gaad maiti powa!’” ");
INSERT INTO bzj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Di peepl dehn fala ahn bikaa fi lang taim ih mi-di du sohn powaful tingz wid ih oabya weh dehn kudn bileev. ");
INSERT INTO bzj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bot wen dehn yehr weh Filip preech, dehn bileev di Gud Nyooz bowt Gaad kingdom ahn di naym a Jeezas Krais. Ahn Filip baptaiz dehn, man ahn uman! ");
INSERT INTO bzj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Eevn Saiman anaal bileev, ahn afta ih geh baptaiz, ih hich op wid Filip ahn ih kudn bileev ih aiy dehn wen ih si di big mirakl ahn wandaz dehn weh Filip mi-di du. ");
INSERT INTO bzj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nyooz reech di apasl dehn da Jeroosalem seh how di peepl dehn da Samayrya aksep di Werd a Gaad. Soh wen dehn yehr dat, dehn sen Peeta ahn Jan deh. ");
INSERT INTO bzj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wen dehn reech, Peeta ahn Jan pray fi di bileeva dehn dat dehn wuda geh di Hoali Spirit ");
INSERT INTO bzj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","bikaa di Hoali Spirit neva kohn dong pahn non a dehn yet. Dehn mi oanli geh baptaiz eena di naym a di Laad Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Soh Peeta ahn Jan put dehn han pahn di bileeva dehn ahn dehn geh di Hoali Spirit. ");
INSERT INTO bzj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Wen Saiman si dat di Spirit kohn dong pahn di bileeva dehn wen Peeta ahn Jan put dehn han pahn dehn, Saiman aafa dehn moni fi geh disya powa. ");
INSERT INTO bzj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ih seh, “Gi mi di sayhn powa soh dat enibadi weh Ah put mi han pan wahn geh di Hoali Spirit tu.” ");
INSERT INTO bzj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Bot Peeta ansa ahn seh, “Yoo ahn yu moni wahn en op da hel fi di eevn tink seh yu kuda bai dis gif fahn Gaad wid moni! ");
INSERT INTO bzj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yoo noh ga no paat er shayr eena disya werk ya bikaa yu haat noh rait wid Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ton fahn yu wikidnis ahn pray tu di Laad fi fagiv yu fi tink dehn ting. ");
INSERT INTO bzj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ah si seh dat yu oanli red aiy ahn yu da wahn prizna a yu oan sin.” ");
INSERT INTO bzj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Den Saiman seh tu Peeta ahn Jan, “Ah bayg yu, pray tu di Laad fi mi soh dat non a di ting dehn weh yu seh wahn hapm tu mi.” ");
INSERT INTO bzj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Wen Peeta ahn Jan don tel di peepl dehn how dehn mi geh fi noa Jeezas, ahn preech di mesij fahn di Laad, dehn gaahn bak da Jeroosalem. Pahn dehn way bak, dehn preech di Gud Nyooz bowt Jeezas Krais da lata Samaritan vilij. ");
INSERT INTO bzj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Now wahn aynjel fahn di Laad seh tu Filip, “Geh redi ahn goh sowt tu di road weh goh fahn Jeroosalem tu Gaza, weh haadli enibadi eva yooz agen.” ");
INSERT INTO bzj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Soh Filip staat owt, ahn pahn ih way ih meet wahn impoatant ofishal fahn Eetiyopya, weh mi in chaaj a di chrezhri a di kween a Eetiyopya. Dis man mi gaahn da Jeroosalem fi wership Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Pahn ih way hoahn ih mi deh eena ih kehrij di reed di Skripcha weh Aizaiya di oal taim prafit mi rait. ");
INSERT INTO bzj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Di Hoali Spirit tel Filip seh, “Goh oava bai di kehrij ahn ron lang saida it.” ");
INSERT INTO bzj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Soh Filip gaahn ron lang saida di kehrij, ahn ih yehr di man di reed weh Aizaiya mi rait. Filip aks ahn seh, “Yu andastan eniting weh yu di reed?” ");
INSERT INTO bzj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Di ofishal ansa seh, “How Ah wahn andastan if nobadi noh deh fi eksplayn it tu mi?” Soh ih tel Filip fi get eena di kehrij ahn sidong saida ahn. ");
INSERT INTO bzj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Di paat a di Skripcha weh di man mi-di reed da-mi dis paat ya: “Dehn kehr ahn sayhn laik wen dehn di kehr sheep fi kil, ahn jos laik how wahn lam kwaiyet wen dehn di kot aaf ih wul, sayhn way hihn neva oapm ih mowt. ");
INSERT INTO bzj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Eena ih shaym ih neva geh no jostis. Da hoo ku taak bowt ih disendant dehn? Bikaa dehn tek ih laif fahn di ert.” ");
INSERT INTO bzj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Di ofishal ton tu Filip ahn aks ahn seh, “Tel mi noh, da hoo di prafit mi-di taak bowt ya, ihself er bowt sohnbadi els?” ");
INSERT INTO bzj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Soh Filip staat wid di sayhn paat a di Skripcha weh ih mi-di reed ahn tel ahn bowt di Gud Nyooz a Jeezas Krais. ");
INSERT INTO bzj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Az dehn mi-di chravl dong di road, dehn kohn tu sohn waata ahn di ofishal seh, “Wach ya, sohn waata deh ya. Da weh mek yu kyaahn baptaiz mi now?” ");
INSERT INTO bzj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ahn Filip seh, “If yoo bileev wid aal yu haat, yu ku geh baptaiz.” Ahn di ofishal ansa seh, “Ai bileev dat Jeezas Krais da di Son a Gaad.” ");
INSERT INTO bzj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ahn soh ih aada di jraiva fi stap di kehrij ahn di too a dehn gaahn dong eena di waata, ahn Filip baptaiz ahn. ");
INSERT INTO bzj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ahn wen dehn kom op owta di waata, di Spirit a di Laad tek Filip weh sodn-wan. Ahn di ofishal neva si ahn agen, bot ih gaahn pahn ih way oanli hapi! ");
INSERT INTO bzj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Den Filip fain ihself da di siti weh nayhn Azotus, ahn den ih gaan aan di preech di Gud Nyooz a Jeezas Krais eena aala di tong dehn til ih reech Seezareeya. ");
INSERT INTO bzj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Meentaim, Saal stil mi-di chretn Jeezas falowa dehn ahn ih mi waahn kil dehn. Soh ih gaahn da di hai prees, ");
INSERT INTO bzj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ahn aks ahn fi sohn leta fi kehr da di Jooish meetn plays dehn eena Damaskos, fi geh fi dehn help fi ares enibadi weh fala di Way a di Laad Jeezas, weda man er uman, ahn bring dehn da Jeroosalem eena chaynz. ");
INSERT INTO bzj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pahn ih way da Damaskos, az ih mi-di reech di siti, sodn-wan wahn brait lait fahn hevn flash rong ahn! ");
INSERT INTO bzj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saal jrap da grong ahn ih yehr wahn vais weh seh, “Saal, Saal, da wai yu di persikyoot mi?” ");
INSERT INTO bzj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ih aks, “Da hoo yoo, Laad?” Di vais ansa ahn seh, “Ai da Jeezas, di sayhn wan weh yu di persikyoot. ");
INSERT INTO bzj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Now get op ahn goh da di siti ahn yu wahn yehr weh yu hafu du.” ");
INSERT INTO bzj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Di man dehn weh mi-di chravl wid Saal kudn eevn seh notn; dehn stan op deh kudn taak. Dehn yehr di vais bot dehn neva si nobadi. ");
INSERT INTO bzj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saal get op aafa di grong, ahn wen ih oapm ih aiy, ih kudn si notn kaa ih mi blain. Soh dehn leed ahn bai ih han ahn kehr ahn da Damaskos. ");
INSERT INTO bzj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Fi chree dayz Saal kudn si, ahn joorin dis taim ih neva eet er jrink notn. ");
INSERT INTO bzj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Eena Damaskos dehn mi ga wahn bileeva nayhn Ananaiyas. Di Laad kaal ahn eena wahn vizhan seh, “Ananaiyas!” Ih ansa seh, “Yes, Laad.” ");
INSERT INTO bzj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Di Laad tel ahn seh, “Get op ahn goh dong di road da di schreet weh nayhn Schrayt ahn yu wahn reech Joodas hows. Wen yu reech deh, aks fi wahn man nayhn Saal fahn Taasos. Dis sayhn taim ya Saal di pray, ");
INSERT INTO bzj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ahn eena wahn vizhan ih si wahn man nayhn Ananaiyas kom eena di hows, ahn put ih han pan ahn, ahn gi ahn bak ih sait.” ");
INSERT INTO bzj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Wen Ananaiyas yehr dis, ih seh, “Laad, Ai yehr aal kaina ting bowt dis man ahn aala di wikidnis weh ih du tu yu peepl dehn da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ahn now ih deh ya bikaa ih ga paypa fahn di cheef prees dehn fi ares aala di bileeva dehn da Damaskos weh wership yoo!” ");
INSERT INTO bzj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Bot di Laad tel Ananaiyas, “Goh ahn du weh Ah seh bikaa dis man da di wan weh Ai pik fi goh tel peepl weh da noh Joo bowt mi, ahn fi goh fronta king, ahn di peepl a Izrel fi mek dehn noa da hoo mee. ");
INSERT INTO bzj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ahn mee miself wahn shoa ahn humoch ih wahn sofa fi mi.” ");
INSERT INTO bzj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Soh Ananaiyas gaahn da di hows ahn put ih han pahn Saal. Ih seh, “Saal, mi brada, di Laad Jeezas weh apyaa tu yu pahn di road wen yu mi-di kohn, sen mi ya. Ih sen mi soh dat yu ku si agen ahn fi mek yu geh ful op wid di Hoali Spirit.” ");
INSERT INTO bzj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Da sayhn taim, sohnting weh luk laik fish skayl jrap fahn aafa Saal aiy dehn, ahn ih kuda mi si agen! Ih get op ahn geh baptaiz. ");
INSERT INTO bzj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Afta dat ih eet sohnting ahn ih mi feel schrang agen. Saal stay deh da Damaskos fi wahn fyoo dayz wid di ada peepl dehn weh bileev eena Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ih neva ways no taim fi staat preech eena di Jooish meetn plays dehn dat Jeezas da di Son a Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Aala di peepl weh yehr ahn mi sopraiz ahn dehn aks seh, “Dis da noh di sayhn man weh mi-di persikyoot di peepl dehn da Jeroosalem weh bileev eena Jeezas? Wee mi tink seh dat hihn kohn ya fi ares di bileeva dehn ahn kehr dehn bak da di cheef prees dehn eena chaynz.” ");
INSERT INTO bzj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Wid aal weh dehn mi-di seh, Saal preechin geh moa ahn moa powaful. Ih proov tu di Jooz da Damaskos dat Jeezas da di Krais weh Gaad mi pramis fi sen, ahn aal dehn kuda mi du da shet dehn mowt. ");
INSERT INTO bzj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Afta sohn taim paas, di Jooish leeda dehn nak hed tugeda fi werk owt wahn plan fi kil Saal. ");
INSERT INTO bzj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bot Saal fain owt bowt dehn plan. Day ahn nait dehn wach di siti gayt fi kehr owt dehn plan fi merda ahn. ");
INSERT INTO bzj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Bot wahn nait, dehn wan weh mi kohn fi bileev eena Jeezas chroo Saal preechin tek Saal ahn let ahn dong eena wahn baaskit chroo wahn hoal eena di siti waal. ");
INSERT INTO bzj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wentaim Saal reech Jeroosalem, ih chrai fi jain op wid di bileeva dehn, bot dehn mi frayd far ahn; dehn neva bileev dat hihn da-mi wahn chroo chroo bileeva. ");
INSERT INTO bzj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bot Baanabas tek ahn, ahn kehr ahn da di apasl dehn. Ih eksplayn tu dehn how di Laad mi apyaa tu ahn, ahn taak tu ahn pahn di road, ahn how afta dat Saal neva frayd fi preech da Damaskos eena di naym a Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Soh ih stay wid dehn ahn neva frayd fi goh aal bowt Jeroosalem di preech eena di naym a di Laad. ");
INSERT INTO bzj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sayka weh Saal doz taak ahn aagyu wid sohn Jooish peepl weh taak Greek, dehn mi-di chrai fain wahn way fi kil ahn. ");
INSERT INTO bzj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wen di ada bileeva dehn mi yehr bowt dat, dehn kehr ahn dong da Seezareeya ahn dehn sen ahn aaf da Taasos. ");
INSERT INTO bzj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Soh aala di cherch dehn eena Judeeya ahn Gyalilee ahn Samayrya mi ga lee pees. Dehn staat groa schrang ahn lata peepl jain dehn. Dis hapm bikaa dehn shoa rispek fi Gaad, ahn di Hoali Spirit mi-di help dehn. ");
INSERT INTO bzj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Rong di sayhn taim, Peeta mi-di chravl fahn plays tu plays fi vizit di bileeva dehn. Pahn di way ih stap fi vizit dehn wan weh mi deh da di tong a Lida. ");
INSERT INTO bzj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ih meet wahn man nayhn Aneeyas, weh mi paralaiz ahn mi hafu lidong eena ih bed fi ayt yaaz. ");
INSERT INTO bzj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peeta seh tu ahn, “Aneeyas, Jeezas Krais heel yu! Get op ahn mek op yu bed.” Rait deh Aneeyas get op pahn ih fut. ");
INSERT INTO bzj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wen di peepl weh mi liv da di tong a Lida ahn di ayrya weh nayhn Shayron si dis, aala dehn bileev eena di Laad Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Eena di tong a Japa, wahn laydi mi liv deh weh nayhn Tabita. (Eena di Greek langwij ih naym da Dorkas, weh meen “dyaa.”) Shee da-mi wahn bileeva ahn ih spen aala ih taim di help poa peepl ahn di du gud. ");
INSERT INTO bzj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bot wahn day bowt dis sayhn taim, ih geh sik ahn ih ded. Ih fren dehn wash di badi ahn put ahn fi lidong eena wahn room opstayz. ");
INSERT INTO bzj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Di tong a Lida neva deh faar fahn Japa, ahn wen di bileeva dehn yehr dat Peeta mi deh rait da Lida, dehn sen too man fi goh bayg ahn seh, “Pleez hori mikays kohn wid wi da Japa.” ");
INSERT INTO bzj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Peeta kohn wid dehn ahn wen ih reech, dehn kehr ahn opstayz da di room. Wen ih gaan eensaid, di room mi ful op a wido weh mi-di baal. Wen dehn si Peeta, dehn kohn rong ahn di shoa ahn di difrent kaina kloaz weh Dorkas yoostu mek wen ih mi alaiv. ");
INSERT INTO bzj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peeta sen aala dehn owta di room, ahn den ih neel dong ahn pray. Den ih ton tu di badi ahn seh, “Tabita, stan op!” Di laydi oapm ih aiy ahn ih luk pahn Peeta, ahn den ih sidong op. ");
INSERT INTO bzj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peeta hoal ih han ahn help ahn fi stan op. Den ih kaal een di bileeva dehn ahn di wido dehn ahn shoa dehn dat Tabita mi alaiv agen! ");
INSERT INTO bzj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Di hoal a Japa yehr bowt weh mi hapm, ahn lata peepl staat bileev eena di Laad Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peeta stay da Japa fi wahn lee taim di liv wid Saiman, wahn man weh mek ting owta leda. ");
INSERT INTO bzj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Eena di tong a Seezareeya, dehn mi ga dis man weh nayhn Kaaneelyos, weh da-mi di kyaptin a wan honjrid soalja eena di Roaman aami. Dehn kaal dis groop di Italyan Rejiment. ");
INSERT INTO bzj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Hihn da-mi wahn gaadli man, lang wid ih hoal faamli. Ih mi ga wahn gud haat ahn ih doz giv lata gif tu di poa. Ahn hihn da-mi wahn man weh doz aalwayz pray. ");
INSERT INTO bzj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Rong chree aklak wahn aftanoon, Kaaneelyos geh wahn vizhan fahn Gaad. Eena dis vizhan wahn aynjel kom eena ih room ahn seh tu ahn, “Kaaneelyos!” ");
INSERT INTO bzj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kaaneelyos mi fraitn no miks ahn ih aiy dehn oapm big-wan, ahn ih seh, “Da weh yu waahn, sa?” Di aynjel seh, “Gaad pleez wid yu, ahn ih tek noatis a yu pryaaz ahn yu gif dehn tu di poa. ");
INSERT INTO bzj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Now, sen sohn man da Japa fi wahn man weh nayhn Saiman Peeta. ");
INSERT INTO bzj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ih di tek lajin wid wahn nada man weh nayhn Saiman, weh mek ting owta leda. Hihn liv kloas di see.” ");
INSERT INTO bzj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Wen di aynjel gaan, Kaaneelyos kaal too servant ahn wan a fi hihn oan soalja dehn, weh da-mi wahn gaadli man. ");
INSERT INTO bzj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ih tel dehn evriting weh hapm ahn den ih sen dehn da Japa. ");
INSERT INTO bzj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Rong twelv aklak di neks day, wen di man dehn mi nayli reech di tong a Japa, da mi di sayhn taim wen Peeta gaan op pahn di howstap fi pray. ");
INSERT INTO bzj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ih geh hongri ahn ih mi waahn sohnting fi eet. Bot wail di food mi-di geh redi, ih mi ga wahn vizhan. ");
INSERT INTO bzj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ih si hevn oapm op, ahn sohnting laik wahn big sheet geh let dong tu di grong bai di foa kaanaz. ");
INSERT INTO bzj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Eena di sheet mi ga aal kaina animal ahn reptail ahn berd weh flai eena di ayaa. ");
INSERT INTO bzj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Den wahn vais seh tu ahn, “Peeta, get op ahn kil eni wan a dehn yu waahn, ahn eet it.” ");
INSERT INTO bzj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peeta seh, “Ah kuda neva du dat, Laad. Eena aal mi laif Ah neva eet notn weh Moaziz Laa seh noh kleen ahn weh noh fit fi eet.” ");
INSERT INTO bzj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Den dis sayhn vais seh tu ahn agen, “Yoo noh ga no rait fi seh sohnting noh kleen wen Gaad ihself mek it kleen.” ");
INSERT INTO bzj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Dis hapm chree taim, den di sheet gaahn bak op da hevn. ");
INSERT INTO bzj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Soh wail Peeta mi-di wanda weh di vizhan meen, di man dehn weh Kaaneelyos sen, fain di hows. Dehn mi-di stan op owtsaida di hows da di gayt, ");
INSERT INTO bzj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ahn dehn aks, “Wahn man weh nayhn Saiman Peeta liv ya?” ");
INSERT INTO bzj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Meenwail, Peeta mi stil di tink bowt di vizhan weh ih mi jos gat. Ahn di Hoali Spirit mi hafu tel ahn seh, “Luk ya, sohn man deh dong deh fi si yu. ");
INSERT INTO bzj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mikays ahn goh dongstayz, ahn noh tink haad fi goh wid dehn. Da mee sen dehn.” ");
INSERT INTO bzj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Soh Peeta gaahn dongstayz ahn tel dehn seh, “Yes, mee da di wan weh yu di luk fa. Da weh bring unu ya?” ");
INSERT INTO bzj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Dehn ansa seh, “Kyaptin Kaaneelyos sen wi. Hihn da wahn gud man weh wership Gaad, ahn aala di Jooish peepl dehn mi ga nof rispek far ahn. Wahn aynjel fahn Gaad tel ahn fi sen fi yoo, ahn mek yu goh da ih hows soh dat ih ku yehr weh yu ga fi seh.” ");
INSERT INTO bzj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Soh Peeta aks dehn fi stay di nait. Di neks maanin Peeta ahn som a di bileeva dehn fahn Japa gaahn wid Kaaneelyos man dehn. ");
INSERT INTO bzj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Di neks day dehn reech Seezareeya. Kaaneelyos mi-di wayt fi dehn ahn ih mi aks aala ih faamli ahn kloas fren dehn fi kohn. ");
INSERT INTO bzj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Az Peeta mi-di luk fi goh eena di hows, Kaaneelyos meet ahn, ahn jrap dong da ih fut ahn wership ahn. ");
INSERT INTO bzj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bot Peeta mek ih get op ahn ih seh, “Get op! Ai da jos wahn man laik yuself.” ");
INSERT INTO bzj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peeta ahn Kaaneelyos mi-di taak tugeda wail dehn mi-di goh eensaid, wehpaa wahn lata peepl mi don gyada. ");
INSERT INTO bzj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Peeta seh tu aala dehn, “Unu wel noa dat ih goh gens fi wee Jooish Laa dehn fi miks op wid peepl weh da noh Joo er goh da dehn hows. Bot Gaad shoa mi dat Ah noh fi seh dat nobadi noh kleen nof fi miks op wid, jos bikaa dehn da noh Jooz laik wee. ");
INSERT INTO bzj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Soh wen yu sen fi mi, Ah neva tink haad fi kohn ataal ataal. Soh now, Ah waahn noa wai yu bring mi ya.” ");
INSERT INTO bzj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kaaneelyos ansa seh, “Da mi bowt foa dayz abak, rong dis sayhn taim, chree aklak di aftanoon, Ah mi-di du mi yoozhwal aftanoon pryaaz, wen owta no way wahn man eena brait brait kloaz kohn ahn stan op fronta mi. ");
INSERT INTO bzj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ih seh, ‘Kaaneelyos! Gaad yehr yu pryaaz, ahn ih memba yu gif dehn tu poa peepl. ");
INSERT INTO bzj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Now sen sohn man da Japa fi aks Saiman Peeta fi kohn. Ih di stay da Saiman hows, di man weh werk wid leda ahn weh liv kloas tu di see.’ ");
INSERT INTO bzj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Soh Ah mikays sen fi yu, ahn yu soh kain fi kohn. Now aala wi deh rait ya fi yehr weh Gaad tel yu fi seh. Ah hihn deh ya wid wi tu.” ");
INSERT INTO bzj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Den Peeta tel dehn seh, “Now Ah noa di chroot dat Gaad chreet evribadi di sayhn way. ");
INSERT INTO bzj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Gaad wahn aksep enibadi weh liv rait ahn weh wership ahn, noh mata weh konchri dehn kohn fram. ");
INSERT INTO bzj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Di mesij weh Gaad sen tu di peepl a Izrel da-mi di Gud Nyooz dat pees kohn chroo Jeezas Krais, weh da di Laad oava evribadi. ");
INSERT INTO bzj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Unu don noa weh hapm aal oava Judeeya dischrik. Di hoal ting staat eena Gyalilee afta Jan staat tu preech bowt how peepl shuda geh baptaiz. ");
INSERT INTO bzj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Gaad poar owt di Hoali Spirit ahn ih powa pahn Jeezas fahn Nazaret. Den Jeezas gaan aal bowt di plays di du gud, ahn ih heel aala dehn wan weh mi deh anda di powa a di devl, kaa Gaad mi deh wid ahn. ");
INSERT INTO bzj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Wee da witnis tu aala dehn ting weh ih mi du da Izrel ahn Jeroosalem. Dehn merda ahn wen dehn nayl ahn pahn di kraas. ");
INSERT INTO bzj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Bot eena chree dayz taim, Gaad bring ahn bak tu laif ahn mek peepl si ahn. ");
INSERT INTO bzj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Noh evribadi mi si ahn, oanli wee weh Gaad mi don pik owt fahn lang taim. Wee da di wan dehn weh mi eet ahn jrink wid ahn afta ih mi rayz op bak fahn di ded, soh wee deh ya fi witnis tu dat. ");
INSERT INTO bzj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ahn ih aada wi fi preech tu di peepl dehn, ahn mek dehn noa dat Gaad mek Jeezas joj oava evribadi, dehn wan weh livin ahn dehn wan weh don ded tu. ");
INSERT INTO bzj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ahn aala di prafit dehn mi taak ahn rait bowt Jeezas, ahn dehn seh dat evribadi weh bileev eena ahn, hihn wahn fagiv dehn sin dehn chroo di powa a fi hihn naym.” ");
INSERT INTO bzj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Wail Peeta stil mi-di seh dehn ting, di Hoali Spirit kohn dong pahn aala dehn wan weh mi-di lisn. ");
INSERT INTO bzj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ahn di Jooish bileeva dehn weh mi gaahn deh wid Peeta mi sopraiz dat Gaad gi di Hoali Spirit az wahn gif tu di peepl dehn weh da noh Joo tu. ");
INSERT INTO bzj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Dehn yehr dehn di taak eena tongz ahn di prayz Gaad fi ih gudnis. Den Peeta seh, ");
INSERT INTO bzj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Dehnya peepl geh di Hoali Spirit jos laik wee, soh hoo ku stap dehn fahn geh baptaiz wid waata?” ");
INSERT INTO bzj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Soh Peeta aada dehn fi geh baptaiz eena di naym a Jeezas Krais. Den afta dat, Kaaneelyos bayg ahn fi stay wid dehn fi wahn lee wail. ");
INSERT INTO bzj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Di apasl dehn ahn di ada bileeva dehn aal oava Judeeya dischrik yehr seh dat peepl weh da noh Joo mi aksep di Werd a Gaad tu. ");
INSERT INTO bzj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Bot wen Peeta gaahn bak op da Jeroosalem, di Jooish bileeva dehn staat fain aal kaina faalt wid ahn. ");
INSERT INTO bzj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ahn dehn tel ahn seh, “Yu gaan eena di hows a dehn peepl weh noh serkomsaiz, ahn eevn nyam food da dehn taybl!” ");
INSERT INTO bzj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Soh Peeta gi dehn di lang ahn shaat a di hoal stoari fahn di staat, ");
INSERT INTO bzj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Wen Ah mi deh da Japa, wail Ah mi-di pray, Ah mi ga wahn vizhan. Ah si sohnting weh luk laik wahn big big sheet weh let dong fahn hevn bai di foa kaanaz, ahn ih kohn rait dong tu weh Ah mi deh. ");
INSERT INTO bzj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Wen Ah luk een deh, Ah si foa-fut animal ahn wail animal weh liv pahn ert, ahn reptail, ahn berd weh flai eena di ayaa. ");
INSERT INTO bzj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Den Ah yehr wahn vais seh, ‘Peeta, get op ahn kil eni wan a dehn yu waahn, ahn eet it.’ ");
INSERT INTO bzj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ah ansa seh, ‘Ah kuda neva du dat, Laad! Eena aal mi laif Ah neva eet notn weh Moaziz Laa seh noh kleen ahn weh noh fit fi eet.’ ");
INSERT INTO bzj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Di vais fahn hevn taak wahn sekant taim ahn seh, ‘Yu noh ga no rait fi seh sohnting noh kleen wen Gaad ihself don mek it kleen.’ ");
INSERT INTO bzj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Dis hapm chree taim, den di sheet gaan op bak da hevn. ");
INSERT INTO bzj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Sayhn taim chree man fahn Seezareeya kohn da di hows weh Ah mi deh. ");
INSERT INTO bzj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Di Spirit tel mi noh fi tink haad fi goh wid di man dehn. Di siks man dehn weh mi deh wid mi kohn lang wid mi, ahn aala wi gaahn da Kaaneelyos hows. ");
INSERT INTO bzj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ih tel wi seh how ih mi si wahn aynjel eena ih hows, ahn di aynjel seh, ‘Sen da Japa fi wahn man weh nayhn Saiman Peeta. ");
INSERT INTO bzj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Hihn wahn tel yu how yoo ahn evribadi eena yu hows kuda geh sayv fahn unu sin dehn.’ ");
INSERT INTO bzj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Az Ah mi-di staat tu preech, di Hoali Spirit kohn dong pahn dehn, jos laik how ih mi kohn dong pahn wee da di biginin. ");
INSERT INTO bzj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Den Ah memba weh di Laad mi seh, ‘Jan baptaiz unu wid waata, bot Gaad wahn baptaiz unu wid di Hoali Spirit.’ ");
INSERT INTO bzj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Soh if Gaad gi dehn di sayhn gif weh ih gi wi wen wee mi bileev eena di Laad Jeezas Krais, da hoo mee fi tink seh dat mee ku goh gens Gaad?” ");
INSERT INTO bzj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Wen dehn yehr dis, dehn neva ga notn moa fi seh, ahn dehn prayz Gaad ahn seh, “Gaad mek di peepl dehn weh da noh Joo ga di sayhn chaans jos laik wee weh da Joo fi ton fahn dehn sin dehn ahn liv fareva.” ");
INSERT INTO bzj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Now som a Jeezas falowa dehn mi skyata bowt di plays sayka di chroblz weh dehn mi-di goh chroo afta Steeven ded. Dehn mi gaan az faar az Foneesha ahn Saipros ahn Antiyak; dehn preech di mesij, bot oanli tu di Jooz dehn. ");
INSERT INTO bzj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Bot som a dehn weh kohn fahn Saipros ahn Saireen gaahn da Antiyak ahn preech di Gud Nyooz bowt di Laad Jeezas tu di peepl dehn deh weh da neva Joo. ");
INSERT INTO bzj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Di powa a di Laad mi deh pahn dehn ahn wahn lata peepl bileev ahn ton tu di Laad. ");
INSERT INTO bzj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Di nyooz bowt dis flai ahn reech di apasl dehn ayz da Jeroosalem, ahn dehn sen Baanabas da Antiyak. ");
INSERT INTO bzj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Wen Baanabas reech deh ahn si how Gaad bles di peepl dehn, hihn mi glad ahn ih inkorij di bileeva dehn fi stay kloas tu di Laad noh mata weh ih kaas dehn! ");
INSERT INTO bzj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Baanabas da-mi wahn gud man weh mi deh anda di kanchroal a di Hoali Spirit, ahn ih mi schrang eena ih fayt; ahn wahn lata peepl mi ton tu di Laad. ");
INSERT INTO bzj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Den Baanabas lef ahn gaahn da Taasos fi luk fi Saal. ");
INSERT INTO bzj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wen ih fain ahn, ih bring ahn bak da Antiyak. Soh fi wahn hoal yaa Saal ahn Baanabas stay wid di cherch deh ahn teech wahn hoal lata peepl weh kohn. Da mi rait da Antiyak dehn mi kaal di peepl dehn weh bileev eena Jeezas “Kristyan” fi di fos taim. ");
INSERT INTO bzj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Da mi rong dis sayhn taim, sohn prafit kohn fahn Jeroosalem tu Antiyak. ");
INSERT INTO bzj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Wan a dehn weh nayhn Agabos stan op wid di powa a di Hoali Spirit pan ahn, ahn pridik seh dat wahn bad bad taim a staavayshan mi wahn spred oava aala di konchri dehn weh di Roaman govament di rool oava. (Dis hapm wen Klaadiyos da-mi di Empara.) ");
INSERT INTO bzj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Soh di bileeva dehn disaid fi sen rashan fi di ada bileeva dehn da Judeeya dischrik. Eech a dehn gi aal weh dehn kuda mi gi. ");
INSERT INTO bzj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Soh dehn du dis ahn sen dehn gif wid Baanabas ahn Saal tu di cherch elda dehn da Judeeya. ");
INSERT INTO bzj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Rong dis taim King Herod staat tu persikyoot ahn ares som a di bileeva dehn weh bilangz tu di cherch. ");
INSERT INTO bzj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ih staat wid Jaymz weh da Jan breda, ahn ih gi aadaz fi mek dehn kil ahn wid wahn soad. ");
INSERT INTO bzj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Wen ih si seh dat di Jooz dehn weh neva bileev eena Jeezas mi laik dat, ih gaan afta Peeta ahn ares hihn tu. Aala dis hapm joorin di taim a di Jooish fees wen dehn eet bred weh mek widowt ees. ");
INSERT INTO bzj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Afta Herod ares Peeta, ih put ahn eena jayl ahn put foa set a soalja fi gyaad ahn, ahn eech set mi ga foa soalja. Herod mi plan fi put ahn pahn poblik chraiyal afta di Paasoava selibrayshan. ");
INSERT INTO bzj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Soh dehn kip Peeta eena jayl, bot di peepl dehn da di cherch mi-di pray far ahn haad-wan. ");
INSERT INTO bzj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Di nait bifoa Herod mi fi bring Peeta owt fronta di peepl dehn fi chrai ahn, Peeta mi-di sleep bitween too gyaad. Ih mi chayn op wid too chayn, ahn too moa gyaad mi deh pahn jooti da di gayt fi di jayl. ");
INSERT INTO bzj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sodn-wan wahn aynjel fahn di Laad stan op fronta Peeta, ahn di sel lait op wid wahn brait lait. Di aynjel shayk Peeta ahn wayk ahn op ahn tel ahn seh, “Hori get op!” Sayhn taim di chayn dehn jrap aafa Peeta han dehn. ");
INSERT INTO bzj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Den di aynjel seh, “Put aan yu belt ahn yu sandalz.” Peeta du dat, den di aynjel seh, “Put yu koat rong yu ahn kohn wid mi.” ");
INSERT INTO bzj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peeta fala ahn owta di prizn, bot ih mi tink seh dat eeda ih mi-di jreem di hoal ting, er ih mi-di si wahn vizhan. ");
INSERT INTO bzj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Dehn paas di fos gyaad stayshan, den di sekant wan, til dehn kohn da di aiyan gayt weh oapm owt tu di schreet weh leed tu di siti. Di gayt oapm bai ihself widowt dehn eevn toch it. Dehn waak chroo it ahn dong di schreet, ahn den sodn-wan di aynjel disapyaa. ");
INSERT INTO bzj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Da den Peeta riyalaiz seh dat ih noh mi-di jreem, ahn ih seh, “Now Ah noa seh dat dis da noh no jreem, bot ih hapm fi chroo. Di Laad sen wan a ih aynjel fi reskyu mi fahn Herod powa ahn fahn evriting weh di Jooish peepl dehn mi tink wahn hapm tu mi.” ");
INSERT INTO bzj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Wen aala dis sink een, ih hed fi Mayri hows. Dis Mayri da-mi Jan Maak ma. Da fi shee hows wahn lata peepl mi kohn tugeda fi pray fi Peeta. ");
INSERT INTO bzj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peeta nak pahn di owtsaid doa ahn wahn gyal nayhn Roada kohn fi ansa di doa. ");
INSERT INTO bzj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Wen shee rekonaiz Peeta vais, shee mi soh hapi ahn eksaitid shee ron een bak insteda oapm di doa. Shee hala seh dat Peeta deh owt deh. ");
INSERT INTO bzj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Dehn tel ahn seh, “Yoo mos krayzi!” Bot ih tel dehn seh, “Noh man, da chroo!” Soh dehn seh, “Dat da mosi Peeta aynjel.” ");
INSERT INTO bzj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Meentaim Peeta deh owt deh di nak ahn nak. At lang laas dehn oapm di doa, ahn wen dehn si ahn, dehn kudn bileev dehn aiy. ");
INSERT INTO bzj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peeta hoal op ih han ahn tel dehn seh, “Unu kwaiyet dong!” Den ih eksplayn ahn tel dehn how di Laad bring ahn owta prizn. “Unu tel Jaymz ahn di res a di bileeva dehn weh hapm tu mi.” Ahn ih lef ahn gaahn sohnweh els. ");
INSERT INTO bzj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Di neks maanin big rokshan deh monks di soalja dehn bikaa dehn neva noa weh Peeta get tu, soh dehn mi deh eena chrobl. ");
INSERT INTO bzj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Soh Herod sen owt ih soalja dehn fi luk fi Peeta, bot dehn kudn fain ahn no way. Soh Herod kweschan di soalja dehn weh mi-di gyaad Peeta ahn den ih sentens dehn tu det. Den Herod lef Judeeya dischrik ahn gaahn da Seezareeya Tong ahn stay deh fi wahn lee wail. ");
INSERT INTO bzj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Now Herod ahn di peepl dehn fahn Taiya ahn Saidan kudn gree, ahn Herod mi beks bad wid dehn. Soh dehn sen wahn groop fi goh si Herod. Dehn manij fi geh Blastos help. Hihn da-mi Herod raiyal sekiteri. Dehn kohn bayg Herod fi mek pees wid dehn bikaa dehn mi-di pen pahn chrayd wid Herod konchri fi dehn food. ");
INSERT INTO bzj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pahn di day wen dehn mi fi kohn si Herod, Herod jres op eena ih raiyal roab ahn sidong pahn ih chroan ahn den ih mek wahn speech. ");
INSERT INTO bzj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Di peepl dehn hala seh, “Dis da di vais a wahn gaad; da noh di vais a wahn aadineri man.” ");
INSERT INTO bzj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Sayhn sayhn taim, wahn aynjel fahn Gaad schraik dong Herod. Wom staat tu eet owt ih eensaid ahn ih ded. Dis da bikaa ih mi-di injai how di peepl dehn mi-di prayz ahn op, ahn ih neva gi Gaad di gloari. ");
INSERT INTO bzj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Soh moa ahn moa peepl yehr di Werd a Gaad, ahn bileev eena Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Baanabas ahn Paal finish fi dehn werk da Jeroosalem, soh dehn lef deh ahn kehr Jan Maak wid dehn da Antiyak. ");
INSERT INTO bzj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Eena di cherch da Antiyak yu mi ga sohn prafit ahn sohn teecha. Dehn da-mi Baanabas, ahn Simiyan weh dehn kaal Naijer, ahn Looshos fahn Saireen, ahn Manayen weh mi groa op wid Herod weh da-mi di roola a Gyalilee, ahn Saal. ");
INSERT INTO bzj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Wail dehn mi-di wership di Laad ahn di faas, di Hoali Spirit tel dehn seh, “Ah waahn unu dedikayt Baanabas ahn Saal fi wahn speshal jab weh Ah ga fi dehn du.” ");
INSERT INTO bzj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Soh afta dehn mi faas ahn pray sohn moa, dehn put dehn han pahn dehn fi bles dehn ahn sen dehn aaf. ");
INSERT INTO bzj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Soh da di Hoali Spirit sen dehn owt. Fos, dehn gaahn sowt da Silisya ahn den dehn sayl da di ailan a Saipros. ");
INSERT INTO bzj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Wen dehn reech di tong a Salaamis, dehn staat tu preech tu di Jooz dehn eena di plays weh dehn meet. Jan Maak mi deh wid dehn di help dehn tu. ");
INSERT INTO bzj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Dehn chravl chroo di hoal ailan ahn den dehn reech Pafos. Dehsoh dehn meet wahn Jooish man weh mi nayhn Baa-Jeezas. Hihn da-mi wahn oabyaman ahn wahn faals prafit. ");
INSERT INTO bzj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hihn mi fren op wid Serjyos Paalos, weh da-mi di govna a di ailan. Dis man Serjyos Paalos da-mi wahn intelijent man, ahn ih sen fi Baanabas ahn Saal fi yehr weh dehn ga fi seh bowt di Werd a Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bot Baa-Jeezas, hoofa naym da-mi Elimas eena di Greek langwij, mi deh gens Baanabas ahn Saal ahn soh ih mi eevn chrai fi diskorij di govna fahn bileev eena Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Now Saal, weh dehn kaal Paal, mi ful op a di Hoali Spirit. Ih wach Baa-Jeezas schrayt eena ih aiy ahn seh, ");
INSERT INTO bzj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Yoo son a di devl, yu! Yu laiyad bad, ahn aal yu du da fool op peepl. Yu deh gens evriting weh raichos. Wai yu noh stap twis op di wayz a di Laad? ");
INSERT INTO bzj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Now lisn ya. Di Laad han wahn deh hevi pahn yu, ahn yu wahn blain. Yu noh wahn si di son til wen Gaad redi fi mek yu si agen.” Sayhn, sayhn taim wahn fag ahn daaknis kohn pahn Baa-Jeezas ahn ih mi hafu fain sohnbadi fi leed ahn bowt. ");
INSERT INTO bzj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Wen di govna si weh aal hapm, ih mi reeli sopraiz bowt di teechin a di Laad ahn ih bileev eena Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Now Paal ahn ih fren dehn set owt ahn sayl fahn Pafos tu Perga eena Pamfilya. Dehsoh Jan lef dehn ahn gaahn bak da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Wen dehn lef Perga, dehn reech Antiyak eena Pisidya. Da mi di Sabat soh dehn gaahn da di Jooish meetn plays ahn sidong deh. ");
INSERT INTO bzj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Afta dehn reed fahn Moaziz Laa ahn fahn weh di oal taim prafit dehn mi rait, di leeda dehn fi di sinagag sen fi dehn ahn seh, “Bradaz, if unu ga wahn lee werd a inkorijment fi di peepl dehn, shayr it wid wi noh.” ");
INSERT INTO bzj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Den Paal stan op ahn hoal op ih han ahn seh, “Unu peepl a Izrel, ahn aala unu weh fyaa Gaad, lisn tu mi! ");
INSERT INTO bzj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Di Gaad a Izrel pik wi ansesta dehn ahn rayz dehn op ahn mek dehn intu wahn big nayshan wail dehn mi deh da Eejip. Ahn ih bring dehn owt fahn deh wid fi hihn powa. ");
INSERT INTO bzj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Fi bowt faati yaaz ih luk afta dehn ahn bayr wid dehn eena di dezert. ");
INSERT INTO bzj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ih dischrai sebm nayshan weh mi eena Kaynan fi dehn. Den ih tek dehn lan ahn ih gi di peepl a Izrel. ");
INSERT INTO bzj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Aala dis hapm eena bowt foa honjrid ahn fifti yaaz. “Afta dat Gaad gi dehn joj fi rool oava dehn til wen Samwel, di prafit, kohn. ");
INSERT INTO bzj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Den afta dat dehn mi waahn wahn king, soh Gaad gi dehn Saal, weh mi rool oava dehn fi faati yaaz. Hihn da-mi Kish son weh da-mi fahn Benjamin chraib. ");
INSERT INTO bzj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Den afta ih moov Saal, ih put Dayvid az dehn king. Dis da weh Gaad seh bowt Dayvid: ‘Ah fain seh dat Dayvid, weh da Jesi son, da di kaina man weh kloas tu mi haat bikaa hihn wahn du aal weh Ah tel ahn fi du.’ ");
INSERT INTO bzj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Gaad mi pramis fi sen wahn Sayvya fi di peepl a Izrel chroo dis sayhn Dayvid famili lain, ahn dis Sayvya da Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Bifoa Jeezas mi staat ih werk, Jan mi preech tu aala di peepl a Izrel dat dehn shuda ton fahn dehn sin dehn ahn geh baptaiz. ");
INSERT INTO bzj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Den sayhn taim wen Jan mi-di finish ih werk, ih seh tu di peepl dehn, ‘Hoo unu tink mee? Mee da noh di wan weh unu di wayt fa, yu noh! Bot yehr ya! Hihn di kohn afta mee ahn fi tel yu di chroot, mee noh eevn gud nof fi tek aaf ih sandalz aafa ih fut!’ ");
INSERT INTO bzj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mi felo Izrelait dehn, weh da Aybraham disendant dehn, ahn aala unu peepl weh da noh Joo weh wership Gaad, unu lisn op! Da wee Gaad sen dis mesij a salvayshan tu! ");
INSERT INTO bzj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Di peepl dehn weh liv da Jeroosalem ahn dehn leeda dehn mi neva noa seh dat da hihn da di Sayvya. Dehn neva andastan di prafit dehn needa, eevn doa dehn mi-di reed weh dehn rait evri Sabat. Stilyet dehn mek di prafit werd kohn chroo wen dehn kandem Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ahn eevn wen dehn kudn fain no reezn fi gi ahn di det sentens, dehn stil aks Pailat fi put ahn tu det. ");
INSERT INTO bzj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Den wen dehn don du evriting weh di Skripcha seh bowt ahn, dehn tek ahn dong fahn di kraas ahn beri ahn eena wahn toom. ");
INSERT INTO bzj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bot Gaad rayz ahn op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ahn fi lata dayz dehn wan weh mi yoostu chravl wid ahn fahn Gyalilee tu Jeroosalem si ahn bikaa ih apyaa tu dehn. Now dehn di tel aala fi wee peepl bowt hihn. ");
INSERT INTO bzj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Soh now wee kohn bring di Gud Nyooz tu unu. Weh Gaad mi pramis wi grayt, grayt, granfaada dehn kohn chroo fi wee now. Ih mi pramis seh ih mi wahn bring Jeezas bak tu laif. ");
INSERT INTO bzj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Dis da weh di sekant Saam di taak bowt wen ih seh, ‘Yoo da mi Son; tudeh Ai kohn fi bee yu Faada.’ ");
INSERT INTO bzj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Bikaaz Gaad mi pramis fi bring Jeezas bak tu laif agen, ih noh wahn ded agen. Dis deh eena di Skripcha weh seh, ‘Ah wahn gi yu di sayhn blesin dehn weh Ah mi pramis Dayvid.’ ");
INSERT INTO bzj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Eena wahn nada Saam, ih eksplayn it klyaa-wan wen ih seh, ‘Ah noh wahn mek di badi a di Hoali Wan geh ratn.’ ");
INSERT INTO bzj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ih kudn a mi-di seh dis bowt Dayvid bikaa afta Dayvid don du weh Gaad mi waahn ih du, hihn mi ded, ahn dehn beri ahn, ahn fi hihn badi mi ratn. ");
INSERT INTO bzj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Bot dis neva hapm tu Jeezas bikaa Gaad rayz ahn op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Mi bradaz, unu shuda noa dat da chroo Jeezas di mesij bowt fagivnis a sin di preech tu unu. ");
INSERT INTO bzj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Evribadi weh chros eena ahn wahn free fahn aala dehn sin dehn. Moaziz Laa kudn set unu free! ");
INSERT INTO bzj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Soh unu beta main seh dat weh di prafit dehn mi seh noh hapm tu unu. Dehn mi seh, ");
INSERT INTO bzj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Luk ya, unu weh laik tek Gaad Werd mek papishoh, unu wahn lef di wanda ahn den jrap ded. Bikaaz Ai di du sohnting eena fi unu dayz weh unu wuda neva bileev eevn if sohnbadi wuda chrai fi eksplayn it tu unu.’” ");
INSERT INTO bzj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Az Paal ahn Baanabas dehn mi-di lef di meetn plays, di peepl dehn aks dehn fi kohn bak kohn taak tu dehn bowt dehn sayhn ting di neks Sabat. ");
INSERT INTO bzj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Soh afta di peepl dehn lef di meetn, wahn lata Jooz ahn peepl weh mi jain di Jooish rilijan, staat tu fala Paal ahn Baanabas. Di apasl dehn taak tu dehn ahn inkorij dehn fi kip aan fi chros eena di grays a Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Di neks Sabat nayli di hoal siti kohn fi yehr di Werd a Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bot wen di Jooz dehn si di lata, lata peepl weh kohn, dehn geh jelos soh dehn kanchradik weh Paal seh ahn insolt ahn. ");
INSERT INTO bzj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Bot Paal ahn Baanabas ansa dehn widowt frayd. Dehn seh, “Wi mi hafu preech Gaad mesij tu unu fos, bot laik how unu noh waahn yehr it, dat meen seh unu noh tink unuself gud nof fi liv wid Gaad fareva. Soh wi wahn lef unu ahn goh da di peepl dehn weh da noh Joo. ");
INSERT INTO bzj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Dis da di komanment weh di Laad gi wi: ‘Ah di mek unu bee wahn lait fi di peepl dehn weh da noh Joo, soh dat yu ku kehr di mesij a salvayshan tu peepl aal oava di werl.’” ");
INSERT INTO bzj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wen di peepl dehn weh da noh Joo yehr dis, dehn mi glad ahn dehn prayz Gaad fi ih mesij. Ahn aala dehn wan weh Gaad mi don pik fi liv wid hihn fareva, put dehn fayt eena di Laad. ");
INSERT INTO bzj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Di Werd a Gaad spred rait chroo di hoal ayrya. ");
INSERT INTO bzj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Bot di Jooz dehn staat tu ster op aans nes monks di rispektabl laydi dehn weh mi lov Gaad ahn di man dehn weh mi ga hai op pozishan eena di siti. Dehn mek chrobl fi Paal ahn Baanabas ahn chroa dehn owta di siti. ");
INSERT INTO bzj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Soh di apasl dehn shayk di dos aafa dehn fut az wahn sain a jojment gens dehn, ahn dehn gaahn da Ikonyom. ");
INSERT INTO bzj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Di bileeva dehn da Antiyak mi ful a jai ahn dehn mi ful a di Hoali Spirit. ");
INSERT INTO bzj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Wen dehn reech Ikonyom, Paal ahn Baanabas gaahn da di Jooish meetn plays gaahn preech. Dehn preech wid soh moch faiya dat lata Jooz ahn peepl weh da noh Joo mi bileev. ");
INSERT INTO bzj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Bot dehn Jooz weh neva bileev chrai fi paizn di main a dehn wan weh bileev ahn ton dehn gens Paal ahn Baanabas. ");
INSERT INTO bzj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","In spait a dat, Paal ahn Baanabas stil stay deh wahn lang taim. Dehn neva frayd fi taak bowt di Laad, ahn di Laad shoa dehn seh dat hihn mi deh wid dehn bikaa ih yooz dehn fi werk sohn grayt mirakl. ");
INSERT INTO bzj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Wen di peepl dehn si aala dat, dehn neva noa weh fi bileev. Sohn mi said wid di Jooish leeda dehn, ahn sohn mi said wid Paal ahn Baanabas. ");
INSERT INTO bzj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Now sohn Jooz ahn peepl weh da noh Joo, lang wid dehn leeda dehn, mi-di plan fi beet op Paal ahn Baanabas ahn stoan dehn tu det. ");
INSERT INTO bzj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bot Paal ahn Baanabas yehr bowt it, ahn dehn tayk aaf ahn gaahn da Laikonya wehpaa dehn preech da di too siti a Lischra ahn Derbi, ahn di ayrya rong deh. ");
INSERT INTO bzj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Soh dehn kantinyu fi preech di Gud Nyooz. ");
INSERT INTO bzj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Wen Paal mi-di preech da Lischra, dehn mi ga dis kripl man weh mi-di sidong eena di krowd. Dis man mi kripl fahn ih baan. ");
INSERT INTO bzj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Hihn mi-di lisn tu Paal wid aal weh ih gat. Paal si how ih di lisn tu ahn, ahn ih si seh dat ih ga fayt fi geh heel, soh Paal luk schrayt eena ih aiy ahn seh haad-wan, “Stan op schrayt pahn yu fut.” Di man jomp op sayhn taim ahn staat tu waak. ");
INSERT INTO bzj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Wel, wen di krowd si weh Paal du, dehn hala eena dehn langwij seh, “Dehnya man da Gaad eena hyooman badi.” ");
INSERT INTO bzj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Dehn disaid seh dat Baanabas da di Greek gaad weh nayhn Zoos, ahn Paal da Hermiz bikaaz hihn da di wan weh du aal di taakin. ");
INSERT INTO bzj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Pahn tap a dat, di prees fi di gaad Zoos mi ga wahn templ jos owtsaida di tong. Wel, hihn kohn now ahn bring sohn bul ahn lata flowaz da di siti gayt, ahn hihn ahn di peepl dehn mi waahn aafa wahn sakrifais tu dehn fi wership dehn. ");
INSERT INTO bzj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Wel, wen Baanabas ahn Paal si weh di hapm, dehn tayr dehn kloaz fi shoa seh dat dehn neva laik weh di prees mi wahn du, ahn dehn ron eena di midl a di krowd ahn hala seh, ");
INSERT INTO bzj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Man, da wai unu di du dis? Wee da man jos laik unu! Wee deh ya fi tel unu di Gud Nyooz soh dat unu ku ton fahn dehnya wotlis tingz ahn ton tu di livin Gaad weh mek hevn, ahn ert, ahn di see, ahn evriting eena it. ");
INSERT INTO bzj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Way bak eena bifoa taim dayz, Gaad doz mek di nayshan dehn goh dehn oan way. ");
INSERT INTO bzj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Bot ih doz aalwayz gi proof seh hihn da Gaad bikaaz a di ting dehn weh ih du. Da hihn gi unu rayn fahn hevn, ahn gi unu kraps eena dehn taim; ahn da hihn gi unu food ahn ih mek unu hapi.” ");
INSERT INTO bzj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Bot, cho! Eevn wid aala dat, di apasl dehn mi ga wahn haad taim fi stap di peepl dehn fahn sakrifais tu dehn. ");
INSERT INTO bzj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Noh tu lang afta dat, sohn Jooz kohn fahn Antiyak ahn Ikonyom ahn ton di sayhn krowd gens Paal. Dehn stoan Paal ahn den dehn jreg ahn owta di siti kaaz dehn mi tink ih ded. ");
INSERT INTO bzj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bot wen di bileeva dehn stan op rong ahn, ih get op ahn gaahn bak eena di siti. Di neks day hihn ahn Baanabas lef ahn gaahn da Derbi. ");
INSERT INTO bzj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paal ahn Baanabas preech di Gud Nyooz da di tong a Derbi ahn wahn lata peepl bileev eena di Laad. Den Paal ahn Baanabas gaahn bak da Lischra, den da Ikonyom ahn den da Antiyak eena Pisidya. ");
INSERT INTO bzj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Dehn mi gaahn gaahn inkorij di bileeva dehn fi stan op fi dehn fayt. Ih tel dehn seh, “Wi kyaahn get eena Gaad kingdom widowt goh chroo lata chroblz eena dis laif.” ");
INSERT INTO bzj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paal ahn Baanabas pik owt eldaz eena aala di cherch dehn. Dehn pray ahn faas fi dehn ahn put dehn eena di han a di Laad weh dehn mi bileev eena. ");
INSERT INTO bzj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Afta Paal ahn Baanabas gaahn chroo Pisidya, dehn kohn tu Pamfilya. ");
INSERT INTO bzj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Wen dehn don preech di Werd a Gaad da Perga, dehn moov dong tu Atalya. ");
INSERT INTO bzj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Fahn deh dehn sayl bak da Antiyak weh da-mi di sayhn siti weh dehn mi staat owt fram. Da dehsoh di bileeva dehn mi put dehn eena Gaad han fi du di werk weh dehn don now. ");
INSERT INTO bzj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Soh wen dehn reech Antiyak, Paal ahn Baanabas gyada aala di peepl dehn tugeda ahn tel dehn bowt weh aal di Laad du wid dehn. Dehn tel dehn how di Laad mek wahn way fi mek di peepl dehn weh da noh Joo bileev eena hihn. ");
INSERT INTO bzj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Dehn stay wid di bileeva dehn da Antiyak wahn lang taim. ");
INSERT INTO bzj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Sohn man fahn Judeeya kohn dong da Antiyak ahn dehn staat teech di bileeva dehn weh da noh Joo bowt serkomsizhan. Dehn seh, “If unu noh serkomsaiz laik how Moaziz Laa seh, unu kyaahn geh sayv.” ");
INSERT INTO bzj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paal ahn Baanabas neva agree wid dehn, soh big aagyument brok owt. Soh di bileeva dehn da Antiyak disaid fi mek Paal ahn Baanabas, lang wid sohn ada bileeva, goh op da Jeroosalem da di apasl dehn ahn di elda dehn, fi fain owt weh dehn ga fi seh bowt di hoal ting. ");
INSERT INTO bzj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Soh di cherch sen dehn aaf. Dehn chravl chroo Foneesha ahn Samayrya ahn dehn tel di bileeva dehn weh mi dehdeh bowt how peepl weh da noh Joo mi-di geh sayv. Di bileeva dehn deh mi oanli glad fi yehr dis. ");
INSERT INTO bzj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Wen Paal ahn Baanabas dehn reech Jeroosalem, di cherch peepl ahn di apasl dehn ahn di eldaz mi oanli glad fi si dehn. Di bileeva dehn weh mi-di vizit tel dehn evriting weh hapm ahn how Gaad yooz dehn. ");
INSERT INTO bzj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bot som a di bileeva dehn weh da-mi Farisee get op ahn seh, “Di peepl dehn weh da noh Joo hafu serkomsaiz ahn soh obay Moaziz Laa.” ");
INSERT INTO bzj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Soh di apasl dehn ahn di elda dehn disaid fi meet ahn taak bowt di prablem. ");
INSERT INTO bzj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Dehn spen wahn lang taim di taak bowt it, ahn den Peeta get op ahn seh, “Mi bradaz, unu noa seh dat lang taim now Gaad mi pik mi fahn monks unu fi goh preech di Gud Nyooz bowt Jeezas tu di peepl dehn weh da noh Joo, soh dat dehn ku bileev tu. ");
INSERT INTO bzj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Gaad noa how man tink, ahn ih shoa seh dat hihn aksep dehn wan weh da noh Joo wen hihn gi dehn di Hoali Spirit jos laik how ih gi wee. ");
INSERT INTO bzj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Gaad chreet di peepl dehn weh da noh Joo di sayhn way laik how ih chreet wee. Jos laik how wee bileev eena ahn, dehn bileev eena ahn tu ahn ih mek dehn haat kleen. ");
INSERT INTO bzj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Now unu waahn geh Gaad beks er sohnting? Wai unu di put wahn hevi load pahn di bak a di bileeva dehn weh da noh Joo? Noh eevn wee ner fi wee ansesta dehn kuda mi bak it. ");
INSERT INTO bzj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Weh hapm? Unu noh bileev seh dat aala wi geh sayv di sayhn way, bai di grays a di Laad Jeezas?” ");
INSERT INTO bzj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Dis shet dehn op. Dehn neva ga notn moa fi seh ahn soh dehn lisn wailz Baanabas ahn Paal tel dehn bowt aala di wandaz ahn mirakl dehn weh Gaad du chroo dehn monks di peepl dehn weh da noh Joo. ");
INSERT INTO bzj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Wen dehn don, Jaymz tek di floa. Hihn seh, “Unu lisn op, bradaz. ");
INSERT INTO bzj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saiman Peeta mi tel wi how Gaad mi shoa seh dat ih lov di peepl dehn weh da noh Joo. Soh fi di fos taim, ih tek owt wahn peepl fi ihself fahn monks dehn. ");
INSERT INTO bzj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Di oal taim prafit dehn mi rait bowt dis sayhn ting bikaaz di Skripcha seh, ");
INSERT INTO bzj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Aftawodz Ah wahn kohn bak. Ah wahn rayz op bak Dayvid kingdom weh mi faal dong. Ah wahn fiks op di rooinz, Ah wahn bil dehn op bak agen, ");
INSERT INTO bzj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Di hoal hyooman rays wahn luk fi mi; ahn aala dehn wahn fain mi. Eevn di peepl dehn weh da noh Joo weh maak wid fi mee naym, wahn luk fi mee ahn fain mee. Dat da weh di Laad mi seh, ");
INSERT INTO bzj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","dehnya ting hihn mi shoa wee. Hihn mi plan dehn fahn lang lang taim abak.’” ");
INSERT INTO bzj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Den Jaymz gaan aan fi seh, “Da fi mee opinyan dat wi shudn chrobl dehn peepl weh da noh Joo weh ton tu Gaad, ahn foas dehn fi obay fi wee Jooish Laa dehn. ");
INSERT INTO bzj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Weh wi ku du da rait dehn wahn leta seh dat dehn noh fi eet no food weh mi aafa tu aidal; wahn man noh fi ga seks wid wahn uman if ih noh marid tu ahn; ahn dehn noh fi eet blod er no meet weh kohn fahn animal weh mi schrangl. ");
INSERT INTO bzj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Unu noa dehndeh ting fahn way bak bikaa Moaziz Laa mi-di preech fahn den, ahn evri Sabat ih stil preech eena di Jooish meetn plays eena evri siti.” ");
INSERT INTO bzj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Den di apasl dehn, ahn di eldaz, ahn di hoal cherch disaid fi pik too man fahn di kangrigayshan ahn sen dehn wid Paal ahn Baanabas. Dehn pik Joodas, di wan weh ih laas naym da Barsaabas, ahn Sailas. Dehn da-mi too man weh di cherch memba dehn mi reeli rispek. ");
INSERT INTO bzj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Den dehn sen wahn leta wid dehn. Da soh di leta reed: Wee, di apasl dehn ahn di eldaz, sen greetinz tu aala wi felo bileevaz weh noh baan Joo, ahn weh liv da Antiyak ahn Siriya ahn Silisya. ");
INSERT INTO bzj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Wi andastan seh dat som a fi wee man dehn fahn ya gaahn deh gaahn tel unu sohnting weh opset unu, bot wee neva sen dehn. Soh dehn noh ga no atariti fahn wee. ");
INSERT INTO bzj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Now wi kaal wahn meetn ahn aala wi mek op wi main fi sen too man tu unu fi tel unu weh wi disaid seh. Dehn wahn goh lang wid wi dyaa fren dehn, Baanabas ahn Paal, ");
INSERT INTO bzj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","weh da too man weh put dehn laif pahn di lain fi sayka di Laad Jeezas Krais. ");
INSERT INTO bzj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Soh wi di sen Joodas ahn Sailas tu unu. Dehn wahn tel unu egzakli weh wi stan fa, ahn soh unu wahn si dat dat da di sayhn ting weh wi rait eena di leta. ");
INSERT INTO bzj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Di Hoali Spirit seh dat unu noh need no ekschra berdn ahn wee agree. Yu oanli hafu fala dehnya rool ya: ");
INSERT INTO bzj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Unu noh fi eet no food weh mi aafa tu aidal; wahn man noh fi ga seks wid wahn uman if ih noh marid tu ahn; ahn unu noh fi eet blod er no meet weh kohn fahn wahn animal weh mi schrangl. Ih wahn du unu gud fi kip weh fahn dehndeh ting. Unu tek kayr. ");
INSERT INTO bzj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Soh di foa man dehn lef owt fahn Jeroosalem ahn gaahn da Antiyak. Wen dehn reech deh, dehn kaal wahn meetn a di cherch ahn gi dehn di leta. ");
INSERT INTO bzj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Afta di leta don reed eena di cherch, evribadi mi hapi ahn mi feel inkorij. ");
INSERT INTO bzj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Joodas ahn Sailas dehn da-mi preechaz, soh dehn du lata preechin di inkorij di bileeva dehn ahn schrentn dehn fayt. ");
INSERT INTO bzj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Afta dehn spen wahn gud amonk a taim deh, di bileeva dehn da Antiyak sen dehn bak wid dehn blesin tu di bileeva dehn da Jeroosalem weh mi sen dehn owt eena di fos plays. ");
INSERT INTO bzj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Soh Sailas hihn disaid seh hihn wahn stay da Antiyak. ");
INSERT INTO bzj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paal ahn Baanabas stay bak da Antiyak fi preech ahn teech di Werd a Gaad lang wid di ada preecha ahn teecha dehn weh dehn mi gat. ");
INSERT INTO bzj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Afta wahn fyoo dayz, Paal seh tu Baanabas, “Mek wi goh bak da dehn tong wehpaa wi mi preech di Werd a Gaad ahn si how di bileeva dehn di du.” ");
INSERT INTO bzj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Baanabas agree ahn put it tu Paal fi dehn kehr Jan Maak wid dehn. ");
INSERT INTO bzj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Paal neva agree wid dat bikaa hihn seh dat yu kyaahn pen pahn Jan Maak bikaa hihn mi fi deh pahn dis mishan wid dehn, bot ih dizert dehn da Pamfilya. ");
INSERT INTO bzj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Soh Paal ahn Baanabas mi ga big heetid aagyument oava dis, ahn dehn disaid fi goh dehn oan way. Baanabas kehr Maak wid hihn ahn sayl gaahn da Saipros. ");
INSERT INTO bzj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bot Paal pik Sailas fi goh wid hihn. Di bileeva dehn da Antiyak put dehn eena Gaad han ahn sen dehn aaf. ");
INSERT INTO bzj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Soh Paal ahn Sailas chravl chroo Siriya ahn Silisya di inkorij di cherch dehn eena dehn plays deh. ");
INSERT INTO bzj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paal ahn Sailas gaahn da Derbi fos ahn den da Lischra wichpaa dehn meet wahn bileeva weh nayhn Timoti. Fi hihn ma da-mi wahn bileeva tu. Shee da-mi Joo bot ih pa da-mi Greek. ");
INSERT INTO bzj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Di bileeva dehn da Lischra ahn Ikonyom mi taak gud bowt Timoti, ");
INSERT INTO bzj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","soh Paal mi waahn kehr ahn lang wid dehn pahn dehn jerni. Bot ih serkomsaiz Timoti fos soh dat di Jooz dehn weh mi liv eena da ayrya noh ga notn fi seh, kaa dehn mi noa seh dat Timoti pa da-mi Greek. ");
INSERT INTO bzj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Den dehn chravl fahn siti tu siti fi tel di bileeva dehn weh da di roolz weh di apasl dehn ahn di elda dehn da Jeroosalem mi disaid pan fi dehn obay. ");
INSERT INTO bzj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Soh di cherch dehn mi groa schranga eena dehn fayt ahn lat moa peepl jain dehn. ");
INSERT INTO bzj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Neks Paal ahn Sailas, lang wid Timoti, chravl chroo Frijya ahn Galaysha, bot dehn neva gaahn da Aysha kaa di Hoali Spirit tel dehn noh fi preech deh. ");
INSERT INTO bzj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Wen dehn reech di boada da Misya, dehn chrai fi goh da Bitinya, bot Jeezas Hoali Spirit neva waahn dehn goh deh. ");
INSERT INTO bzj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Soh insteda goh deh, dehn gaahn chroo Misya ahn dong da Chroawaz. ");
INSERT INTO bzj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Da sayhn nait Paal mi ga wahn vizhan. Ih si wahn man fahn Masidoanya di stan op ahn di bayg ahn seh, “Kohn da Masidoanya, kohn help wi.” ");
INSERT INTO bzj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Afta Paal si di vizhan, wi neva ways no taim fi geh redi fi goh da Masidoanya, kaaz wi mi noa seh dat da Gaad mi-di sen wi deh fi preech di Gud Nyooz tu di peepl dehn deh. ");
INSERT INTO bzj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Wi lef fahn Chroawaz eena wahn ship ahn sayl schrayt kraas tu Samochrays, ahn den di neks day wi gaahn da Niyapolis. ");
INSERT INTO bzj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Fahn deh wi gaahn da Filipai, weh da wahn Roaman kalani ahn wahn siti eena di fos dischrik a Masidoanya. Wi stay deh fi wahn fyoo dayz. ");
INSERT INTO bzj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Wen di Sabat day kohn, wi gaahn bai di rivasaid weh wi noa seh wi mait fain wahn plays weh di Jooish peepl dehn mi wahn goh pray. Wen wi reech, wi sidong ahn taak tu di laydi dehn weh mi dehdeh. ");
INSERT INTO bzj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wan a di laydi weh mi dehdeh da-mi Lidya, fahn Taiyataira. Shee doz sel sohn ekspensiv perpl klaat. Shee da-mi wahn laydi weh wership Gaad ahn di Laad oapm fi shee haat fi bileev di mesij weh Paal preech. ");
INSERT INTO bzj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Shee ahn evribadi eena ih hows geh baptaiz ahn den shee invait wi fi kohn stay wid ahn. Ih seh, “If unu bileev seh dat Ai da wahn chroo chroo bileeva eena di Laad, den unu stay wid mi.” Ih neva don til ih perswayd wi fi stay da ih hows. ");
INSERT INTO bzj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wahn day az wi mi-di goh da di plays fi pray, wi meet wahn slayv gyal. Shee mi ga wahn eevl spirit eena ahn weh mek ih kuda mi tel di fyoocha. Bikaaz a dis, shee doz mek lata moni fi di peepl dehn weh mi oan ahn. ");
INSERT INTO bzj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ih mi-di fala Paal ahn di hala seh, “Dehnya man da di servant fi di moas hai Gaad! Dehn tel yu how yu ku geh sayv.” ");
INSERT INTO bzj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Shee gaan aan wid dis fi wahn gud lee wail, til Paal geh taiyad a it. Soh wahn day, ih jos ton rong ahn seh tu di spirit eena di gyal, “Eena di naym a Jeezas Krais, Ah aada yu fi kom owta ahn!” Sayhn sayhn taim di eevl spirit kom owta ahn. ");
INSERT INTO bzj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Wel, wen fi shee oana dehn riyalaiz seh dat shee wahn kyaahn mek nohmoh moni fi dehn, dehn mi beks. Soh dehn grab Paal ahn Sailas ahn jreg dehn fronta di atariti dehn eena di poblik skwyaa. ");
INSERT INTO bzj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Dehn bring dehn fronta di Roaman ofishal dehn ahn akyooz dehn seh, “Dehnya man da Jooz, ahn dehn di kaaz lata chrobl eena fi wee siti. ");
INSERT INTO bzj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Dehn di teech tingz weh deh gens fi wee laa; wee da Roaman sitizn ahn wi kyaahn du dehndeh ting deh.” ");
INSERT INTO bzj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Wel, di krowd jain een fi atak Paal ahn Sailas. Den di ofishal dehn tayr di kloaz aafa Paal ahn Sailas ahn aada wahn wipin fi dehn. ");
INSERT INTO bzj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Afta dehn don geh wahn gud beetn, dehn chroa dehn eena jayl ahn dehn tel di jayla fi mek shoar ih lak dehn op gud. ");
INSERT INTO bzj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Soh di jayla fala di aadaz ahn soh chroa dehn eena di sel weh deh way eensaid, ahn pahn tap a dat, ih faasn dehn fut bitween too hevi blak a wud. ");
INSERT INTO bzj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Rong midnait Paal ahn Sailas mi-di pray ahn sing himz tu Gaad, ahn di ada prizna dehn mi-di lisn tu dehn. ");
INSERT INTO bzj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Sodn-wan wahn seeryos ertwayk shayk di jayl rait dong tu di fongdayshan. Sayhn sayhn taim aala di doa dehn oapm op ahn aala di chayn dehn jrap aafa aala di prizna dehn. ");
INSERT INTO bzj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Di jayla hihn wayk op ahn wen hihn si seh dat aala di doa dehn oapm, hihn mi tink seh dat di prizna dehn mi don get weh; soh hihn haal owt ih soad ahn ih mi wahn kil ihself. ");
INSERT INTO bzj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bot Paal hala pahn di tap a ih vais seh, “Stap, noh kil yuself! Aala wi deh ya!” ");
INSERT INTO bzj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Di jayla hala fi wahn lait, ih dash een ahn faal dong di chrimbl da Paal ahn Sailas fut. ");
INSERT INTO bzj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Den ih bring dehn owta di sel ahn aks dehn seh, “Mista, da weh Ah ku du fi geh sayv?” ");
INSERT INTO bzj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Dehn ansa ahn seh, “Bileev eena di Laad Jeezas ahn yoo wahn sayv—yoo ahn yu hoal famili.” ");
INSERT INTO bzj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Den dehn preech di Werd a Gaad tu hihn ahn di res a di peepl dehn eena ih hows. ");
INSERT INTO bzj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Da mi nait, bot da sayhn taim di jayla tek dehn ahn ten tu di kot ahn brooz weh dehn mi get; den hihn ahn ih hoal famili geh baptaiz sayhn taim. ");
INSERT INTO bzj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Den ih kehr Paal ahn Sailas opstayz eena ih hows ahn gi dehn ting fi eet. Di jayla ahn ih famili mi oanli hapi kaaz now dehn bileev eena Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Di neks maanin di Roaman ofishal dehn sen sohn polees aafisa wid di aada seh, “Let goh dehn man.” ");
INSERT INTO bzj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Soh di jayla seh tu Paal, “Wahn aada kohn fahn di Roaman ofishal dehn seh dat yoo ahn Sailas ku goh. Soh unu ku goh, ahn goh in pees.” ");
INSERT INTO bzj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Bot Paal seh tu di polees aafisa dehn, “Dehn neva fain wi gilti a no kraim. Stilyet dehn beet wi eena poblik ahn chroa wi eena prizn, ahn fi si dat wee da Roaman sitizn. Now dehn waahn sen wee aaf eena seekrit. No way! Dehn beta kohn tel wee dat dehnself ahn den let wi goh.” ");
INSERT INTO bzj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Soh di polees aafisa dehn gaahn bak gaahn tel di Roaman ofishal dehn weh Paal mi seh. Wel, wen dehn yehr seh dat Paal ahn Sailas da-mi Roaman sitizn, dehn mi oanli fraitn. ");
INSERT INTO bzj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Soh dehn gaahn dehnself gaahn tel dehn how dehn soh sari; den dehn kehr dehn dehnself owta jayl ahn aks dehn fi lef di siti. ");
INSERT INTO bzj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Afta Paal ahn Sailas lef di prizn, dehn gaahn da Lidya hows. Dehn meet wid di bileeva dehn deh, ahn gi dehn werdz a inkorijment, ahn den dehn lef. ");
INSERT INTO bzj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paal ahn Sailas paas chroo Amfipolis ahn Apolonya, den dehn reech Tesalonaika. Wahn Jooish meetn plays mi deh da Tesalonaika, ");
INSERT INTO bzj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ahn da mi Paal habit fi aalwayz fain di meetn plays eniway ih goh, soh fi chree schrayt Sabat ih gaahn deh fi reezn wid di peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ih eksplayn di Skripcha tu di peepl dehn ahn shoa dehn proof seh dat di Krais hafu sofa, ahn den ih wahn rayz op bak fahn di ded. Paal tel dehn seh, “Dis Jeezas weh Ah di taak bowt da di Krais.” ");
INSERT INTO bzj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Som a dehn mi kanvins seh dis da chroo ahn soh dehn jain Paal ahn Sailas. Lata Greek peepl weh mi lov Gaad ahn wahn lata impoatant laydi fahn di siti mi deh monks dehn wan weh bileev tu. ");
INSERT INTO bzj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Bot di Jooz dehn geh jelos ahn dehn get tugeda sohn wotlis bwai aafa di schreet fi staat wahn raiyat, ahn dehn ton di hoal siti opsaid dong. Dehn gaahn da Jayson hows kaaz dehn mi tink seh Paal ahn Sailas mi dehdeh, kaa dehn mi waahn jreg dehn owt fronta di krowd. ");
INSERT INTO bzj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Paal ahn Sailas neva dehdeh, soh dehn haal owt Jayson insted, lang wid sohn ada bileeva dehn weh mi dehdeh. Den dehn kehr dehn fronta di siti atariti dehn ahn hala seh, “Dehnya man noh kaaz notn bot chrobl eniway dehn goh. Now dehn kohn da fi wee siti, ");
INSERT INTO bzj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ahn Jayson mek dehn stay da ih hows. Dehn di brok Seeza laa kaaz dehn di seh dat wahn nada king deh weh nayhn Jeezas.” ");
INSERT INTO bzj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Wel luk ya, wen di krowd ahn di siti atariti dehn yehr dis, dehn gaan aaf. ");
INSERT INTO bzj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Soh di atariti dehn in chaaj mek Jayson ahn di ada bileeva dehn pay bayl, ahn den dehn let dehn goh. ");
INSERT INTO bzj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Wen nait kohn dong, di brejrin hosl Paal ahn Sailas owt, ahn sen dehn da Bereeya. Wen dehn reech deh, dehn gaahn schrayt da di meetn plays. ");
INSERT INTO bzj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Da Bereeya di peepl dehn mi moa wilin fi lisn, noh laik dehn wan da Tesalonaika. Wel, dehn jos mi-di wayt fi yehr di mesij. Evri day dehn stodi di Skripcha fi si if weh Paal seh da chroo. ");
INSERT INTO bzj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Wahn lata di Jooz dehn bileev, ahn lata hai op Greek laydi, ahn lata Greek man bileev tu. ");
INSERT INTO bzj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Bot sayhn taim, di Jooz dehn da Tesalonaika yehr seh dat Paal mi-di preech di sayhn mesij bowt Jeezas da Bereeya, soh dehn kohn deh fi kohn set op di peepl dehn gens Paal. ");
INSERT INTO bzj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Di brejrin deh neva ways no taim, ahn dehn hori sen Paal dong di koas, bot Sailas ahn Timoti stay bak da Bereeya. ");
INSERT INTO bzj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Di man dehn fahn Bereeya weh gaahn wid Paal kehr ahn da Atenz, ahn den dehn ton bak. Paal tel dehn dat wen dehn reech bak da Bereeya, dehn mos tel Sailas ahn Timoti fi kohn kohn kech op wid ahn az soon az dehn kud. ");
INSERT INTO bzj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Wailz Paal mi-di wayt fi dehn wan, ih luk rong Atenz ahn ih mi feel sad wen ih si di lata aidal dehn rong di siti. ");
INSERT INTO bzj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Paal gaahn da di meetn plays wehpaa ih ku reezn wid di Jooz dehn ahn dehn wan weh da noh Joo weh wership Gaad. Den evri day ih wuda goh da di maakit plays tu fi goh taak tu di peepl dehn weh mi dehdeh. ");
INSERT INTO bzj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ih mi meet op wid sohn Epikyooryan ahn Stowik teechaz tu, ahn dehn ga big aagyument wid ahn. Sohn seh, “Da weh dis shoa-aaf noa-aal di chrai seh?” Wen Paal preech tu dehn bowt Jeezas ahn how ih mi rayz op bak fahn di ded, sohn seh, “Hihn luk laik hihn di taak bowt sohn gaad weh wee noh noa bowt.” ");
INSERT INTO bzj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Soh dehn kehr Paal fronta di kongsl weh dehn kaal di Ariyopagos. Dehn seh, “Kohn tel wi bowt dis nyoo rilijan.” ");
INSERT INTO bzj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","“Dehn ting weh yu di tel wi song schraynj tu wee, ahn wee waahn noa moa.” ");
INSERT INTO bzj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Yu si, di peepl dehn a Atenz ahn di farina dehn weh mi liv deh, mi lov fi yehr nyoo tingz ahn taak bowt nyoo tingz aal di taim.) ");
INSERT INTO bzj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Soh Paal stan op fronta di kongsl ahn seh, “Unu man ya da Atenz, Ah noatis seh dat unu oanli rilijos ");
INSERT INTO bzj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","bikaa az Ah mi-di waak paas, Ah mi-di luk pahn aala di aidal dehn weh unu wership, an Ah si wahn alta weh maak, ‘Tu di Gaad weh nobadi noh noa.’ Unu mi-di wership ahn, ahn unu neva eevn noa ahn. Wel, now Ah wahn tel unu bowt ahn. ");
INSERT INTO bzj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Hihn da di Wan weh mek di werl ahn evriting weh eena it, ahn bikaa hihn da di Laad a hevn ahn ert, hihn noh liv eena no templ weh hyooman han mek. ");
INSERT INTO bzj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ahn bisaidz dat, fi unu hyooman han kyaahn ten tu fi hihn need dehn bikaa hihn noh need notn. Da hihn gi laif ahn bret tu evriting, ahn hihn satisfai aala fi wee needz. ");
INSERT INTO bzj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Da hihn mek aala di peepl dehn weh deh eena di werl fahn wan man weh nayhn Adam. Den ih skyata dehn aal oava di hoal ert. Da hihn fiks di egzak taim ahn plays wehpaa dehn fi liv. ");
INSERT INTO bzj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Gaad du aala dis soh dat wee wuda luk far ahn, ahn chrai fain ahn, bikaa reeli ahn chrooli Gaad noh deh faar fahn non a wi. ");
INSERT INTO bzj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Da hihn gi wi di powa fi liv ahn moov ahn fi mek wi deh ya. Laik weh som a unu oan poawet dehn seh, ‘Wee da fi hihn pikni dehn tu.’ ");
INSERT INTO bzj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Laik how wee da Gaad pikni, den wi shudn eevn tink seh dat Gaad da wahn aidal weh man ku tink op fi mek fahn owta goal er silva er stoan. ");
INSERT INTO bzj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Fos, Gaad doz talarayt aala dis bikaa peepl neva noa beta, bot now ih koman evribadi, evriway fi du weh wid dehn aidal ahn wership oanli hihn wan. ");
INSERT INTO bzj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Yu si, hihn don fiks wahn day wen hihn wahn joj di peepl dehn a di werl fyaa-wan. Ahn Jeezas da di man weh hihn don pik fi du di jojin far ahn. Gaad proov seh ih wahn du dat wen ih bring da sayhn Jeezas bak fahn di ded.” ");
INSERT INTO bzj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Wen dehn yehr Paal taak bowt how sohnbadi mi rayz op bak fahn di ded, som a dehn laaf aata ahn, bot sohn ada wan seh, “Wee waahn yehr moa bowt dis layta.” ");
INSERT INTO bzj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Soh Paal lef di meetn. ");
INSERT INTO bzj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Bot sohn man jain op wid Paal ahn dehn bileev; monks dehn da mi Daiyonisyos, weh da-mi wahn memba a di siti kongsl, ahn wahn laydi nayhn Damaaris, ahn sohn ada wan. ");
INSERT INTO bzj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Afta dis, Paal lef Atenz ahn gaahn da Korint, ");
INSERT INTO bzj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","wehpaa ih meet Akwila, weh da-mi wahn Joo weh baan da Pontus. Hihn mi jos kohn fahn Itali lang wid ih waif, Prisila. Dehn lef bikaa Klaadiyos, weh da-mi di Empara, mi aada aala di Jooz dehn fi lef Roam. Paal gaahn si Akwila ahn Prisila, ");
INSERT INTO bzj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ahn laik how dehn doz mek tent fi sel jos laik Paal, ih en op di stay wid dehn ahn werk wid dehn. ");
INSERT INTO bzj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Evri Sabat Paal wuda goh da di Jooish meetn plays ahn ih wuda aagyu wid di Jooz dehn ahn di Greek peepl dehn, di chrai geh dehn fi bileev eena Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Wen Sailas ahn Timoti kohn fahn Masidoanya, Paal spen aala ih taim di preech tu di Jooish peepl dehn di chrai kanvins dehn dat Jeezas da-mi di Krais. ");
INSERT INTO bzj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Bot, cho! Dehn ton gens Paal ahn staat tu seh aal kaina bad tingz bowt ahn. Soh Paal shayk aaf di dos fahn aafa ih kloaz fi shoa seh ih noh ga notn fi du wid dehn agen, ahn ih tel dehn seh, “If unu kot unuself aaf fahn Gaad, unu gat unu oanself fi blaym. Ai noh rispansabl agen. Fahn ya goh bak, Ah wahn goh tu di peepl dehn weh da noh Joo.” ");
INSERT INTO bzj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Soh Paal lef dehn ahn gaahn liv da Taitos Jostos hows. Hihn da-mi wahn man weh wership Gaad ahn ih mi liv rait saida di Jooish meetn plays. ");
INSERT INTO bzj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispos da-mi di leeda a di meetn plays, ahn hihn mi kohn fi bileev eena di Laad, lang wid evribadi eena ih hows. Lata ada peepl fahn Korint weh mi yehr di mesij bileev tu, ahn dehn geh baptaiz. ");
INSERT INTO bzj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Den wahn nait di Laad kohn tu Paal eena wahn vizhan ahn seh tu ahn, “Noh frayd, bot taak owt. Noh kip kwaiyet. ");
INSERT INTO bzj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ai deh wid yu ahn no man kyaahn put wahn han pahn yu ahn haam yu; ahn bisaidz dat, Ai ga lata peepl eena dis siti weh bileev eena mi.” ");
INSERT INTO bzj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Soh Paal setl dong deh fi wahn yaa an a haaf di teech di peepl dehn di Werd a Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Joorin da taim, wahn man nayhn Galyo ton govna da Akaiya. Wel, di Jooz dehn kohn tugeda ahn grab Paal, ahn kehr ahn da koat fronta Galyo. ");
INSERT INTO bzj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Dehn seh, “Dis man di chrai fi kanvins peepl fi wership Gaad eena wahn way weh goh gens fi wee laa.” ");
INSERT INTO bzj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paal mi wahn ansa fi difen ihself, bot sayhn taim Galyo staat taak. Ih seh, “Lisn, unu Jooz, if dis da-mi wahn kays weh involv sohn kraim er di ada, Ah mi wahn lisn tu unu, ");
INSERT INTO bzj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","bot dis da wahn aagyument bowt fi unu werdz, ahn naym, ahn bowt fi unu oan Jooish Laa. Soh unu si bowt dat, unu oanself. Mee noh di joj dehndeh ting deh.” ");
INSERT INTO bzj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Soh Galyo jraiv dehn owta ih koat. ");
INSERT INTO bzj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Wel den, dehn ton pahn Sostineez, di leeda a di meetn plays, ahn beet hihn op rait fronta di koat-hows. Bot Galyo neva pay dehn no main. ");
INSERT INTO bzj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paal stay da Korint wid di bileeva dehn fi wahn gud nomba a dayz, den ih lef dehn ahn sayl fi Siriya, lang wid Prisila ahn Akwila. Bifoa ih set sayl, ih shayv ih hed da Senkriya fi shoa seh dat ih kip wahn vow weh ih mi mek tu Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Dehn reech Efisos, weh Paal lef Prisila ahn Akwila, ahn hihn wan gaan eena di Jooish meetn plays fi taak wid di Jooz dehn. ");
INSERT INTO bzj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Dehn mi-di aks ahn fi stay wid dehn wahn fyoo moa dayz, bot ih tel dehn seh dat ih kudn stay. ");
INSERT INTO bzj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Bot wen ih mi-di lef, ih pramis dehn dat ih wahn kohn bak if Gaad wilin. Den Paal set sayl fahn Efisos. ");
INSERT INTO bzj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ih neks stap da-mi Seezareeya, ahn fahn deh ih gaahn gaahn vizit di cherch da Jeroosalem, ahn den ih sayl gaahn da Antiyak. ");
INSERT INTO bzj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Paal spen wahn lee taim da Antiyak, ahn den fahn deh ih vizit fahn wan plays tu di neks aal oava Galaysha ahn Frijya, ahn evriway weh ih goh, ih help di bileeva dehn fi geh schranga eena dehn fayt eena di Laad. ");
INSERT INTO bzj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Now wahn Joo weh nayhn Apolos fahn Alegzanjriya kohn da Efisos. Hihn da-mi wahn gud speeka ahn hihn mi noa wahn hoal lat bowt di Skripcha. ");
INSERT INTO bzj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Sohnbadi mi teech ahn bowt di Way a di Laad Jeezas, soh hihn taak owt bowt Jeezas wid aal weh ih mi gat, ahn weh ih mi-di seh mi karek. Di oanli bad ting da-mi dat hihn neva yehr di hoal stoari. Hihn mi oanli noa bowt Jeezas fahn weh Jan di Baptis mi seh. ");
INSERT INTO bzj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Bot ih taak bowt weh ih mi noa widowt frayd wen ih goh da di Jooish meetn plays. Da dehsoh Prisila ahn Akwila yehr ahn. Soh dehn invait Apolos da dehn hows ahn dehn ful ahn een ahn teech ahn gud bowt di Way a di Laad Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Meentaim Apolos mi-di tink bowt goh da Grees, ahn di bileeva dehn inkorij ahn fi goh. Soh dehn rait di ada bileeva dehn da Grees ahn aks dehn fi welkom Apolos. Wen ih get deh, Gaad reeli yooz ahn fi schrentn aala dehn wan weh mi ton bileevaz chroo di grays a Gaad, ");
INSERT INTO bzj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","kaa hihn kuda mi aagyu wid di Jooz dehn ahn beet dehn eena poblik dibayt ahn proov fahn di Skripcha dat Jeezas da di Krais. ");
INSERT INTO bzj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Soh den, wail Apolos mi deh da Korint, Paal mi-di chravl chroo di opa paat a da ayrya, ahn den ih reech Efisos, wehpaa ih fain kwait a fyoo bileevaz. ");
INSERT INTO bzj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ih aks dehn seh, “Unu mi geh di Hoali Spirit wen unu mi bileev?” Dehn seh, “No, wee noh eevn noa weh yu meen bai di Hoali Spirit.” ");
INSERT INTO bzj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paal aks dehn seh, “Wel, weh kaina baptizm unu mi geh den?” Dehn ansa seh, “Di baptizm weh Jan mi preech bowt.” ");
INSERT INTO bzj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Den Paal eksplayn tu dehn seh, “Jan baptizm da-mi fi mek unu shoa seh dat unu ton fahn unu sin dehn. Bot memba, ih tel unu seh dat unu fi goh aan fahn deh ahn bileev eena di Wan weh di kohn afta hihn, ahn da wan da Jeezas.” ");
INSERT INTO bzj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Wen dehn yehr dis, dehn geh baptaiz eena di naym a di Laad Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Den Paal put ih han pahn dehn ahn di Hoali Spirit kohn pahn dehn, ahn dehn staat tu taak eena tongz ahn dehn staat tu prafesai. ");
INSERT INTO bzj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Da mi bowt twelv a dehn dis hapm tu. ");
INSERT INTO bzj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Joorin di neks chree monts, Paal wuda goh da di Jooish meetn plays evri day, ahn ih neva frayd fi aagyu wid di peepl dehn ahn chrai fi kanvins dehn bowt Gaad kingdom. ");
INSERT INTO bzj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Bot som a dehn mi oanli stobant ahn wudn bileev. Insted, dehn staat tu seh wikid tingz bowt di Way a di Laad Jeezas rait fronta evribadi. Soh Paal lef dehn loan ahn disaid fi moov owt wid di disaipl dehn. Dehn gaahn da Tiranos lekcha haal, ahn Paal teech deh evri day. ");
INSERT INTO bzj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Paal kantinyu wid ih teechin fi too yaaz, ahn bikaaz a dat, aal di Jooz dehn ahn aal di Greek peepl dehn weh liv eena Aysha, mi kohn fi yehr di Werd a di Laad. ");
INSERT INTO bzj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Den Gaad staat tu perfaam sohn grayt ahn powaful mirakl chroo Paal. ");
INSERT INTO bzj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Peepl kehr eevn di hanki ahn aypran dehn weh toch Paal, ahn put dehn pahn dehn sik ahn dehn geh heel. Noh oanli dat, bot di eevl spirit dehn lef dehn tu. ");
INSERT INTO bzj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wel, dehn mi ga sohn Jooz weh chravl rong di jraiv owt eevl spirit. Dehn chrai fi yooz di naym a di Laad Jeezas tu. Dehn seh tu di eevl spirit dehn, “Ah koman yu, eena di naym a Jeezas weh Paal preech, fi kom owt.” ");
INSERT INTO bzj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Now yu mi ga sebm son a wahn Jooish hai prees nayhn Skeeva weh mi-di du dis. ");
INSERT INTO bzj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bot wen dehn gi di koman, di eevl spirit tel dehn seh, “Ah noa Jeezas, an Ah noa Paal, bot da hoo yoo?” ");
INSERT INTO bzj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ahn di man weh mi ga di eevl spirit jomp pahn dehn, ahn gi dehn wahn beetn soh bad dat dehn ron owta di hows naykid, bata op ahn di bleed. ");
INSERT INTO bzj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Wen di Jooz dehn ahn di Greek peepl dehn weh liv eena Efisos yehr dis, dehn mi fraitn bad ahn dehn riyalaiz seh dat dehn beta aana di naym a di Laad. ");
INSERT INTO bzj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Lata dehn wan weh bileev eena Jeezas ahn weh mi-di du oabya kom owt eena di oapm ahn kanfes it. ");
INSERT INTO bzj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Som a dehn wan weh mi-di du oabya er blak majik bring dehn blak majik buk dehn ahn bon dehn op eena poblik. Wen dehn kalkyulayt humoch di buk dehn wot, ih wuda mi kom op tu bowt fifti towzn pees a silva. ");
INSERT INTO bzj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Soh di Werd a Gaad mi powaful ahn ih gaan owt evriway ahn moa ahn moa peepl bileev. ");
INSERT INTO bzj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Afta aala dis hapm, di Hoali Spirit leed Paal fi goh da Jeroosalem, ahn pahn ih way, ih paas chroo Masidoanya ahn Akaiya. Paal seh, “Afta Ah goh da Jeroosalem, Ah mos goh da Roam tu.” ");
INSERT INTO bzj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Paal mi ga too helpa weh nayhn Timoti ahn Erastos. Ih sen dehn heda ahn da Masidoanya, wail hihn stay bak eena Aysha fi wahn lee wail. ");
INSERT INTO bzj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Rong di sayhn taim, big chrobl staat op eena Efisos sayka di Way a di Laad Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Di chrobl staat wid wahn man weh nayhn Dimeechriyos, weh doz mek ting owta silva. Hihn mek sohn lee silva templ weh luk jos laik di reel templ weh dehn goh wership di gaadis Daiyana. Dehn wan weh werk fi Dimeechriyos mek lata moni. ");
INSERT INTO bzj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Wel, hihn kaal dehn tugeda lang wid di ada werkman dehn weh eena di sayhn bizniz, ahn ih tel dehn seh, “Aala unu, lisn op. Unu noa seh dat dis bizniz bring een lata moni fi wee. ");
INSERT INTO bzj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Now unu mosi si ahn yehr how noh oanli da Efisos, bot evriway eena Aysha, dis man Paal hihn di invigl peepl fi bileev seh dat gaad weh mek wid hyooman han da noh reel gaad ataal. ");
INSERT INTO bzj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Bikaaz a dis, fi wee bizniz wahn geh bad naym. Noh oanli dat, peepl noh wahn rispek di templ a di grayt gaadis Daiyana nohmoh. Ahn Daiyana ihself, weh evribadi eena Aysha ahn aal oava di werl wership, wahn kohn tu notn, ahn evribadi wahn faget aal bowt shee.” ");
INSERT INTO bzj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Wen di krowd yehr dis, dehn geh beks bad ahn staat tu hala, “Daiyana a Efisos grayt!” ");
INSERT INTO bzj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Wahn krowd staat tu gyada, ahn bifoa yu noa it, raiyat staat eena di siti. Di krowd rosh ahn grab Gaiyos ahn Aristaakos, weh da-mi too Masidoanyan man weh mi-di chravl wid Paal. Dehn jreg dehn gaahn da di staydyom weh dehn hoal dehn poblik meetn. ");
INSERT INTO bzj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paal ihself mi waahn goh een deh fi taak tu di krowd, bot di bileeva dehn neva alow ahn. ");
INSERT INTO bzj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Eevn som a di ofishal dehn weh da-mi ih fren sen wahn mesij fi tel ahn noh fi goh een deh. ");
INSERT INTO bzj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lata naiz ahn kanfyoozhan mi deh eensaid. Som a di peepl dehn mi-di hala wan ting ahn som a dehn wahn nada ting. In fak, moas a dehn neva eevn noa da wai dehn mi dehdeh. ");
INSERT INTO bzj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Di Jooish leeda dehn push wahn man nayhn Alegzanda op da front fi eksplayn weh di hapm. Dehn mi-di hala tel ahn weh fi seh. Ih put op ih han fi sailens ahn oapm ih mowt fi staat eksplayn. ");
INSERT INTO bzj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Bot wen di krowd fain owt dat hihn da wahn Joo, aala dehn staat tu hala tugeda seh, “Daiyana a Efisos da di graytis!” Dehn kip dis op fi too owaz. ");
INSERT INTO bzj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","At laas di siti klerk kuda mi kwaiyet dehn dong ahn soh taak tu dehn. Ih seh, “Unu peepl a Efisos, evribadi noa seh dat di siti a Efisos da di senta fi di grayt Daiyana bikaa da yasoh fi shee stachu mi faal dong fahn hevn. ");
INSERT INTO bzj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nobadi kyaahn seh dat da noh chroo. Soh den, unu mos kyaam dong ahn noh du notn schupid. ");
INSERT INTO bzj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Dehnya man weh unu bring noh gilti a notn bad. Dehn noh seh notn bad bowt di gaadis ahn dehn neva teef notn fahn ih templ. ");
INSERT INTO bzj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","If Dimeechriyos ahn di ada werka dehn gat eniting gens dehn, mek dehn kehr dehn kays da koat; dat da weh di koat dehdeh fa. ");
INSERT INTO bzj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ahn if unu ga ada komplaynt gens dehn, dehn ku setl dehndeh da di regyula leegal sitizn meetn. ");
INSERT INTO bzj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Bikaaz if wi noh ga no gud reezn fi weh hapm tudeh, di Roaman govament ku kaal wi op fi kaaz di raiyat.” ");
INSERT INTO bzj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Afta ih don seh dis, di siti klerk dismis di meetn. ");
INSERT INTO bzj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Afta di raiyat don ahn tingz get bak kyaam, Paal sen fi di bileeva dehn. Ih tel dehn ting fi inkorij dehn ahn tel dehn gudbai, ahn den ih lef ahn gaahn da Masidoanya. ");
INSERT INTO bzj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Az ih paas chroo di difrent siti dehn, ih wuda stap ahn gi di peepl dehn lata inkorijment. Den ih stap aaf da Grees ");
INSERT INTO bzj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","fi chree monts ahn ih mi-di geh redi fi sayl da Siriya wen ih fain owt seh di Jooz dehn mi-di plan fi kil ahn; soh Paal disaid fi goh bak chroo Masidoanya. ");
INSERT INTO bzj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Dehnya da di man dehn weh mi-di chravl wid Paal: Sopata, weh da-mi Piros fahn Bereeya son, ahn Aristaakos ahn Sekundos fahn Tesalonaika. Den yu mi ga Gaiyos fahn Derbi, ahn Tichikos ahn Chrofimos fahn Aysha, ahn den Timoti. ");
INSERT INTO bzj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Dehn gaahn hed ahn wayt fi wee da Chroawaz. ");
INSERT INTO bzj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Den wi sayl fahn Filipai afta di Paasoava selibrayshan, ahn faiv dayz layta wi meet op wid di ada wan dehn da Chroawaz, wehpaa wi spen wahn week. ");
INSERT INTO bzj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Di Satideh eevnin wi mi get tugeda fi eet ahn fi selibrayt kamyoonyan. Paal mi-di preech, ahn bikaa ih mi-di plan fi lef di neks day, ih preech lang til afta midnait. ");
INSERT INTO bzj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Di opstayz room wehpaa wi mi-di meet mi lait op wid lata lamp. ");
INSERT INTO bzj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Wahn yong man weh nayhn Yootikos mi-di sidong pahn di winda sil. Paal mi-di taak ahn taak, ahn Yootikos mi-di geh sleepiya ahn sleepiya til ih faal song asleep ahn jrap chroo di winda fahn di terd stoari tu di grong. Wen dehn pik ahn op, ih mi don ded. ");
INSERT INTO bzj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Bot Paal kohn dong ahn chroa ihself pan ahn, ahn hog ahn op. Ih tel dehn seh, “Noh wori, di bwai alaiv.” ");
INSERT INTO bzj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Den ih gaahn bak opstayz gaahn eet ahn selibrayt kamyoonyan wid dehn. Afta dat Paal taak tu dehn til maanin, wen di son rayz, ahn den ih lef. ");
INSERT INTO bzj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Az fi di bwai, dehn kuda mi kehr ahn hoahn alaiv, soh dehn mi reeli feel gud bowt dat. ");
INSERT INTO bzj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paal mi araynj seh dat wee wuda goh bai ship tu Asos wail hihn goh bai road ahn jain op wid wi deh. ");
INSERT INTO bzj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Soh wen wi meet ahn da Asos, ih kohn pahn boad di ship wid wi ahn wi sayl fi Mitileen. ");
INSERT INTO bzj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Di neks day wi set sayl ahn wi reech kraas fahn Kyos. Di day afta dat wi reech Samos, ahn wan day layta wi reech Maileetos. ");
INSERT INTO bzj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paal mi disaid seh dat ih noh wahn stap da Efisos bikaa ih neva waahn spen no taim da Aysha. Ih mi-di hori fi geh da Jeroosalem, if pasabl, in taim fi di selibrayshan a Pentikaas. ");
INSERT INTO bzj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Bot wen ih lan da Maileetos, ih disaid seh fi sen wahn mesij tu di cherch elda dehn da Efisos fi kohn dong da di boat, kohn meet wid ahn wen ih lan deh. ");
INSERT INTO bzj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Wen dehn reech, ih tel dehn seh, “Unu noa seh dat fahn di fos day Ah set fut eena Aysha, how Ai mi stan. ");
INSERT INTO bzj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ah mi du di Laad werk hombl-wan ahn wid tyaaz, eevn doa Ah gaahn chroo lata chraiyalz ahn testin wid dehn Jooz weh mi-di nak hed tugeda gens mi aal di taim. ");
INSERT INTO bzj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Unu noa seh dat Ai neva frayd fi preech eniting weh wuda mi help unu. Ah neva frayd fi teech unu eena poblik ner goh fahn hows tu hows. ");
INSERT INTO bzj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ah mi ga wan mesij fi di Jooz dehn ahn fi di Greek dehn—dat dehn mos ton fahn dehn sin dehn ahn ton tu Gaad, ahn put dehn fayt eena di Laad Jeezas. ");
INSERT INTO bzj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ahn now di Hoali Spirit tel mi seh dat Ah fi goh da Jeroosalem, eevn doa Ah noh noa weh wahn hapm tu mi deh. ");
INSERT INTO bzj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Di Hoali Spirit oanli tel mi seh dat jayl ahn sofarin wahn fala mi da evri siti. ");
INSERT INTO bzj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Bot fi mee laif noh wot notn if Ah noh yooz it fi du di werk weh di Laad Jeezas gi mi fi du—dat da fi tel evribadi di Gud Nyooz bowt di grays a Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ahn now Ah noa seh dat non a unu weh Ah gaahn bowt di preech tu bowt Gaad kingdom wahn si mi fays agen. ");
INSERT INTO bzj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mek Ah mek it playn seh dat if eni a unu en op da hel, da noh sayka mee, ");
INSERT INTO bzj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","bikaaz Ah mi mek shoar dat Ah preech di mesij weh Gaad gi mi tu unu. ");
INSERT INTO bzj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Now unu hafu deh pahn unu gyaad, ahn mek shoar dat unu tek kayr a unuself ahn di flak weh di Hoali Spirit put unu az shepad oava. Dis flak da di cherch weh Gaad bai wid fi hihn oan blod. ");
INSERT INTO bzj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ah noa seh dat az soon az Ah ton mi bak, faals teechaz wahn kom een fi di kil laik wail wulf. ");
INSERT INTO bzj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ih wahn kohn tu di paint weh yu wahn ga dehn wan rait fahn monks unu weh wahn chaynj op di chroot fi chrai win di bileeva dehn pahn fi dehn said. ");
INSERT INTO bzj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Soh deh pahn unu gyaad, az unu memba how nait ahn day fi chree yaaz Ah teech unu ahn shed tyaaz oava evri wan a unu. ");
INSERT INTO bzj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Now Ah di put unu eena Gaad han. Unu noh faget di mesij bowt fi hihn grays! Dis mesij wahn bil op unu fayt ahn gi unu aala weh bilangz tu unu sayka weh unu da Gaad peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ah waahn rimain unu seh dat Ai mi neva red aiy wen ih kohn tu moni ahn kloaz. ");
INSERT INTO bzj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Unu unuself noa seh dat dehnya han yoostu werk haad fi tek kayr a mi needz ahn fi tek kayr a dehn wan weh mi deh wid mi tu. ");
INSERT INTO bzj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Eena evriting weh Ah mi du, Ah lef wahn egzampl fi unu fala dat unu fi tek kayr a dehn wan weh week, bikaa memba seh dat da di Laad Jeezas ihself mi seh, ‘Gaad bles yu moa wen yu gi dahn wen yu get.’” ");
INSERT INTO bzj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Wen Paal finish seh dis, ih neel dong ahn pray wid aala dehn. ");
INSERT INTO bzj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Aala dehn staat tu krai az dehn hog ahn op ahn kis ahn gudbai. ");
INSERT INTO bzj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Weh mek dehn feel moa sad da wen Paal tel dehn dat dehn noh wahn si ih fays agen. Den dehn tek dehn laas waak wid Paal dong tu di ship. ");
INSERT INTO bzj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","At laas wi manij fi tayr wiself fahn dehn, ahn wi sayl schrayt fi di ailan a Kos. Di neks day wi reech Roadz, ahn fahn deh wi gaan aan tu Pataara. ");
INSERT INTO bzj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Dehsoh wi fain wahn ship weh mi gwehn da Foneesha, soh wi gaahn boad ahn set sayl fi deh. ");
INSERT INTO bzj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Pahn wi way tu Taiya, wi paas di ailan weh nayhn Saipros pahn wi lef. Wen wi reech Taiya, weh deh eena Siriya, di ship stap deh fi anload. ");
INSERT INTO bzj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Dehsoh wi fain sohn loakal bileeva ahn stay wid dehn fi wan week. Dehn waan Paal dat di Hoali Spirit tel dehn seh dat ih noh fi goh da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Bot wen di taim mi kohn fi boad di ship agen, wi lef ahn kantinyu wi jerni. Aala di bileeva dehn, lang wid dehn waif ahn pikni, kohn si wi aaf. Dehn waak lang wid wi til wi get owta di siti. Bifoa wi lef, wi pray wid dehn rait deh pahn di beech. ");
INSERT INTO bzj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Afta wi seh gudbai, wi boad di ship, ahn den dehn gaahn hoahn. ");
INSERT INTO bzj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Wi kantinyu wi jerni fahn Taiya ahn gaahn shoa da Toalamays, wehpaa wi greet di bileeva dehn ahn stay wid dehn fi wan day. ");
INSERT INTO bzj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Di neks day wi lef, ahn den wi reech Seezareeya. Dehsoh wi stay da Filip, weh da di evanjilis, ahn hihn da-mi wan a di sebm deekan dehn. ");
INSERT INTO bzj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Hihn mi ga foa daata weh neva marid ahn weh mi ga di gif a prafesi. ");
INSERT INTO bzj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Wi mi dehdeh fi sevral dayz wen wahn prafit weh nayhn Agabos kohn deh fahn Judeeya. ");
INSERT INTO bzj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Hihn kohn tu wi, ahn ih tek Paal belt ahn tai op fi hihn oan han ahn fut wid it. Den ih seh, “Dis da weh di Hoali Spirit seh: ‘Dis da di sayhn way how di Jooz dehn da Jeroosalem wahn tai op di oana a dis belt, ahn han ahn oava tu di peepl dehn weh da noh Joo.’” ");
INSERT INTO bzj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Wen wi yehr dis, aala wi weh di chravl wid Paal, plos di loakal bileeva dehn, bayg Paal noh fi goh da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Bot Paal ansa seh, “Da wai unu di baal ahn di chrai brok mi haat? Ai redi noh oanli fi dehn tai mi op, bot fi ded fi di Laad da Jeroosalem if Ah haftu.” ");
INSERT INTO bzj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Wen wi si dat wi kudn chaynj ih main, wi giv op ahn seh, “If da di Laad wil, wel mek ih bee soh.” ");
INSERT INTO bzj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Afta dis wi geh redi ahn pak op wi ting dehn, ahn gaahn da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Som a di disaipl dehn fahn Seezareeya mi kohn wid wi, ahn dehn kehr wi da dis man hows weh mi nayhn Nayson. Hihn da-mi fahn Saipros ahn da-mi wahn bileeva fahn di erli dayz. ");
INSERT INTO bzj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Di bileeva dehn da Jeroosalem gi wi wahn waam welkom wen wi reech deh. ");
INSERT INTO bzj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Di neks day, Paal ahn aala wi gaahn gaahn si Jaymz. Aala di elda dehn mi dehdeh. ");
INSERT INTO bzj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paal hayl dehn ahn den ih tel dehn evriting eena deetayl weh Gaad mi du chroo hihn monks di peepl dehn weh da noh Joo. ");
INSERT INTO bzj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Wen dehn yehr aala dehn ting deh, dehn prayz di Laad, bot dehn seh tu Paal, “Mi brada, yu si how lata lata Jooz bileev, ahn aala dehn oanli schrik wen ih kohn tu kip Moaziz Laa. ");
INSERT INTO bzj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Dehn yehr seh dat yoo di teech aala di Jooz dehn weh liv monks peepl weh da noh Joo dat dehn noh hafu du weh Moaziz seh, laik serkomsaiz dehn pikni ner fala fi wee kostom dehn. ");
INSERT INTO bzj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Soh da weh wi wahn du bowt dis? Dehn wahn definaytli yehr seh dat yu kohn. ");
INSERT INTO bzj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Soh du weh wi tel yu. Yu ga foa man weh mek wahn vow tu Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Goh lang wid dehn ahn jain eena dehn washin serimoni ahn pay fi dehn soh dat dehn ku shayv dehn hed. Den evribadi wahn noa seh dat di stoari dehn weh dehn yehr bowt yoo da noh chroo bikaa yu di kip di Laa stil. ");
INSERT INTO bzj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Now kansaanin dehn bileeva dehn weh da noh Joo, wi mi don rait dehn dat dehn noh hafu fala fi wee kostom dehn bot dehn mos kip dehnya rool: ‘Dehn noh fi eet no food weh mi aafa tu aidal; dehn noh fi eet blod ner no meet weh kohn fahn animal weh mi schrangl; ahn wahn man noh fi ga seks wid wahn uman if ih noh marid tu ahn.’” ");
INSERT INTO bzj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Di neks day, Paal gaahn wid di man dehn ahn gaahn chroo di washin serimoni lang wid dehn. Den ih gaan eena di templ fi mek evribadi noa seh dat afta dis sebm dayz a washin finish, ih mi wahn aafa sakrifais fi eech wan a di foa man dehn. ");
INSERT INTO bzj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Bot bifoa di sebm dayz kuda mi don, sohn Jooz fahn Aysha si Paal eena di templ. Dehn ster op wahn hoal krowd gens ahn, ahn dehn hoal ahn dong. ");
INSERT INTO bzj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Den dehn staat tu hala seh, “Aala unu man weh da Joo, kohn help wi! Dis da di man weh di goh rong di teech evribadi gens fi wee peepl dehn, ahn gens fi wee Laa, ahn gens dis templ. Noh oanli dat, bot ih faysi inof fi bring sohn peepl weh da noh Joo eena di templ ahn bring shaym pahn dis hoali plays.” ");
INSERT INTO bzj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Yu si, dehn mi si Chrofimos, weh da-mi fahn Efisos, lang wid Paal erliya, soh dehn mi tink seh dat dis man mi gaan eena di templ wid Paal.) ");
INSERT INTO bzj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Wel, di hoal siti mi ton opsaid dong. Peepl kohn di ron fahn aal said. Dehn grab Paal ahn jreg ahn owta di templ ahn dehn shet di gayt kwik-wan baka dehn. ");
INSERT INTO bzj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Dehn wuda mi kil Paal if werd neva reech di ayz a di komanda a di Roaman aami da Jeroosalem dat raiyat mi-di staat. ");
INSERT INTO bzj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Faas, faas-wan ih aada owt sohn soalja ahn aafisa ahn chaaj dong pahn di krowd. Wen di krowd si di soalja dehn, dehn stap beet Paal. ");
INSERT INTO bzj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Di komanda kohn ahn ares Paal ahn tel ih soalja dehn fi tai ahn op wid too chayn. Den ih aks di peepl dehn da hoo Paal, ahn da weh ih du. ");
INSERT INTO bzj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Sohn hala wan ting ahn sohn hala sohnting els. Di komanda kudn mek no sens owta weh dehn mi-di seh, soh ih aada ih soalja dehn fi kehr Paal da di baraks. ");
INSERT INTO bzj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Wen Paal reech di step, di peepl dehn mi-di rayl op ahn goh aan soh bad dat di soalja dehn mi hafu hais Paal pahn dehn shoalda fi kehr ahn chroo di krowd. ");
INSERT INTO bzj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Di krowd fala dehn di hala, “Kil ahn! Kil ahn!” ");
INSERT INTO bzj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Jos az di soalja dehn mi wahn kehr Paal eena di baraks, Paal aks di komanda, “Ah ku tel yu sohnting?” Ih tel Paal, “Ah neva noa yu ku taak Greek. ");
INSERT INTO bzj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Yoo da noh di Eejipshan weh mi ster op chrobl gens di govament sohn yaaz bak, ahn kehr foa towzn teroris wid ahn eena di dezert?” ");
INSERT INTO bzj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paal ansa ahn seh, “No! Mee da wahn Joo, an Ai da wahn sitizn a Taasos eena Silisya weh da wahn impoatant siti. Ah di aks yu permishan fi taak tu di peepl dehn.” ");
INSERT INTO bzj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Di man gi Paal permishan ahn Paal stan op pahn di tap step. Paal hoal op ih han fi di peepl dehn geh kwaiyet. Di peepl geh kwaiyet ahn den ih taak tu dehn eena fi dehn Jooish langwij. ");
INSERT INTO bzj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Paal seh, “Mi felo Jooz, yong ahn oal, lisn mek Ah eksplayn weh hapm!” ");
INSERT INTO bzj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Wen di krowd yehr Paal di taak eena fi dehn langwij, dehn geh moa kwaiyet. Den Paal kantinyu fi seh, ");
INSERT INTO bzj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ai da wahn Joo weh baan da di siti a Taasos, weh deh eena di konchri a Silisya. Ah rayz op eena dis siti. Ai da-mi wan a Gamalyel styoodent dehn, an Ah mi wel ejukaytid eena evri singl laa a fi wee ansesta dehn. In fak, Ai mi az pashnayt wen ih kohn tu obay Gaad az eni a unu ya tudeh. ");
INSERT INTO bzj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ai doz gi di peepl dehn weh fala di Way a di Laad Jeezas haad taim soh moch dat Ah eevn geh som a dehn kil. Ah yoostu ares man ahn uman alaik ahn put dehn eena jayl. ");
INSERT INTO bzj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Yu ku aks di cheef prees er enibadi weh eena di Kongsl a leedaz, ahn dehn wahn tel yu dat dat da chroo. Dehn mi eevn gi mi sohn leta soh dat Ah ku kehr dehn tu di Jooish Kongsl da Damaskos, soh Ah ku ares peepl deh ahn bring dehn bak da Jeroosalem mek dehn ponish dehn. ");
INSERT INTO bzj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Bot ih soh hapm dat wahn day wen Ah mi gwehn da Damaskos, sodn-wan wahn brait brait lait flash rong mi fahn hevn; dis da-mi rong mid-day. ");
INSERT INTO bzj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ah jrap da grong, an Ah yehr wahn vais seh tu mi, ‘Saal, Saal, da wai yoo di persikyoot mi?’ ");
INSERT INTO bzj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“An Ah ansa seh, ‘Da hoo yoo, Laad?’ “Den hihn ansa seh, ‘Ai da Jeezas fahn Nazaret, di Wan weh yoo di persikyoot.’ ");
INSERT INTO bzj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Di peepl dehn weh mi deh wid mi mi si di lait bot dehn neva yehr weh ih mi-di seh tu mi. ");
INSERT INTO bzj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Den Ai seh, ‘Weh Ai fi du, Laad?’ “Di Laad ansa mi seh, ‘Get op ahn goh da Damaskos. Dehsoh yu wahn laan weh aal yu fi du fi mi.’ ");
INSERT INTO bzj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Di lait mi soh brait dat ih blain mi an Ah kudn si weh Ah mi gwehn, soh di man dehn weh mi deh wid mi mi hafu hoal mi han ahn leed mi da Damaskos. ");
INSERT INTO bzj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Wen Ah reech Damaskos, wahn man weh nayhn Ananaiyas kohn kohn si mi. Hihn mi schrik wen ih kohn tu kip di Laa, ahn soh di Jooz dehn doz rispek ahn. ");
INSERT INTO bzj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Wel, hihn kohn tu mi ahn seh, ‘Brada Saal, geh bak yu sait.’ Sayhn sayhn taim Ah luk op an Ah kuda mi si ahn. ");
INSERT INTO bzj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Den Ananaiyas eksplayn tu mi seh, ‘Di Gaad a mi ansesta dehn pik yoo fi noa fi hihn wil ahn fi si di Raichos Wan, ahn fi yehr di veri werd dehn fahn ih mowt. ");
INSERT INTO bzj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Yoo wahn bee fi hihn witnis fi goh aal bowt ahn tel evribadi weh yu si ahn yehr. ");
INSERT INTO bzj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Soh weh yu di wayt fa? Get op ahn goh geh baptaiz ahn kaal pahn di Laad fi wash weh yu sin dehn.’ ");
INSERT INTO bzj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Afta Ah gaahn bak da Jeroosalem, Ah gaahn da di templ fi pray. Wailz Ah mi-di pray, Ah si wahn vizhan. ");
INSERT INTO bzj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ah si di Laad di seh tu mi, ‘Hori op ahn get owta Jeroosalem faas, kaaz di peepl dehn noh wahn lisn tu weh yu ga fi seh bowt mi.’ ");
INSERT INTO bzj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Ahn den Ah seh, ‘Bot Laad, dehn wahn lisn kaaz dehn mi noa seh dat Ai neva yoostu joak wen ih kohn tu ares ahn lak op ahn beet op dehn wan weh yoostu bileev eena yoo. ");
INSERT INTO bzj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ahn wen dehn mi-di merda Steeven, hoo yoostu preech bowt yu, mee mi-di stan op rait deh di agree wid dehn, an Ah eevn mi-di hoal di kloaz fi dehn wan weh mi-di stoan ahn.’ ");
INSERT INTO bzj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Bot di Laad seh tu mi, ‘Lef Jeroosalem rait now ahn goh. Ah di sen yu faar fahn ya, tu di peepl dehn weh da noh Joo.’” ");
INSERT INTO bzj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Di krowd mi-di lisn tu Paal gud gud-wan til ih seh dat ih gwehn da di peepl dehn weh da noh Joo. Wel, da den dehn staat hala seh, “Kil ahn! Hihn noh fit fi liv pahn ert. Kil ahn!” ");
INSERT INTO bzj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Soh dehn di hala, soh dehn di haal aaf dehn koat ahn chroa dos eena di ayaa. ");
INSERT INTO bzj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Dat da wen di komanda aada di soalja dehn fi kehr Paal eena di baraks soh dat dehn ku beet ahn, ahn soh fain owt da weh dehn ga gens ahn. ");
INSERT INTO bzj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Wail di soalja dehn mi-di tai op Paal fi beet ahn, Paal aks wan a di aafisa dehn weh mi-di stan op kloas tu ahn, “Tel mi, ih leegal fi beet wahn Roaman sitizn bifoa unu chrai ahn da koat?” ");
INSERT INTO bzj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Wen di aafisa yehr dis, ih hori gaahn da di komanda ahn seh, “Da weh yoo di du? Dis man da wahn Roaman sitizn.” ");
INSERT INTO bzj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Di komanda gaahn schrayt da Paal ahn aks ahn seh, “Tel mi, yoo da wahn Roaman sitizn?” Paal tel ahn seh, “Yes, Ai da wahn Roaman sitizn.” ");
INSERT INTO bzj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Di komanda seh, “Wel, Ai mi pay wahn lata moni fi bee wahn Roaman sitizn.” Bot Paal tel ahn seh, “Ai baan wahn Roaman sitizn.” ");
INSERT INTO bzj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Di man dehn weh mi wahn beet Paal ahn kweschan ahn bak aaf sayhn taim. Di komanda ihself mi fraitn wen ih riyalaiz seh dat ih put wahn Roaman sitizn eena chaynz. ");
INSERT INTO bzj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Now di komanda mi reeli waahn noa fi sertn da wai di Jooz dehn mi deh afta Paal. Soh ih tek aaf di chayn dehn ahn ih aada di cheef prees dehn ahn di hoal Kongsl fi kohn tugeda. Den ih bring Paal fronta dehn. ");
INSERT INTO bzj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paal luk schrayt pahn di memba dehn a di Kongsl ahn seh, “Brejrin, op tu dis day Ah liv mi laif wid wahn klyaa kanshans fronta Gaad.” ");
INSERT INTO bzj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Den Ananaiyas, weh da-mi di hai prees, tel sohn man weh mi deh neks tu Paal fi lik ahn eena ih mowt. ");
INSERT INTO bzj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Wen Paal yehr dat, ih seh, “Da mee yu wahn lik? Gaad wahn lik yoo dong, yu hipokrit. Yu da jos laik dehn wait-wash waal. Yu wahn joj mee wid di Laa, bot yoo yuself di brok di Laa wen yu di luk fi slap mi.” ");
INSERT INTO bzj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Dehn wan weh mi-di stan op deh seh, “Da how dayr yoo? Yoo kyaahn di taak laik dat ahn insolt di hai prees weh Gaad put deh.” ");
INSERT INTO bzj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paal seh, “Brejrin, Ai neva noa dat hihn da-mi di hai prees. Ah hafu admit dat di Skripcha doo seh, ‘Yu noh fi taak bad bowt yu leeda.’” ");
INSERT INTO bzj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Bai dis taim, Paal riyalaiz dat som a di man dehn da-mi Sadyusee ahn sohn da-mi Farisee. Soh ih hala seh, “Brejrin, Ai da wahn Farisee ahn di son a wahn Farisee. Dehn haal mi eena dis koat bikaaz Ah bileev dat wan day di ded wahn rayz op bak tu laif.” ");
INSERT INTO bzj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Wel, wen Paal seh dat, aagyument brok owt bitween di Farisee dehn pahn wan said, ahn di Sadyusee dehn pahn di ada said. ");
INSERT INTO bzj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Yu si, di Sadyusee dehn seh dat wen sohnbadi don ded, dehn noh wahn kohn bak tu laif agen. Ahn dehn noh bileev eena aynjel ner spirit needa. Bot di Farisee dehn bileev eena aala dat. ");
INSERT INTO bzj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Soh big komoashan mi deh. Som a di teecha a di Laa weh bilangz tu di Farisee paati dehn geh hat ahn jomp op di seh, “Wee noh fain notn rang wid dis man. Sopoaz dat da wahn spirit er wahn aynjel di taak tu hihn.” ");
INSERT INTO bzj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Wel, di kwaaril geh hata ahn hata, soh di komanda disaid fi du sohnting bikaa ih mi frayd seh dat dehn mi wahn tayr Paal tu peesiz. Ih aada di soalja dehn fi get Paal owta deh ahn kehr ahn bak da di soalja baraks. ");
INSERT INTO bzj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Da nait, di Laad kohn tu Paal ahn seh, “Noh giv op, Paal. Sayhn way how yu witnis bowt mi ya da Jeroosalem, da di sayhn way yu wahn hafu witnis bowt mi da Roam.” ");
INSERT INTO bzj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Di neks maanin, sohn Jooz kohn tugeda ahn dehn mek wahn vow seh dat dehn noh wahn eet notn ner jrink notn til dehn kil Paal. ");
INSERT INTO bzj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Da mi oava faati a dehn weh mek dis vow. ");
INSERT INTO bzj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Aala dehn kohn tugeda ahn gaahn fronta di cheef prees dehn ahn di ada Jooish leeda dehn ahn tel dehn seh, “Wee vow monks wiself dat wi noh wahn eet notn ahn wi noh wahn jrink notn til wi don kil Paal. ");
INSERT INTO bzj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Soh weh yu ku du, da priten seh yu waahn fain owt moa fahn Paal bowt dis hoal mata, soh mek unu ahn di Kongsl aks di komanda fi bring ahn bak soh unu ku kweschan ahn. Den bifoa ih eevn kohn fronta unu, wee wahn kil ahn.” ");
INSERT INTO bzj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Bot Paal nevyoo yehr bowt di plan, ahn sayhn taim hihn gaahn da di baraks gaahn tel Paal. ");
INSERT INTO bzj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paal kaal wan a di aafisa dehn ahn tel ahn seh, “Kehr dis yong man da di komanda. Ih ga sohnting impoatant fi tel ahn.” ");
INSERT INTO bzj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Soh di aafisa kehr ahn tu di komanda ahn eksplayn seh, “Di prizna weh nayhn Paal aks mi fi kehr dis yong man tu yu kaa ih ga sohnting fi tel yu.” ");
INSERT INTO bzj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Di komanda kehr di bwai wan said soh nobadi ku yehr, ahn ih aks ahn seh, “Da weh yu waahn tel mi?” ");
INSERT INTO bzj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Paal nevyoo tel ahn seh, “Sa, sohn Jooz wahn aks yu fi bring Paal da di Kongsl tumaaro ahn dehn wahn priten seh dehn waahn aks ahn sohn kweschan fi geh moa infamayshan. ");
INSERT INTO bzj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bot pleez noh bileev weh dehn seh, kaa moa dan faati man wahn di haid lang di way fi jomp pan ahn, ahn kil ahn. Aala dehn mi mek wahn vow seh dat dehn noh wahn eet notn ner jrink notn til dehn kil Paal. Dehn don gat evriting set; dehn oanli di wayt fi di goa-ahed fahn yoo.” ");
INSERT INTO bzj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Bifoa di komanda sen weh di yong man, ih waan ahn seh, “Noh mek nobadi noa seh yu tel mi dis.” ");
INSERT INTO bzj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Soh now di komanda kaal too a ih aafisa ahn tel dehn seh, “Get tugeda too honjrid soalja fi goh da Seezareeya, ahn semti man pahn haas, ahn too honjrid soalja wid spyaa weh wahn chravl pahn fut. Ah waahn dehn redi fi maach bai nain aklak tunait. ");
INSERT INTO bzj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Paal wahn need sohn haas tu fi chravl pan. Ah waahn yu kehr ahn sayf-wan tu Feeliks, di govna.” ");
INSERT INTO bzj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Soh di komanda rait wahn leta laik dis: ");
INSERT INTO bzj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Fahn Klaadiyos Lisyas tu yu Ekselensi di Govna Feeliks: Greetinz. ");
INSERT INTO bzj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Dis man mi geh arestid bai sohn Jooz weh mi wahn kil ahn, bot sayhn taim Ai kohn wid mi soalja dehn ahn reskyu ahn, kaa Ah mi laan seh dat hihn da-mi wahn Roaman sitizn. ");
INSERT INTO bzj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Afta dat, Ah kehr ahn fronta dehn Kongsl fi chrai fain owt da weh ih mi du. ");
INSERT INTO bzj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ah soon fain owt seh dat da mi sohnting fi du wid fi dehn rilijos laa dehn. Da mi notn weh mi dizerv det ner lak op. ");
INSERT INTO bzj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Bot layta now, sohnbadi kohn tel mi bowt wahn plan fi kil ahn. Rait away Ah sen ahn tu yoo. Ah don tel dehn dat wateva chaaj dehn ga gens ahn, fi mek dehn bring it tu yoo. Pleez tek chaaj a dis mata.” ");
INSERT INTO bzj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Soh da nait di soalja dehn kehr Paal da di siti a Antipachris, az dehn mi aada dehn fi du. ");
INSERT INTO bzj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Den di soalja dehn weh mi deh pahn fut ton bak ahn gaahn bak da di baraks da Jeroosalem, wailz di soalja dehn pahn haas kehr Paal da Seezareeya. ");
INSERT INTO bzj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Wen dehn reech Seezareeya, dehn kehr Paal ahn di leta schrayt tu Govna Feeliks. ");
INSERT INTO bzj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Hihn reed it ahn den ih aks Paal da weh konchri hihn kohn fram. Paal ansa ahn seh, “Silisya.” ");
INSERT INTO bzj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Den di govna seh, “Wel, Ah wahn yehr yu kays az soon az dehn wan weh ga di kays gens yu kohn.” Den di govna aada dat dehn lak op Paal eena di prizn da Herod palis. ");
INSERT INTO bzj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Faiv dayz layta, Ananaiyas, weh da di hai prees, gaahn dong da Seezareeya lang wid som a di Jooish leeda dehn, ahn wahn laaya weh nayhn Tertilos, fi lay owt dehn kays gens Paal fronta di govna. ");
INSERT INTO bzj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Dehn bring een Paal, ahn Tertilos staat ih kays gens ahn. Dis da weh ih seh: “Anarabl Feeliks, anda fi yoo waiz rool, wi nayshan ga pees fi wahn lang taim now, ahn yu mek lata chaynj fi di beta. ");
INSERT INTO bzj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Aala wi evriway reeli graytful fi aal weh yu du fi wi. ");
INSERT INTO bzj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Now Ah noh waahn bada yu, bot jos ga lee payshens wid wi ahn lisn tu mi fi wahn fyoo minits. ");
INSERT INTO bzj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Dis man ya da wahn chroblmayka ahn ih reeli laik ster op faiya monks di Jooz dehn aal oava di werl. Hihn da di ringleeda fi wahn rilijos paati weh nayhn di Nazareen dehn. ");
INSERT INTO bzj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Hihn eevn chrai fi disrispek fi wee templ, ahn soh wi ares ahn, ahn wi waahn chrai ahn fi brok wi Laa. ");
INSERT INTO bzj_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Bot sayhn taim, di komanda Lisyas hihn kohn ahn manhandl ahn fahn wee. ");
INSERT INTO bzj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Den ih aada dat dehn wan weh akyooz ahn mos kohn fronta yoo. Yu wahn fain owt dat dehn ting ya weh Ah di seh da chroo wen yu kweschan ahn yuself.” ");
INSERT INTO bzj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Di ada Jooz dehn weh mi dehdeh staat jain een seh, “Da chroo weh ih di seh.” ");
INSERT INTO bzj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Den di govna nad tu Paal fi mek ih noa dat da mi fi hihn tern fi taak now. Soh Paal staat. Ih seh, “Ah noa, Sa, dat yoo da wahn joj oava dis nayshan fi lata yaaz, soh Ah stan op fronta yu hapi fi lay owt mi kays tu yu. ");
INSERT INTO bzj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Yu ku fain owt eezi-wan dat da oanli twelv dayz sins Ai deh ya da Jeroosalem, di wership da di templ. ");
INSERT INTO bzj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ah neva aagyu wid nobadi da di templ. Ah neva ster op no chrobl fi mek peepl waahn raiyat eena di Jooish meetn plays ner pahn schreet. ");
INSERT INTO bzj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","No way dehn man ya kuda proov di ting dehn weh dehn seh mee du. ");
INSERT INTO bzj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Ah hafu tel yu doh, dat da chroo seh dat Ai fala Di Way a di Laad Jeezas, weh dehn seh da wahn rang way. Ah mos tel yu seh tu dat Ai wership di Gaad a fi wee ansesta dehn, an Ai schrangli bileev di Laa ahn aal weh di prafit dehn rait. ");
INSERT INTO bzj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ai ga fi mee hoap ahn kanfidens eena Gaad jos laik dehn man ya, dat wan day Gaad wahn rayz op di raichos ahn di wikid. ");
INSERT INTO bzj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Bikaaz a dis, Ai aalwayz chrai mi bes fi kip wahn klyaa kanshans wid Gaad ahn man eena evriting weh Ah du. ");
INSERT INTO bzj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Ah mi gaahn weh fi kwait a fyoo yaaz, an Ah kohn bak da Jeroosalem now fi bring moni fi help mi Jooish peepl dehn ahn fi aafa sakrifais tu Gaad. ");
INSERT INTO bzj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Da mi wail Ah mi-di goh chroo di serimoni fi mek miself kleen fronta Gaad dat dehn wan weh gat it gens mi kohn ster op chrobl. No krowd neva deh rong mee, wosa no raiyat. ");
INSERT INTO bzj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","“Da sohn Jooz fahn Aysha weh staat di hoal ting, ahn fi si dat dehn noh deh ya tudeh fi seh da weh dehn ga gens mee. ");
INSERT INTO bzj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Wel, Ah sopoaz dehn wan weh deh ya kuda seh da weh kraim di Jooish Kongsl fain mee gilti a. ");
INSERT INTO bzj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Di oanli ting weh Ah ku tink bowt dat maybi dehn kuda seh Ah mi gilti a, da wen Ah mi stan op fronta dehn ahn hala seh, ‘Ah deh pahn chraiyal fronta unu tudeh bikaa Ah bileev seh dat Gaad wahn mek dehn peepl weh ded kohn bak tu laif agen!’” ");
INSERT INTO bzj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Den Feeliks, doa ih mi noa evriting bowt di Way a di Laad Jeezas, neva waahn mek wahn disizhan sayhn taim, soh ih disaid fi ajern di kays. Ih seh, “Unu wayt til Komanda Lisyas kohn, den Ah wahn disaid di kays.” ");
INSERT INTO bzj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Feeliks aada di aafisa weh mi in chaaj fi kip Paal anda gyaad, bot gi ahn sohn freedom soh dat ih fren dehn ku kohn vizit ahn, ahn soh tek kayr a ahn. ");
INSERT INTO bzj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Sohn dayz layta, Feeliks kohn wid ih waif Jrusila, weh da-mi wahn Joo. Ih sen fi Paal fi kohn taak tu dehn bowt ih fayt eena Krais Jeezas. Hihn ahn ih waif lisn gud. ");
INSERT INTO bzj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Paal reezn wid dehn bowt raichosnis, ahn self-kanchroal, ahn jojment weh wahn kohn. Wen Feeliks yehr aala dis, ih geh fraitn. Soh ih seh, “Dat da inof fi rait now. Yu ku goh. Wen Ah ga taim agen, Ah wahn sen fi yu.” ");
INSERT INTO bzj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Now Feeliks mi-di hoap seh dat Paal wuda braib ahn wid moni fi let ahn goh, soh ih staat tu sen far ahn moa ahn moa fi taak tu ahn. ");
INSERT INTO bzj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Hoal a too yaaz paas laik dis, ahn den wahn nyoo man tek oava fahn Feeliks, nayhn Porsyos Festos. Wen Feeliks mi-di lef, ih lef Paal rait deh eena prizn bikaa ih mi waahn du di Jooz dehn wahn fayva. ");
INSERT INTO bzj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Chree dayz afta Festos mi deh da Seezareeya az di govna, ih gaan op da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Dehsoh di hai prees ahn di Jooish leeda dehn meet wid Festos ahn staat tel ahn aal weh dehn mi akyooz Paal a. ");
INSERT INTO bzj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Dehn bayg Festos wahn fayva, fi sen Paal bak da Jeroosalem. Akchwali dehn plan da-mi fi laywayt Paal ahn kil ahn wen dehn bring ahn pahn di way. ");
INSERT INTO bzj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Bot Festos tel dehn seh dat Paal wahn stay rait deh da Seezareeya, kaa hihn ihself gwehn bak deh direkli. ");
INSERT INTO bzj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Soh ih tel dehn seh, “Mek unu leeda dehn goh bak deh wid mi. If Paal du eniting rang, unu ku staat unu kays dong deh.” ");
INSERT INTO bzj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festos stay wid dehn ayt er ten dayz, ahn den ih gaahn bak da Seezareeya. Di veri neks day ih tek ih plays az joj, den ih gi aadaz fi dehn bring een Paal. ");
INSERT INTO bzj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Di minit Paal waak eena di koat room, di Jooz dehn weh mi kohn dong fahn Jeroosalem, dehn sorong ahn, ahn staat tu akyooz ahn bowt sohn seeryos tingz weh dehn kudn proov. ");
INSERT INTO bzj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paal stan op fi difen ihself ahn seh, “Sa, Ai noh komit no kraim gens di Jooish Laa, ner di templ ner gens Seeza.” ");
INSERT INTO bzj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Den Festos, sayka weh hihn mi waahn pleez di Jooz dehn, aks Paal seh, “Yoo wilin fi goh op da Jeroosalem ahn stan chraiyal fronta mi deh?” ");
INSERT INTO bzj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bot Paal ansa seh, “No, Sa! Ai noh don di stan pahn chraiyal fronta Seeza koat rait now? Soh Ah noh si wai yu kyaahn chrai mi rait ya. Yu wel noa seh dat Ai noh du di Jooz dehn notn. ");
INSERT INTO bzj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","If Ai du sohnting weh dizerv det, Ai noh main fi ded. Bot if Ai inosent, den needa yoo ner nobadi noh ga no rait fi han mi oava tu dehn. Mek Seeza ihself chrai mi.” ");
INSERT INTO bzj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festos taak it oava wid ih advaiza dehn ahn den ih tel Paal seh, “Yu aks fi Seeza chrai yu, soh da Seeza yu gwehn tu.” ");
INSERT INTO bzj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Now sohn taim layta King Agripa ahn ih sista, Bernis, kohn kohn hayl Festos. ");
INSERT INTO bzj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Dehn dehdeh fi sevral dayz, ahn joorin da taim Festos taak oava Paal kays wid di king. Ih seh, “Wi ga wahn prizna ya weh Feeliks lef fi wee ten tu. ");
INSERT INTO bzj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Wen Ah mi deh da Jeroosalem, di cheef prees dehn ahn di Jooish leeda dehn pres chaajiz gens ahn, ahn mi waahn Ah sentens ahn tu det. ");
INSERT INTO bzj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Wel, af koars mee mikays paint owt tu dehn dat wee Roamanz noh du ting soh; wee noh sentens nobadi widowt yehr dehn kays fos. Wee hafu mek shoar dat di man geh wahn chaans fi fays ih akyooza dehn ahn difen ihself. ");
INSERT INTO bzj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Soh wen di Jooz dehn kohn dong ya wid mi fi di kays, Ah neva ways no taim; di veri neks day Ah tek mi seet eena di koat ahn aada dehn fi bring een Paal. ");
INSERT INTO bzj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Wen dehn staat tu chroa dehn chaaj dehn pahn Paal, da mi notn fi du wid di kaina kraim Ai mi-di ekspek. ");
INSERT INTO bzj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Da mi sohnting fi du wid fi dehn rilijan, ahn bowt sohnbadi weh nayhn Jeezas weh don ded, bot weh Paal insis seh mi alaiv. ");
INSERT INTO bzj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ah neva noa weh fi du fi get tu di batam a dis hoal ting, soh Ah aks Paal if ih wuda waahn goh op da Jeroosalem fi stan chraiyal deh pahn di chaaj dehn gens ahn. ");
INSERT INTO bzj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Bot Paal seh ih waahn Ai kip ahn rait ya da Seezareeya til Seeza ku disaid weh fi du bowt ahn. Soh Ah aada fi dehn kehr ahn bak da jayl til Ah ku araynj fi sen ahn da Seeza.” ");
INSERT INTO bzj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa tel ahn seh, “Yu noa wat, Ai wuda laik fi yehr di man miself.” Soh Festos ansa seh, “Wel, yu ku yehr ahn tumaaro.” ");
INSERT INTO bzj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Soh di neks day Agripa ahn Bernis mek wahn gran enchrans eena di aditoaryam wid lata shoa. Aala di big shat dehn ahn di aami aafisa dehn mi dehdeh. Den Festos aada dehn fi bring owt Paal. ");
INSERT INTO bzj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festos get op ahn seh, “King Agripa ahn evribadi weh deh ya, dis da di man weh di Jooz dehn ya ahn dehn wan fahn Jeroosalem di hala seh dat dehn waahnt ahn ded. ");
INSERT INTO bzj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Bot eena fi mee opinyan, ih noh du notn fi mek ih ded. Enihow ih aks fi wahn chraiyal fronta Seeza, ahn soh Ai disaid fi sen ahn da Roam. ");
INSERT INTO bzj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bot Ah noh noa weh Ah wahn rait tel Seeza bowt dis man. Soh Ah bring ahn fronta unu, ahn espeshali fronta yoo, King Agripa, soh dat afta unu egzamin ahn, maybi Ai mait ga sohnting fi rait. ");
INSERT INTO bzj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Bikaaz fi mee ih noh mek no sens fi sen wahn prizna way da Seeza if wi noh ga no chaaj gens ahn.” ");
INSERT INTO bzj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Den Agripa seh tu Paal, “Goh hed ahn taak ahn difen yuself.” Soh Paal rayz ih han ahn staat tu taak. ");
INSERT INTO bzj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Ih seh, “King Agripa, da wahn gud ting seh dat da fronta yoo Ah fi difen miself gens aala dehn ting weh di Jooz dehn di akyooz mi bowt, ");
INSERT INTO bzj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","bikaaz Ah noa seh dat yoo da wahn eksport wen ih kohn tu Jooish kostom ahn aala dehn ishyooz weh dehn laik aagyu bowt. Soh Ah di aks yu fi lisn ahn ga payshens wid mi. ");
INSERT INTO bzj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Aal di Jooz dehn noa how Ai liv fahn Ai yong. Dehn noa how Ah spen mi hoal laif. Di fos paat a mi laif Ah mi-di liv eena mi oan konchri, ahn afta dat Ah kohn liv da Jeroosalem. ");
INSERT INTO bzj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Dehn noa mi fi wahn lang taim, ahn if dehn wilin fi admit it, Ai da-mi wahn staanch memba a di Farisee paati, weh da di schrikis branch a fi wee rilijan. ");
INSERT INTO bzj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ahn now luk how Ai deh pahn chraiyal bikaa Ai taak seh dat Ai bileev di pramis weh Gaad mek tu fi wee ansesta dehn. ");
INSERT INTO bzj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Dat da di sayhn pramis weh di twelv chraib a fi wee peepl dehn di luk faawod tu, ahn dat da wai dehn wership Gaad day ahn nait. Yu Majesti, da sayka dis sayhn pramis, di Jooz dehn di akyooz mi. ");
INSERT INTO bzj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ai noh noa wai non a unu noh bileev seh dat ih pasabl dat Gaad ku rayz peepl fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Mee miself mi tink dat Ai shuda du evriting Ah kud gens dehn peepl weh di fala Jeezas weh da fahn Nazaret. ");
INSERT INTO bzj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Dat da weh Ah yoostu du da Jeroosalem. Ah geh atariti fahn di cheef prees dehn ahn put wahn lata bileeva eena jayl. Wen dehn sentens dehn tu det, Ai da-mi wan a dehn wan weh mi kyaas mi voat gens dehn. ");
INSERT INTO bzj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Lata taim da mee mek dehn geh ponish eena di Jooish meetn plays dehn fi geh dehn fi taak gens Jeezas. Ai mi soh hayt dehn dat Ah wuda eevn goh da farin siti fi persikyoot dehn. ");
INSERT INTO bzj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Da mi fi dis sayhn reezn wai Ah mi-di goh da Damaskos wid atariti ahn aadaz fahn di cheef prees dehn. ");
INSERT INTO bzj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Yu Majesti, da pahn di road rong mid-day, dat Ah mi si wahn brait, brait lait, braita dan di son, di kohn fahn di skai ahn shain rong mee ahn di man dehn weh mi-di chravl wid mi. ");
INSERT INTO bzj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Aala wi faal dong pahn di grong, an Ah yehr wahn vais seh tu mi eena Heebroo, ‘Saal, Saal! Da wai yu di persikyoot mi? Yu di hert yuself wen yu di chrai hert mee. Da laik wahn bul weh di kik gens di stik weh ih oana di yooz fi gaid ahn wid.’ ");
INSERT INTO bzj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ah aks ahn seh, ‘Da hoo yoo, Laad?’ “Ahn di Laad ansa, ‘Ai da Jeezas. Da mee yu di persikyoot. ");
INSERT INTO bzj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Bot get op ahn stan op pahn yu fut. Ah shoa miself tu yu bikaa Ah di pik yoo fi bee mi servant. Yu fi goh ahn tel evribadi weh yu si bowt mi tudeh, ahn yu fi tel dehn bowt moa ting weh Ah wahn shoa yu eena di fyoocha. ");
INSERT INTO bzj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ai wahn protek yu fahn yu oan peepl ahn fahn dehn peepl weh da noh Joo weh Ah di sen yu tu. ");
INSERT INTO bzj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ah waahn yu oapm dehn ayz ahn ton dehn rong fahn di daaknis weh dehn deh eena tu di lait, ahn ton dehn fahn Saytan powa tu Gaad; soh dat chroo dehn fayt eena mi, dehn wahn geh fagivnis fi dehn sin dehn ahn dehn wahn ga wahn plays monks di peepl a Gaad.’ ");
INSERT INTO bzj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Ahn soh, King Agripa, Ah neva disobay di vizhan weh Ah geh fahn hevn. ");
INSERT INTO bzj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ah staat tu preech fos da Damaskos, den Ah gaahn da Jeroosalem, ahn den Ah gaahn rong di hoal a Judeeya, an Ah staat preech tu peepl weh da noh Joo tu. Ah preech seh dat dehn mos ton fahn dehn sin dehn ahn ton tu Gaad ahn du di tingz weh rait fi shoa seh dat dehn chaynj. ");
INSERT INTO bzj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Sohn Jooz ares mi eena di templ fi di preech dis, ahn dehn chrai fi kil mi. ");
INSERT INTO bzj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Bot Gaad protek mi tu dis day. Dats wai Ah deh ya fi tel evribadi, fahn di smaalis tu di graytis, dat evriting weh yu si Ai di preech ya da di sayhn ting weh di prafit dehn ahn Moaziz mi seh mi wahn hapm. ");
INSERT INTO bzj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Dehn mi seh dat di Krais mi wahn sofa ahn dat hihn mi wahn bee di fos wan fi rayz op bak fahn di ded, fi anonks di lait a salvayshan tu di Jooz dehn, ahn tu dehn wan weh da noh Joo tu.” ");
INSERT INTO bzj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Az Paal mi-di difen ihself, Festos hala owt ahn seh, “Yoo mos krayzi, Paal! Yu stodi soh moch dat ih krayzi yu.” ");
INSERT INTO bzj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Bot Paal ansa ahn seh, “Ai noh krayzi, Yu Ekselensi! Weh Ai seh da chroo ahn ih mek sens. ");
INSERT INTO bzj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","King Agripa noa bowt dehn tingz ahn ih noa seh dat Ah taak di chroot bikaa dehnya ting weh Ah di taak bowt, dehn neva hapm eena wahn kaana! ");
INSERT INTO bzj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","“King Agripa, yoo bileev di prafit dehn? Ah noa seh yu bileev dehn.” ");
INSERT INTO bzj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa ansa Paal, “Yoo tink eena dis shaat taim yoo ku ton mee intu wahn Kristyan?” ");
INSERT INTO bzj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paal ansa, “Ih noh mata if da wahn shaat taim er wahn lang taim. Weh Ai di pray tu Gaad fa, da fi yoo ahn evribadi weh deh ya wuda bee jos laik mee eksep fi dehnya chayn.” ");
INSERT INTO bzj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Den di king, ahn di govna, ahn Bernis, ahn aala di ada wan dehn get op ahn lef. ");
INSERT INTO bzj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Afta dehn lef, dehn agree monks dehnself seh, “Dis man noh du notn fi mek dehn waahn kil ahn er fi put ahn eena prizn.” ");
INSERT INTO bzj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa seh tu Festos, “Wi kuda mi set dis man free if ih neva mi don mek wahn apeel tu Seeza.” ");
INSERT INTO bzj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Afta dehn disaid seh dat wi wahn sayl goh da Itali, dehn han oava Paal ahn sohn ada prizna tu Joolyos. Hihn da-mi wahn aafisa eena wan a di rejiment a di Roaman aami weh dehn kaal “Seeza Rejiment.” ");
INSERT INTO bzj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Wi boad wahn ship fahn Ajramityam weh mi redi fi lef fi goh da difrent plays lang di koas a Aysha; soh wi set sayl. Aristaakos, wahn Masidoanyan fahn Tesalonaika, mi deh wid wi. ");
INSERT INTO bzj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Di neks day wi reech shoa da Saidan. Joolyos mi kain tu Paal, soh ih mek Paal gaahn gaahn luk fi ih fren dehn weh liv deh ahn soh geh eniting weh ih mi need. ");
INSERT INTO bzj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Wi lef owt fahn deh agen bot bikaa di breez mi-di bloa gens wi, wi mi hafu sayl kloas tu di ailan a Saipros fi haid fahn di breez. ");
INSERT INTO bzj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Wi kraas di see paas Silisya ahn Pamfilya ahn gaahn shoa da Mira eena Lisya. ");
INSERT INTO bzj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Dehsoh di aafisa fain wahn ship weh kohn fahn Alegzanjriya ahn weh mi wahn sayl tu Itali; soh ih put wi boad. ");
INSERT INTO bzj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Wi sayl sloa sloa fi sevral dayz ahn ih neva eezi, til at laas wi reech di tong a Kinaidos. Di breez chaynj dairekshan, soh wi sayl dong di said a di ailan weh nayhn Kreet weh mi blak di breez. Wi paas Kayp Salmoneh. ");
INSERT INTO bzj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Wi stay kloas kloas tu di koas bot di see mi rof. Fainali wi reech wahn plays kaal Sayf Haaba, weh neva deh tu faar fahn di tong a Laseeya. ");
INSERT INTO bzj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Wi ways wahn lata taim deh. Bai da taim di Day a Atoanment mi don gaan. Dehn riyalaiz seh dat fi kantinyu di jerni mi wahn daynjaros, soh Paal waan dehn seh, ");
INSERT INTO bzj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Bradaz, Ah si seh dat wi jerni fahn ya goh bak wahn bee daynjaros. Wi ku laas di kaago ahn di ship, ahn eevn wi laif.” ");
INSERT INTO bzj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Bot di aafisa neva bileev Paal ataal; insted hihn bileev weh di kyaptin ahn di oana a di boat tel ahn. ");
INSERT INTO bzj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Di haaba weh dehn mi deh da neva wahn gud plays fi spen di winta non ataal. Soh nayli evribadi mi agree fi wi put owt da see ahn chrai fi reech Feeniks soh wi ku spen di winta deh. Feeniks da wahn haaba eena Kreet weh fays sowt-wes ahn naat-wes. ");
INSERT INTO bzj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Wahn lait breez fahn di sowt staat fi bloa, ahn soh di man dehn mi tink dat dehn ku kehri owt dehn plan. Soh dehn pul op anka ahn sayl az kloas az dehn ku lang di koas a Kreet. ");
INSERT INTO bzj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Bot eena no taim wahn schrang naat-ees breez laik wahn harikayn staat tu bloa dong fahn di ailan. ");
INSERT INTO bzj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Wen ih lik di ship hed aan, wi kudn goh gens it, soh wi giv op ahn jos mek di breez kehr wi lang. ");
INSERT INTO bzj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Wen wi mi-di paas sowt a wahn lee ailan weh nayhn Kowda, wi fait fi sikyoar di laifboat. ");
INSERT INTO bzj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Dehn haal it boad ahn dehn faasn sohn roap tait tait rong di ship fi kip it tugeda. Dehn mi frayd seh dehn mait ron shoa pahn sohn sanbank weh deh aafa di koas a Libya, soh dehn loar sayl ahn mek di breez kehr di ship. ");
INSERT INTO bzj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Di staam kantinyu fi di pong, soh di neks day dehn staat tu chroa som a di kaago oavaboad. ");
INSERT INTO bzj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Di terd day dehn chroa paat a di ikwipment fi di ship oavaboad wid dehn bayr han. ");
INSERT INTO bzj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Dayz pahn tap a dayz ahn wi noh si no son ner staar, ahn di breez kip aan di bloa haad-wan. Bai dis taim wi giv op hoap dat wi mi wahn reech weh wi mi gwehn sayf. ");
INSERT INTO bzj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Fi dayz now nobadi neva geh notn fi eet. Paal stan op fronta evribadi ahn seh, “Unu shuda mi lisn tu mi ahn noh lef Kreet; den wi wuda mi avaid aala dis damij ahn aala dis chrobl weh wi di goh chroo. ");
INSERT INTO bzj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ah bayg unu now fi kip haat! Nat wan a unu wahn ded; oanli di ship wahn dischrai. ");
INSERT INTO bzj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","How Ah noa dis da bikaa laas nait wahn aynjel weh kohn fahn di Gaad weh Ai bileev eena ahn weh Ai wership, kohn tu mi ahn tel mi seh, ");
INSERT INTO bzj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Noh frayd, Paal! Yu hafu stan op fronta Seeza. Bikaaz a dis, Gaad, owta ih gudnis tuwaadz yu, wahn spayr di laif a aala dehn wan weh di chravl wid yu.’ ");
INSERT INTO bzj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Soh unu tek korij, aala unu! Ai chros Gaad ahn soh Ai noa dat weh hihn seh wahn hapm. ");
INSERT INTO bzj_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Bot di oanli ting, wi wahn shiprek pahn wahn ailan.” ");
INSERT INTO bzj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Di staam neva eez op ahn fi foateen nait now wi dehdeh di jrif wid di breez eena di Meditaraynyan See. Bowt midnait di seeman dehn mi ga wahn feelin seh dat dehn mi get nayr tu lan. ");
INSERT INTO bzj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Soh dehn jrap wahn lain wid wahn wayt tai aan tu it ahn dehn fain owt seh dat di waata mi wan honjrid ahn tweni fut deep. Wahn lee bit layta dehn jrap it agen. Dis taim da mi oanli nainti fut deep. ");
INSERT INTO bzj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Wen dehn si dis, dehn mi frayd seh dat di ship mi wahn goh pahn rak, soh dehn jrap foa anka fahn di bak paat a di ship ahn den dehn pray fi daylait kohn. ");
INSERT INTO bzj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Som a di seeman dehn chrai fi eskayp fahn di ship. Dehn loar di laifboat eena di waata ahn priten seh dat dehn gwehn goh jrap sohn moa anka da di front a di ship. ");
INSERT INTO bzj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Bot Paal tel di aami aafisa ahn di soalja dehn, “If dehn seeman noh stay pahn boad, unu noh wahn ga no hoap fi sayv.” ");
INSERT INTO bzj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Soh di soalja dehn kot di roap dehn weh hoal di laifboat ahn let it goh. ");
INSERT INTO bzj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Jos bifoa daan brok Paal bayg dehn fi eet sohnting. “Fi di paas foateen dayz unu dehdeh di wori op unuself ahn unu noh eet notn. ");
INSERT INTO bzj_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ah bayg unu fi eet sohnting kaa unu wahn need it fi servaiv. Noh eevn wan hyaa pahn unu hed wahn laas.” ");
INSERT INTO bzj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Afta Paal don tel dehn dat, ih tek sohn bred, ahn ih gi Gaad tanks far it fronta aala dehn, ahn ih brok it ahn staat eet. ");
INSERT INTO bzj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Wen di res si dis, dehn staat tu feel beta ahn soh dehn staat tu eet tu. ");
INSERT INTO bzj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Da mi bowt too honjrid ahn semti-siks a wi mi deh pahn boad da ship. ");
INSERT INTO bzj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Afta evribadi beli don ful, dehn staat tu chroa di sak a weet dehn oavaboad fi laitn op di ship. ");
INSERT INTO bzj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Wen day brok, di seeman dehn neva rekonaiz di koas weh dehn deh, bot dehn noatis wahn sandi bay ahn dehn disaid seh dat if dehn kud, dehn wahn ron di ship agrong pahn dat. ");
INSERT INTO bzj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Soh dehn kot aaf di anka dehn mek dehn sink da batam a di see ahn dehn loos di roap dehn weh mi tai aan tu di roda dehn weh dehn styaa di ship wid. Afta dat dehn rayz di sayl dehn weh deh da di front a di ship soh dat di breez wuda bloa di ship faawod tu di shoa. ");
INSERT INTO bzj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Bot bifoa dehn ku reech di sandi bay, di ship hit wahn sanbank ahn ron agrong. Di front a di ship geh stok ahn kudn moov, wailz sohn big wayv brok op di staan eena peesiz. ");
INSERT INTO bzj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Di soalja dehn disaid fi kil aala di prizna dehn fi mek shoar dat dehn wudn swim tu shoa ahn soh get weh. ");
INSERT INTO bzj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Bot di aami aafisa mi waahn sayv Paal, soh hihn stap dehn. Soh insted hihn tel evribadi dat di wan dehn weh ku swim fi jomp oavaboad fos ahn chrai reech shoa. ");
INSERT INTO bzj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Di res weh kyaahn swim fi jomp oavaboad ahn hoal aan tu boad er eniting fahn di ship weh di float weh ku kehr dehn tu shoa. Soh dis da how aala wi reech shoa sayf sayf-wan. ");
INSERT INTO bzj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Wen wi reech sayf pahn shoa, wi laan seh dat di ailan mi nayhn Malta. ");
INSERT INTO bzj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Di peepl dehn weh liv pahn di ailan mi oanli frenli. Ih mi staat tu rayn ahn ih mi koal, soh dehn bil wahn faiya ahn dehn mek aala wi feel welkom. ");
INSERT INTO bzj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paal gaahn gyada op sohn faiyawud ahn ih mi-di chroa dehn pahn di faiya wen sayhn taim wahn paiznos snayk kohn fahn bitween di stik dehn ahn bait ahn pahn ih han ahn faasn aan tu it. Di heet a di faiya mosi mi jraiv ahn owt. ");
INSERT INTO bzj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Di peepl dehn si di snayk faasn aan tu Paal han ahn dehn staat tu seh tu wan anada, “Dis man da mos wahn merdara! Kaaz luk how hihn neva jrongdid wen di ship gaahn dong, bot now Jostis kech op wid ahn, ahn ih kohn rait ya fi ded.” ");
INSERT INTO bzj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Bot wen dehn luk, Paal shayk di snayk rait aafa ih han ahn eena di faiya, ahn notn neva hapm tu ahn. ");
INSERT INTO bzj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Di peepl dehn mi ekspek Paal fi swel op er jrap dong ded, bot afta dehn wayt fi wahn lang taim ahn si seh dat notn neva hapm tu ahn, dehn chaynj dehn mowt ahn staat tu seh, “Hihn da wahn Gaad!” ");
INSERT INTO bzj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Noh tu faar fahn weh aala dis mi hapm, yu mi ga sohn lan weh da-mi fi di govna a di ailan. Fi hihn naym da-mi Pooblyos. Hihn invait wi fi stay wid ahn, ahn fi chree dayz wi stay deh, ahn ih oanli chreet wi gud ahn mek wi feel at hoam. ");
INSERT INTO bzj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Pooblyos pa mi sik eena bed di sofa fahn feeva ahn daireeya. Paal gaan een gaahn si ahn, ahn pray far ahn, ahn ih put ih han pan ahn, ahn heel ahn. ");
INSERT INTO bzj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Wen dis hapm, evribadi pahn di ailan weh mi sik yehr bowt it, soh dehn kohn tu Paal ahn aala dehn geh heel tu. ");
INSERT INTO bzj_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Fi shoa seh dat dehn aana wi, dehn gi wi lata gif, ahn wen wi mi redi fi lef, dehn stak op di boat wid aal weh wi mi wahn need fi di jerni. ");
INSERT INTO bzj_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Afta chree monts wi lef Malta pahn wahn ship weh mi dak deh pahn di ailan fi di hoal winta. Dis ship weh mi nayhn “Di Twin Gaad” da-mi fahn Alegzanjriya. ");
INSERT INTO bzj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Wi reech Sirakyooz Siti ahn spen chree dayz deh. ");
INSERT INTO bzj_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Fahn deh wi kantinyu sayl ahn reech Regyom Siti. Di neks day wahn breez pik op fahn di sowt, ahn eena too dayz taim wi reech di tong a Putyoli. ");
INSERT INTO bzj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Wi fain sohn bileeva deh ahn dehn aks wi fi stay wid dehn fi wahn week. Afta dat wi reech Roam. ");
INSERT INTO bzj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Di bileeva dehn da Roam yehr seh dat wi mi-di kohn ahn dehn kohn way da di Maakit a Apyos ahn di tong a Chree Inz, fi kohn meet wi. Wen Paal si dehn, ih mi feel gud ahn tank di Laad fi dehn bikaa dehn inkorij ahn. ");
INSERT INTO bzj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Wen wi reech Roam dehn mi alow Paal fi liv bai ihself wid oanli wan soalja di gyaad ahn. ");
INSERT INTO bzj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Afta chree dayz paas, Paal kaal di Jooish leeda dehn tugeda, ahn wen dehn kohn tugeda, ih tel dehn seh, “Mi bradaz, Ah neva du notn gens fi wee peepl ner gens di kostom dehn a fi wee ansesta dehn, bot stil dehn lak mi op da Jeroosalem ahn han mi oava tu di Roamanz. ");
INSERT INTO bzj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Afta dehn mi kweschan mi, di Roamanz dehn mi waahn let mi goh bikaa dehn riyalaiz seh dat Ai neva du notn fi dizerv fi ded. ");
INSERT INTO bzj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Bot wen di Jooz dehn neva laik da disizhan, Ai mi foas fi kehr mi apeel tu Seeza, eevn doa mee persnali neva ga notn gens mi peepl dehn. ");
INSERT INTO bzj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Dats wai Ah aks fi si unu ahn taak tu unu. In fak, Ai deh ya tai op eena chaynz bikaaz Ai bileev dat di Krais weh di peepl a Izrel di hoap fa don kohn.” ");
INSERT INTO bzj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Di Jooish leeda dehn tel Paal seh, “Wee neva geh no kaina leta fahn Judeeya bowt yoo. Non a fi wee peepl neva kohn fahn deh wid no kaina nyooz bowt yu, ahn dehn neva ga notn bad fi seh bowt yu needa. ");
INSERT INTO bzj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Bot wi wuda laik fi yehr weh yu ga fi seh kaaz peepl aal oava di plays di taak gens di paati weh yu bilangz tu.” ");
INSERT INTO bzj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Soh dehn set wahn dayt wid Paal. Lat moa peepl dan di fos taim kom owt da day da di plays weh Paal mi-di stay. Fahn maanin til nait Paal eksplayn tu dehn di mesij bowt Gaad kingdom. Ih chrai fi kanvins dehn bowt Jeezas az ih koat fahn Moaziz Laa ahn di prafit dehn. ");
INSERT INTO bzj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Som a dehn mi kanvins bot som a dehn neva bileev ataal. ");
INSERT INTO bzj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Soh di peepl dehn lef di aagyu monks dehnself, espeshali afta Paal mi don seh, “Da mi reeli chroo weh di Hoali Spirit mi seh chroo di prafit Aizaiya tu unu ansesta dehn. Ih mi seh, ");
INSERT INTO bzj_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Goh ahn tel dehn peepl: Unu wahn lisn ahn lisn, bot unu noh wahn andastan wan ting. Unu wahn luk ahn luk, bot unu stil noh wahn si. ");
INSERT INTO bzj_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Bikaaz unu haat geh soh haad, da sayhn laik stik brok eena unu ayz. Unu kova op unu aiy. If unu neva du dat, den unu kuda mi si wid unu aiy, ahn yehr wid unu ayz, ahn unu kuda reeli andastan wid unu haat, ahn den unu wuda ton tu mee fi mek Ah heel unu.’” ");
INSERT INTO bzj_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Den Paal kloaz aaf di seh, “Ah waahn unu noa seh dat now Gaad mesij a salvayshan wahn geh preech tu peepl weh da noh Joo. Dehn wahn lisn!” ");
INSERT INTO bzj_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Afta Paal seh dis, wel, di Jooz dehn lef wid big big aagyument monks dehnself. ");
INSERT INTO bzj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Fi too yaaz Paal liv eena wahn plays weh ih rent fi ihself ahn dehsoh ih welkom enibadi weh kohn luk far ahn. ");
INSERT INTO bzj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Paal preech bowt Gaad kingdom ahn teech bowt di Laad Jeezas Krais. Paal neva frayd fi taak ahn nobadi neva chrai fi stap ahn.");
INSERT INTO bzj_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Dis leta da fahn mee, Paal, weh serv Krais Jeezas. Ai da wahn apasl weh Gaad pik, ahn hihn kaal mee fi goh preech fi hihn Gud Nyooz. ");
INSERT INTO bzj_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Gaad mi pramis fahn lang taim bak fi sen dis Gud Nyooz. Ih mek ih prafit dehn rait dong eena di hoali Skripcha seh dat dis Gud Nyooz mi wahn kohn. ");
INSERT INTO bzj_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Dis da di Gud Nyooz bowt Gaad Son. Wen ih Son mi kohn az wahn hyooman, hihn mi baan eena King Dayvid famili lain. ");
INSERT INTO bzj_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Wen Gaad rayz wi Laad Jeezas Krais op bak fahn di ded, ih proov seh dat Jeezas da-mi di Son a Gaad chroo di powa a fi hihn oan Spirit weh hoali. ");
INSERT INTO bzj_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Chroo Jeezas Krais, ahn sayka fi hihn naym, Gaad gi mi grays ahn mek Ai bee wan a fi hihn apasl dehn, soh dat Ai ku goh help aala dehn peepl weh da noh Joo fi bileev eena Jeezas Krais, ahn fi obay ahn. ");
INSERT INTO bzj_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ahn unu tu, weh deh da Roam, deh monks dehn wan weh Gaad kaal fi bilangz tu Jeezas Krais. ");
INSERT INTO bzj_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Soh Ah di rait tu aala unu da Roam, unu weh Gaad lov, ahn weh hihn kaal fi bee fi hihn oan peepl dehn. Ah di pray seh dat Gaad wi Faada ahn di Laad Jeezas Krais gi unu grays ahn pees eena unu haat. ");
INSERT INTO bzj_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Now fos ting, Ah tank mi Gaad chroo Jeezas Krais fi aala unu, kaa peepl aal oava di hoal werl di seh how unu chros eena Jeezas Krais. ");
INSERT INTO bzj_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ai di serv Gaad wid aal mi haat an Ah di tel di Gud Nyooz bowt ih Son, ahn Gaad noa dat weh Ah seh da chroo. Hihn noa seh dat Ai aalwayz pray fi unu. ");
INSERT INTO bzj_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","An Ah di pray dat Gaad wahn mek wahn way fi mek Ah kohn si unu laik weh Ah waahn du fahn lang taim, if da Gaad wil. ");
INSERT INTO bzj_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ah waahn kohn si unu bad, soh dat Ah ku shayr som a di gif dehn fahn di Hoali Spirit, weh wahn schrentn unu. ");
INSERT INTO bzj_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Laik dat, wi wahn di inkorij wan anada. ");
INSERT INTO bzj_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Mi bradaz ahn sistaz, Ah waahn unu noa dat lata taim Ah plan fi kohn si unu, bot aal di taim sohnting kom op fi mek Ah kyaahn kohn. Ah waahn win falowaz fi Krais monks unu da Roam, jos laik how Ah mi du monks dehn peepl weh da noh Joo da di ada plays dehn. ");
INSERT INTO bzj_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ah ga wahn jooti fi tel di Gud Nyooz tu evribadi: dehn wan weh sivilaiz, ahn dehn wan weh noh sivilaiz, dehn wan weh ejukaytid, ahn dehn wan weh noh ejukaytid. ");
INSERT INTO bzj_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Sayka dat, Ah eega fi preech di Gud Nyooz tu unu weh deh da Roam tu. ");
INSERT INTO bzj_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mee noh shaym a di Gud Nyooz ataal, kaa dis Gud Nyooz da Gaad powaful way fi sayv evribadi weh bileev eena Jeezas Krais, fos dehn peepl weh da Joo, ahn den dehn wan weh da noh Joo. Aala dehn wahn sayv if dehn bileev. ");
INSERT INTO bzj_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kaa di Gud Nyooz da fi shoa how Gaad mek evriting rait bitween hihn ahn peepl, if dehn bileev. Gaad mek dehn rait sayka dehn fayt, fahn di fos tu di laas, jos laik weh di Skripcha seh, “Dehn wan weh raichos hafu liv bai fayt.” ");
INSERT INTO bzj_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Gaad di shoa ih raat fahn hevn gens dehn peepl weh ga sin eena dehn haat ahn dehn wan weh du bad ting. Fi dehn wikidnis di haid di chroot bowt Gaad fahn ada peepl. ");
INSERT INTO bzj_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Dehn noa ful wel weh peepl shuda noa bowt Gaad kaa Gaad ihself mek dat playn tu dehn. ");
INSERT INTO bzj_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Fahn di taim wen Gaad mek di werl, peepl mi noa playn-wan dat Gaad ga powa weh laas fareva, ahn dat hihn da di chroo Gaad. Peepl neva laan dehn ting bowt Gaad fahn weh dehn ku si wid dehn aiy, bot dehn ku noa ahn, kaa dehn ku andastan fahn di ting dehn weh Gaad mek. Soh den, nobadi kyaahn seh dat dehn noh noa dat dehn di sin. ");
INSERT INTO bzj_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Dehn noa Gaad, bot dehn noh gi ahn di aana weh hihn fi geh. Ahn dehn noh tank ahn fi weh ih du needa. Insteda dat, dehn noh ga no sens. Dehn schupid main deh eena daaknis. ");
INSERT INTO bzj_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Dehn seh dehn ga sens, bot dehn ton owt fi bee fool. ");
INSERT INTO bzj_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Insteda dehn wership Gaad weh kyaahn ded, dehn di wership aidal weh luk laik peepl, er berd, er animal, er reptail. ");
INSERT INTO bzj_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Dat da wai Gaad lef dehn rait deh fi du weh dehn waahn, soh dehn gaahn hed ahn du aala dehn doti ting weh mi eena dehn haat. Dehn du aal kaina doti ting wid wan anada badi, ting weh shuda mek dehn shaym. ");
INSERT INTO bzj_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Insteda dehn bileev di chroot bowt Gaad, dehn peepl bileev loan lai. Dehn di wership ahn serv di ting dehn weh Gaad mek insteda wership ahn serv di Gaad weh mek aal di ting dehn. Dat da di Gaad weh wi shuda prayz fareva ahn eva. Aymen. ");
INSERT INTO bzj_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Sayka weh peepl du dat, Gaad lef dehn rait deh, ahn mek dehn gaahn hed ahn du aala dehn shaymful ahn eevl ting weh deh eena dehn haat. Di uman dehn stap ga seks eena di nachral way, ahn insted, dehn staat tu ga seks wid wan anada. ");
INSERT INTO bzj_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Sayhn way, di man dehn stap sleep wid uman, ahn dehn gaahn du aala dehn doti ting weh mi eena dehn haat wid ada man, ting weh Gaad neva mek man fi du wid ada man. Dehn doti ting weh dehn du wid ada man shuda mek dehn shaym. Sayka dat, dehn geh di ponishment weh dehn dizerv, eena dehn oan badi. ");
INSERT INTO bzj_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Pahn tap a dat, sayka weh peepl noh waahn put dehn haat pahn di chroot weh dehn noa bowt Gaad, Gaad lef dehn rait deh, soh dat aal weh dehn tink bowt, da fi du dehn ting weh dehn main weh korop tel dehn fi du. ");
INSERT INTO bzj_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Dehn haat ful op wid aal kaina wikidnis. Dehn du aal kaina bad ting tu wan anada. Dehn ga red aiy, ahn dehn jelos wan anada; dehn di kil op wan anada, ahn fait wid wan anada; dehn greedi, ahn dehn tink loan bad ting bowt wan anada; dehn gasip bowt wan anada. ");
INSERT INTO bzj_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Dehn slanda wan anada; dehn hayt Gaad; dehn insolt op wan anada; dehn tink seh dehn beta dan ada peepl, ahn dehn loan boas bowt dehnself; dehn aalwayz di tink bowt moa way fi du bad ting aal di taim; dehn noh pay dehn ma ahn dehn pa no main. ");
INSERT INTO bzj_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Dehn noh ga no sens; dehn noh kip dehn werd. Dehn noh shoa wan anada no mersi, ahn dehn noh kay bowt wan anada ataal. ");
INSERT INTO bzj_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Dehn noa dat Gaad Laa seh dat peepl weh du dehn kaina ting dizerv fi ded. Stilyet, dehn kip aan di du dehn ting, ahn pahn tap a dat, dehn inkorij ada peepl fi du dehn tu. ");
INSERT INTO bzj_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Soh den, unu noh ga no ekskyooz ataal fi di bad ting dehn weh unu du. Ih noh mata hoo yoo, kaa enitaim yu joj ada peepl, bot yu kip aan di du di sayhn bad ting dehn weh dehn di du, yu di joj yuself. ");
INSERT INTO bzj_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Now, wi noa seh dat Gaad rait wen ih joj dehn peepl weh di du dehn bad ting deh. ");
INSERT INTO bzj_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Bot unu weh di joj ada peepl di du di sayhn bad ting dehn weh unu di joj dehn fa. Ahn fi shoar unu wahn kyaahn get weh wid dat. Gaad wahn joj unu tu. ");
INSERT INTO bzj_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Unu tink dat Gaad kainis tu unu noh meen notn? Ih ga payshens wid unu ahn put op wid unu fi wahn lang taim. Unu noa fi shoar dat Gaad du soh moch gud fi unu, kaa ih di chrai fi get unu fi ton fahn unu sin dehn. ");
INSERT INTO bzj_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Bot unu haat haada dahn rak, ahn unu noh waahn ton fahn unu sin dehn. Soh den, unu wahn mek ting wos fi unuself pahn Jojment Day wen Gaad wahn shoa ih raat ahn joj di werl fyaa-wan. ");
INSERT INTO bzj_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Kaa Gaad “wahn gi evribadi weh dehn dizerv fi evriting weh dehn du, weda gud er bad.” ");
INSERT INTO bzj_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Sohn peepl kip aan di du gud ahn dehn di luk tu Gaad fi prayz dehn ahn aana dehn ahn gi dehn laif weh laas fareva; da tu dehn wan deh Gaad wahn gi laif weh wahn neva en. ");
INSERT INTO bzj_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Bot ada peepl jos di liv fi dehnself. Dehn noh waahn obay di chroot; dehn oanli waahn du weh rang, ahn Gaad wahn shoa dehn how ih beks wid dehn fi chroo, ahn ih wahn ponish dehn bad. ");
INSERT INTO bzj_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ih wahn bee reeli bad fi aala dehn peepl weh kip aan di du weh eevl, fi di Jooz dehn fos, ahn den fi dehn peepl weh da noh Joo. Aala dehn wahn sofa bad if dehn kip aan di du eevl. ");
INSERT INTO bzj_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Bot aala dehn peepl weh di du gud, Gaad wahn prayz dehn ahn aana dehn ahn gi dehn pees. Ih wahn du it fi di Jooz dehn fos, ahn den fi dehn wan weh da noh Joo. ");
INSERT INTO bzj_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Yu si, Gaad noh shoa fayvritizm. ");
INSERT INTO bzj_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Aal dehn peepl weh noh ga di Laa weh Gaad gi Moaziz wahn stil geh ponish fi weh dehn du rang. Ahn Gaad wahn ponish di Jooz dehn wen dehn sin tu, kaa dehn ga di Laa weh Gaad gi Moaziz ahn dehn noa weh ih seh. ");
INSERT INTO bzj_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Jos kaa dehn don yehr weh di Laa seh, dat noh mek dehn rait wid Gaad. Dehn wan weh du weh di Laa seh, da dehn stan rait eena Gaad sait. ");
INSERT INTO bzj_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Eevn peepl weh da noh Joo weh noh ga Gaad Laa, ga nof sens fi du weh di Laa seh, kaa eena dehn haat dehn noa rait fahn rang. ");
INSERT INTO bzj_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Di way how dehn liv shoa seh dat Gaad Laa deh eena dehn haat, kaa dehn oan kanshans tel dehn wen dehn di du rait er rang. ");
INSERT INTO bzj_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Soh akaadn tu di Gud Nyooz weh Ah di preech, aal dehn ting ya wahn hapm pahn da Day wen Gaad wahn sen Jeezas Krais fi joj di seekrit ting dehn weh evribadi ga eena dehn haat. ");
INSERT INTO bzj_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Now den, wat bowt unu weh seh, “Ai da wahn Joo?” Unu di chros eena di Laa, ahn unu di boas seh dat unu da peepl weh Gaad don pik. ");
INSERT INTO bzj_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Unu noa weh Gaad waahn unu du, ahn unu noa di gud way, kaa di Laa teech unu weh rait, ahn weh rang. ");
INSERT INTO bzj_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Unu tink seh unu ku leed peepl weh blain, ahn dat unu da lait fi dehn wan weh deh eena daaknis. ");
INSERT INTO bzj_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Unu tink seh unu ku teech peepl weh noh ga no sens, ahn dehn wan weh noh staat tu laan yet, kaa di Laa weh Gaad gi Moaziz mek unu noa aal weh unu wahn hafu noa, ahn aal weh chroo. ");
INSERT INTO bzj_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Soh den, wen unu di teech ada peepl, how kom unu noh teech unuself tu? Unu di tel ada peepl seh, “Unu mosn teef.” Stilyet, unu di teef! ");
INSERT INTO bzj_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Unu di tel ada peepl seh, “Unu noh fi cheet pahn unu waif er unu hozban,” bot stilyet unu du dat. Unu di taak seh unu hayt dehn aidal weh peepl mek fi wership. Stil, unu di teef fahn di plays dehn weh di peepl dehn wership di aidal dehn. ");
INSERT INTO bzj_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Unu di boas seh unu noa di Laa weh Gaad gi Moaziz, ahn stil unu noh du weh di Laa tel unu fi du. Unu noh ga no rispek fi Gaad. ");
INSERT INTO bzj_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Soh den, da jos laik weh rait dong eena di Skripcha seh, “Unu di mek dehn peepl weh da noh Joo insolt Gaad.” ");
INSERT INTO bzj_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","If yu du weh di Laa seh, den di way unu geh serkomsaiz meen sohnting fi chroo. Bot if yu noh du weh di Laa seh, da jos laik yu neva geh serkomsaiz ataal. ");
INSERT INTO bzj_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","If sohnbadi weh neva geh serkomsaiz reeli du weh di Laa seh, Gaad wahn luk pahn dehn jos laik sohnbadi weh don geh serkomsaiz. ");
INSERT INTO bzj_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Soh den, di peepl dehn weh neva geh serkomsaiz ahn stil du weh di Laa seh, da dehn wahn kandem unu. Kaa unu weh don geh serkomsaiz, ahn weh ga di Laa, noh di du weh di Laa seh. Sayhn way, eevn doa unu ga di Laa rait dong, ahn unu serkomsaiz, unu stil noh du weh di Laa seh. ");
INSERT INTO bzj_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Soh da hoo da di chroo chroo Joo? Wahn man da noh wahn chroo chroo Joo jos kaa ih geh serkomsaiz. ");
INSERT INTO bzj_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","No. Di chroo chroo Joo da di wan weh Gaad don put ih maak pan eena ih haat. Da Gaad Spirit du dat, noh Moaziz Laa weh rait dong. Wahn persn laik dat wahn geh prayz fahn Gaad, noh fahn no man. ");
INSERT INTO bzj_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Wel, da weh gud ih du fi bee wahn Joo den? Weh gud ih du fi bee serkomsaiz? ");
INSERT INTO bzj_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ah di tel unu, da wahn gud ting fi bee wahn Joo eena evri way. Fos ting, Gaad mi chros di Jooz dehn wid di veri werdz a Gaad ihself. ");
INSERT INTO bzj_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Da chroo seh dat som a di Jooz dehn noh du weh Gaad waahn dehn du. Dat meen dat Gaad noh wahn kip fi hihn werd? ");
INSERT INTO bzj_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Neva! Gaad wahn kip fi hihn werd dehn eevn if evribadi els di lai. Da jos laik weh di Skripcha seh, “Gaad, evri taim yoo taak, peepl wahn si seh dat yoo rait. Ahn wen yoo joj, yoo wahn win di vikchri.” ");
INSERT INTO bzj_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Bot wat if di eevl weh wee du shoa eevn beta dat Gaad di du rait? Weh wi wahn seh tu dat? Dat meen seh Gaad noh di du di rait ting wen ih ponish wi fi di eevl weh wi du? (Ah di taak ya laik how wahn hyooman been wuda taak.) ");
INSERT INTO bzj_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Neva! Dat da noh soh ataal! If Gaad noh di du di rait ting, dat meen hihn kyaahn joj di peepl dehn a di werl. ");
INSERT INTO bzj_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Bot dis da weh sohn peepl ku aagyu seh: “If di lai weh Ai di tel wahn shoa eevn beta dat Gaad di tel di chroot, ahn dat mek peepl gi hihn moa gloari, how kom ih stil di kandem mee ahn seh dat Ai da sina?” ");
INSERT INTO bzj_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Soh den, peepl ku seh, “Mek wee du eevl soh dat gud ku kom owta di eevl weh wee du.” Da chroo dat sohn peepl don di akyooz mi seh dat dat da weh Ai di preech. Wel, Gaad wahn joj dehn peepl weh di tel lai pahn mi laik dat, ahn hihn wahn gi dehn weh dehn dizerv. ");
INSERT INTO bzj_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Now weh wi ku seh, dat wee weh da Jooz beta eena Gaad sait dan dehn peepl weh da noh Joo? No, wi no beta dan dehn, noh eevn wahn lee bit. Kaa Ah don shoa unu dat sin di rool oava evribadi, oava di Joo dehn ahn oava dehn wan weh da noh Joo. ");
INSERT INTO bzj_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Da jos laik weh rait dong eena di Skripcha, “Nobadi noh rait eena Gaad sait, noh eevn wan persn. ");
INSERT INTO bzj_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nobadi noh andastan. Nobadi noh di luk fi Gaad. ");
INSERT INTO bzj_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Evribadi don ton dehn bak pahn Gaad. Non a dehn noh wot notn. Nobadi noh deh weh di du di rait ting, noh eevn wan.” ");
INSERT INTO bzj_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Dehn werdz da laik dehn bad smel weh di kohn fahn wahn oapm grayv. Aal weh di kom owta dehn mowt da loan lai fi fool op peepl.” “Dehn werdz da laik snayk paizn.” ");
INSERT INTO bzj_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Dehn mowt ful op a loan werdz fi put mowt pahn peepl.” ");
INSERT INTO bzj_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Dehn ron kwik-wan soh dat dehn ku damij peepl ahn kil dehn. ");
INSERT INTO bzj_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Evriway weh dehn goh, dehn kaaz dischrokshan ahn mek peepl sofa. ");
INSERT INTO bzj_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Dehn noh noa notn bowt pees ataal.” ");
INSERT INTO bzj_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Dehn neva did laan fi fyaa Gaad.” ");
INSERT INTO bzj_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Soh den, wi noa dat evriting weh eena di Jooish Laa di taak tu dehn peepl weh sopoas tu liv akaadn tu da Laa deh, soh dat nobadi kyaahn seh dat dehn noh noa weh da di rait ting fi du. Ahn soh aal di peepl dehn eena di hoal werl wahn hafu ansa tu Gaad fi weh dehn du. ");
INSERT INTO bzj_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Soh eevn if wahn persn du weh di Laa seh fi du, dat noh wahn mek dehn rait eena Gaad sait. Insteda dat, di Laa da fi mek peepl kanchos dat dehn sin. ");
INSERT INTO bzj_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Bot now Gaad don shoa wi di way how hihn don mek evriting rait bitween hihn ahn aal di peepl dehn eena di werl. Ahn dat da noh akaadn tu di Laa, eevn doa weh di Laa seh, ahn weh di prafit dehn mi seh di tel wi bowt da way deh. ");
INSERT INTO bzj_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Gaad mek evriting rait bitween ihself ahn peepl if dehn bileev eena Jeezas Krais. Gaad du dat fi aal di peepl dehn weh bileev eena Jeezas, fi di Jooz dehn ahn fi dehn peepl weh da noh Joo, kaa no difrens noh deh bitween dehn. ");
INSERT INTO bzj_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Evribadi don sin, ahn notn noh deh weh gud nof fi dehn du fi meja op tu Gaad gloari. ");
INSERT INTO bzj_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Bot Gaad shoa wi ih grays fi mek evriting rait bitween hihn ahn aal di peepl dehn. Hihn du dis wen Krais Jeezas bai aal di peepl dehn wid ih blod fi mek dehn free fahn sin. ");
INSERT INTO bzj_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Gaad sen Jeezas fi sakrifais ih laif eena fi wee plays, ahn wen Jeezas ded fi fi wee sin, dat da how Gaad fagiv peepl dehn sin wen dehn bileev eena hihn. Eena dis way Gaad shoa dat hihn du weh rait aal di taim. Op til now hihn mi-di put op wid peepl sin. ");
INSERT INTO bzj_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Hihn du dat fi shoa dat hihn raichos ahn dat hihn aalwayz du weh rait. Gaad wahn mek evriting rait bitween hihn ahn aala dehn wan weh bileev dat Jeezas don ded eena fi dehn plays. ");
INSERT INTO bzj_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Soh den, weh wi ku boas bowt? Notn ataal. Wi ku boas kaa wi obay di Laa? No, kaa da Gaad mek wi rait wid ihself chroo fayt. ");
INSERT INTO bzj_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Soh den, wi noa dat evriting rait bitween wee ahn Gaad kaa wee bileev. Da noh kaa wi du weh di Laa tel wi fi du. ");
INSERT INTO bzj_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ahn Gaad noh dehdeh jos fi di Jooish peepl dehn. Ih noh dehdeh fi dehn wan weh da noh Joo tu? Yes, ih dehdeh fi di too a dehn, dehn wan weh da Joo, ahn dehn wan weh da noh Joo. ");
INSERT INTO bzj_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Oanli wan Gaad deh fi di Jooz dehn, ahn fi dehn wan weh da noh Joo. Ahn Gaad wahn mek evriting rait bitween fi hihnself ahn dehn wan weh da Joo ahn weh da noh Joo. ");
INSERT INTO bzj_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Dat meen dat wee di seh di Laa noh meen notn tu wee kaa wi bileev eena Jeezas? No, dat da noh chroo ataal. Wi noh wahn shub di Laa wan said. Insteda dat, wi shoa dat di Laa stil impoatant. ");
INSERT INTO bzj_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Mek wi stodi bowt Aybraham, weh da-mi di wan weh staat fi wee Jooish nayshan. Da weh hihn fain owt bowt how Gaad mek evriting rait? ");
INSERT INTO bzj_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","If Gaad mek evriting rait bitween hihn ahn Aybraham sayka weh Aybraham du, den Aybraham mi wahn ga sohnting fi boas bowt. Bot ih kyaahn boas tu Gaad bowt dat; ");
INSERT INTO bzj_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","kaa memba weh di Skripcha seh? Ih seh, “Aybraham mi chros Gaad, ahn sayka dat, evriting mi mek rait bitween hihn ahn Gaad.” ");
INSERT INTO bzj_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Now den, wen sohnbadi di werk fi moni, dehn geh pay fi di werk weh dehn du. Nobadi noh wahn gi dehn moni rait soh, if dehn noh werk far it. ");
INSERT INTO bzj_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Bot yu kyaahn mek Gaad aksep yu bikaaz a eniting weh yoo du. Yu si, Gaad aksep peepl weh sin kaa dehn ga fayt eena hihn. ");
INSERT INTO bzj_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dat da weh Dayvid meen wen ih rait bowt di persn weh Gaad aksep. Ih seh dat evriting rait bitween Gaad ahn da persn, eevn doa da persn noh du notn fi mek Gaad aksep ahn, bot ih chros eena Gaad. Dayvid seh dat da persn geh blesin. Dayvid mi seh, ");
INSERT INTO bzj_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Di peepl dehn weh Gaad paadn dehn sin, mi bles fi chroo. Gaad fagiv dehn a evriting bad weh dehn du, ahn ih noh memba dehn sin nohmoh. ");
INSERT INTO bzj_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Dehn peepl weh Gaad luk pan ahn seh dat ih noh hoal dehn sin gens dehn, dehn bles fi chroo.” ");
INSERT INTO bzj_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Dis blesin weh Dayvid di taak bowt da oanli fi dehn peepl weh don serkomsaiz, rait? No, sa! Da di saym fi dehn peepl weh noh serkomsaiz. Wi mi-di seh dat Aybraham chros Gaad, ahn sayka dat, evriting mi mek rait bitween hihn ahn Gaad. ");
INSERT INTO bzj_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Da wen dat hapm? Ih hapm bifoa Aybraham geh serkomsaiz, er afta ih geh serkomsaiz? Ih neva hapm afta ih geh serkomsaiz; ih hapm bifoa Aybraham geh serkomsaiz. ");
INSERT INTO bzj_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Afta Gaad don mek evriting rait bitween hihn ahn Aybraham, Gaad koman Aybraham fi geh serkomsaiz. Ahn wen Aybraham geh serkomsaiz, dat da-mi wahn sain fi shoa dat Gaad mi mek evriting rait bitween ihself ahn Aybraham, kaa Aybraham mi chros Gaad wail ih neva serkomsaiz. Soh den, Aybraham da di faada fi aal di peepl dehn weh chros eena Gaad wail dehn neva serkomsaiz, ahn Gaad mek evriting rait bitween dehn ahn ihself. ");
INSERT INTO bzj_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ahn Aybraham da di faada fi aala dehn Jooish peepl dehn tu, weh mi geh serkomsaiz ahn chros Gaad, ahn weh waak eena fayt, jos laik how Aybraham mi chros Gaad ahn waak eena fayt bifoa ih geh serkomsaiz. ");
INSERT INTO bzj_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Aybraham kudn du aal weh di Laa seh ih fi du, soh da neva sayka dat dat Gaad mi pramis hihn ahn ih disendant dehn seh ih mi wahn gi dehn di werl. Gaad mi pramis ahn dat, kaa Aybraham mi ga fayt eena Gaad, ahn dat da-mi weh mek evriting rait bitween Gaad ahn Aybraham. ");
INSERT INTO bzj_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","If dehn ting weh Gaad pramis da jos fi dehn peepl weh du weh di Laa seh, den fayt noh meen notn. Ahn den Gaad pramis noh wahn wot notn tu dehn wan weh chros eena ahn. ");
INSERT INTO bzj_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Wen di Laa deh, Gaad wahn joj peepl kaa dehn brok di Laa. Bot wen no Laa noh deh, peepl wahn kyaahn brok it, soh Gaad noh wahn joj dehn akaadn tu di Laa. ");
INSERT INTO bzj_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Soh den, sayka weh peepl chros eena Gaad, dehn wahn geh weh Gaad pramis. Di ting weh Gaad pramis fi gi tu aala Aybraham disendant dehn, dat free, ahn da pramis da noh jos fi dehn wan weh du weh di Laa seh, bot da fi dehn wan weh chros eena Gaad laik how Aybraham mi chros eena Gaad. Aybraham da aala fi wee pa. ");
INSERT INTO bzj_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Da jos laik weh rait dong eena di Skripcha, “Ah don mek yu bee di faada a wahn lata nayshan.” Eena Gaad sait, Aybraham da fi wee pa, ahn Gaad da di wan weh Aybraham chros. Gaad da di sayhn Gaad weh mek peepl weh don ded kohn bak tu laif agen. Hihn jos seh di werd ahn dehn ting weh neva deh eena di werl, dehn dehdeh. ");
INSERT INTO bzj_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Aybraham mi bileev, ahn luk faawod tu weh Gaad mi pramis. Hihn mi bileev dat weh Gaad mi pramis mi wahn hapm eevn wen notn neva deh fi Aybraham si, ahn sayka dat, ih kohn fi bee di faada a wahn lata nayshan. Da jos laik weh rait dong eena di Skripcha, “Yu wahn ga lata pikni jos laik di staar dehn, ahn yu wahn kyaahn eevn konk dehn.” ");
INSERT INTO bzj_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Aybraham neva dowt dat Gaad mi wahn du weh ih pramis. Aybraham mi bowt wahn honjrid yaaz oal, ahn ih mi noa dat hihn mi tu oal fi ga pikni, ahn hihn mi noa dat ih waif, Sayra, kudn ga pikni needa. ");
INSERT INTO bzj_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Stil, notn neva mek Aybraham dowt dat Gaad mi wahn du weh ih mi pramis fi du. Ih chros Gaad moa ahn moa, ahn ih prayz Gaad fi weh ih mi wahn du. ");
INSERT INTO bzj_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Aybraham mi shoar dat Gaad kuda mi du weh ih pramis fi du. ");
INSERT INTO bzj_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Dat da how kom dehn rait eena di Skripcha seh, “Aybraham mi chros Gaad, ahn sayka dat, evriting mi rait bitween hihn ahn Gaad.” ");
INSERT INTO bzj_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Di werd dehn weh dehn rait seh, “evriting mi rait bitween ihself ahn Gaad,” dehn mi neva rait jos sayka Aybraham. ");
INSERT INTO bzj_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Dehndeh werd deh mi rait fi wee tu. If wee ga fayt eena Gaad, weh mi rayz op Jeezas bak fahn di ded, den evriting wahn rait bitween wee ahn Gaad. ");
INSERT INTO bzj_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Gaad mi giv op Jeezas fi mek ih ded fi fi wee sin, ahn ih mek Jeezas rayz op bak fahn di ded ahn liv agen, soh dat ih ku mek evriting rait bitween wee ahn Gaad. ");
INSERT INTO bzj_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Fi wee Gaad don mek evriting rait bitween hihn ahn wee, kaa wi chros eena weh Jeezas Krais du. Wi ga pees wid Gaad sayka weh fi wee Laad Jeezas Krais du fi wee. ");
INSERT INTO bzj_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Sayka weh wi chros eena weh Jeezas Krais du, wi ku liv anda Gaad grays. Soh wi ful op wid jai, kaa wee noa dat Gaad wahn gi wi fi wee paat eena fi hihn gloari. ");
INSERT INTO bzj_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ahn bisaidz dat, wi di rijais tu, kaa eevn wen wi di sofa, dat wahn help wi fi bayr eniting weh kohn tu wi. ");
INSERT INTO bzj_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Ahn wen wi wilin fi bayr eniting weh kohn, dat wahn mek wi geh schrang eensaid. Ahn sayka weh wi schrang eensaid, dat wahn gi wi hoap fi weh Gaad ga fi wi. ");
INSERT INTO bzj_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ahn sayka weh wi hoap deh eena Gaad, wi noa seh hihn noh wahn let wi dong, kaa Gaad lov wi, ahn ih poar owt dis lov pahn wi wen ih gi wi ih hoali Spirit. ");
INSERT INTO bzj_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Krais ded fi wee da di rait taim wen wi da-mi sina ahn kudn help wiself. ");
INSERT INTO bzj_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Yu haadli fain dat sohnbadi wahn ded fi sohnbadi els, eevn wen da persn du weh rait. Stil, fi sohnbadi weh gud ahn kain, sohnbadi mait ga di korij fi ded fi dehn. ");
INSERT INTO bzj_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Bot Gaad shoa wi humoch hihn lov wee, kaa eevn wail wi da-mi stil wahn sina, Jeezas Krais ded fi wee. ");
INSERT INTO bzj_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Now den, sayka weh Jeezas Krais shed ih blod fi wee, hihn don mek evriting rait bitween wee ahn Gaad. Soh wi eevn moa shoar dat sayka Jeezas Krais, Gaad noh wahn poar owt ih raat pahn wee pahn da Day wen ih wahn joj evribadi. ");
INSERT INTO bzj_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Wee da-mi Gaad enimi, bot hihn don bring wi bak tu ihself ahn mek wi bee fi hihn fren wen ih Son ded fi wi. Now dat wee don kohn bak tu Gaad, wi eevn moa shoar dat Gaad wahn neva ponish wee, kaa Jeezas Krais liv agen. ");
INSERT INTO bzj_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ahn dat da noh aal. Wi di rijais sayka weh fi wee Laad Jeezas Krais du, wen ih bring wee bak tu Gaad. ");
INSERT INTO bzj_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Sin mi fos kom eena di werl wen wan man sin, ahn da man sin bring det; ahn sin spred tu evribadi, ahn aala dehn sin. Sayka dat, evribadi wahn ded. ");
INSERT INTO bzj_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Peepl eena di werl mi-di sin bifoa Gaad gi Moaziz di Laa, bot wen di Laa neva deh, Gaad neva seh dat peepl gilti a dehn sin. ");
INSERT INTO bzj_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Bot fahn di taim wen Adam mi-di liv, til di taim a Moaziz, evribadi mi deh anda di powa a sin. Soh aala dehn mi hafu ded, eevn dehn wan weh neva disobay Gaad koman laik how Adam mi du. Soh eena sohn wayz Adam da-mi laik Krais, weh mi fi kohn layta. ");
INSERT INTO bzj_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Stil, di gif weh Gaad gi, da noh laik di sin weh Adam sin. Da chroo, plenti peepl ded sayka di sin a da wan man Adam. Bot Gaad grays plenti moa powaful dahn Adam sin. Plenti peepl di liv kaa da wan man, Jeezas Krais, mi ga mersi pahn wi, ahn wi noh hafu pay fi dat. Hihn da Gaad free gif. ");
INSERT INTO bzj_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Di gif weh Gaad di gi peepl, difrent fahn weh hapm wen da wan man sin. Wen da wan man sin, Gaad joj ahn, ahn Gaad seh ih mi gilti, ahn ih hafu geh ponish. Bot now wen peepl sin, Gaad noh mek dehn ded fi dehn sin, laik how dehn mi dizerv fi ded. Ih tel dehn seh dat dehn noh gilti, ahn ih mek evriting rait bitween hihn ahn dehn. ");
INSERT INTO bzj_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Da chroo dat fahn da taim deh, sayka weh wan man, Adam, sin, evribadi mi hafu ded. Bot weh di Wan man, Jeezas Krais mi du, mi eevn faar beta. Evribadi weh aksep Gaad rich grays az wahn gif, Gaad wahn mek dehn rait wid hihn, ahn dehn wahn rool now wid hihn laik king. ");
INSERT INTO bzj_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Soh den, Gaad kandem evribadi sayka weh wan man disobay. Sayhn way, Gaad don mek evribadi free ahn gi dehn nyoo laif, sayka di rait ting weh wan man du. ");
INSERT INTO bzj_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ahn wen da wan man disobay, dat mek evribadi bee sina. Sayhn way, sayka di Wan man weh mi du weh Gaad tel ahn fi du, Gaad mek evriting rait bitween hihn ahn lata peepl. ");
INSERT INTO bzj_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Gaad sen di Laa fi mek peepl andastan how sinful dehn sinful. Bot di moa peepl sin, Gaad grays deh moa ahn moa. ");
INSERT INTO bzj_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Gaad di shoa wi grays, soh dat jos laik how sin mi ga di powa fi mek evribadi ded, sayhn way, Gaad grays ga di powa fi mek wi geh laif weh wahn neva en, now dat Gaad don mek evriting rait bitween wee ahn hihn, sayka weh wi Laad Jeezas Krais du. ");
INSERT INTO bzj_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Soh den, weh wi wahn seh? Da chroo, wi noh fi kip aan di sin jos soh dat Gaad ku kip aan di gi wi moa ahn moa grays. ");
INSERT INTO bzj_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","No, wi noh fi goh aan eena wi sinful way nohmoh. Sin noh ga nohmoh powa fi rool oava wee, soh da how wi wahn kip aan di sin? ");
INSERT INTO bzj_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Unu noa seh dat wen dehn baptaiz wi, dat mek wee wan wid Krais Jeezas, ahn wee mi ded sayhn laik how hihn mi ded. ");
INSERT INTO bzj_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Wen dehn baptaiz wi, wee mi ded wid Jeezas Krais ahn dehn beri wi wid hihn, soh dat jos laik how fi wee Faada mi yooz ih grayt powa fi mek Jeezas Krais liv agen, sayhn way, ih yooz ih powa soh dat wee tu ku liv wahn nyoo laif. ");
INSERT INTO bzj_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Wee kohn fi bee wan wid Jeezas Krais wen wi mi ded laik how hihn mi ded. Sayhn way, wee wahn bee wan wid hihn wen Gaad gi wi nyoo laif, jos laik how ih gi Krais nyoo laif wen ih mek ih rayz op bak fahn di ded. ");
INSERT INTO bzj_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Wi noa dat di laif weh wi doz liv ded sayhn taim wen dehn kil Jeezas pahn di kraas, soh dat di powa a sin weh doz rool wi laif ku geh dischrai. Wi noh hafu bee slayv tu sin nohmoh. ");
INSERT INTO bzj_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kaa wen sohnbadi don ded, sin noh ga nohmoh powa oava dehn. ");
INSERT INTO bzj_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","If wee ded wid Krais, den wee bileev dat wi wahn liv wid ahn tu. ");
INSERT INTO bzj_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kaa wi noa dat Gaad don mek Krais rayz op fahn di ded ahn liv agen, soh hihn wahn neva hafu ded agen. Det noh ga nohmoh powa oava hihn. ");
INSERT INTO bzj_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Wen Krais ded, ih brok di powa a sin fareva, ahn now di laif weh ih di liv da fi pleez Gaad. ");
INSERT INTO bzj_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Sayhn way, yu mos luk pahn yuself laik yu don ded wen ih kohn tu sin, ahn alaiv weh Gaad kansaan, kaa yu da wan wid Krais Jeezas. ");
INSERT INTO bzj_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Soh den, yu mosn mek sin rool nohmoh oava yu badi weh wahn ded. Yu noh fi giv een tu notn bad weh yu badi di kaal fa. ");
INSERT INTO bzj_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Yu noh fi yooz no paat a yu badi fi du notn bad. Insteda dat, yu mos gi Gaad yu hoal badi fi mek hihn yooz fi du weh rait, kaa da hihn don gi yu nyoo laif. ");
INSERT INTO bzj_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Sin mos stap rool oava yu laif, kaa yu noh di liv anda di Laa nohmoh; yu di liv anda di gud grays a Gaad. ");
INSERT INTO bzj_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Soh den, weh wi wahn du? Kip aan di sin jos kaa wi di liv anda di grays a Gaad now, ahn kaa wi noh liv anda di Laa nohmoh? Neva! Wi noh fi du dat. ");
INSERT INTO bzj_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Unu noh noa seh dat unu da wahn slayv tu enibadi weh unu obay? Unu ku bee wahn slayv tu sin ahn ded, er yu ku du weh rait ahn pleez Gaad ahn bee wahn slayv tu hihn. ");
INSERT INTO bzj_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Bot unu fi tel Gaad ta