﻿USE sofia;
DROP TABLE IF EXISTS sofia.bzi_vpl;
CREATE TABLE bzi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bzi_vpl WRITE;
INSERT INTO bzi_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","อางเม้ง นี้อือ ย่า พระเยซูคริสต์ ก่าซ้าด อางฮื่อ มาง อางฮู่ อางพี่ อือ อางเม้ง ย่าง เป. พระเยซู ย่า ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บลือ ชี แน ก่าซ้าด ดาวิด ย่า อับราฮัม ก้อง อางเจ้อ ซื้บลือ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","อับราฮัม อางย่า มาง อางเม้ง อิสอัค, อิสอัค อางย่า มาง อางเม้ง ยาโคบ, ยาโคบ อางย่า มาง อางเม้ง ยูดาห์ แน ยาโคบ ก้อง อางย่า ค่าพ่าย่า 11 คู่น จา แล่แง. ชฺ้าง 11 คู่น นี้อือย่า ยูดาห์ ม้องน้าม อือ ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ยูดาห์ ย่า เปเรศ แน เศราห์ เย่ด อางโบ้ง เย. ยาว เย่ด อางบา ม้า ทามาร์ เย. เปเรศ อางย่า มาง อางเม้ง เฮสโรน, เฮสโรน อางย่า มาง อางเม้ง ราม แน. ");
INSERT INTO bzi_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ราม ย่า อัมมีนาดับ อางโบ้ง เย. อัมมีนาดับ ย่า นาโชน อางโบ้ง เย. ยาว นาโชน สัลโมน อางโบ้ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","สัลโมน ย่า โบอาส อางโบ้ง เย. ยาว โบอาส อางบา ม้า ราหับ เย. ยาว โบอาส ย่า โอเบด อางโบ้ง เย. ยาว โอเบด อางบา ม้า รูธ เย. ยาว โอเบด ย่า เจสซี อางโบ้ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ยาว เจสซี ย่า ดาวิด อิสราเอลชฺ้าง อือ ก่าซ้าด มาง อางโบ้ง เย. ยาว ก่าซ้าด ดาวิด ย่า โซโลมอน อางโบ้ง เย. ยาว โซโลมอน อางบา ม้า อุรียาห์ ค่าบา อางอ้าน เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","โซโลมอน ย่า เรโหโบอัม อางโบ้ง เย. เรโหโบอัม ย่า อาบียาห์ อางโบ้ง เย. ยาว อาบียาห์ ย่า อาสา อางโบ้ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","อาสา ย่า เยโฮชาฟัท อางโบ้ง เย. เยโฮชาฟัท ย่า เยโฮรัม อางโบ้ง เย. เยโฮรัม ย่า อุสซียาห์ อางโบ้ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","อุสซียาห์ ย่า โยธาม อางโบ้ง เย. โยธาม ย่า อาหัส อางโบ้ง เย. ยาว อาหัส ย่า เฮเซคียาห์ อางโบ้ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","เฮเซคียาห์ ย่า มนัสเสห์ อางโบ้ง เย. มนัสเสห์ ย่า อาโมน อางโบ้ง เย. อาโมน ย่า โยสิยาห์ อางโบ้ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","โยสิยาห์ ย่า เยโคนิยาห์ อางโบ้ง เย. ยางก้อง ย่าช่างม้องน้าม จา แล่แง. แฮ้ญ่าม เมอ, ยิวชฺ้าง อือนา บาบิโลน อางเมิง โย้เวอ เชลย ชู เพล่อ แอ ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","น่อง โย้เวอ บาบิโลน อางเมิง โย้เวอ เชลย เพล่อ ยาว, เยโคนิยาห์ มือ อางย่า อางเม้ง เชอัลทิเอล แน กงาบู้ ชีเย. ยาว เชอัลทิเอล ย่า เศรุบบาเบล มาง อางโบ้ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","เศรุบบาเบล ย่า อาบียุด อางโบ้ง เย. อาบียุด ย่า เอลียาคิม อางโบ้ง เย. แน เอลียาคิม ย่า อาซอร์ อางโบ้ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","อาซอร์ ย่า ศาโดก อางโบ้ง เย. ศาโดก ย่า อาคิม อางโบ้ง เย. แน อาคิม ย่า เอลีอูด อางโบ้ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","เอลีอูด ย่า เอเลอาซาร์ อางโบ้ง เย. เอเลอาซาร์ ย่า มัทธาน อางโบ้ง เย. แน มัทธาน ย่า ยาโคบ อางโบ้ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ยาโคบ ย่า โยเซฟ อางโบ้ง เย. โยเซฟ ย่า มารีย์ อางบล้อง มาง ย้า. ยาว มารีย์ ย่า พระเยซู พาจาว มาง แช้ยู้ ยาว, ยิวชฺ้าง อือ ก่าซ้าด เพล่อ ปี่ ชี มาง แน ฮ้าว มาง อางบา มาง ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","อับราฮัม จีน เวอ จาย ก่าซ้าด ดาวิด จีน เวอ เคอ นี้ย่า 14 จีน. ยาว ก่าซ้าด ดาวิด จีน เวอ จาย บาบิโลน อางเมิง เวอ เชลย เพล่อ แอ ชี นี้ง มือ 14 จีน. ยาว บาบิโลน อางเมิง เชลย เพล่อ เมอ จาย พระเยซูคริสต์ จีน เวอ เคอ แฮ้ง มือ 14 จีน เย. ");
INSERT INTO bzi_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","พระเยซูคริสต์ มาง เกิ้ด ลือ ชี อางเลิ่ง ย่าง นี้แม้แน เป. มารีย์ พระเยซู อางบา ม้า แฮ้ญ่าม เมอ ยา โยเซฟ คู่นซู่ เย. จ้า เย่ด บ่ากงายู้ กาเมอ ย้า มารีย์ มือ แบ ชี, ยา พาจาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ล่าที่ แฮ้ง ปาปาย อู่ปู่มปู่ม ชี แน. ");
INSERT INTO bzi_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","โยเซฟ, มารีย์ คู่นซู่ ม้า ชฺ้าง อางแม่น เย, แน ยา มารีย์ นา ฮาก ล้าก้า โย้เวอ บ่าฮา ซฺ่าจอ แล่ ปี่ ซี่ เย. แฮ้งย้า กย้าบ แน ชา ว่าง แล่ง. ");
INSERT INTO bzi_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","โยเซฟ แฮ้แม้แน ชา ฮา แงแน ยู่ เย้ง จาเมอ, จี่วีดอางซื้ง มาง เท่วาด่า มาง มือ โยเซฟ แมบืน เวอ มย้าง ลือ ปี่ ยาว จี่ เย นี้แม้แน, “โยเซฟ ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บลือ ชี มาง เวอ, มารีย์ นา ยู้ แฮ้งนา บ่ากงา แค คา, ไม้ ยาง ป่องปอง คล้าว เวอ ย่าแน่ ม้า พาจาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ปาปาย ตอล้า แง. ");
INSERT INTO bzi_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ยาว ยา อางย่า ค่าพ่าย่า กงาบู้ แง. ยาว ย่าแน่ มางนา เยซู แน อางเม้ง เม้ง โว, ยา ยาง ชฺ้าง อือ อางบล่าบ แฮ้ง ชอ อ่อก ปี่ง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","อางเลิ่ง นี้อือ ตอล้า ชี นี้ย่า, จี่วีดอางซื้ง มาง จี่ต่างจี่แต่นฮู มาง จี่ ชี ชี แฮ้งแม้แน ตอล้า ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ค่าบาย่า ค่าพ่าย่า ก้อง บ่ากงายู่ กาซื้ง มางก้อง อางย่า ค่าพ่าย่า ดื้ง ชี, ยาว ชฺ้าง อือ ยางนา อิมมานูเอล แน ฮ้าว คูแง. ‘พาจาว ม้า กงูก้อง ดื้ง แงแน ฮา แง’” แน. ");
INSERT INTO bzi_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","โยเซฟ ดู่งทาน ล้ายาว ยางมือ จี่วีดอางซื้ง เท่วาด่า แฮ้มาง ม่า ชี แม้แน ฮาชี, ยาว น่อง โย้เวอ โยเซฟ มือ มารีย์ นา ค่าบาลา ฮาย ช่าง ชี. ");
INSERT INTO bzi_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","จ้า โยเซฟ มารีย์ อางย่า เกิ้ด เมอ เคอ ย้าเย่ บ่ายู่ช่าง เย. ยาว โยเซฟ มือ ย่าแน่ มางนา “เยซู” แน อางเม้ง เม้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","พระเยซู เบธเลเฮม ค่อง ยูเดีย แควน เวอ เกิ้ด ชี. ยาง เกิ้ด ชี แฮ้ญ่าม เมอ, ก่าซ้าด เฮโรด ยูเดีย แควน แฮ้ง ฮูพลา เย. ยาว จายล้า แล่ยาว, อู่กื่อมอฮู อือ มู่งนื่งอ่อกป่ากย่า ย่อ จายล้า เยรูซาเล็ม อางเมิง เวอ ล้าน คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ยอ นี้แม้แน อางเมิง ชฺ้าง อือนา น้า คูง เย, “อางแบ ล่า ย่าแน่ เกิ้ด ลือ ยิวชฺ้าง อือ ก่าซ้าด เพล่อ ลือ ชี ม้า เกิ้ง โย้เวอ แน? กงูย่า ยาง อู่กื่อ ย่าง มู่ง โย้เวอ มย้าง คูแอ. นี้งย้า ลือ ยางนา บอกไว้ ลือ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ก่าซ้าด เฮโรด แฮ้แม้แน กงากย่า ยาว นาบาตา นืงบาต่องบ่าม่อนบ่าซ่า เย่. ยาว เยรูซาเล็มชฺ้าง คาโคลาโค อือ คาตา เย นืงบาต่องบ่าม่อนบ่าซ่า คู. ");
INSERT INTO bzi_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","แฮ้งย้าเย่ ก่าซ้าด เฮโรด มือ ปุโรหิต ยอคา แน อางลี้บอางล่าว ม่าอู่บฮู คาโคลาโค อือนา ฮ้าว ช้อน ล้า ปี่ โค ยาว นี้แม้แน น้าน ชี, “พาจาว มาง ก่าซ้าด แช้ยู้ เพล่อ ปี่ ชีม้า ล้อเกิ้ง เวอ เกิ้ด แฮ้ง ซูม แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ยาว ยอง พอ คูง เย นี้แม้แน, “เบธเลเฮม ค่อง ยูเดีย แควน เวอ แน, ไม้ พาจาวจี่ต่างจี่แต่นฮู มาง มอ ยาว พระคัมภีร์ เวอ แต้ม ชี ชี นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘เบธเลเฮม ค่องช่าง อือ เวอ, ยูเดีย แควน เวอ ชฺ้าง อือ นองนา บ่าฮูย้า ล่าก้าน. ไม้ นาง ค่อง นู้เวอ ยอคา ปีนแตปีนนา ทื่อม่าง ตอล้า แง. ยา อิสราเอลชฺ้าง อือนา ฮูพลา ลือ แง. ชฺ้าง แกะ อือนา แม่น แน ฮูยพลา ปอ แม้แน.’” ");
INSERT INTO bzi_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","แฮ้งย้าเย่ ก่าซ้าด เฮโรด มางมือ อู่กื่อมอฮู อือนา ค่าว น้า ล้า ชี, อู่กื่อ แฮ้ อาล่อม มย้าง แอ แน. ");
INSERT INTO bzi_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ยาว ก่าซ้าด เฮโรด มือ อู่กื่อมอฮู อือนา เบธเลเฮม ค่อง เวอ ตอย แอ ปี่ชี่ ยาว ม่า เย นี้แม้แน, “ย่าแน่ แฮ้มางนา แม่นแน ซฺ้า ฮู แอ ยาว ยางนา มย้าง ยาว กงานา คาตา แน ม่าย ล้า ล่าว ยาว กงาม มือ ยางนา บอกไว้ แอ แน” แน. ");
INSERT INTO bzi_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ก่าซ้าด เฮโรด มาง ม่า เปิน ยาว, อู่กื่อมอฮู อืมมือ ยอง อู่กื่อ มย้าง ชี มางนา เค่ แอน คูชี. ยาว อู่กื่อ มางมือ ย่าเก มาง จา โย้เวอ ซ่าว ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","อู่กื่อมอฮู อือ อู่กื่อ แฮ้ซื่อ โย้เวอ ซ่าว ชี แน กงามย้าง คูยาว นาบาตา เย่ กย่าง คูแง. ");
INSERT INTO bzi_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","แฮ้งย้าเย่ ยองมือ ยู้ม โย้เวอ เคอ แล ยาว ซฺื่ยกา อ้อง แลน ชี. ยาว ยองมือ ย่าเก แน มารีย์ ย่าเก อางบา มาง เย่ดนา มย้าง แล ชีเย. ยอง มือ ย่าเก มางนา ป่าตูคู บอกไว้ คู ชีเย. ยาว ยอง มือ ค่าม กำยาน แน มดยอบ ย่าง จอก อ่อกล้า ปี่ ยาว ย่าเก มางนา ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ยาว น่อง โย้เวอ พาจาว มาง อู่กื่อมอฮู อือนา แมบืน คล้าว เวอ ม่า ลือ ชี, ก่าซ้าด เฮโรด ก้อง บ่าพ่าว แล แล่ โจ แน. แฮ้งย้าเย่ ยอง มือ แก้บ้า ทื่อปล่าก ป่ากย่า ย่อย ยอง ประเทศ เวอ แอน แล่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","อู่กื่อมอฮู อือ พ่าว แอน แล่ ยาว, จี่วีดอางซื้ง มาง เท่วาด่า มาง มือ โยเซฟ แมบืน เวอ ม่า เย นี้แม้แน, “ทานล้า ปาว ย่าเก นี้มาง แน ยาง อางบา มาง เย่ด นา ประเทศ อียิปต์ เวอ ซฺื่ย ดื้ง แอ ปาโน, กงา ม่าย ล้า แล่ ปี่ เมอ ตื่อเคอ แน, ไม้ อามือ ก่าซ้าด เฮโรด ชฺ้าง นา ม่าย ย่าเก นี้มางนา แซ่ ลือ ปี่ง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ยาว แฮ้คี่ ย้าเย่ โยเซฟ มือ ทานล้า ยาว ย่าเก มางนา แน มารีย์ เย่ดนา ประเทศ อียิปต์ โย้เวอ ซฺื่ยแอ้น ชี. ");
INSERT INTO bzi_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ยองมือ ก่าซ้าด เฮโรด ซฺี้ เมอ เคอ ย้า โย้เวอ ดื้ง ชี. ยาว พาจาวจี่ต่างจี่แต่นฮู มาง มอ ยาว พระคัมภีร์ เวอ แต้ม ปี่ชี่ แม้แนย้า ตอล้า ชี นี้แม้แน, “กงาย่า กงา อางย่า มางนา ประเทศ อียิปต์ โย้ ฮ้าว อ่อกล้า ปี่ แอ่” แน. ");
INSERT INTO bzi_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ก่าซ้าด เฮโรด อู่กื่อมอฮู อือ จ้อบ ชี แน แบ ยาว, ยาง นาบาตา เย นืงบาค่า แง. แฮ้งย้า ยาง ชฺ้าง อือนา ม่า เบธเลเฮม ค่อง แน ค่อง ก่องทาง โย้เวอ ย่าเก ค่าพ่าย่า เกิ้ด เมอ จาย อ่าญู 2 โคบ เวอ เคอ อือนา ม่าย แซ่ ปี่ โค ชี, ไม้ ยางนา อู่กื่อมอฮู อือ อู่กื่อ มย้าง แอ แน ต่องก่า เวอ ม่า ชี แฮ้ย่า 2 ปี เคิน ป้าน่อ. ");
INSERT INTO bzi_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ยาว นี้ย่า พาจาวจี่ต่างจี่แต่นฮู เยเรมีย์ มอ ยาว, พระคัมภีร์ เวอ แต้ม ชี ชี แม้แนย้า ตอนล้า ชี นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“รามาห์ ค่อง โย้เวอ อางเซง ทื่อเซง กงากย่า แอ. อางเซง แฮ้ย่า ชฺ้าง นาบาตา แน นืงบาต่อง ลาบ้าบ อู้ง แม้แน อางเซง นี้ย่า ราเชล อางเซง ย่าง. ยาง อางอ่าน อือ อางเลิ่ง แฮ้ง ปาปาย อู้ง ย่าง, ไม้ ยาง อางอ่าน อือ ซฺี้ ปี่ ป้าน่อ ยาว อ่าซ่าง มาง บ่าปล้อง เย.” ");
INSERT INTO bzi_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ก่าซ้าด เฮโรด ซฺี้ คายาว, จี่วีดอางซื้ง มาง เท่วาด่า มาง มือ โยเซฟ นา ประเทศ อียิปต์ โย้เวอ ยาง แมบืน เวอ ม่า ชี นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ทานล้า ปาว ยาว ย่าเก แน ยาง อางบา มางนา คาตา แน ประเทศ อิสราเอล โย้ ซฺื่ย แอน ปาว, ไม้ ชฺ้าง ย่าเก นี้มางนา ชา แซ่ ซี่ง อือ ซฺี้ โค ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ยาว แฮ้งย้าเย่ โยเซฟ มือ ยู่ทา ล้ายาว ย่าเก มาง แน มารีย์ นา คาตา ประเทศ อิสราเอล โย้เวอ ซฺื่ย แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","จ้า ก่าซ้าด เฮโรด ซฺี้ ยาว อารเคลาอัส ยาง อางย่า มาง ยูเดีย แควน โย้เวอ ก่าซ้าด เพล่อ แต่น ชีแน แบน ยาว โยเซฟ มือ โย้เวอ แล แฮ้งนา แค เย. ยาว จี่วีดอางซื้ง มาง เท่วาด่า มางมือ โยเซฟ นา แมบืน เวอ ม่า ชีเย กาลิลี แควน โย้เวอ แลน โว แน. ");
INSERT INTO bzi_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ยาว ยอง มือ นาซาเร็ธ ค่อง เวอ ดื้ง แล คู ชีเย, ไม้ พาจาวจี่ต่างจี่แต่นฮู อือ พาจาว มาง ชฺ้าง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ มาง อางเลิ่ง แฮ้ง, มอ ยาว พระคัมภีร์ เวอ แต้ม ชี ชีแฮ้ง ม้าม้า แน เพล่อ ปี่ง แนน่อ. พระคัมภีร์ โย้เวอ นี้แม้แน, “ชฺ้าง อือย่า ยางนา นาซาเร็ธ บ่า แน ฮ้าว แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","แฮ้ญ่าม เมอ, ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ฮู มาง ยูเดีย แควน ซ่องก่อง อางเว่อ อือเมอ ม่าอู่บ ป่าวกว่า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ยา นี้แม้แน ป่าว เย, “อางบล่าบ ฮา แฮ้ง ว่าง ยาว นืงบา อางซฺื่อ เพ่น แล่ โว! ไม้ บ่ามล่าง ยาว พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ แง!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ยอห์น อางเลิ่ง นี้ย่า ค้าแต้ เวอ พาจาวจี่ต่างจี่แต่นฮู อิสยาห์ มาง มอ ยาว, พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี เป, “ชฺ้าง แฮ้ม้า ซ่องก่อง อางเว่อ โย้เวอ นี้แม้แน ป่าว แง, ‘จี่วีดอางซื้ง มาง อามือ ชา ลือ แง. ปีนแตปีนนา แน ยาง เคอ ลือ แฮ้นืง นา ล่อ คูโว. ค่องช่าง อือ ก่าซ้าด มาง ชา ล้า เมอ แก้บ้า แต่ง ล่อ แฮ้งแม้แน.’” ");
INSERT INTO bzi_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ยอห์น อางก่าอางตูม ตูม แล่ชี่ แฮ้ย่า อูฐ อางมื่อ แฮ้ง ไจ แต่ง ชีเย. ยาง ไซฮาง อางจ่อ ฮี่ด แล่ชี่ แฮ้ย่า ซ้าดอางคอ เย. ยาง จฺ่าเกิ่ง แฮ้ย่า ญ่ามไป่ แน ปย่าจฺื่อ เย. ");
INSERT INTO bzi_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","แฮ้ญ่าม เมอ, ชฺ้าง อางอีบ่าอ่า เย ยูเดีย แควน กูต่องกูตี่ อือก้อง จายลือ ชี, ตื่น เยรูซาเล็ม อางเมิง แน จอร์แดน ล้างบ้า ก่องทาง อือก้อง จายลือ คูง เย, ยอห์น ม่าอู่บ แฮ้ง น้า ลือ คูง เย. ");
INSERT INTO bzi_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ยอ ยอง อางบล่าบ แฮ้อือ ม่าจ่าแล่ คูแง. แนยาว ยอห์น มือ ยองนา จอร์แดน ล้างบ้า โย้เวอ ล้างตือพิธีบัพติศมา ฮาย ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ฟาริสี มู อือ แน สะดูสี มู อือ อางบย่า เย ยอห์น ก้อง ล้างตือพิธีบัพติศมา ฮา ลือ แล่ชี่. จ้า ยอห์น มือ แฮ้แม้แน มย้าง ยาว นี้แม้แน จี่ ชีเย, “นอ อื้อล้าง อางปีด อือ ช้อด ย้า! นองนา บ้าเจอซ่าง ม่า พาจาว มาง วี่บ่ากไจ ปี่ ล่าง แฮ้ง ฮื่น ปี่ ล่าแง? ");
INSERT INTO bzi_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ฮายฮู ปี่ ล่าวแล นอ อางบล่าบฮา แฮ้ง ว่าง ยาว นืงบา อางซฺื่อ เพ่น แล่ คูชี แน. ");
INSERT INTO bzi_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ค่าตอง แอ่ แน บ่าเย่ง จ่าแล่ คู โจ นอ อับราฮัม อางอ่านอางซฺื้อ, แนยาว วี่บ่ากบ่ากงาไจ แน, กงา ม่าแบ ปี่ ล่าว่า พาจาว ม้า นู้เวอ ลอบาซื่อ นี้อือนา อับราฮัม อางอ่านอางซฺื้อ ฮาย เพล่อ ปี่ เวิม อางกงา ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","พาจาว ม้า ชฺ้าง มู่ย ท้าม แล่ชี่ มาง ช้อดย้า. ยา ซื่งซื่อล่างซื่อ อางจฺื้ง คาโคลาโค อางซื่อ บ่าซื่อ อือนา ชา เตยเลิง แง. แน กอย บี่ท่อ เวอ ปูม แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“กงาย่า ล้าง นี้ง ไจ พิธีบัพติศมา ฮา ปี่ ล่าแง, ไม้ ฮายแบ ปี่ แง นอย่า นืงบา อางซฺื่อ เพ่น คูงญา แน, ยาว ชฺ้าง กงา น่อง เวอ ลือ แฮ้ม้า กงา ล่อบ่าปา ล่าที่ ฮื่อ แง. กงา อางโต นี้ย่า ยางนา แค้บ ล่าตื่อ พื้อ ปี่ เวิม บ่าซูม. ยา นองนา พาจาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แน บี่ท่อ แฮ้ง ไจ พิธีบัพติศมา ฮา ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ยาง ล่าปู่ แฮ้ย่า ปยางวี ท่าม แล่ยาว, กอล่าว ชีแฮ้ง เซฺิ่งซฺ้าง แน ปยาง ยาว กอ อางค่าว แน กอ อางม้า แฮ้ง เปิ่งอ่อก ลางกา ปี่ แง. กอ อางม้า แฮ้ย่า กอโชง เวอ กอ ชี แง, ยาว กอ อางค่าว แฮ้ บี่ท่อบี่ปู่ม ซฺู่นืง บ่าจา โย้เวอ ฮ้าน พี แอ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","แฮ้ญ่ามเมอ, พระเยซู กาลิลี แควน โย้เวอ เจิ่ก ล้า ยาว, จอร์แดน ล้างบ้า โย้เวอ แลน ชี, ไม้ ยอห์น นา ป้า ล้างตือพิธีบัพติศมา ฮา ปี่ แง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ยอห์น มือ บ่าฮา ปี่ ซี่, ยาง จี่ เย นี้แม้แน, “อ่าจาน เวอ, กงา นางนา ล้างตือพิธีบัพติศมา ฮา ปี่ ล่ายาว บ่าซูม, นาง กงานา ฮา ล่าง แฮ้ง ซูม กาน้าอี่” แน. ");
INSERT INTO bzi_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ยาว พระเยซู มือ พอ เย นี้แม้แน, “อามือ ย่า นี้แม้แน ฮา ปาว, ไม้ กงูย่า พาจาว มาง คาม่าย ฮา ปี่ง แม้แน ฮา ปาว” แน. แฮ้งเย่ ยอห์น มือ พระเยซู นา ล้างตือพิธีบัพติศมา ฮา ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","พระเยซู ล้างตือพิธีบัพติศมา ฮา แล่เปิน ยาว ล้าง เวอ อ่อกล้า เมอ, ซฺ้อก ย้า มู่งท่า ย่าง มือ พอง ล้า ชี. ยาว พระเยซู มือ มย้าง ชี พาจาว มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ม้า ฮาย่า อางป่อน แม้แน แต่ง แล่ยาว ยางก้อง ปย้าม แป่ก ลือ ชีแน. ");
INSERT INTO bzi_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ยาว มู่งท่า โย้เวอ อางเซง จายลือ เย นี้แม้แน, “นี้ม้าย่า กงา อางย่า ลาก มาง ย้า. กงาย่า ยางนา นาบาตา ย้า นืงบาจาบ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","พระเยซู ล้างตือพิธีบัพติศมา ฮา แล่เปิน ยาว พาจาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง พระเยซู นา ซ่องก่อง อางเว่อ โย้เวอ ซฺื่ยแอ้น ชีเย. ซาตานแด่ย่ายอคา มางนา นืงบาเจ้อฮู ปี่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","พระเยซู จฺ่าเกิ่งจฺื่ง ล้า 40 นืง 40 คี่ เคิน ยาว, ยาง มือ นาบาตา เย แบ่ซฺู่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","แฮ้งเย่ ซาตานแด่ย่ายอคา มาง มือ พระเยซู นา ลาย นืงบาเจ้อ จี่ช่าง ล้า ชี นี้แม้แน, “จาว่าแน นาง พาจาว อางย่า มาง ม้าม้า แน ยาว ลอบา นี้อือนา ม่า จฺ่าเกิ่ง เพล่อ ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","จ้า พระเยซู มือ พอ เย นี้แม้แน, “พระคัมภีร์ เวอ แต้ม ชี ชี นี้แม้แน, ‘ชฺ้าง จี่วีดม้าม้า จา แล นี้ย่า จฺ่าเกิ่ง จฺ่าต้าง แฮ้ง ปาปาย แอ่ แน บ่าอ่า, จ้า พาจาว มาง จี่ต่าง โค แน จี่อ่อก ลือ ปี่ ชีแฮ้ง คาตา แน จี่วีดไจ โย้เวอ กงาไจ แล แง’” แน. ");
INSERT INTO bzi_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","จายล้า แล่ ยาว, ซาตานแด่ย่ายอคา มาง พระเยซู นา เยรูซาเล็ม อางเมิง อางเซฺิ่งอางซฺ้าง เวอ ซฺื่ยแลน ชีเย. ยาว โบสถ์อางฮื่อ ตู่ตีน อางมอง เวอ ซฺื่ย จูง แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ยาว ยาง มือ พระเยซู นา ตาจ่าง เย นี้แม้แน, “จาว่าแน นาง พาจาว อางย่า มาง ม้าม้า แนยาว อางอ่อก โย้เวอ เปิก ลู่งแอ้น โว, ไม้ พระคัมภีร์ เวอ แต้ม ชี ชี นี้แม้แน, ‘พาจาว ม้า ยาง เท่วาด่า อือนา ม่าย นางนา ฮูพลา ปี่ ล่าแง. ยาว ยาง เท่วาด่า อืม นางนา อาม ชี ล่าง นาง ล่าคื่อ แฮ้งนา ลอบา เวอ บ่าปี่ กงาง แน.’” ");
INSERT INTO bzi_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","จ้า พระเยซู ซาตานแด่ย่ายอคา มางนา นี้แม้แน จี่พอ ชีเย, “พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี, ‘พาจาว ค่าตอง จี่วีดอางซื้ง มางนา นืงบาบ่าเจอ ฮู โจ’” แน. ");
INSERT INTO bzi_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ยาว ทื่อเทอ ม้า ซาตานแด่ย่ายอคา มาง พระเยซู นา ตาแซ้ นาบาตา มอง โย้เวอ ซฺื่ยแลน ชี. ยาว โย้เวอ ชฺ้างอางเมิง เวอ อางเมิง คาโคลาโค อางฮื่อ อางจาอางปาง แฮ้ง ต้าว แน ฮู มย้าง อางกงา. ");
INSERT INTO bzi_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ยาว ยาง มือ พระเยซู นา ตาจ่าแล่ง เย นี้แม้แน, “จาว่าแน นาง กงานา บอกไว้ ล่ายาว กงาย่า นาง กูเจ้อ แน ฮูมย้าง ชี นี้อือ นาง เฮอ เพล่อ ปี่ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ยาว พระเยซู มือ พอ เย นี้แม้แน, “ซาตานแด่ย่ายอคา มาง เวอ, เว่อ แน แอน โว, ไม้ พระคัมภีร์ เวอ แต้ม ชี นี้แม้แน ‘นา จี่วีดอางซื้ง นาง พาจาว มางนา ทื่อม่าง ญา กงาบอกไว้ แง’” แน. ");
INSERT INTO bzi_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ยาว แฮ้งเย่ ยาง มือ พระเยซู นา เจิ่กแอน ชี. แน เท่วาด่า อืม มือ ยางนา ลือ ฮูพลา ลือ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","พระเยซู แบน ชีเย ฮาก ยอห์น นา คอก ชู ล้อง ชี แน ยาง มือ กาลิลี แควน เวอ พ่าว แอน แล ชี. ");
INSERT INTO bzi_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ยาว ยา นาซาเร็ธ ค่อง เวอ พ้าง อ่อกแอ คาเปอรนาอุม อางเมิง โย้เวอ ดื้ง แอ ชี. คาเปอรนาอุม อางเมิง นี้ย่า ลองอองอางฮื่อ กาลิลี ก่องทาง โย้เวอ ดื้ง แง. ลองอองอางฮื่อ กาลิลี นี้ย่า เศบูลุน แควน แน นัฟทาลี แควน กาคย่า โย้เวอ ดื้ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","พาจาวจี่ต่างจี่แต่นฮู อิสยาห์ มอ ชี ชี แม้แน เพล่อ ปี่ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ยิวชฺ้างบ่าอ่า เศบูลุน แควน เวอ ดื้ง อือ, นัฟทาลี แควน เวอ ดื้ง อือ, ลองอองอางฮื่อ กาลิลี ก่องทาง เวอ ดื้ง อือ, จอร์แดน ล้างบ้า มู่งนื่งอ่อกป่ากย่า เวอ ดื้ง อือ.” ");
INSERT INTO bzi_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","“ชฺ้าง อางวื้งอางว้าง เวอ ดื้ง อือ ย้า, จ้า ยองมู นี้ อางแปล้นอางซ้า อางฮื่อ แฮ้ง ชา มย้าง แง.” “แน นองมู ซฺี้ นา แค อือ เวอ, อางแปล้นอางซ้า ย้าง นองก้อง แปล้น ลืน ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","แฮ้งจายล้า ปี่ยาว พระเยซู มือ นี้แม้แน ป่าว ชีเย, “อางบล่าบ ฮา แฮ้ง ว่าง ยาว นืงบา อางซฺื่อ เพ่น แล่ คูโว, ไม้ พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ อางญ่าม ย่าง แท้ ล้าน ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ทื่อนืง จา เย, พระเยซู ลองอองอางฮื่อ กาลิลี แปฟาง โย้เวอ ย่อ จา เมอ, ซีโมน ฮาก เปโตร แน ฮ้าว มาง แน อันดรูว์ เย่ดนา มย้าง ชี. อันดรูว์ ซีโมน อางแพ้ เย. แน เย่ด ล่องแต่ซฺ้าชฺ้าง เย. แน แฮ้ญ่าม เมอ เย่ด ฮอจื้ง จาน จา เย. ");
INSERT INTO bzi_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ยาว พระเยซู มือ เย่ดนา นี้แม้แน จี่ช่าง ชี, “กงาก้อง เค่ ล้าน ปาว, แน กงาย่า ไน้นา ชฺ้าง นา ซฺื่ย กงาก้อง ซฺ้า ล้า ล่าง แฮ้ง ม่าอู่บ แบ ปี่ ล่าว่า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ยาว เย่ด มือ ซฺ้อก ย้า ฮอจื้ง ย่าง วี ยาว พระเยซู ก้อง เค่ แอ้น ชี. ");
INSERT INTO bzi_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ยาว พระเยซู อางอี้ ย่อ แลน แล่ ยาว ม้องน้าม 2 คู่น นา มย้าง แล่ ชีเย. เย่ด อางเม้ง ยากอบ แน ยอห์น แน เย, ยาว เย่ด เศเบดี อางย่าย่าค่า เย. เย่ด อางโบ้ง มางก้อง ล้อง โย้เวอ ฮอจื้ง กู่ จา ชีเย. ยาว พระเยซู มือ เย่ดนา ฮ้าว ล้า ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ซฺ้อก ย้าเย่ ยากอบ แน ยอห์น เย่ด มือ อางโบ้ง มางนา ล้อง โย้เวอ ชี ช่ายาว, พระเยซู ก้อง เค่ แอ้น ชี. ");
INSERT INTO bzi_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","พระเยซู มือ กาลิลี แควน เวอ ต้าว ย้า กว่า ชี, ไม้ ยิวชฺ้าง โบสถ์ คล้าว อือเมอ ม่าอู่บ กว่า เย. ยา อางเลิ่ง อางแม่น พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลืง แฮ้ง ป่าว เย, แน ชฺ้างด้า อือนา พ่าญาด กูเจ้อ อือ ยา ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","แฮ้งย้าเย่ พระเยซู อางเลิ่ง แฮ้ ซีเรีย แควน เวอ ชฺ้าง คาโคลาโค อือ อางแบ กงากา. ชฺ้าง มู อือ พระเยซู ก้อง ลือ ชี, ยองมู ย่าง ชฺ้าง อางด้า พ่าญาด เพล่อ ลาบ้าบ อือ, ชฺ้าง แด่ย่าอ้อง ชี อือ, ชฺ้างมามู อือ แน ชฺ้าง ต่องแก่ อือนา ซฺื่ย ยา ลือ ชี. ยาว พระเยซู มือ ชฺ้างด้า คาโคลาโค อือนา ยา โปยว ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ยาว ชฺ้าง อางอีบ่าอ่า เย พระเยซู นา เค่ คูชี. ทื่อบ่า กาลิลี แควน เวอ จายลือ ทื่อบ่า เดคาโปลิส แควน เวอ จายลือ แง, ทื่อบ่า เยรูซาเล็ม อางเมิง เวอ จายลือ แง, ทื่อบ่า ยูเดีย แควน เวอ จายลือ แง, แน จอร์แดน ล้างบ้า ทื่อปล่าก ป่ากย่า จายล้า คูง เย. ");
INSERT INTO bzi_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ชฺ้าง อางบย่า เค่ ล้าน ชี แน พระเยซู มย้าง ยาว ยาง มือ ตาแซ้ท่า เวอ แลน ยาว ดื้ง ลื่อ ชี่. ยาง ศิษย์ อืม มือ เค่ ซฺ้า แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ยาว พระเยซู มือ ยองนา ต่องก่าต่าง ม่าอู่บ ชีเย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ชฺ้าง พาจาว มางนา กงา ซี้ง แงแน อางแบจ่าแล่ อือ, พาจาว ม้า ยองนา ก่ามป่อน ปี่ ญา, ไม้ ยองมู นี้ย่า พาจาว มาง ชฺ้าง เพล่อ ป้าน่อ. ");
INSERT INTO bzi_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ชฺ้าง นืงบาต่องบ่าม่อนบ่าซ่า อือ, พาจาว ม้า ยองนา ก่ามป่อน ปี่ ญา, ไม้ พาจาว ม้า ยองนา ปล้อง นอ. ");
INSERT INTO bzi_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ชฺ้าง บ่าอ่อนจ่าแล่ อือ, พาจาว ม้า ยองนา ก่ามป่อน ปี่ ญา, ไม้ พาจาว ม้า ยองนา ชฺ้างอางเมิง นี้ง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ชฺ้าง พาจาว มาง ฮา ปี่ ซี้ แม้แน ม้าม้า แน ฮา ซี้ง อือ, พาจาว ม้า ยองนา ก่ามป่อน ปี่ ญา, ไม้ พาจาว ม้า ยองนา ฮาย นืงบาจาบ ปี่ นอ. ");
INSERT INTO bzi_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ชฺ้าง ฮากนา ลากซื่งกง่ากย้า อือ, พาจาว ม้า ยองนา ก่ามป่อน ปี่ ญา, ไม้ พาจาว ม้า ยองนา ลากซื่งกง่ากย้า นอ. ");
INSERT INTO bzi_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ชฺ้าง นืงบา เวอ อางเซฺิ่งอางซฺ้าง อือ, พาจาว ม้า ยองนา ก่ามป่อน ปี่ ญา, ไม้ ยอ พาจาว มางนา กงามย้าง แง. ");
INSERT INTO bzi_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ชฺ้าง ฮากนา แม่นกาปี่ นา อางซอ อือ, พาจาว ม้า ยองนา ก่ามป่อน ปี่ ญา, ไม้ พาจาว ม้า ยองนา อางย่า แน ฮ้าว แง. ");
INSERT INTO bzi_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ชฺ้าง พาจาว มาง ฮา ปี่ ซี่ง แม้แน เค่ฮา ยาว ฮาก เค่คาม โก้นก้าว อือ, พาจาว ม้า ยองนา ก่ามป่อน ปี่ ญา, ไม้ ยองมู นี้ย่า พาจาว มาง ชฺ้าง เพล่อ ป้าน่อ. ");
INSERT INTO bzi_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“นองมู กงาชฺ้าง เพล่อ ชีแฮ้ง ปาปาย ฮาก ฮูย้า เค่คาม, ชฺ้าง บ่าแม่น แน จี่ ล่าเมอ, พาจาว ม้า นองนา ก่ามป่อน ปี่ ล่างญา. ");
INSERT INTO bzi_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ม่อนซ้า กย่าง คูปาว, พาจาว มาง นอง รางวัล ย่าง มู่งท่า โย้เวอ กอ ชี ล่าง ย้า, ไม้ ค้าแต้ โย้เวอ, พาจาว มาง จี่ต่างจี่แต่นฮู อือนา นี้แม้แนย้า ฮาก คาม ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","พระเยซู จี่ แล่ง นี้แม้แน, “นองมู นี้ย่า ชฺ้างอางเมิง นู้เวอ จ่าแม่ แม้แนย้า, จ่าแม่ นี้ย่า ม้างม้าเจ้อ ดอง เมอ มล่าง แน กอชี อางกงา. จ้า จ่าแม่ แฮ้ง บ่ากาน ยาว ปู่ แง, อางมล่าง แน บ่ากอชี กงากา. นี้แม้แนยาว นอย่า อางเลิ่ง อางแม่น ฮาย ฮากนา ปล่อง อางบล่าบ บ่าปี่ ฮา ปี่ โจ. จ่าแม่ นี้ย่า อางอ้าม แฮ้ง โค ยาว ฮา อ้าม แล่ ปี่ บ่ากงา กาน, แม่น แน แล่มจ่าแล่ว นอง อางโต นี้ย่า จ่าแม่ อางอ้าม โค ชี แม้แน เพล่อ ยาว เจิ้นเจ้อ จองไจ บ่าจากาน, วี ยาว ฮากนา น่าง ปี่ แฮ้งญา. ");
INSERT INTO bzi_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“นองมู นี้ย่า ชฺ้างอางเมิง นู้เวอ อางแปล้นอางซ้า อือย้า. แน ตาแซ้ โย้เวอ อางเมิง แต่ง ชี ชี แฮ้ง บ่าโชง ชี กงากา. ");
INSERT INTO bzi_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ทื่อช่างกานญา ต่องซฺื่อลาน นี้ย่า จฺ่อ ยาว อ่าซ่าง มาง นื้งชฺ่าอู่ล่อง บ่าโคบ ชี. จ้า ต่องซฺื่อลาน จ่อตื้งย้า เวอ จฺ่อ ตื้ง แง. ชฺ้าง คาโคลาโค ยู้ม คล้าว โย้เวอ จา อือนา ท่อ แปล้นซ้า ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","นองมือ ทื่อช่างกานญา อางแปล้นอางซ้า แฮ้ง ท่อ อ่อกแอ ปี่ว, ไม้ ชฺ้าง อือนา นอง อางแม่น ฮา ชี แฮ้ง มย้าง ปี่ นอ, แนยาว ยองมือ พาจาว นอง อางโบ้ง มู่งท่า ดื้ง มางนา สรรเสริญ ฮา คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","พระเยซู จี่ แล่ง นี้แม้แน, “กงา ลือ ชี นี้ย่า โมเสส อางลี้บอางล่าว แฮ้ง แน พาจาวจี่ต่างจี่แต่นฮู อือ มอ ยาว, พระคัมภีร์ โย้เวอ แต้ม ชี ชีอือ ก่างพยา ลือ แงแน บ่าเย่ง คูโจ เป, จ้า กงา ลือ ชี นี้ย่า พระคัมภีร์ โย้เวอ แต้ม ชี ชีแฮ้ง ฮาย เปิ้นเซฺิ่ง ลือ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","กงา ม่ายแบ ปี่ ล่าว่า มู่ง แน นื้งชฺ่า นี้ง อางจา แน ยาว, อางลี้บอางล่าว ปาบ โย้เวอ อางไล่ อืมมือ ทื่อโต แนมมือ บ่าโปยว แอ, พระคัมภีร์ โย้เวอ กูเจ้อ แต้ม ชี ชี อือ ม้าม้า แน ตอล้า เมอ เคอ ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ยาว อ่าซ่าง อางลี้บอางล่าว เวอ อางเลิ่ง อางอี เลิ่นเลิ่น แฮ้ง บ่าฮาย เค่, แน ฮากนา ม่าอู่บ บ่าปี่ ฮาย เค่ แง, ชฺ้าง แฮ้ม้า พาจาว มาง อางเมิง โย้เวอ ชฺ้าง ปีนแตปีนนา บ่ากงา เพล่อ. จ้า อ่าซ่าง อางลี้บอางล่าว นา อางน้า แน ฮากนา ม่าอู่บ น้า ปี่ง อือ พาจาว มาง อางเมิง โย้เวอ ชฺ้าง ปีนแตปีนนา กงา เพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ไม้ กงา ม่ายแบ ปี่ ล่าแน, จาว่าแน นอง พาจาว มางนา น้าจ่าง แฮ้ง อางลี้บอางล่าว ม่าอู่บฮู อือ แน ฟาริสี มู อือ, พาจาว มางนา น้าจ่าง แฮ้ง ล่อบ่าปา แน บ่าบย่า ยาว, นอย่า พาจาว มาง อางเมิง โย้เวอ บ่ากงา อ้องแล เป” แน. ");
INSERT INTO bzi_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","พระเยซู จี่ แล่ง นี้แม้แน, “นองมู นี้ย่า โมเสส ค้าแต้ ชฺ้าง อือนา จี่ช่าง แฮ้งนา อางกย่า กางซื้ง ย้า นี้แม้แน, ‘ชฺ้าง นา บ่าแซ่ โจ แน, จ้า อ่าซ่าง ชฺ้าง นา แซ่ แง, พาจาว ม้า ชฺ้าง แฮ้มางนา ต้าดต่อน วี่บ่ากไจ ปี่ แง.’ ");
INSERT INTO bzi_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","จ้า กงา ม่าแบ ปี่ ล่าว่า, อ่าซ่าง ฮากนา นืงบาค่า ยาว ต้าดต่อน แง, พาจาว มาง ชฺ้าง แฮ้มางนา อางซี ต้าดต่อน แง, แน อ่าซ่าง ฮากนา จี่ฮูย้า แง, แฮ้มางนา อางซีต้าดต่อนย่า อางฮื่อ โย้เวอ ต้าดต่อน แง. แน อ่าซ่าง ฮากนา แซ้งว้าน แง แฮ้ม้า ล่าลูกบี่ท่อ เวอ กงากลา แอ แง. ");
INSERT INTO bzi_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","นี้แม้ยาว นอง อางเกิ่งท่านเซฺ่อ อือ โบสถ์อางฮื่อ โย้เวอ ฮ้าน เคอ ล้า เมอ, นาง อ่าซ่าง นา บ่าแม่น ฮากาน ยาว, ยา นางนา นืงบาค่า ล่าง แน เย้ง กงา แล่ยาว, ");
INSERT INTO bzi_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","อางเกิ่งท่านเซฺ่อ แฮ้ง โบยช่ายาว แฮ้มางนา แม่นช่าง แอ โว. ยาว อางเกิ่ง แฮ้ น่องเวอ พ่าว ท่าน ล้า โว. ");
INSERT INTO bzi_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","จาว่าแน นาง อ่าซ่าง นา ซี ช่าง ยาว, นาง ซี ช่าง ชี มาง นางนา อางซี ยู้ ล่ายาว ต้าดต่อนย่า โย้เวอ ชา ซฺื่ยแล ล่าเมอ, อางไว่ แน แม่น แน ม่าอู่บ ลางกา โว, แฮ้แม้ บ่าฮา ยาว นางนา ต้าดต่อนฮู มางก้อง ซฺาแล ปี่ ล่ายาว, ต้าดต่อนฮู มาง นางนา คอก ฮูพลา มางนา ม่าย คอก เวอ ซฺื่ย ล้อง ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","กงา ม่ายแบ ปี่ ล่าแน นา คอก โย้เวอ บ่ากงา อ่อก เป. พลู้ อือ ปี่ โค เมินญา กงาอ่อก แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","พระเยซู จี่ แล่ง นี้แม้แน, “นอย่า อางกย่า กางซื้ง ย้า นี้แม้แน, ‘ฮาก อางบี่อางบล้อง นา จู้ บ่าเพล่อ ช่างโจ’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","จ้า กงา นองนา ม่าแบ ปี่ ล่าว่า ค่าบาย่า นา ฮู ยาว ยู่ ช่าง ซี้เค แน เย้ง ยาว, นอง อางโต นี้ย่า ค่าบาย่า มางนา นืงบา เวอ จู้ เพล่อ ญาเป. ");
INSERT INTO bzi_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","นี้แม้ยาว นอง แมนือ ล่าม่า มาง นองนา อางบล่าบ ฮา ปี่ ล่ายาว โค่ง วี แล่ โว, ไม้ แมนือ ทื่อซื่อ จา นี้ย่า ล่าลูก เวอ กลา ล่อบ่าปา เช แง. ");
INSERT INTO bzi_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","จาว่าแน นอง ล่าปู่ ล่าม่า แฮ้ง นองนา ฮาย อางบล่าบ ฮา ปี่ ล่า ยาว ต่อน วี โว, ไม้ ล่าปู่ ทื่อเบิง จา นี้ย่า ล่าลูก เวอ กลา ล่อบ่าปา เช แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","พระเยซู จี่ แล่ง นี้แม้แน, “นอย่า อางกย่า กางซื้ง ย้า นี้แม้แน, ‘อ่าซ่าง ค่าบา นา ว่าง แง อางพ่า ว่างกาเซฺ่อ แฮ้ง แต้ม ยาว ค่าบา นา ปี่ โว.’ ");
INSERT INTO bzi_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","จ้า กงา ม่าแบ ปี่ ล่าว่า จาว่าแน ค่าบา มาง จู้ จา ยาว, อางบล้อง ม้า ค่าบา มางนา ว่าง แล่ อางกงา. จ้า ค่าบา มาง จู้ บ่าจา แน อางบล้อง มาง ว่าง ยาว, ค่าบา มาง อางบล้อง อางซฺื่อ ยู้ แล่ยาว, ยา ค่าบา มางนา ฮา จู้ จา ปี่ชี่ แน ทื้อ แง. แน ยาง อางบล้อง อางซฺื่อ มาง จู้ แน ทื่อช่างกานญา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","พระเยซู จี่ แล่ง นี้แม้แน, “นองมู นี้ย่า โมเสส ค้าแต้ ชฺ้าง อือนา จี่ช่าง แฮ้งนา อางกย่า กางซื้ง ย้า นี้แม้แน, ‘ก่ามค่าน ฮา ยาว ก่ามค่าน แฮ้ง บ่าซี โจ, ยาว จี่วีดอางซื้ง มางนา ก่ามค่าน ปี่ ชี แฮ้ง ฮา เค่ โว.’ ");
INSERT INTO bzi_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","จ้า กงา ม่า ล่าว่า นอง ก่ามค่าน ฮา เมอ, สาบาน บ่าฮา โจ แน มู่งท่า แฮ้งนา บ่าจี่อ้าง โจ, ไม้ มู่งท่า นี้ย่า พาจาว มาง ต่างอี่ ดื้งย้า ย้าง. ");
INSERT INTO bzi_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ยาว ชฺ้างอางเมิง นี้งนา บ่าจี่อ้าง โจ, ไม้ ชฺ้างอางเมิง นี้ย่า พาจาว มาง ล่าคื่อ น่างย่า ยาง. แน เยรูซาเล็ม อางเมิง แฮ้งนา บ่าอ่าง โจ, ไม้ เยรูซาเล็ม อางเมิง นี้ย่า พาจาว ก่าซ้าด อางฮื่อ มาง อางเมิง ย้าง. ");
INSERT INTO bzi_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","แน ค่าตอง อางตู่ แฮ้ง บ่าจี่อ้าง จาแล่ โจ, ไม้ นอ ต้ามคื้ง แฮ้ง ตื่อเซน แนม บ่าฮา ป่อน บ่าฮา ปล้าง ปี่ ตอ กา. ");
INSERT INTO bzi_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","อางอ้า แน ยาว อางอ้า แน ม่า โว. บ่าอ่า แน ยาว บ่าอ่า แน ม่า โว. นี้ล่อ แน จี่ เวิม กงา คางญา, บย่า แน จี่ ยาว ซาตานแด่ย่ายอคา มางก้อง จายล้า แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","พระเยซู จี่ แล่ง นี้แม้แน, “นอย่า อางกย่า กางซื้ง ย้า นี้แม้แน, ‘อ่าซ่าง ล้อแม้แน บ่าแม่น ฮา แง แฮ้มางนา แฮ้แม้แน ย้า วี่บ่ากกงาไจ ปี่ แง’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","จ้า กงา ม่า ล่าปานา, ชฺ้าง นองนา อางซี ฮากาน ล่ายาว แฮ้มางนา เจิ้นเจ้อ บ่าฮา โจ. อ่าซ่าง นองนา ป่าปา ล่าม่า โย้เวอ ทาก ล่าแง, ป่าปา ล่าซ่าย แฮ้ง พลาบ ทาก ปี่ โว. ");
INSERT INTO bzi_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","จาว่าแน อ่าซ่าง นอง ค่าลาว แฮ้ง กงาซี้ ยาว, ยาง ค่าลาว ย่าง แน จี่ ยาว, แน นองนา ต้าดต่อนย้า โย้เวอ ซฺื่ยแลน ล่ายาว, นองมือ นอง ค่าลาว อางเง้ แฮ้ง คาตา แน ปี่ โว. ");
INSERT INTO bzi_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","จาว่าแน ตาฮ้าน อือ นองนา ทื่อ กิโลเมตร แน อางเกิ่ง เค้ ป่า แอ ปี่ ล่าแง, 2 กิโลเมตร แน ป่า แอ โว. ");
INSERT INTO bzi_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","อ่าซ่าง นองนา บ้าเจอ ป้า ล่าแง ปี่ โว. แน ชฺ้าง ม้างม้าเจ้อ ป้า ชี่ ล่าง อือนา แมก่า บ่าพลาบ ฮื่น โจ” แน. ");
INSERT INTO bzi_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","พระเยซู จี่ แล่ง นี้แม้แน, “นอย่า อางกย่า กางซื้ง ย้า นี้แม้แน, ‘ยู้มต่องยู้มทาง อือนา ลาก โว, ยาว ชฺ้าง นองนา เม้อ ล่าง อือนา เม้อ โว’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","จ้า กงา นองนา ม่า ล่าว่า นองนา เม้อ ล่าง อือนา ลาก โว, แน ชฺ้าง นองนา เค่คาม ล่าง อือนา อธิษฐาน ฮาย ปี่ โว แน. ");
INSERT INTO bzi_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","จาว่าแน นอง นี้แม้แน ฮา กงากา ยาว, นอย่า พาจาว มู่งท่า เวอ ดื้ง มาง อางย่า กงาเพล่อ แง. ยา ชฺ้าง อางแม่น แน ชฺ้าง บ่าแม่น อือนา ทื่อช่างกานญา มู่งนื่ง ท่อ แปล้น ปี่ แง. แน ชฺ้าง อางกง่าอางเกิง แน ชฺ้าง บ่ากง่าบ่าเกิง อือ นามมือ ทื่อช่างกานญา มู่งฮ่อ แฮ้ง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","จาว่าแน นอง ชฺ้าง นองนา ลาก อือนา แอ่ แน ลาก ยาว, พาจาว ม้า บ้าเจอฮาย นองนา รางวัล ปี่ ล่าแง? ซ้ามบา ชฺ้าง ภาษีกอฮู อืมมือ แฮ้แม้แน ฮา บ่าอ่า ลา? ");
INSERT INTO bzi_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","นอง อางช่าง อือนา แอ่ แน แม่น แน จี่ช่าง นี้ย่า บ้าเจอล้อแม้ แม่น ชี? ซ้ามบา ชฺ้าง พาจาว มางนา บ่าเจ่อ อืมมือ ยอง อางช่าง อือนา แม่น ย้า จี่ช่าง แง. ");
INSERT INTO bzi_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","นี้แม้แนยาว นอง อางโบ้ง มู่งท่า ดื้ง มาง ล้อแม้ แม่น แง, นอง มือ แฮ้แม้แน แม่น ปี่ โว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","พระเยซู จี่ แล่ง นี้แม้แน, “แบ ชี คู โว เป ฮากนา มย้าง ปี่ ซี่ ปาปาย แน อางแม่น บ่าฮา คู โจ. นี้แม้ ฮา นี้ย่า, นอย่า นอง พาจาว มู่งท่า ดื้ง มางก้อง รางวัล บ่ากงาบู้. ");
INSERT INTO bzi_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","นอง ชฺ้าง อางตูกอางพาน อือนา ปล่อง เมอ, ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือ แม้แน บ่าฮา โจ. ยอย่า ยิวชฺ้าง โบสถ์ แน ก้าด โย้เวอ ชฺ้าง ล้า ชี อือนา ฮายฮู ปี่ ยาว, ฮากนา โญกจ่าญ่อจ่า ปี่ง. จ้า พาจาว ม้า ยองนา บ่าโญกบ่าญ่อจ่า. ");
INSERT INTO bzi_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","แฮ้งย้า ชฺ้าง อางตูกอางพาน อือนา ปล่อง เมอ, ปล่อง ชี แน อ่าซ่าง มางนา บ่าแบ ปี่ เวิม อางกงา. ");
INSERT INTO bzi_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","นี้แม้แนยาว นอง ชฺ้าง อางตูกอางพาน นา ปล่อง เมอ, กย้าบ แน ปล่อง โว. ยาว พาจาว นอง อางโบ้ง นอง กย้าบ แน ฮา ชี แฮ้งนา อางมย้าง มาง นองนา โญกจ่าญ่อ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","พระเยซู จี่ แล่ง นี้แม้แน, “นอง อธิษฐาน ฮา เมอ, นอง มือ ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือ แม้แน บ่าฮา โจ. ยอย่า ยิวชฺ้าง โบสถ์ แน ก้าด โย้เวอ ชฺ้าง ล้า ชี อือนา ฮายฮู ปี่ ยาว, ฮากนา โญกจ่าญ่อจ่า ปี่ง. จ้า พาจาว ม้า ยองนา บ่าโญกบ่าญ่อจ่า. ");
INSERT INTO bzi_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","จ้า นอง อธิษฐาน ฮา เมอ, อางฮ้อง คล้าว โย้เวอ อ้องแล ล้องก้อ พี่ ยาว, พาจาว นอง อางโบ้ง นอง บ่าฮู มย้าง กา มางนา อธิษฐาน ฮา โว. ยาว พาจาว นอง กย้าบ แน ฮา แฮ้งนา อางมย้าง มาง นองนา รางวัล ปี่ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“แน นอง อธิษฐาน ฮา เมอ ชฺ้าง พาจาว มางนา บ่าแบ กงา กาง อือ แม้แน จี่ต่าง จองไจ บ่าจา อือ ม้อง แน ต้างต้างจี่ แน บ่าฮา โจ, ไม้ ยอ เย้ง คูง แง ต้างต้างจี่ แน อธิษฐาน ฮา ยาว, พาจาว มาง พอ แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ชฺ้าง แฮ้อือ แม้แน บ่าฮา คูโจ, ไม้ พาจาว กงู อางโบ้ง ม้า นอง บ่าป่า ฮู เมอ ย้า อางแบ นองมู นี้ย่า บ้าเจอ บ่าจา แน. ");
INSERT INTO bzi_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","นองมู นี้ย่า นี้แม้แน อธิษฐาน ฮา คู โว, พาจาวกงูอางโบ้ง มู่งท่า ดื้ง มาง เวอ, ชฺ้าง อือนา นางนา สรรเสริญ ฮายแล ปี่ โว. ");
INSERT INTO bzi_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","กงู นางนา ป้า ชฺ้างอางเมิง นู้เวอ อางไว่ แน ก่าซ้าด เพล่อ ปี่ ล่าแง. มู่งท่า โย้เวอ ล้อแม้ จา แง ชฺ้างอางเมิง นู้ เวิม นาง เพล่อ ปี่ ซี่ แม้แน เพล่อ ปี่ โว. ");
INSERT INTO bzi_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","มี้นืง กงูมู นา จฺ่าเกิ่ง จฺ่าเซฺ่อ ก้อ แน ปี่ ล่าปาว. ");
INSERT INTO bzi_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","กงู อางบล่าบ ฮา ชี แฮ้งนา อางซี บ่ายู ล่า โจ. ฮาก กงูนา อางบล่าบ ฮา ล่า เมอ กงู ยองนา อางซี บ่ายู แฮ้งแม้แน. ");
INSERT INTO bzi_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ยาว กงู อางบล่าบ ฮา ซี้ เมอ กงูนา ปล่อง เจิ้นเจ้อ อางซี บ่าปี่ ฮา ล่าโจ, แน กงูมู นา ซาตานแด่ย่ายอคา มางก้อง ปล่องปูน ปี่ ล่า โว. ");
INSERT INTO bzi_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“ชฺ้าง นองนา บ่าแม่น ฮา ล่าง อือนา อางซี บ่ายู ยาว, พาจาว นอง อางโบ้ง มู่งท่า ดื้ง มาง นองนา คาตา ย้า อางซี บ่ายู ล่า. ");
INSERT INTO bzi_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","จ้า นอง ฮากนา อางซี แฮ้ง ยู้ ยาว, พาจาว นอง อางโบ้ง มาง นอง อางบล่าบ แฮ้งนา อางซี ยู้ ล่าง ทื่อช่างกานญา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","พระเยซู จี่ แล่ง นี้แม้แน, “นอง จฺ่าเกิ่งจฺื่ง เมอ, ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือ แม้แน แมก่า บ่าม่อนบ่าซ่า แน บ่าจ่างจ่าแล่ โจ. ยอ ฮากนา ฮา ฮู ปี่ แง ยอ จฺ่าเกิ่งจฺื่ง แงแน. ยอย่า ฮากนา โญกจ่าญ่อจ่า ปี่ง. จ้า พาจาว ม้า ยองนา บ่าโญกบ่าญ่อจ่า. ");
INSERT INTO bzi_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","จ้า นอง จฺ่าเกิ่งจฺื่ง เมอ, แมตู่พ่อ แล่ยาว ตู่คยา คยา แล่ โว. ");
INSERT INTO bzi_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","อ่าซ่าง มาง บ่าแบ นอ จฺ่าเกิ่งจฺื่ง ชี แน, จ้า พาจาวกงูอางโบ้ง นอง บ่าฮู มย้าง กามาง ญา นอง กย้าบ แน ฮา ชีอือ มย้าง แง, แน นองนา โญกจ่าญ่อจ่า ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","พระเยซู จี่ แล่ง นี้แม้แน, “อางเกิ่งอางก้อ อางฮู่ อางจา อางบา แน คี้แม้ง จฺ่า อางกงา อือ, แน แล่ค่าว อือ อ้อง ค่าว แล อางกงา อือ, ชฺ้างอางเมิง นู้เวอ บ่ากอ ชี บู้ โจ. ");
INSERT INTO bzi_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","จ้า อางเกิ่งอางก้อ อางฮู่ อางจา คี้แม้ง แน อางบา บ่าจฺ่า กงา กาง อือ, แน แล่ค่าว บ่าอ่อง ค่าว แล กงา กาง อือ, มู่งท่า โย้เวอ กอยช้อน ชี โว. ");
INSERT INTO bzi_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ไม้ นอง อางเกิ่งอางก้อ อางฮู่ อางจา อือ ล้อเกิ้ง จา แง, นอง นืงบา แฮ้ง โย้เวอ ย้า จา แง. ");
INSERT INTO bzi_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","แมนือ นี้ย่า เพ้ก ลื่อยาว นืงบา แม้แนย้า. นี้แม้แนยาว แมนือ นี้ง แปล้นซ้า ยาว นืงบา แฮ้ง คาตา ย้า แปล้นซ้า แง. จาว่าแน นอง แมนือ แฮ้ง แม่น ยาว, นอง นืงบา แฮ้ง คาตา ย้า แม่น แง. ");
INSERT INTO bzi_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","จ้า จาว่าแน นอง แมนือ แฮ้ง บ่าแม่น ยาว, นอง นืงบา นี้ย่า อางวื้งอางว้าง แฮ้ง ปลื้ง ย้า จา แง, แน นอง นืงบา โย้เวอ อางแปล้นอางซ้า อือ อางวื้งอางว้าง เพล่อ ยาว นาบาตา ย้า วื้งว้าง แง. ");
INSERT INTO bzi_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ย่าเจ่น นี้ย่า เจ้านาย 2 คู่น แน ล่ากาน บ่าว่า ปี่ กงากา, ไม้ ย่าเจ่น นี้ม้า เจ้านาย ทื่อม่าง มางนา ลาก ยาว ทื่อม่าง มาง นา เม้อ แง, บ่าอ่าเวิม ยา เจ้านาย ทื่อม่าง มางนา ซอ ยาว ทื่อม่าง มางนา ฮูย้า แง. ยาว นี้งย้า นองมือ พาจาว มางนา แน พลู้ แฮ้งนา ทื่อญ่าม กาแน บ่าลาก กงากา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","พระเยซู จี่ แง นี้แม้แน, “นี้แม้แนยาว กงา นองนา ม่า ล่า ปานา, จี่วีด นี้งนา บ่าพี่บ่าล่อง โจ, บ้าเจอจฺ่าบ้าเจอต้าง วา แน, บ่าอ่ายาว ม้างม้าเจ้อ ก่าแล่ตูมแล่เซฺ่อ อางจา ล่าแน, ไม้ จี่วีด นี้ย่า จฺ่าเกิ่ง ล่อบ่าปา อางฮู่ จา บ่าอ่า ลา? แน อางโต นี้ย่า อางก่าอางตูม ล่อบ่าปา อางฮู่ จา บ่าอ่า ลา? ");
INSERT INTO bzi_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ฮาย่า ปย้าม กว่า อือนา ฮู ปาว ยอย่า เจิ้นเจ้อ บ่าคลา บ่าว่าบ่าบู่ แน กอโชง เวอ อางคลาอางซ้าง บ่ากอ ชี. จ้า พาจาว นอง อางโบ้ง มู่งท่า โย้เวอ จา ม้า ยองนา ฮูพลา ปอ แง. ยาว นองมู นี้ย่า ฮาย่า อือ ล่อบ่าปา อ่าลา อางฮู่ จา แง? ");
INSERT INTO bzi_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","บ้าเจอฮาย พี้ล้อง แง? พี้ล้อง ยาว นาง จี่วีด นี้ ทื่อชั่วโมง แต่ มล่าง แล แล่ง ลา? จ้า บ่าอ่า น้อ. ");
INSERT INTO bzi_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“นี้แม้ยาว บ้าเจอฮาย อางก่าอางตูม อางเลิ่ง อือนา ม่านชู แง. น่าตูง เวอ แวย่า อือนา ฮู คูปาว ยอ ล้อแม้ แต่ล้า ชี. ยองมู นี้ย่า ล่ากาน บ่าว่า แน อางก่าอางตูม บ่าแต่ง ตูม แล่. ");
INSERT INTO bzi_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","กงา ม่ายแบ ปี่ ล่าว่า, ก่าซ้าด โซโลมอน นาบาตา จาปาง มาง อางก่าอางตูม ก่าตูม แล่ง แฮ้, แวย่า นี้อือ อางแว ทื่อแว ล่อ แนม บ่ามาง. ");
INSERT INTO bzi_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","แวย่า นี้อือนา ฮู ปาว! บ่ามล่าง ยาว ยอ แฮ่ว กือ ซฺี้ แง. จ้า แฮ้แม้เวิม พาจาว ม้า แวย่า อือนา แม่นมาง ย้า แต่ง แง, นี้แม้แนยาว พาจาว ม้า นองนา แวย่า นี้อือ ล่อบ่าปา ฮูพลา ล่าง. ท้าว นอ พาจาว มางนา นืงบาบ่าชี คู แน? ");
INSERT INTO bzi_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","นี้แม้แนยาว บ้าเจอ จฺ่าต้าง แล่วา แน บ้าเจอ ก่าตูม แล่วา แน บ่าม่านบ่าชู คู โจ. ");
INSERT INTO bzi_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ชฺ้าง พาจาว มางนา บ่าแบกงา กาง อือ อางเลิ่ง นี้อือ พี้ล้อง คูแง. จ้า พาจาว นอง อางโบ้ง มู่งท่า เวอ ดื้ง ม้า อางแบ ย้า นอ บ้าเจอ อือ กงาไจ แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","นี้แม้แนยาว นองมู นี้ย่า พาจาว นอง ก่าซ้าด เพล่อ ชี มางนา ฮาย นืงบาจาบ ปี่ อางเลิ่ง แฮ้ง เย้ง ซฺ้า ออน ฮา ปาโน, นี้แม้ฮายยาว พาจาว มางมือ กูย่างกูเจ้อ นอง กงาไจ แฮ้ง ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“นี้แม้แนยาว มี้นืง ย่า นี้เซฺ้อ อางเลิ่ง แฮ้งนา บ่าพี่บ่าล่อง โจ, ไม้ นี้เซฺ้อ มือ อางเลิ่ง ม่านชู คาแม้แน ชี อือ อางจา ย้า, ยาว กานืง กา นี้ง มือ อางเลิ่ง อางตูกอางพาน อางบย่า ย้า จา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","พระเยซู จี่ แล่ง นี้แม้แน, “ฮากนา บ่าต่าดบ่าต่อน โจ! ยาว พาจาว มาง นองนา บ่าต่าดบ่าต่อน ล่า. ");
INSERT INTO bzi_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ไม้ นอง ฮากนา ล้อแม้ ต้าดต่อน แง, พาจาว มางมือ นองนา แฮ้แม้ย้า ต้าดต่อน ล่าแง. พาจาว ม้า นอง อางลี้บ ฮากนา ต้าดต่อน ชี่ แฮ้ง นองนา ต้าดต่อน ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","นอย่า บ้าเจอ ฮาก แมนือ คล้าว โย้เวอ แมเจ่ด อือ อางฮู มย้าง กาแน. จ้า บ้าเจอ ค่าตอง แมนือ คล้าว โย้เวอ ตู่มบา แฮ้งนา บ่าฮู มย้าง กาแน? ");
INSERT INTO bzi_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","บ้าเจอ นอ ฮากนา นี้แม้แน อางม่า แน ‘กงา นาง แมนือ เวอ แมเจ่ด แฮ้ง ยู้อ่อก ปี่ ล่าว่า,’ จ้า ม้าม้า ย่าง นาง แมนือ โย้เวอ ตู่มบา ย่าง จา แง. ");
INSERT INTO bzi_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือเวอ, ฮากนา แมนือ เวอ แมเจ่ด ชา ยู้ อ่อก ปี่ เมอ, ค่าตอง แมนือ คล้าว เวอ ตู่มบา แฮ้ง ยู้อ่อก แล่ ปาโน. ");
INSERT INTO bzi_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“คื่อ อือนา พาจาว มาง อางเกิ่งอางก้อ อางเซฺิ่งอางซฺ้าง แฮ้ง บ่าปี่ คูโจ, ไม้ ยา นองนา ปีน แช่ ล่าง. ว่า อือนา ไข่มุก บ่าจาน ปี่ โจ, ไม้ ยา น่าง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","พระเยซู จี่ แล่ง นี้แม้แน, “ป้า ยาว กงา แง, ซฺ้า ยาว มย้าง แง, ล้องก้อ โย้เวอ คอก ยาว, ชฺ้าง อางคล้าว จา มาง ล้องก้อ แฮ้ง พอง ล้า แง. ");
INSERT INTO bzi_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ไม้ ชฺ้าง คาโคลาโค พาจาว มางนา ป้า คูง อือ กงา คูง แง, ชฺ้าง คาโคลาโค พาจาว มางนา ซฺ้า คูง อือ พาจาว มางนา มย้าง คูแง, แน ชฺ้าง คาโคลาโค พาจาว มาง ล้องก้อ แฮ้ง คอก คูง อือ พาจาว มาง ล้องก้อ แฮ้ง พอง แง. ");
INSERT INTO bzi_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“นองมู โย้เวอ อ่าซ่าง จา แง อางย่า อือ ฮ่าง ป้า เมอ ลอบา แฮ้ง กอ ปี่ แงแน? ");
INSERT INTO bzi_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","บ่าอ่า เวิมมือ อางย่า อือ ล่องแต่ ป้า เมอ อื้อล้าง อางปีด อางจา แฮ้ง จฺ่า ปี่ แงแน? ");
INSERT INTO bzi_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ซ้ามบา นอง ชฺ้าง บ่าแม่น อืม มือ ค่าตอง อางย่า อือนา อางเกิ่งอางก้อ อางแม่น ปี่ นา แบ แง, ท้าว พาจาว กงู อางโบ้ง มู่งท่า ดื้ง ม้า แฮ้ล่อบ่าปา แน ชฺ้าง ยางนา ป้า อือนา บ่าปี่ ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","พระเยซู จี่ แล่ง นี้แม้แน, “นอ ฮากนา ล้อแม้ นองนา ฮาย ปี่ ล่า ปี่ ซี่ง แง, นองมือ ฮากนา แฮ้แม้แน ฮาย ปี่ โว! ไม้ โมเสส อางลี้บอางล่าว แน พาจาวจี่ต่างจี่แต่นฮู อือ ม่าอู่บ นี้ย่า นี้แม้แน ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","พระเยซู จี่ แล่ง นี้แม้แน, “แม่น แน แล่ม แล โว! นอง มู่งท่า อางแล ซี้ แนยาว ล้องก้อ อางแท่ง โย้ อ้องแล โว! ไม้ ล้องก้อ อางกลื้อ แน แก้บ้า อางกลื้อ อือ นองนา ซฺื่ย ล่าลูก เวอ กลา แอ ปี่ ล่าแง. ยาว ชฺ้าง อางอีบ่าอ่า ล้องก้อ อางกลื้อ มางก้อง อ้องแล คูแง. ");
INSERT INTO bzi_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","จ้า ล้องก้อ อางแท่ง แน แก้บ้า บ่าแม่น ย่อแอ่ อางย่าก นี้ย่า จี่วีดม้าม้า ป่ากย่า ซฺื่ยแล ล่าแง. ยาว ชฺ้าง อางบย่า แน บ่ากงา ย่อ อ้องแล” แน. ");
INSERT INTO bzi_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","พระเยซู จี่ แล่ง นี้แม้แน, “พาจาวจี่ต่างจี่แต่นฮู ม้าม้า บ่าอ่า อือนา แล่ม แล่ว, ยอง อางโต แฮ้ แกะอางย่า บ่าโซ่กบ่าไล่ อือ แม้แน นองนา ซฺ้า ล่า คูแง. จ้า นืงบา แฮ้ย่า ฮ้อนโจ้ง แม้แน โซ้กไล้ คูแง. ");
INSERT INTO bzi_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ยอง อางเลิ่ง ฮา แฮ้ย่า ฮากนา ฮายแบ ปี่ แง, ยอง อางโต แฮ้ย่า บ้าเจอล้อแม้ ชฺ้าง แน. ยาว อ่าซ่าง มาง จี่กู่ ปาว เวอ อ่างู่น แน ซื่อไค่มี้ล่อก บ่าชู คู. ");
INSERT INTO bzi_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ทื่อช่างกานญา จฺืงจฺื้ง อางแม่น อือ อางซื่อ อางแม่น ซื่อ แง, ยาว จฺืงจฺื้ง บ่าแม่น อือ อางซื่อ บ่าแม่น ซื่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","จฺืงจฺื้ง อางแม่น อือ อางซื่อ บ่าแม่น อือ บ่าซื่อ แน จฺืงจฺื้ง บ่าแม่น อืมมือ อางซื่อ อางแม่น อือ บ่าซื่อ. ");
INSERT INTO bzi_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","จฺืงจฺื้ง คาโคลาโค อางซื่อ อางแม่น บ่าจา อือนา เตอ วี ยาว บี่ท่อ พี แง. ");
INSERT INTO bzi_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","นี้แม้แนยาว พาจาวจี่ต่างจี่แต่นฮู ม้าม้า บ่าอ่า อือนา ฮู นี้ย่า, ยอง อางเลิ่ง ฮา โย้เวอ ฮู กาโน. ");
INSERT INTO bzi_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ชฺ้าง กงานา ‘จี่วีดอางซื้ง’ แน ฮ้าว ล่าง อือ พาจาว มาง อางเมิง โย้เวอ คาโคลาโค แน บ่ากงา อ้องแล เป. จ้า ชฺ้าง พาจาว กงู อางโบ้ง มู่งท่า ดื้ง มาง นืงบาจาบ แม้แน ฮา เค่ อือ อางกงา อ้องแล เป. ");
INSERT INTO bzi_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ต้าดต่อน นืง เคอ เมอ ชฺ้าง อางอีบ่าอ่า เป กงานา นี้แม้แน ม่า ล่าง, ‘จี่วีดอางซื้ง จี่วีดอางซื้ง มาง เวอ กงูมู นี้ย่า พาจาว มาง อางเลิ่ง ป่าว เมอ นาง อางเม้ง แฮ้ง ไจ, แน แด่ย่า ก่า เมอ แน ม้างม้าเจ้อ อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา เมอ นาง อางเม้ง แฮ้ง จี่ เคอ แง’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","จ้า กงา ยองนา ม่า แน นี้แม้แน, ‘กงาย่า นองนา บ่าแบล่ากงา กา, ชฺ้าง อางบล่าบ อือ เวอ เว่อ แน ฮื่น คูโว!’” แน. ");
INSERT INTO bzi_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","พระเยซู จี่ แล่ง นี้แม้แน, “ชฺ้าง กงา ม่าอู่บจี่ต่าง นี้อือ กย่า ยาว ฮายเค่ อือย่า, ชฺ้าง อางแอ้น อือ ยู้ม แต่ง ดื้ง แม้แนย้า. มู่งฮ่อ ลือ ล้างเจอเจ่อ ฮ้างม้าน อางแล่ง ยู้ม โย้เวอ พยาง เวิม, ยู้ม แฮ้ บ่าก่างบ่าพยา, ไม้ ยู้มยื้ง ย่าง ค่ามตู่ ลอบา เวอ เคอ แน ตู่ แอ ปี่ ชี่ โย้เวอ พูม ป้าน่อ. ");
INSERT INTO bzi_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","จ้า ชฺ้าง กงา จี่ต่าง นี้อือ กย่า ยาว บ่าฮายเค่ อือ, ยอ ชฺ้าง อางจ่าง ซ่าย ท่า โย้เวอ ยู้ม ชฺอ ชี ชีอือ แม้แนย้า. ");
INSERT INTO bzi_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","มู่งฮ่อ ลือ ล้างเจอเจ่อ ฮ้างม้าน อางแล่ง ยู้ม โย้เวอ พยาง ยาว. ยู้ม แฮ้ง ก่างพยา เลิง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","พระเยซู จี่ เปิน ยาว ค่องช่าง อืมมือ ยาง ม่าอู่บจี่ต่าง แฮ้งนา นาบาตา นืงบาม่าน คูง เย, ");
INSERT INTO bzi_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ไม้ พระเยซู ม่าอู่บ นี้ย่า อางลี้บอางล่าว ม่าอู่บฮู อือ ม่าอู่บ แฮ้งนา บ่าตู่. จ้า ยา พาจาว มางก้อง ล่าที่ ม้าม้า จายลือ ชี แฮ้ง ไจ ม่าอู่บ แง. ");
INSERT INTO bzi_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","พระเยซู ตาแซ้ เวอ จาย ลู่งลือ เมอ ชฺ้าง อางบย่า เย ยางก้อง เค่ แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ชฺ้าง คี้ตู้ด ทื่อม่าง จา แง. พระเยซู ล้าก้า เวอ ล้า ยาว ป่าตูคู จี่ แง นี้แม้แน, “จี่วีดอางซื้ง เวอ, จาว่าแน นาง กงานา ปล่อง ลา ซี่ แง แนยาว, กงาม มือ อางโปยว ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","แฮ้งย้า พระเยซู มือ ยาง ล่าปู่ ย่าง กลาง แอ ปี่ ยาว ชฺ้าง คี้ตู้ด มางนา ว่า แอ ชี ยาว นี้แม้แน จี่ ชี, “โอ่ย กงา นางนา ปล่อง ล่า ซี่ แง. นาง พ่าญาด นี้ง โปยว โว!” แน. ยาว ยาง คี้ตู้ด ย่าง ซฺ้อก ย้า โปยว ชี. ");
INSERT INTO bzi_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ยาว พระเยซู มือ นี้แม้แน ม่าย ชีเย, “อ่าซ่าง มางนา บ่าอู่บ น้า ปี่ โจ, จ้า ปุโรหิต มางนา ฮู แอ ปี่ โว. แน อางเกิ่งท่านเซฺ่อ แฮ้ง ท่าน โว, โมเสส ชฺ้าง คี้ตู้ด เพล่อ ยาว โปยว ชี อือนา ม่าย ฮา ปี่ชี่ แฮ้งแม้แน, ไม้ ชฺ้าง คาโคลาโค อือนา แบ ปี่ น้อ, นาง พ่าญ่าด นี้ย่า โปยว ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","พระเยซู คาเปอรนาอุม อางเมิง เวอ อ้องแล เมอ, นายร้อย ทื่อม่าง จา เย. ยา ยิวชฺ้างบ่าอ่า. ยา พระเยซู นา ป้า ปล่อง ปี่ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","เจ้านาย เวอ, กงา ย่าเจ่น ม้า กงา ยู้ม โย้เวอ, ยา นาบาตา ต่องแก่ เพล่อ ด้า ลาบ้าบ บ่าทา ล้า กงากา. ");
INSERT INTO bzi_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","แฮ้งเย่ พระเยซู มือ นายร้อย มางนา ม่า ชี, “กงา ยา แอ ล่าว่า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ยาว นายร้อย มางมือ พระเยซู นา ม่า เย นี้แม้แน, “เจ้านาย เวอ, กงา ชฺ้าง บ่าแม่น กงา ยู้ม โย้เวอ บ่าอ่อง แล โจ, นาง นู้เวอ จาย จี่ เวิมมือ กงา ย่าเจ่น อางด้า มาง อางโปยว ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","กงา นี้แม้แน แบ นี้ย่า, กงา เมอ เจ้านาย แน ตาฮ้าน จา แง. กงา ตาฮ้าน มางนา ล้อเกิ้ง ม่า แอ ปี่ เวิม แอ แง. แน ม่าย ล้า ปี่ เวิม ล้า แง. ยาว กงา ย่าเจ่น อือนา นี้ง ว่า แฮ้ง ว่า แน ม่ายฮา ปี่ เวิม ยอ ว่า แง.” ");
INSERT INTO bzi_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","พระเยซู มือ แฮ้แม้แน กงากย่า ยาว ยางมือ นาบาตา เย นืงบาม่าน แง. ยาว ชฺ้าง เค่ ลือ ชี อือนา จี่ช่าง เย นี้แม้แน, “กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า นี้แม้แน, กงาย่า อิสราเอลชฺ้าง อางมู นู้เวอ อ่าซ่าง มางนา ทื่อม่าง แนม นี้แม้แน เจ่อ นา บ่ามย่าง กางซื้ง. ");
INSERT INTO bzi_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","กงา ม่ายแบ ปี่ ล่าว่า มู่งนื่งกลาป่ากย่า แน มู่งนื่งอ่อกป่ากย่า ชฺ้าง อางบย่า จายล้า ดื้งช้อน กาแง. ยอ อับราฮัม อิสอัค แน ยาโคบ ยองก้อง ทื่งกง่า แน มู่งท่า โย้เวอ จฺ่าปอต้างปอ ฮา คูง. ");
INSERT INTO bzi_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","จ้า อิสราเอลชฺ้าง ทื่อบ่า, มู่งท่า เวอ กงาดื้ง แงแน เย้ง อือนา ตี อางวื้งอางว้าง เวอ จาน แอ ปี่ แง. แน ยอ ซ่อเพ่แช่แก่น ย้า บื้งฮ้าว ด้า อู้ง ลาบ้าบ คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ยาว พระเยซู มือ นายร้อย มางนา จี่ช่าง แง นี้แม้แน, “ยู้ม เวอ พ่าว แอน ปาว, ยาว นาง เจ่อ ชี แม้แน ย้า ตอล้า แง” แน. ยาว ยาง ย่าเจ่น มาง พ่าญาด ย่าง ซฺ้อก ย้า โปยว กาชี. ");
INSERT INTO bzi_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","พระเยซู เปโตร ยู้ม เวอ อ้องแล เมอ, เปโตร มาง ย่อบา มาง อางม้างกย้า ยู่ป่าม เวอ ยู่ จา นา มย้าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ยาว พระเยซู มือ ยาง ล่าปู่ เวอ ว่า ยาว อางม้างกย้า ยาง ซฺ้อก ย้า โปยว ชี, ยาว ยาง มือ ทานล้า ยาว พระเยซู นา ฮูพลา เย. ");
INSERT INTO bzi_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","มู่งคี่ล้าก้า มู่งนื่ง ชา กลา เมอ ค่องช่าง อือ ชฺ้าง แด่ย่าอ้อง ชี อือนา อางบย่า เย่ พระเยซู ก้อง ซฺื่ย ซฺ้า ล้า ชี, ยาว พระเยซู มือ แด่ย่า อือนา จี่ต่าง แฮ้ง ไจ ก่าฮื่น ปี่ ชีเย, แน ยาง มือ ชฺ้างอางด้าอางกย้าง อือนา โค ย้า พ่าญาด ยา โปยว ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","นี้เลิ่ง ตอล้า ชี นี้ย่า พาจาวจี่ต่างจี่แต่นฮู อิสยาห์ มาง จี่ ชี ชี แม้แน ตอล้า ปี่ง นี้แม้แน, “ยา กงู อางด้าอางกย้าง อือ ยา โปยว ล่าง, แน ยา กงู พ่าญาด อือ ฮ้าน แอน ชี.” ");
INSERT INTO bzi_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","พระเยซู ชฺ้าง ยางนา แวด จา อือนา มย้าง ยาว, ยางมือ ยาง ศิษย์ อือนา ม่า ลองอองอางฮื่อ ทื่อปล่าก ป่ากย่า คาม แอ ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","อางลี้บอางล่าว ม่าอู่บฮู ทื่อม่าง จา แง. พระเยซู นา ซฺ้า ล้า ยาว ม่า เย, “อ่าจาน เวอ นา เกิ้ง แอ แง กงา คาตา ย้า เค่ แอ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ยาว พระเยซู มือ ยางนา พอ เย นี้แม้แน, “ฮ้อนโจ้ง นี้ย่า ดื้งย้า อางจา, ฮาย่า ปย้าม กว่า อืม มือ อางป่าม ดื้งย้า อางจา, จ้า กงาชฺ้างอางย่า นี้ม้า ยู่ย่า ดื้งย้า บ่าจา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ยาง ศิษย์ ทื่อม่าง จา เย. พระเยซู นา ป้า เย นี้แม้แน, “กงานา อ่าโบ้ง นา พ่าว ซฺ้า แล ปี่ ล่าปาว. ยาว ยาง ซฺี้ เมอ, กงา ยางนา พูม ยาว นางก้อง เค่ แล แน” แน. ");
INSERT INTO bzi_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","แฮ้งเย่ พระเยซู มือ ม่า ชี นี้แม้แน, “ชฺ้างซฺี้ต่องชฺ้างซฺี้ แน พูม ลางกา ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","พระเยซู แน ยาง ศิษย์ อืมมือ ล้องตา แอน คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ยาว ซฺ้อก ย้าเย่ ฮ้างม้าน อางฮื่อ ตอล้า ชี ล้างฮ้าด ย่าง ล้อง เวอ ปลื้ง เย เอิก อ้อง ล้าน ชี. จ้า พระเยซู ยู่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ศิษย์ มู อืม ยางก้อง แท้ แน อ้อง แลน ยาว, ยางนา ฮ้าว ทานล้า ปี่ชี่. ยาว ยางนา นี้แม้แน ฮ้าว ม่า ชีเย, “จี่วีดอางซื้ง เวอ, กงูนา ปล่อง ล่า ปาโน กงู ล้าง ชา นื่อ แซ่ แล่ คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ยาว พระเยซู มือ ยองนา นี้แม้แน อี่ เย, “ชฺ้าง เจ่อ อางอี อือ เวอ, นอ บ้าเจอฮาย แค คูแง?” แน. ยาว ยาง มือ ทานล้า ยาว, ฮ้างม้าน แน ล้างฮ้าด ย่าง ม่าย ว่าง ปี่ชี่ เย. ยาว ล้างม้าน แน ล้างฮ้าด ย่าง มือ กยาบ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ยาว ยองมือ นาบาตา เย นืงบาม่าน คูแง แน จี่กาง เย นี้แม้แน, “ยา อ่าซ่าง ม้าม้า เวอ? ซ้ามบ้า ฮ้างม้าน แน ล้างฮ้าด อืม ยางนา น้าจ่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","พระเยซู ลองอองอางฮื่อ ทื่อปล่าก กาดารา แควน กาคย่า โย้เวอ คาม เคอ แอ เมอ, ชฺ้าง 2 คู่น จา แง, แด่ย่าอ้อง ปี่ชี่. ท้ามชฺ้างซฺี้ชีย้า เวอ อ่อกล้า ยาว ยางก้อง ล้า ชี, เย่ด 2 คู่น นี้ย่า นาบาตา โซ้ก, อ่าซ่าง มาง โย้เวอ บ่าย่อ ไก จอ กา เย. ");
INSERT INTO bzi_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","เย่ด 2 คู่น ย่าง พระเยซู นา มย้าง ยาว จี่ โฮ้กฮ้าว ชี นี้แม้แน, “พาจาว อางย่า เวอ, กงูมู นา บ้าเจอฮาย ตี่นต้อง ล่าแง? นา พาจาว มาง อางญ่าม ซฺ้า ชี ชี ฮู่ นู้เวอ กงูนา ฮาย ลาบ้าบ ปี่ ล่าง ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","โย้เวอ จายแล บ่าเว่อ เย. ว่า อางบย่า เย อางจ้า กลา ไจ่ จา เย. ");
INSERT INTO bzi_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ยาว แด่ย่า แฮ้อือ มือ พระเยซู นา ป้า คูง เย นี้แม้แน, “จาว่าแน กงูนา ก่าอ่อก ปี่ ล่าง แน ยาว, ว่า แฮ้อือ ก้อง อ้อง ปี่ ล่าปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ยาว พระเยซู มือ แด่ย่า แฮ้อือนา นี้แม้แน ม่า ชีเย, “ว่า อือก้อง อ้อง แอ คูโว!” แน. ยาว แด่ย่า แฮ้อืม มือ อ่อก ยาว ว่า อือก้อง อ้อง ชีเย. ยาว ว่า อืมมือ ตาแซ้พยางพยาง เวอ จาย ฮื่น ลู่ง แอ ลองอองอางฮื่อ โย้เวอ กลา แล่ แซ่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ยาว ว่าปอฮู อืม อางเมิง คล้าว เวอ ฮื่น แล ยาว, อางเลิ่ง คาโคลาโค ตอล้า ชีอือ อางเมิง คล้าว โย้เวอ ชฺ้าง อือนา อู่บน้า ปี่ชี่. แน ค่าพ่าย่า แด่ย่าอ้อง ชี มาง เย่ดก้อง อางเลิ่ง ตอล้า ชี ย่าง คาตา อู่บน้า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ยาว ชฺ้าง อางเมิง คล้าว อืมมือ โค ย้า อ่อกลือ พระเยซู นา ซฺ้า ลือ ชี, ยาว ป้า เย ยอง ตี นู้เวอ อ่อกแอ ปาว แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","พระเยซู ยาง อางเมิง เวอ ล้องตา คาม แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ยาว ชฺ้าง ทื่อบ่า อืม ชฺ้าง ต่องแก่ มางนา อ่าเพ่น เวอ ยู่ ปี่ ยาว พระเยซู ก้อง ซฺื่ย ล้า ชีเย. พระเยซู มือ ยอง เจ่อ แฮ้งนา มย้าง ยาว ยางมือ ชฺ้าง ต่องแก่ มางนา จี่ช่าง ชี นี้แม้แน, “อางย่า เวอ, นืงบาจาบื่อ แน จา ปาว, ไม้ กงา นางนา อางซีอางบล่าบ บ่ายู่ ล้าก้าน” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","อางลี้บอางล่าว ม่าอู่บฮู ทื่อบ่า อืมมือ นืงบา เวอ นี้แม้แน เย้ง คูง เย, “ชฺ้าง นี้ม้า พาจาว มางนา จี่ ฮูย้า แง, ไม้ ชฺ้าง อือนา อางซีอางบล่าบ บ่ายู่ นี้ย่า พาจาว มาง ญา ฮา กงา กาแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","จ้า พระเยซู อางแบ เย ยอง นืงบา โย้เวอ บ้าเจอ เย้ง คูแง แน. แฮ้งเย่ ยางมือ จี่ ชี นี้แม้แน, “บ้าเจอ นอย่า นืงบา เวอ บ่าแม่น แน อางเย้ง คู แน? ");
INSERT INTO bzi_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","กงานา ชฺ้าง ต่องแก่ นี้มางนา บ้าเจอล้อแม้ จี่ช่าง ปี่ ล่าง, ‘กงา นางนา อางซีอางบล่าบ บ่ายู่ ล้าก้าน’ แน จี่ ปี่ ล่าง ลา. อ้าว ‘ทานล้า โว ย่อ แลน ปาว’ แน จี่ปี่ ล่าง ลา. บ้าเจอล้อแม้ จี่ แฮ้ง ไง่ แล่แง? ");
INSERT INTO bzi_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","กงา นองมู นา ฮาย มย้าง ปี่ ล่าว่า, กงาชฺ้างอางย่า นี้ม้า ล่าที่ อางจา ชฺ้างอางเมิง นู้เวอ อางซีอางบล่าบ อือ บ่ายู่ เวิม อางกงา.” ยาว พระเยซู มือ ชฺ้าง ต่องแก่ มางนา จี่ช่าง ชี, “ทานล้า ปาว ยาว อ่าเพ่น นี้ง กอ ยาว ยู้ม เวอ พ่าว แลน ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ยาว ชฺ้าง ต่องแก่ แฮ้มาง มือ ทานล้า ยาว ยาง ยู้ม เวอ แลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ค่องช่าง อือ, ล่าที่ พาจาว มาง พระเยซู นา ปี่ พ่าญาด ยา ปี่ชี่ แฮ้ง มย้าง เมอ นืงบาม่าน แค คูง เย. แฮ้งเย่ ยอง มือ ซฺื่ยกา พาจาว มางนา สรรเสริญ ฮา คู ชี. ");
INSERT INTO bzi_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","พระเยซู ม่าอู่บ เปิน ยาว ย่อ พ่าว แอ แล่ เมอ, ภาษี กอย้า โย้เวอ ชฺ้าง ภาษีกอฮู ทื่อม่าง อางเม้ง มัทธิว แน ชี่ มางนา มย้าง ชี. ยาว พระเยซู มือ มัทธิว นา นี้แม้แน จี่ช่าง ชี, “กงาก้อง เค่ ล้าน ยาว กงา ศิษย์ เพล่อ ปาว!” แน. มัทธิว มือ ทานล้า ยาว พระเยซู ก้อง เค่ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","พระเยซู มัทธิว ยู้ม โย้เวอ ฮ่างจฺ่า เมอ, ชฺ้าง ภาษีกอฮู แน ชฺ้างอางบล่าบ อางอีบ่าอ่า ย้าเย่ พระเยซู แน ยาง ศิษย์ อือก้อง ทื่งกง่า แน ฮ่างจฺ่า ดื้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ฟาริสี มู อือ แฮ้แม้แน มย้าง คู ยาว แฮ้งเย่ พระเยซู ศิษย์ อือนา นี้แม้แน น้า คูชี, “บ้าเจอ นอง อ่าจาน ม้า คื่อ แฮ้อือ ก้อง ทื่งกง่า แน ฮ่าง อางจฺ่า ดื้ง แน” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","พระเยซู มือ ยอง จี่ แฮ้ง กงากย่า ยาว ยาง มือ ยองนา นี้แม้แน พอ ชี, “ชฺ้าง บ่าด่าบ่ากย่าง อือย่า มอ นา บ่ากงา ซี้, จ้า ชฺ้าง อางด้าอางกย้าง อือย่า มอ นา กงา ซี้ ยาว พ่าญาด ยา แล่ซี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","นองมู นี้ย่า พระคัมภีร์ นี้ข้อ เล่นฮูแล บ้าเจอ นา ฮา แงแน. พาจาว ม้า นี้แม้แน จี่ แง, ‘กงา ลากซื่งกง่ากย้า แฮ้งนา มย้าง ซี้ แง, อางเกิ่งท่านเซฺ่อ อือนา มย้าง ซี้ แง บ่าอ่า’ แน, ไม้ กงา ชฺ้าง ฮาก นาบทื้อ คูชี อือนา ซฺ้า ลือ แง บ่าอ่า, จ้า ชฺ้าง อางบล่าบ ฮาก บ่านาบบ่าทื่อ อือนา ซฺ้า ลือ แง, ไม้ ยองนา นืงบาเพ่น อางบล่าบ ฮา แฮ้ง ว่าง ปี่ แง แนนอ” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ยาว ยอห์น ล้างตือพิธีบัพติศมา ฮา มาง ศิษย์ มาง พระเยซู นา น้า ล้า ชี นี้แม้แน, “กงูมู แน ฟาริสี มู นี้ย่า อางเลิ้ง กาย้า ฮ่างจฺื่ง อธิษฐาน ฮา แง. จ้า บ้าเจอ นาง ศิษย์ อือ บ่าฮา คู แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","พระเยซู มือ นี้แม้แน พอ ชี, “นอย่า ชฺ้าง ค่าบาล่า ล่ากาน เวอ ล้า คูชี อือนา ฮ่าง จฺ่าเกิ่ง บ่าจฺ่า แน พ่าว แอ แล่ ปี่ง ลา? นอ นี้แม้แน บ่าฮา อ่าลา? เจ้าบ่าว มาง ยองก้อง ทื่งกง่า แน ดื้ง เมอ, ยองมู นี้ย่า ฮ่างบ่าจฺื่ง เป. จ้า เจ้าบ่าว มางนา ซฺื่ยแล แฮ้นืง เคิน ล้า เมอ, ยองมู แฮ้ง เจ้าบ่าว มางก้อง ทื่งกง่า แน บ่ากงา ดื้ง, แน ยองมู แฮ้ง ฮ่างจฺื่ง คูแง. กงา ศิษย์ อืม ทื่อช่างกานญา, กงา จา เมอ ยอ ฮ่าง บ่ากงา จฺื่ง, จ้า กงา แลน เมอ ยอ ฮ่างจฺื่ง อธิษฐาน กงาฮา คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ยาว พระเยซู มือ ยองนา อางเลิ่ง อู่บ เพ้ก น้า ปี่ชี่, ยาง ม่าอู่บ นี้ย่า ม่าอู่บจี่ต่าง อางซฺื่อ แน. ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “อ่าซ่าง มาง พ้า อางซฺื่อ แฮ้ง ค่าลาว อางอ้าน เวอ อางต้อง บ่าต่อ, ไม้ พ้า อางซฺื่อ นี้ย่า อี ลู่ง เมอ, ค่าลาว อางอ้าน แฮ้งนา จาก แช ปี่ง. แน อางอ้าน ล่อบ่าปา ย้า อางฮ้อน กลื้อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ยาว พระเยซู มือ ยองนา อางเลิ่ง ทื่อเลิ่ง อู่บ เพ้ก น้า แล่ ปี่ชี่, ยาง ม่าอู่บจี่ต่าง นี้ย่า อ่างู่น แต่ค่า อางซฺื่อ ซ้าด อางคอ ปาไต่ อางซฺื่อ เวอ กาน ชี อือ แม้แน ย้า. ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “อ่าซ่าง มาง อ่างู่น แต่ค่า อางซฺื่อ แฮ้ง ซ้าด อางคอ ปาไต่ อางอ้าน เวอ บ่าท่อก กาน, ไม้ อ่างู่น แต่ค่า อางซฺื่อ นี้ย่า ซ้าด อางคอ ปาไต่ อางอ้าน แฮ้งนา ฮาย ปล่าก ปี่ง. นี้แม้แนยาว ตื่น อ่างู่น แต่ค่า แน ซ้าด อางคอ ปาไต่ แฮ้ง ก่างพยา แง. ม้าม้า นี้ อ่างู่น แต่ค่า อางซฺื่อ นี้ย่า ซ้าด อางคอ ปาไต่ อางซฺื่อ เวอ กงากาน แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","พระเยซู นี้เลิ่ง จี่ เมอ ยิวชฺ้าง โบสถ์ เวอ ยอคา มาง ยาง ล้าก้า เวอ ล้าย ป่าตูคู จี่ช่าง ชี นี้แม้แน, “กงา อางย่าย่าบี่ มาง อ่าแซง ญา ซฺี้ แง. จ้า อ่าจาน เวอ, ปล่อง ล่าปาว ย่าเก มาง อางโต โย้เวอ นาง ล่าปู่ โบย แอ ยาว. ย่าเก มาง อางแต่ ล้า แล่ ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","แฮ้งย้า พระเยซู มือ ยางก้อง เค่ แลน ชี แน ยาง ศิษย์ อือ คาตา พระเยซู ก้อง เค่ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","แฮ้ญ่าม เมอ, ค่าบาย่า ทื่อม่าง จา เย ซฺี่ ลู่ง บ่าว่าง แน 12 ปี เคิน ชา ลาบ้าบ ล้าย. ยา พระเยซู น่องน่อง เวอ ค่าว เค่ ล้า, ยาว พระเยซู ค่าลาวม่านเงิน เวอ ว่า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ยา นืงบา เวอ เย้ง เย นี้แม้แน, “อ่าจาน มาง ค่าลาว นู้เวอ อางอี้ กงาว่า เวิม กงา อางโปยว ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","พระเยซู ยางนา มย้าง ยาว จี่ เย นี้แม้แน, “อางย่า เวอ, จาบื่อดื้งบื้อ แน จา ปาว. นาง เจ่อ นี้ง นางนา ฮาย โปยว ปี่ ล่าง.” ยาว ยาง ซฺี่ ลู่ง ย่าง ซฺ้อก ย้า โปยว ชี. ");
INSERT INTO bzi_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","พระเยซู ยิวชฺ้าง โบสถ์ โย้เวอ ยอคา มาง ยู้ม เวอ เคิน เมอ, ชฺ้าง ปีปี เคอ อือ แน ชฺ้าง อางบย่า อู้ง จา นา มย้าง ชี. ");
INSERT INTO bzi_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","แฮ้งย้า พระเยซู มือ ยองนา ม่า แง นี้แม้แน, “อางเง้ เวอ อ่อกแอ โค คู ปาโน, ย่าเก นี้ม้า บ่าซฺี่ กาซื้ง ยา ยู่ กาน ชี” แน. ยาว ยองมือ พระเยซู นา อื้อ กาน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ชฺ้าง อือนา ม่า อ่อกแอ ปี่ โค ยาว, ยางมือ ย่าเก มาง อางฮ้องคล้าว เวอ อ้องแล ยาว ย่าเก มาง ล่าปู่ เวอ ชู ยาว ย่าเก มางมือ ทานล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ยาว นี้เลิ่ง มือ นี้เมิง ก้อง ต้าว ย้าเย่ จี่ กาแง. ");
INSERT INTO bzi_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","พระเยซู โย้เวอ จาย อ่อกล้า เมอ, ค่าพ่าย่า แมปอ 2 คู่น ย่อย เค่ ล้าน ชี. ยาว จี่ โฮ้กฮ้าว ชี นี้แม้แน, “ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บล้า ชี มาง เวอ, ไกง้นา ซื่งกง่ากย้า ล่าปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","พระเยซู ยู้ม โย้เวอ อ้องแล เมอ ชฺ้างแมปอ มาง เย่ด มือ อ้อง ซฺ้า แล ชี. ยาว พระเยซู มือ น้า ชี นี้แม้แน, “กงา ไน้นา ฮาย มย้าง ปี่ ล่า อางกงา ไน้ อางเจ่อ ลา?” แน. ชฺ้างแมปอ มางเย่ด พอ ชี “จี่วีดอางซื้ง เวอ, อางเจ่อ ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","แฮ้งเย่ พระเยซู มือ ชฺ้างแมปอ มาง เย่ด แมนือ เวอ ว่า ชี, ยาว จี่ เย นี้แม้แน, “นอง ล้อแม้ เจ่อ แง แฮ้แม้แน เพล่อ ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ยาว เย่ด มือ มย้าง ล้า ชี, ยาว พระเยซู มือ เย่ดนา นี้แม้แน ม่า เย, “นี้เลิ่ง อ่าซ่าง มางนา บ่าม่า แบ ปี่ โจ เป” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","จ้า เย่ด อ่อก ลือ ยาว อางเมิง เวอ ต้าว ย้า นี้เลิ่ง อู่บ กว่า ชี. ");
INSERT INTO bzi_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ค่าพ่าย่า แฮ้เย่ด อ่อกแอ เมอ, ค่องช่าง อืมมือ ชฺ้าง แด่ย่า อ่อง ยาว บ่าจี่ตอ กา มางนา พระเยซู ก้อง ซฺื่ยล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ยาว พระเยซู แด่ย่า มางนา ก่าอ่อก ยาว ค่าพ่าย่า มาง ซฺ้อก ย้า จี่ตอ กา ชีเย. ค่องช่าง อืม นาบาตา เย นืงบาม่าน คูชี. ยาว นี้แม้แน จี่ กาง เย, “ประเทศ อิสราเอล นู้เวอ อางเลิ่ง นี้แม้แน บ่ามย่าง กางซื้ง น่อ!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","จ้า ฟาริสี อือ นี้แม้แน จี่ คูง เย, “เยซู ซาตานแด่ย่ายอคา มางก้อง ล่าที่ กงาบู้ ชี, แฮ้งย้า ยา แด่ย่า ก่าอ่อก กงากา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","พระเยซู ยิวชฺ้าง โบสถ์ กูค่อง กูเมิง โย้เวอ ม่าอู่บ แล ชี. ยา พาจาว มาง ชฺ้างอางเมิง เวอ ก่าซ้าด เพล่อ ลือ แฮ้ง ป่าว เย. แน พ่าญาด กูย่างกูเจ้อ อือ คาตา ยา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","พระเยซู ชฺ้าง อางบย่า นา มย้าง เมอ ซื่งกง่ากย้า เย, ไม้ ยองมู นี้ย่า อางเลิ่ง อางตูกอางพาน จา ยาว ปล่อง ฮู บ่าจา, แกะ ชฺ้าง ปอฮู บ่าจา อือนา อางตู้. ");
INSERT INTO bzi_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ยาว พระเยซู ยองนา ม่า เย นี้แม้แน, “ชฺ้าง อางบย่า ย้า กงานา เจ่อล่าซี่ง แง, จ้า ชฺ้าง อางเลิ่ง อางแม่น ป่าวกว่าฮู นี้ย่า อางบย่า แน บ่าจา. ");
INSERT INTO bzi_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ชฺ้าง นี้อือ ย่า อางคลาอางซ้าง อางซื่อ บย่า แน ซฺื่ยล้า ยาว ชูญ่าม เคอ ชี อือ ช้อด ย้า, จ้า ชฺ้าง ล่ากาน ว่าฮู ชูฮู อือ บ่าบย่า. แฮ้แม้แนยาว พาจาว มางก้อง ชฺ้าง อางเลิ่ง อางแม่น ป่าวกว่าฮู ป้า คูโว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","พระเยซู ยาง ศิษย์เอก 12 คู่น อือนา ฮ้าว ล้า ปี่ ยาว, แด่ย่า ก่า ล่าที่ แน พ่าญาด ยาจ่า อือ ล่าที่ ย่าง โค ย้า ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","นี้อือย่า ยาง ศิษย์เอก 12 คู่น อือ อางเม้ง ย้าง นี้แม้แน. ซีโมน บ่าอ่าเวิมมือ ยาง นา เปโตร แน ฮ้าว แง, อันดรูว์ ยาง อางแพ้ มาง, ยากอบ เศเบดี มาง อางย่า, ยาว ยอห์น ยาง อางแพ้ มาง, ");
INSERT INTO bzi_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ฟีลิป, แน บารโธโลมิว, ยาว โธมัส, แน มัทธิว ชฺ้าง ภาษีกอฮู มาง, ยากอบ อัลเฟอัส อางย่า มาง แน ธัดเดอัส ");
INSERT INTO bzi_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ซีโมน อิสราเอล อางเจ้ออางจาด นา ลาก มาง, แน ยูดาส อิสคาริโอท น่อง เวอ พระเยซู นา บ่าแม่น ฮา มาง. ");
INSERT INTO bzi_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","พระเยซู ศิษย์เอก 12 คู่น นี้อือนา ซฺาแอ ปี่ชี่, ยาว พระเยซู มือ ยองนา ม่า ชี นี้แม้แน, “ยิวชฺ้างบ่าอ่า อือนา บ่าซฺ่า แอ คูโจ. แน สะมาเรียชฺ้าง อือ อางเมิง โย้เวอ บ่าอ่อง แล โจ แน. ");
INSERT INTO bzi_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","จ้า อิสราเอลชฺ้าง พาจาว มาง แกะ โปยว ชี อือนา แอ ซฺ้า แอ โว. ");
INSERT INTO bzi_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","พาจาว มาง ชฺ้างอางเมิง เวอ ก่าซ้าด เพล่อ ลือ ย้าง ชา เคิน ญา แน ป่าว แล โว. ");
INSERT INTO bzi_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ยาว ชฺ้างอางด้าอางกย้าง อือนา ยา โปยว ปี่ โว, ชฺ้างซฺี้ อือนา ฮาย แต่ล้า ปี่ว, ชฺ้าง คี้ตู้ด เพล่อ ชี อือนา ยา โปยว ปี่ว, ยาว แด่ย่า ชฺ้าง อือก้อง อ้อง ชี อือนา ก่าอ่อก โว. นอย่า พลู้ บ่ากงา ไจ แน พาจาว มางก้อง ก่ามป่อน กงา แง. นี้แม้แนยาว ฮากก้อง พลู้ บ่ากงา ป้า ปล่อง ปี่ คา. ");
INSERT INTO bzi_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“นอง แก้บ้า ย่อ แอ คูเมอ ค่าม พลู้ บ่ากงา ฮ้าน แอ คูคา, ");
INSERT INTO bzi_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","แพล่อง, อางก่าอางตูม เพ่น แล่เซฺ่อ แน แค้บ เพ่น แล่เซฺ่อ, บ่าอ่า เวิม มือ ล่าไมต้ามท้อ บ่ากงา ฮ้าน แอ คูคา, ไม้ ชฺ้าง ล่ากานว่าฮู อือนา ฮาก ปล่อง ฮูพลา คูแง, ยอง ล่ากาน ว่า ชี่ แฮ้งนา ซูม แน. ");
INSERT INTO bzi_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“จาว่าแน นอง อางเมิง ล้อเมิง ก้อง แน ค่อง ล้อค่อง ก้อง อ้องแล แง, นองมือ ชฺ้าง นองนา ยาง ยู้ม โย้เวอ ดื้ง ปี่ล่าซี่ง อือนา ซฺ้า ยาว ยองก้อง ดื้ง คูโว, นอง โย้เวอ เจิ่ก แอ เมอ เคอ แน. ");
INSERT INTO bzi_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","นอง ยู้ม ล้อลาง ก้อง อ้องแล แง ยองนา นี้แม้แน ก่ามป่อน ปี่ โว, จาบื่อดื้งบื้อ แน จา แล โว แน. ");
INSERT INTO bzi_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","จาว่าแน ชฺ้าง แฮ้อือ นองนา แม่น แน ฮูพลา ล่ายาว, พาจาว มาง ยองนา ก่ามป่อน ปี่ แง. จ้า ยอง นองนา แม่น แน บ่าฮูบ่าพลา ล่ายาว, พาจาว มาง ยองนา ก่ามป่อน บ่าปี่. ");
INSERT INTO bzi_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ยาว จาว่าแน ยู้ม ล้อยู้ม แน อางเมิง ล้อเมิง, นองนา บ่าลาบบ่าต้อน แน นอง จี่ต่าง แฮ้งนา บ่าน่าจ่า ล่าแง. ซฺ้อก แน แฮ้ยู้ม แน แฮ้เมิง ก้อง เจิ่ก แอน โว. แน นอง ล่าคื่อ เวอ ค้าล้า แฮ้ง โค แน ทาก อ่อก แล่ คูโว. นอง นี้แม้ ฮา ชีนี้ ฮายแบ ปี่ง นอง มือ ยองนา บ่าลาบ แน. ");
INSERT INTO bzi_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","กงา อางเลิ่ง ม้าม้า แฮ้ง ม่า ล่าว่า ค่อง แฮ้ค่อง เวอ ชฺ้าง อือย่า. ต้าดต่อน นืง เคอ เมอ โสโดม อางเมิง, แน โกโมราห์ อางเมิง ชฺ้าง อือ ล่อบ่าปา ย้า วี่บ่ากกงาไจ คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“แม่น แน น้า คูเป. กงา นองนา ซฺาแอ ปี่ ล่าง นี้ย่า แกะ อือนา ฮ้อนโจ้ง อางมู โย้เวอ ซฺาแอ ปี่ง แม้แน ทื่อช่างกานญา. นี้แม้แนยาว นอย่า อื้อล้าง แม้แน วี่ไซป้านญา จา คูโว. จ้า ฮาย่า อางป่อน แม้แน อางเซิ่งอางไซ่ด่อ แน จา คูโว. ");
INSERT INTO bzi_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","แม่น แน อางโต แฮ้ง แล่ม จ่าแล่ คูโว, ชฺ้าง แฮ้อือย่า นองนา ชู ล่ายาว, ยิวชฺ้าง อือ ต้าดต่อนย่า อือเมอ ซฺื่ยแล ล่าแง. แน นองนา โบสถ์ คล้าว อือเมอ ตื่อชืก ล่า คูแง. ");
INSERT INTO bzi_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ฮากย่า นองนา ต้าดต่อนฮู มางก้อง แน ก่าซ้าด อือ ล้าก้า โย้เวอ ซฺื่ยแล ล่า คูแง, ไม้ นอง กงา ศิษย์ เพล่อ ชี แฮ้ง ปาปาย. อางเลิ่ง นี้ง ตอล้า เมอ นองมู นี้งมือ กงา อางเลิ่ง อางแม่น แฮ้ง ก่าซ้าด แน ยิวชฺ้างบ่าอ่า อือนา อู่บน้า ปี่ คู โว. ");
INSERT INTO bzi_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","นองนา ฮาก ต้าดต่อนย่า โย้เวอ ซฺื่ยแล ล่าเมอ, บ้าเจอล้อแม้ แน จี่ วา แน บ่าพี่บ่าล่อง คูโจ, ไม้ อางญ่าม เคิน ยาว พาจาว มาง นองนา ล้อแม้แน จี่ ปี่ ล่าแง แน ม่า ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ม้าม้า นี้ย่า จี่ฮู ม้าย่า นอง อางโต แฮ้ง บ่าอ่า, จ้า พาจาว นอง อางโบ้ง มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง นอง อางโต โย้เวอ ล่ากาน ว่า มาง จี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“กาญ่าม เวอ อางเลิ่ง นี้อือ ตอล้า แง, ม้องน้ามต่องม้องน้าม แน บ่าแม่น ฮา กายาว ฮากนา ม่า แซ่ ปี่ แง. อางโบ้ง อืมมือ อางย่า นา บ่าแม่น ฮาช่าง ยาว ฮากนา ม่า แซ่ ปี่ง แง. อางย่าอางคย้า อืมมือ อางบา อางโบ้ง นา บ่าแม่น ฮาช่าง ยาว ฮากนา ม่า แซ่ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ชฺ้าง คาโคลาโค อือย่า นอง กงานา เจ่อ ล่า ชีแฮ้ง ปาปาย ย้า, ยองนา ฮาย นองนา เม้อ ปี่ ล่าง. จ้า จาว่าแน อางญ่าม แฮ้มาง อางนืงลีน แฮ้นืง เวอ เคอ แน โอ้ด กงากา ยาว, ชฺ้าง แฮ้ม้าย่า กงาปูน แล่แง. ");
INSERT INTO bzi_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","จาว่าแน อางเมิง คล้าว ชฺ้าง อือ นองนา คาม ล่าคู ยาว อางเมิง ทื่อเมิง อือก้อง พ้าง แอน คู โว. กงา นองนา ม่ายแบ ปี่ ล่าว่า, กงาชฺ้างอางย่า มาง เคอ ลือ เมอ, นอ ประเทศ อิสราเอล นู้เวอ กงา อางเลิ่ง แฮ้ง บ่าป่าว กว่า ต้าว กางซื้ง เป. ");
INSERT INTO bzi_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ศิษย์ นี้ย่า คู่ ล่อ แน บ่าฮื่อ, ย่าเจ่น นี้ง ค่าตอง เจ้านาย อือล่อ แน บ่าฮื่อ. ");
INSERT INTO bzi_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ศิษย์ นี้ย่า คู่ แม้แน เพล่อ คู โว, ย่าเจ่น นี้ย่า เจ้านาย แม้แน เพล่อ คูโว. แฮ้แม้แนยาว จาว่าแน ฮาก กงานา แด่ย่ายอคา เบเอลเซบูล แน ฮ้าว ล่ายาว, ฮาก ย่า กงา ศิษย์ อือนา ล้อม้อก แน บ่าแม่น อือ จี่กาน คู แง.” ");
INSERT INTO bzi_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“นี้แม้แนยาว บ่ากงา แค คา, ไม้ ชฺ้าง อือ ค่าวโชง ชี ชี อือย่า กาญ่าม เวอ พาจาว มาง ชฺ้าง คาโคลาโค อือนา ฮาย มย้าง ปี่ง แง, แน อางเลิ่ง ฮากนา บ่าปี่ แบ อือย่า อ่อก ล้า ฮากนา กงาแบ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","กงา นองนา ตี ฮาก บ่าจา โย้เวอ อางเลิ่ง ม่า ล่า ชี อือ, ชฺ้าง คาโคลาโค อือนา ม่า แอ โว. กงา นองนา อางเลิ่ง ค่าว ม่า ล่า ชี อือ อางเซง บื้ง แน ชฺ้าง คาโคลาโค อือนา ม่า แอ คู โว.” ");
INSERT INTO bzi_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“ชฺ้าง นองนา นอง อางโต แฮ้ง แอ่ แน แซ่ ล่า กงากา ยาว, อางค่องอางล้า แฮ้งนา บ่าแซ่ ล่ากงา กาง อือนา บ่าแค คู โจ. จ้า พาจาว นอง อางโต แน อางค่องอางล้า ล่าลูก โย้เวอ ก่างพยา ล่ากงา กาง มางนา แค คูโว. ");
INSERT INTO bzi_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ฮาย่า อางอี 2 โต อางฮู่ ทื่อบาท แน ก่อง ชี อือย่า, พาจาว นอง อางโบ้ง มาง นืงบาบ่าจาบ ยาว ฮาย่า อือย่า ทื่อโต แนม มือ นื้งชฺ่าท่า เวอ บ่ากลา ลือ กงากา. ");
INSERT INTO bzi_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ยาว นอง อางตู่ เวอ ต้ามคื้ง อืมมือ พาจาว ม้าย่า ดาบ ชี โค ญา. ");
INSERT INTO bzi_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","บ่ากงา แค คูคา, ไม้ นอย่า ฮาย่า อางอี อางมู อือ ล่อบ่าปา อางฮู่ จา คูแง.” ");
INSERT INTO bzi_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ไม้ อ่าซ่าง ชฺ้างอางเมิง นู้เวอ ฮาก ล้าก้า โย้เวอ ม่า แง. ยา กงา ชฺ้าง แน, กงาม มู่งท่า เวอ อ่าโบ้ง พาจาว ล้าก้า โย้เวอ ม่า แง, ชฺ้าง แฮ้ม้า กงา ชฺ้าง แน. ");
INSERT INTO bzi_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","จ้า อ่าซ่าง ชฺ้างอางเมิง นู้เวอ ฮาก ล้าก้า เวอ ม่า แง, ยา กงา ชฺ้าง บ่าอ่า แน. กงามมือ มู่งท่า อ่าโบ้ง พาจาว ล้าก้า โย้เวอ ม่า แง, ชฺ้าง แฮ้ม้า กงา ชฺ้าง บ่าอ่า แน.” ");
INSERT INTO bzi_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“กงาย่า ชฺ้างอางเมิง นู้ ลือ ยาว จาบื่อดื้งบื้อ แน ชี่อือ ฮาน ซฺาลือ แง แน บ่าเย่ง คูโจ, จ้า กงา ลือ ชี นี้ย่า ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา ฮาย ซีแล ลางกา ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","ไม้ กงา ลือ ชี นี้ย่า, อางย่าย่าค่า มางนา อางโบ้ง นา ซี กา ปี่ง, อางย่าย่าบี่ มางนา อางบา นา ซี กา ปี่ง, อางยู มางนา ย่อบ่า นา ซี กา ปี่ง ไม้ นองนา บ่าแม่น ฮาช่าง อือย่า ค่าตอง ยู้มชฺ้าง อือย้า. ");
INSERT INTO bzi_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ชฺ้าง ค่าตอง อางบา อางโบ้ง นา กงานา ล่อบ่าปา แน ลาก อืมมือ, กงา ศิษย์ เพล่อ คู ยาว บ่าซูม, แน ชฺ้าง ค่าตอง อางย่าย่าค่า แน อางย่าย่าบี่ อือนา กงานา ล่อบ่าปา แน ลาก อืมมือ, กงา ศิษย์ เพล่อ ยาว บ่าซูม. ");
INSERT INTO bzi_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","อ่าซ่าง ค่าตอง ไม้กางเขน แฮ้ง บ่าป่า ล้า, แน กงา ปาปาย อางตูกอางพาน แฮ้ง บ่าโอ่ด กงากา ยาว, ยา กงา ศิษย์ เพล่อ บ่าซูม. ");
INSERT INTO bzi_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ไม้ ชฺ้าง ค่าตอง จี่วีด แฮ้งนา กงานา ล่อบ่าปา แน ลาก อือ กงาซฺี้ แง. จ้า อ่าซ่าง กงานา เจ่อ ล่า ปาปาย ซฺี้ แง, ชฺ้าง แฮ้ม้า จี่วีดม้าม้า กงา จา แล แง. ");
INSERT INTO bzi_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ชฺ้าง นองนา เจ่อ ล่าง อืมมือ กงานา คาตา ย้า เจ่อ ล่าง. แน ชฺ้าง กงานา เจ่อ ล่า ชี่ อืมมือ กงานา ซฺาลือ ปี่ ล่า ชี่ มางนา คาตา ย้า เจ่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","อ่าซ่าง พาจาวจี่ต่างจี่แต่นฮู อือนา เจ่อ แง, ไม้ ยอง พาจาวจี่ต่างจี่แต่นฮู เพล่อ ชี แฮ้ง ปาปาย แน, ยา พาจาวจี่ต่างจี่แต่นฮู มาง ก่ามป่อน กงาบู้ ชี แม้แนย้า กงาบู้ แง. อ่าซ่าง พาจาว มาง ชฺ้าง อือนา เจ่อ แง, ไม้ ยอง พาจาว มางนา เจ่อ ชี่ แฮ้ง ปาปาย แน, ยา พาจาว มาง ชฺ้าง อือ แม้แนย้า ก่ามป่อน กงาบู้ แง. ");
INSERT INTO bzi_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","อ่าซ่าง ชฺ้าง ปีนแตปีนนา บ่าอ่า อือนา ล้างจือ ทื่อกอก ต้าง ปี่ แง, ไม้ ยอง กงา ชฺ้าง เพล่อ ชี แฮ้ง ปาปาย แน, กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า ชฺ้าง แฮ้ม้าย่า ก่ามป่อน ม้าม้า ย้า กงาบู้ แง.” ");
INSERT INTO bzi_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","พระเยซู มือ ยาง ศิษย์ 12 คู่น อือนา ม่าอู่บ เปิน ยาว, ยาง มือ แก้บ้า ย่อ กาลิลี แควน โย้เวอ อางเมิง อือเมอ ม่าอู่บ ป่าว กว่า แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ฮู มาง คอก ดื้ง เมอ, พระเยซูคริสต์ อางเลิ่ง ฮา ชีอือ กงากย่า ยาว, แฮ้งย้าเย่ ยาง มือ ยาง ศิษย์ อือนา, ");
INSERT INTO bzi_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ม่า พระเยซู นา น้า แอ ปี่ ชี นี้แม้แน, “นา ชฺ้าง ลือ แฮ้มาง ย้า อ่าลา? อ้าว กงู ชฺ้าง ทื่อม่าง ชา ลือ แฮ้มางนา กงา ล่อ แล่ง ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","แฮ้งเย่ พระเยซู มือ พอ ชี นี้แม้แน, “นอง กงากย่า กงามย้าง ชี นี้อือ ยอห์น นา พ่าว ม่า แล โว นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ชฺ้าง แมปอ อืมมือ ฮูมย้าง กาชี, ชฺ้าง ต่องแก่ อืมมือ ย่อ ตอ กาชี, ชฺ้าง คี้ตู้ด อืมมือ คี้ตู้ด ย่าง โปยว คาชี, ชฺ้าง น่าป่าง อืมมือ กย่า ล้า ชี, ชฺ้างซฺี้ ชี อืมมือ แต่ ลาน ชี, แน อางเลิ่ง อางแม่น ย่าง มือ ชฺ้าง อางตูกอางพาน อือนา ป่าวกย่า ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","อ่าซ่าง กงานา นืงบาชี ยาว เจ่อ แล แล่ ล่าง, พาจาว ม้า ชฺ้าง แฮ้มางนา ม้าม้า ย้า ก่ามป่อน ปี่ แง.” ");
INSERT INTO bzi_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ยาว ยอห์น ศิษย์ มาง เย่ด พ่าว แลน แล่ยาว, แฮ้งย้า พระเยซู มือ ยอห์น มาง อางเลิ่ง ย่าง ค่องช่าง อือนา อู่บน้า ปี่ ชี นี้แม้แน, “นองมู นี้ย่า บ้าเจอฮาย ตี อางกืออางคาก ป่ากย่า ฮู แอ คูแง? นอย่า ชฺ้าง บ่าแก่นบ่าคา แน ไมออ ปาง ฮ้างม้าน ตอล้า เมอ เลิง เค่ แอ แม้แน กงามย้าง แน เย้ง คูลา? ");
INSERT INTO bzi_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","จ้า แฮ้แม้บ่าอ่ายาว, น่อ บ้าเจอ อ่อก ฮู แล แอ, ชฺ้าง ค่าลาว อางมาง อางฮู่ อางคา ตูม แล่ง อือนา ฮู คูง ลา? จ้า บ่าอ่า ม้าม้า ย้า, ชฺ้าง ค่าลาว อางมาง อางฮู่ อางคา ตูม แล่ง นี้ย่า ก่าซ้าด ยู้ม คล้าว ดื้ง กาน แง. ");
INSERT INTO bzi_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","แฮ้แม้แนยาว นอย่า บ้าเจอ อ่อก ฮู แอ แง? พาจาวจี่ต่างจี่แต่นฮู อือนา ฮู แอ คูง ลา? กงา ม่าแบ ปี่ ล่าว่า นี้แม้แน ยอห์น พาจาวจี่ต่างจี่แต่นฮู อือ ล่อบ่าปา ฮื่อ แล่ง, ");
INSERT INTO bzi_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ไม้ ยา ค้าแต้ เวอ พาจาวจี่ต่างจี่แต่นฮู อือ. มอ ยาว พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี มาง ย้า เป, ‘แม่น แน น้า ปาว! กงา นาง ฮู่ เวอ ชฺ้าง ป่าวฮู ทื่อม่าง ซฺาลือ ปี่ง, ไม้ ยา ชฺ้าง นางนา ชา ล้า เจ่อ ล่าง อือนา ซฺ้า ชี ล่าแง.’ ");
INSERT INTO bzi_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“กงา นองนา อางเลิ่ง ม้าม้า ม่า แบ ปี่ ล่าว่า, ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ฮู ม้าย่า, ชฺ้าง คาโคลาโค ชฺ้างอางเมิง นู้ เกิ้ด ลือ ชี อือ ล่อบ่าปา ฮื่อ เลิ่นเลิ่น แง. จ้า พาจาว มาง อางเมิง เวอ ชฺ้าง ปีนแตปีนนา อางอี เลิ่นเลิ่น มาง มือ ยอห์น ล่อบ่าปา ฮื่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ฮู มาง จีน เวอ จาย อามือ เคอ แน ชฺ้าง ทื่อบ่า อือ, ปีนแตปีนนา ย้า พาจาว มาง ชฺ้าง เพล่อ ซี้ แง. ");
INSERT INTO bzi_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","พาจาวจี่ต่างจี่แต่นฮู คาโคลาโค แน โมเสส อางลี้บอางล่าว โย้เวอ จาย ยอห์น จีน เวอ ตื่อเคอ นี้ย่า ฮายแบ ปี่ แง กาญ่าม เวอ บ้าเจอ ตอล้า แง แน. ");
INSERT INTO bzi_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","จาว่าแน นอง พาจาวจี่ต่างจี่แต่นฮู อือนา เจ่อจ่า ยาว, นอง มือ กงาเจ่อ คูแง, ยอห์น พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ แม้แน ชี่ มาง อ่ามือ ชา ลือ แงแน, ");
INSERT INTO bzi_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","อ่าซ่าง ก้อง น่าซื่ง จา แง แม่น แน น้า ชี คูปาว. ");
INSERT INTO bzi_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“กงา อามือ ชฺ้าง อือนา บ้าเจอ ก้อง เพ้ก ลื่อวา? ยอย่า ย่าเก ทื่งกง่า แน บ่อ ยาว ซีแล กางอือ ป้าค้า ย้า. ยาว โฮ้กฮ้าว อี่ กาง แง นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘กงู คองมาน มาโย้ง ตื่อบ่อ เมอ นอ บ่าเยน เค่ คู, กงู ศพ จา ชี แน ฮาย บ่อ เมอ นอง มือ บ่าอู่ง คู.’ ");
INSERT INTO bzi_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“ยอห์น ลือ ชี นี้ย่า ยา อ่างู่น แต่ค่า บ่าต่าง, แน ฮ่าง จฺ่าเกิ่งจฺื่ง แง, จ้า นอ ยางนา แด่ย่า อ่อง ชี แน จี่ กางแง. ");
INSERT INTO bzi_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","จ้า กงาชฺ้างอางย่า มาง ลือ เมอ, กงา อางจฺ่าอางต้าง ย้า. นองมู นี้ง นี้แม้แน จี่ กาง, ‘ชฺ้าง จฺ่า อางไล้ แน แต่ค่า ต้าง อางคา. อ่าจ่าม ชฺ้าง ภาษีกอฮู บ่าแม่น บ่ากง่าบ่าเกิง อือนา แน ชฺ้าง อางบล่าบ อือนา คาตา ซฺ้ามี แง’ แน. จ้า ชฺ้าง พาจาว มาง ก้อง เค่ อือย่า ยอ พาจาว มาง วี่ไซป้านญา อางฮื่อ แฮ้ง กงามย้าง แง.” ");
INSERT INTO bzi_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ยาว พระเยซู มือ อางเมิงชฺ้าง แฮ้อือนา จี่ ชีเย, ไม้ ยา ยอง อางเมิง อือเมอ อางเลิ่งชฺ้างบ่าฮาตอกางอือ อางบย่า ย้า ฮา ชี, จ้า ยองมู แฮ้ย่า อางบล่าบ ฮา แฮ้ง บ่าว่าง คู. ");
INSERT INTO bzi_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","แฮ้งย้าเย่ พระเยซู มือ นี้แม้แน จี่ แง, “โคราซิน อางเมิง ชฺ้าง เวอ, แน เบธไซดา อางเมิง ชฺ้าง เวอ, กงา นอง อางเมิง คล้าว โย้เวอ อางเลิ่งชฺ้างบ่าฮาตอกางอือ ไลเจ้อ ย้า ฮาย มย้าง ปี่ ล่าแอ่. จ้า นอง บ่าเจ่อ จ่าล่า แฮ้งย้า พาจาว มาง โคราซิน อางเมิง แน เบธไซดา อางเมิง ชฺ้าง อือนา วี่บ่ากไจ ปี่ชี่. จาว่าแน กงา ไทระ อางเมิง แน ไซดอน อางเมิง โย้เวอ นอง อางเมิง โย้เวอ ฮา ชี แม้แน ฮาย ยาว, มล่าง คางญ้า อางเมิง ชฺ้าง แฮ้อือ ย่า อางซีอางแล แบจ่าแล่ คู ยาว นืงบาเพ่น คูแง. ยาว อางก่าอางตูม ก่าซ่อบ พ้า อางซา อือ ตูม แล่ คู แง. ยาว บี่ย่าวค้าล้า อางตู่ โย้เวอ พ่อ แล่ คูแง. นี้แม้ ฮา ชี นี้ย่า ฮากนา ม่ายแบ ปี่ ยอย่า ม้าม้า ย้า นืงบาเพ่น ชี แน. ");
INSERT INTO bzi_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","พาจาว มาง อางซีอางแล ต้าดต่อน ฮา แฮ้นืง ย้า, โคราซิน อางเมิง ชฺ้าง แน เบธไซดา อางเมิง ชฺ้าง นี้ ไทระ อางเมิง ชฺ้าง แน ไซดอน อางเมิง ชฺ้าง อือ ล่อบ่าปา วี่บ่ากกงาไจ แง. ");
INSERT INTO bzi_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“คาเปอรนาอุม อางเมิง ชฺ้าง นี้ง ทื่อช่างกานญา บ่าเย่ง โจ เป พาจาว มาง นองนา มู่ง เวอ ซฺื่ยแล ล่าง แน. แฮ้แม้ บ่าอ่า เป น่อ ชฺ้างซฺี้ อางเมิง เวอ กงา กลา แอ ชากอน ย้า, ไม้ กงา อางเลิ่งชฺ้างบ่าฮาตอกางอือ โสโดม อางเมิง โย้เวอ ฮาย แล่อู้, แฮ้เมิง อามือ เคอ ย้า จา แง. ");
INSERT INTO bzi_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","กงา อางเลิ่ง ม้าม้า แฮ้ง ม่ายแบ ปี่ ล่าว่า, อางนืงต้าดต่อน แฮ้นืง ย่า, นอย่า โสโดม อางเมิง ชฺ้าง อือ ล่อบ่าปา วี่บ่ากกงาไจ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ยาว พระเยซู มือ จี่ เย นี้แม้แน, “อ่าโบ้งพาจาว เวอ, นา มู่งท่า แน ชฺ้างอางเมิง อางซื้ง มาง ย้า. กงา นางนา สรรเสริญ ฮา ล่าแน. ยี่นดี ย้าเป นาง กงา อางเลิ่ง นี้ง ชฺ้าง อางแอ้น อางแบ อือนา โชง ชี ชี นี้ย่า, จ้า ชฺ้าง บ่าแบบ่าบู่ ย่าเก ป้าค้า อือนา แบ ปี่ชี่ นี้ย่า. ");
INSERT INTO bzi_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","อางอ้า ย้า อ่าโบ้ง กงา พาจาว มาง เวอ, นาง เพล่อ ปี่ ซี่ แม้แน เพล่อ ปี่ ปาว แน. ");
INSERT INTO bzi_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“พาจาว กงา อ่าโบ้ง ม้า กงานา กูย่างกูเจ้อ อือ ล่อบ่าปา แน ล่าที่ จา ปี่ ล่าแง. กงานา อ่าซ่าง มาง บ่าแบ ล่า กงากา, พาจาว กงา อางโบ้ง มาง ญา อางแบ ล่า กงากา แน. ยาว พาจาว กงา อ่าโบ้ง มางนา อ่าซ่าง มาง บ่าแบ กงากา, กงา แน กงา ชฺ้าง แช้ยู้ ชี่ อืนญา พาจาว กงา อางโบ้ง มางนา อางแบกงา กาแน.” ");
INSERT INTO bzi_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ชฺ้าง คาโคลาโค นืงบาต่อง เวอ ตูกพานลาบ้าบ อือย่า กงาก้อง ลาน คู ปาว, ยาว กงา นองนา ซ่าว ปี่ ล่าว่า. ");
INSERT INTO bzi_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","กงา ม่าย ฮา ปี่ ล่า ชี แฮ้งแม้แน ฮายเค่ คู ปาว แน กงาก้อง เล่นแบ แล่ คู ปาว, ไม้ กงาย่า อางเซฺิ่งอางไซ อางด่อ แน บ่าอ่อนจ่าแล, กงานา ฮูพลา ปี่ ล่าปาว, ยาว กงา นองนา ซ่าว ปี่ ล่า คู แน. ");
INSERT INTO bzi_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ยาว กงา นองนา ล่ากาน ว่า ปี่ ล่าง แฮ้งมือ บ่าฮ่านบ่าตือ” แน. ");
INSERT INTO bzi_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ทื่อนืง จา ชี, พระเยซู แน ยาง ศิษย์ อือ กอแต่ โย้เวอ ย่อ ไก ชีเย. แฮ้นืง ย่า ลองนืง เย. ยาว ยาง ศิษย์ อือ นาบาตา ฮ่างแบ่ คู เย แฮ้งย้าเย่ ยอง มือ กอน้าม ย่าง เชอ ยาว ช่าจฺ่า คู ชี. ");
INSERT INTO bzi_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ฟาริสี มู อือ แฮ้แม้แน มย้าง ยาว ยอง มือ พระเยซู นา นี้แม้แน จี่ เย, “โย้ ฮู ปาว, นาง ศิษย์ อือย่า อามือ ลองนืง อางลี้บอางล่าว โย้เวอ อางซี ฮา คูชี” แน. ");
INSERT INTO bzi_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ยาว พระเยซู มือ ยองนา พอ ชีเย นี้แม้แน, “นอย่า พระคัมภีร์ เวอ บ่ากงา อ้าน กางซื้งลา? ก่าซ้าด ดาวิด แน ยางชฺ้าง อือ แบ่ซฺู่ คู เมอ บ้าเจอล้อแม้ แน ฮา ชี แน? ");
INSERT INTO bzi_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ยา โบสถ์ พาจาว มาง ดื้งย้า โย้เวอ ย่อ อ้อง แลน ชี. แน พาจาว มางนา ค้านู้มป่าง ท่าน ชี แฮ้ง จฺ่า ชี. กงู ศาสนา อางลี้บอางล่าว นี้ย่า, ปุโรหิต อืน ญา พาจาว มางนา ค้านู้มป่าง ท่าน ชี แฮ้ง จฺ่า กงากา แง. จ้า ก่าซ้าด ดาวิด ค้านู้มป่าง แฮ้ง จฺ่า ชี. อ่าจ่าม มือ ยาง ชฺ้าง อือนา คาตา ย้า เปิ่ง จฺ่า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ยาว นอย่า โมเสส อางลี้บอางล่าว แฮ้ง บ่าอ่าน กางซื้ง ล่า, กาเทอกา ปุโรหิต โบสถ์อางฮื่อ โย้เวอ ล่ากาน ว่า อือย่า ลองนืง เวอ ล่ากาน ว่า คูแง, จ้า ยอง ก้อง อางซี บ่าจา. ");
INSERT INTO bzi_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","กงา ม่ายแบ ปี่ ล่าว่า ชฺ้าง โบสถ์อางฮื่อ ล่อบ่าปา แน ฮื่อ ม้า นู้ จาน ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","พระคัมภีร์ โย้เวอ นี้แม้แน แต้ม ชี ชี, ‘กงาย่า ลากซื่งกง่ากย้า แฮ้ง มย้าง ซี่ค้า, อางเกิ่งท่านเซฺ่อ แฮ้งนา มย้าง ซี้ง บ่าอ่า’ แน, จ้า นอ บ่าแบ คู พระคัมภีร์ โย้เวอ จี่ต่าง แต้ม ชี ชี แฮ้ย่า บ้าเจอ นา ฮา แงแน. จาว่าแน นอง อางแบ แน ยาว นอย่า ชฺ้าง อางซี บ่าจา อือนา อางซี จา แงแน บ่าจี่ คู. ");
INSERT INTO bzi_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ไม้ กงาชฺ้างอางย่า เพล่อ ชี่ นี้ม้า ย่า ล่าที่ อางจา ลองนืง ล่อบ่าปา ฮื่อ แล่ง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ยาว พระเยซู มือ ยิวชฺ้าง โบสถ์ โย้เวอ อ้อง แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ยาว ค่าพ่าย่า ทื่อม่าง จา เย, ยาง ล่าปู่ แฮ้ อางแล่บ เย. ยาว อางลี้บอางล่าว ม่าอู่บฮู อือ แน ฟาริสี มู อือ ล่อ ฮู คูง เย, พระเยซู อ่าซ่าง นา ลองนืง เวอ ยา แงแน, ไม้ ยอ พระเยซู นา อางเลิ่ง จี่ เซฺ่อ ซฺ้า เย. ");
INSERT INTO bzi_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ยาว แฮ้งเย่ พระเยซู มือ ยองนา พอ ชี นี้แม้แน, “จาว่าแน นองมู โย้เวอ ชฺ้างทื่อม่าง จา แง, ยางก้อง แกะ ทื่อโต จา ยาว ลองนืง โย้เวอ ล้างบ้อ กลา แล่ ยาว, ยา ยาง แกะ มางนา บ่าปล่อง จาก คื้น ลา ปี่ ลา? ");
INSERT INTO bzi_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ชฺ้าง นี้ย่า แกะ ล่อบ่าปา เป อางฮู่ จาแง. นี้แม้แนยาว ลองนืง เวอ อางแม่น ฮา แฮ้ย่า อางลี้บอางล่าว เวอ เจิ้นเจ้อ บ่าซี” แน. ");
INSERT INTO bzi_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ยาว พระเยซู มือ ค่าพ่าย่า ล่าปู่ อางแล่บ มางนา จี่ช่าง ชี นี้แม้แน, “ล่าปู่ กลาง อ่อก ลือ ปี่ โว!” แน. ยาง ฮา เค่ ชีเย. ยาว ยาง ล่าปู่ อางแล่บ ย่าง ยาง ล่าปู่ ล่าซ่าย แม้แน แม่น ล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ฟาริสี มู อือ แฮ้แม้แน มย้าง เมอ, ยอง ยิวชฺ้าง โบสถ์ อางเง้ เวอ อ่อกแอน คูชี. แน ยองมู แฮ้ง น้าท้าม ลางกา ชี, พระเยซู นา บ้าเจอล้อแม้ แซ่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","จ้า พระเยซู มือ แบจ่าแล่ ยาว ยาง มือ อ่อกแอน ชี. ยาว ชฺ้าง อางอีบ่าอ่า เย ยางก้อง เค่ แอน คูชี. แน พระเยซู มือ ชฺ้างอางด้าอางกย้าง คาโคลาโค อือ พ่าญาด ย่าง ยา โปยว ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ยาว พระเยซู มือ ชฺ้าง แฮ้อือนา ม่า ชี, “กงา อ่าซ่าง แน ฮากนา บ่าม่า โจ” แน. ");
INSERT INTO bzi_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ไม้ พาจาวจี่ต่างจี่แต่นฮู อิสยาห์ มอ ยาว พระคัมภีร์ เวอ แต้ม ชี ชี แฮ้งแม้แน ตอล้า ปี่ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“นี้ม้าย่า กงา ย่าเจ่น กงา แช้ ชี ชี มาง, กงาย่า ยางนา นาบาตา ย้า นืงบาจาบ ลาก แง, กงาย่า กงา อางค่องอางล้า แฮ้ง ยางนา ปี่ แน, ยา อางเลิ่ง อางกง่าอางเกิง แฮ้ง ชฺ้างกูเจ้อกูจาด อือนา ป่าว แบ ปี่แง. ");
INSERT INTO bzi_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ยา อ่าซ่าง มางนา บ่าซีบ่าแล ช่าง, อ่าซ่าง มาง ยาง อางเซง แฮ้งนา ก้าด อือเมอ บ่ากงากย่า คู. ");
INSERT INTO bzi_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ยาง อางเลิ่ง อางกง่าอางเกิง แฮ้งนา ฮาย ก่าจ่า ปี่ เมอ ตื่อเคอ, ยา ชฺ้างอางด่ออางย่า อือนา บ่าแม่น แน บ่าฮา ช่าง. ยา ไมออ ปาง จูม ชีอือ แม้แน ชี อือนา บ่าเคลิก วี แน ยา กู่มบี่ท่อ ชาซฺู่ อือ แม้แน ชี อือนา บ่าซฺู่. ");
INSERT INTO bzi_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","กาญ่าม โย้เวอ ชฺ้างกูเจ้อกูจาด อือ ยางนา นืงบาแก่นจ่า คูแง.” ");
INSERT INTO bzi_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ชฺ้าง ทื่อม่าง จา แง แด่ย่าอ้อง ปี่ ยาว บ่าฮูมย้าง กา แน บ่าจี่ตอ กาแน เพล่อ ปี่ ชี่. ยาว ค่องช่าง อืมมือ ยางนา พระเยซู ก้อง ซฺื่ยล้า ชีเย. พระเยซู มือ ยาจ่า ชี แฮ้งย้าเย่ ยางมือ ฮูมย้าง ล้า ชี แน จี่ตอ กา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ชฺ้าง คาโคลาโค อือ นืงบาม่าน โค ชีเย. ยาว ยอง มือ น้า กาง เย นี้แม้แน, “ชฺ้าง นี้ม้า ย่า ก่าซ้าด ดาวิด อางอ่านอางซฺื้อ มาง ไป้ วา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","จ้า ฟาริสี อือ กงากย่า คู ยาว ยอง มือ จี่ เย นี้แม้แน, “เยซู ซาตานแด่ย่ายอคา อางเม้ง เบเอลเซบูล ชี่ มางก้อง ล่าที่ กงาบู้ ชี. แฮ้งย้า ยา แด่ย่า ก่า อ่อก กงา กาแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ยาว พระเยซู อางแบ เย, ยอ บ้าเจอ เย้ง แงแน. แฮ้งเย่ นี้แม้แน ม่า ชี, “อางเมิง ล้อเมิง ชฺ้าง อือ ซีแล บ่าโลง กาแง แฮ้เมิง ย่า อางเมิง เพล่อ แล แล่ บ่ากงา เป. ยาว ยู้มชฺ้าง ล้อยู้ม ซีแล กาแง ยอ ก่างพยา คูแง. ");
INSERT INTO bzi_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","นี้แม้แน ยาว ซาตานแด่ย่ายอคา มาง ทื่อช่างกานญา, ค่าตอง แด่ย่า ย่าเจ่น อือนา ก่างพยา ยาว ยางมือ ยาง อางโต แฮ้ง ก่างพยา แล่ กาน้าอี่. ยาว ยา ล้อแม้แน แด่ย่ายอคา ก่าซ้าด เพล่อ แล ตอ กาแน? ");
INSERT INTO bzi_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ท้าว นอง ศิษย์ อือย่า อ่าซ่าง ล่าที่ แฮ้ง ไจ คูแง? ไม้ ยอง ทื่อช่างกานญา แด่ย่า นา ก่าอ่อก แง. จาว่าแน นอง ศิษย์ อือ ซาตานแด่ย่ายอคา มาง ล่าที่ แฮ้ง บ่ากงา ไจ ยาว, กงาม มือ ทื่อช่างกานญา ซาตานแด่ย่ายอคา ล่าที่ แฮ้ง บ่ากงา ไจ. นี้แม้แนยาว นอง ศิษย์ อือย้า นองนา อางซี ต้าดต่อน ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","จ้า กงา พาจาว มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง ไจ แด่ย่า นา ก่าอ่อก แง, นี้แม้แนยาว พาจาว มาง ก่าซ้าด ชา ลือ เพล่อ ลืง ย่าง อางญ่าม ชา เคอ ลือ ญา. ");
INSERT INTO bzi_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“บ่าอ่า เวิมมือ อ่าซ่าง ฮาก ยู้ม เวอ ค่าว อ้อง อางเกิ่ง ค่าว ฮื่น นี้ย่า, จาว่าแน ยู้มซื้ง อางแก่นอางคา มางนา บ่าชู พือ ชี เปิน ยาว, อ่าซ่าง มาง ยู้ม คล้าว โย้เวอ อางเกิ่ง แฮ้ง บ่าค่าว ฮื่น กงากา. จ้า ยู้มซื้ง อางแก่นอางคา มางนา ชู พือ ชี ยาว, ยู้ม คล้าว โย้เวอ อางเกิ่ง แฮ้ง อางค่าว ฮื่น กงากา ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ชฺ้าง กงา จี่ต่าง บ่าฮายเค่ อือย่า ชฺ้าง กงานา เม้อ ล่าง อือ ย้า. ชฺ้าง กงานา บ่าปล่อง ล่าง อือย่า ชฺ้าง กงา ล่ากาน แฮ้ง ฮาย ก่างพยา ปี่ อือย้า เป. ");
INSERT INTO bzi_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“กงา อางเลิ่ง ม้าม้า แฮ้ง ม่า ล่าว่า, พาจาว ม้า ชฺ้าง อางบล่าบ กูเจ้อ แน จี่ต่างฮูย้า กูเจ้อ อือนา อางซี บ่ายู่, จ้า พาจาว ม้า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มางนา ฮูย้า คูชี อือนา อางซีอางบล่าบ ยู้ แง. ตื่น อ่ามือ เวอ จาย แน กาญ่าม เวอ เคอ ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","จ้า อ่าซ่าง กงาชฺ้างอางย่า เพล่อ ชี่ นี้ มางนา จี่ ฮูย้า ล่าแง, พาจาว ม้า ชฺ้าง แฮ้มางนา อางซีอางบล่าบ บ่ายู่ เวิม อางกงา. จ้า อ่าซ่าง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มางนา จี่ ฮูย้า แง, พาจาว ม้า ชฺ้าง แฮ้มางนา อางซีอางบล่าบ ยู้ แง, ตื่น อามือ จีน จาย จ้างจ้าง จีน เวอ เคอ ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“จาว่าแน จฺืงจฺื้ง แฮ้งนา บ้าเจอ จฺื้ง แน แบ ซี้ง แนยาว อางซื่อ โย้ ฮู กาโน, จาว่าแน อางจฺื้ง แฮ้ง อางแม่น แน ยาว, อางซื่อ แฮ้งมือ อางแม่น, จ้า จาว่าแน อางจฺื้ง แฮ้ง บ่าแม่น ยาว, อางซื่อ แฮ้งมือ บ่าแม่น. ");
INSERT INTO bzi_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","อื้อล้าง อางปีด อางเจ้อ อือ เวอ นอย่า ชฺ้าง บ่าแม่น, จี่ต่าง อางแม่น แน อางกง่าอางเกิง อือย่า นอง ม่านป่อง โย้เวอ ล้อแม้แน จายล้า ตอกา แน, ไม้ นืงบา โย้เวอ บ้าเจอ ปลืงล้อน จา แง นอง ม่านป่อง มาง แฮ้แม้ย้า จี่ อ่อกล้า ปี่แง. ");
INSERT INTO bzi_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ชฺ้าง อางแม่น อือ ยอง นืงบา คล้าว เวอ อางแม่น อือ จี่ ล้า ปี่ง, จ้า ชฺ้าง บ่าแม่น อือ ยอง นืงบา คล้าว เวอ บ่าแม่น อือ แอ่ ย้า จี่ คูแง. ");
INSERT INTO bzi_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","กงา ม่ายแบ ปี่ ล่าว่า, อางซี ต้าดต่อน แฮ้นืง ย่า, นอง จี่ต่าง กูย่างกูเจ้อ บ่าแม่น แน จี่ ชี อือ กงาลาบ จ่าแล่ คู แง. ");
INSERT INTO bzi_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","นอง จี่ต่าง แฮ้งย้า ฮายแบ ปี่ง, นอย่า อางกง่าอางเกิง ล่า อางซี แน.” ");
INSERT INTO bzi_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","อางลี้บอางล่าว ม่าอู่บฮู อือ แน ฟาริสี ทื่อบ่า อือย่า พระเยซู นา นี้แม้แน จี่ช่าง เย, “อ่าจาน เวอ, อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮายฮู ปี่ ล่าปาว, ไม้ กงู แบ ซี้ง แง นาย่า พาจาว มาง ล่าที่ แฮ้ง ม้าม้า แน อางจา ล่า แน.” ");
INSERT INTO bzi_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","แฮ้งย้าเย่ พระเยซู มือ นี้แม้แน พอ ชี, “ชฺ้าง บ่าแม่น แน ชฺ้าง พาจาว มางนา บ่าเจ่อ อือย่า, ชฺ้าง อางเลิ่งชฺ้างบ่าฮาตอกางอือ ม่า ฮา ปี่ง อือ ย้าเป, จ้า กงาย่า เจิ้นเจ้อ อางเลิ่งชฺ้างบ่าฮาตอกางอือ บ่าฮา ฮู ปี่ล่า, พาจาวจี่ต่างจี่แต่นฮู โยนาห์ ก้อง อางเลิ่ง ตอล้า ชี แฮ้งญา ฮายฮู ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ยาว กงาชฺ้างอางย่า มางนา ชฺ้างอางเมิง ท้ามชฺ้างซฺี้ชีย้า นู้เวอ 3 คี่ 3 นืง ชี แง, โยนาห์ ล่องแต่ อางฮื่อ ป่องปอง เวอ 3 คี่ 3 นืง ดื้ง ชี แม้แน.” ");
INSERT INTO bzi_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“อางนืงต้าดต่อน แฮ้นืง นีนะเวห์ อางเมิง ชฺ้าง อือย่า, นองมู อามือ ชฺ้าง อือก้อง ทื่งกง่า แน ทานล้า แง. ยาว นองนา จี่ ล่า คูแง, ไม้ นีนะเวห์ อางเมิง ชฺ้าง อือ โยนาห์ ม่าอู่บจี่ต่าง ย่าง กงากย่า คูยาว อางบล่าบ ฮา แฮ้ง บ่าว่าง คู, จ้า กงา โยนาห์ ล่อบ่าปา แน ฮื่อ เวิม, กงา ม่าอู่บ ล่าเมอ นอ กงานา บ่าน่าจ่า ล่า แน นืงบา บ่าเพ่น คู. ");
INSERT INTO bzi_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“ยาว พาจาว มาง ชฺ้าง อางบล่าบ คาโคลาโค อือนา อางซี ต้าดต่อน แฮ้นืง, พระราชินี เชบา อางเมิง โย้เวอ จายล้า ชีมาง พาจาว มาง ล้าก้า โย้เวอ นอง อางเลิ่ง อางซี ฮา ชี แฮ้ง อู่บน้า ปี่แง. ยา อางเว่อ เวอ จายล้า ชี ก่าซ้าด โซโลมอน วี่ไซป้านญา แฮ้ง น้า ล้า แงแน. จ้า กงา ก่าซ้าด โซโลมอน ล่อบ่าปา แน ฮื่อ เวิมมือ นองมู นี้ย่า กงานา บ่าน่าจ่าล่า คู.” ");
INSERT INTO bzi_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“แด่ย่า มาง ชฺ้าง อางโต โย้เวอ อ่อก ยาว, ตี อางกืออางคาก อือเมอ ดื้งย้า ซฺ้า กว่า แอ ชีเย. จ้า บ่าซฺ่า กงากา เย. ");
INSERT INTO bzi_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ยาว ยาง นี้แม้แน จี่ เย, ‘กงา ชฺ้าง กงา อ้องอ่าน มางก้อง พ่าว อ้อง แล่ง แฮ้ง เชคาไล’ แน. ยาว ยาง พ่าวแอ้น น้าว, ยาว ยาง มย้าง ชีเย, ชฺ้าง แฮ้ม้า ยู้ม อางเซฺิ่งอางซฺ้าง ชฺ้าง บ่าดื่ง อือ ป้าค้า ย้า เพล่อ ชี แน. ");
INSERT INTO bzi_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ยาว แฮ้งย้า ยาง มือ แด่ย่า ยาง ล่อบ่าปา แน อางโซ้กอางไล้ อือนา 7 แด่ ช่าง ยาว, ชฺ้าง แฮ้มาง ก้อง ทื่งกง่า แน อ้อง ชีเย. ยาว ชฺ้าง แฮ้มาง อางอ้าน แฮ้ง ล่อบ่าปา เย ลาบ้าบ เค่ แล่ชี่. อามือ จีน อางไล้ นู้เวอ ชฺ้าง บ่าแม่น อืมมือ แฮ้แม้ย้า ชา กงาเพล่อ คู แง.” ");
INSERT INTO bzi_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","พระเยซู ค่องช่าง อือนา ยู้ม คล้าว โย้เวอ ม่าอู่บ จา เมอ, พระเยซู อางแพ้ แน อางบา อือ ยางนา จี่ช่าง ซี้ ยาว ยู้ม อางเง้ โย้เวอ ล่อ ดื้ง คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ยาว ชฺ้าง พระเยซู นา นี้แม้แน ลือ ม่า ลือ ชีเย, “อ่าจาน เวอ, นาง อางบา แน นาง อางแพ้ อือ นางนา อางเง้ โย ล่อ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","แฮ้งย้าเย่ พระเยซู มือ ยางนา น้า ชี นี้แม้แน, “กงา อางบา แน กงา อางแพ้ อือย่า อ่าซ่าง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ยาว พระเยซู มือ ยาง ศิษย์ อือก้อง ล่าปู่ กลาง แอ ยาว จี่ เย นี้แม้แน, “นอง ย้า กงา อางบา แน กงา ม้องน้าม อือ ย่า. ");
INSERT INTO bzi_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ชฺ้าง กงา อางโบ้ง มู่งท่า เวอ ดื้ง มาง นืงบาจาบวา แน ฮายเค่ อือย่า, กงา อางบา แน อางแพ้ อางป่อ ม้าม้า อือย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ทื่อนืง กานญา เย, พระเยซู มือ ยู้ม เวอ อ่อก ลือยาว ลองอองอางฮื่อ ก่องทาง เวอ ดื้ง ลือชี. ");
INSERT INTO bzi_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ชฺ้าง อางอีบ่าอ่า เย ยางนา แวด คูชี, แฮ้งย้าเย่ ยาง มือ ล้อง เวอ ตา แอ ชี, ยาว ชฺ้าง แฮ้อือ ลองอองอางฮื่อ ก่องทาง โย้ จา คู ชี. ");
INSERT INTO bzi_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ยาว พระเยซู มือ ยองนา อางเลิ่ง ม่าอู่บ เพ้ก น้า ปี่ ชี. ยา นี้แม้แน อู่บ เย, “น่าว่าฮู ทื่อม่าง จา แง. อ่อกแอ กอย่าว ปยา แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","กอย่าว ปยา เมอ, กอย่าว ทื่อบ่า อือย่า แก้บ้า ย่อย่า อือเมอ กลาน ชี. ยาว ฮาย่า ดอก จฺ่า โค ชี. ");
INSERT INTO bzi_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","กอย่าว ทื่อบ่า อือย่า ลอบา ท่า เวอ นื้งชฺ่า จา ชี อือเมอ กลาน ชี. ยาว กอย่าว แฮ้ง อางไว่ ย้า แต่ล้าน ชี, ไม้ นื้งชฺ่า บ่าน่า. ");
INSERT INTO bzi_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","จ้า นื้งช้า ช่อ เมอ ล้อง ยาว แฮ่ว กือ ซฺี้น ชี, ไม้ อางเช บ่าน่า. ");
INSERT INTO bzi_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","กอย่าว ทื่อบ่า อือย่า จี่กู่แต่ เวอ กลา แอ ยาว จี่กู่ปาว ย่าง โปกปาว ฮา ซฺี้ ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","จ้า กอย่าว ทื่อบ่า อือย่า นื้งชฺ่า อางแม่น อือเมอ กลาน ชี. แฮ้งย้า แต่ ฮื่อ มอง ล้า แม่นมาง ชี. แน กอน้าม พลอง อ่อก ล้า กอ กงา ชี 30 โตบ, 60 โตบ แน 100 โตบ. ");
INSERT INTO bzi_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","อ่าซ่าง น่าซื่ง จา แง แม่น แน น้า คูปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","พระเยซู ศิษย์ อืมมือ พระเยซู นา นี้แม้แน น้า คูง เย, “บ้าเจอ นา อางเลิ่ง เพ้ก อือ แอ่ แน ค่องช่าง อือนา อางอู่บ น้า ปี่ แน” แน. ");
INSERT INTO bzi_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ยาว พระเยซู มือ ยองนา นี้แม้แน ม่า ชี, “นอง ญา เป พาจาวอางเมิง อางเลิ่งอางโชง แฮ้ง กงาแบ คูงแง, ฮาก ย่า บ่ากงา แบ เป. ");
INSERT INTO bzi_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","นอ ชฺ้าง น้าฮู บ้าเจอล้ออื้อเจ้อ เพล่อ แงแน. ชฺ้าง กงา ม่าอู่บ ยาว น้า อือ ยอ บย่า แน แบ เค่ แง. จ้า ชฺ้าง กงา ม่าอู่บ ยาว บ่าน่า อือ, อางแบ ย้า แน เย้ง จ่าแล่ง อือ, พาจาว ม้า ยาง แบ ชี แฮ้ง ยู้ คื่น แล่แง. ");
INSERT INTO bzi_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","นี้งย้า กงา ยองนา อางเลิ่ง เพ้ก น้า ปี่ นี้ย่า, ยองมู นี้ย่า ฮู เวิม ฮู แล่ ย้า, จ้า บ่าฮู มย้าง กา, น้า เวิม น้า แล่ ย้า, จ้า บ่าน่ากลา กา, ไม้ ยอง มย้าง ยาว แบน ยาว, ยอ พาจาว มางนา พ่าว ซฺ้า ล้า แง. แน พาจาว มาง ยองนา อางซีอางบล่าบ บ่ายู่. ");
INSERT INTO bzi_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“พาจาวจี่ต่างจี่แต่นฮู อิสยาห์ มอ ยาว พระคัมภีร์ เวอ แต้ม ชี ชี แม้แน ตอล้า ชี, ‘นอย่า น้ายาวน้าแล่ เวิม มือ บ่าแบ คู นอย่า ฮูยาวฮูแล่ เวิม มือ บ่ามย่าง. ");
INSERT INTO bzi_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ไม้ ชฺ้าง นี้มู นืงบา นี้ย่า อางล้าน. ยอง น่าซื่ง นี้ย่า บ่าน่า ซี้ แน ยองมู นี้ย่า ค่าตอง แมนือ แฮ้ง วาบ แล่ง. นี้แม้ บ่าอ่า แนอู้ ยอ อางกงามย้าง คู, แน ยอง น่าซื่ง แฮ้ง อางกงากย่า คู, แน ยอง นืงบา แฮ้ง กงาแบ คูแง, แน กงานา พ่าว ซฺ้า ล้า ล่าง. กงานา ยอง อางบล่าบ อือ ปล่องปูน ปี่ ล่าง แน.’ ");
INSERT INTO bzi_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“นองมู น่าซื่ง จา ยาว กงากย่า อือ, แน แมนือ จา ยาว กงามย้าง อือย่า, พาจาว มาง ก่ามป่อน แฮ้ง กงาบู้ ญา. ");
INSERT INTO bzi_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","กงาย่า อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า นี้แม้แน, อามือ นอง อางเลิ่ง กงากย่า กงามย้าง ชี นี้ย่า, ค้าแต้ พาจาวจี่ต่างจี่แต่นฮู แน ชฺ้าง พาจาว มาง นืงบาจาบวา แน ฮายเค่ อือย่า, นาบาตา แน กงากย่า กงามย้าง คู ซี้ เวิม, ยอ บ่ากงากย่า แน บ่ากงามย้าง คู.” ");
INSERT INTO bzi_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","พระเยซู จี่ แล่ง นี้แม้แน, “แม่น แน น้า คู โว นี้ย่า น่าว่าฮู มาง กอปยา อางเลิ่งเพ้ก แฮ้ง อู่บ ไค้ แบ ปี่ ล่าง ย้าง. ");
INSERT INTO bzi_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","กอย่าว แก้บ้า อือเมอ กลา ชี อือย่า, ชฺ้าง พาจาว มาง ม่าอู่บจี่ต่าง แฮ้ง กงากย่า คูยาว, บ่าแบ กื้ง แน ชฺ้าง บ่าแม่น มาง แน บ่าอ่ายาว ซาตานแด่ย่ายอคา มาง, ยอง นืงบา คล้าว เวอ พาจาว มาง ม่าอู่บจี่ต่าง อือ ค่าว ฮื่น ปี่ชี่ อือย้า. ");
INSERT INTO bzi_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ยาว ชฺ้าง ทื่อบ่า อือย่า กอย่าว ลอบา ท่า นื้งชฺ่า จา ชีอือ เมอ กลา ชีอือ ช้อด ย้า. ยองมู นี้ย่า พาจาวจี่ต่าง กงากย่า เมอ, นืงบาต่องม่อนซ้า แง. แน ซฺ้อก ย้า พาจาวจี่ต่าง แฮ้ง นืงบา เวอ กอ ชี คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","จ้า ยอ พาจาวจี่ต่าง แฮ้ง ปีนแตปีนนา แน บ่าแบ คู. แฮ้งย้า พาจาวจี่ต่าง แฮ้ง ยอง นืงบา เวอ อางมล่าง แน บ่าดื่ง แง. จาว่าแน ยอง พาจาวจี่ต่าง เจ่อ ชี แฮ้ง ปาปาย, แน ฮาก ยองนา คาม ฮาย ตูกพานลาบ้าบ ปี่ ยาว, ยอ ซฺ้อก ย้า พาจาวจี่ต่าง เจ่อ ชี แฮ้ง ว่าง แง. ");
INSERT INTO bzi_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ชฺ้าง ทื่อบ่า อือย่า กอย่าว จี่กู่ปาว กลา ชีอือ ช้อด ย้า. ชฺ้าง นี้อือ พาจาวจี่ต่าง กงากย่า ชีอือ ย้า. จ้า ยอ ชฺ้างอางเมิง นู้เวอ จี่วีด ไจ จาดื้ง แฮ้ง พี้ล้อง แง. แน อางเกิ่งอางก้อ ค่าม พลู้ อือนา ลาก แง. แฮ้งย้า พาจาวจี่ต่าง แฮ้ง ยอง ก้อง จองไจ บ่าจา แง. ยาว นี้ย่า ยอง จี่วีด โย้เวอ จี่กู่ ปาว ชี ปี่ชี่ ช้อด แน. ");
INSERT INTO bzi_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","จ้า ชฺ้าง ทื่อบ่า อือย่า กอย่าว นื้งชฺ่า อางแม่น เวอ กลา ชี อือ ช้อด ย้า. ยองมู นี้ย่า พาจาวจี่ต่าง แฮ้ง ม้าม้า แน กงากย่า ยาว นืงบา คล้าว กอ ชี ชี. แน จองไจ ตอล้า ชี 30 โตบ, 60 โตบ แน 100 โตบ” แน. ");
INSERT INTO bzi_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ยาว พระเยซู มือ อางเลิ่ง ทื่อเลิ่ง เพ้ก น้า แล่ ปี่ชี่ นี้แม้แน, “พาจาว มาง อางเมิง แฮ้ย่า เพ้ก ลื่อ ยาว, ชฺ้าง ค่าตอง น่า คล้าว โย้เวอ กอย่าว อางแม่น ปยา ชี มาง แม้แนย้า. ");
INSERT INTO bzi_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","จ้า มู่งคี่ เวอ ชฺ้าง อือ ยู่ โค เมอ, ชฺ้าง ยางนา บ่าซอ มางมือ ล้า ยาว ยาง กอปยา ชี โย้เวอ บู่ก่า นือ ย่าง ค่าว ปยา ยาว ฮื่น ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","กอ อือ แต่ล้า กอปู่ม พลอง ลา เมอ บู่ก่า อือ คาตา เย แต่ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ยาว ย่าเจ่น อืมมือ น่า อางซื้ง มางนา น้า คูง เย นี้แม้แน, ‘เจ้านาย เวอ, นาย่า กอย่าว อางแม่น อือ ปยา แอ อ่าลา? ท้าว บ้าเจอ บู่ก่า อือย่า ล้อแม้แน ตอล้า กงากา ชี แน?’ ");
INSERT INTO bzi_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“ยาว เจ้านาย มาง มือ ยาง ย่าเจ่น อือนา พอ ชีเย นี้แม้แน, ‘ชฺ้าง กงานา บ่าซอ ล่าง มาง ฮา ชี แน’ ยาว แฮ้งย้าเย่ ย่าเจ่น อืมมือ น้า คูงแง นี้แม้แน, ‘นาย่า กงูนา กื่น ปี่ ล่าง ลา?’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“ยาว ยาง ย่าเจ่น อือนา ม่า เย ‘บ่ากงา กื่น คา อ่าซ่า กอ อางแม่น อือนา คาตา กื่น นา. ");
INSERT INTO bzi_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","อางญ่าม กอแย่ญ่าม เมอ เคอ แน ทื่งกง่า แน ตอ แต่ล้า ปี่ ปาโน, ยาว กงา กอแย่บ่า อือนา ม่า บู่ก่า แฮ้อือนา แย่ ช้อน ยาว บี่ท่อ ฮ้าน พี แอ ปี่ง แน, เปิน ยาว กอ อางแม่น แฮ้ง กงา กอโชง โย้เวอ ม่า ฮ้าน ชี ล้า ปี่ แน.’” ");
INSERT INTO bzi_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ยาว พระเยซู มือ อางเลิ่ง ทื่อเลิ่ง อู่บ เพ้ก น้า แล่ ปี่ชี่ นี้แม้แน, “พาจาว มาง อางเมิง แฮ้ย่า ม่าต่าโก้บ อางนือ, น่าว่าฮู มาง ยาง ย้า โย้เวอ แล คลา แล ชี แม้แน ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ม่าต่าโก้บ นือ นี้ย่า กาบ่ากาเจ้อ อางนือ อือ ล่อบ่าปา เย อี เลิ่นเลิ่น แง. จ้า ยาง ฮื่อ ลา เมอ ซื่อย่าวก่างย่าว กาบ่ากาเจ้อ อือ ล่อบ่าปา ฮื่อ แง, แน ฮาย่า อืมมือ ล่างาม โย้เวอ อางป่าม ป่าม เวิม อางกงา.” ");
INSERT INTO bzi_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ยาว พระเยซู มือ อางเลิ่ง ทื่อเลิ่ง อู่บ เพ้ก น้า แล่ ปี่ชี่ นี้แม้แน, “พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด ลือ เพล่อ ลือ นี้ย่า บ้าเจอล้อแม้ ลือ แง? ค่าบาย่า ทื่อม่าง ผงฟู แฮ้ง ไจ ค้านู้มป่าง แต่ง ชี ป้าค้า ย้า. ยา แป้ง 3 ถัง โย้เวอ ผงฟู อางอี ซูน ยาว แป้ง แฮ้งนา ฮา อู่ง ล้า ปี่ชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","พระเยซู อางเลิ่ง คาโคลาโค นี้อือ ค่องช่าง อือนา อู่บน้า ปี่ชี่ นี้ย่า อางเลิ่ง อู่บ เพ้ก น้า ปี่ อือ แอ่ ย้าเย่ อู่บ เพ้ก น้า ปี่ชี่, อางเลิ่ง ทื่อเลิ่ง แนม มือ บ่ากงา เพ้ก แน บ่าจา เย. ");
INSERT INTO bzi_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ยาว นี้ย่า พาจาวจี่ต่างจี่แต่นฮู มาง จี่ ชี ชี แม้แนย้า ตอล้า ชี. “กงาย่า อางเลิ่ง อู่บเพ้ก น้า ปี่ อือ ม่าอู่บ แง กงาย่า ชฺ้างอางเมิง แต่งล้า เมอ จาย อางเลิ่งโชง ชี ชีอือ จี่เคอ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","พระเยซู ค่องช่าง อือก้อง เจิ่กล้า ยาว ยู้ม เวอ อ้องแล ยาว, ยาง ศิษย์ อืมมือ เค่ อ้องล้า ยาว นี้แม้แน ป้า เย, “กงู นา น่า คล้าว เวอ บู่ก่า อางเลิ่ง เพ้ก แฮ้ง อู่บ ไค้ น้า ปี่ ล่า ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","พระเยซู มือ ยองนา พอ ชีเย นี้แม้แน, “กอย่าว อางแม่น ปยา ชีม้า กงาชฺ้างอางย่า มาง. ");
INSERT INTO bzi_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","น่า แฮ้ย่า ชฺ้างอางเมิง ย่าง, กอย่าว อางแม่น อือย่า พาจาว มาง อางเมิง เวอ ชฺ้าง อือ, ยาว บู่ก่า อือย่า ซาตานแด่ย่ายอคา มาง ชฺ้าง อือ. ");
INSERT INTO bzi_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ชฺ้าง บู่ก่า ปยา ลา ชีม้า ซาตานแด่ย่ายอคา มาง, ยาว อางญ่าม แย่ญ่าม แฮ้ย่า ชฺ้างอางเมิง อางนืงลีน ย่าง. ยาว ชฺ้าง กอแย่ อือ เท่วาด่า อือย้า เป. ");
INSERT INTO bzi_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“บู่ก่า อือนา ล้อแม้แน แย่ ยาว บี่ท่อ พี แง, อางนืงลีน เมอ แฮ้แม้แนย้า ตอล้า แง. ");
INSERT INTO bzi_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","กงาชฺ้างอางย่า ม้า เท่วาด่า อือนา ซฺาแอ ปี่ ยาว, ชฺ้าง อือนา อางบล่าบ ฮา ปี่ชี่ อือนา แน ชฺ้าง คาโคลาโค บ่าแม่น ฮา ชี อือนา ซฺ้า ช้อน แง, ยาว พาจาว มาง อางเมิง อางเง้ โย้เวอ ก่าอ่อก แอ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ยาว เท่วาด่า อืมมือ ชฺ้าง นี้อือนา บี่ท่อปู่ม อางจ่อ ชฺ้าง ด้า โฮ้กฮ้าว โย้เวอ ฮ้าน วี แอแง. ");
INSERT INTO bzi_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ยาว ชฺ้าง พาจาว มาง นืงบาจาบวา แน ฮายเค่ อือ, ยอง อางโบ้ง มาง อางเมิง โย้เวอ มู่งนื่ง แม้แนย้า แปล้นซ้า คูแง, อ่าซ่าง ก้อง น่าซื่ง จา แง แม่น แน น้า ชี คูปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","พระเยซู จี่ แล่ง เย่ นี้แม้แน, “พาจาว มาง อางเมิง แฮ้ย่า น่าตูง เวอ อางเกิ่งอางก้อ อางฮู่ อางคา โชง ชีอือ แม้แนย้า, ยาว ชฺ้าง ทื่อม่าง ล้า มย้าง ล้า เมอ, ยาง มือ อางอ้าน แม้แน โชง ชี แง. ยาว กย่าง แฮ้ง ปาปาย ยาง อางเกิ่งอางก้อ ค้าจา ย่าง ก่อง ยาว น่าตี แฮ้ง แล วื้อ แล ชี. ");
INSERT INTO bzi_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“แน พาจาว มาง อางเมิง แฮ้ย่า ไข่มุก วื้อฮู อางแม่นอางมาง ซฺ้า กว่า มาง แม้แนย้า. ");
INSERT INTO bzi_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ยาว ไข่มุก อางฮู่ นาบาตา คา ทื่อซื่อ มย้างจ่า ยาว, ยางมือ ยาง อางเกิ่งอางก้อ ค้าจา อือ ก่อง ยาว, ไข่มุก แฮ้ง แล วื้อ แล ชี.” ");
INSERT INTO bzi_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","พระเยซู จี่ แล่ง เย่ นี้แม้แน, “พาจาว มาง อางเมิง แฮ้ย่า ลองอองอางฮื่อ โย้เวอ, ฮอจื้ง จาน ยาว ล่องแต่ ไลเจ้อ แน กงาชี แม้แนย้า. ");
INSERT INTO bzi_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ยาว ฮอจื้ง โย้เวอ ล่องแต่ อ้อง บย่า ยาว, ฮอจื้ง แฮ้ง จากคื้น ล้า ปี่ ยาว ล่องแต่ อางแม่น อือแอ่ แน แช้ยู้ ยาว, ค้าตืง เวอ กาน ยาว ล่องแต่ บ่าแม่น อือนา จาน แอ ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","อางนืงลีน แฮ้นืง มือ แฮ้แม้แน ย้า, เท่วาด่า อือ ชฺ้าง อางแม่น อือ แน ชฺ้าง บ่าแม่น อือนา เจิ่ก กาปี่ง แง. ");
INSERT INTO bzi_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ยาว ชฺ้าง บ่าแม่น อือนา บี่ท่อปู่ม นาบาตา ล้อง ชฺ้าง ด้า โฮ้กฮ้าว คูง โย้ จาน แอ ปี่ แง.” ");
INSERT INTO bzi_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“กงา กูย่างกูเจ้อ จี่ ล้า ปี่ชี่ นี้ย่า นอย่า แบ คายา?” ยาว ยาง ศิษย์ อืมมือ พอ คูง เย นี้แม้แน, “แบ คู คายา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ยาว แฮ้งย้าเย่ พระเยซู มือ ยาง ศิษย์ อือนา นี้แม้แน จี่ช่าง แง, “อางลี้บอางล่าว ม่าอู่บฮู คาโคลาโค พาจาว มาง อางเมิง แฮ้ง กงาแบ คูชี อือย่า, ชฺ้าง ทื่อม่าง ยาง ยู้ม คล้าว โย้เวอ อางเกิ่งอางอ้าน แน อางเกิ่งอางซฺื่อ จา แม้แนย้า. ไม้ ยอ โมเสส อางลี้บอางล่าว แน กงา ม่าอู่บจี่ต่าง อือ ทื่งกง่า แน ม่าอู่บ แง.” ");
INSERT INTO bzi_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ยาว พระเยซู อางเลิ่ง อู่บ เพ้ก น้า ปี่ อือ จี่ เปิน ยาว ยางมือ เจิ่ก แอน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ยาว ยาง ค่อง ค่อล้า ชี โย้เวอ พ่าว แอน ชีเย. ยาว ยิวชฺ้าง อือโบสถ์ โย้เวอ ต่องก่าต่าง ม่าอู่บ ชีเย, ยองมู ย่าง มือ นาบาตา เย นืงบาม่าน คูชี, แน น้า กาง เย, ค่าพ่าย่า นี้ม้า ยา ล้อเกิ้ง วี่ไซป้านญา กงา ชี, แน ล้อเกิ้ง เวอ ล่าที่ กงา ยาว อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ตอ กา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“ยา ล่าไม ซ้าล้า อางย่า มาง อ่าลา? ยาง อางบา มาง อางเม้ง มารีย์, ยาว ยาง อางแพ้ อือย่า ยากอบ โยเซฟ ซีโมน แน ยูดาส ยอง บ่าอ่า ลา? ");
INSERT INTO bzi_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ยาว ยาง อางป่อ คาโคลาโค อืมมือ กงูก้อง เวอ ทื่งกง่า แน ดื้ง อ่าลา? ยาว ยา ล้อเกิ้ง เวอ วี่ไซป้านญา แน ล่าที่ กงา ล้า ชี?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ยอย่า พระเยซู นา บ่าเจ่อ คู เย, จ้า พระเยซู มือ ยองนา จี่ช่าง เย นี้แม้แน, “พาจาวจี่ต่างจี่แต่นฮู อือนา กูตี ย้า ฮาก นาบทื้อ คูแง, จ้า ค่าตอง ค่อง ค่าตอง อางเมิง แน ค่าตอง ยู้มชฺ้าง อือ ยองนา บ่านาบบ่าทื่อ คู แน.” ");
INSERT INTO bzi_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","แฮ้งย้าเย่ พระเยซู มือ เจิ้นเจ้อ อางเลิ่งชฺ้างบ่าฮาตอกางอือ อางบย่า แน บ่ากงาฮา, ไม้ ชฺ้าง แฮ้อือ ย่า ยางนา บ่าเจ่อจ่า คู เย. ");
INSERT INTO bzi_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ก่าซ้าด เฮโรด กาลิลี แควน ฮูพลา มาง พระเยซู อางเลิ่ง ย่าง กงากย่า ยาว. ");
INSERT INTO bzi_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ยาง มือ ยาง ชฺ้างน้าย้าท้ามย้า อือนา จี่ช่าง เย นี้แม้แน, “ยา ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ฮู ซฺี้ ยาว แต่ล้า แล่ชี่ แฮ้มาง ม้าม้า นาตู้. แฮ้งย้า อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา กงา กาแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ไม้ ก่าซ้าด เฮโรด นี้ม้า ยาง ชฺ้าง อือนา ม่า ยอห์น นา ชู คอก ล้อง ปี่ชี่ มาง ย้า. ยาง นี้แม้แน ฮา ชี นี้ย่า, ไม้ ยา เฮโรเดียส นา นืงบาจาบ ปี่ ซี่ แง. เฮโรเดียส ฟีลิป ค่าบา. ฟีลิป ก่าซ้าด เฮโรด อางแพ้. จ้า ก่าซ้าด เฮโรด ค่าตอง อางแพ้ มาง ค่าบา มางนา ยู้ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ยาว ยอห์น ก่าซ้าด เฮโรด นา อางเลิ้ง ย้า นี้แม้แน ม่าอู่บ แง, “อางแพ้ ค่าบา นา ยู้ ค่าตอง ค่าบา เพล่อ ปี่ง นี้ย่า อางซี เป” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","แฮ้งย้าเย่ ก่าซ้าด เฮโรด มือ ยอห์น นา แซ่ ซี่ง แง. จ้า ค่องช่าง อือนา แค เย, ไม้ ค่องช่าง อือย่า ยอห์น นา พาจาวจี่ต่างจี่แต่นฮู แน นาบทื้อ คูง นอ. ");
INSERT INTO bzi_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ยาว ก่าซ้าด เฮโรด เกิ้ดนืง ปอ เมอ เฮโรเดียส อางย่าย่าบี่ มาง มือ, อ่อกลือ ก่าซ้าด เฮโรด แน ยาง ชฺ้าง ม่าย ล้า ปี่ชี่ อือนา เยน ฮู ปี่ชี่ เย, ยาว ก่าซ้าด เฮโรด มือ นาบาตา เย ซอ แง. ");
INSERT INTO bzi_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","แฮ้งย้าเย่ ก่าซ้าด เฮโรด มือ ก่ามค่าน ปี่ชี่ ยาง คาป้า อือย้า ปี่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","แฮ้งเย่ ยาง มือ ยาง อางบา มาง ม่าย ป้า ปี่ชี่ แม้แน ป้า ชี, “ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ ฮู มาง อางตู่ แฮ้ง ต่อน ยาว, ฮ่างเพิ่น เวอ กาน ยาว, กงานา นู้เวอ ฮ้าน ปี่ ล่าว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ก่าซ้าด เฮโรด นาบาตา เย นืงบาชู่ม แง, จ้า บ้าเจอล้อแม้ บ่าฮาตอ กาเย, ไม้ ยา ชฺ้าง ป้า ล้า ปี่ชี่ อือ ล้าก้า เวอ แฮ้แม้แน ก่ามค่าน ปี่ ป้าน่อ, ยาง มือ แฮ้งย้าเย่ เฮโรเดียส มาง อางย่าย่าบี่ มาง ป้า ชี แม้แน ฮาย ชี. ");
INSERT INTO bzi_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ยาว ก่าซ้าด เฮโรด มือ ยาง ย่าเจ่น อือนา ม่า ยอห์น อางตู่ แฮ้ง คอก คล้าว เวอ ต่อน แล ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","แน ยอห์น อางตู่ แฮ้ง ฮ่างเพิ่น เวอ กาน เฮโรเดียส อางย่าย่าบี่ มางนา ปี่ ชี. ยาว เฮโรเดียส อางย่าย่าบี่ แฮ้มาง ยาง อางบา มางนา ฮ้าน ปี่ แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ยาว ยอห์น ศิษย์ อืมมือ ยอห์น อางโต ย่าง ท้ามชฺ้างซฺี้ชีย้า โย้เวอ ฮ้าน ชี แอ ยาว พระเยซู นา อู่บน้า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","พระเยซู ยอห์น อางเลิ่ง ย่าง แบน ยาว. ยาง มือ ยาง ทื่อม่าง แน ตีอางกยาบ โย้เวอ ล้องตา แอน ชีเย. ยาว อางเมิง อือเมอ ค่องช่าง อือ แบน คู ยาว, ยองมือ พระเยซู ก้อง นื้งชฺ่าท่า ป่ากย่า เค่ แอน คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ยาว พระเยซู ล้อง เวอ อ่อกล้า นื้งชฺ่าท่า เวอ เคอ ล้า ยาว, ยาง มือ ชฺ้าง อางอีบ่าอ่า แน ล่อจา นา มย้าง ยาว ซื่งกง่ากย้า เย. ยาว ยาง มือ โย้เวอ ชฺ้างอางด้าอางกย้าง อือนา ยา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","มู่งคี่ล้าก้า เคิน ยาว ศิษย์ อืม พระเยซู นา นี้แม้แน ม่าย ล้า ชี, “อ่าจาน เวอ, นู้ ตี อางกยาบ เจิ้นเจ้อ บ่าจา. แน ชฺ้าง ยู้ม บ่าจา. แน อามือ มู่งคี่ล้าก้า ชา เคิน ญ้า. ยองนา ม่าย พ่าว แอ แล่ ปี่ ปาว. ยองนา นู้เวอ ค่อง อางแท้ อือเมอ ม้างม้าเจ้อ ซฺ้า วื้อ จฺ่า แอ ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","จ้า พระเยซู ม่า ชี นี้แม้แน, “ยองนา เกิ้งเกิ้ง บ่ากงาม่าย แอ ปี่ คา, นู้เวิม ดื้ง ปี่ปาว, นอง มือ ยองนา จฺ่าเกิ่ง ปอ คูปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ยาว ยาง ศิษย์ อืมมือ นี้แม้แน ม่า คูง เย, “กงูก้อง ค้านู้มป่าง 5 ซื่อ แน ล่องแต่ 2 โต ญา จา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ยาว พระเยซู มือ ม่า เย นี้แม้แน, “นู้เวอ ฮาน ล้า ปี่ว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ยาว พระเยซู มือ ค่องช่าง คาโคลาโค อือนา บู่ก่าแต่ เวอ ม่าย ดื้ง ปี่ชี่. ยาว ยาง มือ ค้านู้มป่าง 5 ซื่อ แน ล่องแต่ 2 โต ย่าง ท่าม แล่ยาว, มู่งท่า ป่ากย่า ฮู แล ปี่ ยาว พาจาว มางนา ขอบคุณ ฮา ชีเย, แน ยาง มือ ยาง ศิษย์ อือนา ค้านู้มป่าง ย่าง เปิ่ง ปี่ ชี. ยาว ยาง ศิษย์ อืมมือ ค่องช่าง อือนา เปิ่ง จฺ่า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ยาว ค่องช่าง อืม ก้อ ย้า จฺ่า คูชี, ยาว ศิษย์ อืม ชฺ้าง คาโคลาโค อือ ค้านู้มป่าง, แน ล่องแต่ จฺ่าจาน ย้าง 12 ซ้าล้อง กอกงา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ชฺ้าง โย้เวอ จฺ่าเกิ่งจฺ่า ชีอือ ค่าพ่าย่า แอ่ แน 5,000 คู่น เย, จ้า ค่าบาย่า แน ย่าเก อือนา บ่ากงา ดาบ เย. ");
INSERT INTO bzi_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ยาว พระเยซู มือ ยาง ศิษย์ อือนา ล้อง ม่าย ตา แอออน ฮา ปี่ ชีเย, จ้า ยา ค่องช่าง อือนา ล่อ ซฺา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ค่องช่าง อือ แอ โค คู ยาว พระเยซู มือ, ยาง ทื่อม่าง แน ตาแซ้ ท่า เวอ แล อธิษฐาน ฮา แล ชีเย. มู่งคี่ คี่ เวิม มือ ยา ตาแซ้ ท่า โย้เวอ ยาง ทื่อม่าง ญาเย่. ");
INSERT INTO bzi_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ยาว ล้อง ย่าง แอ เว่อ กาชา เย, จ้า ล้อง แฮ้ อางย่ากอางกาบ แน ปู้ย แอน ชีเย, ไม้ ล้างฮ้าด อางคา แน ฮ้างม้าน อางแล่ง แฮ้ง ปาปาย. ");
INSERT INTO bzi_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ซอทา อางด่า เวอ, พระเยซู มือ ล้างท่า เวอ ย่อ ยาง ศิษย์ อือ ก้อง แอน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ยาว ยาง ศิษย์ อืมมือ ยาง ล้างท่า เวอ ย่อ นา มย้าง ยาว, ยอง มือ แค แล่ คู ยาว จี่ โฮ้กฮ้าว คูง เย นี้แม้แน, “แด่ย่า!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","แฮ้งย้าเย่ พระเยซู มือ ยองนา อางไว่อางคย้าง แน ม่า ชี นี้แม้แน, “บ่าแค คู โจ! กงา เยซู เป! นืงบาแก่น คู โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","แฮ้งย้าเย่ เปโตร มือ จี่ แง นี้แม้แน, “จี่วีดอางซื้ง เวอ, จาว่าแน นาง ม้าม้า แนยาว กงานา ฮ้าว ล้างท่า โย้เวอ ย่อ แอ ปี่ ล่าปาว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","แฮ้งย้าเย่ พระเยซู มือ จี่ แง นี้แม้แน, “ย่อ ลืน ปาว!” แน. ยาว เปโตร มือ ล้อง เวอ อ่อก ล้างท่า เวอ ย่อ พระเยซู นา ซฺ้า แอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","จ้า ฮ้างม้าน อางแล่ง พยาง ลาน ยาว เปโตร มือ แค เย, ยาว ยางมือ ล้าง ชานื่อ แล่ง เย. แฮ้งเย่ ยาง มือ จี่ โฮ้กฮ้าว ลาชี นี้แม้แน, “จี่วีดอางซื้ง เวอ ปล่อง ล่า ปาโน!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","แฮ้งย้าเย่ พระเยซู มือ ยาง อางโต เวอ ซฺ้อก แน ล่าปู่ ย่าง กลาง ชู ยาว จี่ แง นี้แม้แน, “นาง เจ่อ นี้ย่า นาบาตา ยา อี แง, บ้าเจอ กงานา บ่าเจ่อ ล่า แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ยาว พระเยซู แน เปโตร เย่ด ล้อง เวอ ตา ลาน ยาว ฮ้างม้าน ย่าง มือ ว่าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ยาว ล้องตา ชฺ้าง อืมมือ พระเยซู นา บอกไว้ ยาว จี่ คูง เย นี้แม้แน, “อ่าจาน เวอ นาย่า พาจาว มาง อางย่า ม้าม้า ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ยาว ยองมือ เยนเนซาเรท ค่อง ก่องทาง เวอ เคอ ลือ เมอ. ");
INSERT INTO bzi_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","โย้เวอ ค่องช่าง อือ พระเยซู นา อางแบ กงากา, แฮ้งเย่ แควน อางแท้ อือเมอ ต้าว แน ม่าย ชี. ยาว ค่องช่าง อืมมือ ชฺ้าง อางด้า คาโคลาโค อือนา ซฺื่ย พระเยซู นา ซฺ้า ลือ คู ชี. ");
INSERT INTO bzi_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ยาว ชฺ้างอางด้าอางกย้าง อืมมือ พระเยซู นา ป้า คูง เย, ยาง ค่าลาวม่านเงิน โย้ กงาว่า คู เวิม ยอง มือ ยอง พ่าญาด แฮ้ย่า อางโปยว ย้า แน, ยาว ชฺ้าง ยาง ค่าลาวม่านเงิน โย้เวอ กงาว่า คูชี อืมมือ พ่าญาด ย่าง ม้าม้า ย้าเย่ โปยว คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ฟาริสี แน อางลี้บอางล่าว ม่าอู่บฮู อือ, เยรูซาเล็ม อางเมิง เวอ จายลือ พระเยซู นา ซฺ้า ลือ คูชี. ยาว ยองมือ พระเยซู นา น้า คูง เย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“บ้าเจอ นาง ศิษย์ อือย่า ค้าแต้ เวอ จาย อางลี้บอางล่าว ม่าอู่บ กาลือ ชี แฮ้งแม้แน บ่าฮา เค่ คู แน, บ้าเจอ ยอ ฮ่าง ชา จฺ่า เมอ ยอย่า ล่าปู่ บ่าชี่ แล่ คู แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ยาว พระเยซู มือ พอ เย นี้แม้แน, “ท้าว นอ บ้าเจอ พาจาว มาง อางลี้บอางล่าว แฮ้ง วี คูยาว, นอง อางลี้บอางล่าว แต่ง ล้า ชี แฮ้ง อางฮาย เค่ คู แน? ");
INSERT INTO bzi_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ฮูปาว พาจาว นองนา นี้แม้ ม่า ล่าง, ‘ค่าตอง อางบา อางโบ้ง นา นาบทื้อ โว!’ แน ‘ชฺ้าง ค่าตอง อางบา อางโบ้ง นา แซ้งว้าน ชี อือนา แซ่ โว!’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","จ้า นองมู นี้ย่า นี้แม้แน ม่าอู่บ คูแง. ค่าตอง อางบา อางโบ้ง นา นี้แม้แน ม่า นี้ย่า บ่าไล่, ‘อ่าบา อ่าโบ้ง เวอ, กงา อางเกิ่งอางก้อ ไน้นา อางปล่อง ล่า กงากาง อือย่า, พาจาว มางนา ท่าน โค ย้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","นี้แม้แน ฮา นี้ย่า นอ ยองนา ม่าอู่บ อางบา อางโบ้ง นา เจิ้นเจ้อ บ่าปี่ ปล่อง แน ฮา ชี แน ทื่อช่างกานญา. นี้แม้แนยาว นอ พาจาว มาง อางลี้บอางล่าว แฮ้ง วี ยาว, ชฺ้าง อือ ม่าอู่บจี่ต่าง แฮ้ง ฮายเค่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือเวอ, พาจาวจี่ต่างจี่แต่นฮู อิสยาห์ นอง อางเลิ่ง แฮ้ง มอ ยาว, พระคัมภีร์ เวอ แต้ม ชี ชี นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘พาจาว ม้า นี้แม้แน จี่ แง, ชฺ้าง นี้อือย่า กงานา ม่านป่อง แฮ้งญา นาบทื้อ ล่า คูแง จ้า ยอง นืงบา แฮ้ย่า กงานา บ่านาบบ่าทื่อ ล่า. ");
INSERT INTO bzi_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","นี้แม้แนยาว ยอง กงานา สรรเสริญ ฮา ล่าง นี้ย่า เจิ้นเจ้อ จองไจ บ่าจา, ไม้ ยองมู นี้ย่า กงา อางลี้บอางล่าว แฮ้ง บ่าม่าบ่าอู่บ คู, จ้า ชฺ้าง อางลี้บอางล่าว แต่ง ชีอือ ม่าอู่บ คูแง’” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ยาว พระเยซู มือ ชฺ้าง อือนา ฮ้าว ล้า ปี่ ยาว จี่ เย นี้แม้แน, “แม่น แน น้า คูโว! แน แบ ชี คู ปาว. ");
INSERT INTO bzi_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ชฺ้าง อือ จฺ่าเกิ่ง จฺ่า อ้องแล ปี่ชี่ อือย่า เจิ้นเจ้อ บ่าจา ยอง นืงบา แฮ้งนา ฮา โซซา ปี่ชี่ แน. ยอง ม่านป่อง โย้เวอ ม้างม้าเจ้อ จายล้า ชี อืน ญา, ยอง นืงบา แฮ้งนา ฮา โซซา ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ยาว พระเยซู ศิษย์ อืมมือ พระเยซู นา ม่า ล้า ชี นี้แม้แน, “อ่าจาน เวอ, นา อางแบ ล่า นาง แฮ้แม้แน จี่ ชี่แฮ้, ฟาริสี มู อือ นาบาตา ย้า นืงบาค่า คูแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ยาว พระเยซู มือ พอ เย นี้แม้แน, “จฺืงจฺื้ง กูจฺื้ง กงา อางโบ้ง มู่งท่า เวอ ดื้ง มาง บ่ากงา คลา อือย่า, กูป้าง ย้า กื่น วี อางเช้ แฮ้ง มือ บ่าปี่ จ้าน ล้า. ");
INSERT INTO bzi_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","บ่ากงาตี่นบ่ากงาต้อง คูคา ยอ ชฺ้างแมปอ นา แก้บ้า ม่า อือ แม้แน ย้า, จาว่าแน แมปอต่องแมปอ แน แก้บ้า ม่าย ลางกายาว, เย่ด มือ ค่ามตู่ โย้เวอ ซฺื่ยกา กลา แล่ คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ยาว เปโตร มือ จี่ เย นี้แม้แน, “อ่าจาน เวอ นาง อางเลิ่ง จี่เพ้ก แฮ้ง ม่ายแบ ปี่ ล่าว แล” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ยาว พระเยซู มือ จี่ เย นี้แม้แน, “บ้าเจอ อามืม บ่าแบ กาซื้ง ลา? ");
INSERT INTO bzi_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","บ่ามย่าง ล้า กูย่างกูเจ้อ ชฺ้าง อือ จฺ่า อ้องแล ปี่ง อือย่า, ป่องปอง คล้าว เวอ อ้องแล ยาว อือ อ่อก ลือ ปี่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","จ้า ม่านป่อง เวอ จี่ อ่อกลือ ปี่ง อือย่า นืงบา เวอ จายลือ แง, ยาว นี้งย้า พาจาว มาง ชฺ้าง อือนา อางโซอางซา แน ฮู นี้ย่า. ");
INSERT INTO bzi_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ไม้ นืงบา เวอ จาย อ่อก ลือ นี้ย่า อางเลิ่ง บ่าแม่น แน เย้ง อือ แอ่ ย้า, แซ่เตอ กา อางเลิ่ง อือ, จู้จา อางเลิ่ง อือ, ป้องก้า อางเลิ่ง อางซี กูเจ้อ อือ, ค่าวดา อางเลิ่ง อือ, อางเลิ่ง จ้อบ กางอือ, อางไล้จี่กาน กางอือ. ");
INSERT INTO bzi_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","อางเลิ่ง นี้อือย่า ชฺ้าง อือนา ฮาย พาจาว มาง ล้าก้า โย้เวอ โซซา ปี่ง อือย้า. จ้า ฮ่าง ชา จฺ่า เมอ ล่าปู่ บ่ากงาชี่ แฮ้ย่า พาจาว มาง ล้าก้า โย้เวอ บ่าโซบ่าซา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ยาว พระเยซู มือ กาลิลี อางเมิง เวอ จาย อ่อกล้า ยาว, ไทระ อางเมิง แน ไซดอน อางเมิง เวอ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ค่าบาย่า คานาอันชฺ้าง ทื่อม่าง จา เย พระเยซู นา ฮ้าว ป้า เย นี้แม้แน, “จี่วีดอางซื้ง ก่าซ้าด ดาวิด อางอ่านอางซฺื้อ มาง เวอ, กงานา ซื่งกง่ากย้า ล่าปาว, กงา อางย่าย่าบี่ มางนา แด่ย่า อ้อง ปี่ชี่. ยา นาบาตา ย้า ลาบ้าบ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","พระเยซู มือ ยางนา ทื่อก่าม แนมมือ บ่าพอ เย, ยาว พระเยซู ศิษย์ อืมมือ จี่ คูง นี้แม้แน, “ก่า แอ ปี่ปาว โฮ้กฮ้าว กว่า แง เม้อ คาบอล้อ” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ยาว พระเยซู มือ ยางนา พอ ชี นี้แม้แน, “พาจาว มาง กงานา ซฺาลือ ปี่ ล่า ชี่ นี้, อิสราเอลชฺ้าง แกะ แม้แน แก้บ้า ลูง แล่ ชี อือนา ปล่อง ลือ ปี่ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","แฮ้งย้าเย่ ค่าบาย่า แฮ้มาง มือ พระเยซู นา บอกไว้ ชี. ยาว นี้แม้แน จี่ เย, “จี่วีดอางซื้ง มาง เวอ, กงานา ปล่อง ล่าปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ยาว พระเยซู มือ ยางนา นี้แม้แน จี่ช่าง ชี, “กงา ยิวชฺ้าง จ้า นา ยิวชฺ้างบ่าอ่า. ยิวชฺ้าง นี้ ยิวชฺ้างบ่าอ่า อือนา คื่อ อางโซอางซา นา อางตู้ แน จี่ แง. ท้าว กงานา ยิวชฺ้างบ่าอ่า คื่อ แม้แน เพล่อ คูชี อือนา จฺ่าเกิ่ง ปี่, ปี่ ล่าง นี้ย่า อางซูม ลา? ยิวชฺ้าง ย่าเก อือนา ปี่ ออน ฮา แฮ้ง บ่าเช แล่ ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ยาว ค่าบาย่า มาง พอ เย นี้แม้แน, “อางอ้า ย้า, จ้า คื่อ เวิมมือ ยอง อางซื้ง มาง ฮ่างจฺ่า ยาว โต อ่อก โย้เวอ จฺ่าเกิ่ง จฺ่า กลา ชีอือ กงาจฺ่า แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","แฮ้งย้าเย่ พระเยซู มือ พอ ชี นี้แม้แน, “นาง เจ่อ แฮ้ นาบาตา ชีมา บย่า แง, นาง บ้าเจอ ป้า เวิม มือ นาง คาป้า แม้แน เพล่อ ล้า ปาว” แน. ยาว ยาง อางย่าย่าบี่ มางมือ ซฺ้อก ย้า โปยว ชี. ");
INSERT INTO bzi_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ยาว พระเยซู โย้เวอ อ่อกล้า ยาว ยาง มือ ลองอองอางฮื่อ อางเม้ง กาลิลี ก่องทาง โย้เวอ ย่อ แล ชีเย, ยาว ตาแซ้ ท่า เวอ แล ดื้ง แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ค่องช่าง อางอีบ่าอ่า เย พระเยซู นา ซฺ้า ล้า ชี. ยอย่า ชฺ้าง ล่าปู่ ล่าคื่อ บ่าแม่น อือ, ชฺ้างแมปอ, ชฺ้างบ่าจี่ตอ กางอือ แน ชฺ้าง กาบ่ากาเจ้อ พ่าญาด เพล่อ ชีอือ นา ซฺื่ยล้า คูชี. ยาว พระเยซู ล่าคื่อ โย้เวอ แท้ แน ซฺื่ย ชี ล้า ชี. ยาว พระเยซู มือ ชฺ้าง คาโคลาโค อือนา ยา โปยว ชี. ");
INSERT INTO bzi_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ยาว ชฺ้าง อืมมือ นืงบาม่าน คู ชีเย, ชฺ้างบ่าจี่ตอ กาง อืมมือ จี่ตอ กาชี, ชฺ้าง อางด้าอางกย้าง อืมมือ โปยว คู ชี, ชฺ้าง ล่าปู่ ล่าคื่อ บ่าแม่น อืมมือ ย่อตอ กาชี, แน ชฺ้างแมปอ อืมมือ ฮูมย้าง กาชี. ยาว ยอง มือ อิสราเอลชฺ้าง อือ พาจาว มางนา สรรเสริญ ฮา คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ยาว พระเยซู มือ ยาง ศิษย์ อือนา ฮ้าว ล้า ปี่ ยาว จี่ช่าง เย นี้แม้แน, “กงา ชฺ้าง นี้อือนา ซื่งกง่ากย้า เค, ยอย่า กงู ก้องดื้ง ล้า 3 นืง เคิน ญา, ยองนา อางแบ่อางซฺู่ แน บ่าแอ ปี่ ซี่, อ่าซ่า แก้บ้า อือเมอ ปางปี ฮาน นา วาม ค่า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ยาว ยาง ศิษย์ อืมมือ จี่ เย นี้แม้แน, “ซ่องก่องอางเว่อ นู้เวอ ชฺ้างอางบย่า นี้อือนา ล้อแม้แน จฺ่าเกิ่ง ซฺ้า ปอ กงา กาแน?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","แฮ้งเย่ พระเยซู มือ นี้แม้แน น้า ชี, “นองก้อง ค้านู้มป่าง อ้าล่อ ซื่อ จา แง?” แน. ยาว ยาง ศิษย์ อืมมือ พอ คูง เย 7 ซื่อ จา แง แนยาว ล่องแต่ อางอี 2-3 โต จา แง. ");
INSERT INTO bzi_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","แฮ้งย้าเย่ พระเยซู มือ ค่องช่าง อือนา ม่า นื้งชฺ่าท่า เวอ ดื้ง ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ยาว ยาง มือ ค้านู้มป่าง 7 ซื่อ แฮ้ง แน ล่องแต่ ย่าง ท่าม แล่ยาว, พาจาว มางนา ขอบคุณ ฮา ยาว ค้านู้มป่าง แฮ้ง ชีด ชี. ยาว ศิษย์ อือนา ปี่ ค่องช่าง อือนา เปิ่ง ปี่ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ค่องช่าง อืม ก้อ ย้า กงาจฺ่า คูชี. แน ศิษย์ อืม จฺ่าเกิ่ง จ้านล้าชี แฮ้ง 7 ซ้าล้อง ปลื้ง ย้า กอ กงา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","จฺ่าเกิ่ง ดื้ง จฺ่า ชี นี้ย่า ค่าพ่าย่า แอ่ แน ดาบ ชีแฮ้ 4,000 คู่น เย, นี้ย่า ค่าบาย่า แน ย่าเก อือนา คาตา แน บ่ากงา ดาบ เย. ");
INSERT INTO bzi_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","พระเยซู ชฺ้าง อือนา ซฺาแอ ปี่ โค ยาว, ยาง มือ มากาดาน อางเมิง เวอ ล้องตา แอน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ฟาริสี แน สะดูสี อือ พระเยซู นา นืงบาเจ้อ อางเลิ่งชฺ้างบ่าฮาตอกางอือ ม่า ฮายฮู ปี่ ชีเย, ไม้ ยอ พระเยซู นา นืงบาเจ้อ คู แง, ยา พาจาว มาง ก้อง ม้าม้า ล่า จายลือ แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","จ้า พระเยซู มือ พอ เย นี้แม้แน, “มู่งคี่ล้าก้า เวอ มู่ง แฮ้ง เซฺิ่งซฺ้าง แน มย้าง เมอ, นอย่า จี่ กางแง นี้เซฺ้อ ย่า นื้งช้า ช่อ แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","จ้า ซอทา เวอ มู่ง แฮ้ง มู่งบู่ดบู่ด เมอ, นอง มือ ฮา คูง แง มี้นืง ย่า มู่งฮ่อ ชา ลือ แงแน. นอง มู่ง แฮ้งนา มย้าง เมอ นอ อางแบ คู มู่งฮ่อ ลือ ล่า นื้งช้า ช่อ แงแน. จ้า นอ กงา อางเลิ่ง ฮา ชี อือนา มย้าง เมอ, นอ ย่า บ้าเจอ ตอล้า ชี แน บ่าแบ คู. ");
INSERT INTO bzi_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ชฺ้าง บ่าแม่น แน ชฺ้าง จู้จา อือย่า, ชฺ้าง อางเลิ่งชฺ้างบ่าฮาตอกางอือ ม่าย ฮา ปี่ง อือย้า. จ้า กงา บ่าฮายฮู ปี่ ล่า เป. พาจาวจี่ต่างจี่แต่นฮู โยนาห์ ก้อง อางเลิ่ง ตอล้า ชี แฮ้งญา ฮายฮู ปี่ ล่าง.” ยาว พระเยซู มือ เจิ่ก แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ยอง ลองอองอางฮื่อ ทื่อปล่าก ป่ากย่า แอ เมอ ศิษย์ อืม ค้านู้มป่าง ย่าง ลู้ม คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ยาว พระเยซู มือ ยองนา ม่า เย นี้แม้แน, “ฟาริสี แน สะดูสี อือ อางเจ้อ แฮ้งนา แล่ม แล่ คู โว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","แฮ้งย้า ศิษย์ อืม นี้แม้แน จี่ ลางกา ชี, “อ่าจาน มาง นี้แม้แน จี่ นี้ย่า, กงู ค้านู้มป่าง ลู้ม ชี ช่าชี่ แฮ้ง ปาปาย นาตู้” แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","พระเยซู อางแบ เย ยอ บ้าเจอ อางเลิ่ง จี่ กางแง แน แฮ้ง ย้า จี่ ชี นี้แม้แน, “บ้าเจอฮาย ค้านู้มป่าง บ่าจา แฮ้งนา จี่ กางแง, นอง เจ่อ นี้ย่า นาบาตา ย้า อี แง. ");
INSERT INTO bzi_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","นอ อามืม บ่าแบ คู ล่า, นอย่า ลู้ม คู แอ ล่า กงา ล้อแม้แน ฮา ชี แน, ค้านู้มป่าง 5 ซื่อ ชฺ้าง 5,000 คู่น นา ปอ ชี แฮ้, นอย่า จ้านล้า ชีแฮ้ อาล้อ ซ้าล้อง แน กอกงา คู แอ แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","แน กงา ค้านู้มป่าง 7 ซื่อ จา เมอ ชฺ้าง 4,000 คู่น อือนา ปอ เมอ, นอ จ้านล้าชี แฮ้ย่า อาล้อ ซ้าล้อง กอกงา แอ แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","บ้าเจอ นอย่า บ่าแบ คู แน กงาย่า ค้านู้มป่าง อางเลิ่ง แฮ้งนา บ่ากงา จี่เคอ แน. จ้า กงาย่า ฟาริสี แน สะดูสี อือ อางเจ้อ แฮ้ง ม่าย แล่ม ปี่ ล่าง เป” แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ยาว พระเยซู ศิษย์ อืมมือ แบ คู ชีเย, พระเยซู ยา ค้านู้มป่าง อางเจ้อ กาน แฮ้งนา บ่ากงา จี่เคอ แน, จ้า ฟาริสี แน สะดูสี อือ จี่ต่าง ม่าอู่บ แฮ้งนา ม่า แล่ม แล่ ปี่ง แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","พระเยซู ซีซารียาฟีลิปปี อางเมิง เวอ เคิน ลือ ยาว, พระเยซู มือ ยาง ศิษย์ อือนา น้า เย นี้แม้แน, “ฮาก กงาชฺ้างอางย่า มางนา อ่าซ่าง แน จี่ เคอ กางแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ยาว ยาง ศิษย์ อืมม่า คูง เย นี้แม้แน, “ทื่อบ่า อือย่า ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ฮู มาง แน, ยาว ทื่อบ่า พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ แน ฮา มาง, ยาว ทื่อบ่า พาจาวจี่ต่างจี่แต่นฮู เยเรมีย์ แน ฮา แง, บ่าอ่า เวิม มือ พาจาวจี่ต่างจี่แต่นฮู มู โย้เวอ ทื่อม่าง มางย้า แน ฮา กาแง.” ");
INSERT INTO bzi_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","แฮ้งย้าเย่ พระเยซู มือ ยาง ศิษย์ อือนา น้า แง นี้แม้แน, “นอง เย้ง กานยาว กงา อ่าซ่าง เวอ” แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ซีโมนเปโตร มาง ฮา เย, “นาย่า พาจาว มาง แช้ยู้ ก่าซ้าด อางฮื่อ เพล่อ ปี่ชี่ แฮ้มาง ย้า. แน นาย่า พาจาว ซฺี้นืง บ่าจา มาง อางย่า มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ยาว พระเยซู มือ พอ เย นี้แม้แน, “ซีโมน โยนาห์ อางย่า มาง เวอ, นี้เลิ่ง นา ม้าม้า ย้า ก่ามป่อน กงาบู้ แง. กงา อ่าโบ้ง มู่งท่า ดื้ง มาง ม่าแบ ปี่ ล่าแง. ชฺ้าง อือ ม่ายแบ ปี่ ล่าง บ่าอ่า. ");
INSERT INTO bzi_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","กงา อางเลิ่ง ม้าม้า แฮ้ง ม่ายแบ ปี่ ล่าว่า, เปโตร เวอ นาง อางเม้ง นี้ย่า ลอบา นา ฮา แง, นี้แม้แนยาว กงาย่า ลอบาซื่อท่า นี้ซื่อ ก้องเวอ กงา โบสถ์ แฮ้ง แต่ง แน. ยาว ซฺี้ อางเลิ่ง เวอ ล่าที่ แฮ้ย่า กงา โบสถ์ นี้งนา บ่าก่าจ่า กงากา. ");
INSERT INTO bzi_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","กงาย่า พาจาว มาง อางเมิง กูนแจ แฮ้ง นางนา ปี่ ล่า แน. ชฺ้างอางเมิง นู้เวอ กูย่างกูเจ้อ นอง บ่าปี่ ฮา อือย่า มู่งท่า พาจาว มาง มือ บ่าปี่ ฮา, แน ทื่อช่างกานญา กูย่างกูเจ้อ นอง ชฺ้างอางเมิง นู้ ฮา ปี่ อางกงา อือย่า, พาจาว มาง มู่งท่า โย้เวอ อางปี้ ฮา กงากา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ยาว พระเยซู มือ ยาง ศิษย์ อือนา ม่า ชี. ยา พาจาว มาง แช้ ก่าซ้าด เพล่อ ปี่ ชี่ มาง แน ฮากนา บ่าม่า โจ แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","โย้ จายล้า แล่ ยาว พระเยซู มือ ยาง ศิษย์ อือนา ม่า ชีเย, ยา เยรูซาเล็ม อางเมิง เวอ กงา แอ แง. แน ยิวชฺ้าง ยอคา, ปุโรหิต ยอคา แน อางลี้บอางล่าว ม่าอู่บฮู อือ ยางนา ไลเจ้อ ย้า ฮาย ลาบ้าบ ปี่ ยาว แซ่ แง. จ้า 3 นืง เคิน ยาว ยา แต่ล้า แล่ง. ");
INSERT INTO bzi_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","เปโตร พระเยซู นา แท้ แน จาก ล้า ปี่ ยาว พระเยซู นา อี่ เย นี้แม้แน, “โอ้! จี่วีดอางซื้ง มาง เวอ, นางก้อง นี้แม้แน บ่าตอล้า กงากา!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ยาว พระเยซู มือ เปโตร นา พลาบ จี่ช่าง ชี นี้แม้แน, “ซาตานแด่ย่ายอคา แม้แน บ่าจี่ โจ! นาย่า กงานา เกิ้ด ชี ล่าแง, ไม้ นา พาจาว มาง เย้ง แฮ้งแม้แน บ่ากงาเย้ง, จ้า ชฺ้าง เย้ง แฮ้งแม้แน เย้ง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ยาว พระเยซู มือ ยาง ศิษย์ อือนา จี่ช่าง เย นี้แม้แน, “อ่าซ่าง กงานา เค่ ล่าซี่ง แง, ค่าตอง นืงบาวา แน ฮา แฮ้ง ว่าง ยาว ค่าตอง ไม้กางเขน แฮ้ง ป่า แล่ยาว กงาก้อง เค่ ลาน โว! ");
INSERT INTO bzi_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ไม้ ชฺ้าง ค่าตอง จี่วีด แฮ้งนา กงานา ล่อบ่าปา แน ลาก อือ กงาซฺี้ แง. จ้า อ่าซ่าง กงานา เจ่อ ล่า ปาปาย ซฺี้ แง, ชฺ้าง แฮ้ม้า จี่วีดม้าม้า กงา จา แล แง. ");
INSERT INTO bzi_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","จาว่าแน ชฺ้างอางเมิง นู้เวอ กูย่างกูเจ้อ จา ชีอือ อางซื้ง กงาเพล่อ ยาว, จี่วีดม้าม้า บ่าจา ยาว บ้าเจอ จองไจ จา แง? ไม้ จี่วีดม้าม้า นี้ย่า เจิ้นเจ้อ บ่าไคล่ ยู้ กงากา. ");
INSERT INTO bzi_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ไม้ กงาชฺ้างอางย่า ม้า อ่าโบ้งพาจาว ล่าที่ แฮ้ง จา แง แน เท่วาด่า อือก้อง ทื่งกง่า แน ลือ แง, ยาว กงาชฺ้างอางย่า นี้ม้า ชฺ้าง อือนา ต้าดต่อน ลือ แง ยอง ฮา ชีแฮ้ง วา แน. ");
INSERT INTO bzi_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า, นองมู นู้เวอ ทื่อบ่า จูง จา อือย่า, ยอ กงาชฺ้างอางย่า มาง ก่าซ้าด เพล่อ ลือ แฮ้งนา บ่ากงามย้าง เปิน ยอ บ่าซฺี่ คู” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ยาว 6 นืง จายล้า แล่ยาว, พระเยซู เปโตร ยากอบ แน ยอห์น ยากอบ อางแพ้ มาง ซฺื่ยกา ตาแซ้ อางมอง เวอ แลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ยาว พระเยซู อางโต ย่าง มือ ยอง ล้าก้า เวอ เพ่น ล้า ชีเย, ยาง แมก่า แฮ้ย่า มู่งนื่ง ช้อด ย้า แปล้น ล้า ชี, ยาว ยาง อางก่าอางตูม อืมมือ ป่อนล่อนช่อน แน แปล้น บล่าบบล่าบ ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ยาว ยองมู แฮ้ง โมเสส แน เอลียาห์ พาจาวจี่ต่างจี่แต่นฮู มางเย่ด พระเยซู นา จี่ช่าง นา มย้าง ชี. ");
INSERT INTO bzi_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ยาว เปโตร มือ พระเยซู นา จี่ช่าง ชี นี้แม้แน, “จี่วีดอางซื้ง มาง เวอ, นาบาตา ย้า แม่น แง กงู นู้เวอ กงา ล้า ชี นี้ย่า, จาว่าแน นาง ซ่าวย่า กงา ซี้ง แง แนยาว, กงาย่า 3 ลาง ชฺอ ปี่ ล่าว่า, นางนา ทื่อลาง, โมเสส นา ทื่อลาง ยาว เอลียาห์ นา ทื่อลาง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","เปโตร จี่ จา เมอ มู่งบื่น แปล้นซ้า ย้า ยองนา โปก โค ชี. ยาว มู่งบื่น โย้เวอ อางเซง จี่ ลือ ปี่ง นี้แม้แน, “นี้ม้าย่า กงา อางย่า ลาก มาง กงาย่า ยางนา นาบาตา ย้า นืงบาจาบ แง, ยางนา น้าจ่า คู โว เป” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","พระเยซู ศิษย์ อือ กงากย่า คู ยาว ยองมือ นาบาตา เย แค แล่ คูชี, อางไว่อางคย้าง เย นื้งชฺ่า เวอ ป่าตูคู แมก่า บอก คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","จ้า พระเยซู ย่อ ลือ ยาว ยอง อางโต เวอ ว่า ยาว จี่ เย นี้แม้แน, “ทานล้า ปาว บ่ากงา แค คา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","จ้า ยอง แมก่า แงน ล้า ปี่ ยาว, ยอง มือ พระเยซู นา ทื่อม่าง ญา มย้าง คูชี อ่าซ่าง มาง บ่าจา เย. ");
INSERT INTO bzi_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ยาว ยองมู แฮ้ง ซฺื่ยกา ตาแซ้ โย้เวอ ย่อ ลู่งแอ แล่เมอ, พระเยซู มือ ยองนา นี้แม้แน ม่า ชี, “นอง อางเลิ่ง กงามย้าง ชี นี้ง, กงาชฺ้างอางย่า เพล่อ ชี นี้มาง ซฺี้ ยาว แต่ล้า แล่ เมอ ฮากนา อู่บน้า ปี่ โว! จ้า อามือ อ่าซ่าง มางนา บ่าอู่บน้า ปี่ แคน โจ!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ยาว พระเยซู ศิษย์ อืมมือ พระเยซู นา น้า คูง เย นี้แม้แน, “บ้าเจอ อางลี้บอางล่าว ม่าอู่บฮู อือย่า อางจี่ คู แน, พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ ม้า พาจาว มาง แช้ยู้ ก่าซ้าด เพล่อ ปี่ชี่ มาง ฮู่ เวอ ลือออน ฮา แงแน” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","พระเยซู มือ นี้แม้แน พอ ชี, “อางกง่า ย้า, เอลียาห์ ก่าซ้าด แฮ้มาง ฮู่ เวอ ลือออน ลือ แง, ไม้ ยา กูย่างกูเจ้อ กงาซฺ้า ชี ลางออน ฮา แง. ");
INSERT INTO bzi_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","จ้า กงา ม่ายแบ ปี่ ล่าว่า เอลียาห์ ลือ ญา, จ้า ยอ บ่าแบ คู เอลียาห์ แน, แฮ้งย้า ยอง มือ เอลียาห์ นา ยอง นืงบาจาบวา แน ฮา คู ชี, แน ยองมู นี้ย่า กงาชฺ้างอางย่า มางนา ฮาย ลาบ้าบ ปี่ แง เอลียาห์ นา ฮา ชี แม้แนย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","แฮ้งเย่ ศิษย์ อืมมือ แบ คูชี. พระเยซู ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ฮู มางนา จี่ เคอ แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","พระเยซู แน ยาง ศิษย์ อือ ชฺ้าง อางมู จา โย้เวอ เคอ ลือ ยาว, ค่าพ่าย่า ทื่อม่าง จา เย พระเยซู ล้าก้า เวอ บอกไว้ ลือ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ยาว ยาง มือ พระเยซู นา จี่ช่าง เย นี้แม้แน, “จี่วีดอางซื้ง เวอ, กงา อางย่า ค่าพ่าย่า มางนา ซื่งกง่ากย้า ล่าปาว, ยา มามู เพล่อ นาบาตา ย้า ลาบ้าบ แง, ยา บี่ท่อ แน ล้าง เวอ อางเลิ้ง ย้า กลา แล่แง. ");
INSERT INTO bzi_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","กงาย่า ยางนา นาง ศิษย์ อือก้อง เวอ ซฺื่ย ยา ล้าแอ, จ้า ยอง มือ บ่ายา กงากา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “ชฺ้าง บ่าเจ่อ อือ เวอ, กงา นองก้อง อางมล่าง ล่า กงาดื้ง แล แล่แง? กงา นองนา อางมล่าง ล่า กงาโอ้ด แล แล่ ล่าแง? ย่าเก แฮ้มางนา กงาก้อง ซฺื่ย ลาน ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ยาว พระเยซู มือ แด่ย่า มางนา ม่า อ่อกแอ ปี่ชี่ เย, ยาว ย่าเก มาง มือ ซฺ้อก ย้าโปยว ชี. ");
INSERT INTO bzi_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ยาว ยาง ศิษย์ อืมมือ ยอง แอ่ แน พระเยซู ก้อง อ้อง ล้า ยาว น้า เย นี้แม้แน, “บ้าเจอ กงูย่า แด่ย่า แฮ้มางนา บ่าก่า อ่อก กงา กาแน?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ยาว พระเยซู มือ ยองนา ม่า ชี นี้แม้แน, “ไม้ นอง เจ่อ นี้ย่า อางอี, กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า, จาว่าแน นอง เจ่อ แฮ้ย่า ม่าต่าโก้บ นือ ล่อ แน เจ่อ เวิมมือ, นอย่า นู้เวอ ตาแซ้ นี้ง ม่า โย้เวอ แอ ปี่ เวิม อางกงา ยาว ตาแซ้ มาง มือ นอง ม่า แม้แนย้า ฮายเค่ แง. ยาว ทื่อเจ่อ แนม บ่าจา นอง บ่าฮาตอ กาแน” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ยาว ยอง กาลิลี อางเมิง เวอ ล้า ช้อน กาเมอ พระเยซู มือ ยองนา ม่า เย นี้แม้แน, “ชฺ้าง กงานา บ่าแม่น ฮา ล่าง ม้า, ยา กงาชฺ้างอางย่า เพล่อ ชี นี้ มางนา ชฺ้าง กงานา แซ่ ล่าง อือ ก้อง ซฺาแอ ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","แน กงา ซฺี้ ยาว วันที่ 3 แฮ้นืง แต่ล้า แล่แง” แน. แฮ้ง ย้า ยาง ศิษย์ อือ นาบาตา แน นืงบาต่อง เวอ บ่าม่อนบ่าซ่า คู. ");
INSERT INTO bzi_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","พระเยซู แน ยาง ศิษย์ อือ คาเปอรนาอุม อางเมิง เวอ เคอ ลือ เมอ, ชฺ้าง โบสถ์อางฮื่อ โย้เวอ ภาษี กอ มาง เปโตร นา น้า เย นี้แม้แน, “นาง อ่าจาน ม้าย่า ภาษี บ่าตอ ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ยาว เปโตร มือ พอ เย นี้แม้แน, “อางตอ ย้า” แน. ยาว เปโตร พระเยซู นา ยู้ม คล้าว โย้เวอ อ้อง ซฺ้า แล เมอ, พระเยซู มือ จี่ ลางออน ฮา เย นี้แม้แน, “เปโตร เวอ, นา ล้อแม้แน เย้ง แง, ชฺ้างอางเมิง นู้เวอ ก่าซ้าด อือย่า ค่าตอง ชฺ้าง อือก้อง ภาษี อางก้อ ล่า อ้าว ฮากก้อง กอ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ยาว เปโตร มือ พอ เย นี้แม้แน, “ฮากก้อง กอ แง” แน. ยาว แฮ้งย้า พระเยซู มือ จี่ แง นี้แม้แน, “แฮ้แม้แนยาว ยางชฺ้าง อืมมือ ภาษี บ่ากงา ตอ ลา? ");
INSERT INTO bzi_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","นี้แม้แนยาว ชฺ้าง ภาษีกอฮู มางนา นืงบา บ่าปี่ ค่า ยาว, นาง มือ ลองอองอางฮื่อ โย้เวอ ยาง จาน แอ โว, อางด่า โย้เวอ ล่องแต่ ทื่อโต กงา ยาว ล่องแต่ มาง ม่านป่อง แฮ้ง อ่า ฮู โว, ยาว นา พลู้ ทื่อเหรียญ นา มย้าง แง, ยาว พลู้ แฮ้ง ไกง้ ภาษีฮู่ แฮ้ง ฮ้าน ตอ แลโว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","แฮ้ญ่าม เวอ พระเยซู ศิษย์ อืมมือ พระเยซู นา น้า ล้า คูง เย นี้แม้แน, “พาจาว มาง อางเมิง โย้เวอ อ่าซ่าง ฮื่อ เลิ่นเลิ่น แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","แฮ้งย้าเย่ พระเยซู มือ ย่าเก อางอี ทื่อม่าง ยาง ศิษย์ อือ ล้าก้า โย้เวอ ฮ้าว จูง ล้า ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ยาว พระเยซู มือ ยาง ศิษย์ อือนา ม่า เย นี้แม้แน, “กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า, จาว่าแน นอง นืงบา แฮ้ง ย่าเก อางอี นี้มาง แม้แน บ่าเพ่น คูยาว, นอย่า พาจาวอางเมิง โย้เวอ บ่ากงา อ้องแล. ");
INSERT INTO bzi_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","แฮ้แม้แนยาว อ่าซ่าง ย่าเก อางอี นี้มาง แม้แน บ่าฮื่อจ่าแล่ แน เพล่อ ยาว, ชฺ้าง แฮ้ม้าย่า พาจาว มาง อางเมิง โย้เวอ อางฮื่อ เลิ่นเลิ่น มาง ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“อ่าซ่าง กงานา ฮูจ่าล่าปาปาย ย่าเก อือนา แม่นช่าง แง, ชฺ้าง แฮ้มาง มือ กงานา แม่นช่าง ล่า ชี แน ทื่อช่างกานญา. ");
INSERT INTO bzi_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","อ่าซ่าง ย่าเก อางอี กงานา เจ่อ ล่าชี่ นี้อือนา จ้อบ อางบล่าบ ฮา ปี่ แง. ชฺ้าง แฮ้ม้า วี่บ่ากกงาไจ แง. แน ยางนา วี่บ่ากกงาไจ นี้ย่า นาบาตา ย้า ตูกพานลาบ้าบ แง. นี้แม้แนยาว ลอบา อางฮื่อ แฮ้ง ยาง นื้งชฺือ โย้เวอ ล่าตื่อ พือ แป่น ยาว, ทะเล โย้เวอ ต่าน คลา แอ ปี่ง แฮ้งย้า เช แล่แง. ");
INSERT INTO bzi_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“ชฺ้าง นี้ย่า ซื่งกง่ากย้า คาบอล้อ ย้า, ไม้ ชฺ้างอางเมิง นู้เวอ ม้างม้าเจ้อ อางบย่า จา แง ยองนา จ้อบ อางบล่าบ ฮา ปี่ง แน. จ้า พาจาว ม้า ชฺ้าง ฮากนา จ้อบ อางบล่าบ ฮา ปี่ง มางนา อางซี ต้าดต่อน วี่บ่ากไจ ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","นี้แม้แนยาว จาว่าแน นอง ล่าปู่ บ่าอ่าเวิม นอง ล่าคื่อ แฮ้ง นองนา อางบล่าบ ฮาย ปี่ ล่า ยาว ต่อน วี แล่ว, ไม้ ล่าปู่ แน ล่าคื่อ บ่าจา ยาว จี่วีดม้าม้า จา แล นี้ย่า ล่าปู่ แน ล่าคื่อ 2 เบิง จา ยาว ล่าลูก บี่ท่อ ซฺู่ นืง บ่าจา โย้เวอ กลา แอ แฮ้ง ล่อบ่าปา เช แล่ง. ");
INSERT INTO bzi_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","จาว่าแน นอง แมนือ ทื่อซื่อ มาง นองนา ฮาย อางบล่าบ ฮา ปี่ ล่ายาว, แมนือ แฮ้ซื่อ โค่ง วี โว! ไม้ แมนือ ทื่อซื่อ จ้าน ล้า ยาว จี่วีดม้าม้า จา นี้ย่า, แมนือ 2 ซื่อ จา ยาว ล่าลูกบี่ท่อ เวอ กลา แอ แฮ้ง ล่อบ่าปา เช แล่แง.” ");
INSERT INTO bzi_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","พระเยซู จี่ แล่ง นี้แม้แน, “แม่น แน อางโต แล่มแล่ คู โว, กงา ชฺ้าง ย่าเก แม้แน เจ่อ อือนา ทื่อม่าง นา แนมมือ บ่าฮูย้า คู โจ, กงา ม่ายแบ ปี่ ล่าว่า ยองมู นี้ย่า ค่าตอง อางโต เวอ เท่วาด่า ฮูพลาฮู จา แง, เท่วาด่า แฮ้อือย่า มู่งท่า โย้เวอ กงา อางโบ้ง มาง ล้าก้า โย้เวอ กูญ่าม ย้า จา แง.” ");
INSERT INTO bzi_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“นอย่า นี้เลิ่ง นา ล้อแม้ เย้ง คูแง? จาว่าแน ชฺ้าง ทื่อม่าง มางก้อง แกะ 100 โต จา แง, จ้า ทื่อโต โปยว กา ชี. นี้แม้แน ยาว ยาง แกะ 99 โต อือนา ตาแซ้ โย้เวอ ชีช่ายาว แกะ ทื่อโต มางนา มย้าง แอ เคอ แน บ่าซฺ่า กว่า แอ ลา? ");
INSERT INTO bzi_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า, ยาง แกะ ทื่อโต โปยว ชี มางนา กงายคื่น แล่ ชี แฮ้ย่า, แกะ 99 โต บ่าโปยว แฮ้ง ล่อบ่าปา เป กย่าง แง. ");
INSERT INTO bzi_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","นอง อางโบ้ง มู่งท่า ดื้ง มาง ทื่อช่างกานญา, ยา กงา ชฺ้าง ย่าเก แม้แน เจ่อ อือนา ทื่อม่าง นา แนมมือ บ่าปี่ โปยว ซี้ง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","พระเยซู จี่ แล่ง นี้แม้แน, “จาว่าแน ชฺ้าง กงานา เจ่อ ล่าง มาง นางนา อางบล่าบ ฮา ล่ายาว, นาง มือ ยาง อางซี ฮา ชี แฮ้ง กย้าบ แน ยางนา ม่ายแบ แล่ ปี่ โว, จาว่าแน ยาง นางนา อางน้า ล่ายาว, ไน้ มือ แม่น กาแล่ง. ");
INSERT INTO bzi_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","จ้า จาว่าแน ยาง นางนา บ่าน่า ล่ายาว, นางมือ ชฺ้าง ทื่อม่าง บ่าอ่าเวิมมือ 2 คู่น ยางก้อง ซฺื่ยแล โว, ไม้ ชฺ้าง 2-3 คู่น นี้อือนา แบ ปี่ ยาว พี่ญ่าน เพล่อ ปี่ง นอ. ");
INSERT INTO bzi_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","จาว่าแน นี้แม้ ฮา ยาว ยางมือ บ่าน่า ล่ายาว, นาง มือโบสถ์ คล้าว โย้เวอ ชฺ้าง กงานา เจ่อ ล่าง อือนา ม่า แล โว, ยาว จาว่าแน ยาง ชฺ้าง กงานา เจ่อ ล่าง อือนา บ่าน่าจ่า ยาว, ยางนา ชฺ้าง กงานา บ่าเจ่อ ล่าง อือ แน ภาษีกอฮู อือนา ฮา แม้แน ฮาย กาน กาโน. ");
INSERT INTO bzi_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า นี้แม้แน, ชฺ้างอางเมิง นู้เวอ กูย่างกูเจ้อ นอง บ่าปี่ ฮา อือย่า มู่งท่า พาจาว มาง มือ บ่าปี่ ฮา, แน ทื่อช่างกานญา กูย่างกูเจ้อ นอง ชฺ้างอางเมิง นู้ ฮา ปี่ อางกงา อือย่า, พาจาว มาง มู่งท่า โย้เวอ อางฮา ปี่ กงากา. ");
INSERT INTO bzi_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า, จาว่าแน ชฺ้าง 2 คู่น กงานา เจ่อ ล่าง มาง เย่ด, พาจาว กงา อางโบ้ง มู่งท่า ดื้ง มางนา ทื่อเจอ กาแน ป้า ยาว, พาจาว มู่งท่า ดื้ง มาง อางปี่ ล่าย้า, ");
INSERT INTO bzi_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ไม้ ล้อเกิ้ง เวอ กงา ชฺ้าง อือ 2-3 คู่น ล้า ช้อน ลางกา แง, กงา ยอง ก้อง ทื่งกง่า แน ดื้ง แง.” ");
INSERT INTO bzi_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","เปโตร มือ พระเยซู นา น้า ลา ชี นี้แม้แน, “จี่วีดอางซื้ง มาง เวอ, จาว่าแน ฮาก กงานา อางบล่าบ ฮา ล่ายาว, กงา ยางนา อางซี บ่ายู่ แน อ้าล้อเทอ ซูม แง? 7 เทอ นี้ย่า อางซูม ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","แฮ้งเย่ พระเยซู มือ พอ แง นี้แม้แน, “7 เทอ บ่าอ่า จ้า 77 เทอ เป.” ");
INSERT INTO bzi_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“นี้แม้ ปาปาย ย้า, พาจาว มาง อางเมิง แฮ้ย่า เพ้ก ลื่อยาว, ก่าซ้าด ทื่อม่าง ยาง ย่าเจ่น อางชี่ ตีด แล่ ชี อือนา อางชี่ โค ปี่ ซี่ แฮ้งแม้แน ย้าเป, ");
INSERT INTO bzi_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ปาบ โย้เวอ อางชี่ กื้ด เมอ, ย่าเจ่น ก่าซ้าด มางก้อง อางชี่ 50,000,000 เหรียญ ตีด แล่ ชี่ มางนา ซฺื่ย อ้องล้า แง. ");
INSERT INTO bzi_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","จ้า ย่าเจ่น มางมือ พลู้ อางชี่ ไซ้ เซฺ่อ บ่าจา เย, แฮ้งย้า ก่าซ้าด มางมือ ยาง อางโต แฮ้ง, อางเกิ่งอางก้อ แน ตื่น ยาง อางบี่อางย่า ค้าจา อือนา ก่อง ยาว, พลู้ แฮ้ง อางชี่ ยู้ แงแน ม่า ชี.” ");
INSERT INTO bzi_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“ย่าเจ่น มางมือ ก่าซ้าด มางนา ป่าตูคู ป้า ชี นี้แม้แน, ‘กงานา อางญ่าม ปี่ ล่า ปาโน ยาว กงา อางชี่ คาโคลาโค จา แฮ้ง ไซ้ ล่า ว่า’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ยาว ก่าซ้าด มางมือ ย่าเจ่น มางนา ซื่งกง่ากย้า ยาว, ย่าเจ่น มาง อางชี่ ย่าง บ่ายู่ กาน แน ตอ แอ ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“ย่าเจ่น แฮ้มาง มือ อ่อกแอ ยาว, ยาง ย่าเจ่น อางช่าง ยางก้อง อางชี่ พลู้ 100 เหรียญ ตีด แล่ ชี่ มางนา มย้าง แอ ยาว, ยางมือ ยาง ย่าเจ่น อางช่าง มางนา นื้งชฺือ เวอ แกบ ยาว จี่ เย นี้แม้แน, ‘กงา นา อางชี่ ไซ้ ล่าว’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“ยาว ย่าเจ่น อางช่าง อางชี่ ตีด แล่ ชี่ มาง มือ ป่าตูคู ป้า ชี นี้แม้แน, ‘กงานา อางญ่าม ปี่ ล่า ปาโน, ยาว กงา อางชี่ คาโคลาโค จา แฮ้ง ไซ้ ล่าว่า’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","จ้า ยาง มือ บ่าจู่ เย ย่าเจ่น อางช่าง มางนา คอก เวอ ชู ล้อง แล ชีเย, ยาง อางชี่ แฮ้ง โค แน ปี่ เมอ ตื่อเคอ. ");
INSERT INTO bzi_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“ยาว ย่าเจ่น อางช่าง อือ มย้าง ยาว บ่าม่อนบ่าซ่า แม้แน, อางเลิ่ง กงาแบ กงามย้าง คูชี ย่าง ก่าซ้าด มางนา อู่บน้า แล ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","แฮ้งย้าเย่ ก่าซ้าด มาง มือ ย่าเจ่น แฮ้มางนา ฮ้าวล้า ปี่ ยาว จี่ เย นี้แม้แน, ‘ย่าเจ่น บ่าแม่น มาง เวอ, กงาย่า นาง กงาก้อง อางชี่ คาโคลาโค ตีด ล่า ชี แฮ้ง บ่ายู่ ล่า, ไม้ นาง กงานา ป้า ล่า ชี แฮ้ง ปาปาย, ");
INSERT INTO bzi_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","นาง มือ นาง ย่าเจ่น อางช่าง มางนา ซื่งกง่ากย้า แล่ กงา นางนา ซื่งกง่ากย้า ล่างแม้แน ช่าอ้า?’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ก่าซ้าด มาง มือ นาบาตา เย นืงบาค่า แง, แฮ้งย้าเย่ ยาง มือ ย่าเจ่น แฮ้มางนา คอก เวอ ล้อง วี่บ่ากไจ ปี่ ชี ยาง อางชี่ แฮ้ง โค เมอ ตื่อเคอ แน. ");
INSERT INTO bzi_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“จาว่าแน ฮาก นองนา อางบล่าบ อางอี ฮา ล่าชี่ มางนา นอง อางซี ยู้ ยาว. กงา อางโบ้ง มู่งท่า เวอ ดื้ง มาง นองนา คาโคลาโค แฮ้งนา แฮ้แม้แนย้า ฮา ล่าง.” ");
INSERT INTO bzi_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","พระเยซู อางเลิ่ง อือ จี่ เปิน ยาว, ยาง มือ กาลิลี แควน เวอ จาย ยูเดีย แควน จอร์แดน ล้างบ้า ทื่อปล่าก โย้เวอ แอน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ชฺ้าง อางอีบ่าอ่า เย ยางก้อง เค่ แอน ชี, ยาว ยาง มือ โย้เวอ ชฺ้างอางด้าอางกย้าง อือนา ยา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ฟาริสี อางมู เวอ ชฺ้าง ทื่อบ่า จา แง. พระเยซู นา อางเลิ่งซฺ่า คูชี. ยองมู นี้ย่า พระเยซู นา นี้แม้แน น้าน ชี, “ค่าพ่าย่า ค่าบา นา ว่าง นี้ย่า โมเสส อางลี้บอางล่าว เวอ อางซี ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","แฮ้งย้าเย่ พระเยซู มือ พอ ชี นี้แม้แน, “นอย่า พระคัมภีร์ โย้เวอ บ่ากงา อ้าน กางซื้ง ลา? ต่องก่า โย้เวอ พาจาว ม้า ค่าพ่าย่า ทื่อม่าง แน ค่าบาย่า ทื่อม่าง แต่ง ชี แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘นี้งย้า ค่าพ่าย่า นี้ย่า อางบา อางโบ้ง นา เจิ่ก ค่าบา ก้อง ดื้ง แอ แง. แน เย่ด ชฺ้าง ทื่อม่าง กา แน เพลิ่น ชี แน ทื่อช่างกานญา’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","นี้แม้แนยาว เย่ด ชฺ้าง 2 คู่น บ่าอ่า กาน, จ้า ชฺ้าง ทื่อม่าง กานญา. นี้แม้แนยาว พาจาว มาง ทื่อลู่มทื่อเจ่อ แน ฮา เพล่อ ปี่ ยาว, อ่าซ่าง มางนา บ่าปี่ ฮา เจิ่ก อ่อก ปี่ โจ” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ยาว ฟาริสี อืมมือ น้า แล่ ชี นี้แม้แน, “ท้าว โมเสส ย่า บ้าเจอ อางม่า แน ค่าพ่าย่า นี้ย่า, ว่างกาอางพ่า แฮ้ง ค่าบา อือนา แต้ม ปี่ ยาว ว่าง กงา คางญ้า?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ยาว พระเยซู มือ พอ เย นี้แม้แน, “โมเสส นองนา ม่าย ว่าง ปี่ ล่าง นี้ย่า ไม้ นอง อางล้าน แฮ้ง ปาปาย น่อ, จ้า ต่องก่า เวอ พาจาว ม้า นี้แม้แน บ่าตอล้า ปี่ ซี่. ");
INSERT INTO bzi_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","กงา ม่ายแบ ปี่ ล่าว่า อ่าซ่าง เวิม มือ จาคาปี่ว ค่าตอง ค่าบา นา ว่าง แล่ ยาว, ค่าบา อางซฺื่อ ยู้ แล่ง นี้ย่า, จู้ จา ชี แน ทื่อช่างกานญา, จ้า ค่าบา มาง ป้องก้า อางเลิ่ง อางซีอางบล่าบ ฮา ยาว ว่าง แล่ง นี้ย่า เจิ้นเจ้อบ่าไล่” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ยาว ยาง ศิษย์ อืมมือ พระเยซู นา จี่ช่าง เย นี้แม้แน, “ค่าตอง ค่าบา นา ว่าง แล่ง นี้ย่า นี้เลิ่ง แอ่ แน ยาว ค่าบา บ่ายู่ แฮ้ง เชคาไล” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ยาว พระเยซู มือ พอ เย นี้แม้แน, “นี้เลิ่ง ม่าอู่บจี่ต่าง นี้ย่า ชฺ้าง คาโคลาโค อือย่า โค แน ลาบกงา กาง บ่าอ่า เป. จ้า พาจาว ม้า ชฺ้าง ทื่อบ่า อือนา ฮาย ลาบกงา กา ปี่ง แง. ");
INSERT INTO bzi_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ยาว ค่าพ่าย่า อือ ค่าบา บ่ายู่ นี้ย่า, ไม้ ทื่อบ่า อือนา ชฺ้าง อือ ฮาย เพล่อ ปี่ ชี่, ทื่อบ่า อือย่า เกิ้ด เมอ จายย้า ค่าบา บ่ายู่ ตอ กา. ทื่อบ่า พาจาว มางนา ล่ากาน ว่า ปี่ แฮ้ง ค่าบา บ่ายู่, จ้า อ่าซ่าง ทื่อม่าง แน ดื้งกงา กาง แง อางแม่น ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ชฺ้าง ทื่อบ่า จา แง. ย่าเก อางอี อือนา ซฺื่ย พระเยซู นา ซฺ้า ล้า ชี, ไม้ ยางนา ล่าปู่โบ่ย ก่ามป่อน ปี่ ปี่ง แนนอ. จ้า ศิษย์ อือย่า ยองนา แฮ้แม้แน บ่าปี่ ฮา แน อี่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","จ้า พระเยซู ม่า เย นี้แม้แน, “ย่าเก อือนา กงาก้อง ตอย อ้องล้า ปี่ว. ยองนา เจิ้นเจ้อ บ่าจี่ โจ, ไม้ ชฺ้าง มู่งท่า เวอ กงาอ้อง แล คูง อือย่า ย่าเก นี้อือ แม้แน กงาเจ่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","พระเยซู ย่าเก อือนา ล่าปู่โบ่ย ก่ามป่อน ปี่ ยาว ยาง มือ โย้เวอ เจิ่ก อ่อกแอน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ย่าค่า ทื่อม่าง จา เย พระเยซู นา ซฺ้า ล้า ยาว น้า เย นี้แม้แน, “อ่าจาน เวอ, พาจาว มาง ก้อง ทื่งกง่า แน จี่วีดม้าม้า จา แล นี้ย่า, กงา บ้าเจอ อางเลิ่ง อางแม่น กงาฮา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","พระเยซู มือ พอ เย นี้แม้แน, “นาย่า บ้าเจอฮาย กงานา น้า ล่าง นา บ้าเจอ อางเลิ่ง อางแม่น กงาฮา แงแน? พาจาว มาง ญา อางแม่น แน. จาว่าแน นาง พาจาว มาง ก้อง จี่วีดม้าม้า จา แล ซี้ง แง แนยาว, นาง มือ อางลี้บอางล่าว แฮ้ง ฮา เค่ โว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ยาว ย่าค่า มาง มือ น้า เย อางลี้บอางล่าว ล้อข้อ เวอ แน. ยาว พระเยซู มือ พอ เย นี้แม้แน, “ชฺ้าง นา บ่าแซ่ โจ, ฮาก อางบี่อางบล้อง นา จู้ บ่าเพล่อ โจ, ฮาก อางเกิ่ง บ่าค่าว โจ, ชฺ้าง แล่จ่อบ บ่าเพล่อ โจ, ");
INSERT INTO bzi_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ค่าตอง อางบา อางโบ้ง นา นาบทื้อ โว, ฮากนา ลาก โว ค่าตอง นา ลาก แม้แน.” ");
INSERT INTO bzi_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ยาว ย่าค่า แฮ้มาง มือ พอ เย นี้แม้แน, “อางลี้บอางล่าว นี้ย่า กงา ฮา โค ย่า, ยาว บ้าเจอ จา แล่ง แง กงา บ่ากงา ฮา กาซื้ง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ยาว พระเยซู มือ พอ เย นี้แม้แน, “จาว่าแน พาจาว มาง แม่น ปี่ ซี่ง แม้แน แม่น ซี่ง แง แนยาว, นาง อางเกิ่ง คาโคลาโค จา ชี แฮ้ง ก่อง ยาว, พลู้ แฮ้ง ชฺ้าง อางตูกอางพาน อือนา ปี่ แอ โว! ยาว นา มู่งท่า โย้เวอ อางเกิ่งอางก้อ บย่า แน จา แง. แน นา กงาก้อง เค่ ล้าน ยาว กงา ศิษย์ เพลิ่น ปาว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ย่าค่า แฮ้มาง มือ แฮ้แม้แน กงากย่า ยาว, ยาง มือ นืงบาต่องบ่าม่อนบ่าซ่า แน ย่อ อ่อกแอน ชี, ไม้ ยา นาบาตา เย จาปาง แง. ");
INSERT INTO bzi_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","พระเยซู มือ ยาง ศิษย์ อือนา จี่ช่าง เย นี้แม้แน, “กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า, ชฺ้างอางจาอางปาง อือนา มู่งท่า เวอ อ้องแล ปี่ นี้ย่า นาบาตา ย่าก ");
INSERT INTO bzi_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ทื่อเทอ ม่า ล่าว่า อูฐ อือนา ก่องกย่าว อางฮ้อน เวอ อ้องแล ปี่ง นี้ย่า, ชฺ้าง อางจาอางปาง อือนา พาจาวอางเมิง เวอ อ้องแล ปี่ง แฮ้ง ล่อบ่าปา ไง่ แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ศิษย์ อืม นาบาตา ย้า นืงบาม่าน คูชี. แน ยองมู แฮ้ง นี้แม้แน น้าท้าม ลางกา ชี, “ซ้ามบา ชฺ้างอางจาอางปาง อืม พาจาวอางเมิง เวอ อ้องแล อางย่าก. ท้าว นี้แม้แนยาว พาจาวอางเมิง เวอ อ่าซ่าง อ้องแล กงากา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","พระเยซู มือ ยองนา ฮู ยาว นี้แม้แน พอ ชี, “ชฺ้าง นี้ย่า มู่งท่า เวอ ยอง ทื่อม่าง แน บ่าอ่อง แล กงากา, จ้า พาจาว มาง ปล่อง ยาว อางกงา ย้า, ไม้ พาจาว ม้าย่า กูย่างกูเจ้อ ย้า ฮาย กงากา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ยาว เปโตร มือ พระเยซู นา น้า เย นี้แม้แน, “อ่าจาน เวอ ฮูปาว, กงูย่า กูย่างกูเจ้อ อือ วี ย่า, ยาว นางก้อง เค่ คูง นี้ย่า กงูย่า บ้าเจอ กงา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","พระเยซู มือ พอ เย นี้แม้แน, “กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า นี้แม้แน, พาจาว มาง ชฺ้างอางเมิง อางซฺื่อ แต่ง ยาว, กงาชฺ้างอางย่า ม้า ต่างอี่ ก่าซ้าด ดื้งย้า โย้เวอ ดื้ง แง, ยาว นอง กงานา เค่ ล่า ชี อืมมือ ต่างอี่ ก่าซ้าด ดื้งย้า 12 อาน โย้เวอ กงา ดื้ง คู แง. ยาว อิสราเอล อางเจ้อ 12 เจ้อ อือนา กงา ต้าดต่อน แง. ");
INSERT INTO bzi_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ชฺ้าง คาโคลาโค กงานา เค่ ล่า ปาปาย ค่าตอง ยู้ม, อางบา อางโบ้ง, ม้องน้าม, อางย่าอางคย้า, น่า, ย้า แน กูย่างกูเจ้อ อือนา วี ชี อือย่า, ยอง วีจาน ชี แฮ้ง ล่อบ่าปา 100 โตบ กงายคื่น แล่ง, แน พาจาว มาง ก้อง ทื่งกง่า แน จี่วีดม้าม้า กงา จา แล แง. ");
INSERT INTO bzi_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","จ้า อามือ ชฺ้าง ปีนแตปีนนา อือย่า, น่อง เวอ ชฺ้าง ปีนแตปีนนา บ่าอ่า เพล่อ แง. แน อามือ ชฺ้าง ปีนแตปีนนา บ่าอ่า อือย่า, น่อง เวอ ชฺ้าง ปีนแตปีนนา เพล่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“พาจาว มาง อางเมิง แฮ้ย่า อ่างู่น โซนซื้ง ทื่อม่าง, ค่าตอง ยู้ม เวอ ซอทาด่า แน ทา อ่อกแอ ยาว, ยาง อ่างู่น โซน โย้เวอ ล่ากานว่าฮู ซฺ้า จ้าง ว่า ปี่ง แม้แน ย้า เพ้ก แง. ");
INSERT INTO bzi_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ยาว ยาง ล่ากานว่าฮู่ ย่าง กานืง กาเหรียญ กา แน จ้าง ชีเย, ยาว ยาง มือ อ่างู่น โซน เวอ ล่ากาน อ้อง ว่า แล ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“ยาว 9 โมง ซอทา เวอ โซนซื้ง มางมือ ก้าด เวอ แล ยาว, ชฺ้าง ไล คู่น เจิ้นเจ้อ ว่าเซฺ่อ บ่าจา แน ก้าด โย้เวอ จูง จา คูง นา มย้าง แล ชี. ");
INSERT INTO bzi_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ยาว ยาง มือ ยองนา ม่า เย นี้แม้แน, ‘จาว่าแน นอง กงา อ่างู่น โซน โย้เวอ ล่ากาน ว่า แล ยาว กงามมือ ล่ากานว่าฮู่ แม่น แน ปี่ ล่าว่า’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ยาว ชฺ้าง แฮ้อืมมือ ล่ากาน ว่า แล คู ชีเย. ยาว โซนซื้ง มางมือ 12 โมง นืงก้องฮ่างจฺ่าญ่าม แน 3 โมง เวอ อ่อกแอ แล่ ชีเย. ยาว ยาง มือ อางอ้าน ย่าง แม้แน ฮา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“ยาว 5 โมง มู่งคี่ล้าก้า เวอ โซนซื้ง มาง มือ ก้าด โย้เวอ ทื่อเทอ อ่อกแอน แล่ ชี. ยาว ยาง มือ ชฺ้าง ทื่อบ่า เจิ้นเจ้อ บ่าว่า แน จูง จา นา มย้าง แล ชี. แฮ้งย้า ยาง อ้อง น้า แล ชี นี้แม้แน, ‘บ้าเจอ นอ ว่านคาม แน เจิ้นเจ้อ บ่าว่า แน จูง คู แง’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“ยาว ชฺ้าง แฮ้อืมมือ พอ คูง เย นี้แม้แน, ‘กงูนา อ่าซ่าง มาง ล่ากาน บ่าจ่าง ว่า ปี่ ล่า’ แน. “แฮ้งย้าเย่ อ่างู่น โซนซื้ง มาง ล่ากาน ช่าง ว่า ชี นี้แม้แน, ‘กงา โซน โย้เวอ ล่ากาน ว่า แล ปาว’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“มู่งคี่ล้าก้า เคิน ยาว โซนซื้ง มาง มือ ล่ากานว่าฮู ยอคา มางนา ฮ้าว ม่า ชี นี้แม้แน, ‘ล่ากานว่าฮู อือนา ฮ้าวล้า ปี่ ยาว ล่ากานว่าฮู่ นี้ง ปี่ โว. จ้า ชฺ้าง น่อง เวอ ล่ากาน ล้า ว่า ชี อือนา ปี่ ออน ปี่ โว, ชฺ้าง ล่ากาน ว่า ล้าออน อือนา น่อง เวอ ปี่ กาโน’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ชฺ้าง 5 โมง มู่งคี่ล้าก้า เวอ ว่า ล้า ชี อือ ล่ากานว่าฮู่ กามางกา เหรียญ กงา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","แฮ้แม้ยาว ล่ากานว่าฮู อางด่า เวอ ล้า ชี อืมมือ ล่ากานว่าฮู่ ย่าง ล่า แอ คู ชีเย. ยองมือ เย้ง คูง เย ยอย่า 5 โมง เวอ ล้า ชี มาง ล่อบ่าปา แน ล่ากานว่าฮู่ กงา แงแน, จ้า ยอ พลู้ กามาง กาเหรียญ ญา กงา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ยาว ยอง มือ ล่ากานว่าฮู่ ย่าง กงา คู ยาว โซนซื้ง มางนา จี่จ่าบ แอ คู ชีเย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘แฮ้อือย่า ล่ากาน 1 ชั่วโมง ญา ว่า คูแง, จ้า นา ยองนา กงู นื้งช้า อางล้อง เวอ ล่ากาน ว่านคาม แน ว่า ชี อือ ล่อ แน อางปี่ แน.’ ");
INSERT INTO bzi_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“ยาว โซนซื้ง มาง มือ ล่ากานว่าฮู ทื่อม่าง มางนา ม่า ชีเย นี้แม้แน, ‘อางช่าง เวอ, กงาย่า นางนา บ่ากงาโกง ล่า เป, ไม้ กงูย่า ล่ากานว่าฮู่ กานืง กาเหรียญ กาแน จ้าง กาง อ่าลา? ");
INSERT INTO bzi_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","นาง ล่ากานว่าฮู่ แฮ้ง ยู้ ยาว แอ ปาว. กงาย่า น่อง เวอ ล้า ชี อือนา นางนา จ้าง ล่าชี่ แฮ้งล่อ แน ปี่ ซี่ง นอ. ");
INSERT INTO bzi_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","กงาย่า กงา พลู้ นี้ง กงา วา แน บ่าไจ กงากา ลา? นาย่า กงา นืงบาอางแม่น นี้งนา เจอ ลา?’” ");
INSERT INTO bzi_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","พระเยซู จี่ แล่ง นี้แม้แน, “นี้งย้าเป อามือ ชฺ้าง ปีนแตปีนนา อือย่า, น่อง เวอ ชฺ้าง ปีนแตปีนนา บ่าอ่า อือ เพล่อ แง. แน อามือ ชฺ้าง ปีนแตปีนนา บ่าอ่า อือย่า, น่อง เวอ ชฺ้าง ปีนแตปีนนา เพล่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","พระเยซู เยรูซาเล็ม อางเมิง เวอ แก้บ้า ย่อ แล เมอ, ศิษย์เอก 12 คู่น อือ แอ่ แน ซฺื่ยกา อ่อกแอ ชี. ยาว ยาง มือ ยองนา จี่ช่าง ชี นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“แม่น แน น้า โว! อามือ กงูมู นี้ย่า เยรูซาเล็ม อางเมิง เวอ ชา แล คูแง. แน ชฺ้าง กงานา บ่าแม่น ฮา ล่าง ม้า, กงานา ชฺ้างอางย่า เพล่อ ชี นี้มางนา ปุโรหิต ยอคา อือ ก้อง, แน อางลี้บอางล่าว ม่าอู่บฮู อือ ก้อง ซฺาแอ ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ยองมู แฮ้ย่า กงานา ต้าดต่อน ซฺี้ ปี่ ล่าง. แน กงานา โรมชฺ้าง อือ ก้อง ซฺาแอ ปี่ ล่าง. ยาว ชฺ้าง แฮ้อืมมือ กงานา, จี่ฮูย้า อื้อกาน, ตื่อชืก ล่าง. ยาว กงานา ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด ซฺี้ ปี่ ล่าง. จ้า วันที่ 3 เคิน ยาว พาจาว มาง กงานา แต่ล้า แล่ ปี่ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","เศเบดี ค่าบา แน ยาง อางย่า 2 คู่น อือ ซฺื่ยกา พระเยซู ก้อง ล้า ชี. ยาว เศเบดี ค่าบา มาง มือ พระเยซู นา บอกไว้ ยาว กาบ่ากาเจ้อ ป้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","แฮ้งเย่ พระเยซู มือ ยางนา น้า ชี นี้แม้แน, “บ้าเจอ ฮา แง?” แน. ยาว ยาง มือ ฮา เย นี้แม้แน, “นาง ก่าซ้าด กงา เพล่อ เมอ, กงา อางย่า มาง เย่ดนา นาง ล่าม่า ป่ากย่า ทื่อม่าง แน นาง ล่าซ่าย ป่ากย่า ทื่อม่าง ดื้ง ปี่ โว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ยาว พระเยซู มือ พอ เย นี้แม้แน, “ไน้ย่า อางแบ ล่า บ้าเจอ ป้า คูชี แน. ไน้ กงา ล้างก้อก อางตูกอางพาน กงาต้าง นี้ง อางต้าง กงา ย้าลา?” แน. เย่ด 2 คู่น ย่าง มือ พอ ชีเย “อางกงา ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ยาว พระเยซู มือ เย่ดนา ม่า ชีเย นี้แม้แน, “ไน้ย่า ม้าม้า ย้า กงาบู้ แง, จ้า อ่าซ่าง กงา ล่าม่า ล่าซ่าย ป่ากย่า ดื้ง นี้ย่า กงา แช้ ดื้ง ปี่ บ่าอ่า, จ้า แช้ ดื้ง ปี่ ม้า อ่าโบ้ง เป, ยา ซฺ้า ชี ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ยาว ศิษย์ ทื่อแช่ คู่น อือ นี้เลิ่ง นา แบ คู ยาว, ยองมือ ม้องน้าม แฮ้ เย่ดนา นาบาตา เย นืงบาค่า แง. ");
INSERT INTO bzi_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","แฮ้งย้าเย่ พระเยซู มือ ยอง คาโคลาโค นา ฮ้าวล้า ปี่ ยาว ม่า ชี นี้แม้แน, “นอ อางแบ ย้า ชฺ้างอางเมิง นู้เวอ ก่าซ้าด อือย่า ค่าตอง ชฺ้าง ฮูพลา ชี อือ ล่อบ่าปา ฮื่อ แล่ง แน. ยาว ชฺ้าง ยอคา เพล่อ คูชี อืม ค่าตอง ชฺ้าง ฮูพลา ชี อือนา ล่าที่ ไจ ช่าง แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","จ้า นอง อางมู นู้เวอ แฮ้แม้แน บ่าอ่า, อ่าซ่าง อางฮื่อ เพล่อ ซี่ แง. ยา นองนา ล่ากาน กงาว่า ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","แน อ่าซ่าง ชฺ้าง ปีนแตปีนนา อางฮื่อ เลิ่นเลิ่น เพล่อ ซี่ แง. ยา นองมู คาโคลาโค อือ ย่าเจ่น กงาเพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ไม้ กงาชฺ้างอางย่า เพล่อ ชี นี้มาง ลือ ชี นี้ย่า ฮากนา กงา ย่าเจ่น เพล่อ ปี่ง บ่าอ่า, จ้า กงาย่า ฮาก ย่าเจ่น เพล่อ ลือ แอ. แน ค่าตอง จี่วีด วี ลือ แง, ไม้ ชฺ้าง อางบย่า อือนา ปล่อง ย่าเจ่น กงาปูน ปี่ง แนนอ” แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","พระเยซู แน ยาง ศิษย์ อือ เยรีโค อางเมิง เวอ จาย อ่อกลือ เมอ, ยองนา ชฺ้าง อางอีบ่าอ่า เย ย่อ เค่ แอ้น คู ชี. ");
INSERT INTO bzi_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ค่าพ่าย่า แมปอ 2 คู่น จา เย แก้บ้า ก่องทาง โย้เวอ ดื้ง จา แง, เย่ด มือ พระเยซู ลืน ชี แน กงากย่า ยาว จี่ โฮ้กฮ้าว ป้า เย นี้แม้แน, “จี่วีดอางซื้ง ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บล้า ชี มาง เวอ, ไกง้นา ซื่งกง่ากย้า ล่าปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ค่องช่าง อางอีบ่าอ่า เย่ดนา จี่จ้าด ม่า กยาบ ปี่ชี่. จ้า ยาง อางอ้าน แฮ้ง ล่อบ่าปา อางเซง บื้ง แน จี่ โฮ้ก ชี. แน ยา นี้แม้แน จี่ ชี, “พระเยซู ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บล้า ชี มาง เวอ, ไกง้นา ซื่งกง่ากย้า ล่าปาว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","แฮ้งเย่ พระเยซู มือ ย่อ ย่าง ว่าง ยาว เย่ดนา ฮ้าวล้า ปี่ ยาว น้า ชี นี้แม้แน, “กงานา บ้าเจอ ปล่อง ปี่ ล่าแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ยาว เย่ด มือ ม่า เย นี้แม้แน, “จี่วีดอางซื้ง มาง เวอ, ไกง้ย่า ฮู มย้าง ซี้ค่า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","พระเยซู มือ เย่ดนา ซื่งกง่ากย้า เย แฮ้งเย่ เย่ด แมนือ เวอ ว่า ชี. ยาว เย่ด มือ ซฺ้อก ย้า ฮูมย้าง ล้า ชี. ยาว เย่ด มือ พระเยซู ก้อง เค่ แลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","พระเยซู แน ศิษย์ อือ เยรูซาเล็ม อางเมิง โย้เวอ ชา เคอ แล เมอ, ยองมู แฮ้ง เบธฟายี ค่อง แน เบธานี ค่อง โย้เวอ เคิน แล คูชี. เบธฟายี ค่อง แน เบธานี ค่อง นี้ย่า มะกอกเทศ ตาแซ้ ท่า โย้เวอ ดื้ง แง. ยาว พระเยซู มือ ศิษย์ 2 คู่น ม่าง เย่ดนา ซฺาแล ปี่ ลางออน แล ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","แน ม่า ชี นี้แม้แน, “ค่อง ล้าก้า โย้เวอ อ้องแล โว, ยาว ไน้ มือ ลา อางบา อางย่า 2 โต แล่ง จา นา มย้าง แง, ยาว ลา มาง เย่ด ล่าตื่อ แฮ้ง พื้ย ยาว กงาก้อง ชื้ง ลือ โว. ");
INSERT INTO bzi_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","จาว่าแน ฮาก น้า ล่ายาว นี้แม้แน, ไน้ย่า ลา แฮ้ เย่ด นา เกิ้ง ซฺื่ย แอ แงแน, ไน้ ม่า โว จี่วีดอางซื้ง มาง ไจ ซี้ง แง แน, ยาว ซฺ้อก ย้า ยาง มือ ไน้นา ปี่ ลือ ปี่ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","นี้เลิ่ง ม้าม้า ย้า ตอล้า แง, พาจาวจี่ต่างจี่แต่นฮู มาง มอ ยาว พระคัมภีร์ เวอ แต้ม ชี ชี แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ศิโยน อางเมิง ชฺ้าง อือนา ม่า ปาว ชี นี้แม้แน, ‘ฮูปาว นอง ก่าซ้าด มาง อามือ ล้า แงแน. ยา บ่าอ่อนจ่าแล่, ยา ลา อางย่า มาง ต่างค่าง โย้เวอ ตา ชี.’” ");
INSERT INTO bzi_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","แฮ้งย้า ศิษย์ 2 คู่น มาง เย่ด มือ พระเยซู ม่า ชี แม้แน ค่อง แฮ้ค่อง โย้เวอ อ้องแลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ยาว เย่ด มือ ลา อางบา แน ลา อางย่า มาง เย่ดนา พระเยซู นา ชื้ง ซฺาลือ ชี. ยาว เย่ด ค่าลาว ย่าง ลา มาง เย่ด ต่างค่าง เวอ ค่าง ยาว พระเยซู นา ดื้ง ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ค่องช่าง อางอีบ่าอ่า เย ยอง อางก่าอางตูม ย่าง แก้บ้า เวอ ค่าง ชี, แน ทื่อบ่า จฺืงจฺื้งล่างาม อือ เพิด ยาว แก้บ้า เวอ ค่าง คู ยาว พระเยซู นา ลา ตา ย่อ แอ ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ค่องช่าง พระเยซู ล้าก้า แน น่องน่อง เวอ ย่อ ชี อืมมือ จี่โฮ้กฮ้าว คูง เย นี้แม้แน, โฮซันนา! ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บลือ ชี มางนา สรรเสริญ ฮา แง. จี่วีดอางซื้ง เวอ, นาง ซฺาลือ ปี่ ชี่ มางนา ก่ามป่อน ปี่ ปาว. “โฮซันนา! พาจาว อางฮื่อ เลิ่นเลิ่น มู่งท่า เวอ ดื้ง มางนา สรรเสริญ ฮา แง!” ");
INSERT INTO bzi_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","พระเยซู เยรูซาเล็ม อางเมิง เวอ อ้องแล เมอ, อางเมิง โย้เวอ ชฺ้าง อืมมือ ซืกซาก น้า กาง เย นี้แม้แน, “อ่าซ่าง เวอ?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ยาว ชฺ้าง มู อืมมือ พอ คูง เย นี้แม้แน, “ชฺ้าง นี้ม้า เยซู พาจาวจี่ต่างจี่แต่นฮู นาซาเร็ธ ค่อง กาลิลี แควน เวอ จายลือ ชี มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","พระเยซู มือ โบสถ์อางฮื่อ กองโค้ง โย้เวอ อ้อง แลน ชี. แน โบสถ์อางฮื่อ กองโค้ง โย้เวอ ชฺ้าง อางเกิ่ง ก่อง ล้า ชี อือนา, แน อางเกิ่ง วื้อ ล้า ชี อือนา ก่าแอ ปี่ชี่. ยา พลู้ เพ่นฮู อือ แน ฮาย่า อางป่อน ก่องฮู อือ โต แน ต่องก่อน แฮ้ง ต่านเลิง ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี, ‘กงา โบสถ์อางฮื่อ นี้ย่า ยู้มอธิษฐานฮาย้า แน ฮ้าว แง.’ จ้า นอ ค่าโม่ยค่ามโจน ยู้ม ฮาย เพล่อ ปี่ชี่!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ชฺ้างแมปอ แน ชฺ้าง ต่องแก่ พระเยซู นา โบสถ์อางฮื่อ โย้เวอ อ้อง ซฺ้า ล้า ชี. ยาว พระเยซู มือ ยองนา โปยว ย้า ยา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ปุโรหิต ยอคา แน อางลี้บอางล่าว ม่าอู่บฮู อือ, พระเยซู อางเลิ่งชฺ้างบ่าฮาตอกางอือ แน ย่าเก อือ นี้แม้แน โฮ้กฮ้าว แฮ้งนา, “ก่าซ้าด ดาวิด อางอ่านอางซฺื้อ มาง เวอ, อ่าญูซื้ง แน จา แล โว” แน, กงากย่า กงามย้าง คู เมอ ยอง มือ นาบาตา เย นืงบาค่า คูแง. ");
INSERT INTO bzi_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","แฮ้งย้า ยอง มือ พระเยซู นา น้า คูชี นี้แม้แน, “ย่าเก อือ โฮ้กฮ้าว แฮ้งนา อางกงากย่า ย้า ลา?” แน. ยาว พระเยซู มือ พอ ชีเย, “อางกงากย่า ย้า นอย่า พระคัมภีร์ โย้เวอ บ่ากงา อ้าน กางซื้ง ล่า นี้แม้แน, ‘พาจาว ม้า ย่าเก แน ย่าแน่ อือนา สรรเสริญ เพ่ง อือ ม่าอู่บ ยาว นางนา ฮ้าว ปี่ ล่าแง แน ชี่ แฮ้.’” ");
INSERT INTO bzi_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ยาว พระเยซู มือ เยรูซาเล็ม อางเมิง โย้เวอ จาย อ่อก ลือ ยาว เบธานี ค่อง เวอ ซ่าว แอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ซอทา แปล้น ล้า ยาว พระเยซู เยรูซาเล็ม อางเมิง โย้เวอ, ย่อ พ่าว ลือ แล่เมอ ยาง มือ ฮ่างแบ่น ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ยาว ยาง มือ ซื่อไค่มี้ล่อก ป่าง ทื่อป่าง แก้บ้า ก่องทาง โย้เวอ มย้าง ชีเย, แฮ้งย้าเย่ ยาง มือ ย่อ อ้อง ฮู แล ชี, จ้า อางซื่อ บ่าจา เย. อางพ่า แอ่น ญาเย่ จา แง, แฮ้งย้าเย่ ยาง มือ จฺืงจฺื้ง มางนา จี่ช่าง ชี นี้แม้แน, “อางซื่อ บ่าซื่อ แล่ก้าน โจ!” แน. ยาว ซื่อไค่มี้ล่อก แฮ้ ป้าง มือ ซฺ้อก ย้า แฮ่ว ซฺี้ กา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ยาง ศิษย์ อือ แฮ้แม้แน มย้าง คู ยาว นืงบาม่าน น้า คูง เย นี้แม้แน, “บ้าเจอ ซื่อไค่มี้ล่อก นี้ ป้าง แฮ่ว กือ ซฺี้ ไว่ กาทืง แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ยาว พระเยซู มือ พอ ชีเย นี้แม้แน, “กงา นองนา อางเลิ่ง ม้าม้า ม่ายแบ ปี่ ล่าว่า นี้แม้แน, จาว่าแน นอง ม้าม้า แน เจ่อ ยาว, นอง มือ กงา ซื่อไค่มี้ล่อก นี้ ป้าง นา ฮา ชี แม้แน ฮา กงา กางแง, แนยาว นอง มือ ตาแซ้ นี้มางนา ‘ทะเล โย้เวอ ล่อย กลา แอ โว.’ แน อางม่า กงากา. ยาว แฮ้แม้ย้า ตอล้า แง. ");
INSERT INTO bzi_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“จาว่าแน นอง พาจาว มางนา เจ่อ ยาว นอง บ้าเจอ อธิษฐาน ฮาย ป้า เวิม แฮ้แม้แน ย้า กงา คู แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","พระเยซู โบสถ์อางฮื่อ โย้เวอ อ้องแล ยาว ม่าอู่บ จา เมอ, ปุโรหิต ยอคา แน ยิวชฺ้าง ยอคา อือ พระเยซู นา อ้อง น้า ล้า ชีเย นี้แม้แน, “นา อ่าซ่าง? นางนา อ่าซ่าง ล่าที่ ปี่ นี้แม้แน ฮา ปี่ ล่าแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ยาว พระเยซู มือ พอ เย นี้แม้แน, “กงา นองนา น้า ล่าง นี้ง ม่า ล่าวแล, ยาว กงาม นอง กงานา น้า ล่าง นี้ง ม่า ล่าว่า, กงา อ่าซ่าง ล่าที่ แฮ้ง ไจ อางเลิ่ง นี้อือ ฮา แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","กงานา ม่าย ล่าวแล, ยอห์น ล้างตือพิธีบัพติศมา ฮา แฮ้ย่า ยางนา อ่าซ่าง ล่าที่ ปี่ ชี. พาจาว มาง ปี่ ชี ลา, อ้าว ชฺ้าง อือ ปี่ ชี?” แน. ยาว ยองมู แฮ้ง นี้แม้แน จี่ ลางกา ชี, “กงู ยางนา บ้าเจอล้อแม้แน พอ คูวา? จาว่าแน กงู ยางนา นี้แม้แน พอ ยาว, ‘พาจาว มาง’ แน. ยาง กงูนา นี้แม้แน น้า ล่า กาน้าอี่, ‘ท้าว นอ บ้าเจอฮาย ยอห์น นา บ่าเจ่อ คูแน?’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","จ้า กงู ยางนา นี้แม้แน พอ ยาว, ‘ชฺ้าง ก้อง จายล้า แง’ แน. ค่องช่าง อืม กงูนา นืงบาค่า ล่า กาน้าอี่, ไม้ ค่องช่าง อือย่า เจ่อ คูง ยอห์น พาจาวจี่ต่างจี่แต่นฮู” แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","แฮ้งย้า ยอง พระเยซู นา นี้แม้แน พอ คูชี, “บ่าแบ ล้า” แน. แฮ้งย้า พระเยซู มือ ยองนา นี้แม้ ม่า ชี, “นี้แม้แนยาว กงาม นองนา บ่าม่า ล่า, อ่าซ่าง กงานา ล่าที่ ปี่ นี้แม้ ฮา ปี่ ล่าชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“กงานา ม่า ล่าวแล นาย่า นี้เลิ่ง นา ล้อแม้แน เย้ง แงแน, ค่าพ่าย่า ทื่อม่าง จา แง ยางก้อง อางย่า ย่าค่า 2 คู่น จา แง. ยา อางย่า ซากาว มางนา ม่า ชี นี้แม้แน, ‘มี้นืง นา อ่าโบ้ง อ่างู่น โซน โย้เวอ ล่ากาน ว่า แล ปาว แน.’ ");
INSERT INTO bzi_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ยาว อางย่า มาง พอ เย ‘อ่าเฮอ’ แน. ยาว จายล้า แล่ยาว ยาง มือ นืงบาเพ่น ชี อ่างู่น โซน โย้เวอ ล่ากาน ว่า แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ยาว อางโบ้ง มาง อางย่า ทื่อม่าง มางนา ม่า แล่ ชีเย, ‘มี้นืง อ่างู่น โซน โย้เวอ ล่ากาน ว่า แล ปาว’ แน, ยาว ยาง มือ อางโบ้ง มางนา ม่า เย ‘โอ่ย’ แน. จ้า ยาง มือ บ่าแล เย. ");
INSERT INTO bzi_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“อางย่า 2 คู่น นี้เย่ด ย่า อ่าซ่าง อางโบ้ง มางนา น้า จ่าง แง?” ยาว ยิวชฺ้าง ยอคา อืมมือ พอ คูง เย, “อางย่า ซากาว มาง” แน. ยาว พระเยซู มือ ม่า ชี นี้แม้แน, “กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า, ชฺ้าง ภาษีกอฮู อือ แน ค่าบาย่า อางโต ก่อง อือย่า, พาจาว มาง อางเมิง โย้เวอ นองนา แล แต่น ล่า คู แง. ");
INSERT INTO bzi_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ยอห์น ย่า นองนา ม่ายแบ ปี่ ล่างญา ล้อแม้แน พาจาว มางก้อง จี่วีด กง่าเกิ้ง แน ไจ แงแน, จ้า นอง มือ ยางนา บ่าเจ่อจ่า คู จ้า ชฺ้าง ภาษีกอฮู อือ แน ค่าบาย่า อางโต ก่อง อือย่า ยอห์น นา อางเจ่อจ่า คู. นอย่า ยอง นี้แม้แน ฮา ชี แฮ้งนา มย้าง คู เวิม มือ, นอย่า ยอห์น นา เจ่อ แงแน นืงบา บ่าเพ่น คู.” ");
INSERT INTO bzi_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","พระเยซู จี่ แง, “อางเลิ่ง เพ้ก น้า ปี่ ลาง นี้ง แม่น แน น้า คู ปาว. ค่าพ่าย่า ทื่อม่าง จา แง อ่างู่น โซน ว่า ชี, ยาว ก้ามทื้อ ทือ แวด ชี. แน อ่างู่น น่างเซฺ่อ ค่ามตู่ ตู่ ชี. ยาว หอคอย แต่ง ชี. ยาว ฮากนา ว่าพ่าพ้า ปี่ชี่. ยาว ยาง อางโต แฮ้ย่า ฮาก อางเมิง เวอ แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","อ่างู่น ชู ญ่าม เคิน ยาว, โซนซื้ง มาง มือ ยาง ย่าเจ่น อือนา ม่าย โซนว่าพ่าพ้า อือก้อง อ่างู่น ม่าย ล่า แอ ปี่ ชี่.” ");
INSERT INTO bzi_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“จ้า อ่างู่น โซนว่าพ่าพ้า ชี อือ ย่าเจ่น อือนา ชู ชี ชี. ทื่อม่าง มางนา แซ่ ชี, ทื่อม่าง มางนา ตื่อชืก ชี. ยาว ทื่อม่าง มางนา ลอบา ย่าง จาน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","แฮ้งย้าเย่ อ่างู่น โซนซื้ง มาง มือ อางอ้าน ล่อบ่าปา แน ย่าเจ่น อือนา ซฺาลือ ปี่ ชี. จ้า โซนว่าพ่าพ้า อืมมือ อางอ้าน แม้แน ฮา แล่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","น่อง เวอ โซนซื้ง มาง มือ ยาง อางย่าย่าค่า มางนา ซฺาลือ ปี่ ชี่, ยาง มือ เย้ง เย ‘โซนว่าพ่าพ้า อือ กงา อางย่าย่าค่า มางนา อางน้า จ่า นาตู้’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“จ้า โซนว่าพ่าพ้า อือ โซนซื้ง มาง อางย่า มาง ลือ นา มย้าง คู ยาว, ยอง มือ นี้แม้แน ม่า ลางกา ชี, ‘ฮู ปาว ชฺ้าง นี้ม้า โซนซื้ง อางย่า ย่าค่า ม่าง ย้า. กงู ยางนา ปล่อง แซ่ กาเซฺ้อ, อ่างู่น โซน นี้ง กงูเฮอ เพล่อ คาไล!’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","แฮ้งย้า ชฺ้าง โซนว่าพ่าพ้า คูชี อืม ยางนา ชู แซ่ ยาว อ่างู่น โซน อางเง้ โย้เวอ ลาม วี แอ ชี.” ");
INSERT INTO bzi_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ยาว พระเยซู มือ ยองนา นี้แม้แน จี่ช่าง ชี, “นอง เย้ง กาน ยาว โซนซื้ง ม้า บ้าเจอล้อแม้ ฮา แง?” ");
INSERT INTO bzi_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ยา ชฺ้าง โซนว่าพ่าพ้า คูชี อือนา แซ่ ล้า ยาว, อ่างู่น โซน แฮ้ง ฮากนา ว่าพ่าพ้า ปี่ง ลา? ยาว ปุโรหิต ยอคา แน ยิวชฺ้าง ยอคา อืมมือ พอ คูง เย นี้แม้แน, “ยา โซนว่าพ่าพ้า บ่าแม่น อือนา ม้าม้า ย้า แซ่ แง, แน โซนซื้ง มางมือ ชฺ้าง โซนว่าพ่าพ้า ยางนา อ่างู่น เปิ่ง ปี่ ชี่ แฮ้มางนา ยาง โซน แฮ้ง ว่า แล แล่ ปี่ แง.” ");
INSERT INTO bzi_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","พระเยซู มือ ม่า ชี นี้แม้แน, “นอ พระคัมภีร์ นี้ข้อ นา บ่ากงา อ้าน ลา? ‘ยู้ม ซ้าล้า อือ ยู้มยื้ง วี ชี นี้ยื้ง น่อง โย้เวอ เสาเอก เพลิ่น ชี. นี้ย่า จี่วีดอางซื้ง มาง ฮาย เพล่อ ปี่ชี่. กงูนา ฮา มย้าง ปี่ ล่าง นี้เลิ่ง นืงบาม่าน คาบอล้อ ย้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“กงา ม่ายแบ ปี่ ล่าว่า, พาจาว มาง อางเมิง แฮ้ย่า นองก้อง เวอ เจิ่ก แล แง, ยาว ชฺ้าง พาจาว มางนา น้าจ่า ยาว ฮายเค่ อือนา โญก ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ชฺ้าง ยู้มยื้ง นี้ยื้ง นา เลิงเง่ ชี อือ ยอง อางกง่าว แฮ้ เคลิก แง. จ้า ยู้มยื้ง นี้ยื้ง เลิงตื่อ ยาว ชฺ้าง แฮ้ม้า บืนยาวล้าว ยาว ย้า.” ");
INSERT INTO bzi_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ปุโรหิต ยอคา แน ฟาริสี มู อือ พระเยซู อางเลิ่ง จี่เพ้ก แฮ้ง กงากย่า คู ยาว, ยอง มือ ซฺ้อก ย้า แบน คูชี พระเยซู ยองนา ชฺ้าง โซนว่าพ่าพ้า บ่าแม่น อือ แน ฮา แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ยาว ยอง มือ พระเยซู นา ชู คู ซี้ง เย จ้าบ่าชู จอ กาเย, ไม้ ชฺ้าง นี้อือย่า พระเยซู นา พาจาวจี่ต่างจี่แต่นฮู มาง แน เจ่อ คูง เย. ");
INSERT INTO bzi_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ยาว พระเยซู มือ ยองนา อางเลิ่ง อู่บเพ้กน้า แล่ ปี่ ชี นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“พาจาว มาง อางเมิง แฮ้ย่า ก่าซ้าด มาง, ยาง อางย่าย่าค่า มางนา ค่าบาล่า จฺ่าปอต้างปอ ล้าง ปี่ แม้แน ทื่อช่างกานญา. ");
INSERT INTO bzi_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ยาว ล่ากาน อือ ล้างจ่าเปิน เมอ, ก่าซ้าด มางมือ ย่าเจ่น อือนา ม่าย ชฺ้าง ป้า ชี อือนา ม่ายล้า ปี่ ชี. จ้า อ่าซ่าง มาง บ่าล่า เย. ");
INSERT INTO bzi_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“ยาว ก่าซ้าด มางมือ ย่าเจ่น ทื่อบ่า อือนา ทื่อเทอ ม่า แอ แล่ ปี่ ยาว ม่า ชี นี้แม้แน, ‘ชฺ้าง ป้ายล้า ปี่ ชี่ อือนา ม่าย แอ โว, กงา จฺ่าปอต้างปอ ล่ากาน นี้ย่า ล้างจ่าเปิน ย่า. อ่ามย่าง อางฮู้ แน อ่ามย่าง อางตู่ง อางแม่น อือ แซ่ เปิน ย่า, ล้าย กงา คางญา’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","จ้า อ่าซ่าง มาง บ่าตี่นบ่าต่อง คู เย, ยอง ล่ากาน อือ แล ว่า แล คู ชี. ทื่อบ่า โซน ว่า แล ชี, ทื่อบ่า ก่องก้า แล ชี, ");
INSERT INTO bzi_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ยาว ชฺ้าง จ้าน ล้าชี อืมมือ ย่าเจ่น อือนา ชู ตื่อ ยาว แซ่ วี ชี. ");
INSERT INTO bzi_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“ก่าซ้าด มางมือ นาบาตา เย นืงบาค่า แง, แฮ้งย้าเย่ ตาฮ้าน อือนา ม่า ชฺ้าง ยาง ย่าเจ่น อือนา แซ่ ชีอือ นา แซ่ แอ ปี่ ชี, ยาว ยอง อางเมิง ย่าง พี วี ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","แฮ้งย้าเย่ ก่าซ้าด มางมือ ยาง ย่าเจ่น อือนา จี่ช่าง ชี นี้แม้แน, ‘ค่าบาล่า ล่ากาน นี้ย่า ล้าง ชี เปิน ยา, จ้า ต่องก่า เวอ ชฺ้าง จฺ่าปอต้างปอ ล่ากาน นู้เวอ ป้าล้า ชี อือย่า บ่าซูม คู’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","แก้บ้า อือเมอ อ่อกแอ ยาว อ่าซ่าง นา คามย้าง แง ม่ายล้า ปี่ ปาว. ");
INSERT INTO bzi_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ยาว แฮ้งย้า ย่าเจ่น อืมมือ แก้บ้า อือเมอ อ่อกแอ ยาว, ตื่น ชฺ้าง อางแม่น แน ชฺ้าง บ่าแม่น ยอง คามย้าง อือนา ม่ายล้า ปี่ ชี, จฺ่าปอต้างปอ อางฮ้อง เวอ ปลื้ง ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ก่าซ้าด มาง จฺ่าปอต้างปอ ล่ากาน โย้เวอ อ่อก ฮู ลือ เมอ, ยาง มือ ค่าพ่าย่า ทื่อม่าง นา มย้าง ชีเย, ยาง อางก่าอางตูม ตูม แล่ ชี แฮ้ย่า บ่าซูม แน. ");
INSERT INTO bzi_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ยาว ก่าซ้าด มาง มือ น้า เย นี้แม้แน, ‘อางช่าง เวอ, ล้อแม้แน อ้องล้า กงากา แอ ค่าบาล่า ล่ากาน เวอ อางก่าอางตูม ก่าตูม แล่เซฺ่อ บ่าจา แน.’ จ้า ค่าพ่าย่า แฮ้มาง เจิ้นเจ้อ บ่าจี่ เย. ");
INSERT INTO bzi_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ยาว ยาง มือ ย่าเจ่น อือนา ม่าย ค่าพ่าย่า มาง ล่าปู่ ล่าคื่อ ย้าง ชู พือ ยาว, อางวื้งอางว้าง ชฺ้าง ด้า อู้งฮ้าว คูง โย้เวอ จาน แอ ปี่ ชีเย.” ");
INSERT INTO bzi_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“ชฺ้าง ป้า ล้า ปี่ ชี อือย่า อางบย่า เย. จ้า ชฺ้าง แช้ยู้ ชีอือ บ่าบย่า เย” แน. ");
INSERT INTO bzi_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ยาว ฟาริสี มู อือมือ อางเง้ เวอ อ่อกแอ คูยาว, พระเยซู จี่ต่าง แฮ้งนา ล้อแม้แน อางเลิ่ง อางซี ชู วา แน เย้ง แอ คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","แฮ้งย้า ยอง มือ ยอง ศิษย์ อือนา แน ชฺ้าง ก่าซ้าด เฮโรด ก้อง อ้อง อือนา ม่า ยาว, พระเยซู นา น้า แอ ปี่ ชี นี้แม้แน, “อ่าจาน เวอ, กงู อางแบ ย้า นา ชฺ้าง อางซืออางปลอง, อางกง่าอางเกิง, อ่าซ่าง มางนา แมก่า บ่าชี่, ");
INSERT INTO bzi_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","นา อางเลิ่ง ม้าม้า พาจาว มาง ชฺ้าง อือนา ฮา ปี่ ซี่ง แฮ้ง ม่าอู่บ แงแน. กงูนา ม่า ล่าวแล, ก่าซ้าดยอคา ซีซาร์ นา ภาษี ฮู่ ปี่ นี้ย่า อางกง่าอางเกิง ลา?” ");
INSERT INTO bzi_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","จ้า พระเยซู ยอง บ่าแม่น แน เย้ง แฮ้งนา อางแบ เย. แฮ้งย้าเย่ ยาง มือ จี่ ชี นี้แม้แน, “ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือ เวอ, นอย่า กงานา บ้าเจอฮาย นืงบาเจ้อฮู ล่า คูแง? ");
INSERT INTO bzi_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","พลู้ ภาษี ตอ แฮ้ง กงานา ทื่อลู่ม ฮู ปี่ ล่าวแล” แฮ้งย้าเย่ ยอง มือ พระเยซู นา ทื่อเหรียญ ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ยาว พระเยซู มือ ยองนา น้า เย นี้แม้แน, “นี้ย่า อ่าซ่าง อางฮูบ แน อ่าซ่าง อางเม้ง เวอ” แน. ");
INSERT INTO bzi_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ยอง มือ พอ คูง เย นี้แม้แน, “ก่าซ้าดยอคา ซีซาร์” แน. ยาว พระเยซู มือ ยองนา ม่า ชี นี้แม้แน, “ซีซาร์ อางเกิ่ง นี้ย่า ซีซาร์ นา ปี่ ปาว, พาจาว มาง อางเกิ่ง นี้ย่า พาจาว มางนา ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ยอง มือ แฮ้แม้แน กงากย่า คู ยาว, บลื่ง ย้าเย่ ยาว ยอง มือ ซฺื่ยกา ฮื่น คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ทื่อนืง กานญา เย สะดูสี มู, ชฺ้างซฺี้ ยาว บ่าแต่ล้า แล่ กงากา แน เจ่อ อือ, พระเยซู นา น้า ล้า คู ชีเย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“อ่าจาน เวอ, โมเสส ย่า กงูนา ม่า ล่าแง นี้แม้แน, ‘ค่าพ่าย่า ล้อมาง อางย่า บ่าจา แน ซฺี้ ยาว ยาง อางแพ้ มางมือ อางอ้าย มาง ค่าบา มางนา ยู้ แง. ยาว อางย่า กงา ยาว อางอ้าย มาง อางเจ้อ แฮ้ง ซื้บแล ปี่ แง.’ ");
INSERT INTO bzi_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","นี้เทอ เวอ ม้องน้าม 7 คู่น จา แง. อางอ้าย ซากาว มาง ค่าบา ยู้ ยาว, อางย่า บ่าจา กื้ง แน ซฺี้น ชี. ");
INSERT INTO bzi_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ยาว ม้องน้าม ที่ 2 ที่ 3 เวอ จาย, ม้องน้าม ที่ 7 มางก้อง เคอ อืมมือ ทื่อช่างกานญา ซฺี้ โค ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","น่อง เวอ ค่าบาย่า มาง คาตา เย ซฺี้ คา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ยาว ม้องน้าม 7 คู่น นี้อือ แต่ล้า แล่ แฮ้นืง ค่าบาย่า นี้ม้า อ่าซ่าง ค่าบา เพล่อ แง? ไม้ ยา ม้องน้าม 7 คู่น คาโคลาโค นี้อือ ค่าบา เพล่ออ่าน น่อ” แน. ");
INSERT INTO bzi_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ยาว พระเยซู มือ ยองนา พอ เย นี้แม้แน, “นอย่า เย้ง ซี คู ชี, ไม้ นอ พระคัมภีร์ แฮ้ง แม่น แน บ่าแบ คู แน พาจาว มาง ล่าที่ แฮ้งนา บ่าแบกงากา คู. ");
INSERT INTO bzi_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ชฺ้างซฺี้ อือย่า แต่ล้าน แล่เมอ อางบี่อางบล้อง บ่ายู่ แล่ก้าน. แน อ่าซ่าง มาง อางบี่อางบล้อง บ่าเพล่อ กา แล่ก้าน. จ้า ยอ เท่วาด่า แม้แน เพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“ซฺี้ ยาว แต่ล้า แล่ง แฮ้ง แบ ซี้ง แนยาว พาจาว มาง ม่า ชี ชี แฮ้ง อ้าน แล่ คู โว นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘กงา อับราฮัม, อิสอัค แน ยาโคบ ยอง พาจาว บอกไว้ มาง ย้า.’ นี้แม้แนยาว พาจาว นี้ม้า ชฺ้างซฺี้ อือ พาจาว บ่าอ่า, จ้า ชฺ้าง อางแต่ อือ พาจาว.” ");
INSERT INTO bzi_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ค่องช่าง อือ พระเยซู นี้แม้แน ม่าอู่บ แฮ้งนา กงากย่า คู ยาว ยอง มือ นาบาตา ย้า นืงบาม่าน คูแง. ");
INSERT INTO bzi_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ฟาริสี อางมู อือ พระเยซู สะดูสี อือนา ฮาย บลื่ง ปี่ ชี แน แบน คู ยาว, ยอง มือ ล้า ช้อน กายาว น้าท้าม ลางกา เย. ");
INSERT INTO bzi_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ยองมู เวอ โมเสส อางลี้บอางล่าว อางแบ เลิ่นเลิ่น มางนา พระเยซู นา ล้า นืงบาเจ้อฮู ชีเย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“อ่าจาน เวอ, โมเสส อางลี้บอางล่าว คาโคลาโค นี้ย่า บ้าเจอ ล้อข้อ ปีนแตปีนนา เลิ่นเลิ่น ม้า?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ยาว พระเยซู มือ พอ เย นี้แม้แน, “พาจาว นอง จี่วีดอางซื้ง เพล่อ ชี่ นี้มางนา นืงบา โค, ก่ามกืด โค, แฮ่ง โค แน ลาก โว! ");
INSERT INTO bzi_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","นี้ย่า ม่าอู่บจี่ต่าง ต่องก่า มาง แน ปีนแตปีนนา เลิ่นเลิ่น ย้างย้า, ");
INSERT INTO bzi_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ยาว ข้อที่ 2 นี้ง ทื่อช่างกานญา นี้แม้แน, ‘ค่าตอง นา ลากจ่าแล่ง แฮ้งแม้แน ยู้มต่องยู้มทาง อือนา ลาก โว!’ ");
INSERT INTO bzi_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","อางลี้บอางล่าว คาโคลาโค แน พาจาวจี่ต่างจี่แต่นฮู อือ แต้ม ชี ชี อือ, อางลี้บอางล่าว 2 ข้อ นี้ง วา แน เค่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ฟาริสี อือ ช้อน น้าท้าม จา กาเมอ พระเยซู มือ ยองนา น้า เย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“นอย่า พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ ชี่ มางนา ล้อแม้ แน เย้ง คูง แง? ยา อ่าซ่าง ก้อง อางเจ้อ ซื้บลือ ชี?” แน. ยาว ฟาริสี มู อืมมือ พอ คูง เย, “ยา ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บลือ ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ยาว พระเยซู มือ น้า แล่ ชีเย นี้แม้แน, “ท้าว บ้าเจอ ก่าซ้าด ดาวิด อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ล่าที่ แฮ้ง ไจ จี่ ม้า, ยาง อางอ่านอางซฺื้อ มางนา ‘จี่วีดอางซื้ง’ แน อางฮ้าว แน. ยาว นี้แม้แน อางจี่ แน, ");
INSERT INTO bzi_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘พาจาว ม้า ยาง ชฺ้าง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้มางนา, แน กงา จี่วีดอางซื้ง เพล่อ ชี แฮ้มางนา นี้แม้แน จี่ช่าง ชี, กงา ล่าปู่ ล่าม่า นี้กย้า ดื้ง ลื่อ ปาว. กงา ชฺ้าง นางนา เม้อ ล่าง อือนา ฮาย นาง ล่าคื่อโบ้ยย้า เพล่อ ปี่ เมอ ตื่อเคอ แน.’ ");
INSERT INTO bzi_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“ซ้ามบ้า ก่าซ้าด ดาวิด มือ, พาจาว มาง ชฺ้าง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้มางนา นี้แม้แน ฮ้าว แง, ‘กงา จี่วีดอางซื้ง มาง’ แน. นี้แม้แนยาว พาจาว มาง ชฺ้าง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้ม้า, ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บล้า ชี. จ้า ยา ก่าซ้าด ดาวิด ล่อบ่าปา ฮื่อ แล่ง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","อ่าซ่าง มาง พระเยซู นา ทื่อม่าง แนม บ่าพอ ตอ กาเย, ยาว แฮ้นืง จายล้า ปี่ ยาว อ่าซ่าง มาง ยางนา เจิ้นเจ้อ บ่าน่าจอ กา เย. ");
INSERT INTO bzi_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","พระเยซู ชฺ้าง มู อือนา แน ยาง ศิษย์ อือนา จี่ช่าง แง นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“อางลี้บอางล่าว ม่าอู่บฮู อือ แน ฟาริสี มู อือย่า, ยอง ล่าที่ แฮ้ง นองนา ม่าอู่บ ล่า อางกงา โมเสส แม้แน ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ยอง ม่าอู่บ แฮ้ง น้าจ่า คู โว, จ้า ยอง ฮา คูง แฮ้งแม้แน บ่าฮาย เค่ คู โจ. ไม้ ยอย่า ทื่อเจ่อ ม่าอู่บ ยาว ทื่อเจ่อ ย้า ฮา คูแง. ");
INSERT INTO bzi_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ยอย่า ยอง อางลี้บ แต่ง ชี แฮ้ง ฮากนา เค้ ฮา ปี่ แง. ฮากนา ตูกพานลาบ้าบ ปี่ กาน แง. จ้า ยอ ชฺ้าง แฮ้อือนา เจิ้นเจ้อ บ่าปล่อง. ");
INSERT INTO bzi_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ยอง กูเจ้อ ฮา นี้ย่า ชฺ้าง อือนา ฮายฮู ปี่ กานแง. ยอ พระคัมภีร์ กานย้า อางฮื่อ แต่ง ยาว, ยอง แมค้อง แน ล่าปู่ โย้เวอ พือ แป่น แล่แง. ยาว พู่ มอง แน ยอง ค่าลาวม่านเงิน โย้เวอ พือ ตีด แล่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“ยอย่า จฺ่าปอต้างปอ ฮา ล่ากาน เวอ แอ เมอ, แน ยิวชฺ้าง โบสถ์ คล้าว โย้เวอ อ้อง ไว้ แล เมอ, ยองมู นี้ย่า ดื้งย้า ปีนแตปีนนา เลิ่นเลิ่น เวอ ดื้ง นา อางซอ คู. ");
INSERT INTO bzi_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ก้าด อือเมอ ย่อกว่า นา อางซอ คู, ไม้ ฮากนา ยองนา ล่าปู่ โญกไว้ ปี่ง แนนอ. แน ฮากนา ยองนา อ่าจาน แน ฮ้าว ปี่ ซี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“จ้า กงา นองนา ม่า ล่าว่า นองมู นู้เวอ อ่าซ่าง มางนา ‘อ่าจาน’ แน บ่าฮ้าว คู โจ, ไม้ นองมู คาโคลาโค นี้ย่า ย่าช่างม้องน้าม กาแอ่นญา. แน นองก้อง อ่าจาน ทื่อม่าง กานญา จา แง.” ");
INSERT INTO bzi_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","“ยาว ชฺ้างอางเมิง นู้เวอ นอ อ่าซ่าง มางนา ‘อ่าโบ้ง’ แน บ่าฮ้าว คู โจ, ไม้ นองก้อง มู่งท่า โย้เวอ อางโบ้ง ทื่อม่าง ญา จา แง. ");
INSERT INTO bzi_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","อ่าซ่าง มางนา นองนา ‘ยอคา’ แน บ่าฮ่าว ปี่ ล่า โจ, ไม้ นอง ยอคา ม้า พาจาว มาง แช้ยู้ ก่าซ้าด เพล่อ ปี่ ชี่ มาง ญา แน. ");
INSERT INTO bzi_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","นองมู เวอ ชฺ้าง ปีนแตปีนนา ม้า ย่าเจ่น เพล่อ นองนา ล่ากาน ว่า ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ไม้ อ่าซ่าง ฮื่อจ่าแล่ง ยางนา อ่าซ่าง มาง บ่านาบบ่าทื่อ. ยาว ชฺ้าง บ่าฮื่อจาแล่ อือนา ฮาก นาบทื้อ คูง. ");
INSERT INTO bzi_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“อางลี้บอางล่าว ม่าอู่บฮู อือ แน ฟาริสี มู อือเวอ, นองนา พาจาว มาง ต้าดต่อน วี่บ่ากไจ ปี่ ล่าง. นอย่า ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ. นอย่า ฮากนา มู่งท่า โย้เวอ บ่าปี่ แล คู. นอง อางโต นี้ย่า บ่าอ่องแล คู จ้า ฮาก อ้องแล คู ซี้ง อือนา บ่าปี่ แล แน ฮา คูแง.” ");
INSERT INTO bzi_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“นองมู อางลี้บอางล่าว ม่าอู่บฮู แน ฟาริสี มู แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ มู อือ เวอ, นองนา พาจาว มาง ต้าดต่อน วี่บ่ากไจ ปี่ ล่าง. นอ เว่อ ย้า ทะเล แน นื้งชฺ่าตี อือเมอ แล คู ยาว, ชฺ้าง ทื่อม่าง ซฺ้า ยาว นอง เจ่อ แม้แน เจ่อ ปี่ แง. จ้า ยางนา กงา ยาว นอย่า ยางนา ฮาย นอง ล่อบ่าปา แน บ่าแม่น ฮา ปี่ แง, แน ยางนา ฮาย ล่าลูก กลา ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“พาจาว ม้า นองนา ต้าดต่อน วี่บ่ากไจ ปี่ ล่าง. นอย่า ชฺ้างแมปอ นา แก้บ้า ม่า คู ชี. นอย่า นี้แม้แน ม่าอู่บ แง ‘บ้าเจอซ่าง โบสถ์อางฮื่อ โย้เวอ ก่ามค่าน ฮา จ่าแล่ แง เจิ้นเจ้อ จองไจ บ่าจา, จ้า จาว่าแน นอง โบสถ์อางฮื่อ คล้าว เวอ ค่าม โย้เวอ ก่ามค่าน ฮา จ่าแล่ นี้ย่า, ก่ามค่าน ฮา ชี แม้แน กงา ฮา คู แง’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ชฺ้างล่าจ่าง แมปอ เวอ, โบสถ์อางฮื่อ ค่าม มางนา ฮาย เซฺิ่งซฺ้าง ปี่ มาง, แน ค่าม นี้ย่า บ้าเจอ ลออาน เวอ ปีนแตปีนนา เลิ่นเลิ่น ม้าม้า ม้า. ");
INSERT INTO bzi_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ยาว นอง มือ จี่แล่ง แง นี้แม้แน, ‘จาว่าแน อ่าซ่าง อางเกิ่งท่านย่า โย้เวอ ก่ามค่าน ปี่ แง เจิ้นเจ้อ จองไจ บ่าจา แน, จ้า อ่าซ่าง อางเกิ่งท่านเซฺ่อ โย้เวอ ก่ามค่าน ปี่ แง แฮ้แม้แน ย้า กงา ฮายเค่ แงแน’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","นาย่า แมปอ ม้าม้า ย้า. อางเกิ่งท่านย่า อางเกิ่งท่านเซฺ่อ แฮ้งนา ฮาย เซฺิ่งซฺ้าง ปี่ แฮ้ง, แน อางเกิ่งท่านเซฺ่อ นี้ย่า ล้อมาง เวอ ปีนแตปีนนา ม้าม้า ม้า. ");
INSERT INTO bzi_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","นี้แม้แนยาว อ่าซ่าง อางเกิ่งท่านย่า โย้เวอ ก่ามค่าน ปี่ แง, ชฺ้าง แฮ้ม้า อางเกิ่งท่านย่า โย้เวอ อางเกิ่งท่านเซฺ่อ แฮ้ง คาตา แน ก่ามค่าน ปี่ ชี แน ทื่อช่างกานญา. ");
INSERT INTO bzi_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ยาว อ่าซ่าง โบสถ์อางฮื่อ โย้เวอ ก่ามค่าน ปี่ แง, ชฺ้าง แฮ้ม้า โบสถ์อางฮื่อ โย้เวอ พาจาว มางนา คาตา แน ก่ามค่าน ปี่ ชี แน ทื่อช่างกานญา. ");
INSERT INTO bzi_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ยาว อ่าซ่าง มู่งท่า มางนา ก่ามค่าน ฮาช่าง แง, ชฺ้าง แฮ้ม้า มู่งท่า เวอ พาจาว ต่างอี่ อางฮื่อ ดื้ง มางนา ก่ามค่าน ปี่ ชี แน ทื่อช่างกานญา. ");
INSERT INTO bzi_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“อางลี้บอางล่าว ม่าอู่บฮู อือ แน ฟาริสี มู อือ เวอ, พาจาว ม้า นองนา ต้าดต่อน วี่บ่ากไจ ปี่ ล่าง, นอย่า ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือ, นอย่า คาโคลาโค ทื่อแช่ ปูน แน จา อือ พาจาว มางนา ทื่อ ปูน ท่าน เวิม มือ, ฮอมนู้ม พ่า ฮอมป้อม นือ แน ยี่หร่า อือ คาตา ย้า ท่าน คู แง, จ้า นอย่า พระคัมภีร์ โย้เวอ อางเลิ่ง ปีนแตปีนนา อือนา ลู้ม คูชี, อางเลิ่ง แฮ้อือย่า อางเลิ่ง อางกง่าอางเกิง อือ, ลากซื่งกง่ากย้า อือ, แน อางเลิ่งอางซืออางปลอง อือ. ทื่อแช่ ปูน แน จา อือ พาจาว มางนา ทื่อ ปูน ท่าน แฮ้ แม่น คางญา, จ้า ม่าอู่บจี่ต่าง ปีนแตปีนนา นี้อือ คาตา แน ฮา คูโว. ");
INSERT INTO bzi_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ชฺ้าง ชฺ้างแมปอ นา แก้บ้า ม่า มาง เวอ, นอย่า ล้างต้างเซฺ่อ โย้เวอ อางบา อ้อง ชี มาง ยู้ อ่อก แง, จ้า นอย่า อูฐ อางโต อางโต ย้า นาง อ้อง แอ ปี่ง แง.” ");
INSERT INTO bzi_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“อางลี้บอางล่าว ม่าอู่บฮู แน ฟาริสี มู ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือ เวอ, พาจาว ม้า นองนา ต้าดต่อน วี่บ่ากไจ ปี่ ล่าง, นอย่า ลอค่อลอจา ล้างก้อกแก้ว อางเง้ โย้เวอ แอ่ แน จอ คูแง, จ้า อางคล้าว โย้เวอ ตานฮา แน ค่าตอง อางเลิ่ง เย้ง แฮ้ง แอ่ ย้า จา แง. ");
INSERT INTO bzi_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ฟาริสี แมปอ อือ เวอ, ลอค่อลอจ้า อางคล้าว อือเมอ จอ ปาโน. ยาว อางเง้ อืมมือ เซฺิ่งซฺ้าง แง.” ");
INSERT INTO bzi_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“พาจาว ม้า นองนา ต้าดต่อน วี่บ่ากไจ ปี่ ล่าง. อางลี้บอางล่าว ม่าอู่บฮู อือ แน ฟาริสี มู อือ เวอ, นอย่า ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือ, นอย่า ท้ามชฺ้างซฺี้ชีย้า อางเง้ เวอ ซี้ อางป่อน แม่นมาง แน ต่า ยาว, อางคล้าว ป่ากย่า เวอ ชฺ้างซฺี้ อางกง่าว แน ม้างม้าเจ้อ อางโซอางซา อือ ปลื้ง แน จา ชี อือ ช้อด ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","นองมู นี้ย่า อางเง้ โย้เวอ ชฺ้าง อือ ฮู ยาว พาจาวจี่ต่าง ฮายเค่ อือ แม้แน จา แง, จ้า ม้าม้า นี้ นองมู นี้ย่า แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ แน นืงบา โย้เวอ อางเลิ่ง บ่าแม่น อือ แอ่ ย้า จา แง.” ");
INSERT INTO bzi_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“พาจาว ม้า นองนา ต้าดต่อน วี่บ่ากไจ ปี่ ล่าง. อางลี้บอางล่าว ม่าอู่บฮู อือ แน ฟาริสี มู อือ เวอ, นอย่า ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือ, ไม้ ค้าแต้ ย่า นอง อางฮู่ อางพี่ อือ พาจาว มาง จี่ต่างจี่แต่นฮู อือนา แซ่ คู ชี. จ้า อ่ามือ นอย่า นอง อางฮู่ อางพี่ อือ แซ่ ชี อือนา ท้ามชฺ้างซฺี้ชีย้า แม่นมาง แน แต่ง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","จ้า นอย่า จี่ คู แง นี้แม้แน, ‘จาว่าแน กงู อ่าฮู้ อ่าพี้ ยอง จี่น เวอ จา อู้, กงูย่า ยอง แม้แน พาจาวจี่ต่างจี่แต่นฮู อือนา บ่าเค่ แซ่’ แน.” ");
INSERT INTO bzi_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","นี้งย้า ฮายแบ ปี่ แง นอย่า พาจาวจี่ต่างจี่แต่นฮู อือนา แซ่ ชี อือ อางอ่านอางซฺื้อ ม้าม้า อือ แน. ");
INSERT INTO bzi_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","แฮ้แม้แนยาว นอง อางฮู่ อางพี่ อือ, อางบล่าบ ฮา ชี ชี อือ เปิน แน แอ ฮา แอ คู ปาว. ");
INSERT INTO bzi_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“อื้อล้าง อางปีด อือ เวอ, นอย่า ล้อแม้แน ล่าลูก แฮ้ง กงาปูน แล่ คู แน. ");
INSERT INTO bzi_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“กงา ชฺ้าง กงานา จี่แต่นล่าฮู อือ, ชฺ้าง วี่ไซป้านญา อางจา อือ แน อางลี้บอางล่าว ม่าอู่บฮู อือนา ซฺาลือ ปี่ เวิม, นอง มือ ยองนา ซฺื่ย แซ่ แล แง, แน ทื่อบ่า นา ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด แซ่ แล แง, ทื่อบ่า นา ยิวชฺ้าง โบสถ์ โย้เวอ ซฺื่ย ตื่อชืก คูแง. แน ยองนา กูเมิง ย้า เค่ ซฺ้า คูแง. ");
INSERT INTO bzi_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“นี้แม้แนยาว ชฺ้างอางเมิง นู้เวอ พาจาวจี่ต่างจี่แต่นฮู อือ ซฺี่ แฮ้ย่า นองก้อง กลา แง, อาเบล อางกง่าอางเกิง มาง ซฺี่ แฮ้งจาย เศคาริยาห์ เบเรคิยาห์ อางย่า โบสถ์อางฮื่อ อางเกิ่งท่านย่า โย้เวอ, นองมู ยิวชฺ้าง อือ แซ่ ยาว ซฺี่ เซฺ่อ อ่อก ลือ ชี มาง ซฺี่ แฮ้ง คาตา ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","“กงาย่า อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า นี้แม้แน, ค้าแต้ ชฺ้าง อือ อางเลิ่ง บ่าแม่น ฮา ชี แฮ้ย่า อามือ ชฺ้าง อือ วี่บ่ากกงาไจ คูแง.” ");
INSERT INTO bzi_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“เอ้อ เยรูซาเล็ม อางเมิง ชฺ้าง อือ เวอ, นองมู นี้ย่า พาจาว มาง จี่ต่างจี่แต่นฮู อือนา ลอบา จาน แซ่ ชี. ยาว ไลเทอ ย้า กงา นอง อางเมิง ชฺ้าง อือนา ค่อด ชี ซี้ง แง, ยาอางบา มาง ยาอางย่า อือนา อางต้อง แฮ้ง ไจ ค่อด ชี ชีอือ ช้อด แน, จ้า นอ กงานา แฮ้แม้แน บ่าปี่ฮา ล่า. ");
INSERT INTO bzi_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","อามือ ย่า พาจาว ม้า นอง อางเมิง โย้เวอ บ่าดื่ง กาน. ");
INSERT INTO bzi_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","นู้จายแล ปี่ นี้ย่า นอย่า กงานา บ่ากงามย้าง ล่ากาน, จ้า นอง นี้แม้แน จี่ เมินญา ‘พาจาว มาง ชฺ้าง ซฺาลือ ปี่ ชี่ มางนา สรรเสริญ ฮา แง’” แน. ");
INSERT INTO bzi_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","พระเยซู โบสถ์อางฮื่อ โย้เวอ ย่อ อ่อก เมอ, พระเยซู ศิษย์ อืมมือ พระเยซู นา โบสถ์อางฮื่อ โย้เวอ ตึก อือ ม่าย ฮู ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ยาว ยาง มือ ศิษย์ อือนา จี่ช่าง เย นี้แม้แน, “ตึก นี้อือนา มย้าง ย่า อ่าลา? กาญ่าม เวอ ตึก นี้อือ ก่างพยา แง. ลอบา ตาก ลางกา ชี นี้ย่า เลิง พู่นพ่าน แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","พระเยซู มะกอกเทศ ตาแซ้ โย้เวอ ทื่อม่าง แน ดื้ง จา เมอ, ยาง ศิษย์ อืมมือ ยางนา ซฺ้า ล้า ยาว น้า คูง เย นี้แม้แน, “นี้เลิ่ง อาล่อม ตอล้า แง? แน นาง พ่าวลือ แล่ง อางนืง แฮ้ย่า ล้อนืง เวอ แน กงู ล้อแม้ แบตอ กงากา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ยาว พระเยซู มือ พอ เย นี้แม้แน, “อางโต แล่มจ่าแล่ คูโว! อ่าซ่าง มางนา บ่าปี่ จ้อบ ปี่ คู โจ เป, ");
INSERT INTO bzi_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ไม้ ชฺ้างอางบย่า ย้า กงา อางเม้ง แฮ้ง จี่อ้าง จ่าแล่ง แง, ยอย่า พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ ชี่ มาง แน ฮาจ่าแล่ คูแง, ยาว ชฺ้างอางบย่า นา ฮาย เจ่อ ปี่ง แง. ");
INSERT INTO bzi_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","จาว่าแน นอง ดื้ง โย้เวอ แท้ แน ฮาก ‘สงคราม ตอล้า ชี, สงคราม ตอล้า ชี’ แน กงากย่า คู ยาว บ่าแค คูโจ, ไม้ แฮ้แม้ ม้าม้า ย้า ตอล้า แง. ยาว นี้เลิ่ง ตอล้าออน เป. จ้า ชฺ้างอางเมิง ลีน ย่าง บ่าเคอ กาซื้ง เป. ");
INSERT INTO bzi_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ชฺ้าง ไลเจ้อไลจาด ย้า แซ่ กาแง. อางเมิง ไล เมิง ย้า แซ่ กาแง. ชฺ้างอางเมิง นู้เวอ กูต่องกูตี่ ย้า มี่ซี่อืน แง แน ฮ่าง จฺ่าเกิ่ง เคม แง. ");
INSERT INTO bzi_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","นี้ย่า ชฺ้างอางเมิง นู้เวอ อางนืงลีน แฮ้นืง ชา เคิน ล้า เมอ, ต่องก่าต่าง ตูกพานลาบ้าบ ย้าง ย้า, ค่าบาย่า อือ อางย่า ชาเกิ้ด เมอ ด้ากย้าง แฮ้ง ป้าค้า ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“นองนา ฮาก ชู แล ฮาย ลาบ้าบ ปี่ ล่ายาว แซ่ ล่าง, แน กงา ศิษย์ เพล่อ ชี แฮ้ง ปาปาย ย้า กูเมิง โย้เวอ ชฺ้าง อือ นองนา เม้อ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","แฮ้ญ่าม เคินล้ายาว ชฺ้าง อางอีบ่าอ่า ยอง เจ่อ แฮ้ง วี คูแง. นืงบา บ่าซือบ่าปลอง กาแน บ่าแม่น ฮา กายาว เม้อ กาแง. ");
INSERT INTO bzi_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ยาว พาจาวจี่ต่างจี่แต่นฮู ม้าม้า บ่าอ่า อือ อางบย่า ย้า ตอล้า แง, แน ชฺ้าง นา อางบย่า ย้า จ้อบ คู แง. ");
INSERT INTO bzi_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","อางเลิ่ง บ่าแม่น อือ บย่า เค่ แง แฮ้งย้า ชฺ้าง อืมมือ บ่าลาก กา คู. ");
INSERT INTO bzi_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","จ้า ชฺ้าง อางเลิ่ง บ่าแม่น นี้ อือ ตอล้า ชี แฮ้ง เปิน เมอ เคอ แน, โอ้ด กงากา ชี อือย่า กงาปูน จ่าแล่ คูแง. ");
INSERT INTO bzi_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ยาว พาจาว มาง อางเมิง อางเลิ่ง อางแม่น แฮ้งมือ ชฺ้างอางเมิง นู้เวอ ต้าว ย้า ป่าว แอ ปี่ง แง, ไม้ กูเจ้อกูจาด อือนา อางเลิ่ง อางแม่น นี้อือ กงากย่า กงาแบ ปี่ง นอ, ยาว ชฺ้างอางเมิง ลีน แฮ้งมือ เคอ ลือ แง. ");
INSERT INTO bzi_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ม้างม้าเจ้อ ช่าคาบอล้อ พาจาวจี่ต่างจี่แต่นฮู ดาเนียล มาง มอ ชี ชี แฮ้ย่า โบสถ์อางฮื่อ โย้เวอ กงามย้าง คูแง.” (นี้ข้อย่า อ้านฮู อือ แม่น แน อ้าน ยาว แบ ปี่ โว.) ");
INSERT INTO bzi_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“แฮ้ญ่าม เคินยาว ชฺ้าง ยูเดีย แควน โย้เวอ ดื้ง อือนา ตาแซ้ ท่า โย้เวอ ม่าย ฮื่น แล ปี่ว. ");
INSERT INTO bzi_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ชฺ้าง ยู้มมู้ง อางท่า ดื้ง ชี อือนา, ยู้ม คล้าว โย้เวอ อางเกิ่งอางก้อ บ่าปี่ อ้อง กอ แล โจ. ยองนา อางไว่ แน ตาแซ้ โย้เวอ ฮื่น แล ปี่ โว! ");
INSERT INTO bzi_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ชฺ้าง น่า ย้า โย้เวอ จา คูชี อือนา, ยู้ม คล้าว โย้เวอ อางก่าอางตูม บ่าปี่ อ้อง ยู้ แล โจ. ยองนา อางไว่ แน ตาแซ้ โย้เวอ ฮื่น แล ปี่ โว! ");
INSERT INTO bzi_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","แฮ้ญ่าม ย่า ชฺ้างอู่ปู่ม แน ชฺ้าง อางย่า อือนา ลองแปด ชู่ ปี่ง อือ อางญ่าม แคคาบอล้อ แน ชี่ ย่าง ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","พาจาว มางนา อธิษฐาน ฮา คูปาว, ฮื่น อางนืง แฮ้นืง ย่า ช่อมย่า แน ลองนืง โย้เวอ บ่าปี่ กลา โจ. ");
INSERT INTO bzi_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ไม้ แฮ้ญ่าม เวอ อางตูกอางพาน อางฮื่อ ตอล้า แง. ชฺ้างอางเมิง บ่าจา กาซื้ง เมอ จาย แน อามือ เคอ นี้ย่า นี้แม้แน บ่าตอล้า กาซื้ง เป. แน อางเลิ่ง นี้แม้แน ตอล้า ชี นี้ย่า กาญ่าม เวอ บ่าจา แล่ก้าน. ");
INSERT INTO bzi_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","แน จาว่าแน พาจาว มาง อางญ่าม แฮ้ง บ่าฮา กื้น ปี่ ยาว, อ่าซ่าง มาง ทื่อม่าง แนม จี่วีด บ่ากงาปูน แล่. จ้า ยาง ชฺ้าง แช้ ชี ชี อือนา ฮูจ่าปาปาย แฮ้งย้า ยางมือ อางญ่าม ย่าง ฮา กื้น ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“แฮ้ญ่าม เมอ ชฺ้าง อือ นองนา นี้แม้แน ม่า ล่า เมอ, ‘แฮ้! พาจาว มาง ชฺ้าง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้ม้า นู้เวอ จาน ญา’ แน. บ่าอ่ายาว ‘โฮ้ก! พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้ม้า โย้เวอ จาน ญา’ แน. บ่าเจ่อ จ่า โจ. ");
INSERT INTO bzi_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ไม้ แฮ้ญ่าม เมอ ชฺ้าง อางอีบ่าอ่า จา แง, ยอ ฮากนา นี้แม้แน ม่า แง, ยอ พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้มาง ย้าแน, บ่าอ่ายาว ยอ พาจาวจี่ต่างจี่แต่นฮู เพล่อ แงแน. จ้า กานแตว บ่าอ่า เป. แน ยองมู นี้ย่า อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา แง, ไม้ ชฺ้าง พาจาว มาง แช้ยู้ ชี อือนา จ้อบ แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","บ่าลู่ม คูโจ! กงาย่า กูย่างกูเจ้อ ย้า ม่า ชี ลางออน ฮาย ล่าแอ่. ");
INSERT INTO bzi_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“ยาว อ่าซ่าง นองนา นี้แม้แน ม่า ล่า เมอ, ‘โฮ้ก พระเยซู มาง ตี อางกืออางคาก โย้เวอ จา แง’ แน ม่า ล่า เมอ บ่าอ่อกแอ คูโจ. แน ‘พระเยซู มาง อางฮ้อง โย้เวอ จา แง’ แน ม่า ล่าเมอ บ่าเจ่อ คูโจ เป. ");
INSERT INTO bzi_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ไม้ กงาชฺ้างอางย่า มาง ลือ เมอ, เจ้ง ย้า กงามย้าง คู แง, มู่งท่า เวอ มู่งบล่าบ แม้แน ย้า ทื่อปล่าก จาย ทื่อปล่าก ป่ากย่า บล่าบ แอ แง. ");
INSERT INTO bzi_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ทื่อช่างกานญา นอ ฮาย่า อีแร้ง อางมู ชฺ้างซฺี้ อางปู่ จฺ่า อือนา มย้าง เมอ แบ แง ชฺ้างซฺี้ ปู่ จา แงแน. ยาว กงา นองนา อางเลิ่ง อู่บน้า ปี่ ล่า ชีแฮ้ง ตอล้า เมอ, แบ ชี คู โว เป กงา พ่าวลือ ญ่าม ย่าง ชา เคิน ญา. ");
INSERT INTO bzi_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ซฺ้อก แน ตูกพานลาบ้าบ แฮ้ญ่าม เปิน เมอ, ‘มู่งนื่ง นี้ย่า วื้งว้าง แง, แน อู่ลา แฮ้ บ่าแปล่นบ่าซ่า กาน. อู่กื่อ อืมมือ มู่งท่า เวอ จาย กลาลือ แง. แน กูย่างกูเจ้อ มู่งท่า โย้เวอ จา อืมมือ ยืก แง.’ ");
INSERT INTO bzi_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“แฮ้ญ่าม เมอ มู่งท่า โย้เวอ ฮู ยาว แบ แง. กงาชฺ้างอางย่า เพล่อ ชี่ มาง ชา ลือ แงแน. ยาว ชฺ้างอางเมิง โย้เวอ ชฺ้าง คาโคลาโค อืมมือ อู้งฮ้าว คูง แง. ยาว ชฺ้าง อืม กงา มู่งบื่น อางป่อน โย้เวอ ทื่งกง่า แน ลือ นา มย้าง แง, แน กงาก้อง ล่าที่ อางฮื่อ ปลื้ง ย้า จา แง. ยาว กงา อางโต โย้เวอ อางแปล้นอางซ้า อ่อกล้า แง. ");
INSERT INTO bzi_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ยาว ซ้าดอางคย้าว มี เซง บื้ง แน กงากย่า แง, แน กงาย่า เท่วาด่า อือนา พาจาว มาง ชฺ้าง แช้ยู้ ชี อือนา ซฺ้า ช้อน กา ปี่ แง. เท่วาด่า อือย่า ชฺ้างอางเมิง นู้เวอ ต้าว ย้า พาจาว มาง ชฺ้าง แช้ยู้ ชี อือนา ซฺ้า กว่า แง, ชฺ้างอางเมิง ทื่อปล่าก ป่ากย่า จาย ทื่อปล่าก ป่ากย่า เคอ ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ซื่อไค่มี้ล่อก ป้าง โย้เวอ ฮู กาโน ล่างาม โย้เวอ อางพ่า พลอง อ่อก ยาว, นอง มือ แบ คู แง ล้องมย้า ย่าง ชา เคิน ลางญา แน. ");
INSERT INTO bzi_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ทื่อช่างกานญา, นอง อางเลิ่ง ตอล้า ชี นี้อือ กงามย้าง เมอ, นอง แบ คูโว กงา ทื่อเทอ ลือ แล่ง อางญ่าม ชา เคอ ชีแน. ");
INSERT INTO bzi_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","กงา ม่ายแบ ปี่ ล่าว่า, อางเลิ่ง คาโคลาโค นี้อือ ตอล้า เมอ, อามือชฺ้าง อือ บ่าซฺี่ โค กางซื้ง แน. ");
INSERT INTO bzi_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","มู่งท่า แน ชฺ้างอางเมิง นี้ย่า โปยว แอ แง. จ้า กงา จี่ต่าง นี้ย่า โปยว แอ นืง บ่าจา.” ");
INSERT INTO bzi_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","พระเยซู จี่ แล่ง นี้แม้แน, “อ่าซ่าง มาง บ่าแบ อางญ่าม แฮ้ย่า ล้อนืง เคอ ล้า แงแน. ซ้ามบา เท่วาด่า อืม บ่าแบ. กงา พาจาวอางย่า เพล่อ ชี นี้มาง บ่าแบ. อ่าโบ้งพาจาว ญา อางแบ แน. ");
INSERT INTO bzi_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“ยาว กงา พ่าวลือ แล่ แฮ้นืง ย่า โนอาห์ จีน แฮ้งแม้แน เป. ");
INSERT INTO bzi_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","แฮ้ญ่าม เมอ ชฺ้าง อือ แต่งงาน ฮา จฺ่าต้าง ม่อนซ้า คูแง. จ้า โนอาห์ ล้อง คล้าว โย้เวอ อ้องแล เมอ ซฺ้อก ย้า ล้าง ย่าง ทู้ม ล้า แง, ยาว ยองมู แฮ้ง ล้าง นื่อแซ่ แล่ โค ชี. ");
INSERT INTO bzi_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ชฺ้าง แฮ้อือย่า บ้าเจอ ตอล้า แงแน บ่าแบจ่าแล่ คู เย. ยอง คาโคลาโค แฮ้งนา ล้างทู้ม ปูย แอ ปี่ เมอ เคอ ย้าเย่. กงา ลือ เมิม แฮ้แม้ย้า ตอล้า แง. ");
INSERT INTO bzi_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“แฮ้ญ่าม เมอ ค่าพ่าย่า 2 คู่น ย้า ว่าย จา เมอ, ทื่อม่าง กงานา เจ่อ ล่าง มางนา มู่งท่า โย้เวอ ซฺื่ยแล แง. ทื่อม่าง กงานา บ่าเจ่อ ล่าง มางนา ชีช่าง แง. ");
INSERT INTO bzi_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ยาว ค่าบาย่า 2 คู่น ทื่งกง่า แน กอท่อง จา เมอ, ทื่อม่าง กงานา เจ่อ ล่าง มางนา มู่งท่า โย้เวอ ซฺื่ยแล แง. ทื่อม่าง กงานา บ่าเจ่อ ล่าง มางนา ชีช่าง แง. ");
INSERT INTO bzi_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“แฮ้แม้แนยาว แม่น แน ล่อ ฮู คู โว, ไม้ นอง จี่วีดอางซื้ง ม้า ลอญ่าม เวอ ลือ นามบ่าแบ. ");
INSERT INTO bzi_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","นองมู นี้ย่า แบ ชี คู โว! จาว่าแน ยู้มซื้ง มาง แล่ค่าว อือ อ่าล่อม ล้า คู แงแน แบนลาง ยาว, ยา ท้านย้า บ่ายู่ แน แล่ค่าว มางนา ยาง ยู้ม คล้าว โย้เวอ บ่าปี่ อ้องล้า. ");
INSERT INTO bzi_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","นองมู นี้ง ทื่อช่างกานญา อางโต แฮ้ง แม่น แน แล่ม ล่อ คู โว! ไม้ กงา พ่าวลือ เมอ, นอ บ่าแบจ่าแล่ คู แน บ่าเย่ง เคอ กา, กงา อาล่อมเมอ พ่าวลือ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ยาว พระเยซู มือ นี้แม้แน จี่ แล่ง, “ย่าเจ่น ยอคา อางซืออางปลอง แน อางแอ้น ม้า อ่าซ่าง เวอ? กงา ม่ายแบ ปี่ ล่าว่า เจ้านาย มาง ฮาก ค่อง เวอ แอน ยาว, ยางมือ ย่าเจ่น อางซืออางปลอง มางนา ม่าย ย่าเจ่น ทื่อบ่า อือนา ฮูพลา ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","เจ้านาย มาง พ่าวลือ แล่เมอ ยาง ย่าเจ่น มาง, ยาง ล่ากาน ม่ายว่า ปี่ ชี แฮ้ง แม่น แน ว่า ชี แน มย้าง เมอ, ยางมือ ย่าเจ่น แฮ้มางนา โญกจ่าญ่อ จ่างแง. ");
INSERT INTO bzi_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","กงา ม่ายแบ ปี่ ล่าว่า, เจ้านาย มาง ย่าเจ่น แฮ้มางนา ย่าเจ่น ยอคา ต้างแต่ง เพล่อ ปี่ ยาว, ยาง ล่ากาน แน อางเกิ่งอางก้อ คาโคลาโค แฮ้ง ฮูพลา ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","จ้า จาว่าแน ย่าเจ่น แฮ้มาง บ่าแม่น แน เย้ง ยาว นี้แม้แน, ‘กงา เจ้านาย ม้า บ่าพ่าว ล้า แล่ง กาซื้ง’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ยาว ยาง มือ ย่าเจ่น อางช่าง อือนา ตื่อชืก ยาว, แต่ค่าต้างมู อือก้อง ทื่งกง่า แน แต่ค่า ต้าง ชี. ");
INSERT INTO bzi_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ยาว ยาง เจ้านาย มาง ล้า เมอ, ยา บ่าแบจ่าแล่ แน อางนืง อางญ่าม แฮ้งนา บ่าแบ. ");
INSERT INTO bzi_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ยาว ยาง เจ้านาย มางมือ ยางนา ตื่อชืก ก่าอ่อก ยาว, ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือก้อง แอ ดื้ง ปี่ง แง, โย้เวอ อู้งฮ้าว ด้า โฮ้กฮ้าว อางเซง อือ แอ่ ย้า จา แง.” ");
INSERT INTO bzi_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","พระเยซู จี่ แล่ง นี้แม้แน, “พาจาว มาง อางเมิง แฮ้ย่า เจ้าสาว อางช่าง ทื่อแช่ คู่น, กู่มบี่ท่อ จฺ่อ ท่าม อ่อกลือ ยาว เจ้าบ่าว มางนา ลือ ลาบ แม้แน ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ยองมู โย้เวอ ชฺ้าง อางจ่าง 5 คู่น แน ชฺ้าง อางแอ้น 5 คู่น เย. ");
INSERT INTO bzi_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ย่าบี่ อางจ่าง 5 คู่น อือ กู่มบี่ท่อ ย่าง ฮ้าน แอน ชี, จ้า นามมาน ย่าง ฮ้านเพ้อ แน บ่ากงา ฮ้าน แอ เย, ");
INSERT INTO bzi_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","จ้า ค่าบาย่า อางแอ้น 5 คู่น อือย่า กู่มบี่ท่อ ย่าง ฮ้าน แอน ยาว, นามมาน ย่าง คาตา แน ฮ้านเพ้อ แน ฮ้าน แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ยาว เจ้าบ่าว มาง ล้า แฮ้ย่า อางกล่าม เย. แฮ้งเย่ ย่าบี่ คาโคลาโค อืมมือ ยู่ ซี้ ยาว ยู่ มู่งนื่งอ่อง คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ยาว 12 โมง มู่งคี่ เคิน เมอ ยองมือ อางเซง ฮ้าว นา กงากย่า ชีเย นี้แม้แน, ‘เจ้าบ่าว มาง ลืน ชา อางไว่ แน อ่อกลือ ลาบต้อน คู โว’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“ยาว แฮ้งย้าเย่ เจ้าสาว อางช่าง อืมมือ ทานล้า ยาว กู่มบี่ท่อ ย่าง ท่อ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ยาว ย่าบี่อางจ่าง อืมมือ ย่าบี่อางแอ้น อือนา จี่ช่าง คู เย นี้แม้แน, ‘นอง นามมาน แฮ้ง กงูนา เปิ่ง ปี่ ล่าปาว, กงู กู่มบี่ท่อ ย่าง นามมาน โค ชี ยาว ชา ซฺู่ แง.’ ");
INSERT INTO bzi_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“ยาว ย่าบี่อางแอ้น อืมมือ ม่า ชีเย นี้แม้แน, ‘บ่ากงา เป นามมาน นี้ย่า กงู คาโคลาโค นี้ย่า บ่าล่อ กา, นอย่า ฮาก นามมาน ก่อง โย้เวอ ป้า วือ แอ คู ปาว’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“ย่าบี่อางจ่าง อือ นามมาน วือ แอ เมอ เจ้าบ่าว มาง เคอ ลือ ชีเย, ยาว เจ้าสาว อางช่าง นามมาน อางจา อืมมือ เจ้าบ่าว มาง ก้อง ค่าบาล่า ล่ากาน โย้เวอ เค่ อ้อง แลน ชีเย. ยาว ล้องก้อ ย่าง พี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ยาว ย่าบี่อางจ่าง อือ เคอ ล้าเมอ ยองมือ ฮ้าว คูง เย นี้แม้แน, ‘เจ้านาย เวอ, กงูนา ล้องก้อ นี้ง พอง ปี่ ล่า ปาโน’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“จ้า เจ้าบ่าว มาง พอ เย นี้แม้แน, ‘กงาย่า นองนา ม่ายแบ ปี่ ล่าวา, กงา นองนา บ่าแบล่ากงา กา’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“นี้แม้แนยาว แม่น แน ล่อฮู คูโว! ไม้ นอ บ่าแบ อางญ่าม แฮ้ ล้อนืง เคอ ล้า แงแน.” ");
INSERT INTO bzi_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","พระเยซู จี่ แล่ง นี้แม้แน, “บ่าอ่ายาว พาจาว มาง อางเมิง แฮ้ย่า ค่าพ่าย่า ทื่อม่าง ฮาก อางเมิง โย้เวอ ชา แอ ยาว, ยาง ย่าเจ่น อือนา ฮ้าว ล้า ปี่ ยาว, ยาง อางเกิ่ง แฮ้ง ชี ฮูพลา ปี่ มางนา เพ้ก แง เป. ");
INSERT INTO bzi_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ยา ย่าเจ่น ทื่อม่าง มางนา พลู้ 5 เหรียญ, ย่าเจ่น ทื่อม่าง มางนา 2 เหรียญ, ยาว ย่าเจ่น ทื่อม่าง มางนา ทื่อ เหรียญ ปี่ ชี, ยอง ฮูพลา กงากา แฮ้ง วา แน ปี่ ฮูพลา ปี่ ชี. ยาว ยาง มือ แก้บ้า ย่อ แลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“ย่าเจ่น พลู้ 5 เหรียญ กงา ชี ม้า, ซฺ้อก ย้า พลู้ ย่าง ฮ้าน ก่องก้า แล ยาว พลู้ 5 เหรียญ กงา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ยาว ย่าเจ่น พลู้ 2 เหรียญ กงา ชี ม้า พลู้ ย่าง ฮ้าน ก่องก้า ยาว พลู้ 2 เหรียญ กงา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","จ้า ย่าเจ่น พลู้ ทื่อ เหรียญ กงา ชี ม้า เจ้านาย มาง พลู้ ปี่ ชี ย่าง ค่ามตู่ ตู่ย พูม ชี ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“เจ้านาย มาง แอ มล่าง ยาว พ่าวล้า แล่เมอ. ยาง มือ ยาง ย่าเจ่น อือนา น้า ชีเย พลู้ ย่าง บ้าเจอล้อแม้ ฮา คู แอ แน. ");
INSERT INTO bzi_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ย่าเจ่น พลู้ 5 เหรียญ กงา ชี มางมือ, ยาง เจ้านาย มางนา พลู้ 5 เหรียญ ก่องก้า กงา ชีย้าง คาตา ฮ้าน ปี่ ล้า ชีเย. ยาว ยาง มือ ยาง เจ้านาย มางนา ม่า เย นี้แม้แน, ‘เจ้านาย เวอ, นาง กงานา พลู้ 5 เหรียญ ฮูพลา ปี่ ล่า ชี นี้ย่า กงา กำไร 5 เหรียญ กงา แล่แอ่.’ ");
INSERT INTO bzi_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“แฮ้งย้าเย่ เจ้านาย มางมือ ยางนา ม่า นี้แม้แน, ‘อางแม่น ย้าเป นา ย่าเจ่น อางแม่น แน อางซืออางปลอง. นาย่า อางเลิ่ง อางอี เวิม มือ อางซืออางปลอง. กงา นางนา อางเกิ่งอางก้อ บย่า แน ฮูพลา ปี่ ล่าแน. กงาก้อง ทื่งกง่า แน จฺ่าต้าง ม่อนซ้า ล่าปาว.’ ");
INSERT INTO bzi_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“ยาว ย่าเจ่น พลู้ 2 เหรียญ กงา ชี มางมือ, ยาง เจ้านาย มางนา ล้า ซฺ้า ล้า ยาว ม่า เย นี้แม้แน, ‘เจ้านาย เวอ นาย่า กงานา พลู้ 2 เหรียญ ฮูพลา ปี่ ล่าแง. กงาย่า ก่องก้า ยาว กำไร 2 เหรียญ กงา แล่แอ่’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“แฮ้งย้าเย่ เจ้านาย มาง มือ ยางนา ม่า ชี นี้แม้แน, ‘อางแม่น ย้าเป นา ย่าเจ่น อางแม่น แน อางซืออางปลอง. นาย่า อางเลิ่ง อางอี เวิม มือ อางซืออางปลอง. กงา นางนา อางเกิ่งอางก้อ บย่า แน ฮูพลา ปี่ ล่าแน. กงาก้อง ทื่งกง่า แน จฺ่าต้าง ม่อนซ้า ล่าปาว.’ ");
INSERT INTO bzi_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“ยาว ย่าเจ่น พลู้ ทื่อ เหรียญ แน กงา ชี มางมือ ล้ายม่า ล้า ชีเย นี้แม้แน, ‘เจ้านาย เวอ, กงา อางแบ นาย่า ชฺ้าง อางโซ้กอางไล้, แน นาย่า ฮาก ตี เวอ อางคลาอางซ้าง นาง บ่ากงาคลาบ่ากงาซ้าง อือ ย่าด ยู้บู้ แง. ");
INSERT INTO bzi_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","กงา แค ค้า ยาว แฮ้งย้า นาง พลู้ ปี่ ล่า ชี่ แฮ้ง นื้งชฺ่า เวอ ค่ามตู่ ตู่ย ยาว พูม แอ, นู้ จา ญา นาง พลู้ ย้าง’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“แฮ้งย้าเย่ เจ้านาย มาง อี่ ชี นี้แม้แน, ‘ย่าเจ่น บ่าเม่น แน อางคลื่อ เวอ, นาย่า อางแบ กงาย่า ฮาก ตี เวอ, อางคลาอางซ้าง กงา บ่ากงาคลาบ่ากงาซ้าง อือ ย่าดยู้ ปี่ แงแน, ");
INSERT INTO bzi_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ท้าว นี้แม้แนยาว นาย่า กงา พลู้ แฮ้ง ธนาคาร เวอ บ่าฮ่าน ชี แล แน, ไม้ กงา พ่าว ลือ แล่ เมอ กงา พลู้ แฮ้ง แน คี้ดอก แฮ้ง คาตา น่อ กงา แง’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ยาว เจ้านาย มาง มือ ยาง พลู้ ย่าง ย่าเจ่น พลู้ ทื่อแช่ เหรียญ จา มางนา ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ไม้ ชฺ้าง ยอง อางเกิ่ง ค้าจา แฮ้ง จองไจ ฮา ตอล้า ปี่ อือ, ยอ อางอ้าน แฮ้ง ล่อบ่าปา กงา แล่แง. จ้า ชฺ้าง ยอง อางเกิ่ง ค้าจา แฮ้ง เจิ้นเจ้อ จองไจ บ่าฮา ตอล้า ปี่ ยาว, ยอง ค้าจา แฮ้ย่า โค ย้า ยู้ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ยาว ยาง มือ ย่าเจ่น จองไจ บ่าจา มางนา, ตี อางเง้ อางวื้งอางว้าง ชฺ้าง อู้ง โฮ้กฮ้าว ด้า อางเซง จา โย้เวอ ลาม วี แอ ชี.” ");
INSERT INTO bzi_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","พระเยซู จี่ แล่ง นี้แม้แน, “กงาชฺ้างอางย่า มาง เท่วาด่า คาโคลาโค อือก้อง ทื่งกง่า แน ล่าที่ ฮื่อ แน ลือ เมอ, กงา ต่างอี่ อางฮื่อ ล่าที่ อางจา โย้เวอ ดื้ง ลือ แง. ");
INSERT INTO bzi_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ชฺ้าง กูเจ้อกูจาด นี้ย่า กงาชฺ้างอางย่า มาง ล้าก้า โย้เวอ ล้า ช้อน ล้า คูแง. ยาว กงา ชฺ้าง อือนา แช้ ยาว เจิ่ก กา ปี่ง แง, แกะปอฮู มาง แกะ แน แพแล อือนา แช้ อ่อก กา ปี่ง แม้แน ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","กงา แกะ อือนา ยาง ล่าปู่ ล่าม่า ป่ากย่า โย้เวอ แช้ ชี แง. ยาว แพแล อือนา กงา ล่าปู่ ล่าซ่าย ป่ากย่า แช้ ชี แง. ");
INSERT INTO bzi_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“ยาว กงาย่า ก่าซ้าด มาง ย้า, กงาย่า ล่าม่า โย้เวอ ดื้ง อือนา จี่ช่าง แง นี้แม้แน, ‘นองมู อ่าโบ้ง ก้อง เวอ ก่ามป่อน กงาบู้ ชี อือ เวอ, ชฺ้างอางเมิง ต่องก่าต่าง แต่ง เมอ จาย, นองนา อางเมิง ซฺ้า ชี ล่าชี่ แฮ้ง ล่าบู ล้า คูโว.’ ");
INSERT INTO bzi_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ไม้ กงา แบ่ซฺู่ เมอ นอย่า กงานา จฺ่า ปี่ ล่า คูแง, กงา ล้างแบ่ เมอ นอย่า กงานา ต้าง ปี่ ล่าแง. นอง กงานา บ่าแบ ล่ากงากา เวิม มือ, นอย่า กงานา เป-ลอ ลาบตอน ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","กงา อางก่าอางตูม ตูม เซฺ่อ บ่าจา เวิม มือ, นอง มือ ซฺ้า ตูม ปี่ ล่าแง, กงา บ่าจาบ่าดื่งบื้อ เวิม มือ นอง มือ กงานา ฮูพลา ล่าแง, กงา คอก เวอ ดื้ง เมอ นอง มือ กงานา บ่อซฺ้า ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“ยาว ชฺ้าง พาจาว มาง นืงบาวา แน ฮา ชี อือ นี้แม้แน พอ แง, ‘จี่วีดอางซื้ง เวอ กงูย่า นาง แบ่ซฺู่ นา อาล่อม มย้าง ชี. แน อาล่อม เวอ นางนา จฺ่าต้าง ปี่ ล่า ชี, บ่าอ่ายาว นาง ล้าง แบ่ นา มย้าง ยาว อาล้อม เวอ ล้าง ต้าง ปี่ ล่า ชี. ");
INSERT INTO bzi_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","แน กงูย่า นางนา บ่าแบล่ากงา กาแน อาล้อม มย้าง ล่า ชี. ยาว อาล้อม เวอ ยู้ม คล้าว เวอ เป-ลอ ลาบตอน อ้อง ล้า ปี่ ล่า ชี, แน นาง อางก่าอางตูม ตูม เซฺ่อ บ่าจา แน อาล้อม เวอ มย้าง ล่า ชี. แน อาล้อม เวอ นางนา อางก่าอางตูม ปี่ ตูม ปี่ล่า ชี. ");
INSERT INTO bzi_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ยาว กงูย่า นาง ด้ากย้าง ชี แน คอก เวอ จา นา อาล่อม เวอ มย้าง ล่า ชี, แน กงูย่า นางนา อาล้อม เวอ บ่อ ซฺ้า ล่า ชี’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“ยาว กงา ยองนา พอ แง นี้แม้แน, ‘กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า นี้แม้แน, กงา ม้องน้าม ชฺ้าง ปีนแตปีนนา อางอี เลิ่นเลิ่น มางนา นอ อาล่อม เวอ ม้างม้าเจ้อ ฮายกาน แง. นอย่า กงานา คาตา แน ฮา ล่า ชี แน ทื่อช่างกานญา.’ ");
INSERT INTO bzi_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“ยาว กงา ชฺ้าง ล่าซ่าย ป่ากย่า ดื้ง อือนา พลาบ อี่ ชีเย นี้แม้แน, ‘ฮื่น โว ชฺ้าง แซ้งว้าน จี่ต่าง กงาบู้ ชี อือ เวอ, บี่ท่อ ซฺู่นืง บ่าจา ซาตานแด่ย่ายอคา, แน ยาง ย่าเจ่น อือนา เก้ม ชี ปี่ ชีโย้เวอ กลา แอ คูโว. ");
INSERT INTO bzi_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ไม้ กงา แบ่ซฺู่ เมอ นอ กงานา เจิ้นเจ้อ บ่าจฺ่า ปี่ ล่า, กงา ล้าง แบ่ เมอ นอ กงานา เจิ้นเจ้อ บ่าต่าง ปี่ ล่า. ");
INSERT INTO bzi_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","นอ กงานา บ่าแบ ล่ากงา กา แฮ้งย้า นอง กงานา นอง ยู้ม โย้เวอ บ่าปี่ อ้องแล ล่า, กงา อางก่าอางตูม ตูม เซฺ่อ บ่าจา เวิมมือ นอง มือ อางก่าอางตูม บ่าปี่ก่าบ่าปี่ตูม ล่า, กงา ด้ากย้าง เมอ แน คอก เวอ จา เมอ กงานา บ่าบ่อ ซฺ้า ล่า คู.’ ");
INSERT INTO bzi_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“ยาว ยอง พอ แง นี้แม้แน, ‘จี่วีดอางซื้ง มาง เวอ, นาง แบ่ซฺู่ เมอ, ล้างแบ่ เมอ แน นางนา บ่าแบล่ากงา กา, แน นาง อางก่าอางตูม ตูม เซฺ่อ บ่าจา, แน นาง ด้ากย้าง ชี แน คอก เวอ จา นา มย้าง เมอ บ่าปล่อง ล่า แน อาล้อม ฮา ล่า ชี’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“ยาว กงา นี้แม้แน พอ แง ‘กงา อางเลิ่ง ม้าม้า นองนา ม่ายแบ ปี่ ล่าว่า นี้แม้แน, นองมู ชฺ้าง นี้มู ก้อง กงา ม้องน้าม ชฺ้าง ปีนแตปีนนา อางอี เลิ่นเลิ่น มางนา เจิ้นเจ้อ บ่าฮา ปี่ กางซื้ง, ยาว นอย่า กงานา คาตา แน เจิ้นเจ้อ บ่าฮา ปี่ กางซื้ง แน ทื่อช่างกานญา’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“ยาว ยอง มือ วี่บ่ากกงาไจ แล แง, จ้า ชฺ้าง พาจาว มาง นืงบาวา แน ฮา อือ พาจาว มาง ก้อง จี่วีดม้าม้า กงา จา แล แง.” ");
INSERT INTO bzi_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","พระเยซู อางเลิ่ง นี้อือ จี่ เปิน ยาว ยาง ศิษย์ อือนา ม่า เย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“นองมือ อางแบ คูยา 2 นืง ยาว ปัสกาป่อยนืง อางนืง ย่าง เคอ ญา แน, ยาว กงาชฺ้างอางย่า เพล่อ ชี่ มางนา ชฺ้าง อือก้อง ซฺาแอ ปี่ ยาว, ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด แอ แง.” ");
INSERT INTO bzi_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","แฮ้ญ่าม เวอ ปุโรหิต ยอคา แน ยิว โบสถ์ ยอคา อืมมือ, คายาฟาส ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง ยู้ม เวอ ลือ ช้อน ลางกา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ยองมู นี้ย่า พระเยซู นา ล้อแม้ กย้าบ แน ชู ยาว แซ่ วา แน น้าท้าม กาง เย. ");
INSERT INTO bzi_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","จ้า ยอง มือ ม่า กาง เย นี้แม้แน, “ปัสกา อางนืง นู้เวอ บ่าฮา แคน คูโจ, ไม้ ค่องช่าง อือ อางเลิ่ง อางซืกอางซาก ฮา คู นา วาม คูงเย.” ");
INSERT INTO bzi_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","เบธานี ค่อง โย้เวอ พระเยซู ซีโมน คี้ตู้ด เพล่อ อ่าน มาง ยู้ม โย้เวอ จา เมอ. ");
INSERT INTO bzi_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ค่าบาย่า ทื่อม่าง จา แง. น้ำหอม ป่าง อางฮู่อางคา ย่าง ท่าม ล้า ยาว, พระเยซู ดื้ง เง้น ฮ่างจฺ่า จา เมอ น้ำหอม ย่าง อางตู่ เวอ ต่า ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ศิษย์ อือ มย้าง คู ยาว ยองมือ นืงบาค่า จี่ คูงเย นี้แม้แน, “อางเกิ่ง อางแม่น อางฮู่อางคา นี้ย่า บ้าเจอ นา ค้าค้าเล้อเล้อ แน ฮาย บ่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ก่อง ยาว นาบาตา บย่า ย้า พลู้ กงา แง. ยาว ชฺ้าง อางตูกอางพาน อือนา พลู้ แฮ้ง ปี่ เชคาไล” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","พระเยซู กงากย่า ยาว ยาง ศิษย์ อือนา ม่า เย นี้แม้แน, “นอย่า ยางนา บ้าเจอฮาย ตี่นต้อง แง, ยา กงานา อางเลิ่ง อางแม่น ฮา ปี่ ล่าง ม้า. ");
INSERT INTO bzi_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ชฺ้าง อางตูกอางพาน อือย่า นองก้อง กูญ่าม ย้า จา แง, จ้า กงาย่า นองก้อง กูญ่าม แน บ่ากงา ดื้ง แล เป. ");
INSERT INTO bzi_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ยาง กงา อางโต นู้เวอ น้ำหอม ต่า ล่าชี่ นี้ย่า กงา ศพ แฮ้ง พูม เมอ เก้ม ชี ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","กงา ม่ายแบ ปี่ ล่าว่า, ชฺ้างอางเมิง นู้เวอ บ้าเจอล้อเกิ้ง อางเลิ่ง อางแม่น นี้ง ป่าว แง, ชฺ้าง อืม ค่าบาย่า นี้มาง กงานา อางเลิ่ง อางแม่น ฮา ปี่ ล่าชี่ นี้ง คาตา ย้า จี่ เคอ แง, ไม้ ยางนา ปื้อซฺ้า แนนอ” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ยูดาส อิสคาริโอท พระเยซู ศิษย์เอก 12 คู่น โย้เวอ, ศิษย์ ทื่อม่าง มาง ปุโรหิต ยอคา อือก้อง แอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ยา น้า แอ ชี นี้แม้แน, “กงา นองนา ซฺื่ย พระเยซู นา ชู แล ยาว นอย่า กงานา อาล้อ แน ปี่ ล่าแง?” แน. ยาว ยอง มือ ยูดาส นา พลู้ 30 เหรียญ ปี่ ชี เย. ");
INSERT INTO bzi_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ยาว จายล้า แล่ยาว ยูดาส มือ พระเยซู นา ยองนา ชู ล้า ปี่ อางญ่าม แฮ้ง ซฺ้า เย. ");
INSERT INTO bzi_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ค้านู้มป่างอางเจ้อบ่ากานป่อยนืง ต่องก่าต่าง แฮ้นืง ย่า, พระเยซู ศิษย์ อืมมือ น้า เย นี้แม้แน, “ปัสกาป่อยนืง จฺ่าเกิ่ง นางนา ซฺ้า ชี ปี่ ล่าง นี้ย่า ล้อเกิ้ง ชี ปี่ ล่าแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ยาว พระเยซู มือ ยองนา ม่า ชี นี้แม้แน, “อางเมิง คล้าว โย้เวอ อ้องแล ยาว ค่าพ่าย่า ทื่อม่างนา ซฺ้าแล โว. ยาว ยางนา ม่า โว นี้แม้แน, ‘กงู อ่าจาน มาง ม่า ล่าง, กงา อางญ่าม ย่าง ชา เคอ ลือ ชา, กงา นาง ยู้ม นู้เวอ กงา ศิษย์ อือก้อง ทื่งกง่า แน ปัสกาป่อยนืง จฺ่าต้าง แง.’” ");
INSERT INTO bzi_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ยาว พระเยซู ศิษย์ อืม พระเยซู ม่า ชี แม้แน ฮา คู ชี. โย้เวอ ปัสกาป่อยนืง จฺ่าเกิ่ง ย่าง ซฺ้า ชี คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","มู่งคี่ล้าก้า เคิน ยาว พระเยซู มือ ยาง ศิษย์เอก 12 คู่น อือก้อง, ฮ่างเพิ่น ทาง เวอ ทื่งกง่า แน ดื้งเง้น แน ดื้ง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","แน ยอง ทื่งกง่า แน ฮ่างจฺ่า ดื้ง เมอ พระเยซู มือ นี้แม้แน จี่ ชี, “กงา อางเลิ่ง ม้าม้า แฮ้ง ม่าแบ ปี่ ล่าว่า, นอง อางมู นู้เวอ ชฺ้าง ทื่อม่าง จา แง, กงานา บ่าแม่น ฮา ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ยาว ศิษย์ อืม นืงบาต่องบ่าม่อนบ่าซ่า คู. ยองมู คาโคลาโค แฮ้ง กาจาง กามาง กา แน พระเยซู นา นี้แม้แน น้าน คูชี, “จี่วีดอางซื้ง เวอ, กงา บ่าอ่า อ่าลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","แฮ้งเย่ พระเยซู มือ ม่า ชี นี้แม้แน, “ชฺ้าง กงานา บ่าแม่น ฮาช่าง ล่าง ม้าย่า, กงาก้อง ทื่งกง่า แน น้ำจิ้ม ลอค่อ ทื้อค่อ กา แน คี ชี มาง ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","กงาชฺ้างอางย่า เพล่อ ชี นี้ม้า กงาซฺี้ แง, พระคัมภีร์ เวอ มอ ยาว แต้ม ชี ชี แฮ้งแม้แน ย้า. จ้า ชฺ้าง กงานา บ่าแม่น ฮา ล่าง แฮ้มางนา พาจาว มาง ต้าดต่อน วี่บ่ากไจ ปี่ แง. ชฺ้าง แฮ้ม้า บ่ากงา เกิ้ดลือ แฮ้ง เชคาไล” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ยูดาส พระเยซู นา บ่าแม่น ชา ฮา มางมือ พระเยซู นา น้า เย นี้แม้แน, “อ่าจาน เวอ, กงา บ่าอ่า อ่าลา?” แน. ยาว ยาง มือ พอ เย นี้แม้แน, “นาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","พระเยซู แน ศิษย์ อือ ทื่งกง่า แน จฺ่าต้าง ดื้ง คู เมอ, พระเยซู มือ ค้านู้มป่าง แฮ้ง กอ ท่าม แล่ชี่. แน พาจาว มางนา ขอบคุณ ฮา ชี. ยาว ยาง ค้านู้มป่าง แฮ้ง ชีด ศิษย์เอก อือนา เปิ่ง ปี่ ชี. ยา นี้แม้แน จี่ แง, “ยู้ จฺ่า ปาว นี้ย่า กงา อางโต ย่าง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ยาว พระเยซู มือ อ่างู่น แต่ค่า ล้างก้อก แฮ้ง กอ ท่าม แล่ชี่. แน พาจาว มางนา ขอบคุณ ฮา ชี. ยาว ศิษย์ อือนา ต้าง ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “นี้ย่า กงา ซฺี่ เซฺ่อ อ่อก ล้า ปี่ง ย้าง ย้า, ไม้ ชฺ้าง อางบย่า อือนา อางบล่าบ ปล่องปูน ปี่ง แนนอ. แน ซฺี่ นี้ย่า พาจาว มาง ก่ามค่าน อางซฺื่อ โย้เวอ อางช่า ย่าง ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","กงา อางเลิ่ง แฮ้ง ม่ายแบ ปี่ ล่าว่า, กงา อ่างู่น แต่ค่า บ่าต่าง แล่ก้าน. แฮ้นืง เคิน เมินญา กงู ทื่งกง่า แน อ่างู่น แต่ค่า ทื่อเทอ กงาต้าง แล่แง. แน แฮ้นืง พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ อางนืง ย้าง ย้าเป” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ยองมู ย่าง สรรเสริญ เพ่ง ย่าง ฮ้าว เปิน คู ยาว, ยองมือ มะกอกเทศ ตาแซ้ โย้เวอ ซฺื่ยกา แลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","พระเยซู ศิษย์ อือนา นี้แม้แน จี่ช่าง ชี, “มี้คี่ นองมู คาโคลาโค นี้ย่า กงานา วี ล่า คูแง, ไม้ พระคัมภีร์ เวอ นี้แม้แน มอ ยาว แต้ม ชี ป้าน่อ, ‘พาจาว ม้า แกะ ปอฮู มางนา แซ่ แง. แน แกะ อือย่า กามางกาต่อง กามางกาตี่ แน ฮื่น แอ คูแง’ แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“จ้า กงา ซฺี้ ยาว แต่ล้าน แล่ เมอ, กงา กาลิลี แควน โย้เวอ นอง ฮู่ เวอ แล ลางออน ฮา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","จ้า เปโตร มือ พระเยซู นา นี้แม้แน ม่า ชี, “ฮาก นางนา วี ล่าโค เวิม มือ กงาย่า นางนา บ่าวี ล่า!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ยาว พระเยซู มือ เปโตร นา ม่า เย นี้แม้แน, “กงา อางเลิ่ง ม้าม้า ม่ายแบ ปี่ ล่าว่า มี้คี่ ยาพ่า บ่าตานฮู่ เวอ, นาย่า กงานา บ่าแบ่ล่ากงา กา แน 3 เทอ จี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","จ้า เปโตร มือ พระเยซู นา นี้แม้แน ม่า ชี, “อ่าจาน เวอ, กงานา นางก้อง ทื่งกง่า แน กงาซฺี้ ปี่ ล่าเวิม, จ้า กงา บ่าจี่ นางนา บ่าแบล่ากงา กา” แน. ยาว ศิษย์ ทื่อบ่า อือ คาตา ย้า แฮ้แม้แน จี่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ยาว พระเยซู มือ ยาง ศิษย์ อือนา เกทเสมนี โซน โย้เวอ ซฺื่ย แลน ชีเย, ยาว ยองนา ม่า เย นี้แม้แน, “นอย่า นู้จา คู โว เป กงาย่า แฮ้กย้า อธิษฐาน ฮา แล ปานา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ยาว พระเยซู มือ แลน ชี. แน ยา เปโตร, ยากอบ แน ยอห์น (เย่ด เศเบดี อางย่า เย่.) ยองนา คาตา แน ซฺื่ยแลน ชี. ยาว พระเยซู มือ นืงบาต่องบ่าม่อนบ่าซ่า เย. แน ยา นาบาตา ย้า นืงบาต่องลาบ้าบ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","แฮ้งย้า ยาง เปโตร, ยากอบ แน ยอห์น ยองนา นี้แม้แน ม่า ชี, “กงาย่า นืงบาต่องลาบ้าบ ชา ซฺี้ ย้าง ญา จา แง. นอง นู้เวอ กงานา ล่อ ดื้ง ล่าโว! บ่ายู่ คูโจ เป!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","พระเยซู อางอี้ ย่อ แอน ยาว แมก่า ย่าง นื้งชฺ่า เวอ บอก ยาว อธิษฐาน ฮา ชี นี้แม้แน, “อ่าโบ้ง เวอ, จาว่าแน อางเพล่อ กงากา แนยาว ตูกพานลาบ้าบ ล้างก้อก นี้ง กงาก้อง บ่าจา ปี่ ล่า โจ, จ้า ล้อแม้เวิม นาง นืงบาจาบวา แน เพล่อ ปี่ ปาว, กงา นืงบาจาบ นี้ง วา แน บ่าอ่า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ยาว พระเยซู มือ ย่อ พ่าว ล้าน แล่ชี่. แน ยาง มย้าง ชี ยาง ศิษย์ 3 คู่น อือย่า ยู่น ชีแน. แฮ้งย้า ยาง เปโตร นา นี้แม้แน จี่ช่าง ชี, “ทานล้า โว! นาย่า ทานล้า ยาว กงานา ทื่อชั่วโมง อางช่าง ดื้ง ช่าง ล่า บ่ากงา ลา? ");
INSERT INTO bzi_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","แม่น แน อางโต แล่ม แล่ คูโว! แน อธิษฐาน ฮา คูโว! ไม้ อ่าซ่าง มางนา นองนา บ่าปี่ จ้อบ อางบล่าบ ฮา ปี่ ล่า แนนอ. นืงบา นี้ง อางเลิ่ง อางกง่าอางเกิง ฮา ซี้ เวิม, จ้า อางโต นี้ย่า อางด่ออางย่า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ยาว พระเยซู มือ ทื่อเทอ ย่อ พ่าว แล อธิษฐาน ฮา ชีเย นี้แม้แน, “อ่าโบ้ง เวอ ตูกพานลาบ้าบ ล้างก้อก นี้ง กงาก้อง บ่าปูน ยาว, นาง นืงบาจาบวา แน เพล่อ ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ยาว พระเยซู ย่อ พ่าวล้าน แล่ เมอ มย้าง ชี, ยาง ศิษย์ อือ ยู่น ชีแน. ยองมู นี้ย่า แมนือแมคอ ฮ่าน แมนือ บ่าพอง ล้าตอ กา. ");
INSERT INTO bzi_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ยาว พระเยซู มือ อางอ้าน แม้แน ทื่อเทอ พ่าว อธิษฐาน ฮา แล ชีเย, นี้เทอ 3 เทอ เคิน ชาเย. ");
INSERT INTO bzi_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ยาว พระเยซู มือ ย่อ พ่าวล้า ศิษย์ อือนา ฮูน ล้า แล่ชี่. แน ยาง ยองนา นี้แม้แน จี่ช่าง ชี, “นองมู นี้ย่า ยู่ ซ่าวดื้ง แล่ คูง ลา? กงา คางญ้า! ชฺ้าง กงานา บ่าแม่น ฮา ล่าง มาง, กงาชฺ้างอางย่า เพล่อ ชี นี้มางนา ชู ยาว, ชฺ้าง อางบล่าบ อือนา ปี่ อางญ่าม ย่าง เคิน ญ้า. ");
INSERT INTO bzi_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ทานล้า ปาว เอ้ว! โฮ้ก ชฺ้าง กงานา บ่าแม่น ฮา ล่าง มาง เคิน ล้าง ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","พระเยซู จี่ ย้าง บ่าลีน กื้ง ยูดาส เคิน ล้า ชี. ยา ศิษย์เอก 12 คู่น โย้เวอ ชฺ้าง ทื่อม่าง มาง ย้า. แน ยา ชฺ้าง อางอีบ่าอ่า ซฺื่ยล้าน ชี. ยองมู นี้ย่า มยา แน ตู้ลู้ง ท่าม ล้าน คูชี. ชฺ้าง ยองนา ซฺา ล้า ปี่ชี่ อือย่า ปุโรหิต ยอคา อือ แน ยิวชฺ้าง ยอคา อือ ย้า. ");
INSERT INTO bzi_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ยูดาส มือ ยองนา อางด่า เวอ นี้แม้แน ม่า ชี ลางออน ม่าย ชี, “กงา อ่าซ่าง นา ป่าปา น่าม แล แง, นอง ชฺ้าง แฮ้มางนา ชู แอ โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ยูดาส มือ ซฺ้อก ย้า พระเยซู นา ย่อ อ้องซฺ้า แล ชี. แน ยาง พระเยซู นา นี้แม้แน จี่ช่าง ชี, “อ่าจาน เวอ” แน. ยาว พระเยซู นา ป่าปา เวอ น่าม ชี. ");
INSERT INTO bzi_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","แฮ้งย้าเย่ พระเยซู มือ ยางนา จี่ช่าง ชี นี้แม้แน, “อางช่าง เวอ บ้าเจอฮาซี้เวิม อางไว่ แน ฮา ปาว” แน. ยาว ชฺ้าง แฮ้อืมมือ พระเยซู นา อ้อง ชู ล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","พระเยซู อางมู โย้เวอ ชฺ้าง ทื่อม่าง จา แง. ยา ค่าตอง มยาทาง แฮ้ง ชอด อ่อก ล้า ปี่ ยาว, ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น ม่าง ย่าเจ่น ม่าง น่าซื่ง เวอ แจ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","จ้า พระเยซู มือ ยาง ศิษย์ มางนา ม่า เย นี้แม้แน, “นาง มยาทาง แฮ้ง กอย ชี โว! ชฺ้าง มยาทาง ไจ อือ มยาทาง แฮ้ง ปาปาย ย้า กงาซฺี้ แล่แง. ");
INSERT INTO bzi_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","นาง เย้ง กานยาว กงาย่า อ่าโบ้ง นา บ่าป่า ปล่อง ปี่ กงากา ลา? ยา กงานา ซฺ้อก แน เท่วาด่า 12 มู กงานา ซฺาลือ ปี่ ล่าเวิม อางกงา. ");
INSERT INTO bzi_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","จ้า จาว่าแน กงา แฮ้แม้แน ฮา ยาว, พระคัมภีร์ เวอ แต้ม ชี ชี แม้แน บ่าตอล้า เป” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","แฮ้งย้า พระเยซู มือ ชฺ้าง แฮ้อือนา นี้แม้แน จี่ช่าง ชี, “นอง มยาทาง แน ตู้ลู้ง ท้าม ล้า ยาว กงานา ชู ล้าล่า คูชี นี้ย่า, ไม้ นอ กงานา ค่าโม่ยค่ามโจน แน เย้ง ล่างลา? นอย่า กงา โบสถ์อางฮื่อ โย้เวอ ม่าอู่บ ดื้ง นา กูนืง ย้า มย้าง ล่าแง, จ้า นอ กงานา บ่าชู ล่า. ");
INSERT INTO bzi_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","จ้า กูย่างกูเจ้อ นี้ย่า พาจาวจี่ต่างจี่แต่นฮู อือ มอ ยาว พระคัมภีร์ เวอ แต้ม ชี ชี แฮ้งแม้แน ย้า กงาเพล่อ แง” แน. ยาว พระเยซู ศิษย์ คาโคลาโค อืม พระเยซู นา วี คูชี, ไม้ ยองมู นี้ย่า แค ฮื่น คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ชฺ้าง แฮ้อือย่า พระเยซู นา ชู ชี. ยาว ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น คายาฟาส มาง ยู้ม โย้เวอ ซฺื่ยแอน ชี. ยาว โย้เวอ อางลี้บอางล่าว ม่าอู่บฮู อือ แน ยิวชฺ้าง ยอคา อือ ช้อนกา น้าท้าม กาจา เย. ");
INSERT INTO bzi_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","เปโตร พระเยซู ก้อง เว่อเว่อ แน เค่แอน ชี. แน ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น ม่าง ยู้ม กองโค้ง โย้เวอ อ้องแลน ยาว, ยู้มล่อฮู อือก้อง ทื่งกง่า แน ดื้ง ชี. ยา บ้าเจอ ตอล้า แง แน ล่อ ฮู เย. ");
INSERT INTO bzi_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ปุโรหิต ยอคา แน สภาแซนฮีดริน อางมู คาโคลาโค อือ, พี่ญ่าน ม้าม้า บ่าอ่า อือนา ซฺ้า ยาว พระเยซู นา อางซี จี่ กาน ปี่ ยาว แซ่ คู เย. ");
INSERT INTO bzi_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","จ้า พี่ญ่าน ม้าม้า บ่าอ่า อือ อางบย่า แน จา เวิม มือ, จ้า ยอง มือ พระเยซู นา อางซี บ่าซฺ่า แซ่ กงา กาเย. จ้า น่อง เวอ ค่าพ่าย่า 2 คู่น จี่ เย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ค่าพ่าย่า นี้ม้าย่า จี่ แง พาจาว มาง โบสถ์อางฮื่อ นี้ย่า กงา พยา วี อางกงา, ยาว 3 นืง โย้เวอ อางซฺื่อ แต่งล้า แล่ ปี่ แงแน.” ");
INSERT INTO bzi_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","แฮ้งย้า ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง ทาจูง ล้า ชี. แน พระเยซู นา นี้แม้แน น้าน ชี, “ยอ นางนา อางซี ฮา ชี แน จี่ ล่าง. ท้าว นา เจิ้นเจ้อ บ่าจี่ ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","จ้า พระเยซู มือ กย้าบ ย้าเย่, แฮ้งเย่ ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง มือ พระเยซู นา จี่ช่าง ชี นี้แม้แน, “กงา นางนา น้า ล่า ปานา, พาจาว มาง ล้าก้า นู้เวอ ก่ามค่าน ฮา ฮูแล, นา อางเลิ่ง ม้าม้า จี่ แงแน. นา พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ปี่ชี่ มาง ลา? นาย่า พาจาว มาง อางย่า มาง ม้าม้า ย้า ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ยาว พระเยซู มือ ยางนา พอ ชี นี้แม้แน, “นาง จี่ นี้ย่า อางกง่า ย้า, จ้า กงา ม่ายแบ ปี่ ล่าว่า, จ้างจ้าง โย้เวอ นาย่า กงาชฺ้างอางย่า เพล่อ ชี มาง, พาจาว อางฮื่อ เลิ่นเลิ่น มาง ล่าปู่ ล่าม่า ป่ากย่า โย้เวอ ดื้ง นา กงามย้าง แง. แน กงาชฺ้างอางย่า เพล่อ ชี ม้าย่า มู่งบื่น อางป่อน โย้เวอ ทื่งกง่า แน ลือ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ยาว ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มางมือ นืงบาค่า ชีเย, ยาว ยาง ค่าลาวอางเง้โลบแล่เซฺ่อ แฮ้ง ชีดล่าก แล่ยาว จี่ เย นี้แม้แน, “ยา พาจาว มางนา ม้าม้า ย้า จี่ฮูย้า แง, กงู พี่ญ่าน บ่าซฺ่า กานโจ. ฮู ปาว นอ จี่ต่าง ฮูย้า แฮ้งนา กงากย่า คูงญา, ");
INSERT INTO bzi_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","นอย่า ล้อแม้แน เย้ง คูแง?” แน. ยาว ยอง มือ พอ คูง เย นี้แม้แน, “ยาง อางซี นี้ย่า ซฺี้ ก้อม้อก ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ชฺ้าง แฮ้อืมมือ พระเยซู แมก่า เวอ ค่านล่าง พี่ด กาน ยาว ตื่อ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ยาว ยอง พระเยซู นา น้า คูง เย นี้แม้แน, “ก่าซ้าด พาจาว มาง ซฺาลือ ปี่ ชี่ มาง เวอ, ม่า ล่าวแล อ่าซ่าง นางนา ตื่อ ล่า ชี่ ม้า?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","เปโตร ยู้ม กองโค้ง โย้เวอ ดื้ง จา เมอ ย่าบี่ ย่าเจ่น ทื่อม่าง เปโตร นา มย้าง ยาว น้า เย นี้แม้แน, “นา เยซู กาลิลีบ่า มางก้อง ทื่งกง่า แน ดื้ง อ่าลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","จ้า เปโตร มือ ชฺ้าง อางมู อือ ล้าก้า โย้เวอ พอ เย นี้แม้แน, “กงา บ่าแบ นา บ้าเจอ นา จี่ เคอ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ยาว ยาง มือ ก้ามทื้อ ล้องก้อ โย้เวอ ย่อ อ่อกแอน ชีเย. ยาว ย่าบี่ ย่าเจ่น ทื่อม่าง ยางนา มย้าง แล่ ชี่ มาง มือ, ชฺ้าง โย้เวอ จา อือนา จี่ช่าง เย นี้แม้แน, “ชฺ้าง นี้ม้า เยซู นาซาเร็ธชฺ้าง มางก้อง ทื่งกง่า ย้า ดื้ง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","จ้า เปโตร มือ พอ เย นี้แม้แน, “กงา สาบาน ฮา เวิม อางกงา กงา ค่าพ่าย่า นี้มาง นา บ่าแบกงากา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ยาว ทื่อซ่าล่ากยาว ชฺ้าง โย้เวอ จูง จา มาง มือ, เปโตร นา ย่อ อ้อง ซฺ้า ลา ชี ยาว จี่ช่าง เย นี้แม้แน, “นาย่า ยอง อางมู อือ ม้าม้า ย้า, ไม้ นาง จี่ต่าง แฮ้ ยอง จี่ต่าง อางเซง แม้แน” แน. ");
INSERT INTO bzi_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","จ้า เปโตร มือ สาบาน ฮา ชี แน ก่ามค่าน ฮา ชี นี้แม้แน, “กงา ค่าพ่าย่า นี้มาง นา บ่าแบกงากา” แน. ยาว ซฺ้อก ย้า ยาพ่า ต้าน ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ยาว เปโตร มือ พระเยซู ม่า ชี แฮ้งนา เย้ง กงา แล ชี นี้แม้แน, “นาย่า ยา บ่าตาน ฮู่ เวอ กงานา บ่าแบ่ล่ากงา กาแน 3 เทอ จี่ แง” แน, แฮ้งเย่ เปโตร มือ นืงบาชู่ม อางเง้ เวอ อ่อกแอ อู้ง แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ซอทาอางด่า โย้เวอ ปุโรหิต ยอคา แน ยิวชฺ้าง ยอคา อือ ฮา กางเย, พระเยซู ซฺี้ แฮ้ง ซูม แงแน. ");
INSERT INTO bzi_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","แฮ้งเย่ ยองมือ พระเยซู นา พือ ยาว ปีลาต โรม ผู้ว่า มางนา ซฺื่ย ซฺ้า แล ชี. ");
INSERT INTO bzi_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ยูดาส พระเยซู นา บ่าแม่น ฮา ชี มาง พระเยซู นา ซฺี้ แอเคอ แน ต้าดต่อน ชี แน แบน ยาว, ยางมือ นาบาตา เย นืงบาชู่ม แง, แฮ้งย้าเย่ ยาง มือ พลู้ 30 เหรียญ ย่าง, ปุโรหิต ยอคา แน ยอคา ย่าม่าง อือนา คื่น ปี่ แล่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ยาว ยูดาส มือ จี่ เย นี้แม้แน, “กงาย่า ชฺ้าง อางแม่น เจิ้นเจ้อ อางซี บ่าฮา มางนา บ่าแม่น ฮา กาน แอ, กงา อางบล่าบ ฮา ชา” แน. จ้า ยอง มือ พอ คูงเย นี้แม้แน, “แฮ้ย่า นาง อางเลิ่ง กงู อางเลิ่ง บ่าอ่า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ยูดาส มือ โบสถ์อางฮื่อ คล้าว เวอ พลู้ ย่าง จานวี ยาว, อางเง้ เวอ อ่อกแอ นื้งชฺือ แป่น แซ่ แอ แล่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ปุโรหิต ยอคา อืมมือ พลู้ แฮ้ง กอ ยาว จี่ คูง เย นี้แม้แน, “พลู้ นี้ง โบสถ์อางฮื่อ โย้เวอ พลู้ อือก้อง ทื่งกง่า แน กอ ชี นี้ย่า อางลี้บอางล่าว เวอ อางซี, ไม้ พลู้ นี้ย่า ไจ ชฺ้าง นา วื้อ ซฺี้ ปี่ชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","แฮ้งเย่ ยอง มือ พลู้ แฮ้ง นื้งชฺ่าอู่ล่อง แต่งฮู มาง ตี ย่าง วื้อ แอชี, ไม้ ยิวชฺ้างบ่าอ่า อือ ศพ พูม ย้า แต่ง เย. ");
INSERT INTO bzi_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","แฮ้งเย่ ตี แฮ้งนา อามือ เคอ แน “ซฺี่ ตี” แน ฮ้าว แง. ");
INSERT INTO bzi_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","นี้เลิ่ง ย่า พาจาวจี่ต่างจี่แต่นฮู เยเรมีย์ มาง มอ ชี แม้แน ย้า ตอล้า ชี นี้แม้แน, “ยอย่า พลู้ 30 เหรียญ อิสราเอลชฺ้าง อือ, ยาง อางโต อางฮู่ เย้ง ชี ย้าง, ");
INSERT INTO bzi_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","นื้งชฺ่าอู่ล่อง แต่งฮู มาง ตี ย่าง วื้อ แอ ชี, จี่วีดอางซื้ง มาง กงานา ม่า ชี ล่า ชี แม้แน” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ยาว ยอง มือ พระเยซู นา ผู้ว่า ปีลาต มาง ล้าก้า เวอ ซฺื่ย จูง แอ ชีเย. ยาว ผู้ว่า มาง มือ พระเยซู นา น้า เย นี้แม้แน, “นาย่า ยิวชฺ้าง อือ ก่าซ้าด ลา?” แน. ยาว พระเยซู มือ พอ เย นี้แม้แน, “โอ่ย! อางอ้า ย้า นาง จี่ นี้ย่า อางกง่า ย้าเป” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ยาว ปุโรหิต ยอคา แน ยิวชฺ้าง ยอคา อือ, พระเยซู นา จี่ เมอ พระเยซู มือ เจิ้นเจ้อ บ่าจี่ พอ เย. ");
INSERT INTO bzi_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","แฮ้งเย่ ผู้ว่า ปีลาต มือ น้า แง นี้แม้แน, “ฮาก นางนา อางไล้จี่กาน ล่าง แฮ้งนา บ่ากย่า ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","จ้า พระเยซู มือ ผู้ว่า ปีลาต นา ทื่อก่าม แนม บ่าพอ เย, แฮ้งเย่ ผู้ว่า ปีลาต มือ นืงบาม่าน แง. ");
INSERT INTO bzi_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ปัสกาป่อยนืง โย้เวอ อางลี้บอางล่าว จา เย. นักโทษ อือนา กาปี กามาง กา แน ตอ แงแน. นี้ย่า ผู้ว่า ปีลาต อางลี้บอางล่าว แต่งล้า ชีย้าง. นี้งย้า ผู้ว่า ปีลาต มางมือ ค่องช่าง อือนา ชฺ้าง อางซี ฮา ชี อือนา ทื่อม่าง แช้ ตอ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","แฮ้ญ่าม เมอ นักโทษ บ่าแม่น อางโซ้กอางไล้ ทื่อม่าง จา แง, อางเม้ง บารับบัส แน ยางนา อ่าซ่าง มาง อางแบ กงากา แอ่ ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ค่องช่าง อือ ลาน คู ยาว ผู้ว่า ปีลาต มือ ยองนา น้า คูงเย นี้แม้แน, “นอย่า กงานา อ่าซ่าง นา ตอ ปี่ ล่าแง, บารับบัส นา ล่าอ้าว พระเยซู ฮาก พาจาว มาง แช้ยู้ ก่าซ้าด เพล่อ ปี่ชี่ มาง แน ฮ้าว มางนา ตอ ปี่ ล่า แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ยาง นี้แม้ จี่ นี้ย่า, ไม้ ผู้ว่า ปีลาต อางแบ เย ปุโรหิต ยอคา แน ยิวชฺ้าง ยอคา อือ, พระเยซู นา ซฺื่ยล้า ชี แฮ้ย่า พระเยซู นา เจอค้อย แฮ้ง ปาปาย แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ผู้ว่า ปีลาต ต่างอี่ ดื้งย้า โย้เวอ ดื้ง ต้าดต่อน เมอ, ผู้ว่า ปีลาต ค่าบา มางมือ ย่าเจ่น ทื่อม่าง นา ม่าย ผู้ว่า ปีลาต นา ม่าย ล้า ปี่ ชีเย นี้แม้แน, “ค่าพ่าย่า เจิ้นเจ้อ อางซี บ่าจา นี้มาง นา เจิ้นเจ้อ บ่าฮา โจ. ไม้ มี้คี่ทาง เวอ กงา ยางนา แมบืน บ่าแม่น แน บืน มย้าง แอ. กงาย่า ซอทา จาย มู่งคี่ล้าก้า เคอ ยา นืงบาบ่าม่อนบ่าซ่า.” ");
INSERT INTO bzi_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","จ้า ปุโรหิต ยอคา แน ยิวชฺ้าง ยอคา อือ, ค่องช่าง อือนา จี่ซ้อ ม่าอู่บ บารับบัส นาตอ ปี่ เย. ยาว พระเยซู นา แซ่ โว แน ม่า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ผู้ว่า ปีลาต มือ ค่องช่าง อือนา น้า เย นี้แม้แน, “นี้ 2 คู่น นา อ่าซ่าง นา ตอ ปี่ ล่าแง แน.” ค่องช่าง อือมือ ฮ้าว ม่า เย, “บารับบัส นา ตอ โว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ยาว ผู้ว่า ปีลาต มือ น้า แล่ ชีเย นี้แม้แน, “เยซู ชฺ้างอางเมิง นู้เวอ พาจาว มาง ก่าซ้าด แช้ยู้ เพล่อ ปี่ชี่ มางนา ล้อแม้ฮายวา” แน. ยาว ยอง คาโคลาโค แฮ้งมือ ฮ้าว ม่า คูงเย นี้แม้แน, “ยางนา ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","จ้า ผู้ว่า ปีลาต มือ ยองนา นี้แม้แน น้าน ชี, “ยา บ้าเจอ อางซี ฮา ชี?” แน. จ้า ค่องช่าง อืม อางอ้าน แฮ้ง ล่อบ่าปา อางเซง บื้ง แน จี่ โฮ้ก คูชี. ยอ นี้แม้แน จี่ โฮ้ก ชี, “ไม้กางเขน ท่า โย้เวอ แซ่ โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ผู้ว่า ปีลาต มือ เจิ้นเจ้อ บ่าฮาตอ กา เย. แน ชฺ้าง อือ แกล่ก ลางกา ยาว ยาง มือ ค่องช่าง อือ ล้าก้า โย้เวอ ล้าง ย่าง ล่าปู่ ชี่ แล่ยาว จี่ เย นี้แม้แน, “ค่าพ่าย่า นี้มาง ซฺี้ นี้ย่า กงา บ่าแบ เป, นอง คาฮาแม้แน ฮา คู ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ยาว ค่องช่าง อืมมือ ฮา คูงเย นี้แม้แน, “ยาง ซฺี้ นี้ย่า กงู อางย่าอางคย้า แน กงูมู นี้ง ลาบจ่าแล่ คู แน.” ");
INSERT INTO bzi_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","แฮ้งเย่ ผู้ว่า ปีลาต มือ บารับบัส นา ตอ ชี. ยาว พระเยซู นา ซ้าด อางคอ ล่าตื่อ ซฺ้าม กอเล อางแล้ม ตีด ชี อือ, ตื่อชืก ปี่ ยาว ตาฮ้าน อือนา ปี่ ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด แซ่ แอ ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ยาว ตาฮ้าน อืม พระเยซู นา ศาลปรีโทเรียม โย้เวอ ซฺื่ยแลน คูชี. ศาลปรีโทเรียม นี้ย่า ผู้ว่า ม่าง ยู้ม กองโค้ง โย้เวอ. ยาว ยองมู แฮ้ง โย้เวอ ตาฮ้าน คาโคลาโค จา อือนา ฮ้าว ล้า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ยอ พระเยซู อางก่าอางตูม อางเง้ ย่าง แล ปี่ ยาว, อางก่าอางตูม อางแน้ ก่าซ้าด อางก่าอางตูม แม้แน ตูม ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ยอ จี่กู่ ย่าง มงกุฎ แต่ง ยาว พระเยซู อางตู่ เวอ ช่อง ปี่ ยาว, ไมออ ป้าง ย่าง ยาง ล่าปู่ ล่าม่า ป่ากย่า ท่าม ปี่ ชี, ยาว ยอง มือ ยางนา ป่าตูคู บอกไว้ ชี แน แต่งจ่าแล่ คู ยาว จี่ เย นี้แม้แน, “ยิวชฺ้าง ก่าซ้าด มาง เวอ, จาบื่อดื้งบื้อ แน จา โว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ยาว ยอง มือ พระเยซู นา ค่านล่าง ย่าง พี่ด กาน ยาว, ไมออ ปาง ย่าง ยาง อางตู่ เวอ ชืก ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ตาฮ้าน อือ พระเยซู นา ป่าลาลาบ่อ ม่อน ก่อ แล่ คู เมอ, ยอง พระเยซู นา ก่าซ้าด ค่าลาวอางเง้โลบแล่เซฺ่อ แฮ้ง แล อ่อก ปี่ชี่. ยาว พระเยซู อางก่าอางตูม แฮ้ง ยางนา อางอ้าน แฮ้งแม้แน ก่าตูม แล่ ปี่ชี่. ยาว ยองมู แฮ้ง พระเยซู นา ซฺื่ย อ่อก แลน คูชี, ไม้ พระเยซู นา ไม้กางเขน ท่า โย้เวอ แซ่ แล แง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ยอง ย่อ อ่อก ลือ เมอ ค่าพ่าย่า ทื่อม่าง นา มย้าง ชี. ยาง อางเม้ง ซีโมน แน, ยา ไซรีน อางเมิง เวอ จายลือ ชี. ยาว ยอง มือ ยางนา พระเยซู ไม้กางเขน ย่าง เค้ ป่า ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ยองมู แฮ้ง พระเยซู นา ซฺื่ย นื้งชฺ่าตี กลโกธา โย้เวอ เคิน แล ชี. กลโกธา นี้ย่า อางตู่ตู่คย่าม ตาแซ้ นา ฮา แง. ");
INSERT INTO bzi_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ยาว ยอง มือ อ่างู่น แต่ค่า อางเกิ่ง อางค่า ซูน ชีย้าง พระเยซู นา ฮ้าน ต้าง ปี่ ชีเย. จ้า พระเยซู มือ บ่าต่าง เย. ");
INSERT INTO bzi_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ยาว ยองมู แฮ้ง พระเยซู นา ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด ชี. แน พระเยซู อางก่าอางตูม แฮ้ง เบอจอก เปิ่ง ลางกา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ยาว ยองมือ พระเยซู นา ดื้ง ฮู คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ยาว ยอง มือ พระเยซู อางตู่ อางท่า เวอ ล่าไม แป้น โย้เวอ, อางซี ฮา ชีย้าง แต้ม ชี นี้แม้แน, “นี้ม้า เยซู ยิวชฺ้าง อือ ก่าซ้าด มาง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ค่าโม่ยค่ามโจน 2 คู่น จา แง. ตาฮ้าน อือย่า เย่ดนา ไม้กางเขน ท่า เวอ ตื่อตี้ด ชี. แน พระเยซู ก่องทาง โย้เวอ ดื้ง ปี่ชี่, ล่าซ่าย ป่ากย่า ทื่อม่าง แน, ล่าม่า ป่ากย่า ทื่อม่าง แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ค่องช่าง ย่อ ไก้ กว่า คูง อืม อางตู่ วืด คูง เย. แน ยอง พระเยซู นา นี้แม้แน จี่ ฮูย้า คูชี, ");
INSERT INTO bzi_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“บ้าเจอล้อแม้ จา แง. นา โบสถ์อางฮื่อ แฮ้ง พยา ยาว, 3 นืง นู้เวอ อางซฺื่อ แต่ง แล่ง อ่าลา, จาว่าแน นาง พาจาว มาง อางย่า ม้าม้า แนยาว ค่าตอง อางโต นี้ง ปล่องจ่าแล่ ปาโน. แน ไม้กางเขน ท่า เวอ จาย ลู่งลือ โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ยาว ปุโรหิต ยอคา อางลี้บอางล่าว ม่าอู่บฮู อือ, แน ยิวชฺ้าง ยอคา อือ พระเยซู นา จี่ ฮูย้า กางเย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ยา ฮากนา อางปล่อง กงากา จ้า ยา ค่าตอง นา บ่าปล่อง จ่าแล่ กงากา, จาว่าแน ยา ยิวชฺ้าง อือ ก่าซ้าด ม้าม้า แน ยาว, ค่าตอง ไม้กางเขน ท่า เวอ จา แฮ้ง ปล่อง จ่าแล่ ยาว, ลู่ง ลือ กงากา ยาว กงูม มือ ยางนา เจ่อจ่า คู แน, ");
INSERT INTO bzi_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ยา พาจาว มางนา นืงบาชี แง. จาว่าแน พาจาว มาง ยางนา บ่าวี ยาว, พาจาว มางนา อามือ ป้า ปล่อง ปี่ โว, ไม้ ยา จี่ แง นี้แม้แน, ‘กงา พาจาว มาง อางย่า’” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","แน ค่าโม่ยค่ามโจน 2 คู่น ยางก้อง ทื่งกง่า แน, ไม้กางเขน ท่า เวอ ตื่อตี้ด ชี มาง เย่ด คาตา พระเยซู นา จี่ ฮูย้า เย. ");
INSERT INTO bzi_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ยาว ชฺ้างอางเมิง คาโคลาโค โย้เวอ, 12 โมง นืงก้อง เวอ จาย 3 โมง เวอ เคอ นี้ย่า วื้งว้าง โค ชี. ");
INSERT INTO bzi_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","3 โมง มู่งคี่ล้าก้า เคิน เมอ พระเยซู มือ นี้แม้แน จี่ โฮ้ก ชี, “เอลี เอลี ลามา สะบักธานี!” แน. นี้แม้แน ฮา แง, “พาจาว มาง เวอ, พาจาว มาง เวอ, บ้าเจอฮาย กงานา วี ล่าแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ค่องช่าง แท้ แน จูง ฮู คูชี อือ กงากย่า เมอ, ยอง นี้แม้แน จี่ ลางกา ชี, “น้า แล้, ยา พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ นา ฮ้าว แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ยาว ทื่อม่าง จา เย, อางไว่อางคย้าง ย้า อู่ไต่ ย่าง อ่างู่น แต่ค่า เวอ ตือ ยาว, ล่าไม เวอ ชอก ยาว พระเยซู ม่านป่อง เวอ กลาง แล ต้าง ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","จ้า ชฺ้าง จ้านล้าชี อือ จี่ กาง เย นี้แม้แน, “บ่าตี่นบ่าต่อง โจ, ล่อ ฮู คู เซฺ้อ ยางนา เอลียาห์ อางลือ ปล่อง ลือ ล่า!” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","พระเยซู ทื่อเทอ จี่โฮ้ก ยาว อางซ่า แช ซฺี้ คา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","แฮ้ญ่ามเมอ โบสถ์อางฮื่อ อางฮ้อง อางเซฺิ่งอางซฺ้าง ล้องก้อ โย้เวอ, พ้า เทิง ชี ชีย้าง ซฺ้อก ย้า 2 พื้น แน ชีดอ่อก ล้า ชี. พ้า ชีด ชี แฮ้ย่า อางท่า จาย อางอ่อก เคอ แน ชีด ลู่งลืน ชี. ยาว นื้งชฺ่า อืมมือ มี่ซี่อืน ล้าชี. ลอบา อืมมือ ปล่าก พล่อยพล่อย เย. ");
INSERT INTO bzi_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ท้ามชฺ้างซฺี้ชีย้า อืม พอง อ่อก ล้า ชี. ยาว พาจาว มาง ชฺ้างซฺี้ แอ ชี อืมมือ อางบย่า ย้าเย่ แต่ ลาน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","พระเยซู แต่ ลาน แล่ ยาว ยอง มือ ท้ามชฺ้างซฺี้ชีย้า เวอ จาย อ่อก ลาน คู ชีเย, ยาว เยรูซาเล็ม อางเมิง อางเซฺิ่งอางซฺ้าง เวอ ซฺื่ย กา แลน ยาว, ค่องช่าง อือนา มย้าง แล ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ตาฮ้าน มู แน ตาฮ้าน นายร้อย ทื่อม่าง พระเยซู นา ล่อ ชีอืม, มี่ซี่อืน ชี แฮ้ง แน อางเลิ่ง คาโคลาโค ตอล้า ชี อือ มย้าง คู ยาว, ยอง มือ นาบาตา เย แค คูแง. แน ยอง จี่ กางเย นี้แม้แน, “ยา พาจาว มาง อางย่า ม้าม้า ชา” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ค่าบาย่า ทื่อมู เว่อเว่อ แน จูง ฮู จา เย. ยอ พระเยซู นา กาลิลี แควน เวอ จาย ย้าเย่ เค่ ฮูพลา ลา ชี. ");
INSERT INTO bzi_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ยองมู โย้เวอ มารีย์ มักดาลาชฺ้าง มาง, มารีย์ ยากอบ แน โยเซฟ เย่ด อางบา มาง แน เศเบดี ค่าบา มาง จา เย. ");
INSERT INTO bzi_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","มู่งคี่ล้าก้า โย้เวอ ชฺ้างอางจาอางปาง ทื่อม่าง จา แง อางเม้ง โยเซฟ แน. ยา อาริมาเธีย อางเมิง เวอ จายล้า ชี, ยา พระเยซู ศิษย์ เย. ");
INSERT INTO bzi_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","โยเซฟ ผู้ว่า ปีลาต ก้อง แลน ยาว พระเยซู ศพ ย่าง ป้า แล ชีเย, แฮ้งย้าเย่ ปีลาต มือ ตาฮ้าน อือนา ม่าย พระเยซู ศพ ย่าง โยเซฟ นา ปี่ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","โยเซฟ มือ พระเยซู ศพ ย่าง, พ้า อางป่อน อางฮู่ อางคา ย่าง ป้าน ยาว ฮ้าน แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ยาว ลอบา ตาแซ้, ยาง ท้ามชฺ้างซฺี้ชีย้า อางซฺื่อ ม่า แต่ง ปี่ชี่ โย้เวอ พระเยซู ศพ ย่าง ฮ้าน ชี แล ชีเย. ยาว ยาง ชา แอ แล่เมอ ยาง มือ ท้าม เวอ ลอบาซื่อ อางฮื่อ ย่าง พี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","แฮ้ญ่ามเมอ มารีย์ มักดาลาชฺ้าง แน มารีย์ ทื่อม่าง มาง เย่ด, ท้ามชฺ้างซฺี้ชีย้า ทื่อปล่าก ป่ากย่า โย้เวอ ล่อดื้ง จา เย. ");
INSERT INTO bzi_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ยาว ซอทา เคอ เมอ ปุโรหิต ยอคา แน ฟาริสี อือ ผู้ว่า ปีลาต ก้อง ลา ชี. แฮ้นืง ลองนืง เย. ");
INSERT INTO bzi_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ยาว ยอง มือ ม่า คูงเย นี้แม้แน, “กงูย่า อางจาม กงากา ชฺ้างแล่จ่อบ แฮ้ม้า จี่ แง, ยา ซฺี้ ยาว ว่านที่ 3 แฮ้นืง อางซฺื่อ แต่ล้า แล่แง แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ท้ามชฺ้างซฺี้ชีย้า โย้เวอ ชฺ้าง อือนา ม่า ล่อ แอ ปี ปาว ว่านที่ 3 นืง เวอ ตื่อเคอ แน, อ่าซา ยาง ศิษย์ อือ ศพ แฮ้ง ค่าว ยาว ค่องช่าง อือนา จ้อบ คู นา นี้แม้แน, ‘ยา แต่ ลาน แล่ง ญา’ แน, นี้เทอ จ้อบ แล่ยาว ยา ชฺ้าง อือนา อางอ้าน แฮ้งล่อบ่าปา ยาเป จ้อบ แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ยาว ผู้ว่า ปีลาต มือ ม่า ชี นี้แม้แน, “ตาฮ้าน อือนา ม่า ล่อ แอ ปี่ว นอง ล้อม้อก แน ซฺื่ย แอ ซี้ง ซฺื่ย แอ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","แฮ้งย้าเย่ ยอง มือ ท้ามชฺ้างซฺี้ชีย้า โย้เวอ ตาฮ้าน อือนา ล่อ ปี่ ชี. ยาว ท้าม อ้อง ย้า ลอบา พี่ ชี โย้เวอ อางช่า แต่งตีด ชี. อางช่า แฮ้ย่า อางอ้าน แม้แน บ่าจา ยาว ฮาก โก้นก้าว ล้า ชี แน ฮาย แบ ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ว่านตีด ซอทาอางด่า โย้เวอ มารีย์ มักดาลาชฺ้าง, แน มารีย์ ทื่อม่าง มาง เย่ด มือ ท้ามชฺ้างซฺี้ชีย้า เวอ ล้าน ชี เย. ");
INSERT INTO bzi_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","แฮ้ญ่าม เมอ นาบาตา เย มี่ซี่อืน ชี, ยาว จี่วีดอางซื้ง มาง เท่วาด่า ทื่อม่าง มู่งท่า เวอ จาย ลู่งลือ ยาว, ลอบา ท้าม อ้องย้า โย้เวอ พี่ ชี ย่าง ต่าน อ่อก ชีเย. ยาว ลอบาท่า เวอ ดื้ง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","เท่วาด่า มาง อางโต แฮ้ย่า มู่งบล่าบ ช้อด ย้า แปล้น แง. แน ยาง ค่าลาว แฮ้ย่า อู่ไต่ แม้แน ป่อน แง. ");
INSERT INTO bzi_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ตาฮ้าน อือ เท่วาด่า มางนา มย้าง คู ยาว แค ยืก เลิง แล่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","จี่วีดอางซื้ง มาง เท่วาด่า มาง ค่าบาย่า มาง เย่ดนา จี่ช่าง เย นี้แม้แน, “บ่ากงาแคคา, กงา อางแบ ไน้ย่า พระเยซู ไม้กางเขน ท่า เวอ ตื่อตี้ด แซ่ ชี มางก้อง ล้า แงแน, ");
INSERT INTO bzi_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ยา นู้เวอ บ่าจา กาน, ยางนา ชี ชี นู้เวอ ฮู ล้า ปาว, ยาง จี่ ชี ชี แม้แนย้า แต่ล้าน แล่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ยาง ศิษย์ อือนา อางไว่ แน แอ ม่า แอ ปาว นี้แม้แน, ‘ยา แต่ล้าน แล่ง ญา, ยาว อามือ ยา กาลิลี แควน โย้เวอ นองฮู่ ย้า แลน แง. ยาว นอย่า ยางนา โย้เวอ กงามย้าง แลแง’ อางเลิ่ง นี้ย่า กงา นองนา ลือ ม่า ล่าง ย้างย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ค่าบาย่า มาง เย่ด มือ ท้ามชฺ้างซฺี้ชีย้า โย้เวอ อางไว่อางคย้าง แน อ่อกแอน ชี, เย่ด แคมอางแค กย่าง อางกย่าง แน ฮื่น แอ พระเยซู ศิษย์ อือนา ม่า แอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ทื่อชี่ดยาว พระเยซู มือ ค่าบาย่า มาง เย่ด ล้าก้า เวอ จูง ลือ ชีเย. แน จี่ช่าง เย นี้แม้แน, “อางจาอางดื้งบื้อ ลา?” แน. ยาว เย่ด มือ พระเยซู ล่าคื่อ เวอ อ้อง ค่อด ป่าตูคู บอกไว้ แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ยาว พระเยซู มือ ค่าบาย่า มาง เย่ด นา จี่ช่าง ชี นี้แม้แน, “บ่ากงาแคคา, กงา ชฺ้าง อือนา กาลิลี แควน โย้เวอ ม่าย แล ปี่ ปาว, ยอย่า กงานา โย้เวอ กงามย้าง ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ค่าบาย่า มาง เย่ด แก้บ้า ย่อ แอ เมอ, ตาฮ้าน ท้ามชฺ้างซฺี้ชีย้า ล่อฮู ทื่อบ่า อืมมือ อางเมิง คล้าว โย้เวอ อ้องแล ยาว, ปุโรหิต ยอคา อือนา อางเลิ่ง ตอล้า ชี อือ อู่บน้า ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","แฮ้งเย่ ปุโรหิต ยอคา อือ แน ยิวชฺ้าง ยอคา อือ น้าท้าม ลางกายาว, ตาฮ้าน อือนา พลู้ บย่า ย้าเย่ ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ยอย่า ตาฮ้าน อือนา ม่า จี่ ปี่ชี่ นี้แม้แน, “พระเยซู ศิษย์ อือ ตาฮ้าน ล่อ จา อือ ยู่ เมอ พระเยซู ศพ ย่าง ค่าว แอน ชี แน. ");
INSERT INTO bzi_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ยาว จาว่าแน นี้เลิ่ง ผู้ว่า มางก้อง เคิน แล ยาว, นอย่า เจิ้นเจ้อ บ่ากงา จี่ คา กงู จี่ กานนา นองนา บ่าฮาย ลาบ้าบ ปี่ ล่า.” ");
INSERT INTO bzi_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ตาฮ้าน อืมมือ พลู้ ย่าง ยู้ ยาว ยอง ม่า ชี แม้แน ฮาย คู ชี, แฮ้งย้าเย่ นี้เลิ่ง ย่า ยิวชฺ้าง อือ อามือเคอ แน อู่บ กาแง. ");
INSERT INTO bzi_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","พระเยซู ศิษย์เอก 11 คู่น อืมมือ กาลิลี แควน โย้เวอ แลน คู ชี. ยาว ตาแซ้ พระเยซู ม่ายแล ปี่ชี่ โย้เวอ แลน คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ยองมู ย่าง พระเยซู นา มย้าง คู ยาว ป่าตูคู บอกไว้ ชี. จ้า ทื่อบ่า นืงบา เวอ เย้ง คูง พระเยซู ม้าม้า ย้าล่า แน. ");
INSERT INTO bzi_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","พระเยซู มือ ยองก้อง อ้องล้า ยาว จี่ช่าง เย นี้แม้แน, “พาจาว ม้า กงานา มู่งท่า แน ชฺ้างอางเมิง นู้เวอ ล่าที่ คาโคลาโค ย่าง ปี่ ล่างญา. ");
INSERT INTO bzi_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","นี้แม้แนยาว นองมือ, ชฺ้างอางเมิง นู้เวอ ชฺ้าง กูเจ้อกูจาด อือนา กงา ศิษย์ เพล่อ ล้า ปี่ ปาว, ยองนา ล้างตือพิธีบัพติศมา ฮา ปี่ เมอ, อ่าโบ้งพาจาว, กงา พาจาวอางย่า เพล่อ ชี มาง, อางค่องอางล้า อางเซฺิ่งอางซฺ้าง อางเม้ง นี้ง ไจ ฮา ปี่ โว. ");
INSERT INTO bzi_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","นอย่า กงา กูย่างกูเจ้อ ม่าอู่บ ล่า ชี นี้ง, โค แน ยองนา ม่าอู่บ น้าจ่า ปี่ คู โว! ยาว บ่าลู่ม คูโจ กงาย่า นองก้อง กูญ่าม ย้า จา แงแน, ชฺ้างอางเมิง อางนืงลีน เมอ เคอ ย้า!” แน.");
INSERT INTO bzi_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","นี้ย่า พระเยซูคริสต์ ก่าซ้าด อางฮื่อ พาจาวอางย่า มาง อางเลิ่ง อางแม่น แฮ้ง ต่องก่าต่าง ย้าง. ");
INSERT INTO bzi_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ค้าแต้ เวอ พาจาวจี่ต่างจี่แต่นฮู อิสยาห์ มอ ยาว พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี, “พาจาว ม้า ยาง อางย่า มางนา นี้แม้แน ม่า ชี, ‘แม่น แน น้า ปาว! กงา นาง ฮู่ เวอ ชฺ้าง ป่าวฮู ทื่อม่าง ซฺาแอ ปี่ง, ไม้ ยา นางนา ชฺ้าง นางนา ชา เจ่อ ล่าง อือ ซฺ้า ชี ล่าแง.’ ");
INSERT INTO bzi_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ชฺ้าง แฮ้ม้า ซ่องก่อง อางเว่อ โย้เวอ นี้แม้แน ป่าว แง, ‘จี่วีดอางซื้ง มาง อามือ ชาลือ แง. ปีนแตปีนนา แน ยาง เคอ ลือ แฮ้นืง นา ล่อ คูโว. ค่องช่าง อือ ก่าซ้าด มาง ล้า เมอ แก้บ้า แต่ง ล่อ แฮ้งแม้แน.’” ");
INSERT INTO bzi_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ยาว ชฺ้าง พาจาว มาง จี่ เคอ นี้ม้า ยอห์น เย. ยา ซ่องก่อง อางเว่อ โย้เวอ ดื้ง แง. แน ยา ชฺ้าง อือนา นี้แม้แน ม่าอู่บ แง, “อางบล่าบ ฮา แฮ้ง ว่าง ยาว นืงบา อางซฺื่อ เพ่น แล่ โว! ยาว ล้างตือพิธีบัพติศมา ฮา แล่ คู โว! ยาว พาจาว มาง นองนา อางซีอางบล่าบ บ่ายู่ ล่า!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ชฺ้าง อางอีบ่าอ่า ยูเดีย แควน กูต่องกูตี่ อือ ก้อง จายล้า คูชี, แน เยรูซาเล็ม อางเมิง แน จอร์แดน ล้างบ้า ก่องทาง อือก้อง จายล้า คูชี. ยองมู นี้ย่า ยอห์น ม่าอู่บ แฮ้ง น้า ล้า คูชี. แน ค่าตอง อางบล่าบ ฮา ชี อือ ยอห์น นา ม่ายแบ ปี่ชี่. ยาว ยอห์น มือ ยองนา จอร์แดน ล้างบ้า โย้เวอ ล้างตือพิธีบัพติศมา ฮา ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ยอห์น อางก่าอางตูม ตูม แล่ชี่ แฮ้ย่า อูฐ อางมื่อ แฮ้ง ไจ แต่ง ชี. ยาง ไซฮาง อางจ่อ ฮีด แล่ชี่ แฮ้ย่า ซ้าดอางคอ. ยาง จฺ่าเกิ่ง แฮ้ย่า ญ่ามไป่ แน ปย่าจฺื่อ. ");
INSERT INTO bzi_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ยอห์น ชฺ้าง อือนา นี้แม้แน ป่าว ม่า แง, “ชฺ้าง ทื่อม่าง จา แง. ยา กงา น่อง เวอ ลือ แง. ยา กงา ล่อบ่าปา ล่าที่ ฮื่อ แง. กงา อางโต นี้ย่า ยางนา แค้บ ล่าตื่อ พื้อ ปี่ เวิม บ่าซูม. ");
INSERT INTO bzi_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","กงา นองนา ล้าง แฮ้ง ไจ พิธีบัพติศมา ฮา ปี่ ล่าง. จ้า ชฺ้าง แฮ้ม้า นองนา อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง ไจ พิธีบัพติศมา ฮา ปี่ ล่าง!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","แฮ้ญ่ามเมอ พระเยซู มือ นาซาเร็ธ ค่อง โย้เวอ จาย จอร์แดน ล้างบ้า โย้เวอ แลน ชี. นาซาเร็ธ ค่อง นี้ย่า กาลิลี แควน โย้เวอ ดื้ง แง. แน พระเยซู มือ ยอห์น ก้อง ล้างตือพิธีบัพติศมา ฮา แล่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","พระเยซู ล้าง คล้าว โย้เวอ อ่อก ล้า เมอ, ยาง ซฺ้อก ย้า มู่ง แฮ้ง พอง อ่อก นา มย้าง ชี. แน ยาว พระเยซู มือ มย้าง ชี, พาจาว มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ฮาย่า อางป่อน แม้แน แต่ง แล่ยาว, ยางก้อง ปย้าม แป่ก ลือ ชีแน. ");
INSERT INTO bzi_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ยาว พาจาว มาง มู่งท่า โย้เวอ จาย นี้แม้แน จี่ ชี, “ค่า เวอ, นา อ่าโบ้ง อางย่า ลาก มาง ย้า. อ่าโบ้ง นางนา นืงบาจาบ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","พระเยซู ล้างตือพิธีบัพติศมา ฮา แล่เปิน ยาว, ซฺ้อก ย้า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ยางนา ซ่องก่อง อางเว่อ โย้เวอ ซฺื่ย ดื้ง แล ชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ยาว พระเยซู มือ โย้เวอ 40 นืง ดื้ง ชี. แน แฮ้ญ่ามเมอ ซาตานแด่ย่ายอคา มาง พระเยซู นา นืงบาเจ้อฮู ชี. แน พระเยซู ดื้ง ชี โย้เวอ ซ่องก่อง ซ้าด อางโซ้ก คาตา จา แง. จ้า เท่วาด่า อืม พระเยซู นา ฮูพลา แง. ");
INSERT INTO bzi_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ยอห์น นา คอก ชู ล้อง ยาว, พระเยซู มือ กาลิลี แควน โย้เวอ แลน ชี. แน ต่องก่าต่าง พาจาว มาง อางเลิ่ง อางแม่น แฮ้ง ชฺ้าง อือนา ป่าว ม่าอู่บ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","พระเยซู นี้แม้แน จี่ เย, “พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ อางญ่าม แท้ ล้าน ญ้า. อางบล่าบ ฮา แฮ้ง ว่าง ยาว นืงบา อางซฺื่อ เพ่น แล่ โว! แน อางเลิ่ง อางแม่น นี้เลิ่ง เจ่อ โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ทื่อนืง จา แง, พระเยซู ลองอองอางฮื่อ กาลิลี แปฟาง โย้เวอ ย่อ จา เมอ, อันดรูว์ แน ซีโมน ฮาก เปโตร แน ฮ้าว มางนา มย้าง ชี. อันดรูว์ ซีโมน อางแพ้. แน เย่ด ล่องแต่ซฺ้าชฺ้าง, แฮ้ญ่าม เมอ เย่ด ฮอจื้ง จาน จา แง. ");
INSERT INTO bzi_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ยาว พระเยซู มือ เย่ดนา นี้แม้แน จี่ช่าง ชี, “กงาก้อง เค่ ล้าน ปาว. แน กงาย่า ไน้นา ชฺ้าง นา ซฺื่ย กงาก้อง ซฺ้า ล้า ล่าง แฮ้ง ม่าอู่บ แบ ปี่ ล่าว่า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ยาว เย่ด มือ ซฺ้อก ย้า ฮอจื้ง วี ยาว พระเยซู ก้อง เค่ แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","พระเยซู อางอี้ ย่อ แลน แล่ เมอ, ยากอบ แน ยอห์น เย่ดนา มย้าง แล ชี. เย่ด เศเบดี อางย่าย่าค่า. แน แฮ้ญ่ามเมอ เย่ด ล้อง คล้าว โย้เวอ ฮอจื้ง กู่ ดื้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","พระเยซู มือ ซฺ้อก ย้า เย่ดนา ฮ้าว ชี. ยาว เย่ด มือ อางโบ้ง มางนา ล่ากานว่าฮู อือก้อง ล้อง โย้เวอ ชี ช่า ยาว, พระเยซู ก้อง เค่ แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","พระเยซู แน ศิษย์ อืม คาเปอรนาอุม อางเมิง โย้เวอ แอน คูชี. ลองนืง เคิน ยาว พระเยซู มือ ยิวชฺ้าง โบสถ์ โย้เวอ อ้อง แลน ชี. แน ค่องช่าง อือนา ม่าอู่บ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ค่องช่าง อือ พระเยซู ม่าอู่บจี่ต่าง แฮ้ง กงากย่า คู เมอ, นาบาตา ย้า นืงบาม่าน คูชี, ไม้ พระเยซู ม่าอู่บ นี้ย่า อางลี้บอางล่าว ม่าอู่บฮู อือ ม่าอู่บ แฮ้งนา บ่าตู่. จ้า ยา พาจาว มาง ก้อง ล่าที่ ม้าม้า จายลือ ชี แฮ้ง ไจ ม่าอู่บ แง. ");
INSERT INTO bzi_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","แฮ้ญ่ามเมอ ค่าพ่าย่า ทื่อม่าง จา แง. ยางนา แด่ย่า อ่อง ปี่ชี่. ยาว ยาง ยิวชฺ้าง โบสถ์ โย้เวอ ย่อ อ้อง ล้าน ชี. แน นี้แม้แน จี่ โฮ้กฮ้าว ชี, ");
INSERT INTO bzi_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“โอ้! พระเยซู นาซาเร็ธชฺ้าง เวอ, นา กงูนา บ้าเจอ ฮา ล่าแง? นาง นู้เวอ ล้า ชี นี้ย่า กงูนา ก่างพยา ล้า ล่างลา? กงา อางแบ ย้า นา อ่าซ่าง แน. นา พาจาว มาง ชฺ้าง อางเซฺิ่งอางซฺ้าง มาง ย้า!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","จ้า พระเยซู มือ แด่ย่า มางนา นี้แม้แน อี่ ชี, “กยาบ ยาว อ่อกแอน โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ยาว แด่ย่า มาง ค่าพ่าย่า ม่าง อางโต แฮ้งนา ฮา แล่ง แน ยืก ปี่ชี่. แน ค่าพ่าย่า แฮ้มาง โฮ้กฮ้าว ล่าน ชี. ยาว แด่ย่า แฮ้มาง อ่อก ชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ยาว ค่องช่าง คาโคลาโค อืม นืงบาม่าน คูชี. ยองมู แฮ้ง นี้แม้แน น้าท้าม ลางกา ชี, “บ้าเจอตอนล้าชี? นี้ย่า ม่าอู่บจี่ต่าง อางซฺื่อ ลา? ค่าพ่าย่า นี้ม้า ล่าที่ อางจา ม้าม้า ย้า. ยา แด่ย่า อือนา อางม่า กงา กา. แน แด่ย่า อืม ยางนา น้าจ่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","บ่ามล่าง ยาว ชฺ้าง กาลิลี แควน กูต่องกูตี่ เวอ ดื้ง คูชี อืม พระเยซู อางเลิ่ง แฮ้ง แบ โค คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ยาว พระเยซู แน ศิษย์ อืม ยิวชฺ้าง โบสถ์ โย้เวอ อ่อกแอน คูชี. ตื่น ยากอบ แน ยอห์น เย่ด คาตา ย้า. ยาว ยองมู แฮ้ง ซฺ้อก ย้า ซีโมน แน อันดรูว์ เย่ด ยู้ม โย้เวอ แลน คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ซีโมน ย่อบา ม้า อางม้างกย้า ยู่ป่าม โย้เวอ ยู่น ชี. พระเยซู เคิน แล เมอ, ค่องช่าง อืม ซฺ้อก ย้า ซีโมน ย่อบา มาง อางเลิ่ง แฮ้ง อู่บน้า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ยาว พระเยซู มือ ซีโมน ย่อบา มางนา ซฺ้าแล ชี. แน ยางนา ล่าปู่ ชู ค้อง ทานล้า ปี่ชี่. ยาว ซีโมน ย่อบา มาง ซฺ้อก ย้า อางม้างกย้า แฮ้ง โปยว คาชี. ยาว ซีโมน ย่อบา มาง พระเยซู แน ยาง ศิษย์ อือนา ฮ่าง จฺ่าเกิ่ง ซฺ้า จฺ่าต้าง ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","มู่งคี่ล้าก้า เคอ มู่งนื่ง กลา เมอ, ค่องช่าง อืม ชฺ้าง อางด้า แน ชฺ้าง แด่ย่า อ่อง ชี อือนา ซฺื่ย พระเยซู นา ซฺ้า ล้า คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ยาว ค่องช่าง คาโคลาโค อืม ซีโมน ยู้ม ล้าก้า โย้เวอ ช้อน ลางกา ชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","แน พระเยซู มือ ชฺ้าง พ่าญาด ต่างไล เพล่อ คูชี อือนา อางบย่า ย้า พ่าญาด ยา โปยว ปี่ชี่. แน แด่ย่า อางบย่า ย้า ก่าอ่อก ชี. จ้า ยา แด่ย่า แฮ้อือนา เจิ้นเจ้อ บ่าปี่ จี่, ไม้ แด่ย่า แฮ้อือ อางแบ ย้า พระเยซู อ่าซ่าง แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ยาว พระเยซู มือ ซอทา อางด่า บ่าแปล่น ฮู่ เวอ ยู่ ทานล้า ชี. แน ซีโมน ยู้ม โย้เวอ อ่อกแลน ชี. ยา ตีอางกยาบ ชฺ้าง บ่าจา โย้เวอ พาจาว มางนา อธิษฐาน ฮา แล ชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","นืงก้องก้อง ยาว ซีโมน แน ยาง อางช่าง อืม พระเยซู นา ซฺ้ากว่า คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","พระเยซู นา ซฺ้า มย้าง เมอ, ยองมู แฮ้ง ยางนา นี้แม้แน จี่ช่าง คูชี, “อ่าจาน เวอ, ค่องช่าง คาโคลาโค อือ นางนา ซฺ้ากว่า ล่า คูง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","จ้า พระเยซู มือ นี้แม้แน พอ ชี, “กงา ชฺ้างอางเมิง นู้เวอ ลือ ชี นี้ย่า, ไม้ ชฺ้าง อือนา ม่าอู่บ ลือ แง. นี้แม้แนยาว กงูนา ฮาก อางเมิง อือก้อง แอ ปี่ ล่าปาว. กงา โย้เวอ ค่องช่าง อือนา คาตา ย้า กงา ม่าอู่บ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","แฮ้งย้า พระเยซู มือ กาลิลี แควน กูต่องกูตี่ อือเมอ แอ้น ชี. แน ยา ยิวชฺ้าง โบสถ์ อือเมอ ม่าอู่บ ชี. แน แด่ย่า ชฺ้าง นา อ้อง ชี อือนา อางอีบ่าอ่า ก่า อ่อก ชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ค่าพ่าย่า ทื่อม่าง จา แง, คี้ตู้ด เพลิ่น ชี. ยา พระเยซู นา ซฺ้า ล้า ชี. แน ยา พระเยซู นา บอกไว้ ยาว ป้า ปล่อง ปี่ชี่. แน ยา นี้แม้แน จี่ แง, “จาว่าแน นาง กงานา อางปล่อง ล่าซี่ แนยาว, กงา อางโปยว ม้าม้า ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","พระเยซู มือ ชฺ้าง คี้ตู้ด แฮ้มางนา ซื่งกง่ากย้า แง. แฮ้งย้า ยาง ล่าปู่ ย่าง กลาง อ่อกแอ ปี่ชี่. แน ชฺ้าง คี้ตู้ด แฮ้มางนา ว่า ชี. แน นี้แม้แน จี่ ชี, “โอ่ย, กงา นางนา อางปล่อง ล่าซี่ ย้า โปยว ปาว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ยาว ซฺ้อก ย้า ค่าพ่าย่า แฮ้มาง คี้ตู้ด เพล่อ ชี แฮ้ง โปยว ชี. แน ยาง อางซฺ่าอางคอ อืม แม่นมาง ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ยาว พระเยซู มือ ชฺ้าง คี้ตู้ด มางนา ชา แอ ปี่ เมอ นี้แม้แน ม่า ชี, ");
INSERT INTO bzi_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“อ่าซ่าง มางนา นี้เลิ่ง บ่าอู่บน้า ปี่ โจ, จ้า ปุโรหิต มางนา ฮู ปี่ โว. แน อางเกิ่งท่านเซฺ่อ แฮ้ง ท่าน โว, โมเสส ชฺ้าง คี้ตู้ด เพล่อ ยาว โปยว ชี อือนา ม่า ฮา ปี่ชี่ แฮ้งแม้แน, ไม้ ชฺ้าง คาโคลาโค อือนา แบ ปี่ง น้อ, นาง คี้ตู้ด นี้ย่า โปยว ญ้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","จ้า ค่าพ่าย่า นี้ม้า พระเยซู นา เจิ่ก ยาว, อางเลิ่ง ตอล้า ชี แฮ้ง ฮากนา อู่บน้า ปี่ชี่. ฮาก แบ โค เมอ, ชฺ้าง อางอีบ่าอ่า พระเยซู นา เค่ คูชี. แฮ้งย้า พระเยซู มือ ค่อง คล้าว โย้เวอ บ่าอ่อง แล ตอ กาแง. แฮ้งย้า ยาง มือ ค่อง อางเง้ อ่าซ่าง มาง บ่าจา โย้เวอ ดื้ง แอ ชี. แน ค่องช่าง อืม กูต่องกูตี่ เวอ จาย ยางนา ซฺ้า ล้า คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","2-3 นืง จายล้า แล่ยาว พระเยซู มือ คาเปอรนาอุม ค่อง โย้เวอ พ่าว แลน แล่ชี่. แน ค่องช่าง อืม แบ โค ชี, พระเยซู ซีโมน ยู้ม โย้เวอ ดื้ง แงแน. ");
INSERT INTO bzi_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","แฮ้งย้า ค่องช่าง อืม ซีโมน ยู้ม โย้เวอ แล ชอน ลางกา ชี. แน ยองมู นี้ย่า ซีโมน ยู้ม คล้าว โย้เวอ ปลืงแท่ง ลางกา ชี, ยู้ม ล้องก้อ ล้าก้า โย้เวอ ล้อน อ่อก ลือ แอ เคอ ย้า. พระเยซู มือ ยองนา พาจาวจี่ต่าง แฮ้ง ป่าว ม่าอู่บ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","แฮ้ญ่ามเมอ ค่าพ่าย่า 4 คู่น จา แง. ยองมู นี้ย่า ชฺ้าง ต่องแก่ ทื่อม่าง นา อ่าเพ่น เวอ ยู่ ปี่ ยาว ปล่อง ลาม ลางกา ชี. แน พระเยซู ก้อง ซฺื่ย ล้าน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","จ้า ยองมู นี้ย่า ชฺ้าง ต่องแก่ มางนา พระเยซู ก้อง แท้ แน บ่าซฺื่ย อ้องแล กงา กา, ไม้ ชฺ้าง นาบาตา บย่า. แฮ้งย้า ยอง มือ พระเยซู ดื้ง ชี แฮ้ต้าด เวอ ยู้มมู้ง แฮ้ง พอง อ่อก ชี. ยาว ชฺ้าง ต่องแก่ มางนา อ่าเพ่น โย้เวอ ยู่ ปี่ ยาว กล่ามกล่าม แน พระเยซู ก้อง คลา ลู่ง แอ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","พระเยซู มือ ยอง เจ่อ คูง แฮ้ง กงามย้าง เมอ, ชฺ้าง ต่องแก่ มางนา นี้แม้แน จี่ช่าง ชี, “อางย่า เวอ, กงา นางนา อางซีอางบล่าบ บ่ายู่ ล้าก้าน” แน. ");
INSERT INTO bzi_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","อางลี้บอางล่าว ม่าอู่บฮู ทื่อบ่า โย้เวอ ดื้ง จา แง. ยองมู นี้ย่า นืงบา เวอ นี้แม้แน เย้ง คูง, ");
INSERT INTO bzi_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ชฺ้าง นี้ม้า พาจาว มางนา จี่ ฮูย้า แง, ไม้ ชฺ้าง อือนา อางซีอางบล่าบ บ่ายู่ นี้ย่า พาจาว มาง ญา ฮา กงา กาแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","จ้า พระเยซู อางแบ ย้า ยอง นืงบา โย้เวอ บ้าเจอ เย้ง คูง แน. แฮ้งย้า ยาง นี้แม้แน จี่ ชี, “บ้าเจอ นอ นี้แม้ อางเย้ง คู แน? ");
INSERT INTO bzi_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","กงานา ชฺ้าง ต่องแก่ นี้มางนา บ้าเจอล้อแม้ จี่ช่าง ปี่ ล่าง, ‘กงา นางนา อางซีอางบล่าบ บ่ายู่ ล้าก้าน’ แน จี่ ปี่ ล่าง ลา? อ้าว ‘ทานล้า โว, นาง อ่าเพ่น แฮ้ง กอ ปาว, แน ย่อ แลน ปาว’ แน จี่ปี่ ล่าง ลา? บ้าเจอล้อแม้ จี่ แฮ้ง ไง่ แง? ");
INSERT INTO bzi_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","จ้า กงา นองนา ฮา มย้าง ปี่ ล่าง, ชฺ้างอางย่า ม้า ล่าที่ อางจา, ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา อางซีอางบล่าบ บ่ายู่ เวิม อางกงา” แน. ยาว พระเยซู มือ ชฺ้าง ต่องแก่ มางนา จี่ช่าง ชี, ");
INSERT INTO bzi_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ทานล้า โว, อ่าเพ่น กอ ยาว ยู้ม เวอ พ่าว แลน โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ชฺ้าง ต่องแก่ ม่าง ทานล้า ยาว อ่าเพ่น กอ ยาว ย่อ อ่อกแอน ชี. ค่องช่าง อือ มย้าง ยาว นาบาตา ย้า นืงบาม่าน คูชี. แน ยอง พาจาว มางนา สรรเสริญ ฮา คูชี. แน นี้แม้แน จี่ คูชี, “โอ้! กงู นี้แม้ บ่ามย่าง กางซื้ง น่อ!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","พระเยซู มือ แปฟาง ลองอองอางฮื่อ กาลิลี โย้เวอ พ่าว แลน แล่ชี่. แน ชฺ้าง อางอีบ่าอ่า ยางนา ซฺ้า ล้า ชี. แน พระเยซู มือ ยองนา ม่าอู่บ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","พระเยซู ม่าอู่บ เปิน ยาว ย่อ พ่าว แอ แล่ เมอ, ภาษี กอย้า โย้เวอ ชฺ้าง ภาษีกอฮู ทื่อม่าง นา มย้าง ชี. ยาง อางเม้ง เลวี, แน ยา อัลเฟอัส อางย่าย่าค่า. เลวี ก้อง อางเม้ง ทื่อเม่ง จา แล่ง มัทธิว แน. ยาว พระเยซู มือ เลวี นา นี้แม้แน ม่า ชี, “กงาก้อง เค่ ล้าน โว!” แน. เลวี มือ ทานล้า ยาว พระเยซู ก้อง เค่ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","มู่งคี่ล้าก้า เคิน ยาว พระเยซู มือ เลวี ยู้ม โย้เวอ ฮ่างจฺ่า แอ ชี. ชฺ้าง ภาษีกอฮู อือ แน ชฺ้าง อางบล่าบ อือ อางอีบ่าอ่า พระเยซู ก้อง เค่ แอน คูชี. แน ยอง อางมู โย้เวอ ชฺ้าง ทื่อบ่า อือย่า, พระเยซู แน ศิษย์ อือก้อง ทื่งกง่า แน ฮ่างจฺ่า ดื้ง คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","อางลี้บอางล่าว ม่าอู่บฮู ทื่อบ่า จา แง. ยองมู นี้ย่า ฟาริสี อือ อางมู. ฟาริสี อางมู นี้ย่า ยิวชฺ้าง อือ ศาสนา แฮ้ง ปีนแตปีนนา ย้า ทื้อ คูแง. แน ยอ พระเยซู นา มย้าง ชี ชฺ้าง ภาษีกอฮู อือก้อง แน ชฺ้าง อางบล่าบ อือก้อง ทื่งกง่า แน ฮ่างจฺ่า ดื้ง ชี แน. แฮ้งย้า ยอง พระเยซู ศิษย์ อือนา นี้แม้แน น้า คูชี, “พระเยซู คื่อ แฮ้อือ ก้อง บ้าเจอฮา ทื่งกง่า แน ฮ่างจฺ่า ดื้ง แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","พระเยซู มือ ยอง จี่ แฮ้ง กงากย่า ยาว ยองนา นี้แม้แน พอ ชี, “ชฺ้าง บ่าด่าบ่ากย่าง อือย่า มอ นา บ่ากงา ซี้, จ้า ชฺ้าง อางด้าอางกย้าง อือย่า มอ นา กงา พ่าญาด ยา แล่ซี่ แง. กงา ชฺ้าง ฮาก นาบทื้อ คูชี อือนา ซฺ้า ลืง บ่าอ่า, จ้า ชฺ้าง อางบล่าบ ฮาก บ่านาบบ่าทื่อ อือนา ซฺ้า ลืง แง, ไม้ ยองนา นืงบาเพ่น อางบล่าบ ฮา แฮ้ง ว่าง ปี่ง แนนอ” แน. ");
INSERT INTO bzi_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","แฮ้ญ่ามเมอ ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ มาง ศิษย์ อือ, แน ฟาริสี ศิษย์ อือ ฮ่างจฺื่ง พาจาว มางนา อธิษฐาน ฮา คูชี. ยาว ชฺ้าง ทื่อบ่า จา แง, พระเยซู นา ซฺ้า ล้า ชี. แน ยางนา นี้แม้แน น้า ชี, “บ้าเจอ นาง ศิษย์ อือย่า ฮ่าง บ่าจฺื่ง คู แน, ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ มาง ศิษย์ อือ แน ฟาริสี ศิษย์ อือ แม้แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","พระเยซู มือ นี้แม้แน พอ ชี, “นอย่า ชฺ้าง, แต่งงาน ฮา ล่ากาน เวอ ล้า คูชี อือนา, ฮ่าง จฺ่าเกิ่ง บ่าจฺ่า แน พ่าว แอ แล่ ปี่ง ลา? นอ นี้แม้แน บ่าฮา อ่าลา? เจ้าบ่าว มาง ยอง ก้อง ทื่งกง่า แน ดื้ง เมอ, ยองมู นี้ย่า ฮ่าง บ่าจฺื่ง เป. ");
INSERT INTO bzi_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","จ้า เจ้าบ่าว มางนา ซฺื่ยแล แฮ้นืง เคิน ล้า เมอ, ยองมู แฮ้ง เจ้าบ่าว มาง ก้อง ทื่งกง่า แน บ่ากงา ดื้ง, แน ยองมู แฮ้ง ฮ่างจฺื่ง คูแง. กงา ศิษย์ อืม ทื่อช่างกานญา, กงา จา เมอ ยอ ฮ่าง บ่ากงา จฺื่ง, จ้า กงา แลน เมอ ยอ ฮ่างจฺื่ง อธิษฐาน กงาฮา คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ยาว พระเยซู มือ ยองนา อางเลิ่ง อู่บ เพ้กน้า ปี่ชี่, ยาง ม่าอู่บจี่ต่าง นี้ย่า ม่าอู่บจี่ต่าง อางซฺื่อ แน. ยา นี้แม้แน จี่ แง, “อ่าซ่าง มาง พ้า อางซฺื่อ แฮ้ง ค่าลาว อางอ้าน เวอ อางต้อง บ่าต่อ, ไม้ พ้า อางซฺื่อ นี้ย่า อี ลู่ง เมอ, ค่าลาว อางอ้าน แฮ้งนา จาก แช ปี่ง. แน อางอ้าน ล่อบ่าปา ย้า อางฮ้อน กลื้อ อ่อกแอ แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ยาว พระเยซู มือ ยองนา อางเลิ่ง ทื่อเลิ่ง อู่บ เพ้ก น้า แล่ ปี่ชี่, ยาง ม่าอู่บจี่ต่าง นี้ย่า อ่างู่น แต่ค่า อางซฺื่อ ซ้าด อางคอ ปาไต่ อางซฺื่อ เวอ กาน ชี อือ แม้แน ย้า. ยา นี้แม้แน จี่ แง, “อ่าซ่าง มาง อ่างู่น แต่ค่า อางซฺื่อ แฮ้ง, ซ้าด อางคอ ปาไต่ อางอ้าน เวอ บ่าท่อก กาน, ไม้ อ่างู่น แต่ค่า อางซฺื่อ นี้ย่า ซ้าด อางคอ ปาไต่ อางอ้าน แฮ้งนา ฮา ปล่าก ปี่ง. นี้แม้แนยาว ตื่น อ่างู่น แต่ค่า แน ซ้าด อางคอ ปาไต่ แฮ้ง ก่างพยา แง. ม้าม้า นี้ อ่างู่น แต่ค่า อางซฺื่อ นี้ย่า ซ้าด อางคอ ปาไต่ อางซฺื่อ เวอ กงากาน แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ทื่อนืง จา แง, พระเยซู แน ศิษย์ อือ กอแต่ โย้เวอ ย่อ ไก คูชี. แฮ้นืง ย่า ลองนืง. ศิษย์ อืม นาบาตา ฮ่างแบ่ คูแง. แฮ้งย้า ยอง กอน้าม ย่าง เชอ ช่าจฺ่า คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ฟาริสี อือ แฮ้แม้แน มย้าง ยาว ยอง พระเยซู นา นี้แม้แน จี่ ชี, “ฮู ปาว, อามือ นาง ศิษย์ อือย่า ลองนืง อางลี้บอางล่าว เวอ ม่ายฮา ปี่ชี่ แฮ้งแม้แน บ่าฮา เค่ คู, ไม้ อามือ ยอ ลองนืง เวอ ล่ากาน ว่า คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ยาว พระเยซู มือ ยองนา นี้แม้แน พอ ชี, “นอย่า พระคัมภีร์ เวอ บ่ากงา อ้าน กางซื้งลา? ก่าซ้าด ดาวิด แน ยางชฺ้าง อือ แบ่ซฺู่ เมอ, บ้าเจอล้อแม้ ฮา คูชี แน? ");
INSERT INTO bzi_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ยา โบสถ์ พาจาว มาง ดื้งย้า โย้เวอ อ้อง แลน ชี. แน พาจาว มางนา ค้านู้มป่าง ท่าน ชี แฮ้ง จฺ่า ชี. นี้เลิ่ง อาบีอาธาร์ ปุโรหิต ยอคา เพล่อ เมอ ตอล้า ชี. กงู ศาสนา อางลี้บอางล่าว นี้ย่า, ปุโรหิต อืน ญา พาจาว มางนา ค้านู้มป่าง ท่าน ชี แฮ้ง จฺ่า กงา กาแง. จ้า ก่าซ้าด ดาวิด ค้านู้มป่าง แฮ้ง จฺ่า ชี. อ่าจ่าม มือ ยาง ชฺ้าง อือนา คาตา ย้า เปิ่ง จฺ่า ปี่ชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ยาว พระเยซู มือ ยองนา นี้แม้แน ม่า ชี, “พาจาว ม้า ชฺ้างอางเมิง นู้เวอ ลองนืง จา ปี่ แง, ไม้ ชฺ้าง อือนา ปล่อง แนนอ. ชฺ้าง อือนา ลองนืง ปาปาย ตูกพานลาบ้าบ ปี่ง บ่าอ่า. ");
INSERT INTO bzi_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","นี้แม้แนยาว กงาชฺ้างอางย่า เพล่อ ชี่ นี้ม้า, ล่าที่ อางจา ลองนืง ล่อบ่าปา ฮื่อ แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ทื่อนืง จา แง ลองนืง เวอ, พระเยซู ยิวชฺ้าง โบสถ์ โย้เวอ ม่าอู่บ ดื้ง เมอ, ค่าพ่าย่า ล่าปู่ อางแล่บ ทื่อม่าง จา แง. ");
INSERT INTO bzi_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","อางลี้บอางล่าว ม่าอู่บฮู อือ แน ฟาริสี อืม พระเยซู นา ล่อ ฮู แง, อ่าซ่าง นา ลองนืง เวอ พ่าญาด ยา ปี่ แงแน, ไม้ ยอ พระเยซู นา อางเลิ่ง จี่ เซฺ่อ ซฺ้า เย. ");
INSERT INTO bzi_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","พระเยซู มือ ค่าพ่าย่า ล่าปู่ อางแล่บ มางนา นี้แม้แน จี่ช่าง ชี, “ชฺ้าง อางมู ล้าก้า นู้เวอ จูง ล้า โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ยาว พระเยซู มือ ค่องช่าง อือนา นี้แม้แน น้า ชี, “กงา น้า ล่า ปานา, กงู อางลี้บอางล่าว นี้ย่า ลองนืง เวอ บ้าเจอ ม่า ฮา ปี่ชี? อางเลิ่ง อางแม่น ฮา ล้า, อ้าว อางเลิ่ง บ่าแม่น ฮา แง? ชฺ้าง นา จี่วีด ปล่อง ล้า, อ้าว ก่างพยา แง?” แน. จ้า ยองมู แฮ้ง กยาบ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","พระเยซู มือ นืงบาค่า ชี แน ก่าคย่าวคย่าว ชี. ยา นืงบาค่า ยอง แมก่า เวอ ฮูน ชี, นี้มางนา ฮู แฮ้มางนา ฮู แน. แน ยา ยอง แฮ้แม้แน เพล่อ ชี แฮ้ง ปาปาย ก่าคย่าวคย่าว แง, ไม้ ยองมู นี้ย่า อางล้าน แน บ่ากง่าบ่าเกิง คู. ยาว พระเยซู มือ ค่าพ่าย่า ล่าปู่ อางแล่บ มางนา นี้แม้แน จี่ช่าง ชี, “ล่าปู่ กลาง อ่อก ล้า ปี่ โว!” แน. ยาว ค่าพ่าย่า แฮ้มาง ยาง ล่าปู่ อางแล่บ แฮ้ง กลาง อ่อกแอ ปี่ชี่. ยาว ยาง ล่าปู่ แล่บ ชี แฮ้ง โปยว ชี. ");
INSERT INTO bzi_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ฟาริสี อือ แฮ้แม้แน มย้าง เมอ, ยอง ยิวชฺ้าง โบสถ์ อางเง้ เวอ อ่อกแอน คูชี. แน ซฺ้อก ย้า ก่าซ้าด เฮโรด ชฺ้าง อือนา ซฺ้า แอ คูชี. แน ยองมู แฮ้ง ปล่อง เย่ง ลางกา ชี, พระเยซู นา บ้าเจอล้อแม้ แซ่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","พระเยซู แน ศิษย์ อืม ลองอองอางฮื่อ กาลิลี โย้เวอ แลน คูชี. แน ชฺ้าง อางอีบ่าอ่า พระเยซู ก้อง เค่ แลน คูชี. ชฺ้าง นี้อือ อางมู โย้เวอ ชฺ้าง ทื่อบ่า อือย่า, กาลิลี แควน แน ยูเดีย แควน เวอ จายล้า คูชี. แน ชฺ้าง ทื่อบ่า อือ เยรูซาเล็ม อางเมิง แน เอโดม แควน เวอ จายล้า คูชี. แน ชฺ้าง ทื่อบ่า อือ, ค่อง จอร์แดน ล้างบ้า ก่องทาง เวอ ดื้ง ชี อือเมอ จายล้า คูชี. แน ชฺ้าง ทื่อบ่า อือ ค่อง ไทระ อางเมิง ก่องทาง เวอ, แน ไซดอน อางเมิง ก่องทาง เวอ ดื้ง ชี อือเมอ จายล้า คูชี. ชฺ้าง คาโคลาโค พระเยซู นา ซฺ้า ล้า คูชี นี้ย่า, ไม้ ยอ ฮาก พระเยซู อางเลิ่ง ฮา ชี อือ จี่ กา ชี แฮ้ง กงากย่า คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ชฺ้าง นาบาตา บย่า แฮ้ง ปาปาย ย้า พระเยซู มือ ยาง ศิษย์ อือนา ม่า ล้อง ทื่อล่าม ซฺ้า ยางนา ปี่ ปี่ชี่. แน ยาง ล้องตา ชี. ยาง นี้แม้แน ฮา ชี นี้ย่า, ไม้ ชฺ้าง อือนา ยางก้อง บ่าปี่ ปลืงแท่ง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","พระเยซู มือ ชฺ้าง อางด้าอางกย้าง อือนา อางอีบ่าอ่า พ่าญาด ยา โปยว ปี่ชี่. แฮ้งย้า ชฺ้าง พ่าญาด เพล่อ คูชี อืม ปลืงแท่ง พระเยซู ก้อง อ้อง ล้าน คูชี, ไม้ พระเยซู นา ว่า คูง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","แน อ้าล่อมเมอ ชฺ้าง แด่ย่า อ่อง ปี่ชี่ อือ พระเยซู นา มย้าง แง, ยอง ซฺ้อก ย้า พระเยซู นา บอกไว้ คูแง. แน นี้แม้แน จี่ โฮ้ก คูง, “นา พาจาวอางย่า!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","จ้า พระเยซู มือ แด่ย่า อือนา ปีนแตปีนนา ย้า นี้แม้แน ม่า แง, “กงา อ่าซ่าง แน ฮากนา บ่าม่า โจ!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ยาว พระเยซู มือ ตาแซ้ ท่า เวอ ตา แลน ชี. แน ชฺ้าง ยางนา เค่ ปี่ ซีง อือนา ฮ้าว ล้า ปี่ชี่. ยาว ชฺ้าง แฮ้อืม ยางนา ซฺ้า ล้า คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ยาว พระเยซู มือ ชฺ้าง 12 คู่น แช้ยู้ ยาง ศิษย์เอก เพล่อ ปี่ชี่. แน ยาง ยองนา นี้แม้แน จี่ช่าง ชี, “กงา นองนา แช้ยู้ กงาก้อง ทื่งกง่า แน ดื้ง ปี่ ล่าง. แน กงา นองนา ไจ ชฺ้าง อือนา ม่าอู่บ กว่า แอ ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","แน กงา นองนา ล่าที่ จา ปี่ ล่าง. นอง ล่าที่ นี้ย่า แด่ย่า ชฺ้าง นา อ้อง ชี อือนา ก่า อ่อก อางกงา” แน. ");
INSERT INTO bzi_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","นี้ย่า ศิษย์เอก 12 คู่น พระเยซู แช้ยู้ ชี อือ อางเม้ง ย้าง เป, ซีโมน, พระเยซู ยางนา เปโตร แน อางเม้ง อางซฺื่อ เม้ง ปี่ ชี, ");
INSERT INTO bzi_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ยากอบ แน ยอห์น, เย่ด เศเบดี อางย่าย่าค่า. พระเยซู เย่ดนา โบอาเนอเย แน ฮ้าว, มู่งเจ่ อางย่า แน ฮา แง. ");
INSERT INTO bzi_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","อันดรูว์, ฟีลิป, บารโธโลมิว, มัทธิว, โธมัส, ยากอบ อัลเฟอัส อางย่าย่าค่า ม่าง, ธัดเดอัส, ซีโมน อิสราเอล อางเจ้ออางจาด นา ลาก มาง, ");
INSERT INTO bzi_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","แน ยูดาส อิสคาริโอท กาญ่าม เวอ พระเยซู นา บ่าแม่น ฮาช่าง มาง. ");
INSERT INTO bzi_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ยาว พระเยซู มือ ยู้ม เวอ พ่าว แอน แล่ชี่. ยาว ชฺ้าง อางอีบ่าอ่า โย้เวอ จูง ช้อน ลางกา แล่ชี่. แฮ้งย้า พระเยซู แน ยาง ศิษย์ อืม ฮ่างจฺ่าญ่าม บ่าจา แง. ");
INSERT INTO bzi_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","พระเยซู ยู้มชฺ้าง อือ พระเยซู นา ซฺ้าล้า ชี, ไม้ ยอ ฮาก นี้แม้แน จี่ กาง แฮ้งนา กงากย่า ชี, “เยซู เปิดบา เพลิ่น ชี” แน. แฮ้งย้า ยอง พระเยซู นา ยู้ม เวอ ชา ซฺื่ย พ่าว แล คูแง. ");
INSERT INTO bzi_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","อางลี้บอางล่าว ม่าอู่บฮู ทื่อบ่า จา แง. เยรูซาเล็ม อางเมิง โย้เวอ จายล้า ชี. แน ยองมู นี้ย่า นี้แม้แน จี่ คูง, “เยซู นา ซาตานแด่ย่ายอคา อางเม้ง เบเอลเซบูล แน ชี่ มาง อ้อง ปี่ชี่. แฮ้งย้า ยาง แด่ย่า ก่า อ่อก กงา กาแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","แฮ้งย้า พระเยซู มือ ค่องช่าง อือนา ฮ้าว ล้า ปี่ชี่. แน อางเลิ่ง อู่บ เพ้กน้า ปี่ชี่. ยา นี้แม้แน จี่ แง, “ซาตานแด่ย่ายอคา นี้ย่า ค่าตอง อางมู อือนา อางก่า ฮื่น ปี่ ลา? ");
INSERT INTO bzi_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","อางเมิง ล้อเมิง ก้อง ชฺ้าง อือ ซีแล บ่าโลง กาแง, แฮ้เมิง อางเมิง เพล่อ แล แล่ บ่ากงา เป. ");
INSERT INTO bzi_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ยาว ยู้มชฺ้าง ล้อยู้ม ซีแล กาง, ยอ ก่างพยา แง. ");
INSERT INTO bzi_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","นี้แม้แนยาว ซาตานแด่ย่ายอคา มาง ทื่อช่างกานญา, จาว่าแน ยาง แด่ย่า ค่าตอง ย่าเจ่น เพล่อ ชี อือนา ก่างพยา ยาว, ยา แด่ย่ายอคา บ่าเพล่อ แล แล่ ตอ กา. จ้า ยา ก่างพยา แง. ");
INSERT INTO bzi_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ม้าม้า นี้ย่า ฮาก ยู้ม เวอ อางเกิ่ง ค่าว ฮื่น นี้ย่า, จาว่าแน ยู้มซื้ง อางแก่นอางคา มางนา บ่าชู พือ ชี ยาว, อ่าซ่าง มาง ยู้ม คล้าว โย้เวอ อางเกิ่ง แฮ้ง บ่าค่าว ฮื่น กงากา. จ้า จาว่าแน ยู้มซื้ง อางแก่นอางคา มางนา ชู พือ ชี ยาว, ยู้ม คล้าว โย้เวอ อางเกิ่ง แฮ้ง อางค่าว ฮื่น กงากา ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“กงา ม่า แบ ปี่ ล่าว่า, พาจาว ม้า ชฺ้าง อางบล่าบ กูย่างกูเจ้อ ฮา ชี อือนา, แน ชฺ้าง คาโคลาโค ฮากนา จี่ ฮูย้า ชี อือนา, อางซีอางบล่าบ บ่ายู่ เวิม อางกงา ย้าแน. ");
INSERT INTO bzi_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","จ้า พาจาว ม้า ชฺ้าง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มางนา, จี่ ฮูย้า ชี อือนา อางซีอางบล่าบ ยู้ แง, ไม้ ชฺ้าง แฮ้อือ อางบล่าบ ฮา ชี แฮ้ย่า, ยองนา ฮา ชฺ้าง อางบล่าบ เพล่อ แล ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","พระเยซู นี้แม้ จี่ นี้ย่า, ไม้ ชฺ้าง ทื่อบ่า จา แง, ยางนา นี้แม้แน จี่ ชี, “เยซู นา แด่ย่า อ่อง ปี่ชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ยาว พระเยซู อางบา แน อางแพ้ อืม เคิน ล้า ชี. ยองมู นี้ย่า ยู้ม อางเง้ โย้เวอ จูง ล่อ คูชี. แน ชฺ้าง อือนา ม่า พระเยซู นา ฮ้าว แล ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","แฮ้ญ่ามเมอ ค่องช่าง อืม พระเยซู นา ดื้ง แวด คูชี. แน ยองมู แฮ้ง พระเยซู นา นี้แม้แน จี่ช่าง ชี, “นาง อางบา แน นาง อางแพ้ อือ นางนา ยู้ม อางเง้ โย้เวอ ล่อ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","พระเยซู มือ นี้แม้แน น้า ชี, “กงา อางบา แน กงา อางแพ้ อือย่า อ่าซ่าง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ยาว พระเยซู มือ ค่องช่าง ยางนา ดื้ง แวด ชี อือนา ฮู ชี. แน นี้แม้แน จี่ ชี, “นู้เวอ ชฺ้าง นี้อือ กงา อางบา, กงา อางแพ้ อือ ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","กงา อางบา, กงา อางแพ้ แน กงา อางป่อ ม้าม้า อือย่า, ชฺ้าง พาจาว มาง นืงบาจาบวา แน ฮาย เค่ อือ ย้าเป” แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ทื่อนืง จา แง, พระเยซู ลองอองอางฮื่อ กาลิลี ก่องทาง โย้เวอ ม่าอู่บ แล แล่ชี่. ชฺ้าง อางอีบ่าอ่า ยางนา จูง แวด ชี. แฮ้งย้า ยาง ล้อง ท่า เวอ ตา ดื้ง แล ชี. ยาว ค่องช่าง อืม พระเยซู ม่าอู่บจี่ต่าง แฮ้ง แปฟาง ท่า อือเมอ จูง น้า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","พระเยซู มือ ยองนา อางเลิ่ง ไล เลิ่ง ย้า จี่เพ้ก ม่าอู่บ ชี. ยา นี้แม้แน จี่ แง, ");
INSERT INTO bzi_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“แม่น แน น้า โว, น่าว่าฮู ทื่อม่าง จา แง. อ่อกแอ กอย่าว ปยา แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","กอย่าว ปยา เมอ, กอย่าว ทื่อบ่า อือย่า แก้บ้า ย่อย่า อือเมอ กลาน ชี. ยาว ฮาย่า ดอก จฺ่า โค ชี. ");
INSERT INTO bzi_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","กอย่าว ทื่อบ่า อือย่า ลอบา ท่า เวอ นื้งชฺ่า จา ชี อือเมอ กลาน ชี. ยาว กอย่าว แฮ้ง อางไว่ ย้า แต่ล้าน ชี, ไม้ นื้งชฺ่า บ่าน่า. ");
INSERT INTO bzi_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","จ้า นื้งช้า ช่อ เมอ ล้อง ยาว แฮ่ว กือ ซฺี้น ชี, ไม้ อางเช บ่าน่า. ");
INSERT INTO bzi_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","กอย่าว ทื่อบ่า อือย่า จี่กู่แต่ เวอ กลา แอ ยาว, จี่กู่ปาว ย่าง โปกปาว ฮา ซฺี้ ปี่ ชีเย. แฮ้งย้า กอ ป้าง แฮ้ง กอน้าม บ่าอ่อก ล้า แง. ");
INSERT INTO bzi_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","จ้า กอย่าว ทื่อบ่า อือย่า นื้งชฺ่า อางแม่น อือเมอ กลาน ชี. แฮ้งย้า แต่ ฮื่อ มอง ล้า แม่นมาง ชี. แน กอน้าม พลอง อ่อก ล้า กอ กงา ชี 30 โตบ, 60 โตบ แน 100 โตบ” แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “อ่าซ่าง น่าซื่ง จา แง, แม่น แน น้า คูปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","พระเยซู ทื่อม่าง แน จา เมอ, ศิษย์เอก 12 คู่น แน ชฺ้าง ทื่อบ่า พระเยซู ม่าอู่บจี่ต่าง แฮ้ง กงากย่า คูชี อืม พระเยซู นา ซฺ้า ล้า ชี. แน ยางนา ป้า อางเลิ่ง เพ้ก ม่าอู่บ ชี อือ จี่ไค้ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ยาว พระเยซู มือ ยองนา นี้แม้แน ม่า ชี, “นอง ญา เป พาจาวอางเมิง อางเลิ่งอางโชง แฮ้ง กงาแบ คูแง, ฮาก บ่ากงา แบ เป. จ้า กงา ฮากนา อางเลิ่ง เพ้ก ม่าอู่บ กาน แง, ");
INSERT INTO bzi_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ไม้ พระคัมภีร์ โย้เวอ มอ ชี ชี แฮ้งแม้แน เพล่อ ปี่ง แนนอ. พระคัมภีร์ โย้เวอ นี้แม้แน มอ ชี ชี, ‘ยองมู นี้ย่า ฮู เวิม ฮู แล่ ย้า, จ้า บ่าฮู มย้าง กา, น้า เวิม น้า แล่ ย้า, จ้า บ่าน่ากลา กา, ไม้ ยอง มย้าง เมอ แบน ยาว, ยอ พาจาว มางนา พ่าวซฺ้า ล้า แง. แน พาจาว มาง ยองนา อางซีอางบล่าบ บ่ายู่’” แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ยาว พระเยซู มือ ยองนา นี้แม้แน น้า ชี, “นองมู นี้ย่า อางเลิ่ง เพ้ก ม่าอู่บ นี้เลิ่ง นา บ่าน่ากลา กาซื้ง ลา? ท้าว นอ บ้าเจอล้อแม้ อางเลิ่ง เพ้ก ม่าอู่บ ทื่อบ่า อือนา น้ากลา กาแง? ");
INSERT INTO bzi_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","น่าว่าช่าง นี้ม้า พาจาวจี่ต่าง ป่าว ม่าอู่บฮู แน ทื่อช่างกานญา. ");
INSERT INTO bzi_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ชฺ้าง ทื่อบ่า อือย่า กอย่าว แก้บ้า ย่อย่า กลา ชี อือ ช้อดย้า. ยอง พาจาวจี่ต่าง กงากย่า เมอ, ซาตานแด่ย่ายอคา มาง ซฺ้อก ย้า ย่าด ฮื่น แง. ");
INSERT INTO bzi_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ยาว ชฺ้าง ทื่อบ่า อือย่า กอย่าว ลอบา ท่า นื้งชฺ่า จา ชี อือเมอ กลา ชี อือ ช้อด ย้า. ยองมู นี้ย่า พาจาวจี่ต่าง กงากย่า เมอ, นืงบาต่องม่อนซ้า แง. แน ซฺ้อก ย้า พาจาวจี่ต่าง แฮ้ง นืงบา เวอ กอ ชี คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","จ้า ยอ พาจาวจี่ต่าง แฮ้ง ปีนแตปีนนา แน บ่าแบ คู. แฮ้งย้า พาจาวจี่ต่าง แฮ้ง ยอง นืงบา เวอ อางมล่าง แน บ่าดื่ง แง. จาว่าแน ยอง พาจาวจี่ต่าง เจ่อ ชี แฮ้ง ปาปาย, แน ฮาก ยองนา คาม ฮาย ตูกพานลาบ้าบ ปี่ ยาว, ยอ ซฺ้อก ย้า พาจาวจี่ต่าง เจ่อ ชี แฮ้ง ว่าง แง. ");
INSERT INTO bzi_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ชฺ้าง ทื่อบ่า อือย่า กอย่าว จี่กู่ปาว กลา ชี อือ ช้อด ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ชฺ้าง นี้อือ พาจาวจี่ต่าง กงากย่า ชี อือ ย้า. จ้า ยอ ชฺ้างอางเมิง นู้เวอ จี่วีด ไจ จาดื้ง แฮ้ง พี้ล้อง แง. แน อางเกิ่งอางก้อ ค่าม พลู้ อือนา ลาก แง. แน ตานฮา จา กูย่างกูเจ้อ ย้า กงา ซี้ แง. แฮ้งย้า พาจาวจี่ต่าง แฮ้ง ยอง ก้อง จองไจ บ่าจา แง. ยาว นี้ย่า ยอง จี่วีด แฮ้งนา จี่กู่ ปาว ชี ปี่ชี่ ช้อด ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","จ้า ชฺ้าง ทื่อบ่า อือย่า กอย่าว นื้งชฺ่า อางแม่น เวอ กลา ชี อือ ช้อด ย้า. ยองมู นี้ย่า พาจาวจี่ต่าง กงากย่า ยาว นืงบา คล้าว กอ ชี ชี. แน จองไจ ตอล้า ชี 30 โตบ, 60 โตบ แน 100 โตบ” แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ยาว พระเยซู มือ นี้แม้แน จี่ แลน แล่ชี่, “อ่าซ่าง จา แง ต่องซฺื่อลาน จฺ่อ ยาว นื้งชฺ่าอู่ล่อง โคบ ชี แงแน? บ่าอ่ายาว ต่องซฺื่อลาน จฺ่อ ยาว ป้าเซ้อ อ่อก เวอ จ่อตื้ง แงแน? ต่องซฺื่อลาน นี้ย่า จฺ่อ ยาว ต่องซฺื่อลานตื้งย้า เวอ จ่อตื้ง อ่าลา? ");
INSERT INTO bzi_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ยาว ม้างม้าเจ้อ ชฺ้าง อือ ค่าวโชง ชี ชี อือย่า, กาญ่าม เวอ พาจาว มาง, ชฺ้าง คาโคลาโค อือนา ฮา มย้าง ปี่ แง. แน อางเลิ่ง ฮากนา บ่าปี่ แบ อือย่า อ่อก ล้า ฮากนา กงาแบ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","อ่าซ่าง น่าซื่ง จา แง แม่น แน น้า โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","พระเยซู มือ นี้แม้แน คาตา ย้า จี่ แล่ชี่, “นอง จี่ต่าง กงากย่า ชี นี้ง แม่น แน เย้ง ฮู ปาว. นอง นี้ป้าค้า ล้อม้อก ฮา แง, นอง มือ แฮ้ ล่อ ย้า แบ บย่า เค่ แง. แน พาจาว ม้า นองนา แฮ้ ล่อบ่าปา แบ ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","นอ ชฺ้าง น้าฮู บ้าเจอล้ออือเจ้อ เพล่อ แง. ชฺ้าง กงา ม่าอู่บ ยาว น้า อือ บย่า แน แบ เค่ แง. จ้า ชฺ้าง กงา ม่าอู่บ ยาว บ่าน่า อือ, แน อางแบ ย้า แน เย้ง จ่าแล่ง อือ, พาจาว ม้า ยาง แบ ชี แฮ้ง ยู้ คื่น แล่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","พระเยซู มือ นี้แม้แน จี่ แลน แล่ชี่, “พาจาวอางเมิง นี้ย่า กอย่าว แต่ อ่อก ล้า มอง ฮื่อ แล แฮ้งแม้แน ย้า. ค่าพ่าย่า ทื่อม่าง จา แง. ย้า เวอ กอชาว แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ค่าพ่าย่า แฮ้ม้า มู่งคี่ เวอ ยู่ แง. แน นืงก้อง เวอ ล่ากาน ว่า แง. แน ยาง กอชาว ชี แฮ้ง แต่ อ่อก ล้า แง. แน ตื่น มู่งคี่ นืงก้อง ย้า มอง ฮื่อ แล แง. จ้า ยา บ่าแบ กอซื่อ แฮ้ บ้าเจอล้อแม้ แต่ มอง ฮื่อ แล ชี แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","นื้งชฺ่า นี้ย่า กอย่าว อือนา ฮา แต่ อ่อก ล้า มอง ฮื่อ ปี่ แง. ต่องก่า เวอ กอย่าว แฮ้ง แต่ อ่อก ล้า อางป้าง อางย่า เพล่อ เปิน แง. ยาว น่อง เวอ กอป้าง อางย่า แฮ้ง มอง ฮื่อ แล แง. แน กอน้าม อ่อก ล้า กอซื่อ เพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","กอซื่อ อือ ซฺื้อ เมอ ค่าพ่าย่า แฮ้ มาง กี่ว ท่าม อ่อกแอ กอแย่ แอ แง, ไม้ กอแย่ญ่าม เคิน ป้าน่อ” แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ยาว พระเยซู มือ นี้แม้แน จี่ แลน แล่ชี่, “กงา พาจาวอางเมิง นี้งนา บ้าเจอ นา เพ้ก ลื่อว้า? บ้าเจอ ล้อเลิ่ง เพ้ก น้า ปี่ ล่าว้า? ");
INSERT INTO bzi_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ม่าต่าโก้บ นือ นา เพ้ก นา. ม่าต่าโก้บ นือ นี้ย่า นื้งชฺ่า เวอ คลา เมอ อางนือ นาบาตา อี. ");
INSERT INTO bzi_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","จ้า มอง ฮื่อ ล้าน ยาว ซื่อย่าวก่างย่าว คาโคลาโค อือ ล่อบ่าปา อางป้าง มอง แง. แน ล่างาม อ่อก แง. ฮาย่า อางป่าม แต่ง ดื้ง อางกงา” แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","พระเยซู ค่องช่าง อือนา พาจาวจี่ต่าง แฮ้ง ม่าอู่บ เมอ, อางเลิ่ง นี้ป้าค้า ไลเลิ่ง ย้า เพ้ก ม่าอู่บ ชี, ยอง กงากย่า ยาว น้ากลา กาง แฮ้ง วา ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ยา ค่องช่าง อือนา อางเลิ่ง เพ้ก ม่าอู่บ แง กูเลิ่ง ย้า. จ้า ยาง ศิษย์ อือ ยอง แอ่ แน ดื้ง เมอ, ยา ยาง ฮากนา อางเลิ่ง เพ้ก ม่าอู่บ ชี อือ กูย่างกูเจ้อ ย้า จี่ไค้ ยองนา แบ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","มู่งคี่ล้าก้า แฮ้นืง เวอ, พระเยซู มือ ยาง ศิษย์ อือนา นี้แม้แน จี่ช่าง ชี, “กงู ลองอองอางฮื่อ ทื่อปล่าก ป่ากย่า คาม แอน ปยา” แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","พระเยซู ศิษย์ อืม ค่องช่าง อือนา ชี ช่า ยาว, ล้อง พระเยซู ดื้ง จา ชี มาง ก้อง ตา แอ คูชี. ยาว ฮาก คาตา ย้า ล้อง ทื่อบ่า อือ ก้อง ตา ยองนา เค่ แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ยาว ฮ้างม้าน ตอน ชี นาบาตา ย้า แล่ง แง. แฮ้งย้า ล้างฮ้าด เอิก ล้อง คล้าว โย้เวอ อ้อง ล้าน ชี, ล้อง คล้าว โย้เวอ ล้าง ป้าดจา ปลืง ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","แฮ้ญ่าม เมอ พระเยซู ล้อง ต่องซี่ โย้เวอ ตู่คู คู ยู่ ชี. แฮ้งย้า ศิษย์ อืม พระเยซู นา ตาแค ทานล้า ปี่ชี่. แน ยองมู นี้ย่า นี้แม้แน จี่ คูง, “อ่าจาน เวอ, นา กงูนา บ่าตี่นบ่าต่อง ล้าลา? นา กงู ล้างนื่อ แซ่ แล่ นา บ่าว่าม ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","แฮ้งย้า พระเยซู มือ ทานล้า ยาว, ฮ้างม้าน แน ล้างฮ้าด อือนา นี้แม้แน ม่า ชี, “ว่าง ยาว กยาบ โว!” แน. ยาว ซฺ้อกย้า ฮ้างม้าน อางแล่ง ตอ ชี แฮ้ง ว่าง ยาว กยาบ ชี. แน ล้างฮ้าด เอิก กว่า แฮ้ง ว่าง ยาว กยาบ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ยาว พระเยซู มือ ยาง ศิษย์ อือนา นี้แม้แน จี่ช่าง ชี, “บ้าเจอฮา แค คูง? บ้าเจอ กงานา นืงบาบ่าชี่ ล้า แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","จ้า พระเยซู ศิษย์ อือย่า นาบาตา ย้า แค คูง. ยองมู นี้ย่า นี้แม้แน น้า กาแง, “ยา อ่าซ่าง ม้าม้า เวอ? ซ้ามบ้า ฮ้างม้าน แน ล้างฮ้าด อืม ยางนา น้าจ่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","พระเยซู แน ยาง ศิษย์ อืม ลองอองอางฮื่อ กาลิลี ทื่อปล่าก ป่ากย่า เคิน แล ชี. แน โย้เวอ เกราซา อางเมิง ชฺ้าง อือ ดื้งย้า ย้างเย่. ");
INSERT INTO bzi_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","พระเยซู ล้อง โย้เวอ อ่อก ล้า เมอ, ซฺ้อก ย้า ค่าพ่าย่า ทื่อม่าง นา มย้าง ชี. ค่าพ่าย่า แฮ้มางนา แด่ย่า อ่อง ปี่ชี่. แน ยา ท้ามชฺ้างซฺี้ชีย้า โย้เวอ ฮื่น อ่อก ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ค่าพ่าย่า นี้ม้า ท้ามชฺ้างซฺี้ชีย้า อือเมอ ดื้ง แง. ยางนา อ่าซ่าง มาง โซ่ บ่าชู พือ ชี แล่ กงากา, ");
INSERT INTO bzi_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ไม้ ยางนา ล่าปู่ แน ล่าคื่อ โย้เวอ โซ่ พือ ชี ไลเทอ เคิน ญา. จ้า ยาง มือ กูเทอ ย้า โซ่ แฮ้ง จาก วี แง. ค่าพ่าย่า นี้ม้า นาบาตา ย้า แก่นคา แง. อ่าซ่าง มาง ยางนา บ่าชู ดื้ง กงากา. ");
INSERT INTO bzi_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ยา ตื่น มู่งคี่ นืงก้อง ย้า ท้ามชฺ้างซฺี้ชีย้า แน ตาแซ้ อือเมอ ย่อ ซ้อดแซ้ด โฮ้กฮ้าว กว่า แง. แน ลอบา แฮ้ง ยาง อางโต อือเมอ คีด แล่ง. ");
INSERT INTO bzi_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ยาว ยาง พระเยซู นา อางเว่อ เมอ จาย ย้า ฮู มย้าง ชี. แฮ้งย้า ยาง ฮื่น ล้า พระเยซู นา ซฺ้าน ล้า ชี. แน พระเยซู นา ป่าตูคู บอกไว้ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","แน ยาง มือ นี้แม้แน จี่ โฮ้กฮ้าว ชี, “พระเยซู พาจาว อางฮื่อ เลิ่นเลิ่น อางย่า มาง เวอ, บ้าเจอฮา กงานา ตี่นต้อง ล่าง! พาจาว มางนา ก่ามค่าน ปี่ ปาว, นา กงานา บ่าฮา ด้ากย้าง ลาบ้าบ ปี่ ล่า!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ค่าพ่าย่า นี้มาง นี้แม้แน จี่ ชี นี้ย่า, ไม้ พระเยซู ยางนา นี้แม้แน ม่า ชี, “แด่ย่า บ่าแม่น เวอ, อ่อกแอน โว! ค่าพ่าย่า นี้มาง อางโต นู้เวอ บ่าดื่ง โจ!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","แฮ้งย้า พระเยซู มือ ยางนา นี้แม้แน น้า ชี, “นาง อางเม้ง บ้าเจอล้อแม้?” แน. แด่ย่า แฮ้มาง นี้แม้แน พอ ชี, “กงา อางเม้ง อางมู แน, ไม้ กงู ค่าพ่าย่า นี้มาง อางโต นู้เวอ ไล โต น่อ ดื้ง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ยาว แด่ย่า อืม พระเยซู นา ไลเทอ ย้า ป้า ชี, ยองนา ตี แฮ้มาง ก้อง บ่าก่า ฮื่น ปี่ โจ แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","แฮ้ญ่ามเมอ ว่า ทื่อมู จา แง. ว่าปอฮู อือ ตาแซ้ ก่องทาง อือเมอ อางจ้า ซฺ้าจฺ่า กว่า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","แฮ้งย้า แด่ย่า อืม พระเยซู นา นี้แม้แน ป้า คูชี, “กงูนา ว่า นี้อือ ก้อง อ้อง ปี่ ล่าปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ยาว พระเยซู มือ แด่ย่า อือ ยางนา ป้า ชี แฮ้งแม้แน ฮา ปี่ ชี. แฮ้งย้า แด่ย่า อืม ค่าพ่าย่า แฮ้มาง ก้อง อ่อก ชี, แน ว่า อือ ก้อง อ้อง แอ ชี. ยาว ว่า คาโคลาโค 2,000 โต อืม ตาแซ้พยางพยาง โย้เวอ ฮื่น แล คูชี. แน ลองอองอางฮื่อ เวอ เปิก กลา แอน คูชี. แน ล้าง นื่อ แซ่ แล่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ว่าปอฮู อืม ฮื่น แล อางเลิ่ง ตอล้า ชี แฮ้ง ฮากนา ม่า กว่า แล ชี. ตื่น อางเมิง คล้าว เวอ ดื้ง อือ แน อางเมิง อางเง้ เวอ จา คูชี อือนา คาตา ย้า. แฮ้งย้า ยอง อางเลิ่ง ตอล้า ชี แฮ้ง อ่อก ฮูน ลือ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ยองมู แฮ้ง พระเยซู นา ซฺ้า ล้า คูชี. แน ค่าพ่าย่า แด่ย่า ไล โต แน อ้อง ปี่ชี่ มางนา มย้าง คูชี. ค่าพ่าย่า แฮ้ม้า อางก่าอางตูม ก่าตูม แล่ชี่ แน ฮาก แม้แน วี่ไซป้านญา จา ล้า ชี. ยาว ยองมู แฮ้ง แคน คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ยาว ชฺ้าง นี้เลิ่ง กงามย้าง คูชี อืม ค่าพ่าย่า แด่ย่า อ่อง ปี่ชี่ มาง ก้อง อางเลิ่ง ตอล้า ชี แฮ้ง, แน ว่า อือ ก้อง อางเลิ่ง ตอล้า ชี แฮ้ง ยองนา อู่บน้า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","แฮ้งย้า ยอง พระเยซู นา ป้า ยอง อางเมิง โย้เวอ อ่อกแอ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","พระเยซู ล้อง คล้าว โย้เวอ ลู่ง ดื้ง แอ เมอ, ค่าพ่าย่า แด่ย่า อ่อง อาน มาง พระเยซู นา ป้า เค่ แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","จ้า พระเยซู มือ ยางนา บ่าปี่ เค่ แอ, ยา ค่าพ่าย่า แฮ้มางนา นี้แม้แน ม่า ชี, “ยู้ม เวอ พ่าว แล นาง ยู้มชฺ้าง อือนา ซฺ้า แล ปาว. แน ยองนา ม่า แบ ปี่ว จี่วีดอางซื้ง ม้า นางนา บ้าเจอ ฮา ปี่ ล่าชี่, แน ยา นางนา ล้อม้อก แม่น ช่าง ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","แฮ้งย้า ค่าพ่าย่า แฮ้มาง พระเยซู นา เจิ่ก แอน ชี. แน เดคาโปลิส แควน อือเมอ ต้าว ย้า ฮากนา ซฺ้า ม่า กว่า ชี, พระเยซู ยางนา แด่ย่า ก่า อ่อก ปี่ชี่ แน. แน ชฺ้าง คาโคลาโค กงากย่า คูชี อืม นาบาตา ย้า นืงบาม่าน คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","พระเยซู มือ ล้องตา ลองอองอางฮื่อ กาลิลี ทื่อปล่าก ป่ากย่า พ่าว แอน แล่ชี่. ลองอองอางฮื่อ ก่องทาง โย้เวอ ชฺ้าง อางอีบ่าอ่า พระเยซู นา ซฺ้า ล้า ชี. แน ยองมู นี้ย่า พระเยซู นา ดื้ง แวด คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ค่าพ่าย่า ทื่อม่าง จา เย อางเม้ง ไยรัส แน. ยา ยิวชฺ้าง โบสถ์ โย้เวอ ยอคา เย. ยาว ยาง พระเยซู ล่าคื่อ เวอ บอกไว้ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","แน ยา พระเยซู นา ปีนแตปีนนา ย้า ป้า ยาง อางย่าย่าบี่ มางนา ปล่อง ปี่ชี่. ยา นี้แม้แน จี่ แง, “กงา อางย่าย่าบี่ อางอี มาง อางม้างกย้า ชา ซฺี้ แง. ยางก้อง ล่าปู่โบ่ย แอ ปาว, ไม้ ยาง อางม้างกย้า แฮ้ง โปยว คาไล. แน ยางนา จี่วีด จา แล แล่ ปี่ เซฺ้อ” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ยาว พระเยซู มือ ไยรัส นา เค่ แอน ชี. ชฺ้าง อางอีบ่าอ่า พระเยซู นา ย่อ เค่ ชี. ยองมู นี้ย่า ปลืงแท่ง ลางกา ชี. แน พระเยซู ก้อง แน่ง อ้องแล คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ชฺ้าง อางมู โย้เวอ ค่าบาย่า ทื่อม่าง จา แง. ยา ซฺี่ ลู่ง บ่าตื่อ ว่าง กาแน เพล่อ ล้า 12 ปี เคิน ญา. ");
INSERT INTO bzi_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ค่าบาย่า นี้ม้า มอ ซฺ้า ค่าตอง พ่าญาด แฮ้ง ยา แล่ชี่ ไล คู่น ย้า. แน ยาง พลู้ แฮ้ง พ่าญาด ยาฮู่ ปี่ โค เวิม ยาง พ่าญาด แฮ้ง บ่าเช ล้า. จ้า อางอ้าน แฮ้ง ล่อบ่าปา เพล่อ แล่ง เค่ แล่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ค่าบาย่า นี้ม้า พระเยซู อางเลิ่ง แฮ้ง กงากย่า ชี. แฮ้งย้า ชฺ้าง อางมู โย้เวอ ย่อ วาน อ้องแล, พระเยซู น่องน่อง โย้เวอ จูง แล ยาว ค่าลาว เวอ ว่า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ยา นืงบา เวอ นี้แม้แน เย้ง แง, “จาว่าแน กงา พระเยซู อางก่าอางตูม โย้เวอ ว่า ยาว, กงา พ่าญาด นี้ง อางโปยว ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ค่าบาย่า นี้มาง พระเยซู ค่าลาว โย้เวอ ว่า ยาว, ยาง ซฺี่ ลู่ง ย้าง ซฺ้อก ย้า ว่าง ชี. แน ยาง มือ แบ จ่าน แล่ชี่ ยาง พ่าญ่าด นี้ย่า โปยว ญา แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","พระเยซู มือ ซฺ้อก ย้า แบน ชี ยาง อางโต เวอ ล่าที่ นี้ย่า อ่อกแอ ชีแน. แฮ้งย้า ยาง มือ ชฺ้าง อางมู ยางนา ย่อ เค่ ล้า ชี อือนา พลาบ ฮู กว่า ชี. แน นี้แม้แน น้าน ชี, “อ่าซ่าง กงา ค่าลาว นู้เวอ ว่า ชีม้า?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ยาง ศิษย์ อืม นี้แม้แน พอ คูชี, “อ่าจาน เวอ, ฮู ปาว ชฺ้าง อางอีบ่าอ่า ปลืงแท่ง ลางกา ชี. แน ยองมู นี้ย่า แน่ง กา นางก้อง อ้อง ล้าน คูชี. ท้าว นา บ้าเจอฮา นี้แม้แน น้า แง, ‘อ่าซ่าง กงานา ว่า ล่าชี่ ม้า?’” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","จ้า พระเยซู มือ ยาง ค่าลาว เวอ ว่า ชี มางนา ฮู ซฺ้า กว่า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ค่าบาย่า แฮ้มาง ยาง อางเลิ่ง ฮา ชี แฮ้งนา แค ยืก แง. แฮ้งย้า พระเยซู นา ป่าตูคู บอกไว้ ชี. ยาว อางเลิ่ง ม้าม้า แฮ้ง อู่บ น้า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ยาว พระเยซู ค่าบาย่า ม่างนา จี่ช่าง ชี นี้แม้แน, “อางย่า เวอ, นาง เจ่อ ชีนี้ง ปาปาย ย้า นางนา ฮา บ่าจาบ่าดื่งบื้อ นี้ง โปยว ปี่ ล่าชี่ นี้ย่า. จาบื่อดื้งบื้อ แน จี่วีด จา แล โว, แน นา บ่าลาบ้าบ แล่ก้าน” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","พระเยซู จี่ ย้าง บ่าลีน กื้ง กาซื้ง. ชฺ้าง ทื่อม่าง จา แง. ไยรัส ยู้ม เวอ จายล้า ชี. ไยรัส นา นี้แม้แน ม่า ล้า ชี, “ไยรัส เวอ, นาง อางย่า ม้า ซฺี้น ญ้า. อ่าจาน มางนา บ่าฮา พี้ล้อง ปี่ กานโจ” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","พระเยซู มือ เย่ด จี่ กาง แฮ้ง กงากย่า ชี. แฮ้งย้า ไยรัส นา นี้แม้แน ม่า ชี, “บ่าแค โจ! กงานา เจ่อ ล่า กาโน” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","พระเยซู ฮากนา บ่าปี่ เค่ แอ. ยา เปโตร, ยากอบ แน ยอห์น ยากอบ อางแพ้ มางนา ญา เค่ แอ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ยาว ยองมู แฮ้ง ไยรัส ยู้ม เคอ แอ คูชี. ยาว พระเยซู มือ ไยรัส ยู้ม เวอ ชฺ้าง อือ อู้ง ซืกซาก นา มย้าง ชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","พระเยซู มือ ยู้ม คล้าว โย้เวอ อ้อง แลน ชี. ยาว ยู้ม คล้าว โย้เวอ ชฺ้าง อู้ง อือนา นี้แม้แน ม่า ชี, “นองมู นี้ย่า บ้าเจอฮา อู้ง แกล่กแย้ว ซืกซาก คูแง? ย่าเก แฮ้ม้า บ่าซฺี่ กาซื้ง. จ้า ยา ยู่น ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","จ้า ยองมู แฮ้ง พระเยซู นา อื้อ กาน คูชี. แฮ้งย้า พระเยซู มือ ชฺ้าง แฮ้อือนา ม่า อางเง้ อ่อกแอ ปี่ชี่. ยาว ย่าเก มาง อางบา อางโบ้ง, แน ยาง ศิษย์ 3 คู่น อือนา, ซฺื่ย อางฮ้อง คล้าว ย่าเก มาง จา โย้เวอ อ้อง แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","พระเยซู มือ ย่าเก ค่าบาย่า มาง ล่าปู่ เวอ ชู ชี. แน นี้แม้ จี่ ชี, “ทาลิธา คูมิ” แน. นี้แม้แน ฮา แง, “ย่าเก อางอี เวอ, ทานล้าโว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ย่าเก ค่าบาย่า มาง ซฺ้อก ย้า ทานล้า ชี. แน อางฮ้อง คล้าว โย้เวอ ย่อ กว่า ชี. (ย่าเก ค่าบาย่า นี้ม้า อ่าญู 12 ปี.) ชฺ้าง อางเลิ่ง ตอล้า ชี นี้ง กงามย้าง คูชี อืม นืงบาม่าน คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","จ้า พระเยซู มือ ยองนา ปีนแตปีนนา ย้า ม่า ชี, อ่าซ่าง มางนา นี้เลิ่ง บ่าอู่บน้า ปี่ โจ แน. แน ยา ยองนา ม่า ย่าเก แฮ้มางนา ฮ่าง จฺ่าเกิ่ง ซฺ้า จฺ่า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","พระเยซู มือ ไยรัส ยู้ม โย้เวอ เจิ่ก อ่อก แลน ชี. แน นาซาเร็ธ ค่อง ยาง ค่อล้า ชี โย้เวอ พ่าว แลน ชีเย. ยาว ศิษย์ อือ คาตา ย้า เค่ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ลองนืง เคิน ล้า ยาว พระเยซู มือ ยิวชฺ้าง โบสถ์ โย้เวอ ม่าอู่บ ชี. ชฺ้าง อางอีบ่าอ่า พระเยซู ม่าอู่บจี่ต่าง แฮ้ง กงากย่า ยาว นืงบาม่าน ชี. แน ยองมู นี้ย่า นี้แม้แน จี่ กาแง, “ยา บ้าเจอล้อเกิ้ง วี่ไซป้านญา นี้ป้าค้า กงาย ล้า ชี? ยา บ้าเจอล้อแม้ อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา กงา กาชี? ");
INSERT INTO bzi_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ยา ล่าไม ซ้าล้า กานแอ อ่าลา? ยา มารีย์ อางย่าย่าค่า กานแอ อ่าลา? แน ยากอบ, โยเสส, ยูดาส, ซีโมน ยอง อางอ้าย กานแอ อ่าลา? แน ยาง อางป่อ อือย่า ค่อง นี้ ค่อง ก้องเวอ กงู ก้อง ทื่งกง่า ย้า ดื้ง คูง อ่าลา?” แน. แฮ้งย้า ยอง พระเยซู นา บ่าเจ่อ คู. ");
INSERT INTO bzi_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","พระเยซู มือ ยองนา นี้แม้แน จี่ช่าง ชี, “พาจาวจี่ต่างจี่แต่นฮู นี้ย่า บ้าเจอล้อเกิ้ง ดื้ง เวิม ฮาก นาบทื้อ แง. ค่าตอง ค่อง เวอ ค่องช่าง, แน ย่าช่างม่องน้าม, แน ค่าตอง ยู้มชฺ้าง อืน ญา ยางนา บ่านาบบ่าทื่อ แน” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","แฮ้งย้า พระเยซู มือ โย้เวอ ดื้ง เมอ, อางเลิ่งกาบ่ากาเจ้อ ชฺ้างบ่าฮาตอกางอือ บ่าฮา แล่แง. ยา ชฺ้าง อางด้า ทื่อบ่า อือนา ล่าปู่ โบ้ย พ่าญาด ยา ปี่ นี้งญา ฮา ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","พระเยซู มือ ค่องช่าง อือ ยางนา บ่าเจ่อ แฮ้งนา นืงบาม่าน ชี. ยาว พระเยซู มือ ค่อง อางต่องอางทาง อือเมอ แอน ชี. แน โย้เวอ ค่องช่าง อือนา ม่าอู่บ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","พระเยซู มือ ศิษย์ 12 คู่น อือนา ฮ้าว ล้า ปี่ชี่. ยาว ยองนา อางกู่ แน ซฺาแอ ปี่ชี่. พระเยซู ยองนา แด่ย่า อือ ล่อบ่าปา แน ล่าที่ จา ปี่ชี่. แฮ้งย้า ยอง แด่ย่า ชฺ้าง ก้อง อ้อง ชี อือนา ก่า อ่อก กงา กาชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","แน พระเยซู มือ ยองนา นี้แม้แน ม่า ชี, “เจิ้นเจ้อ บ่าฮ่าน แอ โจ. ล่าไมต้ามท้อ นี้ง แอ่ แน ฮ้าน แอ กาโน. อางจฺ่าอางต้าง, แพล่อง แน พลู้ อือนา บ่ากงา ฮ้าน แอ ค้า. ");
INSERT INTO bzi_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","แค้บตา แอ อางกงา ย้า. จ้า อางก่าอางตูม เพ่นแล่เซฺ่อ บ่ากงา ฮ้าน แอ ค้า. ");
INSERT INTO bzi_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ยู้มซื้ง ล้อมาง นองนา ค่าตอง ยู้ม โย้เวอ ช่าง อ้องแล ล่าแง. นอง มือ ยู้ม แฮ้ ยู้ม ก้องเวอ ดื้ง โว. นอง ค่อง แฮ้ ค่อง ก้อง เจิ่ก แอ เมอ ตื่อเคอ แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","จ้า บ้าเจอล้อเกิ้ง นองนา บ่าลาบบ่าต้อน ล่า, แน นองนา บ่าน่าจ่า ล่าแง, โย้เวอ เจิ่ก อ่อกแอน โว. แน นอง ล่าคื่อ เวอ ค้าล้า แฮ้ง ทาก วี แล่ โว! ไม้ นี้ย่า ยองนา ม่า แบ ปี่ง พาจาว ม้า นืงบาบ่าจาบ แน” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ยาว ศิษย์ อืม อ่อกแอ ค่องช่าง อือนา ม่าอู่บ แอ ชี, ไม้ ยองนา นืงบา อางซฺื่อ เพ่น อางบล่าบ ฮา แฮ้ง ว่าง ปี่ง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ยองมู นี้ย่า แด่ย่า ชฺ้าง ก้อง อ้อง ชี อือนา อางอีบ่าอ่า ก่า อ่อก ชี. แน ชฺ้าง อางด้า อือนา อางบย่า ย้า น้ำมันมะกอก ต่า ปี่ ชี. แน ยองนา พ่าญาด ยา ปี่ชี่ โปยว แอเคอ ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ก่าซ้าด เฮโรด มือ ชฺ้าง คาโคลาโค อือ พระเยซู อางเลิ่ง จี่ กาง แฮ้ง กงากย่า ชี. ชฺ้าง ทื่อบ่า อือย่า นี้แม้แน จี่, “ยา ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ฮู, ซฺี้ ยาว แต่ล้า แล่ชี่ แฮ้มาง ม้าม้า นาตู้. แฮ้งย้า อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา กงา กาแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ยาว ชฺ้าง ทื่อบ่า อือ นี้แม้แน จี่ กาง เย, “ยา พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ ซฺี้ ยาว แต่ล้า แล่ชี่ มาง ย้า” แน. ชฺ้าง ทื่อบ่า อือย่า นี้แม้แน จี่ คูง เย, “ยา ค้าแต้ โย้เวอ พาจาวจี่ต่างจี่แต่นฮู อือ แม้แน ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ก่าซ้าด เฮโรด อางเลิ่ง นี้อือ กงากย่า เมอ ยาง นี้แม้แน เย้ง ชี, “ยา ยอห์น กงา ตาฮ้าน อือนา ม่า อางตู่ ต่อน ปี่ ยาว แต่ล้า แล่ชี่ แฮ้มาง นาตู้” แน, ");
INSERT INTO bzi_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ไม้ ก่าซ้าด เฮโรด นี้ม้า ยาง ชฺ้าง อือนา ม่า ยอห์น นา ชู คอก ล้อง ปี่ชี่ มาง ย้า. ยาง นี้แม้แน ฮา ชี นี้ย่า, ไม้ ยา เฮโรเดียส นา นืงบาจาบ ปี่ซี่ แง. เฮโรเดียส ฟีลิป ค่าบา. ฟีลิป ก่าซ้าด เฮโรด อางแพ้. จ้า ก่าซ้าด เฮโรด ค่าตอง อางแพ้ มาง ค่าบา มางนา ยู้ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ยาว ยอห์น ก่าซ้าด เฮโรด นา อางเลิ้ง ย้า นี้แม้แน ม่าอู่บ แง, “อางแพ้ ค่าบา นา ยู้ ค่าตอง ค่าบา เพล่อ ปี่ง นี้ย่า อางซี เป” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","แฮ้งย้า เฮโรเดียส มือ นืงบาค่า ยอห์น นา แซ่ ซี่ แง. จ้า บ่าฮา กงา กา, ");
INSERT INTO bzi_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ไม้ ก่าซ้าด เฮโรด ยอห์น นา บ่าแซ่ จอ กา. ยา อางแบ เย่ ยอห์น ย่า ชฺ้าง อางเซฺิ่งอางซฺ้าง, พาจาว มาง นืงบาจาบวา แน ฮา เค่ แงแน. แฮ้งย้า ยาง ยอห์น นา ปล่อง แง. ก่าซ้าด เฮโรด ยอห์น ม่าอู่บจี่ต่าง แฮ้ง กงากย่า เมอ กูเทอ ย้า นืงบาต่องลาบ้าบ แง. จ้า บ้าเจอล้อแม้เวิม ก่าซ้าด เฮโรด มือ ยอห์น ม่าอู่บจี่ต่าง แฮ้งนา ซอ แง. ");
INSERT INTO bzi_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ยาว เฮโรเดียส มือ อางนืง อางญ่าม ซฺ้า ยอห์น นา แซ่ กงา ชี. แฮ้นืง เมอ ก่าซ้าด เฮโรด เกิ้ดนืง ปอ ชี. แฮ้งย้า ก่าซ้าด เฮโรด มือ ยาง ชฺ้าง อือนา ม่า ก่าซ้าดนาล่ากานปล่องว่าฮู ยศ อางฮื่อ อือนา ป้า ยาง ล่ากาน จฺ่าปอต้างปอ ฮา โย้เวอ ล้า ปี่ชี่. ตาฮ้าน ยอคา แน กาลิลี แควน โย้เวอ ชฺ้าง ปีนแตปีนนา อือ คาตา ย้า ก่าซ้าด เฮโรด ล่ากาน จฺ่าปอต้างปอ ฮา โย้เวอ แลน คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ยาว เฮโรเดียส อางย่าย่าบี่ ม่าง อ้อง ล้า ยองนา เยน ฮู ปี่ชี่. ก่าซ้าด เฮโรด แน ชฺ้าง ล่ากาน จฺ่าปอต้างปอ ฮา โย้เวอ ล้า ชี อืม นาบาตา ย้า ซอ แง. แฮ้งย้า ก่าซ้าด เฮโรด มือ เฮโรเดียส อางย่าย่าบี่ แฮ้มางนา นี้แม้แน ม่า ชี, “นา บ้าเจอ กงา ซีง, กงานา ป้า ล่าโว. ยาว กงาม นางนา ปี่ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ยาว ก่าซ้าด เฮโรด มือ นี้แม้แน ก่ามค่าน ปี่ ชี, “กงา นาง ป้า แฮ้งแม้แน กูย่างกูเจ้อ ย้า นางนา ปี่ ล่าง. กงา อางเมิง นี้ย่า นางนา ทื่อปล่าก ปี่ ล่าเวิม อางกงา เป” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ยาว เฮโรเดียส อางย่าย่าบี่ ม่าง อางเง้ เวอ อ่อกแอ ยาง อางบา มางนา นี้แม้แน น้า ชี, “อ่าบา เวอ, กงา บ้าเจอ ป้า ว้า?” แน. อางบา มาง นี้แม้แน พอ ชี, “ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ฮู มาง อางตู่ แฮ้ง ป้า โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ยาว เฮโรเดียส อางย่าย่าบี่ ม่าง อางไว่อางคย้าง ย้า ฮื่น อ้องแล ก่าซ้าด เฮโรด นา นี้แม้แน ม่า แล ชี, “กงา ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ฮู มาง อางตู่ ป้า แง. อามือ ย้า ฮ่างเพิ่น เวอ กาน ฮ้าน ล้าน โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ก่าซ้าด เฮโรด มือ นาบาตา ย้า ม่านชู ชี. จ้า ยา ค่าตอง จี่ ชี แฮ้งแม้แน กงาฮา แง, ไม้ ชฺ้าง อางอีบ่าอ่า เย ยาง ก่ามค่าน ฮา ชี แฮ้ง กงากย่า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","แฮ้งย้า ยาง ชฺ้างอางตู่ต่อนฮู มางนา ม่า ยอห์น อางตู่ แฮ้ง ต่อน ปี่ชี่. ยาว ชฺ้างอางตู่ต่อนฮู มาง คอก โย้เวอ แล ยอห์น อางตู่ แฮ้ง ต่อน แล ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","แน ยอห์น อางตู่ แฮ้ง ฮ่างเพิ่น เวอ กาน เฮโรเดียส อางย่าย่าบี่ มางนา ปี่ ชี. ยาว เฮโรเดียส อางย่าย่าบี่ แฮ้มาง ยาง อางบา มางนา ฮ้าน ปี่ แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ยอห์น ศิษย์ อือ แบ เมอ ยอง มือ ยอห์น นา ล่า ล้า ชี. แน ท้ามชฺ้างซฺี้ชีย้า โย้เวอ กอย ชี แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","พระเยซู ศิษย์เอก ซฺาแอ ปี่ชี่ อืม พระเยซู นา พ่าว ซฺ้า ล้า ชี. แน ยอง อางเลิ่ง คาโคลาโค ฮา ชี อือ แน ม่าอู่บ ชี อือ พระเยซู นา อู่บน้า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ยาว พระเยซู มือ ยองนา นี้แม้แน ม่า ชี, “เดว! กงู ตี อางกยาบ ฮาก บ่าจา โย้เวอ แล ซ่าวดื้ง แล ปายา” แน, ไม้ ชฺ้าง อางอีบ่าอ่า พระเยซู นา ซฺ้า ล้า ชี, ฮ่างจฺ่า ญ่าม บ่าจา แอ เคอ ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","แฮ้งย้า พระเยซู แน ศิษย์เอก อืม ยอง แอ่ แน ล้องตา ตี อางกยาบ โย้เวอ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","จ้า ชฺ้าง อางอีบ่าอ่า จา แง. ยอ ค่อง ต่างไล แปฟาง ก่องทาง อือเมอ ดื้ง แง. ยองมู นี้ย่า พระเยซู แน ศิษย์เอก อือ ล้องตา แล แฮ้งนา มย้าง เมอ, แบน ชี อ่าซ่าง แน. แฮ้งย้า ยอง แปฟาง ก่องทาง อือเมอ ฮื่น เค่ แลน ชี. แน ยอ ตี อางกยาบ โย้เวอ พระเยซู แน ศิษย์เอก อือ ล้าก้า เวอ ย้า ฮื่น เคิน แล ลาง ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","พระเยซู ล้อง เวอ อ่อก ล้า เมอ ยาง มย้าง ชี ชฺ้าง อางอีบ่าอ่า ยางนา ล่อ จา แงแน. พระเยซู มือ ยองนา ซื่งกง่ากย้า ชี, ไม้ ยองมู นี้ย่า แกะ ชฺ้างปอฮู บ่าจา อือ ช้อด ย้าเย่. แฮ้งย้า พระเยซู มือ ต่องก่าต่าง ยองนา ม่าอู่บ ชี. แน ยา ยองนา อางเลิ่ง ไล เลิ่ง ย้า ม่าอู่บ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","มู่งคี่ล้าก้า เคิน ยาว ศิษย์ อืม พระเยซู นา นี้แม้แน ม่า ล้า ชี, “อ่าจาน เวอ, นู้ ตี อางกยาบ เจิ้นเจ้อ บ่าจา. แน ชฺ้าง ยู้ม บ่าจา. แน อามือ มู่งคี่ล้าก้า ชา เคิน ญ้า. ");
INSERT INTO bzi_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ยองนา ม่า พ่าว แอ แล่ ปี่ ปาว. ยองนา นู้เวอ ค่อง อางแท้ อือเมอ ม้างม้าเจ้อ ซฺ้า วื้อ จฺ่า แอ ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","จ้า พระเยซู มือ นี้แม้แน พอ ชี, “นอง มือ ยองนา จฺ่าเกิ่ง ซฺ้า จฺ่า ปี่ ปาว” แน. ยาว ศิษย์เอก อืม นี้แม้แน พอ ชี, “ยองนา จฺ่าเกิ่ง วื้อ จฺ่า ปี่ง นี้ย่า พลู้ 200 เดนาริอัน บ่าเคอ ยาว บ่าปอ โกล้ม กา” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","แฮ้งย้า พระเยซู มือ ยองนา นี้แม้แน น้า ชี, “ฮู แอ ปาว, นองก้อง ค้านู้มป่าง อาล้อ ซื่อ จา แง?” แน. ศิษย์ อือ ฮู แอ ยาว พระเยซู นา นี้แม้แน ม่า ล้า ชี, “ค้านู้มป่าง 5 ซื่อ แน ล่องแต่ 2 โต จา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ยาว พระเยซู มือ ศิษย์ อือนา ม่า ค่องช่าง คาโคลาโค อือนา อางมู้ เปิ่ง อ่อก ปี่ชี่. แน ยองนา บู่ก่า เคว แน แต่ อ่อกล้า ชี อือเมอ อางมู้ แน ดื้ง ช้อน ลางกา ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","แฮ้งย้า ค่องช่าง อืม อางมู้ แน ดื้ง ช้อน ลางกา ชี. กามู 100 คู่น แนม อางจา. แน กามู 50 คู่น แนม อางจา. ");
INSERT INTO bzi_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ยาว พระเยซู มือ ค้านู้มป่าง 5 ซื่อ แน ล่องแต่ 2 โต แฮ้ง กอ ท่าม แล่ชี่. ยาว ยาง มู่งท่า โย้เวอ ฮูน ชี. แน พาจาว มางนา ขอบคุณ ฮา ชี. ยาว ยาง ค้านู้มป่าง แฮ้ง ชีด ศิษย์ อือนา แน ค่องช่าง อือนา เปิ่ง ปี่ชี่. แน ยาง มือ ล่องแต่ 2 โต แฮ้ง คาตา ย้า ชฺ้าง คาโคลาโค อือนา เปิ่ง ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ยาว ค่องช่าง อืม ก้อ ย้า จฺ่า คู ชี, ");
INSERT INTO bzi_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ยาว ศิษย์ อืม ชฺ้าง คาโคลาโค อือ ค้านู้มป่าง แน ล่องแต่ จฺ่าจาน ย้าง 12 ซ้าล้อง กอกงา ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ชฺ้าง ค้านู้มป่าง จฺ่า ชี อือ อางมู โย้เวอ ค่าพ่าย่า อือนา แอ่ แน นาบ ชี แฮ้ 5,000 คู่น นาบ กงา ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ค่องช่าง อือ ฮ่างจฺ่า กอ ยาว พระเยซู มือ ยาง ศิษย์ อือนา ล้องตา เบธไซดา อางเมิง โย้เวอ แล ลางออน ฮา ปี่ชี่. เบธไซดา อางเมิง นี้ย่า ลองอองอางฮื่อ ทื่อปล่าก ป่ากย่า ดื้ง แง. จ้า พระเยซู ค่องช่าง อือ ก้อง จาน ช่าชี่. แน ยา ค่องช่าง อือนา ซฺา ยู้ม เวอ พ่าว แอ แล่ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ค่องช่าง อือ ยู้ม เวอ พ่าว แอ โค เมอ, พระเยซู มือ ยาง ทื่อม่าง แน ตาแซ้ ท่า โย้เวอ อธิษฐาน ฮาน แล ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","มู่งคี่ เคิน ยาว ศิษย์ อืม ล้องตา ลองอองอางฮื่อ ก้องนื้ง โย้เวอ เคิน แอ คูชี. แฮ้ญ่ามเมอ พระเยซู แปฟาง ท่า โย้เวอ ยาง ทื่อม่าง แน ดื้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","พระเยซู มือ ศิษย์ อือ ล้องตา ลาบ้าบ ชี แน มย้าง ชี, ไม้ ฮ้างม้าน นาบาตา แล่ง ล้อง มางนา บ่าปี่ ปู้ย แอ แน. ซอทา อางด่า โย้เวอ พระเยซู มือ ล้าง ท่า โย้เวอ ย่อ ศิษย์ อือนา ซฺ้าน แอ ชี. แน ยา ยองนา ชา ย่อ ไก แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ศิษย์ อือ พระเยซู ล้าง ท่า ย่อ ชี แน มย้าง เมอ, ยอง แด่ย่า แน เย้ง คูชี. แฮ้งย้า โฮ้กฮ้าว แกล่กแย้ว คูชี, ");
INSERT INTO bzi_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ไม้ ยอ นาบาตา ย้า แค แล่ชี่. จ้า พระเยซู มือ ซฺ้อก ย้า ยองนา นี้แม้แน จี่ช่าง ชี, “บ่าแค คู โจ! กงา เยซู เป! แน นืงบาแก่น คู โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ยาว พระเยซู มือ ศิษย์ อือก้อง ทื่งกง่า แน ล้อง ท่า โย้เวอ ตา ดื้ง แล ชี. ยาว ฮ้างม้าน ตอ ย้าง ซฺ้อก ย้า ว่าง ชี. ศิษย์ อืม นาบาตา ย้า นืงบาม่าน คูชี, ");
INSERT INTO bzi_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ยองมู นี้ย่า พระเยซู ค่าพ่าย่า 5,000 คู่น อือนา ค้านู้มป่าง 5 ซื่อ ปอ ชี แฮ้ง กงามย้าง เวิม, จ้า ยอ บ่าแบ พระเยซู อ่าซ่าง ม้าม้า แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ยาว พระเยซู แน ศิษย์ อืม ล้องตา ลองอองอางฮื่อ แฮ้ง คาม แล เยนเนซาเรท อางเมิง โย้เวอ เคิน แล คูชี. ยาว ศิษย์ อืม ล้อง แฮ้ง พือ ชี คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","พระเยซู ล้อง โย้เวอ อ่อก ล้าน ยาว, ค่องช่าง อือ มย้าง เมอ ยอง ซฺ้อก ย้า แบน ชี ยา พระเยซู แน. ");
INSERT INTO bzi_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","แฮ้งย้า ยอง ฮากนา ม่า แบ โค ปี่ชี่. แน ชฺ้าง อางด้า อือนา อ่าเพ่น เวอ กาน ลาม ล้าน คูชี. แน พระเยซู นา พ่าญาด ยา ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","นี้แม้แนยาว พระเยซู บ้าเจอล้อเกิ้ง แอ แง, ค่อง ล่าอ้าว อางเมิง ล่าเวิม, ค่องช่าง อืม ชฺ้างอางด้า อือนา ก้าด โย้เวอ ซฺื่ย ชี ล้า คูแง. แน ค่องช่าง อืม พระเยซู นา ป้า คูแง, ชฺ้างอางด้า อือนา ยาง ค่าลาวม่านเงิน โย้เวอ ว่า ปี่ ปาว แน. แน ชฺ้างอางด้า คาโคลาโค พระเยซู ค่าลาวม่านเงิน แฮ้ง กงา ว่า คูชี อืม ด้ากย้าง คูชี แฮ้ง โปยว ชี. ");
INSERT INTO bzi_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ทื่อนืง จา แง, ฟาริสี มู อือ แน อางลี้บอางล่าว ม่าอู่บฮู ทื่อบ่า เยรูซาเล็ม อางเมิง โย้เวอ จายล้า คูชี อือ ซฺื่ยกา พระเยซู นา ซฺ้า ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ยองมู นี้ย่า พระเยซู ศิษย์ ทื่อบ่า อือ ล่าปู่ บ่าชี่ แน ฮ่างจฺ่า ดื้ง คูชี แน มย้าง ชี. ");
INSERT INTO bzi_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(ฟาริสี อือ แน ยิวชฺ้าง คาโคลาโค นี้ย่า ล่าปู่ บ่าชี่ แน ฮ่างบ่าจฺ่า คู, ไม้ ยองมู นี้ย่า ค้าแต้ เวอ อางลี้บอางล่าว ยองนา ม่า ฮา ปี่ชี่ แฮ้งแม้แน ฮา เค่ แง. ");
INSERT INTO bzi_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ก้าด เวอ จฺ่าเกิ่ง วื้อ จายล้า ชี อืม ทื่อช่างกานญา ฮา แง. ล่าปู่ บ่าชี่ แล่เปิน บ่าจฺ่า เย. อ่าจ่าม ยองมู นี้ย่า อางลี้บอางล่าว กาบ่ากาเจ้อ อือ อางอีบ่าอ่า ฮา ล้าน แล่ คูชี. อางลี้บอางล่าว แฮ้อือ นี้อือ ย้าเย่, ลอค่อ จอ อือ, อู่ล่อง จอ อือ, ฮ่างเพิ่น จอ อือ.) ");
INSERT INTO bzi_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","แฮ้งย้า ฟาริสี อือ แน อางลี้บอางล่าว ม่าอู่บฮู อืม พระเยซู นา นี้แม้แน น้าน คูชี, “บ้าเจอ นาง ศิษย์ อือ ค้าแต้ เวอ อางลี้บอางล่าว กงูนา ม่า ฮา ปี่ ล่าชี่ แฮ้งแม้แน บ่าฮา เค่ แน? บ้าเจอ ยอ ล่าปู่ บ่าชี่ แน ฮ่าง อางจฺ่า ดื้ง แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","แฮ้งย้า พระเยซู มือ นี้แม้แน พอ ชี, “พาจาวจี่ต่างจี่แต่นฮู อิสยาห์ มอ ยาว แต้ม ชี ชี แฮ้ย่า อางกง่าอางเกิง ย้า. ยา มอ ชี นองมู นี้ย่า ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือ ย้าแน. แน ยา นี้แม้แน พระคัมภีร์ เวอ แต้ม ชี ชี, ‘พาจาว ม้า นี้แม้แน จี่ แง, ชฺ้าง นี้อือย่า กงานา ม่านป่อง แฮ้งญา นาบทื้อ ล่า คูแง จ้า ยอง นืงบา แฮ้ย่า กงานา บ่านาบบ่าทื่อ ล่า. ");
INSERT INTO bzi_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","นี้แม้แนยาว ยอง กงานา สรรเสริญ ฮา ล่าง นี้ย่า เจิ้นเจ้อ จองไจ บ่าจา, ไม้ ยองมู นี้ย่า กงา อางลี้บอางล่าว แฮ้ง บ่าม่าบ่าอู่บ คู, จ้า ชฺ้าง อางลี้บอางล่าว แต่ง ชี อือ ม่าอู่บ คูแง’ แน. ");
INSERT INTO bzi_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“นองมู นี้ย่า พาจาว มาง อางลี้บอางล่าว แฮ้ง วี ยาว, ชฺ้าง อือ ม่าอู่บจี่ต่าง แฮ้ง ฮา เค่ คูชี” แน. ");
INSERT INTO bzi_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","พระเยซู มือ นี้แม้แน จี่ แลน แล่ชี่, “นองมู นี้ย่า แอ้นแคนแคน ลื้กล้าน คูแง. นอ พาจาว มาง อางลี้บอางล่าว แฮ้ง วี คูชี, ไม้ ชฺ้าง ม่าอู่บจี่ต่าง อือ ฮา เค่ คูง แนนอ, ");
INSERT INTO bzi_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ฮูปาว โมเสส นองนา นี้แม้ ม่า ล่าง, ‘ค่าตอง อางบา อางโบ้ง นา นาบทื้อ โว!’ แน ‘ชฺ้าง ค่าตอง อางบา อางโบ้ง นา แซ้งว้าน ชี อือนา แซ่ โว!’ แน. ");
INSERT INTO bzi_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","จ้า นองมู นี้ย่า นี้แม้แน ม่าอู่บ คูแง. ค่าตอง อางบา อางโบ้ง นา นี้แม้แน ม่า นี้ย่า บ่าไล่, ‘อ่าบา อ่าโบ้ง เวอ, กงา อางเกิ่งอางก้อ ไน้นา อางปล่อง ล่ากงา กาง อือย่า, พาจาว มางนา ท่าน โค ยา’ แน. ");
INSERT INTO bzi_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","นี้แม้แน ฮา นี้ย่า นอ ยองนา ม่าอู่บ อางบา อางโบ้ง นา เจิ้นเจ้อ บ่าปี่ ปล่อง แน ฮา ชี แน ทื่อช่างกานญา. ");
INSERT INTO bzi_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","นี้แม้แนยาว นอ พาจาว มาง อางลี้บอางล่าว แฮ้ง วี ยาว, ชฺ้าง อือ ม่าอู่บจี่ต่าง แฮ้ง ฮา เค่ คูชี. แน นอย่า นี้ป้าค้า ม่าอู่บ คูชี ไล เลิ่ง ย้า!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","พระเยซู ค่องช่าง อือนา ฮ้าว ล้า ปี่ ยาว นี้แม้แน ม่าอู่บ ชี, “แม่น แน น้า คูโว! แน แบ ชี คู ปาว. ");
INSERT INTO bzi_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ชฺ้าง อือ จฺ่าเกิ่ง จฺ่า อ้องแล ปี่ชี่ อือย่า เจิ้นเจ้อ บ่าจา ยอง นืงบา แฮ้งนา ฮา โซซา ปี่ชี่ แน. ยอง นืงบา โย้เวอ ม้างม้าเจ้อ จายล้า ชี อืน ญา, ยอง นืงบา แฮ้งนา ฮา โซซา ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","อ่าซ่าง น่าซื่ง จา แง แม่น แน น้า โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","น่อง โย้เวอ พระเยซู ค่องช่าง อือนา เจิ่ก ยู้ม คล้าว โย้เวอ อ้อง ล้าน ยาว, ศิษย์ อืม ยางนา ซฺ้า ล้า คูชี. แน ยาง อางเลิ่ง เพ้ก ม่าอู่บ ชี แฮ้ง น้าท้าม คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","พระเยซู มือ ยองนา นี้แม้แน ม่า ชี, “นองมู นี้ย่า บ่าแบ กาซื้ง ลา? ชฺ้าง อือ จฺ่าเกิ่ง จฺ่า อ้องแล ปี่ชี่ อือย่า เจิ้นเจ้อ มาง บ่าจา ยอง นืงบา แฮ้งนา ฮา โซซา ปี่ชี่ แน, ");
INSERT INTO bzi_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ไม้ จฺ่าเกิ่ง แฮ้อือ ยอง นืงบา คล้าว โย้เวอ บ่ากงา อ้อง แล. จ้า ป่องปอง คล้าว โย้เวอ กลา แอ แง. ยาว แอ่งอือ ค่ามตู่ เวอ กลา แอ ปี่ แง” แน. (พระเยซู นี้แม้แน จี่ นี้ย่า, ไม้ จฺ่าเกิ่ง กูย่างกูเจ้อ นี้ย่า อางจฺ่า กงากา แอ่น ญา เย.) ");
INSERT INTO bzi_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ยาว พระเยซู มือ นี้แม้แน จี่ แลน แล่ชี่, “ม้างม้าเจ้อ ชฺ้าง อือนา ฮา โซซา ปี่ง นี้ย่า ยอง นืงบา โย้เวอ จายล้า ชี อือ ย้าเป, ยาว นี้งย้า พาจาว มาง ชฺ้าง อือนา อางโซอางซา แน ฮู นี้ย่า. ");
INSERT INTO bzi_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ไม้ อางเลิ่ง บ่าแม่น นี้ย่า นืงบา โย้เวอ จายล้า แง น้อ. อางเลิ่ง บ่าแม่น นี้ย่า นี้อือ ย้าเป, ก่ามกืด บ่าแม่น อือ, ป้องก้า อางเลิ่ง อางซีอางบล่าบ ฮา อือ, ฮาก อางเกิ่ง ค่าว อือ, ฮากนา แซ่ อือ, ");
INSERT INTO bzi_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ฮาก อางบี่อางบล้อง นา จู้ เพล่อ อือ, ตานฮา จา อือ, ฮากนา จ้อบ อือ, ป้องก้า ตานฮา จา อือ, ฮากนา เจอค้อย อือ, ฮากนา ค่าว จี่ อือ, อ่อนจ่าแล่ง อือ, แน อางเลิ่ง อางจ่าง ฮา อือ. ");
INSERT INTO bzi_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","อางเลิ่ง บ่าแม่น คาโคลาโค นี้ อือย่า ชฺ้าง อือ นืงบา คล้าว โย้เวอ จายล้า แง. แน อางเลิ่ง บ่าแม่น นี้ อือย่า ชฺ้าง อือ นืงบา แฮ้งนา ฮา โซซา ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ยาว พระเยซู มือ โย้เวอ เจิ่ก ไทระ อางเมิง ก่องทาง โย้เวอ ค่อง อือเมอ แลน ชี. ยาว ยาง มือ ยู้ม ทื่อลาง มาง ก้อง อ้อง ดื้ง แล ชี. ยา อ่าซ่าง มางนา บ่าแบ ปี่ซี่ ยา ล้อเกิ้ง ดื้ง แงแน. จ้า ค่องช่าง อืม แบน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ค่าบาย่า ทื่อม่าง จา แง. ยาง อางย่าย่าบี่ มางนา แด่ย่า อ่อง ปี่ชี่. ยาง มือ พระเยซู ล้าน ชี แน แบน ยาว พระเยซู นา ซฺ้า ล้า ชี. แน พระเยซู ล่าคื่อ โย้เวอ บอกไว้ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ค่าบาย่า นี้ม้า ยิวชฺ้างบ่าอ่า. ยา ฟีนิเซีย แควน ประเทศ ซีเรีย โย้เวอ เกิ้ด ชี. ยา พระเยซู นา ป้า แง, แด่ย่า ยาง อางย่าย่าบี่ มางนา อ้อง ชี แฮ้มางนา ก่าอ่อก ปาว แน. ");
INSERT INTO bzi_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ยาว พระเยซู มือ ยางนา นี้แม้แน จี่ช่าง ชี, “กงา ยิวชฺ้าง จ้า นา ยิวชฺ้างบ่าอ่า. ยิวชฺ้าง นี้ ยิวชฺ้างบ่าอ่า อือนา คื่อ อางโซอางซา นา อางตู้ แน จี่ แง. ท้าว กงานา ยิวชฺ้างบ่าอ่า คื่อ แม้แน เพล่อ คูชี อือนา จฺ่าเกิ่ง ปี่, ปี่ ล่าง นี้ย่า อางซูม ลา? ยิวชฺ้าง ย่าเก อือนา ปี่ ออน ฮา แฮ้ง บ่าเช แล่ ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","จ้า ค่าบาย่า ม่าง นี้แม้ จี่พอ ชี, “อางอ้า ย้า, จ้า ย่าเก อือ ฮ่างจฺ่า เมอ จฺ่าเกิ่ง โต อ่อก เวอ กลา แอ ชี แฮ้ย่า คื่อ อือ บ่าจฺ่า กงา กาลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “นาง จี่ นี้ย่า นาบาตา แม่น! นาง ยู้ม เวอ พ่าว แลน แล่ปาว, ไม้ กงาย่า แด่ย่า นาง อางย่าย่าบี่ มางนา อ้อง ปี่ชี่ แฮ้มางนา ก่า อ่อก ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ค่าบาย่า แฮ้มาง ยาง ยู้ม เวอ พ่าว เคิน แล เมอ, มย้าง ชี ยาง อางย่าย่าบี่ ม้า ยู่ป่าม โย้เวอ ยู่น ชี, แน แด่ย่า ม่าง อ่อก ชีแน. ");
INSERT INTO bzi_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ยาว พระเยซู มือ ไทระ อางเมิง ก่องทาง โย้เวอ ค่อง อือเมอ เจิ่ก แอน ชี. แน ยา ไซดอน อางเมิง โย้เวอ ย่อไก ชี, ไม้ ลองอองอางฮื่อ กาลิลี โย้เวอ แล แง แนนอ. ยาว ยาง เดคาโปลิส แควน โย้เวอ เคิน แล ชี. ");
INSERT INTO bzi_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ยาว ค่องช่าง อืม ค่าพ่าย่า ทื่อม่าง นา ซฺื่ย พระเยซู นา ซฺ้า ล้า ชี. ค่าพ่าย่า นี้ม้า น่าซื่ง น่าป่าง แน อ่าล่อ แน บ่าจี่ท้อบ กา. ยาว ยองมู แฮ้ง พระเยซู นา ป้า ค่าพ่าย่า มาง ก้อง ล่าปู่ โบ้ย ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ยาว พระเยซู มือ ค่าพ่าย่า แฮ้มางนา ซฺื่ย ชฺ้าง อางมู โย้เวอ เจิ่ก แอน ชี. ยาว ยาง ล่าญู่ง แฮ้ง ค่าพ่าย่า แฮ้มาง น่าซื่ง อางฮ้อน 2 ฮ้อน โย้เวอ โค่ง อ้องแล ปี่ชี่. แน ยาง ล่าญู่ง โย้เวอ ค่านล่าง พี่ด กาน ยาว ค่าพ่าย่า แฮ้มาง ม่านล่า โย้เวอ แดด ชี. ");
INSERT INTO bzi_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ยาว พระเยซู มือ มู่งท่า โย้เวอ ฮูน ชี. ยาว ยาง อางซ่ากล่างบ้า ฮา ยาว ค่าพ่าย่า แฮ้มางนา นี้แม้แน จี่ช่าง ชี, “เอฟฟาธา! พอง อ่อก โว!” แน ฮา แง. ");
INSERT INTO bzi_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ยาว ค่าพ่าย่า แฮ้มาง ซฺ้อก ย้า กงากย่า ชี แน จี่ท้อบ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ยาว พระเยซู มือ ค่องช่าง อือนา ม่า ชี อางเลิ่ง นี้เลิ่ง นา อ่าซ่าง มางนา บ่าอู่บ น้า ปี่ โจ แน. จ้า พระเยซู ยองนา บ่าปี่ จี่ แน ล้อม้อก ม่า แง, ยองมู แฮ้ง ค้าแจ้ ย้า ฮากนา อู่บน้า ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ชฺ้าง กงากย่า คูชี อืม นาบาตา ย้า นืงบาม่าน คูชี. แน นี้แม้แน จี่ ลางกา ชี, “ยา บ้าเจอ ฮา เวิม อางแม่น ม้าม้า ย้า. ยา ชฺ้าง น่าซื่ง น่าป่าง อือนา ฮา กงากย่า ปี่ เวิม อางกงา. แน ชฺ้าง บ่าจี่ตอ กาง อือนา ฮา จี่ ปี่ เวิม อางกงา” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ทื่อเทอ จา แง. ค่องช่าง อางอีบ่าอ่า พระเยซู ก้อง ทื่งกง่า แน ดื้ง ชี. ยองมู นี้ย่า จฺ่าเกิ่ง จฺ่าเซฺ่อ บ่าจา. แฮ้งย้า พระเยซู มือ ศิษย์ อือนา ฮ้าว นี้แม้แน ม่า ชี, ");
INSERT INTO bzi_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“กงา ชฺ้าง นี้อือนา ซื่งกง่ากย้า เค, ยอย่า กงู ก้อง ดื้ง ล้า 3 นืง เคิน ญา. ");
INSERT INTO bzi_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ยองนา อางแบ่อางซฺู่ แน บ่าแอ ปี่ ซี่, อ่าซ่า แก้บ้า อือเมอ ปางปี ฮาน นา วาม ค่า, ไม้ ยองมู เวอ ชฺ้าง ทื่อบ่า อือย่า ยู้ม อางเว่อ.” ");
INSERT INTO bzi_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ยาว ยาง ศิษย์ อืมมือ จี่ ชี นี้แม้แน, “ซ่องก่องอางเว่อ นู้เวอ ชฺ้างอางบย่า นี้อือนา ล้อแม้แน จฺ่าเกิ่ง ซฺ้า ปอ กงา กาแน?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","แฮ้งเย่ พระเยซู มือ นี้แม้แน น้า ชี, “นองก้อง ค้านู้มป่าง อ้าล่อ ซื่อ จา แง?” แน. ยาว ยาง ศิษย์ อืมมือ พอ คู ชี 7 ซื่อ จา แงแน. ");
INSERT INTO bzi_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","แฮ้งย้าเย่ พระเยซู มือ ค่องช่าง อือนา ม่า นื้งชฺ่าท่า เวอ ดื้ง ปี่ชี่. ยาว ยาง มือ ค้านู้มป่าง 7 ซื่อ แฮ้ง ท่าม พาจาว มางนา ขอบคุณ ฮา ยาว, ค้านู้มป่าง แฮ้ง ชีด ชี. ยาว ศิษย์ อือนา ปี่ ค่องช่าง อือนา เปิ่ง ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ยอง ก้อง ล่องแต่ อางโต อางอี 2-3 โต จา ชี. พระเยซู มือ ล่องแต่ แฮ้ง ท่าม พาจาว มางนา ขอบคุณ ฮา ชี. ยาว ศิษย์ อือนา ม่า ค่องช่าง อือนา เปิ่ง ปี่ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ค่องช่าง อืม ก้อ ย้า กงาจฺ่า คูชี. แน ศิษย์ อืม จฺ่าเกิ่ง จ้านล้าชี แฮ้ง 7 ซ้าล้อง ปลื้ง ย้า กอ กงา ชี. ");
INSERT INTO bzi_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","นี้เทอ ชฺ้าง ดาบ กงา ชี แฮ้ย่า 4,000 คู่น ล่อซฺ่า. ฮ่างจฺ่า เปิน ยาว พระเยซู มือ ยองนา ม่า ยู้ม เวอ พ่าว แล แล่ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ยาว ซฺ้อกย้า พระเยซู แน ศิษย์ อืม ล้องตา ดาลมานูธา แควน เวอ แลน คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ฟาริสี อางมู เวอ ชฺ้าง ทื่อบ่า จา แง พระเยซู นา จี่เจ้ ล้า ชี. แน ยองมู นี้ย่า พระเยซู นา นี้แม้แน ตา จ่า คูแง, จาว่าแน ยาง พาจาว มาง ก้อง ม้าม้า แน จาย ลือ ชี แน ยาว, อางเลิ่งชฺ้างบ่าฮาตอกางอือ ยองนา ฮา ฮู ปี่ โว แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","พระเยซู แฮ้แม้แน กงากย่า เมอ ยาง อางซ่ากล่างบ้า แน จี่ ชี นี้แม้แน, “อามือ ชฺ้าง นี้ย่า บ้าเจอฮา กงานา ยองนา อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ฮู ปี่ ล่า ซีง นามบ่าแบ. กงา ม่า แบ ปี่ ล่าว่า กงาย่า เจิ้นเจ้อ อางเลิ่งชฺ้างบ่าฮาตอกางอือ บ่าฮา ฮู ปี่” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ยาว พระเยซู แน ศิษย์ อืม ล้อง เวอ พ่าว แอน แล่ชี่. แน ล้องตา ลองอองอางฮื่อ ทื่อปล่าก ป่ากย่า คาม แลน คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ศิษย์ อือ ค้านู้มป่าง บ่าฮ่าน ลือ แน ลู้ม ชี ช่า คูชี. แน ล้อง โย้ เวิม ค้านู้มป่าง ทื่อซื่อ ญา จา แง. ");
INSERT INTO bzi_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","พระเยซู มือ ยองนา นี้แม้แน ม่าอู่บ ชี, “ฟาริสี อือ แน ก่าซ้าด เฮโรด ชฺ้าง อือ อางเจ้อ แฮ้ง แม่น แน อางโต แล่ม แล่ คูโว” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","แฮ้งย้า ศิษย์ อืม นี้แม้แน จี่ ลางกา ชี, “อ่าจาน มาง นี้แม้แน จี่ นี้ย่า กงู ค้านู้มป่าง ลู้ม ชี ช่าชี่ แฮ้ง ปาปาย นาตู้” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","พระเยซู อางแบ ย้า ยองมู แฮ้ย่า บ้าเจอ จี่ ลางกา ชีแน. แฮ้งย้า ยาง นี้แม้แน จี่ ชี, “นอ บ้าเจอฮา ค้านู้มป่าง ลู้ม ชี ช่าชี่ อางเลิ่ง แฮ้ง จี่ กาแง? นองมู นี้ย่า บ่าแบ บ่ามย่าง กาซื้ง ลา? นอ นาบาตา อางลื้กอางล้าน คู. ");
INSERT INTO bzi_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","แมนือ จา เวิม บ่าฮู มย้าง กา. น่าซื่ง จา เวิม บ่ากย่า คู. นอ ลู้ม แอ ลา? ");
INSERT INTO bzi_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","กงา ชฺ้าง 5,000 คู่น อือนา ค้านู้มป่าง 5 ซื่อ ปอ เมอ, นอ ค้านู้มป่าง จ้านล้าชี แฮ้ง อาล้อ ซ้าล้อง กอ กงา แอ?” แน. ศิษย์ อืม นี้แม้แน พอ คูชี, “12 ซ้าล้อง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ยาว พระเยซู มือ นี้แม้แน น้า แล่ชี่, “กงา ชฺ้าง 4,000 คู่น อือนา ค้านู้มป่าง 7 ซื่อ ปอ เมอ, นอ ค้านู้มป่าง จ้านล้าชี แฮ้ง อาล้อ ซ้าล้อง กอ กงา แอ?” แน. ศิษย์ อืม นี้แม้แน พอ คูชี, “7 ซ้าล้อง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","แฮ้งย้า พระเยซู มือ นี้แม้แน จี่ ชี, “ซ้ามบา กงา นี้แม้แน ฮา ฮู ปี่ ล่าเวิม นอ บ่าแบ กาซื้ง ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","พระเยซู แน ศิษย์ อือ เบธไซดา อางเมิง โย้เวอ เคิน แล เมอ, ค่องช่าง ทื่อบ่า อืม ค่าพ่าย่า แมปอ ทื่อม่าง ซฺื่ย พระเยซู นา ซฺ้า ล้า คูชี. แน ยองมู แฮ้ง พระเยซู นา ป้า ยางนา ล่าปู่ โบ้ย พ่าญาด ยา ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","แฮ้งย้า พระเยซู มือ ค่าพ่าย่า แมปอ แฮ้มางนา ชื้ง ค่อง อางเง้ เวอ ซฺื่ย อ่อกแอน ชี. ยาว พระเยซู มือ ค่าพ่าย่า แมปอ แฮ้มาง แมนือ 2 ซื่อ โย้เวอ ค่านล่าง พี่ด กาน ชี. แน ยาง ล่าปู่ แฮ้ง ค่าพ่าย่า แมปอ แฮ้มาง แมนือ โย้เวอ แดด ชี. ยาว ยาง นี้แม้แน น้าน ชี, “ฮู มย้าง ย้า?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ยาว ค่าพ่าย่า แมปอ แฮ้ มาง แมก่า แงน ฮู กว่า ชี. แน นี้แม้แน พอ ชี, “พื้อ แน ฮู มย้าง แง. ชฺ้าง อือนา จฺืงจฺื้ง ย่อ กว่า ชี แม้แน ฮู มย้าง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","แฮ้งย้า พระเยซู มือ ยาง ล่าปู่ แฮ้ง ค่าพ่าย่า แฮ้มาง แมนือ โย้เวอ ทื่อเทอ แดด แล่ชี่. ยาว ค่าพ่าย่า แฮ้ มาง แมนือ พอง ฮูน ชี. ยาว ยาง แมนือ แฮ้ง กูย่างกูเจ้อ ย้า เจ้ง แน ฮู มย้าง ชี. ");
INSERT INTO bzi_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ยาว พระเยซู มือ ค่าพ่าย่า แฮ้มางนา นี้แม้แน ม่า ชี, “นาง ยู้ม โย้เวอ ซฺ้อก แน พ่าว แอน แล่โว. ล้อเกิ้ง บ่าแว บ่อ โจ.” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","พระเยซู แน ศิษย์ อือ ซีซารียาฟีลิปปี อางเมิง โย้เวอ ค่อง อางแท้ อือเมอ แลน คูชี. แก้บ้า ย่อ แล เมอ พระเยซู มือ ศิษย์ อือนา นี้แม้แน น้า ชี, “ฮาก กงานา อ่าซ่าง แน จี่ เคอ ล่าง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ศิษย์ อืม นี้แม้แน พอ คูชี, “ชฺ้าง ทื่อบ่า อือย่า นางนา จี่เคอ ล่าแง, นา ยอห์น ชฺ้าง อือนา ล้างตือพิธีบัพติศมา ฮา ปี่ แฮ้มาง แน. ชฺ้าง ทื่อบ่า อือย่า นางนา จี่เคอ ล่าแง, นา ค้าแต้ เวอ พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ แน ชี่ แฮ้มาง แน. ชฺ้าง ทื่อบ่า อือย่า นางนา จี่เคอ ล่าแง, นา ค้าแต้ เวอ พาจาวจี่ต่างจี่แต่นฮู อางมู โย้เวอ ชฺ้าง ทื่อม่าง มาง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ยาว พระเยซู มือ ยองนา นี้แม้แน น้า ชี, “ท้าว นอ กงานา อ่าซ่าง แน เย้ง ล่า คูแง?” แน. เปโตร มือ นี้แม้แน พอ ชี, “นาย่า พาจาว มาง แช้ยู้ ก่าซ้าด อางฮื่อ เพล่อ ปี่ชี่ แฮ้มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","แฮ้งย้า พระเยซู มือ ศิษย์ อือนา ปีนแตปีนนา แน ม่า ชี, ยา อ่าซ่าง แน ฮากนา บ่าม่า แบ ปี่ โจ แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ยาว พระเยซู มือ ศิษย์ อือนา นี้แม้แน ม่าอู่บ ชี, “กงาชฺ้างอางย่า เพล่อ ชี นี้ม้า ไลย่างไลเจ้อ ย้า กงาโอ้ด ตูกพานลาบ้าบ แง. ยิวชฺ้าง ยอคา อือ, ปุโรหิต ยอคา อือ แน อางลี้บอางล่าว ม่าอู่บฮู อือ กงา จี่ต่าง แฮ้งนา บ่าเจ่อ คู. แน กงานา ฮาก แซ่ ล่าแง. จ้า พาจาว ม้า กงา ซฺี้ ยาว ว่านที่ 3 แฮ้นืง เวอ แต่ล้า ปี่ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","พระเยซู ศิษย์ อือนา ยาง ซฺี้ อางเลิ่ง แฮ้ง เจ้ง ย้า อู่บ น้า โค ปี่ชี่. แฮ้งย้า เปโตร มือ พระเยซู นา ยางก้อง แท้ แน จาก แอ ปี่ชี่. ยาว พระเยซู นา จี่ ชี บ้าเจอฮา แฮ้แม้ จี่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","พระเยซู มือ ศิษย์ อือนา พลาบ ฮู ยาว, เปโตร นา นี้แม้แน อี่ ชี, “ซาตานแด่ย่ายอคา แม้แน บ่าจี่ โจ! ไม้ นา พาจาว มาง เย้ง แฮ้งแม้แน บ่ากงา เย้ง, จ้า ชฺ้าง เย้ง แฮ้งแม้แน เย้ง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ยาว พระเยซู มือ ศิษย์ อือนา แน ค่องช่าง อือนา ฮ้าว อ้อง ล้า ปี่ชี่. แน ยาง นี้แม้แน จี่ ชี, “อ่าซ่าง กงานา เค่ ล่าซี่ง แง, ค่าตอง นืงบาวา แน ฮา แฮ้ง ว่าง ยาว ค่าตอง ไม้กางเขน แฮ้ง ป่า แล่ยาว กงาก้อง เค่ ลาน โว! ");
INSERT INTO bzi_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ไม้ ชฺ้าง ค่าตอง จี่วีด แฮ้งนา กงานา ล่อบ่าปา แน ลาก อือ กงาซฺี้ แง. จ้า อ่าซ่าง กงานา เจ่อ ล่า ปาปาย, แน กงา อางเลิ่ง อางแม่น นี้ง ป่าว กว่า ปาปาย กงาซฺี้ แง, ชฺ้าง แฮ้ม้า จี่วีดม้าม้า กงาจา แล แง. ");
INSERT INTO bzi_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","จาว่าแน ชฺ้างอางเมิง นู้เวอ กูย่างกูเจ้อ จา ชี อือ อางซื้ง กงาเพล่อ ยาว, จี่วีดม้าม้า บ่าจา ยาว บ้าเจอ จองไจ จา แง? ");
INSERT INTO bzi_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ไม้ จี่วีดม้าม้า นี้ย่า เจิ้นเจ้อ บ่าไคล่ ยู้ กงา กา. ");
INSERT INTO bzi_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ชฺ้าง อือ พาจาว มางนา นืงบาบ่าชี่ อางนืง อางญ่าม นู้เวอ, แน อางบล่าบ อางนืง อางญ่าม นู้เวอ อ่าซ่าง กงา ชฺ้าง เพล่อ แฮ้งนา ซฺ่าจอ แง, แน กงา ม่าอู่บจี่ต่าง แฮ้ง ฮา เค่ แฮ้งนา ซฺ่าจอ แง, กงาชฺ้างอางย่า เพล่อ ชี นี้มาง ชฺ้างอางเมิง นู้เวอ พ่าว ลือ แล่ แฮ้นืง, กงาม ชฺ้าง แฮ้มางนา กงา ชฺ้าง เพล่อ ปี่ แฮ้งนา ซฺ่าจอ แง. แน แฮ้นืง กงาย่า เท่วาด่า อางเซฺิ่งอางซฺ้าง อือ ก้อง ทื่งกง่า แน ลือ แง. แฮ้นืง อ่าโบ้งพาจาว ล่าที่ อางฮื่อ แฮ้ง ฮา กงา อางโต โย้เวอ อางแปล้นอางซ้า อ่อก ล้า ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ยาว พระเยซู มือ ยองนา นี้แม้แน จี่ช่าง ชี, “กงา ม่า แบ ปี่ ล่าว่า, นู้เวอ ชฺ้าง ทื่อบ่า จูง อือย่า. พาจาว มาง ยาง ล่าที่ แฮ้ง ไจ ชฺ้างอางเมิง นู้เวอ, ก่าซ้าด อางฮื่อ เพล่อ ลือ ชี แฮ้ง บ่ากงา มย้าง ยาว บ่าซฺี่” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","6 นืง จายล้า แล่ยาว พระเยซู มือ เปโตร, ยากอบ แน ยอห์น ยองนา ตาแซ้ อางมอง โย้เวอ ซฺื่ยแลน ชี. ยาว พระเยซู มือ ยอง ล้าก้า โย้เวอ เพ่น ชี. ");
INSERT INTO bzi_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ยาง อางก่าอางตูม แฮ้ย่า ป่อนล่อนช่อน แน แปล้น บล่าบบล่าบ ย้า. ยาว ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือ อางก่าอางตูม อางป่อน อือ ล่อบ่าปา ป่อน แง. ");
INSERT INTO bzi_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ยาว ยองมู แฮ้ง พาจาวจี่ต่างจี่แต่นฮู โมเสส แน พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ เย่ด พระเยซู นา จี่ช่าง นา มย้าง ชี. ");
INSERT INTO bzi_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","แฮ้งย้า เปโตร มือ พระเยซู นา นี้แม้แน ม่า ชี, “อ่าจาน เวอ, กงู นู้เวอ ดื้ง ชี นี้ย่า นาบาตา แม่น เป, ไม้ กงูย่า ซ่าวย่า 3 ลาง ชอ คูแน. นางนา ทื่อลาง ดื้ง ปี่ ล่าแน. โมเสส นา ทื่อลาง ดื้ง ปี่ แน. เอลียาห์ นา ทื่อลาง ดื้ง ปี่ แน” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(เปโตร บ่าแบ เย ยา บ้าเจอล้อแม้ จี่ วา แน, ไม้ ยองมู นี้ย่า นาบาตา ย้า แคแล่ชี่.) ");
INSERT INTO bzi_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ยาว มู่งบื่น อางป่อน อืม ยองนา โปก โค ชี. แน มู่งบื่น อางป่อน โย้เวอ นี้แม้แน จี่ อ่อก ลือ ปี่ชี่, “นี้ม้า กงา อางย่า ลาก มาง. ยางนา น้าจ่า โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","แฮ้งย้า ยอง มือ ซฺ้า ฮู กว่า ชี. จ้า อ่าซ่าง มางนา บ่ามย่าง คู. พระเยซู นา มย้าง ชี แฮ้ง ญา. ");
INSERT INTO bzi_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ยาว ยองมู แฮ้ง ซฺื่ย กา ตาแซ้ โย้เวอ ย่อ ลู่ง แอ แล่ เมอ, พระเยซู มือ ยองนา นี้แม้แน ม่า ชี, “นอง อางเลิ่ง กงามย้าง ชี นี้ง กงาชฺ้างอางย่า เพล่อ ชี นี้มาง ซฺี้ ยาว แต่ล้า แล่ เมอ ฮากนา อู่บน้า ปี่ โว! จ้า อามือ อ่าซ่าง มางนา บ่าอู่บน้า ปี่ แคน โจ!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ยาว ยองมู แฮ้ง พระเยซู ม่า ชี แฮ้งแม้แน ฮา คูชี. จ้า ยองมู นี้ย่า ยองต่องยอง แน นี้แม้ น้าท้าม ลางกา ชี, “ซฺี้ ยาว แต่ล้า แล่ง แฮ้ บ้าเจอ?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ยาว พระเยซู ศิษย์ อืมมือ พระเยซู นา น้า คูง เย นี้แม้แน, “บ้าเจอ อางลี้บอางล่าว ม่าอู่บฮู อือย่า อางจี่ คู แน พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ ม้า พาจาว มาง แช้ ก่าซ้าด เพล่อ ปี่ ชี่ มาง ฮู่ เวอ ลือออน ฮา แงแน” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","พระเยซู มือ นี้แม้แน พอ ชี, “อางกง่า ย้า, เอลียาห์ ก่าซ้าด แฮ้มาง ฮู่ เวอ ลือออน ฮา แง, ไม้ ยา กูย่างกูเจ้อ กงาซฺ้า ชี ลางออน ฮา แง. จ้า นอ อางแบ คู ย้าล่า, บ้าเจอ พระคัมภีร์ เวอ นี้แม้แน อางแต้ม ชี แน, ‘กงาชฺ้างอางย่า เพล่อ ชี นี้ม้า นาบาตา ย้า กงาโอ้ด ตูกพานลาบ้าบ แง. แน ชฺ้าง อืม กงานา วี ล่าแง’ แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","กงา ม่า แบ ปี่ ล่าว่า, เอลียาห์ ลืน ญา. แน ชฺ้าง อืม ยอง นืงบาจาบวา ย้า เอลียาห์ นา ฮาช่าง ชี่, พระคัมภีร์ เวอ มอ ชี ชี แฮ้งแม้แน ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","พระเยซู, เปโตร, ยากอบ แน ยอห์น ยองมู แฮ้ง ศิษย์ ทื่อบ่า อือ จา โย้เวอ ย่อ เคิน แอ เมอ, ยองมู แฮ้ง มย้าง คูชี ค่องช่าง อางอีบ่าอ่า ศิษย์ แฮ้อือนา จูง แวด คูชี แน. แฮ้ญ่ามเมอ อางลี้บอางล่าว ม่าอู่บฮู ทื่อบ่า อือย่า ศิษย์ แฮ้อือนา อางเลิ่ง ซฺ้า จี่เจ้ คูแง. ");
INSERT INTO bzi_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ค่องช่าง อือ พระเยซู นา มย้าง ยาว นาบาตา ย้า นืงบาม่าน คูชี. ยาว ยอง พระเยซู นา ฮื่น ซฺ้า ล้า คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","พระเยซู มือ นี้แม้แน น้า ชี, “บ้าเจอ อางเลิ่ง จี่เจ้ กาแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ยาว ค่องช่าง อือ อางมู โย้เวอ ค่าพ่าย่า ทื่อม่าง มาง นี้แม้แน พอ ชี, “อ่าจาน เวอ, กงาย่า ค่าตอง อางย่าย่าค่า มางนา ซฺื่ย นางก้อง ล้า แอ. ยา บ่าจี่ ตอ กา, ไม้ แด่ย่า อ่อง ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","แด่ย่า นี้มาง ย่าเก มางนา อ้อง เมอ กูเทอ ย้า ย่าเก มางนา ฮา ยืกซ่าน นื้งชฺ่าท่า โย้เวอ เลิง แอ ปี่ แง. ย่าเก นี้มาง อางโต แก่นแล่งแท้ง, ซ่อเพ่ แช่ แก่น, ค่านล่าง เซฺ่อ ย้า. กงาย่า นาง ศิษย์ อือนา ป้า แด่ย่า ก่า อ่อก ปี่ แอ่. จ้า ยองมู นี้ย่า บ่าฮา กงากา” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “ชฺ้าง บ่าเจ่อ อือ เวอ, กงา นองก้อง อางมล่าง ล่า กงาดื้ง แล แล่แง? กงา นองนา อางมล่าง ล่า กงาโอ้ด แล แล่ ล่าแง? ย่าเก แฮ้มางนา กงาก้อง ซฺื่ย ลาน ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ยาว ยอง ย่าเก แฮ้มางนา ซฺื่ย ล้าน คูชี. แด่ย่า ย่าเก แฮ้มางนา อ้อง ชี มาง พระเยซู นา มย้าง เมอ, ย่าเก แฮ้มางนา ฮา ยืกซ่าน นื้งชฺ่าท่า โย้เวอ เลิง แอ ปี่ชี่. ยาว ย่าเก แฮ้มาง นื้งชฺ่าท่า โย้เวอ ค่านล่าง เซฺ้อ ย้า ยู่ ล่าน กว่า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","แฮ้งย้า พระเยซู มือ ย่าเก แฮ้มาง อางโบ้ง มางนา นี้แม้แน น้า ชี, “ยา นี้แม้ เพล่อ ล้า มล่าง คางลา?” แน. ยาว ย่าเก แฮ้มาง อางโบ้ง มาง นี้แม้แน พอ ชี, “ยาง ย่าเก อางอี แน ฮา เมอ จาย ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","แด่ย่า นี้ม้า ยางนา ไลเทอ เคิน ญา ชา แซ่ แง. กาเทอกา ยางนา ฮา บี่ท่อ กอง อางจฺ่อ โย้เวอ กลา แอ ปี่ แง. กาเทอกา ยางนา ฮา ล้าง โย้เวอ กลา แอ ปี่ แง. อ่าจาน เวอ, นาง อางปล่อง กงากา แน ยาว, กงูนา ซื่งกง่ากย้า แน ปล่อง ล่าปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","แฮ้งย้า พระเยซู มือ นี้แม้แน พอ ชี, “บ้าเจอ ‘นาง อางปล่อง กงากา แนยาว’ แน อางจี่ แน. ชฺ้าง อางเจ่อ อือย่า กูย่างกูเจ้อ ย้า ฮา กงากา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ยาว ย่าเก แฮ้มาง อางโบ้ง มาง ซฺ้อกย้า นี้แม้แน จี่ ชี, “กงา อางเจ่อ ย้า, จ้า กงา เจ่อ นี้ย่า บ่าบย่า กาซื้ง. กงานา ปล่อง อางอ้าน นี้ง ล่อบ่าปา แน ฮา เจ่อ ปี่ ล่าปาว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","พระเยซู มือ ค่องช่าง อือ อางอ้าน แฮ้ง ล่อบ่าปา จูง ฮูน ล้า ชีแน มย้าง เมอ, ยาง มือ แด่ย่า แฮ้มางนา นี้แม้แน ม่า ชี, “แด่ย่า เวอ, นา ชฺ้าง นา ฮา น่าซื่ง น่าป่าง เพล่อ ปี่ แง, แน บ่าจี่ ตอ กา แน ฮา ปี่ แง. กงา ม่า ล่าง นี้ง น้า โว, ย่าเก นี้มาง ก้อง อ่อก โว, แน ยางนา บ่าอ่อง แล่ โจ!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ยาว แด่ย่า แฮ้มาง โฮ้กฮ้าว แกล่กแย้ว ชี. แน ย่าเก แฮ้มางนา ฮา ยืกซ่าน เลิง แล่ ปี่ชี่. ยาว แด่ย่า แฮ้มาง ย่าเก แฮ้มาง ก้อง อ่อก ชี. ยาว ย่าเก แฮ้มาง กย้าบยี้น ย้า กลาน ชี. ค่องช่าง อืม นี้แม้แน จี่ ลางกา ชี, “ย่าเก นี้ม้า ซฺี้น ญ้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","จ้า พระเยซู มือ ย่าเก แฮ้มางนา ล่าปู่ ชู ค้อง ทา จูง ล้า ปี่ชี่. ยาว ย่าเก แฮ้มาง ทา จูง ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ยาว พระเยซู มือ ยู้ม คล้าว โย้เวอ อ้อง แลน ชี. พระเยซู แน ศิษย์ อือ ยอง แอ่ แน จา เมอ, ศิษย์ อืม ยางนา นี้แม้แน น้า ชี, “อ่าจาน เวอ, บ้าเจอ กงู แด่ย่า แฮ้มางนา บ่าก่า อ่อก กงากา แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","แฮ้งย้า พระเยซู มือ นี้แม้แน พอ ชี, “พาจาว มางนา อธิษฐาน ฮา นี้ง ญา แด่ย่า นี้อือเจ้อ นา ก่า อ่อก กงากา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ยาว พระเยซู แน ศิษย์ อืม แก้บ้า ย่อ แลน แล่ คูชี. แน กาลิลี แควน โย้เวอ ย่อ ไก คูชี. พระเยซู อ่าซ่าง มางนา บ่าแบ ปี่ซี่, ยา บ้าเจอล้อเกิ้ง ดื้ง แงแน, ");
INSERT INTO bzi_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ไม้ แฮ้ญ่ามเมอ ยา ศิษย์ อือนา ม่าอู่บ แง. ยา นี้แม้แน จี่ แง, “ชฺ้าง กงานา บ่าแม่น ฮาช่าง ล่าง ม้า, ยา กงาชฺ้างอางย่า เพล่อ ชี นี้ มางนา ชฺ้าง กงานา แซ่ ล่าง อือ ก้อง ซฺาแอ ปี่ ล่าง. แน กงา ซฺี้ ยาว วันที่ 3 แฮ้นืง แต่ล้า แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","จ้า ศิษย์ อือย่า พระเยซู ม่าอู่บจี่ต่าง แฮ้งนา บ่าน่ากลา กา. แน อ่าซ่าง มาง พระเยซู นา บ่าน่า จอ กา, ยา บ้าเจอ จี่ เคอ แงแน. ");
INSERT INTO bzi_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ยาว พระเยซู แน ศิษย์ อืม คาเปอรนาอุม อางเมิง โย้เวอ เคิน แล คูชี. แน ยู้ม คล้าว โย้เวอ อ้อง แลน ยาว, พระเยซู มือ ยาง ศิษย์ อือนา นี้แม้แน น้า ชี, “แก้บ้า ย่อ ล้า เมอ นอ บ้าเจอ อางเลิ่ง จี่เจ้ กาแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ยาว ยองมู คาโคลาโค แฮ้ง ซฺ่าจอ กยาบ คูชี, ไม้ แก้บ้า ย่อ ล้า เมอ ยอ จี่เจ้ กาแง, ยอง อางมู นู้เวอ อ่าซ่าง ชฺ้าง อางฮื่อ เลิ่นเลิ่น ม้า? แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","แฮ้งย้า พระเยซู มือ ดื้ง ลื่อยาว ศิษย์เอก 12 คู่น อือนา ฮ้าว ล้า ปี่ชี่. ยาว ยาง นี้แม้แน จี่ ชี, “อ่าซ่าง ชฺ้าง ปีนแตปีนนา อางฮื่อ เลิ่นเลิ่น เพล่อ ซี่ แง, ชฺ้าง แฮ้ม้า ชฺ้าง ปีนแตปีนนา อางอี เลิ่นเลิ่น กงาเพล่อ แง, แน ฮาก ย่าเจ่น กงาเพล่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ยาว พระเยซู มือ ย่าเก อางอี ทื่อม่าง มางนา ซฺื่ย ล้า ยอง ล้าก้า โย้เวอ จูง ปี่ชี่. ยาว ยาง ล่าลื่ง แฮ้ง ย่าเก แฮ้มาง ป่าฮู่ม โย้เวอ ค้อง ชี. ยาว ยาง นี้แม้แน ม่าอู่บ ชี, ");
INSERT INTO bzi_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“อ่าซ่าง กงานา ฮูจ่าล่าปาปาย ย่าเก อางอี นี้แม้แน ชี่ อือนา แม่นช่าง แง, ชฺ้าง แฮ้ม้า กงานา แม่นช่าง ล่าชี่ แน ทื่อช่างกานญา. แน ชฺ้าง กงานา แม่นช่าง ล่าชี่ แฮ้ม้า กงานา แอ่ แน บ่ากงา แม่นช่าง ล่า, จ้า ยา พาจาว กงานา ซฺาลือ ปี่ ล่าชี่ แฮ้มางนา คาตา ย้า แม่นช่าง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ยอห์น มือ พระเยซู นา นี้แม้แน อู่บน้า ปี่ชี่, “อ่าจาน เวอ, กงูมู นี้ย่า ค่าพ่าย่า ทื่อม่าง แด่ย่า ก่าอ่อก นา มย้าง คูแอ้. ยา นาง อางเม้ง แฮ้ง ไจ แด่ย่า ก่า แง. จ้า ยา กงู อางมู บ่าอ่า แฮ้งย้า กงูม ยางนา ม่า ว่าง ปี่ แอ่” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","จ้า พระเยซู มือ นี้แม้แน ม่าอู่บ ชี, “ยางนา บ่าม่า ว่าง ปี่ โจ, ไม้ ชฺ้าง กงา อางเม้ง แฮ้ง ไจ อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา อือย่า น่อง เวอ กงานา บ่าจี่ ก่างพยา ปี่ ล่า, ");
INSERT INTO bzi_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ไม้ ชฺ้าง กงูนา บ่าซีบ่าแล ช่าง ล่าง อือย่า กงู อางมู. ");
INSERT INTO bzi_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","กงา ม่า แบ ปี่ ล่าว่า อ่าซ่าง เวิม จาคาปี่ว, นอง กงา ชฺ้าง เพล่อ ชี แฮ้ง ปาปาย แน นองนา ล้างต้าง ปี่ ล่ายาว, ชฺ้าง แฮ้ม้า ก่ามป่อน ม้าม้า ย้า กงาบู้ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ยาว พระเยซู มือ นี้แม้แน จี่ แลน แล่ชี่, “อ่าซ่าง ย่าเก อางอี กงานา เจ่อ ล่าชี่ นี้อือนา จ้อบ อางบล่าบ ฮา ปี่ แง. ชฺ้าง แฮ้ม้า วี่บ่ากกงาไจ แง. แน ยาง วี่บ่ากกงาไจ นี้ย่า นาบาตา ย้า ตูกพานลาบ้าบ แง. นี้แม้แนยาว ลอบา อางฮื่อ แฮ้ง ยาง นื้งชฺือ โย้เวอ ล่าตื่อ พือ แป่น ยาว, ทะเล โย้เวอ ต่านคลา แฮ้งย้า เช แล่แง. ");
INSERT INTO bzi_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","จาว่าแน นอง ล่าปู่ ทื่อเบิง มาง นองนา ฮา อางบล่าบ ฮา ปี่ ล่ายาว, ล่าปู่ แฮ้เบิง ต่อน วี โว! ไม้ ล่าปู่ ทื่อเบิง มาง กู้ด ยาว, พาจาว มาง ก้อง มู่งท่า โย้เวอ ทื่งกง่า แน จี่วีด จา แล นี้ย่า, ล่าปู่ 2 เบิง จา ยาว, ล่าลูก บี่ท่อ ซฺู่ นืง บ่าจา โย้เวอ กลา แอ แฮ้ง ล่อบ่าปา เช แล่แง. ");
INSERT INTO bzi_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ล่าลูก โย้เวอ แลท่อง ซฺี้ นืง บ่าจา อือ แน บี่ท่อ ซฺู่ นืง บ่าจา อือ ปลื้ง ย้า จา แง. ");
INSERT INTO bzi_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","จาว่าแน นอง ล่าคื่อ ทื่อคื่อ มาง นองนา ฮา อางบล่าบ ฮา ปี่ ล่ายาว, ล่าคื่อ แฮ้คื้อ ต่อน วี โว! ไม้ ล่าคื่อ ทื่อคื่อ กู้ด ยาว, พาจาว มาง ก้อง มู่งท่า โย้เวอ ทื่งกง่า แน จี่วีด จา แล นี้ย่า ล่าคื่อ 2 คื่อ จา ยาว, ล่าลูก เวอ กลา แอ แฮ้ง ล่อบ่าปา เช แล่แง. ");
INSERT INTO bzi_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ล่าลูก โย้เวอ แลท่อง ซฺี้ นืง บ่าจา อือ แน บี่ท่อ ซฺู่ นืง บ่าจา อือ ปลื้ง ย้า จา แง. ");
INSERT INTO bzi_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","จาว่าแน นอง แมนือ ทื่อซื่อ มาง นองนา ฮา อางบล่าบ ฮา ปี่ ล่ายาว, แมนือ แฮ้ซื่อ โค่ง วี โว! ไม้ แมนือ ทื่อซื่อ จ้าน ล้า ยาว มู่งท่า พาจาวอางเมิง โย้เวอ กงาอ้อง ดื้ง แล นี้ย่า, แมนือ 2 ซื่อ จา ยาว ล่าลูก เวอ กลา แอ แฮ้ง ล่อบ่าปา เช แล่แง. ");
INSERT INTO bzi_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ล่าลูก โย้เวอ แลท่อง ซฺี้ นืง บ่าจา อือ แน บี่ท่อ ซฺู่ นืง บ่าจา อือ ปลื้ง ย้า จา แง.” ");
INSERT INTO bzi_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ไม้ กงา ชฺ้าง คาโคลาโค อือย่า อางตูกอางพาน กงาโอ้ด คูแง. ยองมู นี้ย่า ลาบ้าบ แง, ยองนา บี่ท่อ จฺ่อ ชี ช้อดย้า, ไม้ ยอง เจ่อ แฮ้งนา แก่นคา ปี่ง แนนอ.” ");
INSERT INTO bzi_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“จ่าแม่ นี้ย่า อางแม่น. จ้า จาว่าแน จ่าแม่ แฮ้ง อางอ้าม โคน ยาว, นอ บ้าเจอล้อแม้ ฮา อางอ้าน แฮ้งแม้แน อ้าม แล่ ปี่ กงา กาแง? นองมู คาโคลาโค นี้ย่า อางเลิ่ง อางแม่น ฮา แลน แล่ คูปาว, จ่าแม่ อือ อางอ้าม กอ ชี ชี แฮ้งแม้แน, ไม้ นองนา ฮา จาบื่อดื้งบื้อ แน ทื่งกง่า แน ดื้ง ช้อน กา ปี่ล่า คาไล” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ยาว พระเยซู มือ แก้บ้า ย่อ กาลิลี แควน โย้เวอ จาย ยูเดีย แควน โย้เวอ อ้อง แลน ชี. แน จอร์แดน ล้างบ้า ทื่อปล่าก ป่ากย่า คาม แลน ชี. ค่องช่าง อางอีบ่าอ่า พระเยซู นา ซฺ้า ล้า ชี. พระเยซู มือ ค่องช่าง อือนา ม่าอู่บ ชี กูเทอ แม้แน ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ฟาริสี อางมู เวอ ชฺ้าง ทื่อบ่า จา แง. พระเยซู นา อางเลิ่งซฺ่า คูชี. ยองมู นี้ย่า พระเยซู นา นี้แม้แน น้าน ชี, “ค่าพ่าย่า ค่าบา นา ว่าง นี้ย่า โมเสส อางลี้บอางล่าว เวอ อางซี ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","พระเยซู มือ นี้แม้แน น้า ชี, “โมเสส นี้เลิ่ง นา บ้าเจอล้อแม้ ม่า ฮา ปี่ ชี?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ยอง มือ นี้แม้แน พอ ชี, “โมเสส ค่าพ่าย่า อือนา ว่างกาอางพ่า แฮ้ง ค่าบา อือนา แต้ม ปี่ ปี่ง. ยาว ว่าง กงา คางญ้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","แฮ้งย้า พระเยซู มือ ยองนา นี้แม้แน ม่า ชี, “โมเสส นองนา นี้แม้แน อางลี้บอางล่าว แต้ม ปี่ ล่าชี่ นี้ย่า, ไม้ นอ อางล้าน น้อ. ");
INSERT INTO bzi_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","จ้า ม้าม้า นี้ย่า พาจาว มาง ต่องก่าต่าง ชฺ้างอางเมิง แต่ง เมอ ‘พาจาว ม้าย่า ชฺ้าง แต่ง ชี. ค่าพ่าย่า ทื่อม่าง แน ค่าบาย่า ทื่อม่าง แน.’ พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี แฮ้งแม้แน ย้า, ");
INSERT INTO bzi_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘นี้งย้า ค่าพ่าย่า นี้ย่า อางบา อางโบ้ง นา เจิ่ก ค่าบา ก้อง ดื้ง แอ แง. ");
INSERT INTO bzi_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","แน เย่ด ชฺ้าง ทื่อม่าง กา แน เพลิ่น ชี แน ทื่อช่างกานญา’ แน. นี้แม้แนยาว เย่ด ชฺ้าง 2 คู่น บ่าอ่า กาน, จ้า ชฺ้าง ทื่อม่าง กาน ญา. ");
INSERT INTO bzi_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","นี้แม้แนยาว พาจาว มาง ทื่อลู่มทื่อเจ่อ แน ฮา เพล่อ ปี่ ยาว, อ่าซ่าง มางนา บ่าปี่ ฮา เจิ่ก อ่อก ปี่ โจ” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","พระเยซู แน ศิษย์ อือ ยอง แอ่ แน ยู้ม คล้าว ดื้ง เมอ, ศิษย์ อืม พระเยซู นา นี้เลิ่ง น้า คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","พระเยซู มือ นี้แม้แน พอ ชี, “ค่าพ่าย่า ล้อมาง ค่าบา นา ว่าง ยาว ค่าบา อางซฺื่อ ยู้ แล่ง, ค่าพ่าย่า แฮ้ม้า อางบล่าบ ฮา แง, ไม้ ยาง นี้แม้ ฮา ชี นี้ย่า จู้ จาน ชี แน ทื่อช่างกานญา. ");
INSERT INTO bzi_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","แน ค่าบาย่า ล้อมาง อางบล้อง นา ว่าง ยาว อางบล้อง อางซฺื่อ ยู้ แล่ง, ค่าบาย่า แฮ้ม้า อางบล่าบ ฮา แง, ไม้ ยาง นี้แม้ ฮา นี้ย่า จู้ จาน ชี แน ทื่อช่างกานญา” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ชฺ้าง ทื่อบ่า จา แง. ย่าเก อางอี อือนา ซฺื่ย พระเยซู นา ซฺ้า ล้า ชี, ไม้ ยางนา ล่าปู่โบ่ย ก่ามป่อน ปี่ ปี่ง แนนอ. จ้า ศิษย์ อือย่า ยองนา แฮ้แม้แน บ่าปี่ ฮา แน อี่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","พระเยซู แฮ้แม้แน มย้าง เมอ นืงบาค่า ชี. แฮ้งย้า ศิษย์ อือนา นี้แม้แน จี่ช่าง ชี, “ย่าเก อือนา กงาก้อง ตอย อ้องล้า ปี่ว. ยองนา เจิ้นเจ้อ บ่าจี่ โจ, ไม้ ชฺ้าง พาจาวอางเมิง เวอ กงาอ้อง แล คูง อือย่า ย่าเก นี้อือ แม้แน กงาเจ่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","กงา ม่า แบ ปี่ ล่าว่า, อ่าซ่าง พาจาว มางนา ย่าเก นี้อือ นืงบาชี แฮ้งแม้แน นืงบาบ่าชี่ แง, พาจาวอางเมิง เวอ บ่ากงาอ้อง แล” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ยาว พระเยซู มือ ย่าเก แฮ้อือนา ค่อด ชี. แน ยองมู คาโคลาโค แฮ้งนา ล่าปู่โบ่ย ก่ามป่อน ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","พระเยซู แก้บ้า ย่อ จา เมอ, ย่าค่า ทื่อม่าง จา แง. พระเยซู ล้าก้า โย้เวอ ฮื่น ล้า บอกไว้ ล้า ชี. ยาว นี้แม้แน น้าน ชี, “อ่าจาน อางแม่น เวอ, พาจาว มาง ก้อง ทื่งกง่า แน จี่วีดม้าม้า จา แล นี้ย่า กงา บ้าเจอ กงาฮา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","พระเยซู มือ นี้แม้แน พอ ชี, “นา บ้าเจอฮาย กงานา ชฺ้าง อางแม่น แน ฮ้าว ล่าง? อ่าซ่าง มาง บ่าแม่น เป. พาจาว มาง ทื่อม่าง ญา อางแม่น แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","นาง มือ อางลี้บอางล่าว แฮ้ง อางแบ ย้า. อางลี้บอางล่าว เวอ นี้แม้แน แต้ม ชี ชี, ‘ชฺ้าง นา บ่าแซ่ โจ, ฮาก อางบี่อางบล้อง นา จู้ บ่าเพล่อ โจ, อางเกิ่ง บ่าค่าว โจ, ชฺ้าง แล่จ่อบ บ่าเพล่อ โจ, อางเลิ่ง บ่ากง่าบ่าเกิง บ่าฮา โจ, แน ค่าตอง อางบา อางโบ้ง นา นาบทื้อ โว!’” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ย่าค่า แฮ้มาง นี้แม้แน พอ ชี, “อ่าจาน เวอ, กงาย่า ย่าเก แน ฮา เมอ จาย ย้า อางลี้บอางล่าว คาโคลาโค นี้อือ ฮาย ล้าน แอ” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","พระเยซู มือ ย่าค่า แฮ้มางนา ลาก ปาปาย ฮูน ชี. แน ยางนา นี้แม้แน ม่า ชี, “จ้า นา ทื่อย่าง กงาฮา แล่ง. นาง อางเกิ่ง คาโคลาโค จา ชี แฮ้ง ก่อง ยาว, พลู้ แฮ้ง ชฺ้าง อางตูกอางพาน อือนา ปี่ แอ โว! ยาว นา มู่งท่า โย้เวอ อางเกิ่งอางก้อ บย่า แน จา แง. แน นา กงาก้อง เค่ ล้าน ยาว กงา ศิษย์ เพลิ่น ปาว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ย่าค่า แฮ้มาง พระเยซู แฮ้แม้แน จี่ แฮ้ง กงากย่า ยาว, นืงบาต่องบ่าม่อนบ่าซ่า เย. แฮ้งย้า ยาง มือ แมก่า บอก ย่อ เจิ่ก แอน ชี, ไม้ ยา ชฺ้าง นาบาตา อางจาอางปาง นอ. ");
INSERT INTO bzi_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","พระเยซู มือ ยาง ก่องทาง อือเมอ ฮู กว่า ชี. แน ยาง ศิษย์ อือนา นี้แม้แน จี่ช่าง ชี, “ชฺ้าง อางจาอางปาง อือนา พาจาว อางเมิง เวอ อ้องแล ปี่ นี้ย่า นาบาตา ย่าก” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ศิษย์ อืม พระเยซู จี่ต่าง แฮ้ง กงากย่า ยาว บลื่ง คูชี. จ้า พระเยซู มือ นี้แม้แน จี่ แลน แล่ชี่, “อางย่า เวอ, อางแบ ล่า พาจาวอางเมิง เวอ อ้องแล นี้ย่า อางย่าก ม้าม้า แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","อูฐ อือนา ก่องกย่าว อางฮ้อน เวอ อ้องแล ปี่ง นี้ย่า, ชฺ้าง อางจาอางปาง อือนา พาจาวอางเมิง เวอ อ้องแล ปี่ง แฮ้ง ล่อบ่าปา ไง่ แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ศิษย์ อืม นาบาตา ย้า นืงบาม่าน คูชี. แน ยองมู แฮ้ง นี้แม้แน น้าท้าม ลางกา ชี, “ซ้ามบา ชฺ้างอางจาอางปาง อืม พาจาวอางเมิง เวอ อ้องแล อางย่าก. ท้าว นี้แม้แนยาว พาจาวอางเมิง เวอ อ่าซ่าง อ้องแล กงากา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","พระเยซู มือ ยองนา ฮู ยาว นี้แม้แน พอ ชี, “ชฺ้าง นี้ย่า มู่งท่า เวอ ยอง ทื่อม่าง แน บ่าอ่อง แล กงา กา, จ้า พาจาว มาง ปล่อง ยาว อางกงา ย้า, ไม้ พาจาว ม้าย่า กูย่างกูเจ้อ ย้า ฮา กงากา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ยาว เปโตร มือ พระเยซู นา นี้แม้แน ม่าย ชี, “อ่าจาน เวอ ฮูปาว, กงูย่า กูย่างกูเจ้อ อือ วี ย่า, ยาว นางก้อง เค่ คูง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","แฮ้งย้า พระเยซู มือ นี้แม้แน พอ ชี, “กงา ม่ายแบ ปี่ ล่าว่า, อ่าซ่าง ค่าตอง ยู้ม, ม้องน้าม, อางบา อางโบ้ง, อางย่า แน น่า ย้า อือนา วี ยาว, กงานา เค่ ล่าง, แน กงา อางเลิ่ง อางแม่น แฮ้ง ป่าว กว่า แง, ");
INSERT INTO bzi_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ชฺ้าง แฮ้ม้า กาญ่าม เวอ อางเกิ่งอางก้อ บย่า แน จา แง, ไม้ อามือ อางเกิ่ง วี ชี แฮ้ย่า กาญ่าม เวอ 100 โตบ กงายคื่น แล่ง. ตื่น ยู้ม, ม้องน้าม, อางบา อางโบ้ง, อางย่า แน น่า ย้า อือ คาตา ย้า. แน ยองนา ฮาก ฮูย้า คาม แง. จ้า กาญ่าม เวอ ยองมู นี้ย่า พาจาว มาง ก้อง ทื่งกง่า แน จี่วีดม้าม้า จา แล แง. ");
INSERT INTO bzi_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ยาว อามือ ชฺ้าง ปีนแตปีนนา อือย่า, น่อง เวอ ชฺ้าง ปีนแตปีนนา บ่าอ่า อือ เพล่อ แง. แน อามือ ชฺ้าง ปีนแตปีนนา บ่าอ่า อือย่า, น่อง เวอ ชฺ้าง ปีนแตปีนนา เพล่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","แฮ้ญ่ามเมอ พระเยซู แน ยาง ศิษย์ อืม เยรูซาเล็ม อางเมิง โย้เวอ ย่อ แลน คูชี. พระเยซู ฮาก ล้าก้า ย่อ ชี. ศิษย์ อืม พระเยซู เยรูซาเล็ม อางเมิง เวอ แล แฮ้งนา นืงบาม่าน คูง เย. แน ค่องช่าง เค่ ล้า คูชี อืม แค คูชี. พระเยซู มือ ยาง ศิษย์ 12 คู่น อือนา แอ่ แน ซฺื่ย แก้บ้า ก่องทาง โย้เวอ แอน ชี. แน ยาง ซฺี้ อางเลิ่ง แฮ้ง ยองนา ทื่อเทอ อู่บน้า แล่ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ยาว ยองนา นี้แม้แน จี่ช่าง ชี, “แม่น แน น้า โว! อามือ กงูมู นี้ย่า เยรูซาเล็ม อางเมิง เวอ ชา แล คูแง. แน ชฺ้าง กงานา บ่าแม่น ฮา ล่าง ม้า, กงานา ชฺ้างอางย่า เพล่อ ชี นี้มางนา, ปุโรหิต ยอคา อือ ก้อง แน อางลี้บอางล่าว ม่าอู่บฮู อือ ก้อง ซฺาแอ ปี่ ล่าง. ยองมู แฮ้ย่า กงานา ต้าดต่อน ซฺี้ ปี่ ล่าง. แน กงานา โรมชฺ้าง อือ ก้อง ซฺาแอ ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","โรมชฺ้าง แฮ้อือ กงานา ฮูย้า ล่าง, ค่านล่าง พี่ด กาน ล่าง, กงานา ซฺ้าม ชืก ล่าง, แน กงานา แซ่ ล่าง, จ้า กงา ซฺี้ ยาว ว่านที่ 3 มาง ก้อง แต่ล้า แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ยาว ยากอบ แน ยอห์น เศเบดี อางย่าย่าค่า มาง เย่ด พระเยซู นา ซฺ้า ล้า ชี. แน พระเยซู นา นี้แม้แน จี่ช่าง ชี, “อ่าจาน เวอ, ไกง้นา ทื่อเลิ่ง อางปล่อง ล่า กงากา ย้าลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","พระเยซู มือ นี้แม้แน น้า ชี, “ไน้ กงานา บ้าเจอฮา ปี่ ล่าง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","เย่ด มือ นี้แม้แน พอ ชี, “อ่าจาน เวอ, นาง ก่าซ้าด กงาเพล่อ ยาว, ไกง้นา นาง ล่าซ่าย ป่ากย่า ทื่อม่าง แน ล่าม่า ป่ากย่า ทื่อม่าง แน ดื้ง ปี่ ล่าปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","พระเยซู มือ นี้แม้แน น้า ชี, “ไน้ อางแบ ล่า บ้าเจอ ป้า แงแน? ไน้ กงา ล้างก้อก อางตูกอางพาน กงาต้าง นี้ง อางต้าง กงากา ย้าลา? กงา อางตูกอางพาน กงาโอ้ด ลาบ้าบ แฮ้ย่า ไน้ อางโอ้ด ลาบ้าบ กงากา ย้าลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","เย่ด มือ นี้แม้แน พอ ชี, “อางกงา ย้า” แน. แฮ้งย้า พระเยซู มือ เย่ดนา นี้แม้แน ม่า ชี, “ไน้ กงา ล้างก้อก กงาต้าง นี้ง ม้าม้า ย้า กงาต้าง แง. แน ไน้ กงา อางตูกอางพาน กงาโอ้ด ลาบ้าบ ชี แฮ้งแม้แน ย้า กงาโอ้ด ลาบ้าบ แง. ");
INSERT INTO bzi_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","จ้า ชฺ้าง แช้ยู้ กงา ล่าม่า ป่ากย่า แน ล่าซ่าย ป่ากย่า ดื้ง ปี่ง นี้ย่า กงา แช้ยู้ บ่าอ่า, จ้า พาจาว มาง แช้ยู้ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ศิษย์ ทื่อแช่ คู่น อือ นี้เลิ่ง แบน เมอ, ยอง มือ ยากอบ แน ยอห์น เย่ดนา นืงบาค่า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","แฮ้งย้าเย่ พระเยซู มือ ยอง คาโคลาโค นา ฮ้าวล้า ปี่ ยาว ม่า ชี นี้แม้แน, “นอ อางแบ ย้า ชฺ้างอางเมิง นู้เวอ ก่าซ้าด อือย่า ค่าตอง ชฺ้าง ฮูพลา ชี อือ ล่อบ่าปา ฮื่อ แล่ง แน. ยาว ชฺ้าง ยอคา เพล่อ คูชี อืม ค่าตอง ชฺ้าง ฮูพลา ชี อือนา ล่าที่ ไจ ช่าง แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","จ้า นอง อางมู นู้เวอ แฮ้แม้แน บ่าอ่า, อ่าซ่าง อางฮื่อ เพล่อ ซี่ แง. ยา นองนา ล่ากาน กงาว่า ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","แน อ่าซ่าง ชฺ้าง ปีนแตปีนนา อางฮื่อ เลิ่นเลิ่น เพล่อ ซี่ แง. ยา นองมู คาโคลาโค อือ ย่าเจ่น กงาเพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ไม้ กงาชฺ้างอางย่า เพล่อ ชี นี้มาง ลือ ชี นี้ย่า ฮากนา กงา ย่าเจ่น เพล่อ ปี่ง บ่าอ่า, จ้า กงาย่า ฮาก ย่าเจ่น เพล่อ ลือ แอ. แน ค่าตอง จี่วีด วี ลือ แง, ไม้ ชฺ้าง อางบย่า อือนา ปล่อง ย่าเจ่น กงาปูน ปี่ง แนนอ” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ยาว พระเยซู แน ศิษย์ อืม เยรีโค อางเมิง โย้เวอ ย่อ เคิน แล คูชี. พระเยซู แน ศิษย์ อือ ค่องช่าง อือ ก้อง ทื่งกง่า แน เยรีโค อางเมิง อางเง้ เวอ แก้บ้า ย่อ อ่อกแอ เมอ, ชฺ้างแมปอ ทื่อม่าง จา แง. ยาง อางเม้ง บารทิเมอัส แน, ยา ทิเมอัส อางย่าย่าค่า. ยา แก้บ้า ก่องทาง โย้เวอ พลู้ ป้า ดื้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ยาว ยาง กงากย่า ชี พระเยซู นาซาเร็ธชฺ้าง มาง ล้าน ชี แน. แฮ้งย้า นี้แม้แน จี่ โฮ้กฮ้าว ชี, “พระเยซู ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บล้า ชี มาง เวอ, กงานา ซื่งกง่ากย้า ล่าปาว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ค่องช่าง อางอีบ่าอ่า ยางนา จี่จ้าด ม่า กยาบ ปี่ชี่. จ้า ยาง อางอ้าน แฮ้ง ล่อบ่าปา อางเซง บื้ง แน จี่ โฮ้ก ชี. แน ยา นี้แม้แน จี่ ชี, “พระเยซู ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บล้า ชี มาง เวอ, กงานา ซื่งกง่ากย้า ล่าปาว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","แฮ้งย้า พระเยซู มือ ย่อ ย้าง ว่าง ชี. แน นี้แม้ จี่ ชี, “ชฺ้าง แฮ้มางนา ฮ้าว ล้า ปี่ว” แน. ยาว ยองมู แฮ้ง ชฺ้างแมปอ แฮ้มางนา ฮ้าว ล้า ปี่ชี่. แน ยางนา นี้แม้แน จี่ช่าง ชี, “กย่าง กงา คางญ้า ทานล้า ปาว, อ่าจาน ม้า นางนา ฮ้าว ซฺ้า ล้า ปี่ ล่าง ญ้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","แฮ้งย้า ชฺ้างแมปอ แฮ้มาง ยาง ค่าลาวอางเง้โลบแล่เซฺ่อ แฮ้ง แลอ่อก แล่ยาว วี ชี. แน เปิก จูง ล้า ชี. แน พระเยซู นา ซฺ้าน แล ชี. ");
INSERT INTO bzi_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","พระเยซู มือ ยางนา นี้แม้แน น้า ชี, “กงานา บ้าเจอ ปล่อง ปี่ ล่า ซี่ แง?” แน. ชฺ้างแมปอ แฮ้มาง นี้แม้แน พอ ชี, “อ่าจาน เวอ, กงาย่า ฮู มย้าง ซีค้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","แฮ้งย้า พระเยซู มือ นี้แม้แน ม่า ชี, “แอ ปาว, นาง กงานา เจ่อ ล่าชี่ นี้ย่า นาง แมนือ แมปอ ปอ ชี แฮ้ง ฮา โปยว ปี่ ล่าง ญ้า” แน. ยาว ชฺ้างแมปอ แฮ้มาง ซฺ้อก ย้า ฮูมย้าง ล้า ชี. แน ยาง มือ พระเยซู นา ย่อ เค่ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","พระเยซู แน ศิษย์ อือ เยรูซาเล็ม อางเมิง โย้เวอ ชา เคอ แล เมอ, ยองมู แฮ้ง เบธฟายี ค่อง แน เบธานี ค่อง โย้เวอ เคิน แล คูชี. เบธฟายี ค่อง แน เบธานี ค่อง นี้ย่า มะกอกเทศ ตาแซ้ ท่า โย้เวอ ดื้ง แง. ยาว พระเยซู มือ ศิษย์ 2 คู่น ม่าง เย่ดนา ซฺาแล ปี่ ลางออน ฮา ชี. ");
INSERT INTO bzi_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","แน นี้แม้แน ม่า ชี, “ไน้ ล้าก้า โย้เวอ ค่อง แฮ้ค่อง ก้อง อ้อง แลน โว. เคิน แล เมอ ลา อางย่า ทื่อม่าง ล่าตื่อ พือแล่ง จา นา มย้าง แง. ลา นี้มางนา อ่าซ่าง มาง บ่าตา กางซื้ง. ล่าตื่อ พือแล่ง ชี แฮ้ง พื้ยอ่อก ยาว กงาก้อง ชื้ง ล้าน โว! ");
INSERT INTO bzi_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","จาว่าแน ฮาก นี้แม้แน น้า ล่า เมอ, ‘ไน้ ลา นี้มางนา บ้าเจอล้อเกิ้ง ชา ซฺื่ย แอ แง?’ แน. ไน้ มือ นี้แม้แน พอ โว, ‘จี่วีดอางซื้ง ม้า ลา นี้มางนา ไจ ซี้ แง. ไจ เปิน ยาว อางไว่ แน ฮ้าน ซฺาลือ ล่าว่า’” แน. ");
INSERT INTO bzi_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ยาว ศิษย์ มาง เย่ด แลน ชี. แน เย่ด มือ ลา อางย่า ทื่อม่าง มย้าง ชี. ลา นี้ม้า แก้บ้า ก่องทาง ล้องก้อ ล้าก้า โย้เวอ พือแล่ง ชี. แฮ้งย้า เย่ด มือ ล่าตื่อ พือแล่ง ชี แฮ้ง พื้ยอ่อก ชี. ");
INSERT INTO bzi_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ชฺ้าง ทื่อบ่า โย้เวอ จูง จา อืม เย่ดนา นี้แม้แน น้าน ชี, “บ้าเจอฮา ล่าตื่อ พื้ออ่อก แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ยาว เย่ด มือ พระเยซู ม่า จี่ ปี่ชี่ แฮ้งแม้แน พอ ชี. แฮ้งย้า ยอง มือ เย่ดนา ตอย ลา อางย่า แฮ้มางนา ซฺื่ย แอ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ศิษย์ นี้เย่ด ลา อางย่า แฮ้มางนา ชื้ง พระเยซู นา ปี่ เมอ, เย่ด มือ ค่าตอง ค่าลาวอางเง้โลบแล่เซฺ่อ แฮ้ง ลา ต่างค่าง โย้เวอ ค่าง ชี. ยาว พระเยซู มือ ลา แฮ้มางนา ตา แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ค่องช่าง อางอีบ่าอ่า จา แง. ยอง ค่าลาว แฮ้ง แก้บ้า อือเมอ ค่าง ชี. แน ชฺ้าง ทื่อบ่า อือย่า ปาล์มพ่า น่า ย้า เวอ ต่อน ล้า ชี อือ แก้บ้า อือเมอ ค่าง ชี. ");
INSERT INTO bzi_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ยาว ชฺ้าง ล้าก้า เวอ ย่อ แล คูชี อืม แน ชฺ้าง น่องน่อง เวอ ย่อ เค่ แล คูชี อืม นี้แม้แน จี่โฮ้กฮ้าว คูชี, “โฮซันนา! พาจาว มางนา สรรเสริญ ฮา แง! จี่วีดอางซื้ง เวอ, นาง ซฺาลือ ปี่ชี่ มางนา ก่ามป่อน ปี่ ปาว!” ");
INSERT INTO bzi_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“ชฺ้าง ก่าซ้าด ดาวิด นา ก่าซ้าด เพล่อ แต่น ลือ มางนา สรรเสริญ ฮา แง!” “โฮซันนา! พาจาว อางฮื่อ เลิ่นเลิ่น มู่งท่า เวอ ดื้ง มางนา สรรเสริญ ฮา แง!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ยาว พระเยซู มือ เยรูซาเล็ม อางเมิง โย้เวอ อ้อง แลน ชี. แน โบสถ์อางฮื่อ โย้เวอ แลน ชี. แน โบสถ์อางฮื่อ ก่องทาง อือเมอ ต้าว ย้า ย่อ ฮู กว่า ชี. จ้า มู่งคี่ล้าก้า ชา วื้ง กาชา เย่. แฮ้งย้า พระเยซู แน ศิษย์ 12 คู่น อืม เบธานี ค่อง เวอ พ่าว แอ้น แล่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ซอทา แปล้น ล้า ยาว พระเยซู แน ศิษย์ อือ เบธานี ค่อง โย้เวอ จาย ย่อ อ่อก แล เมอ, พระเยซู มือ ฮ่างแบ่น ชี. ");
INSERT INTO bzi_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ยาว ยาง อางเว่อ จาย ย้า ซื่อไค่มี้ล่อก ป่าง ทื่อป่าง มย้าง ชี, อางพ่า ปลื้ง ย้า จา แงแน. แฮ้งย้า ยาง มือ ย่อ อ้อง ฮูน แล ชี, อางซื่อ อางจา ล่าแน. จ้า เคิน แล เมอ ซื่อไค่มี้ล่อก ทื่อซื่อ แนม บ่ามย่าง. ยา อางพ่า แฮ้ง แอ่น ญา มย้าง ชี, ไม้ อางซื่อ ซื่อ ญ่าม บ่าเคอ เย. ");
INSERT INTO bzi_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","แฮ้งย้า พระเยซู มือ ซื่อไค่มี้ล่อก ป่าง มางนา นี้แม้แน จี่ช่าง ชี, “อ่าซ่าง มาง นาง อางซื่อ นี้ง บ่ากงา จฺ่า แล่ก้าน!” แน. ศิษย์ อืม พระเยซู จี่ต่าง แฮ้ง อางกงากย่า ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","พระเยซู แน ศิษย์ อือ เยรูซาเล็ม อางเมิง โย้เวอ เคิน แล เมอ, พระเยซู มือ โบสถ์อางฮื่อ กองโค้ง โย้เวอ อ้อง แลน ชี. แน โบสถ์อางฮื่อ กองโค้ง โย้เวอ ชฺ้าง อางเกิ่ง ก่อง ล้า ชี อือนา แน อางเกิ่ง วื้อ ล้า ชี อือนา ก่าแอ ปี่ชี่. ยา พลู้ เพ่นฮู อือ แน ฮาย่า อางป่อน ก่องฮู อือ โต แน ต่องก่อน แฮ้ง ต่านเลิง ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ยา อ่าซ่าง มางนา โบสถ์อางฮื่อ โย้เวอ อางเกิ่งอางก้อ บ่าปี่ ป่า พ้าด กว่า. ");
INSERT INTO bzi_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ยาว พระเยซู มือ นี้แม้แน ม่าอู่บ ชี, “พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี, ‘กงา โบสถ์อางฮื่อ นี้ย่า ชฺ้าง กูเจ้อกูจาด อือ ยู้มอธิษฐานฮาย้า แน ฮ้าว แง.’ จ้า นอ ค่าโม่ยค่ามโจน ยู้ม ฮา เพล่อ ปี่ชี่!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ปุโรหิต ยอคา แน อางลี้บอางล่าว ม่าอู่บฮู อือ นี้เลิ่ง แบน เมอ, ยอง อางญ่าม ซฺ้า พระเยซู นา ชา แซ่ คูชี. จ้า ยองมู นี้ย่า พระเยซู นา แค คูแง, ไม้ ค่องช่าง อางอีบ่าอ่า พระเยซู ม่าอู่บจี่ต่าง แฮ้งนา ซอ คูแง. ");
INSERT INTO bzi_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","มู่งคี่ล้าก้า เคิน เมอ พระเยซู แน ศิษย์ อืม เยรูซาเล็ม อางเมิง อางเง้ โย้เวอ แอน คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ซอทา แปล้น ลา ยาว พระเยซู แน ศิษย์ อือ ซื่อไค่มี้ล่อก ป่าง พระเยซู แซ้ง ชี แฮ้มาง ก้อง ย่อ ไก เมอ, ศิษย์ อืม มย้าง ชี ซื่อไค่มี้ล่อก ป่าง แฮ้ย่า แฮ่ว กือ ซฺี้น ชี ตู่ตีน โย้เวอ จาย อางเช้ เคอ ย้าแน. ");
INSERT INTO bzi_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","เปโตร มือ เย้ง กงา แล่ชี่ มี้งก้อง พระเยซู ซื่อไค่มี้ล่อก ป่าง นี้มางนา แซ้ง ชีแน. แฮ้งย้า ยาง พระเยซู นา นี้แม้แน ม่า ชี, “อ่าจาน เวอ, โฮก! นาง ซื่อไค่มี้ล่อก ป่าง แซ้ง ชี มางนา ฮู ปาว, แฮ่ว กือ ซฺี้น ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","แฮ้งย้า พระเยซู มือ ศิษย์ อือนา นี้แม้แน ม่า ชี, “พาจาว มางนา เจ่อ โว! ");
INSERT INTO bzi_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","กงา อางเลิ่ง ม้าม้า ม่า แบ ปี่ ล่าว่า, จาว่าแน นอง พาจาว มางนา ก่ามกืด โค แน เจ่อ ยาว, แน นอง จี่ แฮ้ ม้าม้า ย้า เพล่อ แงแน เจ่อ ยาว, นอ ตาแซ้ แฮ้งนา ม่า ทะเล เวอ ล่อย กลา แอ ปี่ เวิม อางกงา ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","นี้งย้า กงา นองนา นี้แม้แน ม่า ล่าแง, พาจาว มางนา อธิษฐาน ฮา เมอ, นอ ยางนา บ้าเจอ ป้า แง. จาว่าแน นอง อางกงา ย้า แน เจ่อ ยาว, นอง แฮ้แม้ ย้า กงา แง. ");
INSERT INTO bzi_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","นอง อธิษฐาน ฮา เมอ, จาว่าแน อ่าซ่าง นา นืงบาค่า แง, นืงบาค่า แฮ้ง ว่าง ยาว อางเลิ่ง บ่ายู่ โจ. ยาว อ่าโบ้งพาจาว มู่งท่า เวอ ดื้ง มาง นอง อางซี ฮา ชี แฮ้งนา อางซีอางบล่าบ บ่ายู่ ล่า. ");
INSERT INTO bzi_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","จ้า จาว่าแน นอง ฮากนา อางเลิ่งยู่ ยาว, อ่าโบ้งพาจาว มู่งท่า เวอ ดื้ง มาง คาตา ย้า นองนา อางซีอางบล่าบ ยู้ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ยาว พระเยซู แน ศิษย์ อืม เยรูซาเล็ม อางเมิง โย้เวอ ทื่อเทอ อ้อง แลน แล่ คูชี. พระเยซู โบสถ์อางฮื่อ กองโค้ง โย้เวอ ย่อ กว่า เมอ, ปุโรหิต ยอคา อือ, อางลี้บอางล่าว ม่าอู่บฮู อือ แน ยิวชฺ้าง ยอคา อืม พระเยซู นา ย่อ ซฺ้า ล้า คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","แน นี้แม้แน น้าน ชี, “นา อ่าซ่าง? นางนา อ่าซ่าง ล่าที่ ปี่ นี้แม้แน ฮา ปี่ ล่าแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ยาว พระเยซู มือ จี่พอ ชี นี้แม้แน, “กงา นองนา น้า ล่าง นี้ง ม่า ล่าวแล, ยาว กงาม นอง กงานา น้า ล่าง นี้ง ม่า ล่าว่า กงา อ่าซ่าง ล่าที่ แฮ้ง ไจ อางเลิ่ง นี้อือ ฮา แงแน. ");
INSERT INTO bzi_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","กงานา ม่าย ล่าวแล, ยอห์น ล้างตือพิธีบัพติศมา ฮา แฮ้ย่า ยางนา อ่าซ่าง ล่าที่ ปี่ชี่. พาจาว มาง ปี่ ชี ลา, อ้าว ชฺ้าง อือ ปี่ ชี?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ยาว ยองมู แฮ้ง นี้แม้แน จี่ ลางกา ชี, “กงู ยางนา บ้าเจอล้อแม้แน พอ คูวา? จาว่าแน กงู ยางนา นี้แม้แน พอ ยาว, ‘พาจาว มาง’ แน. ยาง กงูนา นี้แม้แน น้า ล่า กาน้าอี่, ‘ท้าว นอ บ้าเจอฮาย ยอห์น นา บ่าเจ่อ คูแน?’ แน. ");
INSERT INTO bzi_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","จ้า กงู ยางนา นี้แม้แน พอ ยาว, ‘ชฺ้าง ก้อง จายล้า แง’ แน. ค่องช่าง อืม กงูนา นืงบาค่า ล่า กาน้าอี่, ไม้ ค่องช่าง อือย่า เจ่อ คูง ยอห์น พาจาวจี่ต่างจี่แต่นฮู” แน. ");
INSERT INTO bzi_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","แฮ้งย้า ยอง พระเยซู นา นี้แม้แน พอ คูชี, “บ่าแบ ล้า” แน. แฮ้งย้า พระเยซู มือ ยองนา นี้แม้ ม่า ชี, “นี้แม้แนยาว กงาม นองนา บ่าม่า ล่า, อ่าซ่าง กงานา ล่าที่ ปี่ นี้แม้ ฮา ปี่ ล่าชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","พระเยซู อางเลิ่ง อู่บ เพ้ก น้า ปี่ชี่. ยา นี้แม้แน จี่ แง, “ค่าพ่าย่า ทื่อม่าง จา แง อ่างู่น โซน ว่า ชี. ยาว ก้ามทื้อ ทือ แวด ชี. แน อ่างู่น น่างเซฺ่อ ค่ามตู่ ตู่ ชี. ยาว หอคอย แต่ง ชี. ยาว ฮากนา ว่าพ่าพ้า ปี่ชี่. ยาว ยาง อางโต แฮ้ย่า ฮาก อางเมิง เวอ แอ้น ชี. ");
INSERT INTO bzi_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","อ่างู่น ชู ญ่าม เคิน เมอ ยาง มือ ยาง ย่าเจ่น ทื่อม่าง มางนา ไจ อ่างู่น แฮ้ง เปิ่ง ยู้ ล้า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","จ้า ชฺ้าง โซนว่าพ่าพ้า คูชี อือย่า ย่าเจ่น แฮ้มางนา ชู ตื่อ คูชี, แน ก่า พ่าว แอ แล่ ปี่ชี่ ยางนา เจิ้นเจ้อ บ่าปี่ คู. ");
INSERT INTO bzi_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","แฮ้งย้า โซนซื้ง มาง ยาง ย่าเจ่น ทื่อม่าง มางนา อางซฺื่อ ซฺา ล้า แล่ ปี่ชี่. จ้า นี้เทอ ชฺ้าง โซนว่าพ่าพ้า คูชี อืม ย่าเจ่น แฮ้มางนา ชอน กา ยาง อางตู่ เวอ ตื่อ ชี. แน ยางนา ฮา ซฺ่าจอ แล่ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","น่อง โย้เวอ โซนซื้ง มาง ยาง ย่าเจ่น ทื่อม่าง มางนา อางซฺื่อ ซฺา ล้า แล่ ปี่ชี่. จ้า ชฺ้าง โซนว่าพ่าพ้า คูชี อืม ย่าเจ่น แฮ้มางนา แซ่ คูชี. ยาว โซนซื้ง มาง ชฺ้าง อางซฺื่อ ซฺา ล้า แล่ ปี่ชี่ ไลเทอ ย้า. โซนซื้ง มาง ชฺ้าง ซฺา ล้า ปี่ชี่ อือย่า ทื่อบ่า อือนา ชฺ้าง โซนว่าพ่าพ้า คูชี อือ ตื่อ ชี, แน ทื่อบ่า อือนา แซ่ ชี.” ");
INSERT INTO bzi_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“น่อง โย้เวอ โซนซื้ง มาง ชฺ้าง อือย่า ทื่อม่าง ญา จ้านล้า ชี. ชฺ้าง แฮ้ม้า ยาง อางย่าย่าค่า ลาก เลิ่นเลิ่น มาง ย้า. แฮ้งย้า ยาง มือ ยาง อางย่าย่าค่า มางนา ซฺาแอ ปี่ชี่. โซนซื้ง ม้า นืงบา เวอ นี้แม้แน เย้ง แง, ‘โซนว่าพ่าพ้า อือ กงา อางย่าย่าค่า มางนา อางน้า จ่า นาตู้’” แน. ");
INSERT INTO bzi_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“จ้า ชฺ้าง โซนว่าพ่าพ้า คูชี อือย่า ยอง อางมู โย้เวอ นี้แม้แน ม่า ลางกา ชี, ‘ชฺ้าง นี้ม้า โซนซื้ง อางย่าย่าค่า ม่าง ย้า. กงู ยางนา ปล่อง แซ่ กาเซฺ้อ, อ่างู่น โซน นี้ง กงูเฮอ เพล่อ คาไล!’ แน. ");
INSERT INTO bzi_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","แฮ้งย้า ชฺ้าง โซนว่าพ่าพ้า คูชี อืม ยางนา ชู แซ่ ยาว อ่างู่น โซน อางเง้ โย้เวอ ลาม วี แอ ชี.” ");
INSERT INTO bzi_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ยาว พระเยซู มือ ยองนา นี้แม้แน จี่ช่าง ชี, “นอง เย้ง กาน ยาว โซนซื้ง ม้า บ้าเจอล้อแม้ ฮา แง? ยา ชฺ้าง โซนว่าพ่าพ้า คูชี อือนา ล้าย แซ่ ล้า ยาว อ่างู่น โซน แฮ้ง ฮากนา ว่าพ่าพ้า ปี่ง ลา? ");
INSERT INTO bzi_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","นอ พระคัมภีร์ นี้ข้อ นา บ่ากงา อ้าน ลา? พระคัมภีร์ โย้เวอ นี้แม้แน แต้ม ชี ชี, ‘ยู้ม ซ้าล้า อือ ยู้มยื้ง วี ชี นี้ยื้ง น่อง โย้เวอ เสาเอก เพลิ่น ชี. ");
INSERT INTO bzi_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","นี้ย่า จี่วีดอางซื้ง มาง ฮา เพล่อ ปี่ชี่. กงูนา ฮา มย้าง ปี่ ล่าง นี้เลิ่ง นืงบาม่านคาบอล้อ ย้า’” แน. ");
INSERT INTO bzi_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ยิวชฺ้าง ยอคา อือย่า อางแบ ย้า, พระเยซู ยองนา จี่ เพ้ก แง, ยองมู นี้ย่า ชฺ้าง โซนว่าพ่าพ้า คูชี อือ ย้าแน. แฮ้งย้า ยอง พระเยซู นา อางเลิ่ง ซฺ้า ชา ชู คูชี. จ้า ค่องช่าง อือนา แค บ่าฮา จอ กา. แฮ้งย้า ยอง พระเยซู นา เจิ่ก แอน คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ยิวชฺ้าง ยอคา อือ ฟาริสี อางมู เวอ ชฺ้าง ทื่อบ่า อือนา, แน ก่าซ้าด เฮโรด อางมู เวอ ชฺ้าง ทื่อบ่า อือนา, ไจ พระเยซู นา ซฺ้า แอ ปี่ชี่, ไม้ ยองนา พระเยซู นา อางเลิ่ง ซฺ้า อางซี ชู ปี่ง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ยองมู นี้ย่า พระเยซู นา นี้แม้แน น้าน คูชี, “อ่าจาน เวอ, กงู อางแบ ย้า นา ชฺ้าง อางซืออางปลอง, อางกง่าอางเกิง, อ่าซ่าง มางนา แมก่า บ่าชี่, นา อางเลิ่ง ม้าม้า พาจาว มาง ชฺ้าง อือนา ฮา ปี่ ซีง แฮ้ง ม่าอู่บ แงแน. กงูนา ม่า ล่าว แล, ก่าซ้าดยอคา ซีซาร์ นา ภาษี ฮู่ ปี่ นี้ย่า อางกง่าอางเกิง ลา? ");
INSERT INTO bzi_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","“ปี่ แฮ้ง ซูม ล่า, อ้าว บ่าปี่ แฮ้ง ซูม แง?” แน. จ้า พระเยซู อางแบ ย้า ยองมู นี้ย่า ยางนา จ้อบน้า แงแน. แฮ้งย้า นี้แม้แน จี่ ชี, “นอ บ้าเจอฮา กงานา จ้อบ อางซี ชู ล่าแง? กงานา พลู้ ทื่อเหรียญ ปี่ ล่าว แล” แน. ");
INSERT INTO bzi_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ยาว ยองมู แฮ้ง พระเยซู นา พลู้ ทื่อเหรียญ ปี่ ชี. ยาว พระเยซู มือ ยองนา นี้แม้แน น้าน ชี, “นี้ย่า อ่าซ่าง อางฮูบ แน อ่าซ่าง อางเม้ง?” แน. ยองมู แฮ้ง นี้แม้แน พอ ชี, “ก่าซ้าดยอคา ซีซาร์” แน. ");
INSERT INTO bzi_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","แฮ้งย้า พระเยซู มือ ยองนา นี้แม้แน ม่า ชี, “นี้แม้แนยาว ซีซาร์ อางเกิ่ง นี้ย่า ซีซาร์ นา ปี่ ปาว, พาจาว มาง อางเกิ่ง นี้ย่า พาจาว มางนา ปี่ ปาว” แน. ยาว ยองมู แฮ้ง พระเยซู จี่ต่าง แฮ้งนา นืงบาม่าน คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","สะดูสี มู ชฺ้างซฺี้ ยาว บ่าแต่ล้า แล่ กงากา แน เจ่อ อือ, พระเยซู นา น้า ล้า คูชี นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“อ่าจาน เวอ, โมเสส ย่า กงูนา ม่า ล่าแง นี้แม้แน, ‘ค่าพ่าย่า ล้อมาง อางย่า บ่าจา แน ซฺี้ ยาว, ยาง อางแพ้ มางมือ อางอ้าย มาง ค่าบา มางนา ยู้ แง. ยาว อางย่า กงา ยาว อางอ้าย มาง อางเจ้อ แฮ้ง ซื้บแล ปี่ แง.’ ");
INSERT INTO bzi_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","นี้เทอ เวอ ม้องน้าม 7 คู่น จา แง. อางอ้าย ซากาว มาง ค่าบา ยู้ ยาว, อางย่า บ่าจา กื้ง แน ซฺี้น ชี. ยาว ยาง ค่าบา มาง แมม้าย เพลิ่น ชี. ");
INSERT INTO bzi_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","ยาว ชฺ้างซฺี้ แฮ้มาง อางแพ้ ที่ 1 ม่าง แมม้าย แฮ้มางนา ยู้ ชี. ยาว ยาง มือ อางย่า บ่าจากื้ง แน ซฺี้น ชี. ยาว อางแพ้ ที่ 2 แน อางแพ้ ทื่อบ่า อืม นี้แม้แน ย้า ฮา ยาว อางย่า บ่าจากื้ง แน ซฺี้น คูชี. ม้องน้าม 7 คู่น คาโคลาโค นี้อือย่า ค่าบาย่า แฮ้มางนา ยู้ ยาว, อางย่า บ่าจา กื้ง แน ซฺี้น คูชี. ยาว น่อง โย้เวอ ค่าบาย่า แฮ้มาง ซฺี้น ชี. ");
INSERT INTO bzi_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ยาว ม้องน้าม 7 คู่น นี้อือ แต่ล้า แล่ แฮ้นืง ค่าบาย่า นี้ม้า อ่าซ่าง ค่าบา เพล่อ แง? ไม้ ยา ม้องน้าม 7 คู่น คาโคลาโค นี้อือ ค่าบา เพล่ออ่าน น่อ” แน. ");
INSERT INTO bzi_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ยาว พระเยซู มือ ยองนา จี่พอ ชี นี้แม้แน, “นอย่า เย้ง ซี คูชี, ไม้ นอ พระคัมภีร์ แฮ้ง แม่น แน บ่าแบ คู, แน พาจาว มาง ล่าที่ แฮ้งนา บ่าแบกงากา คู. ");
INSERT INTO bzi_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ชฺ้างซฺี้ อือย่า แต่ล้าน แล่เมอ อางบี่อางบล้อง บ่ายู่ แล่ก้าน. แน อ่าซ่าง มาง อางบี่อางบล้อง บ่าเพล่อ กา แล่ก้าน. จ้า ยอ เท่วาด่า แม้แน เพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","นอ โมเสส ปาบ โย้เวอ จฺืงจฺื้งปาว บี่ท่ออางจฺ่อ อางเลิ่ง แต้ม ชี ชี แฮ้งนา บ่ากงา อ้าน ลา? แฮ้ เลิ่ง ก้อง เวอ พาจาว มาง โมเสส นา จี่ช่าง ชี แฮ้ง แต้ม ชี ชี. แน พาจาว ม้า นี้แม้แน จี่ ชี, ‘กงา อับราฮัม, อิสอัค แน ยาโคบ ยอง พาจาว บอกไว้ มาง ย้า’ แน. นี้แม้แนยาว อามืม ยอง 3 คู่น นี้ย่า มู่งท่า โย้เวอ พาจาว มางนา อางบอกไว้ คูย้า. ");
INSERT INTO bzi_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","พาจาว นี้ม้า ชฺ้างซฺี้ อือ พาจาว บ่าอ่า, จ้า ชฺ้าง อางแต่ อือ พาจาว. นอ นี้เลิ่ง นา โค ย้า เย้งซี ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","อางลี้บอางล่าว ม่าอู่บฮู ทื่อม่าง จา แง. ยอง จี่กางแฮ้ง จูง น้า ชี. ยาว ยาง มย้าง ชี พระเยซู สะดูสี อือนา จี่พอ แฮ้ นาบาตา แม่น แน. แฮ้งย้า ยาง มือ พระเยซู นา นี้แม้แน อ้อง น้า ล้า ชี, “โมเสส อางลี้บอางล่าว คาโคลาโค นี้ย่า บ้าเจอ ล้อข้อ ปีนแตปีนนา จา เลิ่นเลิ่น แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","พระเยซู มือ นี้แม้แน พอ ชี, “อางลี้บอางล่าว ปีนแตปีนนา เลิ่นเลิ่น ม้าย่า นี้แม้แน เป, ‘อิสราเอลชฺ้าง เวอ, แม่น แน น้า โว! พาจาว กงู จี่วีดอางซื้ง เพล่อ ชี่ นี้มาง ญา พาจาว ม้าม้า เพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","พาจาว นอง จี่วีดอางซื้ง เพล่อ ชี่ นี้มางนา นืงบา โค, ก่ามกืด โค, แฮ่ง โค แน ลาก โว!’ ");
INSERT INTO bzi_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ยาว อางลี้บอางล่าว ปีนแตปีนนา ที่ 2 ม้าย่า นี้แม้แน เป, ‘ค่าตอง นา ลากจ่าแล่ง แฮ้งแม้แน ยู้มต่องยู้มทาง อือนา ลาก โว!’ อางลี้บอางล่าว 2 ข้อ นี้ย่า อางลี้บอางล่าว ทื่อบ่า อือ ล่อบ่าปา ปีนแตปีนนา ฮา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ยาว อางลี้บอางล่าว ม่าอู่บฮู นี้มาง พระเยซู นา นี้แม้แน จี่ช่าง ชี, “อ่าจาน เวอ, พาจาว นี้ย่า ทื่อม่าง ญา จา แงแน นาง จี่ นี้ย่า อางกง่า ย้า. พาจาว ม้าม้า นี้ย่า พาจาว นี้มาง ญา จา แง. พาจาว กาบ่ากาเจ้อ บ่าจา แล่ก้าน. ");
INSERT INTO bzi_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","พาจาว มางนา นืงบา โค, ก่ามกืด โค, แฮ่ง โค แน ลาก นี้ย่า, แน ค่าตองนา ลากจ่าแล่ง แฮ้งแม้แน ยู้มต่องยู้มทาง อือนา ลาก นี้ย่า, อางลี้บอางล่าว เวอ ม่า อางเกิ่งท่านเซฺ่อ, แน อางเกิ่งพีท่านเซฺ่อ ท่าน ปี่ชี่ แฮ้ง ล่อบ่าปา ปีนแตปีนนา ฮา แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","พระเยซู มือ อางลี้บอางล่าว ม่าอู่บฮู แฮ้มาง จี่พอ นี้ย่า วี่ไซป้านญา อางจา แน มย้าง เมอ, ยาง นี้แม้แน จี่ ชี, “บ่ามล่าง ยาว นา พาจาว มาง ชฺ้าง อางกงาเพล่อ นาตู้” แน. แฮ้เมอ จายล้า แล่ยาว อ่าซ่าง มาง พระเยซู นา บ่าน่า จอ แล่. ");
INSERT INTO bzi_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","พระเยซู โบสถ์อางฮื่อ กองโค้ง โย้เวอ ม่าอู่บ จา เมอ, ยาง มือ ค่องช่าง อือนา นี้แม้แน น้าน ชี, “อางลี้บอางล่าว ม่าอู่บฮู อือย่า นี้แม้แน ม่าอู่บ คูแง, ‘พาจาว มาง ชฺ้าง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้ม้า, ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บล้า ชี’ แน. ท้าว ยอง ม่าอู่บจี่ต่าง นี้ย่า บ้าเจอล้อแม้ เพล่อ กงากา แง? ");
INSERT INTO bzi_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ไม้ ก่าซ้าด ดาวิด มือ อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ยางนา ม่า จี่ ปี่ชี่ แฮ้งแม้แน จี่ แง. ยา นี้แม้แน จี่ แง, ‘พาจาว ม้า ยาง ชฺ้าง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้มางนา แน กงา จี่วีดอางซื้ง เพล่อ ชี แฮ้มางนา นี้แม้แน จี่ช่าง ชี, กงา ล่าปู่ ล่าม่า นี้กย้า ดื้ง ลื่อ ปาว. กงา ชฺ้าง นางนา เม้อ ล่าง อือนา ฮาย นาง ล่าคื่อโบ้ยย้า เพล่อ ปี่ เมอ ตื่อเคอ แน.’ ");
INSERT INTO bzi_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“ซ้ามบ้า ก่าซ้าด ดาวิด มือ, พาจาว มาง ชฺ้าง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้มางนา นี้แม้แน ฮ้าว แง, ‘กงา จี่วีดอางซื้ง มาง’ แน. นี้แม้แนยาว พาจาว มาง ชฺ้าง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้ม้า, ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บล้า ชี. จ้า ยา ก่าซ้าด ดาวิด ล่อบ่าปา ฮื่อ แล่ง” แน. ค่องช่าง อางอีบ่าอ่า พระเยซู ม่าอู่บ แฮ้ง ดื้งน้า คูชี. แน ยองมู นี้ย่า กย่างม่อนซ้า นืงบาจาบื่อ ย้า ดื้งน้า คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","พระเยซู มือ นี้แม้แน ม่าอู่บ ชี, “อางลี้บอางล่าว ม่าอู่บฮู นี้อือนา แม่น แน อางโต แล่ม แล่ โว! ยองมู นี้ย่า คู่ ค่าลาวอางเง้โลบแล่เซฺ่อ อือ ตูม แล่ ยาว, ก้าด อือเมอ ย่อกว่า นา อางซอ คู, ไม้ ฮากนา ยองนา ล่าปู่ โญกไว้ ปี่ง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","จฺ่าปอต้างปอ ฮา ล่ากาน เวอ แอ เมอ, แน ยิวชฺ้าง โบสถ์ คล้าว โย้เวอ อ้อง ไว้ แล เมอ, ยองมู นี้ย่า ดื้งย้า ปีนแตปีนนา เลิ่นเลิ่น เวอ ดื้ง นา อางซอ คู. ");
INSERT INTO bzi_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","จ้า ยองมู นี้ย่า แมม้าย อือ ยู้ม แฮ้ง จ้อบ ยู้ คูชี. แน ยอ ป่องฮ่าน ย้า มล่าง แน อธิษฐาน ฮา คูแง, ไม้ ยอ ชฺ้าง อางแม่น แน ฮากนา เย้ง ปี่ง แนนอ. ชฺ้าง นี้อือ นาบาตา ย้า วี่บ่ากกงาไจ คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","พระเยซู โบสถ์อางฮื่อ อางคล้าว โย้เวอ จา เมอ, ยาง มือ อางฮี้บ พลู้ กานท่านย่า ล้าก้า โย้เวอ ดื้ง ชี. แน ยา ชฺ้าง อือ อางฮี้บ โย้เวอ พลู้ กาน แฮ้งนา ดื้ง ฮูน ชี. ชฺ้าง อางจาอางปาง อือย่า พลู้ บย่า แน กาน แง. ");
INSERT INTO bzi_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","แมม้าย อางตูกอางพาน ทื่อม่าง จา แง. พลู้ 2 สลึงค์ กาน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","แฮ้งย้า พระเยซู มือ ศิษย์ อือนา ฮ้าว อ้องล้า ปี่ ยาว นี้แม้แน ม่า ชี, “กงา ม่าแบ ปี่ ล่าว่า, แมม้าย นี้ม้า ฮาก ล่อบ่าปา พลู้ ท่าน แอ่ บย่า แงแน, ");
INSERT INTO bzi_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ไม้ ฮาก พลู้ ท่าน ชี นี้ย่า ยอง พลู้ ไจ จ้านล้า ชีย้าง เป. จ้า แมม้าย นี้ม้า นาบาตา ตูก เวิม, ยาง พลู้ คาโคลาโค ฮ่าง จฺ่าเกิ่ง วื้อ จฺ่าเซฺ่อ จา ชีย้าง ท่าน ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","พระเยซู โบสถ์อางฮื่อ โย้เวอ ย่อ อ่อก ลือ เมอ, ศิษย์ ทื่อม่าง มาง พระเยซู นา นี้แม้แน จี่ช่าง ชี, “อ่าจาน เวอ โบสถ์อางฮื่อ นี้อือนา ฮูปาว, อางมาง ม้าม้า ย้า. ลอบา อางฮื่อ แอ่ย้า ไจ แต่ง ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","พระเยซู มือ นี้แม้แน พอ ชี, “โบสถ์อางฮื่อ นี้อือนา มย้าง ย่า อ่าลา? กาญ่าม เวอ โบสถ์อางฮื่อ นี้อือ ก่างพยา แง. ลอบา ตาก ลางกา ชี นี้ย่า เลิง พู่นพ่าน แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ยาว พระเยซู แน ศิษย์ อืม มะกอกเทศ ตาแซ้ โย้เวอ แลน คูชี. มะกอกเทศ ตาแซ้ นี้ย่า โบสถ์อางฮื่อ ล้าก้า ป่ากย่า ดื้ง แง. พระเยซู มะกอกเทศ ตาแซ้ โย้เวอ ดื้ง จา เมอ, เปโตร, ยากอบ, ยอห์น แน อันดรูว์ ยองมู แฮ้ง แอ่ แน, พระเยซู นา นี้แม้แน น้าน ล้า คูชี, ");
INSERT INTO bzi_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“อางเลิ่ง นี้อือ อาล้อม เมอ ตอล้า แง? อางเลิ่ง นี้อือ ตอล้า อางญ่าม แฮ้ง ชา เคิน เมอ, กงู บ้าเจอ กงามย้าง ลางออน ฮา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ยาว พระเยซู มือ พอ ชี นี้แม้แน, “อางโต แล่มจ่าแล่ คูโว! อ่าซ่าง มางนา บ่าปี่ จ้อบ โจ เป, ");
INSERT INTO bzi_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ไม้ ชฺ้างอางบย่า ย้า กงา อางเม้ง แฮ้ง จี่อ้าง จ่าแล่ง แง, ยอย่า พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ ชี่ มาง แน ฮาจ่าแล่ คูแง, ยาว ชฺ้างอางบย่า ย้า เจ่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","จาว่าแน นอง สงคราม อางเซง กงากย่า เมอ, บ่าอ่ายาว สงคราม ตอล้า ชี แน กงากย่า เมอ บ่าแค คูโจ, ไม้ แฮ้แม้ ม้าม้า ย้า ตอล้า แง. จ้า นี้เลิ่ง ตอล้า เมอ ชฺ้างอางเมิง ลีน ย่าง บ่าอ่า เป. ");
INSERT INTO bzi_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ชฺ้าง ไลเจ้อไลจาด ย้า แซ่ กาแง. อางเมิง ไล เมิง ย้า แซ่ กาแง. ชฺ้างอางเมิง นู้เวอ กูต่องกูตี่ ย้า มี่ซี่อืน แง. แน ฮ่าง จฺ่าเกิ่ง เคม แง. นี้ย่า ชฺ้างอางเมิง นู้เวอ อางนืงลีน แฮ้นืง ชา เคิน ล้า เมอ ต่องก่าต่าง ตูกพานลาบ้าบ ย้าง ย้า, ค่าบาย่า อือ อางย่า ชาเกิ้ด เมอ ด้ากย้าง แฮ้ง ป้าค้า ย้าเป” แน. ");
INSERT INTO bzi_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“แม่น แน อางโต แล่ม แล่ คูโว! นองนา อางซีต้าดต่อนย่า เวอ ชู แล ล่าง. นองนา ยิวชฺ้าง โบสถ์ โย้เวอ ตื่อชืก ล่าง. แน นองมู นี้ย่า กงา ปาปาย ย้า ผู้ว่า อือ, แน ก่าซ้าด อือ ล้าก้า โย้เวอ กงาจูง แล คูแง, ไม้ กงา อางเลิ่ง อางแม่น นี้ง ยองนา ม่า แบ ปี่ง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","จ้า ชฺ้างอางเมิง นู้เวอ อางนืงลีน แฮ้ง ชา เคอ ล้า เมอ, นอ อางเลิ่ง อางแม่น นี้ง ชฺ้าง กูเจ้อกูจาด อือนา กงาป่าว ม่า แง. ");
INSERT INTO bzi_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","นองนา อางซีต้าดต่อนย่า เวอ ชู แล ล่า เมอ, บ้าเจอล้อแม้ แน จี่ วา แน บ่าพี่บ่าล่อง คูโจ, ไม้ อางญ่าม เคิน ยาว พาจาว มาง นองนา ล้อแม้แน จี่ ปี่ ล่าแง แน ม่า ล่าแง. ม้าม้า นี้ย่า จี่ฮู ม้าย่า นอง อางโต แฮ้ง บ่าอ่า, จ้า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง นอง อางโต โย้เวอ ล่ากาน ว่า มาง จี่ แง.” ");
INSERT INTO bzi_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“กาญ่าม เวอ อางเลิ่ง นี้อือ ตอล้า แง, ม้องน้ามต่องม้องน้าม แน บ่าแม่น ฮา กายาว ฮากนา ม่า แซ่ ปี่ แง. อางโบ้ง อืมมือ อางย่า นา บ่าแม่น ฮาช่าง ยาว ฮากนา ม่า แซ่ ปี่ แง. อางย่าอางคย้า อืมมือ อางบา อางโบ้ง นา บ่าแม่น ฮาช่าง ยาว ฮากนา ม่า แซ่ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ชฺ้าง คาโคลาโค อือย่า นอง กงานา เจ่อ ล่า ชีแฮ้ง ปาปาย ย้า นองนา เม้อ ล่าง. จ้า จาว่าแน อ่าซ่าง อางนืงลีน แฮ้นืง เวอ เคอ แน โอ้ด กงา กาแง, ชฺ้าง แฮ้ม้า กงาปูน แล่แง.” ");
INSERT INTO bzi_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“นอง โบสถ์อางฮื่อ โย้เวอ ชฺ้าง อือ, อางเลิ่ง ช่าคาบอล้อ, แคคาบอล้อ แน ชี่ อือ ฮา นา มย้าง เมอ. (นี้ข้อ อ้านฮู อือย่า แม่น แน อ้าน ยาว แบ ปี่ โว.) ชฺ้าง ยูเดีย แควน โย้เวอ ดื้ง คูชี อือนา ตาแซ้ โย้เวอ ฮื่น แล ปี่ โว. ");
INSERT INTO bzi_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ชฺ้าง ยู้มมู้ง อางท่า ดื้ง ชี อือนา ยู้ม คล้าว โย้เวอ อางเกิ่งอางก้อ บ่าปี่ อ้อง กอ แล โจ. ยองนา อางไว่ แน ตาแซ้ โย้เวอ ฮื่น แล ปี่ โว! ");
INSERT INTO bzi_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ชฺ้าง น่า ย้า โย้เวอ จา คูชี อือนา, ยู้ม คล้าว โย้เวอ อางก่าอางตูม บ่าปี่ อ้อง ยู้ แล โจ. ยองนา อางไว่ แน ตาแซ้ โย้เวอ ฮื่น แล ปี่ โว! ");
INSERT INTO bzi_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","อางญ่าม แฮ้ญ่าม ย่า ชฺ้างอู่ปู่ม แน ชฺ้าง อางย่า อือนา ลองแปด ชู่ ปี่ง อือ อางญ่าม แคคาบอล้อ แน ชี่ ย่างย้า. ");
INSERT INTO bzi_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","พาจาว มางนา อธิษฐาน ฮา คูปาว, อางเลิ่ง แคคาบอล้อ นี้งนา ช่อมย่า เวอ บ่าปี่ ตอล้า โจ แน. ");
INSERT INTO bzi_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ไม้ แฮ้ญ่าม เวอ อางตูกอางพาน อางฮื่อ ตอล้า แง. ชฺ้างอางเมิง บ่าจา กาซื้ง เมอ จาย อามือ เคอ นี้ย่า นี้แม้แน บ่าตอล้า กาซื้ง เป. แน อางเลิ่ง นี้แม้แน ตอล้า ชี นี้ย่า กาญ่าม เวอ บ่าจา แล่ก้าน. ");
INSERT INTO bzi_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","จี่วีดอางซื้ง มาง อางญ่าม แฮ้ง บ่าฮา กื้น ปี่ ยาว, อ่าซ่าง มาง จี่วีด บ่ากงาปูน แล่. จ้า ยาง ชฺ้าง แช้ ชี ชี อือนา ฮูจ่าปาปาย, แฮ้งย้า ยางมือ อางญ่าม ย่าง ฮา กื้น ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","แฮ้ญ่าม เมอ ชฺ้าง อือ นองนา นี้แม้แน ม่า ล่า เมอ, ‘แฮ้! พาจาว มาง ชฺ้าง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้ม้า นู้เวอ จาน ญา’ แน. บ่าอ่ายาว ‘โฮ้ก! พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้ม้า โย้เวอ จาน ญา’ แน. บ่าเจ่อ จ่า โจ, ");
INSERT INTO bzi_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ไม้ แฮ้ญ่าม เมอ ชฺ้าง อางอีบ่าอ่า จา แง, ยอ ฮากนา นี้แม้แน ม่า แง, ยอ พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้มาง ย้าแน, บ่าอ่ายาว ยอ พาจาวจี่ต่างจี่แต่นฮู เพล่อ แงแน. จ้า กานแตว บ่าอ่า เป. แน ยองมู นี้ย่า อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา แง, ไม้ ชฺ้าง พาจาว มาง แช้ยู้ ชี อือนา จ้อบ แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","แม่น แน อางโต แล่ม แล่ คูโว! ไม้ กงาย่า กูย่างกูเจ้อ ย้า ม่า ชี ลางออน ฮาย ล่าแอ่.” ");
INSERT INTO bzi_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“น่อง โย้เวอ ตูกพานลาบ้าบ แฮ้ญ่าม เปิน เมอ, มู่งนื่ง นี้ย่า วื้งว้าง ย้า. แน อู่ลา แฮ้ บ่าแปล่นบ่าซ่า กาน. ");
INSERT INTO bzi_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","อู่กื่อ อืมมือ มู่งท่า เวอ จาย กลาลือ แง. แน กูย่างกูเจ้อ มู่งท่า โย้เวอ จา อืมมือ ยืก แง. ");
INSERT INTO bzi_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ยาว ชฺ้าง อืม กงาชฺ้างอางย่า เพล่อ ชี่ มางนา มย้าง แง, กงา มู่งบื่น อางป่อน โย้เวอ ทื่งกง่า แน ลือ แง. แน กงาก้อง ล่าที่ อางฮื่อ ปลื้ง ย้า จา แง, ยาว กงา อางโต โย้เวอ อางแปล้นอางซ้า อ่อกล้า แง. ");
INSERT INTO bzi_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ยาว กงาย่า เท่วาด่า อือนา พาจาว มาง ชฺ้าง แช้ยู้ ชี อือนา ซฺ้า ช้อน ปี่ แง. เท่วาด่า อือย่า ชฺ้างอางเมิง นู้เวอ ต้าว ย้า, พาจาว มาง ชฺ้าง แช้ยู้ ชี อือนา ซฺ้า กว่า แง, ชฺ้างอางเมิง ทื่อปล่าก ป่ากย่า จาย ทื่อปล่าก ป่ากย่า เคอ ย้า.” ");
INSERT INTO bzi_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ซื่อไค่มี้ล่อก ป้าง โย้เวอ ฮู กาโน, ล่างาม โย้เวอ อางพ่า พลอง อ่อก ยาว, นอง มือ แบ คู แง ล้องมย้า ชา เคิน ญา แน. ");
INSERT INTO bzi_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ทื่อช่างกานญา, นอง อางเลิ่ง ตอล้า ชี นี้อือนา กงามย้าง เมอ, นอง แบ คูโว กงา ทื่อเทอ ลือ แล่ง อางญ่าม ชา เคอ ชีแน. ");
INSERT INTO bzi_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","กงา ม่า แบ ปี่ ล่าว่า, อางเลิ่ง คาโคลาโค นี้อือ ตอล้า เมอ, อามือชฺ้าง อือ บ่าซฺี่ โค กางซื้ง แน. ");
INSERT INTO bzi_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","มู่งท่า แน ชฺ้างอางเมิง นี้ย่า โปยว แอ แง, จ้า กงา จี่ต่าง นี้ย่า โปยว แอ นืง บ่าจา.” ");
INSERT INTO bzi_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“อ่าซ่าง มาง บ่าแบ อางญ่าม แฮ้ย่า ล้อนืง เคอ ล้า แงแน. ซ้ามบา เท่วาด่า อืม บ่าแบ. กงา พาจาวอางย่า เพล่อ ชี นี้มาง บ่าแบ. อ่าโบ้งพาจาว ญา อางแบ แน. ");
INSERT INTO bzi_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","นี้แม้แนยาว แม่น แน ล่อ ฮู คูโว! ไม้ นอ บ่าแบ อางญ่าม แฮ้ ล้อนืง เคอ ล้า แงแน. ");
INSERT INTO bzi_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","กงา อางเลิ่ง อู่บ เพ้กน้า ปี่ ล่าว่า. ค่าพ่าย่า ทื่อม่าง จา แง. ยาง ย่าเจ่น อือนา ล่ากาน ม่า ว่า ปี่ชี่. แน ยา ชฺ้าง ยู้ม ล่อ ฮู มางนา ม่า ชี ยู้ม แม่น แน ล่อ โว แน. ยาว ยาง มือ ค่าตอง ยู้ม แฮ้ง ชี ช่า ยาว ฮาก อางเมิง เวอ แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","นี้แม้แนยาว นองมู นี้ง แม่น แน ล่อ ฮู คูโว! ไม้ ยู้มซื้ง ม้า อาล้อม พ่าว ล้า แล่ นามบ่าแบ. กาเทอกา มู่งคี่ล้าก้า เวอ พ่าว ล้า แง. กาเทอกา 12 โมง มู่งคี่ เวอ, กาเทอกา ซอทาอางวื้ง ยาต้าน เมอ, กาเทอกา นืงก้อง ก้อง แน พ่าว ล้า แง. ");
INSERT INTO bzi_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ยู้มซื้ง มาง ซฺ้อก แน พ่าว ล้า แล่ เมอ, ยางนา บ่าปี่ มย้าง โจ นอ ยู่น ชีแน. ");
INSERT INTO bzi_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ยาว กงา นองนา อางเลิ่ง ม่ายฮา ปี่ ล่าชี่ นี้ย่า, กงา ชฺ้าง คาโคลาโค อือนา คาตา ย้า นี้แม้แน ม่า แอ, ‘แม่น แน อางโต แล่ม ล่อ คูโว!’” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ปัสกาป่อยนืง แน ค้านู้มป่างอางเจ้อบ่ากานป่อยนืง บ่าเคอ กาซื้ง แน 2 นืง จา แล่ชี่ เย. ปุโรหิต ยอคา แน อางลี้บอางล่าว ม่าอู่บฮู อืม, อางนืง อางญ่าม ซฺ้า พระเยซู นา ค่าว ชู แซ่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ยองมู นี้ย่า นี้แม้แน จี่ ลางกา ชี, “ป่อยนืง ฮา นี้ญ่าม พระเยซู นา บ่าแซ่ โจ, ไม้ อ่าซ่า ค่องช่าง อือ อางเลิ่ง อางซื่กอางซ่าก ฮา ตอล้า ปี่ นา” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ซีโมน เบธานี ค่อง เวอ ดื้ง แง. ยา คี้ตู้ด เพล่ออ่าน เย. พระเยซู ซีโมน ยู้ม โย้เวอ ฮ่างจฺ่า ดื้ง เมอ, ค่าบาย่า ทื่อม่าง จา แง. น้ำหอม นาระดา ทื่อป่าง ท่าม แล่ ยาว, พระเยซู นา ซฺ้า ล้า ชี. น้ำหอม นาระดา นี้ย่า อางฮู่ นาบาตา คา. ยาว ยาง มือ ป่าง ม่านป่อง แฮ้ง ตู ปล่าก ยาว, น้ำหอม แฮ้ง พระเยซู อางตู่ โย้เวอ ต่า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ชฺ้าง ทื่อบ่า โย้เวอ จา ชี อือ นืงบาบ่าจาบ เย. แฮ้งย้า ค่าบาย่า แฮ้มางนา นี้แม้แน จี่ ชี, “บ้าเจอฮา น้ำหอม อางฮู่ นาบาตา คา นี้งนา ค้าค้าเล้อเล้อ แน ต่า บ่อ แง. ");
INSERT INTO bzi_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","จาว่าแน น้ำหอม นี้ง ฮ้าน ก่อง แอ ยาว, กาเทอกา พลู้ 300 เดนาริอัน อางกงา นามบ่าแบ. ยาว พลู้ แฮ้ง ชฺ้าง อางตูกอางพาน อือนา ปี่ เวิม อางกงา ย้า” แน. ยาว ยองมู แฮ้ง ค่าบาย่า แฮ้มางนา นาบาตา ย้า จี่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","จ้า พระเยซู มือ ยองนา นี้แม้แน ม่า ชี, “ยางนา บ่าจี่ โจ. ยางนา บ่าตี่นบ่าต่อง โจ. ยาง กงานา อางเลิ่ง อางแม่น ฮา ปี่ ล่าชี่ นี้ย่า อางซูม ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ชฺ้าง อางตูกอางพาน นี้ย่า กูญ่าม ย้า นองก้อง ทื่งกง่า แน ดื้ง แล แง. แน นอ ยองนา อาล้อม ปล่อง เวิม อางกงา ย้า. จ้า กงา นองก้อง ทื่งกง่า แน กูญ่าม แน บ่าดื่ง แล เป. ");
INSERT INTO bzi_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","แน นี้เลิ่ง ญา ค่าบาย่า นี้ม้า กงานา ฮา ปี่ ล่ากงา กาแง. ยา กงา อางตู่ นู้เวอ น้ำหอม ต่า ล่าแง, ไม้ กงา ซฺี้ ยาว ศพ แฮ้ง ท้ามชฺ้างซฺี้ชีย้า โย้เวอ บ่ากอ ชี ฮู่ เวอ, น้ำหอม ต่า ชี ลางออน ฮา แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","กงา ม่า แบ ปี่ ล่าว่า, ชฺ้างอางเมิง นู้เวอ บ้าเจอล้อเกิ้ง อางเลิ่ง อางแม่น นี้ง ป่าว แง, ชฺ้าง อืม ค่าบาย่า นี้มาง กงานา อางเลิ่ง อางแม่น ฮา ปี่ ล่าชี่ นี้ง คาตา ย้า จี่ เคอ แง, ไม้ ยางนา ปื้อซฺ้า แนนอ” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ยาว ยูดาส อิสคาริโอท พระเยซู ศิษย์เอก 12 คู่น โย้เวอ ศิษย์ ทื่อม่าง มาง, ปุโรหิต ยอคา อือนา ซฺ้า แอ ชี, ไม้ พระเยซู นา ปล่อง ชู แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ปุโรหิต ยอคา อืม แฮ้แม้แน กงากย่า ยาว นาบาตา ย้า กย่าง คูแง. แน ยองมู แฮ้ง ยูดาส นา ก่ามค่าน ปี่ ชี พลู้ ปี่ แงแน. แฮ้งย้า ยูดาส มือ อางนืง อางญ่าม ซฺ้า พระเยซู นา ชู ปุโรหิต ยอคา อือนา ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ค้านู้มป่างอางเจ้อบ่ากานป่อยนืง เวอ ต่องก่าต่าง แฮ้นืง ยิวชฺ้าง อือย่า แกะอางย่า แซ่ แง, ไม้ พาจาว มางนา ท่าน แง, แน ปัสกาป่อยนืง เวอ จฺ่าเกิ่ง แต่ง ปอ กาง แนนอ. ศิษย์ อืม พระเยซู นา นี้แม้แน น้า ชี, “อ่าจาน เวอ, นาง ปัสกาป่อยนืง ฮ่าง จฺ่าเกิ่ง จฺ่าเซฺ่อ นี้ย่า กงูนา บ้าเจอล้อเกิ้ง ซฺ้า ชี ปี่ ล่าแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","แฮ้งย้า พระเยซู มือ ศิษย์ 2 คู่น ม่าง เย่ดนา ซฺาแอ ปี่ชี่. ยา เย่ดนา นี้แม้แน ม่า ชี, “ไน้ อางเมิง คล้าว โย้เวอ อ้องแอน เมอ, ค่าพ่าย่า ทื่อม่าง นา มย้าง แง. ยา อู่ล่องม่อน้าม ป่า แล่แง. ยาว ยางนา เค่ แอน โว! ");
INSERT INTO bzi_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","แน ค่าพ่าย่า แฮ้มางนา เค่ ยู้ม คล้าว โย้เวอ อ้องแอน โว! แน ยู้มซื้ง มางนา นี้แม้แน น้า โว! อ่าจาน นี้แม้แน ม่า น้า ปี่ ล่าง, ‘ปัสกาป่อยนืง เวอ นา กงานา แน ศิษย์ อือนา บ้าเจอล้อเกิ้ง ฮ่างจฺ่า ดื้ง ปี่ ล่าแง?’ แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ยาว ยาง ไน้นา อางฮ้อง ซฺ้า ชี ล่าชี่ แฮ้ง ซฺื่ยฮู แล ล่าง. อางฮ้อง แฮ้ฮ้อง อางฮื่อ แน อางท่า ดื้ง แง. ยาว ไน้ มือ โย้เวอ กงูนา จฺ่าเกิ่ง ซฺ้า ชี ล่าโว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ยาว ศิษย์ 2 คู่น ม่าง เย่ด อางเมิง คล้าว โย้เวอ อ้องแอน ชี. ยาว เย่ด มือ กูย่างกูเจ้อ ย้า มย้าง ชี, พระเยซู ม่า ชี แฮ้งแม้แน. แฮ้งย้า เย่ด มือ ปัสกาป่อยนืง เวอ ฮ่าง จฺ่าเกิ่ง จฺ่าเซฺ่อ แฮ้ง โย้เวอ ซฺ้า ชี ชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","มู่งคี่ล้าก้า เคิน เมอ พระเยซู แน ศิษย์เอก 12 คู่น อืม ยู้ม แฮ้ลาง ก้อง เคิน แอ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","แน ยอง ทื่งกง่า แน ฮ่างจฺ่า ดื้ง เมอ พระเยซู มือ นี้แม้แน จี่ ชี, “กงา อางเลิ่ง ม้าม้า แฮ้ง ม่าแบ ปี่ ล่าว่า, นอง อางมู นู้เวอ ชฺ้าง ทื่อม่าง จา แง, กงานา บ่าแม่น ฮา ล่าแง. แน ชฺ้าง แฮ้ม้า กงาก้อง ทื่งกง่า ย้า ฮ่างจฺ่า ดื้ง ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ยาว ศิษย์ อืม นืงบาต่องบ่าม่อนบ่าซ่า คู. ยองมู คาโคลาโค แฮ้ง กาจาง กามาง กา แน พระเยซู นา นี้แม้แน น้าน คูชี, “กงา บ่าอ่า อ่าลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","แฮ้งย้า พระเยซู มือ ยองนา นี้แม้แน พอ ชี, “นอง อางมู 12 คู่น นู้เวอ ชฺ้าง ทื่อม่าง มาง ย้า. ชฺ้าง แฮ้ม้า กงา น้ำจิ้ม ลอค่อ ค้านู้มป่าง คี จฺ่า ชี แฮ้มาง ก้อง ค้านู้มป่าง คี จฺ่า แง. ");
INSERT INTO bzi_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","กงาชฺ้างอางย่า เพล่อ ชี นี้ม้า กงาซฺี้ แง, พระคัมภีร์ เวอ มอ ยาว แต้ม ชี ชี แฮ้งแม้แน ย้า. จ้า ชฺ้าง กงานา บ่าแม่น ฮา ล่าง แฮ้มางนา พาจาว มาง ต้าดต่อน วี่บ่ากไจ ปี่ แง. ชฺ้าง แฮ้ม้า บ่ากงา เกิ้ดลือ แฮ้ง เชคาไล” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","พระเยซู แน ศิษย์ อือ ทื่งกง่า แน จฺ่าต้าง ดื้ง คู เมอ, พระเยซู มือ ค้านู้มป่าง แฮ้ง กอ ท่าม แล่ชี่. แน พาจาว มางนา ขอบคุณ ฮา ชี. ยาว ยาง ค้านู้มป่าง แฮ้ง ชีด ศิษย์เอก อือนา เปิ่ง ปี่ ชี. ยา นี้แม้แน จี่ แง, “ยู้ จฺ่า ปาว นี้ย่า กงา อางโต ย่าง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ยาว พระเยซู มือ อ่างู่น แต่ค่า ล้างก้อก แฮ้ง กอ ท่าม แล่ชี่. แน พาจาว มางนา ขอบคุณ ฮา ชี. ยาว ศิษย์ อือนา ปี่ ต้าง ปี่ชี่. ยาว ศิษย์ คาโคลาโค อืม ล้างก้อก โย้เวอ อ่างู่น แต่ค่า อางแน้ แฮ้ง ต้าง คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “นี้ย่า กงา ซฺี่ เซฺ่อ อ่อก ล้า ปี่ง ย้าง ย้า, ไม้ ชฺ้าง อางบย่า อือนา อางบล่าบ ปล่องปูน ปี่ง แนนอ. แน ซฺี่ นี้ย่า พาจาว มาง ก่ามค่าน อางซฺื่อ โย้เวอ อางช่า ย่าง ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","กงา อางเลิ่ง ม้าม้า แฮ้ง ม่า แบ ปี่ ล่าว่า, กงา อ่างู่น แต่ค่า บ่าต่าง แล่ก้าน. แฮ้นืง เคิน เมินญา กงา อ่างู่น แต่ค่า ทื่อเทอ ต้าง แล่แง. แน แฮ้นืง พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ อางนืง ย้าง ย้าเป” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ยาว ยองมู นี้ง สรรเสริญ เพ่ง ย่าง ฮ้าว เปิน คู เมอ, มะกอกเทศ ตาแซ้ โย้เวอ ซฺื่ยกา แลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","พระเยซู ศิษย์ อือนา นี้แม้แน จี่ช่าง ชี, “นองมู คาโคลาโค นี้ย่า กงานา วี ล่า คูแง, ไม้ พระคัมภีร์ เวอ นี้แม้แน มอ ยาว แต้ม ชี ป้าน่อ, ‘พาจาว ม้า แกะ ปอฮู มางนา แซ่ แง. แน แกะ อือย่า กามางกาต่อง กามางกาตี่ แน ฮื่น แอ คูแง’ แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“จ้า กงา ซฺี้ ยาว แต่ล้าน แล่ เมอ, กงา นอง ฮู่ เวอ กาลิลี แควน โย้เวอ แล ลางออน ฮา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","จ้า เปโตร มือ พระเยซู นา นี้แม้แน ม่า ชี, “ฮาก นางนา วี ล่าโค เวิม มือ กงาย่า นางนา บ่าวี ล่า!” ");
INSERT INTO bzi_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ยาว พระเยซู มือ เปโตร นา ม่า ชี นี้แม้แน, “กงา อางเลิ่ง ม้าม้า ม่า แบ ปี่ ล่าว่า, มี้คี่ ยาพ่า ครั้งที่ 2 บ่าตานฮู่ เวอ นาย่า กงานา บ่าแบ่ล่ากงา กา แน 3 เทอ จี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","จ้า เปโตร มือ พระเยซู นา ปีนแตปีนนา ย้า นี้แม้แน ม่า ชี, “อ่าจาน เวอ, กงานา นางก้อง ทื่งกง่า แน กงาซฺี้ ปี่ ล่าเวิม, จ้า กงา บ่าจี่ นางนา บ่าแบล่ากงา กา” แน. ยาว ศิษย์ ทื่อบ่า อือ คาตา ย้า แฮ้แม้แน จี่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ยาว พระเยซู แน ศิษย์ อืม เกทเสมนี โซน โย้เวอ เคิน แล คูชี. พระเยซู มือ ศิษย์ อือนา นี้แม้แน ม่า ชี, “นอ นู้จา คู โว เป กงาย่า แฮ้กย้า อธิษฐาน ฮา แล ปานา” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ยาว พระเยซู มือ แลน ชี. แน ยา เปโตร, ยากอบ แน ยอห์น ยองนา คาตา แน ซฺื่ยแลน ชี. ยาว พระเยซู มือ นืงบาต่องบ่าม่อนบ่าซ่า เย. แน ยา นาบาตา ย้า นืงบาต่องลาบ้าบ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","แฮ้งย้า ยาง เปโตร, ยากอบ แน ยอห์น ยองนา นี้แม้แน ม่า ชี, “กงาย่า นืงบาต่องลาบ้าบ ชา ซฺี้ ย้าง ญา จา แง. นอง นู้เวอ กงานา ล่อ ดื้ง ล่าโว! บ่ายู่ คูโจ เป!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ยาว พระเยซู มือ อ่าล่อ อางอี้ เว่อ แน ย่อ อ่อก แลน ชี. ยาว ยาง มือ อางตู่ บอก ดื้ง ชี, ยาง แมก่า แฮ้ง นื้งชฺ่า โย้เวอ คี แอ เคอ ย้า. ยาว ยาง นี้แม้แน อธิษฐาน ฮา ชี. อางเพล่อ กงา กาแน ยาว, ยางนา อางตูกอางพาน อางญ่าม นี้ง กงาปูน ปี่ ปาว แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ยา นี้แม้แน จี่ แง, “อ่าโบ้งพาจาว เวอ, นา กูย่างกูเจ้อ ย้า ฮา เพล่อ ปี่ กงากา แง. อางตูกอางพาน ล้างก้อก นี้ง กงาก้อง ยู้ แลน ปาว. จ้า บ้าเจอล้อแม้เวิม กงา นืงบาจาบวา แน บ่าปี่ เพล่อ โจ. จ้า นาง นืงบาจาบวา แน เพล่อ ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ยาว พระเยซู มือ ย่อ พ่าว ล้าน แล่ชี่. แน ยาง มย้าง ชี ยาง ศิษย์ 3 คู่น อือย่า ยู่น ชีแน. แฮ้งย้า ยาง เปโตร นา นี้แม้แน จี่ช่าง ชี, “เปโตร เวอ, ยู่ แล่ง ลา? ทานล้า โว! นาย่า ทานล้า ยาว กงานา ทื่อชั่วโมง อางช่าง ดื้ง ช่าง ล่า บ่ากงา ลา? ");
INSERT INTO bzi_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","แม่น แน อางโต แล่ม แล่ โว! แน อธิษฐาน ฮา โว! ไม้ อ่าซ่าง มางนา นางนา บ่าปี่ จ้อบ อางบล่าบ ฮา ปี่ ล่า แนนอ. นืงบา นี้ง อางเลิ่ง อางกง่าอางเกิง ฮา ซี้ เวิม, จ้า อางโต นี้ย่า อางด่ออางย่า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ยาว พระเยซู มือ ย่อ แล ทื่อเทอ อธิษฐาน ฮา แล แล่ชี่. แน ยาง อางอ้าน แฮ้งแม้แน ย้า จี่ แล่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ยาว พระเยซู ย่อ พ่าวล้าน แล่ เมอ มย้าง ชี, ยาง ศิษย์ อือ ยู่น ชีแน. ยองมู นี้ย่า แมนือแมคอ ฮ่าน แมนือ บ่าพอง ล้าตอ กา. แน ยอ บ่าแบ เย พระเยซู นา บ้าเจอ จี่ช่าง วา แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ยาว พระเยซู มือ ครั้งที่ 3 ย่อ พ่าวล้า ศิษย์ อือนา ฮูน ล้า แล่ชี่. แน ยาง ยองนา นี้แม้แน จี่ช่าง ชี, “นองมู นี้ย่า ยู่ ซ่าวดื้ง แล่ คูง ลา? กงา คางญ้า! ชฺ้าง กงานา บ่าแม่น ฮา ล่าง มาง, กงาชฺ้างอางย่า เพล่อ ชี นี้มางนา, ชู ชฺ้าง อางบล่าบ อือนา ปี่ ย้าง อางญ่าม เคิน ญ้า. ");
INSERT INTO bzi_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ทานล้า ปาว เอ้ว! โฮก! ชฺ้าง กงานา บ่าแม่น ฮา ล่าง มาง เคิน ล้าง ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","พระเยซู จี่ ย้าง บ่าลีน กื้ง ยูดาส เคิน ล้า ชี. ยา ศิษย์เอก 12 คู่น โย้เวอ ชฺ้าง ทื่อม่าง มาง ย้า. แน ยา ชฺ้าง อางอีบ่าอ่า ซฺื่ยล้าน ชี. ยองมู นี้ย่า มยา แน ตู้ลู้ง ท่าม ล้าน คูชี. ชฺ้าง ยองนา ซฺา ล้า ปี่ชี่ อือย่า ปุโรหิต ยอคา อือ, อางลี้บอางล่าว ม่าอู่บฮู อือ แน ยิวชฺ้าง ยอคา อือ ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ยูดาส มือ ยองนา อางด่า เวอ นี้แม้แน ม่า ชี ลางออน ฮา ชี, “กงา อ่าซ่าง นา ป่าปา น่าม แล แง, นอง ชฺ้าง แฮ้มางนา ชู แอน โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ยูดาส เคิน ล้า เมอ ยาง พระเยซู นา ย่อ อ้อง ซฺ้า แล ชี. แน ยาง พระเยซู นา นี้แม้แน จี่ช่าง ชี, “อ่าจาน เวอ” แน. ยาว พระเยซู นา ป่าปา เวอ น่าม ชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ยาว ชฺ้าง แฮ้อืม พระเยซู นา อ้อง ชู ล้า คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","พระเยซู อางมู โย้เวอ ชฺ้าง ทื่อม่าง จา แง. ยา พระเยซู ก้อง แท้ แน จูง ชี. ยา ค่าตอง มยาทาง แฮ้ง ชอด อ่อก ล้า ปี่ ยาว, ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น ม่าง ย่าเจ่น ม่าง น่าซื่ง เวอ แจ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","แฮ้งย้า พระเยซู มือ ชฺ้าง แฮ้อือนา นี้แม้แน จี่ช่าง ชี, “นอง มยาทาง แน ตู้ลู้ง ท้าม ล้า ยาว กงานา ชู ล้าล่า คูชี นี้ย่า, ไม้ นอ กงานา ค่าโม่ยค่ามโจน แน เย้ง ล่างลา? ");
INSERT INTO bzi_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","นอย่า กงา โบสถ์อางฮื่อ โย้เวอ ม่าอู่บ ดื้ง นา กูนืง ย้า มย้าง ล่าแง. จ้า นอ กงานา บ่าชู ล่า. จ้า กูย่างกูเจ้อ นี้ย่า พาจาวจี่ต่างจี่แต่นฮู อือ มอ ยาว, พระคัมภีร์ เวอ แต้ม ชี ชี แฮ้งแม้แน ย้า กงาเพล่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ยาว พระเยซู ศิษย์ คาโคลาโค อืม พระเยซู นา วี คูชี, ไม้ ยองมู นี้ย่า แค ฮื่น คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ย่าค่า ทื่อม่าง จา แง. พระเยซู ก้อง เค่ ล้าน ชี. ยา พ้าต้อง ทื่อพื่น ญา ป้าน แล่ชี่. ชฺ้าง แฮ้อืม ยางนา ชา ชู คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","จ้า ยอ ยางนา บ่าชู กงากา. ยอ ยาง พ้าต้อง แฮ้งนา แอ่น ญา ชู กงา ชี. ยาว ยาง ต่องจ่อนซฺ่าง ย้า ฮื่น แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ยาว ยองมู แฮ้ง พระเยซู นา ซฺื่ย ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มางนา ซฺ้าแอ ชี. แฮ้ญ่ามเมอ ปุโรหิต ยอคา อือ, ยิวชฺ้าง ยอคา อือ, แน อางลี้บอางล่าว ม่าอู่บฮู อือ, ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง ยู้ม โย้เวอ ช้อน ลางกา ชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","เปโตร พระเยซู ก้อง เว่อเว่อ แน เค่แอน ชี. แน ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น ม่าง ยู้ม กองโค้ง โย้เวอ อ้องแลน ชี. แน ชฺ้างยู้มล่อฮู อือก้อง ทื่งกง่า แน บี่ท่อ ปย่าว ดื้ง แอ ชี, ไม้ ยาง อางโต แฮ้งนา บ่าปี่ ช่อจือ แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ปุโรหิต ยอคา อือ แน สภาแซนฮีดริน อางมู คาโคลาโค อืม, ปีนแตปีนนา ย้า พี่ญ่าน ซฺ้า พระเยซู นา จี่ ปี่ชี่ อางซี ฮา ชี แน, ไม้ อางเลิ่ง ซฺ้า พระเยซู นา แซ่ แนนอ. จ้า อางซี บ่าซฺ่า กงากา. ");
INSERT INTO bzi_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ชฺ้าง อางอีบ่าอ่า พี่ญ่าน เพล่อ ชี, จ้า ยองมู นี้ย่า พี่ญ่านม้าม้าบ่าอ่า แน ยอง จี่ นี้ย่า บ่าตู่ กา. ");
INSERT INTO bzi_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ยาว ชฺ้าง ทื่อบ่า จา แง, ทา จูง ล้า ยาว พี่ญ่าน เพล่อ อางเลิ่ง ม้าม้าบ่าอ่า อือ จี่ ชี. ยอ พระเยซู อางซี ฮา ชี แน จี่ แง. แน นี้แม้แน จี่ ชี, ");
INSERT INTO bzi_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“กงู พระเยซู จี่ แฮ้ง กงากย่า แอ. ยา นี้แม้แน จี่ แง, ‘กงา โบสถ์อางฮื่อ ชฺ้าง แต่ง ชี แฮ้ง พยา แง. ยาว กงา 3 นืง นู้เวอ โบสถ์อางฮื่อ อางซฺื่อ แต่ง แล่ง. โบสถ์อางฮื่อ อางซฺื่อ นี้ย่า ชฺ้าง บ่ากงา แต่ง เป’” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","จ้า พี่ญ่าน อือ นี้เลิ่ง จี่ นี้ย่า บ่าตู่ กา. ");
INSERT INTO bzi_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","แฮ้งย้า ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง ชฺ้าง อางบย่า ล้าก้า โย้เวอ ทาจูง ล้า ชี. แน พระเยซู นา นี้แม้แน น้าน ชี, “ยอ นางนา อางซี ฮา ชี แน จี่ ล่าง. ท้าว นา เจิ้นเจ้อ บ่าจี่ ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","จ้า พระเยซู มือ กยาบ ชี. ยา เจิ้นเจ้อ บ่าจี่. แฮ้งย้า ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง พระเยซู นา นี้แม้แน น้าน ชี, “นา พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ปี่ชี่ มาง ลา? แน นา พาจาว กงู สรรเสริญ ฮา แฮ้มาง อางย่า ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","แฮ้งย้า พระเยซู มือ นี้แม้แน พอ ชี, “โอ่ย อางอ้า ย้า. แน จ้างจ้าง โย้เวอ นองมู นี้ย่า กงาชฺ้างอางย่า เพล่อ ชี นี้ มางนา กงามย้าง ล่าแง. กงาย่า พาจาว อางฮื่อ เลิ่นเลิ่น มาง ล่าปู่ ล่าม่า ป่ากย่า ดื้ง แง. แน มู่งท่า เวอ มู่งบื่น อางป่อน อือก้อง ทื่งกง่า แน ลือ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ยาว ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มางมือ นืงบาค่า ชีเย. ยาว ยาง ค่าลาวอางเง้โลบแล่เซฺ่อ แฮ้ง ชีดล่าก แล่ยาว จี่ ชี นี้แม้แน, “ยา พาจาว มางนา ม้าม้า ย้า จี่ฮูย้า แง, กงู พี่ญ่าน บ่าซฺ่า กานโจ. ");
INSERT INTO bzi_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ฮู ปาว นอ จี่ต่าง ฮูย้า แฮ้งนา กงากย่า คูงญา, นอย่า ล้อแม้แน เย้ง คูแง?” แน. ยาว ยอง มือ พอ คูง เย นี้แม้แน, “ยาง อางซี นี้ย่า ซฺี้ ก้อม้อก ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ยาว ชฺ้าง ทื่อบ่า อืม พระเยซู นา ค่านล่าง พี่ด กาน ชี. แน ชฺ้าง ทื่อบ่า อือย่า พระเยซู แมนือ โย้เวอ พ้า ฮี่ด ชี. แน พระเยซู นา ตื่อ ชี. ยาว ยอง พระเยซู นา นี้แม้แน จี่ ฮูย้า น้า คูชี, “ม่าล่าว แล นางนา อ่าซ่าง ตื่อ ล่าชี่” แน. ยาว ตาฮ้าน โบสถ์ล่อฮู อืม พระเยซู นา ซฺื่ย ตื่ย แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","เปโตร ยู้ม กองโค้ง โย้เวอ จา เมอ, ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง ย่าบี่ย่าเจ่น ทื่อม่าง มาง ย่อ ไก้ ล้าน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ยาว ยาง เปโตร บี่ท่อ ปย่าว ดื้ง จา นา มย้าง ชี. แฮ้งย้า แท้ แน อ้อง ฮูน แล ชี. แน ยาง เปโตร นา นี้แม้แน จี่ช่าง ชี, “นา เยซู นาซาเร็ธชฺ้าง มาง ก้อง ทื่งกง่า ดื้ง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","จ้า เปโตร มือ นี้แม้แน พอ ชี, “กงา บ่าแบ นอ, นา บ้าเจอ อางเลิ่ง จี่ แง” แน. ยาว เปโตร มือ ล้องก้อ ยู้ม อ้องแล ป่ากย่า ย่อ แลน ชี. ยาว ยาต้าน ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ยาว ย่าบี่ย่าเจ่น แฮ้มาง เปโตร นา มย้าง แล่ เมอ, ยาง มือ ชฺ้าง ยางก้อง แท้ แน จูง ชี อือนา นี้แม้แน จี่ช่าง ชี, “ยา เยซู อางมู เวอ ชฺ้าง ทื่อม่าง มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","เปโตร มือ ม่า ชี, ยา พระเยซู นา บ่าแบกงากา แน. ทื่อชี่ด ยาว ชฺ้าง โย้เวอ จูง จา อืม เปโตร นา นี้แม้แน จี่ช่าง ชี, “นา เยซู อางมู โย้เวอ ชฺ้าง ทื่อม่าง มาง ม้าม้า ย้า, ไม้ นา กาลิลี แควน เวอ จายล้า แง พระเยซู อางมู อือ แม้แน ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ยาว เปโตร มือ นี้แม้แน จี่ ชี, “กงา สาบาน ฮา เวิม อางกงา ย้า กงา จี่ นี้ย่า อางเลิ่ง ม้าม้า แน. จาว่าแน กงา จี่ นี้ง อางเลิ่ง ม้าม้า บ่าอ่ายาว, พาจาว มางนา กงานา วี่บ่ากไจ ปี่ ล่าว. กงาย่า ชฺ้าง นอง จี่ เคอ แฮ้มางนา บ่าแบกงา กา!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","แฮ้ญ่ามเมอ ยา ครั้งที่ 2 ต้าน ชี. ยาว เปโตร มือ พระเยซู จี่ต่าง แฮ้งนา ปื้อซฺ้า ชี. พระเยซู ยางนา นี้แม้แน ม่า ชี, “ยาพ่า ครั้งที่ 2 ชา ต้าน เมอ, นา 3 เทอ จี่ แง, กงานา บ่าแบล่ากงา กา” แน. ยาว เปโตร มือ นืงบาชู่ม อู้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ซอทา แปล้น ล้า ยาว ปุโรหิต ยอคา อือ, ยิวชฺ้าง ยอคา อือ, อางลี้บอางล่าว ม่าอู่บฮู อือ, แน สภาแซนฮีดริน ชฺ้าง อืม ปล่องเย่ง ลางกา ชี, พระเยซู นา บ้าเจอล้อแม้ ฮา แงแน. ยองมู นี้ย่า พระเยซู นา พือ ยาว ผู้ว่า ปีลาต ก้อง ซฺื่ยแลน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ผู้ว่า ปีลาต มือ พระเยซู นา นี้แม้แน น้า ชี, “นา ยิวชฺ้าง อือ ก่าซ้าด ลา?” แน. พระเยซู มือ นี้แม้แน พอ ชี, “โอ่ย! อางอ้า ย้า นาง จี่ นี้ย่า อางกง่า ย้าเป” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ปุโรหิต ยอคา อือย่า จี่ คูง, พระเยซู อางเลิ่ง อางซี ไล เลิ่ง ย้า ฮา ชีแน. ");
INSERT INTO bzi_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","แฮ้งย้า ผู้ว่า ปีลาต มือ พระเยซู นา นี้แม้แน น้าน แล่ชี่, “นา เจิ้นเจ้อ บ่าจี่ ลา? นาง อางมย้าง ย้า อ่าลา, ยองมู นี้ย่า จี่ คูง นา อางเลิ่ง อางซี ไลเลิ่ง ย้า ฮา ชี?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","จ้า พระเยซู มือ กยาบ ชี, ยา เจิ้นเจ้อ บ่าจี่ แล่. ยาวนี้ย่า ผู้ว่า ปีลาต นา ฮา นาบาตา ย้า นืงบาม่าน ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ปัสกาป่อยนืง โย้เวอ อางลี้บอางล่าว จา เย. นักโทษ อือนา กาปี กามาง กา แน ตอ แงแน. นี้ย่า ผู้ว่า ปีลาต อางลี้บอางล่าว แต่งล้า ชีย้าง. นี้งย้า ผู้ว่า ปีลาต ค่องช่าง อือนา ชฺ้าง อางซี ฮา ชี อือนา ทื่อม่าง แช้ ตอ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","แฮ้ญ่ามเมอ ค่าพ่าย่า ทื่อม่าง จา แง. ยาง อางเม้ง บารับบัส แน. ยางนา ชฺ้าง อางเมิง โย้เวอ อางเลิ่ง อางซืกอางซาก ฮา ตอ ล้า ปี่ชี่ อือ ก้อง ทื่งกง่า แน คอก ล้อง ชี, ไม้ ยองมู นี้ย่า ยอง อางเลิ่ง อางซืกอางซาก ฮา ตอ ล้า ปี่ เมอ ชฺ้าง อือนา แซ่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","แฮ้งย้า ค่องช่าง อืม ผู้ว่า ปีลาต นา ซฺ้า ล้า คูชี. แน ยางนา ป้า นักโทษ ทื่อม่าง ตอ ปี่ชี่, ยอง ฮา ล้า คูชี แฮ้งแม้แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ผู้ว่า ปีลาต มือ ค่องช่าง อือนา นี้แม้แน น้าน ชี, “นองมู นี้ย่า กงานา ยิวชฺ้าง อือ ก่าซ้าด มางนา อางตอ ปี่ล่าซี่ ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ยาง นี้แม้ จี่ นี้ย่า, ไม้ ผู้ว่า ปีลาต อางแบ เย, ปุโรหิต ยอคา แน ยิวชฺ้าง ยอคา อือ, พระเยซู นา ซฺื่ยล้า ชี แฮ้ย่า, พระเยซู นา เจอค้อย แฮ้ง ปาปาย แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","จ้า ปุโรหิต ยอคา อืม ค่องช่าง อือนา นี้แม้แน จี่ซ้อ คูชี, ผู้ว่า ปีลาต นา ป้า บารับบัส นา ตอ ปี่ว แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","แฮ้งย้า ผู้ว่า ปีลาต มือ ค่องช่าง อือนา ทื่อเทอ นี้แม้แน น้า แล่ชี่, “นี้แม้แนยาว นองมู นี้ย่า กงานา นอง ยิวชฺ้าง อือ ก่าซ้าด แน ฮ้าว นี้มางนา บ้าเจอล้อแม้ ฮา ปี่ ล่าแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ค่องช่าง อืม นี้แม้แน จี่ โฮ้ก คูชี, “ไม้กางเขน ท่า โย้เวอ แซ่ โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","จ้า ผู้ว่า ปีลาต มือ ยองนา นี้แม้แน น้าน ชี, “ยา บ้าเจอ อางซี ฮา ชี?” แน. จ้า ค่องช่าง อืม อางอ้าน แฮ้ง ล่อบ่าปา อางเซง บื้ง แน จี่ โฮ้ก คูชี. ยอ นี้แม้แน จี่ โฮ้ก ชี, “ไม้กางเขน ท่า โย้เวอ แซ่ โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ผู้ว่า ปีลาต ค่องช่าง อือนา นืงบาจาบ ปี่ ซี่ง เย. แฮ้งย้า ยาง มือ บารับบัส นา ตอ ชี. แน ยาง ตาฮ้าน อือนา ม่า ซ้าดอางคอล่าตื่อ ซฺ้าม กอเล อางแล้ม ตีด ชี แฮ้ง ไจ พระเยซู นา ชืก ปี่ชี่. ตื่อชืก เปิน ยาว น่อง โย้เวอ ไม้กางเขน ท่า โย้เวอ แซ่ เย. ");
INSERT INTO bzi_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ยาว ตาฮ้าน อืม พระเยซู นา ศาลปรีโทเรียม โย้เวอ ซฺื่ยแลน คูชี. ศาลปรีโทเรียม นี้ย่า ผู้ว่า ม่าง ยู้ม กองโค้ง โย้เวอ จา แง. ยาว ยองมู แฮ้ง โย้เวอ ตาฮ้าน คาโคลาโค จา อือนา ฮ้าวล้า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ยาว ยองมู แฮ้ง ก่าซ้าด ค่าลาวอางเง้โลบแล่เซฺ่อ สีม่วง แฮ้ง พระเยซู นา ตูม ปี่ชี่. แน ล่างาม จี่กู่ อางจา แฮ้ง มงกุฎ เจ่อ ยาว พระเยซู อางตู่ โย้เวอ ช่อง ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ยาว ยองมู แฮ้ง พระเยซู นา ป่าลาลาบ่อ คูชี, ยองมู นี้ย่า พระเยซู นา อางตู่ บอก ปี่ คูชี, แน นี้แม้แน จี่ คูชี, “ยิวชฺ้าง อือ ก่าซ้าด มาง เวอ, จาบื่อดื้งบื้อ แน จาดื้ง แล โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ยาว ยองมู แฮ้ง ไมออ แฮ้ง พระเยซู อางตู่ โย้เวอ ตื่อ ชี. แน พระเยซู นา ค่านล่าง พี่ด กาน ป่าตูคู บอกไว้ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ตาฮ้าน อือ พระเยซู นา ป่าลาลาบ่อ ม่อน ก่อ แล่ คู เมอ, ยอง พระเยซู นา ก่าซ้าด ค่าลาวอางเง้โลบแล่เซฺ่อ สีม่วง แฮ้ง แล อ่อก ปี่ชี่. ยาว พระเยซู อางก่าอางตูม แฮ้ง ยางนา อางอ้าน แฮ้งแม้แน ก่าตูม แล่ ปี่ชี่. ยาว ยองมู แฮ้ง พระเยซู นา ซฺื่ย อ่อก แลน คูชี, ไม้ พระเยซู นา ไม้กางเขน ท่า โย้เวอ แซ่ แล แง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ตาฮ้าน อือ พระเยซู นา แก้บ้า ย่อ ซฺื่ยแล เมอ, ค่าพ่าย่า ทื่อม่าง นา มย้าง ชี. ยาง อางเม้ง ซีโมน แน, ยา ไซรีน อางเมิง ชฺ้าง. ยา อเล็กซานเดอร์ แน รูฟัส เย่ด อางโบ้ง. แฮ้ญ่าม เมอ ยา อางเมิง คล้าว โย้เวอ ชา ย่อ อ้องแล แง. แฮ้งย้า ตาฮ้าน อืม ยางนา เค้ พระเยซู ไม้กางเขน แฮ้ง ป่า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ยาว ยองมู แฮ้ง พระเยซู นา ซฺื่ย นื้งชฺ่าตี กลโกธา โย้เวอ เคิน แล ชี. กลโกธา นี้ย่า อางตู่ตู่คย่าม ตาแซ้ นา ฮา แง. ");
INSERT INTO bzi_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ยาว ตาฮ้าน อืม อ่างู่น แต่ค่า แฮ้ง มดยอบ ซูน ยาว, พระเยซู นา ต้าง ปี่ชี่. จ้า พระเยซู มือ บ่าต่าง. ");
INSERT INTO bzi_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ยาว ยองมู แฮ้ง พระเยซู นา ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด ชี. แน พระเยซู อางก่าอางตูม แฮ้ง เบอจอก เปิ่ง ลางกา ชี. ");
INSERT INTO bzi_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ตาฮ้าน อือ พระเยซู นา ไม้กางเขน ท่า เวอ ตื่อตี้ด เมอ, ซอทา 9 โมง เย. ");
INSERT INTO bzi_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","พระเยซู อางซี แฮ้ ล่าไม แป้น นี้แม้แน แต้ม ชี ชี, “ยิวชฺ้าง อือ ก่าซ้าด” แน. ยาว ล่าไม แป้น แฮ้ง ไม้กางเขน ท่า โย้เวอ ตื่อตีด ชี. ");
INSERT INTO bzi_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ค่าโม่ยค่ามโจน 2 คู่น จา แง. ตาฮ้าน อือย่า เย่ดนา ไม้กางเขน ท่า เวอ ตื่อตี้ด ชี. แน พระเยซู ก่องทาง โย้เวอ ดื้ง ปี่ชี่, ล่าซ่าย ป่ากย่า ทื่อม่าง แน, ล่าม่า ป่ากย่า ทื่อม่าง แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ยาว นี้ย่า พระคัมภีร์ เวอ มอ ชี ชี แฮ้งแม้แน ม้าม้า ย้า เพลิ่น ชี. พระคัมภีร์ โย้เวอ นี้แม้แน มอ ชี ชี, “ยองมู นี้ย่า จี่วีดอางซื้ง มางนา ชู ค่าโม่ยค่ามโจน อือก้อง ทื่งกง่า แน ดื้ง ปี่ชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ค่องช่าง ย่อ ไก้ กว่า คูง อืม อางตู่ วืด พล่อย ย้า. แน ยอง พระเยซู นา นี้แม้แน จี่ ฮูย้า คูชี, “ฮื้อ! บ้าเจอล้อแม้ จา แง. นา โบสถ์อางฮื่อ แฮ้ง พยา ยาว, 3 นืง นู้เวอ อางซฺื่อ แต่ง แล่ง อ่าลา. ");
INSERT INTO bzi_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","อามื้อ ค่าตอง นา ปล่อง จ่าแล่ ปาโน. แน ไม้กางเขน ท่า เวอ จาย ลู่งลือ โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ปุโรหิต ยอคา อือ แน อางลี้บอางล่าว ม่าอู่บฮู อืม พระเยซู นา อื้อ ฮูย้า คูชี. ยองมู นี้ย่า นี้แม้แน จี่ กาแง, “ยา ฮากนา อางปล่อง กงา กา. จ้า ค่าตอง นา บ่าปล่อง จ่าแล่ กงา กา. ");
INSERT INTO bzi_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","จาว่าแน ยา พาจาว มาง แช้ยู้ ยิวชฺ้าง อือ ก่าซ้าด เพล่อ ปี่ ชี่ มาง ม้าม้า แนยาว, ค่าตอง ไม้กางเขน ท่า เวอ จา แฮ้ง ปล่อง แล่ยาว, ลู่งลือ กงา ยาว กงูม มือ ยางนา เจ่อจ่า คูแน” แน. ค่าโม่ยค่ามโจน พระเยซู ก่องทาง เวอ ไม้กางเขน ท่า ตื่อตี้ด ชี แฮ้ เย่ด คาตา ย้า พระเยซู นา จี่ ฮูย้า ชี. ");
INSERT INTO bzi_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ยาว ชฺ้างอางเมิง คาโคลาโค โย้เวอ 12 โมง นืงก้อง เวอ จาย 3 โมง เวอ เคอ นี้ย่า วื้งว้าง โค ชี. ");
INSERT INTO bzi_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","3 โมง มู่งคี่ล้าก้า เคิน เมอ พระเยซู มือ นี้แม้แน จี่ โฮ้ก ชี, “เอโลอี เอโลอี ลามา สะบักธานี!” แน. นี้แม้แน แปล แง, “พาจาว เวอ, พาจาว เวอ, บ้าเจอฮาย กงานา วี ล่าแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ค่องช่าง แท้ แน จูง ฮู คูชี อือ กงากย่า เมอ, ยอง นี้แม้แน จี่ ลางกา ชี, “น้า แล้, ยา พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ นา ฮ้าว แง” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ค่าพ่าย่า ทื่อม่าง จา แง. ฮื่น แอ อู่ไต่ แฮ้ง ล่าไม ตู่ตีน โย้เวอ ชอก ยาว, อ่างู่น แต่ค่า อางเช้น โย้เวอ ตือ ยาว, พระเยซู นา ต้าง ปี่ชี่. ยาว ยาง พระเยซู นา นี้แม้แน จี่ ฮูย้า ชี, “กงา ล่อ ฮู แน เอลียาห์ เยซู นา ไม้กางเขน อางซฺื่ย ลู่ง ลือ ล่า!” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","พระเยซู มือ จี่โฮ้ก ยาว อางซ่า แช ซฺี้น ชี. ");
INSERT INTO bzi_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","แฮ้ญ่ามเมอ โบสถ์อางฮื่อ อางฮ้อง อางเซฺิ่งอางซฺ้าง ล้องก้อ โย้เวอ พ้า เทิง ชี ชีย้าง 2 พื้น แน ชีดอ่อก ล้า ชี. พ้า ชีด ชี แฮ้ย่า อางท่า จาย อางอ่อก เคอ แน ชีด ลู่งลืน ชี. ");
INSERT INTO bzi_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ตาฮ้าน นายร้อย ทื่อม่าง พระเยซู ก้อง แท้ แน จูง ฮู ชี มาง พระเยซู ซฺี้ ชี แฮ้งนา กงามย้าง เมอ, ยาง นี้แม้แน จี่ ชี, “ค่าพ่าย่า นี้ม้า พาจาวอางย่า ม้าม้า ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ค่าบาย่า ทื่อมู จา แง. เว่อ แน จูง ฮูน คูชี. ค่าบาย่า อางมู โย้เวอ มารีย์ มักดาลาชฺ้าง มาง, สะโลเม, มารีย์ ยากอบ อางอี แน โยเสส เย่ด อางบา มาง คาตา ย้า จา แง. ");
INSERT INTO bzi_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ค่าบาย่า นี้อือ พระเยซู นา เค่ ฮูพลา ล่ากาน ปล่อง ว่า คูแง, พระเยซู กาลิลี แควน โย้เวอ จา เมอ ย้า. แน ค่าบาย่า อางมู โย้เวอ ชฺ้าง ทื่อบ่า พระเยซู นา เค่ เยรูซาเล็ม อางเมิง เวอ แล คูชี อือ คาตา ย้า จา แง. ");
INSERT INTO bzi_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","โยเซฟ อาริมาเธีย ชฺ้าง, ยา สภาแซนฮีดริน ชฺ้าง อือ อางมู เวอ ชฺ้าง ทื่อม่าง มาง ย้า. แน ยางนา ค่องช่าง นาบทื้อ แง. ยา พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ แฮ้นืง นา ล่อ แง. ยา ผู้ว่า ปีลาต นา ซฺ้า แลง แฮ้งนา บ่าแค. มู่งคี่ล้าก้า โย้เวอ โยเซฟ มือ ผู้ว่า ปีลาต ก้อง แล พระเยซู ศพ ย่าง ป้า แล ชี, ไม้ นี้เซฺ้อ ยิวชฺ้าง อือ ลองนืง นอ. ");
INSERT INTO bzi_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ผู้ว่า ปีลาต มือ พระเยซู ซฺี้น ชี แน แบ ยาว นืงบาม่าน ชี, พระเยซู บ้าเจอฮาย ซฺี้ ไว่ กาทืง แงแน. แฮ้งย้า ตาฮ้าน นายร้อย มางนา ฮ้าว ล้า ปี่ ยาว น้าน ชี พระเยซู ซฺี้ มล่าง กาชา ล่าแน. ");
INSERT INTO bzi_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ยาว ตาฮ้าน นายร้อย มาง มือ พระเยซู ซฺี้ ชี อางเลิ่ง แฮ้ง ผู้ว่า ปีลาต นา อู่บน้า ปี่ชี่. แฮ้งย้า ผู้ว่า ปีลาต มือ โยเซฟ นา พระเยซู ศพ ย่าง ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ยาว โยเซฟ มือ พ้า อางป่อน อางฮู่ อางคา อือ วื้อ แอ ชี. แน ไม้กางเขน ท่า เวอ พระเยซู ศพ แฮ้ง ยู้ อ่อก ยาว พ้า อางป่อน แฮ้ง ป้าน ชี. ยาว ท้ามชฺ้างซฺี้ชีย้า โย้เวอ กอย ชี ชี. ยาว ท้าม อ้องย้า โย้เวอ ลอบา อางฮื่อ ย่าง พี่ ชี ชี. ");
INSERT INTO bzi_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ยาว มารีย์ มักดาลาชฺ้าง แน มารีย์ โยเสส อางบา มาง เย่ด กงามย้าง ชี, โยเซฟ พระเยซู ศพ แฮ้ บ้าเจอล้อเกิ้ง ชี ชีแน. ");
INSERT INTO bzi_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","น่อง โย้เวอ ยิวชฺ้าง อือ ลองนืง ย้าง ปูน ยาว, มารีย์ มักดาลาชฺ้าง, สะโลเม แน มารีย์ ยากอบ อางบา มาง, อางเกิ่งอางฮ้อม ย้าง วื้อ คูชี, ไม้ พระเยซู อางโต โย้เวอ พ่อ แง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ว่านตีด ซอทา เวอ มู่งนื่ง มาง อ่อก ล้าน ยาว, ยองมู แฮ้ง ท้ามชฺ้างซฺี้ชีย้า โย้เวอ แลน คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","แก้บ้า ย่อแล เมอ ยองมู แฮ้ง นี้แม้แน น้าท้าม ลางกา ชี, “ท้าม อ้องย้า โย้เวอ ลอบา อางฮื่อ พี่ ชี ชี แฮ้ย่า กงูนา อ่าซ่าง ปล่อง ต่าน อ่อก ล่าง?” แน. ");
INSERT INTO bzi_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ท้าม โย้เวอ เคิน แล เมอ, ยอง มย้าง คูชี ลอบา อางฮื่อ แฮ้ย่า ท้าม อ้องย้า โย้เวอ ล่าน อ่อก ชีแน. ");
INSERT INTO bzi_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","แฮ้งย้า ยอง มือ ท้ามชฺ้างซฺี้ชีย้า โย้เวอ อ้อง แลน คูชี. ยาว ยอง ย่าค่า ทื่อม่าง นา มย้าง ชี. ย่าค่า นี้ม้า เท่วาด่า เย. ยา ค่าลาวอางเง้โลบแล่เซฺ่อ อางป่อน ตูม แล่ชี่. แน ล่าม่า ป่ากย่า ดื้ง ชี. ยองมู แฮ้ง นาบาตา ย้า แคแล่ชี่. ");
INSERT INTO bzi_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ยาว เท่วาด่า แฮ้มาง นี้แม้แน จี่ ชี, “บ่าแค โจ นองมู นี้ย่า พระเยซู นาซาเร็ธชฺ้าง, ไม้กางเขน ท่า เวอ ซฺี้ ชี แฮ้มางนา ซฺ้า ล้า คูง ลา? ยา นู้เวอ บ่าดื่ง เป. ยา ซฺี้ ยาว แต่ล้าน แล่ง ญ้า. พระเยซู ศพ ชี ชี นู้เวอ ฮู ปาว. ");
INSERT INTO bzi_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","เปโตร แน พระเยซู ศิษย์ ทื่อบ่า อือนา นี้แม้แน ม่า แอ โว, ‘พระเยซู กาลิลี แควน โย้เวอ นอง ฮู่ แลน ล้าง ญ้า. นองมู นี้ย่า ยางนา โย้เวอ กงามย้าง คูแง. ยาง นองนา ม่า ชี ล่าชี่ แฮ้งแม้แน ย้า’” แน. ");
INSERT INTO bzi_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","จ้า ยองมู นี้ย่า บลื่งบล้าง แค ยืก คูชี. แฮ้งย้า อางไว่ แน ท้าม อางเง้ โย้เวอ ฮื่น อ่อกแอน คูชี. ยองมู นี้ย่า นาบาตา ย้า แค คูง อ่าซ่าง มางนา บ่าอู่บ น้า ปี่ จอ กา แอ เคอ ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ว่านตีด ซอทา อางด่า แฮ้นืง เวอ พระเยซู แต่ล้าน แล่ ยาว, ยาง มารีย์ มักดาลาชฺ้าง มางนา ฮากฮู่ เวอ มย้าง ปี่ชี่. มารีย์ นี้ม้า พระเยซู แด่ย่า 7 โต ก่าอ่อก ปี่ชี่ มาง ย้า. ");
INSERT INTO bzi_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ยาว มารีย์ มือ พระเยซู ศิษย์ อือนา ม่า แล ชี. แฮ้ญ่ามเมอ ยองมู นี้ย่า นืงบาต่อง ตูกพาน อู้งฮ้าว คูชี. ");
INSERT INTO bzi_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","มารีย์ ยองนา นี้แม้แน ม่า ชี. พระเยซู ซฺี้ ยาว แต่ล้าน แล่ง ญา, แน ยา พระเยซู นา กงามย้าง ญา แน. จ้า ยองมู นี้ย่า มารีย์ นา บ่าเจ่อ คู. ");
INSERT INTO bzi_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ยาว น่อง โย้เวอ พระเยซู มือ ยาง ศิษย์ 2 คู่น มาง เย่ดนา มย้าง ปี่ชี่. แฮ้ญ่ามเมอ เย่ด อางเมิง อางเง้ โย้เวอ ย่อ อ่อกแอ แง. ");
INSERT INTO bzi_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ยาว เย่ด อางไว่ ย้า พ่าว แล ศิษย์ ทื่อบ่า อือนา ม่า แล ชี. จ้า ยอ เย่ดนา บ่าเจ่อ คู. ");
INSERT INTO bzi_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ยาว พระเยซู มือ ยาง ศิษย์ 11 คู่น อือนา มย้าง ปี่ชี่. แฮ้ญ่าม เมอ ยองมู นี้ย่า ฮ่างจฺ่า ดื้ง คูแง. ยาว พระเยซู มือ ยองนา ชฺ้าง อางล้าน แน จี่ ชี, ไม้ ยองมู นี้ย่า ชฺ้าง แฮ้อือ จี่ต่าง แฮ้งนา บ่าเจ่อ คู. ชฺ้าง แฮ้อือ พระเยซู ซฺี้ ยาว แต่ล้า แล่ เมอ, ยางนา กงามย้าง คูชี อือ ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ยาว พระเยซู มือ ยองนา นี้แม้แน ม่าอู่บ ชี, “ชฺ้างอางเมิง นู้เวอ ต้าว แน อ่อกแอน โว, แน ชฺ้าง คาโคลาโค กูต่องกูตี่ เวอ ดื้ง คูชี อือนา อางเลิ่ง อางแม่น นี้ง ป่าว ม่า โว! ");
INSERT INTO bzi_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ชฺ้าง คาโคลาโค เจ่อ ยาว ล้างตือพิธีบัพติศมา ฮา แล่ คูชี อือย่า อางบล่าบ กงาปูน แล่ คูแง. จ้า พาจาว ม้า ต้าดต่อน ชฺ้าง คาโคลาโค บ่าเจ่อ อือนา วี่บ่ากไจ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ชฺ้าง เจ่อ คูชี อือย่า ล่าที่ จา แง. ยอง ล่าที่ แฮ้ย่า กงา อางเม้ง นี้ง จี่ เคอ เมอ, แด่ย่า อางก่า อ่อก กงา กา. แน จี่ต่างบ่ากย่ากางซื้ง อือ อางจี่ กงา กา. แน ยอ ล่าปู่ อางแอ่ แฮ้ง ไจ อื้อล้าง นา อางชู กงากา. ");
INSERT INTO bzi_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","แน ยอ จี่ก่า อางปีด อางจา อือ จฺ่า เมอ, เจิ้นเจ้อ บ่าไล่. แน ยอ ชฺ้าง อางด้า อือนา ล่าปู่ โบ้ย พ่าญาด อางยา โปยว ปี่ กงา กา” แน. ");
INSERT INTO bzi_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","น่อง โย้เวอ พระเยซู กงู จี่วีดอางซื้ง มาง ยาง ศิษย์ อือนา ม่าอู่บ เปิน ยาว, พาจาว มาง พระเยซู นา มู่งท่า โย้เวอ แล ปี่ ชีเย. แน พระเยซู มือ พาจาว มาง ล่าปู่ ล่าม่า ป่ากย่า ดื้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","แฮ้เมอ จาย ล้า ยาว พระเยซู ศิษย์ อืม อ่อกแอ พระเยซู อางเลิ่ง อางแม่น แฮ้ง กูต่องกูตี่ ย้า ป่าว กว่า แอ คูชี. จี่วีดอางซื้ง มาง ยองก้อง ทื่งกง่า แน ล่ากาน ว่า แง. ยา ยองนา ล่าที่ ปี่ อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ปี่ชี่, ไม้ ค่องช่าง อือนา กงามย้าง ปี่ง ยอง จี่ แฮ้ย่า อางเลิ่ง ม้าม้า แน.");
INSERT INTO bzi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","เธโอฟีลัส เวอ, ชฺ้าง อางอีบ่าอ่า พระเยซู อางเลิ่ง พาจาว มาง กงูนา ฮาย มย้าง ปี่ ล่า ชี่อือ แต้ม ชี ชี. ");
INSERT INTO bzi_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ยอง แต้ม ชี นี้ย่า พระเยซู อางเลิ่ง, ยอง ต่องก่า เมอ จาย กงากย่า กงามย้าง ชี อือ ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","แฮ้งย้า กงาม ยอง พระเยซู อางเลิ่ง แต้ม ชี อือ แม่น ย้า ฮู แอ, แน ชฺ้าง พระเยซู อางเลิ่ง กงาแบ กงามย้าง ชี อือนา น้าท้าม ยาว, อางแล่มอางล้าง แน แต้ม แอ บ่าปี่ ซี แน, ไม้ อางเลิ่ง กง่าเกิ้ง แน นางนา แต้ม ปี่ ล่าง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ยาว กงา นางนา อางเลิ่ง ม้าม้า แบ ปี่ ล่า ซี่ค้า, นาง พระเยซู อางเลิ่ง กงาแบ กงากย่า ชี แฮ้ย่า อางเจ่อจ่า กงากา แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ค้าแต้ เมอ, ยิว ปุโรหิต ทื่อม่าง จา อางเม้ง เศคาริยาห์ แน. ยาง ค่าบา มาง อางเม้ง เอลีซาเบธ แน. เศคาริยาห์ ยา ปุโรหิต อาบียาห์ อางมู เวอ ดื้ง แง. ยาว เอลีซาเบธ แน เศคาริยาห์ เย่ด อาโรน ก้อง อางเจ้อ ซื้บลือ ชี. ยาว เศคาริยาห์ แน เอลีซาเบธ เย่ด จี่วีด จา ชี แฮ้ญ่าม, เฮโรด ยูเดีย แควน เวอ ก่าซ้าด เพล่อ เมอ เย. ");
INSERT INTO bzi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","พาจาว ม้า อางมย้าง เย เย่ด ชฺ้าง อางแม่น แน, แน เย่ด จี่วีดอางซื้ง มาง อางลี้บอางล่าว แน จี่ต่าง แฮ้ง ฮายเค่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","แฮ้เมอ เย่ดย่า อางย่า บ่าจา, ไม้ เอลีซาเบธ ก้อง อางย่าบ่าดื่ง เย. อ่าจ่าม มือ เย่ด ย่าม่าง ม่าง กาชา เย. ");
INSERT INTO bzi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ยาว แฮ้ตีด ย่า เศคาริยาห์ อางมู อือ โบสถ์อางฮื่อ โย้เวอ ล่ากาน ว่า ญ่าม ย่าง เคอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","แฮ้นืง อางเกิ่ง อางฮ้อม พี ท่านฮู แช้ยู้ คูง, ยาว เศคาริยาห์ เบอจอก กงา ชีเย. นี้แม้ ฮา นี้ย่า ปุโรหิต อางลี้บ ซื้บลือ ชี ป้าค้า ย้าง เย. ");
INSERT INTO bzi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ยาว ยาง อางเกิ่ง อางฮ้อม พี เมอ, ชฺ้าง มู อือ ช้อน กายาว อางเง้ เวอ อธิษฐาน ฮา คู แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","เศคาริยาห์ อางฮ้อง คล้าว อางเกิ่ง อางฮ้อม พี เมอ, พาจาว มาง เท่วาด่า ทื่อม่าง มาง ยางนา มย้าง ปี่ชี่ เย. ยาว เท่วาด่า มาง อางเกิ่งอางฮ้อมพีย้า ล่าม่า ป่ากย่า เวอ จูง ลือ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","เศคาริยาห์ เท่วาด่า มางนา มย้าง เมอ แค ยืก เย. ");
INSERT INTO bzi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","จ้า เท่วาด่า มาง ยางนา จี่ช่าง เย นี้แม้แน, “เศคาริยาห์ เวอ, บ่าแค โจ! พาจาว ม้า นาง อธิษฐาน ฮา ชีย้าง กงากย่า ญา. เอลีซาเบธ นาง ค่าบา ม้า อางย่า ค่าพ่าย่า กงา เป. ยางนา ยอห์น แน อางเม้ง เม้ง โว! ");
INSERT INTO bzi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ยาง เกิ้ด ลือ ชี นี้ย่า นางนา ฮาย กย่างม่อนซ้า ปี่ ล่าง, ยาว ชฺ้าง คาโคลาโค อืม กย่างม่อนซ้า แง, ");
INSERT INTO bzi_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ไม้ พาจาว ม้า ยางนา กาญ่าม เวอ ล่ากาน ปีนแตปีนนา แฮ้ง ว่า ปี่ง. แน ยา อ่างู่น แต่ค่า แน อางม่าว เกิ่ง อือ บ่าต่าง. ยาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ม้า ยางก้อง ดื้ง แง, ยาง อางบา มาง ป่องปอง คล้าว เวอ ดื้ง เมอจาย ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ยา อิสราเอลชฺ้าง อือนา อางอีบ่าอ่า ย้า, ซฺื่ย จี่วีดอางซื้ง ยอง พาจาว เพล่อ ชี มางนา ซฺ้าแล แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ยาว ยอห์น มือ พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ แม้แน ย้า, พาจาว มาง อางเลิ่ง อางแม่น แฮ้ง เจิ้นเจ้อ นา บ่าแค แน ป่าว กว่า แง. จี่วีดอางซื้ง มาง ชาลือ เมอ ยอห์น ชฺ้าง อือนา ซฺ้า ชี แง. ยาว ยา อางบา อางโบ้ง แน อางย่า อือนา ฮาย ลาก ลางกา ปี่ แง. ยาว ยา ชฺ้าง พาจาว มางนา บ่าน่าจ่าง อือนา, ฮาย นืงบาเพ่น ชฺ้าง อางแม่น เพล่อ วี่ไซป้านญา จา ปี่ แง. พาจาว มาง ชฺ้าง เพล่อ ชี่ แม้แนย้า เป. ยาง นี้แม้ ฮา ชี นี้ย่า ไม้ จี่วีดอางซื้ง มาง ลือ เมอ ชฺ้าง อือนา ล่อลาบ ปี่ง น้อ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ยาว เศคาริยาห์ เท่วาด่า มางนา น้า เย นี้แม้แน, “ท้าว กงา บ้าเจอล้อแม้ แบตอ กาแน, นาง จี่ ล้า ปี่ชี่ นี้ ม้าม้า ย้า ตอล้า แงแน? ไม้ กงา อางโต นี้ย่า ย่าม่าง ม่าง กาชา, อ่าจ่าม กงา ค่าบา ม้า อ่าญู บย่า คางญา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","เท่วาด่า มาง ม่า เย นี้แม้แน, “กงา เท่วาด่า กาเบรียล มาง, กงา พาจาว มาง ล้าก้า เวอ จูง มาง. ยาว พาจาว มาง กงานา ม่าย อางเลิ่ง อางแม่น แฮ้ง นางนา ลือ ม่า ลือ ปี่ ล่าง, นา อางย่า กงา แงแน. ");
INSERT INTO bzi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","จ้า นู้จายแล ปี่ นี้ย่า นา บ่าจี่ตอ กา เป, แน นาง อางย่า กงา เมินญา จี่ตอ กางแง, ไม้ นา กงา จี่ต่าง นา บ่าเจ่อ ล่า วา. จ้า อางเลิ่ง นี้ย่า ม้าม้า ย้า ตอล้า แง พาจาว มาง อางญ่าม แช้ ชี ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","แฮ้ญ่าม เวอ อางเลิ่ง คาโคลาโค ตอล้า เมอ, ชฺ้าง มู เศคาริยาห์ นา ล่อ อือ เย้ง คูง เย, บ้าเจอ ยา โบสถ์อางฮื่อ คล้าว เวอ มล่าง แน อางดื้ง แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ยาว ยาง อางเง้ เวอ อ่อก ลือ เมอ อ่าซ่าง มางนา บ่าจี่ช่างตอ กาเย. ยางมือ ยองนา ล่าปู่ เต ม่า กาน เย. แฮ้งเย่ ชฺ้าง มู อือ แบ คูชี เศคาริยาห์ โบสถ์อางฮื่อ คล้าว เวอ ม้างม้าเจ้อ มย้าง ชี แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ยาว ยาง โบสถ์อางฮื่อ โย้เวอ ล่ากาน แฮ้ง ว่า เปิน ยาว, ยาง ยู้ม พ่าวแอ้น ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","แฮ้เมอ จายล้า ยาว, เอลีซาเบธ มาง อู่ปู่มปู่ม ชี, ยาว ยา ยู้ม โย้เวอ 5 ลา ดื้ง ชี เกิ้งเกิ้ง บ่าแอ่บ่าล่า แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","เอลีซาเบธ จี่ เย นี้แม้แน, “จี่วีดอางซื้ง มาง นืงบา อางแม่น, ยาว อ่ามือ กงา อางย่า บ่าจา นี้ย่า บ่าซ่าจอ กาน” แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","เอลีซาเบธ อู่ปู่มปู่ม 6 ลา เคอ ยาว, ค่าบาย่า ย่าบี่ ทื่อม่าง จา เย อางเม้ง มารีย์ แน. พาจาว มาง เท่วาด่า กาเบรียล มางนา ยางก้อง ซฺาลือ ปี่ ชี่. ยา นาซาเร็ธ ค่อง กาลิลี แควน เวอ ดื้ง แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","มารีย์ โยเซฟ, ก่าซ้าด ดาวิด อางเจ้อ ซื้บลือ ชี มาง คู่นซู่ เย่. ");
INSERT INTO bzi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","เท่วาด่า มาง มารีย์ นา ซฺ้าแอ ชีเย, ยาว จี่ช่าง ชี นี้แม้แน, “ย่าบี่ เวอ, พาจาว มาง นางนา ก่ามป่อน ปี่ ล่าง ย้า! จี่วีดอางซื้ง ม้า นางก้อง ดื้ง เป!” ");
INSERT INTO bzi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","มารีย์ แฮ้แม้แน กงากย่า ยาว, นืงบาต่อง เวอ บ่าจาบ่าดื่งบื้อ เย. ยาว ยา เย้ง เย เท่วาด่า มาง ม่า ล่าง นี้ย่า บ้าเจอป้าค้า เวอ แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","จ้า เท่วาด่า มาง จี่ เย นี้แม้แน, “มารีย์ เวอ, บ่าแค โจ เป! พาจาว ม้า อางเลิ่ง อางแม่น นางนา ฮาย ปี่ ล่าง! ");
INSERT INTO bzi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","นา อู่ปู่มปู่ม เป, ยาว อางย่า ค่าพ่าย่า กงา เป. ยาว นาง อางย่า มางนา อางเม้ง เม้ง โว ‘เยซู’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","เยซู ยา ชฺ้าง อางฮื่อ เพล่อ เป. ยาว ยา นี้แม้แน อางเม้ง กงา จ่าแล่ แง, พาจาว มาง อางย่า กูย่างกูเจ้อ ล่อบ่าปา ฮื่อ เลิ่นเลิ่น มาง แน. จี่วีดอางซื้ง มาง ยางนา ฮาย ก่าซ้าด อางฮื่อ เพล่อ ปี่, ก่าซ้าด ดาวิด ยาง อางเจ้อ มาง แม้แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ยาว ยา อิสราเอลชฺ้าง อือ ก่าซ้าด กูญ่าม ย้า กงาเพล่อ แล แงแน.” ");
INSERT INTO bzi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","มารีย์ เท่วาด่า มางนา น้า เย นี้แม้แน, “บ้าเจอล้อแม้ ตอล้า กงา กางแง แน? กงา อางบล้อง บ่าจากางซื้ง นอ.” ");
INSERT INTO bzi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","เท่วาด่า มาง ม่า เย นี้แม้แน, “อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ม้า นางก้อง ดื้ง ลือ แง เป. ยาง ล่าที่ อางแม่น แฮ้ย่า นางนา ฮาย อู่ปู่มปู่ม ปี่ ล่าง เป, แน ย่าแน่ อางเซฺิ่งอางซฺ้าง เกิ้ด ลือ นี้ม้า พาจาว มาง อางย่า แน ฮ้าว คู แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ฮู ปาว! เอลีซาเบธ นาง ย่าช่างม่องน้าม ม้า อามือ อู่ปู่มปู่ม 6 ลา เคินญา. ยา ย่าม่าง ม่าง เมอ อางย่า ค่าพ่าย่า กงา แง. ค้าแต้ เมอ ชฺ้าง อือ จี่ กาง แง, ยา อางย่า บ่ากงาตอ กา ชีล้า แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","จ้า เจิ้นเจ้อ บ่าจา พาจาว มาง บ่าฮาตอ กาแน” แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","มารีย์ จี่ เย นี้แม้แน, “กงา จี่วีดอางซื้ง มาง ย่าเจ่น, นาง จี่ แฮ้งแม้แน เพล่อ ปี่ ปาว” แน. ยาว เท่วาด่า มาง โปยว ชี. ");
INSERT INTO bzi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","บ่ามล่าง ยาว มารีย์ อางไว่อางคย้าง เย, ยูเดีย ตาแซ้ อางเมิง ทื่อเมิง เวอ แล ชี. ");
INSERT INTO bzi_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ลือเคอ ลือยาว มารีย์ เศคาริยาห์ ยู้ม เวอ อ้องแลน ชี, ยาว เอลีซาเบธ นา จี่อู้ น้าท้าม ช่าง ชี. ");
INSERT INTO bzi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","เอลีซาเบธ มารีย์ จี่อู้ น้าท้าม แฮ้ง กงากย่า ยาว, ยาง ป่องปอง คล้าว ย่าแน่ มาง กี่แล่โจง แล่ง เย. แฮ้เมอ ย่า เอลีซาเบธ ก้อง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ปลื้ง ย้า จา แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ยาว เอลีซาเบธ มือ มารีย์ นา จี่ช่าง ชี อางเซง บื้ง แน นี้แม้แน, “ค่าบาย่า มู คาโคลาโค นู้เวอ, พาจาว มาง นางนา แน นาง ป่องปอง คล้าว เวอ ย่าแน่ ดื้ง มางนา, ก่ามป่อน บย่า ย้า ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","จี่วีดอางซื้ง มาง อางบา มาง เวอ, นาง กงานา บ่อซฺ้า ลือ ล่า ชี นี้ย่า นาบาตา ย้า แม่น แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","กงา นาง อางเซง แฮ้ง กงากย่า เมอ, กงา ป่องปอง คล้าว เวอ ย่าแน่ มาง กี่แล่โจง แล่ กย่าง แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","นาง ก่ามป่อน กงาบู้ ชี นี้ย่า, ไม้ นาง เจ่อ ชี แฮ้ง ปาปาย ย้า, พาจาว มาง นางนา ม่า ล่าชี่ แฮ้ย่า ม้าม้า ย้า ตอล้า แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ยาว มารีย์ นี้แม้แน จี่ ชีเย, “กงา จี่วีดอางซื้ง มางนา สรรเสริญ ฮา แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","แน กงา กย่างม่อนซ้า แง, ไม้ พาจาว ม้า กงานา ฮูพลา ล่าง นอ. ");
INSERT INTO bzi_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ไม้ กงา ชฺ้าง ปีนแตปีนนา บ่าอ่า กงา ย่าเจ่น กานแอ. ยาว พาจาว มาง กงานา ฮูพลา ล่าง. นู้ จายแล ปี่ นี้ย่า ฮาก กงานา ก่ามป่อน กงา ชี มาง แน ฮ้าว ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ไม้ พาจาว ม้า กงานา อางเลิ่ง อางแม่น อางฮื่อ อือ ฮาย ปี่ ล่าง. พาจาว มาง อางเม้ง แฮ้ อางเซฺิ่งอางซฺ้าง แน ยา ล่าที่ อางจา. ");
INSERT INTO bzi_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","พาจาว ม้า, ชฺ้าง ยางนา เจ่อ อือนา กูญ่าม ย้า ลากซื่งกง่ากย้า แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ยาง ล่าปู่ แฮ่ ล่ากาน อางฮื่อ ว่า แง. พาจาว ม้า ชฺ้าง อ่อนจ่าแล่ อือนา ฮาย โปยว ปี่ง แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","พาจาว ม้า ชฺ้าง ล่าที่ อางจา อือนา ฮาย ชฺ้าง ล่าที่ บ่าจา อือ เพล่อ ปี่ แง. ชฺ้าง ล่าที่ บ่าจา อือ ชฺ้าง ล่าที่ อางจา อือ เพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","พาจาว ม้า ชฺ้าง จฺื่งคู อือนา ฮาย จฺ่าเกิ่ง อางแม่น กงาจฺ่า ปี่ง ก้อ แน. จ้า ชฺ้าง อางจาอางปาง อือนา ฮาย เจิ้นเจ้อ บ่าจา แน ฮา ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","พาจาว ม้า อิสราเอลชฺ้าง ยาง ย่าเจ่น อือนา ปล่อง แง. ยา ยองนา ลากซื่งกง่ากย้า แฮ้ง บ่าลู่ม. ");
INSERT INTO bzi_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ยา อับราฮัม แน ยาง อางย่าอางคย้า อางอ่านอางซฺื้อ อือนา ฮูพลา แล แง. ต่องก่า เมอ ยาง กงู อางเจ้อ อือนา ก่ามค่าน ปี่ ชี ชี แฮ้งแม้แน.” ");
INSERT INTO bzi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","มารีย์ เอลีซาเบธ ก้อง ดื้ง ชี 3 ลา ยาว ยาง ยู้ม พ่าว แลน แล่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","เอลีซาเบธ อางย่า เกิ้ด ญ่าม เคิน ยาว, ยา อางย่า ค่าพ่าย่า กงา ชี. ");
INSERT INTO bzi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ยู้มต่องยู้มทาง แน ยาง ย่าช่างม่องน้าม อือ กงากย่า คูชี นี้แม้แน, พาจาว มาง ยางนา ลากซื่งกง่ากย้า แงแน, ยาว ยองมู ย่าง กย่างม่อนซ้า คูง เย. ");
INSERT INTO bzi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ยาว 8 นืง เคอ ยาว, ย่าแน่ มางนา พิธีขลิบ ฮาย ปี่ ชีเย. ยาว ย่าช่างม้องน้าม อืม ย่าแน่ มางนา อางเม้ง เม้ง ปี่ชี่, “เศคาริยาห์” แน, อางโบ้ง มาง อางเม้ง แม้แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","จ้า อางบา มาง จี่ เย นี้แม้แน, “บ่าอ่า อางเม้ง ยอห์น แน เม้ง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ยองมู ย่าง ม่า เย, “นอง ย่าช่างม้องน้าม อือก้อง อ่าซ่าง อางเม้ง นี้แม้แน บ่าจา.” ");
INSERT INTO bzi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","จ้า ยองมู ย้าง ล่าปู่ เต น้า น้าว, ย่าแน่ มาง อางโบ้ง มางนา ล้อแม้ อางเม้ง เม้ง วา แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","เศคาริยาห์ ก่าดาน ทื่ออาน ป้า ยาว อางเม้ง แต้ม กาน ชี นี้แม้แน, “ยาง อางเม้ง ยอห์น” แน. ชฺ้าง มู อืม นืงบาม่าน คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","จ้า ซฺ้อก ย้า เศคาริยาห์ จี่ กงา ชี. ยาว ยาง พาจาว มางนา สรรเสริญ ฮาย ชี. ");
INSERT INTO bzi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ยาง ยู้มต่องยู้มทาง อือ แค คูง แน ยูเดีย แควน ค่อง อือเมอ นี้เลิ่ง จ่อด ย้า จี่ ลางกา ชี. ");
INSERT INTO bzi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ค่องช่าง อือ กงากย่า ยาว น้าท้าม กาง เย นี้แม้แน, “นี้ก้าม ย่าแน่ นี้ม้า ล้อแม้ เพล่อ แล นามบ่าแบ?” ไม้ ยอ อางแบ นอ พาจาว มาง ล่าที่ แฮ้ย่า ย่าแน่ มางก้อง อางจา ม้าม้า แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","เศคาริยาห์ ซฺ้อก แน จี่ กงา เมอ, อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ยางก้อง ปลื้ง ย้า จา แง. ยาว ยาง มือ จี่ ชี นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“พาจาว มางนา ขอบคุณ ฮา โว! ยา อิสราเอลชฺ้าง อือ พาจาว มาง เป. ยาง ลือ ชี นี้ย่า ยา ชฺ้าง อือนา อางบล่าบ ชอ ลือ แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ไม้ พาจาว มาง กงูนา ชฺ้าง ทื่อม่าง ปี่ ล่าแง. ชฺ้าง แฮ้ม้า ล่าที่ อางจา ยา กงูนา ปล่อง ลือ ล่าง. ยา ก่าซ้าด ดาวิด อางเจ้อ พาจาว มาง ย่าเจ่น มางก้อง เกิ้ด ลือ แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","กูย่างกูเจ้อ นี้ย่า พาจาว มาง ก่ามค่าน ฮาย ชี ชี แม้แน ย้า เพล่อ ชี, ก่ามค่าน นี้ม้า ค้าแต้ เวอ พาจาว มาง จี่ต่างจี่แต่นฮู อือนา ม่า ยาว, กงูนา ม่า ล่าชี่ แฮ้งย้า. ");
INSERT INTO bzi_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","พาจาว ม้า กงู นา ชฺ้าง บ่าแม่น อือก้อง ปูน ปี่ ล่าง. แน ชฺ้าง กงูนา เม้อ ล่าง อือก้อง ปูน ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","พาจาว ม้า กงูนา ฮาย มย้าง ปี่ ล่าง, ยา อ่าฮู้ อ่าพี้ ยองนา ลากซื่งกง่ากย้า แง, แน ยา ยองนา ก่ามค่าน อางเซฺิ่งอางซฺ้าง ปี่ชี่ แฮ้งนา บ่าลู่ม แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","พาจาว ม้า อับราฮัม กงู อางฮู่ มางนา นี้แม้แน ก่ามค่าน ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ยา กงูนา ชฺ้าง กงูนา เม้อ ล่าง อือก้อง ปล่องปูน ปี่ ล่าแง. ไม้ กงูนา เจิ้นเจ้อ นา บ่าแค แน ยางนา ล่ากาน ว่ายปี่ ปี่ ล่าง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","แน กงูนา พาจาว มาง ล้าก้า โย้เวอ, เซฺิ่งซฺ้าง แน กง่าเกิ้ง แน จี่วีดไจ ปี่ ล่าง แนนอ. กงู จี่วีด จา เมอ จาย ซฺี้ แอ เมอ เคอ แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ย่าแน่ มาง เวอ, ฮาก ย่า นางนา พาจาว อางฮื่อ เลิ่นเลิ่น ม่าง จี่ต่างจี่แต่นฮู แน ฮ้าว ล่า คูแง, ไม้ นา ชฺ้าง จี่วีดอางซื้ง มางนา ล่อลาบ อือนา ซฺ้า ชี แง. ");
INSERT INTO bzi_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ยาว นา ชฺ้าง อือนา ม่า แง พาจาว ม้า ล้อแม้ อางบล่าบ ชอ ล่าง แน. ยาว พาจาว ม้า ยอง อางบล่าบ ฮา ชี แฮ้ง อางซี บ่ายู่ แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","พาจาว ม้า กงูนา ลากซื่งกง่ากย้า ล่าง, แฮ้งย้า มู่งท่า เวอ จาย อางแปล้นอางซ้า ท่อ ลู่งลือ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ไม้ ชฺ้าง อางวื้งอางว้าง เวอ ดื้ง อือนา แน ชฺ้าง ค่าตอง ซฺี้ แฮ้งนา แค อือนา, อางแปล้นอางซ้า แฮ้ง กงามย้าง ปี่ แง. แน พาจาว ม้า กงูนา ฮูพลา แม่น แน กงาจากงาดื้ง ปี่ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ยาว ยอห์น มือ ค่อล้า ชีเย, แน ยา ชฺ้าง นืงบาอางแก่น เย. ยา ซ่องก่องอางเว่อ เจิ้นเจ้อบ่าจา โย้เวอ ดื้ง ชีเย, อิสราเอลชฺ้าง อือนา ม่าอู่บ อางญ่าม แฮ้ง เคอ ล้า เมอ ตื่อเคอ. ");
INSERT INTO bzi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","แฮ้ญ่าม ก่าซ้าดยอคา ทื่อม่าง จา เย, ยาง อางเม้ง ซีซาร์ ออกัสตัส แน. ยา ประเทศ โรม คาโคลาโค แฮ้ง ฮูพลา แง. ยา ยาง ย่าเจ่น อือนา ม่าย ชี, ยาง ชฺ้าง คาโคลาโค ฮูพลา อือนา ดาบ ยาว, ยอง อางเม้ง แฮ้ง ปาบ เวอ แต้ม กาน โว แน. ");
INSERT INTO bzi_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(นี้เทอ ชฺ้าง ดาบ ชี นี้ย่า, ประเทศ โรม ต่องก่าต่าง ชฺ้าง อือนา ยอง อางเม้ง แฮ้ง ปาบ เวอ แต้ม กาน ย้างเย่. นี้แม้ ฮา ชี นี้ย่า ผู้ว่า คีรินิอัส ซีเรีย อางเมิง ฮูพลา เมอ ตอล้า ชีเย.) ");
INSERT INTO bzi_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ยาว ชฺ้าง คาโคลาโค อืม ค่อง พ่าว แล อางเม้ง แต้ม แล คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","แฮ้งเย่ โยเซฟ ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บลือ ชี มาง, ก่าซ้าด ดาวิด ค่องเกิ่ด โย้เวอ พ่าว แอน แล่ชี่. ยา นาซาเร็ธ ค่อง กาลิลี แควน โย้เวอ จาย เบธเลเฮม ค่อง ยูเดีย แควน โย้เวอ แอน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","แน โยเซฟ มารีย์ ยาง คู่นซู่ มางนา คาตา เย ซฺื่ยแอ, ยาว ปาบ เวอ อางเม้ง แต้ม กาน แอ ชี. แฮ้ญ่าม เมอ มารีย์ อู่ปู่ม เย, แน ยาง ป่องปอง แฮ้ ฮื่อ กาชา เย. ");
INSERT INTO bzi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","เย่ด โย้เวอ เคอ แล เมอ, มารีย์ อางย่า เกิ้ด ญ่าม ย่าง เคิน ล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","แน ดื้งย้า ซฺ้า กว่า ยาว บ่าจา แม้แน, เย่ดมือ อ่ามย่าง คอก คล้าว เวอ ดื้ง แอ ชีเย. ยาว มารีย์ มือ อางย่า ค่าพ่าย่า เกิ้ด ไจ่ ชี, ย่าแน่ นี้ม้า มารีย์ อางย่า ซากาว มาง ย้า. ยาว มารีย์ ย่าแน่ อางคย้าง แฮ้ง ย่าแน่ มางนา ปาน ปี่ ชี่, ยาว อ่ามย่าง ต่างล่าง อางจ้า กาน จฺ่า ปี่ เซฺ่อ โย้เวอ ยู่ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ค่อง อางเง้ น่าตูง โย้เวอ ชฺ้าง แกะปอฮู จา แง. ยองมู นี้ย่า มู่งคี่ โย้เวอ แกะ อือนา ฮูพลา จา แง. ");
INSERT INTO bzi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ทื่อชี่ด ยาว จี่วีดอางซื้ง มาง เท่วาด่า ทื่อม่าง ซฺาลือ ปี่ชี่. ยาว พาจาว มาง อางแปล้นอางซ้า ย้าง ทื้อแปล้น เย, ชฺ้าง แกะปอฮู อือก้อง แปล้น ลือ ชี. ยอง มย้าง ยาว, นาบาตา เย แค คู แง. ");
INSERT INTO bzi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","จ้า เท่วาด่า มาง นี้แม้แน จี่ เย, “บ่ากงา แค คา! กงา นองนา แน ชฺ้าง คาโคลาโค อือนา, อางเลิ่ง กย่าง เซฺ่อ นาบาตา แม่น แฮ้ง ลือ ม่า ลือ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","มี้นืง ก่าซ้าด ดาวิด ค่อง อางเม้ง เบธเลเฮม นู้ เวอ, ชฺ้าง นองนา อางบล่าบ ชอ ล่าง มาง ลือ เกิ้ด ลือ ชี, ยา พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ปี่ชี่ มาง, แน กงู จี่วีดอางซื้ง มาง ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","กงา จี่ นี้ย่า อางเลิ่ง ม้าม้า แน นองนา ฮายแบ ปี่ ล่าง นี้ย่า นี้แม้, นอ อ่ามย่าง ต่างล่าง อางจ้า กาน จฺ่า ปี่ ย่า โย้เวอ, ย่าแน่ อางคย้าง ปาน ยู่ จา นา มย้าง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","เท่วาด่า แฮ้ มาง จี่ เปิน ยาว, ซฺ้อก ย้าเย่ เท่วาด่า อางบย่า ซฺื่ยกา ลู่งลือ ชี, พาจาว มางนา สรรเสริญ ฮา คู ชี. แน ยาว นี้แม้แน จี่ คู เย, ");
INSERT INTO bzi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“พาจาว อางฮื่อ เลิ่นเลิ่น มู่งท่า ดื้ง มาง เวอ, กงู นางนา สรรเสริญ ฮา ล่าแน. ยาว ชฺ้างอางเมิง นู้ ชฺ้าง คาโคลาโค นี้ย่า, อ่าซ่าง พาจาว มางนา ฮาย นืงบาจาบ ปี่ แง, ชฺ้าง แฮ้มางนา จาบื่อดื้งบื้อ แน จาแล ปี่ โว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","เท่วาด่า อือ มู่งท่า เวอ พ่าว แล แล่ คู ยาว, ชฺ้าง แกะปอฮู อือ นี้แม้แน จี่ กาง เย, “เอ้ว! เบธเลเฮม ค่อง เวอ แอ, จี่วีดอางซื้ง มาง กงูนา อางเลิ่ง ม่า ล่าชี่แฮ้ง ฮู แอ คู ปายา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ชฺ้าง แกะปอฮู อือ อางไว่อางคย้าง เย แอน คูชี. เคอ แอ ยาว มารีย์ แน โยเซฟ เย่ดนา มย้าง แอ ชีเย. แน ย่าแน่ อ่ามย่าง ต่างล่าง อางจ้า กาน จฺ่า ปี่ เซฺ่อ โย้เวอ ยู่ จา นา มย้าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ชฺ้าง แกะปอฮู อือ ย่าแน่ มางนา มย้าง ยาว, ย่าแน่ มาง อางเลิ่ง แน เท่วาด่า มาง ม่า ชี แฮ้ง ฮากนา อู่บน้า ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ชฺ้าง คาโคลาโค อางเลิ่ง อางแม่น แฮ้ง กงากย่า คูชี อืม เย้ง คูง เย, ชฺ้าง แกะปอฮู อือ อางเลิ่ง อางแม่น ตอล้า ชี แฮ้, บ้าเจอล้อแม้ ตอล้า ชี แน. ");
INSERT INTO bzi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","จ้า มารีย์ ยางก้อง อางเลิ่ง ตอล้า ชีอือ, กย้าบ แน นืงบา เวอ กอ ชี ยาว อางเลิ้ง กาเย เย้ง แง. ");
INSERT INTO bzi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","แกะปอฮู อือ ย่อ แล แล่ เมอ, ยอ พาจาว มางนา สรรเสริญ ฮา คู ชี, ไม้ ยอง อางเลิ่ง กงากย่า กงามย้าง ชี แฮ้ง ปาปาย. ยาว อางเลิ่ง คาโคลาโค แฮ้, เท่วาด่า มาง ม่า ชี แม้แน ม้าม้า ย้า ตอล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ย่าแน่ มาง เกิ้ด 8 นืง เคอ ยาว, พิธีขลิบ อ้อง ปี่ ญ่าม ย่าง เคอ ชีเย. ยาว “เยซู” แน อางเม้ง เม้ง ชี, มารีย์ อู่ปู่มบ่าปู่ม เมอ เท่วาด่า มาง ม่า ชี ชีแม้แน. ");
INSERT INTO bzi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","โมเสส อางลี้บอางล่าว เวอ ค่าบาย่า อางย่า เกิ้ดซฺื่อ นี้ย่า พิธีเซฺิ่งซฺ้าง แน ชี่ปู้ แล่ เย. ยาว มารีย์ นี้แม้ กงาฮา เย่, แฮ้งย้าเย่ โยเซฟ แน มารีย์ เย่ด มือ, พระเยซู นา เยรูซาเล็ม อางเมิง เวอ ซฺื่ยแล จี่วีดอางซื้ง มางนา ท่าน แอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","จี่วีดอางซื้ง มาง อางลี้บ แต่ง ชี ชี นี้แม้แน, “อางย่า ซากาว ค่าพ่าย่า กงา ยาว, พาจาว มางนา ท่าน อางย่า เพล่อ ปี่ เปิน แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ยาว พาจาว มาง อางลี้บ แต่ง ชี ชี แฮ้, ค่าบาย่า อางย่า เกิ้ดซฺื่อ นี้ย่า พิธีเซฺิ่งซฺ้าง แน ชี่ปู้ แฮ้ย่า, ฮาย่า ก่องค่าว 2 โต บ่าอ่ายาว ฮาย่า อางป่อน อางโกลง 2 โต กงาท่าน แง. แฮ้งเย่ มารีย์ แฮ้แม้ ฮา ชี. ");
INSERT INTO bzi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ค่าพ่าย่า ทื่อม่าง จา อางเม้ง สิเมโอน แน. เยรูซาเล็ม อางเมิง เวอ ดื้ง แง. ยา พาจาวจี่ต่าง นา อางน้า. แน ยา ชฺ้าง พาจาว มาง แช้ ก่าซ้าด เพล่อ อิสราเอลชฺ้าง อือนา ปล่อง ลือ ปี่ ชี มางนา ล่อ, ยาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ยางก้อง ดื้ง แง. ");
INSERT INTO bzi_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง สิเมโอน นา นี้แม้แน ม่า เย, “นาง บ่าซฺี้ ฮู่ เมอ นา ชฺ้าง พาจาว มาง แช้ ก่าซ้าด เพล่อ ปี่ ชี่ มางนา กงามย้าง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ยาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง, สิเมโอน นา ซฺื่ย โบสถ์อางฮื่อ เวอ อ้อง แลน ชี, แฮ้นืง ย่า มารีย์ แน โยเซฟ เย่ด เยซู นา ซฺื่ย พาจาว มางนา ท่าน แล ชีเย, พาจาว มาง โมเสส นา อางลี้บอางล่าว ปี่ ชี ป้าค้า. ");
INSERT INTO bzi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","สิเมโอน เยซู นา อาม แล่ ยาว, พาจาว มาง นา นี้แม้ สรรเสริญ ฮา ชีเย, ");
INSERT INTO bzi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“จี่วีดอางซื้ง เวอ, น้า นาง ก่ามค่าน ฮา ชี ชี แฮ้งแม้แน ฮาย ญา, กงานา แม่น แน ซฺี้ ปี่ ล่าปาว. ");
INSERT INTO bzi_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ไม้ กงา ชฺ้าง นาง กงูนา ซฺาลือ ปล่อง ปี่ ล่าง มางนา กงามย้าง ย่า. ");
INSERT INTO bzi_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","นา ชฺ้าง นี้มางนา ซฺ้า ชี ยาว ชฺ้าง คาโคลาโค อือนา กงามย้าง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ยา ยิวชฺ้างบ่าอ่า อือนา อางแปล้นอางซ้า ท่อ, พาจาว ม้าม้า มางนา มย้าง ปี่ชี่ มาง ย้า, แน ยา ชฺ้าง คาโคลาโค อือนา, อิสราเอลชฺ้าง อือนา จี่ต่าง โญกจ่าญ่อจ่า แฮ้ง กงา ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ยาว โยเซฟ แน มารีย์ เย่ด มือ นืงบาม่าน ชี, สิเมโอน ย่าแน่ มาง อางเลิ่ง แฮ้แม้ จี่ นา กงากย่า แฮ้ง. ");
INSERT INTO bzi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ยาว สิเมโอน ยองนา ก่ามป่อน ปี่ ชีเย. ยาว มารีย์ นา นี้แม้แน ม่าย ชีเย, “พาจาว ม้า ย่าแน่ นี้ มางนา แช้ ชี ญา. ยา อิสราเอลชฺ้าง อางบย่า นา อางบล่าบชออ่อก ปี่ แง, แน ยาง ปาปาย ย้า อิสราเอลชฺ้าง อางบย่า ก่างพยา แง. ย่าแน่ นี้ม้า ชฺ้าง อือนา ฮา แบ ปี่ แง พาจาว ม้า บ้าเจอ กงาซี้ แงแน. จ้า ชฺ้าง อางอีบ่าอ่า ยางนา อางไล้ จี่ กาน แง. ");
INSERT INTO bzi_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ยาว ยอง อางไล้ จี่ แฮ้งย้า ชฺ้าง คาโคลาโค อือนา ฮา แบ ปี่งแง, ยอง นืงบา แฮ้ บ้าเจอล้อแม้แน. ยาว อางเลิ่ง นี้อือ นาบาตา ย้า นางนา ฮาย นืงบาต่อง ลาบ้าบ ปี่ ล่าแง, นาง นืงบา โย้เวอ มยาทาง ชาว ชี ช้อด ย้าเป” แน. ");
INSERT INTO bzi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ค่าบาย่า ทื่อม่าง จา ชีเย ยา โบสถ์อางฮื่อ คล้าว ดื้ง แง. ยาง อางเม้ง อันนา แน เย. ยา ย่าม่าง ม่าง กาชา เย, ยา ฟานูเอล อางย่าย่าบี่ แน อาเซอร์ อางเจ้อ ซื้บลือ ชีเย, ยาว พาจาว มาง ยางนา แช้ ชี ชี พาจาวจี่ต่างจี่แต่นฮู เพล่อ ปี่ แงแน. อันนา อางบล้อง ยู้ 7 ปี เคิน ยาว อางบล้อง มาง ซฺี้ กาชี. ");
INSERT INTO bzi_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","แฮ้เมอ จายล้า ยาว ยาง อางบล้อง บ่ายู่ แล่ เย. อันนา อ่าญู 84 ปี. ยา โบสถ์อางฮื่อ คล้าว ดื้ง กาน แง, เกิ้งเกิ้ง บ่าอ่อกแอ ยา ตื่น มู่งคี่ นืงก้อง ย้าเย่ พาจาว มางนา ไว้ ดื้ง แง. ยาง พาจาว มางนา ไว้ แฮ้ย่า ฮ่าง จฺ่าเกิ่งจฺื่ง อธิษฐาน ฮา เย่. ");
INSERT INTO bzi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","สิเมโอน จี่ เปิน ยาว อันนา ยองนา อ้อง ซฺ้า แล ชี. ยาว พาจาว มางนา สรรเสริญ ฮาน ชี, แน ย่าแน่ เยซู มาง อิสราเอลชฺ้าง อือนา อางตูกอางพาน ปล่องปูน ปี่ อางเลิ่ง แฮ้ง, ชฺ้าง พาจาว มางนา ล่อ ยองนา ปล่อง ปี่ชี่ อือนา อู่บน้า ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","โยเซฟ แน มารีย์ เย่ด มือ, พาจาว มาง อางลี้บอางล่าว ม่ายฮา ปี่ แม้แน ฮา เปิน ยาว, นาซาเร็ธ ค่อง กาลิลี แควน เวอ พ่าว แลน แล่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ยาว เยซู มือ ค่อล้า ชี. ยาว พาจาว มาง ยางนา ก่ามป่อน ปี่ ชี, ยางนา แฮ่งจาแก่นคา วี่ไซป้านญา จา ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","พระเยซู อางบา อางโบ้ง มาง เย่ด กูปี ย้าเย่, เยรูซาเล็ม อางเมิง โย้เวอ ปัสกาป่อย เวอ แล แง. ");
INSERT INTO bzi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ยาว พระเยซู อ่าญู 12 ปี เคอ ยาว, ยาง อางบา อางโบ้ง มาง เย่ด ยางนา ปัสกาป่อย เวอ ซฺื่ย แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ปัสกาป่อย ย้าง เปิน ยาว, ค่องช่าง อืม ยอง ยู้ม พ่าว แอ แล่ ชี่, จ้า พระเยซู มือ เยรูซาเล็ม อางเมิง โย้เวอ จานช่าชี่, จ้า โยเซฟ แน มารีย์ เย่ด บ่าแบ เย่. ");
INSERT INTO bzi_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ไม้ เย่ด เย้ง เย่ พระเยซู ชฺ้าง อางมู พ่าว ลือ คูชี อือก้อง ทื่งกง่า ย้า เค่ ลืน ชี แน. น่อง โย้เวอ มู่งคี่ล้าก้า แฮ้นืง ปูน ยาว, เยซู อางบา อางโบ้ง มาง เย่ด อางย่า มางนา เย่ด ย่าช่างม่องน้าม อือ อางมู, แน อางช่าง อือ อางมู โย้เวอ ซฺ้า กว่า แอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","จ้า บ่าซฺ่า มย้าง กาเย. แฮ้งย้า เย่ด มือ เยรูซาเล็ม อางเมิง โย้เวอ พ่าว ซฺ้า แอ แล่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ยาว 3 นืง เคอ เมอ ย้าเย่, โยเซฟ แน มารีย์ เย่ด พระเยซู นา โบสถ์อางฮื่อ คล้าว โย้เวอ มย้าง แล ชี. แฮ้ญ่าม เมอ เยซู อางลี้บอางล่าว ม่าอู่บฮู อือ จี่ แฮ้ง ดื้ง น้า จา เย, แน ยา ยองนา น้าท้าม ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ชฺ้าง คาโคลาโค พระเยซู จี่ต่าง วี่ไซป้านญา จา แน, อางจี่ อางพอ คี่ แฮ้งนา กงากย่า คูชี อืม นาบาตา เย่ นืงบาม่าน คูแง. ");
INSERT INTO bzi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","โยเซฟ แน มารีย์ เย่ด พระเยซู นา มย้าง ยาว, บลื่ง เย่ ฮานล้า ปี่ชี่. ยาว มารีย์ พระเยซู นา นี้แม้แน จี่ช่าง ชีเย, “จาว เวอ, นา บ้าเจอ อ่าบา อ่าโบ้ง นา นี้แม้แน อางฮา ล่าแน? นางโบ้ง ไกง้ย่า นาบาตา ย้า นืงบา พี้ล้อง, ไกง้ย่า นางนา กูต่องกูตี่ ย้า ซฺ้า กว่า ล่าแอ่” แน. ");
INSERT INTO bzi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","จ้า พระเยซู นี้แม้แน พอ ชีเย, “บ้าเจอฮาย กงานา ซฺ้า กว่า ล่า แง? บ่าแบ ล่า กงาย่า พาจาว กงา อ่าโบ้ง เพล่อ ชี มาง ยู้ม นู้เวอ กงา ดื้ง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","จ้า โยเซฟ แน มารีย์ เย่ด พระเยซู จี่ต่าง แฮ้งนา บ่าน่าแบกา เย่. ");
INSERT INTO bzi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ยาว พระเยซู นาซาเร็ธ ค่อง เวอ พ่าว แอน แล่ชี่, แน ยา อางบา อางโบ้ง ม่าอู่บจี่ต่าง นา อางน้าจ่า เย. พระเยซู อางบา มาง ยาง อางย่า ม่าง อาเลิ่ง แฮ้ง นืงบา เวอ กอย ชี ชี. ");
INSERT INTO bzi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ยาว พระเยซู ค่อล้า ชีเย, แน ยา วี่ไซป้านญา บย่า ย้า จา แง. พาจาว แน ชฺ้าง อางอีบ่าอ่า เย ยางนา นืงบาจาบ คูแง. ");
INSERT INTO bzi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","ก่าซ้าดยอคา ทิเบริอัส ประเทศ โรม ฮูพลา ล้าย 15 ปี เคิน ยาว, พาจาวจี่ต่าง ยอห์น เศคาริยาห์ อางย่าย่าค่า ซ่องก่อง อางเว่อ เวอ ดื้ง ชี มางก้อง เคอ ลือ ชี. แฮ้ญ่าม เมอ ผู้ว่า ปอนทิอัส ปีลาต ยูเดีย แควน แฮ้ง ฮูพลา แง. ก่าซ้าด เฮโรด กาลิลี แควน แฮ้ง ฮูพลา แง. ผู้ว่า ฟีลิป เฮโรด อางแพ้ ม้าย่า อิทูเรีย แควน แน ตราโคนิติส แควน แฮ้ง ฮูพลา แง. ผู้ว่า ลีซาเนียส อาบีเลิน แควน แฮ้ง ฮูพลา แง. ยาว แฮ้เมอ อันนาส แน คายาฟาส เย่ด ปุโรหิต ยอคา เพล่อ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","แฮ้งเย่ ยอห์น อ่อกแอ, ชฺ้าง จอร์แดน ล้างบ้า ก่องทาง กูต่องกูตี่ เวอ ดื้ง คูชี อือนา นี้แม้แน ป่าว ม่า แอ ชี, “อางบล่าบ ฮา แฮ้ง ว่าง ยาว นืงบา อางซฺื่อ เพ่น แล่ โว! ยาว ล้างตือพิธีบัพติศมา ฮา แล่ คู โว! ยาว พาจาว มาง นองนา อางซีอางบล่าบ บ่ายู่ ล่า!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ยอห์น อางเลิ่ง นี้ย่า ค้าแต้ เวอ พาจาวจี่ต่างจี่แต่นฮู อิสยาห์ มอ ยาว, พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี เป, “ชฺ้าง แฮ้ม้า ซ่องก่อง อางเว่อ โย้เวอ นี้แม้แน ป่าว แง, ‘จี่วีดอางซื้ง มาง อามือ ชาลือ แง. ปีนแตปีนนา แน ยาง เคอ ลือ แฮ้นืง นา ล่อ คูโว. ค่องช่าง อือ ก่าซ้าด มาง ชา ล้า เมอ แก้บ้า แต่ง ล่อ แฮ้งแม้แน. ");
INSERT INTO bzi_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ตาแซ้อางฮ่อง คาโคลาโค โย้เวอ นื้งชฺ่า แฮ้ง ปลื้ง แน ทูม โว. ตาแซ้ คาโคลาโค ตีอางเป้ง แต่ง เพล่อ ปี่ โว. แก้บ้า อางง่อย อือนา แก้บ้า ปล้องไว แน แต่ง เพล่อ ปี่ โว. แก้บ้า บ่าแม่น นื้งชฺ่า บ่าเป่ง อือนา แก้บ้า อางแม่น นื้งชฺ่า อางเป้ง แต่ง เพล่อ ปี่ โว. ");
INSERT INTO bzi_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ยาว ชฺ้าง คาโคลาโค อืม พาจาว มาง ยองนา ปล่องปูน ปี่ชี่ แฮ้ง กงาแบ กงามย้าง แง.’” ");
INSERT INTO bzi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ยอห์น ชฺ้าง ยางก้อง ล้างตือพิธีบัพติศมา ฮา ล้า ชี อือนา จี่ช่าง เย นี้แม้แน, “นอ อื้อล้าง อางปีด อือ ช้อด ย้า! นองนา บ้าเจอซ่าง ม่า พาจาว มาง วี่บ่ากไจ ปี่ ล่าง แฮ้ง ฮื่น ปี่ ล่าแง? ");
INSERT INTO bzi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ฮายฮู ปี่ล่าวแล นอ อางบล่าบ ฮา แฮ้ง ว่าง ยาว, นืงบา อางซฺื่อ เพ่น แล่ คูชี แน. นอ บ่าเย่ง คู โจ นอ อับราฮัม อางอ่านอางซฺื้อ, ยาว วี่บ่ากบ่ากงาไจ คู แน, กงา ม่าแบ ปี่ ล่าว่า พาจาว ม้า นู้เวอ ลอบาซื่อ นี้อือนา, อับราฮัม อางอ่านอางซฺื้อ ฮาย เพล่อ ปี่ เวิม อางกงา ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","พาจาว ม้า ชฺ้าง มู่ย ท้าม แล่ชี่ มาง ช้อดย้า. ยา ซื่งซื่อล่างซื่อ อางจฺื้ง คาโคลาโค อางซื่อ บ่าซื่อ อือนา ชา เตยเลิง แง, แน กอย บี่ท่อ เวอ ปูม แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","แฮ้งเย่ ค่องช่าง อืม นี้แม้แน น้าท้าม คูชี, “ท้าว กงูนา บ้าเจอล้อแม้ ฮา ปี่ ล่า แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ยาว ยอห์น ม่า ชี นี้แม้แน, “อ่าซ่าง ก้อง ค่าลาว 2 โต จา แง, ฮาก ชฺ้าง ค่าลาว ตูม เซฺ่อ บ่าจา อือนา ทื่อโต เปิ่ง ปี่ โว. ยาว อ่าซ่าง เมอ จฺ่าเกิ่ง จา แง, ค่าลาว เปิ่ง กาง ป้าค้า ย้า ฮากนา เปิ่ง ปี่ โว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ชฺ้าง ภาษีกอฮู อือ คาตา เย ลือ ล้างตือพิธีบัพติศมา ฮา ลือ ชี, ยาว ยอห์น นา น้า คู เย นี้แม้แน, “อ่าจาน เวอ, กงู นา บ้าเจอล้อแม้ ฮา ปี่ ล่าง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ยาว ยอห์น ยองนา ม่า ชี นี้แม้แน, “นอง ภาษี กอ เมอ, กง่าเกิ้ง แน กอ โว. ยาว ภาษี อางฮู่ ม้าม้า กอ กาโน” แน. ");
INSERT INTO bzi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ตาฮ้าน ทื่อบ่า อือ ยอห์น นา นี้แม้แน น้า ชีเย, “ท้าว กงูนา ล้อแม้ ฮา ปี่ ล่าแง?” แน. ยอห์น ยองนา นี้แม้แน ม่า ชีเย, “นอง ล่ากานว่าฮู่ นี้ นืงบาจาบ คู โว. ฮาก พลู้ บ่ากง่าบ่าเกิง แน บ่ายู กว่า โจ, แน ฮากนา อางไล้ บ่าจี่กาน กว่า โจ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ค้าแต้ เวอ พาจาวจี่ต่างจี่แต่นฮู อือ นี้แม้แน จี่ ชี ชีเย, พาจาว ม้า ยาง ชฺ้าง แช้ ก่าซ้าด เพล่อ ชี มาง นา ซฺาลือ ปี่ ยาว, ยิวชฺ้าง อือนา ปล่อง ลือ ปี่ แง. แฮ้งเย่ ค่องช่าง อืม เย้ง คูแง, ยอห์น พาจาว มาง แช้ ก่าซ้าด เพล่อ ปี่ชี่ มาง นาตู้ แน. ");
INSERT INTO bzi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","แฮ้งเย่ ยอห์น ยองนา นี้แม้แน ม่า ชี, “กงา นองนา ล้าง แฮ้ง ไจ พิธีบัพติศมา ฮา ปี่ ล่าแง. จ้า พาจาว ม้า ชฺ้าง ทื่อม่าง ซฺาลือ ปี่ แง. ยาว ชฺ้าง แฮ้ม้า กงา ล่อบ่าปา ล่าที่ ฮื่อ แง. กงา อางโต นี้ย่า ยางนา แค้บ ล่าตื่อ พื้อ ปี่ เวิม บ่าซูม. ยา นองนา บี่ท่อ แน อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง ไจ พิธีบัพติศมา ฮา ปี่ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ยาง ล่าปู่ แฮ้ย่า ปยางวี ท่าม แล่ยาว, กอล่าว ชีแฮ้ง เซฺิ่งซฺ้าง แน ปยาง ยาว, กอ อางค่าว แน กอ อางม้า แฮ้ง เปิ่งอ่อก ลางกา ปี่ง แง. กอ อางม้า แฮ้ย่า กอโชง เวอ กอ ชี แง, ยาว กอ อางค่าว แฮ้ บี่ท่อบี่ปู่ม ซฺู่นืง บ่าจา โย้เวอ ฮ้าน พี แอง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ยอห์น พาจาว มาง อางเลิ่ง อางแม่น แฮ้ง ชฺ้าง อือนา ป่าว ม่า เมอ, ยา ยองนา อางเลิ่ง ไลเลิ่ง ย้าเย่ จี่เพ้ก น้า ปี่ชี่, ไม้ ยองนา นืงบาเพ่น อางบล่าบ ฮา แฮ้ง ว่าง ปี่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ยอห์น ก่าซ้าด เฮโรด กาลิลี แควน ฮูพลา มางนา จี่ ชีเย, ไม้ ก่าซ้าด เฮโรด ยาง อางแพ้ มาง ค่าบา อางอ้าน อางเม้ง เฮโรเดียส แน ชี่ มางนา ยู้ ชีเย, แน อางเลิ่ง บ่าแม่น ไลเลิ่ง ย้าเย่ ฮา ชี. ");
INSERT INTO bzi_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ยาว อ่าจ่าม ก่าซ้าด เฮโรด แฮ้ล่อบ่าปา เย่ อางเลิ่ง บ่าแม่น ทื่อเลิ่ง ฮา แล่ชี่. ยา ยอห์น นา คอก ชู ล้อง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ค่องช่าง อือ ล้างตือพิธีบัพติศมา ฮา ล้า เมอ, พระเยซู คาตา เย่ ฮา ล้า ชี. ยาว พระเยซู อธิษฐาน ฮา เมอ, มู่ง ย่าง พอง ล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ยาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง, ฮาย่า อางป่อน แม้แน แต่ง แล่ยาว พระเยซู ก้อง ปย้าม แป่ก ลือ ชีเย. ทื่อชี่ด ยาว พาจาว มาง อางเซง ย่าง มู่งท่า โย้เวอ จาย บื้ง ลืน ชีเย นี้แม้แน, “ค่า เวอ, นา อ่าโบ้ง อางย่า ลาก มาง ย้า. อ่าโบ้ง นางนา นาบาตา นืงบาจาบ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","พระเยซู ล่ากาน ต้าง ว่า เมอ อ่าญู 30 ปี เย่. ค่องช่าง อือ เย้ง คู แง พระเยซู โยเซฟ อางย่าย่าค่า แน. โยเซฟ เฮลี อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","เฮลี มัทธัต อางย่าย่าค่า, มัทธัต เลวี อางย่าย่าค่า, เลวี เมลคี อางย่าย่าค่า, เมลคี ยันนาย อางย่าย่าค่า, ยันนาย โยเซฟ อางย่าย่าค่า. ");
INSERT INTO bzi_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","โยเซฟ มัทธาธีอัส อางย่าย่าค่า, มัทธาธีอัส อาโมส อางย่าย่าค่า, อาโมส นาฮูม อางย่าย่าค่า, นาฮูม เอสลี อางย่าย่าค่า, เอสลี นักกาย อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","นักกาย มาอาท อางย่าย่าค่า, มาอาท มัทธาธีอัส อางย่าย่าค่า, มัทธาธีอัส เสเมอิน อางย่าย่าค่า, เสเมอิน โยเสค อางย่าย่าค่า, โยเสค โยดา อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","โยดา โยอานัน อางย่าย่าค่า, โยอานัน เรซา อางย่าย่าค่า, เรซา เศรุบบาเบล อางย่าย่าค่า, เศรุบบาเบล เชอัลทิเอล อางย่าย่าค่า, เชอัลทิเอล เนรี อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","เนรี เมลคี อางย่าย่าค่า, เมลคี อัดดี อางย่าย่าค่า, อัดดี โคสัม อางย่าย่าค่า, โคสัม เอลมาดัม อางย่าย่าค่า, เอลมาดัม เอร์ อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","เอร์ โยชูวา อางย่าย่าค่า โยชูวา เอลีเยเซอร์ อางย่าย่าค่า เอลีเยเซอร์ โยริม อางย่าย่าค่า โยริม มัทธัต อางย่าย่าค่า มัทธัต เลวี อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","เลวี สิเมโอน อางย่าย่าค่า, สิเมโอน ยูดาห์ อางย่าย่าค่า, ยูดาห์ โยเซฟ อางย่าย่าค่า, โยเซฟ โยนาม อางย่าย่าค่า, โยนาม เอลียาคีม อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","เอลียาคีม เมเลอา อางย่าย่าค่า, เมเลอา เมนนา อางย่าย่าค่า, เมนนา มัทตะธา อางย่าย่าค่า, มัทตะธา นาทัน อางย่าย่าค่า, นาทัน ดาวิด อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ดาวิด เจสซี อางย่าย่าค่า, เจสซี โอเบด อางย่าย่าค่า, โอเบด โบอาส อางย่าย่าค่า, โบอาส สัลโมน อางย่าย่าค่า, สัลโมน นาโชน อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","นาโชน อัมมีนาดับ อางย่าย่าค่า, อัมมีนาดับ อัดมิน อางย่าย่าค่า, อัดมิน อารนี อางย่าย่าค่า, อารนี เฮสโรน อางย่าย่าค่า, เฮสโรน เปเรศ อางย่าย่าค่า, เปเรศ ยูดาห์ อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ยูดาห์ ยาโคบ อางย่าย่าค่า, ยาโคบ อิสอัค อางย่าย่าค่า, อิสอัค อับราฮัม อางย่าย่าค่า, อับราฮัม เทราห์ อางย่าย่าค่า, เทราห์ นาโฮร์ อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","นาโฮร์ เสรุก อางย่าย่าค่า, เสรุก เรอู อางย่าย่าค่า, เรอู เปเลก อางย่าย่าค่า, เปเลก เอเบอร์ อางย่าย่าค่า, เอเบอร์ เชลาห์ อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","เชลาห์ ไคนาน อางย่าย่าค่า, ไคนาน อารฟาซัด อางย่าย่าค่า, อารฟาซัด เชม อางย่าย่าค่า, เชม โนอาห์ อางย่าย่าค่า, โนอาห์ ลาเมค อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ลาเมค เมธูเสลาห์ อางย่าย่าค่า, เมธูเสลาห์ เอโนค อางย่าย่าค่า, เอโนค ยาเรด อางย่าย่าค่า, ยาเรด มาหะลาเลล อางย่าย่าค่า, มาหะลาเลล ไคนาน อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ไคนาน เอโนช อางย่าย่าค่า, เอโนช เสท อางย่าย่าค่า, เสท อาดัม อางย่าย่าค่า, อาดัม พาจาว มาง อางย่าย่าค่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","พระเยซู จอร์แดน ล้างบ้า เวอ ล้างตือพิธีบัพติศมา ฮา แล่เปิน ยาว, ยางก้อง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ย้าง ปลื้ง ย้า จา แง. ยาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ยางนา ซ่องก่อง อางเว่อ โย้เวอ ซฺื่ย แลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","พระเยซู ซ่องก่อง อางเว่อ โย้เวอ ดื้ง แล เมอ, ซาตานแด่ย่ายอคา มาง พระเยซู นา 40 นืง เย นืงบาเจ้อฮู ชี. 40 นืง นู้ย่า ยา เจิ้นเจ้อ บ่ากงา จฺ่า เย. ยาว 40 นืง ปูน ยาว, พระเยซู นาบาตา เย แบ่ซฺู่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ซาตานแด่ย่ายอคา มาง พระเยซู นา นี้แม้แน น้า ชีเย, “จาว่าแน นาง พาจาว มาง อางย่า ม้าม้า แน ยาว, ลอบา ซื่อ นี้ง ม่าย จฺ่าเกิ่ง เพล่อ ปี่ โว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","จ้า พระเยซู นี้แม้แน พอ ชีเย, “พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี, ‘ชฺ้าง จี่วีดม้าม้า จา แล นี้ย่า จฺ่าเกิ่ง จฺ่าต้าง แฮ้ง ปาปาย แอ่ แน บ่าอ่า’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ยาว ซาตานแด่ย่ายอคา มาง พระเยซู นา ตี อางมอง เวอ ซฺื่ย แลน ชี. ยาว พระเยซู นา ชฺ้างอางเมิง เวอ อางเมิง คาโคลาโค แฮ้ง ทื่อชี่ด แน ฮายมย้าง ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ยาว ซาตานแด่ย่ายอคา มาง พระเยซู นา นี้แม้แน จี่ช่าง ชีเย, “กงา นางนา ล่าที่ นี้อือ แน ชฺ้างอางเมิง นู้เวอ ตี คาโคลาโค จา นี้อือ ปี่ ล่าแน, ไม้ กูย่างกูเจ้อ นี้อือ กงา เฮอ นอ. แน กงา อ่าซ่าง นา ปี่ ซี่ง แง, แฮ้มางนา ย้า ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","จาว่าแน นาง กงานา บอกไว้ ล่ายาว, ชฺ้างอางเมิง นู้เวอ ตี คาโคลาโค จา นี้อือ นาง เฮอ เพล่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","พระเยซู ซาตานแด่ย่ายอคา มางนา นี้แม้แน พอ ชีเย, “กงา นาง ม่า ล่าง แม้แน บ่าฮา, ไม้ พระคัมภีร์ เวอ แต้ม ชี นี้แม้แน, ‘นา จี่วีดอางซื้ง นาง พาจาว มางนา ทื่อม่าง ญา กงาบอกไว้ แง’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","จายล้า แล่ ยาว, ซาตานแด่ย่ายอคา มาง พระเยซู นา เยรูซาเล็ม อางเมิง เวอ ซฺื่ยแลน ชีเย. ยาว โบสถ์อางฮื่อ ตู่ตีน อางมอง เวอ ซฺื่ย จูง แล ชีเย. ยาว ยาง มือ พระเยซู นา ตาจ่าง เย นี้แม้แน, “จาว่าแน นาง พาจาว อางย่า มาง ม้าม้า แนยาว อางอ่อก โย้เวอ เปิก ลู่งแอน โว, ");
INSERT INTO bzi_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ไม้ พระคัมภีร์ เวอ แต้ม ชี ชี นี้แม้แน, ‘พาจาว ม้า ยาง เท่วาด่า อือนา ม่า ยาว นางนา ฮูพลา ปี่ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ยาว ยาง เท่วาด่า อืม นางนา อาม ชี ล่าง, นาง ล่าคื่อ แฮ้งนา ลอบา เวอ บ่าปี่ กงาง แน.’” ");
INSERT INTO bzi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","จ้า พระเยซู ซาตานแด่ย่ายอคา มางนา นี้แม้แน พอ ชีเย, “พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี, ‘พาจาว ค่าตอง จี่วีดอางซื้ง มางนา นืงบาบ่าเจอ ฮู โจ’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ซาตานแด่ย่ายอคา มาง พระเยซู นา กูเจ้อ แน นืงบาเจ้อฮู เปิน ยาว, เจิ่ก แลน ชีเย. ยาว ยาง อางญ่าม ซฺ้า ทื่อเทอ ลือ แล่ง เย่. ");
INSERT INTO bzi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","พระเยซู กาลิลี แควน เวอ พ่าว แลน ชีเย. พระเยซู ก้อง ล่าที่ อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ย่าง ปลื้ง ย้าเย่ จา แง. แน ยาง อางเลิ่ง ย่าง กาลิลี แควน เวอ จ่อด ย้าเย่ ฮาก แบ โค ชี. ");
INSERT INTO bzi_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ยาว พระเยซู ยิวชฺ้าง โบสถ์ โย้เวอ ม่าอู่บ ดื้ง ชีเย, ยาว ชฺ้าง คาโคลาโค อืม ยาง ม่าอู่บจี่ต่าง แฮ้ง กงากย่า คู ยาว ยางนา ซอ เย. ");
INSERT INTO bzi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ยาว พระเยซู นาซาเร็ธ ค่อง เวอ แอน ชีเย, ค่อง นู้ เย่ ยาง ค่อล้า ชี ย่าง. ลองนืง เคิน ยาว, พระเยซู ยิวชฺ้าง โบสถ์ เวอ แล ชี กูเทอ แม้แน. ยาว พระเยซู ทา จูง พระคัมภีร์ ชา อ้าน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","แฮ้งเย่ ยิวชฺ้าง โบสถ์ ยอคา มาง อิสยาห์ ปาบ ยอ ย่าง พระเยซู นา ปี่ ชีเย. อิสยาห์ พาจาวจี่ต่างจี่แต่นฮู เย่. ยาว พระเยซู ปาบ ยอ ย่าง พื้ออ่อก ชี, ไม้ จี่ต่าง นี้แม้แน แต้ม ชี ชี แฮ้ง ซฺ้า เย่, ");
INSERT INTO bzi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“จี่วีดอางซื้ง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ม้า กงาก้อง ดื้ง แง. ไม้ พาจาว มาง กงานา ต้างแต่ง อางเลิ่ง อางแม่น แฮ้ง ชฺ้าง อางตูก อือนา ม่ายแบ ปี่ ล่าง. พาจาว ม้า กงานา ซฺาลือ นักโทษ อือนา ม่า ปี่ ล่าง ยอ กงาปูน แงแน. ยาว ชฺ้างแมปอ อือนา ม่า ปี่ ล่าง ยอ ฮู มย้าง แงแน. ยาว ชฺ้าง ย่าเจ่น เพล่อ อือนา ม่า ปี่ ล่าง ยอ ย่าเจ่น กงาปูน แงแน. ");
INSERT INTO bzi_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ยาว จี่วีดอางซื้ง มาง ยาง ชฺ้าง อือนา ปล่อง ลืง ย้าง, อางญ่าม เคิน ญา แน ม่า แงแน.” ");
INSERT INTO bzi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ยาว พระเยซู ปาบ ย่าง ยอ ยาว ชฺ้าง ฮูพลาฮู มางนา คื่น ปี่ ชีเย. ยาว พระเยซู ดื้ง ลือ ชีเย. ยาว ชฺ้าง คาโคลาโค ยิวชฺ้าง โบสถ์ โย้เวอ จา อืม พระเยซู นา ฮู คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ยาว พระเยซู ยองนา จี่ช่าง ชี นี้แม้แน, “พระคัมภีร์ เวอ อางเลิ่ง กงา นองนา อ้าน น้า ปี่ ล่า ชี่ นี้ย่า, มี้นืง ม้าม้า ย้า ตอล้า แง.” ");
INSERT INTO bzi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ยาว ชฺ้าง คาโคลาโค อืม พระเยซู นา โญกจ่าญ่อจ่า คู ชีเย, แน ยาง ม่าอู่บจี่ต่าง แฮ้งนา นืงบาม่าน คูง เย่, ยาว ยอง น้า กางเย นี้แม้แน, “นี้ม้า โยเซฟ อางย่า มาง อ่าลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ยาว พระเยซู มือ จี่ ชีเย นี้แม้แน, “นอ นี้แม้แน จี่ต่างเพ้กเต้ม แฮ้ง กงานา ชา ม่า ล่าง ล้า, ‘มอ ม้าม้า นี้ย้า ค่าตอง นา อางยา จ่าแล กงากา’ แน. ทื่อช่างกานญา นอย่า กงา คาเปอรนาอุม อางเมิง โย้เวอ, อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ชี แฮ้ง กงู ค่อง นู้เวอ ฮา ปี่ ล่าง ซี่ง แง. ");
INSERT INTO bzi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","จ้า กงา อางเลิ่ง ม้าม้า ม่ายแบ ปี่ ล่าว่า นี้แม้แน, พาจาวจี่ต่างจี่แต่นฮู นี้ย่า ทื่อม่าง แนม บ่าจา, ค่าตอง ค่อง เวอ ค่องช่าง อือ นาบทื้อ แงแน. ");
INSERT INTO bzi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“ค้าแต้ เวอ พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ จี่วีดแต่จา เมอ ฮู ปาว, อิสราเอล โย้เวอ มู่งฮ่อ บ่าลือ แน 3 ปี 6 ลา เย, แน ต้าว ย้าเย่ กือคาก จฺื่งคู คูแง. อิสราเอลชฺ้าง มู โย้เวอ แมม้าย อางบย่า เย่ จา แง. ");
INSERT INTO bzi_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","จ้า พาจาว ม้า พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ นา, อิสราเอลชฺ้าง แมม้าย อือนา บ่ากงา ปล่องแอ ปี่ เย่. จ้า พาจาว ม้า พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ นา แมม้าย ทื่อม่าง อิสราเอล บ่าอ่า มางนา ปล่อง แอ ปี่ ชีเย, ศาเรฟาท อางเมิง ไซดอน แควน โย้เวอ. ");
INSERT INTO bzi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","พาจาวจี่ต่างจี่แต่นฮู เอลีชา จี่วีดแต่จา เมอ ป้าค้า ย้าเย่, อิสราเอลชฺ้าง อือ อางบย่า ย้าเย่ คี้ตู้ด เพล่อ ชี. จ้า พาจาว ม้า เอลีชา นา, อิสราเอลชฺ้าง คี้ตู้ด เพล่อ ชี อือนา บ่ากงา ปล่อง ปี่ เย่. จ้า พาจาว ม้า เอลีชา นา, นาอามาน ซีเรียชฺ้าง มางนา ปล่อง แอ ปี่ ชีเย” แน. ");
INSERT INTO bzi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ค่องช่าง ยิวชฺ้าง โบสถ์ โย้เวอ จา ชี อือ กงากย่า ยาว, นาบาตา เย นืงบาค่า คูแง. ");
INSERT INTO bzi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ยาว ยองมือ ทาล้า โค ยาว, พระเยซู นา เซฺย ตาแซ้พยางพยาง โย้เวอ ชา ต่าน คลา แงแน. ");
INSERT INTO bzi_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","จ้า พระเยซู ชฺ้าง อางมู โย้เวอ ย่อ ฮื่น ปูน แล่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","พระเยซู คาเปอรนาอุม อางเมิง กาลิลี แควน โย้เวอ แอน ชีเย, ยาว ยาง กูนืง ย้าเย่ ค่องช่าง อือนา ลองนืง เวอ ม่าอู่บ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ค่องช่าง อือ พระเยซู ม่าอู่บจี่ต่าง แฮ้งนา นาบาตา นืงบาม่าน คูง เย, ไม้ ยา พาจาว มางก้อง ล่าที่ ม้าม้า จายลือ ชี แฮ้ง ไจ ม่าอู่บ นอ. ");
INSERT INTO bzi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","แฮ้ญ่ามเมอ ค่าพ่าย่า ทื่อม่าง จา เย่. ยางนา แด่ย่า อ่อง ปี่ชี่. ยาว ยาง ยิวชฺ้าง โบสถ์ โย้เวอ ย่อ อ้อง ล้าน ชี. แน นี้แม้แน จี่ โฮ้กฮ้าว ชี, ");
INSERT INTO bzi_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“โอ้! พระเยซู นาซาเร็ธชฺ้าง เวอ, นา กงูนา บ้าเจอฮา ล่าแง? นาง นู้เวอ ล้า ชี นี้ย่า กงูนา ก่างพยา ล่า ล่าง ลา? กงา อางแบ ย้า นา อ่าซ่าง แน. นา พาจาว มาง ชฺ้าง อางเซฺิ่งอางซฺ้าง มาง ย้า!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","จ้า พระเยซู มือ แด่ย่า มางนา นี้แม้แน อี่ ชี, “กยาบ ยาว อ่อกแอน โว!” แน. ยาว แด่ย่า มาง ค่าพ่าย่า มางนา ฮาเลิง แอ ปี่ ยาว ซฺ้อก ย้าเย่ อ่อกแอ ชี, ชฺ้าง อางมู อือ ล้าก้า เวอ ย้าเย่. จ้า แด่ย่า มาง ค่าพ่าย่า มางนา เจิ้นเจ้อ บ่าฮา เย่. ");
INSERT INTO bzi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ยาว ค่องช่าง คาโคลาโค อืม นาบาตา ย้าเย่ นืงบาม่าน คู ชี. ยอ นี้แม้แน จี่กาง เย่, “ยาง จี่ต่าง นี้ย่า นืงบาม่านคาบอล้อ ย้า. ยา ล่าที่ ไจ แด่ย่า มางนา ม่า อ่อกแอ ปี่ชี่. ยาว แด่ย่า มาง อ่อกแอน ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ยาว พระเยซู อางเลิ่ง ย่าง กาลิลี แควน โย้เวอ ต้าว ย้าเย่ ฮาก แบ โค ชี. ");
INSERT INTO bzi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","พระเยซู ยิวชฺ้าง โบสถ์ โย้เวอ อ่อกแอน ชี, ยาว ซีโมน ยู้ม เวอ อ้องแล ชีเย. ยาว ซีโมน ย่อบา มาง นาบาตา เย่, อางม้างกย้า ชี. ค่องช่าง อืม พระเยซู นา ป้า ยา ปี่ คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ยาว พระเยซู ซีโมน ย่อบา มาง ก่องทาง เวอ จูง จี่ ชีเย, อางม้างกย้า โปยว โว แน แฮ้แม้ จี่ ยาว ซฺ้อก ย้าเย่ อางม้างกย้า ย้าง โปยว ชี. ยาว ยาง ทานล้า ยาว พระเยซู แน ยาง ศิษย์ อือนา จฺ่าเกิ่ง แต่ง ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","มู่งคี่ล้าก้า มู่งนื่ง ชา กลา เมอ, ค่องช่าง อือ ชฺ้าง ด้า อือนา ซฺื่ย พระเยซู ก้อง ล้าน คู ชี. ยาว พระเยซู มือ ชฺ้าง อางด้า อือ อางโต โย้เวอ ล่าปู่ โบย ยา ชี, ยาว ชฺ้างด้า อือ พ่าญาด ย่าง โปยว คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ยาว แด่ย่า อือ ชฺ้าง อือ ก้อง อ่อก เมอ, นี้แม้แน จี่โฮ้กฮ้าว คูง เย, “นาย่า พาจาว มาง อางย่า” แน. จ้า พระเยซู แด่ย่า อือนา บ่าปี่ จี่ เย, ไม้ แด่ย่า อือ อางแบ เย่ พระเยซู พาจาว มาง แช้ยู้ ก่าซ้าด เพล่อ ปี่ชี่ มาง แน. ");
INSERT INTO bzi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ซอทา อางด่า เวอ พระเยซู ตีอางกยาบ ชฺ้าง บ่าจา โย้เวอ แลน ชีเย, จ้า ค่องช่าง อืม พระเยซู นา ซฺ้า กว่า ชีเย. จ้า มย้าง ยาว พระเยซู นา บ่าปี่ แอ เย่ ยองก้อง ดื้ง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","จ้า พระเยซู นี้แม้แน จี่ ชีเย, “กงาย่า อางเลิ่ง อางแม่น พาจาว มาง ชฺ้างอางเมิง นู้เวอ, ก่าซ้าด เพล่อ ลืง แฮ้ง ฮาก อางเมิง อือ ก้อง คาตา กงาป่าว กว่า แอ แง, ไม้ พาจาว มาง กงานา ซฺาลือ ปี่ ล่า ชี่นี้, ยา กงานา ล่ากาน นี้มาง ว่า ปี่ ล่าง น้อ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ยาว พระเยซู มือ ยูเดีย แควน ยิวชฺ้าง โบสถ์ อือเมอ ม่าอู่บ กว่า ชี. ");
INSERT INTO bzi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ทื่อนืง จา ชีเย, พระเยซู ลองอองอางฮื่อ อางเม้ง เยนเนซาเรท ก่องทาง โย้เวอ จูง จา เมอ, ชฺ้าง อางอีบ่าอ่า เย พระเยซู ก้อง อ้องแล ปลืงแท่ง ลางกา ชี. ไม้ พาจาว มาง ม่าอู่บจี่ต่าง แฮ้ง น้า คู แงแน. ");
INSERT INTO bzi_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","พระเยซู ล้อง 2 ลาม มย้าง ชีเย, ล้อง แฮ้ ล่องแต่ซฺ้าชฺ้าง อือ ล้อง ย่าง เย่. แน แปฟาง ก่องทาง โย้เวอ จ่อด ชี ชี. ยาว ล่องแต่ซฺ้าชฺ้าง อือ ฮอจื้ง ชี่ จา เย. ");
INSERT INTO bzi_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","แฮ้งเย่ พระเยซู ซีโมน ล้อง เวอ ตา แลน ชี, ยาว ยางนา ม่าย ล้อง แฮ้ง แปฟาง โย้เวอ อางอี้ เว่อ แน ซาด อ่อกแอ ปี่ ชี่. ยาว พระเยซู ล้อง โย้เวอ ดื้ง ชฺ้าง อือนา ม่าอู่บ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","พระเยซู ชฺ้าง อือนา ม่าอู่บ เปิน เมอ, ซีโมน นา นี้แม้แน ม่าย ชีเย, “ล้าง อางน่า โย้เวอ แอน โว! ฮอจื้ง จาน แอ ปี่ ยาว ล่องแต่ ชู โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","จ้า ซีโมน นี้แม้แน พอ ชีเย, “อ่าจาน เวอ, กงู ตื่งคี่ ย้า ล่องแต่ ซฺ้า คู แอ เจิ้นเจ้อ บ่ากงา คู, จ้า นาง ม่ายฮา ปี่ ล่า ยาว กงาม อางซฺื่อ ฮายฮูเจ้อเจ้อ แล่ แน” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ยอง พระเยซู ม่า ชี ป้าค้า ฮา ยาว, ล่องแต่ อางบย่า เย ชู กงา ชี, ฮอจื้ง ย่าง ป้าดจา แช เย. ");
INSERT INTO bzi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","แฮ้งเย่ ยอง มือ ล่องแต่ซฺ้าชฺ้าง อางช่าง ทื่อบ่า อือนา ฮ้าว ม่า ปล่อง ปี่ชี่ เย. ยอง ล่องแต่ กงา คู ชีแฮ้ ล้อง 2 ลาม ย่าง ปลื้ง ย้าเย่, แน ล้อง ย้าง ป้าดจา จู้ม เย. ");
INSERT INTO bzi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ยาว ซีโมน, ฮาก เปโตร แน ฮ้าว มาง แฮ้แม้ มย้าง ยาว, ยาง พระเยซู นา ป่าตูคู บอกไว้ ชีเย. ยาว จี่ เย นี้แม้แน, “อ่าจาน เวอ, กงาก้อง เว่อ แน แอน ปาว, ไม้ กงา ชฺ้าง อางบล่าบ นางก้อง แท้ แน ดื้ง บ่าซูม เป” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ซีโมน นี้แม้แน จี่ นี้ย่า ไม้ ซีโมน แน ยาง อางช่าง อือย่า, ยอง ล่องแต่ บย่า แน ชู กงา ชี แฮ้งนา นืงบาม่าน คูง เย. ");
INSERT INTO bzi_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ยากอบ แน ยอห์น ซีโมน ล่ากานว่าช่าง ม่าง เย่ด คาตา เย นืงบาม่าน ชี. เย่ด เศเบดี อางย่าย่าค่า เย. ยาว พระเยซู ซีโมน นา นี้แม้แน ม่าย ชีเย, “บ่าแค โจ! นู้จาย แล ปี่ นี้ย่า นา ล่องแต่ บ่ากงา ซฺ้า กาน, จ้า นาย่า ชฺ้าง อือนา ซฺื่ย กงานา ซฺ้า ลือ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ยองมู นี้ย่า ล้องตา แปฟาง โย้เวอ เคิน แล คูยาว, กูย่างกูเจ้อ อือ วี โค คู ชีเย. ยาว พระเยซู ก้อง เค่ แอน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","พระเยซู ค่อง ทื่อค่อง เวอ จา เมอ, ค่าพ่าย่า ทื่อม่าง จา ชีเย, ยาง อางโต คาโคลาโค แฮ้ย่า คี้ตู้ด จฺ่า โค ชีเย. ยาง พระเยซู นา มย้าง ยาว บอกไว้ ชีเย. ยาว นี้แม้แน ป้า ชีเย, “จี่วีดอางซื้ง เวอ, กงานา ยา ล่าปาว. กงา อางแบ ย้า จาว่าแน นาง กงานา อางปล่อง ล่าซี่ แน ยาว, นา กงานา ยา พ่าญ่าด โปยว ปี่ ล่า อางกงา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","แฮ้งย้า พระเยซู มือ ยาง ล่าปู่ ย่าง กลาง ชฺ้าง คี้ตู้ด มางนา ว่า แอ ชี ยาว นี้แม้แน จี่ ชี, “โอ่ย! กงา นางนา ปล่อง ล่า ซี้ แง. นาง พ่าญาด นี้ง โปยว โว!” แน. ยาว ยาง คี้ตู้ด ย่าง ซฺ้อก ย้าเย่ โปยว ชี. ");
INSERT INTO bzi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ยาว พระเยซู มือ นี้แม้แน ม่าย ชีเย, “อ่าซ่าง มางนา บ่าอู่บ น้า ปี่ โจ, จ้า ปุโรหิต มางนา ฮู แอ ปี่ โว. แน อางเกิ่งท่านเซฺ่อ แฮ้ง ท่าน โว, โมเสส ชฺ้าง คี้ตู้ด เพล่อ ยาว โปยว ชี อือนา ม่าย ฮา ปี่ชี่ แฮ้งแม้แน, ไม้ ชฺ้าง คาโคลาโค อือนา แบ ปี่ง น้อ, นาง พ่าญ่าด นี้ย่า โปยว ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","พระเยซู ยางนา บ่าปี่ จี่ เวิม, ยาง อางเลิ่ง แฮ้ ค้าแจ้ กา เย ฮาก แบ แอ แง. แฮ้งย้า ค่องช่าง อือ อางบย่า เย พระเยซู ม่าอู่บ แฮ้งนา น้า คู แง, ยาว พ่าญาด อางด้าอางกย้าง อือ ยา แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","จ้า พระเยซู อางเลิ้ง กา เย ตี อางกยาบ อือเมอ แอ อธิษฐาน ฮา แอ แง. ");
INSERT INTO bzi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","แฮ้ญ่าม เวอ, พระเยซู ม่าอู่บ ดื้ง เมอ, ฟาริสี อือ แน อางลี้บอางล่าว ม่าอู่บฮู อือ จา เย. ยอ กาลิลี แควน ยูเดีย แควน แน เยรูซาเล็ม อางเมิง เวอ จายล้า ชี. แน จี่วีดอางซื้ง มาง พระเยซู นา ล่าที่ พ่าญาด ยา โปยว ปี่ง ย่าง ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ยาว ชฺ้าง ทื่อบ่า อืม ชฺ้าง ต่องแก่ มางนา อ่าเพ่น เวอ ยู่ ปี่ ยาว ซฺื่ย ล้าน ชี. ยาว ยู้ม คล้าว โย้ ชา อ้องแล คูง เย, ไม้ พระเยซู ล้าก้า โย้เวอ ซฺื่ย ชี แลง เย. ");
INSERT INTO bzi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","จ้า ยองมู นี้ย่า ชฺ้าง ต่องแก่ มางนา, พระเยซู ก้อง แท้ แน บ่าซฺื่ย อ้องแล กงากา, ไม้ ชฺ้าง นาบาตา บย่า. แฮ้งย้า ยอง มือ พระเยซู ดื้ง ชี แฮ้ต้าด เวอ ยู้มมู้ง แฮ้ง พอง อ่อก ชี. ยาว ชฺ้าง ต่องแก่ มางนา อ่าเพ่น โย้เวอ ยู่ ปี่ ยาว, กล่ามกล่าม แน พระเยซู ก้อง คลา ลู่ง แอ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","พระเยซู ยอง เจ่อ แฮ้งนา มย้าง ยาว จี่ เย นี้แม้แน, “อางช่าง เวอ, กงา นางนา อางซีอางบล่าบ บ่ายู่ ล้าก้าน” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","อางลี้บอางล่าว ม่าอู่บฮู แน ฟาริสี อือ นืงบา เวอ เย้ง เย, “ชฺ้าง นี้ม้า อ่าซ่าง บ้าเจอ ยา นี้แม้ อางจี่ แน? ไม้ ชฺ้าง อือนา อางซีอางบล่าบ บ่ายู่ นี้ย่า พาจาว มาง ญา ฮาย กงา กาแง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","จ้า พระเยซู อางแบ เย่ ยอง นืงบา โย้เวอ บ้าเจอ เย้ง คูแง แน. แฮ้งเย่ ยางมือ จี่ แง นี้แม้แน, “บ้าเจอ นอ นี้แม้ อางเย้ง คู แน? ");
INSERT INTO bzi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","กงานา ชฺ้าง ต่องแก่ นี้มางนา บ้าเจอล้อแม้ จี่ช่าง ปี่ ล่าง, ‘กงา นางนา อางซีอางบล่าบ บ่ายู่ ล้าก้าน’ แน จี่ ปี่ ล่าง ล้า. อ้าว ‘ทานล้า โว ย่อ แลน ปาว’ แน จี่ปี่ ล่าง ล้า. บ้าเจอล้อแม้ จี่ แฮ้ง ไง่ แล่แง? ");
INSERT INTO bzi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","กงา นองมู นา ฮาย มย้าง ปี่ ล่าว่า, กงาชฺ้างอางย่า นี้ม้า ล่าที่ อางจา, ชฺ้างอางเมิง นู้เวอ อางซีอางบล่าบ อือ บ่ายู่ เวิม อางกงา.” ยาว พระเยซู มือ ชฺ้าง ต่องแก่ มางนา จี่ช่าง ชี, “ทานล้า ปาว ยาว อ่าเพ่น นี้ง กอ ยาว ยู้ม เวอ พ่าว แลน ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ยาว ซฺ้อก ย้าเย่ ชฺ้าง ต่องแก่ มางมือ ทานล้า ยาว, อ่าเพ่น ย่าง กอย ยู้ม เวอ ย่อ แอน ชี แน พาจาว มางนา สรรเสริญ ฮา ชี. ");
INSERT INTO bzi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ค่องช่าง อือ มย้าง เมอ นืงบาม่าน แค คูยาว, พาจาว มางนา สรรเสริญ ฮา คู ชีเย. ยาว จี่ เย นี้แม้แน, “กงู มี้นืง อางเลิ่ง นืงบาม่าน ปี่ง อือ กงามย้าง แอ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","แฮ้แม้ ฮาย ยาว, พระเยซู ย่อ ค่อง อางเง้ เวอ อ่อกแอน ชี, ยาว ชฺ้าง ภาษีกอฮู อางเม้ง เลวี ฮาก มัทธิว แน ฮ้าว มางนา มย้าง ชี. ภาษี กอย้า โย้เวอ ดื้งจา เย. พระเยซู ยางนา จี่ช่าง เย นี้แม้แน, “กงาก้อง เค่ ลาน ยาว กงา ศิษย์ เพล่อ ปาว!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","เลวี ทานล้า ยาว กูเจ้อ ย้าเย่ ชีช่าชี่ ยาว ยาง พระเยซู ก้อง เค่ แล ชี. ");
INSERT INTO bzi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ยาว เลวี พระเยซู นา ยาง ยู้ม โย้เวอ ฮ่างปอ เมอ, ค่องช่าง อือ แน ชฺ้าง ภาษีกอฮู อางอีบ่าอ่า เย, พระเยซู ก้อง ทื่งกง่า แน ฮ่างจฺ่า ดื้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ฟาริสี แน อางลี้บอางล่าว ม่าอู่บฮู อือ พระเยซู ศิษย์ อือนา จี่จ่าบ น้า ปี่ น้าว, “บ้าเจอ นอ คื่อ แฮ้อือก้อง ทื่งกง่า แน ฮ่าง อางจฺ่า ดื้ง แน” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","พระเยซู มือ ยอง จี่ แฮ้ง กงากย่า ยาว ยาง มือ ยองนา นี้แม้แน พอ ชี, “ชฺ้าง บ่าด่าบ่ากย่าง อือย่า มอ นา บ่ากงา ซี้, จ้า ชฺ้าง อางด้าอางกย้าง อือย่า มอ นา กงา พ่าญาด ยา แล่ซี่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","กงา ชฺ้าง ฮาก นาบทื้อ คูชี อือนา ซฺ้า ลือ แง บ่าอ่า, จ้า ชฺ้าง อางบล่าบ ฮาก บ่านาบบ่าทื่อ อือนา ซฺ้า ลือ แง, ไม้ ยองนา นืงบาเพ่น อางบล่าบ ฮา แฮ้ง ว่าง ปี่ แง แนนอ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ยาว ยองมู ย่าง พระเยซู นา จี่ช่าง เย นี้แม้แน, “ยอห์น ศิษย์ อือ แน ฟาริสี ศิษย์ อือย่า, อางเลิ้ง กาย้า ฮ่างจฺื่ง อธิษฐาน ฮา แง. จ้า บ้าเจอ นาง ศิษย์ อือ บ่าฮา คู แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","พระเยซู มือ นี้แม้แน พอ ชีเย, “นอย่า ชฺ้าง ค่าบาล่า ล่ากาน เวอ ล้า คูชี อือนา, ฮ่าง จฺ่าเกิ่ง บ่าจฺ่า แน พ่าว แอ แล่ ปี่ง ลา? นอ นี้แม้แน บ่าฮา อ่าลา? เจ้าบ่าว มาง ยองก้อง ทื่งกง่า แน ดื้ง เมอ, ยองมู นี้ย่า ฮ่างบ่าจฺื่ง เป. ");
INSERT INTO bzi_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","จ้า เจ้าบ่าว มางนา ซฺื่ยแล แฮ้นืง เคิน ล้า เมอ, ยองมู แฮ้ง เจ้าบ่าว มางก้อง ทื่งกง่า แน บ่ากงา ดื้ง, แน ยองมู แฮ้ง ฮ่างจฺื่ง คูแง. กงา ศิษย์ อืม ทื่อช่างกานญา, กงา จา เมอ ยอ ฮ่าง บ่ากงา จฺื่ง, จ้า กงา แลน เมอ ยอ ฮ่างจฺื่ง อธิษฐาน กงาฮา คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ยาว พระเยซู มือ ยองนา อางเลิ่ง อู่บ เพ้ก น้า ปี่ชี่, ยาง ม่าอู่บ นี้ย่า ม่าอู่บจี่ต่าง อางซฺื่อ เย่. ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “อ่าซ่าง มาง พ้า อางซฺื่อ แฮ้ง ค่าลาว อางอ้าน เวอ อางต้อง บ่าต่อ, ไม้ พ้า อางซฺื่อ นี้ย่า อี ลู่ง เมอ, ค่าลาว อางอ้าน แฮ้งนา จาก แช ปี่ง. แน อางอ้าน ล่อบ่าปา ย้า อางฮ้อน กลื้อ อ่อกแอ แง. แน พ้า อางซฺื่อ ซี้ แฮ้ง แน พ้า อางอ้าน ซี้ แฮ้ง บ่าตู กา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ยาว พระเยซู มือ ยองนา อางเลิ่ง ทื่อเลิ่ง อู่บ เพ้ก น้า แล่ ปี่ชี่, ยาง ม่าอู่บจี่ต่าง นี้ย่า อ่างู่น แต่ค่า อางซฺื่อ ซ้าด อางคอ ปาไต่ อางซฺื่อ เวอ กาน ชี อือ แม้แน ย้า. ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “อ่าซ่าง มาง อ่างู่น แต่ค่า อางซฺื่อ แฮ้ง ซ้าด อางคอ ปาไต่ อางอ้าน เวอ บ่าท่อก กาน, ไม้ อ่างู่น แต่ค่า อางซฺื่อ นี้ย่า ซ้าด อางคอ ปาไต่ อางอ้าน แฮ้งนา ฮา ปล่าก ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","นี้แม้แนยาว ตื่น อ่างู่น แต่ค่า แน ซ้าด อางคอ ปาไต่ แฮ้ง ก่างพยา แง. ม้าม้า นี้ อ่างู่น แต่ค่า อางซฺื่อ นี้ย่า ซ้าด อางคอ ปาไต่ อางซฺื่อ เวอ กงากาน แง. ");
INSERT INTO bzi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ยาว อ่าซ่าง มาง อ่างู่น แต่ค่า อางอ้าน ต้าง ยาว, แต่ค่า อางซฺื่อ บ่าต่าง แล่ ซี้ กาน. ยาว ยอง นี้แม้แน จี่ คูง เย, อ่างู่น แต่ค่า อางอ้าน นี้ อ่างู่น แต่ค่า อางซฺื่อ ล่อบ่าปา แม่น แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ทื่อนืง จา ชี, พระเยซู แน ยาง ศิษย์ อือ กอแต่ โย้เวอ ย่อ ไก ชีเย. แฮ้นืง ลองนืง เย. ยาว ยาง ศิษย์ อือ นาบาตา ฮ่างแบ่ คูง เย, แฮ้งย้าเย่ ยอง มือ กอน้าม ย่าง เชอ ยาว ช่าจฺ่า คู ชี. ");
INSERT INTO bzi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ฟาริสี มู อือ แฮ้แม้แน มย้าง ยาว ยอง มือ พระเยซู นา นี้แม้แน จี่ เย, “โย้ ฮู ปาว, นาง ศิษย์ อือย่า อามือ ลองนืง อางลี้บอางล่าว โย้เวอ อางซี ฮา คู ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ยาว พระเยซู มือ ยองนา พอ ชีเย นี้แม้แน, “นอย่า พระคัมภีร์ เวอ บ่ากงา อ้าน กางซื้งลา? ก่าซ้าด ดาวิด แน ยางชฺ้าง อือ แบ่ซฺู่ คู เมอ, บ้าเจอล้อแม้ แน ฮา ชี แน? ");
INSERT INTO bzi_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ยา โบสถ์ พาจาว มาง ดื้งย้า โย้เวอ อ้อง แลน ชี. แน พาจาว มางนา ค้านู้มป่าง ท่าน ชี แฮ้ง จฺ่า ชี. กงู ศาสนา อางลี้บอางล่าว นี้ย่า, ปุโรหิต อืน ญา พาจาว มางนา ค้านู้มป่าง ท่าน ชี แฮ้ง จฺ่า กงากา แง. จ้า ก่าซ้าด ดาวิด ค้านู้มป่าง แฮ้ง จฺ่า ชี. อ่าจ่าม มือ ยาง ชฺ้าง อือนา คาตา ย้า เปิ่ง จฺ่า ปี่ชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ยาว พระเยซู ฟาริสี อือนา นี้แม้แน ม่า ชีเย, “กงาชฺ้างอางย่า เพล่อ ชี่ นี้ม้า ล่าที่ อางจา ลองนืง ล่อบ่าปา ฮื่อ แล่ง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ทื่อนืง จา เย ลองนืง เวอ, พระเยซู ยิวชฺ้าง โบสถ์ โย้เวอ ม่าอู่บ เมอ, ค่าพ่าย่า ทื่อม่าง จา เย, ยาง ล่าปู่ ล่าม่า แฮ้ อางแล่บ เย. ");
INSERT INTO bzi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ยาว อางลี้บอางล่าว ม่าอู่บฮู อือ แน ฟาริสี มู อือ ล่อ ฮู คูง เย, พระเยซู อ่าซ่าง นา ลองนืง เวอ ยาจ่า แงแน, ไม้ ยอ พระเยซู นา อางเลิ่ง จี่ เซฺ่อ ซฺ้า เย. ");
INSERT INTO bzi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","จ้า พระเยซู อางแบ เคิด กา เย. ยองมู นี้ย่า บ้าเจอ เย้ง แงแน. ยาว ยา ค่าพ่าย่า ล่าปู่ อางแล่บ มางนา นี้แม้แน จี่ช่าง ชีเย, “ชฺ้าง อางมู ล้าก้า นู้เวอ จูง ล้า โว!” แน. ยาง มือ ฮา เค่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ยาว พระเยซู มือ ชฺ้าง อือนา นี้แม้แน น้า ชี, “กงา น้า ล่า ปานา กงู อางลี้บอางล่าว นี้ย่า, ลองนืง เวอ บ้าเจอ ม่ายฮา ปี่ชี? อางเลิ่ง อางแม่น ฮา ล้า, อ้าว อางเลิ่ง บ่าแม่น ฮา แง? ชฺ้าง นา จี่วีด ปล่อง ล้า, อ้าว ก่างพยา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ยาว พระเยซู ยองมู เวอ ต้าว แน ฮู กว่า น้าว. ยาว ค่าพ่าย่า ล่าปู่ อางแล่บ มางนา จี่ช่าง เย นี้แม้แน, “ล่าปู่ กลาง อ่อก ลือ ปี่ โว!” แน. ยาง ฮายเค่ ยาว ยาง ล่าปู่ อางแล่บ ยาง โปยว ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ยาว อางลี้บอางล่าว ม่าอู่บฮู อือ แน ฟาริสี อือ นาบาตา เย นืงบาค่า ไล้ ชี. ยาว ยอง ม่า ลางกา ชี พระเยซู นา ล้อแม้ ฮา วา แน. ");
INSERT INTO bzi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","จายล้า แล่ยาว บ่ามล่าง, พระเยซู ตาแซ้ เวอ แล อธิษฐาน ฮา แล ชี. ยา พาจาว มางนา ตื่งคี่ ย้าเย่ อธิษฐาน ฮา ดื้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ซอทา เคอ ยาว พระเยซู มือ ยาง ศิษย์ อือนา ฮ้าว ล้า ปี่ นาว. ยาว พระเยซู มือ ชฺ้าง 12 คู่น แช้ยู้ ยาง ศิษย์เอก เพล่อ ปี่ชี่. ยอง อางเม้ง นี้แม้แน เย, ");
INSERT INTO bzi_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ซีโมน (พระเยซู ยางนา เปโตร แน ฮ้าว แง.) อันดรูว์ (เปโตร อางแพ้ มาง) ยากอบ, ยอห์น, ฟีลิป, บารโธโลมิว, ");
INSERT INTO bzi_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","มัทธิว, โธมัส, ยากอบ (อัลเฟอัส อางย่าย่าค่า มาง), ซีโมน (อิสราเอล อางเจ้ออางจาด นา ลาก มาง), ");
INSERT INTO bzi_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ยูดาส (ยากอบ อางย่าย่าค่า มาง), แน ยูดาส อิสคาริโอท (กาญ่าม เวอ พระเยซู นา บ่าแม่น ฮาช่าง มาง) ");
INSERT INTO bzi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","พระเยซู แน ยาง ศิษย์ อือ ตาแซ้ เวอ ลู่ง ลือ ตี อางเป้ง เวอ เคอ ลือ ยาว, ค่องช่าง แน ยาง ศิษย์ อือ อางอีบ่าอ่า เย ยางนา ลือ ซฺ้า ลือ คูชี. ยอย่า ยูเดีย แควน กูต่องกูตี ย้า จายลือ คูชี, เยรูซาเล็ม อางเมิง เวอ คาตา ย้า, แน ทะเล ก่องทาง ไทระ อางเมิง, ไซดอน อางเมิง อือเมอ จายลือ คูชี. ");
INSERT INTO bzi_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ยอง ลา ชี นี้ย่า พระเยซู ม่าอู่บจี่ต่าง แฮ้ง ลือ น้า ลือ คูชี, แน พ่าญาด ยา ลือ แล่ คูชี. ยาว พระเยซู ชฺ้าง แด่ย่า อ่อง ชี อือนา คาตา ย้า แด่ย่า ก่า อ่อก ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ยาว ชฺ้าง คาโคลาโค ย้าเย่ พระเยซู นา ว่าชู คู ชี, ไม้ พระเยซู ก้อง ล่าที่ อ่อก ลือ ชี แฮ้ย่า, ยองนา อางยา โปยว ปี่ กงากา เย. ");
INSERT INTO bzi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","พระเยซู ยาง ศิษย์ อือก้อง ฮู แอ ปี่ ยาว ม่า ชีเย นี้แม้แน, “ชฺ้าง พาจาว มางนา กงา ซี้ง แงแน อางแบจ่าแล่ อือ, พาจาว ม้า ยองนา ก่ามป่อน ปี่ ญา, ไม้ ยองมู นี้ย่า พาจาว มาง ชฺ้าง เพล่อ ป้าน่อ. ");
INSERT INTO bzi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ยาว นองมู อามือ จฺื่งคู คูง อือ เวอ, แบ ชี คู โว! พาจาว ม้า นองนา ก่ามป่อน ปี่ ล่างญา แน. ยาว พาจาว มาง นองนา ฮาย จฺ่าก่อต้างก้อ แน จา ปี่ ล่าง. นองมู อามือ อู้ง คูง อือ เวอ แบ ชี คู โว! พาจาว ม้า นองนา ก่ามป่อน ปี่ ล่างญา แน. บ่ามล่าง ยาว พาจาว ม้า นองนา ฮาย อื้อ ปี่ ล่าง เป. ");
INSERT INTO bzi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“นอง กงาชฺ้าง เพล่อ ชีแฮ้ง ปาปาย แน ชฺ้าง นองนา เม้อ ล่าเมอ, นองนา ก่า ล่าเมอ, นองนา ฮูย้า ล่าเมอ, แน นองนา ชฺ้าง บ่าแม่น แน จี่ ล่าเมอ, พาจาว ม้า นองนา ก่ามป่อน ปี่ ล่างญา. ");
INSERT INTO bzi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ยาว นองนา ฮาก คาม ล่าง แฮ้นืง ย่า กย่าง เปิก คู โว! ไม้ พาจาว ม้า รางวัล ย่าง มู่งท่า โย้เวอ นองนา กอ ชี ล่างญา. ไม้ ค้าแต้ โย้เวอ, พาจาวจี่ต่างจี่แต่นฮู อือนา นี้แม้แน ย้า ฮาก คาม ชี.” ");
INSERT INTO bzi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ยาว พระเยซู จี่ แล่ง นี้แม้แน, “ชฺ้าง อางจาอางปาง อือ เวอ นอ อางตูกอางพาน กงามย้าง แง เป. ไม้ นอง จาบื่อดื้งบื้อ แน กงาย ล้า ชีนี้ โค คางญา. ");
INSERT INTO bzi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ยาว ชฺ้าง อามือ จฺ่าก่อต้างก้อ แน ดื้ง อือ เวอ, นอ ชา จฺื่งคู คูง เป. แน ชฺ้าง อามือ อื้อ จา อือ เวอ, นอ บ่าม่อนบ่าซ่า บ่าจาบ่าดื่งบื้อ แน กงา อู้ง คู แง เป. ");
INSERT INTO bzi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ยาว ชฺ้าง ฮาก โญกจ่าญ่อจ่า อือ เวอ, น่อง โย้เวอ นองนา นาบาตา ย้า ฮาย ลาบ้าบ ปี่ ล่าแง. ยาว นอง อางฮู่ อางพี่ อืม, พาจาวจี่ต่างจี่แต่นฮู ม้าม้า บ่าอ่า อือนา โญกจ่าญ่อจ่า กางซื้ง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“จ้า นอง กงานา ดื้งน้า ล่าง อือนา ม่า ล่าว่า นี้แม้แน, นองนา เม้อ ล่าง อือนา อางแม่น ฮาช่าง โว! แน ลาก โว!” ");
INSERT INTO bzi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ยาว นองนา แซ้งว้าน ล่าง อือนา ก่ามป่อน ปี่ โว! นองนา บ่าแม่น ฮา ล่าง อือนา อธิษฐาน ฮา ปี่ โว! ");
INSERT INTO bzi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","จ้า ฮาก นาง ป่าปา ทื่อปล่าก มางก้อง ทาก ล่า ยาว, ป่าปา ทื่อปล่าก แฮ้ง พลาบ ทาก ปี่ โว! อ่าซ่าง นาง ค่าลาวโลบแล่เซฺ่อ แฮ้ง ย่าด ล่าแง, ค่าลาว อางคล้าว ตูม แล่ ชี่ แฮ้ง คาตา แน แล ปี่ โว! ");
INSERT INTO bzi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ยาว ชฺ้าง คาโคลาโค นางนา ป้า ล่าง อือนา ปี่ โว! แน อ่าซ่าง นาง อางเกิ่งอางก้อ แฮ้ง ย่าด ล่าแง, บ่ากงา ป้า คื่น แล่ คา. ");
INSERT INTO bzi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","นอ ฮากนา ล้อแม้ นองนา ฮาย ปี่ ล่า ปี่ ซี่ง แง, นองมือ ฮากนา แฮ้แม้แน ฮาย ปี่ โว! ");
INSERT INTO bzi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ยาว นอง ชฺ้าง นองนา ลาก อือนา แอ่ แน ลาก ยาว, พาจาว ม้า บ้าเจอฮาย นองนา รางวัล ปี่ ล่าแง? ซ้ามบา ชฺ้าง บ่าแม่น อืมมือ แฮ้แม้แน ฮา บ่าอ่า ลา? ");
INSERT INTO bzi_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ยาว นองนา แม่น ช่างล่าง อือนา แอ่ แน แม่น ช่าง ยาว, บ้าเจอล้อแม้ แม่น ชี? ซ้ามบา ชฺ้าง อางบล่าบ นี้ ยอ นี้แม้ย้า ฮา คู แง. ");
INSERT INTO bzi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","นอง ฮากนา พลู้ ชี่ ปี่ นี้ย่า ชฺ้าง พลู้ อางคื่น ล่าตอ อือนา ญา ล่า ชี่ ปี่ง. นี้แม้ฮา ชี นี้ย่า ล้อแม้ เลิ่นเล้อ ล้า แง, ไม้ ชฺ้าง บ่าแม่น อือ นี้แม้ย้า ฮา แง. ฮากนา พลู้ ชี่ ปี่ ยาว. พลู้ ชี่ ชีแฮ้ง กงา คื่น แล่ ซี้ แง. ");
INSERT INTO bzi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","จ้า นองมู นี้ย่า นองนา เม้อ ล่าง อือนา ลาก โว! ยองนา แม่น แน ฮาช่าง โว! ยาว ยองนา พลู้ ชี่ ปี่ โว! กงายคื่น แงแน บ่ากงาเย้ง คา. ยาว น้า รางวัล อางบย่า ย้า กงา แง, แน พาจาว อางฮื่อ เลิ่นเลิ่น มาง อางย่า ม้าม้า กงาเพล่อ แง, ไม้ พาจาว นี้ย่า ชฺ้าง กู่น นา บ่าแบ อือ, แน ชฺ้าง บ่าแม่น อือนา แม่น ช่าง แง. ");
INSERT INTO bzi_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","นองมู นี้ย่า ลากซื่งกง่ากย้า อือ จา โว! พาจาว มาง ลากซื่งกง่ากย้า แม้แน. ");
INSERT INTO bzi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ยาว ฮากนา บ่าต่าดบ่าต่อน โจ! ยาว พาจาว มาง นองนา บ่าต่าดบ่าต่อน ล่า เป. ฮากนา บ่าจี่ กว่า โจ! ยาว พาจาว มาง นองนา บ่าจี่ ล่า เป. ฮากนา อางซี บ่ายู โจ! ยาว พาจาว มาง นองนา อางซี บ่ายู่ ล่า. ");
INSERT INTO bzi_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ยาว นอง ฮากนา ปี่ ยาว, พาจาว มาง นองนา คาตา ย้า ปี่ ล่าง. ยาว พาจาว ม้า นอง เย้ง ชี ชี ล่อบ่าปา ปี่ ล่าแง, ไม้ นอง ฮากนา ล้อแม้ ฮาย ปี่ แง นอง แฮ้แม้ย้า กงา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ยาว พระเยซู มือ อางเลิ่ง จี่เพ้ก น้า ปี่ น้าว นี้แม้แน, “แมปอ นี้ย่า แมปอ นา อางชฺื้ง กงากา ลา? เย่ด ค่ามตู่ เวอ บ่าซฺื่ย กา กลา แล่ ลา? ");
INSERT INTO bzi_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ศิษย์ นี้ย่า คู่ ล่อบ่าปา ล่า เลิ่น? จ้า ยอง เล่น โค ยาว ยอง คู่ ป้าค้า ย้า เพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“นาย่า บ้าเจอ ฮาก แมนือ คล้าว โย้เวอ, แมเจ่ด อือ อางฮู มย้าง กา แน. จ้า บ้าเจอ ค่าตอง แมนือ คล้าว โย้เวอ ตู่มบา แฮ้งนา บ่าฮู มย้าง กาแน? ");
INSERT INTO bzi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","บ้าเจอ นา ฮากนา นี้แม้แน อางม่า แน, ‘กงา นาง แมนือ เวอ แมเจ่ด แฮ้ง ยู้อ่อก ปี่ ล่าว่า,’ จ้า ม้าม้า ย่าง นาง แมนือ โย้เวอ ตู่มบา ย่าง จา แง. ชฺ้าง แมก่าทื่อเจ่อ นืงบาทื่อเจ่อ อือเวอ, ฮาก แมนือ เวอ แมเจ่ด ชา ยู้ อ่อก ปี่ เมอ, ค่าตอง แมนือ คล้าว เวอ ตู่มบา แฮ้ง ยู้อ่อก แล่ ปาโน” แน. ");
INSERT INTO bzi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ยาว พระเยซู จี่ แล่ง นี้แม้แน, “ทื่อช่างกานญา จฺืงจฺื้ง อางแม่น นี้ย่า อางซื่อ บ่าแม่น แน บ่าซื่อ กงากา. ยาว จฺืงจฺื้ง บ่าแม่น นี้ย่า อางซื่อ อางแม่น แน บ่าซื่อ กงากา. ");
INSERT INTO bzi_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ยาว บ้าเจอ ป้าง แน แบ ซี้ง แง แนยาว, อางซื่อ อือนา ฮู กาโน. ยาว นอ ซื่อไค่มี้ล่อก ซื่อ, แน อ่างู่น อางซื่อ นี้ย่า จี่กู่ แต่ เวอ บ่าซฺ่า แอ อ่าลา? ");
INSERT INTO bzi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ยาว นืงบา โย้เวอ บ้าเจอ ปลืงล้อน จา แง นอง ม่านป่อง มาง แฮ้แม้ย้า จี่ อ่อกล้า ปี่ แง. ชฺ้าง อางแม่น อือ ยอง นืงบา คล้าว เวอ อางแม่น อือ จี่ อ่อก ล้า ปี่ง, จ้า ชฺ้าง บ่าแม่น อือ ยอง นืงบา คล้าว เวอ บ่าแม่น อือ แอ่ ย้า จี่ คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ยาว พระเยซู จี่ แล่ ชี่ นี้แม้แน, “นาง กงา ม่า แม้แน บ่าฮา ยาว, บ้าเจอฮา กงานา, ‘จี่วีดอางซื้ง มาง เวอ, จี่วีดอางซื้ง มาง เวอ,’ แน เค่ ฮ้าว ล่า แง? ");
INSERT INTO bzi_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","กงา ม่ายแบ ปี่ ล่าว่า, ชฺ้าง กงานา ล้า ซฺ้า ล่าชี่ อือ แน กงา ม่าอู่บจี่ต่าง แฮ้ง ฮายเค่ ยาว, ");
INSERT INTO bzi_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ชฺ้าง ยู้ม แต่ง ป้าค้า ย้า. ค่ามตู่ ลอบา เวอ เคอ แน ตู่ แอ ปี่ ยาว ยู้มยื้ง แฮ้ง พูม แง. ล้าง ทู้ม เมอ ล้างฮ้าด ล้างเจอ อางคา ลือ เมอ, ยู้ม นี้ย่า บ่าปูย แอ, ไม้ แก่นคา แน แต่ง ชี ป้าน่อ. ");
INSERT INTO bzi_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","จ้า ชฺ้าง กงา จี่ต่าง นา กงากย่า ยาว บ่าฮา เค่ อือย่า, ชฺ้าง ยู้ม แต่ง ต่องก่า เวอ แก่นคา แน บ่าแต่ง อือ ป้าค้า. ล้างฮ้าด ล้างเจอ อางฮื่อ ลือ ยาว, ยู้ม นี้ ปูย ก่างพยา บืนลาว แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","พระเยซู ค่องช่าง อือนา ม่าอู่บ เปิน ยาว, ยาง มือ คาเปอรนาอุม อางเมิง เวอ แอน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ยาว ตาฮ้าน นายร้อย โรมัน ทื่อม่าง จา เย. ยาง ย่าเจ่น ทื่อม่าง มาง ด้ากย้าง ชา ซฺี้ เย่. ยาว นายร้อย นี้ม้า ย่าเจ่น นี้ มางนา นาบาตา ย้า ลาก แง. ");
INSERT INTO bzi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ยาว ยาง พระเยซู อางเลิ่ง แฮ้ง กงากย่า ยาว, ยิวชฺ้าง ยอคา อือนา ม่า พระเยซู นา ป้า ยาง ย่าเจ่น มางนา ยา ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","แฮ้งเย่ ยิวชฺ้าง ยอคา อืม พระเยซู นา มย้าง ยาว นี้แม้แน ป้า คู ชี, “อ่าจาน เวอ, นายร้อย นี้ มางนา ปล่อง ปาว. อางซูม ย้า ยางนา ปล่อง นี้ย่า, ไม้ ยา ชฺ้าง นาบาตา แม่น เป. ");
INSERT INTO bzi_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ยาว ยา ยิวชฺ้าง นา อางลาก. ยา กงูนา โบสถ์ แต่ง ปี่ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","แฮ้งเย่ พระเยซู ยองก้อง เค่ แอน ชี. ยาว ยู้ม เวอ ชา เคอ เมอ, นายร้อย ม่าง ยาง อางช่าง อือนา ม่า พระเยซู นา นี้แม้แน ม่า ปี่ชี่ เย, “เจ้านาย เวอ, กงา ชฺ้าง บ่าแม่น กงา ยู้ม โย้เวอ บ่าอ่อง แล โจ. ");
INSERT INTO bzi_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","กงา อางโต นี้ย่า บ่าแม่น นางนา ซฺ้า ล่า ยาว บ่าซูม. นาง กงา ย่าเจ่น มางนา พ่าญ่าด โปยว ปาว แน ม่า ยาว, ซฺ้อก ย้า ยาง พ่าญ่าด แฮ้ง โปยว แง. ");
INSERT INTO bzi_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","กงา นี้แม้แน แบ นี้ย่า, กงา เมอ เจ้านาย แน ตาฮ้าน จา แง. กงา ตาฮ้าน มางนา ล้อเกิ้ง ม่า แอ ปี่ เวิม แอ แง. แน ม่า ล้า ปี่ เวิม ล้า แง. ยาว กงา ย่าเจ่น อือนา นี้ง ว่า แฮ้ง ว่า แน ม่าฮา ปี่ เวิม ยอ ว่า แง.” ");
INSERT INTO bzi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","พระเยซู มือ แฮ้แม้แน กงากย่า ยาว ยางมือ นาบาตา เย นืงบาม่าน แง. ยาว ชฺ้าง เค่ ลือ ชี อือนา จี่ช่าง เย นี้แม้แน, “กงา อางเลิ่ง ม้าม้า แฮ้ง นองนา ม่ายแบ ปี่ ล่าว่า นี้แม้แน, กงาย่า อิสราเอลชฺ้าง อางมู นู้เวอ, อ่าซ่าง มางนา ทื่อม่าง แนม นี้แม้แน เจ่อ นา บ่ามย่าง กางซื้ง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ยาว ยิวชฺ้าง ยอคา อือ นายร้อย มาง ยู้ม พ่าว แลน แล่ยาว ยอง มย้าง ชีเย, นายร้อย มาง ย่าเจ่น ด้ากย้าง ชี มาง ด้ากย้าง ย้าง โปยว ชี. ");
INSERT INTO bzi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","แฮ้เมอ จายล้า แล่ ยาว, พระเยซู แน ยาง ศิษย์ อือ นาอิน ค่อง เวอ แอน ชีเย, แน ค่องช่าง อางอีบ่าอ่า เย พระเยซู ก้อง เค่ แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","พระเยซู ค่อง ล้องก้อ เวอ แท้ แน ย่อ เคอ ล้า ยาว, ยาง ชฺ้าง อือ ชฺ้างซฺี้ นา ลามกา ลือ นา มย้าง ชีเย. ชฺ้างซฺี้ นี้ม้า แมม้าย มาง อางย่าย่าค่า ทื่อม่าง แน จา มาง ย้าเย่. ค่องช่าง อางบย่า เย แมม้าย มางก้อง ทื่งกง่า แน ย่อ ลืน คูชี. ");
INSERT INTO bzi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","พระเยซู แมม้าย มางนา มย้าง ยาว ซื่งกง่ากย้า เย. ยาว ยาง แมม้าย มางนา นี้แม้แน จี่ช่าง เย, “บ่าอู่ง โจ!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ยาว พระเยซู ย่อ อ้องแล ชฺ้างซฺี้ มาง อางลอง โย้เวอ ชู แล ชีเย. ชฺ้าง อางลอง ลาม คูง อืม ย่อ ย้าง ว่าง ยาว จูง คู ชีเย. ยาว พระเยซู ชฺ้างซฺี้ มางนา นี้แม้แน จี่ช่าง ชีเย, “ย่าค่า เวอ, ทานล้า ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ยาว ชฺ้างซฺี้ มาง ทา ดื้ง ล้า ยาว จี่ ล้า ชีเย. ยาว พระเยซู ย่าค่า มาง อางบา มางนา นี้แม้แน จี่ ช่าง ชีเย, “นี้ นาง อางย่า มาง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ค่องช่าง อือ แค แล่ คู ชีเย, ยาว พาจาว มางนา นี้แม้แน สรรเสริญ ฮา คู ชีเย, “พาจาวจี่ต่างจี่แต่นฮู อางฮื่อ ม้าย่า กงู มู นู้เวอ เกิ้ด ลือ ชี” แน. ยาว ยอง นี้แม้แน จี่ แล่ คู ชีเย, “พาจาว ม้า ยาง ชฺ้าง อือนา ปล่อง ลือ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ยาว พระเยซู อางเลิ่ง นี้ย่า ยูเดีย แควน, แน อางต่องอางทาง อือเมอ จ่อด ย้าเย่ แบ แอน คูชี. ");
INSERT INTO bzi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ยอห์น ล้างตือพิธีบัพติศมา ฮา มาง คอก ดื้ง เมอ, ยาง ศิษย์ อือ พระเยซู อางเลิ่ง ฮา ชีอือ ยอห์น นา อู่บน้า ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ยาว ยอห์น ยาง ศิษย์ 2 คู่น ม่าง เย่ดนา นี้แม้แน จี่ช่าง ชีเย, “จี่วีดอางซื้ง มางนา นี้แม้แน น้า โว! ‘นา ชฺ้าง ลือ แฮ้มาง ย้า อ่าลา? อ้าว กงู ชฺ้าง ทื่อม่าง ชา ลือ แฮ้มางนา กงา ล่อ แล่ง ลา?’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ยาว ยอห์น ศิษย์ มาง เย่ด พระเยซู นา นี้แม้แน จี่ช่าง ชีเย, “ยอห์น ล้างตือพิธีบัพติศมา ฮา มาง ไกง้นา ไจ นางนา นี้แม้แน น้า ลือ ปี่ ล่าแง, ‘นา ชฺ้าง ลือ แฮ้ มาง ย้า อ่าลา? อ้าว กงู ชฺ้าง ทื่อม่าง ชา ลือ แฮ้มางนา กงา ล่อ แล่ง ลา?’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","แฮ้ญ่ามเมอ พระเยซู ชฺ้าง อางด้าอางกย้าง อือนา ยา โปยว ปี่ชี่ เย. ยาว แด่ย่า อือนา ก่าอ่อก ปี่ชี่ เย. ยาว ชฺ้างแมปอ อือนา ยา ยาว ฮาย มย้าง ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","แฮ้งเย่ พระเยซู มือ ยอห์น ศิษย์ มาง เย่ดนา พอ ชี นี้แม้แน, “นอง กงากย่า กงามย้าง ชี นี้อือ ยอห์น นา พ่าว ม่า แล โว นี้แม้แน, ชฺ้าง แมปอ อืมมือ ฮูมย้าง กาชี, ชฺ้าง ต่องแก่ อืมมือ ย่อตอ กาชี, ชฺ้าง คี้ตู้ด อืมมือ คี้ตู้ด ย่าง โปยว คาชี, ชฺ้าง น่าป่าง อืมมือ กย่า ล้า ชี, ชฺ้างซฺี้ ชี อืมมือ แต่ ลาน ชี แน? อางเลิ่ง อางแม่น ย่าง มือ ชฺ้าง อางตูกอางพาน อือนา ป่าวกย่า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","อ่าซ่าง กงานา นืงบาชี ยาว เจ่อ แล แล่ ล่าง. พาจาว ม้า ชฺ้าง แฮ้มางนา ม้าม้า ย้า ก่ามป่อน ปี่ แง.” ");
INSERT INTO bzi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ยาว ยอห์น ศิษย์ มาง เย่ด พ่าว แลน แล่ยาว, แฮ้งย้า พระเยซู มือ ยอห์น มาง อางเลิ่ง ย่าง ค่องช่าง อือนา อู่บน้า ปี่ ชีเย นี้แม้แน, “นองมู นี้ย่า บ้าเจอฮาย ตี อางกืออางคาก ป่ากย่า แอ ฮู แอ คู แง? นอย่า ชฺ้าง บ่าแก่นบ่าคา, แน ไมออ ปาง ฮ้างม้าน ตอล้า เมอ เลิง แอ แม้แน กงามย้าง แน เย้ง คูลา? ");
INSERT INTO bzi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","จ้า บ่าอ่า ยาว, น่อ บ้าเจอ อ่อก ฮู แล แอ, ชฺ้าง ค่าลาว อางมาง อางฮู่ อางคา ตูม แล่ง อือนา ฮู คูง ลา? จ้า บ่าอ่า ม้าม้า ย้า, ชฺ้าง ค่าลาว อางมาง อางฮู่ อางคา ตูม แล่ง นี้ย่า ก่าซ้าด ยู้ม คล้าว ดื้ง กาน แง. ");
INSERT INTO bzi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","แฮ้แม้แนยาว นอย่า บ้าเจอ อ่อก ฮู แอ คูง แง? พาจาวจี่ต่างจี่แต่นฮู อือนา ฮูแอ คูง ลา? กงา ม่า แบ ปี่ ล่าว่า นี้แม้แน ยอห์น พาจาวจี่ต่างจี่แต่นฮู อือ ล่อบ่าปา ฮื่อ แล่ง, ");
INSERT INTO bzi_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ไม้ ยา ค้าแต้ เวอ พาจาวจี่ต่างจี่แต่นฮู อือ มอ ยาว พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี มาง ย้า, ‘แม่น แน น้า ปาว! กงา นาง ฮู่ เวอ ชฺ้าง ป่าวฮู ทื่อม่าง ซฺาลือ ปี่ง, ไม้ ยา ชฺ้าง นางนา ชา ล้า เจ่อ ล่าง อือนา ซฺ้า ชี ล่าแง.’ ");
INSERT INTO bzi_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“กงา นองนา อางเลิ่ง ม้าม้า ม่ายแบ ปี่ ล่าว่า, ยอห์น ชฺ้าง คาโคลาโค ชฺ้างอางเมิง นู้ เกิ้ด ลือ ชี อือ ล่อบ่าปา ฮื่อ เลิ่นเลิ่น แง. จ้า พาจาว มาง อางเมิง เวอ, ชฺ้าง ปีนแตปีนนา อางอี เลิ่นเลิ่น มาง มือ ยอห์น ล่อบ่าปา ฮื่อ แง.” ");
INSERT INTO bzi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ชฺ้าง อือ แน ชฺ้าง ภาษีกอฮู อือ กงากย่า เมอ ยอง เย้ง คูง เย, พาจาว มาง ม่าอู่บจี่ต่าง นี้ย่า อางแม่น แน, ไม้ ยองมู นี้ย่า ยอห์น ก้อง ล้างตือพิธีบัพติศมา ฮา แล่ คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","จ้า ฟาริสี แน อางลี้บอางล่าว ม่าอู่บฮู อือ, พาจาว มาง แม้แน ฮายเค่ แฮ้งนา บ่าตื่อฮา กาเย, ไม้ ยองมู นี้ย่า ยอห์น ก้อง ล้างตือพิธีบัพติศมา ฮา แล่ง แฮ้ง บ่าตื่อ ฮา แล่ กา เย. ");
INSERT INTO bzi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ยาว พระเยซู จี่ แล แล่ง นี้แม้แน, “กงาย่า อามือ ชฺ้าง อือนา บ้าเจอ ก้อง เพ้ก ลื่อวา? ");
INSERT INTO bzi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ยอ ย่าเก ทื่อกง่า แน บ่อ ยาว ซีแล กางอือ ป้าค้า ย้า. ยาว โฮ้กฮ้าว อี่ กาง แง นี้แม้แน, ‘กงู คองมาน มาโย้ง ตื่อบ่อ เมอ นอ บ่าเยน เค่ คู, กงู ศพ จา ชี แน ฮาย บ่อ เมอ นอง มือ บ่าอู่ง คู.’” ");
INSERT INTO bzi_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“ยอห์น ล้างตือพิธีบัพติศมา ฮา มาง ลาน ยาว, ยา อ่างู่น แต่ค่า บ่าต่าง, แน ฮ่าง จฺ่าเกิ่งจฺื่ง แง, จ้า นอ ยางนา แด่ย่า อ่อง ชี แน จี่ กางแง. ");
INSERT INTO bzi_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","จ้า กงาชฺ้างอางย่า มาง ลือ เมอ, กงา อางจฺ่าอางต้าง ย้า. นองมู นี้ง นี้แม้แน จี่ กาง, ‘ชฺ้าง จฺ่า อางไล้ แน แต่ค่า ต้าง อางคา. อ่าจ่าม ชฺ้าง ภาษีกอฮู บ่าแม่น บ่ากง่าบ่าเกิง อือนา, แน ชฺ้าง อางบล่าบ อือนา คาตา ซฺ้ามี แง’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","จ้า ชฺ้าง พาจาว มางก้อง เค่ อือย่า, ยอ พาจาว มาง วี่ไซป้านญา อางฮื่อ แฮ้ง กงามย้าง แง.” ");
INSERT INTO bzi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ฟาริสี ทื่อม่าง จา แง อางเม้ง ซีโมน แน. ยา พระเยซู นา ช่าง ยาง ยู้ม เวอ ฮ่างจฺ่า แล ชีเย. พระเยซู มือ ยาง ยู้ม เวอ แล ชี. ยาว ฮ่างเพิ่น ทาง เวอ ดื้ง จา เมอ. ");
INSERT INTO bzi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ค่าบาย่า ทื่อม่าง จา เย, อางเมิง คล้าว โย้เวอ จ่อด ย้าเย่ ฮาก อางแบ ยา ชฺ้าง อางบล่าบ แน. ยาว ยาง กงากย่า ชีเย, พระเยซู ยา ฟาริสี มาง ยู้ม เวอ ฮ่างจฺ่า ลือ ชี แน. ยาง มือ น้ำหอม ป่าง อางมาง ย่าง ท้าม ลือ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ยาว ยาง มือ พระเยซู น่องน่อง เวอ อ้องแล ชี. ยาว พระเยซู ล่าคื่อ เวอ แท้ แน อ้อง ดื้ง แล ชี. ยาว อู้ง ชี ยาง แมปื้อ ย่าง พระเยซู ล่าคื่อ เวอ กลา จาก ยาว, ยาง มือ ต้ามคื้ง แฮ้ง ไจ ซีด ปี่ชี่ เย. ยาว ยาง บอก ยาว พระเยซู ล่าคื่อ เวอ ไลเทอ ย้าเย่ ชู่บ ชี. ยาว ยา น้ำหอม พระเยซู ล่าคื่อ 2 เบิง เวอ ท่อก ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ยาว ซีโมน มย้าง ยาว นี้แม้แน เย้ง เย, “ค่าพ่าย่า นี้ม้า พาจาวจี่ต่างจี่แต่นฮู ม้าม้า แน ยาว, อางแบ อี้ ค่าบาย่า ยางนา ว่าซาว นี้ม้า อ่าซ่าง แน, แน ค่าบาย่า นี้ม้า ค่าบาย่า ลอเจ้อ แน, ยา อางแบ อี้ ค่าบาย่า นี้ม้า ชฺ้าง อางบล่าบ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ยาว พระเยซู จี่ช่าง เย นี้แม้แน, “ซีโมน เวอ, กงา ม่า ล่าว่า” ยาว ซีโมน พอ เย, นี้แม้แน “จี่ ลือ ปี่ ปาว, อ่าจาน เวอ.” ");
INSERT INTO bzi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","พระเยซู จี่ เย นี้แม้แน, “ชฺ้าง พลู้ ฮากนา ชี่ ปี่ ฮู ทื่อม่าง จา เย. ยาว ชฺ้าง 2 คู่น จา เย ยางก้อง พลู้ ชี่ ลือ ชี. ทื่อม่าง ม้า พลู้ 500 เหรียญ ชี่ ชีเย, ทื่อม่าง ม้า พลู้ 50 เหรียญ ชี่ ชีเย” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","จ้า เย่ด พลู้ ไซ เซฺ่อ บ่าจา เย. แฮ้งเย่ ชฺ้าง พลู้ ชี่ ปี่ ฮู มาง อางชี่ แฮ้ง บ่ายู คื่น แล่ แง. นาง เย้ง กาน ยาว, ชฺ้าง พลู้ ชี่ อางบย่า แน อางอี มาง เย่ด บ้าเจอ ซ่าง พลู้ ชี่ ปี่ ฮู มางนา ลาก เลิ่นเลิ่น แงแน? ");
INSERT INTO bzi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","แฮ้งย้า ซีโมน นี้แม้แน จี่พอ ชี, “ชฺ้าง พลู้ อางบย่า แน ชี่ ชี มาง ย้า” แน. พระเยซู มือ นี้แม้แน จี่พอ ชีเย, “โอ่ย, อางอ้า ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ยาว พระเยซู ค่าบาย่า มางก้อง ฮู แอ ปี่ น้าว. ยาว ซีโมน นา นี้แม้แน ม่า ชีเย, “ค่าบาย่า นี้มาง นา อางมย้าง ลา? กงา นาง ยู้ม นู้ ลือเมอ นา กงู อางลี้บ แม้แน กงา ล่าคื่อ เวอ ล้าง บ่าชี่ ปี่ ล่า น่อ, จ้า ค่าบาย่า นี้ม้า ยาง แมปื้อ ย้าง กงา ล่าคื่อ เวอ ชี่ ล่า แง. ยาว ยาง ต้ามคื้ง ย่าง กงา ล่าคื่อ ซีด ล่า แง.” ");
INSERT INTO bzi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ยาว นา กงู อางลี้บ แม้แน กงานา บ่าชู่บ ลาบ ล่า, จ้า ค่าบาย่า นี้ม้า กงา ล่าคื่อ เวอ ชู่บ ย้าง บ่าว่าง ยาง อ้อง ลา เมอ จาย ยา. ");
INSERT INTO bzi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ยาว น้า กงู อางลี้บ แม้แน กงา อางตู่ เวอ นามม่าน บ่าต่า ปี่ ล่า, จ้า ค่าบาย่า นี้ม้า กงา ล่าคื่อ นู้เวอ น้ำหอม ย่าง ท่อก ล่า แง. ");
INSERT INTO bzi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","กงา ม่า แบ ปี่ ล่าว่า, ค่าบาย่า นี้มาง กงานา นาบาตา แน ลาก ล่าง นี้ย่า ฮา มย้าง ปี่ แง. กงา ยาง อางบล่าบ อางบย่า ฮา ปูน ปี่ชี่ แฮ้ง ปาปาย แน. จ้า ชฺ้าง อางบล่าบ บ่าบย่า แน กงา ปูน จ่าแล่ ชีอือ ย่า, พาจาว มางนา อางบย่า แน บ่าลาก. ");
INSERT INTO bzi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ยาว พระเยซู ค่าบาย่า มางนา ม่า เย นี้แม้แน, “กงา นาง อางซีอางบล่าบ บ่ายู่ ล่ากาน” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ยาว ชฺ้าง พระเยซู ก้อง จฺ่าต้าง ดื้ง คูชี อืม นี้แม้แน จี่กาง เย, “ชฺ้าง นี้ม้า บ้าเจอ อ่าซ่าง เวอ แน เย้ง จ่าแล่ แง, ฮากนา อางซีอางบล่าบ บ่ายู แน ฮายกว่า แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ยาว พระเยซู ค่าบาย่า นี้มางนา นี้แม้แน จี่ช่าง ชีเย, “นาง พาจาว มางนา เจ่อ จ่าง แฮ้ง ปาปาย ย้า, นางนา ฮา อางบล่าบ ปูน ปี่ ล่าแง. จาบื่อดื้งบื้อ แน จาแล โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","แฮ้เมอ จายล้า แล่ ยาว, พระเยซู อางเมิง แน ค่อง อือเมอ แลน ชีเย. ยาว อางเลิ่ง อางแม่น ป่าว กว่า ชีเย. พาจาว มาง ชฺ้างอางเมิง นู้ ก่าซ้าด เพล่อ ลือ ชี อางเลิ่ง แฮ้ง. ยาว ศิษย์ 12 คู่น อืม ยางก้อง ทื่งกง่า แน ดื้ง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ยาว ค่าบาย่า ทื่อบ่า พระเยซู แด่ย่า ก่าอ่อก ปี่ชี่ อือ, แน พ่าญาด ยา ปี่ชี่ อือ คาตา ย้าเย่ พระเยซู นา เค่ กว่า คู ชี. ค่าบาย่า แฮ้อือ ย่า มารีย์ มักดาลาชฺ้าง, พระเยซู ยางนา แด่ย่า 7 โต ก่าอ่อก ปี่ชี่ มาง เย่. ");
INSERT INTO bzi_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ยาว โยอันนา คูซา ค่าบา มาง. คูซา ก่าซ้าด เฮโรด มาง อางเกิ่ง ฮูพลา เย. ยาว สูสันนา แน ค่าบาย่า ทื่อบ่า อือย่า ค่าตอง อางเกิ่งอางก้อ, แน พลู้ แฮ้ง พระเยซู แน ยาง ศิษย์ อือนา ปล่อง แง. ");
INSERT INTO bzi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ชฺ้าง อางบย่า เย ค่อง อือก้อง จายลือ พระเยซู นา ลือ ซฺ้า ลือ คู ชี. ยาว พระเยซู ยองนา อางเลิ่ง อู่บเพ้กน้า ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","นี้แม้แน, “น่าว่าฮู ทื่อม่าง จา แง อ่อกแอ กอย่าว ปยา แอ ชี. กอย่าว ปยา เมอ, กอย่าว ทื่อบ่า อือย่า แก้บ้า ย่อย่า อือเมอ กลาน ชี. แน ชฺ้าง น่าง ชีเย. ยาว ฮาย่า ดอก จฺ่า โค ชี. ");
INSERT INTO bzi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ยาว กอย่าว ทื่อบ่า อือย่า ลอบา แต่ อือเมอ กลาน ชีเย. ยาว แต่ล้า แฮ่ว ชีเย, ไม้ ล้าง อางบย่า แน บ่าจา วา. ");
INSERT INTO bzi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","กอย่าว ทื่อบ่า อือย่า จี่กู่แต่ เวอ กลา แอ ยาว, จี่กู่ปาว ย่าง โปกปาว ฮา ซฺี้ ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","จ้า กอย่าว ทื่อบ่า อือย่า นื้งชฺ่า อางแม่น อือเมอ กลาน ชี. แฮ้งย้า แต่ ฮื่อ มอง ล้า แม่นมาง ชี. แน กอน้าม พลอง อ่อก ล้า กอ กงา ชี 30 โตบ, 60 โตบ แน 100 โตบ” แน. ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “อ่าซ่าง น่าซื่ง จา แง, แม่น แน น้า คูปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ยาว พระเยซู ศิษย์ อืม พระเยซู นา นี้แม้แน น้าน คู ชีเย, “นาง กงูนา อางเลิ่ง อู่บน้า ปี่ ล่าชี่ นี้ย่า บ้าเจอป้าค้า เวอ?” ");
INSERT INTO bzi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “พาจาว ม้า นองนา ม่ายแบ ปี่ ล่าง ญา, ยา ชฺ้างอางเมิง นู้เวอ บ้าเจอล้อแม้ ก่าซ้าด กงาเพล่อ แงแน. จ้า กงา ฮากนา อางเลิ่ง อู่บ เพ้กน้า ปี่ แง. ไม้ พระคัมภีร์ โย้เวอ นี้แม้แน แต้ม ชี ชี, ‘ยองมู นี้ย่า ฮู เวิม ฮู แล่ง ย้า, จ้า บ่าฮู มย้าง กา น้า เวิม น้า แล่ ย้า, จ้า บ่าน่ากลา กา’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“กงา นองนา อางเลิ่ง อู่บเพ้กน้า ปี่ ล่าชี่ นี้ย่า นี้ ป้าค้า เป. กอย่าว นี้ย่า พาจาวจี่ต่าง ย่าง เป. ");
INSERT INTO bzi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","กอย่าว แก้บ้า อือเมอ กลาน ชี นี้ย่า ชฺ้าง พาจาวจี่ต่าง กงากย่า ชี อือ เป, จ้า ซาตานแด่ย่ายอคา อือ พาจาวจี่ต่าง ย่าง ย่าด ฮื่น ปี่ชี่ เย. แฮ้งเย่ ยอ พาจาว มางนา บ่าเจ่อ คูแง แน จี่วีดม้าม้า บ่าจา คูแง. ");
INSERT INTO bzi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ยาว ชฺ้าง ทื่อบ่า อือย่า กอย่าว ลอบา ท่า นื้งชฺ่า จา ชี อือเมอ กลา ชี อือ ช้อด ย้า. ยองมู นี้ย่า พาจาวจี่ต่าง กงากย่า เมอ, นืงบาต่องม่อนซ้า แง. แน พาจาวจี่ต่าง แฮ้ง นืงบา เวอ กอ ชี คูชี. จ้า ยอ พาจาวจี่ต่าง แฮ้ง ปีนแตปีนนา แน บ่าแบ คู. แฮ้งย้า ยองก้อง อางเลิ่ง อางตูกอางพาน ตอล้า เมอ, พาจาวจี่ต่าง แฮ้ง ยอง นืงบา อางมล่าง แน บ่าดื่ง แง. ");
INSERT INTO bzi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ชฺ้าง ทื่อบ่า อือย่า กอย่าว จี่กู่ปาว กลา ชี อือ ช้อด ย้า. ชฺ้าง นี้อือ พาจาวจี่ต่าง กงากย่า ชี อือ ย้า. จ้า ยอ ชฺ้างอางเมิง นู้เวอ จี่วีด ไจ จาดื้ง แฮ้ง พี้ล้อง แง. แน อางเกิ่งอางก้อ ค่าม พลู้ อือนา, แน ม่อนซ้า อางเลิ่ง อือนา ม่านชู แง. แฮ้งย้า พาจาวจี่ต่าง แฮ้ง ยอง ก้อง จองไจ บ่าจา แง. ยาว นี้ย่า ยอง จี่วีด โย้เวอ จี่กู่ ปาว ชี ปี่ชี่ ช้อด ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","จ้า ชฺ้าง ทื่อบ่า กอย่าว นื้งชฺ่า อางแม่น เวอ กลา ชี อือย่า. ชฺ้าง นืงบาอางแม่น แน อางเลิ่ง อางกง่าอางเกิง ฮา อือ ย้าเย่. ชฺ้าง นี้อือเจ้อ พาจาวจี่ต่าง แฮ้ง กงากย่า ยาว ยอง นืงบา คล้าว โย้เวอ กอยชี ยาว เจ่อ คูชี อือ ย้าเย่, ไม้ ยอง ตูกพานลาบ้าบ โอ้ด ชี แฮ้ง ปาปาย ย้าเย่, นี้แม้แนยาว ยอง จี่วีด นี้ย่า กอป้าง อางแม่น กอ บย่า แน ซื่อ ล้า ชี ลอย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ยาว พระเยซู จี่ แล่ง นี้แม้แน, “อ่าซ่าง มาง ต่องซฺื่อลาน จฺ่อ ยาว นื้งชฺ่าอู่ล่อง บ่าโคบ ชี. บ่าอ่ามมือ ป้าเซ้อ อ่อก โย้เวอ บ่าชี เป. จ้า ต่องซฺื่อลาน จ่อตื้งย้า เวอ จฺ่อ ตื้ง แง, ไม้ ชฺ้าง อือ ยู้ม คล้าว เวอ ย่อ อ้อง ล้า เมอ แปล้นซ้า แน มย้าง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ยาว ม้างม้าเจ้อ ชฺ้าง อือ ค่าวโชง ชี ชี อือย่า, กาญ่าม เวอ พาจาว มาง ชฺ้าง คาโคลาโค อือนา ฮา มย้าง ปี่ง แง. แน อางเลิ่ง ฮากนา บ่าปี่ แบ อือย่า อ่อก ล้า ฮากนา กงาแบ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","นี้แม้แนยาว แม่น แน แล่ม แล่ คู โว เป, นอ ชฺ้าง น้าฮู บ้าเจอล้ออือเจ้อ เพล่อ แงแน. ชฺ้าง กงา ม่าอู่บ ยาว น้า อือ ยอ บย่า แน แบ เค่ แง. จ้า ชฺ้าง กงา ม่าอู่บ ยาว บ่าน่า อือ, อางแบ ย้า แน เย้ง จ่าแล่ง อือ, พาจาว ม้า ยาง แบ ชี แฮ้ง ยู้ คื่น แล่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","พระเยซู อางบา แน อางแพ้ อือ พระเยซู นา ซฺ้า ล้า เมอ, ยางก้อง บ่าอ่อง แล ตอ กาเย, ไม้ ชฺ้าง นาบาตา บย่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ยาว ชฺ้าง ทื่อม่าง พระเยซู นา อ้อง ม่า ลา นาว นี้แม้แน, “อ่าจาน เวอ, นาง อางบา แน นาง อางแพ้ อือ นางนา อางเง้ โย้ ล่อ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","พระเยซู มือ พอ นาว นี้แม้แน, “ชฺ้าง พาจาวจี่ต่าง น้า ยาว ฮายเค่ แฮ้อือย่า กงา อางบา แน กงา อางแพ้ อือ ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ยาว ทื่อนืง จา เย, พระเยซู แน ยาง ศิษย์ อือ ลองอองอางฮื่อ เวอ ล้องตา แล คู ชีเย. ยาว พระเยซู ยองนา จี่ช่าง เย นี้แม้แน, “กงู ลองอองอางฮื่อ ทื่อปล่าก ป่ากย่า แอน ปยา” แน ยองมู ย่าง ล้องตา อ่อกแอน นาว. ");
INSERT INTO bzi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ล้อง มาง ปูย แอ เมอ, พระเยซู มือ ยู่ ชีเย. บ่ามล่าง ยาว ลองอองอางฮื่อ ก้องนื้ง เวอ ฮ้างม้าน อางฮื่อ ตอล้า ชี, ยาว ยอง ล้อง เวอ ล้างฮ้าด ย่าง เอิก อ้องล้า ชีเย. ยาว ยอง ล้อง ย่าง ชา จู้ม เย. ");
INSERT INTO bzi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ยองมู ย่าง มือ พระเยซู นา ตาแค ชีเย, ยาว จี่โฮ้กฮ้าว ม่า คูง เย นี้แม้แน, “อ่าจาน เวอ, อ่าจาน เวอ, กงู ล้าง ชา นื่อ แซ่ แล่ คูชา” พระเยซู มือ ทานล้า ยาว ฮ้างม้าน แน ล้างเอิก ย่าง ม่า ว่าง ปี่ชี. ยาว ฮ้างม้าน แน กูเจ้อ ย่าง ว่าง กยาบ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ยาว พระเยซู ยองนา นี้แม้แน น้า ชีเย, “นอง เจ่อ ย้าง เกิ้ง แอ โค ชี?” แน. ยองมู ย้าง แค คูง เย แน นืงบาม่าน คู ชีเย. ยาว น้า กางเย นี้แม้แน, “ยา อ่าซ่าง ม้าม้า เวอ? ซ้ามบ้า ฮ้างม้าน แน ล้างฮ้าด อืม ยางนา น้าจ่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ยาว ยอง ล้อง ย่าง ลองอองอางฮื่อ กาลิลี ทื่อปล่าก ป่ากย่า แล น้าว, ยาว เกราซา ชฺ้าง อือ ตี เวอ เคิน แล ชี. ");
INSERT INTO bzi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","พระเยซู แปฟาง เวอ ตา แล เมอ, ค่าพ่าย่า ทื่อม่าง แด่ย่า อ่อง ชี มาง พระเยซู ก้อง ย่อ ลือ ชีเย. ค่าพ่าย่า แฮ้ม้า เกราซา อางเมิง เวอ จายลือ ชีเย. ยา อางก่าอางตูม บ่าตูม แล่ เย, แน ยู้ม บ่าดื่ง แน มล่าง กาชา เย. ยา ท้ามชฺ้างซฺี้ชีย้า อือเมอ ดื้ง กว่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ยาว ยาง พระเยซู นา มย้าง ยาว ซฺ้อก ย้าเย่, โฮ้กฮ้าว ล้า ยาว เลิง ลือ ชี่ ยาว จี่ เย นี้แม้แน, “กงานา บ้าเจอ ฮา ตี่นต้อง ล่าแง? เยซู พาจาว อางฮื่อ เลิ่นเลิ่น มาง อางย่า มาง เวอ, กงา ป้า ล่าปานา กงานา เจิ้นเจ้อ บ่าฮา ลาบ้าบ ปี่ ล่า โจ!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ยาง นี้แม้ จี่ ชี นี้ย่า, ไม้ พระเยซู ค่าพ่าย่า มาง อางโต เวอ ม่า อ่อก ปี่ ชี แฮ้ง ปาปาย นอ, แด่ย่า นี้ม้า ค่าพ่าย่า นี้มาง ก้อง ดื้ง แง. ยาว ค่าพ่าย่า นี้มางนา อ้อง อางคา เย. ยาว ค่าพ่าย่า มางนา ไลเจ้อ ย้า ฮา ชี. ค่าพ่าย่า แด่ย่า อ่อง ชี นี้ม้า ล่าปู่ แน ล่าคื่อ 2 เบิง เวอ โซ่ แล่ง ยาว ล้อง ชี เวิม, ยา โซ่ แฮ้ง ฮาย แช ปี่ อางกงา. ยาว แด่ย่า นี้ม้า ค่าพ่าย่า นี้มางนา ซ่องก่องอางเว่อ เวอ เค้ แล ปี่ง เย. ");
INSERT INTO bzi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","แฮ้งย้า พระเยซู มือ ยางนา นี้แม้แน น้า ชี, “นาง อางเม้ง บ้าเจอล้อแม้?” แน. แด่ย่า แฮ้มาง นี้แม้แน พอ ชี, “กงา อางเม้ง อางมู แน, ไม้ กงู ค่าพ่าย่า นี้มาง อางโต นู้เวอ อางบย่า น่อ ดื้ง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ยาว แด่ย่า อืม พระเยซู นา ป้า เย, ยองนา ล่าลูก บ่าซฺา แอ ปี่ ล่า โจ แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","จ้า ตาแซ้ ท่า โย้เวอ, ว่า อางบย่า เย อางจ้า ซฺ้า กลาจฺ่า แง. แด่ย่า อือ พระเยซู นา ป้า เย นี้แม้แน, ยองมู นา ว่า อือก้อง อ้อง ปี่ ล่าปาว แน, แฮ้งย้า พระเยซู ยองนา ม่า อ้อง ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ยาว แด่ย่า อืม ค่าพ่าย่า มาง อางโต เวอ อ่อกแอ ยาว ว่า อือ ก้อง อ้อง คูนาว. ว่า อางมู อืม ลองอองอางฮื่อ ตาแซ้พยางพยาง เวอ ฮื่น เปิก กลา แอ โค ยาว, ล้างนื่อ แล่แซ่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ยาว ว่าปอฮู อือ แฮ้แม้ มย้าง ยาว, ซฺื่ยกา อางเมิง คล้าว แน อางเมิง อางเง้ โย้เวอ ฮื่น แอ คู ชี, ยาว อางเลิ่ง ย่าง อู่บ กว่า ชี จ่อด ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ยาว ชฺ้าง อือ ซฺื่ยกา อ่อก ฮู ลือ นาว บ้าเจอ ตอล้า ชี แน. ยอง พระเยซู ก้อง เคอ ลือ เมอ ค่าพ่าย่า แด่ย่า อ่อง ชี มางนา มย้าง ชีเย, พระเยซู ล่าคื่อ เวอ แท้ ย้าเย่ ดื้ง จา แง ยา อางก่าอางตูม ก่าตูม แล่ชี่. ยาว ยา เจิ้นเจ้อ บ่าเพล่อ กาน เย ค่องช่าง อือ มย้าง ยาว แค คูงเย. ");
INSERT INTO bzi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ยาว ชฺ้าง นี้เลิ่ง กงามย้าง คูชี อืม ค่าพ่าย่า แด่ย่า อ่อง ปี่ชี่ มาง ก้อง อางเลิ่ง ตอล้า ชี แฮ้ง, ยองนา อู่บน้า ปี่ชี่ ค่าพ่าย่า นี้ม้า ล้อแม้ โปยว ชี แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ยาว แฮ้อือเมอ ชฺ้าง คาโคลาโค ดื้ง ชี อือ, พระเยซู นา ทื่อต่อง อือเมอ ป้า แอ ปี่ชี่ ยองก้อง เว่อ แน, ไม้ ยองมู นี้ย่า แค คูง เย. แฮ้งเย่ พระเยซู มือ ทื่อปล่าก ปากย่า ล้องตา แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ยาว ค่าพ่าย่า แด่ย่า อ่อง อ่าน มาง พระเยซู ก้อง ป้า เค่ แอน น้าว, จ้า พระเยซู ค่าพ่าย่า แฮ้มางนา ม่า เย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“ยู้ม เวอ พ่าว แล นาง ยู้มชฺ้าง อือนา ซฺ้า แล ปาว. แน ยองนา ม่ายแบ ปี่ว พาจาว ม้า นางนา บ้าเจอ ฮา ปี่ ล่าชี่” แน. แฮ้งย้า ค่าพ่าย่า มาง แลน ยาว อางเมิง เวอ จ่อด ย้าเย่, พระเยซู ยางนา ฮา โปยว ปี่ชี่ แฮ้ง อู่บกว่า ชี. ");
INSERT INTO bzi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ยาว พระเยซู กาลิลี แควน เวอ พ่าว เคอ แล เมอ, ค่องช่าง อือ ยางนา มย้าง ยาว กย่าง คู เย, ไม้ ยอ ยางนา ล่อ จา คูง เย. ");
INSERT INTO bzi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ค่าพ่าย่า ทื่อม่าง จา เย อางเม้ง ไยรัส แน. ยา ยิวชฺ้าง โบสถ์ โย้เวอ ยอคา เย. ยาว ยาง พระเยซู ล่าคื่อ เวอ บอกไว้ ชี. ยาว ยาง มือ พระเยซู นา ยาง ยู้ม โย้เวอ ป้า แอ ปี่ นาว. ");
INSERT INTO bzi_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ไม้ ยาง อางย่าย่าบี่ อ่าญู 12 ปี ทื่อม่าง แน ชี่ มาง ชา ซฺี้ เย. พระเยซู แก้บ้า ย่อ แล เมอ, บ้าเจอ ลอนา แอ เวิม ชฺ้าง แอ่ ย้าเย่ ปลืงแท่ง กา แง. ");
INSERT INTO bzi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ยาว ชฺ้าง มู นู้ ค่าบาย่า ทื่อม่าง จา เย ซฺี่ ลู่ง 12 ปี เคอ กาชา เย. ยาง พลู้ ค้าจา ย่าง ยา โค แล่ ชีเย, จ้า บ่าโปยว เย. ");
INSERT INTO bzi_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","แฮ้งเย่ ค่าบาย่า นี้มาง พระเยซู น่องน่อง ป่ากย่า อ้อง ซฺ้า แล ชี. ยาว พระเยซู ค่าลาวม่านเงิน โย้เวอ ว่า ชี. ยาว ค่าบาย่า มาง ซฺี่ ลู่ง ชีย้าง ซฺ้อก ย้า โปยว ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ยาว พระเยซู นี้แม้แน น้า ชีเย, “อ่าซ่าง เวอ กงานา ว่า ล่าชี่ ม้า?” แน. ยองมู ย้าง จี่ กางเย บ่ากงา ว่า แน. เปโตร พอ เย นี้แม้แน, “อ่าจาน เวอ, ชฺ้าง อางบย่า ปลืงแท่ง กา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","จ้า พระเยซู จี่ ชี นี้แม้แน, “กงานา ชฺ้าง ว่า ล่าง ม้าม้า ย้า ไม้ กงา อางโต เวอ ล่าที่ ย่าง อ่อกแอน ชี. กงา อางแบจ่าแล่ เป” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ค่าบาย่า มาง ล้อเกิ้ง เวอ บ่าแอ ปูน กา ชีล้า, แน แบน ยาว ยาง ชฺ้าง อางมู โย้เวอ แค ยืก ชี, แน พระเยซู ล้าก้า เวอ บอกไว้ ชีเย. ยาว ยาง พระเยซู นา นี้แม้แน ม่า ชีเย, “กงา นางนา ว่า ล่า ชี่ นี้ย่า, ไม้ กงานา ซฺ้อก แน พ่าญ่าด ฮา โปยว ปี่ ล่าง น้อ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ยาว พระเยซู ค่าบาย่า ม่างนา จี่ช่าง เย นี้แม้แน, “อางย่า เวอ, นาง เจ่อ นี้ง ปาปาย ย้า นางนา ฮา บ่าจาบ่าดื่งบื้อ นี้ง โปยว ปี่ ล่า ชี่ นี้ย่า. จาบื่อดื้งบื้อ แน จี่วีด จา แล โว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","พระเยซู จี่ ย้าง บ่าลีน กื้ง กาซื้ง ชฺ้าง ทื่อม่าง จา แง. ไยรัส ยู้ม เวอ จายล้า ชี. ไยรัส นา นี้แม้แน ม่า ล้า ชี, “ไยรัส เวอ, นาง อางย่า ม้า ซฺี้น ญ้า. อ่าจาน มางนา บ่าฮาย พี้ล้อง ปี่ กานโจ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","จ้า พระเยซู นี้เลิ่ง กงากย่า ยาว, แฮ้งเย่ ไยรัส นา ม่า ชี นี้แม้แน, “บ่ากงา แคคา เจ่อ ล่า กาโน, ยาว นาง อางย่าย่าบี่ ม้า แต่ล้า แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ยาว พระเยซู ไยรัส ยู้ม เวอ เคอ แล ยาว, พระเยซู อ่าซ่าง มางนา บ่าปี่ เค่ อ้องแล ปี่ เย, ยอห์น, ยากอบ, เปโตร แน ย่าเก มาง อางบา อางโบ้ง อือนา ย้าเย่ อ้องแล ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ยาว ชฺ้าง อือ ย่าเก ค่าบาย่า มางนา อู้ง ซฺ้า คูง เย. พระเยซู จี่ เย นี้แม้แน, “อู้ง แฮ้ง ว่าง คู โว! ย่าเก นี้ม้า บ่าซฺี้ กาซื้ง ยา ยู่ กาน แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ชฺ้าง แฮ้อืม พระเยซู นา อื้อกาน คูง เย, ไม้ ยอ แบ ป้าน่อ ย่าเก ค่าบาย่า นี้ม้า ซฺี้ ชี ม้าม้า ย้า แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","พระเยซู ย่าเก ค่าบาย่า ม่าง ล่าปู่ เวอ ชู ยาว จี่ช่าง เย นี้แม้แน, “ย่าเก อางอี เวอ, ทานล้า ปาว!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ยาว ย่าเก ค่าบาย่า ม่าง แต่ล้าน ชี เย, แฮ้งเย่ พระเยซู ยองนา ม่า ย่าเก มางนา จฺ่าเกิ่ง ซฺ้า ปี่ยาว ฮ้าน จฺ่า ล้า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","แฮ้งย้า ย่าเก ค่าบาย่า ม่าง อางบา อางโบ้ง มาง เย่ด มือ นืงบาม่าน คูชี เย, จ้า พระเยซู ม่า เย ฮากนา บ่าอู่บน้า ปี่ โจ แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","พระเยซู ศิษย์เอก 12 คู่น อือนา ฮ้าว ช้อน ชีเย, ยาว ยองนา ล่าที่ ปี่ ชีเย. ล่าที่ นี้ม้า แด่ย่า อางก่า อ่อก กงากา เย, แน พ่าญาด อางด้าอางกย้าง อางยา โปยว ปี่ กงากา เย. ");
INSERT INTO bzi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ยาว พระเยซู ยาง ศิษย์เอก 12 คู่น อือนา ซฺาแอ ปี่ชี่ เย, ไม้ พาจาว มาง ชฺ้างอางเมิง ก่าซ้าด ลือ เพล่อ อางเลิ่ง แฮ้ง ม่า ป่าว กว่า แอ ปี่ ชีเย. แน ชฺ้าง อางด้า อือนา ยา กว่า แอ ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ยาว พระเยซู ยองนา นี้แม้แน ม่า ชีเย, “เจิ้นเจ้อ บ่ากงา ฮ้าน แอ คา เป, ตื่น ล่าไมต้ามท้อ, แพล่อง, จฺ่าเกิ่ง, พลู้, อางก่าอางตูม เพ่น แล่เซฺ่อ อืม บ่ากงา ฮ้าน แอ คา เป. ");
INSERT INTO bzi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ยู้ม ล้อลาง ก้อง อ้องแล แง. โย้เวอ ดื้ง โว! นอง แฮ้เมิง ก้อง อ่อกแอ เมอ เคอ แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ยาว ชฺ้างอางเมิง ล้อเมิง นองนา บ่าลาบบ่าต้อน ล่าแง. แฮ้เมิง ก้อง อ่อกแอน โว! ยาว นอง ล่าคื่อ โย้เวอ ค้าล้า แฮ้ง ทาก อ่อก แล่ โว! ล่าคื่อ ค้าล้า ทาก อ่อก นี้ย่า ยองนา ม่า แบ จ่าแล่ ปี่ แง. พาจาว ม้า ยองนา วี่บ่ากไจ ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","แฮ้งเย่ ยอง อ่อกแอ พาจาว มาง อางเลิ่ง อางแม่น แฮ้ง ป่าว กว่า แอ คู ชี. ค่อง ค้าจา อือเมอ จ่อด ย้าเย่. ยาว ชฺ้าง แด่ย่า อ่อง ชี อือนา อางบย่า เย แด่ย่า ก่าอ่อก ปี่ชี่, แน ชฺ้าง อางด้า อือนาม อางบย่า ย้าเย่ ยา ชี. ");
INSERT INTO bzi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ยาว ก่าซ้าด เฮโรด กาลิลี แควน ฮูพลา มาง อางเลิ่ง ตอล้า ชี แฮ้ง กงากย่า ยาว นืงบาม่าน ชีเย, ไม้ ชฺ้าง ม่า ล้า ป้าน่อ พระเยซู อางเลิ่ง แฮ้ง นี้แม้แน, “ยา ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ มาง ซฺี้ ยาว, อางซฺื่อ แต่ล้า แล่ชี่ มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ยาว ชฺ้าง ทื่อบ่า อือ นี้แม้แน จี่ กาง เย, “ยา พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ ซฺี้ ยาว แต่ล้า แล่ชี่ มาง ย้า” แน. ชฺ้าง ทื่อบ่า อือย่า นี้แม้แน จี่ คูง เย, “ยา ค้าแต้ โย้เวอ พาจาวจี่ต่างจี่แต่นฮู แต่ล้า แล่ชี่ มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","จ้า ก่าซ้าด เฮโรด นี้แม้แน จี่ เย, “กงา ตาฮ้าน อือนา ม่า ยอห์น นา อางตู่ ต่อน ปี่ ย่า. ยาว ชฺ้าง ฮาก จี่ เคอ กงา กงากย่า ชี่ นี้ม้า อ่าซ่าง เวอ?” แน. แฮ้งเย่ ยาง มือ พระเยซู นา มย้าง ซี้ง แง. ");
INSERT INTO bzi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ศิษย์เอก อือ พ่าว ล้า แล่ เมอ, ยอง อางเลิ่ง ฮาย ล้า ชีย้าง พระเยซู นา อู่บ น้า ปี่ ชีเย. ยาว พระเยซู มือ ยองนา เบธไซดา อางเมิง เวอ ซฺื่ย แอ นาว ชฺ้าง อือนา บ่าปี่ แบ แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","จ้า ค่องช่าง อือ แบ คู ยาว พระเยซู ก้อง เค่ แอ นาว. พระเยซู ยองนา แม่น ย้าเย่ ลาบต้อน ชี. ยาว ยาง พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด ลือ เพล่อ อางเลิ่ง แฮ้ง อู่บน้า ปี่ ชีเย. ยาว พระเยซู ชฺ้าง อางด้า อือนา คาตา ย้าเย่ ยา ชี. ");
INSERT INTO bzi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","มู่งคี่ล้าก้า เคิน ยาว ศิษย์เอก 12 คู่น อืม พระเยซู นา นี้แม้แน ม่า ล้า ชี, “อ่าจาน เวอ, นู้ ตี อางกยาบ จฺ่าเกิ่ง บ่าจา. ยองนา ม่า พ่าว แอ แล่ ปี่ ปาว. ยองนา นู้เวอ ค่อง อางแท้ อือเมอ จฺ่าเกิ่ง แน ยู่ย่าดื้งย้า ซฺ้า แอ ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","จ้า พระเยซู นี้แม้แน ม่า ชีเย, “นองมู นี้ย่า ยองนา ม้างม้าเจ้อ ซฺ้า จฺ่า ปี่ ปาว” แน. ศิษย์ อืม พอ เย นี้แม้แน, “กงู ค้านู้มป่าง 5 ซื่อ แน ล่องแต่ 2 โต นี้งญา จา แง. ยอง คาโคลาโค นา จฺ่าก่อต้างก้อ แน จฺ่า ปี่ง แนยาว, กงู กงา วื้อ ปอ แล่กานาอี่” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","แฮ้เมอ, ค่าพ่าย่า 5,000 คู่น เย จา แง. ยาว พระเยซู มือ ยาง ศิษย์ อือนา จี่ช่าง เย นี้แม้แน, “นี้แม้แนยาว ยองนา ม่า ดื้ง ช้อน ลางกา ปี่ โว! 50 คู่น กา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ยาว ชฺ้าง อืม แฮ้แม้แน ดื้ง คู ชี. ");
INSERT INTO bzi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","พระเยซู มือ ค้านู้มป่าง 5 ซื่อ แน ล่องแต่ 2 โต ย่าง กอ ท้าม แล่ ยาว, มู่งท่า เวอ แมก่า ย่าง ฮู แล ปี่ ชีเย. ยาว พาจาว มางนา ขอบคุณ ฮา ชี, พระเยซู มือ ค้านู้มป่าง ย่าง ชีด ยาว ยาง ศิษย์ อือนา ปี่ ชี. ยาว ศิษย์ อือ มือ ชฺ้าง คาโคลาโค อือนา ฮ้าน จฺ่า แอ ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ยาว ค่องช่าง อืม ก้อ ย้า จฺ่า คู ชี, ยาว ศิษย์ อืม ชฺ้าง คาโคลาโค อือ ค้านู้มป่าง แน ล่องแต่ จฺ่าจาน ชี ย้าง 12 ซ้าล้อง กอกงา ชี. ");
INSERT INTO bzi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","พระเยซู ยาง ทื่อม่าง แน อธิษฐาน ฮา จา เมอ, ยาง ศิษย์ อือ ล้า คู ชี. ยาว พระเยซู มือ ยาง ศิษย์ อือนา น้า เย นี้แม้แน, “ฮาก กงานา อ่าซ่าง แน จี่ เคอ ล่าง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ศิษย์ มู อือ พอ ชีเย นี้แม้แน, “ทื่อบ่า ยอห์น ล้างตือพิธีบัพติศมา ฮา ปี่ฮู มาง แน ฮา คูแง. ทื่อบ่า เอลียาห์ พาจาวจี่ต่างจี่แต่นฮู ซฺี้ ยาว แต่ล้า แล่ชี่ มาง แน ฮา แง. จ้า ทื่อบ่า ค้าแต้ พาจาวจี่ต่างจี่แต่นฮู ซฺี้ ยาว อางซฺื่อ แต่ล้า แล่ชี่ มาง แน ฮา คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ยาว พระเยซู ยาง ศิษย์ อือนา น้า เย นี้แม้แน, “ท้าว นอ กงานา อ่าซ่าง แน เย้ง ล่า คู แง?” เปโตร พอ ชีเย นี้แม้ แน, “นาย่า พาจาว มาง แช้ยู้ ก่าซ้าด อางฮื่อ เพล่อ ปี่ชี่ แฮ้มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","แฮ้งย้า พระเยซู มือ ศิษย์ อือนา ปีนแตปีนนา แน ม่า ชี, ยา อ่าซ่าง แน ฮากนา บ่าม่า แบ ปี่ โจ แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ยาว พระเยซู จี่ เย นี้แม้แน, “กงาชฺ้างอางย่า เพล่อ ชี นี้ม้า ไลย่างไลเจ้อ ย้า กงาโอ้ด ตูกพานลาบ้าบ แง. ยิวชฺ้าง ยอคา อือ, ปุโรหิต ยอคา อือ แน อางลี้บอางล่าว ม่าอู่บฮู อือ กงา จี่ต่าง แฮ้งนา บ่าเจ่อ คู. แน กงานา ฮาก แซ่ ล่าแง. จ้า พาจาว ม้า กงา ซฺี้ ยาว ว่านที่ 3 แฮ้นืง เวอ ฮา แต่ล้า ปี่ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ยาว พระเยซู มือ ชฺ้าง คาโคลาโค อือนา ม่า เย นี้แม้แน, “อ่าซ่าง กงานา เค่ ล่าซี่ง แง, ค่าตอง นืงบาวา แน ฮา แฮ้ง ว่าง ยาว, ค่าตอง ไม้กางเขน แฮ้ง กูนืงกูนืง แน ป่า แล่ยาว กงาก้อง เค่ ลาน โว! ");
INSERT INTO bzi_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ไม้ ชฺ้าง ค่าตอง จี่วีด แฮ้งนา กงานา ล่อบ่าปา แน ลาก อือ กงาซฺี้ แง. จ้า อ่าซ่าง กงานา เจ่อ ล่า ปาปาย ซฺี้ แง, ชฺ้าง แฮ้ม้า จี่วีดม้าม้า กงา จา แล แง. ");
INSERT INTO bzi_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","จาว่าแน ชฺ้างอางเมิง นู้เวอ กูย่างกูเจ้อ จา ชี อือ อางซื้ง กงาเพล่อ ยาว, จี่วีดม้าม้า บ่าจา ยาว บ้าเจอ จองไจ จา แง? ");
INSERT INTO bzi_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ยาว อ่าซ่าง กงานา แน กงา ม่าอู่บจี่ต่าง แฮ้งนา ซฺ่าจอ ล่าแง, กงาชฺ้างอางย่า เพล่อ ชี นี้มาง แน อ่าโบ้งพาจาว แน เท่วาด่า อือ, กงู ทื่งกง่า แน แปล้นซ้า แน ลือ เมอ, กงาม มือ ชฺ้าง แฮ้มาง นา ซฺ่าจอ แง. ");
INSERT INTO bzi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ยาว นองมู นู้ จูง จา อือ เวอ, กงา ม่า แบ ปี่ ล่าว่า. ทื่อบ่า บ่าซฺี่ ฮู เวอ, พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด ลือ เพล่อ ชี แฮ้ง กงามย้าง เปิน แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ยาว 8 นืง ซฺ่า จายล้า แล่ นี้ง ย้า, พระเยซู มือ เปโตร ยอห์น แน ยากอบ ยองนา, ตาแซ้ เวอ ซฺื่ยแล ยาว อธิษฐาน ฮา แล ชี. ");
INSERT INTO bzi_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ยาว พระเยซู อธิษฐาน ฮา จา เมอ แมก่า ย่าง เพ่น ชี. พระเยซู ค่าลาว ย่าง ซี้ อางป่อน เพล่อ ล้า ชี แปล้นซ้า ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ยาว โมเสส แน เอลียาห์ พาจาวจี่ต่างจี่แต่นฮู มางเย่ด พระเยซู นา จี่ช่าง ชี. ");
INSERT INTO bzi_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ยาว โมเสส แน เอลียาห์ เย่ด จา โย้เวอ นาบาตา ย้าเย่ แปล้นซ้า แง. ยาว ยอง อางเลิ่ง จี่ กาง แฮ้ย่า บ่ามล่าง ยาว, พระเยซู เยรูซาเล็ม อางเมิง ชา ซฺี้ อางเลิ่ง แฮ้ง จี่ เคอ กาง เย. ");
INSERT INTO bzi_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","จ้า เปโตร แน ยาง อางช่าง อือย่า ยู่ คู ชีเย, จ้า ยอง ดู่ง ทานล้า ยาว, พระเยซู อางโต โย้เวอ อางแปล้นอางซ้า มย้าง ชี. ยาว ค่าพ่าย่า 2 คู่น พระเยซู ก้อง จูง จา นา มย้าง ชี. ");
INSERT INTO bzi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ค่าพ่าย่า มาง เย่ด ชา แอ เมอ, เปโตร พระเยซู นา จี่ช่าง เย นี้แม้แน, “อ่าจาน เวอ, อางแม่น ย้า กงู นู้ ดื้ง ชีนี้. กงู ซ่าวย่า ชฺอ เซฺ้อ 3 ลาง, ไม้ กงูนา จ้าม ชี ปี่ ล่าแง กงู นู้ อางล้า กางซื้ง แน. นางนา ทื่อลาง โมเสส นา ทื่อลาง แน เอลียาห์ นา ทื่อลาง ชฺอ ปี่ เซฺ้อ” แน. จ้า เปโตร จี่ ชี นี้ย่า บ่ากงา เย้ง ชี ลางออน เย. ");
INSERT INTO bzi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","เปโตร จี่ เมอ, มู่งบื่น ย่าง ยองก้อง ล่อย ลือ นาว. ยาว ยอง แค คูง เย. ");
INSERT INTO bzi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ยาว มู่งบื่น โย้ พาจาว มาง อางเซง ย่าง อ่อก ลือ ชีเย นี้แม้แน, “นี้ย่า กงา อางย่า กงา แช้ยู้ ชี มาง ย้า. ยางนา น้าจ่า โว เป” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","พาจาว มาง จี่ เปิน ยาว, ยอง มือ พระเยซู นา ญา เย มย้าง ชี. ยาว ศิษย์ อือมือ อางเลิ่ง มย้าง ชี แฮ้ง, อ่าซ่าง มาง นา บ่าอู่บน้า ปี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ยาว ทื่อนืง จายล้า แล่ยาว, ยองมู ย่าง ตาแซ้ เวอ ย่อ ลู่ง ลือ เมอ, ค่องช่าง อางอีบ่าอ่า เย พระเยซู นา ซฺ้า ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ยาว ค่าพ่าย่า ทื่อม่าง จา เย ชฺ้าง อางมู เวอ จี่ฮ้าว ล้า ชีเย นี้แม้แน, “อ่าจาน เวอ, กงา อางย่าย่าค่า นี้ มางนา ปล่อง ล่า ปาโน. กงา อางย่า ทื่อม่าง ญา จา แง. ");
INSERT INTO bzi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ยาง อางโต โย้เวอ แด่ย่า อ้อง ปี่ชี่ ยาว บื้งฮ้าว แง. กาเทอกา แด่ย่า มาง ย่าเก มางนา ฮา เลิง ปี่ ยาว, ฮา ยืก ปี่ แง แน ยาง ม่านป่อง โย้เวอ ค่านล่าง ปลื้ง ย้า. แด่ย่า มาง บ่าตื่อ อ่อก กา. ยาง นา อางไล้ ฮา แง. ");
INSERT INTO bzi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","แฮ้งย้า กงาม นาง ศิษย์ อือนา ป้า ปล่อง ปี่ แง, จ้า ยอง มือ บ่าปล่อง กงากา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “ชฺ้าง บ่าเจ่อ อือ เวอ, กงา นองก้อง อางมล่าง ล่า กงาดื้ง แล แล่แง? กงา นองนา อางมล่าง ล่า กงาโอ้ด แล แล่ ล่าแง?” ยาว พระเยซู มือ ย่าเก มาง อางโบ้ง มางนา นี้แม้แน ม่า ชีเย, “นาง อางย่า มางนา ซฺื่ย ลา ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ย่าเก มาง ย่อ ลา เมอ, แด่ย่า มาง ย่าเก มางนา ฮา เลิง แอ ปี่ ยาว ฮา ยืก ปี่ นาว. พระเยซู แด่ย่า มางนา อี่ ยาว ก่าอ่อก ชีเย. ยาว ย่าเก อางโบ้ง มางนา นี้แม้แน ม่า ชีเย, “นาง อางย่า มางนา นาง ยู้ม เวอ ซฺื่ย แอน ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ยาว ค่องช่าง อืม พาจาว มาง ล่าที่ อางฮื่อ แฮ้ง, แน ย่าเก มางนา แด่ย่า ก่าอ่อก ปี่ชี่ แฮ้ง นืงบาม่าน คู ชีเย. ชฺ้าง มู อือ พระเยซู ฮา ชีแฮ้ง มย้าง ยาว นืงบาม่าน คู เมอ, พระเยซู มือ ยาง ศิษย์ อือนา จี่ช่าง ชีเย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“กงา นองนา ชา ม่า ล่าง นี้ง แม่น แน น้า เป, กงาชฺ้างอางย่า มาง เป. ยาว ชฺ้าง กงานา บ่าแม่น เย้ง ช่าง ล่าง อือย่า กงานา ชา ชู ล่า แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","จ้า ศิษย์ อือ บ่าแบ คู เย พระเยซู ย่า บ้าเจอ จี่เคอ แงแน, ไม้ พาจาว มาง ยองนา บ่าปี่ แบ วา. จ้า อ่าซ่าง มาง บ่าน่า จอ กาเย. ");
INSERT INTO bzi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ทื่อนืง จา แง ศิษย์ มู อือ จี่เจ้ กาเย นี้แม้แน, อ่าซ่าง ชฺ้าง อางฮื่อ เลิ่นเลิ่น ม้า? แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","พระเยซู อางแบ เย ยองมู นืงบา คล้าว โย้ ล้อแม้ เย้ง แงแน. แฮ้งย้า ยาง มือ ย่าเก ทื่อม่าง นา ซฺื่ยล้า ยาว, ยาง ก่องทาง เวอ จูง ล้า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ยาว ศิษย์ อือนา นี้แม้แน ม่า ชีเย, “อ่าซ่าง กงานา เจ่อ ล่า ปาปาย, ย่าเก อางอี นี้อือ แม้แน ชี่ อือนา แม่นช่าง แง. ชฺ้าง แฮ้ม้า กงานา แม่นช่าง ล่าชี่ แน ทื่อช่างกานญา, แน อ่าซ่าง กงานา แม่นช่าง ล่าแง, พาจาว กงานา ซฺาลือ ปี่ ล่าชี่ มางนา แม่นช่าง ชี แน ทื่อช่างกานญา. นองมู นู้เวอ ชฺ้าง ปีนแตปีนนา บ่าอ่า อือ, พาจาว มาง ฮูยาว ชฺ้าง ปีนแตปีนนา เพล่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ยอห์น มือ พระเยซู นา นี้แม้แน อู่บน้า ปี่ชี่, “อ่าจาน เวอ, กงูมู นี้ย่า ค่าพ่าย่า ทื่อม่าง แด่ย่า ก่าอ่อก นา มย้าง คูแอ้. ยา นาง อางเม้ง แฮ้ง ไจ แด่ย่า ก่า แง. จ้า ยา กงู อางมู บ่าอ่า แฮ้งย้า กงูม ยางนา ม่า ว่าง ปี่ แอ่” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","แฮ้งเย่ พระเยซู มือ ยอห์น นา จี่ช่าง ชี นี้แม้แน, “ยองนา บ่าม่า ว่าง ปี่ โจ! ไม้ ชฺ้าง กงูนา บ่าซีบ่าแล ช่าง ล่าง อือย่า กงู อางมู” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","บ่ามล่าง ยาว พาจาว มาง พระเยซู นา มู่งท่า เวอ ล่า แล แง. แฮ้งเย่ พระเยซู เยรูซาเล็ม อางเมิง เวอ แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ยาว พระเยซู มือ ศิษย์ ทื่อบา อือนา แอ ลางออน แอ ปี่ นาว. ยองมู ย้าง สะมาเรีย ค่อง เวอ อ้องแล ชีเย, ยาว พระเยซู นา อางเกิ่ง เก้ม ล่อ คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","จ้า โย้เวอ ชฺ้าง อือ พระเยซู นา บ่าลาบบ่าตอน คู เย, ไม้ ยอ อางแบ เย พระเยซู เยรูซาเล็ม อางเมิง เวอ ชา แอ แงแน. ");
INSERT INTO bzi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ยากอบ แน ยอห์น พระเยซู ศิษย์ มาง เย่ด แฮ้แม้ มย้าง ยาว จี่ เย นี้แม้แน, “อ่าจาน เวอ, กงูย่า มู่งท่า เวอ บี่ท่อ แฮ้งนา ฮ้าว ชฺ้าง นี้มู นา กลา จฺ่อ ปี่ โค ปยาเด่?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","จ้า พระเยซู มือ ยองนา อี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ยาว ยองมู ย่าง ค่อง ทื่อค่อง เวอ แลน แล่ น้าว. ");
INSERT INTO bzi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ยาว ยอง แก้บ้า ย่อ แล เมอ, ค่าพ่าย่า ทื่อม่าง จา เย พระเยซู นา จี่ช่าง เย นี้แม้แน, “นา เกิ้ง แอ แง กงา คาตา ยา เค่ แอ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ยาว พระเยซู มือ ยางนา พอ เย นี้แม้แน, “ฮ้อนโจ้ง นี้ย่า ดื้งย้า อางจา, ฮาย่า ปย้าม กว่า อืม มือ อางป่าม ดื้งย้า อางจา, จ้า กงาชฺ้างอางย่า นี้ม้า ยู่ย่า ดื้งย้า บ่าจา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ยาว พระเยซู ชฺ้าง ทื่อม่าง มางนา จี่ช่าง เย นี้แม้แน, “กงาก้อง เค่ ล้า ปาว” แน. จ้า ค่าพ่าย่า มาง พอ ชีเย นี้แม้แน, “กงานา อ่าโบ้ง นา พ่าว ซฺ้า แล ปี่ ล่าปาว. ยาว ยาง ซฺี้ เมอ, กงา ยาง อางโต แฮ้ง พูม ยาว นางก้อง เค่ แล แน” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","แฮ้งเย่ พระเยซู มือ ม่า ชี นี้แม้แน, “ชฺ้างซฺี้ต่องชฺ้างซฺี้ แน พูม ลางกา ปี่ ปาว. จ้า นา พาจาว มาง ชฺ้างอางเมิง นู้ ก่าซ้าด เพล่อ ลือ ชีนี้ง, ชา ป่าว กว่า แอ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ยาว ค่าพ่าย่า ทื่อม่าง มาง จี่ ชีเย นี้แม้แน, “กงา นางก้อง เค่ แอ แน, จ้า กงา ยู้มชฺ้าง อือนา ม่า แล ปานา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","แฮ้งเย่ พระเยซู มือ พอ ชี นี้แม้แน, “อ่าซ่าง กงาก้อง เค่ แล ยาว ยาง จี่วีด อางอ้าน แฮ้งนา โมงซฺ้า แง, ชฺ้าง แฮ้ม้า พาจาว กงู ก่าซ้าด มาง ล่ากาน ว่า แฮ้ง บ่าซูม เป” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","น่อง โย้เวอ จายล้า แล่ ยาว, จี่วีดอางซื้ง มาง ชฺ้าง มู เค่ ลา ชี โย้เวอ ชฺ้าง 72 คู่น แช้ยู้ แล่ ชีเย. ยาว อางกู่ อางกู แน ซฺาแอ ปี่ ชีเย, ยาง อางเมิง แน ค่อง ชา แล แฮ้อือ ก้อง ซฺาแล ลางออน แล ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ยาว พระเยซู ยองนา ม่า เย นี้แม้แน, “ชฺ้าง อางบย่า ย้า กงานา เจ่อ ล่าซี้ง แง, จ้า ชฺ้าง อางเลิ่ง อางแม่น ป่าวกว่าฮู นี้ย่า อางบย่า แน บ่าจา. ชฺ้าง นี้อือ ย่า อางคลาอางซ้าง อางซื่อ บย่า แน ซื่อ ล้า ยาว ชูญ่าม เคอ ชี อือ ช้อด ย้า, จ้า ชฺ้าง ล่ากาน ว่าฮู ชูฮู อือ บ่าบย่า. แฮ้แม้แนยาว พาจาว มางก้อง ชฺ้าง อางเลิ่ง อางแม่น ป่าวกว่าฮู ป้า คูโว! ");
INSERT INTO bzi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ยาว แอ คู ปาว, จ้า บ่าลู่ม โจ เป กงา นองนา ซฺาแอ ปี่ ล่าง นี้, น่อ แกะอางย่า ฮ้อนโจ้ง ก้องนื้ง เวอ ดื้ง ชี แน ทื่อช่างกานญา เป. ");
INSERT INTO bzi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ยาว พลู้ แน แพล่อง บ่าฮาน แอ คู โจ! ยาว แค้บ แฮ้ง ฮ้านเพ้อ แน บ่าฮาน แอ โจ! แก้บ้า ย่อ แอ คู เมอ ไว่ไว่ แน แอ คู โว! ชฺ้าง นา มย้าง ยาว บ่าซ่าว จี่ช่าง คู โจ! ");
INSERT INTO bzi_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","นอง ยู้ม ล้อลาง ก้อง อ้องแล แง ยองนา นี้แม้แน ก่ามป่อน ปี่ โว, จาบื่อดื้งบื้อ แน จา แล โว แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","จาว่าแน ชฺ้าง แฮ้อือ นองนา แม่น แน ฮูพลา ล่ายาว, พาจาว มาง ยองนา ก่ามป่อน ปี่ แง. จ้า ยอง นองนา แม่น แน บ่าฮูบ่าพลา ล่ายาว, พาจาว มาง ยองนา ก่ามป่อน บ่าปี่. ");
INSERT INTO bzi_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ยาว นอย่า ยู้ม ล้อยู้ม ก้อง ดื้ง แง, แฮ้ลาง ก้อง ย้า ดื้ง แล โว, บ่าพ่าง กว่า โจ. ยอง บ้าเจอ จฺ่าต้าง ปี่ ล่าเวิม จฺ่า กาโน, ล่ากานว่าฮู นี้ย่า จฺ่าเกิ่งต่างก้อ ยาง ล่ากาน ว่าฮู่ แฮ้ง ล่อ ย้า กงาบู้ แง. ");
INSERT INTO bzi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ยาว ค่อง ล้อค่อง ก้อง กงา อ้องแล แง. ฮาก บ้าเจอ ปอ ปี่จฺ่า ปี่ต้าง ล่าเวิม มือ จฺ่า กาโน. ");
INSERT INTO bzi_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","แฮ้ค่อง ก้อง ชฺ้าง อางด้าอางกย้าง อือนา ยา จ่า กาโน. ยาว ยองนา ม่า โว นี้แม้แน, ‘พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ อางญ่าม ย่าง แท้ ล้าน ญา.’ ");
INSERT INTO bzi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","จ้า ค่อง ล้อค่อง ก้อง ชฺ้าง อือ นองนา บ่าลาบบ่าต้อน ล่ายาว, แก้บ้า โย้เวอ ยองนา นี้แม้แน จี่ โว, ");
INSERT INTO bzi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘จาว่าแน นี้เมิง ก้อง ค้าล้า อือ กงู ล่าคื่อ นู้เวอ ต่า ยาว, กงู ทาก อ่อก แล่ แง โค ย้า. กงู ยองนา แบ ปี่ แง, พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ อางญ่าม ย่าง แท้ ล้าน ญา’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","กงา ม่า ล่าว่า ค่อง แฮ้ค่อง เวอ ชฺ้าง อือย่า. ต้าดต่อน นืง เคอ เมอ, โสโดม อางเมิง ชฺ้าง อือ ล่อบ่าปา ย้า วี่บ่ากกงาไจ คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","แฮ้งย้าเย่ พระเยซู มือ นี้แม้แน จี่ แง, “โคราซิน อางเมิง ชฺ้าง เวอ, แน เบธไซดา อางเมิง ชฺ้าง เวอ, กงา นอง อางเมิง คล้าว โย้เวอ, อางเลิ่งชฺ้างบ่าฮาตอกางอือ ไลเจ้อ ย้า ฮาย มย้าง ปี่ ล่าแอ่. จ้า นอง บ่าเจ่อ จ่าล่า, แฮ้งย้า พาจาว มาง โคราซิน อางเมิง แน เบธไซดา อางเมิง ชฺ้าง อือนา วี่บ่ากไจ ปี่ชี่. จาว่าแน กงา ไทระ อางเมิง ชฺ้าง แน ไซดอน อางเมิง ชฺ้าง โย้เวอ นอง อางเมิง โย้เวอ ฮา ชี แม้แน ฮา ยาว, มล่าง คางญ้า อางเมิง ชฺ้าง แฮ้อือย่า, อางซีอางแล แบจ่าแล่ คู ยาว นืงบาเพ่น คู แง. ยาว อางก่าอางตูม ก่าซ่อบ พ้า อางซา อือ ตูม แล่ คู แง. ยาว บี่ย่าวค้าล้า อางตู่ โย้เวอ พ่อ แล่ คู แง. นี้แม้ ฮา ชี นี้ย่า ฮากนา ม่ายแบ ปี่ ยอย่า ม้าม้า ย้า นืงบาเพ่น ชี แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","พาจาว มาง อางซีอางแล ต้าดต่อน แฮ้นืง ย้า, โคราซิน อางเมิง ชฺ้าง แน เบธไซดา อางเมิง ชฺ้าง นี้, ไทระ อางเมิง ชฺ้าง แน ไซดอน อางเมิง ชฺ้าง อือ ล่อบ่าปา วี่บ่ากกงาไจ แง. ");
INSERT INTO bzi_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","แน คาเปอรนาอุม อางเมิง ชฺ้าง นี้ง ทื่อช่างกานญา, บ่าเย่ง โจ เป พาจาว มาง นองนา มู่ง เวอ ซฺื่ยแล ล่าง แน. แฮ้แม้ บ่าอ่า เป น่อ ชฺ้างซฺี้ อางเมิง เวอ กงา กลา แอ ชากอน ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ยาว พระเยซู ยาง ศิษย์ อือนา นี้แม้แน ม่า ชีเย, “ชฺ้าง นอง จี่ต่าง นา น้าจ่า ล่าง อือย่า, กงา จี่ต่าง นา น้า จ่า ชี แน ทื่อช่างกานญา. ชฺ้าง นองนา บ่าเจ่อ แน จี่ต่าง บ่าน่า จ่า ล่าง อือย่า, กงานา บ่าเจ่อ แนยาว กงา จี่ต่าง นา บ่าน่า จ่าล่า แน ทื่อช่างกานญา. ชฺ้าง กงานา บ่าเจ่อ ล่าง อือย่า, พาจาว กงานา ซฺาลือ ปี่ ล่า ชี่ มางนา บ่าเจ่อ แน ทื่อช่างกานญา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ยาว ศิษย์ 72 คู่น พระเยซู ซฺาแอ ปี่ชี่ อืม พ่าว ลา แล่ชี่เย. ยองมู นี้ย่า นาบาตา กย่าง พระเยซู นา นี้แม้แน ม่า ชีเย, “อ่าจาน เวอ, กงู นาง อางเม้ง จี่ อ่อก เมอ ซ้ามบา แด่ย่า อืม กงู จี่ต่าง นา น้าจ่า ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","พระเยซู พอ เย นี้แม้แน, “กงาย่า ซาตานแด่ย่ายอคา มู่งท่า เวอ จาย กลา ลือ นา มย้าง แอ มู่งบล่าบ ช้อด ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","กงา นองนา ล่าที่ ปี่ ล่าแอ่, นองนา ฮาย ซาตานแด่ย่ายอคา มาง ล่าที่ แฮ้งนา ก่าจ่า ปี่ ล่าแอ่. นอ อื้อล้าง อางปีด แน แมงป่อง อือนา น่าง เวิม บ่าด่าบ่ากย่าง เป. ฮาก นองนา บ่าแม่น เย้ง ช่าง ล่าง อือนา, เจิ้นเจ้อ อางไล้ บ่าปี่ ฮา ล่า กงากา แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","จ้า แด่ย่า อือ นอง จี่ต่าง แฮ้งนา น้า จ่าล่า ชี่ แฮ้งนา บ่ากย่าง คูโจ. จ้า พาจาว มาง นอง อางเม้ง คาโคลาโค, มู่งท่า ชา อ้องแล อางเม้ง ปาบ โย้ แต้ม กาน ชี ชี แฮ้ง กย่าง คูโว!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","แฮ้ญ่าม เมอ, อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง พระเยซู นา ฮาย กย่างม่อนซ้า ปี่ ชีเย. พระเยซู มือ จี่ เย นี้แม้แน, “อ่าโบ้งพาจาว เวอ, นา มู่งท่า แน ชฺ้างอางเมิง อางซื้ง มาง ย้า. กงา นางนา สรรเสริญ ฮา ล่าแน. ยี่นดี ย้าเป นาง นี้เลิ่ง ชฺ้าง อางแอ้น อางแบ อือนา โชง ชี ชี นี้ย่า, จ้า ชฺ้าง บ่าแบบ่าบู่ ย่าเก ป้าค้า อือนา แบ ปี่ชี่ นี้ย่า. อางอ้า ย้า อ่าโบ้งพาจาว เวอ, นาง เพล่อ ปี่ ซี่ แม้แน เพล่อ ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“พาจาว กงา อ่าโบ้ง ม้า, กงานา กูย่างกูเจ้อ อือ ล่อบ่าปา แน ล่าที่ จา ปี่ ล่าแง. กงานา อ่าซ่าง มาง บ่าแบ ล่า กงากา, พาจาว กงา อางโบ้ง มาง ญา อางแบ ล่า กงากา แน. ยาว พาจาว กงา อ่าโบ้ง มางนา อ่าซ่าง มาง บ่าแบกงากา, กงา แน กงา ชฺ้าง แช้ยู้ ชี่ อืนญา, พาจาว กงา อางโบ้ง มางนา อางแบ กงากา แน.” ");
INSERT INTO bzi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","พระเยซู ยาง ศิษย์ อือก้อง ทื่งกง่า แน ดื้ง เมอ, ยาง ศิษย์ อือนา พลาบ จี่ช่าง เย นี้แม้แน, “พาจาว มาง นองนา ก่ามป่อน ปี่ ล่าชี่ นี้ย่า, นองนา อางเลิ่ง อางแม่น กงามย้าง ปี่ ล่าชี่ นี้ง ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","กงาย่า นองนา ม่ายแบ ปี่ ล่าว่า นี้แม้แน, อามือ นอง อางเลิ่ง กงากย่า กงามย้าง ชี นี้ย่า, ค้าแต้ พาจาวจี่ต่างจี่แต่นฮู แน ก่าซ้าด อือย่า นาบาตา แน กงากย่า กงามย้าง คู ซี้ เวิม, ยอ บ่ากงากย่า แน บ่ากงามย้าง คู” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ยาว อางลี้บอางล่าว ม่าอู่บฮู ทื่อม่าง จา ชีเย. ยา แบ ซี้ แง พระเยซู อางลี้บอางล่าว ม้าม้า ล่า แบบู่ แงแน. แฮ้งย้า ทานล้า ยาว พระเยซู นา นืงบาเจ้อฮู ชี. ยาง น้า เย นี้แม้แน, “อ่าจาน เวอ, พาจาว มางก้อง ทื่งกง่า แน จี่วีดม้าม้า จา แล นี้ย่า, กงา บ้าเจอ กงาฮา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ยาว พระเยซู นี้แม้แน พอ ชีเย, “โมเสส อางลี้บอางล่าว เวอ นี้เลิ่ง นา ล้อแม้ แต้ม ชี ชี? ยาว นา ล้อแม้ แบบู้ แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ยาง พอ ชีเย นี้แม้แน, “จี่วีดอางซื้ง มางนา นืงบา โค, ก่ามกืด โค, แฮ่ง โค แน ลาก โว! ค่าตอง นา ลากจ่าแล่ง แฮ้งแม้แน ยู้มต่องยู้มทาง อือนา ลาก โว!” ");
INSERT INTO bzi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ยาว พระเยซู มือ จี่ เย นี้แม้แน, “กง่า คางญา แฮ้แม้ ฮา แล เป, ยาว พาจาว มางก้อง จี่วีด กงาจากงาดื้ง แล แง.” ");
INSERT INTO bzi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","จ้า ยา ฮากนา ฮาย ฮู ปี่ ซี้ แง, ยาง นี้แม้ น้า ชีนี้ กง่า คางญา แน. ยาว ยาง นี้แม้ น้า แล่ แง, “กงา ยู้มต่องยู้มทาง ชฺ้าง ม้า อ่าซ่าง?” ");
INSERT INTO bzi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","พระเยซู พอ เย นี้แม้แน, “ค่าพ่าย่า ทื่อม่าง จา เย, ยา ยิวชฺ้าง เยรูซาเล็ม อางเมิง เวอ จาย เยรีโค อางเมิง เวอ ย่อ แล ชีเย. จ้า แก้บ้า ย่อ เมอ ค่ามู่ยค่ามโจน อือ ปู่น, ยาง ค้าจา แฮ้ง ยู ปี่ชี่ ยาว ยางนา ตื่อ ยาว ฮื่น ชี, ค่าพ่าย่า มางนา ด้า จา ปี่ น้าว, ป้าดจา ซฺี้ เย แก้บ้า ก่องทาง โย้เวอ. ");
INSERT INTO bzi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","จ้า ปุโรหิต ทื่อม่าง ย่อ ลือ ชีเย, ยาง ค่าพ่าย่า มางนา มย้าง ยาว, ยาง แก้บ้า ทื่อปล่าก ป่ากย่า ย่อ แอ นาว. ");
INSERT INTO bzi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ยาว โบสถ์ เวอ ปล่องฮู ว่าฮู ทื่อม่าง มาง ทื่อช่างกานญา, ยาง ค่าพ่าย่า มางนา มย้าง ยาว, ยาง แก้บ้า ทื่อปล่าก ป่ากย่า ย่อ แอ นาว. ");
INSERT INTO bzi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","จ้า สะมาเรียชฺ้าง ยิวชฺ้างบ่าอ่า มาง ย่อ ไกลือ ชีเย, ค่าพ่าย่า มาง นา มย้าง ยาว, ยาง ซื่งกง่ากย้า เย่. ");
INSERT INTO bzi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","อางไว่อางคย้าง ย้าเย่ อ้อง ปล่อง แล่ ชี, อ่างู่น แต่ค่า แน น้ำมันมะกอก ย่าง ค่าพ่าย่า มาง ด้า เวอ กาน ปี่ ชีเย, นี้แม้ ฮา ชี นี้ ค่าพ่าย่า มาง ด้า แฮ้งนา บ่าปี่ ด้า แน เย, พ้า ป้าน ปี่ ยาว ยาง ลา มาง ต่างค่าง เวอ อาม ตา ปี่ นาว. ยาว โรงแรม เวอ ซฺื่ยแล ชีเย, ยาว ยา จ่า แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ยาว ทื่อนืง จายล้า แล่ยาว, สะมาเรียชฺ้าง นี้มาง โรงแรม อางซื้ง มางนา พลู้ 2 เหรียญ ปี่ น้าว, ยาว นี้แม้แน ม่า ชีเย, ‘ยางนา แม่น แน ฮูพลา เป, ยาว อางฮู่ ลามแล ชี แฮ้ย่า กงา พ่าวลือ แล่ เมอ ปี่ ล่าว่า’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ยาว พระเยซู น้า ชีเย นี้แม้แน, “นาง เย้ง ฮู แล่ว แล, ชฺ้าง 3 คู่น นี้ย่า ล้อมาง เวอ, ชฺ้าง ค่ามู่ยค่ามโจน ปู่น ชี มาง ยู้มต่องยู้มทาง มาง แน ฮาย แบ ปีง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ยาว อางลี้บอางล่าว ม่าอู่บฮู มาง พอ เย นี้แม้ แน, “ชฺ้าง ค่าพ่าย่า อางด้า มางนา ซื่งกง่ากย้า ฮาช่าง มาง” พระเยซู ยางนา จี่ช่าง เย นี้แม้แน, “นี้แม้แน ยาว นาง ยาง แม้แน ฮา ฮู แล.” ");
INSERT INTO bzi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","แก้บ้า ย่อ เมอ พระเยซู แน ยาง ศิษย์ อือ, ค่อง ทื่อค่อง เวอ อ้องแล ชี. ค่อง โย้ ค่าบาย่า ทื่อม่าง จา เย อางเม้ง มารธา แน. ยาง พระเยซู นา ยาง ยู้ม เวอ ป้า ดื้ง ปี่ นาว. ");
INSERT INTO bzi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ยาว มารีย์ มารธา อางป่อ มาง จี่วีดอางซื้ง มางก้อง แท้ แน ดื้ง ชีเย. ยา พระเยซู จี่ แฮ้งนา ดื้ง น้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","จ้า มารธา จฺ่าเกิ่ง แต่ง แฮ้ง ซืกซาก ชีเย ยาง พระเยซู นา ม่า เย นี้แม้แน, “อ่าจาน เวอ, นา บ่าแบ ล่า กงา อางป่อ ม้า กงานา ทื่อม่าง แน ล่ากาน ตอ ว่า ปี่ ล่าแง? ยางนา ม่า กงานา ปล่อง ปี่ ล่า ปาโน” แน. ");
INSERT INTO bzi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","จ้า จี่วีดอางซื้ง มาง ยางนา พอ เย นี้แม้แน, “มารธา เวอ, นาง นืงบาต่อง โย้เวอ อางเลิ่ง ไลเลิ่ง ย้า จา แง นางนา ฮา ซืกซาก ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","จ้า ทื่อย่าง ย่า จา แง ปีนแตปีนนา เลิ่นเลิ่น แน. ยาว มารีย์ อางแม่น เลิ่นเลิ่น แฮ้เลิ่ง แช้ยู้ ชี, แน อ่าซ่าง มาง ยางนา บ่าย่าด ฮื่น กงากา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ยาว ทื่อเทอ จา แง, พระเยซู ตี ทื่อตี เวอ อธิษฐาน ฮา เปิน เมอ, ศิษย์ ทื่อม่าง อ้อง ล้า ยาว น้า ชี นี้แม้แน, “อ่าจาน เวอ, อธิษฐาน ฮา อางเลิ่ง ยอห์น ยาง ศิษย์ อือนา ม่าอู่บ ชี แฮ้, บ้าเจอล้อแม้ อธิษฐาน ฮา แงแน กงูนา ม่าอู่บ ล่าปาว.” แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ยาว พระเยซู มือ ม่าย ชี นี้แม้แน “นอง อธิษฐาน ฮา เมอ, นี้แม้แน จี่ โว!” “พาจาว กงู อางโบ้ง มาง เวอ, นางนา ชฺ้าง อือนา สรรเสริญ ฮา แล ปี่ โว.” “กงู นางนา ป้า ชฺ้างอางเมิง นู้เวอ อางไว่ แน ก่าซ้าด เพล่อ ปี่ ล่าแง.” ");
INSERT INTO bzi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","“มี้นืง กงูนา จฺ่าเกิ่ง จฺ่าเซฺ่อ ก้อ แน ปี่ ล่า ปาว.” ");
INSERT INTO bzi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","“กงู อางบล่าบ ฮา ชี แฮ้งนา อางซี บ่ายู ล่าโจ. ฮาก กงูนา อางบล่าบ ฮา ล่า เมอ กงู ยองนา อางซี บ่ายู แฮ้งแม้แน.” “กงูนา ปล่อง เจิ้นเจ้อ อางซี บ่าปี่ ฮา ล่าโจ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ยาว พระเยซู จี่ แล่ง นี้แม้แน, “จาว่าแน 12 โมง มู่งคี่ โย้เวอ นางก้อง อางช่าง บ่อซฺา ล้า เมอ, นาง ยู้ม โย้เวอ เจิ้นเจ้อ จฺ่าปี่เซฺ่อ บ่าจา. แฮ้งย้า นาง 12 โมง มู่งคี่ โย้เวอ, นาง อางช่าง ทื่อม่าง มางนา ซฺาแล ยาว นี้แม้แน ฮ้าว ม่า, ");
INSERT INTO bzi_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‘กงา อางช่าง เวอ, จฺ่าเกิ่ง ปี่ ล่าว แล. ไม้ กงาก้อง อางช่าง ล้าน ชี, จ้า กงา ยู้ม โย้เวอ เจิ้นเจ้อ จฺ่าเซฺ่อ บ่าจา.’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ยาว อางช่าง นาง จฺ่าเซฺ่อ ป้า แล ชี มาง นี้แม้แน พอ ล่าง, ‘บ่าฮ้าว ล่า โจ! ล้องก้อ ย่าง อางแซ่ กาน ย่า. กงา แน อางย่า อืม ยู่ป่าม คล้าว เวอ ยู่ โค ญา. เจิ้นเจ้อ บ่าทาย กอ ปี่ ล่า กงา ชีล้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","กงา ม่ายแบ ปี่ ล่าว่า, อางช่าง กาเวิม บ่าทาย กอ ปี่ ล่า เป. จ้า ยาง ทานล้า ยาว กอย ปี่ ล่าง นี้ย่า, นาง อางล้าน แน บ่าซ่าจอ แฮ้งนา บ่าโอ้ด กงากา แฮ้ง ปาปาย เป. ยาว ยาง มือ นาง กงา ซี้ง ล่อ ย้า กอย ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“ยาว กงา ม่ายแบ ปี่ ล่าว่า, ป้า ยาว กงา แง, ซฺ้า ยาว มย้าง แง, ล้องก้อ โย้เวอ คอก ยาว ชฺ้าง อางคล้าว จา มาง ล้องก้อ แฮ้ง พอง ล้า แง. ");
INSERT INTO bzi_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ไม้ ชฺ้าง คาโคลาโค พาจาว มางนา ป้า คูง อือ กงา คูง แง, ชฺ้าง คาโคลาโค พาจาว มางนา ซฺ้า คูง อือ พาจาว มางนา มย้าง คูแง, แน ชฺ้าง คาโคลาโค พาจาว มาง ล้องก้อ แฮ้ง คอก คูง อือ, พาจาว มาง ล้องก้อ แฮ้ง พอง แง. ");
INSERT INTO bzi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“นองมู โย้เวอ อ่าซ่าง จา แง อางย่า อือ ล่องแต่ ป้า ยาว, อื้อล้าง อางปีด อือ ชู จฺ่า ปี่ แงแน? ");
INSERT INTO bzi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","บ่าอ่ายาว อางย่า อือ ยาอู ป้า เมอ, แมงป่อง อือ ชู ปี่ แงแน? ");
INSERT INTO bzi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ซ้ามบา นอง ชฺ้าง บ่าแม่น อืม, ค่าตอง อางย่า อือนา อางเกิ่งอางก้อ อางแม่น ปี่ นา แบ แง, ท้าว พาจาว กงู อางโบ้ง มู่งท่า ดื้ง ม้า, ชฺ้าง ยางก้อง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ป้า อือนา อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง บ่าปี่ ลา?” ");
INSERT INTO bzi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ทื่อนืง จา เย, พระเยซู ค่าพ่าย่า บ่าจี่ตอ กาง มางนา แด่ย่า ก่าอ่อก ปี่ ชีเย. แด่ย่า มาง อ่อก ยาว, ค่าพ่าย่า มาง จี่ตอ กา ชีเย. ค่องช่าง อือ นาบาตา เย นืงบาม่าน คู แง. ");
INSERT INTO bzi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ทื่อบ่า จี่ กาง นี้แม้แน, “เยซู ซาตานแด่ย่ายอคา มางก้อง ล่าที่ กงาบู้ ชี. แฮ้งย้า ยา แด่ย่า ก่า อ่อก กงา กาแง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ยาว ชฺ้าง ทื่อบ่า อือ, พระเยซู นา ฮ้าวม่า อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮาย ฮู ปี่ชี่, ไม้ แบ ซี้ง เย พระเยซู พาจาว มางก้อง ม้าม้า ล่า จายลือ ชี แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ยาว พระเยซู อางแบ เย, ยอ บ้าเจอ เย้ง แงแน. แฮ้งเย่ นี้แม้แน ม่า ชี, “อางเมิง ล้อเมิง ชฺ้าง อือ ซีแล บ่าโลง กาง, แฮ้เมิง ย่า อางเมิง บ่าเพล่อ แล ตอ กา เป. ยาว ยู้มชฺ้าง ล้อยู้ม ซีแล กาง ยอ ก่างพยา คู แง. ");
INSERT INTO bzi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ยาว นอง จี่ กาง แง, กงา ซาตานแด่ย่ายอคา มาง ล่าที่ แฮ้ง ไจ แด่ย่า อือนา ก่า ชี แน. นี้แม้แน ยาว ซาตานแด่ย่ายอคา มาง ค่าตอง แด่ย่า ย่าเจ่น อือนา ก่างพยา ยาว, ยาง อางโต แฮ้ง ก่างพยา แล่ กาน้าอี่. ยาว ยา ล้อแม้แน แด่ย่ายอคา ก่าซ้าด เพล่อ แล ตอ กาแน? ");
INSERT INTO bzi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ท้าว นอง ศิษย์ อือย่า อ่าซ่าง ล่าที่ แฮ้ง ไจ คูแง? ไม้ ยอง ทื่อช่างกานญา แด่ย่า นา ก่าอ่อก แง. จาว่าแน นอง ศิษย์ อือ ซาตานแด่ย่ายอคา มาง ล่าที่ แฮ้ง บ่ากงา ไจ ยาว, กงาม มือ ทื่อช่างกานญา ซาตานแด่ย่ายอคา ล่าที่ แฮ้ง บ่ากงา ไจ. นี้แม้แนยาว นอง ศิษย์ อือย้า นองนา อางซี ต้าดต่อน ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","จ้า กงา พาจาว มาง ล่าที่ แฮ้ง ไจ แด่ย่า นา ก่าอ่อก แง, นี้แม้แนยาว พาจาว มาง ก่าซ้าด ชา ลือ เพล่อ ลืง ย่าง อางญ่าม ชา เคอ ลือ ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","จาว่าแน ยู้มซื้ง อางแก่นอางคา มาง ล่าไม แน มยา ท่าม ยู้ม ล่อ ดื้ง ยาว, ยาง อางเกิ่งอางก้อ อือย่า บ่าโปยว เป. ");
INSERT INTO bzi_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","จ้า ชฺ้าง ยาง ล่อบ่าปา แน แก่นคา อือ อ้องล้าน ยาว, ยางนา ก่าจ่า ยาว ยาง มยา แน ล่าไม อือ ฮ้าน แอ้น ปี่ ยาว, แฮ้เมอ เคิน ยาว ยา อางเกิ่งอางก้อ อืม โค ย้า ยู้ แง. ");
INSERT INTO bzi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ชฺ้าง กงา จี่ต่าง บ่าฮายเค่ อือย่า ชฺ้าง กงานา เม้อ ล่าง อือ ย้า. ชฺ้าง กงานา บ่าปล่อง ล่าง อือย่า, ชฺ้าง กงา ล่ากาน แฮ้ง ฮาย ก่างพยา ปี่ อือย้า เป. ");
INSERT INTO bzi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“แด่ย่า มาง ชฺ้าง อางโต โย้เวอ อ่อก ยาว, ตี อางกืออางคาก อือเมอ ดื้งย้า ซฺ้า กว่า แอ ชีเย. จ้า บ่าซฺ่า กงากา เย. ยาว ยาง นี้แม้แน จี่ เย, ‘กงา ชฺ้าง กงา อ้องอ่าน มางก้อง พ่าว อ้อง แล่ง แฮ้ง เชคาไล’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ยาว ยาง พ่าวแอ้น น้าว, ยาว ยาง มย้าง ชีเย, ชฺ้าง แฮ้ม้า ยู้ม อางเซฺิ่งอางซฺ้าง อือ ป้าค้า เพล่อ ชี แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","แฮ้งย้า ยาง มือ แด่ย่า ยาง ล่อบ่าปา แน อางโซ้กอางไล้ อือนา 7 โต ช่าง ยาว, ชฺ้าง แฮ้มางก้อง ทื่งกง่า แน อ้อง ชีเย. ยาว ชฺ้าง แฮ้มาง อางอ้าน แฮ้ง ล่อบ่าปา เย ลาบ้าบ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","พระเยซู นี้เลิ่ง อู่บน้า ปี่ เมอ, ชฺ้าง อางมู โย้เวอ ค่าบาย่า ทื่อม่าง นี้แม้แน จี่ ฮ้าว ล้า ชีเย, “ค่าบาย่า นางนา เกิ้ด อ่อก ลือ ปี่ ล่า ชี่ ม้า, แน นางนา ลองแปด ชู่ ปี่ ล่าชี่ ม้าย่า ก่ามป่อน กงาบู้ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","จ้า พระเยซู นี้แม้แน จี่ ชีเย, “อางอ้า ย้า, จ้า ชฺ้าง พาจาว มาง ม่าอู่บจี่ต่าง แฮ้งนา น้า อือ, แน ฮายเค่ อือ ก่ามป่อน ม้าม้า ย้า กงาบู้ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ค่องช่าง อือ บย่า แน ปลืงแท่ง ลางกา ยาว, พระเยซู ยองนา จี่ช่าง ชี นี้แม้แน, “อามือ ชฺ้าง นี้ย่า บ่าแม่น คู, อาล่อม มือ กงานา ม่าย อางเลิ่งชฺ้างบ่าฮาตอกางอือ เค้ ฮา ปี่ ล่าง, ไม้ ยอ แบ คู ซี้ แง กงานา พาจาว มาง ม้าม้า ล่า ซฺาลือ ปี่ ล่าชี่ แน. จ้า กงา เจิ้นเจ้อ อางเลิ่งชฺ้างบ่าฮาตอกางอือ บ่าฮายฮู ปี่ ล่าเป, พาจาวจี่ต่างจี่แต่นฮู โยนาห์ ก้อง อางเลิ่ง ตอล้า ชี แฮ้งญา ฮาย ฮู ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","โยนาห์ ก้อง ม้างม้าเจ้อ ตอล้า ชี แฮ้, นีนะเวห์ ชฺ้าง อือนา ฮายแบ ปี่ แง, พาจาว ม้า โยนาห์ นา ซฺาลือ ปี่ ชี่ แน. ยาว กงา เมอ อางเลิ่ง ตอล้า ชี นี้, อามือ ชฺ้าง อือนา ฮายแบ ปี่ง แง, พาจาว ม้า กงาชฺ้างอางย่า มางนา ซฺาลือ ปี่ ชี่ ม้าม้า แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ยาว พาจาว มาง ชฺ้าง อางบล่าบ คาโคลาโค อือนา อางซี ต้าดต่อน แฮ้นืง, พระราชินี เชบา อางเมิง โย้เวอ จายล้า ชี มาง พาจาว มาง ล้าก้า โย้เวอ นอง อางเลิ่ง อางซี ฮา ชี แฮ้ง อู่บน้า ปี่ แง. ยา อางเว่อ เวอ จายล้า ชี ก่าซ้าด โซโลมอน วี่ไซป้านญา แฮ้ง น้า ล้า แงแน. จ้า กงา ก่าซ้าด โซโลมอน ล่อบ่าปา แน ฮื่อ เวิมมือ นองมู นี้ย่า กงานา บ่าน่าจ่าล่า คู. ");
INSERT INTO bzi_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","อางนืงต้าดต่อน แฮ้นืงย่า นีนะเวห์ อางเมิง ชฺ้าง อือย่า นองมู อามือชฺ้าง อือก้อง ทื่งกง่า แน ทาล้า แง. ยาว นองนา จี่ ล่า คูแง, ไม้ นีนะเวห์ อางเมิง ชฺ้าง อือ โยนาห์ ม่าอู่บจี่ต่าง ย่าง กงากย่า คูยาว อางบล่าบ ฮา แฮ้ง บ่าว่าง คู, จ้า กงา โยนาห์ ล่อบ่าปา แน ฮื่อ เวิม มือ กงา ม่าอู่บ ล่าเมอ, นอ กงานา บ่าน่าจ่า ล่า แน นืงบา บ่าเพ่น คู. ");
INSERT INTO bzi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“อ่าซ่าง มาง ต่องซฺื่อลาน ท่อ ยาว บ่าโชง ชี. บ่าอ่า ยาว นื้งชฺ่าอู่ล่อง แฮ้ง บ่าโคบ ชี. จ้า ต่องซฺื่อลาน ชี ย้า โย้เวอ ตื้ง ชี คู แง. ชฺ้าง อ้อง ล้า เมอ แปล้นซ้า แน มย้าง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","แมนือ นี้ย่า เพ้ก ลื่อยาว นืงบา แม้แนย้า. นี้แม้แนยาว แมนือ นี้ง แปล้นซ้า ยาว นืงบา แฮ้ง คาตา ย้า แปล้นซ้า แง. จาว่าแน นอง แมนือ แฮ้ง แม่น ยาว, นอง นืงบา แฮ้ง คาตา ย้า แม่น แง. จ้า นอง แมนือ บ่าแม่น ยาว, นอง นืงบา นี้ย่า โค ย้า วื้งว้าง แง. ");
INSERT INTO bzi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","นี้แม้แน ยาว แม่น แน แล่ม แล่ โว, นอง นืงบา โย้เวอ อางแปล้นอางซ้า แฮ้ง วื้งว้าง แน บ่าฮา ปี่ โจ. ");
INSERT INTO bzi_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","จ้า นอง นืงบา เวอ อางแปล้นอางซ้า แฮ้ง ปลื้ง แน จา ยาว, บ้าเจอ ล้อกย้า มือ อางวื้งอางว้าง อือ บ่าจา. นอง นืงบา คาโคลาโค นี้ย่า อางแปล้นอางซ้า อือ ปลื้ง ย้า. กู่มบี่ท่อ นองก้อง ท่อ ลือ ปี่ชี่ แม้แน ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","พระเยซู จี่ เปิน ยาว, ฟาริสี ทื่อม่าง จา เย พระเยซู นา ยาง ยู้ม เวอ ฮ่าง ช่าง จฺ่า แอ ชีเย. ยาว เคอ แอ ยาว พระเยซู นา ฮ่างเพิ่น จาม ชี ชี โย้เวอ ดื้ง ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ยาว ฟาริสี แฮ้มาง นืงบาม่าน ชีเย พระเยซู ยา บ้าเจอ ล่าปู่ บ่าชี่ แล่ แน. ยิว อางลี้บ นี้ย่า ฮ่างจฺ่า เมอ ล่าปู่ ชี่ แล่เปิน แง. ");
INSERT INTO bzi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","พระเยซู ม่าย ชี นี้แม้แน, “ฟาริสี นอง เวอ, นอย่า อางลี้บอางล่าว แม่น แน ฮายเค่ ยาว ฮากนา ฮายฮู ปี่ง, นอย่า ชฺ้าง อางแม่น แน. จ้า ม้าม้า นี้ย่า นอง นืงบา คล้าว โย้ อางโซอางซา อือ แอ่ ย้า จา แง. นอง ลอค่อ อางเง้ ป่ากย่า แอ่ แน เซฺิ่งซฺ้าง ปี่ แม้แน ย้า. จ้า ลอค่อ คล้าว โย้เวอ บ่าเซฺิ่งบ่าซฺ่าง อือ แอ่ ย้า จา แง. ");
INSERT INTO bzi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","จ่างแคนแคน กา ชี, พาจาว ม้า อางเง้ แน อางคล้าว แฮ้ง แต่ง ชี ชี บ่าอ่า ลา? ");
INSERT INTO bzi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","นี้แม้ยาว, นอง ชฺ้าง อางตูกอางพาน อือนา ปล่อง เมอ นอง นืงบา คล้าว เวอ จายล้า ปี่ โว, ยาว นอง ชฺ้าง อางเซฺิ่งอางซฺ้าง เพล่อ แง. พาจาว มาง นืงบาจาบ แฮ้แม้ ย้า.” ");
INSERT INTO bzi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ฟาริสี มู นอง เวอ, พาจาว ม้า นองนา อางซี ต้าดต่อน ล่าง เป. อางเกิ่งอางก้อ คาโคลาโค นอง กงายล้า ชี อือ ทื่อแช่ ปูน กงา ยาว, พาจาว มางนา ทื่อ ปูน ปี่ แง. ตื่ง ยู้ม คล้าว เวอ ก่างพ่าก่างล่อง อือ คาตา ย้า ท่าน แง, จ้า นองมู นี้ย่า พาจาว มางนา ม้าม้า แน บ่าลาก ยาว ฮากนา บ่ากง่าบ่าเกิง แน ฮาช่าง แง เป. นี้แม้แนยาว นองมู นี้ง มือ พาจาว มาง นา อางเกิ่ง แฮ้ง แอ่ แน บ่าท่าน โจ! จ้า พาจาว มางนา คาตา แน ลาก โว! ยาว ฮากนา คาตา แน กง่าเกิ้ง แน ฮาช่าง โว!” ");
INSERT INTO bzi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ฟาริสี มู นอง เวอ, พาจาว มาง นองนา อางซี ต้าดต่อน ปี่ ล่าง เป. นองมู นี้ย่า ยิวชฺ้าง โบสถ์ คล้าว โย้เวอ อ้อง ไว้ แล เมอ, นองมู นี้ย่า ดื้งย้า ปีนแตปีนนา เลิ่นเลิ่น เวอ ดื้ง นา อางซอ คู. ก้าด อือเมอ ย่อกว่า นา อางซอ คู, ไม้ ฮากนา นองนา ล่าปู่ โญกไว้ ปี่ง แนนอ.” ");
INSERT INTO bzi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“พาจาว ม้า นองมู นา ม้าม้า ย้า อางซี ต้าดต่อน ล่าแง. ซฺ่าจอ คาบอล้อ ย้าเป นองมู นี้ย่า ชฺ้างซฺี้ ค่ามตู่ พูม ย้า ช่าคาแม้แน อางช่า บ่ากงา ช่า ชี อือ ช้อด ย้า. ยาว ชฺ้าง อือ บ่าแบ นอง นืงบา คล้าว โย้เวอ ล้อม้อก แน โซซา แงแน” แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ยาว อางลี้บอางล่าว ม่าอู่บฮู ทื่อม่าง จี่ เย นี้แม้แน, “อ่าจาน เวอ, นาง นี้แม้ จี่ ชี นี้ย่า นา กงูนา ฮูย้า ล่าง แงแน ทื่อช่างกานญา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","แฮ้งเย่ พระเยซู นี้แม้แน ม่า ชี, “อางอ้า ย้า, พาจาว มาง นองมู นา วี่บ่ากกงาไจ ปี่ ล่าง. นองมู นี้ย่า อางลี้บอางล่าว นา อางแบอางบู้. ยาว นองมู นี้ย่า นอง อางลี้บ แต่ง ชี แฮ้ง ฮากนา เค้ ฮา ปี่ แง. ฮากนา ตูกพานลาบ้าบ ปี่ กาน แง. จ้า นอ ชฺ้าง แฮ้อือนา เจิ้นเจ้อ บ่าปล่อง.” ");
INSERT INTO bzi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“พาจาว มาง นองนา วี่บ่ากไจ ปี่ ล่าง เป, ไม้ ค้าแต้ ย่า นอง อางฮู่ อางพี่ อือ พาจาว มาง จี่ต่างจี่แต่นฮู อือนา แซ่ คู ชี. จ้า อ่ามือ นอย่า นอง อางฮู่ อางพี่ อือ แซ่ ชี อือนา ท้ามชฺ้างซฺี้ชีย้า แม่นมาง แน แต่ง ปี่ แง. นี้แม้ยาว นองมู นี้ย่า นอง อางฮู่ อางพี่ อือ ฮา ชี อือนา อางซอ ชา ม้า, ยาว นอ นอง อางฮู่ อางพี่ อือ อางบล่าบ ฮา ชี แฮ้งนา อางซอ แน ฮาย เค่ คูชี เป. ");
INSERT INTO bzi_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","นี้งย้า พาจาว วี่ไซป้านญา จา มาง จี่ ชี ชี นี้แม้แน, ‘กงา ชฺ้าง กงานา จี่แต่นล่าฮู อือ แน ศิษย์ อือนา ยองก้อง ซฺาแอ ปี่ แง. ยาว ศิษย์ ทื่อบ่า อือนา ยอง แซ่ คูชี แน ทื่อบ่า อือนา ยอ บ่าแม่น แน ฮาย กาน คู แง.’ ");
INSERT INTO bzi_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","อามือ ชฺ้าง อือ วี่บ่ากกงาไจ คู นี้ย่า! ค้าแต้ เวอ ยอง อางฮู่ อางพี่ อือ, พาจาว มาง จี่ต่างจี่แต่นฮู อือนา ชฺ้างอางเมิง แต่ง ล้า เมอ จาย แซ่ ชี แฮ้ง ปาปาย ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","แน อามือ ชฺ้าง อือ วี่บ่ากกงาไจ คู นี้ย่า! ยอง อางฮู่ อางพี่ อือ, พาจาวจี่ต่างจี่แต่นฮู เอเบล มาง จีน เวอ จาย, พาจาวจี่ต่างจี่แต่นฮู เศคาริยาห์ มาง จีน เวอ เคอ อือนา แซ่ ชี แฮ้ง ปาปาย. ยอย่า เศคาริยาห์ นา พาจาว มาง โบสถ์อางฮื่อ โย้เวอ แซ่ ชี. อางอ้า ย้า เป กงา ม่ายแบ ปี่ ล่าว่า, อามือ ชฺ้าง อือ วี่บ่ากกงาไจ แง, ไม้ ยองมู นี้ย่า แฮ้แม้แน อางบล่าบ ฮาย คู ป้านอ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“พาจาว ม้า นองมู อางลี้บอางล่าว อางแบอางบู้ อือนา วี่บ่ากไจ ปี่ ล่าง, นอย่า ฮากนา มู่งท่า โย้เวอ บ่าปี่ แล คู. นอง อางโต นี้ย่า บ่าอ่องแล คู จ้า ฮาก อ้องแล คู ซี อือนา บ่าปี่ แล แน ฮา คูแง.” ");
INSERT INTO bzi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","พระเยซู อ่อกแอน ยาว, อางลี้บอางล่าว ม่าอู่บฮู แน ฟาริสี อืม พระเยซู นา นาบาตา เย จี่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ยองมู นี้ย่า พระเยซู จี่ต่าง แฮ้ง อางซี ล่อ ชู คู เย. ");
INSERT INTO bzi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ยาว ค่องช่าง ไล ป่าน คู่น แน จูง ปลืงแท่ง ล้าน คู ชีเย. พระเยซู ยาง ศิษย์ อือนา จี่ช่าง เย นี้แม้แน, “ฟาริสี อือ บ่าแม่น ฮา ชี แฮ้ง แล่มจ่าแล่ว เป. ยองมู นี้ย่า ล้าก้า เวอ ทื่อเจ่อ น่องน่อง เวอ ทื่อเจ่อ แน ฮา คู แง. ");
INSERT INTO bzi_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ยาว ม้างม้าเจ้อ ชฺ้าง อือ ค่าวโชง ชี ชี อือย่า, กาญ่าม เวอ พาจาว มาง ชฺ้าง คาโคลาโค อือนา ฮาย มย้าง ปี่ง แง. แน อางเลิ่ง ฮากนา บ่าปี่ แบ อือย่า อ่อก ล้า ฮากนา กงาแบ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","นอง อางวื้งอางว้าง เวอ ค่าว จี่ กา นี้ย่า อางแปล้นอางซ้า ชฺ้าง คาโคลาโค อือ กงากย่า คู แงแน นอง ค่าตอง อางฮ้อง เวอ ค่าวแซบ กาง แฮ้, ชฺ้าง คาโคลาโค อือ กงาแบ คู แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“อางช่าง เวอ ชฺ้าง นา บ่าแค โจ, ไม้ ยอ อางโต นี้งญา อางแซ่ ล่ากงา กาแน. แซ่ เปิน ยาว ยอง นองนา ม้างม้าเจ้อ บ่าฮา ล่า กงากา ก้านลา. ");
INSERT INTO bzi_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","จ้า พาจาว มาง ยาง ล่าที่ แฮ้ง ไจ แซ่ ยาว ล่าลูก เวอ อางจาน แอ ปี่ กงากา เป, นี้แม้แนยาว พาจาว มางนา แค กาโน. อางอ้า ย้า กงา พาจาว นี้มาง นา แค ปี่ ล่าง.” ");
INSERT INTO bzi_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ยาว “ฮาย่า อางอี 5 โต นี้ย่า ทื่อบาท ญา ก่อง กงา แง, จ้า พาจาว ม้า ฮาย่า อือนา ทื่อโต แนม บ่าลู่ม เย. ");
INSERT INTO bzi_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ยาว นอง อางตู่ เวอ ต้ามคื้ง อืมมือ พาจาว ม้าย่า ดาบ ชี โค ญา. บ่ากงา แค คูคา, ไม้ นอย่า ฮาย่า อางมู อือ ล่อบ่าปา อางฮู่ จา คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“กงา ม่ายแบ ปี่ ล่าว่า, อ่าซ่าง ชฺ้างอางเมิง นู้เวอ ยา กงา ชฺ้าง แน ฮาก ล้าก้า โย้เวอ ม่า แง. กงาชฺ้างอางย่า มาง พาจาว มาง เท่วาด่า อือ ล้าก้า โย้เวอ ม่า แง, ชฺ้าง แฮ้ม้า กงา ชฺ้าง แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","จ้า อ่าซ่าง ชฺ้างอางเมิง นู้เวอ ฮาก ล้าก้า เวอ ม่า แง, ยา กงา ชฺ้าง บ่าอ่า แน. กงามมือ พาจาว มาง เท่วาด่า อือ ล้าก้า โย้เวอ ม่า แง, ชฺ้าง แฮ้ม้า กงา ชฺ้าง บ่าอ่า แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“ยาว อ่าซ่าง กงาชฺ้างอางย่า เพล่อ ชี่ นี้ มางนา จี่ ฮูย้า ล่าแง, พาจาว ม้า ชฺ้าง แฮ้มางนา อางซีอางบล่าบ บ่ายู่ เวิม อางกงา. จ้า อ่าซ่าง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มางนา จี่ ฮูย้า แง, พาจาว ม้า ชฺ้าง แฮ้มางนา อางซีอางบล่าบ ยู้ แง. ");
INSERT INTO bzi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ยิวชฺ้าง อือ ช้อนกาย้า โย้เวอ, นางนา ซฺื่ย น้าท้าม แอ ล่า ยาว, ชฺ้าง อางฮื่อ ปีนแตปีนนา แน ชฺ้าง ล่าที่ อางจา อือ ล้าก้า อือก้อง จูง จา เมอ, บ่ากงา แคคา ล้อแม้ จี่ วา แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ไม้ อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง นางนา ม่า ล่า แง แฮ้ญ่าม เวอ ล้อแม้ จี่ วา แน.” ");
INSERT INTO bzi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ยาว ค่องช่าง ทื่อม่าง จา เย, นี้แม้แน จี่ แง, “อ่าจาน เวอ, อ่าไอ้ นา ม่าย อ่าโบ้ง อางเกิ่งอางก้อ แฮ้ง กงานา คาตา แน เปิ่ง ปี่ ปี่ ล่าปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","จ้า พระเยซู นี้แม้แน จี่พอ ชีเย, “ย่าค่า เวอ, กงานา อ่าซ่าง ต้างแต่ง ไน้นา อางเกิ่งอางก้อ เปิ่งฮู เพล่อ ปี่ ล่า ชี?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “แม่น แน อางโต แล่ม จ่าแล่ว เป, ตานฮา บ่าจา ปี่ โจ, ไม้ จี่วีดม้าม้า นี้ย่า ชฺ้าง อางเกิ่งอางก้อ จา แฮ้ง วา แน บ่าอ่า เป” แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ยาว พระเยซู นี้เลิ่ง อู่บ เพ้กน้า ปี่ ชีเย นี้แม้แน, “ค่าพ่าย่า อางจาอางปาง ทื่อม่าง จา เย. ยาง น่า แน ย้า นี้ อางคลาอางซ้าง นาบาตา แม่น เย. ");
INSERT INTO bzi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ยาง เย้ง เย นี้แม้แน, ‘กงา ล้อแม้ ฮาย วา? อางคลาอางซ้าง นี้อือ กอย ชีย้า บ่าจา ชีล้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ยาว ยาง เย้ง เย, ‘ออ! แบ คายา กอจี อางอ้าน พยา วี ยาว อางอ้าน ล่อบ่าปา ฮื่อ แน แต่ง แล่ นา แน. ยาว อางคลาอางซ้าง แน อางเกิ่งอางก้อ ค้าจา อือ กอ ชี แน’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ยาว ยางต่องยาง แน ม่าจ่าแล่ ชีเย นี้แม้แน, ‘กงาย่า อางเกิ่ง อางแม่น อางบย่า กอ ชี แอ, ไล ปี ย้า กงาจฺ่า กงาต้าง แง. ม่อนซ้า แน จี่วีดไจ จฺ่าต้าง จา’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","จ้า พาจาว มาง ยางนา ม่า เย นี้แม้แน, ‘ย่าจ่าง เวอ, มี้คี่ น้า ซฺี้ แง, ยาว นาง อางเกิ่งอางก้อ กอ ชอน ชี ชี นี้ย่า อ่าซ่าง เฮอ เพล่อ แง?’ แน.” ");
INSERT INTO bzi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“ยาว นี้แม้แน ย้า เพล่อ แล แง เป. ชฺ้าง จาปาง ซี้ง อือย่า ค่าตอง อางเกิ่งอางก้อ กอ ชี บู แง. จ้า ยอ พาจาว มาง นืงบาจาบวา แน บ่ากงา ฮายเค่ เย” แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","พระเยซู ยาง ศิษย์ อือนา จี่ช่าง ชีเย นี้แม้แน, “นี้แม้แนยาว กงา นองนา ม่าย ล่า ปานา, จี่วีด นี้งนา บ่าพี่บ่าล่อง โจ, บ้าเจอจฺ่า วา แน บ่าอ่ายาว ม้างม้าเจ้อ ก่าแล่ตูมแล่เซฺ่อ อางจา ล่า แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ไม้ จี่วีด นี้ย่า จฺ่าเกิ่ง ล่อบ่าปา อางฮู่ จา แล่ง. แน อางโต นี้ย่า อางก่าอางตูม ล่อบ่าปา อางฮู่ จา แล่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ฮาย่า อือนา ฮู กาโน, ยอย่า เจิ้นเจ้อ บ่าคลา บ่าว่าบ่าบู่ แน กอโชง เวอ อางคลาอางซ้าง บ่ากอ ชี. จ้า พาจาว ม้า ยองนา ฮูพลา แง. ยาว นองมู นี้ย่า ฮาย่า อือ ล่อบ่าปา อางฮู่ จา แง. ");
INSERT INTO bzi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","บ้าเจอ ฮาย พี้ล้อง แง? พี้ล้อง ยาว นาง จี่วีด นี้ ทื่อชั่วโมง จา แล แล่ง ลา? จ้า บ่าอ่า น้อ. ");
INSERT INTO bzi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","อางเลิ่ง อางอี้ นี้ล่อ นี้ง บ่าฮาตอ กา ยาว, แฮ้เลิ่ง นี้เลิ่ง นา บ้าเจอฮาย พี้ล้อง กาน แง. ");
INSERT INTO bzi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“นี้แม้ยาว บ้าเจอฮาย อางก่าอางตูม อางเลิ่ง อือนา ม่านชู คู แง. แวย่า อือนา ฮู คูปาว ยอ ล้อแม้ แต่ล้า ชี. แวย่า นี้ย่า ล่ากาน บ่าว่า แน อางก่าอางตูม บ่าแต่ง ตูม แล่. กงา ม่ายแบ ปี่ ล่าว่า, ก่าซ้าด โซโลมอน นาบาตา จาปาง มาง อางก่าอางตูม ก่าตูม แล่ง แฮ้ แวย่า นี้อือ อางแว ทื่อแว ล่อ แนม บ่ามาง. ");
INSERT INTO bzi_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","แวย่า นี้อือนา ฮู ปาว! บ่ามล่าง ยาว ยอ แฮ่ว กือ ซฺี้ แง. จ้า แฮ้แม้เวิม พาจาว ม้า แวย่า อือนา แม่นมาง ย้า แต่ง แง, นี้แม้แนยาว พาจาว ม้า นองนา แวย่า นี้อือ ล่อบ่าปา ฮูพลา ล่าง. ท้าว นอ พาจาว มางนา นืงบาบ่าชี คูแน? ");
INSERT INTO bzi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“นี้แม้แนยาว จฺ่าเซฺ่อต้างเซฺ่อ อางจา ล่า แน บ่าม่านบ่าชู คู โจ. ");
INSERT INTO bzi_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ชฺ้าง พาจาว มางนา บ่าแบ กงา กางอือ อางเลิ่ง นี้อือ พี้ล้อง คูแง. จ้า พาจาว นอง อางโบ้ง ม้า อางแบ ย้า นอ บ้าเจอ อือ กงาไจ แงแน. ");
INSERT INTO bzi_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","นี้แม้แนยาว นองมู นี้ย่า พาจาว นอง ก่าซ้าด เพล่อ ชี มางนา ฮาย นืงบาจาบ ปี่ อางเลิ่ง แฮ้ง เย้ง ซฺ้า ออน ฮา ปาโน, นี้แม้ฮายยาว พาจาว มางมือ กูย่างกูเจ้อ นอง กงาไจ แฮ้ง ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“แกะ อางมู อางอี นอง เวอ, บ่าแค โจ! ไม้ อ่าโบ้งพาจาว นองนา นืงบาจาบ ล่าง. ยา นองนา ยางก้อง ทื่งกง่า แน ยาง อางเมิง แฮ้ง ฮูพลา แล ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","อางเกิ่งอางก้อ ค้าจา แฮ้ง ก่อง โค โว! แน พลู้ แฮ้ง ชฺ้าง อางตูก อือนา ปี่ โว! นี้แม้แนยาว นองมู นี้ย่า มู่งท่า โย้เวอ อางเกิ่งอางก้อ อางฮู่ อางจา ม้าม้า แฮ้ง กอยช้อน ชีช้อด ย้า, มู่งท่า โย้เวอ อางเกิ่งอางก้อ ม้าม้า แฮ้ย่า บ่าก่าง, บ่าแช, บ่าโค แน อ่าซ่าง มาง บ่าค่าว กงากา เป, แน คี้แม้ง อืม บ่าจฺ่ากงา กา เป. ");
INSERT INTO bzi_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ไม้ นอง อางเกิ่งอางก้อ อางฮู่ อางจา อือ ล้อเกิ้ง จา แง, นอง นืงบา แฮ้ง โย้เวอ ย้า จา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ยาว กูญ่าม แน ล่ากาน ว่า แงแน อางโต เก้ม แล่ คูโว! ยาว กูญ่าม แน กู่มบี่ท่อ แฮ้ง แปล้นซ้า แน จฺ่อ ชี โว! ");
INSERT INTO bzi_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ย่าเจ่น ค่าตอง เจ้านาย มาง ค่าบาล่า จฺ่าปอต้างปอ เวอ จาย ลือ แฮ้งนา ล่อ แม้แน ย้า. ยาว ยาง เจ้านาย มาง เคอ ลือ ยาว ล้องก้อ คอก ฮ้าว เมอ, ซฺ้อก แน ล้องก้อ กงาพอง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","นี้แม้แนยาว เจ้านาย มาง ลือ เมอ ยาง ย่าเจ่น อือ บ่ายู่ แน ยางนา ล่อ ดื้ง ชี แน มย้าง เมอ, เจ้านาย มาง ยองนา โญกจ่าญ่อ จ่าแง. กงา ม่ายแบ ปี่ ล่าว่า เจ้านาย แฮ้ม้า ยาง ย่าเจ่น อือนา โต โย้เวอ ดื้ง ปี่ ยาว ฮูพลา จฺ่าต้าง ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","นี้งย้า เจ้านาย มาง 12 โมง มู่งคี่ เวอ พ่าว ล้า เมอ, ยาง ย่าเจ่น อือ ล่อ จา นา มย้าง ยาว, เจ้านาย มาง ยาง ย่าเจ่น อือนา โญกจ่าญ่อ จ่างแง. ");
INSERT INTO bzi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“จ้า นองมู นี้ย่า แบ ชี คู โว! จาว่าแน ยู้มซื้ง มาง แล่ค่าว อือ อ่าล่อม ล้า คู แงแน อางแบ แนยาว, ยา แล่ค่าว มางนา ยาง ยู้ม คล้าว โย้เวอ บ่าปี่ อ้องล้า. ");
INSERT INTO bzi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ยาว นองมู นี้ง ทื่อช่างกานญา อางโต แฮ้ง แม่น แน แล่ม ล่อ คูโว! ไม้ กงา พ่าวลือ เมอ, นอ บ่าแบจ่าแล่ คู, แน บ่าเย่ง เคอ กา กงา อาล่อมเมอ พ่าวลือ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ยาว เปโตร น้า เย นี้แม้แน, “อ่าจาน เวอ, อางเลิ่ง เพ้ก นี้ย่า, กงูนา ญา ล่า อู่บน้า ปี่ ล่าง, อ้าว ชฺ้าง คาโคลาโค อือนา คาตา ย้า ล่า อู่บน้า ปี่ง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","พระเยซู มือ ม่าย ชี นี้แม้แน, “ย่าเจ่น ยอคา อางซืออางปลอง อางแอ้น เจ้านาย มาง ล่ากาน ม่าย ว่า ปี่ มาง, แน ย่าเจ่น ทื่อบ่า อือนา ฮูพลา จฺ่าเกิ่ง จฺ่า ปี่ง ม้า อ่าซ่าง เวอ? ");
INSERT INTO bzi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","เจ้านาย มาง ทื่อต่อง จาย พ่าวลือ แล่เมอ ยาง ย่าเจ่น มาง, ยาง ล่ากาน ม่ายว่า ปี่ ชี แฮ้ง แม่น แน ว่า ชี แน มย้าง เมอ, ยางมือ ย่าเจ่น แฮ้มางนา โญกจ่าญ่อ จ่างแง. ");
INSERT INTO bzi_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","กงา ม่าย แบ ปี่ ล่าว่า, เจ้านาย มาง ย่าเจ่น แฮ้มางนา ย่าเจ่น ยอคา ต้างแต่ง เพล่อ ปี่ ยาว, ยาง ล่ากาน แน อางเกิ่งอางก้อ คาโคลาโค แฮ้ง ฮูพลา ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","จ้า จาว่าแน ย่าเจ่น แฮ้มาง นี้แม้แน เย้ง ยาว, ‘เจ้านาย มาง พ่าวล้า แล่ง แฮ้ อางมล่าง ย้า จา แล่ง’ แน. ยาว ย่าเจ่น ค่าพ่าย่า ค่าบาย่า ทื่อบ่า อือนา ตื่อชืก ยาว จฺ่าต้าง ม่าว บ่อ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","นี้แม้แนยาว ยาง บ่าแบจ่าแล่ แน เจ้านาย มาง พ่าวล้าน ยาว มย้าง ล้า เมอ, ยาง เจ้านาย มางมือ ย่าเจ่น แฮ้มางนา นาบาตา ยา โตด ลาบ ปี่ ยาว, ย่าเจ่น ทื่อบ่า ยาง แม้แน บ่าแม่น อือก้อง ทื่อกง่า แน ดื้ง แอ ปี่ง.” ");
INSERT INTO bzi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“นี้งย้า ย่าเจ่น ล้อมาง อางโต บ่าเก่ม ชี แน เจ้านาย มาง ม่ายฮา ปี่ชี่ แฮ้ง บ่าฮา ยาว, เจ้านาย มาง นาบาตา ย้า ตื่อ ชืก แง. ");
INSERT INTO bzi_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","จ้า ย่าเจ่น ล้อมาง เจ้านาย มาง บ้าเจอ ม่าย ว่า ปี่ ชี แน บ่าแบ ยาว, ย่าเจ่น แฮ้มาง อางซี ฮา เมอ ยางนา อางบย่า แน บ่าตื่อ เป. นี้แม้แนยาว พาจาว มาง อ่าซ่าง นา บย่า แน ปี่ แง, ชฺ้าง แฮ้ม้า พาจาว มางนา อางบย่า ย้า กงาปี่ แง. พาจาว มาง อ่าซ่าง นา ล่ากาน บย่า แน ว่า ปี่ แง, พาจาว มาง ชฺ้าง แฮ้มางนา นืงบาแก่นจ่า แง, ชฺ้าง แฮ้ม้า ล่ากาน บย่า แน อางว่า กงากา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","กงา ลือ ชี นี้ย่า ชฺ้างอางเมิง นี้งนา ฮาย บี่ท่อ จฺ่อ ปี่ง. ยาว กงา อามือ ย้า บี่ท่อ จฺ่อ ล้า ปี่ ซี่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","จ้า กงา นาบาตา ย้า กงาตูกกงาพาน แง, กงา ซฺี้ แอ เมอ เคอ ย้า. กงา นาบาตา ย้า นืงบาต่อง ลาบ้าบ แง ล่ากาน ว่า เปิน เมอ เคอ ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","นอย่า กงา ชฺ้างอางเมิง นู้เวอ อางเลิ่ง อางจาอางดื้งบื้อ อือ ฮ้าน ลือ แงแน เย้ง ลา? บ่าอ่า เป, กงา ชฺ้างอางเมิง นู้เวอ ลือ ชฺ้าง อือนา ฮาย ปล่ากพา อางมู เปิ่ง กา ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","นู้ จายแล ปี่ง นี้ย่า, จาว่าแน ยู้ม ล้อยู้ม ชฺ้าง 5 คู่น จา แง, 2 มู แน เปิ่ง กา แง. ทื่อมู ม้า กงานา เจ่อ ล่าง ทื่อมู ม้า กงานา บ่าเจ่อ ล่า. ");
INSERT INTO bzi_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","อางโบ้ง แน อางย่าย่าค่า นี้ย่า บ่าโลง กา, อางบา แน อางย่าย่าบี่ นี้ง บ่าโลง กา, อางยู แน ย่อบา นี้ง บ่าโลง กา. ");
INSERT INTO bzi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ยาว พระเยซู ค่องช่าง อือนา จี่ช่าง ชี นี้แม้แน, “นองมู นี้ย่า มู่งบื่น อางปล้าง มู่งนื่ง กลา ป่ากย่า ล่อยลือ นา มย้าง ยาว จี่ กาง นี้แม้แน, ‘มู่งฮ่อ ชา ลือ กาชา’ แน, ยาว ม้าม้า ย้า มู่งฮ่อ ลือ แง. ");
INSERT INTO bzi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ยาว นอง ต่องปี่ ป่ากย่า ฮ้างม้าน ตอล้า นา มย้าง ยาว นอง จี่ กาง นี้แม้แน, ‘ชา ล้อง กาชา’ แน, ยาว ม้าม้า ย้า ล้อง แง. ");
INSERT INTO bzi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ชฺ้าง ย่าจ่าง อือ เวอ, นองมู นี้ย่า มู่ง แน นื้งชฺ่า แฮ้งนา ฮู ยาว บ้าเจอ ชา ตอล้า แงแน อางแบ กงากา, จ้า อามือ นอ บ่าแบ กงา บ้าเจอ ชา ฮา แงแน.” ");
INSERT INTO bzi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ยาว พระเยซู มือ นี้แม้แน จี่ แล่ ชี, “นอ อางกง่า ล่า บ่ากง่า ล่า แน บ่าเย่ง ตอ กาลา? ");
INSERT INTO bzi_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","จาว่าแน นาง อ่าซ่าง นา ซีช่าง ยาว, นาง ซีช่าง ชี มาง นางนา อางซี ยู้ ล่ายาว ต้าดต่อนย่า โย้เวอ ชา ซฺื่ยแล ล่าเมอ, อางไว่ แน แม่น แน ม่าอู่บ ลางกา โว, แฮ้แม้ บ่าฮา ยาว นางนา ต้าดต่อนฮู มางก้อง ซฺาแล ปี่ ล่ายาว, ต้าดต่อนฮู มาง นางนา คอก ฮูพลา มางนา ม่าย คอก เวอ ซฺื่ย ล้อง ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","กงา ม่ายแบ ปี่ ล่าแน นา คอก โย้เวอ บ่ากงา อ่อก เป. พลู้ อือ ปี่ โค เมินญา กงา อ่อก แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","แฮ้เมอ เวอ, ชฺ้าง ทื่อบ่า พระเยซู นา ม่า ชี นี้แม้แน, ผู้ว่า ปีลาต มาง กาลิลีชฺ้าง นา แซ่ ชีเย, พาจาว มางนา อางเกิ่งท่าน เมอ. ");
INSERT INTO bzi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","แฮ้งเย่ พระเยซู พอ ชี นี้แม้แน, “นองมู เย้ง กานยาว, กาลิลีชฺ้าง ปีลาต แซ่ ชี อือ กาลิลีชฺ้าง อือ ล่อบ่าปา ล่า อางบล่าบ ทู แง? ");
INSERT INTO bzi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","กงา ม่ายแบ ปี่ ล่าว่า บ่าอ่า เป, นอง นืงบา บ่าเพ่น แน อางบล่าบ ฮา แฮ้ง บ่าว่าง คูยาว, นองมู แฮ้งนามมือ ทื่อช่างกานญา ก่างพยา วี ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","แน สิโอลาม หอคอย ชฺ้าง 18 คู่น อือนา เลิง ตื่อ แซ่ ชี แฮ้, นอง เย้ง กานยาว ชฺ้าง 18 คู่น แฮ้อือ เยรูซาเล็มชฺ้าง คาโคลาโค อือ ล่อบ่าปา ล่า อางบล่าบ ทู แง? ");
INSERT INTO bzi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","บ่าอ่า เป! กงา ม่ายแบ ปี่ ล่าว่า, นองมู นืงบา บ่าเพ่น แน อางบล่าบ ฮา แฮ้ง บ่าว่าง คู ยาว, นองมู คาโคลาโค นี้งนา ยอง แม้แนย้า ก่างพยา วี ล่าง.” ");
INSERT INTO bzi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","พระเยซู อางเลิ่ง เพ้กน้า ปี่ ชี นี้แม้แน, “ค่าพ่าย่า ทื่อม่าง โซน เวอ ซื่อไค่มี้ล่อก คลา ชีเย. ยาง ซื่อไค่มี้ล่อก ซื่อ นา ล่อ ฮู เย, จ้า อาล่อม บ่ามย่าง เย. ");
INSERT INTO bzi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ค่าพ่าย่า แฮ้มาง โซนล่อฮู มางนา จี่ช่าง ชี นี้แม้แน, ‘ซื่อไค่มี้ล่อก นี้ จฺื้ง 3 ปี เคอ ญา จ้า อางซื่อ บ่าจา, เตอ วี ปาว คลา ชี เวิม นื้งชฺ่าตี เปลิ้ง กานแง.’ ");
INSERT INTO bzi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“จ้า ชฺ้าง โซนล่อฮู มาง พอ เย นี้แม้แน, ‘ทื่อปี ล่อ ฮู แล่ ป้าโน่, ยาว กงา นื้งชฺ่า ตู่ ปุ๋ย กาน ปี่ แน. ");
INSERT INTO bzi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","จ้า กาญ่าม อางซื่อ ซื่อ ยาว อางแม่น ย้า, จ้า อางซื่อ บ่าจา ยาว เตอ วี กาโน’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ลองนืง แฮ้นืง, พระเยซู ยิวชฺ้าง โบสถ์ โย้เวอ ม่าอู่บ จา แง. ");
INSERT INTO bzi_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","โย้เวอ ค่าบาย่า ทื่อม่าง จา เย, แด่ย่า มาง ยางนา ฮาย ต้างคู้ง เพล่อ ปี่ชี่ 18 ปี เคอ กาชา เย. ");
INSERT INTO bzi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","แฮ้งเย่ พระเยซู ค่าบาย่า แฮ้มางนา มย้าง ยาว, ยางก้อง ฮ้าวล้า ปี่ชี่. ยาว จี่ เย นี้แม้แน, “อือบา เวอ, นาง พ่าญาด เพล่อ ชี นี้ โปยว คางญา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ยาว พระเยซู มือ ยาง ล่าปู่ ย่าง ค่าบาย่า แฮ้มาง อางโต เวอ โบย ลือ ชีเย. ค่าบาย่า แฮ้มาง ต้างคู้ง ย่าง ซฺ้อก ย้า โปยว ชี. ยาว ยาง จูง ล้า ยาว พาจาว มางนา สรรเสริญ ฮา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","จ้า ยิวชฺ้าง โบสถ์ โย้เวอ ยอคา มาง, พระเยซู ลองนืง เวอ พ่าญาด ยา ชี แฮ้งนา นาบาตา เย่ นืงบาค่า แง. ยาว ค่องช่าง อือนา ม่าย ชี นี้แม้แน, “กาตีด กา นี้ย่า ล่ากาน 6 นืง ว่า แง. นี้แม้แนยาว 6 นืง โย้เวอ พ่าญาด ยา แล่ กาโน. ยาว ลองนืง เวอ พ่าญาด บ่ายา แล คู โจ!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","แฮ้งเย่ พระเยซู พอ ชี นี้แม้แน, “ชฺ้าง แมก่า ทื่อเจ่อ นืงบา ทื่อเจ่อ อือ เวอ, ม้าม้า นี้ย่า ลองนืง เคอ ยาว, นองมู คาโคลาโค นี้ย่า อ่ามย่าง แน ลา อือนา ล่าตื่อ พื้ยอ่อก ล้าง ชื้ง ต้าง แอ คู แง บ่าอ่า ลา? ");
INSERT INTO bzi_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ยาว ค่าบาย่า อับราฮัม มาง อางอ่านอางซฺื้อ นี้ม้า ซาตานแด่ย่ายอคา มาง ฮาย ลาบ้าบ ปี่ชี่ 18 ปี เคอ คางญา, ท้าว บ่ากง่า ล่า ค่าบาย่า นี้มาง ลาบ้าบ นี้ง ลองนืง เวอ ปล่องปูน ปี่ นี้ย่า?” ");
INSERT INTO bzi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","พระเยซู นี้แม้แน จี่ ชี่ นี้ ชฺ้าง ยางนา บ่าซอ อือนา ฮาย ซฺ่าจอ แล่ ปี่ ชีเย, จ้า ชฺ้าง ทื่อบ่า อือย่า พระเยซู อางเลิ่ง ฮา ชี แฮ้งนา ซอ คูง เย. ");
INSERT INTO bzi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ยาว พระเยซู นี้แม้แน จี่ ชีเย, “พาจาว มาง นื้งชฺ่าตี นี้ย่า บ้าเจอ นา ตู้ แง? กงา บ้าเจอ แฮ้งนา เพ้กเต้ม ลื่อวา? ");
INSERT INTO bzi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","เพ้ก ฮู ยาว ม่าต่าโก้บ ซื่อ อางนือ ป้าค้า ย้า จา แง. ชฺ้าง โซน คล้าว เวอ ฮ้าน คลา แอ ชี. ยาว อางนือ อือ แต่ล้า ยาว อางป้าง อางฮื่อ เพล่อ ล้า ชี. ยาว ล่างาม อือเมอ ฮาย่า อางป่าม ป่าม อางกงา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด ลือ เพล่อ ลือ นี้ย่า บ้าเจอล้อแม้ ลือ แง, แน บ้าเจอ แฮ้งนา เพ้ก ลือว้า แน? ");
INSERT INTO bzi_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ค่าบาย่า ทื่อม่าง ผงฟู แฮ้ง ไจ ค้านู้มป่าง แต่ง ชี ป้าค้า ย้า. ยา แป้ง 3 ถัง โย้เวอ ผงฟู อางอี้ ซูน ยาว แป้ง แฮ้งนา ฮาย อู่ง ล้า ปี่ง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ยาว พระเยซู เยรูซาเล็ม อางเมิง เวอ ย่อ แล เมอ, ยางมือ อางเมิง แน ค่อง ยาง ย่อ ไก ชี อือเมอ ม่าอู่บ กว่า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ยาว ชฺ้าง ทื่อม่าง จา เย พระเยซู นา นี้แม้แน น้า ชีเย, “อ่าจาน เวอ, ชฺ้าง อางบล่าบปูน แล่ง นี้ย่า ช่า บย่า?” แน. แฮ้งเย่ พระเยซู มือ นี้แม้แน จี่พอ ชี, ");
INSERT INTO bzi_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“แม่น แน แล่ม แล โว! นองมู่งท่า อางแล ซี้ แนยาว ล้องก้อ อางแท่ง โย้ อ้องแล โว! ไม้ ชฺ้าง อางบย่า ย้า อ้องแล ซี้ง แง. จ้า บ่าอ่อง แล กงากา เย. ");
INSERT INTO bzi_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","จ้า ยู้มซื้ง มาง ทานล้า ยาว ล้องก้อ แฮ้ง พี่ เมอ, นองมู นี้ย่า อางเง้ โย้เวอ จูง ฮ้าว ป้า คูง นี้แม้แน, ‘นาง เวอ, กงูนา ล้องก้อ นี้ง พอง ปี่ ล่า ปาโน’ แน. จ้า ยู้มซื้ง มาง พอ ชี นี้แม้แน, ‘นอ อ่าซ่าง เวอ แน ล้อเกิ้ง เวอ จายล้า แอ?’ ");
INSERT INTO bzi_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ยาว นอง พอ เมอ นี้แม้แน, ‘กงู นางก้อง ทื่งกง่า แน จฺ่าต้าง คูชี อือ ย้า แน. ยาว นาย่า กงูนา อางเมิง คล้าว แก้บ้า อือเมอ อางม่าอางอู่บ ล่า กาซื้ง ย้า’ ");
INSERT INTO bzi_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ยาว ยู้ม อางซื้ง มาง พอ แง นี้แม้แน, ‘นอ บ้าเจอซ่าง เวอ นอ เกิ้ง จายล้า นามบ่าแบ. ชฺ้าง อางบล่าบ อือเวอ เว่อ แน ฮื่น คู โว!’ ");
INSERT INTO bzi_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","จ้างจ้าง โย้เวอ นอย่า อับราฮัม อิสอัค ยาโคบ, แน พาจาว มาง จี่ต่างจี่แต่นฮู คาโคลาโค อือ มู่งท่า โย้เวอ ดื้งจา นา มย้าง คูแง, จ้า นอ ยองก้อง บ่าอ่อง แล กงากา, นองมู นี้งนา อางเง้ เวอ จาน แอ ปี่ ล่าง. แน นอย่า ซ่อเพ่แช่แก่น ย้า บื้งฮ้าว ด้า อู้ง ลาบ้าบ คูแง. ");
INSERT INTO bzi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ยาว ชฺ้าง อางบย่า เย กูต่องกูตี่ อือเมอ จายล้า คูแง, ตื่น ล้างม้านป่ากย่า, ต่องปี่ ป่ากย่า, มู่งนื่งอ่อกป่ากย่า, มู่งนื่งกลาป่ากย่า ย้าเย่. ยองมู นี้ย่า มู่งท่า โย้เวอ ทื่งกง่า แน จฺ่าต้าง คูแง. ");
INSERT INTO bzi_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ยาว แฮ้เมอ นองมือ กงามย้าง คู แง. ชฺ้าง ปีนแตปีนนา บ่าอ่า แน อางฮู่ ป้าดจาม บ่าจา อือ, อามือ ชฺ้าง ปีนแตปีนนา ม้าม้า เพล่อ ชี แน. ยาว อามือ ชฺ้าง ปีนแตปีนนา อือ, แฮ้เมอย่า ชฺ้าง ปีนแตปีนนา บ่าอ่า อือ เพล่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","แฮ้ญ่าม เมอ ฟาริสี อางมู เวอ ทื่อบ่า อือ พระเยซู นา นี้แม้แน ม่า ล้า ชี, “นู้เวอ บ่าดื่ง กาน โจ! อางไว่ แน ฮื่น โว! ไม้ ก่าซ้าด เฮโรด นางนา แซ่ ล่า ซี่ง เย!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ยาว พระเยซู มือ พอ ชี นี้แม้แน, “ก่าซ้าด เฮโรด ฮ้อนโจ้ง แม้แน อางโซ้กอางไล้ มางนา นี้แม้แน ม่าย แอ โว! ‘มี้นืง ล่าอ้าว นี้เซฺ้อ ล่าเวิม กงา แด่ย่า อือนา ก่า แง, แน พ่าญาด ยา แล แล่ง. ยาว กงาย่า ล่ากาน นี้ง วันที่ 3 โย้เวอ ว่า เปิน ปี่ง’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","จ้า กงาย่า มี้นืง ล่าอ้าว นี้เซฺ้อ ล่าอ้าว ไพ่นี้เซฺ้อ ล่าเวิม แก้บ้า ย่อ แล แล่แง, ไม้ ค้าแต้ เวอ จาย ย้า พาจาวจี่ต่างจี่แต่นฮู อือนา เยรูซาเล็ม อางเมิง โย้เวอ แซ่ ชี, แน กงา คาตา ย้า โย้เวอ ซฺี้ แล แง. ");
INSERT INTO bzi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“เอ้อ เยรูซาเล็ม อางเมิง ชฺ้าง อือ เวอ, นองมู นี้ย่า พาจาว มาง จี่ต่างจี่แต่นฮู อือนา ลอบา จาน แซ่ ชี. ยาว ไลเทอ ย้า กงา นอง อางเมิง ชฺ้าง อือนา ค่อด ชี ซี้ง แง, ยาอางบา ยาอางย่า อือนา อางต้อง แฮ้ง ไจ ค่อด ชี แฮ้งแม้แน, จ้า นอ กงานา แฮ้แม้แน บ่าปี่ฮา ล่า. ");
INSERT INTO bzi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","อามือ พาจาว ม้า นอง อางเมิง โย้เวอ บ่าดื่ง กาน. นู้จายแล ปี่ง นี้ย่า นอ กงานา บ่ากงามย้าง ล่ากาน, จ้า นอง นี้แม้แน จี่ เมินญา ‘พาจาว มาง ชฺ้าง ซฺาลือ ปี่ชี่ มางนา สรรเสริญ ฮา แง’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ลองนืง เวอ ตื่อเทอ จา แง, พระเยซู มือ ฟาริสี ยอคา ทื่อม่าง มาง ยู้ม โย้เวอ ฮ่างจฺ่า แอ ชี. ยาว ฟาริสี มู อือ พระเยซู บ้าเจอ อางซี ฮา แงแน ล่อ ฮู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ค่าพ่าย่า ล่าคื่อ แน ล่าปู่ นาบาตา ปู้ง ทื่อม่าง จา แง, พระเยซู ล้าก้า เวอ จูง ล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","แฮ้งเย่ พระเยซู มือ อางลี้บอางล่าว ม่าอู่บฮู อือนา แน ฟาริสี อือนา นี้แม้แน น้า ชี, “ลองนืง เวอ พ่าญ่าด ยา นี้ย่า อางลี้บอางล่าว เวอ อางซี ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","จ้า ยองมู ย่าง บ่าพอ คู เย, แฮ้งเย่ พระเยซู มือ ค่าพ่าย่า ล่าปู่ ล่าคื่อ อางปู้ง แฮ้มางนา ชู ยาว, พ่าญาด ยา ยาว ม่าย แอ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ยาว พระเยซู มือ ยองมู นา พลาบ น้า ชี นี้แม้แน, “จาว่าแน นอง อางย่า อือ แน นอง อ่ามย่าง อือ, ลองนืง โย้เวอ ล้างบ้อ เวอ กลา แล่ยาว, นอย่า อางไว่ ย้า ล่า อ้อง ปล่อง แล แง?” ");
INSERT INTO bzi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ยอง กย้าบ ย้า, เจิ้นเจ้อ บ่าพอ ลื่อ ปี่ ตอ กาเย. ");
INSERT INTO bzi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ยาว จฺ่าปอต้างปอ ล่ากาน จา เมอ, พระเยซู ชฺ้าง ล้า ชี อือ ดื้งย้า ปีนแตปีนนา อือเมอ ดื้ง คูง นา มย้าง ยาว, ยางมือ ม่า ชี นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ค่าบาล่า เมอ ชฺ้าง นางนา ป้า แอ ปี่ ล่า ยาว, ดื้งย้า ปีนแตปีนนา โย้เวอ บ่าดื่ง แอ โจ! ไม้ กาเทอกา จฺ่าปอต้างปอ ล่ากาน อางซื้ง มาง, นาง ล่อบ่าปา แน ชฺ้าง ปีนแตปีนนา อือนา ป้า ลือ ปี่ชี่ นามบ่าแบ. ");
INSERT INTO bzi_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ยาว จฺ่าปอต้างปอ ล่ากาน อางซื้ง มาง นางนา ม่า ล่าง นี้แม้แน, ‘ทานล้า ยาว นี้มางนา ดื้ง ปี่ ปาว’ แน. ยาว นาง ซฺ่าจอ แมก่าก่อง แล่ก้าน แง, แน ดื้งย้า ปีนแตปีนนา บ่าอ่า โย้เวอ กงาดื้ง แอ แง. ");
INSERT INTO bzi_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ยาว จฺ่าปอต้างปอ ล่ากาน จา เมอ นอง แอ ยาว, ดื้งย้า ปีนแตปีนนา บ่าอ่า โย้เวอ ดื้ง กาโน. จฺ่าปอต้างปอ ล่ากาน อางซื้ง มาง มย้าง ยาว นางนา อ้อง ม่า ล่าง นี้แม้แน, ‘อางช่าง เวอ, ดื้งย้า ปีนแตปีนนา นู้ ดื้ง ล่าปาว’ แน. ยาว ฮาก นางนา นาบทื้อ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ไม้ อ่าซ่าง ฮื่อจ่าแล่ง ยางนา อ่าซ่าง มาง บ่านาบบ่าทื่อ. ยาว ชฺ้าง บ่าฮื่อจาแล่ อือนา ฮาก นาบทื้อ คูง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ยาว พระเยซู มือ ยู้มซื้ง มางนา นี้แม้แน จี่ช่าง ชี, “นาง นืงก้องฮ่าง แน มู่งคี่ฮ่าง ปอ เมอ, นาง อางช่าง อือนา, แน นาง ย่าช่างม่องน้าม อือนา, แน นาง ยู้มต่องยู้มทาง จฺ่าเซฺ่อต้างเซฺ่อ อางจา อือนา บ่าช่าง ลือ โจ! ไม้ ชฺ้าง นี้อือ น่อง โย้เวอ นางนา อางปอ ไซ ล่า กงากา. ");
INSERT INTO bzi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","จ้า ชฺ้าง อางตูกอางพาน อือนา, ชฺ้าง บ่าย่อ ตอ กาง อือนา, ชฺ้างล่าง่อย อือนา, ชฺ้างแมปอ อือนา ช่าง ล้า โว! ");
INSERT INTO bzi_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ไม้ ชฺ้าง นี้อือ น่อง เวอ นางนา บ่าปอ ไซ ล่า กงากา. ยาว ชฺ้าง พาจาว มาง นืงบาวา แน ฮายเค่ มาง แต่ล้า แล่เมอ, พาจาว ม้า นางนา โญกจ่าญ่อ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ค่าพ่าย่า ทื่อม่าง โย้เวอ จฺ่า ดื้ง จา มาง นี้เลิ่ง กงากย่า ยาว, พระเยซู นา จี่ช่าง ชี นี้แม้แน, “พาจาว มาง อางเมิง, จฺ่าปอต้างปอ ล่ากาน โย้เวอ อ่าซ่าง กงาจฺ่ากงาต้าง แง กย่าง โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ยาว พระเยซู มือ อางเลิ่ง ย่าง เพ้ก ม่าย ชี นี้แม้แน, “ค่าพ่าย่า ทื่อม่าง จา เย จฺ่าปอต้างปอ ล่ากาน อางฮื่อ ปอ ชี, ยาว ชฺ้าง อางบย่า ย้า ป้ายล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ม้างม้าเจ้อ อางเกิ่ง อือ ล้างล่อ เปิน ยาว, จฺ่าปอต้างปอ อางซื้ง มาง ย่าเจ่น มางนา ม่าย, ชฺ้าง ลือ ชีอือ นา นี้แม้แน ม่าย แอ ปี่ชี่, ‘อ้องล้า กงา คางญา กูเจ้อ นี้ย่า ล้างล่อ เปิน ญา’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","จ้า ชฺ้าง จฺ่าปอต้างปอ ล่ากาน โย้เวอ ป้ายล้า ชี อืมมือ, บ่ากื่งจ้า แน ม่า คูง เย. กาบ่ากา นี้แม้ ม่า เย, ‘ซูม่า ย้าเป, กงา บ่ากงา แล ชีล้า น่า อางซฺื่อ วื้อ ชี แฮ้ง กงา ฮู แอ แง’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ยาว กาบ่ากา ม่า เย นี้แม้แน, ‘ซูม่า ย้าเป, บ่าแอ กงากา ชีล้า ป่องนา 5 กู่ วื้อ ชี อือนา ฮู แอ ปานา, บ้าเจอล้อแม้จา แงแน’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","กาบ่ากา นี้แม้แน ม่า เย, ‘ค่าบาล่า ซฺื่อ บ่าแลตอ กาชีล้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“ย่าเจ่น มาง พ่าว ล้า แล่ยาว, เจ้านาย มางนา อางเลิ่ง คาโคลาโค ย่าง อู่บน้า ปี่ ชีเย. เจ้านาย มาง นาบาตา เย่ นืงบาค่า แง. แฮ้งเย่ ย่าเจ่น มางนา ม่า ชี นี้แม้แน, ‘อางไว่ แน นี้เมิง ก้อง แก้บ้า อางฮื่อ แก้บ้า อางอี ค้าจา อือก้อง แอ โว! ยาว ชฺ้าง อางตูก ชฺ้าง ล่าคื่อคื้อแซฺ้ แน ชฺ้างแมปอ อือนา นู้ ซฺื่ยล้า โว!’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ยาว ย่าเจ่น มาง แฮ้แม้แน แอ ฮาย แอ ยาว, เจ้านาย มางนา พ่าว ม่า ล้า ชีเย นี้แม้แน, ‘กงา นาง ม่า ล่าชี่ แม้แน ฮาย ยา, จ้า ตี ดื้งย้า ย่าง จ้านล้า ชี’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","แฮ้งเย่ เจ้านาย มาง นี้แม้แน ม่า ชี, ‘นี้แม้แนยาว อางเมิง อางเง้ แก้บ้า โย้เวอ อ่อกแอ โว! ยาว ชฺ้าง อือนา ช่าง ล้า โว! กงา ยู้ม นู้ ปลื้ง แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ยาว ต่องก่า เวอ กงา ชฺ้าง ป้า ยาว บ่าล่า อือ, อ่าซ่าง มาง กงา จฺ่าปอต้างปอ ล่ากาน ปอ นู้ จฺ่าเกิ่ง นี้ง บ่ากงา จฺ่า ล้า กาน’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ยาว ชฺ้าง อางบย่า ย้า พระเยซู ก้อง เค่ แลน ชี. พระเยซู มือ ยองนา จี่ช่าง ชี นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“จาว่าแน นอง กงา ศิษย์ เพล่อ ซี่ง แนยาว กงานา ลาก ล่าโว, นอง อางบา อางโบ้ง, อางบี่อางย่า, ย่าช่างม่องน้าม อือนา แน ค่าตอง นา ล่อบ่าปา แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","อ่าซ่าง ค่าตอง ไม้กางเขน แฮ้ง บ่าป่า ล้า, แน กงา ปาปาย อางตูกอางพาน แฮ้ง บ่าโอ่ด กงากา ยาว, ยา กงา ศิษย์ บ่าเพล่อ กงากา. ");
INSERT INTO bzi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","จาว่าแน นอง ยู้ม อางฮื่อ แต่ง ซี่ง แนยาว, ต่องก่า เวอ นอย่า แต่งจี อางฮู่ โค แล่ง แฮ้ง กงาเย้ง เปิน แง. ไม้ แบ ปี่ง นอ พลู้ แฮ้ อางลอ ย้า ล่า แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ไม้ นี้แม้ บ่าฮา ยาว, กาเทอกา นอง ยู้มยื้ง ปล้อก เปิน ยาว พลู้ แฮ้ง โค ยาว, นอง ยู้ม อางฮื่อ แต่ง แฮ้ง กงาว่าง กาน้าอี่, ยาว ค่องช่าง อืม อื้อ คูยาว นี้แม้แน จี่ กาน้าอี่, ");
INSERT INTO bzi_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘โอ ชฺ้าง นี้ม้า ย่า ยู้มซฺื้อ อางฮื่อ แต่ง ซี้ แง, จ้า เปิน แน บ่าแต่ง กงากา’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“บ่าอ่า ยาว จาว่าแน ก่าซ้าด ทื่อม่าง มาง. ก่าซ้าด ทื่อม่าง มางนา อ่อก รบ แอ เมอ, ยา บ่าเย่ง เปิน ล่า ยาง ตาฮ้าน 10,000 คู่น อือย่า. ก่าซ้าด ทื่อม่าง มาง ตาฮ้าน 20,000 คู่น อือนา อางก่าจ่า กงา ไกล่า แน? ");
INSERT INTO bzi_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ยาง บ่าก่าจ่า กงากา แน แบน ยาว, ยา อางไว่ แน ชฺ้าง กงา ซฺาแอ ปี่ง รบ กาง แฮ้ง จี่อู้ ว่าง ปี่ง, ก่าซ้าด ทื่อม่าง มาง แน ตาฮ้าน อือ แก้บ้า อางเว่อ โย้เวอ จา เมอ ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ทื่อช่างกานญา, นาง ม้างม้าเจ้อ ค้าจา อือ บ่าวี ยาว, นา กงา ศิษย์ บ่าเพล่อ ตอ กา.” ");
INSERT INTO bzi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","อ่าซ่าง น่าซื่ง จา แง แม่น แน น้า คู โว! “จ่าแม่ นี้ย่า อางแม่น จ้า จ่าแม่ อางอ้าม แฮ้ง โค ยาว, อางอ้าน แม้แน บ่าฮาย อ้าม ปี่ ตอ กา กาน. นื้งชฺ่า เวอ ฮ้าน กาน แอ เวิม บ่ากงา. อ่ามย่างแอ่ง เวอ ฮ้าน ซูน แอ เวิม บ่ากงา. กอย วี แฮ้ง ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","แฮ้ญ่าม เมอ, ชฺ้าง ภาษี กอ มู อือ แน ชฺ้าง อางบล่าบ อือ จา เย, ยองมู นี้ย่า พระเยซู ม่าอู่บ แฮ้งนา อ้อง น้า ล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ยาว ฟาริสี แน อางลี้บอางล่าว ม่าอู่บฮู อือ จี่จ่าบ กาง เย นี้แม้แน, “ชฺ้าง นี้ม้า ชฺ้าง อางบล่าบ อือนา เป-ลอ ช่าง ยาว ฮ่าง ทื่งกง่า แน จฺ่า ช่าง ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","แฮ้งเย่ พระเยซู นี้เลิ่ง ยองนา อู่บ เพ้กเต้ม น้า ปี่ชี. ");
INSERT INTO bzi_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","นี้แม้แน, “จาว่าแน ชฺ้าง ทื่อม่าง มางก้อง แกะ 100 โต จา แง, จ้า ทื่อโต โปยว กา ชี. นี้แม้แน ยาว ยาง แกะ 99 โต อือนา บู่ก่า แต่ โย้เวอ ชีช่ายาว, แกะ ทื่อโต มางนา บ่าซฺ่า กว่า แอ ล้า มย้าง แอ เคอ แน? ");
INSERT INTO bzi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","แกะ แฮ้มางนา มย้าง ยาว ยาง นาบาตา ย้า กย่าง แง. ยาว แกะ มางนา ป่า แล่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ยาว ยู้ม เวอ ซฺื่ย พ่าว ลือ แง, ยาว ยาง ยู้มต่องยู้มทาง แน อางช่าง อือนา ฮ้าว ล้า โค ยาว ม่า เย, ‘กงา แกะ โปยว ชี มางนา มย้าง แล่ ชี่ นี้ง. กงาก้อง จฺ่าต้าง กย่าง ม่อน ช่าง ล่า ปาโน’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ยาว กงา ม่ายแบ ปี่ ล่าว่า, ชฺ้าง อางบล่าบ ทื่อม่าง นืงบาเพ่น อางบล่าบ ฮา แฮ้ง ว่าง ยาว, มู่งท่า เวอ เท่วาด่า อืม กย่างม่อนซ้า คูแง, ไม้ นี้ย่า ชฺ้าง อางแม่น ลามแลว 99 คู่น จา อือ ล่อบ่าปา กย่าง คาแม้ แน จา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“จาว่าแน ค่าบาย่า ทื่อม่าง พลู้ อางฮู่อางคา ทื่อแช่ เหรียญ จา แง. จ้า ทื่อ เหรียญ คลา โปยว ชี, นี้แม้แนยาว ค่าบาย่า แฮ้ม้า, กู่ม ท่อ ยาว พลู้ แฮ้เหรียญ มย้าง แอ เคอ แน ยู้ม บ่ากว่าด ซฺ้า กว่า ลา? ");
INSERT INTO bzi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ยาว พลู้ แฮ้เหรียญ นา ซฺ้า มย้าง ยาว, ค่าบาย่า แฮ้มาง ยู้มต่องยู้มทาง แน อางช่าง อือนา, ช่าง ฮ้าว ล้า โค ยาว ม่าย ชี นี้แม้แน, ‘กงา พลู้ ทื่อ เหรียญ โปยว ยาว มย้าง แล่ ชี่ นี้ง, กงานา จฺ่าต้าง กย่าง ม่อน ช่าง ล่า ปาโน’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","กงา ม่ายแบ ปี่ ล่าว่า, ชฺ้าง อางบล่าบ ทื่อม่าง นืงบาเพ่น เมอ, มู่งท่า เวอ เท่วาด่า อืม แฮ้แม้แน ย้า กย่างม่อนซ้า คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","พระเยซู อางเลิ่ง เพ้ก น้า แล่ ปี่ชี่ นี้แม้แน, “ค่าพ่าย่า ทื่อม่าง จา เย อางย่า ค่าพ่าย่า 2 คู่น จา แง. ");
INSERT INTO bzi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ยาว อางย่า น่องล่า มาง นี้แม้แน จี่ เย, ‘อ่าโบ้ง เวอ, อางเกิ่งอางก้อ กงา กงาคาแม้ แน ชีแฮ้ง, กงานา นาง บ่าซฺี่ ฮู่ นู้ เปิ่ง ปี่ ล่าปาว.’ แฮ้งเย่ อางโบ้ง มาง อางย่า มาง เย่ดนา อางเกิ่งอางก้อ ยาง เปิ่ง ปี่ ชี.” ");
INSERT INTO bzi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“บ่ามล่าง ยาว, อางย่า น่องล่า มาง ยาง อางเกิ่ง ย่าง อางเมิง อางเว่อ โย้เวอ ฮ้าน แลน ชีเย. ยาว ยางมือ พลู้ ย้าง บ่าแม่น ป่ากย่า ไจ ชีเย, แน พลู้ ย้าง ค้าค้าเล้อเล้อ แน ไจ บ่อ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ยาว ยาง พลู้ ย้าง โค ชี, แฮ้ญ่ามเมอ แควน แฮ้ แควน จฺ่าเกิ่งต่างก้อ เคม ชี, ยาว ยาง จฺ่าเซฺ่อ บ่าจา เย. ");
INSERT INTO bzi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","แฮ้งเย่ ยาง อางเมิง แฮ้เมิง ก้อง เวอ, ชฺ้าง ทื่อม่าง มางก้อง ล่ากาน ว่า แอ ชี, ยาว ยางนา น่า โย้เวอ ว่า ปอ แอ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ยาว ยาง นาบาตา เย่ แบ่ซฺู่ แง, ยา ว่า จฺ่าเกิ่ง แฮ้ง จฺ่า ซี่ง เย, จ้า อ่าซ่าง มาง ยางนา เจิ้นเจ้อ บ่าปี่ จฺ่า เย.” ");
INSERT INTO bzi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“ยาว น่อง โย้เวอ ยาง เย้ง กงา แล่ ชี่, แน นี้แม้แน จี่ เย, ‘อ่าโบ้ง ย่าเจ่น อือย่า จฺ่าต้าง บ่าโค, จ้า กงานา ฮู ล่า ปาโน จฺื่งคู ชา ซฺี้ คางญา. ");
INSERT INTO bzi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","กงา อ่าโบ้ง นา พ่าว ซฺาแล ยาว ยางนา นี้แม้แน จี่ช่าง แน, อ่าโบ้ง เวอ, กงา นางนา แน พาจาว มางนา อางบล่าบ ฮาย ล่าแอ่. ");
INSERT INTO bzi_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ยาว กงา อ่าโบ้ง อางย่า เพล่อ แล่ บ่าซูม ชีล้า. กงานา นาง ย่าเจ่น ทื่อม่าง เพล่อ ปี่ ล่าปาว แน.’ ");
INSERT INTO bzi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“ยาว ยางมือ อางโบ้ง มางนา พ่าว ซฺ้า แล ชีเย. ยาว อางโบ้ง มาง ยางนา อางเว่อ โย้เวอ จาย มย้าง ชี. ยาว อางโบ้ง มาง ยางนา ลาก ปาปาย ฮื่น แอ ค่อด ชู่บ แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ยาว อางย่า มาง จี่ เย นี้แม้แน, ‘อ่าโบ้ง เวอ, กงา นางนา แน พาจาว มางนา อางบล่าบ ฮาย ล่าแอ่. กงา นาง อางย่า เพล่อ นี้ บ่าซูม ชีล้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“จ้า อางโบ้ง มาง ย่าเจ่น อือนา นี้แม้แน ม่าย ชีเย, ‘อางไว่! แน ยางนา อางก่าอางตูม อางแม่น แฮ้ง ซฺ้า ตูม ปี่ โว, ยาว ล่าชฺ่อง แฮ้ง ยาง ล่าญู่ง โย้เวอ ช่อง ปี่ โว! แน แค้บ ซฺ้า ตา ปี่ โว! ");
INSERT INTO bzi_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ยาว อ่ามย่าง อางย่า อางตู่ง ทื่อม่าง แซ่ ยาว แต่งจี จฺ่าปอต้างปอ ฮา เซฺ้อ แน. ");
INSERT INTO bzi_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ไม้ กงา อางย่า นี้ม้า ซฺี้ คา ยาว ทื่อเทอ แต่ลาน แล่ ชี ช้อด ย้า. กงา ยางนา โปยว แอ, จ้า อามือ ซฺ้า มย้าง แล่ ย่า’ แน. ยาว ยอง จฺ่าต้างปอ ลางกา น้าว.” ");
INSERT INTO bzi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“ยาว อางย่า ค่าพ่าย่า ซากาว มาง, น่า โย้เวอ ล่ากาน ว่า จายล้า ยู้ม ชา เคอ เมอ, ยาง เพ่ง ฮ้าว ม่อนซ้า นา กงากย่า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","แฮ้งย้า ย่าเจ่น มางนา ฮ้าว น้า ชี นี้แม้แน, ‘บ้าเจอ ตอล้า ชี?’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ย่าเจ่น มาง นี้แม้แน ม่า ชีเย, ‘นาง แพ้ ยู้ม เวอ พ่าว ล้าน แล่งญา แน, แฮ้งย้า นางโบ้ง มือ กงูนา ม่าย อ่ามย่าง อางย่า อางตู่ง ทื่อม่าง แซ่ จฺ่าปอต้างปอ ฮา ปี่ ล่าง’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“อางอ้าย มาง นาบาตา เย นืงบาค่า แง. จฺ่าปอต้างปอ โย้เวอ บ่าอ่อง แล เย. แฮ้งเย่ อางโบ้ง มาง ยางนา อ่อก ช่าง ลือ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","จ้า ยาง อางโบ้ง มางนา ม่า ชี นี้แม้แน, ‘อ่าโบ้ง เวอ, ฮูปาว กงาย่า นางนา ไล ปี ย้า ล่ากาน ว่าย ปี่ ล่าแอ่, ยาว นาง ม่า ล่าง อือ บ่าฮา แน บ่าจา, จ้า นา กงานา เจิ้นเจ้อ บ่าปี่ ล่า กางซื้ง. กงา อางช่าง อือนา แพแล ทื่อโต แนม บ่าแซ่ ปอ กางซื้ง. ");
INSERT INTO bzi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","จ้า อ่าแพ้ ยา นาง อางเกิ่งอางก้อ อือ ค่าบาย่า อางโต ก่อง อือนา โค แน ปี่ ชี, ยาว ยาง พ่าว ล้า แล่เมอ นา ยางนา อ่ามย่าง อางตู่ง แซ่ ปอ แล่ ชี่’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“ยาว อางโบ้ง มาง ม่า ชี นี้แม้แน, ‘อางย่า เวอ, นา อ่าโบ้ง ก้อง ทื่งกง่า แน ดื้ง ลาย มล่าง คางญา. ยาว อางเกิ่งอางก้อ คาโคลาโค นี้ย่า นาง เฮอ เพล่อ ญา. ");
INSERT INTO bzi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","จ้า กงูย่า จามปีน ย้า จฺ่าปอต้างปอ แง, ไม้ นาง แพ้ ซฺี้ คายาว อางซฺื่อ แต่ล้า แล่ ชี แน ทื่อช่างกานญา, กงู ยางนา โปยว ยาว อางซฺื่อ ซฺ้า มย้าง แล่ ป้าน่อ, แฮ้งย้า กงู กย่าง นี้ย่า’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ยาว พระเยซู ศิษย์ อือนา นี้แม้แน จี่ช่าง ชีเย, “ชฺ้าง อางจาอางปาง ทื่อม่าง จา เย. ชฺ้าง ทื่อม่าง นา จ้าง ยาง อางเกิ่งอางก้อ แฮ้ง ฮูพลา ปี่ ชีเย. จ้า น่อง เวอ ฮาก นี้แม้แน ม่า ล้า ชีเย, ชฺ้าง อางเกิ่งอางก้อ ฮูพลา แฮ้ม้า นาง พลู้ ย่าง ค้าค้าเล้อเล้อ แน ไจ ชีแน. ");
INSERT INTO bzi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ยาว ชฺ้าง อางจาอางปาง มาง ชฺ้าง อางเกิ่งอางก้อ ฮูพลา มางนา ฮ้าว น้า ชี นี้แม้แน, ‘กงา อางเลิ่ง กงากย่า ล้า ชีนี้ กงานา ม่าย ล่าวแล ล้อแม้ แน. พลู้ ปาบ นาง ฮูพลา แต้ม ชี ชี แฮ้ง กงานา คื่น ปี่ ล่าว. กงา นางนา ก่าอ่อก ล่าง’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“ยาว ชฺ้าง อางเกิ่งอางก้อ ฮูพลา มาง นืงบา เวอ เย้ง ชี นี้แม้แน, ‘กงา ล้อแม้ ฮาย วา, กงานา ชา ก่า อ่อก ล่าง. นื้งชฺ่า ตู่ เวิม แฮ่ง บ่าจา ชี ล้า, พลู้ ชา ป้า กว่า เวิม ฮากนา ซฺ่าจอ คาแน้. ");
INSERT INTO bzi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","อ่อ กงา แบ คายา, กงา ล่ากาน บ่าจา แน ฮา เมอ ชฺ้าง กงานา ปล่อง ล่าฮู ซฺ้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","แฮ้งย้า ยางมือ ชฺ้าง ยาง เจ้านาย มางก้อง อางชี่ ตีด แล่ชี่ อือนา, ฮ้าว น้า ชี กาเทอ กามาง กาแน. ยางมือ ทื่อม่าง มางนา น้า ชี นี้แม้แน, ‘นา กงา เจ้านาย มางก้อง อางชี่ อาล่อ จา แง?’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ยาว ชฺ้าง อางชี่ ตีด แล่ ชี มาง นี้แม้แน ม่าย ชี, ‘น้ำมันมะกอก 100 ถัง’ ยาง นี้แม้แน ม่าย ชี, ‘นี้ย่า นาง อางชี่ อางพ่า ย่าง อางไว่ แน 50 ถัง แน แต้ม โว!’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ยาว ยาง ทื่อม่าง มางนา นี้แม้แน น้า แล่ ชี่, ‘นา อาล้อ แน อางชี่ จา แง?’ แน. ยาง ม่า ชี นี้แม้แน, ‘กอ 100 ถัง’ แน. ยางมือ นี้แม้แน ม่า ชี, ‘อางชี่ อางพ่า นู้ 80 ถัง แน แต้ม ลู่ง โว’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ยาว ชฺ้าง อางจาอางปาง มาง, ชฺ้าง อางเกิ่งอางก้อ ฮูพลา อาน มาง อางเลิ่ง ฮา ชี แฮ้ง แบน ชี. ยาว ยางนา จี่ ช่าง ชี อางแอ้น แน, ไม้ ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือ นี้แม้แน อางเลิ่ง ฮา แฮ้ง, อางคี่ คู พาจาว มาง ชฺ้าง อือ ล่อบ่าปา แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ยาว กงา ม่ายแบ ปี่ ล่าว่า ชฺ้างอางเมิง นู้ อางช่าง ซฺ้า เมอ พลู้ นี้ง ไจ ซฺ้า ปาว, ไม้ พลู้ โค ยาว นางมือ นาง อางช่าง อือก้อง ชฺ้างอางเมิง นู้เวอ ทื่งกง่า ย้า กงาดื้ง แล แล่ง. ");
INSERT INTO bzi_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ชฺ้าง อางเลิ่ง อางอี แฮ้ง นืงบาชี ฮูพลา ว่า ปี่ อางกงา กางอือ, อางเลิ่ง อางฮื่อ อือ คาตา ยา นืงบาชี ฮูพลา ว่า ปี่ กงา กางแง. จ้า ชฺ้าง อางเลิ่ง อางอี แฮ้ง ฮูพลา ว่า ปี่ง แน นืงบาบ่าชี่ กงา กาง อือ, อางเลิ่ง อางฮื่อ อือ คาตา ย้า นืงบาบ่าชี่ กงากา. ");
INSERT INTO bzi_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","นี้แม้แนยาว ชฺ้างอางเมิง นู้เวอ อางเกิ่งอางก้อ อางอี อือ, ฮูพลา แฮ้ง นืงบาบ่าชี่ ล่ากงา กายาว, พาจาว มาง นางนา อางเลิ่ง ปีนแตปีนนา ม้าม้า อือ, ล้อแม้ นืงบาชี ฮูพลา ว่า ปี่ ล่า กงากา แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ยาว จาว่าแน นอง ฮาก อางเกิ่งอางก้อ แฮ้ง บ่าฮูบ่าพลา ปี่ กงากา ยาว. น่อย่า บ้าเจอล้อแม้ ค่าตอง อางเกิ่งอางก้อ แฮ้ง ฮูพลา กงากา แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ย่าเจ่น นี้ย่า เจ้านาย 2 คู่น แน ล่ากาน บ่าว่า ปี่ กงากา, ไม้ ย่าเจ่น นี้ม้า ทื่อม่าง มางนา ลาก ยาว ทื่อม่าง มาง นา เม้อ แง, บ่าอ่าเวิม ยา เจ้านาย ทื่อม่าง มางนา ซอ ยาว, ทื่อม่าง มางนา ฮูย้า แง. ยาว นี้งย้า นองมือ พาจาว มางนา แน พลู้ แฮ้งนา ทื่อญ่าม กาแน บ่าลาก กงากา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ยาว ฟาริสี พลู้ นา ซอ อือ อางเลิ่ง คาโคลาโค แฮ้ง กงากย่า ยาว, พระเยซู นา อื้อ กาน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","แฮ้งเย่ พระเยซู นี้แม้แน จี่ ชี, “นองมู นี้ย่า ฮากนา แบ ปี่ ซี่ง แง. นอ พาจาว มาง นืงบาวา แน ฮาย เค่ แงแน. จ้า พาจาว ม้า อางแบ นอง นืงบา นี้ย่า อางไล้ อือ แอ่ ย้า จา แง. ยาว ม้างม้าเจ้อ ชฺ้าง อือ อางแม่น, แน ปีนแตปีนนา แน เย้ง อือ พาจาว ม้า ช่าคาบอล้อ แน เย้ง แง.” ");
INSERT INTO bzi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“ยอห์น ล้างตือพิธีบัพติศมา ฮา มาง ชา ลือ เมอ, ยิวชฺ้าง นี้ย่า โมเสส อางลี้บอางล่าว แน พาจาวจี่ต่างจี่แต่นฮู อือ, ม่าอู่บ แฮ้งนา อางน้า จ่า. ยาว ยอห์น มาง ลือ ยาว, อางเลิ่ง อางแม่น พาจาว มาง ชฺ้างอางเมิง นู้ ก่าซ้าด ลือ เพล่อ ชี นี้ง อู่บน้า ปี่ แง. ยาว อามือ ชฺ้าง คาโคลาโค อือ พาจาว มาง ชฺ้าง อือก้อง ทื่งกง่า แน ดื้ง ซี้ แง. ");
INSERT INTO bzi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","จ้า มู่ง แน นื้งชฺ่า แฮ้ง โปยว เวิม, อางลี้บอางล่าว ปาบ โย้เวอ อางไล่ อืมมือ ทื่อโต แนมมือ บ่าโปยว แอ.” ");
INSERT INTO bzi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ค่าพ่าย่า ล้อมาง ค่าตอง ค่าบา นา ว่าง แล่ยาว ค่าบา อางซฺื่อ ยู้ แล่ง, ค่าพ่าย่า แฮ้ม้า จู้ จา ชี แน ทื่อช่างกานญา. ยาว ค่าพ่าย่า ล้อมาง ค่าบาย่า อางบล้อง ว่าง แล่ชี่ มางนา ยู้ แง, ค่าพ่าย่า แฮ้ม้า จู้ จา ชี แน ทื่อช่างกานญา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ยาว พระเยซู นี้แม้แน อางเลิ่ง อู่บ เพ้กน้า แล่ ปี่ชี่ นี้แม้แน, “ชฺ้าง อางจาอางปาง ทื่อม่าง จา เย, ยา อางก่าอางตูม สีม่วง อางฮู่ อางคา แน พ้าป่าน อางแม่น อือ ตูม แล่ ชีเย. จี่วีด จาบื่อดื้งบื้อ ย้า จฺ่าต้าง ดื้ง แง. ");
INSERT INTO bzi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ยาว ชฺ้าง อางตูกอางพาน ทื่อม่าง จา เย, ยาง อางเม้ง ลาซารัส แน เย. ยาง อางโต อือเมอ มาป้อ ปลื้ง ย้า จา แง. ยาว ยา ชฺ้าง อางจาอางปาง มาง ยู้ม ล้องก้อ ล้าก้า โย้เวอ ยู่ จา เย. ");
INSERT INTO bzi_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ยา ชฺ้าง อางจาอางปาง มาง โต โย้เวอ จฺ่าเกิ่ง กลา ชีแฮ้ง จฺ่า ซี่ง เย. ยาว คื่อ อือ ยาง มาป้อ แฮ้ง แบ่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“ยาว น่อง โย้เวอ ลาซารัส มาง ซฺี้ ยาว, เท่วาด่า อือ ยางนา ลาบ อับราฮัม ก้อง มู่งท่า โย้เวอ ซฺื่ย ดื้ง แล ชีเย. แน ชฺ้าง อางจาอางปาง มาง นามมือ ซฺี้ ยาว พูม ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ชฺ้าง อางจาอางปาง ม้า ล่าลูก เวอ กลาแอ ชี, ยาว ยา นาบาตา ย้า ลาบ้าบ ชี. จ้า ยา อับราฮัม นา อางเว่อ เวอ จาย ฮู มย้าง แง. ยาว ลาซารัส นา อับราฮัม ก่องทาง โย้เวอ จูง จา นา มย้าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“ชฺ้าง อางจาอางปาง มาง โฮ้กฮ้าว ล้า ชี นี้แม้แน, ‘อับราฮัม กงา อางฮู่ มาง เวอ, กงานา ซื่งกง่ากย้า ลาซารัส นา กงาก้อง ซฺาลือ ปี่ ล่าปาว, ไม้ ยาง ล่าปู่ ล่าญู่ง แฮ้ง ล้าง โย้เวอ แดด ยาว, กงา ม่านล่า นู้ แดด ปี่ ล่า ปาว ล้อง นี้ง โปยว คาไล, ไม้ กงา บี่ท่อ แต่ นู้ ล้อง ด้า ลาบ้าบ แง’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","จ้า อับราฮัม นี้แม้แน ม่า เย, ‘อางย่า เวอ, อางเย้ง กงา ไกล่า นาง อางแต่ แน ฮา เมอ, นา ม้างม้าเจ้อ อางแม่น แอ่ ย้า กงาบู้ แง, จ้า ลาซารัส ม้า ม้างม้าเจ้อ บ่าแม่น อือ แอ่ ย้า กงาบู้ แง. จ้า อามือ ยา จาบื่อดื้งบื้อ ย้า จา แง, จ้า นา ลาบ้าบ แง. ");
INSERT INTO bzi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ยาว อ่าจ่าม มือ แปฟาง อางมอง อางกลื้อ จา แง, กงูนา บ่าปี่ ซฺ้า กาลา’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“แฮ้งย้า ชฺ้าง อางจาอางปาง มาง นี้แม้แน จี่ ชี, ‘นี้แม้แนยาว อับราฮัม กงา อางฮู่ มาง เวอ, ลาซารัส นา ม่าย อ่าโบ้ง ยู้ม โย้เวอ แล ปี่ โว! ");
INSERT INTO bzi_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ไม้ กงา ม้องน้าม 5 คู่น จา แล่ง. ลาซารัส นา ยองนา ม่าย อางโต แล่มล้าง แล่ ปี่ แน, ไม้ กาญ่าม เวอ ยอ กงา แม้แน บ่ากงา ลาบ้าบ แล่ก้าน’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“จ้า อับราฮัม ม่า ชี นี้แม้แน, ‘โมเสส แน พาจาวจี่ต่างจี่แต่นฮู อือ ยองนา ม่าอู่บ จา แง. ยองนา ชฺ้าง แฮ้อือ จี่ต่าง ม่าอู่บ แฮ้ง น้า ปี่ ปาว’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“ชฺ้าง อางจาอางปาง มาง จี่ เย นี้แม้แน, ‘อับราฮัม กงา อางฮู่ มาง เวอ นี้ม้อก ฮา นี้ บ่าก่อ กาซื้ง เป, แฮ้แม้ยาว ชฺ้างซฺี้ แอ ชี อือนา แต่ล้า ปี่ ยาว ยองนา ม่าอู่บ แล่ ปี่ โว, ยาว ยองมือ อางน้าจ่า ย้า. ยาว ยอง อางบล่าบ ฮา แฮ้ง ว่าง ยาว นืงบา อางเพ่น คู ย้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“อับราฮัม ยางนา จี่ช่าง ชี นี้แม้แน, ‘ยอง โมเสส แน พาจาวจี่ต่างจี่แต่นฮู อือนา บ่าน่าจ่า ยาว, ยอง มือ ชฺ้างซฺี้ ยาว แต่ล้า ชีอือ นา บ่านาจ่า ทื่อช่างกานญา’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ทื่อนืง จา เย พระเยซู ศิษย์ อือนา นี้แม้แน จี่ช่าง ชี, “ม้างม้าเจ้อ จา แง ชฺ้าง อือนา จ้อบ บ่าแม่น ฮา ปี่ง. จ้า อางบล่าบ นี้ย่า, ชฺ้าง ฮากนา อางบล่าบ จ้อบ ฮา ปี่ง อือก้อง กลา แง. ");
INSERT INTO bzi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ยาว ชฺ้าง ย่าเก อือนา อางบล่าบ เค้ ฮา ปี่ง อือนา, ลอบา อางฮื่อ แฮ้ง นื้งชฺือ เวอ พือ แป่น ยาว ทะเล เวอ ต่านคลา แอ ปี่ง แฮ้ง ซูม แง. ");
INSERT INTO bzi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","นี้แม้แนยาว ค่าตอง อางโต แฮ้ง แม่น แน ฮูพลา จ่าแล่ โว. ยาว นาง ย่าช่างม้องน้าม อางบล่าบ ฮา อือนา ม่าย ว่าง ปี่ โว! ยาว จาว่าแน ยาง ม้าม้า แน อางบล่าบ ฮา แฮ้ง ว่าง ยาว ยางนา อางเลิ่ง บ่ายู่ โจ. ");
INSERT INTO bzi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","แน ยาง นางนา กานืง 7 เทอ กา แน บ่าแม่น ฮา ล่าเมอ, นางนา กูเทอ แน นี้แม้แน ม่า ล่ายาว, ‘ซูม่า ย้าเป กงา นี้แม้ บ่าฮา แล่ กาน’ แน. นี้แม้แนยาว นาง ยางนา เจิ้นเจ้อ อางเลิ่ง บ่ายู โจ เป” แน. ");
INSERT INTO bzi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ยาว ศิษย์ อือ จี่วีดอางซื้ง มางนา จี่ช่าง ชี นี้แม้แน, “อ่าจาน เวอ, กงูนา ปล่อง อางอ้าน นี้ง ล่อบ่าปา แน ฮาย เจ่อ ปี่ ล่า ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ยาว พระเยซู นี้แม้แน พอ ชี, “จาว่าแน นอง ม่าต่าโก้บ อางนือ ล่อ แน เจ่อ ยาว, นอ จฺืงจฺื้ง อางฮื่อ มางนา ม่า ทะเล โย้เวอ ดื้งแอ ปี่ เวิม อางกงา ย้า. ยาว จฺืงจฺื้ง อางฮื่อ มาง ม้าม้า ย้า ทะเล โย้เวอ ดื้ง แอ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“จาว่าแน นางก้อง ย่าเจ่น ทื่อม่าง จา แง. ยาว ยางนา แกะ ปอ น่าไท่ ปี่ง, ยาว ยาง พ่าวล้า แล่เมอ, นา ยางนา นี้แม้แน อางม่า ล่า? ‘ดื้ง ลื่อยาว จฺ่าต้าง ปาว’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","อ้าว นา ยางนา นี้แม้แน จี่ช่าง ล่า, ‘กงานา ฮ่างเพิ่น จาม จฺ่า ปี่ ล่ายาว, นู้ ดื้ง ล่อ กงานา ฮูพลา ล่าว. ยาว นาย่า กงา จฺ่าต้าง เปิน เมอ จฺ่า กาโน’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ยาว เจ้านาย ม้า ย่าเจ่น ยาง ม่าย ฮา ปี่ ชี อือ ฮา ชี มางนา ขอบคุณ อางฮา ลา? ");
INSERT INTO bzi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","นอง ทื่อช่างกานญา พาจาว มาง ล่ากาน ม่าย ฮา ปี่ แฮ้ง ว่า เปิน ยาว นี้แม้แน จี่ คู โว! ‘กงู ย่าเจ่น นาง ม่าย ฮา ปี่ แฮ้ง ว่าย ยา, นาง กงูนา ขอบคุณ ฮา ล่าง นี้ย่า บ่าซูม เป’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ยาว พระเยซู เยรูซาเล็ม อางเมิง เวอ ย่อ แล เมอ, ยา กาลิลี แควน แน สะมาเรีย แควน โย้เวอ ย่อไก ชี. ");
INSERT INTO bzi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ค่อง ทื่อค่อง จา ค่าพ่าย่า ทื่อแช่ คู่น จา แง คี้ตู้ด เพล่อ คู ชีเย. ยองมือ พระเยซู นา ซฺ้า แล คู ชี, จ้า ยอ เว่อ แน จูง จา คูง เย. ");
INSERT INTO bzi_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ยาว ยอง จี่ โฮ้กฮ้าว คูชี นี้แม้แน, “พระเยซู กงู เจ้านาย มาง เวอ, กงูนา ซื่งกง่ากย้า ล่าปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","พระเยซู มือ ยองนา ฮู ยาว นี้แม้แน จี่ช่าง ชีเย, “นอง อางโต แฮ้ง ปุโรหิต อือนา ฮู แอ ปี่ ปาว” แน. ยาว ยอง ย่อ แอ เมอ ยอง คี้ตู้ด ย่าง โปยว ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ยาว ชฺ้าง คี้ตู้ด โปยว ชี อางมู โย้เวอ ชฺ้าง ทื่อม่าง จา แง. ยาง คี้ตู้ด ย่าง โปยว ชี แน มย้าง ยาว, พ่าว ลือ อางเซง บื้ง แน พาจาว มางนา สรรเสริญ ฮา ชี. ");
INSERT INTO bzi_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ชฺ้าง คี้ตู้ด โปยว ชี นี้ม้า สะมาเรียชฺ้าง เย, ยาว ยาง พระเยซู ล่าคื่อ เวอ บอกไว้ ยาว ขอบคุณ ฮา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ยาว พระเยซู ยางนา น้า ชี นี้แม้, “ทื่อแช่ คู่น อ่าลา คี้ตู้ด โปยว ชีนี้ ยาว ชฺ้าง 9 คู่น อือ เกิ้ง แอ โค ชี? ");
INSERT INTO bzi_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ยาว บ้าเจอ ยิวชฺ้างบ่าอ่า นี้มาง ญา ล่า พาจาว มางนา สรรเสริญ ฮา นี้ย่า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ยาว พระเยซู ยางนา นี้แม้แน ม่า ชี, “ทานล้า ยาว พ่าว แล ปาว, นาง เจ่อ นี้ง ย้า นาง คี้ตู้ด โปยว ชี นี้ย่า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ทื่อนืง จา เย, ฟาริสี อือ พระเยซู นา นี้แม้แน น้า ชี, “พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ นี้ย่า ล้อญ่าม ลือ แง?” แน, ยาว พระเยซู นี้แม้แน พอ ชีเย, “พาจาว มาง ก่าซ้าด เพล่อ ลือ นี้ย่า บ่าแบตอ กา. ");
INSERT INTO bzi_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ยาว อ่าซ่าง มาง บ่าม่าตอ กา, ‘ยา นู้จา แง’ แน, บ่าอ่ายาว ‘ยา โย้ จา แง’ แน, ไม้ พาจาว ม้า นอง นืงบา นู้เวอ ก่าซ้าด เพล่อ ลือ ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ยาว พระเยซู ยาง ศิษย์ อือนา จี่ช่าง ชี นี้แม้แน, “ยาว นอย่า กงาชฺ้างอางย่า ม่าง ชฺ้างอางเมิง นู้เวอ, ก่าซ้าด เพล่อ ลือ แฮ้นืง นา มย้าง คู ซี้ เวิม นอ บ่ากงา มย้าง คู. ");
INSERT INTO bzi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ยาว นองนา ชฺ้าง นี้แม้แน ล้า ม่า ล่าเมอ, ‘ชฺ้างอางย่า ม้า โย้เวอ จาน ญ้า, บ่าอ่ายาว นู้เวอ จาน ญ้า’ แน. นอ ยางนา บ่ากงา ซฺ้ากว่า คาเป. ");
INSERT INTO bzi_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ไม้ กงาชฺ้างอางย่า มาง ลือ เมอ, เจ้ง ย้า กงามย้าง คูแง, มู่งท่า เวอ มู่งบล่าบ ทื่อปล่าก จาย ทื่อปล่าก ป่ากย่า บล่าบ แม้แน ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","จ้า กงา อางบย่า ย้า ลาบ้าบ เปิน แง. ยาว อามือ ชฺ้าง นี้อือ กงานา บ่าเจ่อจ่า ล่า. ");
INSERT INTO bzi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“ยาว กงา พ่าวลือ แล่ แฮ้นืง ย่า โนอาห์ จีน แฮ้งแม้แน เป. ");
INSERT INTO bzi_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","แฮ้ญ่าม เมอ ชฺ้าง อือ ค่าบาล่า จฺ่าต้าง ม่อนซ้า คูแง, จ้า โนอาห์ ล้อง คล้าว โย้เวอ อ้องแล เมอ, ซฺ้อก ย้า ล้าง ทู้ม ล้า แง. ยาว ยองมู แฮ้ง ล้าง นื่อแซ่ แล่ โค ชี.” ");
INSERT INTO bzi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“โลท จีน โย้เวิม ทื่อช่างกานญา, ชฺ้าง อือ วื้อซฺ้า, ก่องก้า, จฺ่าต้าง, คลาซ้าง, ยู้ม ชฺอ คูแง. ");
INSERT INTO bzi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ยาว โลท โสโดม อางเมิง เวอ อ่อก ลือ เมอ, ซฺ้อก ย้า มู่งท่า โย้เวอ บี่ท่อ แน ลอบา บี่ท่อ ย่าง กลา ลืน ชี. ยาว อางเมิง แฮ้เมิง โย้เวอ ชฺ้าง อือนา โค ย้า จฺ่อ ชี.” ");
INSERT INTO bzi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“ยาว กงา พ่าวลือ แล่ แฮ้นืง ย่า แฮ้แม้ย้า เพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","แฮ้ญ่าม เวอ ชฺ้าง ยู้มมู้ง ท่า ดื้ง ชี อือนา, ยู้ม คล้าว โย้เวอ อางเกิ่งอางก้อ บ่าปี่ อ้อง กอ แล โจ. ยองนา อางไว่ แน ตาแซ้ โย้เวอ ฮื่น แล ปี่ โว. ชฺ้าง น่า แน ย้า โย้เวอ จา คูชี อือนา ยู้ม คล้าว โย้เวอ, เจิ้นเจ้อ บ่าปี่ อ้อง ยู้ แล ปี่ โจ. ยองนา อางไว่ แน ตาแซ้ โย้เวอ ฮื่น แล ปี่ โว! ");
INSERT INTO bzi_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","โลท ค่าบา มางก้อง อางเลิ่ง ตอล้า ชี้ แฮ้งนา บ่าลู่ม คูโจ. ยาง โสโดม อางเมิง แฮ้ง พลาบ ฮู ชี แฮ้ง ปาปาย ย้า พาจาว มาง ยางนา แซ่ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ไม้ ชฺ้าง ค่าตอง จี่วีด แฮ้งนา กงานา ล่อบ่าปา แน ลาก อือ กงาซฺี้ แง. จ้า อ่าซ่าง กงานา เจ่อ ล่า ปาปาย ซฺี้ แง, ชฺ้าง แฮ้ม้า จี่วีดม้าม้า กงาจา แล แง. ");
INSERT INTO bzi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“กงา ม่ายแบ ปี่ ล่าว่า, แฮ้คี่ ชฺ้าง 2 คู่น ยู่ป่าม โย้เวอ ทื่งกง่า แน ยู่ เมอ, ทื่อม่าง กงานา เจ่อ ล่าง มางนา มู่งท่า โย้เวอ ซฺื่ยแล แง. ทื่อม่าง กงานา บ่าเจ่อ ล่าง มางนา ชีช่าง แง. ");
INSERT INTO bzi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ยาว ค่าบาย่า 2 คู่น ทื่งกง่า แน กอท่อง จา เมอ, ทื่อม่าง กงานา เจ่อ ล่าง มางนา มู่งท่า โย้เวอ ซฺื่ยแล แง. ทื่อม่าง กงานา บ่าเจ่อ ล่าง มางนา ชีช่าง แง. ");
INSERT INTO bzi_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ยาว ชฺ้าง 2 คู่น น่า โย้เวอ จา เมอ, ทื่อม่าง กงานา เจ่อ ล่าง มางนา มู่งท่า โย้เวอ ซฺื่ยแล แง. ทื่อม่าง กงานา บ่าเจ่อ ล่าง มางนา ชีช่าง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ยาว ศิษย์ อืม พระเยซู นา น้า ชี นี้แม้แน, “อ่าจาน เวอ, อางเลิ่ง นี้ย่า ล้อเกิ้ง ตอล้า แง?” แน. ยาว พระเยซู มือ ยองนา นี้แม้แน จี่ เพ้กน้า ปี่ ชีเย, “ล้อเกิ้ง เวอ ชฺ้างซฺี้ อางปู่ จฺ่า แง โย้เวอ ฮาย่า อีแร้ง อือ จา แง. ยาว กงา นองนา อางเลิ่ง อู่บน้า ปี่ ล่า ชี่ แฮ้ กงา พ่าวลือ ญ่าม แฮ้ง ชา เคอ เมอ, ตอล้า แง แบ ชี คู โว เป” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ยาว พระเยซู มือ ยาง ศิษย์ อือนา อางเลิ่ง อู่บ เพ้กน้า ปี่ ชีเย, ไม้ ยองนา ม่าอู่บ กูนืง แน อธิษฐาน ฮา แล่ ปี่ง นืงบา บ่าปี่ ด่อ แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ยาว พระเยซู อู่บ ชี นี้แม้แน, “อางเมิง ทื่อเมิง จา เย ต้าดต่อนฮู ทื่อม่าง จา แง, พาจาว มางนา บ่าแค เย. ยาว อ่าซ่าง มางนา บ่านาบบ่าทื่อ เย. ");
INSERT INTO bzi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ยาว อางเมิง นี้เมิง ก้อง แมม้าย ทื่อม่าง จา เย, ต้าดต่อนฮู นี้มาง นา ป้า ย่อ เย นี้แม้แน, ‘ชฺ้าง ทื่อม่าง จา กงานา บ่าแม่น ฮา ล่าง, กงา อางเลิ่ง นี้ง กง่าเกิ้ง แน ต้าดต่อน ปี่ ล่า ปาว.’ ");
INSERT INTO bzi_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ต่องก่า เมอ ต้าดต่อนฮู ม้า แมม้าย มางนา บ่าตี่นบ่าต่อง เย. จ้า น่องเวอ ต้าดต่อนฮู มาง ม่าจ่าแล่ง เย นี้แม้แน, ‘กงา พาจาว มางนา บ่าแค แน อ่าซ่าง มางนา บ่าแค เวิม มือ, ");
INSERT INTO bzi_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","กงาย่า แมม้าย นี้มางนา กง่าเกิ้ง แน ต้าดต่อน ปี่ ปานา, ไม้ ยา กงานา ซูนแซว ล่าง, ยาว ยาง กงานา ซูนแซว ล่างนี้ง ว่าง คาไล, นี้แม้ บ่าฮา ยาว กงา เปิดบา อางเพล่อ กงากา’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ยาว พระเยซู นี้แม้แน จี่ แล่ง เย, “อางมย้าง ล่า ต้าดต่อนฮู บ่ากง่าบ่าเกิง นี้ม้า บ้าเจอ จี่ แงแน, ");
INSERT INTO bzi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","แฮ้งย้า น่องเวอ ยาง กง่าเกิ้ง แน ต้าดต่อน ปี่ชี่. นี้แม้แนยาว พาจาว ม้า ชฺ้าง ยาง แช้ยู้ ชี มางนา อางกง่าอางเกิง แฮ้ง บ่าปี่ ลา? ยาง มู่งคี่ ซอทา แน ป้า เมอ บ่าปล่อง ลา? ยา เจิ้นเจ้อ บ่าปล่อง แน บ่าตอย จา ปี่ เป. ");
INSERT INTO bzi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ยาว กงา ม่ายแบ ปี่ ล่าว่า, พาจาว ม้า ยองนา อางกง่าอางเกิง ปี่ แง! จ้า กงาชฺ้างอางย่า มาง พ่าว ลือ เมอ, กงา ชฺ้าง พาจาว มางนา เจ่อ อือนา อางมย้าง ลือ ลา?” ");
INSERT INTO bzi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","พระเยซู อางเลิ่ง นี้เลิ่ง อู่บเพ้ก นี้ย่า, ไม้ ชฺ้าง ฮากนา ฮูย้า อางคา อือนา ม่าอู่บ เย, แน ชฺ้าง พาจาว มางนา นืงบาจาบวา แน ฮายเค่ ชี แน, ค่าตอง อางโต แฮ้ง ฮาก ลอบ่าปา แน เย้ง จ่าแล่ง อือนา ม่าอู่บ แง. ยาว พระเยซู นี้แม้แน จี่ เพ้ก น้า ปี่ชี่ เย, ");
INSERT INTO bzi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“ชฺ้าง 2 คู่น จา แง ทื่อม่าง ม้า ฟาริสี ทื่อม่าง ม้า ภาษีกอฮู เย. เย่ด โบสถ์อางฮื่อ โย้เวอ อธิษฐาน ฮา แล ชี. ");
INSERT INTO bzi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ยาว ฟาริสี แฮ้มาง ยาง ทื่อม่าง แน อธิษฐาน ฮา ชี นี้แม้แน, ‘พาจาว เวอ, กงา กย่าง แง กงา ฮาก แม้แน อางบล่าบ บ่ากงา ฮา, ไม้ กงา ฮาก อางเกิ่ง บ่าค่าว กว่า แน ฮากนา บ่ากงา จ้อบ กว่า, แน ฮาก ค่าบา นา บ่าโกนบ่าก่าว กว่า, ยาว ภาษีกอฮู แฮ้มาง แม้แน บ่ากงา เพล่อ. ");
INSERT INTO bzi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ยาว กงา จฺ่าเกิ่งจฺื่ง แง กาตีด 2 เทอ กาแน, อางเกิ่ง ทื่อแช่ ปูนกงา ยาว ทื่อ ปูน ท่าน แง.’” ");
INSERT INTO bzi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“จ้า ภาษีกอฮู ม้า เว่อ แน จูง อธิษฐาน ฮา เมอ, ยา มู่งท่า โย้ บ่าแงน ฮู จอ กาเย, ยา ค่าตอง นื้งเอิ้ก โย้เวอ ทาก แล่ยาว อู้ง ฮ้าว จี่ ชี นี้แม้แน, ‘พาจาว เวอ, กงา ชฺ้าง อางบล่าบ เพล่อ ชี นี้งนา กงานา ซื่งกง่ากย้า ล่าปาว’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","กงา ม่ายแบ ปี่ล่าว่า เย่ด อธิษฐาน ฮา เปิน เมอ, พาจาว ม้า ภาษีกอฮู มางนา อางบล่าบ ปูน ปี่ง. ยาว ฟาริสี มางนา อางบล่าบ บ่าปี่ ปูน, ไม้ อ่าซ่าง ฮื่อจ่าแล่ง ยางนา อ่าซ่าง มาง บ่านาบบ่าทื่อ. ยาว ชฺ้าง บ่าฮื่อจาแล่ อือนา ฮาก นาบทื้อ คูง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ชฺ้าง ทื่อบ่า จา แง. ย่าเก อางอี อือนา ซฺื่ย พระเยซู นา ซฺ้า ล้า ชี, ไม้ ยางนา ล่าปู่โบ่ย ก่ามป่อน ปี่ ปี่ง แนนอ. จ้า ศิษย์ อือย่า แฮ้แม้แน บ่าปี่ ฮา แน อี่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","จ้า พระเยซู ย่าเก อือนา ฮ้าว อ้องล้า ปี่ ยาว นี้แม้แน จี่ เย, “ย่าเก อือนา กงาก้อง ตอย อ้องล้า ปี่ว. ยองนา เจิ้นเจ้อ บ่าจี่ โจ, ไม้ ชฺ้าง พาจาวอางเมิง เวอ กงาอ้อง แล คูง อือย่า ย่าเก นี้อือ แม้แน กงาเจ่อ แง. ");
INSERT INTO bzi_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","กงา ม่ายแบ ปี่ ล่าว่า, อ่าซ่าง ย่าเก นี้อือ แม้แน พาจาว มางนา นืงบาบ่าชี่ แง, พาจาวอางเมิง เวอ บ่ากงา อ้อง แล” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ยิวชฺ้าง ยอคา ทื่อม่าง จา แง. พระเยซู นา นี้แม้แน น้า ชี, “อ่าจาน อางแม่น เวอ, พาจาว มางก้อง ทื่งกง่า แน จี่วีดม้าม้า จา แล นี้ย่า กงา บ้าเจอ กงาฮา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","พระเยซู มือ นี้แม้แน พอ ชี, “นา บ้าเจอฮาย กงานา ชฺ้าง อางแม่น แน ฮ้าว ล่าง? อ่าซ่าง มาง บ่าแม่น เป. พาจาว มาง ทื่อม่าง ญา อางแม่น แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","นาง มือ อางลี้บอางล่าว แฮ้ง อางแบ ย้า. อางลี้บอางล่าว เวอ นี้แม้แน แต้ม ชี ชี, ‘ฮาก อางบี่อางบล้อง นา จู้ บ่าเพล่อ โจ, ชฺ้าง นา บ่าแซ่ โจ, อางเกิ่งอางก้อ บ่าค่าว โจ, ชฺ้าง แล่จ่อบ บ่าเพล่อ โจ, ค่าตอง อางบา อางโบ้ง นา นาบทื้อ โว’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ยาว ยิวชฺ้าง ยอคา มาง จี่ ชี นี้แม้แน, “อ่าจาน เวอ, กงาย่า ย่าเก เมอ จาย ย้า อางลี้บอางล่าว คาโคลาโค นี้อือ ฮาย ล้าน แอ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ยาว พระเยซู นี้แม้ กย่า เมอ จี่ ชี นี้แม้แน, “จ้า นา ทื่อย่าง กงาฮา แล่ง. นาง อางเกิ่ง คาโคลาโค จา แฮ้ง ก่อง ยาว, พลู้ แฮ้ง ชฺ้าง อางตูกอางพาน อือนา ปี่ แอ โว! ยาว นา มู่งท่า โย้เวอ อางเกิ่งอางก้อ บย่า แน จา แง. แน นา กงาก้อง เค่ ล้าน ยาว กงา ศิษย์ เพลิ่น ปาว!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ยาง แฮ้แม้ กงากย่า ยาว, นืงบาต่องบ่าม่อนบ่าซ่า เย, ไม้ ยา นาบาตา อางจาอางปาง เย. ");
INSERT INTO bzi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","พระเยซู ยาง นืงบาต่องบ่าม่อนบ่าซ่า แฮ้งนา มย้าง ยาว นี้แม้แน จี่ ชี, “ชฺ้าง อางจาอางปาง อือนา พาจาว อางเมิง เวอ อ้องแล ปี่ นี้ย่า นาบาตา ย่าก. ");
INSERT INTO bzi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","อูฐ อือนา ก่องกย่าว อางฮ้อน เวอ อ้องแล ปี่ง นี้ย่า, ชฺ้าง อางจาอางปาง อือนา พาจาวอางเมิง เวอ อ้องแล ปี่ง แฮ้ง ล่อบ่าปา ไง่ แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ยาว ค่องช่าง นี้เลิ่ง กงากย่า คู ชีอือ นี้แม้แน จี่ เย, “ซ้ามบา ชฺ้างอางจาอางปาง อืม พาจาวอางเมิง เวอ อ้องแล อางย่าก. ท้าว นี้แม้แนยาว พาจาวอางเมิง เวอ อ่าซ่าง อ้องแล กงา กาง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ยาว พระเยซู นี้แม้แน จี่ เย, “ชฺ้าง นี้ย่า บ่าฮาตอ กา, จ้า พาจาว ม้า อางฮา ตอกา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ยาว เปโตร มือ พระเยซู นา นี้แม้แน ม่าย ชี, “อ่าจาน เวอ, ฮูปาว กงูย่า กูย่างกูเจ้อ อือ วี ย่า ยาว นางก้อง เค่ คูง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","พระเยซู พอ ชี นี้แม้แน, “กงา ม่ายแบ ปี่ ล่าว่า, อ่าซ่าง พาจาว มาง ปาปาย แน, ค่าตอง ยู้ม, ค่าบา, ม้องน้าม, อางบา อางโบ้ง, อางย่าอางคย้า อือนา วี แง, ");
INSERT INTO bzi_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ยา ชฺ้างอางเมิง นู้เวอ ก่ามป่อน อางบย่า ย้า กงาบู้ แง. แน ยา ยาง วี ชี แฮ้ง ล่อบ่าปา ไล โตบ กงา แง. แน จ้างจ้าง โย้เวอ พาจาว มางก้อง ทื่งกง่า แน จี่วีดม้าม้า จา แล แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","พระเยซู ศิษย์ 12 คู่น อือนา ยางก้อง ฮ้าว ล้า ปี่ น้าว. ยาว ยองนา นี้แม้แน ม่าย ชี, “แม่น แน น้า โว! กงู เยรูซาเล็ม อางเมิง โย้เวอ แล คูแง. ยาว กงาชฺ้างอางย่า มาง อางเลิ่ง พาจาวจี่ต่างจี่แต่นฮู อือ มอ ยาว แต้ม ชี ชี แฮ้ย่า โย้เวอ ย้า ตอล้า แง. ");
INSERT INTO bzi_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ยาว กงานา โรมชฺ้าง อือ ก้อง ซฺาแล ปี่ ล่าง. ยาว ยอ กงานา อื้อกาน ฮูย้า ล่า คูแง, แน ค่านล่าง พี่ด กาน ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ชฺ้าง แฮ้อือ กงานา ตื่อชืก แซ่ ล่าง, จ้า กงา ซฺี้ ยาว วันที่ 3 โย้เวอ แต่ล้า แล่ง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","จ้า ศิษย์ อือ ยาง จี่ แฮ้งนา บ่าน่าแบ กา, ไม้ จี่ต่าง นี้ย่า จี่ต่าง น้า อางย่าก เย. ");
INSERT INTO bzi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","พระเยซู เยรีโค อางเมิง ย่อ ชา เคิน แอ เมอ, ชฺ้างแมปอ ทื่อม่าง แก้บ้า ก่องทาง เวอ พลู้ ป้า ดื้ง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ยาว ยา ชฺ้าง บย่า แน ย่อไก ล้า นา กงากย่า ยาว นี้แม้แน น้า ชี, “บ้าเจอ ตอล้า ชี?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ชฺ้าง อือ ม่า เย นี้แม้แน, “พระเยซู นาซาเร็ธชฺ้าง มาง อ่ามือ ย่อ ล้า แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ยาว ชฺ้างแมปอ มาง จี่ โฮ้กฮ้าว ชี นี้แม้แน, “พระเยซู ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บล้า ชี มาง เวอ, กงานา ซื่งกง่ากย้า ล่า ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ยาว ค่องช่าง อางอีบ่าอ่า ยางนา จี่จ้าด ม่าย กยาบ ปี่ชี่. จ้า ยาง อางอ้าน แฮ้ง ล่อบ่าปา อางเซง บื้ง แน โฮ้ก จี่ ชี นี้แม้แน, “พระเยซู ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บล้า ชี มาง เวอ, กงานา ซื่งกง่ากย้า ล่าปาว!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","พระเยซู ย่อ ย่าง ว่าง ยาว จูง ชีเย, ชฺ้าง อือนา ม่าย แมปอ มางนา ซฺื่ย อ้องล้า ปี่ ชีเย. ยาว ยาง แมปอ มางนา นี้แม้แน น้า ชี, ");
INSERT INTO bzi_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“กงานา บ้าเจอ ฮา ปี่ ล่าง?” แน. ยาง ม่า ชี นี้แม้แน, “จี่วีดอางซื้ง เวอ กงา มย้าง ซี้ค้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","พระเยซู มือ ยางนา นี้แม้แน ม่าย ชี, “ฮู ปาว ยาว มย้าง แง, นาง กงานา เจ่อ ล่าง นี้ย่า นาง แมนือ แมปอ ปอ ชี แฮ้ง, ฮาย โปยว ปี่ ล่าง ญ้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ยาว ยาง ฮู มย้าง ล้า ชีเย. ยาว พระเยซู ก้อง เค่แล พาจาว มางนา สรรเสริญ ฮา ชีเย. ค่อง ช่าง อืม แฮ้แม้ มย้าง ยาว ยอง พาจาว มางนา สรรเสริญ ฮา คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","พระเยซู เยรีโค อางเมิง คล้าว ย่อ อ้องแล ชี. ");
INSERT INTO bzi_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ยาว ค่าพ่าย่า ทื่อม่าง จา เย อางเม้ง ศักเคียส แน. ยา ภาษีกอฮู ยอคา นาบาตา จาปาง เย. ");
INSERT INTO bzi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ยาว ศักเคียส พระเยซู นา มย้าง ซี้ง เย, จ้า ยา บ่าฮู มย้าง กา, ไม้ ยา ชฺ้าง ตามตีน เย. ยาว ชฺ้าง อางบย่า ปลืงแท่ง กาแง. ");
INSERT INTO bzi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ยาว ยา ล้าก้า โย้เวอ ฮื่น แล พระเยซู นา ล่อ ฮู แล ชีเย. ยาว จฺืงจฺื้ง อางฮื่อ ท่า เวอ ตา แลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ยาว พระเยซู ย่อ เคอ แล ยาว ศักเคียส นา จี่ช่าง ชี นี้แม้แน, “ศักเคียส เวอ, อางไว่ แน ลู่งลือ โว! มี้นืง กงา นาง ยู้ม โย้เวอ ซ่าวดื้ง แล แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ยาง นาบาตา เย กย่าง แง. ยาว พระเยซู ก้อง อางไว่ ย้า ลู่ง ลือ ชี, พระเยซู นา ยาง ยู้ม โย้เวอ ซฺื่ย ซ่าว ดื้ง แอ นาว. ");
INSERT INTO bzi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ยาว ชฺ้าง คาโคลาโค อือ แฮ้แม้ มย้าง ยาว จี่จ่าบ คูชี นี้แม้แน, “พระเยซู ยา บ้าเจอ ชฺ้าง นาบาตา บล่าบ มาง ยู้ม โย้เวอ อางแอ?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ศักเคียส ยู้ม เวอ เคินยาว ยาง พระเยซู นา นี้แม้แน ม่าย ชีเย, “อ่าจาน เวอ, กงา อางเกิ่งอางก้อ จา นี้ย่า ทื่อคืง แฮ้ง ชฺ้าง อางตูก อือนา ปี่ แน. ยาว กงา อ่าซ่าง อางเกิ่ง แฮ้ง ยู้ ชี กงา แฮ้มางนา 4 โตบ คื่น ปี่” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","พระเยซู มือ ยางนา นี้แม้แน จี่ช่าง ชี, “มี้นืง นาง แน นาง ยู้มชฺ้าง อือ อางบล่าบ ย่าง กงาปูน แล่งญา, ไม้ นา ฮาย มย้าง ปี่ง ญา, นา อับราฮัม พาจาว มางนา เจ่อ ชี แฮ้งแม้แน เจ่อ แง, แน นา อับราฮัม อางอ่านอางซฺื้อ ม้าม้า ย้า แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ยาว กงาชฺ้างอางย่า มาง ลือ ชี นี้ นี้เลิ่ง ปาปาย ย้าเป, กงา ชฺ้าง โปยว ชี อือนา ซฺ้า กว่า ลือ แง, แน ยองนา อางบล่าบชออ่อก ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ยอง อางเลิ่ง ดื้ง น้า เมอ, พระเยซู อางเลิ่ง ทื่อเลิ่ง อู่บเพ้ก น้า ปี่ ชีเย, ไม้ เยรูซาเล็ม อางเมิง เวอ ชา เคอ กาชา เย. ยาว ค่องช่าง อือ เย้ง เย, พระเยซู มาง ก่าซ้าด เพล่อ ลือ ชี นี้ย่า บ่ามล่าง นู้ย้า กงามย้าง แงแน. ");
INSERT INTO bzi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ยาว พระเยซู อู่บเพ้ก เย นี้แม้แน, “ค่าพ่าย่า ทื่อม่าง ยา ชฺ้าง ปีนแตปีนนา เย. ยา อางเมิง อางเว่อ โย้เวอ ชา แล เย, ไม้ ก่าซ้าด ต้างแต่ง เพล่อ ปี่ชี่ แฮ้ง ลาบ แอง เย, ยาว เปิน เมอ พ่าว ล้า แล่ง. ");
INSERT INTO bzi_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ยาง ชา แอ เมอ ยางมือ ยาง ย่าเจ่น ทื่อแช่ คู่น อือนา ฮ้าว ล้า ปี่ ยาว พลู้ กามางกา ทื่อ มินา ปี่ ชี ยาว ม่า ชี นี้แม้แน, ‘ค่าม พลู้ นี้ง ฮ้าน ก่องก้า แอ โว กงา พ่าว ล้า แล่ เมอ เคอ’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","จ้า อางเมิง ชฺ้าง อือ ยางนา เม้อ คู เย. ยาว ยาง น่องน่อง เวอ ชฺ้าง เค่ แอ ปี่ ชีเย. ยาว นี้แม้แน ม่า ชีเย, ‘กงู นี้ มางนา กงู ก่าซ้าด บ่าเพล่อ ปี่ ซี่’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“จ้า น่องเวอ ยาง ก่าซ้าด กงาเพล่อ ยาว พ่าวล้า นาว. ยาง ย่าเจ่น ค่าม พลู้ ปี่ ชี อือนา ฮ้าว อ้องล้า ปี่ น้าว, ไม้ ยา แบ ซี้ง เย ยอ อาล้อ แน ค่าม พลู้ ก่องก้า กงาย ชี แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ยาว ย่าเจ่น ทื่อม่าง มาง เคอ ลือ เมอ ม่า เย นี้แม้แน, ‘เจ้านาย เวอ, นาง พลู้ ทื่อ มินา ย้าง กงา ก่องก้า ยาว พลู้ ทื่อแช่ มินา กงา แอ’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ก่าซ้าด มาง ยางนา โญกจ่าญ่อ จ่าง เย นี้แม้แน, ‘อางแม่น อี้ นา ย่าเจ่น อางแม่น, อางเลิ่ง อางอี อืม นืงบาอางชี กงากา! กงา นางนา อางเมิง ทื่อแช่ เมิง แฮ้ง ฮูพลา ปี่ ล่าว่า!’ ");
INSERT INTO bzi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ยาว ย่าเจ่น ทื่อม่าง มาง อ้อง ลาน ยาว ม่า เย นี้แม้แน, ‘ก่าซ้าด เวอ, นาง พลู้ ทื่อ มินา ย่าง กงา ก่องก้า พลู้ 5 มินา กงา แอ’ ");
INSERT INTO bzi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ก่าซ้าด มาง ย่าเจ่น มางนา ม่า เย นี้แม้แน, ‘กงา นางนา อางเมิง 5 เมิง ฮูพลา ปี่ ล่าว่า’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“จ้า ย่าเจ่น ทื่อม่าง มาง อ้องล้าน ยาว นี้แม้แน ม่าย ชีเย, ‘ก่าซ้าด เวอ, นี้ย่า นาง พลู้ ทื่อ มินา ย่าง กงา นาง พลู้ ย่าง พ้า ท้าว ชี แอ แม่น ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ไม้ กงา นาง อางโซ้ก แฮ้งนา แค คา. แน นา ฮาก อางเกิ่งอางก้อ ย่าดยู้ อางคา, แน นา อางคลาอางซ้าง นาง บ่ากงา คลา แฮ้ง ย่าดยู้ อางคา’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“ยาว ก่าซ้าด มาง นี้แม้แน อี่ ชีเย, ‘ย่าเจ่น บ่าแม่น กงา นางนา โตดลาบ ปี่ ล่าแน, นาง จี่ แฮ้งแม้แน ย้า. กงา ชฺ้าง อางโซ้ก ฮาก อางเกิ่งอางก้อ ย่าดยู้ อางคา, แน ค่าตอง อางคลาอางซ้าง บ่ากงา คลา แฮ้ง ย่าดยู้ อางคา แน นาง อางแบ แน ยาว. ");
INSERT INTO bzi_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ท้าว บ้าเจอ พลู้ แฮ้ง ธนาคาร โย้เวอ บ่าชี แล แน. กงา พ่าวล้า แล่เมอ พลู้ อางอ้าน แน คี้ดอก แฮ้ง กงา ปี่ แง’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“ยาว ย่าเจ่น จูง จา อือนา ม่าย ชี นี้แม้แน, ‘ยาง พลู้ จา นี้ง ชฺ้าง พลู้ ทื่อแช่ มินา จา มางนา ปี่ แอ โว!’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“ยอง จี่ เย นี้แม้แน, ‘ก่าซ้าด เวอ, ยางก้อง พลู้ ทื่อแช่ มินา ย้า จา แง.’ ");
INSERT INTO bzi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“ก่าซ้าด มาง ม่าย ชี นี้แม้แน, ‘กงา ม่ายแบ ปี่ ล่าว่า ชฺ้าง ยาง อางเกิ่ง จา แฮ้งนา แม่น แน ไจ อือย่า อางเกิ่ง กงา แล่แง. จ้า ชฺ้าง อางเกิ่ง อางอี จา แฮ้งนา แม่น แน บ่าไจ อือย่า เจิ้นเจ้อ บ่าจ่าน ล้า. ");
INSERT INTO bzi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ยาว ชฺ้าง กงานา เม้อ ล่าง อือ แน กงานา ก่าซ้าด บ่าปี่ เพล่อ ล่างอือ นา ชู แอ โว! ยาว กงา ล้าก้า นู้เวอ ชู แซ่ ล้า โว!’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","น่อง โย้เวอ อางเลิ่ง อู่บ เปิน ยาว พระเยซู เยรูซาเล็ม อางเมิง โย้เวอ แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","พระเยซู แน ศิษย์ อือ เยรูซาเล็ม อางเมิง โย้เวอ ชา เคอ แล เมอ, ยองมู แฮ้ง เบธฟายี ค่อง แน เบธานี ค่อง โย้เวอ เคิน แล คูชี. เบธฟายี ค่อง แน เบธานี ค่อง นี้ย่า มะกอกเทศ ตาแซ้ ท่า โย้เวอ ดื้ง แง. ยาว พระเยซู มือ ศิษย์ 2 คู่น ม่าง เย่ดนา ซฺาแล ปี่ ลางออน ซฺาแล ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","แน นี้แม้แน ม่า ชี, “ไน้ ล้าก้า โย้เวอ ค่อง แฮ้ค่อง ก้อง อ้องแลน โว. เคิน แล เมอ ลา อางย่า ทื่อม่าง ล่าตื่อ พือแล่ง จา นา มย้าง แง. ลา นี้มางนา อ่าซ่าง มาง บ่าตา กางซื้ง. ล่าตื่อ พือแล่ง ชี แฮ้ง พื้ยอ่อก ยาว กงาก้อง ชื้ง ล้าน โว! ");
INSERT INTO bzi_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","จาว่าแน ฮาก นี้แม้แน น้า ล่า เมอ, ‘ไน้ ลา นี้มางนา บ้าเจอล้อเกิ้ง ชา ซฺื่ย แอ แง?’ แน. ไน้ มือ นี้แม้แน พอ โว, ‘จี่วีดอางซื้ง ม้า ลา นี้มางนา ไจ ซี้ แง’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","เย่ด แอ ยาว พระเยซู ม่า ชี แม้แน ย้า มย้าง ชี. ");
INSERT INTO bzi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ยาว ลา อางย่า มางนา ล่าตื่อ พื้ออ่อก เมอ, ลา อางซื้ง มาง นี้แม้แน น้า ชี, “บ้าเจอฮาย ล่าตื่อ แฮ้ง พื้ออ่อก แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ยาว เย่ด พอ ชี นี้แม้แน, “จี่วีดอางซื้ง มางนา ตา ปี่ง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ยาว ศิษย์ มาง เย่ด ลา มางนา ชื้ง แล พระเยซู นา ปี่ น้าว, ยาว เย่ด ค่าลาว ย่าง ลา มาง ต่างค่าง เวอ ค่าง ชี. ยาว เย่ด พระเยซู นา ตา ปี่ น้าว. ");
INSERT INTO bzi_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","พระเยซู ลา มางนา ตา เมอ, ค่องช่าง อือ ค่าลาว ย่าง แก้บ้า เวอ ค่าง ชี. ");
INSERT INTO bzi_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","พระเยซู มะกอกเทศ ตาแซ้ แก้บ้า ต่องลีน โย้เวอ เคอ แล ยาว, ศิษย์ อางบย่า เย พาจาว มางนา โฮ้กฮ้าว สรรเสริญ ฮา คู แง, ยอง อางเลิ่งชฺ้างบ่าฮาตอกางอือ กงามย้าง ล้า ชี แฮ้ง ปาปาย. ");
INSERT INTO bzi_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ยาว ยอง มือ สรรเสริญ ฮา ชีเย นี้แม้แน, “จี่วีดอางซื้ง เวอ, ก่าซ้าด นาง ซฺา ลู่งลือ ปี่ ชี่ มางนา ก่ามป่อน ปี่ ปาว. กงู มู่งท่า โย้เวอ พาจาว กงูนา ฮาย จาบื่อดื้งบื้อ แน จาดื้ง ปี่ ล่าชี่ มางนา สรรเสริญ ฮา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","จ้า ฟาริสี มู อือ พระเยซู นา จี่ช่าง ชี นี้แม้แน, “อ่าจาน เวอ, นาง ศิษย์ อือนา แฮ้แม้ บ่าปี่ จี่ โจ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ยาว พระเยซู นี้แม้แน พอ ชี, “กงา ม่ายแบ ปี่ ล่าว่า ยอง โฮ้กฮ้าว แฮ้ง ว่าง เวิม ลอบา นี้อือ โฮ้กฮ้าว แต่น แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","พระเยซู เยรูซาเล็ม อางเมิง โย้เวอ ย่อ อ้องแล ยาว อางเมิง แฮ้งนา มย้าง ยาว อู้ง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ยาว จี่ เย นี้แม้แน, “กงา นองนา อางเลิ่ง อางจาอางดื้งบื้อ แฮ้ง ฮ้าน ปี่ ล่าง, ยาว บ้าเจอ นอ บ่าฮู มย้าง คูแน. ");
INSERT INTO bzi_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","โอ เยรูซาเล็ม อางเมิง เวอ, บ่ามล่าง ยาว, นางนา เม้อ ล่าง อือ นางนา รบ ล่าง. ยาว นาง ก้ามทื้อ โย้เวอ พย่า อ้องแล คูแง. ยาว นางนา แวด ชี ล่า คูง กู ปล่าก ย้า. ");
INSERT INTO bzi_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ยาว ยอ นางนา แน นาง อางย่า อือนา ก่างพยา ล่าง เจิ้นเจ้อ บ่าปี่ จ้าน ล้า. ยาว ยอ นาง อางเมิง แฮ้ง ก่างพยา ล่าง เจิ้นเจ้อ บ่าปี่ จ้าน ล้า, ไม้ พาจาว ม้า ฮาย มย้าง ปี่ ล่าง ญ้า, ยา นางนา ลากซื่งกง่ากย้า ล่าง แน จ้า นา บ่าตี่นบ่าต่อง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","พระเยซู โบสถ์อางฮื่อ กองโค้ง โย้เวอ อ้อง แลน ชี. ยาว ชฺ้าง โบสถ์อางฮื่อ กองโค้ง โย้เวอ อางเกิ่งอางก้อ ก่อง อือนา ก่าอ่อก แอ ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ยาว พระเยซู มือ นี้แม้แน จี่ ชี, “พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี, ‘กงา โบสถ์อางฮื่อ นี้ย่า ยู้มอธิษฐานฮาย้า แน ฮ้าว แง.’ จ้า นอ ค่าโม่ยค่ามโจน ยู้ม ฮาย เพล่อ ปี่ชี่!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","พระเยซู โบสถ์อางฮื่อ โย้เวอ กูนืง ย้า ม่าอู่บ แง. ยาว ปุโรหิต ยอคา อือ อางลี้บอางล่าว ม่าอู่บฮู อือ แน ยิวชฺ้าง ยอคา อือ, พระเยซู นา ชา แซ่ คูง. ");
INSERT INTO bzi_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","จ้า บ่าแซ่ ตอ กา เย, ไม้ ค่องช่าง อือ อางบย่า เย จา แง พระเยซู ม่าอู่บ แฮ้งนา อางซอ ยาว น้าจ่า คู แงแน. ");
INSERT INTO bzi_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ทื่อนืง จา ชีเย, พระเยซู โบสถ์อางฮื่อ โย้เวอ ชฺ้าง อือนา ม่าอู่บ จา เมอ แน อางเลิ่ง อางแม่น ป่าว เมอ, ปุโรหิต ยอคา แน อางลี้บอางล่าว ม่าอู่บฮู อือ แน ยิวชฺ้าง ยอคา อือ พระเยซู นา ซฺ้า ล้า คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ยอง น้า ชี นี้แม้แน, “นา อ่าซ่าง? นางนา อ่าซ่าง ล่าที่ ปี่ นี้แม้แน ฮา ปี่ ล่าง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ยาว พระเยซู จี่พอ ชี นี้แม้แน, “กงานา ม่า ล่า ปาโน. ");
INSERT INTO bzi_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ยอห์น ล้างตือพิธีบัพติศมา ฮา แฮ้ย่า, ยางนา อ่าซ่าง ล่าที่ ปี่ชี่. พาจาว มาง ปี่ ชี ลา, อ้าว ชฺ้าง อือ ปี่ ชี?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ยาว ยองมู แฮ้ง นี้แม้แน จี่ ลางกา ชี, “กงู ยางนา บ้าเจอล้อแม้แน พอ คูวา? จาว่าแน กงู ยางนา นี้แม้แน พอ ยาว, ‘พาจาว มาง’ แน. ยาง กงูนา นี้แม้แน น้า ล่า กาน้าอี่, ‘ท้าว นอ บ้าเจอฮาย ยอห์น นา บ่าเจ่อ คูแน?’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","จ้า กงู ยางนา นี้แม้แน พอ ยาว, ‘ชฺ้าง ก้อง จายล้า แง’ แน. ค่องช่าง อืม กงูนา ลอบา จาน แซ่ ล่า กาน้าอี่, ไม้ ค่องช่าง อือย่า ยอห์น นา พาจาวจี่ต่างจี่แต่นฮู แน เจ่อ คูง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","แฮ้งย้า ยอง พระเยซู นา นี้แม้แน พอ คูชี, “บ่าแบ ล้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","แฮ้งย้า พระเยซู มือ ยองนา นี้แม้ ม่า ชี, “นี้แม้แนยาว กงาม นองนา บ่าม่า ล่า, อ่าซ่าง กงานา ล่าที่ ปี่ นี้แม้ ฮา ปี่ ล่าชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","พระเยซู ค่องช่าง อือนา อางเลิ่ง อู่บ เพ้กน้า ปี่ ชี นี้แม้แน, “ค่าพ่าย่า ทื่อม่าง จา แง อ่างู่น โซน ว่า แง. ยาว โซนว่าฮู อือนา ว่าพ่าพ้า ปี่ ชี่, จ้า ยา อางเมิง อางเว่อ โย้เวอ มล่าง ย้า ดื้ง แล ชี. ");
INSERT INTO bzi_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","อ่างู่น ชู ญ่าม เคิน เมอ ยางมือ ยาง ย่าเจ่น ทื่อม่าง มางนา ไจ อ่างู่น แฮ้ง เปิ่ง ยู้ ล้า ปี่ชี่. จ้า ชฺ้าง โซนว่าพ่าพ้า คูชี อือย่า ย่าเจ่น แฮ้มางนา ชู ตื่อ คูชี, แน ก่า พ่าว แอ แล่ ปี่ชี่ ยางนา เจิ้นเจ้อ บ่าปี่ คู. ");
INSERT INTO bzi_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ยาว โซนซื้ง มาง ย่าเจ่น ทื่อม่าง ซฺาแอ แล่ ปี่ น้าว, โซนว่าพ่าพ้า คูชี อืม ย่าเจ่น แฮ้มางนา ตื่อชืก ฮาย ซฺ่าจอ ปี่ ชี่. ยาว เจิ้นเจ้อ บ่าปี่ อางแอ่ แน พ่าว แล แล่ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ยาว โซนซื้ง มาง ย่าเจ่น ทื่อม่าง ซฺาแอ แล่ ปี่ น้าว, โซนว่าพ่าพ้า อืม อางอ้าน แม้แน ฮาย แล่ ชีเย. ย่าเจ่น มางนา ฮาย ด้า ปี่ ยาว โซน อางเง้ เวอ ลาม วี แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“ยาว อ่างู่น โซนซื้ง มาง ค่าตอง นา ม่า จ่าแล่ง เย นี้แม้แน, ‘บ้าเจอ แม้ฮาย วา แน? ออ! แบคายา ล้อแม้ ฮา แงแน, กงาย่า กงา อางย่าย่าค่า ลาก มางนา ซฺาแอ ปี่ แน. โซนว่าพ่าพ้า อือ กงา อางย่าย่าค่า มางนา อางน้า จ่า นาตู้’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“จ้า ชฺ้าง โซนว่าพ่าพ้า อือ โซนซื้ง มาง อางย่า มาง ลือ นา มย้าง คู ยาว ยองมือ นี้แม้แน ม่า ลางกา ชี, ‘ฮู ปาว ชฺ้าง นี้ม้า โซนซื้ง อางย่าย่าค่า ม่าง ย้า. กงู ยางนา ปล่อง แซ่ กาเซฺ้อ, อ่างู่น โซน นี้ง กงูเฮอ เพล่อ คาไล!’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","แฮ้งย้า ชฺ้าง โซนว่าพ่าพ้า คูชี อืม ยางนา ชู แซ่ ยาว อ่างู่น โซน อางเง้ โย้เวอ ลาม วี แอ ชี.” ยาว พระเยซู มือ ยองนา นี้แม้แน จี่ช่าง ชี, “นอง เย้ง กาน ยาว โซนซื้ง ม้า บ้าเจอล้อแม้ ฮา แง? ");
INSERT INTO bzi_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ยา ชฺ้าง โซนว่าพ่าพ้า คูชี อือนา ล้าย แซ่ ล้ายาว อ่างู่น โซน แฮ้ง ฮากนา ว่าพ่าพ้า ปี่ง ลา?” ชฺ้างมู อือ แฮ้แม้ กงากย่า ยาว นี้แม้แน จี่ คู ชีเย, “แฮ้แม้ บ่าปี่ เพล่อ โจ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","จ้า พระเยซู ยองนา ฮู ยาว นี้แม้แน จี่ ชีเย, “นี้แม้แนยาว พระคัมภีร์ โย้เวอ แต้ม ชี ชี แฮ้ บ้าเจอ นา ฮา แง, พระคัมภีร์ โย้เวอ นี้แม้แน แต้ม ชี ชี, ‘ยู้ม ซ้าล้า อือ ยู้มยื้ง วี ชี นี้ยื้ง น่อง โย้เวอ เสาเอก เพลิ่น ชี’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“ชฺ้าง ยู้มยื้ง แฮ้ ยื้ง ก้อง เลิง เง่ คูชี อือ อางโต แฮ้ อางต่อน ต่อน ย้า เคลิก แง. จ้า ยู้มยื้ง แฮ้ ยื้ง อ่าซ่าง นา กลา เง่ แง, แฮ้ม้า ปล่าก บืนล้าว แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ยาว อางลี้บอางล่าว ม่าอู่บฮู อือ แน ปุโรหิต ยอคา อือ แบน ชีเย พระเยซู จี่ เพ้ก แฮ้ ยองนา จี่ แง, ยอย่า ชฺ้าง โซนว่าพ่าพ้า อือ ป้าค้า แม้แน เพล่อ ชี แน. แฮ้งเย่ ยอง พระเยซู นา ชา ชู คูแง. จ้า บ่าชู จอ กา เย, ไม้ ค่องช่าง อือนา แค เย. ");
INSERT INTO bzi_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ยอ พระเยซู นา ค่าว ฮู คู แง, ยาว ชฺ้าง อางแม่น จ้างจ่าแล่ง อือนา ซฺาแล ปี่ ชีเย, ไม้ พระเยซู จี่ต่าง แฮ้ง อางซี ชู เย. ยาว พระเยซู นา ชู ผู้ว่า มางนา ปี่ แล เย. ");
INSERT INTO bzi_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ยาว ชฺ้าง อางเลิ่งอางลาบอางโชง ค่าว ฮู กว่า อือ พระเยซู นา น้า ชี นี้แม้แน, “อ่าจาน เวอ, กงู อางแบ นา อางเลิ่ง อางกง่าอางเกิง อือ ม่าอู่บ แงแน. แน อ่าซ่าง มางนา แมก่า บ่าชี่ แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","กงูนา ม่า ล่าว แล, ก่าซ้าดยอคา ซีซาร์ นา ภาษี ฮู่ ปี่ นี้ย่า อางกง่าอางเกิง ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ยาว พระเยซู ยอง จ้อบน้า แงแน อางแบ แฮ้งย้า ม่าย ชี นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“พลู้ ทื่อ เหรียญ ล้า ปี่ ล่าวแล. ยาว นี้ อ่าซ่าง อางฮูบ เวอ? ยาว อ่าซ่าง อางเม้ง แต้ม กาน ชี” แน. ยาว ยอง ม่าย ชีเย, “ก่าซ้าดยอคา ซีซาร์” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ยาว พระเยซู นี้แม้แน จี่ ชีเย, “ซีซาร์ อางเกิ่ง นี้ย่า ซีซาร์ นา ปี่ ปาว, พาจาว อางเกิ่ง นี้ย่า พาจาว มางนา ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ยาว ยองมู แฮ้ง ฮาก ล้าก้า เวอ พระเยซู จี่ต่าง นา อางซี บ่าชู กงากา เย, จ้า ยองมู แฮ้ พระเยซู จี่ แฮ้งนา กงากย่า ยาว, นืงบาม่าน เจิ้นเจ้อ บ่าจี่อ่อก กา เย. ");
INSERT INTO bzi_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","สะดูสี มู ชฺ้างซฺี้ ยาว บ่าแต่ล้า แล่ กงากา แน เจ่อ อือ พระเยซู นา น้า คูง เย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“อ่าจาน เวอ, โมเสส ย่า กงูนา ม่า ล่าง นี้แม้แน, ‘ค่าพ่าย่า ล้อมาง อางย่า บ่าจา แน ซฺี้ ยาว ยาง อางแพ้ มางมือ อางอ้าย มาง ค่าบา มางนา ยู้ แง. ยาว อางย่า กงา ยาว อางอ้าย มาง อางเจ้อ แฮ้ง ซื้บแล ปี่ แง.’ ");
INSERT INTO bzi_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","นี้เทอ เวอ ม้องน้าม 7 คู่น จา แง. อางอ้าย ซากาว มาง ค่าบา ยู้ ยาว, อางย่า บ่าจา กื้ง แน ซฺี้น ชี. ");
INSERT INTO bzi_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ยาว อางแพ้ ที่ 1 มาง แมม้าย มางนา ยู้ น้าว, จ้า ยา อางย่า บ่าจากื้ง แน ซฺี้น ชี. ");
INSERT INTO bzi_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ยาว อางแพ้ ที่ 2 มาง แมม้าย แฮ้มางนา ยู้ น้าว, จ้า ยา อางย่า บ่าจากื้ง แน ซฺี้น ชี. นี้แม้แนยาว ม้องน้าม 7 คู่น นี้อือย่า ค่าบาย่า แฮ้มางนา ยู้ ยาว อางย่า บ่าจากื้ง แน ซฺี้น คูชี. ");
INSERT INTO bzi_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","น่องเวอ ค่าบาย่า มาง ซฺี้ กา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ยาว ม้องน้าม 7 คู่น นี้อือ แต่ล้า แล่ แฮ้นืง ค่าบาย่า นี้ม้า อ่าซ่าง ค่าบา เพล่อ แง? ไม้ ยา ม้องน้าม 7 คู่น คาโคลาโค นี้อือ ค่าบา เพล่ออ่าน น่อ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","แฮ้งเย่ พระเยซู นี้แม้แน พอ ชี, “ชฺ้างอางเมิง นู้เวอ ชฺ้าง อืนญา ยู้ซฺ้า อางบี่อางบล้อง เพล่อ กา แง. ");
INSERT INTO bzi_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","จ้า ชฺ้างซฺี้ ยาว แต่ล้า แล่ คูชี อือ แน มู่งท่า โย้เวอ ซู้ม แน กงาดื้ง อือย่า บ่ายู่บ่าซฺ้า กา. ");
INSERT INTO bzi_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ยอ ทื่อเทอ ซฺี้ แล่ง แน บ่าจา กาน, จ้า ยอ เท่วาด่า แม้แน เพล่อ แง, ไม้ พาจาว ม้า ยองนา แต่ล้า แล่ ปี่ง. แน ยองนา พาจาว อางย่า เพล่อ ปี่ แง.” ");
INSERT INTO bzi_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“ซ้ามบ้า โมเสส มือ ซฺี้ ยาว แต่ล้า แล่ อางเลิ่ง แฮ้งนา เจ่อ แง. ไม้ โมเสส ยาง จฺืงจฺื้งปาว บี่ท่ออางจฺ่อ อางเลิ่ง แฮ้ง แต้ม เมอ, ยา พาจาว มางนา นี้แม้แน ฮ้าว แง, ‘อับราฮัม, อิสอัค แน ยาโคบ ยอง พาจาว มาง ย้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","พาจาว นี้ม้า ชฺ้างซฺี้ อือ พาจาว บ่าอ่า, จ้า ชฺ้าง อางแต่ อือ พาจาว, ไม้ พาจาว ม้า ชฺ้าง คาโคลาโค อือนา จี่วีด อางจา แน ทื้อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ยาว อางลี้บอางล่าว ม่าอู่บฮู ทื่อบ่า อือ พระเยซู นา โญกจ่าญ่อจ่า แง นี้แม้แน, “อ่าจาน จี่ นี้ย่า นาบาตา ย้า แม่น แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ยาว อ่าซ่าง มาง พระเยซู นา เจิ้นเจ้อ บ่าน่าจอ แล่เย่. ");
INSERT INTO bzi_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","พระเยซู ยองนา นี้แม้แน น้า ชีเย, “นอ บ้าเจอ นี้แม้แน อางจี่ แน, ชฺ้าง พาจาว มาง แช้ ก่าซ้าด เพล่อ ปี่ชี่ ม้า, ก่าซ้าด ดาวิด อางอ่านอางซฺื้อ มาง แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ก่าซ้าด ดาวิด สดุดี ปาบ โย้เวอ นี้แม้แน แต้ม ชี ชี, ‘พาจาว ม้า ยาง ชฺ้าง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้มางนา, แน กงา จี่วีดอางซื้ง เพล่อ ชี แฮ้มางนา นี้แม้แน จี่ช่าง ชี, กงา ล่าปู่ ล่าม่า นี้กย้า ดื้ง ลื่อ ปาว. ");
INSERT INTO bzi_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","กงา ชฺ้าง นางนา เม้อ ล่าง อือนา ฮาย นาง ล่าคื่อโบ้ยย้า เพล่อ ปี่ เมอ ตื่อเคอ แน.’ ");
INSERT INTO bzi_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“ซ้ามบ้า ก่าซ้าด ดาวิด มือ พาจาว มาง ชฺ้าง แช้ยู้ ยาว ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้มางนา นี้แม้แน ฮ้าว แง, ‘กงา จี่วีดอางซื้ง มาง’ แน. นี้แม้แนยาว พาจาว มาง ชฺ้าง แช้ยู้ ยาว ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้ม้า ก่าซ้าด ดาวิด ก้อง อางเจ้อ ซื้บล้า ชี. จ้า ยา ก่าซ้าด ดาวิด ล่อบ่าปา ฮื่อ แล่ง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ค่องช่าง อือ น้า จา เมอ, พระเยซู ยาง ศิษย์ อือนา นี้แม้แน จี่ช่าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“อางลี้บอางล่าว ม่าอู่บฮู นี้อือนา แม่น แน อางโต แล่ม แล่ โว! ยองมู นี้ย่า คู่ ค่าลาวอางเง้โลบแล่เซฺ่อ อือ ตูม แล่ ยาว, ก้าด อือเมอ ย่อกว่า นา อางซอ คู, ไม้ ฮากนา ยองนา ล่าปู่ โญกไว้ ปี่ง แนนอ. จฺ่าปอต้างปอ โย้เวอ แอ เมอ, แน ยิวชฺ้าง โบสถ์ คล้าว โย้เวอ อ้อง ไว้ แล เมอ, ยองมู นี้ย่า ดื้งย้า ปีนแตปีนนา เลิ่นเลิ่น เวอ ดื้ง นา อางซอ คู. ");
INSERT INTO bzi_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ยอ แมม้าย อือ ยู้ม แฮ้ง ย่าด ยู้ ปี่ง, ยาว มล่าง แน อธิษฐาน ฮา แง ไม้ ชฺ้าง อือนา โอ่ด แง แนนอ. ยาว ชฺ้าง นี้อือ ชฺ้าง อางเลิ่ง นี้แม้แน บ่ากงา ฮา อือ ล่อบ่าปา วี่บ่ากกงาไจ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","พระเยซู ชฺ้าง อางจาอางปาง อือ โบสถ์อางฮื่อ โย้เวอ อางฮี้บ เวอ พลู้ กาน นา มย้าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ยาว ยางมือ แมม้าย อางตูกอางพาน ทื่อม่าง อางฮี้บ เวอ พลู้ 2 สลึงค์ กาน นา มย้าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","พระเยซู จี่ เย นี้แม้แน, “กงา ม่ายแบ ปี่ ล่าว่า, แมม้าย นี้มาง พลู้ ท่าน นี้ย่า ฮาก ล่อบ่าปา บย่า แงแน, ");
INSERT INTO bzi_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ไม้ ฮาก พลู้ ท่าน นี้ย่า ยอง พลู้ ไจ จ้านล้า ชีย้าง เป. จ้า แมม้าย นี้ม้า นาบาตา ตูก เวิม, ยาง พลู้ คาโคลาโค ฮ่าง จฺ่าเกิ่ง วื้อ จฺ่าเซฺ่อ ย่าง ท่าน ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ศิษย์ ทื่อบ่า อือย่า โบสถ์อางฮื่อ อางมาง นี้ง แน อางเกิ่งอางก้อ ท่าน ชี อือนา จี่อู้ กาง เย, แน ลอบา กูซื่อ โบสถ์อางฮื่อ ไจ แต่ง ชี แฮ้งนา นาบาตา มาง แน จี่ เคอ คูง. ยาว พระเยซู จี่ เย นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“คาโคลาโค นอง มี้นืง มย้าง นี้ย่า, ทื่อนืง บ่าอ่ายาว ทื่อนืง ย้า ก่างพยา ปู่งกลา ลือ แง เจิ้นเจ้อ บ่าจ่าน ล้า, ลอบา ตาก ลางกา ชี นี้ย่า เลิง พู่นพ่าน แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ยาว ยอง น้า ชี นี้แม้แน, “อ่าจาน เวอ, นี้เลิ่ง อ้าล่อม ตอล้า แง? ยาว ล้อแม้ แบ แน นี้เลิ่ง ตอล้า นี้ย่า แท้ ล้าน ญา?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ยาว พระเยซู มือ พอ เย นี้แม้แน, “อางโต แล่มจ่าแล่ คูโว! อ่าซ่าง มางนา บ่าปี่ จ้อบ ปี่ คู โจ เป, ไม้ ชฺ้างอางบย่า ย้า กงา อางเม้ง แฮ้ง จี่อ้าง จ่าแล่ง แง, ยอย่า พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ ชี่ มาง แน ฮาจ่าแล่ คูแง, แน ยอ นี้แม้แน ม่า แล่ ล่าง, ‘อางญ่าม เคอ ญา’ แน. จ้า ยองนา บ่าเจ่อ โจ! ");
INSERT INTO bzi_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","นอง สงคราม ตอล้า ชี แน กงากย่า ยาว แน ชฺ้าง อือ ซืกซาก คู ยาว บ่ากงา แค คา. จาว่าแน นอง สงคราม อางเซง กงากย่า เมอ, บ่าอ่ายาว สงคราม ตอล้า ชี แน กงากย่า เมอ บ่าแค คูโจ, ไม้ แฮ้แม้ ม้าม้า ย้า ตอล้า แง. จ้า นี้เลิ่ง ตอล้า เมอ ชฺ้างอางเมิง ลีน ย้าง บ่าอ่า เป. ");
INSERT INTO bzi_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“ชฺ้าง ไลเจ้อไลจาด ย้า แซ่ กาง, อางเมิง ไล เมิง ย้า แซ่ กาแง. ");
INSERT INTO bzi_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ชฺ้างอางเมิง นู้เวอ กูต่องกูตี่ ย้า มี่ซี่อืน แง. แน ฮ่าง จฺ่าเกิ่ง เคม แง. ยาว พ่าญาด อางไล้ ตอล้า แง, อางเลิ่ง แค คาบอล้อ ตอล้า แง, ยาว มู่ง โย้เวอ ม้างม้าเจ้อ บ่าตอล้า กาซื้ง อือ อางบย่า ย้า ตอล้า แง. ");
INSERT INTO bzi_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“จ้า นี้อือเจ้อ ชา ตอล้า เมอ, นองนา ฮาก ชู คาม ล่า เปิน แง, แน ยิวชฺ้าง โบสถ์ โย้เวอ ซฺื่ย แอ ล่าง, แน คอก ชู ล้อง ล่าง. ยาว ก่าซ้าด แน ผู้ว่า อือ ล้าก้า โย้เวอ น้าท้าม ล่าง, ไม้ น่อ กงา ศิษย์ น้อ. ");
INSERT INTO bzi_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ยาว นี้ย่า นอง อางญ่าม อางแม่น ย่าง ย้า, กงา อางเลิ่ง แฮ้ง ยองนา จี่ น้า ปี่ นี้. ");
INSERT INTO bzi_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ยาว นอ บ่ากงาแคคา ล้อแม้ จี่ วา แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","กงา นองนา วี่ไซ้ป้านญา ปี่ ล่าว่า แน จี่ต่าง อางทา แฮ้ง ปี่ ล่าว่า, ชฺ้าง นองนา เม้อ ล่าง อือ กงากย่า ยาว นองนา บ่าอี่ ล่า กงากา. ");
INSERT INTO bzi_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","นางก้อง แท้ แน จา อือ ทื่อช่างกานญา, อางบา อางโบ้ง ม้องน้าม แน อ่างช่าง อือ, นางนา น่อง เวอ บ่าแม่น ฮา ล่าง. ยาว นองมู เวอ ทื่อบ่า อือนา แซ่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ยาว ชฺ้าง คาโคลาโค อือ นองนา เม้อ ล่าง, ไม้ นอง กงานา เค่ ล่างนี้ง ปาปาย. ");
INSERT INTO bzi_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","จ้า บ่ากงา แค คา, ไม้ ยองมู นี้ย่า นองนา เจิ้นเจ้อ อางไล้ บ่าฮา ล่า. ");
INSERT INTO bzi_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ยาว โอ้ด ชี คูโว, ยาว นอ จี่วีดม้าม้า กงา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“นอง ตาฮ้าน อางมู เยรูซาเล็ม อางเมิง เวอ แวด จา นา มย้าง ยาว, แบ คู โว เยรูซาเล็ม อางเมิง นี้ย่า ชา ก่างพยา ญา แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","แฮ้แม้แนยาว ชฺ้าง ยูเดีย แควน เวอ ดื้ง อือย่า, อางไว่ แน ตาแซ้ ท่า โย้เวอ ฮื่น แล โว! นอง เยรูซาเล็ม อางเมิง โย้เวอ ดื้ง ยาว, อางไว่ แน อางเมิง อางเง้ โย้เวอ อ่อกแอ โว! ชฺ้างอางเมิง อางเง้ เวอ ดื้ง อือ อางเมิง คล้าว โย้เวอ บ่าอ่อง แล โจ! ");
INSERT INTO bzi_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ไม้ แฮ้นืง เยรูซาเล็ม อางเมิง แฮ้งนา วี่บ่ากไจ ปี่ ย่าง เป, ไม้ กูเจ้อ นี้ ม้าม้า แน เพล่อ แง พระคัมภีร์ โย้เวอ แต้ม ชี ชี แม้แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","อางญ่าม แฮ้ญ่าม ย่า ชฺ้างอู่ปู่ม แน ชฺ้าง อางย่า อือนา ลองแปด ชู่ ปี่ง อือ อางญ่าม แคคาบอล้อ แน ชี่ ย่าง ย้า, ไม้ โย้เวอ อางเลิ่ง บ่าแม่น ตอล้า แง. ไม้ พาจาว มาง อิสราเอลชฺ้าง นี้อือนา วี่บ่ากไจ ปี่ง นอ. ");
INSERT INTO bzi_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ไม้ ยองนา มยา แจ แซ่ แง, แน ฮาก อางเจ้ออางจาด ชฺ้าง อือ เชลย เพล่อ แง. ฮาก อางเจ้ออางจาด อือ เยรูซาเล็ม อางเมิง โย้เวอ อ้องแล ก่างพยา แล คูแง. พาจาว มาง อางญ่าม ซฺ้า ชี ชี แฮ้นืง ตื่อ เคอ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“มู่งนื่ง แน อู่ลา อู่กื่อ อือก้อง ม้างม้าเจ้อ บ่าตอล้า กาซื้ง อือ ตอล้า แง. ยาว ชฺ้างอางเมิง นู้เวอ ชฺ้าง ไลเจ้อไลจาด อือย่า แค คูแง, แน ทะเล ล้างฮ้าด อางคา อางเซง แฮ้ง กงากย่า คู ยาว ซืกซาก คูแง. ");
INSERT INTO bzi_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ยาว ชฺ้าง อือ ปางปี เพล่อ เลิง แล่ คูง, ไม้ ชฺ้างอางเมิง นู้เวอ อางเลิ่ง ชา ตอล้า นี้ง แค เย. ยาว กูย่างกูเจ้อ มู่งท่า โย้เวอ จา อืมมือ ยืก แง. ");
INSERT INTO bzi_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ยาว ชฺ้าง อืม กงาชฺ้างอางย่า เพล่อ ชี่ มางนา มย้าง แง, กงาย่า มู่งบื่น อางป่อน โย้เวอ ทื่งกง่า แน ลือ แง, แน กงาก้อง ล่าที่ อางฮื่อ ปลื้ง ย้า จา แง. ยาว กงา อางโต โย้เวอ อางแปล้นอางซ้า อ่อกล้า แง. ");
INSERT INTO bzi_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","อางเลิ่ง นี้อือ ต่องก่า ต้าง ตอล้า เมอ นองมู นี้ย่า ทา ฮู ล้า คูโว, ไม้ อางเลิ่ง นี้อือ ตอล้า ชี นี้ย่า นองนา แบ ปี่ ล่าง. พาจาว ม้า ชา ลือ นองนา อางบล่าบ ปล่องปูน ปี่ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","พระเยซู อางเลิ่ง อู่บเพ้ก น้า ปี่ น้าว นี้แม้แน, “นองมู ซื่อไค่มี้ล่อก แน ม้างม้าเจ้อ จฺื้ง อือนา มย้าง เมอ. ");
INSERT INTO bzi_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ยอง อางพ่า แฮ้ง พลอง อ่อก ล้า นา มย้าง ยาว, นอง อางแบ ล้องมย้า ชา เคอ กาชา แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","จ้า นอง กงา กูเจ้อ จี่ ชี ชี แฮ้ง ตอล้า ชี แน มย้าง เมอ. นอง แบ ชี คู โว, พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด ลือ เพล่อ ลืง ย่าง ชา เคอ ญา แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","กงา ม่ายแบ ปี่ ล่าว่า, อางเลิ่ง คาโคลาโค นี้อือ ตอล้า เมอ, อามือชฺ้าง อือ บ่าซฺี่ โค กางซื้ง แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","มู่งท่า แน ชฺ้างอางเมิง นี้ย่า โปยว แอ แง. จ้า กงา จี่ต่าง นี้ย่า โปยว แอ นืง บ่าจา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“แม่น แน แล่ม แล่ โว! จฺ่าต้าง แต่ค่าม่าว ช้อน กาง อางเลิ่ง แฮ้ง แอ่ แน บ่าเย่ง คูโจ! แน จี่วีด อางเลิ่ง แฮ้ง แอ่ แน บ่าเย่ง ดื้ง โจ! ไม้ นี้แม้ เย้ง ยาว แฮ้นืง ย่า บ่าแบจ่าแล่ แน เคอ ล้า แง. ซ้าด นา ค้าม เซฺ่อ ค้ามเพ่ก แม้แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","อางนืง แฮ้นืง ย่า ซฺ้อก ย้า ชฺ้างอางเมิง นู้เวอ ชฺ้าง คาโคลาโค อือก้อง เคอ ลือ แง. ");
INSERT INTO bzi_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","กูญ่าม แน แล่มจ่าแล่ว, ยาว อธิษฐาน ฮา โว ม้างม้าเจ้อ ชา ตอ นี้ง ปูน ปี่ โว, แน ยาว ชฺ้างอางย่า มาง ล้าก้า โย้เวอ กงา จูง ปี่ ล่าว เจิ้นเจ้อ นา บ่าซ่าจอ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ยาว พระเยซู มือ โบสถ์อางฮื่อ คล้าว โย้เวอ กูนืง ย้า ม่าอู่บ แง, ยาว มะกอกเทศ ตาแซ้ โย้เวอ กู คี่ ย้า ยู่ แง. ");
INSERT INTO bzi_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ยาว ค่องช่าง อืม ด่า ย้า ทานล้า ยาว, พระเยซู โบสถ์อางฮื่อ โย้เวอ ม่าอู่บ แฮ้ง น้า ล้า คูแง. ");
INSERT INTO bzi_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ปัสกาป่อย ญ่าม นี้ย่า อางเม้ง ทื่อเม่ง จา แล่ง ค้านู้มป่างอางเจ้อบ่ากานจฺ่าญ่าม แน. ยาว ปัสกาป่อยนืง ชา เคอ เมอ. ");
INSERT INTO bzi_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ปุโรหิต ยอคา แน อางลี้บอางล่าว ม่าอู่บฮู อือ พระเยซู นา ชา แซ่ เย, จ้า ยอ ค่องช่าง อือนา แค เย. ");
INSERT INTO bzi_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ยูดาส อิสคาริโอท ศิษย์เอก 12 คู่น เวอ ทื่อม่าง มางนา ซาตานแด่ย่ายอคา มาง อ้อง ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ยาว ยูดาส มาง ปุโรหิต ยอคา แน ตาฮ้าน ยอคา โบสถ์อางฮื่อ ล่อ อือก้อง แอ ชี, ยาว ม่า ชี พระเยซู นา ปล่อง ชู ปี่ ล่าว่า แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ยาว ยอง นาบาตา เย กย่าง แง, ยาว ยูดาส นา ม่าย ชี พลู้ ปี่ ล่าว่า แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","แฮ้งเย่ ยูดาส มือ อางญ่าม ซฺ้า ยาว ค่องช่าง บ่าบย่า แน ฮา เมอ พระเยซู นา ชา ชู แง. ");
INSERT INTO bzi_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ปัสกาป่อยนืง เคอ ยาว, แฮ้นืง ย่า ยอ แกะอางย่า แซ่ จฺ่า คู แง. ");
INSERT INTO bzi_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ยาว พระเยซู เปโตร แน ยอห์น นา ม่า ชี นี้แม้แน, “ปัสกาป่อยนืง นู้ กงู จฺ่าเซฺ่อ นี้ย่า อางด่าอางกื้ง แน ซฺ้า ชี โว.” ");
INSERT INTO bzi_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ยาว เย่ด น้า เย นี้แม้แน, “เกิ้ง ซฺ้า ชี วา แน?” ");
INSERT INTO bzi_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","พระเยซู จี่พอ ชี นี้แม้แน, “อางเมิง คล้าว โย้เวอ อ้องแล โว, ยาว ไน้ ค่าพ่าย่า ทื่อม่าง อู่ล่อง มอนาม ป่า นา มย้าง ยาว, ยางก้อง เค่ แล ยู้ม ทื่อลาง โย้เวอ อ้องแล โว. ");
INSERT INTO bzi_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ยาว ยู้ม อางซื้ง มางนา น้า โว นี้แม้แน, ‘อ่าจาน ม้า ม่า น้า ปี่ ล่าง ปัสกาป่อยนืง เวอ จฺ่าเกิ่ง ดื้งจฺ่าย่า อางฮ้อง ย่าง ล้อเกิ้ง เวอ?’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ยาว ยาง ไน้นา อางท่า โย้เวอ อางฮ้อง อางฮื่อ แม่น แน แต่ง เปิน ชี โย้เวอ ซฺื่ยซฺา แล ล่าง, ยาว แฮ้ฮ้อง ก้อง จฺ่าเกิ่ง ซฺ้า ชี โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","เย่ด แลน ชีเย, ยาว พระเยซู ม่า ชี แม้แน ย้า เพล่อ ล้า ชี. เย่ด มือ ปัสกาป่อยนืง จฺ่าเกิ่ง ย่าง ซฺ้า ชี นาว. ");
INSERT INTO bzi_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ปัสกาป่อยนืง มู่งคี่ฮ่างจฺ่าญ่าม เคอ ยาว, พระเยซู มือ ยาง ศิษย์ อือก้อง ทื่งกง่า แน ฮ่างเพิ่น โย้เวอ ฮ่าง ดื้ง จฺ่า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ยาว พระเยซู จี่ เย นี้แม้แน, “กงา ปัสกาป่อยนืง จฺ่าเกิ่ง นี้ง นองก้อง ทื่งกง่า แน จฺ่า ซี่ง แง, กงา ลาบ้าบ อางนืง แฮ้ง บ่าเคอ กาซื้ง นู้. ");
INSERT INTO bzi_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","กงา ม่ายแบ ปี่ ล่าว่า, กงา ปัสกาป่อยนืง จฺ่าเกิ่ง นี้ย่า บ่าจฺ่า แล่ก้าน. พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ แฮ้นืง ตื่อเคอ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ยาว พระเยซู ลอค่อ ย่าง โญก แล่ ยาว พาจาว มางนา ขอบคุณ ฮา ชี, ยาว จี่ เย นี้แม้แน, “ลอค่อ นู้เวอ อ่างู่น แต่ค่า นี้ง เปิ่ง ต้าง คู โว. ");
INSERT INTO bzi_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","กงา อางเลิ่ง แฮ้ง ม่ายแบ ปี่ ล่าว่า, กงา อ่างู่น แต่ค่า บ่าต่าง แล่ก้าน. แฮ้นืง เคิน เมินญา กงา อ่างู่น แต่ค่า ทื่อเทอ ต้าง แล่แง. แน แฮ้นืง พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ อางนืง ย่าง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","พระเยซู มือ ค้านู้มป่าง แฮ้ง กอ ท่าม แล่ชี่. แน พาจาว มางนา ขอบคุณ ฮา ชี. ยาว ยาง ค้านู้มป่าง แฮ้ง ชีด ศิษย์เอก อือนา เปิ่ง ปี่ ชี. ยา นี้แม้แน จี่ แง, “จฺ่า ปาว นี้ย่า กงา อางโต ย่าง ย้า นี้แม้ ฮา นี้ย่า กงานา ปื้อ ซฺ้า ล่าว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ยาว ยองมู ย่าง มู่งคี่ฮ่างจฺ่า เปิน ยาว, พระเยซู มือ ลอค่อ ย่าง โญก คื้น แล่ยาว พาจาว มางนา ขอบคุณ ฮา ชี ยาว จี่ เย นี้แม้แน, “นี้ย่า กงา ซฺี่ เซฺ่อ อ่อก ล้า ปี่ง ย้าง ย้า, ไม้ ชฺ้าง อางบย่า อือนา อางบล่าบ ปล่องปูน ปี่ง แนนอ. แน ซฺี่ นี้ย่า พาจาว มาง ก่ามค่าน อางซฺื่อ โย้เวอ อางช่า ย่าง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","พระเยซู จี่ เย นี้แม้แน, “ชฺ้าง กงานา น่อง เวอ บ่าแม่น ฮา ล่าง ม้า นู้ ย้า ดื้ง จา แง. ");
INSERT INTO bzi_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ยาว กงาชฺ้างอางย่า เพล่อ ชี ม้า กงาซฺี้ แง พาจาว มาง ม่า ชี แม้แน, จ้า ชฺ้าง กงานา น่องเวอ บ่าแม่น ฮา ล่าง แฮ้มางนา พาจาว มาง ต้าดต่อน วี่บ่ากไจ ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ยาว ศิษย์ อือ นี้แม้แน น้า กาง เย, “อ่าซ่าง เวอ นี้แม้ ฮา ม้า?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ยาว ศิษย์ อือ จี่เจ้ กา เย, กงู มู นู้เวอ อ่าซ่าง ฮื่อ เลิ่นเลิ่น แง? แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ยาว พระเยซู ม่า ชีเย นี้แม้แน, “ชฺ้างอางเมิง นู้เวอ ก่าซ้าด อือ ชฺ้าง อือนา เค้ อางคา, แน ชฺ้าง ล่าที่ อางจา อือย่า ค่องช่าง อือนา ยองนา ฮ้าว ปี่ แง นี้แม้แน, ‘ยอ ค่องช่าง อือนา จองไจ ฮา ปี่ อือย้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","จ้า นอ แฮ้แม้ บ่าเพล่อ โจ, นองมู นู้ ชฺ้าง ปีนแตปีนนา อางฮื่อ เลิ่นเลิ่น เพล่อ ม้า, ย่าเก ปีนแตปีนนา บ่าอ่า อือ แม้แน เพล่อ แง, ยาว ชฺ้าง ยอคา นา อางตู้ ม้า ย่าเจ่น ป้าค้า เพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ม้าม้า นี้ย่า เจ้านาย นี้ โต โย้เวอ ดื้ง แง ยาว ย่าเจ่น ม้า อางอ่อก โย้เวอ ดื้ง ยางนา ฮูพลา แง. จ้า กงา เกิ้ด ลือ ชี นี้ย่า แฮ้แม้ บ่าอ่า กงา นองก้อง ดื้ง นี้ย่า ย่าเจ่น ป้าค้า ดื้ง แง.” ");
INSERT INTO bzi_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“ค้าแต้ เวอ จาย อามือ เคอ แน, กงานา ฮาก คาม ล่า เมอ, นอย่า กูเทอ ย้า กงาก้อง ดื้ง แง กงานา บ่าวี ล่า. ");
INSERT INTO bzi_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ยาว กงา นองนา ก่าซ้าด เพล่อ ปี่ ล่าว่า, พาจาว มาง กงานา ก่าซ้าด เพล่อ ปี่ ล่า ชี่ แม้แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ยาว นอ พาจาว มาง อางเมิง โย้เวอ กงาก้อง ทื่งกง่า แน กงาจฺ่ากงาต้าง แง. ยาว นอ ต่างอี่ ก่าซ้าด ดื้งย้า โย้เวอ กงา ดื้ง คูแง. ยาว อิสราเอล อางเจ้อ 12 เจ้อ อือนา กงา ต้าดต่อน แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ยาว พระเยซู ซีโมนเปโตร นา นี้แม้แน จี่ช่าง ชีเย, “ซีโมน เวอ, แม่น แน น้า โว! ซาตานแด่ย่ายอคา ม้า นางนา แน นาง อางช่าง อือนา นืงบาเจ้อ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","จ้า ซีโมน เวอ, กงา นางนา แก่นคา แน เจ่อ โว แน อธิษฐาน ฮา ปี่ ล่าง. ยาว นอง กงานา วี ล่ายาว พ่าว ซฺ้า ล้า แล่เมอ, คริสเตียนม้องน้าม ทื่อบ่า อือนา ปล่อง โว, ยองนา แก่นคา แน เจ่อ ปี่ โว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ยาว เปโตร ม่า ชี นี้แม้แน, “จี่วีดอางซื้ง เวอ, กงา นางก้อง ทื่งกง่า แน คอก เวอ ดื้ง ยาว ซฺี้” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ยาว พระเยซู มือ เปโตร นา ม่า เย นี้แม้แน, “กงา ม่ายแบ ปี่ ล่าว่า มี้คี่ ยาพ่า บ่าตานฮู่ เวอ นาย่า กงานา บ่าแบ่ล่ากงา กา แน 3 เทอ จี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","พระเยซู ศิษย์เอก อือนา น้าน ชี นี้แม้แน, “ค้าแต้ เวอ กงา นองนา อางเลิ่ง อางแม่น แฮ้ง ป่าว แอ ปี่ ล่าเมอ, กงา นองนา พลู้ แน แพล่อง แน แค้บ แฮ้ง ฮ้านเพ้อ แน บ่าปี่ ฮ้าน แอ ปี่ ล่า, ยาว นองก้อง บ้าเจอ บ่าจา แน จา แง?” แน. ศิษย์เอก อือ นี้แม้แน จี่พอ ชีเย, “เจิ้นเจ้อ บ่าจา แน บ่าจา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ยาว พระเยซู นี้แม้แน จี่ ชีเย, “จ้า อ่ามือ อ่าซ่าง เมอ พลู้ แน แพล่อง จา แง ฮ้าน แอ โว! แน อ่าซ่าง เมอ มยาทาง บ่าจา แง ค่าลาวอางเง้โลบแล่เซฺ่อ อือ ก่อง ยาว มยาทาง วื้อ โว! ");
INSERT INTO bzi_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","กงา นี้แม้ ม่ายฮา ปี่ ล่าง นี้ย่า, ไม้ มอ ยาว พระคัมภีร์ เวอ แต้ม ชี ชี นี้แม้แน, ‘ยางนา ชฺ้าง บ่าแม่น อือ อางมู แน ดาบ แงแน. ยาว นี้ย่า กงา อางโต นี้งนา จี่ เคอ แง.’ “ยาว บ่ามล่าง ยาว แฮ้แม้ ม้าม้า ย้า เพล่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ยาว ยอง ม่า ชีเย นี้แม้แน, “อ่าจาน เวอ, เฮก! มยาทาง 2 อาน ย่าง นู้เวอ จาน ญา” จ้า พระเยซู ม่า ชีเย นี้แม้แน, “นี้เลิ่ง จี่ นี้ง ว่าง ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","พระเยซู อางฮ้อง แฮ้ ฮ้อง ก้อง อ่อกแอ ยาว มะกอกเทศ ตาแซ้ โย้เวอ แลน ชี, ยาง ศิษย์เอก อือ คาตา ย้า เค่ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","เคอ แล ยาว พระเยซู นี้แม้แน จี่ ชีเย, “นองมู นี้ย่า พาจาว มางนา อธิษฐาน ฮา ป้า โว! ม้างม้าเจ้อ อือนา นองนา บ่าปี่ จ้อบ อางซี ฮา ปี่ ล่าโจ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ยาว พระเยซู ยอง ก้อง อ่อกแอ บ่าเว่อ คา เย, ยาว ยางมือ ดื้ง ลื่อยาว ป่าตู คู อธิษฐาน ฮา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","นี้แม้แน “อ่าโบ้ง เวอ, นาง นืงบาจาบ แง แนยาว อางตูกอางพาน ล้างก้อก นี้ง ฮ้านแอ ปาว, กงา นืงบาจาบวา แน บ่าปี่ เพล่อ โจ. จ้า นาง นืงบาจาบวา แน เพล่อ ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ยาว มู่งท่า เท่วาด่า อืม ลู่ง ลือ พระเยซู นา นืงบาแฮ่ง ปี่ ลือ คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ยาว พระเยซู ปีนแตปีนนา ย้า อธิษฐาน ฮาย ดื้ง ชี, ไม้ ยา นืงบาต่อง นาบาตา ย้า ลาบ้าบ แง, มู่งนื่อ เซฺ่อเซฺ่อ ย้า นื้งชฺ่า เวอ ซฺี่ เซฺ่อ กลา ชี แม้แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","พระเยซู อธิษฐาน ฮา เปิน ยาว, ยาง ย่อ พ่าว ล้าน แล่ ชีเย. จ้า ยาง ศิษย์ อือ ยู่ โค ชีเย, ไม้ ยอ นืงบาชู่ม แฮ่ง โค ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","แฮ้งเย่ พระเยซู นี้แม้แน จี่ ชี, “บ้าเจอฮาย ยู่ คู แง? ทานล้า ยาว พาจาว มางนา อธิษฐาน ฮา ป้า โว! ม้างม้าเจ้อ อือนา นองนา บ่าปี่ จ้อบ อางซี ฮา ปี่ ล่าโจ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","พระเยซู จี่ ย่าง บ่าเปิน กื้ง เย, ยูดาส ยาง ศิษย์เอก 12 คู่น โย้เวอ ทื่อม่าง มาง ชฺ้าง ทื่อมู ซฺื่ยล้าน ชี. ยูดาส พระเยซู นา ย่อ อ้องซฺ้า แล ชีเย. แน พระเยซู นา ป่าปา น่าม แล ชี. ");
INSERT INTO bzi_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ยาว พระเยซู ยูดาส นา นี้แม้แน น้าน ชีเย, “ยูดาส เวอ, นา กงานา ป่าปา น่าม ล่ายาว บ่าแม่น ฮา ล่างลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ยาว พระเยซู ศิษย์ อืม มือ บ้าเจอ ตอล้า ชี แน มย้าง ยาว น้าน คูชี นี้แม้แน, “อ่าจาน เวอ, มยาทาง เค่ แจ ลื่อ จาเด่?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","พระเยซู อางมู โย้เวอ ชฺ้าง ทื่อม่าง จา แง. ยา ค่าตอง มยาทาง แฮ้ง ชอด อ่อก ล้า ปี่ ยาว, ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น ม่าง ย่าเจ่น ม่าง น่าซื่ง เวอ แจ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ยาว พระเยซู ม่า ชี นี้แม้แน, “ว่าง โว” แน. ยาว พระเยซู ปุโรหิต ยอคา มาง ย่าเจ่น มาง น่าซื่ง เวอ ซาว ยาว ยา โปยว ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ยาว พระเยซู มือ ปุโรหิต ยอคา อือนา, แน ตาฮ้าน โบสถ์อางฮื่อ ล่อฮู อือนา, แน ยิวชฺ้าง ยอคา ยางนา ลาย ชู ล้า คูชี อือนา นี้แม้แน จี่ช่าง ชีเย, “นอง มยาทาง แน ตู้ลู้ง ท่าม ล้า ยาว กงานา ล้า ชู ล่าง นี้ย่า, ไม้ นอ กงานา ค่าโม่ยค่ามโจน แน เย้ง ล่างลา? ");
INSERT INTO bzi_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","นอย่า กงา โบสถ์อางฮื่อ โย้เวอ ม่าอู่บ ดื้ง นา กูนืง ย้า มย้าง ล่าแง. จ้า นอ กงานา บ่าชู ล่า. จ้า อ่ามือ อางวื้งอางว้าง แน นอง อางญ่าม ย่าง เป” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ยองมู ย่าง พระเยซู นา ชู ยาว ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง ยู้ม โย้เวอ ซฺื่ยแลน ชีเย, เปโตร เว่อ แน เค่ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ยาว ยู้มล่อฮู อือ ยู้ม กองโค้ง ก้องนื้ง โย้เวอ บี่ท่อ จฺื้ง ปย่าว ดื้ง แวด จา คูเมอ, เปโตร มือ อ้อง ดื้ง แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ย่าบี่ ย่าเจ่น ทื่อม่าง จา เย, เปโตร บี่ท่อ ดื้ง ปย่าว จา นา มย้าง ยาว ยาง มือ แท้ แน อ้อง ฮูน แล ชีเย ยาว จี่ เย นี้แม้แน, “ค่าพ่าย่า นี้ม้า เยซู ก้อง ทื่งกง่า แน ดื้ง มาง ชีมา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","จ้า เปโตร นี้แม้แน จี่ ชี, “ย่าบี่ เวอ, กงา ยางนา บ่าแบกงากา นอ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","บ่ามล่าง ยาว ค่าพ่าย่า ทื่อม่าง เปโตร นา ฮู มย้าง ชีเย. แน นี้แม้ จี่ เย, “นา เยซู อางมู ชีมา” แน. จ้า เปโตร นี้แม้แน จี่พอ ชีเย, “กงา ยาง อางมู บ่าอ่า น้อ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ทื่อ ชั่วโมง จายล้า แล่ ยาว ค่าพ่าย่า ทื่อม่าง จา เย. ยา ปีนแตปีนนา ย้า นี้แม้แน จี่ แง, “ค่าพ่าย่า นี้ม้า ม้าม้า ย้า เยซู ก้อง ทื่งกง่า แน ดื้ง แง, ไม้ เย่ด กาลิลีชฺ้าง ทื่อช่างกานญา น่อ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","จ้า เปโตร จี่ เย นี้แม้แน, “กงา บ่าแบ นา บ้าเจอ จี่ แง” แน. ยาว เปโตร จี่ ย้าง บ่าลีน กื้ง เย ยาพ่า ต้าน ล่า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ยาว พระเยซู เปโตร นา พลาบ ฮู ชีเย, ยาว เปโตร พระเยซู จี่ต่าง นี้แม้แน จี่ ชี แฮ้ง ปื้อ ล้า ชีเย, “มี้คี้ ยา บ่าต่าน ฮู่ นู้, นา กงานา บ่าแบ ล่า กงากา แน 3 เทอ จี่ เป” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ยาว เปโตร อ่อกแอน ยาว นืงบาชู่ม นาบาตา เย อู้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ชฺ้าง พระเยซู นา ชูยแล ชีอือ พระเยซู นา จี่ ฮูย้า ยาว ตื่อ คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ยองมู นี้ย่า พระเยซู แมนือ เวอ พ้า ฮี่ด ชีเย, ยาว นี้แม้แน น้า ชีเย, “ม่า ล่าวแล นางนา ตื่อ ล่า ชี่ ม้า อ่าซ่าง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ยาว ยอง พระเยซู นา นาบาตา ย้า จี่ ฮูย้า คู ชี. ");
INSERT INTO bzi_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ซอทา แปล้น ล้า ยาว, ยิวชฺ้าง ยอคา อือ, ปุโรหิต ยอคา อือ แน อางลี้บอางล่าว ม่าอู่บฮู อือ ปาชูม ฮา คู ชีเย. ยาว พระเยซู นา ซฺื่ย น้าท้าม ล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ยาว ยอง พระเยซู นา นี้แม้แน น้าน คู ชีเย, “กงู นา ม่า ล่าวแล, นา พาจาว มาง แช้ยู้ ก่าซ้าด เพล่อ ปี่ชี่ มาง อางอ้า ลา?” แน. พระเยซู ยองนา พอ ชี นี้แม้แน, “กงา นองนา ม่า ล่าเวิม นอง กงานา บ่าเจ่อ ล่า. ");
INSERT INTO bzi_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","จาว่าแน กงา นองนา น้า ล่า ยาว, นอง กงานา บ่าพอ ล่า. ");
INSERT INTO bzi_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","จ้า จ้างจ้าง โย้เวอ กงาชฺ้างอางย่า เพล่อ ชี่ นี้ม้า พาจาว ล่าที่ อางฮื่อ มาง ล่าม่า ป่ากย่า ดื้ง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ยอง พระเยซู นา น้าน ชีเย นี้แม้แน, “นี้แม้ยาว นา พาจาว มาง อางย่า ลา?” แน. พระเยซู พอ ชี นี้แม้แน, “นอง จี่ นี้ย่า อางกง่า ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ยาว ยองมู แฮ้ง นี้แม้แน จี่ คูง เย, “กงู บ้าเจอฮาย พี่ญ่าน ซฺ้า กาน แง, ไม้ กงู ยาง จี่ แฮ้งนา อางกย่า คู แอ่น ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ชฺ้าง คาโคลาโค ดื้ง ช้อน กาชีอือ ทา จูง ล้า คู ชีเย, ยาว พระเยซู นา ผู้ว่า ปีลาต ก้อง ซฺื่ย แอน คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ยิวชฺ้าง ยอคา อือ พระเยซู นา นี้แม้แน จี่ คูง เย, “กงู ค่าพ่าย่า นี้มาง ค่องช่าง อือนา จี่ซ้อ นา มย้าง คูแอ, ยา ค่องช่าง อือนา ม่า แง, ก่าซ้าดยอคา ซีซาร์ นา ภาษี ฮู่ บ่าปี่ โจ แน, แน ยา ชฺ้าง พาจาว มาง แช้ยู้ กงู ก่าซ้าด เพล่อ ปี่ชี่ มาง แน ฮาจ่าแล่ง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ยาว ผู้ว่า ปีลาต มือ พระเยซู นา น้า ชี นี้แม้แน, “นา ยิวชฺ้าง อือ ก่าซ้าด มาง ลา?” แน. พระเยซู นี้แม้แน จี่พอ ชีเย, “โอ่ย! อางอ้า ย้า นาง จี่ นี้ย่า อางกง่า ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ยาว ผู้ว่า ปีลาต มือ ปุโรหิต ยอคา แน ค่องช่าง อือนา นี้แม้แน จี่ช่าง ชีเย, “กงา ฮู ยาว ยา เจิ้นเจ้อ อางซี บ่าจา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","จ้า ยองมู แฮ้ง ค้าแจ้ ย้า จี่ แล่ คูแง นี้แม้แน, “ยา กาลิลี แควน ชฺ้าง อือนา จ่อด ย้า ม่าอู่บ กว่า ซืกซาก ปี่ ชี่, ยาว น่อง โย้เวอ ยูเดีย แควน แน เยรูซาเล็ม อางเมิง โย้เวอ คาตา ย้า ฮาย ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","แฮ้งเย่ ผู้ว่า ปีลาต มาง ยองนา น้า ชี พระเยซู กาลิลี แควน ชฺ้าง ลา? ");
INSERT INTO bzi_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ยาว ค่องช่าง อืม พ้อ เย “โอ่ย อางอ้า ย้า” แน. แฮ้งเย่ ผู้ว่า ปีลาต พระเยซู นา ก่าซ้าด เฮโรด ก้อง ซฺาแล ปี่ชี่, ไม้ ยา กาลิลี แควน แฮ้ง ฮูพลา นอ, ยาว แฮ้เมอ ก่าซ้าด เฮโรด เยรูซาเล็ม อางเมิง โย้เวอ ดื้ง เย. ");
INSERT INTO bzi_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ก่าซ้าด เฮโรด พระเยซู นา มย้าง นาบาตา เย กย่าง แง, ไม้ ยา พระเยซู นา มย้าง ซี้ ยาว มล่าง กาชา เย, แน ยา พระเยซู อางเลิ่ง ฮา ชี อือ กงากย่า ชี, แน ยา พระเยซู อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา แฮ้ง มย้าง ซี้ง เย. ");
INSERT INTO bzi_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ก่าซ้าด เฮโรด พระเยซู นา ไลเจ้อ ย้า น้า ชี, จ้า พระเยซู มือ เจิ้นเจ้อ บ่าจี่ พอ เย. ");
INSERT INTO bzi_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ยาว ปุโรหิต ยอคา แน อางลี้บอางล่าว ม่าอู่บฮู โย้เวอ จูง จา อือ นาบาตา เย พระเยซู นา อางไล้ จี่ กาน คู ชี. ");
INSERT INTO bzi_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ยาว ก่าซ้าด เฮโรด แน ยาง ตาฮ้าน อืม พระเยซู นา อื้อกาน ยาว ฮูย้า ชีเย, ยองมู ย่าง พระเยซู นา ก่าซ้าด อางก่าอางตูม ตูม ปี่ ยาว, ผู้ว่า ปีลาต ก้อง ซฺาแล ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","แฮ้นืง ย้าเย่ ก่าซ้าด เฮโรด แน ผู้ว่า ปีลาต เย่ด อางช่าง เพล่อ กา ชี ย้าง, ไม้ อางด่า เย่ด บ่าโลง กา เย. ");
INSERT INTO bzi_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ผู้ว่า ปีลาต ปุโรหิต ยอคา แน ยิวชฺ้าง ยอคา แน ค่องช่าง อือนา ฮ้าว ช้อน ล้า ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ยาว ผู้ว่า ปีลาต นี้แม้แน จี่ ชีเย, “นอง ค่าพ่าย่า นี้มางนา กงานา ซฺื่ย ซฺ้า ล่า ชี นี้, นอ ยางนา จี่ แง ยา ค่องช่าง อือนา จี่ซ้อ ชี แน. ยาว กงา นอง ล้าก้า นู้เวอ ยางนา น้าท้าม ฮู ย่า, ยา เจิ้นเจ้อ อางซี บ่าจา, นอง ยางนา จี่ แฮ้งแม้แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ยาว ก่าซ้าด เฮโรด กงา แม้แน ย้า เย้ง แง, แฮ้งย้า ยาง ค่าพ่าย่า นี้มางนา กงาก้อง ซฺาลือ ปี่ชี่ นี้ย่า, ยา เจิ้นเจ้อ อางซี บ่ากงา ฮา บ้าเจอฮาย ยางนา แซ่ แง? ");
INSERT INTO bzi_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","กงา ตาฮ้าน อือนา ม่า ยางนา ตื่อ ปี่ ยาว ตอ แอ ปี่ นา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ไม้ ผู้ว่า ปีลาต ปัสกาป่อยนืง เวอ กู ปี ย้าเย่ นักโทษ ทื่อม่าง นา ตอ แง. ");
INSERT INTO bzi_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","จ้า ค่องช่าง อืม โฮ้กฮ้าว ชีเย นี้แม้แน, “ยาง นา แซ่ โว, ยาว บารับบัส นา ตอ โว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","บารับบัส นา คอก ชู ล้อง ชี นี้ย่า, ไม้ ยา เยรูซาเล็ม อางเมิง โย้เวอ ฮา ซืกซาก ปี่ ชีเย ยาว ชฺ้าง นา แซ่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ยาว ผู้ว่า ปีลาต ค่องช่าง อือนา ป้า ชีเย, ไม้ พระเยซู นา ตอ ซี้ง เย. ");
INSERT INTO bzi_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","จ้า ค่องช่าง อือ โฮ้กฮ้าว เย นี้แม้แน, “ยางนา ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด โว! ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ยาว ผู้ว่า ปีลาต ยองนา น้า แล่ ชีเย. นี้เทอ 3 เทอ เคอ ญา เย, นี้แม้แน “ยา บ้าเจอฮาย ชี? กงา บ่ามย่าง น้อ ยางนา แซ่ ก่อม้อก แน อางซี ฮา ชีแน, กงา ตาฮ้าน อือนา ม่าย ยางนา ตื่อ ปี่ ยาว ตอ แอ ปี่ นา” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","จ้า ยอง อางเซง แล่ง แน โฮ้กฮ้าว คู ชีเย, พระเยซู นา ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด โว! นี้แม้แนยาว ผู้ว่า ปีลาต ค่องช่าง อือ อางเซง แฮ้งนา บ่าก่าจ่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","แฮ้งย้า ผู้ว่า ปีลาต ค่องช่าง อือ ป้า แฮ้งแม้แน ฮาย ชี. ");
INSERT INTO bzi_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ผู้ว่า ปีลาต บารับบัส อางเลิ่ง อางซืกอางซาก ฮา ชี มางนา, แน ชฺ้าง แซ่ ชี มางนา ตอ ชีเย. ยาว ตาฮ้าน อือนา ม่าย พระเยซู นา ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด ปี่ ชีเย. ค่องช่าง อือ ป้า ชี แม้แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","พระเยซู นา ซฺื่ยแล เมอ, ยอง ซีโมน นา ชู ชีเย. แน ยางนา เค้ พระเยซู น่องน่อง โย้เวอ พระเยซู ไม้กางเขน ป่า เค่ ปี่ชี่. ซีโมน ไซรีนชฺ้าง เย, แฮ้ญ่ามเมอ ยา อางเมิง คล้าว เวอ ชา แล เย. ");
INSERT INTO bzi_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ค่องช่าง อางอีบ่าอ่า เย ย่อ เค่ แลน ชี, แน ชฺ้าง อางมู โย้เวอ ค่าบาย่า อางอีบ่าอ่า เย พระเยซู นา ซื่งกง่ากย้า อู้ง คู ชี. ");
INSERT INTO bzi_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ยาว พระเยซู ยองนา นี้แม้แน ม่า ชีเย, “เยรูซาเล็ม ค่าบาย่า เวอ, กงานา บ่าอู่ง ปี่ ล่าโจ, จ้า ค่าตอง อางโต นา แน ค่าตอง อางย่า อือนา อู้ง ปี่ คู ปาว. ");
INSERT INTO bzi_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ไม้ บ่ามล่าง ยาว ชฺ้าง อือ นี้แม้แน จี่ คู แง, ‘ค่าบาย่า อางย่า บ่าดื่ง กางซื้ง, แน อางย่า บ่าเกิ่ด กางซื้ง, แน อางย่า นา ลองแปด บ่าชู ปี่ กางซื้ง อือย่า กงู ล่อบ่าปา เช แล่ง ม้าม้า ย้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ยาว ยอง ตาแซ้ อางฮื่อ มางนา นี้แม้แน ป้า คูแง, ‘ตาแซ้ อางฮื่อ เวอ ปู่ง ลือ กงูนา เง่ แซ่ ล่า ปาว’ แน ยอ ตาแซ้ อางอี มางนา นี้แม้แน ป้า คูแง, ‘ตาแซ้ อางอี เวอ กงูนา พูม ล่า ปาว’ แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","จาว่าแน ยองมู แฮ้ง กงานา นี้แม้แน ฮา ล่ายาว นองนา บ้าเจอล้อแม้ ฮา ล่าง แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ยาว ชฺ้าง บ่าแม่น 2 คู่น จา เย, เย่ด นาม พระเยซู ก้อง ทื่งกง่า แน ซฺื่ย แซ่ แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ยาว ตาฮ้าน อือ ตี อางเม้ง “ตู่คย่าม ตาแซ้” แน ฮ้าว โย้เวอ เคิน ยาว, พระเยซู นา ไม้กางเขน เวอ ตื่อตี้ด ชีเย. ยาว ตื่น ค่าโม่ยค่ามโจน 2 คู่น มาง เย่ด นา คาตา ย้าเย่, เย่ดนา พระเยซู ล่าม่า ป่ากย่า ทื่อม่าง, ล่าซ่าย ป่ากย่า ทื่อม่าง แน ไม้กางเขน ท่า เวอ ตื่อตี้ด ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ยาว พระเยซู จี่ เย นี้แม้แน, “พาจาว กงา อางโบ้ง มาง เวอ, ยองนา อางซีอางบล่าบ บ่ายู โจ, ไม้ ยอ บ่าแบ วา ยอ บ้าเจอ ฮา คู ชี” แน. ยาว ยอง พระเยซู ค่าลาว ย่าง เบอจอก เปิ่ง ลางกา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ค่องช่าง อือ จูง ฮูน คู ชีเย, ยาว ยิวชฺ้าง ยอคา อือ จูง อื้อ คู ชีเย, แน นี้แม้แน จี่ ฮูย้า คู ชีเย, “ยา ฮากนา อางปล่อง กงากา, จาว่าแน ยา พาจาว มาง แช้ยู้ ก่าซ้าด เพล่อ ปี่ชี่ มาง ม้าม้า แนยาว, ยาง อางโต แฮ้ง ปล่อง จ่าแล่ คาไล” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ตาฮ้าน อืม จี่ ฮูย้า ยาว อ่างู่น แต่ค่า อางเช้น อางปู่ ย่าง พระเยซู นา ต้าง ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ยาว ยอง พระเยซู นา นี้แม้แน จี่ ชีเย, “จาว่าแน นาง ยิวชฺ้าง อือ ก่าซ้าด ม้าม้า แน ยาว, ค่าตอง อางโต นี้ง ปล่อง จ่าแล่ โว” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","พระเยซู อางตู่ ท่า โย้เวอ ล่าไม แป้น นี้แม้แน แต้ม ชี ชีเย, “นี้ย่า ยิวชฺ้าง อือ ก่าซ้าด มาง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ชฺ้าง บ่าแม่น ทื่อม่าง ไม้กางเขน ท่า เวอ ตื่อตี้ด ชี มาง พระเยซู นา นี้แม้แน จี่ ฮูย้า ชีเย, “น้า พาจาว มาง แช้ยู้ ก่าซ้าด เพล่อ ปี่ชี่ มาง อ่าลา? นาง อางโต นา ปล่อง ไจ่ แล่ แปล้. แน กงูนา คาตา แน ปล่อง ล่า แปล้” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","จ้า ชฺ้าง บ่าแม่น ทื่อม่าง มาง นี้แม้แน จี่ ชีเย, “นาง ชา ซฺี้ คางญา พาจาว มางนา บ่าแค ลา? ");
INSERT INTO bzi_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ไกง้ ย่า ซฺี้ ก้อม้อก, จ้า เยซู ยา เจิ้นเจ้อ อางซี บ่ากงา ฮา นอ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ยาว ยาง พระเยซู นา นี้แม้แน จี่ช่าง ชีเย, “เยซู เวอ, นาง ก่าซ้าด กงา เพล่อ เมอ กงานา บ่าลู่ม ล่า โจ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","แฮ้งเย่ พระเยซู นี้แม้แน ม่า ชี, “กงา ม่ายแบ ปี่ ล่าว่า, มี้นืง นา ซฺี้ แง. ยาว กงาก้อง มู่งท่า เวอ ทื่งกง่า แน ม้าม้า ย้า กงาดื้ง แล แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ยาว ชฺ้างอางเมิง คาโคลาโค โย้เวอ 12 โมง นืงก้อง เวอ จาย 3 โมง เวอ เคอ นี้ย่า วื้งว้าง โค ชี. ");
INSERT INTO bzi_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ไม้ มู่งนื่ง อางแปล้น ท่อ ย้าง ว่าง ชีเย. ยาว โบสถ์อางฮื่อ อางฮ้อง อางเซฺิ่งอางซฺ้าง ล้องก้อ โย้เวอ พ้า เทิง ชี ชีย้าง 2 พื้น แน ชีดอ่อก ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ยาว พระเยซู นี้แม้แน จี่โฮ้ก ล้า ชีเย, “อ่าโบ้งพาจาว เวอ, กงา อางค่องอางล้า นี้ง นาง ล่าปู่ โย้เวอ ชี ปาว” แน. จี่ เปิน ยาว พระเยซู อางซ่า แช ซฺี้ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ยาว ตาฮ้าน นายร้อย มาง บ้าเจอ ตอล้า ชี แน มย้าง ยาว, ยาง พาจาว มางนา สรรเสริญ ฮา ชีเย. ยาว จี่ เย นี้แม้แน, “ยา ชฺ้าง อางแม่น อางเซฺิ่งอางซฺ้าง ม้าม้า ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ยาว ค่องช่าง ฮู ล้า ชีอือ, บ้าเจอ ตอล้า ชี แน มย้าง ยาว, ยอง มือ ยู้ม เวอ พ่าวแอน ยาว นืงบาชู่ม คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ยาว พระเยซู อางช่าง คาโคลาโค อือ, แน ค่าบาย่า กาลิลี แควน เวอ จาย พระเยซู ก้อง เค่ล้า คูชี อืม เว่อ แน จูง ฮูน คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ค่าพ่าย่า ทื่อม่าง จา เย อางเม้ง โยเซฟ แน. ยา สภาแซนฮีดรีน มู โย้เวอ ชฺ้าง ทื่อม่าง มาง เย. ยา ชฺ้าง อางซืออางปลอง เย. ");
INSERT INTO bzi_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ยา ยิวชฺ้าง ยอคา ทื่อบา อือ พระเยซู นา ต้าดต่อน ชี แฮ้งนา บ่าซอ เย. ยา อาริมาเธีย อางเมิง ยูเดีย แควน เวอ จายล้า แง. แน ยา พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ แฮ้ง ล่อ เย. ");
INSERT INTO bzi_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ยา ผู้ว่า ปีลาต ก้อง แล พระเยซู ศพ ย่าง ป้า แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ยาว พระเยซู อางโต ย่าง ไม้กางเขน ท่า โย้เวอ ยู้ อ่อก ยาว, พ้า อางป่อน อางฮู่ อางคา ย่าง ป้าน ชีเย. ยาว ท้ามชฺ้างซฺี้ชีย้า อางซฺื่อ โย้เวอ ฮ้าน แล ชี. ");
INSERT INTO bzi_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","แฮ้นืง วันศุกร์ เย, แน ลองนืง ย่าง แท้ ชา เคิน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ยาว ค่าบาย่า มู พระเยซู ก้อง กาลิลี แควน โย้เวอ จาย เค่ล้า คูชี อืม โยเซฟ ก้อง ท้ามชฺ้างซฺี้ชีย้า โย้เวอ เค่แลน คู ชีเย. ยาว ยอง มย้าง คู ชี, ยา พระเยซู อางโต แฮ้ง ท้าม โย้เวอ บ้าเจอล้อเกิ้ง ชี ชีแน. ");
INSERT INTO bzi_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ยาว ยองมือ ยู้ม เวอ พ่าว แอ อางเกิ่ง อางฮ้อม แน น้ำหอม อือ ซฺ้า ชี คู ชี, พระเยซู ศพ โย้เวอ กาน ปี่ แงแน. ยาว ลองนืง โย้เวอ ยอง มือ ซ่าว คู ชีเย. โมเสส อางลี้บอางล่าว เวอ แต้ม ชี ชี แม้แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ลองนืง ซอทา อางด่า เวอ, ค่าบาย่า อืม อางเกิ่ง อางฮ้อม ซฺ้า ชี ชีย้าง ท้าม โย้เวอ ฮ้าน แอน คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ยาว ท้ามชฺ้างซฺี้ชีย้า โย้เวอ ลอบา พี่ ชี ย่าง ล่าน อ่อก ชีแน มย้าง ชี. ");
INSERT INTO bzi_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ยองมู ย่าง ท้ามชฺ้างซฺี้ชีย้า โย้เวอ อ้องแลน คู ชีเย, จ้า พระเยซู ศพ นา บ่ามย่าง เย. ");
INSERT INTO bzi_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ยาว ยอง นืงบา โย้เวอ เย้ง คูง เย บ้าเจอ ตอล้า ชี แน, ทื่อชี่ด ยาว ค่าพ่าย่า 2 คู่น อางก่าอางตูม ป่อนล่อนช่อน แน ตูม แล่ยาว ยอง ก่องทาง เวอ จูง ล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ยองมู ย่าง แค คู ยาว ป่าตูคู นื้งชฺ่า โย้เวอ แมก่า บอกแป่ก คู ชีเย, ยาว ค่าพ่าย่า 2 คู่น มาง เย่ด ยองนา นี้แม้แน จี่ช่าง ชีเย, “นอ ชฺ้างซฺี้ ดื้งย้า นู้เวอ บ้าเจอฮาย ชฺ้างอางแต่ นา ซฺ้า กว่า คูแง? ");
INSERT INTO bzi_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","พระเยซู นู้เวอ บ่าดื่ง กาน ยา แต่ลาน ญา. อางจามกงา กา ย้าล่า, กาลิลี แควน โย้เวอ จา เมอ พระเยซู นี้แม้แน จี่ แง, ");
INSERT INTO bzi_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘ชฺ้างอางย่า มางนา ชฺ้าง อางบล่าบ อือ ชู ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด แง. ยาว ยา 3 นืง โย้เวอ แต่ล้า แล่แง’” แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","แฮ้งเย่ ค่าบาย่า มู อืม เย้ง กงา แล่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ยองมู ย้าง อางไว่อางคย้าง ย้าเย่ พ่าวแล ศิษย์เอก 11 คู่น อือนา แน ศิษย์ ทื่อบ่า อือนา อางเลิ่ง คาโคลาโค แฮ้ง อู่บน้า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ค่าบาย่า มู นี้เลิ่ง อู่บ ชีอือ, มารีย์ มักดาลาชฺ้าง มาง, โยอันนา, มารีย์ ยากอบ อางบา มาง แน ค่าบาย่า ทื่อบ่า อือ คาตา ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","จ้า ศิษย์เอก อือ แน ศิษย์ ทื่อบ่า อือ ค่าบาย่า อือ จี่ แฮ้งนา บ่าเจ่อ คูเย, แน อางเลิ่ง ม้าม้า บ่าอ่า แน ฮา คูงเย. ");
INSERT INTO bzi_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","จ้า เปโตร มือ ท้ามชฺ้างซฺี้ชีย้า โย้เวอ ฮื่น ฮูน แล ชีเย. ยาง บอก ฮู เมอ ยา พ้า อางป่อน อางฮู่ อางจา พระเยซู ศพ โย้เวอ ปาน ชีย้าง กลา จา นา มย้าง กาน ชีเย, ยาว ยาง อ่อก ลือ เมอ เย้ง เย บ้าเจอ ตอล้า ชี แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","แฮ้นืง พระเยซู ศิษย์ 2 คู่น มาง เย่ด เอมมาอูส ค่อง เวอ ย่อ แอน ชีเย, เยรูซาเล็ม อางเมิง เวอ จาย เอมมาอูส ค่อง เวอ แล นี้ย่า 11 กิโลเมตร นี้งล่อ เย. ");
INSERT INTO bzi_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ยาว เย่ด อางเลิ่ง คาโคลาโค ตอล้า ชี แฮ้ง จี่ กางเย. ");
INSERT INTO bzi_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ยาว พระเยซู เย่ด ก้อง แท้ ย้า ย่อ อ้องล้า ชี, ยาว เย่ดก้อง ทื่งกง่า แน ย่อ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","จ้า พาจาว มาง เย่ดนา ฮาย พระเยซู นา บ่าแบกงากา แน ฮาย ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ยาว พระเยซู นี้แม้แน น้าน ชีเย, “ไน้ บ้าเจอ อางเลิ่ง จี่อู้ กาแง?” แน. เย่ด มือ ย่อ ย่าง ว่าง ชีเย, แน เย่ด แมก่า นี้ย่า บ่าม่อนบ่าซ่า เย. ");
INSERT INTO bzi_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ยาว พระเยซู ศิษย์ ทื่อม่าง อางเม้ง เคลโอปัส แน ชี่ มาง นี้แม้แน พอ ชีเย, “เยรูซาเล็ม อางเมิง เวอ 2-3 นืง จานช่าชี่ นู้เวอ อางเลิ่ง ตอล้า ชี นี้ย่า นาง ญา จา แง บ่าแบ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","แฮ้งเย่ พระเยซู นี้แม้แน น้าท้าม ชี, “บ้าเจอ ตอล้า ชี?” แน. ยาว เย่ด นี้แม้แน พอ ชีเย, “ไม้ เยซู นาซาเร็ธชฺ้าง มางก้อง อางเลิ่ง ตอล้า ชี แฮ้ง ยาว. ยา พาจาวจี่ต่างจี่แต่นฮู เป. พาจาว มาง แน ชฺ้าง อือย่า กงามย้าง คูง ญา, ยาง จี่ต่าง แน ยาง อางเลิ่ง ฮา ชี่อือ นาบาตา ล่าที่ อางจา แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","จ้า ปุโรหิต ยอคา แน กงู ยอคา อือย่า, พระเยซู นา ผู้ว่า มางนา ชู ซฺาแอ ชี, ไม้ ยางนา อางซี ต้าดต่อน แซ่ ปี่ แงแน. ยาว ตาฮ้าน อืม พระเยซู นา ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด ชี. ");
INSERT INTO bzi_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","อางด่า เวอ กงู เย้ง ชี คูแอ, พระเยซู พาจาว มาง แช้ยู้ ก่าซ้าด เพล่อ ปี่ชี่ มาง แน. แน ยา อิสราเอลชฺ้าง อือนา ลือ ปล่อง ลือ แงแน. จ้า ยา ซฺี้ 3 นืง เคิน ญา. ");
INSERT INTO bzi_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ยาว มี้นืง กงู อางมู นู้เวอ ค่าบาย่า ทื่อบ่า อือย่า, ซอทาอางด่า เวอ ย้า ท้ามชฺ้างซฺี้พูมย้า โย้เวอ แลน คูชี. ยาว ยอง พ่าว ลือ กงูนา ฮาย นืงบาม่าน ปี่ ล่า คูแง, ไม้ ยอ กงูนา นี้แม้แน อู่บน้า ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ยองมู นี้ย่า พระเยซู ศพ แฮ้งนา บ่าซฺ่า มย้าง กา. แน ยอ กงูนา นี้แม้แน ม่า แล่ ล่าง, ยองมู นี้ย่า เท่วาด่า 2 องค์ นา มย้าง คูชี แน. เท่วาด่า มาง เย่ด ยองนา ม่า ชี, เยซู อามืม จี่วีด อางจา แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","กงู อางมู เวอ ชฺ้าง ทื่อบ่า อืม ท้ามชฺ้างซฺี้ชีย้า โย้เวอ ฮื่น ฮูน แล คู ยาว, พระเยซู ศพ แฮ้งนา บ่ามย่าง ม้าม้า ย้า, ค่าบาย่า แฮ้อือ ม่า ล่าชี่ แฮ้งแม้แน ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ยาว พระเยซู นี้แม้แน จี่ เย, “ไน้ย่า บ้าเจอ นา จ่าง คาแน้? บ้าเจอ ไน้ย่า พาจาวจี่ต่างจี่แต่นฮู อือ ม่า แฮ้งนา บ่าเจ่อ แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","พาจาวจี่ต่างจี่แต่นฮู อือ เจ้ง ย้า นี้แม้ ม่า ชี ชี, ชฺ้าง พาจาว มาง แช้ยู้ ก่าซ้าด เพล่อ ปี่ชี่ ม้า อางตูกอางพาน กงาโอ้ด เปิน แง. ยาว น่อง โย้เวอ พาจาว ม้า ยางนา โญกจ่าญ่อจ่า แง.” ");
INSERT INTO bzi_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ยาว พระเยซู มือ อางเลิ่ง คาโคลาโค มอ ยาว พระคัมภีร์ โย้เวอ, โมเสส แน พาจาวจี่ต่างจี่แต่นฮู อือ ยางนา จี่ เคอ ชี แฮ้ง อู่บน้า ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","เอมมาอูส ค่อง โย้เวอ ชา เคอ เมอ, พระเยซู มือ ย่อ ไก ลาม แลน ชี ป้าค้า จ้างจ่าแล่ง เย. ");
INSERT INTO bzi_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ยาว เย่ด พระเยซู นา ป้า ดื้ง ปี่ชี่ เย, แน นี้แม้แน ม่า เย, “มู่งคี่ล้าก้า เคอ ตืกตืก กาชา, ชา วื้ง ย้าง ญา จา แง, ไกง้ก้อง ซ่าว ดื้ง ปาโน” แน. พระเยซู มือ เย่ดก้อง ซ่าว ดื้ง น้าว. ");
INSERT INTO bzi_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ยาว ยอง ฮ่าง ดื้ง จ่า จา เมอ, พระเยซู มือ ค้านู้มป่าง ย่าง กอย ท่าม แล่ ยาว พาจาว มางนา ขอบคุณ ฮา ชี, ยาว เย่ด นา ค้านู้มป่าง ย่าง ชีด ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ยาว พาจาว มาง เย่ดนา ฮาย พระเยซู นา จาม กงากา ปี่ ชีเย. ยาว พระเยซู มือ โปยว กา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ยาว เย่ด มือ จี่ ลางกา ชี นี้แม้แน, “นี้ล้อมช้าว ไกง้ ย่อ ลือ เมอ, พระเยซู พระคัมภีร์ โย้เวอ อางเลิ่ง อือ อู่บน้า ปี่ ล่า เมอ, ไกง้ กย่างม่อนซ้า แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ยาว เย่ด มือ อางไว่อางคย้าง เย ทานล้า ยาว, เยรูซาเล็ม อางเมิง โย้เวอ พ่าว แอน แล่ชี่. ยาว ศิษย์ 11 คู่น อือ แน ศิษย์ ทื่อบ่า อือ ช้อน กา จา นา มย้าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ยาว โย้เวอ ชฺ้าง ช้อน กา ชี อืม เย่ดนา ม่า ชีเย นี้แม้แน, “พระเยซู กงู จี่วีดอางซื้ง ม้า แต่ล้าน ชี ม้าม้า ย้า! พระเยซู ยา เปโตร นา มย้าง ปี่ชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ยาว เย่ด มือ เย่ด แก้บ้า ย่อ เมอ อางเลิ่ง ตอล้า ชี แฮ้ง อู่บ ชีเย, แน ยองนา นี้แม้แน อู่บน้า ปี่ชี่ เย, เย่ด พระเยซู ค้านู้มป่าง เคลิก ปี่ เมอ ยา ยางนา จาม กงากา ชี แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","เย่ด อางเลิ่ง แฮ้ง อู่บ จา เมอ, พระเยซู ยองมู โย้เวอ จูง ลือ ชีเย, แน นี้แม้แน จี่ ชีเย, “จาบื่อดื้งบื้อ แน จา คู โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ยาว ยอง มือ แค แล่ คู ชีเย, ไม้ แด่ย่า นา มย้าง ชี แน เย้ง เย. ");
INSERT INTO bzi_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ยาว พระเยซู ยองนา นี้แม้แน จี่ช่าง ชีเย, “บ้าเจอฮาย แค แง? บ้าเจอ บ่าเจ่อ คู แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","กงา ล่าปู่ แน ล่าคื่อ นู้ ฮู ปาว, นี้ กงา อางโต ย่าง ม้าม้า ย้า บ่าเจ่อ ยาว ชู ฮู ปาว แน แบ คาไล แด่ย่า บ่าอ่า แน, ไม้ แด่ย่า นี้ อางม้า แน อางกง่าว บ่าจา นอง กงานา มย้าง ล่าง แม้” แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","จี่ เปิน ยาว, พระเยซู ยาง ล่าปู่ แน ล่าคื่อ ย้าง ยองนา ฮู ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ยาว ศิษย์ อืม กย่าง คูง เย. แน นาบาตา นืงบาม่าน คูง เย. ยอ อางเลิ่ง นี้เลิ่ง นา อางเลิ่ง ม้าม้า แน บ่าเจ่อ คู เย. ยาว พระเยซู นี้แม้แน น้าน ชีเย, “บ้าเจอ จฺ่าเซฺ่อ จา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","แฮ้งเย่ ยอง ยางนา ล่องแต่ คาง ทื่อม่าง ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ยาว พระเยซู มือ ยอง ล้าก้า เวอ จฺ่า ฮู ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ยาว ยาง ยองนา นี้แม้แน จี่ช่าง ชี, “ค้าแต้ กงา นองก้อง ดื้ง เมอ, กงา นองนา ม่า ล่าย่า กงา อางเลิ่ง คาโคลาโค โมเสส อางลี้บอางล่าว แน พาจาวจี่ต่างจี่แต่นฮู อือ มอ ยาว, ปาบ แน สดุดี ปาบ โย้เวอ แต้ม ชี ชี แฮ้ ม้าม้า ย้า ตอล้า แง” แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ยาว พระเยซู ยองนา ฮาย พระคัมภีร์ โย้เวอ อางเลิ่ง แต้ม ชี ชี แฮ้ง แบ ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","พระเยซู ยองนา ม่าย ชี นี้แม้แน, “พาจาวจี่ต่างจี่แต่นฮู อือ มอ ยาว พระคัมภีร์ โย้เวอ นี้แม้แน แต้ม ชี ชี, กงาย่า พาจาว มาง แช้ยู้ ยาว ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ชี มาง ย้า. กงาย่า กงาโอ้ด ตูกพานลาบ้าบ แง, แน กงา ซฺี้ ยาว วันที่ 3 โย้เวอ แต่ล้า แล่ง. ");
INSERT INTO bzi_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ยาว นอย่า กงา ล่าที่ นี้ง ไจ, ชฺ้าง กูเจ้อกูจาด อือนา กงา อางเลิ่ง นี้ง ป่าว ม่ายแบ ปี่ แง. ไม้ ยองนา นืงบาเพ่น อางบล่าบ ฮา แฮ้ง ว่าง ปี่ ยาว อางบล่าบ กงาปูน ปี่ แง แนนอ. แน เยรูซาเล็ม อางเมิง โย้เวอ ต่องก่าต่าง ป่าวม่า เป. ");
INSERT INTO bzi_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ยาว นองมู นี้ย่า นี้เลิ่ง โค ย้า กงาแบ กงามย้าง แง, นี้แม้แนยาว นอย่า อางเลิ่ง คาโคลาโค กงามย้าง ชีนี้ง ฮากนา อู่บน้า ปี่ โว. ");
INSERT INTO bzi_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ยาว กงาย่า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มางนา นองก้อง ซฺาลือ ปี่ แน. อางค่องอางล้า อางเซฺิ่งอางซฺ้าง นี้ม้า อ่าโบ้งพาจาว นองนา ก่ามค่าน ปี่ ล่า ชี่ ย้างย้า นองนา ปี่ ล่า แงแน. จ้า นอ เยรูซาเล็ม อางเมิง นู้เวอ ล่อ ดื้ง คู ปาโน, มู่งท่า โย้เวอ อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ล่าที่ แฮ้ง กงาบู้ เมอ เคอ” แน. ");
INSERT INTO bzi_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","พระเยซู ยองนา เบธานี ค่อง เวอ ซฺื่ยแล ชีเย, ยาว ล่าปู่ โญก แล่ยาว ยองนา ก่ามป่อน ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ยาว พระเยซู ก่ามป่อน ปี่ เมอ พาจาว มาง ยางนา มู่งท่า โย้เวอ แล ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ยาว ยอง พระเยซู นา บอกไว้ คู ชีเย, ยาว เยรูซาเล็ม อางเมิง โย้เวอ พ่าวแล คู ชีเย, ยอ นาบาตา เย่ กย่าง คู แง. ");
INSERT INTO bzi_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ยาว ยอง โบสถ์อางฮื่อ โย้เวอ กูนืง ย้า แอน คู ชี, ยาว ยอง พาจาว มางนา สรรเสริญ ฮา คู ชีเย.");
INSERT INTO bzi_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ต่องก่า เวอ ชฺ้างอางเมิง นี้ง บ่าจา แน ฮา เมอ พาจาวจี่ต่าง นี้ อางจา ลามแลว ย้า, พาจาวจี่ต่าง นี้ พาจาว มาง ก้อง ดื้ง แง, แน พาจาว แน ทื่อช่างกานญา. ");
INSERT INTO bzi_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","จี่ต่าง นี้ย่า ต่องก่า เวอ ชฺ้างอางเมิง บ่าจา แน ฮา เมอ ย้า พาจาว มาง ก้อง จา แง. ");
INSERT INTO bzi_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","พาจาว ม้า ยาง จี่ต่าง แฮ้ง ไจ กูย่างกูเจ้อ แต่ง ชี. ทื่อย่างทื่อเจ่อ แนม บ่าจา พาจาว มาง ยาง จี่ต่าง แฮ้ง บ่ากงา ไจ แต่ง แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","กูย่างกูเจ้อ อือ จี่วีด นี้ย่า พาจาวจี่ต่าง โย้เวอ จายล้า แง. พาจาวจี่ต่าง นี้ย่า ชฺ้าง คาโคลาโค อือนา ฮา มู่งท่า กงามย้าง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","อางแปล้นอางซ้า นี้ย่า อางวื้งอางว้าง โย้เวอ ท่อ แล ปี่ แง, จ้า อางวื้งอางว้าง นี้ย่า อางแปล้นอางซ้า มางนา บ่าก่าจ่ากงากา. ");
INSERT INTO bzi_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","พาจาว ม้า ค่าพ่าย่า ทื่อม่าง อางเม้ง ยอห์น แน ชี่ มางนา ยาง อางเลิ่ง แฮ้ง ม่า ลือ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ยอห์น ชฺ้าง อือนา อางแปล้นอางซ้า อางเลิ่ง นี้ง ม่า ลือ แง, ไม้ ชฺ้าง คาโคลาโค อือนา ยาง อางเลิ่ง ม่า ลือ ชี แฮ้ง เจ่อ ปี่ แง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ยอห์น อางโต นี้ย่า อางแปล้นอางซ้า มาง บ่าอ่า. จ้า ยา อางแปล้นอางซ้า มาง อางเลิ่ง แฮ้ง ม่า ลือ แง. ");
INSERT INTO bzi_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","อางแปล้นอางซ้า ม้าม้า ชฺ้าง คาโคลาโค อือนา อางแปล้น ปี่ นี้ย่า, ชฺ้างอางเมิง นู้เวอ อามือ ลือ แง. ");
INSERT INTO bzi_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","พาจาวจี่ต่าง นี้ย่า ชฺ้างอางเมิง นู้เวอ ลู่ง ดื้ง ลือ ชี. พาจาว มาง ยาง จี่ต่าง แฮ้ง ไจ ชฺ้างอางเมิง แต่ง เวิม, จ้า ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือย่า พาจาวจี่ต่าง แฮ้งนา บ่าแบกงากา. ");
INSERT INTO bzi_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","พาจาวจี่ต่าง แฮ้ง พาจาว มาง ชฺ้าง อางเจ้ออางจาด แช้ยู้ ชี อือ อางมู โย้เวอ เคิน ลือ เวิม, ยองมู แฮ้ง พาจาวจี่ต่าง แฮ้งนา บ่าเจ่อ คู. ");
INSERT INTO bzi_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","จ้า อ่าซ่าง พาจาวจี่ต่าง แฮ้งนา เจ่อ แง, พาจาว มาง อางย่า กงาเพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ชฺ้าง อือ พาจาว มาง อางย่า กงาเพล่อ นี้ย่า ยอง เกิ้ดลือ เมอจาย กงาเพล่อ บ่าอ่า, จ้า ยอง พาจาว มางนา เจ่อ ยาว พาจาว มาง ยองนา ฮาย ยาง อางย่า เพล่อ ปี่ง แน จี่วีด อางซฺื่อ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","พาจาวจี่ต่าง นี้ ชฺ้าง เกิ้ด ลือ ชี. ยาง อางเม้ง พระเยซู แน เป. ยา กงูมู นู้เวอ จี่วีด ไจ แง. พาจาวจี่ต่าง นี้ ลากซื่งกง่ากย้า อางเลิ่ง อือ แน อางซืออางปลอง อางเลิ่ง อือ ปลื้ง ย้า จา แง. กงู ยาง ล่าที่ อางฮื่อ แฮ้ง กงามย้าง คูย่า. ยาว นี้ย่า กงูนา ฮา แบ ปี่ ล่าแง, ยา พาจาว มาง ก้อง ล่าที่ กงาบู้ ชี, แน ยา พาจาวอางย่า ทื่อม่าง แน ชี่ มาง ย้า แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ยอห์น พาจาวอางย่า มาง อางเลิ่ง แฮ้ง ชฺ้าง อือนา ม่า แง. ยา อางเซง บื้ง แน นี้แม้แน จี่ แง, “ชฺ้าง กงา น่อง เวอ ลือ ม้า กงา ล่อบ่าปา ฮื่อ แง, ไม้ ยา ค้าแต้ เวอ ย้า จี่วีด จา ล้าน ชี, กงา บ่าเกิ่ด ฮู่ เวอ ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ยางก้อง ลากซื่งกง่ากย้า อางเลิ่ง อือ ปลื้ง ย้า จา แง. นี้งย้า กงูมู คาโคลาโค นี้ง ยางก้อง ก่ามป่อน กงาบู้ แง, แน กงู ยางก้อง ก่ามป่อน กงา เวิม กงาแล แล่แง. ");
INSERT INTO bzi_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","พาจาว ม้า อางลี้บอางล่าว แฮ้ง โมเสส ก้อง ปี่ ลือ ปี่ชี่, จ้า พาจาว ม้า ยาง ลากซื่งกง่ากย้า อางเลิ่ง แฮ้ง แน อางเลิ่ง ม้าม้า แฮ้ง พระเยซูคริสต์ ก้อง ปี่ ลือ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","อ่าซ่าง มาง พาจาว มางนา บ่ากงามย้าง กางซื้ง, พาจาวอางย่า ทื่อม่าง แน ชี่ มาง ญา พาจาว มางนา กงามย้าง ชี. ยา พาจาว มาง ก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ชี. ยา พาจาว ยาง อางโบ้ง มาง ก้อง แท้ แน ดื้ง แง. ยาว ยา กงูนา ฮาย พาจาว มางนา แบกงา ปี่ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ทื่อนืง จา แง เยรูซาเล็ม อางเมิง เวอ ยิวชฺ้าง ยอคา อือ ปุโรหิต มู แน เลวี มู อือนา ฮ้าว ล้า ปี่ชี่. ยาว ยองนา ม่า ยอห์น นา นี้แม้แน น้า ปี่ชี่ “นา อ่าซ่าง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ยาว ยอห์น มือ อางเลิ่ง ม้าม้า แฮ้งนา บ่าโชง เย. ยาง ปล้อง แน นี้แม้แน ม่า ชีเย, “กงา พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ ชี่ มาง บ่าอ่า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ยองมู ย่าง นี้แม้แน น้าน แล่ชี่ เย, “แฮ้แม้ยาว นา อ่าซ่าง เวอ? นา พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ อางซฺื่อ เกิ้ด แล่ชี่ มาง ลา?” แน. ยอห์น มือ “บ่าอ่า” แน จี่พอ ชีเย. ยาว ยอง นี้แม้แน น้าน แล่ชี่ เย, “อ้าว นา พาจาวจี่ต่างจี่แต่นฮู โมเสส มอ ชี ชี มาง ล่า กาญ่าม เวอ เกิ้ด ลือ แง?” แน. ยอห์น มือ “บ่าอ่า” แน พอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ยองมู ย่าง ยอห์น นา นี้แม้แน น้าน แล่ชี่ เย, “ท้าว นา อ่าซ่าง ม้าม้า เวอ? กงูนา ม่า ล่าว แล, ยาว กงูม ชฺ้าง กงูนา ซฺาลือ ปี่ ล่า ชี่ อือนา ม่า แล แง, นา อ่าซ่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ยาว ยอห์น พาจาวจี่ต่างจี่แต่นฮู อิสยาห์ มาง จี่ต่าง แฮ้ง ไจ นี้แม้แน จี่พอ ชีเย, “กงา อางเลิ่งอางล่าว นี้ย่า พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี เป, กงา ซ่องก่อง อางเว่อ โย้เวอ นี้แม้แน ป่าว แง, ‘จี่วีดอางซื้ง มาง อามือ ชาลือ แง. ยาง เคอ ลือ แฮ้นืง ปีนแตปีนนา แน ล่อ คูโว. ค่องช่าง อือ ก่าซ้าด มาง ชา ล้า เมอ แก้บ้า แต่ง ล่อ แฮ้งแม้แน.’” ");
INSERT INTO bzi_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ยาว ชฺ้าง ฟาริสี มู อือ ซฺาลือ ปี่ชี่ อืม. ");
INSERT INTO bzi_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ยอห์น นา นี้แม้แน น้า ชี, “นา ชฺ้างอางเมิง นู้เวอ พาจาว มาง แช้ยู้ ก่าซ้าด เพล่อ ลือ ปี่ชี่ มาง บ่าอ่า, แน พาจาวจี่ต่างจี่แต่นฮู เอลียาห์ อางซฺื่อ เกิ้ด แล่ชี่ มาง บ่าอ่า, แน นา พาจาวจี่ต่างจี่แต่นฮู โมเสส มอ ชี ชี มาง บ่าอ่า. แฮ้แม้แนยาว นา บ้าเจอฮาย ค่องช่าง อือนา ล้างตือพิธีบัพติศมา ฮา ปี่ แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","แฮ้งย้า ยอห์น นี้แม้แน จี่พอ ชี, “กงา ล้าง แฮ้ง ไจ พิธีบัพติศมา ฮา แง. จ้า นู้เวอ ทื่อม่าง จา แง. นอ ยางนา บ่าแบกงากา. ");
INSERT INTO bzi_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ชฺ้าง นี้ม้า กงา น่อง เวอ ลือ แง. จ้า ชฺ้าง แฮ้ม้า กงา ล่อบ่าปา ฮื่อ แง. กงา อางโต นี้ย่า ยางนา แค้บ ล่าตื่อ พื้ออ่อก ปี่ เวิม บ่าซูม” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","อางเลิ่ง คาโคลาโค นี้ย่า จอร์แดน ล้างบ้า มู่งนื่งอ่อกป่ากย่า ตอล้า ชี, แน ยอห์น ล้างบ้า นี้มางก้อง เวอ ย้า ชฺ้าง อือนา ล้างตือพิธีบัพติศมา ฮา ปี่ แง, แน ยอห์น พิธีบัพติศมา ฮา แฮ้ย่า เบธานี ค่อง เวอ อางแท้. ");
INSERT INTO bzi_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ยาว ทื่อนืง จายล้า แล่ยาว พระเยซู มือ ยอห์น นา ย่อ อ้องซฺ้า แอ ชี. ยาว ยอห์น มย้าง เมอ นี้แม้แน จี่ ชี, “ฮูปาว! ชฺ้าง นี้ม้า พาจาว มาง แกะอางย่า ม่าง ย้า, ยา ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา อางบล่าบ ปล่องปูน ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ชฺ้าง นี้มาง ย้าเป กงา นี้แม้แน จี่ เคอ ม้า, ‘ชฺ้าง ทื่อม่าง จา แง กงา น่อง เวอ ลือ แง, ยา กงา ล่อบ่าปา ฮื่อ แง, ไม้ ยา กงา บ่าเกิ่ด ฮู่ เวอ ย้า จี่วีดแต่จา ชี’ แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","กงา บ่าแบ ยา อ่าซ่าง แน. ยาว กงา อิสราเอลชฺ้าง อือนา ล้างตือพิธีบัพติศมา ฮา ปี่ นี้ย่า, ไม้ ยองนา ฮา แบ ปี่ แง, ยา อ่าซ่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ยาว ยอห์น นี้แม้แน ม่า แล่ชี่, “กงา มย้าง แอ พาจาว มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ม้า ฮาย่า อางป่อน แม้แน แต่ง แล่ยาว ยางก้อง ปย้าม แป่ก ลือ ชีแน. ");
INSERT INTO bzi_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","กงา บ่าแบ ค่าพ่าย่า นี้ม้า อ่าซ่าง แน, จ้า พาจาว กงานา ม่า ชฺ้าง อือนา ล้างตือพิธีบัพติศมา ฮา ปี่ ล่าชี่ ม้า กงานา นี้แม้แน ม่า ล่าง, ‘อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง อ่าซ่าง ก้อง ดื้ง ลือ แง, แฮ้มาง ย้าเป อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง ไจ ชฺ้าง อือนา พิธีบัพติศมา ฮา ปี่ ฮู ม้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","กงา อางเลิ่ง นี้เลิ่ง ตอล้า ชี นี้งนา กงา แมนือ นี้ง ย้า มย้าง แอ, แน กงา นี้แม้แน อางจี่ กงากา, ‘ค่าพ่าย่า นี้ม้า พาจาว มาง อางย่า’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","น่องนืง โย้เวอ ยอห์น ยาง ศิษย์ 2 คู่น มาง เย่ด ก้อง ทื่งกง่า แน จูง ชี. ");
INSERT INTO bzi_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ยาว พระเยซู ย่อ ไก แล นา มย้าง เมอ ยาง มือ นี้แม้แน จี่ ชีเย, “แฮ! แฮ้มาง มา พาจาว มาง แกะอางย่า ม้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ยาว ศิษย์ 2 คู่น มาง เย่ด แฮ้แม้แน กงากย่า ยาว เย่ด พระเยซู ก้อง ย่อ เค่ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","พระเยซู น่องน่อง เวอ พลาบ ฮู ยาว เย่ด ย่อ เค่ ล้า นา มย้าง เมอ นี้แม้แน น้าน ชี, “บ้าเจอ ซฺ้า กว่า แง?” แน. เย่ด มือ นี้แม้แน นาย ชี, “อ่าจาน เวอ, นา ล้อเกิ้ง ดื้ง แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","พระเยซู มือ นี้แม้แน พอ ชี, “เค่ ฮูย ล้า ปาว” แน. เย่ด มือ ยาง จาดื้งย้า เวอ เค่ แลน ชี. แฮ้ญ่าม เมอ 4 โมง มู่งคี่ล้าก้า เย. นี้แม้แนยาว แฮ้ นืง ทื่อนืง ปลื้ง ย้าเย่ เย่ด พระเยซู ก้อง ทื่งกง่า แน ดื้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ชฺ้าง 2 คู่น โย้เวอ ชฺ้าง ทื่อม่าง มาง อางเม้ง แฮ้ย่า อันดรูว์ แน เย. อันดรูว์ เมอ อางอ้าย จา แง, ยาง อางอ้าย มาง อางเม้ง ซีโมนเปโตร แน เย. ");
INSERT INTO bzi_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ต่องก่า เวอ อันดรูว์ ฮา ชี แฮ้ย่า ซฺ้อก แน ยาง อางอ้าย ซีโมน มางนา ซฺ้า แอ ยาว นี้แม้แน ม่า แอ ชี, “กงา พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ ชี่ มางนา มย้าง ยา!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ยาว อันดรูว์ มือ ซีโมน นา ซฺื่ย พระเยซู นา ซฺ้า แล ชีเย. ยาว พระเยซู ซีโมน นา มย้าง เมอ ยางนา นี้แม้แน จี่ช่าง ชี, “นา ยอห์น อางย่า มาง อ่าลา? ชฺ้าง อือ กาญ่าม เวอ นางนา เคฟาส แน ฮ้าว ล่าง เป.” แน. (เคฟาส นี้ย่า ลอบา นา ฮา แง. เปโตร ลอบา นา ฮา แฮ้งแม้แน ย้า.) ");
INSERT INTO bzi_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","น่องนืง ม้า พระเยซู กาลิลี แควน โย้เวอ แลน ชี. ยาว ฟีลิป นา มย้าง แล ชี. ยาว ยาง ฟีลิป นา นี้แม้แน จี่ช่าง ชี, “กงาก้อง เค่ ล้าน โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ฟีลิป ย่า อันดรูว์ แน เปโตร เย่ด แม้แน ย้า เบธไซดา อางเมิง เวอ จายล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ยาว ฟีลิป นาธานาเอล นา มย้าง เมอ ยาง มือ นี้แม้แน ม่า ชี, “กงา โมเสส แน พาจาวจี่ต่างจี่แต่นฮู อือ ชฺ้าง แต้ม เคอ ชี มางนา กงา มย้าง ยา, ยาง อางเม้ง เยซู แน, ยา นาซาเร็ธชฺ้าง แน ยา โยเซฟ อางย่า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","แฮ้งเย่ นาธานาเอล มือ นี้แม้แน ฟีลิป นา น้าน ชี, “นาซาเร็ธ ค่อง โย้เวอ บ้าเจอ อางเกิ่ง อางแม่น จายล้า กงากา แง?” แน. ยาว ฟีลิป มือ นี้แม้แน จี่พอ ชี, “เค่ ฮู ลือ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ยาว พระเยซู นาธานาเอล อ้องล้า นา มย้าง ยาว ยาง นี้แม้แน จี่ เย, “นู้เวอ จาน ญา, อิสราเอลชฺ้าง ม้าม้า อางซืออางปลอง ม้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","แฮ้งเย่ นาธานาเอล มือ พระเยซู นา นี้แม้แน น้าน ชี, “นา กงานา ล้อแม้ แบ ล่า กงากา แอ?” แน. ยาว พระเยซู มือ นี้แม้แน จี่พอ ชีเย, “กงา นางนา มย้าง ล่าแอ่ นาง ซื่อไค่มี้ล่อก ป่าง ต่องก่า ดื้ง จา เมอ, ฟีลิป นางนา บ่าฮ่าว ล่า เมอ ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","แฮ้งเย่ นาธานาเอล นี้แม้แน จี่พอ ชี, “อ่าจาน เวอ, นา พาจาว อางย่า มาง แน อิสราเอลชฺ้าง อือ ก่าซ้าด มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ยาว พระเยซู นี้แม้แน จี่ ชีเย, “นาง กงานา เจ่อ ล่าชี่ นี้ย่า, ไม้ กงา นางนา ซื่อไค่มี้ล่อก ป่าง ต่องก่า โย้เวอ มย้าง ล่าชี่ แฮ้ง ปาปาย อ่าลา? นา อางเลิ่ง อางฮื่อ นี้ล่อบ่าปา กงา มย้าง แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงา นองนา อางเลิ่ง ม้าม้า ม่า แบ ปี่ ล่าว่า, มู่งท่า แฮ้ง พอง อ่อกล้า ยาว นองมู นี้ย่า พาจาว มาง เท่วาด่า อือนา, กงาชฺ้างอางย่า เพล่อ ชี นี้มาง ล้าก้า นู้เวอ ลู่งลู่ง ตาตา แน ฮา นา กงามย้าง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ยาว 3 นืง จายล้า แล่ ยาว คานา ค่อง กาลิลี แควน โย้เวอ ค่าบาล่า แง. พระเยซู อางบา มาง มือ ค่าบาล่า โย้ คาตา จา แง. ");
INSERT INTO bzi_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","พระเยซู แน ยาง ศิษย์ อือนา คาตา เย ค่าบาล่า นู้ ป้า ลือ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ยาว อ่างู่น แต่ค่า ย้าง โค คายาว พระเยซู อางบา มาง มือ พระเยซู นา นี้แม้แน จี่ช่าง ชี, “อ่างู่น แต่ค่า ย้าง โคน ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","จ้า พระเยซู ยาง อางบา มางนา นี้แม้แน จี่พอ ชี, “อ่าบา เวอ, กงานา เจิ้นเจ้อ บ่าม่า ฮา ปี่ ล่า แอ แคน โจ. อามื้อ กงา ชฺ้าง อือนา ล่าที่ ฮา มย้าง ปี่ ญ่าม ย่าง บ่าเคอ กาซื้ง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","แฮ้งเย่ พระเยซู อางบา มาง ย่าเจ่น อือนา นี้แม้แน ม่าย แอ ชี, “ยาง ล้อแม้ ม่า ล่าง แฮ้แม้ ฮา เค่ คู ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ยาว โย้เวอ ม้ออู้ง อางแอ่ 6 ซื่อ จา เย. ม้ออู้ง นี้ย่า ลอบา ไจ แต่ง ชีเย. ม้ออู้ง กาซื่อ กา นี้ ล้าง 100 ลิตร นี้งล่อซฺ่า กาเย กาน กงาแง, แน ยิวชฺ้าง อือ พิธีล้างชี่ฮาเซฺิ่งซฺ้างปี่ง แฮ้ง ฮา เมอ ไจ เย. ");
INSERT INTO bzi_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ยาว พระเยซู มือ ย่าเจ่น อือนา นี้แม้แน ม่า เย, “ม้ออู้ง โย้เวอ ล้าง ปลื้ง แน ค้าม กาน คู ปาว” แน. ยอง มือ ม้ออู้ง โย้เวอ ปลื้ง ย้าเย่ ล้าง ค้าม กาน คู ชี. ");
INSERT INTO bzi_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ยาว พระเยซู มือ นี้แม้แน ม่าย ชี, “ล้าง นี้ง ล่ากานฮูพลาฮู อือนา คู่ย ซฺาแล ปาว” แน. แฮ้งเย่ ย่าเจ่น อืมมือ ล่ากานฮูพลาฮู อือนา ล้าง ย้าง คู่ย ซฺาแล ชี. ");
INSERT INTO bzi_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ยาว ชฺ้าง ล่ากานฮูพลาฮู มาง ล้าง อ่างู่น แต่ค่า เพล่อ ชี แฮ้ง กงา ต้าง ยาว ยาง มือ เจ้าบ่าว มางนา นี้แม้แน ฮ้าว ม่าย ชี. (ยา บ่าแบ เย อ่างู่น แต่ค่า นี้ย่า ล้อเกิ้ง จายล้า ชี แน. ย่าเจ่น ล้างค้าม แอ ชี อือ ญาเย่ อางแบ คู แน.) ");
INSERT INTO bzi_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“ฮากย่า แต่ค่า อางแม่น แฮ้ง อางด่า โย้เวอ ชฺ้าง ล้า คูชี อือนา ต้าง ม่าว ปี่ เปิน แง. ยาว น่อง เวอ แต่ค่า อางฮู่ อางอี แฮ้ง ฮ้าน ซู แอ แง. จ้า นา แต่ค่า อางแม่น แฮ้ง อามือ เคอ ย้า กอย ชี ชี!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","นี้ย่า พระเยซู อางเลิ่งชฺ้างบ่าฮาตอกางอือ ต่องก่าต่าง ฮา ชีย้าง ย้าเย่, ยาง คานา ค่อง กาลิลี แควน โย้เวอ ดื้ง เมอ, ยาง ศิษย์ อืม พระเยซู นา นืงบาชี คู ชีเย, ไม้ ยาง ล่าที่ อางฮื่อ แฮ้ง กงามย้าง ชี แฮ้ง ปาปาย. ");
INSERT INTO bzi_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","โย้ จายล้า แล่ ยาว พระเยซู มือ ยาง อางบา แน ยาง อางแพ้ แน ยาง ศิษย์ อือก้อง ทื่งกง่า แน คาเปอรนาอุม อางเมิง โย้เวอ แอน ชีเย, จ้า โย้เวอ อางมล่าง แน บ่าดื่ง เย. ");
INSERT INTO bzi_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ปัสกาป่อยนืง ชา เคิน ล้า ยาว พระเยซู มือ เยรูซาเล็ม อางเมิง เวอ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ยาว ชฺ้าง อ่ามย่าง ก่อง อือ, แกะ ก่อง อือ, ฮาย่า อางป่อน ก่อง อือ แน ชฺ้าง พลู้ เพ่น ปี่ง อือนา โบสถ์อางฮื่อ กองโค้ง โย้เวอ ดื้ง จา นา มย้าง แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","พระเยซู ล่าตื่อ ย่าง ไจ ชฺ้าง แฮ้อือนา ชืก ก่า ฮื่น ปี่ชี่ เย. ยาว อ่ามย่าง แน แกะ อือนา โบสถ์อางฮื่อ อางเง้ โย้เวอ ก่า อ่อกแอ ปี่ชี่. ยาว ชฺ้าง พลู้ เพ่น อือ พลู้ ย่าง ท่อก วี ยาว ยอง โต ย่าง ต่าน เลิง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ยาว พระเยซู มือ ชฺ้าง ฮาย่า อางป่อน ก่อง อือนา นี้แม้แน ม่า ชี, “ฮ้าน อ่อกแอ โค โว! พาจาว กงา อางโบ้ง มาง ยู้ม นี้งนา ก้าด บ่าฮา เพล่อ ปี่ โจ!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","แฮ้งเย่ ศิษย์ อืม พระคัมภีร์ โย้เวอ จี่ต่าง แต้ม ชี ชี แฮ้ง เย้ง กงาแล่ คูชี. พระคัมภีร์ โย้เวอ นี้แม้แน แต้ม ชี ชี, “กงา พาจาว มาง ยู้ม นา ลาก นี้ย่า กงานา ฮา นืงบาต่องลาบ้าบ ปี่ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ยิวชฺ้าง ยอคา อืม พระเยซู นา นี้แม้แน น้า คูง เย, “นา บ้าเจอฮาย แฮ้แม้ ฮา แง? กงูนา ฮา มย้าง ปี่ ล่า ปาว, นาย่า พาจาว มางก้อง ม้าม้า ย้า ล่าที่ กงาย จาย ลือ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","แฮ้งเย่ พระเยซู มือ นี้แม้แน จี่พอ ชี, “โบสถ์อางฮื่อ นี้ง พยา โว! ยาว กงา 3 นืง ญา อางซฺื่อ แต่ง เปิน ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ยาว ยิวชฺ้าง ยอคา อืม นี้แม้แน จี่ คูง เย, “โบสถ์อางฮื่อ นี้ง แต่ง เปิน ชี นี้ย่า อางญ่าม 46 ปี ไจ แต่ง ชี. ยาว นา เย้ง ล่า 3 นืง นู้เวอ อางซฺื่อ แต่ง เปิน ปี่ ยาว อางกงา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","จ้า โบสถ์อางฮื่อ พระเยซู จี่ เคอ แฮ้ ยาง อางโต แฮ้งนา ฮา จ่าแล่ง เย. ");
INSERT INTO bzi_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","พระเยซู ซฺี้ ยาว ว่านที่ 3 เวอ แต่ล้า แล่ เมินญา เย, ยาง ศิษย์ อืมมือ เย้ง กงาแล่ คูชี, พระเยซู นี้แม้แน อางจี่ กางซื้ง ย้า แน. แฮ้งเย่ ยอง พระคัมภีร์ แน พระเยซู จี่ต่าง แฮ้งนา เจ่อ คูชี. ");
INSERT INTO bzi_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","พระเยซู เยรูซาเล็ม อางเมิง ดื้ง เมอ แฮ้ญ่าม เวอ ปัสกาป่อยนืง เย, ยา อางเลิ่งชฺ้างบ่าฮาตอกางอือ อางบย่า เย ฮาย ตอล้า ปี่ชี่. แฮ้งเย่ ชฺ้าง อางบย่า แน ยางนา เจ่อ ล้า คูชี. ");
INSERT INTO bzi_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","จ้า พระเยซู มือ ยองนา นืงบาบ่าชี่ เย, ไม้ ยา ชฺ้าง คาโคลาโค อือนา อางแบ กงากา เย. ");
INSERT INTO bzi_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ชฺ้าง อางเลิ่ง นี้ย่า อ่าซ่าง มาง ยางนา บ่ากงา ม่า คา, ไม้ ยา ชฺ้าง อือ ก่ามกืด แฮ้งนา อางแบกงากา. ");
INSERT INTO bzi_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ค่าพ่าย่า ทื่อม่าง จา แง อางเม้ง นิโคเดมัส แน, ยา ฟาริสี อางมู เย, แน ยา สภาแซนฮีดริน โย้เวอ สมาชิก ทื่อม่าง มาง เย. ");
INSERT INTO bzi_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ยา มู่งคี่ โย้เวอ พระเยซู นา ซฺ้า แล ชีเย, แน นี้แม้แน จี่ ชีเย, “อ่าจาน เวอ, กงู อางแบ คูย้า, พาจาว มาง นางนา ซฺาลือ ปี่ ล่าชี่ นี้ย่า กงูนา ม่าอู่บ ลือ ปี่ ล่าแง แน, ไม้ อ่าซ่าง มาง อางเลิ่งชฺ้างบ่าฮาตอกางอือ บ่าฮากงากา, นาง ฮา ชี แฮ้งแม้แน. พาจาว มาง ชฺ้าง แฮ้ มางก้อง ดื้ง เมินญา, ชฺ้าง แฮ้ม้า ฮาย กงากา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","แฮ้งเย่ พระเยซู มือ นี้แม้แน จี่พอ ชี, “กงา อางเลิ่ง ม้าม้า ม่า แบ ปี่ ล่าว่า, ชฺ้าง อางซฺื่อ บ่ากงา เกิ้ด อือ พาจาวอางเมิง แฮ้งนา บ่ากงา มย้าง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ยาว นิโคเดมัส มือ พระเยซู นา นี้แม้แน น้าย ชีเย, “ชฺ้าง อางค่อ นี้ย่า บ้าเจอล้อแม้ อางซฺื่อ เกิ้ด แล่แน, อางบา ป่องปอง โย้เวอ ทื่อเทอ อ้องแล อางซฺื่อ เกิ้ด แล่ ยาว อางกงาย ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","พระเยซู มือ นี้แม้แน จี่พอ ชีเย, “กงา อางเลิ่ง ม้าม้า ม่า แบ ปี่ ล่าว่า อ่าซ่าง ล้าง แน อางค่องอางล้า อางเซฺิ่งอางซฺ้าง โย้เวอ บ่ากงา เกิ้ด ล้า แง, พาจาวอางเมิง โย้เวอ บ่าอ่อง แล กงากา แน. ");
INSERT INTO bzi_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","กงู อางบา อางโบ้ง ก้อง เกิ้ด ลือ ชี นี้ย่า กงู ชฺ้าง อางย่า เพล่อ กาน แง. จ้า พาจาว มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ม้า กงูนา ฮาย พาจาว มาง อางย่า เพล่อ ปี่ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ยาว นา กงา นางนา นี้แม้แน ม่า ล่า ชี่ นี้งนา นืงบาบ่าม่าน โจ! ‘นอ อางซฺื่อ เกิ้ด แล่ คูโว’ แน. ");
INSERT INTO bzi_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ฮ้างม้าน นี้ย่า ล้อเกิ้ง เวอ ตอแอ ซี้ แง, โย้เวอ ย้า ตอแอ แง. นา ฮ้างม้าน อางเซง กงากย่า แง. จ้า นา บ่าแบ ล้อเกิ้ง จาย ตอล้า ชี, แน ล้อเกิ้ง เวอ ตอแอ แงแน. ทื่อช่างกานญา นา บ่าม่า กงากา, ชฺ้าง นี้ย่า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มางก้อง บ้าเจอล้อแม้ อางซฺื่อ เกิ้ด กงากา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ยาว นิโคเดมัส นี้แม้แน น้าน ชีเย, “อางเลิ่ง นี้อือเจ้อ บ้าเจอล้อแม้ ตอล้า กงากา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","พระเยซู มือ นี้แม้แน จี่พอ ชีเย, “นาย่า อ่าจาน, นางนา อิสราเอลชฺ้าง อือ นาบทื้อ ล่า คูแง, จ้า นา อางเลิ่ง นี้ อือนา บ่าแบ กาซื้ง ลา? ");
INSERT INTO bzi_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","กงา อางเลิ่ง ม้าม้า ม่าแบ ปี่ ล่าว่า, กงาย่า อางเลิ่ง กงากย่า กงามย้าง ล้า ชี อือ นางนา อู่บน้า ปี่ ล่าย่า. จ้า นองมู นี้ย่า กงา ม่า ล่าง แฮ้งนา บ่าเจ่อ คู. ");
INSERT INTO bzi_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ซ้ามบา กงา นองนา ชฺ้างอางเมิง นู้เวอ อางเลิ่ง แฮ้ง อู่บน้า ปี่ ล่าเวิม, นอ กงานา บ่าเจ่อ ล่าคู. ท้าว กงา นองนา มู่งท่า อางเลิ่ง แฮ้ง อู่บน้า ปี่ ล่ายาว นอ กงานา อางเจ่อ ไล่ลา? ");
INSERT INTO bzi_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","อ่าซ่าง มาง มู่งท่า โย้เวอ บ่าตา แล กางซื้ง, ชฺ้างอางย่า มู่งท่า เวอ จายลือ ชี มางญา มู่งท่า เวอ อางตา แล กางซื้ง แน, กงาย่า ชฺ้างอางย่า มาง ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ค้าแต้ เวอ อิสราเอลชฺ้าง อือ ซ่องก่องอางเว่อ โย้เวอ ดื้ง เมอ, ยองนา อื้อล้าง อางปีด ดอก ชี. ยาว พาจาว มาง โมเสส นา อื้อล้าง ทองสัมฤทธิ์ ไจ แต่ง ชี แฮ้ง ล่าไม ท่า โย้เวอ โญก ชี ปี่ชี่, ไม้ ชฺ้าง อื้อล้าง ฮู่บปาน มางนา ฮู ชี อือนา จี่วีด ปูน ปี่ แง แนนอ. ยาว ทื่อช่างกานญา เป กงาชฺ้างอางย่า แฮ้มางนาม แฮ้แม้แน ย้า ล่าไม ท่า เวอ กงา โญก ชี แง. ");
INSERT INTO bzi_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ไม้ ชฺ้าง คาโคลาโค กงานา เจ่อ ล่าคูชี อือนา พาจาว มางก้อง จี่วีดม้าม้า กงาจา แล ปี่ แง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“แน พาจาว ม้า ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา นาบาตา ลาก แง, แฮ้งย้า ยาง อางย่า ลาก มางนา แน ยาง อางย่า ทื่อม่าง แน จา มางนา ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา ปี่ ชี, ไม้ ชฺ้าง คาโคลาโค กงานา นืงบาชี ล่า คูชี อือนา ล่าลูก บ่าปี่ กลา, แน ยองนา จี่วีดม้าม้า กงาจา แล ปี่ แง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","พาจาว มาง ยาง อางย่า มางนา ชฺ้างอางเมิง นู้เวอ ลือ ปี่ชี่ นี้ย่า, ชฺ้าง อือนา อางซี ต้าดต่อน ลือ ปี่ แง บ่าอ่า, จ้า ชฺ้าง อือนา อางบล่าบ ปล่องปูน ลือ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“อ่าซ่าง กงานา นืงบาชี ล่าแง, พาจาว ม้า ชฺ้าง แฮ้มางนา อางซี บ่าต่าดบ่าต่อน. จ้า อ่าซ่าง กงานา นืงบาบ่าชี่ ล่าแง, พาจาว ม้า ชฺ้าง แฮ้มางนา อางซี ต้าดต่อน แง, ไม้ ยอ พาจาวอางย่า มางนา นืงบาบ่าชี่ คูวา. พาจาวอางย่า นี้ม้า พาจาว มาง อางย่า ทื่อม่าง แน จา มาง ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ยาว นี้ย่า อ่าซ่าง อางซี แน บ่าซี แน พาจาว มาง ต้าดต่อน ย้าง เป. ชฺ้างอางเมิง นู้เวอ อางแปล้นอางซ้า อ้องล้าน ญา. จ้า ชฺ้าง นี้ย่า อางวื้งอางว้าง แฮ้งนา อางแปล้นอางซ้า ล่อบ่าปา ลาก คูแง, ไม้ ยอ บ่าแม่น ฮา คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ชฺ้าง คาโคลาโค อางซี ฮา คูชี อือย่า อางแปล้นอางซ้า นา เม้อ คูแง, แน ยอ อางแปล้นอางซ้า โย้เวอ บ่าอ่องล้า คู, ไม้ อางแปล้นอางซ้า แฮ้ง ยอง อางเลิ่ง บ่าแม่น ฮา ชี แฮ้ง ฮาย มย้าง ปี่ นา วาม นอ. ");
INSERT INTO bzi_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","จ้า ชฺ้าง อางแม่น ฮา คูชี อือ อางแปล้นอางซ้า โย้เวอ อ้องดื้ง ล้า คูแง, ไม้ ชฺ้าง คาโคลาโค อือนา มย้าง ปี่ง น้อ, ยองมู นี้ย่า พาจาว มาง นืงบาจาบวา ย้า ฮา คูแง แน.” ");
INSERT INTO bzi_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","น่อง โย้เวอ พระเยซู แน ยาง ศิษย์ อืม ยูเดีย แควน โย้เวอ อ้องแลน คู ชีเย. ยาว พระเยซู ยาง ศิษย์ อือก้อง ทื่งกง่า แน โย้เวอ ดื้ง ชีเย. ยาว พระเยซู ค่องช่าง อือนา ล้างตือพิธีบัพติศมา ฮา ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","แฮ้ญ่าม เมอ ยอห์น ชฺ้าง อือนา อายโนน ค่อง แน สาลิม ค่อง ก่องทาง โย้เวอ ล้างตือพิธีบัพติศมา ฮา ปี่ แง, ไม้ โย้เวอ ล้าง อางบย่า จา แง. แฮ้งย้า ชฺ้าง อืม ยอห์น ก้อง ล้างตือพิธีบัพติศมา ฮา แล่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","นี้เลิ่ง ยอห์น คอก เวอ บ่าอ่อง กาซื้ง เมอ ตอล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ทื่อนืง จา แง ยอห์น ศิษย์ อือ ยิวชฺ้าง ทื่อม่างนา อางโต ชี่ปู อางลี้บอางล่าว อางเลิ่ง แฮ้ง จี่เจ้ ช่าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","แฮ้งเย่ ยอห์น ศิษย์ อืม ยอห์น ก้อง ล้าน คูชี, แน ยอห์น นา นี้แม้แน จี่ช่าง ชี, “อ่าจาน เวอ, พระเยซู นางนา ซฺ้า ล่าเก่ย นาง พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ มาง แน ฮา มาง จอร์แดน ล้างบ้า ทื่อปล่าก ป่ากย่า ชฺ้าง อือนา อามือ ล้างตือพิธีบัพติศมา ฮา ปี่ แง, แน ชฺ้าง คาโคลาโค อืม ยางนา ซฺ้า แอ คูชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ยาว ยอห์น มือ นี้แม้แน จี่พอ ชี, “ชฺ้าง นี้ย่า พาจาว มาง ฮา ปี่ง นี้งล่อ ญา กงาฮา แง. ");
INSERT INTO bzi_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","นอ กงา จี่ แฮ้งนา อางกงากย่า กางซื้ง ย้า นี้แม้แน, ‘กงา พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ ชี่ มาง บ่าอ่า. จ้า พาจาว มาง กงานา ซฺาลือ ปี่ ล่าออน ฮา ชี นี้ย่า, ไม้ ชฺ้าง พระเยซู นา ชา เจ่อ อือนา ซฺ้า ชี ปี่ง แนนอ’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“ยา เจ้าบ่าว แม้แน เพล่อ แง. กงา เจ้าบ่าว อางช่าง แม้แน เพล่อ แง. เจ้าสาว ม้า เจ้าบ่าว มาง เฮอ. เจ้าบ่าว แน เจ้าสาว มาง ทื่งกง่า แน ดื้ง เมอ, เจ้าบ่าว มาง ม่อนซ้า อางเซง แฮ้ง เจ้าบ่าว อางช่าง จูง จา มาง กงากย่า เมอ กย่าง แง. ทื่อช่างกานญา พระเยซู ก้อง อางเลิ่ง ตอล้า ชี แฮ้ง กงากย่า เมอ กงามมือ นาบาตา ย้า กย่าง แง. ");
INSERT INTO bzi_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","พระเยซู อางอ้าน แฮ้ง ล่อบ่าปา แน ชฺ้าง ปีนแตปีนนา เพล่อ แล แง. ยาว กงานา อ่าซ่าง มาง บ่าฮู ล่าเวิม อางกงา ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“พระเยซู มู่งท่า เวอ จาย ลู่งลือ ชี นี้ม้า กูย่างกูเจ้อ ล่อบ่าปา ฮื่อ แง. ยาว กงา ชฺ้างอางเมิง นู้เวอ จายล้า ชี นี้ม้า ชฺ้างอางเมิง นู้เวอ อางเลิ่ง นี้ง แอ่ญา จี่เคอ แง, แน กงา ชฺ้างอางเมิง นี้มาง ชฺ้าง เป. ");
INSERT INTO bzi_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","พระเยซู ยาง อางเลิ่ง กงากย่า กงามย้าง ชี อือ อู่บน้า ปี่ ล่าง. จ้า ชฺ้าง ยางนา เจ่อ อือย่า บ่าบย่า. ");
INSERT INTO bzi_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","จ้า อ่าซ่าง ยาง อางเลิ่ง ม่า ชี แฮ้งนา เจ่อ แง, ชฺ้าง แฮ้ม้า อางเจ่อ ย้า พาจาว ม้า อางเลิ่ง ม้าม้า จี่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ไม้ พาจาว มาง ซฺาลือ ปี่ชี่ นี้ม้า พาจาว มาง จี่ แฮ้งแม้แน จี่ เค่ แง, แน พาจาว ม้า ยางนา อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง ปลื้ง แน จา ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","พาจาว ม้า ยาง อางย่า มางนา ลาก แง, แน ยางนา กูย่างกูเจ้อ อือนา ฮูพลา ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","อ่าซ่าง พาจาวอางย่า มางนา เจ่อ แง, ยา พาจาว มาง ก้อง ทื่งกง่า แน จี่วีดม้าม้า กงาจา แล แง. จ้า อ่าซ่าง พาจาว มาง อางย่า มางนา บ่าเจ่อ แง, ยา จี่วีดม้าม้า แฮ้งนา บ่ากงา มย้าง เป, แน พาจาว ม้า ชฺ้าง แฮ้มางนา วี่บ่ากไจ ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","พระเยซู ชฺ้าง อือนา ล้างตือพิธีบัพติศมา ฮา ปี่ แง, แน ยา ยอห์น ล่อบ่าปา ศิษย์ จา แงแน ฟาริสี มู อือ กงากย่า ชีเย. ยาว พระเยซู ฟาริสี มู อือ ยาง อางเลิ่ง แฮ้ง กงากย่า ชี แน แบน เมอ. ");
INSERT INTO bzi_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(จ้า ม้าม้า นี้ย่า พระเยซู ชฺ้าง อือนา ล้างตือพิธีบัพติศมา ฮา ปี่ แฮ้ง บ่ากงา ฮา ปี่ เย. จ้า ยาง ศิษย์ อือ ฮา ปี่ เย.) ");
INSERT INTO bzi_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","แฮ้งย้า พระเยซู มือ ยูเดีย แควน โย้เวอ จาย แก้บ้า ย่อ กาลิลี แควน โย้เวอ พ่าวแลน แล่ชี่. ");
INSERT INTO bzi_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","จ้า ยา สะมาเรีย แควน โย้เวอ กงาย่อ ไก แล แง. ");
INSERT INTO bzi_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ยาว ยางมือ สิคาร์ ค่อง สะมาเรีย แควน โย้เวอ เคินแล ชี. สิคาร์ ค่อง แฮ้ย่า ค้าแต้ เวอ ยาโคบ ตี โยเซฟ ยาง อางย่าย่าค่า มางนา ปี่ ชี โย้ อางแท้ เย. ");
INSERT INTO bzi_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","แน โย้เวอ ยาโคบ ล้างบ้อ ย้าง จา เย. พระเยซู แก้บ้า ย่อย ล้า เว่อ คายาว เมิ่ด ชีเย, แฮ้งเย่ ล้างบ้อ ก่องทาง โย้เวอ ดื้งซ่าว ชี, แฮ้ญ่าม เวอ นืงก้องฮ่างจฺ่าญ่าม เย. ");
INSERT INTO bzi_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ยาว สะมาเรียชฺ้าง ค่าบาย่า ทื่อม่าง ล้างบ้อ โย้เวอ ล้างค้าม ลือ ชีเย. แฮ้งเย่ พระเยซู มือ ค่าบาย่า มางนา จี่ช่าง ชี นี้แม้แน, “กงานา ล้างต้าง ปี่ ล่าวแล” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","แฮ้ญ่าม เมอ พระเยซู ทื่อม่าง ญาเย่ จา แง, ไม้ ยาง ศิษย์ อือ ค่องคล่าว โย้เวอ จฺ่าเกิ่ง วื่น แล คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ยาว สะมาเรียชฺ้าง ค่าบาย่า มาง นี้แม้แน จี่พอ ชีเย, “นา ยิวชฺ้าง กงา สะมาเรียชฺ้าง ท้าว นา บ้าเจอฮาย กงาก้อง ล้าง ป้า ต้าง ล่าแง?” แน. (ไม้ ยิวชฺ้าง นี้ย่า สะมาเรียชฺ้าง นา บ่าซฺ่าบ่ามี่ช่าง เย.) ");
INSERT INTO bzi_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ยาว พระเยซู ค่าบาย่า มางนา นี้แม้แน ม่า ชีเย, “พาจาว ม้า นางนา บ้าเจอ ปี่ ล่า ซี่ แง, แน กงา นางนา ล้าง ป้า ต้าง ล่า ชี่ นี้ม้า อ่าซ่าง แน นาง แบน ยาว, นา กงานา อางป้า ล่า นาตู้, ยาว กงาม นางนา ล้าง จี่วีด ปี่ ล่าง แฮ้ง ปี่ ล่าแน” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ยาว ค่าบาย่า มาง นี้แม้แน ม่า ชีเย, “เจ้านาย เวอ, ล้างบ้อ นี้ย่า อางน่า เป, แน นาง เมอ นามทูง บ่าจา, ท้าว นา ล้าง จี่วีด ปี่ แฮ้ง ล้อเกิ้ง เวอ ยู้ย ฮ้านล้า แง? ");
INSERT INTO bzi_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","นา ยาโคบ กงู อางฮู่ มาง ล่อบ่าปา ล่า ฮื่อ แง? ยาโคบ กงูนา ล้างบ้อ นี้ง ปี่ ล่าชี่ มาง ย้า. ยาโคบ อางโต แน ยาง อางย่าอางคย้า อางอ่านอางซฺื้อ แน ยาง ซ้าด อืม ล้างบ้อ นู้เวอ ล้าง นี้งย้า ต้าง คู แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ยาว พระเยซู มือ นี้แม้แน จี่พอ ชีเย, “ชฺ้าง คาโคลาโค ล้างบ้อ นู้เวอ ล้าง ต้าง คูชี อือ ล้างแบ่ แล่ คูแง เป. ");
INSERT INTO bzi_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","จ้า อ่าซ่าง กงา ล้าง ปี่ ชี แฮ้ง ต้าง แง, ยา ล้าง บ่าแบ่ แล่ก้าน, ไม้ กงา ล้าง ปี่ชี่ แฮ้ย่า ยาง อางโต คล้าว โย้เวอ ล้างบ้อ เพล่อ แง, แน ยา พาจาว มางก้อง ทื่งกง่า แน จี่วีดม้าม้า กงาจา แล แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ยาว ค่าบาย่า มาง พระเยซู นา นี้แม้แน จี่ช่าง ชีเย, “เจ้านาย เวอ, กงานา ล้าง แฮ้ง ต้าง ปี่ ล่า ปาว! ไม้ ล้าง บ่าแบ่ แล่ก้าน แนนอ, แน นู้เวอ บ่ากงา พ่าว ลือ ล้างค้าม แล่ก้าน แนนอ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ยาว พระเยซู ค่าบาย่า มางนา นี้แม้แน ม่า ชีเย, “นางบล้อง นา แล ฮ้าว แลยาว นู้เวอ ซฺื่ยลืน โว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ยาว ค่าบาย่า มาง พระเยซู นา นี้แม้แน ม่า ชีเย, “กงา อางบล้อง บ่าจา นอ” แน. ยาว พระเยซู มือ ยางนา นี้แม้แน ม่าย ชีเย, “โอ่ย! นา อางบล้อง บ่าจา แน นาง จี่ นี้ง อางกง่า ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","นาง จี่ นี้ย่า อางเลิ่ง ม้าม้า ย้า, ไม้ น้า อางบล้อง ยู้ย ล้า 5 คู่น เคิน ญา, ยาว อามือ ค่าพ่าย่า นางก้อง ทื่งกง่า แน ดื้ง ม้า นาง อางบล้อง บ่าอ่า, ไม้ นา ยาง นา ค่าบาบ่าล่า ช่าง กาซื้ง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ยาว ค่าบาย่า มาง นี้แม้แน ม่า ชีเย, “เจ้านาย เวอ, กงา อางเจ่อ ย้า นา พาจาวจี่ต่างจี่แต่นฮู แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","กงู อางฮู่ อางพี่ อือ ตาแซ้ นี้ซื่อ ก้องเวอ พาจาว ไว้ คูแง. จ้า นองบ่า ยิวชฺ้าง อือ นี้แม้แน จี่ คูง, ‘พาจาว ไว้ นี้ย่า เยรูซาเล็ม อางเมิง โย้เวอ ญา ไว้ แง’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ยาว พระเยซู มือ ค่าบาย่า มางนา นี้แม้แน ม่า ชีเย, “กงานา เจ่อ ล่าปาว! บ่ามล่าง ยาว พาจาว กงา อางโบ้ง มางนา ตาแซ้ นี้ซื่อ ก้อง แน เยรูซาเล็ม อางเมิง โย้เวอ ไว้ นี้ย่า อางเลิ่ง ปีนแตปีนนา บ่าอ่า กาน. ");
INSERT INTO bzi_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ม้าม้า นี้ย่า นองบ่า สะมาเรียชฺ้าง นี้ย่า นอง พาจาว ไว้ แฮ้มางนา บ่าแบกงากา. จ้า กงูบ่า ยิวชฺ้าง นี้ย่า กงู พาจาว ไว้ แฮ้มางนา อางแบกงากา ย้า, ไม้ พาจาว ม้า ยิวชฺ้าง อือนา ไจ ชฺ้าง อือ อางบล่าบ ปูน อางเลิ่ง แฮ้ง ป่าว ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ยาว อางญ่าม แฮ้ย่า แท้ ลือ ชา เคิน ญา เป, แน อามื้อ ย่า ชฺ้าง อือ พาจาว กงา อางโบ้ง มางนา ม้าม้า แน ไว้ อางญ่าม ย่าง เคิน ญา. พาจาว กงา อางโบ้ง มางนา อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง ไจ ไว้ คูโว! แน ม้าม้า แน ไว้ คูโว! ชฺ้าง นี้อือเจ้อ นา ย้า พาจาว กงา อางโบ้ง มาง ซฺ้า ยางนา ไว้ ล่า ปี่ชี่ อือ ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","พาจาว ม้าย่า อางค่องอางล้า เป. นี้แม้แนยาว อ่าซ่าง ยางนา ไว้ แง, ชฺ้าง แฮ้ม้า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แน อางเลิ่ง ม้าม้า แฮ้ง กงาไจ ไว้ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ยาว ค่าบาย่า มาง นี้แม้แน จี่ ชีเย, “กงา อางแบ ย้า พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ มาง ฮาก พระคริสต์ แน ฮ้าว ม้า อามือ ชา ลือ แงแน, ยาว ยาง ลืน เมอ ยา กงูนา กูย่างกูเจ้อ ย้า ม่าแบ ปี่ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ยาว พระเยซู มือ ยางนา นี้แม้แน ม่า ชีเย, “นางนา อามือ จี่ช่าง ล่าง นี้ม้า พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ ชี่ มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","พระเยซู ศิษย์ อือ พ่าว เคิน ล้ายาว ยอง มือ พระเยซู ค่าบาย่า มางนา จี่ช่าง ชี แน มย้าง เมอ นืงบาม่าน คู ชีเย. จ้า อ่าซ่าง มาง นี้แม้แน บ่าน่า จอ กา เย, “อ่าจาน เวอ, นา บ้าเจอ กงาซี้ แง?” แน. บ่าอ่ายาว “อ่าจาน เวอ, นา บ้าเจอฮาย ยางนา จี่ช่าง แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ค่าบาย่า แฮ้มาง มือ อู่ล่องม่อน้าม ย่าง ชีช่า ยาว ค่องคล่าว โย้เวอ อ้องแล ชฺ้าง อือนา นี้แม้แน ม่า แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“เอ้ว! ค่าพ่าย่า กงา อางเลิ่ง กูย่างกูเจ้อ ฮายล้า ชี อือ อางแบ แน อางม่า กงากา มางนา ฮู แอ คู ป้าโน่, กาเทอกา ยา พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ มาง นาตู้” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ยาว ค่องช่าง อางบย่า ย้าเย่ พระเยซู นา ซฺ้า แอ คู ชี. ");
INSERT INTO bzi_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","แฮ้ญ่าม เมอ พระเยซู ศิษย์ อือ พระเยซู นา นี้แม้แน ป้า คูง เย, “อ่าจาน เวอ, ฮ่างจฺ่า ปาโน” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","จ้า พระเยซู ยองนา นี้แม้แน ม่า ชีเย, “กงา เมอ จฺ่าเกิ่ง นอง บ่าแบกงา กางอือ จา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ยาว ศิษย์ อืม นี้แม้แน น้าท้าม กาง เย, “อ่าซ่าง อ่าจาน นา จฺ่าเกิ่ง ฮ้าน ปี่ ล้า ชี?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","แฮ้งเย่ พระเยซู มือ ยาง ศิษย์ อือนา นี้แม้แน ม่า ชี, “พาจาว ม้า กงานา ซฺาลือ ปี่ ล่าชี่ มาง ย้า. แน พาจาว มางนา นืงบาจาบวา แน ฮา เค่ แฮ้ง แน ยาง กงานา ล่ากาน ว่า ปี่ ล่าชี่ แฮ้ง ว่าเปิน ปี่ง แฮ้ย่า กงา จฺ่าเกิ่ง ย่าง แน ทื่อช่างกานญา. ");
INSERT INTO bzi_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","นอง กอ คลา เมอ นอ นี้แม้แน จี่ คูง อ่าลา? ‘4 ลา เคิน ยาว กอแย่ญ่าม เคอ คางญา’ แน. ชฺ้าง นี้อือนา ฮู ปาว ยองมู นี้ย่า กอซฺื้อ แย่กงา กา ชีอือ ช้อด ย้า. ยอง กงานา นืงบาชี ล่าง อางญ่าม ย่าง เคิน ญา. ");
INSERT INTO bzi_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","พาจาว ม้า ชฺ้างแย่ฮู อือนา ก่ามป่อน ปี่ แง. ชฺ้างแย่ฮู อือย่า พาจาว มาง อางเลิ่ง อางแม่น แฮ้ง ป่าว อือย้า. กอแย่ กงา ชี แฮ้ย่า ชฺ้าง พาจาว นา เจ่อ ชี่ อือ ย้า. ยาว ยองมู นี้ย่า จี่วีดม้าม้า กงา คูแง. นี้แม้แนยาว ชฺ้าง กอ คลา ชี อือ แน กอแย่ คูชี อือ ทื่งกง่า แน ม่อนซ้า คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ยาว นอ นี้แม้แน จี่ คูง บ่าอ่าลา? ‘ชฺ้าง ทื่อม่าง ม้า กอ คลา แง. ชฺ้าง ทื่อม่าง ม้า กอแย่ แง’ แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","กงา นองนา กอ นอง บ่ากงา คลา แน ฮาก คลา ชี แฮ้ง ม่าย แย่ แอ ปี่ ล่าง. กอ แฮ้ ฮาก คลา แง, จ้า นอ ยอง ว่าบู้ ตอล้า ชี แฮ้ง จองไจ กงา คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","แฮ้เมิง ก้อง เวอ สะมาเรียชฺ้าง อือย่า อางอีบ่าอ่า พระเยซู นา นืงบาชี คูชี, ไม้ ค่าบาย่า แฮ้มาง จี่ต่าง แฮ้ง ปาปาย ย้า ค่าบาย่า แฮ้ม้า นี้แม้แน จี่ ชี, “ค่าพ่าย่า แฮ้ม้า กงา อางเลิ่ง กูย่างกูเจ้อ ฮายล้า ชี อือ อางแบ แน อางม่า กงากา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ยาว สะมาเรียชฺ้าง อืม พระเยซู นา อ่อกซฺ้า ลือ คู ชีเย, ยาว ยอง พระเยซู นา ป้าย ยองก้อง ทื่งกง่า แน ดื้ง ปี่ชี่ เย. แฮ้งเย่ พระเยซู มือ โย้เวอ 2 นืง ดื้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ยาว พระเยซู จี่ต่าง แฮ้ง ปาปาย ชฺ้าง อางอีบ่าอ่า เย พระเยซู นา เจ่อ คูชี. ");
INSERT INTO bzi_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ยาว อางเมิงชฺ้าง อืม ค่าบาย่า มางนา นี้แม้แน ม่าย คู ชีเย, “อามือ กงูย่า นาง จี่ต่าง แฮ้ง ปาปาย แน เจ่อ คูง บ่าอ่า เป. จ้า อามือ กงูย่า ค่าตอง น่าซื่ง นี้งย้า กงากย่า คูแอ, แน กงู อางแบ คูย้า ค่าพ่าย่า นี้ม้า ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา อางบล่าบ ปล่องปูน ปี่ฮู ม้าม้า มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","น่อง โย้เวอ 2 นืง จายล้า แล่ยาว พระเยซู มือ ยาง ค่อง อางอ้าน กาลิลี แควน โย้เวอ ย่อยแลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(พระเยซู นี้แม้แน อางจี่ กางซื้ง ย้า, “พาจาวจี่ต่างจี่แต่นฮู นี้ย่า ทื่อม่าง แนม บ่าจา ค่าตอง ค่อง เวอ ชฺ้าง อือ นาบทื้อ แงแน” แน.) ");
INSERT INTO bzi_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","จ้า พระเยซู กาลิลี แควน โย้เวอ เคิน ลือ เมอ, กาลิลีชฺ้าง อืม ยางนา แม่น ย้า ฮูพลา คูชี, ไม้ ยอ พระเยซู เยรูซาเล็ม อางเมิง เวอ ดื้ง เมอ, ปัสกาป่อยนืง โย้เวอ อางเลิ่ง คาโคลาโค ฮา ชี อือ กงามย้าง คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ยาว พระเยซู มือ คานา ค่อง กาลิลี แควน โย้เวอ ทื่อเทอ แลน แล่ชี่ เย, ค่อง นี้ค่อง พระเยซู ล้าง แฮ้ง ฮาย อ่างู่น แต่ค่า อางเพล่อ ปี่ กางซื้ง ย้า. ยาว ก่าซ้าดนาล่ากานปล่องว่าฮู ทื่อม่าง จา ชีเย, ยา คาเปอรนาอุม อางเมิง โย้เวอ ดื้ง เย, แน ยาง อางย่าย่าค่า ม้า อางม้างกย้า ชา ซฺี้ เย, ");
INSERT INTO bzi_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ยาว ยาง พระเยซู ยูเดีย แควน โย้เวอ จาย กาลิลี แควน เวอ ล้าน ชี แน กงากย่า ชีเย, แฮ้งเย่ ยาง พระเยซู ก้อง แลน ชี, แน ยาง อางย่า มางนา พ่าญ่าด ยา ล้า ล่า ปาโน แน ป้า ชีเย, ไม้ ยาง อางย่า ม้า ชา ซฺี้ ย้าง ญาเย่ จา แง. ");
INSERT INTO bzi_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ยาว พระเยซู มือ ยางนา นี้แม้แน จี่ช่าง ชีเย, “นอย่า อางเลิ่งชฺ้างบ่าฮาตอกางอือ บ่ากงามย้าง เปิน กงานา บ่าเจ่อ ล่า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ยาว ก่าซ้าดนาล่ากานปล่องว่าฮู มาง มือ นี้แม้แน ม่า ชีเย, “เจ้านาย เวอ, อางไว่ แล ปาว กงา อางย่า มาง บ่าซฺี่ ฮู่ นู้เวอ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ยาว พระเยซู มือ นี้แม้แน ม่า ชีเย, “นาง ยู้ม โย้เวอ พ่าว แลน แล่ปาว, นาง อางย่า ม้าย่า บ่าซฺี่ เป” แน. ยาว ค่าพ่าย่า มาง พระเยซู จี่ต่าง นา เจ่อ ชีเย, แฮ้งเย่ ยาง มือ ยู้ม เวอ พ่าว แลน แล่ชี่. ");
INSERT INTO bzi_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ยาว ยาง แก้บ้า ย่อย แล แล่ เมอ, ยาง ย่าเจ่น อือนา มย้าง เมอ, ย่าเจ่น อืม ยางนา ม่า แบ ปี่ชี่, ยาง อางย่า ม้า บ่าซฺี่ แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ยาง มือ ย่าเจ่น อือนา นี้แม้แน น้า ชี, “กงา อางย่าย่าค่า มาง อางม้างกย้า นี้ย่า อ้าล่อม เมอ โปยว ชี” แน. ยาว ย่าเจ่น อืม นี้แม้แน ม่า คู ชีเย, “มี้งก้อง บ่ายโมง เวอ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ยาว ย่าเก มาง อางโบ้ง มาง แบน ชีเย, อางญ่าม แฮ้ญ่าม พระเยซู ยางนา จี่ ช่าง ชีย้าง ย้าแน. พระเยซู นี้แม้แน จี่ ชีเย, “นาง อางย่า ม้า บ่าซฺี่ เป” แน. แฮ้งเย่ ยาง อางโต แน ยาง ยู้มชฺ้าง คาโคลาโค อืม มือ พระเยซู นา เจ่อ คูชี. ");
INSERT INTO bzi_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","พระเยซู ยูเดีย แควน โย้เวอ จาย แก้บ้า ย่อ กาลิลี แควน เวอ เคอ ลือ ยาว อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ชี นี้ย่า, อางเลิ่ง นี้เลิ่ง อางเลิ่ง ที่ 2 ย่าง ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","น่อง โย้เวอ จายล้า แล่ยาว ยิวชฺ้าง อือ ป่อย ญ่าม ยาง เคิน ล้า ชีเย. ยาว พระเยซู มือ เยรูซาเล็ม อางเมิง โย้เวอ แอน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","เยรูซาเล็ม อางเมิง แกะ ล้องก้อ ก่องทาง โย้เวอ ลองออง ทื่อตี่ จา เย. ลองออง แฮ้ อารเมค ต่าง นี้ย่า เบธซาธา แน ฮ้าว คูง เย. ลองออง ก่องทาง อือเมอ ศาลา 5 ล้าง จา แง. ");
INSERT INTO bzi_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ศาลา คล้าว โย้เวอ ชฺ้าง อางด้า อือ ปลื้ง ย้า ยู่ จา แง. ชฺ้าง แมปอ ชฺ้าง ล่าคื่อล่าง่อย ชฺ้าง ต่องแก่ อือ คาตา ย้าเย่ จา แง. ");
INSERT INTO bzi_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","กาเทอกา พาจาว มาง เท่วาด่า มาง ลู่งลือ ยาว ลองออง โย้เวอ ล้าง แฮ้ง ฮา เอิก ล้า ปี่ง เย. อ่าซ่าง ฮากฮู่ เวอ ลองออง คล้าว โย้เวอ ลู่ง แอออน ฮา แง. ชฺ้าง แฮ้ม้า ยาง พ่าญาด เพล่อ ชี แฮ้ง โปยว เย. ");
INSERT INTO bzi_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ยาว โย้เวอ ค่าพ่าย่า ทื่อม่าง จา เย. ยา บ่าจาบ่าดื่งบื้อ แน 38 ปี เคิน ชา เย. ");
INSERT INTO bzi_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","พระเยซู ค่าพ่าย่า แฮ้มาง ยู่ย จา นา มย้าง ยาว ยาง แบน ชีเย ค่าพ่าย่า นี้ม้า นี้แม้แน เพล่อ ล้า มล่าง กาชา แน. ยาว พระเยซู มือ ยางนา นี้แม้แน น้าน ชีเย, “นา อางโปยว ซี้ ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ยาว ค่าพ่าย่า แฮ้มาง พระเยซู นา นี้แม้แน จี่พอ ชีเย, “เจ้านาย เวอ, ลองออง โย้เวอ ล้าง แฮ้ง เอิก ล้า เมอ กงานา อ่าซ่าง มาง ลองออง คล้าว โย้เวอ บ่าซฺื่ย ลู่งแอ ล่า. อ่าจ่าม กงา ชา ลู่งแอน ยาว ฮาก ลู่งแอน ลางญา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ยาว พระเยซู มือ ค่าพ่าย่า แฮ้มางนา นี้แม้แน จี่ช่าง ชีเย, “ทานล้า ปาว ยาว แต้พู้ นี้ง กอ ยาว ย่อ แลน ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ยาว ชฺ้าง ต่องแก่ มาง ซฺ้อก ย้า ต่องแก่ ย่าง โปยว ชี. แฮ้งเย่ ยางมือ แต้พู้ ย่าง กอ ยาว ย่อย แลน ชี. แฮ้นืง ย่า ลองนืง เย. ");
INSERT INTO bzi_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ยาว ยิวชฺ้าง ยอคา อืม ค่าพ่าย่า พ่าญาด โปยว ชี มางนา นี้แม้แน จี่ช่าง ชีเย, “มี้นืง ลองนืง เป. ศาสนา อางลี้บอางล่าว แม้แน ฮาย เค่ ยาว นา มี้นืง แต้พู้ บ่าป่าย กว่า แจ นอ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","จ้า ค่าพ่าย่า แฮ้มาง นี้แม้แน จี่พอ ชีเย, “ค่าพ่าย่า กงานา พ่าญาด ยา โปยว ปี่ ล่าชี่ มาง กงานา นี้แม้แน ม่า ล่าง, ‘นาง แต้พู้ ยู่ย่า แฮ้ง กอย ยาว ย่อ แลน ปาว’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","แฮ้งเย่ ยิวชฺ้าง ยอคา อืม ค่าพ่าย่า พ่าญาด โปยว ชี มางนา นี้แม้แน น้าน คูชี, “ค่าพ่าย่า นางนา ม่า แต้พู้ ยอย ป่า ปี่ ล่ายาว ย่อย แล ปี่ ล่าชี่ ม้า อ่าซ่าง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","จ้า ค่าพ่าย่า แฮ้ม้า บ่าแบ เย. ยางนา อ่าซ่าง พ่าญาด ยา โปยว ปี่ชี่ แน, ไม้ พระเยซู โย้เวอ ชฺ้าง อางมู อือก้อง ย่อย อ้องแล ยาว โปยว ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","น่อง โย้เวอ จายล้า แล่ยาว พระเยซู ค่าพ่าย่า แฮ้มางนา โบสถ์อางฮื่อ โย้เวอ มย้าง แล่ชี่ เย. ยาว พระเยซู มือ ยางนา นี้แม้แน จี่ช่าง ชีเย, “อามือ นาง พ่าญ่าด นี้ย่า โปยว ญา. อางบล่าบ บ่าฮา แล่ก้าน โจ! นาง อางบล่าบ ฮา แล่ ยาว กาเทอกา นางก้อง อางเลิ่ง บ่าแม่น อือ อางอ้าน แฮ้ง ล่อบ่าปา ย้า ตอล้า แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ยาว ค่าพ่าย่า แฮ้มาง พระเยซู นา เจิ่กแอน ชี, แน ยิวชฺ้าง ยอคา อือนา ม่า แอ ชี, พระเยซู ยางนา พ่าญาด ยา โปยว ปี่ชี่ มาง ย้า แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","พระเยซู ลองนืง เวอ ชฺ้าง อางด้า อือนา พ่าญ่าด ยา ชี. แฮ้งย้า ยิวชฺ้าง ยอคา อืม พระเยซู นา อางเลิ่ง ซฺ้า ชี. ");
INSERT INTO bzi_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ยาว พระเยซู มือ ยองนา นี้แม้แน จี่ช่าง ชีเย, “พาจาว กงา อางโบ้ง ม้า ยาง ล่ากาน ว่า แฮ้ง บ่าซ่าว กาซื้ง. ท้าว กงา บ้าเจอฮานา ล่ากาน ว่า นี้ง ซ่าว แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","แฮ้งเย่ ยิวชฺ้าง ยอคา อืม พระเยซู นา อางเลิ่ง ซฺ้า ชา แซ่ คูแง, ไม้ พระเยซู ลองนืง อางลี้บอางล่าว ฮา ซี ชี, แน พาจาว มางนา ยาง อางโบ้ง แน ฮ้าว ชี. พระเยซู นี้แม้แน ฮา ชี นี้ย่า พาจาว มาง แม้แน ฮื่อ แงแน ฮา จ่าแล่ชี่ แน ทื่อช่างกานญา. ");
INSERT INTO bzi_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ยาว พระเยซู ยองนา นี้แม้แน จี่ช่าง แล่ชี่ เย, “กงา นองนา อางเลิ่ง ม้าม้า แฮ้ง ม่าแบ ปี่ ล่าว่า. กงา พาจาวอางย่า เพล่อ ชี่ นี้ม้า ค่าตอง นืงบาวา แน เจิ้นเจ้อ บ่าฮา กงากา. จ้า พาจาว กงา อางโบ้ง มาง อางเลิ่ง ฮา ชี่ อืนญา อางฮาย กงา แน, ไม้ อ่าโบ้ง บ้าเจอ ฮา แง, กงา คาตา ย้า แฮ้แม้แน ฮา แง. ");
INSERT INTO bzi_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ไม้ อ่าโบ้ง กงานา ลาก ล่าง. ยา ยาง อางเลิ่ง คาโคลาโค ฮา ชี อือ กงานา มย้าง ปี่ ล่าง. แน ยา กงานา อางเลิ่งชฺ้างบ่าฮาตอกางอือ อางอีบ่าอ่า ย้า ฮา แล่ ปี่ ล่าง. ยาว นี้ย่า นองนา ฮาย นืงบาม่าน ปี่ ล่าง เป. ");
INSERT INTO bzi_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","อ่าโบ้ง ชฺ้างซฺี้ แอ ชี อือนา ล้อแม้ ฮาย แต่ล้า ปี่ ชี, กงาม แฮ้แม้ ย้า ชฺ้างซฺี้ แอ ชี อือนา กงา นืงบาจาบวา แน ฮาย แต่ล้า ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ยาว อ่าโบ้ง อ่าซ่าง มางนา อางซี บ่าต่าดบ่าต่อน. จ้า ยา กงานา ชฺ้าง คาโคลาโค อือนา อางซี ต้าดต่อน ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ไม้ ชฺ้าง คาโคลาโค อือนา กงานา นาบทื้อ ปี่ ล่าง แนนอ. ยอง อ่าโบ้ง นา นาบทื้อ คูชี แฮ้งแม้แน. อ่าซ่าง กงานา บ่านาบบ่าทื่อ ล่าง, ชฺ้าง แฮ้ ม้าย่า อ่าโบ้ง นา บ่านาบบ่าทือ แน ทื่อช่างกานญา, ไม้ อ่าโบ้ง กงานา ซฺาลือ ปี่ ล่าชี่ มาง นอ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงา นองนา อางเลิ่ง ม้าม้า แฮ้ง ม่า แบ ปี่ ล่าว่า. อ่าซ่าง กงา จี่ต่าง นี้ง กงากย่า ยาว กงานา ซฺาลือ ปี่ ล่าชี่ มางนา เจ่อ แง. ยา จี่วีดม้าม้า กงาจา แล แง, แน ยางนา อางซี บ่าต่าดบ่าต่อน. จ้า ยา ซฺี้ อางเลิ่ง โย้เวอ กงาปูน แล่ยาว จี่วีดม้าม้า จา แล แง. ");
INSERT INTO bzi_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","กงา นองนา อางเลิ่ง ม้าม้า นี้ง ม่า แบ ปี่ ล่า ปานา. อางญ่าม แฮ้ แท้ อ้องลาย ชา เคิน ลางญา. แน อามื้อ ชฺ้างซฺี้ อือ กงา อางเซง แฮ้ง กงากย่า อางญ่าม ย่าง ล้ายเคิน ลางญา. ยาว ชฺ้างซฺี้ กงา จี่ต่าง แฮ้ง เจ่อ คูชี อือย่า จี่วีดม้าม้า จา แล แง. ");
INSERT INTO bzi_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","อ่าโบ้ง เมอ ล่าที่ จี่วีดปี่ แฮ้ง จา แง, แน ยา กงานา ล่าที่ จี่วีด ปี่ แฮ้ง จา ปี่ ล่าง ยาง แม้แน ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","กงาย่า ชฺ้างอางย่า เกิ้ด ลือ แอ, แฮ้งย้า อ่าโบ้ง มือ กงานา ล่าที่ ปี่ ชฺ้าง อือนา อางซี ต้าดต่อน ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","อางเลิ่ง นี้เลิ่ง นา นืงบาบ่าม่าน คู โจ, ไม้ ชฺ้างซฺี้ คาโคลาโค อือ กงา อางเซง แฮ้ง กงากย่า อางญ่าม ย่าง ล้ายเคิน ลางญา. ");
INSERT INTO bzi_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ยาว ยองมู นี้ย่า แต่ล้า แล่ คูแง. ชฺ้าง อางเลิ่ง อางแม่น ฮา คูชี อือ พาจาว มางก้อง ทื่งกง่า แน จี่วีดม้าม้า กงาจา แล คู แง. จ้า ชฺ้าง อางเลิ่ง บ่าแม่น ฮา คูชี อือนา อางซี ต้าดต่อน แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงา ค่าตอง นืงบาวา แน บ่ากงาฮา, จ้า กงา พาจาว มางก้อง บ้าเจอล้อแม้ กงากย่า แง, แฮ้แม้แนย้า อางซี ต้าดต่อน แง, แน กงา อางซี ต้าดต่อน แฮ้ย่า อางกง่าอางเกิง, ไม้ กงา ค่าตอง นืงบาวา แน บ่ากงาฮา, กงา พาจาว มาง นืงบาจาบวา แน ฮา แง, ไม้ พาจาว ม้า กงานา ซฺาลือ ปี่ ล่าง นอ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงาต่องกงา แน พี่ญ่าน เพล่อ จ่าแล่ยาว กงา จี่ต่าง นี้ย่า บ่าเจ่อจ่า กงา กาเป. ");
INSERT INTO bzi_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","จ้า ทื่อม่าง จา แง, ยา กงานา พี่ญ่าน เพล่อ ปี่ ล่า อางกงา, แน กงา อางแบ ย้า ยาง จี่ต่าง แฮ้ย่า อางเลิ่ง ม้าม้า แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","นอย่า ชฺ้าง อือนา ไจ กงา อางเลิ่ง นี้ง ยอห์น นา น้า แอ ปี่ แง. ยาว ยอห์น อางเลิ่ง ม้าม้า แฮ้ง ยองนา ม่า แง. ");
INSERT INTO bzi_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ชฺ้าง อือย่า กงานา พี่ญ่าน บ่าเพล่อ ปี่ ล่าเวิม อางกงา ย้า. จ้า กงา นี้แม้ จี่ นี้ย่า, ไม้ นองนา ยอห์น นา เจ่อ ปี่ ล่ายาว อางบล่าบ กงาปูน ปี่ ล่าง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ยอห์น ย่า กู่มบี่ท่อ จฺ่อ ยาว แปล้นซ้า ชี แม้แน ย้า. ยาว นอ ยอห์น ม่าอู่บจี่ต่าง แฮ้ง อางมล่าง แน บ่าซอ คู” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “จ้า กงาก้อง พี่ญ่าน จา แง, แน พี่ญ่าน นี้ม้า ยอห์น จี่ต่าง แฮ้ง ล่อบ่าปา ฮื่อ แง, ไม้ กงา อางเลิ่ง อางแม่น ป่าว แฮ้ง แน อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา นี้ย่า กงานา พี่ญ่าน เพล่อ ปี่ ล่าง, อ่าโบ้ง กงานา ซฺาลือ ปี่ ล่าชี่ แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ยาว อ่าโบ้ง กงานา ซฺาลือ ปี่ ล่าชี่ มาง กงานา พี่ญ่าน เพล่อ ปี่ ล่าแง. นอ ยาง อางเซง แฮ้ง บ่ากงากย่า กางซื้ง, แน ยางนา บ่ากงามย้าง กางซื้ง. ");
INSERT INTO bzi_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","นอง นืงบา โย้เวอ พาจาวจี่ต่าง แฮ้ง บ่าจา, ไม้ นอ ชฺ้าง อ่าโบ้ง ซฺาลือ ปี่ชี่ มางนา บ่าเจ่อ จ่า คูวา, แน กงา ชฺ้าง อ่าโบ้ง ซฺาลือ ปี่ชี่ มาง ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","นอ พระคัมภีร์ แฮ้ง แม่น ย้า เล่น คูแง, ไม้ เย้ง แง นองนา ฮาย พาจาว มางก้อง ทื่งกง่า แน จี่วีดม้าม้า กงาจา แล ปี่ ล่าง แน. กงา อางเลิ่ง นี้ย่า มอ ยาว พระคัมภีร์ โย้เวอ แต้ม ชี ชี. ");
INSERT INTO bzi_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","จ้า แฮ้แม้เวิม นอ กงานา บ่าเจ่อ ล่าคู, จาว่าแน นอง กงานา เจ่อ ล่ายาว กงาม นองนา พาจาว มางก้อง ทื่งกง่า แน จี่วีดม้าม้า จา แล ปี่ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงาย่า ชฺ้าง อือ กงานา โญกจ่าญ่อจ่า ล่า คูง นา บ่าตี่นบ่าต่อง. ");
INSERT INTO bzi_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ยาว กงาม อางแบ ย้า นอ พาจาว มางนา ม้าม้า แน บ่ากงา ลาก แน. ");
INSERT INTO bzi_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","กงาย่า อ่าโบ้ง กงานา ซฺาลือ ปี่ ล่าชี่ มางนา จี่แต่น ลือ แอ. จ้า นอ กงานา บ่าซอ ล่าคู. จ้า นอย่า จี่ต่าง ชฺ้าง อือ ก่ามกืด เวอ จายล้า แฮ้งนา ซอ คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","นอ กงานา บ้าเจอล้อแม้ เจ่อล่าตอ กาแง, ไม้ นอย่า นองต่องนอง แน จี่โญกญอ กางนา ซอ คูแง. จ้า พาจาว ม้าม้า ทื่อม่าง แน จา ชี นี้มาง จี่โญกญอ แฮ้งนา บ่าตี่นบ่าต่อง คู. ");
INSERT INTO bzi_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","นอย่า นอง อางเลิ่ง อางซี ฮา ชี แฮ้ง อ่าโบ้ง นา ม่า แบ ปี่ แงแน บ่าเย่ง คู โจ! นอ โมเสส นา นืงบาแก่นจ่า คูแง, ยา นองนา ปล่อง ล่าง แน. จ้า โมเสส นอง อางเลิ่ง อางซี ฮา ชี แฮ้ง อ่าโบ้ง นา ม่า แบ ปี่ มาง ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","นอง โมเสส นา ม้าม้า แน เจ่อ คูยาว, นอ กงานา คาตา ย้า เจ่อ ล่าง, ไม้ โมเสส กงา อางเลิ่ง นี้ง มอ ยาว พระคัมภีร์ โย้เวอ แต้มชี ป้าน่อ. ");
INSERT INTO bzi_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","จ้า จาว่าแน นอง โมเสส แต้ม ชี ชี แฮ้งนา บ่าเจ่อ คูยาว, นอ กงานา บ้าเจอล้อแม้ เจ่อ ล่าง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ยาว พระเยซู มือ ลองอองอางฮื่อ กาลิลี (ลองอองอางฮื่อ ทิเบเรียส แน ฮ้าว เวิม อางกงา ย้า) ทื่อปล่าก ป่ากย่า คาม แอน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ชฺ้าง อางบย่า เย พระเยซู ก้อง เค่ แอน คูชี, ไม้ ยอ พระเยซู ชฺ้าง อางด้า อือนา ยา เมอ, ยาง อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ชี แฮ้ง กงามย้าง คู ป้าน่อ. ");
INSERT INTO bzi_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ยาว พระเยซู มือ ตาแซ้ ท่า โย้เวอ ย่อย แล ยาว ยาง ศิษย์ อือก้อง ทื่งกง่า แน ดื้ง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","แฮ้ญ่ามเมอ ยิวชฺ้าง อือ ปัสกาป่อยนืง ย่าง ชา เคอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","พระเยซู แมก่า พลาบ ล้า ปี่ ยาว ชฺ้าง อางอีบ่าอ่า แน ยางนา ซฺ้า ล้า ชี แน มย้าง ชีเย. แฮ้งเย่ ยาง ฟีลิป นา น้าน ชี นี้แม้แน, “กงู ชฺ้าง นี้ อือนา ล้อเกิ้ง จฺ่าเกิ่ง วื้อ ยาว ยองนา ก้อ แน จฺ่า ปี่ กงากา แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(ยาง ฟีลิป นา แฮ้แม้ น้า ชี แฮ้ย่า ไม้ ยา ฟีลิป นา นืงบาเจ้อฮู ซี้ง เย. ม้าม้า ย้าง พระเยซู อางแบ บ้าเจอล้อแม้ ชา ฮา แงแน.) ");
INSERT INTO bzi_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ยาว ฟีลิป มือ ม่า ชี นี้แม้แน, “พลู้ 200 เดนาริอัน จา เวิม ยองนา จฺ่าเกิ่ง กามาง กา อางอี้ กาแน วื้อ เปิ่งกาจฺ่า ปี่ เวิม บ่าล่อ กา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","อันดรูว์ ซีโมนเปโตร อางแพ้ เย. ยา พระเยซู ศิษย์ อางมู โย้เวอ ชฺ้าง ทื่อม่าง มาง ย้าเย่. ยา พระเยซู นา นี้แม้แน ม่าย ชี. ");
INSERT INTO bzi_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“นู้ ย่าเก ค่าพ่าย่า ทื่อม่าง จา แง, ยางก้อง ค้านู้มป่าง บาร์เลย์ 5 ซื่อ แน ล่องแต่ 2 โต จา แง. จ้า ชฺ้าง นี้แม้ อางบย่า นี้ย่า บ้าเจอล้อแม้ ก้อ กาแน” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ยาว พระเยซู มือ ยาง ศิษย์ อือนา ม่า ยองนา บู่ก่า แต่ โย้เวอ ม่าย ดื้ง ปี่ชี่ เย. แฮ้งเย่ ชฺ้าง อืม ดื้ง คูชี. ชฺ้าง อางมู โย้เวอ ค่าพ่าย่า อือนา ดาบ กงา ชี แฮ้ 5,000 คู่น เย. จ้า ค่าบาย่า แน ย่าเก อือนา บ่ากงา ดาบ เย. ");
INSERT INTO bzi_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","พระเยซู มือ ค้านู้มป่าง ย้าง กอ ท่าม แล่ ยาว พาจาว มางนา ขอบคุณ ฮา ชีเย. ยาว ชฺ้าง อือนา จฺ่า ปี่ชี่ เย. แน ล่องแต่ แฮ้ง คาตา ย้าเย่ แฮ้แม้แน ฮาย ชี. ยอง ค้าจฺ่าซี่งล่อ ย้าเย่ จฺ่า ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","จฺ่าก่อต้างก้อ เปิน คู ยาว, พระเยซู มือ ยาง ศิษย์ อือนา นี้แม้แน ม่า ชีเย, “โค แน ซ้าล้อง อางฮื่อ เวอ กอย กาน คูโว! บ่าปี่ จ้าน ล้า โจ!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ศิษย์ อือ ค้านู้มป่าง 5 ซื่อ โย้เวอ จฺ่าจ้านล้าชี แฮ้ง กอกงา ชี แฮ้ 12 ซ้าล้อง อางฮื่อ เย. ");
INSERT INTO bzi_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ชฺ้าง อือ พระเยซู แฮ้แม้ ฮาง นา มย้าง คู ยาว นี้แม้แน จี่ กาง เย, “ชฺ้าง นี้ม้า พาจาวจี่ต่างจี่แต่นฮู กงู ค้าแต้ เวอ จาย ล่อ คูชี มาง นาตู้!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ยาว พระเยซู มือ แบน ชีเย, ชฺ้าง นี้ อือ ยางนา ก่าซ้าด ชา เค้ เพล่อ ปี่ แงแน. แฮ้งเย่ ยาง ทื่อม่าง แน ตาแซ้ ท่า โย้เวอ ตาย แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","มู่งคี่ล้าก้า เคิน ยาว พระเยซู ศิษย์ อืม ลองอองอางฮื่อ โย้เวอ ซฺื่ยกาแลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ยาว ยอง มือ ล้องตา คาเปอรนาอุม อางเมิง โย้เวอ คาม แลน คู ชีเย. แฮ้ญ่าม ย่า วื้ง กาชา เย. จ้า พระเยซู มือ ยองนา บ่าลือ ซฺ้า ลือ เย. ");
INSERT INTO bzi_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ยาว ฮ้างม้าน อางฮื่อ ตอน ล้า ยาว ล้าง ย้าง เอิก ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ยอง ล้องตา แอ 5 กิโลเมตร 6 กิโลเมตร ล่อซฺ่า เคิน ยาว, ศิษย์ อืม พระเยซู ล้างท่า โย้เวอ ย่อย ยอง ป่ากย่า ลือ นา มย้าง คู ชีเย. ยอง แฮ้แม้ มย้าง คูยาว แค คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","จ้า พระเยซู ยองนา นี้แม้แน ม่า ชีเย, “บ่าแค คู โจ! กงา เยซู เป!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ยาว ยอง นาบาตา เย กย่าง คูแง. แฮ้งย้า พระเยซู นา ล้อง โย้เวอ ตา ปี่ชี่. ยาว ล้อง ย้าง ซฺ้อก ย้าเย่ ยอง ชา แล โย้เวอ เคิน แล ชี. ");
INSERT INTO bzi_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ชฺ้าง พระเยซู จฺ่าเกิ่ง ปอ ชี อืม พระเยซู นา ซฺ้า กว่าน คู ชีเย, ไม้ ยอ อางมย้าง นอ ล้าง โย้เวอ ล้อง ทื่อล่าม ญา จา แงแน. ยาว ล้องตา แล เมิม พระเยซู ศิษย์ อืนญา ตา แล คูชี แน. พระเยซู ล้อง บ่ากงาตา แล แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ยาว ล้อง ทิเบเรียส อางเมิง เวอ จายลือ คู ชีอืม พระเยซู ค่องช่าง 5,000 คู่น อือนา ฮ่างปอ ชี โย้เวอ แท้ แน จ่อด ลือ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ยาว ชฺ้าง อืม พระเยซู แน ยาง ศิษย์ อือนา บ่ามย่าง แม้แน แฮ้งเย่ ล้องตา คาเปอรนาอุม อางเมิง โย้เวอ เค่ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ค่องช่าง อือ พระเยซู นา แปฟาง ทื่อปล่าก ป่ากย่า มย้าง คู ยาว ยอง นี้แม้แน น้าน ชีเย, “อ่าจาน เวอ, นา นู้เวอ อ้าล้อม เคอ ลือ แอ?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ยาว พระเยซู ยองนา นี้แม้แน จี่พอ ชีเย, “กงา นองนา อางเลิ่ง ม้าม้า ม่า แบ ปี่ ล่า ปานา. นอง กงานา ซฺ้า กว่า ล่าง นี้ย่า นอง จฺ่าเกิ่ง ก้อ แน กงาจฺ่า ชีแฮ้ง ปาปาย, จ้า นอ กงา อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮาย มย้าง ปี่ ล่าชี่ แฮ้งนา บ่าแบ คู. ");
INSERT INTO bzi_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","จฺ่าเกิ่ง ปู่ อางกงา อือนา บ่าตี่นบ่าต่อง คูโจ! จ้า จี่วีดม้าม้า กงา แฮ้งนา ตี่นต้อง คูโว! จี่วีดม้าม้า แฮ้ย่า นองนา ฮาย พาจาว มาง ก้อง ทื่งกง่า แน จี่วีด จา แล ปี่ ล่าง. กงาชฺ้างอางย่า เพล่อ ชี นี้ม้า นองนา จี่วีดม้าม้า แฮ้ง ปี่ ล่า อางกงา, ไม้ อ่าโบ้ง กงานา ล่าที่ ปี่ ล่ายาว ล่ากาน นี้อือ ว่า ปี่ ล่าง นอ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ยาว ค่องช่าง อืม พระเยซู นา นี้แม้แน น้า ชีเย, “ท้าว กงู บ้าเจอล้อแม้ ฮาย พาจาว มางนา นืงบาจาบ ปี่ วา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","แฮ้งเย่ พระเยซู มือ นี้แม้แน จี่พอย ชี, “จาว่าแน พาจาว มางนา นืงบาจาบ ปี่ ซี้ง แนยาว, นอง มือ ชฺ้าง พาจาว มาง ซฺาลือ ปี่ชี่ มางนา เจ่อจ่า คูโว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ยาว ยอง นี้แม้แน น้าน แล่ คู ชีเย, “อ่าจาน เวอ, นาง กงูนา ฮาย เจ่อ ปี่ ล่าง นี้ย่า พาจาว ม้า นางนา ซฺาลือ ปี่ ล่าชี่ แน, น้า กงูนา บ้าเจอ อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮาย ฮู ปี่ ล่าแง. กงูนา ม่า ล่าปาว บ้าเจอ อางเลิ่ง ฮาย ฮู ปี่ ล่าง แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","กงู อางฮู่ อางพี่ อือย่า ตีอางกืออางคาก โย้เวอ 40 ปี แน ซ้อดแซด กว่า คูเมอ มานา แฮ้ง จฺ่า คูชี. พระคัมภีร์ โย้เวอ แต้ม ชี ชี แฮ้งแม้แน ย้า. พระคัมภีร์ โย้เวอ นี้แม้แน แต้ม ชี ชี, ‘โมเสส มู่งท่า โย้เวอ จฺ่าเกิ่ง แฮ้ง ยองนา ปี่ ชี’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","พระเยซู นี้แม้แน จี่ ชีเย, “ม้าม้า นี้ย่า นองนา มู่งท่าจฺ่าเกิ่ง ปี่ ล่าชี่ ม้า โมเสส บ่าอ่า เป. จ้า นองนา มู่งท่าจฺ่าเกิ่ง ปี่ ล่าชี่ ม้า อ่าโบ้ง เป. ");
INSERT INTO bzi_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","พาจาว มาง จฺ่าเกิ่ง แฮ้ย่า, ชฺ้าง มู่งท่า เวอ จาย ลู่งลือ ยาว ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา จี่วีด ปี่ ลือ ชี มาง ย้าเป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","แฮ้งเย่ ค่องช่าง อืม นี้แม้แน จี่ คู แง, “นี้แม้แนยาว กงูนา จฺ่าเกิ่ง แฮ้ง ปี่ ซื้บ แลน ล่า ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ยาว พระเยซู มือ นี้แม้แน จี่พอ ชีเย, “กงา จฺ่าเกิ่ง จี่วีดม้าม้า มาง ย้าเป. อ่าซ่าง กงานา ล้า ซฺ้า ล้า ล่าง. ชฺ้าง แฮ้ม้า เจิ้นเจ้อ บ่าแบ่บ่าซฺู่ แล่ก้าน. แน ชฺ้าง กงานา เจ่อ ล่าง อือย่า ล้าง บ่าแบ่ แล่ก้าน. ");
INSERT INTO bzi_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","กงา นองนา ม่า ล่าชี่ แฮ้งแม้แน ย้า นี้แม้แน, นอ กงานา มย้าง ล่างญา แน. จ้า นอ กงานา บ่าเจ่อ ล่าคู. ");
INSERT INTO bzi_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ชฺ้าง คาโคลาโค อ่าโบ้ง กงานา ปี่ ล่าชี่ อือย่า กงานา ซฺ้า ล่าแง, แน อ่าซ่าง กงานา ซฺ้า ล่าแง. กงาม ชฺ้าง แฮ้มางนา บ่าวีบ่าจาน เป. ");
INSERT INTO bzi_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ไม้ กงา มู่งท่า เวอ จายลือ ชี นี้ม้า ค่าตอง นืงบาจาบวา แน ฮา ลือแอ บ่าอ่า เป. จ้า พาจาว กงานา ซฺาลือ ปี่ ล่าชี่ มาง นืงบาจาบวา แน ฮา ลือแอ. ");
INSERT INTO bzi_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","นี้ย่า อ่าโบ้ง กงานา ซฺาลือ ปี่ ล่าชี่ มาง กงานา อางเลิ่ง ฮา ปี่ ล่าง ย้างย้า, ไม้ ชฺ้าง ยาง แช้ กงานา ปี่ ล่าชี่ อือนา บ่า ปี่ โปยว แน. กงานา ยองนา ฮูพลา ปี่ ล่าแง. ทื่อม่าง นา แนม บ่าปี่ โปยว แน. ยาว ยองนา ชฺ้างอางเมิง ลีน โย้เวอ แต่ล้า แล่ ปี่ง แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","อ่าโบ้ง ชฺ้าง คาโคลาโค กงานา มย้าง ล่าชี่ อือนา, แน กงานา เจ่อ ล่าชี่ อือนา ยางก้อง ทื่งกง่า แน จี่วีดม้าม้า จา แล ปี่ ซี่ แง, แน กงา ชฺ้างอางเมิง ลีน แฮ้นืง ชฺ้าง อือนา ฮาย จี่วีด จา แต่ล้า แล่ ปี่ แน” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ยาว ค่องช่าง อืม พระเยซู จี่ ชี อางเลิ่ง แฮ้ง จี่จ่าบ ลางกา ชีเย. พระเยซู มือ นี้แม้แน จี่ ชีเย, “จฺ่าเกิ่ง มู่งท่า เวอ จายลือ ชี แฮ้ย่า กงา ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ยาว ชฺ้าง อืม นี้แม้แน จี่ ลางกา ชีเย, “นี้ม้า เยซู โยเซฟ อางย่าย่าค่า เป. กงู ยาง อางบา อางโบ้ง มาง เย่ดนา อางแบกงากา อ่าลา? ท้าว ยา บ้าเจอ นี้แม้แน อางจี่ แน, ‘กงา มู่งท่า เวอ จายลือ แอ’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ยาว พระเยซู มือ นี้แม้แน จี่ ชีเย, “จี่จาบ แฮ้ง ว่าง คูโว! ");
INSERT INTO bzi_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","อ่าโบ้ง กงานา ซฺาลือ ปี่ ล่าชี่ มาง อ่าซ่าง มางนา กงาก้อง บ่าฮ่าวล้า ปี่ ยาว, อ่าซ่าง มาง กงานา บ่าเจ่อ ล่าล้า กงากา, แน กงา ยองนา ฮาย ชฺ้างอางเมิง ต่องลีน โย้เวอ จี่วีด จา แต่ล้า แล่ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","พาจาวจี่ต่างจี่แต่นฮู อือ มอ ยาว พระคัมภีร์ เวอ นี้แม้แน แต้ม ชี ชี, ‘พาจาว ม้าย่า ยองมู คาโคลาโค แฮ้งนา ม่าอู่บ แง’ แน. ยาว ชฺ้าง คาโคลาโค อ่าโบ้ง ก้อง กงากย่า เล่นลู้ แบ คูชี อือ กงานา ซฺ้า ล่า คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","อ่าซ่าง มาง อ่าโบ้ง นา บ่ามย่าง กางซื้ง. ชฺ้าง อ่าโบ้ง ก้อง จายลือ ชี มาง ญา, ยางนา อางมย้าง กางซื้ง แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","กงา นองนา อางเลิ่ง ม้าม้า แฮ้ง ม่าแบ ปี่ ล่าว่า, อ่าซ่าง กงานา เจ่อ ล่าแง, พาจาว มางก้อง ทื่งกง่า แน จี่วีดม้าม้า กงาจา แล แง. ");
INSERT INTO bzi_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","กงา จฺ่าเกิ่ง จี่วีดม้าม้า มาง ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","นอง อางฮู่ อางพี่ อือย่า ตีอางกืออางคาก โย้เวอ มานา กงาจฺ่า คู ชี. จ้า อามื้อ ยอ ซฺี้ แอ โค คูง ญา. ");
INSERT INTO bzi_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","จ้า อ่าซ่าง จฺ่าเกิ่ง มู่งท่า โย้เวอ จายลือ ชี แฮ้ง กงาจฺ่า แง ซฺี้นืง บ่าจา. ");
INSERT INTO bzi_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","กงาย่า จฺ่าเกิ่ง มู่งท่า โย้เวอ จายลือ ยาว ชฺ้าง อือนา จี่วีด ปี่ ลือ ชี มาง ย้า. อ่าซ่าง จฺ่าเกิ่ง นี้ง กงาจฺ่า แง, ยา จี่วีด กงาจา แล แง. จฺ่าเกิ่ง แฮ้ย่า กงา อางซฺ่าอางคอ ย่าง ย้าเป, แน กงา ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา จฺ่าเกิ่ง นี้ง ปี่ จี่วีด จา ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ยาว ค่องช่าง อืม นี้แม้แน จี่เจ้ ลางกา ชีเย, “ค่าพ่าย่า นี้ม้า กงูนา ยาง อางซฺ่าอางคอ แฮ้ง บ้าเจอล้อแม้ จฺ่า ปี่ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","แฮ้งเย่ พระเยซู มือ ยองนา นี้แม้แน จี่ช่าง ชี, “กงา นองนา อางเลิ่ง ม้าม้า ม่า แบ ปี่ ล่าว่า, จาว่าแน นอง กงา อางซฺ่าอางคอ แน ซฺี่ แฮ้ง บ่ากงาจฺ่า บ่ากงาต้าง ยาว จี่วีดม้าม้า บ่ากงาจา แล เป. ");
INSERT INTO bzi_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","จ้า อ่าซ่าง กงา อางซฺ่าอางคอ แน ซฺี่ แฮ้ง กงาจฺ่า กงาต้าง แง, ชฺ้าง แฮ้ม้า พาจาว มางก้อง ทื่งกง่า แน จี่วีด กงาจา แล แง, แน กงา ชฺ้าง แฮ้มางนา ฮา ชฺ้างอางเมิง ลีน แฮ้นืง เวอ จี่วีด จา แต่ล้า แล่ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ไม้ กงา อางซฺ่าอางคอ นี้ย่า จฺ่าเกิ่ง ม้าม้า ย้าง ย้าเป, แน กงา ซฺี่ นี้ย่า ล้างต้างเซฺ่อ ม้าม้า ย้าง ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","อ่าซ่าง กงา อางซฺ่าอางคอ แน ซฺี่ แฮ้ง กงาจฺ่า กงาต้าง แง, ชฺ้าง แฮ้ม้า กงาก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ แง, แน กงาม ชฺ้าง แฮ้มาง ก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","อ่าโบ้ง จี่วีด อางจา ม้าย่า กงานา ซฺาลือ ปี่ ล่าแง. ยาว กงา จี่วีดแต่จา นี้ย่า, ไม้ อ่าโบ้ง ปาปาย ย้า. ยาว ทื่อช่างกานญา เป, ชฺ้าง กงา อางซฺ่าอางคอ แน ซฺี่ กงาจฺ่า กงาต้าง ชี อือย่า กงา ปาปาย ย้า จี่วีด กงา จา คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","จฺ่าเกิ่ง มู่งท่า โย้เวอ จายลือ ชี นี้ย่า นอง อางฮู่ อางพี่ อือ มานา จฺ่า ชี แฮ้งนา บ่าตู่, ไม้ ยองมู นี้ย่า น่อง โย้เวอ ซฺี้น ชี. จ้า ชฺ้าง จฺ่าเกิ่ง นี้มาง กงาจฺ่า คูชี อือย่า จี่วีด กงาจา แล คู แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","พระเยซู อางเลิ่ง นี้อือ จี่ เมอ, แฮ้ญ่าม เมอ ยา คาเปอรนาอุม อางเมิง ยิวชฺ้าง โบสถ์ โย้เวอ ม่าอู่บ จา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","พระเยซู ศิษย์ อือ อางบย่า ย้าเย่, อางเลิ่ง นี้อือ กงากย่า คูยาว นี้เลิ่ง นา จี่จ่าบ ลางกา ชี. ยองมู นี้ย่า นี้แม้แน จี่จ่าบ ลางกา ชีเย, “นี้แม้แน ม่าอู่บจี่ต่าง อางย่ากอางกาบ ม่าอู่บ นี้ย่า อ่าซ่าง ฮาย เค่ กงากา แน เวอ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ยาว พระเยซู มือ แบน ชีเย, ยาง ศิษย์ อือ นี้เลิ่ง นา จี่จ่าบ ลางกา ชี แน. แฮ้งเย่ ยางมือ ยองนา นี้แม้แน น้าน ชี, “นอย่า ม่าอู่บจี่ต่าง นี้อือ นา นืงบาบ่าจาบ คู ลา? ");
INSERT INTO bzi_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","จาว่าแน กงา มู่งท่า กงา ดื้งอ่าน โย้เวอ ตายแลน ชี แน นอง มย้าง คูยาว นอ บ้าเจอล้อแม้ ฮา คูแง? ");
INSERT INTO bzi_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ชฺ้าง อือนา จี่วีด ปี่ นี้ย่า ชฺ้าง ล่าที่ แฮ้ง ไจ ปี่ บ่าอ่า เป. จ้า พาจาว มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ล่าที่ แฮ้ง ไจ ปี่ แง. ยาว กงา นองนา จี่ต่าง ม่า ล่าง นี้ย่า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มางก้อง จายลือ แง. อางค่องอางล้า อางเซฺิ่งอางซฺ้าง นี้ย่า ชฺ้าง นา จี่วีดม้าม้า ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","จ้า นองมู นู้เวอ ชฺ้าง ทื่อบ่า อือย่า บ่าเจ่อ คู” แน. (พระเยซู อางด่า ย้าเย่ แบน ล้าง ชี, ชฺ้าง บ่าเจ่อ คูง อือย่า บ้าเจอ ล้อมู เวอ แน, ยาว อ่าซ่าง ยางนา กาญ่าม โย้เวอ บ่าแม่น ฮาง ม้า แน.) ");
INSERT INTO bzi_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “นี้งย้า กงา นองนา นี้แม้แน ม่า ล่าง นี้ย่า, พาจาว มาง บ่าฮ่าวล้า ปี่ ยาว อ่าซ่าง มาง กงานา บ่าเจ่อ ล่าล้า กงากา,” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ยาว พระเยซู นี้แม้แน จี่ ยาว ศิษย์ อางบย่า ย้าเย่ พระเยซู นา วีจาน คู ชี. ");
INSERT INTO bzi_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ยาว พระเยซู มือ ยาง ศิษย์เอก 12 คู่น อือนา นี้แม้แน น้าน ชีเย, “นอ กงานา ชา วี ล่า คูง ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ยาว ซีโมนเปโตร มือ นี้แม้แน จี่พอ ชีเย, “จาว่าแน กงู นางนา วี ล่า ยาว กงู อ่าซ่าง นา ซฺ้า แอ แน, ไม้ นางเมอ พาจาวจี่ต่าง จี่วีดม้าม้า ปี่ แฮ้ง จา น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","กงู อางเจ่อ ย้า แน แบ คายา นา พาจาว มาง ชฺ้าง อางเซฺิ่งอางซฺ้าง มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ยาว พระเยซู มือ ยองนา นี้แม้แน จี่พอย ชีเย, “กงา นองมู 12 คู่น นี้งนา แช้ยู้ ล่าชี่ มาง ย้า อ่าลา? จ้า นองมู นู้เวอ ชฺ้าง ทื่อม่าง จา แง, ยา ซาตานแด่ย่ายอคา มาง ย่าเจ่น เพล่อ แง.” แน. ");
INSERT INTO bzi_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(พระเยซู ยูดาส ซีโมนอิสคาริโอท อางย่า มางนา จี่เคอ เย, ไม้ ยา พระเยซู นา กาญ่าม โย้เวอ บ่าแม่น ฮา มาง ย้าเย่, แน ยา ศิษย์เอก 12 คู่น โย้เวอ ชฺ้าง ทื่อม่าง มาง ย้าเย่.) ");
INSERT INTO bzi_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","น่อง โย้เวอ จายล้า แล่ยาว พระเยซู มือ กาลิลี แควน โย้เวอ ต้าว ย้า กว่า ชี. ยา ยูเดีย แควน เวอ บ่าแล ซี้ เย, ไม้ ยิวชฺ้าง ยอคา อือ ยางนา เค่ แซ่ คูง เย. ");
INSERT INTO bzi_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","แฮ้ญ่าม เมอ ยิวชฺ้าง อือ ยู้มย่าดื้งป่อยนืง ย่าง ชา เคิน ลา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","พระเยซู อางแพ้ อือ พระเยซู นา นี้แม้แน จี่ช่าง ชีเย, “อ่าอ้าย เวอ, ยูเดีย แควน เวอ แล ปาว. นาง ศิษย์ อือนา อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ฮู ปี่ ปาว. ");
INSERT INTO bzi_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ชฺ้าง แมก่า กงาจ่าแล่ ซี่ง อือย่า บ้าเจอ ฮา เวิม อางลาบอางโชง แน บ่าฮา คู. จ้า นา ล้อแม้เวิม อางเลิ่ง นี้อือเจ้อ ฮาย ญา. นี้แม้แนยาว ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา ฮายแบ ปี่ ปาว.” แน ");
INSERT INTO bzi_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(ซ้ามบา พระเยซู อางแพ้ อืม พระเยซู นา บ่าเจ่อ คู เย.) ");
INSERT INTO bzi_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ยาว พระเยซู นี้แม้แน จี่พอย ชีเย, “อ่าอ้าย อางญ่าม ย่าง บ่าเคอ กาซื้ง. จ้า นอง เมอ อางญ่าม กูญ่าม ย้า จา แง. ");
INSERT INTO bzi_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือ นองนา บ่าเมอ ล่า คู, ไม้ ยอ นองนา เม้อ ล่าเซฺ่อ บ่าจา วา. จ้า ยอ อ่าอ้าย นา เม้อ ล่าคูง, ไม้ อ่าอ้าย ยองนา กูเทอ ย้า นี้แม้แน ม่า แง, ‘นอง อางเลิ่ง ฮา อือ อางซี’ แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","นอง ยู้มย่าดื้งป่อยนืง โย้เวอ แอน ลาง คูปาว. อ่าอ้าย บ่าแอ กาซื้ง ล่า, ไม้ อางญ่าม บ่าเคอ กาซื้ง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","แฮ้แม้ จี่ ยาว พระเยซู มือ กาลิลี แควน โย้ ดื้ง แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","น่อง โย้เวอ พระเยซู อางแพ้ อือ ป่อย โย้เวอ แอ้น คู ยาว, พระเยซู กย้าบ แน อ่าซ่าง มางนา บ่าปี่แบ แน ค่าว แอน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ยิวชฺ้าง ยอคา อืม พระเยซู นา ป่อย โย้เวอ ฮูย ซฺ้า ยาว นี้แม้แน น้า ลางกา ชีเย, “ยา ล้อเกิ้ง แอ กาชี เวอ?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ชฺ้าง อางอีบ่าอ่า เย พระเยซู อางเลิ่ง แฮ้ง จี่ ลางกา ชี. ชฺ้าง ทื่อบ่า อือ นี้แม้แน จี่ คูง เย, “ยา ชฺ้าง อางแม่น” แน. จ้า ชฺ้าง ทื่อบ่า อือ นี้แม้แน จี่ ลางกา เย, “บ่าอ่าท้าล้อ นา ยา ชฺ้าง แล่จ่อบ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","จ้า อ่าซ่าง มาง พระเยซู นา อางเซง บื้ง แน บ่าจี่เคอ จอ กาเย, ไม้ ยิวชฺ้าง ยอคา อือนา แค คูง เย. ");
INSERT INTO bzi_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ยู้มย่าดื้งป่อยนืง ย่าง 3-4 นืง เคิน ยาว พระเยซู โบสถ์อางฮื่อ โย้เวอ อ้องแล ชฺ้าง อือนา ต่องก่าต่าง ม่าอู่บ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ยิวชฺ้าง ยอคา อือ พระเยซู ม่าอู่บ แฮ้งนา นืงบาม่าน คูง เย. แฮ้งเย่ นี้แม้แน จี่ ลางกา ชี, “ยา บ้าเจอ แบบย่า กาทืง แง? ไม้ ยา อ่าซ่าง ก้อง บ่ากงา เล่น กางซื้ง น่อ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “กงา ม่าอู่บจี่ต่าง นี้ย่า กงาก้อง จายลือ บ่าอ่า, จ้า พาจาว กงานา ซฺาลือ ปี่ ล่าชี่ มางก้อง จายลือ แง. ");
INSERT INTO bzi_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","อ่าซ่าง พาจาว มาง นืงบาจาบวา แน ฮาย เค่ ซี่ แง, ชฺ้าง แฮ้ม้า อางแบ ย้า กงา ม่าอู่บจี่ต่าง นี้ย่า พาจาว มางก้อง จายลือ ชี ล่าอ้าว กงาก้อง จายล้า แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","อ่าซ่าง ค่าตอง นืงบาจาบวา แน จี่ แง, ชฺ้าง แฮ้ม้า ค่าตอง นา ฮาย แมก่ากงาจ่าแล่ ปี่ แง. จ้า อ่าซ่าง ยางนา ซฺาลือ ปี่ชี่ มางนา ฮาย แมก่า กงา ปี่ แง, ชฺ้าง แฮ้ม้า อางเจ่อจ่ากงา กาย้า, แน ยา อ่าซ่าง มางนา บ่าจ่อบ เป. ");
INSERT INTO bzi_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","โมเสส นองนา อางลี้บอางล่าว แฮ้ง ปี่ ล่าง ญา. จ้า นองมู นี้ย่า ทื่อม่าง แนม บ่าฮา เค่ คู. ท้าว นอ บ้าเจอ กงานา อางแซ่ ล่าซี่ แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","แฮ้งเย่ ยอง นี้แม้แน จี่พอย คู ชี, “นางนา แด่ย่า อ่อง ล่าชา, ชฺ้าง นางนา แซ่ ล่าซี้ง แฮ้ม้า อ่าซ่าง เวอ?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","แฮ้งเย่ พระเยซู มือ ยองนา นี้แม้แน จี่พอ ชี, “กงา ลองนืง เวอ อางเลิ่งชฺ้างบ่าฮาตอกางอือ ทื่อเลิ่ง ฮาย แอ. นอ แฮ้ เลิ่ง นา นืงบาม่าน คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","โมเสส นองนา พิธีขลิบ อางลี้บอางล่าว แฮ้ง ปี่ ล่าชี่, (จ้า ม้าม้า นี้ย่า นองฮู่นองพี่ ยอ โมเสส ฮู่ เวอ ย้า พิธีขลิบ ฮาย ล้าน คูชี.) แน นอง อางย่าย่าค่า อือนา พิธีขลิบ ฮา ปี่ แฮ้นืง เวอ ลองนืง เพล่อ ยาว, นอย่า บ้าเจอล้อแม้เวิม นอง อางย่าย่าค่า อือนา พิธีขลิบ อางฮา ปี่ ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","นอง ค่าตอง อางย่าย่าค่า อือนา ลองนืง เวอ โมเสส อางลี้บอางล่าว แฮ้แม้แน พิธีขลิบ ฮา ปี่ แฮ้ง บ่าซี ยาว, ท้าว กงา ลองนืง เวอ ชฺ้าง นา พ่าญ่าด ยา โปยว ชี นี้ย่า นอ บ้าเจอฮาย กงานา นืงบาค่าด้า ล่า คูแง? ");
INSERT INTO bzi_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","จาว่าแน นอง อางเลิ่ง แฮ้ง ม้าม้า แน บ่าแบ ยาว บ่าต่าดบ่าต่อน โจ! จ้า อางเลิ่ง ม้าม้า วา แน ต้าดต่อน โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","เยรูซาเล็ม อางเมิง โย้เวอ ชฺ้าง ทื่อบ่า จา ชีเย. ยองมู นี้ย่า นี้แม้แน น้าท้าม ลางกา ชีเย, “ชฺ้าง ยอคา อือ ชา แซ่ แฮ้ม้า ชฺ้าง นี้มาง ช่าอ้า? ");
INSERT INTO bzi_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","จ้า ฮู ปาว, ยา ชฺ้าง กางมู เวอ จูง จี่ ชี. ยอคา อืม ยางนา เจิ้นเจ้อ บ่าฮา คู. อ้าว ยอคา อือ ยางนา เจ่อ คูชี ล่า. ยา พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ ชี่ มาง ย้าแน. ");
INSERT INTO bzi_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","จ้า กงู อางแบ คูย้า ชฺ้าง นี้ม้า ล้อเกิ้ง จายล้า ชี แน. จาว่าแน ยาง พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ มาง เพล่อ ชี ม้าม้า แนยาว กงู บ่าแบ คู เป, ยา ล้อเกิ้ง จายล้า ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ยาว พระเยซู โบสถ์อางฮื่อ โย้เวอ ม่าอู่บ เมอ, อางเซง บื้ง แน นี้แม้แน จี่ ชีเย, “อางอ้า ย้า นอ กงานา อางแบกงา ล่า คูย้า. แน นอ อางแบ คูย้า, กงา ล้อเกิ้ง จายลือ ชี แน. จ้า กงา ลือ ชี นี้ย่า ลือ ซี้ ยาว ลือ แอ บ่าอ่า เป. จ้า ทื่อม่าง จา แง, ยา กงานา ม้าม้า ย้า ซฺาลือ ปี่ ล่าแง. แน นอ ยางนา บ่าแบกงา กาคู. ");
INSERT INTO bzi_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","จ้า กงา ยางนา อางแบกงากา ย้า, ไม้ กงา ยางก้อง จายลือ แอ, แน ยา กงานา ซฺาลือ ปี่ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ชฺ้าง อือ พระเยซู นา ชา ชู คูชี จ้า บ่าชู กงา กาเย, ไม้ ยาง อางญ่าม ย่าง บ่าเคอ กาซื้ง เย. ");
INSERT INTO bzi_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ชฺ้าง อางมู โย้เวอ ชฺ้าง อางอีบ่าอ่า เย พระเยซู นา เจ่อ ชี. ยองมู นี้ย่า นี้แม้แน จี่ลางกา ชีเย, “พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ ชี่ มาง ลืน เมอ, ยา ค่าพ่าย่า นี้มาง ล่อบ่าปา ล่า อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","แฮ้ญ่าม เมอ ฟาริสี อือ แบน คู ชีเย. ชฺ้าง อางอีบ่าอ่า พระเยซู อางเลิ่ง แฮ้ง ค่าว จี่ ลางกา ชี แน. แฮ้งเย่ ปุโรหิต ยอคา แน ฟาริสี อืม ชฺ้าง โบสถ์อางฮื่อล่อฮู อือนา ม่า พระเยซู นา ชู แล ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ยาว พระเยซู นี้แม้แน จี่ ชีเย, “กงา นองก้อง ทื่งกง่า แน ทื่อฟ่าง ดื้ง เปิน แง. ยาว กงานา ซฺาลือ ปี่ ล่าชี่ มางก้อง พ่าวแล แล่แง. ");
INSERT INTO bzi_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","นอ กงานา ซฺ้า กว่า ล่า คูแง. จ้า กงานา บ่าซฺ่า ล่า มย้าง กา, ไม้ นอ กงา ชา แล โย้เวอ บ่าแล กงา กา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","แฮ้งเย่ ยิวชฺ้าง ยอคา อืม นี้แม้แน น้าท้าม ลางกา ชี, “ยา ล้อเกิ้ง ชา แล แง? ไม้ กงู ยางนา บ่าซฺ่ามย้าง กา. อ้าว ยา ประเทศ กรีก อือเมอ แล กงู ชฺ้าง อือนา ซฺ้า แลง ลา? แน โย้เวอ กรีก ชฺ้าง อือนา ม่าอู่บ แลง ลา? ");
INSERT INTO bzi_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ยาง นี้แม้แน จี่ นี้ย่า บ้าเจอป้าค้า เวอ. ยา นี้แม้แน จี่ แง, ‘นอ กงานา ซฺ้ากว่า ล่า คูแง. จ้า บ่าซฺ่าล่ามย้าง กา’ แน ‘นอ กงา ชา แล โย้เวอ บ่าแล กงากา’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ยู้มย่าดื้งป่อยนืง อางนืงลีน นี้ย่า อางนืง ปีนแตปีนนา เลิ่นเลิ่น ม่าง ย้าเย่. พระเยซู ทายจูง ล้า ยาว อางเซง บื้ง แน นี้แม้แน จี่ ล้า ชีเย, “อ่าซ่าง ล้าง แบ่ แง, กงาก้อง อ้องล้าน ยาว ต้าง ปาว. ");
INSERT INTO bzi_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","อ่าซ่าง กงานา เจ่อ ล่าง, ยาง นืงบา โย้เวอ จี่วีดล้างบ้า แฮ้ง ปูย อ่อกลือ แง, พระคัมภีร์ เวอ มอ ยาว แต้ม ชี ชี แม้แน ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","พระเยซู นี้แม้แน จี่ นี้, ไม้ จี่วีดล้างบ้า นี้ย่า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง กาญ่าม โย้เวอ ชฺ้าง ยางนา เจ่อ คูชี อือนา ปี่ แฮ้งนา จี่เคอ เย. จ้า อามื้อ อ่าซ่าง มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง บ่ากงาบู้ กาซื้ง เย, ไม้ พระเยซู ล่ากาน บ่าว่า เปิน กาซื้ง, แน ยา มู่งท่า เวอ บ่ากงา พ่าว แล แล่ กาซื้ง. ");
INSERT INTO bzi_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ค่องช่าง อือ พระเยซู จี่ แฮ้งนา กงากย่า คู เมอ. ชฺ้าง อางมู โย้เวอ ชฺ้าง ทื่อบ่า อือ นี้แม้แน จี่ คูง เย, “ค่าพ่าย่า นี้ม้า กงู ค้าแต้ เวอ จาย พาจาวจี่ต่างจี่แต่นฮู ม้าม้า ล่อ ชี แฮ้มาง นาตู้” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","จ้า ชฺ้าง ทื่อบ่า อือ นี้แม้แน จี่กาง เย, “ยา พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ มาง ย้า” แน. จ้า ชฺ้าง ทื่อบ่า อือ นี้แม้แน จี่กาง เย, “เยซู นี้ม้า กาลิลี แควน โย้เวอ จายล้า ชี บ่าอ่า ลา? จ้า พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ ม้า เบธเลเฮม ค่อง เวอ จายล้า แง. ");
INSERT INTO bzi_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","พระคัมภีร์ โย้เวอ มอ ยาว นี้แม้แน แต้ม ชี ชี, ‘กาญ่าม เวอ พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ ม้าย่า ก่าซ้าด ดาวิด อางอ่านอางซฺื้อ เกิ้ด ลือ แง, แน ยา เบธเลเฮม ค่อง ก่าซ้าด ดาวิด ค่องเกิ่ด ชี โย้เวอ เกิ้ดลือ แง.’ กาลิลี แควน เวอ เกิ้ดลือ แง บ่าอ่า เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","แฮ้งเย่ ชฺ้าง อืม อางมู เปิ่งอ่อก ลางกา ชี, ไม้ พระเยซู อางเลิ่ง แฮ้ง ปาปาย. ");
INSERT INTO bzi_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ชฺ้าง ทื่อบ่า อือ พระเยซู นา ชู คู ซี้ง เย. จ้า อ่าซ่าง มาง บ่าชู เย. ");
INSERT INTO bzi_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","แฮ้งเย่ โบสถ์อางฮื่อล่อฮู อืม ปุโรหิต ยอคา แน ฟาริสี อือนา พ่าวซฺ้า แล คูชี. ยาว ปุโรหิต ยอคา แน ฟาริสี มู อืม นี้แม้แน น้าน คู ชีเย, “นอ บ้าเจอ ยางนา นู้เวอ บ่าชู ล้า คู แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ยาว โบสถ์อางฮื่อล่อฮู อืม นี้แม้แน จี่พอ คู ชีเย, “กงูย่า ค่าพ่าย่า นี้มาง ม่าอู่บ แฮ้งแม้แน อ่าซ่าง มาง ม่าอู่บ นา บ่ากย่า กางซื้ง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ยาว ฟาริสี อืม ยองนา นี้แม้แน น้าน คู ชีเย, “ยา นองนา คาตา ล่า จ้อบ ล่าแง? ");
INSERT INTO bzi_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ยอคา มู แน ฟาริสี มู นู้เวอ ฮู ปาว, อ่าซ่าง จา แง ยางนา เจ่อ ชี แน? ");
INSERT INTO bzi_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ชฺ้าง โมเสส อางลี้บอางล่าว แฮ้งนา บ่าแบ คูง อืนญา เป พระเยซู นา เจ่อ คูแง. แฮ้งย้า ยองนา พาจาว มาง แซ้งว้าน แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","นิโคเดมัส ยิวชฺ้าง ยอคา อางมู โย้เวอ ชฺ้าง ทื่อม่าง มาง ย้าเย่, แน ยา พระเยซู นา อางซฺ้า แล กางซื้ง เย. ยา ยองนา นี้แม้แน น้าน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“กงู อางลี้บอางล่าว นี้ย่า อ่าซ่าง นา อางซี ต้าดต่อน แง, ยาง จี่ แฮ้งนา กงากย่า เมินญา, แน ยา บ้าเจอ ฮา ชี แน กงาแบน เมินญา อ่าลา ต้าดต่อน แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","จ้า ยอง นิโคเดมัส นา นี้แม้แน จี่พอ คู ชีเย, “นา ยาง แม้แน กาลิลี แควน เวอ จายล้า ชี นอเด่. พระคัมภีร์ เวอ ฮู ปาว, ยาว นา กงาแบ แง, พาจาวจี่ต่างจี่แต่นฮู นี้ย่า กาลิลี แควน จายล้า ชี แน ทื่อม่าง แนม บ่าจา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ยาว ยองมู คาโคลาโค แฮ้ง เจิ่ก ลางกา ชีเย, แน ค่าตอง ยู้ม พ่าวแอ้น แล่คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","พระเยซู มะกอกเทศ ตาแซ้ โย้เวอ แลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ซอทา อางด่า เคิน ยาว ยาง โบสถ์อางฮื่อ โย้เวอ ทื่อเทอ แอ้น แล่ชี่ เย. ชฺ้าง อืม ยางนา ซฺ้าล้า คู ชีเย. พระเยซู ดื้งลู่ง ลือยาว ต่องก่าต่าง ม่าอู่บ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","อางลี้บอางล่าว ม่าอู่บฮู อือ แน ฟาริสี อือ ค่าบาย่า ทื่อม่าง นา ซฺื่ยล้าน ชีเย, แน ยางนา ชฺ้าง อือ ล้าก้า โย้เวอ จูง ปี่ชี่ เย. ค่าบาย่า นี้ม้า ยาง จู้ มางก้อง ยู่ดื้ง จา เมอ ฮาก ชู กงา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ยอง พระเยซู นา นี้แม้แน จี่ช่าง คู ชีเย, “อาจารย์ เวอ, ค่าบาย่า นี้ม้า ยาง จู้ มางก้อง ยู่ดื้ง จา เมอ ฮาก ชู กงา ชี. ");
INSERT INTO bzi_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","อางลี้บอางล่าว เวอ โมเสส กงูนา ม่า ล่าแง, ชฺ้าง นี้แม้แน ฮา ชี อือนา ลอบา จาน แซ่ โว แน. ท้าว นา บ้าเจอล้อแม้ ฮา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","(ยอง นี้แม้แน น้า คูง นี้ย่า, ไม้ ป่องฮ่าน แน พระเยซู นา จ้อบ อางเลิ่ง ซฺ้า ยาว อางซี ชู คูง เย.) จ้า พระเยซู เจิ้นเจ้อ บ่าจี่ เย. ยา ดื้งจู ฮาน ยาว ยาง ล่าญู่ง แฮ้ง นื้งชฺ่าท่า โย้เวอ แต้ม ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","จ้า ยองมู แฮ้ง พระเยซู นา น้า คูง แฮ้ง บ่าซ่าว คูเย. แฮ้งเย่ พระเยซู ทาจูง ล้ายาว นี้แม้แน จี่น ล้า ชี, “นองมู นู้เวอ อ่าซ่าง จา แง เจิ้นเจ้อ อางซี บ่าจา แน. ชฺ้าง แฮ้มาง ฮากฮู่ เวอ ลอบา แฮ้ง กอย ยาว ค่าบาย่า นี้ มางนา จาน โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ยาว พระเยซู มือ ดื้งจู ฮาน ยาว ยาง ล่าญู่ง แฮ้ง นื้งชฺ่าท่า โย้เวอ แต้ม ล้าแล่ ชี่เย. ");
INSERT INTO bzi_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ชฺ้าง อือ พระเยซู แฮ้แม้แน จี่ แฮ้งนา กงากย่า คูยาว, ยอง กาจาง กามาง กา แน ย่อย เจิ่กอ่อกแอน คู ชีเย. ชฺ้าง ฮาก ล่อบ่าปา แน ย่าม่าง ม่าง มาง ต่องก่าต่าง ย่อย เจิ่กแอออน เย. ยาว น่อง เวอ พระเยซู แน ค่าบาย่า แฮ้มางเย่ด ญาเย่ จ้าน ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ยาว พระเยซู ทายจูง ล้า ชีเย. ยาว ค่าบาย่า แฮ้มางนา นี้แม้แน น้าน ชีเย, “ยอ ล้อเกิ้ง แอ โค คู ชี? นางนา อ่าซ่าง มาง อางซี บ่ายู่ ล่าลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ยาว ค่าบาย่า แฮ้มาง นี้แม้แน จี่พอย ชีเย, “บ่าจา” แน. ยาว พระเยซู ค่าบาย่า แฮ้มางนา นี้แม้แน ม่า ชีเย, “กงาม นางนา อางซี บ่ายู่ ล่าเป. แอ้น ปาว ยาว อางบล่าบ บ่าฮา แล่โจ!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","พระเยซู ฟาริสี อือนา นี้แม้แน ทื่อเทอ จี่ช่าง แล่ชี่ เย, “กงา ชฺ้างอางเมิง นู้เวอ อางแปล้นอางซ้า มาง ย้า. อ่าซ่าง กงานา เค่ ล่าแง. ยา อางแปล้นอางซ้า จี่วีดม้าม้า แฮ้ง กงาบู้ แง. แน ยา อางวื้งอางว้าง โย้เวอ บ่าย่อ แล่ก้าน” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","แฮ้งเย่ ฟาริสี อืม ยางนา นี้แม้แน จี่ช่าง คูชี, “นาง จี่ นาง พอ, นาง จี่ต่าง นี้ย่า บ่าเจ่อจ่า กงากา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “โอ่ย! กงาย่า กงา จี่ กงา พอ ย้า. จ้า บ้าเจอล้อแม้เวิม กงา จี่ต่าง นี้ย่า ม้าม้า เป, ไม้ กงา อางแบจ่าแล่, กงา อางโต นี้ย่า บ้าเจอล้อเกิ้ง จายลือ ชี, แน บ้าเจอล้อเกิ้ง ชา แล แงแน. จ้า นอ บ่าแบ คู, กงา บ้าเจอล้อเกิ้ง จาย ลือ ชี แน บ้าเจอล้อเกิ้ง ชา แล แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","นอ ชฺ้าง อือ อางซี ต้าดต่อน แฮ้งแม้แน ต้าดต่อน คูแง. จ้า กงา อ่าซ่าง มางนา อางซี บ่าต่าดบ่าต่อน เป. ");
INSERT INTO bzi_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","จ้า จาว่าแน กงา อ่าซ่าง นา อางซี ต้าดต่อน แง, กงา ต้าดต่อนจี่ต่าง นี้ย่า อางกง่าอางเกิง เป, ไม้ กงาย่า กงา ทื่อม่าง แน บ่าต่าดบ่าต่อน เป. จ้า กงาย่า อ่าโบ้ง กงานา ซฺาลือ ปี่ ล่าชี่ มาง ไกง้ ทื่งกง่า แน ต้าดต่อน แง. ");
INSERT INTO bzi_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","นอง อางลี้บอางล่าว โย้เวอ นี้แม้แน แต้ม ชี ชี, ชฺ้าง 2 คู่น พี่ญ่าน เพล่อ เมอ, จาว่าแน เย่ด จี่ แฮ้ง ตู้ ลางกายาว อางเจ่อจ่ากงา กาย้า, ไม้ เย่ด อางเลิ่ง ม้าม้า จี่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","กงาย่า ค่าตอง อางโต นี้งนา พี่ญ่าน เพล่อ จ่าแล่ แง. ยาว อ่าโบ้ง กงานา ซฺาลือ ปี่ ล่าชี่ มาง, ยาง คาตา ย้า กงานา พี่ญ่าน เพล่อ ปี่ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","แฮ้งเย่ ยอง พระเยซู นา นี้แม้แน น้าน คู ชี, “ท้าว นางโบ้ง นาง จี่ เคอ แฮ้ม้า บ้าเจอล้อเกิ้ง เวอ?” แน. ยาว พระเยซู นี้แม้แน จี่พอย ชีเย, “นอ อ่าโบ้ง ไกง้นา บ่าแบ ล่า กงากา, ไม้ จาว่าแน นอง กงานา อางแบ ล่า กงากา แนอู้, นอ อ่าโบ้ง นา คาตา ย้า แบ กงากา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","พระเยซู อางเลิ่ง คาโคลาโค นี้อือ จี่ เมอ, ยา โบสถ์อางฮื่อ เวอ พลู้ ท่านย่า อางฮี้บ โบย ชี แฮ้ฮ้อง ก้องเวอ ม่าอู่บ เย. อ่าซ่าง มาง ยางนา บ่าชู ลือ เย, ไม้ ยาง อางญ่าม ย่าง บ่าเคอ กาซื้ง เย. ");
INSERT INTO bzi_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ยาว พระเยซู ชฺ้าง อือนา นี้แม้แน จี่ช่าง แล่ชี่ เย, “กงา นองนา เจิ่กแล ล่าแง. นอ กงานา ซฺ้ากว่า ล่า คูแง. จ้า นอ ค่าตอง อางบล่าบ แฮ้ง ปาปาย ซฺี้ คูแง. กงา ชา แล โย้เวอ นอ บ่าแล กงากา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","แฮ้งเย่ ยิวชฺ้าง ยอคา อืม นี้แม้แน จี่ลางกา ชี, “ยา อามือ ยางต่องยาง แน ชา แซ่จ่าแล่ง ลา? ไม้ ยา นี้แม้แน จี่ แง, ‘กงา ชา แล โย้เวอ นอ บ่าแล กงากา’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ยาว พระเยซู มือ นี้แม้แน จี่พอย ชีเย, “นอ ชฺ้างอางเมิง จายล้า คูแง. จ้า กงา มู่งท่า จายลือ แอ. นอ ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือ จ้า กงา บ่าอ่า เป. ");
INSERT INTO bzi_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ยาว นี้งย้า เป กงา นองนา ม่า ล่าง นี้ย่า นอ ค่าตอง อางบล่าบ แฮ้ง ปาปาย ซฺี้ คูง แน. อางอ้า ย้า, นอ ค่าตอง อางบล่าบ แฮ้ง ปาปาย ย้า ซฺี้ คูแง. จาว่าแน นอง กงานา บ่าเจ่อ ล่าคูยาว, กงา ชฺ้าง แฮ้มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","แฮ้งเย่ ยิวชฺ้าง ยอคา อืม พระเยซู นา นี้แม้แน น้าน คูชี, “ท้าว นา อ่าซ่าง เวอ?” แน. ยาว พระเยซู มือ ยองนา นี้แม้แน จี่พอ ชีเย, “กงา แฮ้มาง ย้า, แน กงา นองนา ต่องก่าต่าง เมอ จาย ย้า ม่าย ล่าแอ่, กงา แฮ้มาง เป แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ม้าม้า นี้ย่า กงา นองนา อางเลิ่ง อางบย่า ย้า ม่าแบ ปี่ ล่าซี่ แง, แน จี่ ล่าซี่ แง. จ้า กงาย่า กงานา ซฺาลือ ปี่ ล่าชี่ มาง ก้องเวอ อางเลิ่ง กงากย่า ชี อืนญา ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา ม่าแบ ปี่ แง, ไม้ ยา อางเลิ่ง ม้าม้า จี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","(ยอ บ่าแบ คู เย, พระเยซู พาจาว ยาง อางโบ้ง มาง อางเลิ่ง แฮ้ง ยองนา จี่ช่าง แงแน.) ");
INSERT INTO bzi_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","แฮ้งเย่ พระเยซู มือ ยองนา นี้แม้แน จี่ช่าง ชี, “นอง กงาชฺ้างอางย่า เพล่อ ชี มางนา ไม้กางเขน ท่า โย้เวอ โญก ชี ล่า เมอ, นอ กงาแบ คูแง, กงาย่า แฮ้มาง ย้า แน. ยาว นอ กงาแบ แล่ คูแง. กงา ค่าตอง นืงบาจาบวา แน เจิ้นเจ้อ บ่ากงา ฮา แน. จ้า กงาย่า อ่าโบ้ง กงานา ม่า จี่ ปี่ ล่าชี่ อางเลิ่ง อือ แอ่นญา จี่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ยาว กงานา ซฺาลือ ปี่ ล่าชี่ ม้า กงาก้อง ย้า จาดื้ง แง. ยา กงานา ทื่อม่าง แน บ่าชี่ช่าล่า, ไม้ กงา กูญ่าม ย้า ยาง นืงบาจาบวา แน ฮา เค่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","พระเยซู นี้แม้แน จี่ ยาว ชฺ้าง อางบย่า เย, ยางนา เจ่อ คูชี. ");
INSERT INTO bzi_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","แฮ้งเย่ พระเยซู ยิวชฺ้าง ยางนา เจ่อ คูชี อือนา นี้แม้แน จี่ ช่าง ชี, “จาว่าแน นอง กงา ม่าอู่บจี่ต่าง แฮ้ง ฮายเค่ ยาว นอ กงา ศิษย์ ม้าม้า ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ยาว นอ อางเลิ่ง ม้าม้า แฮ้งนา กงาแบ คูแง. ยาว อางเลิ่ง ม้าม้า แฮ้ย่า นองนา ฮาย ย่าเจ่น กงาปูน ปี่ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ยาว ยอง นี้แม้แน จี่พอ คู ชีเย, “อ่าจาน เวอ, กงูย่า อับราฮัม อางอ่านอางซฺื้อ เป, แน กงู อ่าซ่าง มาง ย่าเจ่น บ่าเพล่อ กางซื้ง. ท้าว นา บ้าเจอ นี้แม้แน อางจี่ แน? ‘นอ ย่าเจ่น กงาปูน แล่ คูแง’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “กงา อางเลิ่ง ม้าม้า แฮ้ง ม่าแบ ปี่ ล่าว่า ม้าม้า นี้ย่า อ่าซ่าง อางบล่าบ ฮา แง, ยา อางบล่าบ ย่าเจ่น เพล่อ เป. ");
INSERT INTO bzi_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ย่าเจ่น นี้ย่า ค่าตอง ยู้มชฺ้าง บ่าอ่า เป. จ้า อางย่า นี้ย่า ค่าตอง ยู้มชฺ้าง เพล่อ แล แง. ");
INSERT INTO bzi_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","นี้แม้แนยาว จาว่าแน กงา นองนา ย่าเจ่น ปูน ปี่ ล่า ยาว, นอย่า ม้าม้า ย้า ย่าเจ่น กงาปูน แล่ คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","กงา อางแบ ย้า นอ อับราฮัม อางอ่าน อือ ย้า แน. จ้า นอ ปีนแตปีนนา ย้า กงานา ชา แซ่ ล่า คูแง, ไม้ นอ กงา จี่ต่าง แฮ้งนา บ่าเจ่อ คู. ");
INSERT INTO bzi_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","กงาย่า อ่าโบ้ง ก้อง อางเลิ่ง กงามย้าง ชี อือ นองนา ม่า แบ ปี่ ล่าย่า เป. จ้า นอย่า นอง อางโบ้ง มางก้อง อางเลิ่ง กงากย่า คูชี อือ ฮายเค่ คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ยาว ยองมู แฮ้ง นี้แม้แน จี่ คูง เย, “อับราฮัม กงู อางโบ้ง มาง ย้าเป” แน. ยาว พระเยซู นี้แม้แน จี่ ชีเย, “จาว่าแน นอง อับราฮัม อางย่าอางคย้า อางอ่านอางซฺื้อ ม้าม้า แน ยาว, นอ อับราฮัม ฮา ชี แฮ้งแม้แน ย้า ฮา เค่ คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","กงาย่า อางเลิ่ง ม้าม้า พาจาว มางก้อง กงากย่า ชี แฮ้ง นองนา ม่าแบ ปี่ ล่าย่า เป. จ้า นอย่า กงานา แซ่ ล่า คู ซี้ แง. อับราฮัม นี้แม้แน บ่าฮา กางซื้ง เป. ");
INSERT INTO bzi_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","จ้า นอย่า นอง อางโบ้ง มาง ฮา ชี แฮ้งแม้แน ฮายเค่ คูแง” แน. แฮ้งเย่ ชฺ้าง อืม พระเยซู นา นี้แม้แน จี่ช่าง คู ชี, “กงูย่า จู้ อางย่า บ่าอ่า เป. จ้า กงู อางโบ้ง ม้าม้า ม้า พาจาว มาง ทื่อม่าง ญา เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ยาว พระเยซู นี้แม้แน จี่ ชีเย, “จาว่าแน พาจาว มาง นอง อางโบ้ง ม้าม้า มาง แน ยาว, นอ กงานา อางลาก ล่าย้า, ไม้ กงา พาจาว มางก้อง จายลือ แอ. ยาว กงา นู้เวอ จาดื้ง ชี นี้ย่า พาจาว มาง ซฺาลือ ปี่ ล่าง เป. กงาย่า ค่าตอง นืงบาจาบวา แน บ่ากงา ลือ เป. ");
INSERT INTO bzi_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","นอง กงา จี่ นี้งนา บ่าน่าจ่าแบ กาง นี้ย่า, ไม้ นอ บ่าโอ่ด น้า กงา กาวา. ");
INSERT INTO bzi_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","นอย่า ซาตานแด่ย่ายอคา มาง อางย่า, แน นอย่า นอง อางโบ้ง มาง นืงบาจาบวา แน ฮา เค่ คู ซี้ แง. ยา ต่องก่าต่าง เมอ จาย ย้า ชฺ้าง นา แซ่ ล้าน แง, แน ยา อางเลิ่ง ม้าม้า เวอ บ่าดื่ง กางซื้ง, ไม้ ยางก้อง อางเลิ่ง ม้าม้า บ่าจา เป. ยาง จี่ เมอ ยา จ้อบ แง. ยาง นืงบา ม้าม้า แฮ้งแม้แน ย้า, ไม้ ยา แล่จ่อบ น้อ, แน ยา จ้อบ อางเลิ่ง คาโคลาโค โย้เวอ อางโบ้ง มาง ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ยาว นี้งย้า กงา อางเลิ่ง ม้าม้า จี่ เมอ นอง กงานา บ่าเจ่อ ล่า คูง นี้ย่า. ");
INSERT INTO bzi_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","นอง อางมู นู้เวอ อ่าซ่าง ฮา มย้าง ปี่ ล่า กงากา แง, กงา อางบล่าบ ฮา ชี แน. ท้าว กงา อางเลิ่ง ม้าม้า จี่ เมอ บ้าเจอ นอ กงานา บ่าเจ่อ ล่า คูแน? ");
INSERT INTO bzi_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","อ่าซ่าง พาจาว มาง ชฺ้าง เพล่อ แง. ยา พาจาวจี่ต่าง แฮ้งนา อางน้า ย้าเป. จ้า นอ กงา จี่ นี้งนา บ่าน่า คู, ไม้ นอ พาจาว มาง ชฺ้าง บ่าอ่า เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ชฺ้าง อือ พระเยซู นา นี้แม้แน น้าน คู ชีเย, “ท้าว กงู บ้าเจอ ล้อเกิ้ง จี่ ซี ชี, นางนา สะมาเรียชฺ้าง แน จี่ ล่าชี่ นี้ย่า, แน นางนา แด่ย่า อ่อง ชี แน จี่ ล่าชี่ นี้ย่า?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “กงานา แด่ย่า บ่าอ่อง ล้าเป. กงา อ่าโบ้ง นา โญกจ่าญ่อจ่าง, จ้า นอ กงานา ฮูย้า ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","กงา อ่าซ่าง มางนา กงานา บ่าโญกบ่าญ่อ ปี่ ล่าซี่. จ้า พาจาว ม้า กงานา อางฮื่อ เพล่อ ปี่ ล่า ซี่ แง, แน ยา ต้าดต่อนฮู มาง ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","กงา อางเลิ่ง ม้าม้า ม่าแบ ปี่ ล่าว่า, อ่าซ่าง กงา ม่าอู่บจี่ต่าง แฮ้ง ฮาย เค่ แง, ยา บ่าซฺี่!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ยาว ชฺ้าง อืม พระเยซู นา นี้แม้แน จี่ช่าง คู ชีเย, “อามื้อ กงู แบ คายา, นางนา แด่ย่า อ่อง ล่าชี่ แน, ไม้ อับราฮัม แน พาจาวจี่ต่างจี่แต่นฮู อือย่า ซฺี้ แอ โค คูงญา. จ้า นา นี้แม้แน จี่ แง, ‘อ่าซ่าง กงา ม่าอู่บจี่ต่าง แฮ้ง เจ่อ แง, ยา บ่าซฺี่ เป’ แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","นา อับราฮัม กงู อางฮู่ ม่าง ล่อบ่าปา ล่า ฮื่อ แง. อับราฮัม แน พาจาวจี่ต่างจี่แต่นฮู อือย่า ซฺี้ แอ โค คูงญา. นาง เย้ง กานยาว นา อ่าซ่าง เวอ?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “จาว่าแน กงาต่องกงา แน จี่ โญกจ่าญ่อจ่าน แล่ยาว, โญกจ่าญ่อ จี่ต่าง แฮ้ง เจิ้นเจ้อ จองไจ บ่าจา เป. จ้า กงานา จี่ โญกญอ จ่า ล่า ชี่ ม้า พาจาว กงา อางโบ้ง มาง ย้าเป. ยาว ยา นอง พาจาว แน จี่ มาง ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ม้าม้า นี้ย่า นอ ยางนา บ่าแบกงา กา. จ้า กงา ยางนา อางแบกงากา ย้า. จาว่าแน กงา ยางนา บ่าแบกงากา แน จี่ ยาว, กงาม นอง แม้แน ย้า ชฺ้าง แล่จ่อบ เพล่อ แง. กงา ยางนา อางแบกงากา ย้า, แน กงา ยาง ม่า ฮา ปี่ ล่าชี่ อือ ฮายเค่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","อับราฮัม นอง อางฮู่ ม้า กงา ชฺ้างอางเมิง นู้เวอ ลือ แฮ้นืง นา อางกงามย้าง ย้า แน กย่างจ่า แง. ยาว ยา กงามย้าง ญา, แน กงากย่าง ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ยาว ชฺ้าง อืม พระเยซู นา นี้แม้แน จี่ช่าง คู ชีเย, “อับราฮัม ซฺี้ มล่าง คางญา ท้าว นา บ้าเจอล้อแม้ อับราฮัม นา กงามย้าง แอ? ไม้ นาง อ่าญู นี้ย่า 50 ปี แนม บ่าเคอ กาซื้ง น่อ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ยาว พระเยซู มือ ยองนา นี้แม้แน จี่พอ ชีเย, “ม้าม้า นี้ย่า กงา อับราฮัม บ่าเกิ่ด ฮู่ เวอ ย้า จี่วีด จาดื้ง แอ!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ยาว ชฺ้าง แฮ้อืม ลอบา ย่าง กอยท่าม แล่ คู ชีเย. ยองมู นี้ย่า พระเยซู นา ลอบา แฮ้ง ซฺี้ แอเคอ แน ชา จาน คูง เย. จ้า พระเยซู โบสถ์อางฮื่อ อางเง้ โย้เวอ ค่าว ฮื่น อ่อกแอน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","พระเยซู ย่อ จา เมอ, ค่าพ่าย่า แมปอ ทื่อม่าง นา มย้าง ชีเย. ยา เกิ้ด ลือ เมอ จาย ย้าเย่ แมปอ. ");
INSERT INTO bzi_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ยาว พระเยซู ศิษย์ อืม พระเยซู นา นี้แม้แน น้าน คู ชีเย, “อ่าจาน เวอ, ยาง ชฺ้างแมปอ เกิ้ด เพล่อ ลือ ชี นี้ย่า ยาง อางบล่าบ แฮ้ง ปาปาย ล่า, อ้าว ยาง อางบา อางโบ้ง มาง เย่ด อางบล่าบ แฮ้ง ปาปาย ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","แฮ้งเย่ พระเยซู ยาง ศิษย์ อือนา นี้แม้แน จี่พอ ชี, “ยาง อางบล่าบ แน ยาง อางบา อางโบ้ง มาง เย่ด อางบล่าบ แฮ้ง บ่าอ่า เป. จ้า ยาง ชฺ้างแมปอ เพล่อ ชี นี้ย่า, ไม้ ชฺ้าง คาโคลาโค อือนา พาจาว มาง ล่าที่ แฮ้ง กงามย้าง ปี่ แงแน น่อ. ");
INSERT INTO bzi_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","กงูมู นี้ย่า กงูนา ซฺาลือ ปี่ ล่าชี่ มาง ล่ากาน แฮ้ง นืงก้อง เวอ กงาว่า คูแง, ไม้ มู่งคี่ นี้ย่า อามือ ชา เคอ ลือ แง, แน มู่งคี่ เวอ อ่าซ่าง มาง ล่ากาน บ่าว่า กงากา. ");
INSERT INTO bzi_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ยาว กงา ชฺ้างอางเมิง นู้เวอ ดื้ง เมอ กงา ชฺ้างอางเมิง นู้เวอ อางแปล้นอางซ้า มาง ย้าเป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","พระเยซู จี่ เปิน ยาว ยาง ค้าล้า โย้เวอ ค่านล่าง พีด กาน ชีเย. ยาว ยาง ค่านล่าง แน ค้าล้า แฮ้ง ซูน ลางกา ยาว ลองเปิ่น เพล่อ ปี่ชี่ เย. ยาว ยาง ลองเปิ่น แฮ้ง ค่าพ่าย่า แมปอ มาง แมนือ เวอ ต่า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ยาว พระเยซู ค่าพ่าย่า แฮ้มางนา นี้แม้แน ม่า ชีเย, “สิโลอัม ล้างบ้อ โย้เวอ ลองเปิ่น แฮ้ง ชี่อ่อก แล่ โว!” แน. (สิโลอัม นี้ย่า ซฺาแล ปี่ แงแน ฮา เย.) ยาว ค่าพ่าย่า แฮ้มาง แลน ยาว ลองเปิ่น แฮ้ง ชี่อ่อก แล่ชี่ เย. ยาว ยาง ฮูมย้าง ล้า ชีเย. ยาว ยาง พ่าว แอ้น แล่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ยาว ชฺ้างแมปอ นี้มาง ยู้มต่องยู้มทาง อือ แน ชฺ้าง ยาง พลู้ ดื้ง ป้า เมอ มย้าง คูชี อืม นี้แม้แน น้าท้าม ลางกา ชีเย, “ชฺ้าง นี้ม้า พลู้ ดื้ง ป้า ชี มาง บ่าอ่า ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ยาว ชฺ้าง ทื่อบ่า อืม นี้แม้แน จี่ คูง เย, “อางอ้า ย้า, ยาง ย้า” แน. จ้า ชฺ้าง ทื่อบ่า อือย่า นี้แม้แน จี่ คูง เย, “ยาง บ่าอ่า ว่า, จ้า ชฺ้าง นี้ม้า ยางนา แมก่า อางตู้” แน. ยาว ค่าพ่าย่า แฮ้มาง นี้แม้แน จี่ เย, “อางอ้า ย้า, กงา ชฺ้าง แฮ้มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","แฮ้งเย่ ยอง ยางนา นี้แม้แน น้าน คูชี, “ท้าว นา ล้อแม้ มย้าง กงากา แอ?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ยาว ค่าพ่าย่า แฮ้มาง นี้แม้แน จี่พอ ชีเย, “ค่าพ่าย่า อางเม้ง เยซู แน ชี มาง กงา แมนือ นู้เวอ ลองเปิ่น ต่า ล่าง. แน ยา กงานา นี้แม้แน ม่า ล่าง, ‘สิโลอัม ล้างบ้อ โย้เวอ แลน ยาว ลองเปิ่น นี้ง ล้าง ชี่อ่อก แล่โว!’ แนยาว กงามมือ สิโลอัม ล้างบ้อ โย้เวอ แล ยาว ลองเปิ่น แฮ้ง ล้าง ชี่อ่อก แล่แอ่. ยาว กงา แมนือ นี้ง ฮูมย้าง กาแอ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ยาว ชฺ้าง แฮ้อืม นี้แม้แน น้า คูง เย, “ท้าว ค่าพ่าย่า แฮ้ม้า ล้อเกิ้ง แอ กาชี?” แน. ยาว ยาง นี้แม้แน จี่พอ ชีเย, “บ่าแบ ล้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ยาว ชฺ้าง แฮ้อืม ค่าพ่าย่า แมปอ โปยว ชี มางนา ซฺื่ย ฟาริสี อือนา ซฺ้าน แล คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","(พระเยซู ลองเปิ่น แฮ้ง ไจ ค่าพ่าย่า แมปอ มางนา ยา ชี แฮ้นืง ลองนืง เย.) ");
INSERT INTO bzi_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","แฮ้งเย่ ฟาริสี อืม ยางนา น้าน คู ชี. ยา บ้าเจอล้อแม้ มย้าง กงากา ชี แน. ยาว ยาง นี้แม้แน จี่พอ ชีเย, “ยา กงา แมนือ นู้เวอ ลองเปิ่น ต่า ล่าง. ยาว กงาม ลองเปิ่น แฮ้ง ชี่อ่อก แล่แอ่. ยาว กงาม ฮูมย้าง กงากา แอ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ยาว ฟาริสี อางมู โย้เวอ ชฺ้าง ทื่อบ่า อืม นี้แม้แน จี่ คูง เย, “ยา พาจาว มาง ก้อง บ่ากงา จายลือ, ไม้ ยา ลองนืง เวอ ชฺ้าง อางด้า นา ยา ชี. ลองนืง เวอ ล่ากาน ว่า นี้ย่า กงู อางลี้บอางล่าว เวอ อางซี” แน. จ้า ชฺ้าง ทื่อบ่า อือย่า นี้แม้แน จี่ คูง เย, “ชฺ้าง อางบล่าบ นี้ย่า บ้าเจอล้อแม้ อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา กงากา แง?” แน. แฮ้งเย่ ยองมู แฮ้ง อางมู เปิ่งอ่อก ลางกา ชี, ไม้ ยอง อางเลิ่ง นี้เลิ่ง นา เย้ง คูง นี้ย่า บ่าตู่ กาเย. ");
INSERT INTO bzi_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ยาว ฟาริสี อืม ค่าพ่าย่า แมปอ โปยว ชี มางนา นี้แม้แน ทื่อเทอ ต้าง น้าน แล่ ชี่ เย, “นาง เย้ง กานยาว ชฺ้าง นางนา แมปอ ฮา โปยว ปี่ ล่าชี่ ม้า บ้าเจออ่าซ่าง เวอ?” แน. ยาว ยาง นี้แม้แน ม่า ชีเย, “ยา พาจาวจี่ต่างจี่แต่นฮู” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ยาว ยิวชฺ้าง ยอคา อืม บ่าเจ่อ เย. ยา ชฺ้างแมปอ เพล่อ ยาว น่อง นู้เวอ ฮู มย้าง กงากา ชี แน. แฮ้งเย่ ยองมือ ค่าพ่าย่า นี้มาง อางบา อางโบ้ง มาง เย่ดนา ฮ้าว ลาย ปี่ ยาว, ");
INSERT INTO bzi_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","นี้แม้แน น้าน ชี, “ยา ไน้ อางย่า เกิ้ด ลือ ยาว ชฺ้างแมปอ เพล่อ ชี มาง ย้า อ่าลา? ท้าว ยา บ้าเจอ อางฮู มย้าง กงากา แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ยาว อางบา อางโบ้ง มางเย่ด นี้แม้แน จี่พอ ชีเย, “อางอ้า ย้า, ยา ไกง้ อางย่า เกิ้ด ลือ ชฺ้างแมปอ เพล่อ ชี มาง ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","จ้า ไกง้ บ่าแบ ยา บ้าเจอล้อแม้ ฮูมย้าง กงากา ชี, แน ยางนา อ่าซ่าง แมปอ ยา โปยว ปี่ชี่ แน. นอง ยางนา น้า ฮู ปาว, ไม้ ยา ค่อ คางญา, แน นองนา อางเลิ่ง ตอล้า ชี แฮ้ง อางอู่บ น้า ปี่ ล่า กงากา ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","(ค่าพ่าย่า แฮ้มาง อางบา อางโบ้ง มาง เย่ด นี้ป้าค้า จี่ นี้ย่า, ไม้ เย่ด ยิวชฺ้าง ยอคา อือนา แค เย, ไม้ ยิวชฺ้าง ยอคา อือ อางด่า ม่า ลางกา ชีเย. อ่าซ่าง พระเยซู พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ มาง ย้า แน จี่ แง. ชฺ้าง แฮ้มางนา ยิวชฺ้าง โบสถ์ โย้เวอ ก่าฮื่น ปี่ แง, แน โบสถ์ โย้เวอ บ่าปี่ อ้องล้า แล่ก้าน แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","แฮ้งเย่ ค่าพ่าย่า แฮ้มาง อางบา อางโบ้ง มาง เย่ด นี้แม้แน จี่ ชี, “ยา ค่อน ญา, ยางนา น้า ฮู ปาว” แน.) ");
INSERT INTO bzi_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","แฮ้งเย่ ยิวชฺ้าง ยอคา อืม ค่าพ่าย่า แมปอ โปยว ชี มางนา ทื่อเทอ ฮ้าว ล้าแล่ ปี่ชี่. ยาว ยางนา นี้แม้แน จี่ช่าง คู ชีเย, “จาว่าแน นาง พาจาว มางนา นาบทื้อ แนยาว กงูนา ก่ามค่าน ปี่ ล่าโว, นา อางเลิ่ง ม้าม้า จี่ แงแน. กงู อางแบ ย้า ค่าพ่าย่า แฮ้ม้า ชฺ้าง อางบล่าบ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ยาว ยาง นี้แม้แน จี่พอ ชีเย, “กงา บ่าแบ ยา ชฺ้าง อางบล่าบ ล่าอ้าว ชฺ้าง บ่าบล่าบ ล่าแน. จ้า กงา อางแบ ต่องก่า เวอ กงา แมนือ นี้ย่า บ่าฮู มย้าง กาแน. จ้า อามื้อ อางฮู มย้าง กาย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ยาว ยองมู แฮ้ง ยางนา นี้แม้แน น้าน คู ชีเย, “ยา นางนา บ้าเจอฮา ล่าแง? ยา นางนา บ้าเจอล้อแม้ ยา ล่าแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ยาว ยาง นี้แม้แน จี่พอ ชีเย, “กงา นองนา อู่บน้า ปี่ ล่าย่า. จ้า นอ บ่าน่า คู ท้าว บ้าเจอฮานา อู่บ แล่ ปี่ ล่าก้าน แง? อ้าว นอง คาตา แน ยาง ศิษย์ เพล่อ คู ซี้ แง ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ยาว ยิวชฺ้าง ยอคา อืม ยางนา นี้แม้แน จี่ ฮูย้า คู ชีเย, “นา ค่าพ่าย่า แฮ้มาง ศิษย์, จ้า กงู โมเสส ศิษย์. ");
INSERT INTO bzi_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","กงู อางแบ ย้า พาจาว ม้า โมเสส นา จี่ช่าง ชี แน. จ้า กงู บ่าแบ ค่าพ่าย่า แฮ้ม้า บ้าเจอล้อเกิ้ง จายล้า ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ยาว ยาง นี้แม้แน จี่พอ ชีเย, “นืงบาม่าน คาน้าว, นอ บ้าเจอ บ่าแบ คูแน ยา ล้อเกิ้ง จายล้า ชีแน. จ้า บ้าเจอล้อแม้เวิม ยา กงา แมนือ นี้งนา ฮา มย้าง กงาปี่ ล่างญ้า. ");
INSERT INTO bzi_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","กงู อางแบ ย้า, พาจาว ม้า ชฺ้าง อางบล่าบ อือนา บ่าน่า แน. จ้า อ่าซ่าง ยางนา นืงบาชี แง, แน ยาง นืงบาจาบวา แน ฮา เค่ แง. ยา ชฺ้าง แฮ้มางนา อางน้า ย้าแน. ");
INSERT INTO bzi_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ชฺ้างอางเมิง นู้เวอ อ่าซ่าง จา แง, ชฺ้าง เกิ้ด ลือเมอ จาย แมปอ เพล่อ ชี อือนา ฮา ฮูมย้าง ปี่ กงากา แงแน. อ่าซ่าง มาง บ่ากงากย่า กางซื้ง เป. ");
INSERT INTO bzi_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","จาว่าแน ค่าพ่าย่า นี้มาง พาจาว มางก้อง บ่าจาย ลือ อู้, ยา อางเลิ่ง นี้อือเจ้อ บ่าฮา กงากา เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","แฮ้งเย่ ยิวชฺ้าง ยอคา อืม ยางนา นี้แม้แน จี่ คู ชี, “นาง เกิ้ด ลือ ชี นี้ง บล่าบ คางญ้า, นี้ม้อก เวิม กงูนา ชา ม่าอู่บ แล่ ล่าง ล้า” แน. ยาว ยางนา ยิวชฺ้าง โบสถ์ อางเง้ โย้เวอ ก่า อ่อกแอ ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","พระเยซู ยิวชฺ้าง ยอคา อือ ค่าพ่าย่า แมปอ โปยว ชี มางนา ยิวชฺ้าง โบสถ์ โย้เวอ ก่า อ่อก ชี อางเลิ่ง แฮ้ง แบน ยาว, ยาง ค่าพ่าย่า แฮ้มาง นา ซฺ้า แล ชีเย. ยาว ยางนา นี้แม้แน น้าน ชีเย, “นา ชฺ้างอางย่า มางนา นืงบาอางชี ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ยาว ค่าพ่าย่า แฮ้ มาง พระเยซู นา นี้แม้แน น้าน ชีเย, “เจ้านาย เวอ, ชฺ้างอางย่า ม้า อ่าซ่าง? กงา ยางนา แบกงา ซี่ค้า, ไม้ กงา ยางนา นืงบาชี ซี้ แง น้อ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","แฮ้งเย่ พระเยซู มือ นี้แม้แน จี่พอ ชี, “นา ยางนา กงา มย้าง ญา. ยา นางนา อามื้อ จี่ช่าง ล่าง มาง ย้าเป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ยาว ค่าพ่าย่า แมปอ โปยว ชี มาง นี้แม้แน จี่ ชีเย, “จี่วีดอางซื้ง เวอ, กงา นางนา นืงบาอางชี ล่า ย้า” แน. ยาว ยาง พระเยซู นา บอกไว้ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ยาว พระเยซู นี้แม้แน จี่ ชีเย, “กงา ลือ ชี นี้ย่า ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา อางซี ต้าดต่อน ลือ แอ, ไม้ ชฺ้างแมปอ อือนา ฮา ฮู มย้าง ปี่ แง แนนอ, แน ชฺ้าง ค่าตอง อางฮู มย้าง กงากา แน เย้ง คูง อือนา ฮา แมปอ เพล่อ ปี่ แง แนนอ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","โย้เวอ ฟาริสี อางมู เวอ ชฺ้าง ทื่อบ่า อือ จา ชีเย. พระเยซู จี่ แฮ้งนา กงากย่า เมอ, ยอง ยางนา นี้แม้แน น้าน คู ชีเย, “นา กงูนา คาตา ย้าล่า แมปอ แน จี่ ล่าแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “จาว่าแน นอง แมปอ แน อู้, นอ เจิ้นเจ้อ อางซีอางบล่าบ บ่าจา. จ้า นอ พาจาว มาง อางเลิ่ง แฮ้ง อางแบ อางมย้าง แน จี่ คู แง. นี้ป้าค้า นี้ย่า นอ อางซีอางบล่าบ จา แง เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ทื่อนืง จา แง พระเยซู นี้แม้แน อางเลิ่ง จี่เพ้ก น้า ปี่ชี่ เย, “กงา นองนา อางเลิ่ง ม้าม้า แฮ้ง ม่าแบ ปี่ ล่าว่า, แกะ คอก เวอ อ้องแล นี้ย่า อ่าซ่าง ล้องก้อ ป่ากย่า บ่าอ่องแล แน พย่า อ้องแล แง, ชฺ้าง แฮ้ม้า แล่ค่าว เป. ");
INSERT INTO bzi_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","อ่าซ่าง แกะ คอก ล้องก้อ ป่ากย่า อ้องแล แง, ยา แกะปอฮู มาง ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ชฺ้าง แกะ ล้องก้อ ล่อ ดื้ง มาง ยางนา ล้องก้อ พอง ปี่ แง. ยา ยาง แกะ คาโคลาโค อือนา อางแบกงากา, แน แกะ อืม ยางนา น้าจ่า คูแง. ยา ยาง แกะ อือ อางเม้ง แฮ้งนา ฮ้าว แง, แน ยา ยาง แกะ อือนา คอก อางเง้ เวอ ซฺื่ย อ่อกแอ แง. ");
INSERT INTO bzi_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","แกะ อือ คอก โย้เวอ อ่อกลือ โค ยาว, ชฺ้าง ปอ ฮู มาง แกะ อือ ล้าก้า โย้เวอ ย่อ แล แง, แน แกะ อืม ยางนา ย่อ เค่ แล แง, ไม้ แกะ อือย่า ยาง อางเซง นา อางจาม กงากา. ");
INSERT INTO bzi_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","แกะ อือย่า ชฺ้าง ยอง บ่าแบกงา กาง อือนา บ่าย่อ เค่ เป. ยอ ซฺ้อก ย้า ฮื่น แง, ไม้ ยอ อางเซง แฮ้งนา บ่าแบกงา กา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","พระเยซู อางเลิ่ง นี้เลิ่ง ยองนา จี่เพ้ก น้า ปี่ชี่ เย. จ้า ยอ บ่าแบ คูเย, พระเยซู บ้าเจอ นา จี่ เคอ แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “ม้าม้า นี้ย่า กงา แกะ คอก โย้เวอ ล้องก้อ แฮ้งแม้แน เป. ");
INSERT INTO bzi_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ชฺ้าง กงาฮู่ เวอ ลือ คูชี อือย่า แล่ค่าว เป. จ้า แกะ อือย่า ยองนา บ่าน่าจ่า. ");
INSERT INTO bzi_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","กงาย่า ล้องก้อ เป. อ่าซ่าง กงา ป่ากย่า อ้องล้า แง, ชฺ้าง แฮ้ม้า อางบล่าบ กงาปูน แล่แง. ชฺ้าง แฮ้ม้า อ้องแล ล่า อ้าว อ่อกแอ เวิม จฺ่าเกิ่ง นา มย้าง แง. ");
INSERT INTO bzi_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","แล่ค่าว มาง ลือ นี้ย่า ยอ อางเกิ่ง ค่าว ลือ แง, แน แซ่ ลือ แง, แน ก่างพยา ลือ แง. จ้า กงา ลือ นี้ย่า จี่วีดม้าม้า ปี่ ลือ แง. จี่วีดม้าม้า นี้ย่า กูย่างกูเจ้อ โปล้ม แน จา แฮ้งย้า เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงาย่า แกะปอฮู อางแม่น มาง ย้า. แกะปอฮู อางแม่น นี้ย่า ยา ยาง แกะ อือนา ซฺี้ แต่น เวิม อางกงา ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ชฺ้าง ฮาบจ้าง ฮาย แกะ ฮูพลา ชี ม้าย่า แกะปอฮู ม้าม้า มางนา บ่าตู่, ไม้ แกะ อือย่า ยาง เฮอ บ่าอ่า. ยา ฮ้อนโจ้ง มาง ลือ นา มย้าง ยาว ซฺ้อก ย้า แกะ อือนา ฮื่น ชี ช่าง. ยาว ฮ้อนโจ้ง มาง แกะ อือนา แช่ จฺ่า แง, แน แกะ จ้านล้าชี อืม ย่าด ฮื่น กาแง. ");
INSERT INTO bzi_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ชฺ้าง ฮาบจ้าง ฮา ยาว แกะ ฮูพลา ชี มาง ฮื่น ชี แฮ้ย่า, ไม้ ยา แกะ อือนา บ่าตี่นบ่าต่อง วา, ไม้ ยา อางซื้ง บ่าอ่า วา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงาย่า แกะปอฮู อางแม่น มาง ย้า, ไม้ กงา ค่าตอง แกะ อือนา อางแบกงากา, แน กงา แกะ อืม กงานา อางแบ ล่ากงา กา. ");
INSERT INTO bzi_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","กงา อ่าโบ้ง นา แบกงา กาง แฮ้งแม้แน ย้า อ่าโบ้ง กงานา แบกงา ล่าแง. กงาย่า แกะ อือนา ซฺี้แต่น เวิม อางกงา ย้า, ไม้ ยองนา อางบล่าบ กงาปูน ปี่ง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","กงาก้อง แกะ จา แล่แง. จ้า ยอ คอก นี้คอก ก้อง บ่าดื่ง คู. กงาย่า แกะ แฮ้อือนา คาตา ย้า ซฺื่ยแล แง. ยอ กงา อางเซง นา อางน้าจ่า ล่าคู. ยอ ช้อน ลางกา ยาว ทื่อลู่มทื่อเจ่อ แน เพล่อ แง. แน แกะปอฮู ม้า กงา ทื่อม่าง ญา. ");
INSERT INTO bzi_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","อ่าโบ้ง กงานา ลาก ล่าง, ไม้ กงาย่า กงา แกะ อือนา ซฺี้แต่น ป้าน่อ. ยาว กงา นี้แม้ ฮา ชี นี้ย่า, ไม้ กงา แต่ล้า แล่ง น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","อ่าซ่าง มาง กงานา บ่าเค้ ซฺี้ ปี่ ล่า กงากา. จ้า กงา ฮากนา ตอย กงานา แซ่ ปี่ ล่าง. ยาว กงาย่า จี่วีด จา แต่ล้า แล่แง, ไม้ กงา ซฺี้ เวิม อางกงา จี่วีด จา แต่ล้า แล่เวิม อางกงา น่อ, แน อ่าโบ้ง กงานา นี้แม้แน ม่าย ฮา ปี่ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","พระเยซู แฮ้แม้แน จี่ ยาว ค่องช่าง อืม อางมู เปิ่งอ่อก ลางกา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ชฺ้าง อางบย่า เย นี้แม้แน จี่ คูง, “ชฺ้าง นี้ม้า แด่ย่า อ่อง ปี่ ยาว เปิดบา เพล่อ ชี, บ้าเจอฮาย ยางนา น้าจ่า แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","จ้า ค่องช่าง ทื่อบ่า อือย่า นี้แม้แน จี่ คูง เย, “ชฺ้าง แด่ย่า อ่อง ชี อือ บ้าเจอ นี้แม้แน อางม่าอู่บ กงา กาแน? แด่ย่า ม้าย่า ชฺ้างแมปอ นา บ้าเจอล้อแม้ ฮา มย้าง ปี่กงา กาแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ยาว เยรูซาเล็ม อางเมิง โย้เวอ โบสถ์อางฮื่อ ป่อยนืง ย่าง เคิน ชีเย. แฮ้ญ่ามเมอ ช่อมย่า เย. ");
INSERT INTO bzi_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","พระเยซู โบสถ์อางฮื่อ โซโลมอน ตางเก้อ โย้เวอ ย่อ จา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ค่องช่าง อือ พระเยซู นา จูง แวด คู ชีเย, แน ยางนา นี้แม้แน น้าน คู ชีเย, “นา อ่าซ่าง แน กงูนา อางมล่าง ล่า ตอย เย้ง แล แล่ ปี่ ล่าแง? จาว่าแน นาง พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ มาง แนยาว กงูนา ปล้อง แน ม่า ล่าปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ยาว พระเยซู นี้แม้แน พอ ชีเย, “กงา นองนา ม่า ล่าย่า. จ้า นอ กงานา บ่าเจ่อ ล่าคู. อ่าโบ้ง กงานา ม่าย อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ปี่ ล่าแง. ยาว กงา อางเลิ่ง อ่าโบ้ง ม่าย ฮา ปี่ ล่า ชี่ แฮ้งแม้แน ฮา ชีอืม, นองนา ฮาย แบ ปี่ ล่างญา กงา อ่าซ่าง แน. จ้า นอ กงานา บ่าเจ่อจ่า ล่าคู. ");
INSERT INTO bzi_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","นอง บ่าเจ่อ คูง นี้ย่า, ไม้ นอ กงา แกะ อือ บ่าอ่า วา. ");
INSERT INTO bzi_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","กงา แกะ อือย่า กงา อางเซง นา น้า คูแง, แน กงาม กงา แกะ อือนา อางแบกงากา ย้า, แน กงา แกะ อืม กงานา เค่ ล่า คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","กงาย่า กงา แกะ อือนา พาจาว มางก้อง ทื่งกง่า แน จี่วีด จา แล ปี่ แน. กงา แกะ อือ บ่าซฺี่ เป, แน อ่าซ่าง มาง กงา แกะ อือนา บ่าย่าด แอ กงากา. ");
INSERT INTO bzi_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","อ่าโบ้ง กงานา แกะ ปี่ ล่าชี่ ม้า กูย่างกูเจ้อ อือ ล่อบ่าปา ล่าที่ จา แง. ยาว อ่าซ่าง มาง ยาง แกะ ฮูพลา ชี อือนา บ่าย่าด แอ กงากา. ");
INSERT INTO bzi_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","พาจาว ม้าย่า กงา อางโบ้ง มาง ย้า, ไกง้ย่า ทื่อลู่มทื่อเจ่อ กานญา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ยาว ชฺ้าง แฮ้อืม ลอบา ย่าง ทื่อเทอ กอยท่าม แล่ คู ชีเย. ยองมู นี้ย่า พระเยซู นา ซฺี้ แอเคอ แน ลอบา ชา จาน คูง เย. ");
INSERT INTO bzi_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ยาว พระเยซู ยองนา นี้แม้แน น้าน ชีเย, “กงา นองนา อางเลิ่ง อางแม่น อ่าโบ้ง กงานา ม่ายฮา ปี่ ล่าชี่ อือ ฮายฮู ปี่ ล่าย่า, ท้าว นอง กงานา ลอบา ชา จาน ล่าง นี้ย่า อางเลิ่ง อางแม่น บ้าเจอ ล้อเลิ่ง ปาปาย เวอ?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ยาว ยอง นี้แม้แน จี่พอ ชีเย, “กงู นางนา ลอบา ชา จาน ล่า คูง นี้ย่า, ไม้ นาง อางเลิ่ง อางแม่น ฮา ชี แฮ้ง ปาปาย แน บ่าอ่า เป. จ้า นาง พาจาว มางนา จี่ ฮูย้า ชี แฮ้ง ปาปาย ย้าเป. นา ชฺ้าง กานแอ, จ้า นา จี่ แง นา พาจาว มาง ย้า!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “นอง อางลี้บอางล่าว โย้เวอ นี้แม้แน แต้ม ชี ชี, ‘พาจาว มาง จี่ แง, นอ พาจาว อือย้า’ แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","กงูมู นี้ง อางแบ ย้า, พระคัมภีร์ โย้เวอ มอ ยาว แต้ม ชี ชี แฮ้ อางเลิ่ง ม้าม้า เพล่อ แล แงแน. พาจาว ม้า อ่าซ่าง นา พาจาวจี่ต่าง ปี่ แง, ยา ชฺ้าง แฮ้อือนา พาจาว อือ แน ฮ้าว แง. ");
INSERT INTO bzi_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","‘กงา พาจาวอางย่า มาง ย้า’ แน กงา จี่ ชี แฮ้ย่า, ไม้ พาจาว ม้า กงานา แช้ยู้ ล่า ป้าน่อ, แน ยา กงานา ชฺ้างอางเมิง นู้เวอ ซฺาลือ ปี่ ล่าง. ท้าว นอ บ้าเจอฮาย กงานา จี่ ล่า คูแง, กงา พาจาว มางนา จี่ ฮูย้า แงแน? ");
INSERT INTO bzi_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","จาว่าแน กงา อ่าโบ้ง กงานา อางเลิ่ง ม่ายฮา ปี่ ล่าชี่ อือ บ่าฮา ยาว, กงานา บ่ากงา เจ่อ ล่าคา. ");
INSERT INTO bzi_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","จ้า กงา อ่าโบ้ง กงานา อางเลิ่ง ม่ายฮา ปี่ ล่าชี่ อือ ฮา ยาว, นอง กงานา บ่าเจ่อ ล่าเวิม, กงา อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ชี อือนา เจ่อ ปาว, ไม้ นองนา ม้าม้า แน แบ ปี่ ล่าง น้อ, อ่าโบ้ง กงาก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ชี, แน กงา อ่าโบ้ง ก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ยาว ยองมู แฮ้ง พระเยซู นา ชา ชู แล่ คู ชีเย. จ้า พระเยซู ย่อฮื่น ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ยาว พระเยซู จอร์แดน ล้างบ้า แฮ้ง คาม แลน ชีเย. ยาว ยาง ยอห์น พิธีบัพติศมา ฮา ดื้งอ่าน โย้เวอ ดื้ง แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ค่องช่าง อางอีบ่าอ่า เย พระเยซู นา ซฺ้าล้า คู ชี. ยองมู นี้ย่า นี้แม้แน จี่ คูง เย, “ยอห์น อางเลิ่งชฺ้างบ่าฮาตอกางอือ บ่าฮา เป. จ้า ยาง พระเยซู นา จี่เคอ ชี แฮ้ กูย่างกูเจ้อ ย้า อางเลิ่ง ม้าม้า เพล่อ ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ยาว โย้เวอ ค่องช่าง อืม อางอีบ่าอ่า เย พระเยซู นา เจ่อ คู ชี. ");
INSERT INTO bzi_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ค่าพ่าย่า ทื่อม่าง จา ชี ยาง อางเม้ง ลาซารัส แน เย. ยา อางม้างกย้า ด้า ยู่น ชีเย. ยา เบธานี ค่อง มารีย์ แน มารธา เย่ด ดื้ง โย้เวอ ดื้ง เย. มารีย์, มารธา แน ลาซารัส ยอ ม้องน้าม กาเย. ");
INSERT INTO bzi_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","มารีย์ นี้ม้า น่อง โย้เวอ พระเยซู ล่าคื่อ โย้เวอ น้ำหอม แฮ้ง ท่อกกาน ยาว, ยาง ต้ามคื้ง แฮ้ง ซีด ปี่ ชี มาง ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","แฮ้งเย่ ลาซารัส อางชี มาง เย่ด ชฺ้าง นา ป้า ยาว พระเยซู นา นี้แม้แน ม่า แอ ปี่ชี่, “อ่าจาน เวอ, นาง อางช่าง ลาก ม้าย่า อามือ ด้า กลา ชี เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","พระเยซู แฮ้แม้ กงากย่า ยาว ยาง นี้แม้แน จี่ ชีเย, “พ่าญ่าด นี้ม้า ลาซารัส นา บ่าฮาย ซฺี้ ปี่ เป. จ้า ยาง พ่าญ่าด นี้เจ้อ เพล่อ ชี นี้ย่า, ไม้ ชฺ้าง อือนา ฮาย พาจาว มาง แน พาจาวอางย่า มาง ล่าที่ อางฮื่อ แฮ้ง กงามย้าง ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","พระเยซู, มารธา, มารีย์ แน ลาซารัส ยองนา ลาก เย. ");
INSERT INTO bzi_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","จ้า พระเยซู ลาซารัส อางม้างกย้า ด้า กลา ชี อางเลิ่ง แฮ้ง แบน เวิม, ยา ยาง ดื้ง ชี โย้เวอ 2 นืง เย ดื้ง แลน แล่ชี่. ");
INSERT INTO bzi_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ยาว พระเยซู ยาง ศิษย์ อือนา นี้แม้แน จี่ช่าง ชีเย, “ยูเดีย แควน โย้เวอ พ่าวแลน แล่คู ปายา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","จ้า ศิษย์ อืม นี้แม้แน จี่พอ คู ชีเย, “อาจ่าน เวอ, บ้าเจอฮาย ยูเดีย แควน โย้เวอ พ่าว แล แล่แง? ชฺ้าง อือย่า นางนา ตื่อนืง ญา เป ลอบา ชา จาน แซ่ ล่า คูแง!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ยาว พระเยซู มือ นี้แม้แน จี่พอ ชีเย, “นืงก้อง นี้ย่า 12 ชั่วโมง จา แง อ่าลา? อ่าซ่าง นืงก้อง เวอ ย่อ แง. ยา คื้อท้อง บ่าท่อง เลิง แล่ เป, ไม้ ชฺ้างอางเมิง นู้เวอ อางแปล้นอางซ้า แฮ้ ยางนา ฮาย มย้าง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","จ้า อ่าซ่าง มู่งคี่ เวอ ย่อ แง, ยา คื้อท้อง ท่อง เลิ่ง แล่แง, ไม้ อางแปล้นอางซ้า บ่าจา วา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","พระเยซู แฮ้แม้แน จี่ เปิน ยาว ยาง ศิษย์ อือนา นี้แม้แน ม่า ชีเย, “ลาซารัส กงา อางช่าง ม้า ยู่น ชี, จ้า กงา โย้เวอ แล ยางนา ตาแค ทาล้า ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ยาว ศิษย์ อืม นี้แม้แน จี่พอ คู ชีเย, “อ่าจาน เวอ, จาว่าแน ยาง ยู่น ชี แนยาว ยา อางทานล้า แล่ ย้าเป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","พระเยซู ลาซารัส นา จี่เคอ เย ยา ซฺี้น ชี แน. จ้า ศิษย์ อือ เย้ง คูง เย พระเยซู ลาซารัส นา จี่เคอ แง ยา ยู่น ชี แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","แฮ้งเย่ พระเยซู ยองนา ปล้อง แน ม่า ชี, “ลาซารัส ซฺี้น ญา เป. ");
INSERT INTO bzi_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","จ้า กงาย่า กงู โย้เวอ บ่ากงา ดื้ง แฮ้งนา กย่าง แง, ไม้ นี้เลิ่ง นองนา ฮาย กงานา ม้าม้า แน เจ่อ ปี่ ล่าง. เดว! กงู ยางนา ซฺ้า แล คู ปายา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ยาว โทมัส ฮาก แฝด แน ฮ้าว มาง ศิษย์ อือนา นี้แม้แน จี่ช่าง ชีเย, “เดว! กงู อ่าจาน ก้อง ทื่งกง่า แน เค่ แล ปายา. กงู ยางก้อง ทื่งกง่า แน ซฺี้ แล คูเซฺ้อ เด่” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","พระเยซู เบธานี ค่อง เคอ แล เมอ, ลาซารัส นา ท้ามชฺ้างซฺี้ชีย้า โย้เวอ ชี 4 นืง เคอ กาชา เย. ");
INSERT INTO bzi_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","เบธานี ค่อง นี้ย่า เยรูซาเล็ม อางเมิง โย้เวอ 3 กิโลเมตร เย เว่อ แง. ");
INSERT INTO bzi_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ค่องช่าง อางบย่า เย มารีย์ แน มารธา เย่ดนา บ่อซฺ้า ล้า ชี, แน เย่ดนา อางช่าง ดื้ง ช่าง เย, ไม้ เย่ด อางแพ้ มาง ซฺี้ ชี แฮ้ง ปาปาย. ");
INSERT INTO bzi_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","มารธา พระเยซู ล้าน ชี แน แบน ยาว อ่อกซฺ้า แอ ชีเย. จ้า มารีย์ ยู้ม เวอ ดื้ง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ยาว มารธา พระเยซู นา นี้แม้แน จี่ช่าง ชีเย, “อ่าจาน เวอ, จาว่าแน นาง นู้เวอ ดื้ง อู้ อ่าแพ้ บ่าซฺี่ นาตู้. ");
INSERT INTO bzi_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","จ้า กงา อางแบ ย้า อามือ เคินเวิม นา พาจาว มางนา บ้าเจอ ป้า เวิม ยา นางนา กูย่างกูเจ้อ ย้า ปี่ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “นางแพ้ แต่ล้า แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ยาว มารธา นี้แม้แน ม่าย ชีเย, “กงา อางแบ ย้า, อ่าแพ้ ชฺ้างอางเมิง นู้เวอ อางนืงลีน แฮ้นืง ก้อง แต่ล้า แล่ แงแน, ยาว อางนืงลีน แฮ้นืง ชฺ้างซฺี้ คาโคลาโค อือ คาตา ย้า แต่ล้า แล่ คู แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ยาว พระเยซู มารธา นา นี้แม้แน จี่ช่าง ชีเย, “กงา ชฺ้างซฺี้ อือนา ฮาย แต่ล้า แล่ ปี่ แง, แน ยองนา จี่วีด ปี่ แง. อ่าซ่าง กงานา นืงบาชี ล่าง, ซฺี้ เวิม แต่ล้า แล่แง. ");
INSERT INTO bzi_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ยาว ชฺ้าง อางแต่ คาโคลาโค กงานา เจ่อ ล่าชี่ อือย่า ยอง อางค่องอางล้า แฮ้ บ่าซฺี่ เป. ท้าว นา นี้แม้แน อางเจ่อ ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ยาว มารธา มือ พระเยซู นา นี้แม้แน จี่พอ ชีเย, “โอ่ย! กงา อางเจ่อ ย้า, นา พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ มาง พาจาวอางย่า ชฺ้างอางเมิง นู้เวอ ลู่งลือ ชี มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ยาว มารธา มือ พ่าวแล มารีย์ นา นี้แม้แน ม่า แล ชีเย, “อ่าจาน ม้า ล้าน ญา. ยา นางนา น้ายซฺ้า ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","มารีย์ พระเยซู ล้าน ชี แน กงากย่า ยาว ยาง ซฺ้อก ย้าเย่ พระเยซู นา แอ ซฺ้าน แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(แฮ้ญ่าม เมอ พระเยซู ค่องคล่าว เวอ บ่ากงา อ้องแล กาซื้ง เย. ยา มารธา ยางนา แอซฺ้า แอ ชี โย้เวอ ดื้ง ชีเย.) ");
INSERT INTO bzi_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ยู้ม โย้เวอ ค่องช่าง มารีย์ นา อางช่าง ดื้งช่าง คูชี อืม, มารีย์ ยู้ม อางเง้ โย้เวอ อ่อกแอน ชี แน มย้าง คู ยาว, ยอง เย้ง คู ชีเย, มารีย์ ท้ามชฺ้างซฺี้ชีย้า โย้เวอ ชา แล อู้ง ดื้ง แล แงแน. แฮ้งเย่ ยอง มารีย์ ก้อง เค่แลน คู ชี. ");
INSERT INTO bzi_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","มารีย์ พระเยซู นา มย้าง ยาว, ยาง พระเยซู ล่าคื่อ โย้เวอ บอกไว้ ชีเย, ยาว อู้ง ชีเย, แน นี้แม้แน จี่ ชีเย, “อ่าจาน เวอ, จาว่าแน นาง นู้เวอ ดื้ง อู้ อ่าแพ้ บ่าซฺี่ นาตู้” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ยาว พระเยซู มารีย์ แน ค่องช่าง ยางนา เค่ลือ คูชี อือ อู้ง ชี แน มย้าง เมอ, ยาง นืงบาต่องบ่าม่อนบ่าซ่า เย. ");
INSERT INTO bzi_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ยาว พระเยซู นี้แม้แน น้าน ชีเย, “นอ ชฺ้างซฺี้ มางนา บ้าเจอล้อเกิ้ง ชี แอ เวอ?” แน. ยาว ยอง นี้แม้แน จี่พอ คู ชีเย, “อ่าจาน เวอ, เค่ฮู ลือ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ยาว พระเยซู มือ อู้ง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ยาว ชฺ้าง อืม นี้แม้แน จี่ ลางกา ชีเย, “ฮู ปาว ยา ลาซารัส นา ล้อม้อก ลาก แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","จ้า ชฺ้าง ทื่อบ่า อือ นี้แม้แน จี่ คูง เย, “ค่าพ่าย่า นี้ม้า ชฺ้างแมปอ อือนา อางฮาย มย้าง ปี่ กงากา. ท้าว ยา บ้าเจอฮาย ลาซารัส นา ตอย ซฺี้ ปี่ แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ยาว พระเยซู นืงบาต่องบ่าม่อนบ่าซ่า เย. ยาว ยาง ท้าม ลาซารัส นา ชี ชี โย้เวอ ย่อย เคิน แอ ชีเย. ท้ามชฺ้างซฺี้ชีย้า ม่านป่อง โย้เวอ ลอบา อางฮื่อ ทื่อซื่อ พี่ ชี ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ยาว พระเยซู นี้แม้แน ม่าย ชีเย, “ลอบา นี้ซื่อ ต่าน อ่อกแอ ปี่ โว!” แน. ยาว มารธา มือ พระเยซู นา นี้แม้แน จี่ช่าง ชีเย, “อ่าจาน เวอ, อางน้าม นาตู, ไม้ ยา ซฺี้ 4 นืง เคิน ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ยาว พระเยซู ยางนา นี้แม้แน จี่ช่าง ชีเย, “มารธา เวอ, นา กงา นางนา ม่า ล่าชี่ แฮ้งนา ลู้ม แอลา? จาว่าแน นาง เจ่อ ยาว นา พาจาว มาง ล่าที่ อางฮื่อ แฮ้ง กงามย้าง แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ยาว ยองมู แฮ้ง ลอบา แฮ้ซื่อ ต่านอ่อก คู ชีเย. ยาว พระเยซู มู่งท่า ป่ากย่า แมก่า แงน คื้นแล ปี่ชี่ เย. ยาว ยาง นี้แม้แน จี่ ชีเย, “อ่าโบ้ง เวอ, ยี่นดี ย้าเป นาง กงานา น้า ล่าชี่ นี้ย่า. ");
INSERT INTO bzi_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","กงา อางแบ ย้า นา กงานา กูเทอ ย้า น้า ล่าแง แน. จ้า กงา นี้แม้แน จี่ นี้ย่า, ไม้ นู้เวอ ชฺ้าง คาโคลาโค อือนา เจ่อ ปี่ แง, นา กงานา ซฺาลือ ปี่ ล่าชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","พระเยซู นี้แม้แน จี่ เปิน ยาว, ยาง อางเซง บื้ง แน นี้แม้แน จี่ ชีเย, “ลาซารัส เวอ อ่อกลืน โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ยาว ลาซารัส ชฺ้างซฺี้ แอ ชี มาง ย่ออ่อก ลืน ชีเย. ยาง ล่าปู่, ล่าคื่อ แน แมก่า โย้เวอ พ้า อางป่อน อือ ปาน ชีเย. ยาว พระเยซู ยองนา นี้แม้แน ม่า ชีเย, “ยางนา พ้า ปาน ชี ชี แฮ้ง พื้ออ่อก ปี่ ปาว, แน ยางนา ตอย แล ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","มารีย์ นา ชฺ้าง เค่ล้า ชี อือ พระเยซู อางเลิ่ง ฮา ชี แฮ้ง กงามย้าง คู ยาว, ชฺ้าง อางบย่า เย พระเยซู นา เจ่อ ชี. ");
INSERT INTO bzi_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","จ้า ชฺ้าง อางมู โย้เวอ ชฺ้าง ทื่อบ่า อือย่า อางเลิ่ง ตอล้า ชี แฮ้ง ฟาริสี มู อือนา อู่บน้า ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","แฮ้งเย่ ปุโรหิต ยอคา มู แน ฟาริสี มู อืม, สภาแซนฮีดริน มู อือนา ฮ้าวช้อน ชี, ยาว นี้แม้แน จี่ ชีเย, “กงูมู นี้ย่า บ้าเจอล้อแม้ ฮา คู วา? ไม้ ค่าพ่าย่า นี้ม้า อางเลิ่งชฺ้างบ่าฮาตอกางอือ อางบย่า ย้า ฮา ชี. ");
INSERT INTO bzi_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","จาว่าแน กงู นี้แม้แน ตอยจาย แล แล่ ปี่ ยาว, ชฺ้าง คาโคลาโค อือย่า ยางนา ย้า เจ่อ คู แง, ยาว โรมชฺ้าง ตาฮ้าน อืม กงู โบสถ์อางฮื่อ แน กงู อางเจ้ออางจาด ชฺ้าง อือนา แซ่ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","จ้า ยอง อางมู โย้เวอ ค่าพ่าย่า ทื่อม่าง จา ชีเย. ยาง อางเม้ง คายาฟาส แน เย. ยา แฮ้ ปี เวอ ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น เพล่อ ชี มาง ย้าเย่. ยาว ยาง ยองนา นี้แม้แน จี่ช่าง ชีเย, “นอ เจิ้นเจ้อ นา บ่าแบ คู ชี. ");
INSERT INTO bzi_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","นอ บ่าแบ คู ล่า ค่าพ่าย่า ทื่อม่าง นา ชฺ้าง อือนา ซฺี้แต่น ปี่ง นี้ย่า, ยิวชฺ้าง คาโคลาโค อือนา ตอย ซฺี้ แอ ปี่ง แฮ้งนา ล่อบ่าปา แม่น แล่แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","คายาฟาส ยาง ทื่อม่าง แน จี่บู่ ชี บ่าอ่า เย. จ้า พาจาว มาง ยางนา แฮ้แม้แน ฮา จี่ ปี่ชี่ เย, ไม้ ยา แฮ้ ปี เวอ ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง ย้าเย่. แฮ้งเย่ พาจาว มาง คายาฟาส นา ยางนา นี้แม้แน จี่แต่น ปี่ชี่, พระเยซู อามือ ยิวชฺ้าง อางเจ้ออางจาด อือนา ชา ซฺี้แต่น แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","พระเยซู ยิวชฺ้าง อางเจ้ออางจาด อือนา แอ่ แน ซฺี้แต่น บ่าอ่า เป. จ้า ยาง ซฺี้ ชี นี้ย่า, ไม้ พาจาว มาง ชฺ้าง คาโคลาโค ชฺ้างอางเมิง นู้เวอ กูต่องกูตี่ แน ดื้ง คูชี อือนา ฮา ทื่อลู่มทื่อเจ่อ กา แน เพล่อ ปี่ แงแน เป. ");
INSERT INTO bzi_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","แฮ้นืง จายล้า ยาว ยิวชฺ้าง ยอคา อืม พระเยซู นา อางญ่าม ซฺ้า ยาว ชา แซ่ คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","แฮ้งเย่ พระเยซู บ้าเจอล้อเกิ้ง แอ เวิม ค่องช่าง อือนา บ่าปี่ แบ แง. ยาว พระเยซู เบธานี ค่อง โย้เวอ จาย แก้บ้า ย่อ เอฟราอิม ค่อง โย้เวอ แอ้น ชีเย. ค่อง นี้ค่อง ซ่องก่องอางเว่อ โย้เวอ อางแท้ เย. ยาว พระเยซู แน ยาง ศิษย์ อืม โย้เวอ ดื้ง คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","แฮ้ญ่าม เมอ ปัสกาป่อยนืง ย่าง แท้ ชาเคิน ล้า ชีเย. ค่องช่าง อางอีบ่าอ่า เย ยอง ค่อง ดื้ง ชี โย้เวอ จาย แก้บ้า ย่อ เยรูซาเล็ม อางเมิง โย้เวอ อ้องแลน คู ชี, ไม้ ยองมู นี้ย่า ปัสกาป่อยนืง บ่าเคอ ฮู่ เวอ พิธี ฮา ค่าตอง อางโต นา ฮาย เซฺิ่งซฺ้าง แล่ ปี่ เปิน เย. ");
INSERT INTO bzi_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ยาว ยองมู แฮ้ง พระเยซู นา ฮู ซฺ้ากว่า คู ชีเย. ยาว ยอง โบสถ์อางฮื่อ อางคล้าว โย้เวอ ทื่งกง่า แน ดื้ง คู เมอ, ยอง นี้แม้แน น้าท้าม ลางกา ชีเย, “นอง เย้ง กานยาว, ยา ปัสกาป่อยนืง นู้เวอ อางลาย ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ยาว ปุโรหิต ยอคา มู แน ฟาริสี มู อืม พระเยซู นา ชา ชู คูงเย แฮ้งย้า ชฺ้าง อือนา นี้แม้แน น้า ชีเย, “พระเยซู ล้อเกิ้ง ดื้ง ชี แน อ่าซ่าง แบ แง. กงูนา ม่า ล่า โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ปัสกาป่อยนืง บ่าเคอ แน 6 นืง จา แล่ง เย. แฮ้ญ่ามเมอ พระเยซู เบธานี ค่อง โย้เวอ แลน ชีเย. ยา ลาซารัส นา ยาง ยู้ม โย้เวอ บ่อซฺ้า แล ชีเย. ลาซารัส ซฺี้ คายาว พระเยซู ฮาย แต่ล้า แล่ ปี่ชี่ มาง ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ยาว ลาซารัส แน ยาง ยู้มชฺ้าง อืม พระเยซู นา มู่งคี่ฮ่าง แต่ง ชี ปี่ชี่. ยาว มารธา อางจฺ่าอางต้าง อือ ท่าม ล้า โตท่า โย้เวอ โบ้ย ล้า ชีเย. ยาว ลาซารัส พระเยซู โต ดื้ง ชี มางก้อง ทื่งกง่า แน ฮ่างจฺ่า ดื้ง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ยาว มารีย์ มือ น้ำหอม อางฮู่ อางคา แฮ้ง ทื่อเกิ่ง ลิตร ท่าม อ้อง ลาน ชีเย. ยาว พระเยซู ล่าคื่อ โย้เวอ ท่อก ล่อง ชีเย, ตื่น ล่าคื่อ ล่าม่า แน ล่าซ่าย ย้าเย่. ยาว ยาง ต้ามคื้ง แฮ้ง ซีด ปี่ชี่, กือ แอ เคอ ย้าเย่. ยาว ยู้ม แฮ้ ยู้ม ก้อง น้ำหอม อางแป่ ฮ้อม โค ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ยูดาส อิสคาริโอท พระเยซู ศิษย์ ชฺ้าง ทื่อม่าง น่อง เวอ พระเยซู นา บ่าแม่น ฮา มาง นี้แม้แน จี่ เย, ");
INSERT INTO bzi_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“บ้าเจอ น้ำหอม แฮ้ง ก่อง ยาว พลู้ แฮ้ง ชฺ้าง อางตูกอางพาน อือนา บ่าปี่ แอ แน? จาว่าแน ก่อง ยาว พลู้ อางบย่า ย้า กงา แง 300 เหรียญ เดนาริอัน อางกงา นาตู้” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ยูดาส นี้แม้ จี่ นี้ย่า ยา ชฺ้าง อางตูกอางพาน อือนา นืงบาพี้ล้อง บ่าอ่า เย. จ้า ยา แล่ค่าว เย, แน ยา ยอง อางมู โย้เวอ พลู้ แพล่อง ฮูพลาฮู มาง ย้าเย่, แน ยา พลู้ แฮ้ง ค่าว เย. ");
INSERT INTO bzi_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ยาว พระเยซู นี้แม้แน จี่ ชีเย, “ยูดาส เวอ, มารีย์ นา บ่าตี่นบ่าต่อง โจ! ยาง นี้แม้แน ฮา ชี นี้ย่า กง่า คางญา. ยา น้ำหอม กอย ชี ชี มี้นืง เคอ ย้า, ไม้ กงา บ่าซฺี่ ฮู่ นู้เวอ น้ำหอม ต่า ล่อ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ชฺ้าง อางตูกอางพาน นี้ย่า นองก้อง กูญ่าม ยา ดื้ง แง. นอย่า ยองนา อ่าล่อม ปล่อง เวิม อางกงา ย้า. จ้า กงา นองก้อง อางมล่าง แน บ่ากงา ดื้ง แล แล่ก้าน” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","พระเยซู เบธานี ค่อง โย้เวอ ดื้ง แงแน ค่องช่าง อางบย่า เย แบน คู ชี. ยาว ยองมู แฮ้ง โย้เวอ ซฺื่ยกา แลน คู ชีเย. จ้า ยอ พระเยซู นา แอ่ แน มย้าง คู ซี้ง บ่าอ่า เย. จ้า ยอ ลาซารัส นา คาตา เย มย้าง คู ซี้ แง, ไม้ ลาซารัส ซฺี้ คายาว พระเยซู ฮาย แต่ล้า ปี่ชี่ มาง ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","แฮ้งเย่ ปุโรหิต ยอคา อืม อางญ่าม ซฺ้า ลาซารัส นา คาตา แน ชา แซ่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ไม้ ลาซารัส ก้อง อางเลิ่ง ตอล้า ชี แฮ้ง ปาปาย ยิวชฺ้าง อางอีบ่าอ่า เย ปุโรหิต ยอคา อือนา วี ยาว พระเยซู นา เจ่อ คูชี. ");
INSERT INTO bzi_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ซอทา แปล้น ล้ายาว ชฺ้าง อางบย่า ปัสกาป่อย เวอ บ่อ ล้า คูชี อืม กงากย่า คู ชีเย, พระเยซู เยรูซาเล็ม อางเมิง เวอ ชา อ้องล้าน ชี แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","แฮ้งเย่ ยอง ปาล์ม พ่า แฮ้ง ท่าม แล่ยาว พระเยซู นา อ่อกซฺ้า แอ คู ชี. ยาว นี้แม้แน จี่โฮ้กฮ้าว คู ชีเย, “โฮซันนา! จี่วีดอางซื้ง เวอ, นาง ซฺาลือ ปี่ชี่ มางนา ก่ามป่อน ปี่ ปาว. แน อิสราเอลชฺ้าง อือ ก่าซ้าด เพล่อ ชี มางนา ก่ามป่อน ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ยาว พระเยซู ลา อางย่า ทื่อม่าง มย้าง ชีเย. ยาว ยาง ลา อางย่า ม่าง ต่างค่าง โย้เวอ ตาดื้ง แล่ ชี่เย. พระคัมภีร์ โย้เวอ นี้แม้แน มอ ยาว แต้ม ชี ชี เย, ");
INSERT INTO bzi_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“เยรูซาเล็มชฺ้าง อือ เวอ, บ่าแค โจ! โย้เวอ ฮู ปาว นาง ก่าซ้าด มาง อามือ ลา แง. ยา ลา อางย่า ตาล้าน ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","แฮ้ญ่าม เมอ พระเยซู ศิษย์ อือ บ่าแบ คู เย พระคัมภีร์ เวอ มอ ยาว แต้ม ชี ชี แฮ้ย่า นี้เลิ่ง นา จี่เคอ แงแน. จ้า น่อง โย้เวอ พระเยซู ซฺี้ ยาว แต่ล้า ล่าที่ อางฮื่อ กงา เปิน เมอ, ยองมู แฮ้ง เย้งกงา แล่ คู ชีเย. พระคัมภีร์ โย้เวอ พระเยซู อางเลิ่ง แฮ้ง มอ ยาว แต้ม ชี ชี, ชฺ้าง อือ พระเยซู นา นี้แม้แน ฮาช่าง แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ยาว ชฺ้าง พระเยซู ลาซารัส นา ฮาย แต่ล้า แล่ ปี่ เมอ มย้าง คูชี อืม, อางเลิ่ง ตอล้า ชี แฮ้ง ฮากนา อู่บน้า ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ยาว ชฺ้าง อางอีบ่าอ่า เย พระเยซู นา ซฺ้า ล้า คูชี, ไม้ ยองมู นี้ย่า กงากย่า คู ชีเย พระเยซู อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ชีแน. ");
INSERT INTO bzi_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","แฮ้งเย่ ฟาริสี อืม นี้แม้แน จี่ ลางกา ชี, “นอ อางมย้าง ล่า กงู ยางนา เจิ้นเจ้อ บ่าฮา กงา กาแน. ฮูปาว ชฺ้าง คาโคลาโค อืม ยางนา เค่ โค คูชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ปัสกาป่อยนืง เคิน ยาว แฮ้ญ่าม เมอ กรีก ชฺ้าง ทื่อบ่า จา ชีเย. เยรูซาเล็ม อางเมิง โย้เวอ แล พาจาว ไว้ แล คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ยาว กรีก ชฺ้าง อืม ฟีลิป นา ซฺ้า แอ ชีเย. ฟีลิป เบธไซดา ค่อง กาลิลี แควน โย้เวอ จายล้า ชีเย. ยาว ยอง ยางนา นี้แม้แน จี่ช่าง ชีเย, “เจ้านาย เวอ, กงู พระเยซู นา มย้าง ซี่ค้า” แน. ยาว ฟีลิป อันดรูว์ นา ม่า แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ยาว เย่ด ซฺื่ย ลางกา พระเยซู นา ม่า แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ยาว พระเยซู เย่ดนา นี้แม้แน ม่า ชีเย, “พาจาวอางย่า ม่าง ล่าที่ อางฮื่อ แฮ้ง ชฺ้าง อือนา ฮาย มย้าง ปี่ ญ่าม ย่าง เคิน ล้า ชา. ");
INSERT INTO bzi_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","กงา อางเลิ่ง ม้าม้า ม่า แบ ปี่ ล่าว่า เป. กอซื่อ ทื่อซื่อ นี้ย่า จาว่าแน นื้งชฺ่า เวอ บ่ากลา แอ ยาว แน นื้งชฺ่า บ่าพูม ชี ยาว กอซื่อ นี้ซื่อ อางอ้าน แฮ้งแม้แน ย้า กอซื่อ ทื่อซื่อ แน เพล่อ แง. จ้า จาว่าแน กอซื่อ นี้ซื่อ นา นื้งชฺ่า พูม ยาว กอซื่อ นี้ซื่อ อางซฺื่อ แต่ แล่แง. แน กอซื่อ บย่า ย้า อ่อกล้า แง. ทื่อช่างกานญา กงา ซฺี้ ยาว ชฺ้าง อางบย่า ย้า จี่วีดม้าม้า กงาบู้ คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","อ่าซ่าง ค่าตอง จี่วีด แฮ้งนา ลาก จ่าแล่ แง กงานา ลาก ล่าง แฮ้ง ล่อบ่าปา แน, ยา กงาซฺี้ แง. จ้า อ่าซ่าง กงานา ลาก ล่าง ค่าตอง จี่วีด แฮ้ง ล่อบ่าปา แน. ยา พาจาว มางก้อง ทื่งกง่า แน จี่วีดม้าม้า กงาจา แล แง. ");
INSERT INTO bzi_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","อ่าซ่าง กงา ย่าเจ่น เพล่อ แง, ยา กงานา เค่กว่า ล่าแง. กงา บ้าเจอล้อเกิ้ง ดื้ง แง. กงา ย่าเจ่น ม่าง คาตา ย้า กงาก้อง ทื่งกง่า แน ดื้ง แง. อ่าซ่าง กงา ย่าเจ่น เพล่อ แง. อ่าโบ้ง ยางนา ก่ามป่อน ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“กงา อามือ นาบาตา ย้า นืงบาต่องลาบ้าบ แง. บ้าเจอล้อแม้ จี่ วา แน บ่าแบตอ กา ชี ล้า, อ้าว กงานา นี้แม้แน จี่ ปี่ ล่าง ล้า, ‘อ่าโบ้ง เวอ, กงานา อามือ ตูกพานลาบ้าบ ชี นี้ง ปล่องปูน ปี่ ล่า ปาว’ แน. แฮ้แม้ บ่าอ่าเป! กงา ชฺ้างอางเมิง นู้เวอ อ้องล้า ชี นี้ย่า, ไม้ อางตูกอางพาน โอ้ด ลือ แอ เป. ");
INSERT INTO bzi_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","อ่าโบ้ง เวอ, นาง ล่าที่ อางฮื่อ แฮ้ง ชฺ้าง อือนา กงามย้าง ปี่ ปาว!” แน. ยาว ซฺ้อก ย้าเย่ มู่งท่า โย้เวอ จาย อางเซง บื้ง ลู่งลืน ชี นี้แม้แน, “กงา แฮ้แม้ ฮาย ยาเป, แน กงา แฮ้แม้ย้า ฮาย แล แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ยาว ชฺ้าง โย้เวอ จูง จา คูชี อืม อางเซง แฮ้ง กงากย่า คู ชีเย. ชฺ้าง ทื่อบ่า อือย่า มู่งเจ่ เจ่ ชี แน จี่ กางเย. จ้า ทื่อบ่า อือ นี้แม้แน จี่ กางเย, “เท่วาด่า ทื่อม่าง ยางนา จี่ช่าง ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ยาว พระเยซู ยองนา นี้แม้แน จี่ช่าง ชีเย, “นอง อางเซง กงากย่า คูชี แฮ้ย่า กงา จองไจ กงาบู้ บ่าอ่า, จ้า นองนา ฮาย แบ ปี่ล่าง พาจาว ม้า กงานา ซฺาลือ ปี่ ล่าชี่ แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","อามือ ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา พาจาว มาง อางซี ต้าดต่อน อางญ่าม ย่าง เคินญา เป. แน พาจาว ม้า ซาตานแด่ย่ายอคา ชฺ้างอางเมิง ฮูพลา ชี มางนา ก่าอ่อก ฮื่น ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","กงานา ไม้กางเขน ท่า โญก ชี ล่า เมอ, กงา ชฺ้าง คาโคลาโค อือนา ฮาย กงานา ซฺ้าล้า ปี่ ล่าแน” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","พระเยซู นี้แม้แน จี่ นี้ย่า ม่าแบ ปี่ง ยา บ้าเจอล้อแม้ ซฺี้ แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","แฮ้งเย่ ชฺ้าง อืม ยางนา นี้แม้แน น้าน คู ชี, “พระคัมภีร์ โย้เวอ มอ ยาว แต้ม ชี ชี บ่าอ่า ล่า พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ มาง ซฺี้นืง บ่าจา แน? ท้าว บ้าเจอ นา นี้แม้แน อางจี่ แน, ชฺ้างอางย่า ม่างนา ไม้กางเขน ท่า โญก ชี แงแน? ท้าว ชฺ้างอางย่า ม้า อ่าซ่าง เวอ?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ยาว พระเยซู ยองนา นี้แม้แน จี่พอ ชีเย, “อางแปล้นอางซ้า นี้ย่า นองก้อง ทื่อชี่ด ญา ดื้ง แง. นี้แม้แนยาว นอย่า นองก้อง อางแปล้นอางซ้า จา เมอ ย่อย แลน โว. อางวื้งอางว้าง มางนา นองนา บ่าเค่ เคิ้ด ปี่ ล่าโจ! อ่าซ่าง อางวื้งอางว้าง เวอ ย่อ แง, ยา บ้าเจอล้อเกิ้ง ย่อย แอ วา แน บ่าแบ เป. ");
INSERT INTO bzi_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","นองก้อง อางแปล้นอางซ้า มาง จา เมอ, อางแปล้นอางซ้า มางนา นืงบาชี คู ปาว เป. ยาว นอง อางแปล้นอางซ้า มาง อางย่า กงาเพล่อ คู แง” แน. พระเยซู แฮ้แม้แน จี่ เปิน ยาว ยาง เจิ่ก แลน ชีเย, แน ยา อ่าซ่าง มาง ยางนา บ่าซฺ่า มย้าง กาง โย้เวอ แล ดื้ง แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","พระเยซู ชฺ้าง อือ ล้าก้า โย้เวอ อางเลิ่งชฺ้างบ่าฮาตอกางอือ อางบย่า เย ฮาย ชี. จ้า บ้าเจอล้อแม้เวิม ยองมู แฮ้ง ยางนา บ่าเจ่อ คู เย. ");
INSERT INTO bzi_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ยาว นี้ย่า อิสยาห์ พาจาวจี่ต่างจี่แต่นฮู มาง มอ ชี ชี แม้แน ย้าเย่ เพล่อ ชี. ยา นี้แม้แน มอ ชี ชีเย, “จี่วีดอางซื้ง เวอ, อ่าซ่าง จา แง, กงู อางเลิ่ง ม่า ชี แฮ้งนา อางเจ่อ แน? แน อ่าซ่าง จา แง, นาง ล่าที่ แฮ้งนา อางมย้าง แน?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","แน ยอง บ่าเจ่อ คูง แฮ้ย่า, ไม้ อิสยาห์ นี้แม้แน มอ ชี ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“พาจาว ม้า ยอง แมนือ แฮ้งนา ฮาย แมปอ เพล่อ ปี่ชี่. แน ยอง นืงบา มางนา ฮาย ลื้กล้าน ปี่ชี่. ไม้ ยอง แมนือ แฮ้งนา บ่าปี่ ฮู มย้าง แนนอ. แน ยอง นืงบา มางนา บ่าปี่แบ แนนอ. ยอ กงาก้อง บ่าพ่าว ล้า แน กงานา อางบล่าบ บ่าปี่ ปล่องปูน ปี่ ล่า คู” แน. ");
INSERT INTO bzi_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","อิสยาห์ นี้แม้แน จี่ ชี นี้ย่า ไม้ ยา แบน ชีเย, จ้างจ้าง พระเยซู ล้อม้อก ฮื่อ แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ชฺ้าง อางบย่า แน ตื่น ยิวชฺ้าง ยอคา อือ คาตา ย้าเย่ พระเยซู นา เจ่อ คูชี. จ้า ยอ อ่าซ่าง มางนา บ่าม่า แบ ปี่ จอ กาเย, ไม้ ฟาริสี อือ ยองนา ยิวชฺ้าง โบสถ์ โย้เวอ ก่าอ่อก นา แค คูง เย. ");
INSERT INTO bzi_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ชฺ้าง นี้อือย่า ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือ โญกจ่าญ่อจ่าง แฮ้งนา พาจาว มาง โญกจ่าญ่อจ่าง แฮ้งนา ล่อบ่าปา เย ลาก คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ยาว พระเยซู นี้แม้แน จี่โฮ้ก ชีเย, “อ่าซ่าง กงานา เจ่อ ล่าง, ยา กงานา ทื่อม่าง แน เจ่อ ล่าง บ่าอ่า เป. จ้า ยา พาจาว กงานา ซฺาลือ ปี่ ล่าชี่ มางนา คาตา ย้า เจ่อ แง. ");
INSERT INTO bzi_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","อ่าซ่าง กงานา ฮู มย้าง ล่าแง. ยา พาจาว กงานา ซฺาลือ ปี่ ล่าชี่ มางนา คาตา ย้า ฮู มย้าง แง. ");
INSERT INTO bzi_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","กงาย่า ชฺ้างอางเมิง นู้เวอ อางแปล้นอางซ้า เพล่อ ลือ แอ้, ไม้ ชฺ้าง คาโคลาโค กงานา เจ่อ ล่า คูชี อือนา อางวื้งอางว้าง เวอ บ่าปี่ ดื้ง แล่ก้าน แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","กงา ชฺ้าง กงา ม่าอู่บจี่ต่าง แฮ้ง กงากย่า ยาว บ่าฮาย เค่ อือนา อางซี บ่าต่าดบ่าต่อน, ไม้ กงา ลือ ชี นี้ย่า ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา อางซี ต้าดต่อน ลือ แอ บ่าอ่า, จ้า ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา อางบล่าบ ปล่องปูน ลือ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","จ้า ชฺ้าง กงานา บ่าเจ่อ ล่าง อือนา, แน ชฺ้าง กงา ม่าอู่บจี่ต่าง แฮ้ง บ่าน่า จ่าง อือนา ชฺ้างอางเมิง นู้เวอ อางนืงลีน แฮ้นืง กงา ม่าอู่บจี่ต่าง นี้ง ย้าเป ยองนา อางซี ต้าดต่อน แง. ");
INSERT INTO bzi_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","นี้ย่า อางเลิ่ง ม้าม้า เป, ไม้ กงาย่า ค่าตอง นืงบาจาบวา แน บ่ากงา จี่, จ้า จี่ต่าง นี้อือ พาจาว กงานา ซฺาลือ ปี่ ล่าชี่ มาง ม่า จี่ ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","กงาย่า พาจาว มาง กงานา ม่า จี่ ปี่ ล่า ชี่ แม้แน จี่ แง, กงา อางแบ พาจาว มาง ม่าอู่บจี่ต่าง นี้ย่า จี่วีดม้าม้า ปี่ แงแน. นี้งย้า กงาย่า กูย่างกูเจ้อ อ่าโบ้ง กงานา ม่าย ม่าอู่บ ปี่ ล่าง แฮ้ง ม่าอู่บ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ปัสกาป่อยนืง ชาเคอ ล้า เมอ พระเยซู แบน ชีเย, ยาง ชฺ้างอางเมิง นู้เวอ เจิ่ก ยาว พาจาว ยาง อางโบ้ง มาง ก้อง แล ญ่าม ย่าง เคิน ล้า ชี แน. พระเยซู ยาง ศิษย์ อือนา ลาก เย. แฮ้งเย่ ยาง ศิษย์ อือนา ฮาย มย้าง ปี่ชี่ ยา ยองนา ล้อม้อก ลาก แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ซาตานแด่ย่ายอคา มาง ยูดาส, ซีโมนอิสคาริโอท อางย่าย่าค่า มางนา ฮาย พระเยซู นา บ่าแม่น เย้ง ฮา ปี่ ชี่ นี้ย่า มล่าง กาชา เย. พระเยซู แน ยาง ศิษย์ อือ ทื่งกง่า แน มู่งคี่ฮ่าง ดื้ง จฺ่า คู ชี. ");
INSERT INTO bzi_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","พระเยซู อางแบ เย ยาง อางโบ้ง ม้า ยางนา ล่าที่ ปี่ กูย่างกูเจ้อ อือ ล่อบ่าปา แน ฮื่อ ปี่ชี่ แน. แน ยา อางแบ จ่าแล่ ยา พาจาว มางก้อง จายลือ ชี แน. แน ยา อามือ พาจาว มางนา ชา พ่าว ซฺ้าแล แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","แฮ้งเย่ พระเยซู มือ ทาย อ่อกแอน ยาว ยาง ค่าลาวอางเง้โลบแล่เซฺ่อ ย่าง แลอ่อก แล่ชี่. ยาว พ้า แฮ้ง ยาง อางจ่อ โย้เวอ ป้าน แล่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ยาว พระเยซู มือ ล้าง ย้าง ทวยซ้าม เวอ ท่อกกาน ยาว ยาง ศิษย์ อือนา ล่าคื่อ ชี่ ปี่ ชีเย. ยาว ยาง อางจ่อ เวอ พ้า ป้าน แล่ชี่แฮ้ง ยอง ล่าคื่อ โย้เวอ ซีด ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ยาว ซีโมนเปโตร นา ล่าคื่อ ชี่ ปี่ต่า ย้าง เคิน ชีเย. ยาง พระเยซู นา นี้แม้แน น้าน ชีเย, “อ่าจาน เวอ, นา กงานา ล่าคื่อ ชา ชี่ ล่าง ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ยาว พระเยซู มือ นี้แม้แน จี่พอ ชีเย, “นา อามือ บ่าแบ กาซื้ง กงา บ้าเจอ ชา ฮา แงแน. จ้า นา น่องเวอ กงาแบ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ยาว ซีโมนเปโตร มือ นี้แม้แน จี่ ชีเย, “กงา นางนา กงา ล่าคื่อ นี้ง บ่าปี่ ชี่ ล่า เป” แน. ยาว พระเยซู มือ นี้แม้แน จี่พอ ชีเย, “จาว่าแน กงา นางนา ล่าคื่อ บ่ากงา ชี่ ล่ายาว นา กงา ศิษย์ บ่าอ่า เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","แฮ้งเย่ ซีโมนเปโตร มือ นี้แม้แน จี่พอ ชี, “อ่าจาน เวอ, นี้แม้แนยาว กงา ล่าคื่อ นี้ง แอ่ แน บ่าชี่ ล่าโจ. จ้า กงา ล่าปู่ แน อางตู่ อือ คาตา แน ชี่ ล่าปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ยาว พระเยซู มือ ยางนา นี้แม้แน ม่า ชีเย, “ชฺ้าง ล้างคล่าว แล่ชี่ อือย่า ตื่งโต ย้า เซฺิ่งซฺ้าง แง. ล่าคื่อ แฮ้ง แอ่ แน ชี่ แล่ เวิม กงา คางญา. นองมู นี้ย่า เซฺิ่งซฺ้าง ลางญา. จ้า ทื่อม่าง จา แง บ่าเซฺิ่งบ่าซฺ่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","พระเยซู อางแบ เย ยางนา น่อง โย้เวอ อ่าซ่าง บ่าแม่น ฮา แงแน. แฮ้งเย่ ยาง นี้แม้แน จี่ ชี, “นองมู นู้เวอ ทื่อม่าง จา แง บ่าเซฺิ่งบ่าซฺ่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","พระเยซู ยาง ศิษย์ คาโคลาโค อือนา ล่าคื่อ ชี่ ปี่ เปิน ยาว, ยาง ค่าลาวอางเง้โลบแล่เซฺ่อ ย่าง กอย ตูม แล่ยาว ดื้งลู่ง ลื่อ ชีเย. ยาว ยาง ศิษย์ อือนา นี้แม้แน น้าน ชีเย, “นอ อางแบ คู ล่า กงา บ้าเจอฮา แงแน? ");
INSERT INTO bzi_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","นอ กงานา อ่าจาน แน จี่วีดอางซื้ง แน ฮ้าว ล่า คูแง. นอง กงานา แฮ้แม้ ฮ้าว ล่า คูง นี้ย่า กง่า คางญา, ไม้ กงา แฮ้แม้ ม้าม้า น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","นี้แม้แนยาว จาว่าแน กงา จี่วีดอางซื้ง เพล่อ ชี มาง, แน นอง อ่าจาน เพล่อ ชี มาง นองนา ล่าคื่อ ชี่ ปี่ ล่ายาว, นองมู นี้ง ล่าคื่อ ชี่ ปี่ ลางกา ปาว. ");
INSERT INTO bzi_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","กงา นองนา ฮายฮู ปี่ ล่าย่า, นอง ฮาย เค่ คู ปาว. ");
INSERT INTO bzi_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","กงา นองนา อางเลิ่ง ม้าม้า ม่าแบ ปี่ ล่าว่า, ย่าเจ่น นี้ย่า ยาง เจ้านาย มาง ล่อ แน บ่าฮื่อ, แน ชฺ้าง อางเลิ่ง ม่า ลือ ชี ม้า ยางนา ซฺาลือ ปี่ ชี มาง ล่อ แน บ่าฮื่อ. ");
INSERT INTO bzi_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","จาว่าแน นอง อางเลิ่ง ม้าม้า นี้อือ นา แบน ยาว ฮา เค่ ยาว นอ ก่ามป่อน กงาบู้ คูแง ม้าม้า ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงา นองมู คาโคลาโค นี้งนา บ่ากงา จี่เคอ ล่าเป. จ้า กงาย่า กงา ชฺ้าง แช้ ชี ชี อือนา อางแบกงากา ย้า. จ้า อางเลิ่ง มอ ยาว พระคัมภีร์ โย้เวอ แต้ม ชี ชี แฮ้ย่า ม้าม้า ย้า ตอล้า แง. พระคัมภีร์ โย้เวอ นี้แม้แน แต้ม ชี ชี, ‘ชฺ้าง กงา จฺ่าเกิ่ง กงาก้อง ทื่งกง่า แน จฺ่า ชี ม้า น่อง โย้เวอ กงานา บ่าแม่น ฮา ล่าง’ แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","อามื้อ อางเลิ่ง นี้เลิ่ง บ่าตอล้า กาซื้ง เป. จ้า กงา นองนา อางเลิ่ง นี้เลิ่ง บ่าตอล้า เมอ ย้า ม่า ชี ล่าแง, ไม้ อางเลิ่ง นี้เลิ่ง ตอล้า เมอ, นองนา เจ่อ ปี่ ล่าแง, กงา พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ ชี่ มาง ย้า แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","กงา นองนา อางเลิ่ง ม้าม้า ม่าแบ ปี่ ล่าว่า, อ่าซ่าง กงา ชฺ้าง ซฺาแอ ปี่ชี่ อือนา เจ่อ แง, ยา กงานา คาตา ย้า เจ่อ ล่าง. อ่าซ่าง กงานา เจ่อ ล่าแง, ยา พาจาว กงานา ซฺาลือ ปี่ ล่าชี่ มางนา คาตา ย้า เจ่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","พระเยซู จี่ เปิน ยาว นาบาตา เย่ นืงบาต่องลาบ้าบ ชี. ยาว ยาง นี้แม้แน จี่ ชีเย, “กงา อางเลิ่ง ม้าม้า แฮ้ง ม่าแบ ปี่ ล่าว่า, นอง อางมู นู้เวอ ชฺ้าง ทื่อม่าง จา แง, กงานา บ่าแม่น ฮา ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ยาว ศิษย์ อืม แมก่า พลาบฮู ลางกา ชีเย, ไม้ ยอ บ่าแบ เย พระเยซู อ่าซ่าง นา จี่เคอ แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ยาว พระเยซู ศิษย์ อางมู โย้เวอ ชฺ้าง ทื่อม่าง จา ชี พระเยซู อางลาก แน. ยา พระเยซู ก่องทาง โย้เวอ ดื้งเง้น แน ดื้ง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","แฮ้งเย่ ซีโมนเปโตร มือ ศิษย์ แฮ้มางนา แมก่า ฮู ชี, ไม้ ยา ศิษย์ แฮ้มางนา ไจ น้า ปี่ง เย, พระเยซู อ่าซ่าง นา จี่ เคอ แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","แฮ้งเย่ ศิษย์ แฮ้มาง พระเยซู ก้อง แท้ แน ซาด อ้องแลน ยาว นี้แม้แน น้าน ชี, “อ่าจาน เวอ, นา อ่าซ่าง นา จี่เคอ แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ยาว พระเยซู นี้แม้แน ม่า ชีเย, “ชฺ้าง แฮ้ม้า กงา ค้านู้มป่าง นี้ง น้ำจิ้ม เวอ คี ยาว ปี่ แฮ้มาง ย้า” แน. ยาว พระเยซู มือ ค้านู้มป่าง แฮ้ง น้ำจิ้ม เวอ คี ยาว ยูดาส, ซีโมนอิสคาริโอท อางย่า มางนา ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ยาว ยูดาส มือ ค้านู้มป่าง ย้าง ยู้ท่าม แล่ ชี่เย. ยาว ซาตานแด่ย่ายอคา เพล่อ ชี มาง ยางนา อ้อง ปี่ชี่ เย. แฮ้งเย่ พระเยซู มือ ยูดาส นา จี่ช่าง ชี นี้แม้แน, “บ้าเจอ ชา ฮา แง, อางไว่ แน ฮาย ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ชฺ้าง คาโคลาโค โย้เวอ ดื้ง จา คูชี อืม บ่าแบ คู เย. พระเยซู บ้าเจอฮาย ยูดาส นา แฮ้แม้แน จี่ช่าง แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ชฺ้าง ทื่อบ่า อือย่า นี้แม้แน เย้ง คูง เย, พระเยซู ยางนา ม่า ป่อยนืง โย้เวอ อางเกิ่งอางก้อ กงาไจ แฮ้ง วื้อ แอ ปี่ชี่ แน. บ่าอ่ายาว ยางนา ม่าย อางเกิ่งอางก้อ ทื่อบ่า อือ ชฺ้าง อางตูกอางพาน อือนา เปิ่งปี่ ปี่ชี่ แน, ไม้ ยูดาส พลู้ แพล่อง ท่าม ฮู เย. ");
INSERT INTO bzi_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","จ้า ยูดาส ค้านู้มป่าง แฮ้ง จฺ่า แล่ยาว ซฺ้อก ย้าเย่ อางเง้ เวอ อ่อกแอน ชี, แน แฮ้ญ่ามเมอ มู่งคี่ เย. ");
INSERT INTO bzi_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ยูดาส อ่อกแอน ยาว พระเยซู นี้แม้แน จี่ ชีเย, “ชฺ้าง อือ ชฺ้างอางย่า มาง ล่าที่ อางฮื่อ แฮ้ง กงามย้าง ย้าง อางญ่าม เคอ กาชา, แน ชฺ้างอางย่า มางก้อง อางเลิ่ง ตอล้า ชี นี้ย่า ชฺ้าง อือนา ฮาย พาจาว มาง ล่าที่ อางฮื่อ แฮ้ง กงามย้าง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ยาว นี้ง ย้าเป พาจาว มาง ชฺ้าง อือนา ฮาย ชฺ้างอางย่า มาง ล่าที่ อางฮื่อ แฮ้ง มย้าง ปี่ชี่ นี้ย่า, แน ยา ซฺ้อก ย้า แฮ้แม้แน ฮา แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่, “กงา อางย่า ลาก อือ เวอ, กงา นองก้อง อางมล่าง แน บ่ากงาดื้ง ชีล้า. ยาว นอ กงานา ซฺ้า กว่า ล่า คูแง, แน กงา ยิวชฺ้าง ยอคา อือนา ม่า ชี แฮ้งแม้แน ย้า นองนา ม่า ล่าง, นอ กงา ชา แล โย้เวอ บ่าแล กงา กาเป. ");
INSERT INTO bzi_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","กงา นองนา อางลี้บอางล่าว อางซฺื่อ ปี่ ล่าปานา, ลากฮูม ลางกา โว! กงา นองนา บ้าเจอล้อแม้ ลาก ล่าแง, นอง แฮ้แม้แน ย้า ลากฮูม ลางกา โว! ");
INSERT INTO bzi_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","นองมู นี้ง ลาก ลางกา ยาว, ชฺ้าง คาโคลาโค อืม กงาแบ คูแง, นอ กงา ศิษย์ อือ ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ยาว ซีโมนเปโตร พระเยซู นา นี้แม้แน น้าน ชีเย, “จี่วีดอางซื้ง เวอ, นา ล้อเกิ้ง ชา แล แง?” แน. ยาว พระเยซู มือ ยางนา นี้แม้แน ม่าย ชีเย, “กงา ชา แล โย้เวอ อามือ นา บ่าเค่ แล กงา กางซื้ง. จ้า นา น่อง โย้เวอ กงานา เค่ ล้า ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ยาว เปโตร มือ นี้แม้แน น้าน แล่ ชี่เย, “จี่วีดอางซื้ง เวอ, บ้าเจอ กงา อามือ นางนา บ่าเค่ แล ล่า กงากา แน? กงา นาง ปาปาย แน ซฺี้ เวิม อางกงา เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “นา กงา ปาปาย ซฺี้ อางกงา ม้าม้า ลา? กงา อางเลิ่ง ม้าม้า ม่าแบ ปี่ ล่าว่า, ยาพ่า บ่าต่านฮู่ เวอ นา กงานา บ่าแบล่ากงา กาแน 3 เทอ จี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","พระเยซู ยาง ศิษย์ อือนา จี่ช่าง ชีเย นี้แม้แน, “บ่าม่านบ่าชู คูโจ! พาจาว มางนา แน กงานา นืงบาชี ล่า คูโว! ");
INSERT INTO bzi_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","พาจาว กงา อางโบ้ง มาง ยู้ม โย้เวอ อางฮ้อง อางบย่า จา แง. จ้า แฮ้แม้ ม้าม้า แน บ่าจา ยาว กงา นองนา บ่าม่า ล่าเป, กงา โย้เวอ ชา แล ยาว นองนา ดื้งย้า ซฺ้า ชี ล่าง. ");
INSERT INTO bzi_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ยาว น่อง โย้เวอ กงา นองนา ดื้งย้า ซฺ้า ชี ล่าเปิน, ยาว กงา พ่าวลือ นองนา กงาก้อง ทื่งกง่า แน ซฺื่ย ดื้ง แล่ ล่าแน. ");
INSERT INTO bzi_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","นอ กงา แก้บ้า ชา แล แฮ้งนา อางแบกงากา ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ยาว โธมัส พระเยซู นา นี้แม้แน ม่า ชีเย, “อ่าจาน เวอ, กงู บ่าแบ นอ นา ล้อเกิ้ง ชา แล แงแน. ท้าว กงู ล้อแม้ แก้บ้า แฮ้งนา แบกงา กาแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ยาว พระเยซู นี้แม้แน ม่า ชีเย, “กงา แก้บ้า แฮ้เซน ย้าเป, แน กงา อางเลิ่ง ม้าม้า มาง ย้าเป, แน กงา จี่วีดม้าม้า ปี่ มาง ย้า. อ่าซ่าง มาง อ่าโบ้ง ก้อง บ่าแล กงากา จาว่าแน กงา ป่ากย่า บ่าล่า ยาว. ");
INSERT INTO bzi_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","จ้า นอง กงานา อางแบ ล่า กงากา แนยาว, นอ อ่าโบ้ง นา คาตา ย้า แบ กงา กาแง. ยาว นู้เวอ จายแล ปี่ง นี้ย่า นอ ยางนา อางแบกงากา ย้า แน ยางนา กงามย้าง ญา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ยาว ฟีลิป พระเยซู นา นี้แม้แน จี่ช่าง ชีเย, “จี่วีดอางซื้ง เวอ, กงูนา อ่าโบ้ง นา กงามย้าง ปี่ ล่าปาว. นี้ม้อก นี้ง กงู นืงบาจาบ คางญ้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “ฟีลิป เวอ, กงา นางก้อง ดื้งล้า มล่าง คางญ้า, ท้าว นา กงานา บ่าแบล่ากงา กาลา? ชฺ้าง กงานา มย้าง ล่าชี่ อือย่า อ่าโบ้ง นา คาตา ย้า มย้าง ชี. ท้าว นา บ้าเจอ นี้แม้ อางจี่ แน, ‘กงูนา อ่าโบ้ง นา กงามย้าง ปี่ ล่าปาว’ แน? ");
INSERT INTO bzi_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","นา บ่าเจ่อ ล่า, กงา พาจาว กงา อางโบ้ง มางก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ชีแน. ยาว อ่าโบ้ง กงาก้อง ทื่อลู่มทื่อเจ่อ ย้า เพล่อ ชีแน. ม่าอู่บจี่ต่าง กงา นองนา ม่าอู่บ ล่าชี่แฮ้ง, กงา นืงบาจาบวา แน บ่ากงา จี่ เป. จ้า อ่าโบ้ง กงาก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ชี ม้า กงานา ไจ ยาง ล่ากาน แฮ้ง ว่า ปี่ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","กงานา เจ่อ ล่าปาว. กงา นองนา นี้แม้แน ม่า ล่าเมอ, อ่าโบ้ง กงาก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ชี, แน กงา อ่าโบ้ง ก้อง ทื่อลู่มทื่อเจ่อ เพล่อ แงแน. จ้า นอง กงา จี่ แฮ้งนา บ่าเจ่อ ยาว, กงา อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ชี แฮ้งนา ฮู ปาว, แน เจ่อ ปาว. ");
INSERT INTO bzi_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“กงา นองนา อางเลิ่ง ม้าม้า ม่าแบ ปี่ ล่าว่า, อ่าซ่าง กงานา เจ่อ ล่าง, กงา แม้แน อางเลิ่ง นี้อือเจ้อ อางฮา กงา กาเป. แน ยอ อางเลิ่ง อางฮื่อ นี้ล่อบ่าปา ฮา กงา กาแง, ไม้ อามื้อ กงาย่า อ่าโบ้ง ก้อง ชา แล น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","นี้แม้แนยาว นองมู กงา ชฺ้าง เพล่อ ชี อือย่า, กงานา บ้าเจอ ป้า ล่าแง. กงา นอง กงานา ป้า ล่าชี่ แฮ้งแม้แน ย้า ปี่ ล่าง, ไม้ กงานา ฮาย ชฺ้าง อือนา อ่าโบ้ง ล่าที่ อางฮื่อ แฮ้ง มย้าง ปี่ แง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","นอ กงานา บ้าเจอ ป้า ล่าเวิม, กงา นองนา กูย่างกูเจ้อ ย้า ฮา ปี่ ล่าแง, ไม้ นอ กงา ชฺ้าง น้อ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “นอง กงานา ลาก ล่ายาว, นอ กงา ม่าอู่บจี่ต่าง แฮ้ง อางฮา เค่ ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ยาว กงา อ่าโบ้ง นา ป้า แง, แน อ่าโบ้ง นองนา ปล่องฮู ปี่ ล่าแง, แน ปล่องฮู นี้มาง นองก้อง ทื่งกง่า แน จา แล แง. ");
INSERT INTO bzi_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ปล่องฮู นี้ม้า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง นองนา พาจาว มาง อางเลิ่ง ม้าม้า แฮ้ง ฮาแบ ปี่ ล่าง มาง ย้า. จ้า ชฺ้างอางเมิง นู้เวอ ชฺ้าง ทื่อบ่า อือย่า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มางนา ยองก้อง บ่าปี่ ดื้ง, ไม้ ยอ บ่าฮูมย้าง กา แน บ่าแบกงา กา. จ้า นอ อางแบกงากา ย้า, ไม้ อางค่องอางล้า อางเซฺิ่งอางซฺ้าง นี้ม้า นองก้อง ทื่งกง่า แน ดื้ง แง, แน นองก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงา อ่าโบ้ง ก้อง แล ยาว นองก้อง พ่าวลือ แล่แง, ไม้ กงา นองนา ย่าช่าวย่า แม้แน บ่าวี ล่าเป. ");
INSERT INTO bzi_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","บ่ามล่าง ยาว ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือย่า กงานา บ่ามย่าง ล่าก้าน. จ้า นอ กงานา อางมย้าง ล่าย้า, ไม้ กงา จี่วีดม้าม้า จา แง, แน นอง คาตา ย้า จี่วีดม้าม้า จา แล แง. ");
INSERT INTO bzi_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","กงา แต่ล้า แล่ แฮ้นืง เคอ ล้า เมอ นอ กงาแบ คูแง, กงา อ่าโบ้ง ก้อง ทื่อลู่มทื่อเจ่อ ย้า เพล่อ ชีแน. ยาว นอ กงาก้อง ทื่อลู่มทื่อเจ่อ ย้า เพล่อ ชีแน. ยาว กงา นองก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ชีแน. ");
INSERT INTO bzi_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ชฺ้าง กงา ม่าอู่บจี่ต่าง แฮ้ง กงากย่า ยาว ฮา เค่ ชี อือ ชฺ้าง กงานา ลาก ล่าง อือ ย้า. ยาว อ่าโบ้ง คาตา ย้า ชฺ้าง กงานา ลาก ล่าง อือนา ลาก แง. ยาว กงา คาตา ย้า ยองนา ลาก แง. ยาว กงา ยองนา ฮาย กงานา มย้าง ปี่ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ยาว ชฺ้าง ทื่อม่าง จา แง, ยาง อางเม้ง ยูดาส แน, ยา พระเยซู ศิษย์เอก เย (ยูดาส นี้ม้า ยูดาส อิสคาริโอท บ่าอ่า เย.) ยา นี้แม้แน น้าน ชีเย, “จี่วีดอางซื้ง เวอ, ท้าว นา บ้าเจอ ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา บ่าปี่แบ แน? ท้าว นา บ้าเจอฮาย กงูนา แบ ปี่ ล่าแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ยาว พระเยซู ยางนา นี้แม้แน ม่า ชีเย, “อ่าซ่าง กงานา ลาก ล่าแง, กงา ม่าอู่บจี่ต่าง แฮ้ง ฮา เค่ แง. ยาว อ่าโบ้ง ยางนา ลาก แง. ยาว อ่าโบ้ง ไกง้ ยางนา ซฺ้าลือ ยาว ยางก้อง จาดื้ง แง. ");
INSERT INTO bzi_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","อ่าซ่าง กงานา บ่าลาก ล่าแง, ยา กงา ม่าอู่บจี่ต่าง แฮ้งนา บ่า ฮา เค่. ยาว ม่าอู่บจี่ต่าง นอง กงากย่า ชี นี้ย่า กงา จี่ต่าง บ่าอ่า, จ้า อ่าโบ้ง กงานา ซฺาลือ ปี่ ล่าชี่ มาง จี่ต่าง เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงา นองก้อง ทื่งกง่า แน ดื้ง เมอ นองนา อางเลิ่ง นี้อือ อู่บน้า ปี่ ล่าย่า. ");
INSERT INTO bzi_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ยาว น่อง โย้เวอ อ่าโบ้ง นองนา ปล่องฮู ปี่ ล่าแง. ปล่องฮู นี้ม้าย่า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ย้า. อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ม้า กงานา แต่น ลือ ล่าแง, แน นองนา กูย่างกูเจ้อ ย้า ม่าอู่บ ล่าแง, แน นองนา ฮาย กงา อางเลิ่ง คาโคลาโค อู่บน้า ปี่ ล่าชี่ อือ จามกงา ปี่ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “บ่าม่านบ่าชู คูโจ, แน บ่าแค คูโจ! ไม้ กงา นองนา ฮา นืงบาต่องจาบื่อดื้งบื้อ ปี่ ล่าแง. ยาว กงา นองนา ฮา นืงบาต่องจาบื่อดื้งบื้อ ปี่ ล่าชี่ แฮ้ย่า, นอง ชฺ้างอางเมิง นู้เวอ กงาบู้ ชี แฮ้งนา บ่าตู่ เป. ");
INSERT INTO bzi_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","นอ กงา จี่ แฮ้งนา กงากย่า ญา. กงา นี้แม้แน จี่ แอ, ‘กงา อามือ ชา เจิ่ก แล แง, จ้า กงา นองก้อง พ่าว ลือ แล่แง’ แน. นอง กงานา ลาก ล่าแง แนยาว, นอ กงา อ่าโบ้ง นา ชา ซฺ้า แล แฮ้งนา อางกย่าง คูย้า, ไม้ ยา กงา ล่อบ่าปา ล่าที่ ฮื่อ แง. ");
INSERT INTO bzi_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","อามื้อ อางเลิ่ง นี้เลิ่ง บ่าตอ ล้า กางซื้ง เป. จ้า กงา นองนา อางเลิ่ง นี้เลิ่ง ม่า ชี ล่าเปิน แง, ไม้ อางเลิ่ง นี้ง ม้าม้า แน ตอ ล้า เมอ, นองนา เจ่อ ปี่ ล่าง น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“กงา นองนา ม่าอู่บ ล่าญ่าม อางบย่า แน บ่าจา, ไม้ ซาตานแด่ย่ายอคา ชฺ้างอางเมิง ฮูพลา ชี ม้า อามือ ชา ล้า แง. จ้า ยา กงา ล่อ แน ล่าที่ บ่าฮื่อ เป. ");
INSERT INTO bzi_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","จ้า กงา อ่าโบ้ง กงานา ม่าฮา ปี่ ล่า ชี แม้แน กูย่างกูเจ้อ ย้า ฮา, ไม้ กงา ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา แบ ปี่ ซี่ค้า, กงา อ่าโบ้ง นา ลาก แงแน. “ยอ! ทานล้า คูปาว, แล ปายา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงา อ่างู่น อางจฺื้ง ม้าม้า มาง ย้า. ยาว อ่าโบ้ง โซนฮูพลาฮู มาง ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","อ่าโบ้ง กงา ล่างาม อางซื่อ บ่าจา อือนา ต่อนวี แง. จ้า ล่างาม อางซื่อ ซื่อ อ่อกล้า ชี อือนา แม่น ย้า ต่อนแต่ง ฮูพลา แง, ไม้ บย่า แน อางซื่อ ซื่อ อ่อกล้า ปี่ง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","นอ กงา ม่าอู่บจี่ต่าง นองนา ม่าอู่บ ล่าชี่ นี้ง ปาปาย เซฺิ่งซฺ้าง ลางญา. ");
INSERT INTO bzi_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","กงาก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ โว! แน กงาม นองก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ แง. อ่างู่น ล่างาม นี้ย่า จาว่าแน อ่างู่น อางจฺื้ง โย้เวอ ทื่อลู่มทื่อเจ่อ แน บ่าเพล่อ ยาว, อางซื่อ บ่าซื่อ ตอกา, นอ อ่างู่น ล่างาม อือ แม้แนย้า. นอง กงาก้อง ทื่อลู่มทื่อเจ่อ แน บ่าเพล่อ ยาว นอ อางซื่อ บ่าซื่อ ตอกา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงา อ่างู่น อางจฺื้ง มาง ย้า, แน นอ อ่างู่น ล่างาม อือ ย้า. นอง กงาก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ แลน ยาว, แน กงา นองก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ยาว, นอ บย่า ย้า อางซื่อ ซื่อ อ่อกล้า ปี่ แง. จ้า กงา บ่าจา ยาว นอ เจิ้นเจ้อ บ่าฮากงา กาเป. ");
INSERT INTO bzi_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","อ่าซ่าง กงาก้อง ทื่อลู่มทื่อเจ่อ แน บ่าเพล่อ แล แง, ชฺ้าง แฮ้ม้า อ่างู่น ล่างาม ต่อนวี ยาว ตอย กือ ซฺี้ ปี่ ยาว บี่ท่อ พี ชี อือ แม้แนย้า เพล่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “นอง กงาก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ยาว, แน กงา ม่าอู่บจี่ต่าง แฮ้ง นองก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ยาว, นอ บ้าเจอ ป้า เวิม แฮ้แม้ย้า กงา แง. ");
INSERT INTO bzi_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","นอง บย่า แน อางซื่อ ซื่อ ยาว, นอ กงา ศิษย์ อือ ย้าเป, แน นอ ชฺ้าง อือนา ฮา อ่าโบ้ง ล่าที่ อางฮื่อ แฮ้ง กงามย้าง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","กงา นองนา ลาก ล่าง อ่าโบ้ง กงานา ลาก ล่าง แฮ้งแม้แน ย้า. กงานา ลาก แล ล่าคู โว! ");
INSERT INTO bzi_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","กงา นองนา อางเลิ่ง ม่า ฮา ปี่ ล่าชี่ อือ นอง ฮา เค่ ยาว, นอ กงานา อางลาก ล่าย้า. กงา อ่าโบ้ง อางเลิ่ง ม่าฮา ปี่ ล่าชี่ อือ ฮา เค่ ชี แฮ้งแม้แน ย้า, แน กงา ยางนา ลาก แล ชี แฮ้งแม้แน ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","กงา นองนา อางเลิ่ง นี้อือ ม่าแบ ปี่ ล่าง นี้ย่า, ไม้ กงา นองนา กงา แม้แน บย่า แน นืงบาต่องจาบื่อดื้งบื้อ แน จา ปี่ ล่า ซี่ค้า. ");
INSERT INTO bzi_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","กงา นองนา ม่าฮา ปี่ ล่าง นี้ย่า ลากฮูม ลางกา โว! กงา นองนา ลาก ล่าง แฮ้งแม้แน. ");
INSERT INTO bzi_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ลาก อางเลิ่ง โย้เวอ ค่าตอง อางช่าง นา ซฺี้แต่น แฮ้ง ล่อ แน บ่าฮื่อ แล่ก้าน. ");
INSERT INTO bzi_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","กงา นองนา อางเลิ่ง ม่าฮา ปี่ ล่าง แฮ้ง นอง ฮา เค่ ยาว, นอ กงา อางช่าง อือ ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","กงา นองนา ย่าเจ่น แน บ่าฮ่าว ล่าก้าน, ไม้ ย่าเจ่น นี้ย่า ค่าตอง เจ้านาย มาง บ้าเจอ ฮา แง แน บ่าแบ, จ้า กงา นองนา อางช่าง แน ฮ้าว ล่าง, ไม้ กงา อ่าโบ้ง ก้อง เวอ อางเลิ่ง กงากย่า ชี อือ นองนา กูย่างกูเจ้อ ย้า ม่าแบ ปี่ ล่าแอ่. ");
INSERT INTO bzi_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","นอ กงานา บ่ากงา แช้ยู้ ล่า, จ้า กงา นองนา แช้ยู้ ล่าชี่ มาง ย้า, แน นองนา ซฺา อ่อกแอ ปี่ ล่ายาว อางซื่อ บย่า แน จา ปี่ ล่าง. แน อางซื่อ นี้อือ ปู่นืง บ่าจา. ยาว นอ บ้าเจอ ป้า เวิม อ่าโบ้ง นองนา กูย่างกูเจ้อ ย้า ปี่ ล่าง, ไม้ นอ กงา ชฺ้าง อือ น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","กงา นองนา ม่าฮา ปี่ ล่าง นี้ย่า ลากฮูม ลางกา โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “ชฺ้างอางเมิง นี้ง นองนา เม้อ ล่ายาว, ชฺ้างอางเมิง นี้ย่า กงานา เม้อ ล่าออน แน จ้าม ชี โว! ");
INSERT INTO bzi_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","นอง ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือ แนยาว, ชฺ้างอางเมิง นู้เวอ ชฺ้าง อืม นองนา อางลาก ล่าย้า, ไม้ นอ ยาง ชฺ้าง น้อ. จ้า กงา นองนา แช้ กงา ชฺ้าง เพล่อ ปี่ ล่าย่า. นี้แม้แนยาว นอ ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือ บ่าอ่า กาน. ยาว ชฺ้างอางเมิง นู้เวอ ชฺ้าง อืม นองนา เม้อ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","กงา นองนา ม่า ล่าชี่ แฮ้งนา อางจาม กงา กาย้า ล่า, กงา นองนา นี้แม้แน ม่า ล่าแอ่, ‘ย่าเจ่น นี้ย่า ค่าตอง เจ้านาย มาง ล่อ แน บ่าฮื่อ’ แน. ยอง กงานา เค่คาม ล่ายาว, ยอ นองนา คาตา ย้า เค่คาม ล่าแง. ยอง กงา ม่าอู่บจี่ต่าง แฮ้ง ฮายเค่ ยาว, ยอ นอง ม่าอู่บจี่ต่าง แฮ้ง คาตา ย้า ฮา เค่ คู แง. ");
INSERT INTO bzi_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ยอง นองนา เค่คาม ล่าง นี้ย่า, ไม้ นอ กงา ชฺ้าง น้อ, แน ยอ กงานา ซฺาลือ ปี่ ล่าชี่ มางนา บ่าแบกงา กาวา. ");
INSERT INTO bzi_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","กงา ยองนา บ่าจี่ช่าง ลือ อู้, ยอ เจิ้นเจ้อ อางซีอางบล่าบ บ่าจา นาตู้. จ้า อามือ ยอ อางซีอางบล่าบ บ่ากงา ฮา แน บ่าจี่ กงา กางลา. ");
INSERT INTO bzi_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","อ่าซ่าง กงานา เม้อ ล่าแง, อ่าโบ้ง นา คาตา ย้า เม้อ แง. ");
INSERT INTO bzi_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","กงา ยอง อางมู โย้เวอ อางเลิ่งชฺ้างบ่าฮาตอกางอือ บ่าฮา อู้, ยอ อางซีอางบล่าบ บ่าจา นาตู้. จ้า อามือ ยองมู นี้ย่า กงา อางเลิ่ง ฮา ชี อือ กงามย้าง คู เวิม, ยอ อ่าโบ้ง ไกง้นา คาตา ย้า เม้อ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ล้อแม้เวิม อางเลิ่ง นี้อือ ม้าม้า ย้า ตอล้า ชี, ไม้ มอ ยาว พระคัมภีร์ โย้เวอ แต้ม ชี ชี แม้แน เพล่อ ปี่ง น้อ. พระคัมภีร์ โย้เวอ แต้ม ชี แฮ้ นี้แม้แน, ‘ยอ กงานา บ่าจ่องบ่าไจ่ ย้า เม้อ ล่า คูแง’ แน. ");
INSERT INTO bzi_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“จ้า กงา นองนา ปล่องฮู ปี่ ล่าแง. ปล่องฮู นี้ม้า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง นองนา พาจาว มาง อางเลิ่ง ม้าม้า แฮ้ง ฮาแบ ปี่ ล่าง มาง ย้า, แน กงา อางเลิ่ง แฮ้ง ชฺ้าง อือนา ป่าว ม่า ลือ แง. ");
INSERT INTO bzi_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ยาว นอง คาตา ย้า กงา อางเลิ่ง นี้ง ฮากนา กงา ป่าว แบ ปี่ แง, ไม้ นอ ต่องก่า เมอ จาย กงาก้อง ทื่งกง่า แน ดื้ง ลาน ป้าน่อ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงา นองนา อางเลิ่ง นี้อือ ม่ายชีออน ม่า ล่าแง, ไม้ นองนา กงานา นืงบาชี ล่าง นี้ง บ่าปี่ ว่าง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ยองมู นี้ นองนา ยิวชฺ้าง โบสถ์ โย้เวอ ก่าอ่อก ล่าง, แน บ่ามล่าง ยาว ชฺ้าง นองนา แซ่ ล่า คูชี อือย่า นี้แม้แน เย้ง คูแง, ‘ยอง แฮ้แม้ ฮา ชี แฮ้ย่า พาจาว มางนา ล่ากาน ว่า ปี่ แง’ แน. ");
INSERT INTO bzi_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ยอง นี้แม้ ฮา ชี นี้ย่า, ไม้ ยอ อ่าโบ้ง ไกง้นา บ่าแบล่ากงา กา. ");
INSERT INTO bzi_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","กงา นองนา อางเลิ่ง นี้อือ อามือ ม่า ชี ล่าง, ไม้ อางเลิ่ง นี้อือ ม้าม้า แน ตอล้า เมอ, นองนา จ้าม กงา ปี่ ล่าง, กงา นองนา อางเลิ่ง นี้อือ ม่า ล่าง ญ้า แนนอ” แน. ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงา นองนา อางเลิ่ง นี้อือ ต่องก่า เวอ จาย แน บ่าม่า แบ ปี่ ล่าง นี้ย่า, ไม้ กงา นองก้อง ทื่งกง่า แน ดื้ง น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","จ้า อามือ กงาย่า กงานา ซฺาลือ ปี่ ล่าชี่ มางนา ชา ซฺ้า แล แง, แน นอง อางมู โย้เวอ กงานา อ่าซ่าง มาง นี้แม้แน บ่าน่า ล่า คู, ‘อ่าจาน เวอ, นา ล้อเกิ้ง ชา แล แง?’ แน. ");
INSERT INTO bzi_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ไม้ นอ กงา อางเลิ่ง ม่า ล่าชี่ แฮ้ง ม่านชู คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","กงา นองนา อางเลิ่ง ม้าม้า ม่า แบ ปี่ ล่าว่า, กงา อ่าโบ้ง นา ซฺ้า แล นี้ย่า นองก้อง จองไจ จา แง, ไม้ จาว่าแน กงา บ่าแล ยาว, ปล่องฮู มาง นองนา บ่าซฺ่า ลือ ล่าเป. จ้า กงา แลน ยาว, กงา ยางนา นองก้อง ซฺาลือ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ปล่องฮู มาง ลืน เมอ, ยา ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา ฮา กงาแบ กงามย้าง ปี่ แง, อางบล่าบ ม้าม้า นี้ย่า บ้าเจอล้อแม้ จา แง, แน อางกง่าอางเกิง นี้ย่า บ้าเจอล้อแม้ จา แง, แน พาจาว ม้า ชฺ้าง อือนา ต้าดต่อน วี่บ่ากไจ ปี่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ปล่องฮู ม้าย่า ชฺ้าง อือนา ฮา แบ ปี่ แง, ยอง อางบล่าบ ฮา ชี แฮ้ย่า, ไม้ ยอง กงานา บ่าเจ่อ ล่าง แฮ้ง ปาปาย ย้าแน. ");
INSERT INTO bzi_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ปล่องฮู ม้าย่า ชฺ้าง อือนา ฮาแบ ปี่ แง, กงา อางเลิ่ง อางกง่าอางเกิง ฮา ชี แฮ้ย่า กงา อ่าโบ้ง นา ซฺ้า แล แฮ้งย้า แน. นี้แม้แนยาว นอ กงานา บ่ากงามย้าง ล่าก้าน. ");
INSERT INTO bzi_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ยาว ปล่องฮู มาง ชฺ้าง อือนา ฮาแบ ปี่ แง, พาจาว ม้า ชฺ้าง คาโคลาโค อือนา ต้าดต่อน แง, ไม้ พาจาว ม้า ซาตานแด่ย่ายอคา ชฺ้างอางเมิง ฮูพลา ชี มางนา อางซี ต้าดต่อน ญ้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “ม้าม้า นี้ย่า กงา นองนา อางเลิ่ง อางบย่า ย้า ม่าล่าซี่ แง. จ้า อามือ กงา บย่า แน จี่ ยาว นอ บ่าน่า โค กา เป. ");
INSERT INTO bzi_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","จ้า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง เคอ ลือ เมอ, ยา นองนา พาจาว มาง อางเลิ่ง ม้าม้า แฮ้ง ฮา แบ ปี่ ล่าง, ไม้ ยา ค่าตอง นืงบาวา แน บ่ากงา จี่, จ้า ยาง อางเลิ่ง กงากย่า ลือ ชี อือ จี่ แง, แน ยา นองนา ม่า แบ ปี่ ล่าแง, บ้าเจอ อางเลิ่ง ชา ตอล้า แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ยา นองนา ฮา กงา ล่าที่ อางฮื่อ แฮ้ง มย้าง ปี่ ล่าง, ไม้ ยา กงาก้อง อางเลิ่ง กงากย่า ชี อือ นองนา ม่า แบ ปี่ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","อ่าโบ้ง กูย่างกูเจ้อ จา ชี แฮ้ย่า กงาเฮอ เพล่อ แง. ยาว นี้งย้า กงา นี้แม้แน จี่ นี้ย่า, ‘ปล่องฮู ม้า กงาก้อง อางเลิ่ง กงากย่า ชี อือ นองนา ม่าแบ ปี่ ล่าแง’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “อ่าซาง ทื่อชี่ดยาว นอ กงานา บ่ากงา มย้าง ล่างลา. ยาว น่อง โย้เวอ ทื่อชี่ดยาว กงา พ่าว ลือ แล่แง, แน นอ กงานา ทื่อเทอ กงามย้าง แล่ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ยาว พระเยซู ศิษย์ ทื่อบ่า อืม นี้แม้แน น้าท้าม ลางกา ชีเย, “อ่าจาน แฮ้แม้แน จี่ แฮ้ย่า บ้าเจอป้าค้า เวอ, ยา นี้แม้แน จี่ แง, ‘อ่าซาง ทื่อชี่ดยาว นอ กงานา บ่ากงา มย้าง ล่างลา. ยาว น่อง โย้เวอ ทื่อชี่ดยาว กงา พ่าวลือ แล่แง, แน นอ กงานา ทื่อเทอ กงามย้าง แล่ ล่าแง’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ยาว ยองมู แฮ้ง นี้แม้แน น้าท้าม ลางกา ชีเย, “อ่าจาน แฮ้แม้แน จี่ แฮ้ย่า บ้าเจอป้าค้า เวอ, ยา นี้แม้แน จี่ แง, ‘อ่าซาง ทื่อชี่ดยาว’ แน. กงู บ่าแบ ยา บ้าเจอ อางเลิ่ง จี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","จ้า พระเยซู อางแบ เย, ยอ นี้เลิ่ง น้าท้าม คู ซี้ แงแน. แฮ้งเย่ ยาง ยองนา นี้แม้แน จี่ช่าง ชี, “กงา นี้แม้แน จี่ แฮ้, ‘อ่าซาง ทื่อชี่ดยาว นอ กงานา บ่ากงา มย้าง ล่างลา. ยาว น่อง โย้เวอ ทื่อชี่ดยาว กงา พ่าวลือ แล่แง, แน นอ กงานา ทื่อเทอ กงามย้าง แล่ ล่าง’ แน. นอย่า นี้เลิ่ง น้าท้าม กาง อ่าลา? กงา จี่ แฮ้ บ้าเจอป้าค้า เวอ แน. ");
INSERT INTO bzi_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","กงา นองนา อางเลิ่ง ม้าม้า ม่าแบ ปี่ ล่าว่า, นอ นืงบาชู่ม อู้งฮ้าว คูง จ้า ชฺ้างอางเมิง เวอ ชฺ้าง อือย่า ม่อนซ้า แง. นอ นืงบาต่องลาบ้าบ คูง จ้า นอง นืงบาต่องลาบ้าบ ชี แฮ้ น่อง โย้เวอ นองนา ฮา กย่าง ปี่ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ค่าบาย่า อู่ปู่ม อางย่า ชา เกิ้ด อือ แม้แน ย้า. ยา ป่องปอง ด้า ปาปาย ตูกพานลาบ้าบ แง. จ้า ยาง อางย่า เกิ้ด เปิน เมอ น่อง โย้เวอ ยา ยาง ป่องปอง ด้า ชี อือนา โค ย้า ลู้ม แง, ไม้ ยา ยาง อางย่า ม่าง ชฺ้างอางเมิง นู้เวอ เกิ้ด ลือ ชี แฮ้งนา กย่าง น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","นอง ทื่อช่างกานญา เป. นอ อามื้อ นืงบาต่องลาบ้าบ คูแง. จ้า น่อง เวอ กงา นองนา พ่าว ซฺ้า ลือ ล่า เมอ นอ กย่าง คูแง. นอง กย่าง นี้ย่า อ่าซ่าง มาง บ่าย่าด ยู้ กงากา เป. ");
INSERT INTO bzi_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ยาว แฮ้นืง นอ กงานา เจิ้นเจ้อ บ่ากงา น้า ล่า คาเป. กงา นองนา อางเลิ่ง ม้าม้า ม่าแบ ปี่ ล่าว่า, นอ อ่าโบ้ง นา บ้าเจอ ป้า เวิม ยา นองนา กูย่างกูเจ้อ ย้า ปี่ ล่าแง, ไม้ นอ กงา ชฺ้าง น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","นอง กงา ชฺ้าง เพล่อ ล้า ชี นี้ย่า นอ กงานา เจิ้นเจ้อ บ่าป่า ล่า กางซื้ง, ป้า ปาว. ยาว นอ แฮ้แม้แน ย้า กงา แง, ไม้ นองนา ปลื้ง แน นืงบาจาบื่อ แนชี่แฮ้ง ปี่ ล่าง น้อ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ยาว พระเยซู นี้แม้แน จี่ แล่ชี่ เย, “กงา นองนา อางเลิ่ง อู่บเพ้กน้า ปี่ ล่าง นี้ย่า, ไม้ นองนา อางเลิ่ง นี้อือ ม่าแบ ปี่ ล่าแง แน เป. จ้า บ่ามล่าง ยาว กงา นองนา อางเลิ่ง บ่าอู่บเพ้กน้า ปี่ ล่าก้าน. จ้า กงา นองนา อ่าโบ้ง อางเลิ่ง แฮ้ง ปล้อง ย้า ม่าย แบ ปี่ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","แฮ้นืง ย่า นอ บ้าเจอ ป้า แง, กงานา บ่ากงา ม่าย ป้า ปี่ ล่าก้าน. จ้า นอ กงา อางเม้ง แฮ้ง ไจ พาจาว มางนา ป้า อางกงา, ไม้ นอ กงา ชฺ้าง อือ น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","อ่าโบ้ง นองนา ลาก ล่าง. ยา นองนา คาโคลาโค ย้า ลาก ล่าแง, ไม้ นอ กงานา ลาก ล่าแง, แน กงา พาจาว มาง ก้อง จายลือ ชี แน เจ่อ คูง น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","กงา อ่าโบ้ง ก้อง จายลือ แอ, แน กงา ชฺ้างอางเมิง นู้เวอ ดื้ง ลือ แอ. จ้า อามือ กงา ชฺ้างอางเมิง นู้เวอ ชา เจิ่ก แล แง, ไม้ อ่าโบ้ง ก้อง ชา พ่าวแล แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ยาว พระเยซู ศิษย์ อืม นี้แม้แน จี่ เย, “อามือ นา กงูนา อางเลิ่ง บ่าอู่บเพ้กน้า ปี่ ล่า. จ้า นา กงูนา ปล้อง ย้า ม่า ล่าง. ");
INSERT INTO bzi_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","กงู อามือ แบ คายา นา กูย่างกูเจ้อ ย้า แบ แงแน. นา กงู บ่าน่า ฮู่ เวอ ย้า แบ แง, นา กงูนา ล้อแม้ จี่พอ ล่าง แน. ยาว ตื่น กงู นางนา บ่าน่าบ่าท่าม ล่าเวิม นา อางแบ กงู บ้าเจอ เย้ง แงแน. นี้งย้า กงู เจ่อ นี้ย่า นาย่า พาจาว มางก้อง จายลือ ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ยาว พระเยซู มือ ยองนา นี้แม้แน จี่พอ ชีเย, “อามื้อ นอ เจ่อ ย้าลา? ");
INSERT INTO bzi_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ล่อฮู คู เป อางญ่าม แฮ้ม้า อามือ ชา เคอ ลือ แง. ม้าม้า นี้ย่า อางญ่าม แฮ้ม้า เคิน ลืงญา. นองมู คาโคลาโค นี้ย่า กามางกาต่อง กามางกาตี่ แน ฮื่น แล คูแง, แน กงานา ทื่อม่าง แน ชี ช่า ล่าง. จ้า ม้าม้า นี้ กงาย่า กงา ทื่อม่าง แน บ่าดื่ง เป, ไม้ อ่าโบ้ง กงาก้อง ทื่งกง่า แน ดื้ง แง. ");
INSERT INTO bzi_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","กงา นองนา อางเลิ่ง นี้เลิ่ง ม่า แบ ปี่ ล่า ชี นี้ย่า, ไม้ นองนา กงาก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ชี แฮ้ง ปาปาย แม่น แน นืงบาต่องจาบื่อดื้งบื้อ แน จา ปี่ ล่าง น้อ. ชฺ้างอางเมิง นี้ย่า นองนา ฮา ตูกพานลาบ้าบ ปี่ ล่าง. จ้า นืงบาบ่าด่อ คู โจ! ไม้ กงา ชฺ้างอางเมิง แฮ้งนา ก่าไจ่ ยา!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","พระเยซู ยาง ศิษย์ อือนา จี่ช่าง เปิน ยาว มู่งท่า โย้เวอ แมก่าแงน ฮูน ชีเย. ยาว ยาง นี้แม้แน จี่ ชีเย, “อ่าโบ้ง เวอ, ชฺ้าง อือนา ฮา กงา ล่าที่ อางฮื่อ แฮ้ง มย้าง ปี่ ญ่าม ย่าง เคิน ญ้า, ไม้ กงานา ชฺ้าง อือนา ฮาย นาง ล่าที่ อางฮื่อ แฮ้ง มย้าง ปี่ง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","นา กงานา ชฺ้าง คาโคลาโค อือ ล่อบ่าปา แน ล่าที่ ฮื่อ ปี่ ล่าง, ไม้ กงานา นาง ชฺ้าง คาโคลาโค ฮูพลา ปี่ ล่า ชี อือนา ฮาย นางก้อง ทื่งกง่า แน จี่วีดม้าม้า จา แล ปี่ แง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","นางก้อง ทื่งกง่า แน จี่วีดม้าม้า จา แล แฮ้ย่า นางนา แบกงา ล่าง แฮ้งย้า, แน กงานา นาง ซฺาลือ ปี่ ชี มางนา คาตา แน แบกงา กาง แฮ้งย้า. นาย่า พาจาว ม้าม้า มาง ย้า, แน นาง ทื่อม่าง ญา พาจาว ม้าม้า แน. ");
INSERT INTO bzi_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","กงา ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา ฮาย นาง ล่าที่ อางฮื่อ แฮ้ง กงามย้าง ปี่ ย้าเป, ไม้ กงา นาง กงานา ล่ากาน ม่าย ว่า ปี่ ล่า ชี อือ ว่าเปิน โค ป้าน่อ. ");
INSERT INTO bzi_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","อ่าโบ้ง เวอ, อามื้อ กงานา นาง ล้าก้า โย้เวอ อางอ้าน ป้าค้า ล่าที่ จา ฮื่อ ปี่ ล่าปาว. ชฺ้างอางเมิง บ่าแต่งฮู่ โย้เวอ ไกง้ ทื่งกง่า แน ล่าที่ จา ชี แฮ้งแม้แน. ");
INSERT INTO bzi_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“กงา นาง กงานา ชฺ้างอางเมิง นู้เวอ ชฺ้าง ฮูพลา ปี่ ล่า ชี อือนา ม่า นางนา แบกงา ปี่ ล่าย่า. ยองมู นี้ย่า นาง ชฺ้าง เป. ยาว นา กงานา ยองนา ฮูพลา ปี่ ล่าแง, แน ยองมู นี้ย่า นาง ม่าอู่บจี่ต่าง แฮ้ง ฮา เค่ คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ยาว อามื้อ ยอง แบน ญา. กงาก้อง กูย่างกูเจ้อ จา ชี แฮ้ย่า นางก้อง จายลือ แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","กงาย่า นาง กงานา จี่ต่าง ปี่ ล่าชี่ อือ ยองนา ปี่ ยาเป, แน ยอง ยู้ชี ญาเป. ยองมู นี้ย่า อางแบ คูย้า, กงา นางก้อง จายลือ ชี ม้าม้า ย้าแน, ยองมู นี้ย่า อางเจ่อ คูย้า, นา กงานา ซฺาลือ ปี่ ล่าชี่ แน. ");
INSERT INTO bzi_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“กงา ยองนา อธิษฐาน ฮาย ปี่ แง เป. จ้า กงา ชฺ้างอางเมิง นู้เวอ ชฺ้าง คาโคลาโค อือนา อธิษฐาน บ่ากงาฮา ปี่ เป. จ้า กงา นาง กงานา ชฺ้าง ฮูพลา ปี่ ล่า ชี อือนา อธิษฐาน ฮาย ปี่ แง, ไม้ ยองมู นี้ย่า นาง ชฺ้าง น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","กูย่างกูเจ้อ กงาเฮอ นี้ย่า นางเฮอ, แน กูย่างกูเจ้อ นางเฮอ นี้ย่า กงาเฮอ เป. ชฺ้าง นี้อือ ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา ฮาย กงา ล่าที่ อางฮื่อ นี้ง มย้าง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","กงา ชฺ้างอางเมิง นู้เวอ บ่าดื่ง แล่ก้าน, ไม้ กงา อามือ นางนา ชา แล ซฺ้า ล่าง. จ้า ยอ ชฺ้างอางเมิง นู้เวอ ดื้งจาช่าแง. อ่าโบ้ง อางซีอางบล่าบ บ่าจา มาง เวอ, นาง กงานา ล่าที่ ปี่ ล่า ชี แฮ้ง ไจ ยองนา ฮูพลา ปาว, ไม้ ยองนา ทื่อลู่มทื่อเจ่อ แน เพล่อ ปี่ เซฺ้อ, ไกง้ ทื่อลู่มทื่อเจ่อ แน เพล่อ ชี แฮ้งแม้แน. ");
INSERT INTO bzi_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","กงา ยองก้อง ทื่งกง่า แน ดื้ง เมอ, กงา นาง กงานา ล่าที่ ปี่ ล่าชี่ แฮ้งย้า ไจ ยองนา ฮูพลา แง. ชฺ้าง กงา ฮูพลา ชี อือย่า ทื่อม่าง แนม บ่าโปยว. จ้า ยองมู โย้เวอ ชฺ้าง ทื่อม่าง กงาโปยว แอ แง, ไม้ มอ ยาว พระคัมภีร์ โย้เวอ แต้ม ชี ชี แม้แน ม้าม้า แน เพล่อ ปี่ง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“กงา อามือ นางนา ชา แล ซฺ้า ล่าแง. จ้า อางเลิ่ง นี้อือ กงา ชฺ้างอางเมิง นู้เวอ ดื้ง เมอ ย้า จี่ แอ, ไม้ ยองนา กงา แม้แน ปีนแตปีนนา แน นืงบาต่องม่อนซ้า ปี่ง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","กงา ยองนา นาง ม่าอู่บจี่ต่าง อือ ม่าอู่บ ยาเป. จ้า ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือ ยองนา เม้อ แง, ไม้ ยอ ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือ แม้แน บ่าเย่ง ยอ กงา แม้แน เย้ง แง. ");
INSERT INTO bzi_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","กงา นางนา บ่ากงา ป้า ยองนา ชฺ้างอางเมิง นู้เวอ ซฺื่ย อ่อกแอ ปี่ ล่าเป. จ้า กงา นางนา ป้า ล่าแง, ยองนา ปล่อง ซาตานแด่ย่ายอคา มางก้อง กงาปูน ปี่ ปาว แน. ");
INSERT INTO bzi_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ยอ ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือ แม้แน บ่าเย่ง ยอ กงา แม้แน เย้ง แง. ");
INSERT INTO bzi_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","นาง ม่าอู่บจี่ต่าง นี้ย่า อางเลิ่ง ม้าม้า เป. นี้แม้แนยาว นาง ม่าอู่บจี่ต่าง แฮ้ง ยองนา ฮาย นาง ชฺ้าง เพล่อ ปี่ ปาว. ");
INSERT INTO bzi_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","กงา ยองนา ชฺ้างอางเมิง นู้เวอ ต้าว แน ชา ซฺาแอ ปี่ แง. นาง กงานา ชฺ้างอางเมิง นู้เวอ ซฺาลือ ปี่ ล่า ชี แฮ้งแม้แน ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","กงา อางโต นี้ง นางนา ทื่อม่าง แน ท่าน ปี่ ล่าชี่ นี้ย่า ยอง ปาปาย ย้า, ไม้ ยองนา นาง อางเลิ่ง ม้าม้า แฮ้ง แบ ปี่ ยาว ค่าตอง อางโต แฮ้ง นางนา ทื่อม่าง แน ท่าน ปี่ ปี่ ล่าง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“กงา ค่าตอง ศิษย์ อือนา แอ่ แน อธิษฐาน ฮา ปี่ บ่าอ่า เป, จ้า ชฺ้าง กงา ศิษย์ อือ ม่าอู่บ ยาว กงานา กาญ่าม เวอ เจ่อ ล่าง อือนา คาตา ย้า อธิษฐาน ฮา ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","อ่าโบ้ง เวอ, ยองนา ฮา ทื่อลู่มทื่อเจ่อ แน เพล่อ ปี่ ปาว, นาง กงาก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ชี แฮ้งแม้แน, แน กงา นางก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ชี แฮ้งแม้แน, แน ยองนา ไกง้ ก้อง ทื่อลู่มทื่อเจ่อ แน เพล่อ ปี่ ปาว, ไม้ ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา เจ่อ ปี่ เซฺ้อ, นา กงานา ม้าม้า ย้า ซฺาลือ ปี่ ล่าชี่ แน. ");
INSERT INTO bzi_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","กงา ยองนา ล่าที่ อางฮื่อ ปี่ แอ่. นาง กงานา ล่าที่ ปี่ ล่าชี่ แฮ้งแม้แน, ไม้ ยองนา ทื่อลู่มทื่อเจ่อ แน เพล่อ ปี่ง แนนอ. ไกง้ ทื่อลู่มทื่อเจ่อ กาแน เพล่อ ชี แฮ้งแม้แน. ");
INSERT INTO bzi_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ทื่อลู่มทื่อเจ่อ กาแน เพล่อ นี้ย่า กงา ยองก้อง ดื้ง แฮ้งย้า, แน นาง กงาก้อง ดื้ง แฮ้งย้า เป, ไม้ ยองนา ปีนแตปีนนา แน ทื่อลู่มทื่อเจ่อ กาแน เพล่อ ปี่ง แนนอ, ไม้ ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือนา กงาแบ ปี่ง น้อ, นา กงานา ม้าม้า ย้า ซฺาลือ ปี่ ล่าชี่, แน นา ยองนา ลาก แง, นาง กงานา ลาก ล่าง แฮ้งแม้แน ย้า. ");
INSERT INTO bzi_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“อ่าโบ้ง เวอ, นา กงานา ยองนา ฮูพลา ปี่ ล่าแง. กงา ล้อเกิ้ง ดื้ง เวิม ยองนา กงาก้อง ทื่งกง่า แน ดื้ง ปี่ ซี่ค้า, ไม้ ยองนา กงา ล่าที่ อางฮื่อ แฮ้ง กงามย้าง ปี่ แง แนนอ. นา กงานา ล่าที่ อางฮื่อ ปี่ ล่า ชี มาง ยา, ไม้ นา กงานา ไกง้ ชฺ้างอางเมิง บ่าแต่ง ฮู่ เวอ ย้า ลาก ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","อ่าโบ้ง เวอ, นา อางซืออางปลอง. ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือย่า นางนา บ่าแบ ล่า กงากา. จ้า กงา นางนา อางแบ ล่า กงา กาย้า. ยาว กงา ศิษย์ นี้อืม อางแบ คูย้า, นา กงานา ซฺาลือ ปี่ ล่า ชี มาง ย้า แน. ");
INSERT INTO bzi_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","นา กงานา ลาก ล่าแง. ยาว กงา ยองนา ฮาย นางนา แบกงา ปี่ ล่าย่า. ยาว กงา นี้แม้แน ย้า ฮา แล แล่แง, ไม้ นาง กงานา ลาก ล่าง แฮ้ง ยอง นืงบา โย้เวอ ดื้ง ปี่ แง, แน กงาม ยอง นืงบา โย้เวอ ดื้ง นอ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","พระเยซู อธิษฐาน ฮา เปิน ยาว ยาง ศิษย์ อือก้อง ทื่งกง่า แน ขิดโรน ล้างย่า โย้เวอ ย่อ คาม แลน ชีเย, แน มะกอกเทศ โซน โย้เวอ อ้องแลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ยูดาส น่อง เวอ พระเยซู นา บ่าแม่น ฮา ชี แฮ้มาง โซน นี้โซน นา อางแบกงากา ย้าเย่, ไม้ พระเยซู แน ยาง ศิษย์ อือ นู้เวอ อางเลิ้ง กาเย ล้า คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ยาว ยูดาส มือ โรม ตาฮ้าน ทื่อมู อือนา แน ชฺ้าง โบสถ์อางฮื่อล่อฮู อือนา ซฺื่ย พระเยซู นา ซฺ้า ล้า ชีเย. ชฺ้าง โบสถ์อางฮื่อ ฮูพลา นี้อือนา ปุโรหิต ยอคา แน ฟาริสี อือ ซฺาล้า ปี่ ชีเย. ยองมู นี้ย่า ตะเกียง แน ฮาต้าง ท่อ ล้าน คู ชีเย, แน มยาทาง ท่าม ล้าน คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","พระเยซู อางแบจ่าแล่ เย ยางก้อง บ้าเจอ อางเลิ่ง ชา ตอล้า แงแน. แฮ้งเย่ ยาง ย่อ อ่อกแอ ยองนา ซฺ้า แอ ชี. ยาว ยาง ยองนา นี้แม้แน น้าน ชีเย, “นอ อ่าซ่าง นา ซฺ้า กว่า คูแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ยองมู แฮ้ง นี้แม้แน จี่พอ คู ชีเย, “กงู เยซู นาซาเร็ธชฺ้าง มางนา ซฺ้ากว่า คูแง” แน. แฮ้งเย่ พระเยซู มือ ยองนา นี้แม้แน ม่า ชี, “กงา เยซู นอง ชฺ้าง ซฺ้ากว่า มาง ย้า” แน. (ยูดาส พระเยซู นา บ่าแม่น ฮา ชี มาง ชฺ้าง แฮ้มู ก้อง ทื่งกง่า แน จูง ชีเย.) ");
INSERT INTO bzi_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","พระเยซู นี้แม้แน จี่ เมอ, “กงา เยซู นอง ชฺ้าง ซฺ้ากว่า มาง ย้าเป” แน. ยาว ยองมู ย่าง มือ ทื้อแค แน เลิง แล่ คูชี. ");
INSERT INTO bzi_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","พระเยซู มือ ยองนา ทื่อเทอ น้าน แล่ ชี่ นี้แม้แน, “นอ อ่าซ่าง นา ซฺ้ากว่า คูแง?” แน. ยองมู ย้าง นี้แม้แน จี่พอย คู ชีเย, “กงู เยซู นาซาเร็ธชฺ้าง มางนา ซฺ้ากว่า คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ยาว พระเยซู มือ ยองนา นี้แม้แน จี่ช่าง ชีเย, “กงา นองนา ม่าย ล่าย่า กงา ชฺ้าง แฮ้มาง ย้า. จาว่าแน นอง กงานา ซฺ้า กว่า ล่าง แนยาว, ชฺ้าง นี้อือ นา ตอย แล ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","พระเยซู นี้แม้แน จี่ นี้ย่า, ไม้ ยาง จี่ ชี ชี แฮ้งแม้แน ม้าม้า แน เพล่อ ปี่ง เย. ยา นี้แม้แน จี่ ชี ชี, “อ่าโบ้ง เวอ กงาย่า นาง กงานา ชฺ้าง ฮูพลา ปี่ ล่า ชี อือนา ทื่อม่าง แนม บ่าปี่ โปยว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ซีโมนเปโตร เมอ มยาทาง จา เย. แฮ้งเย่ ยาง มยาทาง แฮ้ง จาก อ่อกล้า ปี่ ยาว มัลคัส น่าซื่ง ล่าม่า เวอ แจล่าก ชี่. มัลคัส ย่า ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง ย่าเจ่น เย. ");
INSERT INTO bzi_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ยาว พระเยซู มือ ซีโมนเปโตร นา จี่ช่าง ชี นี้แม้แน, “นาง มยาทาง แฮ้ง กอย ชี โว! นา กงานา อ่าโบ้ง ล้างก้อก อางตูกอางพาน ปี่ ล่าชี่ แฮ้ง บ่าปี่ ต้าง ล้าลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","โรม ตาฮ้าน แน ตาฮ้าน ยอคา แน โบสถ์อางฮื่อล่อฮู อืม พระเยซู นา ชู พือ ชี ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ยาว อันนาส นา ซฺื่ยซฺ้า แอ ชีเย. อันนาส คายาฟาส ย่อพ่า เย. คายาฟาส แฮ้ปี เวอ ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น เพล่อ ชี มาง ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","คายาฟาส ยิวชฺ้าง อือนา นี้แม้แน ม่า ชี มาง ย้าเย่, “ชฺ้าง ทื่อม่าง นา ซฺี้ ปี่ง นี้ย่า ยิวชฺ้าง คาโคลาโค อือนา ซฺี้ ปี่ง แฮ้ง ล่อบ่าปา แม่น แล่ง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ซีโมนเปโตร แน พระเยซู ศิษย์ ทื่อม่าง มาง เย่ด พระเยซู นา เค่ แอน ชีเย. ศิษย์ นี้ม้า ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มางนา อางแบกงากา เย. แฮ้งเย่ ยา พระเยซู ก้อง ทื่งกง่า แน ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง ยู้ม กองโค้ง โย้เวอ กงาอ้อง แล ชี. ");
INSERT INTO bzi_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","จ้า เปโตร ยู้ม ก้ามทื้อ อางเง้ ล้องก้อ ก่องทาง โย้เวอ จูงล่อ ชีเย. ยาว ศิษย์ แฮ้มาง อ่อกลือ ย่าบี่ย่าเจ่น ยู้ม ก้ามทื้อ ล้องก้อ ล่อดื้งฮู มางนา ม่า ชีเย. แฮ้งเย่ ยาง ซีโมนเปโตร นา อางคล้าว โย้เวอ อ้องแล ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ยาว ย่าบี่ย่าเจ่น ยู้ม ก้ามทื้อ ล้องก้อ ล่อ ดื้ง มาง ซีโมนเปโตร นา นี้แม้แน น้าน ชีเย, “นา ค่าพ่าย่า แฮ้ มาง ศิษย์ อ่าลา?” แน. ยาว ซีโมนเปโตร มือ นี้แม้แน จี่พอ ชีเย, “กงา ยาง ศิษย์ บ่าอ่า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ย่าเจ่น อือ แน โบสถ์อางฮื่อล่อฮู อือย่า บี่ท่อ จืง ปย่าว แล่ คูชี, ไม้ อางช่อ เย, แน ซีโมนเปโตร ยอง ก้อง ทื่งกง่า แน บี่ท่อ ปย่าว จูง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง พระเยซู นา ยาง ศิษย์ อือ อางเลิ่ง แฮ้ง แน ยาง ม่าอู่บจี่ต่าง อางเลิ่ง แฮ้ง น้าท้าม ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ยาว พระเยซู มือ นี้แม้แน จี่พอ ชีเย, “ชฺ้าง คาโคลาโค อือย่า อางแบ ย้า กงา บ้าเจอ ม่าอู่บ แงแน. กงา ค่องช่าง อือ โบสถ์ แน โบสถ์อางฮื่อ อือเมอ ม่าอู่บ แง, ไม้ ตี แฮ้อือเมอ ค่องช่าง คาโคลาโค อือ ช้อนกาย้า น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","นา กงานา บ้าเจอฮาย น้า ล่าแง? ชฺ้าง กงา ม่าอู่บจี่ต่าง กงากย่า ชี อือนา น้า แอ โว, กงา ยองนา บ้าเจอ ม่าอู่บ ชี แน, ไม้ ยอ อางแบ กงา บ้าเจอ ม่าอู่บ ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","พระเยซู แฮ้แม้แน จี่ ยาว โบสถ์อางฮื่อล่อฮู อางมู โย้เวอ ชฺ้าง ทื่อม่าง พระเยซู ก้อง แท้ แน จูง ชี มาง พระเยซู นา แมก่า ทาก ชีเย, แน พระเยซู นา นี้แม้แน จี่ ชีเย, “นา ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มางนา นี้แม้แน อางจี่พอ จอ กา ชี เด้” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ยาว พระเยซู มือ ยางนา นี้แม้แน จี่พอ ชีเย, “กงา จี่ นี้ง ซีน ชี แนยาว, นู้เวอ ชฺ้าง คาโคลาโค อือนา ม่าแบ ปี่ ปาว กงา บ้าเจอ จี่ ซี ชี แน. จ้า กงา จี่ ชี นี้ง เจิ้นเจ้อ บ่าซี ยาว นา บ้าเจอฮาย กงานา แมก่า ทาก ล่าแง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","พระเยซู นา นักโทษ แม้แน พือ ชี ชีเย. ยาว อันนาส พระเยซู นา ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น คายาฟาส ก้อง ซฺาแล ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ซีโมนเปโตร ยองก้อง ทื่งกง่า แน จูง บี่ท่อ ปย่าว แล่ เมอ. ยองมู แฮ้ง ยางนา นี้แม้แน น้าน คู ชีเย, “นา ค่าพ่าย่า แฮ้มาง ศิษย์ บ่าอ่า ม้าม้า ลา?” แน. ยาว ยาง นี้แม้แน จี่พอ ชีเย, “บ่าอ่า, กงา ยาง ศิษย์ บ่าอ่า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง ย่าเจ่น อือ อางมู โย้เวอ ชฺ้าง ทื่อม่าง จา ชีเย. ยา ค่าพ่าย่า ซีโมนเปโตร น่าซื่ง แจล่าก ปี่ชี่ มาง ย่าช่างม่องน้าม เย. ยา ซีโมนเปโตร นา นี้แม้แน น้าน ชีเย, “กงา นางนา แน ค่าพ่าย่า แฮ้มางนา โซน โย้เวอ มย้าง ล่าชี่ บ่าอ่า ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ยาว ซีโมนเปโตร มือ บ่าอ่า แน ทื่อเทอ จี่ แล่ ชีเย. ยาว ซฺ้อก ย้าเย่ ยาพ่า ต้าน ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ซอทา อางด่า โย้เวอ ยองมู ย่าง พระเยซู นา ซฺื่ย แก้บ้า ย่อย อ่อกแลน ชีเย. ยองมู นี้ย่า คายาฟาส ยู้ม โย้เวอ จาย ผู้ว่า ปีลาต โรมชฺ้าง มาง ยู้มอางฮื่อ โย้เวอ แลน ชี เย. จ้า ยองมู ย่าง ผู้ว่า ปีลาต มาง ยู้มอางฮื่อ โย้เวอ บ่าอ่อง แล คู เย, ไม้ ยิวชฺ้าง อือย่า ทื้อ คูง เย ยิวชฺ้าง อือ ตี บ่าอ่า โย้เวอ อ้องแล นี้ย่า ยอง อางโต นา ฮา โซซา ปี่ แงแน. จาว่าแน บ่าเซฺิ่งบ่าซฺ่าง ยาว ปัสกาป่อยนืง เวอ บ่าอ่อง แล กงากา เย. ");
INSERT INTO bzi_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","แฮ้งเย่ ผู้ว่า ปีลาต มือ ยาง ยู้มอางฮื่อ อางเง้ โย้เวอ ย่อย อ่อกแอน ยาว ยองนา ซฺ้าน แอ ชี. ยองนา นี้แม้แน น้าน ชีเย, “กงานา ม่า ล่าวแล ยา บ้าเจอ อางเลิ่ง อางซี ฮาย ชี?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ยาว ยองมือ ผู้ว่า ปีลาต นา นี้แม้แน ม่า คู ชีเย, “จาว่าแน ยาง ชฺ้าง อางแม่น แน อู้, กงู ยางนา นางก้อง บ่าซฺื่ยล้า เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","แฮ้งเย่ ผู้ว่า ปีลาต มือ ยองนา นี้แม้แน ม่า ชี, “นี้แม้แนยาว ยางนา นอง อางลี้บอางล่าว วา แน ต้าดต่อน วี่บ่ากไจ ปี่ ปาว” แน. จ้า ยองมู แฮ้ง นี้แม้แน จี่พอ คู ชีเย, “ค่าพ่าย่า นี้ม้า อางซี อางจา ม้าม้า ย้า. ยางนา แซ่ นี้ย่า อางซูม ย้า. จ้า โรม อางลี้บอางล่าว โย้เวอ กงูมู ยิวชฺ้าง อือนา อ่าซ่าง มางนา บ่าปี่ แซ่ ล่า เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ยาว นี้แม้แน เพล่อ ชี นี้ย่า ไม้ พระเยซู มอ ชี ชี แม้แน ม้าม้า แน เพล่อ ปี่ง เย, ยา ล้อแม้ กงา ซฺี้ แงแน. ยา ไม้กางเขน ท่า เวอ ซฺี้ แง, โรมชฺ้าง อือ ต้าดต่อน ชฺ้าง นา แซ่ ซฺี้ ปี่ แฮ้งแม้แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ยาว ผู้ว่า ปีลาต มือ ยาง ยู้มอางฮื่อ โย้เวอ ย่อย อ้องแลน ยาว พระเยซู นา ฮ้าว อ้องแล ปี่ชี่. ยาว นี้แม้แน น้าน ชีเย, “นา ยิวชฺ้าง อือ ก่าซ้าด มาง ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ยาว พระเยซู นี้แม้แน พอย ชีเย, “นี้ย่า นาง เย้งบู้ แอล้า อ้าว ฮาก ม่ายแบ ปี่ ล่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ยาว ผู้ว่า ปีลาต มือ นี้แม้แน น้าน แล่ ชีเย, “นาง เย้ง กานยาว กงา ยิวชฺ้าง ลา? ชฺ้าง นางนา ซฺื่ยล้า ล่า คูชี อือย่า, นาง ชฺ้าง แน ปุโรหิต ยอคา อือ ย้าเป. ท้าว นา บ้าเจอ อางเลิ่ง อางซี ฮาย แอ?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “กงา ล่าที่ นี้ย่า ชฺ้างอางเมิง นู้เวอ จายล้า ชี บ่าอ่า เป. จาว่าแน แฮ้แม้แนยาว กงา ชฺ้าง อืม ยิวชฺ้าง ยอคา อือนา กงานา บ่าปี่ชู ล่า เป. จ้า ม้าม้า นี้ย่า กงา ล่าที่ นี้ ชฺ้างอางเมิง นู้เวอ บ่ากงาจายล้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","แฮ้งเย่ ผู้ว่า ปีลาต มือ พระเยซู นา นี้แม้แน น้าน ชี, “ท้าว นี้แม้แนยาว นา ก่าซ้าด ย้าวา?” แน. ยาว พระเยซู มือ นี้แม้แน จี่พอ ชีเย, “โอ่ย! อางอ้า ย้า นาง จี่ นี้ย่า อางกง่า ย้าเป. นี้งย้า กงา ชฺ้างอางเมิง นู้เวอ เกิ้ด ลือ ชี นี้, ไม้ ชฺ้าง อือนา อางเลิ่ง ม้าม้า แฮ้ง ม่าแบ ปี่ง แนนอ. ยาว ชฺ้าง คาโคลาโค อางเลิ่ง ม้าม้า มาง ชฺ้าง เพล่อ คูชี อือย่า, กงา จี่ต่าง นา น้า คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ยาว ผู้ว่า ปีลาต มือ พระเยซู นา นี้แม้แน น้าน ชีเย, “อางเลิ่ง ม้าม้า แฮ้ บ้าเจอ?” แน. แฮ้แม้แน น้า เปิน ยาว ยาง อ่อกแอ ชฺ้าง อือนา ซฺ้าน แอ แล่ ชีเย. ยาว ยองนา นี้แม้แน จี่ช่าง ชีเย, “ยา อางเลิ่ง อางซี ฮาย ชี แน กงา บ่ามย่าง น้อ. ");
INSERT INTO bzi_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","จ้า นองเมอ นี้แม้แน อางลี้บอางล่าว จา แง อ่าลา, ปัสกาป่อยนืง เคิน ยาว นอ กงานา นักโทษ ทื่อม่าง ตอ ปี่ ล่าง. นอ กงานา ยิวชฺ้าง อือ ก่าซ้าด นี้มางนา อางตอ ปี่ล่าซี่ ลา?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","จ้า ค่องช่าง อืม นี้แม้แน จี่ โฮ้กฮ้าว คูง เย, “ยางนา บ่าตอ โจ! จ้า บารับบัส นา ตอโว!” แน. (บารับบัส อางเมิง คล้าว โย้เวอ อางเลิ่ง บ่าแม่น อางซื่กอางซ่าก ฮาย ตอล้า ปี่ ชี่ มาง ย้าเย่.) ");
INSERT INTO bzi_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","แฮ้งเย่ ผู้ว่า ปีลาต มือ ชฺ้าง นา ม่า พระเยซู นา ซ้าดอางคอล่าตื่อ ชืก ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ยาว ตาฮ้าน อืม จี่กู่ ป่าง แฮ้ง ไจ มงกุฎ แต่ง ชีเย. ยาว พระเยซู อางตู่ โย้เวอ ช่อง ปี่ ชีเย, แน พระเยซู นา ค่าลาวอางเง้โลบแล่เซฺ่อ สีม่วง ก่าซ้าด ค่าลาว แม้แน ชีแฮ้ง ตูม ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ยาว ยองมู ย้าง ไลเทอ ย้าเย่ เพ่นกา พระเยซู นา อ้องซฺ้า แล คู ชี, แน พระเยซู นา นี้แม้แน จี่ ฮูย้า คู ชีเย, “ยิวชฺ้าง อือ ก่าซ้าด เวอ, จาบื่อดื้งบื้อ แน จา โว!” แน. ยาว ยองมือ พระเยซู นา แมก่า เวอ ทาก ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ยาว ผู้ว่า ปีลาต ชฺ้าง อือนา อ่อกซฺ้า แอ ชีเย. ยาว ยองนา นี้แม้แน จี่ช่าง ชีเย, “ฮู ปาว กงา อามือ ยางนา นองก้อง ชา ซฺื่ย ลือ เป, ไม้ กงา นองนา แบ ปี่ ล่าง. กงา ยาง อางซี ฮา ชี แน บ่ามย่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ยาว พระเยซู นา ผู้ว่า ปีลาต ยู้มอางฮื่อ ล้าก้า โย้เวอ ซฺื่ย อ่อกลืน ชีเย. ยาง อางตู่ โย้เวอ จี่กู่มงกุฏ ช่อง ปี่ชี่ เย, แน ค่าลาวอางเง้โลบแล่เซฺ่อ สีม่วง ตูม แล่ชี่ เย. ยาว ผู้ว่า ปีลาต มือ ยองนา นี้แม้แน ม่า ชีเย, “ฮูปาว ยา นู้เวอ จ่าน ญ้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ปุโรหิต ยอคา อือ แน ชฺ้าง โบสถ์อางฮื่อ ฮูพลา อืม พระเยซู นา มย้าง คูยาว ยอง นี้แม้แน จี่ โฮ้กฮ้าว คู ชีเย, “ยางนา ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด แซ่ โว! ไม้กางเขน ท่า เวอ ตื่อตี้ด แซ่ โว!” แน. ยาว ผู้ว่า ปีลาต นี้แม้แน จี่พอ ชีเย, “นอง ยางนา ซฺื่ย ฮา แอ ปาว, ไม้ กงา บ่ามย่าง น้อ ยา อางเลิ่ง อางซี ฮา ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ยาว ยิวชฺ้าง ยอคา อืม นี้แม้แน จี่พอย คู ชีเย, “ยิว อางลี้บอางล่าว โย้เวอ เค่ ยาว ยา อางเลิ่ง อางซี ฮา ชี, ยาง อางซี นี้ย่า กงาซฺี้ แง, ไม้ ยา พาจาวอางย่า แน ฮาจ่าแล่ง น้อ” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ผู้ว่า ปีลาต แฮ้แม้ กงากย่า ยาว ยาง แค ยืก ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ยาว ผู้ว่า ปีลาต มือ ยาง ยู้มอางฮื่อ โย้เวอ อ้องแลน แล่ชี่ เย. ยาว พระเยซู นา นี้แม้แน น้าน แล่ ชีเย, “นา ล้อเกิ้ง จายล้า แอ?” แน. จ้า พระเยซู บ่าม่า เย. ");
INSERT INTO bzi_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","แฮ้งเย่ ผู้ว่า ปีลาต มือ ยางนา นี้แม้แน จี่ช่าง ชี, “นา กงานา บ่าจี่ช่าง ล่า กานา ลา? นา บ่าแบ ล่า กงา ชฺ้าง นา ม่า นางนา ตอ ปี่ ล่าเวิม อางกงา, แน ชฺ้าง นา ม่า นางนา ไม้กางเขน ท่า เวอ ตื่อตี้ด แซ่ ปี่ ล่าเวิม อางกงา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ยาว พระเยซู นี้แม้แน จี่พอ ชีเย, “จาว่าแน พาจาว มาง นางนา ล่าที่ บ่าปี่จา ล่าอู้, นา กงา ล่อ แน ล่าที่ บ่าฮื่อ. นี้แม้แนยาว ชฺ้าง กงานา ซฺื่ย นางนา ซฺาล้า ล่าชี่ อือย่า นาง ล่อบ่าปา อางบล่าบ บย่า แล่แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ผู้ว่า ปีลาต แฮ้แม้แน กงากย่า ยาว ยาง พระเยซู นา ชา ตอ ชีเย. จ้า ยิวชฺ้าง ยอคา อือ นี้แม้แน จี่ โฮ้กฮ้าว ล้า ชีเย, “จาว่าแน นาง ยางนา ตอย ยาว, นา ก่าซ้าดยอคา ซีซาร์ อางช่าง บ่าอ่า, ไม้ อ่าซ่าง ก่าซ้าด แน ฮาจ่าแล่ แง, ยา ก่าซ้าดยอคา ซีซาร์ นา เม้อ แงแน ทื่อช่างกานญา” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ผู้ว่า ปีลาต แฮ้แม้แน กงากย่า เมอ ยาง พระเยซู นา อางเง้ โย้เวอ ซฺื่ย อ่อกลืน ชีเย. ยาว ยาง อางซีต้าดต่อนดื้งย้า โย้เวอ ดื้ง ลือ ชีเย. อางซีต้าดต่อนดื้งย้า แฮ้ย่า ลอบา ค่าง ชี ชี แน ฮ้าว เย. (อารเมค ต่าง เวอ “กับบาธา” แน ฮ้าว แง.) ");
INSERT INTO bzi_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ยาว แฮ้นืง วันศุกร์ เย, แน ปัสกาป่อยนืง แต่งจ่าล่างจ่านืง เย. แฮ้ญ่าม เมอ นืงก้องฮ่างจฺ่าญ่าม นาตู้, ผู้ว่า ปีลาต มือ ชฺ้าง อือนา นี้แม้แน จี่ช่าง ชีเย, “ฮูปาว นู้เวอ จาน ญา นอง ก่าซ้าด มาง!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ยาว ชฺ้าง อืม นี้แม้แน จี่ โฮ้กฮ้าว คู ชีเย, “แซ่ โว! แซ่ โว! ยางนา ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด แซ่ โว!” แน. ยาว ผู้ว่า ปีลาต มือ ยองนา นี้แม้แน น้าน ชีเย, “นอ กงานา นอง ก่าซ้าด มางนา ไม้กางเขน ท่า เวอ ตื่อตี้ด แซ่ ปี่ ล่าง ลา?” แน. ยาว ปุโรหิต ยอคา อืม นี้แม้แน จี่พอย ชีเย, “กงู เมอ ก่าซ้าด ทื่อม่าง ญา จา แง, แน กงู ก่าซ้าด ม้า ซีซาร์ เป” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","แฮ้งเย่ ผู้ว่า ปีลาต พระเยซู นา โรม ตาฮ้าน อือนา ปี่ ยาว ไม้กางเขน ท่า เวอ ตื่อตี้ด แอ ปี่ชี่. ยาว ตาฮ้าน อืม พระเยซู นา ซฺื่ย แอน ชีเย ");
INSERT INTO bzi_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","พระเยซู ไม้กางเขน ยางนา ไจ ตื่อตี้ด แฮ้ง ป่า แล่ ยาว “อางตู่ ตู่คย่าม ตาแซ้” แน ฮ้าว โย้เวอ ย่อ แอ้น ชีเย. (อารเมค ต่าง เวอ กลโกธา แน ฮ้าว เย.) ");
INSERT INTO bzi_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ยาว ยอง โย้เวอ เคอ แอ ยาว พระเยซู แน ค่าโม่ยค่ามโจน 2 คู่น มาง เย่ดนา ไม้กางเขน ท่า เวอ ตื่อตี้ด ชีเย. พระเยซู นา เย่ด ก้องนื้ง โย้เวอ ดื้ง ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ยาว ผู้ว่า ปีลาต มือ ล่าไม แป้น ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด ชี โย้เวอ นี้แม้แน แต้ม ชี ชีเย, “เยซู นาซาเร็ธ บ่า, ยา ยิวชฺ้าง อือ ก่าซ้าด” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ยาว ชฺ้าง อางอีบ่าอ่า เย ไม้กางเขน ท่า แต้ม ชี ชี แฮ้ง กงาอ้าน คู ชี, ไม้ พระเยซู นา ไม้กางเขน ท่า ตื่อตี้ด ชี แฮ้ อางเมิง โย้เวอ อางแท้ เย, แน อางไล่ แต้ม กาน ชี แฮ้ อารเมค ต่าง แน ลาตินต่าง (โรมต่าง) แน กรีก ต่าง เย. ");
INSERT INTO bzi_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ยาว ปุโรหิต ยอคา อืม ผู้ว่า ปีลาต นา นี้แม้แน จี่ช่าง ชีเย, “ยิวชฺ้าง อือ ก่าซ้าด แน บ่าแต่ม โจ. จ้า นี้แม้แน แต้ม ปาว, ‘ค่าพ่าย่า นี้ม้า ยิวชฺ้าง อือ ก่าซ้าด แน ฮาจ่าแล่ แง’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","จ้า ผู้ว่า ปีลาต มือ ยองนา นี้แม้แน จี่พอย ชีเย, “กงา บ้าเจอ แต้ม ชี ชี, แฮ้แม้แน ตอย จาย ปี่ โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","น่อง เวอ ตาฮ้าน อือ พระเยซู นา ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด ยาว, ยอง 4 คู่น ย่าง พระเยซู อางก่าอางตูม ย่าง กามาง กาพื้น กาแน เปิ่ง ลางกา ชีเย. จ้า พระเยซู ค่าลาว ล่ามโล่ด ตูมแล่เซฺ่อ ตูม แล่ชี่ แฮ้ พ้าทอ ชี อือ เย. แน กู่ยตี้ด ฮ่อย บ่าจา เย, ไม้ พ้า ทื่อพื่น ญา เย ไจ แต่ง ชี่. ");
INSERT INTO bzi_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ยาว ยองมู แฮ้ง นี้แม้แน ม่า ลางกา ชีเย, “นี้ย่า บ่ากงา ชีด เปิ่ง กาคา. จ้า เบอจอก ฮู ปาว อ่าซ่าง กงา แง” แน. ยาว นี้ย่า พระคัมภีร์ โย้เวอ มอ ยาว แต้ม ชี ชี แม้แน ม้าม้า ย้าเย่ ตอล้า ชี. พระคัมภีร์ โย้เวอ นี้แม้แน แต้ม ชี ชีเย, “ยอ กงา อางก่าอางตูม แฮ้ง เปิ่ง ลางกา แง. ยาว กงา ค่าลาว ล่ามโล่ด ตูมแล่เซฺ่อ แฮ้ง เบอจอก ลางกา แง” แน. ยาว ตาฮ้าน อืม แฮ้แม้แน ม้าม้า ย้า ฮา ชี. ");
INSERT INTO bzi_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ยาว พระเยซู อางบา, อางบืง แน มารีย์ โคลปัส ค่าบา แน มารีย์ มักดาลาชฺ้าง มาง พระเยซู นา ไม้กางเขน ตื่อตี้ด ชี โย้เวอ แท้ แน จูง คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ยาว พระเยซู ยาง อางบา แน ยาง ศิษย์ ลาก มางนา ฮู มย้าง ชีเย. แฮ้งเย่ ยาง อางบา มางนา นี้แม้แน จี่ช่าง ชี, “อ่าบา เวอ, ยางนา นาง อางย่า เพล่อ ปี่ ปาว” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ยาว พระเยซู มือ ยาง ศิษย์ แฮ้มางนา นี้แม้แน จี่ช่าง ชีเย, “ยางนา นาง อางบา เพล่อ ปี่ ปาว” แน. ยาว ศิษย์ แฮ้มาง แฮ้เมอจาย ย้าเย่, พระเยซู อางบา มางนา ยาง ยู้ม โย้เวอ ซฺื่ย ดื้ง แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ยาว พระเยซู แบน ชีเย ล่ากาน กูย่างกูเจ้อ นี้ย่า ว่า เปิน โค ญา แน. ยาว ยาง นี้แม้แน จี่น ชีเย, “กงา ล้าง แบ ค่า” แน, ไม้ พระคัมภีร์ เวอ มอ ชี ชี แฮ้ง ม้าม้า แน เพล่อ ปี่ แงแน เย. ");
INSERT INTO bzi_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ยาว โย้เวอ ม้ออู้ง อางย่า ทื่อซื่อ ตื้ง จา ชีเย, ม้ออู้ง คล้าว โย้เวอ อ่างู่น แต่ค่า อางเช้น อือ กาน ชี ชีเย. ยาว ยอง อู่ไต่ แฮ้ง อ่างู่น แต่ค่า โย้เวอ ตือ ชีเย. ยาว อู่ไต่ แฮ้ง หุสบ ล่างาม ตู่ตีน โย้เวอ ชอก ยาว โญก คื้น แล ปี่ ยาว พระเยซู ม่านป่อง ม่านคอ โย้เวอ แดด ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ยาว พระเยซู อ่างู่น แต่ค่า แฮ้ง อางอี้ กงาเจ้อ แล่ยาว ยาง นี้แม้แน จี่น ชีเย, “เปิน ญา” แน. ยาว พระเยซู มือ แมก่า บอก ยาว อางซ่า แช ซฺี้ กา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","แฮ้นืง วันศุกร์ เย. จ้า ซอทา แปล้น ล้ายาว ลองนืง เย. แฮ้งเย่ ยิวชฺ้าง ยอคา อืม ผู้ว่า ปีลาต นา ป้า ตาฮ้าน อือนา ม่า ชฺ้าง ไม้กางเขน ท่า เวอ ตื่อตี้ด ชี อือนา กอแคง เคลิก ปี่ชี่, ไม้ ยองนา อางไว่ แน ซฺี้ ปี่ ยาว ชฺ้างซฺี้ อางโต แฮ้ง ยู้ย ลู่งลือ ปี่ แง, ไม้ ยิวชฺ้าง อือย่า ลองนืง เวอ ไม้กางเขน ท่า เวอ ชฺ้างซฺี้ บ่าแป่น จา ปี่ ซี้ เย, ไม้ ลองนืง นี้ย่า อางนืง อางเซฺิ่งอางซฺ้าง เย. ");
INSERT INTO bzi_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","แฮ้งเย่ ตาฮ้าน อืม ค่าพ่าย่า 2 คู่น พระเยซู ก่องทาง โย้เวอ ไม้กางเขน ท่า เวอ ตื่อตี้ด ชี เย่ดนา กอแคง เคลิก ชี. ");
INSERT INTO bzi_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ยาว ตาฮ้าน อืม พระเยซู ก้อง ย่อ เคิน ลือ ชีเย. ยาว ยองมือ พระเยซู ซฺี้น ชี แน มย้าง ชีเย. แฮ้งเย่ ยอง พระเยซู นา กอแคง บ่าเคลิก แง. ");
INSERT INTO bzi_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","จ้า ตาฮ้าน ทื่อม่าง จา ชีเย, ซฺ้าม ต้ามแล้ม แฮ้ง พระเยซู ป่องปอง อางปย้า เวอ ชาว ชีเย. ยาว ซฺ้อก เย ซฺี่ แน ล้าง เซฺ่อ อ่อกลืน ชี. ");
INSERT INTO bzi_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(ยาว ชฺ้าง ทื่อม่าง จา ชีเย, ยา อางเลิ่ง ตอล้า ชี แฮ้ง กงามย้าง ชีเย. ยาว ยาง ฮากนา อู่บน้า ปี่ ชีเย, ยา บ้าเจอ กงามย้าง ชี แน. ยาว ยาง อางเลิ่ง อู่บ ชี นี้ย่า อางเลิ่ง ม้าม้า. ยาว ยาง นองนา อู่บน้า ปี่ ล่าชี่ นี้ย่า, ไม้ นองนา เจ่อ ปี่ ล่าง แนนอ.) ");
INSERT INTO bzi_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","อางเลิ่ง นี้แม้แน ตอล้า ชี นี้ย่า, ไม้ มอ ยาว พระคัมภีร์ เวอ แต้ม ชี ชี แฮ้ง ม้าม้า แน เพล่อ ปี่ง แน เย. มอ ยาว พระคัมภีร์ โย้เวอ นี้แม้แน แต้ม ชี ชี, “ยาง อางกง่าว นี้ย่า ทื่อซี แนม บ่าเคลิก” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","แน พระคัมภีร์ โย้เวอ นี้แม้แน มอ ชี แล่ชี่ เย, “ยองมู นี้ย่า ชฺ้าง ยอง ชาว ชี มางนา ฮู คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ค่าพ่าย่า ทื่อม่าง จา ชี, ยาง อางเม้ง โยเซฟ แน. ยา อาริมาเธีย ชฺ้าง, ยา พระเยซู นา นืงบาชี เย. จ้า ยา อ่าซ่าง มางนา บ่าปี่ แบ เย, ไม้ ยา ยิวชฺ้าง ยอคา อือนา แค เย. ยาว โยเซฟ มือ ผู้ว่า ปีลาต ก้อง พระเยซู ศพ แฮ้ง ป้า แล ชีเย. ยาว ผู้ว่า ปีลาต มือ โยเซฟ นา ปี่ ชี. แฮ้งย้า โยเซฟ มือ พระเยซู ศพ ย่าง ท้ามชฺ้างซฺี้ชีย้า โย้เวอ ฮ้าน ชี แอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ยาว นิโคเดมัส คาตา เย ล้าน ชี. ยา ต่องก่า เวอ มู่งคี่ โย้เวอ พระเยซู นา อางซฺ้า ล้า กางซื้ง ย้า. ยาว ยา อางเกิ่งอางฮ้อม ฮ้าน ล้าน ชีเย. อางเกิ่งอางฮ้อม แฮ้ย่า มดยอบ แน กฤษณา ซูน ลางกา ชีเย. ฮ่าน แฮ้ 30 กิโลกรัม ล่อซฺ่า เย. ");
INSERT INTO bzi_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ยาว โยเซฟ แน นิโคเดมัส เย่ด พระเยซู ศพ แฮ้ง ยู้อ่อก ยาว, อางเกิ่งอางฮ้อม ย่าง อางโต เวอ พ่อ ชี. ยาว พ้า อางป่อน อางฮู่ อางคา ย่าง ป้าน ชีเย. นี้แม้ ฮา นี้ย่า ยิวชฺ้าง อือ ชฺ้างซฺี้ นา ท้ามชฺ้างซฺี้ชีย้า โย้เวอ ชา ชี เมอ อางลี้บอางล่าว ฮา ย้างย้า. ");
INSERT INTO bzi_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","พระเยซู นา ไม้กางเขน ท่า ตื่อตี้ด ชี โย้เวอ โซน ทื่อโซน จา ชีเย. โซน คล้าว โย้เวอ ท้ามชฺ้างซฺี้ชีย้า อางซฺื่อ จา เย, ชฺ้างซฺี้ นา บ่าชี กางซื้ง เย. ");
INSERT INTO bzi_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ยาว เย่ด พระเยซู ศพ ย่าง ท้าม คล้าว โย้เวอ ฮ้าน แลน ชีเย, ไม้ ท้าม แฮ้ พระเยซู นา ไม้กางเขน ท่า ตื่อตี้ด ชี โย้เวอ อางแท้ เย. แน แฮ้นืง ลองนืง ชา เคิน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ว่านตีด ซอทา อางด่า โย้เวอ มารีย์ มักดาลาชฺ้าง มาง ท้ามชฺ้างซฺี้ชีย้า โย้เวอ แลน ชีเย, ยาว ยาง มย้าง ชีเย ท้าม อ้องย้า เวอ ลอบา อางฮื่อ พี่ ชี ชีย้าง ต่านอ่อก ชี แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","แฮ้งเย่ ยาง ซีโมนเปโตร แน พระเยซู ศิษย์ ลาก มางนา ฮื่น ซฺ้าแล ชี, ยาว นี้แม้แน ม่า ชีเย, “ยอ กงู จี่วีดอางซื้ง มาง อางโต ย่าง ท้าม เวอ ยู้ อ่อกแอน ชี. จ้า ล้อเกิ้ง ฮ้าน ชี แอชี นามบ่าแบ ล้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","แฮ้งเย่ ซีโมนเปโตร แน ศิษย์ แฮ้มาง ท้ามชฺ้างซฺี้ชีย้า โย้เวอ แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","เย่ด ฮื่นแลน ชีเย. จ้า ศิษย์ แฮ้มาง ฮื่น เคอ แล ออน เย, ไม้ ยา ซีโมนเปโตร ล่อบ่าปา เย ฮื่นไว่ แง. ");
INSERT INTO bzi_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","จ้า ยา ท้าม คล้าว โย้เวอ บ่าอ่อง แล เย. ยา อางเง้ โย้เวอ จาย ท้าม คล้าว โย้เวอ บอกฮูน ชีเย, ยาว ยาง พระเยซู นา พ้า ปาน ชีย้าง โบย จา นา มย้าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ยาว ซีโมนเปโตร เคินล้า ชีเย. ยาว ยาง ท้าม คล้าว โย้เวอ ย่อ อ้อง แลน ชีเย, ยาว ยาง พ้า โบย จา นา มย้าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","จ้า พระเยซู อางตู่ โย้เวอ พ้าปาน ชี แฮ้ย่า โตบ ชี ชีเย, แน พ้า พระเยซู อางโต เวอ ปาน ชี โย้เวอ ทื่งกง่า แน บ่าชี เย. ");
INSERT INTO bzi_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ยาว ศิษย์ ซีโมนเปโตร ฮู่ เวอ เคอล้า ชี มาง ซีโมนเปโตร นา เค่ ท้าม โย้เวอ อ้องแลน ชีเย. ยาง มย้าง ยาว เจ่อ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(ไม้ ยอ มอ ยาว พระคัมภีร์ เวอ แต้ม ชี ชี แฮ้งนา ม้าม้า แน ตอล้า แงแน บ่าเย่ง เคอ กาเย. มอ ยาว พระคัมภีร์ โย้เวอ นี้แม้แน แต้ม ชีเย, พระเยซู ซฺี้ ยาว แต่ล้า แล่แง แน.) ");
INSERT INTO bzi_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ยาว เย่ดมือ ยู้ม เวอ พ่าว แอ้น แล่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","มารีย์ ท้ามชฺ้างซฺี้ชีย้า ล้าก้า โย้เวอ อู้ง จูง ชีเย. ยาง อู้ง จูง เมอ ท้าม คล้าว โย้เวอ บอก ฮูยแล ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ยาว ยาง เท่วาด่า 2 องค์ มย้าง ชีเย. เท่วาด่า มางเย่ด อางก่าอางตูม อางป่อน ตูม แล่ชี่ เย, แน พระเยซู อางโต โบ้ยอ่าน โย้เวอ ดื้ง ชีเย. เท่วาด่า ทื่อม่าง ม้า ตู่กู่ม ป่ากย่า ดื้ง ชีเย, แน เท่วาด่า ทื่อม่าง ม้า ป่าต่อง ป่ากย่า ดื้ง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ยาว เท่วาด่า มางเย่ด มารีย์ นา นี้แม้แน น้าน ชีเย, “นา บ้าเจอฮานา อู้ง แง?” แน. ยาว ยาง นี้แม้แน จี่พอย ชีเย, “ยอ กงา จี่วีดอางซื้ง มางนา ซฺื่ยแอ้น ชี, แน กงา บ่าแบ ยอ ยางนา ล้อเกิ้ง ซฺื่ยแอ้น ชี” แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ยาง แฮ้แม้แน จี่ ยาว น่องน่อง ป่ากย่า แมก่า พลาบ แอ ปี่ชี่ เย, แน ยาง พระเยซู จูง จา นา มย้าง ชีเย. จ้า ยา พระเยซู แน บ่าแบ เย. ");
INSERT INTO bzi_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ยาว พระเยซู มือ ยางนา นี้แม้แน น้าน ชีเย, “นา บ้าเจอฮานา อู้ง แง? นา อ่าซ่าง นา ซฺ้ากว่า แง?” แน. มารีย์ เย้ง เย พระเยซู โซนว่าฮู แน. แฮ้งเย่ นี้แม้แน จี่ ชี, “จาว่าแน นาง ยางนา ซฺื่ยแอ้น ยาว กงานา ม่าย ล่าปาว, กงา ยางนา ล่า แอแน” แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","แฮ้งเย่ พระเยซู มือ นี้แม้แน จี่ ชี, “มารีย์ เวอ” แน. ยาว มารีย์ แมก่า พลาบแล ปี่ ยาว อารเมค ต่าง จี่ ชี นี้แม้แน “รับโบนี” แน. (อ่าจาน นา ฮา เย.) ");
INSERT INTO bzi_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ยาว พระเยซู ยางนา นี้แม้แน ม่า ชีเย, “กงานา บ่าชูชี ล่าโจ! ไม้ กงา อ่าโบ้ง นา บ่ากงา พ่าวซฺ้า แล กาซื้ง. นาง มือ กงา อางช่าง อือนา พ่าวซฺ้า แล ปาว, แน ยองนา นี้แม้แน ม่า โว, ‘กงา อามือ กงา อางโบ้ง แน นอง อางโบ้ง มางนา ชา พ่าว ซฺ้า แล แง. ยา กงา พาจาว แน นอง พาจาว มาง ย้าเป’” แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","แฮ้งเย่ มารีย์ มักดาลาชฺ้าง มาง พระเยซู ศิษย์ อือนา นี้แม้แน ม่า แล ชี, “กงา จี่วีดอางซื้ง มางนา มย้าง ย่า!” แน. ยาว ยาง ยองนา อู่บน้า ปี่ชี่ เย, พระเยซู ยางนา บ้าเจอ จี่ช่าง ชี แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ว่านตีด มู่งคี่ล้าก้า แฮ้นืง ย่า พระเยซู ศิษย์ อืม ทื่งกง่า แน ดื้งช้อน ลางกา ชีเย, แน ยอ ยู้ม ล้องก้อ พี่ อางแซ่ กาน ดื้ง คู ชีเย, ไม้ ยอ ยิวชฺ้าง ยอคา อือนา แค คูง เย. พระเยซู มือ ยอง กางมู เวอ จูง ล้า ชีเย, แน นี้แม้แน จี่ ชีเย, “จาบื่อดื้งบื้อ แน จา คู โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","พระเยซู แฮ้แม้แน จี่ ยาว ยองนา ยาง ล่าปู่ แน ป่องปอง อางปย้า โย้เวอ อางฮ่อย ย่าง ฮูย ปี่ ชีเย, ยาว ศิษย์ อืม นืงบาต่องม่อนซ้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ยาว พระเยซู มือ นี้แม้แน จี่ แล่ ชีเย, “จาบื่อดื้งบื้อ แน จา คู โว! กงา อามื้อ นองนา ชา ซฺาแล อางเลิ่ง อางแม่น แฮ้ง ป่าว ปี่ ล่าง. อ่าโบ้ง กงานา ซฺาลือ ปี่ ล่าชี่ แฮ้งแม้แน ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","พระเยซู แฮ้แม้แน จี่ ยาว, ยองนา อางซ่า กล่าง กาน ชีเย, แน นี้แม้ จี่ ชีเย, “อางค่องอางล้า อางเซฺิ่งอางซฺ้าง นี้ง ลาบยู้ คู โว! ");
INSERT INTO bzi_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","จาว่าแน นอง ชฺ้าง อางบล่าบ ล้อมางนา อางซี บ่ายู่ แง, ชฺ้าง อางบล่าบ แฮ้มาง ยาง อางซีอางบล่าบ ฮา ชี แฮ้ง กงาปูน แล่แง. จ้า จาว่าแน นอง ชฺ้าง อางบล่าบ ล้อมางนา อางซี ยู้ แง, ชฺ้าง อางบล่าบ แฮ้มาง ยาง อางซีอางบล่าบ ฮา ชี แฮ้ง บ่ากงาปูน แล่” แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","พระเยซู ยาง ศิษย์ อือนา ซฺ้า ล้า เมอ, โธมัส ยองก้อง ทื่งกง่า แน บ่าดื่ง เย. โธมัส ฮาก แฝด แน ฮ้าว มาง ย้าเย่. ยา พระเยซู ศิษย์ 12 คู่น โย้เวอ ชฺ้าง ทื่อม่าง มาง ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","แฮ้งเย่ ศิษย์ ทื่อบ่า อืม ยางนา ม่าย แบ ปี่ ชี่, แน ยางนา นี้แม้แน จี่ช่าง ชีเย, “กงู จี่วีดอางซื้ง มางนา กงามย้าง คู ยา” แน, ยาว ยาง ยองนา นี้แม้แน จี่พอย ชีเย, “กงา บ่าเจ่อ, กงา ยาง ล่าปู่ เวอ เล้กโก้น อางฮ่อย แฮ้ง กงามย้าง เมินญา เจ่อ แง, แน กงา ล่าญู่ง นี้ง ยาง ป่องปอง อางปย้า โย้เวอ กงาโค่ง อ้องแล ปี่ เมินญา เจ่อ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","น่อง โย้เวอ 7 นืง จายล้า แล่ ยาว, พระเยซู ศิษย์ แน ตื่น โธมัส คาตา ย้าเย่ ยู้ม คล้าว โย้เวอ ทื่งกง่า แน ดื้งช้อน ลางกา แล่ชี่. ล้องก้อ อางแซ่ กาน เวิม พระเยซู มือ อางฮ้อง โย้เวอ อ้องล้าน ชีเย. พระเยซู ยอง กางมู โย้เวอ จูง ล้า ชีเย, แน นี้แม้ จี่ ชีเย, “จาบื่อดื้งบื้อ แน จา คูโว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ยาว ยาง โธมัส นา นี้แม้แน จี่ช่าง ชีเย, “กงา ล่าปู่ นู้เวอ ฮู โว! แน นาง ล่าญู่ง แฮ้ง โค่ง แล ปี่ ปาว, แน นาง ล่าปู่ แฮ้ง กงา ป่องปอง อางปย้า นู้เวอ ว่าซ่าว ฮู ปาว. บ่าอ่า แน เย้ง แฮ้ง ว่าง ยาว เจ่อ โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ยาว โธมัส มือ นี้แม้แน จี่ ชีเย, “กงา จี่วีดอางซื้ง มาง! แน กงา พาจาว มาง!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ยาว พระเยซู มือ นี้แม้แน จี่ ชีเย, “นาง เจ่อ ชี นี้ย่า, ไม้ นา กงานา กงามย้าง ล่า ป้าน่อ. จ้า อ่าซ่าง กงานา บ่ากงา มย้าง ล่า แน กงานา เจ่อ ล่าง, ยา ก่ามป่อน บย่า ย้า กงาบู้ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","พระเยซู ยาง ศิษย์ อือ ล้าก้า โย้เวอ อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ชี นี้ย่า อางอีบ่าอ่า เย จา แล่ง. จ้า ปาบ นี้ปาบ ก้อง บ่ากงา แต้ม ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","จ้า ปาบ นี้ปาบ ก้อง เวอ อางเลิ่ง แต้ม ชี นี้ย่า, ไม้ นองนา เจ่อ ปี่ ล่า คูแง แนนอ, พระเยซู พาจาว มาง แช้ยู้ ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ ชี่ มาง ย้า, แน ยา พาจาวอางย่า แน. ยาว นอง นืงบาชี เมอ นอ ยาง ปาปาย ย้า จี่วีดม้าม้า จา คูแง. ");
INSERT INTO bzi_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ยาว พระเยซู มือ ยาง ศิษย์ อือนา ลองอองอางฮื่อ กาลิลี โย้เวอ ทื่อเทอ มย้าง แล่ ปี่ ชีเย. อางเลิ่ง ตอล้า ชี แฮ้ย่า นี้แม้แน เย. ");
INSERT INTO bzi_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","แฮ้ญ่ามเมอ ชฺ้าง นี้อือ ทื่งกง่า แน ดื้งช้อน ลางกา ชีเย. ชฺ้าง แฮ้อือ นี้อือ ย้าเป, ซีโมนเปโตร, โธมัส ฮาก แฝด แน ฮ้าว มาง, นาธานาเอล คานา ค่อง กาลิลี แควน เวอ จายล้า ชี มาง, เศเบดี อางย่าย่าค่า 2 คู่น มาง เย่ด, พระเยซู ศิษย์ ทื่อบ่า อือ 2 คู่น. ");
INSERT INTO bzi_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ยาว ซีโมนเปโตร ยองนา นี้แม้แน จี่ช่าง ชีเย, “กงา ล่องแต่ ซฺ้า แอ ปานา” แน. จ้า ยอง ซีโมนเปโตร นา นี้แม้แน จี่ช่าง คู ชีเย, “กงู คาตา ย้า เค่ แอ แง” แน. แฮ้งเย่ ยอง ซฺื่ย ลางกา ล้องตา แอ้น ชี. จ้า แฮ้ คี่ ยอ ท้าน ย้าเย่ ล่องแต่ บ่ากงา คู. ");
INSERT INTO bzi_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ยาว ซอทา เวอ พระเยซู แปฟาง เวอ จูง ชีเย. จ้า ยาง ศิษย์ อือ พระเยซู แน บ่าแบ คู เย. ");
INSERT INTO bzi_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ยาว พระเยซู มือ ยองนา นี้แม้แน น้าน ชีเย, “อางช่าง นอง เวอ, ล่องแต่ กงา คู แอ ลา?” แน. ยาว ยอง นี้แม้แน ม่า คู ชีเย, “ท้านยา บ่ากงา คู” แน. ");
INSERT INTO bzi_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ยาว พระเยซู มือ ยองนา นี้แม้แน ม่า ชีเย, “ล้อง ล่าม่า ป่ากย่า ฮอจื้ง แฮ้ง จานแอ ปี่ โว! ยาว นอ ล่องแต่ กงา คูแง” แน. ยาว ยอง ฮอจื้ง ย้าง จานแอ ปี่ ชีเย. ยาว ล่องแต่ อางอีบ่าอ่า เย กงาย คูชี. ฮอจื้ง แฮ้ง บ่าเซฺอ จ่าก่า กา แอเคอ เย. ");
INSERT INTO bzi_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ยาว พระเยซู ศิษย์ ลาก มาง ซีโมนเปโตร นา นี้แม้แน จี่ช่าง ชีเย, “ชฺ้าง แฮ้ม้า จี่วีดอางซื้ง มาง ชีมา!” แน. ยาว ซีโมนเปโตร มือ จี่วีดอางซื้ง มาง แน กงากย่า ยาว, ยาง อางไว่อางคย้าง เย ฮอจื้ง จาน เมอ ค่าลาว แล แล่ชี แฮ้ง กอยตูม แล่ชี่. ยาว ยาง ล้าง โย้เวอ เปิก ลู่งแอน ชีเย. ยาว ยาง ล้าง ล่อย แปฟาง โย้เวอ แลน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","จ้า ศิษย์ ทื่อบ่า อือย่า ล้องตา เค่ ล้าน คู ชีเย, แน ฮอจื้ง ล่องแต่ ปลื้ง แน จา ชี แฮ้ง คาตา เย เซฺอ ล้าน ชี, ไม้ ยอ แปฟาง โย้เวอ บ่าเว่อ เย, 100 เมตร ล่อ นี้ง ญาเย่ เว่อ แง. ");
INSERT INTO bzi_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ยาว ยอง แปฟาง เวอ เคิน ล้าเมอ, ล่องแต่ แน ค้านู้มป่าง ยาง บี่จี อางจฺ่อ เวอ คาง จา นา มย้าง คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ยาว พระเยซู มือ ยองนา นี้แม้แน จี่ช่าง ชีเย, “นอง ล่องแต่ ซฺ้า กงา คูชี แฮ้ง คาตา แน ฮ้าน ล้าน โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","แฮ้งเย่ ซีโมนเปโตร ล้อง โย้เวอ ลู่งแอ้น ชี. ยาว ยาง ฮอจื้ง แฮ้ง แปฟาง ท่า โย้เวอ เซฺอ ตายแลน ชีเย. ล่องแต่ อางฮื่อ ปลื้ง ย้า จา แง, แน 153 โต เย ดาบ กงา ชี. จ้า ล่องแต่ ล้อม้อก บย่า เวิม ฮอจื้ง แฮ้ บ่าแช เย. ");
INSERT INTO bzi_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ยาว พระเยซู มือ ยองนา นี้แม้แน จี่ช่าง ชีเย, “ซอทา ฮ่างจฺ่า คู ปายา” แน. จ้า ยองมู นี้ย่า ทื่อม่าง แนม ยางนา บ่าน่า จอ กา เย, “นา อ่าซ่าง เวอ?” แน, ไม้ ยองมู นี้ย่า อางแบ เย, ยา จี่วีดอางซื้ง มาง ย้าแน. ");
INSERT INTO bzi_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ยาว พระเยซู ย่อย อ้อง ลาน ชีเย, ยาว ยาง ค้านู้มป่าง แน ล่องแต่ แฮ้ง กอย ท่าม แล่ ยาว ยองนา ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","พระเยซู ซฺี้ ยาว แต่ล้า แล่เมอ ยาง ศิษย์ อือนา มย้าง ปี่ชี่ นี้ย่า, นี้เทอ 3 เทอ เคิน ญา เย. ");
INSERT INTO bzi_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ยาว ยอง ซอทาฮ่าง จฺ่าก่อ คู เมอ, พระเยซู มือ ซีโมนเปโตร นา นี้แม้แน น้าน ชีเย, “ซีโมนเปโตร ยอห์น อางย่า เวอ, นา กงานา ยอง ล่อบ่าปา แน ม้าม้า ล่า ลาก ล่าแง?” แน. ยาว ซีโมนเปโตร มือ ยางนา นี้แม้แน จี่พอ ชีเย, “โอ่ย จี่วีดอางซื้ง เวอ, นาง อางแบ ย้า กงา นางนา ลาก ล่าง” แน. ยาว พระเยซู ยางนา นี้แม้แน ม่า ชีเย, “ชฺ้าง กงานา เจ่อ ล่าง อือนา ฮูพลา โว! แกะปอฮู แกะอางย่า อือนา ฮูพลา แม้แน!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ยาว พระเยซู ยางนา ทื่อเทอ น้าน แล่ ชี่ เย นี้แม้แน, “ซีโมนเปโตร ยอห์น อางย่า เวอ, นา กงานา ม้าม้า ล่า ลาก ล่าแง?” แน. ยาว ยาง นี้แม้แน จี่พอ ชีเย, “โอ่ย จี่วีดอางซื้ง เวอ, นาง อางแบ ย้า กงา นางนา ลาก ล่าแง” แน. ยาว พระเยซู มือ ยางนา นี้แม้แน ม่า ชีเย, “กงา แกะ อือนา ฮูพลา ล่า โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ยาว พระเยซู ยางนา ทื่อเทอ น้าน แล่ ชีเย, นี้เทอ 3 เทอ เคิน ญาเย่, “ซีโมนเปโตร ยอห์น อางย่า เวอ, นา กงานา อางลาก ล่ายลา?” แน. ยาว ซีโมนเปโตร พระเยซู ยางนา 3 เทอ แน นี้แม้แน น้า ชี แฮ้ง นืงบาชู่ม ชีเย, “นา กงานา อางลาก ล่ายลา?” แน. แฮ้งเย่ ยาง นี้แม้แน จี่พอ ชี, “จี่วีดอางซื้ง เวอ, นา กูย่างกูเจ้อ แบ แง, นา อางแบ ย้า กงา นางนา ลาก ล่าแง” แน. แฮ้งเย่ พระเยซู มือ ยางนา นี้แม้แน ม่า ชี, “กงา แกะ อือนา ฮูพลา ล่าโว! ");
INSERT INTO bzi_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","กงา อางเลิ่ง ม้าม้า ม่า แบ ปี่ ล่าว่า, นาง ย่าม่าง บ่าม่าง เมอ, นา นาง ทื่อม่าง แน ก่าตูม แล่ยาว นาง นืงบาจาบวา ย้า แอ ล้า กว่า แง. จ้า นาง ย่าม่าง ม่าง เมอ, นาย่า นาง ล่าปู่ แฮ้ง กลาง อ่อกแอ ปี่ แง. ยาว ฮาก นางนา พือ ล่าง. ยาว นาง บ่าแอ ซีง โย้เวอ ซฺื่ย แอ ล่าแง” แน. ");
INSERT INTO bzi_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(พระเยซู นี้แม้แน จี่ ชี่ นี้ย่า ไม้ ม่า แบ ปี่ง เย, ซีโมนเปโตร ล้อแม้ กงา ซฺี้ แงแน, ไม้ ซีโมนเปโตร ซฺี้ นี้ย่า ชฺ้าง อือนา พาจาว มาง ล่าที่ อางฮื่อ แฮ้ง ฮาย มย้าง ปี่ง เย) ยาว พระเยซู ซีโมนเปโตร นา นี้แม้แน จี่ช่าง ชีเย, “กงาก้อง เค่ ล้าน โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ซีโมนเปโตร มือ แมก่า พลาบ แอ ปี่ชี่ เย. ยาว ยาง มย้าง ชีเย พระเยซู ศิษย์ ลาก มาง ยาง น่องน่อง เวอ จูง ชี แน. (ศิษย์ แฮ้ม้า ยอง ทื่งกง่า แน มู่งคี่ฮ่างจฺ่า เมอ, พระเยซู ก้อง ดื้งเง้น ยาว นี้แม้แน น้า ชี มาง ย้าเย่, “อ่าจาน เวอ, ชฺ้าง นางนา น่อง เวอ บ่าแม่น ฮา ล่าง ม้า อ่าซ่าง เวอ?” แน) ");
INSERT INTO bzi_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ยาว ซีโมนเปโตร ยางนา มย้าง เมอ, ยาง พระเยซู นา นี้แม้แน น้าน ชีเย, “จี่วีดอางซื้ง เวอ, ท้าว ยา ล้อแม้ จา แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","จ้า พระเยซู มือ นี้แม้แน จี่พอ ชีเย, “ท้าว กงา ยางนา กงา พ่าว ลือ แล่ เมอ เคอ แน จี่วีด จา ปี่ ยาว, นา บ้าเจอ ฮา แง? แน นา บ้าเจอฮาย น้า ซฺ้า ล่าง? นา กงาก้อง เค่ ล้าน โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","แฮ้งเย่ ชฺ้าง พระเยซู นา นืงบาชี คูชี อืม ศิษย์ นี้ม้า บ่าซฺี่ แน จี่ ลางกา ชี. จ้า กานแตว พระเยซู บ่ากงา จี่ เย, ศิษย์ แฮ้ม้า บ่าซฺี่ แน. จ้า ยา นี้แม้แน จี่ ชีเย, “ท้าว กงา ยางนา กงา พ่าว ลือ แล่เมอ เคอ แน จี่วีด จา ปี่ ยาว, นา บ้าเจอ ฮา แง? แน นา บ้าเจอฮานา น้า ซฺ้า แง?” แน. ");
INSERT INTO bzi_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ศิษย์ นี้มาง ย้าเป, อางเลิ่ง อู่บ ชี ม้า แน อางเลิ่ง คาโคลาโค นี้ง แต้ม ชี ม้า, แน กงู อางแบ คูย้า ยา อางเลิ่ง ม้าม้า อู่บ แงแน. ");
INSERT INTO bzi_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","พระเยซู อางเลิ่ง ฮา ชี อือย่า อางอีบ่าอ่า เป จา แล่แง. จาว่าแน ยาง อางเลิ่ง คาโคลาโค ฮา ชี อือ โค แน ปาบ เวอ แต้ม ชี ยาว, กงา เย้ง แง ชฺ้างอางเมิง นี้ย่า อีน ชี, ปาบ แต้ม ชี แฮ้ง โค แน บ่ากอย ชี กงากา แน.");
INSERT INTO bzi_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","เธโอฟีลัส กงา อางช่าง ลาก มาง เวอ, แฮ้เมอ เวอ กงา นางนา ปาบ แต้ม ปี่ ล่า ชีนี้, พระเยซู ต่องก่า เวอ อางเลิ่ง คาโคลาโค ฮา ชี อือ แน ม่าอู่บ ชีย้าง ย้า. ");
INSERT INTO bzi_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","แน พาจาว มาง ยางนา มู่งท่า โย้เวอ แล ปี่ ชี่ ย้าง. จ้า ยางนา มู่งท่า ชา ซฺื่ยแล เมอ, ยาง ศิษย์เอก แช้ยู้ ชี อือนา ม่า ชี, ยองมู นี้ บ้าเจอ กงาฮา คูง แน. ยาว พระเยซู ยองนา ม่า เมอ, ยา อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง ไจ ม่า ชี. ");
INSERT INTO bzi_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","พระเยซู ซฺี้ ยาว แต่ล้า แล่เมอ, 40 นืง โย้เวอ ยาง ศิษย์เอก อือนา ไลเทอ ย้า มย้าง ปี่ ชี่. แน ยา ไลย่างไลเจ้อ ย้า ฮาย ชี, ยาว ยองมู นา ฮายแบ ฮายมย้าง ปี่ง ยา ซฺี้ ยาว แต่ล้า แล่ ชี ม้าม้า ย้า แน. แน ยองนา พาจาว มาง อางเมิง แฮ้ง ม่ายแบ ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ทื่อเทอ จา แง พระเยซู ยาง ศิษย์เอก อือก้อง ฮ่างดื้งจฺ่า จา เมอ ยาง ยองนา ม่า ชี นี้แม้แน, “ล้อเกิ้ง บ่าแอ โจ เยรูซาเล็ม อางเมิง นู้ ล่อ ป้าโน่. พาจาว กงา อ่าโบ้ง มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง ปี่ ล่าเมอ ตื่อเคอ ยาง ก่ามค่าน ฮาย ชี ชี แม้แน. กงา นองนา ม่า ล่า ชี แม้แน ย้า. ");
INSERT INTO bzi_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ยาว ยอห์น ชฺ้าง นา ล้าง แฮ้ง พิธีบัพ‍ติศ‍มา ฮา ปี่แง. จ้า บ่ามล่าง ยาว นองมู นี้ย่า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง พิธีบัพ‍ติศ‍มา กงาฮา แล่ คูแง” แน. ");
INSERT INTO bzi_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ทื่อเทอ จา แง พระเยซู แน ศิษย์เอก อือ มะกอกเทศ ตาแซ้ โย้เวอ ทื่งกง่า แน จา เมอ ยองมือ พระเยซู นา น้า ชี นี้แม้แน, “จี่วีดอางซื้ง เวอ, อามื้อ นา อิสราเอลชฺ้าง อือ ก่าซ้าด เพล่อ ลือ ยาว, กงูนา ปล่อง โรมชฺ้าง อือ ก้อง กงาปูน ปี่ ล่าง ลา?” ");
INSERT INTO bzi_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","พระเยซู พอ ชี นี้แม้แน, “นอง อางเลิ่ง บ่าอ่า อางนืง อางญ่าม แฮ้ย่า พาจาว กงา อ่าโบ้ง มาง ต้าดต่อน ชี ญา. ");
INSERT INTO bzi_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","จ้า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง นองก้อง ดื้ง ลือ เมอ, นองมู นี้ ล่าที่ กงา แง. แน นองมู นี้ย่า กงา อางเลิ่ง แฮ้ง ชฺ้าง อือนา กงา อู่บน้า ปี่ แง. ยาว เยรูซาเล็ม อางเมิง เวอ, ยูเดีย แควน สะมาเรีย แควน แน ชฺ้างอางเมิง คล้าว นู้เวอ กูต่องกูตี่ ย้า กงาม่าอู่บ กว่า แง.” ");
INSERT INTO bzi_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","พระเยซู จี่ เปิน ยาว, พาจาว มาง พระเยซู นา มู่งท่า โย้เวอ ตาแล ปี่ ชีเย. ยาว มู่งค่าว อืม พระเยซู นา ทู้ม โค ชี ศิษย์ อืม จูง ฮู คูชี ยางนา บ่าฮู มย้าง เมอ เคอ ย้า. ");
INSERT INTO bzi_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","พระเยซู มู่งท่า แล ยาว ศิษย์เอก อือ แงน ฮู จา คู เมอ, ทื่อชี่ดยาว เท่วาด่า 2 องค์ อางก่าอางตูม อางป่อน ตูม แล่ ชี่ มางเย่ด ยอง ก่องทาง โย้เวอ จูง ลือ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ยาว จี่ เย นี้แม้แน, “กาลิลีชฺ้าง เวอ, นอ บ้าเจอฮาย มู่ง นา จูง ฮู คูแง? พาจาว ม้าย่า พระเยซู นา มู่งท่า โย้เวอ ซฺื่ย แลน ญา. ยาว พระเยซู ทื่อเทอ พ่าว ลือ แล่ง, พาจาว มาง ยางนา ซฺื่ยแล เมอ นอง มย้าง ชี แม้แน ย้า.” ");
INSERT INTO bzi_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ยาว ยองมู ย้าง มะกอกเทศ ตาแซ้ โย้เวอ ลู่งลือ คู ชีเย. ยาว เยรูซาเล็ม อางเมิง โย้เวอ พ่าวแลน แล่ คู ชีเย. ทื่อ กิโลเมตร นี้ง ล่อ เย เว่อ แง. ");
INSERT INTO bzi_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","เยรูซาเล็ม อางเมิง โย้เวอ เคอ ลือ ยาว. ศิษย์เอก อางมู อือ ยอง อางฮ้อง อางท่า ยอง ดื้ง อาน เวอ ตายแลน คู ชีเย. ศิษย์เอก มู อือ เปโตร, ยอห์น, ยากอบ, อันดรูว์, ฟีลิป, โธมัส, บารโธโลมิว, มัทธิว, ยากอบ อัลเฟอัส อางย่าย่าค่า ม่าง, ซีโมน อิสราเอล อางเจ้ออางจาด นา อางลาก มาง แน ยูดาส ยากอบ อางย่าย่าค่า อือ เย. ");
INSERT INTO bzi_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ยองมู 11 คู่น แน ตื่ง ค่าบาย่า ทื่อบ่า แน มารีย์ พระเยซู อางบา มาง แน ยาง อางแพ้ อือ คาตา ย้า มย้าง กายาว ทื่งกง่า แน ปีนแตปีนนา ย้า อธิษฐาน ฮา คูแง. ");
INSERT INTO bzi_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ทื่อนืง จา แง เปโตร ทาจูง ล้ายาว พระเยซู ศิษย์ อือนา จี่ช่าง ชี, ศิษย์ อือย่า 120 คู่น นี้งล่อซฺ่า เย. ");
INSERT INTO bzi_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","เปโตร นี้แม้แน จี่ เย “ม้องน้าม นอง เวอ, พระคัมภีร์ โย้เวอ อางเลิ่ง มอ ยาว แต้ม ชี ชี แฮ้ย่า ม้าม้า ย้าเป ตอล้า ชี, ค้าแต้ โย้เวอ อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ก่าซ้าด ดาวิด นา ไจ จี่ ปี่ ชี่ แฮ้งแม้แน ย้าเป. อางเลิ่ง แฮ้, ยูดาส ชฺ้าง แฮ้อือนา ซฺื่ย พระเยซู นา ชู แล ชี แฮ้งย้า. ");
INSERT INTO bzi_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ยูดาส ย่า กงูมู นู้เวอ ชฺ้าง ทื่อม่าง มาง แน ยา กงูก้อง ทื่งกง่า ย้า ล่ากาน ว่า แง.” ");
INSERT INTO bzi_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(ยูดาส พระเยซู นา ก่อง ยาว พลู้ กงา ชี แฮ้ง นื้งชฺ่าตี วื้อ แล ชี. ยาว นื้งชฺ่าตี แฮ้มาง ก้อง ย้า เลิง แล่ชี่. ยาว อางตู่ แฮ้ง นื้งชฺ่า โย้เวอ ชืก แล่ชี่. ยาว ป่องปอง ปล่าก อางอู้ ย่าง อ่อก ซฺี้ กาชี. ");
INSERT INTO bzi_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","นี้เลิ่ง เยรูซาเล็ม อางเมิง โย้เวอ จ่อด ย้า แบ คูแง. ยองมู นี้ ยอง ค่อง ต่าง แฮ้ง นื้งชฺ่าตี นี้ มางนา อาเคลดามา แน ฮ้าว เย, “นื้งชฺ่าตี ซฺี่” แน ฮา แง.) ");
INSERT INTO bzi_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","เปโตร จี่ แลน แล่ ชี นี้แม้แน, “นี้เลิ่ง ก่าซ้าด ดาวิด มอ ยาว สดุดี ปาบ โย้เวอ แต้ม ชี ญา นี้แม้แน, ‘ยาง ตี ดื้งย้า แฮ้ง ทืงตาน ปี่ โว. อ่าซ่าง มาง บ่าอ่อง ดื้ง แล โจ’ ‘ฮากนา ยาง ล่ากาน แฮ้ง ว่า แต่น ปี่ โว.’ ");
INSERT INTO bzi_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“นี้แม้แนยาว กงู จามปีน ย้า ค่าพ่าย่า ทื่อม่าง แช้ยู้ ยาว ยูดาส นา ศิษย์เอก เพล่อ แต่น ปี่ง. จ้า ชฺ้าง แฮ้ม้า กงู พระเยซู นา เค่ กว่า เมอ กงูก้อง กูเทอ แน ดื้ง ชี มาง ย้าเป. ");
INSERT INTO bzi_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ยา ยอห์น ล้างตือพิธีบัพติศมา ฮาย ปี่ เมอ จาย พาจาว มาง พระเยซู นา มู่งท่า โย้เวอ ซฺื่ยแล แฮ้นืง เคอ แน กงู ก้อง จา มาง. ชฺ้าง นี้ม้า กงูก้อง ทื่งกง่า แน พี่ญ่าน กงาเพล่อ แง. ฮากนา ม่ายแบ ปี่ง พระเยซู ซฺี้ ยาว ม้าม้า แน แต่ล้า แล่ชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","นี้งเย่ ยองมู ย้าง ค่าพ่าย่า 2 คู่น อางเม้ง โยเซฟ แน มัทธีอัส เย่ดนา แช้ยู้ ชี. (โยเซฟ เมอ อางเม้ง จา แล่ง บารซับบาส แน ยุสทัส แน.) ");
INSERT INTO bzi_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ยาว ยอง อธิษฐาน ฮา คูชี นี้แม้แน, “จี่วีดอางซื้ง เวอ, นา ชฺ้าง คาโคลาโค อือ นืงบา แฮ้งนา อางแบ แม่นแม่น ย้า. กงูนา ฮายมย้าง ปี่ ล่าปาว ชฺ้าง 2 คู่น นี้ เย่ดนา ล้อมางนา แช้ยู้ ศิษย์เอก เพล่อ ปี่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ยูดาส นา ล่ากาน ว่าย ศิษย์เอก เพล่อ แต่น ปี่ง น้อ. ยูดาส ย่า ยาง ล่ากาน ย่าง วี ยาว ยาง ตี ดื้งย้า ซูม แน ชี่ โย้เวอ ดื้ง แล ชี มาง ย้า.” ");
INSERT INTO bzi_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ยาว ยอง เบอจอก ลางกา ชีเย. ยาว มัทธีอัส อางเม้ง แฮ้ง ชู กงา ชีเย. ยาว นี้งเย่ มัทธีอัส นา ศิษย์เอก 11 คู่น อือก้อง คาตา แน ศิษย์เอก เพล่อ ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","เพ็นเทคอสต์ ป่อยนืง เคิน ยาว พระเยซู ศิษย์ อืม ตี ทื่อตี เวอ ช้อน ลางกา ชี. ");
INSERT INTO bzi_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ทื่อชี่ดยาว มู่งท่า ป่ากย่า ฮ้างม้าน อางแล่ง, อางเซง แม้แน ยอง ยู้ม ดื้ง จา โย้เวอ จ่อด ย้า บื้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ยาว ยองมือ ม้างม้าเจ้อ บี่ท่อ แม้แน มย้าง ชีเย. ยอง อางตู่ ท่า อือเมอ ล่อย กว่า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ยาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ยอง อางโต เวอ ปลื้ง ย้า ดื้ง ชี. ยาว ยองมู คาโคลาโค ย่าง มือ จี่ต่างบ่ากย่ากางซื้ง อือ จี่ คู ชีเย, อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง จี่ ปี่ง แฮ้ม้อก ล่อ เย่. ");
INSERT INTO bzi_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","แฮ้ญ่ามเมอ ยิวชฺ้าง พาจาว มางนา นืงบาชี ชี อือ ชฺ้างอางเมิง คล้าว นู้เวอ กูต่องกูตี่ แน จายล้า คูชี อืม, เยรูซาเล็ม อางเมิง โย้เวอ จา คูงเย. ");
INSERT INTO bzi_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","อางเซง บื้ง นา กงากย่า ยาว ฮู ล้า คู ชีเย. พระเยซู ศิษย์ อือ ยอง จี่ต่าง อือ จี่ นา กงากย่า คูยาว. ยองมือ นืงบาม่าน คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ยองมู ย่างมือ นาบาตา ย้า บลื่ง คูชี แน นี้แม้แน จี่ คูแง, “ชฺ้าง นี้มู กาลิลีชฺ้าง แอ่นญา อ่าลา? ");
INSERT INTO bzi_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ยาว บ้าเจอ กงูมู นี้ย่า กงู ค่อง เวอ จี่ต่าง จี่ กางอือ ยอง จี่ กางนา อางกย่า แน? ");
INSERT INTO bzi_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","จี่ต่าง นี้ย่า อางเมิง นี้อือ จี่ต่าง เย, ปารเทีย, มีเดีย, เอลาม, เมโสโปเตเมีย, ยูเดีย, คัปปาโดเซีย, ปอนทัส, เอเชีย, ");
INSERT INTO bzi_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ฟรีเจีย, ปัมฟีเลีย, อียิปต์ แน จี่ต่าง ทื่อบ่า, ลิเบีย, ไซรีน อางเมิง อางแท้ อือเมอ จี่ต่าง อือ เย, แน โรม อางเมิง โย้เวอ ชฺ้าง จายลือ ชี อือ จี่ต่าง เย. ");
INSERT INTO bzi_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(ตื่ง เกิ้ด ลือ เมอ จาย ยิวชฺ้าง เพล่อ ชี อือ แน ชฺ้าง น่องเวอ ยิว อางลี้บอางล่าว นาบทื้อ คูชี อือ) เกาะ ครีต เวอ จี่ต่าง แน อาระเบีย จี่ต่าง อือ. ยาว กงู คาโคลาโค ย่าง มือ, ชฺ้าง นี้อือ พาจาว มาง อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ชี อือ จี่เคอ นา กงากย่า แอ. ยาว ยอ กงู ค่อง เวอ จี่ต่าง แฮ้งญา ม่าอู่บ คู แง.” ");
INSERT INTO bzi_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ชฺ้าง คาโคลาโค อือ นืงบาม่าน โค ชี ยาว น้า กางเย นี้แม้แน, “นี้ บ้าเจอ เวอ” แน. ");
INSERT INTO bzi_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ชฺ้าง ทื่อบ่า จา ชีเย พระเยซู ศิษย์ อือนา อื้อกาน ยาว จี่ คูง เย นี้แม้แน, “ชฺ้าง นี้มู อ่างู่น แต่ค่า ม่าว ชี นาตู้.” ");
INSERT INTO bzi_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ยาว เปโตร แน ศิษย์เอก 11 คู่น อือ ทาจูง ล้า โค ชี. เปโตร ชฺ้าง แฮ้มู ล้าก้า โย้เวอ อางเซง บื้ง แน จี่ เย นี้แม้แน, “ยิวชฺ้าง ม้องน้าม แน ชฺ้าง คาโคลาโค เยรูซาเล็ม อางเมิง นู้ดื้ง อือ เวอ, กงา อางเลิ่ง ชา อู่บ นี้ง แม่น แน น้า คู ปาว เป. ");
INSERT INTO bzi_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ชฺ้าง นี้มู นอง เย้ง แม้แน แต่ค่า บ่าม่าว, อามืม ซอทา 9 โมง ญา. ");
INSERT INTO bzi_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","จ้า นอง มย้าง คูชี นี้ย่า ค้าแต้ โย้เวอ โยเอล พาจาวจี่ต่างจี่แต่นฮู แฮ้มาง มอ ชี ชีย้าง แม้แน ย้า นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘พาจาว มาง จี่ แง ชฺ้างอางเมิง นู้เวอ อางญ่าม ต่องลีน เคอ เมอ. กงา อางค่องอางล้า อางเซฺิ่งอางซฺ้าง นี้ง ชฺ้าง คาโคลาโค อือนา ปี่ แง. ตื่ง นอง อางย่าย่าค่า อางย่าย่าบี่ กงานา จี่แต่น ล่า คูแง. ชฺ้าง ค่าพ่าย่า อางนู่มกาม อือ แมบืน แม้แน, กงา ยองนา มย้าง ปี่ ซี่ อือ กงามย้าง แง. ย่าม่าง อือ แมบืน บืน มย้าง แฮ้ง ทื่อช่างกานญา กงาก้อง จายลือ แง. ");
INSERT INTO bzi_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","แฮ้ญ่ามเมอ กงา ค่าตอง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง นี้ง, กงา ย่าเจ่น อือนา ปี่ แง, ตื่ง ค่าพ่าย่า แน ค่าบาย่า ย้า. ยาว ยองมู นี้ง กงานา จี่แต่น ล่า คูแง. ");
INSERT INTO bzi_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","กงา มู่งท่า แน ชฺ้างอางเมิง เวอ อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮายฮู ปี่ ล่าแน. แฮ้ย่า ซฺี่ แน บี่ท่อ บี่ค่าว อางปล้าง วื้งว้างทูม แน ฮาย ตอล้า ปี่ง อือ. ");
INSERT INTO bzi_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","พาจาว มาง ชฺ้างอางเมิง เวอ ชา ต้าดต่อน ลือ เมอ มู่งนื่ง นี้ย่า ปล้าง ย้า วื้งว้าง แง. อู่ลา นี้ แน้ ล้า แง ซฺี่ แม้แน. ");
INSERT INTO bzi_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ยาว ชฺ้าง คาโคลาโค จี่วีดอางซื้ง มางนา ฮ้าว ปล่อง ปี่ อือ จี่วีดกงาปูน แล่ง.’ ");
INSERT INTO bzi_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“อิสราเอลชฺ้าง นอง เวอ, แม่น แน น้า คู ปาว. พาจาว ม้า นองนา เจ้ง ย้า ฮายมย้าง ปี่ ล่าง. นี้แม้แน พระเยซู นาซาเร็ธชฺ้าง นี้ม้าย่า พาจาว มาง ล่าที่ ปี่ ชี, ยา นองนา อางเลิ่งชฺ้างบ่าฮาตอกางอือ อางบย่า ย้า ฮาย ปี่ ล่าง, นองมู กงาแบ กงามย้าง ชีแฮ้งแม้แน ย้า. ");
INSERT INTO bzi_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","พาจาว ม้า เย้ง ชี ลางออน ฮาย ญา, พระเยซู นา นองนา ปี่ ล่าง แน. ยาว นอย่า ชฺ้าง พาจาว นา บ่าเจ่อ อือนา ม่าย พระเยซู นา ไม้กางเขน เวอ ตื่อตี้ด แซ่ ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","จ้า พาจาว ม้า พระเยซู นา อางซฺื่อ แต่ล้า แล่ ปี่ง. ยา บ่าซฺี่ แล่ก้าน ซฺี้ อางเลิ่ง นี้ย่า พระเยซู นา บ่าก่าจ่า กงา กาเย.” ");
INSERT INTO bzi_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“ก่าซ้าด ดาวิด มาง พระเยซู นา จี่เคอ แง นี้แม้แน, ‘จี่วีดอางซื้ง ม้า กงาก้อง กูญ่าม ย้า ดื้ง แง. ยา กงา ล่าปู่ ล่าม่า นู้ ย้า ดื้ง แง. นี้แม้แนยาว กงา เจิ้นเจ้อ นา บ่าแค. ");
INSERT INTO bzi_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ยาว กงา นืงบาต่องม่อนซ้า แง. แน จี่วีดอางซื้ง มางนา สรรเสริญ ฮา แง. กงา อางโต นี้ย่า ซฺี้ เวิมมือ จี่วีดอางซื้ง มางนา นืงบาแก่นไจ่จา แง. ");
INSERT INTO bzi_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","จี่วีดอางซื้ง เวอ, นาย่า กงา อางค่องอางล้า มางนา ล่าลูก เวอ บ่าวีบ่าจาน ล่า. แน นา ชฺ้าง อางเซฺิ่งอางซฺ้าง ซฺี้ ชี อือนา บ่าปี่ ปู่ แน แต่ล้า แล่ ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","นาย่า กงานา ฮาย จี่วีดแก้บ้า แฮ้ง แบ ปี่ ล่าง. แน นาง กงาก้อง กูญ่าม แน ดื้ง เมอ นาย่า กงานา นาบาตา ย้า ฮาย จาบื่อดื้งบื้อ แน จา ปี่ ล่าง.’ ");
INSERT INTO bzi_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ม้องน้าม นอง เวอ, ม้าม้า นี้ย่า ก่าซ้าด ดาวิด กงู อางเจ้อ ซื้บลือ ชี นี้ม้า ค่าตอง อางโต นา บ่ากงา จี่ เคอ จ่าแล่. ยา ซฺี้ แอ้นญา แน ท้ามชฺ้างซฺี้ชีย้า ยางนา ชี ชี ย้าง, เยรูซาเล็ม อางเมิง นู้เวอ อามื้อ เคอ ย้า จา แง. ");
INSERT INTO bzi_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","จ้า ก่าซ้าด ดาวิด ยา พาจาวจี่ต่างจี่แต่นฮู ทื่อม่าง ม้าง ย้า. แน ยา อางแบ ย้า พาจาว มาง ก่ามค่าน ปี่ ชี่นี้ นี้แม้แน. ยาง อางย่าอางคย้า อางอ่านอางซฺื้อ มู นู้เวอ ชฺ้าง ทื่อม่าง จา แง, ยาง แม้แน ก่าซ้าด กงา เพล่อ แง. ");
INSERT INTO bzi_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ยาว นี้เลิ่ง ก่าซ้าด ดาวิด ย่า แบน ญา. ยา พระเยซู มาง ซฺี้ ยาว แต่ล้า แล่ อางเลิ่ง นา จี่ เคอ แง นี้แม้แน,” “ยางนา ล่าลูก เวอ บ่ากงา วี บ่ากงา จาน ชีช่า. แน ยาง อางโต แฮ้ง บ่าปู่.” ");
INSERT INTO bzi_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“พาจาว ม้า พระเยซู นา อางซฺื่อ แต่ล้า แล่ ปี่ ชี่. กงูมู คาโคลาโค นี้ง อางมย้าง ย้า. ");
INSERT INTO bzi_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","พระเยซู นา พาจาว มาง ซฺื่ยแล ยาง ล่าปู่ ล่าม่า ป่ากย่า ดื้ง ปี่ชี่. ยาว พาจาว มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง พระเยซู นา ปี่ ชี, ยาง ก่ามค่าน ปี่ ชี ชี แม้แน. ยาว พระเยซู อางค่องอางล้า นี้ง กงูนา ปี่ ล่าง. อามื้อ นองมู กงากย่า กงามย้าง ชี นี้ง แม้แนย้า. ");
INSERT INTO bzi_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ก่าซ้าด ดาวิด ยา มู่งท่า โย้เวอ บ่าแล กางซื้ง เย่, จ้า ยา จี่ แง นี้แม้แน, ‘พาจาว ม้า ยาง ชฺ้าง แช้ยู้ ยาว ชฺ้างอางเมิง นู้เวอ ก่าซ้าด เพล่อ ลือ ปี่ชี่ แฮ้มางนา แน กงา จี่วีดอางซื้ง เพล่อ ชี มางนา นี้แม้แน จี่ช่าง ชี, กงา ล่าปู่ ล่าม่า นี้กย้า ดื้ง ลื่อ ปาโน ");
INSERT INTO bzi_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","กงา ชฺ้าง นางนา เม้อ ล่าง อือนา ฮาย นาง ล่าคื่อโบ้ยย้า เพล่อ ปี่ เมอ ตื่อเคอ แน.’ ");
INSERT INTO bzi_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“แฮ้แม้ยาว อิสราเอลชฺ้าง อือ เวอ, แบ ชี คู โว พาจาว ม้า พระเยซู นอง ไม้กางเขน เวอ ตื่อตี้ด ชี มางนา จี่วีดอางซื้ง แน ก่าซ้าด เพล่อ ปี่ ชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ชฺ้าง แฮ้มู มือ นี้แม้แน กงากย่า ยาว นืงบาชู่ม ชีเย. นี้งเย่ ยองมู ย่าง มือ เปโตร แน ศิษย์เอก ทื่อบ่า อือนา จี่ช่าง ชี นี้แม้แน, “ม้องน้าม นอง เวอ กงูมู นี้ ล้อแม้ ฮา แน?” ");
INSERT INTO bzi_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","เปโตร ยองนา นี้แม้แน จี่ช่าง ชีเย, “นืงบา อางซฺื่อ เพ่น แล่ยาว พระเยซู อางเม้ง นู้ ล้างตือพิธีบัพติศมา ฮาย ปาว. ยาว พาจาว มาง นอง อางซีอางบล่าบ แฮ้ง ปล่องปูน ปี่ ล่าง. ยาว นองมู นี้ง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง กงาบู้ แง. ");
INSERT INTO bzi_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","พาจาว ม้า ก่ามค่าน ฮา ชี ป้าน่อ, นี้อือเจ้อ นองมู นา ปี่ ล่าง. นอง อางย่าอางคย้า อางอ่านอางซฺื้อ แน ชฺ้าง คาโคลาโค อางเว่อ ดื้ง อือนา คาตา แน ปี่ แง. แน อางค่องอางล้า อางเซฺิ่งอางซฺ้าง นี้ย่า ชฺ้าง คาโคลาโค จี่วีดอางซื้ง กงู พาจาว มาง แช้ยู้ ชี อือนา ชี ปี่ แง.” ");
INSERT INTO bzi_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ยาว เปโตร ยองนา อางเลิ่ง อางบย่า เย ม่ายอู่บ ยาว ยองนา ป้า ชี นี้แม้แน, “อามื้อ ชฺ้าง บ่าแม่น อือก้อง ค่าตอง อางโต แฮ้ง ปล่องปูน แล่ว.” ");
INSERT INTO bzi_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ชฺ้างมู เปโตร จี่ ชี่ แฮ้งนา อางน้า อือ ล้างตือพิธีบัพติศมา ฮา แล่ คู ชีเย. แน แฮ้นืง ชฺ้าง พระเยซู นา เจ่อ ชี แฮ้ 3,000 คู่น แฮ้ล่อซฺ่า เย. ");
INSERT INTO bzi_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ยองมู นี้ย่า ศิษย์เอก อือ ม่าอู่บ เมอ ปีนแตปีนนา ย้า น้า คูง. แน พระเยซู นา ปื้อซฺ้า พิธี แฮ้ง ปีนแตปีนนา ย้า ฮา แง. ");
INSERT INTO bzi_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ชฺ้าง คาโคลาโค พระเยซู นา เจ่อ คูชี อือ บลื่ง คู ชีเย, ไม้ ศิษย์เอก มู อือ อางเลิ่งชฺ้างบ่าฮาตอกางอือ ไลย่างไลเจ้อ ย้า ฮา ชี. ");
INSERT INTO bzi_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","แน ยอย่า อางเลิ้ง กาย้า มย้าง กาแง. แน ยอง เมอ อางเกิ่งอางก้อ ค้าจา แฮ้ง เปิ่ง ปี่ กาแง. ");
INSERT INTO bzi_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ยองมู นี้ นื้งชฺ่าตี แน อางเกิ่งอางก้อ อือ ก่อง แอ ชีเย. ยาว พลู้ กงา ชี แฮ้ง ชฺ้าง พลู้ กงาไจ อือนา ปี่ แอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ยองมู นี้ย่า กูนืง ย้า โบสถ์อางฮื่อ โย้เวอ ประชุม ฮา กางแง. แน ยอ ม่อนซ้า ยู้ม อือเมอ ทื่งกง่า แน จฺ่าต้าง คูง แง. ");
INSERT INTO bzi_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ยองมู นี้ย่า พาจาว มางนา สรรเสริญ ฮา เย. แน ชฺ้าง คาโคลาโค อือ ยองนา ซอ เย. แน จี่วีดอางซื้ง มาง ชฺ้าง ยาง ปล่องปูน ปี่ชี่ อือนา กูนืง ย้าเย่ ฮาย บย่า เค่ ปี่ง. นี้แม้แนยาว ชฺ้าง พระเยซู นา เจ่อ อืม บย่า ล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ทื่อนืง จา แง 3 โมง มู่งคี่ล้าก้า ล่อซฺ่า นี้งย้า. แฮ้ญ่าม เวอ อธิษฐาน ฮา ญ่าม เย, เปโตร แน ยอห์น เย่ด โบสถ์อางฮื่อ โย้เวอ แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ยาว ค่าพ่าย่า ทื่อม่าง จา แง ยา เกิ้ดเมอจาย ย้าเย่ ต่องแก่. ยาว ชฺ้าง ต่องแก่ นี้มาง นา ฮาก กูนืง ย้า ยางนา โบสถ์อางฮื่อ ก้ามทื้อ ล้องก้อ โย้เวอ อาม ชี ล้า แง. ยา ชฺ้าง โบสถ์ นี้มาง ก้อง อ้องล้า อือนา พลู้ ล่อ ป้า แง. ล้องก้อ ยาง ดื้ง แฮ้ย่า ล้องก้อ อางมาง แน ฮ้าว เย. ");
INSERT INTO bzi_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ยาว ค่าพ่าย่า นี้มาง เปโตร แน ยอห์น เย่ด ย่อ อ้องล้า นา มย้าง ชีเย. แฮ้งเย่ ยาง มือ ฮ้าว พลู้ ป้า ชี. ");
INSERT INTO bzi_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","เปโตร แน ยอห์น เย่ด มือ ค่าพ่าย่า นี้มาง ก้อง ฮู แอ ปี่ ยาว จี่ ชีเย นี้แม้แน, “ไกง้นา ฮู ล่าว เป.” ");
INSERT INTO bzi_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ค่าพ่าย่า พลู้ ป้า มางมือ ชฺ้าง 2 คู่น ม่าง เย่ด ก้อง ฮู แล ปี่ ชี่ เย. ยา เย้ง เย เย่ด ก้อง พลู้ อางกงา ย้า แน. ");
INSERT INTO bzi_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","จ้า เปโตร นี้แม้แน จี่ เย, “กงาก้อง ค่าม พลู้ บ่าจา เป. จ้า กงา ปี่ ล่าง นี้ย่า พระเยซูคริสต์ นาซาเร็ธชฺ้าง มาง กงานา ล่าที่ ปี่ จี่ ปี่ ล่าง แฮ้งย้า นี้แม้แน, ซฺ้อก แน ทาจูง ล้า โว!” ");
INSERT INTO bzi_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ยาว เปโตร มือ ค่าพ่าย่า แฮ้มาง ล่าปู่ ล่าม่า เวอ ชู ทาน ล้า ปี่ ชี่ เย. ยาว ค่าพ่าย่า มาง ล่าคื่อ ย้างมือ แฮ่ง จา ล้า ชี เย. ");
INSERT INTO bzi_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ยาว ยางมือ โบสถ์อางฮื่อ กองโค้ง เวอ กย่าง เปิก อ้องแล พาจาว มางนา สรรเสริญ ฮา แล ชี. เปโตร แน ยอห์น เย่ด ก้อง ทื่งกง่า แน. ");
INSERT INTO bzi_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ชฺ้าง คาโคลาโค อือ ชฺ้าง ต่องแก่ โปยว ชี มาง, ย่อ พาจาว มางนา สรรเสริญ ฮา แฮ้งนา มย้าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ชฺ้าง คาโคลาโค อืม อางจาม กงา กาเย. ยา ล้องก้อ อางมาง โย้เวอ ค่าพ่าย่า พลู้ ดื้ง ป้า มาง แน. ยอง มือ นาบาตา เย บลื่ง คู ชี, ยาว ค่าพ่าย่า นี้มาง ก้อง บ้าเจอ ตอล้า ชี แน เย้ง คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ค่าพ่าย่า นี้ม้า โบสถ์อางฮื่อ ตางเก้อ อางเม้ง โซโลมอน โย้เวอ, เปโตร แน ยอห์น เย่ด ก้อง ชู เค่ ชี. ยาว ค่องช่าง คาโคลาโค อืม มย้าง คูยาว นืงบาม่าน ฮื่น ฮู ล้า คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","เปโตร แฮ้แม้ มย้าง ยาว ยองนา นี้แม้แน จี่ช่าง ชีเย, “อิสราเอลชฺ้าง เวอ นองมู นี้ บ้าเจอฮา นี้เลิ่ง นา นืงบาม่าน คูแง. บ้าเจอฮา ไกง้นา ฮู ล่าง. ไกง้ ล่าที่ นี้ง ฮาย ค่าพ่าย่า นี้มางนา ย่อ ตอ กา ปี่ชี่ ช้อด แน. ");
INSERT INTO bzi_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","อับราฮัม อิสอัค แน ยาโคบ ยอง พาจาว ม้า กงู อ่าฮู้ อ่าพี้ อือ พาจาว มาง ย้า. แน พาจาว นี้มาง ย้า พระเยซู ยาง ย่าเจ่น ม่าง ล่าที่ อางฮื่อ แฮ้ง กงูนา ฮา มย้าง ปี่ ล่าแง. พระเยซู นี้มาง ย้า นอง ฮากนา ตอย แซ่ ปี่ชี่ ม้า. ยาว นอง ย้า ยาง ผู้ว่า ปีลาต ล้าก้า โย้ จา เมอ ยางนา บ่าตื่อยู่ กาง อือ, ผู้ว่า ปีลาต ต้าดต่อน ยางนา ตอย เวิม มือ. ");
INSERT INTO bzi_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","นอ พระเยซู อางเซฺิ่งอางซฺ้าง อางกง่าอางเกิง นี้มาง นา บ่าตื่อยู่ คู. จ้า นอ ปีลาต นา ป้า, ชฺ้าง ฮากนา แซ่ ชี มางนา ตอ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","นองมู นี้ย่า ชฺ้าง จี่วีดม้าม้า ปี่ อางกงา มางนา แซ่ ชี. จ้า พาจาว ม้า ยางนา อางซฺื่อ แต่ล้า แล่ ปี่ชี่. ไกง้ นี้เลิ่ง นา พี่ญ่าน เพล่อ อางกงา ย้า. ");
INSERT INTO bzi_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ค่าพ่าย่า ต่องแก่ นี้มาง ย่อตอ กา ชี นี้ย่า กงู พระเยซู ล่าที่ แฮ้งนา เจ่อ แฮ้ง ปาปาย ย้า. ยาว นองมู นี้ง กงามย้าง ญา แน ยางนา อางแบกงากา ย้า. ยาว ยาง ต่องแก่ โปยว ชี่ นี้ย่า กงู พระเยซู ล่าที่ แฮ้งนา เจ่อ ชีง ปาปาย ย้า.” ");
INSERT INTO bzi_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ม้องน้าม นอง เวอ, กงา อางแบ ย้า นองมู แน ชฺ้าง ยอคา เพล่อ คู ชีอือ พระเยซู นา แฮ้แม้แน ฮา คูชี แฮ้ย่า. จ้า นอ บ่าแบ คู นอ บ้าเจอ ฮา คู ชีแน. ");
INSERT INTO bzi_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","จ้า พาจาว ม้า นี้เลิ่ง นา จี่ ชี ลางออน ฮาย ญา. ยา ชฺ้าง พาจาวจี่ต่างจี่แต่นฮู อือนา นี้แม้แน มอ ชี ปี่ชี่, พาจาว มาง แช้ยู้ ก่าซ้าด เพล่อ ปี่ชี่ ม้า อางตูกอางพาน กงา โอ่ด ลาบ้าบ แง. ยาว อามื้อ พาจาว มาง ม้าม้า ย้า ฮาย ตอล้า ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","นี้แม้แนยาว นองมู นี้ย่า นืงบาเพ่น อางบล่าบ ฮา แฮ้ง ว่าง คู ปาว. ยาว พาจาว มางนา ซฺ้า ล้า ปาว, ไม้ พาจาว มางนา นองนา อางบล่าบ ปล่องปูน ปี่ ล่าง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ยาว พาจาว ม้า นองมู นี้งนา ฮาย นืงบาต่องม่อนซ้า ปี่ ล่าง. พาจาว ม้า พระเยซู ยาง แช้ ก่าซ้าด เพล่อ ปี่ชี่ มางนา ชฺ้างอางเมิง นู้เวอ ทื่อเทอ ซฺาลือ ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","อามื้อ พระเยซูคริสต์ มู่งท่า โย้เวอ ดื้ง เปิน แง. พาจาว มาง กูย่างกูเจ้อ อือ อางซฺื่อ แต่ง เปิน เมอ ตื่อเคอ. ค้าแต้ โย้เวอ พาจาว มาง พาจาวจี่ต่างจี่แต่นฮู อือนา ก่ามค่าน ปี่ ชี่ แฮ้งแม้แน. ");
INSERT INTO bzi_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ค้าแต้ โย้เวอ โมเสส พระเยซู อางเลิ่ง แฮ้ง มอ ชี ชี, ‘จ้างจ้าง เวอ พาจาว ม้า กงา แม้แน พาจาวจี่ต่างจี่แต่นฮู ซฺาลือ ปี่ ยาว นองนา ปี่ ล่าง. พาจาวจี่ต่างจี่แต่นฮู นี้ม้า นอง ม้องน้าม อือก้อง จายล้า แง. นอ กูเจ้อ ย้า ยาง ม่า ล่าง อือ กงาน้าจ่าง. ");
INSERT INTO bzi_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","อ่าซ่าง พาจาวจี่ต่างจี่แต่นฮู นี้ มางนา บ่าน่าจ่า แง กงา ซฺี้ แง เป. แน ยา พาจาว มาง ชฺ้าง บ่ากงา เพล่อ กาน.’ ");
INSERT INTO bzi_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“ทื่อช่างกานญา ซามูเอล แน พาจาวจี่ต่างจี่แต่นฮู น่อง เวอ ลือ ชี อืม พระเยซู อางเลิ่ง นี้ง มอ คูแง. ");
INSERT INTO bzi_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","นองมู นี้ ชฺ้าง พาจาวจี่ต่างจี่แต่นฮู นี้อือ อางอ่านอางซฺื้อ เป. แน พาจาว มาง นอง อางฮู่ อางพี่ อือนา ก่ามค่าน ปี่ ชี ชี แฮ้ง นอง คาตา ย้า กงาบู้ แง. พาจาว ม้าย่า อับราฮัม นา นี้แม้ จี่ช่าง ชี่, ‘ชฺ้างอางเมิง นู้เวอ ชฺ้าง กูเจ้อกูจาด นี้ย่า นาง อางอ่านอางซฺื้อ ทื่อม่าง มาง ปาปาย ก่ามป่อน กงาบู้ คูแง.’ ");
INSERT INTO bzi_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","พาจาว ม้าย่า พระเยซู นา แช้ยู้ ยาว ยาง ย่าเจ่น เพล่อ ปี่ชี่. ยาว ยางนา นองมู อิสราเอลชฺ้าง เพล่อ ชี อือก้อง ซฺาลือ ปี่ง ญา, ไม้ นองนา ก่ามป่อน ปี่ ล่ายาว นอง อางเลิ่ง บ่าแม่น แฮ้ง วี ปี่ ล่าง.” ");
INSERT INTO bzi_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","เปโตร แน ยอห์น เย่ด ชฺ้าง อางบย่า อือนา ม่าอู่บ จา เมอ. ยาว ปุโรหิต มู อือ แน ตาฮ้าน โบสถ์อางฮื่อ ฮูพลาฮู ยอคา มาง แน สะดูสี มู อือ เย่ด ก้อง ย่อ อ้องล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ยองมู นี้ย่า เปโตร แน ยอห์น เย่ดนา นาบาตา เย นืงบาค่า แง. ไม้ เปโตร แน ยอห์น เย่ด ชฺ้าง อือนา ม่าอู่บ ชี, ชฺ้าง อือ พระเยซู แม้แน ซฺี้ ยาว แต่ล้า แล่ง. ");
INSERT INTO bzi_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","แฮ้เมอ มู่งคี่ล้าก้า เย. ยองมู ย่าง เย่ดนา คอก เวอ ชู ล้อง ชี ซอทา แปล้น เมอ เคอ เย่. ");
INSERT INTO bzi_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","จ้า ชฺ้าง อางบย่า เย่ เย่ด ม่าอู่บ แฮ้งนา เจ่อ คูง. อามื้อ ชฺ้าง พระเยซู นา เจ่อ ชี นี้ย่า ค่าพ่าย่า 5,000 คู่น ล่อซฺ่า เย. ");
INSERT INTO bzi_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ซอทา แปล้น ล้า ยาว ยิวชฺ้าง ยอคา แน ย่าม่างยอคา อางลี้บอางล่าว ม่าอู่บฮู อือ. เยรูซาเล็ม อางเมิง โย้เวอ ลือ ประชุม ฮา ลางกา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","แน ยาว ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น อางเม้ง อันนาส, คายาฟาส, ยอห์น, อเล็กซานเดอร์ แน ชฺ้าง ทื่อบ่า ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง ยู้มชฺ้าง อือนา คาตา ย้า ประชุม อ้อง ฮา แล ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ยองมู นี้ย่า เปโตร แน ยอห์น เย่ดนา ยอง ล้าก้า โย้เวอ จูง ปี่ ยาว นี้แม้แน น้า ชีเย, “ไน้ ชฺ้าง ต่องแก่ มางนา ยา โปยว ปี่ ชี่นี้ บ้าเจอ ล่าที่ แฮ้ง ไจ แง? แน อ่าซ่าง ล่าที่ ย่าง เวอ?” ");
INSERT INTO bzi_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ยาว เปโตร อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ปลื้ง แน จา ชี มาง ยองนา นี้แม้แน พอ ชีเย, “ค่องช่าง ยอคา อือ แน ย่าม่างยอคา มู เวอ, ");
INSERT INTO bzi_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","นองมู นี้ย่า ไกง้นา น้า ล่าง, ไกง้ ชฺ้าง ต่องแก่ มางนา อางเลิ่ง อางแม่น ฮา ปี่ ชี่ นี้ง, ยางนา ล้อแม้ ยา โปยว ปี่ แอ แน. ");
INSERT INTO bzi_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","นองมู คาโคลาโค แน อิสราเอลชฺ้าง คาโคลาโค อือ เวอ แบ ชี คู โว, อางเลิ่ง ตอล้า ชี นี้ย่า พระเยซูคริสต์ นาซาเร็ธชฺ้าง มาง ล่าที่ แฮ้ง ปาปาย แน เป. ยา นอง ไม้กางเขน ท่า โย้เวอ ตื่อตี้ด ชี มาง ย้า. แน ยา ซฺี้ คายาว พาจาว มาง อางซฺื่อ ฮาย แต่ล้า แล่ ปี่ ชี่ มาง ย้า. พระเยซู นี้มาง ย้า, ค่าพ่าย่า นี้มางนา ต่องแก่ ยา โปยว ปี่ ชี่ ม้าย่า. ");
INSERT INTO bzi_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","พระเยซู อางเลิ่ง นี้ย่า พาจาวจี่ต่างจี่แต่นฮู ทื่อม่าง, มอ ยาว พระคัมภีร์ เวอ แต้มเพ้กกาน ชี นี้แม้แน, ‘ยู้ม ซ้าล้า อือ ยู้มยื้ง วี ชี นี้ยื้ง น่อง โย้เวอ เสาเอก เพลิ่น ล้า ชี.’ ");
INSERT INTO bzi_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“ชฺ้างอางเมิง นู้เวอ อ่าซ่าง มาง บ่าจา กาน ชฺ้าง อือนา ล่าลูก เวอ อางปล่องปูน ปี่ กงากา แน. พระเยซู ทื่อม่าง ญา ชฺ้าง อือนา อางปล่องปูน ปี่ กงากา แน.” ");
INSERT INTO bzi_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ยิวชฺ้าง ยอคา อือ บลื่ง คู ชีเย, ยอ ฮู คูงเย เปโตร แน ยอห์น เย่ด ชฺ้าง อางแกงอางวอง แน. ยองมู นี้ย่า เย้ง คูงเย, เย่ด ค่องช่าง อางไล่ อางบย่า แน บ่าแบ อือ นาตู้ แน. ยาว ยองมู ย่าง เย้ง กงา แล่ ชีเย, เย่ด พระเยซู ก้อง อางเค่ กว่า กางซื้ง แน. ");
INSERT INTO bzi_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ยองมู ย้าง บ่าจี่ อ่อก กาเย. ยอ อางมย้าง เย, เปโตร แน ยอห์น เย่ด ม้าม้า ย้า เย่ ค่าพ่าย่า ต่องแก่ มางนา ยา โปยว ปี่ชี่ แน. ยาว ยาง เย่ด ก่องทาง โย้เวอ จูง ชี. ");
INSERT INTO bzi_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ยองมู ย่าง เปโตร แน ยอห์น เย่ดนา ม่า อ่อกแอ ปี่ ชี่. ยาว นี้แม้แน จี่ น้าท้าม ลางกา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“กงูมู นี้ย่า ชฺ้าง นี้เย่ดนา ล้อแม้ ฮา วา? ไม้ เยรูซาเล็ม อางเมิง นู้เวอ ชฺ้าง คาโคลาโค อือ แบ โค คูง ญา เป. เย่ด อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ชี แน. ยาว กงูมู นี้ อางมย้าง ย้าเป แน เจิ้นเจ้อ บ่าจี่ กงากา. ");
INSERT INTO bzi_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","จ้า ชฺ้าง อางบย่า อือนา นี้เลิ่ง นา บ่าปี่ แบ แล่ก้าน โจ. ยอง ม่า ลางกา ชี นี้แม้แนยาว เย่ดนา พระเยซู อางเม้ง นี้งนา บ่าปี่ จี่เคอ กาน โจ” แน. ");
INSERT INTO bzi_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","แฮ้แม้ฮายาว ยองมู ย่าง เปโตร แน ยอห์น เย่ดนา ฮ้าว ซฺ้า ล้า ปี่ชี่. เย่ดนา พระเยซู อางเลิ่ง แฮ้งนา บ่าปี่ม่าอู่บ แน พระเยซู อางเม้ง แฮ้งนา บ่าปี่ จี่ เคอ แล่ เย. ");
INSERT INTO bzi_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","จ้า เปโตร แน ยอห์น เย่ด นี้แม้แน จี่ พอ ชีเย, “นอง เย้ง ฮู แล่ คู ปาว เป, อางกง่าอางเกิง ลา? พาจาว มางนา บ่าน่าจ่า แน นองนา น้าจ่า ล่าง นี้ย่า? ");
INSERT INTO bzi_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ไกง้ย่า ไกง้ อางเลิ่ง กงากย่า กงามย้าง ชี นี้ง บ่าจี่ แน บ่าตอ เป.” ");
INSERT INTO bzi_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","แฮ้งเย่ ยิวชฺ้าง ยอคา อืม ยอห์น แน เปโตร เย่ดนา จี่แค ปี่ ยาว ตอย แอ ปี่ ชี่, ยอ บ่าแบ เย เปโตร แน ยอห์น เย่ดนา ล้อแม้ อางซี ต้าดต่อน แงแน. ไม้ ชฺ้าง คาโคลาโค อือ เย่ด อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ชี แฮ้ง, กงามย้าง คู ยาว พาจาว มางนา สรรเสริญ ฮาย คู ป้าน่อ. ");
INSERT INTO bzi_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ค่าพ่าย่า ต่องแก่ เปโตร แน ยอห์น เย่ด ยา โปยว ปี่ ชี่ นี้ม้า อ่าญู่ 40 ปี ล่อบ่าปา เย บย่า แง. ");
INSERT INTO bzi_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ยิวชฺ้าง ยอคา อือ เปโตร แน ยอนห์ เย่ดนา ตอ ยาว, เย่ด มือ ยอง อางมู อือนา พ่าว ซฺ้า แล ชีเย. ยาว อางเลิ่ง คาโคลาโค ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง แน ย่าม่างยอคา อือ, เย่ดนา อางเลิ่ง จี่ช่าง ชี แฮ้ง ยองนา อู่บน้า ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ชฺ้าง คาโคลาโค พระเยซู นา เจ่อ คูชี อือ แฮ้แม้ กงากย่า ยาว. ยองมู ย้าง ช้อนไก พาจาว มางนา อธิษฐาน ฮาย ป้า คู ชีเย นี้แม้แน, “จี่วีดอางซื้ง เวอ, นา มู่งท่า, ชฺ้างอางเมิง, ทะเล แน กูย่างกูเจ้อ แต่ง ชี มาง ย้า. ");
INSERT INTO bzi_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ยาว ก่าซ้าด ดาวิด ย่า นาง ย่าเจ่น เป แน ยา กงู อางฮู่ เป. นาย่า นาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง ไจ ก่าซ้าด ดาวิด นา จี่ ปี่ ชี่ นี้แม้แน. ‘บ้าเจอ ชฺ้าง อางเจ้ออางจาด ต่างไล นี้ย่า นืงบาอางค่า แน? บ้าเจอ ชฺ้าง อือย่า อางเลิ่ง อางจ่าง อือ อางเย้ง คูแน. ");
INSERT INTO bzi_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ชฺ้างอางเมิง นู้เวอ ก่าซ้าด อือ ช้อน กายาว รบ แอง แง. แน ยอคา มู อืม ช้อน กางแง. แน ยอย่า จี่วีดอางซื้ง มางนา แน พาจาว มาง ก่าซ้าด แช้ยู้ เพล่อ ปี่ ชี่ มางนา รบ ช่าง คูง แง.’ ");
INSERT INTO bzi_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“ยาว พระคัมภีร์ โย้เวอ อางเลิ่ง แต้ม ชี ชีย้าง ม้าม้า ย้า ตอล้า ชี. ก่าซ้าด เฮโรด แน ผู้ว่า ปอนทัส ปีลาต แน ยิวชฺ้างบ่าอ่า แน ยิวชฺ้าง อือ ช้อน กายาว พระเยซู นา ต่อต้าน ฮา คู ชีเย. พระเยซู นาง ย่าเจ่น อางเซฺิ่งอางซฺ้าง เพล่อ ชี่ มาง ย้า. นาย่า ยางนา แช้ยู้ ก่าซ้าด ต้างแต่ง เพล่อ ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","จ้า ม้าม้า นี้ย่า ชฺ้าง นี้อือ กูย่างกูเจ้อ ย้า ฮา ชี. นาง เย้ง ชี ลางออน เย้ง ชี แฮ้งแม้แน, อางเลิ่ง นี้แม้ ตอล้า แงแน. ยาว นี้ย่า นาง ล่าที่ แน นาง นืงบาจาบวา ย้า เพล่อ ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“จี่วีดอางซื้ง เวอ, ยิวชฺ้าง ยอคา อือ ยอง จี่ต่างก่ามแท้ กงูนา จี่แค ปี่ล่าง นี้ง น้า ปาโน. ยาว กงูมู นี้ย่า นาง ย่าเจ่น นี้แม้แนยาว กงูนา ปล่อง ล่าปาว, กงูนา เจิ้นเจ้อ นา บ่าแค แน นาง จี่ต่าง แฮ้ง จี่ ปี่ ล่าปาว. ");
INSERT INTO bzi_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","นาง ล่าปู่ แฮ้ง กลางอ่อก ลือ ปี่ ปาว. ยาว พระเยซู นาง ย่าเจ่น อางเซฺิ่งอางซฺ้าง มาง อางเม้ง แฮ้ง ไจ ชฺ้าง อางด้า อือนา พ่าญาด ยา โปยว ปี่ ปาว, แน อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา ปาว.” ");
INSERT INTO bzi_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ชฺ้าง พระเยซู นา เจ่อ ชีอือ ช้อนไก อธิษฐาน ฮาย ป้า เปิน ยาว. ยองมู ดื้ง จา ชี โย้เวอ มีซี่อืน ล้า ชีเย. ยาว ยองมู คาโคลาโค ย่าง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ปลื้ง ย้าเย่ จา คู ชี. ยาว ยองมู ย่าง พาจาวจี่ต่าง ย่าง ม่าอู่บ คู ชีเย เจิ้นเจ้อ นา บ่าแค แน. ");
INSERT INTO bzi_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ชฺ้าง คาโคลาโค พระเยซู นา เจ่อ ชี อือย่า นืงบา ทื่อลู่มทื่อเจ่อ กาแน เพล่อ ชีเย. แน ยอง เมอ อางเกิ่งอางก้อ จา ชี แฮ้ง อ่าซ่าง มาง, นี้ย่า กงา เฮอ แฮ้ย่า นาง เฮอ แน บ่าฮาจ่าแล่ คู เย. จ้า ยองมู นี้ย่า อางเกิ่งอางก้อ ค้าจา แฮ้ง เปิ่ง กาง เย. ");
INSERT INTO bzi_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ศิษย์เอก อือ พระเยซู ซฺี้ คายาว แต่ล้า แล่ ชี่ อางเลิ่ง แฮ้ง ชฺ้าง อือนา ม่าอู่บ ชีเย. ศิษย์เอก อือ จี่ เมอ อางเซง แฮ้ ล่าที่ ปลื้ง ย้า จา แง. ยาว พาจาว มาง ชฺ้าง คาโคลาโค พระเยซู นา เจ่อ คูชี อือนา ก่ามป่อน บย่า แน ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","ยาว ชฺ้าง พระเยซู นา เจ่อ ชีอือ อางมู โย้เวอ ชฺ้าง อางตูก แน บ่าจา เย. อ่าซ่าง เมอ ยู้ม แน นื้งชฺ่าตี จา ยองมือ ก่อง ยาว พลู้ แฮ้ง ศิษย์เอก อือนา ปี่ ชีเย, ไม้ ยองมู โย้เวอ ชฺ้าง อางตูก อือนา ฮ้าน ปี่ แอ แงแน. ");
INSERT INTO bzi_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","โยเซฟ ฮา ชี แม้แน ย้า, ยางนา พระเยซู ศิษย์เอก อือ บารนาบัส แน ฮ้าว แง. (บารนาบัส นี้ย่า นืงบาแฮ่ง ปี่ แงแน ฮา เย.) ยา เลวี ชฺ้าง เกาะ ไซปรัส โย้เวอ เกิ้ด ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","โยเซฟ ยาง น่า ตี แฮ้ง ก่อง ยาว พลู้ กงาชี แฮ้ง พระเยซู ศิษย์เอก อือนา ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ค่าพ่าย่า ทื่อม่าง จา เย อางเม้ง อานาเนีย แน, ยาว ค่าบา มาง อางเม้ง สัปฟีรา แน. เย่ดมือ เย่ด นื้งชฺ่าตี ย่าง ก่อง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ยาว พลู้ กงา ชีย้าง ทื่อบ่า เปิ่ง ชี บู ชี, จ้า ยาง ค่าบา มาง อางแบ เย. ยาว พลู้ จ้านล้า ชีย้าง ศิษย์เอก อือนา ปี่ ยาว จ้อบ ชี นี้แม้แน, “นี้ย่า พลู้ คาโคลาโค ย้างย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","เปโตร อานาเนีย นา จี่ช่าง ชี นี้แม้แน, “บ้าเจอ นา ซาตานแด่ย่ายอคา มางนา ตอย อ้อง ปี่ แอ? นา อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มางนา จ้อบ ชี แน นื้งชฺ่าตี ย่าง ก่อง ยาว พลู้ กงา ชี อือ ทื่อบ่า ยู้บู้ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","นื้งชฺ่าตี แฮ้ตี บ่าก่อง แน ฮาเมอ นาง เฮอ อ่าลา? แน ก่อง ยาว พลู้ กงา ชี แฮ้ง นาง เฮอ อ่าลา? ยาว บ้าเจอ นา นี้แม้ อางฮา แน? อามือ นา กงูนา จ้อบ ล่าง บ่าอ่า จ้า พาจาว มางนา จ้อบ แง!” ");
INSERT INTO bzi_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ยาว อานาเนีย มือ แฮ้แม้ กงากย่า ยาว อางซ่า แช ซฺี้ กา ชี. ชฺ้าง อือ นี้เลิ่ง กงากย่า ยาว แค คูง. ");
INSERT INTO bzi_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ค่าพ่าย่า อางนู่ม ทื่อบ่า อือ อานาเนีย ศพ ย้าง พ้า ป้าน ยาว ลาม พูม แอ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","แฮ้แม้ฮายาว 3 ชั่วโมง เคอ ยาว, อานาเนีย ค่าบา มาง ย่อ อ้องล้า ชีเย. ยา บ่าแบ เย บ้าเจอ ตอล้า ชีแน. ");
INSERT INTO bzi_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ยาว เปโตร สัปฟีรา นา น้า ชี นี้แม้แน, “ม่าย ล่าวแล นาง นื้งชฺ่าตี ก่อง ชี่นี้ พลู้ นี้ล่อญา ล่า กงา แอ?” ยาง พอ ชี นี้แม้แน, “โอ่ย อางอ้า ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ยาว เปโตร มือ สัปฟีรา นา นี้แม้แน จี่ช่าง ชีเย, “ไน้ย่า บ้าเจอ อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ล่าที่ แฮ้งนา บ่าแค แน? โย้เวอ ฮู ลื่อ แล! ค่าพ่าย่า อางนู่ม มู อือ ล้องก้อ ล้าก้า โย้เวอ จา คู แง. ยองมู นี้ย่า นาง อางบล้อง มาง ศพ แฮ้ง พูม ล้า คูแง. แน ทื่อช่างกานญา ชฺ้าง แฮ้มู ย่า นาง โซ้บ แฮ้ง ชา ลาม อ่อกแอ ล่าง.” ");
INSERT INTO bzi_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","แฮ้แม้ฮายาว สัปฟีรา มาง เปโตร มาง ล่าคื่อ ก่องทาง โย้เวอ เลิง แอ้น ยาว ซฺ้อก ย้า ซฺี้ กาชี. ยาว ชฺ้าง อางนู่ม มู อืม ย่อ อ้องล้า ชีเย. ยองมู ย้าง สัปฟีรา มาง ซฺี้ กา ชี แน มย้าง ชีเย. แฮ้งเย่ สัปฟีรา มาง ศพ ย่าง ลาม กายาว พูม แอ ชี. ยาง อางบล้อง มาง ศพ ก่องทาง โย้เวอ. ");
INSERT INTO bzi_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ชฺ้าง พระเยซู นา เจ่อ อือ แน ชฺ้าง คาโคลาโค อือ นี้เลิ่ง กงากย่า ยาว นาบาตา เย แค คูง. ");
INSERT INTO bzi_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ยาว ศิษย์เอก อืม ค่องช่าง อือ ล้าก้า โย้เวอ อางเลิ่งชฺ้างบ่าฮาตอกางอือ แน อางเลิ่ง ฮา นืงบาม่าน ปี่ง อือ ไลย่างไลเจ้อ ย้า ฮา คูชี. ยาว ชฺ้าง พระเยซู นา เจ่อ คูชี อืม อางเลิ้ง กา ย้า โบสถ์อางฮื่อ ตางเก้อ อางเม้ง โซโลมอน โย้เวอ ช้อน กาแง. ");
INSERT INTO bzi_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ยาว ชฺ้าง พระเยซู นา บ่าเจ่อ อืม มือ ยอง ก้อง บ่าอ่อง ช้อน แล จอ กาเย. จ้า บ้าเจอล้อแม้เวิม ยองมู นี้ง ชฺ้าง พระเยซู นา เจ่อ คูชี อือนา นาบาตา ซอ คูแง. ");
INSERT INTO bzi_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ยาว พาจาว มาง ชฺ้าง พระเยซู นา เจ่อ อือนา ฮาย บย่า เค่ ปี่ชี่, นี้แม้แนยาว ตื่น ค่าพ่าย่า แน ค่าบาย่า อือ คาตา ย้า พระเยซู กงู จี่วีดอางซื้ง มาง ชฺ้าง เพล่อ คูชี. ");
INSERT INTO bzi_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","แฮ้งย้า ค่องช่าง อืม ชฺ้างอางด้า อือนา แต้พู้ โย้เวอ ยู่ ปี่ ยาว, แก้บ้า ก่องทาง โย้เวอ ลาม ชี้ แอ ชี, ไม้ เปโตร ย่อไก เมอ ยาง เก้เก้ช่าง แฮ้ง ชฺ้างอางด้า อือนา กงาง ปี่ง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ยาว ค่องช่าง เยรูซาเล็ม อางเมิง ก่องทาง โย้เวอ ดื้ง คูชี อืม, ชฺ้างอางด้า แน ชฺ้าง แด่ย่า อ่อง ปี่ชี่ อือนา ซฺื่ย ล้าน คูชี. ยาว ศิษย์เอก อืม ยองมู คาโคลาโค นี้งนา พ่าญาด ยา โปยว ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","แฮ้งย้า ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง แน ยาง ชฺ้าง สะดูสี อางมู เวอ ดื้ง อืม, ศิษย์เอก อือนา นืงบาค่า คูง แน เจอค้อย คูชี. ");
INSERT INTO bzi_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","แฮ้งย้า ยองมือ ศิษย์เอก อือนา ชู คอก ล้อง แล ชี. ");
INSERT INTO bzi_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","จ้า แฮ้นืง มู่งคี่ เคิน เมอ พาจาว มาง เท่วาด่า มาง คอก ล้องก้อ ย่าง พอง ชี. ยาว ศิษย์เอก อือนา ซฺื่ย อ่อกแอน ชี. ยาว เท่วาด่า มาง ยองนา ม่า ชี นี้แม้แน, ");
INSERT INTO bzi_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“โบสถ์อางฮื่อ กองโค้ง โย้เวอ จูง แอ โว, ยาว จี่วีด อางซฺื่อ อางเลิ่ง นี้ง ค่องช่าง อือนา ป่าว ม่า โว!” แน. ");
INSERT INTO bzi_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ศิษย์เอก อืม แฮ้แม้แน กงากย่า เมอ, แฮ้งย้า ยอง ซอทา แปล้น ล้า ยาว โบสถ์อางฮื่อ กองโค้ง โย้เวอ แลน ชี, แน ค่องช่าง อือนา ม่าอู่บ ชี. ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง แน ยาง ชฺ้าง อือ โบสถ์อางฮื่อ โย้เวอ เคิน ล้า เมอ, ยาง สภาแซนฮีดริน ชฺ้างมู อือนา ฮ้าว ล้า ปี่ชี่, ไม้ ชฺ้าง นี้อือ ยิวชฺ้าง ยอคา อือ ย้าเย่. ยาว ยองมู ย้าง ยอง ชฺ้าง อือนา ม่า คอก โย้เวอ แอ ปี่ชี่, ไม้ ศิษย์เอก อือนา ซฺื่ย ยางนา ซฺ้า ล้า ปี่ง แนนอ. ");
INSERT INTO bzi_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","จ้า ชฺ้าง แฮ้อือ คอก โย้เวอ เคิน แอ เมอ ศิษย์เอก อือนา บ่ามย่าง เย. แฮ้งย้า ยอง มือ พ่าวล้า นี้แม้แน ม่า ชี, ");
INSERT INTO bzi_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“กงู คอก โย้เวอ เคอ แอ เมอ, คอก ล้องก้อ แฮ้ พี่ ชี อางแซ่ กานแก่น ย้า. ยาว ชฺ้างคอกล่อฮู อืม โย้เวอ ย้า ล่อ จา แง. แฮ้งย้า กงูมมือ คอก ล้องก้อ แฮ้ง พอง ฮู แอ, จ้า อ่าซ่าง มางนา บ่ามย่าง” แน. ");
INSERT INTO bzi_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ตาฮ้าน โบสถ์อางฮื่อ ฮูพลาฮู ยอคา มาง แน ปุโรหิต ยอคา อืม แฮ้แม้แน กงากย่า เมอ บลื่ง คูชี, แน เย้ง ชี บ้าเจอ ตอล้า ชีแน. ");
INSERT INTO bzi_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ยาว ชฺ้าง ทื่อม่าง จา แง, นี้แม้แน ม่า ล้า ชี, “ชฺ้าง นอง คอก ชู ล้อง ชี แฮ้อือนา ฮู แอ ปาว! อามื้อ ยองมู นี้ โบสถ์อางฮื่อ กองโค้ง โย้เวอ ค่องช่าง อือนา ม่าอู่บ คูชี” แน. ");
INSERT INTO bzi_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","แฮ้งย้า ตาฮ้าน โบสถ์อางฮื่อ ฮูพลาฮู ยอคา มาง แน ยาง ชฺ้าง อืม ศิษย์เอก แฮ้อือนา ชู ล้าน ชี, ยองมู นี้ย่า ศิษย์เอก อือนา เจิ้นเจ้อ บ่าฮา เย, ไม้ ยอ แค เย ค่องช่าง อือ ยองนา ลอบา จาน แซ่ วานา. ");
INSERT INTO bzi_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ยาว ยองมู แฮ้ง ศิษย์เอก อือนา สภาแซนฮีดริน อางมู อือ ล้าก้า โย้เวอ จูง ปี่ชี่. ยาว ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น มาง ยองนา นี้แม้แน น้า ชี, ");
INSERT INTO bzi_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“กงู นองนา ปีนแตปีนนา ย้า ม่า ล่าแอ่, ค่องช่าง อือนา พระเยซู อางเลิ่ง แฮ้ง บ่าม่าบ่าอู่บ โจ แน. จ้า นองมู นี้ เยรูซาเล็ม อางเมิง นู้เวอ จ่อด ย้า เยซู อางเลิ่ง นี้ง ม่าอู่บ กว่า คูชี. แน กงูนา คาตา ย้า เซฺ่อ ล่าง เยซู นา ฮา ซฺี้ ปี่ชี่” แน. ");
INSERT INTO bzi_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ยาว เปโตร แน ศิษย์เอก ทื่อบ่า อืม นี้แม้แน พอ คูชี, “กงู จามปีน ย้า พาจาว มางนา กงาน้าจ่าง ชฺ้าง อือนา น้าจ่าง แฮ้ง ล่อบ่าปา แน. ");
INSERT INTO bzi_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","นอ พระเยซู นา ไม้กางเขน เวอ ตื่อตี้ด ชี, ซฺี้ แอ เคอ ย้า. จ้า กงู อางฮู่ อางพี่ อือ พาจาว มาง ยางนา ฮาย แต่ล้า แล่ ปี่ง ญา. ");
INSERT INTO bzi_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","แน พาจาว ม้า พระเยซู นา ยาง ล่าปู่ ล่าม่า ป่ากย่า ดื้ง ปี่ชี่, แน ต้างแต่ง จี่วีดอางซื้ง แน อางบล่าบปล่องปูนปี่ฮู เพล่อ ปี่ชี่, ไม้ อิสราเอลชฺ้าง อือนา พระเยซู ปาปาย นืงบาเพ่น อางบล่าบ ฮา แฮ้ง ว่าง ปี่ง แนนอ. ยาว พาจาว มาง ยองนา อางซีอางบล่าบ บ่ายู่ เย. ");
INSERT INTO bzi_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ยาว กงู พี่ญ่าน เพล่อ แง นี้ย่า อางเลิ่ง ม้าม้า แน. ยาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง คาตา ย้า พี่ญ่าน เพล่อ แง. อางค่องอางล้า อางเซฺิ่งอางซฺ้าง นี้ม้าย่า พาจาว มาง, ชฺ้าง คาโคลาโค ยางนา น้าจ่า คูชี อือนา ปี่ ชี มาง ย้า” แน. ");
INSERT INTO bzi_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","สภาแซนฮีดริน ชฺ้างมู อือ แฮ้แม้แน กงากย่า เมอ นาบาตา เย นืงบาค่า คูแง. แน ยองมู นี้ง ศิษย์เอก อือนา แซ่ ซี้ แง. ");
INSERT INTO bzi_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","จ้า สภาแซนฮีดริน ชฺ้างมู โย้เวอ ชฺ้าง ทื่อม่าง จา แง, ยาง อางเม้ง กามาลิเอล แน, ยา ฟาริสี อางมู ดื้ง แง, ยา อางลี้บอางล่าว ม่าอู่บฮู ชฺ้าง คาโคลาโค อือ นาบทื้อ คูง มาง ย้า. ยาว ยาง ทาจูง ล้า ชี, แน ม่าย ชี ศิษย์เอก นี้อือนา อางเง้ เวอ ทื่อชี่ด ซฺื่ย อ่อกแอ ปาโน แน. ");
INSERT INTO bzi_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ยาว ยาง นี้แม้แน จี่ ชี, “อิสราเอลชฺ้าง นอง เวอ, นอ ชฺ้าง นี้อือนา บ้าเจอ ชา ฮา เวิม, แม่น แน เย้ง ฮู คู ปาโน. ");
INSERT INTO bzi_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","อางจาม กงา ย้าล่า ค้าแต้ เวอ ชฺ้าง ทื่อม่าง จา แง, ยาง อางเม้ง ธุดาส แน, ยา ฮากนา ม่า กว่า ชี ค่าตอง ชฺ้าง ปีนแตปีนนา ล่าที่ อางจา แน. แฮ้งย้า ชฺ้าง ทื่อบ่า อืม ยาง ศิษย์ เพล่อ คูชี. ยาว ชฺ้าง ยาง ศิษย์ เพล่อ คูชี แฮ้ 400 คู่น นี้งล่อซฺ่า เย. จ้า บ่ามล่าง ยาว ธุดาส นา ฮาก แซ่ ชี. ยาว ยาง ศิษย์ อืม กามางกาต่อง กามางกาตี่ เย ฮื่น โปยว แล่ คูชี. ยาว อางเลิ่ง ตอล้า ชี แฮ้ง กยาบ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ธุดาส อางเลิ่ง นี้ง เปิน ยาว น่อง โย้เวอ ชฺ้าง ทื่อม่าง จา แล่แง, ยาง อางเม้ง ยูดาส แน, ยา กาลิลีชฺ้าง เย. แฮ้ญ่ามเมอ ค่องช่าง อือย่า ทะเบียนบ้าน อางพ่า กงาแต่ง คูง เย. ยาว ยูดาส มือ ค่องช่าง อือนา จี่ซ้อ อางเลิ่ง อางซืกอางซาก ฮา ปี่ชี่. จ้า บ่ามล่าง ยาว ยูดาส นา ฮาก แซ่ ชี. แฮ้งย้า ยาง อางมู อืม กามางกาต่อง กามางกาตี่ แน ฮื่น คูชี. ");
INSERT INTO bzi_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","นี้แม้แนยาว นี้เทอ เวอ อางเลิ่ง ตอล้า ชี นี้ง ทื่อช่างกานญา. กงา นองนา ม่า ล่าปานา, ชฺ้าง นี้อือนา บ่าตี่นบ่าต่อง โจ, ยองนา ตอ แอ ปี่ โว, ไม้ จาว่าแน ม่าอู่บจี่ต่าง นี้ง ชฺ้าง ก่ามกืด เวอ จาย ล้า แงแน ยาว, ยอง มือ ก่างพยา แอ แง. ");
INSERT INTO bzi_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","จ้า พาจาว มาง ก้อง จายลือ แงแน ยาว, นองมู นี้ง ยองนา บ่าก่าจ่า กงากา. ยาว นองมู นี้ง พาจาว มางนา รบช่าง แงแน ทื่อช่างกานญา!” แน. ");
INSERT INTO bzi_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ยาว ยองมู แฮ้ง กามาลิเอล ม่า แฮ้งนา อางซอ คู. แฮ้งย้า ยองมือ ศิษย์เอก อือนา ฮ้าว อ้องล้า ปี่ชี่. ยาว ล่าตื่อ อ่ามย่าง อางคอ เวอ ไจ แต่ง ชี แฮ้ง ยองนา ชืก ชี. ยาว ม่า ชี พระเยซู อางเลิ่ง นี้งนา บ่าม่าบ่าอู่บ แล่โจ แน. ยาว ยองมู แฮ้ง ศิษย์เอก อือนา ตอแอ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ยาว ศิษย์เอก อืม นืงบาต่องจาบื่อ ย้า สภาแซนฮีดริน โย้เวอ อ่อกแอน คูชี, ไม้ ยอย่า เย้ง คูง แง พาจาว ม้า ยองนา แช้ยู้ ยาว พระเยซู อางเลิ่ง ป่าว แฮ้ง ปาปาย อางตูกอางพาน กงาโอ้ด ปี่ชี่ แน. ");
INSERT INTO bzi_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ยาว ศิษย์เอก อืม กูนืง ย้า โบสถ์อางฮื่อ กองโค้ง โย้เวอ แน ค่องช่าง อือ ยู้ม โย้เวอ ม่าอู่บ คูแง, แน อางเลิ่ง อางแม่น นี้ง ป่าว คูแง, พระเยซู ย่า พาจาว มาง แช้ยู้ ก่าซ้าด เพล่อ ปี่ ชี่ มาง ย้า แน. ");
INSERT INTO bzi_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","แฮ้ญ่ามเมอ ชฺ้าง พระเยซู นา เจ่อ อือ บย่า เค่ ชี. ยาว ฮาก จฺ่าเกิ่ง เปิ่ง เมอ, ยิวชฺ้าง แมม้าย กรีก ต่าง จี่ อือ ฮาก ล่อ แน บ่ากงา เย. แฮ้งย้า ยิวชฺ้าง กรีก ต่าง จี่ อือ ยิวชฺ้าง ฮีบรู ต่าง จี่ อือนา จี่จ่าบ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","แฮ้งย้า พระเยซู ศิษย์เอก 12 คู่น อืม ชฺ้าง พระเยซู นา เจ่อ คูชี อือนา โค แน ฮ้าว ช้อน ชี. แน ยองนา นี้แม้แน จี่ช่าง ชี, “กงู พาจาวจี่ต่าง ม่าอู่บ นี้ง ว่าง ยาว จฺ่าเกิ่ง เปิ่ง กว่า นี้ย่า บ่าซูม เป. ");
INSERT INTO bzi_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","นี้แม้แนยาว ม้องน้าม นอง เวอ, นอง อางมู นู้เวอ ชฺ้าง 7 คู่น แช้ยู้ ปาว. นอย่า ชฺ้าง นี้อือนา แช้ยู้ โว, ยอย่า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ปลื้ง แน จา แง, วี่ไซป้านญา อางจา แน ฮาก นาบทื้อ คูง อือ. ยาว กงูมู นี้ง ยองนา ต้างแต่ง ชฺ้าง จฺ่าเกิ่งเปิ่งฮู เพล่อ ปี่ แน. ");
INSERT INTO bzi_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","จ้า กงูมู นี้ ปีนแตปีนนา แน อธิษฐาน ฮา คูง, แน พาจาวจี่ต่าง นี้ง ม่าอู่บ คูง” แน. ");
INSERT INTO bzi_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ยาว ชฺ้าง คาโคลาโค อืม ศิษย์เอก อือ จี่ คูชี แฮ้งนา นืงบาจาบ คูชี. แฮ้งย้า ยอง สเทเฟน นา แช้ยู้ คูชี. สเทเฟน พาจาว มางนา ปีนแตปีนนา ย้า เจ่อ แง, แน อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ปลื้ง ย้า ยางก้อง ดื้ง แง. ยาว ยองมู แฮ้ง ฟีลิป, โปรโครัส, นิคาโนร์, ทิโมน, ปารเมนัส, นิโคเลาส์ ยองนา คาตา ย้า แช้ยู้ แล่ คูชี. นิโคเลาส์ ย่า อันทิโอก อางเมิง ชฺ้าง, ย่า ยิวชฺ้างบ่าอ่า. จ้า ยา ยิว อางลี้บอางล่าว ย่าง ทื้อ ชี. ยาว น่อง โย้เวอ ยา พระเยซู นา เจ่อ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ยาว ยองมู แฮ้ง ชฺ้าง 7 คู่น นี้อือนา ซฺื่ย ศิษย์เอก อือนา ซฺ้าแล ชี. ยาว ศิษย์เอก อืม ชฺ้าง 7 คู่น อือก้อง ล่าปู่ โบย ยาว อธิษฐาน ฮา ยาว ยองนา ก่ามป่อน ปี่ ชี. ยาว ยองนา ต้างแต่ง ชฺ้าง จฺ่าเกิ่งเปิ่งฮู เพล่อ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ยาว พาจาวจี่ต่าง แฮ้ง ชฺ้าง บย่า ย้า แบ เค่ คูชี. แน เยรูซาเล็ม อางเมิง โย้เวิม ชฺ้าง อางบย่า ย้า พาจาว มางนา แน พระเยซู นา เจ่อ คูชี. ยาว ปุโรหิต อืม อางบย่า ย้า พาจาวจี่ต่าง แฮ้งนา เจ่อ คูง. ");
INSERT INTO bzi_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","สเทเฟน ย่า พาจาว มาง ลากซื่งกง่ากย้า ยาว พาจาว มาง ล่าที่ ปี่ ชี มาง. ยา อางเลิ่งชฺ้างบ่าฮาตอกางอือ อางอีบ่าอ่า ย้า ค่องช่าง อือนา ฮายฮู ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","จ้า ยิวชฺ้าง ทื่อบ่า จา ชี, ยอย่า ย่าเจ่น ปูน แล่คู ชีอือ. ยองมู นี้ย่า ไซรีน อางเมิง, อเล็กซานเดรีย อางเมิง ซีลีเซีย แควน แน เอเชีย แควน อือเมอ จายล้า คูแง. ยาว ยอย่า สเทเฟน นา อางเลิ่ง ซฺ้า ยาว จี่เจ้ ลือ คูง. ");
INSERT INTO bzi_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","จ้า ยองมู นี้ สเทเฟน วี่ไซป้านญา แฮ้งนา บ่าก่า จ่า เย, ไม้ สเทเฟน อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ม่า จี่ ปี่ง แฮ้งแม้แน จี่ เย. ");
INSERT INTO bzi_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","แฮ้งย้า ยองมู ย้าง ช้อนกา สเทเฟน นา นี้แม้แน อางไล้ จี่กาน คูชี, “กงู ค่าพ่าย่า นี้มาง โมเสส แน พาจาว มางนา จี่ ฮูย้า นา กงากย่า แอ” แน. ");
INSERT INTO bzi_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ยาว ยองมู แฮ้ง ค่องช่าง อือนา แน ยอคา อือนา แน อางลี้บอางล่าว ม่าอู่บฮู อือนา จี่ซ้อ สเทเฟน นา ชู สภาแซนฮีดริน โย้เวอ ซฺื่ยแล ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","แฮ้งย้า ยองมู นี้ง ชฺ้าง ซฺ้า ยาว พี่ญ่าน ม้าม้า บ่าอ่า อือ เพล่อ ปี่ชี่. ยาว พี่ญ่าน ม้าม้า บ่าอ่า แฮ้อืม สเทเฟน นา นี้แม้แน อางไล้ จี่กาน ชี, “ค่าพ่าย่า นี้ม้า โบสถ์อางฮื่อ นี้งนา แน โมเสส อางลี้บอางล่าว นี้งนา กูญ่าม ย้า จี่ ฮูย้า แง, ");
INSERT INTO bzi_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ไม้ กงูมู นี้ ยาง นี้แม้แน จี่ นา กงากย่า แอ, เยซู นาซาเร็ธชฺ้าง ม้า โบสถ์อางฮื่อ นี้ง ก่างพยา ยาว, โมเสส กงูนา อางลี้บอางล่าว ปี่ ล่าชี่ นี้ง เพ่น แง” แน. ");
INSERT INTO bzi_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ยาว ชฺ้าง คาโคลาโค สภาแซนฮีดริน โย้เวอ ดื้งจา คูชี อืม สเทเฟน แมก่า โย้เวอ ฮูน คูชี เย. ยาว ยอง มย้าง ชี สเทเฟน แมก่า นี้ เท่วาด่า นา อางตู้ แน. ");
INSERT INTO bzi_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ปุโรหิต ยอคา อางฮื่อ เลิ่นเลิ่น ม้า สเทเฟน นา น้า ชี นี้แม้แน, “ม้าม้า ลา?” ");
INSERT INTO bzi_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","สเทเฟน มาง นี้แม้ พอ ชีเย, “ย่าม่างยอคา เวอ แน ม้องน้าม นอง เวอ กงานา น้า ล่า ปาโน. พาจาว ล่าที่ อางฮื่อ ม้า กงู อางฮู่ อับราฮัม แน ชี่ มางนา มย้าง ปี่ ชี่. แฮ้เมอ เวอ ยา เมโสโปเตเมีย แควน เวอ ดื้ง แง, ฮาราน อางเมิง โย้เวอ บ่ากงา พ้าง ดื้ง แล กางซื้ง. ");
INSERT INTO bzi_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","พาจาว มาง อับราฮัม นา นี้แม้แน จี่ ช่าง ชี, ‘อับราฮัม เวอ, นาง ค่อง แน นาง ย่าช่างม่องน้าม อือก้อง บ่าดื่ง แล โจ. นื้งชฺ่าตี กงา มย้าง ปี่ ล่าง โย้เวอ แล ปาว.’ ");
INSERT INTO bzi_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","แฮ้แม้ยาว อับราฮัม มือ เมโสโปเตเมีย แควน เคลเดีย ชฺ้าง อือ ดื้ง โย้เวอ แอ้น ยาว, ฮาราน อางเมิง โย้เวอ ดื้ง แล ชีเย. จ้า อางโบ้ง มาง ซฺี้ ยาว. พาจาว มาง ยางนา ฮาราน อางเมิง โย้เวอ บ่าปี่ ดื้ง แล เย. แฮ้งเย่ อับราฮัม ฮาราน อางเมิง โย้เวอ อ่อก ลือ ชี. อามื้อ นองมู นื้งชฺ่าตี ดื้ง นู้เวอ ดื้ง ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“แฮ้ญ่ามเมอ พาจาว มาง อับราฮัม นา นื้งชฺ่าตี ย่าง บ่าปี่ กางซื้ง เย. ล่าคื่อปาว่า ล่อ แนม อางอี้ แนม บ่าปี่ เย. แฮ้ญ่ามเมอ อับราฮัม อางย่า ทื่อม่าง แนม บ่าจา, จ้า พาจาว มาง ก่ามค่าน ปี่ ชีเย. นื้งชฺ่าตี คาโคลาโค นี้ง ยางนา ปี่ แงแน. ยาว ยาง อางย่าอางคย้า อางอ่านอางซฺื้อ อือนา ปี่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","พาจาว มาง ยางนา จี่ช่าง ชี นี้แม้แน, ‘นาง อางย่าอางคย้า อางอ่านอางซฺื้อ นี้อือนา ฮาก อางเจ้ออางจาด อือ นื้งชฺ่าตี เวอ กงาดื้ง แอ ปี่ แง. โย้เวอ ชฺ้าง อือ ยองนา เค้คาม ย่าเจ่น เพล่อ ปี่ แง. แน ยองนา 400 ปี ฮา ตูกพานลาบ้าบ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ชฺ้าง ลอจาด นาง อางย่าอางคย้า อางอ่านอางซฺื้อ อือนา ย่าเจ่น เพล่อ ปี่ แง. กงา ยองนา วี่บ่ากกงาไจ ปี่ แง.’ ยาว พาจาว มาง ม่า แล่ ชี่, ‘ยาว ยองมู นี้ย่า นื้งชฺ่าตี โย้เวอ อ่อกแอ ยาว นื้งชฺ่าตี นี้มาง ก้อง ล้า กงานา ไว้ นาบทื้อ ล่า คูแง.’ ");
INSERT INTO bzi_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“พาจาว มาง อับราฮัม นา ก่ามค่าน ปี่ ชี. ย่าเก ค่าพ่าย่า นา พิธีขลิบ ฮา ปี่ อางเลิ่ง แฮ้ง. ยาว อับราฮัม มือ อางย่า จา ชี อางเม้ง อิสอัค แน, เกิ้ด 8 นืง เคอ ยาว อับราฮัม มือ ยาง อางย่า ม่าง นา พิธีขลิบ ฮา ปี่ ชี่. ยาว จายล้าแล่ยาว อิสอัค มือ อางย่า ค่าพ่าย่า จา ชี อางเม้ง ยาโคบ แน. ยาว ยาโคบ อางย่า ค่าพ่าย่า 12 คู่น จา ชี. แน ชฺ้าง นี้อือ กงู อางฮู่ อางพี่ อางเจ้อ ซื้บไกลือ ชี อือ ย้า. ");
INSERT INTO bzi_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ยาโคบ อางย่า ค่าพ่าย่า อือ ยอง อางแพ้ อางเม้ง โยเซฟ แน ชี่ มางนา เจอค้อย คูง เย. แฮ้งย้า โยเซฟ นา ชู ก่อง ชีเย. โยเซฟ มือ อียิปต์ ชฺ้าง อือ ย่าเจ่น เพล่อ ชีเย. จ้า พาจาว ม้า โยเซฟ มาง ก้อง ดื้ง ลือ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","พาจาว มาง โยเซฟ นา ปล่อง ชี. โยเซฟ อางตูกอางพาน กูเจ้อ อือ ปูน แล่ ชี. ยาว พาจาว มาง โยเซฟ นา วี่ไซป้านญา จา แอ้น ปี่ ชี่. พาจาว มาง อียิปต์ ก่าซ้าด ฟาโรห์ แน ชี่ มางนา ฮาย โยเซฟ นา ซอ ปี่ชี่. ยาว ก่าซ้าด ฟาโรห์ มือ โยเซฟ นา อียิปต์ ชฺ้าง อือนา แน อียิปต์ นื้งชฺ่าตี คาโคลาโค ย่าง ฮูพลา ปี่ชี่. แน ยาง ยู้ม คล้าว โย้เวอ อางเกิ่งอางก้อ คาโคลาโค อือ ฮู พลา ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“น่อง เวอ บ่ามล่าง เย. ประเทศ อียิปต์ แน คานาอัน แควน กูต่องกูตี่ อือเมอ ฮ่าง แน ล้าง เคม ชี. ชฺ้าง อือ ฮ่าง จฺื่งคู นาบาตา เย ตูกพานลาบ้าบ คูแง. ");
INSERT INTO bzi_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ยาว แฮ้ญ่าม เมอ ยาโคบ คานาอัน แควน โย้เวอ ดื้ง แง. ยา ประเทศ อียิปต์ โย้เวอ ฮ่าง จฺ่าเซฺ่อ อางจา แน กงากย่า ชีเย. แฮ้งเย่ ยาง อางย่าย่าค่า อือนา โย้เวอ ซฺาแอ ฮ่าง วื้อ แอ ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ยาว โยเซฟ อางอ้าย อือ ครั้งที่ 2 โยเซฟ ก้อง ฮ่าง วื้อ ลือ เมอ. นี้เทอ โยเซฟ ย่า ยาง ม้องน้าม อือนา ม่า แบ ปี่ ชีเย. ยา ยอง อางแพ้ มาง แน. ยาว ก่าซ้าด ฟาโรห์ มาง โยเซฟ ย่าช่างม้องน้าม แน ยู้ม คล้าว ชฺ้าง อือนา แบ โค ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","โยเซฟ ชฺ้าง ซฺา แอ ปี่ชี่ ยาโคบ ยาง อางโบ้ง มาง แน ยาง ม้องน้าม อือนา ฮ้าว แอ ปี่ ชีเย. ชฺ้าง คาโคลาโค แฮ้ 75 คู่น เย. ");
INSERT INTO bzi_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ยาว ยาโคบ แน ยอง ยู้มชฺ้าง คาโคลาโค ย่าง ประเทศ อียิปต์ โย้เวอ ดื้ง แล ชี. ยาว ยาโคบ แน ยาง อางย่า คาโคลาโค กงู อางฮู่ อางพี่ อางเจ้อ ซื้บลือ ชี อือ โย้เวอ ย้า ซฺี้ โค ชี. ");
INSERT INTO bzi_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","อับราฮัม มือ ท้ามชฺ้างซฺี้ชีย้า เชเคม อางเมิง โย้เวอ ฮาโมร์ อางย่า อือ ก้อง วื้อ ชี ลาง ชี. ยาว ยาโคบ ยู้มชฺ้าง อือ ศพ ย่าง โย้เวอ ย้า ชี ชี. ");
INSERT INTO bzi_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“พาจาว มาง อับราฮัม นา ก่ามค่าน ปี่ ชี่ อางญ่าม ย่าง ชา เคอ ล้า เมอ. อิสราเอลชฺ้าง อือ ประเทศ อียิปต์ โย้เวอ นาบาตา บย่า เย จา แง. ");
INSERT INTO bzi_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","แฮ้ญ่ามเมอ ประเทศ อียิปต์ โย้เวอ ก่าซ้าด อางซฺื่อ เพ่น ชีเย. ยา ประเทศ อียิปต์ นา ฮูพลา เย ยา โยเซฟ อางเลิ่ง นา บ่าแบ เย. ");
INSERT INTO bzi_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ก่าซ้าด นี้ม้า บ่าแม่น เย กงู อิสราเอลชฺ้าง อือนา เค้คาม, จ้อบ ชี. แน กงู อางฮู่ อางพี่ อือนา เค้ ยอง อางย่า อางอี อือนา ล้างบ้า อางฮื่อ โย้เวอ วี ซฺี้ ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“โมเสส แฮ้ญ่าม เวอ เกิ้ด ลือ ชี, ยา อางแม่นอางมาง ฮากนา บ่าตู่ เย. อางบา แน อางโบ้ง มาง เย่ด ยางนา อ่าญู 3 ลา เคอ ย้า ยู้ม คล้าว โย้เวอ ค่าว ปอ ไจ่ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ยาว ยางนา ซ้าล้อง เวอ กาน ล้างบ้า เวอ ปู้ย แอ ปี่ ชี่. ก่าซ้าด ฟาโรห์ อางย่าย่าบี่ มาง มย้าง ยาว ยาง อางย่า เพล่อ ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","แฮ้แม้ยาว โมเสส มือ อียิปต์ ชฺ้าง อือ อางไล่ คาโคลาโค อือ โค แน เล่นแบ แล่ ชีเย. จี่ต่าง อางเลิ่ง นี้ง อางจี่คี่ แน ล่ากาน กูย่างกูเจ้อ อืมมือ อางแบ อางคี่ เย. ");
INSERT INTO bzi_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“โมเสส อ่าญู 40 ปี เคอ ยาว อิสราเอลชฺ้าง ยาง อางเจ้ออางจาด ชฺ้าง อือนา บ่อซฺ้า แอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ยาว อียิปต์ ชฺ้าง ทื่อม่าง จา ชี, อิสราเอลชฺ้าง ทื่อม่าง นา ตื่อชืก ชี. โมเสส มย้าง ล้า ยาว อิสราเอลชฺ้าง มางนา ปล่อง ชีเย. แน อียิปต์ ชฺ้าง มางนา แซ่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ยาว โมเสส เย้ง เย ยองมู นี้ย่า อางแบ ย้า แน. พาจาว ม้า โมเสส นา ไจ อิสราเอลชฺ้าง ยาง อางเจ้ออางจาด อือนา ปล่อง ย่าเจ่น ปูน ปี่ ลือ ชี แน. จ้า กานแตว อิสราเอลชฺ้าง นี้ย่า บ่าแบ เย. ");
INSERT INTO bzi_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ซอทา แปล้น ล้ายาว อิสราเอลชฺ้าง 2 คู่น จา ชีเย. ซี ลางกา ชี โมเสส ล้า มย้าง ล้า ยาว เย่ดนา จี่ช่าง ชี นี้แม้แน, ‘ไน้ ย่าช่างม่องน้าม กา บ้าเจอ อางซี กาแน?’ ");
INSERT INTO bzi_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","จ้า ค่าพ่าย่า อางซี ม้า โมเสส นา ต่าน ยาว นี้แม้แน จี่ ชีเย, ‘นางนา อ่าซ่าง ชฺ้าง อือนา ฮูพลาฮู ต้างแต่ง เพล่อ ปี่ ล่าแง? แน อ่าซ่าง ต้างแต่ง กงูนา ต้าดต่อน ปี่ ล่าแง? ");
INSERT INTO bzi_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ยาว นา กงานา ชา แซ่ ล่าง ลา? มี้งก้อง อียิปต์ ชฺ้าง มางนา แซ่ ชี แม้แน.’ ");
INSERT INTO bzi_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","โมเสส มือ แฮ้แม้ กงากย่า ยาว ยาง โย้เวอ ฮื่น อ่อกแอ ยาว มีเดียน ชฺ้าง อือ ค่อง เวอ ดื้ง แล ชี. แน อางย่า ค่าพ่าย่า 2 คู่น กงา ชีเย.” ");
INSERT INTO bzi_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“40 ปี ปูน แลน ยาว เท่วาด่า มาง โมเสส นา ลือ มย้าง ปี่ ชี่ เย. ตีอางกืออางคาก ซีนาย ตาแซ้ อางแท้ โย้เวอ. เท่วาด่า ม้า จฺืงจฺื้ง ปาว บี่ท่อ อางจฺ่อ เวอ จา แง. ");
INSERT INTO bzi_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","โมเสส มย้าง ยาว บ่าเจ่อ ซี่ เย. ยาง เจ้ง แน มย้าง ซี้ ยาว แท้ แน ย่อ อ้อง ฮู แล ชีเย. ยาว จี่วีดอางซื้ง มาง อางเซง จี่ ย่าง นี้แม้แน กงากย่า ชี, ");
INSERT INTO bzi_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘กงา นาง อางฮู่ อางพี่ อือ พาจาว มาง เป. อับราฮัม มาง พาจาว อิสอัค มาง พาจาว แน ยาโคบ มาง พาจาว เป.’ โมเสส แค ยืก ชีเย จฺืงจฺื้ง ปาว โย้เวอ บ่าฮู จอ กา เย. ");
INSERT INTO bzi_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“ยาว จี่วีดอางซื้ง มาง โมเสส นา จี่ช่าง แล่ ชี่ นี้แม้แน, ‘แค้บ ชอด แล่ โว! นาง นื้งชฺ่าตี จูง นี้ย่า นื้งชฺ่าตี อางเซฺิ่งอางซฺ้าง เป. ");
INSERT INTO bzi_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ยาว กงา อียิปต์ ชฺ้าง อือ กงา ชฺ้าง อือนา ตื่อชืก แฮ้งนา อางมย้าง เป. แน ยอง อู้ง อางเซง แฮ้งนา กงากย่า แอ. แฮ้แม้ยาว กงา ลู่ง ลือ ยองนา ปล่อง ลือ แง. ยองนา อางตูกอางพาน ปูน ปี่แง. นี้แม้แนยาว นาย่า ประเทศ อียิปต์ โย้เวอ พ่าว แอน แล่ ปาว! กงา นางนา ซฺาแอ ปี่ ล่าง.’ ");
INSERT INTO bzi_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“โมเสส นี้มาง นา ย้า อิสราเอลชฺ้าง อือ ยาง แมก่า เวอ จี่ กาน ชี นี้แม้แน, ‘นางนา อ่าซ่าง ชฺ้าง อือนา ฮูพลาฮู ต้างแต่ง เพล่อ ปี่ ล่าแง? แน อ่าซ่าง ต้างแต่ง กงูนา ต้าดต่อน ปี่ ล่าง?’ ยาว พาจาว มางมือ เท่วาด่า โมเสส จฺืงจฺื้ง ปาว บี่ท่อ อางจฺ่อ เวอ มย้าง ชี มาง ก้อง จี่ ลือ ปี่ ชี่ เย. ยาว พาจาว มาง ยางนา ซฺาลือ ปี่ ยาว อิสราเอลชฺ้าง อือนา ปล่อง ลือ ปี่ง. แน อิสราเอลชฺ้าง อือนา ฮูพลา ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","โมเสส ย่า อิสราเอลชฺ้าง อือนา ปล่อง ประเทศ อียิปต์ โย้เวอ อ่อกลือ ปี่ มาง. ยา ประเทศ อียิปต์ โย้เวอ ทะเลแดง แน ตีอางกืออางคาก อือเมอ อางเลิ่งชฺ้างบ่าฮาตอกางอือ อางบย่า ย้า ฮา ชี 40 ปี เย. ");
INSERT INTO bzi_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","โมเสส นี้มาง ย้าเป อิสราเอลชฺ้าง อือนา นี้แม้แน จี่ช่าง ชี นี้แม้แน, ‘จ้างจ้าง เวอ พาจาว ม้า กงา แม้แน พาจาวจี่ต่างจี่แต่นฮู ซฺาลือ ปี่ ยาว นองนา ปี่ ล่าง. พาจาวจี่ต่างจี่แต่นฮู นี้ม้า นอง ม้องน้าม อือก้อง จายล้า แง.’ ");
INSERT INTO bzi_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","โมเสส นี้มาง ย้า ตีอางกืออางคาก โย้เวอ อิสราเอลชฺ้าง อือ ก้อง ทื่งกง่า แน ดื้ง ชี มาง. ยา กงู อางฮู่ อางพี่ อือก้อง ทื่งกง่า แน ดื้ง ชี. แน ยา เท่วาด่า ยางนา ซีนาย ตาแซ้ โย้เวอ จี่ช่าง ชี่ มาง ก้อง ทื่งกง่า แน ดื้ง ชี. แน ยา พาจาว ม่าอู่บจี่ต่าง จี่วีดม้าม้า อางเลิ่ง อือ, ลาบลือ ยาว กงูนา ปี่ ล่าแง. ");
INSERT INTO bzi_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“จ้า กงู อางฮู่ อางพี่ อือ ยาง จี่ต่าง นา บ่าน่า แน ยางนา บ่าซอ เย. กงู อางฮู่ อางพี่ อือ นืงบา โย้เวอ ประเทศ อียิปต์ โย้เวอ พ่าวแล ซี้ แงแน เย้ง จา เย. ");
INSERT INTO bzi_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ยาว โมเสส ซีนาย ตาแซ้ โย้เวอ ตาแล เมอ. ยองมู นี้ย่า อาโรน โมเสส อางอ้าย มางนา จี่ช่าง ชี นี้แม้แน, ‘โมเสส กงูนา ประเทศ อียิปต์ โย้เวอ ซฺื่ย อ่อกลือ ล่า ชี่ มางก้อง บ้าเจอ ตอล้า ชี นามบ่าแบ ตาแซ้ โย้เวอ ไล นืง เคิน ญา แล. แฮ้แม้ยาว กงูนา ฮู่บปาน แต่ง ปี่ ล่าปาว แก้บ้า ซฺื่ยแล ล่า เซฺ่อ.’ ");
INSERT INTO bzi_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","แฮ้ญ่ามเมอ ยองมู ย้าง อ่ามย่าง อางย่า ฮู่บปาน แต่ง ยาว ไว้ ชีเย. แน อ่ามย่าง อางย่า ฮู่บปาน มางนา ซ้าด แซ่ ท่าน ยาว จฺ่าต้าง ม่อน ลางกา ชีเย. ยอง ฮู่บปาน แต่ง ล้า ชี มางนา ไว้ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“แฮ้แม้ยาว พาจาว ม้า ยองนา แมก่า พลาบ ฮื่น ชีเย. พาจาว มาง ยองนา ตอย มู่งท่า โย้เวอ อู่กื่อ อือนา ไว้ ปี่ ชี่ เย. พาจาวจี่ต่างจี่แต่นฮู อือ พระคัมภีร์ โย้เวอ แต้ม ชี ชี แม้แน, ‘อิสราเอลชฺ้าง นอง เวอ, 40 ปี นู้เวอ นอง ตีอางกืออางคาก โย้เวอ ซ้าด แซ่ ท่าน ชี่ นี้อือ. กงานา บ่ากงา ท่าน ล่า เป. ");
INSERT INTO bzi_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","นองมู นี้ ฮู่บปาน กูย่างกูเจ้อ แต่งล้า ชี อือ ไว้ ชี. นอย่า พระโมเลค นา ไว้ ย้า ย้าง แต่ง ชี. แน เรฟาน ฮูบปาน ย่าง คาตา แต่ง ชี. แฮ้แม้ยาว กงา นองมู นา เว่อ แน ซฺาแอ ปี่ ล่าง บาบิโลน อางเมิง แฮ้ง ล่อบ่าปา แน, ยาว ย่าเจ่น เพล่อ ปี่ ล่าแน.’ ");
INSERT INTO bzi_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“กงู อางฮู่ อางพี่ อือ ตีอางกืออางคาก โย้เวอ ดื้ง เมอ เต็นท์ พาจาว ไว้ย้า จา เป. เต็นท์ แฮ้ พาจาว มาง โมเสส นา มย้าง ปี่ ยาว ม่า แต่ง ปี่ ชี่แม้แน. ");
INSERT INTO bzi_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ยาว กงู อางฮู่ อางพี่ อือ เต็นท์ ย่าง กงา ยาว. ยองมือ เต็นท์ ย่าง เช่ โยชูวา ก้อง ซฺื่ยกา เค่ แลน ชี. กงู อางฮู่ อางพี่ อือย่า ยอง นื้งชฺ่าตี รบ ย่าด กงา ชี โย้เวอ แลน ชี. แฮ้ญ่ามเมอ พาจาว ม้า ยาง ตี ยองนา ปี่ ชี่ โย้เวอ, ชฺ้าง จา อือนา ก่าอ่อก ชี. แฮ้งย้า เต็นท์ แฮ้ แฮ้เมอเวอ จาย ย้า โย้เวอ ดื้ง ล้า ชี. ก่าซ้าด ดาวิด อางญ่าม อางเมิง ฮูพลา เมอ เคอ ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","พาจาว มาง ก่าซ้าด ดาวิด นา นาบาตา ซอ เย่. ก่าซ้าด ดาวิด มือ พาจาว มางนา ป้า ยาว, ยาโคบ พาจาว มางนา โบสถ์อางฮื่อ แต่ง ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","จ้า ม้าม้า แน โบสถ์อางฮื่อ แต่ง ปี่ ชี่ ม้า ก่าซ้าด โซโลมอน ก่าซ้าด ดาวิด อางย่า มาง เย. ");
INSERT INTO bzi_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","จ้า บ้าเจอล้อแม้เวิม พาจาว อางฮื่อ เลิ่นเลิ่น ม้า ชฺ้าง อือ โบสถ์อางฮื่อ แต่ง ชี โย้ บ่าดื่ง เป. พาจาวจี่ต่างจี่แต่นฮู อือ พาจาว มาง จี่ต่าง ย่าง นี้แม้แน จี่ ชี ชี, ");
INSERT INTO bzi_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘มู่งท่า นี้ กงา ต่างอี่ ย่าง. ชฺ้างอางเมิง นี้ย่า กงา ล่าคื่อ น่าง เซฺ่อ ย่าง. พาจาว มาง ม่า ชีเย. อ่าซ่าง มาง กงา ดื้งย้า แฮ้ง บ่าแต่ง ปี่ ล่าตอ กา. ");
INSERT INTO bzi_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ไม้ ม้างม้าเจ้อ นี้อือ กงา แต่งล้า แอ.’ ");
INSERT INTO bzi_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“นองมู นี้ย่า ชฺ้าง อางล้าน แน น่าป่าง อือ. นองมู นี้ อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มางนา กูเทอ ย้า บ่าตื่อ น้า แน บ่าตื่อ ฮา เค่ กา. นอง อางฮู่ อางพี่ อือ บ้าเจอล้อแม้ ฮา ลือ ชี นอง แฮ้แม้ย้า ฮา เค่ แง. ");
INSERT INTO bzi_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","นอง อางฮู่ อางพี่ อือ พาจาวจี่ต่างจี่แต่นฮู อือนา กูคู่น ย้า เค่คาม โก้นก้าว ชี. ยองมู นี้ย่า พาจาวจี่ต่างจี่แต่นฮู อางมู, พระเยซู ลือ เมอ มอ ชี อือนา แซ่ ชี. แน นอ พระเยซู นา บ่าแม่น แน ฮา ป้าน่อ ยาว ยางนา แซ่ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","พาจาว ม้า ยาง เท่วาด่า มางนา ม่าย อางลี้บอางล่าว แฮ้ง นองนา ฮ้าน ปี่ ลือ ปี่ ล่าง. จ้า นองมู นี้ย่า อางลี้บอางล่าว แฮ้งนา บ่าฮา เค่!” ");
INSERT INTO bzi_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ยิวชฺ้าง ยอคา อือ แฮ้แม้ กงากย่า ยาว ซ่อเพ่แช่ทา ย้า นืงบาค่า แง. ");
INSERT INTO bzi_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","จ้า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง สเทเฟน มาง ก้อง ดื้ง ลือ ชีเย. สเทเฟน มาง มู่งท่า ป่ากย่า แงน ฮูแล ปี่ ยาว พาจาว มาง ล่าที่ แน พระเยซู มางนา มย้าง ชีเย. พระเยซู พาจาว มาง ล่าปู่ ล่าม่า ป่ากย่า จูง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ยาว สเทเฟน จี่ เย นี้แม้แน, “ฮู ปาว! กงา มู่ง พองอ่อก นา มย้าง แอ. แน พระเยซู พาจาว มาง ล่าปู่ ล่าม่า ป่ากย่า จูง ชี.” ");
INSERT INTO bzi_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","แฮ้เมอ เวอ ชฺ้าง มู อือ โฮ้กฮ้าว ล้า คู ชีเย อางเซงป้าดจาแช เย. ยาว ล่าปู่ ย่าง น่าซื่ง เวอ วาบ แล่ คู ยาว สเทเฟน ก้อง ฮื่น แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ยาว สเทเฟน นา อางเมิง อางเง้ เวอ เซฺ่อ แอ ยาว ลอบา จาน ชีเย. ชฺ้าง สเทเฟน นา อางซีอางแล จี่กาน คูชี อืม ยอง ค่าลาว อางเง้ ตูมเซฺ่อ ย่าง แล อ่อก แล่ คู ชี. ยาว ค่าพ่าย่า ย่าค่า อางเม้ง เซาโล แน ชี่ มาง ล่าคื่อ ก่องทาง โย้เวอ โบย ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","แฮ้แม้ยาว ชฺ้าง มู อืม สเทเฟน มางนา ลอบา ย่าง ช้อนกา จาน ชีเย. แฮ้เมอเวอ สเทเฟน นี้แม้แน อธิษฐาน ฮา ชีเย, “พระเยซู จี่วีดอางซื้ง มาง เวอ, กงา อางค่องอางล้า มางนา ลือ ล่า ล่าปาว.” แน. ");
INSERT INTO bzi_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ยาว สเทเฟน มือ ป่าตูคู ยาว อางเซง บื้ง แน ฮ้าว ชี นี้แม้แน, “จี่วีดอางซื้ง มาง เวอ, นี้เทอ ยอง อางซี ฮา ชี นี้ย่า ยองนา อางบล่าบ บ่าปี่ จา ปี่ โจ เป!” แฮ้แม้ จี่ เปิน ยาว สเทเฟน มือ ซฺี้ กา ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","สเทเฟน นา แซ่ ชี่นี้ เซาโล มาง อางแบ อางมย้าง ย้าเย่. แน สเทเฟน นา แซ่ ชี่ นี้ย่า ยา อางซอ เย. แฮ้ญ่ามเมอ เยรูซาเล็ม อางเมิง โย้เวอ นาบาตา เย ชฺ้าง พระเยซู นา เจ่อ ชี่ อือนา ฮาก ก่า คูแง, ยองนา ฮาก บ่าโลง เย. แฮ้แม้ยาว ยองมู ย้าง กามาง กาตี่ เย เปิดเลิ้น แอ้น ชี. ยูเดีย แควน แน สะมาเรีย แควน อือเมอ แอ้น ชีเย. จ้า ศิษย์เอก อือ เกิ้งเกิ้ง บ่าแอ เย. ");
INSERT INTO bzi_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ชฺ้าง มู พาจาว มางนา ปีนแตปีนนา แน เจ่อ ชี่อือ สเทเฟน ศพ ย่าง พูม ยาว สเทเฟน นา อู้ง ซฺ้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","จ้า เซาโล ม้า ชฺ้าง พระเยซู นา เจ่อ ชี อือนา, ยอง ยู้ม คล้าว อือเมอ อ้อง ชู แลยาว คอก ชู ล้อง แล ชี ตื่ง ค่าพ่าย่า ค่าบาย่า อือนา โค ย้า ชู ชี. ");
INSERT INTO bzi_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ชฺ้าง พระเยซู นา เจ่อ ยาว เปิดเลิ้น กว่า ชี อือย่า, ยอง จาดื้ง ชี โย้เวอ พาจาว มาง อางเลิ่ง อางแม่น ย่าง ม่าอู่บ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ยาว ฟีลิป ม้า สะมาเรีย แควน อางเมิง ทื่อ เมิง โย้เวอ แลน ชี. ยาว โย้เวอ พระเยซูคริสต์ อางเลิ่ง ย่าง ชฺ้าง อือนา ม่าอู่บ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ชฺ้าง มู อือ ฟีลิป ม่าอู่บ แฮ้งนา กงากย่า ยาว, แน ยาง อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮา แฮ้ง กงามย้าง ยาว ปีนแตปีนนา ย้า ดื้ง น้า คู ชี. ");
INSERT INTO bzi_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ยาว ยา แด่ย่า ชฺ้าง ก้อง อ้อง ชี อือนา ก่า ชี. ยาว แด่ย่า อืมมือ อางเซง บื้ง แน โฮ้กฮ้าว อ่อก คู ชีเย. ชฺ้าง ล่าปู่ ล่าคื่อ อางง่อย แน ชฺ้าง ต่องแก่ อือนา คาตา ย้า ยา โปยว ปี่ ชี่. ชฺ้าง นี้อือ นา ยา ชี นี้ย่า อางบย่า ย้า. ");
INSERT INTO bzi_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","แฮ้แม้ยาว อางเมิง แฮ้มาง ก้อง ชฺ้าง อืม ม่อนซ้า จาบื่อดื้งบื้อ ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ค่าพ่าย่า ทื่อม่าง จา ชีเย อางเม้ง ซีโมน แน. ยา อางเมิง แฮ้เมิง ก้อง ดื้ง ล้า มล่าง กาชา เย, แน ยา ก่าทา เล่น ยาว นาบาตา เย่ ก่าทา อางเลิ่ง แฮ้ง คี่ แง. สะมาเรียชฺ้าง อือ บลื่ง แอ เคอ ย้าเย่. ยา ชฺ้าง อางฮื่อ ล่าที่ อางจา มาง แน ฮาจ่าแล่ง เย. ");
INSERT INTO bzi_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ค่องช่าง คาโคลาโค ชฺ้าง อางตูกอางพาน จาย ชฺ้าง อางจาอางปาง ยศ อางฮื่อ อางมอง เวอ เคอ อือ ยางนา นาบาตา ซอ คูแง. ยาว นี้แม้แน จี่กาง เย, “ค่าพ่าย่า นี้ม้า พาจาว มาง ล่าที่ อางเม้ง ‘ล่าที่ อางบย่า’ แน ชี่ ย้าง จา แง” ");
INSERT INTO bzi_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ซีโมน ยา ก่าทา อางเลิ่ง อือ แบ มล่าง กาชา เย. แฮ้แม้ยาว ค่องช่าง อือ ยางนา ซอ คูง เย. ");
INSERT INTO bzi_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","จ้า ฟีลิป พาจาว มาง อางเลิ่ง ย่าง ยองนา ม่าอู่บ ยาว แน พระเยซูคริสต์ ล่าที่ ย่าง ยองนา ม่าอู่บ แบ ปี่ ยาว, ค่องช่าง อืมมือ พระเยซู นา เจ่อ คู ชี, ยาว ตื่ง ค่าพ่าย่า ค่าบาย่า ย้า ล้างตือพิธีบัพติศมา ฮา แล่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ซีโมน คาตา เย พระเยซู นา เจ่อ ชี. แฮ้แม้ยาว ยาง ล้างตือพิธีบัพติศมา ฮา แล่ยาว ยาง มือ ฟีลิป ก้อง กูต่องกูตี่ ย้า เค่ กว่า ชี. แน ฟีลิป มาง อางเลิ่งชฺ้างบ่าฮาตอกางอือ ฮายฮู ปี่ เมอ ยางมือ บลื่ง ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ยาว ศิษย์เอก เยรูซาเล็ม อางเมิง โย้เวอ ดื้ง อืม แบน ชีเย. สะมาเรียชฺ้าง อือ พระเยซู นา เจ่อ คูชี แน. แฮ้แม้ยาว ยองมือ เปโตร แน ยอห์น เย่ดนา ซฺาแอ ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","เปโตร แน ยอห์น เย่ด โย้เวอ เคอ แอ ยาว. เย่ดมือ สะมาเรียชฺ้าง พระเยซู นา เจ่อ ชี อือนา อธิษฐาน ฮาย ปี่ง เย, ยองมู นา อางค่องอางล้า อางเซฺิ่งอางซฺ้าง กงาบู้ ปี่ แงแน. ");
INSERT INTO bzi_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ชฺ้าง นี้มู พระเยซู นา เจ่อ ยาว ล้างตือพิธีบัพติศมา ฮา แล่ คู ชีเย, จ้า อ่าซ่าง มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง บ่ากงาบู้ กาซื้ง เย. ");
INSERT INTO bzi_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ยาว เปโตร แน ยอห์น เย่ด มือ ยองมู อางตู่ เวอ ล่าปู่ โบย ยาว, ยองมู คาโคลาโค ย่างมือ อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ย่าง กงาบู้ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ซีโมน มือ ศิษย์เอก อือ ค่องช่าง อือ อางตู่ โย้เวอ ล่าปู่ ย่าง โบย ยาว, ชฺ้าง อือ อางค่องอางล้า อางเซฺิ่งอางซฺ้าง กงาบู้ ชี แน มย้าง เมอ. ซีโมน มือ ยาง พลู้ ย่าง ศิษย์เอก อือนา ฮ้าน ปี่ ชี่เย. ");
INSERT INTO bzi_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ยาว นี้แม้แน จี่ เย, “กงานามมือ ล่าที่ นี้แม้แน จา ปี่ ล่าปาว, ยาว กงามมือ ชฺ้าง อือนา ยอง อางตู่ โย้เวอ ล่าปู่ โบย ยาว, ยองนา อางค่องอางล้า อางเซฺิ่งอางซฺ้าง แฮ้ง กงาบู้ ปี่ง แงแน.” ");
INSERT INTO bzi_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","จ้า เปโตร ซีโมน นา อี่จ้าด ชี นี้แม้แน, “นา พาจาว มาง ล่าที่ แฮ้งนา อางวื้อ กงากา แน เย้ง แง. แฮ้แม้แนยาว นาง อางโต แน นาง พลู้ นี้ง จี้บ โค โว! ");
INSERT INTO bzi_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","พาจาว ม้า อางแบ นาง นืงบา นี้ย่า บ่าซือบ่าปลอง แน. แฮ้แม้แนยาว นา ล่ากาน นี้ง บ่ากงา ว่า กาน. ");
INSERT INTO bzi_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","นี้แม้แนยาว นาย่า นืงบาเพ่น อางบล่าบ ฮา แฮ้ง ว่าง โว. ยาว พาจาว มางนา อธิษฐาน ฮา ป้า โว. กาเทอกา พาจาว ม้าย่า นางนา อางซีอางบล่าบ บ่ายู่ ล่า นาตู้. ");
INSERT INTO bzi_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","กงา อางมย้าง ย้า นาง นืงบา นี้ย่า อางบล่าบ แน อางเลิ่ง เจอค้อย อือ ปลื้ง ย้า จา แง.” ");
INSERT INTO bzi_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","แฮ้แม้ยาว ซีโมน มาง นี้แม้แน จี่ พอ ชีเย, “กงานา นาง จี่ แม้แน บ่าปี่ เพล่อ ล่า โจ. แฮ้แม้ยาว ไน้ย่า กงานา, พาจาว มางนา อธิษฐาน ฮา ป้า ปี่ ล่าปาว, กงานา ปล่อง ล่าว แน.” ");
INSERT INTO bzi_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ยาว โย้เวอ เปโตร แน ยอห์น เย่ด พาจาว มาง อางเลิ่ง อางแม่น แฮ้ง ม่าอู่บ เปิน ยาว, เย่ด มือ เยรูซาเล็ม อางเมิง โย้เวอ พ่าวแอ้น แล่ ชีเย. แน เย่ด แก้บ้า ย่อ แอ เมอ สะมาเรีย แควน โย้เวอ ไล ค่อง ย้า พระเยซู อางเลิ่ง อางแม่น ย่าง ป่าว ม่าอู่บ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","จี่วีดอางซื้ง มาง เท่วาด่า ทื่อองค์ มาง ฟีลิป นา จี่ช่าง ชี นี้แม้แน, “ต่องปี่ ป่ากย่า ย่อ แอ้น ปาว. แก้บ้า นี้กย้า แอ้น ปาว เยรูซาเล็ม อางเมิง จาย กาซา อางเมิง เวอ เคอ” แน. (แก้บ้า แฮ้ม้า ตี อางกืออางคาก เจิ้นเจ้อ บ่าจา เย.) ");
INSERT INTO bzi_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","แฮ้งเย่ ฟีลิป ย่อ แอ ชี. โย้เวอ ค่าพ่าย่า เอธิโอเปีย ชฺ้าง ทื่อม่าง จา ชีเย. ยา เอธิโอเปีย ก่าซ้าด มาง ราชินี มาง ย่าเจ่น เย. ยา ขันที เพล่อ ยาว ค่าบาย่า นี้มาง อางเกิ่งอางก้อ คาโคลาโค แฮ้ง ฮูพลา ปี่ แง. ยา เยรูซาเล็ม อางเมิง โย้เวอ พาจาว มางนา ไว้ จายลือ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ยาว อ่าม่อง ไค่ลอ ตา ยู้ม พ่าวแอ แล่เมอ. ยา พาจาวจี่ต่างจี่แต่นฮู อิสยาห์ มาง ปาบ ย่าง อ้าน ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ยาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ฟีลิป นา นี้แม้แน จี่ช่าง ชีเย, “อ่าม่อง ไค่ลอ แฮ้ กาน ก้อง แท้ แน อ้องแล โว.” ");
INSERT INTO bzi_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ฟีลิป มือ อ่าม่อง ไค่ลอ แฮ้กาน ก้อง แท้ แน ฮื่น อ้อง แลน ชีเย. ยาว ยา ค่าพ่าย่า มาง พาจาวจี่ต่างจี่แต่นฮู อิสยาห์ มาง ปาบ อ้าน อางเซง ย่าง กงากย่า ชีเย. แฮ้แม้ยาว ฟีลิป มือ นี้แม้แน น้า ชีเย, “นาง ปาบ อ้าน แท้ น้า อางแบ กงา ไก ลา?” ");
INSERT INTO bzi_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ค่าพ่าย่า มาง นี้แม้แน พอ ชีเย, “ล้อแม้ แบ กงากา แน อ่าซ่าง มาง บ่าม่า แบ ปี่ ล่า น่อ.” ยาว ยาง ฟีลิป นา ยาง อ่าม่อง ไค่ลอ เวอ ทื่งกง่า แน ฮ้าว ตา ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","นี้ย่า พระคัมภีร์ เวอ อางไล่ ค่าพ่าย่า มาง อ้าน ชีย้าง นี้แม้แน, “ยางนา ชู ชี แกะ นา ชู แซ่ แม้แน. ยา ทื่อก่าม แนม บ่ากงา จี่. ยา แกะอางย่า ชฺ้าง อางมื่อต่อนฮู มาง ล้าก้า โย้เวอ นี้ม แน จา ชี แม้แน เพล่อ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ยางนา ฮาก ฮาย ซฺ่าจอ แมก่าก่อง แล่ ปี่ แง. แน อางเลิ่ง อางกง่าอางเกิง อือ บ่ากงา ลาบ. ยา อางย่าอางคย้า อางอ่านอางซฺื้อ บ่าจากื้ง แน ซฺี้ แอน ญา, อามือ ยา ชฺ้างอางเมิง นู้เวอ บ่าจา กาน.” ");
INSERT INTO bzi_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ค่าพ่าย่า ขันที มาง ฟีลิป นา นี้แม้แน น้า ชีเย, “ม่า ล่าวแล พาจาวจี่ต่างจี่แต่นฮู ม้า ยาง อางโต แฮ้งนา จี่เคอ จ่าแล่ง ลา อ้าว ฮากนา จี่เคอ แง?” ");
INSERT INTO bzi_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ยาว ฟีลิป มือ พระคัมภีร์ นี้ข้อ ก้อง ต่องก่าต่าง จี่ ชี. แน พระเยซู อางเลิ่ง อางแม่น ย่าง ค่าพ่าย่า ขันที มางนา อู่บน้า ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","เย่ด แก้บ้า เวอ อ่าม่อง ไค่ลอ ตาล้า เมอ ตี ทื่อตี่ ล้าง อางจา นา มย้าง ชีเย. ค่าพ่าย่า ขันที มาง นี้แม้แน จี่ ชี, “ล้าง ย้าง โย้เวอ จาน ญ้า. กงา ล้างตือพิธีบัพติศมา ฮา แล่ อางกงา ย้าลา?” ");
INSERT INTO bzi_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ยาว ฟีลิป มือ นี้แม้แน พอ ชีเย, “นาง นืงบา โค แน เจ่อ ยาว, ล้างตือพิธีบัพติศมา ฮา แล่ อางกงา ย้า.” ค่าพ่าย่า ขันที มาง นี้แม้แน พอ ชีเย, “กงา อางเจ่อ ย้า พระเยซูคริสต์ ย่า พาจาว มาง อางย่า” แน. ");
INSERT INTO bzi_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ยาว ค่าพ่าย่า ขันที มาง อ่าม่อง ไค่ลอ ย่าง ม่า จ่อด ปี่ ชี่. ยาว ฟีลิป เย่ดมือ ล้าง คล้าว โย้เวอ ลู่งแอ ชี. ยาว ฟีลิป มือ ค่าพ่าย่า ขันที มางนา ล้างตือพิธีบัพติศมา ฮา ปี่ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","แฮ้แม้ยาว เย่ด ล้าง เวอ ซฺื่ยกา อ่อกล้า ชีเย. ยาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ฟีลิป นา ซฺื่ยแล ชีเย. แฮ้แม้ฮายยาว ค่าพ่าย่า ขันที มาง ฟีลิป นา แมก่า บ่ากงา มย้าง แล่ เย. ยาว ค่าพ่าย่า ขันที มาง กย่าง เย แน แก้บ้า ย่อ แล แล่ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ยาว ฟีลิป อาโซทัส อางเมิง โย้เวอ เคอ ล้า ชี. พระเยซู อางเลิ่ง อางแม่น แฮ้ง อางเมิง กูเมิง ต้าว ย้า ป่าว กว่า ชี, ซีซารียา อางเมิง โย้เวอ เคอ ย้า. ");
INSERT INTO bzi_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","แฮ้ญ่าม เวอ เซาโล ย่า ชฺ้าง พระเยซู นา เจ่อ ชี อือนา แซ่ แงแน จี่แค ปี่ ชีเย. ยา ปุโรหิต อางฮื่อ เลิ่นเลิ่น มางนา ซฺ้าแอ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","โจ้ดมาย แต้ม ปี่ล่าว แน ป้า แอ ชี. โจ้ดมาย นี้ ดามัสกัส อางเมิง ยิวชฺ้าง โบสถ์ อือเมอ ยอคา อือนา ฮู ปี่ง เย. ยาว ชฺ้าง พระเยซู นา เจ่อ อือนา ตื่ง ค่าพ่าย่า ค่าบาย่า ย้า ชู ยาว เยรูซาเล็ม อางเมิง โย้เวอ ซฺื่ย โตด ลาบ ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","เซาโล ดามัสกัส อางเมิง โย้เวอ แก้บ้า ย่อ ชา เคอ แอ เมอ, มู่งท่า โย้เวอ ซฺ้อก ย้า แปล้น ลือ ชี. ยาง อางโต โย้เวอ แปล้น แน แวด ชี. ");
INSERT INTO bzi_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ยาว เซาโล มือ นื้งชฺ่า เวอ เลิง แอ้น ชี. ยาว จี่เซง กงากย่า ชี นี้แม้แน, “เซาโล เวอ เซาโล เวอ นา บ้าเจอ ฮาย กงานา คาม ล่าง?” ");
INSERT INTO bzi_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","เซาโล มือ นี้แม้แน พอ ชีเย, “นา อ่าซ่าง?” ยาว อางเซง พอ ลือ ปี่ ชี่, “กงา เยซู นาง เค่คาม ล่าชี มาง ย้า, ");
INSERT INTO bzi_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ทานล้า ยาว ดามัสกัส อางเมิง โย้เวอ อ้องแลน ปาว. โย้เวอ ชฺ้าง จา แง นางนา ม่า ล่าง นา บ้าเจอ กงา ฮา แงแน.” ");
INSERT INTO bzi_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ชฺ้าง เซาโล ก้อง เค่ ล้า ชี อือ จี่เซง แฮ้งญา เย่ กย่า คู ชี, จ้า ชฺ้าง จี่ มางนา บ่าฮู มย้าง กาเย. แฮ้แม้ยาว ยองมู ย้าง นืงบาม่าน เจิ้นเจ้อ บ่าจี่อ่อก กาเย. ");
INSERT INTO bzi_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","เซาโล ทาจูง ล้า ยาว, แมนือ ย่าง เจิ้นเจ้อ นา บ่าฮูมย้าง กาเย. แฮ้งเย่ ชฺ้างมู อืม เซาโล นา ดามัสกัส อางเมิง โย้เวอ ซฺื่ย ชื้ง แลน ชี. ");
INSERT INTO bzi_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","เซาโล เจิ้นเจ้อ นา บ่าฮูมย้าง กาแน เจิ้นเจ้อ บ่ากงาจฺ่า บ่ากงาต้าง แน 3 นืง เย. ");
INSERT INTO bzi_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ดามัสกัส อางเมิง คล้าว โย้เวอ พระเยซู นา เจ่อ มาง จา เย, ยาง อางเม้ง อานาเนีย แน. แมบืน คล้าว โย้เวอ จี่วีดอางซื้ง มาง ยางนา นี้แม้แน จี่ช่าง ชี นี้แม้แน, “อานาเนีย เวอ” ยาง พอ ชี นี้แม้แน, “จี่วีดอางซื้ง มาง เวอ กงา นู้เวอ เป.” ");
INSERT INTO bzi_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","จี่วีดอางซื้ง มาง ยางนา นี้แม้แน จี่ช่าง ชีเย, “ทานล้า ยาว แก้บ้า อางเม้ง อางปลอง แน ชี โย้เวอ แล ปาว. ยาว ยูดาส ยู้ม โย้เวอ อ้องแล โว! ค่าพ่าย่า อางเม้ง เซาโล ทาร์ซัส ชฺ้าง มางนา น้า ซฺ้า แล โว! อามือ ยา อธิษฐาน ฮา แง. ");
INSERT INTO bzi_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ยาว เซาโล มาง ทื่อช่างกานญา แมบืน บืน มย้าง ชี. ค่าพ่าย่า ทื่อม่าง จา ชีย้าง อางเม้ง อานาเนีย แน ยา ยู้ม คล้าว เวอ อ้องล้า ชี. ยาว ยาง อางโต เวอ ล่าปู่ โบย ชี, ยางนา ฮาย ทื่อเทอ ฮูมย้าง ปี่ แง” แน. ");
INSERT INTO bzi_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","อานาเนีย นี้แม้แน พอ ชีเย, “จี่วีดอางซื้ง มาง เวอ, กงา กงากย่า ย่า ชฺ้าง อางบย่า จี่ กาแง. ค่าพ่าย่า นี้ม้า นาง ชฺ้าง เยรูซาเล็ม อางเมิง คล้าว โย้เวอ ดื้ง อือนา อางเลิ่ง บ่าแม่น ฮา ชีแน. ");
INSERT INTO bzi_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ยา ปุโรหิต ยอคา อือก้อง ล่าที่ กงา ชี. นู้เวอ ชฺ้าง คาโคลาโค นางนา นืงบาชี ล่าง อือนา ชู แง” แน. ");
INSERT INTO bzi_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","จ้า จี่วีดอางซื้ง มาง อานาเนีย นา นี้แม้แน ม่า ชีเย, “แอ ปาว ค่าพ่าย่า นี้มางนา กงา แช้ยู้ ย่า. ยา กงา อางเลิ่ง อางแม่น นี้ง กงา ป่าว กว่า แง. ยิวชฺ้างบ่าอ่า อือนา แน ก่าซ้าด มู อือนา แน อิสราเอล ค่องช่าง อือนา กงาม่า แบ ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ยาว กงาย่า เซาโล นา ฮายแบ ปี่ แน. ยา กงา ปาปาย อางตูกอางพาน อาล้อม้อก กงา โอ้ด แง แน.” ");
INSERT INTO bzi_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ยาว อานาเนีย มือ แอ้น ยาว ยู้ม คล้าว เวอ อ้องแล ยาว, ยาง ล่าปู่ ย่าง เซาโล อางตู่ เวอ โบย ยาว นี้แม้แน จี่ ชี, “เซาโล เวอ, พระเยซู นางนา มย้าง ปี่ ล่า ชี มาง. นาง แก้บ้า ย่อ ล้า เมอ กงานา ซฺาล้า ปี่ ล่าง. นางนา ฮาย ทื่อเทอ มย้าง ปี่ ล่าง. แน นางนา ฮาย อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ปลื้ง แน จา ปี่ ล่าง.” ");
INSERT INTO bzi_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ยาว ม้างม้าเจ้อ จา เย ทื่อเจ่อ อางเกด แม้แน เซาโล แมนือ เวอ ซฺ้อก เย อ่อก ลือ ชี. ยาว เซาโล มือ ทื่อเทอ มย้าง ล้า แล่ ชีเย. ยาว ยาง ทานล้า ยาว ล้างตือพิธีบัพติศมา ลาบ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","แน ฮ่างจฺ่า เปิน ยาว ยาง แฮ่งจา แก่นคา ล้าชี. ยาว เซาโล มือ ดามัสกัส อางเมิง คล้าว โย้เวอ พระเยซู ศิษย์ อือก้อง ไลนืง ย้าเย่ ซ่าว ดื้ง ชี. ");
INSERT INTO bzi_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ยาว ยาง ซฺ้อก ย้า ยิวชฺ้าง โบสถ์ โย้เวอ พระเยซู อางเลิ่ง อางแม่น ย่าง ป่าว แล ชี. ยา นี้แม้แน จี่ เย, “พระเยซู ยา พาจาว มาง อางย่า” แน. ");
INSERT INTO bzi_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ชฺ้าง คาโคลาโค เซาโล แฮ้แม้ จี่ นา กงากย่า ยาว นืงบาม่าน คูง แง. ยาว นี้แม้แน จี่ กางเย, “ชฺ้าง นี้มาง บ่าอ่า ลา เยรูซาเล็ม อางเมิง โย้เวอ ชฺ้าง เยซู นา เจ่อ อือนา เค่คาม ชี ม้า? แน ยาง นู้ ล้า ชี นี้ย่า ชฺ้าง แฮ้อือ นา ชู ยาว ปุโรหิต ยอคา อือนา ปี่ แงแน บ่าอ่า ลา?” ");
INSERT INTO bzi_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ยาว เซาโล ม่าอู่บจี่ต่าง นี้ย่า ล่าที่ จา เค่ เย. แน ยิวชฺ้าง ดามัสกัส อางเมิง ดื้ง อือนา ฮาย มย้าง ปี่ ชี่, พระเยซู ย่า พาจาว มาง ชฺ้างอางเมิง นู้เวอ ก่าซ้าด แช้ เพล่อ ปี่ ชี่ มาง ย้า แน. แฮ้งย้า ยิวชฺ้าง มู อืม เจิ้นเจ้อ บ่าจี่เจ้ แล่ตอ กาเย. ");
INSERT INTO bzi_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ไลนืง ปูน ชีช่า ยาว ยิวชฺ้าง อือ กื้ดคาน เซาโล นา ชา แซ่ คู เย. ");
INSERT INTO bzi_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","จ้า เซาโล แบออน แบ ชีเย. ยองมู ย่าง อางเมิง ล้องก้อ เวอ ค่าวจอ ยาว เซาโล นา ล่อ แซ่ ชี ตื่ง มู่งคี่ นืงก้อง ย้าเย่. ");
INSERT INTO bzi_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","จ้า พระเยซู นา เจ่อ อือ เซาโล นา มู่งคี่ เวอ ค่าว ซฺื่ย ฮื่น ชีเย. ยองมู ย่าง เซาโล นา ซ้าล้อง อางฮื่อ คล้าว โย้เวอ ดื้ง ปี่ ยาว กล่ามกล่าม แน อางเมิง ก้ามทื้อ เวอ คลา ลู่งแอ ปี่ ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","เซาโล เยรูซาเล็ม อางเมิง โย้เวอ เคอ ลือ ยาว. ยาง พระเยซู นา เจ่อ อือ ก้อง ทื่งกง่า แน ดื้ง แล ชี. จ้า ยอ แค คูง แน บ่าเจ่อ คู เย เซาโล พระเยซู นา ม้าม้า แน เจ่อ ชีแน. ");
INSERT INTO bzi_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","จ้า บารนาบัส ย่า เซาโล นา ศิษย์เอก อือก้อง ซฺื่ย แอ้น ยาว อู่บน้า ปี่ ชี่ เย. แก้บ้า ย่อ เมอ เซาโล จี่วีดอางซื้ง มางนา ล้อแม้ กงามย้าง ชี, แน ยางนา บ้าเจอ จี่ช่าง ชี แน. บารนาบัส อู่บ แล่ง เย ดามัสกัส อางเมิง โย้เวอ จาดื้ง เมอ เซาโล พระเยซู อางเลิ่ง อางแม่น แฮ้ง ม่าอู่บ ชี เจิ้นเจ้อ นา บ่าแค แน. ");
INSERT INTO bzi_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ยาว พระเยซู ศิษย์เอก มู อืม เซาโล นา ทื่งกง่า แน ดื้ง ปี่ ชีเย. แฮ้แม้ยาว เซาโล มือ เยรูซาเล็ม อางเมิง โย้เวอ ดื้ง ชี. แน พระเยซู อางเลิ่ง อางแม่น แฮ้ง ต้าว ย้า ม่าอู่บ กว่า ชี เจิ้นเจ้อ นา บ่าแค แน. ");
INSERT INTO bzi_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","เซาโล ยิวชฺ้าง กรีก ต่าง จี่ อือนา จี่เจ้ ช่าง ชีเย. แฮ้งย้า ยองมู ย้าง เซาโล นา ชา แซ่ คูง แง. ");
INSERT INTO bzi_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","พระเยซู นา เจ่อ อืม นี้เลิ่ง แบ ยาว ยองมู ย้าง เซาโล นา ซีซารียา อางเมิง โย้เวอ ซฺื่ย ล้องตา แอ้น ชีเย. ยาว ทาร์ซัส อางเมิง โย้เวอ ซฺาแอ ปี่ ชี่ เย. ทาร์ซัส ค่อง นี้ย่า เซาโล ค่อง เกิ้ด ชี ย้างย้า. ");
INSERT INTO bzi_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","แฮ้แม้ฮายาว ชฺ้าง คาโคลาโค พระเยซู นา เจ่อ คูชี อือ ยูเดีย แควน กาลิลี แควน แน สะมาเรีย แควน จา ดื้ง คูชี อืม จาบื่อดื้งบื้อ เย จา คู ชี. ยองมู นี้ย่า จี่วีดอางซื้ง มางนา นาบทื้อ คูง เย. แฮ้แม้ฮายาว ยองมู ย้าง อางอ้าน ย่าง ล่อบ่าปา เย่ พระเยซู นา เจ่อ แลน แล่ คู ชี. แน อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ม้า ยองนา ปล่อง เย. แฮ้งย้า ชฺ้าง พระเยซู นา เจ่อ ชีอืม บย่า เค่ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","เปโตร กูต่องกูตี่ ต้าว แน แล เมอ, ยาง ลิดดา อางเมิง โย้เวอ แลน ชี. ชฺ้าง พระเยซู นา เจ่อ ชี อือนา บ่อ ซฺ้า แล ชี. ");
INSERT INTO bzi_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","แน ยา โย้เวอ ค่าพ่าย่า ทื่อม่าง นา มย้าง ชี อางเม้ง ไอเนอัส แน. ยา ต่องแก่ เพล่อ ยู่ป่าม เวอ ยู่ ล้า 8 ปี เคอ ชา เย่. ");
INSERT INTO bzi_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","เปโตร ยางนา จี่ช่าง ชี นี้แม้แน, “ไอเนอัส เวอ, พระเยซูคริสต์ นางนา พ่าญาด ยา โปยว ปี่ ล่างญา! ทานล้า ยาว ยู่ป่าม กอ ปาว!” ยาว ไอเนอัส ม่าง ซฺ้อก ย้า ทานล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ยาว ชฺ้าง คาโคลาโค ลิดดา อางเมิง แน ชาโรน อางเมิง โย้เวอ จา ดื้ง ชี อืม, ไอเนอัส นา มย้าง ยาว ยองมู ย่าง จี่วีดอางซื้ง มางนา เจ่อ คู ชี. ");
INSERT INTO bzi_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ยัฟฟา อางเมิง โย้เวอ ค่าบาย่า พระเยซู นา เจ่อ มาง ทื่อม่าง จา เย. ยาง อางเม้ง ทาบิธา แน, ฮีบรู ต่าง เย. จ้า กรีก ต่าง นี้ โดรคัส แน ฮ้าว แง. ยา อางเลิ่ง อางแม่น อางเลิ้ง กาเย ฮา แง. แน ชฺ้าง อางตูกอางพาน นา อางเกิ่ง เปิ่ง ปี่ แง. ");
INSERT INTO bzi_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","แฮ้ญ่าม ยา ด้ากย้าง ซฺี้ ชี ยาว ยู้มต่องยู้มทาง ชฺ้าง อืม ยาง ศพ ย่าง ล้างคล่าว ปี่ ชี่ ยิว อางลี้บอางล่าว แม้แน. ยาว อางฮ้อง อางท่า เวอ ชี แล ยาว ล่อ พูม เย. ");
INSERT INTO bzi_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ยาว ลิดดา อางเมิง นี้ย่า ยัฟฟา อางเมิง โย้เวอ อางแท้ เย. พระเยซู นา เจ่อ อือ เปโตร ลิดดา อางเมิง โย้เวอ ดื้ง ชี แน กงากย่า ยาว, ยองมู ย้าง ค่าพ่าย่า 2 คู่น ซฺาแอ ป้า ปี่ ชี่ นี้แม้แน, “กงู ก้อง อางไว่ แน เค่ ล้า ปาว!” ");
INSERT INTO bzi_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","แฮ้แม้ยาว เปโตร มาง ค่าพ่าย่า ม่าง เย่ด ก้อง เค่ แล ชีเย. เคอ แล ยาว เย่ด มือ เปโตร นา อางฮ้อง อางท่า เวอ ซฺื่ย ตาแลน ชีเย. แมม้าย มู อือ เปโตร ก้อง จูง อู้ง แวด คู ชีเย. ยาว ค่าลาว อางเง้ ตูมเซฺ่อ แน อางก่าอางตูม โดรคัส แมม้าย อือนา เพิด ปี่ ชี่ ย้าง ม่ายฮู ปี่ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","เปโตร ชฺ้าง คาโคลาโค อือนา ม่า อางฮ้อง อางเง้ เวอ อ่อกแอ ปี่ ชี่ เย. ยาว ยาง ทื่อม่าง แน ป่าตูคู อธิษฐาน ฮาย ป้า ชี. ยาง แมก่า ย่าง ศพ จา ป่ากย่า พลาบ แอ ปี่ ยาว จี่ ชี นี้แม้แน, “ทาบิธา ทานล้า ปาว!” โดรคัส ม่าง ซฺ้อก เย แมนือ ย่าง พอง ล้า ชี. แน เปโตร นา ฮูมย้าง ยาว ยาง ทาดื้ง ล้า ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","เปโตร แฮ้งเย่ โดรคัส นา ล่าปู่ ชู ทาจูง ล้า ปี่ ชี่. ยาว ชฺ้าง พระเยซู นา เจ่อ ชี อือนา แน แมม้าย มู อือนา ฮ้าว อ้องล้า ปี่ ยาว ยองนา ฮาย มย้าง ปี่ ชี่ โดรคัส ซฺี้ ยาว แต่ล้า แล่ ชี่ แน. ");
INSERT INTO bzi_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","นี้เลิ่ง ยัฟฟา อางเมิง โย้เวอ จ่อด ย้า แบ โค ชี. แฮ้แม้ยาว ชฺ้าง อางบย่า เย จี่วีดอางซื้ง มางนา นืงบาชี ยาว เจ่อ ล้า คูชี. ");
INSERT INTO bzi_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","เปโตร ยัฟฟา อางเมิง โย้เวอ ไลนืง เย ดื้งแลน แล่ชี่. ซีโมน ซ้าดอางคอ ฟอก ซ้าล้า มาง ยู้ม โย้เวอ ดื้ง แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ซีซารียา อางเมิง โย้เวอ ตาฮ้าน นายร้อย ทื่อม่าง จา แง โรมชฺ้าง เย. แน อิตาลี กองพัน เวอ ตาฮ้าน มาง เย. อางเม้ง โครเนลิอัส แน. ยา กองร้อย ฮูพลาฮู มาง เย. ");
INSERT INTO bzi_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ยา ศาสนา ทื้อจ่า อางแม่น เย. ตื่ง ยาง อางโต แน ยาง ยู้มชฺ้าง อือ พาจาว มางนา นาบทื้อ คูง เย. ยา ชฺ้าง อางตูกอางพาน อือนา ปล่อง ยาว อางเกิ่งอางก้อ เปิ่ง ปี่ เย. แน พาจาว มางนา อางเลิ้ง กา ย้า อธิษฐาน ฮาย ป้า แง. ");
INSERT INTO bzi_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","แฮ้เมอ เวอ 3 โมง มู่งคี่ล้าก้า เวอ โครเนลิอัส แมบืนบืน ชี เจ้ง ย้าเย่. พาจาว เท่วาด่า ทื่อม่าง มาง ยางนา อ้อง จี่ช่าง ล้า ชี นี้แม้แน, “โครเนลิอัส เวอ.” ");
INSERT INTO bzi_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ยาว โครเนลิอัส พาจาว เท่วาด่า มางนา อางแค แน บลื่ง แน ฮู ยาว น้า ชี นี้แม้แน, “บ้าเจอ?” แน. แฮ้แม้ยาว พาจาว เท่วาด่า มาง ยางนา จี่ช่าง ชี นี้แม้แน, “พาจาว ม้า นาง อธิษฐาน ฮาย ป้า ย้าง กงากย่า ญา. แน ยา นาง ชฺ้าง อางตูกอางพาน นา ปล่อง อางเกิ่งอางก้อ เปิ่ง ปี่ แฮ้งนา นืงบาจาบ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","อามือ ยัฟฟา อางเมิง โย้เวอ ชฺ้าง ซฺาแอ ปี่ โว. ค่าพ่าย่า อางเม้ง ซีโมน ฮาก เปโตร แน ฮ้าว มางนา นางก้อง ซฺื่ยล้า โว. ");
INSERT INTO bzi_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ยา ซ้าดอางคอ ฟอก ซ้าล้า อางเม้ง ซีโมน แน ชี่ มาง ก้อง จาดื้ง แง. ยาง ยู้ม นี้ย่า ทะเล ก่องทาง โย้เวอ.” ");
INSERT INTO bzi_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","พาจาว เท่วาด่า ม่าง โครเนลิอัส นา จี่ช่าง เปิน ยาว เจิ่ก แล ชีเย. แฮ้งเย่ โครเนลิอัส ม่าง ยาง ยู้ม คล้าว โย้เวอ ย่าเจ่น อือนา 2 คู่น ฮ้าว ล้า ปี่ ชี่, แน ตาฮ้าน อางเก่ยอางเลิ้ง, ศาสนา นาบทื้อ อางแม่น ทื่อม่าง มางนา ยางก้อง ฮ้าวล้า ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ยาว ยาง อางเลิ่ง คาโคลาโค ตอล้า ชีย้าง ยองมู นา อู่บน้า ปี่ชี่ เย. แฮ้แม้ฮายาว ยองมู นา ยัฟฟา อางเมิง โย้เวอ ซฺาแอ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ทื่อนืง จายล้า แล่เมอ ยองมู ย้าง แก้บ้า ย่อ ยัฟฟา อางเมิง โย้เวอ ชาเคอ แล เมอ, แฮ้ญ่าม ย่า นืงก้องฮ่างจฺ่าญ่าม ชาเคอ กาชา เย่. ยาว เปโตร มือ ยู้ม ดาดฟ้า เวอ ตาแล อธิษฐาน ฮา แล ชี. ");
INSERT INTO bzi_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","เปโตร ฮ่างแบ่ ฮ่างจฺ่า ซี้ง เย. แฮ้ญ่าม เวอ ชฺ้าง ยู้ม คล้าว จา อือ ก่างพ่าแต่ง คูเมอ เปโตร มือ แมบื้น แม้แน มย้าง ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ยาว มู่ง ย่าง พองอ่อก นา มย้าง ชีเย. แน ม้างม้าเจ้อ มย้าง ชีเย. พ้า อางฮื่อ คลา ลู่งลือ ชี แม้แน จา เย. พ้า แฮ้ พื้น ย่า 4 แจ้ง แน พือ ยาว เทิง ชี ชีเย. ยาว กล่ามกล่าม แน ชฺ้างอางเมิง เวอ คลา ลือ ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","พ้า คล้าว โย้เวอ ซ้าด กูย่างกูเจ้อ ย้า จา แง. ตื่ง ซ้าด ต่อ โจง กว่า อือ แน ฮาย่า อือ เย. ");
INSERT INTO bzi_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","แน อางเซง นี้แม้แน จี่ เย, “เปโตร เวอ, ทานล้า ยาว ซ้าด นี้อือนา แซ่ จฺ่า โว!” ");
INSERT INTO bzi_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","เปโตร นี้แม้แน พอ ชีเย, “บ่ากงา เป จี่วีดอางซื้ง มาง เวอ. กงา ซ้าด อางโซอางซา โมเสส อางลี้บอางล่าว โย้เวอ บ่าปี่ จฺ่า อือ บ่าจฺ่า กางซื้ง.” ");
INSERT INTO bzi_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ยาว อางเซง แล่ง แน ทื่อเทอ จี่ แล่ง นี้แม้แน, “ม้างม้าเจ้อ อางเกิ่ง พาจาว มาง ฮา เซฺิ่งซฺ้าง ปี่ ยาว, นา บ่าเซฺิ่งบ่าซฺ่าง แน บ่าทื่อ กานโจ.” ");
INSERT INTO bzi_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","อางเลิ่ง นี้แม้แน 3 เทอ เย ตอล้า ชี. ยาว อางเกิ่ง คาโคลาโค ย่าง มู่งท่า โย้เวอ ซฺ้อก เย่ ฮ้าน พ่าวแลน แล่ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","เปโตร นืงบาม่าน ชี แมบืน แม้แน มย้าง ชี นี้ย่า บ้าเจอ นา ฮา แงแน. ยาว แฮ้ญ่าม เวอ ชฺ้าง โครเนลิอัส ซฺาล้า ปี่ ชี่ อืม ล้องก้อ ก้ามทื้อ ล้าก้า โย้เวอ จูง คู ชี, แน ซีโมน ยู้ม ย้าง น้า ซฺ้า ชี. ");
INSERT INTO bzi_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ค่าพ่าย่า แฮ้มู มือ ฮ้าว น้า ชี นี้แม้แน, “ซีโมน ฮาก เปโตร แน ฮ้าว แฮ้ม้า นู้เวอ ช่า ดื้ง” แน. ");
INSERT INTO bzi_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","เปโตร ยาง อางเลิ่ง แมบืนบืน ชีย้าง เย้ง จา เมอ, อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ยางนา นี้แม้แน จี่ช่าง ชีเย, “ค่าพ่าย่า 3 คู่น จา แง นางนา น้า ซฺ้า ล่าง. ");
INSERT INTO bzi_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ทานล้า ปาว อางอ่อก เวอ ลู่งแอ ปาว. กงา ยองนา ฮ้าว ล้า ปี่ แอ่. แฮ้แม้ยาว เจิ้นเจ้อ บ่าเย่ง กานโจ ยอง ก้อง เค่แอน โว.” ");
INSERT INTO bzi_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ยาว เปโตร ลู่งแอ้น ยาว ยองนา นี้แม้แน จี่ช่าง ชีเย, “นอง ชฺ้าง ซฺ้า กว่า ม้า, กงา ย้า บ้าเจอ เวอ?” ");
INSERT INTO bzi_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ยองมู ย้าง นี้แม้แน พอ ชีเย, “ตาฮ้าน นายร้อย โครเนลิอัส กงูนา ซฺาล้า ปี่ ล่าง. ยา ชฺ้าง อางแม่น พาจาว มางนา นาบทื้อ แง. แน ยิวชฺ้าง คาโคลาโค อือ ยางนา นาบทื้อ แง. พาจาว เท่วาด่า มาง ยางนา ม่า นางนา ป้า ล่ายาว ยาง ยู้ม โย้เวอ แล ปี่ ล่าง. นาง อางเลิ่ง อู่บ แฮ้ง น้า แงแน.” ");
INSERT INTO bzi_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","แฮ้แม้ยาว เปโตร ค่าพ่าย่า 3 คู่น อือนา ช่าง ยู้ม เวอ ซ่าวดื้ง ปี่ ชี่. ซอทา แปล้น ล้ายาว เปโตร มือ ยองก้อง เค่แลน ชี. แน ชฺ้าง ทื่อบ่า ยัฟฟา อางเมิง โย้เวอ พระเยซู นา เจ่อ อือ คาตา เค่แอน ชี. ");
INSERT INTO bzi_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ทื่อนืง จายล้า แล่ยาว ยองมู ย้าง ซีซารียา อางเมิง โย้เวอ เคอ ล้า ชี. แฮ้เมอ เวอ โครเนลิอัส มือ ยองมู นา ล่อ จา เย. ยาว โครเนลิอัส ม่าง ยาง ย่าช่างม้องน้าม แน อางช่าง อางเก่ยอางเลิ้ง กา อือนา คาตา ย้า ป้า ฮ้าว ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","เปโตร ยู้ม คล้าว โย้เวอ ชา ย่อ อ้องแล เมอ. โครเนลิอัส ม่าง มย้าง ยาว เปโตร ล่าคื่อ เวอ บอกไว้ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ยาว เปโตร โครเนลิอัส นา ชูทานล้า ปี่ ชี่ แน นี้แม้แน จี่ช่าง ชีเย, “ทานล้า ปาว กงา นอง แม้แน ชฺ้าง ทื่อช่างกานญา.” ");
INSERT INTO bzi_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","เปโตร โครเนลิอัส นา จี่ช่างปา แน ยู้ม คล้าว โย้เวอ ย่อ อ้องแล ชีเย. แน โย้เวอ ชฺ้าง อางบย่า ช้อนกาจา นา มย้าง แล ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","เปโตร ยองมู นา นี้แม้แน จี่ช่าง ชีเย, “นองมู นี้ อางแบ ย้า ยิวชฺ้าง อือ ยิวชฺ้างบ่าอ่า อือนา ซฺ้ามี นี้ย่า อางลี้บอางล่าว เวอ อางซี แน. จ้า พาจาว มาง กงานา ฮาย มย้าง ปี่ ล่าง. ฮากนา บ่าฮ้าว แจ ชฺ้าง บ่าเซฺิ่งบ่าซฺ่าง แน. ");
INSERT INTO bzi_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","แฮ้งย้า กงานา ชฺ้าง ลือ ฮ้าว ล่าเมอ, กงา เจิ้นเจ้อ บ่าจี่ แง. จ้า กงา อางอี้ น้า ล่าปานา นองมู นี้ย่า กงานา บ้าเจอ ฮา นา ฮ้าว ล้า ปี่ ล่าแง?” ");
INSERT INTO bzi_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","แฮ้แม้ยาว โครเนลิอัส มือ นี้แม้แน พอ เย, “4 นืง จาช่าง นู้เวอ 3 โมง มู่งคี่ล้าก้า อามื้อ นี้ญ่าม แม้แนย้า กงา ยู้ม คล้าว โย้เวอ อธิษฐาน ฮาจา เมอ, ค่าพ่าย่า ทื่อม่าง จา แง. ค่าลาว อางป่อน แปล้น บล่าบบล่าบ แน ตูม แล่ยาว กงา ล้าก้า โย้เวอ จูง ลือ แง. ");
INSERT INTO bzi_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ยาว กงานา นี้แม้แน จี่ช่าง ล่าง, ‘โครเนลิอัส เวอ, พาจาว มาง นาง อธิษฐาน ฮา ย่าง กงากย่า ญา, แน นาง ชฺ้าง อางตูกอางพาน อือนา อางเกิ่งอางก้อ เปิ่ง ปี่ แฮ้ง ซอ แง. แน นี้งย้า พาจาว มาง นางนา ปื้อ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","นางนา ม่า ล่าง ชฺ้าง ซฺาแอ ปี่ โว ยัฟฟา อางเมิง โย้เวอ. ซีโมน ฮาก เปโตร แน ฮ้าว มางนา ป้า ยาว นู้เวอ ฮ้าว ล้าน โว. ยา ซีโมน ซ้าดอางคอ ฟอก ซ้าล้า มาง ยู้ม ทะเล ก่องทาง โย้เวอ ดื้ง แง.’ ");
INSERT INTO bzi_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","แฮ้แม้ยาว กงาม ซฺ้อกย้า ชฺ้าง ซฺาแอ นางนา ป้า ยาว ฮ้าว แอ ปี่ ล่าแอ่. แน นาง ล้า ชี นี้ง นาบาตา ย้า ยี่นดี ฮา แง. อามื้อ กงูมู นี้ย่า พาจาว มาง ล้าก้า โย้เวอ ทื่งกง่า แน จา แง. จี่วีดอางซื้ง มาง จี่ต่าง นางนา จี่ ปี่ ล่าง แฮ้ง น้า คู แงแน.” ");
INSERT INTO bzi_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","แฮ้แม้ยาว เปโตร มือ ต่องก่าต่าง นี้แม้แน จี่ ชีเย, “อามื้อ กงา แบ ตืกตืก คางญา พาจาว ม้า อ่าซ่าง มางนา แมก่า บ่าชี่ แน. ");
INSERT INTO bzi_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ยา ชฺ้าง กูเจ้อกูจาด ยางนา นาบทื้อ อือนา ยาง ชฺ้าง เพล่อ ปี่ง. ");
INSERT INTO bzi_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","แน อางเลิ่ง อางแม่น อิสราเอลชฺ้าง อือนา พาจาว มาง ปี่ ชี่นี้ นองมู นี้ง อางแบ คูย้า. พาจาว ม้า พระเยซู อางเลิ่ง แฮ้ง ปาปาย ชฺ้าง กูเจ้อกูจาด อือนา ยาง ชฺ้าง เพล่อ ปี่ แงแน. พระเยซู ชฺ้าง คาโคลาโค อือ จี่วีดอางซื้ง มาง, อิสราเอลชฺ้าง อือ จี่วีดอางซื้ง มาง แอ่ แน บ่าอ่า. ");
INSERT INTO bzi_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","แน นองมู นี้ง อางแบ คูย้า พระเยซู ประเทศ อิสราเอล โย้เวอ บ้าเจอ ฮาย ชี แน. กาลิลี แควน โย้เวอ ต่องก่าต่าง ฮาย ชี, พระเยซู ฮา ชี นี้ย่า ยอห์น ชฺ้าง อือนา ล้างตือพิธีบัพติศมา อางเลิ่ง แฮ้ง ป่าว เมอ ฮาย ล้า ชี. ");
INSERT INTO bzi_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","นองมู นี้ง อางแบ ย้า, พระเยซู นาซาเร็ธชฺ้าง มาง อางเลิ่ง นี้ย่า. ยางนา พาจาว มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ฮาย จา ปี่ ชี่ แน ล่าที่ ปี่ ชี. นองมู นี้ง อางแบ ย้า, พระเยซู อางเลิ่ง อางแม่น ฮา ชี ต้าว ย้า. แน นองมู นี้ง อางแบ ย้า ยา ชฺ้าง แด่ย่า อ่อง ปี่ชี่ อือนา ล้อแม้ ก่าอ่อก แงแน. พาจาว ม้า พระเยซู ก้อง ดื้ง แง. นี้งย้า พระเยซู อางเลิ่ง นี้อือ ฮากงา กาแง. ");
INSERT INTO bzi_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","กงา พระเยซู เยรูซาเล็ม อางเมิง ยิวชฺ้าง อือ นื้งชฺ่าตี อือเมอ จ่อด แน อางเลิ่ง คาโคลาโค ฮา ชี แฮ้งนา กงามย้าง แอ. แน ยองมู ย้าง ยางนา ไม้กางเขน ท่า เวอ ตื่อตี้ด แซ่ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","จ้า พระเยซู ซฺี้ 3 นืง เคอ ยาว พาจาว มาง ฮาย แต่ล้า แล่ ปี่ ยาว ฮากนา มย้าง ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","จ้า ชฺ้าง คาโคลาโค แน มย้าง ปี่ง บ่าอ่า เป. พาจาว ม้า ชฺ้าง ยาง แช้ยู้ พี่ญ่าน เพล่อ ปี่ ชี่ อือนา ญา มย้าง ปี่ง. แน ชฺ้าง พี่ญ่าน เพล่อ คูชี นี้อือ กงูมู นี้งย้า. พระเยซู ซฺี้ ยาว แต่ล้า แล่เมอ ยางก้อง ทื่งกง่า แน กงาจฺ่ากงาต้าง ชีอือ ย้า. ");
INSERT INTO bzi_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ยา กงูนา ม่า ล่าง อ่อกแอ ยาง อางเลิ่ง อางแม่น แฮ้ง ฮากนา ป่าว แบ ปี่ โว. พระเยซู ย่า พาจาว มาง ต้างแต่ง ชฺ้าง อางแต่ แน ชฺ้าง อางซฺี้ อือนา ต้าดต่อน ปี่ชี่ มาง ย้า. ");
INSERT INTO bzi_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","แน พาจาวจี่ต่างจี่แต่นฮู อืม พระเยซู นา พี่ญ่าน เพล่อ ปี่ง. พระเยซู ชฺ้าง คาโคลาโค ยางนา เจ่อ อือนา ยอง อางซีอางบล่าบ ฮา ชี อือ ปล่องปูน ปี่ ชี่.” ");
INSERT INTO bzi_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","เปโตร พาจาวจี่ต่าง แฮ้ง จี่ จา เมอ, อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ชฺ้าง คาโคลาโค ดื้ง น้า อือก้อง ดื้ง ลือ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","พาจาว ม้า ยิวชฺ้างบ่าอ่า อือนา อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ย่าง ปี่ ชี่เย. แฮ้แม้ยาว เปโตร ก้อง ยิวชฺ้าง พระเยซู นา เจ่อ ยาว เค่ ล้า คูชี อืม นืงบาม่าน คู ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ยองมู ย้าง กงากย่า ชี ยิวชฺ้างบ่าอ่า อือ จี่ต่างบ่ากย่ากางซื้ง จี่ ชี แน พาจาว มางนา สรรเสริญ ฮา คูชี แน. ");
INSERT INTO bzi_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","เปโตร จี่ เย นี้แม้แน, “ยองมู นี้ย่า กงู แม้แน อางค่องอางล้า อางเซฺิ่งอางซฺ้าง กงาบู้ คูงญา. นี้แม้แนยาว ยองมู นี้ง มือ ล้างตือพิธีบัพติศมา ฮา แล่ อางกงา ย้าเป” แน. ");
INSERT INTO bzi_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","แฮ้งย้า เปโตร มือ ยิวชฺ้างบ่าอ่า อือนา ม่า พระเยซูคริสต์ อางเม้ง โย้เวอ ล้างตือพิธีบัพติศมา ฮา แล่ ปี่ชี่. แฮ้แม้ฮายาว ยองมู ย้าง เปโตร นา ช่าง ยอง ก้อง 2-3 นืง ซ่าว ดื้ง แล่ ปี่ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","แฮ้ญ่าม เวอ ศิษย์เอก มู แน ชฺ้าง พระเยซู นา เจ่อ อางมู ยูเดีย แควน ดื้ง อือย่า, กงากย่า ชี ยิวชฺ้างบ่าอ่า อือ พาจาวจี่ต่าง ย่าง เจ่อ คูชี แน. ");
INSERT INTO bzi_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","แฮ้แม้ยาว เปโตร เยรูซาเล็ม อางเมิง โย้เวอ พ่าว แล แล่เมอ, ยิวชฺ้าง พระเยซู นา เจ่อ อือ ช้อนกา ยางนา จี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“บ้าเจอ นา ยิวชฺ้างบ่าอ่า อือ ยู้ม โย้เวอ อางอ้อง แล แน. ยาว ยอง ก้อง ทื่งกง่า แน ฮ่าง อางจฺ่าอางต้าง แน. นี้แม้ ฮา นี้ย่า อางลี้บอางล่าว โย้เวอ อางซี เป.” ");
INSERT INTO bzi_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","แฮ้งเย่ เปโตร มือ อางเลิ่ง กูย่างกูเจ้อ ตอล้า ชี ย้าง, ต่องก่า เมอ จาย ยองมู นา อู่บน้า ปี่ ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“กงา ยัฟฟา อางเมิง โย้เวอ อธิษฐาน ฮา จา เมอ, กงา แมบื้น แม้แน มย้าง แอ, ม้างม้าเจ้อ พ้า อางฮื่อ คลา ลู่งลือ ปี่ ชี แม้แน จา แง. พ้า แฮ้พืน 4 แจ้ง แน พือ ยาว เทิง ชี ชี. ยาว กล่ามกล่าม แน มู่งท่า โย้เวอ จาย กงาก้อง กลา ลือ แง. ");
INSERT INTO bzi_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","กงาม แมนืออ่าว ย้า พ้า คล้าว โย้เวอ ฮู แอ. ซ้าด บ่าจฺ่าแจ กางอือ จา แง, ซ้าด นี้อือย่า นื้งชฺ่าท่า ซ้าด ล่าคื่อ 4 คื้อ อือ, ซ่องก่องซ้าด, ซ้าด ต่อ โจง กว่า อือ, ฮาย่า มู่ง เวอ ปย้าม กว่า อือ. ");
INSERT INTO bzi_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ยาว กงาม อางเซง จี่ นา กงากย่า แอ นี้แม้แน, ‘เปโตร เวอ ทานล้า ยาว ซ้าด นี้อือนา แซ่ จฺ่า โว!’ ");
INSERT INTO bzi_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“จ้า กงาม พอ แอ นี้แม้แน, ‘บ่ากงา เป จี่วีดอางซื้ง มาง เวอ. กงา ซ้าด อางโซอางซา โมเสส อางลี้บอางล่าว โย้เวอ บ่าปี่ จฺ่า อือ บ่าจฺ่า กางซื้ง.’ ");
INSERT INTO bzi_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“ยาว มู่งท่า โย้เวอ อางเซง จี่ลือ แล่ ปี่ง นี้แม้แน, ‘ม้างม้าเจ้อ อางเกิ่ง พาจาว มาง ฮา เซฺิ่งซฺ้าง ปี่ ยาว, นา บ่าเซฺิ่งบ่าซฺ่าง แน บ่าทื่อ กานโจ’ ");
INSERT INTO bzi_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","นี้แม้แน อางเลิ่ง ตอล้า ชี นี้ย่า อางตู้ กาแน 3 เทอ เย. ยาว อางเกิ่ง คาโคลาโค ย่าง มู่งท่า โย้เวอ ทื่อเทอ ฮ้าน พ่าว แล แล่ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“ยาว ซฺ้อก ย้า ชฺ้าง 3 คู่น ลือ แง กงา ยู้ม ดื้ง แฮ้ลาง ก้อง เวอ. ค่าพ่าย่า แฮ้มู ย่า ซีซารียา อางเมิง โย้เวอ จายลือ คูแง. ชฺ้าง ซฺาลือ ปี่ ชี่, กงานา ซฺ้าลือ ล่าง. ");
INSERT INTO bzi_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ยาว อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง กงานา ม่า ยอง ก้อง เค่ แล ปี่ ล่าแง. เจิ้นเจ้อ บ่าปี่ เย้ง ล่าแน. ยาว ชฺ้าง 6 คู่น พระเยซู นา เจ่อ อือ กงาก้อง เค่ ล้า แง. ยาว กงูมู ย้าง โครเนลิอัส ม่าง ยู้ม คล้าว โย้เวอ อ้องแล คู แอ. ");
INSERT INTO bzi_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","โครเนลิอัส กงูมู นา ม่า ล่าแง. ยา ยาง ยู้ม คล้าว โย้เวอ พาจาว มาง เท่วาด่า มางนา มย้าง ชี. ยาว นี้แม้แน จี่, ‘ชฺ้าง ซฺาแอ ปี่ โว ยัฟฟา อางเมิง โย้เวอ. ซีโมน ฮาก เปโตร แน ฮ้าว มางนา ซฺื่ยล้า โว! ");
INSERT INTO bzi_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ยา นาง แน นาง ยู้มชฺ้าง อือ อางบล่าบ กงาปูน แล่ง แฮ้ง ม่า ล่าแง.’ ");
INSERT INTO bzi_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“กงา ต่องก่าต่าง จี่ เมอ ย้า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ยอง ก้อง ดื้ง ลือ แง. ต่องก่า กงู ก้อง ลือ ชี แม้แน. ");
INSERT INTO bzi_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","กงานา ฮา ปื้อ ปี่ ล่าแง จี่วีดอางซื้ง มาง จี่ ชี ชี แฮ้งนา, ‘ยอห์น ม้า ล้าง แฮ้ง พิธีบัพติศมา ฮา ปี่ แง. จ้า นองมู นี้ย่า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง ก้อง พิธีบัพ‍ติศ‍มา ฮา แล่ คูแง’ แน. ");
INSERT INTO bzi_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","กงู พระเยซูคริสต์ นา นืงบาชี เมอ, พาจาว ม้า อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ปี่ ล่าแง. แน ยองมู นาม พาจาว มาง อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ปี่ แง. กงูมู นา ปี่ ชี่ แม้แน ย้า แฮ้แม้ยาว กงา พาจาว มางนา บ่าจี่ กงากา.” ");
INSERT INTO bzi_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ยิวชฺ้าง พระเยซู นา นืงบาชี คูชี อืม แฮ้แม้ กย่า ยาว เปโตร นา จี่ ย้าง ว่าง ชีเย. แน พาจาว มางนา สรรเสริญ ฮา คู ชีเย, “พาจาว มาง ยิวชฺ้างบ่าอ่า อือนา คาตา ย้า, ยองนา นืงบาเพ่น อางบล่าบ ฮา แฮ้ง ว่าง ปี่ แง. ไม้ ยองนา จี่วีดม้าม้า กงาบู้ ปี่ แงแน.” ");
INSERT INTO bzi_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","แฮ้เมอเวอ สเทเฟน ซฺี้ ยาว ชฺ้าง พระเยซู นา เจ่อ อือนา ฮาก คาม คูง บ่าโลง เย. แฮ้งย้า ชฺ้าง พระเยซู นา นืงบาชี อืมมือ เปิดเลิ้น ฮื่น แอ เว่อ แล่ คู ชีเย. ทื่อบ่า ฟีนิเซีย อางเมิง โย้เวอ ทื่อบ่า เกาะ ไซปรัส ทื่อบ่า อันทิโอก อางเมิง อือเมอ แล คู ชีเย. แน ชฺ้าง นี้มู ย่า ยิวชฺ้าง อือนา ญา เย พาจาว มาง จี่ต่าง ย่าง ป่าว ม่ายแบ ปี่ ชี่. ");
INSERT INTO bzi_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ชฺ้าง พระเยซู นา เจ่อ คูชี อือ ทื่อบ่า เกาะ ไซปรัส แน ไซรีน อางเมิง โย้เวอ จาย ล้า คู ชีเย. แน ยองมู ย่าง อันทิโอก อางเมิง โย้เวอ เคอ แล ยาว ยิวชฺ้างบ่าอ่า อือนา พระเยซู อางเลิ่ง อางแม่น ย่าง ป่าว น้า ปี่ ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ยองมู อางโต โย้เวอ จี่วีดอางซื้ง มาง ล่าที่ ปลื้ง ย้า จา แง. แฮ้แม้ยาว ชฺ้าง อางบย่า เย, พระเยซู นา เจ่อ คู ยาว จี่วีดอางซื้ง มางนา เค่ คู ชี. ");
INSERT INTO bzi_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","เยรูซาเล็ม อางเมิง โย้เวอ พระเยซู นา เจ่อ อือ นี้เลิ่ง แบ ยาว ยองมู ย้าง บารนาบัส นา อันทิโอก อางเมิง โย้เวอ ซฺาแอ ปี่ ชี่ เย. ");
INSERT INTO bzi_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ยาว บารนาบัส อันทิโอก อางเมิง โย้เวอ เคอ แอ เมอ. โย้ ชฺ้าง อือนา พาจาว มาง ก่ามป่อน ปี่ ชี่ แน มย้าง ยาว ยาง กย่าง ชีเย. แน อันทิโอก อางเมิง ชฺ้าง คาโคลาโค พระเยซู นา เจ่อ อือนา ม่าอู่บ ชีเย. จี่วีดอางซื้ง มางนา นืงบา โค แน ลาก แล แล่ โว. ");
INSERT INTO bzi_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","บารนาบัส ยา ชฺ้าง อางแม่น เย แน ยาง อางโต โย อางค่องอางล้า อางเซฺิ่งอางซฺ้าง ปลื้ง ย้า จา แง. แน ยา นาบาตา ย้า พระเยซู นา เจ่อ แง. แน ชฺ้าง อางบย่า เย จี่วีดอางซื้ง มางนา เจ่อ คู ชี. ");
INSERT INTO bzi_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","แฮ้แม้ฮายาว บารนาบัส เซาโล นา ทาร์ซัส อางเมิง โย้เวอ ซฺ้าแอ ชี. ");
INSERT INTO bzi_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","แน เซาโล นา มย้าง ยาว อันทิโอก อางเมิง โย้เวอ ซฺื่ยแอ ชีเย. ยาว เย่ด อันทิโอก อางเมิง โย้เวอ 1 ปี ปลื้ง ย้า, ชฺ้าง พระเยซู นา เจ่อ ชี อือก้อง ทื่งกง่า แน ดื้ง ยาว พาจาว มาง จี่ต่าง ย่าง ชฺ้าง อือนา อางบย่า ย้า ม่าอู่บ ชี. แฮ้งย้า ชฺ้าง พระเยซู นา เจ่อ คูชี อือ, อันทิโอก อางเมิง นู้เวอ ย้า อางเม้ง กงา แล่ ชี่ คริสเตียน แน. ");
INSERT INTO bzi_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","แฮ้ญ่าม เวอ พาจาวจี่ต่างจี่แต่นฮู ทื่อบ่า อือ เยรูซาเล็ม อางเมิง โย้เวอ จาย อันทิโอก อางเมิง โย้เวอ ย่อลือ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ชฺ้าง อางมู โย้เวอ ชฺ้าง ทื่อม่าง จา เย, อางเม้ง อากาบัส แน เย. ยางนา อางค่องอางล้า อางเซฺิ่งอางซฺ้าง มาง มอ ยาว จี่ ปี่ ชี่ เย. แฮ้แม้ยาว ยาง ทาจูง ล้ายาว จี่ ชีเย. กาญ่าม เวอ ชฺ้างอางเมิง นู้เวอ ชฺ้าง อือ นาบาตา ย้า ฮ่างจฺ่าเซฺ่อ ต้างเซฺ้อ บ่าจา แน กงาจฺื่งคู คูงแง. (ยาว ม้าม้า ย้า จักรพรรดิ์ คลาวดิอัส อางเมิง ฮูพลา เมอ อางเลิ่ง นี้แม้แน ตอล้า ชี.) ");
INSERT INTO bzi_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","แฮ้แม้ยาว พระเยซู นา เจ่อ อืม ม่า ลางกา ชีเย. ยอ คริสเตียนม้องน้าม ยูเดีย แควน เวอ ดื้ง อือนา ปล่อง แงแน, ยอง คา ปล่อง กงา กาง แม้แน. ");
INSERT INTO bzi_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","แฮ้งเย่ ยองมู ย้าง อางเกิ่งอางก้อ ช้อน ลางกายาว, บารนาบัส แน เซาโล เย่ดนา ปี่ ชี, เยรูซาเล็ม อางเมิง โย้เวอ คริสเตียน ยอคา โบสถ์ ฮูพลา อือนา ปี่ แล แงแน. ");
INSERT INTO bzi_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","แฮ้ญ่าม เวอ, ก่าซ้าด เฮโรด ชฺ้าง พระเยซู นา เจ่อ อือนา เค่คาม ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ก่าซ้าด เฮโรด ยาง ชฺ้าง อือนา ม่า ยากอบ ยอห์น อางอ้าย มางนา อางตู่ ต่อน ปี่ ชีเย. ");
INSERT INTO bzi_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ก่าซ้าด เฮโรด ยาง นี้แม้ ฮา ชี แฮ้ง ยิวชฺ้าง อือ นืงบาจาบ ชี แน มย้าง ยาว. แฮ้งเย่ เปโตร นา คาตา แน ชู แล ชี. (แฮ้ญ่าม เวอ ปัสกาป่อย ย้าง) ");
INSERT INTO bzi_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","เฮโรด เปโตร นา ชู ยาว คอก เวอ ซฺื่ย ล้อง แล ชีเย. แน ยาง ตาฮ้าน 4 มู กามู 4 คู่น กาแน ม่า เปโตร นา ล่อ ปี่ ชีเย. ก่าซ้าด เฮโรด เย้ง ชี ชีเย ปัสกาป่อย แฮ้ง ปูน ปี่ ยาว เปโตร นา ซฺื่ย ค่องช่าง ล้าก้า โย้เวอ ต้าดต่อน แล แงแน. ");
INSERT INTO bzi_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","แฮ้งเย่ เปโตร นา คอก เวอ ล้อง ชี ชี. จ้า ชฺ้าง พระเยซู นา เจ่อ ชีอือ ช้อนกา พาจาว มางนา ปีนแตปีนนา ย้าเย่ อธิษฐาน ฮา ป้า คู ชี. เปโตร นา ปล่อง โว แน. ");
INSERT INTO bzi_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ก่าซ้าด เฮโรด เปโตร นา คอก เวอ ชา ซฺื่ย ต้าดต่อน แอ เมอ, แฮ้คี่ เปโตร ยู่ จา เย. ยาง ก่องทาง โย้เวอ ตาฮ้าน 2 คู่น จา แง, ล่าม่า ป่ากย่า ทื่อม่าง แน ล่าซ่าย ป่ากย่า ทื่อม่าง แน. ยองนา โซ่ พือ ตีด ลางกา ปี่ ชี่. แน คอก ล้องก้อ ล้าก้า 