﻿USE sofia;
DROP TABLE IF EXISTS sofia.bzh_vpl;
CREATE TABLE bzh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bzh_vpl WRITE;
INSERT INTO bzh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kerisi yi degwa lo sënë: Yesu saga sën Davit* yi mewis, geDavit saga sën Abraham yi mewis. ");
INSERT INTO bzh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ḳo Isaak, gIsaak ḳo Yakop, geYakop saga sën ḳo Yuda losho ari lo. ");
INSERT INTO bzh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","GeYuda ḳo Peres luho avëhnö Sera, geluho ataj Tamar. GePeres ḳo Hesron. Ga, Hesron ḳo Ram. ");
INSERT INTO bzh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ga, Ram ḳo Aminadap, gAminadap ḳo Nason, geNason ḳo Salmon. ");
INSERT INTO bzh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","GeSalmon ḳo Boas, gata Rahap. GeBoas ḳo Obet, gata Rut. Ga, Obet ḳo Yese, ");
INSERT INTO bzh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","geYese ḳo Mehö-los-bengö Davit, geDavit ḳo Solomon, gata sën Uria venë wirek lo. ");
INSERT INTO bzh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Loga, Solomon ḳo Rehoboam, geRehoboam ḳo Abiya, gAbiya ḳo Asa. ");
INSERT INTO bzh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ga, Asa ḳo Yosapat, geYosapat ḳo Yoram, geYoram ḳo Usia. ");
INSERT INTO bzh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ga, Usia ḳo Yotam, geYotam ḳo Ahas ga, Ahas ḳo Hesekia. ");
INSERT INTO bzh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ga, Hesekia ḳo Manase, geManase ḳo Amos, gAmos ḳo Yosia. ");
INSERT INTO bzh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","GeYosia ḳo Yekonia losho ari lo, lob loḳ buk saga alam Babulon* deduu alam Israel vahi medeḳo sir ya denedo hir nyëġ. ");
INSERT INTO bzh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Deya denedo nyëġ böp Babulon* lom Yekonia ḳo nalu Sealtiel. Lob Sealtiel ḳo Serubabel, ");
INSERT INTO bzh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","lob Serubabel ḳo Abiut, gAbiut ḳo Eliakim, gEliakim ḳo Asor. ");
INSERT INTO bzh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","GAsor ḳo Sadok, geSadok ḳo Akim, gAkim ḳo Eliut. ");
INSERT INTO bzh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","GEliut ḳo Eleasar, gEleasar ḳo Matan, geMatan ḳo Yakop ngwë. ");
INSERT INTO bzh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","GeYakop sënë ḳo Yosep sën Maria regga, lob Maria saga sën ḳo Yesu, sën denenër bë Kerisi* lo. ");
INSERT INTO bzh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nebë saga lob sir pin Abraham yi mewis sir, beyam verup loḳ Davit saga, besir yu nemadluho-bevidek-lubeluu. Gevu Davit beyam verup loḳ buk sën deḳo sir ya denedo nyëġ böp Babulon*, saga sir yu nemadluho-bevidek-lubeluu. Lob vu buk sën deḳo sir ya denedo nyëġ böp Babulon* beverup loḳ Kerisi*, og sir yu nemadluho-bevidek-lubeluu nebë saga ving. ");
INSERT INTO bzh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu ata ḳo yi lo degwa nebë sënë: Deggooin ata Maria raḳ in jaḳ vu Yosep, rëḳ luho yö nahën denedo, log Maria nalu loḳ raḳ Anon Vabuung. ");
INSERT INTO bzh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosep sën deggooin raḳ bë natu regga lo, yi mehö netetuu aggata niröp, lob su bë rëḳ nanër avëh yi ġaġek nimumsën ranġah vu alam pin rë. Gaḳ vonġin bë bepul Maria vunsën. ");
INSERT INTO bzh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yosep nahën kwa nevo nebë sënë, loḳ Mehöböp yi angër yam vu yi loḳ pesepsën benër vu bë, “Davit* yi mewis Yosep-e! Gwenġo! Su nim dëlin Maria! Gaḳ gweḳo nök natu venëm. Hurmahen sën loḳ nare ayo lo, saga Anon Vabuung vonġ vu yi. ");
INSERT INTO bzh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Rëḳ geḳo nalu aġuu lom ġenanër arë nabë Yesu. In rëḳ geḳo yi alam vër in hir nipaya nyëvewen.” ");
INSERT INTO bzh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nġaa pin sënë anon raḳ yoh vu ġaġek sën Mehöböp vonġ verup mehö-nenër-ġaġek-ranġahsën Yesaya avi lo nebë: ");
INSERT INTO bzh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ham gwenġo rë! Rëḳ avëh avö nalu doḳ, lom geḳo nalu aġuu. Lob rëḳ ġenanër arë nabë Emanuel.” Arë sënë degwa nebë ‘Anutu nedo ving hil’. ");
INSERT INTO bzh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Lob Yosep ggëp mepesep ggovek gekedi raḳ, lom vonġ yoh vu sën Mehöböp yi angër nër vu yi lo. Ya beḳo avëh netu venë, ");
INSERT INTO bzh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","rëḳ su neya aggata ving yi rë, gema rot, beya verup loḳ buk sën venë ḳo nalu aġuu lo. Lob tahi ggev raḳ nebë Yesu. ");
INSERT INTO bzh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria ḳo Yesu vu Betlehem ggëp Yudea loḳ buk sën Herot* tu mehö-los-bengö menedo. Ḳo ggovek, lom alam kwaj böp la vu nyëġ mala neverup bedeyam Yerusalem medeloḳ tepëḳ bë, ");
INSERT INTO bzh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Alam Yuda hir mehö-los-bengö hurmahen mewis sën lo tena? He halë yi betuheng verup ggëp sën nyëġ mala neverup, lom he yam in bë ġaḳo arë jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mehö-los-bengö Herot* nġo hir ġaġek saga, lob lëk anon, balam Yerusalem pin delëk ving. ");
INSERT INTO bzh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Lob tahi alam-deneḳo-seriveng hir ggev los alam-horek-yi pin ya vu yi beloḳ tepëḳ in sir bë, “Kerisi* ata geḳo yi gëp tena?” ");
INSERT INTO bzh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Lob denër yah bë, “Ata geḳo yi gëp Betlehem vu distrik Yudea, in mehö-nenër-ġaġek-ranġahsën kevu ġaġek meneggëp nebë: ");
INSERT INTO bzh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Honġ Betlehem vu nyëġ Yuda, su ġetu nyëġ Yuda yi begganġ-bu mahen tamusën rë, gaḳ ġekwesuu. In ggev böp ti rëḳ berup doḳ honġ, lob ġeġin salam Israel.’” ");
INSERT INTO bzh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herot* nġo nebë saga lob vun yi metahi alam los kwaj böp saga yam, beloḳ tepëḳ in sir in bë jaḳ ni niröp nabë betuheng saga verup loḳ buk tena. ");
INSERT INTO bzh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Log vonġ sir ya Betlehem genër vu sir bë, “Ham na sero hurmahen saga niwëëk ata, lob bë ham natöḳ vu yi, og ham gweḳo ġaġek nom vu sa, in senök ġaḳo arë jaḳ geving.” ");
INSERT INTO bzh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Denġo mehö-los-bengö yi ġaġek saga ggovek log deya. Lob betuheng sën delë neggëp nyëġ mala neverup lo, muġin beya nare ya valeḳ nyëġ sën hurmahen neggëp loḳ lo. ");
INSERT INTO bzh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Delë betuheng lom kwaj vesa rot. ");
INSERT INTO bzh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lob deloḳ ya begganġ ayo bedelë hurmahen luho ata Maria, lob deyun lusej vu los deḳo yi raḳ. Gedeggoo ḳupeḳ la loḳ hir keröng yoh vu sir bedevo vu yi. Goor, geḳele niḳegwi reggu nivesa sën denenër arëj nebë praginsëj* los mur*. ");
INSERT INTO bzh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Log Anutu vo pesepsën vu sir loḳ buk bë su nah deberup vu Herot*, lom deyoh aggata ngwë medeyah medeya bej. ");
INSERT INTO bzh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Deya ggovek, log Mehöböp yi angër ti yam vu Yosep benër vu yi loḳ pesepsën bë, “Kwedi gweḳo hurmahen luho ata jaḳ, meġebeya meġena Ejep. In Herot* vonġin sero hurmahen bengis yi nadiiḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Lob Yosep kedi meḳo hurmahen luho ata raḳ loḳ buk beya Ejep. ");
INSERT INTO bzh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Lob ya denedo sagu rot beya verup loḳ buk sën Herot* diiḳ. Devonġ nebë saga lob ġaġek sën Mehöböp vonġ verup mehö-nenër-ġaġek-ranġahsën avi lo anon raḳ nebë: “Sa tahi naluġ vu Ejep yam.” ");
INSERT INTO bzh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Rëḳ Herot* raḳ ni bë alam los kwaj böp saga dekuung in yi, lob ahë sengën panġsën rot, bevonġ alam la deya Betlehem los nyëġ mahen mahen sën neggëp dus vu lo, bedesis hurmahen maluh pin bedediiḳ. Sir sën ataj nahën neḳo sir lo rot, beya verup loḳ sën hir nġebek netu luu raḳ lo, yoh vu buk sën alam los kwaj böp denër vu Herot* bë delë betuheng nyëdahis lo. ");
INSERT INTO bzh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Lom mehö-nenër-ġaġek-ranġahsën Yeremia yi ġaġek sën kevu meneggëp lo anon raḳ. Sënë nebë: ");
INSERT INTO bzh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Aye ti dedun vu nyëġ Rama. Nesu los nenġeeḳ böpata. Rakel nesu in nalu lo, medenahubin yi, rëḳ ma gesu yoh vu rë. In nalu lo su denedo rë, gaḳ malaj ma.” ");
INSERT INTO bzh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herot* diiḳ ggovek, lom mëm Mehöböp yi angër ti yam tato yi vu Yosep ggëp Ejep loḳ pesepsën, ");
INSERT INTO bzh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","menër vu yi bë, “Kwedi gweḳo hurmahen luho ata jaḳ meġenah Israel hir dob. In alam sën bë dengis hurmahen lo dediiḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Lob Yosep kedi meḳo hurmahen luho ata raḳ, beyah Israel hir dob. ");
INSERT INTO bzh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Rëḳ nġo bë Arkelaus loḳ yah ama Herot* ben betu alam Yudea hir mehö-los-bengö lob ggöneng in yi besu ya sagu rë. Rëḳ Anutu vo pesepsën vu Yosep in tato aggata vu yi, lob ya los distrik Galilea. ");
INSERT INTO bzh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ya nedo nyëġ ti arë nebë Nasaret. Lom alam-denenër-ġaġek-ranġahsën hir ġaġek lo anon raḳ. Sën denër bë: “Rëḳ denanër yi nabë yi Nasaret ti.” ");
INSERT INTO bzh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Vu buk saga mehö-neripek-alam Jon verup nedo nyëġ-yumeris ggëp Yudea hir dob, benenër ġaġek bë, ");
INSERT INTO bzh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ham gweġin ham in Nyëġ-yaġek-yi vonġin anon jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon saga sën Anutu vonġ ġaġek raḳ yi verup mehö-nenër-ġaġek-ranġahsën Yesaya avi nebë: “Mehöti aye neraḳ loḳ nyëġ-yumeris bë, ‘Ham bolinin Mehöböp yi aggata, meham sesor begëp niröp.’” ");
INSERT INTO bzh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon sënë neröp röpröp ading sën denevasu raḳ kamër niviis lo, genevëh ḳabi neggëp balo. Genegga sepaaḳ los nenum beggoh netu yi nos. ");
INSERT INTO bzh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Lob alam Yerusalem losho alam nyëġ Yudea pin, galam pin sën denedo dus vu bël Yordan lo deneya vu yi. ");
INSERT INTO bzh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bedenër hir nġaa nipaya ranġah geJon neripek sir luḳ bël Yordan. ");
INSERT INTO bzh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Loḳ Jon lë bë alam Parisai* los alam Sadukai* nġahi deyam vu yi in bë dejipek bël geving, lom nër vu sir bë, “Nyël nalu ham! Re nër vu ham bë ham beya in nyëvewen sën rëḳ natöḳ vu ham vu buk tamusën agi? ");
INSERT INTO bzh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ham gwevonġ nġaa niröp noh vu sën ham wërin ayomin lo, in tato nabë ham wërin ham yönon. ");
INSERT INTO bzh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ham su kwamin bo megweḳo ġaġek jaḳ nah menanër nabë Abraham yi mewis ham. Gaḳ sa nanër vu ham nabë Anutu yoh vu bë gevonġ ġelönġ sënë denatu Abraham yi mewis. ");
INSERT INTO bzh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yönon, in ḳoov nevu nevaleḳ ḳele ġeġa meneggëp vorot, in ḳele pin sën su denesis anoj nivesa rë lo, saga rëḳ dengap bedegetë jaḳ na nengwah. ");
INSERT INTO bzh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Sa naripek ham raḳ bël mu, in bë ham gwërin ham. Gaḳ mehö los niwëëk ti kesuu sa rëḳ tamuin sa menam, lob sa su mehö niġ vesa yoh vu in bë sa natu yi hur ti menaḳah vaha suu vër rë. Mehö sënë rëḳ basuh ham begevonġ Anon Vabuung vu ham vahi gegevonġ benengwah ga ham vahi. ");
INSERT INTO bzh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jom yi savor loḳ ya nema vorot in tetëhin ḳale ḳale na in yi wit* ġahis, gengupin jaḳ na jök-wit-yi. Gaḳ ḳale ḳale saga, og rëḳ besi jaḳ na nengwah sën medo netum degwata lo.” ");
INSERT INTO bzh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nebë sënë lob Yesu vu Galilea meluḳ meya bël Yordan vu Jon, in bë Jon jipek yi. ");
INSERT INTO bzh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Rëḳ Jon nërin yi bë, “Bë ġejipek sa og mëm nivesa, ma nebë va sën ġeyam vu sa-ë?” ");
INSERT INTO bzh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Rëḳ Yesu nër yah vu yi bë, “Ġenaḳööḳ galu dahun hil gesepa doḳ Anutu yi aggata nabë sënë rë loḳ mëm.” Lob Jon yoġekin yi ġaġek beripek yi. ");
INSERT INTO bzh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu ripek bël ggovek geraḳ yom roneḳ, lob pevis beyaġek tateḳin yi, gelë Anutu yi Anon Vabuung ni nebë soḳ nuung ti beluḳ yam nare raḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Log ġaġek ti yam vu yaġek bë, “Yiḳ sa naluġ sënë sën sahëġ neving yi los halë yi nivesa lo!” ");
INSERT INTO bzh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ggovek saga log Anon Vabuung li Yesu raḳ meya nyëġ-yumeris in Satan pelëpin yi. ");
INSERT INTO bzh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu su gga nos rë genedo meris buk geranġah mehödahis luu, lom diiḳahë. ");
INSERT INTO bzh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Lob mehö-pelëpinsën-ala ya menër vu yi bë, “Bë Anutu nalu honġ, og ġenanër ġelönġ sënë denatu brët!” ");
INSERT INTO bzh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Rëḳ Yesu nër yah vu bë, “Ġaġek neggëp loḳ Anutu-yi-ḳapiya bë: ‘Nos mu su yoh vu bë gevonġ bemehönon demedo vesaj rë, gaḳ yiḳ ġaġek pin sën neverup raḳ Anutu avi lo nejom ahon ving.’” ");
INSERT INTO bzh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Loḳ Satan ḳo yi beluho deya nyëġ vabuung Yerusalem, beḳo yi raḳ ya dub-vabuung-böp yu vavunë, log nër vu yi bë, ");
INSERT INTO bzh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Bë Anutu Nalu honġ, og gwetë honġ na dob, in ġaġek neggëp loḳ Anutu-yi-ḳapiya bë: ‘Rëḳ gevonġ yi angër lo nam degeġin honġ nivesa.’ Log ġaġek ngwë nër bë: ‘Rëḳ detabuu honġ doḳ nemaj gesu rëḳ ġengis vaham jaḳ ġelönġ rë.’” ");
INSERT INTO bzh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Loḳ Yesu nër yah vu yi bë, “Ġaġek ngwë neggëp loḳ Anutu-yi-ḳapiya ving nebë: ‘Su ġeseggi Mehöböp sën honġ Anutu.’” ");
INSERT INTO bzh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Loḳ tum Satan ḳo yi meluho deya ḳedu ading ti, beya tato nyëġ dob pin los mehönon pin gehir nġaa nivesa vesa pin vu yi, ");
INSERT INTO bzh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","log nër vu bë, “Bë ġengun lup vu sa los gweḳo sarëġ jaḳ, og sëḳ dëëin nġaa los arë arë pin sënë nök vu honġ!” ");
INSERT INTO bzh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Rëḳ Yesu nër yah vu bë, “Satan! Gweḳo honġ jaḳ meġena! Ġaġek neggëp loḳ Anutu-yi-ḳapiya nebë: ‘Yiḳ gweḳo Mehöböp sën honġ Anutu lo jaḳ, beġeġurek yi yö timu babu!’” ");
INSERT INTO bzh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Lob Satan veya in Yesu meya, gangër yam deneloḳ vu yi. ");
INSERT INTO bzh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Deduu Mehö-neripek-alam Jon ahon beya nedo ḳarabus, beYesu nġo bengö lom tah yi yah distrik Galilea. ");
INSERT INTO bzh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Loḳ vuu Nasaret geya nedo Kapernaum sën neggëp nġaggee böp Galilea nenga beneggëp ya los alam Sebulon los Naptali hir dob lo. ");
INSERT INTO bzh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ya saga lob ġaġek sën mehö-nenër-ġaġek-ranġahsën Yesaya nër lo anon raḳ nebë: ");
INSERT INTO bzh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Alam Sebulon los alam Naptali hir dob, ggëp aggata sën neya los nġaggee Galilea vu bël Yordan nenga vahi sagu. GeGalilea hir dob vahi sën alam dahis yam denedo loḳ lo. ");
INSERT INTO bzh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nengwah-tumsën böpata jëh raḳ alam sën denedo loḳ malaḳenu ayo lo! Denedo loḳ nyëġ malaḳenu sagi bebë denadiiḳ bemalaj nama na, loḳ Ranġah raḳ in sir!” ");
INSERT INTO bzh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Vu buk saga Yesu ḳo yi huk raḳ benër ġaġek ranġah bë, “Ham gweġin ham! In Nyëġ-yaġek-yi vonġin anon jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu neyoh nġaggee böp Galilea nenga, lom töḳ vu Simon sën denenër arë ngwë nebë Pita lo luho ari Andreas, geluho medo denetë leḳ luḳ ya nġaggee in bë degeḳo ġël, in yiḳ luho yö hir huk sagi. ");
INSERT INTO bzh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Lob Yesu nër vu luho bë, “Melu nam sepa sa natu sa hur besa tahu meluu in melu gweḳo mehönon denam vu sa nabë sën melu neḳo ġël agi.” ");
INSERT INTO bzh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Lob pevis beluho devuu hir leḳ geya desepa yi melööho deya. ");
INSERT INTO bzh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Lööho deya beya deverup, lob lë mehöti luho ari, Yakobus luho ari Jon sën Sebedi nalu luho. Luho raḳ denedo yaġ ving amaj Sebedi, medenejoo hir leḳ vepulsën yah. Loḳ Yesu tahi luho, ");
INSERT INTO bzh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","lob luho devuu amaj los yaġ ya pevis geya desepa yi. ");
INSERT INTO bzh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Log Yesu yoh vu distrik Galilea pin benër ġaġek vu alam loḳ dub-supinsën-yi. Nër Bengö Nivesa raḳ Anutu-yi-nyëġ, gevonġ balam hir niraḳsën aggagga pin nivesa raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Lob Yesu bengö ya meyoh vu distrik Suria pin, lom deḳo alam sën nij raḳ aggagga los alam sën nij nesanġ lo, galam sën memö nipaya nevonġ sir lo, galam sën bedo nevesi sir lo, galam sën seḳëj neselönġin lo pin, medeya vu yi mevonġ benijvesa neraḳ. ");
INSERT INTO bzh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Lob alam nġahiseḳë vu distrik Galilea los Begganġ-bu-nemadluho gevu nyëġ böp Yerusalem los distrik Yudea pin, gevu bël Yordan vahi yi, bedesepa yi medeya. ");
INSERT INTO bzh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu lë alam nġahiseḳë denesupin sir, lom raḳ ya ḳedu ti meto nedo, geyi hur maluh deya vu yi, ");
INSERT INTO bzh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","lom tateḳin ġaġek vu sir nebë sënë: ");
INSERT INTO bzh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Alam sën deraḳ ni bë su nijvesa rë lo, kwaj vesa, in detu Anutu-yi-alam berëḳ demedo nivesa doḳ yi nyëġ. ");
INSERT INTO bzh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Alam sën ayoj maggin in nġaa nipaya sën nedo dob lo, kwaj vesa, in Anutu rëḳ gevonġ mayoj nivesa. ");
INSERT INTO bzh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Alam sën denedahun arëj lo, kwaj vesa, in rëḳ dob ala sir. ");
INSERT INTO bzh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Alam sën ahëj ving rot bë degevonġ nġaa niröp mu nebë sën alam dediiḳahëj in nos lo, kwaj vesa, in Anutu rëḳ gevonġ banon jaḳ benajom sir ahon. ");
INSERT INTO bzh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Alam sën kwaj paya in alam vahi bedeneloḳ vu sir lo, kwaj vesa, in Anutu rëḳ gevonġ doḳ nah vu sir nabë. ");
INSERT INTO bzh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Alam sën ayoj neggëp niröp rot lo, kwaj vesa, in rëḳ degelë Anutu. ");
INSERT INTO bzh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Alam sën denevonġ in bë dedahun beġö na lo, kwaj vesa, in Anutu rëḳ nanër nabë nalu sir. ");
INSERT INTO bzh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Alam sën deneḳo maggin in denesepa loḳ nġaa niröp los yohvu lo, kwaj vesa, in detu Anutu-yi-alam berëḳ demedo nivesa doḳ yi nyëġ. ");
INSERT INTO bzh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Alam rëḳ depelë ham gedegevonġ rii jaḳ ham gedenanër ġaġek nipaya kuungsën aggagga jaḳ ham in denelë bë sa alam ham, rëḳ mu mëm ham kwamin vesa. ");
INSERT INTO bzh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ham ayomin nivesa bekwamin vesa anon, in ham nyëvewen rëḳ gëp yaġek, in denevonġ nebë saga vu alam-denenër-ġaġek-ranġahsën wirek.” ");
INSERT INTO bzh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ham nebë dob sënë yi mamireng. Rëḳ mamireng bë nimöḳ jaḳ, og rëḳ hil ġevonġ benengën jaḳ nah nabë va? Mamireng nebë saga hen huk ma, om hil ġetë na balam debaḳë duḳ dob. ");
INSERT INTO bzh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Geham nebë dob sënë yi ranġah. Nyëġ ti bë medo jaḳ ḳedu, og su yoh vu bë bun yi rë. ");
INSERT INTO bzh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Gemehöti su netaggi loḳ ram menetunġ ggevek ya dëg ayo rë. Ma rot. Gaḳ mu netunġ raḳ nedo reek vavunë in bë natum jaḳ alam pin sën denedo begganġ ayo lo. ");
INSERT INTO bzh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Om ham najëh jaḳ alam pin malaj nabë saga, lob rëḳ degelë nġaa nivesa sën ham nevonġ lo, lob rëḳ degeḳo ham Amamin sën nedo yaġek lo arë jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ham su kwamin bo nabë seyam in dahun Moses yi horek los alam-denenër-ġaġek-ranġahsën hir ġaġek na. Gaḳ ma. Sa su yam in bë dahun na rë, gaḳ seyam in bë tateḳin degwa beġevonġ banon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sa nanër vu ham yönon nabë Anutu su rëḳ dëëin ġaġek metes teka, ma nyë dus ti sën neggëp loḳ horek-ë, begeto megëp rë. Gaḳ yö rëḳ gëp nabë sënë rot, bena berup doḳ buk sën yaġek los dob nama na, gAnutu yi ġaġek pin anon jaḳ rë. ");
INSERT INTO bzh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Om bë mehöti keyëh ġaġek dus ti doḳ horek sënë betahu alam bedegevonġ noh vu sën nër lo, og Anutu rëḳ nanër yi gëp Nyëġ-yaġek-yi nabë mehö tamusën veröḳ-yi. Gaḳ alam sën denesepa loḳ horek sënë bedenetateḳin vu alam medenero lo, og rëḳ Anutu nanër sir vu Nyëġ-yaġek-yi nabë sir böp. ");
INSERT INTO bzh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Om sa nanër vu ham nabë: Bë ham su sepa doḳ Anutu yi horek bekwesuu alam-horek-yi los alam Parisai* rë, og ham su yoh vu bë rëḳ doḳ na Nyëġ-yaġek-yi rë.” ");
INSERT INTO bzh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ham nġo ġaġek sën neggëp vu alam hib wirek lo ggovek nebë, ‘Su ġengis mehönon denadiiḳ’. Mehöti bë ngis mehö ngwë menadiiḳ, og rëḳ geḳo nyëvewen doḳ nah. ");
INSERT INTO bzh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Gaḳ sa, og sa nanër vu ham nabë: Mehöti bë ahë sengën vu ari, og rëḳ geḳo nyëvewen doḳ nah. Log bë mehöti nanër ġaġek nipaya jaḳ ari, og rëḳ bare kaunsor mala in debo nyëvewen vu yi doḳ nah. Log mehöti bë nanër ngwë nabë, ‘Kwam ma!’ og rëḳ duḳ na nengwah vu Nyëġ-nipaya megeḳo nyëvewen doḳ nah. ");
INSERT INTO bzh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nebë saga lob bë gweḳo honġ seriveng in gwetunġ jaḳ na jepö gëp dub vabuung, loḳ kwam bo nabë melu arim ham ġaġek ti neggëp, ");
INSERT INTO bzh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","og gwevuu honġ seriveng bemedo jepö degwa, geġena vu arim bemelu semu ġaġek govek rë, loḳ mëm ġenom gwetunġ honġ seriveng vu Anutu. ");
INSERT INTO bzh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mehöti bë gevonġ ġaġek vu honġ, lob melu nahën neyök aggata, meneya vu jaas sën nenġo ġaġek lo, og ġepevis bemelu semu ġaġek doḳ ti. In rëḳ getunġ honġ doḳ na jaas nema, lob jaas getunġ honġ doḳ na ahëvavu nemaj, lob ahëvavu degetunġ honġ doḳ na ḳarabus. ");
INSERT INTO bzh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sa nanër vu honġ yönon nabë su rëḳ gwetah honġ vër in ḳarabus pevis rë, gaḳ rëḳ ġemedo rot bena berup doḳ buk sën honġ nyëvewen govek na los dahis lo.” ");
INSERT INTO bzh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ham nġo ġaġek sënë neggëp wirek nebë, ‘Su gwevonġ baggëb’. ");
INSERT INTO bzh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Gaḳ sa, og sa nanër vu ham nabë: Bë maluh ti gelë avëh ti bayo gurekin yi, og saga nebë nevonġ baggëb vu avëh saga loḳ ayo ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Om nabë malam ġahis vesa gevonġ benġaa nipaya kepë honġ, og maam ġeselupek vër megwetë na. Nabë navim len timu mala nama, og mëm nivesa, in su degetë navim pin doḳ na Nyëġ-nengwah-yi. ");
INSERT INTO bzh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Log nabë nemam vesa vonġ benġaa nipaya kepë honġ, og maam kwetöv megwetë na. Nabë navim len timu mala nama, og mëm nivesa, in su degetë navim pin doḳ na Nyëġ-nengwah-yi.” ");
INSERT INTO bzh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Alam hib wirek hir ġaġek ngwë neggëp nebë, ‘Nabë mehöti nidëlin venë, og bo ḳapiya-vepulsën-yi vu yi’. ");
INSERT INTO bzh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Gaḳ sa, og sa nanër vu ham nabë: Avëh ti su nevonġ baggëb rë rëḳ regga nidëlin yi, og mehö saga vonġ bevenë vonġ baggëb, om degwa neggëp vu yi. Gemehöti bë geḳo avëh sën regga nilëlin yi lo, og mehö saga vonġ baggëb vu avëh sënë.” ");
INSERT INTO bzh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Log ham nġo ġaġek ngwë neggëp vu alam hib wirek nebë, ‘Nabë ham nanër ġaġek los nanër yönon vavunë geving, og ham su gwekuung jaḳ, gaḳ ham gwevonġ noh vu gëp Anutu mala’. ");
INSERT INTO bzh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Gaḳ sa, og sa nanër vu ham nabë: Ham su nanër yönon vavunë. Ma rot. Geham su tato yaġek in alam dejaḳ ham ġaġek ni nabë yönon! Gaḳ yö nama rot, in ġaġek saga luho yönon vavunë neggëp ti. In yaġek saga og yiḳ vonġ bë Anutu yi sëa sën nedo raḳ lo. ");
INSERT INTO bzh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Geham su tato dob in alam dejaḳ ham ġaġek ni nabë yönon, gaḳ yö nama rot, in ġaġek saga luho yönon vavunë neggëp ti. Gedob og yiḳ vonġ bë Anutu yi sëa mahen sën nebë vaha raḳ lo. Geham su tato nyëġ böp Yerusalem in alam dejaḳ ham ġaġek ni nabë yönon! Gaḳ yö nama rot, in ġaġek saga luho yönon vavunë neggëp ti. GeYerusalem saga og yiḳ Mehöböp-los-bengö yi nyëġ. ");
INSERT INTO bzh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Gesu ġetato yum in alam dejaḳ honġ ġaġek ni nabë yönon, gaḳ yö nama rot, in ġaġek saga luho yönon vavunë neggëp ti. In su ġeyoh vu bë gwevonġ yum viis ti natu veroo ma veriik jaḳ rë. ");
INSERT INTO bzh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Om nabë ġengoġekin nġaa, og ġengoġekin niröp, rëḳ mu nabë kwam bo nabë ‘Ma!’, og ġenanër ranġah nabë ‘Ma!’ Beyiḳ ggovek. Gaḳ bë ham nanër yönon vavunë geving, og sagaḳ Mehö Nipaya yi nġaa.” ");
INSERT INTO bzh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ham nġo ġaġek sënë neggëp wirek nebë, ‘Bë mehöti selupek malam vër, og ġeselupek hen vahi doḳ nah, genabë mehöti getur nevum vër, og gwetur hen ti doḳ nah’. ");
INSERT INTO bzh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Gaḳ sa, og sa nanër vu ham nabë: Mehöti bë gevonġ paya vu ham, og ham su bo doḳ nah vu yi. Ti bë petap honġ doḳ nengam vesa, og ġepeggirin nengam ḳëj bepetap geving. ");
INSERT INTO bzh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Genabë mehöti vonġin bë geḳo honġ na vu jaas sën genġo ġaġek lo, in nakah honġ röpröp vër, og ġebo honġ röpröp-ayööng-yi vu yi geving. ");
INSERT INTO bzh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Genabë mehö los arë ti nanër vu honġ nabë gweḳo yi ḳupeḳ bemelu na aggata dus ti rë, og gweḳo meġena dus ngwë geving. ");
INSERT INTO bzh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nabë mehöti ketaġ nġaa ti vu honġ, og ġebo vu. Gemehöti bë ketaġ nabë geḳo honġ nġaa ti mena rëḳ geḳo nom, og su gweruu demim vu yi.” ");
INSERT INTO bzh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ham nġo ġaġek sënë neggëp wirek nebë, ‘Ham ahëmin geving ham alam, geham ngis beġö vu alam sën denesis beġö vu ham lo’. ");
INSERT INTO bzh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Gaḳ sa, og sa nanër vu ham nabë: Ham ahëmin geving alam sën denesis beġö vu ham lo, geham najom jaḳ in alam sën denedeġinengin nġaa maggin raḳ ham lo. ");
INSERT INTO bzh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ham gwevonġ nabë saga in tato nabë ham Amamin sën nedo yaġek lo nalu ham. Yi sën nevonġ beyi hes netum raḳ alam nij paya los alam nijvesa pin, genevonġ hob neto vu alam yohvu los alam sevöḳ sevöḳ lo. ");
INSERT INTO bzh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bë ham ahëmin geving alam sën ahëj neving ham lo mu, og ham su rëḳ gweḳo nyëvewen jaḳ rë. Ma! In nġaa nebë saga og yiḳ alam nij paya pin lo denevonġ. ");
INSERT INTO bzh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Genabë ham nġo bengwënġ in ham arimin lo mu, og yiḳ alam dahis pin denevonġ nebë saga medenedo, om ham vonġ nġaa böp tena kesuu sir-a? ");
INSERT INTO bzh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Om ham nġo medo yö niröp anon, nabë sën ham Amamin vu yaġek yö nedo niröp anon.” ");
INSERT INTO bzh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ham gweġin ham. Ham su gwevonġ ham nġaa nivesa vesa jaḳ alam malaj medegelë. Bë ham gwevonġ nabë saga, og ham Amamin sën nedo yaġek lo su rëḳ gevonġ nyëvewen vu ham rë. ");
INSERT INTO bzh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Bë ġedoḳ vu alam sën deneraḳ vu in nġaa lo, og su gwevonġ mehönon degevë avuuḳ los degeḳo ḳapah medenamuġin log ġetamu nabë alam kwaj luu sën denevonġ loḳ dub-supinsën-yi los aggata in bë alam degeḳo arëj jaḳ lo. Sa nanër vu ham yönon nabë deḳo hir nyëvewen ggovek ya raḳ saga, gaḳ su rëḳ denatöḳ vu nyëvewen ngwë vu tamusën rë. ");
INSERT INTO bzh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nabë ġedoḳ vu alam-ḳupeḳ-masën, og nemam ḳëj su jaḳ nġaa sën nemam vesa nevonġ lo ni, ");
INSERT INTO bzh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","gaḳ ġedoḳ vu sir yö gëp vunsën. GAmam vu yaġek neraḳ nġaa sën neggëp vunsën lo ni, om rëḳ bo doḳ nah nyëvewen vu honġ.” ");
INSERT INTO bzh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Log nabë ham najom jaḳ, og ham su gwevonġ nabë alam kwaj luu rë. Ahëj neving panġsën bë denajom jaḳ doḳ dub-supinsën-yi ayo los aggata böp nenga ḳetu, in alam degelë sir. Sa nanër vu ham yönon nabë deḳo hir nyëvewen ggovek ya raḳ saga, gaḳ su rëḳ denatöḳ jaḳ nyëvewen ngwë vu tamusën rë. ");
INSERT INTO bzh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Gaḳ bë ġenajom jaḳ, og ġedoḳ na begganġ ayo beġebehii veluung avi, log mëm ġenajom jaḳ vu Amam sën nedo loḳ nyëġ vunsën saga. Amam saga nedo yaġek menelë nġaa pin sën neggëp vunsën lo, om rëḳ bo doḳ nah nyëvewen vu honġ. ");
INSERT INTO bzh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Log bë ham najom jaḳ, og ham su nanër ġaġek meris meris mu nabë alam dahis. Denekuung bë denanër ġaġek nġahiseḳë, og mëm Anutu rëḳ genġo sir. ");
INSERT INTO bzh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ham su gwevonġ nabë sënë. Gaḳ ham Amamin vu yaġek raḳ nġaa pin sën ham neraḳ vu in lo ni. Yönon, ham nġo nahën geham su kwetaġ vu yi rë, log yö raḳ ni vorot. ");
INSERT INTO bzh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Om ham najom jaḳ nabë sënë: ‘He Amamin sën nedo yaġek, mehönon debo vabuung in arëm. ");
INSERT INTO bzh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ġenam ġenatu he Mehöböp noh vu nyëġ pin, gemehönon pin degevonġ noh vu kwam gëp dob nabë sën angër denevonġ ggëp yaġek lo. ");
INSERT INTO bzh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ġebo nos vu he vu pehi sënë. ");
INSERT INTO bzh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Lob ġedahun he nġaa nipaya na nabë sën he nedahun nġaa nipaya sën mehönon denevonġ vu he lo ya. ");
INSERT INTO bzh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Su gweli he na vu pelëpinsën, gaḳ mu gweḳo he vër in nġaa nipaya pin. (In honġ Nyëġ og Nyëġ anon, gehonġ Anutu los niwëëk, garëm og böpata rot kesuu nġaa pin, neggëp degwata los degwata. Yönon!)’ ");
INSERT INTO bzh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kë! Nabë ham dahun mehönon hir nġaa nipaya na, og rëḳ ham Amamin vu yaġek dahun ham nġaa nipaya na geving nabë saga. ");
INSERT INTO bzh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Gaḳ nabë ham su dahun mehönon hir nġaa nipaya na rë, og ham Amamin vu yaġek su rëḳ dahun ham nġaa nipaya na rë gerëḳ nama.” ");
INSERT INTO bzh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Bë ham ayemin gërin nos geham su gwa rë, og ham su malamin seluh nabë alam kwaj luu sën malaj neseluh in bë alam dejaḳ ni nabë ayej ggërin nos lo. Sa nanër vu ham yönon nabë deḳo hir nyëvewen ggovek ya raḳ saga, gaḳ su rëḳ denatöḳ jaḳ nyëvewen ngwë vu tamusën rë. ");
INSERT INTO bzh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Gaḳ bë ayem gërin nos, og gwetunġ wël* jaḳ yum, geġejipek malam, ");
INSERT INTO bzh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","in alam su dejaḳ ni nabë ayem ggërin nos. GAmam sën nedo vunsën lo yö timu jaḳ ni. Amam vu yaġek nelë nġaa sën neggëp vunsën lo, om rëḳ bo doḳ nah nyëvewen vu honġ.” ");
INSERT INTO bzh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ham su ngupin ham ḳupeḳ nivesa vesa vu dob sënë. In vu dob sënë og nġaa nemoneḳ los jeluj neloḳ benipaya neraḳ, galam hodeḳ denekevoh wes geneggodeḳ ya. ");
INSERT INTO bzh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Gaḳ ham ngupin ham nġaa nivesa vu yaġek. In vu yaġek og nġaa su nemoneḳ rë, gejeluj su neloḳ menipaya neraḳ rë, galam hodeḳ su denekevoh wes gedeneggodeḳ ya rë. ");
INSERT INTO bzh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nyëġ sën ham supin ham ḳupeḳ menedo loḳ lo, og ham su rëḳ kwamin birekin nyëġ saga rë.” ");
INSERT INTO bzh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Malam tu navim yi ram. Bë malam natum in nġaa nivesa, og ranġah rëḳ gegwanġ na navim pin los dahis. ");
INSERT INTO bzh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Gaḳ nabë malam natum in nġaa nipaya, og rëḳ navim pin malaḳenu doḳ. Log ayom malaḳenu bë pemëġin ranġah na, og rëḳ malaḳenu natu böpata jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Hur ti su yoh vu bë gevonġ huk vu ala luu doḳ ti rë. In rëḳ nidëlin ngwë, gahë geving ngwë, ma rëḳ ayo napiiḳ vu ngwë genitebö in ngwë. Ham su yoh vu bë gwevonġ huk vu Anutu los monë doḳ ti rë.” ");
INSERT INTO bzh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Om sën sa bë nanër vu ham nabë ham su newamin jaḳ in ham medoḳ tepëḳ nabë, ‘Hil rëḳ aġa va? Ma hil rëḳ nanum va?’ Geham su newamin jaḳ in navimin nabë, ‘Hil rëḳ ḳebu navid jaḳ va?’ In hil anod kesuu nos gehil navid kesuu tob. ");
INSERT INTO bzh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ham kwamin bo soḳ sën denevëëng medeneyoh yaġek babu lo rë. Su denehin nos ġahis rë, gesu denerur anon bedenesupin raḳ ya begganġ rë, rëḳ ham Amamin vu yaġek nevet sir. Gaḳ ham mehönon, og ham kwesuu soḳ sënë. ");
INSERT INTO bzh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nabë ham ti kwa bo nabë geḳo yi buk sën medo mala vesa lo seggi berup na teka geving, og maḳ yoh vu bë rëḳ gevonġ-a? Ma! ");
INSERT INTO bzh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Om ham su newamin jaḳ in tob! Ham kwamin bo sesik talohek sën nekweḳ pahup ayo lo rë. Su denevonġ huk los denevasu tob rë, ");
INSERT INTO bzh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","log sa nanër vu ham nabë wirek Solomon* los yi vuneḳ-vuneḳ niḳapiik neggërin yi, rëḳ ti su nivesa nebë sesik sënë rë. ");
INSERT INTO bzh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yönon, Anutu neġin nivesa vos sën nare gwëbeng, gerëḳ dekesik neheng bedebesi jaḳ na nengwah. Om nebë va sën ham su ayomin neya timu vu Anutu rë-ë? Ham jaḳ ni nabë Anutu rëḳ geġin ham geving bekesuu saga. ");
INSERT INTO bzh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Om ham su newamin jaḳ menanër nabë, ‘He rëḳ aġa va? Ma nanum va? Ma ajöp va?’ ");
INSERT INTO bzh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","In alam dahis vu dob yiḳ kwaj nevo nġaa pin sënë panġsën bë denatöḳ vu. Gaḳ ham Amamin vu yaġek raḳ nġaa pin sën ham neraḳ vu in lo ni ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Om ham malamin sepa Anutu namuġin nabë nam geġin ham geham gwevonġ nġaa niröp noh vu kwa, loḳ mëm nġaa pin saga og rëḳ gevonġ vu ham geving. ");
INSERT INTO bzh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ham su kwamin bo nġaa maggin neheng yi benewamin jaḳ pehi. Gaḳ nġaa neheng yi, og neheng rëḳ ham kwamin bo. Nġaa maggin neggëp loḳ buk pin, om ham kwamin bo buk ti ti yö yi maggin doḳ buk saga lo beggovek.” ");
INSERT INTO bzh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ham su seggi mehö ngwë doḳ ayomin nabë mehö nipaya, in lob Anutu su seggi ham benanër ham nabë ham alam nimin paya. ");
INSERT INTO bzh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","In Anutu rëḳ seggi ham ġaġek nabë sën ham neseggi mehö ngwë hir ġaġek lo. Gerëḳ gevonġ doḳ nah vu ham nabë sën ham nevonġ vu mehö ngwë lo. ");
INSERT INTO bzh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ma nebë va sën ġenelë ḳale mahen teka sën negga raḳ arim mala lo, log su ġenelë ġanġ dus ti sën neggëp loḳ malam aga rë-ë? ");
INSERT INTO bzh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ma nebë va sën ġenër vu arim bë, ‘Ḳööḳ gesa hevonġ ḳale vër in malam ġahis rë.’ Gwelë rë, ġanġ dus ti neggëp loḳ nġo malam ġahis. ");
INSERT INTO bzh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Honġ mehö kwam luu! Gwevonġ ġanġ dus ti saga vër in malam govek rë, loḳ mëm rëḳ gwelë nġaa mahen teka sën neggëp loḳ arim mala aga nivesa meġebo vër. ");
INSERT INTO bzh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ham su gwevonġ Anutu yi nġaa vabuung vu anöö! Geham su gwetë ham nġaa vuneḳsën sën ham nebaġo raḳ monë böp lo na vu bööḳ. In rëḳ debaḳë duḳ dob jaḳ vahaj, log depekwë medega ham.” ");
INSERT INTO bzh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Bë ham kwetaġ nġaa vu Anutu og rëḳ bo vu ham, bë ham sero nġaa, og ham rëḳ natöḳ jaḳ, bë ham pepa jaḳ repinġ, og Anutu rëḳ tahinin vu ham. ");
INSERT INTO bzh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","In alam sën deneketaġ nġaa vu Anutu lo, og nevo vu sir, log alam sën denesero nġaa lo, og denetöḳ raḳ, galam sën denepepa raḳ repinġ lo, og netahinin vu sir. ");
INSERT INTO bzh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bë ham ti nalu ketaġ nos vu ama, og rëḳ bo ġelönġ vu yi? Ma! ");
INSERT INTO bzh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Log bë mehöti nalu ketaġ yi in ġël ti, og ama rëḳ bo nyël ti vu yi? Ma rot! ");
INSERT INTO bzh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ham alam nimin paya vu dob sënë, rëḳ ham kwamin nevo nalumin lo menevonġ nġaa nivesa vu sir, om ham jaḳ ni borot nabë ham Amamin sën nedo yaġek lo nevonġ nġaa nivesa rot kesuu ham, om rëḳ gevonġ nġaa nivesa vesa vu alam sën deneketaġ vu yi lo. ");
INSERT INTO bzh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nġaa pin sën ham ahëmin neving bë alam degevonġ vu ham lo, og ham gwevonġ vu sir namuġin. Horek los alam denenër-ġaġek-ranġahsën hir ġaġek lo degwa nebë sënë.” ");
INSERT INTO bzh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ham doḳ na aggata avi mahen in aggata sënë neya Nyëġ Mala-tumsën-yi. Gaḳ aggata sën neya Nyëġ Nipaya lo, og böpata beneggëp tateḳinsën, lob alam nġahiseḳë deneyoh ya saga rot. ");
INSERT INTO bzh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Gaḳ aggata sën neya Nyëġ Mala-tumsën-yi lo, og mahen teka, behuk böp, lob alam ti ti mu denetöḳ raḳ medeneloḳ ya.” ");
INSERT INTO bzh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ham gweġin ham vu alam-ġaġek-kuungsën. In alam saga nebë mehönon dekebu sir raḳ sipsip navij gedeneloḳ yök vu ham in bë ham gwekuung nabë sir alam nijvesa. Rëḳ mu ayoj peggo nipaya nebë anöö bemën sën vonġin dega ham. ");
INSERT INTO bzh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ham nġo rëḳ jaḳ nij jaḳ hir huk sën degevonġ lo. In mehöti su nerur vud anon raḳ aggis niggin ti jes rë, gemehöti su nerur mori anon raḳ jajap rë gema. ");
INSERT INTO bzh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ḳele nivesa pin yö nesis anon nivesa, geḳele nipaya yö nesis anon nipaya. ");
INSERT INTO bzh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ḳele nivesa su yoh vu bë ngis anon nipaya rë, geḳele nipaya su yoh vu bë ngis anon nivesa rë. ");
INSERT INTO bzh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ḳele pin sën su nesis anon nivesa rë lo, og denevuv medenetë raḳ ya nengwah. ");
INSERT INTO bzh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Om ham gwelë alam-ġaġek-kuungsën hir huk, beham jaḳ nij nabë saga.” ");
INSERT INTO bzh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Alam pin sën ayej neloḳ sa bë ‘Mehöböp! Mehöböp!’ lo, saga sir pin su rëḳ dedoḳ na Nyëġ-yaġek-yi medenatu Anutu-yi-alam rë, gaḳ yiḳ alam sën denesepa loḳ Amaġ yi ġaġek lo sën rëḳ dedoḳ na Nyëġ-yaġek-yi medenatu yi alam. ");
INSERT INTO bzh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Vu Buk-tamusën og alam nġahiseḳë rëḳ ayej doḳ sa nabë, ‘Mehöböp! Mehöböp! He nër ġaġek ranġah raḳ arëm, los hetii memö to deya in mehönon raḳ arëm, gehe hevonġ nġaa böp nġahiseḳë raḳ arëm!’ ");
INSERT INTO bzh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Rëḳ ma gesëḳ nanër vu sir nabë, ‘Sa su raḳ ham nimin rë. Ham alam nimin paya, ham jaḳ na nenga in sa!’” ");
INSERT INTO bzh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Alam sën degenġo sa ġaġek bedesepa doḳ lo, og sir nebë mehö los kwa sën lev yi begganġ raḳ nedo ġelönġ böp. ");
INSERT INTO bzh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Lob hob to raḳ mebël vaar böp gesanġ böp vë begganġ saga, rëḳ su kevoh ya rë, in begganġ saga yi mudeng luḳ ya ġelönġ meving ahon niwëëk. ");
INSERT INTO bzh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Gaḳ alam pin sën degenġo sa ġaġek pin rëḳ su desepa doḳ rë lo, og sir nebë mehö kwa masën, sën lev yi begganġ raḳ nedo raggër. ");
INSERT INTO bzh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lob hob to raḳ, mebël vaar böp, gesanġ böp vë begganġ saga, lob kevoh pevis bekevoh ya veröḳ yi in raggër niyes.” ");
INSERT INTO bzh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu nër ġaġek sënë ggovek, lob alam yu böpata saga delëk bavij töḳ in yi ġaġek, ");
INSERT INTO bzh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","in su nenër vu sir nebë alam-horek-yi lo rë. Gaḳ nenër nebë mehö los niwëëk ti. ");
INSERT INTO bzh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu vu ḳedu meluḳ meya, lob alam nġahiseḳë detamuin yi. ");
INSERT INTO bzh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lob mehöti los nisevuuḳ yam dus vu yi bepetev meneggëp loḳ vaha genër bë, “Mehöböp! Nabë ahëm geving og ġeyoh vu bë gwevonġ mesa niġ veseek jaḳ!” ");
INSERT INTO bzh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Lom Yesu bë nema raḳ yi genër bë, “Sahëġ ving! Om nim veseek jaḳ!” Lob yiḳ sevuuḳ saga mehor ya pevis. ");
INSERT INTO bzh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Lob Yesu nër vu yi bë, “Gweġin honġ! Su ġena ġenanër nġaa sënë vu mehö la. Gaḳ mëm ġena ġetato honġ vu mehö-neḳo-seriveng gegwetunġ seriveng noh vu sën Moses nër wirek bë hil ġevonġ lo, in alam pin dejaḳ ni nabë nim veseek raḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu loḳ ya Kapernaum, lob alam-beġö-yi vu Rom yu ti yoh vu mehödahis nemadvahi hir ggev nedo, lob ya vu yi meketaġ bë doḳ vu yi. ");
INSERT INTO bzh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ketaġ bë, “Mehöböp! Sa hur niraḳ meneggëp begganġ ayo; seḳë selönġin benesanġ panġsën rot.” ");
INSERT INTO bzh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Lom Yesu nër bë, “Sëḳ nök ġevonġ benivesa jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Rëḳ mehö neġin alam-beġö-yi nër yah bë, “Mehöböp, sa su mehö niġ vesa yoh vu bë ġedoḳ na sa begganġ rë. Om yiḳ ġenanër jaḳ avim mu gesa hur nivesa jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gaḳ yiḳ sa mehö los niġ wëëk ti ving. Sa nahurek sa alaġ sën neġin sa menevo huk vu sa lo babu, log senġo salam-beġö-yi sën sa neheġin sir lo deneggurek sa babuġ ving nebë saga. Bë sa nanër vu sir ti nabë, ‘Ġena!’ og rëḳ na, gesa nanër vu ngwë nabë, ‘Ġenam!’ og rëḳ nam. Gesa nanër vu sa hur nabë, ‘Gwevonġ nġaa sënë!’ og rëḳ gevonġ. Om yiḳ ġenanër jaḳ avim mu og yiḳ yoh vu.” ");
INSERT INTO bzh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu nġo, lom ranġa nema genër vu alam sën denetamuin yi lo bë, “Sa nanër vu ham yönon nabë sa su töḳ vu Israel ti gayo neyam timu vu sa nebë sënë rë. ");
INSERT INTO bzh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Gesa nanër vu ham nabë alam nġahiseḳë vu nyëġ mala neverup los nemasuseḳ ya yö rëḳ dena bemedo dega nos doḳ Nyëġ-yaġek-yi geving Abraham lööho Isaak lu Yakop. ");
INSERT INTO bzh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Gaḳ alam Yuda og Anutu rëḳ getii vahi na nyëġ malaḳenu dobnë medengu medegeköö nyëj, gesu rëḳ dedoḳ na demedo Nyëġ-yaġek-yi rë. ");
INSERT INTO bzh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Lob Yesu nër vu mehö neġin alam-beġö-yi bë, “Ġenah meġena böm, gerëḳ anon jaḳ vu honġ noh vu honġ ġaġek sën ġevonġ ving agi.” Lob nahën nenër log mehö neġin alam-beġö-yi lo yi hur nivesa raḳ pevis. ");
INSERT INTO bzh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu raḳ ya Pita yi begganġ, lob lë Pita ggen avëh nivanë meneggëp begganġ ayo. ");
INSERT INTO bzh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Lom Yesu jom loḳ nema, lob nikul ya gekedi raḳ menevonġ nos vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Log sehuksën lom deḳo alam nġahiseḳë sën memö denegwanġ ya sir lo medeyam vu yi, lob tii memö raḳ avi mu meto deya, gevonġ balam hir niraḳsën aggagga pin nivesa raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Vonġ nġaa sënë lob mehö-nenër-ġaġek-ranġahsën Yesaya yi ġaġek anon raḳ. Sën nër nebë: “Yö ti vo hil niraḳsën vër, geḳo hil nivanë aggagga raḳ yah yi.” ");
INSERT INTO bzh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu lë alam nġahiseḳë yam detetup yi, lob nër vu yi hur maluh bë dejaḳ yaġ medena nġaggee böp nenga vahi. ");
INSERT INTO bzh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Lob alam-horek-yi ti ya vu yi menër bë, “Tatovaha! Nyëġ pin sën ġena lo, og sëḳ sepa honġ bena geving.” ");
INSERT INTO bzh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Rëḳ Yesu nër yah vu bë, “Anöösik lej neggëp, gesoḳ newisej nedo, gaḳ Mehönon Nalu og ben sën gëp doḳ lo ma!” ");
INSERT INTO bzh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Log yi hur maluh lo ngwë nër bë, “Mehöböp! Amaġ nadiiḳ besedev rë, loḳ mëm senök tamuin honġ.” ");
INSERT INTO bzh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Loḳ Yesu nër yah vu bë, “Ġetamuin sa, galam-diiḳsën yö rëḳ dedev hir heljënġ.” ");
INSERT INTO bzh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu raḳ ya nedo yaġ geyi hur maluh deraḳ ya ving. ");
INSERT INTO bzh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Deraḳ meto deya nġaggee vuheng, lob pevis besanġ yam böp bevonġ nġaggee sis bevonġin dahun yaġ. Rëḳ Yesuḳ ggëp yiing. ");
INSERT INTO bzh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Loḳ yi hur maluh ya deggee vu yi gedenër bë, “Mehöböp! Ġedoḳ vu hil! Hil hevonġin nadiiḳ bemalad nama!” ");
INSERT INTO bzh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Loḳ nër yah vu sir bë, “Ham newamin neraḳ in-a? Ham su ayomin neyam timu vu sa yönon rë!” Nër bë saga log kedi petupek raḳ sanġ los nġaggee, lob ahë yes raḳ bededun ma geneggëp. ");
INSERT INTO bzh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Lom sir pin delëk mederanġa nemaj gedenër bë, “Mehö sënë nebë va? Om sën sanġ los nġaggee denġo aye-ë!” ");
INSERT INTO bzh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Loḳ tum Yesu ya verup Gadara hir nyëġ vu nġaggee nenga vahi, lob töḳ raḳ mehö luu, geluho vu waaḳ sën denebë mehönon seḳëj loḳ lo avi medetöḳ to. Memö nedo loḳ luho beluho nij wëëk ata, lob alam deneggönengin luho gesu deneyoh aggata saga rë. ");
INSERT INTO bzh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Lob luho pevis bedenġeeḳ bë, “Anutu Nalu honġ! Bë gwevonġ va vu he? Buk yö nahën, log ġeyam sënë in bë ġebo vanë vu he namuġin-a?” ");
INSERT INTO bzh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Lob bööḳ yu ti vare deneruuk raḳ ḳedu sënë medenare ading teka. ");
INSERT INTO bzh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Lob memö deketaġ vu Yesu bë, “Nabë gwetii he na, og gwevonġ he na madoḳ na bööḳ yu ti sagu!” ");
INSERT INTO bzh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Lob Yesu nër vu sir bë, “Ham na!” Nebë saga lob to deya meya deloḳ ya bööḳ, lob bööḳ pin saga deseröġ niwëëk beya depesönġ ya nyëġ vaha degwa ti, bedeluḳ ya nġaggee berehöö sir pin bemalaj maya veröḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Log alam sën deneġin bööḳ lo deveya medeya nyëġ böp beya denër ġaġek pin ranġah vu hir alam, los memö yi ġaġek ving. ");
INSERT INTO bzh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lom alam pin vu nyëġ saga deyah medeya denesero Yesu. Detöḳ vu yi lom deketaġ vu yi bë gevuu hir nyëġ gena. ");
INSERT INTO bzh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu raḳ yah yaġ beyah los nġaggee nenga vahi betöḳ ya yi nyëġ. ");
INSERT INTO bzh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Lob mehö la devaḳu mehöti seḳë selönġin raḳ reek medeya vu yi. Yesu lë bë ayoj neya timu vu yi, lom nër vu mehö seḳë selönġinsën bë, “Naluġ-e! Ayom sepëp jaḳ! In sa dahun honġ nġaa nipaya ya.” ");
INSERT INTO bzh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lob tum alam-horek-yi vahi denġo bekwaj nevo loḳ ayoj bë, “Mehö sënë ḳo yi raḳ besevöḳ Anutu!” ");
INSERT INTO bzh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Rëḳ Yesu raḳ nġaa sën kwaj nevo loḳ ayoj lo ni, lom nër vu sir bë, “Ham kwamin nevo ġaġek nipaya nebë sënë loḳ ham ayomin in va? ");
INSERT INTO bzh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ham kwamin nevo ġaġek sën senër bë, ‘Sa dahun honġ nġaa nipaya ya’ agi lo bë anon ma? In re yoh vu bë gelë nabë dahun ya yönon-a? Rëḳ mu mëm nabë sa nanër vu yi nabë, ‘Kwedi jaḳ meġena’, og mëm ham rëḳ jaḳ ni nabë sa nanër ġaġek los anon. ");
INSERT INTO bzh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Om sa bë ham jaḳ ni nabë Mehönon Nalu niwëëk yoh vu bë dahun nġaa nipaya na vu dob—”; log peggirin menër vu mehö seḳë selönġinsën bë, “Kwedi gweḳo honġ reek jaḳ meġenah böm!” ");
INSERT INTO bzh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Lob mehö lo kedi raḳ meyah ben. ");
INSERT INTO bzh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Galam delë nġaa sënë lom deggöneng rot, gedeḳo Anutu arë raḳ in vonġ niwëëk nebë sënë vu mehönon in bë dedoḳ vu mehönon vahi. ");
INSERT INTO bzh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Lob Yesu kedi raḳ vu saga meya, lom lë mehöti nedo raḳ begganġ-takës-yi, arë nebë Matai. Lom nër vu yi bë, “Ġenam ġetamuin sa!” Lob Matai kedi raḳ meya tamuin yi. ");
INSERT INTO bzh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Loḳ tum Yesu medo negga nos loḳ Matai ben, lob alam-deneḳo-takës* losho alam-nijpaya nġahiseḳë yam denedo medenegga nos ving losho yi hur maluh. ");
INSERT INTO bzh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Alam Parisai* la delë nebë saga lom denër vu yi hur maluh bë, “Nebë va sën ham tatovaha negga nos ving alam-deneḳo-takës* losho alam-nijpaya-ë?” ");
INSERT INTO bzh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Rëḳ Yesu nġo hir ġaġek menër yah vu sir bë, “Alam nijvesa su deneya vu dokta rë, gaḳ alam nijraḳsën mu yö deneya vu. ");
INSERT INTO bzh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Om ham nah bekwamin bo ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo degwa rë. Sën nenër bë: ‘Sa su hevonġin bë ġaḳo seriveng sën ham nevesi vu sa lo rë.’ Gaḳ sahëġ ving bë ham kwamin paya in alam beham doḳ vu sir. In sa su yam in bë tahi alam yohvu rë, gaḳ seyam in bë tahi alam sën nġaa nipaya neggëp vu sir lo.” ");
INSERT INTO bzh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lob buk ngwë lom mehö-neripek-alam Jon yi hur maluh deya vu Yesu medeloḳ tepëḳ in yi bë, “He los alam Parisai* ayemin neggërin nos buk nġahiseḳë gehe su naha rë, log honġ hur maluh og su denevonġ rë in va?” ");
INSERT INTO bzh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Loḳ Yesu peggirin ġaġek raḳ mehö sën neḳo avëh lo benër yah bë, “Ham kwamin bo rë, nabë mehöti medo geving yi alam geluho avëh ti denajom nemaj. Bë nabë sënë og yi alam sënë su rëḳ ayoj maggin medengu rë. Rëḳ mëm buk sën debo mehö sën geḳo avëh lo vër, besu medo geving yi alam rë, og mëm yi alam rëḳ ayoj maggin gayej gërin nos doḳ buk saga. ");
INSERT INTO bzh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Log mehöti su neḳo tob mewis sën su deneripek rë lo len ti meneduu tob muġeng sën nekweeḳ lo raḳ rë. Nabë gevonġ nabë saga, og rëḳ dejipek lob tob mewis sënë najul menom, getob muġeng sënë rëḳ nakweeḳ gökin belen böpata rot. ");
INSERT INTO bzh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Gemehöti su netöö wain* mewis loḳ memëk-navi muġeng rë. Bë gevonġ nabë sënë og rëḳ wain ngol navi muġeng sën bebepul gekeseh geto mena meris, gememëk-navi nipaya jaḳ geving. Gaḳ mëm denatöö wain* mewis doḳ na memëk-navi mewis, og mëm luho rëḳ demedo nivesa doḳ ti.” ");
INSERT INTO bzh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu nahën nenër ġaġek sënë vu sir, lob alam Yuda hir dub-supinsën-yi ala ti yam vu Yesu beyun lus vu yi log nër bë, “Sa naluġ avëh nahën nediiḳ gwëbengko, om ġenam gwebë nemam jaḳ yi in vesa doḳ nah.” ");
INSERT INTO bzh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Lob Yesu kedi tamuin yi beya, lob yi hur maluh kedi deya ving yi. ");
INSERT INTO bzh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Log avëh ti niḳöḳ neyam ata yoh vu nġebek nemadluho-mevidek-luu, lob verup ggëp Yesu demi bebë nema raḳ Yesu yi tob nyë. ");
INSERT INTO bzh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","In kwa nevo ggëp ayo nebë, “Bë sa ġebë nemaġ jaḳ yi tob mu, og sëḳ niġ vesa jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Lom Yesu ggërin melë avëh lom nër vu yi bë, “Naluġ-e, kwam vesa! In ayom yam timu vu sa lob vonġ benimvesa raḳ.” Lob pevis bavëh nivesa raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Lob Yesu ya verup dub ala lo yi begganġ. Lom nġo alam denevë ġevëëġ apel heljënġ yi los denevonġ dedun böp, loḳ nër vu sir bë, ");
INSERT INTO bzh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Ham jaḳ na! Avëh mahen su diiḳ rë, gaḳ mu neggëp yiing!” Rëḳ denöp raḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lob Yesu tii sir beto deyah dobnë, geloḳ ya bejom loḳ avëh mahen nema bekedi raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Lob ġaġek lo bengö ya meyoh vu nyëġ saga pin meya. ");
INSERT INTO bzh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Log Yesu kedi vu nyëġ saga meya, lom mehö luu malaj ḳenod detamuin yi, bedetahi bë, “Davit* yi Mewis-e! Kwam gevonġin aluu!” ");
INSERT INTO bzh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu ya verup loḳ ya begganġ ayo, loḳ luho deyam vu yi, lob loḳ tepëḳ in luho bë, “Melu vonġ ving bë seyoh vu bë ġevonġ melu malamin nivesa jaḳ, ma ma?” Loḳ luho deyoġek bë, “Ëë-ë, Mehöböp. Ġeyoh vu.” ");
INSERT INTO bzh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Lob Yesu bë nema raḳ luho malaj genër bë, “Om anon jaḳ noh vu sën melu ayomin nam vu sa agi!” ");
INSERT INTO bzh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Lob luho malaj tum yah, log Yesu vo ḳooin luho bë, “Melu su na nanër nġaa sënë vu mehö la.” ");
INSERT INTO bzh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Rëḳ ma geluho to deya lob denër Yesu bengö ya meyoh vu nyëġ saga pin. ");
INSERT INTO bzh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Luho to deneya log alam deḳo mehöti verup, sën su yoh vu bë bengwënġ rë in memö kwa-nġengöleng-yi nedo loḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Lob Yesu tii memö saga to meya log mëm nevengwënġ. Lob alam nġahiseḳë saga kwaj ya nġahi mederanġa nemaj gedenër bë, “Wirek hil su halë nġaa ti nebë sënë ggëp Israel rë!” ");
INSERT INTO bzh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Rëḳ alam Parisai* denër bë, “Netii memö to deneya raḳ memö alaj niwëëk.” ");
INSERT INTO bzh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Lob Yesu ya meyoh vu nyëġ böp los mahen pin, betateḳin ġaġek vu sir loḳ hir dub-supinsën-yi ayo yoh vu nyëġ. Benër Bengö Nivesa raḳ Anutu-yi-nyëġ, gevonġ alam los niraḳsën aggagga genġaa maggin sën neggëp navij lo pin benijvesa raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lë alam nġahiseḳë saga, lom kwa vonġin sir. In medo deneketul loḳ gedenedo paya rot nebë sipsip sën alaj main sir lo. ");
INSERT INTO bzh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nebë saga lob peggirin ġaġek menër vu yi hur maluh bë, “Nos nġahiseḳë anon loḳ menedo huk anon, rëḳ alam sën deketöv medengupin lo su nġahi rë. ");
INSERT INTO bzh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Om ham kwetaġ vu huk ala nabë gevonġ yi hur na debo yi nos medengupin nom!” ");
INSERT INTO bzh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu tahi yi hur maluh nemadluho-bevidek-luu yam bevo niwëëk vu sir bë degetii memö geto dena los degevonġ balam sën niraḳsën aggagga pin töḳ vu sir lo nijvesa jaḳ, jaḳ arë. ");
INSERT INTO bzh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Sinarë nemadluho-bevidek-luu sënë arëj sënë: Mehö muġinsën Simon (sën denenër arë ngwë nebë Pita) log ari Andreas, geYakobus luho ari Jon sën Sebedi nalu luho, ");
INSERT INTO bzh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","lob Pilip geBartolomai, Tomas geMatai, sën yi mehö-neḳo-takës*. Log Yakobus ngwë sën Alpeus nalu, geTadaius. ");
INSERT INTO bzh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Log Simon sën yi mehö-neruuk-alam-Rom, luho Yudas Iskariot sën rëḳ nanër Yesu tato vu alam-beġö-yi lo. ");
INSERT INTO bzh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Lob Yesu vonġ yi hur maluh nemadluho-bevidek-luu sënë ya, log nër ġaġek vu sir ving bë, “Ham su na vu alam-yu-ngwë. Geham su doḳ na alam Samaria* hir nyëġ. ");
INSERT INTO bzh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Gaḳ ham na vu sipsip Israel sën deneketul loḳ bevonġin malaj nama lo. ");
INSERT INTO bzh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ham na nanër vu sir nabë sënë: ‘Nyëġ-yaġek-yi vonġin anon jaḳ!’ ");
INSERT INTO bzh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ham gwevonġ balam nijraḳsën nijvesa jaḳ, geham gwevonġ beheljënġ vesaj doḳ. Ham gwevonġ balam nij sevuuḳ nij veseek jaḳ, geham gwetii memö geto dena in alam. Sevo niġ wëëk yök vu ham nyëmasën gemonë ma, om ham gwevonġ meris vu sir geham su gweḳo monë jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ham su gweḳo monë goor ma seriva, ma monë ḳöḳ sepa doḳ ham ḳeggis. ");
INSERT INTO bzh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Geham su gweje vahek sepa mena aggata, beham su gweḳo röpröp luu luu, beham su gweḳo suu ngwë geving, beham su natohin atohenġ. Gaḳ yö nama rot! In alam sën ham nanër ġaġek vu sir gedoḳ vu sir lo rëḳ dedoḳ vu ham medebo nos lu nġaa vu ham. ");
INSERT INTO bzh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Sën ham na nyëġ böp ti ma begganġ-bu mahen ti lo, og ham doḳ tepëḳ in alam nijvesa in degeġin ham, lob mëm ham medo geving sir rot beham na jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lob nabë ham doḳ na begganġ ti ayo, og ham nanër ġaġek semusën vu alam saga. ");
INSERT INTO bzh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nabë sir alam nijvesa, og ham ġaġek semusën rëḳ na vu sir. Gaḳ nabë sir alam nij paya, og ham ġaġek semusën rëḳ pekwë menom vu ham. ");
INSERT INTO bzh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Log nabë mehö la su degeġin ham nivesa gëp hir begganġ ma hir nyëġ rë, besu degenġo ham ġaġek rë, og ham tetëhin kebus in ham vahamin in dejaḳ ni nabë devonġ paya, gegwevuu begganġ ma nyëġ saga geham na. ");
INSERT INTO bzh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sa nanër vu ham yönon nabë, vu Buk-tamusën, sën Anutu genġo mehönon hir ġaġek lo, og rëḳ alam vu nyëġ saga denatöḳ vu nyëvewen böpata rot kesuu Sodom los Gomora.” ");
INSERT INTO bzh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ham gwenġo rë, sa nehevonġ ham ya nebë sën sipsip deneloḳ ya anöö bemën avij. Om ham kwamin bo namuġin begwevonġ ham nġaa los kwamin nabë sën hil nanër nyël bë denevonġ nġaa los kwaj lo. Geham malamin yes nabë sën hil nanër nuung bë malaj yes lo. ");
INSERT INTO bzh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ham gweġin ham in mehönon. In rëḳ degeḳo ham na ġaġek vu kaunsor bedebeek ham doḳ hir dub-supinsën-yi. ");
INSERT INTO bzh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Log rëḳ degeḳo ham na bare doḳ kiap böp los alam-los-bengöj böp lo malaj, in salam ham, lob ham rëḳ nanër sa ranġah vu sir gevu alam dahis. ");
INSERT INTO bzh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nabë degeḳo ham na ġaġek, og ham su newamin jaḳ nabë, ‘Maḳ hil rëḳ nanër ġaġek nah nabë va? Ma hil rëḳ nanër ġaġek re?’ Gaḳ doḳ buk saga og Anutu yö rëḳ gevonġ ġaġek sën ham nanër vu sir lo vu ham. ");
INSERT INTO bzh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","In ham su nġo rëḳ nanër ġaġek saga rë, gaḳ ham Amamin yi Anon Vabuung yö rëḳ nanër ġaġek berup ham avimin. ");
INSERT INTO bzh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Alam rëḳ degevonġ arij lo doḳ na alam-beġö-yi nemaj bedengis sir medenadiiḳ. Log amaj rëḳ degevonġ nabë saga vu naluj. Log hurmahen rëḳ degelë amaj lu ataj paya medenanër sir ranġah bedengis sir medenadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Lob rëḳ alam pin degelë ham paya in salam ham. Gaḳ alam sën denajom sir ahon rot, bena berup doḳ buk sën denadiiḳ lo, saga rëḳ Anutu geḳo sir nom vu yi. ");
INSERT INTO bzh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lob nabë degevonġ paya vu ham vu nyëġ la, og ham beya mena nyëġ ngwë. Sa nanër vu ham yönon nabë ham nahën gesu rëḳ semu huk na gëp nyëġ Israel pin rë, log Mehönon Nalu rëḳ nom. ");
INSERT INTO bzh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Hur maluh ti su kesuu yi tatovaha rë, log hur-huk-meris-yi ti su kesuu ala rë. ");
INSERT INTO bzh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nabë hur maluh arëj böp jaḳ nabë hir tatovaha, og ggovek. Genabë hur-huk-meris-yi arëj böp jaḳ nabë alaj, og yoh vu. Nabë denanër Belsebul* jaḳ begganġ ala, og rëḳ denanër yi hur nabë saga los denanër ggev nipaya la jaḳ sir geving.” ");
INSERT INTO bzh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Om ham su ġönengin mehönon. Nġaa pin sën neggëp vunsën gwëbeng rëḳ natöḳ nam ranġah vu tamusën. Genġaa pin sën debom meneggëp loḳ ġobeng gwëbeng agi, og nahub rëḳ alam pin dejaḳ ni. ");
INSERT INTO bzh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ġaġek sën sa nanër vu ham vunsën lo, og ham nanër na ranġah. Geġaġek sën sa nepatereng loḳ ya ham nengamin lo, saga ham bare jaḳ telig getahi na ranġah. ");
INSERT INTO bzh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ham su ġönengin alam sën dengis ham navimin mu menadiiḳ lo, in su deyoh vu bë rëḳ dengis ham anomin geving rë. Gaḳ mëm ham ġöneng in Mehö sën yoh vu bë kevoh ham navimin los anomin doḳ Nyëġ-nengwah-yi lo. ");
INSERT INTO bzh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ham yoh vu bë baġo soḳ mahen luu jaḳ toea timu, rëḳ soḳ saga ti su rëḳ mala nama vunsën geham Amamin duġin rë. ");
INSERT INTO bzh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Gaḳ ham og Anutu tevin ham yumin viis pin los dahis beneraḳ ni. ");
INSERT INTO bzh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Om ham su ġönengin ham, in kwa nevo ham kesuu soḳ nġahiseḳë meneġin ham.” ");
INSERT INTO bzh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mehöti bë nanër yi ranġah vu mehönon nabë sa alam yi, og sëḳ nanër yi ranġah nabë saga vu Amaġ sën nedo yaġek lo. ");
INSERT INTO bzh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Log bë mehöti dah sarëġ vun in mehönon nabë su sa alam yi rë, og sëḳ dah arë vun in Amaġ sën nedo yaġek lo.” ");
INSERT INTO bzh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ham su gwekuung nabë seyam in ġevonġ mamer vu dob. Ma! Sa su yam in mamer rë, gaḳ seyam in beġö berup. ");
INSERT INTO bzh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Seyam in ġevonġ ġaġek-beġö-yi berup galam degelë sir paya in sa los sa ġaġek. Mehönon losho amaj ahëj sengën vu sir. Log avëh losho ataj ahëj sengën vu sir, gavëh atov losho ggej denapëëng sir, ");
INSERT INTO bzh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","galam sën denedo raḳ begganġ timu lo depemëġin sir. ");
INSERT INTO bzh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mehöti bë ahë geving ama ma ata rot kesuu sa, og su yoh vu bë rëḳ natu sa alam rë. Log bë mehöti ahë geving nalu maluh ma avëh kesuu sa, og su yoh vu bë rëḳ natu sa alam rë. ");
INSERT INTO bzh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Log mehöti bë su bër yi ḳelepeḳo* jaḳ metamuin sa rë, og su yoh vu bë rëḳ natu sa alam rë. ");
INSERT INTO bzh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mehöti bë kwa bo yi, og su rëḳ medo mala-tumsën rë. Gaḳ mehöti bë kwa bo sa gekwa birek in yi, og rëḳ medo mala-tumsën.” ");
INSERT INTO bzh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mehöti bë gevonġ nivesa vu ham, og vonġ nivesa vu sa. Gemehöti bë gevonġ nivesa vu sa, og vonġ nivesa vu Mehö sën vonġ sa meseyam lo ving. ");
INSERT INTO bzh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mehöti bë geḳo mehö-nenër-ġaġek-ranġahsën ti jaḳ in yi mehö-nenër-ġaġek-ranġahsën, og luhoho rëḳ degeḳo hir nyëvewen gëp ti. Gemehöti bë geḳo mehö niröp ti jaḳ in yi mehö niröp, og luhoho rëḳ degeḳo hir nyëvewen gëp ti. ");
INSERT INTO bzh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Log mehöti bë geḳo bël kul mebo vu sa mehö meris ti menanum in raḳ ni bë sa hur, og sa nanër vu ham yönon nabë, mehö sënë yi nyë vewen neggëp vu yaġek.” ");
INSERT INTO bzh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu nër ġaġek saga vu yi hur maluh nemadluho-bevidek-luu ggovek, log kedi raḳ beya begganġ-bu sën deneggëp dus vu nyëġ saga in bë tateḳin ġaġek vu sir. ");
INSERT INTO bzh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Log Mehö-neripek-alam Jon nedo ḳarabus genġo nġaa böp sën Kerisi* nevonġ lo bengö, lob vonġ yi hur maluh la deya vu Yesu in bë dedoḳ tepëḳ in yi nabë, ");
INSERT INTO bzh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Maḳ honġ mehö sën Jon nër bengöm bë rëḳ ġenam lo sënë, ma he rëḳ medo ġeġin yi rë?” ");
INSERT INTO bzh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Lob Yesu nër yah vu sir bë, “Ham nah mena nanër nġaa sën ham nġo los ham lë lo vu Jon nabë, ");
INSERT INTO bzh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","alam malaj ḳenod denelë nyëġ ggökin, galam vahaj paya deneya aggata, galam nij sevuuḳ nij veseek neraḳ galam nengaj mir denenġo ġaġek, galam sën denediiḳ lo vesaj neloḳ yah, log alam sën denedo paya in nġaa navij yi lo denenġo Bengö Nivesa. ");
INSERT INTO bzh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mehöti sën su kwa luu luu in sa rë lo, og kwa vesa!” ");
INSERT INTO bzh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lob Jon yi hur maluh deyah loḳ mëm Yesu yom nër Jon degwa vu alam yu böpata saga nebë, “Wirek ham ya nyëġ-yumeris in bë ham gwelë mehö nebë va? Ham bë gwelë ayööng neḳo dee menekepë yah geneyom-a? ");
INSERT INTO bzh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma ham ya in bë gwelë mehö nebë va? Ham bë gwelë mehöti neröp tob niyes mala nġeri nġeri? Ma! Alam sën deneröp tob niyes nebë saga, og denedo alam-los-bengöj bej. ");
INSERT INTO bzh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ma ham ya in bë gwelë mehö nebë va? Mehö-nenër-ġaġek-ranġahsën ti? Ëë, om mëm sa nanër vu ham nabë mëm yi mehö-nenër-ġaġek-ranġahsën bekesuu alam-denenër-ġaġek-ranġahsën lo pin. ");
INSERT INTO bzh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yiḳ mehö saga sën dekevu ġaġek raḳ yi loḳ Anutu-yi-ḳapiya nebë: ‘Gwenġo rë! Sëḳ ġevonġ sa hur ti namuġin, mena negetonġin aggata in honġ!’ ");
INSERT INTO bzh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sa nanër vu ham yönon nabë Mehö-neripek-alam Jon arë böp rot kesuu alam pin sën ataj neḳo sir vu dob agi. Rëḳ mu alam sën denesepa loḳ sa bedenetu Anutu-yi-alam lo pin, og rëḳ dekesuu Jon. ");
INSERT INTO bzh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Loḳ buk sën Mehö-neripek-alam Jon yam dob lo, lob nġaa maggin vonġin bë kepë Nyëġ-yaġek-yi beyam verup gwëbeng, galam nijpaya denesis beġö vu Nyëġ-yaġek-yi niwëëk ata benij wëëk rot in bë deduḳ na medegeḳo. ");
INSERT INTO bzh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ġaġek pin sën alam-denenër-ġaġek-ranġahsën dekevu lo los horek pin, neggëp in mala negët Jon sënë. ");
INSERT INTO bzh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Lob ham bë jaḳ ni nabë saga, og ham gwevonġ geving mehö sënë lo nabë Elia sën denenër bë rëḳ nom lo. ");
INSERT INTO bzh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mehöti bë nenga neggëp, og genġo sa ġaġek. ");
INSERT INTO bzh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ma sëḳ tateḳin ham alam buk sënë jaḳ va? Ham nebë hurmahen sën ggëp deneggök telig bedenetahi hurmahen vahi bë: ");
INSERT INTO bzh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘He nasis ggaġeng rëḳ ma geham su nelöö rë. Gehe nasu kwamin paya paya, rëḳ ham su nesu menepengah ham rë.’ ");
INSERT INTO bzh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","In Mehö-neripek-alam Jon yam, lob su negga nos los nenum wain rë, rëḳ ham nër yi nebë, ‘Memö neloḳ vu yi!’ ");
INSERT INTO bzh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Lob Mehönon Nalu yam benegga los nenum, lob ham nër yi bë, ‘Ham gwelë mehö sënë! Mehö ahëta los nenum wain panġsën, alam-deneḳo-takës* losho alam nijpaya hir mehö yi!’ Rëḳ mu nabë hil ġalë Anutu yi huk og hil ajaḳ ni nabë yi mehö los kwa.” ");
INSERT INTO bzh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Log Yesu vonġ ġaġek raḳ nyëġ vahi sën nevonġ nġaa böp nġahiseḳë loḳ rëḳ su deneggërin sir yah vu Anutu rë lo nebë, ");
INSERT INTO bzh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Wöp-o! Ham Korasin! Gëp in ham! Ham Betsaida! Gëp in ham! Bë mehöti gevonġ nġaa böp gëp alam Ture los Sidon hir nyëġ nabë sën sa hevonġ loḳ ham nyëġ agi, og rëḳ ayoj maggin in devonġ nġaa nipaya medegërin sir nom, medegeyeh vahek duum gededev tamut jak sir gedemedo doḳ vewev degwa. ");
INSERT INTO bzh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Om sa nanër vu ham nabë, doḳ Buk-nyëvewen-yi, og ham rëḳ gweḳo maggin böpata rot kesuu alam Ture los Sidon. ");
INSERT INTO bzh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Geham alam Kapernaum, ham bë kwerë ham jaḳ na vavunë? Ma! Rëḳ ham duḳ na Nyëġ-nengwah-yi. Bë mehöti gevonġ nġaa böp gëp Sodom nabë sën sa hevonġ ggëp ham nyëġ lo, og rëḳ Sodom nahën medo rot beberup doḳ buk sënë. ");
INSERT INTO bzh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Om sa nanër vu ham nabë doḳ Buk-nyëvewen-yi, og ham rëḳ gweḳo maggin böpata rot kesuu Sodom hir maggin!” ");
INSERT INTO bzh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Vu buk saga Yesu jom raḳ bë, “O Amaġ! Honġ Mehöböp vu yaġek los dob. Sahëġ nivesa rot vu honġ in nġaa pin sënë neggëp vunsën in alam los kwaj, gaḳ ġetato vu alam sën su deluḳ dub böp rë lo. ");
INSERT INTO bzh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yönon Amaġ! In yiḳ nġo kwam nevo bë gwevonġ nabë saga in nivesa.” ");
INSERT INTO bzh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Log nër ving bë, “Amaġ vo nġaa pin loḳ yam sa nemaġ ggovek ya. Gemehöti su raḳ Nalu ni rë, gaḳ Ama yö timu raḳ ni. Gemehöti su raḳ Ama ni rë, gaḳ yiḳ Nalu yö timu raḳ ni. Galam sën Nalu tato Ama vu sir lo, og deraḳ ni ving. ");
INSERT INTO bzh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ham sën nekwerë nġaa maggin, beham nevimengin menedo lo, ham pin nam vu sa, in sa ġaḳo maggin vër in ham geham sewah. ");
INSERT INTO bzh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ham natu sa hur, beham gweḳo kwa vu sa. In sa mehö malaġ yes, gesa su nehaḳo sa raḳ loḳ ayoġ rë, lob ham ayomin rëḳ geto megëp revuh. ");
INSERT INTO bzh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kë! Huk sën sebo vu ham lo saga su rëḳ deġinengin ham rë, genġaa maggin sën sëḳ ġevonġ vu ham in ham kwerë lo, saga yiḳ sepëp!” ");
INSERT INTO bzh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Buk-sewahsën-yi* ti lob Yesu losho yi hur maluh deyoh ya huk wit* ti ayo, lob yi hur maluh derur nos sënë anon mededah in dediiḳahëj. ");
INSERT INTO bzh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Loḳ alam Parisai* delë lob denër vu Yesu bë, “Ġelë! Honġ hur maluh dekeyëh horek Buk-sewahsën-yi*!” ");
INSERT INTO bzh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Rëḳ loḳ tepëḳ yah vu sir bë, “Maḳ ham su tevin ġaġek sën Davit diiḳahë wirek lo rë? ");
INSERT INTO bzh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Diiḳahë lob losho alam sën denesepa yi lo deloḳ ya Anutu yi dub bedegga brët vabuung sën denetunġ netu seriveng benedo ggëp Anutu mala lo. Nos sën alam meris nebë Davit su deyoh vu bë dega rë lo, gaḳ alam-deneḳo-seriveng mu yö denegga, (rëḳ mu dediiḳahëj lom degga lob saga su devonġ paya rë). ");
INSERT INTO bzh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Log maḳ ham su raḳ ġaġek sën neggëp loḳ horek lo ni rë? Sënë nebë alam-deneḳo-seriveng denevonġ huk loḳ dub ayo loḳ Buk-sewahsën-yi* lob dekeyëh horek ving nebë saga, rëḳ su devonġ paya rë. ");
INSERT INTO bzh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Rëḳ sa nanër vu ham nabë nġaa sën nedo agi, sën böpata kesuu dub-vabuung-böp. ");
INSERT INTO bzh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bë ham jaḳ ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo ni, og ham su rëḳ bo maggin vu sir rë. Ġaġek sënë nebë: ‘Sa su nehevonġin bë ġaḳo seriveng sën ham nevesi vu sa lo rë, gaḳ sahëġ neving bë ham kwamin paya in alam beham doḳ vu sir.’ Om su devonġ paya rë. ");
INSERT INTO bzh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","In Mehönon Nalu tu Buk-sewahsën-yi* ala.” ");
INSERT INTO bzh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu vu nyëġ saga beya meloḳ ya alam Parisai* saga hir dub-supinsën-yi. ");
INSERT INTO bzh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lob mehö seḳë belooinsën ti nedo. Lom alam la bë denanër ġaġek jaḳ Yesu, lob deloḳ tepëḳ in yi bë, “Maḳ yoh vu bë hil ġevonġ alam nijraḳsën nijvesa jaḳ doḳ Buk-sewahsën-yi* ma ma?” ");
INSERT INTO bzh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Loḳ Yesu nër yah vu sir bë, “Bë ham ti yi sipsip perurek timu, lob duḳ söv doḳ Buk-sewahsën-yi*, og maḳ mehö saga su rëḳ najom jaḳ nom vavunë rë? Gaḳ rëḳ najom jaḳ nom! ");
INSERT INTO bzh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Rëḳ mu mehönon dekesuu sipsip yönon. Om sën hil ayoh vu bë adoḳ vu mehönon doḳ Buk-sewahsën-yi*.” ");
INSERT INTO bzh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Log nër vu mehö sënë bë, “Ġetelo seḳëm nam!” Lom telo seḳë ya, lob nivesa raḳ nebë vahi. ");
INSERT INTO bzh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lob alam Parisai* to deyah dobnë medesupin sir medevengwënġ raḳ aggata bë dengis Yesu menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Loḳ Yesu raḳ ni, lob vuu nyëġ saga geya. Lob alam nġahiseḳë detamuin yi, lob vonġ alam nijraḳsën pin benijvesa raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Log vo ḳoo vu sir bë su denanër yi ranġah, ");
INSERT INTO bzh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","lob ġaġek sën wirek Anutu nër verup mehö-nenër-ġaġek-ranġahsën Yesaya avi lo anon raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nebë: “Sa hur sënë, sehooin yi raḳ, sahëġ neving yi, gesa halë yi nivesa kesuu alam vahi pin. Rëḳ sa ġetunġ sa Anon Vabuung jaḳ yi, lob rëḳ tateḳin sa ġaġek anon degwa vu alam-yu-ngwë. ");
INSERT INTO bzh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Losho mehönon su rëḳ denanër sir rë, gesu rëḳ genġeeḳ rë, gesu rëḳ degenġo gegevonġ paanġ gëp telig rë. ");
INSERT INTO bzh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ġagwëḳ sën keyëh meneggëp neḳo ahon lo, og sa hur su rëḳ keyëh na veröḳ yi rë. Log ram yi wik sën ggëp nelëlek teka lo, og sa hur su rëḳ napuv na veröḳ yi rë. Rëḳ medo gevonġ huk in rot beġaġek niröpsën anon jaḳ bekesuu nġaa nipaya pin. ");
INSERT INTO bzh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lob alam-yu-ngwë rëḳ medo debo kwaj in yi nabë rëḳ doḳ vu sir.” ");
INSERT INTO bzh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Lob deḳo mehöti yam vu yi. Memö nedo loḳ yi bemala ḳenod los su yoh vu bë bengwënġ rë. Lob Yesu vonġ benivesa raḳ, betum nevengwënġ genelë nyëġ. ");
INSERT INTO bzh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lob alam yu böpata saga delëk anon bedenër bë, “Mehö sënëḳ maḳ yiḳ Davit* yi mewis sën lo?” ");
INSERT INTO bzh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Rëḳ alam Parisai* denġo, lob denër bë, “Netii memö to deneya raḳ memö alaj Belsebul* niwëëk.” ");
INSERT INTO bzh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Rëḳ Yesu raḳ ayoj ni, lob nër vu sir bë, “Nabë alam dob timu debasuh sir bedengis sir, og dob saga rëḳ nabumeng na. Log nabë nyëġ böp ti ma alam degwa ti debasuh sir na yu luu bedengis sir, og rëḳ nyëġ ma alam degwa ti saga su rëḳ demedo rë. ");
INSERT INTO bzh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Om nabë Satan getii yi hur memö geto dena, og losho yi hur rëḳ debasuh sir, lom yi nyëġ rëḳ medo niwëëk nabë va? ");
INSERT INTO bzh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Rëḳ mu nabë Belsebul* neloḳ vu sa yönon besa nehetii memö to deneya, og maḳ re neloḳ vu ham alam besën denetii memö to deneya agi? Om ham alam saga degenġo ham ġaġek sagi medeseggi rë. ");
INSERT INTO bzh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Gaḳ bë Anutu yi Anon Vabuung loḳ vu sa, besa hetii memö beto deneya, og ham jaḳ ni nabë Anutu yam vu ham ggovek ya in bë geġin ham. ");
INSERT INTO bzh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mehöti su yoh vu bë doḳ na Mehö Nipaya los niwëëk saga yi begganġ mebo yi ḳupeḳ pin vër rë. Nabë naduu mehö niwëëk saga govek, og mëm godeḳ yi ḳupeḳ pin sën nedo loḳ yi begganġ ayo lo. ");
INSERT INTO bzh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mehöti sën su sa alam yi rë lo, og nesis beġö vu sa. Gemehöti sën su neloḳ vu sa menesupin sipsip ving rë lo, og netii sir meya denepalët loḳ. ");
INSERT INTO bzh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Om sa nanër vu ham nabë Anutu yoh vu bë dahun mehönon hir nġaa nipaya los ġaġek pelësën pin sën denevonġ lo na. Gaḳ ġaġek pelësën sën denenër raḳ Anon Vabuung lo, og su rëḳ Anutu dahun na rë. ");
INSERT INTO bzh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Log mehöti bë nanër ġaġek nipaya ti jaḳ Mehönon Nalu, og rëḳ Anutu dahun yi nipaya sënë na. Gaḳ nabë mehöti nanër ġaġek nipaya ti jaḳ Anon Vabuung, og su rëḳ Anutu dahun yi nipaya sënë na rë. Gaḳ rëḳ nama, vu gwëbeng gevu tamusën geving.” ");
INSERT INTO bzh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nabë ham baroh ḳele nivesa, og yö rëḳ ngis anon nivesa. Nabë ham baroh ḳele nipaya, og yö rëḳ ngis anon nipaya. In hil nehalë ḳele anon rëḳ mëm hil naraḳ ni nebë ḳele nivesa ma nipaya. ");
INSERT INTO bzh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nyël nalu ham! Ham su yoh vu bë nanër ġaġek nivesa rë, in ham alam nimin paya. Yönon, ham nenër ġaġek verup avimin yoh vu nġaa sën ham kwamin nevo loḳ ayomin lo. ");
INSERT INTO bzh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Om mehö nivesa neḳo nġaa nivesa vër loḳ nġaa nivesa sën nesupin meneggëp loḳ ayo lo, menenër yam ranġah, log mehö nipaya neḳo nġaa nipaya vër loḳ nġaa nipaya sën nesupin meneggëp loḳ ayo lo, menenër yam ranġah. ");
INSERT INTO bzh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Om sën sa nanër vu ham nabë ġaġek jeggin jeggin pin sën alam denenër lo, og rëḳ Anutu gevonġ nyëvewen doḳ nah vu sir doḳ buk sën genġo alam pin hir ġaġek lo. ");
INSERT INTO bzh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","In honġ ġaġek rëḳ nanër honġ nabë honġ mehö nim vesa ma rëḳ nanër honġ nabë honġ mehö nim paya.” ");
INSERT INTO bzh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nër saga ggovek lob alam-horek-yi la los alam Parisai* la denër vu yi bë, “Tatovaha, he hevonġin bë gwevonġ nġaa böp ti behe ġalë.” ");
INSERT INTO bzh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lom nër yah vu sir bë, “Ham alam sën nedo dob-ë, ham alam nimin paya. Ham nebë avëh baggëb, om sën ham nekwetaġ bë ham gwelë nġaa böp. Rëḳ mu sa su rëḳ ġevonġ nġaa böp vu ham rë. Gaḳ sëḳ ġevonġ nġaa böp nabë sën mehö-nenër-ġaġek-ranġahsën Yona yi nġaa böp lo mu vu ham beggovek. ");
INSERT INTO bzh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Wirek Yona neggëp loḳ ġël böp ayo yoh vu ranġah löö gebuk löö, lom Mehönon Nalu rëḳ gëp doḳ dob ayo noh vu ranġah löö gebuk löö nabë saga. ");
INSERT INTO bzh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Log vu Buk-tamusën og Anutu rëḳ seggi mehönon hir ġaġek, lob rëḳ alam Nineve kedi debare medenanër ġaġek jaḳ alam vu buk sënë nabë denevonġ nġaa nipaya. In alam Nineve denġo Yona aye bedeggërin sir yah vu Anutu. Gaḳ Mehö sën nedo agi kesuu Yona, rëḳ ham su wërin ham rë. ");
INSERT INTO bzh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Log vu Buk-tamusën og Anutu rëḳ seggi mehönon hir ġaġek, lob rëḳ avëh-los-bengö vu dob nyë sën sanġ-neverup lo kedi bare menanër ġaġek jaḳ alam vu buk sënë nabë denevonġ nġaa nipaya. In avëh-los-bengö sënë yam vu dob nyë in bë genġo Solomon* yi ġaġek los kwa böp. Gaḳ Mehö sën nedo agi og kesuu Solomon*, rëḳ ham su nġo aye rë.” ");
INSERT INTO bzh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Memö nipaya sën to meya in mehönon ti lo, og to meya medo neyoh nyëġ nivevo benesero nyëġ len ti in bë sewah doḳ, rëḳ su netöḳ raḳ rë. ");
INSERT INTO bzh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Lom nër bë, ‘Maam saḳ nah mena ġalë begganġ sën sa nado loḳ wirek lo rë!’ Lob yah verup rëḳ nelë bë desekee begganġ sën lo bedevuneḳ vu benedo meris. ");
INSERT INTO bzh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Lob rengö yi beyah ḳo memö nemadvahi-bevidek-luu sën denevonġ nġaa nipaya rot medenekesuu yi lo, beyom denedo loḳ begganġ sënë. Lob mehö sën nedo paya wirek lo mëm nedo paya ya veröḳ yi rot. Om nġaa nipaya nabë sënë rëḳ natöḳ vu alam nij paya sën denedo gwëbeng agi nabë saga.” ");
INSERT INTO bzh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu nahën nenër ġaġek nebë sënë vu alam, log ata gari lo yam denare dobnë in bë losho debengwënġ. ");
INSERT INTO bzh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Lob mehöti nër vu bë, “Ġelë, atam losho arim lo yam denare dobnë in bë ham los bengwënġ.” ");
INSERT INTO bzh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Lob Yesu nër ġaġek yah vu mehö sënë bë, “Sataġ re? Gesarig re lo?” ");
INSERT INTO bzh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Lob tato yi hur lo raḳ nema genër bë, “Gwelë! Ataġ lo arig lo sënë. ");
INSERT INTO bzh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Alam sën denesepa loḳ Amaġ vu yaġek kwa lo, og sir saga mëm detu sarig lo, savëhnög lo, sataġ lo!” ");
INSERT INTO bzh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Vu buk saga Yesu vu begganġ ayo meto meya dobnë, beya nedo dus vu nġaggee böp nenga. ");
INSERT INTO bzh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Loḳ alam yu böpata deya vu yi, lob Yesu raḳ ya nedo yaġ ti, galam pin denare nġaggee nenga. ");
INSERT INTO bzh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Log nër ġaġek peggirinsën nġahiseḳë vu sir bë, “Ham gwenġo rë! Mehö netetëhin nos ġahis ti to meya huk anon in bë tetëhin yi nos ġahis. ");
INSERT INTO bzh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Netetëhin nos ġahis, lob vahi to nedo loḳ aggata sën neyoh huk vuheng lo, lom soḳ yam degga pevis. ");
INSERT INTO bzh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Log ġahis la to meraḳ nedo dob mahen teka sën raḳ neggëp ġelönġ vavunë lo, om kip pevis in dob mahen teka mu, ");
INSERT INTO bzh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","lob hes tum bevev raḳ lom meran ya, in ġeġa su luḳ ya dob ġebinë rë. ");
INSERT INTO bzh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Log ġahis vahi to meloḳ ya nedo vos niggin ggin ayo, lob vos niggin ggin sënë kip merig meggök nos bevonġ paya. ");
INSERT INTO bzh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Log ġahis la to meluḳ ya nedo dob jeji, lob rig besis anon nivesa. La sis anon mehödahis nemadvahi, gela sis anon mehödahis löö, gela sis anon mehödahis ti benemadluho. ");
INSERT INTO bzh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mehöti bë nenga neggëp, og genġo ġaġek sënë.” ");
INSERT INTO bzh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Lob yi hur maluh ya deloḳ tepëḳ in yi bë, “Ġenër ġaġek pin netu ġaġek peggirinsën vu sir in va?” ");
INSERT INTO bzh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Loḳ nër yah vu sir bë, “In Anutu tateḳin Nyëġ-yaġek-yi yi ġaġek vunsën degwa vu ham, gaḳ su tateḳin vu alam sënë rë. ");
INSERT INTO bzh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mehöti sën neraḳ ġaġek degwa ni lo, og rëḳ jaḳ la degwa ni geving rot, gemehöti sën su neraḳ ġaġek degwa ni rë lo, og rëḳ kwa birekin teka sën neraḳ ni lo benama na veröḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Senër ġaġek peggirinsën vu sir in bë rëḳ degelë mu gesu dejaḳ ni rë, log degenġo mu gesu denatöḳ jaḳ ġaġek degwa rë. ");
INSERT INTO bzh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Om mehö-nenër-ġaġek-ranġahsën Yesaya yi ġaġek anon raḳ, sën nër nebë: ‘Ham nengamin rëḳ genġo, rëḳ ham kwamin su rëḳ natöḳ jaḳ rë. Ham malamin rëḳ gelë, rëḳ ham su rëḳ jaḳ degwa ni rë.’ ");
INSERT INTO bzh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","GeYesaya nër raḳ sir ving bë: ‘Nabë saga, in alam sënë ayoj niwëëk, medemir nengaj gedekebu malaj in bë malaj rëḳ gelë genengaj rëḳ genġo, lob dejaḳ ni medegërin sir lob sa ġevonġ benijvesa jaḳ.’ ");
INSERT INTO bzh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Gaḳ mu hameḳ kwamin vesa in ham malamin nelë sa los ham nengamin nenġo sayeġ. ");
INSERT INTO bzh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sa nanër vu ham yönon nabë: Wirek alam-denenër-ġaġek-ranġahsën los alam yohvu nġahiseḳë denetunġ malaj in bë degelë nġaa sën ham nelë agi, rëḳ su denelë rë. Log denebë nengaj in bë degenġo ġaġek sën ham nenġo agi, rëḳ su denenġo rë.” ");
INSERT INTO bzh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Om ham gwenġo ġaġek peggirinsën raḳ mehö netetëhin ġahis lo degwa rë. ");
INSERT INTO bzh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Alam sën denenġo Nyëġ-yaġek-yi yi ġaġek rëḳ su kwaj netöḳ raḳ degwa rë lo, og sir nebë ġahis sën to nedo loḳ aggata, in Mehö Nipaya lo yam nesepos ġaġek lo vër in ayoj. ");
INSERT INTO bzh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Log ġahis sën to nedo raḳ ġelönġ vavunë lo, nebë alam sën denġo ġaġek medeḳo raḳ pevis mekwaj vesa in. ");
INSERT INTO bzh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Rëḳ mu sir nebë nos ġeġa sën neraḳ vu ġelönġ lo, lob su denedo hus ading rë. Bë nġaa maggin ti natöḳ jaḳ sir, ma mehö la denanër sir in desepa loḳ sa ġaġek, og rëḳ dedëëin na pevis. ");
INSERT INTO bzh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Log ġahis sën to meloḳ ya vos niggin ggin ayo lo, nebë alam sën denenġo ġaġek, loḳ newaj neraḳ in nġaa dob yi lo. Gahëj ving monë lu nġaa rot ggök ya ġaġek, lom diiḳ gesu sis anon rë. ");
INSERT INTO bzh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Log ġahis sën to meluḳ ya dob jeji lo nebë alam sën denġo ġaġek bedetöḳ raḳ degwa bedenevonġ ving bedenevonġ banon raḳ lo. La denesis anon mehödahis nemadvahi, gela denesis anon mehödahis löö, gela denesis anon mehödahis ti benemadluho.” ");
INSERT INTO bzh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Loḳ nër ġaġek peggirinsën ngwë ggökin vu sir bë, “Sën Nyëġ-yaġek-yi anon jaḳ lo, og yiḳ nebë mehönon ti tetëhin nos ġahis nivesa loḳ yi huk. ");
INSERT INTO bzh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lob neggëp yiing buk, log mehö sën nelë yi paya lo, tetëhin vos nipaya ġahis ggök ya nos ġahis lo vavunë geneya. ");
INSERT INTO bzh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lob ġahis lo kip meböp raḳ ggovek bebë ngis anon, loḳ delë vos nipaya lo kip merivin loḳ ving. ");
INSERT INTO bzh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Lob yi hur ya denër vu yi bë, ‘Mehö böp, maḳ ġetetëhin ġahis nivesa loḳ honġ huk, log vos nipaya sën kip agu yam vu tena?’ ");
INSERT INTO bzh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Loḳ nër vu sir bë, ‘Mehö sën nelë sa paya lo vonġ nġaa sënë!’ Lom yi hur deloḳ tepëḳ in yi bë, ‘Om he na bepul vos sënë na?’ ");
INSERT INTO bzh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Rëḳ nër yah bë, ‘Ma! Bë ham bepul vos na, og maḳ ham rëḳ bepul nos la geving. ");
INSERT INTO bzh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Om ham naḳööḳ geluho desarömin sir medebare gebuk sën hil abo nos anon lo rë. Lob doḳ buk saga og sëḳ nanër vu alam sën debo nos anon lo nabë dengap vos nipaya jaḳ bun namuġin bena degetë jaḳ na nengwah, log mëm dengupin nos anon jaḳ na sa jök.’” ");
INSERT INTO bzh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Loḳ Yesu nër ġaġek peggirinsën ngwë vu sir ggökin bë, “Sën Nyëġ-yaġek-yi anon jaḳ lo, og yiḳ nebë mastet* ġahis sën mehöti ḳo meya mehin loḳ yi huk. ");
INSERT INTO bzh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nos ġahis saga mahen teka genos ġahis pin kesuu, rëḳ tum nekip lob böp neraḳ benekesuu nos pin geya netu ḳele, besoḳ sën denevëëng medeneya agi yam denejegwi newisej loḳ nema.” ");
INSERT INTO bzh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Log nër ġaġek peggirinsën ngwë vu sir nebë, “Sën Nyëġ-yaġek-yi anon jaḳ lo, og yiḳ nebë yiist* sën nevonġ bebrët nerig lo. Avëh ti ḳo meya sarömin ving parawa ḳetuḳ löö loḳ ġabum, lom yiist* köd parawa pin sënë merig.” ");
INSERT INTO bzh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu nër ġaġek peggirinsën pin saga gesu nër ti ranġah rë, gaḳ nër tu ġaġek peggirinsën mu vu alam yu böpata saga. ");
INSERT INTO bzh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","In mehö-nenër-ġaġek-ranġahsën Yesaya yi ġaġek sënë anon jaḳ. Sën nebë: ‘Sëḳ nanër vu sir jaḳ ġaġek peggirinsën. Gesëḳ nanër ġaġek sën nevun yi loḳ buk sën Anutu tunġ yaġek los dob meneggëp rot meverup gwëbeng agi vu sir.’ ");
INSERT INTO bzh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu nër ggovek, log vuu alam yu böpata saga ya, geloḳ yah begganġ ayo, lob yi hur maluh ya deloḳ tepëḳ in yi bë, “Ġenanër ġaġek peggirinsën sën vos nipaya kip loḳ huk anon lo degwa ranġah vu he rë.” ");
INSERT INTO bzh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Lob nër yah vu sir bë, “Mehö sën nevaroh nos ġahis nivesa saga og Mehönon Nalu. ");
INSERT INTO bzh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Gedob pin sënë nebë huk, genos ġahis nivesa saga nebë alam sën detu Anutu yi hur, gevos nipaya saga nebë Mehö Nipaya Satan yi hur lo. ");
INSERT INTO bzh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Log mehö netetëhin vos nipaya ġahis lo, saga Satan. Log buk sën dengupin nos lo, saga og buk sën dob los yaġek nama na lo. Galam sën dengupin nos lo, sagaḳ angër lo. ");
INSERT INTO bzh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Log sën dengupin vos nipaya mena debesi pin jaḳ nengwah lo, og yiḳ rëḳ degevonġ nabë sënë doḳ Buk-tamusën. ");
INSERT INTO bzh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Doḳ buk saga Mehönon Nalu rëḳ gevonġ yi angër na dengupin alam nij paya pin sën depelëpin alam-vonġvingsën-yi lo geving alam pin sën denevonġ nġaa nipaya lo, bedegeḳo sir vër in Anutu-yi-Nyëġ. ");
INSERT INTO bzh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Lob rëḳ degetë sir doḳ na nengwah, bedengu los degeköö nyëj. ");
INSERT INTO bzh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Lob vu buk saga Anutu-yi-alam rëḳ denajëh nabë hes gëp Amaj-yi-Nyëġ. Mehöti bë nenga neggëp og genġo ġaġek sënë!” ");
INSERT INTO bzh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Log sën Nyëġ-yaġek-yi anon jaḳ lo, og yiḳ nebë ḳupeḳ nivesa sën mehöti vun meneggëp loḳ dob bemehö ngwë töḳ vu, log vun yah ggökin. Kwa vesa rot geya nevonġ yi nġaa pin balam debaġo beḳo monë raḳ pin, lom yah baġo dob len ti sënë betu yi nġaa.” ");
INSERT INTO bzh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Log sën Nyëġ-yaġek-yi anon jaḳ lo, og yiḳ nebë mehö-nebaġo-nġaa nesero ḳumḳum nivesa in bë baġo. ");
INSERT INTO bzh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Töḳ vu ḳumḳum ti bemalanġeri rot beyi monë böpata rot. Lom ya mevonġ yi ḳupeḳ pin balam debaġo, lob ḳo monë raḳ betum yah baġo ḳumḳum malanġeri sënë raḳ betu yi nġaa.” ");
INSERT INTO bzh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Log ġaġek peggirinsën ngwë nebë sënë: Sën Nyëġ-yaġek-yi anon jaḳ lo, og yiḳ nebë leḳ-ġël-yi ti sën denetë luḳ ya loo beggërin ġël aggagga loḳ. ");
INSERT INTO bzh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Leḳ pup lom dedadii raḳ yam roneḳ, bedeggooin ġël nivesa loḳ ya ġabum, gedetë nipaya ya. ");
INSERT INTO bzh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Lob buk sën yaġek los dob nama na lo, og rëḳ nabë sënë. Angër rëḳ nam degeḳo alam nij paya vër doḳ alam nijvesa vuheng, ");
INSERT INTO bzh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","bena degetë sir doḳ na nengwah, bedengu los degeköö nyëj.” ");
INSERT INTO bzh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Log Yesu loḳ tepëḳ in sir bë, “Maḳ ham raḳ ġaġek mewis pin sënë degwa ni?” Lom deyoġek bë, “Ëë-ë!” ");
INSERT INTO bzh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Lob nër yah vu sir bë, “Mehö-horek-yi sën nenġo ġaġek raḳ Nyëġ-yaġek-yi venuh ggovek lo, saga nebë begganġ ala ti. Loḳ ya yi begganġ-ḳupeḳ-yi ayo beḳo yi ḳupeḳ mewis los muġeng loḳ ti beluḳ yom.” ");
INSERT INTO bzh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu nër ġaġek peggirinsën saga vu sir ggovek log vuu hir nyëġ ya, ");
INSERT INTO bzh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","geyah ben menenër Anutu yi ġaġek vu yi alam loḳ hir dub-supinsën-yi. Lom avij töḳ medenër bë, “Mehö sënë ḳo kwa los nġaa böp böp sënë vu tena? ");
INSERT INTO bzh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yosep sën mehö nelev begganġ lo nalu yi! Gata Maria! Gemaḳ ari lo sën Yakobus geYosep geSimon geYudas lo? ");
INSERT INTO bzh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Gavëhnö lo sën denedo ving hil-ë! Log maḳ ḳo nġaa pin sënë vu tena?” ");
INSERT INTO bzh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Denër nebë sënë, log denelë yi paya. Rëḳ Yesu nër vu sir bë, “Alam vu nyëġ pin deneḳo mehö-nenër-ġaġek-ranġahsën arëj raḳ, gaḳ yö hir alam, gesir sën losho begganġ-bu timu lo, og ma!” ");
INSERT INTO bzh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Lob su vonġ nġaa böp nġahiseḳë vu nyëġ saga rë, in su ayoj neya timu vu yi rë. ");
INSERT INTO bzh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Vu buk saga Herot* tu distrik Galilea ala menedo, benġo Yesu bengö. ");
INSERT INTO bzh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Lob nër vu yi alam sën denenġo ġaġek ggëp avi lo bë, “Yiḳ Mehö-neripek-alam Jon lo sënë! Kedi raḳ ggökin vu bedub, om sën nevonġ nġaa los niwëëk ata nebë agi.” ");
INSERT INTO bzh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herot* nër bë saga in jom Mehö-neripek-alam Jon beduu yi ahon wirek betunġ yi ya ḳarabus. Herot* vonġ raḳ ari Pilip venë Herodias sën ggodeḳ yah tu venë lo. ");
INSERT INTO bzh_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","In Jon nër vu Herot* bë, “Su ġeḳo avëh sënë niröp rë!” ");
INSERT INTO bzh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Lom Herot* bë ngis yi menadiiḳ rëḳ ggönengin alam Yuda in kwaj nevo Jon bë yi mehö-nenër-ġaġek-ranġahsën ti. ");
INSERT INTO bzh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Betum buk sën Herot* kwa vo yi buk sën ata ḳo yi wirek lo, lob vonġ nos böp balam la desupin sir ving yi, geHerodias nalu avëh yam nelöö loḳ malaj. ");
INSERT INTO bzh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Lob Herot* lë bahë nivesa rot in yi, lob nër yönon rot vu avëh avö sënë getato nema ya vavunë bë, “Bë ġenanër nġaa ti vu sa, og sëḳ bo nök vu honġ yönon!” ");
INSERT INTO bzh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lob Herodias loḳ nalu avëh ahë bemëm nër vu Herot* bë, “Gwetunġ Mehö-neripek-alam Jon yu doḳ ġabum ti meġebo vu sa pehi sënë!” ");
INSERT INTO bzh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nër nebë sënë lom mehö-los-bengö Herot* ayo maggin, rëḳ kwa vo ġaġek sën nër yönon getato nema ya vavunë lo, in neggönengin alam vatëveḳ sën deyam in yi nos böp lo denġo. Lob nër bë degevonġ noh vu saga. ");
INSERT INTO bzh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Lom vonġ mehöti ya begganġ ḳarabus ayo meketöv Jon kwa. ");
INSERT INTO bzh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Lob deḳo yu loḳ ġabum ti beyam devo vu avëh avö sënë, beḳo meyah vo vu ata. ");
INSERT INTO bzh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","GeJon yi hur maluh yam deḳo anon meya delev. Delev ggovek, log ya denër vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu nġo ġaġek sënë lob vuu nyëġ saga geraḳ yaġ meya nyëġ-yumeris tahsën ti. Loḳ alam denġo lom devuu nyëġ böp gedeyoh roneḳ bedesepa yi medeya. ");
INSERT INTO bzh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Lob Yesu ya verup meraḳ yah roneḳ vu nyëġ-yumeris, lob lë alam nġahiseḳë saga bekwa vonġin sir, lob vonġ behir alam nijraḳsën nijvesa raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Log sehuk luḳ lob yi hur maluh ya denër vu yi bë, “Nyëġ-yumeris tahsën sënë behes mala ya ggovek, om gwevonġ alam sënë deketëḳin sir medena denoh vu begganġ-bu ti ti in debaġo hir nos.” ");
INSERT INTO bzh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Rëḳ Yesu nër vu sir bë, “O, su dena! Gaḳ ham bet sir!” ");
INSERT INTO bzh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Rëḳ denër yah vu yi bë, “Rëḳ mu hil hed brët nemadvahi geġël luu mu-o!” ");
INSERT INTO bzh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Rëḳ nër yah bë, “Ham gweḳo nam vu sa rë!” ");
INSERT INTO bzh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Lom nër vu alam bë degeto demedo jaḳ pahup, log ḳo brët nemadvahi geġël luu lo raḳ, log varah mala raḳ yaġek gejom raḳ in los kwa vesa ya vu Anutu. Log mëm deġo bevo vu yi hur maluh beya devo ggelek alam saga. ");
INSERT INTO bzh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Lob sir pin degga meyoh vu sir, log desupin vahi sën nahën nedo lo loḳ sap nemadluho-bevidek-luu. ");
INSERT INTO bzh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Alam sën degga nos lo sir maluh yoh vu 5,000, gesu detevin avëh los hurmahën ving rë. ");
INSERT INTO bzh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ggovek log Yesu vonġ yi hur maluh bë dejaḳ na yaġ bedena nġaggee nenga vahi namuġin, gegevonġ alam bedenah bej rë. ");
INSERT INTO bzh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Vonġ alam deya ggovek, log yö ti ya los ḳedu in bë najom jaḳ, lob nahën ya nedo ḳedu gebuk loḳ. ");
INSERT INTO bzh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Geyaġ to meya nġaggee vuheng rot, lom sanġ vë niwëëk yam ggëp yaġ neru, lob nġaggee tëë luḳ ya yaġ rot. ");
INSERT INTO bzh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lob dus raḳ in bë nyëġ geheng, log Yesu vare neya raḳ nġaggee vavunë betöḳ ya vu sir. ");
INSERT INTO bzh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Delë bë vare neya raḳ nġaggee vavunë, lom delëk meḳenuj verup medenër bë, “Alam diiḳsën ḳenuj ti!”, gedeggöneng medenġeeḳ. ");
INSERT INTO bzh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Rëḳ Yesu pevis benër ya vu sir bë, “Ham su newamin jaḳ! Yiḳ sa sënë om ham su ġöneng.” ");
INSERT INTO bzh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Lom Pita nër yah vu bë, “Mehöböp! Nabë honġ saga, og ġenanër gesa bare jaḳ nġaggee vavunë benök vu honġ!” ");
INSERT INTO bzh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Lom Yesu nër bë, “Ġenam!” Lob Pita vuu yaġ geto meya nare raḳ nġaggee vavunë meya vu Yesu, ");
INSERT INTO bzh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","rëḳ nġo sanġ dedun, lom ggöneng bevonġin bë duḳ na nġaggee benġaggee jehöö yi. Lob nġeeḳ in Yesu bë, “Mehöböp, ġenajom sa jaḳ!” ");
INSERT INTO bzh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Lom Yesu pevis bejom Pita raḳ genër vu yi bë, “Su ayom neyam timu vu sa yönon rë! Ayom luu luu in-a?” ");
INSERT INTO bzh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Lob luho deraḳ yah yaġ, log sanġ maya avuti. ");
INSERT INTO bzh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Lob alam sën denedo raḳ yaġ lo depetev medeneggëp loḳ vaha gedenër bë, “Anutu nalu honġ yönon rot!” ");
INSERT INTO bzh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ggovek, loḳ ya deverup nġaggee vahi beya detöḳ ya Genesaret*, ");
INSERT INTO bzh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","lob alam vu nyëġ sagu deraḳ ni bë Yesu, lob devonġ ġaġek ya nyëġ dus dus pin bedeḳo alam nijraḳsën pin yam vu yi. ");
INSERT INTO bzh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Gedeketaġ vu yi bë yiḳ alam nijraḳsën degebë nemaj jaḳ yi röpröp nyë mu. Lob sir pin sën denebë nemaj raḳ lo og nijvesa neraḳ. ");
INSERT INTO bzh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisai* la losho alam-horek-yi la vu Yerusalem bedeyam vu Yesu bedenër bë, ");
INSERT INTO bzh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Tum honġ hur maluh denekeyëh alam hib wirek hen hir horek sën devonġ vu hil agi lo in-a? Su deneripek nemaj muġin rëḳ mëm denegga nos rë!” ");
INSERT INTO bzh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Rëḳ Yesu nër yah vu sir bë, “Log yiḳ ham nebë saga! Nebë va sën ham nġo nesepa loḳ alam hib wirek hen hir horek geham nekweyëh Anutu yi horek-ë? ");
INSERT INTO bzh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anutu nër bë, ‘Ġeġurek amam lu atam babuj’ genër ving bë, ‘Mehöti bë nanër ġaġek nipaya jaḳ ama ma ata, og ham tengwa yi menadiiḳ’. ");
INSERT INTO bzh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Rëḳ ham nenër bë, ‘Mehöti yi monë lu nġaa neggëp in bë doḳ vu ama ma ata jaḳ, rëḳ mu nanër vu yi nabë, “Sa bë doḳ vu meluu meġevonġ sa nġaa sënë nök vu meluu, rëḳ mu rëḳ nama, in sehooin raḳ ggovek in bë natu seriveng vu Anutu”, ");
INSERT INTO bzh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","og ggovek, mehö saga su doḳ vu ama lu ata jaḳ.’ Rëḳ mu ham nedahun Anutu yi ġaġek raḳ nġaa nebë saga in bë ham nġo sepa doḳ alam hib wirek hen hir ġaġek. ");
INSERT INTO bzh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ham alam kwamin luu! Mehö-nenër-ġaġek-ranġahsën Yesaya nër ġaġek sënë raḳ ham niröp nebë: ");
INSERT INTO bzh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Alam sënë deneḳo sarëġ raḳ verup avij, rëḳ mu ayoj yö neggëp ading in sa. ");
INSERT INTO bzh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yö denenër mehönon hir horek gedenenër bë, “Anutu yi horek sënë!” lob deneḳo sa raḳ meris mu.’” ");
INSERT INTO bzh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Lob Yesu supin alam deyam vu yi benër vu sir bë, “Ham gwenġo beham jaḳ ni. ");
INSERT INTO bzh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nġaa sën neloḳ ya mehönon avij lo, og su nevonġ benij paya neraḳ rë. Gaḳ mëm nġaa sën nedo loḳ mehönon ayoj beraḳ neverup avij lo mu, sën nevonġ benij paya neraḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lob yi hur maluh ya denër vu yi bë, “Alam Parisai* denġo honġ ġaġek saga lob ayoj nipaya. Ma ġeraḳ ni?” ");
INSERT INTO bzh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Rëḳ Yesu nër yah bë, “Nġaa pin sën Amaġ vu yaġek su nevaroh rë lo, og rëḳ bepul los ġeġa na. ");
INSERT INTO bzh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ham naḳööḳ geyö hir nġaa! Alam malaj ḳenod lob dekuung bë detato aggata vu alam malaj ḳenod ngwë. Bë mehö mala ḳenod ngwë tato aggata vu mehö mala ḳenod ngwë, og rëḳ luhoho debës lii doḳ ti.” ");
INSERT INTO bzh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Lom Pita nër yah vu Yesu bë, “Om ġenanër ġaġek peggirinsën sënë degwa behe ġanġo rë!” ");
INSERT INTO bzh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Rëḳ Yesu nër bë, “Om ham nġo nahën geham su neraḳ ni rë? ");
INSERT INTO bzh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Maḳ ham su raḳ nġaa pin sën hil naha lo ni bë neloḳ ya hil avid beya nare loḳ hil ahëd ḳevus, loḳ tum to neluḳ ya asoreng rë? ");
INSERT INTO bzh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Gaḳ nġaa sën raḳ neverup mehönon avij beto neyam ranġah lo, sën yam ggëp ayoj. Lob nġaa nebë sënë sën nevonġ bemehönon nij paya neraḳ. ");
INSERT INTO bzh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","In nġaa sën neverup ayoj lo nebë sënë: Kwaj nevo nġaa nipaya, denesis mehönon medenediiḳ, deneggodeḳ alam venëj ma reggaj, maġëm los avö deneggodeḳ sir, deneggodeḳ nġaa, denenër ġaġek kuungsën, denenër ġaġek pelësën. ");
INSERT INTO bzh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nġaa pin sënë nevonġ bemehönon nij paya neraḳ. Gaḳ bë mehönon dega nos besu dejipek nemaj namuġin rë, og saga su nevonġ benij paya neraḳ rë.” ");
INSERT INTO bzh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Lob Yesu kedi raḳ loḳ nyëġ saga beya distrik Ture los Sidon. ");
INSERT INTO bzh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Lob avëh-yu-ngwë ti vu Kanaan nedo sagu beyam tahi bë, “O Mehöböp! Davit* yi Mewis honġ! Kwam gevonġ in sa! Memö nipaya ti gwanġ ya sa naluġ avëh ayo benevasap yi rot!” ");
INSERT INTO bzh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Rëḳ Yesu su nër ġaġek ti loḳ yah vu yi rë. Lob yi hur maluh deyam vu yi medenër bë, “Avëh sënë tahi megejiiin hil rot, om gwevonġ nah!” ");
INSERT INTO bzh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Rëḳ Yesu nër yah bë, “Anutu vonġ sa meseyam in sedoḳ vu sipsip mala-masën vu Israel mu!” ");
INSERT INTO bzh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Rëḳ avëh yam dus bepetev meneggëp loḳ vaha genër bë, “Mehöböp ġedoḳ vu sa!” ");
INSERT INTO bzh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Loḳ Yesu nër raḳ ġaġek peggirinsën yah vu yi bë, “Su yoh vu bë hil ġaḳo hurmahen hir nos vër beġetë na vu anöö rë!” ");
INSERT INTO bzh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Rëḳ avëh nër bë, “Mehöböp, sagaḳ yönon, gaḳ mëm anöö denepatu nos metes sën alaj denevonġ meneluḳ ya reek len lo!” ");
INSERT INTO bzh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nër nebë sënë, lom Yesu nër yah vu yi bë, “O avëh! Ayom neyam timu vu sa yönon rot, om nġaa sën ġenevonġin lo rëḳ anon jaḳ vu honġ.” Lom loḳ hes mala saga avëh nalu nivesa raḳ yah ggökin. ");
INSERT INTO bzh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Log Yesu ya raḳ beya metöḳ ya nġaggee böp Galilea nenga. Besepa meya teka loḳ mëm raḳ ya ḳedu ti beto nedo. ");
INSERT INTO bzh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Lob alam nġahiseḳë desupin sir medeyam vu yi. Lob deḳo alam vahaj nipaya, seḳëj vegguu, malaj ḳenod, kwaj nġengöleng, geniraḳsën vahi ving, bedeyam vu yi. Bedebë sir loḳ Yesu vaha, lob vonġ benijvesa raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lob alam saga ḳenuj ya in denelë alam kwaj nġengöleng denevengwënġ, galam seḳëj vegguu seḳëj nesesor yi, galam vahaj nipaya deneya aggata, galam malaj ḳenod denelë nyëġ. Lob deḳo Israel hir Anutu arë raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Lob Yesu supin yi hur maluh lo benër vu sir bë, “Sa kwaġ paya in alam sënë, in denedo buk löö ving sa benos main sir. Lob sa su hevonġin bë ġevonġ sir na rë, in meyip rëḳ gevonġ sir bemalaj pebilin gëp aggata bedebës.” ");
INSERT INTO bzh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Loḳ yi hur maluh denër vu yi bë, “Nyëġ-yumeris sënë, om hil rëḳ ġaḳo nos vu tena mabet alam yu böpata sënë jaḳ-a?” ");
INSERT INTO bzh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Rëḳ Yesu nër yah vu sir bë, “Ham brët va la neggëp vu ham-a?” Lom denër yah bë, “He hömin brët nemadvahi-bevidek-luu geġël mahen luu.” ");
INSERT INTO bzh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Lob Yesu nër vu alam beto denedo dob. ");
INSERT INTO bzh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Log ḳo brët nemadvahi-bevidek-luu, geġël luu lo raḳ, gejom raḳ in los kwa vesa ya vu Anutu, log deġo bevo vu yi hur maluh, beya devo ggelek alam. ");
INSERT INTO bzh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Degga beyoh vu sir, log vahi nedo bedesupin loḳ jebeng nemadvahi-mevidek-luu. ");
INSERT INTO bzh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Log alam sën degga nos lo sir yoh vu 4,000, gesu detevin avëh los hurmahen ving rë. ");
INSERT INTO bzh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Log mëm Yesu vonġ medeketëḳin sir medeya, log raḳ yaġ meya los Magadan. ");
INSERT INTO bzh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Alam Parisai* los Sadukai* deyam in bë deseggi Yesu, lob denër bë gevonġ nġaa böp yaġek yi ti bedegelë. ");
INSERT INTO bzh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Rëḳ nër yah vu sir bë, “Ham nelë bë ġerub nevarah sehuksën lob ham nenër bë, ‘Ġerub varah sehuksën, om nyëġ rëḳ gevanġ neheng.’ ");
INSERT INTO bzh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Log ham nelë ḳeḳup nekebu monbuk, lom ham nenër bë, ‘Ḳeḳup kebu monbuk genyëġ malaḳenu rot, om vonġin ayööng los hob nam!’ Nġaa nebë sënë netato vu ham beham nġo neraḳ ni, rëḳ ham su neraḳ nġaa sën neggëp ham malamin gwëbeng-ë ni rë! ");
INSERT INTO bzh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ham alam nimin paya, ham nebë avëh baggëb, om sën ham kwetaġ bë ham gwelë nġaa böp. Rëḳ mu sa su rëḳ ġevonġ nġaa böp ti beham gwelë rë. Gaḳ sëḳ tato nġaa böp nabë sën Yona yi nġaa böp lo vu ham mu beggovek.” Log Yesu vuu sir geya. ");
INSERT INTO bzh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yi hur maluh deraḳ yaġ ving yi medeya nġaggee nenga vahi, rëḳ kwaj virekin nos gesu deḳo la sepa rë. ");
INSERT INTO bzh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Loḳ Yesu nër vu sir bë, “Ham gweġin ham in alam Parisai* los Sadukai* hir yiist*!” ");
INSERT INTO bzh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Lob yö denër vu sir bë, “Hil su haḳo nos la sepa rë, om sën nenër aga!” ");
INSERT INTO bzh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu raḳ ni lob nër bë, “Ham su ayomin neyam timu vu sa yönon rë! Ma nebë va sën ham nesap ham raḳ bë ham su ḳo nos la sepa rë-ë? ");
INSERT INTO bzh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ma ham nahën geham su raḳ ni rë? Maḳ ham su kwamin nevo brët nemadvahi sën alam 5,000 degga gesap va la sën ham supin loḳ lo rë? ");
INSERT INTO bzh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Log maḳ ham su kwamin nevo brët nemadvahi-bevidek-luu sën alam 4,000 degga geham supin loḳ jebeng va la lo rë? ");
INSERT INTO bzh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ma ham su raḳ ni rë? Sa su nanër nos vu ham rë! Gaḳ senër vu ham bë ham gweġin ham vu Parisai* los Sadukai* hir yiist*!” ");
INSERT INTO bzh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Lob mëm deraḳ ni bë su nër raḳ yiist* sën brët yi lo rë. Gaḳ nenër bë degeġin sir vu Parisai* los Sadukai* hir ġaġek. ");
INSERT INTO bzh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu ya los Sisarea vu distrik Pilipi, lob loḳ tepëḳ in yi hur maluh bë, “Alam denenër Mehönon Nalu bë yi re?” ");
INSERT INTO bzh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Lob denër yah bë, “Mehö la denenër bë Mehö-neripek-alam Jon. Log la denenër bë Elia. Log la denenër bë Yeremia, ma mehö-nenër-ġaġek-ranġahsën wirek hen ti.” ");
INSERT INTO bzh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Loḳ Yesu loḳ tepëḳ yah vu sir bë, “Gaḳ hameḳ nenër bë sa re?” ");
INSERT INTO bzh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Loḳ Simon Pita nër yah bë, “Honġ Kerisi*! Anutu mala-tumsën Nalu honġ!” ");
INSERT INTO bzh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Lom Yesu nër yah vu yi bë, “Jon* nalu Simon! Kwam vesa anon! Alam dob sënë ti su tateḳin ġaġek sënë vu honġ rë. Gaḳ Amaġ sën nedo yaġek lo yö tateḳin vu honġ. ");
INSERT INTO bzh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Om sa nanër vu honġ nabë honġ Pita (sënë degwa nebë ġelönġ), lob sëḳ dev sa dub jaḳ medo ġelönġ sënë, geNyëġ Nipaya su yoh vu bë bare megedu beġö jaḳ dub sënë rë. ");
INSERT INTO bzh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Sëḳ bo kii Nyëġ-yaġek-yi vu honġ. Genġaa sën ġenanërin vu dob lo, og Anutu rëḳ nanërin vu yaġek geving. Genġaa sën ġengoġekin vu dob lo, og Anutu rëḳ bo veyovin gëp yaġek geving.” ");
INSERT INTO bzh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Log Yesu nër niwëëk vu yi hur maluh bë su na denanër vu mehö la nabë yi Kerisi*. ");
INSERT INTO bzh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Log Yesu nër ranġah muġin vu yi hur maluh loḳ buk saga bë rëḳ na Yerusalem, lob alam-teta losho alam-deneḳo-seriveng hir ggev, galam-horek-yi rëḳ debo vanë nġahiseḳë vu yi, gedengis yi menadiiḳ, gebuk natu löö rëḳ mëm kedi jaḳ nah gökin. ");
INSERT INTO bzh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Lob Pita ḳo yi meya nenga bevonġ ġaġek raḳ yi bë, “Mehöböp, su rëḳ nabë saga rë! Nġaa sënë su rëḳ natöḳ vu honġ rë!” ");
INSERT INTO bzh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Loḳ Yesu ggërin yah benër vu Pita bë, “Satan! Ġebare nah sa demiġ, in ġenewërin sa aggata! Su kwam töḳ raḳ Anutu kwa rë, gaḳ kwam nevo nġaa nebë sën mehönon yö kwaj nevo lo!” ");
INSERT INTO bzh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Log Yesu nër vu yi hur maluh bë, “Mehöti bë natu sa hur, og kwa birek in yi gekerë yi ḳelepeḳo* betamuin sa. ");
INSERT INTO bzh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","In mehöti bë kwa bo yi begeġin nivesa, og rëḳ anon mala nama. Gaḳ mehöti bë kwa birekin yi benadiiḳ in sa, og rëḳ medo mala-tumsën. ");
INSERT INTO bzh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nabë mehöti yö geḳo yi jaḳ in nġaa dob yi pin bemedo loḳ nadiiḳ, og yi nġaa sënë rëḳ doḳ vu yi nabë va? Ma mehönon rëḳ debaġo Anutu jaḳ va in gevonġ bedemedo malaj-tumsën-a? Ma! ");
INSERT INTO bzh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mehönon Nalu rëḳ nam los Ama yö niwëëk geyi vuneḳ vuneḳ yaġek yi geyi angër lo, lob doḳ buk sënë og rëḳ bo nyëvewen doḳ nah nġaa pin sën mehönon denevonġ lo vu sir. ");
INSERT INTO bzh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sa nanër vu ham yönon nabë ham sën nare agi vahi su rëḳ denadiiḳ rë, gaḳ rëḳ demedo medegelë geMehönon Nalu nom nabë mehö-los-bengö in geġin hil.” ");
INSERT INTO bzh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Buk nemadvahi-bevidek-ti ya ggovek, log Yesu ḳo Pita geYakobus luho ari Jon bederaḳ ḳedu ading ti, beyö ya denedo. ");
INSERT INTO bzh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Lob delë bë Yesu navi agga ngwë raḳ, bemala netum nebë hes, geyi tob veroo meris nebë davës. ");
INSERT INTO bzh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Lob delë Moses lu Elia detöḳ yam medenevengwënġ ving yi. ");
INSERT INTO bzh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita lë lob nër vu Yesu bë, “Mehöböp, he nado mehalë nġaa sënë om mëm nivesa rot. Bë ahëm geving, og sedev numeng löö gëp sënë, ti vu honġ, ngwë vu Moses, gengwë vu Elia.” ");
INSERT INTO bzh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nahën nevengwënġ, log beggob veroo ti yam bom Yesu lööho, log ġaġek ti yam loḳ beggob ayo nebë, “Sa Naluġ yiḳ sënë, sën sahëġ neving yi los halë yi nivesa lo. Ham gwebë nengamin vu yi!” ");
INSERT INTO bzh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yi hur maluh denġo sënë, lob deggöneng bedepetev beyuj ya dob. ");
INSERT INTO bzh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Loḳ Yesu yam vu sir bebë nema raḳ sir genër bë, “Ham su ġöneng rë, ham kwedi jaḳ!” ");
INSERT INTO bzh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Lob devër malaj raḳ rëḳ su denelë mehöti ving rë, gaḳ yiḳ Yesu yö timu nare. ");
INSERT INTO bzh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sir vu ḳedu menahën deneluḳ medeneyah, lob Yesu nër niwëëk vu sir bë, “Nġaa sën ham lë agi, og ham su na nanër vu mehö la. Rot bemëm Mehönon Nalu kedi jaḳ nah gökin gëp bedub rë, loḳ mëm.” ");
INSERT INTO bzh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lom yi hur maluh deloḳ tepëḳ in yi bë, “Loḳ nebë va sën alam-horek-yi denenër bë Elia rëḳ nom namuġin lo?” ");
INSERT INTO bzh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Loḳ mëm tateḳin yah vu sir bë, “Yönon, Elia rëḳ nom namuġin besemu nġaa pin rë. ");
INSERT INTO bzh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Rëḳ mu sa nanër vu ham nabë Elia yam ggovek ya, rëḳ alam su deraḳ ni rë, gedevonġ paya vu yi yoh vu yö kwaj. Gerëḳ debo vanë vu Mehönon Nalu nabë saga geving.” ");
INSERT INTO bzh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesu nër nebë sënë, lob yi hur maluh deraḳ ni bë nenër Mehö-neripek-alam Jon vu sir. ");
INSERT INTO bzh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Loḳ yah to detöḳ vu alam yu böpata, lob mehöti verup vu Yesu beyun lus vu yi, ");
INSERT INTO bzh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","genër bë, “Mehöböp! Kwam gevonġin sa naluġ. Bado nevonġ yi benavi nipaya raḳ rot. Nevesi yi raḳ nengwah los nevës bël beron nġahiseḳë. ");
INSERT INTO bzh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Lob sa haḳo yam vu honġ hur maluh lo rëḳ su deyoh vu bë degevonġ benivesa jaḳ rë.” ");
INSERT INTO bzh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Lob Yesu nër yah vu yi bë, “Oo, ham alam dahis! Ham su vonġ ving rë! Sëḳ medo buk va la geving ham-a? Gesëḳ medo ḳerë ham maggin noh vu kwev va la geving-a? Maam ham gweḳo hurmahen nam vu sa rë!” ");
INSERT INTO bzh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Lob Yesu petupek raḳ memö, lob lëëin hurmahen geto meya, log bado maya in yi pevis. ");
INSERT INTO bzh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Loḳ Yesu losho yi hur maluh meris yö denedo, lob deloḳ tepëḳ vu yi bë, “Nebë va sën he su ayoh vu bë ġetii memö sënë geto mena rë-ë?” ");
INSERT INTO bzh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Rëḳ Yesu nër vu sir bë, “Ham su nevonġ ving niwëëk rë, om sën ham su yoh vu rë! Kë! Sa nanër vu ham yönon nabë: Bë ham vonġvingsën mahen teka mu nabë mastet* ġahis, og ham rëḳ nanër vu ḳedu sënë nabë ‘Kwedi jaḳ meġena sagu!’, og rëḳ na. Bë ham gwevonġ geving yönon, og ham yoh vu bë rëḳ gwevonġ nġaa pin. ");
INSERT INTO bzh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Su aggata ngwë neggëp in bë hil ġetii memö nabë sënë geto dena rë. Gaḳ hil ayed gërin nos gehil najom jaḳ mu og mëm.” ");
INSERT INTO bzh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yah denedo Galilea lob buk ti lob Yesu nër vu yi hur maluh bë, “Rëḳ debo Mehönon Nalu doḳ na mehönon nemaj. ");
INSERT INTO bzh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Lob rëḳ dengis yi menadiiḳ, loḳ buk natu löö lob kedi jaḳ nah gökin.” Lob yi hur maluh ayoj maggin rot. ");
INSERT INTO bzh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Lob ya deverup Kapernaum, galam sën deneḳo takës-dub-vabuung-böp-yi lo ya deverup vu Pita bedeloḳ tepëḳ vu yi bë, “Maḳ ham tatovaha netunġ takës-dub-vabuung-yi ving-a?” ");
INSERT INTO bzh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Lob Pita yoġek bë, “Ëë-ë, netunġ lo!” Log loḳ ya begganġ ayo, loḳ Yesu tum loḳ tepëḳ in yi muġin bë, “Simon! Kwam nevo bë? Alam-los-bengöj vu dob sënë, deneḳo takës-ḳupeḳ-yi los deneḳo vu mehönon tena? Maḳ yö deneḳo vu hir alam, ma deneḳo vu alam-yu-ngwë?” ");
INSERT INTO bzh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Lob Pita nër yah bë, “Deneḳo vu alam-yu-ngwë!” Lom Yesu nër bë, “Nebë saga, om hir alam su degetë takës gegëp! ");
INSERT INTO bzh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Rëḳ mu alu su ġevonġ bahëj sengën. Om ġena ġeseyu gwaaḳ gëp nġaggee nenga, lob ġël ti sën rëḳ berup namuġin begweḳo jaḳ lo, og ġebasuh avi lob rëḳ ġenatöḳ vu monë ti doḳ. Lob mëm gweḳo monë saga meġena gwetë natu alu hed takës.” ");
INSERT INTO bzh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Vu buk saga Yesu yi hur maluh ya deverup vu yi bedeloḳ tepëḳ in yi bë, “Mehö re tu muġinsën vu Nyëġ-yaġek-yi kesuu alam pin-a?” ");
INSERT INTO bzh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Lob Yesu ḳo hurmahen ti yam bevarah loḳ malaj, ");
INSERT INTO bzh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","genër vu sir bë, “Sa nanër vu ham yönon nabë: Bë ham su gwërin ham gedahun ham nabë hurmahen nebë sënë rë, og ham su yoh vu bë rëḳ doḳ na Nyëġ-yaġek-yi rë. ");
INSERT INTO bzh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mehöti bë dahun yi rot nabë hurmahen sënë, og rëḳ natu muġinsën vu Nyëġ-yaġek-yi kesuu alam pin. ");
INSERT INTO bzh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Log mehöti bë kwa bo sa bedoḳ vu hurmahen nabë sënë ti, og sagaḳ loḳ vu sa.” ");
INSERT INTO bzh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Gaḳ bë mehöti geli sa alam sën ayoj neya timu vu sa mahen teka mu lo ti, begevonġ nġaa nipaya, og rëḳ geḳo nyëvewen böpata rot vu tamusën, gaḳ nabë deseyu ġelönġ böpata doḳ kwa gedegetë duḳ na loo vuheng namuġin bemala nama, og mëm nivesa, in su kepë mehönon la. ");
INSERT INTO bzh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gëp in alam vu dob sënë in nġaa nipaya neggëp merëḳ kepë sir. Yönon! Nġaa nipaya rëḳ berup, rëḳ mu gëp in alam sën denekepë mehönon ngwë raḳ nġaa nipaya lo. ");
INSERT INTO bzh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Lob nabë nemam ma vaham bë gevonġ benġaa nipaya kepë honġ, og maam kwetöv megwetë na. Geyiḳ nemam vahi timu ma vaham vahi timu, in mëm ġemedo malam-tumsën degwata. In rëḳ nemam luu gevaham luu lob degetë honġ doḳ na nengwah sën netum yoh vu buk los ranġah lo. ");
INSERT INTO bzh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Log nabë malam ġahis vahi bë gevonġ benġaa nipaya kepë honġ, og maam ġeselupek vër begwetë na. Geyiḳ malam vahi mu medo in mëm ġemedo malam-tumsën degwata. In rëḳ malam ġahis luu lom degetë honġ doḳ na nengwah sën neggëp Nyëġ-nengwah-yi lo.” ");
INSERT INTO bzh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ham gweġin ham! In rëḳ ham gwekuung nabë hurmahen maluh los avëh nebë sënë sir nġaa meris. Ma! Sa nanër vu ham nabë hir angër vu yaġek sën deneġin sir lo vare denelë Amaġ sën nedo yaġek lo yoh vu buk. ");
INSERT INTO bzh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","In Mehönon Nalu luḳ yam in bë geḳo alam malaj masën nah gökin. ");
INSERT INTO bzh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ham kwamin bo rë. Bë mehöti yi sipsip 100, lob bë ti mala nama, og rëḳ na sero ma rëḳ nama? Gaḳ rëḳ gevuu 99 bedebare ḳedu gena sero ti sën mala ma lo. ");
INSERT INTO bzh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sa nanër vu ham yönon nabë: Bë natöḳ vu sipsip ti saga, og rëḳ kwa vesa in rot kesuu sën kwa vesa in 99 lo. ");
INSERT INTO bzh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nebë sënë, om ham Amamin vu yaġek nilël bë hurmahen nebë sënë ti su mala nama.” ");
INSERT INTO bzh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Bë arim gevonġ nġaa nipaya vu honġ, og nġo ti ġena ġenanër yi nipaya tato vu yi rë. Lob nabë genġo ayem, og saga nebë ġeḳo yi yom vu honġ. ");
INSERT INTO bzh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Rëḳ nabë su nġo ayem rë, og gweḳo mehöti ma mehö luu geving bemelöö nah doḳ ti in meluu ma melöö nanër ġaġek ranġah, og mëm ham rëḳ semu. ");
INSERT INTO bzh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Rëḳ nabë su nġo melöö ayemin rë, og ġenanër vu sa alam pin. Rëḳ nabë su genġo sa alam ayej geving rë, og ham gwelë yi nabë yi alam-yu-ngwë ti, meyi mehö-neḳo-takës*. ");
INSERT INTO bzh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Sa nanër vu ham yönon nabë nġaa sën ham nanërin vu dob lo, og rëḳ Anutu nanërin gëp yaġek geving. Genġaa pin sën ham ngoġekin vu dob lo, og Anutu rëḳ ngoġekin gëp yaġek geving. ");
INSERT INTO bzh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Log sa nanër vu ham yönon gökin nabë: Bë ham mehö luu ayoj timu in nġaa ti vu dob sënë beluho deketaġ in vu Amaġ, og Amaġ sën nedo yaġek lo, rëḳ gevonġ banon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kë, log nabë mehö luu ma mehö löö kwaj bo sarëġ bedengupin sir doḳ ti, og sëḳ nam medo geving sir.” ");
INSERT INTO bzh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Loḳ buk saga Pita ya verup vu Yesu benër vu yi bë, “Mehöböp, arig gevonġ nipaya beron va la vu sa loḳ mëm sa dahun yi nġaa nipaya na? Maḳ noh vu beron nemadvahi-bevidek-luu-a?” ");
INSERT INTO bzh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Loḳ Yesu nër yah vu yi bë, “Sa su rëḳ nanër vu honġ nabë beron nemadvahi-bevidek-luu mu rë. Gaḳ sa nanër vu honġ nabë ġedahun yi nġaa nipaya na noh vu 70 natu beron nemadvahi-videk-luu.” (Nër bë sënë in bë tato nabë hil dahun mehönon hir nġaa nipaya sën denevonġ vu hil lo pin na.) ");
INSERT INTO bzh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Log nër ving bë, “Sën Nyëġ-yaġek-yi anon jaḳ lo, og yiḳ nebë mehö-los-bengö ti vonġin bë yi hur debo doḳ nah yi monë. ");
INSERT INTO bzh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lob deḳo ti ya verup vu yi, geyi nyëvewen böpata rot yoh vu 10 milion kina. ");
INSERT INTO bzh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Rëḳ yi monë su yoh vu bë bo doḳ rë. Lob mehö-los-bengö nër bë mehö la debaġo mehö sënë losho venë lo nalu lo, geyi nġaa pin, bedenatu hur-huk-meris-yi in doḳ nah yi nyëvewen böpata sënë. ");
INSERT INTO bzh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Lob yi hur maluh saga petev meneggëp loḳ vaha gesu bë, ‘Ġenaḳööḳ rë, rëḳ mëm sëḳ bo doḳ nah honġ monë!’ ");
INSERT INTO bzh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Lob ala kwa vonġin yi, benër bë ggovek gesu bo doḳ nah, log vonġ yi yah. ");
INSERT INTO bzh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Lob hur maluh sënë to meya dobnë, lob töḳ raḳ hur maluh ngwë sën vo yi monë yiḳ mahen mu vu wirek yoh vu K100 benyëvewen nahën neggëp vu yi lo. Lob jom yi ahon niwëëk begibek nema loḳ kwa genër bë, ‘Ġebo doḳ nah sa monë!’ ");
INSERT INTO bzh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Lob hur maluh ngwë sënë petev meneggëp loḳ vaha geketaġ vu yi bë, ‘Ġenaḳööḳ rë, rëḳ mëm sëḳ bo doḳ nah honġ monë!’ ");
INSERT INTO bzh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Rëḳ su nġo aye rë, getunġ yi ya ḳarabus in bë mëm bo doḳ yi nyëvewen rë, lob mëm degeḳo yi vër. ");
INSERT INTO bzh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hur maluh vahi delë nġaa sënë, lom ayoj maggin rot, lob ya denër ġaġek sënë pin ranġah vu alaj. ");
INSERT INTO bzh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Lob alaj tahi yi hur maluh saga yah benër vu yi bë, ‘Honġ hur nipaya! Muġinsën ġesu vu sa, lob sa dahun honġ nyëvewen böpata saga ya meris. ");
INSERT INTO bzh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Sa kwaġ vonġin honġ, rëḳ su kwam vonġin hur maluh ngwë saga rë in-a?’ ");
INSERT INTO bzh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Lob ala ahë sengën, lom tunġ yi loḳ ya ḳarabus in debo maggin vu yi bemedo, bemëm bo doḳ nah yi nyëvewen böpata saga los dahis lob mëm. ");
INSERT INTO bzh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Om nabë ham su dahun arimin hir nġaa nipaya na yönon rë, og Amaġ sën nedo yaġek lo rëḳ gevonġ nabë sënë vu ham.” ");
INSERT INTO bzh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu nër ġaġek pin sënë ggovek, log vuu distrik Galilea geya los distrik Yudea hir dob sën neggëp bël Yordan vahi yi. ");
INSERT INTO bzh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lob alam nġahiseḳë detamuin yi bedeya sagu, lob vonġ behir niraḳsën nemaya benijvesa neraḳ. ");
INSERT INTO bzh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Lob alam Parisai* la deyam vu yi bedeloḳ tepëḳ bedeseggi yi bë, “Yoh vu bë mehöti bepul venë jaḳ ġaġek meris meris mahen ti ma ma?” ");
INSERT INTO bzh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Lob Yesu nër yah bë, “Maḳ ham su tevin ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo rë? Ġaġek sënë nebë Anutu tunġ mehönon vu nyëdahis, og tunġ mehönon maluh los avëh! ");
INSERT INTO bzh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Log nër bë, ‘Nebë saga om maluh rëḳ gevuu ama lu ata, log geḳo venë, lob luho denatu anon timu’! ");
INSERT INTO bzh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Om luho su rëḳ nabë luho luu gökin rë, gaḳ luho detu anon timu. Om nġaa sën Anutu duu ahon ggovek ya lo, og mehönon su debepul.” ");
INSERT INTO bzh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lob alam Parisai* denër vu yi bë, “Log nebë va sën Moses vo horek vu hil benër bë mehönon dekevu ḳapiya-vepulsën-yi bedebo vu venëj gedejuuk sir na-ë?” ");
INSERT INTO bzh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Loḳ Yesu nër yah vu sir bë, “Ham ayomin niggoh om sën Moses yoġekin bë ham bepul venëmin nah. Rëḳ su nebë saga vu nyëdahis rë. ");
INSERT INTO bzh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Om sa nanër vu ham nabë: Bë mehöti venë su vonġ baggëb rë, rëḳ regga vuu yi geḳo avëh ngwë, og mehö saga vonġ baggëb.” ");
INSERT INTO bzh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Lob yi hur maluh denër bë, “Bë nġaa nabë sënë gëp vu maluh los venëj, og maam mehönon su degeḳo sir.” ");
INSERT INTO bzh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Lob nër yah vu sir bë, “Alam pin su deyoh vu bë degevonġ noh vu ġaġek sën denatu timu agi rë, gaḳ alam vahi sën Anutu duu sir niwëëk revuh ti lo, og sir saga mu sën deyoh vu bë desepa doḳ. ");
INSERT INTO bzh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Alam aggagga su deyoh vu bë rëḳ degeḳo avëh rë. In mehö la og ataj yö ḳo sir nebë saga. Log alam denevonġ paya vu mehö la besu deneḳo avëh rë. Log alam la kwaj nevo Nyëġ-yaġek-yi, lob ayoj ni nelël bë su degeḳo venëj. Mehöti yoh vu bë gevonġ noh vu ġaġek sënë og gevonġ.” ");
INSERT INTO bzh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lob alam deḳo hurmahen la medeya vu Yesu in bë gebë nema jaḳ sir genajom jaḳ sir. Rëḳ yi hur maluh deruuk losho ataj. ");
INSERT INTO bzh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Loḳ Yesu nër bë, “Ham gwevonġ hurmahen denam vu sa. Ham su gwërin sir, in alam sën ayoj neyam timu vu sa nebë hurmahen, og alam Nyëġ-yaġek-yi sir.” ");
INSERT INTO bzh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Log bë nema raḳ sir log ya raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Lob mehö maġëm ti ya verup vu Yesu beloḳ tepëḳ vu yi bë, “Tatovaha! Mëm sa ġevonġ va ti nivesa in mëm sa medo malaġ tumsën degwata los degwata?” ");
INSERT INTO bzh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Lob Yesu nër yah vu yi bë, “Ġeloḳ tepëḳ in sa in nġaa nivesa in va? Yiḳ Mehö timu nedo beyi mehö nivesa! Kwam nevo bë ġemedo malam-tumsën, og ġesepa doḳ Anutu yi horek pin!” ");
INSERT INTO bzh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Rëḳ loḳ tepëḳ yah ggökin bë, “Horek tena?” Lom Yesu nër yah vu bë, “Horek nebë sënë: Su ġengis mehönon medenadiiḳ! Su gwevonġ baggëb! Su ġeġodeḳ nġaa! Su ġenanër ġaġek kuungsën jaḳ mehö ngwë! ");
INSERT INTO bzh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ġeġurek amam lu atam babuj! Log ahëm geving alam sën denedo dus vu honġ lo nabë sën nġo ahëm neving honġ!” ");
INSERT INTO bzh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Lob mehö maġëm sënë nër yah vu yi bë, “Sa nesepa loḳ horek pin sënë ggovek ya. Rëḳ mu sa ġevonġ va ngwë geving-a?” ");
INSERT INTO bzh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Lob Yesu nër vu bë, “Bë ġenatu mehö yohvu, og gwevonġ honġ ḳupeḳ pin balam debaġo, lob ġebo monë sën gweḳo jaḳ honġ nġaa pin lo vu alam sën deneraḳ vu in nġaa lo, log mëm ġenam ġetamuin sa, gemëm honġ ḳupeḳ nivesa rëḳ gëp vu yaġek.” ");
INSERT INTO bzh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Rëḳ mehö maġëm nġo ġaġek sënë, lob ya los ayo maggin rot, in yi ḳupeḳ nġahiseḳë rot. ");
INSERT INTO bzh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Lob Yesu nër vu yi hur maluh bë, “Sa nanër vu ham yönon nabë mehö-los-bengö-ggoreksën bë doḳ na Nyëġ-yaġek-yi, og rëḳ bimengin rot. ");
INSERT INTO bzh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sa nanër gökin vu ham nabë kamer ti bë gurek na rureḳ len, og yiḳ huk böpata rot, rëḳ mu nabë mehö-los-bengö-ggoreksën gevonġin nabë doḳ na Anutu yi nyëġ, og sagaḳ huk böpata rot kesuu.” ");
INSERT INTO bzh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lom yi hur maluh denġo ġaġek sënë lom delëk bedenër bë, “Om maḳ re yoh vu bë rëḳ medo mala-tumsën degwata?” ");
INSERT INTO bzh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Lob Yesu gët sir genër vu sir bë, “Mehönon su deyoh vu bë degevonġ beyö demedo malaj-tumsën rë, gaḳ Anutu yö yoh vu bë gevonġ bedemedo malaj-tumsën. In Anutu yoh vu bë gevonġ nġaa pin.” ");
INSERT INTO bzh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nër bë sënë lob Pita nër yah vu bë, “Gwelë! He hevuu he nġaa pin ya gehe yam medo nesepa honġ, om he rëḳ ġaḳo va nivesa jaḳ sënë?” ");
INSERT INTO bzh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Lob mëm Yesu nër vu sir bë, “Sa nanër vu ham yönon nabë vu Buk-tumusën genġaa pin pekwë yi natu mewis, geMehönon Nalu jaḳ medo mehö-los-bengö yi sëa malanġeri belos arë, og mëm vu buk saga ham sën netamuin sa agi rëḳ jaḳ medo sëa-los-arëj nemadluho-bevidek-luu geving sa. Lob ham rëḳ gwenġo alam Israel degwaj nemadluho-bevidek-luu hir ġaġek. ");
INSERT INTO bzh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Log alam pin sën kwaj nevo sarëġ bedenevuu hir begganġ, ma arij, ma avëhnöj, ma amaj, ma ataj, ma naluj, ma hir dob lo, og rëḳ degeḳo nyëvewen mehödahis jaḳ gëp alam nemadvahi doḳ nah sënë, log demedo malaj-tumsën degwata los degwata. ");
INSERT INTO bzh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Rëḳ mu alam nġahijseḳë vu muġinsën rëḳ nom denatu alam tamusën, log alam nġahijseḳë vu tamusën rëḳ nah denatu alam muġinsën.” ");
INSERT INTO bzh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Kë”! Sën Nyëġ-yaġek-yi anon jaḳ lo, og yiḳ nebë mehöti sën kedi raḳ loḳ monbuk anon meya nesero alam in degevonġ huk in yi wain. ");
INSERT INTO bzh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Lob vengwënġ ving hur la, bedeyoġekin bë degeḳo kina ti doḳ buk saga og ggovek, log mëm vonġ sir medeya denevonġ yi huk wain. ");
INSERT INTO bzh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Loḳ yah verup loḳ 9 krök, lob lë alam la gedenare meris mu raḳ telig, in huk main sir. ");
INSERT INTO bzh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Lob nër vu sir bë, ‘Ham na gwevonġ sa huk wain geving, log sëḳ baġo ham nivesa.’ Lob deya huk. ");
INSERT INTO bzh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Log hes vuheng raḳ 12 krök los 3 krök, lob yah to bevonġ nebë sënë ggökin. ");
INSERT INTO bzh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Log 5 krök sehuksën, lob yah to belë bë alam la denare, lob nër vu sir bë, ‘Ham nare sënë yoh vu hes mala pin in va?’ ");
INSERT INTO bzh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Loḳ denër yah bë, ‘Huk main he!’ Lob nër bë, ‘Om ham na gwevonġ sa huk wain geving!’ ");
INSERT INTO bzh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Lob buk loḳ, lob huk wain ala nër vu mehö sën neġin alam huk yi lo bë, ‘Ġetahi hur nam beġebaġo sir. Ġebaġo gëp alam sën deyam huk tamusën lo, bena natöḳ na alam sën deyam muġin lo!’ ");
INSERT INTO bzh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Lob alam sën deneya huk raḳ 5 krök sehuksën lo denare yam, besir ti ti deneḳo monë kina ti ti. ");
INSERT INTO bzh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Galam sën deyam huk muġinsën lo denare yam, gekwaj nevo bë rëḳ degeḳo monë nġahiseḳë rot. Rëḳ ma! Yiḳ deneḳo kina ti ti nebë saga ving. ");
INSERT INTO bzh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Deḳo monë, rëḳ mu devonġ ayej nipaya vu huk ala medenër bë, ");
INSERT INTO bzh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Alam sënë deyam tamusën, bedevonġ huk sehuksën mu, rëḳ ġebaġo sir nebë he. Gaḳ he nehevonġ huk böpata hes ading rot, behes negga he rot.’ ");
INSERT INTO bzh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Denenër nebë sënë, lob nër yah vu sir ti bë, ‘Sa mehö-e! Sa su hevonġ nipaya vu ham rë! Hil ajoo ġaġek muġin bë sëḳ baġo honġ jaḳ monë kina ti, ");
INSERT INTO bzh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","om gweḳo honġ monë beġena. Monë sën sevo vu honġ lo, og sa bë ġevonġ vu alam tamusën geving nabë saga. ");
INSERT INTO bzh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bë sa ġevonġ nġaa ti jaḳ senġo sa monë sënë, og maḳ sënë su yoh vu rë? Sa hevonġ nivesa rëḳ ahëm nevonġin sënë in va?’ ");
INSERT INTO bzh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Om alam vu tamusën rëḳ nah denatu alam muġinsën galam vu muġinsën rëḳ nom denatu alam tamusën nabë saga.” ");
INSERT INTO bzh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Lob Yesu neya in bë na Yerusalem, lob yi hur maluh nemadluho-bevidek-luu desepa yi medeneya ving. Nahën denetetuu aggata medeneya, lob Yesu ḳo sir yah nenga menër vu sir bë, ");
INSERT INTO bzh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ham nġo? Gwëbeng hil naraḳ menaya Yerusalem, lob rëḳ degetunġ Mehönon Nalu doḳ na alam-deneḳo-seriveng hir ggev lo los alam-horek-yi lo nemaj. Lob rëḳ denanër ġaġek venuh nabë dengis yi nadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Log rëḳ debo yi doḳ na alam dahis nemaj, in denanër ġaġek pelësën jaḳ yi los debeek yi gedengis brëm na yi betii ḳelepeḳo*. Gebuk natu löö loḳ kedi jaḳ nah gökin.” ");
INSERT INTO bzh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Lob Sebedi venë ḳo nalu luho sepa beya vu Yesu, lom petev meneggëp loḳ vaha in bë ketaġ nġaa ti vu. ");
INSERT INTO bzh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Lob Yesu nër vu yi bë, “Ġeyam in va?” Lob nër yah vu bë, “Ġenanër nabë sa naluġ luho denatu honġ ġadu gëp honġ Nyëġ. Ngwë medo gëp nemam vesa gengwë medo gëp nemam ḳëj.” ");
INSERT INTO bzh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nër bë sënë, loḳ Yesu nër yah vu nalu luho bë, “Melu su raḳ nġaa sën melu nekwetaġ in vu sa agi ni rë. Ma melu yoh vu bë melu rëḳ nanum doḳ kap* sën sëḳ nanum doḳ lo?” Rëḳ luho denër yah bë, “Alu ayoh vu!” ");
INSERT INTO bzh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Lob Yesu nër vu luho bë, “Yönon, melu rëḳ nanum doḳ sa kap! Rëḳ mu mehö sën rëḳ medo gëp sa nemaġ vesa gemehö sën rëḳ medo gëp sa nemaġ ḳëj lo, og su neggëp vu sa rë. Gaḳ alam sën Amaġ yö ggooin sir raḳ lo, sën rëḳ demedo doḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Lob sir nemadluho denġo luho hir ġaġek sënë, lob ahëj sengën vu luho ari. ");
INSERT INTO bzh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Rëḳ Yesu supin sir yam benër vu sir bë, “Ham raḳ ni! Alam dahis hir alam sën deneġin sir lo, og deneḳo sir raḳ vu hir alam. Gehir alam böp denedeġinengin hir alam raḳ horek nġahi. ");
INSERT INTO bzh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Rëḳ mu ham, og ham su gwevonġ nabë saga! Gaḳ mehöti bë gevonġin nabë natu ham mehö böp ti, og gevonġ nġaa nabë sën tu ham hur in doḳ vu ham. ");
INSERT INTO bzh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Log bë mehöti gevonġin nabë natu ham mehö muġinsën ti, og gevonġ nġaa nabë sën yi mehö meris lo begevonġ huk nyëmasën vu ham. In Mehönon Nalu yiḳ nebë saga. ");
INSERT INTO bzh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Su yam in bë alam degevonġ huk vu yi rë. Gaḳ yam in bë gevonġ huk vu mehönon genadiiḳ doḳ nah alam nġahiseḳë bej in geḳo sir nah vu Anutu.” ");
INSERT INTO bzh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Log dekedi vu Yeriko bedeya lob alam nġahiseḳë detamuin Yesu. ");
INSERT INTO bzh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lob mehö mala ḳenod luu denedo loḳ aggata nenga. Luho denġo ġaġek bë Yesu to neyam, lob luho detahi niwëëk bë, “Mehöböp, Davit* yi Mewis honġ! Kwam gevonġin aluu!” ");
INSERT INTO bzh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lob alam saga depetupek raḳ luho bë luho ayej nama, rëḳ ma geluho pasanġ detahi böpata rot bë, “Mehöböp! Davit* yi Mewis honġ! Kwam gevonġin aluu!” ");
INSERT INTO bzh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Lob Yesu nare betahi luho benër bë, “Melu vonġin bë sa ġevonġ va vu meluu-a?” ");
INSERT INTO bzh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lob luho denër yah vu bë, “Mehöböp, alu hevonġ in bë gwevonġ balu malamin nivesa jaḳ nah.” ");
INSERT INTO bzh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Lob Yesu kwa vonġin luho mebë nema raḳ luho malaj, lob pevis beluho malaj tum medelë nyëġ ggökin, geluho detamuin yi bedeya. ");
INSERT INTO bzh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ya deverup dus raḳ Yerusalem, lob detöḳ ya Betpage vu Ḳedu Ḳele-oliv. Lob Yesu vonġ hur maluh luu deya, ");
INSERT INTO bzh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","log nër vu luho bë, “Melu doḳ na begganġ-bu ti sën melu malamin neya agu, lob pevis bemelu rëḳ gwelë dogi ti gedeseyu menare genalu nare ving. Lob melu kwevelekin begweḳo luho nom vu sa. ");
INSERT INTO bzh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Lob nabë mehöti nanër ġaġek jaḳ meluu, og melu nanër nabë Mehöböp bë jaḳ mena. Lob rëḳ gevonġ luho nam pevis.” ");
INSERT INTO bzh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Vonġ nġaa sënë in ġaġek sën mehö-nenër-ġaġek-ranġahsën nër lo anon jaḳ nabë: ");
INSERT INTO bzh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ham nanër vu nyëġ Sion* yi alam nabë sënë: ‘Ham gwelë ham mehö-los-bengö neyök vu ham. Yi mehö mala yes ti, lob raḳ nedo dogi beneyam. Raḳ nedo dogi-ḳupeḳ-yi nalu ti beneyök.’” ");
INSERT INTO bzh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Lob hur maluh luho ya devonġ yoh vu sën Yesu nër vu luho lo. ");
INSERT INTO bzh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Luho deḳo dogi ata ving nalu, lob delah hir röpröp ayööng yi raḳ ya dogi luho demij, beYesu raḳ nedo. ");
INSERT INTO bzh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Galam nġahiseḳë dekah hir röpröp ayööng yi bedevah neggëp aggata. Log la denesap ḳapah medenebë neggëp aggata ving. ");
INSERT INTO bzh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lob alam vahi sën denemuġin gevahi sën denetamuin yi lo denepisekin medenetahi bë: “Hosana, Oo Davit* Nalu! Anutu gevonġ semusemu vu mehö sën neyam los Mehöböp niwëëk! Hil ġaḳo Anutu arë jaḳ na vavunë rot!” ");
INSERT INTO bzh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mëm Yesu loḳ ya Yerusalem, lob alam pin detahi bedevonġ nyëġ dedun raḳ log sir vahi deneloḳ tepëḳ vu sir bë, “Mehö re sënë?” ");
INSERT INTO bzh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lob alam sën deneya ving yi lo denër yah bë, “Mehö-nenër-ġaġek-ranġahsën Yesu vu Nasaret ggëp distrik Galilea!” ");
INSERT INTO bzh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Lob Yesu loḳ ya dub-vabuung-böp ayo betii alam pin sën denedo loḳ medenebaġo nġaa los alam sën denetunġ nġaa in mehö ngwë baġo lo. Log keyoveḳin tevor pin sën denepekwë* monë raḳ lo ving alam sën denetunġ nuung lo hir sëa. ");
INSERT INTO bzh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Log nër vu sir bë, “Ġaġek neggëp loḳ Anutu-yi-ḳapiya nebë, ‘Sa begganġ og rëḳ denanër nabë begganġ jom-raḳsën-yi. Rëḳ ham vonġ beyah tu alam hodeḳ bej waaḳ vunsën raḳ.’” ");
INSERT INTO bzh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesu nedo loḳ dub-vabuung-böp lob vonġ alam malaj ḳenod la gevahaj nipaya la, benijvesa raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Alam-deneḳo-seriveng hir ggev los alam-horek-yi ahëj sengën raḳ in delë bë nevonġ nġaa böp böp nebë saga, log denġo hurmahen bë denepisekin loḳ dub ayo nebë, “Hosana vu Davit* yi Mewis!” lob denër vu yi bë, ");
INSERT INTO bzh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“Maḳ su ġenġo ġaġek sën denenër-ë rë?” Loḳ Yesu nër yah vu sir bë, “Ëë-ë, sa hanġo! Gaḳ ham su tevin ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo rë? Nebë: ‘Ġetahu hurmahen sën nahën denevengwënġ paya paya los sën ataj nahën denevo rur vu sir lo, gedegeḳo arëm jaḳ niröp anon.’” ");
INSERT INTO bzh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Log vuu sir geto meya beyah Betania beya neggëp sagu. ");
INSERT INTO bzh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Heng to, lob Yesu kedi meyah nyëġ böp lob diiḳahë, ");
INSERT INTO bzh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","lob lë ḳele pik* ti nare loḳ aggata nenga beya in, rëḳ anon ma geris meris. Lob nër vu ḳele pik* sënë bë, “Su ġengis anom gökin genama na veröḳ yi!” Lob pevis beḳele pik* lo meran ya. ");
INSERT INTO bzh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yi hur maluh delë nebë sënë, lob delëk beḳenuj ya gedenër bë, “Nebë va sën ḳele pik* meran ya pevis-ë?” ");
INSERT INTO bzh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Loḳ Yesu nër yah vu sir bë, “Sa nanër vu ham yönon nabë: Bë ham gwevonġ geving anon, geham su kwamin luu luu rë, og rëḳ ham gwevonġ nġaa nabë sën sa hevonġ vu ḳele pik* agi. Lob ham su rëḳ gwevonġ sënë mu rë. Gaḳ bë ham nanër vu ḳedu sagu nabë, ‘Kwedi gwetë honġ duḳ na loo vuheng!’ og rëḳ anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Log bë ham gwevonġ geving benajom jaḳ in nġaa ti, og nġaa pin sën ham nekwetaġ in bë gweḳo lo, og saga ham rëḳ gweko.” ");
INSERT INTO bzh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Log Yesu loḳ ya dub-vabuung-böp betateḳin ġaġek vu alam. Lob alam-deneḳo-seriveng hir ggev los Israel hir alam teta deverup vu yi bedenër bë, “Re vo niwëëk vu honġ benër bë gwevonġ huk nabë sënë? Re ggooin honġ raḳ-a?” ");
INSERT INTO bzh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Loḳ Yesu nër yah vu sir bë, “Kë”, om sa bë doḳ tepëḳ in ġaġek ti nök vu ham rë, loḳ nabë ham nanër nom, og mëm sëḳ nanër mehö sën ggooin sa raḳ in bë sa ġevonġ huk agi nök vu ham. ");
INSERT INTO bzh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sën Mehö-neripek-alam Jon neripek alam lo, og maḳ degwa vu tena? Maḳ yam vu yaġek ma sepa loḳ mehönon vu dob kwaj?” Lob tum yah denesap sir raḳ medenenër bë, “Bë hil nanër nabë yam vu yaġek, og rëḳ doḳ tepëḳ nom vu hil nabë, ‘Rëḳ nebë va sën ham su vonġ ving yi rë-ë?’ ");
INSERT INTO bzh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Log nabë hil nanër nabë sepa loḳ mehönon vu dob kwaj, og hil rëḳ aġönengin alam sën denare-ë. In sir pin kwaj nevo Jon bë yi mehö-nenër-ġaġek-ranġahsën ti yönon.” ");
INSERT INTO bzh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Lob denër yah vu Yesu bë, “He duġin degwa-o!” Lob Yesu nër yah vu sir bë, “Nebë saga, om sa su rëḳ nanër mehö sën ggooin sa raḳ lo vu ham rë!” ");
INSERT INTO bzh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Rëḳ ham kwamin vo bë? Mehöti nalu luu denedo, lob ya vu nalu aġuu benër vu bë, ‘Naluġ-e, pehi sënë ġena gwevonġ sa huk wain!’ ");
INSERT INTO bzh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Loḳ nalu nër yah vu bë, ‘Sa niġ lël!’ Loḳ yom ggërin ayo geya mevonġ huk wain. ");
INSERT INTO bzh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Log yiḳ ama ya menër vu nalu amon nebë saga, lob yoġek bë ‘Ëë, amaġ! Sëḳ na!’ Rëḳ su ya rë. ");
INSERT INTO bzh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Lom nalu ngwë tena sën nġo ama aye?” Rëḳ denër yah bë, “Nalu aġuu!” Lob Yesu nër yah vu sir bë, “Om sa nanër vu ham yönon nabë alam-deneḳo-takës* losho avëh baggëb denevonġ ving bedeneloḳ ya Anutu yi Nyëġ in ham. ");
INSERT INTO bzh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","In Mehö-neripek-alam Jon yam betateḳin aggata niröpsën vu ham, rëḳ ham su vonġ ving yi rë. Gaḳ alam-deneḳo-takës* gavëh baggëb lo yö denevonġ ving yi. Beham lë sir ggovek ya, rëḳ ma geham su wërin ham bevonġ ving yi rë.” ");
INSERT INTO bzh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ham gwenġo ġaġek peggirinsën ngwë agi rë! Mehöti los yi dob böpata bevaroh huk wain bengö ti. Gejegelin ġelönġ netu heek beggërin, gesemu nyëġ gelev asoreng ti in denapip wain anon doḳ, belev begganġ ading ti sën debare jaḳ medemalajin huk wain lo ving. Lob vo huk sënë loḳ ya mehö la nemaj in bë degeġin ganon vahi natu yi yi gevahi natu hej, log tah yi ya nyëġ ngwë. ");
INSERT INTO bzh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Gebuk sën wain anon nemoneḳ lo dus raḳ, lob vonġ yi hur la deya vu alam sën deneġin huk lo in bë degeḳo yi wain anon vahi. ");
INSERT INTO bzh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Rëḳ alam sën deneġin huk lo dejom yi hur lo ahon bedeneveek la, gedenesis la medenediiḳ, gedenetengwa la raḳ ġelönġ. ");
INSERT INTO bzh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Loḳ huk ala vonġ hur la deyah ggökin. Vonġ alam nġahiseḳë kesuu sën vonġ ya muġin lo, rëḳ alam sën deneġin yi huk lo yiḳ devonġ nebë saga vu sir ving. ");
INSERT INTO bzh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Log vonġ nalu ya vu sir raḳ neggëp hus. In kwa nevo bë, ‘Rëḳ degurek babu!’ ");
INSERT INTO bzh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Rëḳ alam sën deneġin huk wain lo delë nalu lob yö denër vu sir bë, ‘Mehö sënë rëḳ doḳ nah ama ben vu tamusën begeḳo yi nġaa pin. Om ham-o! Hil angis yi benadiiḳ log mëm yi huk sënë natu hil nġaa!’ ");
INSERT INTO bzh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Lob dejom ahon mederot yi yah dobnë, gedesis mediiḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Lom Yesu loḳ tepëḳ bë, “Om ham kwamin nevo bë? Nahub rëḳ huk wain ala nam, og rëḳ gevonġ nabë va vu alam sën deneġin yi huk lo?” ");
INSERT INTO bzh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lob denër yah vu yi bë, “Rëḳ ngis alam nij paya sënë beyuj ḳataḳ jaḳ. Gerëḳ bo huk wain saga vu alam mewis la bedegeġin, rëḳ mëm buk sën dejur anon lo, og mëm debo vahi vu yi!” ");
INSERT INTO bzh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Lob Yesu nër vu sir bë, “Maḳ ham su tevin ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo rë? Nebë: ‘Alam sën denelev begganġ lo, nij lëlin ġelönġ ti sënë. Rëḳ mu sënë netu ġelönġ niwëëk begganġ nyëḳetu-yi. Mehöböp vonġ sënë lob he halë bë nivesa rot.’ ");
INSERT INTO bzh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Om sa nanër vu ham nabë rëḳ Anutu geḳo yi Nyëġ vër in ham, gebo vu alam sën degevonġ banon jaḳ lo. ");
INSERT INTO bzh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Lob mehöti bë bës bengis yi jaḳ ġelönġ sënë, og rëḳ metes jaḳ. Ma bë ġelönġ sënë geto mejaḳ gëp mehöti, og rëḳ ḳataḳ jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Alam-deneḳo-seriveng hir ggev los alam Parisai* denġo ġaġek peggirinsën sën Yesu nër agi, lob deraḳ ni bë nenër raḳ sir. ");
INSERT INTO bzh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lob bë denajom yi ahon, rëḳ deneggönengin alam sën yam denare lo in kwaj nevo Yesu bë yi mehö-nenër-ġaġek-ranġahsën ti. ");
INSERT INTO bzh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Log Yesu nër ġaġek peggirinsën ngwë ggökin bë: ");
INSERT INTO bzh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Sën Nyëġ-yaġek-yi anon jaḳ lo, og yiḳ nebë sën mehö-los-bengö ti bë getunġ avëh na vu nalu, lob vonġ nos böpata. ");
INSERT INTO bzh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wirek vonġ dik ya in alam la in bë denam dega nos sën nalu lu venë rëḳ denajom nemaj lo, lob loḳ buk sën bë dega nos lo, lob vonġ yi hur la yah denër vu sir. Rëḳ su deyam rë, genij nelël medenedo. ");
INSERT INTO bzh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Lob vonġ hur la yah ggökin genër vu sir bë, ‘Ham na vu alam sën sa hevonġ dik ya in sir wirek lo, beham nanër vu sir nabë sa hero nos ggovek menedo. Sa hevonġ medesis burmakau böp böp los nalu tuveḳ sën jeji lo ggovek ya. Besa semu nġaa pin ggovek benedo. Ham nam in gwa nos böp sën naluġ lu venë denejom nemaj!’ ");
INSERT INTO bzh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yi hur ya denër ġaġek sënë vu sir, rëḳ nij tebö besu debë nengaj vu rë, gedeya jeggin jeggin. Ti ya yi huk, gengwë ya nevonġ yi huk stewa, ");
INSERT INTO bzh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","gesir vahi dejom mehö-los-bengö yi hur ahon medenevasap sir, gedenesis sir medenediiḳ. ");
INSERT INTO bzh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lob mehö-los-bengö ahë sengën rot bevonġ yi alam-beġö-yi ya desis alam sën desis yi hur medediiḳ lo pin bemalaj maya, gedevesi loḳ hir nyëġ ving. ");
INSERT INTO bzh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Log mehö-los-bengö nër vu yi hur lo bë, ‘Nos böp sën naluġ lu venë denejom nemaj lo nöḳ ggovek ya menedo, rëḳ alam sën sa hevonġ dik ya in sir wirek lo, sir mehönon nij paya besu deyoh vu bë dega rë. ");
INSERT INTO bzh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Om ham na menoh vu aggata böp sën nevasuh yi lo pin, lob alam pin sën ham natöḳ vu gëp sagu, og ham nanër vu sir nabë nam dega nos sën naluġ lu venë denejom nemaj agi!’ ");
INSERT INTO bzh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nër nebë sënë, log yi hur deyoh vu aggata pin bedesupin alam pin sën denetöḳ vu sir lo, alam nijvesa losho alam nij paya pin. Beyam denedo begganġ sën maluh lu venë denejom nemaj lo bepup. ");
INSERT INTO bzh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","To denedo gemehö-los-bengö loḳ ya in bë gelë sir. Lob lë mehöti gesu röp röpröp nebë sën vo vu yi vatëveḳ pin mederöp lo rë, gema. ");
INSERT INTO bzh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Lob mehö-los-bengö nër vu yi bë, ‘Sa mehö-e! Ġeyoh tena meġeloḳ yam sënë gesu ġeröp röpröp rë?’ Rëḳ mehö sënë su nër ġaġek ti rë. ");
INSERT INTO bzh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Lom mehö-los-bengö nër vu yi hur lo bë, ‘Ham naduu nema los vaha gegwetë yi geto mena dobnë, bena medo malaḳenu sagu, bengu megeköö nyë!’” ");
INSERT INTO bzh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Lom Yesu nër bë, “Kë”, Anutu nevonġ dik ya vu alam nġahiseḳë, rëḳ neggooin ti ti mu raḳ in dedoḳ na!” ");
INSERT INTO bzh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lob alam Parisai* yö yah denër vu sir bë, “Hil natöḳ vu ġaġek ti tena in hil naduu Yesu?” In sir bë denaduu Yesu nabë sën mehönon denesis soḳ loḳ leḳ lo. ");
INSERT INTO bzh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Lob devonġ hir hur maluh lo ving Herot* yi alam beya denër vu Yesu bë, “Tatovaha! He naraḳ ni bë honġ mehö niröp! Lob ġenetateḳin Anutu yi aggata vu alam los anon. Su ġenehönengin alam malaj rë, gaḳ ġenenër ġaġek neggëp ti vu alam meris gevu alam los arëj ving. ");
INSERT INTO bzh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Om ġenanër vu he rë, nabë yoh vu bë hil ġetunġ takës vu alam Rom hir mehö-los-bengö Sisar* ma nama?” ");
INSERT INTO bzh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Rëḳ Yesu raḳ nij bë sir alam kwaj luu lob nër bë, “Ham alam kwamin luu! Ham bë seggi sa? ");
INSERT INTO bzh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Maam ham tato monë-takës-yi ti vu sa rë!” Lob deḳo monë ġahis ti yam vu yi, ");
INSERT INTO bzh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","lob loḳ tepëḳ in sir bë, “Re ḳenu los arë sën raḳ neggëp agi?” ");
INSERT INTO bzh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Lob denër yah bë, “Sisar*!” Lob nër yah vu sir bë, “Om ham gwevonġ Sisar* yi nġaa nah vu Sisar*, log Anutu yi nġaa og ham bo nah vu Anutu!” ");
INSERT INTO bzh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Denġo ġaġek sënë lob delëk beḳenuj ya. Lob devuu yi gedeya. ");
INSERT INTO bzh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Alam Sadukai* denenër bë alam-diiḳsën og su rëḳ dekedi jaḳ nah rë. Lob sir la deya vu Yesu yiḳ loḳ buk saga bedeloḳ tepëḳ in yi bë, ");
INSERT INTO bzh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tatovaha! Moses nër bë, ‘Bë mehöti nalu nama log nadiiḳ, og ari geḳo yi alov beluho degeḳo naluj vu ari.’ ");
INSERT INTO bzh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Lob mehöti losho ari lo, sir nemadvahi-bevidek-luu denedo ving he wirek. Lob arij aġuu ḳo avëh lob diiḳ, genalu ma. Lob ari amon ḳo yi alov, ");
INSERT INTO bzh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","loḳ ari amon diiḳ nebë saga, lob gwee nebë saga beya meto arij meggi. ");
INSERT INTO bzh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sir pin naluj ma gedediiḳ, log avëh diiḳ raḳ neggëp hus. ");
INSERT INTO bzh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Om ġenanër nabë najeeng sën mehönon diiḳsën dekedi jaḳ nah lo, og avëh sënë rëḳ natu arij ti tena venë? In sir pin deḳo avëh timu saga netu venëj.” ");
INSERT INTO bzh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Loḳ Yesu nër yah vu sir bë, “Ham su raḳ Anutu yi ġaġek sën neggëp loḳ yi ḳapiya lo ni rë! Beham su raḳ Anutu niwëëk ni ving rë! Om sën ham nekuung raḳ in ham rot. ");
INSERT INTO bzh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Vu buk sën mehönon diiḳsën dekedi jaḳ nah lo, og maluh su rëḳ degeḳo avëh rë, gavëh su rëḳ dejaḳ maluh rë, gaḳ rëḳ nama. Gaḳ rëḳ demedo nabë angër lo vu yaġek. ");
INSERT INTO bzh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Rëḳ ġaġek sën mehönon diiḳsën bë dekedi jaḳ nah lo! Maḳ ham su tevin ġaġek sën Anutu nër vu ham meneggëp loḳ yi ḳapiya lo rë? Sën nër nebë, ");
INSERT INTO bzh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Sa Abraham yi Anutu sa, gIsaak yi Anutu sa, geYakop yi Anutu sa.’ Nabë mehönon denadiiḳ bemalaj nama na veröḳ yi, og su yoh vu bë nanër nabë lööho hir Anutu yi rë, gaḳ lööho denedo malaj-tumsën, in Anutu og alam malaj vesa los malaj-tumsën hir Anutu yi.” ");
INSERT INTO bzh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lob alam pin sën denġo ġaġek agi lo delëk beḳenuj ya. ");
INSERT INTO bzh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Loḳ alam Parisai* denġo bë Yesu yi ġaġek saga vonġ Sadukai* bededuj ma, lob desupin sir ya vu yi ");
INSERT INTO bzh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","in bë deseggi yi, lob hir mehö-horek-yi ti loḳ tepëḳ in yi bë, ");
INSERT INTO bzh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tatovaha! Horek ti tena kesuu horek vahi pin-a?” ");
INSERT INTO bzh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Lob Yesu nër vu yi bë, “Ahëm geving Mehöböp honġ Anutu los ayom dahis, beḳenum los dahis, gekwam los dahis na vu yi timu. ");
INSERT INTO bzh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Horek dus ti sënë böpata rot bekesuu vahi pin. ");
INSERT INTO bzh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Lob horek böp ngwë netu luu nebë saga nebë, ‘Ahëm geving alam sën denedo dus vu honġ nabë sën nġo ahëm neving honġ lo.’ ");
INSERT INTO bzh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","In Horek pin los alam-denenër-ġaġek-ranġahsën hir ġaġek pin lo degwaj neggëp loḳ horek luu sënë.” ");
INSERT INTO bzh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Alam Parisai* desupin sir benahën denedo, lob Yesu loḳ tepëḳ in sir bë, ");
INSERT INTO bzh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ham kwamin nevo Mehö sën Anutu ggooin raḳ in bë geḳo hil nah lo bë maḳ degwa vu re?” Loḳ denër yah vu yi bë, “Degwa vu Davit*.” ");
INSERT INTO bzh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Lob nër yah vu sir bë, “Rëḳ nebë va sën Anon Vabuung vo kwa vu Davit benër Mehöböp raḳ Kerisi-ë? ");
INSERT INTO bzh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Sën nër bë: ‘Mehöböp nër vu sa Mehöböp nebë: “Ġemedo sa nemaġ vesa. Gevu tamusën og sëḳ ġetunġ alam sën denelë honġ paya lo dedoḳ na vaham ġebinë.” ’ ");
INSERT INTO bzh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yi degwa vu Davit*, loḳ nebë tena sën Davit nër yi bë yi Mehöböp-ë?” ");
INSERT INTO bzh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Lob mehöti su yoh vu bë nanër ġaġek ti doḳ nah vu Yesu rë. Lob deggönengin yi ġaġek loḳ buk sënë, besu deneloḳ tepëḳ vu yi ggökin yah rë. ");
INSERT INTO bzh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Lob Yesu nër ġaġek vu alam yu böpata saga losho yi hur maluh lo bë, ");
INSERT INTO bzh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Alam-horek-yi los alam Parisai* deneloḳ yah Moses ben, ");
INSERT INTO bzh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","om ġaġek sën devo vu ham lo, og ham gwenġo beham sepa doḳ. Rëḳ nġaa sën denevonġ lo, og saga ham su sepa doḳ. In deneggooin horek nġahiseḳë raḳ rëḳ su denevonġ yoh vu rë. ");
INSERT INTO bzh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Deneduu nġaa maggin bedenetelë raḳ ya mehönon kwaj, rëḳ sir og nij nelël gesu denevër nemaj in bë dedoḳ vu sir teka rë. ");
INSERT INTO bzh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nġaa pin sën denevonġ lo, og sagaḳ denevonġ in bë alam degelë. Log denekevu Anutu yi horek la loḳ ḳapiya medebom loḳ ġobeng gedenevaḳu vil dabaj kesuu alam vahi gedenesemu hir röpröp nyë veteveḳ menare soo soo. ");
INSERT INTO bzh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Gahëj neving bë jaḳ na dega nos namuġin gëp nyëġ-nos-böp-yi, gedemedo lël mala gëp dub-supinsën-yi. ");
INSERT INTO bzh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Log ahëj neving bë alam debengwënġ vu sir bedegeḳo sir jaḳ doḳ alam tabaaḳ los denanër sir nabë Tatovaha. ");
INSERT INTO bzh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Rëḳ mu ham og alam su denanër ham nabë Tatovaha! Gaḳ yiḳ Mehö timu tu ham tatovaha, gaḳ ham pin arimin ham mu. ");
INSERT INTO bzh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Log ham su nanër ham mehöti vu dob sënë nabë ham Amamin yi. Gaḳ yiḳ ham Amamin timu nedo, yiḳ Yi sën nedo yaġek. ");
INSERT INTO bzh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Log su denanër ham nabë Alaj ham. Gaḳ yiḳ ham Alamin timu sënë, yiḳ Kerisi*. ");
INSERT INTO bzh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Rëḳ mu mehö sën bë kesuu ham benatu ham mehö böp lo, og natu ham hur rë. ");
INSERT INTO bzh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mehöti bë geḳo yö arë jaḳ, og rëḳ arë nama. Log mehöti bë dahun arë, og rëḳ arë böp jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Wöp-o! Ham alam-horek-yi los alam Parisai*-e! Gëpin ham! Ham alam kwamin luu! Ham nevehii Nyëġ-yaġek-yi yi veluung avi in mehönon pin! Log ham nġo su neloḳ ya rë, geham newërin alam sën denevonġ in bë dedoḳ na lo ving. ");
INSERT INTO bzh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Wöp-o! Ham alam-horek-yi galam Parisai*-e, gëpin ham! Ham alam kwamin luu! Ham neḳo avëh alov hir begganġ lu nġaa vër in sir, log ham nejom raḳ hus adingseḳë in bë kebu jaḳ ham nġaa nipaya saga. Om rëḳ ham gweḳo nipaya böpata doḳ nah nyëvewen. ");
INSERT INTO bzh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Wöp-o! Ham alam-horek-yi los alam Parisai*-e! Gëpin ham! Ham alam kwamin luu! Ham neḳo loḳ loo los dob pin in bë natöḳ vu mehöti begërin yi natu ham hur. Lob mehö nebë sënë netu ham hur ggovek, lob tum ham nevonġ yi netu mehö nipaya kesuu ham berëḳ na Nyëġ-nengwah-yi geving ham.” ");
INSERT INTO bzh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Wöp-o! Gëpin ham! Ham mehönon malamin ḳenod sën ham bë tato aggata vu mehönon! Ham nenër bë, ‘Bë mehöti nanër dub-vabuung-böp arë genanër yönon vavunë, og sagaḳ nġaa meris. Gaḳ mehöti bë nanër dub-vabuung-böp yi goor, genanër yönon vavunë, og su rëḳ gekuung jaḳ rë, gaḳ rëḳ gevonġ noh vu sën nër lo.’ ");
INSERT INTO bzh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ham mehönon kwamin ma, gemalamin ḳenod! Nġaa tena kesuu-a? Maḳ goor kesuu-a? Ma! Dub-vabuung-böp sën vonġ begoor netu vabuung lo, om saga kesuu! ");
INSERT INTO bzh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Log ham nenër bë, ‘Bë mehöti nanër jepö gëp dub-vabuung-böp genanër yönon vavune, og sagaḳ nġaa meris. Gaḳ bë nanër seriveng sën raḳ nedo jepö lo, genanër yönon vavunë, og su rëḳ gekuung jaḳ rë, gaḳ rëḳ gevonġ noh vu sën nër lo.’ ");
INSERT INTO bzh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ham mehönon malamin ḳenod! Nġaa tena kesuu-a? Maḳ seriveng kesuu-a? Ma! Jepö sën nevonġ beseriveng netu vabuung lo, om saga kesuu! ");
INSERT INTO bzh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Om mehöti bë nanër jepö genanër yönon vavunë, og nevonġ niwëëk vu yi ġaġek raḳ jepö los nġaa pin sën raḳ nedo lo ving. ");
INSERT INTO bzh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Gemehöti bë nanër dub-vabuung-böp genanër yönon vavunë, og nevonġ niwëëk vu yi ġaġek raḳ dub-vabuung ving Mehö sën nedo loḳ dub ayo lo. ");
INSERT INTO bzh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Log mehöti bë nanër yaġek genanër yönon vavunë, og nevonġ niwëëk vu yi raḳ Anutu yi sëa los Mehö sën raḳ nedo lo ving. ");
INSERT INTO bzh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Wöp-o! Ham alam-horek-yi los alam Parisai*! Gëpin ham! Ham alam kwamin luu! Ham nos pin vu huk saga sën ham neḳo anon ti ti ggëp sën netu nemadluho lo, beham netunġ netu seriveng vu Anutu. Ham netunġ nos böp los mahen mahen pin nebë jemejeng los yeseḳ gemajëj ving, rëḳ ham vuu horek yi ġaġek böp böp vahi pin ya. Sën nenër bë alam degevonġ nġaa niröp mu, los kwaj pesivin mehönon mededoḳ vu sir gayoj na timu vu Anutu lo. Horek sën nebë hil abo nġaa sën netu nemadluho natu seriveng vu Anutu lo, og hil su rëḳ ġevuu sënë na rë. Rëḳ mu mëm hil sepa doḳ nġaa böp sënë namuġin. ");
INSERT INTO bzh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ham mehönon malamin ḳenod sën ham bë tato aggata vu mehönon! Ham nesepa loḳ horek mahen mahen geham su nesepa loḳ horek böp böp rë, lob sënë nebë sën ham seruuin nġemeḳ vër in bël kul, geham num kamer los dahis ving bël loḳ ya ham ayomin. ");
INSERT INTO bzh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Wöp-o! Ham alam-horek-yi los alam Parisai*, gëpin ham! Ham alam kwamin luu! Ham neripek kap los perë navi mu, geham nesupin nġaa hodeḳ nipaya paya los nġaa jeggin jeggin loḳ ayo peggo. ");
INSERT INTO bzh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ham Parisai* malamin ḳenod! Ham jipek kap ayo namuġin rë, loḳ mëm navi rëḳ niveseek jaḳ geving. ");
INSERT INTO bzh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Wöp-o! Ham alam-horek-yi los alam Parisai*, gëpin ham! Ham alam kwamin luu! Ham nebë bedub avi sën dekevu heveḳ veroo raḳ. Hil halë ggëp vavunë bë malanġeri, rëḳ ayo peggo og heljënġ seḳëj los nġaa ningöhek pin pup beneggëp. ");
INSERT INTO bzh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lom ham nebë saga. Alam denelë ham navimin mu, lob denekuung bë ham nimin vesa. Rëḳ mu ġaġek kuungsën los nġaa nipaya pup ham ayomin.” ");
INSERT INTO bzh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Wöp-o! Ham alam-horek-yi los alam Parisai*, gëpin ham! Ham alam kwamin luu! Ham nelev begganġ-bedub-yi nivesa vesa raḳ nedo waaḳ sën denebë alam-denenër-ġaġek-ranġahsën seḳëj loḳ wirek lo, geham nevuneḳ vu alam-yohvu hir bedub. ");
INSERT INTO bzh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Geham nenër bë, ‘Bë he medo wirek doḳ he ḳenumin lo hir buk, og su rëḳ he doḳ vu sir bangis alam-denenër-ġaġek-ranġahsën sënë rë.’ ");
INSERT INTO bzh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Om saga og ham nġo nenër ham degwa ranġah bë alam sën denesis alam-denenër-ġaġek-ranġahsën bedenediiḳ lo hir mewis ham. ");
INSERT INTO bzh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Maam ham nġo tahu doḳ nah ham ḳenumin lo vahaj! ");
INSERT INTO bzh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ham nyël! Beggëv nalu ham! Ham su yoh vu bë rëḳ beya in Nyëġ-nengwah-yi rë! ");
INSERT INTO bzh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Om sa nanër vu ham nabë sëḳ ġevonġ alam-denenër-ġaġek-ranġahsën la, galam los kwaj nivesa la, galam-horek-yi la, benök deberup vu ham, lob ham rëḳ ngis sir la medenadiiḳ, geham ngis la jaḳ na ḳelepeḳo*, geham beek la doḳ ham dub-supinsën-yi. Log ham rëḳ juuk sir begwetii sir medoḳ vahaj medena nyëġ ngwë. ");
INSERT INTO bzh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Om rëḳ denanër alam sën denesis sir medenediiḳ vu nyëdahis lo, gesën vu buk agi pin degwa gëp vu ham nabë ham sis sir ving. Kë. Loḳ mehö-yohvu Abel, beyam verup loḳ Barakia nalu Sakaria sën desis mediiḳ loḳ dub-böp ayo vabuung los jepö vuheng atov lo, og nġaa pin sënë degwa rëḳ gëp vu ham. ");
INSERT INTO bzh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sa nanër vu ham yönon nabë nġaa pin sënë nyëvewen rëḳ natöḳ vu alam vu buk sënë.” ");
INSERT INTO bzh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusalem, Yerusalem! Honġ mehö ġenesis alam-denenër-ġaġek-ranġahsën medenediiḳ, log ġenetengwa Anutu-yi-alam sën nevonġ sir yök vu honġ lo raḳ ġelönġ medenediiḳ! Sa nehevonġ beron beron in bë ngupin nalum lo nabë sën ḳöḳrëëh ata nesupin nalu lo loḳ yah babu lo, rëḳ nim lël. ");
INSERT INTO bzh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Om ham gwenġo rë! Anutu vuu ham ya ggovek ya beham nyëġ rëḳ nabumeng na. ");
INSERT INTO bzh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Om sa nanër vu ham nabë ham su rëḳ malamin jaḳ sa gökin nah rë, rot bena berup doḳ buk sën ham nanër nabë: ‘Anutu gevonġ semusemu vu Mehö sën vonġ yam los niwëëk lo!’” ");
INSERT INTO bzh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu vu dub-vabuung-böp ayo beto meya, lob yi hur maluh deya vu yi bedetato dub-vabuung yi begganġ pin vu yi. ");
INSERT INTO bzh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Rëḳ nër yah vu sir bë, “Ham lë nġaa pin sënë? Sa nanër vu ham yönon nabë: Su rëḳ degönengin ġelönġ ti gejaḳ medo ngwë vavunë rë. Gaḳ rëḳ dekevoh pin bedegetë geto jeggin jeggin.” ");
INSERT INTO bzh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu ya nedo Ḳedu Ḳele-oliv, lob yi hur maluh meris yö deya vu yi bedenër bë, “Ġenanër vu he nabë ġaġek sën ġenër lo rëḳ anon jaḳ doḳ buk tena? Geva rëḳ tato vu he nabë vonġin ġeduḳ nom dob, log dob los yaġek hir buk nama na?” ");
INSERT INTO bzh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Lob Yesu nër yah vu sir bë, “Ham gweġin ham! ");
INSERT INTO bzh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","In rëḳ mehö la degekuungin ham. Alam nġahiseḳë rëḳ denam bedenanër sarëġ jaḳ nah sir nabë, ‘Yiḳ Kerisi* sa sënë!’ Lob rëḳ detetuhin alam nġahiseḳë medenah vu sir. ");
INSERT INTO bzh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Log ham rëḳ gwenġo beġö bengö, galam denanër jeggin jeggin nabë vonġin berup, og ham su newamin jaḳ! In nġaa nebë sënë yö rëḳ nam, gaḳ Buk-tamusëneḳ yö rëḳ nahën. ");
INSERT INTO bzh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Alam dob ngwë rëḳ dekedi belosho alam nyëġ ngwë dengis sir. Log mehö-los-bengö ngwë losho yi alam rëḳ dekedi belosho mehö-los-bengö ngwë losho yi alam dengis sir. Log meyip rëḳ natöḳ vu nyëġ vahi, gejemapi gee jaḳ dob la. ");
INSERT INTO bzh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nġaa pin sënë og yiḳ nebë nivanë sën nevonġ avëh muġin in bë degeḳo naluj lo. ");
INSERT INTO bzh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Doḳ buk sënë rëḳ alam degeḳo ham in debo vanë los maggin vu ham, gedengis ham nadiiḳ. Log alam pin rëḳ degelë ham paya in sa alam ham. ");
INSERT INTO bzh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lob rëḳ alam nġahiseḳë nij dëlin sa gedegërin sir nah, bedegelë sir paya, lob degetunġ hir alam doḳ na alam-beġö-yi nemaj. ");
INSERT INTO bzh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Lob alam-ġaġek-kuungsën nġahiseḳë rëḳ kedi degekuungin alam nġahiseḳë. ");
INSERT INTO bzh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nġaa nipaya nam meböpata jaḳ, lob alam nġahiseḳë su rëḳ ahëj geving sir rë. ");
INSERT INTO bzh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Gaḳ mehönon sën denajom sa ahon medemedo los nij wëëk rot menatöḳ na buk sën denadiiḳ lo, og rëḳ Anutu geḳo sir nah vu yi. ");
INSERT INTO bzh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Lob rëḳ alam denanër Bengö Nivesa jaḳ Anutu-yi-Nyëġ na menoh vu dob pin balam pin degenġo, log mëm yaġek los dob hir buk govek na.” ");
INSERT INTO bzh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Lob ham rëḳ gwelë nabë nġaa vabuung degwa nipaya sën mehö-nenër-ġaġek-ranġahsën Daniel nër wirek lo bare doḳ nyëġ vabuung Yerusalem begevonġ paya vu-bë mehöti natevin sënë, og kwa bo ġaġek sënë mejaḳ ni rë- ");
INSERT INTO bzh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","og mëm doḳ buk saga alam sën demedo distrik Yudea lo rëḳ debeya bedena los ḳedu. ");
INSERT INTO bzh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Lob mehöti bë jaḳ na sewah jaḳ yi begganġ yu tamanġsën vavunë megeḳo ayööng doḳ buk saga, og su rëḳ doḳ nah geḳo yi nġaa vu begganġ ayo rë, gaḳ rëḳ beya mena pevis. ");
INSERT INTO bzh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Log mehöti bë medo doḳ huk anon, og su rëḳ seröġ benah geḳo yi röpröp-ayööng-yi gëp begganġ rë, gaḳ rëḳ beya mena pevis. ");
INSERT INTO bzh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Gëp in avëh sën naluj nare loḳ ayoj lo, los sën nahën denevo rur vu naluj loḳ buk agi. ");
INSERT INTO bzh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ham najom jaḳ nabë nġaa sënë su natöḳ vu ham doḳ kwev-ayööng-nikul-yi, ma doḳ Buk-sewahsën-yi* rë. ");
INSERT INTO bzh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yönon, doḳ buk sënë og rëḳ maggin böpata rot. Maggin nebë sënë su neggëp wirek vu buk sën Anutu tunġ dob lo rë rot beverup gwëbeng sënë. Log su rëḳ maggin nabë sënë berup vu dob sënë gökin nah vu tamusën rë. ");
INSERT INTO bzh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Lob nabë Mehöböp su kwa bo nabë bepul buk saga dus rë, og mehöti su rëḳ medo vesa rë. Rëḳ mu kwa nevo yi alam sën ggooin sir raḳ lo, om rëḳ bepul buk los maggin saga dus. ");
INSERT INTO bzh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Doḳ buk sënë bë mehöti nanër vu ham nabë, ‘Ham lë! Yiḳ Kerisi* sënë!’, ma nanër nabë, ‘Yi sagu!’, og ham su gwevonġ geving hir ġaġek. ");
INSERT INTO bzh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Rëḳ Kerisi-kuungsën la los alam-ġaġek-kuungsën la rëḳ dekedi bedegevonġ huk los niwëëk aggagga gedegevonġ nġaa böp böp. Yönon, lob nabë deyoh vu, og rëḳ degeḳo alam sën Anutu ggooin sir raḳ lo nah vu sir. Rëḳ mu su deyoh vu rë. ");
INSERT INTO bzh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ham nġo? Senër sënë muġin vu ham! ");
INSERT INTO bzh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Om nabë denanër vu ham nabë, ‘Ham gwelë! Nedo nyëġ-yumeris saga!’, og ham su na sagu. Ma denanër nabë, ‘Ham gwelë! Vun yi menedo loḳ begganġ ayo!’, og ham su gwevonġ geving sir, ");
INSERT INTO bzh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","in Mehönon Nalu rëḳ nam nabë sën davës nevër ggëp nyëġ mala neverup beya netöḳ nyëġ mala nemasuseḳ lo, balam pin degelë. ");
INSERT INTO bzh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Vu nyëġ sën heljënġ deneggëp lo, og ḳadanii denesup sir ya in bë dega.” ");
INSERT INTO bzh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Maggin buk sënë yi govek na rë, log rëḳ pevis ‘benyëġ malaḳenu doḳ, gekwev su rëḳ natum rë, log betuheng rëḳ geto in yaġek. Genġaa los niwëëk pin vu yaġek rëḳ desasuḳin sir.’ ");
INSERT INTO bzh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Lob vu buk saga, mëm nġaa ti rëḳ berup gëp yaġek babu in bër ham kwamin beham jaḳ ni nabë Mehönon Nalu vonġin duḳ nom, lob rëḳ mehönon pin vu dob dengu medengis sir. Log rëḳ degelë Mehönon Nalu doḳ medo beggob yaġek yi, benam los niwëëk gevuneḳ vuneḳ yaġek yi malanġeri rot. ");
INSERT INTO bzh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lob avuuḳ rëḳ ngu bededun böpata, log gevonġ yi angër na dengupin alam sën yö ggooin sir raḳ tu yi alam lo noh vu nyëġ pin. Vu dob vuheng atov mena menoh vu dob nenga lubeluu.” ");
INSERT INTO bzh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ham kwamin bo jaḳ go* rë. Buk sën bë purpur berup ngu lo, og ham neraḳ ni bë go* vonġin nabunġ beham dev jaḳ na jök. ");
INSERT INTO bzh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Om nabë ham gwelë nġaa pin sënë anon jaḳ, og ham jaḳ ni nabë Mehönon Nalu yam dus raḳ benare aggata avi. ");
INSERT INTO bzh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sa nanër vu ham yönon nabë mehönon pin su rëḳ malaj nama na veröḳ yi rë, log nġaa pin sën agi rëḳ anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yaġek los dob rëḳ nama na, gaḳ sa ġaġek, og su rëḳ nama na rë.” ");
INSERT INTO bzh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Rëḳ mehöti su raḳ buk los hes mala saga ni rë. Angër vu yaġek su deraḳ ni rë. GeNalu su raḳ ni rë. Gaḳ Ama yö timu raḳ ni. ");
INSERT INTO bzh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mehönon Nalu bë nom, og alam rëḳ medo degevonġ nġaa nabë sën denevonġ loḳ Noa yi buk wirek lo. ");
INSERT INTO bzh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Wirek sën bël su vuuḳ rë lo, og mehönon medo denegga los denenum, gemaluh deneḳo venëj, gavëh deneraḳ reggaj rot, beya verup loḳ buk sën Noa loḳ ya yaġ ayo. ");
INSERT INTO bzh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Log alam saga su deraḳ ni bë nġaa ti vonġin natöḳ vu sir rë, log bël vuuḳ verup pevis berehöö sir pin. Lob buk sën Mehönon Nalu nom lo rëḳ nabë saga. ");
INSERT INTO bzh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Lob bë maluh luu demedo huk anon, og Anutu rëḳ geḳo ngwë na gegevuu ngwë bemedo. ");
INSERT INTO bzh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Lob bë avëh luu medo degebil nos, og Anutu rëḳ geḳo ngwë na gegevuu ngwë bemedo. ");
INSERT INTO bzh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Om ham medo malamin natum, in ham duġin buk sën ham Mehöböp rëḳ nom lo. ");
INSERT INTO bzh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ham kwamin bo nġaa sënë rë: Bë begganġ ala genġo hes mala sën mehö hodeḳ rëḳ nam doḳ buk begodeḳ yi nġaa lo, og su yoh vu bë rëḳ gelë mehö saga mu gedoḳ na yi begganġ ayo rë. ");
INSERT INTO bzh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nebë saga, om ham gwero ham bemedo, in Mehönon Nalu rëḳ nom doḳ buk ti, log ham duġin.” ");
INSERT INTO bzh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Maḳ hur ti tena nedo beyi mehö los kwa benevonġ yi huk niröp-a? Og mëm ala rëḳ gooin yi jaḳ in geġin yi hur vahi pin bebo nos gelek sir niröp doḳ buk sën degeḳo nos lo. ");
INSERT INTO bzh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Gevu tamusën nabë ala na genom berup, lob gelë nabë yi hur nevonġ huk yoh vu sën nër lo, og yi hur sënë rëḳ kwa vesa. ");
INSERT INTO bzh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Log sa nanër vu ham yönon nabë ala rëḳ gevonġ yi nġaa pin doḳ na nema in geġin. ");
INSERT INTO bzh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Gaḳ hur nipaya ti og rëḳ kwa bo doḳ ayo nabë, ‘Sa alaġ su yoh vu bë rëḳ nom pevis rë!’ ");
INSERT INTO bzh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Lob geveek hur-huk-yi vahi, gega los nanum geving alam sën denenum bël menġëës bedenekeyevin lo. ");
INSERT INTO bzh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Log ala rëḳ nom doḳ buk ti sën yi hur su neġin yi loḳ lo rë, gaḳ rëḳ nom doḳ hes mala ti sën yi duġin lo. ");
INSERT INTO bzh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Lob rëḳ ala ngis yi rot mebasap yi, log getë na medo geving alam kwaj luu, bedegeḳo nyëvewen gëp ti. Vu nyëġ sagu og rëḳ dengu medegeköö nyëj.” ");
INSERT INTO bzh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Log Yesu tateḳin vu sir bë, “Sën Nyëġ-yaġek-yi anon jaḳ lo, og yiḳ rëḳ nabë sën avëh avö nemadluho deḳo hir ram raḳ beya denebuu maluh sën nahën neḳo avëh lo ggëp aggata. ");
INSERT INTO bzh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lob sir nemadvahi kwaj ma, genemadvahi los kwaj. ");
INSERT INTO bzh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Avëh kwaj masën deḳo hir ram bedeyam, rëḳ su deḳo wël* sepa rë. ");
INSERT INTO bzh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Gaḳ avëh los kwaj deḳo hir ram raḳ bedetöö wël* la loḳ buayo ving bedeḳo sepa. ");
INSERT INTO bzh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Rëḳ mehö sën ḳo avëh lo su yam pevis rë, lob avëh pin malaj neggëp, lob deggëp yiing. ");
INSERT INTO bzh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lob buk vuheng raḳ loḳ ḳööḳ ti yam bë, ‘Mehö sën ḳo avëh lo yam raḳ. Ham na gwebuu yi vu aggata begweḳo menam!’ ");
INSERT INTO bzh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Lob avëh avö pin dekedi raḳ bedesemu loḳ hir ram. ");
INSERT INTO bzh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Lob avëh kwaj masën denër vu avëh los kwaj bë, ‘Ham bo hömin wël* teka vu he rë, in he hömin ram vonġin nakul!’ ");
INSERT INTO bzh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Rëḳ avëh los kwaj denër yah vu sir bë, ‘Ma! Wël* teka sënë su rëḳ noh vu hil pin rë. Om maam ham nġo na baġo hömin vu setuwa!’ ");
INSERT INTO bzh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Lob dekedi raḳ benahën medo deneyök aggata, log mehö sën ḳo avëh lo to. Lob avëh sën desemu sir ggovek medenedo lo deloḳ ya begganġ ayo ving yi in dega nos böp sën maluh lu venë denejom nemaj lo. Log devehii repinġ yah. ");
INSERT INTO bzh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Log avëh avö nemadvahi sën kwaj ma lo yom deverup lob denër bë, ‘Mehö böp, mehö böp! Ġetahinin repinġ in he!’ ");
INSERT INTO bzh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Rëḳ nër yah vu sir bë, ‘Sa nanër vu ham yönon nabë sa duġin ham!’ ");
INSERT INTO bzh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Om sa nanër vu ham nabë ham medo malamin natum, in ham su raḳ buk los hes mala ni rë.” ");
INSERT INTO bzh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Log sën Nyëġ-yaġek-yi anon jaḳ lo, og yiḳ nebë mehö ti neya vatëveḳ nyëġ ngwë, log supin yi hur bevo yi monë ggelek sir in degeġin. ");
INSERT INTO bzh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kwa vo hir huk los nij wëëk ti ti lo, lob vo ggelek loḳ yah sir. Ti ḳo K5000, gengwë ḳo K2000, log ngwë ḳo K1000. Vonġ nebë sënë log ya raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ya ggovek, log mehö sën ḳo K5000 lo pevis bevonġ huk baġosën raḳ, lob ḳo K5000 sevöḳ ya ving. ");
INSERT INTO bzh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Log mehö sën ḳo K2000 lo vonġ huk baġosën raḳ ving beḳo K2000 sevöḳ ya ving nebë saga. ");
INSERT INTO bzh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Gaḳ mehö sën ḳo K1000 lo, og ḳo monë sën ala vo vu yi lo beya melev söv gevun luḳ ya. ");
INSERT INTO bzh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nahub gebuk sën alaj yom verup lo, lob vonġin bë genġo monë sën vo vu sir lo. ");
INSERT INTO bzh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Lob mehö sën ḳo K5000 lo verup, lob ḳo K5000 ving K5000 sën ala vo vu yi lo, genër bë, ‘Mehö böp! Gwelë! Ġevo K5000 sënë vu sa, log sa hevonġ huk baġosën raḳ behaḳo K5000 sënë ving.’ ");
INSERT INTO bzh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Lob ala nër vu yi bë, ‘Honġ hur nivesa meġevonġ yoh vu. Ġevonġ nivesa rot! Ġeneġin nġaa mahen mahen pin nivesa nebë saga, om mëm sa ġevonġ honġ begweġin nġaa nġahiseḳë. Ġenam balu kwad vesa doḳ ti.’ ");
INSERT INTO bzh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Log mehö sën ḳo K2000 lo verup ving benër bë, ‘Mehö böp! Ġevo K2000 vu sa wirek, log sa hevonġ huk baġosën raḳ, lob sa haḳo K2000 ving.’ ");
INSERT INTO bzh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Lob ala nër vu yi bë, ‘Honġ hur nivesa, meġevonġ yoh vu! Ġeneġin nġaa teka teka nivesa nebë saga, om mëm sa ġevonġ honġ begweġin nġaa nġahiseḳë. Ġenam balu kwad vesa doḳ ti.’ ");
INSERT INTO bzh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Log tum mehö sën ḳo K1000 lo verup benër bë, ‘Mehö böp! Senġo raḳ nim ggovek ya bë honġ mehö los nim wëëk. Mehö ngwë denevaroh nos genġo ġeneḳo anon. Log mehö ngwë denevonġ huk, lob nġo ġeneḳo hir nyë-sevöḳsën. ");
INSERT INTO bzh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nebë saga om sën sehöneng, lob sevun honġ monë K1000 sënë menedo loḳ dob. Honġ nġaa sënë, om gweḳo nök!’ ");
INSERT INTO bzh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Rëḳ ala nër yah vu yi bë, ‘Honġ hur nipaya rot! Benim tebö ata! Maḳ yönon, ġeraḳ ni bë sa nehaḳo nos sën mehö ngwë denevaroh lo, gesa nehaḳo nyë-sevöḳsën raḳ sën mehönon ngwë denevonġ huk in lo? ");
INSERT INTO bzh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bë nabë saga, og gwetunġ sa monë na begganġ-monë-yi, in nabë senom berup nabë sënë, og sa ġaḳo sa nġaa los yi sevöḳsën geving. ");
INSERT INTO bzh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Om ham bo K1000 sënë vër in mehö sënë geham bo vu mehö sën ḳo la ving metu K10,000 lo. ");
INSERT INTO bzh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","In alam pin sën hir nġaa neggëp lo, og rëḳ degeḳo la geving, gehir nġaa la rëḳ berup geving mekesuu. Gaḳ mehöti sën yi nġaa su neggëp rë lo, og mahen teka sën neggëp vu yi lo rëḳ nama na veröḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Lob ham gwetë hur sehëb sënë doḳ na nyëġ malaḳenu sën alam denesu los deneköö nyëj lo.’” ");
INSERT INTO bzh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nahub rëḳ Mehönon Nalu nam los niwëëk gevuneḳ vuneḳ yaġek-yi, gangër pin denam geving yi, og vu buk sënë rëḳ jaḳ medo yi sëa malanġeri los vuneḳ vuneḳ yaġek-yi. ");
INSERT INTO bzh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Log mehönon pin rëḳ dengupin sir na debare mala. Lob rëḳ basuh sir na yu luu nabë sën sipsip ala ggooin sipsip raḳ yu ngwë, gememëk raḳ yu ngwë. ");
INSERT INTO bzh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Rëḳ gevonġ sipsip na nema vesa, gememëk na nema ḳëj. ");
INSERT INTO bzh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nabë sënë lob Mehö-los-bengö rëḳ nanër vu alam sën denare nema vesa lo nabë, ‘Ham nam! Ham sën Amaġ vonġ semusemu vu ham lo. Ham doḳ na nyëġ sën tonġin vu ham wirek loḳ buk sën netunġ yaġek los dob meneggëp lo. ");
INSERT INTO bzh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","In wirek sediiḳahëġ, rëḳ ham vo nos vu sa. Sayoġ vev in bël kul, rëḳ ham vo bël kul mesenum. Sa mehö nyëġ ngwë rëḳ ham ḳo sa ya ham begganġ. ");
INSERT INTO bzh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ham lë sa naviġ meris, lob ham vo tob vu sa. Sa niġ raḳ, rëḳ ham ġin sa nivesa. Sa nado ḳarabus, rëḳ ham yök lë sa kesii.’ ");
INSERT INTO bzh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Loḳ tum alam yohvu saga rëḳ dedoḳ tepëḳ nah vu yi nabë, ‘Mehöböp! He halë loḳ buk tena bë ġediiḳahëm lob he vo nos vu honġ-a? Log he halë bë ayom vev in bël loḳ buk tena lob he vo vu honġ-a? ");
INSERT INTO bzh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Log he halë bë honġ mehö nyëġ ngwë loḳ buk tena, lob he haḳo honġ ya he begganġ-a? Log ġenare navim meris loḳ buk tena lob he vo tob vu honġ-a? ");
INSERT INTO bzh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Gehe halë bë nim raḳ ma ġenedo ḳarabus loḳ buk tena, lob he yök halë honġ kesii-a?’ ");
INSERT INTO bzh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Lob Mehö-los-bengö rëḳ nanër vu sir nabë, ‘Sa nanër vu ham yönon nabë nġaa sën ham nevonġ vu arig lo nij paya paya sën su los bengöj vu dob rë lo, og nġaa pin sënë ham nevonġ vu sa.’ ");
INSERT INTO bzh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Log rëḳ nanër alam sën demedo nema ḳëj lo nabë, ‘Ham alam nimin paya! Ham su bare sa malaġ. Ham na medoḳ na nyëġ sën devonġ vu Satan losho yi angër lo. Sën nengwah netum yoh vu buk los buk lo. ");
INSERT INTO bzh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","In wirek sediiḳahëġ, rëḳ ham su vo nos vu sa rë. Sayoġ vev in bël kul, rëḳ ham su vo bël kul vu sa rë. ");
INSERT INTO bzh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Sa mehö nyëġ ngwë, rëḳ ham su ḳo sa ya ham begganġ rë. Sa niġ raḳ los sa nado ḳarabus, rëḳ ham su yam lë sa kesii rë.’ ");
INSERT INTO bzh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Lob rëḳ denanër nah vu yi nabë, ‘Mehöböp! Vu buk tena he halë bë ġediiḳahëm, ma ayom vev in bël, ma honġ mehö nyëġ ngwë, ma navim meris, ma nim raḳ los ġenedo ḳarabus rëḳ he su halë honġ nivesa rë?’ ");
INSERT INTO bzh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Loḳ rëḳ nanër nah vu sir nabë, ‘Sa nanër vu ham yönon nabë nġaa sën ham nehulin in arig lo nij paya paya vu dob lo, og ham nehulin nġaa pin sënë in sa ving.’ ");
INSERT INTO bzh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Lob alam sënë rëḳ denatöḳ vu nipaya nyëvewen doḳ nah degwata los degwata. Gaḳ alam yohvu rëḳ demedo malaj-tumsën degwata los degwata.” ");
INSERT INTO bzh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu nër ġaġek pin sënë ggovek ya, log mëm nër vu yi hur maluh bë, ");
INSERT INTO bzh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ham raḳ ni bë buk luu mu nahën lob Buk-ggöksën-yi* berup, lob mëm rëḳ denanër Mehönon Nalu ranġah bedengis yi jaḳ ḳelepeḳo*.” ");
INSERT INTO bzh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Vu buk sënë alam-deneḳo-seriveng hir ggev los alam teta desupin sir raḳ alam-deneḳo-seriveng hir ggev böp Kayapas yi begganġ, ");
INSERT INTO bzh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","bedejoo ġaġek bë denadëġek bedenajom Yesu ahon gedengis yi menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Rëḳ denër bë, “Hil su ġevonġ doḳ buk nos yi sënë in alam rëḳ degevonġ dedun.” ");
INSERT INTO bzh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu nedo loḳ mehö sevuuḳnyë Simon yi begganġ vu Betania. ");
INSERT INTO bzh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Medo negga nos, lob avëh ti ḳo nġaa reggu nivesa loḳ buayo ġelönġ veroo sën denenër arë nebë alabasta* lo ti, beya keseh raḳ Yesu yu. Alam Yuda debaġo nġaa reggu nivesa sënë raḳ monë böpata bedenerikin raḳ heljënġ. ");
INSERT INTO bzh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Rëḳ yi hur maluh delë nġaa sënë, lob ahëj sengën gedenër bë, “Nevasap nġaa reggu nivesa sënë in va? ");
INSERT INTO bzh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bë hil ġevonġ balam debaġo, og hil rëḳ ġaḳo monë böpata jaḳ, lob hil adoḳ vu alam-ḳupeḳ-masën jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Rëḳ Yesu raḳ hir ġaġek sënë ni, lob nër vu sir bë, “Ham nër avëh in va? Yö semu sa raḳ nġaa nivesa! ");
INSERT INTO bzh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Alam-ḳupeḳ-masën rëḳ demedo geving ham gesu rëḳ nama na rë. Gaḳ saḳ su rëḳ medo hus ading geving ham rë. ");
INSERT INTO bzh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Avëh keseh nġaa reggu nivesa sënë raḳ sa vorot in gero sa naviġ namuġin in sëḳ nadiiḳ mededev sa. ");
INSERT INTO bzh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sa nanër vu ham yönon nabë rëḳ denanër Bengö Nivesa ranġah na menoh vu dob pin bedenanër nġaa sën avëh vonġ vu sa agi geving, in alam pin degenġo bekwaj bo.” ");
INSERT INTO bzh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Lob yi hur maluh nemadluho-bevidek-luu ti sën arë nebë Yudas Iskariot lo ya vu alam-deneḳo-seriveng hir ggev, ");
INSERT INTO bzh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","beloḳ tepëḳ in sir bë, “Ham rëḳ bo va vu sa log mëm sa ġevonġ Yesu doḳ na ham nemamin-a?” Lom devo monë seriva mehödahis ti benemadluho vu yi. ");
INSERT INTO bzh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Lob vu buk saga Yudas medo mekwa nesero buk los aggata in bë gevonġ Yesu doḳ na nemaj. ");
INSERT INTO bzh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lob buk vabuung sën alam Yuda denegga brët sën yiist* nema in lo yi buk muġinsën verup, lob yi hur maluh deya vu yi bedenër bë, “He na ġero nyëġ vu tena in ġegwa nos los reggu ggöksën-yi dok-a?” ");
INSERT INTO bzh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Lob nër vu sir bë, “Ham na nyëġ böp Yerusalem beham na vu mehö sën lo, beham nanër vu yi nabë, ‘Tatovaha nër bë, “Sa buk dus raḳ, om sa bë ġa nos los reggu ggöksën-yi geving sa hur maluh jaḳ honġ begganġ.” ’” ");
INSERT INTO bzh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Lob yi hur maluh devonġ yoh vu sën Yesu nër vu sir lo, bedesemu nos los reggu ggöksën-yi loḳ. ");
INSERT INTO bzh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Loḳ sehuksën lob medo negga nos los reggu ving yi hur maluh nemadluho-bevidek-luu. ");
INSERT INTO bzh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Medo denegga, lob nër vu sir bë, “Sa nanër vu ham yönon nabë: Ham sënë ti rëḳ gevonġ sa doḳ na alam Yuda nemaj.” ");
INSERT INTO bzh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lob ayoj maggin rot, gesir ti ti deloḳ tepëḳ in yi bë, “Mehöböp, maḳ sa?” ");
INSERT INTO bzh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Rëḳ nër yah vu sir bë, “Mehö sën nema loḳ ya ġabum in nos ving sa lo rëḳ gevonġ sa doḳ na alam sën denelë sa paya lo nemaj. ");
INSERT INTO bzh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kë’! Mehönon Nalu rëḳ nadiiḳ nabë sën dekevu meneggëp loḳ Anutu-yi-ḳapiya lo. Rëḳ mu gëpin mehö sën rëḳ nanër Mehönon Nalu ranġah vu alam bedengis yi lo, ko nabë ata su geḳo yi!” ");
INSERT INTO bzh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Log Yudas mehö sën rëḳ nanër yi ranġah lo, nër ving bë, “Tatovaha, maḳ sa?” Rëḳ Yesu nër yah vu yi bë, “Yiḳ nġo ġenër yoh vu!” ");
INSERT INTO bzh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Medo denegga nos los reggu, lob Yesu ḳo brët gejom raḳ in los kwa vesa ya vu Anutu, log debu mevo ggelek yoh vu yi hur maluh pin genër bë, “Ham gweḳo nök begwa! Sa reggos sënë!” ");
INSERT INTO bzh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Log ḳo wain kap ti raḳ, gejom raḳ in los kwa vesa ya vu Anutu gevo vu sir genër bë, “Ham pin nanum doḳ sënë! ");
INSERT INTO bzh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Sa ḳöḳ sënë in tato sa ġaġek mewis sën sejoo in doḳ vu ham lo nabë rëḳ anon jaḳ! Sa ḳeseh in alam nġahiseḳë in bë dahun hir nġaa nipaya na. ");
INSERT INTO bzh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sa nanër vu ham nabë sa su rëḳ nanum wain nabë sënë gökin nah rë. Rot bena berup doḳ buk sën hil nanum wain agga ngwë doḳ ti doḳ Amaġ yi Nyëġ.” ");
INSERT INTO bzh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Log devonġ raro ti beggovek, log to deyah dobnë bedeya Ḳedu Ḳele-oliv. ");
INSERT INTO bzh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Lob Yesu nër vu sir bë, “Ham pin rëḳ gwevuu sa geham beya mena in sa pehi buk sënë. In dekevu wirek meneggëp loḳ Anutu-yi-ḳapiya nebë: ‘Sa Anutu sëḳ ngis sipsip alaj, log sipsip lo degevuu talë medena jeggin jeggin.’ ");
INSERT INTO bzh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Om rëḳ nabë saga, loḳ sëḳ ḳedi jaḳ nah gökin, lob sëḳ namuġin mena distrik Galilea, geham tamuin sa.” ");
INSERT INTO bzh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Lob Pita nër yah vu yi bë, “Sir pin sënë og maḳ rëḳ degevuu honġ bedebeya medena, gaḳ saḳ su rëḳ ġevonġ nabë sënë rë!” ");
INSERT INTO bzh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Lom Yesu nër yah vu yi bë, “Sa nanër vu honġ yönon nabë: Pehi sënë og ḳöḳrëëh su rëḳ ngu rë, log rëḳ ġedah sa vun natu beron löö!” ");
INSERT INTO bzh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Rëḳ Pita nër yah vu yi bë, “Seyoh vu bë sëḳ nadiiḳ geving honġ, gaḳ sa su rëḳ dah honġ vun rë, gerëḳ nama veröḳ yi!” Lob yi hur maluh pin denër nebë saga. ");
INSERT INTO bzh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Lob Yesu ya nyëġ sën denenër arë nebë Getsemane lo, ving yi hur maluh lo, lob nër vu sir bë, “Ham medo sënë gesena najom jaḳ vu sagu!” ");
INSERT INTO bzh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Lob ḳo Pita ving Sebedi nalu luho. Lob ayo maggin rot gekwa ketuin yi. ");
INSERT INTO bzh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Lob nër vu sir bë, “Sayoġ maggin rot bevonġin bë sa nadiiḳ. Om melöö naḳööḳ medo sënë bemedo malamin natum beġadu sa. ");
INSERT INTO bzh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Log tah ya teka, lob petev meneggëp dob, log jom raḳ meketaġ bë, “O Amaġ! Bë yoh vu og gweḳo nġaa maggin sënë bër in sa! Rëḳ mu su ġesepa doḳ sa ġaġek, gaḳ nġo kwam!” ");
INSERT INTO bzh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Log yah to vu lööho, rëḳ lë gedeneggëp yiing. Lob loḳ tepëḳ vu Pita bë, “Nebë va? Melöö su yoh vu bë rëḳ medo malamin natum dus ti geving sa rë? ");
INSERT INTO bzh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Melöö malamin medo natum bemelöö najom jaḳ, in nġaa ti su kepë ham! Ëë-ë yönon! Ham ayomin niyes rëḳ mu navimin ni tebö!” ");
INSERT INTO bzh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Lob yah nejom raḳ beron netu luu bë, “Oo Amaġ! Bë nġaa maggin sënë natöḳ vu sa gesu yoh vu bë noh nenga in sa rë, og ggovek, sa ġevonġ noh vu kwam.” ");
INSERT INTO bzh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Loḳ yom to ggökin, rëḳ lë bë deneggëp yiing yah, in malaj neggëp lo. ");
INSERT INTO bzh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Lob denedo geyah meya nejom raḳ netu beron löö, lob yiḳ nër ġaġek lo ggökin yah. ");
INSERT INTO bzh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Log yah to vu yi hur maluh benër vu sir bë, “Ham sewah benġo nahën newëp-a? Ham lë! Buk sën Anutu tunġ in debo Mehönon Nalu doḳ na alam nij paya nemaj lo verup ggovek ya, ");
INSERT INTO bzh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","om ham kwedi jaḳ behil ana. Ham lë? Mehö sën gevonġ sa doḳ na nemaj lo yam dus raḳ!” ");
INSERT INTO bzh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu nahën medo nenër bë saga, log Yudas verup. Yi sën hur maluh nemadluho-mevidek-luu lo ti, lob ḳo alam yu böpata ti medeyam los paëp yu anil gebeġö. Alam-deneḳo-seriveng hir ggev los Israel hir alam-teta devonġ sir yam. ");
INSERT INTO bzh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Lob mehö sën bë tato Yesu ranġah vu sir lo, nër vu sir vorot bë, “Sëḳ tato Yesu vu ham nabë sënë, nabë sa ġemul* mehöti, og ham najom yi ahon.” ");
INSERT INTO bzh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Lob Yudas ya verup sesor meya vu Yesu pevis benër bë, “Buk Tatovaha!” Log mul* yi. ");
INSERT INTO bzh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Rëḳ Yesu nër yah vu yi bë, “Sa mehö! Nġaa sën ġeyam in bë gwevonġ lo, og gwevonġ pevis!” Lob deyam dus bedejom Yesu ahon. ");
INSERT INTO bzh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Rëḳ alam sën denare ving Yesu lo ti nema loḳ yah dadii yi paëp-yu-anil vër in newis, besap alam-deneḳo-seriveng hir ggev böp yi hur ti nenga ris vahi ya. ");
INSERT INTO bzh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Rëḳ Yesu nër vu bë, “Ġejöp honġ paëp doḳ nah newis. In alam sën denevonġ beġö lo, og mehö ngwë rëḳ dengis sir doḳ nah nyëvewen medenadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bë sa ḳetaġ na vu Amaġ nabë gevonġ yi angër nġahiseḳë rot denam pevis mededoḳ vu sa, og ġekuung bë su rëḳ gevonġ nam rë? ");
INSERT INTO bzh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Rëḳ bë sa ġevonġ nabë sënë, og su rëḳ Anutu yi ġaġek anon jaḳ rë. Sën dekevu meneggëp loḳ Anutu-yi-ḳapiya bë nġaa nabë sënë rëḳ natöḳ vu sa lo.” ");
INSERT INTO bzh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Log Yesu nër vu alam sënë bë, “Ham yam in bë sero mehö-beġö-hodeḳ-yi om sën ham ḳo paëp-yu-anil los beġö meyam in bë najom ahon-a? Sa netateḳin ġaġek vu ham loḳ dub-vabuung-böp yoh vu buk, rëḳ ham su nejom sa ahon rë? ");
INSERT INTO bzh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Rëḳ mu nġaa pin sënë netöḳ vu sa in ġaġek sën alam-denenër-ġaġek-ranġahsën dekevu meneggëp loḳ Anutu-yi-ḳapiya lo anon jaḳ.” Nebë saga lob yi hur maluh pin devuu yi gedeveya medeya. ");
INSERT INTO bzh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Dejom Yesu ahon bedeḳo ya alam-deneḳo-seriveng hir ggev böp Kayapas yi begganġ. Galam-horek-yi los alam-teta desupin sir bedenedo ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Lom Pita tamuin sir beneya, rëḳ nevun yi geneyam ggëp ading. Lob ya beloḳ ya alam-deneḳo-seriveng hir ggev böp yi begganġ tete ayo, beya nare telig ving ahëvavu sën denare medenemalajin nyëġ lo, in bë jaḳ ġaġek lo degwa ni. ");
INSERT INTO bzh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Lob alam-deneḳo-seriveng hir ggev los kaunsor pin denesero mehö la in bë denanër ġaġek kuungsën jaḳ Yesu in lob dengis yi menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lob alam nġahiseḳë denër ġaġek kuungsën raḳ yi, rëḳ su detöḳ vu degwa ti in bë dengis yi menadiiḳ rë. Loḳ mëm mehö luu deverup, ");
INSERT INTO bzh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","lob luho denër bë, “Mehö sënë nër bë, ‘Seyoh vu bë sa ḳevoh Anutu yi dub-vabuung-böp na gesedev nah buk löö mu!’” ");
INSERT INTO bzh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Lob alam-deneḳo-seriveng hir ggev böp kedi nare geloḳ tepëḳ vu Yesu bë, “Su ġenenër ġaġek ti yom rë? Denenër ġaġek va sën raḳ honġ-ë?” ");
INSERT INTO bzh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Rëḳ Yesu su nër ġaġek ti yah rë. Loḳ alam-deneḳo-seriveng hir ggev böp loḳ tepëḳ vu yi ggökin bë, “Seloḳ tepëḳ in honġ yönon raḳ Anutu mala-tumsën arë, om ġenanër vu he nabë honġ Kerisi*, Anutu nalu honġ ma ma?” ");
INSERT INTO bzh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Loḳ Yesu nër yah bë, “Ġenër yoh vu! Rëḳ mu sa nanër vu ham nabë: Nahub rëḳ ham gwelë Mehönon Nalu gemedo gëp Mehö Niwëëk nema vesa, gerëḳ jaḳ medo beggob vu yaġek benom!” ");
INSERT INTO bzh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Lob alam-deneḳo-seriveng hir ggev böp kweeḳ yi röpröp ading getahi bë, “Ḳo yi raḳ besevöḳ Anutu! Ma hil medo nesero mehönon sën denanër ġaġek jaḳ yi lo in va? Ham nġo bë ḳo yi raḳ besevöḳ Anutu! ");
INSERT INTO bzh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Om ham kwamin nevo bë?” Lob denër yah niwëëk vu yi bë, “Vonġ paya om nadiiḳ!” ");
INSERT INTO bzh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Log depesuv nyëj ḳos raḳ mala gedepëëng yi, gela depetap nenga, ");
INSERT INTO bzh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","gedenër bë, “Honġ Kerisi*? Om ġenanër ranġah vu he nabë re sis honġ-a?” ");
INSERT INTO bzh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Log Pita nedo raḳ telig, lob Kayapas yi hur avëh ti yam dus vu yi benër bë, “Honġ sënëḳ melu Yesu sën vu Galilea lo nesepa ham.” ");
INSERT INTO bzh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Rëḳ Pita lah yi vun raḳ alam pin malaj bë, “Sa duġin ġaġek sën ġenër aga!” ");
INSERT INTO bzh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Log to meya nare ya tete avi, lob hur avëh ngwë lë yi ggökin, lob nër vu alam sën denedo lo bë, “Mehö sënë nedo ving Yesu Nasaret!” ");
INSERT INTO bzh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Rëḳ Pita lah yi vun ggökin bë, “Yönon vavunë, sa duġin mehö sënë!” ");
INSERT INTO bzh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Lob nedo teka, loḳ alam sën denare dus vu yi yam denër vu bë, “Yönon rot, alam sagu hir ti sën honġ agi. In ayem yö tato honġ ranġah bë honġ Galilea ti!” ");
INSERT INTO bzh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Lob Pita du ġaġek in yi benër niwëëk rot neggëp Anutu mala bë, “Yönon vavunë, sa duġin mehö sënë! Bë sa ġekuung jaḳ og Anutu ngis sa mesa nadiiḳ!” Nër ggovek log ḳöḳrëëh su. ");
INSERT INTO bzh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Lob Pita kwa vo yah ġaġek sën Yesu nër lo bë, “Ḳöḳrëëh su rëḳ ngu rë, log rëḳ ġedah sa vun natu beron löö.” Lob Pita to meyah dobnë beya mesu böpata rot. ");
INSERT INTO bzh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Monbuk anon lob Israel hir alam-deneḳo-seriveng hir ggev los alam-teta lo pin devengwënġ raḳ Yesu ggovek bë dengis yi menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Log deduu yi gedeḳo meya devonġ loḳ ya kiap böp Pilatus nema. ");
INSERT INTO bzh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Lob Yudas, mehö sën nër Yesu ranġah lo, lë bë dejoo ġaġek bë Yesu nadiiḳ, lob yom ayo maggin vu yi, lom ḳo monë seriva mehödahis benemadluho sën lo yah vu alam-deneḳo-seriveng hir ggev los alam-teta, ");
INSERT INTO bzh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","genër bë, “Sa hevonġ nġaa nipaya! Senër mehö sën nipaya su neggëp vu yi rë lo ranġah, bevonġin dengis yi menadiiḳ.” Rëḳ denër yah bë, “Su he nġaa rë, gaḳ nġo honġ nġaa!” ");
INSERT INTO bzh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Lob Yudas pengah monë sënë ya dub-vabuung-böp ayo, log to meya vaḳu kwa bediiḳ. ");
INSERT INTO bzh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Lob alam-deneḳo-seriveng hir ggev depatu monë seriva sënë raḳ, rëḳ denër bë, “Monë hel ḳöḳ sënë, om hil su ayoh vu bë ġetunġ na geving Anutu yi monë seriveng rë!” ");
INSERT INTO bzh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Lob denër ġaġek ti venuh, lob debaġo dob len ti vu mehö sën nesemu dëg lu nġaa raḳ nġaġek lo raḳ monë sënë, in bë dedev alam-yu-ngwë hir heljënġ doḳ. ");
INSERT INTO bzh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Om sën denër dob len ti sënë arë nebë Dob-hel-ḳöḳ, meneggëp nebë saga begwëbeng. ");
INSERT INTO bzh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lob ġaġek sën Anutu vonġ verup mehö-nenër-ġaġek-ranġahsën Yeremia avi wirek lo anon raḳ. Sën nër bë, “Alam Israel denër vorot bë rëḳ degevonġ monë seriva mehödahis ti benemadluho in mehö los arë sënë, lob deḳo monë sën deggooin raḳ in bë debaġo yi jaḳ agi, ");
INSERT INTO bzh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bedebaġo mehö sën nesemu dëg lu nġaa raḳ nġaġek lo yi dob len ti raḳ, yoh vu ġaġek sën Anutu nër vu sa lo.” ");
INSERT INTO bzh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Devarah Yesu ya kiap böp mala, lob loḳ tepëḳ in yi bë, “Alam Yuda hir mehö-los-bengö honġ-a?” Loḳ Yesu nër yah bë, “Ġenër ya meyoh vu!” ");
INSERT INTO bzh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lob alam-deneḳo-seriveng hir ggev los alam-teta denër ġaġek raḳ yi, rëḳ su nër ġaġek ti loḳ yah rë. ");
INSERT INTO bzh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nebë saga lom Pilatus nër vu yi bë, “Maḳ su genġo ġaġek pin sën denër raḳ honġ-ë rë?” ");
INSERT INTO bzh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Rëḳ Yesu su nër ġaġek ti loḳ yah rë, lom kiap böp kwa ya nġahi. ");
INSERT INTO bzh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Alam Yuda hir Buk-ggöksën-yi* lob hir aggata neggëp nebë sënë: Neyoh vu nġebek pin, og kiap böp nevonġ alam ḳarabus ti ti vër. Bë alam detahi mehöti arë, og Pilatus nelëëin mehö timu saga neyah vu sir. ");
INSERT INTO bzh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Vu buk saga mehöti nedo ḳarabus, arë nebë Barabas, galam pin denġo bengö bë mehö nevun alam kwaj. ");
INSERT INTO bzh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Lob alam nġahiseḳë yam desupin sir, lob Pilatus loḳ tepëḳ in sir bë, “Ham vonġin mehö ngwë tena bë sa ġaḳo yi bër nök vu ham-a? Barabas, ma Yesu sën denenër arë nebë Kerisi* lo?” ");
INSERT INTO bzh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","In yö raḳ ni rot bë alam-deneḳo-seriveng ahëj nevonġ medenelë Yesu paya, besën devo yi loḳ ya nema. ");
INSERT INTO bzh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Lob Pilatus raḳ nedo yi sëa-ġaġek-yi in bë genġo yi ġaġek, rëḳ venë vonġ ġaġek ya vu yi bë, “Su gwevonġ nġaa ti vu mehö niröp saga, in sa halë pesepsën raḳ yi gwëbeng, lob sa newaġ raḳ rot.” ");
INSERT INTO bzh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Loḳ alam-deneḳo-seriveng hir ggev los alam-teta deloḳ alam ahëj bedetahi ya vu Pilatus bë dëëin Barabas bër vu sir gengis Yesu menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Rëḳ kiap böp Pilatus loḳ tepëḳ yah vu sir bë, “Ham vonġin mehö luu sënë ngwë tena bë sa ġaḳo bër nök vu ham-a?” Loḳ denër yah bë, “Barabas!” ");
INSERT INTO bzh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Rëḳ Pilatus loḳ tepëḳ yah vu sir ggökin bë, “Om sëḳ ġevonġ nabë va vu Yesu, mehö sën denenër yi nebë Kerisi* lo?” Lom detahi yah bë, “Ġengis yi jaḳ na ḳelepeḳo*!” ");
INSERT INTO bzh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Loḳ Pilatus loḳ tepëḳ bë, “In va? Mehö sënë vonġ va paya?” Rëḳ detahi niwëëk rot bë, “Ġengis yi jaḳ na ḳelepeḳo*!” ");
INSERT INTO bzh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lom Pilatus raḳ ni bë su debë nengaj vu yi ġaġek rë, gaḳ newaj raḳ gebeġö böpata vonġin berup. Om ḳo bël beripek nema raḳ alam pin malaj genër bë, “Bë ham ngis mehö niröp sënë menadiiḳ, og su degwa neggëp vu sa rë! Gaḳ ham nġo ham nġaa!” ");
INSERT INTO bzh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Lob alam pin detahi yah bë, “Degwa yö gëp vu he los he mewis!” ");
INSERT INTO bzh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Lob Pilatus lëëin Barabas yah vu sir. Log nër balam-beġö-yi deveek Yesu gedeḳo medeya in dengis yi jaḳ na ḳelepeḳo*. ");
INSERT INTO bzh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kiap böp yi alam-beġö-yi deḳo Yesu loḳ ya kiap böp yi begganġ sën denenër arë nebë Prëtoryam lo, log desupin alam-beġö-yi yu böpata pin ya detetup yi. ");
INSERT INTO bzh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Lob dekah yi tob vër, gederöp röpröp ḳöḳ ti loḳ yah yi medetahu mehö-los-bengö raḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Debuu aggis niggin ggin tahu alam-los-bengöj hir madub gedetunġ raḳ yu, gedevo nġesinġ loḳ nema vesa, log deneyun lusej vu yi gedepelë yi bë, “Alam Yuda hir mehö-los-bengö honġ, mehö böp los ġayeheng!” ");
INSERT INTO bzh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Gedepesuv nyëj ḳos raḳ yi, gedevo nġesinġ vër bedesis yu raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Depelë yi ggovek, log dekah tob sënë vër in yi, gederöp yö yi tob loḳ yah yi, gedeḳo yi bedeya in dengis yi jaḳ na ḳelepeḳo*. ");
INSERT INTO bzh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Deya lob detöḳ vu alam Kurene ti, arë nebë Simon. Lob denër niwëëk bë, “Kwerë ḳelepeḳo*!” ");
INSERT INTO bzh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Lob ya deverup ḳedu ti arë nebë Golgota. Arë sën degwa nebë ‘Nyëġ-yuseḳë’. ");
INSERT INTO bzh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Lob desarömin marasin nimenġëës ving wain bedevo vu Yesu in bë nanum. Lob tep beseggi rëḳ nilëlin gesu num rë. ");
INSERT INTO bzh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Desis yi raḳ ya ḳelepeḳo* ggovek, log yom detë ġelönġ mahen teka la in bë gooin sir ti ti jaḳ bedegeḳo yi tob. ");
INSERT INTO bzh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ggovek log medo denemalajin yi. ");
INSERT INTO bzh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Lob dekevu yi ġaġek sën mehönon denër raḳ yi lo raḳ neggëp ḳelepeḳo* yu nebë: ");
INSERT INTO bzh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Log desis alam-beġö-hodeḳ luu raḳ ḳelepeḳo* ving. Ngwë nare ggëp nema vesa gengwë nare ggëp nema ḳëj. ");
INSERT INTO bzh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Lob alam sën deneyah gedeneyom lo denenër pelë raḳ yi gedenevarah nemaj vu yi ");
INSERT INTO bzh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","gedenenër bë, “Honġeḳ-o! Ġenër bë kwevoh Anutu yi dub-vabuung-böp na, geġedev nah buk löö mu lo, om nġo ġedoḳ vu honġ! Bë Anutu Nalu honġ, og nġo ġeduḳ vu ḳelepeḳo* meġenam!” ");
INSERT INTO bzh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Log alam deneḳo-seriveng hir ggev losho alam-horek-yi ving alam-teta denenër pelë raḳ yi nebë saga ving. ");
INSERT INTO bzh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Denenër bë, “Neloḳ vu alam, gaḳ su yoh vu bë yö doḳ vu yi rë! Alam Israel hir mehö-los-bengö! Nabë dëëin ḳelepeḳo* geduḳ menam, og mëm rëḳ hil ġevonġ geving yi. ");
INSERT INTO bzh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nevonġ ving Anutu? Om nabë Anutu ahë ving yi yönon, og nam doḳ vu yi! In nër bë Anutu Nalu yi.” ");
INSERT INTO bzh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Lob alam-beġö-hodeḳ luu sën desis luho nare Yesu vahi vahi lo denër pelë raḳ Yesu ving nebë saga. ");
INSERT INTO bzh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Log hes vuheng raḳ, log malaḳenu loḳ beyoh vu dob pin beya meto 3 krök sehuksën. ");
INSERT INTO bzh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lob dus raḳ in bë 3 krök lob Yesu nġeeḳ böpata bë, “Eli, Eli, lama sabaktani?” Sënë degwa nebë, “O sa Anutu, sa Anutu, nebë va sën gwevuu sa ya-ë?” ");
INSERT INTO bzh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lob alam sën denare dus vu yi lo vahi denġo lob denër bë, “Mehö sënë netahi Elia!” ");
INSERT INTO bzh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Log pevis besir ti seröġ beya meḳo nġaa ayo sovinsën sën nedo loḳ loo lo ti, bedaġoo luḳ wain ahëggin sën arë nebë vinegga lo geduu ya vetii nġesinġ, gevo ya verup loḳ Yesu avi in bë sesuvin. ");
INSERT INTO bzh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Rëḳ sir vahi denër bë, “Ġenaḳööḳ gehil ġalë rë, nabë Elia rëḳ nam doḳ vu yi ma rëḳ nama?” ");
INSERT INTO bzh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Rëḳ Yesu nġeeḳ böpata ggökin log lëëin anon ya. ");
INSERT INTO bzh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lob pevis betob böp sën neruu dub-vabuung-böp ayo vabuung lo kweeḳ raḳ luu ggëp vavu beya metöḳ ahu. Log dob ggee geġelönġ böp böp deġo. ");
INSERT INTO bzh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gebedub avi tateḳin yi gAnutu-yi-alam sën dediiḳ ggovek lo nġahiseḳë vesaj loḳ, bedekedi raḳ los navij dahis. ");
INSERT INTO bzh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Dekedi raḳ loḳ mëm Yesu kedi raḳ yah ggökin, log mëm to deyam medeloḳ ya nyëġ vabuung Yerusalem. Balam nġahiseḳë delë sir. ");
INSERT INTO bzh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Log mehö neġin alam-beġö-yi ving yi alam-beġö-yi sën medo deneġin Yesu lo denġo gejemapi ggee, gedelë nġaa vahi nebë saga, lob ḳenuj verup, gedenër bë, “Yönon rot! Mehö sënëḳ Anutu nalu yi!” ");
INSERT INTO bzh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Lob avëh sën denetamuin Yesu vu Galilea bedeyam in bë dedoḳ vu yi lo nġahiseḳë denare ading teka bevare denelë. ");
INSERT INTO bzh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Sir ti arë nebë Maria vu Magdala. Log Maria ngwë sën Yakobus lu Yosep ataj. Log avëh ti sën Sebedi nalu luho ataj. ");
INSERT INTO bzh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Log sehuk luḳ lob mehö-los-bengö-ggoreksën ti vu Arimatea beverup. Arë nebë Yosep. Yiḳ Yesu yi hur maluh ti yi ving, bemedo nesepa loḳ Yesu yi ġaġek. ");
INSERT INTO bzh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ya verup beloḳ tepëḳ vu Pilatus bë geḳo Yesu nihel. Lob Pilatus nër bedevo vu yi. ");
INSERT INTO bzh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Lob Yosep ḳo nihel bebom loḳ tob veroo mewis ti. ");
INSERT INTO bzh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Log ya mebë loḳ ya yö yi bedub mewis sën nahën denesap loḳ ġelönġ meris lo. Log tetolin ġelönġ böpata ti ggërin avi. Vonġ ggovek log ya. ");
INSERT INTO bzh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Lob Maria vu Magdala luho arë ngwë denedo bemedo malaj neya waaḳ bedub saga. ");
INSERT INTO bzh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Buk sën alam Yuda denero sir in bë dega nos Buk-ggöksën-yi* lo ggovek ya geheng to, loḳ mëm alam-deneḳo-seriveng los alam Parisai* yah denër vu Pilatus bë, ");
INSERT INTO bzh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Mehö böp! He kwamin nevo ġaġek sën mehö ġaġek kuungsën saga nedo mala vesa genër lo bë, ‘Buk löö na govek rë, loḳ sëḳ ḳedi jaḳ nah!’ ");
INSERT INTO bzh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Om ġenanër bedegeġin bedub avi noh vu buk löö. In rëḳ yi hur maluh degodeḳ yi na gedenanër vu alam nabë kedi raḳ ggökin vu bedub. Lob ġaġek kuungsën vu tamusën rëḳ kesuu sën muġinsën.” ");
INSERT INTO bzh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Lom Pilatus nër vu sir bë, “Ham gweḳo alam-beġö-yi la in degeġin, beham behii bedub avi niwëëk ata!” ");
INSERT INTO bzh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Lob ya dekepa bedub avi niwëëk gedejegwi ḳele niḳegwi* teka raḳ ġelönġ nenga ya vetii waaḳ avi ving, gedetunġ alam-beġö-yi medo deneġin. ");
INSERT INTO bzh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lob Buk-sewahsën-yi* ggovek ya, geheng to loḳ Soda monbuk, lob Maria vu Magdala luho Maria ngwë kedi deya in bë degelë bedub. ");
INSERT INTO bzh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lob pevis bejemapi ggee böpata, in Mehöböp yi angër ti vu yaġek meluḳ yam tetolin ġelönġ vër in waaḳ avi geraḳ nedo. ");
INSERT INTO bzh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mala netum nebë davës, geyi tob veroo meris nebë beggob. ");
INSERT INTO bzh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Alam-beġö-yi sën deneġin bedub lo delë, lom ḳenuj verup in yi, benij loḳ ti nebë alam-diiḳsën. ");
INSERT INTO bzh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Rëḳ angër nër vu avëh luho bë, “Melu su ġöneng! Seraḳ ni bë melu yam nesero Yesu, mehö sën desis yi raḳ ḳelepeḳo* lo. ");
INSERT INTO bzh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Rëḳ mu su neggëp sënë rë! Gaḳ kedi raḳ yoh vu sën nër wirek lo! Om melu nam gwelë nyëġ sën neggëp loḳ veseveng lo. ");
INSERT INTO bzh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Log melu nah mena pevis, bena nanër vu yi hur maluh lo nabë kedi raḳ ggökin vu bedub bemuġin meya distrik Galilea, geham rëḳ na gwelë yi vu sagu. Yiḳ senër vu meluu ggovek saga!” ");
INSERT INTO bzh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Lob avëh luho deggöneng rot, rëḳ kwaj vesa böpata, lob pevis beluho deseröġ bedeneyah in bë denanër vu yi hur maluh lo. ");
INSERT INTO bzh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Loḳ Yesu töḳ vu luho vu aggata benër bë, “Monbuk!” Lob luho deya dus vu bedepetev medeneggëp gedejom loḳ vaha medeḳo arë raḳ. ");
INSERT INTO bzh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Lob Yesu nër vu luho bë, “Melu su ġöneng! Melu nah mena nanër vu arig lo nabë dena distrik Galilea, lob rëḳ degelë sa gëp sagu.” ");
INSERT INTO bzh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Avëh luho nahën deneyök aggata galam-beġö-yi sën deneġin bedub lo deyah medeya nyëġ böp Yerusalem pevis bedenër nġaa pin sën töḳ vu sir ggëp bedub lo vu alam-deneḳo-seriveng hir ggev. ");
INSERT INTO bzh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Lob alam-deneḳo-seriveng hir ggev ving alam-teta bedevengwënġ raḳ ġaġek ti, lob devo monë nġahiseḳë vu alam-beġö-yi saga, ");
INSERT INTO bzh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","gedevo ḳoo vu sir bë, “Ham na nanër nabë sënë, ‘Yi hur maluh deyam buk, gehe hëp yiing, log deggodeḳ ya.’ ");
INSERT INTO bzh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Lob nabë kiap böp genġo ġaġek sënë, og he rëḳ semu ġaġek vu yi, lob su rëḳ gevonġ ġaġek vu ham rë.” ");
INSERT INTO bzh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nebë saga lob alam-beġö-yi deḳo monë geya devonġ yoh vu ġaġek sën alam Yuda hir ggev denër vu sir lo. Lob ġaġek sënë ya meyoh vu alam Yuda pin, lob nahën denesepa loḳ hir ġaġek sënë bedenenër nebë sënë rot begwëbeng. ");
INSERT INTO bzh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Log hur maluh nemadluho-bevidek-ti lo detetuu aggata medeya Galilea, beya deverup ḳedu sën Yesu nër tato vu sir lo. ");
INSERT INTO bzh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Lob delë Yesu, lob depetev medeneggëp loḳ vaha gedeḳo arë raḳ, rëḳ sir vahi kwaj luu luu. ");
INSERT INTO bzh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Lob Yesu yam dus benër ġaġek vu sir bë, “Anutu vo niwëëk pin vu sa bë sa ġeġin yaġek los dob. ");
INSERT INTO bzh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Om ham na gwevonġ mehönon pin denatu sa hur maluh los avëh. Lob ham jipek sir jaḳ Ama arë, geNalu arë, bAnon Vabuung arë. ");
INSERT INTO bzh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Log ham tahu sir doḳ ġaġek pin sën sa netateḳin vu ham lo in desepa doḳ. Ham gwenġo rë! Serëḳ medo geving ham noh vu buk pin rot bedob los yaġek hir buk govek na.” ");
INSERT INTO bzh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Anutu nalu Yesu Kerisi yi Bengö Nivesa degwa muġinsën: ");
INSERT INTO bzh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nebë sën mehö-nenër-ġaġek-ranġahsën Yesaya kevu loḳ Anutu-yi-ḳapiya wirek meneggëp nebë: “Gwenġo rë! Sëḳ ġevonġ sa hur ti namuġin mena negetonġin honġ aggata.” ");
INSERT INTO bzh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Gemehöti aye neraḳ loḳ nyëġ-yumeris bë, ‘Ham bolinin Mehöböp yi aggata meham sesor megëp niröp.’” ");
INSERT INTO bzh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nebë sënë, loḳ Mehö-neripek-alam Jon yam vu nyëġ-yumeris meyam nenër ġaġek ranġah nebë, “Ham gwevuu ham nġaa nipaya na, geham gwërin ham nom vu Anutu, lom mëm sejipek ham jaḳ bël, gAnutu rëḳ dahun ham nġaa nipaya na.” ");
INSERT INTO bzh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nër bë saga, lob alam vu distrik Yudea los alam Yerusalem pin deneya vu yi. Denenër hir nġaa nipaya pin ranġah vu, log mëm neripek sir luḳ bël Yordan. ");
INSERT INTO bzh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon röp yi röpröp ading sën denevasu raḳ kamer niviis lo, log nevëh ḳabi neggëp balo, genegga sepaaḳ los nenum beggoh netu yi nos. ");
INSERT INTO bzh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Lob yam nenër Anutu yi ġaġek ranġah nebë, “Mehö los niwëëk ti kesuu sa rëḳ tamuin sa menam. Gesa su mehö niġ vesa yoh vu in bë sa natu yi hur ti meḳevelekin vaha suu rë. ");
INSERT INTO bzh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Sën seripek ham lo, og senġo hetunġ bël meris mu raḳ ham, gaḳ mëm yi sën rëḳ nam getunġ Anon Vabuung jaḳ ham.” ");
INSERT INTO bzh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Vu buk saga Yesu vu Nasaret ggëp distrik Galilea meya vu Jon, beJon ripek yi luḳ bël Yordan. ");
INSERT INTO bzh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ripek, log Yesu nahën neraḳ yom roneḳ, loḳ lë geyaġek tateḳin ya gAnon Vabuung ni nebë soḳ nuung ti meto megwanġ ya Yesu ayo. ");
INSERT INTO bzh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Log ġaġek ti yam vu yaġek bë, “Sa naluġ honġ! Sahëġ neving honġ besa halë honġ nivesa.” ");
INSERT INTO bzh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ggovek saga lob Anon Vabuung ggee loḳ ayo bë na nyëġ-yumeris ti. ");
INSERT INTO bzh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ya nyëġ-yumeris ti sën saġ hir nyëġ lo beya nedo buk mehödahis luu, geSatan ya medo nepelëpin yi vu sagu. Lom Satan vuu yi ya gemëm angër yam deneloḳ vu yi. ");
INSERT INTO bzh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Deduu Mehö-neripek-alam Jon beya nedo ḳarabus, loḳ mëm Yesu ya distrik Galilea menër Anutu yi Bengö Nivesa ranġah nebë, ");
INSERT INTO bzh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Anutu tunġ buk vorot lob töḳ yam, om gwëbeng sënë Anutu-yi-nyëġ vonġin anon jaḳ, om ham gwevuu ham nġaa nipaya na, geham gwërin ham nom vu Anutu, beham gwevonġ geving Anutu yi Bengö Nivesa sënë.” ");
INSERT INTO bzh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Buk ti lob Yesu medo nesepa loḳ nġaggee böp Galilea nenga, lob töḳ vu Simon lu ari Andreas geluho medo denetë leḳ luḳ ya nġaggee in bë degeḳo ġël, in yiḳ luho yö hir huk sagi. ");
INSERT INTO bzh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Lob Yesu nër vu luho bë, “Melu nam sepa sa natu sa hur besa tahu meluu in gweḳo mehönon denam vu sa nabë sën melu neḳo ġël gwëbeng agi lo.” ");
INSERT INTO bzh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lob pevis beluho devuu leḳ ya geya desepa yi melööho deya. ");
INSERT INTO bzh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Log lööho deya dus ti beya deverup, loḳ Yesu lë Sebedi nalu luho, Yakobus lu ari Jon, geluho raḳ denedo yaġ ti medeneduu hir leḳ vepulsën yah. Lë luho lob pevis metahi luho. ");
INSERT INTO bzh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Lom luho devuu amaj Sebedi losho yi hur-huk-yi lo beraḳ denedo yaġ geluho ya desepa Yesu medeya. ");
INSERT INTO bzh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sir sënë ya detöḳ ya Kapernaum, log yiḳ Yudea hir Buk-sewahsën-yi* ti, lom Yesu luḳ ya dub-supinsën-yi menetateḳin ġaġek vu alam sën denedo loḳ lo. ");
INSERT INTO bzh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nenër ġaġek vu sir, lob ḳenuj ya rot in su nenër nebë mehö-horek-yi rë, gaḳ nenër ġaġek nebë mehö los niwëëk ti. ");
INSERT INTO bzh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nebë saga, lom mehöti to nare loḳ dub ayo gememö nipaya ti nedo loḳ ayo. ");
INSERT INTO bzh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Lom nġeeḳ bë, “Yesu vu Nasaret! Bë gwevonġ va vu he? Maḳ ġeyam in bë kwevoh he? Seraḳ nim nebë Anutu yi Mehö Vabuung honġ!” ");
INSERT INTO bzh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Loḳ Yesu petupek raḳ bë, “Ayem nama! Ġegweto ġena in mehö saga!” ");
INSERT INTO bzh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Lob memö sesö yi loḳ mehö lo ayo genġeeḳ böpata, log vuu yi geto meya. ");
INSERT INTO bzh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lob alam pin saga delëk anon, gedeneloḳ tepëḳ vu sir bë, “Va ti sënë? Maḳ ġaġek mewis ma va? Mehö sënë nenër vu memö nijpaya lo ving nebë yi mehö los niwëëk ti, om nengaj yes geto deneya!” ");
INSERT INTO bzh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Lom pevis medenenër Yesu arë ya meyoh vu distrik Galilea pin. ");
INSERT INTO bzh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ggovek saga log tur vu dub-supinsën-yi ayo, lob lööho Jon lu Yakobus ya deraḳ ya Simon Pita luho Andreas hir begganġ. ");
INSERT INTO bzh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lob pevis medenër Simon Pita ggen avëh vu bë nivanë rot meneggëp. ");
INSERT INTO bzh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Lob mëm Yesu ya mejom loḳ nema beḳo yi raḳ, lom nikul ya pevis, lob mëm neyeh nos bevo vu sir. ");
INSERT INTO bzh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ggovek log sehuksën behes luḳ ya, lob deneḳo alam nijraḳsën meya deverup vu Yesu, medeneḳo alam sën memö denegwanġ ya ayoj ving. ");
INSERT INTO bzh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Alam pin vu begganġ-bu ti saga ya denekebu sir loḳ veluung avi. ");
INSERT INTO bzh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Loḳ mëm Yesu nevonġ alam nġahiseḳë sën niraḳsën aggagga nevonġ sir agi benijvesa neraḳ, genetii memö nġahiseḳë to deneya in mehönon. Log nërin memö pin bë su denanër yi ranġah, in deneraḳ ni bë Anutu Nalu yi. ");
INSERT INTO bzh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nyëġ yö nahën gesu heng rë, log Yesu kedi raḳ buk meya nedo nyëġ-yumeris tahsën in bë najom jaḳ na vu Anutu. ");
INSERT INTO bzh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Loḳ Simon losho alam sën denedo ving yi lo ya desero ");
INSERT INTO bzh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","bedetöḳ raḳ lob denër vu bë, “Alam pin medo denesero honġ!” ");
INSERT INTO bzh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Loḳ Yesu nër vu sir bë, “Hil ana begganġ bu böp böp sën nedo dus agi in sa nanër Anutu yi ġaġek ranġah vu sir geving. In seyam in bë sa ġevonġ nabë sënë.” ");
INSERT INTO bzh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Lom mëm neḳo loḳ distrik Galilea beneluḳ ya dub-supinsën-yi pin menenër Anutu yi ġaġek ranġah vu alam pin. Genetii memö to deneya in mehönon ving. ");
INSERT INTO bzh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Buk ti lob mehöti los nisevuuḳ ya vu yi metunġ lus luḳ geketaġ vu yi bë, “Nabë ahëm geving, og ġeyoh vu bë gwevonġ besa niġ veseek jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Lob Yesu kwa pesivin yi mebë nema raḳ yi genër vu yi bë, “Sa ahëġ ving! Om nim veseek jaḳ!” ");
INSERT INTO bzh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Lob yiḳ sevuuḳ saga mehor ya pevis. ");
INSERT INTO bzh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Lob Yesu vo ḳooin niwëëk gevonġ yi ya pevis. Nër vu yi nebë, “Gweġin honġ besu ġena ġenanër nġaa sënë vu mehö la. ");
INSERT INTO bzh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Gaḳ mëm ġena ġetato honġ vu mehö-neḳo-seriveng gegwetunġ seriveng in nim veseek raḳ. Noh vu sën Moses nër wirek bë hil ġevonġ lo, in alam pin dejaḳ ni nabë nim veseek raḳ.” ");
INSERT INTO bzh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Rëḳ ma gemehö lo to meya meya medo neturin yi ġaġek sënë ranġah vu mehönon pin medenġo, lob Yesu su yoh vu bë na tato yi ranġah vu begganġ-bu ti rë gema. Geyö ya nedo tahsën loḳ mëm alam yoh vu nyëġ pin medo deneya vu yi. ");
INSERT INTO bzh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Buk la ggovek ya, loḳ Yesu yah meya nedo Kapernaum, loḳ alam denġo bë yah nedo ben. ");
INSERT INTO bzh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Lob desup sir ya beyi begganġ pup. Gedeggërin veluung avi ving, belen ti su ggëp netöḳ rë. GeYesu nenër Anutu yi ġaġek nivesa ranġah vu sir. ");
INSERT INTO bzh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Medo nenër vu sir log deḳo mehö seḳë selönġin ti medeverup. Sir lubeluu devaḳu medeyam vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Deraḳ vu mehönon pin saga besu deyoh vu bë degeto denam Yesu mala rë, lom deraḳ ya begganġ vavunë medekehe begganġ demi valeḳ sën Yesu nare lo. Dekehe ggovek ya geggëp netöḳ, log mëm deseyesin reek los mehö seḳë selönġinsën lo to meluḳ ya begganġ ayo. ");
INSERT INTO bzh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nebë sënë lob Yesu lë bë ayoj neya timu vu yi, lom nër vu mehö seḳë selönġinsën bë, “Naluġ-e! Sa dahun honġ nġaa nipaya ya!” ");
INSERT INTO bzh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Log alam-horek-yi la loḳ denedo begganġ ayo sën ving Yesu bekwaj nevo loḳ ayoj bë, ");
INSERT INTO bzh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nenër ġaġek va ti sënë? Ḳo yi raḳ besevöḳ Anutu! Mehöti su yoh vu bë dahun nġaa nipaya na rë, gaḳ Anutu yö timu yoh vu!” ");
INSERT INTO bzh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Loḳ Yesu raḳ ni loḳ ayo bë kwaj nevo nebë sënë, lom nër vu sir bë, “Ham ayomin neya nġahi nebë sënë in va? ");
INSERT INTO bzh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ham kwamin nevo ġaġek sën senër agi bë, ‘Sa dahun honġ nġaa nipaya ya’ lo bë anon ma, in re yoh vu bë gelë nabë dahun ya yönon-a? Rëḳ mu mëm nabë sa nanër vu yi nabë, ‘Kwedi jaḳ meġena’, og mëm ham rëḳ jaḳ ni nabë sa nanër ġaġek los anon. ");
INSERT INTO bzh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Rëḳ sa bë ham jaḳ ni nabë sa Mehönon Nalu sën seyoh vu bë dahun nġaa nipaya na gëp dob, om...” log peggirin menër vu mehö seḳë selönġinsën bë, ");
INSERT INTO bzh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Sa nanër nök vu honġ nabë: Kwedi gweḳo honġ reek jaḳ meġenah böm!” ");
INSERT INTO bzh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lob kedi raḳ pevis beḳo yi reek raḳ meya, gesir pin vare denelë. Delë, bavij töḳ rot gedeḳo Anutu arë raḳ medenenër bë, “Hil su halë nġaa ti nëbë sënë wirek rë!” ");
INSERT INTO bzh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ggovek log Yesu to meyah dobnë meyah meya nġaggee böp Galilea nenga, loḳ mëm alam pin deneya vu yi benetateḳin ġaġek vu sir. ");
INSERT INTO bzh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ggovek, log ya raḳ meya meto metöḳ vu Alpeus nalu Levi geloḳ nedo begganġ-takës-yi, lob nër vu yi bë, “Ġenam medo ġesepa sa!” Lob Levi kedi raḳ mesepa yi meya. ");
INSERT INTO bzh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Loḳ Yesu losho alam nġahiseḳë sën denetamuin yi lo ya denegga nos loḳ Levi ben. Alam-deneḳo-takës* losho alam nijpaya sën denekeyëh horek lo geyi hur maluh, sir pin ya denegga nos ving yi. ");
INSERT INTO bzh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Loḳ tum Parisai* hir alam-horek-yi lo delë bë losho alam nijpaya sën galam-deneḳo-takës* lo denegga nos loḳ ti, lob deloḳ tepëḳ vu yi hur maluh bë, “Nebë va sën negga nos ving alam-deneḳo-takës* losho alam nijpaya agi-ë?” ");
INSERT INTO bzh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Rëḳ Yesu nġo lob nër vu sir bë, “Alam nijvesa su deneya vu dokta rë, gaḳ alam nijraḳsën mu yö deneya vu. Om sesu yam in bë tahi alam yohvu rë; gaḳ mu seyam in bë tahi alam sën nġaa nipaya neggëp vu sir lo.” ");
INSERT INTO bzh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Log buk ngwë, lob Mehö-neripek-alam Jon yi hur maluh losho alam Parisai* pin devonġin bë degeḳo Anutu arë jaḳ, lom ayej ggërin nos besu degga rë, loḳ tum mehö la ya deloḳ tepëḳ vu Yesu bë, “Jon yi hur maluh losho Parisai* hir hur maluh ayej neggërin nos besu denegga rë, log tum honġ hur maluh denegga nos gesu ayej neggërin rë in va?” ");
INSERT INTO bzh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Lom Yesu peggirin ġaġek raḳ mehö sën neḳo avëh lo, benër yah vu sir bë, “Ham kwamin bo rë, nabë mehöti medo geving yi alam geluho avëh ti denajom nemaj! Bë nabë sënë og yi alam sënë su deyoh vu bë rëḳ ayej gërin nos rë! Gaḳ mu mehöti sën bë geḳo avëh lo nedo ving sir, om rëḳ kwaj nivesa medega nos gesu deyoh vu bë rëḳ ayej gërin rë. ");
INSERT INTO bzh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Rëḳ mëm buk sën debo mehö sën geḳo avëh lo vër besu medo geving yi alam rë, og mëm yi alam rëḳ ayoj maggin bayej gërin nos doḳ buk saga.” ");
INSERT INTO bzh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Log Yesu nër vu sir ving bë, “Mehöti su neḳo tob mewis sën su deneripek rë lo len ti menepeḳa tob muġeng sën nekweeḳ lo len raḳ rë. Nabë gevonġ nabë sënë, og rëḳ dejipek, lob tob mewis sënë najul menom getob muġeng sënë rëḳ nakweeḳ gökin melen böpata rot. ");
INSERT INTO bzh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Gemehöti su netöö wain* mewis loḳ ya memëk-navi muġeng rë. Gaḳ bë mehöti gevonġ nabë sënë, og rëḳ wain ngol navi mebepul, gewain keseh geto mena bebasap wain los memëk-navi doḳ ti. Gaḳ denetöö wain mewis loḳ ya memëk-navi mewis mu!” ");
INSERT INTO bzh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lob Buk-sewahsën-yi* ti, lob Yesu yi hur maluh deyoh ya huk wit* ti, lob yi hur maluh derur anon mededah. ");
INSERT INTO bzh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Lom Parisai* lo delë medeloḳ tepëḳ vu yi nebë, “Gwelë! Nebë va sën honġ hur maluh dekeyëh horek Buk-sewahsën-yi-ë?” ");
INSERT INTO bzh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Rëḳ Yesu loḳ tepëḳ yah vu sir bë, “Maḳ ham su tevin ġaġek raḳ nġaa sën Davit vonġ wirek lo rë? Nos main mediiḳahë, ");
INSERT INTO bzh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","lob losho alam sën denesepa yi lo deloḳ ya Anutu yi dub-vabuung. Alam-deneḳo-seriveng hir ggev Abiatar neġin Anutu yi dub-vabuung loḳ buk saga, lob deluḳ ya medegga brët vabuung sën denetunġ netu seriveng benedo ggëp Anutu mala lo. Nos sën alam meris su deyoh vu bë dega rë lo, gaḳ alam-deneḳo-seriveng mu yö denegga. Rëḳ mëm mehö meris sën Davit gga, gevo vu alam meris sën denesepa yi lo bedegga ving. (Rëḳ su devonġ paya rë, gaḳ dediiḳahëj om degga, lob yiḳ sa hur maluh sënë nebë).” ");
INSERT INTO bzh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Loḳ Yesu nër vu sir ggökin yah nebë, “Anutu su tunġ Buk-sewahsën-yi* in bë deġinengin mehönon rë, gaḳ tunġ in bë doḳ vu sir. ");
INSERT INTO bzh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Om Mehönon Nalu tu Buk-sewahsën-yi* ala.” ");
INSERT INTO bzh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Buk ngwë rë, lob luḳ yah dub-supinsën-yi ggök yahin, galam sën loḳ denedo dub ayo lo ti seḳë belooin. ");
INSERT INTO bzh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Log alam vahi sën denelë Yesu paya lo medo malaj nesepa yi, in bë degelë nabë rëḳ gevonġ benema nivesa jaḳ doḳ Buk-sewahsën-yi* ma rëḳ nama. Nabë gevonġ, og mëm denanër ġaġek jaḳ yi nabë keyëh horek. ");
INSERT INTO bzh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Lom Yesu nër vu mehöti sën seḳë belooin lo bë, “Kwedi jaḳ meġenam ġebare doḳ he malamin vuheng atov!” ");
INSERT INTO bzh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Lob loḳ tepëḳ vu sir pin bë, “Maḳ hil horek nër bë hil ġevonġ nġaa nivesa doḳ Buk-sewahsën-yi*, ma hil ġevonġ nġaa nipaya? Maḳ nër bë hil adoḳ vu mehönon in demedo vesaj, ma hil nid dël jaḳ sir in denadiiḳ?” Denġo rëḳ ayej ma rot geti su vengwënġ rë. ");
INSERT INTO bzh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Lom Yesu vare mala neḳo loḳ menelë sir gahë sengën vu sir gayo maggin rot vu sir, in su kwaj nevonġin mehöti sënë rë, gayoj niwëëk. Loḳ nër vu mehö seḳë belooin bë, “Ġetelo seḳëm nam!” Lom mehö lo telo nema ya, lom nivesa raḳ pevis. ");
INSERT INTO bzh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Rëḳ Parisai* lo deluḳ yom dobnë, lob losho Herot* yi alam desap sir medenesero aggata in bë dengis Yesu menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lob Yesu losho yi hur maluh detah sir meya denedo nġaggee böp nenga, lom alam nġahiseḳë rot vu distrik Galilea denetamuin sir. Galam vu distrik Yudea ving. ");
INSERT INTO bzh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Galam vu nyëġ böp Yerusalem, galam vu distrik Idumea, galam vu bël Yordan vahi-yi. Galam sën denedo dus vu nyëġ böp Ture los Sidon, besir nġahiseḳë deyam. Sir pin denenġo nġaa pin sën nevonġ lo, lom deneya vu yi. ");
INSERT INTO bzh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Lom nër vu yi hur maluh bë na degeḳo yaġ ti, in alam nġahiseḳë deneyam rot om rëḳ degeving in yi. ");
INSERT INTO bzh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","In vonġ sir nġahiseḳë benijvesa raḳ, om alam nijraḳsën denepeḳa raḳ yi rot in bë degebë nemaj jaḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Log memö sën denegwanġ ya mehönon medenevonġ lo, denelë yi lom denepetev medeneggëp loḳ vaha gedenenġeeḳ bë, “Anutu nalu honġ!” ");
INSERT INTO bzh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lob nevo ḳoo vu sir niwëëk bë su denanër yi ranġah. ");
INSERT INTO bzh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Loḳ tum ya nyëġ ti los ḳedu betahi alam sën kwa nevo sir lo bë dena vu yi. ");
INSERT INTO bzh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Log ggooin maluh nemadluho-bevidek-luu raḳ in bë desepa yi geyö rëḳ gevonġ sir mena denanër yi ġaġek ranġah. ");
INSERT INTO bzh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Vo niwëëk vu sir ving in degetii memö sën denegwanġ ya mehönon ayoj lo geto dena. ");
INSERT INTO bzh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ggooin Simon, lob nër ggev ngwë raḳ nebë Pita. ");
INSERT INTO bzh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Lob ggooin Yakobus luho ari Jon sën Sebedi nalu luho raḳ, benër ggev ngwë raḳ luho nebë Boanerges, (degwa nebë luho nij wëëk nebë vaḳuvek). ");
INSERT INTO bzh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Lob ggooin Andreas luho Pilip ga, Bartolomai luho Matai, geTomas ga, Alpeus nalu Yakobus, geTadaius, geSimon sën yi mehö-neruuk-alam-Rom ti, ");
INSERT INTO bzh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","geYudas Iskariot ving, sën rëḳ nanër Yesu ranġah lo. ");
INSERT INTO bzh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu yah meya ben lob mehönon nġahiseḳë yom desupin sir ggökin yah, lom Yesu losho yi hur maluh su deyoh vu bë dega nos rë, in mehönon nġahiseḳë medeggërin sir. ");
INSERT INTO bzh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Loḳ Yesu yi alam denedo bej gedenġo bë alam deggërin sir rot, lob denër bë, “Maḳ yu vonġ paya!” Lom deya in bë denajom yi nah. ");
INSERT INTO bzh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Log alam-horek-yi la deyam vu Yerusalem medenenër bë, “Memö alaj Belsebul* nevonġ yi!” Gedenenër ving bë, “Netii memö to deneya raḳ memö alaj niwëëk!” ");
INSERT INTO bzh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Loḳ mëm Yesu supin sir yam dus getateḳin vu sir bë, “Satan rëḳ getii yö yi hur memö geto dena nabë va? ");
INSERT INTO bzh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nabë alam dob timu debasuh sir bedengis sir, og alam sënë su rëḳ demedo los nij wëëk rë. ");
INSERT INTO bzh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Log nabë alam degwa timu debasuh sir medengis sir, og alam sënë su rëḳ demedo los nij wëëk rë. ");
INSERT INTO bzh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Om nabë Satan losho yi alam debasuh sir medengis sir, og su rëḳ demedo rë, gaḳ rëḳ malaj nama na. ");
INSERT INTO bzh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Log hil su ayoh vu bë aġök Mehö Nipaya los niwëëk saga ben vavunë gabo yi nġaa vër rë. Mëm nabë hil naduu Mehö los niwëëk sënë ahon, og mëm hil rëḳ abo yi nġaa pin vër menama na veröḳ yi.” ");
INSERT INTO bzh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Alam sënë denenër bë Yesu nevonġ nġaa nebë sënë in memö nipaya ti nevonġ yi, loḳ Yesu nër yah vu sir bë, “Sa nanër vu ham yönon nabë Anutu yoh vu bë dahun mehönon hir nġaa nipaya pin na, nġaa nipaya los ġaġek pelësën sën denanër jaḳ Anutu lo. Gaḳ nabë mehöti nanër ġaġek pelësën jaḳ Anon Vabuung (nabë yiḳ sëëḳ memö nipaya ti), og Anutu su rëḳ dahun yi ġaġek sënë na rë, gaḳ yö rëḳ gëp vu yi degwata.” ");
INSERT INTO bzh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lob ata losho ari lo yam denare dobnë gedevonġ ġaġek ya vu yi bë duḳ na vu sir. ");
INSERT INTO bzh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Gelosho mehönon nġahiseḳë denedo, lom denër vu yi bë, “Atam garim lo avëhnöm lo yam denare dobnë medeneloḳ tepëḳ in honġ!” ");
INSERT INTO bzh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Rëḳ loḳ tepëḳ yah vu sir nebë, “Ataġ lo arig re lo?” ");
INSERT INTO bzh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Log mala neḳo loḳ begganġ ayo menelë alam pin sën detebuu yi lo genër vu sir bë, “Sataġ lo sarig lo sënë! ");
INSERT INTO bzh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Alam sën denesepa loḳ Anutu kwa lo, og sir saga mëm detu sarig lo, savëhnög lo, sataġ lo.” ");
INSERT INTO bzh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Buk ngwë rë, loḳ Yesu yah meya nġaggee böp lo nenga, lom tateḳin ġaġek vu mehönon ggökin yah. Mehönon nġahiseḳë rot desup sir medeneteḳing raḳ sir, lom raḳ ya nedo yaġ ti raḳ nġaggee vavunë galam pin denedo nġaggee nenga. ");
INSERT INTO bzh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Lom mëm nenër ġaġek peggirinsën nġahiseḳë vu sir, genër bë, ");
INSERT INTO bzh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ham gwenġo rë! Mehö netetëhin nos ġahis ti to meya huk anon in bë tetëhin yi nos ġahis. ");
INSERT INTO bzh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Netetëhin nos ġahis, lob vahi to nedo loḳ aggata sën neyoh huk vuheng lo, lob soḳ yam pevis medegga. ");
INSERT INTO bzh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Log ġahis vahi to meraḳ nedo dob mahen teka sën raḳ neggëp ġelönġ vavunë lo, om kip pevis in dob mahen teka mu. ");
INSERT INTO bzh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lob hes verup netum bevev raḳ, lob meran ya pevis in ġeġa su luḳ ya dob rë. ");
INSERT INTO bzh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Log ġahis vahi to meloḳ ya nedo vos niggin ggin ayo, lob vos niggin ggin sënë kip merig, lob ggök nos besu sis anon rë gema. ");
INSERT INTO bzh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Log ġahis vahi to meluḳ ya nedo dob jeji lob kip verup merig mesis anon. Vahi sis dahis ti benemadluho, gevahi sis dahis löö, gevahi sis dahis nemadvahi.” ");
INSERT INTO bzh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Log nër ving bë, “Mehöti bë nenga neggëp, og genġo ġaġek sënë.” ");
INSERT INTO bzh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ya nedo tahsën, loḳ yi hur maluh nemadluho-bevidek-luu sën losho alam sën denesepa yi lo, yam deloḳ tepëḳ vu yi bë, “Ġaġek peggirinsën sën ġenër-ë degwa nebë va?” ");
INSERT INTO bzh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Loḳ nër yah vu sir bë, “Anutu netateḳin ġaġek vunsën raḳ yi nyëġ degwa vu ham, gaḳ alam vahi sën denedo nenga lo, og Anutu nenër vu sir loḳ ġaġek peggirinsën mu, ");
INSERT INTO bzh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘in bë su rëḳ degërin sir nah vu Anutu mekevoh hir nġaa nipaya na rë. Gaḳ degelë mu gesu dejaḳ ni rë, log degenġo mu gesu denatöḳ jaḳ ġaġek degwa rë.’” ");
INSERT INTO bzh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Lob loḳ tepëḳ yah vu sir nebë, “Ma ham su raḳ ġaġek peggirinsën sënë degwa ni rë? Om maḳ ham rëḳ jaḳ ġaġek peggirinsën pin ni nabë va? ");
INSERT INTO bzh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mehöti sën netetëhin nos ġahis lo nebë mehö nenër Anutu yi ġaġek. ");
INSERT INTO bzh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Log ġahis vahi sën to nedo loḳ aggata lo nebë alam sën denġo Anutu yi ġaġek ggovek, loḳ tum Satan yam pevis meḳo vër in ayoj lo. ");
INSERT INTO bzh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Geġahis vahi sën to meraḳ nedo dob los ġelönġ lo nebë mehönon vahi sën denġo Anutu yi ġaġek log ahëj nivesa medeḳo raḳ pevis. ");
INSERT INTO bzh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Rëḳ mu sir nebë nos ġeġa sën neraḳ vu ġelönġ lo om denedo teka, loḳ nġaa maggin töḳ vu sir, ma, alam denenër pelësën raḳ sir in denesepa loḳ Anutu yi ġaġek, lom tum delëëin pevis. ");
INSERT INTO bzh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Log ġahis vahi sën loḳ nedo vos niggin ggin ayo lo nebë alam sën denenġo Anutu yi ġaġek ggovek lo. ");
INSERT INTO bzh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Loḳ newaj neraḳ in nġaa-dob-yi rot gahëj neving monë bedenelev vahaj in ḳupeḳ lu nġaa, lob mëm nġaa pin sënë neggök Anutu yi ġaġek banon nema. ");
INSERT INTO bzh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Log ġahis sën to meluḳ ya dob jeji lo nebë alam sën denġo yi ġaġek medevasu loḳ ayoj medenevonġ yoh vu banon neraḳ lo. Sënë nebë nos rig menesis anon nivesa; vahi nesis dahis ti benemadluho, gevahi nesis dahis löö, gevahi nesis dahis nemadvahi.” ");
INSERT INTO bzh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Lob nër vu sir bë, “Bë hil ġelu doḳ ram buk, og maḳ yoh vu bë hil abun duḳ na dëg ayo ti, ma, hil ġetunġ duḳ na reek ġebinë? Ma! Hil ġetunġ jaḳ medo reek vavunë in natum nivesa behil ġalë nyëġ jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lob nġaa pin sën neggëp vunsën lo, najeeng rëḳ tato yi ranġah, genġaa pin sën debom meneggëp loḳ ġobeng gwëbeng agi, og najeeng rëḳ alam pin dejaḳ ni. ");
INSERT INTO bzh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bë ham nengamin neggëp, og ham gwenġo ġaġek sënë meham kwamin bo!” ");
INSERT INTO bzh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Loḳ nër vu sir ggökin bë, “Ham kwamin bo ġaġek sën ham nenġo lo nivesa rë. Nġaa sën ham nevonġ vu mehö ngwë lo, og rëḳ Anutu bo doḳ nah vu ham nabë, gebo la geving mesevöḳ. ");
INSERT INTO bzh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mehöti sën neraḳ ġaġek degwa ni lo, og rëḳ jaḳ la degwa ni geving rot. Gemehöti sën su neraḳ ġaġek degwa ni rë lo, og rëḳ kwa birekin teka sën neraḳ ni lo benama na veröḳ yi.” ");
INSERT INTO bzh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Log nër bë, “Sën Anutu yi Nyëġ anon jaḳ lo, og yiḳ nebë mehöti tetëhin nos ġahis luḳ ya dob. ");
INSERT INTO bzh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Lom neggëp buk genekedi raḳ monbuk benedo yoh vu buk nġahi, log nos ġahis lo kip berig geyi duġin degwa sën nos nerig raḳ lo. ");
INSERT INTO bzh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ġahis yö kip verup dob. Neru verup muġinsën, lob tunġ ris raḳ genema ggol raḳ, lom mëm vuuḳ anon. ");
INSERT INTO bzh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Loḳ nelë bë anon loḳ beris nebunġ, lob mëm neḳo paggëpek beketöv anon in anon loḳ ggovek lo. Kë! Lob Anutu yi Nyëġ anon neraḳ nebë sënë.” ");
INSERT INTO bzh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Log nër ggökin yah bë, “Hil nanër nabë Anutu neġin hil nebë va? Gehil nanër ġaġek peggirinsën jaḳ yi nyëġ nabë anon neraḳ nebë va? ");
INSERT INTO bzh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hil nanër nabë: Sën yi Nyëġ anon jaḳ lo, og yiḳ nebë mastet* ġahis sën hil nehehin lo. Mastet* ġahis sënë og mahen teka rot genos ġahis pin kesuu. ");
INSERT INTO bzh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Loḳ nabë hil ġehin, og nakip bejig böpata bekesuu jojeng pin, bemëm nema böp gol doḳ og soḳ sën denevëëng medeneya agi rëḳ nam dejegwi newisej doḳ nema gedejivin kuu. Kë! Lob Anutu yi Nyëġ anon neraḳ nebë sënë!” ");
INSERT INTO bzh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu nenër vu sir loḳ ġaġek peggirinsën nġahi yoh vu sën bë dejaḳ ni. ");
INSERT INTO bzh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nenër yi ġaġek vu mehönon pin loḳ ġaġek peggirinsën nebë sënë, rëḳ mëm losho yi hur maluh yö ya denedo tahsën, log netateḳin ġaġek sën pin ranġah vu sir. ");
INSERT INTO bzh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Loḳ buk timu saga, lob nyëġ luḳ ya, lob nër vu yi hur maluh nebë, “Hil ana nġaggee vahi sagu rë.” ");
INSERT INTO bzh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yesu raḳ nedo yaġ lo vorot, lom yi hur maluh deraḳ ya ving medeya, gedevuu alam saga lo ya. Gelosho yaġ vahi desepa sir medeya. ");
INSERT INTO bzh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Lob sanġ böpata nevë genġaggee nesis böp meneluḳ ya yaġ ayo bevuuḳ loḳ, bevonġin bë napup. ");
INSERT INTO bzh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","GeYesu bë kwa raḳ nġadoheng dus ti meneggëp yiing ggëp yaġ hus, loḳ mëm yi hur maluh deggee vu yi medenër vu bë, “Tatovaha! Su kwam nevo hil bë vonġin hil malad nama rë?” ");
INSERT INTO bzh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Lom kedi raḳ pevis bepetupek raḳ sanġ los nġaggee bë, “Ggovek ya! Ahëm yes jaḳ!” Lom sanġ ahë yes raḳ pevis gededun ma geneggëp. ");
INSERT INTO bzh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Lob mëm nër vu sir bë, “Ham newamin raḳ in-a? Maḳ su ham ayomin neyam timu vu sa rë?” ");
INSERT INTO bzh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Lom ḳenuj ya rot gedeneloḳ tepëḳ vu sir nebë, “Maḳ mehö sënë yi nebë va? Om sën sanġ los nġaggee denġo aye-ë?” ");
INSERT INTO bzh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nebë saga, lom ya detöḳ ya nġaggee nenga vahi, sën alam Garasa hir nyëġ lo. ");
INSERT INTO bzh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lob Yesu raḳ nedo yaġ meya pesönġ ya roneḳ, lob mehöti kedi ggëp waaḳ sën denebë mehönon seḳëj loḳ lo meluḳ to vu yi, lob memö nipaya nedo loḳ ayo. ");
INSERT INTO bzh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mehö sënë ben loḳ neggëp waaḳ ving mehönon seḳëj gemehöti su yoh vu bë naduu yi ahon jaḳ sëng ma nġaa ti rë gema. ");
INSERT INTO bzh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gaḳ deneduu nema los vaha raḳ sëng wirek wirek, loḳ nevepul sëng in nema genekeluġin sëng benepepöö in vaha, gemehöti su yoh vu bë gevonġ bemala yes jaḳ rë. ");
INSERT INTO bzh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nedo nyëġ heljënġ los ḳedu, log medo nenġeeḳ buk los ranġah genesis yi raḳ ġelönġ. ");
INSERT INTO bzh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mehö sën nahën nedo adingnë menelë Yesu, loḳ seröġ meyam petev neggëp loḳ Yesu vaha, ");
INSERT INTO bzh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","genġeeḳ bë, “Yesu, Anutu Vavunë nalu honġ. Ġeyam in-a? Bë gwevonġ va vu sa? Sa ḳetaġ yök vu honġ niwëëk neggëp Anutu mala nebë su ġebasap sa!” ");
INSERT INTO bzh_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","In Yesu nër vu memö sënë bë, “Memö nipaya-e! Gwevuu mehö sënë na gegweto ġena!” ");
INSERT INTO bzh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Lob mëm Yesu loḳ tepëḳ ya vu mehö sënë bë, “Arëm re?” Rëḳ bë, “Sarëġ nebë Mehömehö in he nġahiseḳë.” ");
INSERT INTO bzh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Loḳ mëm pasanġ neketaġ vu Yesu nebë Yesu su getii sir na gedegevuu nyëġ sagi. ");
INSERT INTO bzh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Log bööḳ yu ti vare deneruuk raḳ ḳedu sënë vewen, ");
INSERT INTO bzh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","lom tum memö deketaġ vu yi bë, “Gwevonġ he mehe na ġegwanġ na bööḳ sagu ayoj.” ");
INSERT INTO bzh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Lob yoġekin bë yoh vu bë degegwanġ na, lom mëm memö nipaya sën devuu mehö lo ya geto deya degwanġ ya bööḳ; lob bööḳ saga sir 2,000, lob mëm deseröġ meya deluḳ nyëġ vaha degwa ti meya devës ya nġaggee benġaggee rehöö sir pin bemalaj maya veröḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Lob alam sën deneġin bööḳ lo deveya meya denër nġaa sënë ranġah vu alam pin sën denedo loḳ nyëġ böp los mahen mahen lo ving. Lob alam saga deyah in bë degelë nġaa sën to meya lo. ");
INSERT INTO bzh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lob deyah vu Yesu medelë mehö sën memö to deya in yi lo. Delë mehö sën Mehömehö gwanġ ya yi wirek lo vëh tob benedo nivesa gekwa nevo nġaa nivesa, loḳ tum deneggönengin sir rot. ");
INSERT INTO bzh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Lob alam sën delë nġaa agi raḳ malaj lo, denetateḳin nġaa pin sën töḳ vu mehö los memö nipaya gebööḳ lo pin vu sir ving. ");
INSERT INTO bzh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Lom mëm alam pin deketaġ vu Yesu bë gevuu hir nyëġ gena. ");
INSERT INTO bzh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Lom Yesu nahën neraḳ yah yaġ, log mehö sën memö to deya in yi lo ya ketaġ vu yi bë na geving yi. ");
INSERT INTO bzh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Rëḳ Yesu vonġ yi yah genër vu yi bë, “Mu ġenah meġena vu honġ alam meġena ġenanër nġaa böp sën Mehöböp vonġ vu honġ los kwa pesivin honġ lo ranġah vu sir.” ");
INSERT INTO bzh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Lob yah meya medo nenër ġaġek sënë ranġah vu alam ggëp nyëġ sën denenër arë nebë Begganġ-bu-nemadluho lo nebë Yesu vonġ nġaa böp sën sënë vu yi, lom tum alam pin avij netöḳ. ");
INSERT INTO bzh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu raḳ yaġ meyah meya nġaggee vahi galam nġahiseḳë desupin sir meyam detetup yi loḳ nġaggee nenga. ");
INSERT INTO bzh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nahën nedo nġaggee böp nenga lob dub-supinsën-yi ala ti, arë nebë Yairus, to metöḳ vu yi, lob petev meto neggëp loḳ vaha, ");
INSERT INTO bzh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","log ketaġ niwëëk vu yi bë, “Sa naluġ avëh dus raḳ in nadiiḳ. Om ġenam gwebë nemam jaḳ yi in vesa doḳ bemedo.” ");
INSERT INTO bzh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Lom Yesu ya ving yi beluho deya, lob alam nġahiseḳë rot desepa luho medepeḳa raḳ yi medeya ving. ");
INSERT INTO bzh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lob avëh ti niḳöḳ medo neyam yoh vu ta nemadluho-bevidek-luu. ");
INSERT INTO bzh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yi sënë neya vu dokta nġahiseḳë in bë degevonġ benivesa jaḳ, rëḳ ma gesu deyoh vu rë, geneḳo vanë rot. Baġo sir raḳ yi monë los yi nġaa pin bemaya veröḳ yi, rëḳ su nivesa neraḳ rë geniḳöḳ neyam ata. ");
INSERT INTO bzh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Avëh sënë lo nenġo Yesu bengö nebë nevonġ mehönon benijvesa neraḳ, lob mëm sepa yi begwanġ ya alam nġahiseḳë sënë lo vuheng atov, beyam to nare Yesu demi gebë nema raḳ yi tob, in kwa nevo loḳ ayo nebë, ");
INSERT INTO bzh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Nabë sa ġebë nemaġ jaḳ yi tob mu, og rëḳ sa niġ kelöḳ jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kwa vo loḳ ayo nebë sënë, gebë nema raḳ tob genenġo loḳ ayo nebë niḳöḳ tewii ya benivesa raḳ pevis. ");
INSERT INTO bzh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lob Yesu nġo bë niwëëk la to meya in yi, loḳ peggirin yi pevis loḳ alam sagi lo vuheng atov meloḳ tepëḳ vu sir nebë, “Re bë nema raḳ sa tob-a?” ");
INSERT INTO bzh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Rëḳ yi hur maluh denër yah vu yi bë, “Ġenelë bë alam nġahi sën denepeḳa raḳ honġ rot, loḳ ġeloḳ tepëḳ bë re bë nema raḳ honġ in va?” ");
INSERT INTO bzh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Rëḳ Yesu mala neḳo loḳ menelë sir in bë jaḳ mehöti sën vonġ nebë agi ni. ");
INSERT INTO bzh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Loḳ avëh raḳ nġaa sën töḳ vu yi lo ni, om ggöneng menelëk, lom yam petev meneggëp loḳ Yesu vaha genër yi ġaġek pin sënë ranġah vu yi. ");
INSERT INTO bzh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Lob Yesu nër yah vu yi bë, “Naluġ-e! Ayom yam timu vu sa, lob vonġ benim vesa raḳ, om ġena los ayom sepëp genim raḳsën sënë rëḳ nama na veröḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu nahën nevengwënġ vu avëh sënë, log mehö la deḳo ġaġek ggëp dub ala Yairus yi begganġ beyam denër vu dub ala sënë bë, “Nalum diiḳ ya gwëbeng, om su gweḳo Tatovaha mala seggi rë.” ");
INSERT INTO bzh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Loḳ Yesu su bë nenga vu hir ġaġek rë, genër vu dub-supinsën-yi ala bë, “Su newam jaḳ! Gaḳ ayom nam timu vu sa!” ");
INSERT INTO bzh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Lob nërin alam pin saga bedenedo, geyiḳ losho Pita geYakobus luho ari Jon, gavëh avö sën diiḳ lo ama, medeya. ");
INSERT INTO bzh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ya deto dub ala sënë yi begganġ, lob mëm nelë bë alam nġahiseḳë denedo genenġo bë denevonġ dedun böpata gedenesu medenesis sir rot. ");
INSERT INTO bzh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nebë sënë rëḳ Yesu loḳ ya begganġ ayo benër vu sir bë, “Ham nevonġ dedun böpata los ham nesu rot nebë sënë in va? Hurmahen sënë su diiḳ rë, gaḳ neggëp yiing mu!” ");
INSERT INTO bzh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Loḳ denöp raḳ yi, lom tii sir pin to deya dobnë gemëm losho hurmahen sënë ama lu ata, geyi hur maluh lööho sën deya ving yi lo, medeloḳ ya begganġ ayo sën hur avëh diiḳ meneggëp loḳ lo, ");
INSERT INTO bzh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","lob jom loḳ nema genër vu loḳ ayej bë, “Talita kumi!” (Degwa nebë, “Avëh mahen-e! Kwedi jaḳ!”) ");
INSERT INTO bzh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Lom mëm avëh mahen lo kedi raḳ pevis meneggee meneya, in yi ta nemadluho-bevidek-luu. Gemem sir pin ḳenuj ya rot in. ");
INSERT INTO bzh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Log Yesu vo ḳoo vu sir bë su dena denanër nġaa sënë ranġah vu mehö la, genër ving bë degevonġ nos vu avëh mahen sënë. ");
INSERT INTO bzh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ggovek log Yesu yah meya yi nyëġ, lom yi hur maluh deya ving yi. ");
INSERT INTO bzh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lob Buk-sewahsën-yi* lom luḳ ya dub-supinsën-yi menetahu alam. Sir nġahi denedo, lom denġo aye bavij töḳ medenër vu sir nebë, “Mehö sënë neḳo ġaġek sënë vu tena? Maḳ re vonġ ġaġek los kwa sënë vu yi? Re loḳ vu yi om sën nevonġ nġaa böp böp nebë agi? ");
INSERT INTO bzh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Sënëḳ yiḳ Maria nalu, mehö sën nelev begganġ lo? Gari lo sën Yakobus luho Yoses geYudas lu Simon agi lo? Gavëhnö lo sën yiḳ nahën denedo ving hil-ë lo?” Lom denelë yi paya. ");
INSERT INTO bzh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nebë sënë lob Yesu nër vu sir bë, “Alam vu nyëġ pin deneḳo mehö-nenër-ġaġek-ranġahsën arëj raḳ, gaḳ yö hir alam, gehir degwa, gesir sën losho begganġ-bu timu lo, og ma!” ");
INSERT INTO bzh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Lom Yesu su yoh vu bë gevonġ nġaa böp vu saga rë. Gaḳ yiḳ nebë nema raḳ alam nijraḳsën ti ti mu benijvesa neraḳ. ");
INSERT INTO bzh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Lob avi töḳ meranġa nema in su denevonġ ving yi rë gema. Lom ya neḳo loḳ begganġ-bu sën denedo dus raḳ lo metateḳin Anutu yi ġaġek vu sir. ");
INSERT INTO bzh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Lob supin yi hur maluh nemadluho-bevidek-luu sën lo genër vu sir bë dena jaḳ. Nevonġ sir luu luu ya genër vu sir bë degetii memö nipaya lo geto dena. ");
INSERT INTO bzh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Lob nër ġaġek vu sir ving bë denatohin atohenġ mu gedena meris. Su degeḳo nos sepa, gevahek los monë gëp. ");
INSERT INTO bzh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Gaḳ yiḳ dejöp suu beröpröp ading timu gesu degeḳo ngwë sepa. ");
INSERT INTO bzh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Log yiḳ nër yah vu sir ggökin bë, “Bë mehöti geḳo ham luu luu sënë doḳ na yi begganġ megeġin ham, og ham naḳööḳ doḳ begganġ saga rot beham na jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Rëḳ nabë begganġ-bu ti su degeġin ham los degenġo ham ġaġek nivesa rë, og ham tetëhin kebus in vahamin, in dejaḳ ni nabë devonġ paya, log ham gwevuu begganġ ti saga na geham na jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Lob mëm deya raḳ meya denër Anutu yi ġaġek sënë ranġah vu mehönon bë degevuu hir nġaa nipaya na gedegërin sir nom vu Anutu. ");
INSERT INTO bzh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Gedenetii memö nġahiseḳë to deneya, gedenerikin wël* ḳele-oliv* raḳ mehönon nġahiseḳë sën nij neraḳ lo ving, benijvesa neraḳ. ");
INSERT INTO bzh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Alam pin denġo Yesu bengö medenër ya meyoh vu alam pin, beMehö-los-bengö Herot* nġo ving bë nevonġ nġaa böp nebë sënë, lom alam vahi denenër bë yiḳ sënëḳ Mehö-neripek-alam Jon sën diiḳ lo rëḳ vesa loḳ yah, om sën nevonġ huk los niwëëk nebë agi. ");
INSERT INTO bzh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Rëḳ mu alam vahi denenër bë, “Mu maḳ Elia.” Galam vahi denenër bë, “Mu mehö-nenër-ġaġek-ranġahsën ti nebë alam sën denenër ġaġek ranġah wirek lo.” ");
INSERT INTO bzh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Rëḳ mu Herot* nenġo bengö nebë sënë lob nër bë, “Mu yiḳ Jon sën sa ḳetöv kwa lo sën kedi raḳ yah.” ");
INSERT INTO bzh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","In wirek og Herot* yö vonġ mehö la ya dejom Mehö-neripek-alam Jon ahon medetunġ loḳ ya ḳarabus raḳ degwa nebë sënë: Herot* ggodeḳ ari Pilip venë Herodias, betum neḳo netu venë, ");
INSERT INTO bzh_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","lom Jon nër vu Herot* bë, “Ġehodeḳ arim avëh, sënë su yoh vu rë, ġekweyëh horek!” ");
INSERT INTO bzh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Lob Herodias ahë sengën vu Jon bebë ngis yi nadiiḳ rëḳ ma, gaggata su neggëp rë, in Herot* neggönengin Jon. ");
INSERT INTO bzh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","In neraḳ ni bë su nevonġ nġaa nipaya ti rë, gaḳ yi mehö yohvu beyi vabuung, lom neġin yi nivesa. Nenġo Jon yi ġaġek lom kwa neya nġahi gayo maggin, rëḳ ahë neving panġsën bë genġo yi ġaġek rot. ");
INSERT INTO bzh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nebë sënë geHerodias yö medo mekwa nevo bë buk ti rë. Lob mëm buk ti, lob Herot* kwa vo yi buk sën ata ḳo yi wirek lo, lob nevonġ nos böpata ti vu yi ggev losho yi alam sën deneġin beġö lo hir ggev, gevu alam böp böp vu distrik Galilea pin. ");
INSERT INTO bzh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Medo denegga nos sënë geHerodias nalu avëh avö ti lo ya nelöö loḳ malaj, geHerot* losho yi vatëveḳ sën ahëj nivesa rot vu yi, lom Mehö-los-bengö Herot* nër vu bë, “Ġenanër nġaa ti sën ahëm neving rot lo ranġah vu sa, lob sëḳ bo nök vu honġ.” ");
INSERT INTO bzh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Lom tato nema ya vavunë genër yönon rot bë, “Nġaa ti sën ġenanër vu sa lo, og yiḳ sëḳ bo noh vu nök vu honġ. Gaḳ bë ġenanër sa nġaa pin sënë vewen, og sa su rëḳ ġulin rë.” ");
INSERT INTO bzh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Lob avëh avö to meyah dobnë beya meloḳ tepëḳ vu ata bë, “Senah mena nanër va?” Rëḳ bë, “Mehö-neripek-alam Jon yu!” ");
INSERT INTO bzh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Lom pevis meloḳ yah humeḳ ayo menewa newa meneya vu mehö-los-bengö menër vu yi bë, “Sa bë gwevonġ Mehö-neripek-alam Jon yu vu sa! Gwetunġ doḳ medo ġabum ti meġebo vu sa pevis.” ");
INSERT INTO bzh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Lob mehö-los-bengö ayo maggin rot, rëḳ ggöneng vu ġaġek sën nër ranġah vu avëh lo, lob su bë rëḳ keyëh ġaġek rë in nër yönon getato nema ya vavunë, beyi alam vatëveḳ pin denġo. ");
INSERT INTO bzh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Lom pevis mevonġ alam-beġö-yi ti ya in Jon yu loḳ ḳarabus ayo. Lob ketöv Jon kwa, ");
INSERT INTO bzh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","betunġ loḳ ġabum ti, beḳo yom vu avëh avö sënë lo, loḳ mëm ḳo meyah vo vu ata. ");
INSERT INTO bzh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ggovek saga lob Jon yi hur maluh denġo bengö bë desis yi mediiḳ, lob ya deḳo meya debë loḳ waaḳ heljënġ yi ti. ");
INSERT INTO bzh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Lob sinarë sën Yesu vonġ sir ya lo yom deverup vu yi, bedenër huk sën denevonġ lo los ġaġek pin sën denenër vu alam lo vu yi. ");
INSERT INTO bzh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Galam nġahiseḳë deneyah gedeneyom vu sir besu deyoh vu bë dega nos rë, lom Yesu nër vu yi hur maluh lo bë, “Ham nam hil nġo ana medo nyëġ-yumeris tahsën geham sewah teka rë!” ");
INSERT INTO bzh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Lom mëm sir yö anon deraḳ ya yaġ medeya nyëġ-yumeris tahsën ti. ");
INSERT INTO bzh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Rëḳ alam nġahi delë bë deneya raḳ, lob deraḳ nyëġ sën bë dena lo ni, lob alam vu nyëġ böp pin saga deneseröġ medeneyoh roneḳ medenemuġin meya deneġin Yesu losho yi hur maluh vu nġaggee böp nenga vahi sagu. ");
INSERT INTO bzh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu pesönġ ya roneḳ loḳ lë bë sir nġahiseḳë, lob kwa vonġin sir rot, in sir nebë sipsip sën alaj main sir, lom mëm tateḳin ġaġek nġahiseḳë vu sir rot, ");
INSERT INTO bzh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","besehuk luḳ, lom yi hur maluh ya denër vu yi bë, “Sënëḳ nyëġ-yumeris tahsën sënë genyëġ ggovek ya, ");
INSERT INTO bzh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","om gwevonġ sir medenah medena begganġ-bu ti ti sën neggëp dus agi medebaġo hir nos.” ");
INSERT INTO bzh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Loḳ nër yah vu sir bë, “Mu ham nġo gwevonġ nos vu sir!” Loḳ deloḳ tepëḳ yah vu bë, “Gemonë K200 tena in he na baġo brët noh vu sir medega?” ");
INSERT INTO bzh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Lom mëm loḳ tepëḳ vu sir bë, “Ham brët va la neggëp-a? Ham nah gwelë rë!” Lob yah delë beyom denër vu bë, “Brët nemadvahi, geġël luu!” ");
INSERT INTO bzh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nebë saga, lob mëm nër vu alam pin bë, “Ham gweto medo yu ti ti jaḳ pahup sën nimewis aga, beham medo rë!” ");
INSERT INTO bzh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Lob to denedo yu yu raḳ neggëp alam mehödahis nemadvahi vahi, geraḳ neggëp alam mehödahis löö löö. ");
INSERT INTO bzh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ggovek ya, lob mëm nejom brët nemadvahi saga geġël luu lo raḳ, bemëm varah mala raḳ yaġek gejom raḳ in los ahë nivesa ya vu Anutu, log mëm deġo brët bevo vu yi hur maluh bemëm ya devo ggelek yoh vu alam pin. Lob heḳ ġël mevo yoh vu sir pin nebë saga ving. ");
INSERT INTO bzh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Lom degga beyoh vu sir pin bahëj pup ya. ");
INSERT INTO bzh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Degga ggovek, log desupin brët los ġël sën nedo lo loḳ sap nemadluho-bevidek-luu bepup ya. ");
INSERT INTO bzh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Log alam sën degga nos lo, sir maluh 5,000. ");
INSERT INTO bzh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ggovek ya log Yesu vonġ yi hur maluh bë dejaḳ na yaġ medenamuġin medena nġaggee vahi medena Betsaida, geyiḳ medo megevonġ alam pin sën deketëḳin medena rë. ");
INSERT INTO bzh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Lob vonġ sir ya, log ya los ḳedu in bë najom jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nebë saga lob sehuk luḳ geyaġ to meya nġaggee vuheng atov geYesu yö ti nahën nedo ḳedu. ");
INSERT INTO bzh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Loḳ nelë bë denevimengin yaġ rot in sanġ neruuk sir los yaġ yom. Loḳ nyëġ neggovek in bë geheng, lob Yesu vare neya raḳ nġaggee vavunë beya meto vu sir bevonġ in bë kesuu sir gena. ");
INSERT INTO bzh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Rëḳ delë bë vare neya raḳ nġaggee vavunë meneya, lob dekuung bë alam-diiḳsën ḳenuj ti, lom denġeeḳ. ");
INSERT INTO bzh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","In sir pin delë medeggönengin yi medelëk rot, rëḳ Yesu vengwënġ ya vu sir pevis bë, “Ham su newamin jaḳ! Yiḳ sa sënë, om ham su ġöneng!” ");
INSERT INTO bzh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Lom raḳ ya yaġ ving sir, log sanġ maya avuti, lom tum avij netöḳ mederanġa nemaj ");
INSERT INTO bzh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","in su kwaj nevo brët sën vet alam raḳ lo rë gema. In nahën gesu kwaj töḳ raḳ degwa rë. ");
INSERT INTO bzh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Lob deraḳ yaġ medetöḳ ya Genesaret*, lom mëm deseyu yaġ ahon ya nġaggee nenga menedo. ");
INSERT INTO bzh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Log depesönġ mederaḳ ya roneḳ, lom alam vu nyëġ sagi delë Yesu mederaḳ ni pevis. ");
INSERT INTO bzh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Lom mëm deneseröġ medeneyoh vu nyëġ saga pin medenevaḳu alam nijraḳsën loḳ hir ḳanyë medeneya nyëġ sën denenġo bë Yesu ya meto nedo lo. ");
INSERT INTO bzh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Vu begganġ yu böp geyu mahen geyoh vu nyëġ sën Yesu neyoh lo pin, og denebë alam nijraḳsën ya deneggëp telig, log deneketaġ vu yi bë yoh vu bë degebë nemaj jaḳ yi röpröp ading nenga mu. Lom alam pin sënë sën denebë nemaj raḳ yi tob lo, og nijvesa neraḳ. ");
INSERT INTO bzh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisai* galam-horek-yi la vu Yerusalem desupin sir medeya vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Lob delë bë yi hur maluh vahi denegga nos los nemaj nipaya-sënë nebë su deneripek nemaj yoh vu alam Yuda hir horek muġin rë gema. ");
INSERT INTO bzh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Denër nebë sënë in Parisai* ving alam Yuda pin denesepa loḳ alam hib wirek hir ġaġek sën nebë: Su dejipek nemaj namuġin rë, og su rëḳ dega nos. ");
INSERT INTO bzh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Genġaa pin sën debaġo vu maket lo, og deneripek rë, loḳ mëm denegga. Gemedo denesepa alam hib wirek hir ġaġek muġeng nġahiseḳë nebë sënë ving, bedeneripek kap geġabum gedëg aën los nġaa pin. ");
INSERT INTO bzh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Denevonġ nebë sënë, om sën Parisai* losho alam-horek-yi deloḳ tepëḳ vu Yesu bë, “Honġ hur maluh dekeyëh horek medenegga nos los nemaj nipaya gesu denesepa loḳ alam hib wirek hir ġaġek rë in va?” ");
INSERT INTO bzh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Lob nër yah vu sir bë, “Mehö-nenër-ġaġek-ranġahsën Yesaya nër valeḳ ham yönon bë ham ayomin luu. Kevu wirek meneggëp nebë sënë: ‘Alam sënë deneḳo sarëġ raḳ rak avij meris mu, gaḳ ayoj nilëlin sa. ");
INSERT INTO bzh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yö denenër mehönon hir horek mu, log denenër nebë “Anutu yi ġaġek sënë!” Log deneḳo sarëġ raḳ meris mu.’ ");
INSERT INTO bzh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ham lëëin Anutu yi horek ya, geham nejom mehönon hir ġaġek muġeng ahon.” ");
INSERT INTO bzh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Loḳ nër vu sir ggökin bë, “O yönon! Maḳ ham mehönon los kwamin, om sën ham neruu demimin vu Anutu yi horek geham nġo nesepa loḳ alam hib wirek hir ġaġek-ë? ");
INSERT INTO bzh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","In Moses nër wirek meneggëp bë, ‘Ġeġurek amam lu atam babuj!’ genër ving bë, ‘Bë mehöti nanër ġaġek nipaya jaḳ ama ma ata, og ham tengwa yi menadiiḳ.’ ");
INSERT INTO bzh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Loḳ ham nenër bë, ‘Bë mehöti yi monë lu nġaa neggëp in bë doḳ vu ama ma ata jaḳ, rëḳ mu nanër vu luho nabë, “Sa bë doḳ vu meluu meġevonġ sa nġaa sënë nök vu meluu, rëḳ mu rëḳ nama in sehooin raḳ ggovek netu Korban (sënë nër bë tu Anutu yi seriveng).” ’ ");
INSERT INTO bzh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nenër nebë saga, lob ham nevo veyovin bë, ‘Yiḳ ggovek, su doḳ vu ama lu ata!’ ");
INSERT INTO bzh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Lob sënë og ham nekweyëh Anutu yi horek meham nenër bë nġaa meris, geham nesepa loḳ alam hib wirek hen hir ġaġek menenër bë nġaa anon. Beham netahu nalumin lo loḳ ving. Geham nevonġ nġaa nġahiseḳë nebë sënë.” ");
INSERT INTO bzh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ggovek, loḳ supin alam ggök yahin menër vu sir bë, “Ham pin gwenġo sa ġaġek bejaḳ ni venuh! ");
INSERT INTO bzh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nġaa pin sën hil naha lo su yoh vu bë duḳ na mehöti ayo megevonġ benipaya jaḳ rë. Gaḳ mu nġaa sën nedo loḳ ayo meraḳ neverup avi lo mu sën nevonġ benipaya neraḳ. ");
INSERT INTO bzh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Bë mehöti nenga neggëp og genġo mekwa bo rë!” ");
INSERT INTO bzh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nër ġaġek sënë ggovek, log vuu alam saga geraḳ ya begganġ, loḳ mëm yi hur maluh ya deloḳ tepëḳ vu yi in ġaġek peggirinsën sënë. ");
INSERT INTO bzh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Lob loḳ tepëḳ yah vu sir bë, “Ma ham nahën geham su neraḳ ni rë? Maḳ ham su raḳ ni bë nġaa pin sën hil naha meneloḳ ya hil ayod lo, og su yoh vu bë gevonġ mehöti benipaya jaḳ rë? ");
INSERT INTO bzh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","In nġaa nebë sënë su negwanġ ya mehönon ayoj rë, gaḳ neluḳ ya ahëj ḳevus mu, loḳ tum to neluḳ ya asoreng.” Yesu nër vu hil loḳ ġaġek sënë nebë nos los reggu aggagga pin og nivesa. ");
INSERT INTO bzh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Log mëm nër vu sir bë, “Nġaa sën nedo loḳ mehönon ayoj meneverup avij lo, sën nevonġ bemehönon nij paya neraḳ. ");
INSERT INTO bzh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","In nġaa sën neggëp loḳ mehönon ayoj meraḳ neverup avij lo nebë sënë: Kwaj nevo nġaa nipaya, denevonġ baggëb, deneggodeḳ nġaa, denesis mehönon medenediiḳ, ");
INSERT INTO bzh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","deneggodeḳ mehö ngwë venëj ma reggaj, malaj anonin mehö ngwë yi nġaa, denevonġ nġaa nipaya aggagga, denetetuhin mehö ngwë, kwaj nevo nġaa nipaya yoh vu buk pin netu hir nġaanon, ahëj sengën, denenër ġaġek pelësën raḳ mehönon, deneḳo sir raḳ, denevonġ jeggin jeggin. ");
INSERT INTO bzh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nġaa nipaya pin sënë loḳ neggëp mehönon ayoj, besën raḳ neverup avij menevonġ benij paya neraḳ.” ");
INSERT INTO bzh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Lob Yesu kedi raḳ loḳ saga meya Ture los Sidon hir nyëġ, beya nedo loḳ begganġ ti. Vonġin bë bun yi, rëḳ ma gesu yoh vu bë dah bengö vun rë. ");
INSERT INTO bzh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Loḳ avëh ti vu sagu nġo bë Yesu nedo, lom ya vu yi pevis. In memö nipaya ti gwanġ ya nalu avëh ayo menevonġ yi, lom ya pevis mepetev meneggëp loḳ Yesu vaha. ");
INSERT INTO bzh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Avëh sënë og avëh yu ngwë, ata Grik avëh beḳo yi vu Ponisia vu distrik Suria benedo, lob ya ketaġ vu Yesu bë getii memö geto mena in nalu. ");
INSERT INTO bzh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Lob Yesu nër raḳ ġaġek peggirinsën yah vu yi bë, “Hil abet hurmahen namuġin rë, in su yoh vu bë hil ġaḳo hurmahen hir nos vër meġetë na vu anöö rë!” ");
INSERT INTO bzh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Loḳ avëh sepa loḳ yi ġaġek menër yah vu yi nebë, “Ëë-ë, Mehöböp yönon! Gaḳ mëm hurmahen hir nos sën denegga gemetes to neluḳ ya reek len lo, og mëm anöö yam denepatu medenegga.” ");
INSERT INTO bzh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Lom mëm Yesu nër yah vu yi bë, “Ġenër ġaġek los kwam saga, om ġenah meġena böm in memö nipaya vuu nalum geto meya gwëbeng!” ");
INSERT INTO bzh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Lom yah meya ben genalu raḳ neggëp ḳanyë gememö to meya veröḳ yi yoh vu sën Yesu nër lo. ");
INSERT INTO bzh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Lob Yesu vu Ture hir nyëġ meyoh ya Sidon meneya nġaggee böp Galilea nenga meya neḳo loḳ nyëġ sën denenër arë nebë Begganġ-bu-nemadluho lo hir dob. ");
INSERT INTO bzh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Lob deḳo mehöti nenga mir gekwa nġengöleng bedeya vu yi medeketaġ bë gebë nema jaḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mehönon nġahiseḳë denedo saga, lom li yi meya nenga tahsën, loḳ mëm gelu nema deggis loḳ ya mehö lo nenga len, log pesuv nyë ḳos metunġ raḳ daggen. ");
INSERT INTO bzh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesu mala ya yaġek gerov saheng in kwa pesivin mehö sënë lo, log nër vu bë, “Epata!” (Degwa nebë “Nengam natöḳ!”). ");
INSERT INTO bzh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Lom nenga töḳ menġo ġaġek gedaggen neggee menevengwënġ nivesa. ");
INSERT INTO bzh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Lob mëm Yesu vo ḳoo vu sir pin saga bë su dena denanër ġaġek sënë ranġah vu mehö la. Yesu vo ḳoo vu sir niwëëk, rëḳ ma gedekeyëh aye genij wëëk beya denër ranġah. ");
INSERT INTO bzh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Alam denġo lob ḳenuj ya rot medenër bë, “Mehö sënë nevonġ nġaa pin nivesa. Om sën nevonġ balam nengaj mirsën denenġo ġaġek, genevonġ balam kwaj nġengöleng denevengwënġ nivesa.” ");
INSERT INTO bzh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Loḳ buk saga alam nġahiseḳë desupin sir ya vu yi ggökin benos main sir, lom supin yi hur maluh menër vu sir bë, ");
INSERT INTO bzh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Sa kwaġ nevonġin alam sënë in hil nado buk löö genos main sir. ");
INSERT INTO bzh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sir vahi deyam vu nyëġ ading, om nabë sa ġevonġ sir medenah bej los ahëj meyip, og rëḳ nök denadiiḳ aggatata.” ");
INSERT INTO bzh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Lom yi hur maluh deloḳ tepëḳ yah vu yi bë, “Hil nado nyëġ-yumeris tahsën sënë, om hil rëḳ ġaḳo nos vu tena in hil abet mehönon sënë jaḳ-a?” ");
INSERT INTO bzh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Lob Yesu loḳ tepëḳ yah vu sir bë, “Ham ḳo brët va la?” Loḳ denër yah vu yi bë, “Nemadvahi-bevidek-luu!” ");
INSERT INTO bzh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Lom mëm nër vu mehönon pin beto denedo dob, log ḳo brët nemadvahi-bevidek-luu sënë raḳ gejom raḳ in los kwa vesa ya vu Anutu, log debu bevo vu yi hur maluh in bë debo gelek noh vu alam pin, lom mëm devo ggelek yoh vu sir. ");
INSERT INTO bzh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Geġël mahen luu neggëp ving, lob nejom raḳ yah vu Anutu los kwa vesa in, genër vu yi hur maluh bë debo gelek noh vu alam pin geving. ");
INSERT INTO bzh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Lob degga meyoh vu sir pin beggovek ya, log vahi nedo bedesupin loḳ jebeng nemadvahi-bevidek-luu mepup. ");
INSERT INTO bzh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Log alam sën degga nos lo, sir yoh vu 4,000. Log mëm Yesu vonġ sir ya, ");
INSERT INTO bzh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","log pevis belosho yi hur maluh deraḳ ya yaġ ti medeya nyëġ Dalmanuta. ");
INSERT INTO bzh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Lob Parisai* la kwaj nevo bë depelë Yesu, lom ya deto vu bedeseggi yi bë, “Gwevonġ nġaa böp yaġek yi ti in he ġalë nabë Anutu vonġ honġ yam!” ");
INSERT INTO bzh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Lob Yesu ayo maggin berov saheng genër vu sir bë, “Ham sën ham nedo dob-ë, ham vonġin bë sa ġevonġ nġaa böp in bë tato nabë Anutu vonġ sa meseyam in va? Rëḳ mu sa nanër vu ham yönon nabë sesu rëḳ ġevonġ nġaa böp ti beham gwelë rë, gaḳ rëḳ nama!” ");
INSERT INTO bzh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Lob vuu sir geraḳ yah nedo yaġ ggökin meyah meya nġaggee vahi. ");
INSERT INTO bzh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yi hur maluh kwaj virekin nos gesu deḳo la sepa rë, geyiḳ brët perurek timu raḳ nedo yaġ. ");
INSERT INTO bzh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Lob Yesu nër vu sir loḳ ġaġek peggirinsën bë, “Arë! Ham gweġin ham vu Parisai* hir yiist*, gevu Herot* yiyi geving.” ");
INSERT INTO bzh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Lom kwaj nevo yi ġaġek medenesap sir raḳ medenër vu sir bë, “Hil su haḳo brët la sepa rë, om sën maḳ nenër aga!” ");
INSERT INTO bzh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Loḳ Yesu raḳ ni, lom nër vu sir bë, “Nebë va sën ham nesap ham raḳ bë ham su ḳo brët la sepa rë-ë? Maḳ ham duġin degwa? Ma maḳ ham ayomin yö nahën niwëëk-a? ");
INSERT INTO bzh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ham malamin neggëp rëḳ ham su nelë rë? Geham nengamin neggëp rëḳ ham su nenġo rë? Ma ham su kwamin nevo ");
INSERT INTO bzh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","sën sa debu brët nemadvahi vu alam 5,000 geham supin vahi loḳ ya sap va la mepup lo rë?” Rëḳ denër yah vu bë, “Nemadluho-bevidek-luu!” ");
INSERT INTO bzh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Rëḳ bë, “Log sën sa deġo brët nemadvahi-bevidek-luu vu alam 4,000 lo, og ham supin vahi loḳ ya jebeng va la mepup-a?” Loḳ denër bë, “Nemadvahi-bevidek-luu!” ");
INSERT INTO bzh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Loḳ tum loḳ tepëḳ bë, “Rëḳ ham nġo nahën geham su raḳ degwa ni rë?” ");
INSERT INTO bzh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Loḳ tum yah deverup Betsaida, lob alam la deli mehö mala ḳenod ti yam vu Yesu bedeketaġ vu yi bë gebë nema jaḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Lob Yesu jom loḳ nema geli yi meluho deya begganġ telig nenga, loḳ mëm pesuv nyë ḳos loḳ ya mala ġahis gebë nema raḳ yi, log loḳ tepëḳ vu nebë, “Ġëlë nġaa la?” ");
INSERT INTO bzh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Lob vër mala raḳ menër bë, “Sa nehalë mehönon, rëḳ mu sa halë ahëj ḳenu nebë ḳele, rëḳ mëm vare deneggee medeneya!” ");
INSERT INTO bzh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Lob mëm Yesu bë nema raḳ yah mala ġahis ggökin, lob mëm mehö lo mala tum niwëëk menelë nyëġ, bemala nivesa raḳ genelë nġaa pin neggëp ranġah. ");
INSERT INTO bzh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Lob nër vu mehö sënë bë, “Su ġedoḳ nah begganġ-bu ti sënë pehi gökin bedegelë honġ!” Log vonġ yi yah ben. ");
INSERT INTO bzh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Log Yesu losho yi hur maluh ya medo deneḳo loḳ begganġ-bu ti ti sën neggëp dus raḳ Sisarea vu distrik Pilipi lo. Nahën deneyök aggata log loḳ tepëḳ vu yi hur maluh bë, “Alam denenër sa bë sa re?” ");
INSERT INTO bzh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Loḳ denër yah vu yi bë, “Alam vahi denenër bë Mehö-neripek-alam Jon honġ, gevahi denenër bë honġ Elia, gevahi denenër bë honġ mehö-nenër-ġaġek-ranġahsën wirek hen ti!” ");
INSERT INTO bzh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Loḳ yiḳ loḳ tepëḳ yah vu sir bë, “Log hameḳ? Ham nenër bë sa re?” Loḳ Pita nër yah vu yi bë, “Honġ Kerisi*. Mehö sën Anutu ggooin raḳ in bë geḳo he nah lo.” ");
INSERT INTO bzh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Lob vo ḳooin niwëëk vu sir bë, “Om ham su na nanër sa nabë sënë vu mehöti!” ");
INSERT INTO bzh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Lob mëm nër nġaa sën rëḳ natöḳ vu yi lo ranġah vu sir bë alam böp böp galam-deneḳo-seriveng hir ggev rëḳ debo vanë vu Mehönon Nalu rot, galam-horek-yi rëḳ degeruu demij vu yi, lob dengis yi menadiiḳ gebuk natu löö loḳ kedi jaḳ nah gökin. ");
INSERT INTO bzh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nenër vu sir nebë sënë, lob Pita li yi meya nenga mevonġ ġaġek raḳ yi bë, “Su ġenanër ġaġek nabë sënë!” ");
INSERT INTO bzh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Loḳ Yesu peggirin melë yi hur maluh pin, genër Pita bë, “Honġ Satan! Gwevuu sa geġena! In su kwam töḳ raḳ Anutu kwa rë, gaḳ mu kwam nevo nġaa nebë sën mehönon yö kwaj nevo lo.” ");
INSERT INTO bzh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Lob supin alam yu böpata saga deyam ving yi hur maluh benër vu sir bë, “Mehöti bë natu sa hur, og kwa birekin yi gekerë yi ḳelepeḳo* metamuin sa. ");
INSERT INTO bzh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mehöti bë kwa bo yi begeġin nivesa, og rëḳ anon mala nama, gaḳ mehöti bë kwa birek in yi benadiiḳ in sa los Bengö Nivesa, og rëḳ medo mala-tumsën. ");
INSERT INTO bzh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Gaḳ nabë mehöti yö geḳo yi jaḳ in nġaa dob yi pin bemedo loḳ nadiiḳ, og yi nġaa sënë rëḳ doḳ vu yi nabë va? ");
INSERT INTO bzh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ma mehönon rëḳ debaġo Anutu jaḳ va in gevonġ bedemedo malaj-tumsën-a? Ma! ");
INSERT INTO bzh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Alam sën denedo dob agi sir mehönon nij paya los deneruu demij vu Anutu, om nabë sir ti ninamum in sa los sa ġaġek vu dob sënë, og vu Buk-tamusën sën Mehönon Nalu nom los Ama yö niwëëk geyi vuneḳ vuneḳ yaġek yi geyi angër vabuung lo, og rëḳ ninamum in mehö saga doḳ nah.” ");
INSERT INTO bzh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Lob Yesu nër vu sir ving bë, “Sa nanër vu ham yönon nabë: Ham sën nare agi vahi su rëḳ denadiiḳ rë, gaḳ rëḳ nahën demedo medegelë gAnutu yi nyëġ anon jaḳ los niwëëk.” ");
INSERT INTO bzh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nahub gebuk nemadvahi-bevidek-ti ya ggovek rë, loḳ Yesu ḳo Pita lööho Yakobus lu Jon beli lööho belosho deya ḳedu ading ti beyö ya denedo. Lob Yesu nare loḳ lööho malaj, lom lööho delë genavi agga ngwë raḳ, ");
INSERT INTO bzh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","geyi tob veroo meris genepelibin, mehöti su yoh vu bë jipek tob ti meveroo jaḳ nabë sënë rë. ");
INSERT INTO bzh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Lob delë Elia luho Moses yam denare ving yi gelööho denevengwënġ. ");
INSERT INTO bzh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Lom Pita nër vu Yesu bë, “Sa alaġ-e! He nado mehalë nġaa sënë om mëm nivesa rot, om he dev numeng löö, ti vu honġ, gengwë vu Moses ga, ngwë vu Elia.” ");
INSERT INTO bzh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Lööho deneggöneng in sir rot, om sën Pita vengwënġ pevis benër nebë saga gesu kwa vo nivesa rë. ");
INSERT INTO bzh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Loḳ pevis bebeggob ti yam ggërin sir, log aye ti yam loḳ beggob lo ayo bë, “Sa naluġ yiḳ sënë sën sahëġ neving yi lo, om ham gwebë nengamin vu yi.” ");
INSERT INTO bzh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nebë saga loḳ pevis belööho malaj neḳo loḳ nyëġ rëḳ su delë mehöti rë. Gaḳ Yesu perurek timu yö nare ving sir. ");
INSERT INTO bzh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Lob nahën deneluḳ medeneyam vu ḳedu genër niwëëk vu lööho bë su denanër nġaa sën delë lo ranġah. Gaḳ yö gëp rot bemëm Mehönon Nalu kedi jaḳ nah vu bedub rë, loḳ mëm. ");
INSERT INTO bzh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Lom devonġ yoh vu yi ġaġek sënë, loḳ yö yom medo denesap sir raḳ medenër bë, “Kedi jaḳ nah vu bedub sën nabë va?” ");
INSERT INTO bzh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Lom deloḳ tepëḳ vu yi bë, “Rëḳ nebë va sën alam-horek-yi denër bë Elia namuġin menom dob-ë?” ");
INSERT INTO bzh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Lob Yesu nër yah vu sir bë, “Yönon, Elia namuġin menom in gero nġaa pin nah. Loḳ maḳ ġaġek va ti sënë sën dekevu meneggëp loḳ Anutu-yi-ḳapiya bë mehönon rëḳ debo vanë vu Mehönon Nalu bedegeruu demij vu yi-ë? ");
INSERT INTO bzh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Om mëm sa nanër vu ham nabë Elia yom ggovek, rëḳ mehönon devonġ nġaa nipaya vu yi yoh vu yö kwaj, nebë sën dekevu wirek meneggëp loḳ Anutu-yi-ḳapiya lo.” ");
INSERT INTO bzh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Lob yah deto vu yi hur maluh vahi lo, lob delë gemehönon nġahiseḳë ya detetup sir, gelosho alam-horek-yi denemehoo sir. ");
INSERT INTO bzh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ya meto detöḳ vu sir, lob alam pin delë Yesu bedelëk in yi, lom pevis medeseröġ medeya vu yi in bë denajom nema. ");
INSERT INTO bzh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Lob loḳ tepëḳ vu sir bë, “Ham hök ham in ġaġek re?” ");
INSERT INTO bzh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Loḳ sir ti aye raḳ menër yah vu bë, “Tatovaha! Sa haḳo naluġ ti sën yam vu honġ in memö kwa nġengöleng ti gwanġ ya ayo, lom su nevengwënġ rë. ");
INSERT INTO bzh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Loḳ buk sën memö negwanġ ya yi, og nepengah yi raḳ dob, log nyë ḳataḳ netunġ genevu nengitek geni neköpeḳ, om sën sa haḳo meyam. Sa ḳetaġ vu honġ hur maluh sënë bë degetii memö geto mena in, rëḳ ma gesu deyoh vu rë.” ");
INSERT INTO bzh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Lob Yesu nër yah vu sir bë, “O ham mehönon sën nedo dob-ë! Ham su nevonġ ving sa rë! Om maḳ sëḳ medo geving ham buk va la geving-a? Gesëḳ medo ḳerë ham maggin noh vu kwev va la geving-a? Om maam ham gweḳo hurmahen nam vu sa rë!” ");
INSERT INTO bzh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Lob deḳo maluh mahen sënë ya vu yi, lob memö nelë Yesu, lob pevis mevonġ behurmahen vës meto nesap nyëġ meggëp neyon yi genyë ḳataḳ netunġ. ");
INSERT INTO bzh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Loḳ Yesu loḳ tepëḳ vu ama bë, “Nġaa sënë töḳ vu yi nangërek-a?” Rëḳ bë, “Yö nahën niḳöḳ lob vonġ, genevonġ menesepa loḳ rot. ");
INSERT INTO bzh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nevesi yi raḳ nengwah los netë yi luḳ ya bël beron nġahiseḳë bebë nadiiḳ. Rëḳ mëm nabë ġeyoh vu, og mëm kwam paya in aluu meġedoḳ vu.” ");
INSERT INTO bzh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Loḳ Yesu nër yah vu yi bë, “Mu nabë nġo ġeyoh vu, og mëm! In alam sën ayoj neya timu vu Anutu lo, og deyoh vu bë degevonġ nġaa pin.” ");
INSERT INTO bzh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Lob ama pevis besu bë, “Yiḳ sayoġ neyök vu honġ mahen teka mu, rëḳ mu nabë mëm ġedoḳ vu sa, og sëḳ ayoġ nök timu vu honġ panġsën.” ");
INSERT INTO bzh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu lë bë alam nġahiseḳë desupin sir ya vu yi rot, lom pevis menër memö nipaya sën lo bë, “Honġ memö kwam nġengöleng los malam ḳenod! Sa nanër vu honġ nabë: Gwevuu hurmahen sënë gegweto ġena, gesu ġedoḳ nah gökin!” ");
INSERT INTO bzh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Lob memö nġeeḳ gesesö yi rot loḳ hurmahen, log mëm to meya gehurmahen niköpeḳ meneggëp nebë heljënġ, lom alam nġahiseḳë denër bë, “Diiḳ ya veröḳ yi!” ");
INSERT INTO bzh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Rëḳ Yesu jom loḳ nema beḳo yi raḳ gemëm kedi raḳ. ");
INSERT INTO bzh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Log Yesu raḳ yah begganġ belosho yi hur maluh yö denedo, lob deloḳ tepëḳ vu yi bë, “Nebë va sën he su ayoh vu bë ġetii memö sënë geto mena rë-ë?” ");
INSERT INTO bzh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Loḳ nër yah vu sir bë, “Su aggata ngwë neggëp in bë hil ġetii memö nabë sënë geto dena rë, gaḳ hil najom jaḳ mu og mëm!” ");
INSERT INTO bzh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ggovek gedekedi vu nyëġ saga bedeya raḳ meya deneḳo loḳ distrik Galilea, lom vun yi in bë alam su dejaḳ nyëġ sën nedo loḳ lo ni. ");
INSERT INTO bzh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","In netateḳin ġaġek vu yi hur maluh benenër vu sir bë, “Rëḳ degetunġ Mehönon Nalu doḳ na mehönon nemaj, log dengis yi menadiiḳ. Dengis yi menadiiḳ govek gebuk löö jaḳ, loḳ mëm kedi jaḳ nah gökin.” ");
INSERT INTO bzh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lob sir duġin ġaġek sënë rëḳ deneggöneng gesu deneloḳ tepëḳ in vu yi rë. ");
INSERT INTO bzh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Lob yah deverup Kapernaum medeloḳ ya begganġ ayo ggovek, loḳ mëm loḳ tepëḳ vu yi hur maluh lo bë, “Sën hil nahën netetuu aggata menayam lo, log ham nevengwënġ raḳ va?” ");
INSERT INTO bzh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Loḳ ayej ma rot in ġaġek sën denesap sir raḳ lo. In denenër bë sir ti tena maḳ yi böp kesuu sir vahi. ");
INSERT INTO bzh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Loḳ to nedo gesupin sir nemadluho-bevidek-luu lo yam benër vu sir bë, “Bë ham ti gevonġin nabë natu ham mehö böp ti begeġin ham, og mehö saga dahun yi benah natu mehö meris bedoḳ vu alam pin loḳ mëm.” ");
INSERT INTO bzh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Lob ḳo hurmahen ti bevarah yi loḳ sir vuheng atov gelah nema loḳ yi genër vu sir bë, ");
INSERT INTO bzh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nabë mehöti kwa bo sa begevonġ nivesa vu hurmahen nabë ti sënë, og sënëḳ vonġ vu sa; log bë mehöti gevonġ nivesa vu sa, og su vonġ vu sa mu rë, gaḳ vonġ vu Mehö sën vonġ sa meseyam lo ving.” ");
INSERT INTO bzh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Lob Jon nër vu Yesu bë, “Tatovaha! He halë mehöti genenër arëm los niwëëk benetii memö to deneya, loḳ he nërin yi, in hil los su nesepa hil rë!” ");
INSERT INTO bzh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Loḳ Yesu nër yah vu yi bë, “Ham su nanërin yi rë! Gaḳ bë mehöti gevonġ nġaa böp jaḳ sarëġ, og maḳ su rëḳ nanër ġaġek nipaya jaḳ sa rë. ");
INSERT INTO bzh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","In mehöti sën su nelë hil paya rë lo, og neloḳ vu hil. ");
INSERT INTO bzh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sa nanër vu ham yönon nabë: Bë mehöti bo bël kul beham nanum, in Kerisi-yi-alam ham, og sënë su rëḳ gevonġ vu ham nyëmasën rë.” ");
INSERT INTO bzh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Log Yesu nër ving bë, “Nabë mehöti tahu sa alam sën ayoj neyam vu sa mahen teka mu lo ti begevonġ nġaa nipaya, og rëḳ geḳo nyëvewen böpata rot vu tamusën. Gaḳ nabë deseyu ġelönġ böpata doḳ kwa namuġin bedegetë duḳ na loo vuheng bemala nama na, og mëm nivesa in su kepë mehönon la. ");
INSERT INTO bzh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Log nabë nemam gevonġ benġaa nipaya kepë honġ, og maam kwetöv na, geyiḳ ġemedo jaḳ nemam vahi ti in ġena ġemedo malam-tumsën gëp Anutu yi Nyëġ. Gaḳ nabë ġemedo los nemam vahi vahi, og rëḳ degetë honġ doḳ na Nyëġ Nipaya sën nengwah medo mega honġ gesu rëḳ nakul rë lo. ");
INSERT INTO bzh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nyëġ Nipaya sënë, og melë medo mega sir noh vu buk pin gesu rëḳ denadiiḳ rë, genengwah su rëḳ nakul rë. ");
INSERT INTO bzh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Log nabë vaham geli honġ na begwevonġ nġaa nipaya, og maam kwetöv na, geyiḳ ġemedo los vaham vahi ti in ġena ġemedo malam-tumsën gëp Anutu yi Nyëġ. Gaḳ nabë ġemedo los vaham vahi vahi, og rëḳ degetë honġ doḳ na Nyëġ Nipaya sën nengwah medo mega honġ lo. ");
INSERT INTO bzh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nyëġ Nipaya sënë, og melë medo mega sir noh vu buk pin gesu rëḳ denadiiḳ rë, genengwah su rëḳ nakul rë. ");
INSERT INTO bzh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Log nabë malam gevonġ benġaa nipaya kepë honġ, og maam ġeselupek vër megwetë na, geyiḳ ġemedo los malam vahi ti in ġena ġemedo malam-tumsën gëp Anutu yi Nyëġ. Gaḳ nabë ġemedo los malam vahi vahi, og rëḳ degetë honġ doḳ na Nyëġ Nipaya sën nengwah medo mega honġ lo. ");
INSERT INTO bzh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Vu nyëġ sënë, og ‘melë medo mega sir noh vu buk pin gesu rëḳ denadiiḳ rë, genengwah su rëḳ nakul rë.’ ");
INSERT INTO bzh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Rëḳ debo vanë vu mehönon pin nabë sën alam Yuda denekevu mamireng raḳ sipsip gedenevesi netu seriveng vu Anutu lo. ");
INSERT INTO bzh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mamireng og nġaa nivesa, rëḳ mu nabë mamireng nimöḳ jaḳ, og hil rëḳ ġevonġ benengën jaḳ nah nabë va? Nġaa niröp gëp doḳ ham ayomin nabë mamireng, log ham medo los ġaġek-mala-yes.” ");
INSERT INTO bzh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu kedi vu saga beyah vaseḳ bël Yordan geya distrik Yudea, lob alam nġahiseḳë desupin sir medeya vu yi ggökin, loḳ netateḳin ġaġek vu sir ggökin nebë sën yö medo nevonġ yoh vu buk lo. ");
INSERT INTO bzh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Lob Parisai* la deverup in bë deseggi yi, lom deloḳ tepëḳ vu yi bë, “Hil horek nër bë yoh vu bë mehöti nidëlin venë ma ma?” ");
INSERT INTO bzh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Loḳ Yesu loḳ tepëḳ yah vu sir bë, “Moses vo horek vu ham nebë va?” ");
INSERT INTO bzh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Lom denër bë, “Moses nër bë yoh vu bë mehöti kevu ḳapiya-vepulsën-yi ti nabë ‘Su sa venëġ honġ rë!’, log mëm juuk venë na.” ");
INSERT INTO bzh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Loḳ Yesu nër vu sir bë, “Ham ayomin niwëëk, om sën Moses vo horek ti sën vu ham. ");
INSERT INTO bzh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Gaḳ Anutu tunġ maluh gavëh vu nyëdahis sën netunġ dob los nġaa pin lo. ");
INSERT INTO bzh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Om maluh rëḳ gevuu ama lu ata, log geḳo venë, lob luho denatu anon timu. ");
INSERT INTO bzh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Yönon, luho denatu anon timu. Luho su rëḳ nabë luho luu gökin rë, gaḳ denatu anon timu. ");
INSERT INTO bzh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Om nġaa sën Anutu duu ahon ggovek lo, og mehönon su debepul.” ");
INSERT INTO bzh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Loḳ mëm deraḳ yah hir begganġ vavunë, lob yi hur maluh deloḳ tepëḳ yah vu yi in ġaġek sënë ggökin. ");
INSERT INTO bzh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Lom mëm nër vu sir bë, “Bë maluh ti nidëlin venë gegeḳo avëh ngwë natu venë, og mehö sënë nevonġ baggëb bevonġ paya vu venë soġek. ");
INSERT INTO bzh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Log bë avëh ti nidëlin regga megevuu na, log na mejaḳ vu maluh ngwë natu regga, og avëh sënë nevonġ baggëb.” ");
INSERT INTO bzh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Lob mehö la deḳo hurmahen mahen medeyam vu yi in bë gebë nema jaḳ sir, loḳ yi hur maluh deruuk sir. ");
INSERT INTO bzh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Loḳ Yesu lë bë denevonġ nebë sënë, lom ahë sengën genër vu sir bë, “Ham gwevonġ hurmahen denam vu sa, ham su gwërin sir! In alam sën ayoj neyam timu vu sa nebë hurmahen, og rëḳ demedo doḳ Anutu-yi-nyëġ. ");
INSERT INTO bzh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sa nanër vu ham yönon nabë: Bë mehöti sën su ayo na timu vu Anutu-yi-nyëġ nabë hurmahen rë lo, og su yoh vu bë doḳ na rë.” ");
INSERT INTO bzh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Lom mëm neḳo hurmahen raḳ menetabuu sir, log bë nema raḳ sir gejom raḳ vu Anutu in sir bë semu sir. ");
INSERT INTO bzh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu kedi in bë na jaḳ, loḳ mehöti seröġ meyam ggërin yi geyun lus vu yi, log loḳ tepëḳ in bë, “Tatovaha! Honġ mehö nim vesa anon! Sa ġevonġ nabë va in sa medo malaġ-tumsën degwata los degwata?” ");
INSERT INTO bzh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Loḳ Yesu loḳ tepëḳ yah vu yi bë, “Ġënër sa bë sa niġ vesa in va? Yiḳ Anutu yö timu nivesa! ");
INSERT INTO bzh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ġeraḳ Anutu yi horek sënë ni nebë: Su ġengis mehönon medenadiiḳ! Su gwevonġ baggëb! Su ġeġodeḳ nġaa! Su ġenanër ġaġek kuungsën jaḳ mehö ngwë! Su gwekuung in mehönon geġebo hir nġaa vër! Ġeġurek amam lu atam babuj!” ");
INSERT INTO bzh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Lob mehö sënë nër yah vu Yesu bë, “Tatovaha! Sënëḳ senġo nahën hurmahen log sa nesepa loḳ horek pin sënë, rot beverup gwëbeng sagi.” ");
INSERT INTO bzh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Lob Yesu lë yi bahë ving yi, lob nër vu yi bë, “Genġaa ti nahën! Ġena gwevonġ honġ ḳupeḳ pin na bemehönon debaġo, lob gwevonġ monë sën gweḳo jaḳ lo na vu alam sën deneraḳ vu in nġaa lo. Gwevonġ nabë sënë, log mëm ġenam ġesepa sa, gemëm honġ ḳupeḳ nivesa rëḳ gëp vu yaġek.” ");
INSERT INTO bzh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mehö sënë nġo ġaġek sënë, lom mala seluh geyah meya los ayo maggin in yi ḳupeḳ nġahiseḳë rot. ");
INSERT INTO bzh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Lom Yesu mala ḳo loḳ sir, log nër vu yi hur maluh bë, “Alam sën hir ḳupeḳ nġahiseḳë lo bë dedoḳ na Anutu-yi-nyëġ, og rëḳ debimengin.” ");
INSERT INTO bzh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Lob yi hur maluh delëk mederanġa nemaj in yi ġaġek sënë, loḳ Yesu nër yah ggökin vu sir bë, “Naluġ lo! Alam bë dedoḳ na Anutu-yi-nyëġ, og rëḳ huk böp vu sir. ");
INSERT INTO bzh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nabë kamer ti gurek na rureḳ len, og yiḳ huk böpata rot, rëḳ mu nabë mehö-los-bengö-ggoreksën ti gevonġin nabë doḳ na Anutu-yi-nyëġ, og sagaḳ huk böpata rot kesuu.” ");
INSERT INTO bzh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lob yi hur maluh ḳenuj ya in, geyö deloḳ tepëḳ vu sir bë, “Om maḳ re yoh vu bë rëḳ na medo mala-tumsën-a?” ");
INSERT INTO bzh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Lob Yesu gët sir genër bë, “Mehönon su deyoh vu bë degevonġ beyö demedo malaj-tumsën rë, gaḳ Anutu yö yoh vu bë gevonġ. In Anutu yoh vu bë gevonġ nġaa pin.” ");
INSERT INTO bzh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Loḳ Pita nër yah vu yi bë, “Gwelë! He hevuu he nġaa pin ya gehë yam medo nesepa honġ!” ");
INSERT INTO bzh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Lob Yesu nër bë, “Sa nanër vu ham yönon nabë mehöti sën gevuu ben gari losho avëhnö lo, gata losho ama genalu lo geyi dob, in sa los sa Bengö Nivesa sënë lo, ");
INSERT INTO bzh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","og vu buk sënë rëḳ geḳo mehödahis jaḳ gëp alam nemadvahi doḳ nah yi begganġ gari lo avëhnö lo, ata lo nalu lo, geyi dob. Log rëḳ geḳo vanë geving, gevu Buk-tamusën rëḳ medo mala-tumsën degwata los degwata. ");
INSERT INTO bzh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Rëḳ mu alam nġahijseḳë vu muġinsën, rëḳ nom denatu alam tamusën, galam nġahijseḳë vu tamusën rëḳ nah denatu muġinsën.” ");
INSERT INTO bzh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Lob detetuu aggata beya deverup in bë dena Yerusalem. Yesu muġin meya, lob yi hur maluh newaj neraḳ, galam sën denesepa yi lo deneggöneng in sir. Loḳ Yesu supin sir nemadluho-bevidek-luu lo ggök yahin benër nġaa sën rëḳ natöḳ vu yi lo ranġah vu sir. ");
INSERT INTO bzh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Bë, “Ham nġo! Gwëbeng hil naraḳ menaya Yerusalem, lom mëm rëḳ degetunġ Mehönon Nalu doḳ na alam-deneḳo-seriveng hir ggev lo los alam-horek-yi lo nemaj, lom rëḳ degevonġ ġaġek vu yi bedenanër nabë nadiiḳ, log degevonġ doḳ na alam-yu-ngwë nemaj ");
INSERT INTO bzh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","in depelë yi gedepesuv nyëj ḳos jaḳ yi gedebeek yi jaḳ aggis, log mëm dengis yi menadiiḳ. Gebuk natu löö loḳ kedi jaḳ nah gökin.” ");
INSERT INTO bzh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Lob Sebedi nalu Yakobus luho Jon verup deya vu Yesu medeloḳ tepëḳ vu bë, “Tatovaha! Alu bë ḳetaġ ġaġek ti vu honġ in gwevonġ vu aluu.” ");
INSERT INTO bzh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Loḳ Yesu loḳ tepëḳ yah vu luho bë, “Melu kwamin nevo bë sa ġevonġ nabë va vu meluu-a?” ");
INSERT INTO bzh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Loḳ luho denër yah bë, “Ġenanër vu aluu in tamusën sën rëḳ ġemedo los nim wëëk böpata gevuneḳ vuneḳ yaġek yi lo, og mëm alu natu honġ ġadu bemedo kwebem vahi vahi. Aluu ngwë medo nemam vesa, gengwë medo nemam ḳëj.” ");
INSERT INTO bzh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Rëḳ Yesu nër yah vu luho bë, “Meluu duġin ġaġek sën melu nekwetaġ in vu sa-ë degwa! Ma melu yoh vu bë melu rëḳ nanum doḳ kap* sën sëḳ nanum doḳ lo? Ma melu yöh vu bë rëḳ jipek bël nabë sën sëḳ jipek doḳ lo?” ");
INSERT INTO bzh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Loḳ luho deyoġekin bë, “Alu ayoh vu!” Lob mëm Yesu nër vu luho bë, “Melu nër yönon! Kap* sën sëḳ nanum doḳ lo, og melu rëḳ nanum doḳ, gemelu rëḳ jipek bël nabë sën sëḳ jipek lo. ");
INSERT INTO bzh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Rëḳ mu mehö sën rëḳ medo gëp sa nemaġ vesa, gemehö sën rëḳ medo sa nemaġ ḳëj lo, og su neggëp vu sa rë. Gaḳ alam sën Amaġ yö ggooin sir raḳ lo, sën rëḳ demedo doḳ.” ");
INSERT INTO bzh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Lob sir nemadluho denġo luho hir ġaġek sënë, lob ahëj sengën vu Yakobus luho ari Jon. ");
INSERT INTO bzh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Rëḳ Yesu supin sir genër vu sir bë, “Ham raḳ alam dahis nij bë hir alam sën deneġin sir lo, og deneḳo sir raḳ vu hir alam, gehir alam böp denedeġinengin hir alam raḳ horek nġahi. ");
INSERT INTO bzh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Rëḳ mu ham, og ham su gwevonġ nabë sënë. Gaḳ bë ham ti gevonġin nabë natu ham mehö böp ti, og gevonġ nġaa nabë sën tu ham hur in doḳ vu ham, ");
INSERT INTO bzh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","log bë ham ti gevonġin nabë natu ham mehö muġinsën ti, og gevonġ nġaa nabë sën yi mehö meris lo, begevonġ huk nyëmasën vu ham pin. ");
INSERT INTO bzh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","In Mehönon Nalu yiḳ nebë sënë. Su yam in bë mehönon pin degevonġ huk mededoḳ vu yi rë, gaḳ yam in bë gevonġ huk vu mehönon pin los nadiiḳ doḳ nah alam nġahiseḳë bej in geḳo sir nah vu Anutu. ");
INSERT INTO bzh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu losho yi hur maluh ya detöḳ ya Yeriko gedekesuu medeneya. Geyi hur maluh losho alam nġahiseḳë deneya ving yi. Loḳ ya verup detöḳ vu Timaius nalu Bartimaius mala ḳenod menedo loḳ aggata nenga, bemedo neketaġ monë lu nġaa vu alam bë dedoḳ vu yi. ");
INSERT INTO bzh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Lob nġo Yesu Nasaret bengö nebë verup, lob tahi ya niwëëk bë, “Yesu! Davit*-yi-mewis honġ! Kwam gevonġin sa!” ");
INSERT INTO bzh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Loḳ alam pin saga depetupek raḳ yi medenër bë aye nama. Rëḳ ma gepasanġ netahi niwëëk rot bë, “Davit*-yi-mewis! Kwam gevonġin sa!” ");
INSERT INTO bzh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Lob Yesu nare benër vu sir bë, “Nabë nam!” Lob detahi yam bedenër vu bë, “Ayom sepëp jaḳ! Tahi honġ, om kwedi jaḳ meġena vu!” ");
INSERT INTO bzh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Lob selevekin yi röpröp sën bom yi loḳ lo ya, gekedi pesönġ meya vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Loḳ Yesu loḳ tepëḳ vu yi bë, “Ġevonġin bë sa ġevonġ va vu honġ-a?” Loḳ mehö sën mala ḳenod lo nër yah vu bë, “Mehöböp! Sa bë gwevonġ sa malaġ natum in sa ġalë nyëġ gökin!” ");
INSERT INTO bzh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Lom mëm Yesu nër vu yi bë, “Om ġena! Ayom yam timu vu sa, om vonġ bemalam nivesa raḳ!” Lob pevis menelë nyëġ, loḳ mëm tetuu aggata metamuin Yesu. ");
INSERT INTO bzh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Lob ya deverup dus vu Yerusalem meya deto Betpage los Betania ggëp Ḳedu Ḳele-oliv, lob vonġ yi hur maluh luu deya, ");
INSERT INTO bzh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","genër vu luho bë, “Melu na begganġ-bu ti sën melu malamin neya agu. Lob melu na berup aggatavi loḳ melu rëḳ gwelë nabë deseyu dogi nalu ti menare loḳ sagu. Dogi nalu ti sën su mehöti raḳ wirek rë geyö nahën nare, lob melu kwevelekin begweli nom. ");
INSERT INTO bzh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Genabë mehöti bare gelë meluu, bedoḳ tepëḳ vu meluu nabë, ‘Melu nevonġ va saga?’ og melu nanër nah vu nabë, ‘Mehöböp bë jaḳ mena!’ lob mëm rëḳ gevonġ nam pevis.” Nër vu luho nebë saga, log vonġ luho ya. ");
INSERT INTO bzh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Luho deya lob detöḳ vu dogi nalu yoh vu sën nër lo. Deseyu meloḳ nare aggatavi benare ranġah loḳ aggata böp, lom luho dekevelekin. ");
INSERT INTO bzh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Galam vare denelë luho, lob deloḳ tepëḳ vu luho bë, “Melu gwevonġ va vu dogi nalu saga sën melu nekwevelekin-ë?” ");
INSERT INTO bzh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Rëḳ luho denër Yesu aye vu sir, lom mëm delëëin dogi ya vu luho. ");
INSERT INTO bzh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Lob luho deli dogi nalu yah verup vu Yesu, log delah hir röpröp raḳ demi, log mëm Yesu raḳ ya nedo. ");
INSERT INTO bzh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lob alam nġahiseḳë dekah hir tob medevah loḳ aggata, gesir vahi deneseröġ medeneya aggata vahi vahi medenesap ḳapah medenevah aggatata ving, geYesu neraḳ dogi meneggök. ");
INSERT INTO bzh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Lob alam sën denemuġin gesën denetamuin yi lo denepisek in medenetahi bë, “Hosana! Anutu gevonġ semusemu vu mehö sën neyam los Mehöböp niwëëk. ");
INSERT INTO bzh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Anutu semu hil ḳenud Davit yi buk sënë, sën vonġin nom berup vu hil gökin. Om hil ġaḳo Anutu arë jaḳ na vavunë!” ");
INSERT INTO bzh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Lob Yesu ya metöḳ ya Yerusalem beloḳ ya Anutu yi dub-vabuung-böp beḳo loḳ belë nġaa pin, loḳ hes mala ggovek ya lom losho yi hur maluh nemadluho-bevidek-luu lo to deyah dobnë medeyah medeya Betania. ");
INSERT INTO bzh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Heng to lob sir vu Betania medeyam lom diiḳahë, ");
INSERT INTO bzh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","lob nelë ḳele pik* ti nare adingnë geris nġahiseḳë rot, lob ya dus in bë sero anon. Ya deverup vu lom lë rëḳ ris meris ganon ma, in yi buk nahën gesu nesis anon rë. ");
INSERT INTO bzh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Lob nër vu ḳele bë, “Su rëḳ ġengis anom bemehönon dega gök nahin rë!” Geyi hur maluh vare denenġo nebë sënë. ");
INSERT INTO bzh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yah deverup Yerusalem, lob loḳ yah Anutu yi dub-vabuung-böp ggökin, lob tii alam sën denevonġ huk baġosën loḳ lo. Log keyoveḳin alam sën denepekwë* monë lo hir tevor, los alam sën denetunġ nuung in bë alam debaġo bedebesi natu hir seriveng lo hir sëa. ");
INSERT INTO bzh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Log nërin mehönon pin bë su degeḳo hir nġaa medenah medenom nabë aggata doḳ dub vabuung. ");
INSERT INTO bzh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Log nër vu sir bë, “Ġaġek neggëp loḳ Anutu-yi-ḳapiya nebë: ‘Sa begganġ og rëḳ denanër nabë begganġ-jom-raḳsën-yi in mehönon vu dob pin denajom jaḳ doḳ.’ Rëḳ ham vonġ beyah tu alam hodeḳ bej waaḳ vunsën raḳ.” ");
INSERT INTO bzh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Lob alam-deneḳo-seriveng hir ggev losho alam-horek-yi sën denġo bë Yesu nër ġaġek nebë sënë lob desero aggata in bë dengis yi menadiiḳ. In deneggöneng in yi, in alam pin avij netöḳ in yi ġaġek bemedo denenġo. ");
INSERT INTO bzh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nebë saga lob hes luḳ ya lob devuu Yerusalem ya gedeyah. ");
INSERT INTO bzh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lob monbuk loḳ yom deverup, loḳ delë ḳele pik* sënë bë meran ya. Ris meran geġeġa gilin gebebov ya. ");
INSERT INTO bzh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Lob Pita kwa vo Yesu yi ġaġek menër vu bë, “Tatovaha! Gwelë! Ḳele pik* sën ġeterot lo meran bebebov ya!” ");
INSERT INTO bzh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Loḳ Yesu nër yah vu sir bë, “Ham gwevonġ geving Anutu! ");
INSERT INTO bzh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sa nanër vu ham yönon nabë: Bë mehöti nanër vu ḳedu sënë nabë, ‘Kwedi gwetë honġ duḳ na loo vuheng!’ gesu medo ayo luu luu rë, gaḳ gevonġ geving nabë yi ġaġek sënë rëḳ anon jaḳ, og rëḳ anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Om sa nanër vu ham nabë: Nġaa sën ġenejom raḳ meġenekwetaġ in vu Anutu lo, og gwevonġ geving yi nabë rëḳ gweḳo anon, og rëḳ bo vu honġ yönon. ");
INSERT INTO bzh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Log nabë ham bare najom jaḳ na vu Anutu, rëḳ ham ahëmin sengën neggëp vu mehö la, beham kwamin nevo nebë devonġ nġaa nipaya vu ham, og ham dahun hir nġaa nipaya sën lo na benama na veröḳ yi, geham su kwamin bo gök nahin. Ham gwevonġ nabë saga, og mëm ham Amamin sën nedo yaġek lo rëḳ dahun ham hömin nġaa nipaya na geving. ");
INSERT INTO bzh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Gaḳ nabë ham su dahun hir nġaa nipaya na rë, og ham Amamin sën nedo yaġek lo su rëḳ dahun ham nġaa nipaya na rë, gaḳ yö rëḳ gëp vu ham.” ");
INSERT INTO bzh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Lob ya detöḳ yah Yerusalem lob neḳo loḳ Anutu yi dub-vabuung-böp lo ggökin, lob alam-deneḳo-seriveng hir ggev, galam-horek-yi los alam teta detöḳ vu yi. ");
INSERT INTO bzh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Lob deloḳ tepëḳ vu yi bë, “Re vo niwëëk vu honġ benër bë gwevonġ huk nabë sënë? Re ggooin honġ raḳ-a?” ");
INSERT INTO bzh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Loḳ Yesu nër yah vu sir bë, “Kë, om sa bë doḳ tepëḳ in ġaġek ti nök vu ham rë, loḳ nabë ham nanër nom, og mëm sëḳ nanër mehö sën ggooin sa raḳ in bë sa ġevonġ huk agi nök vu ham. ");
INSERT INTO bzh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ham nanër ġaġek sënë vu sa rë nabë: Jon neripek alam, og yam vu yaġek, ma, sepa loḳ mehönon vu dob kwaj?” ");
INSERT INTO bzh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Lom yö yah denesap sir raḳ medenenër vu sir nebë, “Bë hil nanër nabë yam vu yaġek, og rëḳ doḳ tepëḳ nom nabë, ‘Rëḳ nebë va sën ham su vonġ ving yi rë-ë?’ ");
INSERT INTO bzh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Log nabë hil nanër nabë sepa loḳ mehönon vu dob kwaj...?” Rëḳ su yoh vu bë denanër ġaġek sënë rë, in deneggöneng in alam sën vare denenġo lo bë rëḳ dengis sir. In alam pin kwaj nevo Jon bë yi mehö-nenër-ġaġek-ranġahsën ti yönon. ");
INSERT INTO bzh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Lom denër yah vu Yesu bë, “He duġin degwa-o!” Loḳ Yesu nër yah vu sir bë, “Nebë saga, om sa su rëḳ nanër mehö sën ggooin sa raḳ lo vu ham rë!” ");
INSERT INTO bzh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Lob Yesu nër ġaġek peggirinsën ti vu sir bë, “Mehöti varoh huk wain ti, gejegelin ġelönġ netu heek, log semu nyëġ ti in napip wain anon doḳ. Log lev begganġ ading ti sën debare jaḳ medemalajin wain lo. Loḳ tum vo huk sënë loḳ ya mehö la nemaj in bë degeġin, loḳ mëm anon vahi natu yiyi gevahi natu hej. Ggovek log tah yi ya meya nyëġ ading ti meya nedo. ");
INSERT INTO bzh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Gebuk sën wain anon nemoneḳ lo dus raḳ, lob huk ala sënë nevonġ yi hur ti ya vu mehönon sën deneġin huk lo, in bë geḳo yi wain anon vahi. ");
INSERT INTO bzh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Rëḳ dejom yi ahon medeveek yi gedevonġ yi yah meya nema meris. ");
INSERT INTO bzh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Loḳ huk wain ala lo vonġ yi hur ngwë yah ggökin, loḳ desis yu raḳ beġö, bedevonġ paya vu yi rot. ");
INSERT INTO bzh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Lom yiḳ vonġ hur ngwë ya, loḳ desis yi mediiḳ ya; genevonġ yi hur nġahiseḳë deya ggök ggökin nebë saga, lob deneveek vahi, gedenesis vahi medenediiḳ. ");
INSERT INTO bzh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nebë saga lob yi hur pin maya geyiḳ nalu perurek timu sën ahë neving yi rot lo nahën nedo ving yi. Lom kwa vo nebë, ‘Sa naluġ sënë, om rëḳ degurek babu!’ lom vonġ yi ya raḳ neggëp hus. ");
INSERT INTO bzh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Rëḳ alam sën deneġin yi huk lo, yö denër vu sir nebë, ‘Mehö sënë rëḳ doḳ nah ama ben begeḳo yi nġaa pin, om ham-o! Hil angis yi menadiiḳ gehuk sënë natu hil nġaa!’ ");
INSERT INTO bzh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Lom dejom yi ahon medesis mediiḳ, log detë yah dobnë. ");
INSERT INTO bzh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nebë saga, om huk wain ala sënë maḳ rëḳ gevonġ nabë va vu sir-a? Rëḳ na bekevoh alam sën deneġin yi huk lo bemalaj nama na veröḳ yi, log mëm gevonġ huk sënë vu alam mewis la medegeġin. ");
INSERT INTO bzh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ma maḳ ham su tevin ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo rë? Nebë: ‘Alam sën denelev begganġ lo nij lëlin ġelönġ ti sënë. Rëḳ mu sënë netu ġelönġ niwëëk begganġ nyëḳetu yi. ");
INSERT INTO bzh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mehöböp vonġ sënë lom he halë bë nivesa rot!’” ");
INSERT INTO bzh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Lob alam Yuda hir ggev deraḳ ni bë nenër ġaġek peggirinsën raḳ sir, lom devonġ in bë denaduu yi na ḳarabus, rëḳ deggöneng in alam nġahiseḳë sën denedo lo, lom devuu yi gedeyah medeya. ");
INSERT INTO bzh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lob devonġ Parisai* la losho Herot* yi alam la to deya vu Yesu in bë deseggi yi, in bë nabë nanër ġaġek ti paya, og denajom yi ahon nabë sën mehönon denesis soḳ loḳ leḳ lo. ");
INSERT INTO bzh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ya deto vu yi lom deloḳ tepëḳ vu bë, “Tatovaha! He raḳ nim bë honġ mehö niröp, gesu ġenehöneng in mehönon meġenër ġaġek yah nenga rë! Gesu ġenehöneng in alam malaj rë, gaḳ ġenenër ġaġek neggëp ti vu alam meris gevu alam los arëj ving, log ġenatateḳin Anutu yi ġaġek vu alam los anon mu. Om ġenanër vu he rë nabë hil ġetë takës na vu alam Rom hir mehö-los-bengö Sisar* ma nama? Hil rëḳ ġetunġ ma hil su rëḳ ġetunġ rë?” ");
INSERT INTO bzh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Rëḳ Yesu raḳ nij bë kwaj luu, lom nër vu sir bë, “Ham neseggi sa in va? Ham gweḳo monë ġahis ti nam sa ġalë rë!” ");
INSERT INTO bzh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Lom deḳo ti ya vu, loḳ loḳ tepëḳ vu sir bë, “Re ḳenu los arë sën raḳ neggëp agi?” Rëḳ bë, “Sisar*!” ");
INSERT INTO bzh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Lom Yesu nër vu sir bë, “Om ham gwevonġ Sisar* yi nġaa nah vu Sisar*, log Anutu yi nġaa og ham bo nah vu Anutu!” Lob tum delëk rot gavij netöḳ in nër ġaġek sënë los kwa. ");
INSERT INTO bzh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Alam Sadukai* denenër bë alam-diiḳsën og su rëḳ dekedi jaḳ nah rë. Lob sir la deya vu Yesu medeloḳ tepëḳ vu yi bë, ");
INSERT INTO bzh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tatovaha! Moses kevu horek sënë vu hil meneggëp bë, ‘Bë mehöti ari ti nadiiḳ geyi alov nedo, rëḳ mu luho su deḳo naluj rë, og mëm ari geḳo yi alov natu venë meluho degeḳo naluj vu ari sën diiḳ lo’. ");
INSERT INTO bzh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Lob hur maġëm ti losho ari lo, sir nemadvahi-bevidek-luu denedo, lob arij aġuu ḳo avëh, ");
INSERT INTO bzh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","loḳ diiḳ geluho su deḳo naluj rë. Lom tum ari amon ḳo yi alov, rëḳ luho su deḳo naluj rë, log amon diiḳ ving. Log gwee nebë saga, ḳo alov rëḳ diiḳ geluho naluj ma. Beyiḳ sir pin devonġ nebë sënë metöḳ ya arij meggi, gesir pin naluj ma. ");
INSERT INTO bzh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Log avëh sënë diiḳ raḳ neggëp hus. ");
INSERT INTO bzh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Om ġenanër nabë najeeng sën mehönon diiḳsën dekedi jaḳ nah lo, og avëh sënë rëḳ natu arij ti tena venë? In sir pin deḳo avëh timu saga netu venëj.” ");
INSERT INTO bzh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Loḳ Yesu nër yah vu sir bë, “Ham duġin Anutu yi ġaġek sën neggëp loḳ yi ḳapiya lo, geham duġin Anutu niwëëk ving. ");
INSERT INTO bzh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Vu Buk-tamusën sën mehönon diiḳsën dekedi jaḳ nah lo, og maluh su rëḳ degeḳo avëh rë, gavëh su rëḳ dejaḳ maluh rë. Gaḳ rëḳ demedo nabë angër lo vu yaġek. ");
INSERT INTO bzh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ġaġek sën mehönon diiḳsën dekedi jaḳ nah lo, maḳ ham su tevin ḳapiya sën Moses kevu lo rë? Sën nengwah medo netum loḳ ḳele yu dabun ti log Anutu nër vu Moses bë, ‘Sa Abraham yi Anutu sa, gIsaak yi Anutu sa, geYakop yi Anutu sa!’ ");
INSERT INTO bzh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nabë alam-diiḳsën denadiiḳ bemalaj nama na veröḳ yi, og su yoh vu bë nanër nabë lööho hir Anutu yi rë. Gaḳ lööho denedo malaj-tumsën, in Anutu og alam malaj vesa los malaj-tumsën hir Anutu yi. Rëḳ ham nekwetul loḳ.” ");
INSERT INTO bzh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lob alam-horek-yi ti verup menġo bë denesap sir nebë sënë, lob nenġo bë Yesu nër ġaġek los kwa vu sir lom loḳ tepëḳ vu yi bë, “Horek ti tena sën kesuu horek vahi pin-a?” ");
INSERT INTO bzh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Loḳ Yesu nër yah bë, “Horek sën kesuu lo nebë: Honġ Israel! Gwenġo rë! Anutu sën hil Mehöböp lo, yiḳ Mehöböp perurek timu, ");
INSERT INTO bzh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","om ahëm geving Mehöböp honġ Anutu los ayom dahis. Ḳenum natu yi nġaa, gekwam los dahis na vu yi timu, gahëm geving yi los nim wëëk pin. ");
INSERT INTO bzh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lob horek böp ngwë sën netu luu nebë: Ahëm geving alam sën denedo dus vu honġ nabë sën nġo ahëm neving honġ lo. Behorek ngwë su kesuu horek luu sënë rë!” ");
INSERT INTO bzh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Loḳ mehö-horek-yi sënë nër yah vu yi bë, “Ġenër niröp, tatovaha! Ġenër yönon nebë Anutu yö timu, gAnutu ngwë su nedo rë. ");
INSERT INTO bzh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Log bë hil ahëd geving yi los ayod dahis gehil kwad los dahis na vu yi timu, gehil ahëd geving yi los nid wëëk, log hil ahëd geving alam sën denedo dus vu hil lo nabë sën hil nġo ahëd neving hil, og mëm nġaa sënë kesuu seriveng sën hil nehetunġ medenevesi vu Anutu lo los seriveng vahi pin.” ");
INSERT INTO bzh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Lom Yesu nġo bë mehö sënë nër ġaġek los kwa lom nër vu bë, “Su ġenedo ading in Anutu-yi-nyëġ rë!” Lob tum alam pin deggöneng in sir gesu deloḳ tepëḳ yah vu Yesu in ġaġek ngwë rë. ");
INSERT INTO bzh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Loḳ tum Yesu medo nenër ġaġek vu mehönon loḳ Anutu yi dub-vabuung-böp, loḳ loḳ tepëḳ bë, “Nebë va sën alam-horek-yi denenër Mehö sën Anutu ggooin raḳ in bë geḳo hil nah lo bë degwa vu Davit*-ë? ");
INSERT INTO bzh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Anon Vabuung vo kwa vu Davit menër bë: ‘Mehöböp nër vu sa Mehöböp nebë, “Ġemedo sa nemaġ vesa gevu tamusën og sëḳ ġetunġ alam sën denelë honġ paya lo dedoḳ na vaham ġebinë!” ’ ");
INSERT INTO bzh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yi degwa vu Davit*, loḳ nebë tena sën Davit nër yi bë yi Mehöböp-ë?” Lob alam nġahiseḳë rot denenġo yi ġaġek bekwaj vesa. ");
INSERT INTO bzh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Lob lev horek vu sir bë, “Ham gweġin ham in alam-horek-yi. In ahëj neving bë dejöp tob ading nivesa vesa, log ahëj neving bë alam debengwënġ vu sir bedegeḳo arëj jaḳ doḳ alam tabaaḳ, ");
INSERT INTO bzh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","gahëj neving bë demedo lël mala doḳ dub-supinsën-yi los jaḳ na dega nos namuġin gëp nyëġ-nos-böp-yi. ");
INSERT INTO bzh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Alam sënë su kwaj nevonġin avëh alov rë, gaḳ deneggodeḳ hir nġaa, log denejom raḳ hus ading meris mu raḳ alam malaj. Om nyëvewen rëḳ natöḳ vu sir mekesuu rot.” ");
INSERT INTO bzh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Log Yesu to nedo dus vu keröng sën denetunġ monë seriveng loḳ vu Anutu lo, benelë alam sën denetunġ lo. Lob lë mehönon los bengöj-ggoreksën nġahiseḳë gedenetunġ monë böpata loḳ ya keröng, ");
INSERT INTO bzh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","log avëh alov ti hen monë ma, lob yiḳ ḳo monë mahen ḳöḳ luu mu beto metunġ luḳ ya ving. Monë ḳöḳ luu sënë yoh vu bë nah natu toea ti. ");
INSERT INTO bzh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Lob Yesu supin yi hur maluh lo ya menër vu sir bë, “Sa nanër vu ham yönon nabë: Avëh alov ti sënë tunġ seriveng böpata rot kesuu seriveng pin sën alam denetunġ loḳ ya keröng-seriveng-yi lo. ");
INSERT INTO bzh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Senër nebë sënë in sir mehönon los bengöj-ggoreksën behir nġaa nġahiseḳë nedo vu sir, gaḳ sën denetunġ lo og yiḳ metes. Gaḳ avëh sënë og su hen vahi nedo rë, rëḳ yö keyoveḳin keröng ahë degwa raḳ metunġ yi nġaa pin tu seriveng gehen monë nos yi ma.” ");
INSERT INTO bzh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu vu dub-vabuung-böp ayo meluḳ yom, lob yi hur maluh ti nër vu yi bë, “Gwelë, tatovaha! Delev dub sënë raḳ ġelönġ malanġeri gedub böpata benivesa rot!” ");
INSERT INTO bzh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Lob Yesu nër vu bë, “Ġëlë begganġ böp böp sën delev raḳ ġelönġ agi? Su rëḳ degönengin ġelönġ ti gejaḳ medo ngwë vavunë rë. Gaḳ rëḳ dekevoh pin medegetë geto jeggin jeggin.” ");
INSERT INTO bzh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu ya nedo raḳ Ḳedu Ḳele-oliv, gAnutu yi dub-vabuung-böp nedo vahi yi, loḳ Pita losho Yakobus lu Jon gAndreas bedeya vu yi medeloḳ tepëḳ bë, ");
INSERT INTO bzh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ġenanër vu he nabë nġaa sën ġenër lo rëḳ anon jaḳ doḳ buk tena? Geva rëḳ tato vu he nabë nġaa sënë vonġin natöḳ nam-a?” ");
INSERT INTO bzh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Lob Yesu nër vu sir bë, “Ham gweġin ham in mehö la rëḳ detetuhin ham! ");
INSERT INTO bzh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Alam nġahiseḳë rëḳ denam medenanër sarëġ jaḳ nah sir nabë, ‘Mehö sën lo, yiḳ sa sënë!’ Lob rëḳ detetuhin alam nġahiseḳë medenah vu sir. ");
INSERT INTO bzh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Log ham rëḳ gwenġo beġö bengö galam denanër jeggin jeggin nabë vonġin berup, og ham su newamin jaḳ, in nġaa nebë sënë yö rëḳ nam, gaḳ Buk-tamusëneḳ yö rëḳ nahën. ");
INSERT INTO bzh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lob alam dob ngwë rëḳ dekedi belosho alam dob ngwë dengis sir, gemehö-los-bengö ngwë losho yi alam rëḳ dekedi belosho mehö-los-bengö ngwë losho yi alam dengis sir. Log jemapi rëḳ gee jaḳ dob la, gemeyip gevonġ mehönon vu dob la. Nġaa sënë nebë nivanë sën avëh denevimeng in degeḳo naluj lo. ");
INSERT INTO bzh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Om ham gweġin ham nivesa. In rëḳ degetunġ ham doḳ na kaunsor lo nemaj, gedebeek ham doḳ dub-supinsën-yi, geham rëḳ bare kiap böp losho alam-los-bengöj böp malaj in sa alam ham, lob ham nanër sa ranġah vu sir, ");
INSERT INTO bzh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","geham nanër Bengö Nivesa ranġah na menoh vu mehönon pin sën denedo dob-ë namuġin rë, loḳ mëm buk govek na. ");
INSERT INTO bzh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Lob bë denaduu ham medegeli ham na ḳarabus medegevonġ ham bare kot, og ham su newamin jaḳ pevis nabë, ‘Sëḳ nanër nabë va?’ Ma! Gaḳ doḳ buk saga ham rëḳ nanër noh vu ġaġek sën Anutu yö rëḳ gevonġ vu ham lo. In ham su nġo rëḳ kwamin bo ġaġek sënë benanër rë, gaḳ Anon Vabuung yö rëḳ gevonġ ġaġek sënë vu ham beham nanër. ");
INSERT INTO bzh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Lob alam rëḳ degevonġ arij lo doḳ na alam-beġö-yi nemaj medengis sir medenadiiḳ, log amaj rëḳ degevonġ naluj nabë, gehurmahen rëḳ degevonġ amaj los ataj doḳ na hir alam-beġö-yi nemaj medengis sir nadiiḳ, log alam pin rëḳ ahëj sengën vu ham in sa alam ham. ");
INSERT INTO bzh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Log mehönon sën denajom sa ahon medemedo los nij wëëk rot menatöḳ na buk sën denadiiḳ lo, og rëḳ Anutu geḳo sir nah vu yi.” ");
INSERT INTO bzh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Lob bë ham gwelë nġaa vabuung degwa nipaya bare doḳ nyëġ ti sën su yoh vu bë bare doḳ rë lo begevonġ paya vu, og alam sën denedo distrik Yudea lo debeya medena ḳedu pevis. (Bë mehöti natevin ḳapiya sënë, og yö kwa bo ġaġek sënë mejaḳ ni rë!). ");
INSERT INTO bzh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bë mehöti jaḳ na sewah jaḳ yi begganġ yu tamanġsën vavunë megeḳo ayööng doḳ buk saga, og su rëḳ doḳ nah geḳo yi ḳupeḳ lu nġaa doḳ begganġ ayo rë, gaḳ rëḳ beya mena pevis. ");
INSERT INTO bzh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Log bë mehöti na medo huk anon, og su rëḳ pekwë menah begganġ in geḳo yi röpröp ayööng yi lu nġaa rë, gaḳ rëḳ beya mena pevis! ");
INSERT INTO bzh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Log gëpin avëh sën naluj nare loḳ ayoj lo, gesir sën nahën denevo rur vu naluj lo doḳ buk saga. ");
INSERT INTO bzh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Om ham najom jaḳ nabë nġaa sënë su natöḳ vu ham doḳ kwev-ayööng-nikul-yi. ");
INSERT INTO bzh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yönon, doḳ buk saga og rëḳ maggin böpata rot. Maggin nebë sënë su neggëp wirek vu buk sën Anutu tunġ nġaa pin lo rë, rot beverup gwëbeng sagi. Log su rëḳ maggin nabë sënë berup vu dob sënë gökin nah vu tamusën rë. ");
INSERT INTO bzh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lob nabë Mehöböp su kwa bo nabë bepul buk saga dus rë, og mehöti su rëḳ medo vesa rë. Rëḳ mu kwa nevo yi alam sën ggooin sir raḳ lo, om rëḳ bepul buk los maggin saga dus. ");
INSERT INTO bzh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Doḳ buk saga nabë mehö ngwë nanër vu ham nabë, ‘Ham lë! Yiḳ Kerisi* sënë!’ ma nanër nabë, ‘Gwelë! Yi saga!’ og ham su gwevonġ geving hir ġaġek. ");
INSERT INTO bzh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","In Kerisi-kuungsën la los alam denenër ġaġek kuungsën ranġah la yö rëḳ dekedi bedegevonġ huk los niwëëk aggagga, gedegevonġ nġaa böp böp, lob nabë deyoh vu og rëḳ degeḳo alam sën Anutu ggooin sir raḳ lo nah vu sir. Rëḳ mu su deyoh vu rë.” ");
INSERT INTO bzh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","“Om ham gweġin ham. Senër ġaġek sënë pin muġin vu ham in bë ham jaḳ ni bekwamin bo. ");
INSERT INTO bzh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nġaa maggin saga govek na rë, loḳ mëm ‘hes malaḳenu doḳ gekwev su rëḳ natum rë, ");
INSERT INTO bzh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","gebetuheng rëḳ geto in yaġek, genġaa los niwëëk pin vu yaġek rëḳ desasuḳin sir.’ ");
INSERT INTO bzh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Lom doḳ buk saga rëḳ degelë Mehönon Nalu medo doḳ beggob ayo menom los niwëëk böpata gevuneḳ vuneḳ yaġek yi. ");
INSERT INTO bzh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Lob rëḳ gevonġ beyi angër dena dengupin yi alam sën ggooin sir raḳ tu yi alam lo noh vu nyëġ pin. Vu dob vuheng atov mena menoh vu dob nenga lubeluu.” ");
INSERT INTO bzh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ham kwamin bo jaḳ go* rë. Bë purpur berup ngu, og ham neraḳ ni bë go* vonġin nabunġ beham dev jaḳ na jök. ");
INSERT INTO bzh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Om nabë ham gwelë nġaa pin sënë anon jaḳ, og mëm ham jaḳ ni nabë Mehönon Nalu yam dus raḳ benare aggata avi. ");
INSERT INTO bzh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sa nanër vu ham yönon nabë: Mehönon pin su rëḳ malaj nama na veröḳ yi rë, log nġaa pin sën agi rëḳ anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yaġek los dob rëḳ mala nama, gaḳ mu sa ġaġek su rëḳ mala nama na rë, yö rëḳ gëp degwata.” ");
INSERT INTO bzh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Rëḳ mu nġaa sënë yi buk gehes mala, og mehönon pin duġin. Angër vu yaġek duġin, geNalu duġin ving. Gaḳ Ama yö timu raḳ ni. ");
INSERT INTO bzh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Om ham gweġin ham, bemalamin medo natum, in ham duġin buk sën rëḳ nam natöḳ vu ham lo. ");
INSERT INTO bzh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ġaġek sënë nebë mehöti kedi raḳ beya nyëġ ading ti, log nër vu yi hur bë degeġin yi nġaa pin, log ya raḳ. Vonġ huk ggelek yoh vu sir ti ti genër vu mehö sën neġin veluung avi lo bë bare geġin nivesa, gesu gëp. ");
INSERT INTO bzh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Lob rëḳ ham nabë. Ham medo malamin natum in ham duġin buk sën begganġ ala rëḳ nom lo. Rëḳ nom geto raggita, ma buk vuheng, ma sën ḳöḳrëëh nahën nesu lo, ma nyëġ hengsën. ");
INSERT INTO bzh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","In rëḳ nom pevis menatöḳ vu ham geham gwëp. ");
INSERT INTO bzh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ġaġek sën senër vu ham agi, og yiḳ senër vu alam pin bë ham medo malamin natum!” ");
INSERT INTO bzh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Lob yiḳ buk luu mu nahën in bë alam Yuda hir buk-vabuung-ggöksën-yi sën denegga brët sën yiist* nema in lo. Lob alam-deneḳo-seriveng hir ggev losho alam-horek-yi denesero aggata rot in bë denadëġek medenajom yi ahon. Denevonġ in bë denaduu yi gedengis menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Loḳ denër bë, “Hil su ġevonġ doḳ alam sën denegga nos böp agi malaj, in rëḳ dedun böpata.” ");
INSERT INTO bzh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Log Yesu ya verup Betania benedo mehö sevuuḳnyë Simon ben. Denedo bemedo denegga nos, loḳ avëh ti ḳo buayo ti beya begganġ ayo vu sir. Dero buayo sënë raḳ ġelönġ alabasta* gewël reggu nivesa loḳ nare. Wël nart sënë sën denerikin raḳ heljënġ beyi monë böpata rot, rëḳ avëh saga ḳo meloḳ ya vu beveröp buayo raḳ gekeseh raḳ Yesu yu. ");
INSERT INTO bzh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Rëḳ alam la sën denedo ving sir lo ahëj sengën meyö denër vu sir bë, “Nevasap wël nivesa sënë in va? ");
INSERT INTO bzh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gaḳ nabë mëm mehöti baġo wël sagi jaḳ K300 vu hil og mëm, in hil adoḳ vu alam-ḳupeḳ-masën jaḳ!” Gedenër avëh saga rot. ");
INSERT INTO bzh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Rëḳ Yesu nër vu sir bë, “Gëpin! Ham su nanër yi! Yö semu sa raḳ nġaa nivesa. ");
INSERT INTO bzh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gaḳ alam-ḳupeḳ-masën og rëḳ demedo noh vu buk geving ham gesu rëḳ nama na rë, lob bë ham kwamin bo nabë ham doḳ vu sir, og mëm ham yoh vu. Gaḳ saḳ su rëḳ medo geving ham hus ading rë. ");
INSERT INTO bzh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Huk sënë yoh vu avëh sënë bë gevonġ. Rikin marasin sënë raḳ sa vorot in gero sa naviġ namuġin in sëḳ nadiiḳ mededev sa. ");
INSERT INTO bzh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Gesa nanër vu ham yönon nabë: Rëḳ denanër Bengö Nivesa ranġah na menoh vu dob pin bedenanër nġaa sën avëh vonġ vu sa agi geving, in alam pin degenġo mekwaj bo.” ");
INSERT INTO bzh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Lob Yudas Iskariot sën sir nemadluho-bevidek-luu lo ti ya vu alam-deneḳo-seriveng hir ggev in bë nanër Yesu ranġah begevonġ doḳ na nemaj. ");
INSERT INTO bzh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Denġo yi ġaġek sënë, lob ahëj nivesa medenër bë rëḳ debaġo yi, lom mëm Yudas kwa nesero buk los aggata sën bë gevonġ Yesu doḳ na nemaj lo. ");
INSERT INTO bzh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Log buk vabuung sën alam Yuda denegga brët sën yiist* nema in lo yi buk muġinsën verup ggovek ya. Yiḳ buk sën denesis sipsip nalu ggöksën-yi loḳ lo sënë, lob Yesu yi hur maluh ya deloḳ tepëḳ vu yi bë, “He na ġero nyëġ vu tena in ġegwa nos los reggu ggöksën-yi dok-a?” ");
INSERT INTO bzh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Lob vonġ yi hur maluh luu ya genër vu luho bë, “Melu doḳ na nyëġ böp Yerusalem, og mëm melu rëḳ natöḳ vu mehöti genakud bël doḳ dëg ti, lom melu tamuin mena. ");
INSERT INTO bzh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Lob jaḳ na begganġ ti, og melu nanër vu begganġ saga ala nabë, ‘Tatovaha nër bë, “Sa begganġ ayo vatëveḳ yi tena in sa los sa hur maluh lo aġa nos los reggu ggöksën-yi dok-a?” ’ ");
INSERT INTO bzh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Loḳ rëḳ tato ayo böp ti sën detonġin medero ggovek ggëp vavunë lo vu meluu, lom melu gwero nos los reggu vu hil doḳ saga.” ");
INSERT INTO bzh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nër vu luho nebë saga, log luho deya raḳ medeloḳ ya Yerusalem meya detöḳ vu nġaa pin yoh vu sën nër lo, lob mëm luho dero nos los reggu ggöksën-yi loḳ begganġ ayo ti saga. ");
INSERT INTO bzh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ggovek, log sehuksën lob Yesu losho yi hur maluh nemadluho-bevidek-luu lo verup deya begganġ ti saga. ");
INSERT INTO bzh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lob nahën denegga nos los reggu, loḳ Yesu nër vu sir bë, “Sa nanër vu ham yönon nabë ham sën newa nos ving sa agi ti rëḳ gevonġ sa doḳ na alam sën denelë sa paya lo nemaj.” ");
INSERT INTO bzh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Lom ayoj maggin mesir ti ti deneloḳ tepëḳ in yi mesepa loḳ bë, “Maḳ sa?” ");
INSERT INTO bzh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Loḳ nër yah vu sir bë, “Yiḳ ham nemadluho-bevidek-luu sënë ti. Ham sën hil nedaġoo brët loḳ ġabum agi lo ti. ");
INSERT INTO bzh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mehönon Nalu rëḳ nadiiḳ nabë sën dekevu meneggëp loḳ Anutu-yi-ḳapiya wirek lo, rëḳ mu gëp in mehöti sën rëḳ nanër Mehönon Nalu ranġah vu alam bedengis yi lo. Ko nabë ata su geḳo yi-ḳa?” ");
INSERT INTO bzh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nahën medo denegga nos, loḳ Yesu ḳo brët raḳ gejom raḳ in los ahë nivesa ya vu Anutu. Log debu bevo ggelek yoh vu sir genër bë, “Ham gweḳo nök gwa! Sa reggos sënë!”. ");
INSERT INTO bzh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Log ḳo wain kap ti raḳ, gejom raḳ in los ahë nivesa ya vu Anutu, log vo vu sir pin medenum. ");
INSERT INTO bzh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Log nër vu sir bë, “Sa ḳöḳ sënë, sën sa ḳeseh loḳ yah mehönon nġahiseḳë in bë tato nabë ġaġek mewis sën sejoo in doḳ vu sir lo rëḳ anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sa nanër vu ham yönon nabë sa su rëḳ nanum wain nabë sënë gökin nah rë, rot bena berup doḳ buk sën sëḳ nanum wain agga ngwë doḳ Anutu-yi-nyëġ.” ");
INSERT INTO bzh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ggovek log devonġ raro ti, log to deyah dobnë medeyah Ḳedu Ḳele-oliv. ");
INSERT INTO bzh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Deya raḳ lob Yesu nër vu sir bë, “Ham pin rëḳ gwevuu sa geham beya mena. In dekevu wirek meneggëp loḳ Anutu-yi-ḳapiya nebë: ‘Sa Anutu, sëḳ ngis sipsip alaj log sipsip lo degevuu talë medena jeggin jeggin.’ ");
INSERT INTO bzh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Om rëḳ nabë saga, loḳ sëḳ ḳedi jaḳ nah gökin, lob sëḳ namuġin mena distrik Galilea, loḳ ham rëḳ tamuin sa.” ");
INSERT INTO bzh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Lom Pita nër yah bë, “Sir pin sënë og maḳ rëḳ degevuu honġ gedebeya medena, gaḳ saḳ su rëḳ ġevonġ nabë sënë rë!” ");
INSERT INTO bzh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Lob Yesu nër yah vu yi bë, “Sa nanër vu honġ yönon nabë pehi sënë og ḳöḳrëëh su rëḳ ngu beron luu rë, log rëḳ ġedah sa vun beron löö!” ");
INSERT INTO bzh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Loḳ Pita nër niwëëk bë, “Seyoh vu bë sëḳ nadiiḳ geving honġ, gaḳ sesu rëḳ dah honġ vun rë, gerëḳ nama veröḳ yi!” Lob yiḳ sir pin denër nebë sënë. ");
INSERT INTO bzh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Lob Yesu losho yi hur maluh ya deverup nyëġ ti sën denenër arë nebë Getsemane lo, lob nër vu sir bë, “Ham medo sënë, gesena najom jaḳ rë!” ");
INSERT INTO bzh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Lob ḳo Pita geYakobus luho Jon medetah ya teka, loḳ ayo maggin rot gekwa ketuin yi. ");
INSERT INTO bzh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Lob nër vu lööho bë, “Sayoġ maggin rot vonġin bë sa nadiiḳ, om melöö naḳööḳ medo sënë bemedo malamin natum beġadu sa.” ");
INSERT INTO bzh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Log tah teka, lob petev meneggëp dob, log jom raḳ meketaġ bë yoh vu, og Anutu gevonġ buk-maggin-yi sënë noh nenga in yi. ");
INSERT INTO bzh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Lob nër bë, “Aba-e! nebë Amaġ-e! Ġeyoh vu bë gwevonġ nġaa pin, om gweḳo nġaa maggin sënë vër in sa. Rëḳ mu su ġesepa doḳ sa ġaġek, gaḳ nġo kwam!” ");
INSERT INTO bzh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Loḳ yah meya vu lööho melë gedeneggëp yiing, lob nër vu Pita bë, “Simon, ġëëwëp-a? Su ġeyoh vu bë medo malam natum dus ti rë? ");
INSERT INTO bzh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ham gweġin ham, beham malamin natum geham najom jaḳ nabë nġaa ti su kepë ham. Yönon, ham ayomin niyes raḳ, rëḳ mu navimin ni tebö!” ");
INSERT INTO bzh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Lob yah meya ketaġ vu Anutu beron ngwë ggökin menër ġaġek timu nebë sën nër muġin lo. ");
INSERT INTO bzh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Loḳ yom to vu sir ggök yahin belë bë deneggëp yah, in malaj neggëp lo. Lom su deyoh vu bë denanër ġaġek ti nah vu yi rë. ");
INSERT INTO bzh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Lom nevonġ nebë saga netu beron löö, loḳ nër vu sir bë, “Ham nġo nahën newëp geham su malamin netum rë? Maam yiḳ ggovek, in sa buk yam töḳ vu sa ggovek ya! Devo Mehönon Nalu loḳ ya alam nij paya lo nemaj yönon! ");
INSERT INTO bzh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Om ham kwedi jaḳ mehil ana! Ham lë! Mehöti sën gevonġ sa doḳ na nemaj lo yam dus raḳ!” ");
INSERT INTO bzh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu nahën medo nenër bë saga log Yudas verup. Yi sën sir nemadluho-bevidek-luu lo ti, lob ḳo alam yu böpata ti medeyam los paëp-yu-anil gebeġö. Alam-deneḳo-seriveng hir ggev losho alam-horek-yi, galam teta devonġ sir yam. ");
INSERT INTO bzh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Lob mehö sën bë tato yi ranġah lo nër vu sir vorot bë, “Sëḳ tato Yesu vu ham nabë sënë: Nabë sa ġemul* mehöti, og ham najom yi ahon beham gweġin yi nivesa megweḳo mena.” ");
INSERT INTO bzh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Lob Yudas ya verup sesor meya vu Yesu pevis menër bë, “Tatovaha!” log mul* yi. ");
INSERT INTO bzh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Lob dejom yi ahon bededuu. ");
INSERT INTO bzh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lob alam sën denare ving Yesu lo ti dadii yi paëp-yu-anil vër in newis besap alam-deneḳo-seriveng hir ggev böp yi hur ti nenga ris vahi ya. ");
INSERT INTO bzh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Lom Yesu loḳ tepëḳ vu sir bë, “Ham yam in bë sero mehö-beġö-hodeḳ-yi, om sën ham ḳo paëp-yu-anil los beġö meyam in bë najom ahon-ë? ");
INSERT INTO bzh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sa netateḳin ġaġek vu ham loḳ dub-vabuung-böp yoh vu buk, rëḳ ham su nejom sa ahon rë! Rëḳ maam Anutu yi ġaġek sën dekevu wirek meneggëp lo anon jaḳ rë!” ");
INSERT INTO bzh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Lom yi hur maluh pin devuu yi gedeveya medeya. ");
INSERT INTO bzh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Loḳ hur maġëm ti sepa Yesu meya. Bom yi loḳ tob meris ti gesepa, lom dejom loḳ tob in bë denajom yi ahon. ");
INSERT INTO bzh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Rëḳ vuu tob loḳ nemaj geveya meya ahë töḳsën. ");
INSERT INTO bzh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Log deḳo Yesu ya vu alam-deneḳo-seriveng hir ggev böp, geggev pin losho alam teta galam-horek-yi pin denesupin sir. ");
INSERT INTO bzh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Lob Pita tamuin sir meneya, rëḳ nevun yi in sir meneyam ggëp ading, meya verup alam-deneḳo-seriveng hir ggev böp yi begganġ beloḳ ya tete ayo menedo telig. Lob medo nevenguh nengwah ving ahëvavu sën denare medenemalajin nyëġ lo. ");
INSERT INTO bzh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Lob alam-deneḳo-seriveng hir ggev losho kaunsor pin denesero mehö la in bë denanër ġaġek jaḳ Yesu gemëm dengis yi menadiiḳ, rëḳ ma gesu detöḳ vu rë. ");
INSERT INTO bzh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Alam nġahiseḳë denenër ġaġek tetuhinsën raḳ yi, rëḳ ma gedenenër jeggin jeggin, gehir ġaġek su neggëp ti rë. ");
INSERT INTO bzh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Gesir vahi kedi denër ġaġek tetuhinsën raḳ yi bë, ");
INSERT INTO bzh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“He hanġo bë yi sënë nër bë, ‘Sëḳ ḳevoh Anutu yi dub-vabuung-böp sën mehönon delev raḳ nemaj lo na, loḳ buk natu löö lob sëḳ dev ngwë sën mehönon su denelev raḳ nemaj rë lo bebare nah.’” ");
INSERT INTO bzh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Rëḳ ma gehir ġaġek sën denër agi su neggëp ti ving rë. ");
INSERT INTO bzh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Lob alam-deneḳo-seriveng hir ggev böp kedi nare loḳ sir vuheng atov geloḳ tepëḳ ya vu Yesu bë, “Su ġënër ġaġek ti yom rë? Mehönon sënë denenër ġaġek va sën raḳ honġ-ë?” ");
INSERT INTO bzh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Rëḳ Yesu aye ma gesu nër ġaġek ti yah rë. Loḳ alam-deneḳo-seriveng hir ggev böp loḳ tepëḳ vu yi ggökin bë, “Honġ Kerisi* ma ma? Mehö sën hil nehaḳo arë raḳ lo nalu honġ-a? Ġenanër!” ");
INSERT INTO bzh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Loḳ Yesu nër yah bë, “Yiḳ sa lo sënë! Lob ham rëḳ gwelë Mehönon Nalu gemedo gëp Mehö Niwëëk nema vesa, gerëḳ jaḳ medo beggob vu yaġek menom.” ");
INSERT INTO bzh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Lob alam-deneḳo-seriveng hir ggev böp kweeḳ yi röpröp ading getahi bë, “Hil medo nesero mehönon sën denanër ġaġek jaḳ yi lo in va? ");
INSERT INTO bzh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ham nġo bë ḳo yi raḳ besevöḳ Anutu? Om ham kwamin nevo bë?” Loḳ sir pin denër bë vonġ paya om nadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Lob depesuv nyëj ḳos raḳ yi gedevaḳu tob ggërin mala gedepëëng yi gedeloḳ tepëḳ in bë, “Re sis honġ-a? Ġenanër!” Lob ahëvavu sën deneġin yi lo depetap yi ving. ");
INSERT INTO bzh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Log Pita nahën nedo raḳ telig, log alam-deneḳo-seriveng hir ggev böp yi hur avëh ti yam to vu sir ");
INSERT INTO bzh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","belë bë Pita medo nevenguh nengwah, lob gët yi panġsën genër bë, “Honġ sënëḳ melu Yesu Nasaret nesepa ham!” ");
INSERT INTO bzh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Rëḳ lah yi vun bë, “Ma! Sa su raḳ ni rë! Sa duġin honġ ġaġek sënë.” Lob kedi raḳ meyah nare loḳ tete avi, log ḳöḳrëëh ti su. ");
INSERT INTO bzh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Loḳ hur avëh ti sën lo lë yi ggökin genare loḳ tete avi, lom nër vu alam sën denare dus vu yi lo bë, “Mehö saga yiḳ sir ti saga!” ");
INSERT INTO bzh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Rëḳ nër ggökin yah bë, “Ma!” Lob nare teka rë, loḳ alam sën denaregu lo denër vu Pita ggökin bë, “Yönon rot! Yiḳ hir mehöti sën honġ-ë! In honġ Galilea ti!” ");
INSERT INTO bzh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Rëḳ Pita du ġaġek in yi benër niwëëk rot neggëp Anutu mala bë, “Yönon vavunë! Sa duġin mehöti sën ham nenër agi! Bë sa ġekuung jaḳ og Anutu ngis sa mesa nadiiḳ.” ");
INSERT INTO bzh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Log pevis beḳöḳrëëh su netu beron luu, lob Pita kwa vo yah Yesu yi ġaġek sën nër lo bë, “Ḳöḳrëëh su rëḳ ngu beron luu rë, log rëḳ ġedah sa vun beron löö.” Pita kwa vo lob kwa paya besu rot. ");
INSERT INTO bzh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Monbuk anon lob alam-deneḳo-seriveng hir ggev losho alam teta, galam-horek-yi, gekaunsor pin bedevengwënġ raḳ Yesu, log mëm deduu yah meya devo loḳ ya Pilatus nema. ");
INSERT INTO bzh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Lob Pilatus loḳ tepëḳ vu yi bë, “Alam Yuda hir mehö-los-bengö honġ-a?” Loḳ nër yah vu bë, “Ġenër ya meyoh vu!” ");
INSERT INTO bzh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Lob alam-deneḳo-seriveng hir ggev denër ġaġek nġahiseḳë raḳ yi. ");
INSERT INTO bzh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Lom Pilatus loḳ tepëḳ ggök yahin bë, “Su ġënër ġaġek ti yom rë? Ġenġo bë denenër ġaġek nġahiseḳë raḳ honġ-a?” ");
INSERT INTO bzh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Rëḳ Yesu su nenër ġaġek ti yah rë gema, lom Pilatus kwa ya nġahi rot. ");
INSERT INTO bzh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Alam Yuda hir Buk-ggöksën-yi* lob hir aggata neggëp nebë sënë neyoh vu nġebek pin bë Pilatus nelëëin ḳarabus ti ti vër. Bë detahi mehöti arë, og Pilatus nelëëin mehö timu saga neyah vu sir. ");
INSERT INTO bzh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lob vu buk saga alam sën denesis beġö vu gavman, gesir vahi sën denesis mehö la medenediiḳ beya denedo ḳarabus lo, lob sir ti arë nebë Barabas. ");
INSERT INTO bzh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lob alam yu böpata verup deya vu Pilatus medeketaġ vu bë, “Gwevonġ nabë sën ġenevonġ yoh vu ta lo!” ");
INSERT INTO bzh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Loḳ Pilatus nër yah vu sir bë, “Ham vonġin bë sa ḳevelekin alam Yuda hir mehö-los-bengö sënë lo vër nök vu ham ma ma?” ");
INSERT INTO bzh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","In raḳ ni bë alam-deneḳo-seriveng hir ggev ahëj nevonġ medenelë Yesu paya, om sën devo yi loḳ ya nema. ");
INSERT INTO bzh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Rëḳ alam-deneḳo-seriveng hir ggev deloḳ alam pin ahëj bë denanër vu Pilatus bekevelekin Barabas vër. ");
INSERT INTO bzh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Loḳ Pilatus loḳ tepëḳ yah vu sir ggökin bë, “Log sëḳ ġevonġ va vu mehö sënë, sën ham nenër yi bë alam Yuda hir mehö-los-bengö lo?” ");
INSERT INTO bzh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Rëḳ detahi yah vu bë, “Ġengis yi jaḳ na ḳelepeḳo*!” ");
INSERT INTO bzh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Lom Pilatus loḳ tepëḳ vu sir bë, “In va? Mehö sënë vonġ va paya?” Rëḳ pasanġ detahi ya niḳelap bë, “Ġengis yi jaḳ na ḳelepeḳo*!” ");
INSERT INTO bzh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Lob mëm Pilatus nġo hir ġaġek bevonġin bë alam ahëj nivesa jaḳ, lom kevelekin Barabas vër, gevonġ Yesu ya in bë alam-beġö-yi debeek yi, loḳ mëm dengis yi jaḳ na ḳelepeḳo*. ");
INSERT INTO bzh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lob alam-beġö-yi vahi deḳo Yesu medeloḳ ya Pilatus yi begganġ-ġaġek-yi ayo ti (Rom ayej nebë Prëtoryam), log detahi alam-beġö-yi vahi bedesupin sir ya ving. ");
INSERT INTO bzh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Lob deröp tob mala saġap ti loḳ Yesu gedebuu aggis niggin ggin tahu alam-los-bengöj hir madub gedetunġ raḳ yu. ");
INSERT INTO bzh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Log depelë yi gedesis nemaj vu gedenër bë, “Alam Yuda hir mehö-los-bengö honġ, mehö böp los ġayeheng!” ");
INSERT INTO bzh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Log desis yu raḳ atohenġ nġesinġ gedepesuv nyëj ḳos raḳ yi gedeyun lusej vu yi. ");
INSERT INTO bzh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Denër pelësën raḳ yi ggovek, log dekah tob mala saġap sën vër gederöp yö yi tob loḳ yah, log deḳo yi yah meya dobnë in dengis yi jaḳ na ḳelepeḳo*. ");
INSERT INTO bzh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Deḳo medeya lob detöḳ vu mehöti loḳ aggata geverup. Simon vu Kurene, sën Aleksander lu Rupus amaj lo, verup in bë doḳ na nyëġ böp Yerusalem, lob alam-beġö-yi dejom yi ahon gedenër bë, “Kwerë ḳelepeḳo*!” ");
INSERT INTO bzh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Lob deḳo Yesu medeya nyëġ ti sënë arë nebë Golgota (sënë nebë Nyëġ-yuseḳë). ");
INSERT INTO bzh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Lob dekeseh mur* teka loḳ ya wain medeggee loḳ gedevo vu, rëḳ nilëlin gesu num rë. ");
INSERT INTO bzh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Lob desis yi raḳ ya ḳelepeḳo*, log detë ġelönġ mahen teka la in bë gooin sir ti ti jaḳ bedegeḳo yi tob. ");
INSERT INTO bzh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Log 9 krök monbuk lob desis yi raḳ ya ḳelepeḳo*. ");
INSERT INTO bzh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Gedekevu yi ġaġek sën mehönon denenër raḳ yi lo raḳ neggëp ḳelepeḳo* yu nebë: ALAM YUDA HIR MEHÖ-LOS-BENGÖ SËNË! ");
INSERT INTO bzh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Log desis alam beġö hodeḳ luu raḳ ḳelepeḳo* ving. Ngwë nare ggëp nema vesa gengwë nare ggëp nema ḳëj. ");
INSERT INTO bzh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nebë saga lob Anutu yi ġaġek wirek hen lo anon raḳ, sën nebë: “Detevin yi ving alam nij paya sën denekeyëh horek lo.” ");
INSERT INTO bzh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lob alam sën deneyah gedeneyom lo, denenër pelë raḳ yi gedenevarah nemaj vu yi gedenenër bë, “Honġeḳ-o! Ġenër bë kwevoh Anutu yi dub-vabuung-böp na, geġedev nah buk löö mu? ");
INSERT INTO bzh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Om nġo ġedoḳ vu honġ meġeduḳ vu ḳelepeḳo* meġenam!” ");
INSERT INTO bzh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Galam-deneḳo-seriveng hir ggev losho alam-horek-yi denenër pelë raḳ yi ving bedenenër vu sir bë, “Neloḳ vu alam, gaḳ su yoh vu bë yö doḳ vu yi rë. ");
INSERT INTO bzh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nabë yi Kerisi, balam Israel hir mehö-los-bengö yönon, og gevuu ḳelepeḳo* geduḳ menam. Hil ġalë nabë saga loḳ mëm hil ġevonġ geving yi!” Gemehö luu sën desis luho nare raḳ ḳelepeḳo* vahi vahi lo denepelë yi ving. ");
INSERT INTO bzh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Log hes vuheng raḳ, loḳ malaḳenu loḳ beyoh vu dob pin beyam to 3 krök sehuksën. ");
INSERT INTO bzh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Lob 3 krök sehuksën lob mëm Yesu nġeeḳ böpata bë, “Eloi, Eloi, lama sabaktani!” —sënë degwa nebë: “Sa Anutu! Sa Anutu! Nebë va sën ġevuu sa ya-ë?” ");
INSERT INTO bzh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lob alam sën denare dus vu yi lo vahi denġo lob denër bë, “Ham nġo! Netahi Elia!” ");
INSERT INTO bzh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Loḳ mehöti tup meḳo nġaa ayo sovinsën sën nedo loḳ loo lo ti bedaġoo loḳ wain ahëggin sën arë nebë vinegga lo, geduu raḳ ġagwëḳ gevo ya verup loḳ Yesu avi in bë sesuvin, loḳ mehö sënë nër bë, “Ham naḳööḳ! Hil ġalë rë nabë Elia rëḳ nam geḳo yi vër in ḳelepeḳo* ma rëḳ nama!” ");
INSERT INTO bzh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Lob Yesu nġeeḳ böpata log diiḳ ya, ");
INSERT INTO bzh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","lob tob böp sën neruu dub-vabuung-böp ayo vabuung lo kweeḳ raḳ luu ggëp vavu beya metöḳ ahu. ");
INSERT INTO bzh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Lob Rom hir alam-beġö-yi hir ggev ti sën nare Yesu mala lo lë bë diiḳ ya, lom nër bë, “Mehö sënë og Anutu Nalu yönon rot!” ");
INSERT INTO bzh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Gavëh la denare ading teka mevare denelë. Sir lo sënë Maria vu Magdala, geMaria ngwë sën Yakobus mahen luho Yoses ataj, geSalome. ");
INSERT INTO bzh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Vu buk sën Yesu nahën nedo Galilea lo, lom lööho sënë denesepa yi medeneloḳ vu yi. Gavëh vahi sën denesepa yi belosho deraḳ medeya Yerusalem lo denare ving. ");
INSERT INTO bzh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Log hes ggovek in bë duḳ na, lom alam Yuda kwaj nevo bë degero sir in dega nos doḳ Buk-sewahsën-yi* monbuk. ");
INSERT INTO bzh_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Lom Yosep vu Arimatea sën kaunsor böp ti los arë, beyi mehö sën medo netunġ mala in buk sën Anutu-yi-nyëġ anon jaḳ lo. Sën kedi raḳ los niwëëk meya vu Pilatus meketaġ vu yi bë juh Yesu nihel vër in ḳelepeḳo*. ");
INSERT INTO bzh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Lob Pilatus lëk in, gekwa vo bë maḳ diiḳ pevis ma va? Lom vonġ ġaġek ya vu alam-beġö-yi hir ggev yam, beloḳ tepëḳ vu bë, “Mehö sënë lo diiḳ ya veröḳ yi ma ma?” ");
INSERT INTO bzh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Rëḳ alam-beġö-yi hir ggev vonġ ġaġek yom vu, lob raḳ ni bë diiḳ ya veröḳ yi, lob mëm nër vu Yosep bë juh heljënġ vër begeḳo mena. ");
INSERT INTO bzh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Lom Yosep baġo tob veroo nivesa ti, beruh Yesu nihel vër in ḳelepeḳo* mebom loḳ, gebë loḳ ya waaḳ ti sën yö desap loḳ ġelönġ meris, log tetolin ġelönġ böpata yah ggërin avi. ");
INSERT INTO bzh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","GeMaria vu Magdala, geMaria sën Yoses ata lo, luho delë nyëġ sën debë heljënġ loḳ ya neggëp lo. ");
INSERT INTO bzh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Log Buk-sewahsën-yi* saga ggovek ya, lob Maria vu Magdala lööho Maria ngwë sën Yakobus ata lo, geSalome, belööho ya debaġo marasin reggu nivesa in bë dejikin jaḳ Yesu nihel vu bedub. ");
INSERT INTO bzh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Buk-sewahsën-yi ggovek ya geheng to, loḳ Soda monbuk anon, lob dekedi raḳ medeya bedub, loḳ mëm hes mala töḳ. ");
INSERT INTO bzh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nahën deneyök aggata gedenenër vu sir bë, “Maḳ re rëḳ tetolin ġelönġ böpata ti sën nare ggërin waaḳ avi lo na vu hil-a?” ");
INSERT INTO bzh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Loḳ devër malaj raḳ medelë loḳ bë ġelönġ böpata sën lo tetolin meya nare ya nenga vorot. ");
INSERT INTO bzh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Lob lööho deluḳ ya waaḳ ayo lom delë gemaġëm ti nedo ggëp lööho nemaj vesa. Yi tob veroo adingseḳë, lom delëk meḳenuj ya. ");
INSERT INTO bzh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Lob angër sënë nër vu sir bë, “Ham su ḳenumin na! Ham yam nesero Yesu Nasaret sën desis yi raḳ ḳelepeḳo lo. Rëḳ mu su neggëp sënë rë, gaḳ kedi raḳ meya. Melöö lë! Nyëġ sën debë yi loḳ lo neggëp meris. ");
INSERT INTO bzh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Om melöö nah mena nanër vu yi hur maluh, gevu Pita geving, nabë: Muġin meya distrik Galilea om ham tamuin. Ham rëḳ gwelë yi vu sagu noh vu ġaġek sën yö nër vu ham wirek lo.” ");
INSERT INTO bzh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Lob lööho vu waaḳ ayo meto deyom dobnë pevis medeveya medeyah. Denelëk rot gavij netöḳ gedeneggöneng in sir, lom su denër ranġah vu mehöti rë. ");
INSERT INTO bzh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu kedi raḳ loḳ Soda monbuk anon, lom tato yi vu Maria vu Magdala muġin. Yi sën Yesu tii memö nemadvahi-bevidek-luu to deya in yi wirek lo. ");
INSERT INTO bzh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Avëh sënë yah meya menër bengö vu alam sën denesepa Yesu benahën medo denesu medenesis sir lo. ");
INSERT INTO bzh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nër bedenġo bë kedi raḳ menedo mala vesa metöḳ vu yi, rëḳ ma gesu debë nengaj vu aye rë. ");
INSERT INTO bzh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ggovek ya loḳ sir luu medo denetetuu aggata medeneya vuheng ti, lom Yesu töḳ vu luho rëḳ ni agga ngwë raḳ. ");
INSERT INTO bzh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lom luho deyah meya denër bengö ranġah vu sir vahi, rëḳ su devonġ ving luho ving rë. ");
INSERT INTO bzh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ggovek loḳ mëm yi hur maluh nemadluho-bevidek-ti sënë medo denegga nos loḳ begganġ ayo ti, lom ya meto metöḳ vu sir medelë yi, lom nër sir in su devonġ ving yi rë gayoj niwëëk. Nenër sir nebë sënë in su devonġ ving alam sën delë bë kedi raḳ yah lo hir ġaġek rë. ");
INSERT INTO bzh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Loḳ mëm nër vu sir bë, “Ham na menoh vu dob pin, beham nanër Bengö Nivesa ranġah vu mehönon pin. ");
INSERT INTO bzh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mehö sën ayo neyam timu vu sa geripek bël lo, og sëḳ ġaḳo yi nom vu sa berëḳ medo mala-tumsën degwata. Gaḳ mehö sën su ayo neyam timu vu sa rë lo, og rëḳ medo los yi nġaa nipaya menatöḳ jaḳ nyëvewen bemala nama. ");
INSERT INTO bzh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Alam sën ayoj neyam timu vu sa lo, og deyoh vu bë rëḳ degevonġ nġaa böp nabë sënë: Rëḳ degetii memö geto dena jaḳ sarëġ, log debengwënġ doḳ nyëġ ngwë ayej, ");
INSERT INTO bzh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","log nabë denajom nyël, ma, denanum bël diiḳsën, og su rëḳ denadiiḳ rë. Gerëḳ degebë nemaj jaḳ alam nijraḳsën benijvesa jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mehöböp Yesu nër vu sir nebë saga ggovek ya, log Anutu ḳo yi raḳ yah yaġek benedo nema vesa. ");
INSERT INTO bzh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Geyi hur maluh deya raḳ beya denenër yi Bengö Nivesa ranġah ya meyoh vu nyëġ pin, geMehöböp nedo ving sir meneloḳ vu sir, genevonġ nġaa böp los niwëëk yoh vu ġaġek sën nër vu sir lo. ");
INSERT INTO bzh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Oo mehö böp Teopilus*, seraḳ ni bë alam nġahi kwaj nevo nġaa sën töḳ vu he lo, bedekevu loḳ ya ḳapiya vorot. ");
INSERT INTO bzh_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Desepa loḳ alam sën denelë nġaa pin agi raḳ malaj vu muġinsën lo ayej, bedekevu yoh vu. Alam sënë hir huk bë denanër Anutu yi ġaġek ranġah, om deturin vu he. ");
INSERT INTO bzh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Rëḳ mu sa kwaġ nevo ving bë maḳ mëm sëḳ ḳevu niröp rot beġevonġ nök vu honġ, in sa nado ving sir hus ading beseloḳ tepëḳ in nġaa pin sën yö vu agu meyam lo degwa mehero vu sir. ");
INSERT INTO bzh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nebë saga in bë ġejaḳ ġaġek sën detahu honġ loḳ lo ni nivesa nabë sënëḳ yönon rot. ");
INSERT INTO bzh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mehö-neḳo-seriveng ti nedo loḳ buk sën Herot* tu alam Yuda hir mehö-los-bengö lo. Arë nebë Sakaria, balam sën Abia neġin sir lo ti yi. Gevenë arë nebë Elisabet, geyi degwa vu Aaron. ");
INSERT INTO bzh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Luho denevonġ nġaa niröp ggëp Anutu mala. Denesepa loḳ horek los Anutu yi ġaġek pin gesu denevuu ti rë. Nġaa nipaya ti su neggëp vu luho rë. ");
INSERT INTO bzh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Rëḳ luho naluj ma, gElisabet nare babu seḳë, beluho atov ya. ");
INSERT INTO bzh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lob yah verup Abia yi alam hir buk bë degeġin huk dub-vabuung ayo, lob Sakaria yi buk bë gevonġ, lob ḳo raḳ menevonġ menare Anutu mala. ");
INSERT INTO bzh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yiḳ deggooin yi raḳ loḳ alam-deneḳo-seriveng vahi yoh vu sën denevonġ lo, in bë doḳ na Mehöböp yi dub ayo vabuung mebesi nġaa bereggu nivesa berup na vu Anutu. ");
INSERT INTO bzh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Alam nġahiseḳë desup sir meyam vare denejom raḳ ggëp dob, log loḳ ya nevesi nġaa reggu nivesa verup neya. ");
INSERT INTO bzh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Lob Sakaria lë geMehöböp yi angër ti verup nare jepö sën nġaa reggu nivesa yi lo nenga vesa. ");
INSERT INTO bzh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Lë angër, lob lëk meḳenu ya, geggöneng rot. ");
INSERT INTO bzh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Rëḳ angër nër vu yi bë, “Sakaria, su ġeġöneng! Anutu nġo honġ venġevsën ggovek ya, om venëm Elisabet rëḳ geḳo hurmahen maluh ti vu honġ. Lob ġetahi ggev jaḳ yi nabë Jon. ");
INSERT INTO bzh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Rëḳ ayom nivesa, gekwam vesa rot. Ata rëḳ geḳo yi, lob alam nġahiseḳë rëḳ kwaj vesa rot in yi medenapisek in. ");
INSERT INTO bzh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Lob rëḳ natu ggev mebare Mehöböp mala. Su rëḳ nanum wain los bël niwëëk rë, gaḳ yö rëḳ nahën doḳ bare ata ayo, log Anon Vabuung rëḳ doḳ nam gërin ayo. ");
INSERT INTO bzh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Lob rëḳ gërin alam Israel nġahiseḳë denom vu hir Anutu sën hir Mehöböp lo. ");
INSERT INTO bzh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Rëḳ natu mehö niwëëk los ġayeheng nabë sën Elia wirek lo benamuġin, loḳ mëm Mehöböp tamuin yi menam. Rëḳ gevonġ mamer, lob alam hib los hurmahen degelë sir nivesa. Log rëḳ gërin alam-ġaġek-keyëhsën ayoj bedesepa doḳ alam-yohvu kwaj nivesa. Log rëḳ gevonġ huk in mehönon borot medegero sir in Mehöböp rëḳ nam.” ");
INSERT INTO bzh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Lob Sakaria nër yah vu angër bë, “Sëḳ jaḳ ġaġek sënë ni nabë yönon nabë va? Sa atov ya, besa venëġ atov ya ving.” ");
INSERT INTO bzh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Loḳ angër nër yah vu bë, “Sa Gabriel, besa nare Anutu mala, bAnutu yö vonġ sa yam niröp in bë sa nanër vu honġ, meġevonġ bengö nivesa sënë nök vu honġ. ");
INSERT INTO bzh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Om gwenġo rë! Sa ġaġek sënë rëḳ anon jaḳ doḳ buk sën Anutu ggooin raḳ vorot lo. Rëḳ su ġevonġ ving sayeġ rë, om rëḳ ġenġoo jaḳ kwam, gesu rëḳ ġebengwënġ rë, rot bena berup doḳ buk sën nġaa pin agi anon jaḳ lo, lom mëm.” ");
INSERT INTO bzh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Log alam medo deneġin Sakaria hus ading rot, lob kwaj ya nġahi, in ya nedo rot loḳ dub ayo vabuung. ");
INSERT INTO bzh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Loḳ luḳ yom, lob su yoh vu bë bengwënġ rë. Lom deraḳ ni bë töḳ vu nġaa agga ti loḳ dub ayo vabuung. Lom yiḳ netato nġaa raḳ nema mu vu sir, in avi mir. ");
INSERT INTO bzh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Loḳ Sakaria ggovek yi huk, log yah meya ben. ");
INSERT INTO bzh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ggovek, loḳ mëm venë Elisabet nalu loḳ, beyö neggëp begganġ ayo yoh vu kwev nemadvahi beggëp neḳo Mehöböp arë raḳ bë, ");
INSERT INTO bzh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Mehöböp vonġ nebë sënë vu sa. Sa naluġ ma besa niġ nemum, rëḳ ma geMehöböp kwa vo sa besemu sa. ");
INSERT INTO bzh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet nalu loḳ bekwev nemadvahi bevidek ti ggovek ya, loḳ mëm Anutu vonġ angër Gabriel ya distrik Galilea nyëġ böp ti arë nebë Nasaret. ");
INSERT INTO bzh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ya vu avëh avö ti sën deggooin yi raḳ ggovek menedo vu mehöti arë nebë Yosep. Yi degwa vu Davit*. Gavëh avö arë nebë Maria. ");
INSERT INTO bzh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel ya vu yi benër bë, “Honġ-e! Anutu kwa vonġin honġ, menelë honġ nivesa. Mehöböp nedo ving honġ.” ");
INSERT INTO bzh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria nġo ġaġek sënë, lob ayo ya nġahi rot, gekwa nevo bë, “Maḳ ġaġek va ti sënë?” ");
INSERT INTO bzh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Loḳ angër nër vu yi bë, “Maria, su newam jaḳ. Anutu ahë nivesa vu honġ. ");
INSERT INTO bzh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Om gwenġo rë! Rëḳ nalum doḳ, lob gweḳo nalum maluh ti. Lob ġetahi ggev jaḳ nabë Yesu. ");
INSERT INTO bzh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Rëḳ natu Mehöböp los bengö, lob denanër yi nabë Anutu Kesuusën nalu. Log Anutu rëḳ gevonġ yi natu mehö-los-bengö doḳ nah yi degwa Davit ben. ");
INSERT INTO bzh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Rëḳ natu Yakop yi mewis lo hir mehö-los-bengö degwata. Lob rëḳ natu alaj megeġin sir degwata los degwata.” ");
INSERT INTO bzh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Loḳ Maria loḳ tepëḳ yah vu angër bë, “Nġaa sënë rëḳ anon jaḳ nabë va, in senġo nahën nado gesa su raḳ maluh ti rë?” ");
INSERT INTO bzh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Loḳ angër nër yah bë, “Anon Vabuung rëḳ jaḳ nök honġ, gAnutu Vavunë Kesuusën niwëëk rëḳ gebom honġ. Om rëḳ denanër hurmahen sën gweḳo agi vu tamusën nabë vabuung, los denanër nabë Anutu Nalu. ");
INSERT INTO bzh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Om gwenġo agi rë! Honġ ngwë Elisabet atov ya, rëḳ nalu aġuu loḳ nare ahë. Wirek og alam denenër yi bë nare babu seḳë, rëḳ gwëbeng og nalu loḳ bekwev nemadvahi-bevidek-ti ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","In Anutu yoh vu bë gevonġ nġaa pin.” ");
INSERT INTO bzh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Loḳ Maria nër bë, “Mehöböp yi hur avëh sa, om yö gevonġ noh vu sën ġenër aga.” Lob mëm nedo gangër ya. ");
INSERT INTO bzh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maria kedi loḳ buk saga bepevis meya begganġ-bu ti ggëp Yuda hir nyëġ ḳedu, ");
INSERT INTO bzh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","beya meloḳ ya Sakaria yi begganġ benër hes vuheng raḳ Elisabet. ");
INSERT INTO bzh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hurmahen nare loḳ Elisabet ayo, gElisabet nġo Maria aye, lob hurmahen neggee loḳ ayo rot. Lob Anon Vabuung loḳ yam ggërin Elisabet ayo, ");
INSERT INTO bzh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","lob tahi niwëëk bë, “Anutu semu honġ kesuu avëh pin. Besemu hurmahen sën nare loḳ ayom aga ving. ");
INSERT INTO bzh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Sa nebë va om sën Mehöböp ata yam vu sa-ë? ");
INSERT INTO bzh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Om gwenġo rë, sa hanġo ayem loḳ ya nengaġ, lob hurmahen sën loḳ nare sayoġ agi kwa vesa beggee. ");
INSERT INTO bzh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yönon, Mehöböp rëḳ semu honġ in ġevonġ ving ġaġek sën nër vu honġ lo.” ");
INSERT INTO bzh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Lob Maria nër bë: “Sa nehaḳo Mehöböp arë raḳ loḳ ayoġ. ");
INSERT INTO bzh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Lob sanoġ nepisek in Anutu sën ḳo sa yah vu yi lo. ");
INSERT INTO bzh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","In sa og nġaa meris, rëḳ setu yi hur avëh besemu sa. Om vu gwëbeng sënë gevu tamusën, og alam pin rëḳ denanër nabë Anutu semu sa. ");
INSERT INTO bzh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","In Anutu Mehö Niwëëk ata vonġ nġaa böpata rot vu sa, garë tu vabuung. ");
INSERT INTO bzh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yi semusemu neggëp ving alam sën deneggurek babu lo, genesepa loḳ naluj lo meneya meneya rot. ");
INSERT INTO bzh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nema nevonġ huk niwëëk, log netii alam sën deneḳo sir raḳ loḳ ayoj lo, meya denepalët loḳ. ");
INSERT INTO bzh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nedahun alam-los-bengöj niwëëk wëëk, geneḳo alam sën su los arëj rë lo raḳ. ");
INSERT INTO bzh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nevo nġaa nivesa vesa vu alam sën deneraḳ vu in nġaa lo, bedeneḳo beggovek, rëḳ alam sën los bengöj-ggoreksën lo, og netii sir yah los nemaj meris. ");
INSERT INTO bzh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Neloḳ vu yi hur Israel, in yö nahën kwa nevo yi ġaġek ");
INSERT INTO bzh_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","sën nër wirek vu hil dobahë Abraham lo bë rëḳ kwa gevonġin yi losho yi mewis sën rëḳ deberup vu tamusën lo, beyö gëp degwata.” ");
INSERT INTO bzh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Lob Maria nedo ving Elisabet yoh vu kwev löö, loḳ yah meya ben. ");
INSERT INTO bzh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lob Elisabet yi buk ggovek ya bë geḳo nalu, lob ḳo nalu aġuu. ");
INSERT INTO bzh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Lob yi alam sën sir begganġ-bu ti lo losho alam sën sir degwa ti lo denġo bë Mehöböp semu yi böpata rot, lob kwaj vesa ving yi. ");
INSERT INTO bzh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Log buk nemadvahi-bevidek-luu ggovek ya, geti netu löö, lob deyam in bë degerah* hurmahen navi. Devonġin bë detahi ama arë Sakaria jaḳ yi, ");
INSERT INTO bzh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","rëḳ hurmahen ata nër bë, “Ma! Hil tahi Jon jaḳ yi.” ");
INSERT INTO bzh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Loḳ denër yah vu yi bë, “Rëḳ mu honġ alam ti su arë nebë saga rë-o.” ");
INSERT INTO bzh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Rëḳ ma, lob detato raḳ nemaj vu ama bë vonġin bë tahi ggev re jaḳ nalu, ");
INSERT INTO bzh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","lob tato bedeḳo taperë mahen ti yam bekevu raḳ bë: “Arë nabë Jon.” Lob kwaj ya nġahiseḳë rot. ");
INSERT INTO bzh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lob mëm Sakaria kwa nivesa loḳ yah pevis, bemëm daggen sepëp raḳ benevengwënġ, beneḳo Anutu arë raḳ. ");
INSERT INTO bzh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Lob alam sën sir begganġ-bu ti lo deggöneng rot, beya denër nġaa pin sënë ya meyoh vu distrik Yudea nyëġ ḳedu pin. ");
INSERT INTO bzh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Lob alam pin sën denġo bengö lo debë loḳ ya yuj, bemedo mekwaj nevo, medenenër vu sir bë, “Maḳ hurmahen sënë rëḳ jig lob gevonġ nabë va?” Lob Mehöböp nemalain yi meneġin. ");
INSERT INTO bzh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Lob Anon Vabuung loḳ yam ggërin ama Sakaria ayo bevonġ menër ġaġek ranġah nebë: ");
INSERT INTO bzh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Hil ġaḳo Mehöböp arë jaḳ, hil Israel hil Anutu. In yam vu yi alam in bë doḳ vu sir begeḳo sir vër in hir nġaa nipaya nyëvewen. ");
INSERT INTO bzh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Genevonġ mehö niwëëk ti verup loḳ yi hur Davit* yi mewis in bë geḳo hil nom vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yoh vu ġaġek sën nevonġ verup yi alam vabuung lo avij bedenenër ranġah yö vu agu rot beyam lo. ");
INSERT INTO bzh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bë: Rëḳ geḳo hil vër in alam sën denesis beġö vu hil los alam sën denelë hil paya lo nemaj. ");
INSERT INTO bzh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nevonġ yam in bë ġaġek kwa-vonġinsën sën nër vu hil ḳenud lo lo anon jaḳ, genevonġ in bë ġaġek vabuung sën joo vu sir wirek lo anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ġaġek sën nenër los yönon vavunë vu hil dobahë Abraham nebë: ");
INSERT INTO bzh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Rëḳ geḳo hil vër in alam sën denesis beġö vu hil lo pin nemaj gehil su rëḳ aġönengin sir rë, loḳ mëm hil bare mala menatu yi alam vabuung los yohvu meġaḳo arë jaḳ noh vu buk pin vu dob. ");
INSERT INTO bzh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Log honġ, hur mahen-e! Alam rëḳ denanër honġ nabë Mehöböp los ġayeheng yi mehö-nenër-ġaġek-ranġahsën ti honġ. In rëḳ ġenamuġin megwetonġin Mehöböp yi aggata, ");
INSERT INTO bzh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","lob Anutu-yi-alam dejaḳ ni nabë vonġin kevoh hir nġaa nipaya na, gegeḳo sir nah vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nġaa sënë rëḳ berup in hil Anutu kwa vonġin hil, lom rëḳ gevonġ Mehö-ranġah-yi nam vu hil nabë sën hes neverup monbuk menetum raḳ hil. ");
INSERT INTO bzh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Rëḳ nam in gevonġ beranġah jaḳ in alam sën denedo loḳ malaḳenu bevonġin denadiiḳ lo, gerëḳ geḳo hil vahi betato aggata vu hil in hil medo nivesa los ayod gëp revuh.” ");
INSERT INTO bzh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Loḳ hurmahen sënë rig meböp raḳ, lob töḳ vu kwa besepa loḳ nġaa nivesa. Loḳ mëm ya nedo nyëġ-yumeris rot beya verup loḳ buk sën töḳ yam tato yi vu alam Israel. ");
INSERT INTO bzh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lob vu buk saga alam Rom hir mehö-los-bengö Sisar* Augustus vonġ ġaġek ya vu alam pin nebë vonġin gevonġ sensas ti bekevu alam pin arëj. ");
INSERT INTO bzh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kwirinius tu kiap böp meneġin distrik Suria loḳ buk saga, lob vonġ sensas nyëdahis sënë. ");
INSERT INTO bzh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Lob alam pin deneya medeneya bej in bë dekevu arëj. ");
INSERT INTO bzh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Lob Yosep vu Nasaret ggëp distrik Galilea meraḳ meyah Davit yi nyëġ Betlehem ggëp distrik Yudea, in Davit* yi mewis yi, beyi degwa vu Davit*. ");
INSERT INTO bzh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Luho venë Maria sën deli vu yi in bë luho denajom nemaj lo, deya in bë kiap kevu luho arëj doḳ ti. GeMaria nalu loḳ nare ayo. ");
INSERT INTO bzh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lob luho ya verup denedo Betlehem, log Maria yi buk ggovek ya bë geḳo nalu. ");
INSERT INTO bzh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Lob ḳo nalu aġuu mebom yi loḳ tob mebë loḳ neggëp reggu hir ġabum-nos-yi, in vatëveḳ bej pup ya genyëġ len ti su neggëp rë. ");
INSERT INTO bzh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Lob sipsip alaj denedo dus vu nyëġ Betlehem saga bedeneġin hir sipsip buk ggëp pahup ayo. ");
INSERT INTO bzh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Lob Anutu yi angër ti yam vu sir, beniḳapiik los vuneḳ vuneḳ yaġek yi jëh raḳ sir nebë nengwah böpata, lom deggöneng rot. ");
INSERT INTO bzh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Loḳ angër nër vu sir bë, “Ham su newamin jaḳ! Gaḳ ham gwenġo rë! Sa haḳo Bengö Nivesa yam vu ham, gevu alam pin sën denedo dob-ë, in bë degenġo bekwaj vesa rot. ");
INSERT INTO bzh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","In gwëbeng sënë avëh ti ḳo nalu vu Davit yi nyëġ böp Betlehem. Yiḳ yi Mehöböp Kerisi*. Yi saga sën yam in bë geḳo alam vër in hir nġaa nipaya nyëvewen. ");
INSERT INTO bzh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Geham rëḳ gwelë jaḳ sënë nabë debom yi loḳ tob meneggëp loḳ reggu hir ġabum-nos-yi.” ");
INSERT INTO bzh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lob pevis bangër nġahiseḳë vu yaġek medeyam ving angër ti sënë medepisek in Anutu medeḳo arë raḳ nebë, ");
INSERT INTO bzh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Hil ġaḳo Anutu arë jaḳ na vavunë! Galam pin ayoj gëp revuh in Anutu nelë sir nivesa.” ");
INSERT INTO bzh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angër deyah medeya yaġek, log sipsip alaj lo yom denër vu sir bë, “Ham-o! Hil ana Betlehem meġalë nġaa sën anon raḳ agu, sën gwëbeng Mehöböp nër tato vu hil lo.” ");
INSERT INTO bzh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Log dekedi raḳ pevis medeya. Ya deverup, lob detöḳ raḳ Maria luho Yosep gedenedo, gehurmahen neggëp loḳ reggu hir ġabum-nos-yi. ");
INSERT INTO bzh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Delë ggovek, log denër ġaġek sën denġo raḳ hurmahen lo ranġah. ");
INSERT INTO bzh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lob alam pin sën denġo sipsip alaj hir ġaġek lo ḳenuj ya rot. ");
INSERT INTO bzh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Rëḳ mu Maria, og jelë ġaġek pin sënë loḳ ya yu bemedo mekwa nevo. ");
INSERT INTO bzh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Log sipsip alaj lo deyah medeya, gedeneḳo Anutu arë raḳ. Kwaj vesa vu Anutu in nġaa pin sën denġo los delë lo, yoh vu sën angër nër vu sir lo. ");
INSERT INTO bzh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Neggëp gebuk nemadvahi-bevidek-löö raḳ, loḳ mëm derah* navi, log detahi ggev raḳ yi bë Yesu. Su loḳ nare ata ayo rë geyö nahën, log angër tahi ggev sënë raḳ yi vorot. ");
INSERT INTO bzh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Buk sën avëh los naluj deneggëp rot meneggovek gedeneluḳ yah dub ayo ggökin in bë nij veseek jaḳ lo ggovek ya yoh vu sën Moses nër lo, lob Yesu ata lu ama deḳo yi medeya Yerusalem in bë degetunġ yi doḳ na Mehöböp nema. ");
INSERT INTO bzh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sënë yoh vu Mehöböp yi ġaġek sën neggëp loḳ yi ḳapiya lo bë: Avëh degeḳo naluj muġinsën, benabë aġuu, og ham gwevonġ bedenatu Mehöböp yi nġaa vabuung. ");
INSERT INTO bzh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Log luho bë debesi seriveng geving, noh vu sën Mehöböp yi horek nër lo bë: Vevop nivesa luu ma, nuung nalu mewis luu. ");
INSERT INTO bzh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lob mehöti arë nebë Simeon nedo Yerusalem. Yi mehö niröp menesepa loḳ Anutu yönon, log neġin mehö semusën sën rëḳ doḳ vu Israel lo. GAnon Vabuung nedo ving yi. ");
INSERT INTO bzh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","GAnon Vabuung tateḳin vu yi vorot bë su rëḳ nadiiḳ pevis rë, gaḳ rëḳ gelë Mehöböp yi Kerisi* jaḳ mala rë, loḳ mëm. ");
INSERT INTO bzh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Lob mëm Anon Vabuung kehe ayo beloḳ ya dub-vabuung-böp ayo, loḳ Yesu ata lu ama deḳo yi verup loḳ ya in bë degevonġ noh vu sën horek nër lo. ");
INSERT INTO bzh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Lom Simeon ḳo hurmahen ya betabuu gepisek in Anutu meḳo arë raḳ bë: ");
INSERT INTO bzh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Mehöböp, mëm sëḳ nadiiḳ los ahëġ nivesa, in gwëbeng sënë ġaġek sën ġenër wirek lo anon raḳ. ");
INSERT INTO bzh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sa malaġ raḳ mehö sën ġevonġ in bë gweḳo he nök vu honġ lo. ");
INSERT INTO bzh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Lom ġevonġ nġaa sënë ggëp mehönon pin malaj. ");
INSERT INTO bzh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mehö sënë nebë ranġah, om rëḳ najëh ranġah jaḳ alam dahis pin, lob geḳo honġ alam Israel lo arëj jaḳ rot.” ");
INSERT INTO bzh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yosep luho venë kwaj ya nġahi in ġaġek sën Simeon nër raḳ luho naluj agi. ");
INSERT INTO bzh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Loḳ Simeon jom raḳ vu Anutu bë semu luho, log nër vu hurmahen ata Maria bë, “Gwenġo rë, hurmahen sënë rëḳ gevonġ balam Israel nġahiseḳë rëḳ malaj nama, log rëḳ gevonġ besir nġahiseḳë denom vu Anutu. Yam in tato aggata vu hil, rëḳ mu alam nġahiseḳë rëḳ nij dëlin yi. ");
INSERT INTO bzh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Rëḳ nabë sënë in mëm alam nġahiseḳë kwaj sën yö neggëp vu sir lo natöḳ ranġah. Rëḳ mu nġo rëḳ ayom maggin rot geving berëḳ nabë sën paëp-yu-anil ti negelu newam.” ");
INSERT INTO bzh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Log tum avëh-nenër-ġaġek-ranġahsën ti nedo, arë nebë Ana. Panuel nalu yi, geyi degwa vu Aser, rëḳ yi atov rot. Yi avö geraḳ regga beluho denedo wirek yoh vu nġebek nemadvahi-bevidek-luu, ");
INSERT INTO bzh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","loḳ regga diiḳ, genedo alov rot beyi nġebek 84 raḳ loḳ buk sënë. Rëḳ su nevuu dub-vabuung-böp ya rë, gaḳ yö neya rot. Buk nġahi og aye ggërin nos genejom raḳ menedo mu, benevonġ Anutu yi huk buk geranġah. ");
INSERT INTO bzh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lob Yesu lööho ama lu ata nahën denare loḳ buk sënë, log Ana verup ving bepisek in Anutu, log nër ġaġek raḳ hurmahen sënë vu alam pin sën deneġin bë Anutu geḳo alam Yerusalem nah vu yi lo. ");
INSERT INTO bzh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Devonġ nġaa pin sënë yoh vu sën Mehöböp yi horek nër lo, log deyah medeya distrik Galilea vu hir nyëġ böp Nasaret lo. ");
INSERT INTO bzh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Log hurmahen rig beniwëëk raḳ. Beyi mehö los kwa nivesa, bAnutu yi semusemu neggëp vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesu ama lu ata deneraḳ medeneya Yerusalem yoh vu ta pin medenelë buk vabuung böp sën denenër bë Buk-ggöksën-yi* lo. ");
INSERT INTO bzh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Lob Yesu yi ta nemadluho-bevidek-luu raḳ, log yiḳ devonġ nebë saga mederaḳ medeya Yerusalem in bë degelë Buk-ggöksën-yi*. ");
INSERT INTO bzh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Lob Buk-ggöksën-yi* ggovek ya, beyi buk pin maya, log deneyah medeneya bej. Gaḳ Yesu og nedo Yerusalem, gama lu ata duġin. ");
INSERT INTO bzh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Luho dekuung bë ya ving yi mehö la medeneya. Rot besehuk luḳ, loḳ luho denesero yi beya denesero vu alam sën losho degwa ti lo, genij papu lo. ");
INSERT INTO bzh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Luho desero medenesero rëḳ ma. Lom luho deyah medeya denesero yi vu Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Luho medo denesero yi yoh vu buk löö, loḳ mëm luho detöḳ vu yi loḳ dub-vabuung-böp ayo, genedo ving alam tatovaha lo, benenġo hir ġaġek, geneloḳ tepëḳ in degwa ving. ");
INSERT INTO bzh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Lob alam pin sën vare denenġo yi tepëḳ lo ḳenuj ya in kwa los yi ġaġek sën nenër yah vu sir lo. ");
INSERT INTO bzh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ama lu ata delë yi, lob delëk anon mederanġa nemaj. Lob ata nër vu yi bë, “Aġuu-e? Ġevasap aluu in-a? Alu amam ayomin maggin rot in alu medo nesero honġ rot.” ");
INSERT INTO bzh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Loḳ nër yah vu luho bë, “Melu nesero sa in va? Maḳ melu su kwamin nevo bë sëḳ medo doḳ Amaġ yi begganġ rë?” ");
INSERT INTO bzh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Rëḳ luho su kwaj töḳ raḳ yi ġaġek sën nër agi degwa rë. ");
INSERT INTO bzh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ggovek log mëm yah ving luho belööho deyah Nasaret, lob yö nenga yes yes vu ama lu ata ayej. Lob ata jelë ġaġek pin sënë loḳ ya yu bemedo mekwa nevo. ");
INSERT INTO bzh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","GeYesu rig meböp raḳ, lob yi Mehö los kwa nivesa rot. Lob Anutu losho mehönon denelë yi nivesa, mekwaj vesa in. ");
INSERT INTO bzh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberius tu alam Rom hir Sisar* menedo yoh vu ta nemadluho menemadvahi vorot, lob vonġ bePontius Pilatus tu kiap pin vu distrik Yudea hir yuseḳë beneġin sir. Log Herot* tu yuseḳë meneġin distrik Galilea, gari Pilip tu yuseḳë meneġin alam ggëp distrik Ituraya los Trakonitis. Log Lusanius tu yuseḳë meneġin distrik Abilene, ");
INSERT INTO bzh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","gAnas luho Kayapas detu alam-deneḳo-seriveng hir ggev böp. Lob Sakaria nalu Jon nedo nyëġ-yumeris loḳ buk saga, bAnutu yi ġaġek neyam vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nebë saga, lob neyoh vu begganġ-bu pin sën nedo dus vu bël Yordan, benenër ġaġek vu alam bë degërin sir medejipek bël, lob mëm Anutu rëḳ kevoh hir nġaa nipaya sën neggëp vu sir lo na. ");
INSERT INTO bzh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sënë yoh vu ġaġek sën mehö-nenër-ġaġek-ranġahsën Yesaya nër meneggëp loḳ Anutu-yi-ḳapiya lo bë: “Mehöti aye neraḳ loḳ nyëġ-yumeris bë: ‘Ham bolinin Mehöböp yi aggata, meham sesor begëp niröp. ");
INSERT INTO bzh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Debahu lii ayo böp böp na, gededev ḳedu böp böp los mahen medegerurin geto geving. Gaggata pin sën neggëp bejusën lo, og dedev gguu beniveröḳ jaḳ. ");
INSERT INTO bzh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","In alam pin degelë nġaa sën Anutu gevonġ in geḳo hil nah vu yi lo.’” ");
INSERT INTO bzh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Lob alam nġahiseḳë deya vu yi in bë dejipek bël jaḳ nema, loḳ nër vu sir bë, “Nyël nalu ham! Re nër vu ham bë ham beya in nyëvewen sën rëḳ natöḳ vu ham vu Buk-tamusën agi? ");
INSERT INTO bzh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ham gwevonġ nġaa niröp noh vu sën ham wërin ayomin lo, in tato nabë ham wërin ham yönon. Gaḳ ham su kwamin bo megweḳo ġaġek jaḳ nah menanër nabë Abraham yi mewis ham. Gaḳ sa nanër vu ham nabë Anutu yoh vu bë gevonġ ġelönġ sëne denatu Abraham yi mewis. ");
INSERT INTO bzh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yönon, in ḳoov nevu nevaleḳ ḳele ġeġa meneggëp vorot. In ḳele pin sën su denesis anoj nivesa rë lo, og rëḳ buv mebesi jaḳ na nengwah.” ");
INSERT INTO bzh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nër nebë sënë, lob alam pin deneloḳ tepëḳ in yi bë, “Om he rëḳ ġevonġ nabë va?” ");
INSERT INTO bzh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Loḳ nër yah vu sir bë, “Mehöti sën yi röpröp luu neggëp vu yi lo, og bo ngwë vu mehö ngwë sën neraḳ vu in lo. Gemehöti sën yi nos neggëp lo, yiḳ gevonġ nabë saga geving.” ");
INSERT INTO bzh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Log alam sën deneḳo takës* lo la deyam ving in bë dejipek bël, lob deloḳ tepëḳ vu yi bë, “Tatovaha, log heḳ rëḳ ġevonġ nabë va?” ");
INSERT INTO bzh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Loḳ nër yah vu sir bë, “Ham gweḳo monë takës niröp noh vu sën gavman nër vu ham lo, gaḳ ham su ġodeḳ la sevöḳ na geving rë.” ");
INSERT INTO bzh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Log alam-beġö-yi la deloḳ tepëḳ in sir vu yi bë, “Log heḳ rëḳ ġevonġ nabë va?” Loḳ nër yah vu sir bë, “Ham su ngis mehönon jeggin jeggin los nanër ġaġek kuungsën jaḳ sir in nabë ham ġodeḳ hir monë lu nġaa, gaḳ yiḳ ham gweḳo ham monë sën ggev denebaġo ham lo niröp los ahëmin nivesa beggovek.” ");
INSERT INTO bzh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Alam denġo ġaġek sënë, lob kwaj vo ya niwëëk loḳ ayoj bë, “Maḳ Jon sënë yiḳ maḳ yi Mehö sën Anutu ggooin raḳ in bë geḳo hil nah lo ma ma?” ");
INSERT INTO bzh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nebë sënë, lob Jon nër yah vu sir bë, “Sa naripek ham raḳ bël. Rëḳ mëm mehö los niwëëk ti kesuu sa rëḳ tamuin sa menam, log sa su mehö niġ vesa yoh vu in bë sa natu yi hur beḳevelekin vaha suu rë. Yi saga sën rëḳ basuh ham begevonġ Anon Vabuung vu ham vahi begevonġ benengwah ga ham vahi. ");
INSERT INTO bzh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jom yi savor loḳ ya nema vorot in tetëhin ḳale ḳale na in yi wit*, gengupin wit* anon jaḳ na yi jök-wit-yi. Gaḳ ḳale ḳale saga og rëḳ besi jaḳ na nengwah sën yö medo netum degwata lo.” ");
INSERT INTO bzh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon nenër bengö nivesa vu alam genenër ġaġek nġahiseḳë ving in bë gelu ayoj medegërin sir. ");
INSERT INTO bzh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Rëḳ Jon vo ġaġek raḳ hir yuseḳë Herot*, in ggodeḳ ari avëh Herodias log nevonġ nġaa nipaya vahi ving. ");
INSERT INTO bzh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Genevonġ nġaa nipaya ti sënë ggökin ving: Tunġ Jon ya ḳarabus. ");
INSERT INTO bzh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Log alam pin deneripek bël, lob Yesu ripek bël ving. Ripek bël ggovek gevare nejom raḳ, lob yaġek tateḳin yi ");
INSERT INTO bzh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","gAnon Vabuung ni nebë soḳ nuung beluḳ yam raḳ ya yi. Log ġaġek ti yam vu yaġek bë, “Sa naluġ honġ. Sahëġ neving honġ besa halë honġ nivesa.” ");
INSERT INTO bzh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu yi ta mehödahis-menemadluho raḳ, lob mëm ḳo yi huk raḳ. Loḳ alam kwaj nevo yi bë yiḳ Yosep nalu yi. Log yiḳ Yosep ama Heli. ");
INSERT INTO bzh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ga, Heli ama Matat, geMatat ama Levi* ga, Levi* ama Melki. Ga, Melki ama Yanai ga, Yanai ama Yosep (sënëḳ yö ngwë). ");
INSERT INTO bzh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ga, Yosep ama Matatias ga, Matatias ama Amos. Ga, Amos ama Naum ga, Naum ama Esli. Ga, Esli ama Nagai. ");
INSERT INTO bzh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ga, Nagai ama Maat. Ga, Maat ama Matatias (sënëḳ yö ngwë), ga, Matatias ama Semein. Ga, Semein ama Yosek ga, Yosek ama Yoda. ");
INSERT INTO bzh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ga, Yoda ama Yoanan ga, Yoanan ama Resa. Ga, Resa ama Serubabel ga, Serubabel ama Sealtiel. Ga, Sealtiel ama Neri. ");
INSERT INTO bzh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ga, Neri ama Melki, (sënëḳ yö ngwë). Ga, Melki ama Adi ga, Adi ama Kosam. Ga, Kosam ama Elmadam ga, Elmadam ama Er. ");
INSERT INTO bzh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ga, Er ama Yosua ga, Yosua ama Elieser. Ga, Elieser ama Yorim ga, Yorim ama Matat (sënëḳ yö ngwë). Ga, Matat ama Levi (sënëḳ yö ngwë). ");
INSERT INTO bzh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ga, Levi ama Simeon. Ga, Simeon ama Yuda ga, Yuda ama Yosep (sënëḳ yö ngwë). Ga, Yosep ama Yonam ga, Yonam ama Eliakim. ");
INSERT INTO bzh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ga, Eliakim ama Melea ga, Melea ama Mena. Ga, Mena ama Matata ga, Matata ama Natan. Ga, Natan ama Davit. ");
INSERT INTO bzh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ga, Davit ama Yese. Ga, Yese ama Obet ga, Obet ama Boas. Ga, Boas ama Salmon ga, Salmon ama Nason. ");
INSERT INTO bzh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ga, Nason ama Aminadap ga, Aminadap ama Admin ga, Admin ama Arni. Ga, Arni ama Hesron ga, Hesron ama Peres. Ga, Peres ama Yuda (sënëḳ yö ngwë). ");
INSERT INTO bzh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ga, Yuda ama Yakop. Ga, Yakop ama Isaak ga, Isaak ama Abraham. Ga, Abraham ama Tera ga, Tera ama Nahor. ");
INSERT INTO bzh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ga, Nahor ama Seruk ga, Seruk ama Reyu. Ga, Reyu ama Pelek ga, Pelek ama Eber. Ga, Eber ama Sela. ");
INSERT INTO bzh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ga, Sela ama Kainan. Ga, Kainan ama Arpaksat ga, Arpaksat ama Sem. Ga, Sem ama Noa ga, Noa ama Lamek. ");
INSERT INTO bzh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ga, Lamek ama Metusala ga, Metusala ama Enok. Ga, Enok ama Yaret ga, Yaret ama Mahalalel. Ga, Mahalalel ama Kainan (sënëḳ yö ngwë). ");
INSERT INTO bzh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ga, Kainan ama Enos. Ga, Enos ama Set ga, Set ama Adam. Ga, Adam og yiḳ Anutu nalu in tunġ yi. ");
INSERT INTO bzh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Anon Vabuung loḳ yam ggërin Yesu ayo, lob yi vu bël Yordan meneyah, lob Anon Vabuung li yi meya nyëġ-yumeris. ");
INSERT INTO bzh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Beya nedo nyëġ-yumeris yoh vu buk mehödahis luu, lob Satan pelëpin yi. Yesu su negga nos loḳ buk saga rë, genedo meris yoh vu buk pin sënë beggovek ya loḳ tum diiḳahë. ");
INSERT INTO bzh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Lob Satan nër vu yi bë, “Bë Anutu nalu honġ, og ġenanër meġelönġ sënë natu brët.” ");
INSERT INTO bzh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Loḳ Yesu nër yah vu bë, “Ġaġek neggëp loḳ Anutu-yi-ḳapiya bë: Nos mu su yoh vu bë gevonġ bemehönon demedo vesaj rë.” ");
INSERT INTO bzh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Loḳ Satan ḳo yi meraḳ ya ḳedu ading, lob pevis betato alam pin sën denedo dob lo los hir nyëġ pin vu Yesu, ");
INSERT INTO bzh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","genër vu yi bë, “Sëḳ bo nġaa nivesa vesa los niwëëk sënë pin vu honġ barëm böp jaḳ kesuu mehönon pin. In nġaa pin sënë tu sa nġaa. Om nabë sebo vu mehöti, og sëḳ bo vu yi benatu yi nġaa. ");
INSERT INTO bzh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Om nabë ġenadudeḳ vu sa megweḳo sa jaḳ, og nġaa pin sënë rëḳ nök natu honġ nġaa.” ");
INSERT INTO bzh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Loḳ Yesu nër yah vu yi bë, “Ġaġek neggëp loḳ Anutu-yi-ḳapiya nebë: Yiḳ gweḳo Mehöböp sën honġ Anutu lo jaḳ, beġeġurek yi yö timu babu.” ");
INSERT INTO bzh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Loḳ Satan ḳo Yesu ggökin beya nyëġ böp Yerusalem metunġ yi raḳ ya Dub-vabuung-böp yu vavunë rot, genër vu yi bë, “Bë Anutu Nalu honġ, og gwetë honġ na dob, ");
INSERT INTO bzh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","in ġaġek neggëp loḳ Anutu-yi-ḳapiya bë: Rëḳ gevonġ yi angër lo nam degeġin honġ nivesa. ");
INSERT INTO bzh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Log nër ving bë: Rëḳ detabuu honġ doḳ nemaj, gesu rëḳ ġengis vaham jaḳ ġelönġ rë.” ");
INSERT INTO bzh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Loḳ Yesu nër yah vu yi bë, “Ġaġek neggëp ving bë: Su ġeseggi honġ Mehöböp Anutu.” ");
INSERT INTO bzh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan seggi yi raḳ nġaa sënë ggovek, log ya gekwa vo bë maam buk ngwë rë. ");
INSERT INTO bzh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu ḳo niwëëk vu Anon Vabuung beyah meya distrik Galilea, lob bengö ya meyoh vu distrik saga los dahis. ");
INSERT INTO bzh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Lob netateḳin ġaġek vu alam loḳ hir dub-supinsën-yi pin, lob alam pin deḳo arë raḳ. ");
INSERT INTO bzh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Lob Yesu yah verup Nasaret sën wirek yi mahen genedo merig loḳ lo, log Buk-sewahsën-yi*, lob loḳ ya dub-supinsën-yi nebë sën yö nevonġ yoh vu soda pin lo. Lob kedi nare in bë natevin Anutu yi ġaġek. ");
INSERT INTO bzh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Lob devo mehö-nenër-ġaġek-ranġahsën Yesaya yi ḳapiya loḳ nema bepuh, lob töḳ raḳ len teka sën dekevu meneggëp bë: ");
INSERT INTO bzh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mehöböp yi Anon Vabuung loḳ yam ggërin sayoġ. In yö ggooin sa raḳ in bë sa nanër Bengö Nivesa vu alam sën deneraḳ vu in nġaa lo. Vonġ sa yam in bë sa nanër ġaġek ranġah vu alam sën denedo loḳ ḳarabus ayo lo nabë ggovek ya gedegetah sir vër. Gesa bë nanër vu alam malaj ḳenod lo nabë malaj natum gökin medegelë nyëġ. Ġevonġ sa yam in bë sa ġaḳo alam sën nġaa maggin deġinengin sir lo vër, ");
INSERT INTO bzh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","gesa nanër ranġah nabë nġebek sën Mehöböp gelë mehönon nivesa lo töḳ yam ggovek.” ");
INSERT INTO bzh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu tevin ġaġek dus ti sënë ggovek medenġo, lob vevir ḳapiya yah bevo yah vu ala geto nedo. Log alam sën denedo loḳ dub-supinsën-yi ayo lo pin yiḳ malaj neya timu vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Lob mëm ḳo ġaġek lo raḳ menër vu sir bë, “Anutu yi ġaġek sën ham nahën nenġo agi lo anon raḳ gwëbeng.” ");
INSERT INTO bzh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lob deḳo arë raḳ, loḳ kwaj neya nġahi in yi ġaġek nivesa vesa sën nenër verup avi lo, medenër bë, “In va gemu sënëḳ Yosep nalu-ë lo?” ");
INSERT INTO bzh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Lob nër vu sir bë, “Yönon, maḳ ham rëḳ nanër alam hib hir ġaġek ti sënë jaḳ sa nabë, ‘Dokta! Nġo gwevonġ benim vesa jaḳ namuġin rë. Om gwevonġ nġaa nabë sën he hanġo bë ġevonġ ggëp Kapernaum lo doḳ nġo honġ nyëġ sënë geving loḳ mëm.’” ");
INSERT INTO bzh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Loḳ nër ggökin bë, “Sa nanër yönon vu ham nabë: Alam su denebë nengaj vu mehö-nenër-ġaġek-ranġahsën ti ggëp yö yi begganġ degwa rë. ");
INSERT INTO bzh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Rëḳ mu sa nanër yönon vu ham nabë: Loḳ Elia yi buk og avëh alov nġahiseḳë denedo Israel. Lob beggob kehe ya gebamöö veriik, behob su neto rë yoh vu nġebek löö bekwev nemadvahi-mevidek-ti. Gemeyip böpata yoh vu nyëġ. ");
INSERT INTO bzh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Rëḳ Anutu su vonġ Elia ya vu alov la vu Israel in bë doḳ vu sir rë. Gaḳ mëm yiḳ vonġ yi meya nyëġ ngwë vu Sarepat ggëp distrik Sidon mu in doḳ vu avëh alov ti vu sagu. ");
INSERT INTO bzh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Log yiḳ alam nij sevuuḳ nġahiseḳë denedo Israel loḳ mehö-nenër-ġaġek-ranġahsën Elisa yi buk nebë saga ving. Rëḳ sir ti su nivesa neraḳ loḳ sir len rë. Gaḳ yiḳ mehö-yu-ngwë Naaman vu dob Suria yö timu sën nivesa raḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Loḳ alam pin sën denedo dub-supinsën-yi agi denġo ġaġek sënë, lob ahëj sengën böpata rot. ");
INSERT INTO bzh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lob dekedi deruuk Yesu to meya in nyëġ saga. Delev hir nyëġ sagi benedo raḳ nyëġ ḳedu ti, lob deḳo yi medeya peḳë in bë dejos na. ");
INSERT INTO bzh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Rëḳ ma geyoh sir vuheng atov beto meya. ");
INSERT INTO bzh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Loḳ tum ya meto distrik Galilea yi nyëġ böp ngwë sën Kapernaum. Log Buk-sewahsën-yi*, lob nenër ġaġek vu alam. ");
INSERT INTO bzh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Denġo yi ġaġek, lob avij töḳ mederanġa nemaj in nenër ġaġek nebë mehö los niwëëk ti. ");
INSERT INTO bzh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Loḳ memö ti nedo loḳ mehö ti benedo loḳ dub-supinsën-yi saga ving, lob nġeeḳ bë, ");
INSERT INTO bzh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“O! Yesu vu Nasaret, bë gwevonġ va vu he? Maḳ ġeyam in bë kwevoh he? Seraḳ nim bë Anutu yi mehö vabuung honġ.” ");
INSERT INTO bzh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Rëḳ Yesu petupek raḳ bë, “Ayem nama! Ġegweto ġena in mehö saga!” Lob memö sënë të mehö lo to neggëp dob loḳ sir vuheng, log to meya, rëḳ su vonġ paya vu yi rë. ");
INSERT INTO bzh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Lob alam pin delëk anon gedenenër vu sir bë, “Sënëḳ maḳ ġaġek re? Mehö sënë nenër vu memö nebë yi mehö niwëëk los bengö ti, om denenġo aye meto deneya in mehönon.” ");
INSERT INTO bzh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesu vonġ nebë sënë, lob bengö ya meyoh vu nyëġ pin vu sagu. ");
INSERT INTO bzh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu vu dub-supinsën-yi ayo meluḳ yom, lom ya meloḳ ya Simon yi begganġ, geSimon ggen avëh nivanë böpata meneggëp. Lob deketaġ vu Yesu bë doḳ vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","To meya nare dus mekepë yi ya vu, log petupek raḳ nivanë, lob nikul ya. Log avëh kedi raḳ pevis beneyeh nos in losho dega. ");
INSERT INTO bzh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hes ggovek in bë duḳ na, lob alam deḳo hir alam sën nij neraḳ lo medeya vu yi. Lob nebë nema raḳ sir pin ti ti benevonġ benijvesa neraḳ. ");
INSERT INTO bzh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Gememö to deneya in alam nġahiseḳë, gedenenġeeḳ bë, “Anutu Nalu honġ.” Rëḳ petupek raḳ sir bë ayej nama. In deraḳ ni bë yi Mehö sën Anutu ggooin raḳ in bë geḳo hil nah lo. ");
INSERT INTO bzh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Log monbuk anon, lob kedi raḳ beya nyëġ-yumeris tahsën ti. Loḳ alam desero yi medeya vu yi bedevonġin bë denanërin yi in su gevuu sir gena nyëġ ngwë. ");
INSERT INTO bzh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Rëḳ nër vu sir bë, “Sa naya in nanër Anutu-yi-nyëġ yi Bengö Nivesa ranġah vu nyëġ vahi geving. In Anutu vonġ sa meseyam in bë ġevonġ huk sënë.” ");
INSERT INTO bzh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Lob ya nenër loḳ distrik Yudea hir dub-supinsën-yi pin. ");
INSERT INTO bzh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Buk ti, lob nare nġaggee böp Genesaret* nenga, lob alam nġahiseḳë ya detetup yi medahis raḳ, in bë degenġo Anutu yi ġaġek. ");
INSERT INTO bzh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Lob lë geyaġ mahen luu nedo meris yam nġaggee nenga galam-ġël-yi deluḳ medeneripek leḳ. ");
INSERT INTO bzh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Lob raḳ ya yaġ ngwë sën Simon yiyi, benër vu yi lob ḳo yaġ to meya vuheng teka, log mëm nedo raḳ genetateḳin ġaġek vu sir. ");
INSERT INTO bzh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nër ġaġek vu sir ggovek, log nër vu Simon bë, “Gwetee honġ yaġ geto mena nġaggee sën luḳ ya ading teka loḳ mëm ham gwetë leḳ duḳ na in ham gweḳo ġël.” ");
INSERT INTO bzh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Loḳ Simon nër yah bë, “Alaġ, he hevonġ huk böpata gwëbeng buk ading rot, rëḳ he su haḳo ġël la rë. Rëḳ maam ġenër om saḳ ġetë leḳ duḳ nah gökin rë.” ");
INSERT INTO bzh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Devonġ nebë sënë, lob devasu ġël nġahiseḳë rot beleḳ vonġin bë bepul. ");
INSERT INTO bzh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lob detahi sir vahi sën denedo raḳ yaġ ngwë lo bë na dedoḳ vu sir. Lob mëm deya bedeḳo ġël raḳ yaġ luhoho, rëḳ ġël vevii bevonġin bë duḳ na nġaggee. ");
INSERT INTO bzh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Pita lë nebë sënë, lob yun lus loḳ Yesu vaha genër bë, “Oo-o, Mehöböp! Ġedëëin sa geġena! In saḳ nġaa nipaya neggëp vu sa.” ");
INSERT INTO bzh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","In losho yi alam sën denedo loḳ yaġ delë ġël pin sën deḳo lo, lob ḳenuj ya in. ");
INSERT INTO bzh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Log Sebedi nalu Yakobus luho ari Jon sën yiḳ losho Simon denevonġ huk timu lo, ḳenuj ya in ving. Rëḳ Yesu nër vu Simon bë, “Su newam jaḳ, in rëḳ gweḳo mehönon nabë saga.” ");
INSERT INTO bzh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Lob dedadii yaġ ya roneḳ, lob devuu nġaa pin ya gedetamuin yi, belosho deya. ");
INSERT INTO bzh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu nedo nyëġ böp ti, lob mehöti nedo sagu, besevuuḳ vunin navi pin. Mehö sënë lë Yesu, lob petev meneggëp loḳ vaha geketaġ vu yi bë, “Mehöböp! Nabë ahëm geving, og ġeyoh vu bë gwevonġ mesa niġ veseek jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Lob Yesu bë nema raḳ yi genër bë, “Sahëġ ving, om nim veseek jaḳ!” Lob yiḳ sevuuḳ saga mehor ya pevis. ");
INSERT INTO bzh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Log Yesu vo ḳooin bë, “Su ġena ġenanër vu mehöti. Gaḳ mëm ġena ġetato navim vu mehö-neḳo-seriveng, gegwetunġ seriveng* in nim veseek raḳ. Noh vu sën Moses nër wirek bë hil ġevonġ lo. In alam pin dejaḳ ni nabë nim veseek raḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Rëḳ ma geYesu yi nġaa pin sën nevonġ lo bengö tup luḳ nyëġ meya. Lob alam nġahiseḳë denġo medeyam vu yi in bë degenġo yi ġaġek gegevonġ hir niraḳsën nama na. ");
INSERT INTO bzh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Rëḳ buk la og netah yi ya nyëġ-yumeris menejom raḳ. ");
INSERT INTO bzh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Buk ti, lob medo nenër ġaġek vu mehö la, galam Parisai* la losho alam-horek-yi la denedo ving. Deyam ggëp nyëġ neru ti ti lo pin. Vu distrik Galilea, gevu distrik Yudea gevu nyëġ böp Yerusalem. Lob Mehöböp vo niwëëk vu Yesu in bë gero alam nijraḳsën benijvesa jaḳ. ");
INSERT INTO bzh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lob mehö la devaḳu mehö ti raḳ reek medeya vu in seḳë pin selönġin. Lob devaḳu medeya in bë na degebë doḳ Yesu mala gëp begganġ ayo, ");
INSERT INTO bzh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","rëḳ nyëġ mir in alam nġahiseḳë, gesu aggata neggëp in bë debaḳu doḳ na rë. Nebë saga, lob deraḳ ya begganġ demi tamanġsën medekehe begganġ demi gedeseluhin mehö sënë los reek luḳ ya alam vuheng atov beya meto neggëp loḳ Yesu mala. ");
INSERT INTO bzh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu lë beraḳ ni bë ayoj neya timu vu yi, lob nër vu mehö sënë bë, “Sa mehö-e! Sa dahun honġ nġaa nipaya ya.” ");
INSERT INTO bzh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Lob alam Parisai* losho alam-horek-yi yö kwaj neya nġahi bë, “Mehö re sagi, sën neḳo yi raḳ besevöḳ Anutu-ë? Mehöti su yoh vu bë dahun nġaa nipaya na rë, gaḳ Anutu yö timu yoh vu.” ");
INSERT INTO bzh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Rëḳ Yesu raḳ ayoj ni, lob nër yah vu sir bë, “Ham ayomin neya nġahi in va? ");
INSERT INTO bzh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ham kwamin nevo ġaġek sën senër agi bë, ‘Sa dahun honġ nġaa nipaya ya’ lo bë anon ma, in re yoh vu bë gelë nabë dahun ya yönon-a? Rëḳ mu mëm nabë sa nanër vu yi nabë, ‘Kwedi jaḳ meġena!’ og mëm ham rëḳ jaḳ ni nabë sa nanër ġaġek los anon. ");
INSERT INTO bzh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Rëḳ sa bë ham jaḳ ni nabë Mehönon Nalu yoh vu bë dahun nġaa nipaya na vu dob.” Log peggirin menër vu mehö sën seḳë selönġin lo bë, “Sa nanër nök vu honġ nabë: Kwedi gweḳo honġ reek jaḳ meġenah böm.” ");
INSERT INTO bzh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nër nebë sënë, lob yiḳ kedi raḳ avuti raḳ alam pin saga malaj, bekerë nġaa sën devaḳu raḳ lo beneyah ben, geneḳo Anutu arë raḳ. ");
INSERT INTO bzh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lob alam pin saga ḳenuj ya gederanġa nemaj. Lob deḳo Anutu arë raḳ, gedeggöneng medenenër bë, “Nġaa ti sën hil halë gwëbeng agi yö agga ti.” ");
INSERT INTO bzh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ggovek, geYesu to meyah dobnë meneya, loḳ lë gemehö sën neḳo takës* lo ti loḳ nedo begganġ-takës-yi. Arë nebë Levi. Lob nër vu yi bë, “Ġenam ġesepa sa.” ");
INSERT INTO bzh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lob vuu nġaa pin menedo, gekedi meya sepa Yesu meluho deya. ");
INSERT INTO bzh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lob Levi vonġ Yesu yi nos böp ti loḳ yi begganġ, balam sën deneḳo takës* lo nġahiseḳë losho alam vahi deyam ving luho belosho denegga. ");
INSERT INTO bzh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Rëḳ alam Parisai* losho hir alam-horek-yi delë, lom denër ġaġek nġahiseḳë raḳ Yesu vu yi hur maluh lo bë, “Nebë va sën ham los alam-deneḳo-takës* losho alam sën denevonġ nġaa nipaya lo newa nos loḳ ti-ë?” ");
INSERT INTO bzh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Loḳ Yesu nër yah vu sir bë, “Alam nijvesa su deneya vu dokta rë. Gaḳ yiḳ alam nijraḳsën mu yö deneya vu. ");
INSERT INTO bzh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Om sa su yam in bë tahi alam-yohvu rë. Gaḳ seyam in bë tahi alam sën nġaa nipaya neggëp vu sir lo in degërin ayoj.” ");
INSERT INTO bzh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Loḳ deloḳ tepëḳ vu Yesu ggökin bë, “Jon yi hur maluh ayej deneggërin nos gedenejom raḳ beron beron, balam Parisai* hir hur maluh denevonġ nebë saga ving. Rëḳ honġ hur maluh, og yö medo denegga gedenenum mu.” ");
INSERT INTO bzh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Loḳ Yesu peggirin ġaġek raḳ mehö sën neḳo avëh lo benër yah vu sir bë, “Ham kwamin bo rë, nabë mehöti medo geving yi alam geluho avëh ti denajom nemaj. Bë nabë sënë, og yi alam sënë su deyoh vu bë ayej gërin nos rë. ");
INSERT INTO bzh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Rëḳ mëm buk sën debo mehö sën ḳo avëh lo vër, besu medo geving yi alam rë, og mëm yi alam rëḳ ayoj maggin bayej gërin nos doḳ buk saga.” ");
INSERT INTO bzh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Loḳ Yesu nër ġaġek peggirinsën ngwë vu sir ggökin bë, “Mehöti su nekweeḳ tob mewis ti len teka menepeḳa muġeng ngwë sën nekweeḳ lo len raḳ rë. Bë mehöti gevonġ nabë saga, og rëḳ gevonġ paya vu tob mewis saga, gemewis len ti sën lo su luho tob muġeng rëḳ gëp ti rë. ");
INSERT INTO bzh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Log mehöti su netöö wain* mewis loḳ memëk navi muġeng rë. Bë mehöti gevonġ nabë sënë, og wain rëḳ ngol memëk navi mebepul gewain keseh geto mena. Gememëk navi nipaya jaḳ geving. ");
INSERT INTO bzh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Gaḳ yiḳ alam yö denetöö wain mewis loḳ ya memëk navi mewis og mëm. ");
INSERT INTO bzh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Log alam sën yö denenum wain muġeng lo, og su ahëj neving wain mewis rë. Gaḳ denenër bë, ‘Wain muġeng mëm nivesa.’” ");
INSERT INTO bzh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Buk-sewahsën-yi* ti, lob Yesu losho yi hur maluh deyoh ya huk wit* ti ayo medeya. Lob yi hur maluh derur wit* anon la mederii raḳ nemaj mededah. ");
INSERT INTO bzh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Rëḳ alam Parisai* la delë medenër bë, “Nebë va sën ham kweyëh horek Buk-sewahsën-yi-ë?” ");
INSERT INTO bzh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Loḳ Yesu loḳ tepëḳ yah vu sir bë, “Maḳ ham su tevin ġaġek raḳ nġaa sën Davit vonġ wirek lo rë? Sën losho yi hur dediiḳahëj lo, ");
INSERT INTO bzh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","lob loḳ ya Anutu yi dub beḳo brët vabuung sën denetunġ netu seriveng benedo ggëp Anutu mala lo. Alam-deneḳo-seriveng mu yö deyoh vu bë dega brët saga, gaḳ alam meris nebë Davit og ma. Rëḳ gga gevo vu yi hur medegga ving.” ");
INSERT INTO bzh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Log Yesu nër ving bë, “Mehönon Nalu tu Buk-sewahsën-yi* ala.” ");
INSERT INTO bzh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Log Buk-sewahsën-yi* ngwë, lob loḳ ya dub-supinsën-yi menetateḳin ġaġek vu alam. Log mehöti nema vesa belooin benedo. ");
INSERT INTO bzh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Alam-horek-yi losho alam Parisai* medo malaj nesepa Yesu in bë degelë nabë rëḳ gevonġ benema nivesa jaḳ doḳ Buk-sewahsën-yi*, ma rëḳ nama! In denesero aggata in bë denanër ġaġek jaḳ Yesu nabë keyëh horek. ");
INSERT INTO bzh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Rëḳ yö raḳ ayoj ni. Lob nër vu mehö sën seḳë paya lo bë, “Kwedi ġenam ġebare doḳ vuheng atov.” Lob kedi meya nare. ");
INSERT INTO bzh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Log Yesu nër vu sir bë, “Sa bë doḳ tepëḳ in ġaġek ti vu ham nabë: Maḳ horek nër bë hil ġevonġ nġaa nivesa doḳ Buk-sewahsën-yi*, ma hil ġevonġ nġaa nipaya? Maḳ nër bë hil adoḳ vu alam in demedo vesaj, ma hil nid dël jaḳ sir in malaj nama?” ");
INSERT INTO bzh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Log mala neḳo loḳ menelë sir pin, log nër vu mehö lo bë, “Ġetelo seḳëm nam!” Telo seḳë ya, lob nivesa loḳ ggökin. ");
INSERT INTO bzh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Rëḳ alam saga ahëj sengën böpata rot, geyah desap sir raḳ bë degevonġ nabë va vu Yesu! ");
INSERT INTO bzh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Loḳ buk sënë, Yesu tah yi ya ḳedu ti in bë najom jaḳ, lob medo mejom raḳ vu Anutu buk ading rot menyëġ heng ya. ");
INSERT INTO bzh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Log hes mala verup, lob supin yi hur maluh ya vu yi, betum ggooin sir nemadluho-mevidek-luu lo raḳ benër sir bë Sinarë. ");
INSERT INTO bzh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Alam lo sënë: Simon sën Yesu tahi ggev ngwë raḳ bë Pita lo. Ga, ari Andreas. Ga, Yakobus lu Jon. Ga, Pilip lu Bartolomai. ");
INSERT INTO bzh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ga, Matai lu Tomas. Ga, Yakobus sën Alpeus nalu. Ga, Simon sën yi mehö-neruuk-alam-Rom lo. ");
INSERT INTO bzh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ga, Yudas sën Yakobus nalu lo, log Yudas Iskariot sën rëḳ nanër Yesu ranġah vu alam-beġö-yi lo. ");
INSERT INTO bzh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Lob Yesu luḳ meya ving sir beya nare nyëġ neggumeng ti ving yi hur maluh yu böpata. Galam nġahiseḳë deyam vu nyëġ böp Yerusalem, gesir sën distrik Yudea pin, galam loo sën dus vu Ture los Sidon lo beyam desupin sir medenedo. ");
INSERT INTO bzh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Deyam in bë degenġo yi ġaġek, log gevonġ behir niraḳsën nama na. Galam sën memö nevasap sir lo, og Yesu nevonġ menijvesa neraḳ ving. ");
INSERT INTO bzh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Galam pin denedu sir in bë degebë nemaj jaḳ yi. In yi niwëëk ya nevonġ balam pin nijvesa neraḳ. ");
INSERT INTO bzh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Loḳ Yesu vër mala raḳ menelë yi hur maluh lo, lom nër bë: “Ham sën neraḳ vu in nġaa dob-yi lo, ham kwamin vesa. In ham tu Anutu-yi-alam beham rëḳ medo nivesa doḳ yi nyëġ. ");
INSERT INTO bzh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ham sën nediiḳahëmin agi, ham kwamin vesa. In ham su rëḳ jaḳ vu in nġaa nivesa ti vu tamusën rë. Ham sën nesu menedo agi, ham kwamin vesa. In ham rëḳ kwamin vesa menanöp vu tamusën. ");
INSERT INTO bzh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Alam rëḳ degelë geham sepa doḳ Mehönon Nalu, lob rëḳ degelë ham paya, bedegetii ham, gedepelë ham, gedenanër ham nabë ham nimin paya, rëḳ mu ham kwamin vesa in nġaa saga. ");
INSERT INTO bzh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nabë degevonġ nabë sënë vu ham, og ham kwamin vesa, geham napisek in rot, in ham nyëvewen sën neggëp yaġek lo, og böpata rot. In wirek og ḳenuj lo denevonġ nebë sënë vu alam-denenër-ġaġek-ranġahsën lo ving. ");
INSERT INTO bzh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Gaḳ ham sën los bengömin-ggoreksën lo, og gëpin ham! In ham nedo raḳ nġaa sën nivesa vesa lo vorot. ");
INSERT INTO bzh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Geham sën newa nos böp bahëmin nepup agi, gëpin ham! In ham rëḳ jaḳ vu in nġaa vu tamusën. Geham sën nenöp gwëbeng agi, gëpin ham! In ham rëḳ ngu mengis ham vu tamusën bemalamin ruḳ keseh. ");
INSERT INTO bzh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nabë alam pin degeḳo ham arëmin jaḳ, og gëpin ham! In ḳenuj lo denevonġ nebë saga wirek vu alam-ġaġek-kuungsën lo.” ");
INSERT INTO bzh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Rëḳ sa bë nanër vu ham sën nenġo sa ġaġek agi nabë: Ham kwamin pesivin alam sën denesis beġö vu ham lo. Geham gwevonġ nivesa vu alam sën degelë ham paya lo. ");
INSERT INTO bzh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Geham najom jaḳ in alam sën deneterot ham lo nabë Anutu semu sir. Geham benġev jaḳ in alam sën denenër pelë raḳ ham lo nabë Anutu doḳ vu sir. ");
INSERT INTO bzh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nabë mehöti petap nengam vahi, og honġeḳ ġegwërin vahi bepetap geving. Genabë mehöti ngoo doḳ honġ röpröp-ayööng-yi, og ġenaḳah honġ röpröp ngwë geving, gaḳ su ġeġulin. ");
INSERT INTO bzh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nabë mehöti ketaġ nġaa ti vu honġ, og ġebo vu yi. Genabë mehöti sepos honġ nġaa vër in honġ, og su ġenanër vu nabë bo nom. ");
INSERT INTO bzh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nġaa sën ham ahëmin neving bë alam degevonġ vu ham lo, og yiḳ ham gwevonġ nabë saga vu sir namuġin. ");
INSERT INTO bzh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nabë yiḳ ham nġo ahëmin geving alam sën ahëj neving ham lo mu, og alam rëḳ degeḳo ham arëmin jaḳ in degwa tena? Gaḳ yiḳ alam pin og denevonġ nebë sënë, bahëj neving alam sën ahëj neving sir lo. ");
INSERT INTO bzh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Log nabë ham doḳ vu alam sën deneloḳ vu ham lo mu, og alam rëḳ degeḳo ham arëmin jaḳ in degwa tena? Gaḳ yiḳ alam pin og denevonġ nebë sënë ving. ");
INSERT INTO bzh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Log nabë ham bo nġaa vu alam gekwamin bo nabë rëḳ debo doḳ nah vu ham, og alam rëḳ degeḳo ham arëmin jaḳ in degwa tena? Gaḳ yiḳ alam pin og denevo nġaa vu sir vahi, in bë degeḳo hir nġaa vahi doḳ nah nyëvewen. ");
INSERT INTO bzh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Gaḳ mëm ham ahëmin geving alam sën denesis beġö vu ham lo. Geham doḳ vu mehönon pin. Ham bo nġaa vu alam, gaḳ ham su kwamin bo nabë rëḳ debo nġaa ti nom vu ham doḳ nah nyëvewen. Ham gwevonġ nabë saga, log vu tamusën, og ham rëḳ natöḳ vu ham nyëvewen böpata rot benatu Anutu Vavunë nalu lo. In nevonġ semusën vu alam sën su kwaj vesa in yi rë lo, losho alam nij paya. ");
INSERT INTO bzh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Om ham kwamin gevonġin alam medoḳ vu sir nabë sën ham Amamin Anutu nevonġ lo.” ");
INSERT INTO bzh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ham su seggi mehö ngwë doḳ ayomin nabë yi mehö nipaya. In lob Anutu su seggi ham benanër ham nabë ham alam nimin paya. Log ham su nanër mehö ngwë nabë degeḳo nyëvewen doḳ nah hir nġaa nipaya. In lob Anutu su nanër ham nabë ham gweḳo nyëvewen doḳ nah ham nġaa nipaya. Gaḳ ham dahun nġaa nipaya sën mehönon denevonġ vu ham lo na, in lob Anutu dahun ham nġaa nipaya na geving. ");
INSERT INTO bzh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ham bo nġaa vu mehönon, og Anutu rëḳ bo doḳ nah vu ham rot, beham dëg napup avi, beham deġinengin gesesesin jaḳ beduḳ na, genam gök gökin megerurin geto. In yiḳ nġaa sën ham nevonġ vu mehönon lo, og Anutu rëḳ gevonġ nabë saga doḳ nah vu ham.” ");
INSERT INTO bzh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Log Yesu nër ġaġek peggirinsën ti vu sir bë, “Maḳ mehö mala ḳenod ti yoh vu bë tato aggata vu mehö mala ḳenod ngwë? Ma! Bë nabë sënë, og luhoho rëḳ debës söv doḳ ti. ");
INSERT INTO bzh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hur maluh ti su kesuu yi tatovaha rë. Bë tatovaha tahu yi govek mejaḳ ni, og mëm luho ala rëḳ degëp ti. ");
INSERT INTO bzh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ma ġenelë ḳale mahen teka sën negga raḳ arim mala lo, log su kwam nevo ġanġ dus ti sën neggëp loḳ malam aga rë? ");
INSERT INTO bzh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ma nebë va sën ġenër vu arim bë, ‘Ari-e! Ḳööḳ gesa hevonġ ḳale vër in malam ġahis rë.’ Gwelë rë! Honġ mehö kwam luu! In ġanġ neggëp loḳ nġo malam ġahis! Nġo gwevonġ ġanġ dus ti sënë vër in malam govek rë, loḳ mëm rëḳ gwelë nġaa mahen teka sën neggëp loḳ arim mala aga nivesa meġebo vër.” ");
INSERT INTO bzh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ḳele nivesa su nesis anon nipaya rë. Log ḳele nipaya su yoh vu bë rëḳ ngis anon nivesa rë. ");
INSERT INTO bzh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Om mehönon degelë ḳele anon, loḳ mëm dejaḳ ni nabë ḳele nivesa, ma nipaya. In mehöti su nerur mori anon raḳ aggis niggin ti jes rë. Log mehöti su nerur vud anon raḳ ḳele niggin nipaya ti agga rë. ");
INSERT INTO bzh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Om mehö nivesa neḳo nġaa nivesa vër loḳ nġaa nivesa sën nesupin meneggëp loḳ ayo lo, menenër yam ranġah. Log mehö nipaya neḳo nġaa nipaya vër loḳ nġaa nipaya sën nesupin meneggëp loḳ ayo lo, menenër yam ranġah. Mehönon avij nenër ġaġek sën neggëp loḳ ayoj lo, meneyam ranġah.” ");
INSERT INTO bzh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ham ayemin neloḳ sa bë, ‘Mehöböp, Mehöböp!’ rëḳ ham su nenġo sayeġ rë in va? ");
INSERT INTO bzh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Alam sën denam vu sa bedegenġo sa ġaġek bedesepa doḳ lo ");
INSERT INTO bzh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","og sir nebë mehö sën lev yi begganġ raḳ nedo ġelönġ böp, belev mudeng len luḳ ya rot. Log bël vaar böpata beya mevuv raḳ begganġ lo, rëḳ su yoh vu bë kevoh rë. In mehö sënë yö lev niwëëk mero. ");
INSERT INTO bzh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Gaḳ alam sën degenġo sa ġaġek rëḳ su desepa doḳ rë lo, og sir nebë mehö sën lev yi begganġ raḳ nedo dob vavunë mu lo. Su lev mudeng luḳ ya ġebinë rë, om bël vaar beya mevuv raḳ begganġ saga, lob kevoh ya pevis, benipaya raḳ ya veröḳ yi.” ");
INSERT INTO bzh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu nër ġaġek sënë vu alam ggovek, log ya raḳ beya meluḳ ya Kapernaum. ");
INSERT INTO bzh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Alam-beġö-yi vu Rom yu ti yoh vu mehödahis nemadvahi (100) hir ggev nedo, beyi hur ti nedo, lob ahë neving yi rot, rëḳ hur töḳ vu niraḳsën, bedus raḳ bë nadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Loḳ alam-beġö-yi hir ggev sënë nġo bë Yesu ya verup nedo, lob vonġ Yuda hir ggev la deya vu yi in bë na denanër vu benam gevonġ beyi hur nivesa jaḳ. ");
INSERT INTO bzh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ya deverup vu Yesu, lob deketaġ niwëëk vu bë, “Mehö sënë yi mehö nivesa, om yoh vu bë ġedoḳ vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ahë neving hil Yuda, beyö lev hil Yuda hil dub-supinsën-yi ti.” ");
INSERT INTO bzh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Lob losho Yesu deyah, beya deverup dus raḳ begganġ, loḳ alam-beġö-yi hir ggev vo ġaġek vu yi mehö la medeḳo medeya vu Yesu bë, “Mehöböp, su ġebasap honġ, in saḳ su mehö niġ vesa yoh vu in bë ġedoḳ na sa begganġ rë. ");
INSERT INTO bzh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Log sa su niġ vesa in bë senök vu honġ geving rë. Om yiḳ ġenanër jaḳ avim mu, gesa hur rëḳ nivesa jaḳ. ");
INSERT INTO bzh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gaḳ yiḳ sa mehö los niġ wëëk ti ving. Sa nahurek sa alaġ babu, log senġo sa alam-beġö-yi sën sa neheġin sir lo deneggurek sa babuġ ving nebë saga. Bë sa nanër vu sir ti nabë, ‘Ġena!’, og rëḳ na. Log bë sa nanër vu ngwë nabë, ‘Ġenam!’, og rëḳ nam. Log bë sa nanër vu sa hur nabë, ‘Gwevonġ huk sënë!’, og rëḳ gevonġ. Om yiḳ ġenanër jaḳ avim mu og yiḳ yoh vu.” ");
INSERT INTO bzh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu nġo ġaġek sënë, lob ranġa nema geggërin yah vu alam yu böpata sën losho denesepa sir medeneya lo bë, “Sa nanër vu ham yönon nabë sa su töḳ vu Israel ti gayo neyam timu vu sa nebë sënë rë.” ");
INSERT INTO bzh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Log alam sën alam-beġö-yi hir ggev vonġ sir ya lo yah deverup begganġ loḳ delë bë hur lo nivesa loḳ menedo. ");
INSERT INTO bzh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Heng to, lob Yesu ya nyëġ böp ti arë nebë Nain. Lob yi hur maluh losho alam nġahiseḳë rot deya ving yi. ");
INSERT INTO bzh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Lob ya deto dus raḳ nyëġ böp saga yi aggata avi, loḳ alam devaḳu heljënġ ti meya verup deneya bedub. Heljënġ sënë ata yam ving. In yiḳ nalu aġuu perurek timu sën diiḳ agi, geyi avëh alov. Log alam nġahiseḳë vu nyëġ saga desepa sir medeyam ving. ");
INSERT INTO bzh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lob Yesu lë avëh saga mekwa paya in rot, lob nër vu bë, “Su ġengu!” ");
INSERT INTO bzh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Lob to meya dus bebë nema raḳ reek sën devaḳu heljënġ loḳ lo, lom denare. Log Yesu nër bë, “Hur maġëm-e! Sa nanër vu honġ nabë kwedi jaḳ!” ");
INSERT INTO bzh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Lob heljënġ lo kedi raḳ menedo benevengwënġ. Log mëm Yesu vonġ yi yah vu ata. ");
INSERT INTO bzh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nebë sënë, lob alam pin deggöneng bemëm deḳo Anutu arë raḳ medenër bë, “Mehö-nenër-ġaġek-ranġahsën böpata ti sën verup nare loḳ hil vuheng atov agi.” Gedenër ving bë, “Anutu yam in doḳ vu yi alam.” ");
INSERT INTO bzh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lob denër Yesu bengö sënë ya meyoh vu distrik Yudea los nyëġ vahi pin. ");
INSERT INTO bzh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mehö-neripek-alam Jon yi hur maluh denër nġaa pin sën Yesu nevonġ lo vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Lob Jon tahi yi hur maluh luu ya vu yi bevonġ luho ya in bë dedoḳ tepëḳ vu Mehöböp nabë, “Yiḳ honġ mehö sën denenër bë rëḳ nam lo sënë, ma he rëḳ medo ġeġin yi rë?” ");
INSERT INTO bzh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lob luho ya deverup vu Yesu medenër bë, “Mehö-neripek-alam Jon vonġ aluu yam vu honġ genër bë, ‘Maḳ yiḳ honġ mehö sën denenër bë rëḳ nam lo sënë, ma he rëḳ medo ġeġin yi rë?’” ");
INSERT INTO bzh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lob loḳ buk sënë, Yesu medo nevonġ alam niraḳsën aggagga menijvesa neraḳ. Netii memö to deneya in sir, genevonġ balam malaj ḳenod denelë nyëġ ggökin. ");
INSERT INTO bzh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Lob Yesu nër yah vu luho bë, “Melu nah mena nanër nġaa sën melu nelë los nenġo agi vu Jon nabë: Alam malaj ḳenod denelë nyëġ, galam vahaj paya deneya aggata, galam nij sevuuḳ nij veseek neraḳ, galam nengaj mir denenġo ġaġek, galam sën denediiḳ lo vesaj neloḳ yah, log alam sën denedo paya in nġaa navij yi lo denenġo Bengö Nivesa. ");
INSERT INTO bzh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Om mehö sën su kwa neya luu luu in sa rë lo, og kwa vesa.” ");
INSERT INTO bzh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon yi hur luho deyah, loḳ mëm Yesu nër Jon yi degwa vu alam bë, “Wirek ham ya nyëġ-yumeris in bë ham gwele mehö nebë va? Maḳ ham ya in bë gwelë nabë ayööng neḳo dee ti menekepë ya geneyom-a? ");
INSERT INTO bzh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ma ham ya in bë gwelë mehö nebë va? Maḳ ham bë gwelë mehöti neröp tob niyes mala nġeri nġeri? Ma. Alam sën deneröp tob niyes los denedo raḳ nġaa nivesa vesa lo, og sir sagaḳ yö denedo ggëp alam-los-bengöj bej. ");
INSERT INTO bzh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma ham ya in bë gwelë mehö nebë va? Mehö-nenër-ġaġek-ranġahsën ti? Ëë-ë, om mëm sa nanër vu ham nabë, mëm yi mehö-nenër-ġaġek-ranġahsën, bekesuu alam denenër-ġaġek-ranġahsën pin. ");
INSERT INTO bzh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yiḳ mehö saga sën ġaġek raḳ yi loḳ Anutu-yi-ḳapiya lo bë: Gwenġo rë, sëḳ ġevonġ sa hur ti namuġin mena negetonġin aggata in honġ. ");
INSERT INTO bzh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Om sa nanër vu ham nabë: Jon arë böp rot kesuu alam pin sën ataj neḳo sir vu dob agi. Rëḳ mu alam sën denesepa loḳ sa bedenetu Anutu-yi-alam lo pin, og rëḳ dekesuu Jon.” ");
INSERT INTO bzh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Denġo ġaġek sënë ggovek, log alam pin losho alam sën deneḳo takës* lo denër bë, “Yönon. Anutu nevonġ nġaa niröp.” In deneripek bël raḳ Jon nema. ");
INSERT INTO bzh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Rëḳ alam Parisai* losho alam-horek-yi, og su deyam beJon ripek sir rë, gaḳ deruu demij vu aggata nivesa sën Anutu bë tateḳin vu sir lo. ");
INSERT INTO bzh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Log Yesu nër bë, “Om maḳ sëḳ tateḳin ham alam buk sënë jaḳ va? Maḳ ham nebë va? ");
INSERT INTO bzh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ham nebë hurmahen sën ggëp deneggök telig medenetahi vu sir vewen bë: ‘He nasis ggaġeng, rëḳ ma geham su nelöö rë. Gehe nasu kwamin paya paya, rëḳ ham su nesu menepengah ham ving rë.’ ");
INSERT INTO bzh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","In mehö neripek alam Jon yam, lom su negga nos los nenum wain rë. Loḳ ham nenër bë, ‘Memö neloḳ vu yi.’ ");
INSERT INTO bzh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Log Mehönon Nalu yam, lob negga los nenum, loḳ ham nër yi bë, ‘Ham gwelë, mehö saguḳ mehö ahëta, gemehö sën yö nenum wain panġsën. Galam sën deneḳo takës* lo, losho alam sën denevonġ nġaa nipaya lo vahi hir mehö yi.’ ");
INSERT INTO bzh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Rëḳ mu hil ġalë Anutu yi huk los kwa, lob mëm hil ajaḳ ni nabë mehö los kwa ti.” ");
INSERT INTO bzh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Alam Parisai* ti tahi Yesu bë na mega nos geving yi, lob ya ben bemedo negga nos. ");
INSERT INTO bzh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lob avëh nipaya ti nedo nyëġ sagu, lob nġo bë Yesu medo negga nos loḳ Parisai* sënë yi begganġ. Lob ḳo wël reggu malanġeri loḳ buayo ġelönġ alabasta* veroo ti beya vu. ");
INSERT INTO bzh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ya verup nare loḳ Yesu demi dus vu vaha gemedo nesu, lob mala ruḳ töö raḳ Yesu vaha, log revu raḳ yu viis. Log mul Yesu vaha, gekeseh wël merikin raḳ vaha. ");
INSERT INTO bzh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Rëḳ Parisai* sën tahi Yesu meya negga nos ving yi lo lë nġaa sënë, lob kwa nevo bë, “Yönon, bë mehö sënë yi mehö-nenër-ġaġek-ranġahsën, og rëḳ jaḳ avëh sën nema raḳ yi agi ni, gejaḳ ni geving nabë avëh nipaya.” ");
INSERT INTO bzh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nebë sënë loḳ Yesu raḳ ni benër yah vu yi bë, “Simon, sa kwaġ nevo ġaġek ti, om sa bë nanër vu honġ.” Loḳ Simon nër bë, “Tatovaha, ġenanër nam.” ");
INSERT INTO bzh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Lob Yesu nër bë, “Mehöti vo nġaa vu mehö luu meya neggëp vu luho, geluho su devo loḳ rë. Ngwë yi K500, gengwë yiḳ hen K50 mu. ");
INSERT INTO bzh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Rëḳ luho su deyoh vu bë debo doḳ nah rë, lob mehö sënë nilël raḳ luho. Om mehö ngwë tena sën rëḳ ahë geving yi rot-a?” ");
INSERT INTO bzh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Loḳ Simon nër yah bë, “Sa kwaġ nevo bë mehö sën yi nyëvewen böpata mesevöḳ lo maḳ ahë neving monë ala rot mekesuu.” Lob Yesu nër vu bë, “Ġenër yoh vu.” ");
INSERT INTO bzh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Loḳ Yesu ggërin yah vu avëh sënë genër vu Simon bë, “Gwelë avëh sënë? Seyam honġ begganġ ayo, rëḳ su ġevo bël vu sa in bë sejipek vahaġ rë. Rëḳ avëh sënë og ripek sa vahaġ raḳ mala ruḳ gerevu raḳ yu viis. ");
INSERT INTO bzh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Log seloḳ yök begganġ ayo rëḳ su ġemul* sa rë, rëḳ avëh sënë og yö medo nemul* sa vahaġ rot. ");
INSERT INTO bzh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Log su ġerikin wël teka raḳ sa yuġ rë, rëḳ avëh sënë loḳ wël nivesa rot sagi raḳ sa vahaġ. ");
INSERT INTO bzh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Om sa nanër vu honġ yönon nabë: Avëh sënë ahë neving Anutu panġsën rot in yi nġaa nipaya nġahiseḳë rot, rëḳ ma gAnutu dahun ya bemaya. Gaḳ mehö sën nġaa nipaya mahen mu neggëp vu yi, lob Anutu dahun ya lo, og yiḳ ahë neving yi mahen teka mu.” ");
INSERT INTO bzh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Log Yesu nër vu avëh bë, “Sa dahun honġ nġaa nipaya ya vorot.” ");
INSERT INTO bzh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lob alam sën losho medo denegga nos lo kedi denër yah meyom vu sir bë, “Mehö sënë maḳ yi re om sën bë dahun nġaa nipaya na-ë?” ");
INSERT INTO bzh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Log Yesu nër vu avëh lo bë, “Ayom neyam timu vu sa, om Anutu ḳo honġ yom vu yi vorot. Kwam vesa meġena los ayom sepëp.” ");
INSERT INTO bzh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ggovek loḳ Yesu ya neḳo loḳ nyëġ böp böp los begganġ-bu mahen mahen, benenër Bengö Nivesa ranġah vu sir raḳ Anutu-yi-nyëġ. Lob yi hur maluh nemadluho-mevidek-luu lo deya ving yi. ");
INSERT INTO bzh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Gavëh la sën wirek Yesu netii memö in sir los nevo niraḳsën vër in sir lo deya ving. Sir sënë: Maria sën denenër bë Maria vu Magdala, beYesu tii memö nemadvahi-bevidek-luu to deya in yi wirek lo. ");
INSERT INTO bzh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ga, Kusa sën neġin Herot* yi begganġ lo venë Yoana, ga, Susana, gavëh vahi ving, melosho deya. Avëh pin sënë deneloḳ vu Yesu losho yi hur maluh lo raḳ hir monë lu nġaa. ");
INSERT INTO bzh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Alam yu böpata desupin sir medenedo galam vu nyëġ pin deyam vu Yesu, lob nër ġaġek peggirinsën ti sënë vu sir bë, ");
INSERT INTO bzh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mehö netetëhin nos ġahis ti to meya huk anon in bë tetëhin yi nos ġahis. Netetëhin nos ġahis, lob vahi to nedo loḳ aggata sën neyoh huk vuheng lo, lob mehönon denevaḳë gesoḳ yam degga. ");
INSERT INTO bzh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ga, ġahis la to meraḳ nedo dob mahen teka sën raḳ neggëp ġelönġ vavunë, lob kip rëḳ bël ma, lob meran mediiḳ ya. ");
INSERT INTO bzh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Log ġahis la to meloḳ ya nedo vos nigginggin ayo, lob vos nigginggin sënë kip berig, lob ggök nos bevonġ paya. ");
INSERT INTO bzh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Log mëm ġahis la to meluḳ ya nedo dob jeji, lob kip merig besis anon nivesa. Nesis dahis nemadvahi vahi.” Log nër bë, “Bë mehöti nenga neggëp, og genġo ġaġek sënë.” ");
INSERT INTO bzh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Lob yi hur maluh deloḳ tepëḳ vu yi in ġaġek peggirinsën sënë degwa. ");
INSERT INTO bzh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Loḳ nër bë, “Anutu yö tateḳin yi nyëġ yi ġaġek vunsën degwa vu ham, beham rëḳ jaḳ ni. Rëḳ alam vahi og degenġo ġaġek peggirinsën mu, ‘in malaj rëḳ gelë, rëḳ mu su rëḳ dejaḳ ni rë. Log rëḳ degenġo ġaġek, rëḳ mu su rëḳ dejaḳ degwa ni rë.’” ");
INSERT INTO bzh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ġaġek peggirinsën sagi degwa nebë: Nos ġahis sënë yiḳ Anutu yi ġaġek. ");
INSERT INTO bzh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Log ġahis la sën to nedo loḳ aggata lo, yiḳ alam sën denenġo ġaġek, loḳ Satan ya neḳo vër in ayoj in bë rëḳ degevonġ geving lob Anutu geḳo sir nah lo. ");
INSERT INTO bzh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Log ġahis la sën to nedo loḳ nyëġ ġelönġ lo, yiḳ alam sën denġo ġaġek bekwaj vesa in lo, rëḳ mu su luḳ ya ayoj rë. Gaḳ yiḳ devonġ ving dus teka, loḳ seggisën töḳ vu sir lom delëëin ya. ");
INSERT INTO bzh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Log ġahis la sën to meloḳ ya vos nigginggin ayo lo, og yiḳ alam sën denġo ġaġek medeya medeya, loḳ tum newaj raḳ in maggin aggagga, gemonë los nġaa-dob-yi sën nesemu hil navid lo pin ggök ya, lom su anon raḳ rë gediiḳ ya. ");
INSERT INTO bzh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Gaḳ ġahis sën to meluḳ ya dob jeji lo, og alam sën denġo ġaġek medejom ahon bayoj neya niröp beneggëp nivesa, gedenedo niwëëk medenevonġ banon neraḳ lo.” ");
INSERT INTO bzh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Mehöti su netaggi loḳ ram genekeyoveḳin dëg raḳ, ma netunġ ggevek ya reek len rë. Gaḳ netunġ raḳ ya vavunë, in bë alam sën dedoḳ na begganġ ayo lo degelë nyëġ. ");
INSERT INTO bzh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Lob nġaa pin sën neggëp vunsën gwëbeng agi rëḳ natöḳ nam ranġah. Genġaa pin sën mehönon deneloḳ kesii in lo, rëḳ natöḳ nam ranġah vu tamusën balam pin dejaḳ ni. ");
INSERT INTO bzh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ham gwebë nengamin, in ham gwenġo ġaġek megwero. Mehöti sën neraḳ ġaġek la degwa ni bekwa nevo lo, og rëḳ jaḳ la degwa ni geving rot. Gemehöti sën su neraḳ ġaġek degwa ni rë lo, og rëḳ kwa birekin teka sën neraḳ ni lo benama na veröḳ yi.” ");
INSERT INTO bzh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Loḳ buk saga Yesu ata lo ari lo deya in bë degelë yi, rëḳ alam yu böpata desup sir medenedo, lob su deyoh vu bë dedoḳ na vu yi rë. ");
INSERT INTO bzh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Loḳ mehö la denër ya vu yi bë, “Atam losho arim lo verup denare dobnë. Deyam in bë degelë honġ.” ");
INSERT INTO bzh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Loḳ nër yah vu sir bë, “Alam sën denenġo Anutu yi ġaġek medenesepa loḳ lo, og sir saga sën sa ataġ lo arig lo.” ");
INSERT INTO bzh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Buk ti lob Yesu losho yi hur maluh deraḳ ya yaġ, lom nër vu sir bë, “Hil ajaḳ mana nġaggee nenga vahi.” Lom deya. ");
INSERT INTO bzh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yaġ neya geYesuḳ ggëp yiing. Log sanġ böpata ti verup, lob vonġ benġaggee neluḳ ya yaġ ayo bevuuḳ loḳ bedus raḳ bë malaj nama. ");
INSERT INTO bzh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lob ya deggee vu Yesu gedenër vu bë, “Tatovaha! Hil hevonġin malad nama!” Lob kedi petupek raḳ sanġ los nġaggee sën netëë lo, lob sanġ los nġaggee ahë yes raḳ, gededun ma geneggëp. ");
INSERT INTO bzh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Log nër vu sir bë, “Ham su ayomin neyam timu vu sa yönon rë!” Lom deggöneng gekwaj ya nġahi medenenër vu sir bë, “Maḳ mehö sënë yi nebë va, om sën nër vu sanġ los bël, lob denġo aye-ë?” ");
INSERT INTO bzh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Loḳ ya deverup Gadara hir dob ga, distrik Galilea neggëp nġaggee nenga vahi yi, genyëġ sënë neggëp vahi. ");
INSERT INTO bzh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Lob Yesu vu yaġ mepesönġ ya roneḳ, loḳ alam nyëġ sënë ti verup vu yi. Memö la denedo loḳ mehö sënë meyö medo neya ahë töḳsën yö wirek la, lob su nedo loḳ begganġ rë, gaḳ yö ya neggëp loḳ waaḳ sën denebë mehönon seḳëj loḳ lo. ");
INSERT INTO bzh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mehö sënë lë Yesu, lob nġeeḳ geto petev meneggëp loḳ vaha. Log nġeeḳ böpata bë, “Yesu! Anutu Vavunë Nalu honġ! Bë gwevonġ va vu sa? Sa ḳetaġ vu honġ nabë su ġebasap sa!” ");
INSERT INTO bzh_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nër bë sënë in Yesu nër vu memö bë geto mena in mehö sënë, in memö sënë nejom yi ahon beron nġahiseḳë. Lob yi alam malaj nesepa yi medeneduu raḳ sëng los aën buk nġahi, rëḳ ma genevepul sëng lu nġaa pin. Gememö sënë netë meneya nyëġ-yumeris. ");
INSERT INTO bzh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Lob Yesu loḳ tepëḳ vu yi bë, “Arëm re?” Loḳ nër yah bë, “Mehömehö.” In degwa nebë memö nġahiseḳë denedo loḳ yi. ");
INSERT INTO bzh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lob memö pin saga detahi ya vu Yesu bë, “Su gwetii he doḳ na asoreng böpata sën adingseḳë rot lo!” ");
INSERT INTO bzh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Log bööḳ yu ti vare deneruuk raḳ ḳedu dus vu sir, lob memö lo deketaġ vu Yesu bë, “Mëm gwevonġ he na vu bööḳ sagu!” Lob Yesu vonġ sir ya. ");
INSERT INTO bzh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Lob memö lo to deya in mehö sënë beya deloḳ ya bööḳ yu ti sënë. Lob pevis gebööḳ pin deseröġ rot beya devës ya nyëġ vaha degwa, bedeluḳ ya nġaggee merehöö sir bemalaj maya veröḳ yi. ");
INSERT INTO bzh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lob alam sën deneġin bööḳ lo delë, lob deveya medeya, beya denër nġaa sënë vu alam nyëġ böp los mahen mahen pin. ");
INSERT INTO bzh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Lob alam saga deya in bë degelë nġaa sën to meya lo. Yah deverup vu Yesu bedelë mehö sën memö to deya in yi lo, gevëh tob gekwa nevo nġaa nivesa, genedo loḳ Yesu vaha. Loḳ tum deneggöneng in sir rot. ");
INSERT INTO bzh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Loḳ mëm alam sën delë nġaa agi raḳ malaj lo deturin nġaa sën Yesu vonġ vu mehö sën memö neloḳ vu yi wirek loḳ nivesa raḳ agi medero. ");
INSERT INTO bzh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lob alam pin vu Gadara denër vu Yesu bë kedi jaḳ mena, gesu medo hir nyëġ. In deneggöneng rot. Lob Yesu raḳ yah yaġ meyah meya. ");
INSERT INTO bzh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Loḳ mehö sën memö to deya in yi lo ketaġ vu Yesu bë na geving yi. Rëḳ Yesu vonġ yi yah genër vu bë, ");
INSERT INTO bzh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ġenah meġena böm, meġena ġenanër nġaa pin sën Anutu vonġ vu honġ lo vu honġ alam.” Lob mehö lo yah meya menër nġaa pin sënë vu alam ggëp yi nyëġ. ");
INSERT INTO bzh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu yah to, lob alam pin kwaj vesa in yi, in medo deneġin yi geyah to. ");
INSERT INTO bzh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Loḳ mehöti arë nebë Yairus ya verup. Dub-supinsën-yi ala ti yi, lob ya verup petev meneggëp loḳ Yesu vaha, geketaġ vu yi bë na yi begganġ. ");
INSERT INTO bzh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","In yiḳ nalu mewing timu beyi ta nemadluho-bevidek-luu raḳ, lob dus raḳ bë nadiiḳ. Lob Yesu neya raḳ, loḳ alam nġahiseḳë depeḳa raḳ yi rot belosho deneya. ");
INSERT INTO bzh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lob avëh ti neya ving. Niḳöḳ yö medo neyam yoh vu nġebek nemadluho-bevidek-luu, rëḳ mehöti su yoh vu bë gevonġ menivesa jaḳ nah rë. ");
INSERT INTO bzh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Avëh sënë verup ya nare dus loḳ Yesu demi gebë nema raḳ Yesu yi tob nyë. Vonġ nebë sënë, lob niḳöḳ tewii ya avuti gesu neyom ggökin rë. ");
INSERT INTO bzh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Loḳ Yesu loḳ tepëḳ bë, “Re bë nema raḳ sa?” Loḳ sir pin denenër yah vu bë sireḳ ma. Log Pita nër bë, “Sa alaġ-e! Yiḳ alam nġahiseḳë sën denare tetup honġ meyök depeḳa raḳ honġ aga.” ");
INSERT INTO bzh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Loḳ Yesu nër bë, “Ma! Loḳ sir ti bë nema raḳ sa, mesa hanġo bë sa niġ wëëk la ya vu yi.” ");
INSERT INTO bzh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Lob avëh sënë raḳ ni bë nġaa sën vonġ lo töḳ yam ranġah, om nelëk rot, lob verup ya mepetev meneggëp loḳ vaha, genër sën bë nema raḳ yi tob lo degwa ranġah vu raḳ alam pin malaj benër ving bë yi niraḳsën maya avuti. ");
INSERT INTO bzh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Lob Yesu nër vu yi bë, “Naluġ-e, ayom yam timu vu sa, om vonġ benim vesa raḳ. Om ġenah meġena los ayom sepëp.” ");
INSERT INTO bzh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu nahën nevengwënġ vu avëh, log mehöti vu dub ala ben meverup nër vu dub ala sënë bë, “Nalum diiḳ ya, om su gweḳo Tatovaha mala seggi!” ");
INSERT INTO bzh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu nġo ġaġek sënë rëḳ nër yah bë, “Su newam jaḳ, gaḳ ayom nam timu vu sa mu, loḳ mëm nalum rëḳ vesa doḳ nah.” ");
INSERT INTO bzh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Lob Yesu töḳ ya ggev lo ben, lob nërin alam pin bë su dedoḳ na begganġ ayo geving yi. Gaḳ yiḳ ḳo Pita lööho Jon lu Yakobus ving hurmahen ama lu ata mu bedeloḳ ya. ");
INSERT INTO bzh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Galam yö medo denesu medenesis sir in, loḳ Yesu nër vu sir bë, “Ham su ngu. In sënëḳ su diiḳ rë, gaḳ yiḳ neggëp yiing mu.” ");
INSERT INTO bzh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Loḳ denöp raḳ yi, in deraḳ ni bë diiḳ ya veröḳ yi. ");
INSERT INTO bzh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Rëḳ Yesu jom loḳ avëh mahen nema getahi bë, “Avëh mahen-e, kwedi jaḳ!” ");
INSERT INTO bzh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Lob avëh mahen lo anon to meloḳ yah, log kedi raḳ pevis. Lob Yesu nër vu sir bë, “Ham bo nos la vu yi mega.” ");
INSERT INTO bzh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Lob avëh mahen ata lu ama ḳenuj ya mederanġa nemaj. Loḳ Yesu vo ḳoo vu luho bë luho su na denanër nġaa sënë vu mehöti. ");
INSERT INTO bzh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Log tahi hur maluh nemadluho-bevidek-luu lo deyam vu yi bevo niwëëk vu sir in bë denoh vu bedegetii memö geto dena, gedegevonġ meniraḳsën nama na. ");
INSERT INTO bzh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Log vonġ sir ya in bë denanër ġaġek jaḳ Anutu-yi-nyëġ, gedegevonġ balam nijraḳsën nijvesa jaḳ nah. ");
INSERT INTO bzh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Log nër vu sir bë, “Ham na, rëḳ mu ham su gweḳo ḳupeḳ sepa ham. Ham su natohin atohenġ, ga, gweje vahek, ma gweḳo nos, ma monë sepa. Geham su gweḳo röpröp luu luu sepa. ");
INSERT INTO bzh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Log nabë mehöti geḳo ham luu luu sënë doḳ na yi begganġ megeġin ham, og ham naḳööḳ doḳ begganġ timu saga rot beham nom jaḳ. ");
INSERT INTO bzh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Gaḳ nabë su degeḳo ham doḳ na hir begganġ rë, og ham tetëhin kebus in vahamin in dejaḳ ni nabë devonġ paya, log ham na jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nër nebë sënë ggovek, log ya deyoh vu nyëġ pin. Bedenenër Bengö Nivesa ranġah, gedenevonġ balam nijraḳsën nijvesa neraḳ yoh vu nyëġ pin. ");
INSERT INTO bzh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Log dob ala Herot* nġo nġaa pin sën Yesu nevonġ lo bengö, lob kwa neya nġahi in mehö la denenër bë Jon kedi vu bedub ggökin. ");
INSERT INTO bzh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Log la denenër bë Elia yom verup. Log la denenër bë alam sën denenër ġaġek ranġah wirek lo ti kedi raḳ yah ggökin. ");
INSERT INTO bzh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Rëḳ Herot* nër bë, “Joneḳ sa ḳetöv kwa lo. Gaḳ maḳ mehö re sën sa nehanġo bengö nebë agi?” Lob kwa nevo bë gelë yi jaḳ mala. ");
INSERT INTO bzh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sinarë lo deya geyom deverup, lob denër nġaa pin sën devonġ lo vu Yesu. Lob ḳo sir raḳ belosho yö detah sir ya nyëġ-yumeris ti dus vu Betsaida. ");
INSERT INTO bzh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Loḳ alam saga deraḳ ni lob desepa yi medeya. Ya detöḳ vu yi, lob vengwënġ vu sir los kwa vesa, benër Bengö Nivesa raḳ sën Anutu bë natu ala megeġin sir lo. Genevonġ balam nijraḳsën nijvesa neraḳ ving. ");
INSERT INTO bzh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Log sehuk luḳ, lob yi hur maluh nemadluho-bevidek-luu lo ya denër vu yi bë, “Gwevonġ alam sënë dena in dedoḳ na begganġ-bu böp los mahen sën denedo dus dus lo bena degëp, in denatöḳ vu nos lu nġaa rë. In hil nado sënëḳ nyëġ-yumeris tahsën.” ");
INSERT INTO bzh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Rëḳ Yesu nër yah vu sir bë, “Ham nġo rëḳ bet sir.” Loḳ denër yah bë, “Nos nġahi su nedo vu he rë. Gaḳ yiḳ brët nemadvahi ga, ġël luu mu nedo. Ma he yoh vu bë ana baġo nos in alam pin sënë?” ");
INSERT INTO bzh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","In alam nġahi rot denedo bemaluh yoh vu 5,000. Loḳ Yesu nër yah vu yi hur maluh lo bë, “Ham nanër vu sir nabë sir mehödahis luu menemadluho demedo jaḳ yu ti ti.” ");
INSERT INTO bzh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yi hur maluh devonġ nebë sënë balam pin to denedo. ");
INSERT INTO bzh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Log Yesu ḳo brët nemadvahi ga, ġël luu lo raḳ, gevarah mala raḳ yaġek gejom raḳ in los kwa vesa ya vu Anutu; log debu bevo vu yi hur maluh lo bë na debo gelek alam. ");
INSERT INTO bzh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Lob sir pin degga meyoh vu, log desupin vahi sën nedo lo loḳ ya sap nemadluho-bevidek-luu. ");
INSERT INTO bzh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lob buk ti rë lob Yesu medo nejom raḳ, geyi hur maluh denedo ving yi, lob loḳ tepëḳ in sir bë, “Alam denenër sa bë sa re?” ");
INSERT INTO bzh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Loḳ denër yah vu yi bë, “Sir la denenër honġ bë Mehö-neripek-alam Jon. Gela denenër honġ bë Elia. Gela denenër bë alam-denenër-ġaġek-ranġahsën wirek ti kedi raḳ yah ggökin.” ");
INSERT INTO bzh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Loḳ loḳ tepëḳ in sir ggökin bë, “Gaḳ hameḳ nenër bë sa re?” Loḳ Pita nër yah bë, “Anutu yi Kerisi* honġ.” ");
INSERT INTO bzh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Lob Yesu vo ḳooin niwëëk vu sir bë, “Om ham su na nanër ġaġek sënë ranġah vu mehöti.” ");
INSERT INTO bzh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Log nër ving bë, “Mehönon Nalu rëḳ geḳo maggin nġahiseḳë, galam-deneḳo-seriveng hir ggev losho alam-horek-yi lo rëḳ degeruu demij vu yi, gerëḳ dengis yi menadiiḳ, gebuk natu löö loḳ kedi jaḳ nah gökin.” ");
INSERT INTO bzh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Log nër vu sir pin bë, “Mehöti bë natu sa hur, og kwa birek in yi gekerë yi ḳelepeḳo* noh vu buk metamuin sa. ");
INSERT INTO bzh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mehöti bë kwa bo yi begeġin nivesa, og rëḳ anon mala nama. Gaḳ mehöti bë kwa birek in yi menadiiḳ in sa, og rëḳ na medo mala-tumsën. ");
INSERT INTO bzh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Gaḳ nabë mehöti yö geḳo yi jaḳ in nġaa dob yi pin bemedo loḳ nadiiḳ, og yi nġaa sënë rëḳ doḳ vu yi nabë va? ");
INSERT INTO bzh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Log nabë mehöti göneng in mehönon bedah sa los sa ġaġek vun, og Mehönon Nalu rëḳ dah yi vun doḳ buk sën nom los Ama yö niwëëk garë böpata, gelos angër vabuung nij wëëk gevuneḳ vuneḳ yaġek yi lo. ");
INSERT INTO bzh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sa nanër vu ham yönon nabë alam sën denare agi vahi su rëḳ denadiiḳ rë, gaḳ rëḳ nahën demedo medegelë gAnutu nam in geġin hil.” ");
INSERT INTO bzh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu nër ġaġek sënë ggovek bebuk nemadvahi-mevidek-löö ya ggovek, loḳ ḳo Pita lööho Jon lu Yakobus medeya ḳedu, in bë najom jaḳ. ");
INSERT INTO bzh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Medo nejom raḳ, lob mala agga ngwë raḳ, geyi röpröp veroo meris nebë davës. ");
INSERT INTO bzh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Log pevis bemehö luu yam vare denevengwënġ ving yi. Yiḳ Moses lu Elia. ");
INSERT INTO bzh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Luho deyam los nij ḳapiik, meyam denenër nġaa pin sën Yesu rëḳ gevonġ gëp Yerusalem begovek genah mena lo tato vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita lööho malaj neggëp panġsën rot bë degëp yiing. Rëḳ su deneggëp yiing rë, lob delë Yesu niḳapiik ving mehö luu sën lööho denare lo. ");
INSERT INTO bzh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Lob luho bë degevuu Yesu gedenah jaḳ, lob Pita nër vu Yesu bë, “Sa alaġ-e! He nado mehalë nġaa sënë om mëm nivesa rot. Om he dev numeng löö: Ti vu honġ, gengwë vu Moses, gengwë vu Elia.” Pita su kwa vo mero rë, gaḳ newa raḳ om pevis menër nebë sënë. ");
INSERT INTO bzh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nahën nenër ġaġek sënë, log beggob ti yam kebu sir. Loḳ yam rot beggërin sir, lob newaj raḳ rot. ");
INSERT INTO bzh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Log ġaġek ti yam loḳ beggob ayo bë, “Sënëḳ sa naluġ. Sehooin yi raḳ ggovek ya. Om ham gwebë nengamin vu yi.” ");
INSERT INTO bzh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Denġo ġaġek sënë ggovek, log delë bë Yesu yö ti nedo. Lob ayej ma gesu denër nġaa sën delë agi lo vu mehöti loḳ buk saga rë. ");
INSERT INTO bzh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Log heng to, lob sir vu ḳedu beyah deto, loḳ alam yu böpata ti yam debuu Yesu ggëp aggata. ");
INSERT INTO bzh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lob sir ti pevis metahi ya bë, “Tatovaha, sa ḳetaġ vu honġ nabë gwelë sa naluġ aġuu sënë. In yiḳ sa naluġ perurek anon timu. ");
INSERT INTO bzh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Rëḳ memö nipaya ti nepesönġ raḳ yi pevis avuti, lob nenġeeḳ böpata. Log memö sënë nesesesin raḳ yi panġsën rot lob nyë ḳataḳ netunġ. Beyö nevasap yi rot, gesu nevuu yi pevis rë. ");
INSERT INTO bzh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Lob sa verup su vu honġ hur maluh lo bë degetii memö nipaya sënë geto mena, rëḳ ma gesu deyoh vu rë.” ");
INSERT INTO bzh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Loḳ Yesu nër yah bë, “Oo ham alam vu buk sënë, ham ayomin su neyam timu rë, log ham ayomin su neggëp niröp rë. Om sëḳ nahën medo geving ham buk va la geving meḳerë ham maggin-a? Maam gweḳo nalum nam.” ");
INSERT INTO bzh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hurmahen sënë nahën neya vu Yesu, log memö lo të yi to mesap nyëġ, genesesesin raḳ yi panġsën. Loḳ Yesu petupek raḳ memö lo, gevonġ behurmahen nivesa raḳ, log vonġ yah vu ama. ");
INSERT INTO bzh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Lob alam pin delë Anutu niwëëk sënë, lob delëk anon mederanġa nemaj. Nahën medo mekwaj neya nġahi in nġaa pin sën Yesu nevonġ agi, log Yesu nër vu yi hur maluh lo bë, ");
INSERT INTO bzh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ham gwebë nengamin vu ġaġek sënë megwero! Nahub rëḳ rëḳ debo Mehönon Nalu doḳ na mehönon nemaj.” ");
INSERT INTO bzh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Rëḳ su deraḳ ġaġek sënë ni rë. Ġaġek sënë degwa vun yi in sir, besu kwaj töḳ vu rë. Rëḳ deggöneng in yi gesu deloḳ tepëḳ in degwa rë. ");
INSERT INTO bzh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Log yi hur maluh deḳo ġaġek ti raḳ medemehoo sir in bë sir ti tena böp kesuu sir vahi. ");
INSERT INTO bzh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Loḳ Yesu raḳ ġaġek sën kwaj nevo loḳ ayoj lo ni, lob ḳo hurmahen ti yam nare ving yi ");
INSERT INTO bzh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","genër vu sir bë, “Mehöti bë kwa bo sa begevonġ nivesa vu hurmahen teka nabë sënë, og nevonġ nivesa vu sa. Log mehöti sën gevonġ nivesa vu sa lo, og nevonġ nivesa vu yi sën vonġ sa meseyam lo. Om ham ti sën dahun yi benevonġ nivesa vu ham pin lo, og tu böp vorot ggëp Anutu mala. ");
INSERT INTO bzh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Loḳ Jon nër yah vu yi bë, “Sa alaġ-e! He halë mehöti genenër arëm los niwëëk benetii memö to deneya, loḳ he nërin yi in hil los su nesepa hil rë.” ");
INSERT INTO bzh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Rëḳ Yesu nër yah vu sir bë, “Ham su nanërin yi, in mehöti sën su nelë ham paya rë lo, og neloḳ vu ham.” ");
INSERT INTO bzh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Buk sën Anutu geḳo Yesu jaḳ nah yaġek lo dus raḳ, lob Yesu kwa veröḳ raḳ bë na Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Lob vonġ yi hur maluh luu medeḳo ġaġek muġin meya deloḳ ya Samaria* hir nyëġ ti in bë degero nġaa vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Rëḳ alam vu nyëġ sagu nij lël bë su rëḳ degeḳo Yesu doḳ na hir begganġ rë. In deraḳ ni bë yö rëḳ berup na Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hur maluh luu sënë, Jon lu Yakobus, delë nġaa sënë, lob luho denër bë, “Mehöböp, maḳ hil tahi nengwah vu yaġek duḳ nam ga alam sënë?” ");
INSERT INTO bzh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Loḳ Yesu ggërin yah bevonġ ġaġek raḳ luho. ");
INSERT INTO bzh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Log deya raḳ medeya begganġ-bu ngwë. ");
INSERT INTO bzh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nahën medo deneyök aggata, lob mehöti nër vu Yesu bë, “Nyëġ pin sën ġena lo, og sëḳ sepa honġ mena geving.” ");
INSERT INTO bzh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Loḳ Yesu nër yah vu bë, “Anöösik lej neggëp, gesoḳ newisej nedo, gaḳ Mehönon Nalu, og ben sën gëp doḳ lo ma.” ");
INSERT INTO bzh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Log nër vu mehö ngwë bë, “Ġenam ġesepa sa.” Loḳ nër bë, “Amaġ nadiiḳ besedev rë loḳ mëm.” ");
INSERT INTO bzh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Loḳ Yesu nër vu bë, “Alam diiḳsën yö rëḳ dedev hir heljënġ. Gaḳ honġ, og ġena ġenanër ġaġek jaḳ sën Anutu natu ala megeġin hil lo.” ");
INSERT INTO bzh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Loḳ mehö ngwë nër vu yi bë, “Mehöböp, sa hevonġin bë nök sepa honġ, om ġenaḳööḳ gesenah najom sa alam nemaj rë. ");
INSERT INTO bzh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Loḳ Yesu nër vu bë, “Mehö sën ḳo huk raḳ rëḳ kwa luu luu in lo, og su yoh vu bë doḳ na Anutu-yi-nyëġ rë.” ");
INSERT INTO bzh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ggovek, log ggooin alam 70 raḳ ving, bevonġ sir luu luu demuġin medeya nyëġ böp los mahen pin sën rëḳ na lo. ");
INSERT INTO bzh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Log peggirin ġaġek menër vu sir bë, “Nos nġahiseḳë anon loḳ menedo huk anon, rëḳ alam sën deketöv medengupin lo su nġahi rë. Om ham kwetaġ vu huk ala nabë gevonġ yi hur na debo yi nos medengupin nom. ");
INSERT INTO bzh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Om ham na jaḳ. Rëḳ mu ham gwenġo rë, sa nehevonġ ham ya nebë sën sipsip deneloḳ ya anöö bemën avij. ");
INSERT INTO bzh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Om ham su banuh jej monë-yi ma, gweje vahek ma, gweḳo suu sepa. Geham su bengwënġ in alam medenajom ham ahon doḳ aggata. ");
INSERT INTO bzh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nabë ham doḳ na begganġ ti, og ham benġev jaḳ in sir menanër namuġin nabë sënë, ‘Alam begganġ ayo ti sënë ayoj gëp revuh.’ ");
INSERT INTO bzh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","In lob nabë mehöti nedo ayo revuh loḳ begganġ saga, og ham ġaġek semusën saga rëḳ semu yi. Rëḳ nabë sir ti su nebë saga menedo rë, og ham ġaġek sën ham nër ya lo, yö rëḳ pekwë menom semu ham. ");
INSERT INTO bzh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Log yiḳ ham naḳööḳ doḳ begganġ timu saga, beham gwa los nanum nġaa sën denevonġ vu ham lo. In mehö sën nevonġ huk lo, og netöḳ raḳ nyëvewen raḳ yi huk. Gaḳ ham su medo mepesönġ doḳ begganġ ti ti lo. ");
INSERT INTO bzh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nabë ham doḳ na nyëġ böp ti, lob degeḳo ham na vu sir, og ham gwa nos sën debo vu ham lo. ");
INSERT INTO bzh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Geham gwevonġ behir alam nijraḳsën nijvesa jaḳ. Geham nanër nabë, ‘Anutu yi nyëġ vonġin anon jaḳ.’ ");
INSERT INTO bzh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gaḳ nabë ham doḳ na nyëġ böp ti, rëḳ su degeḳo ham na vu sir rë, og ham kwedi mena bare na nyëġ saga yi aggata nyë, genanër nah vu sir nabë, ");
INSERT INTO bzh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ham nyëġ sënë dob kebus gga raḳ he vahamin, rëḳ mu he netetëhin yök vu ham. Rëḳ mu ham nġo kwamin bo rë, in Anutu yök dus raḳ ham ggovek ya, rëḳ ma geham nimin lël in.’ ");
INSERT INTO bzh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Sa nanër vu ham nabë: Vu Buk-tamusën, og alam vu nyëġ nebë sënë rëḳ denatöḳ vu maggin böp rot kesuu alam Sodom.” ");
INSERT INTO bzh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Wöp-o! Ham Korasin! Gëpin ham! Log ham Betsaida! Gëpin ham! Bë mehöti gevonġ nġaa böp gëp alam Ture los Sidon hir nyëġ nabë sën sa hevonġ loḳ ham nyëġ agi, og rëḳ ayoj maggin in devonġ nġaa nipaya medegërin sir nom medegeyeh vahek duum gedebo rarii medemedo doḳ vewev degwa. ");
INSERT INTO bzh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Om doḳ buk-nyëvewen-yi, og ham rëḳ gweḳo maggin böpata rot kesuu alam Ture los Sidon. ");
INSERT INTO bzh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Log ham Kapernaum, ham bë kwerë ham jaḳ na vavunë? Ma! Ham rëḳ duḳ na Nyëġ-nengwah-yi.” ");
INSERT INTO bzh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Log nër vu yi hur maluh lo bë, “Mehöti bë genġo ham ayemin, og sagaḳ nenġo sayeġ. Log mehöti bë geruu demi vu ham, og sagaḳ neruu demi vu sa ving. Log mehöti bë geruu demi vu sa, og yiḳ neruu demi vu Mehö sën vonġ sa meseyam lo.” ");
INSERT INTO bzh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ggovek, galam 70 lo yom deverup, lob kwaj vesa rot gedenër bë, “Mehöböp, he nër arëm, lob memö nengaj yes ving meto deya.” ");
INSERT INTO bzh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Lob nër vu sir bë, “Ëë-ë sa nehalë gevonġ bë Satan vës vu yaġek nebë davës meyam sis yi. ");
INSERT INTO bzh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ham nġo! Sevo niwëëk vu ham, om ham yoh vu bë baḳë nyël los veveeyaġek böp, geham yoh vu bë dahun Satan yi nġaa vahi pin sën gevonġ beġö vu ham lo, genġaa ti su yoh vu bë gevonġ paya vu ham rë. ");
INSERT INTO bzh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Rëḳ mu ham su napisek in sën memö nengaj yes vu ham ayemin lo rë, gaḳ ham napisek in dekevu ham arëmin ya neggëp yaġek vorot.” ");
INSERT INTO bzh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Loḳ buk saga Anon Vabuung vonġ beYesu kwa vesa rot, lob jom raḳ bë, “Oo Amaġ, honġ Mehöböp vu yaġek los dob. Sa ahëġ nivesa vu honġ, in nġaa sënë neggëp vunsën in alam sën deneluḳ dub böp lo los alam los kwaj, gaḳ ġetato vu alam sën su deneluḳ dub böp rë lo mu. Yönon Amaġ, in yiḳ nġo kwam nevo bë gwevonġ nabë saga in nivesa.” ");
INSERT INTO bzh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Log nër ving bë, “Amaġ tunġ nġaa pin loḳ yam sa nemaġ ggovek ya. Log mehöti su raḳ Nalu ni rë, gaḳ Ama yö timu raḳ ni. Log mehöti su raḳ Ama ni rë, gaḳ yiḳ Nalu yö timu raḳ ni. Galam sën Nalu tato Ama vu sir lo, og deraḳ ni ving.” ");
INSERT INTO bzh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Lob Yesu ggërin yah menër vu yi hur maluh mu bë, “Alam sën denelë nġaa sën ham nelë raḳ malamin agi, og kwaj vesa. ");
INSERT INTO bzh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yönon, sa nanër vu ham nabë: Wirek og alam-denenër-ġaġek-ranġahsën nġahi galam-los-bengöj nġahiseḳë denetunġ malaj in bë degelë nġaa sën ham nelë agi, rëḳ su denelë rë. Gedenebë nengaj in bë degenġo ġaġek sën ham nenġo agi, rëḳ su denenġo rë.” ");
INSERT INTO bzh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nebë saga lob alam-horek-yi ti kedi raḳ in bë seggi yi. Lob loḳ tepëḳ vu yi bë, “Tatovaha, sëḳ ġevonġ va in lob sa medo malaġ-tumsën degwata los degwata?” ");
INSERT INTO bzh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Loḳ Yesu loḳ tepëḳ yah vu yi bë, “Dekevu ġaġek nebë va meneggëp loḳ horek meġetevin-a?” ");
INSERT INTO bzh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Loḳ mehö saga nër yah vu bë, “Ahëm geving Mehöböp honġ Anutu los ayom dahis beḳenum los dahis, gahëm geving yi los nim wëëk pin, gekwam los dahis na vu yi timu. Log ahëm geving alam sën denedo dus vu honġ nabë sën nġo ahëm neving honġ lo.” ");
INSERT INTO bzh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Lob Yesu yoġekin bë, “Sagaḳ ġenër ya meyoh vu. Gwevonġ nabë saga, og mëm rëḳ ġemedo malam-tumsën degwata los degwata.” ");
INSERT INTO bzh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Rëḳ mehö saga vonġin bë tato yi nabë yi mehö nivesa, lom sën loḳ tepëḳ yah vu Yesu bë, “Alam sën denedo dus vu sa lo, og sir maḳ re lo?” ");
INSERT INTO bzh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Loḳ Yesu nër yah vu yi bë, “Mehöti vu Yerusalem meneluḳ meneya in bë na Yeriko. Lob alam-beġö-hodeḳ la detöḳ raḳ yi loḳ aggata, lob desis yi bedus raḳ bë nadiiḳ geneggëp loḳ aggata nenga. Log deggodeḳ yi tob lu nġaa pin bedeya. ");
INSERT INTO bzh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Loḳ alam-deneḳo-seriveng ti tetuu aggata saga beya meto, lob lë mehö saga, rëḳ ma geyö yoh aggata nenga vahi bekesuu meya. ");
INSERT INTO bzh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Log alam Levi* ti yiḳ vonġ nebë saga. Ya meto aggata saga belë yi geneggëp, rëḳ yoh aggata nenga vahi, bekesuu meya. ");
INSERT INTO bzh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Loḳ mëm Samaria* ti medo netamu beya meto belë mehö saga geneggëp, lob kwa pesivin yi. ");
INSERT INTO bzh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Lom to meya dus vu yi berikin wain los wël* raḳ beġö nyë, geteta. Log tunġ yi raḳ ya yi dogi, beḳo meya mebë loḳ ya vatëveḳ-bej ti beġin yi nivesa. ");
INSERT INTO bzh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Log heng to, lob vo kina luu vu mehö sën neġin vatëveḳ-bej lo, genër vu yi bë, ‘Gweġin mehö sënë nivesa. Genabë monë sënë su yoh vu rë lob ġebasap honġ monë la jaḳ geving, og sëḳ nom geto, lob mëm sebo doḳ nah honġ monë.’ ");
INSERT INTO bzh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nebë saga, om kwam nevo bë mehö löö sën deyoh aggata agi ti tena vonġ yoh vu nebë sën nedo dus vu mehö sën devasap yi agi?” ");
INSERT INTO bzh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lob mehö-horek-yi lo nër yah bë, “Mehö sën kwa pesivin yi lo.” Lob Yesu nër vu bë, “Om ġena jaḳ, log yiḳ gwevonġ nabë saga.” ");
INSERT INTO bzh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Loḳ tum ya medo deneḳo loḳ beya deverup begganġ-bu ti, lob Yesu loḳ ya, lob avëh ti arë nebë Marta ḳo yi loḳ ya ben. ");
INSERT INTO bzh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Log Marta ari ti nedo barë nebë Maria. Lob Maria verup nedo loḳ Mehöböp vaha menebë nenga vu yi ġaġek. ");
INSERT INTO bzh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Rëḳ Marta og nevonġ huk nġahi in neyeh nos lu nġaa, om kwa neya vu nġaa aggagga. Nevonġ nebë sënë, lob ya menër vu Yesu bë, “Mehöböp, arig vuu sa gesenġo ti nehevonġ huk böp meneheyeh nos. Ma su kwam nevo sënë rë? Om ġenanër vu Maria nabë nam doḳ vu sa.” ");
INSERT INTO bzh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Loḳ Mehöböp nër yah vu yi bë, “Marta, Marta, kwam neya nġahi genewam neraḳ in nġaa nġahiseḳë. ");
INSERT INTO bzh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Rëḳ mu hil naraḳ vu in nġaa timu, lob Maria ḳo nġaa nivesa sënë ya vu yi ggovek ya, lob hil su rëḳ abo nġaa nivesa sënë vër in yi rë.” ");
INSERT INTO bzh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Buk ti lob Yesu medo nejom raḳ loḳ nyëġ len ti. Jom raḳ ggovek, loḳ yi hur maluh ti nër vu yi bë, “Mehöböp, ġetahu he doḳ jomraḳsën nabë sën Jon netahu yi hur maluh wirek lo.” ");
INSERT INTO bzh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Loḳ nër yah vu sir bë, “Bë ham najom jaḳ, og ham nanër nabë sënë: ‘Amaġ, arëm yö gëp vabuung. Gemehönon pin degurek babum. ");
INSERT INTO bzh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ġebo nos vu he noh vu buk pin. ");
INSERT INTO bzh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Log ġedahun he nġaa nipaya na. In he nġo nedahun mehönon pin hir nġaa nipaya sën denevonġ vu he lo ya. Log su gweli he na vu pelëpinsën.’” ");
INSERT INTO bzh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Log nër vu sir ving bë, “Maḳ bë ham ti kedi mena vu yi alam ti doḳ buk vuheng menanër vu nabë, ‘Sa mehö-e! Ġebo brët löö vu sa rë, ");
INSERT INTO bzh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","in sehöġ vatëveḳ ti medo meyam benahën neverup vu sa, lob nos teka su nedo vu sa in bë ga rë.’ ");
INSERT INTO bzh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Loḳ yi alam ti sën lo maḳ rëḳ nanër nah vu yi nabë, ‘Su ġegwee vu sa. In sa vehii repinġ beniwëëk raḳ gehe los hurmahen ahëp yiing ya; om sa su yoh vu bë rëḳ ḳedi menök bo nġaa ti vu honġ rë.’ ");
INSERT INTO bzh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Rëḳ mu sa nanër vu ham nabë: Maḳ su rëḳ kwa bo yi mehö saga nabë bo vu yi rë, rëḳ mu netahi menegeyeh loḳ, om rëḳ kedi mebo nġaa pin sën neraḳ vu in lo vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Om sa nanër vu ham nabë: Bë ham kwetaġ nġaa vu Anutu, og rëḳ bo vu ham. Geham bë sero nġaa, og ham rëḳ natöḳ jaḳ. Geham bë pepa jaḳ repinġ, og Anutu rëḳ tahinin vu ham. ");
INSERT INTO bzh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","In alam pin sën deneketaġ nġaa vu Anutu lo, og nevo vu sir. Galam sën denesero nġaa lo, og denetöḳ vu. Galam sën denepepa raḳ repinġ lo, og Anutu netahinin vu sir. ");
INSERT INTO bzh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bë ham ti nalu ketaġ nos vu ama, og maḳ rëḳ bo ġelönġ ti vu yi? Ma bë ketaġ ġël vu yi, og maḳ rëḳ bo nyël ti vu yi? Ma! ");
INSERT INTO bzh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Log bë nalu ketaġ ḳöḳrëëh ġahis ti vu ama, og maḳ ama rëḳ bo veveeyaġek ti vu yi? Rëḳ nama! ");
INSERT INTO bzh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ham alam nimin paya rëḳ ham nevo nġaa nivesa vesa vu nalumin lo. Gaḳ Amaġ sën nedo yaġek lo nevonġ nġaa nivesa rot kesuu ham, om rëḳ bo Anon Vabuung vu alam sën deneketaġ vu yi lo.” ");
INSERT INTO bzh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu tii memö kwa nġengöleng ti to meya in mehöti, genevengwënġ nivesa. Lob alam kwaj neya nġahi mederanġa nemaj. ");
INSERT INTO bzh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Rëḳ sir vahi denenër bë, “Netii memö to deneya raḳ memö hir ala Belsebul* niwëëk.” ");
INSERT INTO bzh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Gesir vahi kwaj nevo bë deseggi Yesu, lom denër vu bë gevonġ nġaa böp yaġek yi ti medegelë. ");
INSERT INTO bzh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Rëḳ raḳ ayoj ni, lob nër vu sir bë, “Bë alam dob timu debasuh sir bedengis sir, og hir nyëġ rëḳ nabumeng na. Log alam degwa ti bë debasuh sir medengis sir, og rëḳ arëj nama na. ");
INSERT INTO bzh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Om nabë Satan losho yi alam debasuh sir na yu luu medengis sir, og hir nyëġ rëḳ gëp niwëëk nabë va? Senër sënë in ham nër bë sa nehetii memö raḳ Belsebul* niwëëk. ");
INSERT INTO bzh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Rëḳ bë Belsebul* neloḳ vu sa yönon besa nehetii memö to deneya, og maḳ re neloḳ vu ham alam besën denetii memö to deneya agi? Om ham alam saga degenġo ham ġaġek sagi medeseggi rë. ");
INSERT INTO bzh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Rëḳ mu nabë Anutu nema neloḳ vu sa, besa nehetii memö lo, og saga tato bë Anutu yam vu ham ggovek ya in bë geġin ham. ");
INSERT INTO bzh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nabë mehö niwëëk ti medo los nġaa-beġö-yi megeġin yi begganġ nivesa, og yi nġaa pin yö nedo nivesa. ");
INSERT INTO bzh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Rëḳ mu nabë mehö los niwëëk ngwë niwëëk kesuu yi beberup ngis yi medahun na, og nevo yi nġaa-beġö-yi sën kwa nevo bë rëḳ doḳ vu yi lo vër, betum bo yi nġaa pin vër bebo gelek yi alam. ");
INSERT INTO bzh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mehöti sën su neloḳ vu sa rë lo, og nesis beġö vu sa. Gemehöti sën su neloḳ vu sa menesupin sipsip ving rë lo, og netii sir meya denepalët loḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Memö nipaya sën to neya in mehönon ti lo, og to meya medo neyoh nyëġ nivevo menesero nyëġ len ti in bë sewah doḳ. Rëḳ su netöḳ vu rë lob nenër bë, ‘Maam saḳ nah mena ġalë begganġ sën sa nado loḳ wirek lo rë.’ ");
INSERT INTO bzh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Lob yah verup rëḳ nelë bë desekee begganġ sën lo bedevuneḳ vu menedo meris. ");
INSERT INTO bzh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Lob rengö yi beyah ḳo memö nemadvahi-bevidek-luu sën denevonġ nġaa nipaya rot medenekesuu yi lo, beyom denedo loḳ begganġ sënë. Lob mehö sën nedo paya wirek lo, mëm nedo paya ya veröḳ yi rot.” ");
INSERT INTO bzh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Alam yu böpata denedo, geYesu nenër ġaġek sënë, loḳ avëh ti nare loḳ sir vuheng bepisek in bë, “Avëh ti sën ḳo honġ wirek, bevo rur vu honġ lo, maḳ yö nedo los kwa vesa.” ");
INSERT INTO bzh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Rëḳ Yesu nër yah bë, “Rëḳ mëm alam sën denenġo Anutu yi ġaġek agi medenesepa loḳ lo, og mëm kwaj vesa rot mekesuu yi.” ");
INSERT INTO bzh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Log alam nġahiseḳë denesup sir yam ggök ggökin rot, lob nër vu sir bë, “Alam vu buk sënë og sir alam nij paya, om deketaġ bë degelë nġaa böp yaġek yi. Rëḳ mu sa su rëḳ tato nġaa böp ti vu sir rë. Gaḳ yiḳ sëḳ tato nġaa böp nabë sën Yona lo mu vu sir beggovek. ");
INSERT INTO bzh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wirek alam Nineve delë nġaa böp sën töḳ vu Yona lo mederaḳ ni medeggërin sir. Om yiḳ alam vu buk sënë rëḳ degelë nġaa böp natöḳ vu Mehönon Nalu nabë saga in dejaḳ ni medegërin sir. ");
INSERT INTO bzh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Log vu Buk-tamusën og Anutu rëḳ seggi mehönon hir ġaġek, lob rëḳ avëh-los-bengö vu sën sanġ neverup lo kedi bare menanër ġaġek jaḳ alam vu buk sënë nabë denevonġ nġaa nipaya. In wirek avëh sënë nedo dob nenga, rëḳ yam in bë genġo Solomon* yi ġaġek los kwa böp. Gaḳ mehö sën nedo gwëbeng agi kesuu Solomon*, rëḳ ham su nġo aye rë. ");
INSERT INTO bzh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Log vu Buk-tamusën og Anutu rëḳ seggi mehönon hir ġaġek, lob rëḳ alam Nineve kedi debare medenanër ġaġek jaḳ alam vu buk sënë nabë denevonġ nġaa nipaya. In alam Nineve denġo Yona aye medeggërin sir yah vu Anutu. Gaḳ mehö sën nedo gwëbeng agi kesuu Yona, rëḳ ham su wërin ham rë.” ");
INSERT INTO bzh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Mehöti su netaggi loḳ ram menevun luḳ ya reek len ma, nekeyoveḳin dëg raḳ rë. Gaḳ netunġ raḳ ya reek in bë alam sën dedoḳ na begganġ ayo lo degelë nyëġ. ");
INSERT INTO bzh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Log malam tu navim yi ram. Bë malam natum in nġaa nivesa, og ranġah rëḳ gegwanġ na navim pin los dahis. Gaḳ bë malam natum in nġaa nipaya, og navim pin rëḳ malaḳenu doḳ. ");
INSERT INTO bzh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Om gweġin honġ nivesa, in rëḳ ranġah sën nedo loḳ honġ lo malaḳenu doḳ. ");
INSERT INTO bzh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nabë navim pin ranġah rot, gelen ti su malaḳenu rë, og navim pin rëḳ ranġah na veröḳ nabë sën ram nejëh raḳ honġ.” ");
INSERT INTO bzh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu nër ġaġek sënë ggovek, log Parisai* ti nër bë na mega nos geving yi. Lob ya meloḳ ya begganġ ayo beya nedo ya tevor. ");
INSERT INTO bzh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Lob Parisai* sënë lë bë Yesu sesor meya nedo ya tevor menegga nos gesu ripek nema rë, lom kwa ya nġahi. ");
INSERT INTO bzh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Rëḳ Mehöböp nër vu yi bë, “Ham Parisai*, ham neripek kap los perë navi mu, gaḳ ham ayomin og hodeḳ los nġaa nipaya pup ya. ");
INSERT INTO bzh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ham kwamin ma! Anutu sën nero nġaa demi lo, maḳ su nero ayo peggo ving rë? ");
INSERT INTO bzh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gaḳ ham doḳ vu alam sën deneraḳ vu in nġaa, loḳ mëm ham rëḳ nimin röp jaḳ los dahis. ");
INSERT INTO bzh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Rëḳ mu ham Parisai*! Gëpin ham! In ham nos pin vu huk saga sën ham neḳo anon ti ti ggëp sën netu nemadluho lo, beham netunġ netu seriveng vu Anutu. Ham netunġ nos böp los mahen mahen pin nebë yeseḳ los ḳele navi, gejojeng reggu nivesa aggagga. Rëḳ mu ham nehök nġaa niröp los sën ahëmin geving Anutu lo. Yönon, horek sën nebë hil abo nġaa sën netu nemadluho natu seriveng vu Anutu lo, og hil su rëḳ ġevuu na rë. Rëḳ mu mëm hil sepa doḳ nġaa böp sënë namuġin. ");
INSERT INTO bzh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Wöp-o! Ham Parisai*! Gëpin ham! In ham ahëmin neving panġsën bë ham medo lël mala doḳ dub ayo geham ahëmin neving bë alam debengwënġ vu ham medegeḳo ham jaḳ doḳ alam tabaaḳ. ");
INSERT INTO bzh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Wöp-o! Gëpin ham! In ham nebë heljënġ sën neggëp vunsën loḳ söv ġebinë lo. Alam su deneraḳ ni rë, geyö medo deneggök ham ggëp vavunë.” ");
INSERT INTO bzh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Lob alam-horek-yi ti nër yah vu yi bë, “Ġenër nebë saga, om ġenër ġaġek nipaya yam raḳ he ving.” ");
INSERT INTO bzh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Loḳ Yesu nër yah bë, “Ham alam-horek-yi, gëpin ham ving! In ham netelë nġaa maggin raḳ ya mehönon kwaj. Rëḳ ham ti su netelo nema ya in bë doḳ vu sir teka rë. ");
INSERT INTO bzh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Wöp-o! Gëpin ham! In ham ḳenumin lo desis alam-denenër-ġaġek-ranġahsën lo wirek medediiḳ, log gwëbeng og ham medo nelev begganġ-bedub-yi nivesa vesa raḳ nedo waaḳ sën denebë seḳëj loḳ lo. ");
INSERT INTO bzh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ham nevonġ nebë sënë, log ham kwamin nevo ham ḳenumin lo hir nġaa nipaya saga beham ahëmin nivesa in. In ham ḳenumin denesis alam saga, log ham nevuneḳ vu hir bedub. ");
INSERT INTO bzh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nebë saga om sën Anutu los kwa böp nër bë, ‘Sëḳ ġevonġ alam-denenër-ġaġek-ranġahsën los sinarë la dena vu sir, lob rëḳ dengis sir la denadiiḳ, gedegetii vahi na depalët doḳ.’ ");
INSERT INTO bzh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nebë saga om Anutu rëḳ nanër alam-denenër-ġaġek-ranġahsën pin sën denesis sir wirek vu nyëdahis sën Anutu tunġ yaġek los dob beyam verup gwëbeng agi degwa gëp vu alam vu buk sënë nabë desis sir ving. ");
INSERT INTO bzh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Loḳ sën Abel diiḳ wirek lo rot, beyam verup loḳ Sakaria sën diiḳ loḳ jepö degwa los dub ayo vabuung vuheng atov lo. Sa nanër vu ham yönon nabë: Anutu rëḳ nanër nabë nipaya pin nyëvewen rëḳ natöḳ vu alam sën denedo gwëbeng agi. ");
INSERT INTO bzh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Wöp-o! Ham alam-horek-yi! Gëpin ham! In ham vun kii sën tateḳin aggata vu mehönon medejaḳ ġaġek los kwa böp ni lo. Ham su nġo nepedi veluung avi meneloḳ ya rë, log ham newërin aggata in alam vahi sën denevonġin bë dedoḳ na lo ving.” ");
INSERT INTO bzh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Lob Yesu vu begganġ sënë ayo beto meyah dobnë, lob alam-horek-yi losho Parisai* nij wëëk medenevonġ newa newa in bë denanër ġaġek jaḳ yi. Lob deneloḳ tepëḳ in ġaġek agga ti ti vu yi panġsën in bë degenġo aye. ");
INSERT INTO bzh_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Lob deseji yi in bë denatöḳ jaḳ ġaġek ti berup avi, lob degevonġ ġaġek vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Alam nġahiseḳë raḳ neggëp mehömehö desup sir yam mederaḳ vu sir, log Yesu nenër vu yi hur maluh lo bë, “Ham su gwa jaḳ Parisai*, in ham rëḳ natu alam kwamin luu nabë sir. ");
INSERT INTO bzh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","In nġaa pin sën neggëp vunsën lo, rëḳ natöḳ nam ranġah vu tamusën. Genġaa pin sën debom meneggëp loḳ ġobeng gwëbeng lo, og mehönon rëḳ dejaḳ ni vu tamusën. ");
INSERT INTO bzh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nebë sënë om ġaġek sën ham nenër loḳ mala vahis lo, og alam rëḳ degenġo jaḳ hes. Ga, ġaġek pin sën ham nepatereng loḳ begganġ ayo lo, og rëḳ debare jaḳ telig gedetahi na ranġah.” ");
INSERT INTO bzh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Sa mehö lo, sa nanër vu ham nabë: Ham su ġönengin alam sën dengis ham navimin mu meham nadiiḳ lo. In su deyoh vu bë dengis ham anomin geving rë. ");
INSERT INTO bzh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Gaḳ mëm sa tato mehö sën ham ġönengin yi lo: Ham ġönengin yi sën nesis mehönon medenediiḳ, geniwëëk neggëp beyoh vu bë rëḳ getë anoj doḳ na Nyëġ-nengwah-yi geving lo. Om sa nanër vu ham nabë mëm ham ġönengin Mehö sënë. ");
INSERT INTO bzh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Log ham neraḳ ni. Alam denebaġo soḳ mahen nemadvahi raḳ toea luu mu, rëḳ Anutu su kwa nevirekin soḳ nebë sënë ti rë. ");
INSERT INTO bzh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Gaḳ ham, og Anutu tevin ham yumin viis pin los dahis beneraḳ ni. Om ham su ġönengin ham, in Anutu kwa nevo ham kesuu soḳ mahen mahen nġahiseḳë sënë meneġin ham.” ");
INSERT INTO bzh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Log sa nanër vu ham nabë: Bë mehöti nanër yi ranġah gëp mehönon malaj nabë sa alam yi, og Mehönon Nalu rëḳ nanër yi ranġah nabë sënë gëp Anutu yi angër lo malaj. ");
INSERT INTO bzh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Log bë mehöti dah sarëġ vun in mehönon, og sëḳ dah arë vun in Anutu yi angër lo. ");
INSERT INTO bzh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mehöti bë nanër ġaġek nipaya ti jaḳ Mehönon Nalu, og aggata neggëp in bë mëm Anutu rëḳ dahun yi nipaya sënë na. Gaḳ nabë mehöti nanër ġaġek nipaya ti jaḳ Anon Vabuung, og aggata su neggëp in bë Anutu rëḳ dahun yi nipaya ti sën lo na rë. ");
INSERT INTO bzh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Log nabë alam degelë ham paya in sën ham nesepa loḳ sa lo medegeḳo ham na dub-supinsën-yi ayo, gevu gavman, gevu alam sën detu ggev lo, og ham su newamin jaḳ nabë, ‘Maḳ hil rëḳ nanër ġaġek nah nabë va? Ma hil rëḳ nanër ġaġek re?’ ");
INSERT INTO bzh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gaḳ doḳ buk saga, og Anon Vabuung yö rëḳ gevonġ ġaġek sën ham nanër nah lo vu ham.” ");
INSERT INTO bzh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Alam yu böpata sën yam denedo lo ti nër vu Yesu bë, “Tatovaha, ġenanër vu arig nabë basuh alu amamin yi nġaa pin begevonġ vahi vu sa.” ");
INSERT INTO bzh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Rëḳ Yesu nër yah vu yi bë, “Sa mehö-e! In re ggooin sa raḳ in bë sa ġanġo ham ġaġek, ma sebo ham nġaa gelek-a?” ");
INSERT INTO bzh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Log nër vu sir ving bë, “Ham gweġin ham! Beham kwamin bo in ham rëḳ malamin anon in nġaa nġaa. In mehöti sën yi nġaa nġahiseḳë lo, og su rëḳ medo mala-tumsën jaḳ yi ḳupeḳ rë.” ");
INSERT INTO bzh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Loḳ tateḳin ġaġek ngwë ggökin vu sir bë, “Mehö-los-bengö-ggoreksën ti yi nos anon loḳ rot menedo huk anon. ");
INSERT INTO bzh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Lob mehö-los-bengö-ggoreksën sënë kwa nevo loḳ ayo bë, ‘Sëḳ ġevonġ nabë va? Sehöġ begganġ su yoh vu bë sa ġetunġ nos anon pin sënë doḳ nam rë.’ ");
INSERT INTO bzh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Loḳ nër bë, ‘Maam sa ġevonġ nabë sënë: Sëḳ ḳevoh sa jök pin na, gesedev böp böp doḳ nah. Lob mëm sëḳ ngupin wit* ġahis los sa nġaa nivesa vesa pin jaḳ na jök sënë. ");
INSERT INTO bzh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Log mëm sëḳ nanër vu sa nabë, “Ma sa in-a! Sesupin nġaa nġahiseḳë beyoh vu nġebek nġahiseḳë rot. Om sëḳ sewah bemedo meġa los nanum kwaġ vesa vesa.” ’ ");
INSERT INTO bzh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Rëḳ Anutu nër vu yi bë, ‘Kwam ma rot! Rëḳ ġenadiiḳ pehi buk sënë. Log nġaa pin sën ġesupin menedo lo, og rëḳ natu re yi ngaa?’ ");
INSERT INTO bzh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Om alam sën yö kwaj neya vu hir nġaa mu gesu kwaj neya vu Anutu rë lo, rëḳ nabë saga.” ");
INSERT INTO bzh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Log Yesu nër vu yi hur maluh lo bë, “Nebë saga om sa nanër vu ham nabë: Ham su newamin jaḳ in ham medoḳ tepëḳ nabë, ‘Hil rëḳ aġa va?’ Geham su newamin jaḳ in navimin nabë, ‘Hil rëḳ ḳebu navid jaḳ va?’ ");
INSERT INTO bzh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","In hil anod kesuu nos gehil navid kesuu tob. ");
INSERT INTO bzh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Om ham kwamin bo soḳ lo rë. Su denehin nos ġahis rë, gesu denerur anon medenesupin rë. Hej jök los begganġ sën degetunġ anon doḳ lo ma. Rëḳ Anutu nevet sir. Gaḳ ham mehönon, og ham kwesuu soḳ lo yönon! ");
INSERT INTO bzh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nabë ham ti kwa bo nabë geḳo yi buk sën medo mala vesa lo seggi berup na teka geving, og maḳ yoh vu bë rëḳ gevonġ-a? ");
INSERT INTO bzh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma! Ham su yoh vu bë gwevonġ nġaa mahen teka nabë sënë rë, om ham su newamin jaḳ in nġaa vahi. ");
INSERT INTO bzh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ham kwamin bo sesik talohek sën nekweḳ pahup ayo lo rë nabë deneraḳ nebë va? Su denevonġ huk rë, besu denevasu tob rë. Rëḳ mu sa nanër vu ham nabë: Wirek Solomon* los yi vuneḳ vuneḳ niḳapiik neggërin yi, rëḳ mu ti su nivesa nebë sesik sënë rë. ");
INSERT INTO bzh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yönon, Anutu neġin vos sën nare gwëbeng gerëḳ dekesik neheng medebesi jaḳ na nengwah agi nivesa. Om nebë va sën ham su ayomin neya timu vu Anutu rë-ë? Ham jaḳ ni nabë Anutu rëḳ geġin ham nivesa geving kesuu vos saga. ");
INSERT INTO bzh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Om ham su newamim jaḳ medoḳ tepëḳ in ham nabë ham rëḳ gwa va los nanum va? Geham su medo mekwamin na nġahi. ");
INSERT INTO bzh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","In alam dahis vu dob yiḳ kwaj nevo nġaa pin sënë panġsën bë denatöḳ vu. Gaḳ ham Amamin vu yaġek raḳ ni ggovek ya bë ham neraḳ vu in nġaa nebë sënë. ");
INSERT INTO bzh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Gaḳ mëm ham malamin sepa nabë Anutu natu ala begeġin ham, lob mëm rëḳ bo nġaa pin saga vu ham geving.” ");
INSERT INTO bzh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ham sipsip yu mahen teka sënë, ham su ġöneng! Gaḳ ham Amamin vu yaġek joo ġaġek menare vorot bë ham rëḳ natu alam-los-bengömin beham medo nivesa geving yi. ");
INSERT INTO bzh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ham gwevonġ ham nġaa pin balam debaġo, lob ham bo monë sën ham gweḳo jaḳ lo vu alam sën deneraḳ vu in nġaa lo in doḳ vu sir. Ham sero jej-monë-yi sën su rëḳ siis jaḳ rë lo. Geham ngupin nġaa nivesa vesa gëp yaġek, in vu yaġek og nġaa su mala nema rë galam hodeḳ su deyoh vu bë dena dus jaḳ rë, gejeluj su neloḳ rë. ");
INSERT INTO bzh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nyëġ sën ham ngupin ham ḳupeḳ bemedo doḳ lo, og ham rëḳ gwëp natumin.” ");
INSERT INTO bzh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ham gwevëh ham tob dus, beham baḳu ahon jaḳ ḳabi, geham taggi doḳ ram, bemedo gweġin Yesu duḳ nom. ");
INSERT INTO bzh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ham gwevonġ nabë sën hur deneġin hir alam in ya nos böp sën maluh ti lu venë denejom nemaj gerëḳ nom geto lo, om deneġin yi in bë pepa jaḳ repinġ, og detahinin pevis in yi. ");
INSERT INTO bzh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nabë alaj nom geto begelë genahën medo denetum, og hur lo sënë rëḳ kwaj vesa. Sa nanër vu ham yönon nabë: Alaj yö rëḳ gevëh tob nos yi gërin yi, log mëm nanër vu sir nabë na detetup doḳ tevor. Log yö rëḳ bo nos gelek sir. ");
INSERT INTO bzh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yönon, nabë nam buk vuheng, ma doḳ sën ḳöḳrëëh nesu beron ti geneggëp yah lo, begelë nabë yö nedo denetum, og yö rëḳ kwaj vesa rot. ");
INSERT INTO bzh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Log ham kwamin bo nġaa sënë rë: Bë begganġ ala genġo hes mala sën mehö hodeḳ rëḳ godeḳ yi nġaa lo bengö namuġin, og su yoh vu bë rëḳ gelë mehö saga mu gedoḳ na yi begganġ ayo rë. ");
INSERT INTO bzh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Om ham gwero ham nabë saga, in Mehönon Nalu rëḳ nom doḳ buk ti sën ham su kwamin nevo bë rëḳ nom doḳ lo rë.” ");
INSERT INTO bzh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Lob Pita loḳ tepëḳ in bë, “Mehöböp, maḳ nġo ġenër ġaġek peggirinsën sënë vu he mu, ma ġenenër vu alam pin ving-a?” ");
INSERT INTO bzh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Loḳ Mehöböp nër yah bë, “Maḳ hur ti tena nedo, beyi mehö los kwa benevonġ yi huk niröp-a? Og mëm ala rëḳ gooin yi jaḳ in geġin yi hur vahi pin mebo nos gelek sir niröp doḳ buk sën degeḳo nos lo! ");
INSERT INTO bzh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Og ala rëḳ na genom berup begelë nabë yi hur nevonġ huk yoh vu sën nër lo, lob yi hur sënë rëḳ kwa vesa. ");
INSERT INTO bzh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Gesa nanër vu ham yönon nabë ala rëḳ gevonġ yi nġaa pin doḳ na nema in geġin. ");
INSERT INTO bzh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Gaḳ bë hur saga kwa bo nabë ala su rëḳ nom berup pevis rë, lob beek hur maluh los hur avëh, log yö medo mega los nanum mekeyevin, ");
INSERT INTO bzh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","og ala rëḳ nom doḳ buk ti sën yi hur su neġin yi loḳ lo rë, gaḳ rëḳ nom doḳ hes mala sën yi duġin lo. Lob ala rëḳ ngis yi rot mebasap yi, log getë yi na medo geving alam sën denekeyëh ġaġek lo, bedegeḳo nyëvewen gëp ti. ");
INSERT INTO bzh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Sa nanër nabë hur sën neraḳ ala kwa ni ggovek ya, rëḳ mu su nesepa loḳ rë, om ala rëḳ beek yi panġsën rot. ");
INSERT INTO bzh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Log mehöti bë duġin ala kwa lom gevonġ paya beyoh vu bë rëḳ geḳo nyëvewen doḳ nah, og ala su rëḳ beek yi panġsën rot rë. In alam sën alaj bo nġaa nġahiseḳë doḳ nemaj lo, og alaj kwaj nevo bë degevonġ huk böpata medegeġin nġaa pin saga nivesa. Log alam sën degeġin huk nġahiseḳë lo, og alaj kwaj nevo bë degevonġ pin niröp, gedegevonġ huk vahi geving.” ");
INSERT INTO bzh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Sa haḳo nengwah yam in bë natum gëp dob, om ko nengwah sënë natumeḳ-a! ");
INSERT INTO bzh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Dus raḳ in bë sa ġaḳo ḳerus, om sa hevonġin bë govek na pevis in sayoġ maggin rot. ");
INSERT INTO bzh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Maḳ ham kwamin nevo bë seyam in bë ġevonġ mamer vu dob-a? Ma! Sa nanër vu ham nabë: Seyam in bë alam degenġo sa ġaġek bedebasuh sir na yu luu. ");
INSERT INTO bzh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Rëḳ degevonġ doḳ buk sënë mena rot. Alam nemadvahi rëḳ demedo doḳ begganġ timu, lob debasuh sir na yu luu. Löö rëḳ degelë luu paya, log luu rëḳ degelë löö paya. ");
INSERT INTO bzh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Rëḳ debasuh sir bamaj rëḳ degelë naluj maluh lo paya, genaluj maluh rëḳ degelë amaj paya. Log ataj rëḳ depemëġin naluj avëh lo, genaluj avëh lo rëḳ depemëġin ataj. Gavëh böp rëḳ denapëëng ggej avëh lo geggej avëh lo rëḳ denapëëng ggej avëh böp, degwa jaḳ sa ġaġek.” ");
INSERT INTO bzh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Log nër vu alam ving bë, “Ham nelë beggob nekebu yam ggëp sën hes nemasuseḳ ya lo, lob ham nenër pevis bë, ‘Hob vonġin geto!’ Lob hob neto yönon. ");
INSERT INTO bzh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Log ham nenġo bë sanġ neyam ggëp ahë, lob ham nenër bë, ‘Hes vonġin natum böpata-o!’ Lob anon neraḳ yoh vu saga. ");
INSERT INTO bzh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ham alam ġaġek tetuhinsën ata! Ham nelë raḳ dob yi nġaa, ga, yaġek yi nġaa. Rëḳ ham su neraḳ buk sënë ni beneraḳ ni bë Anutu nevonġ huk loḳ ham vuheng atov rë.” ");
INSERT INTO bzh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nebë va sën ham su nġo neseggi nġaa sën neyoh vu lo menevonġ rë-ë? ");
INSERT INTO bzh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Buk sën ġenena geving mehö sën melu neya in gwevonġ ġaġek lo, og melu nahën nenök aggata, log ġenanër vu yi bemelu semu ġaġek, in rëḳ dadii honġ doḳ na jaas sën nenġo ġaġek lo nema. Lob jaas bo honġ doḳ na ahëvavu nemaj, lob ahëvavu degetunġ honġ doḳ na ḳarabus. ");
INSERT INTO bzh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Om sa nanër vu honġ nabë: Su rëḳ gwetah honġ vër in ḳarabus pevis rë. Gaḳ rëḳ ġemedo rot bena berup doḳ buk sën honġ nyëvewen govek na los dahis lo lom mëm.” ");
INSERT INTO bzh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yiḳ loḳ buk sënë, lob mehö la denër alam Galilea la vu Yesu bë Pilatus sis sir benij ḳöḳ keseh beto meya sarömin ving hir seriveng ḳöḳ. ");
INSERT INTO bzh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Lob Yesu nër yah vu sir bë, “Ham kwamin nevo bë alam Galilea sënë hir nġaa nipaya nġahi neggëp vu sir kesuu Galilea vahi pin om sën malaj ma raḳ-a? ");
INSERT INTO bzh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Sa nanër vu ham niröp nabë: Ma! Su nebë saga rë! Rëḳ mu nabë ham su gwërin ham rë, og ham pin rëḳ malamin nama nabë saga. ");
INSERT INTO bzh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ma alam nemadluho-menemadvahi-videk-löö (18) sën begganġ ading vu Siloam kepë mesis sir wirek bedediiḳ lo, og maḳ ham kwamin nevo bë hir nġaa nipaya kesuu alam vahi pin sën denedo Yerusalem lo hir nġaa nipaya? ");
INSERT INTO bzh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma! Sa nanër vu ham niröp nabë: Su nebë saga rë! Rëḳ mu nabë ham su gwërin ham rë, og ham rëḳ malamin nama nabë saga.” ");
INSERT INTO bzh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Loḳ nër ġaġek peggirinsën ti bë, “Mehöti varoh ḳele pik* ti menare loḳ yi huk wain ayo, lob ya in bë gelë anon mejur, rëḳ anon ma. ");
INSERT INTO bzh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Lob nër vu hur sën nevonġ huk in lo bë, ‘Ġenġo? Seyam sero pik* anon yoh vu nġebek löö, rëḳ ma, om ġebuv ḳele na, ma va sën vasap dob jeji rot-ë!’ ");
INSERT INTO bzh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Loḳ yi hur sën lo nër yah bë, ‘Mehö böp, ġenaḳööḳ ġebare ta ngwë sënë geving, besedev dob doḳ degwa, gesa ġetunġ tebeḳ doḳ degwa balu ġalë rë. ");
INSERT INTO bzh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","In maḳ mëm rëḳ ngis anon doḳ ta sënë. Rëḳ mëm nabë nama lo, og mëm nġo rëḳ ġebuv na.’” ");
INSERT INTO bzh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu vare nenër ġaġek vu alam loḳ Buk-sewahsën-yi* ti loḳ dub-supinsën-yi ayo. ");
INSERT INTO bzh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Log avëh ti nedo, rëḳ memö gwanġ ya ayo lob vonġ beni neraḳ yoh vu nġebek nemadluho-menemadvahi-mevidek-löö (18). Lob avëh sënë seḳë ma rot gedemi seḳë vegguu besu yoh vu bë kedi bare niröp rë. ");
INSERT INTO bzh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu lë yi, lob tahi yi ya benër vu bë, “Avëh-e, sa hevonġ behonġ niraḳsën maya.” ");
INSERT INTO bzh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Log bë nema raḳ avëh sënë, lob demi sesor avuti benare niröp. Log avëh lo ḳo Anutu arë raḳ. ");
INSERT INTO bzh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Rëḳ dub-supinsën-yi ala ahë sengën panġsën in Yesu vonġ bavëh sënë nivesa raḳ loḳ Buk-sewahsën-yi*. Lob nër vu alam pin bë, “Buk-huk-yi nemadvahi-bevidek-ti neggëp, om nabë ham nam in degevonġ beham nimin vesa jaḳ, og ham nam doḳ buk-huk-yi, gaḳ ham su nam in nġaa nabë sënë doḳ Buk-sewahsën-yi*.” ");
INSERT INTO bzh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Loḳ Mehöböp nër yah vu yi bë, “Ham alam kwamin luu! Neloḳ Buk-sewahsën-yi* og ham pin neya bööḳ bej beham nekwevelekin ham burmakau los dogi beneḳo sir ya denenum bël. ");
INSERT INTO bzh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Gaḳ avëh sënë lo, og yiḳ Abraham yi mewis yi, rëḳ Satan jom yi ahon yoh vu nġebek nemadluho-menemadvahi-videk-löö (18). Om sa bë ḳevelekin aggis in yi doḳ Buk-sewahsën-yi*, ma su yoh vu rë?” ");
INSERT INTO bzh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nër nebë sënë, lob sir sën denelë yi paya lo nij mum. Galam pin ahëj nivesa medepisek rot in nġaa nivesa pin sën nevonġ agi. ");
INSERT INTO bzh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Log Yesu nër ġaġek peggirinsën ngwë ggökin bë, “Maḳ sën Anutu-yi-nyëġ anon jaḳ lo, og yiḳ nebë va? Maḳ sëḳ tateḳin jaḳ va? ");
INSERT INTO bzh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sën Anutu-yi-nyëġ anon jaḳ lo, og yiḳ nebë nos sën hil nanër bë mastet* lo ġahis. Mehöti ḳo mastet* sënë ġahis behin loḳ yi huk. Lob kip merig beni nebë ḳele, lob soḳ sën denevëëng medeneya agi yam denejegwi newisej loḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Loḳ nër ġaġek peggirinsën ngwë ggökin bë, “Maḳ sa tateḳin sën Anutu-yi-nyëġ anon jaḳ lo jaḳ va ngwë geving-a? ");
INSERT INTO bzh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Sën Anutu-yi-nyëġ anon jaḳ lo, og yiḳ nebë yiist* sën nevonġ bebrët nerig lo. Avëh ti sarömin yiist* sënë los parawa ḳetuḳ böp löö loḳ ġabum, lob köd parawa pin sënë merig.” ");
INSERT INTO bzh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Log ya neḳo loḳ nyëġ los begganġ-bu la, menenër ġaġek vu alam, log ya in bë na Yerusalem, ");
INSERT INTO bzh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","lob mehöti loḳ tepëḳ vu yi bë, “Mehöböp, maḳ yiḳ Anutu rëḳ geḳo alam ti ti mu nah vu yi?” Loḳ Yesu nër yah vu bë, ");
INSERT INTO bzh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ham pasanġ dev vahamin doḳ in ham doḳ na veluung avi mahen. In sa nanër vu ham nabë: Alam nġahiseḳë rëḳ degevonġin rot nabë dedoḳ na, rëḳ mu su rëḳ denoh vu rë, ");
INSERT INTO bzh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","in begganġ ala rëḳ kedi bebehii repinġ. Log ham rëḳ berup bare dobnë bepepa jaḳ, genanër nabë, ‘Mehöböp, ġetahinin repinġ in he!’ Loḳ rëḳ nanër nök vu ham nabë, ‘Ham re lo? Sa duġin ham!’ ");
INSERT INTO bzh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Loḳ ham rëḳ nanër nah nabë, ‘He sën hil los naha nos los nanum loḳ ti, geġenare loḳ he aggata meġenenër ġaġek vu he lo.’ ");
INSERT INTO bzh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Loḳ rëḳ nanër vu ham nabë, ‘Ham re lo? Sa duġin ham! Ham sënë nevonġ nġaa nipaya, om ham jaḳ na nenga in sa!’ ");
INSERT INTO bzh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ham rëḳ gwelë Abraham ga, Isaak ga, Yakop galam-denenër-ġaġek-ranġahsën pin demedo doḳ Anutu-yi-nyëġ, rëḳ mu ham, og rëḳ dejos ham nah dobnë beham rëḳ ngu megweköö nyëmin. ");
INSERT INTO bzh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Gaḳ alam vu nyëġ sën hes mala neverup los nyëġ sën hes mala nemasuseḳ ya lo, galam vu nyëġ sën ayööng neyam lo los nyëġ sën sanġ neyam lo, og rëḳ dedoḳ na bemedo dega nos böp gëp Anutu-yi-nyëġ. ");
INSERT INTO bzh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yönon, log alam vahi vu tamusën rëḳ nah denatu alam muġinsën. Galam vahi vu muġinsën rëḳ nom denatu alam tamusën.” ");
INSERT INTO bzh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lob alam Parisai* la denër niröp loḳ buk sënë vu yi bë, “Gwevuu nyëġ sënë geġena nyëġ ngwë, in Herot* vonġin ngis honġ meġenadiiḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Loḳ Yesu nër yah vu sir bë, “Ham na nanër vu anöö bemën kwa nġahi saga nabë, ‘Ġenġo! Sëḳ ġetii memö geto dena, gesëḳ ġevonġ balam nijraḳsën nijvesa jaḳ pehi geneheng. Gaḳ duu og sëḳ semu sa huk na veröḳ yi.’ ");
INSERT INTO bzh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Rëḳ mu sëḳ medo mena pehi sënë geneheng, ga, duu. In su yoh vu bë dengis alam-denenër-ġaġek-ranġahsën ti doḳ begganġ-bu ngwë rë, gaḳ yiḳ yö dengis menadiiḳ doḳ Yerusalem timu. ");
INSERT INTO bzh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Oo Yerusalem, Yerusalem, honġ mehö ġenesis alam-denenër-ġaġek-ranġahsën medenediiḳ, geġenetengwa Anutu-yi-alam sën nevonġ sir yök vu honġ lo raḳ ġelönġ medenediiḳ. Sa nehevonġ beron beron in bë sengupin nalum lo nabë sën ḳöḳrëëh ata nesupin nalu lo loḳ yah babu lo, rëḳ nim nelël. ");
INSERT INTO bzh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Om ham gwenġo rë! Anutu vuu ham ya ggovek ya beham nyëġ rëḳ nabumeng na. Sa nanër vu ham nabë: Ham su rëḳ malamin jaḳ sa gökin nah rë, rot bena berup doḳ buk sën ham nanër nabë: ‘Anutu gevonġ semusemu vu Mehö sën vonġ yam los niwëëk lo!’” ");
INSERT INTO bzh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lob Buk-sewahsën-yi* ti, lom Yesu ya medo negga nos ving Parisai* hir ggev ti, lob alam medo malaj nesepa yi. ");
INSERT INTO bzh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","In mehö vuuḳsën ti nedo, lob nedo loḳ mala. ");
INSERT INTO bzh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu lë, lob loḳ tepëḳ vu alam-horek-yi los alam Parisai* bë, “Yoh vu bë hil ġevonġ balam nijraḳsën nijvesa jaḳ doḳ Buk-sewahsën-yi*, ma su yoh vu rë?” ");
INSERT INTO bzh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Rëḳ ayej ma rot, lom ḳo mehö saga bevonġ benivesa raḳ, log vonġ yah meya ");
INSERT INTO bzh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","genër vu sir bë, “Bë ham ti nalu ma yi burmakau ti bës duḳ asoreng-bël-yi doḳ Buk-sewahsën-yi* ti, og maḳ ham su rëḳ dadii jaḳ nom doḳ buk saga rë? Gaḳ ham rëḳ gwevonġ!” ");
INSERT INTO bzh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Rëḳ su kwaj töḳ raḳ ġaġek ti medenër loḳ yah rë. ");
INSERT INTO bzh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu lë vatëveḳ sën deyam in bë dega nos lo ya denedo raḳ sëa sën los arë lo. Lob nër ġaġek raḳ sir betateḳin bë, ");
INSERT INTO bzh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nabë mehöti gevonġ dik nam vu honġ nabë ġena nos böp sën maluh ti lu venë denejom nemaj lo, og su gweto ġemedo jaḳ sëa sën los arë lo. In tum mehö sënë, maḳ rëḳ gevonġ dik in mehö ngwë sën los arë kesuu honġ lo nam geving. ");
INSERT INTO bzh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Bë ġevonġ nabë sënë, og mehö sën vonġ dik in meluu lo rëḳ nam nanër vu honġ nabë, ‘Ġebo sëa-los-arë saga vu mehö sënë.’ Lob rëḳ nim namum böpata rot beġenah ġemedo lël hus. ");
INSERT INTO bzh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Om nabë mehöti gevonġ dik in honġ nabë ġena nos böp geving yi, og ġena ġeberup ġemedo lël hus. Gwevonġ nabë sënë in lob mehö sën vonġ dik in honġ lo nam gelë honġ lob nanër nabë, ‘Sa mehö, ġenam lël mala.’ Nabë nanër nabë sënë, og mëm alam pin sën ham los newa nos lo rëḳ degelë nabë ḳo honġ raḳ. ");
INSERT INTO bzh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","In mehöti bë yö geḳo arë jaḳ, og Anutu rëḳ dahun yi. Gaḳ mehöti sën nabë dahun yi lo, og Anutu rëḳ geḳo arë jaḳ na vavunë.” ");
INSERT INTO bzh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Log nër vu mehö sën vonġ dik ya in yi lo bë, “Nabë gwevonġ nos böp ti, og su gwevonġ dik na in nim papu lo, arim lo, galam sën ham degwa ti lo. In maḳ rëḳ degevonġ dik nom in honġ beġena ġegwa nos doḳ nah honġ nos saga gëp hir begganġ buk ngwë. ");
INSERT INTO bzh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Gaḳ nabë gwevonġ nos böp, og mëm gwevonġ dik na in alam bengöj masën, galam vahaj paya los vahaj ḳasöm, galam malaj ḳenod. ");
INSERT INTO bzh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","In alam nebë sënë su deyoh vu bë debo doḳ nah honġ nos nyëvewen vu honġ rë. Gwevonġ nabë sënë, lob kwam vesa. In Anutu rëḳ bo doḳ nah honġ nos vu honġ vu Buk-tamusën doḳ buk sën alam yohvu dekedi jaḳ nah gëp bedub lo.” ");
INSERT INTO bzh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Alam sën losho Yesu medo denegga nos agi ti nġo ġaġek sënë, lob nër vu Yesu bë, “Mehöti sën rëḳ medo mega nos doḳ Anutu-yi-nyëġ lo og kwa vesa.” ");
INSERT INTO bzh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Rëḳ Yesu nër yah vu yi bë, “Mehöti vonġin bë gevonġ nos böpata, lob vonġ dik ya vorot vu alam nġahi in bë nam dega nos böp sënë. ");
INSERT INTO bzh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Lob mëm ya verup loḳ buk sën dega nos böp doḳ lo, lob vonġ yi hur ya denër vu alam sën vonġ dik ya in sir wirek lo bë, ‘Ham nam jaḳ in sa hero nġaa pin ggovek ya menedo.’ ");
INSERT INTO bzh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Rëḳ alam saga sir pin ti ti yö kwaj nevo hir ġaġek medenenër yah vu bë su deyoh vu bë dena rë. Sir ti nër bë, ‘Sa baġo huk bengö ti, om sa naya in ġalë kesii. Om wöp-o, sa su yoh vu bë nök rë.’ ");
INSERT INTO bzh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Log ngwë nër vu bë, ‘Sa baġo burmakau-huk-yi nemadluho, om sa naya in tahu sir doḳ huk, om wöp-o, sa su yoh vu bë nök rë.’ ");
INSERT INTO bzh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Log ti nër bë, ‘Yiḳ sa nahën nehaḳo avëh gwëbengko, om sa su yoh vu bë nök rë.’ ");
INSERT INTO bzh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Lob hur sën lo yah meya demi meris menër vu ala. Lob begganġ ala ahë sengën rot, lob nër vu yi hur bë, ‘Ġena pevis meġenoh vu aggata böp pin los mahen pin vu nyëġ sënë, begweḳo alam bengöj masën, galam vahaj paya, galam malaj ḳenod, galam vahaj ḳasöm lo megweḳo sir doḳ nam sa begganġ.’ ");
INSERT INTO bzh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Lob yi hur yah geyom verup, lom nër bë, ‘Sa hevonġ yoh vu ayem, rëḳ mu len la nahën neggëp meris.’ ");
INSERT INTO bzh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Lob ala nër yah vu bë, ‘Om ġena ġenoh vu aggata böp pin, geġena ġesepa doḳ heek degwa geving, beġedadii alam denam. In sa hevonġin bë sa begganġ yö napup. ");
INSERT INTO bzh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Gaḳ sa nanër vu honġ nabë: Alam pin sën sa hevonġ dik ya in sir wirek lo, og su rëḳ dega sa nos rë.’” ");
INSERT INTO bzh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Alam yu böpata denetamuin Yesu medeneya, lob Yesu ggërin yom menër vu sir bë, ");
INSERT INTO bzh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nabë mehöti nam vu sa rëḳ ahë neving ama lu ata gevenë losho nalu lo gari lo avëhnö lo kesuu sa, genabë yö kwa nevo yi kesuu sa, og mehö sënë su yoh vu bë natu sa hur rë. ");
INSERT INTO bzh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Gemehöti sën su kerë yi ḳelepeḳo* metamuin sa rë lo, og su yoh vu bë rëḳ natu sa hur rë. ");
INSERT INTO bzh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Gaḳ bë ham ti kwa nevo bë dev begganġ ading ti jaḳ na vavunë, og nedo bekwa neḳo nġaa-begganġ-yi yi monë muġin loḳ mëm. ");
INSERT INTO bzh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nabë su gevonġ nabë sënë rë geyö barah mudeng mu doḳ na meris, log su yoh vu bë gevonġ besemu na rë, og alam pin rëḳ degelë bedenanër pelë jaḳ mehö sënë, gedenanöp jaḳ nabë, ");
INSERT INTO bzh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Mehö sënë nelev begganġ, rëḳ mu su yoh vu bë rëḳ dev mesemu na rë.’ ");
INSERT INTO bzh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Log bë mehö-los-bengö ti na beġö vu mehö-los-bengö ngwë, og medo mekwa neḳo aggata pin muġin loḳ mëm neya. In maḳ yiḳ hen alam-beġö-yi 10,000 mu, log mehö-los-bengö ngwë yi alam-beġö-yi 20,000 kesuu hen. Om rëḳ kwa bo namuġin megero rë nabë: Maḳ rëḳ ngis beġö vu mehö-los-bengö ngwë sënë begetii na, ma maḳ su yoh vu rë? ");
INSERT INTO bzh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Rëḳ nabë raḳ ni bë su yoh vu rë, og alam nyëġ ngwë sën lo yö nahën denedo ading, log nevonġ mehö la ya denenër ġaġek ya bë desemu ġaġek menadiiḳ gebeġö gëp. ");
INSERT INTO bzh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nebë saga, om ham kwamin bo rë. Bë ham ti gelë yi nġaa mu nabë nġaanon, og su yoh vu bë natu sa hur rë.” ");
INSERT INTO bzh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mamireng og nġaa nivesa. Rëḳ mu nabë mamireng sënë nengën nama na, og rëḳ hil ġevonġ benengën jaḳ nah nabë va? ");
INSERT INTO bzh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mamireng nebë sënë og su yoh vu bë hil rëḳ sarömin los dob rë, in rëḳ gevonġ paya vu nos vë, log hil su ayoh vu bë ḳeseh doḳ na geving reggu ahëj sën hil neḳetëḳin loḳ huk lo rë, in su rëḳ bo tebeḳ doḳ nos rë. Gaḳ hen huk maya veröḳ yi behil nehetë ya meris. Mehöti bë nenga neggëp, og genġo ġaġek sënë.” ");
INSERT INTO bzh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Log alam sën deneḳo takës* losho alam nij paya deneya vu Yesu medenenġo yi ġaġek. ");
INSERT INTO bzh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lob Parisai* losho alam-horek-yi denër yi bë, “Mehö sënë ahë neving alam nijpaya, genegga nos ving sir.” ");
INSERT INTO bzh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Denër nebë sënë, lob Yesu nër ġaġek peggirinsën vu sir bë, ");
INSERT INTO bzh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Bë ham ti yi sipsip 100 denare, lob nabë ti mala nama, og rëḳ gevuu 99 bare dega kesëḳ gëp nyëġ len ti, log na sero ti sën mala ma lo. Yö rëḳ sero niwëëk rot benatöḳ jaḳ loḳ mëm. ");
INSERT INTO bzh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bë natöḳ jaḳ, og rëḳ kerë jaḳ gëp baġë los kwa vesa menah. ");
INSERT INTO bzh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Rëḳ nah berup begganġ, lob tahi yi alam lo, galam sën yiḳ sir begganġ-bu ti lo, bedenam vu yi, lob nanër vu sir nabë, ‘Hil kwad vesa! In sa sipsip ti mala ma, rëḳ setöḳ vu behaḳo yom ggökin.’ ");
INSERT INTO bzh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Om yiḳ nebë saga, sa nanër vu ham nabë: Angër lo vu yaġek kwaj vesa in alam yohvu 99 nebë saga, in su huk neggëp vu sir bë rëḳ degërin sir rë. Gaḳ nabë alam nij paya ti gërin yi, og rëḳ kwaj vesa böpata rot vu yaġek kesuu.” ");
INSERT INTO bzh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Log nabë avëh ti neḳo yi monë ġahis nemadluho, loḳ ti mala ma, og rëḳ taggi doḳ ram gesekee begganġ ayo menesero rot, bemëm natöḳ jaḳ loḳ mëm. ");
INSERT INTO bzh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bë natöḳ vu, og rëḳ tahi yi alam lo, galam sën sir begganġ-bu ti lo na vu yi, log nanër vu sir nabë, ‘Hil kwad vesa! In sa hevuu sa monë ġahis ti, rëḳ sa sero metöḳ vu ggökin.’ ");
INSERT INTO bzh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Om yiḳ nebë saga, sa nanër vu ham nabë: Bë mehöti sën nġaa nipaya neggëp vu yi lo gërin yi nom, og Anutu yi angër lo kwaj vesa rot.” ");
INSERT INTO bzh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Log Yesu nër ving bë, “Mehöti nalu maluh luu denedo, ");
INSERT INTO bzh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","lob amon nër vu luho amaj bë, ‘Amaġ-e, kwam bo beġebasuh honġ monë lu nġaa pin borot, beġebo gelek alu arig.’ Lob ama tunġ nġaa pin ggelek luho. ");
INSERT INTO bzh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Lob amon su nedo hus ading rë, gaḳ pevis besupin hen beya nyëġ ading ti. Beya nedo, lob të yi monë pin ya raḳ nġaa nipaya paya sën nevonġ lo. ");
INSERT INTO bzh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Vasap yi nġaa pin bemaya, log meyip böpata verup vu dob sagu. Lob neraḳ vu in nos lu nġaa. ");
INSERT INTO bzh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Lob maam ya nevonġ huk vu mehöti ggëp nyëġ sagu. Lob mehö sënë vonġ yi ya, beya neġin yi bööḳ lo ggëp yi dob. ");
INSERT INTO bzh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Lob kwa neya vu bööḳ hir nos rot bë ga, in mehöti su neloḳ vu yi rë. ");
INSERT INTO bzh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nebë sënë loḳ kwa yah töḳ raḳ ama, lob nër bë, ‘Amaġ yi hur lo hir nos nġahiseḳë, besu deyoh vu bë dega mepalët na rë. Rëḳ tum senġo yam nado sënë menadiiḳahëġ panġsën. ");
INSERT INTO bzh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Om maam sa ḳedi jaḳ menah mena vu amaġ. Log sëḳ nanër vu yi nabë, “Amaġ. Sa hevonġ paya vu Anutu, gevu honġ. ");
INSERT INTO bzh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Om gwëbeng sa su mehö niġ vesa yoh vu bë ġenanër sa nabë nalum rë. Gaḳ gwetunġ sa natu honġ hur ti.” ’ ");
INSERT INTO bzh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Log kedi raḳ meyah meya vu ama. ");
INSERT INTO bzh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nahën verup neyam ggëp ading teka, loḳ ama lë yi, lob kwa paya in yi. Lob seröġ beya kebi yi, gemul* yi. Loḳ nalu nër vu yi bë, ‘Amaġ, sa hevonġ paya vu Anutu, gevu honġ. Om sa su mehö niġ vesa yoh vu bë ġenanër sa nabë nalum sa rë.’ ");
INSERT INTO bzh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Rëḳ ama nër vu yi hur lo bë, ‘Ham gweḳo tob ading malanġeri ti nam pevis bejöp doḳ yi. Geham naḳah seġes ti doḳ seḳë. Geham jöp suu doḳ vaha. ");
INSERT INTO bzh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Geham gweḳo burmakau nalu tuveḳ sën jeji lo ti nam mengis, in hil aġa nos böp gekwad vesa in yi. ");
INSERT INTO bzh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","In vonġ bë sa naluġ sënë diiḳ ya, rëḳ gwëbeng vesa loḳ yah ggökin. Mala ma, loḳ hil atöḳ vu yi ggökin.’ Lob kwaj vesa medenepisek in yi lo. ");
INSERT INTO bzh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Log ari aġuu ya nedo huk anon, beverup dus raḳ begganġ, loḳ nġo geggaġeng dedun gedenelöö rot. ");
INSERT INTO bzh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Lob tahi hur ti ya, beloḳ tepëḳ vu yi bë, ‘Denevonġ va sagu?’ ");
INSERT INTO bzh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Loḳ nër yah vu yi bë, ‘Arim amon yom verup, om sën amam sis burmakau nalu tuveḳ sën jeji lo ti medenegga gekwaj vesa. In nalu su ya mala ma rë, gaḳ ya nedo vesa beyom verup.’ ");
INSERT INTO bzh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Rëḳ nalu aġuu ahë sengën rot, lob su loḳ ya begganġ ayo rë. Lob ama luḳ ya dobnë, beya semu aye in yi. ");
INSERT INTO bzh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Rëḳ nër yah vu ama bë, ‘Sa nehevonġ honġ huk menado yoh vu nġebek nġahiseḳë nebë honġ nġaa meris ti, gesa su neḳeyëh ayem beron ti rë. Rëḳ su ġenevo memëk nalu ti vu sa, behe los sa alam naha gekwamin vesa rë. Geyö nema rot. ");
INSERT INTO bzh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Rëḳ nalum teka saga ya vasap honġ nġaa pin raḳ avëh baggëb lo, geyom verup, lob kwam vo yi beġesis burmakau nalu tuveḳ sën jeji lo in yi.’ ");
INSERT INTO bzh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Loḳ ama nër yah vu bë, ‘Naluġ, honġeḳ alu nado loḳ ti yoh vu buk, besa nġaa pin tu honġ nġaa. ");
INSERT INTO bzh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Gaḳ mëm hil kwad vesa benapisek in arim sënë. In vonġ bë diiḳ ya, rëḳ ma genedo vesa beyom verup ggökin. Mala maya veröḳ yi, loḳ hil halë yi ggökin.’” ");
INSERT INTO bzh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Log Yesu nër vu yi hur maluh lo ving bë, “Mehö-los-bengö-ggoreksën ti nedo, beyi hur ti nedo meneġin yi nġaa nġaa paya. Lob mehö la deya vu mehö monë degwa sënë medenër yi hur ranġah vu yi bë nevasap yi nġaa nġahiseḳë. ");
INSERT INTO bzh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Lob tahi yi hur yam benër vu yi bë, ‘Ġenevonġ nebë tena sën mehö la denër bengöm vu sa-ë? Ġenah ġetateḳin sa nġaa pin sën ġeneġin lo nabë ġenevonġ nebë tena, in sejaḳ ni. In su rëḳ gweġin sa nġaa gökin nah rë.’ ");
INSERT INTO bzh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Lob mehö sën neġin yi nġaa lo kwa nevo loḳ ayo bë, ‘Sëḳ ġevonġ nabë va? Ma gemehö böp rëḳ juuk sa na pehi lo, gesa su rëḳ ġeġin yi nġaa gökin nah rë. Sa seḳëġ ma, om sa su yoh vu bë ḳedub dob rë-o! Log sa niġ nemum bë sa su ḳetaġ nos vu mehö ngwë. ");
INSERT INTO bzh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Rëḳ mu sa kwaġ töḳ raḳ aggata ti, om nabë sa ġevonġ nabë sënë, og alam rëḳ degeḳo sa na hir begganġ doḳ buk sën sa alaġ juuk sa gesesu ġeġin yi nġaa gökin rë lo.’ ");
INSERT INTO bzh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nebë sënë lob tahi alam pin sën hir nyëvewen neggëp berëḳ debo doḳ nah vu ala lo ti ti ya vu yi. Lob ti ya verup muġin, lob loḳ tepëḳ vu bë, ‘Honġ nyëvewen va la neggëp vu sa alaġ-a?’ ");
INSERT INTO bzh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Loḳ nër yah bë, ‘Wël* dram 100.’ Lob nër vu bë, ‘Gweḳo ḳapiya teka sën honġ nyëvewen arë neggëp loḳ lo, begweto ġemedo pevis, bekwevu yiḳ dram 50 mu doḳ gëp.’ ");
INSERT INTO bzh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ggovek log mehö ngwë verup, lob mehö sën neġin nġaa lo loḳ tepëḳ vu bë, ‘Honġ nyëvewen va la neggëp-a?’ Loḳ bë, ‘Wit* bëëk 100.’ Lob nër vu bë, ‘Om gweḳo honġ ḳapiya sën honġ nyëvewen neggëp loḳ lo, beyiḳ kwevu bëëk 80 mu doḳ gëp.’ ");
INSERT INTO bzh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Lob ala nġo bë nevonġ nebë saga, lob ḳenu ya benër yi hur sën tetuhin yi lo bë yi mehö los kwa. Yönon, mehönon vu dob sënë yiḳ kwaj böp bedenetetuhin hir alam nebë sënë. Gaḳ alam-ranġah-yi, og su denevonġ nġaa los kwa nebë sënë rë. ");
INSERT INTO bzh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Om sa nanër vu ham nabë: Ham su ngupin monë in gwevonġ nġaa nipaya paya jaḳ, gaḳ ham gwevonġ balam denatu ham alam jaḳ. Gevu tamusën sën monë nama na lo, og rëḳ degeḳo ham jaḳ na begganġ nivesa sën rëḳ medo degwata los degwata lo. ");
INSERT INTO bzh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nabë mehöti nemalain nġaa mahen teka teka nivesa, og rëḳ malain nġaa böp nivesa geving. Log mehöti sën su gevonġ nġaa mahen mahen niröp rë lo, og su rëḳ gevonġ nġaa böp niröp geving rë. ");
INSERT INTO bzh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Om nabë ham su gweġin dob sënë yi monë niröp rë, og re rëḳ bo nġaanon vu ham beham gweġin-a? ");
INSERT INTO bzh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Log nabë ham su gweġin mehö ngwë hir nġaa nivesa rë, og re rëḳ bo ham nġo ham nġaa sën lo vu ham-a? ");
INSERT INTO bzh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Hur ti su yoh vu bë gevonġ huk vu ala luu doḳ ti rë. In rëḳ nidelin ngwë, gahë geving ngwë. Ma rëḳ napiiḳ vu ngwë, genitebö in ngwë. Ham su yoh vu bë gwevonġ huk vu Anutu los monë doḳ ti rë.” ");
INSERT INTO bzh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Rëḳ alam Parisai* ahëj neving monë panġsën, om denġo ġaġek pin sën Yesu nër agi, lob denöp raḳ yi. ");
INSERT INTO bzh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Rëḳ nër yah vu sir bë, “Ham nġo neḳo ham raḳ ggëp alam malaj bë ham alam yohvu. Rëḳ mu Anutu raḳ ham ayomin ni. In nġaa sën mehönon denelë bë nivesa medeneḳo raḳ lo, og Anutu nelë bë nġaa nipaya. ");
INSERT INTO bzh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Horek yi ġaġek los alam-denenër-ġaġek-ranġahsën hir ġaġek neggëp in bë hil sepa doḳ, rot meverup loḳ Jon yi buk. Rëḳ loḳ Jon yi buk, beyam verup gwëbeng, og Bengö Nivesa raḳ Anutu-yi-nyëġ töḳ yam ranġah. Lob alam pin nij wëëk rot in bë dedoḳ na nyëġ sënë. ");
INSERT INTO bzh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yaġek los dob yoh vu bë govek na bemala nama, rëḳ mu ġaġek sën neggëp loḳ horek lo, og su yoh vu bë teka rëḳ geto mena rë.” ");
INSERT INTO bzh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Bë mehöti nidëlin venë gegeḳo avëh ngwë natu venë, og nevonġ baggëb. Log mehöti sën nabë geḳo avëh sën regga nilëlin yi lo, og nevonġ baggëb benġaa nipaya neggëp vu yi.” ");
INSERT INTO bzh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Mehöti nedo wirek, lob yö neröp röpröp malanġeri nġeri los tob saġap nivesa vesa. Genegga nos nivesa vesa yoh vu buk. ");
INSERT INTO bzh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Log mehö-ḳupeḳ-masën ti neggëp loḳ yi veluung avi, arë nebë Lasarus. Bepegges vunin yi. ");
INSERT INTO bzh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Rëḳ kwa nevo timu bë na in patu nos metes sën mehö-los-bengö-ggoreksën nevonġ meneto loḳ tevor ġebinë lo mega, rëḳ ma. Ganöö verup denetep raḳ yi pegges. ");
INSERT INTO bzh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Loḳ mehö-ḳupeḳ-masën lo diiḳ muġin medelev, lob angër deḳo yi ya nedo ving Abraham. Log mehö-los-bengö-ggoreksën diiḳ tamu bedelev yi ving. ");
INSERT INTO bzh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Lob ya nedo Nyëġ-nipaya beneḳo vanë böpata. Loḳ vër mala raḳ, lob lë ga, Abraham nedo ading rot, log Lasarus nedo ving yi. ");
INSERT INTO bzh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Lob mehö-los-bengö-ggoreksën lo tahi ya vu bë, ‘Amaġ Abraham-e! Kwam gevonġin sa begwevonġ Lasarus nam daġoo nema deggis nyë teka doḳ bël, begevonġ jaḳ sa daggeġ bahë yes jaḳ teka rë. In nengwah sënë gga sa besa hanġo nivanë böpata rot.’ ");
INSERT INTO bzh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Loḳ Abraham nër yah vu bë, ‘Naluġ-e! Nġo kwam bo rë! In wirek sën ġenedo malam vesa lo, og ġenedo raḳ honġ nġaa pin nivesa vesa. Log Lasarus nedo paya in nġaa pin. Rëḳ vu nyëġ sën gwëbeng agi, og nedo nivesa, log ġenetöḳ vu vanë rot. ");
INSERT INTO bzh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Log nġaa ngwë sënë ving. Anutu vonġ lii böpata ti neggëp loḳ vuheng meneruu hil. Om alam sën denedo agi degevonġin nabë deduḳ lii sënë gedenök vu ham, og su deyoh vu rë. Galam sën denedo ggëp aga su deyoh vu bë deduḳ lii sënë gedejaḳ nam vu he rë.’ ");
INSERT INTO bzh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Lob mehö-los-bengö-ggoreksën lo nër bë, ‘Nebë saga om amaġ, sa ḳetaġ vu honġ bë gwevonġ Lasarus nah bena amaġ yi begganġ. ");
INSERT INTO bzh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","In sarig lo nemadvahi denedo loḳ. Om Lasarus pasanġ nanër ġaġek niwëëk vu sir. In rëḳ dedoḳ nam nyëġ sënë bedegeḳo vanë.’ ");
INSERT INTO bzh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Loḳ Abraham nër yah vu bë, ‘Moses losho alam-denenër-ġaġek-ranġahsën hir ġaġek neggëp vu sir. Om yiḳ degenġo saga.’ ");
INSERT INTO bzh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Lob mehö sën los ḳupeḳ wirek lo nër bë, ‘Ma rot! Amaġ Abraham, sagaḳ su yoh vu rë. Gaḳ mëm nabë alam-diiḳsën ti kedi jaḳ gëp bedub benah nanër vu sir, og mëm rëḳ degërin sir.’ ");
INSERT INTO bzh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Loḳ Abraham nër yah vu yi bë, ‘Bë su degenġo Moses losho alam-denenër-ġaġek-ranġahsën hir ġaġek rë, log nabë mehöti kedi jaḳ nah gëp bedub benah nanër, og su rëḳ degevonġ geving yi ġaġek geving rë.’” ");
INSERT INTO bzh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Log Yesu nër vu yi hur maluh bë, “Nġaa aggagga rëḳ berup beseggi mehönon, lob rëḳ kepë sir. Rëḳ mu gëpin mehöti sën jan doḳ vahaj lo! ");
INSERT INTO bzh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","In maḳ rëḳ kepë alam sën nahën nij yes yes lo ti jaḳ nġaa nipaya. Gaḳ nabë deseyu ġelönġ böpata ti doḳ mehö nipaya saga kwa namuġin medegetë yi duḳ na loo bemala nama, og sagaḳ nivesa in lob su rëḳ kepë mehönon la rë, gaḳ nama og rëḳ geḳo nyëvewen böpata rot vu tamusën. Om ham nġo gweġin ham nivesa. ");
INSERT INTO bzh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nabë arim gevonġ nġaa nipaya, og ġebo ġaġek jaḳ yi. Lob nabë gërin yi, og kwam birek na in yi nġaa nipaya saga. ");
INSERT INTO bzh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Log nabë gevonġ paya vu honġ beron nemadvahi-bevidek-luu doḳ buk timu, loḳ gërin yi nom vu honġ beron nemadvahi-bevidek-luu genanër vu honġ nabë, ‘Wöp-o, sa hevonġ sënëḳ nipaya rot.’ Og kwam birek na in yi nipaya saga.” ");
INSERT INTO bzh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sinarë lo denër vu Mehöböp bë, “Gwevonġ behe ayomin na niwëëk.” ");
INSERT INTO bzh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Loḳ Mehöböp nër yah vu sir bë, “Nabë yiḳ ham ayomin nam timu mahen teka mu nabë mastet* ġahis, og ham yoh vu bë rëḳ nanër vu ḳele malberi sënë nabë, ‘Ġesepul honġ los degwam meġena ġejeyanġ honġ duḳ na loo vuheng’, og rëḳ gevonġ noh vu ham ayemin.” ");
INSERT INTO bzh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Log Yesu nër ving bë, “Nabë ham ti yi hur kedub dob gëp huk anon, ma geġin sipsip govek geberup begganġ, og maḳ ala rëḳ nanër vu yi nabë, ‘Ġepevis beġejaḳ nam sëa in ġegwa nos’—a? ");
INSERT INTO bzh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma! Mu rëḳ nanër vu yi nabë, ‘Gwero sa nos. Ġejöp röpröp in ġejuu sa nos begweḳo nam beseġa genanum namuġin, loḳ mëm rëḳ ġegwa höm los ġenanum tamu.’ ");
INSERT INTO bzh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Log maḳ rëḳ kwa vesa megeḳo hur sënë jaḳ in nevonġ nġaa yoh vu aye? Ma! ");
INSERT INTO bzh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Om yiḳ ham gwevonġ nabë saga geving. Nabë ham gwevonġ nġaa pin begovek na noh vu sën Anutu nër vu ham bë ham gwevonġ lo, og ham nanër nabë, ‘Heḳ hur nimin paya. Om huk sën he nehevonġ lo, og yiḳ he nġo he huk om he nehevonġ.’” ");
INSERT INTO bzh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu yoh aggata meneya in bë na Yerusalem, lob ya meto aggata vuheng atov sën neruu dob distrik Samaria los Galilea lo. ");
INSERT INTO bzh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Medo meya beya verup begganġ-bu mahen ti, lob alam nij sevuuḳ nemadluho detöḳ verup vu yi bedenare adingnë ");
INSERT INTO bzh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","gedetahi ya vu yi bë, “Tatovaha, kwam paya in he!” ");
INSERT INTO bzh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu nelë sir, lom nër yah vu sir bë, “Ham na tato navimin vu alam-deneḳo-seriveng.” Lob nahën medo deneyök, log navij tup nivesa raḳ pevis. ");
INSERT INTO bzh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Lob sir ti nelë bë navi nivesa raḳ, lob ggërin yi benepisek in menetahi ya vavunë, geneḳo Anutu arë raḳ geneyah vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mehö saga yah verup, lob to petev loḳ Yesu vaha genër vu bë kwa vesa rot. Rëḳ mu mehö sënë og Samaria* ti. ");
INSERT INTO bzh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu lë bë mehö timu sënë yom to vu yi, lom lëk menër bë, “Sa kwaġ nevo bë ham nemadluho sën lo nimin vesa raḳ pin, loḳ sir nemadvahi-bevidek-lubeluu ya deyoh tena? ");
INSERT INTO bzh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Su deyom in bë degeḳo Mehöböp arë jaḳ rë? Gaḳ yiḳ mehö-yu-ngwë sënë yö timu yom-a?” ");
INSERT INTO bzh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Lom Yesu nër vu yi bë, “Kwedi ġena! Ayom yam timu vu sa om sën nim vesa raḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Lob Parisai* deloḳ tepëḳ in Yesu bë, “Anutu rëḳ nam natu ala megeġin hil nangërek-a? Loḳ Yesu nër yah vu sir bë, “Buk sën nabë Anutu nam geġin hil lo, og ham su rëḳ gwelë nġaa ti jaḳ malamin rë. ");
INSERT INTO bzh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Log su rëḳ denanër vu ham nabë ‘Nedo sagi!’ ma, ‘Nedo sagu!’ rë. Ham nġo? Anutu yam nedo loḳ ham vuheng atov ggovek ya.” ");
INSERT INTO bzh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Log Yesu nër vu yi hur maluh lo bë, “Buk ti vonġin berup, lob ham rëḳ gwevonġ in rot nabë ham gwelë Mehönon Nalu gökin, rëḳ mu ham su rëḳ gwelë yi rë gerëḳ nama. ");
INSERT INTO bzh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Rëḳ denanër vu ham nabë, ‘Nedo sagu om ham na!’ ma, rëḳ denanër vu ham nabë, ‘Nedo sagi om ham nam!’ og ham su tamuin sir, gaḳ ham najom ham ahon! ");
INSERT INTO bzh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","In buk sën Mehönon Nalu duḳ nom lo, og ham rëḳ gwelë nabë sën ham nelë davës nevër lom nejëh raḳ nyëġ pin lo. ");
INSERT INTO bzh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Rëḳ mu geḳo nivanë nġahiseḳë rë, galam sën denedo gwëbeng agi degeruu demij vu yi govek rë. ");
INSERT INTO bzh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Log doḳ buk sën Mehönon Nalu duḳ nom dob lo, og mehönon rëḳ medo denegevonġ nġaa pin nabë sën denevonġ loḳ Noa yi buk wirek lo. ");
INSERT INTO bzh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mehönon medo denegga nos los denenum, gemaluh deneḳo venëj, gavëh deneraḳ reggaj, beya verup loḳ buk sën Noa loḳ ya yaġ ayo lo, loḳ tum bël böpata vuuḳ verup pevis merehöö sir pin. ");
INSERT INTO bzh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Log yiḳ rëḳ nabë sën Lot yi buk lo geving. Denegga nos gedenenum gedenebaġo ḳupeḳ lu nġaa. Denevaroh nos los denelev begganġ. ");
INSERT INTO bzh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Rëḳ mu loḳ buk sën Lot kedi ggëp Sodom meya raḳ lo, og Anutu vonġ nengwah böpata los ġelönġ nisanġsanġ sën netum lo luḳ yam vu vavunë nebë hob megga sir pin bemalaj maya. Ġelönġ saga arë nebë salpa*. ");
INSERT INTO bzh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Lob yiḳ rëḳ mehönon medo denegevonġ hir nġaa aggagga nabë saga doḳ buk sën Mehönon Nalu duḳ nom dob betato yi ranġah lo. ");
INSERT INTO bzh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lob nabë mehöti jaḳ na sewah jaḳ yi begganġ yu tamanġsën vavunë megeḳo ayööng doḳ buk saga, geyi nġaa pin doḳ medo begganġ ayo, og su doḳ nah geḳo yi ḳupeḳ doḳ begganġ ayo, gaḳ beya mena pevis. Log nabë mehöti na medo huk anon, og yiḳ nabë saga, su seröġ menah begganġ, gaḳ beya mena pevis. ");
INSERT INTO bzh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ham kwamin bo Lot venë rë. ");
INSERT INTO bzh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nabë mehöti kwa bo navi panġsën og su rëḳ medo mala-tumsën rë. Gaḳ nabë mehöti kwa birek in yi, og anon rëḳ medo mala-tumsën. ");
INSERT INTO bzh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sa nanër vu ham nabë: Mehö luu rëḳ degëp buk jaḳ ḳanyë timu doḳ buk sënë, lob Anutu rëḳ geḳo ngwë, log gevuu ngwë begëp. ");
INSERT INTO bzh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Log avëh luu rëḳ medo denegerii wit* ġahis natu parawa, lob Anutu rëḳ geḳo ngwë, log gevuu ngwë bemedo. ");
INSERT INTO bzh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Log mehö luu rëḳ demedo doḳ huk anon, lob Anutu rëḳ geḳo ngwë, log gevuu ngwë bemedo.” ");
INSERT INTO bzh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yi hur maluh deloḳ tepëḳ vu yi bë, “Mehöböp, nġaa sënë rëḳ anon jaḳ gëp tena?” Loḳ Yesu nër yah vu sir bë, “Vu nyëġ sën heljënġ neggëp lo, og ḳadanii denesup sir ya timu in bë dega.” ");
INSERT INTO bzh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Lob Yesu nër ġaġek peggirinsën ti vu sir in bë tahu sir beyö denajom jaḳ noh vu buk gesu nij tebö. ");
INSERT INTO bzh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nër bë, “Jaas sën nenġo ġaġek lo ti nedo nyëġ böp ti. Lob jaas ti sënë su neggönengin Anutu rë, log su kwa nevo mehönon ving rë. ");
INSERT INTO bzh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Lob avëh alov ti nedo nyëġ böp sënë ving. Lob neya vu jaas sënë yoh vu buk menenër vu bë, ‘Mehöti vonġ paya vu sa, om gwenġo sa ġaġek megwero.’ ");
INSERT INTO bzh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Loḳ jaas sënë kwa vo muġin bë su rëḳ doḳ vu yi rë, lob nedo hus ading teka. Loḳ tum yom kwa vo loḳ ayo bë, ‘Sa su nahönengin Anutu rë, gesa su kwaġ nevo mehönon rë. ");
INSERT INTO bzh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Rëḳ avëh alov sënë yam neketaġ vu sa mekeduung raḳ, om maam yiḳ ggovek gesedoḳ vu yi in ġaġek. In maḳ rëḳ medo menam vu sa nabë sënë rot besa niġ tebö jaḳ na veröḳ yi.’” ");
INSERT INTO bzh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Log Mehöböp Yesu loḳ tepëḳ bë, “Ham nġo jaas nipaya sënë yi ġaġek, ");
INSERT INTO bzh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","om ham kwamin nevo bë? Alam sën Anutu ggooin sir raḳ tu yi nġaa bedenesu vu yi buk los ranġah pin lo, og ham kwamin nevo bë maḳ su rëḳ doḳ vu sir in ġaġek rë? Maḳ rëḳ geġin hus ading rot, gesu doḳ vu sir pevis rë? Ma. ");
INSERT INTO bzh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Sa nanër vu ham nabë: Rëḳ genġo hir ġaġek bedoḳ vu sir pevis. Rëḳ mu vu tamusën sën Mehönon Nalu nom lo, og maḳ rëḳ natöḳ vu yi alam la gedenegevonġ geving yi medemedo ma rëḳ nama?” ");
INSERT INTO bzh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Log Yesu nër ġaġek peggirinsën ti vu alam vahi sën yö kwaj nevo sir bë sir alam yohvu gedenelë alam vahi pin bë nij paya lo bë, ");
INSERT INTO bzh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Mehö luu kwaj nevo bë denajom jaḳ, lob luho deraḳ medeya dub vabuung böp. Parisai* ngwë, log alam sën deneḳo takës* lo ngwë. ");
INSERT INTO bzh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisai* sënë nare ya, bevenġev raḳ loḳ ayo nebë sënë, ‘Oo Anutu, sa kwaġ vesa vu honġ, in sa su nebë alam vahi rë. In sir og kwaj luu bedenevo alam hir nġaa vër. Gesir alam nij paya, gedenevonġ baggëb. Rëḳ sa og su nebë sën sir-ë rë. Gesa su nebë mehö neḳo takës* sën nare agi ving rë. ");
INSERT INTO bzh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sayeġ neggërin nos buk luu luu neyoh vu soda ti ti. Log nġaa pin sën sa nehaḳo lo, og sa nehetunġ ya yu nemadluho, lob sa navo ti vu honġ.’ ");
INSERT INTO bzh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Rëḳ mehö sën neḳo takës* lo, og yö nare ggëp ading, log nilël bë su barah mala jaḳ yaġek, gaḳ petap babu log jom raḳ bë, ‘Oo Anutu, sa mehö niġ paya, rëḳ mu kwam gevonġin sa!’ ");
INSERT INTO bzh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Om sa nanër vu ham nabë: Anutu nër mehö sën neḳo takës* agi bë yi mehö yohvu beyah meya yi begganġ los nipaya masën. Gaḳ mehö ngwë sënë og ma. In mehöti bë yö geḳo yi jaḳ, og Anutu rëḳ dahun yi. Gaḳ mehöti sën yö dahun yi lo, og Anutu rëḳ geḳo arë jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Loḳ deḳo hurmahen deyam vu Yesu, in bë gebë nema jaḳ sir. Rëḳ yi hur maluh delë, lob denërin sir. ");
INSERT INTO bzh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Rëḳ ma geYesu tahi hurmahen deyam vu yi, log nër bë, “Ham gwevonġ hurmahen denam vu sa. Ham su gwërin sir, in alam sën ayoj neyam timu vu sa nebë hurmahen lo, og rëḳ demedo doḳ Anutu-yi-nyëġ. ");
INSERT INTO bzh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Om sa nanër vu ham yönon nabë: Mehöti sën su ayo na timu vu Anutu-yi-nyëġ nabë hurmahen rë lo, og su yoh vu bë rëḳ doḳ na rë.” ");
INSERT INTO bzh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Loḳ ggev ti loḳ tepëḳ in yi bë, “Tatovaha! Honġ mehö nim vesa anon, om sëḳ ġevonġ nabë va in sena medo malaġ-tumsën degwata los degwata?” ");
INSERT INTO bzh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Loḳ Yesu nër yah vu yi bë, “Ġenër sa bë sa niġ vesa in va? In Anutu yö timu og nivesa. ");
INSERT INTO bzh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ġeraḳ Anutu yi horek ni ggovek ya bë: Su gwevonġ baggëb. Su ġengis mehönon medenadiiḳ. Su ġeġodeḳ nġaa. Su ġenanër ġaġek tetuhinsën jaḳ mehö ngwë. Ġeġurek amam lu atam babuj.” ");
INSERT INTO bzh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Loḳ ggev lo nër yah vu bë, “Ëë-ë, sënëḳ senġo nahën hurmahen, log sa nesepa loḳ horek pin sënë rot beverup gwëbeng sagi.” ");
INSERT INTO bzh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu nġo lob nër yah vu yi bë, “Log nġaa ti nahën. Gwevonġ honġ ḳupeḳ pin bemehö la debaġo, lob ġebo monë sën gweḳo jaḳ lo gelek alam sën hej nġaa nema in sir lo. Gwevonġ nabë sënë log mëm ġenam ġesepa sa, gemëm honġ ḳupeḳ nivesa rëḳ gëp vu yaġek.” ");
INSERT INTO bzh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Rëḳ ggev sënë nġo ġaġek sënë, lob ayo maggin rot. In yi mehö ḳupeḳ degwa. ");
INSERT INTO bzh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu lë yi lob nër bë, “Alam sën hir ḳupeḳ nġahiseḳë lo, bë dedoḳ na Anutu-yi-nyëġ og rëḳ debimengin rot. ");
INSERT INTO bzh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yönon, kamer bë gurek na rureḳ len, og yiḳ huk böpata rot, rëḳ mu nabë mehö-los-bengö-ggoreksën ti gevonġ in nabë doḳ na Anutu yi nyëġ og sagaḳ huk böpata rot kesuu.” ");
INSERT INTO bzh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Alam denġo ġaġek sënë lob denër bë, “Om maḳ re yoh vu bë rëḳ medo mala-tumsën degwata?” ");
INSERT INTO bzh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Loḳ Yesu nër bë, “Nġaa sën mehönon su deyoh vu bë degevonġ rë lo, og Anutu yö yoh vu bë gevonġ.” ");
INSERT INTO bzh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Loḳ Pita nër bë, “Gwelë! He hevuu he nyëġ los he nġaa pin ya, gehe yam medo nesepa honġ.” ");
INSERT INTO bzh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Lob Yesu nër vu sir bë, “Sa nanër vu ham nabë: Alam pin sën kwaj nevo Anutu-yi-nyëġ, bedenevuu hir begganġ, gevenëj, garij lo, gamaj los ataj, genaluj lo lo, ");
INSERT INTO bzh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","og Anutu rëḳ bo nġahiseḳë doḳ nah vu sir doḳ buk sënë, log rëḳ demedo malaj-tumsën degwata los degwata vu tamusën.” ");
INSERT INTO bzh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Lob Yesu ḳo sir nemadluho-bevidek-luu lo ya, benër vu sir bë, “Ham nġo! Gwëbeng hil naraḳ menaya Yerusalem. Lob ġaġek pin sën alam-denenër-ġaġek-ranġahsën dekevu raḳ Mehönon Nalu wirek meneggëp lo vonġin anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","In rëḳ debo yi doḳ na alam-yu-ngwë nemaj. Lob rëḳ denanër pelë jaḳ yi, gedegevonġ paya vu yi, gedepesuv nyëj ḳos jaḳ yi. ");
INSERT INTO bzh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Log rëḳ debeek yi, log mëm dengis yi menadiiḳ. Rëḳ mu buk natu löö jaḳ, lob rëḳ kedi jaḳ nah gökin.” ");
INSERT INTO bzh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Rëḳ yi hur maluh su deraḳ ġaġek sënë ni rë. In neggëp vunsën in sir lob su kwaj töḳ raḳ degwa rë. ");
INSERT INTO bzh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu ya verup Yeriko, lob mehö mala ḳenod ti nedo loḳ aggata nenga bemedo neketaġ monë lu nġaa vu alam bë dedoḳ vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Lob nġo dedun bë alam yu böpata to deneyam, lob loḳ tepëḳ vu sir bë, “Denevonġ va?” ");
INSERT INTO bzh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Loḳ denër vu bë, “Yesu vu Nasaret verup.” ");
INSERT INTO bzh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Lob tahi ya bë, “Yesu! Davit* yi mewis-e! Kwam gevonġin sa.” ");
INSERT INTO bzh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Loḳ alam sën denemuġin lo depetupek raḳ yi bë aye nama. Rëḳ ma gepasanġ netahi menegeyeh loḳ bë, “Davit* yi mewis-e! Kwam gevonġin sa!” ");
INSERT INTO bzh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Lob Yesu ya nare genër vu sir bë degeḳo yi na vu yi. Ya verup, lob Yesu loḳ tepëḳ vu yi bë, ");
INSERT INTO bzh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ġevonġin bë sa ġevonġ nabë va vu honġ-a?” Loḳ nër bë, “Mehöböp, sa bë gwevonġ besa malaġ natum gökin.” ");
INSERT INTO bzh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Lob Yesu nër vu bë, “Malam natum. Ayom yam timu vu sa om vonġ bemalam nivesa raḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lob pevis bemala nivesa raḳ avuti genelë nyëġ. Lob tamuin Yesu meneya, geneḳo Anutu arë raḳ. Galam pin sën delë nġaa agi deḳo Anutu arë raḳ ving. ");
INSERT INTO bzh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Lob Yesu loḳ ya Yeriko in bë noh na bena. ");
INSERT INTO bzh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Loḳ mehöti arë nebë Sakeus nedo. Alam-deneḳo-takës* hir ggev ti yi, beyi mehö neggorek monë nġahiseḳë. ");
INSERT INTO bzh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Lob kwa nevo bë gelë Yesu mejaḳ ni nabë yi mehö nebë va. Rëḳ yi mehö vaha dus besu yoh vu bë rëḳ gelë yi nivesa rë, in alam nġahi rot medeggërin yi. ");
INSERT INTO bzh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Lob seröġ bemuġin beya meraḳ ya ḳele map ti in bë mëm gelë Yesu. In raḳ ni bë rëḳ na berup sagu. ");
INSERT INTO bzh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Lob Yesu ya verup bevarah mala raḳ melë yi, lob nër ya vu bë, “Sakeus, ġeduḳ pevis meġenam! In sëḳ medo geving honġ doḳ böm pehi sënë.” ");
INSERT INTO bzh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Lob luḳ pevis beḳo Yesu raḳ meya yi begganġ los kwa vesa. ");
INSERT INTO bzh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Alam delë nebë sënë, lob ahëj sengën medenër bë, “Ya neggëp loḳ mehö nipaya ti sagu yi begganġ in va?” ");
INSERT INTO bzh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lob Sakeus ya nare benër vu Mehöböp bë, “Mehöböp, gwenġo rë. Sëḳ ġevonġ sa nġaa pin vahi vu alam sën deneraḳ vu in nġaa lo. Log alam sën sa tetuhin sir gesehodeḳ hir nġaa ti ti lo, og sëḳ ġevonġ nġaa lubeluu lubeluu doḳ nah vu sir.” ");
INSERT INTO bzh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Lob Yesu nër vu yi bë, “Gwëbeng sënë, Anutu ḳol alam begganġ ayo ti sënë yah vu yi. In mehö sënë og degwa vu Abraham ving. ");
INSERT INTO bzh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yönon, Mehönon Nalu yam in bë sero mehönon sën malaj nema lo begeḳo sir nah.” ");
INSERT INTO bzh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Denġo ġaġek sënë ggovek, log nër ġaġek peggirinsën ti vu sir. In ya verup dus raḳ Yerusalem, lob kwaj nevo bë buk dus raḳ bAnutu-yi-nyëġ vonġin anon jaḳ pevis avuti. ");
INSERT INTO bzh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Lob nër vu sir bë, “Mehö böp ti bë na nyëġ ading ti jaḳ in degetunġ yi natu mehö-los-bengö benom geġin yi alam pin. ");
INSERT INTO bzh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Lob supin yi hur nemadluho yam bevo monë ḳapiya luu luu ggelek sir pin, log nër vu sir bë, ‘Ham medo gwevonġ huk baġosën jaḳ monë sënë rot, besenom geto sënë gökin.’ ");
INSERT INTO bzh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Rëḳ yi alam nij nelëlin yi, om ya, log devonġ mehö la detamuin yi medeya beya denër bë, ‘He nimin lël bë mehö saga su natu he mehö-los-bengö megeġin he!’ ");
INSERT INTO bzh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Rëḳ ma gedetunġ yi tu hir mehö-los-bengö ggovek geyom to. Lob nër bë, ‘Ham tahi alam sën sevo monë vu sir lo nam. Sa bë ġalë nabë sir ti ti deneḳo va la va la loḳ ya ving-a?’ ");
INSERT INTO bzh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Lob mehöti nare yam muġin benër ya bë, ‘Mehö böp, sa hevonġ huk baġosën raḳ honġ monë ḳapiya luu sënë, log sa haḳo ḳapiya mehödahis sënë loḳ yam ving.’ ");
INSERT INTO bzh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Lob mehö-los-bengö nër vu yi bë, ‘Honġ hur nivesa beġevonġ huk nivesa rot. Ġenemalamin nġaa mahen sënë nivesa, om sëḳ ġevonġ begweġin nyëġ böp yu nemadluho.’ ");
INSERT INTO bzh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Log mehö ngwë sën netu luu nare benër ya bë, ‘Mehö böp, sa hevonġ huk baġosën raḳ honġ monë ḳapiya luu sënë, log gwëbeng sa haḳo ḳapiya nemadluho sënë loḳ yam ving.’ ");
INSERT INTO bzh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Lob mehö-los-bengö nër vu yi bë, ‘Om sëḳ ġevonġ nyëġ böp yu nemadvahi in gweġin.’ ");
INSERT INTO bzh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Loḳ hur ti verup nare yam, benër ya bë, ‘Mehö böp, honġ monë ḳapiya luu sën lo sënë. Sa hebom loḳ tob nyë dus teka besa heġin nivesa beyö nedo rot. ");
INSERT INTO bzh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","In sa nehalë honġ bë honġ mehö nim wëëk. Nġaa sën mehö ngwë denetunġ menedo lo, og ġeneḳo. Genos sën mehö ngwë denevaroh lo, og ġenelev anon. Om sën sehönengin honġ, lob honġ monë ḳapiya luu sën lo yö nedo.’ ");
INSERT INTO bzh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Lob mehö-los-bengö nër vu mehö sënë bë, ‘Honġ sënë, nim paya rot! Maḳ sëḳ ġevonġ ġaġek vu honġ jaḳ nġo honġ ġaġek saga rë. Maḳ ġeraḳ ni yönon bë sa mehö niġ wëëk, bemehö ngwë denetunġ nġaa nedo loḳ sa nehako, gesa nalev nos sën mehö ngwë denevaroh lo? Yönon-a? Sa nehevonġ nebë sënë? ");
INSERT INTO bzh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Rëḳ nebë va sën su ġetunġ sa monë loḳ ya begganġ-monë-yi in bë senom og sa ġaḳo teka sevöḳ geving rë-ë?’ ");
INSERT INTO bzh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Log nër vu alam sën denare dus vu lo bë, ‘Ham bo monë ḳapiya luu saga vër in mehö saga, gebo nah geving vu mehö sën ḳapiya mehödahis nedo vu yi lo.’ ");
INSERT INTO bzh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Loḳ denër yah vu bë, ‘Mehö böp, mu ḳapiya mehödahis neggëp vu yi vorot.’ ");
INSERT INTO bzh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Loḳ nër bë, ‘Sa nanër vu ham nabë mehöti sën nġaa neggëp vu yi lo, og sëḳ bo la gökin geving vu. Gaḳ mehöti sën yi nġaa su neggëp rë lo, og sëḳ bo teka sën neggëp vu yi lo vër in yi. ");
INSERT INTO bzh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Rëḳ alam sën denelë sa paya benij lël bë sa su natu hir mehö-los-bengö lo, og ham gweḳo sir nam sënë beham ngis sir bedenadiiḳ jaḳ sa malaġ.’” ");
INSERT INTO bzh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu nër ġaġek sënë ggovek, log muġin betetuu aggata meneya Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ya verup dus raḳ Betpage los Betania ggëp Ḳedu Ḳele-oliv, lob vonġ yi hur maluh luu deya, ");
INSERT INTO bzh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","genër vu luho bë, “Melu na medoḳ na begganġ-bu ti sën melu malamin neya agu, lob melu rëḳ gwelë gedeseyu dogi nalu ti menare dus vu aggata avi. Mehöti su raḳ dogi sënë wirek rë, lob melu kwevelekin begweḳo nom. ");
INSERT INTO bzh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Genabë mehöti doḳ tepëḳ nabë, ‘Melu gwevonġ va vu dogi sagi?’ og melu nanër nah nabë, ‘Mehöböp bë jaḳ mena’.” ");
INSERT INTO bzh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yesu vonġ luho ya, lob luho ya detöḳ vu nġaa pin yoh vu sën nër vu luho lo. ");
INSERT INTO bzh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Luho medo denekevelekin dogi sënë, loḳ dogi ala loḳ tepëḳ in luho bë, “Melu nekwevelekin dogi nalu sënë in gwevonġ va vu?” ");
INSERT INTO bzh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Loḳ luho denër yah bë, “Mehöböp bë jaḳ mena.” ");
INSERT INTO bzh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lob luho deḳo dogi medeya vu Yesu. Lob delah hir tob raḳ ya dogi demi, log detunġ Yesu raḳ ya nedo vavunë. ");
INSERT INTO bzh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bemëm neraḳ meneya, galam pin kwaj vesa rot vu yi bedenevah hir tob ggök aggata geneggök, ");
INSERT INTO bzh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","beya deverup dus raḳ sën aggata nehöö Ḳedu Ḳele-oliv. Lob yi hur maluh pin sën denesepa yi lo, gesir nġahiseḳë saga kwaj vo yah nġaa böp böp pin sën nevonġ bedenelë wirek lo, lob kwaj vesa bedenepisekin medeneḳo Anutu arë raḳ bë: ");
INSERT INTO bzh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Anutu gevonġ semusemu vu mehö-los-bengö sën neyam los Mehöböp niwëëk! Ġaġek ahë yes raḳ neggëp yaġek, log Anutu arë böpata los niḳapiik nivesa neggëp yaġek vavunë!” ");
INSERT INTO bzh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Log alam Parisai* la deloḳ ya alam yu böpata saga vuheng belosho deneya, lob denër vu Yesu bë, “Tatovaha, ġenanërin honġ hur maluh lo sënë nabë ayej nama.” ");
INSERT INTO bzh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Loḳ nër yah vu sir bë, “Sa nanër vu ham nabë: Bë ayej nama, og ġelönġ lo sënë yö rëḳ denapisek.” ");
INSERT INTO bzh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Loḳ Yesu ya verup dus raḳ, lob mala ya melë nyëġ böp Yerusalem, lob su raḳ. ");
INSERT INTO bzh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Su raḳ bë, “Nabë yiḳ ġejaḳ mehö sën yoh vu bë gevonġ honġ beġemedo revuh lo ni gwëbeng sagi, og mëm sënë nivesa. Rëḳ ma gemehö sënë neggëp vunsën in honġ, gesu ġeraḳ ni rë. ");
INSERT INTO bzh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gwenġo rë, buk ti vonġin berup, lob alam sën degevonġ beġö vu honġ lo rëḳ nam dedev lii beġö yi medetetup doḳ honġ. Log rëḳ deketumin honġ vahi vahi. ");
INSERT INTO bzh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Lob rëḳ dekevoh honġ geving nalum lo pin sën denedo loḳ honġ lo na. Log su rëḳ degönengin ġelönġ ngwë gejaḳ medo ngwë vavunë rë. In su kwam nevo buk sën Anutu yam in bë doḳ vu honġ lo rë.” ");
INSERT INTO bzh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Log loḳ ya dub-vabuung-böp ayo, lob tii alam sën denevonġ huk baġosën loḳ ayo lo. ");
INSERT INTO bzh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Genër vu sir bë, “Ġaġek neggëp loḳ Anutu-yi-ḳapiya bë: Sa begganġ, og yö rëḳ natu begganġ jom-raḳsën-yi. Rëḳ ham vonġ beyah tu alam hodeḳ bej waaḳ vunsën raḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Log nenër ġaġek vu alam yoh vu buk loḳ dub-vabuung-böp ayo. Lob alam-deneḳo-seriveng hir ggev, galam-horek-yi, galam ggev, bedenesero aggata in bë dengis yi menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Rëḳ alam pin nij wëëk bë degenġo yi ġaġek, lob ggev lo su detöḳ raḳ aggata ti rë. ");
INSERT INTO bzh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Buk ti, lob Yesu medo netateḳin ġaġek vu alam loḳ dub-vabuung-böp genenër Bengö Nivesa ranġah vu sir. Lob alam-deneḳo-seriveng hir ggev losho alam-horek-yi, galam ggev, bedeya vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bedeloḳ tepëḳ vu yi bë, “Ġenanër vu he nabë: Re vo niwëëk vu honġ benër bë gwevonġ huk nabë sënë? Re ggooin honġ raḳ-a?” ");
INSERT INTO bzh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Loḳ nër yah vu sir bë, “Kë, om sa bë doḳ tepëḳ in ġaġek ti nök vu ham rë. Ham nanër vu sa nabë: ");
INSERT INTO bzh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Sën Jon neripek alam lo, og yam vu yaġek, ma sepa loḳ mehönon vu dob kwaj?” ");
INSERT INTO bzh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lob yö desap sir raḳ medenër bë, “Nabë hil nanër nah nabë: ‘Yam vu yaġek’, og rëḳ doḳ tepëḳ nom nabë: ‘Rëḳ nebë va sën ham su nevonġ ving yi rë-ë?’ ");
INSERT INTO bzh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Log nabë hil nanër nabë: ‘Sepa loḳ mehönon vu dob kwaj’, og rëḳ alam detengwa hil jaḳ ġelönġ. In kwaj neya niwëëk vu yi bë yi mehö-nenër-ġaġek-ranġahsën ti.” ");
INSERT INTO bzh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Lob maam denër yah vu Yesu bë, “He duġin degwa-o!” ");
INSERT INTO bzh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Lob Yesu nër yah vu sir bë, “Nebë saga, om sa su rëḳ nanër mehö sën ggooin sa raḳ lo vu ham rë.” ");
INSERT INTO bzh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nër nebë saga, log nër ġaġek peggirinsën sënë vu alam bë, “Mehöti varoh huk wain bengö ti, lob vo huk sënë loḳ ya alam la nemaj in bë degeġin medegeḳo anon vahi natu yiyi gevahi natu hej. Log tah yi ya nedo nyëġ ading ti beya nedo hus ading rot. ");
INSERT INTO bzh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Log buk sën wain anon nemoneḳ lo dus raḳ, lob vonġ yi hur ti ya vu alam sën deneġin yi huk wain lo in bë debo yiyi la behur geḳo nah vu yi. Rëḳ alam lo deveek hur saga, gedevonġ yi yah meya nema meris. ");
INSERT INTO bzh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Loḳ vonġ hur ngwë yah meya vu sir ggökin. Rëḳ desis yi ving bedevonġ paya vu yi, gedevonġ yi yah meya nema meris. ");
INSERT INTO bzh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lob yiḳ vonġ hur ti yah ggökin netu beron löö. Rëḳ desis yi gedepengah, log detë yi yah dobnë. ");
INSERT INTO bzh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Devonġ nebë sënë, lob huk ala kwa vo bë, ‘Maḳ sëḳ ġevonġ nabë tena? Maam sa ġevonġ senġo naluġ sën sahëġ neving yi lo na, in mëm maḳ rëḳ degurek babu.’ ");
INSERT INTO bzh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Rëḳ alam lo delë bë nalu ya verup, lob yö denër vu sir bë, ‘Mehö sën agi rëḳ doḳ nah ama ben begeḳo ama yi nġaa pin, om ham-o! Hil angis yi menadiiḳ. In mëm huk sënë natu hil nġaa.’ ");
INSERT INTO bzh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Lob derot yi yah dobnë, beyah desis mediiḳ. Om huk wain ala sënë maḳ rëḳ gevonġ nabë va vu sir-a? ");
INSERT INTO bzh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Rëḳ na, lom kevoh alam sën deneġin huk wain agi bemalaj nama na, log bo huk wain sënë vu alam mewis la bedegeġin.” Alam denġo ġaġek sënë lob denër bë, “Maam nġaa nabë saga og nök gëp!” ");
INSERT INTO bzh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Rëḳ Yesu gët sir geloḳ tepëḳ in sir bë, “Bë nama og ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo nër bë va? Sën nër bë: ‘Alam sën denelev begganġ lo nij lëlin ġelönġ ti sënë, rëḳ mu netu ġelönġ niwëëk begganġ nyëḳetu yi.’ ");
INSERT INTO bzh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mehönon pin bë debës bedengis sir jaḳ ġelönġ sënë, og rëḳ deḳataḳ jaḳ pin. Log nabë ġelönġ sënë geto mejaḳ gëp mehöti, og rëḳ natul mehö sënë bemetes na.” ");
INSERT INTO bzh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Lob alam-horek-yi losho alam-deneḳo-seriveng hir ggev deraḳ ni bë Yesu nenër ġaġek peggirinsën sënë raḳ sir. Lob devonġin bë denajom yi ahon doḳ buk sënë, rëḳ deggönengin alam. ");
INSERT INTO bzh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Lob tum alam ggev medo deneġin yi. Log devonġ hir mehö la ya deloḳ yi medenelë. Lob ya detetuhin bë sir alam yohvu, in bë denajom yi ahon jaḳ ġaġek la bedegevonġ doḳ nah nemaj gena ġaġek vu kiap böp. ");
INSERT INTO bzh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Lob deloḳ tepëḳ vu yi bë, “Tatovaha, he nehanġo honġ ġaġek bë honġ ġaġek neya niröp, beġenenër ġaġek niröp vu alam. Su ġenehönengin alam sën los arëj lo malaj rë. Gaḳ ġenetateḳin Anutu yi ġaġek vu alam los anon mu. ");
INSERT INTO bzh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Om kwam nevo bë? Yoh vu bë hil ġetunġ takës vu alam Rom hir mehö-los-bengö Sisar* ma nama?” ");
INSERT INTO bzh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Rëḳ Yesu raḳ hir ġaġek tetuhinsën sënë ni, lom nër yah vu sir bë, ");
INSERT INTO bzh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ham tato monë ġahis ti nam besa ġalë rë.” Devo ya lob nër bë, “Re ḳenu los arë sën raḳ neggëp agi?” Loḳ denër yah bë “Sisar*.” ");
INSERT INTO bzh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Lob nër yah vu sir bë, “Om ham gwevonġ Sisar* yi nġaa nah vu Sisar*. Log Anutu yi nġaa, og ham bo nah vu Anutu.” ");
INSERT INTO bzh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Lob su deyoh vu bë denatöḳ vu ġaġek ti jaḳ yi gëp alam malaj medenajom yi ahon rë. Gaḳ ḳenuj ya in ġaġek sën nër lo, lob ayej ma. ");
INSERT INTO bzh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Alam Sadukai* denenër bë alam-diiḳsën og su rëḳ dekedi jaḳ nah rë. Lob sir la deya vu Yesu, ");
INSERT INTO bzh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","bedeloḳ tepëḳ vu yi bë, “Tatovaha, Moses kevu horek ti vu hil meneggëp bë, ‘Nabë mehöti geḳo avëh, rëḳ nadiiḳ geluho naluj nama, og ari geḳo yi alov natu venë beluho degeḳo naluj vu ari sën diiḳ lo.’ ");
INSERT INTO bzh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Lob hur maġëm ti losho ari lo, sir nemadvahi-bevidek-luu denedo. Lob arij aġuu ḳo avëh, lob nalu ma gediiḳ. ");
INSERT INTO bzh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Lob ari amon ḳo yi alov loḳ diiḳ ving. ");
INSERT INTO bzh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Lob ari gwee vonġ nebë saga ving, beya metöḳ meggi. Besir pin deḳo avëh timu sënë, rëḳ naluj ma, gedediiḳ pin. ");
INSERT INTO bzh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Log mëm avëh diiḳ raḳ neggëp hus. ");
INSERT INTO bzh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Om ġenanër nabë najeeng sën mehönon diiḳsën dekedi jaḳ nah lo, og avëh sënë rëḳ natu arij ti tena venë? In sir pin deḳo avëh timu sënë netu venëj.” ");
INSERT INTO bzh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Loḳ Yesu nër yah vu sir bë, “Maluh los avëh deneḳo sir loḳ buk sënë. ");
INSERT INTO bzh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Gaḳ maluh los avëh sën Anutu nër bë yoh vu bë rëḳ dekedi jaḳ nah medemedo malaj-tumsën lo, og su rëḳ degeḳo sir doḳ Buk-tamusën rë. ");
INSERT INTO bzh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","In su deyoh vu bë denadiiḳ gökin rë. Gaḳ rëḳ demedo nabë angër lo. Anutu rëḳ gevonġ bedekedi jaḳ nah gëp bedub, om rëḳ denatu yö nalu lo. ");
INSERT INTO bzh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Log Moses tato vu hil ving bë alam-diiḳsën denekedi raḳ yah ggëp bedub. In kevu raḳ Mehöböp meneggëp loḳ ġaġek sën nengwah netum loḳ ḳele yu dabun ti lo bë, ‘Abraham yi Anutu, gIsaak yi Anutu ga, Yakop yi Anutu.’ ");
INSERT INTO bzh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Om nabë mehönon denadiiḳ bemalaj nama na veröḳ yi, og su yoh vu bë rëḳ nanër nabë lööho hir Anutu yi rë. Gaḳ lööho denedo malaj-tumsën, in Anutu og alam malaj vesa los malaj-tumsën hir Anutu yi. In nelë mehönon pin bë sir pin denedo malaj-tumsën.” ");
INSERT INTO bzh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nër nebë sënë, lob alam-horek-yi la denër yah vu bë, “Tatovaha, ġenër ya meyoh vu.” ");
INSERT INTO bzh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Lob nij nemum in yi besu deloḳ tepëḳ in yi ggökin yah rë. ");
INSERT INTO bzh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Loḳ Yesu loḳ tepëḳ yah vu sir bë, “Log nebë tena sën denenër Kerisi* bë degwa vu Davit*-ë? ");
INSERT INTO bzh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","In Davit yö nër raḳ avi beneggëp loḳ ḳapiya Saam bë: ‘Mehöböp nër vu sa Mehöböp bë: “Ġemedo sa nemaġ vesa. ");
INSERT INTO bzh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Gevu tamusën og sëḳ ġetunġ alam sën denelë honġ paya lo dedoḳ na vaham ġebinë.” ’ ");
INSERT INTO bzh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yi degwa vu Davit*, loḳ nebë tena sën Davit nër yi bë yi Mehöböp-ë?” ");
INSERT INTO bzh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Alam pin nahën medo denenġo Yesu yi ġaġek, lob nër vu yi hur maluh bë, ");
INSERT INTO bzh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ham gweġin ham in alam-horek-yi. In ahëj neving bë dejöp tob ading nivesa vesa. Log ahëj neving bë alam debengwënġ vu sir medegeḳo sir jaḳ doḳ alam tabaaḳ. Gahëj neving panġsën bë na demedo lël mala gëp alam malaj doḳ dub-supinsën-yi ayo, gahëj neving bë jaḳ na dega nos namuġin gëp nyëġ-nos-böp-yi. ");
INSERT INTO bzh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Alam sënë deneraa avëh alov hir begganġ yah vu sir, log denekuung raḳ bedenevenġev raḳ hus ading. Om doḳ buk-ġaġek-yi, og rëḳ denatöḳ vu maggin böpata rot mekesuu.” ");
INSERT INTO bzh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Log Yesu vër mala raḳ menelë alam-los-bengöj-ggoreksën lo vahi, geya denetunġ seriveng luḳ ya keröng-monë-yi vu Anutu. ");
INSERT INTO bzh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Lob lë avëh alov ti sën hen monë ma, lob yiḳ tunġ monë ḳöḳ teka luu mu luḳ ya keröng. ");
INSERT INTO bzh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Lob nër bë, “Sa nanër yönon vu ham nabë: Avëh alov sën hen monë ma agi të monë böpata rot bekesuu alam vahi pin. ");
INSERT INTO bzh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Senër nebë sënë in sir mehönon-los-bengöj-ggoreksën behir nġaa nġahiseḳë nedo vu sir, gaḳ sën denetunġ lo og yiḳ metes. Gaḳ avëh sënë og su hen vahi nedo rë, rëḳ yö keyoveḳin keröng ahë degwa raḳ metunġ yi nġaa pin tu seriveng gehen monë nos yi ma.” ");
INSERT INTO bzh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Log mehö la denevengwënġ raḳ dub-vabuung-böp medenenër bë, “Devuneḳ vu begganġ sënë raḳ ġelönġ nivesa vesa los ḳupeḳ sën detunġ tu seriveng vu Anutu lo bemalanġeri rot.” Loḳ Yesu nër bë, ");
INSERT INTO bzh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nġaa pin sën ham nelë gwëbeng agi, og buk ti vonġin berup, lob su rëḳ degönengin ġelönġ ti gejaḳ medo ngwë vavunë rë. Gaḳ rëḳ dekevoh pin bedegetë geto yoh yoh.” ");
INSERT INTO bzh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Lob deloḳ tepëḳ vu yi bë, “Tatovaha, nġaa sën ġenër lo rëḳ anon jaḳ doḳ buk tena? Geva rëḳ tato vu he nabë nġaa sënë vonġin anon jaḳ-a?” ");
INSERT INTO bzh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Loḳ Yesu nër yah bë, “Ham gweġin ham nivesa, in mehö la rëḳ degekuungin ham. Alam nġahiseḳë rëḳ denam bedenanër sarëġ jaḳ nah sir nabë, ‘Mehö sën lo yiḳ sa sënë.’ Log rëḳ denanër nabë, ‘Buk dus raḳ ggovek ya.’ Rëḳ mu ham su sepa sir mena. ");
INSERT INTO bzh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Log ham rëḳ gwenġo beġö bengö los dedun nabë vonġin berup, og ham su ḳenumin berup. In nġaa nebë sënë yö rëḳ nam, gaḳ Buk-tamusëneḳ yö rëḳ nahën.” ");
INSERT INTO bzh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Log nër vu sir ving bë, “Alam dob ngwë rëḳ dekedi belosho alam dob ngwë dengis sir. Log mehö-los-bengö ngwë losho yi alam rëḳ dekedi belosho mehö-los-bengö ngwë losho yi alam dengis sir. ");
INSERT INTO bzh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Log jemapi böpata rëḳ gee jaḳ dob beron beron. Log alam nyëġ la rëḳ denatöḳ jaḳ meyip los niraḳsën aggagga. Log ham rëḳ gwelë nġaa böp böp genġaa aggagga sën rëḳ gevonġ beham ḳenumin berup in lo gëp yaġek babu. ");
INSERT INTO bzh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Rëḳ mu nġaa pin sënë yö rëḳ nahën, log rëḳ denajom ham ahon, bedegevonġ paya vu ham. Rëḳ degevonġ beham gwevonġ ġaġek doḳ dub-supinsën-yi log degetunġ ham na ḳarabus. Log rëḳ degeḳo ham na bare alam-los-bengöj böp los kiap böp lo malaj in sa alam ham. ");
INSERT INTO bzh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lob doḳ buk sënë, og yiḳ ham nanër sa ranġah vu sir. ");
INSERT INTO bzh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Om ham medo kwamin veröḳ, gaḳ ham su medo mekwamin bo ġaġek sën ham nanër nah vu sir lo. ");
INSERT INTO bzh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","In senġo rëḳ ġevonġ ġaġek sën ham nanër nah vu sir lo doḳ nök ham avimin, besebo kwa nivesa vu ham. Lob alam sën degelë ham paya lo su deyoh vu bë dekeyëh, ma dedahun ġaġek sën sebo vu ham agi rë. ");
INSERT INTO bzh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ham amamin los atamin garimin, geham alam sën ham degwa ti lo, geham nimin papu lo, yö rëḳ denanër ham ranġah vu alam sën dengis ham lo. Lob rëḳ dengis ham la medenadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Log alam pin rëḳ ahëj sengën böp rot vu ham, in sa alam ham. ");
INSERT INTO bzh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Rëḳ mu ham yumin viis ti su rëḳ mala nama doḳ ham yumin rë. ");
INSERT INTO bzh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bë ham najom sa ahon bemedo los nimin wëëk, og ham rëḳ medo malamin-tumsën.” ");
INSERT INTO bzh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Rëḳ mu ham rëḳ gwelë nabë alam-beġö-yi nök detetup doḳ Yerusalem, og ham jaḳ ni nabë buk sën debasap Yerusalem lo yök dus raḳ saga. ");
INSERT INTO bzh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Doḳ buk saga og alam sën denedo Yudea lo, rëḳ debeya bedena ḳedu. Galam sën denedo loḳ Yerusalem lo, rëḳ degevuu nyëġ saga gedebeya medena nyëġ ngwë. Galam sën su denedo loḳ nyëġ böp agi rë lo, og su rëḳ debeya menah dedoḳ na rë. ");
INSERT INTO bzh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Buk sënë og buk sën Anutu rëḳ bo doḳ nipaya nyëvewen lo, lob ġaġek pin sën neggëp loḳ yi ḳapiya lo rëḳ anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Gëpin avëh sën naluj nare loḳ ayoj lo, los sën nahën denevo rur vu sir lo doḳ buk sënë! In Anutu rëḳ gevonġ bemaggin böpata rot natöḳ vu dob sënë bekevoh alam sënë. ");
INSERT INTO bzh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Paëp-yu-anil rëḳ ga sir. Galam rëḳ denaduu sir gedegeḳo sir bena demedo ḳarabus na na geving alam-yu-ngwë pin. Galam-yu-ngwë rëḳ vahaj baḳë nyëġ böp Yerusalem, bedemedo nabë sënë rot, begëp nabë sënë bena berup doḳ buk sën alam-yu-ngwë hir buk govek na lo. ");
INSERT INTO bzh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Lob ham rëḳ gwelë genġaa böp aggagga natöḳ vu hes lu kwev, gebetuheng. Log mehönon pin vu dob rëḳ newaj bepul bemedo degelëk in loo dedun sën rëḳ natëë benam lo. ");
INSERT INTO bzh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Alam nġahiseḳë rëḳ kwaj bo nġaa sën anon jaḳ vu dob agi, lob rëḳ newaj jaḳ rot, gemalaj pebilin. In nġaa los niwëëk pin vu yaġek rëḳ desasuḳin sir. ");
INSERT INTO bzh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sënë anon jaḳ, lob rëḳ degelë Mehönon Nalu doḳ medo beggob ayo menam los niwëëk böpata gevuneḳ vuneḳ yaġek yi. ");
INSERT INTO bzh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Doḳ buk sën nabë nġaa agi natöḳ nam lo, og ham rëḳ bare nam bebarah malamin jaḳ. In buk sën Anutu geḳo ham nah lo yam dus raḳ ggovek ya saga.” ");
INSERT INTO bzh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Log nër ġaġek ti metateḳin vu sir bë, “Ham kwamin bo jaḳ go* los nġaa vahi pin rë. ");
INSERT INTO bzh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bë purpur berup ngu, og ham neraḳ ni bë go* vonġin nabunġ beham dev jaḳ na jök. ");
INSERT INTO bzh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Om nabë ham gwelë nġaa pin sënë anon jaḳ, og ham jaḳ ni nabë buk dus raḳ ggovek ya bë Anutu natu ala benam geġin hil. ");
INSERT INTO bzh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sa nanër vu ham yönon nabë: Mehönon pin su rëḳ malaj nama na veröḳ yi rë, log nġaa pin sën agi rëḳ anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Log yaġek los dob rëḳ govek na bemala nama na vu tamusën, gaḳ sa ġaġek og su rëḳ mala nama rë.” ");
INSERT INTO bzh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Rëḳ mu ham gweġin ham nivesa, in ham rëḳ medo gwevonġ ahëmin ta, genanum beyumin gevonġ paya gekwamin bo nġaa-dob-yi, lob nġaa nabë saga rëḳ gërin ham ayomin, lob Mehöböp yi buk sënë rëḳ nam natöḳ vu ham avuti nabë sën saġ neloḳ sapu lo. ");
INSERT INTO bzh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Buk sënë rëḳ natöḳ vu alam pin vu dob pin. ");
INSERT INTO bzh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Om ham nġo medo malamin natum bekwetaġ vu Anutu noh vu buk pin in ġadu ham niwëëk. In lob nġaa pin sënë noh nenga in ham, geham medo rot menatöḳ na vu Mehönon Nalu bebare mala.” ");
INSERT INTO bzh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu netahu alam loḳ dub-vabuung-böp ranġah pin, log buk lob yah neggëp Ḳedu Ḳele-oliv. ");
INSERT INTO bzh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Log monbuk anon lob alam pin dekedi deneya dub-vabuung-böp in bë nanër ġaġek medegenġo. ");
INSERT INTO bzh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Buk vabuung sën denegga brët sën yiist* nema in lo verup. Sën denenër bë Buk-ggöksën-yi* lo. ");
INSERT INTO bzh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Lob alam-deneḳo-seriveng hir ggev losho alam-horek-yi denesero aggata bë dengis Yesu. Rëḳ ma in deneggönengin alam. ");
INSERT INTO bzh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Loḳ Satan loḳ ya Yudas sën denenër arë ngwë nebë Iskariot lo ayo. Yiḳ sir nemadluho-bevidek-luu lo ti yi, ");
INSERT INTO bzh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","lob ya vengwënġ ving alam-deneḳo-seriveng losho alam sën deneġin dub-vabuung-böp lo, in bë natöḳ vu aggata lob bo Yesu doḳ na nemaj. ");
INSERT INTO bzh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Lob kwaj vesa, gedenër vu yi vorot bë rëḳ debaġo yi. ");
INSERT INTO bzh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Lob Yudas yoġek in ayej, log kwa nesero buk sën alam nġahiseḳë su denedo ving yi rë lo, in bë mëm gevonġ Yesu doḳ na nemaj. ");
INSERT INTO bzh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Log Buk-vabuung sën alam Yuda denegga brët sën yiist* nema in lo verup ggovek ya, lom yiḳ buk sën denesis sipsip nalu Buk-ggöksën-yi* yi loḳ lo sënë. ");
INSERT INTO bzh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Lob Yesu vonġ Pita luho Jon ya, genër vu luho bë, “Melu na gwero nos los reggu Buk-ggöksën-yi* vu hil in hil aġa.” ");
INSERT INTO bzh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Loḳ luho deloḳ tepëḳ yah vu bë, “Ġevonġin bë alu ġero gëp tena?” ");
INSERT INTO bzh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Loḳ nër yah bë, “Melu lë! Melu na medoḳ na nyëġ böp sagu, log mehöti rëḳ kerë bël doḳ dëg böp ti menatöḳ vu meluu doḳ aggata. Lob melu tamuin yi rot bedoḳ na begganġ sën doḳ na lo. ");
INSERT INTO bzh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Lob melu nanër vu begganġ ala nabë, ‘Tatovaha nër bë alu anam nanër vu honġ nabë, “Begganġ ayo tena in sa los sa hur maluh lo aġa nos los reggu Buk-ggöksën-yi* dok-a?” ’ ");
INSERT INTO bzh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Lob rëḳ tato ayo böpata ti sën neggëp vavunë vu meluu, ayo ti sën yö devah ḳanyë raḳ vorot. Lob melu gwero nos los reggu vu hil doḳ saga.” ");
INSERT INTO bzh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ggovek log luho deya, lob ya detöḳ vu nġaa pin yoh vu sën Yesu nër vu luho lo. Lob luho dero nos los reggu Buk-ggöksën-yi* loḳ. ");
INSERT INTO bzh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Log nyëġ neggovek, lob Yesu bë ga nos los reggu geving sinarë lo. ");
INSERT INTO bzh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Lob nër vu sir bë, “Sahëġ neving rot bë seġa nos los reggu Buk-ggöksën-yi* sënë geving ham rë, loḳ mëm sa ġaḳo vanë. ");
INSERT INTO bzh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Log sa nanër vu ham nabë: Sa su rëḳ ġa nġaa sënë gökin nah rë, rot bena berup doḳ buk sën hil aġa doḳ ti vu Anutu-yi-nyëġ lo.” ");
INSERT INTO bzh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Log ḳo wain kap ti raḳ bejom raḳ in los kwa vesa ya vu Anutu log nër vu sir bë, “Ham gweḳo sënë nök benanum noh vu ham. ");
INSERT INTO bzh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sa nanër vu ham nabë: Sa su rëḳ nanum wain gökin nah rë, rot bena berup doḳ buk sën hil medo doḳ Anutu-yi-nyëġ lo.” ");
INSERT INTO bzh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Log ḳo brët raḳ bevenġev raḳ in los kwa vesa ya vu Anutu, log debu bevo vu sir. Log nër bë, “Sa reggos sënë. Sën sëḳ ġetunġ natu seriveng doḳ nah ham bömin. Om ham medo sepa doḳ megwevonġ nabë sënë in ham kwamin bo sa.” ");
INSERT INTO bzh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nebë saga bedegga ggovek, log ḳo wain kap ti raḳ bevonġ nebë saga, log nër bë, “Wain kap ti sënë og sa ḳöḳ, sën sëḳ ḳeseh in ham in bë tato nabë ġaġek mewis sën sejoo in doḳ vu ham lo rëḳ anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Rëḳ mu ham gwelë ham rë! Mehö sën rëḳ bo sa doḳ na alam sën denelë sa paya nemaj lo yiḳ nedo raḳ tevor ving sa. ");
INSERT INTO bzh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yönon, Mehönon Nalu nesepa loḳ aggata sën Anutu nër tato vu yi lo. Rëḳ mu gëpin mehö sën rëḳ nanër yi ranġah vu alam bedengis yi lo.” ");
INSERT INTO bzh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nër nebë sënë, lob yö deloḳ tepëḳ vu sir yah meyom bë, “Mehö re rëḳ gevonġ nġaa sënë?” ");
INSERT INTO bzh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Log tum hur maluh deḳo ġaġek ti raḳ loḳ sir, medenenër bë, “Re böp kesuu in geġin hil-a?” ");
INSERT INTO bzh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Loḳ Yesu nër vu sir bë, “Alam-yu-ngwë, og hir mehö-los-bengö tu alaj. Log alam sën detu ala medeneġin sir lo, og denenër behir alam deneḳo sir raḳ bedenenër sir bë sir alam nġatum. ");
INSERT INTO bzh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Rëḳ mu ham, og ham su gwevonġ nabë saga. Gaḳ mehöti sën vonġin bë natu ham ala lo, og dahun yi bemedo nabë sën mehö ahë hus. Log mehöti sën vonġin bë natu ham ggev lo, og gevonġ nġaa nabë sën yi mehö meris ti in doḳ vu ham. ");
INSERT INTO bzh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ma re tu ala? Mehö sën medo neġin in ga nos lo, ma hur sën neruu nos in bë geḳo na vu lo? Gaḳ yiḳ mehö sën neġin bë nos na in ga lo! Rëḳ mu sa, og sa nado ving ham nebë hur meris in bë sedoḳ vu ham. ");
INSERT INTO bzh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Wirek hil los nado gemaggin töḳ vu sa beseggi sa, rëḳ ham nedo ving sa, geham su vuu sa rë. ");
INSERT INTO bzh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Log Amaġ vo yi nyëġ vu sa in bë sa ġeġin, om sebo nyëġ vu ham in ham gweġin nabë saga. ");
INSERT INTO bzh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ham rëḳ gwa los nanum geving sa jaḳ sa tevor gëp sa nyëġ. Geham rëḳ medo jaḳ sëa-los-arëj beseggi alam Israel degwa nemadluho-bevidek-luu sën lo hir ġaġek.” ");
INSERT INTO bzh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon, gwenġo rë! Satan nër vorot bë yoh vu bë rëḳ geḳo ham na vu yi, begerii ham tetër nabë wit* ġahis. ");
INSERT INTO bzh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Rëḳ sejom raḳ in honġ ggovek ya bë honġ vonġvingsën su rëḳ nadiiḳ na rë. Om sën ġegwërin honġ meġenom lo, og ġebo ġadu doḳ arim lo.” ");
INSERT INTO bzh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Loḳ Pita nër yah bë, “Mehöböp, sa hero sa menado in sena ḳarabus geving honġ balu nadiiḳ doḳ ti.” ");
INSERT INTO bzh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Loḳ Yesu nër bë, “Pita, sa nanër vu honġ nabë: Pehi buk sënë, og ḳöḳrëëh su rëḳ ngu rë, log rëḳ ġedah sa vun beron löö nabë honġ duġin sa.” ");
INSERT INTO bzh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Log nër vu sir bë, “Wirek sa hevonġ ham ya, lob ham su ḳo jej-monë-yi los je vahek sepa rë. Log ham su röp suu rë, lob maḳ ham raḳ vu in nġaa ti ma ma?” Loḳ denër yah bë, “Ma!” ");
INSERT INTO bzh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Lob nër vu sir bë, “Gaḳ gwëbeng sënë nabë mehöti yi jej-monë-yi nedo, og yö geḳo sepa yi. Bevahek nabë saga. Gemehöti sën hen paëp-yu-anil nama lo, og tahuuin paëp-yu-anil ti jaḳ yi röpröp-ayööng-yi. ");
INSERT INTO bzh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","In ġaġek neggëp loḳ Anutu-yi-ḳapiya bë, ‘Detevin yi ya ving alam nij paya.’ Om sa nanër vu ham nabë: Ġaġek sënë rëḳ anon jaḳ, jaḳ nġaa pin sën rëḳ natöḳ vu sa. Yönon, ġaġek pin sën neggëp loḳ ḳapiya raḳ sa lo, og rëḳ anon jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Lob denër bë, “Mehöböp, ġelë? He paep-yu-anil luu sënë!” Loḳ nër yah bë, “Om yiḳ ggovek saga.” ");
INSERT INTO bzh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Log to meya dobnë beya Ḳedu Ḳele-oliv nebë sën nevonġ yoh vu buk lo. Lob yi hur maluh desepa yi medeya. ");
INSERT INTO bzh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ya detöḳ ya, lob nër vu sir bë, “Ham najom jaḳ niwëëk, in nġaa ti su kepë ham.” ");
INSERT INTO bzh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Log tah verup ya teka, yoh vu sën hil ġetë ġelönġ na geto lo, lob yun lus log ketaġ vu Ama bë, ");
INSERT INTO bzh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Amaġ, nabë kwam, og gweḳo nġaa maggin sënë vër in sa. Rëḳ mu su ġesepa doḳ sa ġaġek, gaḳ nġo kwam.” ");
INSERT INTO bzh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Lob angër ti vu yaġek beyam ġadu yi. ");
INSERT INTO bzh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu nġo maggin panġsën rot, lob jom raḳ ggökin niwëëk rot. Lob ḳerus yam in rot benetetuḳ nebë ḳöḳ beto neluḳ ya dob. ");
INSERT INTO bzh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jom raḳ ggovek, log kedi raḳ beyah to vu yi hur maluh lo. Loḳ lë bë deneggëp yiing, in ayoj maggin rot. ");
INSERT INTO bzh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Lob nër vu sir bë, “Ham newëp in-a? Ham kwedi benġev jaḳ, in nġaa ti su kepë ham.” ");
INSERT INTO bzh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu nahën medo nevengwënġ, log alam yu böpata deverup. Mehö sën arë nebë Yudas sën sir nemadluho-bevidek-luu lo ti yi, rëḳ li sir medeyam. Lob verup sesor meya vu Yesu in bë gemul* yi. ");
INSERT INTO bzh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Loḳ Yesu nër vu yi bë, “Yudas, ġemul* Mehönon Nalu in bë ġetato yi ranġah-a?” ");
INSERT INTO bzh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesu yi hur maluh denare ving yi medelë nġaa sënë bë vonġin natöḳ vu yi, lob denër bë, “Mehöböp, he ngap sir jaḳ paggëpek-yu-anil-a?” ");
INSERT INTO bzh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Lob sir ti pevis mesis alam-deneḳo-seriveng hir ggev böp yi hur, besap nenga ris vahi vesa ya. ");
INSERT INTO bzh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Rëḳ Yesu nër bë, “Ggovek! Nġaa saga gëp!” Log bë nema raḳ mehö sënë nenga, lob nivesa raḳ yah ggökin. ");
INSERT INTO bzh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Log Yesu loḳ tepëḳ vu alam-deneḳo-seriveng hir ggev ga, dub-vabuung-böp ala lo, galam teta sën losho deyam in bë denajom yi ahon lo bë, “Maḳ ham yam in bë sero mehö-beġö-hodeḳ-yi ti om sën ham ḳo paëp-yu-anil los beġö meyam-ë? ");
INSERT INTO bzh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sa nado loḳ dub-vabuung-böp yoh vu buk ving ham, rëḳ ham su lah nemamin loḳ sa mejom sa ahon rë. Gaḳ buk sën gwëbeng agi, mëm ham buk. Om mala vahis niwëëk jaḳ na vavunë rot mekesuu.” ");
INSERT INTO bzh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nër ggovek log dejom yi ahon medeḳo medeya. Lob deḳo yi loḳ ya alam-deneḳo-seriveng hir ggev böp yi begganġ. Log Pita tamuin sir meneya, rëḳ nevun yi in sir meneyam ggëp ading. ");
INSERT INTO bzh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Log devev nengwah loḳ telig ggëp begganġ sënë yi tete ayo, bemedo denevenguh. Lob Pita verup ya nedo ving sir. ");
INSERT INTO bzh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Loḳ avëh ti lë bë medo nevenguh nengwah, lob tunġ mala raḳ yi genër bë, “Mehö sënë nedo ving Yesu ving.” ");
INSERT INTO bzh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Loḳ Pita lah yi vun bë, “Ma! Avëh, saḳ duġin yi.” ");
INSERT INTO bzh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Genedo teka loḳ mehö ngwë yah verup lë yi, lob nër bë, “Yiḳ sir sën lo ti sën honġ agi ving.” Rëḳ Pita nër yah bë, “Alam-e! Saḳ ma!” ");
INSERT INTO bzh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ggovek genedo hus ading rot yoh vu hes mala ti loḳ mehöti yah verup nër niwëëk bë, “Yönon rot, yiḳ mehö sagi sën nesepa yi ving. In yiḳ yi Galilea ti sënë!” ");
INSERT INTO bzh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Rëḳ Pita lah yi vun bë, “Alam-e! Sa duġin ġaġek ti sën ġenenër agi!” Nahën nenër nebë sënë, log pevis beḳöḳrëëh su. ");
INSERT INTO bzh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Lob Mehöböp ggërin yah melë Pita. Lob Pita kwa vo yah ġaġek sën Mehöböp nër vu yi vorot lo bë, “Pehi buk sënë og ḳöḳrëëh su rëḳ ngu rë, log rëḳ ġedah sa vun beron löö.” ");
INSERT INTO bzh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Lob Pita to meya dobnë, beyah su böpata rot. ");
INSERT INTO bzh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Alam sën denejom Yesu ahon lo denër pelë raḳ yi gedeveek yi. ");
INSERT INTO bzh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Debom mala loḳ tob, gedenesis yi, log deneloḳ tepëḳ vu yi bë, “Honġ mehö-nenër-ġaġek-ranġahsën-a? Om ġenanër nabë re sis honġ-a?” ");
INSERT INTO bzh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Log denenër ġaġek nipaya nġahiseḳë vahi raḳ yi ving. ");
INSERT INTO bzh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Heng to lob alam-deneḳo-seriveng hir ggev detu alam Israel hir kaunsor, belosho alam-horek-yi lo desupin sir, log deḳo Yesu yam nare malaj gedenër bë, ");
INSERT INTO bzh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ġenanër vu he nabë honġ Mehö sën Anutu ggooin raḳ in bë geḳo hil nah lo ma ma?” Loḳ nër yah vu sir bë, “Nabë sa nanër nök vu ham, og ham su rëḳ gwevonġ geving rë. ");
INSERT INTO bzh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Log bë sedoḳ tepëḳ in nök vu ham gökin, og ham su rëḳ nanër doḳ nom vu sa rë. ");
INSERT INTO bzh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Rëḳ mu pehi sënë, og Mehönon Nalu rëḳ medo gëp niwëëk ala Anutu nema vesa bemedo degwata.” ");
INSERT INTO bzh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Lob sir pin denër yah bë, “Om maḳ honġ sagaḳ Anutu Nalu honġ-a?” Loḳ nër yah vu sir bë, “Yiḳ saga. Ham voseḳ vorot.” ");
INSERT INTO bzh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Lob denër bë, “Hil rëḳ ġanġo ġaġek re gökin-a? Ġaġek sënë yö raḳ verup avi behil hanġo ggovek ya.” ");
INSERT INTO bzh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Lob sir pin dekedi bedeḳo yi ya vu Pilatus ");
INSERT INTO bzh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","gedevonġ ġaġek vu yi bë, “He halë mehö sënë bë neloḳ alam ahëj in dekedi medengis beġö medekepë gavman na. Genenërin he bë he su ġetë takës vu ham mehö-los-bengö Sisar*. Log nenër bë yiḳ yi Kerisi* sënë, beyi mehö-los-bengö.” ");
INSERT INTO bzh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Loḳ Pilatus loḳ tepëḳ vu yi bë, “Alam Yuda hir mehö-los-bengö honġ-a?” Loḳ nër yah vu Pilatus bë, “Ġenër ya meyoh vu.” ");
INSERT INTO bzh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Lob Pilatus nër ya vu alam-deneḳo-seriveng hir ggev losho alam pin bë, “Sa su töḳ vu ġaġek ti geneggëp vu mehö sënë rë.” ");
INSERT INTO bzh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Loḳ denër yah niwëëk bë, “Netateḳin ġaġek vu alam yoh vu distrik Yudea pin beneloḳ ahëj rot bë degevonġ beġö medekepë gavman na. Ḳo ġaġek sënë raḳ nyëdahis ggëp Galilea, lob nevonġ rot, gesën verup agi.” ");
INSERT INTO bzh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatus nġo hir ġaġek, lob loḳ tepëḳ yah vu sir bë, “Mehö sënëḳ yi Galilea ti?” ");
INSERT INTO bzh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Lob detateḳin vu yi meraḳ ni bë Yesu yam vu distrik Galilea sën Herot* neġin lo, lom vonġ yi ya vu Herot*. In Herot* verup nedo Yerusalem loḳ buk sënë ving. ");
INSERT INTO bzh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot* lë Yesu, lob kwa vesa rot, in nenġo Yesu bengö lob nevonġ rot bë gelë yi. Lob kwa vo bë maḳ Yesu rëḳ gevonġ nġaa böp ti begelë. ");
INSERT INTO bzh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nebë sënë lom Herot* neloḳ tepëḳ in yi hus ading. Rëḳ Yesu su nenër ġaġek ti yah vu yi rë. ");
INSERT INTO bzh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Lob alam-deneḳo-seriveng hir ggev losho alam-horek-yi deya dus medenër ġaġek niwëëk ya atata vu yi rot. ");
INSERT INTO bzh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Lob Herot* losho yi alam-beġö-yi devasap yi gedenër pelë raḳ yi. Log deḳo tob malanġeri ti bederöp loḳ yi, log devonġ yah meya vu Pilatus ggökin. ");
INSERT INTO bzh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Wirek og Herot* luho Pilatus denelë sir paya, rëḳ loḳ buk sënë, og luho desemu ġaġek medenelë sir nivesa. ");
INSERT INTO bzh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Lob Pilatus tahi alam-deneḳo-seriveng hir ggev losho alam teta, galam meris ving medesupin sir yam. ");
INSERT INTO bzh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Log nër vu sir bë, “Ham ḳo mehö sënë yam vu sa, log ham nër bë neloḳ alam ahëj in dekedi medengis beġö medekepë gavman na. Om ham gwenġo rë. Sa naloḳ tepëḳ in yi ġaġek sënë raḳ ham malamin niröp. Lob sa su töḳ vu bë vonġ nġaa ti paya loḳ ġaġek pin sën ham nër raḳ yi agi rë. ");
INSERT INTO bzh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Log Herot* ving nebë saga om sën vonġ yi yom vu hil ggökin. Ham lë! Mehö sënë su vonġ nġaa ti paya in bë hil angis yi menadiiḳ rë. ");
INSERT INTO bzh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Om maam sëḳ beek yi geġevonġ yi nah mena.” ");
INSERT INTO bzh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","In hir horek neggëp nebë Pilatus gevonġ alam ḳarabus ti ti vër doḳ buk vabuung sënë noh vu ta menah vu sir. ");
INSERT INTO bzh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Loḳ alam pin ayej loḳ ti medekeseh rur raḳ bë, “Ġengis mehö saga menadiiḳ gegwevonġ Barabas nom vu he.” ");
INSERT INTO bzh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas sënë vonġ beġö vu gavman loḳ nyëġ böp saga genesis alam medenediiḳ, lob deḳo yi ya nedo ḳarabus. ");
INSERT INTO bzh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Loḳ Pilatus loḳ tepëḳ yah vu sir ggökin, in kwa nevo bë dëëin Yesu mena. ");
INSERT INTO bzh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Rëḳ detahi yah bë, “Ġengis yi jaḳ na ḳelepeḳo*! Ġengis yi jaḳ na ḳelepeḳo*!” ");
INSERT INTO bzh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Loḳ yiḳ loḳ tepëḳ yah vu sir netu beron löö bë, “In va? Mehö sënë vonġ va paya? Sa su halë bë vonġ nġaa ti paya meneggëp vu yi in bë hil angis yi menadiiḳ rë. Om sebeek yi geġevonġ yi nah.” ");
INSERT INTO bzh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Rëḳ nij wëëk rot, gedetahi ya niwëëk ata bë ngis yi jaḳ na ḳelepeḳo*, bayej rehöö Pilatus aye. ");
INSERT INTO bzh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Lob Pilatus kwa vo bë maam gurek hir ġaġek babu. ");
INSERT INTO bzh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Lob lëëin mehö sën vonġ beġö vu gavman besis mehönon dediiḳ beya nedo ḳarabus lo yah vu sir in detahi arë. Log vo Yesu yah vu sir in bë dengis menadiiḳ yoh vu sën alam detahi lo. ");
INSERT INTO bzh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Deḳo Yesu raḳ medeya, log Simon vu Kurene nahën verup neya in bë doḳ na nyëġ böp Yerusalem. Lob dejom yi ahon gedebë ḳelepeḳo* raḳ ya baġë bekerë metamuin Yesu. ");
INSERT INTO bzh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Galam yu böpata denetamuin yi, gavëh nġahiseḳë denesu medenesis sir, gedenegelu tarot raḳ yi. ");
INSERT INTO bzh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Rëḳ Yesu ggërin yah menër vu sir bë, “Ham Yerusalem avëh, ham su ngu in sa, gaḳ mëm ham nġo ngu in ham los nalumin lo. ");
INSERT INTO bzh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","In buk vonġin berup lob rëḳ denanër nabë: ‘Avëh sën denare babuj seḳë lo, gavëh sën su naluj neloḳ rë lo, gavëh sën su denevo rur vu naluj rë lo, og kwaj vesa.’ ");
INSERT INTO bzh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","In doḳ buk saga, og ‘rëḳ denanër vu ḳedu nabë, “Ham kwepë ham menam jaḳ gwëp he!” Log rëḳ denanër vu ḳedu mahen mahen nabë, “Ham dahun he!” ’ ");
INSERT INTO bzh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","In nabë degevonġ nabë sënë vu ḳele nidun pehi sënë, og maḳ rëḳ degevonġ nabë va vu ḳele sën rëḳ denaboveng na lo?” ");
INSERT INTO bzh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Log deḳo alam sën denekeyëh horek lo luu ya in bë dengis luho geving Yesu. ");
INSERT INTO bzh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ya deverup nyëġ ti sën denenër arë nebë Nyëġ-yuseḳë lo lob desis yi raḳ ya ḳelepeḳo*. Log desis alam sën denekeyëh horek lo luu raḳ ḳelepeḳo* ving. Ngwë nare Yesu nema vesa, gengwë nare nema ḳëj. ");
INSERT INTO bzh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Lob Yesu nër bë, “Amaġ, ġedahun sir sën devasap sa lo hir nġaa nipaya sënë na. In su deraḳ ni bë denevonġ paya rë.” Ggovek log detë ġelönġ mahen teka la in bë gooin sir ti ti jaḳ medegeḳo yi tob. ");
INSERT INTO bzh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Log alam vare denelë. Rëḳ alam ggev denër pelë raḳ yi bë, “Neloḳ vu alam vahi. Om nabë Anutu yi Kerisi* yi yönon sën Anutu ggooin yi raḳ lo, og yö doḳ vu yi.” ");
INSERT INTO bzh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Galam-beġö-yi denenër pelë raḳ yi ving. Log deya dus in bë debo wain ahëggin sën arë nebë vinegga lo besesuvin. ");
INSERT INTO bzh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Log denër vu yi bë, “Nabë alam Yuda hir mehö-los-bengö honġ yönon, og nġo ġedoḳ vu honġ.” ");
INSERT INTO bzh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Log dekevu ġaġek ti raḳ neggëp ḳelepeḳo* yu nebë: ALAM YUDA HIR MEHÖ-LOS-BENGÖ MEHÖ SËNË. ");
INSERT INTO bzh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Log mehö luu sën desis luho raḳ ḳelepeḳo* ving lo ngwë nër Yesu bë, “Honġ Kerisi*? Og nġo ġedoḳ vu honġ, geġedoḳ vu aluu geving!” ");
INSERT INTO bzh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Rëḳ ngwë nġo ġaġek sënë, lob ggoo yi bë, “Yiḳ alöö hoho haḳo vanë neggëp ti, ma su genehöneng in Anutu rë? ");
INSERT INTO bzh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yönon, aluu og desis aluu loḳ yah nġaa nipaya sën alu hevonġ lo, om alu haḳo vanë beyoh vu. Gaḳ mehö sënëḳ su vonġ nġaa ti paya rë.” ");
INSERT INTO bzh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Log nër bë, “Yesu, ġenom los arëm böpata in gweġin mehönon, og kwam bo sa.” ");
INSERT INTO bzh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Lob Yesu nër yah vu yi bë, “Sa nanër vu honġ yönon nabë: Pehi sënë, rëḳ ġemedo geving sa gëp Paradis*.” ");
INSERT INTO bzh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Log hes vuheng raḳ, loḳ hes malaḳenu loḳ beyoh vu dob pin, beya meto 3 krök sehuksën. ");
INSERT INTO bzh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Lob tob böpata sën neruu dub-vabuung-böp ayo vabuung lo kweeḳ raḳ luu. ");
INSERT INTO bzh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Log Yesu nġeeḳ böpata bë, “Amaġ, sa nehevonġ anoġ neyök loḳ nemam.” Tahi nebë sënë, log diiḳ ya. ");
INSERT INTO bzh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Lob Rom hir alam-beġö-yi yu ti hir ala lë nġaa sënë, lob ḳo Anutu arë raḳ bë, “Yönon rot, mehö sënë yi mehö yohvu!” ");
INSERT INTO bzh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Log alam pin sën desup sir ya in bë degelë lo delë nġaa sënë, lob ayoj maggin gedesis sir gedeyah medeya bej. ");
INSERT INTO bzh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Log Yesu ni papu lo pin, gavëh sën sir vu Galilea medesepa Yesu medeyam lo yö denare ggëp ading teka medenelë nġaa pin sënë. ");
INSERT INTO bzh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Log mehöti arë nebë Yosep nedo. Yi vu Yuda hir nyëġ böp ti arë nebë Arimatea. Mehö sënë yi mehö nivesa geyi mehö yohvu, geyi kaunsor ving. ");
INSERT INTO bzh_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Rëḳ su nevo veyov in kaunsor vahi hir ġaġek sën denenër bë dengis Yesu lo rë. Gaḳ yö neġin buk sën Anutu natu ala begeġin sir lo benedo. ");
INSERT INTO bzh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Lob mehö sënë ya vu Pilatus meketaġ Yesu vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Log ya meruh Yesu nihel navi luḳ mebom loḳ tob veroo ti, log ya mebë loḳ waaḳ ti. Nahën denesap waaḳ sënë loḳ ġelönġ yö meris beneggëp mewis, gesu debë mehö ti loḳ rë. ");
INSERT INTO bzh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Buk sënëḳ buk sën denero sir in bë geheng geto log dega nos Buk-ggöksën-yi* lo, log hes neluḳ in bë govek na gedegök na Buk-sewahsën-yi*. ");
INSERT INTO bzh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Log avëh sën desepa Yesu ggëp Galilea medeyam lo, desepa Yosep medeya ving bedelë bedub sënë. Lob delë mederaḳ nyëġ len ti sën bë Yesu nihel meneggëp loḳ lo ni ving. ");
INSERT INTO bzh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Delë ggovek, log deyah medeya bedero marasin los wël, genġaa sën reggu nivesa vesa lo medenedo. Log Buk-sewahsën-yi* og desewah yoh vu sën horek nër lo. ");
INSERT INTO bzh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Log loḳ soda saga yi buk muġinsën monbuk anon lob avëh dekedi bedeḳo wël los nġaa reggu nivesa vesa sën dero menedo vorot lo medeya. ");
INSERT INTO bzh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Loḳ delë geġelönġ sën neggërin bedub avi lo tetolin meyö ya nare ya nenga. ");
INSERT INTO bzh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Lob deloḳ ya delë rëḳ Mehöböp Yesu nihel su neggëp rë. ");
INSERT INTO bzh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lob vare mekwaj neya nġahi in, medeneketul loḳ, loḳ mehö luu depevis beyam denare ving sir geluho hir tob nevër. ");
INSERT INTO bzh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Avëh delë, lob ḳenuj verup bedepetev bemalaj ya dob. Rëḳ luho denër vu sir bë, “Ham nesero mehö mala-tumsën sënë loḳ alam-diiḳsën hir nyëġ in va? Su nedo sënë rë. Gaḳ kedi raḳ meya gwëbeng! ");
INSERT INTO bzh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ham kwamin bo nah ġaġek sën nahën nedo ggëp distrik Galilea genër vu ham lo rë. ");
INSERT INTO bzh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nër vu ham bë debo Mehönon Nalu doḳ na alam nij paya nemaj bedengis yi na betii ḳelepeḳo*, log buk natu löö, lob rëḳ kedi jaḳ nah gökin.” ");
INSERT INTO bzh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Lob kwaj vo yah ġaġek sën Yesu nër wirek lo. ");
INSERT INTO bzh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Lob sir vu bedub bedeyah, beya denër nġaa pin sënë ranġah vu hur maluh nemadluho-bevidek-ti sën lo losho alam vahi pin. ");
INSERT INTO bzh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Yiḳ sir lo sënë: Maria vu Magdala ga, Yoana, geMaria sën Yakobus ata lo, gavëh vahi sën losho deya lo, bedenër ġaġek sënë vu sinarë nyëdahis lo. ");
INSERT INTO bzh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Rëḳ sinarë lo kwaj nevo bë yiḳ avëh om maḳ yö denenër ġaġek kuungsën mu, lob su devonġ ving ayej rë. ");
INSERT INTO bzh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Rëḳ Pita kedi seröġ meyah bedub beya meto nare gekeḳooin melë waaḳ ayo, rëḳ lë bë tob meris yö nedo. Lob yah meya rëḳ kwa neya nġahi in nġaa sënë rot. ");
INSERT INTO bzh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Loḳ yiḳ sir sënë luu medo denetetuu aggata loḳ yiḳ buk saga medeneya nyëġ mahen ti arë nebë Emaus. Aggata sën vu Yerusalem meneya Emaus lo, og yiḳ yoh vu kilomita nemadluho. ");
INSERT INTO bzh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Lob luho medo denetetuu aggata gedenevengwënġ raḳ nġaa pin sën lo. ");
INSERT INTO bzh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Luho denevengwënġ raḳ gedeneloḳ tepëḳ in sir gedeneya, lob Yesu verup ving luho, belööho deneya loḳ ti. ");
INSERT INTO bzh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Rëḳ luho su deraḳ ni bë Yesu rë. ");
INSERT INTO bzh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Lob loḳ tepëḳ vu luho bë, “Melu nevengwënġ raḳ va meneya?” Nër nebë sënë, lob luho denare gayoj maggin rot, gemalaj seluh. ");
INSERT INTO bzh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Loḳ ngwë sën arë nebë Kleopas loḳ tepëḳ yah bë, “Alam pin sën yam denedo Yerusalem lo deraḳ nġaa sën verup ggëp Yerusalem loḳ buk agi ni, gaḳ maḳ yiḳ nġo timu sënë sën honġ duġin-a?” ");
INSERT INTO bzh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Loḳ Yesu loḳ tepëḳ yah bë, “Va ti?” Loḳ luho denër yah vu bë, “Nġaa sën töḳ vu Yesu Nasaret lo. In nġaa sën nevonġ los nenër ggëp Anutu losho alam pin malaj lo netato bë yiḳ yi mehö-nenër-ġaġek-ranġahsën los arë böpata ti, in nevonġ nġaa pin los niwëëk. ");
INSERT INTO bzh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Lob hil alam-deneḳo-seriveng hir ggev lo, losho hil ggev pin devo yi loḳ ya alam Rom nemaj. Lob alam Rom denër ġaġek venuh bë nadiiḳ, lob desis yi raḳ ya ḳelepeḳo*. ");
INSERT INTO bzh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","He hekuung bë yi mehö sën rëḳ geḳo alam Israel vër in alam Rom nemaj lo. Kë’! Log ġaġek ngwë sënë: Nġaa pin sënë töḳ vu yi ngöp, log buk netu löö sën gwëbeng agi, ");
INSERT INTO bzh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","lob he sënagi avëh la ya delë medenër vu he lob he ḳenumin ya. In dekedi raḳ monbuk anon medeya bedub, ");
INSERT INTO bzh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","lob desero Yesu nihel, lob yom verup denër vu he bë delë angër la, lob angër denër vu sir bë Yesu nedo vesa. ");
INSERT INTO bzh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Lob he sënagi la deyah medeya bedub, loḳ delë nġaa yoh vu sën avëh denër lo. Gaḳ su detöḳ raḳ yi rë.” ");
INSERT INTO bzh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Lob Yesu nër vu luho bë, “Oo, melu kwamin ma! Melu su pasanġ nevonġ ving alam-denenër-ġaġek-ranġahsën hir ġaġek pin sën denenër lo rë. ");
INSERT INTO bzh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ma melu su raḳ ni bë Kerisi* og rëḳ geḳo vanë menadiiḳ, loḳ mëm vesa doḳ nah megeḳo arë böpata los vuneḳ vuneḳ yaġek yi rë?” ");
INSERT INTO bzh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Lob ḳo ġaġek raḳ loḳ Moses yi ġaġek los alam-denenër-ġaġek-ranġahsën pin hir ġaġek betateḳin ġaġek pin sën neraḳ yi meneggëp loḳ Anutu-yi-ḳapiya lo degwa vu luho. ");
INSERT INTO bzh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Lob deya rot beya deverup dus vu begganġ-bu ti sën luho deneya agi, lob Yesu vonġ in bë kesuu luho gena. ");
INSERT INTO bzh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Rëḳ luho denërin yi bë, “Ġemedo geving aluu in hes luḳ ya bevonġin ḳenu doḳ.” Lob loḳ ya nedo ving luho. ");
INSERT INTO bzh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ggovek gebë dega nos, lob Yesu nedo ving luho. Lob ḳo brët raḳ bejom raḳ ya vu Anutu los kwa vesa, log debu bevo vu luho. ");
INSERT INTO bzh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Vonġ nebë sënë, lob mëm luho malaj ranġah raḳ mederaḳ ni. Log mehor pevis geluho su delë yi ggökin rë. ");
INSERT INTO bzh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Lob luho yö yom denër vu sir bë, “Yönon, alöö medo nesepa hil menayam aggata, lob netateḳin Anutu-yi-ḳapiya degwa ranġah vu aluu, lob alu ayod tee yi in rot.” ");
INSERT INTO bzh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Lob luho pevis bedekedi loḳ buk bedeyah medeya Yerusalem ggökin. Luho yah to detöḳ vu sir nemadluho-bevidek-ti sën lo ving hir alam vahi, gedesupin sir medenedo. ");
INSERT INTO bzh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Lob denër vu luho bë, “Mehöböp kedi raḳ ggökin yönon beSimon lë yi ggovek ya!” ");
INSERT INTO bzh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nebë saga loḳ luho deturin nġaa pin sën töḳ vu luho loḳ aggata lo vu sir. Geluho denër bë deraḳ ni loḳ sën debu brët bevo vu luho lo. ");
INSERT INTO bzh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Medo denenër ġaġek sënë, log Yesu verup nare ranġah loḳ sir vuheng atov benër vu sir bë, “Ham ayomin gëp revuh.” ");
INSERT INTO bzh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lob deggöneng rot beḳenuj verup. In dekuung bë mehöti ḳenu nare ranġah vu sir. ");
INSERT INTO bzh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Loḳ nër vu sir bë, “Ham ḳenumin neverup in va? Geham kwamin neya nġahi in va? ");
INSERT INTO bzh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ham gwelë sa vahaġ los nemaġ sagi. Yiḳ sa sënë. Ham gwebë nemamin jaḳ sa geham gwelë. Gaḳ mehönon ḳenuj og nijreggos los nijpeḳooḳ nema, gaḳ su nebë sën ham lë sa agi rë. ");
INSERT INTO bzh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nër vu sir nebë sënë, log tato nema los vaha vu sir. ");
INSERT INTO bzh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Lob kwaj vesa rot, rëḳ mu yö denahën gesu devonġ ving rë, gaḳ kwaj neya nġahi. Lob nër vu sir bë, “Maḳ ham nos la neggëp-a?” ");
INSERT INTO bzh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Lob devo ġël sën devesi lo dus ti vu yi. ");
INSERT INTO bzh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Lob vo vër megga gedelë raḳ malaj. ");
INSERT INTO bzh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Lob nër vu sir bë, “Wirek sën sa nahën nado ving ham lo, log senër vu ham bë: Ġaġek pin sën dekevu raḳ sa meneggëp loḳ Moses yi horek, geneggëp loḳ alam-denenër-ġaġek-ranġahsën hir ḳapiya, geneggëp loḳ Saam lo, og ġaġek pin sënë rëḳ anon jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mëm tateḳin kwaj, lob deraḳ Anutu yi ġaġek sën neggëp loḳ ḳapiya lo degwa ni. ");
INSERT INTO bzh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Loḳ nër vu sir bë, “Dekevu ġaġek meneggëp loḳ Anutu-yi-ḳapiya bë: Kerisi* geḳo vanë, gebuk natu löö, lob kedi jaḳ nah gëp bedub. ");
INSERT INTO bzh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Lob rëḳ denanër arë gëp Yerusalem namuġin bena menoh vu dob pin, in mehönon degërin sir, lob Anutu dahun hir nġaa nipaya na. ");
INSERT INTO bzh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ham lë nġaa pin sënë raḳ malamin, om ham na nanër ranġah. ");
INSERT INTO bzh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Log sëḳ ġevonġ nġaa sën Amaġ nër bë rëḳ bo vu ham lo, nök vu ham. Om ham nġo naḳööḳ medo nyëġ sënë, rot bemëm niwëëk yaġek yi duḳ nam vu ham lom mëm.” ");
INSERT INTO bzh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Log li sir meya deverup Betania. Lob varah nema raḳ, gevenġev raḳ in sir bë Anutu geġin sir nivesa. ");
INSERT INTO bzh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nahën nejom raḳ in sir, lob vuu sir, gAnutu ḳo yi raḳ yah yaġek. ");
INSERT INTO bzh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Log deḳo arë raḳ gedeyah medeya Yerusalem los kwaj vesa rot. ");
INSERT INTO bzh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Lob denesupin sir loḳ dub-vabuung-böp raḳ buk pin bedeneḳo Anutu arë raḳ. ");
INSERT INTO bzh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Vu muġinsën Ġaġek nedo. Ġaġek nedo ving Anutu, lob Ġaġek yiḳ yi Anutu. ");
INSERT INTO bzh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Vu muġinsën rot Ġaġek yö nedo ving Anutu. ");
INSERT INTO bzh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yö tunġ nġaa pin. Genġaa ti su verup ggëp aggata ngwë rë. Ma. Nġaa pin sën anon raḳ menedo agi, og pum raḳ yi yö timu. ");
INSERT INTO bzh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mala-tumsën degwa neggëp vu yi, lob mala-tumsën saga sën mehönon hir Ranġah. ");
INSERT INTO bzh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lob Ranġah sënë netum raḳ malaḳenu, lob malaḳenu su yoh vu bë gërin rë. ");
INSERT INTO bzh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anutu vonġ mehöti arë nebë Jon yam. ");
INSERT INTO bzh_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yam in bë nanër ġaġek ranġah. Benanër ġaġek jaḳ Ranġah sënë in alam pin degenġo yi ġaġek bayoj na timu vu. ");
INSERT INTO bzh_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon saga og yi su Ranġah rë. Gaḳ yam in bë nanër ġaġek jaḳ Ranġah sënë mu. ");
INSERT INTO bzh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ranġah soġek sën netum raḳ mehönon pin lo yam dob. ");
INSERT INTO bzh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yi yö tunġ dob, rëḳ luḳ yam nedo dob, rëḳ mehönon vu dob su deraḳ ni rë. ");
INSERT INTO bzh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yam yi nyëġ, rëḳ yi alam su deḳo yi raḳ rë. ");
INSERT INTO bzh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gaḳ alam sën deneḳo yi raḳ bayoj neya timu vu yi lo, og nër sir bë detu Anutu nalu. ");
INSERT INTO bzh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Lob degwa sën detu Anutu nalu lo su neggëp vu amaj lu ataj nij ḳöḳ rë, gesu neggëp vu mehönon yö ayoj neggurekin sir rë, gesu neggëp vu mehönon yö kwaj bë denatu rë. Gaḳ degwa yö neggëp vu Anutu. ");
INSERT INTO bzh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lob Ġaġek sënë netu mehönon raḳ benedo ving hil, behe halë niwëëk los vuneḳ vuneḳ yaġek yi. Niwëëk los vuneḳ vuneḳ yaġek yi in yiḳ Ama Nalu timu, lob semusën degwa yi beyam los ġaġek anon pin. ");
INSERT INTO bzh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon nër yi ranġah genër bë. “Yiḳ mehö sënë sën senër vu ham wirek lo bë, ‘Mehö sën netamuin sa, og kesuu sa in yö nedo wirek, gaḳ saḳ nahën neverup.’” ");
INSERT INTO bzh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Hil pin haḳo nġaa nivesa vesa ggëp yiyi. Vonġ semusën sënë vu hil, geyiḳ vonġ semusën ggök ggökin rot vu hil. ");
INSERT INTO bzh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moses vo Anutu yi horek vu hil, rëḳ Yesu Kerisi vo semusën vu hil rot beyam los ġaġek anon pin. ");
INSERT INTO bzh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mehöti su mala raḳ Anutu rë. Yö ma rot. Yiḳ Anutu Nalu timu sënë, sën nedo loḳ Ama babu lo, om sën tateḳin Anutu yi degwa vu hil. ");
INSERT INTO bzh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Alam Yuda hir ggev devonġ alam-deneḳo-seriveng la ving alam Levi* la vu Yerusalem beya deloḳ tepëḳ in Jon bë, “Honġ re?” Lob Jon nër ġaġek ranġah nebë sënë. ");
INSERT INTO bzh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Su lah ġaġek vun rë, gaḳ nër ranġah bë, “Sa su Mehö sën Anutu ggooin raḳ in bë geḳo hil nah lo rë!” ");
INSERT INTO bzh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Loḳ deloḳ tepëḳ in yi ggökin bë, “Gaḳ honġ re? Maḳ honġ Elia ma re?” Rëḳ bë, “Ma!” Loḳ sireḳ deloḳ tepëḳ yah bë, “Maḳ honġ mehö-nenër-ġaġek-ranġahsën sën hil neheġin lo?” Rëḳ nër yah bë, “Ma!” ");
INSERT INTO bzh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nebë saga lom deloḳ tepëḳ bë, “Gaḳ honġ re? Ġenanër in he nah nanër vu alam sën devonġ he yam lo!” ");
INSERT INTO bzh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Loḳ Jon nër bë, “Sa mehö sën mehö-nenër-ġaġek-ranġahsën Yesaya nër ġaġek raḳ sa wirek lo nebë: ‘Mehöti aye neraḳ loḳ nyëġ-yumeris bë, “Ham bolinin Mehöböp yi aggata!” ’” ");
INSERT INTO bzh_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Alam Parisai* devonġ alam saga yam, ");
INSERT INTO bzh_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","lob deloḳ tepëḳ in yi bë, “Su honġ Kerisi* rë, gesu honġ Elia rë, gesu honġ mehö-nenër-ġaġek-ranġahsën sënë lo rë, loḳ nebë va sën ġeneripek alam-ë?” ");
INSERT INTO bzh_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Rëḳ Jon nër ġaġek yah vu sir bë, “Sa naripek alam raḳ bël. Gaḳ mehöti nare loḳ ham vuheng, geham su raḳ ni rë. ");
INSERT INTO bzh_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mehö saga sën rëḳ tamuin sa menam. Yi mehö nivesa kesuu sa, gesa mehö niġ paya besesu yohvu in bë natu yi hur meḳevelekin aggis in vaha suu rë.” ");
INSERT INTO bzh_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Denër ġaġek sënë vu Betania ggëp bël Yordan nenga vahi vu nyëġ sën Jon neripek alam lo. ");
INSERT INTO bzh_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Heng to lom Jon lë bë Yesu to neya lom nër bë, “Kë! Yi sën Anutu yi sipsip nalu sën rëḳ natu seriveng mekevoh alam dob pin hir nipaya na lo sagu. ");
INSERT INTO bzh_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yiḳ mehö saga sën sa nanër wirek lo bë, ‘Mehöti rëḳ nam tamuin sa, yi og kesuu sa in yö nedo muġin, gesaḳ ma!’ ");
INSERT INTO bzh_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Sa og su seraḳ ni rë. Rëḳ seyam ripek alam raḳ bël in bë mehö saga rëḳ natöḳ nam ranġah balam Israel dejaḳ ni.” ");
INSERT INTO bzh_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Lob Jon nër ggökin bë, “Sa halë Anon Vabuung vu yaġek geluḳ yam nebë soḳ nuung ti meyam nedo raḳ yi. ");
INSERT INTO bzh_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Sa og su seraḳ ni rë, rëḳ Mehö sën vonġ sa yam in bë sejipek alam jaḳ bël lo nër vu sa bë, ‘Gwelë nabë Anon Vabuung duḳ nam medo jaḳ mehöti, og mehö saga sën rëḳ getunġ Anon Vabuung jaḳ ham nabë sën nġo ġenetunġ bël raḳ sir lo.’ ");
INSERT INTO bzh_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Lob sa halë ggovek besenër ġaġek ranġah bë Anutu nalu yi saga.” ");
INSERT INTO bzh_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Loḳ monbuk lob Jon yah nare ggökin beyi hur maluh luu denare ving yi. ");
INSERT INTO bzh_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Loḳ Yesu to neya, lom mala sepa menër bë, “Kë! Anutu yi sipsip nalu yi sagu!” ");
INSERT INTO bzh_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Beyi hur maluh luu sënë denġo nebë sënë, lob ya detamuin Yesu. ");
INSERT INTO bzh_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Lob Yesu ggërin yom melë bë luho denetamuin yi lob nër vu luho bë, “Melu nesero va?” Rëḳ luho denër yah vu yi bë, “Rabai! (Sën hil ayed nebë Tatovaha). Böm tena?” ");
INSERT INTO bzh_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Rëḳ bë, “Melu nam rëḳ gwelë!” Lob luho ya delë begganġ sën neggëp loḳ lo. Yiḳ loḳ 10 krök monbuk, lob luho denedo ving yi loḳ buk saga. ");
INSERT INTO bzh_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Luho sën denġo Mehö-neripek-alam Jon aye meya detamuin Yesu lo ngwë Andreas sën Simon Pita ari. ");
INSERT INTO bzh_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Lom ya metöḳ vu ari Simon muġin menër vu yi bë, “He töḳ vu Mesia!” (Hil pekwë arë Mesia sënë doḳ nah Grik ayej nabë Kerisi*.) ");
INSERT INTO bzh_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Lob Andreas ḳo yi ya vu Yesu, lob Yesu mala nelë yi rëḳ bë, “Honġ Simon, Jon* nalu. Hil rëḳ nanër arëm nabë Kepas!” (Arë sënë degwa nebë Ġelönġ.) ");
INSERT INTO bzh_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Loḳ tum heng to lob Yesu bë na distrik Galilea. Lom töḳ vu Pilip benër vu yi bë, “Ġetamuin sa!” ");
INSERT INTO bzh_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip sënë yi Betsaida ti, yiḳ lööho Andreas lu Pita begganġ-bu timu. ");
INSERT INTO bzh_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Lob Pilip ya metöḳ vu Natanael, lom nër vu yi bë, “Mehö sën Moses kevu ġaġek raḳ loḳ horek wirek galam-denenër-ġaġek-ranġahsën dekevu ġaġek raḳ ving lo sën he töḳ raḳ ggovek ya. Yi Yesu Nasaret, Yosep nalu.” ");
INSERT INTO bzh_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Lob Natanael nër vu yi bë, “Maḳ nġaa nivesa ti rëḳ berup gëp Nasaret-a?” Rëḳ Pilip nër yah vu yi bë, “Ġenam rëḳ gwelë!” ");
INSERT INTO bzh_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu lë Natanael neyam vu yi, lom nër yi bë, “Ham gwelë! Israel anon soġek yi saga! Ġaġek kuungsën ti su neggëp vu yi rë!” ");
INSERT INTO bzh_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Loḳ Natanael loḳ tepëḳ vu yi bë, “Nebë va sën ġeraḳ sa niġ-ë?” Loḳ Yesu nër yah vu yi bë, “Pilip su tahi honġ rë genġo nahën ġëdo loḳ ḳele pik* degwa, log sa halë honġ muġin ggëp sagu.” ");
INSERT INTO bzh_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Lob Natanael nër yah vu bë, “Tatovaha! Anutu nalu honġ! Alam Israel hir Mehö-los-bengö honġ!” ");
INSERT INTO bzh_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Rëḳ Yesu nër yah vu bë, “Ġevonġ ving saga in senër vu honġ bë sa halë honġ loḳ ḳele pik* degwa? Nahub rë, lob rëḳ gwelë nġaa böpata rot kesuu sënë!” ");
INSERT INTO bzh_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Loḳ Yesu nër vu yi ggökin bë, “Sa nanër vu ham yönon nabë nahub rëḳ ham rëḳ gwelë yaġek rëḳ tateḳin yi geham gwelë Anutu yi angër dejaḳ gededuḳ vu Mehönon Nalu.” ");
INSERT INTO bzh_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Log buk netu löö lob mehöti ḳo venë ggëp Kana vu distrik Galilea, lom denegga nos böp geYesu ata nedo ving sir. ");
INSERT INTO bzh_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Log devonġ ġaġek yah in Yesu losho yi hurmaluh bedeyam ving. ");
INSERT INTO bzh_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Lob wain maya, lob Yesu ata nër vu yi bë, “Hej wain maya!” ");
INSERT INTO bzh_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Lom Yesu nër yah bë, “Ataġ! Alu su nemad loḳ ti in nġaa rë! In sa buk yö nahën!” ");
INSERT INTO bzh_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Rëḳ ata nër vu hur sën denevo nos ggelek lo bë, “Nabë nanër ġaġek ti vu ham, og ham gwevonġ noh vu!” ");
INSERT INTO bzh_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Lob dëg nemadvahi-bevidek-ti nedo in bë vatëveḳ dejipek nemaj doḳ noh vu sën alam Yuda hir ġaġek muġeng lo. Dëg sënë böpata beyoh vu bë hil ḳeseh bël ḳetuḳ nemadluho ma nemadluho-menemadvahi doḳ na ti ti. ");
INSERT INTO bzh_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Lob Yesu nër vu sir bë, “Ham gweḳo bël mekweseh doḳ na dëg sagu!” Lob deḳo meya dekeseh luḳ ya bepin pup. ");
INSERT INTO bzh_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Lob nër vu sir bë, “Mëm ham jeḳoov begweḳo mena vu mehö-neġin-nos!” ");
INSERT INTO bzh_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Lob deḳo medeya. Lob mehö-neġin-nos lo num bël menġo bë tu wain raḳ, rëḳ su raḳ ni bë deḳo vu tena rë. Gaḳ hur sën deneḳo bël lo mëm deraḳ ni. Lob mehö-neġin-nos tahi mehö sën ḳo avëh lo yam benër vu yi bë, ");
INSERT INTO bzh_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Alam pin og denevo wain nivesa ggelek muġin, balam denenum nġahiseḳë ggovek rë, loḳ denevo wain nipaya teka tamu. Gaḳ honġ og ġejom wain nivesa ahon bemëm nahën ġevo yam gwëbengko!” ");
INSERT INTO bzh_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu vonġ yi nġaa böp nyëmuġinsën sënë ggëp Kana vu distrik Galilea. Tato niwëëk vu sir nebë sënë, lob yi hur maluh ayoj neya timu vu yi. ");
INSERT INTO bzh_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Saga ggovek log Yesu luḳ meyah Kapernaum ving ata gari lo, geyi hur maluh lo. Beya denedo buk la ggëp sagu. ");
INSERT INTO bzh_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yuda hir Buk-ggöksën-yi* dus raḳ, lob Yesu raḳ meya Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lom töḳ raḳ alam sën denedo loḳ dub-vabuung-böp ḳatum ayo medenetunġ burmakau los sipsip gesoḳ nuung in bë alam debaġo lo. Gelë alam sën denepekwë* alam Yuda hir monë loḳ yah alam Rom hir monë lo denedo hir tevor medenevonġ huk. ");
INSERT INTO bzh_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Lob ḳo aggis bejoo tu beġö betii mehönon ving sipsip los burmakau pin vu dub ayo beto deyah dobnë. Gekeseh alam sën denepekwë* monë lo, hir monë los tevor ya. ");
INSERT INTO bzh_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Log nër vu alam sën denevonġ huk baġosën raḳ soḳ lo bë, “Ham gweḳo nġaa saga mena! Ham su gwevonġ Amaġ yi begganġ sënë natu nyëġ-baġosën-yi.” ");
INSERT INTO bzh_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Lob yi hur maluh kwaj vo yah ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo nebë: “Sa nehevonġ niwëëk in bë ġevonġ honġ begganġ gëp nivesa.” ");
INSERT INTO bzh_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Rëḳ alam Yuda delë sënë lom deloḳ tepëḳ in yi bë, “Ġetii he, om rëḳ ġetateḳin honġ jaḳ nġaa böp tena in he jaḳ nim nabë honġ mehö-los-arëm-a?” ");
INSERT INTO bzh_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Rëḳ Yesu nër yah vu sir bë, “Ham rëḳ kwevoh dub vabuung sënë na, gebuk natu löö rëḳ sedev nah gökin!” ");
INSERT INTO bzh_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Lob alam Yuda denër bë, “Denelev dub-vabuung-böp sënë yoh vu ta mehödahis luu menenadvahi-videk-ti, log ġekuung bë ġedev jaḳ nah noh vu buk löö mu?” ");
INSERT INTO bzh_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Rëḳ dub sën Yesu nër lo, saga yö nër raḳ navi. ");
INSERT INTO bzh_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nebë saga, loḳ nahub geYesu kedi raḳ yah vu bedub rë, lob yi hur maluh kwaj nevo yah yi ġaġek sën nër wirek lo, lom devonġ ving ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo los ġaġek sën Yesu nër lo. ");
INSERT INTO bzh_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu nedo Yerusalem loḳ Buk-ggöksën-yi*, lob alam nġahiseḳë delë nġaa böp sën nevonġ lo, lom ayoj ya timu vu yi. ");
INSERT INTO bzh_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Rëḳ mu Yesu raḳ sir pin ayoj ni om su vonġ yi loḳ ya nemaj rë. ");
INSERT INTO bzh_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","In raḳ alam pin ayoj ni. Mehöti su yoh vu bë nanër mehö ngwë ayo vu yi rë, gaḳ neraḳ mehönon pin ayoj ni ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisai* ti nedo, arë nebë Nikodemus, balam Yuda hir ggev ti. ");
INSERT INTO bzh_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mehö sënë yam vu Yesu buk benër vu yi bë, “Tatovaha! He raḳ nim bë honġ tatovaha ti, bAnutu vonġ honġ yam. Bë Anutu su medo geving mehöti rë, og su yoh vu bë rëḳ gevonġ nġaa böp böp nabë sën ġenevonġ-ë rë.” ");
INSERT INTO bzh_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Rëḳ Yesu nër yah vu yi bë, “Sa nanër vu honġ yönon nabë: Mehöti bë su natu mewis gökin nah rë, og su rëḳ doḳ na Anutu-yi-nyëġ rë.” ");
INSERT INTO bzh_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Lom Nikodemus loḳ tepëḳ yah vu yi bë, “Alam atov rëḳ natu mewis nah nabë va? Maḳ yoh vu bë rëḳ doḳ nah atayo megeḳo yi nom-a?” ");
INSERT INTO bzh_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Rëḳ Yesu nër yah vu bë, “Sa nanër vu honġ yönon nabë: Bë mehönon su denatu mewis jaḳ bël los Anon Vabuung rë, og su deyoh vu bë rëḳ dedoḳ na Anutu-yi-nyëġ rë. ");
INSERT INTO bzh_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nġaa navim yi, og sagaḳ navim yö yi. Gaḳ nġaa sën anom yi, og sagaḳ anom yö yi nġaa. ");
INSERT INTO bzh_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Su kwam na nġahiseḳë in sën senër vu honġ bë ġenatu mewis gökin-ë! ");
INSERT INTO bzh_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Gaḳ kwam bo sanġ rë. Sanġ yö neya jeggin jeggin benevë ya ya. Ġenġo dedun rëḳ su ġeraḳ ni bë ya neverup tena ma ya neyoh tena rë. Og alam pin sën detu mewis raḳ Anon Vabuung lo, sir nebë sënë.” ");
INSERT INTO bzh_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Loḳ Nikodemus loḳ tepëḳ yah vu yi bë, “Nġaa sënë rëḳ anon jaḳ nabë va?” ");
INSERT INTO bzh_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Rëḳ Yesu nër bë, “Alam Israel hir tatovaha ti honġ rëḳ su ġeraḳ nġaa sënë ni rë? ");
INSERT INTO bzh_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sa nanër vu honġ yönon nabë: Nġaa sën he naraḳ ni lo sën he nanër. Gehe nanër nġaa sën he nehalë ggovek lo. Rëḳ ham neruu demimin vu ġaġek sën he nanër lo. ");
INSERT INTO bzh_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Sa nanër nġaa-dob-yi vu ham, rëḳ ham su nevonġ ving rë. Om nabë sa nanër nġaa-yaġek-yi vu ham, og ham rëḳ gwevonġ geving nabë va? ");
INSERT INTO bzh_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mehönon ti su raḳ ya melë yaġek rë, gema. Yiḳ Mehönon Nalu yö timu vu yaġek meluḳ yam. ");
INSERT INTO bzh_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Wirek Moses varah nyël ḳenu raḳ nare ḳele vu nyëġ-yumeris, lob rëḳ debarah Mehönon Nalu jaḳ nabë saga, ");
INSERT INTO bzh_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","in alam pin sën ayoj na timu vu yi lo demedo malaj-tumsën degwata los degwata. ");
INSERT INTO bzh_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","In Anutu kwa pesivin mehönon rot, lob vonġ nalu perurek timu sënë yam dob in bë alam sën ayoj na timu vu yi lo su malaj nama. Gaḳ demedo malaj-tumsën degwata. ");
INSERT INTO bzh_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anutu su vonġ Nalu yam dob in bë bo nyëvewen doḳ nah mehönon hir nġaa nipaya rë. Gaḳ vonġ yi yam in bë geḳo sir nah vu yi. ");
INSERT INTO bzh_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mehönon sën ayoj neya timu vu yi lo su rëḳ degeḳo nyëvewen rë. Gaḳ mehönon sën su ayoj neya timu vu yi rë lo, og Anutu nër vorot bë rëḳ degeḳo nyëvewen doḳ nah hir nġaa nipaya, in su ayoj neya timu vu Anutu Nalu timu sënë rë. ");
INSERT INTO bzh_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ranġah yam dob ggovek, rëḳ mehönon ahëj ving malaḳenu. Su ahëj ving ranġah rë, in hir huk nipaya, om rëḳ degeḳo nyëvewen doḳ nah. ");
INSERT INTO bzh_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Alam pin sën denevonġ nġaa nipaya lo, og denesis beġö vu Ranġah gesu detöḳ yam vu rë, in nij nelël bë su hir nġaa nipaya natöḳ ranġah. ");
INSERT INTO bzh_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gaḳ mehönon sën denesepa loḳ nġaa nivesa lo, og detöḳ yam ranġah, in bë mehönon degelë medejaḳ ni nabë denevonġ hir huk raḳ Anutu niwëëk.” ");
INSERT INTO bzh_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sënë ggovek ya, log Yesu losho yi hur maluh deyah distrik Yudea belosho ya denedo sagu, beneripek alam. ");
INSERT INTO bzh_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","GeJon neripek alam vahi ving ggëp Ainon, dus vu Salim. In bël nġahiseḳë neggëp vu nyëġ sagu, lob alam deneya vu yi beneripek sir. ");
INSERT INTO bzh_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Vu buk saga su deduu Jon ya ḳarabus rë geyö nahën. ");
INSERT INTO bzh_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Lob ġaġek ti verup vuheng loḳ Jon yi hur maluh losho Yuda ti, lob demehoo sir in ġaġek sën alam nij veseek jaḳ lo. ");
INSERT INTO bzh_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Lob Jon yi hur maluh ahëj sengën medeya vu Jon bedenër bë, “Tatovaha! Mehö sën nedo ving honġ wirek vu bël Yordan nenga vahi agu, beġenenër ġaġek raḳ yi lo, neripek alam lob alam pin deneya vu yi!” ");
INSERT INTO bzh_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Rëḳ Jon tateḳin vu sir bë, “Bë Anutu vu yaġek su bo nġaa ti vu mehöti rë, og su rëḳ gevonġ rë. ");
INSERT INTO bzh_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ham nġo nenġo ġaġek sën senër wirek lo bë sa su Kerisi* rë, rëḳ Anutu vonġ sa yam muġin. ");
INSERT INTO bzh_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bë avëh ti jaḳ maluh, og avëh saga tu maluh sën raḳ vu yi lo yö timu venë. Lob bë regga sënë yi mehöti medo geving yi begenġo aye, og su rëḳ gelë avëh regga paya rë, gaḳ rëḳ kwa vesa rot in yi. Lom gwëbeng sa kwaġ vesa rot nebë saga. ");
INSERT INTO bzh_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Arë rëḳ böp jaḳ, gesarëġ gëp ahu. ");
INSERT INTO bzh_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mehö sën yam vu vavunë kesuu nġaa pin. Mehö sën ata ḳo yi vu dob lo, og yi vu dob, beyö nër ġaġek raḳ nġaa-dob-yi mu. Gaḳ mehö sën yam vu yaġek lo, og kesuu nġaa pin. ");
INSERT INTO bzh_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mehö saga nër ġaġek raḳ nġaa sën lë los nġo ggovek lo, rëḳ su mehöti vonġ ving yi ġaġek saga rë. ");
INSERT INTO bzh_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Gaḳ bë mehöti gevonġ geving yi ġaġek, og yiḳ yoġekin Anutu nebë saga nebë yi mehö ġaġek anon degwa. ");
INSERT INTO bzh_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mehö sën Anutu vonġ yi yam lo, og nenër Anutu yi ġaġek, in Anutu vonġ yi Anon Vabuung los dahis loḳ yam ggërin ayo. ");
INSERT INTO bzh_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ama ahë ving Nalu, bevo nġaa pin loḳ ya nema. ");
INSERT INTO bzh_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mehönon sën ayoj na timu vu Anutu Nalu lo, og rëḳ demedo malaj-tumsën degwata los degwata. Gaḳ mehönon sën su desepa doḳ Anutu Nalu aye rë lo, og su rëḳ demedo malaj-tumsën rë. Gaḳ Anutu ahë sengën neggëp vu sir.” ");
INSERT INTO bzh_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesu nġo bë alam Parisai* deraḳ ni bë neripek hur maluh nġahiseḳë kesuu Jon. ");
INSERT INTO bzh_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Rëḳ Yesu su neripek sir rë, gaḳ yi hur maluh mu sën deneripek.) ");
INSERT INTO bzh_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nġo nebë saga lom vuu distrik Yudea geyah meya distrik Galilea ggökin. ");
INSERT INTO bzh_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Lob aggata sën yoh meya lo, og yoh ya distrik Samaria vuheng meya. ");
INSERT INTO bzh_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Lob ya metöḳ ya Samaria nyëġ böp ti arë nebë Sukar, dus vu dob len ti sën wirek Yakop vo vu nalu Yosep lo. ");
INSERT INTO bzh_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Lob asoreng sën wirek Yakop lev medeneḳo bël loḳ lo neggëp dus vu nyëġ saga. Yesu yoh meya verup, lom vaha ma beto nedo dus vu asoreng-bël-yi sënë avi. Raḳ siks krök sehuksën. ");
INSERT INTO bzh_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Lom Samaria* avëh ti verup in bë geḳo bël, lob Yesu nër vu yi bë, “Bël nam sa nanum!” ");
INSERT INTO bzh_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","In yi hur maluh deya nyëġ böp Sukar in bë debaġo nos. ");
INSERT INTO bzh_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Rëḳ Samaria* avëh nër yah vu bë, “Honġ Yuda, gesa Samaria* avëh, rëḳ nebë va sën ġenër vu sa bë ‘Bël nam sa nanum’—ë?” Nër nebë sënë in alam Yuda denelë alam Samaria* paya besu denevengwënġ vu sir rë. ");
INSERT INTO bzh_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Loḳ Yesu nër yah vu yi bë, “Bë ġejaḳ nġaa sën Anutu vonġ vu honġ ni, beġejaḳ mehöti sën nër vu honġ bë ‘Bël nam sa nanum’ ni, og rëḳ kwetaġ vu yi lob bo bël-mala-tumsën-yi vu honġ.” ");
INSERT INTO bzh_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Rëḳ avëh nër yah vu yi bë, “Mehöböp, höm ḳetuḳ ma, log asoreng-bël-yi sënë adingseḳë rot, om rëḳ gweḳo bël-mala-tumsën-yi sënë vu tena? ");
INSERT INTO bzh_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Hil ḳenud Yakop num bël sënë ving nalu lo wirek, geyi reggu lo denum ving, log vo asoreng-bël-yi ti sënë vu he behe nanum. Rëḳ maḳ ġekuung bë ġekwesuu yi?” ");
INSERT INTO bzh_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Rëḳ Yesu nër yah bë, “Alam pin sën denenum bël sënë rëḳ ayoj bev nah gökin in bël. ");
INSERT INTO bzh_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Gaḳ mehöti bë nanum bël sën sebo vu yi lo, og rëḳ nabë sën bël nebenguv loḳ yi. Log bël sënë rëḳ berup jaḳ buk, bebo mala-tumsën vu yi bemedo degwata los degwata.” ");
INSERT INTO bzh_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Lom avëh nër bë, “Mehöböp, ġebo bël sënë vu sa in sa su ayoġ bev in bël, gesa su medo menom ġaḳo bël vu sënë gök gökin!” ");
INSERT INTO bzh_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Loḳ Yesu nër vu yi bë, “Ġena ġetahi reggam bemelu nom sënë rë!” ");
INSERT INTO bzh_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Rëḳ bë, “Sa reggaġ ma!” Lom Yesu nër yah vu bë, “Ġenër bë reggam ma, saga ġenër yönon rot. ");
INSERT INTO bzh_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","In wirek ġeraḳ maluh nemadvahi. Gaḳ mehö sën ġenewëp ving yi loḳ yi begganġ gwëbeng lo, og sagaḳ su reggam anon rë! Om ġenër yönon!” ");
INSERT INTO bzh_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Rëḳ avëh nër bë, “Mehöböp, gwëbeng seraḳ ni bë mehö-nenër-ġaġek-ranġahsën ti honġ! ");
INSERT INTO bzh_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","He ḳenumin lo denesupin sir vu ḳedu Gerisim sënë medenejom raḳ vu Anutu, rëḳ ham Yuda nenër bë hil najom jaḳ gëp Yerusalem yö timu.” ");
INSERT INTO bzh_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Lom Yesu nër vu yi bë, “Avëh, gwevonġ geving sa ġaġek nabë buk ti vonġin berup, lob ham su rëḳ najom jaḳ vu hil Amad vu ḳedu sënë rë, beham su rëḳ najom jaḳ gëp Yerusalem yö timu geving rë. ");
INSERT INTO bzh_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ham nejom raḳ vu nġaa sën ham duġin lo, rëḳ he og he najom raḳ vu nġaa sën he naraḳ ni lo. In mehö sën rëḳ geḳo mehönon nah vu Anutu lo rëḳ berup gëp Yuda. ");
INSERT INTO bzh_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lob buk sën Anutu ggooin raḳ bë berup lo vonġin berup. Yönon, lob verup ggovek ya, om doḳ buk sënë og alam pin sën degevonġin nabë denajom jaḳ yönon lo, og rëḳ degetunġ ḳenuj los dahis vu hil Amad medenajom jaḳ los ayoj timu. Kë’, hil Amad Anutu nesero alam nebë saga in bë denadudeḳ vu yi. ");
INSERT INTO bzh_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anutu yiḳ nebë Anon Vabuung. Om nabë alam degeḳo yi jaḳ, og degetunġ ḳenuj los dahis vu yi, medenajom jaḳ los ayoj timu.” ");
INSERT INTO bzh_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Rëḳ avëh nër bë, “Seraḳ ni bë Mesia rëḳ nam. Sën denenër yi bë Mehö sën Anutu ggooin raḳ in bë geḳo hil nah lo. Bë nam, og rëḳ nanër nġaa pin degwa ranġah vu hil.” ");
INSERT INTO bzh_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Lom Yesu nër vu yi bë, “Yiḳ sa lo sën sa nevengwënġ ving honġ agi!” ");
INSERT INTO bzh_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nenër nebë saga log yi hur maluh yom deverup. Lob kwaj ya nġahi in nevengwënġ ving avëh nyëġ ngwë ti sënë, rëḳ mehöti su loḳ tepëḳ in luho bë, “Bë bo va vu honġ-a?”, ma, “Nebë va sën genevengwënġ ving avëh-ë?” rë. ");
INSERT INTO bzh_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Lob avëh sënë vuu yi ḳetuḳ menedo, geyah meya begganġnë beyah nër vu yi alam bë, ");
INSERT INTO bzh_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ham nam gwelë mehöti! Yi sënë og nër nġaa pin sën sa nehevonġ wirek lo ranġah vu sa. Maḳ yi Kerisi* ma va?” ");
INSERT INTO bzh_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Lob to deya medeya vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nahën medo deneyam, log yi hur maluh denenër vu yi bë, “Tatovaha, ġegwa nos rë!” ");
INSERT INTO bzh_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Rëḳ nër yah vu sir bë, “Sa nos sën sa naha lo nedo, geham su raḳ ni rë.” ");
INSERT INTO bzh_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Lom yi hur maluh lo yö deloḳ tepëḳ vu sir bë, “Maḳ mehöti ḳo nos yam vu yi?” ");
INSERT INTO bzh_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Rëḳ Yesu nër bë, “Sa nos nebë sënë: Sa bë sepa doḳ yi sën vonġ sa meseyam lo yi ġaġek. Besa bë semu yi huk begovek na. Ham nenër nebë sënë, ‘Kwev lubeluu govek na log nos nabunġ!’, rëḳ sa nanër vu ham nabë ham malamin jaḳ megeḳo doḳ megwelë huk rë. Nos anon loḳ beveroo raḳ beyoh vu bë hil ḳetöv bangupin. ");
INSERT INTO bzh_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mehö sën nevo nos lo neḳo yi nyëvewen raḳ yi huk menedo, genesupin nos sën gwëbeng agi in medo mala-tumsën degwata los degwata, lob rëḳ mehö sën nevaroh nos lo gemehö sën nevo nos anon lo, luhoho rëḳ kwaj vesa doḳ ti. ");
INSERT INTO bzh_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Wirek alam hib denenër nebë, ‘Mehö ngwë nevaroh nos loḳ huk gengwë neḳo anon.’ ");
INSERT INTO bzh_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ġaġek saga yönon, om sën sa hevonġ ham ya in bë ham gweḳo nos anon doḳ huk sën ham su vonġ huk in rë lo. ");
INSERT INTO bzh_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Alam ngwë yö devonġ huk in huk saga, rëḳ ham na gweḳo nos anon sën devonġ huk in bepum raḳ nemaj lo.” ");
INSERT INTO bzh_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Lob Samaria* nġahiseḳë vu nyëġ saga denġo avëh sënë yi ġaġek, lom ayoj ya timu vu Yesu. In avëh sënë nër bë, “Nër nġaa pin sën sa hevonġ wirek lo ranġah vu sa!” ");
INSERT INTO bzh_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Lob alam Samaria* deyam vu yi bedeketaġ bë medo geving sir, lob nedo saga buk luu ving sir. ");
INSERT INTO bzh_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Lob alam vahi denġo yi ġaġek besir nġahiseḳë ayoj ya timu vu yi ving. ");
INSERT INTO bzh_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Lob denër vu avëh sënë bë, “Gwëbeng he su ayomin neya timu vu yi raḳ honġ ġaġek rë, gaḳ he nġo hanġo yi ġaġek behe raḳ ni bë yiḳ Mehö sënë, sën yam in bë doḳ vu mehönon megeḳo sir nah vu Anutu lo yönon.” ");
INSERT INTO bzh_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Buk luu saga ggovek ya, lob Yesu vuu nyëġ sënë ya geyah meya distrik Galilea. ");
INSERT INTO bzh_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","In Yesu yö nër ġaġek vorot bë, “Su rëḳ degeḳo mehö-nenër-ġaġek-ranġahsën ti arë jaḳ gëp yö yi begganġ degwa rë!” ");
INSERT INTO bzh_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Loḳ ya metöḳ ya distrik Galilea, lob alam Galilea kwaj vesa in ya vu sir, in ya delë buk-vabuung-ggöksën-yi ving, lom delë nġaa pin sën vonġ vu Yerusalem lo. ");
INSERT INTO bzh_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Log yah meya verup Kana vu distrik Galilea ggökin,—nyëġ sën vonġ bël tu wain lo. Lom mehö-los-bengö Herot* yi ggev ti nedo Kapernaum, lob nalu maluh niraḳ. ");
INSERT INTO bzh_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mehö sënë nġo ġaġek bë Yesu vu distrik Yudea meyah verup distrik Galilea, lom ya ketaġ vu yi bë duḳ mena gevonġ benalu nivesa jaḳ, in dus raḳ bë nadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Loḳ Yesu nër yah vu yi bë, “Bë ham su gwelë nġaa böp aggagga rë, og ham su rëḳ gwevonġ geving rë!” ");
INSERT INTO bzh_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Rëḳ mehö-los-bengö yi ggev nër bë, “Mehöböp, ġenam alu aduḳ manah pevis in sa naluġ vonġin nadiiḳ!” ");
INSERT INTO bzh_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Rëḳ Yesu nër vu yi bë, “Ġenah meġena! Nalum rëḳ vesa doḳ.” Lob mehö sënë vonġ ving Yesu yi ġaġek meyah. ");
INSERT INTO bzh_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nahën neyök aggata log yi hur detöḳ verup vu yi bedenër vu yi bë, “Nalum vesa lok!” ");
INSERT INTO bzh_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Lob loḳ tepëḳ vu sir bë, “Hes mala va lom vesa loḳ-a?” Rëḳ denër bë, “Nikul veseveng loḳ seven krök buk.” ");
INSERT INTO bzh_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lom ama raḳ ni bë yiḳ veseveng raḳ hes mala sën Yesu nër vu yi bë nalu rëḳ vesa doḳ lo. Lom losho yi alam pin ayoj ya timu vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu vu distrik Yudea meyah verup distrik Galilea lo, lob vonġ nġaa böp sënë netu luu. ");
INSERT INTO bzh_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Saga ggovek, log Yuda hir buk vabuung ti verup, lob Yesu raḳ meya Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Lob nġaggee mahen teka nedo Yerusalem dus vu sipsip hir aggata avi. Denenër arë loḳ Hibru ayej nebë Betesda. Log delev begganġ ti ggërin nġaggee sënë, geyi nyëḳetu los veluung avi nemadvahi. ");
INSERT INTO bzh_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Lob alam niraḳsën nġahiseḳë losho alam malaj ḳenod los vahaj nipaya, galam sën seḳëj neselönġin lo deneloḳ ya begganġ-ayööng-yi teka sënë beggëp deneġin nġaggee sënë sën bë gee lo. ");
INSERT INTO bzh_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","In Mehöböp yi angër ti neluḳ ya nġaggee sënë buk ti ti meneggee loḳ. Lob ggeesën nemaya log mehöti sën pevis meduḳ na namuġin lo, og yi niraḳsën rëḳ nama na pevis. ");
INSERT INTO bzh_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Lob mehöti nedo loḳ begganġ-ayööng-yi sënë, niraḳ yoh vu ta mehödahis ti benemadluho benemadvahi bevidek löö (38). ");
INSERT INTO bzh_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu lë mehö sënë neggëp lom raḳ ni bë niraḳ hus ading rot, lom loḳ tepëḳ vu yi bë, “Ġevonġin bë nim vesa jaḳ-a?” ");
INSERT INTO bzh_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Lob mehö niraḳsën nër yah vu bë, “Mehö böp, buk sën nġaggee neggee lo, lom sehöġ mehönon sën geḳo sa mena getunġ duḳ na nġaggee lo ma! Senġo bë rëḳ duḳ na, loḳ sa nahën navimengin log denemuġin medeneluḳ ya in sa.” ");
INSERT INTO bzh_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Lob Yesu nër vu yi bë, “Om kwedi ġebare begweḳo honġ ḳanyë jaḳ beġena!” ");
INSERT INTO bzh_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lom pevis bemehö sënë nivesa raḳ geḳo yi ḳanyë raḳ beya. Gebuk saga og Buk-sewahsën-yi* ti. ");
INSERT INTO bzh_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Lom alam Yuda denër vu mehö sën nivesa raḳ lo bë, “Buk-sewahsën-yi* gwëbeng sënë, behorek nërin bë su gweḳo honġ ḳanyë dok!” ");
INSERT INTO bzh_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Rëḳ nër yah vu sir bë, “Mehö sën vonġ sa mesa niġ vesa raḳ lo nër vu sa bë, ‘Gweḳo honġ ḳanyë jaḳ meġena!’” ");
INSERT INTO bzh_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Loḳ deloḳ tepëḳ in yi bë, “Mehö re nër vu honġ bë gweḳo honġ ḳanyë jaḳ meġena?” ");
INSERT INTO bzh_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Rëḳ mehö sën nivesa raḳ lo duġin, in alam nġahiseḳë vu nyëġ saga lob Yesu loḳ ya sir vuheng. ");
INSERT INTO bzh_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nahub rëḳ Yesu töḳ vu yi ggökin loḳ dub-vabuung-böp ḳatum ayo lob nër vu yi bë, “Gwenġo? Gwëbeng nim vesa raḳ, om su gwevonġ nġaa nipaya gök nahin, in rëḳ maggin böpata natöḳ vu honġ kesuu muġinsën.” ");
INSERT INTO bzh_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Lob mehö sënë yah nër vu alam Yuda bë, “Mehö sën vonġ besa niġ vesa raḳ lo, yiḳ Yesu.” ");
INSERT INTO bzh_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Lob yiḳ alam Yuda ahëj sengën vu Yesu medenelë yi paya in nevonġ nġaa nebë sënë loḳ Buk-sewahsën-yi*. ");
INSERT INTO bzh_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Rëḳ Yesu nër yah vu sir bë, “Amaġ nevonġ nġaa nebë sënë yoh vu buk pin, om sën sa nesepa loḳ yah vaha.” ");
INSERT INTO bzh_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nebë saga lom alam Yuda devonġ raḳ raḳ rot in bë dengis Yesu menadiiḳ. In su keyëh horek Buk-sewahsën-yi* mu rë, gaḳ nër bë Ama Anutu yönon. Lob yiḳ sënë nebë luho Anutu neggëp ti. ");
INSERT INTO bzh_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Lob Yesu nër yah vu sir bë, “Sa nanër vu ham yönon nabë: Nalu su rëḳ gevonġ nġaa ti noh vu yö kwa rë. Gaḳ nevonġ nġaa sën nelë gAma nevonġ lo. Nġaa pin sën Ama nevonġ lo, og Nalu nesepa loḳ menevonġ nebë saga ving. ");
INSERT INTO bzh_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","In Ama ahë ving Nalu rot, lob tato nġaa pin sën nevonġ lo vu yi. Gerëḳ tato huk böp la geving kesuu sënë, lob ham rëḳ ḳenumin na. ");
INSERT INTO bzh_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ama nenër balam-diiḳsën denekedi raḳ yah genevonġ medenedo malaj-tumsën. Log Nalu nesepa loḳ meneggooin alam raḳ yoh vu yö kwa, in bë demedo malaj-tumsën nabë saga. ");
INSERT INTO bzh_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ama su rëḳ genġo mehöti yi ġaġek degwa rë. Gaḳ vo huk saga pin loḳ yah Nalu nema ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nebë saga in alam pin rëḳ degeḳo Nalu jaḳ, nabë sën deneḳo Ama raḳ lo. Alam sën su deneḳo Nalu raḳ rë lo, og su deneḳo Ama sën vonġ yi yam lo raḳ ving rë. ");
INSERT INTO bzh_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Sa nanër vu ham yönon rot nabë: Mehöti bë genġo sa ġaġek bayo na timu vu Amaġ sën vonġ sa meseyam lo, og rëḳ medo mala-tumsën degwata los degwata. Su rëḳ natöḳ jaḳ nyëvewen rë, gaḳ kesuu diiḳsën ggovek ya genedo mala-tumsën vorot. ");
INSERT INTO bzh_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Log sa nanër vu ham yönon nabë: Buk ti vonġin berup, balam-diiḳsën degenġo Anutu Nalu aye, lob buk saga verup ggovek ya. Lob alam sën degenġo aye lo, rëḳ demedo malaj-tumsën. ");
INSERT INTO bzh_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mala-tumsën degwa neggëp vu Ama yö timu, lom vo niwëëk vu Nalu gemala-tumsën degwa neggëp vu yi ving. ");
INSERT INTO bzh_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mehönon Nalu yi, om sën Ama ggooin yi raḳ in bë genġo mehönon hir ġaġek. ");
INSERT INTO bzh_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ham su gwelëk in ġaġek sënë. Gaḳ buk vonġin berup, lob alam-diiḳsën pin sën deneggëp bedub lo, rëḳ degenġo aye medekedi jaḳ medenam. ");
INSERT INTO bzh_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Alam sën denevonġ nġaa nivesa lo, rëḳ dekedi jaḳ medemedo malaj-tumsën. Galam sën denevonġ nġaa nipaya lo, rëḳ dekedi jaḳ nah medenatöḳ jaḳ hir nipaya nyëvewen. ");
INSERT INTO bzh_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Sa su yoh vu bë ġevonġ nġaa ti noh vu senġo kwaġ rë. Gaḳ sa nesepa loḳ ġaġek sën sa nehanġo vu Amaġ lo menesesor alam hir ġaġek raḳ. Lob sa ġaġek neya niröp in sa su kwaġ nevo bë sepa doḳ nġo kwaġ rë, gaḳ sa nesepa loḳ yi sën vonġ sa meseyam lo kwa. ");
INSERT INTO bzh_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Bë senġo tateḳin sa degwa og su yoh vu rë. ");
INSERT INTO bzh_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Rëḳ mehö ngwë nedo metateḳin sa degwa, lob seraḳ ni bë netateḳin yoh vu. ");
INSERT INTO bzh_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Wirek ham vonġ alam deya vu Mehö-neripek-alam Jon in bë degenġo yi ġaġek, lob tateḳin ġaġek anon vu sir ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Rëḳ mu sa su nesero mehöti in bë doḳ vu sa metateḳin sa degwa rë. Gaḳ sa nanër sënë in bë ham gwërin ham bAnutu geḳo ham nom. ");
INSERT INTO bzh_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Mehö-neripek-alam Jon nebë ranġah sën nejëh raḳ nyëġ lo, om ham kwamin vesa dus teka in ranġah saga. ");
INSERT INTO bzh_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yönon, Jon tateḳin sa degwa vu ham, rëḳ mu nġaa böp sën sa nehevonġ lo tateḳin sa degwa rot bekesuu Jon yi ġaġek. Sa nehevonġ huk pin sën Amaġ vo vu sa in bë sa ġevonġ begovek na lo. Lob huk pin sën sa nehevonġ lo netato vu mehönon in bë dejaḳ ni nabë Amaġ vonġ sa beseyam. ");
INSERT INTO bzh_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Lob Amaġ sën vonġ sa beseyam lo, yi yö nër sa degwa ranġah. Ham su nenġo aye rë, geham su malamin neraḳ yi rë. ");
INSERT INTO bzh_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Geyi ġaġek sënë su neggëp loḳ ham ayomin rë. In ham su vonġ ving mehö sën Anutu vonġ yi yam lo rë. ");
INSERT INTO bzh_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ham nesero ġaġek loḳ Anutu-yi-ḳapiya, in ham kwamin nevo bë mala-tumsën degwa loḳ neggëp beham rëḳ natöḳ jaḳ bemedo malamin-tumsën degwata. Rëḳ ḳapiya saga sën tateḳin sa degwa. ");
INSERT INTO bzh_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Rëḳ ham nimin lël geham su neyam vu sa in bë ham medo malamin-tumsën rë. ");
INSERT INTO bzh_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Sa su yam in bë alam degeḳo sarëġ jaḳ rë! ");
INSERT INTO bzh_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Rëḳ seraḳ ham nimin bë ham su ahëmin ving Anutu neggëp ham ayomin rë. ");
INSERT INTO bzh_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Seyam raḳ Amaġ niwëëk, rëḳ ham su ḳo sa raḳ rë. Bë mehöti nam jaḳ yö yi niwëëk, og ham rëḳ gweḳo yi jaḳ. ");
INSERT INTO bzh_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ham ahëmin neving bë mehönon degeḳo ham arëmin jaḳ, rëḳ ham su nevonġin bë Anutu timu geḳo ham arëmin jaḳ rë, om ham rëḳ gwevonġ geving yi nabë va? ");
INSERT INTO bzh_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ham su kwamin bo nabë serëḳ ġevonġ ġaġek vu ham vu Amaġ. Gaḳ mehö sën mëm rëḳ gevonġ ġaġek vu ham lo, og Moses. Yi sën ham kuung bë rëḳ doḳ vu ham lo! ");
INSERT INTO bzh_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bë ham gwevonġ geving Moses yi ġaġek, og rëḳ ham gwevonġ geving sa ġaġek geving. In kevu ġaġek raḳ sa. ");
INSERT INTO bzh_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Gaḳ bë ham su gwevonġ geving nġaa sën Moses kevu lo rë, og ham rëḳ gwevonġ geving sa ġaġek nabë va?” ");
INSERT INTO bzh_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ġaġek sënë maya, log buk ti lob Yesu ya nġaggee böp Galilea nenga vahi-sën denenër arë ngwë nebë Nġaggee-böp Tiberias* lo. ");
INSERT INTO bzh_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Lob alam yu böpata delë nġaa böp sën vonġ vu alam niraḳsën lo, lob denetamuin yi. ");
INSERT INTO bzh_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Lob Yesu raḳ meya ḳedu beya nedo ving yi hur maluh lo, ");
INSERT INTO bzh_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","log alam Yuda hir Buk-ggöksën-yi* dus raḳ. ");
INSERT INTO bzh_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Loḳ Yesu mala neḳo loḳ nyëġ, lob lë bë alam yu böpata verup deneyam vu yi, lob loḳ tepëḳ vu Pilip bë, “Hil rëḳ baġo nos vu tena balam sënë dega?” Nër nebë sënë meseggi Pilip, ");
INSERT INTO bzh_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","gaḳ yö raḳ nġaa sën bë gevonġ lo ni ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Loḳ Pilip nër yah vu yi bë, “Bë hil baġo nos jaḳ monë K200, og sagaḳ su rëḳ noh vu sir pin bedega teka teka rë!” ");
INSERT INTO bzh_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Rëḳ yi hur maluh ngwë Andreas, sën Simon Pita ari lo, nër vu yi bë, ");
INSERT INTO bzh_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Hurmahen ti ḳo brët nemadvahi geġël luu menedo sënë. Rëḳ mu sagaḳ su yoh vu alam yu böpata sënë rë!” ");
INSERT INTO bzh_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Lom Yesu nër bë, “Ham nanër vu sir nabë degeto demedo.” Lob pahup nġahiseḳë taya menedo, lom to denedo raḳ, lob sir maluh 5,000. ");
INSERT INTO bzh_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Log Yesu ḳo nos raḳ bejom raḳ in los kwa vesa ya vu Anutu, log vo ggelek sir. Log vonġ ġël luu lo ving nebë saga. Vo vu sir medejom ggelek sir yoh vu kwaj. ");
INSERT INTO bzh_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Degga ggovek meyoh vu sir, log Yesu nër vu yi hur maluh bë, “Ham ngupin nos vahi sën nahën nedoga. In hil su basap na meris.” ");
INSERT INTO bzh_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Lob desupin bedevasu loḳ sap nemadluho-bevidek-luu, yiḳ degga brët nemadvahi sën meyoh vu sir gevewen nedo. ");
INSERT INTO bzh_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Alam delë nġaa böp sën vonġ-ë, lob denër bë, “Yönon rot, mehö-nenër-ġaġek-ranġahsën sën denenër bë rëḳ nam dob lo yiḳ sënë.” ");
INSERT INTO bzh_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Lob Yesu raḳ ni bë vonġin denajom yi ahon bedegetunġ yi natu hir mehö-los-bengö, lom yö ti tah yi meyah los ḳedu. ");
INSERT INTO bzh_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Log sehuksën lob Yesu yi hur maluh deluḳ medeya nġaggee nenga ");
INSERT INTO bzh_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","bederaḳ ya yaġ in bë denah Kapernaum. Lob buk loḳ in sir geYesu yö nahën nedo ḳedu, ");
INSERT INTO bzh_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","log sanġ yam niwëëk benġaggee tëë böp. ");
INSERT INTO bzh_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Log detee yaġ meto deya nġaggee vuheng rot, (yoh vu 5 ma 6 kilomita), lom delë Yesu raḳ nare nġaggee vavunë meverup dus vu yaġ, lob deggöneng rot. ");
INSERT INTO bzh_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Rëḳ Yesu nër ya vu sir bë, “Yiḳ sa sën verup agi, om ham su ġöneng!” ");
INSERT INTO bzh_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Lob devonġin bë degeḳo yi jaḳ na yaġ rëḳ pevis metöḳ ya nġaggee nenga sën bë dena lo. ");
INSERT INTO bzh_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Log heng to lob alam yö nahën denedo nġaggee nenga vahi, gederaḳ ni bë su yaġ nġahi nedo veseveng rë. Gaḳ yiḳ timu nedo, geYesu su raḳ ya yaġ sënë ving yi hur maluh rë gema. Gaḳ yi hur maluh meris yö deraḳ ya yaġ saga medeya. ");
INSERT INTO bzh_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Rëḳ yaġ la vu nyëġ böp Tiberias* deverup monbuk anon medenedo roneḳnë vu nyëġ sën Yesu jom raḳ nos gedegga lo. ");
INSERT INTO bzh_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Lom delë bë Yesu losho yi hur maluh su denedo rë, lom deraḳ ya yaġ saga beya desero Yesu vu Kapernaum. ");
INSERT INTO bzh_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Desero yi meya detöḳ vu yi ggëp nġaggee nenga vahi, lob deloḳ tepëḳ vu yi bë, “Tatovaha! Ġeyoh bë tena meġeyam-a?” ");
INSERT INTO bzh_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Rëḳ Yesu nër yah bë, “Sa nanër vu ham yönon rot nabë: Ham su kwamin nevo nġaa böp sën sa hevonġ lo beham yam nesero sa rë, gaḳ ham wa nos bahëmin pup, om sën ham yam nesero sa. ");
INSERT INTO bzh_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ham su gwevonġ huk in nos sën rëḳ petar agi! Gaḳ ham gwevonġ huk in nos sën rëḳ medo degwata geyoh vu bë gevonġ beham medo malamin-tumsën lo. Mehönon Nalu rëḳ bo nos sënë vu ham, in Ama Anutu tato yi ggovek ya bevonġ yi yam.” ");
INSERT INTO bzh_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Lob denër yah vu yi bë, “He ġevonġ nabë va in he ġevonġ Anutu yi huk-a?” ");
INSERT INTO bzh_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Rëḳ Yesu nër yah vu sir bë, “Anutu yi huk nebë sënë: Ham ayomin na timu vu Mehö sën Anutu vonġ yam lo.” ");
INSERT INTO bzh_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Loḳ denër yah bë, “Rëḳ gwevonġ nġaa böp va ti mehe ġalë loḳ mëm he rëḳ ġevonġ geving honġ-a? Ġeyoh vu bë rëḳ gwevonġ va? ");
INSERT INTO bzh_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","He ḳenumin lo degga mana* ggëp nyëġ-yumeris wirek, nebë sën dekevu meneggëp loḳ Anutu-yi-ḳapiya lo nebë: Vo nos-yaġek-yi vu sir medegga.” ");
INSERT INTO bzh_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Lom Yesu nër vu sir bë, “Sa nanër vu ham yönon rot nabë: Moses su vo nos-yaġek-yi vu ham rë, gaḳ mëm Amaġ nevonġ nos-yaġek-yi soġek vu ham. ");
INSERT INTO bzh_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nos sën Anutu nevonġ lo, og luḳ yam vu yaġek in bë gevonġ bemehönon demedo malaj-tumsën.” ");
INSERT INTO bzh_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Rëḳ denër yah vu yi bë, “Om Mehöböp, ġebo nos sënë vu he noh vu buk!” ");
INSERT INTO bzh_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Rëḳ Yesu nër bë, “Senġo ti nos-mala-tumsën-yi. Mehöti bë nam vu sa, og su rëḳ nadiiḳahë gökin nah rë. Log bë mehöti ayo na timu vu sa, og su rëḳ ayo bev in bël gökin rë. ");
INSERT INTO bzh_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Rëḳ senër vu ham vorot bë ham nelë sa rëḳ ham su ayomin neyam timu vu sa rë. ");
INSERT INTO bzh_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mehönon pin sën Amaġ vo sir vu sa lo, og rëḳ denam vu sa. Lob mehöti bë nam vu sa, og sa su rëḳ juuk yi rë. ");
INSERT INTO bzh_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","In sa su vu yaġek meyam in bë nġo sepa kwaġ rë. Gaḳ seluḳ yam in bë ġevonġ noh vu Mehö sën vonġ sa meseyam lo kwa. ");
INSERT INTO bzh_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Lob Mehö sën vonġ sa meseyam lo kwa nebë sënë bë: Alam sën vonġ vu sa ggovek lo, saga sa su rëḳ ġevuu sir ti bemala nama rë, gaḳ senġo rëḳ nanër bedekedi jaḳ nah vu Buk-tamusën. ");
INSERT INTO bzh_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kë! Amaġ kwa nebë sënë bë: Alam pin sën degelë Nalu mayoj na timu vu yi lo, og rëḳ demedo malaj-tumsën degwata. Gesëḳ nanër bedekedi jaḳ nah vu Buk-tamusën.” ");
INSERT INTO bzh_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Log nër bë, “Senġo ti nos sën luḳ yam vu yaġek!” Nër bë sënë lob alam Yuda devonġ ayej vu medenër ġaġek nġahiseḳë raḳ yi. ");
INSERT INTO bzh_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Denër bë, “Mehö sënëḳ maḳ Yesu sën Yosep nalu yi lo? Behil araḳ ama lu ata nij. Ma nebë va sën nër bë yi vu yaġek meluḳ yam-ë?” ");
INSERT INTO bzh_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Lom Yesu nër yah vu sir bë, “Ham su nanër ġaġek nġahiseḳë vu ham! ");
INSERT INTO bzh_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mehöti su yoh vu bë nam vu sa meris rë. Gaḳ Amaġ sën vonġ sa meseyam lo, bë geḳo mehöti nam, og mehö saga rëḳ nam vu sa. Lob sëḳ nanër bekedi jaḳ nah vu Buk-tamusën. ");
INSERT INTO bzh_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Alam-denenër-ġaġek-ranġahsën dekevu ġaġek meneggëp loḳ Anutu-yi-ḳapiya nebë: Anutu yö rëḳ tateḳin ġaġek vu sir pin. Lob alam pin sën denenġo Amaġ yi ġaġek venuh lo, og rëḳ denam vu sa. ");
INSERT INTO bzh_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mehöti su lë Amaġ rë. Mehö timu sën nedo ving Anutu beyam lo, yiḳ mehö timu saga sën lë Ama. ");
INSERT INTO bzh_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sa nanër vu ham yönon rot nabë: Bë mehöti ayo nam timu vu sa, og rëḳ medo mala-tumsën degwata los degwata. ");
INSERT INTO bzh_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Senġo ti nos-mala-tumsën-yi. ");
INSERT INTO bzh_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wirek ham ḳenumin lo degga mana* vu nyëġ-yumeris medenedo, loḳ dediiḳ. ");
INSERT INTO bzh_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gaḳ bë mehöti ga nos sën luḳ yam vu yaġek agi, og su rëḳ nadiiḳ rë. ");
INSERT INTO bzh_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nos-mala-tumsën-yi sën luḳ meyam vu yaġek lo, yiḳ sa. Bë mehöti ga nos sënë, og rëḳ medo mala-tumsën degwata. Nos sën sebo vu yi lo, yiḳ sa reggos. Sëḳ bo vu alam vu dob in demedo malaj-tumsën.” ");
INSERT INTO bzh_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Lob alam Yuda yö yah denër vu sir bë, “Nebë va sën mehö sënë bo yi reggos mehil aġa-ë?” ");
INSERT INTO bzh_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Loḳ Yesu nër vu sir bë, “Sa nanër vu ham yönon rot nabë: Nabë ham su gwa Mehönon Nalu reggos los nanum yi ḳöḳ rë, og ham su rëḳ medo malamin-tumsën rë. ");
INSERT INTO bzh_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Alam sën dega sa reggos los denanum sa ḳöḳ lo, og rëḳ demedo malaj-tumsën degwata los degwata, om sëḳ nanër bedekedi jaḳ nah vu Buk-tamusën. ");
INSERT INTO bzh_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","In sa reggos saga og nos soġek, gesa ḳöḳ saga sën tu bël soġek. ");
INSERT INTO bzh_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mehöti bë ga sa reggos los nanum sa ḳöḳ, og rëḳ medo doḳ sa, gesa medo doḳ yi. ");
INSERT INTO bzh_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Amaġ sën mala-tumsën degwa lo vonġ sa beseyam, lob sa nado malaġ-tumsën raḳ Amaġ yi niwëëk. Nebë saga, om mehöti bë ga sa, og rëḳ medo mala-tumsën jaḳ sa niġ wëëk. ");
INSERT INTO bzh_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nos sagi sën luḳ vu yaġek meyam. Su nebë nos sën ham ḳenumin lo degga loḳ dediiḳ lo rë. Gaḳ mehöti bë ga nos sënë, og rëḳ medo mala-tumsën degwata los degwata.” ");
INSERT INTO bzh_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu nër ġaġek sënë vu sir loḳ dub-supinsën-yi vu Kapernaum. ");
INSERT INTO bzh_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Lob yi hur maluh nġahiseḳë denġo ġaġek sënë, lom denër bë, “Ġaġek sënë su yoh vu rë! Re yoh vu bë rëḳ jaḳ degwa ni?” ");
INSERT INTO bzh_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Rëḳ Yesu raḳ ni bë yi hur maluh denër ġaġek nġahiseḳë raḳ ġaġek sënë, lom nër vu sir bë, “Ġaġek sënë vonġ beham ahëmin sengën-a? ");
INSERT INTO bzh_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Om nabë ham gwelë Mehönon Nalu jaḳ menah nyëġ sën nedo wirek meyam lo, og ham rëḳ nanër nabë va? ");
INSERT INTO bzh_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anon Vabuung yö ti nevonġ bemehönon denedo malaj-tumsën. Hil navid su yoh vu bë doḳ vu hil rë, gaḳ ġaġek sën senër vu ham gwëbeng agi, og yoh vu bë doḳ vu ham anomin begevonġ beham medo malamin-tumsën. ");
INSERT INTO bzh_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Rëḳ ham la su devonġ ving rë.” Alam sën su devonġ ving rë lo, og Yesu yö raḳ nij muġin. Geraḳ mehö sën rëḳ nanër yi ranġah vu alam-beġö-yi lo ni ving. ");
INSERT INTO bzh_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Lob nër ggökin bë, “Ham la su devonġ ving sa ġaġek rë, om yiḳ raḳ degwa saga sën senër vu ham nebë: Bë Amaġ su geḳo mehöti nam rë, og su yoh vu bë yö rëḳ nam vu sa rë.” ");
INSERT INTO bzh_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Denġo Yesu yi ġaġek saga, lob yi hur maluh vahi devuu yi gedeyah medeya, gesu deneya ving yi ggökin rë. ");
INSERT INTO bzh_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Lom Yesu loḳ tepëḳ vu sir nemadluho-bevidek-luu bë, “Maḳ ham rëḳ kwehe ham in sa nabë saga geving mena?” ");
INSERT INTO bzh_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Loḳ Simon Pita nër yah vu yi bë, “Mehöböp, rëḳ he na vu re? Ma. Honġ timu ġaġek mala-tumsën degwa honġ! ");
INSERT INTO bzh_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Behe ayomin yök timu vu honġ ggovek ya, behe raḳ nim bë Anutu yi Mehö Vabuung honġ!” ");
INSERT INTO bzh_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Lob Yesu nër ġaġek yah vu sir bë, “Sehooin ham nemadluho-bevidek-luu raḳ, rëḳ ham tiḳ memö!” ");
INSERT INTO bzh_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nër nebë saga raḳ Yudas sën Simon Iskariot nalu. Hur maluh nemadluho-bevidek-luu hir ti yi sën rëḳ nanër Yesu ranġah medengis yi nadiiḳ lo. ");
INSERT INTO bzh_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Sënë ggovek log Yesu tah yi meyah nedo distrik Galilea. Gesu ya neḳo loḳ distrik Yudea rë, in alam Yuda denevonġin bë dengis yi menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lob alam Yuda hir buk vabuung ngwë sën denenër bë Buk-vabuung-numeng-yi lo dus raḳ, (in wirek ḳenuj lo delev numeng mahen mahen medeggëp loḳ vu nyëġ-yumeris, om sën denetahu bedenesepa loḳ yoh vu ta). ");
INSERT INTO bzh_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Lob ari lo denër vu yi bë, “Gwevuu nyëġ sënë geġena Yudea in honġ hur maluh degelë honġ huk sën ġenevonġ lo. ");
INSERT INTO bzh_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Bë mehöti kwa bo nabë gevonġ bengö jaḳ, og su nevun yi huk meneggëp vunsën rë. Ġenevonġ nġaa nebë sënë, om ġena ġetato honġ vu mehönon pin medegelë honġ.” ");
INSERT INTO bzh_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ari lo sën su denevonġ ving yi bë Anutu nalu rë, om sën denër nebë sënë. ");
INSERT INTO bzh_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Lob Yesu nër yah vu sir bë, “Sa buk yö nahën! Gaḳ buk pin sënëḳ ham nġo ham buk. ");
INSERT INTO bzh_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Alam sën denesepa loḳ aggata dob yi lo su deyoh vu bë degelë ham paya rë. Gaḳ denelë sa paya in sa nanër hir nġaa nipaya sën denevonġ lo ranġah. ");
INSERT INTO bzh_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ham nġo na gwelë buk vabuung saga! Gaḳ saḳ su rëḳ na doḳ buk vabuung sënë rë in sa buk yö nahën.” ");
INSERT INTO bzh_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nër bë sënë vu sir genedo Galilea. ");
INSERT INTO bzh_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Loḳ ari lo demuġin meya denelë buk vabuung geyö ti rëḳ tamuin sir meraḳ meya. Su ya ranġah rë, gaḳ vun yi meya. ");
INSERT INTO bzh_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Rëḳ alam Yuda desero yi loḳ buk vabuung saga bedenër bë, “Mehö sënë lo nedo tena?” ");
INSERT INTO bzh_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lob alam depatereng medenër ġaġek nġahiseḳë raḳ yi. Vahi denenër bë, “Yi mehö nivesa!” Gevahi denenër bë, “Ma! Nekuungin alam!” ");
INSERT INTO bzh_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Rëḳ deneggöneng in hir ggev, om sir ti su nër ġaġek raḳ yi ya ranġah rë. ");
INSERT INTO bzh_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Denelë buk vabuung saga beyi buk vahi ggovek ya meya verup vuheng atov, lom Yesu ya verup meluḳ ya dub-vabuung-böp ḳatum ayo metateḳin ġaġek vu alam. ");
INSERT INTO bzh_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Lom alam Yuda deranġa nemaj gedenër bë, “Maḳ re rëḳ tahu mehö sënë loḳ ġaġek sënë om sën nenër-ë? Mehöti su tateḳin vu yi rë!” ");
INSERT INTO bzh_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Rëḳ Yesu nër yah bë, “Ġaġek sën senër vu ham lo, saga su senġo ti sa nġaa rë. Gaḳ Anutu sën nevonġ sa meseyam lo yi nġaa. ");
INSERT INTO bzh_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Genabë mehöti ahë geving nabë gevonġ Anutu yi ġaġek banon jaḳ, og rëḳ jaḳ ġaġek sën sa nanër agi degwa ni nabë neyam vu Anutu, ma, senġo nanër yoh vu kwaġ. ");
INSERT INTO bzh_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mehöti bë nanër ġaġek noh vu yö kwa, og sagaḳ nevonġin bë yö geḳo arë jaḳ mu. Gaḳ mehöti bë geḳo mehö sën vonġ yi meyam lo arë jaḳ, og mehö saga rëḳ nanër ġaġek los anon gesu gekuung jaḳ rë. ");
INSERT INTO bzh_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Wirek Moses vonġ horek vu ham, rëḳ ham ti su nesepa loḳ yi horek saga rë. Ma ham bë ngis sa nadiiḳ in degwa va?” ");
INSERT INTO bzh_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Rëḳ alam saga denër yah vu bë, “Memö nipaya ti negwanġ ya ayom! Re bë ngis honġ nadiiḳ-a?” ");
INSERT INTO bzh_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Rëḳ Yesu nër yah bë, “Sa hevonġ nġaa böp ti lob ham pin kwamin ya nġahi. ");
INSERT INTO bzh_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses vo ġaġek vu ham bë ham gwerah* navimin. Yönon, rëḳ mu ġaġek sënë su verup nyëdahis vu Moses rë, gaḳ yö verup wirek vu ham dobahë lo. Rëḳ ham nerah* nalumin navij loḳ Buk-sewahsën-yi*. ");
INSERT INTO bzh_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ham nerah* hurmahen navij loḳ Buk-sewahsën-yi* in bë ham su kweyëh Moses yi horek. Loḳ nebë va sën ham ahëmin sengën vu sa in sën sa hevonġ bemehöti nivesa raḳ los dahis loḳ Buk-sewahsën-yi*-ë? ");
INSERT INTO bzh_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ham su nanër ġaġek jeggin jeggin jaḳ alam, gaḳ ham jaḳ degwa ni meseggi rë loḳ mëm ham nanër sir niröp.” ");
INSERT INTO bzh_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Log alam Yerusalem la denër kwaj luu luu bë, “Maḳ yiḳ mehö sën denesero yi in bë dengis yi menadiiḳ lo saga? ");
INSERT INTO bzh_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ham lë! Nare ranġah menenër ġaġek rëḳ su denenër ġaġek ti raḳ yi rë! In maḳ alam ggev deraḳ ni bë yi Kerisi* yönon ma va? ");
INSERT INTO bzh_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Rëḳ mu hil araḳ mehö sënë yi nyëġ ni, gaḳ bë Kerisi* berup, og hil su rëḳ ajaḳ yi nyëġ ni rë!” ");
INSERT INTO bzh_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Lob Yesu nedo dub-vabuung-böp ḳatum ayo metateḳin ġaġek vu alam, genër ranġah bë, “Ham raḳ sa niġ, beham raḳ sa nyëġ ni! Rëḳ sa su yam yoh vu senġo kwaġ rë. Gaḳ mehö sën vonġ sa meseyam lo, og ġaġek anon pin degwa yi, rëḳ ham su raḳ ni rë. ");
INSERT INTO bzh_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Gaḳ saḳ seraḳ ni. In sa nado ving yi bevonġ sa meseyam.” ");
INSERT INTO bzh_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nebë saga lob sir bë denaduu yi na ḳarabus, rëḳ su dejom yi ahon rë in yi buk yö nahën. ");
INSERT INTO bzh_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Alam nġahiseḳë ayoj ya timu vu yi medenër bë, “Mesia sën bë rëḳ nam lo maḳ yiḳ yi sënë! Gaḳ mehö ngwë su yoh vu bë rëḳ berup megevonġ nġaa böp böp kesuu nġaa sën mehö agi nevonġ-ë rë.” ");
INSERT INTO bzh_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Alam Parisai* denġo alam denenër ġaġek aggagga nebë sënë raḳ Yesu, lom losho alam-deneḳo-seriveng hir ggev lo devonġ ahëvavu la deya in bë denaduu na ḳarabus. ");
INSERT INTO bzh_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Lob Yesu nër bë, “Yiḳ sa medo buk dus teka geving ham, log sëḳ nah mena vu yi sën vonġ sa meseyam lo. ");
INSERT INTO bzh_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ham rëḳ sero sa, rëḳ ham su rëḳ natöḳ jaḳ sa rë. Lob ham su yoh vu bë na nyëġ sën sena medo lo rë.” ");
INSERT INTO bzh_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Lob alam Yuda yö denër vu sir bë, “Rëḳ na tena gehil su ayoh vu bë rëḳ natöḳ vu yi rë? Maḳ rëḳ na vu hil alam vu alam Grik hir nyëġ betahu alam Grik-a? ");
INSERT INTO bzh_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Om sën nër bë, ‘Ham rëḳ sero sa, rëḳ ham su rëḳ natöḳ vu sa rë’—ë? Log nër ving bë, ‘Ham su yoh vu bë rëḳ na nyëġ sën sena medo lo rë’. Ma maḳ ġaġek sënë degwa nebë va?” ");
INSERT INTO bzh_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Dus raḳ bë Buk-vabuung saga yi buk govek na, lob yi buk böpata sën deneseggi hus lo verup, lob Yesu kedi nare getahi bë, “Bë mehöti ayo bev in bël, og nam nanum vu sa! ");
INSERT INTO bzh_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Saga yoh vu sën dekevu meneggëp loḳ Anutu-yi-ḳapiya lo nebë: Bël-mala-tumsën-yi rëḳ benguv doḳ mehöti sën ayo nam timu vu sa lo ayo rot megeto mena.” ");
INSERT INTO bzh_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nër raḳ Anon Vabuung sën bë rëḳ bo vu alam sën ayoj na timu vu yi lo. In vu buk saga Anon Vabuung su yam rë, in Anutu nahën gesu ḳo Yesu raḳ yah vu yi rë. ");
INSERT INTO bzh_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Alam la denġo ġaġek saga, lob denër bë, “Maḳ mehö sënë, yi Mehö-nenër-ġaġek-ranġahsën ti sën hil neheġin-ë lo yönon.” ");
INSERT INTO bzh_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Gesir vahi denenër ngwë nebë, “Yi Mehö sën Anutu ggooin raḳ in bë geḳo hil nah lo.” Loḳ vahi denenër bë, “Mu maḳ Kerisi* su rëḳ berup gëp Galilea rë! ");
INSERT INTO bzh_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","In dekevu ġaġek raḳ Kerisi* meneggëp loḳ Anutu-yi-ḳapiya bë Davit* yi mewis, om yö rëḳ berup gëp nyëġ Betlehem sën Davit yi nyëġ lo.” ");
INSERT INTO bzh_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nebë saga lob alam devasuh sir ya yu luu in Yesu. ");
INSERT INTO bzh_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Vahi bë degeḳo yi na ḳarabus, rëḳ ti su jom yi ahon rë. ");
INSERT INTO bzh_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nebë saga lob ahëvavu deyah medeya vu alam-deneḳo-seriveng hir ggev losho alam Parisai* ggökin. Lob alam Parisai* deloḳ tepëḳ vu sir bë, “Ham su ḳo yi yam rë in va?” ");
INSERT INTO bzh_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Rëḳ ahëvavu denër yah bë, “Mehöti su nenër ġaġek nebë sën mehö agi nenër-ë wirek rë!” ");
INSERT INTO bzh_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Loḳ alam Parisai* denër yah vu sir nebë, “Kuungin ham ving-a? ");
INSERT INTO bzh_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Maḳ ham lë bë he ggev los Parisai* ti ayo ya timu vu yi? Ma! ");
INSERT INTO bzh_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Rëḳ alam meris sënë desepa loḳ yi in su deraḳ horek ni rë, om Anutu rëḳ gevonġ bemalaj nama.” ");
INSERT INTO bzh_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Loḳ sir ti sën Nikodemus, sën wirek ya vu Yesu buk lo, nër vu sir bë, ");
INSERT INTO bzh_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Maḳ hil horek nër bë hil ġevonġ ġaġek vu mehöti meris mu? Ma! Hil ġanġo yi ġaġek namuġin, behil ajaḳ nġaa sën vonġ lo ni nivesa rë, loḳ mëm.” ");
INSERT INTO bzh_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Rëḳ denër ġaġek yah vu yi bë, “Maḳ honġ Galilea ti ving-a? Bë ġenatevin Anutu-yi-ḳapiya nivesa, og rëḳ ġejaḳ ni nabë alam-denenër-ġaġek-ranġahsën ti su rëḳ berup gëp distrik Galilea rë.” ");
INSERT INTO bzh_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Log deketëḳin sir medeyah medeya bej. ");
INSERT INTO bzh_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Log Yesu yah meya Ḳedu Ḳele-oliv. ");
INSERT INTO bzh_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Log kedi monbuk anon meyah dub-vabuung-böp ḳatum ayo ggökin. Lob alam pin deya vu yi, lom to nedo getateḳin ġaġek vu sir. ");
INSERT INTO bzh_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Lob alam-horek-yi los alam Parisai* delë bë avëh ti vonġ baggëb, lom deḳo medevarah ya alam pin malaj ");
INSERT INTO bzh_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","gedenër vu Yesu bë, “Tatovaha! Avëh sënë vonġ baggëb lom alam detöḳ vu yi. ");
INSERT INTO bzh_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses vo horek vu hil bë hil tengwa avëh nabë sënë jaḳ ġelönġ menadiiḳ. Ma honġ og rëḳ ġenanër nabë va?” ");
INSERT INTO bzh_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Denër bë saga in bë deseggi yi, bedenatöḳ vu ġaġek ti berup avi bedegevonġ ġaġek vu yi. Rëḳ Yesu dudeḳ bemedo neseröö dob raḳ nema deggis. ");
INSERT INTO bzh_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Deloḳ tepëḳ panġsën rot, lob mëm vër yu raḳ benër vu sir bë, “Bë ham ti su nevonġ nġaa nipaya rë, og mëm namuġin betengwa avëh sënë jaḳ ġelönġ ti.” ");
INSERT INTO bzh_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Log dudeḳ yah bemedo neseröö dob ggökin. ");
INSERT INTO bzh_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Denġo nebë sënë, lom sir ti ti to medo deneya dobnë vër vër. Alam ggev to deya muġin, log sir vahi detamu. Devuu Yesu geyö ti nedo gavëh nahën nare loḳ mala. ");
INSERT INTO bzh_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Lob Yesu vër mala raḳ benër vu avëh bë, “Avëh, sir tena? Maḳ mehöti su vonġin bë ngis honġ rë?” ");
INSERT INTO bzh_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Rëḳ bë, “Mehöböp, ma-o!” Lob Yesu nër bë, “Sa ving, sa su hevonġin bë ngis honġ rë. Om ġena, gesu gwevonġ nġaa nipaya gökin nah!” ");
INSERT INTO bzh_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Lob Yesu nër vu sir ggökin yah bë, “Sa og setu dob yi ranġah. Mehöti bë tamuin sa, og su rëḳ ketul doḳ in aggata rë, gaḳ rëḳ nama. In ranġah rëḳ geli yi mena medo mala-tumsën.” ");
INSERT INTO bzh_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nebë saga lob alam Parisai* denër yah vu yi bë, “Nġo ġenetateḳin honġ degwa, om honġ ġaġek saga su anon rë.” ");
INSERT INTO bzh_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Loḳ Yesu nër yah vu sir bë, “Yönon, senġo netateḳin sa degwa. Rëḳ sa ġaġek saga yönon, in seraḳ nyëġ sën sa nado meseyam gesëḳ nah lo ni. Rëḳ ham duġin sa nyëġ sën sa nado meseyam gesëḳ nah mena medo lo. ");
INSERT INTO bzh_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ham nġo nevo nyëvewen loḳ yah vu mehönon yoh vu ham alam-dob-yi nġo kwamin, rëḳ sa, og sa su navo nyëvewen loḳ yah vu mehöti rë. ");
INSERT INTO bzh_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Gaḳ nabë sa ġevonġ nyëvewen vu mehöti, og sëḳ ġevonġ noh vu, in su senġo ti rë. Gaḳ Mehö sën vonġ sa meseyam lo neloḳ vu sa, om sëḳ ġevonġ niröp. ");
INSERT INTO bzh_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yönon, ham horek ti neggëp nebë sënë: Bë mehö luu denanër ġaġek gëp ti, og luho hir ġaġek saga yönon. ");
INSERT INTO bzh_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Log yiḳ sa, og senġo netateḳin sa degwa ranġah, gAmaġ sën vonġ sa meseyam lo netateḳin sa degwa ranġah ving.” ");
INSERT INTO bzh_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nër nebë saga lob deloḳ tepëḳ in bë, “Amam tena?” Loḳ Yesu nër yah bë, “Ham su raḳ sa niġ rë, geham su raḳ Amaġ ni rë. Bë ham jaḳ sa niġ, og ham rëḳ jaḳ Amaġ ni geving.” ");
INSERT INTO bzh_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Netateḳin ġaġek sënë vu alam loḳ dub-vabuung-böp ḳatum ayo, genenër vu sir loḳ dub ayo ti sën monë ben lo rëḳ mehöti su jom yi ahon rë, in yi buk yö nahën. ");
INSERT INTO bzh_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Log Yesu nër yah vu sir ggökin bë, “Sëḳ na geham rëḳ sero sa, rëḳ nama beham nadiiḳ los ham nipaya. Geham su yoh vu bë rëḳ nök nyëġ sën sena-ë rë.” ");
INSERT INTO bzh_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Lob alam Yuda denër bë, “Nër bë hil su ayoh vu bë rëḳ ana nyëġ sën na lo rë! Maḳ nër sënë in bë yö rëḳ ngis yi menadiiḳ-a?” ");
INSERT INTO bzh_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Loḳ nër yah vu sir bë, “Ham vu dob sënë, gesa vu vavunë. Om ham nesepa loḳ aggata-dob-yi, gaḳ saḳ su nesepa loḳ aggata-dob-yi rë. ");
INSERT INTO bzh_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Om sën senër vu ham ggovek bë ham rëḳ nadiiḳ los ham nipaya. Bë ham su gwevonġ geving nabë sa Mehö sënë lo rë, og ham nġaa nipaya rëḳ gëp vu ham, beham nadiiḳ los.” ");
INSERT INTO bzh_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Lom deloḳ tepëḳ yah vu yi bë, “Honġ re?” Loḳ Yesu tateḳin yah vu sir bë, “Yiḳ sa Mehö lo sënë, nebë sën sa nanër vu ham wirek wirek lo. ");
INSERT INTO bzh_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Sa ġaġek nġahiseḳë nahën neggëp besa bë nanër jaḳ ham beseggi ham. Rëḳ Mehö sën vonġ sa meseyam lo yi Mehö ġaġek anon degwa, om ġaġek pin sën sa nehanġo vu yi lo, yiḳ sën sa nanër vu alam pin vu dob.” ");
INSERT INTO bzh_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nenër Ama Anutu vu sir rëḳ su deraḳ ni rë. ");
INSERT INTO bzh_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Log Yesu nër vu sir ggökin bë, “Nahub rëḳ ham ngis Mehönon Nalu jaḳ ḳelepeḳo*, lob mëm ham rëḳ jaḳ ni doḳ buk saga nabë yiḳ sa Mehö lo sënë. Lob ham rëḳ jaḳ ni nabë sa su nehevonġ nġaa ti yoh vu senġo kwaġ rë. Gaḳ sa nanër ġaġek yoh vu sën Amaġ tato vu sa lo. Log Mehö sën vonġ sa meseyam lo neloḳ vu sa. ");
INSERT INTO bzh_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Su nevuu sa besenġo ti nado rë. In sa nehevonġ nġaa sën ahë neving lo yoh vu buk pin.” ");
INSERT INTO bzh_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nër nebë sënë lob alam nġahiseḳë ayoj ya timu vu yi. ");
INSERT INTO bzh_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Lob Yesu nër vu alam Yuda sën ayoj neya timu vu yi ggovek lo bë, “Bë ham medo doḳ sa ġaġek, og ham rëḳ natu sa alam yönon, ");
INSERT INTO bzh_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","beham rëḳ jaḳ ġaġek anon ni, lob ġaġek anon saga rëḳ geḳo ham vër.” ");
INSERT INTO bzh_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Loḳ denër yah vu yi bë, “Abraham yi mewis he, om he su nado loḳ mehö ngwë nema benehevonġ huk ḳarabus vu yi rë! Rëḳ nebë va sën ġenër bë honġ ġaġek rëḳ geḳo he vër-ë?” ");
INSERT INTO bzh_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Loḳ mëm Yesu tateḳin yi ġaġek vu sir bë, “Sa nanër vu ham yönon rot nabë: Alam pin sën denevonġ nġaa nipaya lo, og denedo loḳ nġaa nipaya, benġaa nipaya neġin sir. ");
INSERT INTO bzh_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Alam sën denedo loḳ mehö ngwë nema meneġin sir lo, og su rëḳ demedo degwata geving yi rë. Gaḳ yi yö nalu og mëm rëḳ medo doḳ yi begganġ degwata geving yi. ");
INSERT INTO bzh_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Om Nalu bë geḳo ham vër in nġaa nipaya, og rëḳ geḳo ham vër yönon, beham medo nivesa anon. ");
INSERT INTO bzh_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Seraḳ ni bë Abraham yi mewis ham! Rëḳ sa ġaġek su nedo loḳ ham ayomin rë, om sën ham bë ngis sa mesa nadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Sa nanër ġaġek raḳ nġaa sën Amaġ tato vu sa ggovek lo, rëḳ ham nesepa loḳ nġaa sën ham amamin netato vu ham lo!” ");
INSERT INTO bzh_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Lom denër yah bë, “He degwa vu Abraham!” Rëḳ Yesu nër vu sir bë, “Bë ham degwa vu Abraham yönon, og ham rëḳ gwevonġ nġaa nabë sën Abraham nevonġ lo. ");
INSERT INTO bzh_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Senër ġaġek anon pin sën sa hanġo vu Anutu lo vu ham, lom ham bë ngis sa mesa nadiiḳ, rëḳ Abraham su vonġ nebë sënë rë. ");
INSERT INTO bzh_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gaḳ ham nġo nesepa loḳ amamin vaha!” Loḳ denër yah bë, “He atamin su deḳo he duum rë! He amamin Anutu timu.” ");
INSERT INTO bzh_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Rëḳ Yesu nër yah bë, “Bë ham amamin Anutu yönon, og rëḳ ham ahëmin geving sa, in sa nado ving Anutu besën seyam. Sa su yam yoh vu senġo kwaġ rë, gaḳ Anutu vonġ sa meseyam. ");
INSERT INTO bzh_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ma nebë va sën ham su raḳ sa ġaġek degwa ni rë-ë? Sënë degwa nebë ham ayomin nilëlin sa ġaġek. ");
INSERT INTO bzh_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ham amamin Satan genalu ham, om ham nimin wëëk panġsën bë ham sepa doḳ amamin kwa. Vu muġinsën yi mehö beġö degwa menesis alam medenediiḳ. Rot begwëbeng. Gesu nesepa loḳ ġaġek anon rë, in ġaġek anon su neggëp vu yi rë. Bë nanër ġaġek ti, og rëḳ nanër ġaġek kuungsën, in yö yi nġaa nebë saga. Yi mehö ġaġek kuungsën, lob ġaġek kuungsën ala los degwa yi. ");
INSERT INTO bzh_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Gaḳ saḳ nanër ġaġek anon mu, om sën ham su nevonġ ving sa rë. ");
INSERT INTO bzh_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ham ti tena yoh vu bë rëḳ natöḳ vu nġaa nipaya ti gegëp vu sa? Ma! Sa nanër ġaġek anon mu, rëḳ nebë va sën ham su nevonġ ving rë-ë? ");
INSERT INTO bzh_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Anutu nalu lo, og denebë nengaj vu Anutu yi ġaġek. Gaḳ su Anutu nalu ham rë, om sën ham su nebë nengamin vu yi ġaġek rë.” ");
INSERT INTO bzh_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Lob alam Yuda denër yah vu yi bë, “He raḳ nim bë honġ Samaria* ti, rëḳ memö nipaya ti gwanġ ya ayom. Sagaḳ yönon!” ");
INSERT INTO bzh_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Rëḳ Yesu nër yah bë, “Su memö nipaya gwanġ yam sayoġ rë. Gaḳ sa nehaḳo Amaġ raḳ, rëḳ ham nedahun sa. ");
INSERT INTO bzh_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Sa su nehevonġin bë ġaḳo arëġ jaḳ rë. Gaḳ Mehöti nedo beyö rëḳ kwa bo meseggi sa ġaġek begeḳo sarëġ jaḳ. ");
INSERT INTO bzh_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sa nanër vu ham yönon rot nabë: Bë mehöti sepa doḳ sa ġaġek, og su rëḳ mala nama na veröḳ yi rë.” ");
INSERT INTO bzh_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Lob alam Yuda denër bë, “Gwëbeng he raḳ ni ggovek ya bë memö nipaya ti gwanġ ya ayom meneloḳ vu honġ. Abraham diiḳ ggovek, galam-denenër-ġaġek-ranġahsën dediiḳ bemaya, loḳ ġenër bë, ‘Bë mehöti sepa doḳ sa ġaġek, og su rëḳ mala nama na veröḳ yi rë.’ ");
INSERT INTO bzh_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","In ġekuung bë kwesuu hil dobahë Abraham sën diiḳ wirek lo? Ġekwesuu alam-denenër-ġaġek-ranġahsën sën dediiḳ wirek lo ving-a? Log bë gweḳo honġ jaḳ meġenatu re?” ");
INSERT INTO bzh_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Lob Yesu nër yah bë, “Bë senġo ġaḳo arëġ jaḳ, og serëḳ natu nġaa meris. Rëḳ Amaġ neḳo sarëġ raḳ, Mehö sën ham nër bë ham amamin yi lo. ");
INSERT INTO bzh_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Rëḳ ma geham su raḳ ni rë. Gaḳ sa, og seraḳ ni. Bë sa nanër nabë sa duġin yi, og rëḳ sa mehö ġaġek kuungsën nabë ham. Rëḳ seraḳ ni ggovek ya besa nesepa loḳ yi ġaġek nivesa rot. ");
INSERT INTO bzh_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ham dobahë Abraham sën kwa vesa anon rot in bë gelë sa huk sënë, lob lë ggovek ya, lob ayo nivesa rot.” ");
INSERT INTO bzh_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Lob alam Yuda denër bë, “Su honġ ta mehödahis luu menemadluho rë geyö nahën, log maḳ ġelë Abraham-a?” ");
INSERT INTO bzh_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Rëḳ Yesu nër yah vu sir bë, “Sa nanër vu ham yönon rot nabë: Vu muġinsën gAbraham su nedo rë, vu buk saga sa nado.” ");
INSERT INTO bzh_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Denġo ġaġek saga lom deḳo ġelönġ raḳ in bë detengwa yi menadiiḳ, rëḳ Yesu vun yi loḳ alam ggëp dub ayo, beto meyah dobnë. ");
INSERT INTO bzh_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu tetuu aggata meya, loḳ töḳ raḳ mehö mala ḳenod ti. Yiḳ yö mala ḳenod loḳ buk sën ata ḳo yi lo. ");
INSERT INTO bzh_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Lob Yesu yi hur maluh deloḳ tepëḳ in yi bë, “Tatovaha! Re vonġ nġaa nipaya lom sën ata ḳo yi to los mala ḳenod-a? Degwa neggëp vu mehö sënë yö yi nġaa nipaya, ma vu ama lu ata hir nġaa nipaya?” ");
INSERT INTO bzh_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Lob Yesu nër yah vu sir bë, “Degwa su neggëp vu mehö sënë yi nġaa nipaya ma, vu ama lu ata hir nġaa nipaya rë! Gaḳ nġaa sënë yö raḳ yi in bë Anutu yi niwëëk natöḳ nam ranġah. ");
INSERT INTO bzh_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Gwëbeng hes yö nahën netum, gehil ġevonġ Mehö sën vonġ sa meseyam lo yi huk. In rëḳ buk doḳ in hil, lob mehöti su yoh vu bë rëḳ gevonġ huk rë. ");
INSERT INTO bzh_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Buk sën sa nado dob agi, og setu dob sënë yi Ranġah.” ");
INSERT INTO bzh_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu nër nebë sënë log pesuv nyë ḳos loḳ dob, log sarömin los, gejegwi loḳ mehö mala ḳenod mala ġahis, ");
INSERT INTO bzh_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","log nër vu yi bë, “Ġena ġejipek duḳ nġaggee Siloam!” (Arë sënë degwa nebë ‘Vonġ ya’). Lom ya meripek luḳ, lob mala tum, log yom. ");
INSERT INTO bzh_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Lob yi alam begganġnë ving alam sën denelë yi wirek loḳ buk sën neketaġ monë lu nġaa vu alam lo delë medeloḳ tepëḳ bë, “Maḳ yiḳ mehö sën medo neketaġ alam in monë lu nġaa wirek lo sënë?” ");
INSERT INTO bzh_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Lom la deyoġek bë, “Ëë-ë! Yiḳ mehö lo sënë!” Log la denenër bë, “Oo sagaḳ mehö ngwë, rëḳ ni nebë mehö saga!” Rëḳ mehö sënë yi yö nër raḳ avi bë, “Yiḳ sa lo sënë!” ");
INSERT INTO bzh_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Lom deloḳ tepëḳ yah vu yi bë, “Rëḳ malam nivesa raḳ nebë va?” ");
INSERT INTO bzh_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Loḳ nër yah bë, “Mehö sën denenër arë nebë Yesu lo sarömin dob ving nyë ḳos gejegwi loḳ sa malaġ, log nër vu sa bë, ‘Ġena ġejipek duḳ nġaggee Siloam!’ Lom seya meripek luḳ, lob sa malaġ nivesa raḳ besa halë nyëġ.” ");
INSERT INTO bzh_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Lob denër vu yi bë, “Mehö saga nedo tena?” Rëḳ nër yah bë, “Sa duġin!” ");
INSERT INTO bzh_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Lob deḳo mehö sën mala ḳenod wirek lo, bedeya vu alam Parisai*. ");
INSERT INTO bzh_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","In Yesu sarömin dob los nyë ḳos sënë betateḳin mehö sënë mala loḳ Buk-sewahsën-yi* ti. ");
INSERT INTO bzh_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Lom mëm Parisai* deloḳ tepëḳ in mehö saga ggökin bë, “Malam nivesa raḳ nebë va?” Loḳ nër yah vu sir bë, “Mehö saga jegwi dob rumengsën loḳ sa malaġ, log seripek, lob sa malaġ tum.” ");
INSERT INTO bzh_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Lob Parisai* la denër bë, “Mehö saga keyëh horek Buk-sewahsën-yi*, om maḳ Anutu su vonġ yi yam rë.” Rëḳ la denër bë, “Bë mehö nipaya ti, og su yoh vu bë rëḳ gevonġ nġaa böp nabë sënë rë!” Lob devasuh sir ya yu luu. ");
INSERT INTO bzh_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Lom denër yah vu mehö mala ḳenod bë, “Mehö sën vonġ malam nivesa raḳ lo, rëḳ ġenanër yi nabë va?” Loḳ nër yah bë, “Yi mehö-nenër-ġaġek-ranġahsën ti!” ");
INSERT INTO bzh_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Wirek mehö sënë mala ḳenod, rëḳ gwëbeng mala netum, rëḳ alam Yuda su devonġ ving sënë rë. ");
INSERT INTO bzh_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Lob detahi mehö mala ḳenod sënë ama lu ata yam, bedeloḳ tepëḳ in luho bë, “Maḳ melu nalumin sënë sën melu nër bë ata ḳo yi to los mala ḳenod lo? Rëḳ nebë va sën gwëbeng nelë nyëġ-ë?” ");
INSERT INTO bzh_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Lom ama lu ata denër yah bë, “Alu araḳ ni bë alu nalumin sënë, balu araḳ ni bë ata ḳo yi to los mala ḳenod. ");
INSERT INTO bzh_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Rëḳ alu su araḳ ni bë mala netum nebë va rë! Galu duġin mehö sën tateḳin mala lo. Om ham nġo doḳ tepëḳ vu yi rë. Yi böp raḳ ggovek ya, om yö nanër yi ġaġek!” ");
INSERT INTO bzh_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ama lu ata deggöneng in alam Yuda lom denër nebë sënë. In alam Yuda hir ggev denër ġaġek venuh bë: Bë mehöti nanër Yesu nabë yi Mesia, og rëḳ degetii yi na in dub-supinsën-yi. ");
INSERT INTO bzh_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yiḳ raḳ degwa sënë sën ama lu ata denër bë, “Yi böp raḳ ggovek ya, om ham nġo doḳ tepëḳ vu yi.” ");
INSERT INTO bzh_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Lob detahi mehö sën mala ḳenod lo beron ngwë ggökin bedenër vu yi bë, “Ġenanër ġaġek sënë gëp Anutu mala nabë ġenenër yönon! In he og he raḳ ni bë yi mehö nipaya.” ");
INSERT INTO bzh_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Lob nër yah vu sir bë, “Maḳ yi mehö nipaya ma ma? Sa duġin. Gaḳ yiḳ seraḳ nġaa timu ni. Wirek sa malaġ ḳenod, rëḳ gwëbeng sa malaġ netum.” ");
INSERT INTO bzh_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Loḳ deloḳ tepëḳ yah bë, “Vonġ nebë va vu honġ-a? Tateḳin malam nebë va?” ");
INSERT INTO bzh_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Rëḳ nër yah vu sir bë, “Senër vu ham ggovek, ma ham su nġo rë? Ma nebë va sën ham bë gwenġo nah gökin-ë? Maḳ ham bë natu yi hur maluh geving-a?” ");
INSERT INTO bzh_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Lom deggoo yi medenër bë, “Yiḳ yi hur maluh honġ saga! Gaḳ he, og Moses yi hur maluh he! ");
INSERT INTO bzh_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","He raḳ ni ggovek ya bë Anutu vengwënġ ving Moses, gaḳ maḳ mehö saga yam vu tena? He duġin yi degwa.” ");
INSERT INTO bzh_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Lom mehö sënë nër yah vu sir bë, “Alam-e! Nġaa sënë yö agga ti! Ham su raḳ degwa ni rë, rëḳ vonġ besa malaġ netum! ");
INSERT INTO bzh_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Hil araḳ ni bë Anutu su nenġo alam nijpaya hir ġaġek rë, gaḳ bë mehöti geḳo Anutu arë jaḳ los sepa doḳ yi ġaġek lo, og mëm Anutu rëḳ genġo aye. ");
INSERT INTO bzh_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Vu buk muġinsën sën Anutu tunġ yaġek los dob lo rot beyam töḳ gwëbeng, og su denër bë mehöti ata ḳo yi to los mala ḳenod rëḳ mehö ngwë tateḳin mala rë. ");
INSERT INTO bzh_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bë Anutu su gevonġ mehö sënë nam rë, og su yoh vu bë rëḳ gevonġ nġaa nabë sënë rë.” ");
INSERT INTO bzh_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Rëḳ denër yah vu yi bë, “Atam avëh nipaya meḳo honġ los nġaa nipaya, lob ġerig los nġaa nipaya, loḳ bë ġetateḳin ġaġek vu he?” Denër bë sënë gedetii vu dub ayo meto meyah dobnë. ");
INSERT INTO bzh_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu nġo bë deruuk mehö sënë, lob sero menër vu bë, “Ayom neya timu vu Mehönon Nalu, ma ma?” ");
INSERT INTO bzh_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Loḳ nër yah bë, “O mehö böp, Mehönon Nalu sënëḳ re? Ġenanër tato vu sa rë, loḳ mëm sëḳ ayoġ na timu vu yi.” ");
INSERT INTO bzh_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Lom Yesu nër vu yi bë, “Ġelë yi ggovek ya, mehö sënë sën gwëbeng yiḳ nevengwënġ ving honġ-ë!” ");
INSERT INTO bzh_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Lob mehö sënë nër bë, “Mehöböp, sayoġ neyök timu vu honġ!” Log yun lus vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Lob Yesu nër bë, “Seyam dob sënë in mehönon hir ġaġek natöḳ ranġah. Alam malaj ḳenod rëḳ malaj natum, galam sën denekuung bë malaj netum lo, og malaj ḳenod doḳ.” ");
INSERT INTO bzh_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Lob Parisai* la denedo medenġo yi ġaġek sënë, lob deloḳ tepëḳ vu yi bë, “Maḳ he malamin ḳenod ving-a?” ");
INSERT INTO bzh_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Rëḳ Yesu nër yah vu sir bë, “Bë ham malamin ḳenod, og ham nġaa nipaya su rëḳ gëp vu ham rë. Rëḳ ham nenër bë ham malamin netum, om ham nġaa nipaya nahën neggëp vu ham!” ");
INSERT INTO bzh_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Sa nanër vu ham yönon rot nabë mehöti sën su neyoh ya sipsip hir tete avi rë genepesönġ ggök tete yu meneluḳ ya lo, og yi mehö-hodeḳ-ata los beġö-yi. ");
INSERT INTO bzh_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gaḳ mehö sën neyoh ya tete avi lo, og sipsip alaj yi. ");
INSERT INTO bzh_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mehö sën neġin tete avi lo, og netahinin tete avi in bë sipsip alaj doḳ na geḳo sir. Nelem yi sipsip lo arëj ti ti, geyi sipsip denenġo aye medeneyam beneḳo sir to deneya dobnë. ");
INSERT INTO bzh_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Neḳo yi sipsip meto deneya dobnë ggovek, log nemuġin geyi sipsip lo denetamuin yi, in deneraḳ aye ni. ");
INSERT INTO bzh_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Su rëḳ desepa mehö ngwë rë. Gaḳ rëḳ debeya in mehö ngwë in su deraḳ ayej ni rë.” ");
INSERT INTO bzh_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu nër ġaġek peggirinsën sënë vu sir, rëḳ su deraḳ degwa ni rë. ");
INSERT INTO bzh_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nebë saga lom Yesu nër yah ggökin bë, “Sa nanër vu ham yönon rot nabë senġo ti tu sipsip hir tete avi. ");
INSERT INTO bzh_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Alam pin sën demuġin meyam denër bë Anutu vonġ sir yam lo, og sir alam-hodeḳ-ata los beġö-yi. Rëḳ sipsip su denġo ayej rë. ");
INSERT INTO bzh_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Gaḳ senġo ti tu tete avi. Bë mehöti nam vu sa in bë doḳ na tete ayo, og rëḳ medo nivesa, lob doḳ na tete ayo gegeto mena mega nos benah genom noh vu buk pin. ");
INSERT INTO bzh_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mehö-hodeḳ-ata su neyam in nġaa ngwë rë. Gaḳ neyam in bë godeḳ sipsip gengis sir nadiiḳ megevonġ rii jaḳ sir. Gaḳ sa, og seyam in bë demedo malaj-tumsën medemedo los kwaj vesa. ");
INSERT INTO bzh_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Sipsip alaj nivesa sa. Sipsip alaj nivesa, og nediiḳ in doḳ vu yi sipsip lo. Gaḳ hur sën denebaġo yi lo, og su neġin sipsip nivesa rë. ");
INSERT INTO bzh_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","In su sipsip alaj yi soġek rë, om nelë bë anöö bemën neyam, og nevuu sipsip geneveya meneya, ganöö bemën negga sipsip genetii sir ya denepalët loḳ. ");
INSERT INTO bzh_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","In mehö sënë nevonġ huk in baġosën mu gesu kwa nevo sipsip lo rë. ");
INSERT INTO bzh_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Gaḳ sa, og sa sipsip alaj nivesa. Sa naraḳ sa sipsip lo nij, gesa sipsip lo deneraḳ sa niġ, ");
INSERT INTO bzh_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","nebë sën Amaġ raḳ sa niġ geseraḳ Amaġ ni. Om sa nadiiḳ in sedoḳ vu sipsip lo. ");
INSERT INTO bzh_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Log sa sipsip vahi denedo ving, rëḳ su denedo dob Yudea sënë rë. Om sëḳ ġaḳo sir saga geving lom degenġo sayeġ medesepa doḳ. Lob rëḳ sipsip pin denatu yu timu, galaj timu. ");
INSERT INTO bzh_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Amaġ ahë neving sa in sëḳ nadiiḳ in sir. Sëḳ nadiiḳ gesëḳ vesaġ doḳ nah gökin. ");
INSERT INTO bzh_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nabë sa su ngoġekin nabë sa nadiiḳ rë, og mehöti su yoh vu bë rëḳ ngis sa rë. Gaḳ senġo yoġekin bë sëḳ nadiiḳ. Sa niġ wëëk yoh vu bë sa nadiiḳ, gesa niġ wëëk yoh vu bë sëḳ vesaġ doḳ nah gökin. Ġaġek sënë rëḳ anon jaḳ noh vu sën Amaġ nër vu sa lo.” ");
INSERT INTO bzh_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Alam Yuda denġo ġaġek sënë lob devasuh sir ya yu luu ggökin. ");
INSERT INTO bzh_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Balam nġahiseḳë denenër bë, “Memö nipaya gwanġ ya yi, om sën nenër ġaġek jeggin jeggin. Ma nebë va sën ham nebë nengamin vu yi ġaġek-ë?” ");
INSERT INTO bzh_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gela denenër bë, “Nabë memö nipaya nevonġ yi, og su rëḳ nanër ġaġek nabë sënë rë! Bë memö nipaya, og su yoh vu bë gevonġ bemehö mala ḳenod sënë nivesa jaḳ rë!” ");
INSERT INTO bzh_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Neloḳ buk-ayööng-yi og kwaj nevo buk sën dejom raḳ dub-vabuung-böp vu Yerusalem wirek lo bedenegga nos böp neyoh vu ta pin. ");
INSERT INTO bzh_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nebë saga lob Yesu vare neggök dub nenga-gelusën sën denenër bë Solomon yi yi lo, ");
INSERT INTO bzh_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","lob alam Yuda ya denare tetup yi, gedeloḳ tepëḳ vu yi bë, “Rëḳ medo gwevonġ behe ayomin ketul doḳ noh vu buk va la? Bë honġ Kerisi*, og ġenanër ranġah vu he.” ");
INSERT INTO bzh_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Lob Yesu nër yah vu sir bë, “Senër vu ham ggovek ya, rëḳ ham su nevonġ ving rë. Huk pin sën sa nehevonġ raḳ Amaġ niwëëk lo, og saga netato sa ranġah. ");
INSERT INTO bzh_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ham su ayomin neyam timu vu sa rë, in su sa sipsip ham rë. ");
INSERT INTO bzh_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sa sipsip lo, og denenġo sayeġ, gesa naraḳ nij, gedenetamuin sa. ");
INSERT INTO bzh_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Gesëḳ ġevonġ bedemedo malaj-tumsën degwata los degwata gesu rëḳ malaj nama rë. Gemehöti su yoh vu bë rëḳ geḳo sir vër in sa nemaġ rë. ");
INSERT INTO bzh_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Amaġ vonġ sir vu sa, log Amaġ niwëëk rot bekesuu nġaa pin, om mehöti su yoh vu bë rëḳ geḳo sir vër in nema rë. ");
INSERT INTO bzh_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","In alu Amaġ og yiḳ aluu timu.” ");
INSERT INTO bzh_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Lom alam Yuda dejom ġelönġ raḳ in bë detengwa yi menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Loḳ Yesu nër vu sir bë, “Sa tato Amaġ yi huk nivesa vesa nġahiseḳë vu ham, rëḳ ham kwamin nevo sa huk ti tena besën ham bë ngis sa jaḳ ġelönġ-ë?” ");
INSERT INTO bzh_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Loḳ alam Yuda denër yah vu yi bë, “He su kwamin vo huk nivesa ti behe bë angis honġ jaḳ ġelönġ rë! Gaḳ ġenenër ġaġek jeggin jeggin. Honġ mehö dob yi mu, rëḳ ġenër honġ bë honġ Anutu. ");
INSERT INTO bzh_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Lom Yesu nër yah vu sir bë, “Maḳ ġaġek neggëp loḳ horek sën Anutu vo vu ham lo bë, ‘Senër ham bë ham anutu’ ma ma? ");
INSERT INTO bzh_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Anutu nër alam sën vonġ yi ġaġek ya vu sir wirek lo bë sir anutu, om hil su ayoh vu bë mehoo Anutu yi ġaġek sënë rë. ");
INSERT INTO bzh_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Rëḳ ham nër vu Mehö sën Ama ggooin raḳ bevonġ yam dob lo bë nenër ġaġek jeggin jeggin in nër bë Anutu nalu yi! ");
INSERT INTO bzh_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nabë sa su nehevonġ Amaġ yi huk rë, og mëm ham su ayomin nam timu vu sa beyiḳ ggovek. ");
INSERT INTO bzh_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Rëḳ mu sa nehevonġ yi huk, om nabë ham su ayomin nam timu vu sa rë, og ham gwelë huk sën sa nehevonġ-ë lo, lob ham jaḳ ni nabë Amaġ nedo loḳ sa, gesa nado loḳ yi.” ");
INSERT INTO bzh_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Lob devonġ beron ngwë in bë degeḳo na ḳarabus, rëḳ ma geruu sir geto meya. ");
INSERT INTO bzh_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Bemëm yah meya vaseḳ bël Yordan beyah töḳ ya nyëġ sën Jon neripek alam loḳ nyëdahis lo, benedo nyëġ sagu. ");
INSERT INTO bzh_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Lob alam nġahiseḳë deyam vu yi bedenër bë, “Mehö-neripek-alam Jon su vonġ nġaa böp rë, gaḳ ġaġek pin sën nenër raḳ mehö agi, sën anon raḳ.” ");
INSERT INTO bzh_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Lob sir nġahiseḳë ayoj neya timu vu Yesu vu sagu. ");
INSERT INTO bzh_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mehöti arë nebë Lasarus nedo Betania lob niraḳ meneggëp. Betania sën Maria luho ari Marta hir nyëġ lo. ");
INSERT INTO bzh_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Lob Maria sën keseh nġaa reggu nivesa raḳ Yesu vaha gerevu raḳ yu viis lo sën maluhnö Lasarus niraḳ. ");
INSERT INTO bzh_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nebë saga, lob avëhnö luho devonġ ġaġek ya vu Yesu bë, “Mehöböp, mehö sën ahëm neving rot lo, niraḳ!” ");
INSERT INTO bzh_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu nġo bë niraḳ rëḳ nër bë, “Niraḳ, rëḳ mu niraḳsën saga su rëḳ gevonġ menadiiḳ rë! Gaḳ niraḳ in bë tato Anutu niwëëk nam ranġah bAnutu Nalu niwëëk natöḳ nam ranġah geving.” ");
INSERT INTO bzh_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu ahë ving Marta lööho ari Maria lu maluhnö Lasarus rot. ");
INSERT INTO bzh_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Rëḳ nġo bë Lasarus niraḳ lob nedo buk luu ving vu nyëġ sën nedo lo, ");
INSERT INTO bzh_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","loḳ nër vu yi hur maluh bë, “Hil anah mana distrik Yudea.” ");
INSERT INTO bzh_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Lom yi hur maluh denër vu yi bë, “Tatovaha! Alam Yuda nahën denevonġ in bë detengwa honġ jaḳ ġelönġ, log bë ġenah meġena gökin-a?” ");
INSERT INTO bzh_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Lom Yesu nër yah bë, “Hes mala nemadluho-mevidek-luu neggëp yoh vu buk pin, lob bë mehöti na jaḳ ranġah, og su rëḳ taleḳ rë, in nelë nyëġ. ");
INSERT INTO bzh_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ma bë mehöti na doḳ buk, og rëḳ taleḳ in nyëġ malaḳenu.” ");
INSERT INTO bzh_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nër nebë sënë ggovek, loḳ nër vu sir ggökin bë, “Hil mehö Lasarus neggëp yiing rëḳ sëḳ na megee vu yi.” ");
INSERT INTO bzh_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Lob yi hur maluh denër bë, “Mehöböp, nabë neggëp yiing, og rëḳ nivesa jaḳ nah pevis!” ");
INSERT INTO bzh_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","In dekuung bë neggëp yiing mu, gaḳ mu Yesu nër bë Lasarus diiḳ. ");
INSERT INTO bzh_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Lom mëm Yesu tateḳin vu sir bë, “Lasarus diiḳ! ");
INSERT INTO bzh_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Lob sa kwaġ vesa in ham in sa su nado ving yi vu buk saga rë. Nebë saga om ham rëḳ ayomin nam timu vu sa, om hil ana vu yi.” ");
INSERT INTO bzh_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Lom Tomas sën denenër yi nebë Pepid lo, nër vu hur maluh vahi bë, “Maam ham na behil ana, gedengis hil behil nadiiḳ geving yi.” ");
INSERT INTO bzh_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Log mëm Yesu ya beya verup, lob denër vu bë Lasarus ya neggëp bedub yoh vu buk lubeluu ggovek. ");
INSERT INTO bzh_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Lob Betania neggëp dus vu Yerusalem (ading yoh vu kilomita löö). ");
INSERT INTO bzh_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lob alam Yuda nġahi vu Yerusalem bedeyam vu Marta luho Maria in bë degevonġ beluho ayoj nivesa jaḳ doḳ buk sën luho maluhnöj diiḳ lo. ");
INSERT INTO bzh_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nebë saga lom Marta nġo Yesu bengö bë neyam, lob ya nebuu aggata. GeMaria nedo begganġ. ");
INSERT INTO bzh_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Lob Marta nër vu Yesu bë, “Mehöböp, bë ġemedo sënë, og sa maluhnög su rëḳ nadiiḳ rë. ");
INSERT INTO bzh_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Rëḳ seraḳ ni, bë ġekwetaġ nġaa ti vu Anutu og rëḳ bo vu honġ.” ");
INSERT INTO bzh_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Loḳ Yesu nër yah vu yi bë, “Maluhnöm rëḳ kedi jaḳ nah!” ");
INSERT INTO bzh_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Rëḳ Marta nër yah vu bë, “Seraḳ ni bë rëḳ kedi jaḳ nah vu Buk-tamusën, sën alam pin rëḳ dekedi jaḳ nah lo.” ");
INSERT INTO bzh_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Rëḳ Yesu nër bë, “Mehönon dekedi jaḳ nah los demedo malaj-tumsën degwa sa. Mehöti sën ayo nam timu vu sa lo, nabë nadiiḳ, og rëḳ medo mala-tumsën. ");
INSERT INTO bzh_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Galam sën denedo malaj vesa gayoj neyam timu vu sa lo, su rëḳ denadiiḳ bemalaj nama na veröḳ yi rë. Gaḳ rëḳ demedo malaj-tumsën degwata los degwata. Ġevonġ ving ġaġek sënë ma ma?” ");
INSERT INTO bzh_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Lob Marta nër yah vu Yesu bë, “Ëë-ë Mehöböp! Sa hevonġ ving honġ ggovek ya bë Mesia honġ! Anutu Nalu honġ! Mehö sën Anutu nër wirek bë rëḳ duḳ nam dob lo.” ");
INSERT INTO bzh_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta nër bë sënë, log yah tahi ari Maria. Log ya patereng vu yi loḳ begganġ ayo bë, “Tatovaha verup nedo betahi honġ.” ");
INSERT INTO bzh_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria nġo lob kedi raḳ pevis meya vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu su verup begganġ rë, geyö nahën nedo nyëġ len ti sën Marta ya metöḳ vu yi loḳ lo. ");
INSERT INTO bzh_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Lom alam Yuda sën denedo ving Maria ggëp begganġ ayo lo, delë bë kedi raḳ pevis meya dobnë, lob detamuin yi, in dekuung bë neya in bë ngu jaḳ bedub avi. ");
INSERT INTO bzh_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Loḳ Maria töḳ ya nyëġ sën Yesu nedo lo belë yi, lob petev meneggëp loḳ vaha genër vu yi bë, “Mehöböp, bë ġemedo sënë, og sa maluhnög su rëḳ nadiiḳ rë!” ");
INSERT INTO bzh_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu lë bë nesu, gelë alam Yuda deyam ving yi, medenesu ving. Lob kwa paya gayo maggin rot lom loḳ tepëḳ bë, “Ham bë meneggëp tena?” ");
INSERT INTO bzh_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Loḳ denër bë, “Mehöböp, ġenam rëḳ gwelë!” ");
INSERT INTO bzh_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Lob Yesu su. ");
INSERT INTO bzh_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Lob alam Yuda delë medenër bë, “Ham gwelë! Ahë neving mehö sënë rot!” ");
INSERT INTO bzh_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Rëḳ la denenër bë, “Mehö sënë vonġ bemehö mala ḳenod mala nivesa raḳ, om bë berup og maḳ yoh vu bë rëḳ gevonġ beyi mehö sënë medo vesa geving gesu rëḳ nadiiḳ rë, ma su yoh vu rë?” ");
INSERT INTO bzh_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu ayo maggin rot beya meto bedub. Bedub saga yiḳ waaḳ ti gedepeḳa ġelönġ böpata ti ggërin avi. ");
INSERT INTO bzh_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Lob Yesu nër bë, “Ham kwehe ġelönġ saga na!” Loḳ mehö sën diiḳ lo avëhnö Marta nër bë, “Mehöböp! Diiḳ mebuk lubeluu ya ggovek benivë raḳ!” ");
INSERT INTO bzh_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Rëḳ Yesu nër yah vu yi bë, “Senër vu honġ gwëbeng lo bë, nabë gwevonġ geving, og rëḳ gwelë Anutu niwëëk!” ");
INSERT INTO bzh_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Lob mëm dekehe ġelönġ ya, log Yesu vër mala raḳ ya yaġek genër bë, “O Amaġ! Sa ḳetaġ vu honġ beġenġo sa jom-raḳsën ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Seraḳ ni bë ġenenġo sa jom-raḳsën yoh vu buk, rëḳ sa kwaġ nevo alam sën denare agi, gesa nanër sënë in bë dejaḳ ni nabë ġevonġ sa yam.” ");
INSERT INTO bzh_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nër bë sënë log tahi niwëëk bë, “Lasarus! Gweto ġenam dob!” ");
INSERT INTO bzh_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lob mehö diiḳsën Lasarus tur to meyam los tob sën debom yi loḳ lo. Devevir yi loḳ tob ggëp vaha beya metöḳ baġë, gengwë ggërin mala. Lob Yesu nër vu sir bë, “Ham gwepuh tob vër in yi!” ");
INSERT INTO bzh_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Alam Yuda nġahiseḳë sën deyam vu Maria lo, delë nġaa sën Yesu vonġ, lob ayoj ya timu vu yi. ");
INSERT INTO bzh_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Rëḳ sir la yah denër nġaa sën Yesu vonġ agi ranġah vu alam Parisai*. ");
INSERT INTO bzh_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Lob alam-deneḳo-seriveng hir ggev losho Parisai* desupin sir ving Kaunsor medenër bë, “Hil rëḳ ġevonġ nabë tena? In mehö sënë nevonġ nġaa böp böp nġahiseḳë. ");
INSERT INTO bzh_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bë hil aġöneng in yi gegevonġ nabë sënë rot, og rëḳ alam pin ayoj na timu vu yi. Lob alam Rom rëḳ nam dekevoh hil hed dub-vabuung-böp los alam pin.” ");
INSERT INTO bzh_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Loḳ hir mehöti arë nebë Kayapas nedo. Tu alam-deneḳo-seriveng hir ggev böp loḳ ta saga, lob nër vu sir bë, “Ham su neraḳ nġaa ti ni rë. ");
INSERT INTO bzh_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Om sën ham su kwamin töḳ raḳ bë: Nabë mehö timu nadiiḳ doḳ nah alam pin bej, og mëm nivesa rë. In mëm alam pin su malaj nama.” ");
INSERT INTO bzh_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Rëḳ su nër sënë yoh vu yö kwa rë. Gaḳ tu alam-deneḳo-seriveng hir ggev böp loḳ ta ti saga, om yiḳ netu mehö-nenër-ranġahsën ti ving menër ġaġek ranġah raḳ sën Yesu rëḳ nadiiḳ doḳ nah alam Yuda bej lo. ");
INSERT INTO bzh_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Rëḳ mu su rëḳ nadiiḳ in alam Yuda mu rë, gaḳ rëḳ nadiiḳ in ngupin Anutu nalu lo pin sën denedo ya ya, bedenatu degwa timu. ");
INSERT INTO bzh_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Lob dejoo ġaġek venuh loḳ buk sënë bë dengis yi menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Lom Yesu su vare neyoh ranġah loḳ alam Yuda malaj ggökin rë, gaḳ tah meya begganġ-bu ti arë nebë Epraim, sën neggëp dus vu nyëġ-yumeris. Belosho yi hur maluh ya denedo sagu. ");
INSERT INTO bzh_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lob alam Yuda hir Buk-ggöksën-yi* dus raḳ, lob alam nġahiseḳë vu nyëġ pin deraḳ medeya Yerusalem in bë desemu sir in dega nos-ggöksën-yi. ");
INSERT INTO bzh_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Gedenesero Yesu. Denare dub-vabuung-böp yi ḳatum ayo, gedenenër vu sir bë, “Ham kwamin nevo nebë va? Maḳ Yesu su rëḳ nam gelë buk vabuung sënë rë?” ");
INSERT INTO bzh_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Galam-deneḳo-seriveng hir ggev losho alam Parisai* denër ggovek bë, “Bë mehöti raḳ ni bë nedo bë tena, og nanër tato vu he, mehe najom yi ahon.” ");
INSERT INTO bzh_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yesu ya metöḳ ya Betania sën nër bemehö diiḳsën Lasarus kedi raḳ vu bedub lo, gebuk nemadvahi-videk-ti nahën neggëp in bë mëm degelë Buk-ggöksën-yi*. ");
INSERT INTO bzh_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lom devonġ nos böp vu Yesu vu nyëġ sënë, lob Marta neruu nos geLasarus losho vatëveḳ medo denegga nos ving Yesu. ");
INSERT INTO bzh_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Lob Maria ḳo nġaa reggu nivesa buayo böp ti yam. Alam Yuda denerikin nġaa reggu nivesa saga raḳ heljënġ. Arë nebë nart beyi monë böpata rot. Lom Maria rikin raḳ Yesu vaha, gerevu raḳ yu viis, lob nġaa reggu nivesa saga reggu ya tagwaveḳ loḳ begganġ ayo pin. ");
INSERT INTO bzh_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Rëḳ yi hur maluh ti arë nebë Yudas Iskariot, mehö sën rëḳ nanër Yesu ranġah vu alam-beġö-yi lo, nër bë, ");
INSERT INTO bzh_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Hil su bë ġevonġ balam debaġo nġaa reggu nivesa sënë jaḳ K300 in hil adoḳ vu alam-ḳupeḳ-masën jaḳ-a?” ");
INSERT INTO bzh_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Rëḳ su kwa vo alam-ḳupeḳ-masën lo yönon benër rë. Gaḳ mehö-hodeḳ-ata! In neġin Yesu losho yi hur maluh lo hir jej-monë-yi, lom neggodeḳ monë sën denetunġ loḳ lo. ");
INSERT INTO bzh_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Rëḳ Yesu nër bë, “Ham naḳööḳ! Genevonġ tahutahu raḳ sa buk sën dedev sa na lo. ");
INSERT INTO bzh_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Alam-ḳupeḳ-masën rëḳ demedo geving ham gesu rëḳ nama na rë, gaḳ saḳ su rëḳ medo geving ham hus ading rë!” ");
INSERT INTO bzh_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Lob alam Yuda nġahiseḳë deraḳ ni bë Yesu nedo Betania lom deyam vu yi. Rëḳ su deyam in bë degelë Yesu yö ti rë, gaḳ deyam in bë degelë Lasarus sën Yesu nër bekedi raḳ vu bedub lo geving. ");
INSERT INTO bzh_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Lom alam-deneḳo-seriveng hir ggev dejoo ġaġek revuh ti bë dengis Lasarus nadiiḳ geving. ");
INSERT INTO bzh_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","In alam Yuda nġahiseḳë kwaj nevo Lasarus bayoj ya timu vu Yesu gedevuu alam-deneḳo-seriveng ya. ");
INSERT INTO bzh_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Alam nġahiseḳë yam denedo ggovek ya in bë dega nos böp ggöksën-yi, loḳ heng to lom denġo Yesu bengö bë vonġin berup Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Lom deḳo ḳapah meya denebuu yi vu aggata, lob depisek in yi bë: “Hosana! Anutu gevonġ semusemu vu Mehö sën neyam los Mehöböp niwëëk lo! Alam Israel hir mehö-los-bengö!” ");
INSERT INTO bzh_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Lob Yesu töḳ vu dogi meraḳ nedo. Yoh vu sën Anutu-yi-ḳapiya nër lo bë: ");
INSERT INTO bzh_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Alam Sion*-e! Ham su ġöneng in ham rë! Ham gwelë rë! Ham mehö-los-bengö neyök vu ham. Nedo raḳ dogi nalu meneyök!” ");
INSERT INTO bzh_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Vu muġinsën yi hur maluh su deraḳ nġaa sënë degwa ni rë, rëḳ nahub geYesu kedi raḳ garë böp raḳ ggovek, loḳ mëm kwaj vo yah ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo, lom deraḳ ni bë anon raḳ yoh vu. ");
INSERT INTO bzh_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lob alam nġahiseḳë sën denare ving Yesu genër beLasarus kedi raḳ betah yi in waaḳ geto meyom lo, denër bengö ya meya. ");
INSERT INTO bzh_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Lob alam pin ya denebuu yi loḳ aggata, in denġo bengö bë vonġ nġaa böp sënë. ");
INSERT INTO bzh_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Lob Parisai* yah denër vu sir bë, “Kë’! Ham lë! Hil hed ġaġek su rëḳ anon jaḳ rë, in alam pin yah detamuin yi.” ");
INSERT INTO bzh_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Log alam nġahi deraḳ medeya Yerusalem loḳ buk vabuung sënë in bë degeḳo Anutu arë jaḳ gedega nos Buk-ggöksën-yi*. Balam Grik la deya ving, ");
INSERT INTO bzh_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","lob deya vu Pilip sën yi nyëġ Betsaida vu distrik Galilea lo bedeloḳ tepëḳ vu yi bë, “Mehö böp, he bë ġalë Yesu.” ");
INSERT INTO bzh_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Lob Pilip ya menër vu Andreas, lob Andreas luho Pilip ya denër vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Loḳ Yesu nër yah vu luho bë, “Buk sën Mehönon Nalu niwëëk los arë böp natöḳ nam ranġah lo dus raḳ. ");
INSERT INTO bzh_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sa nanër vu ham yönon nabë: Bë hil su ġehin saköm ġahis ti duḳ na dob bemengëḳ na rë, og yiḳ saköm ġahis timu saga beyö rëḳ medo. Rëḳ mu nabë duḳ na dob bemengëḳ na, og rëḳ nakip banon nġahiseḳë berup jaḳ. ");
INSERT INTO bzh_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mehöti bë ahë geving navi vu dob sënë, og rëḳ anon mala nama. Gaḳ mehöti bë nidëlin navi vu dob sënë, og rëḳ medo mala-tumsën degwata. ");
INSERT INTO bzh_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Bë mehöti gevonġin nabë natu sa hur ti, og sepa doḳ sa vahaġ. Lob nyëġ sën sa medo lo, og sa hur lo rëḳ demedo nyëġ saga geving sa. Mehöti bë natu sa hur ti, og rëḳ Anutu geḳo yi jaḳ.” ");
INSERT INTO bzh_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Sayoġ maggin rot, om sëḳ nanër nabë va? Maḳ sëḳ nanër nabë, ‘Amaġ, gweḳo sa vër in nġaa sën vonġin natöḳ vu sa agi’? Ma! Sa su rëḳ nanër nabë sënë rë. Gaḳ seyam sënë in bë sa ġaḳo maggin nabë sënë. ");
INSERT INTO bzh_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Om Amaġ, ġetato nim wëëk los arëm böp na ranġah!” Yesu nër nebë sënë log ġaġek ti yam vu yaġek bë, “Sa tato niġ wëëk los arëġ böp ya ranġah vorot, gesëḳ ġevonġ gökin nah!” ");
INSERT INTO bzh_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Loḳ alam sën denare dus vu lo, denġo lob denër bë, “Vaḳuvek veröp!” Gela denër bë, “Angër ti nër ġaġek vu yi!” ");
INSERT INTO bzh_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Lom Yesu nër vu sir bë, “Ġaġek sënagi su yam in bë bo niwëëk vu sa rë, gaḳ yam in ham. ");
INSERT INTO bzh_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gwëbeng og Anutu joo alam dob sënë hir ġaġek venuh ggovek ya bë rëḳ bo nyëvewen doḳ nah vu sir yönon. Log gwëbeng vonġin juuk dob ala nipaya sën lo na. ");
INSERT INTO bzh_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Dejekö sa jaḳ na vavunë, loḳ mëm sëḳ ġetah alam doḳ mehönon pin medenam vu sa.” ");
INSERT INTO bzh_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu nër ġaġek sënë in bë tato nabë rëḳ dengis yi jaḳ ḳelepeḳo* menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Loḳ alam denër yah vu bë, “He hanġo ġaġek nebë sënë loḳ horek bë Mesia rëḳ medo degwata los degwata. Rëḳ nebë va sën ġenër bë dejekö Mehönon Nalu jaḳ na ḳelepeḳo*-ë? Maḳ Mehönon Nalu sagaḳ re?” ");
INSERT INTO bzh_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Loḳ Yesu nër yah vu sir bë, “Yiḳ Ranġah rëḳ medo geving ham dus teka geving. Lob ham medo mena jaḳ Ranġah sënë doḳ buk sën nahën nedo ving ham agi, in malaḳenu rëḳ gërin ham. Mehöti bë na doḳ malaḳenu, og rëḳ duġin nyëġ sën neyoh lo. ");
INSERT INTO bzh_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Om ham ayomin na timu vu Ranġah sënë doḳ buk sën nahën nedo ving ham agi, log mëm ham nġo rëḳ natu alam dob sënë hir ranġah.” Yesu nër nebë saga ggovek log vuu sir geya mevun yi. ");
INSERT INTO bzh_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu vonġ nġaa böp nġahiseḳë medenelë, rëḳ su ayoj ya timu vu yi rë, ");
INSERT INTO bzh_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","lob mehö-nenër-ġaġek-ranġahsën Yesaya yi ġaġek anon raḳ nebë sënë. Sën kevu meneggëp nebë: “Mehöböp, alam tena devonġ ving alu hed ġaġek-a? Log Mehöböp, re raḳ nim wëëk ni?” ");
INSERT INTO bzh_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Su deyoh vu bë ayoj na timu vu Yesu rë, in ġaġek ngwë sën Yesaya kevu meneggëp lo anon jaḳ geving. Sën nebë: ");
INSERT INTO bzh_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Anutu kebu malaj, gevonġ kwaj ma in sir, in bë su rëḳ degelë nġaa jaḳ malaj los kwaj bo bedejaḳ ni rë, log su deyoh vu bë degërin ayoj nom vu sa, besa ġevonġ nijvesa jaḳ rë. Gerëḳ nama!” ");
INSERT INTO bzh_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya lë Yesu niwëëk los vuneḳ vuneḳ yaġek yi wirek, lom nër ġaġek saga raḳ yi. ");
INSERT INTO bzh_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Rëḳ mu alam nġahiseḳë ayoj ya timu vu yi, geggev la ving. Rëḳ deneggönengin alam Parisai*, lom su denër ranġah rë, in kwaj nevo bë rëḳ dejuuk sir in dub-supinsën-yi. ");
INSERT INTO bzh_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Om su ahëj ving panġsën bë Anutu geḳo arëj jaḳ rë. Gaḳ mëm ahëj ving panġsën rot bë mehönon yö degeḳo arëj jaḳ. ");
INSERT INTO bzh_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Lom Yesu tahi ya ranġah bë, “Mehöti sën ayo nam timu vu sa lo, og su ayo neyam timu vu senġo ti rë. Gaḳ ayo neya timu vu Mehö sën vonġ sa meseyam lo ving. ");
INSERT INTO bzh_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Gemehöti sën gelë sa lo, og nelë Mehö sën vonġ sa meseyam lo ving. ");
INSERT INTO bzh_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Seluḳ yam dob sënë nebë ranġah in bë alam pin sën ayoj nam timu vu sa lo su demedo doḳ malaḳenu. ");
INSERT INTO bzh_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Bë mehöti genġo sa ġaġek rëḳ su gevonġ banon jaḳ rë, og sa su rëḳ ġevonġ nyëvewen doḳ nah vu yi rë. In sa su yam dob in bë ġevonġ nyëvewen vu mehönon rë gaḳ seyam in bë ġaḳo sir nom. ");
INSERT INTO bzh_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mehöti bë geruu demi vu sa gesu gebë nenga vu sa ġaġek rë, og nġaa sën rëḳ seggi yi betateḳin nabë vonġ paya lo nedo. Yiḳ ġaġek sën sa nanër lo. Rëḳ seggi yi menanër nabë geḳo nyëvewen nipaya doḳ nah vu Buk-tamusën. ");
INSERT INTO bzh_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","In sa su nehevonġ ġaġek yoh vu senġo kwaġ rë. Gaḳ Amaġ sën vonġ sa meseyam lo, yö nër ġaġek pin sënë vu sa bë sa ġevonġ los nanër. ");
INSERT INTO bzh_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nër vu sa bë sa nanër yi ġaġek vu ham in ham medo malamin-tumsën degwata, geseraḳ ni bë yi ġaġek saga yönon om sën senër.” ");
INSERT INTO bzh_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Alam Yuda hir Buk-vabuung-ggöksën-yi yö nahën geYesu raḳ ni bë buk dus raḳ ggovek ya bë gevuu dob sënë genah vu Ama. Ahë neving yö yi alam sën denedo dob sënë vu muġinsën rot meya verup loḳ buk sën diiḳ lo. ");
INSERT INTO bzh_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Medo denegga nos sehuksën loḳ Satan loḳ ya Yudas Iskariot sën Simon nalu lo ayo ggovek ya bë gevonġ Yesu doḳ na alam Yuda nemaj. ");
INSERT INTO bzh_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Rëḳ Yesu yö raḳ ni ggovek ya bë Ama lëëin nġaa pin loḳ ya nema, beraḳ ni ving bë Anutu vonġ yi yam, gerëḳ nah mena vu Anutu gökin. ");
INSERT INTO bzh_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Lom Yesu kedi raḳ vu tevor mekah yi röpröp ngwë sën neröp ggök vavunë lo ya, log ḳo taor ti bevëh neggëp balo, ");
INSERT INTO bzh_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","log keseh bël loḳ ya perë böp ti betunġ ya, generipek yi hur maluh vahaj, generevu raḳ taor sën vëh neggëp balo lo. ");
INSERT INTO bzh_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Lob neripek vahaj meverup loḳ Simon Pita. Lom Pita nër vu yi bë, “Mehöböp, bë ġejipek sa vahaġ-a?” ");
INSERT INTO bzh_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Lob Yesu nër yah vu bë, “Gwëbeng og su ġeraḳ nġaa sën sa nehevonġ agi ni rë. Gaḳ nahub rëḳ rëḳ gejaḳ ni.” ");
INSERT INTO bzh_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Loḳ Pita nër yah vu bë, “Su rëḳ ġejipek sa vahaġ rë! Gaḳ rëḳ nama!” Rëḳ Yesu nër yah vu yi bë, “Bë sa su jipek vaham rë, og alu su rëḳ nemad doḳ ti in huk rë.” ");
INSERT INTO bzh_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Lob Simon Pita nër yah bë, “Om Mehöböp, su ġejipek sa vahaġ mu, gaḳ ġejipek sa nemaġ los sa yuġ geving!” ");
INSERT INTO bzh_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Rëḳ Yesu nër bë, “Mehöti sën ripek yi ggovek lo, og yiḳ rëḳ jipek vaha mu gökin, gaḳ anon pin niveseek raḳ ggovek ya, rëḳ mu su ham pin rë.” ");
INSERT INTO bzh_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","In Yesu raḳ ni ggovek ya bë mehö saga rëḳ nanër yi ranġah vu alam Yuda hir ggev, lom mëm nër bë, “Ham pin su nimin veseek raḳ rë!” ");
INSERT INTO bzh_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu ripek vahaj ggovek, log röp yi röpröp yah geto nedo. Log nër vu sir bë, “Maḳ ham raḳ nġaa sën sa hevonġ vu ham-ë ni? ");
INSERT INTO bzh_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ham nenër sa nebë Tatovaha los Mehöböp, lob ham nër yoh vu in sa nebë saga. ");
INSERT INTO bzh_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ham Mehöböp los Tatovaha sa, rëḳ seripek ham vahamin. Om ham jipek arimin lo vahaj geving nabë saga. ");
INSERT INTO bzh_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","In gwëbeng sa tato tahutahu vu ham, om ham gwevonġ nabë sën sa hevonġ vu ham-ë. ");
INSERT INTO bzh_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sa nanër vu ham yönon rot nabë: Hur ti su kesuu ala rë. Genabë mehöti gevonġ ngwë geḳo ġaġek mena, og ngwë sën ḳo ġaġek meneya lo, su kesuu mehö sën vonġ yi ya lo rë. ");
INSERT INTO bzh_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bë ham jaḳ nġaa saga ni, beham gwevonġ nabë saga, og rëḳ ham kwamin vesa. ");
INSERT INTO bzh_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Sa su nanër raḳ ham pin rë, gaḳ senġo raḳ alam sën sehooin sir raḳ tu sa alam ggovek lo nij. Rëḳ ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo anon jaḳ. Ġaġek sën nër nebë: Mehö sën negga nos ving sa, vër vaha raḳ in baḳë sa. ");
INSERT INTO bzh_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ġaġek sën sa nanër vu ham lo su anon raḳ rë geyö nahën, rëḳ sa nanër vu ham namuġin in bë nahub rëḳ natöḳ ranġah, lob ham rëḳ gwevonġ geving sa nabë yiḳ Mehö lo sënë. ");
INSERT INTO bzh_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sa nanër vu ham yönon rot nabë: Mehöti bë gevonġ nivesa vu mehö sën sa ġevonġ nök lo, og mehö saga vonġ nivesa vu sa nebë saga. Log mehöti bë gevonġ nivesa vu sa, og vonġ nivesa vu Mehö sën vonġ sa meseyam lo ving.” ");
INSERT INTO bzh_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu nër nebë saga ggovek, log ayo maggin genër bë, “Sa nanër vu ham yönon nabë ham sënë ti rëḳ gevonġ sa doḳ na alam sën denelë sa paya lo nemaj.” ");
INSERT INTO bzh_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Lom yi hur maluh degët sir meyah meyom in sir duġin mehö sën Yesu nër ġaġek raḳ yi lo. ");
INSERT INTO bzh_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Log hur maluh ti sën Yesu ahë neving yi lo nedo dus vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Lob Simon Pita të kwa in genër vu bë, “Ġedoḳ tepëḳ vu yi nabë nenër re!” ");
INSERT INTO bzh_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Lob kepë yi yah dus vu Yesu genër vu bë, “Mehöböp, ġenenër re saga?” ");
INSERT INTO bzh_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Lob Yesu nër yah vu bë, “Rëḳ sa daġoo nos teka sënë doḳ ġabum besebo vu yi. Og yiḳ mehö lo sënë.” Lob daġoo nos ḳemu teka loḳ ġabum bevo vu Yudas sën Simon Iskariot nalu. ");
INSERT INTO bzh_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudas vo nos vër ggovek log pevis geSatan loḳ ya ayo. Yesu nër vu bë, “Nġaa sën bë gwevonġ lo, og gwevonġ pevis.” ");
INSERT INTO bzh_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Lom sir pin sën medo denegga nos los reggu saga lo sir ti su raḳ ġaġek sën Yesu nër agi degwa ni rë. ");
INSERT INTO bzh_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Deraḳ ni bë Yudas neġin jej-monë-yi, lom vahi kwaj nevo bë maḳ Yesu nër vu bë na baġo nos-buk-vabuung-yi borot. Ma, maḳ nër vu bë bo nġaa vu alam sën deneraḳ vu in nġaa lo. ");
INSERT INTO bzh_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Log Yudas gga nos teka saga ggovek, log pevis meto meyah dobnë. To meyah log buk loḳ. ");
INSERT INTO bzh_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas to meyah dobnë ggovek, log Yesu nër bë, “Gwëbeng Mehönon Nalu niwëëk los arë böp töḳ yam ranġah ggovek ya, log Mehönon Nalu vonġ bAnutu niwëëk los arë böp töḳ yam ranġah ving. ");
INSERT INTO bzh_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yönon, vonġ bAnutu niwëëk los arë böp töḳ yam ranġah, om Anutu rëḳ gevonġ beMehönon Nalu niwëëk los arë böp natöḳ nam ranġah geving, om vonġin gevonġ pevis. ");
INSERT INTO bzh_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Naluġ lo! Sa medo geving ham teka rë, loḳ ham rëḳ sero sa nabë sën senër vu alam Yuda wirek lo nebë, ‘Ham su yoh vu bë rëḳ na nyëġ sën sëḳ na-ë rë.’ ");
INSERT INTO bzh_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Sa bë bo horek mewis ti vu ham nabë: Ham ahëmin geving ham. Ham ahëmin geving ham nabë sën sahëġ neving ham lo. ");
INSERT INTO bzh_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bë ham ahëmin geving ham nabë sënë, og rëḳ alam pin dejaḳ ni nabë sa hur ham.” ");
INSERT INTO bzh_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Loḳ Simon Pita loḳ tepëḳ vu yi bë, “Mehöböp, rëḳ ġena tena?” Lom Yesu nër yah vu bë, “Su ġeyoh vu bë rëḳ ġesepa sa meġenam nyëġ sën sena-ë rë. Gaḳ nahub rë, loḳ rëḳ ġetamuin sa.” ");
INSERT INTO bzh_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Rëḳ Pita nër bë, “Mehöböp! Sa su rëḳ sepa honġ mena pehi rë in va? Sëḳ nadiiḳ in honġ!” ");
INSERT INTO bzh_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Lob Yesu nër yah bë, “Rëḳ ġenadiiḳ in sa yönon-a? Sa nanër vu honġ yönon rot nabë pehi sënë og ḳöḳrëëh su rëḳ ngu rë, log rëḳ ġedah sa vun beron löö!” ");
INSERT INTO bzh_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ham su ġöneng in ham. Ham ayomin na timu vu Anutu, gayomin nam timu vu sa geving. ");
INSERT INTO bzh_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Amaġ yi begganġ los ayo nġahiseḳë neggëp. Bë nama, og sa su rëḳ nanër vu ham wirek nabë sena ġero nyëġ vu ham rë. ");
INSERT INTO bzh_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Rëḳ nyëġ neggëp, om sën sena ġero vu ham govek rë, loḳ mëm senom meġaḳo ham jaḳ geving sa in nyëġ sën sa medo lo, og ham rëḳ medo geving. ");
INSERT INTO bzh_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Log nyëġ sën sa bë na lo, og ham raḳ yi aggata ni ggovek.” ");
INSERT INTO bzh_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Rëḳ Tomas nër yah vu yi bë, “Mehöböp, ġena tena? He duġin! Lob he rëḳ ajaḳ aggata saga ni nabë va?” ");
INSERT INTO bzh_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Lom Yesu nër vu yi bë, “Aggata sa, geġaġek anon los mala-tumsën degwa sa. Mehöti su rëḳ noh aggata ngwë mena vu Amaġ rë, gaḳ rëḳ nama! Gaḳ yiḳ senġo timu. ");
INSERT INTO bzh_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bë ham jaḳ sa niġ, og ham raḳ Amaġ ni ving. Gwëbeng ham raḳ ni, in ham lë yi ggovek.” ");
INSERT INTO bzh_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Rëḳ Pilip nër yah vu bë, “Mehöböp, ġetato Amam vu he, loḳ mëm he kwamin vesa.” ");
INSERT INTO bzh_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Rëḳ Yesu nër yah vu bë, “Pilip! Sa nado hus adingseḳë rot ving ham, rëḳ nġo ġenahën gesu ġeraḳ sa niġ rë? Alam sën delë sa lo, og yiḳ nebë delë Amaġ. Ma ġenër bë ‘Ġetato Amam vu he’ in va? ");
INSERT INTO bzh_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ma su ġevonġ ving bë Amaġ nedo loḳ sa gesa nado loḳ Amaġ rë? Ġaġek sën sa nanër vu ham lo, og sa su nehevonġ yoh vu senġo kwaġ rë, gaḳ Amaġ sën nedo loḳ sa lo yö nevonġ yi huk. ");
INSERT INTO bzh_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ham gwevonġ geving sa ġaġek sënë nabë sa nado loḳ Amaġ, gAmaġ nedo loḳ sa! Bë nama, og ham kwamin bo huk pin sën sa nehevonġ lo, lom ham gwevonġ geving saga. ");
INSERT INTO bzh_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sa nanër vu ham yönon rot nabë: Bë mehöti ayo nam timu vu sa, og yiḳ rëḳ gevonġ huk pin nabë sën sa nehevonġ agi geving. Log rëḳ gevonġ huk böpata rot kesuu sehöġ, in sa nayah vu Amaġ. ");
INSERT INTO bzh_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Log nġaa pin sën ham kwetaġ in jaḳ sarëġ lo, og sëḳ ġevonġ vu ham, in sa ġevonġ bAmaġ niwëëk los arë böp natöḳ nam ranġah nabë saga. ");
INSERT INTO bzh_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bë ham kwetaġ in nġaa jaḳ sarëġ, og sëḳ ġevonġ vu ham.” ");
INSERT INTO bzh_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Bë ham ahëmin geving sa, og rëḳ ham sepa doḳ sa horek. ");
INSERT INTO bzh_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Lob sëḳ ḳetaġ na vu Amaġ, lob rëḳ gevonġ ham Mehö ngwë nam in ġadu ham los gevonġ niwëëk vu ham, gerëḳ medo geving ham degwata los degwata. Mehö sënë yiḳ yi Anon Vabuung beġaġek anon ala yi. ");
INSERT INTO bzh_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Alam sën denesepa loḳ aggata-dob-yi lo, og su deyoh vu bë degeḳo yi rë, in su delë yi bederaḳ ni rë. Rëḳ hameḳ ham raḳ ni. In nedo ving ham, geloḳ nedo ham ayomin. ");
INSERT INTO bzh_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Sa su rëḳ ġevuu ham meham medo kwetul doḳ nabë hur meten rë. Gaḳ sëḳ nom vu ham. ");
INSERT INTO bzh_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Buk su hus ading rë galam sën denesepa loḳ aggata-dob-yi lo pin su rëḳ degelë sa gökin rë, gaḳ hameḳ rëḳ gwelë sa. Sa nado malaġ-tumsën, om ham rëḳ medo malamin-tumsën geving. ");
INSERT INTO bzh_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Doḳ buk saga og ham rëḳ jaḳ ni nabë sa nado loḳ Amaġ, geham nedo loḳ sa, gesa nado loḳ ham. ");
INSERT INTO bzh_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mehöti sën geḳo sa horek mesepa doḳ nivesa lo, og mehö sënë ahë neving sa. Lom bë mehöti ahë geving sa, og Amaġ rëḳ ahë geving yi, gesahëġ geving yi geving, gesëḳ tateḳin sa vu yi bejaḳ sa niġ.” ");
INSERT INTO bzh_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesu nër nebë sënë, lom mehö ngwë arë nebë Yudas, saga su Iskariot rë, nër vu Yesu bë, “Mehöböp, ġenër va saga? Sën bë ġetato honġ ranġah vu he gesu rëḳ ġetato honġ vu alam sën denesepa loḳ aggata-dob-yi lo rë-ë? Saga nabë va?” ");
INSERT INTO bzh_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Loḳ Yesu nër yah vu bë, “Bë mehöti ahë geving sa, og rëḳ sepa doḳ sa ġaġek megero, lob mëm Amaġ rëḳ ahë geving yi, galu rëḳ anam medo geving yi. ");
INSERT INTO bzh_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mehöti bë su ahë geving sa rë, og su rëḳ sepa doḳ sa ġaġek rë. Ġaġek sën ham nenġo lo, og su senġo ti sa nġaa rë, gaḳ yam ggëp Amaġ sën vonġ sa meseyam lo. ");
INSERT INTO bzh_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Sa nahën nado ving ham gesenër ġaġek sënë vu ham. ");
INSERT INTO bzh_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Gaḳ Mehö sën doḳ vu ham anon lo, sagaḳ Anon Vabuung sën Amaġ rëḳ gevonġ nom los sa niġ wëëk doḳ nah sa böġ lo, og rëḳ tateḳin nġaa pin vu ham los bër ham kwamin jaḳ beham kwamin bo nġaa pin sën senër vu ham. ");
INSERT INTO bzh_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Sa bë na jaḳ om sa ġevonġ beham ayomin geto revuh. Sa nehevonġ beham ayomin neto revuh nebë sën sayoġ neggëp revuh lo. Alam sën denesepa loḳ aggata-dob-yi lo, og su deyoh vu bë degevonġ beham ayomin geto revuh rë, gaḳ saḳ seyoh vu om sa nehevonġ. Om mëm ham su newamin jaḳ, geham su ġöneng in ham. ");
INSERT INTO bzh_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ham nġo sa ġaġek sën senër vu ham bë sa ġevuu ham gesena rëḳ sëḳ nom vu ham. Bë ham ahëmin neving sa, og ham kwamin vesa in sa naya vu Amaġ, in Amaġ og böp bekesuu sa. ");
INSERT INTO bzh_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ġaġek sënë yö nahën gesa nanër vu ham namuġin, in nabë anon jaḳ og ham jaḳ ni. ");
INSERT INTO bzh_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sa su rëḳ nanër ġaġek panġsën rot vu ham rë, in dob sënë ala nipaya vonġin berup, rëḳ mu su yoh vu bë rëḳ kepë sa rë. ");
INSERT INTO bzh_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sa bë alam sën denesepa loḳ aggata-dob-yi lo dejaḳ ni nabë sahëġ neving Amaġ, gesa nehevonġ nġaa yoh vu ġaġek sën Amaġ vonġ vu sa meseyam in lo. Om ham kwedi jaḳ mehil ana!” ");
INSERT INTO bzh_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Wain jes degwaseḳë soġek sa, gAmaġ tu wain ala. ");
INSERT INTO bzh_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Sa nemaġ pin sën su denesis anoj rë lo, og Amaġ neketöv vër menetë ya, gesa nemaġ nivesa pin sën denesis anoj lo, og neketöv dus genetonġin, in bë dengis anoj nġahiseḳë rot. ");
INSERT INTO bzh_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lob ġaġek sën senër vu ham ggovek lo, tonġin ham ggovek ya nebë saga. ");
INSERT INTO bzh_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ham medo doḳ sa, loḳ mëm sëḳ medo doḳ ham. Bë ham su medo doḳ sa rë, og ham su rëḳ ngis anomin rë. Sa tahu raḳ nema sën su raḳ nare jes rë lo, in saga su yoh vu bë ngis anon rë. ");
INSERT INTO bzh_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Wain jes sa, genema ham. Mehöti sën nedo loḳ sa gesa nado loḳ yi lo, og rëḳ ngis anon nġahiseḳë rot. Bë sa su medo geving ham rë, og ham su yoh vu bë rëḳ gwevonġ nġaa ti niröp rë. ");
INSERT INTO bzh_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mehöti bë su medo doḳ sa rë, og rëḳ mala nama nabë wain nema sën deneketöv vër benebebov ya lob denesupin beya denevesi raḳ ya nengwah lo. ");
INSERT INTO bzh_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nabë ham medo doḳ sa gesa ġaġek medo doḳ ham yönon, lom nabë ham ahëmin geving nġaa ti bekwetaġ, og rëḳ ham gweko. ");
INSERT INTO bzh_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Bë ham ngis anomin nġahiseḳë, og saga rëḳ geḳo Amaġ arë jaḳ los tato niwëëk, lob ham rëḳ natu sa hur. ");
INSERT INTO bzh_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Sahëġ neving ham nebë sën Amaġ ahë neving sa, om ham su gwetah ham vër in sa ahëġ-vingsën saga. ");
INSERT INTO bzh_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bë ham sepa doḳ sa horek, og sëḳ ahëġ geving ham panġsën, nabë sën sa nesepa loḳ Amaġ yi horek, gahë neving sa panġsën lo. ");
INSERT INTO bzh_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Senër ġaġek pin sënagi yök vu ham, in bë ham kwamin vesa nabë sa, beham kwamin-vesasën gërin ham ayomin los dahis. ");
INSERT INTO bzh_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Sa horek nebë: Ham ahëmin geving ham nabë sën sahëġ neving ham. ");
INSERT INTO bzh_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mehöti bë nadiiḳ doḳ nah yi alam lo bej, og ahë neving sir kesuu sën mehönon pin ahëj neving hir alam lo. ");
INSERT INTO bzh_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Log nabë ham sepa doḳ sa horek sën sevo vu ham lo, og ham tu salam yönon. ");
INSERT INTO bzh_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Om sa su rëḳ nanër ham gökin nah nabë sa hur meris ham rë, in hur meris og sir duġin huk sën alaj kwa nevo bë gevonġ lo. Gaḳ senër ham bë ham tu sa alam soġek, in nġaa pin sën sa nehanġo ggëp Amaġ lo, og senër ranġah vu ham ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ham su hooin sa raḳ rë, gaḳ sehooin ham raḳ mehevonġ ham ya in bë ham ngis anomin nġahiseḳë beham anomin saga medo degwata. Lom nabë ham kwetaġ nġaa ti jaḳ sarëġ vu Amaġ, og rëḳ bo vu ham. ");
INSERT INTO bzh_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Lob sa horek nebë sënë: Ham ahëmin geving ham!” ");
INSERT INTO bzh_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Alam sën denesepa loḳ aggata-dob-yi lo, bë ahëj sengën vu ham, og ham jaḳ ni nabë ahëj sengën vu sa nebë saga muġin. ");
INSERT INTO bzh_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bë ham degwa vu dob, og rëḳ alam sën denesepa loḳ aggata-dob-yi lo ahëj geving ham, in ham los degwa timu. Rëḳ ma geham su degwa vu dob rë. Sehooin ham raḳ loḳ alam sën denesepa loḳ aggata-dob-yi lo, om sën ahëj sengën vu ham. ");
INSERT INTO bzh_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ham kwamin bo ġaġek sën senër vu ham lo bë: Hur ti su kesuu ala rë. Dedeġinengin sa raḳ nġaa maggin, om rëḳ dedeġinengin ham jaḳ nġaa maggin nabë saga geving. Gaḳ bë desepa doḳ sa ġaġek, og rëḳ desepa doḳ ham ġaġek geving. ");
INSERT INTO bzh_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Rëḳ mu mehönon rëḳ degevonġ nij paya vu ham in salam ham, in su deraḳ Mehö sën vonġ sa meseyam lo ni rë. ");
INSERT INTO bzh_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bë sa su nam nanër ġaġek ranġah vu sir rë, og su rëḳ degeruu demij vu sa benġaa nipaya gëp vu sir rë. Rëḳ seyam nër vu sir, om gwëbeng sënë su yoh vu bë dedahun jaḳ hir nġaa nipaya rë. ");
INSERT INTO bzh_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mehöti bë gelë sa paya, og nelë Amaġ paya ving nebë saga. ");
INSERT INTO bzh_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nġaa böp böp sën mehöti su vonġ wirek rë lo, bë sa su nam ġevonġ medegelë rë, og su rëḳ degeruu demij vu sa benġaa nipaya gëp vu sir rë. Rëḳ delë bë sa nehevonġ nġaa böp nġahiseḳë nebë sënë, lom nahën denelë alu Amaġ paya. ");
INSERT INTO bzh_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nebë saga in bë ġaġek sën dekevu meneggëp loḳ hir horek lo anon jaḳ nabë: Denelë sa paya meris mu gedegwa ma. ");
INSERT INTO bzh_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Lob Mehö-dok-vu-ham, Anon Vabuung ġaġek-anon-yi sën yam vu Amaġ lo, sën sëḳ ġevonġ vu Amaġ menom vu ham lo, og rëḳ tateḳin sa degwa. ");
INSERT INTO bzh_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Geham rëḳ tateḳin sa degwa ranġah nabë saga geving, in ham nedo ving sa vu muġinsën mejom ahon menedo. ");
INSERT INTO bzh_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Senër ġaġek sënë vu ham in bë ham su bës bemalamin nama. ");
INSERT INTO bzh_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Alam rëḳ dejuuk ham in hir dub-supinsën-yi, gebuk rëḳ berup lob dengis ham beham nadiiḳ, gerëḳ degekuung nabë sagaḳ denevonġ Anutu yi huk. ");
INSERT INTO bzh_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Rëḳ degevonġ nġaa saga pin in su deraḳ Amaġ ni rë, besu deraḳ sa niġ rë. ");
INSERT INTO bzh_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Om senër ġaġek saga vu ham vorot, in nabë buk saga natöḳ vu ham, og ham kwamin bo nah ġaġek sën senër vu ham lo.” ");
INSERT INTO bzh_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Vu muġinsën sa su nër ġaġek nebë sënë vu ham rë, in sa nahën nado ving ham. Log gwëbeng sa bë nah mena vu Mehö sën vonġ sa meseyam lo, rëḳ ham ti su loḳ tepëḳ in sa bë, ‘Ġëya tena?’ rë, gema. ");
INSERT INTO bzh_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Senër ġaġek saga vu ham gwëbeng, lob ham ayomin maggin rot. ");
INSERT INTO bzh_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Rëḳ sa nanër ġaġek anon sënë vu ham bë sa nayah in bë doḳ vu ham. Bë sa su nah rë, og ham Mehö sën doḳ vu ham lo su rëḳ nom vu ham rë. Gaḳ senah loḳ mëm sëḳ ġevonġ nom vu ham. ");
INSERT INTO bzh_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mehö saga rëḳ nam, lob rëḳ tateḳin vu alam sën denesepa loḳ aggata-dob-yi lo nabë nġaa nipaya neggëp vu sir, genġaa nivesa neggëp vu sa, lob rëḳ tateḳin nabë nyëvewen rëḳ natöḳ vu sir. ");
INSERT INTO bzh_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Rëḳ tateḳin nabë nġaa nipaya neggëp vu sir in su ayoj neyam timu vu sa rë. ");
INSERT INTO bzh_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Gerëḳ tateḳin nabë nġaa nivesa neggëp vu sa, in seyah meya vu Amaġ geham su nelë sa ggökin yah rë. ");
INSERT INTO bzh_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Gerëḳ tateḳin nabë denatöḳ vu nyëvewen in Anutu nër ggovek bë dob sënë ala nipaya rëḳ natöḳ vu yi nġaa nipaya nyëvewen. ");
INSERT INTO bzh_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Sa ġaġek nġahiseḳë rot sën sa bë nanër vu ham lo neggëp, rëḳ ham nahën gesu yoh vu bë ham jaḳ ni venuh rë. ");
INSERT INTO bzh_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Gaḳ mëm Anon Vabuung ġaġek-anon-yi nam lo, lob mëm rëḳ tateḳin ġaġek anon los dahis vu ham beham jaḳ ni. In su rëḳ nanër yö yi ġaġek rë. Gaḳ ġaġek sën nġo lo, sën rëḳ nanër, gerëḳ nanër ġaġek sën nahën gesu anon raḳ rë lo ranġah vu ham borot. ");
INSERT INTO bzh_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Rëḳ geḳo sarëġ jaḳ, in rëḳ geḳo ġaġek vu sa benom nanër ranġah vu ham. ");
INSERT INTO bzh_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Amaġ yi nġaa pin tu sa nġaa, om sën senër raḳ Mehö saga bë rëḳ geḳo ġaġek vu sa menom nanër ranġah vu ham.” ");
INSERT INTO bzh_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Buk su rëḳ hus ading rë lob ham su yoh vu bë rëḳ gwelë sa rë, log buk su rëḳ hus ading rë gaḳ ham rëḳ gwelë sa gökin.” ");
INSERT INTO bzh_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Lob yi hur maluh lo yö deloḳ tepëḳ vu sir bë, “Nenër ġaġek va sënë? Bë, ‘Buk su rëḳ hus ading rë lob hil su ayoh vu bë rëḳ ġalë yi rë, log buk su rëḳ hus ading rë lob hil rëḳ ġalë yi gökin-ë.’ Log nër ving bë neya vu Ama-ë? ");
INSERT INTO bzh_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nër bë buk su rëḳ hus ading rë sënë degwa nebë va? Hil duġin yi ġaġek saga!” ");
INSERT INTO bzh_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Lom Yesu raḳ ni bë denevonġin bë dedoḳ tepëḳ in yi, lom nër vu sir bë, “Ham neloḳ tepëḳ in ham in sa ġaġek saga sën senër bë buk su rëḳ hus ading rë lob ham su yoh vu bë rëḳ gwelë sa rë, log buk su rëḳ hus ading rë lob ham rëḳ gwelë sa gökin. ");
INSERT INTO bzh_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sa nanër vu ham yönon rot nabë: Ham rëḳ ngu böpata, gekwamin paya paya, galam sën denesepa loḳ aggata-dob-yi lo rëḳ kwaj vesa. Ham rëḳ kwamin paya, rëḳ mu ham kwamin paya saga rëḳ gërin natu kwamin vesa. ");
INSERT INTO bzh_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Avëh ti bë bimeng in geḳo nalu, og ayo maggin rot in vanë töḳ vu yi, loḳ nabë mëm geḳo nalu govek lo, og mëm su rëḳ kwa bo vanë lo gökin nah rë, gaḳ kwa vesa in ḳo nalu metu yi nġaa ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Lob ham nebë saga. Ham ayomin maggin gwëbeng, rëḳ sëḳ ġalë ham gökin, lob mëm ham rëḳ kwamin vesa rot gemehönon su deyoh vu bë degevonġ beham kwamin paya gökin nah rë. ");
INSERT INTO bzh_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Vu buk agu ham su rëḳ doḳ tepëḳ in nġaa ti nah vu sa rë. Sa nanër vu ham yönon rot nabë: Bë ham kwetaġ nġaa ti vu Amaġ jaḳ sarëġ, og rëḳ gevonġ vu ham. ");
INSERT INTO bzh_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Wirek ham su kwetaġ nġaa ti raḳ sarëġ rë. Bë ham kwetaġ, og ham rëḳ gweḳo lom ham kwamin vesa rot.” ");
INSERT INTO bzh_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Senër ġaġek pin sënë vu ham raḳ ġaġek peggirinsën mu. Gaḳ buk vonġin berup, lob sa su rëḳ nanër vu ham jaḳ ġaġek peggirinsën gökin rë, gaḳ sëḳ nanër Amaġ degwa gëp ranġah vu ham. ");
INSERT INTO bzh_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lob buk saga bë berup, og rëḳ ham kwetaġ nġaa vu yi jaḳ sarëġ. Sa su nër bë sëḳ ḳetaġ vu Amaġ in ham rë, ");
INSERT INTO bzh_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","in Amaġ yö kwa pesivin ham, in ham ahëmin neving sa geham vonġ ving bë sa nado vu Anutu beseyam. ");
INSERT INTO bzh_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sa nado ving Amaġ beseluḳ yam dob. Log sa hevonġin ġevuu dob sënë, gesenah mena vu Amaġ gökin.” ");
INSERT INTO bzh_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Lob yi hur maluh denër yah vu yi bë, “Kë! Mëm gwëbeng ġenër neggëp ranġah, gesu ġenër raḳ ġaġek peggirinsën rë. ");
INSERT INTO bzh_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gwëbeng he raḳ ni ggovek bë ġeraḳ nġaa pin ni meġenedo. Su honġ duġin mehönon hir tepëḳ rëḳ mehö la denër vu honġ rë. Sënë vonġ behe hevonġ ving bë Anutu vonġ honġ yam.” ");
INSERT INTO bzh_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Lom Yesu nër yah vu sir bë, “Gwëbeng ham vonġ ving sa? ");
INSERT INTO bzh_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Om ham gwenġo rë! Buk dus raḳ, lob töḳ yam ggovek ya, geham rëḳ kwetëḳin beham ti ti nah mena bömin, gesenġo perurek timu rëḳ medo. Rëḳ sa su perurek timu nġo rëḳ medo rë, in Amaġ nedo ving sa. ");
INSERT INTO bzh_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Senër ġaġek pin sënë vu ham in bë ham kwamin bo sa gemëm ayomin geto revuh. Vu dob sënë nġaa maggin rëḳ deġinengin ham, rëḳ mu ham su newamin jaḳ, in sa ḳepë dob sënë ala nipaya ya ggovek ya.” ");
INSERT INTO bzh_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu nër saga ggovek log varah mala raḳ yaġek gejom raḳ bë: “Amaġ, buk verup ggovek ya, om ġetato nalum niwëëk los arë böp natöḳ nam ranġah in lob mëm nalum gevonġ benim wëëk los arëm böp natöḳ nam ranġah. ");
INSERT INTO bzh_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ġevonġ besetu mehönon pin alaj in bë sa ġevonġ balam pin sën ġevonġ sir vu sa lo demedo malaj-tumsën degwata los degwata. ");
INSERT INTO bzh_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Log nabë dejaḳ nim nabë Anutu anon perurek timu honġ, los dejaḳ Yesu Kerisi sën ġevonġ yam lo ni, og saga rëḳ gevonġ bedemedo malaj-tumsën degwata los degwata. ");
INSERT INTO bzh_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Sa hevonġ benim wëëk los arëm böp töḳ yam ranġah vu dob, gesa semu huk sën ġevonġ vu sa bë sa ġevonġ lo ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Amaġ, gwevonġ besa niġ wëëk los arëġ böp natöḳ nam ranġah gökin nabë sën neggëp ranġah wirek loḳ buk sën sa nado ving honġ gedob yö nahën lo. ");
INSERT INTO bzh_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Sa tateḳin honġ degwa ranġah vu mehönon sën ġehooin sir raḳ vu sa vu dob lo. Honġ alam saga, loḳ ġevonġ sir vu sa, lom desepa loḳ honġ ġaġek. ");
INSERT INTO bzh_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lob gwëbeng deraḳ ni ggovek ya bë nġaa pin sën ġevonġ vu sa lo, og yö yam vu honġ timu. ");
INSERT INTO bzh_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","In ġaġek sën ġevo vu sa lo, og sevo vu sir bedeḳo raḳ bedevonġ ving rot bë sa vu honġ meseyam. Bedevonġ ving bë ġevonġ sa yam. ");
INSERT INTO bzh_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Sejom raḳ in sir sënë. Sa su jom raḳ in alam sën denesepa loḳ aggata-dob-yi lo rë, gaḳ sejom raḳ in sir sën ġevo vu sa lo, in honġ alam sir. ");
INSERT INTO bzh_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Salam pin tu honġ nġaa, gehonġ alam pin tu sa nġaa, lob sir pin sënë detato sa niġ wëëk los arëġ böp ranġah. ");
INSERT INTO bzh_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Sa su rëḳ medo dob rë, gaḳ sir yö rëḳ demedo gesenök vu honġ. O Amaġ Vabuung! Gweġin alam sën ġevonġ vu sa lo jaḳ nim wëëk, in demedo jevuh ti nabë sën alu nado revuh ti agi. ");
INSERT INTO bzh_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sën sa nahën nado ving sir lo, og sa neheġin sir sën ġevonġ vu sa lo raḳ nim wëëk. Sa neheġin sir rot gesir ti su mala ma rë, gaḳ yiḳ mehö nipaya timu sën vonġin mala nama lo, saga mala maya veröḳ yi, in ġaġek sën neggëp loḳ honġ ḳapiya lo anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Gwëbeng sënë sa bë nök vu honġ, rëḳ sa nanër ġaġek sënë vu dob in sir pin kwaj vesa rot nabë sa. ");
INSERT INTO bzh_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Sevo honġ ġaġek vu sir, lob alam sën denesepa loḳ aggata-dob-yi lo delë sir paya in su denesepa loḳ aggata-dob-yi rë nebë sën sa su nesepa loḳ aggata-dob-yi rë lo. ");
INSERT INTO bzh_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Sa su ḳetaġ vu honġ bë gweḳo sir vër in dob rë, gaḳ sa ḳetaġ vu honġ bë gweġin sir vu Mehö Nipaya. ");
INSERT INTO bzh_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Sir og su denesepa loḳ aggata-dob-yi rë, nebë sën sa su nesepa loḳ aggata-dob-yi rë lo. ");
INSERT INTO bzh_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gwevonġ bedejaḳ ġaġek anon ni venuh, loḳ mëm rëḳ denatu honġ hur niröp jaḳ saga, in honġ ġaġek og ġaġek anon. ");
INSERT INTO bzh_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sa hevonġ sir medeneya vu alam sën denesepa loḳ aggata-dob-yi lo, nebë sën ġevonġ sa meseyam vu alam sën denesepa loḳ aggata-dob-yi agi. ");
INSERT INTO bzh_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Sa dahun sa besetu honġ hur niröp in bë sedoḳ vu sir bedejaḳ ġaġek anon ni venuh medenatu honġ hur niröp nabë saga geving. ");
INSERT INTO bzh_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Sa su ḳetaġ in sir sënë mu rë, gaḳ sa ḳetaġ in alam sën rëḳ degenġo hir ġaġek bayoj nam timu vu sa lo ving. ");
INSERT INTO bzh_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O Amaġ! Gwevonġ sir pin demedo jevuh ti nabë sën ġenedo loḳ sa, gesa nado loḳ honġ lo, lob hil pin medo jevuh ti, in alam sën denesepa loḳ aggata-dob-yi lo dejaḳ ni medegevonġ geving nabë ġevonġ sa meseyam. ");
INSERT INTO bzh_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Log nim wëëk sën ġevo vu sa lo, og sevo vu sir in demedo jevuh ti nabë sën alu nado revuh ti agi. ");
INSERT INTO bzh_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Sa nado loḳ ayoj nebë sën ġenedo loḳ sayoġ lo, in bë demedo jevuh ti borot, galam sën denesepa loḳ aggata-dob-yi lo dejaḳ ni nabë ġevonġ sa meseyam, los dejaḳ ni nabë ahëm neving sir nebë sën ahëm neving sa. ");
INSERT INTO bzh_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","O Amaġ! Ahëm neving sa wirek loḳ buk sën dob yö nahën gesu ġetunġ rë lo rot, lob ġevonġ nim wëëk los arëm böp vu sa, om sa bë salam sën ġevonġ vu sa lo demedo geving sa doḳ nyëġ sën sëḳ medo doḳ lo in degelë sa niġ wëëk los arëġ böp saga. ");
INSERT INTO bzh_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Amaġ, Mehö yohvu! Alam sën denesepa loḳ aggata-dob-yi lo su deraḳ nim rë, gaḳ sa og seraḳ nim gesir sënë deraḳ ni bë ġevonġ sa meseyam. ");
INSERT INTO bzh_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Senër honġ degwa vu sir, gesëḳ medo nanër. In ahëvingsën na menoh vu sir geving nabë sën ahëm neving sa lo, log sa medo doḳ ayoj.” ");
INSERT INTO bzh_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu jom raḳ ggovek log to meya ving yi hur maluh meya devaseḳ bël Kidron, meya deto huk oliv* yi ti ggëp nyëġ saga. Lob Yesu losho yi hur maluh ya deluḳ ya. ");
INSERT INTO bzh_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Log Yudas sën nër yi ranġah lo, yö raḳ huk saga ni vorot, in Yesu losho yi hur maluh denesupin sir ggëp saga buk nġahi. ");
INSERT INTO bzh_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Lob ḳo alam-beġö-yi yu ti ving alam-deneḳo-seriveng hir ggev lo hir hur los Parisai* lo hir hur la bedeya huk saga. Detaggi nengwah los ram bedeḳo nġaa-beġö-yi sepa. ");
INSERT INTO bzh_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu raḳ nġaa pin sën vonġin natöḳ vu yi lo ni vorot, lom ya vu sir meloḳ tepëḳ bë, “Ham nesero re?” ");
INSERT INTO bzh_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Rëḳ denër yah vu bë, “Yesu Nasaret!” ");
INSERT INTO bzh_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Lom Yesu nër yah vu sir bë, “Sa lo sënë!” Lob Yudas sën tato yi ranġah lo nare ving sir. Yesu nër vu sir bë, “Sa lo sënë!”, lom deyah raḳ demij medekepë meya deneggëp dob. ");
INSERT INTO bzh_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Lom Yesu loḳ tepëḳ in sir ggökin bë, “Ham nesero re?” Loḳ denër yah bë, “Yesu Nasaret!” ");
INSERT INTO bzh_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Loḳ Yesu nër yah bë, “Senër vu ham ggovek ya bë yiḳ sa lo sënë! Nabë ham nesero sa, og ham gwevonġ alam sënë geto dena.” ");
INSERT INTO bzh_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nër bë saga in yi ġaġek sën nër vorot lo anon jaḳ nabë, “Sir sën ġevonġ sir vu sa lo, og sir ti su rëḳ mala nama rë.” ");
INSERT INTO bzh_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Lom Simon Pita neḳo paëp-yu-anil ti sepa, lob tur vër besap alam-deneḳo-seriveng hir ggev böp yi hur maluh ti nenga ris vesa ya. ");
INSERT INTO bzh_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Hur maluh saga arë nebë Malkus. Rëḳ Yesu nër vu Pita bë, “Ġejöp honġ paëp doḳ nah newis. Ma ġekuung bë sëḳ noh nenga in nġaa maggin sën Amaġ vonġ sa yam in lo?” ");
INSERT INTO bzh_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Log alam-beġö-yi yu ti saga losho alaj, galam Yuda hir hur lo, medejom Yesu ahon gededuu yi. ");
INSERT INTO bzh_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Lob deḳo ya vu Anas atov muġin. In alam-deneḳo-seriveng hir ggev böp wirek, rëḳ ggen Kayapas loḳ yah ben benedo loḳ nġebek sagi. ");
INSERT INTO bzh_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Lob yiḳ Kayapas sënë sën nër vu alam Yuda wirek lo bë, “Bë mehö timu nadiiḳ doḳ nah alam pin bej, og mëm nivesa.” ");
INSERT INTO bzh_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pita luho hur maluh ngwë detamuin Yesu medeya. Loḳ alam-deneḳo-seriveng hir ggev raḳ hur maluh ngwë saga ni, in mewa ma nġaa ti, lom loḳ ya alam-deneḳo-seriveng hir ggev böp saga yi begganġ tete ayo ving Yesu. ");
INSERT INTO bzh_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","GePita nare dobnë. Loḳ hur maluh ngwë sën alam-deneḳo-seriveng hir ggev raḳ ni lo to meyah menër vu avëh sën neġin veluung avi lo, log ḳo Pita meluho deloḳ ya. ");
INSERT INTO bzh_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Lob avëh sën neġin veluung avi lo loḳ tepëḳ vu Pita bë, “Maḳ mehö saga yi hur maluh ti honġ-a?” Rëḳ bë, “Saḳ ma!” ");
INSERT INTO bzh_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Log nyëġ ayööng, om alam-deneḳo-seriveng hir hur losho alam ahëvavu sën denemalajin nyëġ lo devev nengwah medetetup mevare denevenguh. Lom Pita ya nare menevenguh ving sir. ");
INSERT INTO bzh_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Log alam-deneḳo-seriveng hir ggev böp loḳ tepëḳ in Yesu yi hur maluh los yi ġaġek sën nenër vu mehönon lo. ");
INSERT INTO bzh_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Rëḳ Yesu nër yah vu bë, “Sa nanër ġaġek vu mehönon pin menado ranġah, gesa nanër loḳ dub-supinsën-yi pin, geloḳ dub-vabuung-böp sën alam Yuda denesupin sir loḳ lo. Sa su nanër ġaġek menalah vun in ham rë. ");
INSERT INTO bzh_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Om su ġedoḳ tepëḳ in sa, gaḳ ġedoḳ tepëḳ in sa ġaġek vu alam sën denenġo sa ġaġek lo rë, in denġo mederaḳ ni.” ");
INSERT INTO bzh_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Vare nenër ġaġek saga, lob ahëvavu sën denevonġ huk medenare lo ti petap Yesu nenga genër bë, “Su ġenanër ġaġek nabë saga vu alam-deneḳo-seriveng hir ggev böp!” ");
INSERT INTO bzh_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Rëḳ Yesu nër yah vu bë, “Nabë senër ġaġek ti paya, og ġenanër ranġah nabë senër tena paya. Ma nabë senër yoh vu, rëḳ nebë va sën ġesis sa meris mu-ë?” ");
INSERT INTO bzh_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Deduu Yesu ggovek benahën nare los aggis, log Anas vonġ yah vu alam-deneḳo-seriveng hir ggev böp Kayapas. ");
INSERT INTO bzh_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Log Simon Pita vare nevenguh nengwah lom denër vu yi bë, “Maḳ yi hur maluh ti sën honġ-ë?” Rëḳ Pita lah yi vun bë, “Saḳ ma!” ");
INSERT INTO bzh_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Lob alam-deneḳo-seriveng hir ggev böp yi hur ti sën Pita sap nenga ris ya lo ġadë ma nġaa ti verup nër bë, “Maḳ sa halë honġ sënë. Sën ġenare ving yi loḳ huk anon agu lo?” ");
INSERT INTO bzh_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Rëḳ Pita lah yi vun ggökin yah bë, “Saḳ ma!”, lob pevis beḳöḳrëëh su. ");
INSERT INTO bzh_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Loḳ heng to, lom deḳo Yesu ggëp Kayapas yi begganġ beto deya Prëtoryam (sën nebë kiap böp yi begganġ). Rëḳ alam Yuda su deloḳ ya Prëtoryam ving Yesu rë, in deneggöneng in alam Rom hir begganġ saga in bë rëḳ gevonġ benij paya jaḳ, lob su deyoh vu bë dega nos-ggöksën-yi rë. ");
INSERT INTO bzh_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nebë saga lom Pilatus to meya dobnë vu sir menare malaj genër bë, “Ham nër ġaġek va raḳ mehö sënë?” ");
INSERT INTO bzh_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Lom denër yah vu bë, “Mehö saga bë su yi mehö nipaya rë, og he su rëḳ ġaḳo yi manam vu honġ rë!” ");
INSERT INTO bzh_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Rëḳ Pilatus nër yah bë, “Maam ham gweḳo nök megwenġo yi ġaġek noh vu ham horek!” Rëḳ denër bë, “Ham alam Rom ham horek nërin he bë he su ayoh vu bë rëḳ angis mehönon bedenadiiḳ rë.” ");
INSERT INTO bzh_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nebë saga in bë Yesu yi ġaġek sën nër bë rëḳ nadiiḳ jaḳ ḳelepeḳo* lo anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Lom Pilatus loḳ yah Prëtoryam ggökin metahi Yesu yah meloḳ tepëḳ in bë, “Alam Yuda hir mehö-los-bengö honġ-a?” ");
INSERT INTO bzh_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Loḳ Yesu loḳ tepëḳ yah vu yi bë, “Nġo kwam nevo ġaġek saga, ma mehö la denër vu honġ-a?” ");
INSERT INTO bzh_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Loḳ Pilatus nër yah vu yi bë, “O! Sa su Yuda ti rë! Honġ alam losho hir alam-deneḳo-seriveng lo hir ggev yö deḳo honġ yam vu sa. Ma ġevonġ va paya?” ");
INSERT INTO bzh_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Loḳ Yesu nër bë, “Su sa nyëġ neggëp dob sënë rë. Bë sa nyëġ gëp vu dob sënë, og rëḳ salam sën detamuin sa lo degevonġ beġö jaḳ sa, lom alam Yuda su deyoh vu bë rëḳ denajom sa ahon rë.” ");
INSERT INTO bzh_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Lom mëm Pilatus nër yah bë, “Om maḳ honġ mehö-los-bengöm ti yönon-a?” Rëḳ Yesu nër yah bë, “Ġenër yoh vu! Sa mehö-los-bengöġ ti, rëḳ setu mehönon meluḳ yam dob in bë sa nanër ġaġek anon ranġah. Mehöti bë ġaġek anon gëp doḳ ayo, og rëḳ genġo sayeġ.” ");
INSERT INTO bzh_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Rëḳ Pilatus loḳ tepëḳ yah vu yi bë, “Ġaġek anon sagaḳ va?” Pilatus nër ġaġek saga ggovek, log to meyah dobnë menër vu alam Yuda bë, “Sa su töḳ vu ġaġek ti geneggëp vu mehö sënë rë. ");
INSERT INTO bzh_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Rëḳ mu ham nġo ham aggata neggëp bë sa ġaḳo mehöti bër in ḳarabus doḳ Buk-ggöksën-yi* benök vu ham. Om ham nanër rë, nabë ham vonġin bë sa ġaḳo ham alam Yuda ham mehö-los-bengö vër vu ham ma ma?” ");
INSERT INTO bzh_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Rëḳ detahi yah niḳelap vu bë, “Yiḳ ma! Gaḳ Barabas!” Barabas og mehö sën nesis alam geneggodeḳ hir nġaa lo. ");
INSERT INTO bzh_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Lob Pilatus nër medejom Yesu ahon medeḳo meya deveek yi raḳ aggis. ");
INSERT INTO bzh_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Gemëm alam-beġö-yi detahu mehö-yurëmeḳ raḳ yi. Bededuu aggis niggin ggin tahu alam-los-bengöj hir madub gedetunġ raḳ yu, log deröp tob mala saġap loḳ yi, ");
INSERT INTO bzh_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","log ya denare mala gedevonġ kewësën vu bë, “Alam Yuda hir mehö-yurëmeḳ! He haḳo honġ raḳ!” Log depetap yi. ");
INSERT INTO bzh_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Lob Pilatus to meyah dobnë ggökin menër bë, “Ham lë, sa hevonġin ġaḳo yi geto menam vu ham, in mëm ham nġo jaḳ ġaġek sën senër vu ham lo ni nabë sa su töḳ vu nipaya ti geneggëp vu yi rë.” ");
INSERT INTO bzh_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Lob mëm Pilatus ḳo Yesu los madub niggin ggin, betob mala saġap sën beto meya vu sir genër bë, “Ham lë! Mehö lo sënë!” ");
INSERT INTO bzh_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Lob alam-deneḳo-seriveng hir ggev los ahëvavu sën denemalajin nyëġ lo, delë yi lom detahi bë, “Ġengis yi jaḳ na ḳelepeḳo*! Ġengis yi jaḳ na ḳelepeḳo*!” Lom Pilatus nër yah vu sir bë, “Om ham nġo gweḳo yi nök mengis yi jaḳ na ḳelepeḳo*. In sa su töḳ vu nipaya ti geneggëp vu yi rë.” ");
INSERT INTO bzh_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Loḳ alam Yuda denër yah vu bë, “He horek neggëp lom horek saga sën nër bë nadiiḳ in ḳo yi raḳ benër yi nebë Anutu Nalu yi.” ");
INSERT INTO bzh_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatus nġo ġaġek saga, lob ggöneng in yi panġsën rot, ");
INSERT INTO bzh_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","lom loḳ yah Prëtoryam meloḳ tepëḳ in Yesu ggökin bë, “Ġeyam vu tena?” Rëḳ Yesu aye ma. ");
INSERT INTO bzh_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Lom Pilatus nër vu yi bë, “Su ġevengwënġ in sa rë? Ġeraḳ ni bë setu ala! Seyoh vu bë ġaḳo honġ vër, geseyoh vu bë ġevonġ honġ vu sir medengis honġ jaḳ na ḳelepeḳo*!” ");
INSERT INTO bzh_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Loḳ Yesu nër yah vu yi bë, “Bë Anutu vu vavunë su ngoġek rë, og su rëḳ ġenatu ala rë. Nebë saga, om mehö sën vonġ sa loḳ yök nemam lo, saga sën vonġ nġaa nipaya sevöḳ honġ.” ");
INSERT INTO bzh_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatus nġo ġaġek saga, lom tum kwa vo bë geḳo Yesu vër, rëḳ alam Yuda detahi ya niḳelap bë, “Bë gweḳo mehö saga vër, og su mehö-los-bengö Sisar* yi mehö honġ rë! Mehöti bë yö gooin yi jaḳ natu mehö-los-bengö, og neḳo yi raḳ bë kesuu Sisar*.” ");
INSERT INTO bzh_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatus nġo hir ġaġek saga ggovek, lob ḳo Yesu meto meya geraḳ nedo sëa-ġaġek-yi ggëp nyëġ sën denenër bë Telig Ġelönġ lo. (Denenër ggëp Hibru ayej bë Gabata.) ");
INSERT INTO bzh_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lob loḳ buk saga alam Yuda denesemu sir in bë dega nos Buk-ggöksën-yi*, gemëm siks krök monbuk lob Pilatus nër vu alam Yuda bë, “Ham gwelë ham mehö-los-bengö sënë!” ");
INSERT INTO bzh_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Rëḳ detahi yah niḳelap bë, “Gweḳo na! Gweḳo na! Ġengis yi jaḳ na ḳelepeḳo*!” Loḳ Pilatus loḳ tepëḳ in sir bë, “Ham vonġin bë sengis ham mehö-los-bengö jaḳ na ḳelepeḳo*?” Lob alam-deneḳo-seriveng hir ggev denër yah bë, “He hömin mehö-los-bengö ma, gaḳ yiḳ mehö-los-bengö Sisar* yö timu!” ");
INSERT INTO bzh_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Denër nebë saga, lob tum Pilatus lëëin Yesu loḳ yah nemaj in dengis yi jaḳ na ḳelepeḳo*. ");
INSERT INTO bzh_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Lom Yesu yö kerë yi ḳelepeḳo* raḳ gedeḳo yi medeya nyëġ sën denenër arë nebë Nyëġ Yuseḳë lo, (Hibru ayej nebë Golgota). ");
INSERT INTO bzh_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Lom ya desis yi raḳ ḳelepeḳo* ggëp sagu, bedesis mehö luu denare vahi vahi, geYesu nare vuheng. ");
INSERT INTO bzh_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Log Pilatus nër medekevu yi ġaġek raḳ neggëp ḳelepeḳo* yu nebë: YESU NASARET, ALAM YUDA HIR MEHÖ-LOS-BENGÖ. ");
INSERT INTO bzh_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Lom nyëġ sën desis Yesu raḳ ya ḳelepeḳo* lo, neggëp dus vu nyëġ böp Yerusalem nenga, lom Yuda nġahiseḳë detevin ġaġek saga in dekevu loḳ ayej löö pin. Dekevu loḳ alam Yuda ayej, geloḳ alam Rom ayej, geloḳ alam Grik ayej. ");
INSERT INTO bzh_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Lom Yuda hir alam-deneḳo-seriveng hir ggev denër vu Pilatus bë, “Su ġekwevu nabë alam Yuda hir mehö-los-bengö, gaḳ kwevu nabë yö nenër yi nebë alam Yuda hir mehö-los-bengö.” ");
INSERT INTO bzh_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Loḳ Pilatus nër yah vu sir bë, “Ġaġek sën sa ḳevu aga lo, yö gëp jaḳ!” ");
INSERT INTO bzh_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Lob alam-beġö-yi desis Yesu raḳ ya ḳelepeḳo* ggovek, loḳ mëm yom devonġ yi tob ggelek sir ya yu lubeluu yoh vu sir. Rëḳ yi röpröp ading sën neröp ya ġebinë lo nahën neggëp, rëḳ devasu los ayo dahis vu kwa beya meto vaha. ");
INSERT INTO bzh_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Delë bë devasu nebë saga, om denër bë, “Hil su nakweeḳ, gaḳ hil ġetë ġelönġ mahen in nabë mehöti sën sevöḳ hil lo, og geḳo los dahis.” Devonġ nebë saga lob ġaġek sën dekevu meneggëp loḳ Anutu-yi-ḳapiya lo anon raḳ. Ġaġek sënë nebë: “Devonġ sa tob ggelek sir. Gedetë ġelönġ mahen in bë gooin mehöti jaḳ megeḳo sa röpröp.” ");
INSERT INTO bzh_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Lob Maria sën Yesu ata lo luho ari, geKlopas venë Maria, geMaria vu Magdala, beya denare dus vu Yesu yi ḳelepeḳo*. ");
INSERT INTO bzh_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Lob Yesu lë bë ata luho hur maluh* ti sën ahë neving yi panġsën lo denare, lom nër vu ata bë, “Avëh-e! Gwelë nalum saga!” ");
INSERT INTO bzh_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Log nër vu hur maluh saga bë, “Gwelë atam saga!” Lom loḳ buk saga hur maluh saga ḳo Yesu ata raḳ meya nedo ving yi ggëp ben. ");
INSERT INTO bzh_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Lom mëm Yesu raḳ ni bë semu nġaa pin ggovek ya, lom nër bë, “Sayoġ nevev in bël!” in ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo anon jaḳ. ");
INSERT INTO bzh_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lob wain ahëggin sën arë nebë vinegga lo nedo loḳ ġabum ti. Lom deḳo nġaa-ayo-sovinsën sën nedo loḳ loo lo ti, bededuu vetii nġesinġ ti mededaġoo luḳ gedevo ya verup loḳ avi. ");
INSERT INTO bzh_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Lob Yesu sesuvin log nër bë, “Sa semu nġaa pin ggovek ya!” Log kwa yun luḳ gelëëin anon ya. ");
INSERT INTO bzh_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Loḳ buk saga alam Yuda denesemu sir in bë monbuk lob dega nos Buk-ggöksën-yi*, lom deketaġ vu Pilatus bë gevonġ alam-beġö-yi na dekeyëh lööho vahaj in denadiiḳ pevis, log dejuh navij geto. In bë mehönon navij su bare jaḳ ḳelepeḳo* doḳ Buk-sewahsën-yi*, in Buk-sewahsën-yi* saga böpata rot kesuu. ");
INSERT INTO bzh_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Lom alam-beġö-yi ya dekeyëh mehö luu sën lo ngwë vaha muġin, log devonġ ngwë sën nare vahi lo ving nebë saga. ");
INSERT INTO bzh_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Log deloḳ ya Yesu, rëḳ delë bë diiḳ ggovek ya, lom su desis vaha mekeyëh rë. ");
INSERT INTO bzh_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Rëḳ alam-beġö-yi ti pejëh Yesu kweben raḳ jeggevek lom ḳöḳ los bël keseh yam pevis. ");
INSERT INTO bzh_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Lom mehö sën lë nġaa agi raḳ mala lo, sën kevu, om yi ġaġek sagi yönon. Yö raḳ ni benenër ġaġek yönon in ham jaḳ ni geving begwevonġ geving. ");
INSERT INTO bzh_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Devonġ nebë sënë lob ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo anon raḳ. Sën nenër bë: “Seḳë ti su rëḳ keyëh rë.” ");
INSERT INTO bzh_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Gengwë neggëp bë: “Alam rëḳ malaj jaḳ mehö sën depejëh lo.” ");
INSERT INTO bzh_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Saga ggovek log Yesu yi hur maluh ti sën Yosep vu Arimatea, sën vonġ ving Yesu rëḳ mu neggöneng in alam Yuda hir ggev lom su nesepa loḳ Yesu ya ranġah rë lo. Yi saga sën ya ketaġ vu Pilatus bë juh Yesu nihel vër in ḳelepeḳo*, lom yoġekin beya meruh vër. ");
INSERT INTO bzh_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Lob Nikodemus ya ving, sën wirek ya vu Yesu loḳ buk lo. Lom ḳo nġaa reggu nivesa luu sepa, mesarömin luho revuh ti (denenër arëj nebë mur* los alos), bemaggin yoh vu 50 kilo. ");
INSERT INTO bzh_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Lob luho ya deruh Yesu vër lob desepa loḳ alam Yuda vahaj medebom nihel los nġaa reggu nivesa saga loḳ tob veroo. ");
INSERT INTO bzh_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lob huk ti neggëp dus vu nyëġ sën desis Yesu raḳ ḳelepeḳo* lo, lom waaḳ ti neggëp loḳ, rëḳ su debë heljënġ ti loḳ rë, geyö nahën neggëp mewis. ");
INSERT INTO bzh_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Lom debë Yesu loḳ, in neggëp dus, galam Yuda hir buk sën desemu sir lo ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Alam Yuda hir Buk-sewahsën-yi* ggovek ya geSoda monbuk anon. Nyëġ su heng to rë geyö nahën, log Maria Magdala ya verup bedub, lom lë bë ġelönġ tetolin ya in waaḳ avi. ");
INSERT INTO bzh_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Lom seröġ meya menër vu Simon Pita luho hur maluh* ngwë sën Yesu ahë neving yi panġsën lo, benër vu luho bë, “Deḳo Mehöböp vër in bedub gehe duġin sën ya debë lo!” ");
INSERT INTO bzh_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Lom Pita luho hur maluh ngwë sën lo deseröġ pevis medeya bedub. ");
INSERT INTO bzh_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Luho deseröġ loḳ ti, loḳ hur maluh ngwë sënë lo seröġ niwëëk mekesuu Pita betöḳ ya muġin. ");
INSERT INTO bzh_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ya verup bë mala melë waaḳ ayo, loḳ lë bë tob gam veroo sën lo neggëp, rëḳ su luḳ ya waaḳ ayo rë. ");
INSERT INTO bzh_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Loḳ Simon Pita tamu beverup, lom sesor meluḳ ya waaḳ ayo melë bë tob gam veroo sënë nahën neggëp vevirsën, ");
INSERT INTO bzh_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","getob ngwë sën debun yu loḳ lo su nedo ving tob veroo saga rë, gaḳ yö ya nedo los vahininsën ya tahsën. ");
INSERT INTO bzh_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Lom hur maluh ngwë sën ya verup bedub avi muġinsën lo luḳ ya waaḳ ayo melë nebë sënë ving, lom vonġ ving bë Yesu kedi raḳ yah. ");
INSERT INTO bzh_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","In wirek luho su deraḳ ġaġek sën neggëp loḳ Anutu-yi-ḳapiya lo degwa ni rë. Sën neggëp nebë rëḳ kedi jaḳ nah vu bedub lo. ");
INSERT INTO bzh_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ggovek, log luho deyah medeya begganġ. ");
INSERT INTO bzh_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Rëḳ Maria vare nesu loḳ waaḳ sën debë Yesu loḳ lo nenga. ");
INSERT INTO bzh_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nahën vare nesu, log bë mala in waaḳ ayo loḳ lë gangër luu deröp tob veroo meris bedenedo loḳ nyëġ len ti sën debë Yesu loḳ lo. Ngwë nedo ya los sën yu neya lo, gengwë nedo yom sën vaha neyom lo. ");
INSERT INTO bzh_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Lob luho denër vu yi bë, “Avëh, ġenesu in va?” Loḳ nër yah vu luho bë, “Deḳo sa Mehöböp meya debë la, gesa duġin nyëġ sën debë loḳ lo!” ");
INSERT INTO bzh_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nër bë saga ggovek gepeggirin yi yom, lob lë Yesu genare, rëḳ su raḳ ni rë. ");
INSERT INTO bzh_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Lom Yesu nër vu yi bë, “Avëh! Ġësu in va? Ġenesero re?” Rëḳ Maria kuung bë mehö sën neġin huk saga, lom nër yah vu yi bë, “Mehö böp, bë gweḳo yi meġeya, og ġenanër nyëġ sën ġebë yi loḳ lo tato vu sa, in senah ġaḳo yi!” ");
INSERT INTO bzh_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Lom Yesu nër yom bë, “Maria!” Loḳ Maria raḳ ni pevis lom peggirin menër vu yi loḳ Hibru ayej bë, “Raboni!” (Arë sënë nebë Tatovaha.) ");
INSERT INTO bzh_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Lob Yesu nër vu yi bë, “Ġedëëin sa! In sa nahën gesa su raḳ meyah vu Amaġ rë. Om ġenah meġena ġenanër vu arig lo nabë, ‘Sëḳ jaḳ menah vu Amaġ geham Amamin, vu sa Anutu geham Anutu.’” ");
INSERT INTO bzh_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Lob Maria Magdala ya menër ranġah vu hur maluh bë, “Sa halë Mehöböp!”, log nër Yesu yi ġaġek pin ranġah vu sir. ");
INSERT INTO bzh_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Soda saga ggovek ya gehes luḳ ya bebuk loḳ, lom Yesu yi hur maluh deneggöneng in alam Yuda, lom devehii repinġ in sir gedenedo. Lob Yesu yam nare ranġah loḳ sir vuheng genër bë, “Ham ayomin gëp revuh!” ");
INSERT INTO bzh_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Log mëm tato nema los kweben vu sir, lom kwaj vesa raḳ in delë Mehöböp. ");
INSERT INTO bzh_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Log Yesu nër vu sir ggökin bë, “Ham ayomin gëp revuh! Sëḳ ġevonġ ham na nabë sën Amaġ vonġ sa meseyam.” ");
INSERT INTO bzh_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nër nebë saga, log rov saheng raḳ sir genër bë, “Ham gweḳo Anon Vabuung nök! ");
INSERT INTO bzh_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nabë ham dahun alam hir nġaa nipaya na, og rëḳ nama na, ma nabë ham su dahun hir nġaa nipaya na rë, og rëḳ nahën gëp vu sir rot.” ");
INSERT INTO bzh_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Rëḳ sir nemadluho-mevidek-luu sënë lo ti sën Tomas (sën denenër yi bë Pepid lo), su nedo ving sir loḳ buk sën Yesu tato yi vu sir lo rë. ");
INSERT INTO bzh_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Lob Yesu yi hur maluh denër vu Tomas bë, “He halë Mehöböp!” Loḳ Tomas nër yah vu sir bë, “Bë sa su ġalë brëm len sën neggëp loḳ nema lo rë, besa su jöp nemaġ doḳ brëm len rë, gesa su jöp nemaġ doḳ ḳele len sën neggëp loḳ kweben lo rë, og sa su rëḳ ġevonġ geving rë, gerëḳ nama!” ");
INSERT INTO bzh_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Lob soda ti ya ggovek rë, loḳ yi hur maluh denedo loḳ begganġ saga ggökin yah beTomas nedo ving sir. Devehii repinġ in sir gedenedo, loḳ Yesu yam nare ranġah loḳ sir vuheng atov genër bë, “Ham ayomin gëp revuh!” ");
INSERT INTO bzh_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Log nër vu Tomas bë, “Ġenam gwebë nemam deggis jaḳ sënë, gegwelë sa nemaġ. Geġejöp nemam doḳ sa kwebeġ. Su kweyëh ġaġek, gaḳ gwevonġ geving!” ");
INSERT INTO bzh_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Lom Tomas nër yah vu yi bë, “O sa Mehöböp los sa Anutu honġ!” ");
INSERT INTO bzh_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Lom Yesu nër yah vu yi bë, “Ġelë sa om ġevonġ ving-a? Rëḳ mu alam sën su delë sa rë, rëḳ degevonġ geving lo, og rëḳ kwaj vesa rot.” ");
INSERT INTO bzh_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu vonġ nġaa böp nġahiseḳë meyi hur maluh delë, rëḳ sa su ḳevu los dahis meneggëp loḳ ḳapiya sënë rë. ");
INSERT INTO bzh_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yiḳ sa ḳevu dus ti ti sënë in bë ham jaḳ ni begwevonġ geving nabë Yesu yi Kerisi* sën Anutu Nalu. Ham gwevonġ geving nabë saga benatu yi alam lob ham rëḳ medo malamin-tumsën jaḳ arë. ");
INSERT INTO bzh_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nahub rë loḳ Yesu tato yi ggökin vu yi hur maluh vu nġaggee böp Tiberias* nenga. Tato yi nebë sënë: ");
INSERT INTO bzh_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon luho Tomas (sën denenër yi nebë Pepid lo), geNatanael (vu Kana ggëp distrik Galilea), log Sebedi nalu luho ving hur maluh luu bedenedo loḳ ti. ");
INSERT INTO bzh_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Lom Simon Pita nër vu sir bë, “Sena ġaḳo ġël!” Lom denër vu yi bë, “He nök geving honġ.” Lom ya deraḳ ya yaġ ti rëḳ su deḳo ġël ti loḳ buk saga rë gema rot. ");
INSERT INTO bzh_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Benyëġ heng lom Yesu nare nġaggee nenga rëḳ yi hur maluh duġin yi. ");
INSERT INTO bzh_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Lom tahi ya vu sir bë, “Hur maġëm-e! Ham ḳo ġël la?” Rëḳ detahi yah vu yi bë, “Ma rot-o!” ");
INSERT INTO bzh_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Lob tahi vu sir bë, “Maam hameḳ gwetë leḳ nah los yaġ nenga vesa rë, loḳ mëm ham rëḳ gweko.” Lom detë leḳ luḳ yah yoh vu sën nër-ë gededadii raḳ yom, rëḳ devimengin in ġël nġahiseḳë vevii besu deyoh vu rë. ");
INSERT INTO bzh_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Lob hur maluh* ngwë sën Yesu ahë neving panġsen lo, nër vu Pita bë, “Sagiḳ Mehöböp!” Lom Simon Pita nġo bë Mehöböp, lom kebu yi raḳ röpröp ti, in kah yi tob ya genare navi meris, lom pesönġ ya bël beya vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Gehur maluh vahi sën denedo raḳ yaġ lo, deḳo yaġ mededadii leḳ los ġël medeyam nġaggee nenga, in denedo dus vu roneḳ (yoh vu mita 100 mu). ");
INSERT INTO bzh_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ya deraḳ ya roneḳ lom delë bë nengwah medo netum beġël medo nenöḳ raḳ gebrët la nedo ving. ");
INSERT INTO bzh_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Lob Yesu nër vu sir bë, “Ham gweḳo ġël sën gwëbeng ham ḳo aga lo la nam.” ");
INSERT INTO bzh_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Lom Simon Pita raḳ yah yaġ medadii leḳ los ġël böp böp raḳ yam roneḳ. Beġël 153 pup rëḳ leḳ su vepul rë. ");
INSERT INTO bzh_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Lob Yesu nër vu sir bë, “Ham nam gwa nos!” Lom hur maluh pin deggöneng in sir gesir ti su loḳ tepëḳ in yi rë, in deraḳ ni bë Mehöböp. ");
INSERT INTO bzh_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Lob Yesu ḳo brët beyam vo vu sir, bevo ġël ggelek sir ving. ");
INSERT INTO bzh_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu kedi raḳ vu bedub lob tato yi beron netu löö sënë vu yi hur maluh lo. ");
INSERT INTO bzh_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Log denedo medegga nos ggovek ya, loḳ Yesu loḳ tepëḳ vu Simon Pita bë, “Jon* nalu Simon, maḳ ahëm neving sa rot kesuu alam saga pin ma ma?” Loḳ Simon yoġek bë, “Ëë-ë, Mehöböp! Nġo ġeraḳ ni bë honġ mehö sa!” Lom Yesu nër vu yi bë, “Om ġebet sa sipsip nalu lo!” ");
INSERT INTO bzh_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Loḳ Yesu loḳ tepëḳ in yi beron ngwë ggökin bë, “Jon* nalu Simon, maḳ ahëm neving sa yönon ma ma?” Rëḳ Simon nër yah bë, “Ëë-ë, Mehöböp! Nġo ġeraḳ ni bë honġ mehö sa!” Lom Yesu nër vu yi bë, “Om gweġin sa sipsip lo!” ");
INSERT INTO bzh_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Loḳ loḳ tepëḳ in yi netu beron löö bë, “Jon* nalu Simon, maḳ sa mehö honġ yönon-a?” Nebë saga, lom Pita ayo maggin raḳ in loḳ tepëḳ in yi tu beron löö benër bë, “Maḳ sa mehö honġ yönon-a?”, loḳ nër yah bë, “Mehöböp, nġo ġeraḳ nġaa pin ni, om ġeraḳ ni bë honġ mehö sa!” Lom Yesu nër yah vu yi bë, “Om ġebet sa sipsip! ");
INSERT INTO bzh_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Gesa nanër vu honġ yönon nabë nġo ġenahën maġëm lom ġenevëh honġ ḳabi meġeneḳo loḳ nyëġ yoh vu sën ahëm neving lo. Rëḳ mu nabë honġ atov jaḳ, og rëḳ ġetelë nemam gemehöti naduu honġ ḳabi ahon megeli honġ na nyëġ sën su ahëm neving rë lo.” ");
INSERT INTO bzh_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu nër ġaġek saga raḳ Pita in bë tato sën rëḳ nadiiḳ begeḳo Anutu arë jaḳ lo. Nër ġaġek saga ggovek log nër vu Pita bë, “Ġesepa doḳ sa!” ");
INSERT INTO bzh_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Loḳ Pita ggërin yi yah lom lë hur maluh ti sën Yesu ahë neving yi panġsën lo. Mehö sënë sën medo denegga nos wirek lo, loḳ kepë yi yah neggëp loḳ Yesu babu geloḳ tepëḳ vu bë, “Mehöböp, re rëḳ nanër honġ ranġah-a?” ");
INSERT INTO bzh_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita lë bë netamuin luho, lob loḳ tepëḳ in vu Yesu bë, “Mehöböp, gaḳ mehö saguḳ rëḳ nabë va?” ");
INSERT INTO bzh_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Loḳ Yesu nër yah vu yi bë, “Ġeloḳ tepëḳ in va? Senġo sa nġaa! Om nabë sa kwaġ bo nabë yö medo rot gesenom geto rë, og yö rëḳ medo rot. Gaḳ honġ og nġo ġesepa doḳ sa!” ");
INSERT INTO bzh_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Lob mëm ġaġek lo ya meyoh vu ari lo vahi nebë hur maluh sagu su rëḳ nadiiḳ rë. Rëḳ mu Yesu su nër bë su rëḳ nadiiḳ rë, gaḳ nër bë, “Bë sa kwaġ bo nabë medo rot gesenom geto rë, og yö rëḳ medo rot.” ");
INSERT INTO bzh_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yiḳ hur maluh sënë sën nër ġaġek lo pin degwa ranġah gekevu los dahis, lom he raḳ ni bë yönon. ");
INSERT INTO bzh_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Genġaa vahi sën Yesu nevonġ lo nahën neggëp. Rëḳ bë sa kwaġ bo mesepa doḳ los dahis meḳevu doḳ na ḳapiya, og maḳ rëḳ ḳapiya sënë na megërin dob pin. ");
INSERT INTO bzh_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Teopilus*! Ġaġek sën sa ḳevu muġinsën lo, saga sa tateḳin nġaa pin sën Yesu nevonġ los yi ġaġek sën nenër lo, ");
INSERT INTO bzh_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","vu muġinsën rot beverup loḳ buk sën yah meya yaġek lo. Anon Vabuung tato huk vu yi lob nër tato vu sinarë sën ggooin sir raḳ vorot lo ggovek log Anutu ḳo yi raḳ yah yaġek. ");
INSERT INTO bzh_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mehö saga sën ḳo hil nivanë mediiḳ in hil pin, loḳ tato yi vu sinarë lo beron nġahiseḳë in bë dejaḳ ni borot nabë nedo mala-tumsën lo. Denelë yi ranġah los ranġah yoh vu buk mehödahis luu, log nenër sën Anutu-yi-nyëġ anon jaḳ lo degwa tato vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lob medo negga nos ving sir loḳ buk saga ti, lob mëm nër vu sir bë, “Ham su gwevuu Yerusalem. Gaḳ ham medo gweġin nġaa sën Amaġ nër bë rëḳ gevonġ vu ham lo. Sën senër vu ham wirek lo. ");
INSERT INTO bzh_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","In Jon neripek alam raḳ bël, rëḳ su buk hus ading rë gAnon Vabuung vonġin jaḳ na ham.” ");
INSERT INTO bzh_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Loḳ buk saga desupin sir raḳ bedeloḳ tepëḳ in yi bë, “Mehöböp, maḳ buk yam ggovek bevonġin ġebër alam Israel hir nyëġ jaḳ gehil nġo vonġin ġeġin hil gökin nah nabë wirek ma va?” ");
INSERT INTO bzh_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Rëḳ nër yah vu sir bë, “Su ham nġaa in bë ham rëḳ jaḳ buk los nġebek saga ni rë, in Amaġ yö tu ala mekwa vo meneggëp vu yi. ");
INSERT INTO bzh_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Rëḳ mu Anon Vabuung rëḳ nam jaḳ na ham los bo niwëëk vu ham, beham nanër sarëġ ranġah vu Yerusalem, gevu distrik Yudea los distrik Samaria bena menoh vu dob pin.” ");
INSERT INTO bzh_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu nër ġaġek sënë ggovek, gevare denemalajin yi gAnutu ḳo yi raḳ yah yaġek, lob beggob ggërin yi log su delë yi ggökin rë. ");
INSERT INTO bzh_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Log nahën vare malaj nesepa, lob pevis medelë mehö luu los tob veroo meris yam denare ving sir. ");
INSERT INTO bzh_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Lob luho denër bë, “Ham alam Galilea, ham malamin nelë yaġek panġsën in va? Yesu sën vuu ham geraḳ yah yaġek lo rëḳ duḳ nom nabë sën ham nelë yi geraḳ meyah agi!” ");
INSERT INTO bzh_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Lob sir vu ḳedu sën denenër arë nebë Ḳele-oliv* lo medeyah medeya Yerusalem. Ḳedu Ḳele-oliv sënë neggëp dus vu Yerusalem yiḳ yoh vu sën horek nër bë mehönon degee medena doḳ Buk-sewahsën-yi* lo. ");
INSERT INTO bzh_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bedetöḳ yah Yerusalem mederaḳ ya bej meya denedo. Alam sën lo sagi: Pita, geJon, geYakobus lu Andreas, gePilip ving Tomas, geBartolomai ving Matai, geYakobus ngwë sën Alpeus nalu, log Simon ngwë sën mehö neruuk alam Rom lo, log Yudas sën Yakobus ngwë nalu. ");
INSERT INTO bzh_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Alam pin sagi sën ayoj timu medenejom raḳ medenedo. Gavëh la losho Maria sën Yesu ata ving Yesu ari lo pin dejom raḳ medenedo ving. ");
INSERT INTO bzh_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ggovek, loḳ buk ti lob Pita kedi nare loḳ ari lo pin malaj benër ġaġek ti vu sir. Gesir pin saga raḳ neggëp alam nemadvahi-bevidek-ti (120). ");
INSERT INTO bzh_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Pita nër bë, “Arig lo, ġaġek sën dekevu meneggëp loḳ Anutu-yi-ḳapiya lo anon raḳ beyiḳ ggovek. Wirek Anon Vabuung vonġ ġaġek verup Davit avi benër raḳ Yudas, mehö saga sën tato aggata vu alam bë denajom Yesu ahon lo, lob ġaġek wirek hen saga gwëbeng anon raḳ ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","In wirek Yesu ggooin Yudas raḳ menedo ving he beḳo huk sënë ving he. ");
INSERT INTO bzh_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ham raḳ ni bë Yudas sën agi ḳo dob len ti raḳ monë hel ḳöḳ sën devo vu yi lo, lob ya mevës bahë tetap bahë pin keseh to meya. ");
INSERT INTO bzh_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Lob alam pin sën denedo Yerusalem lo, denġo ġaġek saga mederaḳ ni, lom denenër dob saga loḳ ayej nebë Akeldama. Sënë nebë Dob-hel-ḳöḳ. ");
INSERT INTO bzh_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Log tum ġaġek neggëp loḳ ḳapiya Saam sën denevonġ raro raḳ wirek lo nebë: ‘Yi begganġ yö medo menabumeng na, mehöti su doḳ medo!’ Log ġaġek ngwë nër ving nebë: ‘Mehö ngwë pevis medoḳ nah ben.’ ");
INSERT INTO bzh_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Om hil pevis maġooin mehöti vuheng doḳ alam sën deneya ving hil los Mehöböp Yesu raḳ buk pin sën hil nehaḳo loḳ lo. ");
INSERT INTO bzh_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Mehöti sën neya ving hil wirek geJon neripek alam lo, beyam verup loḳ buk sën Anutu ḳo Yesu vër in hil geḳo yi yah vavunë lo. Mehönon sën delë sagi pin, og mëm hil aġooin ti jaḳ begeḳo huk geving he benanër ranġah nabë Yesu kedi raḳ vu bedub yönon.” ");
INSERT INTO bzh_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita nër bë saga, lob deggooin mehö luu raḳ. Ngwë Yosep sën denenër yi nebë Barsabas garë ngwë nebë Yustus lo, log ngwë arë nebë Matias. ");
INSERT INTO bzh_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Lom dejom raḳ vu Mehöböp bë, “Mehöböp, ġeraḳ alam pin ayoj ni, om mëm nġo ġetato vu he nabë ġehooin mehö luu sagi ngwë tena rak ");
INSERT INTO bzh_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","in doḳ nah Yudas ben menatu sinarë nyëdahis geving he. In Yudas vuu huk sagi ya geya nyëġ sën bë na lo.” ");
INSERT INTO bzh_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Lob derekö veri raḳ luho lob löö raḳ Matias, lom devonġ yi tu sinarë ving sir nemadluho-bevidek-ti sagi lo. ");
INSERT INTO bzh_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Buk-supinsën-yi sën denenër bë Pentekos lo verup ggovek lob desupin sir loḳ begganġ ti. ");
INSERT INTO bzh_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Lob pevis bededun ti yam ggëp yaġek, benesu nebë sanġ niwëëk, begeyeh nengaj rot. ");
INSERT INTO bzh_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Lob delë nġaa nebë nengwah daggen netum, lob vepul dus dus beya meraḳ ya sir ti ti. ");
INSERT INTO bzh_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Lob Anon Vabuung loḳ yam ggërin ayoj pin, lob denër ayej aggagga yoh vu Anon Vabuung vonġ verup avij. ");
INSERT INTO bzh_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lob alam Yuda nġahi sën sir vu nyëġ pin meyam denedo Yerusalem in kwaj nevo Anutu lo, ");
INSERT INTO bzh_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","denġo nġaa sën dedun raḳ, lob desupin sir ya, lom delëk in denġo alam sënë denevengwënġ loḳ ayej ti ti. ");
INSERT INTO bzh_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Lob delëk bekwaj ya nġahi medenër bë, “Alam sën agi yiḳ sir Galilea pin! ");
INSERT INTO bzh_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Rëḳ nebë va sën hil pin nehanġo bë denevengwënġ loḳ hil ayed ti ti niröp-ë? ");
INSERT INTO bzh_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Hil Patia geMedia, gehil sën nado Mesopotamia, geYudea, geKapadosia, Pontus, gAsia*. ");
INSERT INTO bzh_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","GePrugia los Pampulia, Ejep ga, hil vahi vu Libua sën dus vu Kurene lo ga, hil alam vatëveḳ vu Rom ving. ");
INSERT INTO bzh_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Hil alam Yuda los alam-yu-ngwë sën deggërin sir medenesepa loḳ alam Yuda hir horek lo, gehil Krete los Arabia. Rëḳ hil pin nehanġo bë denenër ġaġek raḳ Anutu yi huk niwëëk loḳ hil ayed ti ti. ");
INSERT INTO bzh_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Lob sir pin delëk gekwaj ya nġahiseḳë. Geya denër vu sir nebë, “Nġaa sagi degwa nebë va?” ");
INSERT INTO bzh_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Rëḳ la denenër ġaġek pelësën nebë, “Denum bël menġëës panġsën beyuj vonġ paya.” ");
INSERT INTO bzh_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Loḳ Pita losho sir nemadluho-bevidek-ti sënë kedi denare, lob tahi niwëëk genër ranġah vu alam bë, “Ham Yuda los alam-yu-ngwë pin sën ham yam nedo Yerusalem agi! Ham gwebë nengamin vu sa ġaġek, beham jaḳ nġaa sagi ni! ");
INSERT INTO bzh_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ham kuung bë alam sagi denum meyuj vonġ paya, gaḳ ma! Yiḳ nahën 9 krök monbuk gemehöti su nenum bël menġëës monbuk rë. ");
INSERT INTO bzh_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Rëḳ mu mehö-nenër-ġaġek-ranġahsën Yoel nër raḳ nġaa sënë wirek bë: ");
INSERT INTO bzh_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Anutu nër bë, “Buk-tamusën dus jaḳ, og sëḳ ḳeseh sa Anon Vabuung jaḳ alam pin. Geham nalumin maluh los avëh lo rëḳ denanër ġaġek ranġah nabë alam-denenër-ġaġek-ranġahsën. Log ham hur maġëm rëḳ degelë nġaa aggagga nabë pesepsën, geham alam atov rëḳ degëp medegelë pesepsën. ");
INSERT INTO bzh_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kë! Vu buk saga rëḳ sa ḳeseh sa Anon Vabuung jaḳ sa hur maluh los avëh, lob rëḳ denanër ġaġek ranġah nabë alam-denenër-ġaġek-ranġahsën. ");
INSERT INTO bzh_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Lob mëm sëḳ ġevonġ huk aggagga gëp yaġek, gesëḳ ġevonġ nġaa böp böp gëp dob sënë: Ḳöḳ los nengwah genengwah aru. ");
INSERT INTO bzh_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Log hes rëḳ malaḳenu doḳ, gekwev mala ḳöḳ jaḳ. Govek log mëm Mehöböp yi buk natöḳ nam. Yi buk rëḳ böp los niwëëk. ");
INSERT INTO bzh_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Log alam sën detahi ya vu Mehöböp lo pin, og rëḳ Anutu geḳo sir nah vu yi.” ’ ");
INSERT INTO bzh_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Om ham Israel! Ham gwenġo ġaġek sagi! Sa bë nanër Yesu Nasaret vu ham: Ham nġo raḳ huk niwëëk los nġaa böp sën Anutu vo loḳ mehö saga nema lo ni. Tato nġaa böp saga vu ham in bë ham jaḳ ni nabë Anutu vonġ yi yam. ");
INSERT INTO bzh_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wirek Anutu yö kwa vo meduu ahon ggovek ya, log mëm tunġ mehö saga loḳ yök ham nemamin. Loḳ ham vonġ loḳ ya alam-yu-ngwë sën denekeyëh horek lo nemaj, bedesis yi raḳ ya ḳelepeḳo* mediiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Rëḳ mu Anutu nër mekedi raḳ yah vu bedub meḳo yi vër vu nivanë nipaya pin sën diiḳsën-yi lo. In diiḳsën saga su yoh vu bë dahun mehö saga yönon rë. ");
INSERT INTO bzh_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","In Davit nër ġaġek raḳ yi bë: ‘Sa nehalë Mehöböp nedo sa malaġ yoh vu buk pin. Nare ggëp sa nemaġ vesa genġaa ti su rëḳ kepë sa rë. ");
INSERT INTO bzh_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Om sën sa ahëġ nivesa, log mëm sa hevonġ ayeġ in sa kwaġ vesa rot. Gesëḳ bo kwaġ in honġ bemedo, ");
INSERT INTO bzh_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","in su rëḳ gwevuu sa ḳenug bemedo Nyëġ-diiḳsën-yi rë. Log su rëḳ gwevuu honġ mehö vabuung bepetar na rë. ");
INSERT INTO bzh_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ġetato aggata mala-tumsën-yi vu sa, om rëḳ ġemedo geving sa, lom rëḳ sa kwaġ vesa rot.’ ");
INSERT INTO bzh_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Arig lo, sa bë nanër niröp vu ham nabë hil mehö teta wirek hen Davit diiḳ ggovek ya, bedelev. Geyi bedub nahën neggëp vu hil gwëbeng. ");
INSERT INTO bzh_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Rëḳ mu Davit yi mehö-nenër-ġaġek-ranġahsën ti, log yö raḳ ni bë Anutu nër yönon venuh nebë, ‘Sëḳ ġetunġ honġ mewis ti bemedo jaḳ honġ sëa natu mehö-los-bengö doḳ nah böm.’ ");
INSERT INTO bzh_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Wirek Davit lë nġaa sën Anutu rëḳ gevonġ lo, log nër raḳ Kerisi bë rëḳ kedi jaḳ nah. Nër bë Anutu su rëḳ gevuu yi bemedo Nyëġ-diiḳsën-yi benavi petar na rë. ");
INSERT INTO bzh_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yönon, Anutu nër beYesu saga kedi raḳ yah, behe pin halë nġaa sën agi ggovek ya om sën he nanër. ");
INSERT INTO bzh_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Gwëbeng raḳ yah vavunë ggovek beya nedo Anutu nema vesa, beḳo Anon Vabuung ggëp ama nema ggovek ya, yoh vu sën wirek Ama nër bë rëḳ bo vu yi lo. Lob nġaa sën ham lë los ham nġo gwëbeng lo tato bë vonġ yam ggovek. ");
INSERT INTO bzh_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davit su raḳ ya yaġek rë, rëḳ nër bë: ‘Mehöböp nër vu sa Mehöböp nebë, “Ġemedo sa nemaġ vesa. ");
INSERT INTO bzh_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Gevu tamusën og sëḳ ġetunġ alam sën denelë honġ paya lo dedoḳ na vaham ġebinë.” ’ ");
INSERT INTO bzh_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nebë sënë om hil Israel pin ajaḳ ni yönon nabë Yesu saga sën ham rekö yi raḳ ya ḳelepeḳo* lo, saga Anutu tunġ yi netu hil Mehöböp los hil Kerisi.” ");
INSERT INTO bzh_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Alam sënë denġo ġaġek saga lob gelu ayoj rot, lom denër vu Pita losho sinarë saga nebë, “O arig lo! He rëḳ ġevonġ nabë va?” ");
INSERT INTO bzh_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Loḳ Pita nër yah vu sir bë, “Ham ti ti nġo gwërin ayomin geham jipek bël jaḳ Yesu Kerisi arë in dahun ham nġaa nipaya pin na, lob mëm Anutu rëḳ gevonġ Anon Vabuung vu ham. ");
INSERT INTO bzh_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","In wirek Anutu nër bë gevonġ yi vu ham los nalumin, gevu alam pin sën nahën denedo ading in yi lo geving. Yönon! Rëḳ gevonġ vu alam pin sën hil Mehöböp Anutu tahi sir bë dena vu yi lo.” ");
INSERT INTO bzh_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita nër ġaġek agga nġahiseḳë hus ading rot vu sir, log nër niwëëk bë, “Ham gweġin ham! Ham kwehe ham vër in alam nij paya sën denedo dob-ë!” ");
INSERT INTO bzh_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nebë saga, lob sir vahi dejom Pita yi ġaġek ahon medenevonġ ving, lom deripek bël. Lob vu buk saga sir 3,000 derevuh ya ving Mehöböp yi hur medenedo. ");
INSERT INTO bzh_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nijwëëk bë degenġo alam sinarë hir ġaġek, lom detu degwa timu in dedoḳ vu sir, lob denedo revuh ti bedenegga Pasa gedenejom raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Lom Anutu vonġ balam sinarë devonġ nġaa böp nġahiseḳë balam pin delë lob deggöneng. ");
INSERT INTO bzh_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Lob alam pin sën ayoj neya timu vu Kerisi lo denedo revuh ti, log sir ti su ggulin yi nġaa rë, gaḳ denevonġ nġaa pin tu sir pin hir nġaa. ");
INSERT INTO bzh_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Devonġ hir dob los hir ḳupeḳ in bë alam debaġo, lob deneḳo monë raḳ medenevo ggelek sir pin in bë ti su jaḳ vu in nos lu nġaa. ");
INSERT INTO bzh_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Sir pin ayoj timu gedeneya dub-vabuung-böp ḳatum ayo yoh vu buk, log denesupin sir loḳ hir begganġ ti ti medenegga Pasa, log kwaj vesa medenevonġ hir nos ggelek sir. ");
INSERT INTO bzh_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Deneḳo Anutu arë raḳ yoh vu buk, galam pin ayoj netee yi in sir. GeMehöböp nevonġ balam deneggërin ayoj yah vu yi mederevuh yam ving sir sënë yoh vu buk. ");
INSERT INTO bzh_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Buk ti lob Pita luho Jon deya dub-vabuung-böp raḳ 3 krök sehuksën in bë denajom jaḳ. In alam Yuda denevonġ nebë sënë. ");
INSERT INTO bzh_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lob mehö vaha nipaya ti nedo, lob yi alam denevaḳu yi meyam denetunġ menedo dus vu veluung avi sën denenër arë nebë Malanġeri lo. Ata yö ḳo yi to los vaha nipaya, lom denevonġ nebë saga yoh vu buk in bë ketaġ los tahi monë lu nġaa vu alam sën deneya dub-vabuung-böp ḳatum ayo lo. ");
INSERT INTO bzh_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mehö saga lë Pita luho Jon geluho bë dedoḳ na dub-vabuung-böp, lob ketaġ vu luho bë luho debo nġaa vu yi. ");
INSERT INTO bzh_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Rëḳ Pita luho Jon degët yi niwëëk ata, log Pita nër vu yi bë, “Ġebarah malam jaḳ megwelë aluu rë!” ");
INSERT INTO bzh_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Lob kwa vo bë maḳ luho rëḳ debo nġaa vu yi, lom peggirin mala yah vu luho. ");
INSERT INTO bzh_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Rëḳ Pita nër bë, “Sehöġ monë ma! Gaḳ mu sa bë doḳ vu honġ nabë sënë: Sa nanër vu honġ jaḳ Yesu Kerisi Nasaret arë nabë, ‘Kwedi jaḳ meġena!’” ");
INSERT INTO bzh_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Lom jom loḳ nema vesa bedadii yi raḳ. Lob pevis bevaha los vaha pedus niwëëk loḳ, ");
INSERT INTO bzh_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","gemëm kedi pevis mevare neya. Beloḳ ya dub-vabuung-böp ḳatum ayo ving luho, genepisek menepesönġ geneḳo Anutu arë raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Lob alam pin delë bë ggee meneya geneḳo Anutu arë raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Lob deraḳ ni bë yiḳ mehö sën nedo yoh vu buk loḳ dub-vabuung-böp veluung avi Malanġeri, meneketaġ los netahi monë lu nġaa vu sir lo. Lob delë bë nivesa raḳ lom delëk anon bekwaj neketul loḳ. ");
INSERT INTO bzh_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mehö sënë nahën nekebi Pita lu Jon, lob alam deseröġ meya detetup lööho loḳ dub nenga-gelusën sën denenër bë Solomon yiyi lo, lob delëk böpata rot. ");
INSERT INTO bzh_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita lë alam sagi lob nër ġaġek vu sir bë, “Ham alam Israel! Nebë va sën ham ayomin ya nġahiseḳë in nġaa agi-ë? Ham su gwelë aluu! Maḳ ham kwamin nevo bë raḳ alu nġo he niwëëk ma maḳ alu nġo vabuung om sën alu hevonġ mehö aga benivesa raḳ meneya-ë? Gaḳ ma! ");
INSERT INTO bzh_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham luho Isaak ving Yakop hir Anutu sën, hil ḳenud lo hir Anutu lo, sën ḳo yi hur Yesu arë raḳ nebë sënë. Sën yiḳ mehö saga sën ham vo yi loḳ ya alam-beġö-yi nemaj, geham lah yi vun ggëp Pilatus mala lo. Pilatus bë dëëin yi mena, rëḳ ma geham ruu demimin vu yi! ");
INSERT INTO bzh_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ham ruu demimin vu mehö vabuung los yohvu saga, log ham tahi vu Pilatus bë dëëin mehöti sën sis mehö la bedediiḳ lo vër vu ham. ");
INSERT INTO bzh_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mehö mala-tumsën degwa yi rëḳ ham sis yi bediiḳ. Loḳ Anutu nër mekedi raḳ yah vu bedub, behe halë bë nedo mala-tumsën, besën he nanër ranġah. ");
INSERT INTO bzh_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Galu ayomin neya timu vu yi, om sën alu anër arë, lob vonġ niwëëk vu mehö sënë besën ham nelë yi beham raḳ ni lo. Yesu vonġ mehö sënë nivesa raḳ raḳ ham pin malamin in alu ayomin neya timu vu yi. ");
INSERT INTO bzh_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Yönon, arig lo! Seraḳ ni bë ham los ham ggev su raḳ degwa ni rë, om sën ham vonġ paya vu yi nebë sënë. ");
INSERT INTO bzh_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Rëḳ wirek Anutu yö tateḳin ġaġek verup alam-denenër-ġaġek-ranġahsën lo pin avij nebë yö yi Kerisi rëḳ nam begeḳo vanë. Lob vonġ ġaġek saga banon raḳ raḳ huk sën ham vonġ lo. ");
INSERT INTO bzh_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Om ham gwërin ham nom vu Anutu in Anutu dahun ham nġaa nipaya pin na, lob mëm Mehöböp rëḳ gevonġ beham nimin semë semë jaḳ. ");
INSERT INTO bzh_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Lob rëḳ gevonġ Yesu nom vu ham. Mehö saga sën Anutu ggooin raḳ in bë geḳo hil nah lo. ");
INSERT INTO bzh_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Log gwëbeng nedo yaġek meneġin buk sën Anutu bë gevonġ nġaa pin natu mewis lo. Nebë sën nër wirek verup alam-denenër-ġaġek-ranġahsën vabuung lo avij lo. ");
INSERT INTO bzh_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses nër nebë, ‘Ham Mehöböp rëḳ gooin ham arimin ti begetunġ yi natu ham mehö-nanër-ġaġek-ranġahsën ti nabë sa. Om ham gwebë nengamin vu ġaġek sën rëḳ nanër vu ham lo. ");
INSERT INTO bzh_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Gaḳ nabë mehöti su genġo mehö-nenër-ġaġek-ranġahsën saga aye rë, og Anutu rëḳ gevonġ bemala nama, gesu rëḳ medo mala-tumsën geving yi alam rë.’ ");
INSERT INTO bzh_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Log alam-denenër-ġaġek-ranġahsën pin yiḳ denenër ġaġek nebë saga. Samuel losho alam sën deneverup ggökin yi medenenër ġaġek ranġah lo, sir pin denenër ġaġek raḳ buk sënë. ");
INSERT INTO bzh_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Lob gwëbeng ham loḳ yah alam-denenër-ġaġek-ranġahsën bej, beġaġek sën Anutu losho hil ḳenud lo dejoo venuh wirek lo anon raḳ vu ham, in nër vu Abraham bë, ‘Honġ mewis ti rëḳ natu mehö semusemu bedoḳ vu alam pin vu dob.’ ");
INSERT INTO bzh_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yönon, Anutu kwa vo hil alam Yuda muġin, lob ggooin nalu Yesu raḳ bevonġ yam in bë gevonġ semusemu vu hil. Log semusemu sënë nebë hil pin ti ti nġo ġevuu hil nipaya na baġërin hil nom vu yi.” ");
INSERT INTO bzh_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita luho Jon nahën denenër ġaġek vu alam, log alam-deneḳo-seriveng losho mehö sën neġin alam loḳ dub-vabuung-böp lo, galam Sadukai* lo, bedeverup. ");
INSERT INTO bzh_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ahëj sengën vu luho in luho denenër ġaġek ranġah vu alam bë Yesu kedi raḳ yah vu bedub. ");
INSERT INTO bzh_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Lob dejom luho ahon medetunġ luho ya denedo ḳarabus in sehuk luḳ, gemëm bë monbuk lom degevonġ ġaġek vu luho. ");
INSERT INTO bzh_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Rëḳ mu alam nġahiseḳë sën denġo luho hir ġaġek lo devonġ ving, bederevuh yam ving alam muġinsën besir 5,000 raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Heng to lob alam Yuda hir ggev losho alam teta, galam-horek-yi, desupin sir vu Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Alam-deneḳo-seriveng hir ggev böp Anas, geKayapas luho mehöti arë nebë Jon, gAleksander, gAnas yi alam pin medesupin sir. ");
INSERT INTO bzh_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Log devarah Pita luho Jon ya denare malaj gedeloḳ tepëḳ in luho bë, “Melu vonġ nġaa sagi raḳ re niwëëk-a? Ma re vonġ meluu yam-a?” ");
INSERT INTO bzh_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Lob Anon Vabuung loḳ yam ggërin Pita ayo lom nër vu sir bë, “Ham ggev los alam teta vu Israel! ");
INSERT INTO bzh_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Gwëbeng ham maḳ bë doḳ tepëḳ in aluu in nġaa nivesa sën alu hevonġ vu mehö vaha nipaya-ë. Maḳ ham bë jaḳ mehö sën nivesa raḳ agi degwa ni? ");
INSERT INTO bzh_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nabë nebë saga, og mëm alu hevonġin bë ham jaḳ ni balam Israel pin dejaḳ ni geving nabë: Yesu Kerisi Nasaret niwëëk vonġ mehö sagi benivesa raḳ los dahis begwëbeng nare ham malamin. Ham sis mehö saga bediiḳ raḳ ḳelepeḳo*, rëḳ Anutu nër bekedi raḳ yah ggëp bedub. ");
INSERT INTO bzh_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yönon! ‘Ham alam sën denelev begganġ lo nimin lëlin ġelönġ ti sënë. Rëḳ mu netu ġelönġ niwëëk begganġ nyëḳetu yi.’ Og ġelönġ saga yiḳ Yesu. ");
INSERT INTO bzh_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Su mehö ngwë yoh vu bë doḳ vu hil rë. In vu dob pin og Anutu su tato arë agga ngwë vu hil bë rëḳ geḳo hil nah vu yi rë.” ");
INSERT INTO bzh_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Denġo bë Pita luho Jon denër ranġah niwëëk, lob deranġa nemaj in deraḳ ni bë luho su deluḳ dub rë, gaḳ luho alam meris mu. Lob kwaj ya nġahi, rëḳ deraḳ ni bë wirek luho deneya ving Yesu. ");
INSERT INTO bzh_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Log mehö sënë nare ving luho gedelë bë navi nivesa raḳ yönon, lob su deyoh vu bë denanër ġaġek ti doḳ nah vu luho rë. ");
INSERT INTO bzh_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Lob alam ggev denër vu lööho bë lööho degeto dena dobnë rë. Lob lööho to deya, log mëm yö yah desap sir raḳ medenër bë, ");
INSERT INTO bzh_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Rëḳ hil ġevonġ va vu mehö luu saga? Luho devonġ nġaa böp sënë balam vu Yerusalem pin deraḳ ni, om hil su ayoh vu bë rëḳ abun ġaġek saga rë. ");
INSERT INTO bzh_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Gaḳ ġaġek saga rëḳ na menoh vu alam pin, om hil nanërin luho niwëëk nabë luho su dena denanër ġaġek jaḳ Yesu arë saga vu mehö la gökin.” ");
INSERT INTO bzh_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Lob detahi luho yom bemëm denër vu luho bë luho su na denanër ġaġek jaḳ Yesu arë, beluho su detahu ġaġek sënë vu alam. ");
INSERT INTO bzh_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Rëḳ Pita luho Jon denër yah vu sir bë, “Nabë alu ġevuu Mehöböp yi ġaġek sënë na galu sepa doḳ ham ġaġek, og maḳ Anutu rëḳ gelë aluu nivesa? Ham nġo kwamin bo saga rë. ");
INSERT INTO bzh_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Alu su ayoh vu bë rëḳ ayemin nama rë. Gaḳ alu rëḳ nanër ġaġek ranġah jaḳ nġaa pin sën alu halë los hanġo lo!” ");
INSERT INTO bzh_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Lob ggev lo devonġ ġaġek raḳ luho niwëëk ggökin, log mëm delëëin luho beluho deya. Alam ggev deggöneng in alam, in sir pin deneḳo Anutu arë raḳ in nġaa sën luho devonġ agi, lob su kwaj ḳo aggata ti in bë debo vanë vu luho rë. ");
INSERT INTO bzh_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Gemehö sën luho devonġ nġaa böp raḳ yi benivesa raḳ lo, yi ta mehödahis luu gekesuu meya. ");
INSERT INTO bzh_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Devonġ luho ya, lob luho deyah medeya vu hir alam bedenër alam-deneḳo-seriveng hir ggev los alam teta hir ġaġek pin vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Denġo ggovek, log sir pin ayoj timu gedejom raḳ vu Anutu bë, “O Mehöböp, nġo ġetunġ dob los yaġek los loo benġaa pin sën denedo loḳ lo. ");
INSERT INTO bzh_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wirek honġ Anon Vabuung vonġ ġaġek ti verup loḳ honġ hur Davit avi, sën he ḳenumin lo, nebë: ‘Nebë va sën alam-yu-ngwë ahëj sengën panġsën rot, gemehönon la medo denevengwënġ yah nenga meris mu-e? ");
INSERT INTO bzh_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Alam-los-bengöj vu dob sënë pin kedi dero sir in degevonġ beġö, log alam böp pin desupin sir medevengwënġ raḳ beġö in bë dedahun Mehöböp luho Mehö sën ggooin raḳ in bë geḳo hil nah lo na.’ ");
INSERT INTO bzh_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Yönon rot, Herot* luho Pontius Pilatus ving alam-yu-ngwë, galam Israel, bedevengwënġ yah nenga nebë saga ggëp nyëġ böp Yerusalem in bë dedahun honġ hur vabuung Yesu na. Mehö sën wirek ġehooin yi raḳ lo. ");
INSERT INTO bzh_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Dejoo ġaġek revuh ti nebë saga in bë degevonġ nġaa sën wirek ġeduu ġaġek ahon niwëëk bë rëḳ anon jaḳ lo. ");
INSERT INTO bzh_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Om Mehöböp, nġo kwam bo ġaġek maggin pin sën bë degevonġ-ë rë meġedoḳ vu honġ hur he, log gwevonġ niwëëk vu he in he nanër honġ ġaġek ranġah, gehe su aġöneng. ");
INSERT INTO bzh_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ġebër nemam niwëëk jaḳ begwevonġ alam niraḳsën nijvesa jaḳ, log gwevonġ nġaa böp los huk aggagga jaḳ honġ hur vabuung Yesu arë.” ");
INSERT INTO bzh_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nahën denejom raḳ nebë sënë, log begganġ sën desupin sir loḳ lo ggee böpata gAnon Vabuung yam ggërin ayoj, lob mëm denenër Anutu yi ġaġek niwëëk ata gesu deneggöneng rë. ");
INSERT INTO bzh_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Alam sën ayoj neya timu vu Yesu lo ahëj los ayoj neya timu vu sir vewen vewen ving. Su mehöti lë yi nġaa ti benër bë, “Sagiḳ sa nġaa!” rë, gaḳ hir nġaa pin saga sën tu sir pin hir nġaa. ");
INSERT INTO bzh_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Lob sinarë nyëdahis lo denenër ġaġek ranġah bë Mehöböp Yesu kedi raḳ ggökin, lob hir ġaġek saga los niwëëk balam pin deneḳo arëj raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Sir ti su raḳ vu in nos los nġaa ti rë, in sir sën deyoh vu dob los begganġ lo pin denevo vu alam vahi medeneḳo monë raḳ. Deneḳo monë raḳ, ");
INSERT INTO bzh_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","lob devo vu sinarë nyëdahis lo medeneġin, loḳ mëm sinarë denevo ggelek alam sën deneraḳ vu in nġaa lo. ");
INSERT INTO bzh_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mehöti nedo, arë nebë Yosep, lob sinarë denër ggev ngwë raḳ yi nebë Barnabas. Arë sënë degwa nebë mehö nelev horek in alam. Yi Levi* ti, geyi vu dob Kupros. ");
INSERT INTO bzh_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Lob yi dob len ti neggëp Yerusalem, lob vonġ bemehöti baġo, lob ḳo monë saga beya mevo vu sinarë lo. ");
INSERT INTO bzh_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Log mehö ngwë nedo arë nebë Ananias, gevenë arë nebë Sapira. Lob Ananias vonġ yi dob len ti bemehö la debaġo. ");
INSERT INTO bzh_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Rëḳ luho venë devengwënġ loḳ ti, lom devun monë saga vewen betu luho yö hir nġaa. Log Ananias ḳo vewen beya mevo vu alam sinarë genër bë monë sën lo yiḳ pin sënë. ");
INSERT INTO bzh_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Loḳ Pita nër vu yi bë, “Ananias, Satan nare loḳ ayom beġevun dob sagi yi monë vahi geġetetuhin Anon Vabuung. ");
INSERT INTO bzh_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Wirek sën su debaġo dob rë lo, og yiḳ nġo honġ nġaa! Log debaġo om maḳ monë saga netu honġ nġaa in bë gweġin megwevonġ noh vu kwam. Ma re nër vu honġ bë gwevonġ paya nabë sënë? Su ġelah monë sënë vewen vun in mehönon mu rë, gaḳ ġelah vun in Anutu!” ");
INSERT INTO bzh_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias nġo ġaġek sagi, lob diiḳ pevis beto neggëp, lob alam sën vare denelë lo deggöneng böpata rot. ");
INSERT INTO bzh_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Lob alam maġëm kedi debom loḳ tob beya delev. ");
INSERT INTO bzh_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ggovek gehes mala löö ggovek ya, log Ananias venë verup yam begganġ ayo, lob su raḳ nġaa sën töḳ vu regga lo ni rë. ");
INSERT INTO bzh_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Lom Pita loḳ tepëḳ vu yi bë, “Maḳ yiḳ melu ḳo monë yoh vu sën raḳ dob saga ma ma?” Loḳ avëh nër yah bë, “Ëë-ë! Yoh vu! Alu haḳo nebë saga!” ");
INSERT INTO bzh_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Rëḳ Pita nër bë, “Melu reggam joo ġaġek revuh ti gemelu bë seggi Mehöböp yi Anon Vabuung-a? Om gwenġo! Alam sën delev reggam lo yom denare loḳ veluung avi, om rëḳ debaḳu honġ geving bena dedev!” ");
INSERT INTO bzh_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lob pevis bavëh saga diiḳ beto neggëp loḳ Pita vaha, lob alam maġëm deloḳ yam begganġ ayo medelë bë avëh diiḳ meneggëp, lom devaḳu beya delev ving regga. ");
INSERT INTO bzh_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Lom Kerisi-yi-alam pin ving alam pin sën denġo ġaġek agi deggöneng böpata rot. ");
INSERT INTO bzh_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Lob sinarë nyëdahis devonġ nġaa böp aggagga raḳ alam vahi besir pin denelë, lob mëm alam sën denesepa loḳ Yesu lo pin ayoj timu gedenesupin sir loḳ dub-vabuung-böp nenga-gelusën sën denenër bë Solomon yiyi lo. ");
INSERT INTO bzh_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Lob alam vu Yerusalem pin deḳo arëj raḳ, rëḳ deggöneng gesu desupin sir ya ving sir rë. ");
INSERT INTO bzh_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Rëḳ alam maluh los avëh nġahiseḳë ayoj ya timu vu Mehöböp bederevuh yam ving yi alam, bedetu yu böpata raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Lob tum denevaḳu alam nijraḳsën meyam debë neggëp loḳ ḳanyë los bëk loḳ aggata, lob denebë sir ti ti ya ya in bë Pita geto mena, og hes gelu ḳenu na mejaḳ sir. ");
INSERT INTO bzh_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Galam vu nyëġ pin sën denedo dus vu Yerusalem lo denesupin sir yam. Deneḳo alam nijraḳsën ving alam sën memö nipaya gwanġ ya sir lo, lob alam saga pin nijvesa raḳ yah ggökin. ");
INSERT INTO bzh_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nebë saga lob alam-deneḳo-seriveng hir ggev böp losho yi alam Sadukai* pin denelë Yesu yi alam paya, ");
INSERT INTO bzh_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","om dejoo ġaġek lob kedi dejom sinarë nyëdahis lo ahon bedetunġ sir luḳ ya ḳarabus. ");
INSERT INTO bzh_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Rëḳ Mehöböp yi angër yam tahinin repinġ in sir buk vuheng, log ḳo sir to meyah dobnë genër bë, ");
INSERT INTO bzh_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ham na bare dub-vabuung-böp ḳatum ayo beham tateḳin ġaġek vu alam pin nabë degevonġ nabë sënë in denatu mewis medemedo malaj-tumsën.” ");
INSERT INTO bzh_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Denġo ġaġek saga, log monbuk anon lob deyah dub-vabuung-böp bedetateḳin ġaġek vu alam. Getum alam-deneḳo-seriveng hir ggev böp losho yi alam ya medo denesupin kaunsor pin yam. Log denër ġaġek ya begganġ ḳarabus bë degeḳo sinarë nam. ");
INSERT INTO bzh_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lob hir hur deloḳ ya begganġ ḳarabus, rëḳ sinarë su denedo rë. ");
INSERT INTO bzh_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Lob yah denër vu sir bë, “He halë begganġ ḳarabus yi repinġ rëḳ desis loḳ beniwëëk gahëvavu denare medeneġin. Lob he tahinin, rëḳ he su atöḳ raḳ mehöti genedo begganġ ayo rë.” ");
INSERT INTO bzh_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Lob hir ggev sën neġin alam loḳ dub-vabuung-böp lo losho alam-deneḳo-seriveng hir ggev denġo ġaġek saga, lob kwaj ya nġahiseḳë bedenesero degwa. ");
INSERT INTO bzh_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Loḳ mehöti ya verup vu sir benër bë, “Alam sën ham tunġ sir ya ḳarabus lo denare dub-vabuung-böp ḳatum ayo medenetateḳin ġaġek vu alam.” ");
INSERT INTO bzh_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Lob hir ggev sën neġin alam loḳ dub-vabuung-böp lo, losho ahëvavu la, ya deḳo sir. Rëḳ su desis sir gederot rë gema. In deneggöneng in alam bë rëḳ detengwa sir jaḳ ġelönġ. ");
INSERT INTO bzh_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Deḳo sir yam medevarah sir nare vuheng loḳ kaunsor lo malaj, galam-deneḳo-seriveng hir ggev böp nër vu sir bë, ");
INSERT INTO bzh_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“He nër niwëëk ata vu ham bë ham su na nanër bengö saga ranġah vu alam, rëḳ ham nevonġ in va? Ham nenër ġaġek saga ya meyoh vu Yerusalem pin beham vonġin bë gweḳo ġaġek jaḳ nom he nabë he sis mehö saga mediiḳ!” ");
INSERT INTO bzh_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Rëḳ Pita losho sinarë saga denër yah vu sir bë, “He bë sepa doḳ Anutu yi ġaġek namuġin, gemehönon hir ġaġek gëp tamusën! ");
INSERT INTO bzh_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ham vonġ paya vu Yesu beham sis yi raḳ ḳelepeḳo*, rëḳ hil ḳenud hir Anutu nër mekedi raḳ yah. ");
INSERT INTO bzh_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Anutu ḳo yi raḳ yah vavunë betunġ yi nedo nema vesa. Lob tu ala in geḳo hil nah vu Anutu, gevonġin gërin hil Israel ayod gekevoh hil nġaa nipaya na. ");
INSERT INTO bzh_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","He halë nġaa pin saga, om sën he nanër ranġah gAnon Vabuung sën Anutu vonġ vu alam sën nengaj yes vu yi ġaġek lo tateḳin ġaġek sagi ving.” ");
INSERT INTO bzh_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kaunsor lo denġo yi ġaġek saga lob ahëj sengën panġsën rot gedevonġin bë dengis sinarë pin saga medenadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Rëḳ kaunsor ti arë nebë Gamaliel kedi nare. Yi Parisai* ti, geyi tatovaha horek yi los bengö. Alam pin ahëj neving yi rot los deneḳo yi raḳ. Lob kedi menër vu sir bë degevonġ sinarë geto dena dobnë teka rë, lob to deya. ");
INSERT INTO bzh_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Log nër vu kaunsor pin bë, “Ham alam Israel! Bë ham gwevonġ nġaa ti vu alam sënë, og maḳ ham nġo kwamin bo nivesa rë. ");
INSERT INTO bzh_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ham raḳ ni bë wirek mehöti arë nebë Tiudas kedi benër bë, ‘Sa, sa mehö los niġ wëëk böpata!’ Lob alam raḳ neggëp alam mehödahis ti (400) yah detamuin yi. Rëḳ desis yi bediiḳ, log alam sën denetamuin yi lo deveya beya depalët loḳ geyi huk vës bemala maya veröḳ yi. ");
INSERT INTO bzh_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Log tum buk sën kiap böp nekevu mehönon arëj lo lob Yudas vu Galilea kedi raḳ beḳo alam vahi yah detamuin yi. Rëḳ desis yi ving bediiḳ, log alam pin sën denetamuin yi lo deketëḳin sir bemaya. ");
INSERT INTO bzh_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Om sën sa bë nanër vu ham nabë ham ġöneng in alam saga, geham naḳööḳ gedemedo rë. Nabë yö denevonġ huk yoh vu mehönon kwaj, og rëḳ noh paya bebës. ");
INSERT INTO bzh_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Gaḳ nabë degwa neggëp vu Anutu yönon, og ham su yoh vu bë rëḳ kwepë sir rë, om ham gweġin ham in ham su ngis beġö vu Anutu!” ");
INSERT INTO bzh_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Lob devonġ ving Gamaliel yi ġaġek saga, gedetahi sinarë pin loḳ yah bedeveek sir, log denër niwëëk vu sir bë su denanër Yesu bengö ranġah log delëëin sir medeya. ");
INSERT INTO bzh_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Lob mëm devuu kaunsor ya geto deyah dobnë, lob kwaj vesa rot in Anutu ḳo sir raḳ belë sir bë deyoh vu bë alam degevonġ benij namum in Yesu arë. ");
INSERT INTO bzh_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Lob medo denetateḳin ġaġek ranġah loḳ dub-vabuung-böp geloḳ begganġ la yoh vu buk pin. Beyö medo denenër Yesu Kerisi bengö ranġah gaḳ su denevuu rë. ");
INSERT INTO bzh_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nahub geYesu yi hur nġahiseḳë raḳ, lob sir vahi sën denevengwënġ Grik ayej lo ahëj sengën vu vahi sën denevengwënġ alam Yuda ayej lo. Ahëj sengën raḳ degwa nebë sënë: Alam sën denevengwënġ Grik ayej lo denenër bë, “Ham nevo nos ggelek alam yoh vu buk pin log ham su nevo vu he hömin avëh alov lo rë.” ");
INSERT INTO bzh_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Lob hurmaluh nemadluho-bevidek-luu muġinsën desupin Yesu yi hur lo pin yam medenër vu sir bë, “Bë he ġevuu Anutu yi ġaġek na gehe bo nos gelek, og su yoh vu rë! ");
INSERT INTO bzh_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Arig lo! Ham nġo ġooin ham alam nemadvahi-bevidek-luu jaḳ rë. Sir sën alam nijvesa gAnon Vabuung nedo loḳ sir niwëëk lo, gesir sën los kwaj lo. Lob mëm hil ġevonġ medegeġin huk sagi. ");
INSERT INTO bzh_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Gaḳ heḳ nġo rëḳ medo in najom jaḳ noh vu buk pin los tateḳin Anutu yi ġaġek mu.” ");
INSERT INTO bzh_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Alam pin ahëj ving ġaġek saga, lob deggooin Stepan, sën mehö yö nevonġ ving niwëëk ata gAnon Vabuung nedo niwëëk ving yi lo. Log deggooin Pilip luho Prokorus ga, Nikanor luho Timon, geParmenas, geNikolas vu Antiok. Wirek yi alam-yu-ngwë ti rëḳ ggërin yi beloḳ ya metu alam Yuda ti. ");
INSERT INTO bzh_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Devarah alam saga loḳ sinarë malaj, log dejom raḳ gedebë nemaj raḳ sir. ");
INSERT INTO bzh_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Log Anutu yi ġaġek ya meyoh vu nyëġ pin, balam nġahiseḳë detu Yesu yi hur vu Yerusalem. Galam-deneḳo-seriveng vahi ayoj neya timu vu yi ving. ");
INSERT INTO bzh_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Anutu vonġ semusemu los niwëëk böpata vu Stepan, lob nevonġ nġaa böp aggagga balam denelë. ");
INSERT INTO bzh_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Rëḳ alam vahi kedi desis beġö raḳ ġaġek yah vu Stepan. Alam sagi vu Kurene los Aleksandria, gedenenër hir dub-supinsën-yi saga nebë alam sën devo sir vër in mehö ngwë nemaj ggovek lo hir hir. Gesir vahi vu Kilisia los Asia* ving. ");
INSERT INTO bzh_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Rëḳ su deyoh vu bë dekeyëh Stepan yi ġaġek rë, in Anon Vabuung yö vo kwa nivesa vu yi. ");
INSERT INTO bzh_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Lom devo monë vu mehö la in bë denanër ġaġek kuungsën jaḳ Stepan nabë, “He hanġo bë nenër ġaġek pelësën raḳ Moses lu Anutu!” ");
INSERT INTO bzh_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Alam saga devonġ balam teta los alam-horek-yi galam pin ahëj sengën vu raḳ saga, lob mëm sir yö depesönġ medejom Stepan ahon bedeḳo ya nare kaunsor mala. ");
INSERT INTO bzh_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Log devarah mehö la in bë denanër ġaġek kuungsën jaḳ yi lom denër bë, “Mehö saga nenër ġaġek nipaya raḳ dub-vabuung-böp sënë, geraḳ Moses yi horek. ");
INSERT INTO bzh_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","He hanġo mehö saga nër bë, ‘Yesu Nasaret saga rëḳ kevoh dub-vabuung-böp sënë gepekwë ġaġek wirek hen sën Moses vonġ vu hil lo benatu agga ngwë jaḳ.’” ");
INSERT INTO bzh_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Lob kaunsor pin detunġ malaj raḳ Stepan niwëëk ata, lom delë mala niḳapiik raḳ nebë angër ti. ");
INSERT INTO bzh_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Lob alam-deneḳo-seriveng hir ggev böp loḳ tepëḳ bë, “Ġaġek sagi yönon-a?” Lob Stepan nër yah bë, ");
INSERT INTO bzh_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","“O arig lo, amaġ lo! Ham gwenġo rë! Wirek hil dobahë Abraham nahën nedo Mesopotamia gesu ya Haran rë, lob vu buk saga niwëëk ala Anutu töḳ vu yi. ");
INSERT INTO bzh_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Lom nër vu yi bë, ‘Gwevuu honġ dob los honġ alam na geġena nyëġ len ti sën sëḳ tato vu honġ.’ ");
INSERT INTO bzh_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Lob Abraham vuu Kaldia hir dob geya nedo Haran. Denedo saga bama diiḳ ggovek, loḳ mëm Anutu vonġ yi yam nedo nyëġ sën gwëbeng hil nado loḳ agi. ");
INSERT INTO bzh_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Rëḳ Anutu su vo dob sënë len mahen teka vu Abraham in bë yö geġin menatu yi nġaa niröp rë, gema. Rëḳ Anutu nër bë tamusën og rëḳ bo dob sagi vu yi benajom ahon, in natu yi mewis lo pin hir dob geving. Rëḳ mu, loḳ buk sën Anutu nër ġaġek vu yi agi, og Abraham nalu ma. ");
INSERT INTO bzh_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Log Anutu nër ving bë, ‘Honġ mewis rëḳ na demedo alam-yu-ngwë hir dob. Lob rëḳ denatu alam-yu-ngwë saga hir hur bededeġinengin sir jaḳ huk ḳarabus noh vu ta jaḳ gëp alam mehödahis ti (400). ");
INSERT INTO bzh_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Rëḳ mu tamusën, og sëḳ ġevonġ nyëvewen vu alam-yu-ngwë saga sën rëḳ dedeġinengin honġ mewis raḳ maggin böp lo. Loḳ mëm rëḳ degevuu nyëġ sagi na, gedenam denajom jaḳ vu sa gëp sagi.’ ");
INSERT INTO bzh_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Lob Anutu joo ġaġek vu Abraham bë gerah* nalu maluh lo navij. Lob nahub rë loḳ Abraham ḳo nalu Isaak, lob neggëp rot beyah verup loḳ buk sën netu nemadvahi-bevidek-löö sën ata ḳo yi lo, lob ama rah* navi. Log Isaak vonġ nebë sënë vu nalu Yakop ving, geYakop vonġ vu hil degwa nemadluho-bevidek-luu nebë saga ving. ");
INSERT INTO bzh_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Rëḳ hil degwa lo saga denelë arij Yosep paya, lom devo yi vu alam-yu-ngwë bedebaġo yi. Bedeḳo medeya Ejep betu Ejep ti yi nġaa meris. Rëḳ Anutu nedo ving yi, ");
INSERT INTO bzh_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","meloḳ vu yi, beḳo yi vër vu nġaa nipaya pin sën deġinengin yi lo. Vonġ semusemu los kwa böpata vu yi loḳ Ejep hir mehö-los-bengö Parao mala belë. Lob tum Parao tunġ yi tu ggev yuseḳë vu Ejep beneġin Parao yi begganġ lu nġaa pin. ");
INSERT INTO bzh_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Lob nahub rëḳ meyip böpata neggëp dob Ejep los Kanaan pin, lob maggin böpata töḳ vu sir, behil ḳenud lo su deyoh vu bë denatöḳ vu nos rë. ");
INSERT INTO bzh_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Rëḳ Yakop nġo bë nos nedo Ejep, lob vonġ hil ḳenud lo deya nos beron muġinsën. ");
INSERT INTO bzh_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ggovek ya loḳ sireḳ deyah netu beron luu, lob mëm Yosep nër yi ranġah vu ari lo bë, ‘Ham arimin sa Yosep.’ Lob mëm Parao raḳ ni bë Yosep yi alam sir. ");
INSERT INTO bzh_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Lob Yosep vonġ ġaġek yah in ama Yakop losho yi alam pin bedeyam vu yi. Sir yoh vu dahis löö benemadluho menemadvahi (75). ");
INSERT INTO bzh_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Lob Yakop luḳ meya nedo Ejep bediiḳ, log hil ḳenud lo denedo bedediiḳ ving. ");
INSERT INTO bzh_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Lob deḳo navij yom Sekem beyah debë loḳ waaḳ sën wirek Abraham baġo vu alam Hamor raḳ monë betu yi waaḳ bedub lo. ");
INSERT INTO bzh_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Lom buk sën bë Anutu gevonġ nġaa sën wirek nër vu Abraham bë rëḳ gevonġ lo neggovek in bë natöḳ nam ranġah, lob alam Israel deverönġ bedeggërin nyëġ Ejep. ");
INSERT INTO bzh_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Beggovek, loḳ Ejep hir mehö-los-bengö mewis ti verup, lob su raḳ Yosep yi huk nivesa sën nevonġ lo ni rë. ");
INSERT INTO bzh_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Om sën nevonġ rii raḳ hil alam, genevonġ huk ḳarabus vu hil ḳenud lo. Geniwëëk rot bë dejuuk naluj maluh niḳöḳ lo na demedo dobnë medenadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Loḳ nahub rë, loḳ Moses ata ḳo yi loḳ buk saga. Lob Anutu ro hurmahen saga nivesa bemalanġeri rot. Lob ata lu ama deġin yi loḳ begganġ ayo yoh vu kwev löö. ");
INSERT INTO bzh_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Loḳ mëm ya debë yi loḳ bël nenga, loḳ tum Parao nalu avëh ḳo yi ya meneġin nebë sën yö nalu. ");
INSERT INTO bzh_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Lob Moses luḳ dub ving Ejep hurmahen bedenetahu yi loḳ alam Ejep hir ġaġek los kwa pin, lom tum netu mehö los kwa-sevërinsën-yi genevonġ huk los niwëëk ving. ");
INSERT INTO bzh_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ggovek geMoses yi ta tu mehödahis luu raḳ, lob kwa vo bë na gelë yi alam Israel. ");
INSERT INTO bzh_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Lom töḳ raḳ Ejep ti genevasap Israel ti, lob loḳ vu Israel ti sagi bevonġ nyëvewen loḳ yah nipaya saga vu besis Ejep ti saga mediiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses kuung bë rëḳ yi alam kwaj bo yi nabë Anutu vonġ yi yam in bë doḳ vu sir. Rëḳ ma gesu kwaj nevo nebë saga rë. ");
INSERT INTO bzh_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Loḳ heng to lob Moses yah verup betöḳ vu Israel luu geluho denesis sir. Lob vonġin bë gevonġ beluho ayoj nakul gebeġö gëp, om nër bë, ‘Alam-a! Melu arimin ham lo! Rëḳ nebë va sën melu nevonġ paya vu ham-ë?’ ");
INSERT INTO bzh_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Rëḳ mehö sën vonġ paya vu ari lo ruuk Moses yah genër bë, ‘Re nër vu honġ bë ġenatu he ggev los mehö sën ġebo nyëvewen vu he? ");
INSERT INTO bzh_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Maḳ bë ġengis sa nabë sën ġesis Ejep ti bediiḳ veseveng lo?’ ");
INSERT INTO bzh_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nër bë saga lob Moses ggöneng beveya meya pevis. Beya nedo alam Median hir nyëġ. Lob mëm rëḳ ḳo nalu maluh luu vu sagu. ");
INSERT INTO bzh_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Log ta mehödahis luu ggovek ya, loḳ mëm angër ti tato yi vu yi neggëp nyëġ-yumeris dus vu ḳedu Sinai. Angër los nengwah daggen loḳ nare ḳele teka niggin ggin. ");
INSERT INTO bzh_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Lob Moses lë lob kwa ya nġahiseḳë in nġaa sën töḳ vu yi. Lob ya dus in bë gelë nivesa, lob Mehöböp aye nër bë, ");
INSERT INTO bzh_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Sa Anutu sën ḳenum lo hir Anutu sa. Sa Abraham luho Isaak geYakop hir Anutu sa.’ Lob Moses lëk beggöneng bë su gelë. ");
INSERT INTO bzh_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Lob Anutu nër vu yi bë, ‘Ġenaḳah suu vër in vaham. In nyëġ sën ġenare loḳ aga og nyëġ vabuung. ");
INSERT INTO bzh_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Sa halë huk nipaya los maggin pin sën dedeġinengin raḳ sa alam vu Ejep, lob gwëbeng seluḳ yam in bë sa ḳevelekin sir los ġaḳo sir vër vu nġaa maggin. Om kwedi jaḳ! Sa bë ġevonġ honġ meġenah Ejep.’ ");
INSERT INTO bzh_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Yiḳ Moses saga sën wirek deruu demij vu yi gedenër bë, ‘Re tunġ honġ bë ġenatu ggev böp los mehö sën ġebo nyëvewen vu he?’ lo. Rëḳ Anutu vonġ yi yah in bë natu hir ggev los kevelekin sir vër, om sën vonġ bangër sënë töḳ vu yi loḳ ḳele mahen teka sën lo in bë bo niwëëk vu yi. ");
INSERT INTO bzh_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Log yiḳ Moses saga sën vonġ nġaa böp aggagga vu sir vu Ejep, loḳ ḳo sir vër beli sir beya deyoh Loo-ḳöḳ vuheng meya deḳo loḳ nyëġ-yumeris yoh vu ta mehödahis luu. ");
INSERT INTO bzh_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Log yiḳ Moses saga sën nër vu alam Israel bë, ‘Anutu rëḳ gevonġ ham ti natu mehö-nanër-ġaġek-ranġahsën nabë sa.’ ");
INSERT INTO bzh_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Log desupin sir ggëp nyëġ-yumeris, lob yiḳ Moses saga sën ya nedo ḳedu Sinai ving angër bevengwënġ ving yi lo. Log Moses nedo ving hil ḳenud lo, lob ḳo Anutu yi ġaġek mala-tumsën-yi bevonġ vu hil, ");
INSERT INTO bzh_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","rëḳ hil ḳenud lo nij lëlin yi gedekeyëh aye bederuuk yi gekwaj vo bë denah Ejep. ");
INSERT INTO bzh_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Lom denër vu Aaron bë, ‘Ġesemu he anutu la in degeli he na. In Moses sën ḳo he vu Ejep meyam lo maḳ ya tena? He duġin!’ ");
INSERT INTO bzh_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Lom mëm desemu burmakau nalu maluh ti ḳenu raḳ goor betu anutu-kuungsën gedenetunġ seriveng vu. Log ahëj nivesa in nġaa sën yö desemu raḳ nemaj agi. ");
INSERT INTO bzh_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Rëḳ Anutu ruu demi vu sir in denejom raḳ los ayej loḳ hes los kwev gebetuheng pin sën denedo yaġek babu lo, yoh vu sën alam-denenër-ġaġek-ranġahsën dekevu meneggëp loḳ Anutu-yi-ḳapiya lo bë: ‘Ham alam Israel, wirek ham nedo ta mehödahis luu vu nyëġ-yumeris, lom ham sis burmakau los sipsip beham vesi netu seriveng. Maḳ saga ham vonġ vu sa? Ma! ");
INSERT INTO bzh_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ham vaḳu anutu-kuungsën Moloḳ yi dub sël ving anutu-kuungsën Rompa yi betuheng ḳenu. Ham semu nġaa ḳenu pin saga in bë ham najom jaḳ vu los gweḳo arëj jaḳ, om sëḳ ġevonġ nyëvewen vu ham, besëḳ ġevonġ beham kwesuu nyëġ böp Babulon* mena medo ḳarabus vu nyëġ adingnë.’ ");
INSERT INTO bzh_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Wirek hil ḳenud denedo nyëġ-yumeris, lob hir dub sël nedo. Saga sën Anutu yi dub sël getato bë nedo ving sir, lob desemu yoh vu sën Anutu nër tato vu Moses bë gevonġ lo. ");
INSERT INTO bzh_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ggovek loḳ hil ḳenud lo deyam ving Yosua in bë degeḳo alam-yu-ngwë hir dob, lob Anutu loḳ vu sir bekevoh alam saga in sir. Vu buk saga deḳo dub sël sën amaj vo vu sir lo sepa, beyam detunġ nedo rot beverup loḳ Davit yi buk. ");
INSERT INTO bzh_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Loḳ mëm Anutu nelë Davit nivesa, lom Davit jom raḳ vu bë rëḳ dev dub ti vu Yakop yi Anutu. ");
INSERT INTO bzh_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Rëḳ ma geneggëp rot bemëm nalu Solomon rëḳ lev. ");
INSERT INTO bzh_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Rëḳ mu Mehö-ġayeheng Anutu su nedo loḳ dub sën mehönon denelev raḳ yö nemaj lo rë. In mehö nenër-ġaġek-ranġahsën nër bë: ");
INSERT INTO bzh_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mehöböp nër bë sënë: “Yaġek netu sa sëa sën sa nado raḳ, gedob saga netu nġadoheng sën sa nehebë vahaġ raḳ lo. Om re yoh vu bë dev dub ti vu sa in bë sa sewah dok-a? ");
INSERT INTO bzh_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ma ham kuung bë sa nemaġ su tunġ nġaa pin sënë rë?” ’ ");
INSERT INTO bzh_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ham alam ayomin niwëëk. Geham ayomin los nengamin dahis. Ham neruuk Anon Vabuung yoh vu buk pin nebë sën ham ḳenumin lo deneruuk wirek lo. ");
INSERT INTO bzh_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mehö-nenër-ġaġek-ranġahsën ti tena sën ham ḳenumin lo su denevonġ paya vu yi rë? Ma! Desis alam sën denenër ġaġek ranġah bë mehö yohvu Yesu rëḳ nam lo bedediiḳ. Lob yi saga yam, rëḳ ham tato yi vu alam-beġö-yi medesis yi bediiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Angër denevo Anutu yi horek vu ham rëḳ ham su nesepa loḳ rë.” ");
INSERT INTO bzh_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Denġo ġaġek sagi, lob ġaġek sagi gelu ayoj rot. Lom deneköö nyëj, gahëj sengën böpata rot vu Stepan. ");
INSERT INTO bzh_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Rëḳ Anon Vabuung ggërin Stepan ayo, lob varah mala raḳ yaġek niwëëk ata benelë Anutu niḳapiik, log lë bë Yesu nare Anutu nema vesa. ");
INSERT INTO bzh_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Lob tahi bë, “Om ham gwenġo rë! Sa halë bë yaġek tateḳin yi, log Mehönon Nalu nare loḳ Anutu nema vesa!” ");
INSERT INTO bzh_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lob dereseeh rur raḳ gedemir nengaj, log sir pin kedi deseröġ meya dejom Stepan ahon, ");
INSERT INTO bzh_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","gederot yi medeḳo medeya Yerusalem ḳatum degwa dobnë, log mëm detengwa yi raḳ ġelönġ bediiḳ. Lob alam sën denër ġaġek kuungsën raḳ yi lo dekah hir tob muġin bedetunġ menedo loḳ mehö maġëm ti arë nebë Saulus vaha bemedo neġin, ");
INSERT INTO bzh_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","log mëm ya detengwa Stepan raḳ ġelönġ. Nahën denesis yi raḳ ġelönġ, log pevis mejom raḳ bë, “Mehöböp Yesu! Gweḳo sanoġ nök vu honġ!” ");
INSERT INTO bzh_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Lom tunġ lus luḳ getahi bë, “Mehöböp, su ġebo doḳ nah hir nġaa nipaya sënë!” Log diiḳ ya. ");
INSERT INTO bzh_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulus vo ġadu loḳ sir in desis Stepan mediiḳ. Lob vu buk saga alam dekedi in bë debo maggin böpata rot vu Kerisi-yi-alam vu Yerusalem medebasap sir. Lob Kerisi-yi-alam pin deveya medeketëḳin sir medeya distrik Yudea lu distrik Samaria gesinarë nyëdahis mu yö nahën denedo nyëġ böp Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Galam vahi sën denesepa loḳ Anutu yi ġaġek medenero lo, sën mëm delev Stepan gedesu böpata rot in yi. ");
INSERT INTO bzh_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Log Saulus mala nesepa bë kevoh Yesu yi alam benama na veröḳ yi, lob nesepa loḳ begganġ pin beneloḳ ya beneḳo maluh gavëh ving, benedadii sir ya ḳarabus. ");
INSERT INTO bzh_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Lob Kerisi-yi-alam sën deveya medeya jeggin jeggin lo deneḳo loḳ rot beya denenër Bengö Nivesa yoh vu nyëġ. ");
INSERT INTO bzh_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip luḳ meya nyëġ böp ti vu distrik Samaria, lob nër Kerisi vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Alam nġahiseḳë denġo yi ġaġek los delë nġaa böp sën nevonġ lo, lom debë nengaj vu yi panġsën. ");
INSERT INTO bzh_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","In denelë gememö nipaya sën negwanġ ya alam nġahiseḳë ayoj lo denġeeḳ geto deya in sir. Log alam nġahiseḳë seḳëj neselönġin, gevahaj nipaya, og nijvesa neraḳ. ");
INSERT INTO bzh_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Lom mëm alam ayoj tee yi rot vu nyëġ saga. ");
INSERT INTO bzh_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Lob mehöti arë nebë Simon nedo saga, beyi mehö nerob alam los nevonġ yeseḳ lu nġaa aggagga, menevonġ balam Samaria* kwaj neya nġahi in yi gedenër bë yi mehö böp ti. ");
INSERT INTO bzh_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Lob alam ggev los alam meris pin nijwëëk bë degenġo yi ġaġek, lob denenër bë, “Mehö saga ḳo Anutu niwëëk böpata yönon!” ");
INSERT INTO bzh_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nijwëëk in bë degenġo yi ġaġek in nerob alam buk nġahiseḳë los nevonġ yeseḳ medenelë yi nġaa böp nebë sënë, lob kwaj neya nġahiseḳë. ");
INSERT INTO bzh_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Loḳ tum mëm Pilip nër Bengö Nivesa raḳ Anutu-yi-nyëġ los nër Yesu Kerisi bengö ranġah, lom maluh los avëh pin devonġ ving bederipek bël. ");
INSERT INTO bzh_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","GeSimon vonġ ving nebë saga ving beripek bël, lob tum nesepa Pilip beya ving yi. Nelë nġaa böp aggagga nġahiseḳë sën Pilip nevonġ lo, lob kwa neya nġahiseḳë. ");
INSERT INTO bzh_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Log tum alam sinarë sën nahën denedo Yerusalem lo denġo bë alam Samaria* deḳo Anutu yi ġaġek raḳ, lom devonġ Pita lu Jon deya vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Luho deluḳ meya deto, lom dejom raḳ vu Anutu in bë gevonġ Anon Vabuung vu alam sën denevonġ ving lo. ");
INSERT INTO bzh_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","In Anon Vabuung su loḳ yam ggërin ayoj rë, geyö nahën. Gaḳ yiḳ deripek bël raḳ Yesu arë mu. ");
INSERT INTO bzh_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Om luho debë nemaj raḳ sir, lom mëm Anon Vabuung loḳ yam ggërin ayoj. ");
INSERT INTO bzh_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Lob Simon lë bë sinarë luho debë nemaj raḳ sir bAnon Vabuung loḳ yam ggërin ayoj, lom ḳo monë ya vu luho ");
INSERT INTO bzh_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","genër bë, “Melu bo niwëëk saga vu sa geving, in nabë sa ġebë nemaġ jaḳ mehöti, og Anon Vabuung doḳ nam gërin yi.” ");
INSERT INTO bzh_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Rëḳ Pita nër vu yi bë, “Höm monë mala nama na veröḳ yi, behonġ geving! In ġekuung bë ġeyoh vu bë ġebaġo Nġaa sën Anutu vonġ nyëmasën vu hil lo jaḳ monë! ");
INSERT INTO bzh_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Su rëḳ ġedoḳ vu he in huk sënë geving rë, in Anutu lë bë ayom nipaya. ");
INSERT INTO bzh_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Om ġegwërin ayom begweruu demim vu kwam nipaya saga, geġenajom jaḳ vu Mehöböp in kevoh honġ nġaa nipaya sën neggëp loḳ ayom aga na. ");
INSERT INTO bzh_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Sa halë bë ayom sis yi panġsën, genġaa nipaya loḳ nare ayom bejom honġ ahon.” ");
INSERT INTO bzh_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Lom Simon neggöneng genër yah vu luho bë, “Om maam melu nġo najom jaḳ vu Mehöböp in mëm doḳ vu sa genġaa sën melu nër lo ti su natöḳ vu sa!” ");
INSERT INTO bzh_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Lob sinarë luho saga denër Yesu ranġah bedevonġ Mehöböp yi ġaġek yoh vu alam, log mëm luho deyah Yerusalem. Lob luho yah denër Bengö Nivesa ranġah vu begganġ-bu nġahiseḳë vu distrik Samaria ggëp aggata. ");
INSERT INTO bzh_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Log Mehöböp yi angër ti nër vu Pilip bë, “Kwedi ġena los ahë sën aggata nevuu Yerusalem geya nehöö ayo Gasa. Aggata sën neyoh ya nyëġ-yumeris lo.” ");
INSERT INTO bzh_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Lob Pilip kedi raḳ meya. Loḳ mehö nyëġ ngwë ti vu Etiopia neyoh aggata saga meneya. Etiopia hir avëh-los-bengö Kandase yi hur böp yi, beneġin yi monë los yi ḳupeḳ nivesa vesa pin. Mehö sënë ya mejom raḳ vu Anutu ggëp Yerusalem geyom to aggata meneyah. ");
INSERT INTO bzh_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Medo netevin mehö-nenër-ġaġek-ranġahsën Yesaya yi ḳapiya raḳ yi karis meyom to aggata vuheng in bë nah mena yi nyëġ. ");
INSERT INTO bzh_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Lob Anon Vabuung nër vu Pilip bë, “Ġena dus vu karis saga meġena geving!” ");
INSERT INTO bzh_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Lob Pilip seröġ meya dus vu, lob nġo bë mehö saga netevin mehö-nenër-ġaġek-ranġahsën Yesaya yi ġaġek, lob loḳ tepëḳ in yi bë, “Maḳ ġaġek sën ġenër aga, maḳ ġeraḳ degwa ni ma ma?” ");
INSERT INTO bzh_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Loḳ mehö saga nër yah vu Pilip bë, “Bë mehöti su tateḳin vu sa rë, og sëḳ jaḳ degwa ni nabë va?” Lob nër vu Pilip bë, “Ġejaḳ nam vavunë balu ajaḳ karis mana!” ");
INSERT INTO bzh_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ġaġek sën neggëp loḳ Anutu-yi-ḳapiya bemehö-ë netevin lo sënë: “Deli yi yam nebë sën deneli sipsip yam in bë dengis menadiiḳ, gesu nevengwënġ rë. Nebë sën denekeping sipsip nalu niviis, rëḳ su nesu rë. ");
INSERT INTO bzh_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Devonġ nimumsën rot vu yi, rëḳ mehöti su kedi raḳ meloḳ vu yi menër yi ġaġek mero rë gema. Ma rëḳ yi mewis tena in hil nanër rë? In desis yi mediiḳ pevis bemala ma gesu nedo dob rë.” ");
INSERT INTO bzh_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Lom avëh-los-bengö yi hur sënë nër vu Pilip bë, “Ġetateḳin vu sa rë! Mehö-nenër-ġaġek-ranġahsën nër ġaġek sagi raḳ re? Yö nër raḳ yi, ma nër raḳ mehö ngwë?” ");
INSERT INTO bzh_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Lob Pilip tateḳin Anutu yi ġaġek dus ti saga genër Yesu yi Bengö Nivesa degwa tato vu yi. ");
INSERT INTO bzh_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ggovek geluho medo denetetuu aggata medeneya beya deto bël ti, lob mehö saga nër bë, “Gwelë! Bël neggëp! Yoh vu bë ġejipek sa ma ma?” ");
INSERT INTO bzh_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Loḳ Pilip nër yah vu yi bë, “Bë ġevonġ ving anon loḳ ayom, og mëm!” Rëḳ bë, “Sa hevonġ ving Yesu Kerisi bë Anutu nalu yi!” ");
INSERT INTO bzh_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Lob mëm nër bë karis bare, log luhoho medeluḳ ya bël, bemëm Pilip daġoo yi luḳ ya bël. ");
INSERT INTO bzh_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Log luho deraḳ yom roneḳ, lob Mehöböp yi Anon Vabuung ḳo Pilip ya, gemehö sënë su lë yi ggökin rë, rëḳ mu kwa vesa rot mesepa yi aggata beya. ");
INSERT INTO bzh_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Gaḳ Pilip, og Anon Vabuung ḳo yi metöḳ ya Asotus pevis, lob ya meyoh vu nyëġ böp pin menër Bengö Nivesa ranġah. Beya rot beya metöḳ ya Sisarea. ");
INSERT INTO bzh_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Log Saulus nahën nenër ġaġek los niwëëk bë gevonġ paya vu Mehöböp yi hur bengis sir medenadiiḳ. Lob ya vu alam-deneḳo-seriveng hir ggev böp, ");
INSERT INTO bzh_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","benër vu yi bë kevu ḳapiya noh vu alam Yuda hir dub-supinsën-yi pin sën denedo Damaskus lo bebo vu yi. Lob ggev böp kevu ġaġek loḳ ḳapiya saga nebë, “Nabë Saulus sënë natöḳ vu maluh ma avëh la gedenesepa loḳ Yesu yi aggata, og ġaġek ma genaduu sir megeḳo sir nam Yerusalem.” ");
INSERT INTO bzh_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Log Saulus losho ahëvavu la deya raḳ beya deverup dus vu Damaskus, lob pevis benġaa ti vër vu yaġek nebë davës beluḳ yam jëh raḳ sir. ");
INSERT INTO bzh_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Lob Saulus vës betetolin beya neggëp dob, log nġo ġaġek ti yam vu vavunë bë, “Saulus, Saulus! Ġëvo vanë vu sa in va?” ");
INSERT INTO bzh_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Rëḳ Saulus nër yah bë, “Mehöböp, honġ re?” Rëḳ ġaġek lo yom ggökin bë, “Sa Yesu sën ġenevonġ vanë vu sa lo. ");
INSERT INTO bzh_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Rëḳ mu kwedi jaḳ meġena nyëġ böp sagu, genahub rëḳ mëm mehöti rëḳ nanër nġaa sën gwevonġ lo tato vu honġ!” ");
INSERT INTO bzh_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Galam sën deneya ving Saulus lo denare rëḳ denelëk besu deyoh vu bë debengwënġ rë. Log denġo ġaġek saga dedun rëḳ su delë bë mehöti nedo rë. ");
INSERT INTO bzh_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Loḳ mëm Saulus kedi nare bemala netum rëḳ nahën mala nepengipin rot, lom maam dejom loḳ nema bedeli yi ya nyëġ böp Damaskus. ");
INSERT INTO bzh_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Benedo buk löö, rëḳ mu yö nahën mala ḳenod rot, log su negga nos los nenum bël rë. ");
INSERT INTO bzh_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Loḳ Anutu yi hur maluh ti nedo Damaskus arë nebë Ananias. Lob Mehöböp tato yi vu belë nebë pesepsën, genër vu yi bë, “Ananias!” Rëḳ bë, “Mehöböp, sa nado-ë!” ");
INSERT INTO bzh_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Lob Mehöböp nër vu yi bë, “Kwedi ġena aggata ti sën denenër arë nebë Aggata Niröp agu. Ġena Yudas yi begganġ lob mëm ġedoḳ tepëḳ in Tarsus ti sën denenër arë nebë Saulus. Mehö sagi medo nejom raḳ ");
INSERT INTO bzh_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","genelë nġaa nebë pesepsën bë mehöti arë nebë Ananias neloḳ ya begganġ ayo mebë nema raḳ yi in bë gevonġ bemala natum megelë nyëġ gökin.” ");
INSERT INTO bzh_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Rëḳ Ananias nër yah vu bë, “Mehöböp, sa hanġo alam nġahiseḳë denenër mehö saga bë nevonġ huk agga nipaya rot vu honġ alam vabuung pin vu Yerusalem, ");
INSERT INTO bzh_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","lob ḳo ġaġek vu alam-deneḳo-seriveng hir ggev in bë naduu alam sën ayej neloḳ honġ vu agi, in bë dena ḳarabus.” ");
INSERT INTO bzh_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Rëḳ Mehöböp nër yah vu bë, “Ġena! Mehö saga og sa hur ti. Sehooin yi raḳ ggovek ya in geḳo sa bengöġ bena nanër vu alam-yu-ngwë losho hir alam-los-bengöj, gevu alam Israel geving. ");
INSERT INTO bzh_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Log senġo rëḳ tato nivanë aggagga pin sën rëḳ natöḳ vu yi jaḳ sën nanër sarëġ ranġah lo vu yi.” ");
INSERT INTO bzh_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Lob Ananias ya raḳ. Ya verup beloḳ ya Yudas yi begganġ ayo log pevis mebë nema raḳ Saulus genër vu bë, “Arig Saulus! Mehöböp Yesu sën töḳ vu honġ loḳ aggata lo vonġ sa beseyam in bë malam natum gökin nah, gemëm Anon Vabuung doḳ nam gërin ayom.” ");
INSERT INTO bzh_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nġaa sën ggërin Saulus mala lo ni nebë ġël niḳepis mekehe ya pevis, log mala tum ggökin gemëm kedi beripek bël. ");
INSERT INTO bzh_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Log mëm Saulus gga nos bemëm niwëëk loḳ yah, benedo buk vahi ving Yesu yi hur vu nyëġ böp Damaskus. ");
INSERT INTO bzh_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Log pevis meya meyoh vu alam Yuda hir dub-supinsën-yi ggëp nyëġ böp Damaskus benër Yesu yi ġaġek ranġah nebë, “Mehö saga yi Mehöböp Nalu!” ");
INSERT INTO bzh_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Alam pin denġo yi ġaġek lob delëk panġsën beḳenuj ya gedeloḳ tepëḳ vu sir bë, “Mehö saga maḳ sën yiḳ nevonġ paya vu alam sën ayej neloḳ Yesu arë vu Yerusalem lo! Maḳ yiḳ yi saga sën gwëbeng verup agi in naduu sir sënë megeḳo nah vu alam-deneḳo-seriveng hir ggev-ë?” ");
INSERT INTO bzh_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Rëḳ Saulus kedi menër ġaġek los niwëëk ata, lob alam Yuda sën denedo vu Damaskus lo denġo yi ġaġek, lom kwaj ya nġahi in tato vu sir yönon bë Yesu yi mehö sën Anutu ggooin yi raḳ netu Kerisi. ");
INSERT INTO bzh_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Buk nġahiseḳë ya ggovek ya lob alam Yuda vu nyëġ böp Damaskus dejoo ġaġek in bë dengis Saulus menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Rëḳ nġo hir ġaġek saga bë vare deneġin yi loḳ aggata avi pin yoh vu buk los ranġah in bë dengis yi benadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Rëḳ alam sën denġo yi ġaġek medenesepa loḳ lo deḳo yi buk medetunġ loḳ ḳadaḳaad medevonġ ggök ya ḳatum ġelönġ yu vavunë vu nyëġ böp saga nenga, medesejun aggis in yi geluḳ ya dobnë beya. ");
INSERT INTO bzh_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulus yah meya betöḳ yah Yerusalem, lom vonġin bë losho Yesu yi hur demedo jevuh ti, rëḳ deneggöneng in yi, in kwaj nevo bë su Yesu yi hur maluh yi yönon rë. ");
INSERT INTO bzh_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Rëḳ Barnabas ḳo Saulus beya vu sinarë nyëdahis lo, getateḳin bë Saulus lë Mehöböp ggëp aggata benër ġaġek vu yi om sën ggërin yi menenër Yesu arë ranġah los niwëëk vu nyëġ böp Damaskus rot. ");
INSERT INTO bzh_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ggovek lom mëm Saulus nedo ving sir medenesepa sir ggëp Yerusalem. Vonġ huk niwëëk benër Mehöböp arë ranġah gesu ggöneng rë. ");
INSERT INTO bzh_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nër ġaġek raḳ Yesu vu alam Yuda sën denevengwënġ Grik ayej lo ving, lob losho denemehoo sir in ġaġek saga, lom desero aggata in bë dengis yi benadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Rëḳ Kerisi-yi-alam vahi denġo, lob deḳo yi bedeluḳ medeya Sisarea, bedevonġ ya Tarsus. ");
INSERT INTO bzh_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nebë saga lom mëm Kerisi-yi-alam pin vu distrik Yudea los Galilea geSamaria denedo nivesa gemaggin su netöḳ vu sir ggökin rë. Yesu yi huk saga niwëëk raḳ, lob yi alam pin deneggöneng in Mehöböp gedeneḳo arë raḳ, log Anon Vabuung vo niwëëk vu sir lob alam medo deneyam vu sir benġahijseḳë loḳ. ");
INSERT INTO bzh_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Lob Pita ya meyoh vu nyëġ pin beya meto Luda benedo ving Anutu-yi-alam ggëp sagu. ");
INSERT INTO bzh_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Lob töḳ vu Luda ti arë nebë Ainias. Seḳë pin selönġin beneggëp loḳ begganġ ayo yoh vu ta nemadvahi-bevidek-löö. ");
INSERT INTO bzh_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Lob Pita nër vu yi bë, “Ainias! Yesu Kerisi vonġ benim vesa raḳ. Om kwedi ġebahinin honġ ḳanyë!” Lob Ainias kedi raḳ pevis. ");
INSERT INTO bzh_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lob alam Luda los Saron pin delë yi, lob mëm deggërin sir yom vu Mehöböp. ");
INSERT INTO bzh_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yesu yi hur avëh ti nedo Yopa arë nebë Tabita. Sën Grik ayej nenër nebë Dorkas lo. Lob nevonġ nivesa beneloḳ vu alam sën deneraḳ vu in nġaa lo yoh vu buk pin. ");
INSERT INTO bzh_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lob loḳ buk saga niraḳ lob diiḳ. Lob deripek yi gedebë raḳ ya neggëp begganġ ayo vavunë ti. ");
INSERT INTO bzh_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lob Yopa neggëp dus vu Luda, gehur maluh denġo bë Pita nedo Luda, lob pevis medevonġ mehö luu deḳo dik ya vu yi bë, “Ġenam vu he pevis, gesu ġenaköpeḳ!” ");
INSERT INTO bzh_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Lob Pita nġo ġaġek meya ving luho medeyah deverup lob deḳo yi ya begganġ ayo vavunë. Lob avëh alov pin ya detetup loḳ yi gevare denesu medenetato tob los röpröp pin sën Dorkas semu vu sir loḳ buk sën yö nahën nedo mala vesa lo. ");
INSERT INTO bzh_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Rëḳ Pita ruuk alam pin saga to deyah dobnë, log yun lus log jom raḳ. Log mëm peggirin mala ya vu heljënġ genër bë, “Tabita, kwedi jaḳ!” Lob avëh mala tum belë Pita gekedi nedo. ");
INSERT INTO bzh_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita jom loḳ Tabita nema beloḳ vu bekedi raḳ, log tahi Anutu-yi-alam los avëh alov saga deyam betato Dorkas vu sir bë vesa loḳ yah. ");
INSERT INTO bzh_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ġaġek saga yoh vu alam Yopa pin medenġo, lob sir nġahiseḳë ayoj neya timu vu Mehöböp. ");
INSERT INTO bzh_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Lob Pita nedo buk nġahiseḳë ggëp Yopa. Nedo ving Simon sën mehö nesemu ḳabi lu nġaa raḳ reggu navi lo. ");
INSERT INTO bzh_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Rom ti nedo Sisarea arë nebë Kornelius. Alam-beġö-yi vu Itali hir kapten ti meneġin alam mehödahis nemadvahi (100). ");
INSERT INTO bzh_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Log losho yi alam pin sën denedo loḳ ti lo deneggöneng in Anutu medeneḳo arë raḳ. Nevo monë nġahiseḳë in bë doḳ vu alam Yuda sën deneraḳ vu in nġaa lo, geyö nejom raḳ vu Anutu yoh vu buk pin. ");
INSERT INTO bzh_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lob buk ti loḳ 3 krök sehuksën, lob lë nġaa ti nebë pesepsën meneggëp ranġah rot. Lë bë Mehöböp yi angër ti loḳ ya begganġ ayo vu yi benër bë, “Kornelius!” ");
INSERT INTO bzh_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Lob Kornelius ḳenu verup begët yi, loḳ nër bë, “Mehöböp! Bë va?” Rëḳ angër nër yah vu Kornelius bë, “Anutu lë honġ jomraḳsën gelë bë ġeneloḳ vu alam sën deneraḳ vu in nġaa lo, log lë bë yoh vu, lob kwa nevo menedo. ");
INSERT INTO bzh_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Om gwevonġ mehö la dena Yopa bena denatöḳ jaḳ Simon sën denenër arë ngwë nebë Pita lo bedegeḳo nom. ");
INSERT INTO bzh_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mehö saga nedo loḳ Simon ngwë sën yi mehö nesemu reggu navi lo yi begganġ, dus vu loo nenga.” ");
INSERT INTO bzh_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Angër nër ġaġek nebë saga vu Kornelius ggovek log ya raḳ, log Kornelius tahi yi hur luu ving mehö-beġö-yi ti. Mehö-beġö-yi saga yi mehö-jomraḳsën-yi ving. ");
INSERT INTO bzh_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Lob Kornelius nër ġaġek saga pin mero vu lööho, log mëm vonġ lööho ya Yopa. ");
INSERT INTO bzh_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lööho deya beya deneggëp aggata. Genyëġ heng gelööho deya medeya dus raḳ vu nyëġ böp Yopa log hes vuheng raḳ. Log Pita raḳ ya Simon yi begganġ yu-tamanġsën vavunë in bë najom jaḳ. ");
INSERT INTO bzh_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Lob diiḳahë, lob kwa vo bë ga nos rëḳ nahën deneyeh, lob lë nġaa ti nebë pesepsën yam vu yi. ");
INSERT INTO bzh_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Lë yaġek tateḳin log nġaa ti luḳ meyam dob nebë sën denejom loḳ tob nyëḳetu lubeluu lo, geböpata rot. ");
INSERT INTO bzh_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lob reggu aggagga pin loḳ nedo. Nġaa pin sën denevëëng, genġaa pin sën vare deneya los deneggevek dob lo. ");
INSERT INTO bzh_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Lob ġaġek ti yam vu Pita ving bë, “Pita, kwedi ġengis reggu beġegwa!” ");
INSERT INTO bzh_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Lob Pita nër bë, “Ma rot, Mehöböp! Sa su rëḳ ġa rë! Saḳ su naha nġaa nebë sënë rë. In he horek nenërin bë nipaya besu yohvu rë.” ");
INSERT INTO bzh_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Rëḳ ġaġek saga yom vu yi netu beron luu nebë, “Nġaa sën Anutu nër bë yohvu, saga su ġenanër nabë su yohvu rë!” ");
INSERT INTO bzh_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nġaa pin sën agi töḳ vu Pita beron löö, log pevis betob sën yah meya vavunë. ");
INSERT INTO bzh_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita nahën kwa neya nġahi bë, “Nġaa sën sa halë agi degwa nebë va?” log alam Rom sën Kornelius vonġ sir yam lo deverup. Lööho deloḳ tepëḳ in Simon sën mehö nesemu reggu navi lo yi begganġ, lob mëm verup denare loḳ veluung avi. ");
INSERT INTO bzh_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Log detahi medeloḳ tepëḳ bë, “Simon sën arë ngwë nebë Pita lo nedo sënë ma ma?” ");
INSERT INTO bzh_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Rëḳ Pita nahën kwa nevo nġaa sën lë nebë pesepsën lo, loḳ Anon Vabuung nër vu yi bë, “Gwenġo? Mehö löö denesero honġ! ");
INSERT INTO bzh_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Om kwedi ġeduḳ meġena vu sir beham na. Su kwam na nġahi. Senġo hevonġ sir medeyam.” ");
INSERT INTO bzh_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Lob Pita luḳ ya vu alam saga benër bë, “Mehö sën ham nesero lo, yiḳ sa sënë. Ma ham yam in-a?” ");
INSERT INTO bzh_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Loḳ denër bë, “Kornelius, sën alam-beġö-yi hir kapten lo vonġ he yam. Mehö yohvu sën neggöneng in Anutu geneḳo arë raḳ, galam Yuda pin denër bë yi mehö nivesa. Lob Anutu yi angër ti to menër vu yi bë gevonġ he nam in honġ behil anah yi begganġ in bë genġo honġ ġaġek.” ");
INSERT INTO bzh_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Lom Pita nër bedeloḳ ya begganġ ayo, bevo nos vu sir medegga gedeggëp. Log monbuk lob kedi meya ving sir, lob Kerisi-yi-alam la vu Yopa desepa sir medeya ving. ");
INSERT INTO bzh_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ya deggëp buk ti vu aggata, loḳ mëm detöḳ ya Sisarea geKornelius medo neġin sir. Tahi yi alam losho yi mehö la ggovek bedesupin sir benedo deneġin sir. ");
INSERT INTO bzh_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita to meloḳ ya begganġ ayo, lob Kornelius to meya vu bepetev meneggëp loḳ Pita vaha in bë geḳo arë jaḳ. ");
INSERT INTO bzh_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Rëḳ Pita jom loḳ nema mekedi nare genër vu bë, “Kwedi jaḳ! Sa, og sa mehönon meris mu!” ");
INSERT INTO bzh_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Lob luho devengwënġ gedeyah begganġ ayo vu alam nġahiseḳë sën desupin sir medenedo lo. ");
INSERT INTO bzh_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Lob Pita nër vu sir bë, “Ham nġo raḳ ni bë horek niwëëk ata nërin he alam Yuda bë he su ayoh vu bë ana medo geving alam-yu-ngwë, ma ana vatëveḳ vu sir rë. Rëḳ Anutu tato vu sa nebë sa su nanër mehöti nabë nipaya ma su mehö yohvu rë. ");
INSERT INTO bzh_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Om sën sa su ḳeyëh ġaġek rë. Gaḳ ham kwetaġ sa lom seyam pevis. Rëḳ sa bë ġanġo niröp nabë ham tahi sa in va?” ");
INSERT INTO bzh_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Lob Kornelius nër bë, “Nġaa sënë töḳ vu sa bebuk löö ruu ya ggovek ya. Sa medo najom raḳ loḳ sa begganġ ayo raḳ 3 krök sehuksën lob pevis besa halë mehöti nare geyi tob veroo beniḳapiik. ");
INSERT INTO bzh_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Lob nër vu sa bë, ‘Kornelius, Anutu nġo honġ jomraḳsën ggovek gemedo mekwa nevo monë lu nġaa pin sën ġenevonġ in bë doḳ vu alam sën deneraḳ vu in nġaa lo. ");
INSERT INTO bzh_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Om gwevonġ mehö la dena Yopa bena denanër Simon sën denenër arë ngwë nebë Pita lo. Mehö saga nedo loḳ Simon ngwë sën mehö nesemu reggu navi lo yi begganġ dus vu loo nenga.’ ");
INSERT INTO bzh_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Om sën sa hevonġ mehö la deyök in honġ. Lob ġevonġ nivesa beġeyam, om sën gwëbeng he pin ayam nado loḳ Anutu mala agi in bë he ġanġo ġaġek sën Mehöböp vonġ vu honġ in bë ġenanër vu he lo.” ");
INSERT INTO bzh_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Lom mëm Pita nër bë, “Yönon rot, gwëbeng seraḳ ni bë Anutu su kwa ya vu mehö los arë ma alam vahi mu rë. ");
INSERT INTO bzh_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Gaḳ kwa nevo alam vu nyëġ pin bë: Nabë sir ti göneng in yi begevonġ nġaa nohvu, og nelë yi nivesa. ");
INSERT INTO bzh_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yönon, Anutu vonġ yi ġaġek vu he Israel, bevonġ Yesu Kerisi yi Bengö Nivesa vu he. Bengö Nivesa sën nër ġaġek mamer vu he bë Yesu Kerisi tu alam pin hir Mehöböp. ");
INSERT INTO bzh_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","In ham nġo raḳ nġaa sën Yesu Nasaret nevonġ lo ni vorot. Wirek Jon nër ġaġek bël-ripeksën-yi ranġah, lob vu buk sagi Yesu verup ggëp Galilea, lob bengö ya meyoh vu nyëġ pin vu distrik Yudea. ");
INSERT INTO bzh_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Gemaḳ ham raḳ ni bë Anutu ggooin yi raḳ bevonġ Anon Vabuung los niwëëk vu yi, lob ya meyoh vu nyëġ pin beloḳ vu mehönon. Anutu nevo niwëëk vu yi, lob vonġ alam sën Satan nevonġ paya vu sir lo benijvesa neraḳ. ");
INSERT INTO bzh_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Gehe sënë halë yi wirek, lob sën he nanër ġaġek ranġah raḳ nġaa pin sën nevonġ vu Yerusalem los nyëġ pin vu distrik Yudea lo. Gesën derekö yi raḳ ḳelepeḳo* gedesis mediiḳ lo. ");
INSERT INTO bzh_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Rëḳ buk netu löö lob Anutu nër bekedi raḳ yah, log tato yi ranġah. ");
INSERT INTO bzh_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Su tato yi balam Yuda pin delë rë. Gaḳ yiḳ yö tato yi vu he sën wirek Anutu ggooin he raḳ in bë he nanër yi ġaġek ranġah lo. Kedi raḳ yah vu bedub, lob he ha los anum ving yi. ");
INSERT INTO bzh_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Log nër vu he bë he nanër yi ġaġek pin ranġah vu mehönon nabë Anutu ggooin yi raḳ in bë genġo alam-malaj-vesa los alam-diiḳsën pin hir ġaġek. ");
INSERT INTO bzh_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Alam-denenër-ġaġek-ranġahsën pin denër yi ġaġek ranġah nebë: Anutu nekevoh alam pin sën ayoj neya timu vu Yesu lo hir nġaa nipaya ya raḳ Yesu arë los niwëëk.” ");
INSERT INTO bzh_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita nahën nenër ġaġek saga, log Anon Vabuung yam raḳ ya alam pin sën denġo yi ġaġek agi lo. ");
INSERT INTO bzh_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Alam Yuda sën ayoj neya timu vu Yesu wirek gedeyam ving Pita lo, delëk anon rot in denelë bë Anutu keseh Anon Vabuung raḳ alam-yu-ngwë ving. ");
INSERT INTO bzh_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Denġo sir gedenenër ayej aggagga bedeneḳo Mehöböp arë raḳ, lob Pita nër bë, ");
INSERT INTO bzh_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Alam sënë deḳo Anon Vabuung nebë hil, om re rëḳ nanërin bël-ripeksën-yi in sir-a?” ");
INSERT INTO bzh_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Lob nër vu alam sën deyam ving yi lo bë dejipek sir jaḳ Yesu Kerisi arë. Lob tum deketaġ vu Pita bë medo buk la geving sir rë. ");
INSERT INTO bzh_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Sinarë nyëdahis losho arij lo sën denedo yoh vu distrik Yudea pin lo denġo ġaġek bë alam-yu-ngwë deḳo Anutu yi ġaġek ggovek ya ving. ");
INSERT INTO bzh_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Log Pita raḳ meyah Yerusalem, lob alam Yuda sën denesepa loḳ Yesu lo denër yi, in nijwëëk bë degerah* alam sën deneggërin sir yah vu Yesu lo navij pin nabë sën sir Yuda lo. ");
INSERT INTO bzh_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Gedenër yi bë, “Ġeraḳ ya alam sën su derah* navij rë lo hir begganġ geġewa nos ving sir!” ");
INSERT INTO bzh_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Rëḳ Pita tateḳin nġaa pin sën töḳ vu yi lo vu sir bë, ");
INSERT INTO bzh_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Sa nado nyëġ böp Yopa, besa medo najom raḳ loḳ hes vuheng, lob sa halë nġaa ti nebë pesepsën. Sa halë nġaa böpata nebë sën denejom loḳ tob nyëḳetu lubeluu, beluḳ vu yaġek meyam to nedo dob dus vu sa. ");
INSERT INTO bzh_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Lob sa hetunġ malaġ raḳ tob saga ayo peggo rot, lob sa halë bë reggu aggagga pin sën denedo dob lo denedo loḳ. Reggu pin sën vare neya los neggevek dob lo, gesën nevëëng vavunë lo. ");
INSERT INTO bzh_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Lob sa hanġo ġaġek ti yam vu sa bë, ‘Pita, kwedi ġengis reggu beġegwa!’ ");
INSERT INTO bzh_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Rëḳ senër bë, ‘Mehöböp, ma rot! Saḳ su naha nġaa nebë sënë rë! In he horek nenërin bë nipaya gesu yohvu rë.’ ");
INSERT INTO bzh_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Lob ġaġek sën yam vu yaġek lo nër vu sa netu beron luu nebë, ‘Nġaa sën Anutu nër bë yohvu lo, og su ġenanër saga nabë su yohvu rë!’ ");
INSERT INTO bzh_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Lob nġaa pin saga yam netu beron löö, log yah beya yaġek ggökin. ");
INSERT INTO bzh_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Log mehöti nedo Sisarea bevonġ mehö löö deyam in sa lob pevis belööho verup denare loḳ begganġ sën sa nado loḳ lo veluung avi. ");
INSERT INTO bzh_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Lob Anon Vabuung nër vu sa bë, ‘Ġena geving sir. Su kwam na nġahi!’ Lob arig lo nemadvahi-bevidek-ti sënë deya ving sa behe ya maloḳ ya Kornelius yi begganġ. ");
INSERT INTO bzh_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Lob Kornelius nër vu he bë lë angër ti genare loḳ yi begganġ ayo benër vu yi bë, ‘Gwevonġ mehö la dena Yopa bena denanër Simon sën arë ngwë nebë Pita lo nam. ");
INSERT INTO bzh_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Og rëḳ nanër ġaġek la vu honġ, lob Anutu rëḳ geḳo honġ los honġ alam pin nom vu yi jaḳ ġaġek saga.’ ");
INSERT INTO bzh_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Lob sa nahën nanër ġaġek vu sir, lob Anon Vabuung loḳ yam ggërin ayoj nebë sën loḳ yam ggërin hil muġinsën lo. ");
INSERT INTO bzh_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Lob sa kwaġ vo Mehöböp yi ġaġek ggökin, sën nër bë, ‘Jon neripek alam raḳ bël mu, gaḳ Anon Vabuung rëḳ doḳ nam gërin ham.’ ");
INSERT INTO bzh_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Wirek hil ayod ya vu Mehöböp Yesu Kerisi, lob Anutu vonġ Anon Vabuung vu hil, lob yiḳ vonġ Anon Vabuung vu sir nebë saga. Nebë saga lob sa su nebë re in bë seġërin Anutu rë?” ");
INSERT INTO bzh_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Denġo Pita yi ġaġek saga, lob devuu hir ġaġek sagi ya gedeḳo Anutu arë raḳ bedenër bë, “Oo maḳ Anutu yoh vu bë gërin alam-yu-ngwë ayoj nah vu yi geving in demedo malaj-tumsën.” ");
INSERT INTO bzh_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Desis Stepan ggovek loḳ mëm maggin böpata töḳ vu Kerisi-yi-alam, lob deveya medeya beya depalët loḳ bedeya Ponisia los Kupros gAntiok. Rëḳ su denër Bengö Nivesa vu alam-yu-ngwë rë. Gaḳ yö ya denenër vu alam Yuda mu. ");
INSERT INTO bzh_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Loḳ sir la vu dob Kupros, gevahi vu Kurene, deya nyëġ böp Antiok bedenër ġaġek vu alam Grik ving. Denenër Mehöböp Yesu yi Bengö Nivesa ranġah vu sir, ");
INSERT INTO bzh_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","lob Mehöböp loḳ vu sir balam Grik nġahiseḳë devonġ ving medeggërin sir yah vu yi. ");
INSERT INTO bzh_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Lob Kerisi-yi-alam vu Yerusalem denġo ġaġek sagi, lob devonġ Barnabas ya Antiok. ");
INSERT INTO bzh_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ya metöḳ ya vu sir lob lë bë Anutu vonġ semusemu benedo ving sir, lob ahë nivesa. Lom mëm lev horek loḳ sir pin bë degurek Mehöböp babu bekwaj bo yi timu noh vu buk pin. ");
INSERT INTO bzh_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas yi mehö nivesa gAnon Vabuung pup ayo, bevonġ ving niwëëk ata. Lob alam yu böpata deggërin sir medeloḳ yam ving Mehöböp yi alam. ");
INSERT INTO bzh_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Lob mëm Barnabas ya Tarsus in bë sero Saulus. ");
INSERT INTO bzh_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Lob töḳ raḳ yi beḳo beyah Antiok, beluho denedo ving alam vu Antiok yoh vu ta ti, beluho detahu alam nġahiseḳë loḳ Anutu yi ġaġek. Lob mëm yiḳ alam Antiok saga detahi ggev raḳ Mehöböp yi hur muġinsën nebë Kerisi-yi-alam. ");
INSERT INTO bzh_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Luho nahën denedo saga lob alam-denenër-ġaġek-ranġahsën vahi vu Yerusalem deluḳ medeya Antiok, ");
INSERT INTO bzh_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","lob sir ti arë nebë Agabus kedi nare, log Anon Vabuung nër ġaġek ranġah verup avi bë meyip böpata rëḳ natöḳ vu dob pin. Lob yi ġaġek saga anon raḳ loḳ mehö-los-bengö Klaudius yi buk. ");
INSERT INTO bzh_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Lob Yesu yi alam vu Antiok dejoo ġaġek venuh bë degevonġ monë noh vu nemaj na vu arij lo vu distrik Yudea in doḳ vu sir. Denevonġ yoh vu sir ti ti, gesu deneggulin rë. ");
INSERT INTO bzh_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Lob devo monë saga vu Barnabas lu Saulus beluho deḳo yah vu alam ggev vu Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Loḳ buk saga mehö-los-bengö Herot* jom Kerisi-yi-alam vahi ahon in bë ngis sir. ");
INSERT INTO bzh_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Lom nër vu yi alam-beġö-yi bedeketöv Jon ari Yakobus kwa raḳ paëp bediiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Lob lë bë alam Yuda ahëj ving huk nipaya saga, lob nër vu yi ahëvavu bedetunġ Pita luḳ ya ḳarabus ving. Jom yi ahon loḳ Buk-ggöksën-yi* yi buk ti, ");
INSERT INTO bzh_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","betunġ yi loḳ ya nedo ḳarabus, in kwa nevo bë Buk-ggöksën-yi* yi buk pin govek na log mëm geḳo menam bare alam Yuda malaj. Nebë saga log tato alam-beġö-yi lubeluu lubeluu yoh vu yu lubeluu in degeġin Pita medepekwë sir in. ");
INSERT INTO bzh_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Lob medo deneġin Pita loḳ ḳarabus, rëḳ Anutu-yi-alam medo denejom raḳ in yi los ayoj dahis vu Anutu buk geranġah. ");
INSERT INTO bzh_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Deduu Pita raḳ sëng böp luu benedo ḳarabus gemëm Herot* vonġin bë geḳo yi nam ġaġek monbuk. Alam-beġö-yi luu denare veluung avi bedeneġin, log deduu luu nemaj vetii Pita nema vahi vahi geneggëp loḳ luho vuheng atov bebuk vuheng raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Loḳ Mehöböp yi angër ti verup beniḳapiik jëh raḳ begganġ ḳarabus saga ayo. Lob angër sis Pita kweben genër vu yi bë, “Kwedi jaḳ pevis!” Lob sëng luho vepul in Pita nema beto nedo. ");
INSERT INTO bzh_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Log angër nër vu yi bë, “Gwevëh honġ ḳabi los gwetunġ honġ suu nah!” Pita vonġ nebë saga, lob angër nër ggökin bë, “Ġejöp honġ röpröp-ayööng-yi nah geġetamuin sa!” ");
INSERT INTO bzh_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Lob Pita vuu begganġ ḳarabus ayo getamuin yi beya, rëḳ mu su raḳ nġaa sën angër vonġ vu yi agi ni bë yönon rë, gaḳ kuung bë maḳ neggëp melë pesepsën mu. ");
INSERT INTO bzh_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Luho deya, beya dekesuu alam-beġö-yi la ggovek ya, geluho ya deverup dekesuu la ving gedetöḳ ya repinġ aën sën deduḳ nah dobnë lo, lob repinġ saga yö tahinin yi in luho geluho to deya dobnë beya deyoh ya aggata ti. Log pevis bangër mehor bevuu Pita geya. ");
INSERT INTO bzh_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Loḳ mëm Pita ḳenu loḳ yah lob nër bë, “O gwëbeng mëm seraḳ ni rot bë Mehöböp vonġ yi angër yam ḳo sa vër loḳ Herot* nema, geloḳ nġaa pin sën alam Yuda kwaj nevo bë degevonġ vu sa lo.” ");
INSERT INTO bzh_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita kwa vo nebë saga ggovek, log mëm ya meya Jon sën denenër arë ngwë nebë Markus lo ata Maria yi begganġ. Alam nġahiseḳë desupin sir raḳ begganġ saga bemedo denejom raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Log Pita ya verup nare dobnë gepepa raḳ repinġ, lob hur avëh ti arë nebë Roda ya in bë tahinin. ");
INSERT INTO bzh_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Lob nġo Pita aye beraḳ ni lob kwa vesa rot beḳenu pesönġ ya, lom kwa virek gesu tahinin repinġ rë, gaḳ seröġ meyah begganġ ayo benër vu sir bë, “Pita verup nare loḳ veluung avi!” ");
INSERT INTO bzh_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Rëḳ denër vu bë, “O! Maḳ ġenepesep!” Rëḳ pasanġ nër niwëëk bë, “Ma! Verup nare yönon rot!” Loḳ denër bë, “Om maḳ sagaḳ ḳenu!” ");
INSERT INTO bzh_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Rëḳ Pita vare nepepa raḳ repinġ benare rot, loḳ mëm detahinin gedelë yi, lob delëk meḳenuj ya. ");
INSERT INTO bzh_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Loḳ Pita vonġ nema bë ayej nama, log mëm turin ġaġek pin sën Mehöböp ḳo yi vër in begganġ ḳarabus beto meyom dob lo vu sir. Log nër ving bë, “Ham na nanër ġaġek sënë vu Mehöböp ari Yakobus losho hil arid sën Kerisi-yi-alam lo.” Log Pita to meyah dobnë, beya nyëġ ngwë. ");
INSERT INTO bzh_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Log mëm ranġah raḳ behes mala töḳ lob alam-beġö-yi delëk anon beyö deneloḳ tepëḳ vu sir medenenër bë, “Pita ya tena?” ");
INSERT INTO bzh_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Lob Herot* vonġ yi alam-beġö-yi ya denesero Pita, rëḳ ma gesu detöḳ vu yi rë. Lom mëm Herot* loḳ tepëḳ in alam-beġö-yi lubeluu sën deneġin Pita buk lo rot. Rëḳ ma lob nër bedesis sir medediiḳ, log tum Herot* vuu distrik Yudea geluḳ meya nedo nyëġ böp Sisarea. ");
INSERT INTO bzh_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Log Herot* ahë sengën böpata vu alam Ture los Sidon, lob desupin sir in bë dena vu yi. Lob desemu ġaġek vu Blastus sën neġin yi begganġ los ḳupeḳ lo ggovek rë bë rëḳ doḳ vu sir, loḳ mëm desu vu mehö-los-bengö Herot* bë semu ġaġek saga gedemedo. Nij wëëk bë gevonġ nabë saga in denebaġo nos loḳ yi dob, gaḳ nabë nama, og rëḳ degeḳo nos vu tena? ");
INSERT INTO bzh_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lob Herot* ggooin buk ti raḳ, lob vuneḳ raḳ alam-los-bengöj hir tob vuneḳsën, geraḳ nedo alam-los-bengöj hir sëa benër ġaġek vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Lob alam saga detahi bedeḳo yi raḳ bë, “Aye nebë anutu ti nevengwënġ! Gaḳ mehönon og su denenër ġaġek nebë sagu rë!” ");
INSERT INTO bzh_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Rëḳ Herot* su dahun arë vu sir genër bë degeḳo Anutu soġek arë jaḳ rë, om Mehöböp yi angër vonġ bebebën gga ahë pevis mediiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Log Mehöböp yi ġaġek niwëëk raḳ meyoh vu nyëġ pin. ");
INSERT INTO bzh_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Lob Barnabas luho Saulus devonġ hir huk vu Yerusalem beggovek ya, log mëm luho deyah medeya Antiok. Luho deḳo Jon sën arë ngwë nebë Markus lo sepa, meya ving luho. ");
INSERT INTO bzh_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kerisi-yi-alam vu Antiok hir alam-denenër-ġaġek-ranġahsën la, getatovaha la, medenedo. Sir sën arëj agi: Barnabas, geSimeon sën denenër arë ngwë nebë Veriik lo, geLusius vu Kurene ga, Manain sën luho mehö-los-bengö Herot* derig loḳ ti lo ga, Saulus. ");
INSERT INTO bzh_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Denedo loḳ buk ti lob sir sën Kerisi-yi-alam agi ayej ggërin nos medenedo, gemedo denejom raḳ vu Mehöböp. Lob Anon Vabuung nër vu sir bë, “Ham ġooin Barnabas luho Saulus jaḳ in huk sën sa tato luho in bë luho degevonġ lo.” ");
INSERT INTO bzh_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Lob ayej ggërin nos gedenejom raḳ ggökin, gemëm debë nemaj raḳ luho gedevonġ luho ya. ");
INSERT INTO bzh_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Anon Vabuung vonġ luho ya, lob luho deluḳ medeya Selusia mederaḳ yaġ vu saga bedeggök loo medeya Kupros. ");
INSERT INTO bzh_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Luho detöḳ ya Salamis, lob luho denër Anutu yi ġaġek loḳ alam Yuda hir dub-supinsën-yi la. Jon sën arë ngwë nebë Markus lo neya ving luho beneloḳ vu luho. ");
INSERT INTO bzh_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Lob lööho detetuu aggata medeya deyoh vu dob Kupros vahi sagu, belööho detöḳ ya Papos. Lob lööho detöḳ raḳ Yuda ti arë nebë Bar-Yesu. Yi mehö nerob alam los nevonġ yeseḳ lu nġaa aggagga, rëḳ nenër yi bë yi mehö-nenër-ġaġek-ranġahsën ti. ");
INSERT INTO bzh_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mehö-nenër-ġaġek-kuungsën sënë nevonġ huk vu kiap böp arë nebë Sergius Paulus, mehö kwa böp. Lob Sergius sënë tahi Barnabas luho Saulus deya vu yi in bë luho denanër Anutu yi ġaġek begenġo. ");
INSERT INTO bzh_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Rëḳ mehö nerob alam Bar-Yesu sën denenër arë loḳ Grik ayej nebë Elumas lo, nevonġ in bë gërin luho gekiap su gërin yi besepa doḳ Yesu. ");
INSERT INTO bzh_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Rëḳ Anon Vabuung loḳ ya meggërin Saulus sën denenër arë ngwë nebë Paulus lo ayo, lob tunġ mala raḳ Elumas niwëëk genër bë, ");
INSERT INTO bzh_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Satan nalu honġ! Ġenevonġ ayem vu ġaġek anon pin! Ġaġek kuungsën pin los ġaġek nipaya saga pup ayom ya! Ġenevonġ paya vu Mehöböp yi aggata nivesa pin! Maḳ su kwam nevo bë gwevuu na rë? ");
INSERT INTO bzh_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Om gwenġo! Gwëbeng Mehöböp nema vonġin ngis honġ bemalam gemir. Su rëḳ gwelë nyëġ rë gerëḳ ġemedo nabë saga noh vu buk nġahi rot!” Paulus nër bë sagi, log pevis bElumas mala raru loḳ, log ketul loḳ beya nesero mehönon sën denajom doḳ nema bedetato aggata vu yi lo. ");
INSERT INTO bzh_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kiap böp lë nġaa saga, lob vonġ ving. In lëk anon meranġa nema in Mehöböp yi ġaġek. ");
INSERT INTO bzh_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulus losho alam sën desepa yi lo devuu Papos, log yaġ ḳo sir ya Perga ggëp distrik Pampulia, rëḳ Jon sën arë ngwë nebë Markus lo vuu sir geyah meya Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Gesir vu Perga beya detöḳ ya Antiok vu distrik Pisidia. Log Buk-sewahsën-yi* lob deloḳ ya dub-supinsën-yi beto denedo ving alam Yuda. ");
INSERT INTO bzh_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Alam ggev detevin Moses yi horek los alam-denenër-ġaġek-ranġahsën hir ġaġek vu alam ggovek ya, log mëm denër vu Paulus losho alam sën desepa yi lo bë, “Arig lo, nabë ham ġaġek la neggëp in bë bo niwëëk doḳ alam ayoj, og ham nanër nam.” ");
INSERT INTO bzh_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Lob Paulus kedi nare mevonġ nema raḳ bë ayej nama, log mëm nër bë, “Ham alam Israel sagi, geham alam-yu-ngwë sën ham nehöneng in Anutu meneḳo yi raḳ lo, ham gwenġo rë! ");
INSERT INTO bzh_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Hil Israel hil ḳenud lo denedo nebë alam-yu-ngwë loḳ dob Ejep wirek, loḳ mëm Anutu ggooin sir raḳ bevonġ benġahijseḳë loḳ, loḳ tum ḳo sir vër in nyëġ saga raḳ niwëëk. ");
INSERT INTO bzh_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Lob jom yi ahon loḳ nyëġ-yumeris geneġin sir yoh vu ta mehödahis luu. ");
INSERT INTO bzh_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tum vu Kanaan lob Anutu kevoh alam yu nemadvahi-bevidek-luu ya, log vo hir dob vu alam Israel. ");
INSERT INTO bzh_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Lob dejom dob sënë ahon medenedo loḳ yoh vu ta 450. Log ggooin alam ggev raḳ in bë degeġin sir. Rot beverup loḳ mehö-nenër-ġaġek-ranġahsën Samuel yi buk. ");
INSERT INTO bzh_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Lob vu buk saga denesu vu Anutu bë gevonġ mehö-los-bengö ti in geġin sir, lob Anutu vonġ Saulus sën Kis nalu lo vu sir. Yi degwa vu Benyamin, lob tu mehö-los-bengö menedo yoh vu ta mehödahis luu. ");
INSERT INTO bzh_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Rëḳ mëm Anutu ruuk yi ya getunġ Davit netu hir mehö-los-bengö loḳ yah ben. Tateḳin Davit vu sir bë, ‘Sehooin Yese nalu Davit raḳ ggovek. Sahëġ ving yi vorot, in rëḳ tamuin sa ġaġek.’ ");
INSERT INTO bzh_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Anutu vonġ yoh vu sën nër wirek bë rëḳ gevonġ lo, lob anon raḳ. Vonġ Davit* yi mewis ti sën Yesu verup vu Israel in bë geḳo hil vër in hil nġaa nipaya nyëvewen. ");
INSERT INTO bzh_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu yö nahën, log Jon muġin benër ġaġek ranġah vu alam Israel pin bë degërin sir vu hir nġaa nipaya gedejipek bël. ");
INSERT INTO bzh_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Lob dus raḳ in bë Jon yi huk govek na, lob nër bë, ‘Ham kuung bë sa re? Sa su mehö sën ham neġin lo rë. Om ham gwenġo rë! Mehöti sën rëḳ tamuin sa menam, og sa su mehö niġ vesa yohvu in bë sa natu yi hur ti meḳevelekin vaha suu rë.’ ");
INSERT INTO bzh_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Arig lo, ham sën Abraham yi mewis ham, geham alam-yu-ngwë vahi sën ham nehöneng in Anutu lo, og Anutu vonġ ġaġek sënë yam vu hil pin in bë geḳo hil vër in hil nġaa nipaya nyëvewen. ");
INSERT INTO bzh_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Alam sën denedo Yerusalem losho hir alam ggev lo su deraḳ Yesu sagi ni nivesa rë, gesu detöḳ raḳ alam-denenër-ġaġek-ranġahsën hir ġaġek sën denenër loḳ Buk-sewahsën-yi* pin lo degwa rë. Om dejoo yi ġaġek bë nadiiḳ, lom ġaġek sën alam-denenër-ġaġek-ranġahsën denenër wirek lo anon raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Su delë bë vonġ nġaa ti paya in bë dengis yi rë, rëḳ detahi niwëëk vu Pilatus bë ngis yi menadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Devonġ yoh vu nġaa pin sën alam-denenër-ġaġek-ranġahsën dekevu wirek meneggëp loḳ Anutu-yi-ḳapiya lo, banon raḳ ggovek ya. Log deḳo yi vër vu ḳelepeḳo* beya debë yi ya bedub. ");
INSERT INTO bzh_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Rëḳ Anutu vonġ bekedi raḳ yah vu bedub ggökin. ");
INSERT INTO bzh_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kedi raḳ vu bedub, lob tato yi vu alam sën denesepa yi vu Galilea wirek gederaḳ medeya Yerusalem ving yi lo. Lob gwëbeng alam saga sën medo denenër yi ġaġek ranġah vu mehönon. ");
INSERT INTO bzh_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Lob he yam in bë nanër yi Bengö Nivesa vu ham nabë nġaa sagi sën wirek Anutu nër vu hil ḳenud lo bë rëḳ gevonġ lo, ");
INSERT INTO bzh_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","saga gwëbeng Anutu vonġ banon raḳ vu hir mewis lo sën hil agi ggovek ya. Saga nebë vonġ meYesu kedi raḳ yoh vu ġaġek sën neggëp loḳ Saam netu luu lo bë: ‘Sa naluġ honġ. Sa haḳo honġ gwëbeng!’ ");
INSERT INTO bzh_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Log nër wirek bë rëḳ gevonġ bekedi jaḳ nah vu bedub, gesu yoh vu bë rëḳ gëp mepetar na rë, in Anutu nër bë: ‘Sëḳ ġevonġ nġaa nivesa vesa pin sën wirek senër bë sëḳ ġevonġ vu Davit lo vu ham yönon.’ ");
INSERT INTO bzh_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Log tateḳin ġaġek sënë raḳ ġaġek ngwë sën nebë: ‘Su rëḳ gwevuu honġ mehö vabuung mepetar na rë.’ ");
INSERT INTO bzh_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Hil araḳ ni bë Davit nedo dob, lob nevonġ huk yoh vu Anutu kwa beverup loḳ buk sën diiḳ lo. Lob delev yi beya neggëp ving ama lo bu lo bemëm petar ya yönon. ");
INSERT INTO bzh_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Gaḳ mehö sën Anutu vonġ mekedi raḳ lo, og saga su petar ya rë. ");
INSERT INTO bzh_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Om arig lo, sa bë ham jaḳ ni, om sën he nanër ġaġek ranġah vu ham bë: Mehö saga sën yoh vu bë kevoh ham nġaa nipaya na. ");
INSERT INTO bzh_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moses yi horek og su yoh vu bë rëḳ kevoh ham nġaa nipaya na genanër nabë ham alam yohvu rë. Rëḳ mehö saga sën mëm yoh vu bë kevoh alam pin sën ayoj na timu vu yi lo hir nġaa nipaya pin na, genanër sir nabë sir alam yohvu. ");
INSERT INTO bzh_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nebë saga, om ham gweġin ham! In nġaa sën alam-denenër-ġaġek-ranġahsën denenër wirek lo su natöḳ vu ham. Sën nebë: ");
INSERT INTO bzh_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ham sën nenër ġaġek pelësën, ham gwelë! Ham kwamin na nġahi, beham malamin nama! In sa hevonġ huk ti loḳ ham buk sën ham nedo-ë, rëḳ mu nabë mehöti nanër sagi vu ham, og ham su rëḳ gwevonġ geving yi ġaġek rë!’” ");
INSERT INTO bzh_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ggovek log Paulus luho Barnabas bë geto denah dobnë, lob alam saga denër vu luho bë luho nom denanër ġaġek sagi doḳ Buk-sewahsën-yi* ngwë tamusën gök nahin. ");
INSERT INTO bzh_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Log deketëḳin sir, loḳ alam Yuda nġahiseḳë losho alam-yu-ngwë sën deggërin ayoj medenejom raḳ ving alam Yuda lo deya vu Paulus luho Barnabas, lob luho delev horek loḳ sir bë nij wëëk bedegevonġ geving Anutu yi semusemu sën nevonġ vu sir lo. ");
INSERT INTO bzh_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Log Buk-sewahsën-yi* ngwëgu, lob alam vu nyëġ saga pin yam desupin sir in bë degenġo Anutu yi ġaġek. ");
INSERT INTO bzh_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Rëḳ alam Yuda delë alam nġahiseḳë yam denedo, lob ayoj sis yi vu luho gedemehoo Paulus yi ġaġek pin bedenër ġaġek nipaya raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Nebë saga lom Paulus lu Barnabas denër yah niwëëk ata bë, “Yönon! Huk neggëp vu aluu bë alu ġaḳo Anutu yi ġaġek sënë nam vu ham namuġin. Rëḳ ma geham ruu demimin vu, lob saga tato bë ham su yoh vu bë rëḳ medo malamin-tumsën degwata rë. Om ham gwenġo rë! Alu rëḳ peggirin he nah benanër vu alam-yu-ngwë sënë. ");
INSERT INTO bzh_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","In Mehöböp nër vu he bë: ‘Sa hevonġ honġ in ġenatu alam-yu-ngwë hir ranġah, meġedoḳ vu sir noh vu dob pin megweḳo sir nom vu sa.’” ");
INSERT INTO bzh_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Alam-yu-ngwë saga denġo yi ġaġek, lob ahëj nivesa rot in Mehöböp yi ġaġek, galam pin sën Anutu yö ggooin sir raḳ bë demedo malaj-tumsën degwata los degwata lo devonġ ving. ");
INSERT INTO bzh_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lob Mehöböp yi ġaġek saga ya meyoh vu nyëġ saga pin. ");
INSERT INTO bzh_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Rëḳ alam Yuda deloḳ avëh los arëj sën denejom raḳ ving sir lo la ahëj, gedeloḳ ggev maluh vu nyëġ sagu la ahëj ving bë nij tebö in Paulus lu Barnabas gedegetii luho na in hir nyëġ. ");
INSERT INTO bzh_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Lob luho detetëhin kebus in vahaj in bë tato hir huk nipaya sën rëḳ gëp degwata vu sir lo vu sir, log luho deya Ikonium. ");
INSERT INTO bzh_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Lob sir sën denġo Yesu yi ġaġek ggëp Antiok medevonġ ving lo, ahëj nivesa rot gemëm Anon Vabuung luḳ yam ggërin ayoj. ");
INSERT INTO bzh_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Vu Ikonium og luho devonġ nebë sën Antiok lo. Luho deloḳ ya alam Yuda hir dub-supinsën-yi bedenër Bengö Nivesa ranġah. Luho denër nivesa, lob alam Yuda los alam Grik yu böpata devonġ ving. ");
INSERT INTO bzh_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Rëḳ alam Yuda vahi su devonġ ving rë, lob deloḳ alam dahis ahëj bedenër ġaġek nipaya raḳ Kerisi-yi-alam. ");
INSERT INTO bzh_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulus luho Barnabas denedo buk nġahi vu Ikonium gesu deneggöneng rë. Gaḳ luho nijwëëk medenër Mehöböp yi ġaġek ranġah, lob Mehöböp vonġ niwëëk loḳ luho nemaj, beluho devonġ nġaa böp böp los huk aggagga in bë tato vu alam nabë ġaġek semusemu sën denenër lo yönon. ");
INSERT INTO bzh_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Rëḳ alam nyëġ saga devasuh sir ya yu luu. Vahi deġadu alam Yuda gevahi deġadu sinarë luho. ");
INSERT INTO bzh_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Lob alam dahis ving alam Yuda medekedi ving hir alam ggev in bë degevonġ paya vu Barnabas luho Paulus. Devonġ in bë dengis luho jaḳ ġelönġ beluho denadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Rëḳ luho denġo, lob deveya medeya distrik ngwë arë nebë Lukaonia medeya Lustra los Derbe los begganġ-bu sën denedo dus vu nyëġ böp luu saga. ");
INSERT INTO bzh_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Bemëm luho denër Bengö Nivesa ranġah vu alam begganġ-bu pin saga. ");
INSERT INTO bzh_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lob mehöti nedo Lustra, su neggee meneya rë, in ata ḳo yi to los vaha nipaya. ");
INSERT INTO bzh_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mehö sënë nenġo Paulus nenër ġaġek, lob Paulus gët yi niwëëk geraḳ ni bë ayo neya timu beyoh vu bë nivesa jaḳ. ");
INSERT INTO bzh_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Lob nër ya niwëëk bë, “Kwedi jaḳ beġebare!” Lob mehö sënë kedi raḳ pevis beggee meneya. ");
INSERT INTO bzh_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lob alam nġahiseḳë delë nġaa sën Paulus vonġ agi, lob detahi loḳ ayej Lukaonia nebë, “Anutu luu depöö mehönon raḳ bedeluḳ yam vu hil!” ");
INSERT INTO bzh_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bedenër Barnabas bë hir anutu-kuungsën Seyus, log Paulus nenër ġaġek, om denër yi bë hir anutu-kuungsën Hermes. ");
INSERT INTO bzh_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Anutu-kuungsën Seyus yi dub ti nedo ya los nyëġ böp sagu nenga, lob Seyus yi mehö-neḳo-seriveng vuneḳ vu burmakau nalu maluh la raḳ sesik beḳo meyam aggata avi in bë losho alam saga dengis bedebesi seriveng vu luho. ");
INSERT INTO bzh_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Loḳ sinarë Barnabas lu Paulus denġo ġaġek sënë, lob luho ayoj maggin rot bedekweeḳ hir röpröp, geluho deseröġ bedeya deloḳ ya alam vuheng atov bedetahi bë, ");
INSERT INTO bzh_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Alam-e! Ham nevonġin bë gwevonġ va? Aluu mehönon meris mu nebë ham! Alu bë nanër Bengö Nivesa vu ham in ham gwevuu ham nġaa kuungsën saga na geham peggirin ham nom vu Anutu sën mala-tumsën degwa. Sën tunġ dob los yaġek geloo los nġaa pin sën nedo loḳ lo. ");
INSERT INTO bzh_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Yönon, wirek Anutu lë mehönon mu, gedevonġ nġaa pin yoh vu yö kwaj. ");
INSERT INTO bzh_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Rëḳ su vun yi rot in bë ham duġin yi rë. Gaḳ nevonġ nġaa nivesa vesa vu ham mehönon. Nevonġ hob neto vu ham, los nevonġ beham nos anon neloḳ loḳ yi buk niröp. Nevonġ nos vu ham nebë saga, lob vonġ beham kwamin vesa.” ");
INSERT INTO bzh_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Luho devonġ ġaġek sagi bedenare saheng saheng rot in bë degërin alam saga besu debesi seriveng vu luho. ");
INSERT INTO bzh_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Loḳ alam Yuda vu Antiok los Ikonium deyam, lom deloḳ alam saga ahëj, lob ahëj sengën bedetengwa Paulus raḳ ġelönġ. Dekuung bë diiḳ ya, lom dedadii to meya dobnë. ");
INSERT INTO bzh_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Lom alam sën denevonġ ving lo yam detetup yi, rëḳ kedi raḳ beyah meya begganġ. Log monbuk lom luho Barnabas kedi deya Derbe. ");
INSERT INTO bzh_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Luho denër Bengö Nivesa ranġah vu nyëġ sagu, lob alam nġahiseḳë detu Yesu yi hur. Saga ggovek loḳ luho deyah Lustra los Ikonium, medetöḳ yah Antiok vu distrik Pisidia ggökin, ");
INSERT INTO bzh_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","bedevo niwëëk loḳ Kerisi-yi-alam ayoj medeġadu sir, log luho delev horek vu sir bë, “Ham nġo ayomin na timu vu Kerisi niwëëk bemedo. Hil bë adoḳ na Anutu-yi-nyëġ, rëḳ mu hil ġaḳo maggin namuġin rë.” ");
INSERT INTO bzh_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Lob luho deggooin alam la raḳ yoh vu begganġ-bu pin saga in denatu ggev medegeġin Kerisi-yi-alam, log ayej ggërin nos gedejom raḳ in sir medetunġ sir loḳ ya Mehöböp sën ayoj neya timu vu yi ggovek lo nema in bë geġin sir. ");
INSERT INTO bzh_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ggovek ya saga log luho deyoh ya distrik Pisidia medetöḳ yah distrik Pampulia, ");
INSERT INTO bzh_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","lob luho denër Anutu yi ġaġek ranġah ggëp Perga. Ggovek, log luho deluḳ medeya Atalia. ");
INSERT INTO bzh_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Loḳ tum luho deraḳ yaġ vu Atalia, bedeyah medeya Antiok. Yiḳ Antiok saga sën wirek alam detunġ luho loḳ Anutu nema in bë geġin luho geluho na degevonġ yi huk sën luho denevonġ rot begwëbeng agi. ");
INSERT INTO bzh_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Log luho detöḳ yah Antiok lom mëm desupin Kerisi-yi-alam pin, log luho deturin nġaa pin sën Anutu nevonġ vu luho lo ranġah, gedenër bë Anutu tateḳin aggata vu alam-yu-ngwë bedeyoh vu bë ayoj na timu vu Yesu geving. ");
INSERT INTO bzh_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Lob luho denedo buk nġahiseḳë ving Kerisi-yi-alam sagu. ");
INSERT INTO bzh_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Lob Kerisi-yi-alam la vu Yuda deluḳ medeya Antiok bedenër ġaġek vu arij lo bë, “Nabë ham su sepa doḳ Moses yi horek begwerah* navimin rë, og Anutu su rëḳ geḳo ham nah rë!” ");
INSERT INTO bzh_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Denër nebë sënë, lob Paulus lu Barnabas ahëj sengën rot vu sir bedevo ġaġek raḳ sir rot. Lob Kerisi-yi-alam deggooin Paulus lu Barnabas raḳ, galam la ving, in bë dejaḳ medena Yerusalem bedebengwënġ jaḳ ġaġek rahsën* navij geving sinarë nyëdahis losho alam ggev. ");
INSERT INTO bzh_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Devonġ sir ya, lob ya deyoh aggata sën neyoh ya dob Ponisia lu Samaria lo, bedenër bengö vu Kerisi-yi-alam vu begganġ-bu mahen mahen pin loḳ distrik luu saga bë alam dahis deggërin ayoj yah vu Anutu. Lob arij lo ahëj nivesa in. ");
INSERT INTO bzh_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Lob ya detöḳ ya Yerusalem, lob Kerisi-yi-alam losho sinarë, galam ggev, deḳo sir raḳ. Lob Paulus lu Barnabas denër nġaa pin sën Anutu vonġ vu luho lo vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Rëḳ alam Parisai* la sën ayoj neya timu vu Yesu lo dekedi medenër yah bë, “Ham gwerah* navij, geham nanër vu sir nabë desepa doḳ Moses yi Horek geving, og mëm!” ");
INSERT INTO bzh_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nebë saga lob sinarë nyëdahis losho alam ggev desupin sir in bë debengwënġ jaḳ medegero. ");
INSERT INTO bzh_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Medo denesap sir raḳ ġaġek hus adingseḳë, loḳ mëm Pita kedi menër bë, “Arig lo! Ham raḳ ni bë wirek Anutu vo huk ggelek hil, log ggooin sa raḳ in bë sa nanër Bengö Nivesa vu alam dahis in degenġo bedegevonġ geving. ");
INSERT INTO bzh_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Anutu raḳ mehönon pin ayoj ni, lob vo Anon Vabuung vu sir, nebë sën vo vu hil lo, in bë tato nabë nelë sir nivesa. ");
INSERT INTO bzh_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Su vonġ huk ti vu hil gevonġ huk agga ngwë vu sir rë. Gaḳ ayoj ya timu vu yi lob yiḳ saga vonġ bayoj niveseek raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ma ham bë seggi Anutu in va? Sën ham bë gwebë nġaa maggin saga jaḳ Kerisi-yi-alam kwaj-ë! Gaḳ yiḳ hil los hil ḳenud lo su ayoh vu bë ḳerë horek sagi geving rë. ");
INSERT INTO bzh_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Gaḳ hil nehevonġ ving bë Anutu neḳo hil yah vu yi raḳ Mehöböp Yesu yi semusemu, lob yiḳ neḳo alam saga yah nebë saga ving.” ");
INSERT INTO bzh_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita nër bë sënë, lob alam supinsën pin ayej ma, gedebë nengaj in Barnabas luho Paulus hir ġaġek sën luho deneturin nġaa böp aggagga pin bë Anutu vo niwëëk vu luho beluho devonġ vu alam-yu-ngwë lo. ");
INSERT INTO bzh_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Luho denër ggovek log Yakobus kedi menër bë, “Arig lo, ham gwenġo sa ġaġek rë! ");
INSERT INTO bzh_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon nër vu ham bë Anutu yam vu alam-yu-ngwë muġinsën nebë sënë in gooin sir vahi jaḳ bedenatu yi alam. ");
INSERT INTO bzh_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Lob alam-denenër-ġaġek-ranġahsën yiḳ denër ġaġek timu nebë sënë. Sën neggëp loḳ Anutu-yi-ḳapiya nebë: ");
INSERT INTO bzh_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Nahub rëḳ sëḳ nam, lob Davit yi dub sën tamanġ meto nedo lo, saga sëḳ dev jaḳ nah gökin. Yi nġaa pin sën petar ya lo, saga sëḳ bo mewis doḳ nah, berëḳ medo nabë sën muġinsën. ");
INSERT INTO bzh_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","In mehönon vahi rëḳ desero Mehöböp. Alam-yu-ngwë sën senġo hooin sir raḳ in bë denatu sa nġaa lo pin. Mehöböp sën vonġ beġaġek agi töḳ yam ranġah wirek lo, lob nër nebë sënë vu hil.’” ");
INSERT INTO bzh_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Log nër ving bë, “Om sa kwaġ nevo bë hil su abo horek nġahiseḳë medeġinengin alam-yu-ngwë sën deneggërin sir medeyam vu Anutu lo. ");
INSERT INTO bzh_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Gaḳ mëm hil ḳevu ḳapiya ti na vu sir nabë su dega reggu sën alam denetunġ netu seriveng vu anutu-kuungsën lo, gesu degevonġ baggëb, log su dega reggu sën alam deneseyu kwaj medenediiḳ lo, besu dega reggu nij ḳöḳ. ");
INSERT INTO bzh_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gaḳ hil nġo araḳ ni bë mehönon denedo yoh vu nyëġ pin medenër Moses yi horek loḳ dub-supinsën-yi yoh vu Buk-sewahsën-yi* pin rot beverup gwëbeng. ");
INSERT INTO bzh_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Lob sinarë losho alam ggev geKerisi-yi-alam pin dejoo ġaġek, log deggooin hir mehö luu raḳ in bë luho dena Antiok geving Paulus lu Barnabas. Deggooin Yudas sën arë ngwë nebë Barsabas geSilas, sën luho detu Kerisi-yi-alam hir ggev lo. ");
INSERT INTO bzh_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Lom dekevu ḳapiya bedevo loḳ luho nemaj. Dekevu nebë: He sinarë los alam ggev sën ham arimin lo he. He ḳevu ḳapiya dus ti sagi yök vu he arimin lo ham sën ham alam-yu-ngwë vu Antiok los Suria, geKilisia. ");
INSERT INTO bzh_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","He hanġo bë he alam la deyök bedenër horek nġahiseḳë vu ham bedevonġ ham ayomin maggin raḳ geham kwamin neketul loḳ. Rëḳ he su anër vu sir bë degevonġ nabë saga rë. ");
INSERT INTO bzh_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","He hanġo ġaġek sagi, lob mëm he ayomin timu, gehe joo ġaġek ggovek gemëm he hooin arimin luu sënë raḳ behevonġ luho deneyök vu ham ving he arimin luu sën he ahëmin ving luho panġsën lo, Barnabas lu Paulus. ");
INSERT INTO bzh_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Luho su deneggöneng in navij bë rëḳ malaj nama jaḳ sën deneḳo hil Mehöböp Yesu Kerisi arë raḳ agi rë. ");
INSERT INTO bzh_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nebë sënë, lob he hevonġ Yudas lu Silas deyök ving luho in bë mëm luho denanër ġaġek sagi jaḳ avij geving vu ham. ");
INSERT INTO bzh_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Anon Vabuung nër vu he, behe joo ġaġek bë he su ġetunġ horek nġahiseḳë bedeġinengin ham. Gaḳ yiḳ horek sagi sën mëm ham sepa doḳ. ");
INSERT INTO bzh_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ham su gwa reggu sën alam denesis in bë degetunġ seriveng vu anutu-kuungsën lo, geham su gwa reggu nij ḳöḳ, geham su gwa reggu sën deneseyu kwaj medenediiḳ lo, geham su gwevonġ baggëb. Nabë ham gweġin ham besu gwevonġ nġaa pin sagi rë, og rëḳ nivesa rot. Ġaġek ggovek saga. Anutu geving ham begeving he. ");
INSERT INTO bzh_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ggovek, log mëm Kerisi-yi-alam devonġ sir medeluḳ medeya Antiok, bedesupin Kerisi-yi-alam pin ggëp sagu, log devo ḳapiya vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Detevin ḳapiya, lob kwaj vesa in ġaġek nivesa sën neggëp loḳ ḳapiya lo vo niwëëk vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Lob alam-denenër-ġaġek-ranġahsën luu sën Yudas lu Silas lo, denër ġaġek nġahiseḳë vu sir, bedevo niwëëk vu sir bedeġadu sir ving. ");
INSERT INTO bzh_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Luho denedo hus ading teka ggëp Antiok ggovek, loḳ tum arij lo pin devonġ luho yah los ġaġek nahub, beluho deyah medeya vu alam sën devonġ luho ya lo. ");
INSERT INTO bzh_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Rëḳ Silas yö vonġ yoh vu kwa menedo Antiok. ");
INSERT INTO bzh_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Log Paulus lu Barnabas denedo Antiok, belosho alam vahi denetahu mehönon medenenër Mehöböp yi Bengö Nivesa ranġah vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Buk la ya ggovek loḳ Paulus nër vu Barnabas bë, “Alu anah mana ġalë arid lo vu nyëġ pin rë, sën wirek alu anër Mehöböp yi ġaġek vu sir lo. In alu ajaḳ ni nabë denedo nivesa ma ma!” ");
INSERT INTO bzh_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Lob Barnabas bë geḳo Jon na geving luho. Jon sën arë ngwë nebë Markus lo. ");
INSERT INTO bzh_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Rëḳ Paulus nër bë, “Mehö sagi sën wirek vuu aluu ggëp Pampulia gesu yam huk ving aluu rë lo, om alu su ġaḳo yi na geving!” ");
INSERT INTO bzh_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Lob luho denër sir rot, lom devasuh sir beBarnabas ḳo Markus beluho deraḳ yaġ bedeya Kupros. ");
INSERT INTO bzh_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Log Silas ya ving Paulus geKerisi-yi-alam deketaġ vu Mehöböp bë yi semusemu medo geving luho, log devonġ luho ya. ");
INSERT INTO bzh_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Luho ya deḳo loḳ distrik Suria los Kilisia, beluho devo niwëëk loḳ Kerisi-yi-alam vu sagu ayoj. ");
INSERT INTO bzh_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ggovek log Paulus luho Silas ya deverup Derbe medeya Lustra ving. Lob Yesu yi hur ti nedo sagu arë nebë Timoti. Yuda avëh ti sën ayo neya timu vu Yesu lo nalu yi, gamaḳ Grik ti. ");
INSERT INTO bzh_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lob Kerisi-yi-alam vu Lustra los Ikonium denenër Timoti bë mehö nivesa. ");
INSERT INTO bzh_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus ahë ving Timoti bë na geving yi, lob ḳo yi merah* navi. In kwa vo bë alam Yuda sën denedo agu, lob vonġ nebë sënë in deraḳ ni bë Timoti ama Grik, om rëḳ dejuuk yi. ");
INSERT INTO bzh_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Lob detetuu aggata medeya deyoh vu begganġ-bu nġahiseḳë, lob denevonġ ġaġek sën sinarë los ggev dejoo vu Yerusalem lo vu Kerisi-yi-alam pin gedenër vu sir bë desepa doḳ. ");
INSERT INTO bzh_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Lob mëm Kerisi-yi-alam devonġ ving niwëëk ata, log alam deneloḳ yam ving sir yoh vu buk, besir nġahiseḳë neraḳ. ");
INSERT INTO bzh_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Devonġin bë dena distrik Asia* rëḳ Anon Vabuung nërin sir bë su dena denanër Anutu yi ġaġek vu alam Asia*. Lom verup detetuu aggata meya deḳo loḳ distrik Prugia los Galata. ");
INSERT INTO bzh_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Lob ya deverup loḳ distrik Musia hir den atov, lom kwaj nevo bë dedoḳ na distrik Bitunia, rëḳ Yesu yi Anon Vabuung nërin sir. ");
INSERT INTO bzh_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Lob deyoh ya Musia hir den atov meya deto Troas. ");
INSERT INTO bzh_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Lob Paulus lë nġaa nebë pesepsën loḳ buk, geMasedonia ti nare getahi ya vu yi bë, “Ġeġök loo meġenam distrik Masedonia meġedoḳ vu he!” ");
INSERT INTO bzh_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulus lë nġaa saga ggovek, log he pevis benesero yaġ in bë ajaḳ mana loo vahi distrik Masedonia, in he raḳ ni bë Anutu tahi he in bë he na nanër Bengö Nivesa vu alam sagu. ");
INSERT INTO bzh_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Lob he raḳ yaġ vu Troas besesor maya Samotrakia. Log monbuk lob he ya verup Neapolis, ");
INSERT INTO bzh_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","baya verup Pilipi sën alam Rom yam denedo loḳ benyëġ böpata kesuu begganġ-bu pin vu distrik Masedonia lo. Lob he nado buk la vu nyëġ saga. ");
INSERT INTO bzh_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Log Buk-sewahsën-yi* lob he heto mayoh bël nenga sën neggëp dus vu begganġ agi aggata avi, behe ya matöḳ vu nyëġ len teka sën alam Yuda denesupin sir medenejom raḳ loḳ lo. Lob he töḳ raḳ avëh la gedesupin sir medenedo bël saga nenga, lob he heto nado ving sir manër ġaġek ranġah vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lob Tuatira avëh ti arë nebë Ludia nġo he ġaġek sagi. Avëh sënë nevonġ huk monë yi raḳ tob mala saġap, geyö nejom raḳ vu Anutu yoh vu buk. Nenġo Paulus yi ġaġek lob Mehöböp ggërin ayo gebë nenga in. ");
INSERT INTO bzh_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lob losho yi alam deripek bël ggovek loḳ nër bë, “Bë ham gwelë nabë sayoġ neya timu vu Mehöböp yönon, og ham doḳ nam medo sa begganġ.” Jij he niwëëk ata nebë sënë, lob he su ayoh vu bë ḳeyëh aye rë. ");
INSERT INTO bzh_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Buk ngwë lob tum he tetuu aggata maya nyëġ jomraḳsën-yi, loḳ hur avëh ti töḳ vu he loḳ aggata. Mehöti baġo avëh sënë tu yi nġaa meris, lob yi avëh sënë yutöḳsën benenër ġaġek vunsën ranġah. Lom avëh sagi ala neḳo monë böpata raḳ yi huk yutöḳsën sënë. ");
INSERT INTO bzh_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Lob avëh sagi sepa he los Paulus metahi bë, “Anutu vavunë yi alam sënë yönon rot! Denenër aggata sën Anutu geḳo mehönon nah lo tato vu hil!” ");
INSERT INTO bzh_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Avëh sënë nevonġ nebë sënë raḳ buk, lob Paulus ni tebö raḳ, lom ggërin menër vu memö nipaya bë, “Senër raḳ Yesu Kerisi arë niwëëk vu honġ bë ġedëëin avëh sënë geġena!” Lob pevis bememö lëëin avëh geto meya. ");
INSERT INTO bzh_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Lom avëh sagi ala lo pin delë bë hir baġosën degwa to meya, lob dejom Paulus luho Silas ahon mededadii luho ya telig vu alam ggev. ");
INSERT INTO bzh_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Deḳo luho ya vu kiap log denër bë, “Alam Yuda luu sënë deyam in bë degevonġ bebeġö berup doḳ hil nyëġ. ");
INSERT INTO bzh_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","In denenër bë hil sepa doḳ horek agga ti sën hil alam Rom hil su ayoh vu bë ġevonġ ma sepa doḳ rë lo.” ");
INSERT INTO bzh_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Lob alam pin deloḳ vu sir medenër ġaġek raḳ luho ving. Lob kiap kah luho hir tob ya in luho, log nër bedeveek luho raḳ beggi. ");
INSERT INTO bzh_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Deveek luho rot ggovek, log detunġ luho loḳ ya ḳarabus gedenër niwëëk vu mehö neġin begganġ ḳarabus bë geġin luho nivesa. ");
INSERT INTO bzh_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mehö saga nġo ġaġek niwëëk sënë, lob tunġ luho loḳ ya begganġ ḳarabus ayo peggo, gedevingin luho vahaj ahon raḳ nġadoheng. ");
INSERT INTO bzh_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Log buk vuheng raḳ lob Paulus lu Silas medo denejom raḳ los denevonġ raro vu Anutu, galam ḳarabus pin medo denenġo luho. ");
INSERT INTO bzh_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Lob pevis bejemapi ggee böpata beggee raḳ begganġ ḳarabus los mudeng pin, lob repinġ pin tahinin avuti, gesëng puh in alam ḳarabus pin. ");
INSERT INTO bzh_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Lob mehö neġin ḳarabus kedi melë bë repinġ pin tahinin, lom kuung bë alam ḳarabus to deya pin, lom tur yi paëp-yu-anil in bë yö tetev yi benadiiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Rëḳ Paulus tahi niwëëk ya vu bë, “Su ġebasap honġ! In he pin nado!” ");
INSERT INTO bzh_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Log mehö neġin ḳarabus tahi bedeḳo ram yam. Log seröġ meluḳ ya ḳarabus ayo, rëḳ neggöneng rot genelëk, lob petev meneggëp loḳ Paulus lu Silas vahaj. ");
INSERT INTO bzh_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Log li luho to meyah dobnë genër bë, “Mehö böp luho! Sa ġevonġ nabë va in Anutu geḳo sa nah vu yi?” ");
INSERT INTO bzh_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Lob luho denër vu yi bë, “Ayom na timu vu Mehöböp Yesu, og rëḳ Anutu geḳo honġ los honġ alam geving nah vu yi.” ");
INSERT INTO bzh_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Lob mëm luho detateḳin Mehöböp yi ġaġek ranġah vu losho yi alam sën deneggëp loḳ yi begganġ lo. ");
INSERT INTO bzh_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lob buk vuheng raḳ rëḳ ḳo luho beya meripek beggi niben. Lom pevis belosho yi alam pin deripek bël loḳ yiḳ buk saga. ");
INSERT INTO bzh_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Log ḳo luho loḳ yah yi begganġ ayo bevo nos vu luho, log losho yi alam ayoj tee yi in ayoj ya timu vu Anutu. ");
INSERT INTO bzh_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Log heng to, lob kiap devonġ ahëvavu la ya medenër bë, “Ham gweḳo mehö luu saga vër in ḳarabus bedenah bej!” ");
INSERT INTO bzh_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Lob mehö neġin ḳarabus yah menër ġaġek sënë vu Paulus bë, “Kiap devonġ ġaġek yam bë melu nah. Om melu dëëin begganġ ḳarabus na gemelu na los ġaġek nahub.” ");
INSERT INTO bzh_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Rëḳ Paulus nër vu sir bë, “Aluu alam Rom, rëḳ alu su hevonġ nġaa nipaya ti in bë degetunġ aluu duḳ na ḳarabus rë. Gaḳ yö desis aluu meris mu raḳ alam pin malaj gedetunġ aluu yam ḳarabus. Log gwëbeng maḳ bë degetii aluu vunsën geto mena? Ma rot! Yö denam medegeli aluu geto menah dobnë.” ");
INSERT INTO bzh_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Lob ahëvavu deḳo ġaġek sënë meyah denër vu kiap lo, lob kiap denġo bë luho alam Rom yönon, lom deggöneng rot. ");
INSERT INTO bzh_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Lob ya denër ġaġek nahub los kwaj paya vu luho gedeli luho to deyah dobnë. Log denër vu luho bë luho degevuu nyëġ sënë gedena. ");
INSERT INTO bzh_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Lob luho to deya in begganġ ḳarabus, geto deyah Ludia yi begganġ, bedelë Kerisi-yi-alam bedenër ġaġek vahi vu sir in bë bo niwëëk doḳ ayoj. Log luho deya. ");
INSERT INTO bzh_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Luho deya raḳ meya deverup Ampipolis, lob luho dekesuu nyëġ sagi geya deverup Apolonia, bedekesuu geya deverup Tesalonika. Sën alam Yuda hir dub-supinsën-yi ti nedo lo. ");
INSERT INTO bzh_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Lob Paulus vonġ ggökin yah nebë sën nevonġ yoh vu nyëġ lo. Loḳ ya dub-supinsën-yi ving alam Yuda loḳ Buk-sewahsën-yi* metateḳin Anutu-yi-ḳapiya yoh vu soda löö vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nër Anutu yi ġaġek degwa tato getateḳin vu sir bë Anutu yö joo ġaġek ggovek ya bë Kerisi duḳ nam dob begeḳo ḳerus menadiiḳ, gekedi jaḳ nah gökin. Log nër bë, “Yesu sën senër bengö vu ham lo, saga Mehö sën Anutu ggooin raḳ in bë geḳo hil nah lo.” ");
INSERT INTO bzh_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Lob sir sën denġo yi ġaġek lo la deggërin sir medesepa luho Silas. Galam Grik la sën denejom raḳ vu Anutu lo yu böpata detamuin luho. Lob avëh los bengöj-ggoreksën nġahiseḳë devonġ nebë sënë ving. ");
INSERT INTO bzh_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Rëḳ alam Yuda ayoj sis yi rot in alam denesepa Paulus luho Silas, lob debaġo alam sën nijpaya beyuj-lul-ḳöḳ lo la ggëp telig, gedesupin mehönon nġahiseḳë rot beya deloḳ alam begganġ saga ahëj, bahëj sengën raḳ bededun böpata verup. Ya deggërin Yason yi begganġ medesero Paulus luho Silas in bë degeḳo luho geto dena dobnë vu alam. ");
INSERT INTO bzh_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Rëḳ su detöḳ vu luho rë, lob dedadii Yason losho Kerisi-yi-alam vahi to deya dobnë bedeḳo sir ya denare loḳ kaunsor malaj, log detahi böpata bë, “Alam sën deneloḳ alam ahëj yoh vu nyëġ pin bë degevonġ paya lo, sën gwëbeng deverup vu hil-ë. ");
INSERT INTO bzh_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Lob Yason sënë ḳo sir loḳ ya yi begganġ. Alam saga sën denekeyëh alam Rom hir mehö-los-bengö Sisar* yi horek, gedenenër bë mehö-los-bengö ngwë nedo arë nebë Yesu.” ");
INSERT INTO bzh_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kaunsor losho alam pin denġo ġaġek sënë lob newaj raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Lob denër beYason losho yi alam debaġo sir, gedenër vu sir bë degeġin Paulus luho Silas nivesa in su degevonġ bebeġö berup. Log delëëin sir medeya. ");
INSERT INTO bzh_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Loḳ pevis beKerisi-yi-alam devonġ Paulus lu Silas deya Beroya loḳ buk. Luho ya deverup Beroya, lob luho deloḳ ya alam Yuda hir dub-supinsën-yi ayo. ");
INSERT INTO bzh_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Lob alam Yuda sën denedo Beroya agu sir alam nijvesa rot kesuu alam Yuda vu Tesalonika. In deḳo Anutu yi ġaġek raḳ mahëj ving. Detevin Anutu-yi-ḳapiya yoh vu buk in bë dejaḳ ni nabë luho denenër ġaġek anon ma ma. ");
INSERT INTO bzh_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Lob alam Yuda nġahiseḳë losho alam Grik los bengöj-ggoreksën vahi ayoj ya timu vu Yesu. Sir maluh gavëh. ");
INSERT INTO bzh_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ggovek loḳ alam Yuda vu Tesalonika denġo Paulus bengö bë nenër Anutu yi ġaġek ggëp Beroya. Lob deya nyëġ sagu, medetetuhin alam sagu in bë ahëj sengën jaḳ vu Paulus losho alam sën denesepa yi lo. ");
INSERT INTO bzh_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Lob Kerisi-yi-alam depevis medevonġ Paulus ya loonë, geSilas lu Timoti denedo Beroya. ");
INSERT INTO bzh_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Lob alam sën deḳo Paulus ya aggata lo deli ya meto Atens gedeneyah, lom deḳo ġaġek meyah denër vu Silas lu Timoti bë luho dena vu Paulus pevis. ");
INSERT INTO bzh_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulus medo neġin luho ggëp Atens, loḳ lë alam nyëġ sagu bë denesepa loḳ hir anutu-kuungsën nġahiseḳë rot, lob ayo maggin rot. ");
INSERT INTO bzh_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Lob loḳ ya dub-supinsën-yi belosho alam Yuda denesap sir raḳ ġaġek. Log nevengwënġ ving alam-yu-ngwë sën denejom raḳ ving alam Yuda lo ving. Log neya telig yoh vu buk menenër ġaġek vu alam pin sën yam denedo lo. ");
INSERT INTO bzh_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Lob losho alam los kwaj böp la vu Epikurius hir dub, gela vu Stoik hir dub bedemehoo sir, lob denër bë, “Mehö ġaġek jeggin jeggin saga bë nanër ġaġek re?” Lob sir la denër bë, “Maḳ bë nanër alam nyëġ la hir anutu!” Nër bë sënë in Paulus nër ġaġek raḳ Yesu los kediraḳsën. ");
INSERT INTO bzh_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Lom deḳo Paulus ya hir begganġ kaunsor ggëp Ḳedu Ares medeloḳ tepëḳ in yi bë, “Yoh vu bë he ġanġo ġaġek mewis sën ġenenër agi lo degwa? ");
INSERT INTO bzh_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","He hanġo honġ ġaġek rëḳ yö agga ti, om he hevonġin bë ġanġo ġaġek sagi los degwa!” ");
INSERT INTO bzh_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","In yiḳ alam Atens soġek ving alam nyëġ ngwë sën yam denedo Atens lo pin su kwaj nevo nġaa ngwë rë. Gaḳ denedo in bë degenġo ġaġek mewis medebengwënġ jaḳ mu. ");
INSERT INTO bzh_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Lob Paulus nare loḳ kaunsor vu Ḳedu Ares vuheng atov genër bë, “Ham alam Atens! Seraḳ ham nimin bë ham kwamin vo anutu pin meneġin sir nivesa. ");
INSERT INTO bzh_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Lob sa haḳo loḳ nyëġ mehalë ham jepö sën ham netunġ in bë ham najom jaḳ vu sir lo. Lom sa halë jepö ti geham kwevu ġaġek raḳ neggëp nebë ‘Anutu sën hil duġin lo yiyi’. Om anutu sën ham duġin rëḳ ham nejom raḳ meris mu vu yi lo, sën gwëbeng sa bë nanër yi ġaġek vu ham. ");
INSERT INTO bzh_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Anutu sën tunġ dob los nġaa aggagga pin sën denedo loḳ lo, og Anutu saga sën yi Mehöböp sën tu yaġek los dob ala. Rëḳ su nedo loḳ dub sën mehönon denelev raḳ nemaj lo rë. ");
INSERT INTO bzh_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Mehönon su deyoh vu bë dedoḳ vu yi rë, in su neraḳ vu in nġaa ti rë. Gaḳ yö vonġ bemehönon denedo vesaj bemedo malaj netum, gevo nġaa nivesa vesa pin vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Lob vonġ bemehönon pin depum raḳ degwa timu bedeyoh vu nyëġ pin vu dob, geyö tunġ hir buk los den atov pin vorot. ");
INSERT INTO bzh_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nevonġ nġaa nebë saga in bë mehönon pin kwaj bo Anutu gëp ayoj. Genabë desero yi, og rëḳ denatöḳ jaḳ yi, in su nedo ading in hil rë. ");
INSERT INTO bzh_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Gaḳ hil nado vesad gemedo nahee los nehevonġ hil nġaa pin degwa raḳ yi timu. Nebë sën ham alam kwaj böp la denenër bë, ‘Hil degwa yi yönon!’ lo. ");
INSERT INTO bzh_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Om nabë hil degwa Anutu, og hil su kwad bo nabë Anutu ni nebë nġaa sën mehönon denesemu raḳ goor ma seriva ma ġelönġ lo rë. ");
INSERT INTO bzh_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Wirek sën mehönon duġin Anutu lo, og Anutu yö lë ggovek ya rëḳ su kevoh sir ya rë. Rëḳ gwëbeng og nër niwëëk vu mehönon pin vu dob bë degërin sir. ");
INSERT INTO bzh_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Log yö ggooin buk ti raḳ vorot in bë genġo mehönon pin hir ġaġek mebo nyëvewen vu sir niröp. Lob yö ggooin mehöti raḳ in huk sagi, gevonġ yi mekedi raḳ yah vu bedub in bë tato vu hil nabë yiḳ mehö lo sagi.” ");
INSERT INTO bzh_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Alam lo denġo ġaġek bë alam-diiḳsën dekedi jaḳ nah vu bedub, lob vahi denöp raḳ yi, rëḳ vahi denër bë, “Nahub rëḳ ġenanër ġaġek sënë gökin nah vu he behe ġanġo!” ");
INSERT INTO bzh_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Denër ggovek log Paulus vuu sir geto meya. ");
INSERT INTO bzh_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Rëḳ mu alam ti ti deggërin sir bayoj ya timu vu Yesu medetamuin Paulus medeya. Ti arë nebë Dionusius sën kaunsor Ḳedu Ares ti, log avëh ti arë nebë Damaris, galam la ving. ");
INSERT INTO bzh_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Paulus nedo Atens ggovek log ya Korint. ");
INSERT INTO bzh_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Lob töḳ vu Yuda ti arë nebë Akwila geyi nyëġ Pontus. Luho venë Priskila yö söb devuu Itali gedeyam Korint, in alam Rom hir mehö-los-bengö Klaudius yö tii alam Yuda pin bë degevuu Rom gedena. Lob Paulus ya vu luho ");
INSERT INTO bzh_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","in yiḳ lööho hir huk timu, om nedo ving luho bemedo denesemu sël begganġ-yi. ");
INSERT INTO bzh_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Lob Paulus neya Yuda hir dub-supinsën-yi pin menenër vu alam Yuda los alam Grik bë ayoj na timu vu Yesu. ");
INSERT INTO bzh_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Loḳ Silas luho Timoti vu Masedonia medeto, lom mëm Paulus nenër ġaġek yoh vu buk pin vu alam. Nër ġaġek niwëëk vu alam Yuda bë Yesu yiḳ yi Mehö sën Anutu ggooin raḳ in bë geḳo hil nah lo. ");
INSERT INTO bzh_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Rëḳ dekeyëh yi ġaġek gedenër pelë raḳ yi, lob Paulus tetëhin kebus to in yi tob log nër vu sir bë, “Bë ham malamin nama, og yö degwa vu ham, su sa nġaa rë. Gesa naya in sena vu alam-yu-ngwë.” ");
INSERT INTO bzh_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Lob lëëin dub-supinsën-yi geto meya meraḳ ya alam-yu-ngwë ti arë nebë Titius Yustus yi begganġ benedo ving yi. Mehö sënë yi mehö nejom raḳ vu Anutu, lob yi begganġ nedo dus vu Yuda hir dub-supinsën-yi. ");
INSERT INTO bzh_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Yuda hir dub-supinsën-yi ala arë nebë Krispus, lob losho yi alam deggërin sir bayoj ya timu vu Mehöböp. Galam Korint nġahiseḳë denġo Paulus aye medevonġ ving bederipek bël. ");
INSERT INTO bzh_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Log buk ti lob Paulus lë nġaa ti nebë pesepsën geMehöböp nër vu yi bë, “Su ġeġöneng! Gaḳ honġeḳ ġenanër ġaġek ranġah! Su ġenajom honġ ahon! ");
INSERT INTO bzh_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Sa nado ving honġ, om mehöti su rëḳ ngis honġ rë, in alam nġahiseḳë vu nyëġ böp sënë rëḳ denatu salam.” ");
INSERT INTO bzh_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Lom mëm Paulus nedo Korint metateḳin Anutu yi ġaġek vu sir yoh vu ta ti, gekwev nemadvahi-mevidek-ti. ");
INSERT INTO bzh_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Rëḳ nahub geGalio tu alam Akaya hir kiap böp, lob loḳ buk saga alam Yuda denër ġaġek revuh ti gedeḳo Paulus ya ġaġek ggëp begganġ-ġaġek-yi, ");
INSERT INTO bzh_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","gedenër ġaġek tetuhinsën raḳ yi bë, “Mehö sagi netahu alam bë denajom jaḳ vu Anutu og desepa doḳ aggata ngwë medekeyëh he horek.” ");
INSERT INTO bzh_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Lob Paulus bë nanër ġaġek nah, rëḳ Galio nër vu alam Yuda muġin bë, “Ham alam Yuda, nabë ġaġek nipaya soġek ma, nġaa nipaya ti neggëp vu mehö sënë yönon, og yoh vu bë mëm sa ġanġo ham los ham ġaġek. ");
INSERT INTO bzh_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Gaḳ nabë ham yam loḳ tepëḳ in sa in ġaġek meris meris ma, raḳ ham nġo ham degwa la, ma raḳ ham alam Yuda nġo ham horek, og maam nök gëp! Ham nġo semu! Sa niġ lël bë sa su ġanġo ġaġek in nġaa nabë sënë!” ");
INSERT INTO bzh_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Log tii sir to deyah dobnë. ");
INSERT INTO bzh_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nebë saga, lob tum alam Yuda deggërin yah beyö dejom hir dub-supinsën-yi ala ti arë nebë Sostenes ahon, bedeveek yi loḳ begganġ-ġaġek-yi mala. Rëḳ Galio su nër ġaġek ti raḳ sir rë. ");
INSERT INTO bzh_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulus nedo Korint hus ading teka ving rë, loḳ jom Kerisi-yi-alam nemaj geraḳ ya yaġ in na distrik Suria. Lob Priskila luho regga Akwila deya ving yi. Lööho detöḳ ya Senkria, lob mëm Paulus keping yu viis in buk yah verup loḳ buk sën aye ggërin yi neggëp Anutu mala wirek lo bë su rëḳ keping yu rë lo. ");
INSERT INTO bzh_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Log ya deverup Epesus lob vuu luho medenedo nyëġ sënë, geyö ti luḳ ya dub-supinsën-yi ayo menër ġaġek vu alam Yuda. ");
INSERT INTO bzh_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Lob alam saga denër vu yi bë medo buk la geving sir rë, rëḳ su sepa loḳ ayej rë. ");
INSERT INTO bzh_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Gaḳ jom nemaj gesemu ġaġek vu sir bë, “Nabë Anutu su nanërin sa rë, og sëḳ nom berup vu ham buk ngwë gökin.” Log raḳ ya yaġ ti ggëp Epesus meya. ");
INSERT INTO bzh_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Yaġ ya meya nedo Sisarea, lob Paulus raḳ ya Yerusalem bejom Kerisi-yi-alam nemaj, log mëm luḳ meyah Antiok. ");
INSERT INTO bzh_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Paulus ya nedo buk la ggovek, log kedi raḳ vu Antiok meyah beya meyoh vu distrik Galata los Prugia hir nyëġ mahen mahen pin meya nevo ġadu loḳ Kerisi-yi-alam pin ayoj. ");
INSERT INTO bzh_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Lob Yuda ti vu Aleksandria yam nedo Epesus, arë nebë Apolos. Sën yi mehö-vengwënġsën-yi, geyö raḳ Anutu-yi-ḳapiya ni nivesa rot. ");
INSERT INTO bzh_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Detahu yi loḳ Mehöböp yi aggata yö wirek vorot, gaḳ Yesu og su raḳ ni rë. Rëḳ ayo niwëëk in bë nanër bengö ranġah, lob nër niröp rot vu sir. Gaḳ mëm Jon og mëm lë yi buk sën neripek alam raḳ bël lo raḳ mala, ");
INSERT INTO bzh_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","om mëm mehö saga nër los ayo niwëëk ata loḳ alam Yuda hir dub-supinsën-yi. Loḳ mëm Priskila luho Akwila denġo yi lob mëm deḳo yi ya vu luho beluho denër Kerisi yi aggata tato niröp rot vu yi. ");
INSERT INTO bzh_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Lob nahub gApolos kwa vo bë na Akaya, lob Kerisi-yi-alam vu Epesus deyoġek in aye bë gevonġ nabë sënë, lom dekevu ḳapiya vu Yesu yi hur vu Akaya bë degeḳo yi jaḳ. Apolos töḳ ya Akaya lob Anutu vonġ semusemu vu yi beloḳ vu alam sën ayoj neya timu vu Yesu lo niwëëk rot. ");
INSERT INTO bzh_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","In niwëëk rot benër yah bedahun alam Yuda hir ġaġek raḳ alam pin malaj, getato vu sir bë Anutu-yi-ḳapiya nër meneggëp ranġah nebë Yesu yiḳ yi Mehö sën Anutu ggooin raḳ in bë geḳo hil nah lo. ");
INSERT INTO bzh_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos nahën nedo Korint, gePaulus yoh ya distrik Asia* vuheng atov metöḳ ya Epesus, lob töḳ raḳ Kerisi-yi-alam la ggëp sagu. ");
INSERT INTO bzh_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Lob loḳ tepëḳ in sir bë, “Sën ham ayomin ya timu vu Yesu lo, lob maḳ Anon Vabuung loḳ yam ggërin ham ayomin ving-a?” Loḳ denër yah vu bë, “Ma! Mehöti su nër Anon Vabuung ti bengö mehe hanġo rë.” ");
INSERT INTO bzh_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Lob Paulus loḳ tepëḳ yah ggökin bë, “Log deripek ham raḳ bël nebë tena?” Lom denër yah vu bë, “Deripek he nebë sën Jon neripek alam lo.” ");
INSERT INTO bzh_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Lom Paulus nër yah bë, “Wirek Jon nër vu alam bë degërin ayoj bedejipek bël, log nër vu sir ving bë nahub rëḳ ayoj na timu vu mehö sën rëḳ tamuin yi menam lo. Mehö sagi arë nebë Yesu.” ");
INSERT INTO bzh_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Denġo Paulus yi ġaġek saga lob denër meripek sir raḳ Mehöböp Yesu arë. ");
INSERT INTO bzh_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Lob Paulus bë nema raḳ sir, lob pevis bAnon Vabuung loḳ yam ggërin ayoj medenër alam nyëġ ngwë ayej aggagga, bedenenër ġaġek nebë alam-denenër-ġaġek-ranġahsën. ");
INSERT INTO bzh_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Sir yoh vu nemadluho bemaḳ videk luu. ");
INSERT INTO bzh_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Log Paulus loḳ ya alam Yuda hir dub-supinsën-yi betateḳin Anutu-yi-nyëġ degwa ranġah vu sir bejij sir yoh vu kwev löö. ");
INSERT INTO bzh_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Rëḳ alam la ayoj niwëëk rot gesu denevonġ ving rë. Gedenenër ġaġek nipaya raḳ Mehöböp yi aggata raḳ alam malaj. Lob tum Paulus kehe yi in sir geya, lob ḳo alam sën denesepa loḳ yi ġaġek lo raḳ menenër ġaġek vu sir yoh vu buk pin ggëp Turanus yi dub-tateḳinsën-ġaġek-yi. ");
INSERT INTO bzh_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Bevonġ nebë sënë yoh vu ta luu, lob alam Yuda los Grik pin sën denedo Asia* lo denġo Mehöböp yi ġaġek. ");
INSERT INTO bzh_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Anutu vonġ nġaa böp böp loḳ Paulus nema, ");
INSERT INTO bzh_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","lob tum alam deneḳo agesip los tob la sën Paulus navi neraḳ lo beya denetunġ raḳ alam nijraḳsën, lob hir niraḳsën nemaya. Gememö to deneya in sir la ving. ");
INSERT INTO bzh_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Log alam Yuda sën denevenġev raḳ tupaaḳ medeneḳo loḳ nyëġ pin in bë degetii memö na in alam gedegeḳo monë jaḳ lo la denër Mehöböp Yesu arë gedeneseggi in bë degetii memö na in alam. Bedenenër bë, “Ham gwevonġ noh vu sayeġ in sa nanër vu honġ raḳ Yesu arë sën Paulus nër ġaġek raḳ yi lo!” ");
INSERT INTO bzh_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Lob alam Yuda hir alam-deneḳo-seriveng hir ggev ti arë nebë Siva, lob nalu lo nemadvahi-bevidek-luu denevonġ huk nebë sënë. ");
INSERT INTO bzh_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Rëḳ memö nër yah vu sir bë, “Yesu saga seraḳ ni. Geseraḳ Paulus ni ving. Gaḳ mu ham re lo?” ");
INSERT INTO bzh_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Lob mehö sën memö negwanġ ya yi lo, pesönġ ggök sir gesis sir pin bekweeḳ hej tob bedeḳo nipaya rot, bedepiv ḳöḳ medeveya meto deyah dobnë los ahëj töḳsën. ");
INSERT INTO bzh_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ggovek rëḳ alam Yuda los Grik pin sën denedo Epesus deraḳ nġaa sënë ni, lob sir pin deggöneng böpata gedeḳo Mehöböp Yesu arë raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Log alam sën ayoj neya timu vu Yesu lo vahi deyam ving medenër sën denetunġ bu raḳ nġaa pin lo ranġah gedevuu ya. ");
INSERT INTO bzh_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Galam nġahi sën denevonġ parahek los naböö lu nġaa lo desupin hir ḳapiya parahek los naböö yi gedevesi raḳ ya nengwah raḳ alam pin malaj. Lob detevin ḳapiya sënë yi monë sën denebaġo raḳ lo, lob yoh vu monë ġahis 50,000. ");
INSERT INTO bzh_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Lob Mehöböp yi huk niwëëk raḳ nebë sënë genetato yi niwëëk bë yi böpata bekesuu. ");
INSERT INTO bzh_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Paulus lë nġaa pin saga ggovek, log kwa vo bë na distrik Masedonia los Akaya loḳ mëm nah mena Yerusalem. Nër bë, “Sena sagu govek rë, loḳ sena ġalë Rom geving.” ");
INSERT INTO bzh_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Lob vonġ yi mehö luu sën deneloḳ vu yi lo demuġin medeya distrik Masedonia, Timoti lu Erastus. GePaulus yö ti nahën nedo ggëp distrik Asia*. ");
INSERT INTO bzh_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Lob loḳ buk saga, alam demehoo sir in Yesu yi aggata gebë dengis sir raḳ degwa nebë sënë: ");
INSERT INTO bzh_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mehöti arë nebë Demetrius nedo belosho yi hur nġahiseḳë denesemu nġaa raḳ seriva. Denesemu anutu-avëh-kuungsën Artemis yi dub ḳenu mahen mahen raḳ seriva in alam debaġo. ");
INSERT INTO bzh_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Lob Demetrius sënë supin yi hur pin ving alam sën yiḳ denevonġ huk nebë agi genër vu sir bë, “Alam-e! Ham nġo raḳ ni bë hil nehaḳo monë nivesa raḳ hil huk seriva sënë. ");
INSERT INTO bzh_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Lob ham raḳ ni ving nebë mehö sën Paulus lo loḳ alam nġahiseḳë rot ahëj, beggërin ayoj raḳ yi ġaġek sën nenër nebë anutu pin sën hil nesemu raḳ nemad lo, saga og su anutu anon rë. Lob su vonġ nebë sënë vu hil Epesus mu rë, gaḳ vonġ yoh vu distrik Asia* pin ving. ");
INSERT INTO bzh_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Lob Paulus yi ġaġek sagi su rëḳ gevonġ balam degeruu demij vu hil huk-monë-yi sënë mu rë. Gaḳ rëḳ dahun anutu-avëh böp Artemis yi dub vabuung sënë na geving. Gwëbeng alam distrik Asia* los alam vu dob pin deneḳo arë raḳ, rëḳ mu nabë Paulus medo nanër ġaġek nabë saga, og rëḳ hil anutu-avëh böpata los niwëëk sënë rëḳ natu nġaa meris barë nama na.” ");
INSERT INTO bzh_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Denġo ġaġek sënë lob ahëj sengën böpata rot gedetahi rot bë, “Hil Artemis vu Epesus yi böpata rot!” ");
INSERT INTO bzh_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Detahi böpata rot nebë saga galam pin vu nyëġ saga dereseeh rur böpata mekedi deya. Dekedi loḳ ti medeseröġ medeya begganġ-supinsën-yi, lob dejom Gayus luho Aristarkus ahon mededadii luho ya ving sir. Luho vu distrik Masedonia rëḳ luho deyam ving Paulus. ");
INSERT INTO bzh_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulus vonġin bë begi na sir vuheng benanër ġaġek vu sir, rëḳ Yesu yi hur deggërin yi. ");
INSERT INTO bzh_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Log alam distrik Asia* hir ggev böp la, og losho Paulus yö deneraḳ nij, om devonġ ġaġek ya vu yi ving bedenër niwëëk vu yi bë su doḳ na begganġ-supinsën-yi. ");
INSERT INTO bzh_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lob alam nġahiseḳë saga deneketul loḳ rot, in sir vahi denetahi ġaġek agga ti gevahi denetahi agga ngwë, lob alam vahi su deraḳ ġaġek sën desup sir in lo degwa ni rë. ");
INSERT INTO bzh_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Lob alam Yuda derot Aleksander ya nare malaj galam vahi denër bë mëm yö neraḳ ġaġek degwa ni. Lom Aleksander varah nema raḳ gebë nanër ġaġek tato vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Rëḳ ma gederaḳ ni bë yi Yuda ti, lob sir pin ayej loḳ ti gedenetahi rot bë, “Hil Artemis vu Epesus yi böpata rot!” Detahi nebë saga yoh vu nyëġ mala luu. ");
INSERT INTO bzh_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Medo denevonġ medenevonġ, loḳ mëm mehö sën tu nyëġ böp Epesus hir ggev benekevu hir ġaġek lu nġaa lo vonġ bededuj ma, log nër vu sir bë, “Ham alam Epesus! Mehö re rëḳ duġin nyëġ böp Epesus nabë neġin avëh böp Artemis yi dub los ḳenu ġelönġ sën luḳ yam vu yaġek lo? ");
INSERT INTO bzh_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mehöti su yoh vu bë keyëh ġaġek sagi rë. Om ham ayemin nama, geham su pevis megwevonġ nġaa ti. ");
INSERT INTO bzh_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ham nġo ḳo mehö luu sënë yam, rëḳ mu luho su deggodeḳ dub yi nġaa ti rë. Geluho su denër pelësën raḳ hil anutu-avëh rë, gema! ");
INSERT INTO bzh_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Om nabë Demetrius losho yi hur hir ġaġek ti neggëp vu mehöti, og buk-ġaġek-yi neggëp. Gekiap böp nedo. Om yö rëḳ genġo hir ġaġek. ");
INSERT INTO bzh_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Genabë ham ġaġek la nahën neggëp, og ham semu doḳ supinsën yi buk niröp. ");
INSERT INTO bzh_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Rëḳ mu alam Rom rëḳ denanër hil nabë hil hevonġ beġö verup gwëbeng gedegwa ma! Genabë dedoḳ tepëḳ in hil in supinsën nipaya sënë degwa, og ġaġek ti su neggëp in bë hil rëḳ nanër doḳ nah vu sir rë!” ");
INSERT INTO bzh_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Mehö sën nekevu ġaġek lu nġaa lo nër nebë sënë, log kevoh supinsën ya bedeketëḳin sir. ");
INSERT INTO bzh_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ġaġek sënë ahë yes raḳ ggovek, log Paulus supin Yesu yi hur lo deyam vu yi, menër ġaġek vahi vu sir in bë bo niwëëk doḳ ayoj. Log jom nemaj geya raḳ beya distrik Masedonia. ");
INSERT INTO bzh_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ya meyoh vu nyëġ pin menër ġaġek nġahiseḳë in ġadu Kerisi-yi-alam beya verup dob Grik, ");
INSERT INTO bzh_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","lom nedo sagu yoh vu kwev löö ggovek, log bë jaḳ yaġ mena Suria. Rëḳ nġo bë alam Yuda dejoo ġaġek bë dengis yi menadiiḳ, lom sepa vaha meyoh distrik Masedonia beyah. ");
INSERT INTO bzh_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Yah log Purus nalu Sopater vu Beroya, gAristarkus lu MonSekudus vu Tesalonika, geGayus vu Derbe, geTimoti, geTukikus luho Tropimus vu distrik Asia*, bedeneya ving yi. ");
INSERT INTO bzh_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Alam sënë demuġin meya deneġin alu Paulus vu Troas. ");
INSERT INTO bzh_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Log alu halë Buk-ggöksën-yi* ggovek log alu hevuu Pilipi galu araḳ yaġ maya. Alu aya buk nemadvahi loḳ mëm atöḳ ya vu sir ggëp Troas behe nado soda ti. ");
INSERT INTO bzh_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lob Buk-sewahsën-yi* sehuksën, lob he supin he in bë aġa nos los Pasa. Lob Paulus nër ġaġek vu alam, in monbuk og bë na jaḳ. Lob nër ġaġek hus ading rot vu sir bebuk vuheng raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Lob detaggi loḳ ram nġahiseḳë benare loḳ begganġ ayo vavunë sën he nasupin he loḳ lo. ");
INSERT INTO bzh_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Lob maluh maġëm ti arë nebë Etikus nedo raḳ veluung avi ayööng yi, gePaulus nenër ġaġek hus ading rot vu sir. Lob Etikus mala neggëp rot, lob ggëp yiing lom vës vu begganġ ayo ti sën tëb netu löö vu vavunë lo, beyam dob. Lob deluḳ meya devër yi raḳ rëḳ diiḳ. ");
INSERT INTO bzh_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Loḳ Paulus luḳ meya tabuu mehö maġëm saga genër bë, “Ham su newamin jaḳ, in anon nahën nedo loḳ yi.” ");
INSERT INTO bzh_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Lob Paulus raḳ yah vavunë belosho alam saga debu brët medegga. Ggovek loḳ nër ġaġek hus adingseḳë vu sir rot benyëġ heng, log ya raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Gedeḳo maluh maġëm sënë medeya. Rëḳ su diiḳ rë genedo vesa, lob kwaj vesa raḳ yah. ");
INSERT INTO bzh_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paulus nër muġin bë noh dob mena geto Asos, lob mëm he ġaḳo yi jaḳ nom yaġ vu sagu. Lob he raḳ yaġ bamuġin baya neheġin yi ggëp Asos. ");
INSERT INTO bzh_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Loḳ Paulus yök to metöḳ vu he, lob he haḳo yi raḳ yom yaġ mehe los aya Mitulene. ");
INSERT INTO bzh_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","He kesuu Mitulene gaya, lob he hëp benyëġ heng, gehe ya verup dus vu Kios. Log he ya bebuk loḳ yah geheng, lob mëm he ya matöḳ ya Samos. Loḳ he hëp yah beheng to, log mëm he ya matöḳ ya Miletus. ");
INSERT INTO bzh_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulus kwa vo vorot bë kesuu Epesus gena in nilël bë su medo distrik Asia* panġsën. Gaḳ bë pevis in kwa vo bë gelë Buk-supinsën-yi sën denenër bë Pentikos lo, gëp Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","He töḳ ya Miletus, log Paulus vonġ ġaġek ya Epesus in Kerisi-yi-alam hir ggev lo bë denam vu yi. ");
INSERT INTO bzh_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Deverup vu yi lob nër vu sir bë, “Ham nġo raḳ nġaa pin sën sa nehevonġ wirek loḳ sën sa nahën neverup mewis ggëp distrik Asia* lo ni. ");
INSERT INTO bzh_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ham raḳ ni bë alam Yuda dejoo ġaġek vunsën beron nġahiseḳë in bë dengis sa, lob saga vo maggin vu sa panġsën. Rëḳ sa su haḳo sa raḳ rë, gaḳ sa malaġ ruḳ keseh in Mehöböp yi huk gesa medo nehevonġ. ");
INSERT INTO bzh_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Sa su vun ġaġek nivesa ti rë, gaḳ senër ranġah behevonġ nġaa pin in bë doḳ vu ham. Gesenër ranġah vu ham loḳ ham supinsën, geloḳ ham begganġ ayo ving. Besagaḳ ham raḳ ni. ");
INSERT INTO bzh_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Senër ġaġek niwëëk raḳ buk vu alam Yuda, gevu alam Grik in degërin ayoj nah vu Anutu, gayoj na timu vu hil Mehöböp Yesu. ");
INSERT INTO bzh_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Om ham gwenġo rë! Anon Vabuung negejiiin sa bë sena Yerusalem. Lob maḳ va rëḳ natöḳ vu sa vu sagu? Sa duġin. ");
INSERT INTO bzh_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Rëḳ Anon Vabuung tateḳin vu sa yoh vu nyëġ pin sën seya lo meseraḳ ni bë sëḳ natöḳ vu ḳarabus genġaa maggin nġahiseḳë rëḳ deġinengin sa. ");
INSERT INTO bzh_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Rëḳ sa su kwaġ nevo naviġ sënë bë nġaa anon rë. Sa su niġ wëëk ata bë najom ahon rë, gaḳ sa bë sepa doḳ aggata sën sa nesepa loḳ lo, benama na rë. Sa bë semu huk sën sa haḳo vu Mehöböp Yesu lo na. Huk sën sa nanër Bengö Nivesa jaḳ Mehöböp yi semusemu lo. ");
INSERT INTO bzh_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Om ham gwenġo rë! Wirek seyök vu ham besa haḳo loḳ menanër ġaġek raḳ Anutu-yi-nyëġ. Rëḳ gwëbeng seraḳ ni bë ham su rëḳ gwelë sa malaġ gökin nah rë. ");
INSERT INTO bzh_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nebë saga, om gwëbeng sa bë nanër vu ham nabë: Nabë ham ti nadiiḳ bemala nama, og su degwa vu sa rë, ");
INSERT INTO bzh_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","in sa su höneng rë, gaḳ sa tateḳin Anutu kwa pin los dahis vu ham. ");
INSERT INTO bzh_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Om ham gweġin ham nivesa, gegweġin Kerisi-yi-alam vahi geving, in Anon Vabuung ggooin ham raḳ tu alaj. Ham gweġin ham nivesa beham gweġin Mehöböp yi alam sën yö baġo sir raḳ niḳöḳ lo geving. ");
INSERT INTO bzh_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","In seraḳ ni bë sëḳ ġevuu ham gesena, log rëḳ alam ġaġek kuungsën la nabë anöö bemën nij paya rëḳ desarömin sir geving ham, lob degevonġ paya vu Kerisi-yi-alam. ");
INSERT INTO bzh_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Geham ggev la rëḳ dekedi medenanër ġaġek kuungsën la in dedadii Kerisi-yi-alam nah detamuin sir. ");
INSERT INTO bzh_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Om ham gweġin ham noh vu buk. Ham kwamin bo nabë sa tato aggata niröp vu ham buk los ranġah yoh vu ta löö. Gesa nasu in ham pin ti ti. ");
INSERT INTO bzh_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Lob gwëbeng sa hetunġ ham loḳ ya Anutu nema, geloḳ yi ġaġek semusemu ayo, lob saga yoh vu bë bo niwëëk vu ham gemëm ham rëḳ gweḳo nġaa nivesa vesa pin sën Anutu rëḳ gevonġ vu alam pin sën yö ggooin sir raḳ tu yi alam lo. ");
INSERT INTO bzh_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Sa su malaġ anon in mehöti yi seriva ma goor ma tob lu nġaa ti rë. ");
INSERT INTO bzh_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Gaḳ ham nġo raḳ ni bë sa nemaġ sënë yö jom huk beloḳ vu sa in nġaa sën sa naraḳ vu in lo. Geneloḳ vu alam sën denesepa sa lo ving. ");
INSERT INTO bzh_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Sa nehevonġ huk nebë sënë in tato vu ham nabë hil ġevonġ huk niwëëk in hil adoḳ vu alam seḳëj masën. Gehil kwad bo ġaġek sën Mehöböp Yesu yö nër lo nebë, ‘Mehöti sën nabë bo nġaa vu mehö ngwë, gesu kwa bo nabë rëḳ geḳo nyëvewen doḳ nah rë lo, og kwa vesa rot kesuu kwa-vesasën sën kwa vesa in nġaa sën mehö ngwë denevo vu yi lo.’” ");
INSERT INTO bzh_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulus nër ġaġek saga ggovek, log yun lus gejom raḳ ving alam ggev pin. ");
INSERT INTO bzh_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Lob sir pin desu rot gedekebi Paulus ahon gedemul* yi in bë rëḳ gevuu sir gena. ");
INSERT INTO bzh_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ayoj maggin rot in Paulus nër bë su rëḳ degelë yi gök nahin rë. Log mëm deḳo yi meya detunġ raḳ ya yaġ. ");
INSERT INTO bzh_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","He hevuu sir gehe raḳ ya yaġ maya, baya heto sesor niröp maya Kos. Geheng to lob he ya rot batöḳ ya Rodos. Lob he kesuu Rodos gehe ya verup Patara. ");
INSERT INTO bzh_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Lob he töḳ raḳ yaġ ti vu saga geneya los Ponisia. Lob he raḳ ya baya. ");
INSERT INTO bzh_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","He ya heto halë Kupros neggëp ya los he nemamin ḳëj, lob he kesuu gaya rot baya neto nyëġ böp Suria maloḳ ya Ture. In yaġ bë getunġ ḳupeḳ duḳ gëp nyëġ sagu. ");
INSERT INTO bzh_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Lob he ya matöḳ raḳ Kerisi-yi-alam la vu sagu, lob he nado soda ti ving sir. Loḳ Anon Vabuung vër kwaj lob denër vu Paulus bë su na Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Rëḳ ma gehe buk ggovek ya, lob he hevuu nyëġ sagu gaya, lob Kerisi-yi-alam pin ving hir avëh los hur mahen deli he vu begganġ ya loo nenga. Lob he yun lupin ggëp loo nenga genajom raḳ. ");
INSERT INTO bzh_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Log mëm he jom nemamin, log he raḳ ya yaġ baya gedeyah bej. ");
INSERT INTO bzh_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","He raḳ yaġ bekesuu Ture gaya rot batöḳ ya Petolemais. Lob he jom Kerisi-yi-alam lo nemaj gehe nado buk ti ving sir. ");
INSERT INTO bzh_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lob monbuk lob he vu Petolemais batöḳ ya Sisarea, behe loḳ ya sinarë Pilip yi begganġ benado ving yi. Alam nemadvahi-bevidek-luu sën deloḳ vu sinarë nyëdahis in nos vu Yerusalem wirek lo ti yi. ");
INSERT INTO bzh_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Lob nalu avëh avö lubeluu sën maluh su dehov sir rë lo, lob sir avëh-denenër-ġaġek-ranġahsën. ");
INSERT INTO bzh_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","He nado Sisarea buk la ving rot, lob mehö-nenër-ġaġek-ranġahsën ti arë nebë Agabus vu distrik Yudea meluḳ meyam Sisarea. ");
INSERT INTO bzh_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Yam in bë gelë he, lom ḳo Paulus yi ḳabi beduu yö vaha los nema raḳ, log nër bë, “Anon Vabuung nër bë, ‘Alam Yuda vu Yerusalem rëḳ denaduu ḳabi sënë ala nabë sënë, log rëḳ debo yi doḳ na alam-yu-ngwë nemaj.’” ");
INSERT INTO bzh_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","He hanġo nebë sënë, lob he los alam pin sën he nado loḳ begganġ ti saga lo anër niwëëk vu Paulus bë su jaḳ mena Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Loḳ Paulus nër ġaġek yom vu he bë, “Nebë va sën ham nesu benevonġ mesayoġ maggin neraḳ-ë? Seyoh vu bë sena ḳarabus. Gaḳ nabë sa nadiiḳ in Mehöböp arë geving gëp Yerusalem, og yiḳ yoh vu ving!” ");
INSERT INTO bzh_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Lom he su ayoh vu bë rëḳ aġërin kwa rë, om sën he ayemin ma, gehe nër bë, “Om maam anon jaḳ noh vu Anutu kwa!” ");
INSERT INTO bzh_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ggovek log he semu nġaa nġaa loḳ, garaḳ maya Yerusalem. ");
INSERT INTO bzh_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Lob Kerisi-yi-alam la vu Sisarea desepa he bedeli he ya vu mehö sën he bë ana medo geving yi lo. Yi Kupros ti barë nebë Menason, sën yö vonġ ving wirek nyëmuġinsën lo. ");
INSERT INTO bzh_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","He töḳ ya Yerusalem, lob Kerisi-yi-alam deḳo he raḳ los kwaj vesa. ");
INSERT INTO bzh_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Gemonbuk lob Paulus ya ving he, behe ya halë Yakobus. Lob alam ggev pin denedo ving yi. ");
INSERT INTO bzh_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulus jom nemaj ggovek, log turin huk pin sën Anutu ġadu yi bevonġ vu alam-yu-ngwë lo los dahis vu sir. ");
INSERT INTO bzh_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Denġo lob deḳo Anutu arë raḳ, loḳ tum denër vu yi bë, “Ari! Ġeraḳ ni bë alam Yuda raḳ neggëp mehömehö detu Kerisi-yi-alam ggovek ya, lom denesepa loḳ horek sën Moses ḳo agi niwëëk ata. ");
INSERT INTO bzh_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Rëḳ denenġo bë ġenenër vu alam Yuda sën denedo ving alam-yu-ngwë lo bë degevuu Moses yi horek na, geġenenër bë su degerah* naluj navij, gesu desepa doḳ nġaa wirek hen gökin. ");
INSERT INTO bzh_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Om hil rëḳ ġevonġ nabë va? Yönon rot, rëḳ degenġo ġaġek nabë ġeyam ggovek ya. ");
INSERT INTO bzh_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Om ġepevis begwevonġ nġaa noh vu sën he bë nanër vu honġ agi. He alam lubeluu denër ġaġek ti venuh neggëp Anutu mala. ");
INSERT INTO bzh_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Om gweḳo alam saga, beġesepa doḳ horek pin sën gevonġ beham nimin veseek jaḳ gëp Anutu mala lo, gegwetunġ monë natu seriveng in sir gedekeping yuj viis na. Gwevonġ nabë sënë, og alam pin rëḳ dejaḳ ni nabë ġaġek sën denenër raḳ honġ lo, og anon ma. Gemëm yö rëḳ dejaḳ ni nabë ġenesepa loḳ Moses yi horek ving. ");
INSERT INTO bzh_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Gaḳ alam-yu-ngwë sën detu Kerisi-yi-alam lo, og hil ḳevu ḳapiya ya vu sir ggovek ya banër ġaġek sën hil ajoo wirek lo vu sir bë: Degeġin sir nivesa, gesu dega reggu sën alam denesis in bë degetunġ seriveng vu anutu-kuungsën lo, gesu dega ḳöḳ, gesu dega reggu sën alam deneseyu kwaj medenediiḳ lo, gesu degevonġ baggëb.” ");
INSERT INTO bzh_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nebë saga, lob Paulus ḳo alam saga monbuk belosho desepa loḳ horek pin sën gevonġ benij veseek jaḳ gëp Anutu mala lo. Log loḳ ya dub-vabuung-böp ving benër buk sën buk-niveseeksën-yi govek na lo tato vu alam-deneḳo-seriveng lo. Buk sën degetunġ seriveng balam-deneḳo-seriveng debesi jaḳ jepö vu sir lo. ");
INSERT INTO bzh_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Buk-niveseeksën-yi nemadvahi-bevidek-luu saga dus raḳ bë nama na, loḳ alam Yuda la vu distrik Asia* delë Paulus genedo loḳ dub-vabuung-böp ayo, lob deloḳ alam pin ahëj bahëj sengën raḳ. Lob dekedi dejom Paulus ahon ");
INSERT INTO bzh_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","gedetahi bë, “Ham alam Israel, ham doḳ vu he! In mehö sagi nenër vu alam yoh vu nyëġ pin bë dedahun hil hed alam los hil horek gedub-vabuung-böp sagi geving. Beḳo alam Grik la loḳ yam dub-vabuung-böp sënë ving bevonġ paya vu nyëġ vabuung sënë!” ");
INSERT INTO bzh_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Denër nebë sënë in delë Tropimas vu nyëġ böp Epesus genedo Yerusalem ving Paulus, lob dekuung bë Paulus ḳo yi loḳ ya dub ayo ving. ");
INSERT INTO bzh_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nebë saga, lob alam Yerusalem pin ahëj sengën raḳ, lob deseröġ beya dejom Paulus ahon, gededadii to meyah in dub-vabuung-böp. Gedepevis bedevehii dub yi repinġ pin. ");
INSERT INTO bzh_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Devonġin bë dengis Paulus menadiiḳ, rëḳ bengö ya verup vu Rom hir alam-beġö-yi losho alaj bë beġö verup beyoh vu Yerusalem pin. ");
INSERT INTO bzh_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Lob pevis beḳo alam-beġö-yi la, geyi kapten, bedeseröġ medeluḳ medeya vu sir. Yuda delë alam-beġö-yi losho alaj, lob devuu Paulus gesu desis rë. ");
INSERT INTO bzh_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Lob alam-beġö-yi alaj ya dus bejom Paulus ahon genër vu yi alam-beġö-yi bededuu ahon raḳ sëng luu. Log loḳ tepëḳ in sir bë, “Mehö re sënë? Vonġ va paya?” ");
INSERT INTO bzh_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Rëḳ alam yu böpata, om detahi ġaġek ya niḳelap bededun böp rot. Lob alam-beġö-yi alaj su yoh vu bë genġo ġaġek degwa nivesa rë, lom nër vu alam-beġö-yi bë degeḳo Paulus doḳ na hir ḳatum ayo. ");
INSERT INTO bzh_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Lob Paulus ya verup dus vu ḳatum sënë yi lël lob alam nij wëëk rot bë dengis yi menadiiḳ, lob alam-beġö-yi su deyoh vu bë degërin yi nivesa rë, lom devaḳu yi ya vavunë. ");
INSERT INTO bzh_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Galam pin denesepa sir bedetahi bë, “Ġengis menadiiḳ!” ");
INSERT INTO bzh_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Alam-beġö-yi bë degeḳo Paulus doḳ na hir ḳatum ayo, rëḳ Paulus loḳ tepëḳ vu alaj bë, “Yoh vu bë sa nanër ġaġek ti vu honġ rë?” Loḳ alam-beġö-yi alaj lëk beloḳ tepëḳ yah bë, “Ġeraḳ Grik ayej ni? ");
INSERT INTO bzh_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Sa hekuung bë honġ Ejep ti sën ġesis beġö vu gavman vu buk agu geġeḳo alam nij paya los beġö hodeḳ 4,000 meġeya nyëġ-yumeris lo!” ");
INSERT INTO bzh_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Rëḳ Paulus nër yah vu bë, “O saḳ Yuda, gataġ ḳo sa ggëp Tarsus vu distrik Kilisia. Sa nyëġ los bengö. Om ġengoġek gesa nanër ġaġek dus ti vu alam sënë rë.” ");
INSERT INTO bzh_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Lob alam-beġö-yi alaj yoġekin. Lob Paulus raḳ ya nare lël gevarah nema raḳ. Lob alam pin ayej ma, gemëm nër ġaġek ya vu sir loḳ Hibru ayej. ");
INSERT INTO bzh_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Nër bë, “Arig lo amaġ lo, ham gwenġo rë! Sa bë tateḳin sa ġaġek degwa ranġah vu ham.” ");
INSERT INTO bzh_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Denġo bë Paulus nër vu sir loḳ Hibru ayej, lob ayej ma rot gesu deggee rë. Log mëm Paulus nër bë, ");
INSERT INTO bzh_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Sa Yuda ti. Sataġ ḳo sa ggëp Tarsus vu distrik Kilisia, rëḳ serig ggëp nyëġ böp Yerusalem sënë geGamaliel ḳo sa luḳ yi dub betahu sa niröp loḳ hil ḳenud lo hir horek pin. Gesa niġ wëëk mesayoġ ya vu Anutu timu nebë sën gwëbeng ham nimin wëëk menetamuin yi agi. ");
INSERT INTO bzh_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Wirek sevo maggin vu alam sën denesepa loḳ Yesu yi aggata lo, lob sa bë ngis sir medenadiiḳ. Lob seduu maluh los avëh ving raḳ sëng beya denedo begganġ ḳarabus. ");
INSERT INTO bzh_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Alam-deneḳo-seriveng hir ggev böp losho kaunsor hir alam teta pin deyoh vu bë rëḳ denanër ġaġek saga ranġah vu ham, in dekevu ḳapiya vu arij lo vu nyëġ böp Damaskus besa haḳo beya in bë sa naduu alam vu sagu beġaḳo nam Yerusalem bedegeḳo vanë. ");
INSERT INTO bzh_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Lob sa nahën nayök aggata beseya verup dus raḳ nyëġ böp Damaskus, lob hes vuheng raḳ. Loḳ pevis beranġah ti vër böpata nebë davës vu yaġek beyam jëh raḳ sa. ");
INSERT INTO bzh_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Lob sevës beya nahëp dob, log sa hanġo ġaġek ti yam vu sa bë, ‘Saulus, ġëvonġ vanë vu sa in va?’ ");
INSERT INTO bzh_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Rëḳ seloḳ tepëḳ yah bë, ‘Mehöböp-a? Honġ re?’ Loḳ nër yom bë, ‘Sa Yesu Nasaret sën ġenevonġ vanë vu sa lo!’ ");
INSERT INTO bzh_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Galam sën deneya ving sa lo delë ranġah sënë ving, rëḳ su denġo mehö sënë aye rë. ");
INSERT INTO bzh_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Lob senër bë, ‘Om Mehöböp, sëḳ ġevonġ nabë va?’ Loḳ Mehöböp nër yom vu sa bë, ‘Kwedi jaḳ meġena Damaskus. Lob vu nyëġ sagu rëḳ mehöti nanër huk pin sën sehooin raḳ vu honġ lo tato vu honġ.’ ");
INSERT INTO bzh_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ranġah sagi gelu sa malaġ, lob sa su yoh vu bë ġalë nyëġ lu nġaa rë, om alam sën deya ving sa lo dejom loḳ sa nemaġ bedeli sa ya Damaskus. ");
INSERT INTO bzh_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Lob mehöti nedo barë nebë Ananias. Yi mehö nesepa loḳ Moses yi horek anon rot, lom alam Yuda pin sën denedo Damaskus lo deneḳo yi raḳ bë yi mehö nivesa. ");
INSERT INTO bzh_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Mehö saga yam vu sa benër bë, ‘Arig Saulus! Malam natum nah!’ Lob pevis besa malaġ tum ggökin yah besa halë yi. ");
INSERT INTO bzh_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Log nër ving bë, ‘Hil ḳenud hir Mehöböp yö ggooin honġ raḳ in bë gejaḳ kwa ni. Ġelë Mehö yohvu sënë ggovek ya, geġenġo ġaġek sën raḳ verup avi lo. ");
INSERT INTO bzh_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","In rëḳ ġenanër yi ġaġek ranġah. Ġenanër nġaa sën ġelë los ġenġo lo vu mehönon pin. ");
INSERT INTO bzh_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ma ġeneġin va rot-a? Kwedi jaḳ beġejipek bël. Ġenanër Yesu arë gerëḳ jipek honġ nġaa nipaya na.’” ");
INSERT INTO bzh_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Seyom heto Yerusalem, gebuk ti lob sa medo najom raḳ loḳ dub-vabuung-böp, lob sa ḳenug ya nebë pesepsën ");
INSERT INTO bzh_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","besa halë Mehöböp. Lob nër vu sa bë, ‘Ġepevis! Gwevuu Yerusalem geġena! Nabë ġenanër sa ġaġek vu alam sënë og su rëḳ degenġo bedegevonġ geving rë!’ ");
INSERT INTO bzh_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Lob senër bë, ‘Mehöböp, yö deraḳ ni bë wirek seyoh vu dub-supinsën-yi pin beseduu alam sën ayoj neya timu vu honġ lo, gesa neheveek sir. ");
INSERT INTO bzh_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Gewirek desis Stepan sën nenër honġ ġaġek ranġah lo mediiḳ, lob sayoġ nivesa in saga gesa vare nemalaġin alam sën denetengwa yi lo hir röpröp.’ ");
INSERT INTO bzh_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Rëḳ nër vu sa bë, ‘Ġena! Rëḳ sa ġevonġ honġ na aggata ading beġena vu alam-yu-ngwë.’” ");
INSERT INTO bzh_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Alam Yuda vare denenġo Paulus yi ġaġek rot beya verup loḳ ġaġek vewen sagi loḳ detahi niwëëk bë, “Ham jaḳ na genadiiḳ! Mehö nebë saga su medo vesa!” ");
INSERT INTO bzh_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Lom denetahi ya niḳelap gedekah hir röpröp medenetetëhin, gedeneraa kebus raḳ medenetë ya vavunë. ");
INSERT INTO bzh_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nebë saga lob alam-beġö-yi alaj nër bedeḳo Paulus loḳ ya hir ḳatum ayo. Genër vu sir ving bë debeek yi in denatöḳ jaḳ degwa sën alam Yuda denetahi ġaġek ya niḳelap raḳ yi lo. ");
INSERT INTO bzh_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Lom deduu Paulus ya vetii ḳele ggovek in bë debeek, rëḳ alam-beġö-yi hir kapten nare dus vu Paulus, lob Paulus nër vu yi bë, “Ham horek nër bë yoh vu bë ham beek Rom ti geham su gwenġo yi ġaġek namuġin rë?” ");
INSERT INTO bzh_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Lob kapten nġo ġaġek sënë, lob ya menër vu alam-beġö-yi alaj bë, “Ġevonġin bë gwevonġ nabë va? Mehö saga lo yi Rom ti!” ");
INSERT INTO bzh_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Lob ala yom vu Paulus meloḳ tepëḳ vu yi bë, “Ġenanër vu sa nabë honġ alam Rom ti ma ma?” Rëḳ Paulus yoġek bë, “Ëë-ë, sa Rom ti!” ");
INSERT INTO bzh_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Loḳ alam-beġö-yi alaj nër bë, “Sa hetë monë nġahiseḳë in sa vu gavman Rom gesetu Rom ti!” Rëḳ Paulus nër yah bë, “Gaḳ sa og amaġ Rom, om ataġ ḳo sa besa Rom.” ");
INSERT INTO bzh_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Lob alam sën bë debeek yi lo pevis bedelëëin yi, galaj newa raḳ rot in kwa vo bë duu Rom ti raḳ sëng. ");
INSERT INTO bzh_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Rëḳ vonġin bë jaḳ nġaa sën alam Yuda denër bë Paulus vonġ paya lo ni niröp, om ḳo yi vër monbuk gevonġ ġaġek ya vu alam-deneḳo-seriveng hir ggev los kaunsor pin bedesupin sir yam, log ḳo Paulus luḳ ya nare malaj. ");
INSERT INTO bzh_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Lob Paulus gët kaunsor genër bë, “Arig lo, setu Anutu yi hur ti besa medo mekwaġ nevo bë sa nehevonġ yoh vu yi ġaġek rot beverup gwëbeng!” ");
INSERT INTO bzh_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nër nebë sënë, lob alam-deneḳo-seriveng hir ggev böp Ananias nër vu yi alam sën denare dus vu yi lo bedepetap avi. ");
INSERT INTO bzh_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Rëḳ Paulus nër yah vu yi bë, “Honġ ġanġ nipaya rëḳ heveḳ nivesa raḳ nedo navi vavunë mu! Anutu rëḳ petap honġ! Ġenedo sagi in bë gwenġo sa ġaġek meġeseggi jaḳ hil horek, rëḳ mu nġo kweyëh horek sagi in ġenër bedesis sa!” ");
INSERT INTO bzh_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Lob alam sën denare dus vu Paulus lo denër bë, “Su ġenanër ġaġek nipaya jaḳ Anutu yi ggev böp sënë!” ");
INSERT INTO bzh_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Rëḳ Paulus nër yah bë, “Arig lo, sa su raḳ ni bë yi alam-deneḳo-seriveng hir ggev böp rë. Gaḳ Anutu nër meneggëp loḳ yi ḳapiya bë: Su ġenanër ġaġek nipaya jaḳ ala sën neġin honġ alam lo!” ");
INSERT INTO bzh_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Lob Paulus raḳ ni bë alam teta Sadukai* la geParisai* la medenedo, lom tahi ya vu kaunsor bë, “Arig lo! Sa og sa Parisai* soġek rot! Sa nehevonġ ving bë alam-diiḳsën rëḳ dekedi jaḳ gökin, lob yiḳ raḳ degwa saga sën gwëbeng devonġ ġaġek vu sa.” ");
INSERT INTO bzh_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nër ġaġek saga lob ġaġek ahë sengën yi verup pevis loḳ Parisai* losho Sadukai* vuheng atov, lob devasuh sir. ");
INSERT INTO bzh_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","In alam Sadukai* denenër bë mehönon su deyoh vu bë rëḳ dekedi jaḳ nah gëp bedub rë, gangër ma, genġaahur ma. Gaḳ alam Parisai* devonġ ving lööhoho. ");
INSERT INTO bzh_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Lom alam lo devonġ dedun böpata, loḳ alam Parisai* hir alam-horek-yi la kedi denare bedenër niwëëk bë, “He halë mehö saga bë nġaa nipaya ti su neggëp vu yi rë! Maḳ nġaahur ti ma angër ti yö vengwënġ vu yi!” ");
INSERT INTO bzh_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Lob ġaġek ahë-sengën-yi ya meböp raḳ rot, lob Rom hir alam-beġö-yi alaj ggöneng. In sir yu luu, lob bë rëḳ dedadii Paulus vewen vewen lob denabij teka teka benadiiḳ. Lom nër balam-beġö-yi deluḳ beya devo Paulus vër in sir gedeḳo yi loḳ yah hir ḳatum ayo. ");
INSERT INTO bzh_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ggovek gebuk lob Mehöböp yam nare ranġah vu Paulus genër vu bë, “Ġemedo los nim wëëk! Ġenër sa ġaġek ranġah ggëp Yerusalem ggovek, gerëḳ ġenanër sa ġaġek gëp Rom nabë saga geving.” ");
INSERT INTO bzh_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nyëġ heng lob alam Yuda desupin sir medenër ġaġek venuh gedetato nemaj ya vavunë bë su dega los denanum rot bemëm nabë dengis Paulus benadiiḳ loḳ mëm. Gaḳ nabë dega ma denanum namuġin og Anutu ngis sir. ");
INSERT INTO bzh_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Sir sën denër ġaġek venuh lo sir mehödahis luu gela sevöḳ. ");
INSERT INTO bzh_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Lob deya vu alam-deneḳo-seriveng hir ggev los alam teta bedenër bë, “He nër ġaġek niwëëk betato nemamin ya vavunë ganër venuh bë he su rëḳ aġa nos los nanum bël rë rot, bena berup doḳ buk sën he ngis Paulus menadiiḳ lo loḳ mëm. ");
INSERT INTO bzh_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Om ham los kaunsor gwevonġ ġaġek na vu Rom hir alam-beġö-yi alaj pehi nabë degeḳo Paulus duḳ menam vu ham. Ham nanër vu yi nabë ham bë gwenġo Paulus yi ġaġek degwa gök nahin in ham jaḳ ni niröp. Gehe semu he ggovek ya. Su rëḳ nam natöḳ nam vu ham rë, gaḳ he rëḳ angis yi menadiiḳ doḳ aggata!” ");
INSERT INTO bzh_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Rëḳ Paulus mewa nġo ġaġek bë rëḳ degetunġ dum gëp aggata bedengis Paulus menadiiḳ, lob ya meloḳ ya Rom hir alam-beġö-yi hir ḳatum beloḳ ya menër ranġah vu Paulus. ");
INSERT INTO bzh_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Lob Paulus tahi alam-beġö-yi hir kapten ti yam, benër vu bë, “Gweḳo hur maġëm sagi na vu ham ggev, in ḳo ġaġek ti in bë nanër vu yi.” ");
INSERT INTO bzh_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Lob kapten ḳo yi beli ya vu ala benër vu bë, “Ḳarabus Paulus tahi sa benër vu sa bë sa ġaḳo hur maġëm sënë nam vu honġ, in ḳo ġaġek ti beyam vu honġ.” ");
INSERT INTO bzh_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Lom ala jom loḳ nema, beḳo meya nenga, beluho yö luu ya denedo, log mëm loḳ tepëḳ in yi bë, “Ġevonġin bë ġenanër ġaġek re vu sa?” ");
INSERT INTO bzh_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Loḳ hur maġëm nër bë, “Alam Yuda dejoo ġaġek ggovek bë rëḳ dedoḳ tepëḳ in honġ begweḳo Paulus duḳ mena vu kaunsor neheng in dedoḳ tepëḳ in yi ġaġek degwa panġsën vu yi. ");
INSERT INTO bzh_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Rëḳ mu su gwebë nengam vu hir ġaġek, in hir alam mehödahis luu gela sevöḳ bedenër ġaġek venuh bë su rëḳ dega los denanum rë, rot bemëm yö dengis Paulus menadiiḳ rë. Gwëbeng desemu sir gemedo denebuu aggata medeneġin honġ bë rëḳ ġengoġekin hir ġaġek ma nama.” ");
INSERT INTO bzh_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Lob alam-beġö-yi alaj vonġ mehö maġëm sënë yah, genër niwëëk vu yi bë, “Su ġena ġenanër vu mehöti nabë ġenër ġaġek sënë ranġah vu sa!” ");
INSERT INTO bzh_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Lob alam-beġö-yi vu Rom alaj tahi kapten luu yam, benër vu luho bë, “Melu barah alam-beġö-yi. Alam sën deneraḳ hoos lo mehödahis löö benemadluho (70), galam sën denejom ruġ lo jaḳ gëp alam nemadluho (200). Bedegero sir in ham na Sisarea jaḳ 9 krök buk. ");
INSERT INTO bzh_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Log ham barah hoos la geving in Paulus jaḳ, geham gweġin yi nivesa bena berup vu kiap böp Peliks.” ");
INSERT INTO bzh_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Lob alam-beġö-yi alaj kevu ḳapiya ti ving nebë: ");
INSERT INTO bzh_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Sehuksën! Kiap böp Peliks, mehö-los-bengö! Sa Klaudius Lusias, sa ḳevu ḳapiya sënë yök vu honġ. ");
INSERT INTO bzh_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Alam Yuda dejom mehö sagi ahon gebë dengis yi menadiiḳ, rëḳ sa hanġo bë yi Rom ti lob seya ving alam-beġö-yi behe töḳ ya vu sir, lob he haḳo yi vër loḳ nemaj. ");
INSERT INTO bzh_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Lom sa bë ġanġo ġaġek degwa sën denër raḳ yi lo, om sën sa haḳo yi luḳ meyah vu hir kaunsor. ");
INSERT INTO bzh_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Rëḳ sa hanġo denër ġaġek raḳ yi in yö hir horek la. Gaḳ su devonġ ġaġek vu yi in nġaa nipaya ti in bë mëm hil angis yi menadiiḳ ma, hil ġetunġ yi na ḳarabus rë. ");
INSERT INTO bzh_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Log gwëbeng ġaġek ti töḳ vu sa bë dekeyëhin yi vunsën in bë d