﻿USE sofia;
DROP TABLE IF EXISTS sofia.bzdNTpo_vpl;
CREATE TABLE bzdNTpo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bzdNTpo_vpl WRITE;
INSERT INTO bzdNTpo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tsa̱we ta̱ ká̱ jaì ena ká̱ i', e' yö'a̱t Skëköl tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Mik ie' tö íyi ulitane tsá̱ yö'mi, eta̱ ká̱ wa'ñe kë̀ ki̱ ì ku̱' yës. Ká̱ sí kë̀ ta̱'. Di' ë̀ me'r i̱ski̱ë. Ká̱ dör ttsettseë. Erë Skëköl Wiköl shkö̀ar di' tsa̱ka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Eta̱ Skëköl tö iché: “¡Ká̱ ñinú!” Eta̱ ká̱ ñine. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ie' tö isué̱ tö ká̱ ñiwe e' dör buaë, e' méa̱titö ñiweie. Ká̱ ttsettse, e' méa̱titö nañeweie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ñiwe, e' kiéitö ñiwe. Ká̱ ttsettseë, e' kiéitö nañewe. Ekkë kanewé̱itö ká̱ tsa̱we a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","E' bule es ta̱ ie' tö iché: “¡Iyönú we̱s ská̱tke̱ kkö̀ dapee es di' shu̱a̱ iblatoie a̱s kë̀ iwöiërwa̱ne ñì a̱!” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Eta̱ es iyuéitö di' blatoie. Es di' a̱te̱ ká̱ jaishe̱t ena ká̱ i' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ì yuéitö, e' kiéitö ka̱költtö. Ekkë kanewé̱itö eta̱ ká̱ de böt. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","E' bule es ta̱ ie' iché: “¡Di' a̱te̱ ká̱ i' ki̱, e' e̱' dapa'ú̱ka̱ ek tsi̱ní ë̀me a̱s íyök poppo döka̱!” Eta̱ es iyöne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Wé̱ íyök poppo deka̱, e' kiéitö íyök. Wé̱ di' dapaneka̱, e' kiéitö dayë. Ie' isué̱ tö e' ko̱s dör buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","E' ukuöki̱ ta̱ ie' tö iché: “¡Íyök ki̱ íyi kuá ulitane tskinú! Ka̱kö wör ta̱' ese, ñies kal ulitane wör ta̱' ese ko̱s tskinú iwakmik iwakmik.” Eta̱ es ekkëpa tskine. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Es íyök ki̱ íyi kuá ulitane tskine ka̱kö wör ta̱' iwakmik iwakmik, ñies kal wör ta̱' iwakmik iwakmik. Ie' tö isué̱ tö ekkëpa ko̱s, e' dör buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ekkë kanewé̱itö eta̱ ká̱ de mañat. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","E' bule es ta̱ ie' iché: “¡Ì dalöburta̱' yönú ká̱ jaì a̱! Ekkëpa dör buaë ká̱ blatoie ñiwe nañewe, ñies ikkachoie mik ta̱ diwö de ka̱wö tköwo̱ie, ñies ká̱ shta̱'wo̱ie ena duas tköke e' jche̱noie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ekkëpa ko̱s dalöburke tai̱ë ká̱ i' ki̱.” Eta̱ es iyöne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Es ie' tö ì dalöburta̱' tai̱ë ese yuéa̱t bök. Ikibiie dör ká̱ ñiwo̱ie ñiweie. Wé̱ne dalöbur diöshe̱t e' dör olo'bunoie nañeweie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ekkëpa méa̱titö ká̱ jaì a̱ dalöbunoie ká̱ i' ki̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ñië nañeë, ñies ká̱ ñiwe ká̱ nañewe e' blatoie. Ie' tö isué̱ tö ekkëpa dör buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ekkë kanewé̱itö eta̱ ká̱ de tkël. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","E' bule es ta̱ ie' tö iché: “¡Iyiwak se̱rke di' a̱ dayë a̱, e' ko̱s yönú tai̱ë! ¡Ñies dù ulitane yönú a̱s iu̱r ka̱shu̱k a̱!” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Eta̱ es iyiwak blubluë se̱rke dayë a̱, ekkëpa yuéitö. Ñies iyiwak ko̱s se̱rke di' a̱ ena dayë a̱ ekkëpa yuéitö iwakmik iwakmik. E' sù̱ dù ulitane yuéitö, iwakmik iwakmik. Ie' isué̱ tö ekkëpa ko̱s dör buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Eta̱ iyiwak yuéitö e'pa a̱ ie' e̱r buaë ché ttè i' wa: “a' alönú tai̱ë, di' ko̱s, dayë ko̱s, e' wà iö́ka̱ tai̱ë. Ñies a̱s dù alör tai̱ë ká̱ wa'ñe.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ekkëpa kanewé̱itö eta̱ ká̱ de ske̱l. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","E' bule es ta̱ ie' tö iché: “¡Iyiwak se̱rke ká̱ sí ki̱, e' ulitane yönú iwakmik iwakmik! ¡Iyiwak uru, iyiwak kañiru, iyiwak e̱' ku̱ke i̱ski̱, ekkë ko̱s yönú iwakmik iwakmik!” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Eta̱ es ie' tö iyiwak ulitane yué ká̱ sí ki̱ iwakmik iwakmik. Ie' tö isué̱ tö ekkëpa ko̱s dör buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","E' ukuöki̱ ta̱ ie' tö iché: “Ditsö yuö̀sö we̱s se' es a̱s ie'pa tkö̀ka̱sö ká̱ i' ko̱s wökirie. Nima, dù, iyiwak uru, iyiwak kañiru, iyiwak e̱' ku̱ke i̱ski̱, ekkë ko̱s tso' ká̱ i' ki̱, e' a̱tdaë ie'pa ulà a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Mik Skëköl tö s'ditsö tsá̱ yö', eta̱ iyuéitö we̱s ie' es; Ie'pa yuéitö wëm eköl ena alaköl eköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ie' e̱r buaë ché ie'pa a̱ i' es: “A' ala'r kö́ka̱ tai̱ë, a' alönú tai̱ë ká̱ ulitane ki̱. Ká̱ i' ko̱s e' kané ú̱ a' tö. Nima, dù, ena iyiwak ulitane ekkëpa ko̱s wökir a' dör, e' wà ú̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","E' ukuöki̱ ta̱ Skëköl tö iché ie'pa a̱: “Ye' ttö̀ ttsö́. Íyi kuá ko̱s wörta̱' ñarta̱', ese méa̱työ a' a̱ ñè. Ñies kalwö ulitane katarta̱' ku'yarta̱' ese ko̱s méa̱työ a' a̱ katè ku'yè. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Erë iyiwak kañiru, iyiwak uru ena dù, ekkëpa ko̱s a̱ ka̱kö méa̱työ katè.” Eta̱ es ia̱te̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ie' isué̱ tö ekkë ko̱s dör buaë shu̱te̱. Ekkë kanewé̱itö eta̱ ká̱ de teröl. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Es ká̱ jaì ena ká̱ i', ñies íyi ulitane tso' iki̱, e' yöne o̱ne se̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ká̱ de kul eta̱ ì ko̱s yö'bitu̱itö e' yöne o̱ne, e' kue̱ki̱ diwö e' wa ie' kë̀ kaneblëne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","E' diwö wa kë̀ ie' kaneblëneia̱ ká̱ i' yuök e' kue̱ki̱ ie' iché tö diwö e' dör buaë. Ñies ie' iché tö semana bit e' diwö bata e' dör batse'r se' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","I' dör ká̱ jaì ena ká̱ i' tsá̱ yönea̱t, e' pakè. Mik Skëköl Jehová tö ká̱ jaì ena ká̱ i' e' yö', ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","e' ké̱wö ska' ta̱ ka̱m ie' tö ka̱li̱ patkö̀ ká̱ i' ki̱, ñies kë̀ yi ku̱' ká̱ kanéu̱k. E' kue̱ki̱ ka̱m kal kuá tskir ena ka̱m ka̱kö tskir. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Erë di' tskirke íyök a̱, e' tö íyök ko̱s nuwe̱ke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Eta̱ Skëköl Jehová tö íyök yué s'ditsöie eköl wák dör wëm. Eta̱ ie' tö iwöiké iyik a̱ ta̱ iyöne se'ie ttsë'ka. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","E' ukuöki̱ ta̱ ie' tö ká̱ buaala yué ekwöki diwö tskirke e' ëka̱, ká̱ kiè Edén ee̱. Eta̱ wëm yö'itö, e' méa̱titö ká̱ buaala e' a̱ se̱nuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ee̱ ie' tö kal ulitane wër bua'buaë, ñies iwö dör buaë katano ese tské. Ká̱ buaala e' shu̱sha̱, ie' tö kal tské bölka. Kal elka dör se̱ne michoë e' kéli. Kal iëlka e' dör íyi buaë ena íyi suluë ese jche̱noie e' kéli. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Edén ká̱ shu̱a̱ di' tskirke etö, e' tö ká̱ buaala nuwe̱ke. Wé̱ ká̱ e' kkö̀ döwa̱ ee̱ di' e' ulà jchërke döka̱ tkëtö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Di' ulà etö kiè Pisón. E' tkökemi ká̱ kiè Havilá, e' ko̱s a̱. Ká̱ e' ki̱ oro tso'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Oro e' dör oro bua'bua. Ñies kiö̀ masmas bua'bua, ese tso' ena ák bua'bua kiè ónice ese tso'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Di' ulà ëtö tkökemi ká̱ kiè Cus, e' ko̱s a̱. E' kiè Guihón. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Iulà ëtö skà mir ká̱ kiè Asiria diwö tskirke, e' ëka̱. E' kiè Tigris. Eta̱ di' ulà bataie, e' kiè Éufrates. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Mik Skëköl Jehová tö wëm tsé̱mi méa̱t ká̱ buaala a̱te̱ Edén e' shu̱a̱ a̱s ikaneù̱itö, a̱s ikkö'nùitö, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","eta̱ ie' tö ttè dalöiëno i' mé ia̱: “Ká̱ buaala e' kéliwö ulitane katèmibö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Erë íyi buaë ena íyi suluë ese jche̱noie e' kéliwö kë̀ katar. Mik kal e' wö katébö, eta̱ be' duöwa̱raë. E' kue̱ki̱ kë̀ ikatar.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","E' ukuöki̱ ta̱ ie' tö iché: “Kë̀ idör bua' wëm a̱ se̱nuk ekörla. Sú̱yö ie' a̱ wapie yuè eköl iki̱muk buaë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Eta̱ iyiwak yö'itö íyök wa ekkë ko̱s debitu̱ iwa̱ wëm a̱ suè̱ tö i̱ma ie' tö ikiè meka̱mi. Ta̱ we̱s wëm tö ikiè méka̱ es ia̱te̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Es wëm tö iyiwak uru ena iyiwak kañiru, ñies dù, ekkë ko̱s kiè méka̱. Erë kë̀ ie' ki̱muk ku̱ne buaë ie' wapieie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Eta̱ Skëköl Jehová tö wëm kapöwé̱wa̱ tai̱ë, e' dalewa ie' tö ichane yéttsa̱ etö, e' chkà wöiéwa̱neitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ichane e' yuéitö alakölie ta̱ idebitu̱ iwa̱ wëm a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Mik wëm tö isué̱, eta̱ ichéitö: “¡I' je' dör ye' wák dichéwö ena ye' wák chkà! Alaköl dë'ka̱ wëm wa, e' kue̱ki̱ ikirdaë alaköl.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","E' kue̱ki̱ wëpa kë̀ se̱rpaia̱ iyë́ ena imì e'pa dapömik, ise̱rdawa̱ alaköl ta̱. Ie'pa böl se̱rdaë ñita̱, ta̱ imía̱ we̱s wák eköl ë̀ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","E' ké̱ska' ta̱ wëm ena alaköl iëte̱r sume, erë ie'pa kë̀ wa̱ jaë jche̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Tkabë̀ tso' etö, e' e̱rbikö̀ tai̱ë s'ki̱tö'wo̱ie iyiwak kañiru yö' Skëköl Jehová tö, ekkë ko̱s tsa̱ta̱. Ká̱ et ta̱ ie' tö alaköl a̱ ichaké: —¿Moki̱ Skëköl tö iyë'a̱t a' a̱ tö ká̱ buaë shu̱a̱ kal ulitane tso', e' wö kë̀ katar yës? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Alaköl tö iiu̱té: —Au, e' kë̀ dör es. Ie' tö sa' a̱ iché tö kal ulitane wö katarmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Erë kal àr ká̱ i' shu̱sha̱ë, e' wö kë̀ katanuk, kë̀ e' kanuk sa' a̱. E' wamblé sa' tö, eta̱ sa' duöralur. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Eta̱ tkabë̀ tö iché alaköl a̱: —Au, e' dör ka̱che. A' kë̀ duö̀pawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ie' wa̱ ijche̱r buaë tö mik kalwö e' katéwa a' tö, eta̱ ì dör buaë, ì dör suluë e' jche̱rdaë a' wa̱ we̱s ie' wák wa̱ ijche̱r es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Eta̱ alaköl isué̱ tö kalwö e' wër buaë katè. Ie' é̱na ikatak íyi jche̱noie buaë. E' kue̱ki̱ ie' tö kalwö batsée, katéwaitö. E' ukuöki̱ ta̱ ie' tö imé iwëm a̱, eta̱ iwëm ikatéwa ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","E' bet ta̱ ì dör sulu, ì dör buaë ese a̱ne ie'pa é̱na, eta̱ ie'pa wa̱ ijche̱newa̱ tö ie'pa iëte̱r sume. Eta̱ ie'pa tö kal kiè higuera, e' köyök yué banoie e' wa ie'pa e̱' patréwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Siwa̱' bitsi̱rke tsá̱li̱, eta̱ wëm ena ilaköl tö Skëköl Jehová shkökedur ká̱ buaë shu̱a̱, e' ttsé. E' yöki̱ ie'pa e̱' blélur kal tso' tai̱ë ese shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Erë Skëköl Jehová tö wëm kié ta̱ ichaké: —¿Wé̱ be' tso'? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Wëm tö iiu̱té: —Ye' tö ittsé tö be' shkökedur ká̱ buaala shu̱a̱. Ye' dur sume, e' kue̱ki̱ ye' suane be' yöki̱. E' kue̱ki̱ ye' e̱' bléwa̱ be' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Eta̱ Skëköl tö ie' a̱ iché: —¿Yi be' a̱ iché tö be' dur sume? Ichö́ ña tö kalwö yë'yö be' a̱ tö kë̀ ikatar ¿e' katébö? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ie' tö iiu̱té: —Be' tö ye' a̱ alaköl me', ye' wapieie, e' tö ye' a̱ kalwö mé katè. E' katéwayö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Eta̱ Skëköl Jehová tö alaköl a̱ ichaké: —¿Iö́k bö iwamblé? Ie' tö iiu̱té: —Tkabë̀ tö ye' ki̱téka̱, e' kue̱ki̱ ye' tö kalwö e' katéwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Eta̱ Skëköl Jehová tö tkabë̀ a̱ iché: —Ì wamblé be' tö, e' kue̱ki̱ ye' tö be' a̱ ichè tö iyiwak ko̱s shu̱a̱ be' ë̀ weirdaë michoë. Ke̱kraë be' shköraë e̱' ku̱ule be' batsi̱' ki̱ ta̱ be' kkö̀ a̱ ká̱ po mirawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Be' ena alaköl meraa̱työ ñì bolökie. Be' aleripa ko̱s ena alaköl aleripa ko̱s, e'pa a̱te̱ ñì bolökie ñies. Alaköl aleri eköl tö be' wökir shka̱'we̱raë ena be' tö ie' klö̀ kaniñak shka̱'we̱raë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","E' ukuöki̱ ta̱ ie' tö iché alaköl a̱: —Mik be' alà ku̱rketke eta̱ be' weirdaë sia̱rë, idalë'r tai̱ë e' ttseraëbö. Erë be' ki̱ be' wëm kiardaë ena ie' döraë be' wökirie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","E' ukuöki̱ ta̱ ie' tö iché wëm a̱: —Be' tö be' alaköl ttö̀ iu̱té, kalwö yë'yö be' a̱ tö kë̀ ikatar, e' wà katébö. E' kue̱ki̱ be' weirdaë ñies. Be' kue̱ki̱ íyök sulu'we̱rawa̱yö. Be' kaneblöraë darërëë be' chkè yuloie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Íyök ki̱ dika'chka ena ka̱kö sulusi, alördaë. Ñies kalwö kañiru katerabö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Be' ka̱wöta̱ kaneblök darërëë chkoie dö̀ mik be' duowa̱, mía̱ne íyökie we̱s be' dör kuaë es eta̱. Be' yöne íyök wa, e' kue̱ki̱ be' dörane íyökie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Wëm tsá̱ yöne, e' kiè Adán. Ilaköl dör se' mì tsá̱. E' kue̱ki̱ Adán tö ikiè méka̱ Eva. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Eta̱ Skëköl tö datsi' yué ie'pa a̱ iyiwak kkuölit wa, ta̱ ie'pa paiéitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Eta̱ ie' tö iché: “I̱'ñe ì dör buaë ena ì dör suluë, e' jche̱r ditsö wa̱ we̱s se' wa̱ ijche̱r es. E' kue̱ki̱ dö' ie'pa mi', se̱ne michoë e' kéli wöbatsök katè ta̱ ise̱r michorak.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","E' kue̱ki̱ ie' tö wëm ena ilaköl yéttsa̱ ká̱ buaala tso' Edén e' a̱, ta̱ ipatkémiitö íyök wakanéu̱k. Íyök wa wëm yöne e' ki̱ ipatkémi kaneblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ie' tö itrë'wé̱shka, e' ukuöki̱ ta̱ ì ttsë'ka pik ta̱' tso' ká̱ jaì a̱ kiè kérub, e'pa tuléwa̱itö ká̱ buaala e' ñalé̱ ska' diwö tskirke e' ëka̱ ikkö'nuk. Ñies tabè wöñarke dalölöë ratkear siwa̱' ki̱, e' méa̱titö a̱s kë̀ yi döwa̱ia̱ se̱ne michoë kéli ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Eta̱ Adán se̱né Eva ta̱. Eva duneka̱ ta̱ ilà ku̱ne wëm. Ikiè méka̱itö Caín. Mik alà ku̱ne, eta̱ Eva tö iché: “Jehová tö ye' ki̱mé, e' kue̱ki̱ ye' alà ku̱ne eköl wëm.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","E' ukuöki̱ ta̱ ilà skà ku̱ne ek, e' kiè Abel, Caín ël tsirla. Abel tö obeja alöwe̱ke. Caín tö dalì kuatkeke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ká̱ et ta̱, Caín wa̱ idali wöne, ese kak mí mè Jehová a̱ idalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Eta̱ Abel wa̱ ie' icha mí ñies. Ie' obeja tsá̱ bua'bua, ese kak mí ie' wa̱ mè Jehová a̱. Abel ena ì méitö e' wër buaë Jehová wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Erë ie' kë̀ wa̱ Caín ena ì méitö e' su̱ne es, e' kue̱ki̱ Caín uluneka̱ tai̱ë, iwö yée suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","E' kue̱ki̱ Jehová tö Caín a̱ ichaké: “¿Iö́k be' ulune wö yée sulu? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Be' tö ì bua' ú̱pa, e̱'ma be' ja̱ñuke tsuleë. Erë ì sulu wamblébö, e' kue̱ki̱ ì sulu e̱' métër bër be' panuk namuie e̱' aloka̱ be' ki̱. Erë be' ké e̱' alökka̱ iki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ká̱ et ta̱, Caín tö iël Abel kiémi kañika̱. Mik ie'pa demi kañika̱, eta̱ ee̱ Caín ñippéka̱ iël ta̱ eta̱ iël ttéwa̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","E' ukuöki̱ ta̱ bet, Jehová tö Caín a̱ ichaké: —¿Wé̱ be' ël Abel? Caín tö iiu̱té: —Ye' kë̀ wa̱ ijche̱r. Ye' kë̀ dör ie' kkö'nukwak. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Skëköl tö ie' a̱ iché: —¿Iö́k bö iwamblé es? Be' ël ttéwa̱bö, e' pë́ tëne tai̱ë íyök ki̱, e' nuí̱ tso' be' ki̱. E' ki̱ ye' ka̱wöta̱ be' we'ikök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","E' kue̱ki̱ be' weirdaë íyök ki̱ wé̱ be' tö be' ël pë́ tkö'wé̱, e' ki̱ be' yerattsa̱yö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Be' kaneblö̀mi tai̱ë, erë kë̀ wà wörpa buaë. Be' ka̱wöta̱ shkök ká̱ wa'ñe, kë̀ a̱ e̱no ta̱' yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Eta̱ ie' tö Jehová iu̱té: —E' darërë ye' a̱. Kë̀ ye' a̱ idalë'ttsënuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","I̱'ñe be' tö ye' u̱yéttsa̱ ká̱ i' ki̱, e' ukuöki̱ ta̱ ye' ka̱wöta̱ shkök ká̱ wa'ñe ka̱mië, kë̀ a̱ e̱no ta̱'. Be' kë̀ ku̱'ia̱ ye' ta̱, e' kue̱ki̱ yi ye' kué̱wa̱, ese tö ye' tterawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Erë Jehová tö iiu̱té: —Yi be' ttéwa̱, ese kí̱ weirdaë sia̱rë tai̱ë iskéie. Eta̱ Skëköl tö iwakyuée iwà kkachoie a̱s yi tö ikué̱wa̱, ese kë̀ tö ittö̀wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Eta̱ Caín e̱' yéttsa̱ Jehová wörki̱ ta̱ imía̱ ká̱ kiè Nod ee̱, ká̱ e' a̱te̱ Edén diwö tskirke e' kke̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Eta̱ Caín se̱né ilaköl ta̱. Iduneka̱ ta̱ ilà ku̱ne wák dör wëm, e' kiè Enoc. E' ukuöki̱ ta̱ Caín tö ká̱ yué et, kiè méka̱itö ilà kiè wa Enoc. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoc dör Irad yë́. Irad dör Mehujael yë́. Mehujael dör Metusael yë́. Metusael dör Lámec yë́. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Eta̱ Lámec se̱néwa̱ alakölpa böl ta̱. Eköl kiè Adá, eköl kiè Silá. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Eta̱ Adá dë' alàë kiè Jabal. E' aleripa dör iyiwak alöu̱kwakpa e' se̱rke úla yöule datsi'tak wa ese a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ie' ël kiè Jubal. E' aleripa dör ma'ma kicha ta̱' guitarra sù̱ ena ma'ma pulë sù̱ ese bla'u̱kwakpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silá dë' alàë ñies kiè Tubal-Caín. E' aleripa dör tabechka kiè bronce ena hierro ese stë́. E' kutà kiè Naamá. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ká̱ et ta̱ Lámec tö iché ilakölpa a̱: “A Adá, a Silá, ye' ttö̀ ttsö́: Wëm eköl duladula tö ye' shka̱o̱', e' kue̱ki̱ ye' tö ikötwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Yi tö Caín ttéwa̱, e' tö iské tue̱raë sia̱rë, erë yi tö ye' ttéwa̱, e' tö iské kí̱ tue̱raë jaishe̱t shu̱te̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adán alà skà kéka̱ne ilaköl ta̱ wák wëm. Eva tö iché: “Skëköl tö ye' a̱ alà ské mé eköl, Caín tö Abel kötwa̱, e' skéie.” E' kue̱ki̱ ie' tö ikiè méka̱ Set. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ñies Set de alàë wák wëm kiè méka̱itö Enós. E' ké̱wö ska' ta̱ s'ditsö tö Skëköl a̱ íyi tsá̱ ki'mi ena idalöië'mi ikiè Jehová e' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Mik Skëköl tö s'ditsö tsá̱ yö', eta̱ iyuéitö we̱s ie' wák es. Ie'pa yuéitö wëm ena alaköl. Ie' e̱r buaë ché ie'pa a̱. Ie' tö ie'pa yué, e' diwö shà̱ ta̱ ikiè méka̱itö s'ditsö. I' dör Adán aleripa e'pa kiè. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Mik Adán ki̱ duas de cien eyök ki̱ dabom mañayök (130), eta̱ ie' alà ku̱ne eköl, e' dör we̱s ie' wák es, ikiè méka̱itö Set. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","E' ukuöki̱ ta̱ ie' kí̱ se̱neia̱ duas cien paryök (800). E' shu̱a̱ ie' ala'r kí̱ ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Es ie' ki̱ duas deka̱ se̱raa̱ cien su̱li̱yök ki̱ dabom mañayök (930) eta̱ ie' blënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Mik Set ki̱ duas de cien eyök ki̱ ske̱l (105), eta̱ ie' alà wëm kiè Enós, e' ku̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","E' ukuöki̱ ta̱ ie' kí̱ se̱neia̱ duas cien kuryök ki̱ kul (807). E' shu̱a̱ ie' ala'r kí̱ ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Es ie' ki̱ duas deka̱ se̱raa̱ cien su̱li̱yök ki̱ dabom eyök ki̱ bök (912) ta̱ iblënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Mik Enós ki̱ duas de dabom su̱li̱yök (90), eta̱ ie' alà wëm kiè Cainán, e' ku̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","E' ukuöki̱ ta̱ ie' kí̱ se̱neia̱ duas cien paryök ki̱ dabom eyök ki̱ ske̱l (815). E' shu̱a̱ ie' ala'r kí̱ ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Es ie' ki̱ duas deka̱ se̱raa̱ cien su̱li̱yök ki̱ ske̱l (905) ta̱ iblënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Mik Cainán ki̱ duas de dabom kuryök (70), eta̱ ie' alà wëm kiè Mahalalel, e' ku̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","E' ukuöki̱ ta̱, ie' kí̱ se̱neia̱ duas cien paryök ki̱ dabom tkëyök (840). E' shu̱a̱ ie' ala'r kí̱ ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Es ie' ki̱ duas deka̱ se̱raa̱ cien su̱li̱yök ki̱ dabop (910) ta̱ iblënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mik Mahalalel ki̱ duas de dabom teryök ki̱ ske̱l (65), eta̱ ie' alà wëm kiè Jéred, e' ku̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","E' ukuöki̱ ta̱, ie' kí̱ se̱neia̱ duas cien paryök ki̱ dabom mañayök (830). E' shu̱a̱ ie' ala'r kí̱ ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Es ie' ki̱ duas deka̱ se̱raa̱ cien paryök ki̱ dabom su̱li̱yök ki̱ ske̱l (895) ta̱ iblënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Mik Jéred ki̱ duas de cien eyök ki̱ dabom teryök ki̱ bök (162), eta̱ ie' alà wëm kiè Enoc, e' ku̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","E' ukuöki̱ ta̱, ie' kí̱ se̱neia̱ duas cien paryök (800). E' shu̱a̱ ie' ala'r kí̱ ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Es ie' ki̱ duas deka̱ se̱raa̱ cien su̱li̱yök ki̱ dabom teryök ki̱ bök (962) ta̱ iblënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Mik Enoc ki̱ duas de dabom teryök ki̱ ske̱l (65), eta̱ ie' alà wëm kiè Matusalén, e' ku̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ie' tö Skëköl ttö̀ ë̀ dalöieke. Matusalén ku̱ne, eta̱ ie' kí̱ se̱neia̱ duas cien mañayök (300). E' shu̱a̱ ie' ala'r kí̱ ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Es ie' ki̱ duas deka̱ se̱raa̱ cien mañayök ki̱ dabom teryök ki̱ ske̱l (365). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ie' se̱ne' buaë Skëköl ta̱, e' kue̱ki̱ ká̱ et ta̱ Skëköl wa̱ ie' mítse̱r ttsë'ka, e' kue̱ki̱ kë̀ ie' ku̱'ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mik Matusalén ki̱ duas de cien eyök ki̱ dabom paryök ki̱ kul (187), eta̱ ie' alà wëm kiè Lámec, e' ku̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","E' ukuöki̱ ta̱, ie' kí̱ se̱neia̱ duas cien kuryök ki̱ dabom paryök ki̱ bök (782). E' shu̱a̱ ie' ala'r kí̱ ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Es ie' ki̱ duas deka̱ se̱raa̱ cien su̱li̱yök ki̱ dabom teryök ki̱ su̱li̱tu (969) ta̱ iblënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Mik Lámec ki̱ duas de cien eyök ki̱ dabom paryök ki̱ bök (182), eta̱ ie' alà ku̱ne wëm. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","E' kiè méka̱itö Noé. Mik ie' tö ilà kiè méka̱, eta̱ ie' tö iché: “Jehová tö íyök suluo̱'wa̱. E' kue̱ki̱ se' ka̱wöta̱ kaneblök darërë ikuatkoie; erë alà i' tö se' keraë e̱nuk.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noé ku̱ne, e' itöki̱ Lámec kí̱ se̱neia̱ duas cien ske̱yök ki̱ dabom su̱li̱yök ki̱ ske̱l (595). E' shu̱a̱ ila'r ki̱ ku̱ne wëpa alakölpa; ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Es ie' ki̱ duas deka̱ se̱raa̱ cien kuryök ki̱ dabom kuryök ki̱ kul (777) ta̱ iblënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé ki̱ duas de cien ske̱yök, e' itöki̱ ila'r ku̱ne mañal. Ikibi kiè Sem. Ishu̱ ë́k kiè Cam. Ibata ë́k kiè Jafet. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Mik s'ditsö alönémi tai̱ë ká̱ i' ki̱, eta̱ Skëköl ala'r tö isué̱ tö s'ditsö alà busipa dör bua'buaala. E' kue̱ki̱ ie'pa tö busipa wa ie'pa wöbatse ese tsé̱lur. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Erë Jehová tö iché: “Ditsö dör duöta̱'wa̱ ese wakpa. I̱'ñe ta̱ ye' kë̀ tö ka̱wö mepaia̱ ditsö a̱ se̱no ká̱ tai̱ë. Es ise̱rdaë duas cien eyök ki̱ dabom böyök (120), ekkë ulat.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mik Skëköl ala'r bak se̱nuk s'ditsö alà busipa ta̱ alà koka̱ ie'pa ta̱, eta̱ e' ké̱ska' ta̱ wëpa blubluë, ka̱kke̱ë, esepa we̱lepa bak ká̱ i' ki̱. Ñies e' ukuöki̱ wëpa esepa bakia̱. E'pa dör pë' darërë kkeauleka̱ tai̱ë ia̱'chki ta̱ ese. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Jehová tö isué̱ tö s'ditsö tö ì sulu ë̀ wambleke tai̱ë shu̱te̱. Ì suluë ë̀ bikeitseke ie'pa tö ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","E' kue̱ki̱ Skëköl e̱r a̱ idalënene tai̱ë. Ie' tö ibikeitsé: “Kë̀ yö ditsö yuö́pa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Eta̱ ie' iché: “Ditsö yö' ye' tö ká̱ i' ki̱, sú̱yö e'pa e̱wè̱wa. Ñies iyiwak ko̱s se̱rke ká̱ sí ki̱, e' e̱we̱rawayö. ¿Ìie ye' tö ie'pa yö'?” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Erë wëm tso' eköl kiè Noé, e' sue̱ke Jehová tö e̱r bua' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ttè ikkë dör Noé pakè. Noé dör wëm yësyësë Skëköl wörki̱. Ke̱kraë ie' tö Skëköl ttö̀ dalöieke buaë. Ie' eköl ë̀ se̱rke we̱s Skëköl ki̱ ikiane es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ie' ala'r dör mañal wëpa kiè Sem, Cam, ena Jafet. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Skëköl wörki̱ s'ditsö tso' e̱' wamblök sulu ë̀me, ñippök tai̱ë shu̱te̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ie' tö isué̱ tö tai̱ë íyi suluë ë̀ tso' íyök ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","E' kue̱ki̱ ie' tö Noé a̱ iché: “Ye' tö ibikeitsétke tö ditsö ko̱s tso' ká̱ i' ki̱ e' e̱we̱rawayö se̱. Ie'pa ñippöke tai̱ë shu̱te̱ ká̱ i' ki̱. E' kue̱ki̱ ye' tö ditsö ko̱s tso' ká̱ i' ki̱ e' e̱we̱rawa se̱raa̱ di' tai̱ë wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","E' kue̱ki̱ kanò yuö́ etö bërie kal bua'bua ese wa, e' shu̱ blatö́. Kanò wöa̱r tso' ipamik, e' wötö́ kiöchka dalolo bötsböts ese wa u'rki̱ ena ishu̱a̱ a̱s di' kë̀ tkö̀wa̱ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kanò yuö́ batsí̱ metro döka̱ cien eyök kí̱ dabom mañayök kí̱ ske̱l (135 metros) ekkë. Ñies isho̱ló̱ yuö́ metro döka̱ dabom böyök ki̱ böt ki̱ sha̱böts (22,5 metros) ekkë. E' sù̱ ispé yuö́ metro döka̱ dabom eyök kí̱ mañat kí̱ sha̱böts (13,5 metros) ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Kanò ki̱ u yuö́ka̱, erë kanò kkö̀ ki̱ iulat múa̱t metro sha̱böts. Kanò shu̱ blatö́ mañat kuö. Ñies iwékkö yuö́ et kanò spé mik shkowa̱ie kanò a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Di' patkerayö íyi tso' ttsë'ka ká̱ i' ki̱ e' ko̱s e̱wo̱wa. Ekkë duörawa̱ se̱raa̱ ká̱ wa'ñe. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Erë ye' ttè meraë be' a̱ tö be' tsa̱tkeraëyö kanò a̱ di' yöki̱. Be' ala'r ena be' alaköl ena be' yakpa, e'pa tsú̱mi e̱' ta̱ kanò a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","E' sù̱ iyiwak kua̱'ki̱ kua̱'ki̱ tso' ká̱ sí ki̱, e' iö́mi kanò a̱ etö wë'ñe etö alaki a̱s itsa̱tkër we̱s be' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Iyiwak ko̱s iö́ kanò a̱. Iyiwak kua̱'ki̱ kua̱'ki̱ u̱rta̱', iyiwak uru, dö̀ iyiwak e̱' ku̱ke i̱ski̱, e' ko̱s iö́mi kanò a̱, etö wë'ñe etö alaki, a̱s kë̀ iduölur. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ñies chkè ulitane dapa'ú̱ blö́ be' a̱ ena iyiwak a̱ katè.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Eta̱ ekkë ko̱s wakanewé̱ Noé tö se̱ we̱s Skëköl tö iché ia̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","4","E' ukuöki̱ ta̱ Jehová tö Noé a̱ iché: “I̱'ñe kuiki ta̱ ye' tö ka̱li̱ patkeraë ká̱ i' ki̱ döka̱ ká̱ dabom tkëyök (40) ñië nañeë. ¡E' wa íyi ulitane yö' ye' tö tso' ttsë'ka ká̱ sí ki̱, e' ko̱s e̱we̱rawayö yës! Erë ye' tö isué̱ tö ditsö ulitane shu̱a̱ be' ë̀ se̱rke buaë yësyësë we̱s ye' ki̱ ikiane es. E' kue̱ki̱ be' e̱' iö́ka̱ kanò a̱ be' yamipa ko̱s ta̱. Ñies iyiwak batse'r ko̱s ese tsú̱mi döka̱ kuktö wë'ñe kuktö alaki. Erë iyiwak kë̀ dör batse'r, ese tsú̱mi etö wë'ñe etö alaki. E' sù̱ ñies dù kua̱'ki̱ kua̱'ki̱ tsú̱mi döka̱ kul wë'ñe kul alaki a̱s kë̀ ie̱rwa. Ko̱s ttè chéyö be' a̱, e' wakaneú̱ es.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Eta̱ e' ko̱s wakanewé̱ Noé tö yësyësë we̱s Jehová tö ie' a̱ iché es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Mik di' bak tai̱ë ká̱ i' ki̱, eta̱ Noé ki̱ duas tso' cien teryök (600). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ie' e̱' iéka̱ kanò a̱ ila'r ena ilaköl ena iyakpa e'pa ko̱s ta̱ e̱' tsa̱tkök di' alörke tai̱ë e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Iyiwak batse'r, e' sù̱ iyiwak kë̀ dör batse'r, iyiwak e̱' ku̱ke ibatsi̱' ki̱ ñies dù, ekkë ko̱s dewa̱ kanò a̱ Noé ta̱ bölka bölka we̱s Skëköl tö iché ia̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ká̱ de kul, eta̱ di' tö ká̱ katémitke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noé ki̱ duas de cien teryök (600), kí̱ si' et kí̱ ká̱ dabom eyök kí̱ kul (17). E' diwö shà̱ ta̱ íyök tskirolone ta̱ di' tso' idiki̱a̱ e' deka̱ tai̱ë ká̱ wa'ñe. Ñies ká̱ jaishe̱t kköburolone ta̱ di' bite̱shka tai̱ë ka̱li̱ie ká̱ i' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Eta̱ ka̱li̱ yëne darërëë döka̱ ká̱ dabom tkëyök (40) ñië nañeë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ka̱li̱ yënémi, e' diwö shà̱ ta̱ Noé e̱' iéka̱ kanò a̱ ila'r ta̱. Ila'r kiè Sem, Cam ena Jafet. E' sù̱ ilaköl, iyakpa mañal, e'pa e̱' iéka̱ ñies ie' ta̱ kanò a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ie'pa ta̱ iyiwak ulitane dewa̱ kanò a̱, iyiwak uru, iyiwak kañiru, iyiwak e̱' ku̱ke i̱ski̱ ki̱ ena dù ulitane. Ekkë ko̱s dewa̱ kanò a̱ ie'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Iyiwak ko̱s ekkë dewa̱ kanò a̱ bölka bölka. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","E' shu̱a̱ imí wë'ñe etö alaki etö, we̱s Skëköl tö iché ia̱ es. E' o̱ne yës ta̱, Skëköl tö kanò wékkö wötéwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Eta̱ ka̱li̱ yënemiie döka̱ ká̱ dabom tkëyök (40). We̱s di' alör mirka̱ es kanò batsemirka̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Es di' kí̱ alönèmi tai̱ë ta̱ kanò batsemirka̱itö buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","20","Es di' alöneka̱ tai̱ë ka̱bata ko̱s blubluë, e' tsa̱ta̱ jaishe̱t dö̀ metro kul ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Es ko̱s íyi tso' ttsë'ka ká̱ sí ki̱, ekkëpa duolur di' a̱ se̱. Dù ko̱s, iyiwak uru ko̱s, iyiwak kañiru ko̱s, iyiwak e̱' ku̱ke i̱ski̱ ko̱s, ñies s'ditsö ekkëpa ko̱s duolur yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ì ko̱s tso' ká̱ sí ki̱ ttsë'ka, e' e̱newa se̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Erë Noé ena ì tso' ie' ta̱ kanò a̱, e'pa ë̀ tsa̱tkëne. Eta̱ imale̱pa ko̱s e' e̱newa. Es ñies iyiwak ulitane e̱wé̱wa di' tö. Dù ulitane, iyiwak uru, iyiwak kañiru dö̀ iyiwak e̱' ku̱ke i̱ski̱, ekkë ko̱s e̱newa se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Es di' a̱te̱ íyök ki̱ ká̱ döka̱ cien eyök ki̱ dabom ske̱yök (150) ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Erë Skëköl kë̀ é̱na Noé chë'wa. Ñies iyiwak ulitane tso' Noé ta̱ kanò a̱ e' kë̀ chë'wa ie' é̱na. Ie' tö siwa̱' patké a̱s itö di' siù̱wa̱ne ká̱ wa'ñe. Eta̱ di' pasinemine e̱nae̱na. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Íyök tskirolone e' wötënene. Ñies ká̱ jaishe̱t kköburolone e' wötërulunene. Eta̱ ka̱li̱ wöklönewa̱ kë̀ yërku̱'ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Di' tso'ia̱ e' pasirmirne e̱nae̱na. Ká̱ de cien eyök ki̱ dabom ske̱yök (150), eta̱ di' sirmir ë̀me. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","E' ki̱ si' de teröl (6) diwö de dabom eyök ki̱ kul (17), eta̱ e̱rpa kanò sineka̱ ka̱bata kiè Ararat e' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Eta̱ di' pasinemiie. Si' de dabop (10), e' tsá̱ diwö, eta̱ ka̱bata ka̱kke̱ë ese wënemitke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","E' ki̱ ká̱ de dabom tkëyök (40), eta̱ Noé tö kanò wékkö tsitsir kköppée. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ie' tö dù ölö́ sù̱, e' émi et. Erë dù e' kë̀ dë'ia̱ne kanò a̱ ie' u̱rke wi̱shwi̱sh dö̀ mik di' sine eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","E' ukuöki̱ ta̱ ie' tö nuböl émi et isuo̱ie tö ká̱ sinene. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Erë di' tso'ia̱ íyök ki̱, ka̱m isirwa̱, e' kue̱ki̱ nuböl dene kanò a̱. Kë̀ ie' wa̱ ká̱ ulat poppo ku̱ne e̱' tkowa̱. Noé tö nuböl klö'wé̱wa̱ ulà wa ta̱ itsé̱wa̱neitö kanò a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ie' tö iskà pané döka̱ ká̱ kul, eta̱ ie' tö nuböl skà émine. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ká̱ tuinemitke ta̱ nuböl dene, e' wa̱ kal ulatska debitu̱ ikà ki̱. Es Noé é̱na ia̱ne tö íyök kí̱ sirmir. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ie' tö iskà pané döka̱ ká̱ kul, eta̱ ie' tö nuböl skà émine. Nuböl e' kë̀ dë'ia̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Mik Noé ki̱ duas tso' cien teryök ki̱ et (601), eta̱ íyök pasinene. Eta̱ si' ke̱we, e' tsá̱ diwö, ie' tö kanò ki̱ u tso' e' kléttsa̱. Eta̱ ie' isué̱ tö íyök pasinene. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ka̱wö de si' et ki̱ diwö dabom böyök ki̱ kul (27), eta̱ ie' isué̱ tö íyök pasinene se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Eta̱ Skëköl tö ie' a̱ iché: ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Be' e̱' yö́ttsa̱ kanò a̱, be' alaköl ta̱, be' ala'r ta̱, be' yakpa ta̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Es iyiwak ulitane yö́lurbö se̱. Dù ena iyiwak uru ena iyiwak e̱' ku̱ke i̱ski̱ e' ko̱s yö́lurbö kanò a̱, a̱s imi' ká̱ wa'ñe alönuk tai̱ë ká̱ wà iökne.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Es Noé alaköl ena ila'r ena iyakpa, e'pa e̱' yélur kanò a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Es ñies iyiwak ulitane, uru ena kañiru ena iyiwak e̱' ku̱ke i̱ski̱, ñies dù e' ko̱s e̱' yéttsa̱ kanò a̱ se̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","E' ukuöki̱ ta̱ ie' tö ák kataté ka̱'ie et Jehová a̱. E' bata ki̱ ie' tö iyiwak batse'r ese jché ña'wé̱itö etö etö Jehová dalöioie. Ñies dù batse'r jchéitö ña'wé̱itö Jehová a̱ etk etk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mik ishklé̱ alar buaë, e' demi Jehová ska' ta̱ ittséitö ta̱ ibikeitséitö: “Erë́ ditsö ià̱ duladula döka̱ këchke, eta̱ ì sulu ë̀ bikeitsekeitö. Erë kë̀ yö ká̱ sulu'we̱pawa̱ia̱ ie'pa kue̱ki̱. Es ñies kë̀ yö ì ko̱s tso' ttsë'ka e' e̱wè̱waia̱ we̱s yö ie̱wé̱wa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Ká̱ i' tso'ia̱, eta̱ dalì kuatkërmi, iwà wörmi; ka̱ba tso', ka̱se̱ tso' ñies; ka̱li̱ tso', duas tso' ñies; ká̱ ñiwe tso', ká̱ nañewe tso' ñies.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Eta̱ Skëköl e̱r buaë ché Noé a̱ ñies ila'r a̱ ta̱ ichéitö ie'pa a̱: “A' alönú tai̱ë. Ká̱ wa'ñe wà iö́ne a' ala'r wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ditsö yöki̱ iyiwak ulitane suardaë. Iyiwak ulitane u̱rke ka̱shu̱k a̱ ena iyiwak se̱rke ká̱ sí ki̱ ena iyiwak se̱rke dayë a̱, e' ko̱s a̱te̱ a' diki̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Iyiwak ulitane ena kalwö ena ka̱kö e' katèmi a' tö wé̱ kiane a' ki̱ ese. E' ko̱s méa̱työ a' a̱ katanoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Chkè ulitane katèmi a' tö, erë kë̀ ikatar ipë́ ta̱, se' se̱rke s'pë́ mik e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Se' se̱rke s'pë́ mik, e' kue̱ki̱ kë̀ se' menea̱t ñì ttökwa̱, e' nuí̱ ta̱'. Yi tö eköl ttéwa̱, ese kichatërdaë. E' sù̱ iyiwak wé̱ tö s'ttéwa̱, ese ka̱wöta̱ ttèwa̱ ñies. A' wé̱ tö s'ttéwa̱, ese nuí̱ patue̱raëitö ye' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Skëköl tö s'ditsö yö' we̱s ie' es, e' kue̱ki̱ yi tö se' ttéwa̱, ese wák ka̱wöta̱' ttèwa̱ wake'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Erë a' alönú tai̱ë, ká̱ wa'ñe wà iö́ ala'r wa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ñies Skëköl tö iché Noé a̱ ena ila'r a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","“I̱'ñe ye' ttè mukea̱t a' a̱ ena iyiwak e̱' yéttsa̱ kanò a̱ a' ta̱, e' ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Moki̱ë ye' tö a' a̱ ichè tö ye' kë̀ tö ditsö ena iyiwak tso' ká̱ wa'ñe, e' ko̱s e̱we̱pawaia̱ di' wa. Di' kë̀ döpaia̱ ká̱ wa'ñe sulu'u̱kwa̱ we̱s itka es.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Ye' tö shkaba' tkekear mò shu̱a̱ iwà kkachoie a' a̱ ena ditsö ulitane a̱ tö ye' ttè méa̱työ a' a̱ ena iyiwak ko̱s a̱ ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Mik ye' tö mò patké ta̱ e' shu̱a̱ shkaba' tkëne e' wërmi, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","eta̱ ye' é̱na ia̱ne tö ye' ttè me'a̱tbak a' a̱ ena iyiwak ko̱s a̱ tö kë̀ ye' tö ditsö ena iyiwak ulitane e̱we̱pawaia̱ di' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Es mik shkaba' tkëne mò shu̱a̱ e' sué̱yö, eta̱ bet ye' é̱na idaa̱ tö ye' ttè me'a̱t ditsö a̱ ena iyiwak ko̱s a̱ michoë ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","E' dör iwà kkachoie tö ye' ttè me'a̱tbak ditsö ulitane a̱ ñies iyiwak tso' ká̱ i' ki̱ e' ko̱s a̱.” Es Skëköl tö Noé a̱ iché. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noé ala'r e̱' yë'lur kanò a̱, e'pa kiè Sem, Cam ena Jafet. Cam dör Canaán yë́. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","E'pa mañal dör Noé ala'r. Ie'pa aleripa tö ká̱ wà iéne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé dalì kuatkémi. E' shu̱a̱ uva kuatkéitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ká̱ et ta̱ ie' tö uva diö̀ shköshkö e' yé ta̱ e' tö ie' ttéka̱ tai̱ë. Ie' datsi' yéttsa̱ ta̱ ia̱newa i̱ski̱ sume iu a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cam dör Canaán yë́, mik e' tö iyë́ sué̱ sume, eta̱ ie' mía̱ ibiyö́ chök iëlpa böl e'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Erë Sem ena Jafet e'pa kë̀ é̱na iyë́ tër sume e' sua̱k. E' kue̱ki̱ ie'pa tö datsi' klö'wé̱wa̱, iméka̱rakitö e̱' o' bataki̱ ta̱ ie'pa shkémi tsi̱kka iwötrélur bánet dö̀ wé̱ iyë́ tër ee̱ ta̱ ipabakéwa̱ datsi' e' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noé tté tai̱ë blo' tö e' ti̱'neka̱. Mik ie' wa̱ ijche̱newa̱ ilà tsirla ë́k kë̀ wa̱ ie' dalöiëne', ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","eta̱ ichéitö: “¡A̱s Canaán ka̱wö tkö̀ suluë! ¡Ie' weirdaë sia̱rë shu̱te̱ klöulewa̱ iëlpa böl e'pa kanè mésoie!” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","E' ukuöki̱ ta̱ ikí̱ chéitö: “¡Jehová dör Sem Këköl a̱s e' ki̱karka̱! A̱s Canaán aleripa kaneblö̀ Sem aleripa a̱ ikanè mésopaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","A̱s Skëköl ka̱wö buaë mù Jafet a̱ a̱s ie' alör michoë. A̱s Jafet ditséwöpa se̱r Sem yamipa ska'. A̱s Canaán aleripa kaneblö̀ ie' a̱ klöulewa̱ ikanè mésopaie.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Di' bak tai̱ë ká̱ i' ki̱, e' ukuöki̱ ta̱ Noé se̱ne'ia̱ duas cien mañayök kí̱ dabom ske̱yök (350). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Mik ie' blënewa̱, eta̱ ie' ki̱ duas tso' cien su̱li̱yök ki̱ dabom ske̱yök (950). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noé ala'r kiè Sem, Cam ena Jafet. Di' bak tai̱ë e' ukuöki̱ ta̱ ie'pa wák ala'r ku̱ne. Ikkëpa dör Noé aleripa kiè. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafet ala'r wëpa dör Gómer, Magog, Madai, Javán, Tubal, Mésec, ena Tirás. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gómer, e' ala'r wëpa dör Asquenaz, Rifat, ena Togarmá. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javán e' ala'r wëpa dör Elisá, Tarsis, Quitim ena Rodanim. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","E'pa ko̱s dör Jafet aleripa. Ie'pa ñì blatérak ulawa ulawa. Es iká̱ yuérakitö tseë iwakpa a̱ dayë kkömik. Ittö̀ kua̱'ki̱ kua̱'ki̱ iwakpamik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Cam ala'r wëpa dör Cus, Misraim, Fut, ena Canaán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cus ala'r wëpa dör Sebá, Havilá, Sabtá, Raamá ena Sabtecá. Raamá ala'r wëpa dör Sebá ena Dedán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cus dör wëm kiè Nimrod, e' yë́. Nimrod de ke̱weie blu' darërëë ká̱ i' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Jehová ttö̀ wa Nimrod dör yëria poë. E' kue̱ki̱ ttè i' menea̱t se' a̱: “Be' dör yëria poë Skëköl ttö̀ wa we̱s Nimrod es.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Mik Nimrod bak ká̱ kiè Sinar, e' wökirie eta̱ ká̱ e' shu̱a̱ ká̱ tso' tkël kiè Babel, Érec, Acad, ena Calné. E' ko̱s dör ká̱ bua'ie ese. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Wëm e̱' yéttsa̱ Sinar a̱ eköl kiè Asur. E' mía̱ ká̱ bánet. Eta̱ ee̱ ie' ká̱ yué tkël kiè Nínive, Rehobot-ir, Quélah ena Resen. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resen dör ká̱ bërie. E' a̱te̱ Nínive ena Quélah, e' shu̱sha̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Eta̱ Misraim aleripa mía̱ ie'pa ikkë wakpaie: ludeowak, anameowak, lehabiwak, naftuhiwak, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","patruseowak, casluhítawak, ena caftoritawak. Filisteowak datse̱ caftoritawak wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaán dör Sidón yë́. Sidón dör ie' alà tsá̱. Ie' alà skà kiè Het. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Canaán aleripa mía̱ ie'pa ikkë wakpaie: jebuseowak, amorreowak, gergeseowak, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heveowak, araceowak, sineowak, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arvadeowak, semareowak ena hamateowak. Ká̱ tai̱ë ta̱ e' wakpa ko̱s ñì blabatsérak ponemi ká̱ kua̱'ki̱ kua̱'ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Canaánwak ká̱ a̱te̱ ká̱ kiè Sidón döwa̱ ká̱ kiè Gaza. Gaza a̱te̱ ká̱ kiè Guerar e' kke̱. Ñies ie'pa ká̱ a̱te̱ döwa̱ ká̱ kiè Lesa diwö tskirke e' kke̱. Lesa a̱te̱ ká̱ tkël kiè Sodoma, Gomorra, Admá ena Seboím e' kke̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","E' wakpa ko̱s dör Cam aleripa. Ie'pa ñì blabatsérak ulawa ulawa. Es iká̱ yuéitörak tseë iwakpa a̱. Ittö̀ kua̱'ki̱ kua̱'ki̱ iwakpamik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ñies Sem dë' alàë, e' dör Jafet ël kibi ë́k. Heber ala'r ko̱s dör Sem aleripa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem ala'r dör Elam, Asur, Arfaxad, Lud ena Aram. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram ala'r dör Uz, Hul, Guéter ena Mas. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxad dör Sélah yë́. Sélah dör Heber yë́. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","E' ukuöki̱ ta̱ Heber alà de böl. Eköl kiè Péleg. E' ké̱wö ska' ta̱ sulitane ñì blabatsérak, e' kue̱ki̱ ikiè méka̱itö es. Iëköl kiè Joctán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joctán ala'r dör Almodad, Sélef, Hasar-mávet, Jérah, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diclá, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sebá, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havilá, ena Jobab. E'pa ko̱s dör Joctán ala'r. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ie'pa se̱rke ká̱ micho ká̱ kiè Mesá tkörö ká̱ kiè Sefar e' shu̱ulat a̱. Sefar a̱te̱ ka̱bata a̱, wé̱ diwö tskirke, e' kke̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","E' wakpa ko̱s dör Sem aleripa. Ie'pa ñì blabatsérak ulawa ulawa. Es iká̱ yuérakitö tseë iwakpa a̱. Ittö̀ kua̱'ki̱ kua̱'ki̱ iwakpamik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Pë' ko̱s ekkëpa dör Noé aleripa kiè kitule we̱s iditséwö kua̱'ki̱ kua̱'ki̱ ena wé̱ ise̱rke ká̱ kua̱'ki̱ kua̱'ki̱ es. Di' bak tai̱ë, e' ukuöki̱ ta̱ se' alönene tai̱ë e' ñì blabatsérak ká̱ wa'ñe. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Kuaë ta̱ sulitane ttöke ttè etökicha ë̀ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mik ie'pa míyaldak diwö tskirke, e' ëka̱, demirak ka̱kkue kiè Sinar ee̱, eta̱ ee̱ ie'pa e̱' tsé̱a̱t se̱nuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ká̱ et ta̱ ie'pa iché ñì a̱: “Mishkarak ska̱u̱chka yuök blok sù̱, e' kukuèsö bö' a̱ a̱s imi'a̱ darërëë u yuoie.” Es iwakanewé̱rakitö ák skéie. Ñies kiöchka dalolo bötsböts ese wa ibatsérakitö ì tso' shu̱tuule ese skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","E' ukuöki̱ ta̱ iskà chénerakitö ñì a̱: “Mishkarak ká̱ blublu yuök. E' shu̱a̱ u yuö̀sö ka̱kke̱ë döka̱ ká̱ jaì a̱. Es se' e̱' chö̀mi buaë këkëpa tai̱ë ena kë̀ se' ka̱wöta̱ ñì blabatsök ká̱ wa'ñe.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Erë Jehová e̱' éwa isa̱u̱krak tö ie'pa ká̱ blublu yueke ena u ka̱kke̱ë yuekerakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Eta̱ ie' tö ibikeitsé: “Ie'pa dör ká̱ etkë̀ wak ena ittörak etkë̀ ñies, e' kue̱ki̱ ie'pa tö kanè i' kéka̱mi. E' ukuöki̱ ta̱ kë̀ ì a̱ ie'pa wöklönuk. Ie'pa se̱rmi we̱s ie'pa ki̱ ikiane es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","E' kue̱ki̱ sú̱yö ie'pa kè ttök kua̱'ki̱ kua̱'ki̱ a̱s kë̀ iñi ttö̀ a̱nia̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Es Jehová tö iblabatsérak ká̱ wa'ñe. Ee̱ ie'pa ká̱ yué e' kané wöpanere. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ká̱ e' ki̱ Jehová tö ie'pa ké ttök kua̱'ki̱ kua̱'ki̱ ena iblabatsérakitö ká̱ wa'ñe. E' kue̱ki̱ ká̱ e' kinewa̱ Babel. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","I' dör Sem aleripa kiè. Di' bak tai̱ë, e' ukuöki̱ duas bök, e' ké̱wö ska' ta̱ Sem ki̱ duas tso' cien eyök (100). Eta̱ ie' alà ku̱ne wëm kiè Arfaxad. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arfaxad ku̱ne, e' ukuöki̱ Sem kí̱ se̱neia̱ duas deka̱ cien ske̱yök (500), eta̱ ie' ala'r skà ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Mik Arfaxad ki̱ duas tso' dabom mañayök kí̱ ske̱l (35) eta̱ ie' alà ku̱ne wëm, e' kiè Sélah. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sélah ku̱ne, e' ukuöki̱ ta̱ Arfaxad kí̱ se̱neia̱ duas cien tkëyök kí̱ mañal (403), eta̱ ie' ala'r skà ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Mik Sélah ki̱ duas tso' dabom mañayök (30), eta̱ ilà ku̱ne, e' kiè Heber. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Heber ku̱ne, e' ukuöki̱ ta̱ Sélah kí̱ se̱neia̱ duas cien tkëyök kí̱ mañal (403), eta̱ ie' ala'r skà ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Mik Heber ki̱ duas tso' dabom mañayök kí̱ tkël (34), eta̱ ilà ku̱ne, e' kiè Péleg. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Péleg ku̱ne, e' ukuöki̱ ta̱ Heber kí̱ se̱neia̱ duas cien tkëyök kí̱ dabom mañayök (430), eta̱ ie' ala'r skà ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Mik Péleg ki̱ duas tso' dabom mañayök (30), eta̱ ilà ku̱ne, e' kiè Reú. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reú ku̱ne, e' ukuöki̱ ta̱ Péleg kí̱ se̱neia̱ duas cien böyök kí̱ su̱li̱tu (209), eta̱ ie' ala'r skà ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Mik Reú ki̱ duas tso' dabom mañayök kí̱ bök (32), eta̱ ilà ku̱ne, e' kiè Serug. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serug ku̱ne, e' ukuöki̱ ta̱ Reú kí̱ se̱neia̱ duas cien böyök kí̱ kul (207), eta̱ ie' ala'r skà ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Mik Serug ki̱ duas tso' dabom mañayök (30), eta̱ ilà ku̱ne, e' kiè Nahor. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahor ku̱ne, e' ukuöki̱ ta̱ Serug kí̱ se̱neia̱ duas cien böyök (200), eta̱ ie' ala'r skà ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Mik Nahor ki̱ duas tso' dabom böyök kí̱ su̱li̱tu (29), eta̱ ilà ku̱ne, e' kiè Térah. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Térah ku̱ne, e' ukuöki̱ ta̱ Nahor kí̱ se̱neia̱ duas cien eyök kí̱ dabom eyök kí̱ su̱li̱tu (119), eta̱ ie' ala'r skà ku̱ne wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Mik Térah ki̱ duas tso' dabom kuryök (70), e' ukuöki̱ ta̱ ie' ala'r ku̱ne mañal. Ala'r e'pa kiè Abram, Nahor ena Harán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","E'pa dör Térah ala'r. Térah dör Abram, Nahor ena Harán, e'pa yë́. Harán, e' dör Lot yë́. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harán blënewa̱ ke̱we iyë́ Térah e' yöki̱ ká̱ kiè Ur ee̱. Ká̱ e' a̱te̱ Caldea. Ie' blënewa̱ wé̱ ie' ku̱ne ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram se̱néwa̱ alaköl kiè Sarai, e' ta̱. Nahor se̱néwa̱ alaköl kiè Milcá, e' ta̱. Milcá dör Harán alà busi ena Iscá kutà. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai kë̀ döta̱' alàë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Térah e̱' yéttsa̱ Ur, dör caldeawak ká̱ e' a̱. Ie' alà Abram ena itala kiè Lot dör Harán alà ena iyàk kiè Sarai e'pa mía̱ ie' ta̱. Warma ie'pa mírö döka̱ ká̱ kiè Canaán ee̱, erë ie'pa demi ká̱ kiè Harán, eta̱ ee̱ ie'pa e̱' tsé̱a̱t se̱nuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ee̱ Térah blënewa̱. Ie' ki̱ duas tso' cien böyök ki̱ ske̱l (205). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Mik Abram bak se̱nuk ká̱ kiè Ur ee̱, eta̱ Jehová tö ie' a̱ iyë': “Be' ká̱ ena be' ditséwöpa ena be' yë́ yamipa, e' múa̱t ta̱ be' yúshka se̱nuk, ká̱ kkachekeyö be' a̱ ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ká̱ e' ki̱ ye' tö be' aleripa alöwe̱raë tai̱ë. Ie'pa döraë ká̱ tai̱ë wakpaie. Ye' e̱r buaë chöraë be' a̱. Ye' tö pë' tai̱ë keraë be' kkeökka̱ tai̱ë. Ñies be' e̱r buaë chöraë pë' tai̱ë a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Wé̱pa e̱r buaë ché be' a̱, esepa a̱ ye' e̱r bua' chöraë. Wé̱pa tö alibché be' ki̱, esepa we'ikerayö. Be' batamik ye' e̱r buaë chöraë ká̱ ulitane wakpa a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Eta̱ Abram e̱' yéttsa̱ ká̱ kiè Harán we̱s Jehová tö ie' a̱ iyë' es. E' ké̱ska' ta̱ ie' ki̱ duas tso' dabom kuryök kí̱ ske̱l (75). Ie' mía̱ Canaán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Eta̱ ie' wa̱ iyamipa mítse̱r se̱raa̱. Ilaköl kiè Sarai ena ilayök kiè Lot ena íyi ulitane tso'rak iwa̱, ekkë ko̱s mítse̱rak iwa̱. Ñies Harán wakpa we̱lepa tso' ie' wa̱ kanè mésoie, e' mítse̱r ie' wa̱. Mik ie' demi Canaán, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","eta̱ ie' tkami ká̱ ko̱s ekkë dö̀mi ká̱ kiè Siquem a̱te̱ Canaán ee̱. Ee̱ ká̱ a̱te̱ kiè Moré. Ee̱ kós klö̀ àr elka. Canaánwakpa a̱ ká̱ e' dör ká̱ dalöiërta̱' ese. (E' ké̱wö ska' ta̱ Canaánwakpa se̱rkeia̱ ee̱.) ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Eta̱ ee̱ Jehová e̱' kkaché Abram a̱ ta̱ ichéitö ia̱: “Ká̱ i' meraëyö be' ditséwö a̱.” Eta̱ Abram tö ák kataté ka̱'ie et iyiwak jchoie Jehová dalöioie ee̱ Jehová e̱' kkayë' ie' a̱ e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","E' ukuöki̱ ta̱ imía̱ ká̱ dör ka̱bataie a̱te̱ Betel diwö tskirke e' ëka̱. Eta̱ ee̱ ie' se̱né ekuölö. Ká̱ e' a̱te̱ Betel ena ká̱ kiè Ai e' shu̱ulat a̱. Ee̱ ie' tö ák skà kataténe et. Ee̱ ie' tö Jehová dalöié. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","E' ukuöki̱ ta̱ Abram mía̱ e̱nae̱na Négueb kke̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","E' ké̱wö ska' ta̱ ketba tkënewa̱ poë ká̱ e' ki̱. Kë̀ ì ta̱' katè wé̱ Abram se̱rke ee̱. E' kue̱ki̱ ie' mía̱ Egipto se̱nuk ekuölö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Abram dökemitke Egipto eta̱ ilaköl Sarai, e' a̱ ichéitö: “Ye' ttö̀ ttsö́. Ye' wa̱ ijche̱r buaë tö be' dör buaala. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Mik Egipto wakpa tö be' sué̱ tö be' dör buaala, eta̱ ie'pa tö ichèmi: ‘Wì̱ dör wëm wí̱ alaköl.’ Eta̱ ye' tterawa̱ ie'pa tö be' kue̱ki̱ erë ie'pa be' meraa̱t se̱nukwa̱ ie'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","E' kue̱ki̱, be' we'ikèyö, ichö́ ie'pa a̱ tö ye' dör be' akë a̱s kë̀ itö ye' ttö̀wa̱ be' kue̱ki̱ a̱s ye' ka̱wö tkö̀ buaë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Mik Abram demi Egipto, eta̱ Egipto wakpa isué̱ tö Sarai dör alaköl buaala. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ká̱ e' blú kue̱blupa tö isué̱ ñies tö Sarai dör alaköl buaala. E' kue̱ki̱ ie'pa mía̱ ichök blu' a̱ tö alaköl e' dör buaala. Eta̱ imítse̱rak iwa̱ blu' wé a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Eta̱ Egipto blú tö Abram kkö'né buaë Sarai dalërmik. Tai̱ë ie' tö Abram a̱ iyiwak uru kakmé. Obeja, baka, burro ena kameio e' kakméitö ie' a̱. Se' ñies kakméitö ie' a̱ kanè mésoie wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Erë Sarai kue̱ki̱ Jehová tö Egipto blú ena iyamipa we'iké tai̱ë. Duè méka̱ tai̱ë ie'pa ki̱. Ka̱wö darërëë méka̱itö ie'pa ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","E' kue̱ki̱ Egipto blú tö Abram tsu̱k patké ta̱ ichéitö ia̱: “¿Iö́k bö iwamblé ye' ta̱ es? ¿Ì kue̱ki̱ be' kë̀ wa̱ ye' a̱ iyëne tö alaköl i' dör be' alaköl? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Be' tö ye' a̱ iyë' tö ie' dör be' kutà. E' kue̱ki̱ tsir eta̱ ye' se̱néwa̱ ie' ta̱. I' be' alaköl, itsú̱mine ta̱ be' yúshka.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Eta̱ Egipto blú tö ishkëkipa patké Abram yöktsa̱ ká̱ e' ki̱ ilaköl ta̱ ena ì ko̱s tso' ie' wa̱ ekkëpa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","E' ukuöki̱ ta̱ Abram ena ilaköl e̱' yélur Egipto mía̱ne Négueb. Ie' íyi ko̱s mítse̱rak iwa̱ se̱raa̱. Ie' alayök Lot e' mía̱ ie'pa ta̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram dör íyi blu' tai̱ë. Ie' wa̱ oro tso'. Ie' wa̱ inuköl tso' tai̱ë. Ñies ie' wa̱ iyiwak tso' tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Négueb ee̱ ta̱ ie' mía̱ne e̱nae̱na dö̀ Betel. Betel ee̱ ta̱ ie' mía̱ne tkörö wé̱ ie' bak se̱nuk ke̱we ee̱. Ká̱ e' a̱te̱ Betel ena Ai e' ulat shu̱sha̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ká̱ e' a̱ ie' wa̱ ák katatëulebak ka̱'ie, ee̱ ie' tö Jehová dalöiéne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot dör ñies íyi blú tai̱ë we̱s iyëla Abram es. Iyiwak tso' tai̱ë ie' wa̱ obeja ena baka. Se' tso' ie' wa̱ ñies kanè mésopaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Erë wé̱ ie'pa se̱rke ká̱ e' ki̱ ka̱kö kë̀ ku̱'ia̱ ie'pa iyiwak ko̱s a̱ katè. Ie'pa kë̀ chë'ka̱ia̱ ñì o̱'mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Abram ena Lot e'pa iyiwak kkö'nukwakpa ñippöke, ñì wöñatköke. Ñies pë' tso'tke ke̱net ká̱ e' ki̱. E' wakpa dör canaánwak ena fereseowak. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ká̱ et ta̱ Abram tö iché Lot a̱: “Se' dör ñì yami. Kë̀ imène buaë tö se' ñippö̀. Ñies se' iyiwak kkö'nukwakpa ñippöke ë̀me e' kë̀ dör buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ká̱ sa̱ú̱ wì̱ ká̱ bua' tso'. Be' ishu̱shtö́ wé̱ne wa be' wöbatse, e' a̱ be' yúshka. Be' mí wì̱ ëka̱, e' ta̱ ye' mí dià ëka̱. Eta̱ be' mí dià ëka̱, e' ta̱ ye' mí wì̱ ëka̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Eta̱ Lot ká̱ kí̱ sué̱ ka̱mië, eta̱ ko̱s di' kiè Jordán, e' kkömik ká̱ buaë tso', e' kí̱ sué̱ ie' tö. Eta̱ ie' tö isué̱ tö ká̱ e' dör buaë dö̀ ká̱ kiè Sóar ee̱. Buaë di' tso' we̱s ká̱ buaë yö' Jehová tö es ena we̱s Egipto es. (E' ké̱wö ska' ta̱ ka̱m Jehová tö ká̱ kiè Sodoma ena ká̱ kiè Gomorra, e' böt e̱ù̱wa.) ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Eta̱ ka̱kkue tso' Jordán di' kkömik e' shu̱shté Lot tö, eta̱ e' wa ie' mía̱. Es ie'pa ñì blabatsélor. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram e̱' tsé̱a̱t se̱nuk Canaán. Lot mía̱ se̱nuk Jordán ka̱kkue ki̱, ee̱ ká̱ tso' tseë. Ie' se̱né tsi̱net ká̱ kiè Sodoma e' o̱'mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodoma wakpa, se̱rke suluë. Ie'pa ì sulu ë̀ wambleke ke̱kraë Jehová wöa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot mía̱ e' ukuöki̱ ta̱, Jehová tö iché Abram a̱: “Wé̱ be' tso' ee̱ ká̱ kí̱ sa̱ú̱ bua'ie shkit wöwí̱ wöiá̱ dià ëka̱ jaì ëka̱ ká̱ wa'ñe tö ¿is idör? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ká̱ ko̱s kí̱ sué̱bö, e' meraëyö be' a̱ ena be' aleripa a̱ ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ye' tö be' aleripa alöwe̱raë tai̱ë we̱s íyök po tai̱ë es. We̱s íyök po kë̀ shta̱rta̱' es be' aleripa alördaë kë̀ ishta̱rpa yi a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ká̱ i' ko̱s meraëyö be' a̱. E' kue̱ki̱ be' yú iweblök se̱raa̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Eta̱ Abram e̱' yéttsa̱ ta̱ imía̱ se̱nuk kós klö̀ wökir àr tai̱ë dör wëm kiè Mamré e' icha ee̱. E' a̱te̱ tsi̱net ká̱ kiè Hebrón ee̱. Ee̱ Abram tö ák skà kataté ka̱'ie Jehová dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","E' ké̱wö ska' ta̱ blu'pa tso' tkël. Eköl kiè Amrafel, e' dör ká̱ kiè Sinar, e' blú. Iëköl kiè Arioc, e' dör ká̱ kiè Elasar, e' blú. Iëköl skà kiè Quedorlaómer, e' dör ká̱ kiè Elam, e' blú. Eta̱ ibata ë́k kiè Tidal, e' dör ká̱ kiè Goím, e' blú. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Blu'pa skà tso' döka̱ ske̱l e' eköl kiè Bera, e' dör ká̱ kiè Sodoma, e' blú. Iëköl kiè Birsá, e' dör ká̱ kiè Gomorra, e' blú. Iëköl kiè Sinab, e' dör ká̱ kiè Admá, e' blú. Skà kiè Seméber, e' dör ká̱ kiè Seboím, e' blú. Ibata ekkë e' dör ká̱ kiè Bela, e' blú. Ká̱ e' kiè Sóar ñies. E' ké̱wö ska' ta̱ blu'pa döka̱ tkël ñe' e̱' kéka̱ ñippök blu'pa skà döka̱ ske̱l ñe' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Blu'pa ske̱l e'pa tö iñippök wakpa dapa'wé̱ ek tsi̱ní ñippök blu'pa tkël e'pa ta̱ ka̱kkue kiè Sidim ee̱. Ee̱ dayë wölö me'r bërie kiè Mar Muerto. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Blu'pa döka̱ ske̱l e'pa bak se̱nuk iwakpa ta̱ döka̱ duas dabom eyök ki̱ bök (12), blu' kiè Quedorlaómer, e' diki̱a̱. Mik e' ki̱ duas de dabom eyök ki̱ mañal (13) eta̱ ie'pa kë̀ é̱na Quedorlaómer ttè dalöiakia̱. Ie'pa e̱' kakka̱ ñippök ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","E' ki̱ duas de ek eta̱ Quedorlaómer e̱' yéttsa̱ mía̱ ñippök ibolökpa ta̱. Blu'pa döka̱ mañal dör ie' klépa, e' míyal ie' ta̱ ñippök. Ie'pa mía̱ ká̱ kiè Astarot Carnaim ta̱ ee̱ ie'pa e̱' aléka̱ refaítawak ki̱. E' ukuöki̱ ta̱ ie'pa e̱' aléka̱ zuzitawak ki̱, ká̱ kiè Ham ee̱. E' ukuöki̱ ta̱ ie'pa e̱' aléka̱ emiwak ki̱, e' wakpa ká̱ kiè Savé-quiriataim. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","E' ukuöki̱ ie'pa e̱' aléka̱ horeowak ki̱ ka̱bata kiè Seír ee̱. Eta̱ itötié̱mi ie'pa tö dö̀ tkörö ká̱ kiè El-parán ee̱. Ká̱ e' a̱te̱ ká̱ sir poë, e' kkömik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Eta̱ ee̱ ie'pa bite̱ne itö̀ wane dö̀ ká̱ kiè En-mispat. Ká̱ e' kiè Cadés ñies. Ie'pa e̱' aléka̱ Amalec aleripa ki̱ ta̱ iká̱ klö'wé̱wa̱rakitö. Ñies ie'pa e̱' aléka̱ amorreowak ki̱. E' wakpa ká̱ kiè Hasesón-tamar. E' ukuöki̱ ta̱ ie'pa mi'ke ñippök blu'pa ske̱l ta̱. E' kue̱ki̱ blu'pa ske̱l e̱' dapa'wé̱ka̱ Sidim ké̱kkue ki̱ blu'pa tkël ki̱nuk ñippoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Eta̱ Sodoma blú ena Gomorra blú ena Admá blú ena Seboím blú ena Bela blú (Bela kiè Sóar ñies), blu'pa ske̱l ekkëpa ñì dapa'wé̱ka̱ Sidim ké̱kkue ki̱ ñippoie, Quedorlaómer, e' dör Elam blu', e' ta̱ ena blu'pa tso' ie' ta̱ e'pa ta̱ ñies. Blu'pa e'pa dör Tidal, e' dör Goím blu'. Iëköl dör Amrafel, e' dör Sinar blu'. Bata ë́k dör Arioc, e' dör Elasar blu'. Es blu'pa tkël míyal ñippök blu'pa ske̱l ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","E' ké̱wö ska' ta̱ Sidim ké̱kkue ki̱ kiöchka dalolo bötsböts ese dapé tso' tai̱ë. Mik Sodoma wakpa ena Gomorra wakpa tkayal ñippè yöki̱ eta̱ ie'pa sha̱böts a̱nemi kiöchka dapé tso' tai̱ë ese a̱. Imale̱pa tkayalmi ka̱bata shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Es blu'pa döka̱ tkël e'pa e̱' aléka̱ blu'pa ske̱l ki̱. Eta̱ ie'pa tö chkewö ena íyi bua'bua tso' Sodoma ena Gomorra e' ko̱s klö'wé̱wa̱rakitö ta̱ iponemirak. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","E' ké̱wö ska' ta̱ Abram alayök Lot se̱rke Sodoma. E' mítse̱rak iwa̱, es ie' dalì ko̱s e' mítse̱rak iwa̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Eta̱ ñippè shu̱a̱ wëm tkashkar eköl, e' wa̱ ibiyö́ mí Abram a̱. Abram e' dör hebreowak. Ie' se̱rke tsi̱net wëm kiè Mamré dör amorreowak e' kós klö̀ wökir àr ee̱. Mamré dör Escol ena Aner ël. Ie'pa wa Abram wër buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Mik Abram tö ibiyö́ ttsé, eta̱ ie' kanè mésopa ku̱ne ie' u a̱, e'pa dapa'wé̱itö döka̱ cien mañayök ki̱ dabom eyök ki̱ pàköl (318) ilayök tsa̱tkoie. Eta̱ ie'pa míyal blu'pa tkël itöki̱ döka̱ ká̱ kiè Dan ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Eta̱ nañewe ie'pa demi me'ie ñippémiie blu'pa ta̱. Eta̱ ie'pa tö blu'pa töié̱mi tkörö ká̱ kiè Hobá ee̱. Hobá a̱te̱ ká̱ kiè Damasco e' wöwí̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Eta̱ ì ko̱s minetse̱r blu'pa wa̱, e' ko̱s yélur ie'pa tö blu'pa ulà a̱. Es Abram tö ilayök Lot e' tsa̱tkée. Ñies ì tso' ilayök wa̱ e' ko̱s dene iulà a̱. Ñies alakölpa ena pë' male̱pa tso' klöulewa̱ e'pa ko̱s tsa̱tkée ie' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Mik Abram e̱' aléka̱ Quedorlaómer ki̱, e' sù̱ blu'pa mañal shköke ie' ta̱, e'pa ki̱. E' ukuöki̱ ta̱ ie' bite̱ne de Savé ké̱kkue ki̱. Ka̱kkue e' kiè ñies Blu' Ké̱kkue. Eta̱ ee̱ Sodoma blú de ie' ñale̱tsu̱k ie' shke̱'u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ñies ká̱ kiè Salem, e' blú kiè Melquisedec, e' dör Skëköl dör íyi ulitane tsa̱ta̱ e' sacerdote. Ie' tö pan ena vino yéttsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Eta̱ ie' e̱r buaë ché Abram a̱ ttè i' wa: “Skëköl dör íyi ulitane tsa̱ta̱, e' tö ká̱ jaì ena ká̱ i' yö'. Ie' tö be' ki̱mè a̱s be' ka̱wö tkö̀ buaë ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ie' dör íyi ulitane tsa̱ta̱, e' ki̱köka̱sö. Ie' tö be' ki̱mé e̱' alökka̱ be' bolökpa ki̱, e' kue̱ki̱ iki̱köka̱sö.” Eta̱ íyi ko̱s de Abram ulà a̱ ñippè shu̱a̱, e' mú blatèsö döka̱ dabop ta̱ e' tsá̱ eyök yéttsa̱itö méitö Melquisedec a̱ Skëköl dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","E' ukuöki̱ ta̱ Sodoma blu' tö iché Abram a̱: —Sa' yamipa tsa̱tkée be' tö, e'pa múne ye' a̱. Erë dalì ko̱s e' tsú̱mi be' tö be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Erë Abram tö iiu̱té: —Au. Jehová dör Skëköl íyi ulitane tsa̱ta̱, e' tö ká̱ jaì ena ká̱ i' yö', ie' a̱ ye' kablétke ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","tö ì ko̱s dör be' icha, e' kë̀ tse̱paa̱työ yës. Dö̀ be' datsi'takla ö be' klökkuö kicha kë̀ tse̱paa̱työ etkla wë'ia̱ a̱s kë̀ be' ichö̀ tö be' íyi wa ye' blune. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kë̀ ì kiane ye' ki̱ ye' wák a̱. Chkö̀ ko̱s ñétke ye' kanè mésopa tö, e' ë̀ dör wë' ye' a̱. Erë wé̱pa dare ye' ta̱ ñippök bulu'pa ta̱ kiè Aner ena Escol ena Mamré, a̱s ie'pa wa̱ dalì kakmi' ko̱s ika̱wöta̱ tsu̱kmi eköl eköl ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","E' ukuöki̱ ta̱ Jehová tté Abram ta̱ kabsue̱ie, eta̱ ichéitö ia̱: —A Abram, kë̀ be' suanuk. Ye' dör be' tsa̱tkökwak. Íyi buaë merayö be' a̱ tai̱ë shu̱te̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Erë Abram tö iiu̱té: —A Skëköl, ye' wák alà kë̀ ta̱', e' kue̱ki̱ ì ko̱s memibö ye' a̱ e' kë̀ dör ìie bua' ye' a̱. Ye' íyi ko̱s a̱tdaë ye' kanè méso kiè Eliézer dör Damasco wak e' ulà a̱. Erë ie' dör o̱'ka. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Eta̱ Jehová tö iiu̱té: —Be' wák alà ku̱rdaë, e' kë̀ dör o̱'ka. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Eta̱ Jehová wa̱ Abram mítse̱r u'rki̱, ta̱ ichéitö ia̱: —Ká̱ sa̱ú̱ buaë siwa̱' ki̱. Bëkwö sa̱ú̱ ta̱ ishta̱'ú̱. ¿Be' a̱ ishta̱rmi? E̱'ma bua', es be' aleripa alördaë tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Eta̱ Abram e̱rblé Jehová mik, e' kue̱ki̱ iklö'wé̱itö we̱s pë' buaë yësyësë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Eta̱ ichéitö ia̱: —Ye' dör Jehová. Ye' tö be' yë'ttsa̱ caldeawak ká̱ kiè Ur e' a̱ ká̱ i' moie be' a̱ ena be' aleripa ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Eta̱ Abram ie' a̱ ichaké: —A Skëköl, ¿we̱s e' jche̱rmi ye' wa̱ yësyësë tö ká̱ i' dö̀mi ye' ulà a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Jehová tö iiu̱té: —Baka ena chibo ena obeja e' ko̱s ki̱ duas tso' mañal, ese tsú̱bitu̱ ña etö etö. Ñies nuböl et ena ipupula et, e' tsú̱bitu̱ ña. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Eta̱ Abram wa̱ iyiwak ko̱s ekkë debitu̱ Jehová a̱. Eta̱ ie' tö iyiwak e' ttélur télor shu̱sha̱ë. Sha̱böts méwa̱itö wí̱ wa sha̱böts méwa̱itö i' wa. Es ia̱te̱ ñì wösha̱ë. Erë dù kë̀ tënane ie' wa̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Eta̱ ölö́ dettsa̱ iyiwak chkà dalërmik, erë Abram tö ibukueke chkè ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ká̱ tuinemitke, eta̱ Abram kapowa̱ tai̱ë. E' bet Abram pamik ká̱ mía̱ ttsettseë shu̱te̱ se' suawè̱ ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Eta̱ Jehová tö iché ia̱: —Be' wa̱ ijche̱nú buaë tö be' aleripa se̱rdaë ká̱ kua̱'ki̱ ki̱ we̱s ká̱ kua̱'ki̱ wakpa es. Ee̱ ie'pa klördawa̱ kanè mésopaie kë̀ patue̱ta̱'. Ie'pa weirdaë döka̱ duas cien tkëyök (400), ekkë ulatök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Erë ká̱ wé̱ wakpa tö ie'pa we'ikera, e' wakpa ské we'ikerayö sia̱rë. E' ukuöki̱ ta̱ be' aleripa yërdattsa̱ ká̱ e' a̱. Ie'pa wa̱ íyi bua'bua tuè̱ darërëë ese miraë tai̱ë iwákpa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Eta̱ mik be' kënewa̱ eta̱ be' duöwa̱mi buaë, kë̀ weir ta̱'. Es be' michoë be' dëu̱töpa itöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Eta̱ mik be' aleripa tso' ká̱ kua̱'ki̱ ñe' a̱ e'pa de döka̱ tkëtökicha, eta̱ ie'pa dörane ká̱ i' ki̱. Ká̱ i' wakpa, kiè amorreowak, ka̱m e'pa tö ì sulu wamblö̀ dö̀ wë' ishu̱loie. E' kue̱ki̱ be' aleripa kë̀ döpane ká̱ i' ki̱ bet. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ka̱tuine de ka̱mië, eta̱ ì dettsa̱ tabechka ukuöie, e' shu̱a̱ shkle̱ batröke tai̱ë. Ñies kuàtak sí wöñarke tai̱ë ese dettsa̱ ta̱ itkami iyiwak chkà blatëule tkëte̱r ee̱, e' shu̱sha̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Eta̱ Jehová tö ttè mé Abram a̱ i' es: —Ká̱ i' meraëyö be' aleripa a̱. Di' kiè Egipto dí ee̱mi döka̱ di' kibi kiè Éufrates, ká̱ ekkë ko̱s meraëyö be' aleripa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","I̱'ñe ta̱ ká̱ e' dör quenitawak, quenizitawak, cadmoneowak, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","hititawak, fereseowak, refaítawak, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amorreowak, canaánwak, gergeseowak ena jebuseowak e'pa ko̱s wakpa ká̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram alaköl Sarai, e' kë̀ döta̱' alàë. Ie' wa̱ alaköl tkër eköl kanè mésoie kiè Agar. E' dör egiptowak. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Eta̱ Sarai tö iché Abram a̱: —Isa̱ú̱ tö Jehová kë̀ wa̱ ye' a̱ alà mène. E' kue̱ki̱ be' se̱nú ye' kanè méso Agar ta̱. Eta̱ isalema ie' batamik alà dö̀mi ye' ulà a̱. Eta̱ Abram tö Sarai ttö̀ iu̱té. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Eta̱ Sarai tö egiptowak tso' ie' wa̱ kanè mésoie, e' tsé̱bitu̱, mé iwëm a̱ alakölie. E' ké̱wö ska' ta̱ ie'pa se̱né Canaán e' ki̱ duas de dabop. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Eta̱ Abram se̱néwa̱ Agar ta̱, eta̱ Agar duneka̱. Mik ie' isué̱ tö ie' duneka̱, eta̱ ie' tö iwökir Sarai sué̱mi suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Eta̱ Sarai tö iché Abram a̱: —¡Be' iane iwiie tö Agar tö ye' sue̱ke suluë! Ye' wák tö be' a̱ Agar me' alakölie i' ta̱ idurtke e' wà ku̱rdaë, eta̱ ie' e̱' ttsöke jaishe̱t ye' tsa̱ta̱. ¡A̱s Jehová tö se' a̱ ichö̀ tö yi iane iwiie, ye' ö be'! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Eta̱ Abram tö iiu̱té: —Ye' ttö̀ ttsö́, be' kanè méso tso' be' ulà a̱. Be' iú̱ we̱s be' é̱na iwa̱k es. E' ukuöki̱ ta̱ Sarai tö ikanè méso we'ikémi tai̱ë. E' kue̱ki̱ Agar tkashkar. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Eta̱ Jehová biyöchökwak bua'ie, e' tö ikué̱ di' tum o̱'mik ká̱ wé̱ kë̀ yi ku̱' ese ska'. Di' tum e' tso' ñala̱ micho ká̱ kiè Sur e' kkömik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Eta̱ Jehová biyöchökwak bua'ie tö ie' a̱ ichaké: —A Agar, Sarai kanè méso, ¿Wé̱ be' bite̱? ¿Wé̱ be' micho? Ie' iiu̱té: —Ye' tkashkar ye' wökir Sarai yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Eta̱ ie' iché ia̱: —Be' dakö́ne be' wökir ska' ta̱ idalöiö́ bë̀rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ie' tö ikí̱ ché ia̱: “Ye' be' aleripa alöwe̱raë tai̱ë. Kë̀ yi a̱ ishta̱nuk ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Be' e̱riarke, e' ttsé Jehová tö, e' kue̱ki̱ se̱ be' dur, e' wà ku̱ne, ta̱ ikiè múka̱bö Ismael. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Be' alà döraë we̱s burro pupula kë̀ urutërta̱' es. Ie' ñippöraë darërë sulitane ta̱. Ñies sulitane ñippöraë ie' ta̱.” Ie' se̱rdaë ke̱kraë ñippök iëlpa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Jehová tté Agar ta̱, e' ukuöki̱ ta̱ Agar tö iché: “Skëköl ye' sué̱, e' wák sué̱wa̱yö.” E' kue̱ki̱ ie' tö Skëköl kié i' es: “Skëköl tö ye' sué̱ e'.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","E' kue̱ki̱ ñies di' tum e' kiè méka̱itö: “Skëköl tso' e' ye' sue̱ke”. Di' tum e' tso' Cadés ena Béred e' shu̱sha̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","E' ukuöki̱ ta̱ Abram alà kéka̱ Agar ta̱ e' wà ku̱ne wák wëm. Abram tö ikiè méka̱ Ismael. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ismael ku̱ne, e' ké̱wö ska' ta̱ Abram ki̱ duas tso' dabom paryök kí̱ teröl (86). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Mik Abram ki̱ duas tso' dabom su̱li̱yök kí̱ su̱li̱tu (99), eta̱ Jehová e̱' kkaché ie' a̱ ta̱ iché ia̱: —Ye' dör Skëköl Diché Ta̱' Íyi Ulitane Tsa̱ta̱ e'. Be' se̱nú yësyësë ye' wörki̱ ke̱kraë, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","e' ta̱ ye' ttè meraë be' a̱ tö be' aleripa alördaë tai̱ë be' itöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Eta̱ ie' e̱' té̱wa̱ i̱ski̱ iwötsa̱ méwa̱ íyök ki̱. E' dalewa Skëköl tso' ttök ie' ta̱, ta̱ ichéitö ia̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","—Ye' ttè meke be' a̱ e' dör i' es: Be' döraë ká̱ tai̱ë wakpa yë́ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","E' kue̱ki̱ i̱'ñe ta̱ be' kë̀ kièia̱ Abram. Ye' tö be' tkéka̱ ká̱ tai̱ë wakpa yë́ie, e' kue̱ki̱ be' kiè méka̱yö Abraham. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ye' tö be' aleripa alöwe̱raë tai̱ë. Ie'pa döraë blu'paie ena ká̱ tai̱ë wakpaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ke̱kraë ye' dör be' Këköl ñies be' aleripa Këköl. Ka̱wö e' mekeyö be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","I̱'ñe ta̱ be' se̱rke Canaán, ká̱ e' ko̱s meraëyö be' a̱ ena be' aleripa a̱. E' a̱te̱ ie'pa ulà a̱ ke̱kraë. Ye' dör ie'pa Këköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Skëköl tö iskà chéne Abraham a̱: —Erë be' ena be' aleripa ko̱s e' ka̱wöta̱ ttè muk ye' a̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","E' dör i' es: A' wëpa ko̱s ka̱wöta̱ itóttola kkuölitla tök tsir. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","E' kue̱ki̱ a' wëpa ko̱s e' wakyuö́ es. E' tö ikkacheraë tö se' ttè me' ñì a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ke̱kraë ko̱s a' ala'r ku̱rke wëpa, ñies a' kanè mésopa ala'r wëpa, mik e' ki̱ ká̱ de pàköl, eta̱ a' ka̱wöta̱ iwakyuök es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","A' ka̱wöta̱ iu̱k kröröë ala'r ko̱s ku̱rke a' u a̱ ekkëpa ta̱. Es ttè me'tkeyö a' a̱, e' a̱te̱ wakyöule a' chkà ki̱ ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Wëm kë̀ wakyöule, ese kë̀ wa̱ ye' ttö̀ dalöiëne, e' kue̱ki̱ kë̀ ika̱wö ta̱'ia̱ se̱nuk a' shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ñies Skëköl tö iché Abraham a̱: —Be' alaköl kë̀ kièia̱ Sarai. I̱'ñe ta̱ ikirdaë Sara. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ye' e̱r buaë chöraë ie' a̱ a̱s ie' alà kö̀ka̱ be' a̱. Moki̱ ye' e̱r buaë chöraë ie' a̱. Ie' döraë ká̱ tai̱ë wakpa mìie. Ñies ie' aleripa shu̱ döraë blu'paie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham skà e̱' té̱wa̱ne i̱ski̱ iwötsa̱ méwa̱itö íyök ki̱. E' dalewa ija̱ñéka̱ ta̱ ibikeitséitö: “¿Ye' ki̱ duas tso' cien eyök (100), we̱s e' dö̀mi yë́ie? ¿Sara ki̱ duas tso' dabom su̱li̱yök (90), eta̱ we̱s ie' dö̀mi alàë?” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Erë ie' tö iché Skëköl a̱: —¡Be' mú e̱r buaë chö̀ Ismael a̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Erë Skëköl tö iiu̱té: —Au, e' kë̀ dör es. Be' alaköl Sara, e' döraë alàë ta̱ ikiè múka̱bö Isaac. Ttè me'yö be' a̱ e' ë̀ meraneyö ie' a̱ ena ie' aleripa a̱ ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Kë̀ ye' é̱na Ismael chë'wa. Ye' tö ie' ki̱meraë ñies. Ye' tö ie' ala'r alöwe̱raë tai̱ë a̱s ileripa dö̀ tai̱ë ká̱ i' ki̱. Ismael döraë s'blu'pa döka̱ dabom eyök ki̱ böl e'pa yë́ie. Ie' aleripa alördaë tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Erë ttè me'tkeyö be' a̱ e' a̱tdaë be' alà ku̱rdaë kiè Isaac e' a̱. Be' alà e' keraka̱ Sara tö duas iëk wa ka̱wö ikkë ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Mik Skëköl tté o̱ne Abraham ta̱, ta̱ imía̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","E' wösha̱ë Abraham tö ilà Ismael e' tottola kkuölitla tée tsir. Ñies ie' wa̱ kanè mésopa tso' ku̱ne ie' u a̱ ena wëpa to̱ule ese, e'pa ko̱s tottola kkuölitla téeitö tsir we̱s Skëköl tö iyë'ia̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Mik Abraham ki̱ duas tso' dabom su̱li̱yök ki̱ su̱li̱tu (99) ena ilà ki̱ itso' dabom eyök ki̱ mañal (13) eta̱ ie'pa tottola kkuölitla tëne tsir. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Es e' diwö ë̀ wa Abraham ena ilà tottola kkuölitla tëne tsir. Ñies wëpa dör ie' kanè mésopa, e'pa ko̱s tottola kkuölitla tëne tsir. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ká̱ et dibata a̱ ta̱ Abraham tkër ie' ukkö a̱. Ie' u tso' wé̱ wëm kiè Mamré e' kós klö̀ wökir àr ee̱. Ie' tkër ee̱ eta̱ Jehová e̱' kkaché ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","E' wà pakè i' es: Abraham wökéka̱ ta̱ ie' isué̱ tö wëpa de iëte̱r ie' wörki̱ mañal. E' sué̱ ie' tö ta̱ bet ie' e̱' kéka̱, mía̱ ie'pa ñale̱tsu̱k ta̱ ie' e̱' té̱wa̱ i̱ski̱ ta̱ iwötsa̱ méwa̱ íyök ki̱ ie'pa shke̱'wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ie' tö iché: —A këkëpa, be' we'ikèyö, kë̀ be' minuk bet. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ye' mi' di' tsu̱k a' klö̀ skuoie, e' ukuöki̱ ta̱ a' e̱nú bë̀rë kal i' diki̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","A' detke ye' ska', eta̱ ilè mekeyö a' a̱ ñè a̱s a' diché iërne shkoie. Eta̱ ie'pa tö ie' iu̱té: —E̱'ma iú̱ we̱s be' tö iché es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham tkawa̱ iu a̱, ta̱ ichéitö Sara a̱: —Bet, harina bua'bua yulö́ kilo döka̱ dabom böyök (20) ekkë, e' wa pan yuö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","E' ukuöki̱ ta̱ bet ie' wák tu̱nemi baka pupula shu̱shtök wé̱ bua'bua ese klö'wé̱wa̱itö. E' mítse̱r ie' wa̱ méitö ikanè méso eköl a̱. Bet ta̱ ikanè méso tö ikanewé̱ ie' a̱ katè. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Abraham tö baka chkà ena baka tsu'diö wösi ena baka tsu'diö pa̱'a̱li̱ e' mé ie'pa a̱. Ie'pa tulur chkök kal àr ukkö a̱ e' diki̱a̱. E' dalewa Abraham dur ie'pa tiök ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","E' dalewa ie'pa tö ichaké Abraham a̱: —¿Wé̱ be' alaköl kiè Sara e'? Ie' iiu̱té: —Ie' tkër we̱shke̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Eta̱ ie'pa eköl tö iché ia̱: —Duas iëk e' wa ye' döne be' pakök. E' ké̱wö ta̱ be' alaköl Sara alà ta̱'tke. E' dalewa Sara tkër Abraham tsi̱kka u wékkö a̱. Ie' tso' ie'pa ttöke, e' ttsök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham ena ilaköl, e' dewa̱tke këkëpala. Bànet Sara kë̀ tö alakölpa duè sue̱ta̱'ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","E' kue̱ki̱ Sara kë̀ a̱ ja̱ñè wöklönuk ta̱ ibikeitsé: “¿We̱s ye' tö ttè i' klö'wè̱mi tö sa' kërulunetke e' dö̀mi alàë?” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Jehová tö iché Abraham a̱: —¿Ì kue̱ki̱ Sara ja̱ñéka̱? ¿Ì kue̱ki̱ ie' tö iché: “¿We̱s ye' kënewa̱tke e' dö̀mi alàë?” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kë̀ ì ta̱ ye' a̱ darërë. Duas iëk ye' döne, eta̱ ie' alà ta̱'tke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara suane e' kue̱ki̱ ichéitö: “Kë̀ ye' ja̱ñine'.” Erë Jehová tö iché ia̱: —E' kë̀ dör es. Moki̱ be' ja̱ñéka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","E' ukuöki̱ ta̱ ipakökwakpa e̱' duéka̱rak ta̱ imíyal dö̀ wé̱ Sodoma kí̱ wëne ee̱. Abraham tö iñalé̱ mére e̱' choa̱t ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","19","Eta̱ Jehová tö ibikeitsé: “Abraham aleripa alördaë tai̱ë diché ta̱' tai̱ë. Ye' tö iyë'a̱t ie' a̱ tö ie' batamik ye' e̱r buaë chöraë ká̱ ulitane wakpa a̱. Ye' tö ie' shu̱kit a̱s ie' tö ila'r ena ileripa a̱ ichö̀ tö ye' ttè dalöiö́ ñies tö ì ko̱s buaë yësyësë e' ú̱. Es ì ko̱s yë'yö ie' a̱ e' we̱raëyö. E' kue̱ki̱ ye' ka̱wöta̱ ichökia̱ tö iö́k ye' mí Sodoma.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","E' kue̱ki̱ ie' tö iché Abraham a̱: —Sodoma wakpa ena Gomorra wakpa e̱' wamblökerak suluë tai̱ë shu̱te̱, e' ché sulitane tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","E' kue̱ki̱ ye' mía̱ ee̱ isa̱u̱k tö yëne ie'pa e̱' wamblöke suluë ichö́k we̱s ye' a̱ ikkatëne es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Eta̱ Abraham pakökwakpa böl e̱' yéttsa̱ mía̱ Sodoma. Erë Abraham a̱te̱ dur Jehová ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ie' e̱' skéwa̱ tsi̱net Jehová ska' ta̱ ichakéitö ia̱: —¿S'se̱r moki̱ë esepa e̱wè̱wamibö se' sulusipa ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Isalema s'se̱r moki̱ë esepa tso' Sodoma döka̱ dabom ske̱yök (50), eta̱ ¿ká̱ e' wakpa e̱wè̱wamibö se̱raa̱? ¿Kë̀ be' tö ilo'yepa ie'pa ki̱ s'se̱r moki̱ë tso' döka̱ dabom ske̱yök (50), e'pa kue̱ki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","¡Moki̱ be' kë̀ tö s'se̱r yësyësë esepa e̱we̱pawa se' sulusipa ta̱ ñita̱! Kë̀ bö iwamblepa es. ¡E' kë̀ wamblërpa! Be' dör sulitane shu̱lökwak e' kue̱ki̱ ¿we̱s e' kë̀ tö se' shu̱lepa yësyësë? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Jehová tö iiu̱té: —S'se̱r moki̱ë esepa kué̱yö döka̱ dabom ske̱yök (50) e' ta̱ e'pa dalërmik kë̀ ye' tö imale̱pa e̱we̱pawa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Eta̱ Abraham tö iskà chéne ia̱: —Be' dör Skëköl. Ta̱ ye' dör we̱s ká̱ po ena mulu̱chka es be' wöa̱. E' tö be' chakè tai̱ë kë̀ suane. Isalema s'se̱r moki̱ë esepa kianeia̱ ske̱l (5) a̱s idöka̱ dabom ske̱yök (50). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ske̱l e' kianeia̱, e' ta̱ e'pa ë̀ kue̱ki̱ ¿ká̱ e' wakpa e̱wè̱wamibö? Jehová tö iiu̱té: —S'se̱r moki̱ë esepa kué̱yö döka̱ dabom tkëyök ki̱ ske̱l (45), e' ta̱ kë̀ ye' tö ká̱ e' wakpa e̱we̱pawa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham tö iskà chaké: —Dö' dabom tkëyök (40) ë̀ tso', e' ta̱ ¿be' tö ká̱ e' wakpa e̱wè̱wami? Jehová iiu̱té: —Au, kë̀ yö ká̱ e' wakpa e̱we̱pawa dabom tkëyök (40) e' dalërmik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Eta̱ Abraham tö ikí̱ ché ia̱: —Tai̱ë be' tsiriwé̱yö, e' kue̱ki̱ kë̀ be' ulunuk ye' ki̱. Dö' s'se̱r yësyësë tso'ia̱ dabom mañayök (30) ë̀. Jehová tö iiu̱téne: —Au, dabom mañayök (30), e'pa dalërmik kë̀ yö ie̱we̱pawa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham tö ikí̱ chaké ë̀me: —A ye' Këköl, tai̱ë yö be' dalöse̱wé̱wa̱ be' chakök i' es, erë ká̱ ki̱ s'se̱r moki̱ë tso' dabom böyök (20) ë̀, e' ta̱ e'pa kue̱ki̱, ¿ká̱ e' wakpa e̱wè̱wamibö? Jehová tö iiu̱té: —Au, ie'pa dabom böyök (20), e' ë̀ dalërmik kë̀ ye' tö ká̱ e' wakpa e̱we̱pawa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham tö ikí̱ chaké ta̱ ichéitö ia̱: —Kë̀ be' ulunuk ye' ki̱. I' ë̀ chakekeyö be' a̱. S'se̱r moki̱ë esepa tso' döka̱ dabom eyök (10) ë̀, e' ta̱ ¿we̱s bö iwè̱mi? ¿ká̱ e' wakpa e̱wè̱wamibö? Jehová tö iiu̱té: —Dabom eyök ë̀ dalërmik kë̀ ye' tö ká̱ e' wakpa e̱we̱pawa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mik ie'pa tté o̱ne ñita̱ eta̱ Jehová mía̱ne. Abraham bite̱a̱ne ie' u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ká̱ tuinemitke ta̱ Skëköl biyöchökwakpa böl e'pa demi ká̱ kiè Sodoma ee̱. Abraham alayök kiè Lot, e' tkër ká̱ e' kköiëulewa̱ e' wékkö a̱. Mik ie' tö Skëköl biyöchökwakpa sué̱, eta̱ ie' e̱' kéka̱ ie'pa shke̱'u̱k. Ie' e̱' té̱wa̱ i̱ski̱ iwötsa̱ méwa̱itö íyök ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ie' tö iché ie'pa a̱: —A këkëpa, ye' kköchö̀ a' a̱ tö a' kapö́rö ye' ska'. Ee̱ a' klö̀ skuö̀mi eta̱ bule bla'mi a' mi'mine. Ie'pa iiu̱té: —Au. Kë̀ be' tkinuk. Sa' kapömi u'rki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Erë Lot kköché tai̱ë ie'pa a̱. Bata ekkë ta̱ ie'pa míyal ie' u a̱. Mik ie'pa dewa̱ we̱shke̱, eta̱ ie' tö ie'pa a̱ chkè yulé buaë. Pan kë̀ wötuule iwölöwo̱ka̱ wa ese yuéitö ie'pa a̱. Ie'pa chké. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ka̱m ie'pa kapö̀lur e' yöki̱ Sodoma wakpa wëpa debitu̱ tai̱ë. E'pa tö Lot u kköiéwa̱ shkit. Ie'pa ulitane, duladulapa dö̀ këkëpaë, e'pa ku̱lé̱mi Lot wöa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ie'pa tö ichaké a̱neule: —I̱'ñe wëpa böl debitu̱ be' u a̱ ¿wé̱ e'pa? ¡Ie'pa yö́lur í̱e̱ sa' a̱ u'rki̱ a̱s sa' se̱rka̱ ie'pa ta̱ kësik wa! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot e̱' yéttsa̱ ttök ie'pa ta̱. Ukkö wötéwa̱itö buaë itsi̱kka. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ie' tö ie'pa a̱ iché: —A yamipa, ye' kköchö̀ a' a̱ tö ì sulu e' kë̀ wamblar ie'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ye' alà busipa tulur böl ka̱m se̱r wëpa ta̱, e'pa yekeluryö a' a̱ a̱s a' tö iwamblö̀ ie'pa ta̱ we̱s a' ki̱ ikiane es. Erë kë̀ ì wamblar sulu ye' pakökwakpa dewa̱ ye' ska', e'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Erë ie'pa iiu̱té: —¡Be' e̱' skö́u̱ bánet! Be' kë̀ dör ká̱ i' wak. Be' kë̀ a̱ ì yënuk sa' a̱. ¡E' kue̱ki̱ be' we'ikeraë sa' tö ie'pa se̱ tsa̱ta̱! E' ukuöki̱ ta̱ iwe'ikémi ie'pa tö ta̱ idemirak u wékkö batsökök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Eta̱ Lot pakökwakpa ulà tié̱wa̱ u'rki̱ ukkö a̱ Lot tsé̱wa̱ we̱shke̱. Eta̱ ie'pa tö ukkö wötéwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Pë' sulusi ko̱s wöbla sulu'wé̱lur ie'pa tö, kë̀ wawëneia̱. Duladulapa dö̀ këkëpaë e'pa ko̱s wöbla sulurulune. E' kue̱ki̱ ie'pa shtrinewa̱ ukkö yulök. Kë̀ ie'pa wa̱ iku̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Lot pakökwakpa tö iché ia̱: —Tai̱ë ká̱ i' wakpa kkatëne e' tté demi Jehová wö ki̱. E' kue̱ki̱ sa' patkéitö ie'pa e̱u̱kwa. Ie'pa e̱we̱kewa sa' tö yës. E' kue̱ki̱ be' yamipa e̱kka kí̱ tso' ká̱ i' ki̱, e' ta̱ e'pa yö́lur. Be' alà duladulapa ta̱' ö be' alà busipa ta̱' ö be' nua̱kipa ta̱', ö be' yamipa skà tso' ká̱ i' ki̱, e' ta̱ ¡iyö́lur bet tsú̱mi ka̱mië! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Eta̱ Lot mía̱ wëpa ttè meule se̱nukwa̱ ila'r busipa ta̱ e'pa weblök ta̱ iché ia̱rak: —¡A' e̱' kö́ka̱! ¡A' yúshka! Jehová tö ká̱ i' e̱we̱kewa. Erë ie'pa tö ibikeitsé tö ie' kalöke ie'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ká̱ ñirketke, e' ulatök ta̱ Skëköl biyöchökwakpa tö iché Lot a̱: —Sa' tö ká̱ i' e̱we̱kewa. Kë̀ be' duakwa̱, e' ta̱ ¡bet, be' e̱' kö́ka̱! ¡Be' alaköl ena be' ala'r busipa tsú̱mi! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Erë ie' e̱' u̱keia̱ e̱naë. Erë Jehová e̱r buaë ché ie' a̱, e' kue̱ki̱ Skëköl biyöchökwakpa tö iklö'wé̱wa̱ iulà a̱ yèttsa̱. E' sù̱ ñies ilaköl ena ilà busipa yélur ie'pa tö Sodoma a̱ itsa̱tkoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Mik ie'pa tö iyéttsa̱rak bánet eta̱ Skëköl biyöchökwakpa tö iché ie'pa a̱: —¡A' tu̱nú a̱s a' tsa̱tkër! ¡Kë̀ a' ká̱ i' sa̱u̱kia̱ tsi̱kkane yës! ¡E' sù̱ kë̀ a' e̱' wöklö'u̱k ka̱kkue i' ki̱! ¡A' é̱na e̱' tsa̱tkak, e' ta̱ a' yúshka etkëme ka̱bata a̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Erë Lot tö iché ia̱: —¡A këkëpa, au, a' we'ikèyö! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","A' tö ye' ki̱mé tai̱ë. A' tö ye' tsa̱tké duö̀wa̱ ulà a̱, erë kë̀ ye' shkak ka̱bata a̱. Ye' ibikeitsè tö ì sulu datse̱ ká̱ i' e̱u̱kwa, e' tö ye' kuè̱mi ñala̱ ki̱ eta̱ ye' duöwa̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ká̱ tsitsir tso' í̱e̱ tsi̱net, ee̱ ye' tkö̀shkarmi. Ka̱wö mú ña shkowa̱ ee̱ e̱' tsa̱tkoie. Moki̱ e' dör ká̱ tsir. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Eta̱ ie'pa eköl tö iiu̱té: —Ye' be' ttö̀ ttsé, e' kue̱ki̱ yö iwe̱ke we̱s be' tö ye' a̱ ikié es. Ká̱ chébö ye' a̱ e' kë̀ e̱we̱ku̱'wayö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Erë be' yú etkëme ee̱. Kë̀ ye' a̱ ì wamblënuk ka̱m be' dö̀mi e' dalewa. E' kue̱ki̱ ká̱ e' kiè Sóar. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Mik ká̱ ñine eta̱ Lot demi Sóar. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Eta̱ azufre wöñarke bö'ie e' patkébitu̱ Jehová tö tai̱ë Sodoma ena Gomorra ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ká̱ e' wakpa e̱wé̱wa bö' tö yës. Ñies dalikua ko̱s tskirke ká̱ e' ki̱ e' ñanewa̱ se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Erë Lot alaköl dami itöki̱. E' tö ká̱ sué̱ itsi̱kka. Bet ie' yönane dayë wösiie shkë'ka. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Bule es bla'mi ta̱ Abraham mía̱ne wé̱ ika̱paké Jehová ta̱ ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodoma ena Gomorra kí̱ sué̱itö ta̱ ishklé̱ batröke tai̱ë we̱s të blublu ña'wè̱sö es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Es Skëköl tö ká̱ e' wakpa e̱wé̱wa. Erë ì ki' Abraham tö ie' a̱, e' ska' ie' e̱r de, e' kue̱ki̱ ie' tö Lot tsa̱tkée. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Sodoma ena Gomorra e̱wé̱wa Skëköl tö, e' ukuöki̱ ta̱ Lot suane se̱nukia̱ Sóar. E' kue̱ki̱ imía̱ se̱nuk ka̱bata a̱ ila'r busipa böl ta̱. Ee̱ ie'pa mañal se̱né ákuk a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ká̱ et ta̱ ilà busi kibi tö iché itsirla a̱: —Se' yë́ kënewa̱tke eta̱ kë̀ wé̱ wëpa ta̱' se̱nuk se' ta̱ we̱s alakölpa male̱pa wëpa ta̱' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","E' kue̱ki̱ se' yë́ ttöka̱sö blo' wa eta̱ se' se̱r ie' ta̱, eta̱ es se' ulà a̱ alà dö̀mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","E' nañewe ta̱ ie'pa tö iyë́ ttéka̱ blo' wa tai̱ë, eta̱ ilà busi kibi ë́k se̱né ie' ta̱. Erë ie' tteke blo' tö tai̱ë, e' kue̱ki̱ kë̀ ie' é̱na ì a̱neia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Bule es ta̱ ilà busi kibi tö iché itsirla a̱: —Bö ittsö́, ye' se̱né se' yë́ ta̱. I̱'ñe nañewe iskà ttöka̱sö blo' wa. Eta̱ be' se̱nú ie' ta̱. Eta̱ es se' böl ulà a̱ alà dö̀mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","E' nañewe ta̱ ie'pa tö iyë́ skà ttéka̱ blo' wa. Eta̱ ilà busi tsirla se̱né ie' ta̱. Erë ie' tteke blo' tö tai̱ë, e' kue̱ki̱ kë̀ ie' é̱na ì a̱neia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Es ilà busipa böl e̱' bukluwé̱ka̱ iyë́ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Eta̱ ikibi ë́k alà ku̱ne kiè méka̱itö Moab. I̱'ñe ta̱ Moab aleripa datse̱ e' batamik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ñies itsirla de alàë, kiè méka̱itö Ben-amí. I̱'ñe ta̱ amonwak datse̱ e' batamik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham e̱' yéttsa̱ Mamré a̱, mía̱ tkörö ká̱ kiè Négueb ee̱. Eta̱ ie' e̱' tsé̱a̱t se̱nuk ká̱ kiè Guerar ee̱. Guerar a̱te̱ Cadés ena Sur e' shu̱sha̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ie' tö ká̱ e' wakpa a̱ iché tö Sara dör ie' kutà. Ká̱ e' blú kiè Abimélec, e' tö Sara tsu̱k patké alakölie e̱' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Erë nañewe ta̱ ie' kapowa̱ e' dalewa, Skëköl tté ie' ta̱ kabsuè̱ a̱ ta̱ iché ia̱: —Alaköl tsu̱k patkébö e' wëm ta̱', e' kue̱ki̱ be' duöwa̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Erë ka̱m ie' se̱r Abraham alaköl ta̱, e' kue̱ki̱ ie' iiu̱té: —A këkëpa, ye' kë̀ ki̱ e' nuí̱ ku̱' ¿we̱s e' ttèwa̱mibö? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","E̱'ma Abraham wák tö ye' a̱ iché tö alaköl e' dör ie' kutà. Ñies ilaköl tö ye' a̱ iché tö Abraham dör ie' akë. E' kue̱ki̱ ye' tö ì ko̱s wé̱ e̱r bua' wa. Kë̀ ye' wa̱ iwamblëne e̱r sulu wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Skëköl tö iskà iu̱téne kabsuè̱ a̱ ta̱ ichéitö ia̱: —Ye' é̱na ia̱ne buaë tö be' tö iwé̱ e̱r bua' wa. E' kue̱ki̱ kë̀ ye' wa̱ be' kàne ie' kökwa̱ a̱s be' kë̀ tö ì sulu wamblö̀ ye' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Abraham dör ye' tteköl, e' kue̱ki̱ bet be' yú ilaköl mukne ia̱. Ie' tö ye' a̱ ikieraë a̱s be' se̱ria̱ ttsë'ka. Erë be' kë̀ dë'ne imukne, e' ta̱ be' ena be' yamipa ko̱s duöralur. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Bule es bla'mi ta̱ Abimélec shke̱ne ikanè mésopa kiéitö ta̱ ì sué̱itö kabsuè̱ a̱ e' ko̱s pakéitö ie'pa a̱. Mik e' ttsé ie'pa tö eta̱ tai̱ë ie'pa suanéka̱ iyöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Eta̱ Abimélec tö Abraham kié ta̱ iché ia̱: —¿Iö́k be' tö iwamblé sa' ta̱ es? Be' kue̱ki̱ Skëköl tö sa' pau̱ñé e̱wè̱wa, erë Skëköl tö sa' pau̱ñé es, eta̱ ¿ì sulu wambléyö be' ta̱? Íyi ese kë̀ ka̱wö ta̱' wamblënuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Be' tö ì sulu wamblé ye' ta̱, eta̱ ¿ì dör iwà? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham tö iiu̱té: —Ye' tö ibikeitsé tö ká̱ i' ki̱ kë̀ yi tö Skëköl dalöieta̱'. Ye' suane dö' a' ye' ttèwa̱ ye' alaköl yottsa̱ ye' ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Erë iyëne tö ie' dör ye' kutà. Ie' yë́ dör ye' yë́, erë ie' mì kë̀ dör ye' mì. Ñies ie' dör ye' tayë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mik Skëköl tö ye' a̱ iyë' tö be' e̱' yö́ttsa̱ be' yë́ ká̱ a̱, eta̱ yö iché ye' alaköl a̱: “Ká̱ wa'ñe wé̱ se' demi, eta̱ ichö́ tö ye' dör be' akë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Eta̱ Abimélec tö Sara méne iwëm Abraham a̱. Ñies iyiwak kakméitö Abraham a̱ obeja ena baka. Ñies kanè mésopa kakméitö ie' a̱ wëpa ena alakölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Eta̱ ie' iché Abraham a̱: —Ye' ká̱ sa̱ú̱ se̱raa̱ wé̱ wa be' wöbatse e' ki̱ be' yú se̱nuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Eta̱ Sara a̱ ichéitö: —Ye' tö inuköl wömule̱ kakmé be' akë a̱ döka̱ mil ekkë. E' dör ì sulu wambléyö be' ta̱ be' wakpa ulitane wöa̱ e' patuo̱ie. Es be' kë̀ jaëneia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Eta̱ Abraham tö Skëköl a̱ ikié tö Abimélec ena ilaköl duöke, e' bua'ú̱ne. Eta̱ Skëköl tö ie'pa bua'wé̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Alakölpa ko̱s tso' Abimélec u a̱, e'pa shu̱ mo'wa̱ Jehová tö a̱s kë̀ idöia̱rak alàë Sara kue̱ki̱. Ie'pa ko̱s shu̱ wötséene Jehová tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ì yë' Jehová tö Sara a̱ tö be' alà köraka̱, e' wà tka we̱s iyëne bak es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Erë́ Sara ena iwëm dör këkëpalatke, erë ie' duneka̱ e' wà ku̱ne. Alà e' ku̱ne mik Skëköl tö iké̱wö yë' ie' a̱ eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Sara alà ku̱ne wëm e' kiè méka̱ Abraham tö Isaac. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Mik Isaac ki̱ ká̱ de pàköl, eta̱ Abraham tö itóttola kkuölitla tée tsir we̱s Skëköl tö ie' a̱ iyë' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","E' ké̱wö ska' ta̱ Abraham ki̱ duas tso' cien eyök (100). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Eta̱ Sara tö ibikeitsé: “Skëköl tö ye' ja̱ñawé̱ka̱. Mik sulitane wa̱ ijche̱newa̱ tö ye' de alàë eta̱ tai̱ë ie'pa ja̱ñumi ye' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ka̱m ye' alà kö̀ka̱ eta̱ kë̀ yi a̱ iyënuk tö ye' dö̀mi alàë. Erë i' ta̱ ye' alà kéka̱ Abraham a̱, ie' kënewa̱tke eta̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Eta̱ Abraham alà Isaac de bërie ta̱ itsu'batsée e' ké̱wö tkö'wé̱ Abraham tö tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Eta̱ Sara tö isué̱ tö Abraham alà ku̱ne egiptowak kiè Agar e' ta̱ kiè Ismael, e' tö Isaac wayueke suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","E' kue̱ki̱ Sara mía̱ ichök Abraham a̱: “Ì ko̱s tso' be' wa̱ mè se' alà Isaac a̱, e' kë̀ ka̱wö ta̱' blatè se' kanè méso e' alà a̱. E' kue̱ki̱ iyuö́shkar alàë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ismael dör Abraham alà ñies e' kue̱ki̱ ì ché Sara tö e' tö ie' e̱riawé̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Erë Skëköl tö iché ia̱: “Be' aleripa chökle e'pa döraë Isaac wa. E' kue̱ki̱ kë̀ be' tkinuk be' alà kibi ë́k ki̱ ena imì ki̱. Ì ko̱s ché Sara tö e' ú̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Be' alà ku̱ne a' kanè méso ta̱, ñies e' aleripa alöwe̱raëyö tai̱ë, ie' dör be' alà e' kue̱ki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Eta̱ bule es bla'mi ta̱ Abraham tö Agar a̱ chkè mé. Ñies di' méitö ia̱ iyiwak kkuölit yöule di' tso̱ie ese a̱. E' tié̱ka̱ ie' tö se̱raa̱ itsi̱ ki̱ ta̱ iyuéshkar ilà Ismael e' ta̱. Agar mía̱ shkémi ëanas wé̱ kë̀ yi se̱rku̱' ese ska' ká̱ kiè Beerseba e' ëka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mik idi' e̱newa, eta̱ ilà tkése̱ritö kal diki̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ie' kë̀ ki̱ ilà kiane suè̱ duökwa̱, e' kue̱ki̱ imía̱ e̱' tkése̱r kukuie. Mik ie' e̱' tkése̱r i̱ski̱ eta̱ ilà i̱é̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ilà i̱u̱ke e' ttsé Skëköl tö ta̱ bet Jehová biyöchökwak bua'ie e' tö Agar a̱ ichaké ká̱ jaì a̱: “¿A Agar we̱s be' de? Kë̀ be' suanuk. Be' alà tkër i̱u̱k e' ttsé Skëköl tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Be' yú be' alà yulök. Ikö́ka̱ ulà a̱ kë̀ arwa. Ye' tö ie' aleripa alöwe̱raë tai̱ë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Eta̱ Skëköl tö Agar a̱ di' tum kkaché et. Ie' mía̱ di' e' tsu̱k, iyiwak kkuölit a̱ e' méitö Ismael a̱ yè. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Skëköl tö Ismael kkö'né buaë. Ie' talane se̱né ká̱ wé̱ ki̱ kë̀ yi ku̱' kiè Parán ee̱. Ie' de sulëname buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ie' kibine ta̱ imì tö iulabatséwa̱ alaköl dör egiptowak ese ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","E' ké̱wö ska' ta̱ blu' kiè Abimélec mía̱ ttök Abraham ta̱. Ie' ñippökwakpa wökir, kiè Ficol, e' mí ie' wapie. Eta̱ Abimélec tö iché Abraham a̱: —Sa' wa̱ ijche̱r tö Skëköl be' ki̱meke tai̱ë ì ko̱s we̱kebö e' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","E' kue̱ki̱ be' ttè mú ye' a̱ í̱e̱ Skëköl wö wa tö be' kë̀ tö ì sulu wamblepa ye' ki̱ ñies ye' ala'r ki̱ ena ye' aleripa ko̱s e'pa ki̱. Be' ttè mú ye' a̱ tö be' e̱r bua' chöraë ye' a̱ we̱s ye' e̱r buaë ché be' a̱ es. Ñies be' ttè mú ye' a̱ tö be' e̱r buaë chöraë ká̱ i' wé̱ be' se̱rke e' wakpa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham tö iiu̱té: —Tö́. Es ye' ttè mé be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Erë Abimélec wakpa tö di' tum biule yë'ttsa̱ et Abraham wakpa ulà a̱. E' chaké Abraham tö ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ie' tö iiu̱té: —E̱rpa be' ye' tkiwé̱wa̱ ttè e' wa. Kë̀ bö ichö́pa ye' a̱, e̱'ma kë̀ ye' wa̱ ijche̱r. Brör ¿yi tö e' wamblé be' ki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham tö baka ena obeja kakmé Abimélec a̱ eta̱ ie'pa böl ka̱wö mé ñì a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","E' ukuöki̱ ta̱ Abraham tö iobeja alakipa pupula e' dapa'wé̱ döka̱ kuktö ek tsi̱ní. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Mik e' sué̱ Abimélec tö eta̱ ie' tö Abraham a̱ ichaké: —¿Ì kue̱ki̱ be' iyiwak kuktö dapa'wé̱ ek tsi̱ní? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham tö iiu̱té: —Iyiwak kuktö, e' meke ye' tö be' a̱ iwà kkachoie tö moki̱ ye' tö di' tum e' bi'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ie'pa böl ka̱wö mé ñì a̱ ee̱ e' kue̱ki̱ ká̱ e' kinewa̱ Beerseba. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ie'pa ka̱wö mé ñì a̱, e' ukuöki̱ ta̱ Abimélec ena Ficol e'pa bite̱yal filisteowak ká̱ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Eta̱ Abraham tö kal kuá kiè tamarisco ese kuatké elka Beerseba. Ee̱ ie' tö Jehová dör Skëköl yöbië e' dalöié. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ee̱ ie' se̱né ká̱ tai̱ë filisteowak ká̱ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","E' ukuöki̱ ta̱ Skëköl tö Abraham ma'wé̱ tö moki̱ ie' tö idalöieta̱'. Ie' chakéitö: —A Abraham. Abraham tö iiu̱té: —¿Ì? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Eta̱ Skëköl tö iché ia̱: —Be' alà eköl ë̀ kiè Isaac e' dalër be' é̱na tai̱ë, e' tsú̱mi Moria. Mik be' demi ee̱, eta̱ ye' tö be' a̱ ka̱bata kkacheke, e' ki̱ be' alà ttö́wa̱ ta̱ iña'ú̱wa ye' a̱ ye' dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Bule es bla'mi ta̱ Abraham e̱' kéka̱ ta̱ burro payuéitö. Bö' jchéitö tsè̱mi. Eta̱ ie' mía̱ wé̱ Skëköl tö ie' a̱ iyë' ee̱ ilà ena ikanè mésopa böl e'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","E' böiki es ta̱ Abraham tö ká̱ yëne ie' a̱ e' kí̱ sué̱ ka̱mië. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Eta̱ ie' tö iché ikanè mésopa a̱: —Í̱e̱ a' e̱' tsú̱a̱t burro i' ta̱. Ye' ena ye' alà, sa' micho ka̱bata jaì a̱ Skëköl dalöiök, e' wa sa' döne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Eta̱ Abraham wa̱ bö' mí e' ppéka̱itö Isaac kuli' ki̱. Tabela ena bö'ka bö' batsoie e' mí Abraham wa̱. Eta̱ imíyal ñita̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Eta̱ Isaac tö iché iyë́ a̱: —A, yë́wö. Abraham tö iiu̱té: —A alà, ¿ì kiane be' ki̱? Isaac tö iché ia̱: —A Yë́wö, bö' tso' se' wa̱, ñies bö'ka, erë ¿wé̱ obeja pupula ttekewa̱ Skëköl a̱ e'? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Iyë́ tö iiu̱té: —A alà, Skëköl wák tö e' meraë se' a̱. Ie'pa mir ñita̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Mik ie'pa demi wé̱ Skëköl tö iyë' Abraham a̱ ee̱, eta̱ Abraham tö ák kataté et ka̱'ie. E' ukuöki̱ ta̱ ibö' dapa'wé̱ka̱ ka̱' e' ki̱ ta̱ ilà klö'wé̱wa̱itö payuéwa̱ méka̱itö bö' bata ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","11","Ie' tabela klö'wé̱wa̱ ilà ttowa̱ ña'wè̱ Jehová a̱. E' wösha̱ ta̱ Jehová biyöchökwak bua'ie e' tö Abraham chaké siwa̱' ki̱: —¡A Abraham, a Abraham! Ie' tö iiu̱té bet: —¿Ì? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Jehová biyöchökwak bua'ie e' tö iché ia̱: —¡Be' alà kë̀ shka̱'wa̱r, kë̀ ittarwa̱! Be' wák alà eköl ë̀me e' kë̀ kkëo̱ne be' wa̱ ye' yöki̱. E' wa ye' wa̱ ijche̱r tö moki̱ be' tö ye' dalöieta̱' tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","E' wösha̱ Abraham tö isué̱ tö obeja wë'ñe e' mali̱tsé̱wa̱ idula' a̱ kal tsitsir chale a̱. Ie' tö iyiwak e' klö'wé̱wa̱ jché ña'wé̱wa ilà skéie Jehová dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ie' tö ká̱ e' kiè méka̱ i' es: “Ì kiane se' ki̱ e' mera Jehová tö.” E' kue̱ki̱ i̱'ñe ta̱ se' tö ichekeia̱: “Ì kiane se' ki̱, e' merdaë se' a̱ Jehová ké̱bata a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","16","Jehová biyöchökwak bua'ie e' tö Abraham skà kié ká̱ jaì a̱ ta̱ ichéitö ia̱: —Jehová tö iché: ‘Buaë be' tö ye' dalöieke, be' alà eköl ë̀, e' méttsa̱bö ye' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","E' kue̱ki̱ ye' e̱r buaë chöraë be' a̱ tai̱ë. Be' aleripa alöwe̱raëyö tai̱ë we̱s bëkwö tso' tai̱ë ká̱ jaì a̱ es, we̱s ttsa̱'wö tso' tai̱ë dayë kkömik es. Ñies ie'pa e̱' alöraka̱ ibolökpa ki̱ ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Be' tö ye' ttö̀ dalöié, e' kue̱ki̱ be' aleripa batamik ye' e̱r buaë chöraë ká̱ ulitane wakpa a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Eta̱ Abraham bite̱a̱ne wé̱ ikanè mésopa a̱té̱a̱t ee̱ ta̱ imíyal se̱raa̱ ñita̱ dömine Beerseba wé̱ ie' se̱rke ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","23","E' ukuöki̱ ta̱ biyö̀ debitu̱ Abraham ki̱ tö ie' ël kiè Nahor, e' alaköl kiè Milcá, e' ala'r de pàköl (8). E' alà ko'k kiè Uz. Imale̱pa kiè dör Buz, Quemuel, e' dör Aram yë́, Quésed, Hazó, Pildás, Idlaf ena Betuel e' dör Rebeca yë́. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor alaköl skà tso' kiè Reumá, e' ta̱ ie' ala'r kéka̱ tkël. E'pa kiè dör Teba, Gáham, Tahas, ena Maacá. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Mik Sara ki̱ duas tso' cien eyök kí̱ dabom böyök kí̱ kul (127), ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","eta̱ ie' blënewa̱ ká̱ kiè Quiriat-arbá a̱te̱ Canaán ee̱. Ñies ká̱ e' kiè Hebrón. Abraham schöne e' i̱e̱itséitö sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ie' tkër idëu̱tö nu o̱'mik e' e̱' kéka̱ ta̱ imía̱ ttök hititawakpa ta̱, ta̱ ichéitö ie'pa a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","—Erë́ ye' dör ká̱ kua̱'ki̱ wak se̱rke a' shu̱a̱ e' ë̀, erë ká̱ wataú̱ ña pöie ye' dëu̱tö blowa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ie'pa tö iiu̱té: ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","—A këkëpa, be' we'ikè sa' tö, sa' ttö̀ ttsö́. Sa' a̱ ta̱ be' dör këkëpa tai̱ë e' se̱rke sa' shu̱a̱. E' kue̱ki̱ be' dëu̱tö nu blö́ sa' pö bua'ie ese a̱. Sa' ulitane kë̀ tö ichepa be' a̱ tö kë̀ iblar sa' pö a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ie' e̱' duéka̱ ie'pa wörki̱ ta̱ ie' e̱' tkéwa̱ kuchë ki̱ ie'pa dalöiök ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ta̱ ichéitö ie'pa a̱: —Moki̱ a' ki̱ ikiane tö ye' dëu̱tö nu blèwa̱yö í̱e̱ a' ká̱ a̱, e' ta̱ wëm kiè Efrón dör Sóhar alà, e' a̱ ichö́ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","tö ákuk tso' ie' ká̱ kkö̀ a̱ kiè Macpelá e' wataú̱ttsa̱ ye' a̱ ye' yamipa pöie. Ye' tö ipatuè̱mi ie' a̱ ko̱s ituè̱ ekkë. Es ákuk e' a̱te̱ ye' ulà a̱ a' shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eta̱ Efrón dör hititawak e' tkërñak ie'pa shu̱a̱, e' tö Abraham iu̱té darërë a̱s iyamipa ena ko̱s daparke ká̱ e' wékkö a̱ e'pa tö ittö̀ ttsö̀. Ie' tö iché Abraham a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","—A këkëpa, kë̀ ye' tö ákuk watue̱pa be' a̱. Ká̱ e' ñies ákuk tso' ia̱, e' kakmekeyö be' a̱ ë́. Ye' yamipa ko̱s tso' í̱e̱ e'pa tö ye' ttö̀ ttsé tö ká̱ e' kakméyö be' a̱. Be' dëu̱tö nu blö́ ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Erë Abraham e̱' tkéwa̱ne kuchë ki̱ ká̱ e' wakpa wörki̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ta̱ ichéitö ie' a̱ sulitane wörki̱: —Ye' ttö̀ ttsö́. Be' pablèyö tö ká̱ e' ské klö'ú̱ ye' ulà a̱. E' ukuöki̱ ye' dëu̱tö nu blekewa̱yö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ie' tö iiu̱té: ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","—A këkëpa, ye' ttö̀ ttsö́. Ká̱ e' ské dör inuköl wömule̱ döka̱ cien tkëyök (400), erë inuköl ekkë ë̀, kë̀ e' ki̱ se' tkinuk. Be' dëu̱tö nu blö́ ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Eta̱ ko̱s ie' tö ká̱ ské ché imale̱pa wörki̱ e' mène buaë Abraham a̱, ekkë patué̱ttsa̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Es Efrón ká̱ tso' Macpelá a̱te̱ Mamré diwö tskirke e' ëka̱ e' de Abraham ulà a̱ iákuk ta̱ ena kal tso' ko̱s iki̱ e' ta̱. Hititawak ena sulitane dami ká̱ e' wékkö a̱ e'pa ko̱s dör ká̱ to̱ne e' ttekölpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","E' ukuöki̱ ta̱, Abraham tö idëu̱tö nu bléwa̱ ákuk tué̱itö Macpelá ee̱. Ká̱ e' a̱te̱ Mamré a̱te̱ Canaán e' o̱'mik tsi̱net (Mamré kiè ñies Hebrón). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ká̱ e' watué̱ttsa̱ ie' a̱ hititawak tö. Es ká̱ e' ena ákuk e' de Abraham ulà a̱ iyamipa pöie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham dewa̱ këkëpalaie. Ie' a̱ Jehová e̱r buaë ché íyi ulitane wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ká̱ et ta̱ ie' tö ikanè méso kibi kié. E' dör ie' íyi ko̱s e' kue̱blu. Ie' tö iché ia̱: —Be' ulà múwa̱ ye' tu' diki̱a̱ iwà kkachoie tö moki̱ ì kiekeyö be' a̱ e' wawe̱raëbö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Jehová dör ká̱ jaì ena ká̱ i' e' Këköl e' wörki̱ be' ttè mú ye' a̱ moki̱ë tö ye' alà kë̀ kar se̱nukwa̱ Canaán í̱e̱ se' se̱rke e' alékölpa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Be' yú ká̱ wé̱ ye' manét ee̱, eta̱ ee̱ alaköl yulö́ eköl ye' yamipa shu̱a̱ se̱nukwa̱ ye' alà ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ie' tö iiu̱té: —Dö' alaköl kë̀ bitu̱ ye' ta̱, e' ta̱ ¿we̱s ye' iwè̱mi? ¿Buaë idir be' a̱ tö be' alà mi' ye' wa̱ dö̀ wé̱ be' manét ee̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ie' iiu̱té: —¡Au, kë̀ ye' alà tsa̱rmi ee̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jehová dör ká̱ jaì Këköl, e' tö ye' yë'ttsa̱ ye' yë́ u a̱ ena ye' yamipa ká̱ a̱. Ie' tö ittè me' ye' a̱ tö ká̱ i' meraëitö ye' aleripa a̱. Ie' tö ibiyöchökwak patkeraë be' ki̱muk alaköl tsu̱kbitu̱ ye' yàkie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Alaköl kë̀ shkak be' ta̱, e' ta̱ kë̀ be' tkinuk. Kë̀ be' kàne iskà yulök. Erë kë̀ ye' alà tsa̱rmi ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Eta̱ ikanè méso ulà méwa̱ ie' tu' diki̱a̱ ta̱ ittè mé ia̱ tö iwe̱raë we̱s iu̱k patkéitö es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","E' ukuöki̱ ta̱ ie' tö iwökir íyi ko̱s bua'bua, ese shté tsè̱mi kakmè. Ekkë ko̱s payuéitö iyiwak kiè kameio e' ki̱ döka̱ dabop. Eta̱ ie' mía̱ iyiwak wëttsë tkörö Nahor a̱te̱ Mesopotamia ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Mik ie' demi tsi̱net Nahor, eta̱ ká̱ tuirketke. Diwö ekkë ta̱ ká̱ e' alékölpa mi'ke di' tsu̱k. E' wösha̱ ta̱ ie' de di' tum biule e' kkömik ta̱ ikameio kéitö e̱' tulökse̱r e̱nuk ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Eta̱ ie' tö iché Skëköl a̱: “A Jehová, be' dör ye' wökir Abraham e' Këköl. Ye' ki̱mú i̱'ñe ñies e̱r buaë chö́ ye' wökir a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Í̱e̱ di' tum biule o̱'mik ye' e̱' tsu̱kea̱t bërbër ë̀ ká̱ i' busipa tso' di' tsu̱k e' dalewa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ka̱wö mú ña tö wé̱ne ë́k a̱ ye' iché: ‘Be' kakö' ö́wa ye' a̱ di' kakmú yè’, a̱s e' tö ye' iu̱tö̀: ‘Be' di' yö́ ñies be' kameio a̱ ikakmekeyö.’ Es ye' é̱na ia̱ne tö e' ë́k shu̱shté be' tö Isaac a̱ alakölie. Es ye' wa̱ ijche̱rmi tö be' e̱r bua' ché ye' wökir a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Eta̱ ka̱m ì chekeitö e' o̱r, eta̱ ie' isué̱ alaköl datse̱ eköl kakö' bune kuli' ki̱ di' tso̱ie. E' dör Rebeca, ie' dör wëm kiè Betuel e' alà busi. Betuel mì dör Milcá ena iyë́ dör Nahor. Nahor dör Abraham ël. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeca dör busi buaala ka̱m ise̱r wëm ta̱. Ie' mía̱ döttsa̱ di' tum biule e' a̱ ikakö' wà iök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Mik imítke eta̱ Abraham kanè méso tu̱nemi itöki̱ ta̱ iché ia̱: —Be' we'ikèyö, di' dami be' wa̱ e' kakmú ña yè. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ie' tö iiu̱té, —A këkëpa, be' di' yö́. E' bet ie' kakö' éwa klö'wé̱wa̱ ulà a̱ ta̱ di' méitö ia̱ yè. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mik ie' di'yé o̱ne ta̱ Rebeca tö iché ia̱: —Ye' mí di' tsu̱k ñies mè be' kameio a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Bet ikakö' wà ka'wé̱itö wé̱ iyiwak di'yöke e' a̱ ta̱ imí di' kí̱ tsu̱k iyiwak a̱. Es iwé̱itö kameio ulitane a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","E' dalewa Abraham kanè méso tso' isa̱u̱k bë̀rë, wà dör tö ie' ki̱ ikiane jche̱nowa̱ yësyësë tö Jehová tö ie' ki̱mé ì dalërmik ie' shkö̀ e' wa a̱s idöttsa̱ buaë ö au. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Mik kameio di'yé o̱ne, eta̱ ie' tö ula'tsio sù̱ e̱s dör gramo teröl ese tkéwa̱ busi yik a̱. Ñies ulaio méitö böt, e' e̱s dör cien gramos tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Eta̱ ie' tö iché ia̱: —Be' we'ikèyö, ichö́ ña ¿Yi alà busi be' dör? ¿Ye' chö̀mi i̱'ñe nañewe be' yë́ u a̱ kapökrö ye' kanè mésopa ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ie' iiu̱té: —Ye' dör Betuel alà busi, e' dör Milcá ena Nahor alà wëm. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Sa' u a̱ a' chö̀mi. Ñies a' kameio a̱ chkè tso'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Eta̱ Abraham kanè méso e̱' tkéwa̱ kuchë ki̱ Jehová dalöiök ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ta̱ ichéitö: “Jehová dör ye' wökir Abraham e' Këköl. E' ki̱kökka̱ ye' tso'. Ke̱kraë ie' tö ye' wökir Abraham ki̱meke buaë. Ke̱kraë ie' e̱r buaë chöke ye' wökir a̱. Ie' wa̱ ye' debitu̱ buaë ñala̱ ki̱ dö̀ í̱e̱ ye' wökir yamipa u a̱. E' kue̱ki̱ iki̱kèka̱yö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebeca tu̱nemi shka̱la̱la̱ë imì u a̱ ì ko̱s tka ie' ta̱ e' pakök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ie' akë kiè Labán, e' tö ula'tsio sué̱ ena ulaio sué̱ ikutà ulà a̱. Ñies ì ché Abraham kanè méso tö e' tté ttséitö. E' kue̱ki̱ ie' bite̱a̱ iñale̱tsu̱k di' tum biule a̱. Ie' de Abraham kanè méso ska' e' tso'ia̱ ikameio ta̱ di' tum biule ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Eta̱ Labán tö iché ia̱: —Jehová tso' be' ta̱ buaë. ¡Mishka ye' ska'! ¿We̱s be' e̱' tsu̱kea̱t u'rki̱? Ye' u kanewé̱tke be' a̱ ñies kameio a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Es Abraham kanè méso bite̱a̱ ie' ta̱. Ee̱ ie' tö dalì tso' kameio ki̱ e' éwa ta̱ itiéitö. E' ukuöki̱ ta̱ ie' wa̱ di' debitu̱ Abraham kanè méso a̱ ena iwapiepa a̱ klö̀ skuoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Mik ie'pa tö itié, eta̱ Abraham kanè méso tö iché: —Kë̀ ye' chkö̀pa ka̱m ye' tö iö́k ye' debitu̱ e' wà pakö̀ a' a̱ eta̱. Labán tö iiu̱té: —E̱'ma ichö́. ¿Ì dör iwà? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ie' tö iché: —Ye' dör Abraham kanè méso. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Jehová tö iki̱mé tai̱ë. Ie' tö iblu'wé̱ tai̱ë. Obeja, baka, orochka, inukölchka, kanè mésopa wëpa ena alakölpa, kameio ena burro, e' ko̱s méitö ia̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ñies ilaköl Sara e' tö alà mé ia̱ eköl wák wëm ikënewa̱tke eta̱. Ì ko̱s tso' ye' wökir wa̱ e' méitö ilà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ie' tö ye' ké ttè muk ie' a̱. Ye' a̱ ichéitö: ‘Ye' alà kë̀ kar se̱nukwa̱ Canaán wé̱ ye' se̱rke e' alékölpa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Be' yú wé̱ ye' yë́pa tso' ee̱ ta̱ alaköl yulö́ eköl ye' yàkie ye' ditséwö shu̱a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ye' tö iiu̱té: ‘A ye' wökir Abraham, ¿dö' alaköl kë̀ bitu̱ ye' ta̱?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ie' tö ye' iu̱té: ‘Ke̱kraë ye' se̱rke buaë Jehová wöa̱, e' kue̱ki̱ ie' tö ibiyöchökwak patkeraë be' ta̱ a̱s be' ka̱wö tkö̀ buaë ñala̱ ki̱, ñies a̱s alaköl kù̱bö ye' yàkie ye' yamipa ye' yë́ wa e'pa shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Erë ye' yamipa kë̀ é̱na ilà busi patkak be' ta̱, e' ta̱ kë̀ be' tkinuk. Kë̀ ì tté ta̱'ia̱ be' ki̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","44","“E' kue̱ki̱ ye' debitu̱ i̱'ñe di' tum biule ska'. Ee̱ ye' tö ikié Jehová dör ye' wökir Abraham e' Këköl e' a̱: ‘tö moki̱ be' ye' ki̱meke alaköl yulök ye' wökir Abraham yàkie, e' ta̱ a̱s e' bitu̱ ye' ska' í̱e̱ di' tum biule ska'. Mik ye' tö ie' a̱ di' kak kié, eta̱ a̱s imùitö ye' a̱ ena ichö̀itö: Ñies ye' tö be' kameio a̱ ikakmeke. Es ye' isuè̱mi tö alaköl e' shu̱shté be' tö ye' wökir yàkie.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Mik e' chekeyö e' e̱rketke, eta̱ ye' isué̱ tö Rebeca datse̱ ikakö' bune ikuli' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Mik ie' di' yinetke eta̱ ye' tö ie' a̱ iché: ‘Be' we'ikèyö, di' dami be' wa̱ e' kakmú ña yè.’ E' bet ikakö' éwaitö ta̱ ichéitö: ‘Be' di' yö́. Ñies imekeyö be' kameio a̱.’ Ie' ye' a̱ di' mé ñies ye' kameio a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","E' ukuöki̱ ta̱ ye' tö ie' a̱ ichaké: ‘¿Yi alà busi be' dör?’ Ie' iiu̱té: ‘Ye' dör Betuel alà busi e' dör Nahor ena Milcá alà.’ Eta̱ ula'tsio sù̱ e' tkéwa̱yö iyik a̱ ena ulaio tkéwa̱yö böt iulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","E' ukuöki̱ ta̱ ye' e̱' tkéwa̱ kuchë ki̱ ta̱ Jehová dalöiéyö. Ie' dör ye' wökir Abraham e' Këköl e' ki̱kéka̱yö. Ie' wa̱ ye' debitu̱ buaë yësyësë busi shu̱kititö ye' wökir yamipa shu̱a̱ ilà a̱ e' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Es ¿a' e̱r buaë chöke ye' wökir a̱? ¿A' e̱' chöke iki̱muk e̱r bua' wa? Ichö́ ña i' ta̱ yësyësë i̱ma a' tö ichè, es ye' é̱na ia̱rmi tö ì wè̱miyö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Eta̱ Labán ena Betuel e'pa tö iiu̱té: —E̱'ma i' ko̱s debitu̱ Jehová ttö̀ wa. E' kue̱ki̱ kë̀ we̱s sa' a̱ ì o̱nuk. Kë̀ sa' a̱ ì yënuk yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","I' Rebeca. Itsú̱mi be' wökir a̱ se̱nukwa̱ ilà ta̱ we̱s Jehová ki̱ ikiane es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Mik Abraham kanè méso tö ttè e' ttsé, eta̱ ie' e̱' tkéwa̱ kuchë ki̱ iwötsa̱ méwa̱ íyök ki̱ Jehová dalöiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","E' ukuöki̱ ta̱ ie' tö íyi yöule orochka wa ena inukölchka wa ñies datsi' bua'bua e' tai̱ë yélur méitö Rebeca a̱. Ñies ie' tö ikakmé Rebeca akë a̱ ena imì a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","E' ukuöki̱ ta̱ ie' ena iwapiepa chké di'yé ta̱ ikapere ee̱. Bule es ta̱ iti̱'nerak ta̱ Abraham kanè méso tö iché: —Ye' mía̱ne ye' wökir ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Erë Rebeca akë ena imì e'pa tö iché ia̱: —Rebeca kë̀ tsa̱rmi bet. Ka̱wö mú ie' a̱ a̱s ie' e̱' tsù̱a̱t sa' ta̱ ká̱ dabop, e' wa wë' be' wa̱ imi'mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Erë ie' tö iché ie'pa a̱: —Kë̀ ye' wöklö'u̱kia̱ a' tö. Jehová tö ye' ki̱mé a̱s ì ko̱s döttsa̱ buaë ye' a̱. E' kue̱ki̱ ye' ö́mi ye' wökir u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ie'pa tö iiu̱té: —Sa' mí Rebeca kiök chakè ¿i̱ma ichèmiitö? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Eta̱ Rebeca kiérakitö ta̱ ichakérakitö ia̱: —A Rebeca ¿be' shkak wëm i' ta̱? Ie' tö iiu̱té: —Tö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Es ie'pa tö Rebeca ena alaköl tso' ie' kkö'nuk ke̱kraë e'pa a̱ ka̱wö mé a̱s imi'rak. Ñies Abraham kanè méso ena iwapiepa ko̱s e'pa a̱ ka̱wö mérakitö a̱s imi'rak. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ie'pa mitke ta̱ Rebeca yamipa e̱r buaë ché ie' a̱ ttè i' wa: “A sa' yami, A̱s be' alör tai̱ë shu̱te̱ë. A̱s be' aleripa e̱' alö̀ka̱ ibolökpa ko̱s ki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Eta̱ Rebeca ena ikanè mésopa e̱' tuléka̱ ie'pa kameio ki̱ ta̱ imíyal Abraham kanè méso itöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","E' ké̱wö ska' ta̱ Isaac se̱rke Négueb wé̱ di' tum biule tso' kiè “Skëköl tso' e' tö ye' sue̱ke” ee̱, e' dene iyë́ ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Tsá̱li̱ ta̱ Isaac e̱' yéttsa̱ shkök ka̱bikeitsörami. E' wösha̱ ta̱ ie' isué̱ tö kameio datse̱ tseë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","E' wösha̱ Rebeca tö ie' sué̱ ñies ta̱ ie' e̱' éwa kameio ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Rebeca tö ichaké Abraham kanè méso a̱: —¿Wëm doa̱ wì̱ se' kke̱, e' dör yi? Ie' iiu̱té: —E' dör ye' wökir Isaac. Eta̱ Rebeca wö pabakéwa̱ datsi'tak wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Abraham kanè méso tö ì ko̱s tka ie' ta̱ e' paké Isaac a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","E' ukuöki̱ ta̱ Rebeca mítse̱r Isaac wa̱ imì Sara blënewa̱ e' u a̱. Es Isaac se̱néwa̱ ie' ta̱. Isaac é̱na Rebeca dalër tai̱ë, es ie' e̱r pabléne imì blënewa̱ e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham alaköl ské tsé̱wa̱ kiè Queturá. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ie' ala'r kéka̱ Abraham ta̱ wëpa döka̱ teröl. E'pa kiè dör Zimrán, Jocsán, Medán, Madián, Isbac ena Súah. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jocsán dör Sebá ena Dedán, e'pa yë́. Dedán aleripa e' ditséwö döka̱ mañal kiè asurwak, letuswak ena leumwak. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madián ala'r wëpa kiè Efá, Éfer, Hanoc, Abidá ena Eldaá. E'pa ko̱s dör Queturá aleripa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Ì ko̱s tso' Abraham wa̱ e' a̱te̱ Isaac ulà a̱. Erë ka̱m Abraham duö̀wa̱, e' yöki̱ ie' tö íyi kakmé ilakölpa male̱pa ala'r a̱. Ie'pa patkémiitö se̱nuk ká̱ bánet a̱te̱ diwö tskirke e' ëka̱ ka̱mië a̱s kë̀ iku̱'rak Isaac ska' tsi̱net. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham se̱ne' duas cien eyök kí̱ dabom kulyök kí̱ ske̱l (175) se̱raa̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","eta̱ iblënewa̱ buaë ikënewa̱tke kë̀ weine sia̱rë. Es ie' michoë idëu̱töpa itöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Ila'r Isaac ena Ismael e'pa tö inú blé ilaköl Sara pö e' o̱'mik ákuk kiè Macpelá ee̱. Ákuk e' a̱te̱ Mamré diwö tskirke e' wa. Ká̱ e' bak hititawak kiè Efrón dör Sóhar alà e' ulà a̱. Ká̱ e' wato̱'ttsa̱ hititawak tö Abraham a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham blënewa̱, e' ukuöki̱ ta̱ Skëköl e̱r buaë ché Isaac a̱. Ie' e̱' tsé̱a̱t se̱nuk tsi̱net di' tum biule kiè “Skëköl tso', e' ye' sue̱ke” ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismael dör Abraham alà Agar ta̱. Agar dör Abraham alaköl Sara, e' kanè méso e' dör egiptowak. Ikkë dör Ismael ala'r e'pa kiè ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","we̱s iku̱nerak es: Nebaiot, e' dör ilà tsá̱. E' itöki̱ Quedar, Adbeel, Mibsam, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mismá, Dumá, Masá, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Temá, Jetur, Nafis ena ibata kiè Quedmá. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","E'pa ko̱s dör Ismael ala'r döka̱ dabom eyök ki̱ böl (12). Ie'pa ká̱ kiérak iwákpa kiè wa. Ie'pa ko̱s dör iwakpa ká̱ wökirpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael ki̱ duas de cien eyök kí̱ dabom mañayök kí̱ kul (137) ta̱ iblënewa̱. Es ie' michoë idëu̱töpa itöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ie' aleripa mía̱ se̱nuk Havilá ena Sur e' shu̱sha̱. Ká̱ e' a̱te̱ Egipto wösha̱ë Asiria ñalé̱ kke̱. Ie'pa se̱rke ee̱ bánet Abraham aleripa male̱pa yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ttè i' dör Isaac dör Abraham alà, e' pakè. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac ki̱ duas de dabom tkëyök (40) ta̱ ise̱néwa̱ Rebeca ta̱. Rebeca dör Betuel e' alà busi ena Labán kutà. Ie'pa dör arameowak se̱rke ká̱ kiè Padán-aram ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeca kë̀ dö̀ alàë. E' kue̱ki̱ Isaac tö Jehová a̱ ikié a̱s Rebeca dö̀ alàë. Jehová tö ittö̀ ttsé ta̱ Rebeca duneka̱ e' wakpa dör klö̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Erë klöpa ñippöke tai̱ë ie' shu̱a̱. E' kue̱ki̱ ie' ibikeitsé: “Ye' weirke i' es, e̱'ma ¿iö́k ye' se̱rmiia̱?” E' kue̱ki̱ ie' mía̱ iwà chakök Jehová a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","E' tö ie' a̱ iché: “Be' shu̱a̱ ala'r tso' böl. Mik ie'pa de këchke, eta̱ ikibi ë́k döraë itsirla kanè mésoie. Ie'pa aleripa döraë ká̱ böt ñì bolökpa ese wakpa. Itsirla aleripa döraë diché kibiie ikibi aleripa tsa̱ta̱. E' kue̱ki̱ ie'pa ñippémitke ka̱m iku̱r e' yöki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rebeca ké̱wö de, eta̱ klöpa ku̱ne wëpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ike̱we ë́k ku̱ne e' tsà̱ dör mashmash ipàkö shamamaë. Ie' kiè méka̱itö Esaú. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Alà tsá̱ ku̱ne e' klöulewa̱ iël tsirla wa̱ iklö kaniñak a̱ iulà et wa. E' kue̱ki̱ ikiè méka̱itö Jacob. Mik Rebeca klöpa ku̱ne eta̱ Isaac ki̱ duas tso' dabom teryök (60). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Klöpa kibinetke. Esaú dör yëria poë. Ie' wöbatsö sulu yëble wa. Erë iël Jacob, e' kë̀ dör es. Ie' se̱rke bë̀rë. Ie' wöbatsö se̱nuk u a̱ ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Iyiwak kañiru tteke Esaú tö e' chkà wa Isaac wöbatsö suluë. E' kue̱ki̱ Isaac ki̱ Esaú kiar kibiie Jacob tsa̱ta̱. Erë Rebeca ki̱ Jacob kiar kibiie Esaú tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ká̱ et ta̱ Jacob tso' u̱lök. E' dalewa Esaú debitu̱ shtrinewa̱ tai̱ë datse̱ kañika̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ie' iché Jacob a̱: —Be' we'ikèyö, ì alé be' tö mat se̱ kakmú ye' a̱ ñè. Sulu ye' dué bli wa̱. E' kue̱ki̱ Esaú kiè Edom ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob tö iiu̱té: —Ke̱weie ì mekea̱t se' yë́ tö be' a̱ be' dör ilà kibi e' kue̱ki̱, e' ké̱wö múttsa̱ ye' a̱ chkö̀ i' skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esaú tö iché: —Ye' tteke bli tö dö' e' tö ye' ttèwa̱, e' ta̱ ì mekea̱t se' yë́ tö ye' a̱ ¿ìie bua' e' dör ye' a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob tö ikí̱ ché ia̱: —I' ta̱ be' ttè mú ye' a̱ tö moki̱ be' tö ye' a̱ imeke. Eta̱ Esaú tö ittè mé Jacob a̱ yësyësë Skëköl wöa̱. Es ì mekea̱t iyë́ tö ie' a̱, e' ké̱wö méttsa̱itö Jacob a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jacob tö chkö̀ mé ia̱ pan ta̱. Mik Esaú chké o̱ne di' yé o̱ne, ta̱ ie' e̱' kéka̱ ta̱ imía̱. Ie' dör ilà kibi e' ulà a̱ íyi bua' ké̱wö tso', e' kë̀ ki̱ ie' tkine yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","E' ké̱wö ska' ta̱ ketba a̱ne tai̱ë ká̱ e' ko̱s ki̱ we̱s ibak Abraham ké̱wö ska' ta̱ es. E' kue̱ki̱ Isaac mía̱ Guerar wé̱ filisteowak blú se̱rke kiè Abimélec ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ee̱ Jehová e̱' kkaché ie' a̱ ta̱ ichéitö ia̱: “Kë̀ be' minuk Egipto. Be' e̱' tsú̱a̱t wé̱ ye' be' a̱ iché ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Be' se̱núia̱ ká̱ i' ki̱. Ye' tso' be' ta̱. Ye' e̱r buaë chöraë be' a̱. Ká̱ i' ko̱s meraëyö be' a̱ ñies be' aleripa a̱. Es ye' ttè muke be' a̱ we̱s ke̱we ime'yö be' yë́ Abraham a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Be' aleripa alöwe̱raëyö tai̱ë we̱s bëkwö tso' tai̱ë es. Ká̱ i' ko̱s merayö be' aleripa a̱. Ñies ie'pa batamik ye' e̱r buaë chöraë ká̱ ulitane wakpa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Abraham tö ye' ttè ko̱s e' iu̱të' buaë. Ttè mé ye' tö ie' a̱ e' ko̱s blë' buaë ie' tö e' kue̱ki̱ ye' tö ttè buaë e' meke be' a̱ ñies.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaac e̱' tsé̱a̱t se̱nuk Guerar. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ká̱ e' wakpa tö Isaac a̱ ichaké: “¿Rebeca dör be' yaie?” Erë ie' suane ichök: “Ie' dör ye' alaköl.” E' kue̱ki̱ ie' iché: “Ie' dör ye' kutà.” Ie' tö ibikeitsé tö ká̱ e' wëpa tö ie' ttèwa̱mi ilaköl buaala kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaac ki̱ ká̱ de tai̱ë ee̱. Ká̱ et ta̱, ká̱ e' blú kiè Abimélec, e' tö isué̱ ukkö tsitsir a̱ tö Isaac tso' ilaköl Rebeca peñuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Bet itsu̱k patkémiitö ta̱ ichéitö ia̱: —¿Moki̱ tö alaköl se̱ dör be' alaköl? ¿Ì kue̱ki̱ be' tö iyë' kuaë tö ie' dör be' kutà? Isaac tö iiu̱té: —Ye' ibikeitsé tö isalema a' ye' ttèwa̱mi ie' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Erë Abimélec tö iché ia̱: —¿Ì kue̱ki̱ i' wamblébö sa' ta̱? Tsir eta̱ wëm we̱le se̱néwa̱ ie' ta̱, e' ta̱ iekkë ta̱ be' tö sa' ké ì sulu wamblök Skëköl wöa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimélec tö iché sulitane a̱: —A' isie tö Isaac tsiriwé̱ ö ilaköl tsiriwé̱, e' ta̱ e' tterawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Duas e' wa Isaac tö dalì kuatké, wà wöne buaë, Jehová e̱r buaë ché ie' a̱ e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ie' de íyi blú tai̱ë. Tai̱ë íyi tso' ie' wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ie' wa̱ obeja ena baka tso' tai̱ë. Ñies kanè mésopa tso' tai̱ë ie' wa̱. E' kue̱ki̱ filisteowak e̱r ttsë'r suluë ie' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","E' kue̱ki̱ ie'pa tö di' tum bi' iyë́ Abraham e' kanè mésopa tö, e' ko̱s wötéwa̱ íyök wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Bata ekkë ta̱ Abimélec tö iché Isaac a̱: —Be' yöne íyi blu' tai̱ë sa' tsa̱ta̱, e' kue̱ki̱ ¡be' yúshka! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Eta̱ Isaac mía̱ se̱nuk Guerar ka̱kkue ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ee̱ di' tum bi' iyë́ tö, e' wötë'wa̱ filisteowak tö iyë́ blënewa̱ ukuöki̱ ta̱, e' ko̱s biéneitö ta̱ ikiè méka̱itö we̱s iyë́ tö ime'ka̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ká̱ et ta̱ ie' kanè mésopa tso' di' tum biök ká̱ e' ki̱, eta̱ ie'pa tö di' tum a̱ di' tuökeka̱ tai̱ë ese kué̱ et. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Erë ká̱ e' obeja kkö'nukwakpa debitu̱ ñippök Isaac obeja kkö'nukwakpa ta̱. Ie'pa tö iché tö di' tum e' dör ie'pa icha. E' kue̱ki̱ Isaac tö di' tum biule e' kiè méka̱ “Ñippök.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","E' ukuöki̱ ta̱ Isaac kanè mésopa di' tum skà bié et, e' ki̱ iskà ñippérak. E' kue̱ki̱ di' tum biule e' kiè méka̱itö “Se' ñì bolök.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ie' mía̱ ka̱mië ká̱ e' ki̱, ee̱ di' tum skà biéitö et. E' kë̀ ki̱ iñi bunerak. Ie' iché: “I̱'ñe ta̱ Jehová tö ká̱ bua' mé se' a̱ wë' ta̱ se' se̱rdaë buaë.” E' kue̱ki̱ ká̱ e' kiè méka̱itö “Ká̱ tso' tai̱ë se' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","E' ukuöki̱ ta̱ ie' mía̱ Beerseba. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","E' nañewe Jehová de ie' ska' ta̱ ichéitö ia̱: “Ye' dör be' yë́ Abraham e' Këköl. Ye' tso' be' ta̱, e' kue̱ki̱ kë̀ be' suanuk. Abraham dör ye' kanè méso e' dalërmik ye' e̱r buaë chöraë be' a̱, ñies be' aleripa alöwe̱raëyö tai̱ë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ee̱ Isaac tö ák kataté et ka̱'ie iyiwak jchoie Jehová dalöioie. Ee̱ ie' se̱né ta̱ ikanè mésopa tö di' tum bié et ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ká̱ et ta̱, Abimélec datse̱ Guerar debitu̱ ttök Isaac ta̱. Iyamipa debitu̱ böl ie' ta̱. Eköl kiè Ahuzat. Iëköl kiè Ficol. E' dör Abimélec ñippökwakpa wökir. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac tö iché ia̱: —A' é̱na ye' a̱r suluë. A' ye' yö'shkar a' ká̱ ki̱. Eta̱ ¿iö́k a' do ye' ska'? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ie'pa tö iiu̱té: —Sa' isué̱ tö Jehová tso' be' ta̱. E' kue̱ki̱ sa' bite̱a̱ be' a̱ ichök tö ka̱wö mùwa̱sö ñita̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Sa' kë̀ wa̱ be' tsirio̱ule ì wa. Ke̱kraë sa' tö be' ki̱mé. Mik be' manetwa̱, eta̱ sa' kë̀ wa̱ ì tté ku̱' a' ki̱. I̱'ñe ta̱ iwënewa̱ tö be' a̱ Jehová e̱r buaë chöke tai̱ë. E' kue̱ki̱ be' ttè mú sa' a̱ tö be' kë̀ tö ì sulu wamblepa sa' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Eta̱ Isaac tö ka̱wö buaë tkö'wé̱ ie'pa ta̱, chkè wa di'yè wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Bule es bla'mi ta̱ ie'pa tö ika̱wö mé ñì a̱ tö kë̀ ñippöia̱rak. E' ukuöki̱ ta̱ ie'pa e̱' chéa̱t ñì a̱ e̱r bua' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","E' diwö shà̱ ta̱ Isaac kanè mésopa tso' di' biök, e'pa wa̱ ibiyö́ de tö sa' di' kué̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ie' tö di' e' kiè méka̱ Sebá. E' kue̱ki̱ i̱'ñe ta̱ ká̱ e' kièia̱ Beerseba. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Mik Esaú ki̱ duas de dabom tkëyök (40), eta̱ ie' se̱néwa̱ alakölpa böl ta̱. Eköl kiè Judit e' yë́ kiè Beerí, e' dör hititawak. Iëköl kiè Basemat e' yë́ kiè Elón, e' dör hititawak ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Alakölpa böl e'pa tö Isaac ena Rebeca e̱riawé̱ka̱ tsiriwé̱ka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac dewa̱ këkëpalatke. Ie' kë̀ wöbla wawëria̱. Ká̱ et ta̱ ilà kibi Esaú e' kiéitö ta̱ ichéitö ia̱: —¡A alà! Esaú tö iiu̱té: —A yë́wö, ¿ì? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Eta̱ Isaac iché ia̱: —Be' tö isué̱ tö ye' kënewa̱tke dö' we̱kkë alè ta̱ ye' duö̀wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","E' kue̱ki̱ ye' ki̱ ikiane tö be' kuaböt klö'ú̱ ta̱ be' yú ye' a̱ yëblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Eta̱ iwakaneú̱ ña buaë we̱s ye' wöbatsö iwa es, ta̱ itsú̱bitu̱ ña katè. E' wa ye' e̱r buaë chöke be' a̱ ka̱m ye' duö̀wa̱ e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Erë Isaac ttöke Esaú ta̱ e' ttsé Rebeca tö. E' kue̱ki̱ mik Esaú mía̱ yëblök kañika̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","eta̱ bet ie' tö iché Jacob a̱: —A alà, ye' ttö̀ ttsö́. Ye' tö be' yë́ ttsé ttök be' ël Esaú ta̱, ta̱ iché ia̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Be' yú yëblök, e' wakaneú̱ ña buaë ta̱ itsú̱bitu̱ ña katè. E' ukuöki̱ ta̱ ye' tö be' a̱ íyi ko̱s bua' e' ké̱wö mekeyö be' a̱ Jehová wörki̱ ka̱m ye' duö̀wa̱ e' yöki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","E' kue̱ki̱ ye' ttö̀ ttsö́ buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Be' yú chibo pupula bua'bua ese tsú̱bitu̱ ña bötö ta̱ ikanewe̱keyö buaë we̱s be' yë́ wöbatsö iwa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","E' ukuöki̱ ta̱ be' tö chkè tsú̱mi be' yë́ a̱ a̱s iñuitö. Es íyi ko̱s e' ké̱wö a̱tmi be' a̱ be' ël skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Erë Jacob tö iché imì a̱: —Ye' ël pa shamamaë. Ye' kë̀ dör es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ye' yë́ tö ye' kèmi, e' ta̱ ittsèwa̱mi tö ye' idir, eta̱ ie' ichèmi tö ye' tso' ie' dalöse̱u̱kwa̱. Ie' kë̀ e̱r buaë chepa ye' a̱. E' skéie ie' e̱r sulu chöraë ye' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Erë imì tö iiu̱té: —A alà, a̱s ie' e̱r sulu chö̀ ye' ki̱. Ye' ttö̀ iu̱tö́. Be' yú chibola chéyö be' a̱ e' tsu̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Eta̱ Jacob mía̱ chibola tsu̱k e' debitu̱ iwa̱ imì a̱. E' kanewé̱ imì tö buaë we̱s Isaac wöbatsö iwa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ilà kibi Esaú datsi' tso' blëule u a̱ e' bua'bua yéttsa̱ iéka̱itö ilà tsirla ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","E' ukuöki̱ ta̱ chibola kkuölit wa Jacob ulà ena ikuli' patréwa̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Chkö̀ bua' ena pan yuétkeitö, e' méitö Jacob a̱ tsè̱mi iyë́ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jacob dewa̱ iyë́ ska' ta̱ ichéitö ia̱: —A yë́wö. Isaac tö iiu̱té: —A alà, ¿be' dör ye' alà wé̱ne ë́k? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ie' iiu̱té: —Ye' dör Esaú, be' alà kibi ë́k. Ì chébö ña, e' kanewé̱tkeyö. Be' e̱' tkö́se̱r iyiwak ttéyö e' katök. E' ukuöki̱ ta̱ be' íyi buaë e' ké̱wö mekebö ye' a̱, e' mú ye' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Erë Isaac tö ichaké ia̱: —A alà, ¿we̱s be' ulà de iyiwak e' ska' bet? Ie' iiu̱té: —Jehová dör be' Këköl e' tö ye' ki̱mé e' wa ikué̱wa̱yö bet. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaac tö iché ia̱: —Be' e̱' skö́wa̱ ye' o̱'mik pattsèyö tö moki̱ë be' dör ye' alà Esaú. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ie' e̱' skéwa̱ iyë́ o̱'mik a̱s ipattsö̀itö. Isaac tö iché: —Be' ttö̀ e' dör Jacob ttö̀. Erë be' ulà e' dör Esaú ulà. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Jacob ulà kö̀ shamamaë we̱s iël kibi ulà es, e' kue̱ki̱ Isaac kë̀ é̱na ia̱ne buaë tö e' dör Jacob. Mik ie' e̱r buaë chöketke ilà a̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","eta̱ iskà chakéneitö: —¿Moki̱ be' dör ye' alà Esaú? Ie' iiu̱té: —Tö́, ye' dör Esaú. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Iyë́ tö iché ia̱: —A alà, iyiwak ttébö kanewé̱bö e' mú ña katè a̱s ye' e̱r buaë chö̀ be' a̱. Ie' tö iyë́ tié ñies vino mé ia̱ yè. Isaac chké, vino yé. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","E' ukuöki̱ ta̱ ichéitö ia̱: —A alà, be' e̱' skö́wa̱ ye' o̱'mik ye' wöalattsö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Mik Jacob e̱' skéwa̱ iyë́ wöalattsök, eta̱ iyë́ tö idatsi' alattsé ta̱ ie̱r buaë ché ilà a̱ ttè ikkë wa: “Tö́, ipaalar we̱s ye' alà paalar es. Ie' paalar buaë we̱s kañika̱ kkö'nè Jehová tö e' alar ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","A̱s Skëköl tö be' a̱ mò wöli mè ke̱kraë be' dalikua ki̱. A̱s ie' tö be' dalikua ko̱s e' wöù̱ buaë a̱s be' wa̱ trigowö ta̱' tai̱ë ena vino ta̱' tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ká̱ kua̱'ki̱ wakpa tai̱ë a̱s e' dö̀ be' kanè mésopaie. A̱s ie'pa e̱' tulö̀wa̱rak kuchë ki̱ be' wörki̱ be' dalöiök. A̱s be' mú dö̀ be' ëlpa wökirie. A̱s ie'pa e̱' tulö̀wa̱ kuchë ki̱ be' wörki̱ be' dalöiök. Wé̱pa e̱r sulu ché be' ki̱, esepa ki̱ Skëköl e̱r sulu ské chöraë. Ñies wé̱pa e̱r buaë ché be' a̱, esepa a̱ Skëköl e̱r buaë ské chöraë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaac e̱r buaë chétke Jacob a̱ ta̱ Jacob mía̱tke. E' bet ta̱ Esaú tso' yëblök e' dene. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ñies ie' tö chkè alé buaë, e' mí iwa̱ iyë́ a̱ ta̱ ichéitö ia̱: —A yë́wö, dúla ttéyö e' alí katö́. E' ukuöki̱ ta̱ be' e̱r buaë chöke ye' a̱ e' chö́ ña. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaac tö ichaké: —¿Yi dör be'? Ilà tö iiu̱té: —Ye' dör Esaú be' alà kibi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac tkinewa̱ painéka̱ tai̱ë ta̱ ichéitö: —E̱'ma ¿yi dare yëblök, e' wa̱ chkè debitu̱ ña? E' katéwayö se̱raa̱ ka̱m be' dö̀ e' yöki̱. E' a̱ ye' e̱r buaë chétke. Es ie' a̱ ye' e̱r buaë chè e' a̱te̱tke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Mik Esaú tö ì ché iyë́ tö e' ttsé, eta̱ ie' e̱rianeka̱ a̱neka̱ tai̱ë ta̱ ichéitö: —¡A yë́wö, ye' a̱ e̱r buaë chö́ ñies! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Erë Isaac tö iiu̱té: —Be' ël datke ye' ki̱tö'u̱k e' a̱ ye' e̱r buaë chétke be' skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esaú tö iiu̱té: —Wëe' ie' kiè Jacob. I' ta̱ bötökicha iwambléitö ye' ta̱ i' es. Be' íyi ké̱wö mekebö ye' a̱ ye' dör be' alà kibi e' kue̱ki̱, e' ké̱wö yë'ttsa̱ ye' ulà a̱ ie' tö kuaë. I̱'ñe ta̱ be' e̱r buaë chöke ye' a̱ e' yéttsa̱itö ye' yöki̱. ¿Warma be' e̱r buaë chöke ye' a̱ e' kë̀ ta̱'ia̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac tö iiu̱té: —Ittsö́. Ye' tö ie' méka̱tke be' wökirie. Ye' tö be' aleripa ko̱s e' métke ie' kanè mésopaie. Ñies ye' tö ichétke a̱s chkewö ena vino dö̀ ie' ulà a̱ tai̱ë. A alà, ¿ì memiia̱ ye' tö be' a̱ i' ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Erë Esaú tö ikí̱ ché iyë́ a̱: —A yë́wö ¿be' e̱r buaë chöke sa' a̱ e' dör etkë̀? ¡Ye' a̱ e̱r buaë chö́ ñies! Eta̱ Esaú i̱é̱ka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaac tö iché ia̱: “Be' se̱rdaë wé̱ mò wöli kë̀ ta̱' tai̱ë ese ska'. Ee̱ be' dalikua kë̀ wörpa buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Be' ñippöraë tabè wa o̱'ka ta̱ iíyi kue̱ki̱, e' mik be' se̱rdaë. Be' döraë be' ël kanè mésoie. Erë mik be' ñippémi ie' ta̱, eta̱ be' e̱' yörattsa̱ ie' ulà a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Isaac e̱r buaë ché Jacob a̱ Esaú skéie. E' kue̱ki̱ Esaú é̱na suluë Jacob a̱rke. Ie' ibikeitsé: “Ye' yë́ duökewa̱tke. Mik iduowa̱ e' ké̱wö tka, eta̱ ye' ël tterawa̱yö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Mik Rebeca wa̱ ijche̱newa̱ tö Esaú tö iël bikeitsé ttèwa̱, eta̱ Jacob tsu̱k patkéitö ta̱ iché ia̱: —A alà, ittsö́. Be' ël Esaú e̱' pablöke tö ie' be' tterawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","E' kue̱ki̱ ye' ttö̀ ttsö́. Be' tkö́shkar bet ye' akë kiè Labán se̱rke Harán e' u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","45","Be' e̱' tsú̱a̱t ie' ska' ká̱ tai̱ë dö̀ mik be' ël e̱r buanene be' ki̱ ena ì sulu wamblébö e' chowane ie' é̱na eta̱. E' ukuöki̱ ta̱ ye' tö be' tsu̱k patkeraë, e' wa be' döne. ¡Ye' kë̀ ki̱ ikiane tö ye' ala'r böl e' duö̀wa̱ diwö etkë̀ a̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","E' ukuöki̱ ta̱ Rebeca tö iché Isaac a̱: —Esaú alakölpa dör hititawak e'pa tö ye' shtriwé̱tke tai̱ë. Jacob se̱néwa̱ alaköl ese ta̱, e' ta̱ ye' mú duö̀wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Eta̱ Isaac tö Jacob kié ta̱ ishke̱'wé̱itö ta̱ ichéitö ia̱: —Kë̀ be' se̱nukwa̱ canaánwak ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Be' yú be' duöchke kiè Betuel se̱rke Padán-aram e' ska'. Ee̱ be' se̱núwa̱ be' nau̱ Labán alà busipa e' eköl ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Skëköl Diché Ta̱' Íyi Ulitane Tsa̱ta̱ a̱s e' e̱r buaë chö̀ be' a̱. Ñies a̱s ie' tö be' aleripa alöù̱ tai̱ë ká̱ wa'ñe. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ie' tö iyë'a̱tbak Abraham a̱ tö ká̱ i' meraëitö ie' a̱. E' ki̱ se' se̱rke shkal. A̱s ie' e̱r buaë chö̀ be' a̱ ena be' aleripa a̱ we̱s ie' e̱r buaë yë' Abraham a̱ es a̱s ká̱ i' dö̀ a' ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Es Isaac tö Jacob patkémi Padán-aram. Jacob demi inau̱ Labán ska'. Labán dör arameowak kiè Betuel, e' alà. Ie' dör Rebeca akë. Rebeca dör Jacob ena Esaú e'pa mì. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaú wa̱ ijche̱newa̱ tö Isaac e̱r buaë ché Jacob a̱ ñies tö ipatkémiitö ká̱ kiè Padán-aram se̱nukwa̱ ee̱. Ñies ie' wa̱ ijche̱newa̱ tö mik iyë́ e̱r bua' ché Jacob a̱ eta̱ ichéitö ia̱: —Kë̀ be' se̱nukwa̱ canaánwak ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ñies ie' wa̱ ijche̱newa̱ tö Jacob mía̱ ká̱ kiè Padán-aram we̱s iyë́ ena imì tö iché ia̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Es ie' é̱na ia̱ne tö iyë́ kë̀ ki̱ ikiane tö ie'pa se̱rwa̱ canaánwakpa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","E' kue̱ki̱ ie' mía̱ alaköl skà yulök Ismael dör Abraham alà e' ska'. Ee̱ ie' se̱néwa̱ Ismael alà busi kiè Mahalat e' ta̱, e' dör Nebaiot kutà. Es alaköl kí̱ tsé̱wa̱itö eköl e' kë̀ dör canaánwak we̱s imale̱pa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Eta̱ Jacob e̱' yéttsa̱ Beerseba michoë Harán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ie' michoë wé̱ ka̱tuine iki̱ ta̱ ee̱ ikapere. Ák méwa̱itö wökir kataie, e' ki̱ ie' kapöwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ee̱ ie' kabsué̱. Ie' isué̱ tö klökata batsì̱ë tkër i̱ski̱ ibata döka̱ ká̱ jaì a̱. E' ki̱ ie' isué̱ tö Skëköl biyöchökwakpa shköke wo̱'k wa'k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ñies ie' isué̱ tö Jehová dur ie' o̱'mik ta̱ ichéitö ia̱: “Ye' dör Jehová. Ye' dör be' talà, Abraham, ena be' yë́, Isaac, e'pa Këköl. Ká̱ i' wé̱ be' tër, e' meraëyö be' a̱ ena be' aleripa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ie'pa alördaë tai̱ë we̱s ká̱ po es. Ie'pa michoë se̱nuk ká̱ wa'ñe. Ye' e̱r buaë chöraë ká̱ ulitane wakpa a̱ be' ena be' aleripa e'pa batamik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ye' tso' be' ta̱. Ye' tö be' kkö'neraë ká̱ wa'ñe wé̱ be' mir ee̱. Be' dörane ye' wa̱ ká̱ i' ki̱. Kë̀ yö be' we'ikepa. Ttè ko̱s méyö be' a̱, e' wawe̱raëyö es.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Mik Jacob ti̱'neka̱, eta̱ ie' ibikeitsé: “Moki̱ Jehová tso' ká̱ i' ki̱, e' kë̀ jche̱r ye' wa̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Tai̱ë ie' suane ta̱ ibikeitséitö: “Ká̱ i' dör batse'r tai̱ë. ¡Í̱e̱ dör Skëköl wé! ¡Í̱e̱ dör ká̱ jaì wékkö!” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Bule es ta̱ Jacob e̱' kéka̱ bla'mi. Ák méwa̱itö iwökir kataie, e' kéka̱itö duéka̱a̱titö iwà kkachoie tö ká̱ e' dör batse'r. Kiö̀ téitö ák bata ki̱ iwà kkachoie tö ká̱ e' tso' Skëköl dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ká̱ e' kiè mane'wé̱ttsa̱ne ie' tö Betel Ke̱we ta̱ ká̱ e' kiè Luz. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ee̱ ie' tö ittè mé Jehová a̱ i' es: “Be' tso' ye' ta̱ ena ye' kkö'né be' tö i' ye' mir eta̱, ena be' tö chkè ena datsi' mé ye' a̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ñies ye' dene buaë ye' yë́ ska', e' ko̱s wé̱bö ye' a̱, e' ta̱ be' klö'we̱raëyö ye' Këkölie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ák duéka̱yö i', e' dör iwà kkachoie tö í̱e̱ be' dalöiërdaë. A Skëköl, ì ko̱s mekebö ye' a̱, e' mú blatèsö döka̱ dabop ta̱ e' tsá̱ eyök meraneyö be' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","E' ukuöki̱ ta̱, Jacob mía̱ pë' se̱rke diwö tskirke e' ëka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ee̱ ie' tö di' tum biule sué̱ et kañika̱. E' pamik obeja daparke mañayök e̱nuk ee̱ di' e' yekerakitö e' kue̱ki̱. Di' tum biule kkö̀ ki̱ ákkue bërie me'r et. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Iyiwak kkö'nukwakpa wöblanewa̱tke tö a̱s iyiwak ulitane daparka̱ ee̱, e' ukuöki̱ ta̱ ákkue skeu̱ke di' tum biule kkö̀ ki̱ a̱s iyiwak di'yö̀. Iyiwak di'yane o̱ne ta̱ ie'pa tö ikkö̀ pabakéwa̱ne ákkue wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob tö iyiwak kkö'nukwakpa a̱ ichaké: —A yamipa, ¿ká̱ wé̱ wakpa a' dör? Ie'pa tö iiu̱té: —Sa' dör Harán wakpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ie' tö iskà chakéne: —¿A' wa̱ wëm kiè Labán dör Nahor alà, e' su̱ule? Ie'pa tö iiu̱té: —Tö́, e' su̱ule sa' wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ie' tö ichaké: —¿Is ie' tso'? Ie'pa tö iiu̱té: —Ie' tso' bua'. Isa̱ú̱. Wì̱ busi datse̱ e' dör ie' alà kiè Raquel e'. Ie' datse̱ iyë́ iyiwak wëttsë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ie' tö iché: —Ká̱ tso'ia̱ ñiwe. Diwö tso'ia̱ ka̱kke̱ë iyiwak dapa'wo̱wa̱ ek tsi̱ní. Ì kue̱ki̱ a' kë̀ tö di' mè ia̱ ta̱ ièmirak chkök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Erë ie'pa tö iiu̱té: —Kë̀ sa' a̱ e' wamblënuk. Sa' ka̱wöta̱ ipanuk. Mik obeja de se̱raa̱, eta̱ sa' tö di' tum kkö̀ ppekeka̱ ta̱ di' meke sa' tö iyiwak a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ie' ttöke ie'pa ta̱, e' dalewa Raquel debitu̱ iyë́ iyiwak wëttsë, ie' dör iyë́ iyiwak kkö'nukwak e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jacob tö Raquel sué̱ inau̱ iyiwak wëttsë, e' bet ie' tu̱nemi di' kkö̀ kéka̱ ta̱ iyiwak a̱ di' méitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","E' ukuöki̱ ta̱ Raquel shke̱'wé̱itö wöalatséitö ta̱ ie' i̱é̱ka̱ie ttsë'ne buaë kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ie' tö iché ia̱: “Ye' dör Rebeca alà ena Labán nau̱yö.” E' bet ta̱ Raquel tu̱nemi ichök iyë́ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Mik Labán tö inau̱yök tté ttsé, eta̱ bet itu̱nemi iñale̱tsu̱k. Ipaklö'wé̱wa̱itö ta̱ iwöalattséitö ta̱ imítse̱r iwa̱ iu a̱. Ì ko̱s tka Jacob ta̱ e' pakéitö inau̱ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","17","Ta̱ Labán tö iché ia̱: “Moki̱ë be' dör ye' yami e̱kka.” Labán alà busi böl, ikibi ë́k kiè Lía, itsirla ë́k kiè Raquel. Lía wöbla e' kë̀ dör buaala erë Raquel dör buaala wa'ñe. Jacob se̱né Labán ska' dö̀ si' et. E' ukuöki̱ ta̱ Labán tö iché ia̱: —Be' dör ye' yami, erë be' kë̀ ka̱wöta̱ kaneblök ye' a̱ ë́me. Ichö́ ña ¿ko̱s be' tö ye' ña'wè̱mi? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob wöbatse Raquel wa, e' kue̱ki̱ ie' tö Labán iu̱té: —Be' tö ka̱wö mé ye' a̱ se̱nukwa̱ Raquel ta̱, e' ta̱ e' skéie ye' kaneblöke be' a̱ döka̱ duas kul. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labán tö iiu̱té: —Ye' a̱ ta̱ e' dör buaë. Be' je' a̱ ye' tö imèmi buaë. Ye' kë̀ é̱na imak o̱'ka a̱. Be' e̱' tsú̱a̱t ye' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Es Jacob kaneblë' döka̱ duas kul Raquel dalërmik. Erë ie' ki̱ Raquel kiane tai̱ë, e' kue̱ki̱ ka̱wö ekkë e' ttséitö ká̱ bërbër ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Mik duas kul tka, eta̱ Jacob tö iché Labán a̱: —Ka̱wö yë'yö be' a̱, e' detke. Ka̱wö mú ye' a̱ se̱nukwa̱ be' alà busi Raquel ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Eta̱ Labán tö sulitane a̱ ishke̱ñé tö a' shkö́ ulabatsè e' ké̱wö tkö'u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Erë ka̱tuine, e' shu̱a̱ Lía mí ie' wa̱ Jacob a̱ Raquel skéie ta̱ Jacob kapé ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labán tö ikanè méso eka kiè Zilpá, e' me'tke Lía a̱ ikanè mésoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Bule es bla'mi ta̱ Jacob tö isué̱wa̱ tö e' dör Lía. Ie' mía̱ Labán ska' ta̱ ichéitö ia̱: —¿Ì wamblé be' tö ye' ta̱? Ye' kaneblé be' a̱ Raquel dalërmik. ¿Iö́k be' tö ye' ki̱tö'wé̱ es? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labán tö iiu̱té: —Í̱e̱ sa' wöblar tö alà busi kibi ese se̱rkewa̱ ke̱weie, e' itöki̱ itsirla ë́k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Se' ka̱wöta̱ Lía ulabatsöke e' ké̱wö tkö'u̱k döka̱ ká̱ kul. Mik ké̱wö e' tka, eta̱ ye' tö be' a̱ Raquel meke ñies. Erë be' ka̱wöta̱ skà kaneblökne ye' a̱ duas kul Raquel dalërmik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","E' dör buaë Jacob a̱. Mik Lía ulabatsè ké̱wö e' diwö tka, eta̱ Labán tö Raquel mé Jacob a̱ alakölie ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ñies ie' tö ikanè méso eka kiè Bilhá e' mé Raquel a̱ ikanè mésoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Es Jacob se̱néwa̱ Raquel ta̱ ñies. Erë́ ie' ka̱wöta̱ kaneblökne skà Labán a̱ döka̱ duas kul, erë ie' é̱na idalër kibiie Lía tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jehová tö isué̱ tö Jacob kë̀ ki̱ Lía kiane bua'ie. E' kue̱ki̱ Lía a̱ alà méitö. Erë Raquel kë̀ döta̱' alàë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lía duneka̱ alà ku̱ne ta̱ ie' tö iché: “Ye' e̱riarke tai̱ë e' sué̱ Jehová tö, e' kue̱ki̱ i̱'ñe ta̱ ye' dalërdaë ye' wëm é̱na.” E' kue̱ki̱ ikiè méka̱itö Rubén. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","E' ukuöki̱ ta̱ ie' alà skà ku̱ne eköl ta̱ ichéitö: “Ye' wëm kë̀ tkine ye' ki̱ e' sué̱ Jehová tö e' kue̱ki̱ alà skà méitö ye' a̱.” E' kue̱ki̱ ikiè méka̱itö Simeón. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ie' alà skà kéka̱ ta̱ ichéitö: “Ire' ye' ala'r deka̱ mañal e' kue̱ki̱ ye' wëm é̱na ye' dalërmi kibiie.” E' kue̱ki̱ ikiè méka̱itö Leví. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","E' ukuöki̱ ta̱ ie' alà skà kéka̱ ta̱ ichéitö: “I̱'ñe ta̱ ye' tö Jehová ki̱kekeka̱.” E' kue̱ki̱ ikiè méka̱itö Judá. Eta̱ ekkë ë̀ ie' alà dë'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Mik Raquel tö isué̱ tö ie' kë̀ dö̀ alàë, eta̱ ie' sibineka̱ iël ki̱. Ie' tö iché iwëm a̱: —Be' kë̀ tö ye' a̱ alà mè, e' ta̱ ye' duörawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob uluneka̱ ie' ki̱ ta̱ ichéitö ia̱: —Ye' dör Skëköl kalì, e̱'ma ye' a̱ alà mermi be' a̱. Ie' wák tö be' méa̱t kë̀ dö̀ alàë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ie' tö iiu̱té: —Ittsö́, ye' kanè méso kiè Bilhá, e' ta̱ be' se̱nú. Mik ie' alà kéka̱ eta̱ e' dör we̱s ye' alà es. Es ye' döraë alàë ie' batamik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Es ie' tö ikanè méso Bilhá e' mé iwëm a̱ alakölie, e' ta̱ Jacob se̱né. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ie' ta̱ Jacob alà kéka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Raquel tö iché: “Skëköl tö ye' tsa̱tké buaë. Ie' tö ye' ttö̀ ttsé ta̱ alà méitö ye' a̱ wëm.” E' kue̱ki̱ ie' tö ikiè méka̱ Dan. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","E' ukuöki̱ ta̱ Bilhá alà skà ku̱ne Jacob ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raquel tö iché: “Ye' ñippé tai̱ë ye' ël ta̱ eta̱ ye' e̱' aléka̱ iki̱.” E' kue̱ki̱ ikiè méka̱itö Neftalí. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Mik Lía tö isué̱ tö ie' kë̀ dë'ia̱ alàë, eta̱ ie' tö ikanè méso kiè Zilpá, e' mé Jacob a̱ alakölie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpá alà kéka̱ Jacob ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lía tö iché: “¡Edaa̱ ì mène ye' a̱!” E' kue̱ki̱ ilà kiè méka̱itö Gad. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","E' ukuöki̱ ta̱ Zilpá alà skà kéka̱ Jacob ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lía tö iché: “¡Ye' ttsë'r buaë! Ire' alakölpa ko̱s tö icheraë tö be' ttsë'r buaë.” E' kue̱ki̱ ilà kiè méka̱itö Aser. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Trigo wö alirke e' ké̱ska' ta̱ Rubén mía̱ kañika̱. Ee̱ ie' tö kalwö kiè mandrágora e' alí kué̱. E' bite̱ iwa̱ imì Lía a̱. Mik Raquel tö kalwö e' sué̱ ta̱ ichéitö Lía a̱: —Be' we'ikèyö, kalwö debitu̱ be' alà wa̱ be' a̱, e' kakmú ña. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lía tö iiu̱té: —¿Be' kë̀ a̱ wë' idir tö be' wa̱ ye' wëm mítse̱r? ¡Kí̱ie ta̱ be' é̱na kalwö debitu̱ ye' alà wa̱ ye' a̱, e' yaktsa̱ ye' ulà a̱! Erë Raquel tö iché ia̱: —Kalwö e' skéie i̱'ñe nañewe ye' wëm patkekeyö be' ta̱ kapök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ka̱tuirketke ta̱ Jacob tso' kaneblök e' debitu̱ ta̱ Lía mía̱ iñale̱tsu̱k ta̱ ichéitö ia̱: —Ye' tö ye' alà mandrágora e' mé Raquel a̱, e' skéie be' ka̱wöta̱ kapök ye' ta̱ i̱'ñe nañewe. E' nañewe Jacob kapé ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Eta̱ Skëköl tö Lía ttö̀ ttsé ta̱ iduneka̱ ta̱ ilà skà ku̱ne Jacob ta̱. Es ie' alà deka̱ ske̱l. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lía tö iché: “Ye' tö ye' kanè méso mé ye' wëm a̱ e' skéie Skëköl ye' a̱ alà i' mé.” E' kue̱ki̱ ilà kiè méka̱itö Isacar. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","E' ukuöki̱ ta̱ Lía alà skà kéka̱ Jacob ta̱, e' ta̱ ideka̱ teröl. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ie' iché: “Skëköl tö ye' a̱ ì buaë kakmé. Ire' ye' ala'r de teröl. E' kue̱ki̱ ye' wëm é̱na ye' dalërdaë jaishe̱t.” E' kue̱ki̱ ilà kiè méka̱itö Zabulón. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Bata ekkë ta̱ ie' alà skà ku̱ne alaköl. E' kiè méka̱itö Dina. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Erë ñies Raquel ki̱mé Skëköl tö. Ie' tö ala'r mé ia̱ we̱s Raquel tö ikié ia̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ie' duneka̱ ta̱ ilà tsá̱ ku̱ne kiè méka̱itö José. Ie' tö iché: “Ye' jaëne' sia̱rë e' yéttsa̱ Skëköl tö ye' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Jehová mú tö ye' a̱ alà kí̱ mè ia̱ eköl.” E' kue̱ki̱ ikiè méka̱itö José. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","José ku̱ne e' ukuöki̱ ta̱ Jacob tö iché Labán a̱: —Ye' ö́mine ye' ka̱ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ye' alakölpa ena ye' ala'r e'pa mú ye' a̱ a̱s imi'rak ye' ta̱. Ye' kaneblétke be' a̱ ie'pa skéie. Be' wa̱ ijche̱r buaë tö ko̱s ye' kaneblé be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Erë Labán tö iiu̱té: —Be' we'ikèyö. Be' e̱' tsú̱a̱tia̱ se̱nuk ye' ska'. Ye' tö itötké tö Jehová e̱r buaë ché ye' a̱ be' batamik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ichö́ ña ko̱s be' ki̱ inuköl kiane be' kanè skéie, e̱'ma ekkë ye' be' patuè̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ie' tö iiu̱té: —Be' wa̱ ijche̱r tö ye' kaneblé buaë be' a̱. Ñies ye' tö be' iyiwak kkö'né buaë be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Mik ye' dë'bitu̱ be' ska', eta̱ be' kë̀ wa̱ ì ku̱' tai̱ë. I̱'ñe ta̱ be' wa̱ íyi tso' tai̱ë. Jehová e̱r buaë ché be' a̱ ye' kue̱ki̱. Erë ¿mik ye' kaneblö̀mi ye' wák a̱? Ye' wöché yamipaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labán tö iskà ché ia̱: —¿Ko̱s be' ki̱ ikiane tö be' patuè̱yö? Ie' tö iiu̱té: —Be' kë̀ tö ye' patau̱k. Erë ì chekeyö be' a̱ e' iu̱tö́, e' ta̱ ye' tö be' iyiwak kkö'nemi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","I̱'ñe ye' mi'ke be' iyiwak shu̱shtök. Obeja ko̱s dalolo ena chibo ko̱s wöaule shkitshkit ö u̱la̱u̱la̱ ese klö'we̱keyö ye' wák a̱ e̱' patuo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Mik be' de ye' iyiwak sa̱u̱k ta̱ ee̱ be' isuè̱mi tö obeja dalolo ö chibo wöaule shkitshkit ö u̱la̱u̱la̱ ese ë̀ tso', e' ta̱ be' wa̱ ijche̱rwa̱mi tö ye' dör wëm yësyësë. E' kë̀ dör es, e' ta̱ be' wa̱ ijche̱rdaë tö ye' tö be' iyiwak ekiblé. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labán tö iiu̱té: —Tö́, buaë idir. Iù̱sö we̱s be' iché es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Erë e' diwö shà̱ ta̱ ie' mía̱ ie' iyiwak shu̱shtök. Ie' chibo ko̱s tso' wöaule skëkshkëk ö u̱la̱u̱la̱ ese yéluritö. Ñies ie' obeja ko̱s tso' dalolo ese yéluritö ta̱ iméitö ila'r wëpa a̱ kkö'nè. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","E' ukuöki̱ ta̱ iyiwak yélur ie' tö e' wëttsë ie' mía̱ shkè dö̀ ká̱ mañat Jacob yöki̱. Eta̱ Jacob ka̱wöta̱ Labán iyiwak male̱pa e' kkö'nuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Erë Jacob tö kal kua̱'ki̱ kua̱'ki̱ dö̀ mañalka e' ulà aki tée. Elka kiè álamo, skà kiè almendro, skà kiè castaño. Kal ulà kkuölit takla jchéloritö a̱s iwër wöaule saruru skëkshkëk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","E' ukuöki̱ ta̱ kal ulà e' tuléwa̱itö wé̱ iyiwak daparke di'yök e' wösha̱ë. Ee̱ iyiwak wöbatsöke ñì wa. Iyiwak wöbatsöke ñì wa kal ulà ñe' wösha̱ë e' ala'rla ko̱s tskirke wöaule skëkshkëk ö shkitshkit ö u̱la̱u̱la̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Iyiwak tskirke wöaule e' ko̱s dapa'wé̱itö bánet ie' wák a̱. Ese wë'ñe ko̱s u̱yéwa̱itö Labán iyiwak ko̱s wöaule ö dalolo ese a̱ a̱s itskir wöaule ö dalolo. Es ie' iyiwak alörke tai̱ë bánet, kë̀ ku̱' Labán icha ta̱ ñita̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Mik iyiwak bua'bua ese wöbatsöke ñì wa, eta̱ ie' tö kal ulà ñe' tuléwa̱ wé̱ iyiwak di' yöke ee̱. Es ie'pa tö kal ulà wöaule e' sué̱ mik iwöbatsöke ñì wa e' dalewa. E' ala'rla tskirke ko̱s e'pa dör wöaule. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Erë mik iyiwak sí po ese datse̱, eta̱ ie' kë̀ tö kal ñe' tulèwa̱. E' kue̱ki̱ iyiwak sí po ese ala'rla ko̱s tskirke e' dör Labán icha. Erë wé̱ bua'buaë ese dör ie' icha. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Es ie' de íyi blú tai̱ë. Obeja ena kanè mésopa wëpa ena alakölpa ñies kameio ena burro e' ko̱s tso' ie' wa̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Erë Jacob tö ittsé tö Labán ala'r dulakölpa tö icheke: “Jacob tö se' yë́ íyi ko̱s e' klö'wé̱wa̱, e' wa ie' e̱' blu'wé̱ tai̱ë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ñies ie' tö isué̱ tö Labán kë̀ tö ie' suè̱ia̱ buaë we̱s ke̱net es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Eta̱ Jehová tö ie' a̱ iché: “Be' yúne be' yë́pa ka̱ska' wé̱ be' yamipa tso' ee̱. Ye' michoë be' ta̱ be' kkö'nuk.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacob tö Raquel ena Lía tsu̱k patké dö̀ wé̱ ie' tso' obeja wëttsë ee̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ta̱ ichéitö ia̱: —Ye' wa̱ ijche̱newa̱ tö a' yë́ kë̀ ki̱ ye' kianeia̱ we̱s ke̱net es. Erë ye' yë́ e' Këköl tso' ye' ta̱ ke̱kraë ye' ki̱muk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","A' wa̱ ijche̱r buaë tö ye' kaneblé a' yë́ a̱ moki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Erë ie' tö ye' ki̱tö'wé̱ ke̱kraë ye' kanè ské wa. Erë Skëköl kë̀ wa̱ ie' a̱ iké̱wö mène a̱s ì sulu wamblö̀itö ye' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Mik ie' tö ye' a̱ iché: “Ye' be' patue̱ke iyiwak wöaule shkitshkit ese wa”, eta̱ iyiwak ulitane pa̱ne wöaule shkitshkit ë̀me. Mik ie' tö ye' a̱ iché: “Ye' be' patue̱ke iyiwak wöaule shkëkshëk ese wa”, eta̱ iyiwak ulitane pa̱ne wöaule shkëkshëk ë̀me. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Es Skëköl tö a' yë́ iyiwak yë'lur mè ye' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Iyiwak wöbatsöke ñì wa e' ké̱wö ska' ta̱ ye' kabsué̱ tö iyiwak wë'ñe wöbatsöke iláki wa, e' ko̱s wák dör wöaule shkëkshëk ena shkitshkit ena u̱la̱u̱la̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kabsuè̱ e' a̱, Skëköl biyöchökwak ye' chaké ye' kiè wa ta̱ ye' iiu̱té: ‘¿Ì?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ie' ye' a̱ iché: ‘Isa̱ú̱ bua'ie ta̱ be' isue̱raë tö iyiwak wë'ñe wöbatsöke iláki wa, e' ko̱s dör wöaule shkëkshëk ena shkitshkit ena u̱la̱u̱la̱. Ì sulu ko̱s wamblé Labán tö be' ki̱, e' sué̱yö, e' kue̱ki̱ ye' tö iwé̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ye' dör Këköl dë'bitu̱ be' wörki̱ ká̱ kiè Betel ee̱ e'. Ee̱ be' tö ák du'ka̱a̱t ye' dalöioie. Ee̱ be' tö ka̱wö me' ye' a̱. Be' e̱' kö́ka̱ bet, be' e̱' yö́ttsa̱ ká̱ i' a̱. Be' yúne wé̱ be' ku̱ne ee̱.’” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Eta̱ Raquel ena Lía e'pa tö iiu̱té: —Kë̀ sa' a̱ sa' yë́ daliukuö ta̱'ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ñies sa' sué̱ sa' yë́ tö suluë we̱s o̱'ka es. Kí̱ie ta̱ sa' wato̱'ttsa̱itö be' a̱, sa' ské klöo̱'itö buaë e' e̱wé̱waitö yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","E̱'ma ko̱s Skëköl tö íyi yë'lur sa' yë́ ulà a̱, e' dör sa' icha ena sa' ala'r icha. E' kue̱ki̱ ì ko̱s ché Skëköl tö be' a̱ e' iu̱tö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","E' ukuöki̱ ta̱ Jacob tö ila'r ena ilakölpa e'pa ké e̱' tkökka̱ kameio ki̱. Ie' iyiwak ko̱s ena ie' íyi ko̱s dë' ie' ulà a̱ Padán-aram ikanè skéie, e' patkémiitö ke̱weie ie' yöki̱. Eta̱ ie' e̱' yéttsa̱ micho iyë́ Isaac ska' Canaán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labán mía̱ ká̱ bánet ioveja köyök tök, e' dalewa ie' wa̱ íyi diököl tso' dalöiè e' ko̱s bléwa̱mi Raquel tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob kë̀ wa̱ iyëne Labán a̱ tö ie' mi'kea̱. Es ie' tö iki̱té buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ie' tkashkar. Íyi tso' ie' wa̱ e' ko̱s wëttsë. Bet ta̱ ie' tkattsa̱ di' kiè Éufrates, e' wi̱she̱t. Ee̱ ta̱ ie' micho ká̱ kiè Galaad e' ká̱ köwö ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Jacob bakshkar e' ki̱ ká̱ de mañat, eta̱ Labán wa̱ ijche̱newa̱ tö ie' bakshkar. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Eta̱ ie' mía̱ itöki̱ iyamipa ta̱. Ká̱ de kul ta̱ ie' tö ikué̱ Galaad ká̱ köwö ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","E' nañewe Labán kabsué̱ tö Skëköl de ie' wörki̱ ta̱ ichéitö ia̱: “Ye' ttö̀ ttsö́. Kë̀ be' kàne ttök Jacob ta̱ kësik wa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ie' de wé̱ Jacob úla tulur Galaad ká̱ köwö ki̱ ee̱. Ee̱ ie' ena iyamipa, e'pa tö iúla tuléka̱ kapowa̱ie ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ie' tö iché Jacob a̱: —¿Ì wamblé be' tö i' es? ¿Iö́k be' tö ye' ki̱tö'wé̱ i' es? Be' wa̱ ye' alà busipa bite̱tse̱r we̱s ñippökwakpa tö s'tsè̱mi es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Ì kue̱ki̱ be' ye' ki̱tö'wé̱? Be' tkashkar akir ye' yöki̱. Be' e̱' biyö́ chö́pa ye' a̱, e̱'ma ka̱wö buaë tkö'wé̱ ye' tö a' wëttsë ttsëne buaë wa, ma'ma kicha ta̱' ese wa ena sabak blar buaë ese wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kë̀ be' wa̱ ka̱wö méne ye' a̱ ena ye' ala'r busipa ena ye' duöchkepa e'pa a̱ a̱s sa' e̱' chö̀a̱t ñì a̱. Be' tö iwamblé we̱s pë' suluë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ye' wa̱ diché tso' a' ulitane tsa̱ioie buaë, erë e̱nia̱ nañewe be' yë́ e' Këköl tö ye' a̱ iché: ‘Ye' ttö̀ ttsö́. Kë̀ be' kàne ttök Jacob ta̱ kësik wa.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Be' mitkene be' yë́ u a̱ we̱s be' ki̱ ikiane tai̱ë es, eta̱ ¿Ìie be' tö ye' wa̱ íyi diököl tso' dalöiè e' ekiblé? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Eta̱ Jacob tö iiu̱té: —Ye' suane be' yöki̱. Ye' ibikeits dö' be' ye' yöki̱ be' ala'r busipa yèttsa̱ne e̱r sulu wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Yi wa̱ be' íyi diököl tso' dalöiè e' tso', e' ta̱ a̱s e' wák duö̀wa̱. Se' yamipa ko̱s tso' í̱e̱ se' sa̱u̱k, e'pa wörki̱ be' yú be' íyi yulök. E' kué̱bö, e' ta̱ itsú̱mi. Erë ie' kë̀ wa̱ ijche̱r tö Raquel tö iyë́ íyi diököl e' blë'wa̱bitu̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Eta̱ Labán tkawa̱ Jacob úla a̱ ie' íyi yulök. E' ukuöki̱ ta̱ ie' tkawa̱ Lía úla a̱. Ñies Lía ena Raquel kanè mésopa böl e'pa úla shu̱yuléitö. Erë kë̀ ie' wa̱ iku̱ne. Ie' e̱' yéttsa̱ Lía úla a̱ mía̱ Raquel úla shu̱yulök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","E' dalewa Raquel tö iyë́ íyi diököl bléwa̱ kameio tsi̱kkuö diki̱a̱ ta̱ ie' wák e̱' tkéka̱ ibata ki̱. Labán tö ie' úla ulitane shu̱yulé erë kë̀ iwa̱ iku̱ne yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raquel tö iché ia̱: —A yë́wö, kë̀ be' ulunuk ye' ki̱. Ye' e̱' kö̀ka̱mi be' wörki̱, erë ye' duöke sik duè wa̱. Labán tö ie' íyi diököl yulé tai̱ë. Erë kë̀ ie' wa̱ iku̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","E' kue̱ki̱ Jacob uluneka̱ tai̱ë ta̱ ichéitö Labán a̱: —¿Ì sulu wambléyö be' ki̱, e' kue̱ki̱ be' ye' tötié̱ dö̀ í̱e̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Be' tö ye' íyi ko̱s e' shu̱yulé ta̱ ¿be', ì kué̱bö? E' tulö́ í̱e̱ se' yamipa wörki̱ a̱s ie'pa tö ichö̀ tö yi ttè dör moki̱ë, be' ö ye'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ye' kaneblë' be' a̱ duas döka̱ dabom böyök (20), e' dalewa ta̱ be' chibo ena be' obeja e' ko̱s tskirke bua'buaë. Be' iyiwak bobokpa kë̀ tkëulettsa̱ yës. Ñies kë̀ ye' wa̱ be' obeja pupula ë̀ kataulewa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Namu tö be' iyiwak ttéwa̱, e' ta̱ kë̀ ye' wa̱ inú dë'bitu̱. E' nuí̱ pato̱' ye' tö be' a̱. Ñiwe ö nañewe be' iyiwak ekiblélur akblökwakpa tö, e' patau̱k be' tö ye' ka'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ñiwe ye' tteke ka̱ba tö. Nañewe ta̱ ye' tteke ka̱se̱ tö. Kë̀ ye' kapowa̱ buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ye' kaneblë' be' a̱ duas dabom böyök (20) eta̱ es ye' bak weinuk ke̱kraë. Ye' kaneblë' duas dabom eyök ki̱ tkël (14) be' alà busipa dalërmik. E' ukuöki̱ ta̱ ye' skà kaneblë' duas teröl be' iyiwak kue̱ki̱, erë be' bak ye' ki̱tö'u̱k ke̱kraë ye' kanè ské wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Abraham ena ye' yë́ Isaac e'pa Këköl kë̀ kú̱pa ye' ta̱, e̱'ma be' ye' patkë'bitu̱ ulà wöchka. Erë Skëköl tö isué̱ tö ye' sia̱rla, e' kaneblë' tai̱ë, e' kue̱ki̱ ie' tö be' wöuñé e̱nia̱ nañewe. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Eta̱ Labán tö Jacob iu̱té: —Be' alakölpa dör ye' alà busipa. Be' ala'r dör ye' duöchkepa. Obeja ko̱s e' dör ye' icha. Ì ko̱s sué̱bö í̱e̱, e' dör ye' icha ë̀. ¿We̱s ye' a̱ ye' alà busipa ena ye' duöchkepa e'pa o̱rmi? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","E' kue̱ki̱ be' shkö́. Mishka ka̱wö muk ñì a̱. Es se' wa̱ ijche̱rdaë tö we̱s se' ka̱wöta̱ ñì dalöiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ee̱ ta̱ Jacob tö ák duéka̱ ek ie'pa ka̱wö muke ñì a̱ e' wà kkachoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ie' tö iché iyamipa a̱: —Ák dapa'ú̱ í̱e̱. Ie'pa ulitane tö ák dapa'wé̱ ta̱ ichkérak ák dapaule e' o̱'mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Eta̱ Labán tö ká̱ e' kiè méka̱ iwák ttö̀ wa “Jegar Sahadutá”. Ñies Jacob tö ikiè méka̱ iwák ttö̀ wa “Galaad.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labán tö iché: —I̱'ñe ák ikkë dapa'wé̱a̱tsö ka̱wö mésö ñì a̱ e' wà kkachoie. E' kue̱ki̱ Jacob tö ká̱ e' kiè méka̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ká̱ e' kine ñies Mispá, wà dör tö Labán tö iché: —Mik kë̀ se' ñì su̱neia̱, eta̱ a̱s Jehová tö se' sa̱ú̱ tö we̱s se' ñì wamblöke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Be' tö ye' ala'r busipa we'iké ö be' se̱néwa̱ alakölpa kua̱'ki̱ ta̱, e' ta̱ e' sue̱raë Skëköl tö. Erë́ kë̀ yi ku̱' e' sa̱u̱k chène ye' a̱, erë Skëköl wák tö isue̱raë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Eta̱ Labán tö ikí̱ ché Jacob a̱: —Ák dur i' ena ák dapaule i' e' dapa'wé̱yö se' böl shu̱sha̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ák dur i' ena ák dapaule i' e' dör se' böl a̱ iwà kkachoie tö í̱e̱ ë̀ se' ka̱wöta̱ dökwa̱. Kë̀ ye' tkö̀pami be' kke̱r ñippök be' ta̱. Ñies kë̀ be' tkö̀pami ye' kke̱r ñippök ye' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abraham dör be' duöchke ena Nahor dör ye' duöchke, e'pa Këköl eköl ë̀, a̱s e' tö se' shu̱lö̀. Eta̱ Jacob tö ka̱wö mé moki̱ë Labán a̱ Skëköl dalöieke iyë́ Isaac tö e' wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","E' ukuöki̱ ta̱ ie' tö iyiwak jché ña'wé̱ Skëköl dalöioie ee̱. Ie' tö iyamipa kié chkök. Ie'pa ulitane chké ta̱ ikaperö ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Bule es bla'mi ta̱ Labán tö iduöchkepa ena ila'r busipa e'pa wöalattsé e̱' choa̱t ie'pa a̱. Ie' tö iché ia̱rak: a' mú ka̱wö tkö̀ buaë ke̱kraë. E' ukuöki̱ ta̱ imichone ika̱ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","E' ukuöki̱ ta̱ Jacob mir ë̀ wé̱ imírö ee̱. Ñala̱ ki̱ Skëköl biyöchökwakpa de ie' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Mik e'pa sué̱itö, eta̱ ichéitö: “I'pa dör Skëköl ñippökwakpa.” E' kue̱ki̱ ie' tö ká̱ e' kiè méka̱ Mahanaim. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Eta̱ ie' tö ikanè mésopa patkémi biyö̀ muk ie' ël Esaú a̱ tö ie' datse̱. Ie' ël se̱rke ká̱ kiè Seír a̱te̱ Edom ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ie' tö ichémi ikanè mésopa a̱: “A' tö ichö́ ye' ël a̱: ‘Be' ël Jacob datse̱ be' wöki̱ be' kanè mésoie. Ie' tö ichébitu̱ be' a̱: Duas ikkë ko̱s ye' se̱né Labán ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ye' wa̱ baka tso' ena obeja tso' ena burro tso' tai̱ë. Ñies kanè mésopa tso' ye' wa̱ tai̱ë wëpa ena alakölpa. Be' dör ye' këkëpa. Be' a̱ ttè i' patkémiyö a̱s be' tö ye' kiö̀wa̱ e̱r bua' wa.’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Mik ibiyö̀ wakpa dene, eta̱ ie' a̱ ichéitö: —Sa' dare be' ël ska', e' wák datse̱ bet be' shke̱'u̱k. Eta̱ ie' wa̱ wëpa datse̱ e̱' ta̱ döka̱ cien tkëyök (400). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Mik e' ttséitö, eta̱ tai̱ë ie' suane. Tai̱ë ie' ka̱bikeitséka̱ we̱s ye' e̱' ù̱mi. E' kue̱ki̱ ie' tö iyamipa ena ikanè mésopa ena iobeja ena ibaka ena ikameio e' ko̱s blabatsélor böl tsi̱ní. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ie' ibikeitsé tö isalema ye' ël ñippö̀mi ek tsi̱ní ta̱, e' dalewa iëk tsi̱ní tköshkarmirak. E' kue̱ki̱ ie' iblabatsélor es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","E' ukuöki̱ ta̱ ie' tö iché Skëköl a̱: “A Jehová, be' dör ye' talà Abraham ena ye' yë́ Isaac e'pa Këköl. Be' ye' a̱ iyë': ‘be' yúne be' yamipa ska', eta̱ ye' tö be' ki̱meraë a̱s be' ka̱wö tkö̀ buaë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Be' e̱r bua' ché ye' a̱. Be' kë̀ wa̱ ye' mea̱tule bërbër ë̀. Warma e' kë̀ dör ye' sia̱rla e' a̱. Ye' bakmi di' Jordán wì̱ a̱ kë̀ wa̱ ì ta̱', e' ké̱wö ska' ta̱ ye' wa̱ shko kéli ë̀ dami. Erë i̱'ñe ta̱ ye' wöché tai̱ë iyiwakie ena se'ie blabutsule böl tsi̱ní. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Be' we'ikèyö, ye' tsa̱tkö́ ye' ël Esaú e' ulà a̱. Ye' suane ie' yöki̱ dö' ie' datse̱ ñippök ye' ta̱; ñies dö' ye' alakölpa ena ye' ala'rla e'pa ko̱s e̱wè̱wa ie' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Be' tö ye' a̱ iyë'a̱tbak yësyësë tö be' tö ye' ki̱meraë a̱s ye' ka̱wö tkö̀ buaë. Ñies be' tö iyë' tö ye' aleripa alördaë tai̱ë we̱s dayë tsé̱wö kë̀ shta̱rta̱' es.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","E' nañewe ie' kapére ee̱. Iyiwak tso' ie' ta̱ ee̱ e' shu̱shté ie' tö kakmè ie' ël a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ikkë shu̱tshté ie' tö: chibo alaki döka̱ cien böyök (200); chibo wë'ñe döka̱ dabom böyök (20); obeja alaki döka̱ cien böyök (200); obeja wë'ñe döka̱ dabom böyök (20); ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kameio alaki pa̱ne ñiköl ilà ta̱, ese döka̱ dabom mañayök (30); baka alaki döka̱ dabom tkëyök (40); baka wë'ñe pupula döka̱ dabop (10); burro alaki döka̱ dabom böyök (20); burro wë'ñe döka̱ dabop (10). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","E' ukuöki̱ ta̱ iyiwak ekkë ko̱s tuléitö ikanè mésopa a̱ iwakmik iwakmik ulawa ulawa ta̱ ichéitö ia̱rak: —A' yú ye' yöki̱ ke̱we. Ká̱ ulat múa̱t iyiwak a̱ ulat ulat a̱s kë̀ iwöiërwa̱ ñita̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Eta̱ kanè méso ke̱we patkémiitö e' a̱ ichéitö: —Mik be' tö ye' ël kué̱ ta̱ ie' tö be' chaké: “¿Yi be' wökir? ¿Wé̱ be' micho? ¿Se̱kkë dör yi iyiwak?”, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","eta̱ iiu̱tö́: “A këkëpa, iyiwak i' ko̱s e' kak patké be' kanè méso Jacob tö be' a̱. Ie' wák datse̱ sa' itöki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","E' sù̱ ikanè mésopa male̱pa patkémiitö iyiwak wëttsë, e'pa a̱ ichémiitö ñies: —Mik a' tö Esaú kué̱, eta̱ ichö́ ia̱ es ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kë̀ a' é̱na ichökwa chè ia̱: “A këkëpa, be' kanè méso Jacob e' datse̱ sa' itöki̱.” Ie' tö ibikeitsé: “Iyiwak patkémiyö ke̱weie ye' ël a̱ e' dör a̱s ie' e̱r buarne ye' ki̱. E' ukuöki̱ ta̱ ye' wák tö isuè̱mi. Es ie' tö ye' kièwa̱mi e̱r bua' wa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Es iyiwak kak patkémiitö ke̱weie ie' yöki̱. Erë ie' wák e̱' tsé̱a̱t kapökrö ie' úla a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","E' nañewe Jacob e̱' kéka̱. Ie' tö ilakölpa böl ena e'pa kanè mésopa böl ena ila'r döka̱ dabom eyök ki̱ eköl e'pa ko̱s dapa'wé̱itö ta̱ iu̱yöktsa̱ ké di' Jaboc wi̱she̱t ñies ì ko̱s tso' iwa̱ ekkë u̱yéttsa̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ie' e̱' tsé̱a̱t eköl. Ee̱ ta̱ wëm de eköl ie' ska' ta̱ ie'pa ñippé kapa wa darërë dö̀ ká̱ ñine eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Erë wëm e' tö isué̱ tö kë̀ ie' e̱' alö̀paka̱ Jacob ki̱. E' kue̱ki̱ ie' tö itéwa̱ itu' wöiërkewa̱ e' ki̱ ta̱ itu' wöyënettsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Eta̱ wëm ñe' tö iché ie' a̱: —Ká̱ ñirkewa̱tke e' kue̱ki̱ ye' ö́wa. Ie' tö iiu̱té: —Kë̀ be' tö ye' a̱ ka̱wö bua' mè, eta̱ kë̀ ye' tö be' epamine. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Wëm tö ie' a̱ ichaké: —¿I̱ma be' kiè? Ie' tö iiu̱té: —Ye' kiè Jacob. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Wëm tö iché ia̱: —Kë̀ be' kièia̱ Jacob. Be' kirdaë Israel. Be' ñippé Skëköl ta̱ ñies s'ditsö ta̱ eta̱ ì kiane be' ki̱ e' de be' ulà a̱, e' kue̱ki̱ be' kiè méka̱yö es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob tö ie' a̱ ichaké: —Ichö́ ña, ¿i̱ma be' kiè? Ie' iiu̱té: —¿Iö́k be' ki̱ ye' kiè kiane jche̱nuk? Ee̱ ta̱ wëm ñe' e̱r bua' ché ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ie' tö ká̱ e' kiè méka̱ Penuel. Ie' tö iché: “Erë́ ye' tö Skëköl wák sué̱wa̱ ye' wöbla wa, erë kë̀ ye' du'wa̱.” E' kue̱ki̱ ká̱ e' kiè méka̱itö es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Mik ie' tkökemitke Penuel, eta̱ diwö tskine. Erë ie' tu' wöyënettsa̱, e' kue̱ki̱ ie' shkörami shaotshaot. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ie' tënewa̱ itu'kicha ki̱, e' kue̱ki̱ dö̀ ikkë ta̱ ie' aleripa ko̱s kë̀ tö iyiwak tu'kicha kateta̱'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Mik Jacob tö isué̱ tö ie' ël datse̱ ena wëpa tai̱ë datse̱ ie' wa̱ döka̱ cien tkëyök (400), eta̱ ie' tö ila'rla blabatsé. E'pa méitö Lía a̱ ena Raquel a̱ ena e'pa kanè mésopa böl a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Kanè mésopa böl e'pa patkémiitö ke̱weie ila'r ta̱. E' ukuöki̱ ta̱ ie' tö Lía ena ila'r patkémi. Bata ekkë Raquel ena ilà José e'pa patkémiitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Eta̱ ie' wák tkami ke̱we ie'pa yöki̱. Ie' mirwa̱ ie' ël wörki̱ e' dalewa ie' wöémi dö̀ i̱ski̱ es iwöömir döka̱ kuktökicha (7 veces). Es ie' demi tsi̱net iël wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Eta̱ Esaú tu̱nebitu̱ ie' wöki̱, ta̱ ipaklö'wé̱wa̱itö ikuli' a̱ ta̱ iwöalattséitö ta̱ i̱é̱rak ñita̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","E' ukuöki̱ ta̱ Esaú tö Jacob alakölpa ena ila'rla e'pa sué̱ ta̱ ichakéitö ia̱: —¿Wí̱kkëpa dör yi? Jacob tö iiu̱té: —A këkëpa, Skëköl tö ala'rla wí̱kkëpa mé ye' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Eta̱ ilakölpa kanè mésopa e'pa de ila'rlaë ta̱ iwö éwarak dö̀ i̱ski̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","E' ukuöki̱ ta̱ Lía de ila'rë ta̱ ie'pa wöéwa i̱ski̱ ñies. Bata ekkë ta̱ Raquel de ilà José ta̱ eta̱ ie'pa wöéwa dö̀ i̱ski̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","E' bet ta̱ Esaú tö ie' a̱ ichaké: —Iyiwak kué̱yö ñala̱ ki̱ ulawa ulawa ¿ìie e' dör? Ie' iiu̱té: —E' dör a̱s be' e̱r buarne ye' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esaú tö iiu̱té: —Au, kë̀ be' tkinuk ye' ki̱. Ye' wa̱ itso' tai̱ë. E' tsú̱a̱t be' wák tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Erë Jacob tö iskà ché ia̱: —Au, kë̀ be' tö ye' ttè watöktsa̱. Be' e̱r buanene ye' ki̱ e' ta̱ íyi kakmekeyö be' a̱ e' klö'ú̱. Be' tö ye' kiéwa̱ buaë. Be' sué̱neyö e' dör buaë ye' a̱ we̱s Skëköl wák suè̱yö es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tai̱ë Skëköl tö ye' blu'wé̱. Kë̀ ì kianeia̱ ye' ki̱. E' kue̱ki̱ ye' be' pablè tö íyi kakméyö be' a̱ e' tsú̱ ye' ulà a̱. Jacob tö iyiwak watké ia̱ tai̱ë, e' kkë́pa iël Esaú tö iyiwak tsé̱ iulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esaú tö iché ia̱: —E̱'ma mishka ñita̱. Ye' mi'ke ke̱we. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Erë Jacob tö iiu̱té: —A këkëpa. Be' wa̱ ijche̱r bua' tö ye' ala'r ià̱ tsitsirla. Ñies obeja ena baka tso' alàë e' bikeitséyö dö' ishtrirwa̱ ta̱ iduölurmi se̱kka̱ ká̱ etkëme. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ye' a̱ ta̱ buaë idir tö be' yu'tke ke̱we, eta̱ wë' ye' do be' itöki̱ e̱nae̱na we̱s ye' iyiwak ena ye' ala'rla shkömir es. Es ye' mir ie'pa ta̱ dö̀ be' se̱rke Seír ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Eta̱ Esaú tö iiu̱té: —E̱'ma buaë idir. Ka̱wö mú ña ye' kanè mésopa we̱lepa muka̱t be' a̱ be' ki̱moie. Erë Jacob tö iiu̱té: —Au, ¿iö́k be' e̱' we'ikö̀ ye' wa̱ ekkë chökle? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","E' ë̀ diwö ta̱ Esaú mía̱ne Seír iyamipa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Erë Jacob mía̱ ká̱ kiè Sucot ee̱. Ee̱ ie' u yué iwák a̱. Ñies iyiwak wé chali'wé̱itö. E' kue̱ki̱ ká̱ e' kiè méka̱itö Sucot. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Es Jacob manéta̱t Padán-aram dö̀ Canaán. Ie' dettsa̱ buaë. Ie' se̱né ká̱ kiè Siquem, e' wösha̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Wé̱ ie' tö ká̱ yué e' tué̱ttsa̱ ie' tö. E' ské dör inuköl wömule̱ döka̱ cien eyök (100). Hamor dör Siquem yë́, e' ala'r tö ká̱ watué̱ Jacob a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ká̱ e' a̱ Jacob tö ák kataté et ka̱'ie iyiwak jchoie Skëköl dalöioie. E' kiè méka̱itö El-elohé-israel. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Jacob alà busi Lía ta̱ kiè Dina, ká̱ et ta̱ e' mía̱ ká̱ e' wakpa busipa pakök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Eta̱ Hamor e' dör heveowak e' dör ká̱ e' wökir, e' aladulaköl kiè Siquem e' tö Dina sué̱. Eta̱ ie' tö iklö'wé̱wa̱ ta̱ ise̱néka̱ ita̱ kësik wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Erë ie' wöbatse Dina wa tai̱ë ta̱ ipabléitö tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Eta̱ ie' tö iché iyë́ a̱: —A yë́wö, be' yú këkëpa Jacob ska' ilà busi kiöktsa̱ ye' a̱ a̱s ye' se̱rwa̱ ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ì sulu wamblé Siquem tö Dina ta̱ e' jche̱newa̱ Jacob wa̱. Erë ie' aladulakölpa tso' kañika̱ iyiwak kanéu̱k, e' kue̱ki̱ ie' kë̀ wa̱ iyëne ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","E' dalewa Hamor dör Siquem yë́ e' mía̱ Jacob ska' ttök ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Mik Jacob aladulakölpa dene u a̱, eta̱ ì wamblëne Dina ta̱ e' jche̱newa̱ ie'pa wa̱. E' tö ie'pa uluwé̱ka̱ tai̱ë. Siquem se̱néka̱ Jacob alà busi ta̱ e' dör íyi suluë Israel aleripa a̱. E' kë̀ ka̱wö ta̱' wamblè es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Erë Hamor tté ie'pa ta̱, ta̱ ichéitö ia̱: —Ye' aladulaköl Siquem, e' wöbatse tai̱ë a' kutà wa. A' we'ikèyö ka̱wö mú ie' a̱ se̱nukwa̱ ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Es a' yörmi sa' yamipaie. Es sa' se̱rwa̱mi a' alà busipa ta̱. Ñies a' se̱rwa̱mi sa' alà busipa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","A' e̱' tsú̱a̱t se̱nuk sa' shu̱a̱. A' se̱nú sa' ká̱ a̱ wé̱ a' ki̱ ikiane ee̱. A' tö íyi wataú̱ ena íyi ta̱ú̱. A' tö ká̱ ta̱ú̱. Kë̀ yi tö a' wöklö'we̱pa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ñies Siquem tté Dina yë́ ta̱ ena ikëpa ta̱, eta̱ ichéitö ia̱: —Ye' a' pablè tö ye' ttè klö'ú̱. Ye' tö a' a̱ íyi kakmeraë ko̱s a' ki̱ ikiane ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ko̱s iské dör e' tsa̱ta̱ a' tö ye' a̱ ikí̱ kié, e' ta̱ ekkë meraëyö a' a̱. E' kë̀ ki̱ ye' tkine. Ye' tö íyi meraë tai̱ë a' a̱, erë ka̱wö mú ye' a̱ se̱nukwa̱ be' kutà ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Erë Siquem tö ie'pa kutà dalöse̱wé̱wa̱, e' kue̱ki̱ ie'pa tö ie' ena iyë́ iu̱té ka̱chè wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ie'pa tö iché ia̱: —Kë̀ sa' a̱ sa' kutà menuk wëpa kë̀ tottola kkuölitla tëule tsir, esepa a̱. E' dör suluë sa' a̱ jaë tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Es ë̀ sa' tö a' iu̱tèmi. A' wëpa ko̱s tottola kkuölit tée tsir we̱s sa' es, e' ta̱ sa' tö a' ttö̀ iu̱tèmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Es a' se̱rwa̱mi sa' alà busipa ta̱. Ñies sa' se̱rwa̱mi a' alà busipa ta̱. Es sa' se̱rmi a' ta̱ ñita̱ we̱s ká̱ etkë̀ wakpa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Erë kë̀ a' wa̱ a' tottola kkuölitla tëne we̱s sa' tö iché a' a̱ es, e' ta̱ sa' míyalne ká̱ i' ki̱. Sa' kutà mítse̱rne sa' wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Eta̱ Hamor ena ilà Siquem e'pa a̱ imène buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tai̱ë duladula e' ki̱ Jacob alà busi kiane, e' kue̱ki̱ bet iwé̱itö we̱s ie'pa tö iché es. Ie' dalö̀ tai̱ë iyë́ ska' imale̱pa tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","E' kue̱ki̱ ie' mía̱ iyë́ ta̱ ká̱ kköiëule e' wékkö a̱. Ee̱ ká̱ e' wakpa ñì dapa'u̱ke ttè shu̱loie. Ee̱ Siquem ena iyë́ mía̱ ttök iká̱ wakpa ta̱. Ta̱ ichéitö ia̱rak: ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","—Pë' debitu̱ í̱e̱ e̱r buaë se' ta̱. Ie'pa de se̱nuk se' ta̱, íyi ta̱u̱k ena íyi watau̱k se' shu̱a̱. Ká̱ tso' wë' ie'pa a̱. Se' se̱rwa̱mi ie'pa alà busipa ta̱. Ñies ie'pa se̱rwa̱mi se' ichapa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Eta̱ a̱s se' dö̀ ká̱ etkë̀ wakpaie ie'pa ta̱ ñita̱, eta̱ s'ka̱wöta̱ iu̱k we̱s ie'pa tö iché es. Ie'pa tö iché tö se' wëpa ulitane ka̱wöta̱ itóttola kkuölitla tök tsir we̱s ie'pa wöblane iu̱k es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Eta̱ ko̱s ie'pa wa̱ iyiwak tso', ì tso' e' döraë se' icha. Sö ichö̀ ie'pa a̱ tö́. Eta̱ es ie'pa e̱' tsu̱kea̱t se̱nuk se' shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Eta̱ wëpa tso' ká̱ e' ki̱ kibinetke, e'pa ulitane a̱ buaë idir. Eta̱ ie'pa ko̱s tottola kkuölitla télor tsir. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","E' ukuöki̱ bökki̱ es ta̱ mik e' dalërkeia̱ tai̱ë kë̀ wa ie'pa e̱' tsa̱tkër, eta̱ Jacob aladulakölpa dör Dina akëpa kiè Simeón ena Leví, e'pa míyal Siquem, eta̱ ká̱ e' wakpa wëpa télurdakitö se̱raa̱ tabè wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Es ie'pa tö Hamor ena ilà Siquem e'pa ttéwa̱ tabè wa. Ie'pa tö ikutà yéttsa̱ Siquem u a̱ ta̱ imíyal. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ká̱ e' wëpa ttélur se̱raa̱. E' ukuöki̱ ta̱ Jacob aladulakölpa male̱pa debitu̱ ta̱ íyi ko̱s tso' ká̱ e' ki̱ e' tsé̱mirakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Es ie'pa wa̱ obeja ena baka ena burro ena íyi ko̱s tso' ká̱ kköiëulewa̱ e' a̱, ñies ì ko̱s tso' kañika̱ e' mítse̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ñies íyi tso' ko̱s u a̱, e' mítse̱r ie'pa wa̱ se̱raa̱. Ala'rla ko̱s ena alakölpa ko̱s e'pa klö'wé̱lur ie'pa tö ie'pa kanè mésopaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Eta̱ Jacob tö iché Simeón ena Leví a̱: —A' tö se' tsa̱ié. A' kue̱ki̱ ká̱ i' wakpa e' dör canaánwak ena fereseowak e'pa ulurdaë se' ki̱ tai̱ë. Ie'pa ñì dapa'u̱raë ñippök se' ta̱. Kë̀ se' wa̱ ñippökwakpa ta̱' tai̱ë, e' kue̱ki̱ ie'pa e̱' alöraka̱ se' ki̱. Ye' ena ye' yamipa ko̱s ttelurdaë ie'pa tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Erë ie'pa tö iiu̱té: —¿I̱ma ie'pa e̱rbikö̀ tö ie'pa wa̱ sa' kutà mi'mitse̱r we̱s alakölpa sulusi es? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","E' ukuöki̱ ta̱ Skëköl tö iché Jacob a̱: “Be' yú se̱nuk Betel. Ee̱ ák katatö́ ka̱'ie ye' dör be' Këköl e̱' kkayë' be' a̱ mik be' bakshkar Esaú yöki̱ eta̱, e' dalöioie.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Eta̱ Jacob tö iché iyamipa a̱ ena ko̱s itso'rak ie' ta̱, e'pa a̱ ñies: —Íyi diököl tso' a' wa̱ dalöiè, ese ko̱s tulö́ttsa̱ bet. A' kuö́ ta̱ a' datsi' mane'ú̱lor. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Mishkarak bet Betel. Ee̱ ye' tö ák katateke et ka̱'ie iyiwak jchoie Skëköl dalöioie. Ie' tö ye' ki̱me' mik ye' bak e̱rianuk tai̱ë eta̱. Ie' tö ye' kköna' ko̱s ye' ká̱ka're ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","E' bet ta̱ íyi diököl tso' ie'pa wa̱ dalöiè ese tulérakitö Jacob a̱. Ñies ikukuöio ko̱s, e' tulérakitö Jacob a̱. E' ko̱s wötéluritö kós klö̀ te̱r tsi̱net Siquem e' diki̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Eta̱ ie'pa e̱' yélur. Erë ká̱ tso' tsi̱net tsi̱net e' wakpa ko̱s suawé̱ka̱ tai̱ë Skëköl tö, e' kue̱ki̱ e'pa kë̀ wa̱ ie'pa töiëne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Eta̱ Jacob ena iyamipa ko̱s demi ká̱ kiè Luz a̱te̱ Canaán. Ká̱ e' kiè ñies Betel. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Eta̱ ee̱ ák katatéitö et ka̱'ie iyiwak jchoie Skëköl dalöioie. Ee̱ Skëköl e̱' kkayë' ie' a̱ mik ie' bakshkar iël yöki̱ eta̱. E' kue̱ki̱ ák katatéitö e' kiè méka̱itö El-Betel. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","E' ukuöki̱ ta̱ ká̱ e' a̱ Rebeca kkö'nukwak bak kiè Débora, e' blënewa̱ ta̱ inú bléwa̱rakitö kós klö̀ te̱r ee̱ e' diki̱a̱. Kal e' te̱r ká̱ kiè Betel e' o̱'mik. Jacob tö ká̱ e' kiè méka̱ “I̱è̱ kéli”. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","10","Mik Jacob bite̱a̱ne Padán-aram dene Canaán, eta̱ Skëköl e̱' kkachéne etökichane ie' a̱. Eta̱ Skëköl e̱r buaë ché ie' a̱ i' es: “Be' kiè Jacob, erë be' kë̀ kièia̱ es. I̱'ñe ta̱ be' kiè méka̱yö Israel.” Skëköl tö ie' kiè mane'wé̱ttsa̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","e' ukuöki̱ ta̱ ichéitö ia̱: “Ye' dör Skëköl Diché Ta̱' Íyi Ulitane Tsa̱ta̱ e'; Be' ala'r ena be' aleripa alönú tai̱ë. Be' aleripa alördaë tai̱ë, e'pa döraë ká̱ tai̱ë wakpaie. Ñies ie'pa shu̱a̱ blu'pa döraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ká̱ me'bakyö Abraham a̱ ena Isaac a̱, e' méyö be' a̱ ñies be' aleripa a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Mik Skëköl tté o̱ne Jacob ta̱, ta̱ imía̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ee̱ Jacob ák duéka̱ ek së sù̱. Ák e' ki̱ ie' tö kiö̀ ena vino té iwà kkachoie tö e' dör batse'r Skëköl a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ká̱ e' kiè méka̱itö Betel. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","E' ukuöki̱ ta̱ ie'pa e̱' yélur Betel míyal Efrata. Ka̱m ie'pa dö̀mi Efrata e' tso'ia̱ elkeë, eta̱ Raquel alà ku̱rketke e' diwö de. E' tö Raquel kiri'wé̱wa̱ tai̱ë erë kë̀ iwà ku̱r yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ie' tso'tke suluë ichö́k eta̱ ikkö'nukwak dur ee̱, e' tö iché ia̱: “Kë̀ be' suanuk. Be' alà ku̱ne. E' wák dör wëm.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Eta̱ Raquel wake' duökewa̱tke, isiwa̱' bata tkökeia̱, e' shu̱a̱ ilà kiè méka̱a̱titö Ben-oní. Erë ilà yë́ tö ikiè mane'wé̱ Benjamín. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Es Raquel blënewa̱. Inú wötéwa̱rakitö Efrata ñalé̱ ki̱. I̱'ñe ta̱ ká̱ e' kiè Belén. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Eta̱ wé̱ Raquel nu bléwa̱itö e' ki̱ ák duéka̱ ek Jacob tö iwà kkachoie. I̱'ñe ta̱ ák e' tkëria̱ Raquel pö kkachoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Eta̱ Israel michoë wé̱ imi'kerö ee̱. Ie' e̱' tsé̱a̱t se̱nuk ká̱ kiè Migdal Éder e' wi̱shke̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ie' tö ká̱ yué se̱noie ee̱, e' ukuöki̱ ta̱ ilà Rubén se̱néka̱ ie' alaköl kiè Bilhá e' ta̱, e' jche̱newa̱ ie' wa̱. Jacob aladulakölpa döka̱ dabom eyök ki̱ böl (12). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ie' ala'r Lía ta̱ e'pa dör Rubén, e' dör ikibi, ñies Simeón, Leví, Judá, Isacar ena Zabulón. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ila'r Raquel ta̱ e'pa dör José ena Benjamín. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raquel kanè méso kiè Bilhá, e' ta̱ ila'r dör Dan ena Neftalí. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lía kanè méso kiè Zilpá, e' ta̱ ila'r dör Gad ena Aser. E'pa dör Jacob aladulakölpa ku̱ne Padán-aram e'pa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob minea̱ iyë́ Isaac sa̱u̱k ká̱ kiè Mamré ee̱. Ká̱ e' kiè ñies Arbá ö Hebrón. Ká̱ e' a̱ Abraham ena Isaac bak se̱nuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isaac kënewa̱tke. Mik ie' ki̱ duas tso' cien eyök ki̱ dabom paryök (180), eta̱ iblënewa̱ mía̱ idëu̱töpa itöki̱. Ila'r Esaú ena Jacob e'pa tö inú wötéwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","I'pa dör Esaú aleripa. Esaú kiè ñies Edom. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaú se̱néwa̱ canaánwak alakölpa mañal ta̱. Eköl dör Adá, e' dör hititawak kiè Elón, e' alà busi. Iëköl kiè Oholibamá, e' dör Aná alà busi ena heveowak eköl kiè Sibón, e' talà. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Bata ë́k kiè Basemat, e' dör Ismael alà busi ena Nebaiot kutà. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adá alà tsá̱ ku̱ne e' kiè Elifaz. Basemat alà kiè Reuel. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamá ala'r ku̱ne mañal. E'pa kiè dör Jeús, Jaalam ena Coré. E'pa dör Esaú ala'r ku̱ne mik ie' bak se̱nuk Canaán eta̱ e'pa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaú wa̱ ilakölpa ena ila'r wëpa ena ila'r busipa ena imale̱pa ko̱s se̱rke ie' ska' e'pa ko̱s míyal ie' wa̱ e̱' ta̱ se̱nuk ká̱ bánet iël Jacob e' yöki̱. Ñies ie' wa̱ iyiwak ko̱s ena ì ko̱s dë' ie' ulà a̱ Canaán, e' mítse̱r se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esaú ena Jacob wa̱ íyi tso' tai̱ë. E' kue̱ki̱ ie'pa kë̀ chë'ka̱ia̱ ñita̱. Kë̀ ì ku̱'ia̱ wë' ie'pa böl iyiwak a̱ katè. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","E' kue̱ki̱ Esaú (e' kiè ñies Edom) e' mía̱ se̱nuk Seír ké̱bata a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","I' dör Esaú aleripa bak se̱nuk Seír ké̱ köwö ki̱, e'pa kiè edomwak. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","I'pa dör Esaú ala'r: Elifaz e' dör Esaú alà Adá ta̱, ena Reuel e' dör Esaú alà Basemat ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifaz ala'r dör Temán, Omar, Sefó, Gatam ena Quenaz. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaz alaköl skà bak eköl kiè Timná, e' ta̱ ilà ta̱' eköl kiè Amalec. E'pa dör Esaú alaköl kiè Adá e' uyökpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel ala'r dör Náhat, Zérah, Samá ena Mizá. E'pa dör Esaú alaköl kiè Basemat e' uyökpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esaú alaköl kiè Oholibamá, e' dör Aná alà busi ena Sibón talà. Ie' ala'r dör Jeús, Jaalam ena Coré. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","I'pa dör Esaú aleripa e'pa ditséwöpa wökirpa: Esaú alà kibi kiè Elifaz e' aleripa dör: Temán, Omar, Sefó, Quenaz, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatam ena Amalec. E'pa dör Elifaz aleripa e'pa ditséwöpa wökirpa bak se̱nuk Edom. Ie'pa dör Adá uyökpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esaú alà kiè Reuel e' ala'r dör: Náhat, Zérah, Samá ena Mizá. E'pa dör Reuel ditséwöpa wökirpa bak se̱nuk Edom. Ie'pa dör Basemat uyökpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esaú alaköl kiè Oholibamá e' dör Aná alà busi. Ie' ala'r dör: Jeús, Jaalam ena Coré. E'pa dör Oholibamá ditséwöpa wökirpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","E'pa ko̱s dör Esaú (kiè ñies Edom) e' aleripa. E'pa dör ie'pa ditséwöpa wökirpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","I'pa dör wëm dör horeowak eköl kiè Seír, e' ala'r. Ie'pa bak se̱nuk Edom ñies. Ie'pa kiè dör: Lotán, Sobal, Sibón, Aná, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Éser, ena Disán. E'pa dör Seír ala'r wëpa. Ie'pa dör horeowak wökirpa bak se̱nuk Edom. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotán ala'r dör Horí ena Hemam. Lotán kutà dör Timná. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal ala'r dör Alván, Manáhat, Ebal, Sefó ena Onam. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibón ala'r dör Aiá ena Aná. Ká̱ e' ta̱ Aná tso' iyë́ kiè Sibón e' burro kkö'nuk e' dalewa ie' tö di' tum kué̱ tai̱ë ká̱ sí po e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aná alà wëm kiè Disón. Ie' alà busi kiè Oholibamá. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disón ala'r dör Hemdán, Esbán, Itrán ena Querán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Éser ala'r dör Bilhán, Zaaván, ena Acán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disán ala'r dör Us ena Arán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Horeowak wökirpa dör Lotán, Sobal, Sibón, Aná, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Éser, ena Disán. E'pa dör horeowak wökirpa iyamipa wa. Ie'pa bak se̱nuk Seír. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","I'pa dör Edom blu'pa, ka̱m Israel aleripa blúpa dö̀ e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, e' dör Beor alà, e' de Edom wakpa blúie. Ie' ká̱ kiè Dinhaba. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela blënewa̱ e' skéie Jobab yöne blu'ie. Ie' dör Zérah alà. Ie' datse̱ Bosrá. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab blënewa̱ e' skéie Husam datse̱ Temán e' yöne blu'ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam blënewa̱ e' skéie Hadad dör Bedad alà e' yöne blu'ie. Bedad e̱' ali'ka̱ Madián wakpa ki̱ ká̱ kiè Moab ee̱. Husam ká̱ kiè Avit. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad blënewa̱, e' skéie Samlá yöne blu'ie. Ie' ká̱ kiè Masrecá. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlá blënewa̱, e' skéie Saúl yöne blu'ie. Ie' ká̱ dör Rehobot. Ká̱ e' a̱te̱ di' kkö̀ a̱ tsi̱net. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saúl blënewa̱, e' skéie Baal-hanán yöne blu'ie. Ie' dör Acbor alà. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-hanán blënewa̱, e' skéie Hadad yöne blu'ie. Ie' ká̱ kiè Pau. Ie' alaköl kiè Mehetabel, e' dör Matred alà busi ena Mezaab talà. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","I'pa dör Esaú aleripa kiè iyamipa wa ñies iká̱ wa: Timná, Alvá, Jetet, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibamá, Elá, Pinón, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Quenaz, Temán, Mibsar, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel ena Iram. Esaú kiè ñies Edom. E'pa ko̱s dör Edom ká̱ blu'pa wé̱ ise̱nerak iká̱ ki̱ ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob e̱' tsé̱a̱t se̱nuk Canaán wé̱ iyë́ bak se̱nuk ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ttè i' dör Jacob aleripa e' pakè. Jacob alà kiè José, mik e' ki̱ duas tso' dabom eyök ki̱ kul (17) eta̱ ie' tso' iyë́ obeja kkö'nuk iëlpa ta̱. Iëlpa dör iyë́ alakölpa kiè Bilhá ena Zilpá, e'pa ala'r. Eta̱ ì sulu ko̱s wambleke iëlpa tö ie' wöwa, ese kkateke se̱raa̱ ie' tö iyë́ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ie' ku̱ne mik iyë́ Jacob kënewa̱tke eta̱. E' kue̱ki̱ Jacob ki̱ ie' kiar ila'r male̱pa tsa̱ta̱. E' kue̱ki̱ Jacob tö datsi' yué ie' a̱ ki̱tkëule buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Erë mik ie' ëlpa wa̱ ijche̱newa̱ tö ie'pa yë́ ki̱ ie' kiar ie'pa ulitane tsa̱ta̱ eta̱ ie'pa é̱na ia̱r suluë, kë̀ ishke̱'we̱ta̱'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ká̱ et ta̱ ie' kabsué̱ e' pakéitö iëlpa a̱. E' kue̱ki̱ ie'pa é̱na suluë ie' kí̱ a̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ie' tö ikabsuè̱ paké iëlpa a̱ i' es: —Ye' ttö̀ ttsö́. Ye' kabsué̱ e' pakekeyö a' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ye' kabsué̱ tö se' ulitane tso' kaneblök kañika̱ dalì shu̱a̱. Se' tso' dalì wöshtök e' tsa̱tésö ettsa̱k ettsa̱k. Ye' tö isué̱ tö bet ye' icha e̱' duéka̱ bua' shkë'ka. A' ichapa e̱' dapa'wé̱ ye' icha pamik shkit ta̱ e'pa tö ye' icha dalöié. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Eta̱ iëlpa tö iiu̱té: —¿Be' é̱na iwà chak tö be' döraë sa' blúie? ¿Sa' se̱rdaë be' diki̱a̱? Ie' kabsué̱ ena we̱s ipakéitö ie'pa a̱, e' kue̱ki̱ ie'pa é̱na suluë ie' kí̱ a̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","E' ukuöki̱ ta̱ ie' skà kabsué̱ne, e' pakéitö iëlpa a̱ ñies. Ie' tö iché ie'pa a̱: —Ye' kabsué̱ tö diwö ena si'wö ñies bëkwö döka̱ dabom eyök ki̱ et (11), e' ko̱s tö ye' dalöieke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Mik ie' tö ikabsué̱ e' paké iyë́ a̱ ena iëlpa a̱, eta̱ iyë́ tö iuñé: —¿Ì kiane chè be' ki̱ kabsuè̱ e' wa? Ttsëskua be' mì ena be' ëlpa ena ye', sa' ka̱wöta̱ be' dalöiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ie' ëlpa é̱na ia̱r suluë. Erë iyë́ tö ibikeitsé tai̱ë: ¿ì kébisué̱ José tö es? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ká̱ et ta̱ José ëlpa míyal dö̀ Siquem iyë́ iyiwak wëttsë ka̱kö yulök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Eta̱ Jacob tö iché José a̱: —Be' ëlpa tso' tsi̱net Siquem iyiwak kkö'nuk. Ye' ki̱ ikiane tö be' yú isa̱u̱k. Eta̱ José tö iiu̱té: —E' buaë. Ye' mí isa̱u̱krak. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Jacob tö iiu̱té: —Ëkëkë. Be' yú be' ëlpa sa̱u̱k, is itso'rak, is iyiwak tso' ñies. E' wa be' wa̱ ye' a̱ itté dömine. Eta̱ Jacob tö ie' patkémi. Ie' e̱' yéttsa̱ Hebrón ké̱ kkue ki̱ mía̱ Siquem. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ee̱ ie' shkö̀dur chò kañika̱, e' kué̱wa̱ wëm eköl tö ta̱ e' tö ie' a̱ ichaké: —¿Ì yulök be' tso'? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ie' tö iiu̱té: —Ye' tso' ye' ëlpa yulök. ¿Be' kë̀ wa̱ ijche̱r wé̱ ie'pa tso' ye' yë́ iyiwak kkö'nuk? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Wëm e' tö iiu̱té: Ie'pa kë̀ ku̱'ia̱ í̱e̱. Ie'pa mineyalbak. Ye' ittö̀ ttsérak tö ie'pa mi'kea̱ Dotán. Eta̱ ie' mía̱ iëlpa yulök. Eta̱ ie'pa kué̱itö Dotán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Eta̱ iëlpa tö ie' sué̱ ka̱mië tö ie' datse̱. Ka̱m idö̀ e' dalewa iëlpa ka̱wö mérak ñì a̱ ie' ttowa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ichérakitö ñì a̱: —Kabsa̱u̱kwak datse̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ittöwa̱sö. Inú batröömisö ka̱uk kë̀ a̱ di' ta̱' ese a̱. Eta̱ ichö̀sö tö iyiwak sulusi ie' katéwa. Es ie' kabsuè̱ e' kë̀ wà tkö̀pa yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Mik Rubén tö ttè e' ttsé, eta̱ ie' é̱na iël tsa̱tkak. E' kue̱ki̱ ie' tö iché iëlpa a̱: —Kë̀ ittarwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kë̀ a' tö ie' pë́ tkö'u̱k. A' tö iö́mi ka̱uk i' a̱. Kë̀ a' ulà mukka̱ iki̱. Rubén é̱na José tsa̱tkak tsè̱mine iyë́ a̱, e' kue̱ki̱ ie' tö iché ie'pa a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Erë mik José debitu̱ iëlpa ska', eta̱ ie'pa tö ie' datsi' ki̱tkëule bua', e' yéttsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Eta̱ iklö'wé̱wa̱rakitö batréemi, ka̱uk tso' di' blóie, erë kë̀ iwà ta̱' ese a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","E'ukuöki̱ ta̱ ie'pa e̱' tuléwa̱ chkök, e' shu̱a̱ ie'pa isué̱ tö tai̱ë Ismael aleripa datse̱. E'pa datse̱ Galaad michoë Egipto dalì dami iwa̱ e' watau̱k. Kameio ki̱ ie'pa wa̱ kiö̀ alar buaë e' dami. Ñies kiö̀ masmas kiè bálsamo ena mirra e' dami iwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Eta̱ Judá tö iché iëlpa a̱: —Se' ël ttéwa̱sö ta̱ e' tté blésö, e' ta̱ e' wa ¿ì buaë dö̀mi se' ulà a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ye' ichè buaë idir tö iwatau̱ttsa̱sö Ismael aleripa a̱. Ie' dör se' ël se' yami e̱kka, e' kue̱ki̱ kë̀ sö ittö̀wa̱. E' mène buaë iëlpa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Mik íyi watau̱kwakpa datse̱ Madián e'pa tkami ee̱, eta̱ ie'pa tö iël yéttsa̱ ka̱uk a̱ watué̱ttsa̱rakitö Ismael aleripa a̱ inuköl wömule̱ döka̱ dabom böyök (20) ské ekkë. Es Ismael aleripa wa̱ José minetse̱r Egipto. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Mik Rubén debitu̱ ka̱uk kkö̀ ki̱, eta̱ kë̀ iël ku̱'ia̱. E' tö ie' e̱riawé̱ tai̱ë. E' kue̱ki̱ idatsi' jchélor. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","E' ukuöki̱ ta̱, ie' mía̱ iëlpa ska' ta̱ ichéitö ie'pa a̱: —Se' ël tsirla kë̀ ku̱'. ¿We̱s ye' e̱' ù̱mi? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Eta̱ ie'pa tö chibola ttéwa̱ ta̱ e' pë́ wa José datsi' patié̱ka̱rakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Eta̱ datsi' e' patkémiitö iyë́ a̱ ta̱ ichémi ia̱: “Datsi' i' kué̱ sa' tö. Ì sa̱ú̱ bua'ie. ¿Kë̀ idör be' alà datsi'?” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Eta̱ Jacob tö iché: “¡Tö́, i' dör ye' alà datsi'! Iyiwak sulusi wé̱sele tö ye' alà ttéwa̱ katéwa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Eta̱ Jacob tö idatsi' jchéloyar e̱riane kue̱ki̱. Eta̱ datsi' tso' iëno mik schönewa̱ ese iéka̱itö. Eta̱ ilà blënewa̱ e' e̱riaitséitö ká̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Eta̱ ila'r, wëpa ena alakölpa, e'pa ko̱s de ie' pablök, erë kë̀ ie' pablër yës. Ikí̱ i̱u̱ke tai̱ë shu̱te̱ ilà dalërmik. Ie' tö iché: “Ye' schö́ e̱riaitséraë dö̀ mik ye' duowa̱ ekkë, es ye' döraë ie' ska'.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Eta̱ madiánwakpa demi Egipto. Ee̱ ie'pa tö José watué̱ttsa̱ wëm kiè Potifar e' a̱. Wëm e' kaneblöke Egipto blú a̱. Potifar dör Egipto blú tsa̱tkökwakpa e' wökir. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","E' ké̱wö ska' ta̱ Judá e̱' batséttsa̱ iëlpa yöki̱ mía̱ se̱nuk wëm kiè Hirá e' ska'. E' se̱rke ká̱ kiè Adulam. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ee̱ Judá tö alaköl sué̱ eköl. E' dör wëm canaánwak kiè Súah e' alà busi, e' ta̱ ie' se̱néwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","E' ukuöki̱ ta̱ iduneka̱ ta̱ ilà ku̱ne wëm, e' kiè méka̱itö Er. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","E' ukuöki̱ ilà skà ku̱ne wëm, e' kiè méka̱itö Onán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","E' ukuöki̱ ta̱ ilà skà ku̱ne wëm, e' kiè méka̱itö Selá. E' ku̱ne mik ie' se̱rke ká̱ kiè Quezib, ee̱ eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judá tö alaköl yulé se̱nowa̱ie ilà kibi kiè Er e' ta̱. E' kiè Tamar. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Eta̱ Er se̱rke suluë shu̱te̱ Jehová wöa̱. E' kue̱ki̱ Jehová tö ittéwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Eta̱ Judá tö iché Onán a̱: —Be' ka̱wöta̱ se̱nukwa̱ be' dabököt ta̱ alà kö̀ka̱ be' ël blënewa̱ e' a̱ we̱s se' wakpa a̱ imenea̱tbak es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onán é̱na ia̱ne tö ie' alà ku̱rmi ko̱s ischö́ ta̱, e' kë̀ dör ie' wák ala'r. E' kue̱ki̱ mik ie' se̱rke ischö́ ta̱, eta̱ bet ta̱ ie' e̱' skéu̱ bánet a̱s kë̀ alà kö̀ka̱ ischö́ ta̱. Es ie' kë̀ wa̱ iël a̱ iditséwö menea̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","E' dör suluë ichö́k Jehová a̱, e' kue̱ki̱ ie' tö Onán ttéwa̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Eta̱ Judá tö iché iyàk Tamar a̱: —Be' yú se̱nuk be' yë́ u a̱ we̱s schö́ es dö̀ mik ye' alà Selá talane eta̱. Erë Judá tso' Tamar ki̱tö'u̱k. Ie' ibikeitsé tö Selá duöwa̱mi we̱s iëlpa duolur es. Es Tamar minea̱ se̱nuk iyë́ ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ká̱ de tai̱ë ta̱ Judá alaköl dör Súah alà busi e' blënewa̱. Ie' schö́ ké̱wö tka ta̱ ie' mía̱ ká̱ kiè Timnat, wé̱ itso'rak ie' obeja köyök tök ee̱. Ie' yami kiè Hirá e' dör adulamwak, e' mí ie' ta̱ ie' wapiöu̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","14","Tamar tö isué̱ tö Judá alà kiè Selá, e' detke këchke erë kë̀ ie' se̱nèwa̱ ie' ta̱. E' wa ie' wa̱ ijche̱newa̱ tö Judá tö ie' ki̱tö'wé̱ Selá wa. E' kue̱ki̱ mik ie' wa̱ ijche̱newa̱ tö inua̱ki mía̱ Timnat iobeja köyök tök, eta̱ ie' e̱' paiöke schö́ie e' mane'wé̱ttsa̱neitö. Iwö pabakéwa̱ datsi'tak wa a̱s kë̀ yi a̱ iwërwa̱. Eta̱ imía̱ ká̱ kiè Enaim. Ee̱ ie' e̱' tkése̱r Timnat ñalé̱ kkö̀ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Mik Judá tö Tamar sué̱ ta̱ ie' ibikeitsé tö e' dör alaköl sulusi iwö pabakéwa̱ e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Eta̱ ie' mía̱ iwöki̱. Kë̀ ie' wa̱ ie̱ri ta̱' tö e' dör ie' yàk. Eta̱ ichéitö ia̱: —¿Se' se̱r ñita̱? Eta̱ Tamar tö iché ia̱: —¿Ì meke be' tö ye' a̱ iskéie? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Eta̱ Judá tö iiu̱té: —Ye' chibo patköke be' a̱ etö iskéie. Ie' iiu̱té: —Ëkëkë. Erë be' íyi tsá̱ múa̱t ye' a̱ dö̀ mik be' tö chibola patké eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Judá tö ie' a̱ ichaké: —¿Ì kiane be' ki̱ tö ye' imèa̱t be' a̱? Eta̱ ie' tö iiu̱té: —Be' tabechka tso' e̱' kiè shtoie, e' múa̱t ye' a̱ ikichaë. Ñies be' shko kéli múa̱t ye' a̱. Judá tö imé ia̱ ta̱ ie' se̱né ie' ta̱. Eta̱ alaköl duneka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","E' ukuöki̱ ta̱ Tamar mía̱ iu a̱ eta̱ idatsi'tak wa iwö pabakéwa̱ e' yéttsa̱itö. Eta̱ ie' e̱' paiéne schö́ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","E' ukuöki̱ ta̱ Judá tö chibo patkémi iyami adulamwak e' ulà a̱ a̱s ie' tö imù alaköl a̱ a̱s alaköl e' tö ie' íyi méa̱t alaköl ulà a̱ e' mùbitu̱ne. Erë ie' yami kë̀ wa̱ alaköl e' ku̱neia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Eta̱ ie' tö ká̱ e' wakpa a̱ ichaké: —Alaköl sulusi e' dör enaimwak a̱té̱a̱t ñala̱ ska', ¿wé̱ e'? Eta̱ ie'pa tö iiu̱té: —Í̱e̱ alakölpa sulusi kë̀ dë'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Eta̱ ie' bite̱a̱ne Judá wörki̱ ta̱ ichéitö ia̱: —Kë̀ ye' wa̱ alaköl ku̱ne. Ye' tö ichaké ká̱ e' wakpa a̱. Ie'pa tö ye' a̱ iché: ‘Í̱e̱ alakölpa sulusi kë̀ dë'.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judá tö iiu̱té: —A̱s ye' íyi tsú̱a̱titö es kë̀ yi tö sa' jaëwe̱pa. Kë̀ ye' iane iwiie. Ye' tö ichibo patkémi be' ulà a̱, erë kë̀ be' wa̱ alaköl ku̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Eta̱ si' mañat ulatök ta̱ Judá ki̱ biyö̀ de tö: —Be' yàk Tamar e' se̱ne' wëpa kua̱'ki̱ ta̱. Ie' duneka̱. Eta̱ Judá tö iché a̱neule: —¡Iyö́ttsa̱ ta̱ iña'ú̱wa! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Erë mik ie' yekettsa̱ ie'pa tö ttèwa̱, e' wösha̱ ie' ttè mémi inua̱ki a̱: “Yi íyi a'tse̱r ye' ulà a̱ i', e' wák tö ye' duéka̱. Be' isa̱ú̱. ¿Yi kiè shto tabechka i' ikichaë ena shko kéli i'? ¿e' su̱ule be' wa̱?” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Mik Judá tö ie' íyi sué̱wa̱ iyàk ulà a̱ ta̱ ichéitö: “Alaköl i' dör buaë. Kë̀ ye' wa̱ iulabatse̱ ye' alà Selá ta̱. Ye' e̱' wamblé sulu ie' ki̱.” Eta̱ kë̀ ie' se̱neia̱ ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar alà ku̱ne klö̀ wák dör wëpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Itsörke e' wösha̱, eta̱ eköl ulà dettsa̱ ke̱we. Eta̱ ie' kkö'nukwak tö datsi'kicha batsë e' mué̱wa̱ ilà ulà mik ta̱ ichéitö: “I' ë́k ku̱ne ke̱we.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Erë e' wösha̱ë bet ta̱ alà ulà tié̱wa̱ne etökichane eta̱ iëk ku̱ne ke̱weie. Eta̱ ikkö'nukwak tö iché ia̱: “¿We̱s be' ku̱ne ke̱weie?” E' kue̱ki̱ ikiè méka̱itö Fares. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","E' ukuöki̱ ta̱, iulà a̱ datsi'kicha tkër batsë e' ku̱ne, e' kiè méka̱itö Zérah. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","José minetse̱rak iwa̱ Egipto. Ká̱ e' ki̱ wëm tso' eköl kiè Potifar, e' tö ie' tué̱ttsa̱ Ismael aleripa a̱. Wëm e' kaneblöke Egipto blú a̱. Ie' dör Egipto blú tsa̱tkökwakpa wökir. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Erë Jehová tso' José ta̱, e' kue̱ki̱ ì ko̱s kanewe̱keitö e' dökettsa̱ buaë iwökir egiptowak e' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Iwökir tö isué̱ tö Jehová tso' José ta̱, e' kue̱ki̱ ì ko̱s kanewe̱keitö e' dökettsa̱ buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","E' kue̱ki̱ iwökir ki̱ ikiarke tai̱ë. Ie' tö iméka̱ ie' wák ki̱mukwakie. Ñies iméka̱itö ie' íyi ko̱s e' kue̱bluie. Ie' wa̱ íyi ko̱s tso' e' kkö'nekeitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Mik Potifar tö ie' méka̱ iíyi ko̱s kue̱bluie, eta̱ Jehová e̱r buaë chémi Potifar a̱. Ie' íyi ko̱s tso' iu a̱ ena kañika̱ e' ko̱s mir buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","José tö Potifar íyi ulitane kkö'neke buaë. E' kue̱ki̱ Potifar kë̀ wöki̱ ì wëneia̱ yës. Ì ñak ie' é̱na e' ë̀ bikeitsekeitö. José wák dör bua'bluka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ká̱ de iki̱ tai̱ë eta̱ iwökir alaköl wöbatseka̱ iwa. Ká̱ et ta̱ ie' iché ia̱: —Be' se̱núka̱ ye' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Erë José kë̀ wa̱ ie' ttè iu̱tëne ta̱ ichéitö ia̱: —Ye' ttö̀ ttsö́. Ye' wökir íyi ulitane méa̱t ye' ulà a̱ su̱noie. Ye' tso' í̱e̱, e' ta̱ kë̀ ie' tkine ie' íyi ko̱s ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ye' tso' ie' u kue̱blu kibiie. Ye' wökir kë̀ wa̱ ì kkëo̱ne ye' ki̱. Be' ë̀ kë̀ menea̱t iwa̱ ye' a̱ be' dör ie' alaköl e' kue̱ki̱. ¿We̱s ye' tö ì sulu i' wamblèmi be' ta̱? ¿We̱s ye' tö ì sulu wamblèmi Skëköl ki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ke̱kraë alaköl tö ie' a̱ icheke: “Be' se̱nú ye' ta̱.” Erë ie' kë̀ tö iiu̱teta̱' yës. Ie' tö iulawaté ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ká̱ et ta̱ ie' tkawa̱ we̱shke̱ íyi kanéu̱k eta̱ iwökir alaköl e' ë̀ tkër. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Eta̱ iwökir alaköl tö ie' klö'wé̱wa̱ idatsi' a̱ ta̱ ichéitö ia̱: —Be' se̱nú ye' ta̱. Erë ie' tkashkar iulà a̱ mía̱ tu̱neule. Ie' datsi' yënettsa̱a̱t alaköl ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Mik iwökir alaköl tö isué̱ tö José datsi' a̱te̱ ie' ulà a̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","eta̱ ie' tö ikanè mésopa kié ta̱ ichéitö ie'pa a̱: —Isa̱ú̱, ye' wëm wa̱ hebreowak dë'bitu̱ e' tso' se' wayuök. Ie' dewa̱ ye' ska'. Ie' se̱nakka̱ ye' ta̱ kësik wa erë ye' a̱neka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Mik ie' ittsé tö ye' a̱neka̱ tai̱ë ta̱ ie' tkashkar tu̱neule. Ie' datsi' yënettsa̱a̱t e' a̱te̱ ye' ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","E' ukuöki̱ ta̱ ie' tö José datsi' blé kkayënoie iwëm a̱ mik idene eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Mik iwëm dene, eta̱ ipakéitö ia̱ ta̱ ichéitö ia̱: —Be' wa̱ hebreowak dë'bitu̱ kanè mésoie, e' tkawa̱ we̱shke̱ ye' ska'. Ie' se̱nakka̱ ye' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Erë mik ye' a̱neka̱ tai̱ë, eta̱ ie' tkashkar tu̱neule ta̱ idatsi' a̱te̱ tër í̱e̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Es be' kanè méso tö ye' dalöse̱wé̱wa̱. Mik iwökir tö ttè e' ttsé eta̱ iluneka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","21","José klö'wé̱wa̱itö wötökwa̱ patkéitö wé̱ Egipto blú bolökpa tso' wötëule ee̱. Erë Jehová tso' José ki̱muk s'wöto wé a̱ ñies. Ie' e̱r bua' chöke ia̱. Ie' tö s'wöto wé wökir ké e̱r buaë chök ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","S'wöto wé wökir tö iméka̱ s'tso' wötërulewa̱ male̱pa ko̱s kue̱bluie. José tö ì ko̱s we̱ke s'wöto wé a̱ e' ké̱wö meke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Jehová tso' José ta̱. Ie' tö iki̱meke a̱s ì ko̱s döttsa̱ buaë ie' a̱. E' kue̱ki̱ ì kanewe̱ke José tö e' kë̀ sue̱ku̱'ia̱ s'wöto wé wökir tö tö is imir. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","E' ukuöki̱ ta̱ wëm dör Egipto blú a̱ vino mukwakpa e'pa kue̱blu ena wëm dör blu' a̱ pan yuökwakpa e'pa kue̱blu, e'pa böl tö iblú tsiriwé̱ka̱. E' kue̱ki̱ ie' uluneka̱ ie'pa ki̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ta̱ ie'pa patkéitö wötèwa̱ ikkö'nukwakpa kue̱blu e' u a̱ s'wöto wé tso' e' a̱. Ee̱ José tso' wötëule ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Eta̱ Egipto blú kkö'nukwakpa e' kue̱blu tö José ké wëpa böl ñe'pa kkö'nuk. Ee̱ ie'pa se̱né wötëule ká̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ká̱ et nañewe ta̱ ie'pa böl kabsué̱ kua̱'ki̱ kua̱'ki̱. E' wà dör kua̱'ki̱ kua̱'ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Bule es bla'mi ta̱ José debitu̱ isa̱u̱k. Ie' tö isué̱ tö ie'pa e̱riane. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","E' kue̱ki̱ ie' tö ie'pa a̱ ichaké: —¿Iö́k i̱'ñe ta̱ a' wö wër sia̱r? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ie'pa tö iiu̱té: —Sa' kabsué̱, erë kë̀ yi ku̱' sa' a̱ iwà pakök. Ie' tö iché ie'pa a̱: —¿A' kë̀ wa̱ ijche̱r tö Skëköl tö s'kabsuè̱ e' wà chèmi se' a̱? ¿I̱ma a' kabsué̱? E' chö́ ña. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Eta̱ blu' a̱ vino mukwakpa kue̱blu e' tö ikabsuè̱ paké ia̱ ta̱ ichéitö: —Ye' kabsué̱ tö uva kicha me'r ye' wösha̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","e' ulà tso' mañat. E' dapëneka̱ e' wörkua bune tai̱ë ta̱ iwörkua mía̱ne iwö́liie e' yua' tso' tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Egipto blú tka̱' a'tse̱r ye' ulà a̱. E' a̱ uvawöli diö̀ tuéeyö. E' ukuöki̱ ta̱ ye' wák tö imé blu' a̱. Es ye' kabsué̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","José tö iché ia̱: —Be' kabsuè̱ e' wà kiane yënuk i' es: Be' tö uva kicha ulà kébisué̱ mañat. E' wà kiane yënuk ká̱ mañat. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ká̱ mañat ta̱ blu' tö be' shu̱leraë. Be' kané meraneitö be' a̱. Vino meranebö ie' a̱ we̱s be' tö io̱' kuaë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Be' we'ikèyö, mik iwà tka, eta̱ kë̀ be' é̱na ye' chökwa. Ye' tté chö́ blu' a̱ a̱s itö ye' yö̀ttsa̱ í̱e̱. ¡Be' e̱r buaë chö́ ye' a̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ye' dör hebreowak e' ekiblë'wa̱bitu̱ ie'pa tö. Ye' kë̀ wa̱ ì sulu wamblëne. Ye' tso' wötëule ë́. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mik blu' pan yuökwakpa kue̱blu e' tö isué̱ tö José tö iyami kabsuè̱ e' wà paké ta̱ idettsa̱ buaë eta̱ ie' tö ie' icha paké ia̱ ñies. Ie' iché: —Ye' kabsué̱ tö ye' wa̱ kkö́ dami mañal ye' wökir ki̱, e' a̱ pan saruru dami. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kkö́ tkër ká̱kke̱ ë́k e' a̱ pan dami blu' a̱ daklili. Erë pan dami ye' wa̱ kkö́ a̱ ye' wökir ki̱ e' ñeke dù tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Eta̱ José tö iché ie' a̱: —Be' kabsué̱ e' wà kiane yënuk i' es: kkö́ mañal e' dör ká̱ mañat. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","E' wà kiane chè tö ká̱ mañat ta̱ blu' tö be' kuli' tökök patkeraë, ta̱ be' nu kichatkeraka̱ kal ulà a̱. Dù tö be' nu katerawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ká̱ de mañat ta̱ blu' tö iduéswö tkö'wé̱ chkè wa di'yè wa tai̱ë ikue̱blupa ulitane kaneblöke ie' a̱ e'pa a̱. E' shu̱a̱ ie' tö ivino mukwakpa kue̱blu ena ipan yuökwakpa kue̱blu e'pa böl tsu̱kbitu̱ patké s'wöto wé a̱ ikue̱blupa ulitane wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Vino mukwakpa kue̱blu e' a̱ ikané méneitö. Ie' tö blu' a̱ itka̱' méne we̱s kuaë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Erë pan yuökwakpa kue̱blu, e' patkémi nu kichatkèka̱ we̱s José tö iyë' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Erë vino mukwakpa kue̱blu e' kë̀ e̱r a̱neia̱ José ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Duas de bök, e' ukuöki̱ ta̱ Egipto blú kabsué̱ tö ie' dur di' kiè Nilo e' kkömik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ie' isué̱ tö baka deyal di' a̱ kuktö. E' dör baka bua'buaë jani'janila. E' iëte̱r chkök kuachka shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","E' itöki̱ baka skà deyal kuktö di' a̱. Erë e' dör suluë sí sulula. E' míyal di' kkömik baka malè̱ o̱'mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Eta̱ baka sí sulula kuktö, e' tö baka bua'buaë kuktö e' katélur. Ee̱ ta̱ blu' ti̱'neka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","E' ukuöki̱ ta̱ bet ie' kapowa̱ne ta̱ ikabsué̱ne tö ì talarke kuö̀ sù̱ kiè trigo e' klö̀ elka ë̀ a̱ ila'k deka̱ kul. Ila'k e' dör bua'buaë iwö blubluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","E' itöki̱ iskà tskine e' klö̀ elka ë̀ a̱ ila'k deka̱ kul ñies, erë sulula idir. Siwa̱' datse̱ diwö tskirke e' kke̱ e' tö isiwé̱wa̱ ña'wé̱wa suluë mía̱ wö yabé ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Eta̱ ila'k kul siulewa̱ sulu e' tö ila'k bua'bua katélur se̱raa̱. Blu' ti̱'neka̱ ta̱ ié̱na ia̱ne tö ie' kabsa̱u̱ke moki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Erë bule es bla'mi ta̱ ie' kabsué̱ e' tö ie' e̱riawé̱ka̱. E' kue̱ki̱ ie' tö Egipto íyi tötkökwakpa ena íyi jche̱r tai̱ë ese wakpa, ko̱s tsu̱k patké. Ie' kabsué̱ e' pakéitö ie'pa a̱. Erë ie'pa ulitane kë̀ a̱ ie' kabsué̱ e' wà a̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Eta̱ vino mukwakpa kue̱blu e' tö iché blu' a̱: —A blu', e̱rpa ye' é̱na idaa̱ tö sulu ye' e̱' wamblé. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Mik be' uluneka̱ tai̱ë be' pan yuökwakpa kue̱blu ki̱ ena ye' ki̱, eta̱ be' tö sa' wötökwa̱ patkë' be' kkö'nukwakpa kue̱blu e' wé a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ká̱ et nañewe ta̱ pan yuökwakpa kue̱blu kabsué̱. Ye' kabsué̱ ñies. Sa' kabsué̱ e' wà ta̱' ulawa ulawa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ee̱ wëm dur eköl duladula hebreowak, e' dör s'wöto wé wökir e' kanè méso. Ie' a̱ sa' tö sa' kabsué̱ e' paké ta̱ ie' tö iwà ché sa' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","¡Iwamblëne yësyësë we̱s ie' tö sa' a̱ iyë' es! Ye' dene ye' kané a̱ ta̱ iëköl nu kichatkéka̱ kal ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Eta̱ blu' tö José tsu̱k patké ta̱ iyéttsa̱rakitö bet s'wöto wé a̱. José tsà̱ tée buaë, e̱' paié buaë, ta̱ ide ie'pa wa̱ blu' wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Blú tö iché ia̱: —Ye' kabsué̱ erë kë̀ yi é̱na iwà a̱ne. Erë ie'pa tö iché ye' a̱ tö buaë be' tö s'kabsuè̱ e' wà pakè. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ie' tö iiu̱té: —A këkëpa e' kë̀ yënuk ye' a̱. Erë Skëköl tö e' chèmi be' a̱ be' ki̱moie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Blu' tö iché ia̱: —Ye' kabsué̱ tö ye' dur di' kiè Nilo e' kkömik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ye' isué̱ tö baka deyal di' a̱ kuktö. E' dör baka bua'buaë jani'janila. E' iëte̱r chkök kuachka shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","E' itöki̱ baka skà deyal di' a̱ kuktö. Erë e' dör suluë sí pola. ¡Kë̀ ye' wa̱ baka su̱ule sí poë suluë ká̱ i' a̱ ekkë chökle! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Eta̱ baka sí sulula kuktö, e' tö baka bua'buaë kuktö e' katélur. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Baka sí suluë e' tö baka bua'buaë katélur erë kë̀ iwër tö ikatélur. Itso'ia̱ sí poë we̱s ke̱net es. “Ee̱ ta̱ ye' ti̱'neka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Eta̱ bet ye' skà kapowa̱ne ta̱ ye' skà kabsué̱ne tö ì talarke kuö̀ sù̱ e' klö̀ elka ë̀ a̱ ila'k deka̱ kul. Ila'k e' dör bua'buaë iwö blubluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","E' itöki̱ iskà tskine e' klö̀ elka ë̀ a̱ ila'k deka̱ kul ñies. Erë e' ala'k dör sulula. Siwa̱' datse̱ diwö tskirke e' kke̱ e' tö isiwé̱wa̱ ña'wé̱wa suluë mía̱ wö yabé ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Eta̱ ila'k kul siulewa̱ sulu e' tö ila'k bua'bua katélur se̱raa̱. E' ko̱s pakéyö s'tötkökwakpa a̱ erë ie'pa shu̱a̱ kë̀ yi a̱ iwà a̱ne yës.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Eta̱ José tö blu' iu̱té: —A këkëpa, be' kabsué̱ bötökicha, e' wà dör etkë̀. Ì we̱raë Skëköl tö kukuie e' chök ie' tso' be' a̱ kabsuè̱ a̱ ka̱m iwà tkö̀ e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Baka bua'buaë ena ala'k bua'buaë e' wà dör etkë̀, e' dör duas kul. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Baka sulula sí poë deka̱ ibua'buaë itöki̱ ena ala'k suluë siulewa̱ siwa̱' wa̱, e' wà dör etkë̀. E' dör duas kul skà. E' duéswö wa ketba a̱rdaë s'ki̱ dö̀ duas kul e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ì we̱raë Skëköl tö kukuie e' chök ie' tso' be' a̱ we̱s ye' tö be' a̱ ichétke es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ke̱we dalì wördaë tai̱ë Egipto ko̱s a̱ döka̱ duas kul. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","E' ukuöki̱ ta̱ duas skà datskene kul e' dör ketba tai̱ë duéswö. Bli e' tö Egipto ko̱s sulu'we̱rawa̱. E' kue̱ki̱ duas kul buaë e' a̱ dalì wöne tai̱ë e' kë̀ a̱rpaia̱ yi é̱na. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Bli a̱rdaë tai̱ë darërë, e' kue̱ki̱ dalì wönebak tai̱ë e' peli kë̀ wërpaia̱ yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","A këkëpa, be' kabsué̱ bötökicha, e' wà kiane chè tö Skëköl tö iwe̱raë moki̱ë. Bli döraë se' ki̱ bet. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","A këkëpa, be' ka̱wöta̱ wëm yulök eköl e̱rbikö̀ buaë wa̱ íyi jche̱r tai̱ë ese. E' múka̱ ká̱ kue̱bluie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ikaneú̱ i' es: wëpa yulö́ a̱s ie'pa mi' Egipto ko̱s a̱ daliwö kak blök daliwö tso' tai̱ë duas kul e' dalewa. Mik daliwö tso' döka̱ saco ske̱l eta̱ ikiö́ ia̱ saco et blënoie ketba yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ie'pa a̱ ichö́ tö daliwö ñe' ko̱s dapa'ú̱ bánet bánet ká̱ tso' ko̱s Egipto e' a̱. E' kkö'nuk patkö́ be' wák tö sulitane tioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Es daliwö blërdaë a' wakpa ulitane a̱ a̱s ie'pa kë̀ ttö̀ ketba tö mik ketba duéswö de s'ki̱ eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ì ché José tö ie' a̱ e' mène buaë ie' a̱ ena ikue̱blupa ko̱s e'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","E' kue̱ki̱ ie' tö iché ie'pa a̱: —Wëm i' a̱ Skëköl Wiköl tso'. Kë̀ se' a̱ wëm skà ku̱rpa we̱s ie' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Eta̱ ie' tö iché José a̱: —Skëköl tö íyi ulitane ikkë e' kkaché be' a̱. E' kue̱ki̱ be' e̱rbikö̀ buaë, be' wa̱ íyi jche̱r tai̱ë sulitane tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Be' tkekeka̱yö ye' ká̱ ko̱s e' wökirie. Sa' wakpa ko̱s tö be' ttö̀ dalöieraë. Ye' eköl ë̀ dör kibiie be' tsa̱ta̱, ye' dör blu' e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","I̱'ñe ye' tö ichè tö be' dör Egipto wökir kibi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Eta̱ blu' tö iulatsio tso' iwa̱ ikka shtoie, e' yéttsa̱ iéwa̱ José ulatska a̱. José paiérakitö datsi' bua'bua ese wa. Ñies bulë dör oro ese iéwa̱itö José kuli' a̱ et. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","E' ukuöki̱ ta̱ ie' tö José ké e̱' tkökka̱ shkök karreta shköke ie' karreta itöki̱ e' ki̱. Ie' tö ie'pa we̱lepa patkémi ke̱we ichök pë' a̱ a̱neule: “¡A' e̱' skö́! ¡Ka̱wö mú se' wökir kibi datse̱ a̱s e' tkö̀mi!” Es ie' tö José yué Egipto wa'ñe e' wökirie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Eta̱ blu' tö iché José a̱: —Ye' dör Egipto blú erë kë̀ yi a̱ ì o̱nuk ká̱ i' ki̱, be' kë̀ wa̱ iké̱wö mène e' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ie' tö José kiè méka̱ Safenat-panéah egiptowak ttö̀ wa. Ie' tö tayë kiè Asenat e' mé José a̱ se̱nowa̱ie. E' dör wëm kiè Potifera e' alà busi. Potifera dör egiptowak sacerdote eköl. Ie' kaneblöke ká̱ kiè On ee̱. Es José a̱te̱ Egipto wa'ñe e' wökirie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Mik ie'pa wa̱ José dë'bitu̱ blu' ska', e' ké̱wö ska' ta̱ ie' ki̱ duas tso' dabom mañayök (30). José e̱' chéa̱t blu' a̱ ta̱ imítke ikaneu̱k Egipto ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Duas kul tsá̱ shu̱a̱ dalì wöne tai̱ë shu̱te̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Daliwö e' ko̱s kak dapa'wé̱ José tö ta̱ ibléitö ká̱ wa'ñe. Wé̱ dalì e' wöne ese wakpa ká̱ a̱ ibléa̱t u tso' daliwö blóie ese a̱. Es ibléitö ká̱ ulitane tso' Egipto e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ie' tö daliwö dapa'wé̱ tai̱ë we̱s dayë tsé̱wö kë̀ ishta̱r es. E' kue̱ki̱ ie' kë̀ wa̱ ishta̱neia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ketba ké̱wö ka̱m döwa̱ e' yöki̱ José alaköl kiè Asenat, e' alà ku̱ne böl wëpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Mik ilà tsá̱ ku̱ne, eta̱ José tö iché: “Skëköl tö ye' bak e̱rianuk ena ye' yamipa e' ko̱s chöwé̱wa ye' é̱na.” E' kue̱ki̱ ikiè méka̱itö Manasés. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mik ilà skà ku̱ne, eta̱ ie' iché: “Skëköl tö ye' a̱ alà mé ká̱ wé̱ ki̱ ye' bak weinuk tai̱ë ee̱.” E' kue̱ki̱ ikiè méka̱itö Efraín. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Duas kul dalì wöne tai̱ë Egipto e' tka. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","E' ukuöki̱ ta̱ duas kul skà debitu̱ e' dör ketba poë duéswö we̱s José tö iyë' es. Ketba de ká̱ wa'ñe erë Egipto ko̱s a̱ chkewö tso'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Mik Egipto wakpa teketke ketba tö, eta̱ ie'pa mía̱ iblú a̱ chkewö kiök. Ie' tö iché ia̱rak: “A' yú José ska' ta̱ ì ko̱s chéitö a' a̱ e' wà iu̱tö́.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Mik ketba de ká̱ wa'ñe, eta̱ José tö dalì tso' blëule iwé a̱ e' ko̱s kköppée chkewö watuo̱ Egipto wakpa a̱. Ketba kí̱ datse̱ tai̱ë shu̱te̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ká̱ ulitane wakpa a̱ kë̀ ì ku̱'ia̱ katanoie, e' kue̱ki̱ ie'pa de Egipto chkewö ta̱u̱k José ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Mik Jacob wa̱ ijche̱newa̱ tö chkewö tso' Egipto watuè̱, eta̱ ila'r a̱ ichéitö: “¿Iö́k a' iëte̱r ñì sa̱u̱k ë̀? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ye' a̱ iyëne tö chkewö tso' Egipto. A' yú ee̱ chkewö ta̱u̱k a̱s kë̀ se' duö̀lur ketba wa̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Eta̱ José ëlpa döka̱ dabop, e'pa míyal Egipto chkewö ta̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Erë Jacob kë̀ wa̱ ilà Benjamín, e' dör José ël táie imì wa, e' patkënemi iëlpa ta̱ ie' ibikeitsé dö' ì tkö̀ ita̱ ñala̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ketba tso' tai̱ë Canaán e' kue̱ki̱ tai̱ë Canaánwakpa míyal chkewö ta̱u̱k Egipto. Esepa shu̱a̱ Jacob ala'r mirwa̱rak chkewö ta̱u̱k ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","José dör Egipto ká̱ kue̱blu. Ie' tö chkewö watue̱ke sulitane datse̱ ita̱u̱k e'pa a̱. Mik iëlpa demi iwörki̱, eta̱ ie'pa wöéwa dö̀ i̱ski̱ ie' dalöiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ie' tö ie'pa sué̱wa̱ bet tö ie'pa dör iëlpa. Erë ie' e̱' éwa iyöki̱ we̱s kë̀ ie' wa̱ isu̱ule es. Kë̀ ie' e̱' kkayënewa̱ ie'pa a̱ tö ie' dör ie'pa ël. Eta̱ ie' tö iëlpa chaké kësik wa: —¿Wé̱ a' se̱kkëpa bite̱? Ie'pa tö iiu̱té: —Sa' bite̱ Canaán chkewö ta̱u̱k be' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ie' tö ie'pa sué̱wa̱, erë ie'pa kë̀ wa̱ ie' su̱newa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ie' tö iëlpa kébisu̱' e' a̱newa̱ ie' é̱na. Ie' tö iché ie'pa a̱: —A' dör sa' bolökpa datse̱ sa' sa̱u̱k tö we̱s a' döwa̱mi ñippök sa' ta̱ e̱' aloka̱ sa' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ie'pa iiu̱té: —A këkëpa, e' kë̀ dör es. Sa' kë̀ dör a' bolökpa. Sa' debitu̱ chkewö ë̀ ta̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Sa' ko̱s i' e' yë́ dör eköl ë̀. Sa' se̱rke buaë yësyësë. Kë̀ sa' dör yi bolökpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ie' tö ichéne ie'pa a̱: —Au. A' se̱kkë tso' ka̱chök. A' datse̱ sa' ká̱ sa̱u̱k tö we̱s a' döwa̱mi ñippök sa' ta̱ e̱' aloka̱ sa' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Erë ie'pa tö iiu̱té: —Sa' tso' be' wörki̱ we̱s be' kanè mésopa es. Sa' döka̱ dabom eyök ki̱ böl (12). Sa' yë́ dör eköl ë̀. Sa' se̱rke Canaán. Sa' ël tsirla ë́k e' a̱te̱ sa' yë́ ta̱. Iëköl blënewa̱tke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Erë ie' tö iskà chénerakia̱: —Ye' ichétke tö a' dör sa' bolökpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Egipto blú ttö̀ wa yö ichè a' a̱ tö a' kë̀ wa̱ a' ël tsirla e' dë' í̱e̱, e' ta̱ a' kë̀ mi'pa ká̱ i' ki̱. Es ye' isuè̱mi tö a' ttö̀ moki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","A' eköl yú a' tsirla tsu̱kbitu̱. A' male̱pa a̱te̱ wötëule. Es ye' wa̱ ijche̱rmi tö a' ttöke e' dör moki̱. E' kë̀ yëne, e' ta̱ a' dör sa' bolökpa. E' chéyö Egipto blú ttö̀ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ie' tö ie'pa wötéwa̱ se̱kka̱ döka̱ ká̱ mañat. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ká̱ de mañat eta̱ ie' tö iché ia̱rak: —Ye' tö Skëköl dalötse̱ta̱'ka̱. Ì cheke ye' tö a' a̱ e' ú̱, e' ta̱ ye' kë̀ tö a' ttökwa̱ patkepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Yëne tö a' dör wëpa ttö̀ moki̱ ese, e' ta̱ a' eköl múa̱t wötëule. A' male̱pa yúne, chkewö tsú̱mi a' yamipa tteke ketba tö e'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","E' ukuöki̱ ta̱ a' ël tsirla e' tsú̱bitu̱ ye' a̱ suè̱. Es ye' tö isuè̱mi tö a' ttöke e' dör moki̱. E' kë̀ dör es, eta̱ a' duöralur. Eta̱ ie'pa tö iché: “E' dör buaë sa' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Eta̱ ichérakitö ñì a̱: —Moki̱ë se' e̱' wamblë' suluë se' ël José ta̱. Mik ie' kköyë' tai̱ë se' a̱ tö ì sulu kë̀ wamblar ie' ki̱ erë́ se' isu̱' tö tai̱ë ie' e̱riane, erë kë̀ e' ska' se' tkine. E' nuí̱ ki̱ se' weirke i̱'ñe. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Eta̱ Rubén tö iiu̱té: —Ye' tö iyë' a' a̱: “Kë̀ ì wamblar José ki̱.” Erë a' kë̀ wa̱ ye' ttö̀ iu̱tëne. E' kue̱ki̱ i̱'ñe ta̱ se' ka̱wöta̱ idu'wa̱ e' nuí̱ patau̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","José ttöke iëlpa ta̱ egiptowak ttö̀ wa e' pakekene o̱'ka tö ie'pa a̱ iwakpa ttö̀ wa. E' kue̱ki̱ ie'pa kë̀ wa̱ ijche̱r tö ie'pa ttöke e' a̱ne ie' é̱na. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Mik ie' tö ie'pa ttöke e' ttsé, eta̱ ie' e̱' skéttsa̱ mía̱ bánet i̱u̱k. Mik ie' e̱r deka̱ne ttoie, eta̱ ie' dene ie'pa ska'. Ie' tö Simeón yöktsa̱ patké ta̱ ipayuéwa̱rakitö iëlpa wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","E' ukuöki̱ ta̱ ie' tö ikanè mésopa patké iëlpa sku' wà iök chkewö wa. Ñies ichéitö ia̱rak: “Ie'pa chkewö e' ské iö́wa̱ iwakpa bil ekkë sku' a̱. Ñies chkè bakö́mirakia̱ ñè ñala̱ ki̱.” Eta̱ ie'pa tö iwé̱ we̱s ie' tö iché ia̱rak es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","E' ukuöki̱ ta̱ ie'pa tö ichkewö méka̱ iburro ki̱ ta̱ imíyal. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mik ie'pa demi ñala̱ ki̱ wé̱ ie'pa kapökerö ee̱ eta̱ ie'pa eköl tö isku' a̱ burro chkö̀ tso' e' kkö̀ wöttsée iburro tioie ta̱ isué̱ tö inuköl àr sku' shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ie' tö iché iëlpa a̱: —¡Isa̱ú̱! Ye' inuköl mébitu̱ne ie'pa tö e' àr sku' a̱. Ie'pa ulitane suane tai̱ë e̱riane tai̱ë. Ichérakitö ñì a̱: —¿Ì wamblök Skëköl tso' se' ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Mik ie'pa demine Canaán, eta̱ ì tka ie'pa ta̱ Egipto e' ko̱s pakérakitö iyë́ a̱. Ie'pa tö iché ia̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","—Ká̱ e' wökir e' tté sa' ta̱ kësik wa. Ie' tö iché tö sa' dör ie'pa bolökpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Sa' tö iché ia̱: “Sa' se̱rke buaë. Kë̀ sa' dör yi bolökpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Sa' döka̱ dabom eyök ki̱ böl. Sa' yë́ dör eköl ë̀. Sa' ël eköl blënewa̱tke, iëköl a̱te̱ sa' yë́ ta̱ Canaán.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Eta̱ ie' tö sa' iu̱té: “A' ttö̀ moki̱, e' ta̱ a' ël eköl e' múa̱t í̱e̱ ye' ska' eta̱ chkewö tsú̱mi a' yamipa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Erë a' ël tsirla ë́k e' tsú̱bitu̱ ña suè̱. Es ye' wa̱ ijche̱rmi tö a' ttö̀ moki̱. A' tö iwé̱ es, e' ta̱ ye' tö a' ël èmimine. Ñies a' íyi tuè̱mi bua' sa' ká̱ i' ki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Mik José ëlpa tso' isku' wakkau̱k, eta̱ ie'pa isué̱ sku' a̱ inuköl deyal parratulewa̱. Mik e' sué̱, eta̱ ie'pa tkirulune iyë́ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob tö iché ia̱rak: —A' tso' ye' muka̱t alà kë̀ ta̱'. José blënewa̱ se' yöki̱. Simeón ñies, kë̀ ku̱' se' ta̱. I' ta̱ Benjamín kiane tsè̱mi a' ki̱ darë wa. Ke̱kraë ye' weirke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubén tö iché iyë́ a̱: —Bejamín múmi ye' a̱. Ye' tö ikkö'neraë buaë. Ye' wa̱ idörane be' a̱. Ye' kë̀ wa̱ idë'ne, e' ta̱ ye' alà böl e' ttö́lur. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ie' tö iiu̱té: —Ye' alà kë̀ mìne a' ta̱. Iël José du'wa̱ ta̱ ie' ë̀ dawa̱ia̱. Dö' ì sulu tkö̀ ie' ta̱ ñala̱ ki̱, e' ta̱ këkëla i' duömiwa̱ ilà dalërmik ta̱ a' iane iwiie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ketba tkëneia̱ darërë Canaán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Chkewö dë'bitu̱rak iwa̱ Egipto, e' e̱newa. Eta̱ Jacob tö iché ila'r a̱: —A' yúne chkewö skà ta̱u̱k se' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Erë Judá tö iiu̱té: —Wëm tso' ee̱ e' tö iyë' sa' a̱ yësyësë: “A' kë̀ wa̱ a' ël tsirla dë' í̱e̱, e' ta̱ a' kë̀ tö ye' sue̱pa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Be' tö sa' ël tsirla émi sa' ta̱, e' ta̱ sa' mi'mi chkewö ta̱u̱k be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Erë be' kë̀ tö ièmi sa' ta̱, e' ta̱ kë̀ sa' mìne. Wëm e' tö sa' a̱ iché: “A' kë̀ wa̱ a' ël tsirla dë' í̱e̱, e' ta̱ kë̀ a' tö ye' sue̱pa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Jacob tö iiu̱té: —¿Iö́k a' tö ì sulu wambleke tai̱ë ye' ki̱? ¿Iö́k a' tö iché wëm e' a̱ tö a' ël skà tso'ia̱ eköl? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ie'pa tö iiu̱té: —Wëm e' tö sa' chakéwa̱ie darë wa: “¿A' yë́ tso'ia̱ ttsë'ka? ¿A' ël skà tso'?” Kë̀ we̱s sa' a̱ io̱nukia̱. Sa' ka̱wöta̱ iiu̱tök yësyësë. Sa' kë̀ wa̱ ijche̱r tö wëm e' tö sa' a̱ ichémi: “A' ël tsú̱bitu̱ ye' a̱ suè̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judá tö iché ie' a̱: —Se' se̱nakia̱, e' ta̱ be' alà ö́mi ye' ta̱. Ye' tö ikkö'neraë. Es be' ena sa' ena se' ala'r ko̱s kë̀ duöpalur ketba wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ye' e̱' chö̀ ie' skéie. Ì de we̱s ie' ta̱, e' nuí̱ tue̱raëyö. Ye' kë̀ wa̱ ie' dë'ne be' ska', e' ta̱ ye' iane iwiie ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kë̀ sö ka̱wö chöu̱k tai̱ë. Warma i' ta̱ sa' daretke bötökicha. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Iyë́ tö iiu̱té: —E̱'ma kë̀ we̱s io̱nuk. A' tö iú̱ i' es: A' sku' a̱ íyi bua'bua tso' se' ká̱ a̱, ese kak tsú̱mi wëm e' a̱. Bálsamo elkela ena bul alí elkela ena kiö̀ masmas ena mirra ena kalwö wödalo katanoie ese ko̱s kak tsú̱mi ia̱ elkela. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ñies inuköl tsú̱mi ia̱ jaishe̱t döka̱ bötökicha. Wé̱ a' wa̱ idë'ne e' tsú̱mine múne ia̱ a' wák ulawa dö' ie' wöa̱ ká̱ chë'wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","A' yúne wëm e' ska'. Alà tsú̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Skëköl Diché Ta̱' Íyi Ulitane Tsa̱ta̱ e' a̱ ikiéyö a̱s wëm ñe' tö a' sa̱ù̱ e̱r sia̱rë wa ta̱ imú tö be' ël ena Benjamín ö́bitu̱ne. Ye' a̱te̱ alà kë̀ ta̱', erë ¿we̱s ye' e̱' ù̱miia̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Eta̱ Jacob ala'r tö íyi kak ié, ñies inuköl ié jaishe̱t döka̱ bötökicha. Ñies Benjamín mírak iwa̱ ta̱ imíyal. Mik idemirak José ska' ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","eta̱ ie' isué̱ tö Benjamín debitu̱ ie'pa wa̱. Ie' tö iché iu kue̱blu a̱: —Wëpa wí̱kkë tsú̱mi ye' u a̱. Be' yú baka ttökwa̱ elka e' kaneú̱ se' a̱. Ie'pa chköke i̱'ñe ye' ta̱ dibata a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Eta̱ iu kue̱blu tö iwakanewé̱ we̱s ichéitö ia̱ es. Imítse̱rak iwa̱ e̱' ta̱ José u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Erë tai̱ë ie'pa tkinewa̱ imítse̱rak iwa̱ José u a̱ e' kue̱ki̱. Ie'pa ttöramirak ñita̱: Ie'pa tso' se' ki̱tö'u̱k. Ie'pa tö inuköl ië'mi se' sku' a̱ e' nuí̱ tkëne se' mik. E' nuí̱ kue̱ki̱ ie'pa tö se' klö'we̱rawa̱ kaneblök ie'pa a̱ kanè mésopaie kë̀ patuè̱ ta̱' ese. Ñies se' iyiwak klö'we̱rawa̱rakitö nuí̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Mik ie'pa demi u wékkö a̱, eta̱ ie'pa de tsi̱net u kue̱blu wörki̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ta̱ ichérakitö ia̱: —A këkëpa, su̱köt sa' dë' í̱e̱ chkewö ta̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Erë sa' dë'mi wé̱ sa' kapökerö ee̱ ta̱ sa' sku' ko̱s kkö̀ wöttsée ta̱ e' a̱ ko̱s sa' tö chkewö to̱' e' inuköl kué̱ne sa' tö se̱raa̱. E' debitu̱ne sa' wa̱ mène. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ñies sa' wa̱ inuköl skà de chkewö kí̱ tuo̱ie. Erë kë̀ sa' wa̱ ijche̱r yi tö sa' inuköl ië'ka̱ne sa' sku' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","U kue̱blu tö iiu̱té: —Kë̀ a' tkinuk. Kë̀ a' suanuk. Ye' tö a' chkewö pato̱' e' inuköl klöo̱'. A' Këköl dör a' yë́ Këköl ñies, e' tö inuköl e' ië'wa̱ a' sku' a̱. E' ukuöki̱ ta̱ ie' tö Simeón yéttsa̱ tsé̱mi wé̱ iëlpa tso' ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","E' ukuöki̱ ta̱ imítse̱rak iwa̱ se̱raa̱ José u a̱. Eta̱ di' méitö ia̱rak klö̀ skuoie. Ñies iburro tiérakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ie'pa wa̱ ijche̱newa̱ tö ee̱ ie'pa chköke José ta̱ dibata a̱. E' kue̱ki̱ ie'pa wa̱ íyi kak de ie' a̱ e' dapa'wé̱rakitö mè ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Mik ie' dewa̱ we̱shke̱, eta̱ ie'pa wa̱ íyi kak de e' mé ia̱. Ie'pa wöéwaie dö̀ i̱ski̱ idalöiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ie' tö ie'pa shke̱'wé̱ ta̱ ichakéitö: —A' yë́ de këkëpalatke yë' a' tö ye' a̱ su̱köt ¿is e' tso'? ¿Idobyërkeia̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ie'pa skà wöéwane dö̀ i̱ski̱ ta̱ ichéitö: —A këkëpa, tö́, sa' yë́ tso' buaë. Ie' dobyërkeia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Eta̱ José ká̱ sué̱ ipamik shkit, ta̱ Benjamín dör iël e̱kka imì wa ena iyë́ wa e' sué̱itö. Eta̱ ichéitö ie'pa a̱: —A' ël tsirla yë' a' tö ¿e' dör wí̱? Ie' tö iché Benjamín a̱: —A alà, Skëköl e̱r buaë chö̀ be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ie' tö iël sué̱wa̱ e' tö ie' ttsë'wé̱ buaë ta̱ ie' ia̱kka̱. Bet ta̱ ie' e̱' skéttsa̱ mía̱ wé̱ ikapöke ee̱ i̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Mik ie' i̱é̱ o̱ne ta̱ ie̱r pablëne ta̱ iwö skuée ta̱ imía̱ne iëlpa skà ta̱ ichéitö: “Chkö̀ watiö́ bet.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","José tiérakitö bánet. Iëlpa tiérakitö bánet. Egiptowak chköke José u a̱ e'pa tiérakitö bánet ñies. Hebreowak dör ñá egiptowak a̱ e' kue̱ki̱ ie'pa kë̀ a̱ ka̱wö ta̱' chkök ie'pa ta̱ ñita̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","José tö ie'pa tulökwa̱ patké chkök ñì o̱'mik we̱s duas tso' iki̱ es dö̀ ibataë. Ie'pa tö ibikeitsé: “¿We̱s ie'pa wa̱ se' duéswö jche̱r?” E' kue̱ki̱ ie'pa tkinewa̱ tai̱ë ta̱ iñi sué̱ka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ie'pa dëne chkè tso' José mesa ki̱ e' wa. Es iméitö ulitane a̱. Erë Benjamín a̱ chkè méitö kibiie döka̱ ske̱tökicha iëlpa dëne e' tsa̱ta̱. Ie'pa chké tai̱ë blo'yé José ta̱ ttsë'ne buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","E' ukuöki̱ ta̱ iu kue̱blu kiére José tö ta̱ ichéitö ia̱: —Ie'pa sku' ko̱s wà iö́ka̱ chië chkewö wa. Ñies ie'pa inuköl iö́ka̱ne isku' ko̱s kkö̀ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ñies ye' tka̱' yöule inukölchka wa tso' ye' wa̱ wayè e' iö́ka̱ ie'pa ël tsirla e' sku' kkö̀ ki̱, inuköl chkewö patuo̱ e' ta̱ ñita̱. Eta̱ u kue̱blu tö iwakanewé̱ we̱s José tö iché ia̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Bule es bla'mi diwö tskine ta̱ José tö iëlpa a̱ ka̱wö mé shkökne iu a̱ iburroë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ka̱m ie'pa dö̀mi ka̱mië, eta̱ ie' tö iché iu kue̱blu a̱: —Be' yú ie'pa itöki̱. Mik be' ikué̱, eta̱ ichö́ ia̱: ‘Ye' e̱' wé̱ buaë a' ta̱, ¿iö́k a' e̱' wamblé sulu ye' ki̱? ¿Iö́k a' tö ye' wökir tka̱' yöule inukölchka wa, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","e' dör wayè ena íyi tötkoie, e' bléwa̱bitu̱ a' tö? A' e̱' wamblé suluë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mik ie' ikué̱rak, eta̱ ichéitö we̱s iwökir tö iché ia̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Eta̱ ie'pa tö iiu̱té: —¿Iö́k be' tö ttè e' ché sa' a̱ es? Kë̀ ekkë chö́k sa' e̱' wamblö̀pa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Sa' bite̱ Canaán tkörö í̱e̱ inuköl mìne sa' sku' a̱ e' mukne. ¿We̱s be' ibikeitsèmi tö sa' tö inukölchka ö orochka e' blèwa̱mi be' wökir u a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Sa' sku' shu̱yulö́. Yi icha a̱ ikué̱bö, a̱s e' wák duö̀wa̱. Sa' male̱pa a̱te̱ be' kanè mésopaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ie' tö iché ie'pa a̱: —Iwà tköraë we̱s a' tö iché es. Erë wé̱ ë́k sku' a̱ iku̱newa̱ e' ë̀ döraë ye' kanè mésoie. A' male̱pa kë̀ iane iwiie. A' mi'mine buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","E' bet ie'pa ulitane tö isku' éwa i̱ski̱ ta̱ ikkö̀ wöttsélor. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","U kue̱blu tö sku' shu̱yulérak ikibi ë́k ke̱we dö̀ itsirla Benjamín ska'. Eta̱ Benjamín sku' kkö̀ a̱ tka̱' àr. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ie'pa datsi' jchélor e̱riane tai̱ë kue̱ki̱. Ie'pa dalì payuéne burro ki̱ ta̱ ibite̱yalne José ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Mik Judá ena iëlpa demine José ska', eta̱ José duria̱. Ie'pa wöéwa i̱ski̱ iwörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","E' dalewa ie' tö iché ia̱rak: —¿Iö́k a' e̱' wamblö̀ es? ¿A' kë̀ wa̱ ijche̱r tö wëm dör we̱s ye' es, e' s'tötkè buaë? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judá tö iiu̱té: —¿I̱ma sa' tö be' iu̱tèmi? ¿Ì wa sa' tö be' a̱ ikkachèmi tö sa' kë̀ wa̱ ì sulu wamblëne? Ì wamblëule sulu sa' wa̱ e' sué̱ Skëköl tö. I' sa' iëte̱r be' wörki̱. Sa' klö'ú̱ be' kanè mésoie. Yi sku' a̱ be' tka̱' ku̱ne e' klö'ú̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Erë ie' tö iiu̱té: —Kë̀ ye' a̱ e' wamblënuk es. Yi sku' a̱ ye' tka̱' ku̱ne, e' ë̀ a̱te̱ ye' kanè mésoie. A' male̱pa mi'mine buaë a' yë́ ska'. Kë̀ yi tö a' tsiriwe̱pa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Eta̱ Judá debitu̱ José wörki̱ tsi̱net, eta̱ ichéitö ia̱: —A këkëpa, be' we'ikèyö, mishka ttök se' böl ë̀. Be' dalö̀ dör we̱s Egipto blú dalö̀ es e' kue̱ki̱ kë̀ be' ulunuk ye' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Be' tö sa' a̱ ichaki' tö sa' yë́ ta̱', sa' ël skà ta̱'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Sa' tö be' iu̱të' tö́, sa' yë́ ta̱' këkëpalatke, ñies sa' ël ta̱' eköl ià̱ duladula. E' ku̱ne mik sa' yë́ kënewa̱tke eta̱. Sa' be' a̱ iyë' tö sa' yë́ ki̱ tai̱ë ilà tsirla ë́k kiar. Alà e' ë̀ a̱té̱a̱t imì a̱. Ie' ël blënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Be' tö sa' a̱ iyë' tö alà e' tsú̱bitu̱ suè̱yö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Sa' tö be' a̱ iyë' tö kë̀ ie' dö̀pa. Kë̀ ie' a̱ iyë́ menuka̱t ekörla. Mik ie' tö iyë́ méa̱t eköl, eta̱ iyë́ duöwa̱mi ie' dalërmik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Erë be' sa' a̱ iyë' tö sa' kë̀ wa̱ ie' dë', e' ta̱ be' kë̀ sa' kiepawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Mik sa' dë'mine sa' yë́ wörki̱, eta̱ ì ko̱s yë' be' tö sa' a̱, e' paké sa' tö ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ie' tö sa' a̱ iché: ‘A' yúne chkewö ta̱u̱k.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Erë sa' tö iiu̱té: ‘Sa' ka̱wöta̱ sa' ël tsirla tsu̱kmi. Sa' kë̀ wa̱ ie' mìne, e' ta̱ wëm e' kë̀ tö sa' kiepawa̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ie' tö sa' iu̱té: ‘A' wa̱ ijche̱r buaë tö ye' alaköl e' tö ye' a̱ alà mé böl ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ia̱ia̱ë eköl minea̱ ye' yöki̱, kë̀ ye' wa̱ isu̱neia̱. Ye' iklö'wé̱ tö ie' kötwa̱ iyiwak sulusi tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","A' wa̱ ye' alà bata i' mítse̱r ta̱ ì sulu tka ie' ta̱ ñala̱ wa, e' ta̱ wö'kela i' duörawa̱ e̱riar ë̀ wa̱. Itka es, e' ta̱ a' iane iwiie.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Sa' yë́ é̱na ilà dalër tai̱ë. E' kue̱ki̱ sa' demine ie' ska', erë ie' isué̱ tö ilà tsirla kë̀ dë'ne sa' wa̱, e' ta̱ ie' duörawa̱ e̱riar ë̀ wa̱. E' wiie sa' iardaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ye' tö ye' yë́ a̱ iyë': ‘Ye' e̱' chö̀ be' alà tsirla kkö'nuk. Ye' kë̀ wa̱ idë'ne, e' ta̱ ye' iane iwiie ke̱kraë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","E' kue̱ki̱ ye' kköchö̀ be' a̱ tö ye' tsú̱a̱t be' kanè mésoie, alà tsirla skéie. Ie' ö́mi a̱s imi' iëlpa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Alà tsirla kë̀ minene ye' ta̱, e' ta̱ ¿we̱s ye' mi'mine ye' yë́ ska'? Ye' kë̀ ki̱ ye' yë́ kiane suè̱ weinuk sia̱rë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","José kë̀ a̱ iwöklöneia̱ ikanè mésopa ulitane tso' kaneblök ee̱ e'pa wörki̱. E' kue̱ki̱ ie' tö iché ie'pa a̱ a̱neule: “A' ko̱s yúshka bánet. Sa' múa̱t sa' wakpa ë̀.” Es mik José e̱' chéka̱ iëlpa a̱, eta̱ ikanè mésopa kë̀ ku̱' yës ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Eta̱ ie' i̱é̱ka̱ tai̱ë, e' ttsé Egipto wakpa tö. Egipto blú a̱ itté demi tö José tso' i̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","José tö iché iëlpa a̱: —Ye' dör José. ¿Se' yë́ tso'ia̱ ttsë'ka? Ie'pa tkirulune tai̱ë suane José yöki̱, e' kue̱ki̱ kë̀ ie'pa a̱ ie' iu̱tëneia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","José tö iché ie'pa a̱: —A' shkö́wa̱ tsi̱net ye' o̱'mik. Mik ie'pa e̱' skéwa̱ tsi̱net, eta̱ ie' tö iché ie'pa a̱: —Ye' dör a' ël José wato̱'ttsa̱ a' tö tsè̱mi Egipto e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Skëköl tö ye' patkë'bitu̱ í̱e̱ a' yöki̱ ke̱we s'tsa̱tkoie ketba ulà a̱. E' kue̱ki̱ kë̀ a' e̱rianuk, kë̀ a' tkinuk ye' wato̱'ttsa̱ a' tö e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ketba de e' ki̱ duas de bök. Eta̱ duas ske̱l kianeia̱. E' shu̱a̱ íyi ko̱s kuatkèmisö erë kë̀ itskirpa yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Erë Skëköl tö ye' patkë'bitu̱ ká̱ i' ki̱ a' yöki̱ ke̱we a̱s a' aleripa kë̀ e̱rwa a̱s Skëköl tö a' tsa̱tkö̀ ie' diché tai̱ë e' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Es Skëköl wák tö ye' patkë'bitu̱ í̱e̱, e' kë̀ dör a' ye' wato̱'ttsa̱ e' kue̱ki̱. Skëköl tö ye' méka̱ Egipto blú pattökwakie. Ye' dör ie' u kue̱blu ena Egipto wa'ñe wökir. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","A' yúne bet ye' yë́ ska' ta̱ ichö́ ia̱: ‘Be' alà José ttè i' patkébitu̱ be' a̱: Skëköl tö ye' méka̱ Egipto ká̱ ko̱s, e' wökirie. Be' shkö́ ye' sa̱u̱k bet. Kë̀ bö ipanuk tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Be' se̱rdaë ká̱ kiè Gosen ee̱ be' yamipa ko̱s ta̱, ñies be' iyiwak ko̱s ena ì ko̱s tso' be' wa̱ ekkë ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ketba duéswö kianeia̱ ske̱l. E' kue̱ki̱ ye' tö chkewö meraë a' ulitane a̱ a̱s a' wa̱ chkewö tso' wë'.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ye' ël Benjamín ena a' ulitane tö ichèmi ye' yë́ a̱ tö moki̱ ye' wák tté a' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ipakö́ ye' yë́ a̱ tö ye' dör Egipto wökir. Ñies ì ko̱s sué̱ a' tö í̱e̱, e' pakö́ ia̱. ¡Ye' yë́ tsú̱bitu̱ bet í̱e̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Eta̱ José tö iël Benjamín paklö'wé̱wa̱ ta̱ ii̱é̱ka̱. Es Benjamín tö José paklö'wé̱wa̱ ta̱ ii̱é̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Eta̱ José tö iëlpa ko̱s wöalattsé, ñì paklö'wé̱wa̱rak ta̱ ii̱é̱rak. Eta̱ e̱rpa iëlpa e̱r deka̱ ttök ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Eta̱ Egipto blú u a̱ ttè demi tö José ëlpa debitu̱ ie' ska', e' tö Egipto blú ena ikue̱blupa ko̱s e'pa ttsë'wé̱ buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Eta̱ Egipto blú iché José a̱: —Ichö́ be' ëlpa a̱: ‘A' chkewö payuö́ iyiwak ki̱ ta̱ a' yúne Canaán. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Eta̱ a' yë́ ena a' yamipa ko̱s e' tsú̱bitu̱ ye' a̱. Ká̱ tso' Egipto e' bua'ie mekeyö a' a̱. Ñies chkewö tso' Egipto e' bua'ie mekeyö a' a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ñies ichö́ ie'pa a̱: ‘karreta tsú̱mi tai̱ë a' alakölpa ena a' ala'r ena a' yë́ e'pa ko̱s tso̱bitu̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Egipto íyi tso' bua'bua e' kakmeraëyö a' a̱. E' kue̱ki̱ kë̀ a' tkinuk ì tso' a' wa̱ e' ki̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Eta̱ Jacob ala'r tö iwé̱ i' es. José tö karreta mé ie'pa a̱ we̱s Egipto blú tö iché es. Ñies chkö̀ méitö ie'pa a̱ ñè ñala̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ñies datsi' pa̱'a̱li̱ mé ia̱rak e̱' mane'wo̱ie. Erë Benjamín a̱ datsi' kakméitö ske̱tökicha iënoie. Ñies inuköl wömule̱ méitö ia̱ döka̱ cien mañalyök (300). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Íyi bua'bua tso' Egipto e' kak patkémi iyë́ a̱ payöule burro ki̱ döka̱ dabop. Ñies trigowö ena pan ena chkewö skà e' payuéitö burro dabop skà ki̱ iyë́ a̱ ñè ñala̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Mik José ëlpa mitke, eta̱ José tö iché ie'pa a̱: —Kë̀ a' mía̱ ñippök ñala̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ie'pa e̱' yéttsa̱ Egipto a̱ demi Canaán iyë́ ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Eta̱ ie'pa tö iché iyë́ a̱: “Be' alà José tso'ia̱ ttsë'ka. Ie' tso' Egipto ká̱ ko̱s e' wökirie.” Ttè e' tö Jacob wökrawé̱wa̱ tai̱ë. Kë̀ ute̱ia̱. Ie' kë̀ wa̱ ttè e' klöo̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Erë mik ie'pa tö ì ko̱s yë' José tö ie'pa a̱ e' paké iyë́ a̱, ñies mik Jacob tö karreta patké José tö ie'pa tso̱mi e' sué̱, eta̱ ie' e̱r deka̱ne ttsë'ne buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Eta̱ ie' iché: “E' ë̀ kata ye' a̱, ye' alà José tso'ia̱ ttsë'ka. Ye' mi'ke isa̱u̱k ka̱m ye' blërwa̱, e' dalewa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Eta̱ Jacob e̱' yéttsa̱ iu a̱. Ì ko̱s tso' iwa̱ e' mítse̱r se̱raa̱. Mik idemirak ká̱ kiè Beerseba ee̱, eta̱ iyiwak ña'wé̱itö iyë́ Isaac, e' Këköl dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","E' nañewe Skëköl tté ie' ta̱ kabsue̱ie ta̱ ikiéitö ikiè wa: —A Jacob. Jacob tö iiu̱té: —¿Ì? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Eta̱ Skëköl iché ia̱: —Ye' dör be' Këköl. Ye' dör be' yë́ Këköl. Kë̀ be' suanuk shkökmi Egipto. Ee̱ ye' tö be' aleripa alöwe̱raë tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ye' mi'ke be' ta̱ Egipto. Ñies ye' wák tö be' aleripa yerattsa̱ne ká̱ e' a̱. Ñies mik be' duökewa̱tke eta̱ José tso' be' o̱'mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","E' ukuöki̱ ta̱ Jacob e̱' yéttsa̱ Beerseba a̱. Eta̱ ie' ala'r tö ie' iéka̱ karreta patkë' Egipto blú tö ie'pa tso̱mi e' a̱. Ñies ie'pa ala'r ena ie'pa alakölpa e'pa iéka̱rakitö karreta a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Eta̱ Jacob mía̱ Egipto iyamipaë se̱. Ie' baka ko̱s ena ie' obeja ko̱s e' mítse̱r ie' wa̱. Ñies ì ko̱s dë' ie' ulà a̱ Canaán e' mítse̱r ie' wa̱ se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ila'r ko̱s ena isibayökpa ko̱s e'pa mía̱ da'a̱ Egipto. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ikkëpa dör Israel aleripa mineyal Egipto. E'pa dör Jacob ena ila'r. Rubén, e' dör Jacob alà kibi ë́k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Eta̱ Rubén ala'r kiè: Hanoc, Falú, Hesrón, ena Carmí. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeón ala'r kiè: Jemuel, Jamín, Óhad, Jaquín, Sóhar, ena Saúl. Saúl mì dör canaánwak. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Leví ala'r kiè: Guersón, Quehat ena Merarí. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judá ala'r kiè: Er, Onán, Selá, Fares ena Zérah. (Er ena Onán, e'pa blënewa̱ Canaán.) Fares ala'r kiè Hesrón ena Hamul. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isacar ala'r kiè: Tolá, Puvá, Job ena Simrón. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabulón ala'r kiè: Séred, Elón ena Jahleel. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","E'pa ko̱s dör Jacob ala'r ku̱ne Padán-aram Lía ta̱. Ie'pa kutà kiè Dina, e' ku̱ne ee̱ ñies. Jacob aleripa ko̱s wëpa ena alakölpa e' döka̱ dabom mañayök ki̱ mañal (33). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad ala'r kiè: Sefón, Haguí, Esbón, Suní, Erí, Arodí, ena Arelí. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser ala'r kiè: Imná, Isvá, Isví ena Beriá. Ie'pa kutà kiè Sérah. Beriá ala'r kiè Heber ena Malquiel. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","E'pa dör Jacob aleripa Zilpá ta̱, e' mé Labán tö ilà busi Lía, e' a̱ ikanè mésoie. Ie'pa ko̱s döka̱ dabom eyök ki̱ teröl (16). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jacob alaköl kiè Raquel, e' ala'r kiè José ena Benjamín. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","José ala'r dör ilaköl Asenat ta̱ e'pa kiè Manasés ena Efraín. Ie'pa ku̱ne Egipto. Asenat dör wëm kiè Potifera, e' alà busi. Potifera dör egiptowak awá eköl. Ie' kaneblöke ká̱ kiè On ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamín ala'r kiè Bela, Béquer, Asbel, Guerá, Naamán, Ehi, Ros, Mupim, Hupim ena Ard. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","E'pa dör Jacob aleripa Raquel ta̱. Ie'pa ko̱s döka̱ dabom eyök ki̱ tkël (14). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan alà kiè Husim. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Neftalí ala'r kiè: Jahseel, Guní, Jezer, ena Silem. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","E'pa dör Jacob aleripa ilaköl Bilhá ta̱, e' mé Labán tö ilà busi Raquel a̱ ikanè mésoie. Ie'pa döka̱ kul (7). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jacob ta̱ iyamipa e̱kka mìne Egipto, e' wakpa döka̱ dabom teryök ki̱ teröl (66). Ie' ala'r e' alakölpa, kë̀ shta̱ne ishu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","José ala'r ku̱ne Egipto e'pa dör böl. Jacob yamipa dë'mi Egipto döka̱ dabom kuryök (70) se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Eta̱ Jacob tö ilà Judá patkémi ke̱we José a̱ ibiyöchök: “Be' shkö́ Gosen ye' ñale̱tsu̱k.” Eta̱ mik ie'pa demi Gosen, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","eta̱ José tö ikanè mésopa ké ie' karreta yöktsa̱ tsè̱mi iyë́ ñale̱tso̱ie. Mik idemi iyë́ ska' eta̱ iyë́ paklö'wé̱wa̱itö eta̱ ie' i̱é̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Eta̱ Jacob tö iché José a̱: —¡Ire' ye' blërwa̱mi buaë! Ye' be' sué̱ne buaë, be' se̱rkeia̱ e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Eta̱ José tö iché iyamipa ko̱s a̱: —Ye' mía̱ Egipto blú a̱ a' biyöchök tö ‘ye' ëlpa ena ye' yë́ yamipa ko̱s se̱rke Canaán e'pa debitu̱ e̱' tsu̱ka̱t ye' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ie'pa dör iyiwak alöu̱kwakpa. E' kue̱ki̱ ie'pa baka ko̱s ena ie'pa obeja ko̱s ena ì ko̱s tso' ie'pa wa̱ e' debitu̱ ie'pa wa̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mik Egipto blú tö a' chaké: ‘¿Ì dör a' kanè?’, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","e' ta̱ ichö́ ia̱: ‘Ke̱kraë sa' kanè dör iyiwak alöu̱k we̱s sa' tsá̱ bak es.’ Egiptowak kë̀ kàne se̱nuk obeja alöu̱kwakpa ta̱ ñita̱, e' kue̱ki̱ Egipto blú ka̱wö mèmi a' a̱ se̱nuk Gosen. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Eta̱ José mía̱ ibiyö́ muk Egipto blú a̱ ta̱ ichéitö ia̱: “Ye' yë́ ena ye' ëlpa se̱rke Canaán, e'pa debitu̱ í̱e̱. I' ta̱ ie'pa tso' Gosen. Ie'pa obeja ena baka ena ì ko̱s tso' iwa̱ e' debitu̱rak iwa̱ se̱raa̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","José tö iëlpa shu̱shté döka̱ ske̱l ta̱ imítse̱r iwa̱ Egipto blú ska' a̱s ie' tö iwakpa sa̱ù̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Eta̱ Egipto blú tö José ëlpa a̱ ichaké: —¿Ì dör a' kanè? Eta̱ ie'pa tö iiu̱té: —A këkëpa, sa' dör obeja alöu̱kwakpa we̱s sa' tsá̱ bak es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ketba meneka̱ tai̱ë sa' ka̱ska'. Sa' iyiwak a̱ kë̀ chkè ta̱'ia̱, e' kue̱ki̱ sa' bite̱a̱ se̱nuk ká̱ i' ki̱. Be' we'ikè sa' tö, ka̱wö mú sa' a̱ se̱nuk Gosen. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Eta̱ Egipto blú tö iché José a̱: —Be' yë́ ena be' ëlpa de se̱nuk be' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ká̱ tso' Egipto e' wé̱ kiane be' ki̱ e' mú ie'pa a̱ se̱noie. Ko̱s ká̱ tso' Egipto e' bua'ie dör Gosen e' mú ie'pa a̱ se̱noie. Be' yamipa shu̱a̱ wëpa tso' iyiwak kkö'nè buaë, e' ta̱ esepa múka̱ ye' iyiwak kkö'nuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ñies José wa̱ iyë́ Jacob mí kkachè Egipto blú a̱. Jacob tö Egipto blú shke̱'wé̱ e̱r bua' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Eta̱ Egipto blú tö ie' a̱ ichaké: —¿Ko̱s duas tso' be' ki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob iiu̱té: —Ye' ki̱ duas de cien eyök ki̱ dabom mañayök (130) shkök wì̱ a̱ dià a̱. Ka̱wö e' kë̀ dör tai̱ë. E' tka ye' ki̱ darërë. Erë ka̱m ye' ki̱ duas dö̀ ko̱s ye' yë́pa ki̱ duas bak ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","E' ukuöki̱ ta̱ Jacob e̱' chéa̱t Egipto blú a̱ ta̱ imía̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Eta̱ José tö ká̱ bua'bua tso' Egipto, e' mé iyë́ ena iëlpa a̱ se̱noie we̱s Egipto blú tö iché es. Ká̱ e' a̱te̱ Ramsés. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ñies ie' tö chkewö meke iyamipa a̱ ko̱s ila'rla tso' u a̱ u a̱ ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ká̱ ulitane kë̀ íyi wöria̱, e' kue̱ki̱ ketba kí̱ tkërke poë. Ketba tö s'tteke tai̱ë Canaán ena Egipto. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Chkewö tué̱ Egipto wakpa tö ena Canaánwakpa tö, e' ské ko̱s blé José tö Egipto blú u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mik Egipto wakpa ena Canaánwakpa inuköl e̱newa se̱raa̱, eta̱ Egipto wakpa mía̱ José ska' ta̱ iché ia̱: —¡Be' sa' a̱ chkewö mú! Kë̀ sa' inuköl ta̱'ia̱. Kë̀ idör bua' tö e' ë̀ kue̱ki̱ be' tö sa' méttsa̱ duökwa̱ ketba a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Eta̱ ie' tö ie'pa iu̱té: —A' kë̀ wa̱ inuköl ta̱'ia̱, e' ta̱ a' iyiwak tsú̱bitu̱ ña, e' skéie ye' tö a' a̱ chkewö meke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Egipto wakpa wa̱ kabaio ena obeja ena baka ena burro e' ko̱s mí ie' a̱. E' skéie ie' tö chkewö mé ie'pa a̱ dö̀ duas ek. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Duas e' tka eta̱ ie'pa míyalne ie' ska' ta̱ iskà ché ia̱: —Be' wa̱ ijche̱r buaë tö kë̀ sa' wa̱ inuköl ta̱'ia̱. Ñies sa' iyiwak ko̱s, e' dör be' icha. Sa' ká̱ ë̀ tso'ia̱ sa' wa̱ ena sa' wakpa, e' ë̀ tso'ia̱ sa' wa̱ mè be' a̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Sa' wákpa ta̱ú̱. Sa' ká̱ ta̱ú̱ ñies. E' skéie iyiwö mú sa' a̱. Sa' kaneblö̀mi sa' wákpa ká̱ a̱ Egipto blú a̱. Es sa' a̱te̱ Egipto blú kanè mésopaie. Eta̱ chkewö ë̀ memibö sa' a̱ a̱s kë̀ sa' duö̀lur ketba wa̱ ena sa' ká̱ kë̀ weir ë́ ichö́k. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Egipto wakpa tö iká̱ watué̱ttsa̱ José a̱ ketba kue̱ki̱. Es Egipto ká̱ ko̱s de Egipto blú ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ñies Egipto wakpa ko̱s a̱te̱ blu' kanè mésopaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ie'pa sacerdotepa ká̱ e' ë̀ kë̀ to̱ne José wa̱. Egipto blú tö chkewö kakmeke ie'pa a̱, e' kue̱ki̱ ie'pa kë̀ wa̱ iká̱ wato̱nettsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","E' ukuöki̱ ta̱ José tö iché Egipto wakpa a̱: —A' wákpa ko̱s ena a' ká̱ ko̱s e' to̱'ttsa̱ ye' tö se' blú a̱, e' kue̱ki̱ i̱'ñe ta̱ a' ko̱s a̱te̱ ie' ulà a̱. Iyiwö i' tsú̱mi a' tö ta̱ ikuatkö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Mik iwöne ta̱ iyiwö tso' döka̱ saco ske̱l, eta̱ itsá̱ yö́ttsa̱ saco et mè Egipto blú a̱. Iyiwö ëyök a̱te̱ e' dör a' a̱ kuatkè, ñies a' yamipa ulitane a̱ ñanoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Eta̱ ie'pa tö iiu̱té: —Be' tö sa' tsa̱tké ketba ulà a̱. Be' e̱r bua' sa' ta̱. E' kue̱ki̱ sa' e̱' chöke Egipto blú kanè mésopaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Es José tö ka̱wö mé Egipto wakpa a̱ tö iyiwö tso' döka̱ saco ske̱l e' tsá̱ yö́ttsa̱ saco et mè Egipto blú a̱. I̱'ñe ta̱ e' we̱keia̱ ie'pa tö es. Egipto sacerdotepa ë̀ kë̀ ka̱wöta̱ iyiwö tsá̱ muk Egipto blú a̱, ie'pa ká̱ kë̀ dë' Egipto blú ulà a̱ e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Es Israel aleripa e̱' tsé̱a̱t se̱nuk Gosen, ká̱ e' a̱te̱ Egipto. Ká̱ e' ko̱s de ie'pa ulà a̱. Ee̱ ie'pa alöne tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob se̱ne'ia̱ ká̱ e' a̱ duas döka̱ dabom eyök ki̱ kul (17). Duas de ie' ki̱ cien eyök ki̱ dabom tkëyök ki̱ kul (147). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Mik ie' tö ittsé tö iduökewa̱tke, eta̱ José tsu̱k patkéitö ta̱ ichéitö ia̱: —Moki̱ be' e̱r buaë chak ye' a̱, e' ta̱ be' ulà múwa̱ ye' tu' diki̱a̱ iwà kkachoie tö moki̱ ì kiekeyö be' a̱ e' wawe̱raëbö. Ye' nu kë̀ wötarwa̱ Egipto. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Mik ye' blënewa̱ mía̱ ye' dëu̱töpa itöki̱, eta̱ ye' nu yö́ttsa̱ ká̱ i' ki̱ tsú̱mi wötèwa̱ ie'pa pö a̱. Eta̱ José tö iiu̱té: —Es yö iwe̱raë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Iyë́ tö iché ia̱: —Ichö́ ña moki̱ Skëköl wörki̱ tö be' iwe̱raë es. Eta̱ José tö ittè mé moki̱ iyë́ a̱. Eta̱ Jacob wöméwa̱ ika̱' ki̱ ta̱ Skëköl ki̱kéka̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","E' ukuöki̱ ta̱ ie'pa wa̱ biyö̀ debitu̱ José a̱: “Be' yë́ duöke tso' suluë.” Eta̱ José mía̱ isa̱u̱k ila'r böl mí iwa̱ e̱' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Mik ie'pa tö iché Jacob a̱ tö José debitu̱ be' sa̱u̱k, eta̱ ie' e̱' tkéka̱ isulú wa ika̱' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Eta̱ ie' tö iché José a̱: —Skëköl Diché Ta̱' Íyi Ulitane Tsa̱ta̱ e' e̱' kkayë' ye' a̱ ká̱ kiè Luz a̱te̱ Canaán ee̱. Ee̱ ie' e̱r buaë yë' ye' a̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ta̱ ichéitö ña: “Ye' tö be' aleripa alöwe̱raë tai̱ë. Ie'pa döraë ká̱ tai̱ë e' wakpaie. Ká̱ i' meraëyö ie'pa a̱, e' a̱tdaë ie'pa ulà a̱ ke̱kraë michoë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Be' ala'r böl, Efraín ena Manasés, e'pa ku̱ne ka̱m ye' dö̀ Egipto e' yöki̱. Ie'pa tsé̱tköyö we̱s ye' wák ala'r es we̱s ye' ala'r Rubén ena Simeón dör ye' ala'r es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","E' kue̱ki̱ ká̱ meraëyö ie'pa a̱ we̱s ye' wák ala'r a̱ es. Ie'pa itöki̱ be' ala'r skà ku̱rmi, e'pa dör be' wák a̱. Erë ie'pa dör Efraín ena Manasés ëlpa, e' kue̱ki̱ ká̱ ñe' kak döraë ie'pa ulà a̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mik ye' manét Padán-aram e' demi Canaán dökettsa̱tke Efrata, eta̱ ee̱ ñala̱ ki̱ be' mì blënewa̱ ye' yöki̱. Ee̱ ye' tö ie' nu blë'wa̱a̱t Efrata ñalé̱ ki̱. (I̱'ñe ta̱ ká̱ e' kiè Belén.) ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Mik Jacob tö José ala'r sué̱ eta̱ ichakéitö: —¿Se̱pa dör yi? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ie' tö iiu̱té: —I'pa dör ye' ala'r mé Skëköl tö ye' a̱ ká̱ i' ki̱. Eta̱ iyë́ tö iché ia̱: —Ie'pa tsú̱bitu̱ ye' ska' a̱s ye' e̱r bua' chö̀ ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Jacob kënewa̱tke e' kue̱ki̱ iwöbla kë̀ wawëria̱ buaë. E' kue̱ki̱ José tö ila'r patkémi tsi̱net iyë́ o̱'mik. Eta̱ Jacob tö italapa paklö'wé̱ wöalattsé. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","E' ukuöki̱ ichéitö José a̱: —Ye' ibikeits tö ye' kë̀ tö be' sue̱paia̱, erë Skëköl tö ka̱wö mé ye' a̱ be' ena be' ala'r suo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Eta̱ José tö ila'r skéttsa̱ iyë́ o̱'mik ta̱ iwöéwa dö̀ i̱ski̱ iyë́ dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","E' ukuöki̱ ta̱ ila'r böl klö'wé̱wa̱itö iulà a̱. Efraín mí José ulà bua'kka, Manasés mí José ulà bakli̱'kka. Es itsé̱miitö iyë́ ska'. Eta̱ Efraín a̱te̱ Jacob ulà bakli̱'kka, Manasés a̱te̱ Jacob ulà bua'kka. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Erë Jacob ulà bua'kka méka̱ Efraín dur ie' ulà bakli̱'kka e' wökir ki̱. Erë́ e' dör alà tsirla. Eta̱ iulà bakli̱'kka méka̱itö Manasés dur ie' ulà bua'kka e' wökir ki̱. Erë́ e' dör alà kibi. Es Jacob ulà tsé̱tkö wi̱'kë io̱'kë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","16","Eta̱ ie̱r bua' ché José a̱ i' es: “A̱s Skëköl e̱r buaë chö̀ ala'r böl i' a̱ ke̱kraë. Ye' yë́pa bak Abraham ena Isaac, e'pa bak Skëköl e' dalöiök, e' tö ye' kkö'nami kuaë dö̀ ikkë ta̱. Ie' tö ye' tsa̱tké ke̱kraë íyi sulusi ulà a̱. A̱s ala'r i' wa kë̀ ye' chöwa sulitane é̱na ke̱kraë. Ñies ye' yë́pa bak Abraham ena Isaac a̱s e'pa kë̀ chöwa sulitane é̱na ke̱kraë. A̱s ala'r i' alör tai̱ë ká̱ ulitane ki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Jacob ulà bua'kka méka̱ Efraín wökir ki̱, e' kë̀ mène José a̱ buaë. E' kue̱ki̱ ie' tö iyë́ ulà bua'kka e' klö'wé̱wa̱ mèka̱ ilà kibi dör Manasés e' wökir ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","E' dalewa ichéitö ia̱: —¡A yë́wö, kë̀ idör es! I' dör alà kibi. Be' ulà bua'kka múka̱ i' wökir ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Erë iyë́ kë̀ wa̱ io̱ne es. Ie' tö iché ia̱: —¡A alà, e' jche̱r ye' wa̱, e' jche̱r ye' wa̱! Ie' alördaë tai̱ë, ie' döraë këkëpa tai̱ë. Erë itsirla ë́k e' döraë këkëpa tai̱ë shu̱te̱ ikibi tsa̱ta̱. Ñies ie' aleripa döraë ká̱ tai̱ë e' wakpaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Es e' ë̀ diwö wa Jacob e̱r buaë skà ché italapa a̱ i' es: —Mik Israel aleripa e̱r buaë cheke ñì a̱ eta̱ ie'pa tö icheraë ñì a̱ i' es: ‘A̱s Skëköl e̱r buaë chö̀ be' a̱ we̱s Efraín ena Manasés e'pa a̱ e̱r buaë yëne es.’ Es Jacob e̱r buaë ché Efraín a̱, Manasés a̱ imène, e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","E' ukuöki̱ ta̱ José a̱ ichéitö: —Ye' duökewa̱tke erë Skëköl tö a' kkö'neraë. Ie' wa̱ se' aleripa mirane Canaán wé̱ se' yë́pa bak se̱nuk ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ye' tö ká̱ bua'ie méa̱t be' a̱ ime'bakyö be' ëlpa a̱ e' tsa̱ta̱. Ká̱ e' kiè Siquem. E' yë'ttsa̱ ye' tö amorreowak ulà a̱ ñippè wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob tö ila'r kié e̱' ska' ta̱ ichéitö ie'pa a̱: “A' e̱' skö́wa̱ ye' o̱'mik. Ì tköraë a' ta̱ e' wà chekeyö a' a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“A ala'rla, a' e̱' skö́wa̱ tsi̱net ye' ttö̀ ttsök, ye' dör a' yë́. Ye' ttö̀ ttsö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“A Rubén, be' dör ye' alà kibi. Be' dör ye' diché tsá̱ e' alé. Be' dalöiërta̱' tai̱ë, be' diché ta̱' tai̱ë be' ëlpa tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Erë i̱'ñe ta̱ kë̀ idör es. Be' dör we̱s di' yöliie es kë̀ iwöklör yës. Be' tö ye' dalöse̱o̱'wa̱. Be' se̱ne'ka̱ ye' alaköl ta̱. E' kue̱ki̱ be' kë̀ dalöiërpaia̱ we̱s ko'k es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeón ena Leví, e'pa dör ñì ëlpa; ie'pa tabè tso' ñippoie ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","¡Wé̱ ie'pa e̱' dapa'u̱ke ee̱ ye' kë̀ shkak! Ie'pa tö wëpa kötulur kësik ë̀ kue̱ki̱. Baka wë'ñe klökicha blublu e' télorakitö ëanas. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ie'pa kësik dör suluë ichökle e' kue̱ki̱ ie'pa ka̱wö tköraë suluë. ¡Ye' tö ie'pa aleripa powe̱rami se̱nuk iëlpa male̱pa aleripa shu̱a̱ wì̱ a̱ dià a̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“A Judá, be' ëlpa tö be' ki̱keraka̱ tai̱ë. Be' bolökpa klö'we̱wa̱raë be' tö ikuli' a̱, es be' e̱' alöraka̱ ie'pa ki̱. Be' ëlpa e̱kka e̱' wöörawa i̱ski̱ be' dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","¡A Judá, be' dör ye' alà! Be' dör we̱s ma'name alà es. Mik ì ttéitö ta̱ ikaté o̱ne, eta̱ ie' e̱' wöéwa e̱' téwa̱ i̱ski̱ we̱s ma'name këchke es. ¿Yi dö̀mi ie' tsiriu̱k? ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Judá aleripa döraë blu'paie tai̱ë ke̱kraë dö̀ mik iblú chö́k de eta̱. Blu' e' ttö̀ iu̱teraë sulitane tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ie' tö iburro pupula mue̱ke uva shu̱a̱. Ñies idatsi' skuöke uva diö̀ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ie' wöbla dör daloloë uva diö̀ tsa̱ta̱. Ie' kà dör saruruë baka tsu'diö tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zabulón se̱rdaë dayë kkömik. Ee̱ tai̱ë kanò irirke ese ké̱ tso'. E' ká̱ kkö̀ dörawa̱ Sidón kkömik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isacar dör we̱s iyiwak tso' dalì oie diché ta̱' tai̱ë ese e̱' mùtër e̱nuk iwé a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Mik ie' isué̱ tö ká̱ e' dör buaë se̱noie ñies e̱noie, eta̱ ie' tsi̱wö ki̱ dalì deka̱ne kaneblök. Ie' e̱' mèttsa̱ kaneblök kanè mésoie, kë̀ tkine e' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan ditséwö shu̱a̱ s'shu̱lirdaë buaë yësyësë we̱s Israel aleripa e' ditséwö male̱pa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan döraë we̱s tkabë̀ chö́k tso' ñala̱ kkö̀ a̱ tö kabaio kuè iklö a̱ ta̱ iwák bruta̱ne itsi̱wökka ese es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“¡A Jehová, ye' tso' be' panuk tö ye' tsa̱tkö́! ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gad ppök ñippökwakpa döraë tai̱ë. Erë ie' tö ie'pa pperaë, itötie̱raë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aser ká̱ ki̱ chkè kata' buaë tskirdaë. Ì wörke ko̱s e' dör buaë shu̱te̱ mène buaë blu'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Neftalí dör we̱s su̱li̱ alaki dur áie ala'rla ta̱' bua'buaala ese es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“José dör we̱s burro kañiru suè̱ dur di' tum kkömik es, we̱s burro pupula kañiru suè̱ dur ká̱ tukir ki̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kuaböt namépa é̱na sulu ia̱r, ie' ki̱ kuaböt u̱yérakitö kësik wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Erë ie' ulà diché darërë; e' wa ie' wa̱ ishkame' shu̱irikar darërëë, kë̀ ulà shtrirta̱'wa̱ yës. Skëköl tö ie' a̱ diché e' mé. Skëköl e' dör Jacob Këköl e' diché ta̱' tai̱ë. Skëköl e' dör Israel aleripa kkö'nukwak. Ie' tö Israel aleripa tsa̱tkeke. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","A José, be' yë́ e' Këköl tö be' ki̱meke ke̱kraë. E' dör Skëköl Diché Ta̱' Íyi Ulitane Tsa̱ta̱, Ie' e̱r buaë chöraë be' a̱. Ka̱li̱ buaë patkeraë ie' tö be' daliwö ki̱. Ñies be' a̱ di' a̱tdaë buaë íyök ki̱ a̱s be' dalikua talar buaë. Be' aleripa alakölpa ala'r döraë tai̱ë, ñies be' iyiwak döraë tai̱ë. Es Skëköl e̱r buaë chöraë be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Be' yë́ e̱r buaë yë' be' a̱, e' tkö̀ka̱ ye' yë́ e̱r buaë yë' ye' a̱ e' tsa̱ta̱. Skëköl tö José shu̱kit iëlpa shu̱a̱ iwökirie, e' a̱ ie' e̱r buaë chö̀ michoë we̱s ka̱bata yöbië kë̀ e̱rta̱'wa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamín dör we̱s chichi kañiru kësikie ese es; bla'mi ta̱ iyiwak ttéwa̱itö katè, tsá̱li̱ ta̱ ibata watiéwa̱itö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","E'pa dör Israel ditséwöpa daia̱ itöki̱ döka̱ dabom eyök ki̱ böt (12), e' yë́pa tsá̱. Es ie'pa yë́ tö ie'pa a̱ iché mik ie' tö ittè bata ché ie'pa a̱ eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Jacob tö iché ila'r wëpa a̱: “Ye' blërkewa̱ e' ké̱wö dökewa̱tke. Mik ye' blënewa̱, eta̱ ye' nu blö́wa̱ ákuk a̱ ká̱ wé̱ ye' yamipa nu blëne ee̱. Pö e' a̱te̱ wëm kiè Efrón dör hititawak e' ká̱ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ká̱ e' a̱te̱ Macpelá Mamré wösha̱ë. Ká̱ e' a̱te̱ Canaán. Ká̱ e' ena ákuk e' wato̱'ttsa̱ Efrón tö Abraham a̱ a̱s Abraham tö iyamipa nu blö̀ ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ee̱ Abraham ena ilaköl Sara, ñies Isaac ena ilaköl Rebeca, e'pa nu blëne. Ee̱ ye' tö ye' alaköl Lía, e' nu blë'wa̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ká̱ e' ena ákuk e' wato̱' hititawak tö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Mik Jacob tö ttè e' ko̱s ché o̱ne eta̱ ie' e̱' té̱wa̱ne ika̱' ki̱ ta̱ iblënewa̱ mía̱ idëu̱töpa itöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Eta̱ José tö iyë́ nu paklö'wé̱wa̱ wöalattséitö ta̱ ii̱é̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","E' ukuöki̱ ta̱ ie' tö egiptowak dör s'nu kanéu̱kwakpa e'pa kié iyë́ nu kapeyökwa̱ a̱s kë̀ inurwa̱. Eta̱ es ikanewé̱rakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ikanewé̱rakitö döka̱ ká̱ dabom tkëyök (40 días), ekkë ka̱wö kiane ikanewo̱ie e' kue̱ki̱. Egiptowak tö ischö́ e̱riaitsé ka̱wö döka̱ dabom kuryök (70 días). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","E' ukuöki̱ ta̱ José tté Egipto blú kue̱blupa ta̱, ta̱ ichéitö ie'pa a̱: —A' é̱na e̱r bua' chak ye' a̱, e' ta̱ a' yú ichök Egipto blú a̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","tö mik ye' yë́ duökewa̱tke, eta̱ ie' tö ye' ka' ie' a̱ ttè muk Skëköl wörki̱ tö inú blerawa̱yö ákuk kaneo̱'a̱t ie' wák tö a̱te̱ Canaán e' a̱. E' kue̱ki̱ ka̱wö mú ña ie' nu tso̱mi blèwa̱ ee̱. Mik ye' ibléwa̱ ta̱ ye' dotkene. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Eta̱ Egipto blú tö iiu̱té: —Be' yú be' yë́ nu blökwa̱ we̱s ie' tö be' a̱ iki' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Eta̱ José mía̱ iyë́ nu blökwa̱. Egiptowak kue̱blupa ko̱s e'pa míyal ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Jacob yamipa e̱kka ena José yamipa e̱kka ena iëlpa e'pa ko̱s mí ñies. Ie'pa ala'r ena ie'pa iyiwak e'pa ë̀ a̱té̱a̱t Gosen. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ñies pë' mí tai̱ë karreta ki̱ ena kabaio ki̱. Es pë' mí tai̱ë José ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Mik ie'pa demi ká̱ kiè Goren-ha-atad a̱te̱ tsi̱net di' Jordán diwö tskirke e' kke̱r ee̱, eta̱ ee̱ ie'pa ulitane tö Jacob nu wötërkewa̱ e' ké̱wö tkö'wé̱ dalö̀ tai̱ë wa. Ee̱ José tö iyë́ e̱riaitsé döka̱ ká̱ kul. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Mik canaánwak se̱rke ee̱, e'pa tö Jacob nu wötërkewa̱ ké̱wö tkö'wè̱ e' sué̱, eta̱ ie'pa tö iché: “Moki̱ egiptowak tö s'nu wötërkewa̱ e' ké̱wö tkö'we̱ke dalö̀ tai̱ë wa.” E' kue̱ki̱ ká̱ e' kiè méka̱ ie'pa tö Abel-Misraim. Ká̱ e' a̱te̱ tsi̱net di' kiè Jordán e' kkömik. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Es Jacob ala'r tö iyë́ nu kanewé̱ we̱s ie' tö iyë' ie'pa a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ie'pa wa̱ inú mítse̱r Canaán ibléwa̱rakitö ákuk yöule Abraham wa̱ iyamipa pöie e' a̱. E' a̱te̱ Macpelá. E' wato̱'ttsa̱ hititawak kiè Efrón tö Abraham a̱. Ká̱ e' a̱te̱ Mamré wösha̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Mik José dëu̱tö nu blëne o̱ne, eta̱ ie' bite̱a̱ne Egipto. Ie' ëlpa ena pë' ulitane mìne ie' ta̱ e'pa ko̱s bite̱yalne ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Jacob blënewa̱ e' ukuöki̱ ta̱ José ëlpa tö ibikeitsé: “Isalema José é̱na sulu se' a̱rke. Ì ko̱s wamblë' se' tö ie' ki̱ e' skéie se' we'ikeraëitö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","E' kue̱ki̱ ie'pa ttè mémi ie' a̱: “Ka̱m be' yë́ blërwa̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","eta̱ ie' tö sa' a̱ iché tö ichö́ be' a̱: ‘Ì ko̱s suluë wamblë' sa' tö be' ki̱, e' olo'yö́ sa' ki̱.’ E' kue̱ki̱ sa' kköchö̀ be' a̱ tö e' olo'yö́ sa' ki̱. Sa' tö be' yë́ e' Këköl dalöieke e' kue̱ki̱.” Mik biyö̀ e' demi José a̱, eta̱ ie' i̱é̱ sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Eta̱ iëlpa demi iwöki̱. Ie'pa wöéwa dö̀ i̱ski̱ idalöioie ta̱ ichérakitö: —I' sa' de be' wörki̱. Sa' dör be' kanè mésopa. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Eta̱ ie' tö ie'pa iu̱té: —Kë̀ a' suanuk. Ye' kë̀ a̱ a' shu̱linuk Skëköl skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","A' íyi sulu bikeits wamblè ye' ki̱, erë e' mane'wé̱ttsa̱ne Skëköl tö buaë se' ki̱. E' wa tai̱ë pë' tsa̱tkëne i̱'ñe ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","E' kue̱ki̱ kë̀ a' suanuk. Chkewö meraëyö a' a̱ ena a' ala'r ko̱s a̱. Es ie' tö ie'pa a̱ iché e̱r buaë wa. E' tö ie'pa ttsë'wé̱ne buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","José ena iyë́ alikpö yamipa e'pa se̱ne'ia̱ Egipto. Ie' se̱ne' döka̱ duas cien eyök ki̱ dabom eyök (110). ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ie' tö ilà Efraín talapa e' ala'r sué̱ia̱. Ñies ie' tö ilà Manasés e' alà kiè Maquir e' ala'r sué̱ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ká̱ et ta̱ ie' tö iché iëlpa a̱: “Ye' duökewa̱ e' ké̱wö kianeia̱ tsir. Erë Skëköl wák tö a' ki̱meraë. Ie' tö a' yelurdaë ká̱ i' ki̱. Ká̱ yë'bakitö mè Abraham a̱ ena Isaac a̱ ena Jacob a̱ e' a̱ a' tse̱miraëitö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Eta̱ ie' tö iëlpa kié a̱s ie'pa ttè mù ie' a̱ Skëköl wörki̱. Ie' tö ie'pa a̱ iché: “Skëköl tö a' yerattsa̱ ká̱ i' ki̱. Mik e' tka, eta̱ ye' sik tso' blëule e' tsú̱mi e̱' ta̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Mik ie' blënewa̱ Egipto, eta̱ ie' ki̱ duas de cien eyök ki̱ dabom eyök (110). Ie' nu kapeyanewa̱ a̱s kë̀ inurwa̱ e' iënewa̱ s'nu kélkuö a̱.");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","4","Israel kiè ñies Jacob e' ala'r dë'mi Egipto ie' ta̱, e'pa ko̱s yamipa ta̱'. Ie'pa kiè Rubén, Simeón, Leví, Judá, Isacar, Zabulón, Benjamín, Dan, Neftalí, Gad ena Aser. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jacob yamipa mìne ie' ta̱ Egipto e'pa döka̱ dabom kuryök (70) se̱raa̱. Erë José, e' tso'tke Egipto ke̱we iyamipa yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ka̱wö tka tai̱ë, eta̱ José ena iëlpa blërulune. Ñies iyamipa dë'mi Egipto ie'pa ta̱, e'pa ko̱s blërulune se̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Erë Israel aleripa alöne tai̱ë, e' kue̱ki̱ ie'pa de diché ta̱' tai̱ë. Ie'pa tso' Egipto wa'ñe. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","E' ukuöki̱ ta̱ blu' ské tkëneka̱ eköl e' kë̀ wa̱ José pakè jche̱r. Ie' tö iché egiptowak a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","“Ye' ttö̀ ttsö́. Israel aleripa dör tai̱ë. Ie'pa diché tkö̀ka̱ se' diché tsa̱ta̱, dö' ie'pa e̱' alö̀ka̱ se' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Mik se' bolökpa ñippö̀mi se' ta̱, e' ta̱ dö' ie'pa ñì wöiöka̱ se' ppök se' bolökpa ta̱, ta̱ es imi'miyal se' yöki̱. E' kue̱ki̱ se' tö ibikeitsö́ bua'iewa̱ tö we̱s se' tö ie'pa wöklö'wè̱mi a̱s kë̀ ikí̱ alör tai̱ë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","E' kue̱ki̱ egiptowak tö iwökirpa patké Israel aleripa we'ikök kanè darërë wa a̱s ie̱riardak. Ie'pa tö ikérak ká̱ yuök böt chkewö dapa'wo̱ie Egipto blú a̱. Ká̱ e' kiè Pitón ena Ramsés. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Israel aleripa we'ikeke ie'pa tö sia̱rë, erë ikí̱ alörkerak tai̱ë. E' kue̱ki̱ egiptowak suarke tai̱ë ie'pa yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Egiptowak tö ie'pa ké kaneblök kësik wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","E' tö ie'pa e̱riawé̱ tai̱ë. Ikérakitö ska̱u̱chka yuök shtrót shtrót u yuoie. Ñies ikérakitö kaneblök kañika̱ kanè ulitane u̱k. Es Israel aleripa ko̱s we'ikérakitö sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","E' kí̱ie ta̱ Egipto blú tté alakölpa kiè Sifrá ena Puvá e'pa ta̱. Ie'pa dör hebreowak alakölpa alà ku̱rke e' kanéu̱kwakpa. Ie' tö iché ie'pa a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","—Mik a' tö hebreowak alakölpa alà ku̱rke, e' kanewe̱ke, eta̱ isa̱ú̱ ¿ì iwák dör? Iwák wëm e' ta̱ ittö́wa̱. Iwák dör alaköl, e' ta̱ imúa̱t, kë̀ ittarwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Erë alakölpa e'pa tö Skëköl dalöieta̱'. E' kue̱ki̱ ie'pa kë̀ wa̱ Egipto blú ttö̀ iu̱tëne we̱s itö iché es. Ie'pa ala'r wëpa méa̱t ttsë'ka. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Eta̱ Egipto blú tö ie'pa kiére ta̱ ichéitö ia̱rak: —¿Iö́k a' tö iwamblé es? ¿Iö́k a' tö ala'rla wëpa e' méa̱t ttsë'ka? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ie'pa tö iiu̱té: —Hebreowak alakölpa kë̀ alà ku̱r we̱s egiptowak alakölpa es. Ie'pa alakölpa dör darërë. Ie'pa alà ku̱r bet buaë. Mik sa' demi, eta̱ ie'pa alà ku̱netke. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Es Israel aleripa kí̱ alönèmi tai̱ë. Ie'pa diché kí̱ iërke tai̱ë. Sifrá ena Puvá e'pa tö Skëköl dalöieta̱'. E' kue̱ki̱ Skëköl tö ie'pa ki̱mé, ala'r méitö ie'pa a̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Eta̱ Egipto blú tö ikue̱blupa ulitane a̱ ka̱wö mé tö hebreowak ala'rla wëpa ku̱ne ko̱s e' ö́mi di' ki̱. Alakölpala ë̀ múa̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","E' ké̱wö ska' ta̱ wëm eköl dör Leví aleri, e' se̱néwa̱ alaköl dör Leví aleri ñies ese ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Eta̱ ie' alà skà kéka̱ e' dör wëm. Eta̱ imì tö isué̱ tö alala buaala, e' kue̱ki̱ ibléwa̱itö dö̀ si' mañat. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mik imì kë̀ a̱ ilà blëneia̱, eta̱ ie' kkö́ yulé et, patié̱ buaë kiöchka tso' chkua̱'chkua̱ ese wa a̱s kë̀ a̱ di' tkö̀wa̱. E' ukuöki̱ ta̱ alala iéwa̱itö kkö́ a̱, méreitö di' kiè Nilo e' kkömik ka̱kö tso' e' shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Eta̱ alala kutà e̱' duése̱r ka̱mië ikí̱ sa̱u̱k tö we̱s idömi. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","E' ukuöki̱ ta̱ Egipto blú e' alà busi mía̱ kuök di' a̱. E' dalewa tayëpa tso' ie' wa̱ ikanè mésopaie e'pa shkö̀ iëte̱r ákitö ki̱. Eta̱ ie' tö kkö́ sué̱ ka̱kö shu̱a̱. Ikanè mésopa eköl patkémiitö itsu̱kbitu̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Eta̱ ie' tö ikkökéka̱ ta̱ isué̱ tö alala wëm a'ria̱ eköl e' i̱u̱ke. Ie' isué̱ e̱r sia̱rë wa ta̱ ichéitö: —Bëbëla i' dör hebreowak. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","E' wösha̱ bëbëla kutà de ta̱ ichéitö ia̱: —¿Be' ki̱ ikiane tö ye' mi' tayë hebreowak yulök eköl be' a̱ alala se̱ kkö'noie a̱s itala'ù̱itö itsu' wa? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Eta̱ Egipto blú alà busi tö iiu̱té: —Be' yú iyulök. Eta̱ bëbëla kutà mía̱ imì yulök ta̱ idebitu̱ iwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Eta̱ Egipto blú alà busi tö iché alà mì a̱: —Alà i' tsú̱mi kkö'nú ña tala'ú̱ ña buaë. Ye' tö be' patue̱ke iki̱. Eta̱ imì wa̱ ilà mítse̱r tala'wè̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mik alà de bërie, eta̱ imì wa̱ ibite̱tse̱rne Egipto blú alà busi a̱. Eta̱ ie' tö iklö'wé̱ we̱s ie' alà e̱kka es. Ikiè méka̱itö Moisés. Ie' tö iché: —Ye' tö iyë'ttsa̱ di' a̱. E' kue̱ki̱ ie' tö ikiè méka̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Moisés kibineo̱ne. Ká̱ et ta̱ ie' mía̱ iyamipa hebreowak, e'pa pakök. Eta̱ ie' tö isué̱ tö iyamipa weirke sia̱rë kaneblök darërë. Eta̱ ie' isué̱ tö egiptowak eköl tso' iyami hebreowak eköl e' ppök sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Eta̱ ie' ká̱ sué̱ ká̱ wa'ñe. Kë̀ ie' wa̱ yi su̱ne. E' dalewa ie' tö egiptowak e' ttéwa̱ inú wötéwa̱ ie' tö ttsa̱'wö a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Bule es ta̱ ie' skà e̱' yéttsa̱, eta̱ ie' isué̱ tö hebreowak böl tso' ñippök ñita̱. Ie' tö iëköl tso' eköl ppök, e' a̱ iché: —¿Iö́k be' tso' be' yami ppök? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Eta̱ hebreowak e' tö iiu̱té: —¿Yi tö be' tkéka̱ sa' wökirie sa' shu̱lökwakie? ¿Be' tso' ye' bikeitsök ttèwa̱ we̱s egiptowak kötwa̱bö es? Mik ttè e' ttsé Moisés tö, eta̱ e' tö ie' suawé̱. Ie' ibikeitsé: “Ie'pa wa̱ ijche̱newa̱ tö ye' tö egiptowak kötwa̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Mik e' jche̱newa̱ Egipto blú wa̱, eta̱ ie' tö Moisés ttökwa̱ patké. Erë Moisés tkashkar ie' yöki̱, mía̱ se̱nuk ká̱ kiè Madián ee̱. Ee̱ ie' e̱' tkére di' tum biule kkömik. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ká̱ e' a̱ sacerdote se̱rke eköl kiè Reuel. E' alà busipa döka̱ kul. E' diwö wa alà busipa e'pa dë'bitu̱ di' chkök kulë' a̱ mè iyë́ iyiwak a̱ yè. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Eta̱ iyiwak kkö'nukwakpa skà wëpa debitu̱ busipa trë'wé̱mi. Eta̱ Moisés e̱' kéka̱ e' tö busipa tsa̱tkée. Eta̱ ie' tö di' mé iyiwak a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Mik ie'pa demine iyë́ ska', eta̱ iyë́ tö ie'pa a̱ ichaké: —¿Ì wa i̱'ñe a' dene bet? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ie'pa tö iiu̱té: —Egiptowak eköl tö sa' tsa̱tkée iyiwak kkö'nukwakpa ulà a̱. Ie' di' yéttsa̱ mé iyiwak a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Iyë́ tö iché ia̱: —¿Wé̱ wëm e'? ¿Iö́k a' iméa̱t ekörla? A' yú itsu̱kbitu̱ a̱s ichkö̀ se' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Es Moisés e̱' tsé̱a̱t se̱nuk wëm e' ska'. E' ukuöki̱ ta̱ Reuel tö ilà busi kiè Séfora, e' mé Moisés a̱ se̱nowa̱ie ita̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Eta̱ Moisés alà kéka̱ eköl kiè méka̱itö Guersón wà chéitö: Ká̱ i' ki̱ ye' dör o̱'ka. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Duas tka tai̱ë, eta̱ Egipto blú blënewa̱. Erë Israel aleripa kköchökeia̱ tai̱ë ke̱kraë kanè darërëë kue̱ki̱. Ie'pa kköchöke tai̱ë e' ttsé Skëköl tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ttè me'bak ie' tö Abraham a̱ ena Isaac a̱ ena Jacob a̱ e' wà tsá̱ detke kanewè̱. E' kue̱ki̱ ie' tö ibikeitsé tö Israel aleripa ki̱meraëyö i' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ie' tö ie'pa sué̱ ta̱ ie' é̱na ia̱ne tö ì tköke ie'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ká̱ et ta̱ Moisés tso' inua̱ki Jetró, e' iyiwak kkö'nuk. Inua̱ki kaneblöke sacerdoteie Madián. E' dalewa ie' wa̱ inua̱ki iyiwak mítse̱r ká̱ sir po, e' jaishe̱t, demi Skëköl ké̱bata kiè Horeb ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Eta̱ ee̱ Jehová biyöchökwak bua'ie e' e̱' kkachéwa̱ ie' a̱ bö' wörkueie tai̱ë kal tsir elka shu̱a̱. Moisés tö isué̱wa̱ bua'ie ta̱ isué̱ tö kal wöbatseka̱ tai̱ë bö'ie, erë kë̀ iñarwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Eta̱ Moisés tö ibikeitsé: “¿Wì̱ dör ì? Ye' mí isa̱u̱k ì kue̱ki̱ kal wì̱ kë̀ ñarwa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mik Jehová tö isué̱ tö Moisés dökewa̱tke tsi̱net bö' ñarke e' o̱'mik isa̱u̱k, eta̱ Skëköl tö ichaké: —¡A Moisés! ¡A Moisés! Moisés tö iiu̱té: —¿Ì? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Eta̱ Skëköl tö iché ia̱: —Kë̀ be' dökwa̱ tsi̱net. Wé̱ be' dur e' ké̱ dör batse'r, e' kue̱ki̱ be' klökkuö yö́ttsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ye' dör be' yë́ e' Këköl ena be' yë́pa bak ká̱ ia̱ia̱ë kiè Abraham, Isaac ena Jacob e'pa Këköl. Moisés suane Skëköl sa̱u̱kwa̱, e' kue̱ki̱ ie' e̱' wöpabakéwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Erë Jehová tö iché ia̱: —Ye' isué̱ tö wé̱pa dör ye' icha tso' Egipto e'pa weirke sia̱rë. Ie'pa kköchöke tai̱ë ikanè wökirpa ulà a̱ e' ttséyö. Ye' wa̱ ijche̱r buaë tö iweirkerak sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","E' kue̱ki̱ ye' dë'ttsa̱ ie'pa tsa̱tkök egiptowak ulà a̱. Ye' tö ie'pa yerattsa̱ ká̱ e' ki̱. Ye' wa̱ ie'pa miraë ká̱ tai̱ë buaë ese ki̱. Ká̱ e' ki̱ íyi ulitane tskir buaë, iwà wör buaë shu̱te̱. Ká̱ e' ki̱ pë' tso' tai̱ë. E'pa ditséwöpa dör canaánwak, hititawak, amorreowak, fereseowak, heveowak, ena jebuseowak. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ittsö́, ye' tö Israel aleripa kköchöke e' ttsé. Ye' tö isué̱ tö egiptowak tö ie'pa we'ikeke sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","E' kue̱ki̱ ye' tso' be' patkök Egipto blú ska' Israel aleripa dör ye' icha e'pa yökulur Egipto a̱. Be' yú Egipto. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Erë Moisés tö iché ie' a̱: —¿Yi ye' dör e' döwa̱mi Egipto blú wörki̱ Israel aleripa yökulur ie' ulà a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ie' tö iiu̱té: —Be' kë̀ mi'pa ekörla. Ye' tso' be' ta̱ be' ki̱muk. Mik be' tö Israel aleripa yélur Egipto a̱, eta̱ a' tö ye' dalöieraë ka̱bata i' ki̱. E' wa be' wa̱ ijche̱rdaë tö ye' wák tö be' patkë'. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Erë Moisés tö ie' iu̱té: —Dö' ye' mía̱ ta̱ ye' tö ichè ie'pa a̱: “A' yë́pa bak ia̱ia̱ë e' Këköl tö ye' patkë' a' tsa̱tkök.” Dö' ie'pa tö ye' a̱ ichakè: “¿I̱ma e' kiè?”, e' ta̱ ¿ì chèmi ye' tö ie'pa a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Eta̱ ie' tö iiu̱té: —Ye' dör yi tso'tke e'. Ichö́ ie'pa a̱ tö Ye' Tso'tke e' tö ye' patké a' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Skëköl tö ikí̱ ché Moisés a̱: —Ñies ttè i' chö́ Israel aleripa a̱: ‘Se' yë́pa bak ká̱ ia̱ia̱ë kiè Abraham, Isaac ena Jacob, e'pa Këköl kiè Jehová e' tö ye' patké a' tsa̱tkök.’ Ttè e' chö́ ie'pa a̱. Ye' kiè dör Jehová i' dör ye' wák kiè ke̱kraë. Kiè i' wa ye' kirdaë aishkuö ta̱ ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Be' yú Israel aleripa kue̱blupa dapa'u̱k ta̱ ttè i' ichö́ ie'pa a̱: ‘Jehová, dör se' yë́pa bak ká̱ ia̱ia̱ë kiè Abraham, Isaac ena Jacob e'pa Këköl e' e̱' kkayë' ye' a̱ ta̱ ye' a̱ iyë'itö tö ie' tö a' weirke sia̱rë egiptowak ulà a̱ e' sué̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ñies ye' a̱ iyë'itö tö a' tsa̱tkeraëitö egiptowak tso' a' we'ikök e'pa ulà a̱. Ie' wa̱ a' miraë ká̱ buaë ese ki̱. Ká̱ e' ki̱ íyi ulitane tskir buaë, iwà wör buaë shu̱te̱. Ká̱ e' wakpa ditséwöpa dör canaánwak, hititawak, amorreowak, fereseowak, heveowak, ena jebuseowak.’ Ttè e' chö́ ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Israel aleripa kue̱blupa tö be' ttö̀ ttseraë ta̱ be' yú ie'pa ta̱ Egipto blú ska' ta̱ ttè i' chö́ ie' a̱: ‘Jehová dör hebreowak Këköl, e' dë'bitu̱ sa' wöki̱. E' kue̱ki̱ sa' ö́mi ká̱ mañat shkar ekkë wé̱ kë̀ yi ku̱' ese ska' iyiwak ña'u̱k Jehová dör sa' Këköl e' dalöioie.’ Ttè e' chö́ ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Erë ye' wa̱ ijche̱r buaë tö ie' kë̀ tö ie'pa a̱ ka̱wö e' mepa ëanas. Ye' ka̱wöta̱ ie'pa yöktsa̱ ye' diché tai̱ë e' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","E' kue̱ki̱ ye' diché tai̱ë e' kkacheraëyö egiptowak a̱. Ì we̱raëyö ie'pa shu̱a̱ e' tö ie'pa tkiwe̱raë. E' wa ie'pa we'ikeraëyö sia̱rë. E' ukuöki̱ ta̱ Egipto blú tö Israel aleripa erami a̱s imi'yal. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ñies ye' tö egiptowak keraë ie'pa dalöiök tai̱ë. E' kue̱ki̱ mik a' e̱' yökettsa̱ Egipto a̱, eta̱ a' kë̀ minuk ulà wöchka. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Israel aleripa e' alakölpa ko̱s e'pa tö íyi yöule inukölchka wa ö orochka wa ö datsi' ese kak kieraë egiptowak alakölpa se̱rke bánet ö ise̱rkerak Israel aleripa u a̱ esepa a̱, e' ko̱s ieraë a' ala'r tö. Es a' tö íyi bua'bua tso' tai̱ë Egipto e' yerattsa̱ ie'pa ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Erë Moisés tö iiu̱té: —Ie'pa kë̀ tö ye' ttö̀ klö'we̱pa. Kë̀ itö ye' ttö̀ iu̱tepa. Ie'pa tö ye' a̱ icheraë: “Jehová kë̀ dë'bitu̱ be' ska'.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Eta̱ Skëköl Jehová tö ie' a̱ ichaké: —¿Ì a'tse̱r be' wa̱ ulà a̱? Moisés tö iiu̱té: —Ye' shko kéli. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Jehová tö iché ia̱: —¡Iu̱yö́mi i̱ski̱! Eta̱ Moisés tö iu̱yémi i̱ski̱. E' wösha̱ ta̱ ishko kéli yönane tkabë̀ie. Moisés e̱' skéu̱ iyöki̱ bet ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","erë Jehová tö iché ia̱: —¡Iklö'ú̱wa̱ ikirë bata a̱ ulà wa! Eta̱ Moisés tö iklö'wé̱wa̱ eta̱ imía̱ne shko kéliie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Eta̱ Jehová tö iché ia̱: —Mik be' dene Egipto, eta̱ be' tö iú̱ es a̱s ie'pa tö iklö'ù̱ moki̱ tö ye' dör a' yë́pa bak ká̱ ia̱ia̱ë kiè Abraham, Isaac ena Jacob e'pa Këköl e' e̱' kkaché be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","I' ta̱ be' ulà tiú̱wa̱ be' batsi̱' a̱. Eta̱ Moisés ulà tié̱wa̱ ibatsi̱' a̱. Mik ie' ulà yéttsa̱, eta̱ ie' isué̱ tö iwölineka̱ saruruë duè kiè lepra e' wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Eta̱ Skëköl tö iché ia̱: —Be' ulà skà tiú̱wa̱ne be' batsi̱' a̱. Eta̱ Moisés tö iwé̱ es. Mik ie' ulà yéttsa̱ne, eta̱ ie' ulà buanene buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","E' ukuöki̱ ta̱ Skëköl tö iché ia̱: —Ì kkachéyö be' a̱ ke̱we e' kë̀ klönerak iwa̱, ñies ie'pa kë̀ wa̱ be' ttö̀ iu̱tëne, e' ta̱ iët skà ú̱. Isalema e' klö'wè̱mi ie'pa tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Erë e' ko̱s wa ie'pa kë̀ wa̱ be' ttö̀ klöne be' ttö̀ iu̱tëne e' ta̱ di' chkö́ka̱ di' kibi a̱ e' tö́ttsa̱ ká̱ sí ki̱. Mik e' tënettsa̱ ká̱ sí ki̱ eta̱ di' mia̱raë pë́ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moisés tö iiu̱té: —¡Ayëwë! ¡A ye' Këköl! Ye' sia̱rala, kë̀ tto buaë. E' kë̀ dör i̱'ñe ë̀me be' ttöke ye' ta̱ eta̱. Es ye' wák dër ká̱ ia̱ia̱ë. Ye' ttö̀ e̱naë. Ye' kë̀ a̱ s'iu̱tër buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Erë Jehová tö iiu̱té: —¿Yi tö a' a̱ kkö̀ méa̱t? Ye' wák tö a' méa̱t kë̀ tto ö kë̀ kukuö̀ wattsër. Ñies a' wöbla kë̀ wawër ö a' wöbla wawër e' ko̱s méa̱t ye' wák tö a' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","E' kue̱ki̱ be' yú. Mik be' ttöke, eta̱ ye' tso' be' ta̱. Ì kiane ye' ki̱ tö be' tö ichè, e' kkacheraë ye' tö be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Erë Moisés tö iché ia̱: —¡A këkëpa! Ye' kköchö̀ be' a̱ tö o̱'ka patkö́mi ye' skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Eta̱ Jehová uluneka̱ ie' ki̱ ta̱ ichéitö ia̱: —E̱'ma be' ël Aarón dör Leví aleri ¿i̱ma e' bikeitsè be' tö? Ye' wa̱ ijche̱r tö ie' ttö̀ buaë. Ie' tso'tke ñala̱ ki̱ datse̱ be' ska'. Mik ie' tö be' sué̱, eta̱ e' tö ie' ttsë'wè̱mi buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ì ko̱s chak be' é̱na e' ko̱s chö́ Aarón a̱ a̱s ie' tö ichö̀ne. Ye' wák tö a' böl ki̱meraë a̱s a' ttö̀ buaë. Ì kiane ye' ki̱ tö a' tö iwè̱ e' kkacheraë ye' tö a' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aarón ttöraë be' skéie. Ie' döraë be' ttekölie we̱s be' dör ye' tteköl es. Ì cheke ye' tö be' a̱ e' cherane be' tö ie' a̱ ta̱ e' cherane ie' tö a' yamipa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Shko kéli se̱ tsú̱mi. E' wa ì kë̀ o̱r yi a̱ ese we̱raëbö. Ie'pa wökrardawa̱ iweblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","E' ukuöki̱ ta̱ Moisés mía̱ne inua̱ki, Jetró ska' ta̱ ichéitö ia̱: —Ka̱wö mú ña. Ye' ka̱wöta̱ shkökmine Egipto ye' yamipa sa̱u̱k tö itso'ia̱rak ttsë'ka. Eta̱ Jetró tö iiu̱té: —Ëkëkë. Be' shkö́ wöbla wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Moisés tso'ia̱ Madián, eta̱ Jehová tö iché ia̱: —Yi ki̱ be' kiarke ttèwa̱ Egipto, e'pa blërulune. Kë̀ ì dalö̀ ta̱'ia̱ be' ki̱ ee̱. E' kue̱ki̱ be' yúne Egipto. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Eta̱ Moisés tö ilaköl ena ila'r tkéka̱ burro ki̱ ta̱ imíyal Egipto. Ie' wa̱ Skëköl shko kéli dami ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Jehová tö ie' a̱ iché: —Mik be' demi Egipto, eta̱ ye' tö diché me'bak be' a̱ ì kë̀ o̱r yi a̱ ese wo̱ie, e' wakaneú̱ kröröë Egipto blú wörki̱. Erë ye' tö ie' a̱ e̱r suluë meraë a̱s kë̀ ie' tö Israel aleripa ö̀mine. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Eta̱ ttè i' chö́ ie' a̱: ‘Jehová tö iché be' a̱: Israel aleripa dör we̱s ye' alà wëm tsá̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ye' tö be' a̱ ichétke tö ie'pa ö́mine a̱s imi'yalne ye' ki̱kökka̱. Erë be' kë̀ wa̱ ie'pa a̱ ka̱wö mène a̱s imi'yal. E' kue̱ki̱ be' alà wëm tsá̱ e' tterawa̱yö.’ Ttè e' chö́ ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Moisés ena iyamipa minia̱ ñala̱ ki̱ eta̱ wé̱ ie'pa kapökerö ñala̱ ki̱, ee̱ Jehová debitu̱ Moisés ska' ittökwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Erë Moisés alaköl Séfora e' tö ák di'dië klö'wé̱wa̱ e' wa ilà tottola kkuölit tée tsir. E' kkuölit takla pë́ wa ie' tö Moisés klö̀ patié̱ ta̱ ichéitö Moisés a̱: “Moki̱ be' tso'ia̱ ye' wëmie pë́ i' wa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Eta̱ Jehová tö Moisés émi. (Séfora tö ilà tottola kkuölit tée tsir e' kue̱ki̱ ie' tö iché Moisés a̱ tö “be' tso'ia̱ ye' wëmie pë́ i' wa.”) ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Eta̱ Jehová tö Aarón a̱ iché: “Be' yú Moisés ñalé̱ yulök wé̱ kë̀ yi se̱rku̱' ee̱.” Aarón mía̱ Moisés ñalé̱ yulök ta̱ ie' ikué̱ Skëköl ké̱bata a̱. Ee̱ ishke̱'wé̱itö wöalattsè wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Eta̱ ì ko̱s chök Jehová tö Moisés patkë', e' pakéne Moisés tö Aarón a̱. Ñies ì kë̀ o̱r yi a̱ ese kkayë' Jehová tö Moisés a̱ wawè̱ e' ko̱s pakéneitö Aarón a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","E' ukuöki̱ ta̱ ie'pa böl míyal Israel aleripa kue̱blupa dapa'u̱kka̱ ka̱pakök ie'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ì ko̱s yë' Jehová tö Moisés a̱ e' pakéne Aarón tö Israel aleripa kue̱blupa a̱. Ñies ì kë̀ o̱r yi a̱ ese kkayë' Jehová tö Moisés a̱ e' ko̱s wé̱ Moisés tö Israel aleripa ulitane wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Israel aleripa tö Aarón ttè klö'wé̱. Mik ie'pa é̱na ia̱ne tö Jehová é̱na ie'pa dalërke, ñies tö ie'pa weirke sia̱rë e' sué̱itö, eta̱ ie'pa e̱' wöéwa i̱ski̱ ie' dalöiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","E' ukuöki̱ ta̱ Moisés ena Aarón míyal Egipto blú ska' ta̱ ichéitö ia̱: —Jehová dör Israel aleripa e' Këköl, e' tö iché be' a̱ tö e'pa dör ie' icha. Ie'pa ö́mi a̱s imi'yal wé̱ kë̀ yi se̱rku̱' ee̱ ka̱wö tkö'u̱k ie' dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Erë Egipto blú tö iiu̱té: —¿Yi dör Jehová? Ye' kë̀ wa̱ ie' su̱ule. Ye' kë̀ ka̱wöta̱ ie' ttö̀ iu̱tök. Ye' kë̀ ka̱wöta̱ Israel aleripa ökmi. E' kue̱ki̱ kë̀ ye' tö Israel aleripa epami. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Eta̱ ie'pa tö iché: —Hebreowak Këköl e' dë'bitu̱ sa' wöki̱. E' kue̱ki̱ sa' ö́mi ká̱ mañat shkar ekkë wé̱ kë̀ yi ku̱' ese ska' iyiwak ña'u̱k sa' Këköl Jehová e' a̱ idalöioie dö' ie' tö sa' wömèttsa̱ duökwa̱ duè a̱ ö tabè a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Erë Egipto blú tö iiu̱té: —A Moisés. A Aarón. ¿Iö́k a' ki̱ ie'pa kiane wöklö'wè̱ ikanè a̱? ¡A' ena a' yamipa yúshka kaneblök! ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ñies Egipto blú tö iché ie'pa a̱: —I̱'ñe ta̱ Israel aleripa tso' tai̱ë ká̱ i' ki̱, eta̱ ¿we̱s a' ki̱ ikiane tö ie'pa kë̀ kaneblö̀ia̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","E' diwö wa Egipto blú tö iché ikanè wökirpa a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","—Tala'chka kösi e' kë̀ tsa̱rbitu̱ia̱ Israel aleripa a̱ ska̱u̱chka shtrót shtrót yuoie we̱s se' tö ikanewè̱rö es. A̱s ie'pa wákpa mi' itsu̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Erë ikö́rak iyuök ko̱s ke̱kraë iyuekerakitö ekkë, kë̀ wöarwa yës. Ie'pa bikënak ë̀ tai̱ë, e' kue̱ki̱ ie'pa a̱rkerak: ‘¡Mishka iyiwak ña'u̱k se' Këköl a̱!’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ie'pa kí̱ kö́ kaneblök darërëë. Kanè mú ie'pa a̱ tai̱ë a̱s kë̀ itö ka̱chè iu̱tö̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Eta̱ ikanè wökirpa míyal ta̱ ichéitörak Israel aleripa a̱: —Egipto blu' tö ka̱wö mé tö kë̀ a' a̱ tala'chka kösi tsa̱rbitu̱ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","I̱'ñe ta̱ a' wakpa ka̱wöta̱ iyulök wé̱ a' ikué̱, e̱'ma ee̱ itsú̱bitu̱. Erë a' ka̱wöta̱ iyuök ko̱s a' iyueke ke̱net ekkë, kë̀ wöarwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Eta̱ Israel aleripa mía̱ Egipto ká̱ wa'ñe ka̱chka ëse yulök tala'chka skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Kanè wökirpa tö ikérak kaneblök kësik wa ta̱ ichekerakitö ie'pa a̱ ke̱kraë: “A' tö iyuö́ ko̱s a' tö iyueke ke̱net mik sa' tö tala'chka mekeia̱ a' a̱ ekkë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Egiptowak tö Israel aleripa we̱lepa me'ka̱ ñì wökirie. E'pa ppeke egiptowak tö ttsa' bata wa ta̱ ichekerakitö ie'pa a̱: —¿Ì kue̱ki̱ a' kë̀ wa̱ iyöne chkì ena i̱'ñe we̱s ke̱net es? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Eta̱ Israel aleripa kanè wökirpa míyal kköchök Egipto blú wöa̱. Ie'pa tö iché ia̱: —A këkëpa. ¿Ì kue̱ki̱ be' tö be' kanè mésopa we'ikè es? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Tala'chka kë̀ mèneia̱ sa' a̱, erë ie'pa ki̱ ikiane tö sa' tö iyuè ko̱s sa' a̱ tala'chka merkeia̱ ta̱ iyörke ekkë. Ie'pa tö sa' ké kaneblök kësik wa. Ñies sa' ppekeitö sia̱rë. ¡A këkëpa, be' wakpa iane iwiie! ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Egipto blú tö ie'pa iu̱té: —¡A' dör bikëwakpa wöchka! E' kue̱ki̱ a' icheke ke̱kraë: “¡Mishka ká̱ bánet iyiwak ña'u̱k Jehová a̱!” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","¡A' yúshka kaneblök! Erë́ kë̀ tala'chka kösi merku̱'ia̱ a' a̱, erë a' ka̱wöta̱ iyuök ko̱s ke̱net a' tö iyueke ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Mik Israel aleripa kanè wökirpa a̱ iyëne tö ie'pa ka̱wöta̱ iyuök ke̱kraë ko̱s iyuekerakitö ke̱net ekkë, eta̱ ie'pa e̱riane tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ie'pa e̱' yélur Egipto blú ska' de wé̱ Moisés ena Aarón tso' ie'pa panuk ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ie'pa tö iché ia̱rak: —Ì wamblé a' tö sa' ki̱ e' kue̱ki̱ a̱s Jehová tö a' we'ikö̀. Egipto blú ena ikue̱blupa e'pa é̱na sa' a̱r suluë. A' iane iwiie. E' dör we̱s a' wakpa tö tabè mé ie'pa a̱ a̱s sa' ttö̀wa̱ ie'pa tö es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Eta̱ Moisés tö iché Jehová a̱: —A Jehová. ¿Iö́k be' tö Israel aleripa we'ikeke sia̱rë? ¿Iö́k be' tö ye' patkë'bitu̱ í̱e̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Mik ye' dë'bitu̱ ttök Egipto blú ta̱' be' ttö̀ wa, eta̱ ie' tö wé̱pa dör be' icha e'pa kí̱ we'iké sia̱rë. Dö̀ ikkë ta̱ iweirkeia̱ iwák su̱ë. Erë be' kë̀ wa̱ ì o̱ne yës ie'pa tsa̱tkoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Eta̱ Jehová tö ie' iu̱té: —Kukuie bö isue̱raë tö we̱s ye' tö Egipto blú we'ikeraë. Ye' diché tai̱ë e' wa ye' tö ie' keraë ie'pa ökmi. Ye' diché wa ye' tö ie' keraë ie'pa patkökmi iká̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ñies Skëköl tö iché Moisés a̱: —Ye' dör Jehová. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mika̱ ye' e̱' kkayë' Abraham a̱ ena Isaac a̱ ena Jacob a̱, eta̱ ye' iché tö ye' dör Skëköl Diché Ta̱' Íyi Ulitane Tsa̱ta̱ e'. Erë ye' kiè Jehová, e' kë̀ yëne ye' wa̱ ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ye' tö ttè me' ie'pa a̱. Ye' tö iyë'a̱t ie'pa a̱ tö ká̱ kiè Canaán e' merayö a' aleripa a̱. Ee̱ ie'pa bak se̱nuk we̱s o̱'ka ká̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","I̱'ñe ye' wa̱ ijche̱r tö ie'pa weirke sia̱rë. Egiptowak tö ie'pa keke kaneblök darërëë kësik wa. E' kue̱ki̱ ttè me'bak ye' tö ie'pa a̱ e' wawe̱keyö i̱'ñe ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","E' kue̱ki̱ be' yú ichök ie'pa a̱ tö ye' dör Jehová. Egiptowak tö a' we'ikeke sia̱rë kanè darërëë wa, e' ko̱s ulà a̱ a' yerattsa̱ ye' tö. Ye' tö egiptowak we'ikeraë sia̱rë ye' diché tai̱ë e' wa. Es a' tsa̱tkeraë ye' tö egiptowak ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ye' tö a' klö'we̱raë ye' ichapaie. Ye' döraë a' Këköl. A' wa̱ ijche̱rdaë tö ye' dör Jehová. Ye' dör a' Këköl. A' wa̱ ijche̱rdaë tö ye' tö a' yë'lur egiptowak bak a' we'ikök kanè darërëë wa e' ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ye' wa̱ a' miraë ká̱ muk ye' kablë' Abraham, Isaac ena Jacob e'pa a̱ ee̱. Ká̱ e' meraë ye' tö a' a̱. E' a̱tdaë a' a̱. Ye' dör Jehová e' tö iché es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Eta̱ Moisés tö ttè e' skà chéne Israel aleripa a̱. Erë ie'pa e̱riarke tai̱ë kanè darërë kue̱ki̱. E' kue̱ki̱ ie'pa kë̀ wa̱ ittö̀ iu̱tëne. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Eta̱ Jehová tö iché Moisés a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","—Be' yú ichök Egipto blú a̱ tö ka̱wö mú ye' ichapa a̱ e̱' yöktsa̱ Egipto a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Erë Moisés tö Jehová iu̱té: —Israel aleripa kë̀ tö ye' ttö̀ iu̱tè, eta̱ ¿we̱s Egipto blú ye' ttö̀ iu̱tèmi? Ye' kë̀ tto buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Eta̱ Jehová tö Moisés ena Aarón e'pa patkémi ichök Israel aleripa a̱ ena Egipto blú a̱ tö “Jehová tö sa' patké Israel aleripa yökulur Egipto.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","I' dör Moisés ena Aarón ditséwö datse̱ iyëpa wa: Rubén e' dör Jacob alà wëm tsá̱, e' ala'r dör Hanoc, Falú, Hesrón ena Carmí. Ditséwöpa datse̱ ie'pa wa e'pa ko̱s dör Rubén aleripa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeón ala'r wëpa dör Jemuel, Jamín, Óhad, Jaquín, Sóhar ena Saúl. Saúl mì dör cananeawak. Ditséwöpa datse̱ ie'pa wa e'pa ko̱s dör Simeón aleripa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Leví se̱ne' duas döka̱ cien eyök ki̱ dabom mañayök kí̱ kul (137). I'pa dör ila'r wëpa ikibi ë́k dö̀ ibata ë́k: Guersón, Quehat, ena Merarí. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Guersón ala'r wëpa dör Libní ena Simí. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Quehat se̱ne' duas cien eyök ki̱ dabom mañayök ki̱ mañat (133). Ie' ala'r wëpa dör Amram, Ishar, Hebrón ena Usiel. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merarí ala'r wëpa dör Mahli ena Musí. Ditséwöpa datse̱ ie'pa wa e'pa ko̱s dör Leví aleripa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram se̱ne'wa̱ iyëchke kiè Jocabed e' ta̱. E' dör Moisés ena Aarón mì. Amram se̱ne' duas cien eyök ki̱ dabom mañayök ki̱ kul (137). ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ishar ala'r wëpa dör Coré, Néfeg ena Zicrí. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uziel ala'r wëpa dör Misael, Elsafán ena Sitrí. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aarón se̱ne'wa̱ alaköl kiè Eliseba e' ta̱. E' dör Aminadab alà busi ena Nahasón kutà. E' ala'r wëpa kiè Nadab, Abihú, Eleasar ena Itamar. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Coré ala'r wëpa dör Asur, Elcaná ena Abiasaf. Ditséwöpa datse̱ ie'pa wa e'pa ko̱s dör Coré aleripa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasar dör Aarón alà, e' se̱ne'wa̱ Futiel alà busi ta̱. E' alà ku̱ne kiè Finees. E'pa ko̱s datse̱ iyë́ tsá̱ kiè Leví e' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aarón ena Moisés e'pa patkë' Jehová tö Israel aleripa yökulur Egipto a̱ dapauleka̱ we̱s ñippökwakpa tai̱ë e̱' dapa'ù̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Aarón ena Moisés e'pa ut Egipto blú ta̱ a̱s ie' tö ka̱wö mù ie'pa a̱ Israel aleripa yöktsa̱rak Egipto a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Mik Jehová tté Moisés tso' Egipto e' ta̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","eta̱ ichéitö ia̱: —Ye' dör Jehová. Ì ko̱s chekeyö be' a̱ e' skà chö́ne Egipto blú a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Erë Moisés iiu̱té: —A Jehová, ye' kë̀ tto buaë, eta̱ ¿we̱s Egipto blú ye' ttö̀ iu̱tèmi? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Eta̱ Jehová tö iché Moisés a̱: —Ye' ttö̀ ttsö́. Be' ël Aarón ttöraë Egipto blú ta̱ be' skéie we̱s ye' ttekölpa ttöke ye' skéie es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ì ko̱s chekeyö be' a̱, e' cherane be' tö Aarón a̱ ta̱ Aarón tö icherane Egipto blú a̱ a̱s ie' tö ka̱wö mù a' a̱ Israel aleripa yöktsa̱rak Egipto a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Erë ye' tö Egipto blú e̱r darë'we̱kewa̱. Ì kë̀ o̱r yi a̱ ese we̱rayö Egipto ye' diché tai̱ë e' wà kkachoie. Ie'pa wökrardawa̱ isa̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Egipto blú kë̀ tö a' ttö̀ iu̱tepa. Erë ye' tö egiptowak we'ikeraë sia̱rë ye' diché tai̱ë e' wa. Es ye' tö Israel aleripa yeralur. Ie'pa dör ye' a̱ we̱s ñippökwakpa tso' tai̱ë es. Ie'pa dör ye' icha. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Egiptowak we'ikéyö sia̱rë ye' diché tai̱ë wa ñies Israel aleripa yéttsa̱yö e' ukuöki̱ ta̱ egiptowak tö isue̱raë tö moki̱ë ye' dör Jehová. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moisés ena Aarón e'pa tö iwakanewé̱ we̱s Jehová tö iché ie'pa a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mik ie'pa tté Egipto blú ta̱ eta̱ Moisés ki̱ duas tso' dabom paryök (80). Aarón ki̱ duas tso' dabom paryök ki̱ mañat (83). ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Jehová tö iché Moisés ena Aarón a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","—Egipto blu' tö a' a̱ iché: ‘Ì kë̀ o̱r yi a̱ ese ú̱’, e' ta̱ ichö́ Aarón a̱ tö ishko kéli iu̱yö́mi i̱ski̱ a̱s iyönar tkabë̀ie Egipto blú wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Eta̱ Moisés ena Aarón mía̱ Egipto blú ska' eta̱ ie'pa iwé̱ we̱s Jehová tö iché ie'pa a̱ es. Aarón tö ishko kéli u̱yémi i̱ski̱ Egipto blú ena ikue̱blupa e'pa wörki̱ ta̱ iyönane tkabë̀ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Eta̱ Egipto blú tö wëpa wa̱ íyi jche̱r tai̱ë ena ie'pa awápa esepa tsu̱k patké. Ie'pa tö ikanewé̱ ñì su̱ë isiwé̱ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ie'pa shko kéli u̱yémi i̱ski̱ ñies ta̱ iyönane ñies tkabë̀ie. Erë Aarón shko kéli tö Egipto shko kéli katéwarak se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Erë Egipto blú e̱r téwa̱ darërëë we̱s Jehová tö iyë' es. Ie' kë̀ wa̱ ie'pa ttö̀ iu̱tëne yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","E' ukuöki̱ ta̱ Jehová tö iché Moisés a̱: —Egipto blu' e̱r téwa̱ darërëë. Kë̀ ie' é̱na Israel aleripa akmine. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Bule bla'mi mik ie' mía̱ di'kka, eta̱ be' yú ttök ie' ta̱. Ie' panú di'kka. Shko kéli yönane tkabë̀ie e' kéli tsú̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ie' a̱ ichö́: ‘Jehová dör hebreowak Këköl, e' tö ye' patké ichö́k be' a̱ tö ie' ala'r ö́mine a̱s imi'rak ie' ki̱kökka̱ ká̱ wé̱ ki̱ kë̀ yi se̱rku̱' ee̱. Ikkë ta̱ ka̱m bö ie' ttö̀ iu̱tö̀ yës.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","E' kue̱ki̱ Jehová tö ye' patké ichök be' a̱: ‘Ire' bö isue̱raë tö moki̱ ie' dör Jehová. Mik ye' tö di' ppé shko kéli a'tse̱r ye' wa̱ e' wa, eta̱ di' mia̱raë pë́ wöchka. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nima duölurdaë. Di' alaburdaka̱ suluë. Egiptowak kë̀ a̱ di' e' yanuk, tai̱ë ie'pa dako'we̱ka̱raëitö.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ñies Jehová tö iché Moisés a̱: —Ichö́ Aarón a̱ tö ie' shko kéli klö'ú̱ ta̱ ikö́ka̱ di' ko̱s tso' ie'pa wa̱ yè ese tsa̱ka̱. Di'la, batsöri, di' wöblë, di' bló tso' ese ko̱s tsa̱ka̱ ie' ulà kö́ka̱ a̱s imi'a̱ pë́ie. ¡Es imia̱raë pë́ wöchka di' bló ulitane yöule kal wa ö ák wa ese a̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Eta̱ Moisés ena Aarón iwakanewé̱ we̱s Jehová tö iché ie'pa a̱ es. Aarón tö ishko kéli kéka̱ e' wa di' ppéitö Egipto blú ena ikue̱blupa wösha̱ë. Eta̱ di' ko̱s ekkë mía̱ pë́ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nima ko̱s duolur. Di' alanewa̱ suluë kë̀ yar egiptowak a̱. ¡Ká̱ wa'ñe di' mía̱ pë́ wöchka! ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Erë egiptowak awápa tö iwé̱ ñies isiwé̱ wa. E' kue̱ki̱ Egipto blú e̱r téwa̱ we̱s Jehová tö iyë' es. Ie' kë̀ wa̱ Moisés ena Aarón ttö̀ iu̱tëne yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ie' mía̱ne iu a̱. Kë̀ tkine íyi ko̱s ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Egiptowak ko̱s kë̀ a̱ di' yar e' kue̱ki̱ ie'pa tö di' wöblë bié di' kkömik di' manene yottsa̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Jehová tö di' kiè Nilo e' suluo̱'wa̱ e' ki̱ ká̱ de kul, ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","eta̱ ie' tö iché Moisés a̱: —Be' yú Egipto blú ska' ta̱ ichö́ ia̱: ‘Jehová tö ye' patké ichök be' a̱ i' es: Ye' ichapa ö́mine a̱s imi' ye' dalöiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kë̀ be' tö ie'pa èmi, e' ta̱ ye' tö bukuë' alöwe̱raka̱ tai̱ë a' ká̱ ki̱ a' we'ikoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Di' Nilo a̱ bukuë' alördaë tai̱ë shu̱te̱ë. E' e̱' yöralur di' a̱ mirawa̱ be' u a̱. Idörawa̱ we̱shke̱ wé̱ be' kapöke ee̱, be' ka̱' ki̱. Ñies idörawa̱ be' kue̱blupa u a̱ ena be' yamipa ko̱s e'pa u a̱. Ie̱' tiu̱rawa̱ wé̱ a' u̱löke ese a̱ ena wé̱ a' pan wötuöke ese ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Bukuë' u̱rdaka̱ be' ki̱ ena be' kue̱blupa ki̱ ena ko̱s be' ká̱ wakpa tso' e'pa ki̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Eta̱ Jehová tö Moisés a̱ iché: —Ichö́ Aarón a̱ tö ie' ulà ena ie' shko kéli kö́ka̱ di' kibi ena di' tsitsir ena batsöri ko̱s ekkë tsa̱ka̱ a̱s bukuë' döka̱ di' a̱ Egipto ko̱s wà iökka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aarón tö ishko kéli kéka̱ Egipto di' ko̱s tsa̱ka̱. Eta̱ Egipto ká̱ wa'ñe bukuë' alöneka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Erë egiptowak awápa tö iwé̱ ñì su̱ë isiwé̱ wa. Ie'pa tö bukuë' alöwé̱ka̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","E' ukuöki̱ ta̱ Egipto blú tö Moisés ena Aarón e'pa tsu̱k patké ta̱ ichéitö ie'pa a̱: —A' tö ikiö́ Jehová a̱ tö bukuë' yö́lur ye' ki̱ ena ye' ká̱ wakpa ko̱s ki̱ ñies. E' yéluritö eta̱ ye' tö a' yamipa émimi a̱s imi' iyiwak ña'u̱k Jehová dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Eta̱ Moisés tö Egipto blú iu̱té: —Ichö́ ña tö ¿Mik be' ki̱ ikiane tö ye' tö ikiè Jehová a̱ be' ki̱ ena be' kue̱blupa ki̱ ena be' ká̱ wakpa ko̱s ki̱ a̱s bukuë' kë̀ tö a' tsiriwè̱ia̱ ta̱ ia̱tdaë di' ë̀ a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Egipto blú iiu̱té: —Ikiö́ Jehová a̱ bule. Eta̱ Moisés tö iché ie' a̱: —E' wà tköraë we̱s be' ki̱ ikiane es a̱s be' wa̱ ijche̱r tö kë̀ yi dör we̱s sa' Këköl Jehová es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Bukuë' e̱' yölurdane be' u a̱ a̱tdaë di' ë̀ a̱. Kë̀ itö be' tsiriwe̱paia̱. Ñies be' kue̱blupa ena be' ká̱ wakpa ko̱s kë̀ tsiriwe̱paia̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Eta̱ Moisés ena Aarón e̱' yéttsa̱ Egipto blú wöwa. E' ukuöki̱ ta̱ Moisés ikié Jehová a̱ tö bukuë' patkë'bitu̱ Egipto blú ki̱ e' trë'ú̱mi ie' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Eta̱ Jehová tö iwakanewé̱ we̱s Moisés tö ikié ia̱ es. Bukuë' tso' egiptowak u a̱ iupamik u'rki̱ e' ko̱s duolur. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Egiptowak tö bukuë' nu ko̱s shté dapa'wé̱ tai̱ë. E' nu alabuneka̱ suluë ká̱ e' ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Erë mik Egipto blú tö isué̱ tö ie' tsa̱tkëne bukuë' ulà a̱, eta̱ ie̱r té̱wa̱ne darërëë we̱s Jehová tö iyë' es. Kë̀ ie' wa̱ Moisés ena Aarón ttö̀ iu̱tëne. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","E' ukuöki̱ ta̱ Jehová tö iché Moisés a̱: —Ichö́ Aarón a̱ tö ie' shko kéli kö́ka̱ siwa̱' ki̱ e' wa íyök po ppö́ a̱s imi'a̱ mulu̱'shwakie Egipto wa'ñe. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Eta̱ iwakanewé̱rakitö es. Aarón tö shko kéli kéka̱ ta̱ íyök po ppéitö iwa eta̱ íyök po tso' Egipto wa'ñe e' mía̱ mulu̱'shwakie e' iëneka̱ se' ki̱ ñies iyiwak ko̱s ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Egiptowak awápa ima'wé̱ mulu̱'shwak alöu̱kka̱ isiwé̱ wa, erë kë̀ iwà yöne ie'pa a̱. E' dalewa mulu̱'shwak iëneka̱ tai̱ë ie'pa ki̱ ñies iyiwak ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Eta̱ iwépa tö iché Egipto blú a̱: —¡I' dör Skëköl kanè moki̱! Erë ie' e̱r té̱wa̱ darërë we̱s Jehová tö iyë' es. Kë̀ ie' wa̱ ie'pa ttö̀ iu̱tëne. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","E' ukuöki̱ ta̱, Jehová tö iché Moisés a̱: —Bule bla'mi Egipto blú mi'ke di'kka, e' kue̱ki̱ be' e̱' kö́ka̱ bla'mi ta̱ be' yú ñì ku̱kwa̱ ita̱. Ichö́ ie' a̱: ‘Jehová tö ye' patké ichök be' a̱ i' es: Ye' ichapa ö́mine a̱s imi' ye' ki̱kökka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kë̀ be' tö ie'pa èmine, e' ta̱ ye' tö ö́ tai̱ë patkeraë be' ki̱ ena be' kue̱blupa ki̱ ena ko̱s be' ká̱ wakpa tso' e'pa ki̱. Ö́ iërdaka̱ egiptowak u ko̱s ekkë ki̱ dö̀ íyök ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Mik e' wà de a' ki̱, eta̱ ö́ patkeraëyö a' ë̀ ki̱. Wé̱ ye' ichapa se̱rke Gosen ee̱ ö́ kë̀ sue̱pasö yës. Es be' é̱na ia̱rmi tö moki̱ ye' dör Jehová, e' durse̱ ká̱ i' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Be' ká̱ wakpa e'pa ë̀ we'ikeraë ie' tö. Erë ye' ichapa kë̀ we'ikepayö. E' wà tköraë bule.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Es Jehová tö iwakanewé̱. Ö́ dettsa̱ chkaie Egipto blú u a̱ ena ikue̱blupa u a̱ ñies Egipto wa'ñe e' a̱. Ö́ tö Egipto ká̱ ko̱s klö'wé̱wa̱ se̱, sulu'wé̱wa̱ yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Eta̱ Egipto blú tö Moisés ena Aarón tsu̱k patké ta̱ ichéitö ie'pa a̱: —A' yú, e̱'ma a' Këköl a̱ iyiwak ña'u̱k. Erë kë̀ a' e̱' yökulur Egipto a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moisés tö iiu̱té: —Kë̀ e' dör buaë es. Sa' iyiwak ña'we̱ke sa' tö sa' Këköl Jehová e' a̱, e' dör iyiwak dalöieke a' tö skëkölie ese. A' tö sa' sué̱ iyiwak ese ña'u̱k, e' ta̱ a' tö sa' ttèwa̱mi ák wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Sa' ka̱wöta̱ shkök dö̀ ká̱ mañat dö̀ wé̱ kë̀ yi se̱rku̱' ese ska'. Ee̱ sa' tö iyiwak ña'we̱ke sa' Këköl Jehová a̱ we̱s ka̱wö méa̱titö sa' a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Egipto blú tö iché: —A' kë̀ mìne ka̱mië shu̱te̱, e' ta̱ ye' tö a' èmimirak wé̱ kë̀ yi se̱rku̱' ese ska', iyiwak ña'u̱k a' Këköl Jehová e' a̱. A' Këköl Jehová a̱ ikiö́ ye' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moisés tö iiu̱té: —Mik ye' e̱' yéttsa̱ í̱e̱, eta̱ ye' mía̱ Jehová a̱ ikiök be' ki̱ a̱s ö́ pormi be' yöki̱ ena be' kue̱blupa yöki̱ ena be' ká̱ wakpa ko̱s e'pa yöki̱. Erë kë̀ be' tö sa' ki̱tö'u̱kia̱. Kë̀ be' tö Israel aleripa wöklö'u̱k a̱s imi' iyiwak ña'u̱k Jehová a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mik Moisés e̱' yéttsa̱ Egipto blú wöwa, eta̱ ie' ikié Jehová a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Eta̱ Jehová tö iwé̱ we̱s Moisés tö ikié ie' a̱ es. Es ö́ po'wé̱miitö Egipto blú yöki̱ ena ikue̱blupa yöki̱ ena iká̱ wakpa ko̱s e'pa yöki̱. Kë̀ ö́ a̱te̱ia̱ etkla wë'ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Erë Egipto blú e̱r skà té̱wa̱ne darërëë. Kë̀ ie' wa̱ Israel aleripa anemi. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","E' ukuöki̱ ta̱ Jehová tö iché Moisés a̱: —Be' yú ttök Egipto blú ta̱, ta̱ ichö́ ia̱: ‘Jehová dör hebreowak Këköl, e' tö ichè i' es: Ye' ichapa ö́mine a̱s imi' ye' ki̱kökka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Be' kë̀ tö ie'pa èmine, be' tö ie'pa wöklö'we̱keia̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","e' ta̱ ye' tö duè meka̱raë be' iyiwak ko̱s e' ki̱ ye' diché tai̱ë wa. Be' kabaio, be' burro, be' kameio, be' baka ena be' obeja ekkë ko̱s duölurdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Erë Israel aleripa iyiwak ulitane kë̀ duöpalur etö wë'ia̱. Es ye' tö ikkacheraë tö ie'pa dör ye' ichapa.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Eta̱ Jehová tö iké̱wö méwa̱ i' es: —E' ko̱s we̱raëyö bule. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Bule es ta̱ Jehová tö iwé̱. Egiptowak iyiwak ko̱s e' duolur. Erë Israel aleripa icha kë̀ du'wa̱ etö wë'ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Egipto blú tö Israel aleripa icha sa̱u̱k patké eta̱ ie' isué̱ tö moki̱ Israel aleripa icha kë̀ du'wa̱ etö wë'ia̱. Erë ie' e̱r ki̱téwa̱ darërëë. Kë̀ ie' wa̱ Israel aleripa a̱ ka̱wö mène a̱s imi'rak. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","E' ukuöki̱ ta̱ Jehová tö iché Moisés ena Aarón a̱: —Mulu̱chka tso' bö'kkö a̱ e' klö'ú̱ ta̱ a̱s Moisés tö iu̱yö̀ siwa̱' ki̱ Egipto blú wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Mulu̱chka e' po a̱rdaë Egipto ko̱s e' ki̱. E' tskirdane ie'pa ki̱ skuëkie ñies iiyiwak ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Eta̱ Moisés ena Aarón mulu̱chka klö'wé̱ bö'kkö a̱ ta̱ imía̱ Egipto blú ska' ta̱ e' wörki̱ Moisés tö mulu̱chka u̱yé siwa̱' ki̱. Eta̱ egiptowak mik imoneka̱ skuëkie. Ñies iiyiwak ko̱s mik imoneka̱ skuëkie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Egipto awápa ki̱ skuëk tskineka̱ tai̱ë we̱s imale̱pa es, e' kue̱ki̱ ie'pa kë̀ dë' Moisés wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Erë Jehová tö Egipto blú e̱r darë'wé̱wa̱ a̱s kë̀ itö Moisés ena Aarón ttö̀ iu̱tö̀ we̱s ie' tö iyë' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","E' ukuöki̱ ta̱ Jehová tö iché Moisés a̱: —Be' e̱' kö́ka̱ bule bla'mi eta̱ be' yú Egipto blú a̱ ichök: ‘Jehová dör hebreowak Këköl, e' tö ichè be' a̱ i' es: Ye' ichapa ö́mi a̱s imi'rak ye' ki̱kökka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kë̀ be' wa̱ ye' ttö̀ iu̱tëne i' ta̱, e' ta̱ ye' tö íyi sulusi ko̱s patkeraë be' ki̱ ena be' kue̱blupa ki̱ ena a' wakpa ko̱s e' ki̱. Es be' wa̱ ijche̱rdaë tö kë̀ yi ku̱' ye' tsa̱ta̱ ká̱ wa'ñe. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ye' mú ki̱ ikiane, e̱'ma ye' tö íyi sulusi me'ka̱bak be' ki̱ ena be' yamipa ulitane ki̱ a' e̱u̱kwa ká̱ i' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Erë ye' wa̱ be' tso'ia̱ ttsë'ka a̱s be' tö ye' diché tai̱ë e' sa̱ù̱, ñies a̱s yi dör ye' e' tté pakar ká̱ wa'ñe. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Erë be' e̱r dör suluë ke̱kraë. Kë̀ bö ye' ichapa Israel aleripa émi. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Bule ikkë mò wösi se̱se̱ë ese patkeraëyö a' ki̱ tai̱ë. E' dardaë tai̱ë a' ki̱ tkö̀ka̱ ke̱net idarke Egipto e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Mò wösi a̱rdaë e' tö a' tso' u'rki̱ ena a' iyiwak ko̱s tso' kañika̱ e' ttèmilur se̱. E' kue̱ki̱ a' iyiwak ena ì ko̱s tso' a' wa̱ kañika̱ e' blök patkö́ u diki̱a̱ a̱s itsa̱tkër.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Eta̱ Egipto blú kue̱blupa we̱lepa suane Jehová ttö̀ yöki̱. E'pa tö iiyiwak blé, ñies ikanè mésopa blé u diki̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Erë imale̱pa kë̀ wa̱ Jehová ttö̀ klöne, e'pa tö icha méa̱t u'rki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Eta̱ Jehová tö Moisés a̱ iché: —Be' ulà kö́ka̱ siwa̱' ki̱ a̱s mò wösi se̱se̱ë ese dar tai̱ë Egipto ko̱s a̱. E' a̱rdaë ie'pa ki̱ ena iiyiwak ki̱ ñies idaliwö tso'rak iwa̱ e' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mik Moisés tö shko kéli kéka̱ siwa̱' ki̱, eta̱ Jehová tö alá bla'wé̱ tai̱ë wöñawé̱itö tai̱ë döttsa̱ íyök ki̱ eta̱ mò wösi se̱se̱ë ákwöie e' patkéitö Egipto ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Es Jehová tö mò wösi se̱se̱ë ese patké tai̱ë Egipto ká̱ wa'ñe a̱. Eta̱ mò wösi ese darke tai̱ë ena ká̱ wöñarke tai̱ë, kë̀ iwöklörta̱'. Kë̀ yi wa̱ e' su̱ule yës Egipto. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Eta̱ mò wösi e' bite̱shka tai̱ë ì ko̱s tso' ká̱ áie a̱ e' ki̱, se' ki̱ ena iyiwak ki̱ ñies. Dalì kuá ko̱s pé̱luritö sulu'wé̱luritö. Kal tso' ká̱ wa'ñe e' ulà jchërolone. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Erë ká̱ kiè Gosen, wé̱ Israel aleripa se̱rke, e' a̱ mò wösi kë̀ dane yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Eta̱ Egipto blú tö Moisés ena Aarón tsu̱k patké ta̱ ichéitö ia̱: —Ire' yö isué̱ tö ye' e̱' wamblé suluë. Jehová e' ttè dör moki̱ë. Eta̱ ye' ena ye' ká̱ wakpa sa' iane iwiie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Tai̱ë alá blarke ñies mò wösi darke tai̱ë e' kë̀ dalë'ttsëneia̱ sa' a̱. Jehová a̱ ikiö́ tö iwöklö'ú̱ne, e' ta̱ ye' tö a' ekemi. Kë̀ yö a' wöklö'wè̱ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Eta̱ Moisés tö iu̱té: —Ye' e̱' yéttsa̱ ká̱ i' a̱ ta̱ bet ye' ikieke Jehová a̱, eta̱ mò wösi ena alá wöñarke ko̱s e' wöklördawa̱ a̱s be' wa̱ ijche̱r tö Jehová dör ká̱ wa'ñe e' wák. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Erë ye' wa̱ ijche̱r buaë tö be' ena be' kue̱blupa ka̱m tö Sa' Këköl Jehová e' dalöiö̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Eta̱ daliwö kiè lino e' tso' wörkuaie ena cebada e' wö ta̱'tke, e' kue̱ki̱ iweinewa se̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Erë daliwö kiè trigo ena centeno, kë̀ e' dë' we̱s ka̱m iwörkua bur e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mik Moisés e̱' yéttsa̱ ká̱ e' a̱ mía̱ bánet, eta̱ ee̱ ie' tö ikié Jehová a̱. Eta̱ bet ta̱ mò wösi kë̀ daneia̱ ñies ká̱ kë̀ wöñaneia̱. Ka̱li̱ tai̱ë e' kë̀ yëneia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Mik Egipto blú tö isué̱ tö ka̱li̱ kë̀ yërku̱'ia̱, mò wösi kë̀ darku̱'ia̱ ena alá kë̀ blarku̱'ia̱, eta̱ ie' e̱' wambléne suluë. Kë̀ ie' ë̀ e̱r darë'newa̱ ñies ikue̱blupa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Es Egipto blú e̱r téwa̱ darërëë. Kë̀ iwa̱ Israel aleripa a̱ ka̱wö mène a̱s imi'yal we̱s Jehová tö iyë'ia̱ Moisés ttè wa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","E' ukuöki̱ ta̱ Jehová tö Moisés a̱ iché: —Be' yúne Egipto blú ska'. Ye' tö ie' ena ikue̱blupa e̱r téwa̱ darërëë a̱s ie'pa tö isa̱ù̱ tö ye' diché tai̱ë, e' wa ì kë̀ o̱r yi a̱ ese wè̱ ye' tö tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ye' tö ie'pa e̱r téwa̱ darërëë a̱s be' tö ipakö̀ be' ala'r a̱ ena be' talapa a̱ tö we̱s egiptowak we'ikéyö ñies we̱s ì kë̀ o̱r yi a̱ ese wé̱yö tai̱ë ie'pa wörki̱. Es a' ulitane wa̱ ijche̱r tö ye' dör Jehová. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Eta̱ Moisés ena Aarón míyal Egipto blú ska' eta̱ ichéitö ia̱: —Jehová dör hebreowak Këköl, e' tö ichè i' es: “¿Mik be' tö ye' ttö̀ dalöse̱we̱mirö? Ye' ichapa ö́mi a̱s imi' ye' ki̱kökka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kë̀ be' tö ie'pa èmi bule, e' ta̱ ditski patkeraëyö a' ká̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ditski tö a' ká̱ wà ierawa̱ tai̱ë, kë̀ a̱ íyök ulat wëneia̱. A' daliwö bata méa̱t mò wösi tö e' ko̱s katerawa̱itö yës. Ñies kal ulitane katerawa̱itö se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ñies ditski dörawa̱ tai̱ë be' u ko̱s a̱ ena be' kue̱blupa u a̱ ena egiptowak ko̱s u a̱. ¡Íyi i'se kë̀ su̱ule a' yë́pa bak ká̱ ia̱ia̱ë e'pa wa̱ ie'pa tsá̱ dë'bitu̱ ká̱ i' ki̱ dö̀ ikkë ta̱!” Moisés tté o̱ne ta̱ ie' e̱' wötrée ta̱ imía̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","E' bet ta̱ Egipto blú kue̱blupa tö iché iblú a̱: —¿Mik ta̱ wëm e' kë̀ tö se' we'ikèia̱? A blu', ie'pa ö́mi ie'pa Këköl dör Jehová, e' ki̱kökka̱. A blu', ¿be' kë̀ wa̱ isu̱ne tö se' ká̱ sulunewa̱tke se̱raa̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Eta̱ Egipto blú tö Moisés ena Aarón tsu̱k patkéne eta̱ ichéitö ia̱: —A' yúshka Jehová dör a' Këköl, e' ki̱kökka̱. Erë ke̱weie a' tö ye' a̱ ichö́ tö ¿a' wé̱nepa ë̀ mi'ke? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moisés tö iu̱té: —Sa' ka̱wöta̱ shkökmi se̱kka̱. Sa' ka̱wö tai̱ë tkö'u̱ke Jehová a̱. E' kue̱ki̱ sa' ala'r ena sa' këkëpa, e'pa ko̱s ka̱wöta̱ shkökmi. Ñies sa' obeja ko̱s ena sa' baka ko̱s e' mi'ke sa' wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Eta̱ Egipto blú tö iché ia̱: —¡Iwënewa̱ wösha̱k tö a' e̱rbiköke suluë ye' ki̱! ¿I̱ma a' e̱rbikö̀ tö Jehová tö a' ki̱mèmi a̱s ye' tö a' ö̀mi a' alakölpaë ena a' ala'rë? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Kë̀ iwamblërpa es. A' wëpa kibineo̱ne esepa ë̀ yú Jehová ki̱kökka̱ es a' ki̱ ikiane e' kue̱ki̱. Eta̱ Egipto blú tö ie'pa tsu̱kmi ké ie' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Erë Jehová tö iché Moisés a̱: —Be' ulà kö́ka̱ Egipto ki̱ a̱s ditski bitu̱ Egipto ko̱s wà iökka̱ ñies dalikua bata méa̱t mò wösi tö e' ko̱s katökwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Eta̱ Moisés tö ishko kéli kéka̱ Egipto ki̱ eta̱ Jehová tö siwa̱' patkébitu̱ diwö tskirke e' kke̱ Egipto ko̱s ki̱ ñië nañeë. Bule es bla'mi ta̱ siwa̱' wa̱ ditski debitu̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ditski tö Egipto ká̱ ko̱s e' wà iéwa̱ tai̱ë. Ekkë kë̀ su̱ule yi wa̱ ká̱ ia̱ia̱ë es kë̀ yi tö isue̱paia̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Es ditski dapaneka̱ ká̱ ko̱s ekkë ki̱. Kë̀ a̱ íyök ulat ta̱'ia̱. Dalì kuá ena kalwö e' ko̱s bata méa̱t mò wösi tö e' katélur ditski tö yës. Egipto ko̱s a̱ ka̱kö ko̱s kal kö̀ ko̱s e' kë̀ a̱te̱ia̱ yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","E' bet ta̱ Egipto blú tö Moisés ena Aarón e'pa tsu̱k patké ta̱ iché ia̱: —Ye' e̱' wamblé sulu a' Këköl dör Jehová e' ki̱ ñies a' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ye' kköchö̀ a' a̱ i̱'ñe ë̀ tö a' tö e' olo'yö́ ye' ki̱. Ikiö́ a' Këköl dör Jehová e' a̱ ye' ki̱ tö ditski ë̀ trë'ú̱lur ye' ki̱ a̱s kë̀ sa' duö̀lur. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moisés e̱' yéttsa̱ Egipto blú u a̱ ta̱ bet ikiéitö Jehová a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Eta̱ Jehová tö siwa̱' e' wötréene tsi̱kka darërë e' wa̱ ditski mítse̱r a̱nene dayë kiè Dayë Mat, e' ki̱. Eta̱ ditski kë̀ a̱te̱ yës Egipto. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Erë Jehová tö Egipto blú e̱r sulu téwa̱ne darërëë. Ie' kë̀ wa̱ Israel aleripa a̱ ka̱wö mène a̱s imi'rak. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Eta̱ Jehová tö Moisés a̱ iché: —Be' ulà kö́ka̱ siwa̱' ki̱ a̱s ká̱ ttserwa̱ ttsettseë shu̱te̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Eta̱ Moisés ulà kéka̱ eta̱ ká̱ ttsenewa̱ mía̱ ttsettseë Egipto ká̱ wa'ñe ki̱ döka̱ ká̱ mañat. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Kë̀ yi wa̱ iyami se̱rke tsi̱net e' su̱ne yës. Kë̀ yi a̱ e̱' yënuktsa̱ wé̱ itkër ee̱ döka̱ ká̱ mañat. Erë Israel aleripa u a̱, ee̱ je' ká̱ olo tso' dalölö. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Eta̱ Egipto blú tö Moisés tsu̱k patké ta̱ iché ia̱: —A' yúshka Jehová ki̱kökka̱. A' ala'r ko̱s tsú̱mi. Erë a' obeja ena a' baka e' ko̱s múa̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Eta̱ Moisés tö iiu̱té: —Au. Be' ka̱wöta̱ ka̱wö muk sa' a̱ sa' iyiwak tsu̱kmi ña'wè̱ sa' Këköl dör Jehová e' a̱ idalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","E' kí̱ie ta̱ sa' icha ko̱s, e' michoë sa' wakpa wa̱. Sa' iyiwak shu̱shteke sa' tö ña'wè̱ sa' Këköl Jehová a̱ iki̱koka̱ie. Ka̱m sa' dö̀mi ee̱ eta̱ kë̀ sa' wa̱ ijche̱r iyiwak isie ëtö kiane sa' ki̱ ña'wè̱ Jehová a̱. E' kue̱ki̱ kë̀ sa' tö sa' iyiwak mepaa̱t yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Eta̱ Jehová tö Egipto blú e̱r sulu téwa̱ darërëë. E' kue̱ki̱ ie' kë̀ wa̱ ka̱wö mène Israel aleripa a̱ a̱s imi'rak. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","E' kí̱ie ta̱ Egipto blú tö iché Moisés a̱: —Be' e̱' yö́ttsa̱ í̱e̱. Be' e̱' kkö'nú ye' yöki̱. Be' dene ye' sa̱u̱k, e' ta̱ be' duörawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Eta̱ Moisés tö iiu̱té: —Buaë bö iché es. Kë̀ ye' dë'ia̱ne be' sa̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","E' ukuöki̱ ta̱ Jehová tö iché Moisés a̱: —Ye' tö Egipto blú ena egiptowak ulitane e' bata we'ikekeia̱. E' ukuöki̱ ta̱ Egipto blú tö a' erami, e' kí̱ie ie' wák tö a' ulitane u̱yerattsa̱ da'a̱ie iká̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Eta̱ ichö́ Israel aleripa ulitane a̱, wëpa ena alakölpa tö íyi yöule orochka wa ena inukölchka wa, ese kak kiö́ egiptowak se̱rke ie'pa pamik esepa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Eta̱ Jehová tö egiptowak ké Israel aleripa dalöiök tai̱ë. Egipto blú kue̱blupa ena egiptowak ulitane e'pa tö iklö'wé̱ tö Moisés dör këkëpa tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Eta̱ Moisés tö iché Egipto blú a̱: —Jehová tö ichè i' es: Ká̱ sha̱böts nañewe ye' mi'ke Egipto ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ala'r wëpa kibipa e' ko̱s duöralur. Egipto blú tso' s'wökirie e' alà wëm kibi duörawa̱, ñies egiptowak male̱pa icha ko̱s dö̀ s'sia̱rëpa tso'rak iwa̱ iyiwö woie esepa icha duöralur ñies. Ñies iyiwak uru alà wë'ñe kibi ese ko̱s duöralur. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Sulitane i̱u̱raë tai̱ë Egipto ko̱s a̱. Kë̀ ese ttsëule yi wa̱ es, ñies kë̀ yi tö ese ttsepaia̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Erë Israel aleripa shu̱a̱ kë̀ chichi isie a̱rpa yës se' wöa̱ ena iyiwak wöa̱. Es a' wa̱ ijche̱rdaë tö ye' dör Jehová e' tso' Israel aleripa ki̱muk, erë egiptowak we'ikök ye' tso'. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Eta̱ Moisés tö ikí̱ ché ia̱: —Be' kue̱blupa ko̱s döraë ye' ska', eta̱ ie'pa e̱' tkörawa̱ kuchë ki̱ ye' wörki̱ ta̱ ikköchörarak ye' a̱: ‘Be' yúshka. Be' yamipa tso' ko̱s be' ta̱ e'pa tsú̱mirak ñies.’ Eta̱ Moisés ulune tai̱ë e̱' yéttsa̱ Egipto blú wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","E' ukuöki̱ ta̱ Jehová tö iché Moisés a̱: —Egipto blu' kë̀ tö a' ttö̀ iu̱tepa a̱s ye' tö ì kë̀ o̱r yi a̱ ese kí̱ ù̱ tai̱ë Egipto. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Íyi ekkë ko̱s wé̱ Moisés ena Aarón tö Egipto blú wörki̱, erë Jehová tö ie' e̱r darë'wé̱wa̱ a̱s kë̀ itö ittö̀ iu̱tö̀. E' kue̱ki̱ ie' kë̀ wa̱ ka̱wö mène Israel aleripa a̱ a̱s imi'yal. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Jehová tö iché Moisés ena Aarón tso' Egipto e'pa a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Si' i' döraë a' a̱ duas si' tsa̱we ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Israel aleripa ulitane a̱ ichö́: ‘Si' i' e' diwö dabop (10) eta̱ u bitkue ekkë wakpa tö obeja ö chibo ese wë'ñe pupula yulö́ etö katè ila'r ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","U wakpa we̱lepa kë̀ dör tai̱ë, kë̀ a̱ chkè ekkë katarwa̱, e' ta̱ ie'pa tö iyamipa tso' iupamik esepa kiö́ chkök ie'pa ta̱ ñita̱ ko̱s iwakpa döka̱ ekkë ena ko̱s ie'pa a̱ ikatar ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Obeja ö chibo wë'ñe bua'bua, kë̀ ki̱ ì sulu ku̱' ki̱ duas tso' ek ese yulö́ etö. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","E' blö́. Si' i' e' diwö de dabop ki̱ tkël (14) e' tsá̱li̱ eta̱ a' wa̱ iyiwak tso' blëule ese ttö́ u a̱ u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","E' ukuöki̱ ta̱ a' tö iklö'ú̱ ta̱ u wé̱ a̱ a' tö ikateke, e' wékkö kàtke patiú̱ka̱ a' tö ipë́ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ká̱ e' nañewe chkè e' katö́ katuule bö' a̱ ár bacha'bacha ta̱ ñies pan kë̀ yöule iwölöwo̱ka̱ wa, ese ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kë̀ ikatar aki ena paliule elkela wë'ia̱. Ichkà ko̱s, iwökir, ikla'tska, ena iñattse̱ e' ko̱s ka̱wöta̱ kakuèwa̱ bö' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kë̀ a' tö ibata muka̱t dö̀ bule es. Ibata a̱te̱ia̱, e' ta̱ iña'ú̱lor bö' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Mik a' chköketke eta̱ a' e̱' paiö́, a' klökkuö iö́, a' shko kéli klö'ú̱. Ye' dör Jehová e' tö a' tsa̱tkeke e' ké̱wö tkö'we̱ke a' tö, e' kue̱ki̱ a' chkö́ bet. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“ ‘I̱'ñe nañewe ye' tköraë Egipto ká̱ ko̱s a̱ egiptowak ala'r tsá̱ wëm esepa ttökulur. Ñies ie'pa iyiwak ala'rla tsá̱ dör wë'ñe e' ko̱s tteralur ye' tö. Es këkölpa ko̱s tso' egiptowak wa̱ dalöiè e' we'ikeraë ye' tö tai̱ë. Ye' wák dör Jehová e' tö ichè es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","U ko̱s a̱ wé̱ a' tso' e' wékkö ta'o̱ule ipamik iyiwak pë́ wa e' dör a' wakpa a̱ ikkachoie. Mik ye' tö pë́ e' sué̱, eta̱ ye' damitkö u e' ttö́mik. Mik ye' tso' egiptowak we'ikök sia̱rë, eta̱ e' kë̀ dö̀pa a' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“ ‘A' ka̱wöta̱ ka̱wö e' tkö'u̱k. A' ka̱wöta̱ itkö'u̱k ke̱kraë duas bit ekkë ye' dör Jehová e' dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ká̱ döka̱ ká̱ kul e' shu̱a̱ a' kë̀ ka̱wö ta̱' pan yöule iwölöwo̱ka̱ wa ese ñuk. E' kue̱ki̱ ka̱wö tkö'we̱ke e' diwö tsá̱ eta̱ pan wölöwo̱ka̱ ko̱s ese tulö́ttsa̱ a' u a̱. Yi tö pan yöule iwölöwo̱ka̱ wa ese ñé ká̱ kul e' shu̱a̱, e' ta̱ ese wák kë̀ ka̱wö ta̱' se̱nuk Israel aleripa shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ka̱wö tkö'we̱ke e' tsá̱ diwö eta̱ a' e̱' dapa'ú̱ka̱ ek tsi̱ní ë̀me ye' dalöioie. Ñies e' diwö bata ta̱ a' e̱' dapa'ú̱ka̱ne. Ká̱ tsá̱ ena ibata, e' diwö kë̀ a' ka̱wö ta̱' kaneblök yës, ù̱ ë̀ alirmi a' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ka̱wö kiè Pan Kë̀ Yöule Iwölöwo̱ka̱ Wa, e' ké̱wö tkö'u̱k a' ka̱wöta̱. E' ë̀ ké̱wö wa ye' tö a' yerattsa̱ Egipto a̱ se̱raa̱. E' kue̱ki̱ a' ka̱wöta̱ e' ké̱wö tkö'u̱k. E' ké̱wö tkö'we̱raë a' tö ke̱kraë. E' menea̱t dalöiè a' a̱ ena a' ditséwöpa datse̱ a' itöki̱ aishkuö ta̱ e'pa ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Si' i' dör duas si' tsá̱, e' diwö dabom eyök ki̱ tkël (14) e' tsá̱li̱ a' kë̀ ka̱wö ta̱' pan yöule iwölöwo̱ka̱ wa ese ñuk dö̀ si' i' ki̱ diwö de dabom böyök ki̱ et (21), e' tsá̱li̱ eta̱ a' tö iñèmine. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ka̱wö kul e' shu̱a̱ a' kë̀ ka̱wö ta̱' pan wölöwo̱ka̱ se̱u̱k u a̱. Yi tö pan yöule iwölöwo̱ka̱ wa ese ñé ká̱ kul e' shu̱a̱, ká̱ kua̱'ki̱ wakpa ö Israel aleripa, e' ta̱ ese wák kë̀ ka̱wö ta̱' se̱nuk Israel aleripa shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","E' kue̱ki̱ ì ko̱s yöule pan wölöwo̱ka̱ wa, ese kë̀ ñar yës. Wé̱ a' tso'rö ee̱ ta̱ a' kë̀ ka̱wö ta̱' pan yöule iwölöwo̱ka̱ wa, ese ñuk.’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Eta̱ Moisés tö Israel aleripa kue̱blupa dapa'wé̱ ta̱ ichéitö ia̱: “A' wakpa bil ekkë yú obeja ö chibo klö'u̱k etö etö, tsú̱mi a' u a̱ a' yamipa a̱. Ittö́wa̱, Jehová tö se' tsa̱tkere i̱'ñe, e' ké̱wö tkö'wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ipë́ klö'ú̱ tka̱' a̱. Eta̱ ka̱kö kiè hisopo e' ulà klö'ú̱ eyök, e' nuú̱ka̱ pë́ wa, e' wa u wékkö kàtke patiú̱ka̱. Kë̀ a' e̱' yökulur u a̱ ka̱m ká̱ ñir e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mik Jehová tkö̀mi egiptowak ttökulur, eta̱ ie' tö u wékkö e' kàtke sué̱ iauleka̱ pë́ wa eta̱ ie' damitkö u e' ttö́mik. Es Jehová kë̀ ka̱wö mepa ibiyöchökwak tö s'ttekelur e' a̱ a' ttökulur we̱shke̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","A' ka̱wöta̱ ttè i' ko̱s dalöiök ke̱kraë, ñies a' aleripa ko̱s datse̱ a' itöki̱ e'pa ka̱wöta̱ idalöiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Mik a' demi ká̱ yë' Jehová tö tö imeraë se' a̱ ee̱, eta̱ a' ka̱wöta̱ ka̱wö i' tkö'u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Mik a' ala'r tö ichaké a' a̱: ‘¿Iö́k se' tö ka̱wö i' tkö'we̱ke?’, ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","eta̱ a' ka̱wöta̱ iiu̱tök: ‘Iyiwak i' ttekesö Jehová dalöioie ie' tö se' tsa̱tkë' egiptowak ulà a̱ e' kue̱ki̱. Mik ie' bakmi egiptowak ttökulur, eta̱ ie' bakmi se' Israel aleripa u ttö́mik kë̀ dë'wa̱. Es ie' tö se' yamipa tsa̱tkë'lor.’ ” Eta̱ Israel aleripa e̱' tkélur kuchë ki̱ Jehová dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","E' ukuöki̱ ta̱ ie'pa mía̱ iwakanewé̱ we̱s Jehová tö iché Moisés ena Aarón a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ká̱ sha̱böts Jehová tö egiptowak ala'r wëpa kibipa esepa ko̱s ttélur se̱raa̱. Egipto blú tso' s'wökirie e' alà wëm kibi e' duowa̱. Egiptowak male̱pa icha ko̱s dö̀ s'tso' wötëule s'wöto wé a̱ e'pa ala'r wëpa kibipa e'pa duolur ñies. Ñies iyiwak alà wë'ñe kibi e' ko̱s duolur. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","E' nañewe Egipto blú ena ikue̱blupa ñies egiptowak ko̱s e'pa e̱' kéka̱rak se̱raa̱ i̱u̱k ë̀me. Kë̀ u ku̱' yës e' kë̀ a̱ s'nu ku̱'. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","E' nañewe Egipto blú tö Moisés ena Aarón tsu̱k patké ta̱ ichéitö ia̱: —A' yúshka a' yamipaë. A' e̱' skö́ bánet sa' yöki̱. A' yúshka Jehová ki̱kökka̱ we̱s a' tö iyë' kuaë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Iyiwak ko̱s tsú̱mi we̱s a' ki̱ ikiane es. A' yúshka sa' yöki̱. Ñies a' kköchö́ Jehová a̱ a̱s ie' ye' ki̱mù. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Eta̱ egiptowak tö iché Israel aleripa a̱: “A' yúshka betbet sa' yöki̱. A' kë̀ mìne e' ta̱ sa' ulitane duöralur.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Israel aleripa tö harinachka, kë̀ wötuule iwölöwo̱ka̱ wa, ese patréwa̱ tka̱'ë idatsi' a̱ iéka̱ ppéka̱ kuli' ki̱ ta̱ imíyal. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ie'pa tö orochka ena inukölchka ena datsi' e' ko̱s kak kié egiptowak a̱ we̱s Moisés tö iyë' ia̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Jehová tö egiptowak ké Israel aleripa dalöiök e' kue̱ki̱ ie'pa tö íyi ko̱s kak kiérakitö e' mé Israel aleripa a̱. Es Israel aleripa tö egiptowak íyi bua'bua e' ko̱s tsé̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israel aleripa e̱' yélur Ramsés, míyal Sucot. Ie'pa wëpa kibineo̱netke döka̱ 600.000. Alakölpa ena ala'rla kë̀ shta̱o̱ule. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ie'pa ta̱ pë' kua̱'ki̱pa mí ñies tai̱ë. Ñies iyiwak mírak iwa̱ tai̱ë obeja ena chibo ena baka. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Egiptowak tö Israel aleripa ka' e̱' yöktsa̱ bet kë̀ wa̱ ka̱wö menea̱t ie'pa a̱ u̱loie, e' kue̱ki̱ ie'pa wa̱ harinachka mir kë̀ iwölöwo̱ka̱ ta̱'. E' wa ie'pa pan yué ñala̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israel aleripa bak se̱nuk Egipto duas döka̱ cien tkëyök ki̱ dabom mañayök (430). ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ie'pa se̱né Egipto duas döka̱ cien tkëyök ki̱ dabom mañayök (430) tas, eta̱ e' nañewe wösha̱ë ta̱ ie'pa e̱' yélur Egipto a̱ iditséwö wa iditséwö wa we̱s ñippökwakpa tai̱ë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","E' nañewe Jehová tö ie'pa kkö'né buaë a̱s ie'pa e̱' yö̀lur Egipto a̱. E' kue̱ki̱ nañewe e' ké̱wö ka̱wöta̱ tkö'wè̱ wöñine wa duas bit ekkë ke̱kraë Jehová dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Jehová tö iché Moisés ena Aarón a̱: “Ye' tö a' tsa̱tkeke egiptowak ulà a̱ e' ké̱wö tkö'u̱k a' ka̱wöta̱ i' es: Ká̱ kua̱'ki̱ wakpa esepa kë̀ ka̱wö ta̱' obeja ö chibo tteke a' tö e' ké̱wö ska' ta̱ ese chkà katök. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Erë ká̱ kua̱'ki̱ wakpa wëpa ena alakölpa wé̱pa to̱'ttsa̱tke a' tö kanè mésoie ena e' wëpa tottola kkuölit tëule tsir, esepa ë̀ tö ikatèmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Erë ká̱ kua̱'ki̱ wakpa tso' shkar ö kaneblök inuköl klö'u̱k, esepa kë̀ ka̱wö ta̱' ikatök. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","A' ka̱wöta̱ chkè e' katök we̱shke̱. A' kë̀ ka̱wö ta̱' chkè e' tsu̱kmi u'rki̱ yës. Ñies a' kë̀ ka̱wö ta̱' idichéwö pu̱kwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Israel aleripa ulitane ka̱wöta̱ ka̱wö e' tkö'u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Erë a' shu̱a̱ ká̱ kua̱'ki̱ wak tso' se̱nuk esepa é̱na ka̱wö e' tkö'wa̱k a' ta̱ Jehová dalöioie e' ta̱ a̱s itö itkö'ù̱ñak. Erë ke̱we ie'pa tö iyamipa wëpa ulitane tso' ie' u a̱ e'pa keraë itóttola kkuölit tök tsir. E' ukuöki̱ ta̱ ie'pa ka̱wö tkö'wè̱mi a' ta̱ a' yamipaie. Erë wé̱pa kë̀ tottola kkuölit tëule tsir esepa kë̀ ka̱wö ta̱' a' ka̱wö tkö'u̱ke e' chkè katök. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","A' ulitane ena ká̱ kua̱'ki̱ wakpa se̱rke a' shu̱a̱ e' ka̱wöta̱ ttè i' dalöiök ñikkëë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Israel aleripa tö ttè i' ko̱s iu̱té we̱s Jehová tö iché Moisés ena Aarón a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","E' diwö Jehová tö Israel aleripa yélur Egipto iditséwö wa iditséwö wa we̱s ñippökwakpa tai̱ë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Jehová tö iché Moisés a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Israel aleripa ala'r wëpa kibi esepa ko̱s dör batse'r ye' a̱. Ñies a' iyiwak alà tsá̱ wë'ñe e' ko̱s dör batse'r ye' a̱. E' kue̱ki̱ e' ko̱s blö́ ye' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Eta̱ Moisés tö iché Israel aleripa a̱: “I̱'ñe Jehová tö a' yekettsa̱ Egipto a̱ ie' diché tai̱ë e' wa. Ká̱ i' a̱ a' weine sia̱rë kaneblök egiptowak a̱ kë̀ patuè̱ ta̱'. E' kue̱ki̱ a' e̱r a̱nú diwö i' ska'. A' kë̀ ka̱wö ta̱' pan yöule iwölöwo̱ka̱ wa ese ñuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","I̱'ñe a' e̱' yökettsa̱, si' i' kiè Abib e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mik a' demi ká̱ muk Jehová kablë' se' yë́pa bak ká̱ ia̱ia̱ë e'pa a̱ ee̱, eta̱ a' ka̱wöta̱ ka̱wö i' tkö'u̱k si' i' a̱. Ká̱ e' ki̱ íyi ulitane tskir buaë, iwà wör buaë shu̱te̱. Ká̱ e' dör canaánwak, hititawak, amorreowak, heveowak ena jebuseowak, e'pa ká̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","A' ka̱wöta̱ ka̱wö i' tkö'u̱k i' es: Ká̱ kul shu̱a̱ a' kë̀ ka̱wö ta̱' pan yöule iwölöwo̱ka̱ wa ese ñuk. Ka̱wö e' diwö bata, eta̱ ka̱wö tkö'we̱raë bua'ie Jehová dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ka̱wö kul e' shu̱a̱ a' kë̀ ka̱wö ta̱' pan yöule iwölöwo̱ka̱ wa ese ñuk. Pan wölöwo̱ka̱ ena pan yöule iwölöwo̱ka̱ wa ese ko̱s kë̀ ka̱wö ta̱' se̱'wè̱ a' tö a' ká̱ ko̱s e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","E' diwö ta̱ a' tö ichö́ a' ala'r a̱: Ka̱wö e' tkö'we̱ke se' tö, e' wà dör tö Jehová tö se' yë'lur Egipto a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ie' tö se' yë'ttsa̱ Egipto a̱ idiché tai̱ë wa, e' kue̱ki̱ se' dör ie' icha. Mik se' tö ka̱wö e' tkö'we̱ke, eta̱ e' tö se' ulitane a̱ ie̱ri meraë a̱s Jehová ttè ki̱ se' e̱r me'rie. E' dör we̱s se' e̱' wakyuö̀ se' wötsa̱ ki̱ ena se' ulà kkue ki̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","E' kue̱ki̱ a' ka̱wöta̱ ka̱wö e' tkö'u̱k duas bit ekkë idiwö i' ë̀ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Ká̱ ia̱ia̱ë Jehová tö iyë'a̱t a' yë́pa a̱ tö ie' tö canaánwak ká̱ meraë a' a̱. Mik ie' wa̱ a' demi ká̱ e' a̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","eta̱ a' ka̱wöta̱ a' ala'r wëpa kibi esepa ko̱s blök ie' ë̀ a̱ e'pa ko̱s dör ie' icha, e' kue̱ki̱. Ñies a' iyiwak pa̱rke ko̱s wë'ñe, e' kibi ko̱s e' dör ie' icha, e' kue̱ki̱ ese ka̱wöta̱ blè ie' ë̀ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Eta̱ obeja wë'ñe pupula ö chibo wë'ñe pupula e' mú a' tö burro alaki e' alà wë'ñe kibi e' skéie burro alà tsa̱tkoie. Erë a' kë̀ a̱ e' patua̱k es, e' ta̱ burro alà wë'ñe kibi e' kuli' pú̱wa̱. Es a' ka̱wöta̱ a' ala'r wëpa tsá̱ ku̱ne esepa ko̱s skéie iyiwak muk itsa̱tkottsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Aishkuö ta̱ mik a' ala'r tö a' chakeke tö: ‘¿Iö́k a' tö ikanewè̱ i' es?’, eta̱ iiu̱tö́: ‘Jehová tö se' yë'ttsa̱ Egipto a̱ idiché tai̱ë e' wa. Ee̱ se' bak weinuk sia̱rë kaneblök kë̀ patuè̱ ta̱'. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Mik Egipto blú e̱r të'wa̱ darërëë, ie' kë̀ wa̱ ka̱wö mène se' a̱ e̱' yöktsa̱ne ie' ká̱ a̱, eta̱ Jehová tö egiptowak ala'r wëpa tsá̱ ku̱ne e'pa ko̱s ttélur. Ñies iiyiwak alà wë'ñe kibi e' ko̱s ttéluritö. E' kue̱ki̱ se' tö se' iyiwak alà wë'ñe kibi, ese ko̱s meke Jehová a̱. Ñies se' ala'r wëpa tsá̱ ku̱ne, ese skéie iyiwak mekesö Jehová a̱ itsa̱tkottsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","E' kue̱ki̱ ka̱wö i' tkö'ú̱ a̱s kë̀ a' é̱na ichö̀wa tö Jehová tö a' yë'ttsa̱ Egipto a̱ idiché tai̱ë e' wa. E' dör we̱s se' e̱' wakyuö̀ se' wötsa̱ ki̱ ena se' ulà kkue ki̱ es.’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Mik Egipto blú tö Israel aleripa émi, eta̱ Skëköl tö ibikeitsé tö Israel aleripa mú kë̀ ñippö̀ filisteowak ta̱, e' ta̱ ie'pa bitu̱miane Egipto. E' kue̱ki̱ ie' kë̀ wa̱ ie'pa wëttse̱nemi ñala̱ michoë filisteowak ká̱ a̱ e' wa, e' dör ñala̱ yësyësë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","E' kue̱ki̱ ie' tö ie'pa wëttsé̱mi bánet ka̱mië ñala̱ tköke ká̱ sir po e' shu̱a̱ döttsa̱ dayë kiè Dayë Mat e' ska'. Israel aleripa e̱' yë'lur dapauleka̱ we̱s ñippökwakpa tai̱ë e' e̱' dapa'ù̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moisés wa̱ José sik këchke e' mítse̱r ie'pa ta̱ ñita̱. Ka̱m José blërwa̱ e' yöki̱ ie' tö iyë' iëlpa a̱: “Moki̱ Skëköl dörane a' tsa̱tkök. Mik e' wà tka, eta̱ ye' sik tsú̱mi a' ta̱.” Es ie'pa tö ka̱wö mé ñì a̱. E' kue̱ki̱ Moisés wa̱ José sik mítse̱r ie'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Eta̱ Israel aleripa e̱' yélur ká̱ kiè Sucot míyal ká̱ kiè Etam, ee̱ ie'pa e̱' tsé̱a̱t. Ká̱ e' a̱te̱ ká̱ sir po e' kkömik tsi̱net. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ñiwe ta̱ Jehová tö ie'pa wëttse̱ke mò àr tai̱ë alabo e' wa. E' mir ie'pa yöki̱ ke̱we ñala̱ kkachoie ie'pa a̱. Nañewe ta̱ mò e' wöñarke bö'wöie dalöburke. E' wa ie'pa shkömir we̱s ká̱ ñiwe es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ñiwe ta̱ mò e' mir ke̱kraë ie'pa yöki̱ ke̱we. Nañewe ta̱ mò e' wöñarke bö'wöie e' mir ie'pa yöki̱ ke̱we. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Eta̱ Jehová tö iché Moisés a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ichö́ Israel aleripa a̱: A' yúne a' itö̀ wane ta̱ a' e̱' tsú̱a̱t ká̱ kiè Pi-hahirot e' wösha̱. Ká̱ e' a̱te̱ ká̱ kiè Migdol ena dayë kkömik e' shu̱sha̱, ká̱ kiè Baal-sefón, e' wösha̱. E' wösha̱ dayë kkömik tsi̱net úla yuö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Es Egipto blú tö ibikeitseraë: ‘Israel aleripa kë̀ wa̱ ijche̱r wé̱ imi'mirö. Ie'pa cholurmi ká̱ sir po, e' shu̱a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Erë ye' tö ie' e̱r terawa̱ darërë a̱s ie' tö a' tötiù̱mi. Ye' e̱' alöraka̱ ie' ki̱ ena iñippökwakpa ko̱s ki̱, e' wa ye' dalöiërdaë tai̱ë. Egiptowak ulitane wa̱ ijche̱rdaë tö moki̱ ye' dör Jehová.” Eta̱ Israel aleripa tö iwakanewé̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","E' dalewa Egipto blú wöki̱ ibiyö̀ demi tö Israel aleripa tkayal. Ie' ena ikue̱blupa e̱rbikéne kua̱'ki̱ ta̱ ichérakitö ñì a̱: “¿We̱s se' tö ì wamblé i' es? ¿Ìie se' tö Israel aleripa émi ta̱ yi kaneblömiia̱ se' a̱?” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","E' ukuöki̱ bet ta̱ Egipto blú tö ikarreta tso' ñippoie e' tsu̱k patké ta̱ iñippökwakpa patkéitö ñì dapa'u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Eta̱ imía̱ Israel aleripa itöki̱ karreta ñippoie ibua'bua döka̱ cien teryök (600) ekkë. Egipto karreta ñippoie e' male̱pa ko̱s mírak iwa̱ ñies. Karreta ko̱s e' a̱ ñippökwakpa wökir shköke ek ek. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Jehová tö Egipto blú e̱r darë'wé̱wa̱ a̱s ie' mi' Israel aleripa itöki̱ erë́ ie'pa yënettsa̱ Egipto a̱ Jehová diché tai̱ë wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Eta̱ Egipto ñippökwakpa mirwa̱ kabaio ki̱, karreta ki̱, e'pa ko̱s tö Israel aleripa tötié̱mi kué̱rakitö wé̱ Israel aleripa tso' dayë kkömik ká̱ kiè Pi-hahirot e' o̱'mik ena ká̱ kiè Baal-sefón, e' wösha̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Mik Israel aleripa isué̱ tö egiptowak datse̱, e' tö ie'pa suawé̱ tai̱ë. Ie'pa kköché tai̱ë Jehová a̱ tö sa' tsa̱tkö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Moisés a̱ ichérakitö: —¿I̱ma be' iklö'wé̱ pö kë̀ ta̱' Egipto, e' kue̱ki̱ be' tö sa' yë'ttsa̱ duökwa̱ í̱e̱ ká̱ sir po shu̱a̱? ¿Iö́k bö iwamblé es sa' ta̱? ¿Ìie be' tö sa' yë'lur Egipto a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Kuaë sa' tö be' a̱ iyë' Egipto: ‘Sa' múa̱t kaneblök bë̀rë egiptowak a̱. ¡Sa' weirke sia̱rë kaneblök egiptowak a̱, e' dör bua' sa' a̱ duökulur í̱e̱ ká̱ sí poë a̱ e' skéie!’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Erë Moisés tö iiu̱té: —Kë̀ a' tö egiptowak sue̱paia̱. E' kue̱ki̱ kë̀ a' suanuk. A' e̱' tkö́wa̱ darërëë. I̱'ñe Jehová tö a' tsa̱tkeraë e' sa̱ú̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Kë̀ se' tkinuk ì ki̱. Jehová ñippöraë se' skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Jehová tö iché Moisés a̱: —¡Kë̀ be' kköchökia̱ ye' a̱! Ichö́ ie'pa a̱ tö a' shkö́ wöwí̱ ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Be' shko kéli kö́ka̱ dayë tsa̱ka̱ a̱s dayë blatënar ñala̱ie shkotkö poppo dayë shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Erë ye' tö ie' e̱r terawa̱ darërë a̱s ie' tö a' tötiù̱mi. Ye' e̱' alöraka̱ ie' ki̱ ena iñippökwakpa ko̱s ki̱, e' wa ye' dalöiërdaë tai̱ë. Egiptowak ulitane wa̱ ijche̱rdaë tö moki̱ ye' dör Jehová. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Egiptowak ulitane wa̱ ijche̱rdaë tö moki̱ ye' dör Jehová. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","E' wösha̱ë ta̱ Skëköl biyöchökwak mirwa̱ Israel aleripa yöki̱ ke̱we e' e̱' mane'wé̱ttsa̱ne ie'pa tsi̱kkane. Ñies mò àr tai̱ë alabo e' mía̱ ie'pa tsi̱kkane. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Es mò e' a̱te̱ Egipto ñippökwakpa ena Israel aleripa e' shu̱sha̱. Egiptowak kke̱ mò ettaie dör ttsettseë, e' kue̱ki̱ ie'pa tso' ká̱ ttsettse a̱. Erë Israel aleripa kke̱ mò e' dalöburke tai̱ë ká̱ ñiwe sù̱. E' kue̱ki̱ egiptowak kë̀ ulà dë' Israel aleripa ska' e' nañewe. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Eta̱ Moisés ulà kéka̱ dayë tsa̱ka̱ ta̱ Jehová tö siwa̱' bitsi̱wé̱ka̱ darërëë datse̱ diwö tskirke e' ëka̱. E' bitsi̱ne nañeë dayë ki̱. E' tö dayë blatée shu̱sha̱. Es Jehová tö ká̱ ulat poppo yué ñala̱ie dayë shu̱a̱ ie'pa a̱ shkotkö. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ie'pa tkami ká̱ poppo a̱. Es dayë wötuki̱ a̱te̱ wi̱'kë io̱'kë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Eta̱ egiptowak ñippökwakpa mirwa̱ kabaio ki̱ ena karreta ki̱ e'pa ko̱s tö Israel aleripa tötié̱mi dayë a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","E' bla'mi ká̱ ñirketke eta̱ mò wöñarke bö'wöie e' shu̱a̱ Jehová tso' egiptowak sa̱u̱k. Ie' tö ie'pa suawé̱ka̱ tai̱ë e' tö ie'pa wöa̱ ká̱ chöwé̱ka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ñies ie' tö ie'pa karreta wöshki ko̱s e' wötélur dö́ a̱ a̱s kë̀ ishkö̀ bet. Ie'pa tö iché ñì a̱: —Mishka Israel aleripa yöki̱. Jehová tso' ñippök se' ta̱ ie'pa tsa̱tkoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Jehová tö iché Moisés a̱: —Be' ulà kö́ka̱ dayë tsa̱ka̱ a̱s iwöiërwa̱ne Egipto ñippökwakpa ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moisés ulà kéka̱ dayë tsa̱ka̱. Mik ká̱ ñine, eta̱ dayë wöiënewa̱ne es. Mik egiptowak mí tkökshkar, eta̱ dayë wöiënewa̱ ie'pa ki̱. Es Jehová tö ie'pa e̱wé̱wa dayë a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Es Egipto ñippökwakpa mineyal Israel aleripa itöki̱ e'pa ko̱s durulune se̱raa̱ dayë a̱ ikabaioë. Egipto blú ñippökwakpa e' kë̀ a̱te̱ yës ttsë'ka. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Erë Israel aleripa tkami buaë dayë a̱ dö̀ wi̱she̱t ká̱ sí ki̱, dayë wötuki̱ wi̱'kë io̱'kë e' shu̱sha̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","E' ké̱wa Jehová tö Israel aleripa tsa̱tkée egiptowak ulà a̱. Ie'pa tö egiptowak nu sué̱ dayë kkömik. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Mik ie'pa tö isué̱ tö we̱s Jehová tö egiptowak e̱wé̱wa idiché tai̱ë e' wa, eta̱ ie'pa tö ie' dalöié tai̱ë. Ie'pa e̱r blé ie' mik ñies itteköl Moisés e' mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Moisés ena Israel aleripa ttsé Jehová ki̱koka̱ ttsè i' wa: “Ye' ttsöke Jehová dalöioie. Kabaio tai̱ë ena iwákpa ko̱s e' e̱wé̱waitö dayë a̱. Es ie' e̱' alé tai̱ë shu̱te̱ ie'pa ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ye' tso' ttsök Jehová ë̀ a̱. Ie' tö ye' a̱ idiché mé. Ie' tö ye' tsa̱tkée. Ie' dör ye' Këköl. Ye' ka̱wöta̱ ie' ki̱kökka̱ buaë. Ie' dör ye' yë́ Këköl. Ye' tö ie' dalöieraë e̱r moki̱ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ie' dör ñippökwak darërëë bua'ie. Jehová e' dör ie' kiè. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Egipto blú karreta tso' ñippoie ena ie' ñippökwakpa e'pa ko̱s émi dayë a̱ Jehová tö. Egipto blú ñippökwakpa bua'bua e'pa ko̱s duolur se̱ Dayë Mat a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ie'pa katsi̱rulune dayë shu̱a̱ we̱s ák es. Dayë i̱ski̱ë e' ë̀ me'r ie'pa ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","A Jehová, be' ulà bua'kka diché tai̱ë, e' wa be' tö be' bolökpa batsélor. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ie'pa demi ñippök be' ta̱, erë ie'pa ko̱s e̱wé̱wa be' tö be' diché tai̱ë, e' wa. Be' uluneka̱ ie'pa ki̱, ta̱ ie'pa ñanewa̱ we̱s ka̱kö sí es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Dayë wöikébö darërëë ta̱ iwöklönewa̱ie wi̱'kë io̱'kë mía̱ we̱s ká̱ ukuö es. Dayë wöklönewa̱, kë̀ shköku̱'ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Be' bolök e̱' ttséka̱ tai̱ë ta̱ iché: ‘Ye' mi' ie'pa itöki̱ wé̱yö ikué̱rö ta̱ ee̱ ì mirwa̱rak iwa̱ e' yerattsa̱yö iulà a̱, e' wà tierayö ko̱s ye' ki̱ ikiane ekkë. Ye' tabè yerattsa̱ iñalé̱ka, e' wa yö ie'pa tterawa̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Erë be' tö dayë wöiké ta̱ e' tö ie'pa ttélur. Ikatsi̱newa̱ dayë a̱ we̱s tabechka es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","A Jehová, ¡Wé̱pa skà kiekerakitö “skëköl”, esepa ko̱s tsa̱ta̱ be' dör! ¡Kë̀ yi dör batse'r tai̱ë we̱s be' es! ¡Kë̀ yi diché ta̱' tai̱ë we̱s be' es! ¡Ì kë̀ o̱r yi a̱ ese wè̱ be' tö buaë, e' tö sulitane tkiwè̱wa̱! ¡Sulitane ka̱wöta̱ be' ki̱kökka̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Be' ulà bua'kka kéka̱ ta̱ íyök tö ie'pa malé̱wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Be' tö sa' tsa̱tkée. Be' é̱na sa' dalër tai̱ë, e' kue̱ki̱ be' tso' sa' wëttsu̱k. Be' wa̱ sa' mi'ke be' diché wa dö̀ wé̱ be' wák se̱rke ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Mik ká̱ ulitane wakpa wa̱ e' jche̱newa̱, eta̱ ie'pa painuraë suane ë̀ wa̱. Filisteowak krardawa̱ suane ë̀ wa̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edomwak wökirpa chkerdawa̱ suane ë̀ wa̱, Moabwak wökirpa painuraë tai̱ë. Canaánwak ulitane kësik ko̱s e' chörawa yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","A Jehová, ¡a̱s ie'pa tkirwa̱! ¡a̱s ie'pa suar tai̱ë! Be' diché wa a̱s ie'pa a̱t kë̀ ti̱ria̱ suane kue̱ki̱ dö̀ mik sa' ulitane dör be' icha e'pa tka eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","A Jehová, Sa' tse̱ramibö döka̱ be' ka̱bata buaë e' a̱. Ee̱ sa' se̱rdaë buaë ke̱kraë. Ka̱bata e' shu̱kitbö be' a̱ se̱noie. Ee̱ be' wák e̱' wé yué e'dör yöbië. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Jehová tso' se' wëttsu̱k s'blúie ke̱kraë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Mik Egipto blú ñippökwakpa tkawa̱ dayë a̱ kabaio ki̱, karreta ki̱, eta̱ Jehová tö dayë wöiéwa̱ne ie'pa ki̱ erë Israel aleripa tka buaë ká̱ poppo a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","E' ukuöki̱ ta̱ Jehová tteköl kiè María, e' dör Aarón kutà, e' tö ma'ma klö'wé̱wa̱ ttsoie, ta̱ alakölpa ko̱s mí ie' itöki̱ klötökerak es ima'ma blardami. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","E' dalewa María ttsöke i' es: ¡A' ulitane ttsö́ Jehová ki̱koka̱! Kabaio ena iwákpa u̱yéwa̱itö dayë a̱. Es ie' e̱' aléka̱ ie'pa ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moisés tö Israel aleripa ké e̱' yöktsa̱ Dayë Mat e' kkömik. Ie'pa míyal ká̱ sir poë kiè Sur e' a̱. Ee̱ ie'pa shkére ká̱ mañat eta̱ kë̀ ie'pa wa̱ di' ku̱ne yè yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Mik ie'pa demi ká̱ kiè Mará, eta̱ ee̱ di' tso' bacha'bachaë, kë̀ yar ie'pa a̱. E' kue̱ki̱ ká̱ e' kiè méka̱rakitö Mará ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Eta̱ Israel aleripa tö Moisés chémi suluë. Moisés chakérakitö: “¿Ì yèmisö?” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Eta̱ Moisés tö Jehová a̱ ikié tö sa' ki̱mú. Eta̱ Jehová tö ie' a̱ kal tsitsir kkaché elka e' iéwa̱itö di' a̱ eta̱ di' baché chowa de buaë yè. Ee̱ Jehová tö ittè dalöiëno mé ie'pa a̱, ñies ie'pa ma'wé̱itö isuo̱ie tö ie'pa tö idalöièmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ie' tö iché ie'pa a̱: “Ye' dör Jehová. Ye' dör a' Këköl. Ye' dör a' bua'u̱kwak. Ì cheke ye' tö a' a̱ e' ttsé a' tö, e' iu̱té a' tö ñies a' se̱né buaë we̱s ye' ki̱ ikiane es, e' ta̱ ye' kë̀ tö a' we'ikepa ì sulu patkë'yö egiptowak ki̱ ese wa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","E' ukuöki̱ ta̱ ie'pa demi ká̱ kiè Elim. Ee̱ di' tum tso' döka̱ dabom eyök ki̱ böt (12). Ñies ì klö̀ tso' dikó klö̀ sù̱ ese tso' dabom kuryök (70). Ee̱ ie'pa e̱' tsé̱a̱t di' kkömik tsi̱net. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","E' ukuöki̱ ta̱ Israel aleripa ulitane e̱' yélur ká̱ kiè Elim míyal ká̱ sir poë kiè Sin ee̱. Ká̱ e' a̱te̱ Elim ena Sinaí, e' shu̱sha̱. Ie'pa e̱' yë'ttsa̱ Egipto e' ki̱ si' de et ki̱ sha̱böts. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Eta̱ ee̱ ká̱ sir poë shu̱a̱ ie'pa ttémi tai̱ë kësik wa Moisés ena Aarón ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ie'pa tö iché ia̱rak: —¡Jehová tö sa' ttö́palur Egipto! Ee̱ sa' e̱' tulökese̱r ù̱ tulurka̱ wà iëule chikchië chkè wa e' o̱'mik ta̱ sa' bak iwà katök wë' ko̱s sa' ki̱ ikiane ekkë. Erë a' wa̱ sa' dë'bitu̱ ká̱ sir po i' a̱ sa' ulitane ttowa̱ bli wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Jehová tö iché Moisés a̱: —Sú̱yö pan da'wè̱ siwa̱' ki̱ a' a̱. E' shtö́ ká̱ bit ekkë. Erë ishtö́ ko̱s iñar ká̱ etkë̀ ekkë ë̀. Ye' ki̱ ikiane suè̱ tö wé̱pa tö ye' ttö̀ iu̱tèmi ena wé̱pa kë̀ tö ye' ttö̀ iu̱tepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ká̱ de teröl e' bule es ta̱ a' tö chkè kí̱ shtö́ wë' katar ká̱ böt ekkë. Es a' tö iú̱ ke̱kraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Eta̱ Moisés ena Aarón tö iché Israel aleripa a̱: —I̱'ñe tsá̱li̱ ta̱ a' tö isue̱raë tö moki̱ Jehová tö se' yë'lur Egipto a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","A' ttöke kësik wa e' ttsé ie' tö, e' kue̱ki̱ bule bla'mi ta̱ ie' wák olo tai̱ë dalölöë e' sue̱raë a' tö. Ì cheke ie' tö sa' a̱ e' ë̀ chökne sa' tso' a' a̱. E' kue̱ki̱ a' kë̀ ulurku̱' sa' ki̱. A' ulurke ie' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ñies Moisés tö iché ia̱rak: —A' ulurke tai̱ë e' sué̱ Jehová tö. E' kue̱ki̱ i̱'ñe tsá̱li̱ ta̱ ie' tö iyiwak chkà patkeraë a' a̱. Bule bla'mi ta̱ pan patkeraëitö a' a̱ ñè tai̱ë ko̱s a' ki̱ ikiane ekkë. Sa' kë̀ dör yi, a̱s a' ulur sa' ki̱. A' ulurke Jehová ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","E' ukuöki̱ ta̱ Moisés tö iché Aarón a̱: —Ichö́ Israel aleripa a̱ tö a' ttöke kësik wa e' ttsé Jehová tö e' kue̱ki̱ a' e̱' dapa'ú̱ Jehová wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aarón tso' ttök ie'pa ta̱, e' dalewa ie'pa ulitane ká̱ sué̱ ká̱ sir po e' ëka̱. Ie'pa isué̱ tö Jehová olo dalölöë dettsa̱ mò tso' ie'pa wëttsu̱k e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Eta̱ Jehová tö iché Moisés a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","—Israel aleripa ttöke kësik wa, e' ttséyö. Be' ttö́ ie'pa ta̱, ta̱ ichö́ ia̱rak: ‘I̱'ñe tsá̱li̱ a' tö iyiwak chkà kateraë. Bule bla'mi ta̱ a' tö pan ñeraë ko̱s a' ki̱ ikiane ekkë. Es a' wa̱ ijche̱rdaë tö ye' dör Jehová, e' dör a' Këköl.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ká̱ e' tsá̱li̱ ta̱ tai̱ë dù debitu̱ kaklö sù̱. E' tö wé̱ ie'pa se̱rke e' wà iéwa̱ se̱raa̱. Eta̱ bla'mi ta̱ upa ko̱s shke̱ne mò wöli ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Mik mò wöli kaneka̱, eta̱ itö̀a̱ i̱ski̱ ì a̱te̱ taklaie sabubula. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","E' kë̀ su̱ule Israel aleripa wa̱. E' kue̱ki̱ mik ie'pa tö isué̱, eta̱ ie'pa tö iché ñì a̱: “¿Diö́ dör ì?” Eta̱ Moisés tö iché ia̱rak: —E' dör pan mé Jehová tö a' a̱ ñè. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ie' tö ichè tö a' ka̱wöta̱ iu̱k i' es: A' tö ishtö́ eköl eköl ko̱s a' tso' u a̱ e' a̱ iñar ekkë ë̀. Ishtö́ ská̱tke̱ böt ulatök wák eköl eköl a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Eta̱ Israel aleripa ishté we̱s iké̱wö mène es. We̱lepa tö ishté bërëbërë, we̱lepa tö ishté kibiie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Mik ie'pa tö ima'wé̱, eta̱ wé̱ tö ishté tai̱ë ese icha kë̀ bata a̱te̱. Wé̱ tö ishté bërëbërë ese icha deka̱ wë'. Ie'pa ulitane tö ishté eköl eköl ko̱s iñar ekkë ë̀. Es sulitane iñé wë'. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moisés tö iché ie'pa a̱: “Kë̀ a' ka̱wö ta̱' pan e' blök dö̀ bule es.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Erë we̱lepa kë̀ wa̱ Moisés ttö̀ iu̱tëne. E'pa tö icha bata blé dö̀ bule es. E' a̱ öña iëneka̱ ena ilabuneka̱ suluë. E' kue̱ki̱ Moisés uluneka̱ ie'pa ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Mik dìba ba'nebitu̱, eta̱ pan e' diarolone, e' kue̱ki̱ ie'pa wakpa bik tö ishteke bla'mi ko̱s iñar ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Erë mik ká̱ de teröl, eta̱ ie'pa ishté dö̀ iñar ká̱ böt ekkë. E' dör ská̱tke̱ tkël wák eköl eköl a̱. Eta̱ Israel aleripa wökirpa mía̱ ichök Moisés a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Eta̱ Moisés tö iché ia̱: —Jehová tö ichè tö a' ka̱wöta̱ iu̱k i' es: Bule dör e̱no diwö. Diwö e' dör se' a̱ ie' dalöioie. A' kë̀ ka̱wö ta̱' u̱lök e' diwö wa. E' kue̱ki̱ ì aleke a' tö e' alö́ i̱'ñe. Ibata a̱te̱ e' blö́ ñè bule. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Eta̱ ie'pa tö iwé̱ we̱s Moisés tö iché es. Ie'pa tö chkè bata e' blé dö̀ bule es. Eta̱ kë̀ ilane sulu, kë̀ ia̱ öña iëneka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Eta̱ Moisés tö iché ie'pa a̱: —I̱'ñe dör e̱no diwö e' dör se' a̱ Jehová dalöioie. I̱'ñe kë̀ ì kue̱pa a' tö ñè u'rki̱. E' kue̱ki̱ chkè bata a̱te̱ e' ë̀ ñú. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","A' ishtèmi ke̱kraë dö̀ ká̱ teröl. Erë e' bule es dör e̱no diwö, e' diwö kë̀ a' tö ì kue̱pa u'rki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Eta̱ e̱no diwö shu̱a̱ ie'pa we̱lepa míyal chkè shtök, erë kë̀ iwa̱ ì ku̱ne yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Eta̱ Jehová tö iché Moisés a̱: —¿E̱'ma ko̱s a' tö ye' ttè dalöse̱we̱mirö? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","A' é̱na ia̱nú tö ye' dör Jehová, ye' tö e̱no diwö me'a̱tbak a' a̱. E' kue̱ki̱ e̱no diwö e' chkì es ye' tö a' a̱ chkè meke tai̱ë ñè ká̱ böt ekkë. E' kue̱ki̱ a' ulitane ka̱wöta̱ se̱nuk we̱shke̱ ë̀ e̱no diwö wa. Kë̀ a' patkëne bánet. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","E' kue̱ki̱ Israel aleripa e̱nuke diwö e' wa, kë̀ kaneblënerak. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israel aleripa tö chkè shteke e' kiè méka̱ maná Iwà chkà dör saruruë we̱s suiyök es. E' dör blo'bloë we̱s pan yöule bul alí wa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","E' ukuöki̱ ta̱ Moisés tö iché: —Kanè i' me' Jehová tö se' a̱: ‘Maná e' iö́ ská̱tke̱ böt ekkë ta̱ iblö́ a' aleripa a̱ kkachè a̱s ie'pa tö chkè me' ye' tö a' a̱ ká̱ sir poë e' a̱ mik a' yë'ttsa̱yö Egipto eta̱, e' sa̱ù̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Eta̱ Moisés tö iché Aarón a̱: —Tka̱' klö'ú̱ et, e' a̱ maná iö́ ská̱tke̱ böt ekkë. E' blö́ Jehová wörki̱ a̱s a' aleripa tö isa̱ù̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Eta̱ Aarón tö maná e' blé wé̱ Jehová a̱ íyi tso' blëule, e' kélkuö wösha̱ë we̱s Jehová tö iyë' Moisés a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Israel aleripa bak maná ñuk dö̀ mik ie'pa demi wé̱ pë' se̱rke ee̱ eta̱. E' dör Canaán kkömik. Ie'pa bak maná ñuk duas döka̱ dabom tkëyök (40) se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ì wa Israel aleripa tö maná ma'wè̱, e' kiè ie'pa tö gomer. E' wà dör ská̱tke̱ blublu böt ekkë. E' dör litro böt ulatök.) ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Israel aleripa ulitane e̱' yélur ká̱ sir po kiè Sin ee̱ ta̱ imía̱ ñala̱ ki̱ e̱nae̱na we̱s Jehová tö iyë' ia̱rak es. Ie'pa demirak ká̱ kiè Refidim, ee̱ ie'pa e̱' tsé̱a̱t. Erë ee̱ di' kë̀ ta̱' ie'pa a̱ yè. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","E' kue̱ki̱ ie'pa tö Moisés a̱ di' kié kësik wa. Ie'pa tö iché ie' a̱: —¡Sa' a̱ di' mú yè! Moisés iiu̱té: —¿Ì kue̱ki̱ a' tö ye' a̱ di' kié kësik wa? ¿Iö́k a' tö Jehová wöñatkeke? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ie'pa e̱rsine tai̱ë e' kue̱ki̱ ie'pa tö di' kiekerak kësik wa Moisés a̱. Ie'pa tö iché ie' a̱: —¿Iö́k be' tö sa' ena sa' ala'r ena sa' iyiwak e' yë'lur Egipto a̱ ttèwa̱ e̱rsir wa? ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Eta̱ Moisés kköché tai̱ë Jehová a̱ ta̱ ichéitö ia̱: —¿We̱s ye' ie'pa i' wè̱mi? ¡Tsir eta̱ ie'pa ye' ttéwa̱ ák wa! ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Jehová tö iiu̱té: —Be' yú ie'pa wëttsë ke̱weie. A' kue̱blupa we̱lepa tsú̱miñak. Be' shko kéli wa be' tö di' kiè Nilo e' buk, e' tsú̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Be' yú Horeb ké̱bata a̱. Ee̱ ye' be' paneke ák bërie tso' e' ska'. Mik be' tö ák e' ppé be' shko kéli wa, eta̱ di' dörattsa̱ tai̱ë ie'pa a̱ yè. Eta̱ es Moisés tö iwakanewé̱ Israel aleripa kue̱blupa wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Israel aleripa tö di' ki' kësik wa, e' kue̱ki̱ Moisés tö ká̱ e' kiè méka̱ Meribá. Ñies ie'pa tö iyë', “Sa' kë̀ wa̱ iklöne tö Jehová tö sa' ki̱mèmi.” E' kue̱ki̱ Moisés tö ká̱ e' skà kiè méka̱ Masá. Ee̱ ie'pa tö Jehová wöñatkë' e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalec aleripa debitu̱ ñippök Israel aleripa ta̱ Refidim. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moisés tö iché Josué a̱: —Be' tö se' wëpa we̱lepa shu̱shtö́ tsú̱mi ñippök Amalec aleripa ta̱. Bule ye' tso' ka̱bata wöbata ki̱ Skëköl shko kéli yaar. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Eta̱ Josué tö iwakanewé̱ we̱s Moisés tö iché ia̱ es ta̱ imíyal ñippök Amalec aleripa ta̱. E' dalewa Moisés ena Aarón ena Hur míyal ka̱bata wöbata ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mik Moisés ulà kéka̱, eta̱ Israel aleripa e̱' alöke ibolökpa ki̱. Erë mik ie' ulà éwa, eta̱ Amalec aleripa e̱' alöke ie'pa ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ie' ulà shtrinewa̱ tai̱ë, e' kue̱ki̱ ie'pa ák yulé ie' a̱ e̱' tkoie. Ñies Aarón ena Hur e'pa tö ie' ki̱mé iulà böt kökka̱ siwa̱' ki̱ a̱s kë̀ ishtrirwa̱. Es ie' ulà se̱'wé̱ ñië siwa̱' ki̱ dö̀ ka̱tuine ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Es Josué ena Israel aleripa e̱' aléka̱ Amalec aleripa ki̱ tabè wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Eta̱ Jehová tö iché Moisés a̱: —A' ñippè i' e' pakè shtö́ka̱ yëkkuö ki̱ a̱s a' wakpa kë̀ é̱na ichö̀wa ke̱kraë. Ichö́ Josué a̱ tö ye' tö Amalec aleripa ulitane e̱we̱rawa yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Eta̱ Moisés tö ák dapa'wé̱ka̱ ka̱'ie et iyiwak ña'wo̱ie Jehová dalöioie. E' kiè méka̱itö “Jehová diché wa se' e̱' aléka̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ie' tö iché: “¡Ye' ulà kéka̱ Jehová a̱ ikiök a̱s ie' tö se' ki̱mù! ¡Jehová ñippöraë Amalec aleripa ta̱ ke̱kraë!” E' kue̱ki̱ ie' tö ikiè méka̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetró dör ká̱ kiè Madián e' sacerdote ena Moisés nua̱ki. Ko̱s Skëköl tö Moisés ena Israel aleripa ki̱me', e' jche̱r ie' wa̱. Ñies ie' wa̱ ijche̱r tö we̱s Jehová tö Israel aleripa yë'lur Egipto a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Moisés tö ilaköl Séfora e' patkë'mi iyë́ ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Ie' tö ilà busi kiéwa̱ buaë ila'r böl ta̱. Séfora alà eköl kiè Guersón. Moisés tö iyë': “Ye' se̱ne' ká̱ kua̱'ki̱ ki̱ we̱s ká̱ kua̱'ki̱ wakpa es.” E' kue̱ki̱ Moisés tö ikiè méka̱ Guersón ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ilà eköl kiè Eliézer. Moisés tö iyë': “Ye' yë́ Këköl e' dë'bitu̱ ye' ki̱muk. E' tö ye' tsa̱tkë' Egipto blú ulà a̱.” E' kue̱ki̱ ie' tö ikiè méka̱ Eliézer ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Moisés úla yuéka̱ Skëköl ké̱bata o̱'mik tsi̱net. Eta̱ ee̱ inua̱ki Jetró e' de Moisés alaköl ena ila'r böl, e'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jetró tö iché Moisés a̱: —Ye' dör Jetró, be' nua̱ki, ye' debitu̱ be' pakök. Be' alaköl ena be' ala'r böl e'pa de ye' ta̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moisés e̱' yéttsa̱ ta̱ inua̱ki shke̱'wé̱itö buaë dalöiè wa wöalattsè wa. E' ukuöki̱ ta̱ idewa̱rak we̱shke̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","We̱s Jehová tö Israel aleripa tsa̱tké Egipto blú ena egiptowak ulà a̱ ñies we̱s ie' tö ie'pa kkö'né ì sulu tka ie'pa ta̱ ñala̱ wa eta̱, e' ko̱s paké Moisés tö inua̱ki a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ka̱pakè e' tö Jetró ttsë'wé̱ buaë. Jehová e̱r bua' ché tai̱ë Israel aleripa a̱. Ie' tö ie'pa tsa̱tkë'lor egiptowak ulà a̱. E' kue̱ki̱ Jetró ttsë'ne buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ie' tö iché Moisés a̱: —A̱s sulitane tö Jehová ki̱kö̀ka̱. Ie' tö be' ena be' wakpa ko̱s tsa̱tkë'lor buaë Egipto blú ena egiptowak ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ire' ye' tö isué̱ tö moki̱ Jehová dör wé̱pa kiekerakitö “skëköl” esepa ulitane tsa̱ta̱. Yi bak a' we'ikök kësik wa, e'pa ko̱s we'ikéitö sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Eta̱ Moisés nua̱ki, Jetró, e' tö iyiwak klö'wé̱wa̱ etö ña'wé̱itö Jehová a̱ idalöioie. Ñies íyi skà méitö ie' a̱ idalöioie. E' ukuöki̱ ta̱ Aarón ena Israel aleripa kue̱blupa debitu̱ chkök Moisés nua̱ki ta̱ Jehová dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Bule es ta̱ Moisés e̱' tkése̱r ikula' ki̱ Israel aleripa shu̱lök. Ie'pa e̱' dapa'wé̱ iëte̱r ie' wörki̱ ñië bla'mi dö̀ tsá̱li̱ a̱s Moisés tö ishu̱lörak. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","E' ko̱s sué̱ Moisés nua̱ki tö ta̱ ichéitö Moisés a̱: —¿Ì wamblök be' tso' ie'pa ta̱? Be' ë̀ e̱' tkése̱r ie'pa shu̱lök ta̱ ie'pa iëte̱r ñië be' panuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moisés tö iiu̱té: —E̱'ma ie'pa wák de ye' ska' ittsök tö i̱ma Skëköl tö ichè. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Mik ie'pa we̱lepa ñippöke ñita̱, eta̱ ie'pa datse̱ ye' ska' ta̱ ye' tö ie'pa ttè shu̱leke. Ñies ye' tö ie'pa patteke Skëköl ttè wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Moisés nua̱ki tö iché ia̱: —We̱s be' tö iwe̱ke e' kë̀ dör buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Be' shtrirwa̱mi. Ñies ie'pa tso' be' wörki̱ e'pa shtrirwa̱mi. Kanè e' e̱' alöka̱mi be' ki̱. Kë̀ be' a̱ iwöklönuk ekörla. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","A Moisés, ye' tö be' patteke e' ttsö́. A̱s Skëköl tö be' ki̱mù. Be' ka̱wöta̱ ttök Skëköl ta̱ ie'pa skéie. Be' ka̱wöta̱ ie'pa ñippöke e' chök Skëköl a̱ a̱s ie' tö ichö̀ be' a̱ tö we̱s ishu̱leke. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ie'pa wöbla'ú̱ Skëköl ttè wa. Ikkachö́ ie'pa a̱ we̱s ie'pa ka̱wöta̱ se̱nuk yësyësë. Ichö́ ie'pa a̱ tö ì kiane Skëköl ki̱ tö ie'pa tö iwè̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Erë be' ka̱wöta̱ a' wëpa shu̱shtök tseë be' ki̱muk ttè shu̱loie. Wé̱pa se̱rke yësyësë, Skëköl dalöieta̱' tai̱ë, kë̀ e̱' watau̱ta̱'ttsa̱ ì sulu wambloie, esepa shu̱shtö́ Israel aleripa shu̱lök be' ta̱. Ishu̱lökwakpa blatö́ i' es. Israel aleripa mil biyök (1000) e' ko̱s ki̱ ishu̱lökwakpa múka̱ eköl eköl. Mil biyök e' ko̱s blabatsö́lor cien eyök (100) cien eyök döka̱ dabop. Cien biyök e' ko̱s ki̱ ishu̱lökwakpa múka̱ eköl eköl. Cien biyök e' ko̱s blabatsö́lor dabom ske̱yök (50) dabom ske̱yök. E' ko̱s ki̱ ishu̱lökwakpa múka̱ eköl eköl. Dabom ske̱yök ko̱s e' blabatsö́lor dabom eyök dabom eyök döka̱ ske̱l. E' ko̱s ki̱ ishu̱lökwakpa múka̱ eköl eköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ie'pa tö Israel aleripa ko̱s ttè shu̱leraë ke̱kraë be' skéie. Erë ttè wé̱ kë̀ shu̱linuk ie'pa a̱ ese bitu̱raë ie'pa wa̱ be' ska' shu̱lè. Ttè wé̱ shu̱lirmi ie'pa a̱ e' ta̱ ese shu̱leke ie'pa tö. Eta̱ es be' ki̱ kanè e' öshtömi. Ie'pa tö be' ki̱mèmi kanè e' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Skëköl tö be' ké iwakanéu̱k, ñies be' tö iwakanewé̱ es, e' ta̱ be' a̱ ikatatkërmi. Ñies Israel aleripa ko̱s mi'mine iu a̱ ttsë'ne buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Eta̱ Moisés tö inua̱ki ttö̀ iu̱té. Iwakanewé̱itö we̱s inua̱ki tö iché ia̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ie' tö Israel aleripa shu̱a̱ wëpa didir ese shu̱shté. E'pa méka̱itö Israel aleripa shu̱lökwakpaie. We̱lepa meneka̱ mil biyök e' ko̱s ki̱ ishu̱lökwakpaie. We̱lepa skà meneka̱ cien biyök e' ko̱s ki̱ ishu̱lökwakpaie. We̱lepa skà meneka̱ dabom ske̱yök e' ko̱s ki̱ ishu̱lökwakpaie. We̱lepa meneka̱ dabom eyök e' ko̱s ki̱ ishu̱lökwakpaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ie'pa tö Israel aleripa ttè shu̱leke ke̱kraë. Ttè wé̱ darërëë, ese mí ie'pa wa̱ Moisés a̱ shu̱lè. Eta̱ ttè wé̱ tottola, ese shu̱leke ie'pa tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","E' ukuöki̱ ta̱ Moisés nua̱ki e̱' chéa̱t ie' a̱ ta̱ imía̱ne ika̱ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","E' ukuöki̱ ta̱ Israel aleripa e̱' yélur Refidim a̱ demirak Sinaí. Ie'pa e̱' yë'lur Egipto, e' ki̱ si' de böt kí̱ ká̱ et. Sinaí dör ká̱ sir poë. Ee̱ ie'pa e̱' tsé̱a̱t Sinaí ké̱bata o̱'mik tsi̱net. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Eta̱ Moisés mía̱ ka̱bata a̱ ttök Skëköl ta̱. Ee̱ Jehová tö ikié ta̱ ichéitö ia̱: —Ttè cheke ye' tö be' a̱ e' chö́ne Israel aleripa a̱. E'pa dör Jacob aleripa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Ichö́ ie'pa a̱: ‘Ye' tö egiptowak we'ik e' su̱' a' tö. Ñies a' wa̱ ijche̱r tö we̱s ye' wa̱ a' dë'bitu̱ buaë í̱e̱ ye' wörki̱ we̱s pu̱ wa̱ ilala mi' ipik ki̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ká̱ ulitane wakpa dör ye' icha. Erë ye' ttö̀ iu̱té a' tö se̱raa̱, ñies ttè mekesö ñì a̱ e' wà iu̱té a' tö buaë, e' ta̱ ká̱ ulitane wakpa shu̱a̱ a' döraë ye' icha chö́kie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","A' döraë ye' sacerdotepaie. A' döraë batse'r ye' a̱.’ Ttè i' ko̱s chö́ Israel aleripa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Eta̱ Moisés bite̱a̱ne, e' tö Israel aleripa kue̱blupa ko̱s dapa'wé̱. Ì ché Jehová tö ie' a̱ e' ko̱s chéneitö ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ie'pa ulitane tö iiu̱té ñikkëë: —Ì ko̱s ché Jehová tö e' wà iu̱teraë sa' tö. Eta̱ Moisés mía̱ne ttè e' chökne Jehová a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Eta̱ Jehová tö iché ia̱: —Ye' ttö̀ ttsö́. Mochka tërdawa̱ ka̱bata ki̱ tai̱ë e' shu̱a̱ ye' datse̱ ttök be' ta̱ a̱s Israel aleripa ulitane tö ye' ttöke be' ta̱ e' ttsö̀. Es ie'pa tö be' ttè klö'we̱raë ke̱kraë. Eta̱ i̱ma Israel aleripa tö iiu̱té e' chéne Moisés tö Jehová a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Jehová tö iché ia̱: —Be' yú Israel aleripa batse'u̱k i̱'ñe ena bule. Ñies ichö́ ia̱rak: ‘a' datsi' skuö́lor.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ye' dör Jehová, e' datse̱ böiki Sinaí ké̱bata a̱ ie'pa ulitane wörki̱, e' kue̱ki̱ ie'pa batse'ú̱ a̱s ie'pa tso' batse'r böiki yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ka̱bata wakyuö́ shkit a̱s kë̀ yi mi'tkö e' wi̱she̱t. Ichö́ ia̱rak: ‘A' kë̀ a̱ ka̱wö ta̱' shkökwa̱ iwakyöne e' wi̱she̱t. Ñies a' kë̀ a̱ ka̱wö ta̱' shkökwa̱ tsi̱net ipamik. Wé̱pa tkawa̱ e' wi̱she̱t esepa duörawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Yi míwa̱ ee̱ ese kë̀ ka̱wö ta̱' kè ulà wa. Ese ka̱wöta̱ ttèwa̱ ák wa ö sulë̀ wa. Kë̀ a' tkinuk tö se' idir ö iyiwak idir, a' ka̱wöta̱ ittökwa̱. Mik a' tö duk blar ttsé e' ë̀ ta̱ a' dömiwa̱ tsi̱net ka̱bata o̱'mik.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Eta̱ Moisés bite̱a̱ne tö Israel aleripa batse'wé̱ ta̱ ie'pa ulitane datsi' skuélor. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Moisés tö iché ia̱: —A' ulitane e̱' kkö'nú batse'ne böiki yöki̱. E' dalewa kë̀ a' se̱nukka̱ alakölpa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Böiki es bla'mi ta̱ ka̱bata a̱ ká̱ wöñane alá blane tai̱ë. Mò tai̱ë dettsa̱ ka̱bata e' ki̱. Ie'pa tö ittsé tö duk blane tai̱ë, e' tö ie'pa suawé̱ tai̱ë painéka̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Eta̱ Moisés tö Israel aleripa tso'rak iwákpa u a̱ e'pa yélur tsé̱mi Skëköl wörki̱. Ie'pa e̱' wöklö'wé̱rak ka̱bata kuli' a̱ tsi̱net. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Jehová dettsa̱ Sinaí ké̱bata ki̱ bö' shu̱a̱, e' kue̱ki̱ ka̱bata e' mía̱ shkle̱ ë̀me. Shkle̱ e' wër we̱s të shkle̱ butrö̀ es. Ka̱bata ko̱s wöti̱rke darërëë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Duk kí̱ blarke tai̱ë shu̱te̱. Moisés ttöke ta̱ Skëköl tö ie' iu̱teke alá blar ttsëë. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Jehová dettsa̱ ka̱bata ka̱kke̱ë, e' wöbata ki̱ ta̱ Moisés kiéka̱itö ee̱. Moisés tkaka̱ ee̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ta̱ Jehová tö iché ia̱: —Be' e̱' ö́wane ta̱ ichö́ ie'pa a̱: ‘Kë̀ a' tkökbitu̱ wé̱ iwakyöule e' io̱she̱t ye' weblök dö' ie'pa duö̀lur tai̱ë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ñies wëpa kaneblöke ye' a̱ sacerdotepaie esepa ka̱wöta̱ e̱' batse'u̱k buaë dö' ñies ye' tö ie'pa ttèlurmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Eta̱ Moisés tö Jehová iu̱té: —Be' tö sa' ké iwakyuök a̱s kë̀ ie'pa döwa̱ ka̱bata a̱ tsi̱net. E' kue̱ki̱ kë̀ ie'pa bitú̱pa ka̱bata i' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Eta̱ Jehová tö iché Moisés a̱: —Be' yúne ta̱ Aarón tsú̱bitu̱ e̱' ta̱. Erë a' sacerdotepa ena Israel aleripa male̱pa e'pa kë̀ ka̱wö ta̱' shkökbitu̱ wé̱ ye' tso' ee̱ dö' ye' tö ie'pa ttèlur. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Eta̱ Moisés bite̱a̱ne Israel aleripa ska' ta̱ ì ché Jehová tö ie' a̱ e' chéne ie' tö ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Skëköl tté ta̱ ichéitö i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ye' dör Jehová. Ye' dör a' Këköl. Ye' tö a' yë'lur Egipto wé̱ a' bak weinuk sia̱rë kanè wa ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Kë̀ a' ka̱wö ta̱' këkölpa skà dalöiök. Ye' ë̀ dalöiö́ a' Këkölie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Kë̀ a' ka̱wö ta̱' ì diököl yuök dalöiè yës. Ì ko̱s tso' ká̱ jaì a̱ ena ká̱ i' a̱ ena dayë a̱ ena íyök diki̱a̱, e' ko̱s diököl kë̀ yuar a' tö dalöiè. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","6","Ye' dör Jehová. Ye' dör a' Këköl. A' tö këkölpa kua̱'ki̱ dalöié, e' kë̀ dalë'ttsënuk ye' a̱. Wé̱pa ye' suè̱ suluë esepa we'ikeraëyö, ñies ileripa dö̀ inukököpaë e'pa we'ikeraëyö. Erë wé̱pa tö ye' dalëritseke ena ye' ttè dalöiëno e' iu̱teke, esepa ena iëtkuöpa döka̱ mil e' dalëritseraëyö. E' kue̱ki̱ kë̀ a' e̱' tulökwa̱ kuchëwö ki̱ íyi ñekkë ko̱s wörki̱ idalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Ye' dör Jehová. Ye' dör a' Këköl. Ye' kiè kë̀ a̱ritsar ëanas íyi sulu wambloie. Yi tö e' wamblé ese wák we'ikeraëyö. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“E̱no diwö e' blö́ Ye' ë̀ dalöioie. E' kë̀ chökwa a' é̱na. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Semana bit e' a̱ ka̱wö tso' kul. Ka̱wö teröl e' dör a' wákpa a̱ kanebloie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Erë ka̱wö teröl e' bule es e' dör e̱no diwö ye' dalöioie. E' ké̱wö a̱ a' kë̀ ka̱wö ta̱' kaneblök. Ñies a' ala'r ena a' kanè mésopa ena a' iyiwak ena ká̱ kua̱'ki̱ wakpa se̱rke a' ska', e'pa ko̱s kë̀ ka̱wö ta̱' kaneblök e' diwö a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ye' dör Jehová. Ye' tö ká̱ i' ena ká̱ jaì ena dayë ena íyi ulitane e' ko̱s yö' ká̱ teröl shu̱a̱. E' bule es ta̱ ye' e̱ni', e' kue̱ki̱ ka̱wö e' batseo̱'yö me'a̱työ a' a̱ e̱no diwöie ye' dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“A' yë́ ena a' mì e'pa dalöiö́ a̱s a' se̱r ká̱ tai̱ë ká̱ mekeyö a' a̱ e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Kë̀ a' ka̱wö ta̱' s'ttökwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Kë̀ a' ka̱wö ta̱' s'se̱newa̱bak dalöse̱u̱kwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Kë̀ a' ka̱wö ta̱' akblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Kë̀ a' ka̱wö ta̱' s'kkatök ka̱chè wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Kë̀ a' ka̱wö ta̱' o̱'ka u kkechök. Ñies ilaköl ena ikanè mésopa, alakölpa ö wëpa, ena iiyiwak ko̱s ena ì ko̱s tso' iwa̱, ese kë̀ kkechar.” ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Mik Israel aleripa ulitane tö alá blarke e' ttsé ena iwöñarke e' sué̱ ñies duk blarke tai̱ë e' ttsé ena shkle̱ butrökeka̱ tai̱ë ka̱bata a̱ e' sué̱, eta̱ e' yöki̱ ie'pa suane tai̱ë painéka̱rak tai̱ë. Ie'pa iëte̱r isa̱u̱k ka̱mië. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","E' kue̱ki̱ ie'pa tö iché Moisés a̱: —Be' ttö́ sa' ta̱, eta̱ sa' tö be' ttö̀ dalöieraë. Erë kë̀ sa' ki̱ ikiane tö Skëköl ttö̀ sa' ta̱ dö' sa' duö̀lur. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moisés tö iiu̱té: —Kë̀ a' suanuk. Skëköl dettsa̱ a' ma'u̱k isuo̱ie tö moki̱ a' tö ie' dalöieke. Ie' ki̱ ikiane tö a' tö ie' ttö̀ dalöiè a̱s kë̀ a' tö ì sulu wamblö̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ie'pa a̱te̱ isa̱u̱k ka̱mië. Moisés ë̀ mía̱ tsi̱net mò tai̱ë wé̱ Skëköl tso' ee̱.");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Etökicha ta̱ Jehová tö iché itteköl kiè Jonás dör Amitai alà, e' a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Be' yú ká̱ kibi kiè Nínive ee̱, ta̱ ichö́ ká̱ e' wakpa a̱ we̱s a' e̱' wamblö̀ e' dör suluë ye' wöa̱, e' kue̱ki̱ ye' tö a' e̱we̱rawa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Erë ie' kë̀ é̱na Jehová ttö̀ iu̱tak. E' kue̱ki̱ ie' tkashkar iyöki̱. Ie' mía̱ dayë kkömik ká̱ kiè Jope wé̱ kanò irirke ee̱. Ee̱ ie' tö kanò kué̱ etö mitke ká̱ kiè Tarsis e' patué̱itö shkomi ta̱ ie' e̱' iéka̱ iki̱ ta̱ imía̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Erë Jehová tö sërkë patké ie'pa ki̱ tai̱ë darërëë. E' tö kanò u̱yé tai̱ë dö̀ wësua itskirwa̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Eta̱ ko̱s ie'pa tso' kanò a̱, e'pa suane tai̱ë. Ie'pa eköl eköl tö ikieke a̱neule iwák këköl a̱: “¡Sa' tsa̱tkö́, sa' tsa̱tkö́!” Eta̱ dalì ko̱s tuléttsa̱mi dayë ki̱ a̱s kë̀ kanò katsi̱rwa̱. Erë Jonás e̱' a'wa kanò shu̱a̱ dalì bló wé a̱, ee̱ ie' kapötër tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Eta̱ kanò ñakökwak mía̱ dö̀ wé̱ ie' kapötër ee̱ ta̱ iché ia̱: —¿Iö́k be' kapötër? ¡Be' e̱' kö́ka̱! Be' këköl a̱ ikiö́ a̱s ie' tö se' tsa̱tkö̀. Isalema ie' se' suè̱mi e̱r sia̱rë wa ta̱ se' tsa̱tkèmiitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","E' dalewa kanò wakpa male̱pa tö iché ñì a̱: —Mishka itötkök isuo̱ie yi ia̱ne iwiie e' kue̱ki̱ se' weirke i' es. Eta̱ iwëne tö Jonás idir. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","E' kue̱ki̱ ie'pa iché ie' a̱: —Ichö́ sa' a̱, ¿ì kue̱ki̱ ì sulu i' tköke se' ta̱? ¿Iö́k be' e̱' iébitu̱ kanò i' a̱? ¿Wé̱ be' datse̱? ¿Yi ditséwö be' dör? ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Ie' iiu̱té: —Ye' dör hebreowak. Jehová dör Skëköl tso' ká̱ jaì a̱ e' dalöiökwak ye' dör. Ie' tö dayë ena ká̱ i' yö'a̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_10","033_1_10","JON","1","10","11","Ie' tö ie'pa a̱ ipaké tö ie' tso' tkökshkar Jehová yöki̱. Mik e' ttsé ie'pa tö ñies isué̱rakitö tö dayë kí̱ ulune tai̱ë, eta̱ ie'pa suane tai̱ë shu̱te̱. Ie'pa tö ie' a̱ ichaké: —¿Ì wè̱mi sa' tö be' ta̱ a̱s sërkë wöklörwa̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Ie' tö iiu̱té: —Ye' wa̱ ijche̱r buaë tö ye' kue̱ki̱ sërkë i' bitsi̱neka̱ tai̱ë a' ki̱. E' kue̱ki̱ ye' u̱yö́mi dayë a̱ eta̱ sërkë wöklördawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Erë kanò wákpa tö kanò iklémi darërëë a̱s irirka̱. Erë kë̀ ie'pa diché dë'ka̱, dayë kí̱ ulune tai̱ë e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Eta̱ ie'pa tö Jehová a̱ ikié i' es: “A Jehová, kë̀ sa' maktsa̱ duökwa̱ wëm i' kue̱ki̱. I' u̱k be' tso' sa' ta̱, e' we̱kebö we̱s be' ki̱ ikiane es. E' kue̱ki̱ wëm i' kë̀ ki̱ ì nuí̱ ta̱', e' ta̱ sa' tö ie' u̱yekemi dayë a̱ e' nuí̱ kë̀ marka̱ sa' ki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","E' ukuöki̱ ta̱ ie'pa tö Jonás u̱yémi dayë a̱, eta̱ sërkë wöklönewa̱ ta̱ dayë mía̱ne a̱lmië. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Mik kanò wákpa tö e' sué̱, eta̱ ie'pa suane tai̱ë Jehová yöki̱ ta̱ idalöiérakitö tai̱ë. E' ukuöki̱ ta̱ ie'pa tö iyiwak jché ña'wé̱ mè Skëköl a̱ idalöioie, ñies ie'pa tö ttè mé ie' a̱ tö sa' tö be' dalöieraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Eta̱ Jehová tö nima bërie shu̱te̱ patké etö Jonás mulu̱kwa̱. Eta̱ nima e' tö imulé̱wa̱ ta̱ ee̱ nima shu̱a̱ ie' se̱né döka̱ ká̱ mañat ñië nañeë. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Eta̱ Jonás tté Jehová dör ie' Këköl e' ta̱ nima shu̱a̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","ta̱ ichéitö ia̱ i' es: “A Jehová, ye' e̱riarke sia̱rë, e' shu̱a̱ ye' tö be' a̱ ikié tö ye' tsa̱tkö́, eta̱ be' tö ye' iu̱té. Ye' tso'tke ká̱ dià ka̱ska' s'duulewa̱ ké̱ a̱, ee̱ ye' be' a̱ ikié tö ye' ki̱mú, eta̱ ye' ttö̀ ttsébö. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Be' ye' u̱yémi dayë a̱ i̱ski̱ë dayë diki̱a̱, ye' ki̱tëulewa̱ dayë wa̱. Dayë u̱rke tai̱ë e' patkébö, e' tka ye' ki̱kke̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ye' ittsé tö ye' kë̀ ku̱'ia̱ be' wörki̱. Ye' ibikeitsé tö ye' kë̀ dë'ia̱ne be' wé buaë e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Dayë tai̱ë, e' shu̱a̱ ye' a̱nemi. Ye' ki̱kke̱, ye' pamik, ye' diki̱a̱, e' dör dayë ë̀me. Dayë a̱ itö'könu tso', e' mali̱tsé̱ka̱ ye' wökir mik tai̱ë dayë shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ye' a̱nemi dayë a̱ dö̀ i̱ski̱ë, dö̀ wé̱ ka̱bata bitu̱keka̱ ee̱. Ye' ittsé tö ye' wötënewa̱ da'a̱ ká̱ dià ka̱ska'. Erë, a Jehová, be' dör ye' Këköl, be' dör ye' yéttsa̱ne s'duö̀wa̱ ulà a̱ deka̱ne ttsë'ka. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","A Jehová, mik ye' ittsé tö ye' duökewa̱tke, eta̱ ye' be' a̱ ikié tö ye' tsa̱tkö́, eta̱ ì kiéyö, e' ttsébö be' wé buaë e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Wé̱pa tö íyi diököl dalöieke be' skéie, e'pa kë̀ tö be' dalöieku̱'ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Erë ye' tö wëstela cheraë be' a̱ ke̱kraë, iyiwak jcheraë ña'we̱raëyö be' a̱ be' dalöioie. Ye' ttè mé be' a̱, e' wawe̱raëyö. ¡A Jehová, be' ë̀ a̱ sa' tsa̱tkërmi!” ");
INSERT INTO bzdNTpo_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","E' ukuöki̱ ta̱ Jehová tö nima patké Jonás tuöktsa̱ ká̱ sí ki̱, ta̱ ituéttsa̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Eta̱ Jehová tö iskà chéne Jonás a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Be' yú ká̱ kibi kiè Nínive ee̱ ta̱ ì chekeyö be' a̱, e' chö́ ká̱ e' wakpa a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Eta̱ ie' tö Jehová ttö̀ iu̱té. Ie' mía̱ Nínive. E' dör ká̱ bërie. Shkotkö ká̱ e' shu̱a̱, e' dör ká̱ mañat wa'ñe. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Jonás shké ká̱ e' shu̱a̱ ká̱ et wa'ñe ta̱ ie' tö icherami ká̱ e' wakpa a̱ a̱neule: “Ká̱ i' ki̱ ká̱ de dabom tkëyök (40), eta̱ a' e̱rdawa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Eta̱ Nínive wakpa ko̱s e̱rblé Skëköl mik. E' kue̱ki̱ ie'pa ko̱s, ësepala ena dalöiërta̱', e'pa ko̱s tö iché: “S'ka̱wöta̱ batsök, ñies s'ka̱wöta̱ datsi' a̱ja̱ë ese iök iwà kkachoie tö se' e̱r mane'wé̱.” Eta̱ es ie'pa tö iwé̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Mik ttè e' ttsé Nínive blú tö, eta̱ ie' e̱' kéka̱ ikulé ki̱, ta̱ idatsi' bua'buaë iëtkër iwa̱, e' yéttsa̱ skéie datsi' a̱ja̱ë iéka̱itö ta̱ ie' e̱' tkése̱r i̱ski̱ mulu̱chka ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH3_7","033_3_7","JON","3","7","9","Eta̱ ie' tö ttè patké ká̱ e' ulitane wakpa a̱. Ttè e' tö ichè i' es: “A' ulitane kë̀ kàne chkök di'yök yës. Ñies kë̀ a' kàne a' baka ena a' obeja tiök. A' ulitane ka̱wöta̱ datsi' a̱ja̱ë iökka̱. A' kköchö́ Skëköl a̱ a' diché ko̱s wa a̱s a' e̱' wamblö̀ suluë ese ko̱s nuí̱ olo'yö̀itö a' ki̱. Ñies a' e̱' wamblö̀ suluë, ese ko̱s olo'yö́. Isalema ie' e̱r mane'u̱mine, eta̱ ie' e̱r buarmine se' ki̱, eta̱ ie' kë̀ tö se' e̱we̱pawa. Ttè i' dör ye' dör a' blú e' ttè ena a' wökirpa ttè, e' kue̱ki̱ a' ulitane ka̱wöta̱ idalöiök.” ");
INSERT INTO bzdNTpo_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Eta̱ ie'pa tö ttè e' iu̱té buaë. Ie'pa e̱' wamblö̀ suluë ese ko̱s olo'yérakitö. Mik e' sué̱ Skëköl tö, eta̱ ie' ibikeitséne kë̀ yö ie'pa we'ikepa we̱s ye' ibikeits es. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Erë e' kë̀ dör bua' Jonás a̱ ta̱ ie' uluneka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Ie' iché Jehová a̱: —A Jehová, be' isué̱. Mik ye' tkëria̱ ye' ka̱ska', eta̱ ye' iyë' tö be' e̱r buaë chöraë Nínive wakpa a̱. Ye' wa̱ ijche̱r tö be' dör es, e' kue̱ki̱ ye' bakshkar Tarsis. Ye' wa̱ ijche̱r tö be' kë̀ ulurta̱'ka̱ bet. Be' e̱r tottoë. Be' sa' suè̱ e̱r sia̱rë wa. Mik sa' tö ì sulu wamblé ta̱ sa' e̱r mane'wé̱, e' ta̱ bet e' nuí̱ olo'yé be' tö sa' ki̱, kë̀ sa' we'ikè we̱s be' sa' pau̱ñé es. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","A Jehová, e' kue̱ki̱ ye' be' a̱ ichè ye' ttö́wa̱, e' dör bua'ie ye' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Erë Jehová tö ie' a̱ ichaké: —¿I̱ma be' ibikeitsè tö be' wa̱ ka̱wö ta̱' ulunukka̱ se̱ es? ");
INSERT INTO bzdNTpo_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Eta̱ Jonás e̱' yéttsa̱ Nínive mía̱ diwö tskirke e' kke̱ ta̱ ee̱ úla yuéka̱itö e̱' blóie dìba yöki̱. Ee̱ ie' e̱' tkése̱r ì tkö̀mi Nínive wakpa ta̱ e' wà panuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Eta̱ Skëköl Jehová tö kalkua tskéka̱ elka tala'wé̱ka̱itö Jonás tsa̱ka̱ a̱s ikí̱ ttsë'r buaë. E' tö ie' ttsë'wé̱ buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Erë bule es bla'mi ká̱ ñine eta̱ Skëköl tö í̱ patké kalkua katökwa ta̱ isinewa̱ duowa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Mik diwö deka̱, eta̱ ie' tö siwa̱' darërëë ba'baë e' patké diwö tskirke e' kke̱ Jonás ki̱. Dìba a̱ne darërëë Jonás wökir ki̱, ta̱ ie' tö ittsé tö ie' siwa̱'a̱rkewa̱. Ibikeitséitö “¡Ye' mú duö̀wa̱!” Ie' iché, “Ye' duowa̱, e' dör bua'ie ye' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Erë Skëköl tö iché ie' a̱: —¿I̱ma be' ibikeitsè tö be' wa̱ ka̱wö ta̱' ulunukka̱ kalkua sinewa̱ e' kue̱ki̱? Ie' iiu̱té: —Tö́, ye' wa̱ ka̱wö ta̱'. ¡Ye' ulune tai̱ë mik ye' duowa̱ eta̱ e' olone! ");
INSERT INTO bzdNTpo_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Eta̱ Jehová tö iché ie' a̱: —Kal kuá kë̀ tkëne be' wa̱, kë̀ talane kë̀ kaneo̱ne be' wa̱. E' tskine talane ká̱ et nañewe ë̀, bule es nañewe ta̱ iduowa̱, e' dalëne be' é̱na. ");
INSERT INTO bzdNTpo_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Eta̱ ¿we̱s ye' kë̀ é̱na Nínive wakpa dalënuk? Ie'pa dör tai̱ë, ie'pa ala'rla tso' tai̱ë döka̱ 120.000 kë̀ wa̱ ijche̱r ì dör buaë, ì dör suluë. Ñies ie'pa iyiwak tso' tai̱ë.");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo dör se' blú bak kiè David e' aleri, David dör Abraham aleri. Jesucristo yë́pa bak ko̱s e'pa wëpa kiè dör i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham alà dör Isaac, e' alà dör Jacob, e' ala'r dör Judá ena iëlpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá ala'r dör Fares ena Zérah, e'pa mì dör Tamar. Fares alà dör Hesrón, e' alà dör Aram. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","E' alà dör Aminadab, e' alà dör Nahasón, e' alà dör Salmón. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","E' alà dör Booz, e' mì dör Rahab. Booz alà dör Obed, e' mì dör Rut. Obed alà dör Jesé, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","E' alà dör se' blú bak David e'. Se' blú bak David, e' alà dör Salomón, e' mì bak Urías ta̱ ke̱we. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón alà dör Roboam, e' alà dör Abías, e' alà dör Asá. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","E' alà dör Josafat, e' alà dör Joram, e' alà dör Ozías. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","E' alà dör Jotam, e' alà dör Acaz, e' alà dör Ezequías. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","E' alà dör Manasés, e' alà dör Amón, e' alà dör Josías. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","E' ala'r dör Jeconías ena iëlpa. E' ké̱wö ska' ta̱ Israel aleripa klö'wé̱lur Babilonia wakpa tö ta̱ itsé̱mirakitö Babilonia. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Israel aleripa aneyalne Babilonia, e' ukuöki̱ ta̱ Jeconías alà kiè Salatiel e' ku̱ne. Ie' alà dör Zorobabel, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","E' alà dör Abihud, e' alà dör Eliaquim, E' alà dör Azor. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","E' alà dör Sadoc, e' alà dör Aquim, e' alà dör Eliud. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","E' alà dör Eleazar, e' alà dör Matán, e' alà dör Jacob. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","E' alà dör José, e' dör María wëm. María dör Jesús mì. Jesús dör wé̱ pairine'bitu̱ idi' wa s'blúie e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Es Abraham ké̱wö ska' döka̱ David ku̱ne', eta̱ Jesús ditséwö alöne döka̱ dabom eyök kí̱ tkëtökicha (14). Ñies David ké̱wö ska' döka̱ Israel aleripa minetse̱r Babilonia, eta̱ Jesús ditséwö alöne döka̱ dabom eyök kí̱ tkëtökicha (14). Ñies Israel aleripa minetse̱r döka̱ wé̱ pairine'bitu̱ idi' wa s'blúie e' de, eta̱ Jesús ditséwö alöne döka̱ dabom eyök kí̱ tkëtökicha (14). ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","I' dör Jesucristo ku̱ne' e' pakè: Ie' mì kiè María. E' bakia̱ busi ka̱m se̱r wëm ta̱, erë ittè me'bak se̱nukwa̱ wëm kiè José e' ta̱. Ka̱m ie'pa se̱rwa̱ ñita̱, ka̱m ie'pa ñì kö̀wa̱, eta̱ María bukluneka̱ Wiköl Batse'r diché wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José dör wëm buaë yësyësë, e' kue̱ki̱ ie' kë̀ é̱na María jaëwa̱kka̱ sulitane wörki̱. E' kue̱ki̱ ie' tö ibikeitsé: “Sú̱yö imèa̱t bë̀rë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ie' tso'ia̱ ibikeitsök ta̱ ikapowa̱ ta̱ ikabsué̱ tö Skëköl biyöchökwak de eköl e' tö ie' a̱ iché: “A José, David aleri, María bukluneka̱ e' dör Wiköl Batse'r diché wa. E' kue̱ki̱ kë̀ be' suanuk se̱nukwa̱ ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ie' alà ku̱rdaë eköl wák wëm. Ikiè múka̱bö Jesús Ie' tö iwakpa tsa̱tkeraë se̱ne sulu nuí̱ yöki̱, e' kue̱ki̱ ikiè múka̱ es.” Es Skëköl biyöchökwak tté José ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","E' ko̱s tka es a̱s ì yë'a̱tbak Skëköl tö itteköl wa e' wà tkö̀, e' tö ichè: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Busi eköl kë̀ wa̱ wëm kaule e' buklurdaka̱, e' alà ku̱rdaë wák wëm, ikirdaë Emanuel.” (s'kiè e' wà kiane chè: “Skëköl tso' se' ta̱”). ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mik José ti̱'neka̱ne, eta̱ ie' tö iwé̱ we̱s Skëköl biyöchökwak tö ie' a̱ iché es. Ie' ulabatséwa̱ María ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Erë alà ka̱m ku̱r, e' yöki̱ ie'pa kë̀ ñì kànewa̱. Mik alà ku̱ne, eta̱ José tö ikiè méka̱ Jesús. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús ku̱ne' ká̱ kiè Belén a̱te̱ Judea ee̱. E' ké̱wö ska' ta̱ wëm eköl kiè Herodes e' dör ká̱ e' blú. Eta̱ wëpa we̱lepa datse̱ ká̱ ka̱mië a̱te̱ diwö tskirke e' kke̱, e'pa de Jerusalén. Ie'pa dör íyi tötkök bëkwö wa esepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ie'pa tö ichaké: —¿Wé̱ alala ku̱ne judiowak blúie e'? Sa' tö ibëkwö su̱' sa' ka̱ska', e' kue̱ki̱ sa' de í̱e̱rö idalöiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mik Herodes tö ttè e' ttsé, eta̱ e' tö ie' ena Jerusalén wakpa ko̱s tsiriwé̱ka̱rak tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","E' kue̱ki̱ ie' tö sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa kiéttsa̱ se̱raa̱ ta̱ ichaké ie'pa a̱: —¿I̱ma a' ichè? Wé̱ pairine'bitu̱ idi' wa s'blúie, ¿wé̱ e' ku̱rmi? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ie'pa tö iu̱térak: —Ie' ku̱rdaë Belén a̱te̱ Judea ee̱. Skëköl tteköl tö ikita̱t i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Skëköl tö ichè: Belén a̱te̱ Judea, e' wakpa a̱ ye' ichè tö a' shu̱a̱ blu' kardaka̱ eköl, e' tö ye' icha dör Israel aleripa e'pa wëttse̱raë. E' kue̱ki̱ a' ká̱ dör ká̱ bua'ie we̱s Judea ká̱ bua'ie male̱pa tso' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mik Herodes tö ttè e' ttsé, eta̱ ie' tö wëpa tö íyi tötkeke bëkwö wa ñe'pa kié akir ijche̱nowa̱ tö mik ie'pa tö bëkwö e' su̱'mi, ko̱s e' ki̱ ká̱ de. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ie' tö ie'pa a̱ iché: —A' yú Belén. Alala e' yulö́ bua'ie. Mik a' tö ikué̱, eta̱ ibiyö́ chö́ ye' a̱ a̱s ñies ye' mi' idalöiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Mik blu' tö ttè e' ché o̱ne, eta̱ ie'pa míyal. Eta̱ bëkwö su̱' ie'pa tö ika̱ska', e' sué̱ne ie'pa tö ñala̱ wa. E' tö ie'pa ttsë'wé̱ne buaë shu̱te̱. Wé̱ bëkwö mirwa̱ e' wa ie'pa mi'ke dö̀ wé̱ bëkwö e̱' wöklö'wé̱wa̱ ee̱. Bëkwö e̱' wöklö'wé̱wa̱ wé̱ alala e' tso' e' u tsa̱ka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","E' ukuöki̱ ta̱ ie'pa dewa̱ u a̱ ta̱ ie'pa tö alà ena imì María kué̱. Ie'pa e̱' tuléwa̱ kuchë ki̱ ta̱ idalöiérakitö. Kalkuöla dérak iwa̱ e' kköyéttsa̱rakitö ta̱ orochka ena ì masmas ña'wè̱ ena mirra, ese mérakitö alà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","E' ukuöki̱ ta̱ ie'pa a̱ iyëne kabsuè̱ a̱ tö ie'pa kë̀ minukne Herodes ska'. E' kue̱ki̱ ie'pa míyalne iká̱ ki̱ ñala̱ kua̱'ki̱ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wëpa tö íyi tötkeke bëkwö wa e'pa ponemine, e' ukuöki̱ ta̱ José kabsué̱ tö Skëköl biyöchökwak eköl tö ie' a̱ iché: “Be' e̱' kö́ka̱, María ena ilà klö'ú̱ ta̱ be' tkö́shkar Egipto. Blu' Herodes tö alala se̱ yuleraë ttèwa̱, e' kue̱ki̱ be' e̱' tsú̱a̱t se̱nuk ee̱ dö̀ mik ye' tö be' a̱ iché eta̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Eta̱ ie' ti̱'neka̱ e̱' kéka̱ ta̱ alà ena María klö'wé̱itö ta̱ e' nañewe imíyal Egipto. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ee̱ ie'pa se̱né dö̀ mik Herodes blënewa̱ ekkë. E' tka es a̱s itkö̀ we̱s Skëköl tö iyë' itteköl wa es. Ie' tö iyë': “Ye' alà tso' Egipto, e' kiéne ye' tö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mik Herodes wa̱ ijche̱newa̱ tö wëpa tö íyi tötkeke bëkwö wa, e'pa kë̀ wa̱ ie' ttö̀ dalöiëne', eta̱ e' tö ie' uluwé̱ka̱ tai̱ë. Belén ena ká̱ tso' ipamik e' a̱ ala'rla wëpa ku̱rke ko̱s, e'pa ttökulur patké ie' tö se̱raa̱ ka̱m ki̱ duas dö̀ bök e' yöki̱. Wëpa tö íyi tötkeke bëkwö wa e'pa tö bëkwö su̱' ko̱s e' ki̱ ká̱ de, e' yë' ie'pa tö Herodes a̱. E' wa ie' tö iké̱wö yë'ttsa̱ tö duas döketke bök e' ki̱. E' kue̱ki̱ ie' tö ala'rla wëpa ku̱rke e' ké̱wö ulatök, esepa ko̱s ttökulur patké. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Es ì yë' Skëköl tteköl kiè Jeremías e' tö, e' wà tka. Ie' tö iyë': ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ká̱ kiè Ramá ee̱ ittsë̀ne tö tai̱ë ie'pa i̱u̱ke a̱neule kköchöke sia̱rë. Ee̱ alakölpa dör Raquel aleripa e'pa i̱u̱ke ila'rla i̱e̱itsök. Ila'rla ko̱s ttélur, e' kue̱ki̱ ie'pa kë̀ e̱r pablërta̱'.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Blu' Herodes blënewa̱, e' ukuöki̱ ta̱ José tso' Egipto, e' kabsué̱ tö Skëköl biyöchökwak eköl tö ie' a̱ iché: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Wé̱pa é̱na alà ttakwa̱, e'pa blërulunetke. E' kue̱ki̱ be' e̱' kö́ka̱ ta̱ María ena ilà klö'ú̱ ta̱ a' yúshkane Israel.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Eta̱ José e̱' kéka̱ ta̱ María ena ilà klö'wé̱itö ta̱ ie'pa bite̱yalne Israel. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Erë mik ie' wa̱ ijche̱newa̱ tö Herodes alà kiè Arquelao e' tso'ne Judea blúie iyë́ skéie, eta̱ ie' suane se̱nuk ee̱. Eta̱ ie' kabsué̱ tö Skëköl tö ie' a̱ iché: “A' yúshkane Galilea.” E' kue̱ki̱ ie'pa míyalne Galilea. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mik ie'pa de Galilea, eta̱ ie'pa míyal se̱nuk ká̱ kiè Nazaret ee̱. E' tka es a̱s ì yë' Skëköl ttekölpa tö e' wà tkö̀ wé̱ ichéitö: “Ie' kirdaë Nazaret wak.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","E' ké̱wö ska' ta̱ Juan S'wöskuökwak de Skëköl ttè pakök ká̱ sir poë wé̱ kë̀ yi se̱rku̱' a̱te̱ Judea ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Juan tö ie'pa a̱ icheke: “Ì blúie Skëköl tso' e' ké̱wö dewa̱tke tsi̱net, e' kue̱ki̱ a' e̱r mane'ú̱ ie' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Skëköl tö Juan yë' itteköl Isaías wa i' es: “Ká̱ sir poë wé̱ kë̀ yi se̱rku̱' tai̱ë, ee̱ yile ttöraë a̱neule, e' tö icheraë: ‘A' e̱r mane'ú̱ Skëköl datse̱ e' yöki̱, e' dör we̱s ñala̱ yuèsö yësyësë ie' yöki̱ es.’ ” Es Isaías tö iyë'a̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan datsi' yöule kameio köyök wa; ikipamo e' dör iyiwak kkuölit. Ie' chkè dör ditski ena bulali. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalén wakpa ena ká̱ male̱pa tso' Judea e' wakpa de tai̱ë ie' ttöke e' ttsök. Ñies ká̱ tso' di' Jordán kkömik, e' wakpa de. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ì sulu ko̱s wambleke ie'pa tö e' chekeka̱rakitö ta̱ Juan tö iwöskueke Jordán a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Erë mik Juan tö isué̱ tö fariseowakpa ena saduceowakpa de tai̱ë a̱s ie' tö ie'pa wöskuö̀lor eta̱ ie' tö ie'pa a̱ iché: “¡A' dör s'ki̱tö'u̱kwakpa suluë we̱s tkabë̀ es! ¿Yi tö a' a̱ iché tö a' tkömishkar Skëköl tö a' we'ikeraë sia̱rë e' ulà a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","A' se̱nú yësyësë, e' wa iwërwa̱mi tö moki̱ a' e̱r mane'wé̱tke Skëköl a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kë̀ a' tö ibikeitsök tö a' dör Abraham aleripa, e' ë̀ kue̱ki̱ Skëköl kë̀ tö a' we'ikepa. Ye' tö a' a̱ ichè tö Skëköl ki̱ ikiane, e' ta̱ ie' tö ák ikkë yuèmi Abraham aleripaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ie' dör we̱s kal bikökwak es. Ie' tso'tke kal ulitane kë̀ wörta̱' ese ko̱s bikökök ña'wè̱wa bö' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Moki̱ ye' tö a' wöskueke di' a̱ iwà kkachoie tö a' e̱r mane'wé̱tke Skëköl a̱. Erë ye' itöki̱ idatse̱ eköl, e' tö a' ierawa̱ Wiköl Batse'r a̱ ena bö' a̱. Ie' dör këkëpa tai̱ë ye' tsa̱ta̱, e' kue̱ki̱ ie' klökkuö ë̀ tsè̱mi e' kë̀ dör ye' sia̱rla e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ie' tö s'wöpperaë we̱s iyiwö wöppèsö es. Ibua'bua bleraëitö idichakuö a̱, erë isulusi u̱yerawa̱itö bö' kë̀ wöitta̱'wa̱ e' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús e̱' yéttsa̱ Galilea demi Jordán di'kka wé̱ Juan tso' ee̱ a̱s e' tö iwöskuö̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ke̱we ta̱ Juan kë̀ é̱na ie' wöskuak, ie' tö iché ia̱: —Warma be' ka̱wöta̱ ye' wöskuök. ¿We̱s be' do ye' ska' a̱s ye' be' wöskuö̀? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ie' tö iiu̱té: —Ì dör yësyësë Skëköl wöa̱, ese ko̱s ka̱wöta̱ wè̱ se' tö es, e' kue̱ki̱ imua̱tsö es i̱'ñe ta̱. Eta̱ Juan tö ie' ttö̀ iu̱té. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesús wösune e' e̱' duéka̱ne di' a̱ e' wösha̱ ta̱ ká̱ jaì kköbunane ta̱ ie' isué̱ tö Skëköl Wiköl bite̱ ie' ki̱ nuböl sù̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eta̱ ttö̀ ttsëne datse̱ ká̱ jaì a̱ e' tö iché: “Se̱ dör ye' alà dalër tai̱ë ye' é̱na, e' wër buaë shu̱te̱ ye' wa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","E' ukuöki̱ ta̱ Skëköl Wiköl tö Jesús tsé̱mi ká̱ sir poë wé̱ kë̀ yi se̱rku̱' ee̱ a̱s bë́ tö ie' e̱rkiöù̱ ì sulu wamblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ee̱ ie' se̱né döka̱ ká̱ dabom tkëyök (40), kë̀ chkane yës. Ekkë ta̱ ie' dué bli wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bë́ debitu̱ ie' ska' ta̱ ichéitö ia̱: —Be' dör Skëköl Alà, e̱'ma ichö́ ák se̱kkëpa a̱ tö a' yönú chkeie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús tö iiu̱té: —Au. Skëköl yëkkuö tö ichè: ‘Kë̀ se' se̱nuk chkè ë̀ mik. E' skéie ì ko̱s cheke Skëköl tö e' mik se' se̱rke.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","E' ukuöki̱ ta̱ bë́ wa̱ ie' mítse̱r Jerusalén dör ká̱ batse'r ee̱ ta̱ itsé̱mika̱itö Skëköl wé ka̱kke̱ë e' bata ki̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ta̱ ichéitö ia̱: —Be' dör Skëköl Alà, e̱'ma be' e̱' batrö́ömi döttsa̱ i̱ski̱. Skëköl yëkkuö tö ichè: ‘Skëköl tö ibiyöchökwakpa patkeraë be' kkö'nuk. Ie'pa tö be' klö'we̱raka̱ iulà a̱ a̱s be' klö̀ kë̀ tërwa̱ ák ki̱ yës.’ E' kue̱ki̱ be' e̱' batrö́ömi döttsa̱ i̱ski̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Eta̱ Jesús tö iiu̱té: —Au. Ñies Skëköl yëkkuö tö ichè: ‘A' kë̀ ka̱wö ta̱' Skëköl dör a' Këköl e' wötsiriu̱k.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","E' ukuöki̱ ta̱ bë́ tö ie' tsé̱mi ka̱bata ka̱kke̱ë a̱, ta̱ ee̱ ká̱ ko̱s we̱s ká̱ tköke ekkë, ñies íyi bua'buaë tso' iki̱, ese kkachéitö ie' a̱ se̱raa̱ bet. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ie' tö iché ia̱: —Be' e̱' tkéwa̱ kuchëwö ki̱ ye' wörki̱ ye' dalöiök Skëkölie, e' ta̱ ì ko̱s sué̱ be' tö e' meraëyö be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Erë Jesús tö ie' iu̱té: —A Satanás, Skëköl yëkkuö tö ichè: ‘Skëköl dör a' Këköl, e' ë̀ dalöiö́ a' tö Skëkölie, ie' ë̀ a̱ a' se̱nú.’ E' kue̱ki̱ be' yúshka. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Eta̱ bë́ tö Jesús méa̱t wák mía̱ bánet. Ta̱ Skëköl biyöchökwakpa de Jesús ska' iki̱muk. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mik Jesús wa̱ ijche̱newa̱ tö Juan S'wöskuökwak wötéwa̱rakitö s'wöto wé a̱, eta̱ ie' dene Nazaret a̱te̱ Galilea ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Erë kë̀ ie' a̱te̱ se̱nuk Nazaret. Ie' mía̱ se̱nuk Cafarnaúm, e' a̱te̱ batsöri kiè Galilea e' kkömik. Cafarnaúm a̱te̱ zabulónwak ena neftalíwak e'pa ké̱ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Itka es a̱s ì kit Skëköl tteköl Isaías tö yëkkuö ki̱ e' wà tkö̀ es. Ie' tö iyë': ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulónwak ena neftalíwak, e'pa se̱rke di' kiè Jordán e' wi̱she̱t batsöri kkömik. Ie'pa se̱rke Galilea wé̱ ñies pë' kë̀ dör judiowak esepa se̱rke ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ie'pa se̱rke we̱s se' se̱rke stui a̱ es e' kë̀ wa̱ Skëköl su̱ule. Ie'pa dör we̱s s'duulewa̱ es. Erë eköl doia̱, e' tö ie'pa e̱r ñi'we̱raë Skëköl ttè wa we̱s ká̱ olo tö ká̱ ñiwe es.” Es Isaías tö iyë'a̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","E' ukuöki̱ ta̱ Jesús tö s'pattémitke ta̱ ichéitö: “Ì blúie Skëköl tso' e' ké̱wö dewa̱tke tsi̱net, e' kue̱ki̱ a' e̱r mane'ú̱ ie' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús shkörami batsöri kiè Galilea e' kkömik, ee̱ ie' tö wëpa sué̱ böl ñì ëlpa. Eköl kiè Simón, e' kiè ñies Pedro. Iëköl kiè Andrés. Ie'pa kanè dör nima klö'u̱k. Ie'pa tso' ikla' u̱yök batsöri a̱ nima klö'wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ie' tö ie'pa a̱ iché: —A' shkö́ ye' ta̱. A' yueraëyö s'ditsö klö'u̱k ye' a̱ ye' ttökataie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","E' bet ta̱ ie'pa tö ikla' tuléa̱t ta̱ imíyal ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","E' wi̱'kie ie' tö wëpa skà sué̱ böl ñì ëlpa kiè Santiago ena Juan, e'pa dör Zebedeo ala'r. Ie'pa tulur kanò a̱ iyë́ ta̱ kla' wöyuök, ie'pa kiémi ie' tö e̱' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","E' wösha̱ ta̱ ie'pa tö ikanò ena iyë́ méa̱t ta̱ imíyal ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús shké Galilea ko̱s a̱ s'wöbla'u̱k judiowak ñì dapa'wo̱ wé ko̱s a̱. Ì blúie Skëköl tso', e' tté buaë pakekeitö, ñies s'duöke ko̱s, ì dalërke s'mik ko̱s, ese bua'we̱keitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ie' tté buneka̱ Siria ko̱s a̱. E' kue̱ki̱ pë' wa̱ tai̱ë iyamipa duöke duè daklilië wa̱ ese debitu̱ ie' ska'. We̱lepa a̱ aknama tso', we̱lepa siwa̱' a̱rke iröirö, we̱lepa kraulewa̱, esepa ko̱s bua'wé̱neitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Eta̱ pë' datse̱ Galilea, Decápolis, Jerusalén, Judea ena ká̱ a̱te̱ Jordán wi̱she̱t, e'pa mi'ke tai̱ë ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mik Jesús tö isué̱ tö pë' dapane tai̱ë, eta̱ ie' mía̱ ka̱bata tukir ki̱ ta̱ ee̱ ie' e̱' tkése̱r ta̱ ittökatapa de ie' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ie' tö ie'pa wöbla'wé̱mitke ttè i' wa: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Wé̱pa morke Skëköl ë̀ mik, esepa tso' ì blúie ie' tso' e' a̱, e' kue̱ki̱ ayëcha buaë esepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Wé̱pa e̱riarke sia̱rë, esepa e̱r pablërdaë, e' kue̱ki̱ ayëcha buaë esepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Wé̱pa e̱' wöökewa diöshe̱t, esepa a̱ ká̱ i' merdaë, e' kue̱ki̱ ayëcha buaë esepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Wé̱pa tö se̱ne yësyësë ese ko̱s i̱e̱itseke chkè ena di'yè tsa̱ta̱, esepa ulà a̱ iwà döraë, e' kue̱ki̱ ayëcha buaë esepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Wé̱pa tö s'male̱pa sue̱ke e̱r sia̱rë wa, esepa sue̱raë Skëköl tö e̱r sia̱rë wa, e' kue̱ki̱ ayëcha buaë esepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Wé̱pa e̱r maneneë, esepa tö Skëköl sue̱raë, e' kue̱ki̱ ayëcha buaë esepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Wé̱pa tö s'e̱r bua'we̱kene ñì ki̱, esepa kieraë Skëköl tö ila'r, e' kue̱ki̱ ayëcha buaë esepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Wé̱pa weirke ise̱rke yësyësë e' kue̱ki̱, esepa tso' ì blúie Skëköl tso' e' a̱, e' kue̱ki̱ ayëcha buaë esepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ayëcha buaë mik pë' tö a' cheke suluë, a' we'ikeke, a' kkateke ka̱chè wa ye' dalërmik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ká̱ jaì a̱ ì buaë merdaë a' a̱ iskéie, e' kue̱ki̱ mik ese tköke a' ta̱, eta̱ a' ttsë'nú buaë kaneë. Es ñies Skëköl ttekölpa bak a' yöki̱ ke̱we e'pa weine. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“A' dör we̱s dayë es ká̱ i' wakpa a̱. Erë dayë kë̀ kke ta̱'ia̱, e' ta̱ kë̀ ibuarpaia̱ne. Kë̀ iià̱ ìie bua' ta̱ ikeu̱kemi ñala̱ ki̱ ta̱ pë' dakö̀lor iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“A' dör we̱s bö'wö es ká̱ i' wakpa a̱. U tso' tai̱ë ka̱bata ki̱, e' kë̀ blënukwa̱, e' wëne ka̱mië. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kë̀ yi tö bö'wö tskepaka̱ ta̱ ibléwa̱itö ö ipatkéwa̱itö kalkuö diki̱a̱. E' skéie itkekeka̱itö ká̱kke̱ sulitane tso' u a̱ esepa wö a̱ ká̱ ñi'wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Es ñies a' se̱nú buaë yësyësë sulitane wörki̱ a̱s e' sa̱ù̱ ie'pa tö ta̱ a' Yë́ tso' ká̱ jaì a̱ e' ki̱karka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kë̀ a' tö ibikeitsök tö ye' dë'bitu̱ ì kit Moisés ena Skëköl ttekölpa tö yëkkuö ki̱, e' wöshtökwa̱. E' skéie ye' dë'bitu̱ a̱s iwà tkö̀ we̱s itso' kitule es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Moki̱ ye' tö a' a̱ ichè tö ttè e' kë̀ watërpattsa̱ etkla wë'ia̱ ka̱m ká̱ jaì ena ká̱ i' e̱rwa e' yöki̱; ttè e' ko̱s wà tköraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","E' kue̱ki̱ yi tö ttè e' we̱le dalöse̱we̱kewa̱, erë́ ttè tsir idir, ena o̱'ka wöbla'we̱keitö idalöse̱u̱kwa̱, ese döraë s'ësela imale̱pa blúie Skëköl tso' esepa diki̱a̱. Erë yi tö ttè e' dalöieke ena o̱'ka wöbla'we̱keitö idalöiök, ese döraë këkë tai̱ë imale̱pa blúie Skëköl tso' esepa tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","E' kue̱ki̱ ye' tö a' a̱ ichè tö a' kë̀ se̱r yësyësë tkö̀ka̱ s'wöbla'u̱k ttè dalöiëno wa wakpa ena fariseowakpa tsa̱ta̱, e' ta̱ a' kë̀ dö̀pa ì blúie Skëköl tso' e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“A' wa̱ ittsëule tö iyënebak ká̱ ia̱ia̱ë a' yë́pa a̱: ‘Kë̀ a' ka̱wö ta̱' s'ttökwa̱,’ ñies ‘Yi tö s'ttéwa̱, ese wák kichatërdaë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Erë ye' tö a' a̱ ichè tö yi uluneka̱ iyami ki̱, ese kichatërdaë. E' kí̱ie ta̱ yi tö iyami ché suluë, ese kichatërdaë. Ñies yi tö iyami kichatéttsa̱, ese ki̱ inuí̱ tso' tai̱ë tö ipatkerami bö' ké̱ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“E' kue̱ki̱ a' wa̱ ilè mí mè ka̱' tso' íyi moka̱ Skëköl a̱ e' ki̱ ta̱ ee̱ a' é̱na ia̱newa̱ tö a' yami we̱le wa̱ ilè tté tso' a' ki̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","e' ta̱ ì mí a' wa̱ mè e' múa̱t ee̱, kë̀ imar. A' yú a' yami e̱r bua'u̱kne a' ki̱. E' ukuöki̱ ta̱ a' yúne ì meke a' tö e' mú. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Yile wa̱ a' mí kkatè s'shu̱lo wé a̱, e' ta̱ mik a' dami ñala̱ ki̱ ie' ta̱, eta̱ ishu̱lö́ ie' ta̱ a̱s ie' kë̀ tö a' mùttsa̱ s'shu̱lökwak ulà a̱. A' kë̀ tö iwè̱ es, e' ta̱ s'shu̱lökwak tö a' merattsa̱ s'shkëkipa ulà a̱ ta̱ esepa tö a' wöterawa̱ s'wöto wé a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Moki̱ ye' tö a' a̱ ichè tö a' kë̀ döpattsa̱ dö̀ mik a' tö inuí̱ patué̱ttsa̱ se̱raa̱ eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“A' wa̱ ittsëule tö iyënebak: ‘Kë̀ a' ka̱wö ta̱' s'se̱newa̱bak dalöse̱u̱kwa̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Erë ye' tö a' a̱ ichè tö yi tö o̱'ka alaköl sué̱ ta̱ ikkechéitö, e' ta̱ e' wa ise̱newa̱bak dalöse̱wé̱wa̱itö ie̱r a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“E' kue̱ki̱ a' wöbla bua'kka tö a' keke ì sulu wamblök, e' ta̱ iyö́ttsa̱ kö́u̱mi bánet. A' yese alè kéu̱ a' tö, e' dör bua'ie a' u̱yèwa̱ bö' ké̱ a̱ wa'ñe e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A' ulà bua'kka tö a' keke ì sulu wamblök, e' ta̱ itö́ö u̱yö́mi bánet. A' yese alè kéu̱ a' tö, e' dör bua'ie a' u̱yèwa̱ bö' ké̱ a̱ wa'ñe e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ñies iyënebak: ‘Wëm tö itayë éwa, ese wák ka̱wöta̱ ñì owa yëkkuö muk ia̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Erë ye' tö a' a̱ ichè tö wëm tö itayë éwa, kë̀ dör itayë trër kue̱ki̱, e' ta̱ e' wa ese tö itayë wömèttsa̱mi ise̱newa̱bak dalöse̱u̱kwa̱ Ñies wëm we̱le se̱néwa̱ tayë ese ta̱, e' wa e' tö tayë se̱newa̱bak dalöse̱wé̱wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ñies a' wa̱ ittsëule tö iyënebak ká̱ ia̱ia̱ë a' yë́pa a̱: ‘A' ttè mé Skëköl wörki̱, eta̱ e' wà u̱k a' ka̱wöta̱ moki̱ë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Erë ye' tö a' a̱ ichè tö kë̀ a' ka̱wö ta̱' ttè muk ñì a̱ Skëköl wörki̱ ö ilè skà wa. Kë̀ a' ka̱wö ta̱' ttè muk ñì a̱ ká̱ jaì wa, e' dör wé̱ Skëköl tkër s'blúie e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kë̀ a' ka̱wö ta̱' ttè muk ñì a̱ ká̱ i' wa, e' dör Skëköl klö̀ tkoka̱ie e' kue̱ki̱. Kë̀ a' ka̱wö ta̱' ttè muk ñì a̱ Jerusalén wa, e' dör Skëköl dör s'blú, e' ké̱, e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ñies a' wakpa kë̀ a̱ a' tsà̱ ë̀ manenuk saruru ö dalolo, e' kue̱ki̱ a' kë̀ ka̱wö ta̱' ttè muk ñì a̱ i' es: “Ì chéyö e' kë̀ yëne, e' ta̱ ye' wökir tö́ö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","E' kue̱ki̱ mik a' ttè meke ñì a̱, ta̱ a' tö icheke, “tö́”, eta̱ e' dör tö́; mik a' tö icheke, “au”, eta̱ e' dör au. A' tö ì skà chéne bánet, e' ta̱ e' dör suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“A' wa̱ ittsëule tö iyënebak: ‘Yi tö o̱'ka wöbla tskéwa̱, ese wák ka̱wöta̱ wöbla ské tskèwa̱. Yi tö o̱'ka kà pé̱wa̱, ese wák ka̱wöta̱ kà ské pè̱wa̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Erë ye' tö a' a̱ ichè tö kë̀ a' e̱' tsa̱tkök pë' sulusipa yöki̱. E' skéie yi tö a' ppé a' a̱swö bua'kka ki̱, e' ta̱ a' a̱swö etta mú ia̱ ppè. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Yi tö a' kkaté s'shu̱lökwakpa wörki̱ a' paio kiane iki̱ e' kue̱ki̱, e' ta̱ a' paio mú ia̱, ñies a' paio ki̱kke̱ mú ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Yi tö a' ké idali tsu̱kmi kësik wa dö̀ kilómetro et, e' ta̱ ikí̱ tsú̱mi dö̀ kilómetro böt. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yi tö a' a̱ ilè kak kié, e' ta̱ imú ia̱. Ñies yi tö a' a̱ íyi kié peitule, e' ta̱ ipeitö́ ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ñies a' wa̱ ittsëule tö iyënebak: ‘S'yamipa dalëritsö́ erë s'bolökpa sa̱ú̱ sulu.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Erë ye' tö a' a̱ ichè: A' bolökpa dalëritsö́. Wé̱pa tö a' we'ikeke, esepa ki̱ ikiö́ S'yë́ a̱ tö iki̱mú. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","A' tö iwe̱ke es, e' ta̱ e' wa a' tso' ikkachök tö moki̱ a' dör a' Yë́ tso' ká̱ jaì a̱ e' ala'r. Ie' tö dìba patkeke s'se̱r buaë ena s'se̱r sulu esepa ki̱. Ñies ie' tö ka̱li̱ patkeke s'se̱r yësyësë ena s'se̱r sulu esepa ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Wé̱pa tö a' dalëritseke esepa ë̀ ské dalëritseke a' tö, e' ta̱ ¿we̱s Skëköl tö ì buaë mèmi a' a̱ iskéie? Ñies inuköl shtökwakpa Roma wökirpa a̱ e'pa tö iwe̱ke es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","A' tö a' yamipa ë̀ shke̱'we̱ke, e' ta̱ ¿ì buaë we̱ke a' tö s'sulusipa tsa̱ta̱? Ñies pë' kë̀ tö Skëköl dalöiè esepa tö iwe̱ke es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","A' se̱nú buaë yësyësë we̱s Skëköl dör S'yë́ tso' ká̱ jaì a̱ e' se̱r buaë yësyësë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“¡A' e̱' kkö'nú! Mik a' tö ì buaë we̱ke s'ki̱moie, eta̱ kë̀ iwa̱r sulitane wörki̱ a̱s ie'pa tö a' kkeö̀ka̱. A' tö iwé̱ es, e' ta̱ Skëköl dör S'yë́ tso' ká̱ jaì a̱, e' kë̀ tö ì mepa a' a̱ iskéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“E' kue̱ki̱ mik a' tö s'sia̱rëpa ki̱meke, eta̱ kë̀ e' tté pparka̱ sulitane kukua we̱s e̱' ökwakpa es. Ie'pa tö iwe̱ke ie'pa ñì dapa'wo̱ wé a̱ ena ñala̱ wa a̱s sulitane tö ie'pa kkeö̀ka̱. Moki̱ ye' tö a' a̱ ichè tö pë' tö ie'pa kkeekeka̱ e' ë̀ dör ie'pa icha ské. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Erë mik a' tö s'sia̱rëpa ki̱meke, eta̱ a' tö iú̱ bë̀rë, kë̀ ichar yi a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Es Skëköl tö ì ko̱s tso' blëule ese sue̱ke, e' tö ì buaë meraë a' a̱ iskéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Mik a' ttöke S'yë́ ta̱, eta̱ kë̀ a' ttök sulitane wörki̱ we̱s e̱' ökwakpa es. Sulu ie'pa wöbatsö e̱' duökse̱r ttök S'yë́ ta̱ ie'pa ñì dapa'wo̱ wé a̱ ena wé̱ pë' daparke tai̱ë ká̱ áie ese ska' a̱s ikkea̱rka̱. Moki̱ yö ichè a' a̱ tö ie'pa icha ské detke iulà a̱ se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Erë mik a' ttöke S'yë́ ta̱, eta̱ a' yúwa̱ a' úshu̱ a̱, ukkö wötö́wa̱ ee̱ a' ttö́ Skëköl dör a' Yë́ e' ta̱ bë̀rë. A' tö iwe̱ke es, e' ta̱ Skëköl tö ì ko̱s tso' blëule ese sue̱ke, e' tö ì buaë meraë a' a̱ iskéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ñies mik a' ttöke S'yë́ ta̱, eta̱ kë̀ a' ttök we̱s pë' kë̀ tö ie' dalöiè e'pa ttöke ie'pa këkölpa ta̱ es. Ie'pa ttöke ttè etkë̀ wa tai̱ë batsì̱ë kë̀ wà ta̱'. Ie'pa tö ibikeitseke tö ikëkölpa tö ie'pa ttö̀ ttsèmi ie'pa tté tai̱ë e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kë̀ a' tö iu̱k we̱s ie'pa es. Ì kiane a' ki̱ e' jche̱r Skëköl wa̱ ka̱m a' tö ie' a̱ ikiö̀ e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","A' ttö́ ie' ta̱ i' es: ‘A Sa' Yë́ tso' ká̱ jaì a̱, a̱s be' dalöiö̀ sa' tö ì ulitane tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A̱s be' dö̀ sa' blúie da'a̱ie. Ì kiane be' ki̱ a̱s e' o̱r ká̱ i' ki̱ we̱s io̱rke ká̱ jaì a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Chkè kiane sa' ki̱ i̱'ñe se̱noie e' mú sa' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Sa' nuì̱ olo'yö́ sa' ki̱ we̱s sa' tö s'male̱pa ki̱ inuì̱ olo'yeke es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kë̀ sa' marttsa̱ tö ì sulu tö sa' e̱rkiöù̱, e' skéie sa' tsa̱tkö́ yi dör sulu ichö́k e' yöki̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“S'male̱pa nuì̱ olo'yeke a' tö ie'pa ki̱, e' ta̱ ñies S'yë́ tso' ká̱ jaì a̱, e' tö a' nuì̱ olo'yeraë a' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Erë a' kë̀ tö s'male̱pa ki̱ inuì̱ olo'yè, e' ta̱ S'yë́ kë̀ tö a' nuì̱ olo'yepa a' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mik a' batsöke Skëköl a̱, eta̱ kë̀ a' e̱' ök sia̱rë we̱s e̱' ökwakpa es. Ie'pa e̱' öke sia̱rëla a̱s s'male̱pa tö isa̱ù̱ ta̱ ikkeöka̱rakitö ibatsökerak e' kue̱ki̱. Moki̱ ye' tö a' a̱ ichè tö ie'pa icha ské detke ie'pa ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Erë mik a' batsöke, eta̱ a' wöskuö́ö, a' tsa̱iklö́ö, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","a̱s s'male̱pa kë̀ tö isa̱ù̱ tö a' tso' batsök. S'yë́ kë̀ wërta̱' e' tö íyi ulitane tso' blëule e' sue̱ke. A' batsö́ ie' ë̀ wöa̱ ta̱ ie' tö iské meraë a' a̱ buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","21","“Wé̱ a' íyi bua'bua tso' blëule ee̱ a' e̱r me'rie. E' kue̱ki̱ kë̀ a' tö íyi bua'bua blök ká̱ i' ki̱. Ká̱ i' ki̱ powak se' íyi sulu'we̱kewa̱, ñies akblökwakpa tö iekibleke. E' skéie, a' íyi bua'bua e' blö́ ká̱ jaì a̱. Ee̱ powak kë̀ dö̀pa íyi sulu'u̱kwa̱ ñies akblökwakpa kë̀ dö̀pa íyi ekiblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“S'wöbla dör we̱s bö'wö es s'chkà ko̱s a̱. E' kue̱ki̱ s'wöbla dör buaë, e' ta̱ se' chkà ko̱s e' a̱ ká̱ olo ta̱' buaë. E' dör we̱s se' e̱r dör buaë es, ì ko̱s dör buaë yësyësë ese ki̱ se' e̱r me'rie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Erë s'wöbla kë̀ dör bua', e' ta̱ s'chkà ko̱s e' tso' stui a̱. E' dör we̱s se' e̱r suluë es, ì sulu ko̱s ese ki̱ se' e̱r me'rie. Erë se' e̱r buaë e' mía̱ne suluë stuiie, e' ta̱ e' dör suluë ichökle. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Wé̱ klöulewa̱ kanè mésoie, ese ka̱wöta̱ iwökir ë̀ ttö̀ dalöiök. Ie' wökirpa chö́pa böl, e̱'ma ie' ka̱wöta̱ eköl ë̀ dalöiök ena iëköl watöktsa̱. Es a' kë̀ a̱ e̱r menukwa̱ Skëköl ki̱ ena inuköl ki̱ ñita̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“E' kue̱ki̱ ye' tö a' a̱ ichè: Ì kiane a' ki̱ se̱noie chkeie, di'ie, datsi'ie ìie, ese ko̱s kë̀ ki̱ a' tkinuk. S'tso' ttsë'ka e' kë̀ dör chkök ë̀me, ñies s'chkà kë̀ dör datsi' ë̀ ioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Dù sa̱ú̱ a' tö. Ie'pa kë̀ tö ì kuatketa̱' ì wöshteta̱', ie'pa kë̀ tö chkè bleta̱', erë S'yë́ tso' ká̱ jaì a̱ e' tö ie'pa tieke. Ie' é̱na a' dalër tai̱ë dù ko̱s tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A' tkirke tai̱ë e̱' ki̱, e' kë̀ tö a' a̱ ka̱wö kí̱ mepa se̱noie ekuölö ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Ì kue̱ki̱ a' tkirke datsi' ki̱? Ma'ma wörkua bua'buaala ese sa̱ú̱ we̱s italar, kë̀ kaneblöta̱', kë̀ datsi' yueta̱'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Erë́ blu' bak kiè Salomón, e' wa̱ íyi ulitane bua'buaë bak tai̱ë, erë ye' tö a' a̱ ichè tö ie' datsi' bua'bua kë̀ wër buaë we̱s ma'ma wër es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ka̱kö sué̱sö i̱'ñe, bule ta̱ iñanewa, erë Skëköl tö iki̱tkeke buaala iwörkua wa. Ie' tö ka̱kö ki̱tkeke es, ¡e' yita̱ ie' tö a' kianeia̱ e̱rblök buaë ie' mik, esepa paieraë! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","E' kue̱ki̱ kë̀ a' tkinuk. Kë̀ a' e̱' chakök, ‘¿Ì ñèmi sa' tö?’ ö ‘¿Ì yèmi sa' tö?’ ö ‘¿Ì wa sa' e̱' paiö̀mi?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pë' kë̀ tö Skëköl dalöiè esepa tkirke tai̱ë íyi ko̱s ekkë ki̱. Erë ì ko̱s kiane a' ki̱ e' jche̱rtke a' Yë́ tso' ká̱ jaì a̱ e' wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","E' kue̱ki̱ ì ko̱s blúie ie' tso' ena ì dör yësyësë ie' a̱ ese ki̱ a' e̱r múwa̱ ke̱we. A' tö iwe̱ke es, e' ta̱ ñies íyi ñekkë ko̱s döraë a' ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Diwö bit ekkë íyi tso' ki̱ tkine e' dör wë' se' a̱. Bulebök se' tkirmi ì tkö̀mi ee̱ e' ki̱, e' kue̱ki̱ kë̀ a' tkinuk iki̱ i' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","“Ttè wa a' tö s'male̱pa kichaté e' ë̀ wa Skëköl tö a' kichateraë. We̱s a' tö s'male̱pa we̱ke e' sù̱ a' we̱raë Skëköl tö. E' kue̱ki̱ kë̀ a' s'kichatök a̱s Skëköl kë̀ tö a' kichatö̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kaltak jche̱la tsir tso' a' yami wöbla a̱, e' sué̱ a' tö, erë ¿ì kue̱ki̱ kaltak bërie tso' a' wák wöbla a̱, e' kë̀ su̱ne a' wa̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿We̱s a' tö ichèmi a' yami a̱: ‘sú̱yö be' wöbla a̱ kaltak jche̱la tsir tso' e' yèttsa̱’? Erë kaltak bërie tso' a' wöbla a̱, ¿e' kë̀ su̱ne a' wa̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡A' e̱' öke suluë! Kaltak bërie tso' a' wöbla a̱ e' yö́ttsa̱ ke̱we, es a' yami wöbla a̱ kaltak jche̱la tsir tso' e' wërmi a' a̱ buaë yèttsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ì dör batse'r ese kë̀ tularttsa̱ chichi a̱ dö' ie'pa bitu̱ne a' jchöklor. Ñies a' íyi bua'bua, ese kë̀ tularttsa̱ köchi a̱, ie'pa tö iñateraë ikla'tska wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","“Wé̱pa tö íyi kieke Skëköl a̱, esepa a̱ imeraë ie' tö; wé̱pa tö íyi yuleke ie' ska' esepa tö ikue̱raë; wé̱pa tö ie' chakeke, esepa kierawa̱ ie' tö we̱shke̱. E' kue̱ki̱ ì kiane a' ki̱ e' kiö́ ie' a̱, eta̱ ie' tö a' a̱ imeraë; e' yulö́ ie' ska', eta̱ a' tö ikue̱raë; ie' chakö́, eta̱ ie' tö a' kierawa̱ we̱shke̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Kë̀ a' wé̱ne tö ák mepa ilà a̱ pan kiéitö e' skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ñies kë̀ a' tö tkabë̀ mepa a' alà a̱ nima kiéitö e' skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A' dör pë' suluë erë e' tö íyi buaë meke a' alà a̱. ¡E' yita̱ buaë S'yë́ tso' ká̱ jaì a̱, e' tö íyi buaë meraë yi tö ie' a̱ ikieke ese a̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“A' se̱nú s'male̱pa ta̱ we̱s a' ki̱ ikiane tö ie'pa se̱r a' ta̱ es. Ttè e' a̱ ì kit Moisés ena Skëköl ttekölpa tö yëkkuö ki̱ e' ko̱s wöiëulewa̱. E' kue̱ki̱ a' se̱nú es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Se̱ne michoë e' wékkö dör tsir, e' a̱ a' shkö́wa̱. S'weir micho e' ñalé̱ ena iwékkö dör shoë; tai̱ë s'mi'ke iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Erë se̱ne michoë e' wékkö dör tsir ena iñalé̱ ki̱ darërëë shka', wé̱pa tö ikué̱ esepa kë̀ dör tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“A' e̱' kkö'nú ka̱chökwakpa e̱' chö̀ tö ie'pa dör Skëköl ttekölpa esepa yöki̱. Ie'pa e̱' ö̀ tö ie'pa dör buaë we̱s obeja urula es, erë ie'pa e̱r suluë we̱s iyiwak sulusi es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","We̱s ie'pa e̱' wamblöke, e' wa a' tö isue̱rawa̱ pë' wé̱se idir. ¿Wé̱ a' wa̱ isu̱ule tö uvawö ö higowö e' shteta̱'sö dika' kicha mik? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kal buaë ko̱s ese wö dör buaë, erë kal sulusi ko̱s ese wö dör suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kal bua'bua kë̀ wörta̱' kalwö sulusiie. Ñies kal sulusi kë̀ wörta̱' kalwö bua'buaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kal ko̱s kë̀ wör buaë, ese bikeeke ta̱ iña'we̱kewa bö' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Es a' tö ka̱chökwakpa sue̱rawa̱ we̱s ie'pa e̱' wamblö̀ e' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Wé̱pa tö ye' a̱ icheke: ‘A Skëkëpa, a Skëkëpa’, kë̀ esepa döpawa̱ se̱raa̱ ì blúie Skëköl tso' e' a̱. Erë wé̱pa se̱rke we̱s ye' Yë́ tso' ká̱ jaì a̱ e' ki̱ ikiane es, esepa ë̀ dörawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aishkuö ta̱ mik a' wöchakirketke a' nuì̱ ki̱ e' ké̱wö de, eta̱ tai̱ë ie'pa tö ye' a̱ icheraë i' es: ‘A Skëkëpa, be' ttö̀ wa sa' ut Skëköl ttekölie, be' ttö̀ wa sa' tö aknama u̱ya'lur, be' ttö̀ wa ì kë̀ o̱r yi a̱ ese o̱' sa' tö tai̱ë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Erë ye' tö ie'pa iu̱teraë: ‘Kë̀ ye' wa̱ a' su̱ule yës. A' e̱' wamblö̀ suluë. ¡A' yúshka bánet ye' yöki̱!’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“E' kue̱ki̱ yi tö ye' ttö̀ ttsé ta̱ iwà iu̱teke, ese dör we̱s wëm eköl tö u yué es. E' tö u chkí töbié i̱ski̱ë ká̱ dör ák ë̀ ese a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ka̱li̱ yëne tai̱ë, di' pone tai̱ë, sërkë tka tai̱ë, e' ko̱s tëne u e' mik, erë u kë̀ a̱nerö, ichkí tuluulewa̱ ák a̱ e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Erë yi tö ye' ttö̀ ttsé, erë kë̀ iwà iu̱teku̱', ese dör we̱s wëm eköl kë̀ ka̱bikeitsöta̱' es. E' tö u yué ttsa̱'wö a̱ ta̱ chkí a̱te̱ jalëjalë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ka̱li̱ yëne tai̱ë, di' pone tai̱ë, sërkë tka tai̱ë, e' ko̱s tëne u e' mik ta̱ ia̱nerö i̱ski̱ ta̱ kë̀ ì ta̱'ia̱ iwa̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mik Jesús tté o̱ne ta̱ we̱s ie' tö s'wöbla'we̱ke e' tö sulitane tkiwé̱wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ie' tö ie'pa wöbla'we̱ke ttè moki̱, diché ta̱' tai̱ë, ese wa. E' kë̀ dör we̱s s'wöbla'u̱k ttè dalöiëno wa wakpa s'wöbla'we̱ke es. E' kue̱ki̱ ie'pa wökranewa̱ ittsök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mik Jesús bite̱a̱tkene ka̱bata a̱, eta̱ tai̱ë pë' dami ie' itöki̱; ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","e' shu̱a̱ wëm debitu̱ eköl ie' ska' kiri'we̱ke lepra tö. Ie' e̱' tkéwa̱ kuchë ki̱ Jesús wörki̱ ta̱ ichéitö: —A këkëpa, be' ki̱ ikiane, e' ta̱ be' a̱ ye' buarmine a̱s ye' batse'rne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús tö ikéwa̱ ulà wa ta̱ ichéitö ia̱: —Tö́, ye' ki̱ ikiane. Be' dene batse'r. E' wösha̱ ta̱ ie' buanene, kë̀ ki̱ lepra ku̱'ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús tö iché ie' a̱: —Ittsö́, kë̀ ichar yi a̱. Be' yú e̱' kkachök sacerdote a̱. Ì muk Moisés tö a' ka' e̱' batse'wo̱ie, e' tsú̱mi mè Skëköl a̱ iwà kkachoie tö be' buanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mik Jesús de Cafarnaúm, eta̱ Roma ñippökwakpa döka̱ cien ese wökir de eköl ie' ska' kköchök, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ta̱ ichéitö ia̱: —A këkëpa, ye' kanè méso duladula eköl kirinewa̱ tai̱ë. Ie' me'r u a̱ ka̱' ki̱ pa dalërke tai̱ë kranewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús tö iu̱té: —Ye' mí ibua'u̱kne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ñippökwakpa wökir tö iu̱té: —A këkëpa, be' döwa̱ ye' u a̱ e' kë̀ dör ye' sia̱rla e' a̱. Erë iké̱wö ë̀ mú ta̱ ye' kanè méso buardane. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ye' wökirpa ta̱', e'pa ttö̀ iu̱tök ye' ka̱wöta̱. Ñies ye' dör ñippökwakpa tai̱ë e'pa wökir, ie'pa ka̱wöta̱ ye' ttö̀ iu̱tök. Mik ye' tö eköl a̱ icheke: ‘Be' yú’, ta̱ imí. Eköl a̱ ye' tö icheke: ‘Be' dou’, ta̱ ide. Ñies ye' tö icheke ye' kanè méso a̱: ‘Íyi ú̱’ ta̱ iwé̱itö. Ye' iklö'wé̱ tö be' wa̱ ka̱wö ta̱' íyi ulitane tsa̱ta̱, e' kue̱ki̱ ye' wa̱ ijche̱r tö be' tö iké̱wö mé, e' ta̱ ye' kanè méso buardane. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mik Jesús tö e' ttsé ta̱ e' tö ie' tkiwé̱wa̱. Ichéitö pë' dami ie' itöki̱ e'pa a̱: —Moki̱ ye' ichè a' a̱ tö Israel aleripa ko̱s shu̱a̱ kë̀ ye' wa̱ yi ku̱ne e̱rblök ye' mik we̱s wëm i' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ye' tö a' a̱ ichè tö mik ì blúie Skëköl tso' e' ké̱wö de da'a̱ie, eta̱ pë' kë̀ dör judiowak tso' ká̱ wa'ñe, esepa döraë tai̱ë e̱' tkökse̱r chkök se' yë́pa bak kiè Abraham ena Isaac ena Jacob e'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Erë warma wé̱pa e̱' tulökese̱r ee̱ esepa u̱yardattsa̱ bánet stui ké̱ a̱. Ee̱ ie'pa i̱u̱raë sia̱rë ikà yilitdawa̱ weine kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Eta̱ Jesús tö iché ñippökwakpa wökir a̱: —Be' yú u a̱ ta̱ itköraë we̱s be' e̱rblé ye' mik es. E' wösha̱ ta̱ ikanè méso buanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús mía̱ Pedro u a̱ ta̱ ie' isué̱ tö Pedro yàk me'r ka̱' ki̱ kiri'we̱ke duè dalölö tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ie' tö iké iulà ki̱ ta̱ duè dalölö tö iéwa ta̱ ie' e̱' kéka̱ ta̱ ilè yuléitö ie' a̱ ñè. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ká̱ tuirketke ta̱ tai̱ë ie'pa wa̱ pë' a̱ aknama tso' esepa debitu̱ Jesús ska'. Ittö̀ ë̀ wa ie' tö wimblupa ñe' trë'wé̱yal se̱raa̱. Ñies s'kirirke e'pa bua'wé̱neitö se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","E' tka es a̱s ì yë'a̱t Skëköl tteköl kiè Isaías e' tö, e' wà tkö̀. Ie' iyë': “Se' duè ko̱s e' yéttsa̱ ie' tö se' ki̱, Se' weirke ko̱s e' mítse̱r ie' wa̱ se' yöki̱ bánet.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mik Jesús tö isué̱ tö pë' dapaneka̱ tai̱ë ipamik, eta̱ ie' tö iché ittökatapa a̱: “Mishka batsöri wi̱she̱t.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Eta̱ s'wöbla'u̱kwak ttè dalöiëno wa eköl de ie' ska' ta̱ ichéitö ia̱: —A S'wöbla'u̱kwak, ye' shkak be' ta̱ be' ttökataie ká̱ wa'ñe wé̱ be' mírö ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús tö iiu̱té: —Bakli' u ta̱' ñies dúla u ta̱', erë ye' dör S'ditsö Alà e' kë̀ wa̱ u ta̱' se̱noie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Eta̱ wëm skà dör ie' klé eköl e' tö ie' a̱ iché: —A këkëpa, ka̱wö mú ña, mik ye' yë́ blënewa̱ ta̱ inú wötökwa̱, e' ukuöki̱ ye' mi'ke be' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús tö iiu̱té: —I' ta̱ be' shkö́ ye' ta̱. Wé̱pa dör we̱s s'duulewa̱ es Skëköl wöa̱, a̱s esepa tö iyamipa nu blö̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Eta̱ Jesús e̱' iéka̱ kanò a̱ ittökatapa ta̱ ta̱ imíyal batsöri ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ie'pa mirwa̱ia̱ e' shu̱a̱ siwa̱' batsi̱neka̱ tai̱ë tö di' u̱yéka̱ tai̱ë ta̱ kanò a̱ di' iëneka̱mi. Erë ie' kapöme'r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eta̱ ittökatapa de ie' ska' ta̱ iti̱'wé̱ka̱ ta̱ ichéitörak ia̱: —¡A Skëkëpa, se' tsa̱tkö́! ¡Se' duölurmi! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ie' tö ie'pa iu̱té: —¿Ì kue̱ki̱ a' suane se̱kkë? Wësua a' kë̀ e̱rblöku̱' ye' mik bua'ie. Eta̱ ie' e̱' kéka̱ ta̱ siwa̱' ena di' yöli uñéitö ta̱ iwöklönewa̱ mía̱ne alamië. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ie'pa tkinewa̱ tai̱ë ta̱ iñi chakéka̱: —¿Yi dör wëm wí̱? ¡E' ttö̀ dalöieke siwa̱' tö ena di' tö! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mik Jesús demi batsöri wi̱she̱t ká̱ kiè Gadara ee̱ ta̱ wëpa böl a̱ aknama tso', e'pa e̱' yéttsa̱ pö ké̱ a̱ de ie' ska'. Ie'pa e̱' wamblörak suluë e' kue̱ki̱ kë̀ yi shköta̱' ñala̱ e' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ie'pa tö ichémi a̱neule: —Be' dör Skëköl Alà. ¿Iö́k be' de sa' tsiriu̱k? ¿Be' debitu̱ sa' we'ikök ka̱m sa' ké̱wö dö̀ e' yöki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ee̱ tsi̱net köchi iëte̱r tai̱ë chkök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aknamapa tso' tai̱ë e'pa kköché Jesús a̱: —Be' tö sa' u̱yekettsa̱, e' ta̱ ka̱wö mú sa' a̱ e̱' tiu̱kwa̱ köchi tso' tai̱ë jaì a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ie' tö iché ie'pa a̱: —A' yúshka ee̱. Eta̱ aknamapa ko̱s e̱' yélur wëpa a̱ ta̱ e̱' tié̱lur köchi a̱. E' bet ta̱ köchi ko̱s poneka̱ tu̱nemirak ká̱ spé mik brutolonemi batsöri a̱ ta̱ ee̱ iduolur. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Köchi kkö'nukwakpa tkayalmi. Mik ie'pa de ká̱ kibi ki̱, eta̱ ie'pa tö ì ko̱s tka wëpa a̱ aknamapa bak e'pa ta̱, e' tté ppéka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Eta̱ ká̱ e' wakpa ko̱s mía̱ Jesús ska'. Mik ie'pa de, eta̱ ie'pa kköché ie' a̱: “Be' e̱' yö́ttsa̱ sa' ká̱ a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","E' ukuöki̱ ta̱ Jesús e̱' iéka̱ kanò a̱ ta̱ imía̱ne itö̀ wa demi Cafarnaúm wé̱ ie' se̱rke ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Eta̱ ee̱ ie'pa wa̱ wëm kraulewa̱ eköl mítse̱r Jesús ska' ka̱'la ki̱. Mik Jesús tö isué̱ tö moki̱ ie'pa e̱rblé ie' mik, eta̱ ie' tö iché wëm kirirke e' a̱: —A yami, be' e̱r kuú̱, ì sulu ko̱s wamblébö, e' nuí̱ olone be' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Eta̱ s'wöbla'u̱k ttè dalöiëno wa wakpa we̱lepa tö ibikeitseke: “Ì ché ie' tö e' wa ie' tso' Skëköl chök suluë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Erë ì bikeitsök ie'pa tso' e' sué̱wa̱ Jesús tö bet. E' kue̱ki̱ ie' tö ie'pa a̱ ichaké: —¿Ì kue̱ki̱ a' tso' íyi sulu bikeitsök? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ye' tö wëm i' bua'wè̱mine a̱s ishköne, e' ta̱ ¿we̱s a' tö iklö'wè̱mi tö ye' kë̀ a̱ inuì̱ olonuk iki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ye' dör S'ditsö Alà, sú̱ e' tö a' a̱ ikkachè tö ye' wa̱ ka̱wö ta̱' ká̱ i' a̱ nuì̱ olo'yoie. Eta̱ ie' tö iché wëm kraulewa̱ e' a̱: —Be' e̱' kö́ka̱, be' ka̱'la kö́ka̱ ta̱ be' yúne be' u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Eta̱ ie' e̱' kéka̱ ta̱ imía̱ne iu a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mik e' sué̱ pë' tso' ee̱ e'pa tö, eta̱ ie'pa suane tai̱ë. Ie'pa tö isué̱ tö Skëköl tö diché tai̱ë mé s'ditsö eköl a̱, e' kue̱ki̱ ie'pa tö Skëköl ki̱kéka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","E' ukuöki̱ ta̱ Jesús e̱' yéttsa̱ ta̱ imía̱, e' tö wëm sué̱ eköl kiè Mateo, e' dör inuköl shtökwak Roma wökirpa a̱. Ie' tkër ikaneblöke e' wé a̱. Ta̱ Jesús tö ie' a̱ iché: —Be' shkö́ ye' ta̱ ye' ttökataie. Eta̱ ie' e̱' kéka̱ ta̱ imía̱ Jesús ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","E' ukuöki̱ ta̱ Jesús de ittökatapa ta̱ Mateo u a̱ chkök. Ie'pa tulur chkök, e' dalewa inuköl shtökwakpa Roma wökirpa a̱ esepa tai̱ë ena pë' sulusipa skà deyalñak e̱' tulése̱r chkök Jesús ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mik e' sué̱ fariseowakpa tö, eta̱ ie'pa tö Jesús ttökatapa a̱ ichaké: —¿Iö́k a' wöbla'u̱kwak chköke inuköl shtökwakpa ena pë' sulusipa skà ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús tö ittsé ta̱ ichéitö ia̱rak: —Wé̱pa kë̀ kirirku̱' esepa kë̀ ki̱ s'kapeyökwak kiane. Erë wé̱pa kirirke, esepa ki̱ ikiane. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Skëköl tö iyë' iyëkkuö ki̱: ‘Iyiwak jchëule mè ye' a̱, ese kë̀ kiane ye' ki̱. Ye' ki̱ ikiane tö a' ñì sa̱ù̱ e̱r sia̱rë wa.’ A' e̱' yuö́ ttè e' wa. Ye' kë̀ dë'bitu̱ wé̱pa e̱' ttsö̀ tö ie'pa se̱r buaë yësyësë esepa kiök ye' ttökataie; ye' dë'bitu̱ pë' sulusipa kiök ye' ttökataie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan S'wöskuökwak ttökatapa de Jesús ska' ta̱ ichakérakitö ie' a̱: —Sa' ena fariseowakpa batsöke tai̱ë. ¿Ì kue̱ki̱ be' ttökatapa kë̀ batsö̀? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús tö ie'pa iu̱té: —Mik s'kiule ulabatsè ese ké̱wö tkö'u̱k ta̱ ¿we̱s ie'pa e̱riarmi wëm ulabatske e' tso'ia̱ ie'pa ta̱ e' dalewa? Erë iké̱wö döraë eta̱ ie' miratse̱r ie'pa yöki̱. E' je' ta̱ ie'pa batsöraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kë̀ yi tö datsi' këchke wöyuepawa̱ datsi'tak pa̱'a̱li̱ wa. Datsi'tak pa̱'a̱li̱ wöklöneka̱, e' tö datsi' këchkela shu̱kue̱e̱ke ta̱ ikí̱ jcheeke tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ñies vino kë̀ tërta̱'ka̱ iyiwak kkuölit yöule ibloie ese këchke a̱. Itéka̱sö es, e' ta̱ mik ibacha'nebitu̱, eta̱ ikkuölit këchke jchèemiitö. Es vino ena ikkuölit weirwami ë́me. E' kue̱ki̱ vino tekeka̱ ikkuölit pa̱'a̱li̱ a̱, es vino ena ikkuölit kë̀ weirpawa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús tso'ia̱ ttök, e' dalewa judiowak wökir debitu̱ eköl ie' ska' ta̱ ie' e̱' tkéwa̱ kuchë ki̱ ta̱ ichéitö: —Ñiköl ye' alà busi blënewa̱. Erë be' shkö́, be' ulà múka̱ iki̱ ta̱ ishke̱rdaka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús e̱' kéka̱ ta̱ imía̱ ittökatapa ta̱ judiowak wökir itöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","E' shu̱a̱ alaköl eköl dewa̱ tsi̱net Jesús tsi̱ kke̱r. E' du'mi alakölpa duè wa̱ e' ki̱ duas de dabom eyök ki̱ bök (12). Ie' tö ibikeitseke: “Jesús datsi' bata ë̀ kéwa̱yö, e' ta̱ ye' buanene.” E' kue̱ki̱ idatsi' bata kéwa̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Erë Jesús wötrée ta̱ isué̱itö ta̱ ichéitö ia̱: —A alà busi, be' e̱r kuú̱. Be' e̱rblé ye' mik, e' kue̱ki̱ be' buanene. E' wösha̱ ta̱ ie' buanene buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mik Jesús de Jairo u a̱, eta̱ ie' tö isué̱ tö ma'ma bla'u̱kwakpa detke s'nu blërketke e' kue̱ki̱, ñies pë' i̱u̱ke tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ie' tö ie'pa a̱ iché: —A' e̱' yö́lur, busila kë̀ du'wa̱, ikapöme'r ë̀. Ie'pa tö Jesús ja̱ñeitséka̱ tai̱ë, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","erë ie' tö ie'pa ké e̱' skökmi bánet. E' ukuöki̱ ta̱ ie' dewa̱ we̱shke̱ ta̱ busila ulà klö'wé̱wa̱itö ta̱ busila e̱' kéka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","E' tté buneka̱ ká̱ e' ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús e̱' yéttsa̱ ee̱ ta̱ wëpa böl kë̀ wöbla wawër mirwa̱ ie' itöki̱, e'pa a̱rke: —¡A Jesús, s'blú David bak e' aleri, sa' sa̱ú̱ e̱r sia̱rë wa! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mik Jesús de u a̱, eta̱ ie'pa böl de ie' ska'. Ie' tö ie'pa a̱ ichaké: —¿A' tö iklö'wé̱ tö ye' a̱ a' buarmine? Ie'pa tö iiu̱té: —A këkëpa, tö́, sa' tö iklö'wé̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Eta̱ Jesús tö ie'pa wöbla ké ta̱ ichéitö ie'pa a̱: —We̱s a' e̱rblöke ye' mik es iwà o̱rdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Eta̱ ie'pa wöbla buanene. Ta̱ Jesús tö iché ie'pa a̱: —Kë̀ a' kàne ichök yi a̱ yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Erë ie'pa míyal ta̱ ì wé̱ Jesús tö e' paké ie'pa tö ká̱ e' wakpa ulitane a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wëpa böl wöbla buanene e'pa míyal, e' bet ta̱ pë' we̱lepa wa̱ wëm kë̀ tto, ese debitu̱ eköl Jesús ska', e' a̱ aknama tso'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mik Jesús tö aknama trë'wé̱shkar, eta̱ wëm ttéka̱ne buaë. Pë' tso' ee̱ e'pa tkirulune ta̱ ichérakitö: —Kë̀ yi wa̱ íyi wí̱se su̱ule Israel aleripa shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Erë fariseowakpa tö iché: —Bë́, e' wák diché wa ie' tö ie'pa trë'wé̱yal. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús shköke ká̱ ko̱s tso' Galilea blublu ñies tsitsir e' a̱. Ie' s'wöbla'we̱ke judiowak ñì dapa'wo̱ wé ko̱s tso' e' a̱. Ì blúie Skëköl tso' e' tté buaë pakekeitö. Ñies s'kirirke ko̱s, idalërke s'mik ko̱s, e' bua'we̱keitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ie' tö isué̱ tö ie'pa e̱riarke sia̱rë, weinetke sia̱rë we̱s obeja kë̀ kkö'nukwak ta̱' es, e' kue̱ki̱ ie'pa sué̱itö e̱r sia̱rë wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ie' tö iché ittökatapa a̱: —Moki̱, ye' a̱ ta̱ ie'pa dör we̱s iyiwö tso'tke wë'ià̱ë shtè es, erë ishtökwakpa kë̀ dör tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","E' kue̱ki̱ a' tö ikiö́ kanè wák a̱ tö ishtökwakpa patkö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús tö ittökatapa dabom eyök kí̱ böl (12), e'pa kié e̱' ska' ta̱ ka̱wö méitö ie'pa a̱ wimblupa sulusi trë'wo̱yal ñies s'kirirke duè ulitane wa̱ esepa bua'wo̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ie'pa ekkëpa dör ñies Jesús ttekölpa tsá̱, e'pa kiè i' es: ke̱we dör Simón, e' kiè ñies Pedro ena ie' ël kiè Andrés; Santiago ena iël kiè Juan, ie'pa dör Zebedeo ala'r; ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe ena Bartolomé; Tomás ena Mateo dör inuköl shtökwak Roma wökirpa a̱ e'; Santiago dör Alfeo alà, ena Tadeo; ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón Celote ena Judas Iscariote tö Jesús wömekettsa̱ aishkuö ta̱ ibolökpa a̱ e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Wëpa dabom eyök kí̱ böl (12), ñe'pa patkémi Jesús tö ta̱ ipattéitö i' es: “Kë̀ a' minuk pë' kë̀ dör judiowak esepa ká̱ a̱. Ñies kë̀ a' minuk Samaria. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","A' yú Israel aleripa ká̱ a̱, ie'pa dör we̱s obeja chöwa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","A' yú ipakök tö ì blúie Skëköl tso' e' ké̱wö dewa̱tke. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","S'kirirke bua'ú̱ne, s'duowa̱ shke̱'ú̱ka̱ne, s'kiri'we̱ke lepra tö, esepa bua'ú̱ne a̱s ibatse'rne. Ñies aknamapa yö́ttsa̱. E' diché mène a' a̱ ë́me, e' kue̱ki̱ kë̀ yi ña'wa̱r iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“Kë̀ ì tsa̱rmi. A' kë̀ ka̱wö ta̱' inuköl tsu̱kmi yës. Ñies sku', datsi' skà, klökkuö, shko kéli ese ko̱s kë̀ tsa̱rmi. Kaneblökwak chkö̀mi ì kanewe̱keitö e' ské wa, e' kue̱ki̱ kë̀ ì tsa̱rmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mik a' demi ká̱ tsitsir ö ká̱ blublu a̱, eta̱ yi tö a' kièwa̱mi e̱r bua' wa ese yulö́. Mik a' ikué̱, eta̱ e' ë̀ u a̱ a' kapö́rö a' tso' ee̱ e' dalewa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mik a' dewa̱ u e' a̱, eta̱ ie'pa ko̱s se̱rke ee̱ e'pa shke̱'ú̱ e̱r bua' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ie'pa tö a' kiéwa̱ e̱r bua' wa, e' ta̱ Skëköl e̱r buaë chöraë ie'pa a̱. Erë ie'pa kë̀ wa̱ a' kinewa̱ e̱r bua' wa, e' ta̱ kë̀ Skëköl e̱r buaë chö̀pa ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","U we̱le wakpa ö ká̱ we̱le wakpa kë̀ wa̱ a' kinewa̱ buaë ö kë̀ é̱na a' ttö̀ ttsak, e' ta̱ a' e̱' yö́lur u e' a̱ ö ká̱ e' a̱ ta̱ ka̱po tso' a' klöttö mik e' ppö́ö iwà kkachoie ie'pa a̱ tö ie'pa dör Skëköl bolökpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Moki̱, ye' tö a' a̱ ichè tö aishkuö ta̱ mik a' wöchakirketke a' nuì̱ ki̱, eta̱ ká̱ e' wakpa wömerdattsa̱ weinuk tai̱ë Sodoma ena Gomorra wakpa bak se̱nuk suluë e'pa tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“¡Ye' ttö̀ ttsö́! Ye' tö a' patkekemi pë' shu̱a̱ we̱s obejala èmi namu tso' tai̱ë, e' shu̱a̱ es. E' kue̱ki̱ a' se̱nú wösh wa we̱s tkabë̀ es; erë ñies a' se̱nú bë̀rë we̱s nuböl es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","A' tso' e̱rki̱. A' miraë ie'pa wa̱ s'shu̱lökwakpa ulà a̱, ñies a' burdaë sia̱rë judiowak ñì dapa'wo̱ wé a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ie'pa wa̱ a' miraë duèse̱r s'wökirpa ena s'blúpa wörki̱ ye' tté kue̱ki̱. Es a' tö ye' tté pakeraë ie'pa a̱, ñies ká̱ ulitane wakpa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mik ie'pa tö a' méttsa̱ s'shu̱lökwakpa ulà a̱, eta̱ kë̀ a' tkinuk ì chèmi a' tö e̱' tsa̱tkoie. E' wösha̱ ta̱ Skëköl tö ttè eraë a' e̱r a̱ chè ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Es kë̀ a' ttö̀pa a' wák e̱r wa, e' skéie S'yë́ Wiköl tö ttè eraë a' e̱r a̱ chè. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mik e' ké̱wö de, eta̱ we̱lepa tö iël wömerattsa̱ ttèwa̱, iyë́ tö ilà wömerattsa̱, ñies ala'r e̱' köraka̱ iyë́ ena imì kkatök a̱s ittö̀wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sulitane tö a' sue̱raë suluë ye' tté kue̱ki̱. Erë a' isie e̱' tkéwa̱ darërëë döka̱ bata ekkë, e' tsa̱tkërdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mik ie'pa tö a' we'ikeke ká̱ we̱le ki̱, eta̱ a' tkö́shkar iyöki̱, a' yú ká̱ kua̱'ki̱ a̱. Moki̱ ye' tö a' a̱ ichè tö ka̱m ye' dör S'ditsö Alà e' döne, e' yöki̱ a' kë̀ dö̀pa Israel ké̱ ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Wé̱ wöblarke e' kë̀ dör iwöbla'u̱kwak tsa̱ta̱. Ñies kanè méso kë̀ dör iwökir tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","E' dör wë' wé̱ wöblarke e' a̱ tö idö̀ we̱s iwöbla'u̱kwak es. Ñies e' dör wë' kanè méso a̱ tö idö̀ we̱s iwökir es. U wökir kiérakitö Beelzebú ¡e' yita̱ iyamipa cherarakitö suluë! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“E' kue̱ki̱ kë̀ a' suanuk ie'pa yöki̱. Kë̀ ì ku̱' blëulewa̱ e' kë̀ kkayërpa aishkuö ta̱, ese ko̱s jche̱rdane. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ì chéyö a' a̱ akir bë̀rë, e' chö́ne sulitane kukua. Ñies ì ko̱s chéyö bë̀rë asas a' kukuö̀ a̱, e' chö́ne a̱neule sulitane a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kë̀ a' suanuk yi tö s'tteta̱'wa̱ esepa yöki̱. Ie'pa tö s'chkà ë̀ ttèwa̱mi erë ie'pa kë̀ a̱ s'wiköl duökwa̱. E' skéie Skëköl yöki̱ a' suanú. Ie' tö s'chkà ñies s'wiköl e̱wè̱wami bö' ké̱ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Dúla böt tuè̱ tottola inuköl etk wöshkila ë̀, erë dúla kë̀ a̱rta̱'wa i̱ski̱ S'yë́ kë̀ wa̱ iké̱wö mène e' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","E' yita̱ a' kkö'neraëitö buaë dö̀ a' tsa̱kö bitö tso' shta̱o̱ule ie' wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ie' a̱ ta̱ a' tuè̱ tai̱ë tkö̀ka̱ dúla tso' tai̱ë ese tsa̱ta̱. E' kue̱ki̱ kë̀ a' suanuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Yi e̱' chö̀ sulitane wörki̱ tö ie' dör ye' ttökata, e' ta̱ ñies ese cheraëyö ye' Yë́ tso' ká̱ jaì a̱ e' wörki̱ tö ie' dör ye' ttökata. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Erë yi tö iblé s'male̱pa wörki̱ tö ie' kë̀ dör ye' ttökata, e' ta̱ ñies ibleraëyö ye' Yë́ tso' ká̱ jaì a̱ e' wörki̱ tö ie' dör ye' ttökata. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kë̀ a' tö ibikeitsök tö ye' dë'bitu̱ a̱s a' se̱r bë̀rë ñita̱ ká̱ i' ki̱. Ye' kë̀ dë'bitu̱ a̱s a' se̱r bë̀rë ñita̱, e' skéie ye' dë'bitu̱ a' mukka̱ ñippök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ye' dë'bitu̱ a̱s ilà wëm ñippö̀ iyë́ ta̱, a̱s ilà busi ñippö̀ imì ta̱ ena a̱s iyàk ñippö̀ iyàk ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Es yamipa e̱kka döraë ñì bolökpaie ye' tté kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Yi é̱na iyë́ ö imì dalër tkö̀ka̱ ie' é̱na ye' dalër e' tsa̱ta̱, ese kë̀ dö̀pa ye' ttökataie. Ñies yi é̱na ilà wëm ö ilà busi e' dalër tkö̀ka̱ ie' é̱na ye' dalër e' tsa̱ta̱, ese kë̀ dö̀pa ye' ttökataie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yi kë̀ e̱' chö̀ weinuk dö̀ ittèwa̱ krus mik ta̱ ise̱r we̱s ye' ttökata es, ese kë̀ dö̀pa ye' ttökataie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yi e̱' tsa̱tkak ittèwa̱ yöki̱, ese kë̀ ulà a̱ se̱ne michoë dö̀pa. Erë yi e̱' mettsa̱ ttèwa̱ ye' dalërmik, ese ulà a̱ se̱ne michoë döraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Yi tö a' kiéwa̱ e̱r bua' wa, e' dör we̱s ye' kiéwa̱itö e̱r bua' wa es. Ñies yi tö ye' kiéwa̱ e̱r bua' wa, e' dör we̱s yi tö ye' patkë' e' kiéwa̱itö e̱r bua' wa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yi tö Skëköl tteköl kiéwa̱ e̱r bua' wa Skëköl tteköl idir e' kue̱ki̱, e' ta̱ ese a̱ ì meraë Skëköl tö ittekölpa a̱, ese merdaë ñies. E' sù̱ yi tö s'se̱r yësyësë ese kiéwa̱ e̱r bua' wa ise̱rke yësyësë e' kue̱ki̱, e' ta̱ ese a̱ ì meraë Skëköl tö s'se̱r yësyësë esepa a̱, ese merdaë ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yi isie tö di' kakla ë̀ mé ye' ttökata ësela a̱ yè, ye' ttökata idir e' kue̱ki̱, e' ta̱ moki̱ ye' tö a' a̱ ichè tö ese a̱ iské pato̱rdaë buaë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mik Jesús tö ittökatapa dabom eyök ki̱ böl (12) e'pa wöbla'wé̱ o̱ne, eta̱ ie' mía̱ ká̱ tso' tsi̱net ese a̱ s'wöbla'u̱k ena Skëköl ttè buaë e' pakök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan S'wöskuökwak tso' wötëule s'wöto wé a̱, ee̱ ie' tö ì we̱ke Cristo tö e' tté ttsé. E' kue̱ki̱ ie' tö ittökatapa we̱lepa patké iska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ie'pa tö ichaké ia̱: “¿Be' dör wé̱ pairine'bitu̱ idi' wa s'blúie yëule idatse̱ e' ö yi skà panèia̱ sa' tö?” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús tö ie'pa iu̱té: “A' yúne Juan ska' ta̱ ì ko̱s sué̱ a' tö, ì ko̱s ttsé a' tö, e' pakö́ne ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ipakö́ ie' a̱ tö s'wöbla kë̀ wawër, esepa wöbla wawënene; s'kraulewa̱ kë̀ shko, esepa shkéne; wé̱pa kiri'we̱ke lepra tö, esepa buanene batse'nene; s'kukuö̀ kë̀ wattsër, esepa wattsënene; s'duowa̱ shke̱neka̱ne; ñies Skëköl ttè buaë e' pakane s'sia̱rëpa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Yi kë̀ yöki̱ ye' sulune, ayëcha buaë ese!” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mik ie'pa míyalne, eta̱ Jesús tö Juan tté pakémitke pë' a̱, ta̱ iché ie'pa a̱: “Mik a' dë'rö ká̱ sir poë wé̱ kë̀ yi se̱rku̱' ee̱ Juan sa̱u̱k, eta̱ ¿i̱ma a' e̱rbikö̀ wëm wé̱se suè̱mi a' tö? A' kë̀ dë'rö wëm ëse, ka̱bikeitsö̀ wì̱ a̱ dià a̱ we̱s kua'kö wöppè siwa̱' tö es, ese sa̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","A' kë̀ dë'rö wëm ese sa̱u̱k, e' ta̱ ¿wëm wé̱se sa̱u̱k a' dë'rö? A' kë̀ dë'rö wëm e̱' paiö̀ datsi' bua'bua wa ese sa̱u̱k. A' wa̱ ijche̱r tö wé̱pa e̱' paiö̀ es esepa se̱rke blu' u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Erë ¿wëm wé̱se sa̱u̱k a' dë'rö? A' dë'rö wëm dör Skëköl tteköl ese sa̱u̱k. Ye' tö a' a̱ ichè tö moki̱ Juan dör Skëköl tteköl, erë ie' kë̀ dör ese ë̀. Ie' dör Skëköl tteköl tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Skëköl yëkkuö ki̱ itso' kitule wé̱ Skëköl tö ichè wé̱ pairi'bitu̱itö idi' wa s'blúie e' a̱: ‘Ye' tso'tke ye' ttè pakökwak patkök be' yöki̱ ke̱we be' ñalé̱ yuök.’ Skëköl ttè pakökwak e' dör Juan. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Moki̱, ye' tö a' a̱ ichè tö s'ditsö ulitane tso'tke dö̀ ikkë ta̱, e'pa shu̱a̱ kë̀ yi ku̱' Juan S'wöskuökwak tsa̱ta̱. Erë ì blúie Skëköl tso' e' a̱ wé̱ dör ësela shu̱te̱ë e' dör Juan tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Mik Juan S'wöskuökwak s'tsá̱ pautmi dö̀ ikkë ta̱, wé̱pa blúie Skëköl tso' esepa weirke sia̱rë. Pë' kësik suluë esepa é̱na ie'pa e̱wa̱kwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ka̱m Juan tö s'pattö̀mi e' yöki̱ Skëköl ttekölpa ko̱s ena Moisés, e'pa tö iyë'bak tö Skëköl datse̱ se' blúie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A' é̱na iklö'wa̱k es, e' ta̱ Juan dör Skëköl tteköl kiè Elías yëuletke tö idatskene e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡A' é̱na ye' ttö̀ ttsak, e̱'ma ikukueblö́ bua'ie! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿I̱ma a' chèmi ye' tö? ¿We̱s a' dör? A' dör we̱s ttè i' tö ichè es: Ala'rla tso' inuk u itöki̱. Sha̱bötspa a̱rke tai̱ë ta̱ icheke iyamipa a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Sa' tö pulë bla'wé̱, erë a' kë̀ klötëne'; sa' tö s'e̱riar ttseittsé, erë a' kë̀ i̱i̱ne'.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","E' wà dör tö Juan de batsöta̱', blo' kë̀ yöta̱', ta̱ a' tö iché tö aknama tso' ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","E' ukuöki̱ ta̱ ye' dör S'ditsö Alà, e' de kë̀ batsöta̱', blo' yeta̱', ta̱ a' ye' cheke tö ye' chkö̀ tai̱ë, ye' blo' yè tai̱ë ñies tö ye' dör inuköl shtökwakpa ena pë' sulusipa male̱pa, esepa sini'. A' tö ye' cheke es, erë isue̱rasö bulebök ta̱ tö wé̱pa se̱rke we̱s Skëköl siwé̱ tö ichè es esepa dör yësyësë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Eta̱ ká̱ wé̱pa ki̱ Jesús tö ì kë̀ o̱r yi a̱ ese o̱' tai̱ë ká̱ male̱pa tsa̱ta̱, e' wakpa kë̀ e̱r maneo̱ne Skëköl a̱. E' kue̱ki̱ ie' tö ie'pa ché ttè i' wa: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“A Corazín wakpa, a Betsaida wakpa, ¡wëstela i̱na a' ta̱! Ì kë̀ o̱r yi a̱ ese o̱' ye' tö tai̱ë a' wörki̱, erë a' kë̀ e̱r maneo̱ne. E' ú̱pa ye' tö Tiro ena Sidón wakpa wörki̱, e̱'ma ká̱ ia̱ia̱ë ie'pa e̱r maneo̱'bak. Ie'pa tö e̱riane datsi' a̱ja̱ë ië'ka̱bak, ñies ie'pa e̱' tkë'ka̱bak mulu̱chka ki̱ iwà kkachoie tö ie'pa e̱r mane'wé̱ Skëköl a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","E' kue̱ki̱ ye' tö ichè tö aishkuö ta̱ mik a' wöchakirketke a' nuì̱ ki̱, eta̱ a' wömerdattsa̱ weinuk tai̱ë shu̱te̱ Tiro ena Sidón wakpa tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A Cafarnaúm wakpa, kë̀ a' tö ibikeitsök tö Skëköl wa̱ a' mi'mitse̱r ká̱ jaì a̱. Ie' tö a' patkerami diöshe̱t wé̱ s'wimblu weirke ee̱. Ì kë̀ o̱r yi a̱ ese wé̱yö tai̱ë a' wörki̱, erë a' kë̀ e̱r maneo̱ne. E' ú̱pa ye' tö Sodoma wakpa suluë wörki̱, e̱'ma ie'pa tso'ia̱ dö̀ ikkë ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","E' kue̱ki̱ ye' tö ichè tö aishkuö ta̱ mik a' wöchakirketke a' nuì̱ ki̱, eta̱ a' wömerdattsa̱ weinuk tai̱ë shu̱te̱ Sodoma wakpa tsa̱ta̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Eta̱ Jesús tö iché: “A ye' Yë́, be' dör íyi ulitane tso' ká̱ jaì a̱ ena ká̱ i' a̱ e' Këköl. Ttè buaë blë'wa̱ be' tö pë' wa̱ siwa̱' jche̱r i̱ski̱ë ena e̱rbikö̀ tai̱ë esepa yöki̱, erë ikkachébö s'ësepala a̱. Es be' ki̱ ikiane, e' kue̱ki̱ be' tö iwé̱ es. E' kue̱ki̱ be' ki̱kéka̱yö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesús tté iYë́ ta̱ o̱ne ta̱ ichéitö pë' tso' ee̱ e'pa a̱: “Ye' Yë́ tö íyi ulitane méa̱t ye' ulà a̱. Ye' dör Skëköl Alà, kë̀ yi wa̱ ijche̱r moki̱ tö we̱s ye' dör, e' jche̱r ye' Yë́ ë̀ wa̱. Ñies kë̀ yi wa̱ ijche̱r moki̱ tö we̱s ye' Yë́ dör, e' jche̱r ye' ë̀ wa̱. Ñies wé̱pa a̱ ye' é̱na ikkachak esepa wa̱ ijche̱rmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","A' e̱riarke tai̱ë, weirke sia̱rë íyi ulitane diki̱a̱ we̱s dalì e̱kke̱ë diki̱a̱ s'shtrirwa̱ es. A' shkö́ ye' ska', eta̱ a' e̱nuraë ye' batamik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Ye' se̱r bë̀rë, ye' e̱r buaë, e' kue̱ki̱ a' e̱' tiú̱wa̱ ye' ttè diki̱a̱. Ttè wa ye' tö a' wöbla'we̱ke, e' kë̀ dör darërëë, e' kë̀ tö a' we'ikepa we̱s. E' kue̱ki̱ a' e̱' wöbla'ú̱ ye' wa ta̱ a' e̱nuraë buaë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","E' ké̱wö ska' ta̱, e̱no diwö a̱, Jesús dami trigo shu̱a̱ ta̱ ittökatapa dué bli wa̱. E' kue̱ki̱ ie'pa tö trigo wöiklérami ta̱ ikatéramirakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mik fariseowakpa tö isué̱, eta̱ ie'pa tö iché Jesús a̱: —Isa̱ú̱, be' ttökatapa tso' ì kë̀ ké̱wö ta̱' wè̱ e̱no diwö a̱, ese u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ie' tö ie'pa iu̱té: —Ì o̱' David tö ká̱ ia̱ia̱ë ¿e' kë̀ a̱ritsule a' wa̱ Skëköl yëkkuö ki̱? Etökicha ta̱ ie' ena iklépa dué bli wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","E' kue̱ki̱ ie' dewa̱ Skëköl wé a̱ ta̱ pan meule Skëköl a̱ e' klö'wé̱itö ta̱ iñéitö. Pan e' kë̀ ké̱wö ta̱' ñè ie' ena iklépa a̱, sacerdotepa ë̀ a̱ iké̱wö ta̱' ñè. Erë a' é̱na ia̱ne tö e' kë̀ dör suluë Skëköl wöa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ñies ¿a' kë̀ wa̱ ia̱ritsule ttè dalöiëno kit Moisés tö e' ki̱ tö erë́ sacerdotepa kaneblöke Skëköl wé a̱ e̱no diwö a̱, erë e' kë̀ wa ie'pa tö idalöse̱we̱ku̱'wa̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ye' tö ichè a' a̱ tö í̱e̱rö se' dur eköl, e' dör Skëköl wé tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Skëköl tö iyë' iyëkkuö ki̱: ‘Iyiwak jchëule mè ye' a̱, e' kë̀ kiane ye' ki̱. Ye' ki̱ ikiane tö a' ñì sa̱ù̱ e̱r sia̱rë wa.’ Ttè e' wà a̱núpa a' é̱na moki̱ë, e̱'ma kë̀ s'ki̱ ì nuí̱ ta̱' ese kë̀ kkatepa a' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ye' dör S'ditsö Alà, e' wa̱ ka̱wö ta̱' ichök tö ì dör buaë ö ì dör suluë wè̱ e̱no diwö a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","E' ukuöki̱ ta̱ Jesús dewa̱ ie'pa ñì dapa'wo̱ wé a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Eta̱ ee̱ wëm tkër eköl ulà etk siulewa̱. Ie'pa é̱na Jesús kkatak ilè ki̱ e' kue̱ki̱ ie' a̱ ichakérakitö: —¿I̱ma be' tö ibikeitsè? ¿Ka̱wö meule se' a̱ Moisés ttè a̱ s'bua'wo̱ne e̱no diwö a̱ ö au? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ie' tö ie'pa iu̱té: —A' obeja a̱nemi etö ka̱uk a̱ e̱no diwö a̱, e' ta̱ a' miraë iyöktsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","E' yita̱ se' tue̱ta̱' tai̱ë obeja tsa̱ta̱, e' kue̱ki̱ ka̱wö tso' se' a̱ s'ki̱moie e̱no diwö a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Eta̱ ie' tö iché wëm ulà siulewa̱ e' a̱: —Be' ulà shu̱lö́ö. Ta̱ ie' ulà shu̱lée ta̱ ibuanene buaë we̱s iulà iët es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseowakpa e̱' yéttsa̱ ta̱ ileritsérakitö “¿we̱s sö Jesús ttèwa̱mi?” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","E' jche̱newa̱ Jesús wa̱, e' kue̱ki̱ ie' mía̱ bánet. Tai̱ë pë' dami ie' itöki̱ e'pa shu̱a̱ ikirirkerak e'pa ko̱s bua'wé̱ne ie' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ie' tö iché ie'pa a̱: —Kë̀ ye' tté pparka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ie' tö iché ie'pa a̱ es a̱s iwà tkö̀ we̱s Skëköl tteköl kiè Isaías tö iyë' es, e' tö iyë' i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Skëköl tö ichè: “I' dör ye' kanè méso shu̱kit ye' tö, e' dalër tai̱ë ye' é̱na, ie' wër ye' wa buaë shu̱te̱. Ye' Wiköl meraëyö ie' a̱, ta̱ ie' tö se̱ne yësyësë wà pakeraë ká̱ ulitane wakpa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ie' se̱rdaë bë̀rë. Kë̀ yi wöñaktkepa ie' tö. Kë̀ ì chepa ie' tö a̱neule. Kë̀ yi tö ie' ttö̀ ttsepa ñala̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","S'weirke sia̱rë, esepa kë̀ kí̱ we'ikepa ie' tö, Se' kë̀ diché ta̱'ia̱ esepa ki̱meraë ie' tö dö̀ mik ie' e̱' alöraka̱ ì sulu ko̱s ki̱ se̱ne yësyësë wa eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ká̱ ulitane wakpa tö ie' ë̀ paneraë e̱' tsa̱tkoie.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Eta̱ ie'pa wa̱ wëm eköl a̱ aknama tso' ese debitu̱ Jesús ska', e' kë̀ wöbla wawër, kë̀ tto. Jesús tö ibua'wé̱ne ta̱ iwöbla wawënene ñies ittéka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ie'pa ko̱s tkirulune iweblök ta̱ iñi chakérak: “¿A' ichè wí̱ dör s'blú bak David, e' aleri?” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mik ì ché ie'pa tö, e' ttsé fariseowakpa tö, eta̱ ie'pa tö iché: “Beelzebú dör bë́, e' diché wa ie' tö ie'pa trë'we̱keyal.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Erë ì bikeitseke ie'pa tö e' sué̱wa̱itö, e' kue̱ki̱ ie' tö iché ie'pa a̱: “S'se̱rke ká̱ etkë̀ ki̱ e' ñì blabatsélor ñippök ñita̱, kë̀ wöklör, e' ta̱ ie'pa wákpa ë̀ ñì e̱u̱rawa. Ñies ñì yamipa e̱' kéka̱ ñippök ñita̱, kë̀ wöklör, e' ta̱ ie'pa mir wa'k ë̀me. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Es ñies Satanás mú tö iklépa trë'wè̱yal, e' ta̱ ie' tso' ñippök iwakpa ë̀ ta̱. ¿We̱s ì blúie ie' tso' e' se̱rmiia̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ye' tö aknamapa trë'ú̱payal Beelzebú diché wa, e' ta̱ ¿yi diché wa a' klépa tö itrë'wè̱miyal? Ie'pa kë̀ a̱ itrënukyal Beelzebú diché wa, e' kue̱ki̱ ¿we̱s a' tö ye' kkatèmi tö ye' tö itrë'we̱keyal Beelzebú diché wa? A' wák klépa tö iwà kkacheraë tö a' ttè kë̀ dör moki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ye' tö aknamapa trë'wé̱yal Skëköl Wiköl diché wa, e' ta̱ e' wà kiane chè tö ì blúie Skëköl tso', e' ké̱wö detke a' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“¿We̱s yi mi'miwa̱ wëm diché tai̱ë ese u a̱ ie' íyi ekiblök ka̱m ie' tö iwák maù̱wa̱ e' yöki̱? Es ë̀me iíyi ekiblërmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Yi kë̀ a̱ ye' dör bua', ese dör ye' bolök. Yi kë̀ tö ye' ki̱mè imale̱pa tsu̱kbitu̱ Skëköl ska', ese tö ie'pa po'we̱kemi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“E' kue̱ki̱ ye' tö ichè tö ì sulu ko̱s wambleke a' tö ñies Skëköl chè sulu ko̱s e' nuí̱ olo'yèmiitö a' ki̱. Erë yi tö Wiköl Batse'r ché suluë, e' nuí̱ kë̀ olorpa iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ñies yi tö ye' dör S'ditsö Alà, e' ché suluë, e' nuí̱ olo'yèmi Skëköl tö iki̱. Erë yi tö Wiköl Batse'r ché suluë e' nuí̱ kë̀ olorpa iki̱ i̱'ñe ta̱ ñies aishkuö ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kal wërkewa̱ iwö ki̱. Kal buaë, ese wö dör buaë; kal sulu, ese wö dör sulu. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡A' dör suluë we̱s tkabë̀ chö́k es! A' e̱r dör suluë, ¿we̱s a' ttö̀mi buaë? Ì bikeitsekesö, e' ë̀ chekesö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wëm dör buaë ese se̱rke buaë, ttö̀ yësyësë ie' e̱r dör buaë e' kue̱ki̱. Wëm dör suluë, ese se̱rke suluë, ttö̀ suluë ie' e̱r dör suluë e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ye' tö a' a̱ ichè tö aishkuö ta̱ mik a' wöchakirketke a' nuì̱ ki̱ e' ké̱wö de, eta̱ ttè sulu chè a' ulitane tö shabatshabat e' ki̱ a' wöchakirdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","A' wakpa ttè wa a' shu̱lirdaë. A' tö ttè buaë cheke, e' ta̱ Skëköl tö icheraë tö kë̀ a' ki̱ ì nuí̱ ta̱'. Erë a' tö ttè sulu cheke, e' ta̱ ie' tö icheraë tö a' ki̱ nuì̱ tso'.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Eta̱ fariseowakpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa we̱lepa tö iché Jesús a̱: —Ì kë̀ o̱r yi a̱ ese ú̱ sa' a̱ iwà kkachoie tö moki̱ be' patkë'bitu̱ Skëköl tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ie' tö ie'pa iu̱té: —A' dör pë' suluë e' kë̀ tö Skëköl dalöiè we̱s trër wakpa kë̀ tö imaso dalöiè es. A' tö ye' a̱ ikié tö ì kë̀ o̱r yi a̱ ese u̱yö iwà kkachoie tö moki̱ Skëköl tö ye' patkë'bitu̱. Erë ye' tö ilè we̱raë etökicha ë̀me iwà kkachoie e' dör we̱s ibak Jonás dör Skëköl tteköl e' ta̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ie' se̱ne' nima bërie e' shu̱a̱ döka̱ ká̱ mañat ñië nañeë, es ñies ye' dör S'ditsö Alà, e' se̱rdaë íyök shu̱a̱ ká̱ mañat ñië nañeë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mik Jonás tö Nínive wakpa paut, eta̱ ie'pa e̱r maneo̱' Skëköl a̱. Erë i̱'ñe ta̱ ye' dur í̱e̱ e' dör ie' tsa̱ta̱, erë a' kë̀ e̱r mane'ù̱ Skëköl a̱. E' kue̱ki̱ aishkuö ta̱ mik a' wöchakirketke a' nuì̱ ki̱, eta̱ Nínive wakpa e̱' köraka̱ ie' wörki̱ a' kkatök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aishkuö ta̱ mik a' wöchakirketke a' nuì̱ ki̱, eta̱ alaköl datse̱ ká̱ bánet diwö tskirke e' o̱'mik, bak iká̱ blúie, e' e̱' köraka̱ ie' wörki̱ a' kkatök tö a' dör pë' suluë. Ká̱ ia̱ia̱ë alaköl e' dë'bitu̱ datse̱ ka̱mië se' blú bak Salomón wa̱ íyi jche̱r tai̱ë e' ttö̀ ki̱ttsök. Erë i̱'ñe ta̱ ye' dur a' shu̱a̱ e' dör Salomón tsa̱ta̱, erë a' kë̀ tö ye' ttö̀ iu̱tè. E' kue̱ki̱ alaköl e' tö a' kkateraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mik wimblu sulusi trëneshkar yile a̱, eta̱ imía̱ ká̱ sir poë wé̱ kë̀ yi ku̱' ese ska'. Ie' tso' ká̱ yulök se̱noie erë kë̀ ie' wa̱ iku̱ne. E' kue̱ki̱ ie' ibikeitsè: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Ye' mía̱ne wé̱ ye' trëneshkar ee̱ se̱nuk.’ Mik ie' demine wëm e' a̱, eta̱ ie' tö isué̱ tö wëm dör we̱s u shu̱iriule buaë maneneë kë̀ a̱ yi ku̱' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Eta̱ ie' mía̱ iyamipa kí̱ yulök döka̱ kul suluë shu̱te̱ ie' tsa̱ta̱ ta̱ ie'pa ko̱s de se̱nuk wëm e' a̱. Wëm e' mía̱ne suluë shu̱te̱ ke̱net tsa̱ta̱. Es iwamblërdaë a' dör pë' sulusipa e'pa ta̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús ttökeia̱ pë' ta̱ e' shu̱a̱ ie' mì ena iëlpa ena ikutapa e'pa iëte̱r u'rki̱. Ie'pa ttak ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yile tö ibiyö́ ché ie' a̱: —Be' mì ena be' ëlpa ena be' kutapa e'pa shkö̀ be' weblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Erë Jesús iiu̱té: —¿Yi dör ye' mì ena ye' ëlpa ena ye' kutapa? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eta̱ Jesús tö ie' a̱ ittökatapa kkaché ulà wa ta̱ ichéitö: —Isa̱ú̱, ie'pa dör we̱s ye' mì ena ye' ëlpa ena ye' kutapa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yi se̱rke we̱s ye' Yë́ tso' ká̱ jaì a̱ e' ki̱ ikiane es, esepa dör we̱s ye' ël ena ye' kutà ena ye' mì es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","E' ë̀ diwö wa Jesús e̱' yéttsa̱ u a̱ mía̱ batsöri kkömik ta̱ ee̱ ie' e̱' tkése̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pë' debitu̱ tai̱ë ie' ska', e' kue̱ki̱ ie' e̱' iéka̱ kanò a̱ ta̱ ee̱ ie' e̱' tkése̱r ie'pa wöbla'u̱k. Ie'pa ulitane a̱te̱ ká̱ sí ki̱ batsöri kkömik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ie' tö ttè tsa̱ki̱ë kleé ie'pa a̱. E' et dör i' es: “Wëm eköl mía̱ të kuatkök ppé ululu ë̀me ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mik ie' tso' iwö ppök, eta̱ ditsöwö we̱le a̱newa ñala̱ ska' ta̱ dù debitu̱ tö ikatéwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ditsöwö we̱le a̱newa áklo a̱ wé̱ íyök kë̀ ta̱' tai̱ë ese ska'. Íyök kë̀ ta̱' tai̱ë, e' kue̱ki̱ bet ta̱ itskineka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Erë kë̀ iwí kicha ta̱' tai̱ë, e' kue̱ki̱ mik dìba a̱neka̱ iki̱ eta̱ isinewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ditsöwö we̱le a̱newa dika'chka shu̱a̱. Dika'chka ena ditsöwö talane ñita̱, erë dika'chka e̱' aléka̱ iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Erë ditsöwö we̱le a̱newa íyök bua'bua ki̱, e' tskine talane wöne buaë. We̱le wöne döka̱ cien eyök (100) elka elka, we̱le dabom teryök (60), we̱le dabom mañayök (30). ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡A' é̱na ye' ttö̀ ttsak, e̱'ma ikukueblö́ bua'ie!” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Eta̱ Jesús ttökatapa debitu̱ ie' ska' ta̱ ichakérakitö ia̱: “¿Ì kue̱ki̱ be' tö ie'pa wöbla'we̱ke kleaule?” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ie' tö ie'pa iu̱té: “Ì blúie Skëköl tso' e' tté blëulewa̱ e' ké̱wö menea̱t a' a̱ wà jche̱noie, erë pë' male̱pa a̱ kë̀ imenea̱t es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yi wa̱ ttè e' jche̱r ese a̱ imerdaë a̱s ie' wa̱ ikí̱ jche̱r bua'ie. Erë yi kë̀ é̱na ia̱nak, ese wa̱ ì jche̱r bërëbërë e' yerattsa̱ne iyöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ì we̱ke ye' tö e' sue̱ke ie'pa tö, erë ie'pa kë̀ é̱na iwà a̱ne. Ì cheke ye' tö e' ttseke ie'pa tö, erë ie'pa kë̀ tö ittseku̱' e̱r moki̱ wa, ie'pa kë̀ é̱na iwà iu̱tak. E' kue̱ki̱ ye' ka̱paköke ie'pa ta̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Es iwà tköke ie'pa ta̱ we̱s Skëköl tteköl kiè Isaías tö iyë' es, e' tö iyë' i' es: ‘Ká̱ i' wakpa e̱r mía̱ darërë, kë̀ ì dë'wa̱ia̱. Ie'pa kukuöña wötéwa̱ darërë a̱s kë̀ iwattsër, ie'pa tö iwöbla tsi̱miwé̱wa̱ a̱s kë̀ iwawër. Ie'pa tö iwé̱ es a̱s ie'pa kë̀ é̱na iwà a̱r, a̱s ie'pa kë̀ e̱r mane'ù̱ ye' ska' ta̱ ye' tö ie'pa bua'wè̱. E' kue̱ki̱ ie'pa tö ittseraë je', erë kë̀ ie'pa é̱na iwà a̱rpa, ie'pa tö isue̱raë je', erë kë̀ ie'pa tö iklö'we̱pa.’ Es Isaías tö iyë'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Erë a' wöbla wawër buaë, a' kukuöña wattsër buaë, e' kue̱ki̱ ayëcha buaë a'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Moki̱ ye' tö a' a̱ ichè tö Skëköl ttekölpa tai̱ë ena ká̱ ia̱ia̱ë s'bak se̱r yësyësë e'pa tö ì sué̱ a' tö ena ì ttsé a' tö e' kkeyë' sia̱rë suè̱ ena ttsè, erë ie'pa kë̀ wa̱ isu̱ne ittsë̀ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ittsö́, ì kleéyö të kuatkökwak tté wa, e' wà pakekeyö a' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pë' we̱lepa ta̱ itkö̀mi we̱s ditsöwö a̱rwa ñala̱ ska' es. Esepa tö ì blúie Skëköl tso' e' tté ttsé, erë ie'pa kë̀ é̱na iwà a̱ne. Bë́ de ta̱ ttè buaë yéttsa̱ ie'pa e̱r a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","We̱lepa skà ta̱ itkö̀mi we̱s ditsöwö a̱rwa áklo a̱ es. Esepa tö Skëköl ttè ttsé ta̱ iklö'wé̱rakitö ttsë'ne buaë wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Erë ie'pa kë̀ wì kicha ta̱' tai̱ë, e' kue̱ki̱ ie'pa tö iklö'wé̱ ekuölö ë̀. Mik ie'pa weinemitke Skëköl ttè kue̱ki̱, eta̱ ie'pa a̱nemine bet. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","We̱lepa skà ta̱ itkö̀mi we̱s ditsöwö a̱rwa dika'chka shu̱a̱ es. Esepa tö Skëköl ttè ttsé, erë ie'pa tö íyi tso' ká̱ i' ki̱ ese bikeitseke kibiie. Ie'pa e̱r me'rie inuköl ki̱ ena ì tso' ká̱ i' ki̱ tö s'ttsë'we̱ke buaë ese ki̱. E' ko̱s tö Skëköl ttè kui'wé̱wa̱ ie'pa e̱r a̱ ta̱ kë̀ idë'ttsa̱ buaë we̱s ikiane es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Erë we̱lepa skà ta̱ itkö̀mi we̱s ditsöwö a̱rwa íyök bua'bua ki̱ es. Esepa je' tö Skëköl ttè ttsé ta̱ iwà a̱ne buaë ie'pa é̱na ta̱ iwà dettsa̱ buaë we̱s ikiane es. Ie'pa dör we̱s íyi kuá wör buaë es we̱le wöne döka̱ cien eyök (100), we̱le dabom teryök (60), we̱le dabom mañayök (30).” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús tö ttè skà kleéne ie'pa a̱ i' es: “Ì blúie Skëköl tso' e' ta̱ itköke we̱s itka wëm eköl tö trigowö kuatké iká̱ a̱ e' ta̱ itka es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nañewe ie'pa kapolur e' dalewa ibolök debitu̱ eköl ka̱kö dör trigo su̱ë ese wö kuatké trigo shu̱a̱ ta̱ iwák mía̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mik trigo wöne, eta̱ iwënewa̱ tö ñies ka̱kö kua̱'ki̱ tso'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ikanè mésopa mía̱ ta̱ iché kanè wák a̱: ‘A këkëpa, be' tö trigowö bua'bua kuatké be' ká̱ a̱ ta̱ ¿we̱s e' a̱ ka̱kö kua̱'ki̱ tso'?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ie' tö ie'pa iu̱té: ‘Ye' bolök we̱le tö iwamblé ye' ki̱.’ Ie'pa tö ie' a̱ ichaké: ‘¿Be' ki̱ ikiane tö sa' mi' ka̱kö ñe' yökulur?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Erë ie' tö ie'pa iu̱té: ‘Au, imúa̱t es. A' tö ka̱kö yéttsa̱ e' ta̱ trigo yërttsa̱mi ita̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Imúa̱t a̱s italar ñita̱ dö̀ mik itërketke eta̱. E' wa ye' tö itökwakpa patkeke ka̱kö tök ke̱we muè̱ eyök eyök ña'wè̱wa bö' a̱. E' ukuöki̱ ta̱ ye' tö trigowö tök patkeke blè wé̱ ye' iyiwö blöke e' wé a̱.’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ttè skà kleéne Jesús tö ie'pa a̱ i' es: “Ì blúie Skëköl tso' e' dör we̱s mostaza wö kuatkèsö ká̱ a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","E' wö dör tsirlala iyiwö ulitane diki̱a̱. Erë mik italane ta̱ e' dör íyi kuá tsitsir ulitane tsa̱ta̱. E' mía̱ kalie ta̱ dù datse̱ u yuök iulà tsa̱ka̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús tö ie'pa a̱ ttè skà kleéne i' es: “Ì blúie Skëköl tso' e' dör we̱s pan wölöwo̱ka̱ wötué tayë tö harinachka mañayök a̱ es. E' tö harinachka e' ko̱s wölöwé̱ka̱ tai̱ë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ttè e' ko̱s kleé Jesús tö ie'pa a̱. Moki̱ ie' kë̀ wa̱ ì pakane ie'pa a̱ kë̀ kleaule. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ie' tö s'wöbla'wé̱ es, e' wa ì yë'bak Skëköl tteköl eköl tö e' wà tka, e' dör i' es: “Ye' tö s'wöbla'we̱raë kleaule. Ttè tso' blëule ká̱ ia̱ia̱ë ká̱ i' yöne e'ta̱mi, ese kkacherayö ie'pa a̱.” Es Skëköl tteköl tö iyë'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Eta̱ Jesús e̱' chéa̱t pë' a̱ ta̱ imía̱ u a̱. Ittökatapa de ie' ska' ta̱ iché ie' a̱: “Ka̱kö kua̱'ki̱ wakleébö, e' wà pakö́ sa' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ie' tö ie'pa a̱ iché: “Yi tö trigowö kuatké, e' dör ye' dör S'ditsö Alà e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Të wé̱ ki̱ ikuatkëne e' dör ká̱ i'. Trigowö e' dör wé̱pa blúie Skëköl tso' esepa. Ka̱kö kua̱'ki̱ e' dör wé̱pa dör bë́ icha esepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ibolök tö ka̱kö kua̱'ki̱ kuatké e' dör bë́ ë̀. Ilir ké̱wö e' dör ká̱ i' e̱rkewatke e' ké̱wö. Itökwakpa e'pa dör Skëköl biyöchökwakpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","We̱s ie'pa tö ka̱kö kua̱'ki̱ yéttsa̱ u̱yéwa̱ bö' a̱, es itköraë ká̱ i' e̱rkewatke eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","E' ké̱wö ska' ta̱ ye' dör S'ditsö Alà e' döraë íyi ulitane blúie da'a̱ie. Ye' tö ye' biyöchökwakpa patkeraë wé̱pa tö o̱'ka keke ì sulu wamblök ena wé̱pa e̱' wamblö̀ sulu esepa ko̱s shtökka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ie'pa u̱yerawa̱rakitö bö' tai̱ë a̱, ee̱ i̱u̱rarak ñies ikà yilitdawa̱rak iweir kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Erë s'se̱r yësyësë, esepa dalöburdaë we̱s diwö es wé̱ S'yë́ tso' ie'pa blúie ee̱. ¡A' é̱na ye' ttö̀ ttsak, e̱'ma ikukueblö́ bua'ie! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ì blúie Skëköl tso' e' dör we̱s íyi tuè̱ darërëë ese blëulewa̱ yile ká̱ a̱ es. E' kué̱ wëm eköl tö ta̱ e' tö ie' ttsë'wé̱ buaë. E' kue̱ki̱ ie' tö ibléwa̱ne ta̱ imía̱ ta̱ ì ko̱s tso' iwa̱, e' watué̱ttsa̱itö. E' ské wa ie' tö ká̱ e' tué̱. Es íyi tuè̱ darërëë e' de ie' ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ñies ì blúie Skëköl tso' e' dör we̱s ákwöla bua'bua yuleke íyi watau̱kwak eköl tö tuè̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","E' tö ákwöla bua'bua ichö́k tuè̱ darërëë shu̱te̱ ese kué̱wa̱ ta̱ imía̱ ta̱ ì ko̱s tso' iwa̱ e' watué̱ttsa̱itö. E' ské wa ie' tö ákwöla bua'bua e' tué̱ttsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ñies ì blúie Skëköl tso' e' dör we̱s kla' u̱yé wëpa we̱lepa tö dayë a̱ es. E' tö nima klö'wé̱ tai̱ë tsa̱ki̱ë buaë ena suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mik ie'pa tö kla' yéttsa̱ ká̱ sí ki̱ ta̱ ie'pa e̱' tulése̱r nima shu̱shtök; ibua'bua iéka̱ kkö́ a̱ ta̱ isulusi u̱yémi bánet. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Es itköraë mik ká̱ i' e̱rkewatke eta̱. Skëköl biyöchökwakpa bitu̱raë s'shu̱shtök; s'sulusipa michoë bánet, s'se̱r yësyësë michoë bánet. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","S'sulusipa ko̱s u̱yerawa̱ Skëköl biyöchökwakpa tö bö' tai̱ë e' a̱, ee̱ ie'pa i̱u̱raë sia̱rë, kà yilitdawa̱ iweir kue̱ki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús tö ittökatapa a̱ ichaké: —¿Ttè ekkë ko̱s wà a̱ne a' é̱na? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ie'pa iiu̱té: —Tö́. Ie' tö ie'pa a̱ iché: —E' kue̱ki̱ mik s'wöbla'u̱k ttè dalöiëno wa wakpa ese eköl e̱' yué buaë ì blúie Skëköl tso' e' tté wa, eta̱ ie' tö s'wöbla'wè̱mi buaë ttè këchke wa ñies ttè pa̱'a̱li̱ wa. Ie' dör we̱s u wák wa̱ íyi tso' blëule iblo a̱ es. Ese wa̱ ijche̱r mik ta̱ ikëchke ö ipa̱'a̱li̱ kiane yèttsa̱ s'male̱pa ki̱moie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mik Jesús ttè kleé o̱ne, eta̱ imía̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","demi Nazaret, e' dör ie' wák ká̱. Ee̱ ie' tö s'wöbla'wé̱mitke judiowak ñì dapa'wo̱ wé tso' ee̱ e' a̱. We̱s ie' tö ie'pa wöbla'we̱ke e' tö ie'pa tkiwé̱wa̱. Ie'pa tö iché ñì a̱: —¿Wé̱ ie' e̱' yué ttè tai̱ë ekkë wa? ¿We̱s ì kë̀ o̱r yi a̱ ese wé̱ ie' tö buaë? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ie' wí̱ yë́ kë̀ dör se' íyi yuök kaltak wa e'? ¿Ie' mì kë̀ dör María? ¿Ie' ëlpa kë̀ dör Santiago, José, Simón ena Judas? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ñies ie' kutapa kë̀ se̱rku̱' se' shu̱a̱? Eta̱ ì ko̱s we̱ke ie' tö ¿wé̱ e' bite̱ ie' wa̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ie'pa kë̀ é̱na ie' ttè klö'wa̱k. Erë ie' iché ie'pa a̱: —Ká̱ wa'ñe Skëköl tteköl dalöiërta̱', erë iwák ká̱ ki̱ ena iwák u a̱ ee̱ kë̀ idalöiërta̱'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ie'pa kë̀ e̱rblëne ie' mik, e' kue̱ki̱ ì kë̀ o̱r yi a̱ ese kë̀ o̱ne ie' wa̱ tai̱ë ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","E' ké̱wö ska' ta̱ Herodes dör Galilea blú, e' tö Jesús tté ttsé, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","e' kue̱ki̱ ie' tö iché ikanè mésopa a̱: “Wëm ñe' dör Juan S'wöskuökwak shke̱neka̱ne e'. E' kue̱ki̱ ie' wa̱ diché tso' ì kë̀ o̱r yi a̱ ese wo̱ie.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes tö Juan klö'u̱kwa̱ patkë' wötë'wa̱itö s'wöto wé a̱, e' kue̱ki̱ ie' tö Jesús ché es. Ie' se̱ne' Herodías ta̱, e' dör ie' ël kiè Felipe e' alaköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","E' yë' Juan tö ie' a̱: “Kë̀ be' ka̱wö ta̱' se̱nuk be' ël alaköl ta̱.” E' kue̱ki̱ Herodes tö Juan wötökwa̱ patkë'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes é̱na Juan ttakwa̱ erë ie' suane pë' yöki̱, ie'pa tö iklö'wé̱ tö Juan dör Skëköl tteköl e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Erë mik Herodes tö iduéswö ké̱wö tkö'we̱ke, eta̱ Herodías alà busi e' klöté s'kiule tso' tai̱ë e'pa wörki̱. E' wër buaë Herodes wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","E' kue̱ki̱ ie' tö iché ie' a̱ yësyësë Skëköl wörki̱: “Moki̱ ye' tö ichè, ì kiè be' tö ye' a̱, e' meraëyö be' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Eta̱ ie' tö iché Herodes a̱ we̱s imì tö ie' a̱ iyë' es: —Juan S'wöskuökwak ttökwa̱ patkö́ ta̱ iwökir mú ye' a̱ kulë' a̱ iwà kkachoie tö moki̱ ittéwa̱rakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Eta̱ blu' Herodes e̱rianeka̱ tai̱ë, erë ie' tö ittè métke s'kiule tso' e'pa kukua, e' kue̱ki̱ ie' tö iké̱wö mé. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ie' tö Juan kuli' tökök patké s'wöto wé a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","E' ukuöki̱ ta̱ ie'pa wa̱ iwökir debitu̱ kulë' a̱ mé busi a̱ ta̱ ie' tö imé imì a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juan ttökatapa de ta̱ inú tsé̱mirakitö wötéwa̱. E' ukuöki̱ ta̱ ie'pa mía̱ ta̱ ibiyö́ ché Jesús a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mik Jesús tö biyö̀ e' ttsé, eta̱ ie' mía̱ kanò ki̱ ekörla bánet wé̱ kë̀ yi se̱rku̱' ese ska'. Mik pë' wa̱ ijche̱newa̱ tö ie' mía̱, eta̱ ie'pa míyal itöki̱ batsöri kkömik klö̀ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mik Jesús e̱' yéttsa̱ kanò a̱, eta̱ pë' tso' tai̱ë ipanuk e' sué̱itö. Ie'pa sué̱itö e̱r sia̱rë wa. S'kirirke ko̱s demi ie'pa wa̱ e' bua'wé̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ká̱ tuirketke, e' kue̱ki̱ ittökatapa de ie' ska' ta̱ ichérakitö ie' a̱: —Ká̱ de tsá̱li̱, kë̀ yi se̱rku̱' í̱e̱. Ie'pa yuö́mi a̱s ie'pa mi' pë' se̱rke tsi̱net ee̱ ilè ta̱u̱k ñè. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ie' tö ie'pa iu̱té: —Ie'pa kë̀ ka̱wöta̱ mi'kyal; ie'pa tiö́ a' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ie'pa tö iiu̱té: —Pan ske̱l ena nima bötö e' ë̀ tso' sa' wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ie' tö iché: —Itsú̱bitu̱ ña. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Eta̱ ie' tö pë' ké e̱' tulökse̱r i̱ski̱ ta'tsi ki̱. E' ukuöki̱ ta̱ ie' tö pan ske̱l ena nima bötö e' klö'wé̱ ta̱ iká̱ sué̱ ká̱ jaì a̱ ta̱ wëstela chéitö Skëköl a̱. Ta̱ pan blatéitö mé ittökatapa a̱ a̱s ie'pa tö iwatiö̀ pë' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ie'pa ulitane chké de wë'. Ibata a̱te̱ e' shtérakitö iëne döka̱ kkö́la dabom eyök ki̱ bök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ie'pa chké e'pa döka̱ mil ske̱yök (5.000) wëpa ë̀, alakölpa ena ala'rla kë̀ shta̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","E' ukuöki̱ ta̱ Jesús tö iché ittökatapa a̱: “A' e̱' iö́ka̱ kanò a̱, a' yúshkatke ye' yöki̱ ke̱we batsöri wi̱she̱t.” Ie' tö iché pë' male̱pa a̱: “A' yúne a' u a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","E' ukuöki̱ ta̱ ie' mía̱ ekörla ka̱bata a̱ ttök S'yë́ ta̱. Mik ká̱ tuine, eta̱ ie' tso'ia̱ ka̱bata a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","E' dalewa ittökatapa mirwa̱ batsöri ki̱ demitke elkeë. Siwa̱' bitsi̱rke tai̱ë ie'pa kke̱ wöiá̱, e' tö di' u̱yeke tai̱ë tërke kanò mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ká̱ ñirketke eta̱ Jesús mía̱ ie'pa ska' shkörami di' kí̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Erë mik ie'pa tö isué̱ tö ie' shkö̀datse̱ di' kí̱, eta̱ e' tö ie'pa tkiwé̱wa̱ suawé̱ tai̱ë ta̱ ia̱neka̱rak: —¡Wimblu datse̱ se' kke̱r! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Erë ie' iché ie'pa a̱: —¡A' e̱r kuú̱! Kë̀ a' suanuk, ye' idir. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Eta̱ Pedro tö iché ie' a̱: —A Skëkëpa, moki̱ be' idir, e' ta̱ ka̱wö mú ye' a̱ shkök di' kí̱ dö̀ be' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Eta̱ Jesús tö iiu̱té: —Be' shkö́ ye' ska'. Eta̱ Pedro e̱' yéttsa̱ kanò a̱ shkémi di' kí̱ dö̀ Jesús ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Erë mik ie' isué̱ tö siwa̱' bitsi̱rke darërëë, eta̱ ie' suanéka̱ tai̱ë ta̱ iwötunewa̱mi di' a̱ ta̱ ia̱neka̱ tai̱ë: —¡A Skëkëpa, ye' tsa̱tkö́! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","E' bet ta̱ Jesús tö iklö'wé̱ iulà a̱ ta̱ iché ia̱: —¡Wësua be' e̱rblöke ye' mik bërëbërë! ¿Ì kue̱ki̱ be' ibikeitséka̱ bötböt? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mik ie'pa böl e̱' iéka̱ kanò a̱, eta̱ siwa̱' wöklöne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ie'pa ko̱s tso' kanò a̱, e'pa e̱' tulése̱r kuchë ki̱ Jesús wörki̱ idalöioie ta̱ ichérakitö: —¡Moki̱ be' dör Skëköl Alà je'! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Itkattsa̱rak batsöri wi̱she̱t demirak Genesaret. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mik ká̱ e' wakpa tö isué̱ tö Jesús idir, eta̱ ie'pa tö itté ppéka̱ ká̱ e' ko̱s a̱. Ie'pa wa̱ s'kirirke mi'ke ie' ska' a̱s ibua'ù̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","S'kirirke esepa kköchöke ie' a̱ tö ie'pa a̱ ie' datsi' bata ë̀ mú kèwa̱. Wé̱pa ko̱s tö iké e'pa buanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fariseowakpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa se̱rke Jerusalén, e'pa we̱lepa debitu̱ Jesús ska'. Ie'pa tö ie' a̱ ichaké: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Ì kue̱ki̱ be' ttökatapa kë̀ tö se' yë́pa bak e'pa se̱r e' dalöiè? Ie'pa chkö̀ ulà kë̀ paköule. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ie' tö ie'pa iu̱té: —¿Ì kue̱ki̱ Skëköl ttè dalöiëno e' dalöse̱we̱kewa̱ a' tö a' wakpa se̱r dalöioie? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Skëköl iyë'a̱t: ‘A' yë́ ena a' mì e'pa dalöiö́,’ ñies ie' tö iyë'a̱t: ‘Yi tö iyë́ ö imì ché suluë ese wák wömerdattsa̱ ttèwa̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Erë a' icheke tö se' a̱ iyërmi s'yë́ a̱ ö s'mì a̱ i' es: ‘Ì ko̱s tso' ye' wa̱ a' ki̱moie, e' meuletke Skëköl a̱, e' kue̱ki̱ kë̀ ye' a̱ a' ki̱menuk ì wa’. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","A' tö icheke tö yi isie e' ché, ese wák kë̀ ka̱wöta̱ia̱ iyë́ ö imì ki̱muk. Es Skëköl ttè dalöiëno ñe' dalöse̱we̱kewa̱ a' tö a' wakpa se̱r iu̱tè wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡A' e̱' ö̀ suluë! Buaë Isaías tö a' yë' mik ie' iyë': ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Skëköl tö ichè: ‘Pë' ikkëpa tö ye' dalöieke kkö̀ ë̀ wa, erë ie'pa e̱r tso' ka̱mië ye' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ë́ ichökle ie'pa mi'ke ye' wé a̱ ye' dalöiök. Ttè wa ie'pa s'wöbla'we̱ke e' dör s'ditsö ttè dalöiëno ë̀.’ Es Isaías tö iyë'a̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","E' ukuöki̱ ta̱ ie' tö pë' tso' ee̱ e'pa kié ta̱ ie' iché ia̱rak: —A' tö ye' ttö̀ ttsö́, iwà a̱nú a' é̱na. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ì ñeke a' tö ese kë̀ tö a' ia'we̱pa ñáie Skëköl wöa̱. Erë ì sulu wambleke a' tö tskirke a' e̱r a̱ ese je' tö a' ia'we̱raë ñáie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Eta̱ ittökatapa de ie' ska' ta̱ ie' a̱ ichaké: —¿Be' wa̱ ijche̱r tö ì chekebö e' tö fariseowakpa uluwé̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ie' tö ie'pa iu̱té: —Fariseowakpa esepa dör we̱s íyi kuá kë̀ tkënewa̱ ye' Yë́ tso' ká̱ jaì a̱ e' wa̱ es, e' kue̱ki̱ ie'pa yërdattsa̱ wìë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ie'pa múa̱t es. Ie'pa dör we̱s s'wöbla kë̀ wawër ese tö o̱'ka wöbla kë̀ wawër e' ulaiè es, e'pa böl tköa̱raë ka̱uk a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Eta̱ Pedro tö iché ie' a̱: —Ttè wakleébö ñe' wà pakö́ sa' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ie' tö iiu̱té: —¿Ñies a' kë̀ é̱na iwà a̱ne? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A' kë̀ é̱na ia̱ne tö ì ñekesö ese mi'ke s'ñawi a̱ e' ukuöki̱ ta̱ iwekettsa̱sö? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Erë ì sulu tskirke a' e̱r a̱ ese tö a' ia'wè̱mi ñáie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ì sulu bikeitseke a' tö, s'ttèwa̱, se̱newa̱bak dalöse̱wè̱wa̱, trë, akblè, s'kkatè ka̱chè wa ñies ñì chè sulu ese ko̱s tskirke a' e̱r a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Íyi ese tö a' ia'we̱raë ñáie. Erë a' chkö̀ kë̀ ulà paköule e' kë̀ tö a' ia'we̱pa ñáie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Eta̱ Jesús ena ittökatapa míyal ká̱ kiè Tiro ena Sidón ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Eta̱ tayë eköl se̱rke ee̱ dör cananwak, e' a̱rdatse̱ tai̱ë Jesús itöki̱: —A këkëpa be' dör David aleri, ye' sa̱ú̱ e̱r sia̱rë wa. Ye' alà busi kirirke tai̱ë a̱ aknama tso'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Erë Jesús kë̀ wa̱ ie' iu̱tëne yës. Eta̱ ittökatapa kköché ie' a̱: —Tayë a̱rdatse̱ tai̱ë se' itöki̱, ì kiane ie' ki̱ e' mú ie' a̱ a̱s imi'a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ie' tö ie'pa iu̱té: —Skëköl tö ye' patkë' Israel aleripa ë̀ ki̱muk. E'pa dör we̱s obeja chöwa sia̱rë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Eta̱ tayë dewa̱ e̱' tkéwa̱ kuchë ki̱ Jesús wörki̱ ta̱ ichéitö ia̱: —¡A këkëpa, ye' ki̱mú! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús iiu̱té: —Kë̀ idör buaë ala'rla chkè yéttsa̱ mè chichi a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tayë tö iché: —A këkëpa, e' yëne; erë chkè mulé̱ darke i̱ski̱ e' ñeke chichi tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Eta̱ Jesús iché ie' a̱: —A tayë, be' e̱rblé moki̱ ye' mik, e' kue̱ki̱ ì kiane be' ki̱ e' de be' ulà a̱. E' wösha̱ ta̱ ilà busi buanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Eta̱ Jesús ena ittökatapa bite̱yalne batsöri kiè Galilea e' kkömik. Eta̱ ie' tkaka̱ ka̱bata tukir ki̱ ta̱ ee̱ ie' e̱' tkése̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ta̱ pë' de tai̱ë ie' ska', e'pa wa̱ iduepa de Jesús wörki̱. Iduepa kë̀ shko, kë̀ wöbla wawër, kë̀ tto, ulà ö klö̀ suluulewa̱ ñies s'kirirke duè ulitane wa̱ ese ko̱s bua'wé̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pë' ulitane tso' ee̱ isa̱u̱k e'pa wökrarulune. Ie'pa tö isué̱ tö kë̀ s'tto esepa ttéka̱ne, s'ulà ena s'klö̀ suluulewa̱ esepa buanene, kë̀ s'shko esepa shkéne, ñies kë̀ s'wöbla wawër, esepa wöbla wawëne. E' kue̱ki̱ ie'pa tso' Israel aleripa Këköl ki̱kökka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Eta̱ Jesús tö ittökatapa kié ta̱ ichéitö ie'pa a̱: —Sia̱rë ye' wa pë' ikkëpa wër. Ie'pa tso' ye' ta̱ e' ki̱ ká̱ de mañatk ta̱ kë̀ ie'pa wa̱ ì ku̱' ñè. Kë̀ ye' é̱na ie'pa patkak u a̱ kë̀ chkaule dö' isiwa̱'a̱rwa̱rak ñala̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Eta̱ ittökatapa tö iché ia̱: —Erë ká̱ i' a̱ kë̀ yi se̱rku̱'. ¿We̱s sa' tö pan kuè̱mi tai̱ë pë' ekkëpa tioie? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ie' tö ie'pa a̱ ichaké: —¿Ko̱s a' wa̱ pan tso'? Ie'pa iiu̱té: —Sa' wa̱ pan tso' kul (7), ñies nima tso' elkela. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Eta̱ ie' tö pë' ké e̱' tulökse̱r i̱ski̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ta̱ pan kul ena nima e' klö'wé̱itö ta̱ wëstela chéitö Skëköl a̱ ta̱ iblatéitö mé ittökatapa a̱ ta̱ ie'pa tö iwatié pë' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pë' ulitane chké de wë' ta̱ ibata a̱te̱ e' iëne döka̱ kkö́ kul. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ichkérak e'pa döka̱ mil tkëyök (4.000) wëpa ë̀, alakölpa ena ala'rla kë̀ shta̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesús tö pë' yuémine ta̱ ie' e̱' iéka̱ kanò a̱ ta̱ imía̱ ká̱ kiè Magdala ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseowakpa ena saduceowakpa we̱lepa de Jesús ska'. Ie'pa é̱na ie' tsa̱iak, e' kue̱ki̱ ie'pa tö ikié ie' a̱ tö ì kë̀ o̱r yi a̱ ese ú̱itö iwà kkachoie tö moki̱ ie' patkë'bitu̱ Skëköl tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Erë ie' tö ie'pa iu̱té: “Tsá̱li̱ ta̱ a' tö icheke, ‘Ká̱ tanewa̱ mat bule dìba a̱rdaë buaë’; ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","bla'mi ta̱ a' icheke, ‘Ká̱ tanewa̱ mat ka̱li̱ moneka̱ ttsettseë ta̱ ka̱li̱ yërdaë.’ A' é̱na ia̱ne buaë mik ta̱ dìba a̱rmi mik ta̱ ka̱li̱ yërmi, eta̱ ¿we̱s ì tköke i̱'ñe ta̱ e' kë̀ wà a̱r a' é̱na? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A' dör pë' suluë e' kë̀ tö Skëköl dalöiè we̱s trër wakpa kë̀ tö imaso dalöiè es. A' ye' a̱ ikié tö ì kë̀ o̱r yi a̱ ese u̱yö iwà kkachoie tö moki̱ Skëköl tö ye' patkë'bitu̱. Erë ilè we̱raëyö etökicha ë̀me iwà kkachoie, e' dör we̱s Jonás ta̱ ibak es.” Eta̱ ie' tö ie'pa méa̱t ta̱ imía̱ bánet. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesús ena ittökatapa demi batsöri wi̱she̱t, erë ittökatapa é̱na ilè chowa tsè̱mi ñè. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ie' iché ie'pa a̱: —Ye' ttö̀ ttsö́. A' e̱' kkö'nú fariseowakpa ena saduceowakpa pan wölöwo̱ka̱ e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ittökatapa iché ñì a̱: —¡Kë̀ se' wa̱ ì dë' ñè! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ì chök ie'pa tso' e' sué̱wa̱itö ta̱ ichéitö ie'pa a̱: —¿Ì kue̱ki̱ a' tso' ichök ñì a̱ tö kë̀ se' wa̱ ì dë' ñè? ¡Ka̱m a' e̱rblö̀ ye' mik moki̱ë! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ka̱m a' é̱na iwà a̱r? Pan ske̱l wadë'yö wëpa döka̱ mil ske̱yök (5.000) ekkë a̱, ¿e' chowa a' é̱na? Eta̱ ¿kkö́ bik ibata kit a' tö? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ñies pan kul wadë'yö wëpa döka̱ mil tkëyök (4.000) ekkë a̱, ¿e' chowa a' é̱na? E' ukuöki̱ ta̱ ¿kkö́ bik ibata kit a' tö? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿We̱s a' kë̀ é̱na ia̱ne tö ye' kë̀ ku̱' ì ñekesö ese chök? A' e̱' kkö'nú fariseowakpa ena saduceowakpa pan wölöwo̱ka̱ ese yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Eta̱ ie'pa é̱na ia̱ne tö Jesús kë̀ ku̱' pan wölöwo̱ka̱ tso' se' wa̱ ese chök. Ie'pa é̱na ia̱ne tö ttè wa fariseowakpa ena saduceowakpa tö s'wöbla'we̱ke e' chök ie' tso'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mik ie'pa de ká̱ kiè Cesarea Filipo, eta̱ Jesús tö ittökatapa a̱ ichaké: —Ye' dör S'ditsö Alà, ¿i̱ma e' cheke pë' tö ye' dör yi? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ie'pa iiu̱té: —We̱lepa tö icheke tö be' dör Juan S'wöskuökwak. We̱lepa skà tö icheke tö be' dör Skëköl tteköl bak kiè Elías shke̱neka̱ne e'. We̱lepa skà tö icheke tö be' dör Skëköl tteköl bak kiè Jeremías ö Skëköl ttekölpa skà bak e' we̱le. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ie' tö ie'pa a̱ ichaké: —Erë ¿i̱ma a' ichè, ye' dör yi? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedro tö iiu̱té: —Be' dör wé̱ pairine'bitu̱ idi' wa sa' blúie e'. Be' dör Skëköl chö́k Alà e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús iché ie' a̱: —A Simón, Jonás alà, ayëcha buaë be' dör. Ì ché be' tö e' kë̀ mène s'ditsö wa̱ be' a̱, e' mé ye' Yë́ tso' ká̱ jaì a̱ e' tö be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","E' kue̱ki̱ ye' be' a̱ ichè tö be' dör Pedro (kiè e' wà kiane chè ák). Be' dör we̱s ák dör u katabloie es, e' wa ye' ichapa kí̱ döraë tai̱ë. Ì ko̱s tso' dö̀ duèwa̱ diché, e' kë̀ e̱' alö̀paka̱ ie'pa ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ì blúie Skëköl tso' e' wékkö kköppóo ké̱wö meke ye' tö be' a̱. Ye' tö ka̱wö meke be' a̱ ye' tté buaë pakök a̱s Skëköl dö̀ s'tso' tai̱ë e' blúie. E' dör we̱s blu' eköl kanè méso tö blu' wékkö kköppèe a̱s s'döwa̱ia̱ es. Ì kë̀ ké̱wö mène be' wa̱ ká̱ i' a̱, ese kë̀ ké̱wö mène Skëköl wa̱. Ñies ì ké̱wö mé be' tö ká̱ i' a̱, ese ké̱wö me'bak Skëköl tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","E' ukuöki̱ ta̱ Jesús kë̀ wa̱ ittökatapa kàne yi a̱ ichök tö ie' dör wé̱ pairine'bitu̱ idi' wa s'blúie e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","E' ukuöki̱ ta̱ Jesús tö itsá̱ ché ittökatapa a̱: —Ye' ka̱wöta̱ shkökmi Jerusalén, ee̱ judiowak kue̱blupa ena sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa tö ye' we'ikeraë tai̱ë. Ye' tterawa̱ erë e' ki̱ ká̱ de mañat eta̱ ye' shke̱rdaka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro tö ie' kiémi bánet ta̱ iuñémiitö: —¡A Skëkëpa, kë̀ e' char! ¡E' mú kë̀ dör es! ¡Kë̀ e' wamblënuk be' ta̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Erë ie' e̱' wötrée Pedro kke̱ ta̱ iché: —¡A Satanás, be' yúshka bánet ye' yöki̱! Be' tso' ye' wöklö'u̱k. Be' kë̀ tö íyi suè̱ we̱s Skëköl tö isue̱ke es; be' tö isue̱ke we̱s s'ditsö tö isue̱ke es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","25","Ie' tö iché ittökatapa a̱: —Yi e̱' tsa̱tkak ittèwa̱ yöki̱, ese kë̀ ulà a̱ se̱ne michoë dö̀pa. Erë yi e̱' mettsa̱ ttèwa̱ ye' dalërmik, ese ulà a̱ idöraë. E' kue̱ki̱ yi e̱' yuak ye' ttökataie, ese kë̀ kàne tkinukia̱ e̱' ki̱. E' skéie ika̱wöta̱ e̱' chök dö̀ ittèwa̱ wötëulewa̱ krus mik ekkë. Es ie' ka̱wöta̱ shkök ye' itöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","27","Ye' dör S'ditsö Alà, e' döraë Skëköl olo ta̱' tai̱ë e' a̱, ñies Skëköl biyöchökwakpa ta̱. Ye' tö sulitane patue̱raë eköl eköl we̱s ise̱r es. E' kue̱ki̱ íyi ulitane tso' ká̱ i' a̱ e' de a' ulà a̱, erë se̱ne michoë kë̀ dë' a' ulà a̱, e' ta̱ e' dör ¿ìie bua' a' a̱? Se̱ne michoë kë̀ pato̱rpa ì wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Moki̱ ye' tö a' a̱ ichè tö a' tso' í̱e̱, e'pa we̱lepa tö ye' dör S'ditsö Alà, e' datse̱ blu'ie e' sue̱raë ka̱m iblërulur e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","E' ki̱ ká̱ de teröl, eta̱ Jesús wa̱ Pedro ena Santiago ena Juan dör Santiago ël, e'pa mítse̱r e̱' ta̱ ká̱ bata ka̱kke̱ë ese ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ee̱ ie'pa wö sha̱ë ie' manenettsa̱ mía̱ kua̱'ki̱, iwö olobune we̱s diwö es, ñies idatsi' manenettsa̱ mía̱ saruruë wöñarke dalölöë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","E' bet ta̱ ie'pa tö Skëköl ttekölpa bak ká̱ ia̱ia̱ë kiè Moisés ena Elías e'pa sué̱ ka̱pakök ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Eta̱ Pedro tö iché ie' a̱: —A Skëkëpa, buaë se' tso' í̱e̱. Be' ki̱ ikiane, e̱'ma ye' tö úla yuèka̱ mañatkuela; etkue be' a̱, etkue Moisés a̱, etkue Elías a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ie' ttökeia̱ e' wösha̱ ta̱ mochka wöñarke dalölöë ese tö ie'pa ki̱téwa̱. Mochka shu̱a̱ ie'pa tö ttö̀ ttsé tö ichè: “Se̱ dör ye' alà dalër tai̱ë ye' é̱na, e' wër buaë shu̱te̱ ye' wa. Ie' ttö̀ iu̱tö́.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mik e' ttsé ittökatapa tö ta̱ ie'pa suanéka̱ tai̱ë, e' kue̱ki̱ ie'pa e̱' télur wöwakköt. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús dewa̱ ie'pa o̱'mik ta̱ ie' tö ie'pa kéwa̱ ta̱ ichéitö ie'pa a̱: —A' e̱' kö́ka̱; kë̀ a' suanuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mik ie'pa tö ká̱ sué̱, eta̱ ie'pa isué̱ tö kë̀ yi ku̱'ia̱, Jesús ë̀ dur. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ie'pa bite̱tkene wa'k, eta̱ Jesús tö ie'pa a̱ ichè: —Ì sué̱ a' tö e' kë̀ pakar yi a̱ dö̀ mik ye' dör S'ditsö Alà, e' ttéwa̱ shke̱neka̱ne e' ukuöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ie'pa tö ie' a̱ ichakè: —¿Ì kue̱ki̱ s'wöbla'u̱k ttè dalöiëno wa wakpa tö icheke tö Elías ka̱wöta̱ dökne ke̱we wé̱ pairine'bitu̱ idi' wa s'blúie e' yöki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ie' tö ie'pa iu̱té: —E' yëne tö Elías datse̱kene ke̱we. Ie' tö ì ko̱s kanewe̱ketke ke̱we wé̱ pairine'bitu̱ idi' wa s'blúie e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Erë ye' tö a' a̱ ichè tö ie' dë'bak, erë ie'pa kë̀ é̱na ia̱ne tö ie' idir. Ie'pa tö iwe'ik sia̱rë we̱s ie'pa ki̱ ikiane es. Es ñies ie'pa tö ye' dör S'ditsö Alà e' we'ikeraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ie'pa é̱na ia̱ne tö ie' tso' Juan S'wöskuökwak e' chök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mik Jesús ena ittökatapa demine wé̱ pë' daparke tai̱ë ie' panuk ee̱, eta̱ wëm de eköl ie' ska' ta̱ ie' e̱' tkéwa̱ kuchë ki̱ Jesús wörki̱ ta̱ ichéitö ia̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—A këkëpa, ye' alà sa̱ú̱ e̱r sia̱rë wa. Ie' kirirke sia̱rë, we̱kkë alè ta̱ i̱li̱neka̱, mikle ta̱ ie' a̱nerö bö' a̱, mikle ta̱ di' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ka̱m be' dö̀ eta̱ ye' wa̱ idebitu̱ be' ttökatapa a̱ erë ie'pa kë̀ a̱ ibuarne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús tö iché: —A pë' kë̀ e̱rblöta̱' Skëköl mik, a' kë̀ é̱na ká̱ a̱ne. ¿Mik ye' se̱rmirö a' ta̱? ¿Ko̱s ye' tö a' dalë'ttsemirö? Kabëla ñe' tsú̱bitu̱ ña. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Eta̱ ie' tö aknama uñé ta̱ itrë'wé̱shkar duladula a̱. E' wösha̱ ta̱ duladula buanene buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","E' ukuöki̱ ta̱ ittökatapa tté ie' ta̱ bánet. Ie'pa ie' a̱ ichaké: —¿Ì kue̱ki̱ sa' kë̀ a̱ aknama e' trëneshkar? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ie' iché ie'pa a̱: —A' kë̀ e̱rblöku̱' Skëköl mik moki̱ë e' kue̱ki̱. Moki̱ ye' tö a' a̱ ichè tö a' e̱rblö́pa Skëköl mik tsir mostaza wö dör tsirla ekkë, e' ta̱ a' tö ichèmi ka̱bata wì̱ a̱: ‘Be' e̱' skö́ttsa̱ yúshka bánet’, ta̱ imiraa̱ bánet. A' e̱rblöke moki̱ Skëköl mik, e̱'ma kë̀ ì dör darërë a' a̱ wè̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mik Jesús ena ittökatapa ñì dapa'wé̱ Galilea, eta̱ ie' tö ie'pa a̱ ichè: —Ye' dör S'ditsö Alà, e' wömerdattsa̱ pë' ulà a̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ta̱ ye' tterawa̱rakitö, erë e' ki̱ ká̱ de mañat ta̱ ye' shke̱rdaka̱ne. Ttè e' tö ie' ttökatapa e̱riawé̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mik Jesús ena ittökatapa de Cafarnaúm, eta̱ pë' tö inuköl shteke Skëköl wé kanéwo̱ie e'pa de Pedro ska' ta̱ ie' a̱ ichaké: —¿Be' wöbla'u̱kwak tö inuköl patue̱kesö Skëköl wé kanéwo̱ie e' patue̱ta̱'? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro tö ie' iu̱té: —Tö́, ipatue̱ta̱'. E' ukuöki̱ ta̱ mik Pedro de we̱shke̱, eta̱ Jesús tté ie' ta̱ ke̱we ta̱ ichéitö ie' a̱: —A Simón, ¿i̱ma be' ibikeitsè? ¿Yi ña'we̱ke ká̱ wökirpa tö, iká̱ wakpa e̱kka ö pë' kua̱'ki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro tö iiu̱té: —Pë' kua̱'ki̱. Jesús tö iché: —E' yëne, e' kue̱ki̱ ila'r kë̀ ka̱wöta̱ ipatau̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Erë ipataù̱sö a̱s ie'pa kë̀ ulurka̱ se' ki̱. E' kue̱ki̱ be' yú batsöri kkömik eta̱ biklö' u̱yö́mi di' a̱. Eta̱ nima tsá̱ kli'wé̱ be' tö e' kkö̀ shu̱ppö́ö, ee̱ be' tö inuköl kue̱raë et. E' tsú̱mi ie'pa patuo̱ie, e' dör wë' se' böl nuì̱ patuo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","E' ké̱wö ska' ta̱ Jesús ttökatapa de ie' ska' ta̱ ie' a̱ ichakérakitö: —Ì blúie Skëköl tso' e' shu̱a̱ ¿yi dör ibua'ie imale̱pa tsa̱ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús tö alala kié eköl duése̱r ie'pa shu̱sha̱ë ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ta̱ ichéitö ie'pa a̱: —Moki̱ ye' tö a' a̱ ichè tö a' kë̀ e̱r mane'ù̱ a̱s a' dö̀ we̱s alala i' es, e' ta̱ a' kë̀ döpawa̱ ì blúie Skëköl tso' e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yi e̱r mane'wé̱ ta̱ ie' e̱' wöéwa we̱s alala i' es, ese döraë ibua'ie ì blúie Skëköl tso' e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yi tö alala i'se kiéwa̱ ye' ttö̀ wa, ese tö ye' wák kiéwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Yi tö ikkëpala e̱rblöke ye' mik, esepa eköl ké ì sulu wamblök, esepa weirdaë tai̱ë shu̱te̱ tkö̀ka̱ ák wawoie mué̱wa̱ ikuli' a̱ batrèemi dayë a̱ e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Íyi tso' tai̱ë s'e̱rkiöwo̱ie ì sulu wamblök, e' kue̱ki̱ wëstela i̱na ká̱ i' wakpa ta̱. Ke̱kraë ì sulu tso' s'e̱rkiöu̱k, erë yi tö s'ké ì sulu wamblök, wëstela i̱na esepa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“A' ulà ö a' klö̀ tö a' ké ì sulu wamblök e' ta̱ itö́ö u̱yö́mi bánet. A' döwa̱ se̱ne micho a̱ ulà etkë̀ ö klö̀ etkë̀, e' dör buaë. E' skéie a' u̱yèwa̱ bö' ñar michoë e' a̱ ulà bötkë ena klö̀ bötkë e' dör suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ñies s'wöbla tö s'ké ì sulu wamblök, e' ta̱ iyö́ttsa̱ u̱yö́mi bánet. A' döwa̱ se̱ne micho a̱ wöbla ek ë̀ wa, e' dör buaë. E' skéie a' u̱yèwa̱ bö' ñar michoë e' a̱ wöbla bökë, e' dör suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“A' e̱' kkö'nú, ikkëpala kë̀ watarttsa̱. Ye' tö a' a̱ ichè tö Skëköl biyöchökwakpa tso' ie'pa kkö'nuk e'pa tso' ke̱kraë ye' Yë́ tso' ká̱ jaì a̱ e' wörki̱ ie'pa tté chök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿I̱ma a' tö ibikeitsè? Wëm eköl wa̱ obeja tso' döka̱ cien ta̱ e' etö chowa, e' ta̱ ¿ì wè̱mi ie' tö? Obeja döka̱ dabom su̱li̱yök ki̱ su̱li̱tu (99) e' meraa̱t ie' tö kañika̱ ta̱ imía̱ obeja chowa e' yulök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Moki̱ ye' tö a' a̱ ichè tö mik ie' tö ikué̱, eta̱ ie' ttsë'nene buaë tkö̀ka̱ imale̱pa kë̀ chë'wa e' tö ie' ttsë'wè̱ e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Es Skëköl dör a' Yë́ tso' ká̱ jaì a̱, e' kë̀ ki̱ ikiane tö ikkëpala chöwa ekla wë'ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“A' yami we̱le tö ì sulu wamblé a' ki̱, e' ta̱ a' yú ie' ska' ta̱ ì sulu wambléitö e' chö́ ie' a̱, e' shu̱lö́ a' böl ë̀ tö. Ie' tö a' ttö̀ iu̱té, e' ta̱ a' e̱r buanene ñì ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Erë ie' kë̀ wa̱ a' ttö̀ iu̱tëne, e' ta̱ a' yamipa tsú̱mi eköl ö böl, ttè ki̱ a' tö ie' kkatè e' ttekölie a̱s io̱r we̱s itso' kitule es. E' tö ichè, “Ttè ko̱s shu̱lekesö eta̱ ittekölpa kiane böl ö mañal ichoie tö moki̱ idir ö au.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Erë kë̀ ie' wa̱ e'pa ttö̀ ttsëne, e' ta̱ ichö́ ye' icha erule e' kukua. Ñies kë̀ iwa̱ ie'pa ttö̀ iu̱tëne, e' ta̱ isa̱ú̱ we̱s pë' kë̀ tö Skëköl dalöiè es ö we̱s inuköl shtökwakpa Roma wökirpa a̱ e'pa suè̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Moki̱ ye' tö a' a̱ ichè tö ì cheke a' tö tö e' dör suluë ká̱ i' a̱, ese cheraë Skëköl tö tö e' dör suluë. Ñies ì cheke a' tö tö e' dör buaë ká̱ i' a̱, ese cheraë Skëköl tö tö e' dör buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","“Ye' tö ì skà chekene a' a̱: Wé̱ a' böl ö mañal ñì dapa'wé̱ ye' ttö̀ wa, ee̱ ye' tso' a' ta̱. E' kue̱ki̱ a' böl e̱r méwa̱ ñikkëë ká̱ i' a̱ ilè kiök ye' Yë́ tso' ká̱ jaì a̱ e' a̱, e' ta̱ imeraëitö a' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Eta̱ Pedro dewa̱ Jesús ska' ta̱ ichakéitö: —A Skëkëpa, ¿bitökicha ye' yami tö ì sulu wamblé ye' ki̱, e' olo'yèmiyö iki̱? ¿Moki̱ dö̀ kul ekkë? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ie' iiu̱té: —Kë̀ ye' tö be' a̱ ichè kul ë̀. Ye' ichè tö be' ka̱wöta̱ inuì̱ olo'yök iki̱ ke̱kraë bitökicha ekkë ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ì chéyö a' a̱ e' wà pakekeyö ttè i' wa. Ì blúie Skëköl tso' e' dör we̱s blu' eköl é̱na nuì̱ shu̱lak ikanè mésopa ta̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ie' tö ie'pa nuì̱ shu̱lémitke eta̱ ikanè méso eköl debitu̱ ie'pa wa̱ ie' wörki̱, e' wa̱ nuì̱ tso' tai̱ë shu̱te̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ie' kë̀ a̱ nuì̱ ekkë pato̱rpa, e' kue̱ki̱ blu' tö ie' ena ilaköl ena ila'r ena ì ko̱s tso' iwa̱ e' watau̱ktsa̱ ké inuì̱ ekkë patuo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ikanè méso e̱' tkéwa̱ kuchë ki̱ blu' wörki̱ ta̱ ikköché tai̱ë ie' a̱: ‘Be' we'ikèyö, ye' panú bë́rë tsir, e' wa ye' tö be' patuè̱ttsa̱ se̱raa̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Blu' ie' sué̱ e̱r sia̱rë wa, e' kue̱ki̱ iñarke ko̱s e' olo'yéitö iki̱ se̱raa̱ ta̱ iémine bë̀rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Erë mik kanè méso e' mía̱, eta̱ ie' tö kanè méso iëköl kué̱ ña'we̱ke ie' tö elkela ë̀ Ta̱ iklö'wé̱wa̱itö ikuli' a̱ tuéwa̱ darërëë ta̱ ichéitö ia̱: ‘¡Be' ñarke ye' ulà a̱, e' pataú̱ttsa̱ ña!’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ta̱ iëköl e̱' tkéwa̱ kuchë ki̱ ie' wörki̱ ta̱ ikköché tai̱ë: ‘Be' we'ikèyö, ye' panú bë́rë tsir, e' wa yö be' patuè̱ttsa̱ se̱raa̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Erë ie' kë̀ wa̱ iëköl kköchöke e' iu̱tëne. Ie' tö iwötökwa̱ patké s'wöto wé a̱ dö̀ mik inuì̱ patué̱ttsa̱itö se̱raa̱ eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mik kanè mésopa male̱pa tö ittsé, eta̱ e' tö ie'pa e̱riawé̱ tai̱ë. E' kue̱ki̱ ie'pa mía̱ blu' ska' ta̱ ichéka̱ se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Eta̱ blu' tö kanè méso e' kiök patké ta̱ ichéitö ia̱: ‘¡Be' dör pë' suluë! Ye' tö be' ki̱ be' nuì̱ tai̱ë e' olo'ya' se̱raa̱ be' kköyë' ye' a̱ e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Ì kue̱ki̱ be' kë̀ wa̱ be' yami su̱ne e̱r sia̱rë wa we̱s ye' be' su̱' es?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Eta̱ blu' uluneka̱ tai̱ë, e' tö ikanè méso wötökwa̱ patké a̱s iwe'ikö̀ ie'pa tö sia̱rë dö̀ mik inuì̱ pato̱nettsa̱ se̱raa̱ eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Es ñies a' yami tö ì sulu wamblé a' ki̱ e' nuí̱ kë̀ olo'yè a' tö iki̱ e̱r moki̱ wa, e' ta̱ ye' Yë́ tso' ká̱ jaì a̱ e' tö a' we'ikeraë sia̱rë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mik Jesús tö ttè ekkë ché o̱ne, eta̱ ie' e̱' yéttsa̱ Galilea mía̱ Judea ta̱ itkattsa̱ Jordán a̱ wi̱she̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tai̱ë pë' dami ie' itöki̱ e'pa shu̱a̱ wé̱pa kirirke esepa ko̱s bua'wé̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Eta̱ fariseowakpa we̱lepa de ie' ska' ta̱ ie'pa tö ie' a̱ ichaké itsa̱ioie: —¿Wëpa a̱ ka̱wö ta̱' itayë owa íyi ulitane kue̱ki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ie' tö ie'pa iu̱té: —Ì tso' kitule Skëköl yëkkuö ki̱, ¿e' kë̀ su̱ne a' wa̱? E' tö ichè tö tsa̱we ta̱ Skëköl tö se' yö' wëm ena alaköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ie' tö iyë': ‘E' kue̱ki̱ wëpa kë̀ se̱rpaia̱ iyë́ ena imì e'pa dapömik, ta̱ ise̱rdawa̱ alaköl ta̱. Ie'pa böl se̱rdaë ñita̱ ta̱ ie'pa mía̱ we̱s wák eköl ë̀ es.’ Es ikite̱a̱t ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","e' kue̱ki̱ ie'pa kë̀ ià̱ böl, ie'pa yöne we̱s wák eköl ë̀ es. E' kue̱ki̱ wé̱pa batséwa̱ Skëköl tö esepa kë̀ batsökök yi tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Eta̱ ie'pa tö ie' a̱ ichaké: —E' dör es, e' ta̱ ¿ì kue̱ki̱ Moisés tö iyë'a̱t tö wëm tö itayë éwa, ese wák ka̱wöta̱ ñì owa yëkkuö muk ia̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ie' iu̱té: —A' e̱r darërë, e' kue̱ki̱ Moisés tö ka̱wö me' a' a̱ a' tayë ökwa, erë tsa̱we ta̱ kë̀ idör es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ye' tö a' a̱ ichè tö yi tö itayë éwa, kë̀ dör itayë trër kue̱ki̱, ese tö alaköl skà tsé̱wa̱ne, e' ta̱ e' wa ise̱newa̱bak ke̱we e' dalöse̱wé̱wa̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jesús ttökatapa tö iché ie' a̱: —E' dör es e' ta̱ bua' idir sa' a̱ tö kë̀ sa' alaköl tsù̱wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ie' tö ie'pa iu̱té: —Ì ché a' tö e' kë̀ dör sulitane a̱, e' dör wé̱pa a̱ imène esepa ë̀ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wëpa we̱lepa dör kachir ie'pa wák dë'ka̱ es e' kue̱ki̱. We̱lepa skà yueke s'kapeyökwakpa tö kachirie. Iskà tso' esepa se̱rke kachirie ì blúie Skëköl tso' e' kané kue̱ki̱. Wé̱pa se̱rmi es, esepa se̱nú es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pë' wa̱ ala'rla debitu̱ Jesús ska' a̱s ie' ulà mùka̱ iki̱ ena ikiö̀ S'yë́ a̱ iki̱. Erë ittökatapa tö pë' uñélor. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Erë ie' tö iché: —A̱s ala'rla bitu̱ ye' ska'. Wé̱pa dör we̱s ie'pa es, esepa blúie Skëköl tso', e' kue̱ki̱ kë̀ iwöklö'wa̱ria̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Eta̱ ie' ulà méka̱ ie'pa ki̱, e' ukuöki̱ ta̱ imía̱ bánet. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wëm eköl debitu̱ Jesús ska' ta̱ ie' a̱ ichaké: —A S'wöbla'u̱kwak, ¿ì buaë wè̱mi ye' tö a̱s se̱ne michoë dö̀ ye' ulà a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ie' tö iiu̱té: —¿Ì kue̱ki̱ be' tö ye' chaké ì dör buaë ese ki̱? Skëköl eköl ë̀ dör buaë. Be' ki̱ se̱ne michoë kiane, e' ta̱ ttè me'a̱tbak ie' tö dalöiëno e' dalöiö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ie' tö Jesús a̱ ichaké: —¿Ttè wé̱ne? Ie' iiu̱té: —‘Kë̀ a' ka̱wö ta̱' s'ttökwa̱, kë̀ a' ka̱wö ta̱' s'se̱newa̱bak e' dalöse̱u̱kwa̱, kë̀ a' ka̱wö ta̱' akblök, kë̀ a' ka̱wö ta̱' s'kkatök ka̱chè wa, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","a' yë́ ena a' mì dalöiö́, ñies a' male̱pa dalëritsö́ we̱s a' wákpa e̱' dalër es.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Duladula tö ie' a̱ iché: —Ttè e' ko̱s dalöië'bitu̱ ye' tö ia̱ia̱ë. Eta̱ ¿ì skà kianeia̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ie' iiu̱té: —Be' é̱na ì buaë ko̱s wa̱k se̱raa̱, e' ta̱ be' yú ta̱ ì tso' be' wa̱, e' wataú̱ttsa̱ se̱raa̱ ta̱ iské múttsa̱ s'sia̱rëpa a̱. E' ukuöki̱ ta̱ be' shkö́ ye' ta̱ ye' ttökataie. Es ta̱ íyi buaë tai̱ë döraë be' ulà a̱ ká̱ jaì a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Duladula dör inuköl blú tai̱ë, e' kue̱ki̱ mik ie' tö e' ttsé eta̱ ie' e̱rianeka̱ tai̱ë ta̱ imía̱tke. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Eta̱ Jesús tö iché ittökatapa a̱: —Moki̱ ye' tö a' a̱ ichè tö inuköl blúpa a̱ darërëë idir dökwa̱ ì blúie Skëköl tso' e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iskà chèneyö a' a̱ tö inuköl blúpa a̱ dökwa̱ ì blúie Skëköl tso' e' a̱ e' dör darërëë tkö̀ka̱ kameio tkö̀mi datsi' yuo diké ese wöukla a̱ e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mik e' ttsé ie'pa tö, eta̱ ie'pa tkinewa̱ tai̱ë ta̱ ichéitörak: —E' dör es e̱'ma ¿yi tsa̱tkërmi? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ie'pa webléitö ta̱ ichéitö: —E' kë̀ o̱nuk s'ditsö a̱ we̱s, erë Skëköl a̱ íyi ulitane o̱rmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Eta̱ Pedro tö iché ia̱: —Sa' tö íyi ulitane me'a̱t ta̱ sa' bite̱ be' ta̱. ¿Ì dö̀mi sa' ulà a̱ e' skéie? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ie' tö ie'pa iu̱té: —Moki̱ ye' tö a' a̱ ichè tö mik ká̱ i' manerketkene buaë aishkuö ta̱, eta̱ ye' dör S'ditsö Alà e' döraë ká̱ ulitane blúie olo ta̱' tai̱ë. Ñies a' dör ye' ttökatapa, e'pa e̱' tulörase̱r blu' kulé döka̱ dabom eyök kí̱ böt e' ki̱, Israel ditséwöpa döka̱ dabom eyök kí̱ böl e'pa wëttsu̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wé̱pa ko̱s tö iu ö iëlpa ö ikutapa ö iyë́ ö imì ö ila'r ö iká̱ ese méa̱t ye' tté kue̱ki̱, e' ta̱ e'pa ulà a̱ iské dörane tai̱ë shu̱te̱ë, ñies aishkuö ta̱ se̱ne michoë döraë ie'pa ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Erë i̱'ñe ta̱ se' tai̱ë tso' ke̱we esepa döraë bataie ena se' tso' bataie i̱'ñe ta̱ esepa döraë ke̱weie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ì blúie Skëköl tso' e' ta̱ itköke we̱s itka wëm eköl ta̱ es. E' mía̱ bla'mi kanè mésopa yulök ie' uva tso' tkëule e' kanéu̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ie' tö iché ie'pa a̱: ‘Ye' tö a' patue̱ke ko̱s s'pato̱rke ká̱ etk ekkë, e' dör denario etk.’ E' dör buaë ie'pa a̱ ta̱ ie' tö ie'pa patké kaneblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Diwö de su̱li̱tu (9) eta̱ kanè wák mía̱ne kanè mésopa skà yulök eta̱ ee̱ ie' tö isué̱ tö wëpa tulur ñala̱ ska' kë̀ ku̱' kaneblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ie' tö ie'pa a̱ iché: ‘A' yú kaneblök ye' kanè a̱ ta̱ ye' tö a' patue̱ke ko̱s s'pato̱rke moki̱ ekkë.’ Eta̱ ie'pa mía̱ kaneblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Diwö de bata a̱ ta̱ ie' mía̱ kanè mésopa skà yulök eta̱ ie' tö ie'pa patké kaneblök. Ñies tsá̱li̱ diwö de mañat eta̱ ie' mía̱ kanè mésopa skà yulök ta̱ ie'pa patkéitö ñies kaneblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Diwö döketke ske̱l eta̱ ie' mía̱ kanè mésopa skà yulök, ee̱ ie' tö wëpa kué̱ iëte̱r kë̀ ku̱' kaneblök. Ie' tö ie'pa a̱ ichaké: ‘¿Iö́k a' iëte̱r ñië í̱e̱ kë̀ ku̱' kaneblök?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ie'pa tö iiu̱té: ‘Kë̀ yi wa̱ sa' a̱ kanè mène.’ Eta̱ ie' tö ie'pa a̱ iché: ‘A' yú kaneblök ye' a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Mik ká̱ tuine, eta̱ kanè wák tö ichè ikanè mésopa patau̱kwak a̱: ‘Kanè mésopa kiö́ eta̱ ie'pa pataú̱. Wé̱pa debitu̱ bataie, e'pa pataú̱mi ke̱we, ta̱ wé̱pa debitu̱ ke̱we, e'pa pataú̱ bataie.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Eta̱ kanè mésopa debitu̱ kaneblök tsá̱li̱ diwö ske̱l, e'pa pato̱ne ke̱we. Ie'pa ko̱s pato̱ne denario et et. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mik kanè mésopa debitu̱ kaneblök ke̱we, e'pa pato̱rketke eta̱ ie'pa tö ibikeitsé: ‘Sa' pato̱rke aishe̱t sa' male̱pa tsa̱ta̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Erë ie'pa ko̱s pato̱ne denario et et ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","E' tö ie'pa kabewé̱ka̱ ta̱ iché kanè wák a̱: ‘Wëpa ikkëpa debitu̱ bataie kaneblé bërbërla ë̀, e' skéie sa' kaneblé ñië, ña'wé̱ dìba tö, ñies shtrine tai̱ë. Eta̱ ¿we̱s be' tö ie'pa patué̱ ko̱s be' tö sa' patué̱ ekkë?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Erë kanè wák tö ikanè méso eköl iu̱té: ‘A yami, ye' kë̀ ku̱' ì sulu wamblök be' ta̱. Se' ttè mé ñì a̱ tö ye' be' patue̱ke denario etk. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","E' kue̱ki̱ be' inuköl klö'ú̱ ta̱ be' yúshka. Wëm debitu̱ kaneblök ibataie ese a̱ ye' é̱na inuköl mak ko̱s ye' tö be' a̱ imé ekkë eta̱ ¿we̱s ide? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ye' a̱ ka̱wö ta̱' ì wa̱k ye' é̱na ye' inuköl wa, ese wo̱ie. Ye' tö ilè kakmeke yile a̱, ¿e' tö be' ukyëwe̱ke ye' ki̱?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Es s'tso' bataie esepa döraë ke̱weie ena s'tso' ke̱weie esepa döraë bataie.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús ena ittökatapa dabom eyök kí̱ böl (12), e'pa mirka̱ Jerusalén ta̱ ie' tö ie'pa kié bánet ta̱ ichéitö ia̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Se' mirka̱ Jerusalén i', eta̱ ee̱ ye' dör S'ditsö Alà, e' merdattsa̱ sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa ulà a̱. Ie'pa tö ye' kichateraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ye' merattsa̱rakitö pë' kë̀ dör judiowak esepa ulà a̱. E'pa tö ye' wayueraë pperaë sia̱rë ta̱ ye' tterawa̱rakitö wötëule krus mik. Erë e' ki̱ ká̱ de mañat, eta̱ ye' shke̱rdaka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Santiago ena Juan dör Zebedeo ala'r e'pa mì de ie'pa ta̱ Jesús ska' ta̱ ie̱' tkéwa̱ kuchë ki̱ iwörki̱ ilè kioie ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús tö ie' a̱ ichaké: —¿Ì kiane be' ki̱? Ie' tö iiu̱té: —Ye' tö be' a̱ ka̱wö kieke tö mik be' tkëneka̱ s'blúie, eta̱ ye' alà eköl tkö́wa̱ be' ulà bua'kka, eköl be' ulà bakli̱'kka s'wëttsu̱k be' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ie' iiu̱té: —Ì kieke a' tö e' kë̀ wà jche̱r a' wa̱. ¿Ye' tka̱' wayarmi a' a̱? ¿A' e̱' ché weinuk we̱s ye' weirdaë es? Ie'pa tö iiu̱té: —Tö́, sa' dirmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ie' iché: —Moki̱ ye' tka̱' wayeraë a' tö, a' weirdaë we̱s ye' es. Erë e̱' tkökse̱r ye' ulà bua'kka ö ye' ulà bakli̱'kka, e' kë̀ ké̱wö menuk ye' a̱. E' tso'tke ye' Yë́ wa̱ klöule yi a̱ imekeitö esepa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mik ttè e' ttséwa̱ ittökatapa male̱pa döka̱ dabom eyök (10) e'pa tö, eta̱ ie'pa uluneka̱ ie'pa böl ñe' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Erë ie' tö ie'pa ulitane kié ta̱ iché ia̱: —A' wa̱ ijche̱r tö pë' kë̀ tö Skëköl dalöiè, esepa wökirpa ko̱s e̱' alökeka̱ ie'pa ki̱ ke̱kraë, ñies iblúpa tö ie'pa patkeke kësik wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Erë a' kë̀ kàne e̱' wamblök es. E' skéie, a' isie e̱' yuak a' wökirie, ese ka̱wöta̱ e̱' wöökwa imale̱pa diki̱a̱ diöshe̱t ikanè mésoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ñies a' isie e̱' yuak ibua'ie a' male̱pa tsa̱ta̱, ese ka̱wöta̱ e̱' muktsa̱ imale̱pa a̱ kanè mésoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ye' dör S'ditsö Alà, e' kë̀ dë'bitu̱ a̱s yi tö ye' ki̱mù. Ye' dë'bitu̱ ie'pa ki̱muk ena e̱' muktsa̱ ttèwa̱ pë' tso' tai̱ë e' nuì̱ skéie. E' kue̱ki̱ a' ka̱wöta̱ e̱' wöökwa a' male̱pa kanè mésoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús ena ittökatapa e̱' yéttsa̱ Jericó, e'pa itöki̱ pë' mirwa̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Eta̱ wëpa böl wöbla kë̀ wawër, e'pa tulur ñala̱ ska'. Mik ie'pa tö ittsé tö Jesús dami, eta̱ ie'pa tö iché a̱neule: —¡A këkëpa, s'blú David bak e' aleri, sa' sa̱ú̱ e̱r sia̱rë wa! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pë' tö wëpa e' uñeke a̱s ie'pa siwa̱'blö̀wa̱, erë ie'pa kí̱ a̱neka̱ tai̱ë: —A këkëpa, David aleri, sa' sa̱ú̱ e̱r sia̱rë wa ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús e̱' duése̱r ta̱ wëpa wöbla kë̀ wawër e'pa kiéitö ta̱ ie'pa a̱ ichakéitö: —¿Ì kiane a' ki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ie'pa iiu̱té: —A këkëpa, sa' wöbla bua'ú̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ie' tö ie'pa sué̱ e̱r sia̱rë wa ta̱ ie'pa wöbla kéitö. E' wö shà̱ ta̱ ie'pa wöbla buanene ta̱ imíyal ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mik Jesús ena ittökatapa demi tsi̱net Jerusalén, ká̱ kiè Betfagé tso' Olivo ké̱bata a̱ ee̱, eta̱ ie' tö ittökatapa kié böl ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ta̱ ichéitö ia̱rak: —A' yú wì̱ u wëne eruleë ee̱. Mik a' demi ee̱, eta̱ bet ta̱ a' tö burro alaki kue̱raë etö moulewa̱ ena ilala dur io̱'mik. E' wötsö́ö ta̱ itsú̱bitu̱ ña. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yile tö a' a̱ ichaké, e' ta̱ iiu̱tö́: ‘Skëkëpa ki̱ ikiane, e' wa ie' tö imène.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Itka es a̱s ì yë'a̱tbak Skëköl tteköl tö e' wà tkö̀ es. Ie' tö iyë': ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ichö́ Jerusalén wakpa a̱: ‘Ye' ttö̀ ttsö́, a' blú datse̱ a' ska' e̱' tkëuleka̱ burro ki̱. Ie' dör pë' bë̀rë kë̀ e̱' ttsöta̱'ka̱. Ie' datse̱ burro alala ki̱, e' dör iyiwak tso' dalì oie ese.’ ” Es Skëköl tteköl tö iyë'a̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ittökatapa míyal ta̱ iwé̱rakitö we̱s Jesús tö iché ie'pa a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ie'pa wa̱ burro alaki ena ilala bite̱tse̱r Jesús a̱. Ie'pa tö ipaio ki̱kke̱ méka̱ burro alala ki̱ ta̱ Jesús e̱' tkéka̱ iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pë' tso' tai̱ë e'pa tö ipaio ki̱kke̱ shuélor ñala̱ ki̱, ñies we̱lepa tö kal kö̀ télor shuélor ñala̱ ki̱ Jesús ñalé̱ tso̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Pë' mirwa̱ ke̱weie Jesús yöki̱ ñies itöki̱, e'pa ulitane a̱rke tai̱ë: —¡Ie' i' dör se' blú bak David e' aleri, e' ki̱köka̱sö! Ayëcha buaë ie' datse̱ Skëköl ttö̀ wa. ¡Skëköl tso' ká̱ jaì a̱ e' ki̱köka̱sö! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mik ie' dewa̱ Jerusalén, eta̱ e' wakpa aláneka̱ tai̱ë ta̱ ichaké: —¿Yi dör ie'? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pë' datse̱ tai̱ë ie' ta̱, e'pa tö iu̱té: —E' dör Jesús. Ie' dör Skëköl tteköl datse̱ Nazaret a̱te̱ Galilea e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Eta̱ Jesús dewa̱ Skëköl wé a̱. Eta̱ wé̱pa tso' ee̱ íyi ta̱u̱k ena íyi watau̱k e'pa ko̱s trë'wé̱yal ie' tö. Inuköl mane'u̱k wakpa mesa trélurka̱itö. Ñies nuböl watau̱kwakpa kula' trélurka̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ie' iché ie'pa a̱: —Skëköl tö iyë'a̱t iyëkkuö ki̱: ‘Ye' u kirdaë tto ye' ta̱ wé’, erë a' tö iia'wé̱ka̱ akblo wéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Eta̱ s'wöbla kë̀ wawër ena kë̀ s'shko bua' esepa debitu̱ Jesús ska' Skëköl wé a̱ ta̱ ie' tö ie'pa bua'wé̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ala'rla tso' ee̱ e'pa tö iché a̱neule: ‘¡S'blú bak David, e' aleri ki̱köka̱sö!’ Mik sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa tö ì wé̱ Jesús tö e' sué̱, ena i̱ma ala'rla tö ie' ché e' ttsé, eta̱ ie'pa uluneka̱ tai̱ë ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ta̱ ichéitörak Jesús a̱: —Ì chök ala'rla tso', ¿e' ttsé be' tö? Ie' tö ie'pa iu̱té: —Tö́, e' ttséyö. Erë i̱ma e' chè Skëköl yëkkuö tö, wësua e' kë̀ su̱ule a' wa̱. E' tö ichè: ‘A Skëköl, ala'rla ena bëbëpala tsu'yökeia̱, esepa kébö e̱' ki̱kökka̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Eta̱ ie' tö ie'pa méa̱t ta̱ imía̱ ká̱ kiè Betania ee̱. Ee̱ ie' kapére. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Bule es bla'mi ta̱ Jesús michone Jerusalén ta̱ ie' mirwa̱ ñala̱ wa ta̱ ie' dué bli wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ie' tö higuera klö̀ te̱r elka sué̱ ta̱ imía̱ iwö yulök katè. Erë kë̀ iwö ta̱', ikö̀ ë̀ arwa̱ tai̱ë. E' kue̱ki̱ ie' tö iché kal e' a̱: —¡Kë̀ be' wörpaia̱ yës! E' wösha̱ ta̱ higuera klö̀ sinewa̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mik e' sué̱ ittökatapa tö, eta̱ e' tö ie'pa tkiwé̱wa̱ tai̱ë, e' kue̱ki̱ ie'pa tö ie' a̱ ichaké: —¿We̱s higuera klö̀ sinewa̱ bet? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ie' tö ie'pa iu̱té: —Moki̱ ye' tö a' a̱ ichè tö a' e̱rblé Skëköl mik moki̱, kë̀ ibikeitsule bötböt, e' ta̱ ì wé̱ ye' tö, e' o̱rmi a' a̱ ñies. E' kí̱ie ta̱ a' tö ichèmi ka̱bata wì̱ a̱: ‘Be' e̱' skö́ttsa̱ í̱e̱ a̱núwa dayë a̱’, e' ta̱ es iwà tköraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","A' e̱rblé Skëköl mik moki̱, e' ta̱ ì ko̱s kié a' tö ie' a̱ e' wà döraë a' ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","E' ukuöki̱ ta̱ Jesús dewa̱ Skëköl wé a̱, ee̱ ie' tso' s'wöbla'u̱k. Eta̱ sacerdotepa wökirpa ena judiowak kue̱blupa de ie' ska' ta̱ ichaké ia̱: —¿Yi ttö̀ wa be' tö íyi ikkë we̱ke? ¿Yi tö e' ké̱wö mé be' a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ie' iiu̱té: —Ñies ye' tö a' a̱ ilè chakeke, e' iu̱té a' tö, e' ta̱ ye' tö a' a̱ icheke tö yi tö iké̱wö me' ye' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Yi tö Juan patkë' s'wöskuök? ¿Skëköl tso' ká̱ jaì a̱ e' ö s'ditsö? Ie'pa ñì iu̱témi ta̱ ichérakitö: “Se' tö ichèmi tö Skëköl tö ka̱wö mé Juan a̱, e' ta̱ ie' tö se' iu̱tèmi: ‘Eta̱ ¿ì kue̱ki̱ a' kë̀ wa̱ ie' ttè klöo̱ne?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pë' ulitane tö iklö'wé̱ tö Juan dör Skëköl tteköl. Se' suane ie'pa yöki̱, e' kue̱ki̱ kë̀ se' a̱ iyënuk tö Juan a̱ ka̱wö me' s'ditsö tö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","E' kue̱ki̱ ie'pa tö iiu̱té: —Kë̀ sa' wa̱ ijche̱r. Ie' tö ie'pa a̱ iché: —Es ñies ye' kë̀ tö a' a̱ ichepa tö yi tö ye' a̱ ka̱wö mé íyi ikkë wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús tö ie'pa a̱ iché: —Ttè kleekeyö a' a̱ e' ttsö́ a' tö. Wëm eköl alà dör böl wëpa, e' debitu̱ ilà eköl ska' ke̱we ta̱ ichéitö ia̱: ‘A alà, be' yú kaneblök i̱'ñe ye' uva tso' tkëule e' a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ilà tö iiu̱té: ‘Kë̀ ye' mìne.’ Erë e' ukuöki̱ ta̱ ie' tö ibikeitséne kua̱'ki̱ ta̱ imía̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","E' ukuöki̱ ta̱ iyë́ mía̱ ilà iëköl ska' ta̱ ichéitö ia̱: ‘Be' yú kaneblök ye' uva tso' tkëule e' a̱.’ Ilà iu̱té: ‘Ëkëkë ye' mi'ke.’ Erë ie' kë̀ mìne. Eta̱ Jesús tö ie'pa a̱ ichaké: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","—¿I̱ma a' tö ibikeitsè? Ala'r böl, ¿e' wé̱ne tö iyë́ ttö̀ iu̱té? Ie'pa tö ie' iu̱té: —Wé̱ne a̱ ichéitö ke̱we e'. Ie' iché ie'pa a̱: —Juan S'wöskuökwak dë'bitu̱ se̱ne yësyësë ñalé̱ kkachök a' a̱, erë a' kë̀ wa̱ ie' ttè klöo̱ne. Erë inuköl shtökwakpa Roma wökirpa a̱ ena alakölpa sulusipa, esepa tö ie' ttè klö'wé̱. E' sué̱ a' tö erë kë̀ a' e̱r maneo̱ne ie' ttè klö'wo̱ie. E' kue̱ki̱ moki̱ ye' tö a' a̱ ichè tö ie'pa esepa dörawa̱ a' skéie ì blúie Skëköl tso' e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iskà kleekeyö a' a̱, e' ttsö́. Kanè wák eköl tö uva kuatké tai̱ë ta̱ ikköiéwa̱itö buaë, ka̱uk biéitö uva diö̀ tuoie. Ñies úla yuéitö ka̱kke̱ë uva kkö'noie. E' ukuöki̱ ta̱ ie' tö ipeitéa̱t wëpa we̱lepa a̱ a̱s ie'pa tö ipataù̱ ie' a̱ iwörke e' kak wa. E' ukuöki̱ ta̱ ie' mía̱ ká̱ bánet. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mik uvawö aline tso'tke wë'ià̱ë shtè, eta̱ ie' tö ikanè mésopa we̱lepa patkémi ie' icha tsu̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Erë kanéu̱kwakpa tö ikanè mésopa klö'wé̱wa̱, eköl ppérakitö sia̱rë, eköl ttéwa̱rakitö, eköl shka̱'wé̱rakitö tai̱ë ák wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Eta̱ kanè wák tö ikanè mésopa skà patkémine tkö̀ka̱ kuaë ipatkë'itö e' tsa̱ta̱. Erë kanéu̱kwakpa tö iwamblé ie'pa ta̱ we̱s ie'pa tö iwamblë' wé̱pa dë'rö kuaë e'pa ta̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Bata ekkë ta̱ ie' tö iwák alà patkémi ta̱ ie' ibikeitsé: ‘Ye' alà idir, e' kue̱ki̱ ie'pa tö idalöieraë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Erë mik ie'pa tö ilà sué̱, eta̱ ie'pa iché ñì a̱: ‘Ie' wì̱ dör ká̱ i' wak alà, ká̱ i' a̱tdaë ie' ulà a̱. Ittöwa̱sö eta̱ es se' ulà a̱ ká̱ i' a̱tdaë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","E' kue̱ki̱ ie'pa tö iklö'wé̱wa̱ yéttsa̱ bánet ta̱ ittéwa̱rakitö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Eta̱ Jesús tö iché: —Ye' tö a' a̱ ichakè: ¿I̱ma a' tö ibikeitsé? Mik kanè wák dene eta̱ ¿ì we̱raë ie' tö kanéu̱kwakpa e'pa ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ie'pa tö iiu̱té: —Ie' tö pë' sulusipa e'pa tteralur e̱r sulu wa ta̱ uva kané meraneitö kanéu̱kwakpa kua̱'ki̱pa tö ipatue̱raë buaë mik iké̱wö döke bit ekkë esepa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Eta̱ ie' tö iché ie'pa a̱: —Ye' tté tso' kitule Skëköl yëkkuö ki̱, ¿e' kë̀ su̱ne a' wa̱? E' tö ichè: ‘Ák watë'ttsa̱ u yuökwakpa tö e' yönene ák bua'buaie. E' kaneo̱' Skëköl tö, ta̱ e' tö s'ttsë'we̱ke buaë, s'tkinewa̱ iweblök.’ Es Skëköl yëkkuö tö iyë'a̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","E' kue̱ki̱ yö ichè a' a̱ tö ì blúie Skëköl tso' e' kané mène a' a̱, erë e' yerattsa̱itö a' ulà a̱ ta̱ imeraëitö pë' kua̱'ki̱pa tö iwakanewe̱raë buaë esepa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Es yi klastkëne ák e' mik ese pa̱rolordaë ena yi ki̱ ák e' a̱neka̱ ese yalitdawa̱ idiki̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mik sacerdotepa wökirpa ena fariseowakpa tö ì kleé Jesús tö ñe' ttsé, eta̱ ie'pa tö isué̱wa̱ tö ie' tso' ie'pa chök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","E' kue̱ki̱ ie'pa é̱na ie' klö'wa̱kwa̱ ee̱. Erë pë' tö iklö'wé̱ tö ie' dör Skëköl tteköl, e' kue̱ki̱ ie'pa suane pë' yöki̱ ta̱ kë̀ ie'pa wa̱ iklöo̱newa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Eta̱ Jesús tö ttè skà kleé ie'pa a̱ i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ì blúie Skëköl tso' e' ta̱ itköke we̱s itka blu' eköl ta̱ es. E' tö ilà ulabatske e' ké̱wö tkö'we̱ke. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ie' tö ikanè mésopa patké wé̱pa kiule ko̱s e'pa a̱ ichök: ‘Blu' alà ulabatske e' diwö de, a' shkö́ iké̱wö tkö'u̱k.’ Erë ie'pa kë̀ shkak. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","E' ukuöki̱ ta̱ blu' tö ikanè mésopa kua̱'ki̱ skà patkémi e'pa a̱ ichéitö: ‘Ichö́ wé̱pa kiule ko̱s a̱ tö ye' iyiwak bua'buaë e' duotke alinetke, katè ë̀ kianeia̱. E' kue̱ki̱ a' shkö́ ye' alà ulabatske e' ké̱wö tkö'u̱k.’ Eta̱ ie'pa míyal e' chök wé̱pa kiule e'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Erë wé̱pa kiule ko̱s e'pa kë̀ wa̱ blu' ttö̀ iu̱tëne. Ie'pa eköl mía̱ ikanè ki̱, eköl mía̱ íyi watau̱k ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ta̱ imale̱pa tö blu' kanè mésopa klö'wé̱wa̱ ta̱ iwe'ikérakitö sia̱rë, ñies we̱lepa ttéwa̱rakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Eta̱ blu' uluneka̱ tai̱ë ie'pa ki̱ ta̱ ie' tö iché iñippökwakpa a̱: ‘A' yú ie'pa ko̱s ttökulur, ñies ie'pa u ko̱s ña'ú̱wa.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","E' ukuöki̱ ta̱ ie' tö iché ikanè mésopa a̱: ‘Íyi ulitane tso'tke ye' alà ulabatske e' ké̱wö tkö'wo̱ie, erë wé̱pa kiule e'pa dör pë' suluë, e' kue̱ki̱ ye' kë̀ tö ka̱wö mepa ie'pa a̱ ye' alà ulabatske e' ké̱wö tkö'u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","E' kue̱ki̱ a' yú bet ñala̱ kibi ko̱s ese ki̱ ta̱ pë' ko̱s sué̱ a' tö e'pa a̱ ishke̱ñú ka̱wö tkö'u̱k ye' ta̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Eta̱ ikanè mésopa míyal ñala̱ ko̱s ki̱ ta̱ pë' ko̱s kué̱ ie'pa tö, pë' buaë ena pë' suluë, esepa dapa'wé̱ka̱ wé̱ ie'pa tso' iké̱wö tkö'u̱k e' wé a̱. Es iwé wà iëne tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Erë mik blu' de wé̱pa dapane e'pa sa̱u̱k, eta̱ wëm eköl sué̱itö kë̀ e̱' paiëule we̱s ika̱wöta̱ e̱' paiök ulabatsè ké̱wö tkö'wo̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","E' kue̱ki̱ blu' tö ie' a̱ iché: ‘A yami, ¿we̱s be' dewa̱? Be' kë̀ e̱' paiëule ulabatsè ké̱wö tkö'wo̱ ese datsi' wa.’ Erë wëm e' kë̀ wa̱ blu' iu̱tëne yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Eta̱ blu' tö iché ichkö̀ watiökwakpa a̱: ‘Wëm i' ulà ena iklö moú̱wa̱ a' tö ta̱ iu̱yö́ttsa̱ bánet stui ké̱ a̱, ee̱ ie' i̱u̱raë sia̱rë, ikà blardaë iweir tai̱ë e' kue̱ki̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ttè e' pakéyö a' a̱ e' wà dör i' es. S'tso' tai̱ë kiule a̱s Skëköl klö'u̱rakitö iblúie, erë wé̱pa shu̱kitbakitö esepa kë̀ dör tai̱ë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","E' ukuöki̱ ta̱ fariseowakpa míyal ta̱ ittérak ñita̱: “ilè chakö̀sö Jesús a̱ a̱s ie' tö ilè sulu chö̀ ikkatoie.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","E' kue̱ki̱ ie'pa tö iklépa we̱lepa ena Herodes klépa we̱lepa patkémi ie' a̱ ichakök. Ie'pa tö ie' a̱ iché: —A s'wöbla'u̱kwak, sa' wa̱ ijche̱r tö ke̱kraë be' ttö̀ moki̱ë. Be' tö sulitane sue̱ke ñikkëë. I̱ma pë' tö be' cheke e' kë̀ ki̱ be' tkine. E' kue̱ki̱ be' tö s'wöbla'we̱ke yësyësë Skëköl ñalé̱ tté wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","E' kue̱ki̱ ichö́ sa' a̱, ¿i̱ma be' tö ibikeitsè? Roma wökir kibi patuè̱sö ¿e' dör buaë ö kë̀ idör buaë? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ie' tö isué̱wa̱ tö ie'pa tso' ie' chakök e̱r sulu wa, e' kue̱ki̱ ie' iiu̱té i' es: —A' e̱' ö̀ suluë, ¿Ì kue̱ki̱ a' tso' ye' ma'u̱k tsa̱iè? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Inuköl tso' a' wa̱ Roma wökir patuo̱ie, e' kkachö́ ye' a̱ et. Ta̱ ie'pa wa̱ inuköl wöshki ese debitu̱ia̱ et. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Eta̱ ie' tö ie'pa a̱ ichaké: —¿Yi diököl ena yi kiè me'rka̱ iki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ie'pa iiu̱té: —Roma wökir kibi. Eta̱ ie' tö ie'pa a̱ iché: —E̱'ma ko̱s Roma wökir kibi icha, ese mú ie' a̱, ta̱ ko̱s Skëköl icha ese mú ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mik ie'pa tö e' ttsé, eta̱ ie'pa tkinewa̱. Ie'pa tö iméa̱t ta̱ imíyal. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","E' ë̀ diwö wa, saduceowakpa we̱lepa de Jesús ska'. E' wakpa tö iklö'wé̱ tö s'duowa̱ e'pa kë̀ shke̱nukka̱ne. Ie'pa tö ie' a̱ ichaké: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—A s'wöbla'u̱kwak, Moisés tö se' a̱ iyë'a̱t tö wëm blënewa̱ kë̀ alà a̱te̱, e' ta̱ ie' ël ka̱wöta̱ ischö́ tsu̱kwa̱ a̱s ilà kö̀ka̱ iël blënewa̱, e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Etökicha sa' shu̱a̱ wëpa bak döka̱ kul ñì ëlpa. Ikibi alaköl tsé̱wa̱, erë iblënewa̱ kë̀ alà a̱te̱. E' ukuöki̱ ta̱ ie' itöki̱ iël tö ischö́ tsé̱wa̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","erë ñies e' blënewa̱ kë̀ alà a̱te̱. Es itka iël skà ta̱ ñies imale̱pa ko̱s e'pa ta̱. Ie'pa kul blërulune kë̀ alà a̱te̱ yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bata ekkë ta̱ ñies ilaköl blënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wëpa kul e'pa bak alaköl eköl ë̀ ta̱. Mik s'duowa̱ e'pa shke̱neka̱ne, eta̱ ¿wé̱ne dö̀mi ie' wëm chö́kie? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ie' tö ie'pa iu̱té: —A' kë̀ wa̱ Skëköl yëkkuö su̱ule, ñies ie' diché kë̀ jche̱r a' wa̱, e' kue̱ki̱ a' wöa̱ ká̱ chowa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mik s'duolur e'pa shke̱neka̱ne, eta̱ wëpa ena alakölpa kë̀ se̱rpawa̱ia̱ ñita̱. E'pa míyal we̱s Skëköl biyöchökwakpa tso' ká̱ jaì a̱ kë̀ se̱rta̱'wa̱ ñita̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿A' ki̱ kiane jche̱no tö moki̱ s'duowa̱ e'pa shke̱rdaka̱ne? Ì yë' Skëköl tö a' a̱ iyëkkuö ki̱ ¿e' kë̀ a̱ritsule a' wa̱? Ie' tö iyë' Moisés a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ye' dör Abraham, Isaac ena Jacob, e'pa Këköl.’ Ie' kë̀ dör s'duowa̱ e'pa Këköl. ¡Ie' dör s'ttsë'ka e'pa Këköl! E' kue̱ki̱ se' wa̱ ijche̱r tö s'duowa̱ e'pa shke̱rdaka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mik pë' tö ttè wa Jesús tö s'wöbla'we̱ke ñe' ttsé, eta̱ ie'pa tkirulune. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mik fariseowakpa wa̱ ijche̱newa̱ tö Jesús tö saduceowakpa siwa̱'blöwé̱wa̱ ttè moki̱ wa, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","eta̱ ie'pa eköl dör s'wöbla'u̱kwak ttè dalöiëno wa, e' tö ie' a̱ ilè chaké itsa̱ioie: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—A S'wöbla'u̱kwak, Skëköl ttè dalöiëno ¿e' wé̱ne dör ibua'ie imale̱pa tsa̱ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ie' iiu̱té: —‘Këkë dör a' Këköl, e' dalëritsö́ a' e̱r ko̱s wa, a' wák ko̱s wa ena a' e̱rbikè ko̱s wa.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ttè e' dör ibua'ie ttè dalöiëno male̱pa ko̱s tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Erë e' itöki̱ ttè skà tso', e' dör we̱s iët ñe' es, e' tö ichè: ‘A' male̱pa dalëritsö́ we̱s a' wákpa e̱' dalër es.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ttè dalöiëno ko̱s kitbak Moisés tö ena Skëköl ttekölpa tö yëkkuö ki̱, e' wöiënewa̱ ttè böt ñe' ë̀ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseowakpa daparkeia̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","e' dalewa Jesús tö ie'pa a̱ ichaké: —¿I̱ma a' tö wé̱ pairine'bitu̱ idi' wa s'blúie e' chè, tö yi aleri idir? Ie'pa ie' iu̱té: —E' dör s'blú bak kiè David e' aleri. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Eta̱ ie' iché ie'pa a̱: —E' dör es, e' ta̱ ¿we̱s David tö iki' ie' Këköl? David tö iyë' Skëköl Wiköl wa i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Skëköl tö iché ye' Këköl a̱: Be' e̱' tkö́se̱r ye' ulà bua'kka dalöiëno tai̱ë, dö̀ mik ye' tö be' bolökpa mérö be' klö̀ diki̱a̱ eta̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ie' dör David aleri, e' ta̱ ¿we̱s e' kièmi David tö ie' Këköl? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kë̀ yi a̱ ie' iu̱tëneia̱ yës. E' ukuöki̱ ta̱ kë̀ yi kësik dë'ka̱ia̱ ie' a̱ ì skà chakök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","E' ukuöki̱ ta̱ Jesús tö iché ittökatapa a̱ ena s'tso' tai̱ë e' kukua: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","S'wöbla'u̱k ttè dalöiëno wa wakpa ena fariseowakpa a̱ ka̱wö mène ttè dalöiëno me'a̱tbak Moisés tö e' wà pakök se' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","E' kue̱ki̱ ì ko̱s dalöiök a' ké ie'pa tö e' dalöiö́. Erë ì dalöiök ie'pa tö a' ké ese kë̀ dalöieta̱' ie'pa wákpa tö. E' kue̱ki̱ kë̀ ie'pa waköwa̱r a' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ie'pa tö ttè dalöiëno tai̱ë darërëë ese meke s'male̱pa a̱ wà dalöiè. E' dör we̱s dalì e̱kke̱ë iè s'ki̱ es, erë ie'pa kë̀ tö iketa̱'wa̱ iulatska ë̀ wa s'ki̱moie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ì ko̱s we̱ke ie'pa tö e' dör s'ditsö ë̀ wö wa e̱' oie tö ie'pa dör pë' buaë. Skëköl ttè we̱le kitule datsi'tak ki̱, ese mue̱ke ie'pa tö iwötsa̱ ki̱ ena iulà ki̱ e̱' ki̱tkoie. Ñies ie'pa wöbatsö idatsi' ki̱tkök datsi'tak batsi̱batsi̱ chalala buaala ese wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wé̱ ie'pa ka̱wö tkö'u̱ke ñies ñì dapa'wo̱ wé a̱ ese ska' kula' tso' skëkëpa dalöiërta̱' tai̱ë esepa a̱, ese ki̱ ie'pa wöbatsö e̱' tkökse̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ñies ie'pa ki̱ ikiar tö pë' tö ie'pa shke̱'wè̱ we̱s këkëpa dalöiërta̱' tai̱ë ese shke̱'wè̱ es wé̱ pë' tso' tai̱ë e'pa wöwa. Ie'pa wöbatsö tö pë' tö ie'pa kiè ‘s'wöbla'u̱kwak’. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Erë a' ulitane dör ñies ë̀, e' kue̱ki̱ kë̀ a' ñì kiök ‘s'wöbla'u̱kwak.’ A' wöbla'u̱kwak e' dör eköl ë̀me e' kue̱ki̱ kë̀ a' ñì kiök es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ñies a' ulitane yë́ dör eköl ë̀me, e' dör Skëköl tso' ká̱ jaì a̱ e'. E' kue̱ki̱ kë̀ yi kiar ká̱ i' a̱ ‘S'yë́.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ñies a' wökir dör eköl ë̀me, e' dör wé̱ pairine'bitu̱ idi' wa s'blúie e'. E' kue̱ki̱ kë̀ a' ñì kiök ‘s'wökir.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","12","Yi e̱' ttséka̱ tai̱ë, esepa wöardawa; erë yi e̱' wöéwa diöshe̱t, esepa ki̱kardaka̱. E' kue̱ki̱ wé̱ dör ibua'ie a' shu̱a̱ ese ka̱wöta̱ e̱' wöökwa kanè mésoie imale̱pa ki̱muk. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“¡A s'wöbla'u̱k ttè dalöiëno wa wakpa, a fariseowakpa, wëstela i̱na a' ta̱! ¡A' e̱' ö̀ suluë! Ì blúie Skëköl tso' e' wékkö wötekewa̱ a' tö s'male̱pa yöki̱ a̱s kë̀ ie'pa döwa̱. A' kë̀ mi'wa̱, ñies wé̱pa shkakwa̱ esepa wöklö'we̱ke a' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡A s'wöbla'u̱k ttè dalöiëno wa wakpa, a fariseowakpa, wëstela i̱na a' ta̱! ¡A' e̱' ö̀ suluë! A' shköke ká̱ ko̱s ekkë ki̱ s'yulök a̱s ie̱' yuö̀ a' ttökataie. Mik a' ikué̱, eta̱ iyué a' tö ì sulu wamblökwak tai̱ë tkö̀ka̱ a' wákpa tsa̱ta̱. Es ie' weirdaë sia̱rë bö' ké̱ a̱ we̱s a' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡A' dör we̱s sulaiökwakpa wöbla kë̀ wawër es! ¡Wëstela i̱na a' ta̱! A' icheke: ‘Yi tö ttè mé Skëköl wé wa, ese kë̀ ka̱wöta̱ iiu̱tök kröröë. Erë yi tö ttè mé orochka tso' wötëule Skëköl wé mik e' wa, e' ta̱ e' wà ka̱wöta̱ iu̱tè.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡A' kë̀ e̱r ta̱'! ¡A' dör we̱s s'wöbla kë̀ wawër es! ¿Ì dör ibua'ie, orochka tso' Skëköl wé mik e' ö Skëköl wé tö orochka batse'wé̱ e'? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ñies a' tö icheke: ‘Yi tö ttè mé ka̱' tso' íyi moka̱ Skëköl a̱ e' wa, e' ta̱ ese kë̀ ka̱wöta̱ iiu̱tök kröröë. Erë yi tö ttè mé íyi me'rka̱ ka̱' ñe' ki̱ e' wa, e' ta̱ e' wà ka̱wöta̱ iu̱tè.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡A' dör we̱s s'wöbla kë̀ wawër es! ¿Ì dör ibua'ie, íyi me'rka̱ ka̱' ñe' ki̱ e' ö ka̱' tö ibatse'wé̱ e'? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yi tö ttè mé ka̱' ñe' wa, ese kë̀ ku̱' ttè muk ka̱' ñe' ë̀ wa, ñies ie' tso' ttè muk ko̱s ì tso' iki̱ e' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Yi tö ttè mé Skëköl wé wa, ese kë̀ ku̱' ttè muk Skëköl wé ë̀ wa. Ñies ie' tso' ttè muk Skëköl se̱rke ee̱ e' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yi tö ttè mé ká̱ jaì wa ese tso' ñies ttè muk Skëköl kulé wa. Ñies itso' ttè muk Skëköl wák tkër ikulé ki̱ e' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡A s'wöbla'u̱k ttè dalöiëno wa wakpa, a fariseowakpa, wëstela i̱na a' ta̱! ¡A' e̱' ö̀ suluë! Ka̱köla tso' iëno chkè a̱ kiè menta ena anís ena comino ese ko̱s tsá̱ meke a' tö Skëköl a̱. E' dör buaë erë ttè dalöiëno e' bua'ie kë̀ dalöiè a' tö. E' dör se̱ne yësyësë, ena ñì sa̱ù̱ e̱r sia̱rë wa ena e̱rblö̀ Skëköl mik moki̱ kë̀ ilo'yeta̱'. Ñies e' ko̱s dalöiök a' ka̱wöta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡A' dör we̱s sulaiökwakpa wöbla kë̀ wawër es! E' dör we̱s a' tö schö'wak wöppée tá̱ a̱, erë kameio malé̱wa̱ a' tö wa'ñe, kë̀ ittsë'ne a' wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡A s'wöbla'u̱k ttè dalöiëno wa wakpa, a fariseowakpa, wëstela i̱na a' ta̱! ¡A' e̱' ö̀ suluë! A' dör we̱s a' tka̱' ko̱s pa skueke a' tö iki̱kke̱ ë̀ es. A' wër buaë erë a' e̱r suluë. A' dör akblökwakpa. A' ki̱ s'yamipa íyi ko̱s kianettsa̱ a' ë̀ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡A fariseowakpa, a' dör we̱s s'wöbla kë̀ wawër es! Tka̱' ttö̀ skuö́ö ke̱we, es ñies iki̱kke̱ pa sune. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡A s'wöbla'u̱k ttè dalöiëno wa wakpa, a fariseowakpa, wëstela i̱na a' ta̱! ¡A' e̱' ö̀ suluë! A' dör we̱s pö pate̱ule saruruë es. Ese wër buaë iki̱kke̱, erë ishu̱a̱ s'nu diché tso' tai̱ë, e' dör ñá suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","A' dör we̱s pö ese es, a' e̱' ö̀ tö a' dör pë' buaë yësyësë, erë a' e̱r dör suluë. A' dör e̱' ökwakpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡A s'wöbla'u̱k ttè dalöiëno wa wakpa, a fariseowakpa, wëstela i̱na a' ta̱! ¡A' e̱' ö̀ suluë! A' tö Skëköl ttekölpa bak ká̱ ia̱ia̱ë e'pa pö yuekene pa̱'a̱li̱. Ñies ì yué a' tö a̱s s'se̱r yësyësë bak e'pa kë̀ chöwa a' é̱na, ese ki̱tkeke a' dör buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","E' dalewa a' icheke: ‘Sa' tkö́pa sa' yë́pa bak ká̱ ia̱ia̱ë e'pa ké̱wö ska' ta̱, e̱'ma kë̀ sa' wa̱ ie'pa sini'ku̱ne Skëköl ttekölpa ttökulur.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mik e' cheke a' tö, eta̱ a' e̱' chökeka̱ tö a' dör wé̱pa tö Skëköl ttekölpa kötulur, e'pa aleripa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","We̱s a' mir e' wa iwënewa̱ tö ì sulu wamblë'mi a' yë́pa tö ese kí̱ wambleraë a' tö dö̀ ibataie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡A' dör suluë we̱s tkabë̀ es, we̱s tkabë̀ ichö́k es! ¿We̱s a' tkömishkar kë̀ wömerpattsa̱ weinuk bö' ké̱ a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ittsö́, ye' tö Skëköl ttekölpa ena s'pattökwakpa ena s'wöbla'u̱kwakpa ye' ttè wa, esepa patkeraë a' a̱. Erë a' tö ie'pa we̱lepa tterawa̱, we̱lepa skà wöterawa̱ a' tö krus mik ttèwa̱, we̱lepa skà pperaë sia̱rë a' tö ttsa'bata daloie wa a' ñì dapa'wo̱ wé a̱. Ie'pa yuleraë a' tö iwe'ikeraë a' tö ká̱ wa'ñe. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","E' kue̱ki̱ s'se̱r yësyësë kötulur a' yë́pa tö mik Abel kötwa̱ Caín tö döka̱ mik Zacarías dör Berequías alà e' kötwa̱ a' yë́pa tö ka̱' tso' íyi moka̱ Skëköl a̱ e' ena ie' wé e' shu̱sha̱, e' nuí̱ ko̱s kierane ie' tö a' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Moki̱ ye' tö a' a̱ ichè tö s'se̱r yësyësë ko̱s kötulur a' yë́pa tö, e' nuí̱ ki̱ a' ena wé̱pa dör we̱s a' es esepa weirdaë sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡A Jerusalén wakpa, Skëköl ttekölpa ko̱s ttekewa̱ a' tö ke̱kraë! Ñies ittè pakökwakpa patkeke ie' tö a' a̱, e'pa ttekewa̱ a' tö ák wa. ¡We̱kkë ye' e̱rkiè tö ye' mú a' dapa'wè̱ e̱' ska' we̱s dakro mitchke tö ila'rla dapa'wè̱ ipik diki̱a̱ es, erë kë̀ a' ki̱ ikiane yë! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ye' ttö̀ ttsö́, Skëköl kë̀ tö a' ká̱ kkö'nepaia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ye' tö a' a̱ ichè tö i'ta̱mi a' kë̀ tö ye' sue̱paia̱ dö̀ mik ye' dene eta̱. E' ké̱wö ska' ta̱ a' tö ye' cheraë: ‘¡Ayëcha buaë yi datse̱ Skëköl ttö̀ wa e'!’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús e̱' yéttsa̱ Skëköl wé a̱ ta̱ imía̱ ta̱ ittökatapa de ie' ska' ta̱ Skëköl wé ena u bua'bua skà tso' ipamik, e' kkaché ie'pa tö ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Erë ie' iché: —Moki̱ ye' tö a' a̱ ichè tö u ko̱s tso' bua'buaë sué̱ a' tö í̱e̱, e' olordawa̱ se̱raa̱, iékwö ë̀ kë̀ a̱tpa ñì bata ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","E' ukuöki̱ ta̱ ie'pa míyal ka̱bata kiè Olivo ee̱. Jesús e̱' tkése̱r ta̱ ittökatapa de ie' ska' ta̱ ie' ë̀ a̱ ichaké: —Ichö́ sa' a̱ ¿mik íyi ekkë wamblërmi? ¿Ì wa sö isuè̱mi tö be' dotkene, ñies tö ká̱ i' e̱rkewatke? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Ie' tö ie'pa iu̱té: —Tai̱ë pë' datse̱ e̱' chök tö ie'pa dör ye'. Icherarakitö: ‘Ye' dör wé̱ pairine'bitu̱ idi' wa s'blúie e'’, ta̱ pë' ki̱terarakitö tai̱ë. E' kue̱ki̱ a' tso' wösh wa a̱s kë̀ yi tö a' ki̱tö'ù̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ká̱ tai̱ë wakpa ñippöke tai̱ë wì̱ a̱ dià a̱ e' biyö́ ttseraë a' tö. E' wake' tköraë erë ká̱ i' e̱rwami e' kianeia̱. E' kue̱ki̱ kë̀ a' tkinuk e' wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ká̱ kua̱'ki̱ kua̱'ki̱ wakpa ñippöraë ñita̱. Ñies í̱ tö ká̱ wöti̱'we̱raë ká̱ wa'ñe. Ñies ká̱ tseë wakpa tteraë bli tö tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Erë íyi ekkë ko̱s dör e̱rpa s'tsá̱ weirketke ka̱m ye' döne e' yöki̱ ese. E' dör we̱s alaköl alà ku̱rketke ta̱ ikirir es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“A' merdattsa̱ we'ikè. A' ttelurdaë pë' tö. Sulitane tö a' sue̱raë suluë ye' tté kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","E' ké̱wö ska' ta̱ wé̱pa e̱rblé ye' mik, esepa tai̱ë tö ye' waterattsa̱. Ie'pa ñì sa̱u̱raë suluë, ñies we̱lepa tö iëltëpa wömerattsa̱ ibolökpa ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ka̱chökwakpa e̱' chö̀ tö ie'pa dör Skëköl ttekölpa esepa döraë tai̱ë. Ie'pa tö s'ki̱tö'we̱raë tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ì sulu kí̱ wamblërdaë tai̱ë shu̱te̱, e' kue̱ki̱ s'kibiie kë̀ tö imale̱pa dalëritsepaia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Erë yi e̱' tkéwa̱ darërëë döka̱ bata ekkë, esepa tsa̱tkërdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ì blúie Skëköl tso' e' tté buaë pakardaë ká̱ wa'ñe a̱s ká̱ ulitane wakpa wa̱ ijche̱r, e' ukuöki̱ ta̱ ká̱ i' e̱rdawa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Skëköl tteköl bak kiè Daniel, e' tö ikit iyëkkuö ki̱ tö ì sulusi tö ì dör batse'r e' ia'wè̱ ñáie, e' dörawa̱ Skëköl wé a̱ iia'u̱kka̱ ñáie, (yi tso' yëkkuö i' sa̱u̱k, e' é̱na iwà a̱nú). Mik e' sué̱ a' tö, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","eta̱ wé̱pa se̱rke Judea e'pa tkö́yalmi ka̱bata a̱; ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","yi tso' u bata ki̱ esepa tkö́shkar kë̀ dökwa̱ne we̱shke̱ iíyi tsu̱kmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ñies yi tso' kaneblök kañika̱ esepa kë̀ dökwa̱ne we̱shke̱ idatsi' yöktsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","E' ké̱wö ska' ta̱ alakölpa alà ku̱rketke ena alakölpa tsu' muke ilà a̱ ¡wëstela i̱na esepa ta̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","21","S'ditsö weirdaë tai̱ë shu̱te̱. Mik ká̱ i' yöne dö̀ ikkë ta̱ kë̀ s'we'ikule ekkë, ñies kë̀ s'weirpa aishkuö ta̱ ekkë. E' kue̱ki̱ ikiö́ Skëköl a̱ a̱s kë̀ iwamblër a' ta̱ yuëdiö ké̱ska' ö e̱no diwö a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","E' ké̱wö kë̀ wöö́pawa Skëköl tö, e̱'ma kë̀ yi isie a̱tu̱kia̱ ttsë'ka. Erë e' ké̱wö wöerawaitö, wé̱pa shu̱kitbakitö esepa dalërmik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","“Ka̱chökwakpa e̱' köraka̱ e̱' chök tö ie'pa dör wé̱ pairine'bitu̱ idi' wa s'blúie e' ö Skëköl tteköl we̱le. E'pa tö ì kë̀ o̱r yi a̱ ese we̱raë s'ki̱tö'wo̱ie tö ie'pa ttè dör moki̱ë. Dö̀ wé̱pa shu̱kit Skëköl tö, esepa mú ki̱tërmi, e̱'ma iki̱tërdaë. E' kue̱ki̱ yile tö a' a̱ icheke: ‘Isa̱ú̱, wé̱ pairine'bitu̱ idi' wa s'blúie e' dur í̱e̱’, ö ‘Isa̱ú̱, ie' dur wì̱e̱’, e' ta̱ kë̀ a' tö iklö'wa̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ittsö́, íyi ekkë biyö́ chétkeyö a' a̱ ke̱weie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","E' kue̱ki̱ mik ie'pa tö icheke a' a̱: ‘Isa̱ú̱, wé̱ pairine'bitu̱ idi' wa s'blúie e' tso' ká̱ wé̱ kë̀ yi se̱rku̱' ee̱’, eta̱ a' kë̀ minuk isa̱u̱k. Mik ie'pa tö icheke a' a̱: ‘Isa̱ú̱, ie' tso' í̱e̱ blëulewa̱’, eta̱ kë̀ a' tö iklö'wa̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ye' dör S'ditsö Alà, mik e' dene, eta̱ sulitane tö isue̱raë we̱s alá wöñar tö ká̱ olo ppèe ká̱ wa'ñe e' suè̱sö es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sulitane wa̱ ijche̱r tö wé̱ ölö́ daparke tai̱ë, ee̱ ilè nu tër. Es ñies mik ye' dene, eta̱ sulitane wa̱ ijche̱rdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“S'weine e' ké̱wö tka, e' bet diwö wötuirdawa̱, ñies si'wö kë̀ wöñarpaia̱. Bëkwö darolordaë ena ì ko̱s tso' ká̱ jaì a̱ e' wöti̱rdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Eta̱ sulitane tö íyi sue̱raë ká̱ jaì a̱ iwà kkachoie tö ye' dör S'ditsö Alà, e' datse̱ne bet. Ká̱ ulitane wakpa suardaë tai̱ë e' yöki̱, ie'pa i̱u̱raë tai̱ë ta̱ bet ie'pa tö isue̱raë tö ye' datse̱ ka̱shu̱k a̱ mò a̱ diché ta̱' tai̱ë olo ta̱' tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Duk blardaë tai̱ë ta̱ ye' biyöchökwakpa patkeramiyö wé̱pa shu̱kitbakyö, esepa dapa'u̱kka̱ ek tsi̱ní ë̀me. Ie'pa tö iyuleraë ká̱ wa'ñe dö̀ wé̱ ká̱ i' bata e̱rkerö ee̱ ena wé̱ ká̱ jaì bata e̱rkerö ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“A' e̱' wöbla'ú̱ ttè ikkë wa iwà sa̱ú̱ higo klö̀ wa: Mik iulatska tso' ulölöla ena e̱rpa iköyök tskirdoka̱, eta̱ a' wa̱ ijche̱r tö duas dewa̱tke tsi̱net. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Es ñies mik a' tö isué̱ tö íyi ekkë wamblërke, eta̱ a' wa̱ ijche̱nú tö ye' datskene, e' diwö dewa̱tke tsi̱net. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Moki̱ ye' tö a' a̱ ichè tö íyi ekkë wamblërdaë wé̱pa dör we̱s a' es esepa ka̱m e̱rwa e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ka̱shu̱k ena ká̱ i' e̱rdawa, erë ye' ttè michoë e' kë̀ e̱rpawa yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Erë e' ké̱wö e' diwö kë̀ jche̱r yi wa̱. Skëköl biyöchökwakpa tso' ká̱ jaì a̱, e'pa kë̀ wa̱ ijche̱r, ñies ye' dör Skëköl Alà e' kë̀ wa̱ ijche̱r. S'yë́ ë̀ wa̱ ijche̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Ye' dör S'ditsö Alà, mik e' dene eta̱ e' ké̱wö dör we̱s Noé ké̱ska' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","E' ké̱ska' ta̱ ka̱m di' tai̱ë tkö̀ e' yöki̱, ie'pa tso' chkök, di'yök, se̱nukwa̱ we̱s ke̱kraë es dö̀ mik Noé dewa̱ ikanò bërie e' a̱ eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Erë ie'pa kë̀ ku̱' ipanuk yës eta̱ di' dettsa̱ tai̱ë ie'pa ki̱, e' tö ie'pa ulitane ttélur. Es itköraë mik ye' dör S'ditsö Alà e' dene eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","E' ké̱wö ska' ta̱ wëm böl tso' kaneblök ese eköl mira iwa̱ ta̱ iëköl a̱tdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Alakölpa böl tulur ák wawök, ese eköl mira iwa̱ ta̱ iëköl a̱tdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“E' kue̱ki̱ a' tso' e̱rki̱. A' kë̀ wa̱ ijche̱r tö diwö we̱kkë a' Këköl dörane. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","A' wa̱ ijche̱r buaë tö u wák mú wa̱ ijche̱r tö we̱kkë akblökwak datse̱, e̱'ma kë̀ ikapöpawa̱ iyöki̱, kë̀ itö ka̱wö mepa yi a̱ dökwa̱ iíyi ekiblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Es ñies ye' dör S'ditsö Alà, e' datskene mik a' kë̀ ku̱' ye' panuk eta̱, we̱s akblökwak es. E' kue̱ki̱ a' tso' e̱rki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kanè méso yësyësë ka̱bikeitsö̀ buaë, ese meraka̱ iwökir tö imale̱pa kue̱bluie ie'pa tiök ke̱kraë mik kë̀ iku̱' e' dalewa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Iwökir dene ta̱ ikué̱itö iwakanéu̱k we̱s iyëneia̱ es, e' ta̱ ayëcha e' dör buaë ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Moki̱ ye' tö a' a̱ ichè tö kanè méso ese meraka̱itö ie' wa̱ íyi tso' ko̱s e' kue̱bluie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Erë kanè méso ñe' dör suluë tö ibikeitsé tö kë̀ iwökir döpane bet. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","E' kue̱ki̱ ie' tö imale̱pa ppémi. Ñies ie' chkémi, blo' yémi bloblopa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Erë idiwö ena iké̱wö kë̀ wa ie' ku̱' ipanuk, eta̱ iwökir dörane ");
INSERT INTO bzdNTpo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ta̱ iwe'ikeraitö sia̱rë wömerattsa̱ weinuk e̱' ökwakpa ta̱. Ie'pa i̱u̱rarak sia̱rë, ikà blardaë iweir kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ì blúie Skëköl tso' e' ta̱ itköraë we̱s itka ulabatsè a̱ es. Busipala döka̱ dabop e' e̱' yélur ibö'wöla wa wëm ulabatsöke, e' ñale̱tsu̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Busipa ske̱l e'pa dör ka̱bikeitsöta̱' buaë esepa, erë imale̱pa ske̱l kë̀ dör es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Wé̱pa kë̀ ka̱bikeitsöta̱' buaë e'pa wa̱ ibö'wöla ë̀ mí, kë̀ wa̱ bö'wö diö̀ kí̱ mìne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Erë wé̱pa ka̱bikeitsöta̱', e'pa wa̱ ibö'wöla mí, ñies idiö kí̱ mírak iwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Erë wëm ulabatsöke, e' kë̀ dë' bet, iwötkëneka̱ e' kue̱ki̱. E' dalewa busipa shtrine ta̱ ikapolur. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ká̱ sha̱böts ta̱ ie'pa tö ittsé tö ia̱rkerak: ‘¡Wëm ulabatsöke, e' datse̱! ¡A' yú iñale̱tsu̱k!’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Eta̱ busipa ko̱s e̱' kéka̱ ta̱ ibö'wöla wötskémirakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Eta̱ busipa kë̀ ka̱bikeitsöta̱' e'pa tö iché imale̱pa a̱: ‘A' bö'wö diö̀ kakmú sa' a̱ a̱s sa' bö'wöla kë̀ wöìtwa̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Erë ie'pa iiu̱té: ‘Au, sa' tö imé a' a̱, e' ta̱ kë̀ idö̀paka̱ se' ulitane ki̱. E' kue̱ki̱ a' yú a' icha ta̱u̱k wé̱ iwato̱rke ee̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Eta̱ ie'pa míyal bö'wö diö̀ ta̱u̱k. E' dalewa wëm ulabatsöke e' de, eta̱ wé̱pa wa̱ bö'wö diö̀ kí̱ mí e'pa dewa̱ wëm ulabatsöke e' ta̱ iulabatso wé a̱ ta̱ iwékkö wötënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","E' ukuöki̱ ta̱ busipa male̱pa debitu̱ ta̱ ichakeke u'rki̱: ‘¡A këkëpa, a këkëpa, ukkö kköppö́ö sa' a̱!’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Erë wëm ulabatsöke e' tö ie'pa iu̱té: ‘Moki̱ ye' tö a' a̱ ichè tö kë̀ ye' wa̱ a' su̱ule.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Ye' tö a' a̱ ichè tö a' kë̀ wa̱ ijche̱r ì ké̱wö, ì diwö ye' dömine e' kue̱ki̱ a' tso' e̱rki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ñies ì blúie Skëköl tso' e' ta̱ itköraë we̱s itka wëm eköl mi'kea̱ ka̱mië ká̱ kua̱'ki̱ a̱ ese ta̱ es. Ie' tö ikanè mésopa kié ta̱ iché ie'pa a̱: ‘Ye' inuköl wakaneú̱ ye' a̱ buaë a̱s ikí̱ klör.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ikanè méso eköl a̱ ie' tö inuköl kiè talento ese mé mil ske̱l (5.000). Iëköl a̱ ie' imé mil böt (2.000). Eta̱ iskà a̱ ie' tö imé mil et ë̀ (1.000). Ie' tö ie'pa a̱ imé ko̱s ie'pa a̱ iwakaneo̱r ekkë. E' ukuöki̱ ta̱ ie' mía̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wé̱ne a̱ imène mil ske̱l, e' tö iwakanewé̱ buaë. Ie' tö ikí̱ klö'wé̱ mil döka̱ ske̱l. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Es ñies wé̱ne a̱ imène mil böt, e' tö ikí̱ klö'wé̱ mil döka̱ böt. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Erë wé̱ne a̱ imène mil et, e' mía̱ ta̱ íyök biéitö e' a̱ itö iwökir inuköl wötéwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ká̱ de tai̱ë eta̱ ie'pa wökir dene e' tö ie'pa kié isuo̱ie tö ko̱s ie'pa tö inuköl kí̱ klö'wé̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Wé̱ne a̱ imène mil ske̱l, e' de ke̱we iwökir ska'. Ie' wa̱ inuköl kí̱ debitu̱ mil döka̱ ske̱l. Ie' iché iwökir a̱: ‘A këkëpa, be' tö ye' a̱ inuköl me' mil ske̱l, e' kí̱ klö'wé̱yö mil döka̱ ske̱l.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Iwökir tö iché ie' a̱: ‘E' dör buaë, be' dör kanè méso buaë yësyësë. Inuköl elkela me'yö be' a̱ e' wakanewé̱ be' tö yësyësë. E' kue̱ki̱ ye' tö íyi skà meraë be' a̱ tai̱ë wakanewè̱. Be' shkö́wa̱ ttsë'nú buaë ye' ta̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","E' ukuöki̱ ta̱ wé̱ne a̱ imène mil böt e' de ta̱ ichéitö: ‘A këkëpa, be' tö ye' a̱ inuköl me' mil böt, e' kí̱ klö'wé̱yö mil döka̱ böt.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Iwökir tö ie' a̱ iché: ‘E' dör buaë, be' dör kanè méso buaë yësyësë. Inuköl elkela me'yö be' a̱ e' wakanewé̱ be' tö yësyësë. E' kue̱ki̱ ye' tö íyi skà meraë be' a̱ tai̱ë wakanewè̱. Be' shkö́wa̱ ttsë'nú buaë ye' ta̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Erë kanè méso a̱ imène mil et, mik e' de, eta̱ ie' tö iché iwökir a̱: ‘A këkëpa, ye' wa̱ ijche̱r tö be' dör wëm e̱r darërëë ese. Be' tö íyi wöshteke wé̱ kë̀ be' wa̱ ikuatkëne ee̱. Ñies ì kë̀ dör be' icha ese klö'we̱kewa̱ be' dör. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","E' kue̱ki̱ ye' suane be' yöki̱ dö' ye' tö be' inuköl chöwè̱wa. E' kue̱ki̱ be' inuköl blé ye' tö íyök a̱. I' be' inuköl dene ye' wa̱ be' a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Eta̱ iwökir tö iiu̱té: ‘Be' dör kanè méso suluë, bikër tai̱ë ese. Be' iché tö ye' tö íyi wöshteke wé̱ kë̀ ye' wa̱ ikuatkëne ee̱ ena ì kë̀ dör ye' icha ese klö'we̱kewa̱yö, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","e' ta̱ be' tö ye' inuköl blö́pa inuköl bló wé a̱ a̱s ee̱ ikí̱ klör. Be' ikaneú̱pa es, e̱'ma ye' dene eta̱ ye' inuköl ena ikí̱ klöne, e' de ye' ulà a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","29","Eta̱ ie' tö iché: ‘Wé̱ wa̱ íyi tso' e' a̱ ikí̱ merdaë. Erë wé̱ kë̀ wa̱ ì ku̱', ì tso' e' wa̱ elkela e' yerattsa̱ iyöki̱. E' kue̱ki̱ inuköl me'yö ie' a̱, e' yö́ttsa̱ ie' ulà a̱ ta̱ imú wé̱ wa̱ itso' döka̱ 10.000 e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Eta̱ kanè méso suluë i' e' u̱yö́ttsa̱ stui ké̱ a̱, ee̱ pë' suluë i̱u̱rarak sia̱rë ikà blardaë iweir kue̱ki̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ye' dör S'ditsö Alà, e' dörane s'blúie olo ta̱' tai̱ë ye' biyöchökwakpa ko̱s ta̱. Mik ye' dene, eta̱ ye' e̱' tköraka̱ blu' kulé ki̱ ká̱ ulitane wakpa shu̱lök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ie'pa dapardaë ye' wörki̱ ta̱ ye' tö ie'pa blabatseraë we̱s iyiwak kkö'nukwak tö obeja ena chibo blabatsè es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","S'se̱r yësyësë esepa dör we̱s obeja es, ie'pa merawa̱ ye' tö ye' ulà bua'kka. S'se̱r suluë esepa dör we̱s chibo es, ie'pa merawa̱ ye' tö ye' ulà bakli̱'kka. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","36","Eta̱ ye' tö icheraë wé̱pa tso' ye' ulà bua'kka e'pa a̱: ‘Ye' dör a' blú. Ye' yë́ e̱r bua' ché a' a̱. Mik ye' du' bli wa̱, eta̱ a' tö ye' dë'; mik ye' bak e̱rsinuk, eta̱ a' tö ye' a̱ di' me'; a' kë̀ wa̱ ye' su̱ule, erë a' tö ye' kiéwa̱ buaë a' u a̱. Ye' bak datsi' kë̀ ta̱', eta̱ a' tö ye' a̱ datsi' kakme'; ye' bak duök sia̱rë, eta̱ a' dë' ye' ki̱muk; ye' bak wötëulewa̱ s'wöto wé a̱, eta̱ a' dë' ye' sa̱u̱k. E' kue̱ki̱ a' shkö́wa̱ ì blúie ye' tso' e' a̱, e' ko̱s yöulebak a' a̱ ka̱m ká̱ i' yör e' yöki̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Erë s'se̱r yësyësë e'pa tö ye' a̱ ichakeraë: ‘A Skëkëpa, sa' kë̀ wa̱ ijche̱r. ¿Mik sa' tö be' su̱' tö be' tteke bli tö, e' dë' sa' tö? ¿Mik sa' tö be' su̱' tö be' tteke e̱rsi tö, e' a̱ di' me' sa' tö? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Mik be' dë'bitu̱ sa' u a̱, kë̀ su̱ule sa' wa̱, e' ki'wa̱ buaë sa' tö? ¿Mik sa' tö be' su̱' datsi' kë̀ ta̱', e' a̱ datsi' kakme' sa' tö? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Mik sa' tö be' su̱' tö be' duöke ö be' wötëulewa̱ s'wöto wé a̱, e' sa̱u̱k sa' dë'?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Eta̱ ye' tö ie'pa iu̱teraë: ‘Moki̱ ye' tö a' a̱ ichè tö mik a' tö íyi ekkë buaë o̱' ye' yamipa sia̱rë ikkëpa a̱, eta̱ e' dör we̱s a' tö ye' wák a̱ iwè̱ es.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","43","“E' ukuöki̱ ta̱ ye' tö icheraë wé̱pa tso' ye' ulà bakli̱'kka e'pa a̱: ‘Ye' du' bli wa̱, erë a' kë̀ wa̱ ye' dëne; ye' bak e̱rsinuk, erë a' kë̀ wa̱ ye' a̱ di' mène. Ye' dë' a' ska', kë̀ su̱ule a' wa̱, erë a' kë̀ wa̱ ye' kinewa̱ a' u a̱; ye' bak datsi' kë̀ ta̱', erë a' kë̀ wa̱ datsi' mène ye' a̱; ye' bak duök ena wötëulewa̱ s'wöto wé a̱, erë a' kë̀ dë' ye' sa̱u̱k. E' kue̱ki̱ a' wömeulettsa̱bak weinuk sia̱rë. A' e̱' skö́ttsa̱ ye' yöki̱. A' yúshka bö' ñar michoë yöule bë́ ena iklépa we'ikoie e' a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Erë ie'pa tö ye' a̱ ichakeraë: ‘A Skëkëpa, e' kë̀ jche̱r sa' wa̱. ¿Mik sa' tö be' su̱' tö be' duöke bli wa̱? ¿Mik sa' tö be' su̱' tö be' e̱rsine? ¿Mik be' dë' sa' u a̱? ¿Mik sa' tö be' su̱' datsi' kë̀ ta̱'? ¿Mik sa' tö be' su̱' duöke ö wötëulewa̱ s'wöto wé a̱? ¿Mik sa' kë̀ wa̱ be' ki̱mene?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Eta̱ ye' tö ie'pa iu̱teraë: ‘Moki̱ ye' tö a' a̱ ichè tö mik a' kë̀ wa̱ íyi ekkë o̱ne s'sia̱rëpa ikkëpa a̱, eta̱ e' dör we̱s kë̀ a' wa̱ ye' wák a̱ io̱ne es.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","S'se̱r suluë esepa michoë weinuk, erë s'se̱r yësyësë esepa se̱r michoë buaë ye' ta̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mik Jesús tö s'wöbla'wé̱ ko̱s e' o̱ne, eta̱ ie' tö iché ittökatapa a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—A' wa̱ ijche̱r tö böiki se' tö Se' Yë́pa Yërulune Egipto e' ké̱wö tkö'we̱ke. E' ké̱wö ska' ta̱, ye' dör S'ditsö Alà, e' wömerdattsa̱ ttèwa̱ wötëulewa̱ krus mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","E' ké̱wö ska' ta̱ sacerdotepa wökirpa ena judiowak kue̱blupa ñì dapa'wé̱ sacerdote kibi kiè Caifás, e' u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ee̱ ie'pa tö Jesús aleritsé ki̱tö'wè̱ iklö'wo̱wa̱ ttèwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Erë ie'pa iché ñì a̱: —Kë̀ sö iwamblè Se' Yë́pa Yërulune Egipto e' ké̱wö tkö'we̱kesö e' a̱ a̱s pë' kë̀ shu̱ti̱rka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús tso' Betania, Simón kiri'u̱k lepra bak, e' u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ie' tkëria̱ mesa ki̱ chkök. Eta̱ alaköl eköl de ie' ska', e' wa̱ kiö̀ masmas tuè̱ darërëë ese debitu̱, e' mí ie' wa̱ iukkuö yöule ák bua'bua wa ese a̱. Eta̱ kiö̀ e' téka̱itö Jesús wökir ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Erë mik e' sué̱ ittökatapa tö, eta̱ ie'pa uluneka̱ ta̱ iché: —¿Iö́k kiö̀ se̱ we'ikéwa ie' tö ëanas? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iwato̱rmittsa̱ inuköl tai̱ë skéie s'sia̱rëpa ki̱moie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","E' ttsé Jesús tö ta̱ ie' tö iché ie'pa a̱: —¿Iö́k a' tso' alaköl i' tsiriu̱k? Íyi buaë wé̱itö ye' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","S'sia̱rëpa tso' ke̱kraë a' shu̱a̱, erë ye' kë̀ ku̱' ke̱kraë a' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kiö̀ téka̱itö ye' ki̱ ye' kanéwo̱ie ka̱m ye' nu wötërwa̱ e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Moki̱ ye' a' a̱ ichè tö ká̱ wa'ñe wé̱ Skëköl ttè buaë pakarke, ee̱ ipakardaë ñies tö ie' tö ì buaë o̱' ye' a̱. Es e' kë̀ chöpawa yi é̱na. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesús ttökatapa dabom eyök kí̱ böl, e'pa eköl dör Judas Iscariote, e' mía̱ sacerdotepa wökirpa ska' ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ta̱ ie' tö iché ie'pa a̱: —¿Ko̱s a' tö ye' patuè̱mi Jesús wömottsa̱ a' a̱? Eta̱ ie'pa tö inukölchka wöshki mé ie' a̱ döka̱ dabom mañayök (30). ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","E'ta̱mi ie' tö ka̱wö yulémi bua'iewa̱ Jesús wömottsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ka̱wö kiè Pan Kë̀ Yöule Iwölöwo̱ka̱ Wa e' ké̱wö tsá̱ diwö dewa̱tke. Eta̱ Jesús ttökatapa de ie' ska' ta̱ ie' a̱ ichaké: —¿Wé̱ be' ki̱ ikiane tö sa' tö Se' Yë́pa Yërulune Egipto ké̱wö tkö'we̱kesö e' chké kanewè̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ie' tö ie'pa iu̱té: —A' yú Jerusalén, wëm yë' ye' tö a' a̱ e' u a̱ ta̱ ichö́ ie' a̱: ‘S'wöbla'u̱kwak be' a̱ ichök ké: Ie' ké̱wö dökewa̱tke. Ie' datse̱ be' u a̱ ka̱wö tkö'we̱kesö e' tkö'u̱k sa' ta̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ie'pa tö iwé̱ we̱s ie' tö ie'pa a̱ iché es ta̱ ee̱ ie'pa tö ichké kanewé̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mik ka̱tuinetke, eta̱ ie' tkër mesa ki̱ chkök ittökatapa dabom eyök kí̱ böl e'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ie'pa chköke, e' dalewa ie' tö iché ie'pa a̱: —Moki̱ ye' tö a' a̱ ichè tö a' eköl tö ye' wömerattsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ie'pa e̱rianeka̱ tai̱ë ta̱ ichakémi ie' a̱ eköl eköl: —A Skëkëpa, ¿ye' alè idir? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ie' tö ie'pa iu̱té: —A' tso' ye' ta̱ pan nuu̱k tka̱' etkë̀ a̱ ñè, e' eköl ye' wömerattsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ye' dör S'ditsö Alà, e' ta̱ itköraë we̱s itso' kitule Skëköl yëkkuö ki̱ es. Erë wëstela i̱na yi ye' wömekettsa̱, e' ta̱. Buaë idir wëm e' a̱ tö kë̀ iku̱núpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Eta̱ Judas tö iwömekettsa̱, e' tö ie' a̱ ichaké: —A S'wöbla'u̱kwak, ¿ye' alè idir? Ie' iiu̱té: —Be' wák e̱' chéka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ie'pa tso'ia̱ chkök, e' shu̱a̱ pan klö'wé̱itö ta̱ e' ki̱ wëstela chéitö Skëköl a̱ ta̱ iblatéitö ta̱ iwà tié ie'pa a̱ ta̱ ichéitö: —Pan se̱ dör ye' chkà, e' ñú a' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","E' ukuöki̱ ta̱ tka̱' a̱ vino tso', e' klö'wé̱itö ta̱ e' ki̱ wëstela chéitö Skëköl a̱ ta̱ iméitö ie'pa a̱ ta̱ ichéitö: —Vino se̱ dör ye' pë́. Ye' tterawa̱ e' pë́ tërdaë, e' wa ttè pa̱'a̱li̱ me' Skëköl tö e' wà de. Ye' ttèwa̱, e' wa s'tso' tai̱ë e'pa nuì̱ olo'yarmi. E' kue̱ki̱ a' ulitane tö ikak yö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ye' tö a' a̱ ichè tö vino kë̀ yepaia̱yö dö̀ mik ì blúie ye' Yë́ tso' e' ké̱wö de da'a̱ie, eta̱ iskà yeraneyö a' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Eta̱ ie'pa tö Skëköl ttseittsé, e' ukuöki̱ ta̱ ie'pa míyal Olivo ké̱bata a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús tö iché ie'pa a̱: —I' nañewe a' ulitane tköyaldaë. A' ye' meraa̱t ekörla. E' dör we̱s itso' kitule Skëköl yëkkuö ki̱ es, e' tö ichè: ‘Obeja kkö'nukwak ttewa̱raëyö ta̱ obeja pordami wì̱ a̱ dià a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Erë mik ye' ttéwa̱ shke̱neka̱ne, e' ukuöki̱ ta̱ ye' miraë Galilea a' yöki̱ ke̱we. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro tö ie' a̱ iché: —Erë́ ie'pa ulitane be' memia̱t ekörla, erë ye' kë̀ tö be' mepaa̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ie' tö iiu̱té: —Moki̱ ye' ichè be' a̱ tö i' nañewe, ka̱m dakro a̱r, e' yöki̱ be' icheraë mañatökicha tö be' kë̀ wa̱ ye' su̱ule. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro tö ie' a̱ iché: —Erë́ ye' ttèmiwa̱rakitö be' ta̱, erë kë̀ ye' ichepa tö kë̀ ye' wa̱ be' su̱ule. Eta̱ ie'pa ulitane ttöke es ë̀me. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","E' ukuöki̱ ta̱ Jesús mía̱ ittökatapa ta̱ ká̱ kiè Getsemaní ee̱. Ie' tö iché ie'pa a̱: —A' a̱te̱ tulur í̱e̱, e' dalewa ye' mía̱ wi̱shke̱ ttök S'yë́ ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Eta̱ ie' wa̱ Pedro ena Zebedeo ala'r böl, e'pa mítse̱r e̱' ta̱. Eta̱ ie' e̱rianemi chkenewa̱mi tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ie' tö iché ie'pa a̱: —Ye' e̱riane tai̱ë ttsëskua ye' ttèwa̱miitö ekkë. A' e̱' tsú̱a̱t í̱e̱ ye' ta̱, kë̀ a' kapökwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ie' mía̱ wi̱shke̱ ta̱ ie' e̱' kéu̱tër wöwakköt i̱ski̱ ta̱ ikiéitö Skëköl a̱ i' es: “A yë́wö, ì tköraë ye' ta̱ e' dör we̱s íyi bacha'bachaë yèwasö es. E' mú ulà a̱ ye' yërmittsa̱, e̱'ma ye' yö́ttsa̱ iulà a̱. Erë kë̀ iwa̱r we̱s ye' ki̱ ikiane es, iú̱ we̱s be' ki̱ ikiane es.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","E' ukuöki̱ ta̱ ie' dene wé̱ ittökatapa tulur ee̱ ta̱ ie'pa kué̱itö kapö̀tulur ta̱ ichéitö Pedro a̱: —¿A' kë̀ wa̱ kapèwa̱ wöklöne dö̀ hora ek ë̀ ye' ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kë̀ a' kapökwa̱. A' ikiö́ Skëköl a̱ a̱s ì sulu tö a' e̱rkiöwe̱ke ese kë̀ e̱' alö̀ka̱ a' ki̱. Moki̱ a' é̱na ì buaë wa̱k, erë a' diché kë̀ dë'ka̱ iwà u̱k, e' kue̱ki̱ a' a̱ darërëë idir. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Eta̱ ie' skà mía̱ne wi̱shke̱ ttökne S'yë́ ta̱ ta̱ ichéitö: “A yë́wö, ì tköraë ye' ta̱ e' mú ulà a̱ ye' yërmittsa̱, e̱'ma ye' yö́ttsa̱ iulà a̱. Erë iú̱ we̱s be' ki̱ ikiane es.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mik ie' dene, eta̱ ie'pa kué̱neitö kapö̀tulur; ie'pa wöbla surirkewa kapè wa̱ e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ie' skà mía̱ne wi̱shke̱ ttök S'yë́ ta̱, i' ta̱ idare mañatökicha. Eta̱ itténe we̱s itté kuaë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","E' ukuöki̱ ta̱ ie' dene wé̱ ie' tö ittökatapa mañal méa̱t ee̱ ta̱ ie' tö iché ie'pa a̱: —¿A' kapö̀tuluria̱ e̱nukeia̱? Ye' dör S'ditsö Alà, e' diwö deka̱tke mèttsa̱ pë' sulusipa ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","A' e̱' kö́ka̱, yi tö ye' wömekettsa̱, e' dotke i' ta̱. Mishka ie' panuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús tso'ia̱ ttök, e' dalewa ittökatapa dabom eyök ki̱ böl (12), e'pa eköl kiè Judas, e' debitu̱ pë' ta̱ tai̱ë. E' wakpa debitu̱ tabè ki̱ ena kal wölö ki̱. Ie'pa patkë'mi sacerdotepa wökirpa ena judiowak kue̱blupa tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas dör iwöméttsa̱ e' tö ie'pa a̱ iyë'bak: “Wé̱ shke̱'we̱keyö wöalattsè wa, e' dör ie', iklö'ú̱wa̱ a' tö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Eta̱ ie' de Jesús ska' ta̱ iché ia̱: —¡A S'wöbla'u̱kwak! Ta̱ iwöalattséwa̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús tö iché ie' a̱: —A yami, ì u̱k be' de, e' ú̱. Eta̱ pë' datse̱ Judas ta̱ e'pa de Jesús ska' ta̱ iklö'wé̱wa̱rakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Eta̱ ie'pa iëte̱r ee̱ Jesús ta̱ e'pa eköl tö itabè yéttsa̱ ta̱ e' wa sacerdote kibi e' kanè méso kukuöña téttsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús tö iché ie' a̱: —Wé̱pa ñippöke tabè wa, esepa döraka̱ tabè kkö̀ a̱. E' kue̱ki̱ be' tabè blö́wa̱ne ikkuölit a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Be' kë̀ wa̱ ijche̱r tö ye' ki̱ ikiane, e̱'ma ye' tö ikièmi ye' Yë́ a̱ ta̱ ie' tö ibiyöchökwakpa tai̱ë döka̱ 70.000 e' patkèmi ye' tsa̱tkök? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Erë ye' tö ikié es, e' ta̱ ¿we̱s Skëköl yëkkuö ki̱ itso' kitule e' wà tkö̀mi? E' tö ichè tö ì suluë tköke ye' ta̱ e' ka̱wöta̱ tkök es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Eta̱ ie' tö ichaké pë' ekkëpa a̱: —¿Ì kue̱ki̱ a' bite̱ ye' klö'u̱kwa̱ tabè ki̱ kal wölö ki̱ we̱s akblökwakpa klö'wè̱wa̱ es? Ke̱kraë ye' bak e̱' tkökse̱r Skëköl wé a̱ s'wöbla'u̱k, erë a' kë̀ wa̱ ye' klöo̱newa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Erë ì tköke i' e' dör a̱s iwà tkö̀ we̱s Skëköl ttekölpa tö ikita̱tbak Skëköl yëkkuö ki̱ es. E' wösha̱ ta̱ ie' ttökatapa ko̱s tkayalmi tö iméa̱t ekörla. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Eta̱ pë' tö Jesús klö'wé̱wa̱ e'pa tö ie' tsé̱mi sacerdote kibi kiè Caifás e' u a̱. Ee̱ s'wöbla'u̱k ttè dalöiëno wa wakpa ena judiowak kue̱blupa ko̱s daparke. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Erë Pedro datse̱ ie'pa itöki̱ ka̱mië döttsa̱ sacerdote kibi e' u pamik, ee̱ ie' e̱' tsé̱a̱t tkër Skëköl wé shkëkipa ta̱ isa̱u̱k tö ì tkö̀mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Eta̱ sacerdotepa wökirpa ena judiowak wökirpa male̱pa tö ttè yuleke Jesús kkatoie a̱s ie'pa tö iwömùttsa̱ ttèwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tai̱ë pë' de ie' kkatök ka̱chè wa, erë kë̀ yi wa̱ ie' kkatëne wë' ie' wömottsa̱ ttèwa̱. Bata ekkë ta̱ idebitu̱ böl ikkatök ka̱chè wa, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","e'pa tö iché: —Wëm se̱ tö iyë' tö ie' a̱ Skëköl wé olorwa̱mi, e' yuèka̱mineitö ká̱ mañat shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sacerdote kibi e̱' kéka̱ ta̱ ichaké Jesús a̱: —¿Kë̀ be' ie'pa iu̱teku̱' yës? ¿Ñe' ie'pa be' kkateke, e' dör ì? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Erë Jesús siwa̱'bléwa̱ ie'pa yöki̱. Eta̱ sacerdote kibi tö ichaké ie' a̱: —Ichö́ sa' a̱ yësyësë Skëköl chö́k e' wörki̱ tö ¿be' dör ie' Alà? ¿Be' dör wé̱ pairine'bitu̱ idi' wa sa' blúie e'? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ie' iiu̱té: —We̱s be' iché es idir. Ye' tö ichè a' a̱ tö ye' dör S'ditsö Alà, e' sue̱raë a' tö tkërka̱ Skëköl diché ta̱' tai̱ë íyi ulitane tsa̱ta̱ e' ulà bua'kka dalöiërta̱' tai̱ë. Ñies ye' datskene ka̱shu̱k a̱ mò a̱ e' sue̱raë a' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Eta̱ sacerdote kibi e̱' datsi' jchée ikkachoie tö iluneka̱ ta̱ ichéitö: —Ì ché ie' tö, e' wa ie' tso' Skëköl chök suluë. ¿Ìie se' ki̱ ikkatökwakpa kí̱ kiarmiia̱? Ttè suluë chéitö, e' ttsétkesö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿I̱ma a' tö ibikeitsè? Ie'pa tö iiu̱té: —Ie' wák ia̱ne iwiie, e' kue̱ki̱ ika̱wöta̱ ttèwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Eta̱ ie'pa wirituöke Jesús wö ki̱ ta̱ itekerakitö tai̱ë. We̱lepa tö ippé iwö ki̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ta̱ ichérakitö: —Be' dör wé̱ pairine'bitu̱ idi' wa s'blúie e', e̱'ma sa' a̱ ichö́ka̱ ¿yi tö be' ppé? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro tkëria̱ sacerdote kibi e' u pamik ta̱ alaköl kaneblöke u e' a̱, ese de eköl ie' ska' ta̱ ichéitö ia̱: —Be' ñies dör Jesús Galilea wak e' klé eköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Erë ie' tö iblé sulitane tso' e'pa kukua. Ie' tö iché: —Ye' kë̀ é̱na ia̱ne tö ì chök be' tso'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ie' mía̱ ukkö tkër kañika̱ ee̱ ta̱ alaköl skà tö isué̱ e' tö iché imale̱pa a̱: —Ie' i' dör Jesús Nazaret wak e' klé eköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Etökichane Pedro tö iskà ché: —¡Ye' iché Skëköl wörki̱ tö ye' kë̀ wa̱ wëm e' su̱ule! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","E' kuölö ta̱ wé̱pa tso' ee̱ e'pa debitu̱ ie' ska' ta̱ ichéitö: —Moki̱ be' dör ie'pa ëltë wak, be' ttö̀ ie'pa ttö̀ ttsëë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Eta̱ ie' iché: —Skëköl wörki̱ yö ichè tö ¡wëm e' kë̀ su̱ule ye' wa̱! Kë̀ idör es, e̱'ma a̱s ye' kichatër. E' wösha̱ë dakro a̱ne, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ta̱ ì yë' Jesús tö ie' a̱ e' a̱newa̱ ie' é̱na, e' dör i': ‘Ka̱m dakro a̱r, e' yöki̱ be' tö icheraë mañatökicha tö be' kë̀ wa̱ ye' su̱ule.’ Eta̱ ie' e̱' yéttsa̱ mía̱ kañika̱ ta̱ ee̱ ie' i̱é̱ tai̱ë sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mik ká̱ ñine, eta̱ sacerdotepa wökirpa ena judiowak kue̱blupa ko̱s ñì dapa'wé̱ka̱ ileritsök tö “¿we̱s sö Jesús ttèwa̱mi?” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ie'pa wa̱ imítse̱r moulewa̱ mé Pilato a̱. Pilato tkë'ka̱ Roma wökir kibi tö Israel aleripa ké̱ wökirie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas tö Jesús wato̱'ttsa̱bak, mik e' wa̱ ijche̱newa̱ tö moki̱ Jesús wömenettsa̱ ttèwa̱, eta̱ e' tö ie' e̱riawé̱ne tai̱ë. E' kue̱ki̱ ie' mía̱ sacerdotepa wökirpa ena judiowak kue̱blupa ska' ta̱ inuköl mène ie' a̱ mañayök (30), e' méneitö ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ie' iché ie'pa a̱: —Ì sulu wambléyö. Wëm kë̀ ki̱ ì sulu nuí̱ ta̱', ese wöméttsa̱yö ttèwa̱. Erë ie'pa tö ie' iu̱té: —¡E' kë̀ ki̱ sa' tkine! ¡E' wërke be' wöki̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Eta̱ ie' inuköl e' u̱yémine Skëköl wé shu̱a̱ ta̱ imía̱ e̱' kuli' skéka̱ ta̱, es ie' e̱' ttéwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Eta̱ sacerdotepa wökirpa tö inuköl e' shtéka̱ ta̱ ichérakitö: —Inuköl i' dör s'kötulewa̱ ské, e' kue̱ki̱ ñá idir. Kë̀ iiënukwa̱ inuköl tso' Skëköl a̱ íyi kanéwo̱ie ese a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","E' kue̱ki̱ ie'pa ttè mé ñì a̱ tö ká̱ tau̱ttsa̱sö iwa yuè pöie pë' datse̱ ká̱ bánet blënewa̱ í̱e̱, esepa nu blóie. Eta̱ ká̱ kiè Ska̱u̱chka Yuökwak Ké̱ e' tué̱ ie'pa tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ie'pa tö ká̱ e' tué̱ s'kötulewa̱ ese ské wa, e' kue̱ki̱ dö̀ ikkë ta̱ ká̱ e' kiè Ká̱ To̱ne S'kötulewa̱ Ské Wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Íyi ekkë ko̱s tka we̱s Skëköl tteköl kiè Jeremías tö iyë'a̱tbak es. Ie' tö iyë': “Israel aleripa tö iské méka̱ inukölchka wöshki döka̱ dabom mañayök (30), ekkë klö'wé̱ ie'pa tö, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ta̱ e' wa ie'pa tö ká̱ kiè Ska̱u̱chka Yuökwak Ké̱ e' tué̱ we̱s Skëköl tö ye' a̱ iyë' es.” Es Jeremías tö iyë'a̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús mítse̱r ie'pa wa̱ Pilato dör ká̱ e' wökir e' ska' ta̱ e' tö ie' a̱ ichaké: —¿Be' dör judiowak blú? Ie' iiu̱té: —Tö́, we̱s be' iché, e̱'ma es idir. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sacerdotepa wökirpa ena judiowak kue̱blupa tö ie' kkateke Pilato a̱, erë Jesús kë̀ wa̱ ie'pa iu̱tëne yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","E' kue̱ki̱ Pilato tö ie' a̱ ichaké: —Ie'pa tö be' kkateke tai̱ë ¿e' kë̀ ttsëne be' wa̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Erë ie' kë̀ wa̱ iiu̱tëne yës, e' tö Pilato tkiwé̱wa̱ darërëë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Judiowak Yë́pa Yërulune Egipto, e' ké̱wö wa Pilato wöblar s'wötëulewa̱ s'wöto wé a̱ ese yöktsa̱ eköl émine wé̱ kiane pë' ki̱ e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","E' ké̱wö ska' ta̱ wëm tso' wötëule eköl kiè Barrabás kkekauleka̱ tai̱ë judiowak shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","E' kue̱ki̱ mik ie'pa e̱' dapa'wé̱ tai̱ë, eta̱ Pilato tö ie'pa a̱ ichaké: —¿S'wötëulewa̱ wé̱ne kiane a' ki̱ tö ye' tö iyèttsa̱ne a' a̱: Barrabás ö Jesús kiekerakitö wé̱ pairine'bitu̱ idi' wa s'blúie e'? ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ie' tö isué̱wa̱ tö ukyëne wa sacerdotepa wökirpa tö Jesús me'ttsa̱ ie' ulà a̱. E' kue̱ki̱ ie' tö ie'pa a̱ ichaké es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ie' tkërka̱ia̱ s'shu̱lo kulé ki̱, eta̱ ilaköl tö ichök patké ie' a̱: “Nañewe ye' tö Jesús kébisué̱, e' tö ye' tsiriwé̱tka tai̱ë, e' kue̱ki̱ be' kë̀ e̱' tiu̱k wëm se̱r yësyësë e' ta̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Erë sacerdotepa wökirpa ena judiowak kue̱blupa tö pë' ulitane daki̱ñé ta̱ ichérakitö: “Ikiö́ Pilato a̱ tö Barrabás ö́mine erë Jesús ttö́wa̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato tö ie'pa a̱ iskà chakéne: —¿Wëpa böl i', wé̱ kiane a' ki̱ tö ye' tö ièmine? Ie'pa iiu̱té: —¡Barrabás ö́mine! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ie' tö ie'pa a̱ ichaké: —Eta̱ ¿we̱s Jesús kiekerakitö wé̱ pairine'bitu̱ idi' wa s'blúie e' wè̱miyö? Ie'pa iiu̱té: —¡Ittö́wa̱ wötëulewa̱ krus mik! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ie' tö ichaké ie'pa a̱: —¿Ì kue̱ki̱? ¿Ì sulu wambléitö? Erë ie'pa kí̱ a̱rke: —¡Iwötö́wa̱ krus mik! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ie' tö isué̱ tö ie' kë̀ a̱ Jesús tsa̱tkënuk we̱s, pë' kí̱ a̱rkeka̱ tai̱ë, e' kue̱ki̱ ie' tö di' tsu̱k patké ta̱ iulà skué ie'pa ulitane wörki̱ iwà kkachoie tö ie' kë̀ iane iwiie. Ie' iché: —Wëm i' patkeraëyö ttèwa̱ erë e' nuí̱ kë̀ ku̱' ye' ki̱. E' nuí̱ a̱rdaë a' ulitane ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Eta̱ ie'pa ulitane iiu̱té: —Sa' ena sa' ala'r ko̱s a̱s e' ki̱ inuí̱ a̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Eta̱ Barrabás émi ie' tö. E' ukuöki̱ ta̱ ie' tö Jesús ppök patké ttsa' bata daloie wa, ta̱ iméttsa̱itö iñippökwakpa ulà a̱ wötèwa̱ krus mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Eta̱ Pilato ñippökwakpa wa̱ Jesús mítse̱r s'wökirpa wé kiè Pretorio e' pamik ta̱ ee̱ ie'pa tö ñippökwakpa male̱pa ko̱s kiéttsa̱ dapa'wè̱ ek tsi̱ní Jesús pamik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ie'pa tö Jesús datsi' yéttsa̱ ta̱ datsi' mat daloshdalosh ese wa ipaiérakitö blu'ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ñies dika'kicha yué wöshkiie, e' tkéka̱rakitö iwökir ki̱ blu'ie. Kuaköl wölö mérakitö ie' a̱ iulà bua'kka we̱s blu' es. E' ukuöki̱ ta̱ ie'pa e̱' tkéwa̱ kuchë ki̱ ie' wörki̱ iwayuoie ta̱ ichérakitö: —¡Be' dör judiowak blú! ¡Be' ki̱kökka̱ sa' tso'! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ñies ie'pa wiritué iki̱ tai̱ë, ta̱ kuaköl wölö a'tse̱r iulà a̱, e' yéttsa̱rakitö, e' wa ippérakitö tai̱ë iwökir ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mik iwayué o̱ne, eta̱ datsi' mat daloshdalosh, e' yéttsa̱rakitö ta̱ iwák datsi' iéka̱nerakitö iki̱ ta̱ imítse̱rak iwa̱ wötèwa̱ krus mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mik ñippökwakpa wa̱ Jesús dami e'pa e̱' yélur ee̱, eta̱ wëm eköl kué̱ ie'pa tö ñala̱ ki̱ kiè Simón, e' dör Cirene wak. Ie' ké ie'pa tö Jesús krus tsu̱kmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mik ie'pa de ká̱ kiè Gólgota ee̱ (Gólgota wà kiane chè s'wökirdiche), ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","eta̱ ie'pa tö vino shu̱tuule kapöli bacha'bachaë wa, ese mé Jesús a̱ yè. Erë mik ie' tö ipattsé, eta̱ ie' kë̀ wa̱ iyanewa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mik ie'pa tö iwöté krus mik o̱ne, e' ukuöki̱ ta̱ ie'pa iné ñì ma'wo̱ie suè̱ tö we̱s ie'pa tö ie' datsi' blatemi ñì a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","E' ukuöki̱ ta̱ ie'pa e̱' tuluése̱r ikkö'nuk a̱s kë̀ yi itsa̱tkö̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kaltak ki̱ itso' kitule tö ichè: “I' dör Jesús dör judiowak blú e'”, e' batséwa̱rakitö ie' wökir tsa̱ka̱. E' kit ie'pa tö iwà kkachoie tö ì nuí̱ ki̱ ie' wötënewa̱ krus mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Eta̱ ñies wëpa böl akblökwakpa wötéwa̱rakitö krus mik, eköl iulà bua'kka, eköl iulà bakli̱'kka. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pë' tköke ee̱ e'pa tö icheke sulu, iwökir wötiu̱kerak iwöa̱, es ichekerakitö: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—¡Be' se̱ tö Skëköl wé tkekettsa̱, ta̱ ká̱ mañatk ë̀ ta̱ be' tö iyuéka̱ne! Moki̱ be' dör Skëköl Alà, e̱'ma be' e̱' tsa̱tkö́, be' e̱' ö́wa krus se̱ mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Es ñies sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa ena judiowak kue̱blupa, e'pa tö ie' wayueke. Ie'pa ñì a̱ ichöke: ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—O̱'kapa tsa̱tkéitö erë ie' wák kë̀ a̱ e̱' tsa̱tkër. Moki̱ ie' dör Israel aleripa blú, e̱'ma a̱s ie' e̱' ö̀wa krus wí̱ mik, e' iarma ta̱ sa' e̱rblö̀mi ie' mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","¿Ie' kë̀ wa̱ sa' a̱ iyëne tö ie' dör Skëköl Alà? ¡Ie' e̱rblöke Skëköl mik e' ki̱ ikiane, e̱'ma a̱s e' tö itsa̱tkö̀! ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Dö̀ ñies akblökwakpa böl wötëulewa̱ krus mik ie' o̱'mik, e'pa tö ie' cheke sulu. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mik diwö de bata a̱, eta̱ ká̱ mía̱ ttsettseë ká̱ wa'ñe, dö̀ tsá̱li̱ diwö de mañat ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","E' wösha̱ ta̱ Jesús a̱neka̱ tai̱ë ta̱ ichè: “Elí, Elí, ¿lemá sabactani?” (e' wà kiane chè: A ye' Këköl, a ye' Këköl, ¿iö́k be' ye' we'ikéttsa̱?) ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mik we̱lepa tso' ee̱, e'pa tö ttè e' ttsé ta̱ ichérakitö: —Wëm wí̱ tso' Skëköl tteköl bak kiè Elías, e' kiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Eta̱ ie'pa eköl tu̱nemi tö suiyök nuwé̱ka̱ vino shköshkö wa, e' tkéka̱ kuaköl bata ki̱ ta̱ itkéwa̱ ie' kkö̀ mik a̱s ikuyö̀itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Erë imale̱pa tö iché ie' a̱: —Imúa̱t bër, ipanusö suè̱ tö Elías datse̱ itsa̱tkök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Eta̱ ie' skà a̱nene tai̱ë ta̱ iwiköl émiitö. Es iduowa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","E' wösha̱ ta̱ Skëköl wé a̱ ie'pa wa̱ datsi' buririë ese shu̱ku̱ar u blatoie e' jchënane ká̱kke̱ döttsa̱ i̱ski̱. Ñies ká̱ wöti̱'neka̱ ta̱ ák blublu tskirolone. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Eta̱ pö kköburolone ta̱ s'batse'rpa blërulune, esepa tai̱ë shke̱neka̱ne ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","e̱' yélur ipö a̱. Ie' du'wa̱ shke̱neka̱ne, e' ukuöki̱ ta̱ ie'pa de Jerusalén dör ká̱ batse'r ee̱, ta̱ tai̱ë pë' tö ie'pa sué̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Roma ñippökwak eköl dör capitán ena imale̱pa tso' ie' ta̱ Jesús kkö'nuk, mik e'pa tö ká̱ wöti̱'ne ena ì ko̱s tka ee̱ e' sué̱, eta̱ ie'pa tkirulune ta̱ iché ñì a̱: —Moki̱ wëm wí̱ dör Skëköl Alà je'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ñies alakölpa manetwa̱ Galilea Jesús ta̱ iki̱muk, e'pa tso'ñak tai̱ë ie' kí̱ sa̱u̱k ka̱mië. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","E'pa eköl dör María Magdala wak, iëköl dör María dör Santiago ena José e'pa mì, iëköl dör Zebedeo ala'r, e'pa mì. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Wëm eköl tso' kiè José Arimatea wak, e' dör inuköl blú, ñies ie' dör Jesús klé eköl. Mik ká̱ tuirketke, ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","eta̱ ie' mía̱ Pilato ska' Jesús nu kiök. Pilato tö imuk ké ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ie' wa̱ imítse̱r patréwa̱ datsi' ukuö bua'bua saruru maneneë ese wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","E' ukuöki̱ ta̱ ie' tö ibléwa̱ ákuk bine pa̱'a̱li̱ iwák nu blóie e' a̱. Ie' tö ák bërie trémi dö̀ pö kkö̀ mik, e' wa iwötéwa̱. E' ukuöki̱ ta̱ imía̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Erë María Magdala wak ena María skà, e'pa a̱te̱ tulur pö kkö̀ wösha̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","E' bule es e' dör e̱no diwö, eta̱ sacerdotepa wökirpa ena fariseowakpa míyal ñita̱ ttök Pilato ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ie'pa iché ia̱: —A këkëpa, sa' é̱na ia̱newa̱ tö mik ka̱chökwak e' bak ttsë'ka, eta̱ ie' tö iyë' tö ie' duowa̱ e' ki̱ ká̱ de mañat eta̱ ishke̱rdaka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","E' kue̱ki̱ sa' tö be' a̱ ikié tö pö kkö'nuk patkö́ döka̱ ká̱ mañat dö' ittökatapa dö̀ inú ekiblökwa̱ ta̱ i' ukuöki̱ ta̱ ichènerakitö sulitane a̱ tö ishke̱neka̱ne. E' wé̱rakitö es, e' ta̱ e' dör ka̱chè tai̱ë shu̱te̱ tkö̀ka̱ ika̱che ke̱we e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato tö iché ie'pa a̱: —Se̱ a' wa̱ ñippökwakpa tso', a' yú ikkö'nuk bua'iewa̱ ko̱s a' a̱ ikkö'narmi ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Eta̱ ie'pa mía̱ pö a̱ ta̱ íyi batséwa̱rakitö pö kkö̀ mik a̱s kë̀ yi mi'wa̱ia̱ ee̱. Ie'pa tö ñippökwakpa méa̱t pö kkö'nuk, eta̱ iwákpa míyal. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","E̱no diwö tka, e' bule es e' dör domingo e' ñirketke ta̱ María Magdala wak ena María skà, e'pa míyal Jesús pö sa̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","E' wösha̱ ta̱ Skëköl biyöchökwak eköl tso' ká̱ jaì a̱ e' de, eta̱ í̱ tka darërëë. Ie' mía̱ pö a̱ ta̱ ák bastkër e' tréu̱itö bánet ta̱ ie' e̱' tkése̱r iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ie' wöñarke dalölöë we̱s alá wöñar es, idatsi' damiwa̱ saruruë we̱s suiyök es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mik ñippökwakpa tö e' sué̱, eta̱ ie'pa tkirulune painéka̱rak siwa̱' a̱rulune suane ë̀ wa̱, a̱te̱ we̱s s'duowa̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Eta̱ Skëköl biyöchökwak tö iché alakölpa a̱: —Kë̀ a' suanuk. Ye' wa̱ ijche̱r tö a' tso' Jesús köte̱wa̱ krus mik, e' nu yulök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","7","Erë ye' de a' a̱ ichök tö kë̀ iku̱' í̱e̱, ishke̱neka̱ne we̱s ie' tö iyë'a̱tbak es. A' shkö́ wé̱ ie'pa tö inú me'wa̱ e' tö̀ weblök. E' ukuöki̱ ta̱ a' yú bet ibiyö́ chök ittökatapa a̱: ‘Ie' shke̱neka̱ne, e' mir a' yöki̱ ke̱we Galilea, ee̱ a' tö isue̱raë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Eta̱ alakölpa míyal shka̱la̱la̱ë. Ie'pa suane erë ñies ie'pa ttsë'ne buaë. Ie'pa tu̱nemirak ibiyö́ muk Jesús ttökatapa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","E' wösha̱ ta̱ Jesús de dur ie'pa wörki̱ ta̱ ie'pa shke̱'wé̱itö. Ie'pa dewa̱ ie' ska' ta̱ ie'pa e̱' tuléwa̱ kuchë ki̱ ta̱ iklö paklö'wé̱wa̱rakitö ta̱ idalöiérakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ie' tö iché ie'pa a̱: —Kë̀ a' suanuk. A' yú ichök ye' ttökatapa a̱ tö a' yú Galilea ta̱ ee̱ a' tö ye' sue̱raë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Alakölpa míyal, e' dalewa ñippökwakpa tso' pö kkö'nuk e'pa we̱lepa míyal Jerusalén ta̱ ì ko̱s tka e' pakérakitö se̱raa̱ sacerdotepa wökirpa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sacerdotepa wökirpa míyal ttök judiowak kue̱blupa ta̱. Ie'pa ttè mé ñì a̱: “Sú̱ sö ñippökwakpa patuè̱ inuköl tai̱ë wa a̱s ie'pa ichö̀ we̱s se' ki̱ ikiane es.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ie'pa tö iché ñippökwakpa a̱: —A' ichö́ tö nañewe a' kapolur e' dalewa Jesús ttökatapa debitu̱ e' wa̱ inú mítse̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","A' wökir kibi wa̱ ijche̱newa̱, e' ta̱ sa' ttöraë ie' ta̱ a' tsa̱tkoie. Es kë̀ ì tkö̀pa a' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Eta̱ iñippökwakpa tö inuköl e' klö'wé̱ ta̱ ichérakitö we̱s ie'pa ké ichök es. Dö̀ i̱'ñe ta̱ ka̱chè e' pakekeia̱ judiowak tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Eta̱ Jesús ttökatapa dabom eyök kí̱ eköl (11), e'pa míyal Galilea ka̱bata a̱ wé̱ ie' tö ie'pa a̱ iyë' ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mik ie'pa tö isué̱, eta̱ ie'pa tö idalöié, erë ie'pa we̱lepa tö ibikeitséka̱ bötböt. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ie' de ie'pa ska' ta̱ ichéitö: —Skëköl tö ye' tkë'ka̱ íyi ulitane wökirie ká̱ jaì a̱ ena ká̱ i' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","E' kue̱ki̱ a' yú ká̱ ulitane a̱ s'yuök ye' ttökatapaie. Ie'pa wöskuö́ S'yë́ ena ye' dör ilà ena Wiköl Batse'r e' ttö̀ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ñies ttè ko̱s wà dalöiök a' ka' ye' tö, e' wa ie'pa wöbla'ú̱ a̱s ñies ie'pa tö iwà dalöiö̀. Ye' se̱r michoë a' ta̱ ke̱kraë. Erë́ ká̱ i' e̱newatke, erë ye' kë̀ tö a' mepaa̱t a' wakpa ë̀.");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristo dör Skëköl Alà, e' tté buaë dör i' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ká̱ ia̱ia̱ë Skëköl tteköl kiè Isaías e' tö ikita̱t yëkkuö ki̱, e' ichè i' es: Skëköl tö ichè: “Ye' tso'tke ye' ttè pakökwak patkök be' yöki̱ ke̱we, be' ñalé̱ yuök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ká̱ sir poë wé̱ kë̀ yi se̱rku̱' ee̱ ie' ttöraë a̱neule: ‘A' e̱r mane'ú̱ Skëköl datse̱ e' yöki̱, e' dör we̱s ñala̱ yuèsö yësyësë ie' yöki̱ es.’ ” Es Isaías tö iyë'a̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Es Juan S'wöskuökwak tso' ká̱ sir poë wé̱ kë̀ yi se̱rku̱' ee̱, e' tö s'pattémi i' es: “A' e̱r mane'ú̱ Skëköl a̱ a̱s a' nuì̱ olo'yö̀itö a' ki̱ ta̱ a' e̱' wöskuö́lor iwà kkachoie.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jerusalén wakpa ena ká̱ male̱pa tso' Judea e' wakpa ko̱s döke ie' ttöke e' ttsök. Ie'pa e̱' wamblö̀ sulu ko̱s e' chekeka̱rakitö ta̱ Juan tö iwöskuekelor di' kiè Jordán e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan datsi' yöule kameio köyök wa; ikipamo yöule iyiwak kkuölit wa. Ie' chkè dör ditski ena bulali. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ttè pakeke ie' tö ie'pa a̱ i' es: “Ye' itöki̱ idatse̱ eköl, e' dör këkëpa tai̱ë ye' tsa̱ta̱, e' kue̱ki̱ ie' klökkuö kicha ë̀ kë̀ wötsënanuk ye' sia̱rla e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ye' tö a' wöskueke di' a̱, erë ie' tö a' ierawa̱ Wiköl Batse'r a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","E' ké̱wö ska' ta̱ Jesús e̱' yéttsa̱ Nazaret a̱te̱ Galilea ee̱, e' de Jordán ta̱ ee̱ Juan tö ie' wöskué. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mik ie' wösune e' e̱' duéka̱ne di' a̱, e' wösha̱ ta̱ ie' isué̱ tö ká̱ jaì kköbunane ta̱ Skëköl Wiköl bite̱ ie' ki̱ nuböl sù̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Eta̱ ttö̀ ttsëne datse̱ ká̱ jaì a̱, e' tö ichè: “Be' dör ye' alà dalër tai̱ë ye' é̱na, e' wër ye' wa buaë shu̱te̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","E' ukuöki̱ ta̱ Skëköl Wiköl tö Jesús ké shkökmi ká̱ sir poë wé̱ kë̀ yi se̱rku̱' ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ee̱ iyiwak sulusi tso' tai̱ë. Ee̱ ie' se̱né ká̱ dabom tkëyök (40), e' dalewa Satanás tö ie' e̱rkiöwé̱ ì sulu wamblök. Skëköl biyöchökwakpa tö ie' ki̱mé. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan klö'wé̱wa̱rakitö wötéwa̱ s'wöto wé a̱, e' ukuöki̱ ta̱ Jesús mía̱ Galilea Skëköl ttè buaë e' pakök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ie' s'patteke i' es: “Ì blúie Skëköl tso' e' ké̱wö dewa̱tke tsi̱net. E' kue̱ki̱ a' e̱r mane'ú̱ ie' a̱ ta̱ ie' ttè buaë e' klö'ú̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mik Jesús shkörami batsöri kiè Galilea e' kkömik, eta̱ wëpa böl sué̱itö. E'pa dör Simón ena iël Andrés. Ie'pa dör nima klö'u̱kwakpa. Ie'pa tso' ikla' u̱yök batsöri a̱ nima klö'wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús tö ie'pa a̱ iché: —A' shkö́ ye' ta̱. A' yueraëyö s'ditsö klö'u̱k ye' a̱ ye' ttökataie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","E' bet ta̱ ie'pa tö ikla' tuléa̱t ta̱ míyal ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","E' wi̱'kie Jesús tö Santiago ena iël kiè Juan e'pa sué̱. Ie'pa dör Zebedeo ala'r. Ie'pa tulur kanò a̱ ikla' wöyuök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","E' wösha̱ ta̱ Jesús tö ikiémirak e̱' ta̱. Eta̱ ie'pa tö iyë́ méa̱t ikanè mésopa ta̱ kanò shu̱a̱ ta̱ imíyal Jesús ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ie'pa demi ká̱ kiè Cafarnaúm ee̱. E̱no diwö a̱ Jesús tkawa̱ judiowak ñì dapa'wo̱ wé a̱ ta̱ ie' tö s'wöbla'wé̱mitke. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ie' tö s'wöbla'we̱ke ttè moki̱ diché ta̱' tai̱ë ese wa. E' kë̀ dör we̱s s'wöbla'u̱k ttè dalöiëno wa wakpa tö s'wöbla'we̱ke es. E' kue̱ki̱ e' tö wé̱pa tso' ittsök e'pa tkiwé̱wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Eta̱ ee̱ wëm eköl tso' e' a̱ wimblu sulusi tso' e' tö iché a̱neule: ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—A Jesús Nazaret wak, ¿ìie be' tso' sa' tsiriu̱k? ¿Be' debitu̱ sa' e̱u̱kwa? Ye' wa̱ be' su̱ule. Ye' wa̱ ijche̱r tö be' dör yi dör batse'r patkë'bitu̱ Skëköl tö e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús tö wimblu e' uñé: —¡Be' siwa̱'blö́wa̱, be' e̱' yö́ttsa̱ wëm se̱ a̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Wimblu sulusi tö wëm siwa̱' éwa ta̱ ia̱neka̱ tai̱ë ta̱ ie̱' yéttsa̱ ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sulitane tkinewa̱ iweblök ta̱ iñi chakérak: —¿Wí̱ dör ì? ¡Ie' s'wöbla'we̱ke ttè pa̱'a̱li̱ wa ena diché wa dö̀ wimblupa sulusi kéitö e̱' yöktsa̱ ta̱ ittö̀ iu̱térakitö ekkë! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","E' bet ta̱ ie' tté buneka̱ Galilea ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mik ie'pa e̱' yélur ñì dapa'wo̱ wé a̱ ta̱ Jesús mía̱ Simón ena Andrés e'pa u a̱. Santiago ena Juan mí ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ee̱ Simón yàk me'r ka̱' ki̱ kiri'we̱ke duè dalölö tö, e' ché ie'pa tö Jesús a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Eta̱ ie' e̱' skéwa̱ ta̱ iklö'wé̱itö iulà a̱ ta̱ iki̱mé e̱' tkökse̱r. E' bet ta̱ duè dalölö ie' éwa ta̱ ie' e̱' kéka̱ ilè yulök ie'pa a̱ ñè. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ká̱ tuine diwö míwa̱tke ta̱ s'kirirke ena wé̱pa a̱ aknama tso' esepa ko̱s debitu̱rak iwa̱ Jesús ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ká̱ e' wakpa ko̱s e̱' dapa'wé̱ka̱ ukkö a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Eta̱ ie' tö duè ulitane bua'wé̱ne pë' tso' tai̱ë e'pa a̱. Ñies aknamapa tai̱ë trë'wé̱yalitö. Erë aknamapa wa̱ ijche̱r yi dör ie', e' kue̱ki̱ ie' kë̀ wa̱ ka̱wö mène ie'pa a̱ ttök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ká̱ ñirketke ià̱ ttsettseë, ta̱ Jesús e̱' kéka̱ mía̱ bánet wé̱ kë̀ yi ku̱' ese ska' ttök S'yë́ ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Eta̱ Simón ena iwapiepa míyal ie' yulök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mik ikué̱wa̱rakitö, eta̱ ie'pa ie' a̱ iché: —Sulitane tso' be' yulök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Erë ie' tö ie'pa iu̱té: —Mishka ká̱ tso' tsi̱net tsi̱net ese a̱. Ñies ee̱ ye' ké Skëköl ttè pakök, eseie ye' dë'bitu̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Es Jesús shké ká̱ tso' Galilea e' ko̱s a̱ ttè pakök judiowak ñì dapa'wo̱ wé ko̱s a̱, ñies aknama trë'u̱kyal. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wëm eköl kiri'we̱ke lepra tö, e' e̱' skéwa̱ Jesús o̱'mik ta̱ ie' e̱' tkéwa̱ kuchë ki̱ ta̱ iché ia̱: —Be' ki̱ ikiane, e' ta̱ be' a̱ ye' buarmine a̱s ye' batse'rne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús tö ie' sué̱ e̱r sia̱rë wa ta̱ ikéwa̱itö ulà wa ta̱ ichè: —Tö́, ye' ki̱ ikiane. Be' dene batse'r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","E' wösha̱ ta̱ wëm buanene batse'nene. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","E' ukuöki̱ Jesús tö ie' a̱ iché: —Ye' ttö̀ ttsö́, ì tka be' ta̱ e' kë̀ char yi a̱. Be' yú e̱' kkachök sacerdote a̱. Ì muk Moisés tö a' ka' e̱' batse'wo̱ie e' tsú̱mi mè Skëköl a̱ iwà kkachoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Erë wëm mía̱ ta̱ ie' e̱' kéka̱ ì tka ita̱ e' pakök sulitane a̱. E' kue̱ki̱ Jesús kë̀ a̱ e̱' kkayënuk wé̱ pë' tso' tai̱ë ese ska'. Ie' ka̱wöta̱ e̱' tsu̱ka̱t kañika̱ wé̱ kë̀ pë' ku̱' ese ska', erë ká̱ wa'ñe wakpa datse̱ ie' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ká̱ we̱kkë alè kuöki̱ ta̱ Jesús dene Cafarnaúm. Mik pë' wa̱ ijche̱newa̱ tö ie' tkër u a̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","eta̱ tai̱ë ie'pa e̱' dapa'wé̱ ie' ska' kë̀ chë'ka̱ia̱ we̱shke̱, kë̀ chë'ka̱ia̱ ukkö a̱ ekkë. Ie' tso' Skëköl ttè pakök ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","E' dalewa wëpa döka̱ tkël wa̱ wëm kraulewa̱ kë̀ karka̱ debitu̱ eköl ka̱'la ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Erë tai̱ë s'tso', e' kue̱ki̱ kë̀ we̱s ie'pa tkö̀mi we̱shke̱ Jesús ska'. E' kue̱ki̱ ie' tsa̱ka̱ u tsa̱bata jchée ie'pa tö ta̱ iduè émirakitö e̱naë e' a̱ döttsa̱ i̱ski̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mik Jesús tö isué̱ tö moki̱ ie'pa e̱rblé ie' mik, eta̱ ie' iché ikirirke e' a̱: —A alà, ì sulu ko̱s wamblébö, e' nuí̱ olone be' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Erë s'wöbla'u̱k ttè dalöiëno wa wakpa we̱lepa tulur ee̱, e'pa ibikeitsè: ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ì kue̱ki̱ wëm wí̱ ttö̀ es? Skëköl ë̀ a̱ se' nuì̱ olo'yarmi. Ì ché ie' tö e' wa ie' tso' Skëköl chök suluë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Erë ì bikeitsök ie'pa tso' e' sué̱wa̱ Jesús tö bet. E' kue̱ki̱ ie' tö ie'pa a̱ ichaké: —¿Ì kue̱ki̱ a' tö ibikeitseke es? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ye' tö s'kraulewa̱ diö́ bua'wè̱mine a̱s ishköne, e' ta̱ ¿we̱s a' tö iklö'wè̱mi tö ye' kë̀ a̱ inuì̱ olonuk iki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ye' dör S'ditsö Alà, sú̱ e' tö a' a̱ ikkachè tö ye' wa̱ ka̱wö ta̱' ká̱ i' a̱ nuì̱ olo'yoie. Eta̱ ie' tö iché wëm kraulewa̱ e' a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Be' e̱' kö́ka̱, be' ka̱'la kö́ka̱ ta̱ be' yúne u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Bet ta̱ ie' e̱' kéka̱, ika̱'la kéka̱, ta̱ imía̱ sulitane wörki̱. E' tö ie'pa ko̱s tkiwé̱wa̱ ta̱ ie'pa tö Skëköl ki̱kéka̱ tai̱ë ta̱ ichérakitö: —Kë̀ se' wa̱ íyi wí̱se su̱ule yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","E' ukuöki̱ ta̱ Jesús mía̱ne batsöri kkömik ta̱ pë' e̱' dapa'wé̱ka̱ ie' ska' ta̱ ie' tö ie'pa wöbla'we̱ke. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ie' domitkö ta̱ ie' tö inuköl shtökwak Roma wökirpa a̱ e' sué̱ eköl tkër ikaneblöke e' wé a̱. E' dör Leví dör Alfeo aladulaköl. Ie' tö iché ia̱: —Be' shkö́ ye' ta̱ ye' ttökataie. Eta̱ ie' e̱' kéka̱ ta̱ imía̱ Jesús ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","E' ukuöki̱ Jesús tso' chkök Leví u a̱. Pë' shköke tsa̱ki̱ë Jesús ta̱, e' kue̱ki̱ inuköl shtökwakpa ena pë' sulusipa skà tulurñak chkök ie' ena ittökatapa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","S'wöbla'u̱k ttè dalöiëno wa wakpa we̱lepa dör fariseowakpa. Mik e'pa we̱le tö Jesús sué̱ tö ichköke pë' esepa ta̱, eta̱ ie'pa tö ichaké ittökatapa a̱: —¿Iö́k a' wöbla'u̱kwak chköke inuköl shtökwakpa ta̱ ena pë' sulusipa skà ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús tö ittsé ta̱ ichéitö ia̱rak: —Wé̱pa kë̀ kirirku̱' esepa kë̀ ki̱ s'kapeyökwak kiane, erë wé̱pa kirirke esepa ki̱ ikiane. Ye' kë̀ dë'bitu̱ wé̱pa e̱' ttsö̀ tö ie'pa se̱rke yësyësë esepa kiök. Ye' dë'bitu̱ pë' sulusipa kiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Etökicha ta̱ Juan S'wöskuökwak ttökatapa ena fariseowakpa tso' batsök, eta̱ pë' we̱lepa de Jesús ska' ta̱ ichakérakitö ie' a̱: —Juan S'wöskuökwak ttökatapa ena fariseowakpa klépa batsöke. ¿Ì kue̱ki̱ be' ttökatapa kë̀ batsö̀? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús tö ie'pa iu̱té: —Mik s'kiule ulabatsè ké̱wö tkö'u̱k, eta̱ ¿we̱s ie'pa batsö̀mi wëm ulabatske e' tso'ia̱ ie'pa ta̱ e' dalewa? Ie' tso'ia̱ ie'pa ta̱, e' dalewa ie'pa kë̀ batsöpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Erë iké̱wö döraë eta̱ ie' mi'datse̱r ie'pa yöki̱. E' je' ta̱ ie'pa batsöraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Kë̀ yi tö datsi' këchke wöyuepawa̱ datsi'tak pa̱'a̱li̱ wa, datsi'tak pa̱'a̱li̱ wöklöneka̱, e' tö datsi' këchkela shu̱kuè̱e̱ ta̱ ikí̱ jchèe tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ñies kë̀ yi tö vino pa̱'a̱li̱ tepaka̱ iyiwak kkuölit yöule ibloie ese këchke a̱. Itéka̱sö es, e' ta̱ mik ibacha'nebitu̱, eta̱ ikkuölit jchèemiitö. Es vino ena ikkuölit weirwami ë́me. E' kue̱ki̱ vino pa̱'a̱li̱ tekeka̱ ikkuölit pa̱'a̱li̱ a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Etökicha ta̱ e̱no diwö a̱, Jesús dami trigo shu̱a̱ ta̱ ittökatapa tö trigowö butsémi ishkörami e' dalewa katè. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseowakpa tö ie' a̱ ichaké: —Sa' ttö̀ ttsö́, ¿ì kue̱ki̱ be' ttökatapa tso' ì kë̀ ké̱wö ta̱' wè̱ e̱no diwö a̱ ese u̱k? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Erë ie' iu̱té: —Etökicha ká̱ ia̱ia̱ë mik David ena iklépa du' bli wa̱ ta̱ kë̀ ie'pa wa̱ ì dami ñè, eta̱ ì o̱' ie' tö ¿e' kë̀ a̱ritsule a' wa̱ Skëköl yëkkuö ki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mik Abiatar dör sacerdote kibi, e' ké̱wö ska' ta̱ David dewa̱ Skëköl wé a̱ ta̱ pan meule Skëköl a̱ e' ñéitö ta̱ ñies iméitö iklépa a̱ ñè. Sacerdotepa ë̀ a̱ pan ese ké̱wö ta̱' ñè. Erë a' é̱na ia̱ne tö ì o̱' David tö e' kë̀ dör suluë Skëköl wöa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ie' tö ikí̱ ché: —E̱no diwö menea̱t s'ditsö ki̱moie, erë s'ditsö kë̀ yöne e̱no diwö ë̀ batseitsök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","E' kue̱ki̱ ye' dör S'ditsö Alà, e' wa̱ ka̱wö ta̱' ichoie tö ì dör buaë ö ì dör suluë wè̱ e̱no diwö a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús skà dewa̱ne judiowak ñì dapa'wo̱ wé a̱, ta̱ ee̱ wëm tkër eköl ulà etk siulewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ie'pa é̱na ie' kkatak ilè ki̱, e' kue̱ki̱ ie'pa tso' ie' weblök tö wëm ñe' bua'wè̱mine ie' tö e̱no diwö a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ie' tö iché wëm ulà siulewa̱ e' a̱: —Be' e̱' kö́ka̱ ta̱ be' e̱' duö́se̱r í̱e̱ sulitane wösha̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ie' tö ie'pa a̱ iché: —¿Ì ké̱wö ta̱' se' a̱ wè̱ e̱no diwö a̱: ì buaë ö ì suluë? ¿S'tsa̱tkök ö s'ttökwa̱? Erë ie'pa siwa̱'bléwa̱ ie' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ie' tö ie'pa weblé kësik wa. Ie'pa e̱r darërëë e' tö ie' e̱riawé̱. Ie' iché wëm a̱: —Be' ulà shu̱lö́ö. Ta̱ ie' ulà shu̱lée ta̱ ibuanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Eta̱ fariseowakpa ponemi, e' bet ta̱ ie'pa ñì dapa'wé̱ka̱ Herodes klépa ta̱ ileritsök Jesús ttowa̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Eta̱ Jesús mía̱ ittökatapa ta̱ batsöri kkömik ta̱ tai̱ë Galilea wakpa míyal ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ñies pë' tso' tai̱ë ee̱ datse̱ Jerusalén ena Judea ká̱ male̱pa a̱. Ñies ie'pa datse̱ Idumea ena Jordán wi̱she̱t ena ká̱ wé̱ Tiro ena Sidón a̱te̱ ee̱. Ie'pa tö ì ko̱s we̱ke Jesús tö e' tté ttsë' e' kue̱ki̱ ie'pa de iweblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","S'kirirke tai̱ë bua'wé̱tke Jesús tö, e' kue̱ki̱ imale̱pa tai̱ë e̱' u̱yökeka̱ ie' ki̱ ikökwa̱. E' kue̱ki̱ ie' tö iché ittökatapa a̱ tö kanò tsú̱bitu̱ tërtke dö' ie'pa tö ye' tuèwa̱ darërë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mik wé̱pa a̱ wimblupa sulusi tso' esepa tö ie' sué̱, eta̱ ie'pa e̱' tulélur kuchë ki̱ ie' wöa̱ ta̱ ia̱rkerak: —¡Be' dör Skëköl Alà! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Erë ie' tö ie'pa a̱ iché kësik wa: —¡Kë̀ ye' tté pparka̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","E' ukuöki̱ ta̱ Jesús mía̱ ka̱bata a̱. Eta̱ wëpa kiane ie' ki̱ kiè, e'pa kiéitö ta̱ ibite̱rak ie' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ie' tö ie'pa shu̱shté dabom eyök kí̱ böl shkök ie' ta̱ ena patkèmi ie' ttè pakök. E'pa kiè méka̱itö ittekölpa tsá̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ie'pa a̱ diché méitö aknama trë'u̱kyal. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ie'pa kiè i' es: Simón, e' kiè méka̱itö Pedro; ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago ena iël Juan, e'pa dör Zebedeo aladulakölpa, e'pa kiè skà méka̱itö Boanerges (kiè e' wà kiane chè “wëpa dör we̱s alá es”); ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás ena Santiago dör Alfeo alà; ena Tadeo, Simón Celote, ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ena Judas Iscariote tö Jesús wömekettsa̱ aishkuö ta̱ ibolökpa a̱ e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","E' ukuöki̱ ta̱ Jesús dewa̱ u a̱ ittökatapa ta̱. Eta̱ tai̱ë pë' ñì dapa'wé̱ka̱ne kë̀ wa ie'pa chko ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mik Jesús yamipa e̱kka wa̱ ijche̱newa̱ tö we̱s ie' tso', eta̱ ie'pa de itsu̱kmi iyërke tö ie' a̱li̱neka̱ e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ñies s'wöbla'u̱k ttè dalöiëno wa wakpa datse̱ Jerusalén e'pa tö Jesús ché i' es: “Beelzebú dör bë́ e' tö wëm wí̱ é̱na ká̱ chöwé̱wa, e' diché wa ie' tö aknama trë'we̱keyal.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Eta̱ Jesús ikiéttsa̱rak ta̱ ikleéitö ia̱rak i' es: “¿We̱s Satanás e̱' trë'ù̱shkarmi? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","S'se̱rke ká̱ etkë̀ ki̱ e' ñì blabatsélor ñippök ñita̱, kë̀ wöklör, e' ta̱ ie'pa wákpa mir wa'k ë̀me. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ñies ñì yamipa e̱' kéka̱ ñippök ñita̱, kë̀ wöklör, e' ta̱ ie'pa mir wa'k ë̀me. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Es ñies Satanás klépa mú ñì blabatsélor ñippök ñita̱, e' ta̱ idiché wöarwami ta̱ ie̱rdawarak. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kë̀ yi mi'pawa̱ wëm diché tai̱ë ese u a̱ ie' íyi ekiblök ka̱m ie' tö iwák maù̱wa̱ e' yöki̱. Es ë̀me iíyi ekiblërmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Moki̱ ye' tö a' a̱ ichè tö ì sulu ko̱s wambleke a' tö, ñies Skëköl cheke a' tö sulu ko̱s e' nuí̱ olo'yèmiitö a' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Erë yi isie tö Wiköl Batse'r ché suluë, ese kë̀ ki̱ inuí̱ olorpa, itso' iki̱ ke̱kraë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ie'pa iyë' tö wimblu sulusi tö ie' é̱na ká̱ chöwé̱wa e' kue̱ki̱ Jesús tö e' ché ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","E' ukuöki̱ ta̱ Jesús mì ena iëlpa ena ikutapa e'pa debitu̱ ie' yulök, erë ie'pa kë̀ dë'wa̱ we̱shke̱. Ie'pa tö ikiök patké. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pë' tulur ie' pamik e'pa tö iché ia̱: —Be' mì ena be' ëlpa ena be' kutapa e'pa shkö̀ be' weblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ie' iiu̱té: —¿Yi dör ye' mì ena ye' ëlpa ena ye' kutapa? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Wé̱pa tulur ie' pamik e' sué̱itö ë̀k ta̱ ichéitö: —Yi isie tö ì kiane Skëköl ki̱ ese wé̱, ese dör we̱s ye' ël ena ye' kutà ena ye' mì es. E' kue̱ki̱ ie'pa ikkëpa dör we̱s ye' mì ena ye' ëlpa ena ye' kutapa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Etökicha ta̱ Jesús s'wöbla'wé̱mitke batsöri kkömik. Pë' dapane tai̱ë ipamik, e' kue̱ki̱ ie' e̱' iéka̱ kanò tkërki̱ tsi̱net ese etö a̱. Ee̱ ie' e̱' tkése̱r ie'pa wöbla'u̱k. Ie'pa ko̱s a̱te̱ batsöri kkömik ie' ttö̀ ttsök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ee̱ ie' tö ttè tsa̱ki̱ë kleé ie'pa a̱ iwöbla'wo̱ie, e' et dör i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“A' tö ittsö́. Etökicha ta̱ wëm eköl mía̱ të kuatkök ppé ululu ë̀me ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mik ie' tso' iwö ppök, eta̱ ditsöwö we̱le a̱newa ñala̱ ska' ta̱ dù debitu̱ tö ikatéwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ditsöwö we̱le a̱newa áklo a̱ wé̱ íyök kë̀ ta̱' tai̱ë ese ska'. Íyök kë̀ ta̱' tai̱ë, e' kue̱ki̱ bet ta̱ itskine. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Erë kë̀ iwí kicha ta̱' tai̱ë, e' kue̱ki̱ mik dìba a̱neka̱ iki̱, eta̱ isinewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ditsöwö we̱le a̱newa dika'chka shu̱a̱. Dika'chka ena ditsöwö talane ñita̱, erë dika'chka e̱' aléka̱ iki̱, kë̀ wöne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Erë ditsöwö we̱le a̱ne íyök bua'bua ki̱ ese tskine talane wöne buaë. We̱le wöne döka̱ dabom mañayök (30) elka elka, we̱le dabom teryök (60), we̱le cien eyök (100).” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Eta̱ ie' tö ie'pa a̱ iché: “¡A' é̱na ye' ttö̀ ttsak, e̱'ma ikukueblö́ bua'ie!” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mik Jesús a̱te̱ dur ekörla, eta̱ ittökatapa dabom eyök ki̱ böl ena iklépa we̱lepa skà de ie' ska' ta̱ ichakérakitö ia̱: —Ttè wà kleébö, ¿i̱ma e' wà dör? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ie' ie'pa iu̱té: —“Ì blúie Skëköl tso' e' tté blëulewa̱, e' ké̱wö menea̱t a' a̱ iwà jche̱noie. Erë pë' tso' tai̱ë kë̀ é̱na ye' ttè klö'wa̱k, esepa a̱ ye' ikleeke ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","a̱s ie'pa tö iweblö̀ je', erë kë̀ ie'pa a̱ iwà wër, ñies a̱s ie'pa tö ittsö̀ je', erë kë̀ ie'pa a̱ iwà a̱r a̱s kë̀ ie'pa e̱r mane'ù̱ ta̱ inuì̱ kë̀ olor ie'pa ki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Eta̱ ie' tö ie'pa a̱ iché: “Ttè kleéyö ñe' wà kë̀ a̱ne a' é̱na, e' ta̱ ¿we̱s a' é̱na imale̱pa wà a̱rmi? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wé̱ tö ditsöwö kuatké, e' dör wé̱ tö Skëköl ttè pakeke ese. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pë' we̱lepa tso' e'pa ta̱ itkö̀mi we̱s ditsöwö a̱rwa ñala̱ ki̱ es. Esepa tö Skëköl ttè ttsé erë bet Satanás de iska' ta̱ Skëköl ttè yéttsa̱ ie̱r a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","We̱lepa skà ta̱ itkö̀mi we̱s ditsöwö a̱rwa áklo a̱ es. Esepa tö Skëköl ttè ttsé ta̱ iklö'wé̱rakitö ttsë'ne buaë wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Erë ie'pa kë̀ wì kicha ta̱' tai̱ë, e' kue̱ki̱ ie'pa tö iklö'wé̱ ekuölö ë̀. Mik ie'pa weinemitke Skëköl ttè kue̱ki̱, eta̱ ie'pa a̱nemine bet. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","We̱lepa skà ta̱ itkö̀mi we̱s ditsöwö a̱rwa dika'chka shu̱a̱ es. Esepa tö Skëköl ttè ttsé, ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","erë ie'pa tö íyi tso' ká̱ i' ki̱ ese bikeitseke kibiie. Ie'pa e̱r me'rie inuköl ki̱ ena ì skà tso' ká̱ iki̱ tö s'ttsë'we̱ke buaë ese ki̱. Ese ko̱s tö Skëköl ttè kui'wé̱wa̱ ie'pa e̱r a̱ ta̱ kë̀ idë'ttsa̱ buaë we̱s ikiane es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Erë we̱lepa skà ta̱ itkö̀mi we̱s ditsöwö a̱rwa íyök bua'bua ki̱ es. Esepa tö Skëköl ttè ttsé ta̱ iklö'wé̱ ta̱ iwà dettsa̱ buaë we̱s ikiane es. Ie'pa dör we̱s íyi kuá wör buaë es. We̱le wöne döka̱ cien eyök (100), we̱le dabom teryök (60), we̱le dabom mañayök (30).” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Eta̱ ie' tö iché ia̱rak: “Kë̀ yi tö bö'wö tskepaka̱ ta̱ ibléwa̱itö kalkuö diki̱a̱ ö ka̱' diki̱a̱. E' skéie itkekeka̱itö ká̱kke̱ ká̱ ñi'wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Es ñies kë̀ ì ku̱' blëulewa̱ kë̀ jche̱nukwa̱ aishkuö ta̱. Ese ko̱s kkayërdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Yi é̱na ye' ttö̀ ttsak, e̱'ma ikukueblö́ bua'ie!” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Ñies ichéitö: “Yi e̱' yuak buaë ye' ttè wa, ese a̱ ikí̱ meraëyö a̱s ié̱na iwà a̱r buaë. Erë yi kë̀ e̱' yuak ye' ttè wa, ese yöki̱ ì bikeitséitö tö a̱ne ie' é̱na, ese ko̱s yërdattsa̱ne. E' kue̱ki̱ ì cheke ye' tö a' a̱ e' kukueblö́. A' tö iwé̱ es, e' ta̱ a' é̱na ia̱rmi buaë, ñies Skëköl tö a' ki̱meraë a̱s ikí̱ a̱r a' é̱na.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ñies Jesús tö iché: “Ì blúie Skëköl tso' e' ta̱ itköke we̱s itkö̀ iyiwö kuatké wëm eköl tö ese ta̱ es. Ie' tö ikuatké të ki̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ta̱ iméa̱t bë̀rë. Ká̱ bit ekkë ie' kapökewa̱ nañewe, ñiwe ta̱ ie' ti̱'rke ta̱ íyi kuatkéitö e' tskine, talane erë ie' kë̀ é̱na ia̱ne tö we̱s itskine we̱s italane. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Íyök ë̀ tö itskeke. Ke̱we ikua tskine, e' ukuöki̱ ta̱ iwörkuane, e' ukuöki̱ ta̱ iwöne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mik iké̱wö de shtè, eta̱ wëm mía̱ ishtökka̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ñies Jesús tö iché: “Ì blúie Skëköl tso' ¿we̱s e' dör? ¿Ttè wé̱ wa ye' tö ikleèmi? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","E' dör we̱s mostaza wö tkèsö es. E' wö dör tsirlala iyiwö ulitane diki̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Erë mik ikuatkënewa̱, eta̱ italar íyi kuá tsitsir ulitane tsa̱ta̱. E' ulà döka̱ wi̱'wi̱ë, e' tsa̱ka̱ dù u yuöke.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Es Jesús tö ie'pa a̱ ikleé tai̱ë we̱s ttè i' es dö̀ wé̱ ie'pa é̱na ia̱ne ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ie' kë̀ wa̱ ì pakane ie'pa a̱ kë̀ kleaule. Erë iwà ko̱s pakekeneitö ittökatapa a̱ bánet kë̀ kleaule. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","E' tsá̱li̱ mik ká̱ tuine, eta̱ Jesús tö iché ittökatapa a̱: —Mishka batsöri wi̱she̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pë' tso' tai̱ë e'pa méa̱rakitö ta̱ ie̱' iéka̱rak kanò a̱ Jesús tso' e' a̱ ta̱ imíyal. Kanò skà mirwa̱ ie'pa ta̱ tseë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","E' bet ta̱ siwa̱' bitsi̱neka̱ tai̱ë tö di' u̱yéka̱ tai̱ë e' tö kanò wà iekeka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Erë ie' kapöme'r kanò ñak a̱ wökir kata ki̱, ee̱ ittökatapa ie' ti̱'wé̱ka̱ ta̱ iché ia̱: —¡A s'wöbla'u̱kwak! ¿Se' duökelur e' kë̀ ki̱ be' tkine? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Eta̱ ie' e̱' kéka̱ tö siwa̱' uñé ta̱ iché di' a̱: —¡Be' e̱' shtö́wa̱ bër! Eta̱ siwa̱' wöklöne di' wöklöne mía̱ne alamië. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Eta̱ ie' tö ittökatapa a̱ iché: —¿Ì kue̱ki̱ a' suane se̱kkë? ¿Ka̱m a' e̱rblö̀ ye' mik? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ie'pa kí̱ tkinewa̱ tai̱ë ta̱ iñi chakéka̱: —¿Yi dör wëm wí̱? ¡E' ttö̀ dalöieke siwa̱' tö di' tö! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ie'pa demi batsöri wi̱she̱t ká̱ kiè Gerasa ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mik Jesús e̱' yéttsa̱ kanò a̱, eta̱ wëm eköl a̱ wimblu sulusi tso' e̱' yéttsa̱ de Jesús ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wëm e' se̱rke pö ké̱ a̱. Kë̀ imonukwa̱ tabechka kichaie wa ì wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tseë imonere iulà a̱ ena iklö a̱ tabechka kichaie wa erë ibatséloritö. Kë̀ yi diché ta̱' wë' iwöklö'wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ñië nañeë ie' shköke pö a̱ ena ka̱bata a̱ a̱rke tai̱ë, ñies ie' e̱' shka̱'u̱ke ák wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Erë mik ie' tö Jesús sué̱ ka̱mië, eta̱ ie' tu̱nebitu̱ e̱' tkése̱r kuchë ki̱ Jesús wö sha̱ë ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ta̱ ichéitö ia̱ a̱neule: —¡A Jesús, be' dör Skëköl dör íyi ulitane tsa̱ta̱ e' Alà! ¿Iö́k be' de ye' tsiriu̱k? ¡Ye' kköchöke be' a̱ Skëköl wörki̱ tö kë̀ ye' we'ikar! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesús tö ie' a̱ ichétke: “¡A wimblu sulusi, wëm se̱ ö́wa!” E' kue̱ki̱ ie' tö iché Jesús a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Eta̱ Jesús tö ie' a̱ ichaké: —¿I̱ma be' kiè? Ie' iiu̱té: —Ye' kiè Tai̱ë Wakpa, sa' dör tai̱ë e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Eta̱ ikköchöke tai̱ë Jesús a̱: “Kë̀ sa' patkar ka̱mië.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ee̱ tsi̱net ka̱bata kuli' a̱ tai̱ë köchi iëte̱r chkök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Eta̱ aknamapa kköché ie' a̱: —Sa' patkö́mi köchi a̱. Ka̱wö mú sa' a̱ e̱' tiu̱kwa̱ ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Eta̱ ie' tö ka̱wö mé ia̱rak ta̱ wimblupa sulusi e̱' yélur wëm e' a̱ ta̱ ie̱' tié̱wa̱rak köchi a̱. Köchi ekkëpa döka̱ mil böyök ulatök (2.000). Eta̱ köchi poneka̱ tu̱nemirak ká̱ spé mik brutolonemi batsöri a̱ ta̱ ee̱ iduolur. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Köchi kkö'nukwakpa tkayalmi ta̱ itté ppéka̱rakitö ká̱ e' wa'ñe a̱. Tai̱ë pë' de iweblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mik ie'pa de Jesús ska' ta̱ wëm a̱ aknama bak e' sué̱rakitö. E' tkër datsi' iéne é̱na ká̱ a̱nene buaë, e' tö ie'pa suawé̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wé̱pa tö ì tka wëm a̱ aknamapa bak e' ta̱ ena köchi ta̱ e' sué̱, e'pa tö ipakéne imale̱pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Eta̱ ie'pa kköché Jesús a̱: “Be' e̱' yö́ttsa̱ ká̱ i' a̱, be' yú bánet.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mik Jesús dene kanò a̱ ta̱ wëm a̱ aknama bak, e' kköché ie' a̱: “Ye' shkakmi be' ta̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Erë Jesús kë̀ wa̱ iké̱wö mène ie' a̱. Ie' iché ia̱: —Be' yúne be' u a̱ be' yamipa ska'. Ì buaë wé̱ Skëköl tö be' a̱ ena we̱s ie' tö be' sué̱ e̱r sia̱rë wa, e' ko̱s pakö́ ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Eta̱ wëm mía̱ ta̱ ì wé̱ Jesús tö ie' a̱ e' pakéitö ká̱ tso' Decápolis e' wakpa a̱. Ie'pa ko̱s tkinewa̱ ittsök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mik Jesús dene kanò ki̱ batsöri io̱she̱t, eta̱ batsöri kkömik tai̱ë pë' e̱' dapa'wé̱ka̱ ie' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","E' dalewa wëm debitu̱ eköl kiè Jairo. E' dör judiowak ñì dapa'wo̱ wé e' wökir eköl. Mik ie' tö Jesús sué̱, eta̱ ie' e̱' té̱wa̱ wöwakköt Jesús wörki̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ta̱ ikköché tai̱ë ie' a̱: —Ye' alà busi duökewa̱tke. Be' shkö́ ulà mukka̱ iki̱ a̱s ibuarne ta̱ ise̱rne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Eta̱ Jesús mía̱ ie' ta̱. Tai̱ë pë' dami Jesús ta̱ e' tërdami ie' mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","E' shu̱a̱ alaköl dami e' du'mi alakölpa duè wa̱ e' ki̱ duas de dabom eyök ki̱ bök (12). ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tai̱ë ie' weine s'kapeyökwakpa ulà a̱ ena ì ko̱s tso' ie' wa̱ e' e̱wé̱waitö yës ie'pa ki̱, erë kë̀ ibuanene, e' skéie imir wa'k ë̀me. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ie' wa̱ Jesús tté ttsëule e' kue̱ki̱ ie' ibikeitsé: “Jesús datsi' bata ë̀ kéwa̱yö e' ta̱ ye' buanene.” E' kue̱ki̱ ie' e̱' skéwa̱ Jesús tsi̱ kke̱r pë' shu̱a̱ ta̱ idatsi' kéwa̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","E' bet ta̱ ipë́ wöklöne ta̱ ie' ittsé e̱' ki̱ tö ibuanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","E' bet Jesús ittsé tö ilè tka ie' diché wa, e' kue̱ki̱ ie' tö pë' tso' ipamik e' ko̱s sué̱ ë̀k ta̱ ichakéitö ia̱: —¿Yi tö ye' datsi' ké? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ittökatapa tö ie' a̱ iché: —¿Kë̀ be' wa̱ isu̱ne tö tai̱ë ie'pa tërdami be' mik? Ta̱ we̱s be' tö ichaké: “¿Yi tö ye' ké?” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Erë ie' tö wé̱pa tso' ipamik e'pa kí̱ weblé ia̱ isuo̱ie tö yi ie' ké. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Alaköl buanene e' painéka̱ tai̱ë suane wa. Ì tka ie' ta̱ e' a̱ne ie' é̱na, e' kue̱ki̱ ie' debitu̱ e̱' tkéwa̱ kuchë ki̱ Jesús wörki̱. Ì ko̱s tka ie' ta̱ e' chéka̱ia̱ yësyësë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Eta̱ Jesús ie' a̱ iché: —A alà busi, be' e̱rblé ye' mik, e' tö be' bua'wé̱ne. Be' yúne bë̀rë. Be' buanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ie' ttökeia̱ alaköl ta̱ e' dalewa we̱lepa bite̱ Jairo u a̱ e'pa wa̱ ibiyö́ de Jairo a̱ ta̱ ichéitörak: —Be' alà busila blënewa̱tke. ¿Iö́k s'wöbla'u̱kwak tsiriwè̱ia̱bö? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Erë ì cheke ie'pa tö e' kë̀ ki̱ Jesús tkine. Ie' tö Jairo a̱ iché: —Kë̀ be' tkinuk. Be' e̱rblö́ ye' mik ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","E' ukuöki̱ ta̱ ie' mía̱ Jairo u a̱. Pedro ena Santiago ena Santiago ël kiè Juan e'pa ë̀ mí ie' wa̱, kë̀ ie' wa̱ yi skà mìne e̱' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mik ie'pa demi Jairo u a̱, eta̱ tai̱ë pë' dapaneka̱ e' tröke i̱u̱ke tai̱ë sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús dewa̱ we̱shke̱ ta̱ ichéitö ie'pa a̱: —¿Ì tso' a' aláu̱k? ¿Ì kue̱ki̱ a' i̱u̱ke? Busila kë̀ du'wa̱, ikapöme'r ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Eta̱ ie'pa tö ie' wayué ena ija̱ñeitsé, erë ie' tö ie'pa ké e̱' yökulur. Eta̱ alà yë́ ena imì ena wé̱pa de ie' ta̱, e'pa ë̀ mí ie' wa̱ e̱' ta̱ úshu̱ a̱ wé̱ alà nu me'rka̱ ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ie' tö iulà klö'wé̱wa̱ ta̱ ichéitö ia̱: —Talíta kum. (ttè e' wà kiane chè: “A tayëla, ye' be' a̱ ichè, be' e̱' kö́ka̱.”) ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","E' bet ta̱ busila e' e̱' duéka̱ shkë'ka ta̱ ishkémi. E' tö ie'pa tkiwé̱wa̱ tai̱ë. (Tayë e' ki̱ duas tso' dabom eyök ki̱ bök.) ");
INSERT INTO bzdNTpo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Erë Jesús tö ie'pa a̱ iché: “Ì tka i' e' kë̀ char yi a̱.” E' ukuöki̱ ta̱ ie' iché: “Alà se̱ tiö́.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","E' ukuöki̱ ta̱ Jesús e̱' yéttsa̱ ká̱ e' a̱ mía̱ ittökatapa ta̱ iwák ká̱ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mik e̱no diwö de, eta̱ ie' tö s'wöbla'wé̱mitke judiowak ñì dapa'wo̱ wé a̱. Tai̱ë pë' daparke ee̱. Mik ie'pa tö ie' ttö̀ ttsé, eta̱ itkirulune ta̱ iñi chakérak: —¿Wé̱ ie' e̱' yué ttè tai̱ë wa? ¿We̱s ie' ulà de ttè buaë i̱ski̱ë ese ska'? ¿We̱s ì kë̀ o̱r yi a̱ ese wé̱itö? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Ie' kë̀ dör kaltak kanéu̱kwak bak kaneblök í̱e̱rö e'? ¿Ie' kë̀ dör María alà? ¿Ie' kë̀ dör Santiago, José, Judas ena Simón e'pa ël? ¿Ñies ie' kutapa kë̀ se̱rku̱' se' shu̱a̱? E' kue̱ki̱ kë̀ ie'pa e̱rblëne ie' mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Erë ie' tö iché ia̱rak: —Ká̱ wa'ñe Skëköl tteköl dalöiërta̱', erë iwák ká̱ ki̱ ena iyamipa shu̱a̱ ena iwák u a̱ ee̱ kë̀ idalöiërta̱'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ee̱ iekkë ta̱ ì kë̀ o̱r yi a̱ ese kë̀ o̱ne ie' wa̱. Ie' ulà méka̱ we̱lepa kirirke esepa ki̱ ta̱ ibuanerak, erë e' kë̀ dör tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ká̱ e' wakpa kibiiepa kë̀ e̱rblëne ie' mik, e' tö ie' tkiwé̱wa̱. E' ukuöki̱ ta̱ Jesús mía̱ ká̱ tsitsirpa tso' tsi̱net ese a̱ s'wöbla'u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ie' ttökatapa dabom eyök kí̱ böl e'pa kiéitö ta̱ ipatkémirak böl böl. Ie' ka̱wö mé ia̱rak wimblupa sulusi trë'wo̱yal. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ie' tö iché ia̱rak: —Kë̀ ì tsa̱rmi, shko kéli e' ë̀ tsú̱mi. Sku' kë̀ tsa̱rmi, chkö̀ kë̀ tsa̱rmi, inuköl kë̀ tsa̱rmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Klökkuö ena datsi' iö́mi, e' ë̀ mik a' mi'mi, erë datsi' kí̱ kë̀ tsa̱rmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ñies ie' iché ia̱: —Mik a' dewa̱ u we̱le a̱, eta̱ a' e̱' tsú̱a̱t ee̱ dö̀ mik a' míyal ká̱ bánet ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ká̱ we̱le wakpa kë̀ wa̱ a' kinewa̱ buaë ö kë̀ ki̱ a' ka̱paköke e' kiane ttsè, e' ta̱ a' e̱' yö́lur ee̱ ta̱ ka̱po tso' a' klöttö mik e' ppö́ö. E' tö ie'pa a̱ ikkacheraë tö ie'pa dör Skëköl bolökpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eta̱ ittökatapa míyal s'pattök i' es: “A' e̱r mane'ú̱ Skëköl a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ñies ie'pa tö aknama trë'wé̱yal tai̱ë. Ñies tai̱ë s'kirirke esepa ki̱ ie'pa tö kiö̀ té ta̱ ibuanenerak. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Eta̱ Jesús tté buneka̱ ká̱ wa'ñe, e' kue̱ki̱ itté ttsé ñies blu' kiè Herodes e' tö. We̱lepa tö icheke: —Jesús dör Juan S'wöskuökwak shke̱neka̱ne e', e' kue̱ki̱ ie' wa̱ diché tso' ì kë̀ o̱r yi a̱ ese wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","We̱lepa skà tö icheke: —Ie' dör Skëköl tteköl bak kiè Elías e' shke̱neka̱ne. We̱lepa skà tö icheke: —Skëköl tteköl idir we̱s Skëköl ttekölpa ia̱'chki es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erë ttè ekkë ttsé Herodes tö ta̱ ichéitö: —Ie' dör Juan kuli' tökök patkë' ye' tö e' shke̱neka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes tö iché es ie' tö Juan S'wöskuökwak klö'u̱kwa̱ patkë' wötèwa̱ s'wöto wé a̱ Herodías kue̱ki̱. Herodías dör Herodes ël kiè Felipe e' alaköl, erë Herodes se̱ne'wa̱ ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Erë Juan tö iyë' Herodes a̱: “Kë̀ be' ka̱wö ta̱' se̱nuk be' ël alaköl ta̱. E' wa be' tso' ttè dalöiëno dalöse̱u̱kwa̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","E' kue̱ki̱ Herodías uluneka̱ Juan ki̱ ta̱ ie' ki̱ ikiane ttèwa̱. Erë Herodes wa̱ ijche̱r tö Juan dör wëm yësyësë ena batse'r ese, e' dalöiekeitö tai̱ë, e' kue̱ki̱ ikkö'nekeitö. Ie' tö Juan ka̱paköke e' ttseke e̱r bua' wa, erë kë̀ ié̱na ia̱ne ì wè̱miitö. Ie' tö Juan dalöieke es, e' kue̱ki̱ Herodías kë̀ a̱ we̱s Juan o̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erë mik Herodes tö iduéswö ké̱wö tkö'we̱ke, eta̱ Herodías isué̱ we̱s iulà dö̀mi Juan ska'. Herodes tö ikue̱blupa ena iñippökwakpa wökirpa ena wé̱pa dalöiërta̱' tai̱ë se̱rke Galilea esepa kiéttsa̱ iké̱wö tkö'u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mik ie'pa tso' iké̱wö tkö'u̱k, eta̱ Herodías alà busi dewa̱ ta̱ iklöté ie'pa wörki̱. E' wër buaë Herodes ena imale̱pa tso' chkök ie' ta̱, e'pa wa, ta̱ ie' iché tayë busi a̱: —Ì kiane be' ki̱ e' kiö́ ye' a̱ ta̱ ye' tö be' a̱ imeraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Eta̱ ie' tö iché ia̱ ttè moki̱ wa Skëköl wörki̱ sulitane kukua: —Ì ko̱s kièbö ña, e' mekeyö be' a̱. Ká̱ ko̱s wökirie ye' tso', e' kiö́ ña ta̱ e' merayö be' a̱ shu̱sha̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Eta̱ tayë busi mía̱, ta̱ imì chakéitö: —¿Ì kièyö? Ta̱ imì iu̱té: —Juan S'wöskuökwak wökir kiö́ ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ie' mía̱ne bet blu' tkër ee̱ ta̱ iché ia̱: —Ye' ki̱ ikiane tö írö Juan S'wöskuökwak wökir tsú̱bitu̱ ña kulë' a̱ iwà kkachoie tö moki̱ ittéwa̱rakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Eta̱ blu' e̱rianeka̱ tai̱ë, erë ie' tö ittè métke s'kiule tso' e'pa kukua, e' kue̱ki̱ kë̀ ie' a̱ io̱nuk we̱s. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","E' kue̱ki̱ bet ie' tö ñippökwak patkémi eköl Juan wökir tsu̱k. Eta̱ ñippökwak mía̱ s'wöto wé a̱ ta̱ Juan kuli' tée, ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ta̱ iwökir tsé̱bitu̱ kulë' a̱ méitö tayë busi a̱, ta̱ tayë busi tö imé imì a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mik Juan ttökatapa wa̱ ijche̱newa̱ ta̱ ie'pa debitu̱ inú kökka̱ tsé̱mi wötèwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mik Jesús ttekölpa tsá̱ e'pa dene ie' ska', eta̱ ì ko̱s wé̱ ie'pa tö ena ì ko̱s wa ie'pa s'wöbla'wé̱ e' pakérakitö ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pë' datse̱ tai̱ë míyal iské datse̱ne kë̀ wa ie'pa chkoia̱ ekkë, e' kue̱ki̱ ie' iché ittökatapa a̱: —Mishka e̱nuk bánet wé̱ kë̀ yi ku̱' ese ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Eta̱ ie'pa míyal bánet kanò ki̱ wé̱ kë̀ yi se̱rku̱' ese ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Erë ie'pa míyal e' sué̱ pë' tö tai̱ë ñies pë' tö isué̱wa̱ tö ie'pa e' idir. Eta̱ pë' ko̱s se̱rke ee̱ e'pa míyal tu̱neule ipanuk wé̱ ie'pa irirke ee̱ demi ke̱we. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mik Jesús e̱' yéttsa̱ kanò a̱, eta̱ pë' tso' tai̱ë ipanuk e' sué̱itö. Ie'pa wër ie' wa we̱s obeja kë̀ kkö'nukwak ta̱' es, e' kue̱ki̱ ie'pa sué̱itö e̱r sia̱rë wa. Eta̱ ie' e̱' kéka̱ ie'pa wöbla'u̱k ttè kua̱'ki̱ kua̱'ki̱ tai̱ë wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ká̱ detke tsá̱li̱ ta̱, ittökatapa de ie' ska' ta̱ ichérakitö ie' a̱: —Ká̱ de tsá̱li̱, kë̀ yi se̱rku̱' í̱e̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ie'pa yuö́mi a̱s ie'pa mi' pë' se̱rke tsi̱net ena ká̱ tso' tsi̱net ese ska' ilè ta̱u̱k ñè. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Erë ie' tö ie'pa iu̱té: —Ie'pa tiö́ a' tö. Ie'pa iiu̱té: —¿Be' ki̱ kiane tö sa' mi' chkè ta̱u̱k ie'pa tioie? Chkè ekkë tuo̱ie inuköl kiane s'kaneblö̀mi dö̀ ká̱ cien böyök e' ské ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ie' tö ie'pa a̱ ichaké: —¿Ko̱s a' wa̱ pan tso'? A' yú iweblök. Ie'pa dare iweblök ta̱ ichéitö ia̱: —Pan tso' ske̱l ena nima bötö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Eta̱ ie' tö iché ie'pa a̱: —Pë' ko̱s kö́ e̱' tulökse̱r ta'tsi ki̱ erule erule. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Eta̱ pë' e̱' tulése̱r cien eyök, we̱lepa e̱' tulése̱r dabom ske̱yök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","E' ukuöki̱ ta̱ ie' tö pan ske̱l ena nima bötö e' klö'wé̱ ta̱ iká̱ sué̱ ká̱ jaì a̱ ta̱ wëstela chéitö Skëköl a̱. E' ukuöki̱ ta̱ ie' tö pan ena nima blaté ta̱ iméitö ittökatapa a̱ a̱s ie'pa tö iwatiö̀ pë' ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ie'pa ulitane chké de wë'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pan ena nima bata a̱te̱ e' shtérakitö iëne döka̱ kkö́la dabom eyök ki̱ bök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wëpa këchkepa chké esepa döka̱ mil ske̱yök (5.000). ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","E' ukuöki̱ ta̱ Jesús tö iché ittökatapa a̱: “A' e̱' iö́ka̱ kanò a̱, a' yúshkatke ye' yöki̱ ke̱we batsöri wi̱she̱t Betsaida kke̱r.” Ie' tö iché pë' male̱pa a̱: “A' yú a' u a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","E' ukuöki̱ ta̱ ie' mía̱ ka̱bata a̱ ttök S'yë́ ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ká̱ tuine ta̱ kanò demi batsöri shu̱sha̱ë. Ie' e̱' tsé̱a̱t ekörla ká̱ sí ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ie' tö isué̱ tö ie'pa kaneblöke darërë kanò patkoie siwa̱' bitsi̱rke ie'pa kke̱ wöiá̱ e' kue̱ki̱. Ká̱ ñirketke ta̱ ie' mía̱ ie'pa ska' shkörami di' kí̱. Ie' tkökemitke tsi̱net ie'pa o̱'mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Erë mik ie'pa isué̱ tö ie' shkö̀datse̱ di' kí̱, eta̱ ie'pa ibikeitsé tö wimblu idir, e' tö ie'pa tkiwé̱wa̱ tai̱ë ta̱ ia̱neka̱rak. Erë bet ta̱ ie' iché ie'pa a̱: —¡A' e̱r kuú̱! ¡Kë̀ a' suanuk! Ye' idir. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Eta̱ ie' e̱' iéka̱ kanò a̱ ta̱ siwa̱' wöklöne. Ie'pa tkirulune tai̱ë iweblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ie'pa e̱r dör daloie, e' kue̱ki̱ Jesús tö pë' tai̱ë dë' pan ske̱l ë̀ wa, e' wà kë̀ dë'wa̱ ie'pa e̱r a̱. E' kue̱ki̱ ie'pa tkirulune tai̱ë ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Itkattsa̱rak batsöri wi̱she̱t demirak Genesaret ta̱ ee̱ kanò mué̱wa̱rakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ie'pa e̱' yélur kanò a̱ ta̱ e' wösha̱ ta̱ pë' tö Jesús sué̱wa̱ tö ie' idir. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Eta̱ itu̱nerak ká̱ e' wa'ñe ibiyö́ chök. Mik pë' tö ittsé, eta̱ ie'pa tö s'kirirke tsé̱mi wé̱ ittsérakitö tö Jesús tso' ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ká̱ wa'ñe wé̱ ie' mir, wé̱ s'tso' tai̱ë ö bërëbërë, eta̱ pë' tö s'kirikepa tulekese̱r ñala̱ sha̱ë ta̱ ikköchökerak ie' a̱ tö ie'pa a̱ idatsi' bata ë̀ mú kèwa̱. S'kirirke ko̱s tö iké, esepa buanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseowakpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa we̱lepa datse̱ Jerusalén e'pa debitu̱ Jesús ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mik ie'pa tö isué̱ tö Jesús ttökatapa we̱lepa chköke ulà kë̀ paköule, eta̱ e' ki̱ ie'pa tö icheke suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Fariseowakpa ena judiowak male̱pa ko̱s tö ie'pa yë́pa bak e' se̱r klö'wé̱ darërë. E' kue̱ki̱ kë̀ ichköta̱'rak kë̀ ulà paköule we̱s ie'pa a̱ imenea̱t es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mik ie'pa dare chkewö ta̱u̱k, eta̱ kë̀ ichköta̱'wa ka̱m iulà pakör e' yöki̱. Es ie'pa wa̱ íyi ese skà tso' tai̱ë dalöiëno. Ñies tka̱', kulë', ù̱, ka̱' ekkëpa ko̱s pakueke ie'pa tö.) ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","E' kue̱ki̱ fariseowakpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa tö Jesús a̱ ichaké: —¿Ì kue̱ki̱ be' ttökatapa kë̀ tö se' yë́pa bak e' se̱r e' ttè dalöiè? ¿Iö́k ichkörak ñá ulé wa? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ie' tö ie'pa iu̱té: —Buaë Isaías tö a' e̱' ö̀ sulu e'pa yë' mik ie' tö iyë': ‘Skëköl tö ichè: Pë' ikkëpa tö ye' dalöiè kkö̀ ë̀ wa, erë ie'pa e̱r tso' ka̱mië ye' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ë́ ichökle ie'pa mi'ke ye' wé a̱ ye' dalöiök. Ttè wa ie'pa s'wöbla'we̱ke e' dör s'ditsö ttè dalöiëno ë̀.’ Es Isaías tö iyë'a̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","A' tö Skëköl ttè watéttsa̱ s'ditsö se̱r e' ttè dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ñies ie' iché ia̱rak: —Skëköl ttè dalöiëno e' méa̱t a' tö bánet a' wákpa se̱r e' ttè dalöioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés tö iyë': ‘A' yë́ ena a' mì e'pa dalöiö́.’ Ñies ie' tö iyë'a̱t: ‘Yi tö iyë́ ö imì ché suluë ese wák wömerdattsa̱ ttèwa̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Erë a' icheke tö se' a̱ iyërmi s'yë́ a̱ ö s'mì a̱ i' es: ‘Ì ko̱s tso' ye' wa̱, e' dör corbán’ (e' wà kiane chè tö imeulettsa̱ Skëköl a̱). E' kue̱ki̱ kë̀ ye' a̱ a' ki̱menuk ì wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ñies a' tö icheke tö yi isie e' ché, ese kë̀ ka̱wöta̱ia̱ iyë́ ö imì ki̱muk. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Es a' wákpa se̱r e' ttè wa a' tö s'yueke, e' iu̱tè wa a' tö Skëköl ttè dalöiëno e' dalöse̱we̱kewa̱. Ì sulu ese skà wambleke a' tö tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","E' ukuöki̱ ta̱ ie' tö pë' tso' ee̱ e'pa kié ta̱ ie' iché ia̱rak: —A' ulitane tö ye' ttö̀ ttsö́, iwà a̱nú a' é̱na. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Ì ñeke a' tö e' kë̀ tö a' ia'we̱pa ñáie Skëköl wöa̱. Erë ì sulu wambleke a' tö tskirke a' e̱r a̱ ese je' tö a' ia'we̱raë ñáie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mik ie' tö pë' méa̱t dewa̱ we̱shke̱, eta̱ ittökatapa tö ì kleé ie' tö e' wà chaké ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ie' tö ie'pa iu̱té: —¿Ñies a' kë̀ é̱na iwà a̱ne? ¿A' kë̀ é̱na ia̱ne tö ì ko̱s ñekewasö e' kë̀ tö s'ia'we̱pa ñáie? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ì ko̱s ñekewasö e' kë̀ mi'ku̱'wa̱ s'e̱r a̱, e' mi'kewa̱ s'ñawi a̱ e' ukuöki̱ ta̱ iwekettsa̱sö. E' kue̱ki̱ e' kë̀ tö s'ia'we̱pa ñáie. (Ttè e' wa ie' ki̱ ikiane chè tö chkè ulitane dör batse'r.) ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ñies ichéitö: —Ì sulu wambleke a' tö tskirke a' e̱r a̱ ese je' tö a' ia'we̱raë ñáie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ì sulu bikeitseke a' tö, trë, akblè, s'ttèwa̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","se̱newa̱bak dalöse̱wè̱wa̱, o̱'ka íyi kkechè, ì ko̱s sulu wamblè, s'male̱pa wöyuè, s'male̱pa wörieikè, ukyëne, ñì chè suluë, e̱' ttsèka̱, ì ko̱s dör yësyësë ese watèttsa̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","íyi ese ko̱s tskirke a' e̱r a̱ e' tö a' ia'we̱raë ñáie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","E' ukuöki̱ ta̱ Jesús mía̱ ká̱ kiè Tiro e' kke̱r. Ee̱ ie' e̱' tsé̱a̱t yile ska'. Ie' kë̀ ki̱ ikiane tö yi wa̱ ijche̱rwa̱ tö ie' tso' ee̱; erë kë̀ ie' a̱ e̱' blëne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","E' bet busila eköl a̱ wimblu sulusi tso', e' mì wa̱ ijche̱newa̱ ta̱ imía̱ ta̱ ie̱' tkéwa̱ kuchë ki̱ ie' wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Alaköl e' kë̀ dör judiowak, e' dör ká̱ kiè Sirofenicia e' wak. Eta̱ ikköché ie' wöa̱: —Aknama tso' ye' alà busi a̱ e' trë'ú̱shkar. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Erë ie' tö iché ia̱: —Kë̀ idör buaë ala'rla chkè yèttsa̱ mè chichi a̱. E' kue̱ki̱ a̱s ye' ala'r chkö̀ ke̱we. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Erë tayë tö ie' iu̱té: —A këkëpa, e' yëne; erë s'ala'r chköke e' kamule̱ darke i̱ski̱ ese ñeke chichi tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús tö ie' a̱ iché: —Buaë be' iu̱té, e' kue̱ki̱ be' yúne bë̀rë. Aknama trëneshkartke be' alà busila a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mik alaköl e' demine u a̱, eta̱ ilà busila kué̱itö ka̱' ki̱. Aknama kë̀ ku̱'ia̱ ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús e̱' yéttsa̱ Tiro tkami Sidón demi Galilea batsöri Decápolis kke̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ee̱ pë' wa̱ wëm debitu̱ eköl ie' ska' e' kë̀ kukuö̀ wattsër ena kë̀ tto buaë. Ie'pa tö ikié Jesús a̱: “be' ulà múka̱ iki̱ a̱s ibuarne.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús wa̱ imítse̱r bánet wé̱ kë̀ yi ku̱' ee̱, ta̱ iulatska tié̱wa̱ wëm kirirke e' kukuöuk bök a̱ ta̱ iwiri wa iku' kéwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","E' ukuöki̱ ta̱ ká̱ sué̱itö ká̱ jaì a̱, isiwa̱' tkéka̱ ta̱ ichéitö wëm a̱: “¡Efatá!” (e' wà kiane chè ie'pa ttö̀ wa: “¡Kukuö̀ shu̱bunú!”) ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","E' bet ta̱ wëm kukuö̀ ena ittö̀ buanene ta̱ ittéka̱ buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús tö iché ia̱rak tö kë̀ ichar yi a̱. Erë ko̱s e' ché ie' tö ie'pa a̱, e' tsa̱ta̱ ie'pa tö ikí̱ chekeia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ie'pa tkirulune tai̱ë iweblök, ta̱ ichérakitö, “¡Ì ko̱s we̱ke ie' tö buaë dö̀ s'kukuö̀ kë̀ wattsër ese bua'wé̱itö ta̱ iwattsëne buaë, ñies s'me' bua'wé̱itö ta̱ ittéka̱ne buaë!” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Etökicha ta̱ pë' e̱' dapa'wé̱ne tai̱ë Jesús ska', e'pa kë̀ wa̱ ì ku̱' ñè. Ta̱ ie' tö ittökatapa kié ta̱ ichéitö ie'pa a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Sia̱rë ye' wa pë' ikkëpa wër. Ie'pa tso' ye' ta̱ e' ki̱ ká̱ de mañatk ta̱ kë̀ ie'pa wa̱ ì ku̱' ñè. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","We̱lepa datse̱ ka̱mië. E' kue̱ki̱ dö' ye' tö ipatkéminerak u a̱ kë̀ chkaule ta̱ isiwa̱'a̱rwa̱mirak ñala̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Eta̱ ittökatapa ie' iu̱té: —Erë ¿ì wa se' tö ie'pa tièmi ká̱ i'se a̱ wé̱ kë̀ yi se̱rku̱' ee̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ie' tö ie'pa a̱ ichaké: —¿Ko̱s a' wa̱ pan tso'? Ie'pa iiu̱té, —Kul (7). ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eta̱ ie' tö pë' ké e̱' tulökse̱r i̱ski̱ ta̱ pan kul klö'wé̱itö ta̱ wëstela chéitö Skëköl a̱ ta̱ iblatéitö mé ittökatapa a̱ watiè pë' a̱, eta̱ es ie'pa tö iwé̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ñies nima tsitsirla tso'rak iwa̱ elkela e' ki̱ wëstela chéitö Skëköl a̱ ta̱ ittökatapa patkéitö iwatiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Pë' ulitane chké de wë' ta̱ chkè bata a̱te̱ e' shtérakitö iëne döka̱ kkö́ kul. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ichkérak e'pa döka̱ mil tkëyök (4.000) ulatök. E' ukuöki̱ ta̱ Jesús tö ie'pa yuémine ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ta̱ ie' e̱' iéka̱ kanò a̱ ittökatapa ta̱ míyal ká̱ kiè Dalmanuta ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseowakpa debitu̱ Jesús ska' ta̱ ittémirak ie' ta̱ kësik wa. Ie'pa é̱na ie' tsa̱iak, e' kue̱ki̱ ie'pa tö ie' a̱ ikié tö ì kë̀ o̱r yi a̱ ese wé̱itö iwà kkachoie tö moki̱ ie' patkë'bitu̱ Skëköl tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús siwa̱' tkéka̱ i̱ski̱ë ta̱ ichéitö: —¿Ì kue̱ki̱ ì kë̀ o̱r yi a̱ ese kieke a' tö iwà kkachoie tö yi dör ye'? Moki̱ yö a' a̱ ichè tö ese kë̀ kkayërpa a' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Eta̱ ie' tö ie'pa méa̱t ta̱ ie' e̱' iéka̱ne kanò a̱ ta̱ imía̱ batsöri wi̱she̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Eta̱ Jesús ttökatapa é̱na ilè chowa tsè̱mi ñè. Pan etkë̀ mírak iwa̱ e̱' ta̱ kanò a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús iché ia̱rak: —¡A' tso' wösh wa! A' e̱' kkö'nú fariseowakpa pan wölöwo̱ka̱ e' yöki̱. Ñies a' e̱' kkö'nú Herodes pan wölöwo̱ka̱ e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ittökatapa iché ñì a̱: —¡Kë̀ se' wa̱ ì ta̱' ñè! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús wa̱ ijche̱newa̱, ta̱ ie' iché ia̱rak: —¿Ì kue̱ki̱ a' tso' ichök ñì a̱ tö a' kë̀ wa̱ ì ta̱' ñè? ¿Ka̱m a' é̱na iwà a̱r? ¿Ka̱m a' wa̱ iwà jche̱rwa̱? ¿A' e̱r darërë dö̀ ekkë? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","A' wöbla ta̱' ¿e' kë̀ wawër? A' kukuöña ta̱' ¿e' kë̀ wattsër? ¿A' kë̀ é̱na ia̱neia̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mik ye' tö pan ske̱l wadë' wëpa döka̱ mil ske̱yök (5.000) ekkë a̱, eta̱ ¿kkö́ bik ibata kit a' tö? Ie'pa iiu̱té: —Dabom eyök ki̱ bök (12). ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ñies mik ye' tö pan kul (7) wadë' wëpa döka̱ mil tkëyök (4.000) ekkë a̱, eta̱ ¿kkö́ bik wà ië' a' tö ibata wa? Ie'pa iiu̱té: —Kul (7). ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Eta̱ ie' iché ia̱rak: —¿Ka̱m a' é̱na iwà a̱r? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","E' ukuöki̱ ta̱ idemirak Betsaida ta̱ wëm wöbla kë̀ wawër ese debitu̱ eköl pë' wa̱ Jesús a̱ ta̱ ikköchökerak ie' a̱ tö ikö́ ulà wa a̱s ibuarne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Eta̱ ie' tö iklö'wé̱wa̱ iulà a̱ ta̱ iyéttsa̱itö bánet. Ee̱ ie' tö iwöbla bök nuwé̱ka̱ wiri wa ta̱ iulà méka̱ iki̱ ta̱ ichakéitö, “¿Be' wöbla wawëne?” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eta̱ wëm tö ká̱ weblé ta̱ iché: —Pë' sue̱keyö erë ye' wa iwër wësua kal shköke su̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Eta̱ Jesús ulà méka̱ne iwöbla ki̱ ta̱ wëm tö ká̱ sué̱ krereë ta̱ iwöbla wawënene buaë. Íyi ulitane sué̱itö buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Eta̱ Jesús tö ipatkémine iu a̱ ta̱ iché ia̱: —Kë̀ be' mi'ktkö pë' shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","E' ukuöki̱ ta̱ Jesús ena ittökatapa míyal ká̱ tso' tseë a̱te̱ Cesarea Filipo e' a̱. Ñala̱ ki̱ Jesús tö ie'pa a̱ ichaké: —¿I̱ma pë' tö ichè, ye' dör yi? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ie'pa iiu̱té: —We̱lepa tö icheke tö be' dör Juan S'wöskuökwak. We̱lepa skà tö icheke tö be' dör Skëköl tteköl bak kiè Elías shke̱neka̱ne e'. We̱lepa skà tö icheke tö be' dör Skëköl ttekölpa skà bak e' we̱le. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ie' tö ie'pa a̱ ichaké: —Erë ¿i̱ma a' ichè, ye' dör yi? Pedro tö iiu̱té: —Be' dör wé̱ pairine'bitu̱ idi' wa sa' blúie e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Erë Jesús kë̀ wa̱ ie'pa kàne yi dör ie', e' chök yi a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús tö ie'pa a̱ itsá̱ ché: —Ye' dör S'ditsö Alà, e' weirdaë tai̱ë. Judiowak kue̱blupa ena sacerdotepa wökirpa ñies s'wöbla'u̱k ttè dalöiëno wa wakpa tö ye' waterattsa̱. Ye' tterawa̱, erë e' ki̱ ká̱ de mañat eta̱ ye' shke̱rdaka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ttè e' chéitö ie'pa a̱ wösha̱k. Erë Pedro tö ie' kiémi bánet ta̱ iuñémiitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Erë Jesús e̱' wötrée ta̱ ittökatapa weblé krereë ta̱ Pedro uñéitö i' es: —¡A Satanás, be' yúshka bánet ye' yöki̱! Be' kë̀ tö íyi suè̱ we̱s Skëköl tö isue̱ke es; be' tö isue̱ke we̱s s'ditsö tö isue̱ke es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","35","E' ukuöki̱ ta̱ ie' tö ittökatapa ena pë' male̱pa kié e̱' ska' ta̱ ichéitö: —Yi e̱' tsa̱tkak ittèwa̱ yöki̱, ese kë̀ ulà a̱ se̱ne michoë dö̀pa. Erë yi e̱' mettsa̱ ttèwa̱ ye' dalërmik ena ye' ttè buaë e' dalërmik, ese ulà a̱ idöraë. E' kue̱ki̱ yi e̱' yuak ye' ttökataie, ese kë̀ kàne tkinukia̱ e̱' ki̱. E' skéie ie' ka̱wöta̱ e̱' chök dö̀ ittèwa̱ wötëulewa̱ krus mik ekkë. Es ie' ka̱wöta̱ shkök ye' itöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Íyi ulitane tso' ká̱ i' a̱, e' de a' ulà a̱, erë se̱ne michoë e' kë̀ dë' a' ulà a̱, e' ta̱ e' dör ¿ìie bua' a' a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Se̱ne michoë kë̀ pato̱rpa ì wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mik ye' dör S'ditsö Alà, e' dene ye' Yë́ olo ta̱', ñies ibiyöchökwakpa batse'r e'pa ta̱, eta̱ wé̱pa jaëne ye' ki̱ pë' sulusipa kë̀ tö Skëköl dalöiè we̱s trër wakpa kë̀ tö imaso dalöiè es esepa wörki̱, esepa ki̱ ye' jaërdaë ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ñies ie' tö iché ie'pa a̱: —Moki̱ ye' tö a' a̱ ichè tö a' tso' í̱e̱, e' we̱lepa tö ì blúie Skëköl tso' e' ké̱wö de diché ta̱', e' sue̱raë ka̱m iblërulur e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ká̱ teröl ukuöki̱ ta̱ Jesús mía̱ ká̱ bata ka̱kke̱ë e' ki̱. Pedro, Santiago ena Juan e'pa mítse̱r iwa̱ e̱' ta̱. Eta̱ ee̱ ie'pa wö sha̱ë ie' manenettsa̱ mía̱ kua̱'ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ie' datsi' manenettsa̱ mía̱ dalölöë saruruë, kë̀ yi a̱ ká̱ wa'ñe datsi' sunuk a̱s idöttsa̱ saruruë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eta̱ ie'pa tö Skëköl ttekölpa bak ká̱ ia̱ia̱ë kiè Elías ena Moisés e'pa sué̱ ka̱pakök Jesús ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ie'pa tkinewa̱ tai̱ë. Pedro kë̀ é̱na ì a̱neia̱ chè, e' kue̱ki̱ ichéitö Jesús a̱: —¡A S'wöbla'u̱kwak, buaë se' tso' í̱e̱! Sú̱ sa' tö úla yuèka̱ mañatkuela, etkue be' a̱, etkue Moisés a̱, etkue Elías a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eta̱ mochka tö ie'pa ki̱téwa̱ ta̱ e' shu̱a̱ ie'pa tö ttö̀ ttsé tö ichè: “Se̱ dör ye' alà dalër tai̱ë ye' é̱na, e' ttö̀ ttsö́.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","E' bet ta̱ ie'pa ká̱ sué̱ ipamik ta̱ ie'pa isué̱ tö kë̀ yi ku̱'ia̱, Jesús ë̀ dur ie'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ie'pa datskene wöwa'k ta̱ Jesús tö ie'pa a̱ ichè: —Ì sué̱ a' tö e' kë̀ pakar yi a̱ dö̀ mik ye' dör S'ditsö Alà, e' ttéwa̱ shke̱neka̱ne e' ukuöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","E' kue̱ki̱ ie'pa tté iwakpa ë̀ ñì ta̱. Erë ie'pa ñì chaköke: “Ie' ttéwa̱ shke̱neka̱ne ¿i̱ma e' wà dör?” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ie'pa tö Jesús a̱ ichaké: —¿Ì kue̱ki̱ s'wöbla'u̱k ttè dalöiëno wa wakpa tö icheke tö Elías ka̱wöta̱ dökne ke̱we wé̱ pairine'bitu̱ idi' wa s'blúie e' yöki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ie' iiu̱térak: —E' yëne tö Elías datse̱ ke̱we. Ie' tö ì ko̱s kanewe̱ketke ke̱we wé̱ pairine'bitu̱ idi' wa s'blúie e' yöki̱. Erë ¿ì kue̱ki̱ Skëköl yëkkuö tö ichè tö S'ditsö Alà, e' weirdaë ena iwatërdattsa̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ye' tö a' a̱ ichè tö Elías dë'bak, eta̱ ie'pa tö iwe'ik sia̱rë we̱s ie'pa ki̱ ikiane es. E' bak we̱s ie' tté tso' kitule Skëköl yëkkuö ki̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mik idenerak wé̱ ittökatapa male̱pa tso' ee̱, eta̱ ie'pa isué̱ tö tai̱ë pë' tso' ipamik. Ñies isué̱itörak tö s'wöbla'u̱k ttè dalöiëno wa wakpa we̱lepa ñì iu̱töke ie'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mik pë' tö Jesús sué̱, eta̱ iwö krarulune ta̱ itu̱nemirak ishke̱'u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ie' tö ichaké ittökatapa a̱: —¿Ì ki̱ a' ñì iu̱töke? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wëm eköl tö iché ie' a̱: —A s'wöbla'u̱kwak, í̱e̱ ye' wa̱ ye' aladulaköl debitu̱ be' a̱. Wimblu sulusi tso' ia̱ e' kue̱ki̱ kë̀ itto. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ká̱ wa'ñe wé̱ ie' tso' ee̱ wimblu tö ie' é̱na ká̱ chöwe̱kewa ta̱ ikéu̱re i̱ski̱ ta̱ shuya deka̱ ikkö̀ a̱, ikà blarke ñì mik ena ikranewa̱. Be' ttökatapa a̱ ikiéyö tö wimblu e' trë'ú̱shkar erë kë̀ ie'pa a̱ io̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús tö iiu̱té: —¡A pë' kë̀ e̱rblöta̱' Skëköl mik! ¿Mik ye' se̱rmirö a' ta̱? ¿Ko̱s ye' tö a' dalë'ttsemirö? Kabëla ñe' tsú̱bitu̱ ña. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eta̱ ie'pa wa̱ kabëla mítse̱r Jesús ska'. Erë mik wimblu sulusi ñe' tö Jesús sué̱ ta̱ kabëla painuwé̱ka̱itö tai̱ë a̱nerö i̱ski̱ e̱' tréka̱ burup burup ta̱ ikkö̀ a̱ shuya deka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús tö kabëla yë́ a̱ ichaké: —¿Mik i' wamblënemi ie' ta̱? Iyë́ tö iu̱té: —Mik ie' ià̱ tsirlala e'ta̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tai̱ë wimblu tö ie' ma'wé̱ ttèwa̱. Mikle ta̱ iu̱yéwa̱itö bö' a̱ ö di' a̱ ittowa̱ie. Sa' sa̱ú̱ e̱r sia̱rë wa. Ilè o̱rmi be' a̱, e̱'ma sa' ki̱mú. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús tö iiu̱té: —¿We̱s bö ibikeitsèmi tö ye' kë̀ a̱ io̱nuk? Yi e̱rblöke Skëköl mik, ¡ese a̱ ì ko̱s o̱rmi! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Eta̱ kabëla yë́ tö iché a̱neule: —Ye' e̱rblöke Skëköl mik. ¡Ye' ki̱mú kí̱ e̱rblök imik! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mik Jesús tö isué̱ tö tai̱ë pë' daparke, eta̱ wimblu sulusi uñéitö i' es: —A wimblu, kabëla i' tteke be' tö kukuö̀ kë̀ wattsër, kë̀ tto. Ye' tö be' ké e̱' yö́ttsa̱ kabëla i' a̱. Kë̀ be' e̱' tiu̱kwa̱ne ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wimblu a̱neka̱ ta̱ kabëla skà é̱na ká̱ chöwé̱wa̱neitö. E' ukuöki̱ ie' e̱' yéttsa̱ ta̱ kabëla a̱te̱ we̱s s'duowa̱ es. E' kue̱ki̱ pë' tai̱ë tö ichè tö moki̱ iduowa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Erë Jesús tö iklö'wé̱wa̱ iulà a̱ ta̱ iki̱mé e̱' kökka̱ ta̱ ie' e̱' kéka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","E' ukuöki̱ ta̱ Jesús dewa̱ we̱shke̱ ta̱ ittökatapa tö ie' a̱ ichaké bánet. —¿Ì kue̱ki̱ sa' kë̀ a̱ wimblu e' trëneshkar? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ie' tö ie'pa iu̱té: —Wimblu sulusi ese trëo̱shkarmi ikiè S'yë́ a̱ e' ë̀ wa ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jesús ena ittökatapa e̱' yéttsa̱ ee̱ tkami Galilea. Ie' tso' ie'pa wöbla'u̱k, e' kue̱ki̱ ie' kë̀ ki̱ ikiane tö wé̱ ie'pa tso' e' jche̱rwa̱ yi wa̱. Ie' tö iché ie'pa a̱: —Ye' dör S'ditsö Alà, e' wömerdattsa̱ pë' ulà a̱ ta̱ ye' tterawa̱rakitö. Erë e' ki̱ ká̱ de mañat ta̱ ye' shke̱rdaka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Erë ì ché ie' tö, e' wà kë̀ a̱ne ie'pa é̱na, ñies ie'pa suanerak ichakök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","E' ukuöki̱ ie'pa demi Cafarnaúm. Mik ie'pa dewa̱ we̱shke̱, eta̱ Jesús tö ie'pa a̱ ichaké: —¿Ì ki̱ a' ñì iu̱töro ñala̱ ki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Erë ñala̱ ki̱ ie'pa ñì iu̱töro tö wé̱ dör ibua'ie imale̱pa tsa̱ta̱, e' kue̱ki̱ ie'pa siwa̱'bléwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Eta̱ Jesús e̱' tkése̱r ta̱ ie'pa dabom eyök ki̱ böl e'pa kiéitö ta̱ ichéitö ia̱: —Yi ki̱ ikiane tö idö̀ ibua'ie imale̱pa tsa̱ta̱, e' ta̱ ese ka̱wöta̱ e̱' wöökwa imale̱pa diki̱a̱ ikanè mésoie iki̱moie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","E' ukuöki̱ ta̱ alala duése̱ritö eköl ie'pa shu̱sha̱ë ta̱ ikéka̱itö ulà a̱ ta̱ ichéitö ia̱rak: ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Yi tö alala i'se kiéwa̱ ye' ttö̀ wa, ese tö ye' wák kiéwa̱. Es ñies yi tö ye' kiéwa̱, ese kë̀ wa̱ ye' ë̀ kinewa̱, yi tö ye' patkë'bitu̱, e' kiéwa̱itö ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan tö iché Jesús a̱: —A s'wöbla'u̱kwak, wëm sué̱ sa' tö eköl, e' tö aknama trë'wé̱yal be' ttö̀ wa. Erë ie' kë̀ ku̱' se' ta̱, e' kue̱ki̱ sa' tö iché ia̱ tö kë̀ iwa̱ria̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","40","Ie' tö ie'pa iu̱té: —Yi tö ì kë̀ o̱r yi a̱ ese wé̱ ye' ttö̀ wa, ese kë̀ a̱ ye' yënuk suluë. Yi kë̀ ku̱' ñippök se' ta̱, ese tso' se' ta̱. E' kue̱ki̱ kë̀ iwöklö'wa̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yi isie tö di' kakla ë̀ mé a' a̱ yè, ye' dör Cristo e' icha a' dör e' kue̱ki̱, moki̱ ye' tö a' a̱ ichè tö ese a̱ iské pato̱rdaë buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Yi tö ikkëpala e̱rblöke ye' mik, ese eköl ké ì sulu wamblök, esepa weirdaë tai̱ë shu̱te̱ tkö̀ka̱ ák wawoie mué̱wa̱ ikuli' a̱ batrèemi dayë a̱ e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","A' ulà tö a' ké ì sulu wamblök, e' ta̱ itö́ö. A' döwa̱ se̱ne micho a̱ ulà etkë̀, e' dör buaë. E' skéie a' döwa̱ bö' ké̱ a̱ ulà bötkë e' dör suluë. Ee̱ bö' kë̀ wöitta̱'wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","A' klö̀ tö a' ké ì sulu wamblök, e' ta̱ itö́ö. A' döwa̱ se̱ne micho a̱ klö̀ etkë̀, e' dör buaë. E' skéie a' u̱yèwa̱ bö' ké̱ a̱ klö̀ bötkë e' dör suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","A' wöbla tö a' ké ì sulu wamblök, e' ta̱ iyö́ttsa̱. A' döwa̱ ì blúie Skëköl tso' e' a̱ wöbla ek ë̀, e' dör buaë. E' skéie a' u̱yèwa̱ bö' ké̱ a̱ wöbla bökë e' dör suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","E' ké̱ a̱ öña tö s'kateke ke̱kraë kë̀ duöta̱'wa̱, ñies bö' wöñarke kë̀ wöitta̱'wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“S'weir e' dör s'paiklè we̱s iyiwak jchè ña'wè̱ mè Skëköl a̱ ese paiklè dayë wa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Dayë dör buaë, erë kë̀ ikke ta̱'ia̱, e' ta̱ kë̀ ibuarpaia̱ne. Kë̀ a' tö dayë kke chöu̱kwa a' e̱r a̱. A' se̱nú bë̀rë ñita̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús e̱' yéttsa̱ Cafarnaúm mía̱ Judea ta̱ itkattsa̱ Jordán a̱ wi̱she̱t. Ee̱ pë' e̱' dapa'wé̱ne ie' ska' ta̱ ie' tö ie'pa wöbla'wé̱mitke we̱s ie' wöblar es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Eta̱ fariseowakpa we̱lepa de ie' ska' ta̱ ie'pa tö ie' a̱ ichaké itsa̱ioie: —¿Wëpa a̱ ka̱wö ta̱' itayë owa ö au? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ie' tö ie'pa iu̱té: —¿Ì u̱k Moisés tö a' ka' ttè dalöiëno ki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ie'pa tö ie' iu̱té: —Moisés tö iké̱wö me' se' a̱ ñì owa yëkkuö muk s'tayë a̱ ta̱ itrë'u̱kshkar. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ie' tö ie'pa a̱ iché: —A' e̱r darërë, e' kue̱ki̱ Moisés tö ttè e' me'a̱t a' a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Erë mik ká̱ i' yöne, eta̱ kë̀ idir es. Itso' kitule i' es: ‘Skëköl tö se' yö' wëm ena alaköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","E' kue̱ki̱ wëpa kë̀ se̱rpaia̱ iyë́ ena imì e'pa dapömik ta̱ ise̱rdawa̱ alaköl ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ie'pa böl se̱rdaë ñita̱ ta̱ ie'pa mía̱ we̱s wák eköl ë̀ es.’ Es ikite̱a̱t, e' kue̱ki̱ ie'pa kë̀ ià̱ böl, ie'pa yöne we̱s wák eköl ë̀ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","E' kue̱ki̱ wé̱pa batséwa̱ Skëköl tö esepa kë̀ batsökök yi tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mik ie'pa dene we̱shke̱, eta̱ ittökatapa tö ie' ichaké ttè e' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ie' tö ie'pa iu̱té: —Wëm tö itayë éwa, ese tö alaköl ské tsé̱wa̱ne, e' ta̱ e' wa ie' tö ise̱newa̱bak ke̱we e' dalöse̱wé̱wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ñies tayë tö iwëm éwa, ese tö wëm ské tsé̱wa̱ne, e' ta̱ e' wa ie' tö ise̱newa̱bak ke̱we e' dalöse̱wé̱wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Eta̱ pë' wa̱ ala'rla debitu̱ a̱s Jesús ulà mùka̱ iki̱. Erë ittökatapa tö pë' e'pa uñélor. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mik e' sué̱itö ta̱ iluneka̱ ta̱ ichéitö ie'pa a̱: —A̱s ala'rla bitu̱ ye' ska'. Wé̱pa dör we̱s ie'pa es, esepa blúie Skëköl tso', e' kue̱ki̱ kë̀ iwöklö'wa̱ria̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Moki̱ ye' tö ichè tö yi kë̀ e̱' wöö̀wa we̱s alala es ì blúie Skëköl tso' e' kiowa̱, ese kë̀ döpawa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Eta̱ ie' tö ala'rla paklö'wé̱wa̱ ta̱ iulà méka̱ iki̱ ta̱ ie̱r buaë ché ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mik Jesús shkémitke, eta̱ wëm debitu̱ eköl tu̱neule, e̱' tkérö kuchë ki̱ ie' wörki̱, ta̱ ie' a̱ ichakéitö: —A s'wöbla'u̱kwak, be' dör buaë, ¿ì wè̱mi ye' tö a̱s se̱ne michoë dö̀ ye' ulà a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ie' tö iiu̱té: —¿Ì kue̱ki̱ be' tö ye' kié buaë? Skëköl eköl ë̀ dör buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ie' ttè dalöiëno e' jche̱r be' wa̱: ‘Kë̀ a' ka̱wö ta̱' s'ttökwa̱, kë̀ a' ka̱wö ta̱' s'se̱newa̱bak dalöse̱u̱kwa̱, kë̀ a' ka̱wö ta̱' akblök, kë̀ a' ka̱wö ta̱' s'kkatök ka̱chè wa, kë̀ a' ka̱wö ta̱' s'ki̱tö'u̱k, a' yë́ ena a' mì e'pa dalöiö́.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wëm ie' iu̱té: —A s'wöbla'u̱kwak, ttè e' ko̱s dalöië'bitu̱ ye' tö ye' ià̱ duladula e'ta̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús ie' sué̱ e̱r bua' wa ta̱ ichéitö: —Íyi etkë̀ kianeia̱ be' a̱ wè̱, e' dör i': Be' yú ta̱ ì tso' be' wa̱, e' wataú̱ttsa̱ se̱raa̱ ta̱ iské múttsa̱ s'sia̱rëpa a̱. E' ukuöki̱ ta̱ be' shkö́ ye' ta̱ ye' ttökataie. Es ta̱ íyi buaë tai̱ë döraë be' ulà a̱ ká̱ jaì a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ie' dör inuköl blu' tai̱ë, e' kue̱ki̱ mik e' ttséitö, eta̱ iwö éwa i̱ski̱ ta̱ imía̱ e̱riane tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús tö ká̱ sué̱ ipamik ta̱ ichéitö ittökatapa a̱: —¡Inuköl blúpa a̱ darërëë idir dökwa̱ ì blúie Skëköl tso' e' a̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ttè e' tö ittökatapa tkiwé̱wa̱, erë ie' tö ie'pa a̱ iskà chéne: —¡A ala'r, darërëë idir dökwa̱ ì blúie Skëköl tso' e' a̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Inuköl blu'pa a̱ dökwa̱ ì blúie Skëköl tso' e' a̱, e' dör darërëë tkö̀ka̱ kameio tkö̀mi datsi' yuo diké ese wöukla a̱ e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mik e' ttsé ie'pa tö, eta̱ ie'pa kí̱ tkinewa̱ tai̱ë ta̱ ie'pa ñì chaké: —E' dör es, e̱'ma ¿yi tsa̱tkërmi? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ie'pa webléitö ta̱ ichéitö: —E' kë̀ o̱nuk s'ditsö a̱ we̱s, erë kë̀ dör es Skëköl a̱, ie' a̱ íyi ulitane o̱rmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro tö ie' a̱ ichémi: —Sa' tö íyi ulitane me'a̱t ta̱ sa' bite̱ be' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús iiu̱té: —Moki̱ ye' tö a' a̱ ichè tö yi tö iu ö iëlpa ö ikutapa ö imì ö iyë́ ö ila'r ö iká̱ méa̱t ye' dalërmik ena ye' tté buaë dalërmik, ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","e' ta̱ ká̱ i' ki̱ ese ulà a̱ iské dörane tai̱ë döka̱ u cien eyök. Es ñies iëlpa ö ikutapa ö imì ö iyë́ ö ila'r ö iká̱ ese döraë iulà a̱ döka̱ cien eyök. Erë ñies iweirdaë sia̱rë ye' tté buaë kue̱ki̱. Erë aishkuö ta̱ se̱ne michoë döraë iulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Erë i̱'ñe ta̱ s'tso' tai̱ë ke̱weie esepa döraë bataie, ena s'tso' bataie i̱'ñe ta̱ esepa döraë ke̱weie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Eta̱ ie'pa mirka̱ ñala̱ ki̱ micho Jerusalén. Jesús shkörami ittökatapa yöki̱ ke̱we. Ittökatapa mir tkirulewa̱ ena pë' mir ie'pa itöki̱ e'pa suane. Ie' ttökatapa dabom eyök kí̱ böl, e'pa kiémiitö bánet ta̱ ì tköraë ie' ta̱ e' pakémiitö ie'pa a̱. Ichéitö: ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Se' mirka̱ Jerusalén i', eta̱ ee̱ ye' dör S'ditsö Alà, e' merdattsa̱ sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa ulà a̱. Ie'pa tö ye' kichateraë ta̱ ye' wömerattsa̱ pë' kë̀ dör judiowak esepa ulà a̱ ttèwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ye' wayueraë ie'pa tö, iwiri tuöraë ye' ki̱, ye' pperarakitö, ena ye' tterawa̱rakitö; erë e' ki̱ ká̱ de mañat eta̱ ye' shke̱rdaka̱ne.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Santiago ena Juan e'pa dör Zebedeo ala'r e'pa dewa̱ Jesús o̱'mik ta̱ ichéitö ia̱: —A s'wöbla'u̱kwak, sa' ki̱ ikiane tö ì kieke sa' tö be' a̱ e' mú sa' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ie' tö ichakérak: —¿Ì kiane a' ki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ie'pa tö iiu̱té: —Mik be' tkëneka̱ s'blúie olo ta̱' tai̱ë, eta̱ ka̱wö mú sa' a̱ e̱' tkökse̱r be' o̱'mik, eköl be' ulà bua'kka, eköl be' ulà bakli̱'kka s'wëttsu̱k be' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ie' tö ie'pa iu̱té: —A' kë̀ wa̱ ijche̱r ì kiök a' tso'. ¿Íyi yeraë ye' tö bacha'bachaë, e' yarmi a' a̱? ¿A' e̱' ché weinuk we̱s ye' weirdaë es? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ie'pa tö iiu̱té: —Tö́, sa' dirmi. Ie' tö iché ia̱: —Ye' tka̱' wà yeraë a' tö. A' weirdaë we̱s ye' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Erë e̱' tkökse̱r ye' ulà bua'kka ö ye' ulà bakli̱'kka, e' kë̀ ké̱wö menuk ye' a̱. E' tso'tke klöule yi a̱ imeke esepa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mik ttè e' ttséwa̱ ittökatapa male̱pa döka̱ dabom eyök (10) e'pa tö, eta̱ ie'pa uluneka̱ Santiago ena Juan ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Erë ie' tö ie'pa kié se̱raa̱ ta̱ ichéitö: —A' wa̱ ijche̱r tö pë' kë̀ tö Skëköl dalöiè, esepa wökirpa ko̱s e̱' alökeka̱ ie'pa ki̱ ke̱kraë, ñies iblúpa tö ie'pa patkeke kësik wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Erë a' kë̀ kàne e̱' wamblök es. E' skéie, a' isie e̱' yuak s'wökirie, ese ka̱wöta̱ e̱' wöökwa s'male̱pa diki̱a̱ diöshe̱t ikanè mésoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ñies a' isie e̱' yuak ibua'ie s'male̱pa tsa̱ta̱, ese ka̱wöta̱ e̱' muktsa̱ s'male̱pa a̱ kanè mésoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ye' dör S'ditsö Alà, e' kë̀ dë'bitu̱ a̱s yi tö ye' ki̱mù, ye' dë'bitu̱ s'ki̱muk ena e̱' muktsa̱ ttèwa̱ s'tso' tai̱ë e' nuì̱ skéie. E' kue̱ki̱ a' ka̱wöta̱ e̱' wöökwa s'male̱pa kanè mésoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ie'pa demi Jericó. Mik Jesús e̱' yökettsa̱tke ittökatapa ta̱ ena pë' dami tai̱ë itöki̱ e'pa ta̱, eta̱ ee̱ wëm eköl sia̱rë tkër ñala̱ ska'. E' dör inuköl kak kiökwak kiè Bartimeo dör Timeo alà, e' wöbla kë̀ wawër. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mik ie' ittsé tö Jesús Nazaret wak damitkö, eta̱ ie' iché a̱neule: —¡A Jesús, s'blú bak David e' aleri, ye' sa̱ú̱ e̱r sia̱rë wa! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tai̱ë pë' tö ie' uñeke a̱s isiwa̱'blö̀wa̱, erë ie' kí̱ a̱rkeka̱: —¡A David aleri, ye' sa̱ú̱ e̱r sia̱rë wa! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Eta̱ Jesús e̱' duése̱r ta̱ ichéitö: —Ie' kiö́ttsa̱. Eta̱ wëm wöbla kë̀ wawër, e' kiéttsa̱ ie'pa tö ta̱ ichérakitö ia̱: —Be' e̱r kuú̱. Be' e̱' kö́ka̱. Ie' tso' be' kiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eta̱ wëm tö ipaio ki̱kke̱ yéttsa̱ ppéu̱mi ta̱ ie' e̱' kéka̱ bet dewa̱ Jesús ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ta̱ Jesús tö ie' a̱ ichaké: —¿Ì kiane be' ki̱ tö ye' tö iwè̱ be' a̱? Ta̱ ie' tö iiu̱té: —A s'wöbla'u̱kwak, ye' ki̱ ikiane tö ye' wöbla buarne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús tö iché ia̱: —Be' e̱rblé ye' mik, e' wa be' buanene. Be' yúne. E' wösha̱ ta̱ ie' wöbla buanene ta̱ imía̱ Jesús ta̱ ñala̱ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mik Jesús ena ittökatapa dökemitke Betfagé ena Betania tso' tsi̱net Jerusalén, Olivo ké̱bata kuli' a̱ ta̱ ee̱ ie' tö ittökatapa kié böl ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ta̱ ichéitö ia̱rak: —A' yú wì̱ u wëne eruleë ee̱. Mik a' demi ee̱, e' bet ta̱ burro pupula moulewa̱ kue̱raë a' tö etö kë̀ ki̱ yi e̱' tkëuleka̱ ese. E' wötsö́ö ta̱ itsú̱bitu̱ ña. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yile tö a' a̱ ichakeke: ‘¿Ì u̱k a' tso'?’, e' ta̱ iiu̱tö́: ‘Skëkëpa ki̱ ikiane’, e' wa ie' tö imène. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Eta̱ ie'pa míyal tö burro ñe' kué̱, motër ukkö a̱ ñala̱ sha̱ë. Iwötsée ie'pa tö tsè̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Eta̱ we̱lepa iëte̱r ee̱ e' tö ichakérak: —¿Ì u̱k a' tso'? ¿Ìie a' tö burro se̱ wötsée? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ittökatapa tö iiu̱té we̱s Jesús tö iché ia̱ es ta̱ ie'pa tö iébitu̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","E' ukuöki̱ ittökatapa wa̱ burro bite̱tse̱r Jesús a̱. Ie'pa tö ipaio ki̱kke̱ méka̱ burro ki̱ ta̱ Jesús e̱' tkéka̱ iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tai̱ë pë' tö ipaio ki̱kke̱ shuélor ñala̱ ki̱, iskà tö kal kö̀ të'lor kañika̱ tsè̱mi ese shuélor ñala̱ ki̱ Jesús ñalé̱ tso̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Pë' mirwa̱ ke̱weie Jesús yöki̱ ñies itöki̱, e'pa ulitane a̱rke tai̱ë: —¡Skëköl ki̱köka̱sö! Yi datse̱ ie' ttö̀ wa, ayëcha buaë e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","E' datse̱ s'wëttsu̱kne s'blúie we̱s se' yë́ David bak es. Ayëcha buaë ie'. ¡Skëköl tso' ká̱ jaì a̱ e' ki̱köka̱sö! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús dewa̱ Jerusalén ta̱ imía̱ dewa̱ Skëköl wé a̱. Ie' tö íyi weblé se̱raa̱. Ká̱ tuirketke, e' kue̱ki̱ imía̱ Betania ittökatapa dabom eyök ki̱ böl, e'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Bule es ta̱ mik ie'pa e̱' yélur Betania, eta̱ Jesús dué bli wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ka̱mië ie' tö higuera klö̀ sué̱ kö̀ arwa̱ buaë. Ie' mía̱ iweblök tö iwö ta̱'. Erë kë̀ ie' wa̱ iwö ku̱ne. Ka̱m iwö ké̱wö döwa̱, e' kue̱ki̱ ikö̀ ë̀ arwa̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ie' tö iché higo klö̀ a̱: —¡Kë̀ yi tö be' wö katepaia̱! E' ttsé ittökatapa tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ie'pa demi Jerusalén ta̱ Jesús dewa̱ Skëköl wé a̱. Ee̱ ie' e̱' kéka̱ wé̱pa tso' íyi ta̱u̱k ena íyi watau̱k e'pa trë'u̱kyal. Inuköl mane'u̱kwakpa mesa trélurka̱itö. Ñies nuböl watau̱kwakpa kula' trélurka̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ñies ie' kë̀ tö yi a̱ ka̱wö mè íyi tsu̱ktkö Skëköl wé shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Eta̱ ie' tö s'wöbla'wé̱mitke ta̱ ichéitö: —Skëköl tö iyë'a̱t iyëkkuö ki̱: ‘Ye' u kirdaë tto ye' ta̱ wé ká̱ ulitane wakpa a̱,’ erë a' tö iia'wé̱ka̱ akblo wéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mik e' ttsé sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa tö, eta̱ ie'pa ileritsémi Jesús ttowa̱ie. Ie' tö s'wöbla'we̱ke e' tö pë' ko̱s tkiwé̱wa̱, e' kue̱ki̱ judiowak wökirpa suane iyöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Erë mik ká̱ tuine, eta̱ ie' e̱' yéttsa̱ Jerusalén ittökatapa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Bule es bla'mi ie'pa tkamine higuera klö̀ o̱'mik, eta̱ ie'pa tö isué̱ tö isinewa̱ dö̀ iwí kicha ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Eta̱ ì bak e' a̱newa̱ Pedro é̱na, e' kue̱ki̱ ie' tö Jesús a̱ iché: —A S'wöbla'u̱kwak, isa̱ú̱ higuera klö̀ wayë'abö e' sinewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús iiu̱té: —A' e̱rblö́ Skëköl mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Moki̱ ye' tö a' a̱ ichè tö yi tö iché ka̱bata wì̱ a̱: ‘¡Be' e̱' skö́ttsa̱ í̱e̱ a̱núwa dayë a̱!’ ta̱ iklö'wé̱itö moki̱ kë̀ ibikeitse̱ka̱ bötböt tö ì chéitö e' wà tköraë, e' ta̱ es iwà tköraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","E' kue̱ki̱ ye' tö a' a̱ ichè tö iklö'ú̱ tö ì kié a' tö Skëköl a̱ e' wà detke a' ulà a̱, eta̱ iwà döraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ñies mik a' tso' ikiök ie' a̱, eta̱ ilè tté tso' a' wa̱ yile ki̱, ese nuí̱ olo'yö́ iki̱ a̱s S'yë́ tso' ká̱ jaì a̱ e' tö a' icha olo'yö̀ a' ki̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","E' ukuöki̱ ta̱ ie'pa dene Jerusalén. Jesús shkö̀dur Skëköl wé a̱. Eta̱ sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa ena judiowak kue̱blupa e'pa de ie' ska' ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ta̱ ichaké ia̱: —¿Yi ttö̀ wa be' tö íyi ikkë we̱ke? ¿Yi tö e' ké̱wö mé be' a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ie' tö iiu̱té: —Ñies ye' tö a' a̱ ilè chakeke, e' iu̱té a' tö, e' ta̱ ye' tö a' a̱ icheke tö yi tö iké̱wö me' ye' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Yi tö Juan patkë' s'wöskuök? ¿Skëköl tso' ká̱ jaì a̱ e' ö s'ditsö? Ye' iu̱tö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ie'pa ñì iu̱témi ta̱ ichekerakitö: “Sö ichèmi tö Skëköl tö ipatkë'bitu̱, e' ta̱ ie' tö se' a̱ ichèmi: ‘¿Ì kue̱ki̱ a' kë̀ wa̱ ie' ttè klöo̱ne?’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pë' ulitane tö iklö'wé̱ tö Juan dör Skëköl tteköl chökle, e' kue̱ki̱ ie'pa suane pë' yöki̱. E' kue̱ki̱ ie'pa tö icheke ñì a̱: ‘Kë̀ se' a̱ iyënuk tö s'ditsö tö ie' patkë'.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","E' kue̱ki̱ ie'pa tö iiu̱té: —Kë̀ sa' wa̱ ijche̱r. Ie' tö ie'pa a̱ iché: —Es ñies ye' kë̀ tö a' a̱ ichepa tö yi tö ye' a̱ ka̱wö mé íyi ikkë wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús tö ttè kleé ie'pa a̱ i' es: “Wëm eköl tö uva kuatké tai̱ë ta̱ ikköiéwa̱itö buaë, ka̱uk biéitö uva diö̀ tuoie. Ñies úla yuéitö ka̱kke̱ë uva kkö'noie. E' ukuöki̱ ta̱ ie' tö ipeitéa̱t wëpa we̱lepa a̱ a̱s ie'pa tö ipataù̱ ie' a̱ iwörke e' kak wa. E' ukuöki̱ ta̱ ie' mía̱ ká̱ bánet. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mik uva wöline tso'tke wë'ià̱ë shtè, eta̱ ie' tö ikanè méso patkémi eköl ie' icha tsu̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Erë ie'pa tö ikanè méso klö'wé̱wa̱ ppé tai̱ë patkémine ulà wöchka. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eta̱ kanè wák tö ikanè méso skà patkémine eköl, erë e' shka̱'wé̱ ie'pa tö iwökir ki̱ ta̱ iché suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","E' ukuöki̱ ta̱ eköl skà patkémine ie' tö ta̱ e' ttéwa̱ ie'pa tö. E' ukuöki̱ ikanè mésopa skà patkémiitö tai̱ë, erë ie'pa tö we̱lepa ppélor we̱lepa ttélur. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Bata ekkë ta̱ ia̱te̱ia̱ eköl ë̀. E' dör iwák alà, e' dalër tai̱ë ie' é̱na. E' patkémiitö ta̱ ie' ibikeitsè: ‘Ye' alà idir, e' kue̱ki̱ ie'pa tö idalöieraë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Erë ie'pa tö iché ñì a̱: ‘Ká̱ i' a̱tdaë ie' wì̱ ulà a̱. Ittöwa̱sö, es ká̱ i' döraë se' ulà a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","E' kue̱ki̱ ie'pa tö iklö'wé̱wa̱ ttéwa̱ ta̱ inú kéu̱mi ie'pa tö uva ké̱ a̱ bánet.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Eta̱ Jesús tö ie'pa a̱ chaké: —¿I̱ma a' ibikeitsè? ¿Ì we̱raë kanè wák tö? Ie' mira kanéu̱kwakpa ttökulur ta̱ uva kané meraneitö pë' kua̱'ki̱ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ye' tté tso' kitule Skëköl yëkkuö ki̱, ¿e' kë̀ su̱ne a' wa̱? E' tö ichè: ‘Ák watéttsa̱ u yuökwakpa tö e' yönene ák bua'buaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","E' kaneo̱' Skëköl tö, ta̱ e' tö s'ttsë'we̱ke buaë, s'tkinewa̱ iweblök.’ Es Skëköl yëkkuö tö ichè. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ie'pa tö isué̱wa̱ tö kleè e' wa Jesús tö ie'pa ché, e' kue̱ki̱ ie'pa é̱na iklö'wa̱kwa̱. Erë ie'pa suane pë' yöki̱, e' kue̱ki̱ ie'pa tö iméa̱t ta̱ iponemi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","E' ukuöki̱ ta̱ ie'pa tö fariseowakpa we̱lepa ena Herodes klépa we̱lepa patkémi Jesús ska'. Ie'pa ki̱ ikiane tö ie' tö ilè chè ikkatoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ie'pa demi ie' ska' ta̱ ichérakitö ia̱: —A s'wöbla'u̱kwak, sa' wa̱ ijche̱r tö ke̱kraë be' ttö̀ moki̱. Be' tö sulitane sue̱ke ñikkëë. I̱ma pë' tö be' cheke e' kë̀ ki̱ be' tkine. E' kue̱ki̱ be' tö s'wöbla'we̱ke yësyësë Skëköl ñalé̱ tté wa. Ichö́ sa' a̱, Roma wökir kibi patuè̱sö ¿e' dör buaë ö kë̀ idör buaë? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Erë ie' tö isué̱wa̱ tö ie'pa e̱' öke e̱r sulu wa, e' kue̱ki̱ ie' tö iché ia̱rak: —¿Ì kue̱ki̱ a' tso' ye' ma'u̱k tsa̱iè? Inuköl wöshki tsú̱bitu̱ ña et suè̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Eta̱ ie'pa tö inuköl wöshki tsé̱mi ie' a̱ et ta̱ ie' tö ichaké ie'pa a̱: —¿Yi diököl ena yi kiè me'rka̱ iki̱? Ie'pa tö iiu̱té: —Roma wökir kibi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Eta̱ ie' tö iché ie'pa a̱: —E̱'ma ko̱s Roma wökir kibi icha, ese mú ie' a̱, ta̱ ko̱s Skëköl icha ese mú ie' a̱. Ie' tö ie'pa iu̱té es, e' tö ie'pa tkiwé̱wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Eta̱ saduceowakpa we̱lepa de Jesús ska'. E' wakpa tö iklö'wé̱ tö s'duowa̱ e' kë̀ shke̱nukka̱ne. Ie'pa tö ie' a̱ ichaké: ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—A s'wöbla'u̱kwak, Moisés tö ttè dalöiëno kita̱t yëkkuö ki̱ e' tö ichè i' es: Wëm blënewa̱ kë̀ alà a̱te̱, e' ta̱ ie' ël ka̱wöta̱ ischö́ tsu̱kwa̱ a̱s ilà kö̀ka̱ iël blënewa̱, e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Etökicha wëpa bak döka̱ kul ñì ëlpa, ikibi alaköl tsé̱wa̱, erë iblënewa̱ kë̀ alà a̱te̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ie' itöki̱ iël tö ischö́ tsé̱wa̱, erë e' ñies blënewa̱ kë̀ alà a̱te̱. E' sù̱ iwamblëne iël ta̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ena imale̱pa ta̱. Ie'pa kul blërulune kë̀ alà a̱te̱ alaköl e' ta̱. Bata ekkë ta̱ ñies alaköl e' blënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wëpa kul e' bak alaköl eköl ë̀ ta̱. Mik s'duowa̱ e' shke̱neka̱ne, eta̱ ¿wé̱ne dö̀mi ie' wëm chö́kie? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ie' tö ie'pa iu̱té: —A' kë̀ wa̱ Skëköl yëkkuö su̱ule, ñies ie' diché kë̀ jche̱r a' wa̱, e' kue̱ki̱ a' wöa̱ ká̱ chowa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mik s'duolur e' shke̱neka̱ne, eta̱ wëpa ena alakölpa kë̀ se̱rpawa̱ia̱ ñita̱. E'pa míyal we̱s Skëköl biyöchökwakpa tso' ká̱ jaì a̱ kë̀ se̱rta̱'wa̱ ñita̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿A' ki̱ kiane jche̱no tö moki̱ s'duowa̱ e'pa shke̱rdaka̱ne? Skëköl ut Moisés ta̱ kal tsir wöñarke bö'ie, e' shu̱a̱, ¿e' pakè kë̀ a̱ritsule a' wa̱ Moisés yëkkuö ki̱? E' ké̱wö ska' ta̱ Skëköl tö iyë': ‘Ye' dör Abraham, Isaac ena Jacob, e'pa Këköl.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","E' wà kiane chè tö ie' kë̀ dör s'duowa̱, e'pa Këköl. ¡Ie' dör s'ttsë'ka, e'pa Këköl! Tai̱ë a' wöa̱ ká̱ chowa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Eta̱ s'wöbla'u̱kwak ttè dalöiëno wa dur eköl ie'pa tso' ñì iu̱tök e' ttsök. Ie' tö ittsé tö Jesús tö ie'pa iu̱té buaë, e' kue̱ki̱ ie' ichaké ia̱: —Skëköl ttè dalöiëno, ¿e' wé̱ne dör ibua'ie imale̱pa tsa̱ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ie' iiu̱té: —Skëköl ttè dalöiëno kibiie imalè̱ tsa̱ta̱ e' dör i': ‘A Israel aleripa, a' tö ittsö́. Këkë dör se' Këköl, e' ë̀ dör Skëköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","E' dalëritsö́ a' e̱r ko̱s wa ena a' wák ko̱s wa ena a' e̱rbikè ko̱s wa ena a' diché ko̱s wa.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","E' itöki̱ e' dör i': ‘A' male̱pa dalëritsö́ we̱s a' wákpa e̱' dalër es.’ Kë̀ ttè ta̱' dalöiëno tkö̀ka̱ ttè böt e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Eta̱ s'wöbla'u̱kwak ttè dalöiëno wa, e' tö iché ia̱: —A s'wöbla'u̱k, be' iu̱té buaë. Ì ché be' tö e' dör moki̱. Skëköl dör eköl ë̀me. Kë̀ e' skà ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ñies s'ka̱wöta̱ ie' dalëritsök se' e̱r ko̱s wa ena se' ka̱bikeitsö̀ ko̱s wa, ena se' diché ko̱s wa, ñies s'ka̱wöta̱ s'male̱pa dalëritsök we̱s se' wák e̱' dalër es. E' wé̱sö, e' ta̱ e' dör buaë se' a̱ tkö̀ka̱ iyiwak jchëule ña'wè̱ wa'ñe ena iyiwak jchëule skà mèsö Skëköl a̱ e' ko̱s tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mik ie' isué̱ tö s'wöbla'u̱kwak ttè dalöiëno wa, e' tö ie' iu̱té buaë yësyësë, eta̱ ie' tö iché ia̱: —Ì blúie Skëköl tso' e' o̱'mik tsi̱net be' tso'. Eta̱ kë̀ yi kësik dë'ka̱ia̱ ie' a̱ ì skà chakök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús tso' ie'pa wöbla'u̱k Skëköl wé a̱ ta̱ ie'pa a̱ ichakéitö: —¿We̱s s'wöbla'u̱k ttè dalöiëno wa wakpa tö ichèmi tö wé̱ pairine'bitu̱ idi' wa s'blúie, e' dör s'blú bak kiè David e' aleri? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Erë David wák tö iyë' Wiköl Batse'r wa i' es: ‘Skëköl tö ichè ye' Këköl a̱: Be' e̱' tkö́se̱r ye' ulà bua'kka dalöiëno tai̱ë, dö̀ mik ye' tö be' bolökpa mérö be' klö̀ diki̱a̱ eta̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Wé̱ pairine'bitu̱ idi' wa s'blúie e' dör David aleri, e' ta̱ ¿we̱s e' kièmi David tö ie' Këköl? Eta̱ pë' tso' tai̱ë, e'pa tö Jesús ttö̀ ttseke e̱r bua' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús tö s'wöbla'we̱ke e' shu̱a̱ ie' tö iché: “A' e̱' kkö'nú s'wöbla'u̱k ttè dalöiëno wa wakpa yöki̱. Ie'pa wöbatsö shkök datsi' batsì̱ë ese mik wé̱ pë' tso' tai̱ë ese ska' a̱s pë' tö ie'pa shke̱'ù̱ we̱s këkëpa dalöiërta̱' tai̱ë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ñies se' ñì dapa'wo̱ wé a̱ ena wé̱ ie'pa ka̱wö tkö'we̱kerakitö, ese ska' kula' tso' këkëpa dalöiërta̱' esepa a̱, ese yuleke ie'pa tö e̱' tkoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ie'pa tö alakölpa schö́ u yeta̱'ttsa̱ iulà a̱, eta̱ ittökerak S'yë́ ta̱ braraë sulitane wöwa idiki̱ñoie tö ie'pa dör pë' buaë yësyësë. Ie'pa weirdaë sia̱rë s'male̱pa tsa̱ta̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Etökicha ta̱ Jesús tkër kalkuö tso' inuköl ioie mè Skëköl a̱ e' wösha̱ pë' tso' inuköl iök kalkuö a̱ e' sa̱u̱k. Inuköl blúpa tso' tai̱ë esepa tö inuköl ieke tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","E' wösha̱ë ta̱ alaköl sia̱rë dör schö́ debitu̱ eköl, e' tö inuköl wöshkila yöule cobre wa tuè̱ tottola ese iéwa̱ böt kalkuö ek a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús tö ittökatapa kié ta̱ ichéitö ia̱: —Moki̱ ye' tö a' a̱ ichè tö alaköl sia̱rëla dör schö́ wí̱ tö inuköl iéwa̱ kibiie imale̱pa tö iié ko̱s e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ie'pa ulitane tö inuköl kuö̀ a̱te̱ ese ié, erë ie' sia̱rë, e' tö ie' wa̱ itso' se̱noie e' ko̱s méttsa̱. E' kue̱ki̱ ye' tö ie' ché es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mik Jesús e̱' yéttsa̱ Skëköl wé a̱, eta̱ ittökata eköl tö iché ie' a̱: —¡A s'wöbla'u̱k, isa̱ú̱! U bua'buaë yöule ák bua'buaala wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ie' iiu̱té: —U ko̱s tso' bua'buaë sué̱ a' tö í̱e̱, e' olordawa̱ se̱raa̱, iékwö ë̀ kë̀ a̱tpa ñì bata ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","E' ukuöki̱ ta̱ ie'pa míyal ka̱bata kiè Olivo tkërka̱ Skëköl wé wösha̱ë ee̱. Jesús e̱' tkése̱r ta̱ Pedro, Santiago, Juan ena Andrés e'pa tö ie' a̱ ichaké bánet: ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ichö́ sa' a̱: ¿mik íyi ekkë wamblërmi? ¿Ì wa sö isuè̱mi tö iwamblërketke?” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Ie' iiu̱té: “Tai̱ë pë' datse̱ e̱' chök tö ie'pa dör ye'. Icherarakitö: ‘Ye' dör wé̱ pairine'bitu̱ idi' wa s'blúie e'’, ta̱ pë' ki̱terarakitö tai̱ë. E' kue̱ki̱ a' tso' wösh wa a̱s kë̀ yi tö a' ki̱tö'ù̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Mik a' tö ibiyö́ ttsé tö ká̱ tai̱ë wakpa ñippöke tai̱ë wì̱ a̱ dià a̱, eta̱ e' kë̀ tö a' tkiu̱k. E' wake' tköraë, erë ká̱ i' e̱rwami e' kianeia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ká̱ kua̱'ki̱ kua̱'ki̱ wakpa ñippöraë ñita̱. Ñies í̱ tö ká̱ wöti̱'we̱raë ká̱ wa'ñe. Ñies ká̱ tseë wakpa tteraë bli tö tai̱ë. Íyi ekkë dör e̱rpa s'tsá̱ weirketke ka̱m ye' döne e' yöki̱ ese. E' dör we̱s alaköl alà ku̱rketke ta̱ ikirirke es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“A' e̱' kkö'nú. A' merdattsa̱ s'shu̱lökwakpa a̱ ta̱ a' burdaë sia̱rë judiowak ñì dapa'wo̱ wé a̱. Ie'pa tö a' keraë e̱' duökse̱r shu̱lè s'wökirpa ena s'blúpa wörki̱ ye' tté kue̱ki̱. Es a' tö ye' tté pakeraë ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Erë ka̱m ká̱ i' e̱rwa e' yöki̱ ye' tté buaë e' ka̱wöta̱ pakè ká̱ ulitane wakpa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mik a' menettsa̱ ttè shu̱lökwakpa a̱, eta̱ kë̀ a' tkinuk i̱ma a' e̱' tsa̱tkö̀mi. Mik e' ké̱wö de, eta̱ kë̀ a' ttö̀pa a' wákpa e̱r wa, e' skéie Wiköl Batse'r ttöraë a' wa. E' kue̱ki̱ ttè eraë Skëköl tö a' a̱ chè e' chö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Eta̱ we̱lepa tö iël wömerattsa̱ ttèwa̱, iyë́ tö ilà wömerattsa̱, ñies ala'r e̱' köraka̱ iyë́ ena imì kkatök a̱s ittö̀wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sulitane tö a' sue̱raë suluë ye' ttè kue̱ki̱. Erë yi e̱' tkéwa̱ darërëë döka̱ bata ekkë, esepa tsa̱tkërdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Íyi sulusi tö ì dör batse'r ia'wè̱ ñáie e' tkërdaka̱ wé̱ kë̀ ika̱wöta̱ tkèka̱ ee̱ (yi tso' yëkkuö i' sa̱u̱k, e' é̱na iwà a̱nú). Mik e' sué̱ a' tö, eta̱ wé̱pa se̱rke Judea e'pa tkö́yalmi ka̱bata a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yi tso' u bata ki̱ ese kë̀ dökwa̱ne we̱shke̱ iíyi yöktsa̱, itkö́shkarmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ñies yi tso' kaneblök kañika̱ ese kë̀ dökwa̱ne we̱shke̱ idatsi' yöktsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","E' ké̱wö ska' ta̱ alakölpa alà ku̱rketke ena alakölpa tsu' muke ilà a̱ ¡wëstela i̱na esepa ta̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","S'ditsö weirdaë tai̱ë shu̱te̱ ko̱s kë̀ s'we'ikule ekkë mik ká̱ yö' Skëköl tö dö̀ ikkë ta̱, ñies ko̱s kë̀ s'weirpa aishkuö ta̱ ekkë. E' kue̱ki̱ ikiö́ Skëköl a̱ a̱s kë̀ e' wamblër a' ta̱ yuëdiö ké̱ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","E' ké̱wö kë̀ wöö́pawa Skëköl tö, e̱'ma kë̀ yi isie a̱tu̱kia̱ ttsë'ka. Erë e' ké̱wö wöerawaitö, wé̱pa shu̱kitbakitö esepa dalërmik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","“Ka̱chökwakpa e̱' köraka̱ e̱' chök tö ie'pa dör wé̱ pairine'bitu̱ idi' wa s'blúie e' ö ie'pa dör Skëköl tteköl we̱le. E'pa tö ì kë̀ o̱r yi a̱ ese we̱raë s'ki̱tö'wo̱ie tö ie'pa ttè dör moki̱ë. Dö̀ wé̱pa shu̱kit Skëköl tö, esepa ki̱tö'wè̱mi e' mú ki̱tërmi e̱'ma. E' kue̱ki̱ yile tö iché a' a̱: ‘Isa̱ú̱, wé̱ pairine'bitu̱ idi' wa s'blúie e' dur í̱e̱’, ö ‘Isa̱ú̱, idur wì̱e̱’, e' ta̱ kë̀ a' tö iklö'wa̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡A' tso' e̱rki̱! Íyi ekkë biyö́ chétkeyö a' a̱ ke̱weie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Erë s'weine e' ké̱wö tka, eta̱ diwö wötuirdawa̱, ñies si'wö kë̀ wöñarpaia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Bëkwö darolordaë ena ì ko̱s tso' ká̱ jaì a̱ e' wöti̱rdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Eta̱ ye' dör S'ditsö Alà, e' datse̱ mò a̱ diché ta̱' tai̱ë olo ta̱' tai̱ë, e' wërdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Skëköl biyöchökwakpa patkeramiyö wé̱pa shu̱kitbakyö, esepa dapa'u̱kka̱ ek tsi̱ní ë̀me. Ie'pa tö iyuleraë ká̱ wa'ñe dö̀ wé̱ ká̱ i' bata e̱rkerö ee̱ ena wé̱ ká̱ jaì bata e̱rkerö ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“A' e̱' wöbla'ú̱ ttè ikkë wa iwà sa̱ú̱ higo klö̀ wa: Mik iulatska tso' ulölöla ena e̱rpa iköyök tskirdoka̱, eta̱ a' wa̱ ijche̱r tö duas dewa̱tke tsi̱net. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Es ñies mik a' tö isué̱ tö íyi ekkë wamblërke, eta̱ a' wa̱ ijche̱nú tö ye' datskene, e' diwö dewa̱tke tsi̱net. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Moki̱ ye' tö a' a̱ ichè tö íyi ekkë wamblërdaë wé̱pa dör we̱s a' es esepa ka̱m e̱rwa e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ka̱shu̱k ena ká̱ i' e̱rdawa, erë ye' ttè michoë e' kë̀ e̱rpawa yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Erë e' ké̱wö e' diwö kë̀ jche̱r yi wa̱. Skëköl biyöchökwakpa tso' ká̱ jaì a̱, e'pa kë̀ wa̱ ijche̱r, ñies ye' dör Skëköl Alà e' kë̀ wa̱ ijche̱r. S'yë́ ë̀ wa̱ ijche̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“A' kë̀ wa̱ ijche̱r we̱kkë ta̱ idiwö de, e' kue̱ki̱ a' tso' e̱rki̱, a' se̱nú wösh wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","E' dör we̱s wëm eköl mi'kea̱ ka̱mië ká̱ kua̱'ki̱ a̱ es. Ie' tö iché ikanè mésopa a̱: ‘U kkö'nú ña.’ Eta̱ kanè tuléa̱titö ie'pa bik ekkë a̱. Ie' tö iché ie' ká̱ wékkö kkö'nukwak a̱: ‘Be' tso' wösh wa.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Es ñies a' tso' e̱rki̱. A' kë̀ wa̱ ijche̱r mik ye' dör we̱s u wák es e' dotkene. Ye' dömibitu̱ ká̱ tuinetke ekkë alè, ká̱ sha̱böts alè, dakro a̱ne ekkë alè ö ká̱ ñine alè ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","A' tso' wösh wa dö' a' kuè̱wa̱yö kapè a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ttè chéyö a' a̱, e' chekeyö sulitane a̱: ¡A' tso' wösh wa!” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ká̱ böt ë̀ kianeia̱ Judiowak Yë́pa Yërulune Egipto e' ké̱wö tkö'wo̱ie. Ñies e' ké̱wö ska' ta̱ Pan Kë̀ Yöule Iwölöwo̱ka̱ Wa e' ké̱wö tkö'we̱ke judiowak tö. Sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa tö Jesús aleritsé ki̱tö'wè̱ iklö'wo̱wa̱ ttèwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ie'pa we̱lepa tö iché: —Kë̀ sö wamblö̀ Se' Yë́pa Yërulune Egipto e' ké̱wö a̱ a̱s pë' kë̀ shu̱ti̱rka̱. E' kue̱ki̱ ie'pa é̱na iklö'wa̱kwa̱ iki̱tè wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús minea̱ Betania, Simón kiri'u̱k lepra bak, e' u a̱. Ie' tkëria̱ mesa ki̱, e' dalewa alaköl debitu̱ eköl e' wa̱ kiö̀ masmas kiè nardo ese chökle tuè̱ darërë, ese debitu̱. Kiö̀ e' ukkuö yöule ák kiè alabastro e' wa. Kiö̀ ukkuö kuli' pé̱wa̱itö ta̱ itéka̱ Jesús wökir ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","We̱lepa uluneka̱ ie' ki̱ ta̱ iñi a̱ ichérak: —¿Ì kue̱ki̱ alaköl tö kiö̀ we'ikéwa? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ituè̱ darërë döka̱ s'kaneblö̀ duas ek ské ekkë. Iwato̱rmittsa̱ s'sia̱rëpa ki̱moie. Eta̱ suluë ie'pa tö alaköl e' paké. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Erë Jesús tö iché: —Imúa̱t bë̀rë. ¿Ì kue̱ki̱ a' itsiriwe̱ke? Íyi buaë kanewé̱ ie' tö ye' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","S'sia̱rëpa tso' ke̱kraë a' shu̱a̱, eta̱ e'pa ki̱mèmi a' tö mik a' ki̱ ikiane e' ta̱. Erë ye' kë̀ ku̱' ke̱kraë a' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ie' tö iwé̱ ye' a̱ ko̱s ie' a̱ io̱r ekkë. Ie' kiö̀ té ye' ki̱ ye' kanéwo̱ie ka̱m ye' nu wötërwa̱ e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Moki̱ ye' tö a' a̱ ichè tö ká̱ wa'ñe wé̱ Skëköl ttè buaë pakarke ee̱ ipakardaë ñies tö ie' tö ì buaë o̱' ye' a̱. Es e' kë̀ chöpawa yi é̱na. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jesús ttökatapa dabom eyök kí̱ böl, e' eköl dör Judas Iscariote, e' mía̱ sacerdotepa wökirpa ska' ichök tö ye' a̱ Jesús mermittsa̱ a' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mik e' ttsé ie'pa tö, eta̱ ittsë'nerak buaë ta̱ ikablé ie' a̱ inuköl muk. Eta̱ ie' tö ka̱wö yulémi bua'iewa̱ Jesús wömottsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ka̱wö kiè Pan Kë̀ Yöule Iwölöwo̱ka̱ Wa e' ké̱wö tsá̱ diwö dewa̱tke E' diwö wa ie'pa obeja pupula jcheke Judiowak Yë́pa Yërulune Egipto, e' ké̱wö tkö'wo̱ie. Eta̱ Jesús ttökatapa tö ie' a̱ ichaké: —¿Wé̱ be' ki̱ kiane tö sa' mi' ka̱wö tkö'we̱kesö e' chké kanéu̱k be' a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ie' tö iché ie'pa böl a̱: —A' yú Jerusalén. Mik a' demi ee̱, eta̱ wëm kue̱raë a' tö eköl, e' wa̱ di' dami ska̱u̱ña a̱. E' itöki̱ a' yú. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ta̱ u wé̱ a̱ ie' demi e' wák a̱ ichö́: ‘S'wöbla'u̱kwak be' chakök ké: ¿Úshu̱ wé̱ a̱ ie' tö ka̱wö tkö'we̱kesö e' chké ñèmi ie' ttökatapa ta̱?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ie' tö úshu̱ bërie tso' ká̱kke̱ tso'tke kaneo̱ule buaë, e' kkacheraë a' a̱. Ee̱ ichké kaneú̱ se' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Eta̱ ie'pa böl míyal Jerusalén ta̱ íyi ulitane kué̱rakitö we̱s ie' tö iché es. Ee̱ chkè kanewé̱rakitö ka̱wö tkö'wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mik ká̱ tuine, eta̱ ie' debitu̱ ittökatapa dabom eyök kí̱ böl, e'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mik ie'pa e̱' tulése̱r chkök, eta̱ ie' tö iché ie'pa a̱: —Moki̱ ye' tö a' a̱ ichè tö a' eköl tö ye' wömerattsa̱. E' wák tso' ye' ta̱ chkök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Eta̱ ie'pa e̱rianeka̱ tai̱ë ta̱ ie'pa tö ie' a̱ ichakémi eköl eköl: —¿Ye' alè idir? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ie' tö iiu̱té: —E' dör a' dabom eyök ki̱ böl tso' ye' ta̱ pan nuu̱k tka̱' etkë̀ a̱ ñè, e' eköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ye' dör S'ditsö Alà e' ta̱ itköraë we̱s itso' kitule Skëköl yëkkuö ki̱ es. Erë wëstela i̱na yi ye' wömekettsa̱ e' ta̱. ¡Buaë idir wëm e' a̱ tö kë̀ iku̱núpa! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ie'pa tso'ia̱ chkök, e' shu̱a̱ pan klö'wé̱itö, e' ki̱ wëstela chéitö Skëköl a̱ ta̱ iblatéitö watié ie'pa a̱ ta̱ ichéitö: —Pan se̱ dör ye' chkà, e' ñú a' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","E' ukuöki̱ tka̱' a̱ vino tso', e' klö'wé̱itö, e' ki̱ wëstela chéitö Skëköl a̱ ta̱ ie'pa ulitane tö tka̱' e' wayé. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ie' tö iché ie'pa a̱: —Vino se̱ dör ye' pë́. Ye' tterawa̱ e' pë' tërdaë tai̱ë, e' wa ttè pa̱'a̱li̱ me' Skëköl tö, e' wà de. E' wa pë' tai̱ë tsa̱tkërdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Moki̱ ye' a' a̱ ichè tö vino kë̀ yepaia̱yö dö̀ mik ì blúie Skëköl tso' e' ké̱wö de eta̱. Mik ide, eta̱ iskà yeraneyö a' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eta̱ ie'pa tö Skëköl ttseittsé, e' ukuöki̱ ta̱ ie'pa míyal Olivo ké̱bata a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús tö iché ie'pa a̱: —A' ulitane tköyaldaë. A' ye' mea̱tdaë ekörla. E' dör we̱s itso' kitule Skëköl yëkkuö ki̱ es, e' tö ichè: ‘Obeja kkö'nukwak ttewa̱raëyö, eta̱ obeja pordami wì̱ a̱ dià a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Erë mik ye' ttéwa̱ shke̱neka̱ne, e' ukuöki̱ ta̱ ye' miraë Galilea a' yöki̱ ke̱we. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro tö ie' a̱ iché: —Erë́ ie'pa ulitane be' memia̱t ekörla, erë ye' kë̀ tö be' mepaa̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ie' iiu̱té: —Moki̱ ye' tö be' a̱ ichè tö i' nañewe, ka̱m dakro skà a̱rne, e' yöki̱ be' tö icheraë mañatökicha tö be' kë̀ wa̱ ye' su̱ule. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Erë Pedro tö ikí̱ ché ia̱ kröröë: —Erë́ ye' ttèwa̱mirakitö be' ta̱, erë kë̀ ye' ichepa tö kë̀ ye' wa̱ be' su̱ule. Eta̱ ie'pa ulitane ttöke es ë̀me. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","E' ukuöki̱ ta̱ ie'pa míyal ká̱ kiè Getsemaní ee̱. Jesús tö iché ittökatapa a̱: —A' a̱te̱ tulur í̱e̱, ye' mía̱ ttök S'yë́ ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pedro, Santiago ena Juan e'pa mítse̱r iwa̱ e̱' ta̱. Eta̱ ie' e̱rianemi chkenewa̱mi tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ie' tö iché ie'pa a̱: —Ye' e̱riane tai̱ë ttsëskua ye' ttèwa̱miitö ekkë. A' e̱' tsú̱a̱t í̱e̱, kë̀ a' kapökwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","E' ukuöki̱ ie' mía̱ wi̱shke̱ ta̱ ie' e̱' kéu̱tër wöwakköt i̱ski̱ ta̱ ikiéitö Skëköl a̱ tö ì tköraë ie' ta̱, e' diwö tköa̱mi ie' ki̱, e' ta̱ itköú̱u̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ie' ichè: “A yë́wöla, íyi ulitane o̱rmi be' a̱. Ì tköraë ye' ta̱ e' dör we̱s íyi bacha'bachaë yèwasö es. E' ulà a̱ ye' yö́ttsa̱. Erë kë̀ iwa̱r we̱s ye' ki̱ ikiane es, iú̱ we̱s be' ki̱ ikiane es.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","E' ukuöki̱ ta̱ ie' dene wé̱ ittökatapa tulur ee̱ ta̱ ie'pa kué̱itö kapö̀tulur. Ie' tö iché Pedro a̱: —A Simón, ¿be' kapowa̱? ¿Kë̀ be' wa̱ kapèwa̱ wöklöne dö̀ hora ek ë̀? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kë̀ a' kapökwa̱. A' ikiö́ Skëköl a̱ a̱s ì sulu tö a' e̱rkiöwe̱ke ese kë̀ e̱' alö̀ka̱ a' ki̱. Moki̱ a' é̱na ì buaë wa̱k, erë a' diché kë̀ dë'ka̱ iwà u̱k, e' kue̱ki̱ a' a̱ darërëë idir. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ie' mía̱ne ta̱ tté Skëköl a̱ we̱s ke̱we itté es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mik ie' dene ta̱ ie'pa kué̱neitö kapö̀tulur; ie'pa wöbla surirkewa kapè wa̱ e' kue̱ki̱. Ie'pa kë̀ wa̱ ttè ku̱ne ie' iu̱toie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ie' skà mía̱ne ttök S'yë́ ta̱ e' dene, i' ta̱ idare mañatökicha, eta̱ ie' tö iché ia̱rak: —¿A' kapö̀tuluria̱ e̱nukeia̱? Wë' a' kapowa̱. Ye' dör S'ditsö Alà, e' diwö deka̱tke mèttsa̱ pë' sulusipa ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","A' e̱' kö́ka̱, yi tö ye' wömekettsa̱, e' dotke i' ta̱. Mishka ie' panuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús tso'ia̱ ttök, e' dalewa ittökatapa dabom eyök ki̱ böl, e' eköl kiè Judas, e' debitu̱ pë' ta̱ tai̱ë. E' wakpa debitu̱ tabè ki̱ ena kal wölö ki̱. Ie'pa patkë'mi sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa ena judiowak kue̱blupa ekkëpa tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas dör iwöméttsa̱ e' tö ie'pa a̱ iyë'bak: “Wé̱ shke̱'wé̱yö wöalattsè wa, e' dör ie', iklö'ú̱wa̱ a' tö ta̱ itsú̱mi kkö'naule buaë a̱s kë̀ itköshkar.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Eta̱ ie' e̱' skéwa̱ Jesús o̱'mik ta̱ iché ia̱: —¡A S'wöbla'u̱kwak! Ta̱ iwöalattséwa̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eta̱ Jesús klö'wé̱wa̱ pë' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Erë ie'pa iëte̱r ee̱, e' eköl tö itabè yéttsa̱ ta̱ e' wa sacerdote kibi e' kanè méso kukuöña téttsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Eta̱ Jesús tö ichaké pë' ekkëpa a̱: —¿Ì kue̱ki̱ a' bite̱ ye' klö'u̱kwa̱ tabè ki̱ kal wölö ki̱ we̱s akblökwakpa klö'wè̱wa̱ es? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ke̱kraë ye' bak a' shu̱a̱ s'wöbla'u̱k Skëköl wé a̱, erë a' kë̀ wa̱ ye' klöo̱newa̱. Erë i' tköke a̱s itkö̀ we̱s itso' kitule Skëköl yëkkuö ki̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Eta̱ ittökatapa ko̱s tkayalmi tö iméa̱t ekörla. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Erë duladula eköl dowa̱ ie' itöki̱ e̱' patréwa̱bitu̱ ka̱' ki̱shuo wa, e' klö'wé̱wa̱rakitö, ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","erë idatsi' ppéea̱titö wak tkashkarmi sume. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesús tsé̱mirakitö sacerdote kibi ska'. Eta̱ ee̱ sacerdotepa wökirpa male̱pa ena judiowak kue̱blupa ena s'wöbla'u̱k ttè dalöiëno wa wakpa ko̱s daparke. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro datse̱ ie'pa itöki̱ ka̱mië döttsa̱ sacerdote kibi u pamik, eta̱ ee̱ ie' e̱' tsé̱a̱t tkër Skëköl wé shkëkipa ta̱ bö' baiklök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Eta̱ sacerdotepa wökirpa ena judiowak wökirpa male̱pa tö ttè yuleke Jesús kkatoie a̱s ie'pa tö iwömùttsa̱ ttèwa̱, erë kë̀ ie'pa wa̱ ì ttè ku̱ne ikkatoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tai̱ë pë' de ie' kkatök ka̱chè wa, erë ie'pa ttè kë̀ dë'ttsa̱ ñittsëë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","We̱lepa tö ie' kkatémi ka̱chè wa ta̱ ichérakitö: ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Sa' tö ie' ttsë'wa̱ ichök tö Skëköl wé yö' s'ditsö tö i', e' olo'yerawa̱itö ta̱ iské, kë̀ yöne s'ditsö wa̱, ese yuéraka̱neitö ká̱ mañat shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Erë ie'pa ttè kë̀ dë'ttsa̱ ñittsëë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Eta̱ sacerdote kibi e̱' kéka̱ iyamipa shu̱a̱, ta̱ Jesús a̱ ichakéitö: —¿Kë̀ be' ie'pa iu̱teku̱' yës? ¿Ñe' ie'pa be' kkateke, e' dör ì? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Erë Jesús siwa̱'bléwa̱ ie'pa yöki̱, kë̀ ie' wa̱ ì iu̱tëne. Sacerdote kibi ie' skà chaké: —¿Be' dör wé̱ pairine'bitu̱ idi' wa sa' blúie e'? ¿Be' dör Skëköl ki̱kauleka̱ tai̱ë e' Alà? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús ie' iu̱té: —Tö́, ye' idir. Ye' dör S'ditsö Alà e' sue̱raë a' tö tkërka̱ Skëköl diché ta̱' íyi ulitane tsa̱ta̱ e' ulà bua'kka dalöiërta̱' tai̱ë. Ñies ye' datskene ka̱shu̱k a̱ mò a̱ e' sue̱raë a' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Eta̱ sacerdote kibi e̱' datsi' jchée ikkachoie tö iluneka̱ ta̱ ichéitö: —¿Ìie se' ki̱ ikkatökwakpa ki̱ kiarmiia̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","A' ittsé tö ie' e̱' chö̀ tö ie' dör Skëköl Alà, e' wa ie' tso' Skëköl chök suluë. ¿We̱s a' iwe̱ke? Ie'pa ulitane ñì sini'kué̱ tö ie' ia̱ne iwiie, e' kue̱ki̱ ika̱wöta̱ ttèwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ie'pa we̱lepa wirituémi iki̱ ñies iwöbla pabakéwa̱rakitö ta̱ itérakitö ta̱ ichakérakitö: —Be' dör Skëköl tteköl, e̱'ma sa' a̱ ichö́ka̱ ¿yi tö be' té? Eta̱ Skëköl wé shkëkipa tö ippé iwö ki̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro tkëria̱ i̱ski̱ u pamik, e' dalewa tayëla debitu̱ e' dör sacerdote kibi e' kanè méso eköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ie' Pedro sué̱ bö'iklök, ta̱ isué̱itö krereë ta̱ ichéitö ia̱: —Be' ñies dör Jesús Nazaret wak e' klé eköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro tö iblé. Ie' tö iché: —Kë̀ ye' wa̱ ie' su̱ule. Ye' kë̀ é̱na ia̱ne tö ì chök be' tso'. Eta̱ ie' e̱' yéttsa̱ ukkö a̱. E' wösha̱ë dakro a̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kanè méso ñe' tö Pedro sué̱ne ta̱ ie' e̱' kéka̱ ichök imale̱pa a̱: —Ie' i' dör Jesús klépa e' eköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Erë Pedro tö iskà bléne. E' kuölö ta̱ wé̱pa tso' ee̱ ñies e'pa tö iché ie' a̱: —Be' dör Galilea wak, e' kue̱ki̱ moki̱ be' dör ie'pa ëltë wak. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ie' tö iché: —¡Skëköl wörki̱ ye' ichè tö wëm chök a' tso' e' kë̀ su̱ule ye' wa̱! Kë̀ idör es, e̱'ma a̱s ye' kichatër. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","E' wösha̱ë ta̱ dakro a̱ne etökichane, ta̱ ie' é̱na ia̱newa̱ tö Jesús tö ie' a̱ iyë': ‘Ka̱m dakro skà a̱rne e' yöki̱ be' icheraë mañatökicha tö be' kë̀ wa̱ ye' su̱ule.’ Eta̱ ie' i̱é̱ka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mik ká̱ ñine, eta̱ sacerdotepa wökirpa ena judiowak kue̱blupa ena s'wöbla'u̱k ttè dalöiëno wa wakpa ñì dapa'wé̱ka̱ ta̱ Jesús aleritsétke. Ie'pa wa̱ imítse̱r moulewa̱ mé Pilato a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato tö ichaké ie' a̱: —¿Be' dör judiowak blú? Ie' iiu̱té: —Tö́, we̱s be' iché, e̱'ma es idir. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sacerdotepa wökirpa tö ie' kkaté tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Eta̱ Pilato tö iskà chakéne: —Ñekkë ie'pa be' kkaté ¿e' ttsébö? ¿Ì kue̱ki̱ e' kë̀ iu̱tèbö? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Erë ie' kë̀ wa̱ iiu̱tëne, e' tö itkiwé̱wa̱ darërëë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Judiowak Yë́pa Yërulune Egipto e' ké̱wö wa Pilato wöblar s'wötëulewa̱ s'wöto wé a̱ ese yöktsa̱ eköl émine wé̱ kié pë' tö e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wëm kiè Barrabás e' tso' wötëulewa̱ s'wöto wé a̱ imale̱pa sulusipa ta̱. Ie'pa wa̱ s'kötulewa̱ mik ie'pa e̱' ka'ka̱ ñippök romawakpa ta̱ eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ta̱ pë' debitu̱ Pilato ska' e'pa tö ikié ie' a̱ tö iú̱ we̱s iwöblar es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Ie' tö isué̱wa̱ tö ukyëne wa sacerdotepa wökirpa tö Jesús me'ttsa̱ ie' ulà a̱. E' kue̱ki̱ ie' tö ichakérak ia̱: —A' judiowak blú ¿e' èmineyö? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Erë sacerdotepa wökirpa tö pë' shu̱ti̱wé̱ka̱tke a̱s ie'pa tö kiö̀ Pilato a̱ tö Barrabás yö́ttsa̱ Jesús skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato tö ichakéne: —Eta̱ ¿we̱s a' ki̱ kiane tö ye' tö wëm kiè a' tö judiowak blú e' wè̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ie'pa iiu̱té a̱neule: —¡Iwötö́wa̱ krus mik! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ie' tö ichaké ie'pa a̱: —¿Ì kue̱ki̱? ¿Ì sulu wambléitö? Erë ie'pa kí̱ a̱rke: —¡Iwötö́wa̱ krus mik! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ie' a̱ta̱k buaë ie'pa ta̱, e' kue̱ki̱ Barrabás yéttsa̱itö. Eta̱ Jesús ppök patkémiitö ttsa' bata daloie wa. E' ukuöki̱ ta̱ ie' tö iméttsa̱ wötèwa̱ krus mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Eta̱ iñippökwakpa wa̱ Jesús mítse̱r ká̱ e' wökir u kiè Pretorio e' shu̱a̱ wé̱ ulat tso' áie ee̱. Ee̱ ie'pa tö iñippökwakpa male̱pa kiéttsa̱ dapa'wè̱ ek tsi̱ní ë̀me. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ie'pa tö datsi' mat daloshdalosh ese iéka̱ Jesús ki̱ blu'ie. Ñies dika'kicha yuérakitö wöshkiie tkéka̱rakitö iwökir ki̱ blu'ie iwayuoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","E' ukuöki̱ ta̱ ie' wayuémirakitö a̱neule: —¡Be' dör judiowak blú! ¡Be' ki̱kökka̱ sa' tso'! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eta̱ ippémirakitö tai̱ë iwökir ki̱ kuaköl wölö wa ena iwiri tuérak iki̱ ena ie' e̱' tulése̱rak kuchë ki̱ iwörki̱ iwayuök tö sú̱ sa' be' dalöiè. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mik iwayué o̱ne, eta̱ datsi' mat daloshdalosh, e' yéttsa̱rakitö ta̱ iwák datsi' iéka̱nerakitö iki̱ ta̱ imítse̱rak iwa̱ wötèwa̱ krus mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ñippökwakpa tö wëm kiè Simón dör Cirene wak, e' kué̱ ñala̱ ki̱, e' datse̱ bánet micho Jerusalén. Ie' dör Alejandro ena Rufo yë́. Ie' ké ie'pa tö Jesús krus tsu̱kmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ie'pa wa̱ Jesús mítse̱r ká̱ kiè Gólgota ee̱. (Gólgota e' wà kiane chè s'wökirdiche.) ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Eta̱ vino shu̱tuule kapöli kiè mirra e' wa, ese mé Jesús a̱ yè, erë kë̀ ie' wa̱ iyanewa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eta̱ iwötérakitö krus mik. E' ukuöki̱ ta̱ ie'pa iné ñì ma'wo̱ie suè̱ tö we̱s ie'pa tö Jesús datsi' blatemi ñì a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mik ie'pa tö iwötéwa̱ krus mik, eta̱ diwö de su̱li̱tu (9). ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kaltak tso' e' ki̱ itso' kitule tö ichè: “I' dör judiowak blú e'”, e' dör iwà kkachoie tö ì nuí̱ ki̱ ie' wötënewa̱ krus mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ñies wëpa böl akblökwakpa wötéwa̱rakitö krus mik, eköl iulà bua'kka, eköl iulà bakli̱'kka. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pë' tköke ee̱ e'pa tö icheke sulu, iwökir wötiu̱kerak iwöa̱, es ichekerakitö: —¡Íkëta̱, be' se̱ tö Skëköl wé tkekettsa̱ eta̱ ká̱ mañat ë̀ ta̱ be' tö iyuéka̱ne! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡E̱'ma be' e̱' tsa̱tkö́, be' e̱' ö́wa krus se̱ mik! ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Es ñies sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa tö Jesús wayueke. Ie'pa tö icheke ñì a̱: —O̱'kapa tsa̱tkéitö erë ie' wák kë̀ a̱ e̱' tsa̱tkër. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Moki̱ ie' dör wé̱ pairine'bitu̱ idi' wa s'blúie, moki̱ ie' dör se' Israel aleripa e' blú, e̱'ma a̱s ie' e̱' ö̀wa krus wí̱ mik, e' iarma ta̱ se' e̱rblö̀mi ie' mik. Wé̱pa wötëne ie' ta̱ krus mik e'pa tso'ñak ie' chök suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mik diwö de bata a̱, eta̱ ká̱ mía̱ ttsettseë ká̱ wa'ñe dö̀ tsá̱li̱ diwö de mañat ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","E' wösha̱ ta̱ Jesús a̱neka̱ tai̱ë ta̱ iché: “Eloí, Eloí, ¿lemá sabactani?” (e' wà kiane chè: A ye' Këköl, a ye' Këköl, ¿iö́k be' ye' we'ikéttsa̱?) ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","We̱lepa tso' ee̱, mik e'pa tö ttè e' ttsé ta̱ ichérakitö: —¿A' ittsé? Ie' tso' Skëköl tteköl bak kiè Elías, e' kiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Eta̱ ie'pa eköl tu̱nemi tö suiyök nuwé̱ka̱ vino shköshkö wa e' tkéka̱itö kuaköl bata ki̱ ta̱ itkéwa̱ ikkö̀ mik a̱s ikuyö̀itö. Ie'pa tö iché: —Imúa̱t bër, ipanusö suè̱ tö Elías datse̱ iökwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús a̱neka̱ tai̱ë ta̱ isiwa̱' bata tké. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Eta̱ Skëköl wé a̱ ie'pa wa̱ datsi' buririë ese shu̱ku̱ar u blatoie e' jchënane ká̱kke̱ döttsa̱ i̱ski̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Eta̱ Roma ñippökwakpa eköl dör capitán e' durshkö Jesús wömik. Mik e' tö isué̱ tö we̱s Jesús duowa̱, eta̱ ichéitö: —Moki̱, wëm wí̱ dör Skëköl Alà je'. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ñies alakölpa iëte̱r ee̱ ie' kí̱ sa̱u̱k ka̱mië. E' shu̱a̱ eköl dör María Magdala wak. Iëköl dör María e' dör Santiago tsirla ë́k ena José, e'pa mì. Iëköl dör Salomé. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Alakölpa e'pa bak shkök Jesús ta̱ ena iki̱me' mik ibak Galilea eta̱. Ñies alakölpa skà tso' tai̱ë dë'bitu̱ Jesús ta̱ dö̀ Jerusalén. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","E' diwö dör judiowak a̱ íyi kanéwo̱ie e̱no diwö yöki̱. Ká̱ tuirketke e' kue̱ki̱ wëm eköl kiè José Arimateawak, e' kësik iéwa̱ ta̱ imía̱ Jesús nu kiök Pilato a̱ blèwa̱. Ie' dör judiowak wökirpa e' eköl dalöiërta̱' tai̱ë ese. Ñies ie' tso' ì blúie Skëköl tso' e' ké̱wö panuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato tkinewa̱ tö Jesús duowa̱tke, e' kue̱ki̱ ie' tö icapitán kié chakè tö moki̱ Jesús duowa̱tke. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mik ie' wa̱ ijche̱newa̱, eta̱ ie' tö Jesús nu ké̱wö mé José a̱ tsè̱mi. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","E' ukuöki̱ ta̱ José tö datsi' ukuö bua'bua saruru ese tué̱ et. Jesús nu éwaitö krus mik, e' patréwa̱itö datsi' ñe' wa bléwa̱ ákuk biule s'nu blóie ese a̱. Eta̱ ákuk kkö̀ wötéwa̱itö ák bërie wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Wé̱ Jesús nu menewa̱ e' sué̱ María Magdala wak ena María dör José mì, e'pa tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mik e̱no diwö tka, eta̱ María Magdala wak ena María dör Santiago mì ena Salomé e'pa tö kiö̀ masmas bua'bua ese tué̱ mí ie'pa wa̱ tèka̱ Jesús nu ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Eta̱ domingo bla'mi e̱rpa diwö tskine ta̱ ie'pa míyal wé̱ Jesús nu blëne ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ie'pa ñì a̱ iché: —¿Yi tö se' a̱ ák yèmittsa̱ ákuk kkö̀ a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Erë mik ie'pa tö iweblé, eta̱ ie'pa tö isué̱ tö ák rratune bánet. Ák e' dör bërie. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mik ie'pa dewa̱ ákuk a̱, eta̱ ie'pa tö isué̱ tö duladula tkër eköl ulà bua'kka, e' datsi' saruruë batsì̱ë. Ie'pa tkinewa̱ iyöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Erë ie' tö iché ie'pa a̱: —Kë̀ a' tkinukwa̱. Ye' é̱na ia̱ne tö a' tso' Jesús Nazaret wak köte̱wa̱ krus mik e' nu yulök. Erë kë̀ iku̱' í̱e̱, ie' shke̱neka̱ne. Wé̱ ie'pa tö ime'wa̱ e' tö̀ weblö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","A' yú Pedro ena ittökatapa male̱pa a̱ ibiyö́ chök tö ie' mitke a' yöki̱ ke̱we Galilea. Ee̱ a' tö ie' sue̱raë we̱s ie' tö a' a̱ iyë' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Alakölpa tkinewa̱ painéka̱ tai̱ë, e' kue̱ki̱ ie' e̱' yélur ákuk a̱ tkayalmi. Ie'pa suane, e' kue̱ki̱ kë̀ wa̱ ì yëne yi a̱.  ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús shke̱neka̱ne domingo bla'mi, e' ukuöki̱ ta̱ ie' e̱' kkaché ke̱we María Magdala wak a̱, e' a̱ ie' tö aknamapa bak kul (7) e' trëo̱'yal. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Eta̱ alaköl e' mía̱ ibiyö́ chök wé̱pa bak shkök Jesús ta̱ e'pa a̱. Ie'pa e̱riarke i̱ù̱ tulur sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Erë mik ie'pa ittsé tö Jesús shke̱neka̱ne ñies tö alaköl ñe' tö isué̱, eta̱ kë̀ ie'pa wa̱ iklöo̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","E' ukuöki̱ ta̱ ittökatapa böl shkörami micho bánet, eta̱ ñala̱ ki̱ Jesús e̱' kkaché ie'pa a̱, erë iwër kua̱'ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Eta̱ ie'pa míyal ibiyö́ chök imale̱pa a̱, erë ñies kë̀ ie'pa wa̱ ittö̀ klöo̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","E' ukuöki̱ ta̱ Jesús e̱' kkaché ittökatapa dabom eyök ki̱ eköl e'pa a̱. Ie'pa tulur chkök e' dalewa ie' de. Wé̱pa tö ie' shke̱neka̱ne e' sué̱, e'pa ttö̀ kë̀ klöo̱ne ie'pa wa̱, ie'pa e̱r darërë e' kue̱ki̱. E' ki̱ ie' tö ie'pa uñélor. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Eta̱ ie' iché ie'pa a̱: “A' yú ká̱ wa'ñe ye' tté buaë e' pakök sulitane a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yi e̱rblé ye' mik ta̱ ie' e̱' wöskuée esepa tsa̱tkërdaë. Erë yi kë̀ e̱rblëne ye' mik esepa kichatërdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wé̱pa e̱rblöke ye' mik esepa tö ì kë̀ o̱r yi a̱ ese we̱raë iwà kkachoie. Ye' ttö̀ wa ie'pa tö aknamapa trë'we̱rattsa̱, ñies ie'pa a̱ imeraë ttoie s'ttö̀ kua̱'ki̱ kua̱'ki̱ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tkabë̀ chö́k klö'wé̱wa̱ ie'pa tö ulà wa ö kapöli sulusi yéwarakitö, e' ta̱ kë̀ ie'pa dö̀pa we̱s. Ñies ie'pa ulà muraka̱ s'kirirke esepa ki̱ ta̱ ibuardane.” ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mik Skëkëpa Jesús ttè e' ché o̱ne, eta̱ ibutsé̱ka̱ mía̱ ká̱ jaì a̱ ta̱ ee̱ ie̱' tkése̱r Skëköl ulà bua'kka. ");
INSERT INTO bzdNTpo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Eta̱ ittökatapa míyal ká̱ wa'ñe Jesús tté buaë pakök. Skëkëpa Jesús tö ie'pa ki̱mé, ì kë̀ o̱r yi a̱ ese u̱k. E' wa ie' tö iwà kkaché tö ie' tté dör moki̱.");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","A këkëpa tai̱ë Teófilo, ì o̱' Jesús tö sa' shu̱a̱ mik ibak ká̱ i' ki̱ eta̱, e' paka' sa' a̱ wé̱pa itsá̱ su̱'bitu̱ dö̀ ibata ekkë e'pa tö. Ie'pa dör Jesús ttè buaë e' kanéu̱kwakpa. Tai̱ë sa' male̱pa imao̱' shtè yëkkuö ki̱, erë kë̀ idë'ttsa̱ we̱s ikiane shtè es. E' kue̱ki̱ ye' tö iwà chakéwa̱ bua'iewa̱ itsá̱ dö̀ ibataë. Es ye' isué̱ tö buaë idir shtèmi be' a̱ yëkkuö i' ki̱ se̱raa̱ we̱s ibak es ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","a̱s be' é̱na ia̱r tö ttè wa be' wöblane, e' dör moki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mik Herodes bak judiowak blúie eta̱ sacerdote tso' eköl kiè Zacarías. Judiowak sacerdotepa ñì dapa'o̱ule erule erule kaneblök Skëköl wé a̱. Zacarías dör sacerdotepa erule kiè Abías wakpa e' eköl. Ie' alaköl kiè Elisabet, e' dör ñies sacerdotepa ditséwö we̱s iwëm es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ie'pa böl se̱rke yësyësë Skëköl wöa̱. Ie'pa tö Skëköl ttè me'bak dalöiëno, e' dalöieke buaë, kë̀ ki̱ ì sulu tté ta̱'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Erë Elisabet kë̀ döta̱' alàë. Ñies ie'pa böl dör këkëpalatke. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Etökicha ta̱ mik Zacarías ena imale̱pa kàne iwakanéu̱k Skëköl wé a̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","eta̱ ie'pa iné ilè wa we̱s ie'pa wöblar es isuo̱ie tö yi kàne shkökwa̱ Skëköl wé shu̱a̱ íyi masmas ña'u̱k Skëköl a̱. Eta̱ idettsa̱ tö Zacarías ka̱wöta̱ shkökwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mik ie' tso' Skëköl wé shu̱a̱ íyi masmas ña'u̱k, e' dalewa tai̱ë s'daparke u'rki̱ ttök S'yë́ ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","E' wösha̱ ta̱ Skëköl biyöchökwak eköl e̱' kkachéwa̱ ie' a̱ ka̱' tso' íyi masmas ña'wo̱ie Skëköl a̱ e' ulà bua'kka. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mik ie' tö Skëköl biyöchökwak sué̱ ta̱ ie' tkinewa̱ suane tai̱ë iyöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Eta̱ biyöchökwak tö iché ie' a̱: —A Zacarías, kë̀ be' suanuk. Ì kié be' tö Skëköl a̱, e' meraëitö be' a̱. Be' alaköl dör Elisabet, e' döraë alàë, e' wák wëm. Ie' kiè múka̱ a' tö Juan. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Ie' döraë këkëpa tai̱ë Skëköl wöa̱. E' kue̱ki̱ e' be' ttsë'we̱raë buaë kaneë. Ñies ie' tö tai̱ë pë' ttsë'we̱raë buaë. Ie' kë̀ ì shköshkö yepa. Ka̱m ie' ku̱r eta̱ Wiköl Batse'r döraë ie' ki̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ie' tö Israel aleripa tai̱ë, e' kerane ie'pa Këköl yulökne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ie' döraë Skëköl yöki̱ ke̱we itté pakök. Ie' tö ipakeraë Wiköl Batse'r diché tai̱ë e' wa we̱s Skëköl tteköl kiè Elías bak ká̱ ia̱ia̱ë es. Ie' ipakeraë a̱s iyë́ e̱r buarne ila'r ki̱ ena ila'r e̱r buarne iyë́ ki̱. Ñies ipakeraëitö a̱s wé̱pa tö Skëköl ttè dalöse̱wé̱wa̱, esepa e̱' wöbla'ù̱ se̱nuk yësyësë. Es ie' tö ie'pa patteraë Skëköl datse̱ e' panoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Eta̱ Zacarías tö Skëköl biyöchökwak a̱ ichaké: —¿Ì wa be' ye' a̱ ikkachèmi tö ttè e' dör moki̱? Ye' dör këkëpalatke. Ñies ye' alaköl dewa̱tke këkëpalatke, ta̱ ¿we̱s sa' alala kö̀ka̱miia̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ie' iiu̱té: —Ye' dör Gabriel. Ye' kaneblöke Skëköl a̱. Ie' ye' patké ttè buaë i' chök be' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Erë be' kë̀ wa̱ ye' ttè klöo̱ne, e' kue̱ki̱ be' ttö̀ wöblërdawa̱ kë̀ ttö̀paia̱ dö̀ mik be' alà ku̱ne eta̱. Mik ì chéyö be' a̱ e' ké̱wö de, eta̱ be' ttörane. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","E' dalewa ie'pa tso' Zacarías panuk u'rki̱, e'pa tö ibikeitsé, “¿Ì tö ie' wöklö'wé̱, e' kë̀ döttsa̱ bet Skëköl wé a̱?” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mik ie' dettsa̱, eta̱ ie'pa tö isué̱ tö ie' ttö̀ wöblënewa̱, kë̀ ie' ttoia̱ ta̱ ulà ë̀ wa ie' tö iwà kkaché ie'pa a̱. Eta̱ ie'pa é̱na ia̱ne tö ilè sué̱itö kabsue̱ie. Es ie' a̱te̱ me'ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mik ie' kanè o̱ne Skëköl wé a̱, eta̱ imía̱ne iu a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","E' ukuöki̱ ta̱ ie' alaköl Elisabet duneka̱. Ie' e̱' tkéwa̱ iu a̱ dö̀ si' ske̱l, kë̀ dë'ttsa̱ wé̱rö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ie' tö iché, “Ikkëpa Skëköl tö alà mé ye' a̱. Es ie' e̱r buaë ché ye' a̱, ekkë ye' jaëne.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet duneka̱ e' ki̱ si' de teröl, eta̱ Skëköl tö ibiyöchökwak kiè Gabriel, e' patké Nazaret, ká̱ e' a̱te̱ Galilea. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ee̱ busi se̱rke eköl kiè María. Ie' ka̱m se̱r wëm ta̱, erë ie' ttè meule wëm eköl kiè José e' a̱ se̱nowa̱ ie' ta̱. José dör blu' bak kiè David e' aleri eköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Eta̱ Skëköl biyöchökwak dewa̱ wé̱ María tkër ee̱, ta̱ ichéitö ie' a̱: —¿Is be' shke̱ne? Skëköl e̱r buaë ché be' a̱. Ie' tso'ie be' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ttè e' tö María tkiwé̱wa̱ ta̱ ibikeitséitö, “¿Iö́k ye' shke̱'wé̱ es?” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Eta̱ Skëköl biyöchökwak tö iché ie' a̱: —A María, Skëköl e̱r buaë ché be' a̱, e' kue̱ki̱ kë̀ be' suanuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Be' durka̱raë, be' alà ku̱rdaë wák dör wëm, ikiè múka̱bö Jesús. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ie' döraë këkë tai̱ë, dalö̀ tai̱ë. Ie' kirdaë Skëköl dör íyi ulitane tsa̱ta̱, e' Alà. Skëköl tö ie' meraka̱ blu'ie we̱s iyë́ bak kiè David es ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","a̱s Jacob aleripa wëttsù̱itö blu'ie ke̱kraë kë̀ e̱rta̱'wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Eta̱ María tö ichaké Skëköl biyöchökwak a̱: —Ka̱m ye' se̱r wëm ta̱, eta̱ ¿we̱s ì ché be', e' wà tkö̀mi ye' ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Skëköl biyöchökwak iiu̱té: —Wiköl Batse'r döraë be' ki̱, Skëköl dör íyi ulitane tsa̱ta̱ e' diché a̱rdaë be' ki̱. E' kue̱ki̱ be' alà ku̱rdaë, e' se̱rdaë Skëköl ë̀ a̱. Ie' kirdaë Skëköl Alà. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ñies be' yami kiè Elisabet këkëpalatke cheke tö kë̀ idöta̱' alàë, e' alà ku̱rdaë. Si' i' wa ta̱ ie' ki̱ ide si' teröl. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ì ko̱s o̱r Skëköl a̱, kë̀ ì ku̱' darërë ie' a̱ wè̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Eta̱ María tö iché: —Ye' dör Skëköl kanè méso, a̱s ie' tö iù̱ ye' ta̱ we̱s be' iché es. Eta̱ Skëköl biyöchökwak mía̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","E' ukuöki̱ ta̱ María dalì ié ta̱ imía̱ bet Elisabet pakök. Elisabet se̱rke Judea ká̱ dör ka̱bataie ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mik ie' dewa̱ Zacarías u a̱, eta̱ ie' tö Elisabet shke̱'wé̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mik e' ttsé Elisabet tö, eta̱ ilà wöti̱'ne tai̱ë ie' shu̱a̱ ta̱ Wiköl Batse'r de iki̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ie' ttémi darërëë ta̱ ichéitö María a̱: —Skëköl e̱r buaë ché be' a̱ alakölpa ulitane tsa̱ta̱. Ñies ie' e̱r buaë ché be' alà ku̱rmi e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ye' sia̱rë ¿we̱s e' a̱ ie' e̱r buaë ché tö ye' Këkëpa mì e' de ye' pakök? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mik be' tö ye' shke̱'wé̱ e' ttsé yö, e' bet ta̱ ye' alà wöti̱'ne ye' shu̱a̱ ittsë'ne buaë e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ì yë' Skëköl tö be' a̱, e' klö'wé̱bö tö iwà tköraë, e' kue̱ki̱ ayëcha buaë be' dör. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","María tö iché: “Ye' dör Skëköl kanè méso ësela sia̱rë ese ë̀, erë e' ska' ie' e̱r de. E' kue̱ki̱ ie' ki̱kekeka̱ ye' tö. Ie' dör ye' tsa̱tkökwak, e' tö ye' ttsë'we̱ke buaë. Ie' diché tai̱ë íyi ulitane tsa̱ta̱, e' tö ì buaë shu̱te̱ë wé̱ ye' a̱. E' kue̱ki̱ i'ta̱mi ye' yërdaë: ¡Ayëcha buaë! ¡Skëköl dör batse'r! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wé̱pa tö ie' dalöieke, esepa sue̱ke ie' tö ke̱kraë e̱r sia̱rë wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ì kë̀ o̱r yi a̱ ese wé̱itö idiché tai̱ë wa: Pë' e̱' ttsö̀ka̱ tai̱ë esepa tö ì bikeitseke wè̱ ese wöklö'wé̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ká̱ wökirpa u̱yéttsa̱itö ikulé ki̱, e' skéie s'sia̱rëpa tkéka̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wé̱pa sia̱rë kë̀ wa̱ ì ku̱' ñè, esepa a̱ ì buaë méitö tai̱ë. Erë inuköl blúpa esepa patkémiitö ulà wöchka. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Israel aleripa dör ie' kanè mésopa. Ká̱ ia̱ia̱ë ie' tö ie'pa a̱ iyë' tö ie' tö ie'pa sue̱raë e̱r sia̱rë wa. Ttè e' kë̀ chë'wa ie' é̱na. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Es ie' tö iyë'bak Abraham a̱, ñies ie' aleripa ko̱s daia̱ ie' itöki̱ e'pa a̱.” Es María tö iché. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María se̱né Elisabet ska' dö̀ si' mañat ta̱ imía̱ne iu a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mik Elisabet alà ku̱rke e' ké̱wö de, eta̱ iwà ku̱ne wëm. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mik pë' se̱rke tsi̱net ena iyamipa e̱kka, e'pa ibiyö́ ttsé tö Elisabet sué̱ Skëköl tö e̱r sia̱rë wa, eta̱ ie'pa ko̱s ttsë'ne buaë we̱s Elisabet es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mik ilà ku̱ne' e' ki̱ ká̱ de pàköl (8), eta̱ ie'pa debitu̱ ilà tottola kkuölit tërke tsir, e' ké̱wö tkö'u̱k we̱s ie'pa wöblane es iwà kkachoie tö alà e' dör judiowak. Ie'pa é̱na iyë́ kiè Zacarías, e' kiè makka̱ iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Erë imì tö iché: —Au, ie' kirdaë Juan. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ie'pa tö iché: —Kë̀ yi ku̱' be' yamipa shu̱a̱ kiè es. Eta̱ ¿ì kue̱ki̱ be' ikiè mekeka̱ es? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Eta̱ ie'pa ulà kkaché ichakoie alà yë́ a̱, “¿I̱ma be' é̱na ikiè makka̱?” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Eta̱ iyë́ tö kaltak kié, e' ki̱ ie' tö ishté tö “ikiè Juan.” E' tö ie'pa ko̱s tkiwé̱wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","E' wösha̱ ta̱ Zacarías ttéka̱ne, eta̱ Skëköl ki̱kéka̱ ie' tö tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pë' se̱rke tsi̱net, e'pa ko̱s tkirulune tai̱ë. Ñies pë' ko̱s se̱rke Judea ké̱bata a̱, e'pa shu̱a̱ itté buneka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ie'pa ulitane tö itté ttsé e'pa tö ibikeitsé: “Alà e' döraë këkëpa tai̱ë.” Ie'pa isué̱ tö Skëköl tso' ie' ta̱, e' kue̱ki̱ ie'pa tö ibikeitsé es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Eta̱ Wiköl Batse'r de tai̱ë Zacarías ki̱, e' wa ie' ttémi Skëköl ttekölie ta̱ ichéitö: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Skëköl dör Israel aleripa Këköl, e' de ie' icha ko̱s tsa̱tkök, e' kue̱ki̱ iki̱köka̱sö tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ie' tö S'tsa̱tkökwak diché tai̱ë, e' patké eköl, e' dör ie' kanè méso bak kiè David e' aleri. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","E' dör we̱s Skëköl ttekölpa batse'r bak ká̱ ia̱ia̱ë e'pa tö iyë'a̱t es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Skëköl tö iyë'a̱tbak tö ie' tö se' tsa̱tkeraë s'bolökpa ulà a̱, ñies wé̱pa é̱na se' a̱r suluë esepa ko̱s yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ie' tö ittè batse'r me' se' yë́pa bak ká̱ ia̱ia̱ë e'pa a̱ tö ie' se' sue̱raë e̱r sia̱rë wa, e' kë̀ ska' ie' e̱r chë'wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ie' tö iyë' se' yë́ bak ká̱ ia̱ia̱ë kiè Abraham e' a̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tö se' tsa̱tkeraëitö s'bolökpa ulà a̱ a̱s se' se̱r ie' a̱ kë̀ suarta̱', ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ñies a̱s se' se̱r batse'r ena yësyësë ie' wöa̱ se' tso'ia̱ ttsë'ka e' dalewa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A ye' bëbëla, mik be' de këchke, eta̱ be' miraë ke̱we s'pattök a̱s se' tö Skëköl kiö̀wa̱ buaë mik ide eta̱. E' kue̱ki̱ be' kirdaë Skëköl dör íyi ulitane tsa̱ta̱, e' tteköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Israel aleripa a̱ be' tö ttè pakeraë a̱s ie'pa wa̱ ijche̱r tö ì sulu wambleke ie'pa tö, e' olo'yèmi Skëköl tö ie'pa ki̱ itsa̱tkoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Skëköl tö se' sue̱ke e̱r sia̱rë wa, e' kue̱ki̱ ie' tö S'tsa̱tkökwak patkekebitu̱ se' a̱ datse̱ ká̱ jaì a̱ olo ta̱' tai̱ë we̱s diwö tskir bla'mi es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Wé̱pa tso' klöulewa̱ ì sulu ulà a̱ we̱s s'tso' stui a̱ es, wé̱pa tso' iduökewa̱tke e' ë̀ ki̱nuk, esepa wöa̱ ká̱ ñi'we̱raë ie' tö a̱s itsa̱tkërdak. Ie'pa wëttse̱raitö se̱ne bë̀rë ie' ta̱ e' ñalé̱ ki̱.” Es Zacarías tö iché. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Juan talane de këchke ta̱ Wiköl Batse'r tso' tai̱ë ie' a̱. Ie' se̱né ká̱ wé̱ kë̀ yi se̱rku̱' ee̱ dö̀ mik iké̱wö de e̱' kkachoie Skëköl ttekölie Israel aleripa a̱ eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Juan ku̱ne', e' ké̱wö ska' ta̱, Roma wökir kibi kiè Augusto, e' tö ká̱ ko̱s tso' ie' ulà a̱, e' wakpa kiè shtök ké se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Ì dör s'kiè tsá̱ kite̱ mik Cirenio dör ká̱ kiè Siria e' wökir e' ké̱wö ska' ta̱.) ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sulitane ka̱wöta̱ shkökne ká̱ wé̱ iyëpa datse̱ ee̱ e̱' kiè shtök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","José dör David bak Israel blú e' aleri. David ku̱ne' Belén a̱te̱ Judea ee̱. Erë José se̱rke Nazaret a̱te̱ Galilea ee̱. E' kue̱ki̱ ie' mía̱ María ta̱ Belén e̱' kiè shtök. Ie'pa ttè meuletke ñì a̱ se̱nowa̱ie, erë ka̱m ie'pa se̱rwa̱ ñita̱. María batsö̀ dur. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ie'pa tso' Belén, e' dalewa ie' alà ku̱rke, e' diwö de. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Wé̱ s'kapökerö, e' wé a̱, kë̀ ká̱ ku̱neia̱ ie'pa a̱ kapoie. E' kue̱ki̱ ie'pa míyal iyiwak wé a̱ kapökrö. Eta̱ ee̱ ie' alà tsá̱ ku̱ne wák wëm, ipatréwa̱itö datsi'tak batsì̱ wa méka̱itö iyiwak tioie ese kulë' a̱ ka̱' skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","E' nañewe tsi̱net Belén obeja kkö'nukwakpa tso' iiyiwak kkö'nuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","E' bet ta̱ Skëköl biyöchökwak de eköl ie'pa ska' ta̱ Skëköl olo tai̱ë e' olo buneka̱ ie'pa pamik, e' yöki̱ ie'pa suane tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Erë Skëköl biyöchökwak tö iché ie'pa a̱: “Kë̀ a' suanuk, ttè buaë datse̱ ye' wa̱ a' a̱, e' tö pë' ulitane ttsë'we̱raë buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","I̱'ñe a' tsa̱tkökwak ku̱ne David ká̱ a̱, e' dör Skëkëpa pairine'bitu̱ idi' wa a' blúie e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","A' tö ie' kue̱raë parratulewa̱ datsi'tak batsì̱ wa tër kulë' tso' iyiwak tioie ese a̱. E' wa a' wa̱ ijche̱r tö ì ché ye' tö a' a̱, e' dör moki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","E' bet ta̱ Skëköl biyöchökwakpa kí̱ de tai̱ë shu̱te̱, e' tö Skëköl ki̱kekeka̱ ta̱ ichekerakitö: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Skëköl tso' ká̱ jaì a̱, e' ki̱köka̱sö! ¡Ñies wé̱pa a̱ Skëköl e̱r buaë chö̀ a̱s esepa se̱r bë̀rë ñita̱ ká̱ i' ki̱!” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mik Skëköl biyöchökwakpa míyalne ká̱ jaì a̱, eta̱ obeja kkö'nukwakpa tö iché ñì a̱: —Mishka Belén, ì ché Skëköl tö se' a̱, e' wà sa̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eta̱ ie'pa míyal bet, ta̱ María ena José kué̱rakitö, ta̱ iyëne tö alà àr iyiwak tio kulë́ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mik ie'pa isué̱, eta̱ ì ko̱s ché Skëköl biyöchökwak tö ie'pa a̱ alà e' ki̱, e' pakéne ie'pa tö itso'rak ee̱ e'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mik wé̱pa tö, ì ché obeja kkö'nukwakpa, e' ttsé, eta̱ e'pa ko̱s tkirulune. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ttè e' ko̱s bleke María tö ie̱r a̱ ta̱ ie' iwà bikeitseke ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Eta̱ obeja kkö'nukwakpa míyalne. Ì ko̱s ttsé ie'pa tö, sué̱ ie'pa tö, e' ki̱ ie'pa tö Skëköl ki̱keka̱rami. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mik alala ki̱ ká̱ de pàköl (8), eta̱ ie'pa itóttola kkuölit tée tsir ta̱ ikiè méka̱rakitö Jesús we̱s Skëköl biyöchökwak iyë' María a̱ ka̱m ie' buklurka̱ e' yöki̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mik Jesús ku̱ne' e' ki̱ ká̱ de dabom tkëyök (40), eta̱ María ena José mía̱ e̱' batse'u̱k we̱s ttè dalöiëno kit Moisés tö e' tö ichè es. Ie'pa wa̱ ilà mí mè Skëköl a̱ Skëköl wé a̱te̱ Jerusalén ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Skëköl ttè dalöiëno e' ki̱ itso' kitule e' tö ichè: “Alaköl alà tsá̱ ku̱ne wëm, e' kirdaë batse'r Skëköl a̱.” E' kue̱ki̱ ie'pa wa̱ ilà mí mè Skëköl a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ñies ie'pa mía̱ iyiwak muk jchè Skëköl a̱ e̱' batse'wo̱ie we̱s Skëköl ttè dalöiëno tö ichè es: e' dör dù kiè tórtola, et wë'ñe ena et alaki ö nuböl pupula böt. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","E' ké̱wö ska' ta̱ wëm se̱rke Jerusalén kiè Simeón. Ie' se̱rke yësyësë we̱s Skëköl ki̱ ikiane es. Skëköl tö Israel aleripa tsa̱tkeke e' ké̱wö paneke ie' tö. Wiköl Batse'r tso' ie' a̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","e' tö ie' a̱ iyë': “be' kë̀ blërpawa̱ ka̱m be' tö wé̱ pairine'bitu̱ idi' wa a' blúie patkeraë Skëköl tö e' sa̱ù̱ e' yöki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ie' ittsé Wiköl Batse'r wa tö ie' ka̱wöta̱ shkök Skëköl wé a̱, e' kue̱ki̱ ie' mía̱ demi ee̱. Ee̱ ñies José ena María demi. Ie'pa wa̱ ilala Jesús mí wakanewè̱ we̱s Moisés ttè dalöiëno tö ichè es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón tö alala kéka̱ ulà a̱ ta̱ Skëköl ki̱kéka̱itö ta̱ ichéitö: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“A Skëköl, ye' dör be' kanè méso, ì yë' be' tö ye' a̱, e' wà sué̱yö. E' kue̱ki̱ ire', ye' duöwa̱mi bë̀rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sa' tsa̱tkökwak patké be' tö e' wà sué̱ia̱yö ye' wák wöbla wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","E' patké be' tö ká̱ ulitane wakpa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ie' döraë we̱s ká̱ olo es, pë' kë̀ dör judiowak esepa e̱r ñi'wo̱ie a̱s ie'pa é̱na be' ttè moki̱ë e' wà a̱r. Ñies Israel aleripa dör be' icha, e'pa ki̱kardaka̱ tai̱ë ie' batamik.” Es Simeón tö iché. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jesús ché Simeón tö Skëköl a̱, e' tö Jesús mì ena iyë́ tkiwé̱wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ie' tö ikié Skëköl a̱ a̱s e' e̱r buaë chö̀ ie'pa a̱ ta̱ ichéitö María dör Jesús mì e' a̱: —Skëköl ibikeitsbak tö alà i' kue̱ki̱ se' Israel aleripa tai̱ë tsa̱tkërdaë ñies e'pa tai̱ë weirdaë. Ie' tö Skëköl olo kkacheraë se' a̱, erë tai̱ë pë' tö ie' waterattsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","E' tö ì bikeitsekesö e' wà kkacheraë. Be' e̱r a̱ idalërdaë tai̱ë we̱s tabè tiè̱wa̱ be' wák e̱r a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","E' wösha̱ ta̱ alaköl debitu̱ eköl ie'pa ska' kiè Ana, e' dör Skëköl tteköl. Ie' yë́ kiè Fanuel, e' dör Aser aleri. Ie' dör këkëpalatke. Ie' se̱ne'wa̱ mik iià̱ busi eta̱. Ie' se̱ne' wëm e' ta̱ duas kul (7) ë̀ ta̱ iwëm blënewa̱. Ie' schönewa̱ e' ki̱ duas de dabom paryök ki̱ tkël (84). Ie' se̱rkeie Skëköl wé a̱ idalöiök ñië nañeë S'yë́ ta̱ ttè wa ena batsè wa. Ie' tö wëstela chémi Skëköl a̱ alala Jesús kue̱ki̱. Ñies ipakéitö tai̱ë Israel aleripa male̱pa tso' itsa̱tkè panuk esepa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mik José ena María e'pa tö ì ko̱s kanewé̱ we̱s Skëköl ttè dalöiëno tö ichè es, eta̱ ie'pa míyalne Nazaret a̱te̱ Galilea ee̱, e' dör iwakpa ká̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Alala talar ë̀, e' tso' buaë, ñies ie' yörke buaë, ika̱bikeitsöke tai̱ë ta̱ Skëköl e̱r buaë chöke ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Duas bit ta̱ Jesús mì ena iyë́ mi'ke Jerusalén Judiowak Yë́pa Yërulune Egipto e' ké̱wö tkö'u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mik Jesús ki̱ duas de dabom eyök ki̱ bök (12), eta̱ ie'pa míyal ka̱wö e' skà tkö'u̱k we̱s ie'pa wöblar es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mik iké̱wö tka, eta̱ ie'pa míyalne iu a̱, erë Jesús a̱te̱ Jerusalén, e' kë̀ jche̱r imì wa̱ iyë́ wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ie'pa tö ibikeitsé tö ie' dami iyamipa ta̱. Ie'pa shké ká̱ et ta̱ ie'pa isué̱ tö Jesús kë̀ ku̱' ie'pa ta̱. E' kue̱ki̱ ie'pa iyulémi iyamipa dami tai̱ë e'pa shu̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Erë ie'pa kë̀ wa̱ ie' ku̱ne, e' kue̱ki̱ ie'pa mía̱ne Jerusalén iyulökne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ká̱ de böiki es, eta̱ ie'pa tö Jesús kué̱ Skëköl wé a̱. Ie' tkër s'wöbla'u̱k ttè dalöiëno wa wakpa shu̱a̱ iki̱ttsök ena ichakök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jesús tö iiu̱teke e' ttsé ie'pa ko̱s tö e'pa wökrarulune ittsök ena isa̱u̱k tö we̱s ie' wa̱ íyi jche̱r tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mik imì ena iyë́ tö ie' sué̱ ee̱, eta̱ ie'pa tkinewa̱. Eta̱ imì tö iché ia̱: —A alà, ¿iö́k be' e' wamblé sa' ta̱ es? ¿Iö́k be' tö be' yë́ ena ye' e̱riawé̱ ekkë? Sa' be' yulé tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús tö ie'pa iu̱té: —¿Iö́k a' ye' yulé tai̱ë? ¿We̱s a' kë̀ wa̱ ijche̱r tö a' ye' kue̱raë ye' Yë́ u a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Erë ì ché ie' tö, e' wà kë̀ a̱ne ie'pa é̱na. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Eta̱ imía̱ne ie'pa ta̱ Nazaret ta̱ ie' tö ie'pa ttö̀ iu̱teke buaë ke̱kraë. E' ko̱s bleke imì tö ie' e̱r a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús talarke buaë, ñies ie' kí̱ yörke tai̱ë, ka̱bikeitsöke buaë, wër buaë Skëköl wa, ñies s'ditsö wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ká̱ et ta̱ Skëköl tté Juan dör Zacarías alà e' ta̱ wé̱ kë̀ yi se̱rku̱' ee̱ ipatkoie ittè pakök. E' ké̱wö ska' ta̱ wëm kiè Tiberio e' dör Roma wökir kibi. Ie' tkëneka̱ ká̱ e' wökirie, e' ki̱ duas de dabom eyök ki̱ ske̱l (15). Ie' diki̱a̱ ká̱ tsitsirpa wökirpa tso'. E'pa kiè dör i' es: Poncio Pilato dör Judea wökir, Herodes dör Galilea wökir, e' ël kiè Felipe e' dör Iturea ena Traconítide e' wökir ena Lisanias dör Abilinia wökir. E' ké̱wö ska' ta̱ Anás ena Caifás e'pa dör judiowak sacerdotepa wökirpa. E' ké̱wö ska' ta̱ Skëköl tté Juan ta̱ ká̱ sir poë wé̱ kë̀ yi se̱rku̱' ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Eta̱ Juan mía̱ di' kiè Jordán kkömik pë' se̱rke ee̱, e'pa a̱ Skëköl ttè pakök. Ie' tö iché ie'pa a̱: “A' e̱r mane'ú̱ Skëköl a̱ a̱s a' nuì̱ olo'yö̀itö a' ki̱ ta̱ a' e̱' wöskuö́lor iwà kkachoie.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaías dör Skëköl tteköl e' tö Juan tté kit ká̱ ia̱ia̱ë Skëköl yëkkuö ki̱, e' tö ichè: “Ká̱ sir poë wé̱ kë̀ yi se̱rku̱', ee̱ yile ttöraë a̱neule, e' tö icheraë: ‘A' e̱r mane'ú̱ Skëköl datse̱ e' yöki̱, e' dör we̱s ñala̱ yuèsö yësyësë ie' yöki̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ká̱blë ko̱s ka̱wöta̱ wà ièka̱ se̱raa̱, ñies ka̱bata ena ka̱kkuö ko̱s ka̱wöta̱ wè̱ ñikkëë, ñala̱ shku̱li̱'shku̱li̱', e' ko̱s ka̱wöta̱ yèttsa̱ yësyësë, ñies ñala̱ suluë, e' ko̱s ka̱wöta̱ paiklèttsa̱ buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Skëköl tö s'tsa̱tkè, e' sue̱raë sulitane tö.’ ” Es Isaías iyë'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pë' debitu̱ tai̱ë Juan ska' a̱s ie' tö ie'pa wöskuö̀ ta̱ ie' tö ie'pa a̱ iché: “¡A' dör s'ki̱tö'u̱kwakpa suluë we̱s tkabë̀ es! ¿Yi tö a' a̱ iché tö a' tkömishkar Skëköl tö a' we'ikeraë sia̱rë e' ulà a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","A' se̱nú yësyësë, e' wa iwërmiwa̱ tö moki̱ a' e̱r mane'wé̱tke Skëköl a̱. Kë̀ a' tö ibikeitsök tö a' dör Abraham aleripa e' ë̀ kue̱ki̱ Skëköl kë̀ tö a' we'ikepa. Ye' tö a' a̱ ichè tö Skëköl ki̱ ikiane, e' ta̱ ie' tö ák ikkë yuèmi Abraham aleripaie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ie' dör we̱s kal bikökwak es. Ie' tso'tke kal ulitane kë̀ wörta̱' ese ko̱s bikökök ña'wè̱wa bö' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Eta̱ ie'pa tö Juan a̱ ichaké: —¿E̱'ma ì wè̱mi sa' tö? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ie' tö ie'pa iiu̱té: —Yi wa̱ datsi' tso' böt, e' etka mú wé̱ kë̀ wa̱ ita̱' ese a̱. Es ñies yi wa̱ chkè tso', ese tö chkè kakmú wé̱ kë̀ wa̱ ita̱' ese a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Inuköl shtökwakpa Roma wökirpa a̱, e'pa we̱lepa debitu̱ Juan ska' a̱s ie' tö ie'pa wöskuö̀, ie'pa tö ie' a̱ ichaké: —A' s'wöbla'u̱kwak, ¿ì wè̱mi sa' tö? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ie' tö ie'pa iiu̱té: —Kë̀ a' tö inuköl shtök ko̱s ika̱wöta̱ shtè e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ñies ñippökwakpa we̱lepa ie' a̱ ichaké: —Ñe' ta̱ ¿ì wè̱mi sa' tö? Ie' tö ie'pa iu̱té: —Kë̀ a' s'pau̱ñuk inuköl yottsa̱ie. Kë̀ a' ka̱chök s'ña'wo̱ie. Ko̱s a' pato̱rke, ekkë ë̀ klö'ú̱, ta̱ a' ttsë'nú buaë iwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wé̱ pairine'bitu̱ idi' wa s'blúie e' datske bet, e' wà panuk sulitane tso'. E' kue̱ki̱ ie'pa tso' ibikeitsök tö isalema Juan dör e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Erë Juan tö iché ie'pa ulitane a̱: “Moki̱ ye' a' wöskueke di' wa. Erë ye' itöki̱ idatse̱ eköl, e' tö a' ierawa̱ Wiköl Batse'r a̱ ena bö' a̱. Ie' dör këkëpa tai̱ë ye' tsa̱ta̱, e' kue̱ki̱ ie' klökkuö kicha ë̀ kë̀ wötsënanuk ye' sia̱rla e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ie' tö se' wöpperaë we̱s iyiwö wöppè es. Ibua'bua bleraëitö idichakuö a̱, erë isulusi u̱yerawa̱itö bö' kë̀ wöitta̱'wa̱ e' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Es Juan ie'pa patté ttè ese wa tai̱ë. Es ie' tö S'tsa̱tkökwak ttè buaë e' pakeke ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ñies Juan tö Herodes dör Judea wökir, e' uñé. Herodes se̱rke ie' wák ël e' alaköl kiè Herodías e' ta̱. Ñies ie' tö ì sulu skà wamblé tai̱ë. E' kue̱ki̱ Juan ie' uñé. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes tö ì sulu wamblé tai̱ë, erë e' kí̱ie ta̱ ie' tö Juan wötökwa̱ patké s'wöto wé a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mik Juan bak sulitane wöskuök, eta̱ ñies ie' tö Jesús wöskué. Mik Jesús tso'ia̱ ttök S'yë́ ta̱, e' dalewa ká̱ jaì kköbunane ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ta̱ Wiköl Batse'r de ie' ki̱ wër nuböl sù̱. Eta̱ ttö̀ ttsëne ká̱ jaì a̱, e' tö iché: —Be' dör ye' alà dalër tai̱ë ye' é̱na, e' wër ye' wa buaë shu̱te̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mik Jesús ki̱ duas de dabom mañayök (30) ulatök, eta̱ ie' tö Skëköl ttè pakémitke. Ie'pa tö ibikeitsé tö ie' dör José alà. José dör Elí alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","e' dör Matat alà, e' dör Leví alà, e' dör Melquí alà, e' dör Janai alà, e' dör José alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","e' dör Matatías alà, e' dör Amós alà, e' dör Nahúm alà, e' dör Eslí alà, e' dör Nagai alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","e' dör Máhat alà, e' dör Matatías alà, e' dör Semeí alà, e' dör Josec alà, e' dör Judá alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","e' dör Johanán alà, e' dör Resá alà, e' dör Zorobabel alà, e' dör Salatiel alà, e' dör Nerí alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","e' dör Melquí alà, e' dör Adi alà, e' dör Cosam alà, e' dör Elmadam alà, e' dör Er alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","e' dör Josué alà. e' dör Eliézer alà, e' dör Jorim alà, e' dör Matat alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","e' dör Leví alà, e' dör Simeón alà, e' dör Judá alà, e' dör José alà, e' dör Jonam alà, e' dör Eliaquim alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","e' dör Melea alà, e' dör Mená alà, e' dör Matatá alà, e' dör Natán alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","e' dör David alà, e' dör Jesé alà, e' dör Obed alà, e' dör Booz alà, e' dör Sélah alà, e' dör Nahasón alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","e' dör Aminadab alà, e' dör Admín alà, e' dör Arni alà, e' dör Esrom alà, e' dör Fares alà, e' dör Judá alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","e' dör Jacob alà, e' dör Isaac alà, e' dör Abraham alà, e' dör Térah alà, e' dör Nahor alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","e' dör Serug alà, e' dör Ragau alà, e' dör Péleg alà, e' dör Heber alà, e' dör Sélah alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","e' dör Cainán alà, e' dör Arfaxad alà, e' dör Sem alà, e' dör Noé alà, e' dör Lámec alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","e' dör Matusalén alà, e' dör Enoc alà, e' dör Jéred alà, e' dör Mahalalel alà, e' dör Cainán alà, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","e' dör Enós alà, e' dör Set alà, e' dör Adán alà. Adán dör Skëköl alà. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús tso' Jordán di' kkömik, ie' a̱ tai̱ë Wiköl Batse'r tso'. E' tö ie' tsé̱mi ká̱ sir poë wé̱ kë̀ yi se̱rku̱' ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ee̱ ie' se̱né döka̱ ká̱ dabom tkëyök (40), e' dalewa bë́ tso' ie' e̱rkiöu̱k ì sulu wamblök. E' ké̱wö ko̱s ta̱ ie' kë̀ chkane yës, e' ukuöki̱ ta̱ ie' dué bli wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Eta̱ bë́ tö ie' a̱ iché: —Be' dör Skëköl Alà, e̱'ma ichö́ ák se̱ a̱ tö iyönú chkeie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús tö iiu̱té: —Skëköl yëkkuö tö ichè: “Kë̀ se' se̱nuk chkè ë̀ mik.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","E' ukuöki̱ ta̱ bë́ tö ie' tsé̱mi ka̱bata ka̱kke̱ë a̱, ta̱ ee̱ ká̱ ko̱s we̱s ká̱ tköke ekkë kkachéitö ia̱ bet. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ie' tö iché ia̱: —Ká̱ ko̱s sué̱bö e' meule ye' ulà a̱, e' kue̱ki̱ yi a̱ ye' é̱na imak, ese a̱ ye' imeke. Ye' be' yuèmi ká̱ ko̱s e' blúie. Ñies íyi buaë tso', inuköl tso', ì tso' ká̱ ulitane ki̱, e' ko̱s wákie be' yuèmi ye' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Be' e̱' tkéwa̱ kuchëwö ki̱ ye' wörki̱ ye' dalöiök, e' ta̱ e' ko̱s döraë be' ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Erë Jesús ie' iu̱té: —Skëköl yëkkuö tö ichè: ‘Skëköl dör a' Këköl, e' ë̀ dalöiö́; ie' ë̀ a̱ a' se̱nú.’ E' kue̱ki̱ be' e̱' skö́ttsa̱ ye' yöki̱ bánet. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","E' ukuöki̱ ta̱ bë́ wa̱ imítse̱r Jerusalén ta̱ iduéka̱itö Skëköl wé e' bata ki̱ ka̱kke̱ë ta̱ ichéitö ia̱: —Skëköl yëkkuö tö ichè: ‘Skëköl tö ibiyöchökwakpa patkeraë be' kkö'nuk be' tsa̱tkök. Ie'pa be' klö'we̱raka̱ iulà a̱ a̱s be' klö̀ kë̀ tërwa̱ ák ki̱.’ Es Skëköl yëkkuö tö ichè, e' kue̱ki̱ be' dör Skëköl Alà, e̱'ma be' e̱' ppö́ömi döttsa̱ i̱ski̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Erë Jesús iiu̱té: —Ñies Skëköl yëkkuö tö ichè: ‘A' kë̀ ka̱wö ta̱' a' Këköl wötsiriu̱k.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mik bë́ kë̀ wa̱ ì skà ku̱ne Jesús e̱rkiöwo̱ie, eta̱ ie' iméa̱t dö̀ iëttökicha. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús minea̱ dene Galilea. Ke̱kraë Wiköl Batse'r diché tso' ie' a̱ tai̱ë. Ie' tté buneka̱ ká̱ e' ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Judiowak ñì dapa'wo̱ wé ko̱s tso', e' a̱ ie' tö s'wöbla'we̱ke Skëköl ttè wa ta̱ sulitane tö ie' ki̱kekeka̱ buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús demine Nazaret wé̱ ie' talane ee̱. Mik judiowak e̱no diwö de, eta̱ ie' dewa̱ ie'pa ñì dapa'wo̱ wé a̱ we̱s ie' wöblane es. Eta̱ ee̱ ie' e̱' duése̱r Skëköl yëkkuö a̱ritsök ie'pa tso' ee̱, e'pa kukua. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yëkkuö kit Skëköl tteköl kiè Isaías e' tö, e' mé ie'pa tö ie' a̱ suè̱. Ie' ishu̱ppée ta̱ ikué̱itö wé̱ Skëköl kanè méso bua'iewa̱ e' tté tso' kitule ee̱. E' tö ichè i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Skëköl Wiköl tö ye' pairi'bitu̱ idi' wa ttè buaë pakoie s'sia̱rëpa a̱, e' kue̱ki̱ ie' tso' ye' a̱. Ie' tö ye' patkë'bitu̱ ichök s'tso' klöulewa̱ ì sulu ulà a̱ esepa a̱ tö ‘a' yërdattsa̱.’ Ie' tö ye' patkë'bitu̱ wé̱pa wöbla kë̀ wawër esepa wöbla bua'u̱kne. Ie' tö ye' patkë'bitu̱ wé̱pa weirke sia̱rë s'sulusipa ulà a̱, esepa tsa̱tkök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ie' tö ye' patkë'bitu̱ ipakök sulitane a̱ tö Skëköl e̱r buaë chöke se' a̱, e' ké̱wö detke.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","E' ukuöki̱ ta̱ Jesús tö yëkkuö wötréwa̱ne mé judiowak ñì dapa'wo̱ wé e' ki̱mukwak a̱, ta̱ ie̱' tkése̱r iwà pakök. Ko̱s s'daparke ee̱ e'pa tö ie' sué̱wa̱ krereë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Eta̱ ie' tö iché ie'pa a̱: —Skëköl yëkkuö a̱ritsé ye' tö ñe', e' wà tka i' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ie'pa ulitane tö icheke ie' dör pë' buaë. Ñies ttè bua'buaë chekeitö, e' tö sulitane tkiwé̱wa̱. Ie'pa tö iché ñì a̱: —A'ka̱, ¿ie' kë̀ dör José alà? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ie' tö iiu̱té: —Ye' wa̱ ijche̱r buaë a' tö ye' cheraë ttè i' wa: ‘A s'kapeyökwak, be' wák e̱' bua'ú̱ne.’ Ñies a' tö ye' a̱ icheraë: ‘Sa' ittsé tö ì kë̀ o̱r yi a̱ ese wé̱ tai̱ë be' tö Cafarnaúm, ese ú̱ ñies í̱e̱ be' wák ká̱ a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ie' tö ikí̱ ché ie'pa a̱: —Moki̱ ye' a' a̱ ichè tö Skëköl ttekölpa ko̱s kë̀ dalöiërta̱' iwakpa ká̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Moki̱ ye' a' a̱ ichè tö mik Skëköl tteköl kiè Elías bak, eta̱ ka̱li̱ kë̀ yëne yës döka̱ duas mañal kí̱ sha̱böts ta̱ bli bak poë Israel. E' ké̱wö ska' ta̱ alakölpa schö́pa tso' tai̱ë Israel, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","erë Skëköl kë̀ wa̱ Elías patkëne ie'pa ska' iki̱mukrak. Ie' tö Elías patké alaköl dör schö́ eköl se̱rke Sarepta, ká̱ e' a̱te̱ tsi̱net Sidón, e' ki̱muk. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Es ñies mik Skëköl tteköl kiè Eliseo e' bak, e' ké̱wö ska' ta̱ lepra tö s'teke tai̱ë Israel. Erë ie'pa ko̱s kë̀ buao̱ne. Wëm kiè Naamán dör ká̱ kiè Siria e' wak, e' ë̀ buao̱'ne Eliseo tö Skëköl batamik. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mik ie'pa tö ttè e' ttsé, eta̱ ie'pa ko̱s tso' judiowak ñì dapa'wo̱ wé a̱, e'pa uluneka̱ tai̱ë ie' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ie'pa iëneka̱ ie' ki̱ ta̱ iu̱yéttsa̱rakitö ká̱ e' a̱ bánet. Ká̱ e' tso' ka̱bata ka̱kke̱ë e' ki̱, ie'pa wa̱ ie' mítse̱r dö̀ ka̱tte ka̱kke̱ë e' kkömik batrèemi a̱s iduöwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Erë ie' tkami ie'pa shu̱a̱ ta̱ imía̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús mía̱ Cafarnaúm, ká̱ e' a̱te̱ Galilea. E̱no diwö bit ekkë ta̱ ie' tö s'wöbla'we̱ke judiowak ñì dapa'wo̱ wé a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ie' tö s'wöbla'we̱ke ttè moki̱ diché ta̱' tai̱ë ese wa, e' kue̱ki̱ ie'pa tkinewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ká̱ et ta̱ ie'pa ñì dapa'wo̱ wé a̱ wëm dur eköl e' a̱ aknama ö wimblu sulusi tso', ie' tö iché a̱neule: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—A Jesús Nazaret wak, sa' múa̱t bë̀rë. ¿Ìie be' tso' sa' tsiriu̱k? ¿Be' debitu̱ sa' e̱u̱kwa? Ye' wa̱ be' su̱ule. Ye' wa̱ ijche̱r tö yi be' dör. Be' dör batse'r patkë'bitu̱ Skëköl tö e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús tö aknama e' uñé: —¡Be' siwa̱'blö́wa̱, be' e̱' yö́ttsa̱ wëm se̱ a̱! Eta̱ aknama tö wëm e' érö i̱ski̱ sulitane wörki̱, ta̱ ie' e̱' yéttsa̱ ia̱ kë̀ wa̱ we̱s wëm o̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Sulitane tkinewa̱ iweblök ta̱ iñi chakérak: —¿Ttè wé̱se dör ñe'? Ttè diché ta̱' tai̱ë e' wa wëm wí̱ wimblupa sulusi ké e̱' yöktsa̱ ta̱ ie̱' yélur je'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Eta̱ Jesús tté buneka̱ tai̱ë ká̱ e' ko̱s a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús e̱' yéttsa̱ judiowak ñì dapa'wo̱ wé a̱ ta̱ imía̱ Simón u a̱. Ee̱ Simón yàk kiri'we̱ke duè dalölö tö tai̱ë. Ie'pa kköché Jesús a̱ tö ibua'ú̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Eta̱ Jesús e̱' wöéwa ie' ki̱ ta̱ duè dalölö uñéitö ta̱ ibuanene. E' bet ta̱ ie' e̱' kéka̱ ta̱ ilè yulémiitö ie'pa a̱ ñè. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Diwö mi'kewa̱tke ta̱ tai̱ë pë' wa̱ iyamipa kiri'we̱ke duè tsa̱ki̱ë tö, esepa debitu̱ tai̱ë Jesús ska'. Ie' ulà méka̱ ie'pa kirirke ko̱s ki̱ eköl eköl, ta̱ es ie' tö ibua'we̱nerak se̱raa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ñies e' shu̱a̱ tai̱ë s'tso' tteke aknamapa tö. Mik ie' tö ie'pa bua'wé̱ne, eta̱ aknama e̱' yélur ie'pa a̱ ta̱ aknamapa tö iché ie' a̱ a̱neule: —¡Be' dör Skëköl Alà chökle! Erë ie' tö ie'pa uñé. Ie'pa wa̱ ijche̱r tö ie' dör wé̱ pairine'bitu̱ idi' wa s'blúie e'. E' kue̱ki̱ kë̀ ie' wa̱ ie'pa kàne ttök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bule es ká̱ ñine ta̱ Jesús e̱' yéttsa̱ mía̱ bánet wé̱ kë̀ yi ku̱' ese ska'. Erë ie'pa tö ie' yulé. Mik ie'pa tö ikué̱, eta̱ ie'pa tö ima'wé̱ wöklö'wè̱ a̱s kë̀ imi'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Erë ie' tö ie'pa iu̱té: —Ì blúie Skëköl tso' e' tté buaë pakök ye' ka̱wöta̱ ñies judiowak se̱rke ká̱ male̱pa a̱ esepa a̱, eseie ye' patkëne'bitu̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","E' kue̱ki̱ ie' mía̱ ttè pakök judiowak ñì dapa'wo̱ wé tso' tai̱ë Judea e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Etökicha ta̱ Jesús dur s'wöbla'u̱k batsöri kiè Genesaret e' kkömik (batsöri e' kiè ñies Galilea). Tai̱ë pë' dapane ie' ska' Skëköl ttè pakekeitö e' ki̱ttsök, e' kë̀ wa ie' shkoia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nima klö'u̱kwakpa dene tso' ikla' skuök, e'pa kanò àr bötö, e' sué̱ Jesús tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ta̱ ie' e̱' iéka̱ kanò etö a̱, e' dör Simón kanò. Ie' tö ikié Simón a̱: “Be' we'ikèyö, kanò patkö́mi bë́rë wöwi̱k.” Ie' e̱' tkése̱r kanò a̱ ta̱ ie'pa wöbla'wé̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mik ie' s'wöbla'wé̱ o̱ne, eta̱ ie' tö iché Simón a̱: —Kanò patkö́u̱mi di' shu̱a̱ ta̱ a' tö kla' u̱yö́mi nima klö'wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón tö ie' iu̱té: —A s'wöbla'u̱kwak, nañeë sa' ima'wé̱, erë kë̀ sa' wa̱ iwà klöne yës. Erë be' ttö̀ wa ye' tö kla' u̱yekene. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mik ie'pa tö ikla' u̱yémi ta̱ iwà klö'wé̱rakitö tai̱ë, e' tö kla' batseeketke. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ta̱ iulà kkaché iyamipa tso' kanò ëtö a̱ e'pa a̱ tö a' shkö́ sa' ki̱muk. Iyamipa debitu̱ ie'pa ki̱muk ta̱ kanò bötö wà iérakitö chië, tsir eta̱ kanò wöturkewa̱tke di' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mik e' sué̱ Simón Pedro tö, eta̱ ie' e̱' tkéwa̱ kuchë ki̱ Jesús klö̀ ska' ta̱ ichéitö ia̱: —¡A Skëkëpa, ye' dör pë' sulusi, be' e̱' skö́ttsa̱ ye' yöki̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nima klöne tai̱ë, e' tö Simón Pedro ena iyamipa ko̱s tso' ie' ta̱, e'pa tkiwé̱wa̱ tai̱ë, e' kue̱ki̱ ie' tö iché es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ñies Santiago ena Juan dör Zebedeo ala'r e'pa tkirulune. Ie'pa kaneblöke Simón ta̱ nima klö'u̱k. Eta̱ Jesús tö iché Simón a̱: —Kë̀ be' suanuk. Be' kë̀ tö nima klö'we̱paia̱. I' ta̱mi be' wa̱ s'ditsö bitu̱raë ye' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Eta̱ ie'pa tö kanò ikléka̱, ta̱ íyi ko̱s tuléa̱t ie'pa tö ee̱ ta̱ imíyal Jesús ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Etökicha ta̱ Jesús tso' Judea ké̱ et a̱. Eta̱ ee̱ wëm debitu̱ eköl kiri'we̱ke lepra tö. Mik ie' tö Jesús sué̱, eta̱ ie' wöéwa dö̀ i̱ski̱ ta̱ ikköché tai̱ë Jesús a̱: —A këkëpa, be' ki̱ ikiane, e' ta̱ be' a̱ ye' buarmine a̱s ye' batse'rne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús tö ikéwa̱ ulà wa ta̱ ichéitö ia̱: —Tö́, ye' ki̱ ikiane. Be' dene batse'r. E' wösha̱ ta̱ ie' buanene, kë̀ ki̱ lepra ku̱'ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Eta̱ Jesús tö ie' a̱ iché: —Kë̀ ichar yi a̱. Be' yú e̱' kkachök sacerdote a̱. Ì muk Moisés tö a' ka' e̱' batse'wo̱ie, ese tsú̱mi mè Skëköl a̱ ie'pa a̱ ikkachoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Erë Jesús tté ti̱neka̱ tai̱ë shu̱te̱. Tai̱ë pë' döke ie' ska' ie' ttè ki̱ttsök, ñies a̱s ie' tö ie'pa bua'ù̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Erë tai̱ë ie' mi'ke bánet ttök S'yë́ ta̱ wé̱ kë̀ yi ku̱' ese ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Etökicha ta̱ Jesús tso' s'wöbla'u̱k ta̱ ee̱ fariseowakpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa tulur Jesús tso' s'wöbla'u̱k e' ki̱ttsök. Ie'pa datse̱ ká̱ ko̱s tso' Galilea ñies Judea ena Jerusalén. Jesús wa̱ Skëköl diché tso' s'kirirke ese bua'wo̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Eta̱ wëpa we̱lepa debitu̱ e'pa wa̱ wëm kraulewa̱ debitu̱ eköl ka̱'la ki̱. Ie'pa é̱na iduè tsa̱kmi u shu̱a̱ wé̱ Jesús dur ee̱ a̱s ie' tö ibua'ù̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Erë tai̱ë s'tso', e' kue̱ki̱ ie'pa kë̀ a̱ itkö̀mi we̱s u shu̱a̱. E' kue̱ki̱ ie'pa míka̱ u bata ki̱ tö u jchée ta̱ iduè émirakitö e̱naë döttsa̱ i̱ski̱ wé̱ Jesús dur pë' tso' tai̱ë e' shu̱a̱ ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mik Jesús tö isué̱ tö moki̱ ie'pa e̱rblé ie' mik, eta̱ ie' tö iché wëm kirirke e' a̱: —A yami, ì sulu ko̱s wamblébö, e' nuí̱ olone be' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Eta̱ s'wöbla'u̱k ttè dalöiëno wa wakpa ena fariseowakpa tö ibikeitsè: “¿I̱ma wëm wí̱ e̱rbikö̀ tö ie' dör yi e' tö Skëköl ché suluë es? Skëköl ë̀ a̱ se' nuì̱ olo'yarmi.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Erë ì bikeitsök ie'pa tso' e' sué̱wa̱ Jesús tö bet. E' kue̱ki̱ ie' tö ie'pa a̱ ichaké: —¿Ì kue̱ki̱ a' ibikeitseke es? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ye' tö wëm i' bua'wè̱mine a̱s ishköne, e' ta̱ ¿we̱s a' tö iklö'wè̱mi tö ye' kë̀ a̱ inuì̱ oloyanuk iki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ye' dör S'ditsö Alà, sú̱ e' tö a' a̱ ikkachè tö ye' wa̱ ka̱wö ta̱' ká̱ i' a̱ nuì̱ olo'yoie. Eta̱ ie' tö iché wëm kraulewa̱ e' a̱: —Be' e̱' kö́ka̱, be' ka̱'la kö́ka̱ ta̱ be' yúne u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","E' wösha̱ ta̱ ie' e̱' kéka̱ sulitane wörki̱ ta̱ ka̱'la a̱ ie' debitu̱, e' kéka̱itö ta̱ imía̱ne iu a̱ Skëköl ki̱keka̱ramiitö tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ie'pa wökrarulune iweblök ta̱ Skëköl ki̱kéka̱rakitö tai̱ë. Ie'pa suane ta̱ ichéitörak: —Ì sué̱ se' tö i̱'ñe, e' kë̀ su̱ule se' wa̱ yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","E' ukuöki̱ ta̱ Jesús mía̱, e' tö wëm sué̱ eköl kiè Leví, e' dör inuköl shtökwak Roma wökirpa a̱. Ie' tkër ikaneblöke e' wé a̱. Ta̱ Jesús tö ie' a̱ iché: —Be' shkö́ ye' ta̱ ye' ttökataie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Eta̱ Leví e̱' kéka̱ tö ì ko̱s méa̱t ta̱ imía̱ Jesús ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","E' tsá̱li̱ ta̱ Leví tö iké̱wö tkö'wé̱ buaë chkè wa di'yè wa Jesús dalöioie. Inuköl shtökwakpa de tai̱ë. Ñies pë' kua̱'ki̱pa de, e'pa tulur chkök Jesús ena ittökatapa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mik fariseowakpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa tö isué̱, eta̱ ie'pa tö ichémi Jesús ttökatapa a̱: —¿Iö́k a' chköke di' yöke inuköl shtökwakpa ta̱ ena pë' sulusipa male̱pa ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús tö ie'pa iu̱té: —Wé̱pa kë̀ kirirku̱' esepa kë̀ ki̱ s'kapeyökwak kiane. Erë wé̱pa kirirke esepa ki̱ s'kapeyökwak kiane. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ye' kë̀ dë'bitu̱ wé̱pa e̱' bikeitsö̀ tö ise̱rke yësyësë esepa kiök. Ye' dë'bitu̱ pë' sulusipa kiök a̱s ie'pa e̱r mane'ù̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Judiopa wökirpa we̱lepa tö iché Jesús a̱: —Juan S'wöskuökwak ttökatapa batsöke tai̱ë, ttöke S'yë́ ta̱ tai̱ë, we̱s fariseowakpa klépa tö iwe̱ke es, erë be' ichapa chköke ena di'yöke ke̱kraë kë̀ batsöta̱'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús tö ie'pa iu̱té: —Mik s'kiule ulabatsè ké̱wö tkö'u̱k ta̱ ¿we̱s ie'pa batsö̀mi wëm ulabatske ese tso'ia̱ ie'pa ta̱ e' dalewa? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Erë iké̱wö döraë eta̱ ie' mi'datse̱r ie'pa yöki̱. E' je' ta̱ ie'pa batsöraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ñies Jesús tö ie'pa wöbla'wé̱ tö judiowak ttè këchke e' kë̀ shu̱tu̱rpaka̱ ie' ttè pa̱'a̱li̱ ta̱. E' kleéitö ttè i' wa: —Kë̀ yi tö datsi' pa̱'a̱li̱ tak teepa batsèwa̱ datsi' këchke wöyuowa̱ie. Iwé̱sö es, e' ta̱ e' tö datsi' pa̱'a̱li̱ we'ikéwa, ñies itak pa̱'a̱li̱ kë̀ mène buaë datsi' këchke ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ñies vino pa̱'a̱li̱ kë̀ tërta̱'ka̱ iyiwak kkuölit yöule ibloie ese këchke a̱. Itéka̱sö es, e' ta̱ mik ibacha'nebitu̱, eta̱ ikkuölit këchke jchèemiitö. Es vino ena ikkuölit weirwami ë́me. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","E' kue̱ki̱ vino pa̱'a̱li̱ tekeka̱ ikkuölit pa̱'a̱li̱ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yi tö vino bacha'bacha yeke, ese tö ibikeitseke tö e' ya' bua' vino pa̱'a̱li̱ tsa̱ta̱. E' kue̱ki̱ ie' kë̀ é̱na vino pa̱'a̱li̱ yakia̱. Es ñies a' tö ibikeitseke tö ye' ttè pa̱'a̱li̱ e' kë̀ dör buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Etökicha ta̱ e̱no diwö a̱ Jesús dami trigo shu̱a̱ ta̱ ittökatapa tö trigo wöiklérami ta̱ iwösié̱itö irikirik ulà wa ta̱ ikatéramirakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Eta̱ fariseowakpa we̱lepa tö ie'pa a̱ ichaké: —¿Ì kue̱ki̱ a' tso' ì kë̀ ké̱wö ta̱' wè̱ e̱no diwö a̱ ese u̱k? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús tö ie'pa iu̱té: —Ì o̱' David tö ká̱ ia̱ia̱ë ¿e' kë̀ a̱ritsule a' wa̱ Skëköl yëkkuö ki̱? Etökicha ta̱ ie' ena iklépa dué bli wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ie' dë'wa̱ Skëköl wé a̱ ta̱ pan meule Skëköl a̱ e' klö'wé̱itö ñéitö. Ñies ie' tö iblaté iklépa a̱ ta̱ inérakitö. Sacerdotepa ë̀ a̱ pan e' ké̱wö ta̱ ñè. Erë a' é̱na ia̱ne tö ì o̱' David tö ñe' kë̀ dör suluë Skëköl wöa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ñies Jesús tö iché ie'pa a̱: —Ye' dör S'ditsö Alà, e' wa̱ ka̱wö ta̱' ichoie tö ì dör buaë ö ì dör suluë wè̱ e̱no diwö a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","E̱no diwö skà ta̱ Jesús dewa̱ judiowak ñì dapa'wo̱ wé a̱ ta̱ ee̱ ie' tö s'wöbla'wé̱mitke. Ta̱ ee̱ wëm detkër eköl e' ulà bua'kka siulewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","S'wöbla'u̱k ttè dalöiëno wa wakpa ena fariseowakpa é̱na ie' kkatak ilè ki̱, e' kue̱ki̱ ie'pa tso' ie' weblök tö wëm ñe' bua'wè̱mineitö e̱no diwö a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Erë ì bikeitseke ie'pa tö, e' sué̱wa̱ ie' tö, e' kue̱ki̱ ie' tö iché wëm ulà siulewa̱ e' a̱: —Be' e̱' kö́ka̱ ta̱ be' e̱' duö́se̱r í̱e̱ sulitane wösha̱ë. Eta̱ wëm e̱' duése̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús tö iché ie'pa a̱: —A' chakèyö: ¿Ì ké̱wö ta̱' se' a̱ wè̱ e̱no diwö a̱: ì buaë ö ì suluë? ¿S'tsa̱tkök ö s'ttökwa̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","E' ukuöki̱ ta̱ ie' tö ie'pa ulitane weblé e̱' pamik ta̱ ichéitö wëm ulà siulewa̱ e' a̱: —Be' ulà shu̱lö́ö. Ta̱ ie' tö iwé̱ es eta̱ iulà buanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","E' tö ie'pa uluwé̱ka̱ tai̱ë, ta̱ iñi chakérak, ¿we̱s se' tö Jesús wè̱mi? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","E' ké̱wö ska' ta̱ Jesús mía̱ ka̱bata a̱ ttök S'yë́ ta̱, ee̱ ie' tté ie' ta̱ nañeë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mik ká̱ ñine, eta̱ ie' tö ittökatapa kié dapa'wé̱ ie' ta̱. E' shu̱a̱ ie' tö wëpa shu̱shté dabom eyök kí̱ böl (12), e'pa kiéitö ittekölpa tsá̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ie'pa kiè i' es: Simón, e' kiè méka̱ Jesús tö Pedro; Andrés dör Simón ël, Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Santiago dör Alfeo alà, Simón kine Celote, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas dör Santiago alà ena Judas Iscariote tö Jesús wömekettsa̱ ibolökpa a̱ e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús bite̱a̱tkene ka̱bata a̱ ittekölpa tsá̱ e'pa ta̱, e' e̱' wöklö'wé̱ ka̱kkue ki̱. Ee̱ iklépa tso' tai̱ë ie' panuk. Ñies pë' datse̱ Judea ena Jerusalén, esepa de tai̱ë. Ñies pë' de tai̱ë datse̱ Tiro ena Sidón. Ká̱ böt e' a̱te̱ dayë kkömik. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ie'pa ekkëpa ko̱s debitu̱ Jesús tö s'wöbla'we̱ke e' ki̱ttsök ñies a̱s ikirirkerak e' bua'u̱neitö. Ñies wé̱pa tteke wimblupa sulusi tö esepa bua'wé̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tai̱ë diché tso' ie' a̱ e' wa s'kirirke ko̱s e' buanene, e' kue̱ki̱ sulitane é̱na ie' kakwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús tö ittökatapa weblé ta̱ ichéitö ie'pa a̱: “A' wé̱pa dör sia̱rë kë̀ wa̱ ì ta̱' tai̱ë, esepa tso' ì blúie Skëköl tso' e' a̱, e' kue̱ki̱ ayëcha buaë a'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“A' wé̱pa tteke bli tö ká̱ i' a̱, esepa ttsë'rdaë dö̀ wë', e' kue̱ki̱ ayëcha buaë a'. “A' wé̱pa i̱u̱ke ká̱ i' a̱, esepa ja̱ñurane buaë, e' kue̱ki̱ ayëcha buaë a'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ayëcha buaë mik pë' é̱na a' a̱r suluë, a' wateke, a' cheke suluë, a' cheke tö a' dör pë' sulusipa ye' dör S'ditsö Alà e' tté kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mik e' tköke a' ta̱, eta̱ kë̀ a' e̱rianuk. E' skéie a' ttsë'nú buaë. Aishkuö ta̱ ká̱ jaì a̱ ì buaë merdaë a' a̱ iskéie e' kue̱ki̱ a' ttsë'nú kaneë. Kë̀ a' é̱na ichökwa tö ká̱ ia̱ia̱ë ie'pa yë́pa bak Skëköl ttekölpa we'ikök es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Erë wëstela i̱na a' wa̱ íyi tso' tai̱ë ká̱ i' a̱ esepa ta̱, e' ukuöki̱ ta̱ kë̀ ì skà ta̱'ia̱ a' ttsë'wo̱ie buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Wëstela i̱na a' wa̱ íyi tso' tai̱ë ñè wë' i̱'ñe ta̱ esepa ta̱, e' ukuöki̱ ta̱ a' tterane bli tö. “Wëstela i̱na a' ja̱ñuke buaë ká̱ i' a̱ e'pa ta̱, e' ukuöki̱ ta̱ a' e̱riardaë, i̱u̱raë sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Wëstela i̱na a' ta̱ mik sulitane tö a' ki̱kéka̱, es ie'pa yë́pa bak ká̱ ia̱ia̱ë e'pa tö ka̱chökwakpa e̱' chö̀ tö ie'pa dör Skëköl ttekölpa, e'pa ki̱ka'ka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Erë a' tso' ye' ttö̀ ki̱ttsök, esepa a̱ ye' tö ichè: a' bolökpa dalëritsö́. Wé̱pa é̱na sulu a' a̱r, esepa a̱ ì buaë ú̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wé̱pa alibchöke a' ki̱, esepa a̱ a' e̱r buaë chö́. Wé̱pa tö a' cheke suluë esepa ki̱ ikiö́ S'yë́ a̱ tö iki̱mú. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Yi tö a' ppé a' a̱swö ki̱, e' ta̱ a' a̱swö etta mú ia̱ ppè. Yi tö a' paio ki̱kke̱ tsé̱mi, e' ta̱ ñies a' paio mú ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yi tö ilè kak kiè a' a̱, e' ta̱ imú ia̱. Yi wa̱ a' íyi mítse̱r, e' ta̱ kë̀ a' tö ikiökneia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","A' se̱nú s'male̱pa ta̱ we̱s a' ki̱ ikiane tö ie'pa se̱r a' ta̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Wé̱pa tö a' dalëritseke, esepa ë̀ ské dalëritseke a' tö, e' ta̱ ¿e' ki̱ Skëköl tö wëstela chèmi a' a̱? ¡Au! Ñies pë' sulusipa tö wé̱pa tö ie'pa dalëritseke, esepa ské dalëritseke. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wé̱pa tö ì buaë we̱ke a' a̱, esepa ë̀ a̱ a' tö iské we̱ke buaë, e' ta̱ ¿e' ki̱ Skëköl tö a' ki̱kèka̱mi? ¡Au! Ñies pë' sulusipa tö iwe̱ke es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A' tö íyi peiteke, wé̱pa klö'wé̱ a' tö tö imeraneitö, esepa ë̀ a̱, e' ta̱ ¿e' ki̱ Skëköl tö a' ki̱kèka̱mi? ¡Au! Ñies pë' sulusipa tö íyi peiteke ñì a̱, mik ie'pa tö iklö'wé̱ tö imerdane eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","A' bolökpa dalëritsö́. Ì buaë ú̱ ie'pa a̱, íyi peitö́ ie'pa a̱, kë̀ iské panane. A' tö iwe̱ke es, e' ta̱ Skëköl tö a' a̱ iské merane buaë. Ie' e̱r buaë chöke s'sulusipa a̱ ena wé̱pa kë̀ tö wëstela cheta̱' ie' a̱ esepa a̱. A' tö iwe̱ke es, e' ta̱ a' tö ikkacheraë tö moki̱ë a' dör ie' dör íyi ulitane tsa̱ta̱, e' ala'r. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","S'male̱pa sa̱ú̱ e̱r sia̱rë wa we̱s S'yë́ tö a' sue̱ke e̱r sia̱rë wa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kë̀ a' s'kichatök, e' ta̱ Skëköl kë̀ tö a' kichatepa. Kë̀ a' ichök yi a̱ tö Skëköl mú tö be' tsa̱iö̀, e' ta̱ Skëköl kë̀ tö a' tsa̱iepa. Ì sulu ko̱s wamblé ie'pa tö a' ki̱, ese nuí̱ olo'yö́ ie'pa ki̱, e' ta̱ a' nuì̱ olo'yeraë Skëköl tö a' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ko̱s a' tö ì mé s'male̱pa a̱, ekkë a' a̱ imerdane. E' kue̱ki̱ íyi kakmú s'male̱pa a̱, eta̱ iské merane Skëköl tö a' a̱. Erë ie' tö imerane a' a̱ tai̱ë we̱s dakö'ukuö wà ièsö chië wöti̱o̱ule buaë ikí̱ wà iè döka̱ ikkö̀ a̱ katötöë tsá̱ tkënettsa̱mitke es.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ñies Jesús tö ttè kleé ie'pa a̱ i' es: “¿Wé̱ a' wa̱ isu̱ule tö s'wöbla kë̀ wawër, ese tö eköl wöbla kë̀ wawër ese ulà ièmi? ¿E'pa kë̀ brutarmi bölë ka̱uk a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wé̱ wöblarke ese kë̀ dör iwöbla'u̱kwak tsa̱ta̱. Mik iwöblao̱ne, e' je' ta̱ idöraë we̱s iwöbla'u̱kwak es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kaltak jche̱la tsir tso' a' yami wöbla a̱, ese sué̱ a' tö, erë ¿ì kue̱ki̱ kaltak bërie tso' a' wák wöbla a̱, ese kë̀ su̱ne a' wa̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿We̱s a' ichèmi a' yami a̱: ‘A yami, sú̱yö kaltak jche̱la tsir tso' be' wöbla a̱, e' yèttsa̱’? Erë kaltak bërie tso' a' wöbla a̱, e' kë̀ su̱ne a' wa̱. ¡A' e̱' ö̀ suluë! Kaltak bërie tso' a' wöbla a̱, ese yö́ttsa̱ ke̱we, es kaltak jche̱la tsir tso' a' yami wöbla a̱, ese wërmi a' a̱ buaë yèttsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kal buaë kë̀ wörta̱' kalwö suluie, ñies kal sulusi kë̀ wörta̱' kalwö bua'ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kal wërkewa̱ iwö ki̱. Higowö ö uvawö ese kë̀ shteta̱'sö dika' kicha mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ì bikeitsekesö, ese ë̀ chekesö. E' kue̱ki̱ wëm dör buaë, ese e̱r dör buaë, e' kue̱ki̱ ie' se̱rke buaë, ttö̀ yësyësë. Erë wëm dör suluë, ese e̱r dör suluë, e' kue̱ki̱ ie' se̱rke suluë, ttö̀ suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Ì kue̱ki̱ a' tö ye' kieke: ‘A Skëkëpa, a Skëkëpa,’ erë kë̀ a' tö ye' ttè iu̱teku̱'? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yi datse̱ ye' ska', ta̱ ye' ttö̀ ttseke ta̱ iwà iu̱teke, sú̱yö a' a̱ ichè tö we̱s ese dör. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ese dör we̱s wëm eköl tö u yué es. E' tö u chkí töbié i̱ski̱ë, ká̱ dör ák ë̀, ese a̱. Mik di' pone tai̱ë, tkami u ki̱ tai̱ë, erë u kë̀ minetse̱r iwa̱, iyöule buaë e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Erë yi tö ye' ttö̀ ttsé erë kë̀ iwà iu̱teku̱', ese dör we̱s wëm eköl tö u yué, erë kë̀ wa̱ itöbinewa̱ i̱ski̱ë, tkéka̱itö jalëjalë íyök ë̀ bata ki̱ es. Mik di' pone tai̱ë e' tkami u ki̱, eta̱ u mítse̱r iwa̱, kë̀ ì a̱te̱ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mik Jesús tö s'wöbla'wé̱ o̱ne, eta̱ imía̱ demi Cafarnaúm. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Eta̱ ee̱ Roma ñippökwakpa döka̱ cien, e' wökir se̱rke eköl. E' kanè méso eköl kirinewa̱ tai̱ë duökewa̱tke. Iwökir é̱na ie' dalër tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mik ñippökwakpa wökir tö Jesús tté ttsé, eta̱ ie' tö iché judiowak kue̱blupa we̱lepa a̱: “A' yú Jesús ska' ta̱ ichö́ ie' a̱: ‘Be' we'ikè sa' tö, be' shkö́ ñippökwakpa wökir, e' kanè méso eköl duöke tai̱ë, e' bua'u̱kne.’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Mik ie'pa demi Jesús ska' ta̱ ikköchérak tai̱ë ie' wöa̱: —Ñippökwakpa wökir e' é̱na se' judiowak dalër tai̱ë. Ie' wák tö se' ñì dapa'wo̱ wé e' yuök patkë' se' a̱. E' kue̱ki̱ sa' a̱ ta̱ buaë idir tö be' ie' ki̱mè. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Eta̱ Jesús mía̱ ie'pa ta̱. Erë mik ie'pa dökemitke ñippökwakpa wökir e' u a̱, eta̱ ie' tö iyamipa we̱lepa patké ichök Jesús a̱: “A këkëpa, kë̀ be' e̱' tsiriu̱k. Be' dör këkë tai̱ë, e' döwa̱ ye' u a̱, e' kë̀ dör ye' sia̱rla e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","E' kue̱ki̱ ye' kë̀ dë'rö be' ska'. Erë iké̱wö ë̀ mú ta̱ ye' kanè méso buardane. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ye' wökirpa ta̱', e'pa ttö̀ iu̱tök ye' ka̱wöta̱. Ñies ye' dör ñippökwakpa tai̱ë e'pa wökir, ie'pa ka̱wöta̱ ye' ttö̀ iu̱tök. Mik ye' tö eköl a̱ icheke, ‘Be' yú’ ta̱ imí. Eköl a̱ ye' tö icheke, ‘Be' dou’ ta̱ ide. Ñies ye' tö icheke ye' kanè méso a̱, ‘Íyi ú̱’ ta̱ iwé̱itö. Ye' iklö'wé̱ tö be' wa̱ ka̱wö ta̱' íyi ulitane tsa̱ta̱, e' kue̱ki̱ ye' wa̱ ijche̱r tö be' tö iké̱wö mé, e' ta̱ ye' kanè méso buardane.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mik Jesús tö ttè e' ttsé, eta̱ e' tö ie' tkiwé̱wa̱. Ie' wötréene ta̱ ichéitö pë' dami ie' itöki̱ e'pa a̱: —Ye' ichè a' a̱ tö Israel aleripa ko̱s shu̱a̱, kë̀ yi ku̱ne ye' wa̱ e̱rblök ye' mik we̱s wëm i' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Eta̱ mik ñippökwakpa wökir yamipa dene u a̱, eta̱ ie'pa tö isué̱ tö ikanè méso kirirke, e' buanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","E' ukuöki̱ ta̱ Jesús mía̱ ká̱ kiè Naín ee̱. Ie' dami ittökatapa ta̱, ñies pë' dami ie'pa ta̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mik ie'pa de tsi̱net ká̱ e' a̱, eta̱ ie'pa isué̱ tö tai̱ë pë' datse̱, e' wa̱ s'nu datse̱ micho wötèwa̱. Dëu̱tö e' mì dör schö́, ie' alà eköl ë̀me wëm, e' blënewa̱. Tai̱ë ká̱ e' wakpa tö ie' pablerami. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mik Skëkëpa Jesús tö isué̱, eta̱ ie' wa iwër sia̱rë ta̱ ichéitö ia̱: —Kë̀ be' i̱u̱kia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","E' bet ta̱ ie' dewa̱ tsi̱net ka̱'la ki̱ s'nu dami e' o̱'mik ta̱ ka̱'la kéitö. Wé̱pa wa̱ idami e'pa e̱' wöklö'wé̱wa̱. Jesús tö iché s'nu a̱: —A duladula, be' a̱ ye' tö ichè, ¡Be' e̱' kö́ka̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","E' bet ta̱ s'nu shke̱neka̱ne e̱' tkése̱r ta̱ itté. Eta̱ Jesús tö imé imì a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ko̱s pë' tso' ie'pa ta̱ e'pa suane tai̱ë, Skëköl ki̱kéka̱ ie'pa tö tai̱ë ta̱ ichérakitö: —Skëköl tteköl chö́k eköl, e' de se' shu̱a̱. Ñies ie'pa tö iché: —Skëköl de se' dör ie' icha esepa ki̱muk. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Eta̱ ì wé̱ Jesús tö e' tté buneka̱ tai̱ë Judea ké̱ ko̱s e' a̱, ñies ká̱ tso' Judea pamik e' a̱ itté ti̱neka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan S'wöskuökwak ttökatapa tö ì ko̱s we̱ke Jesús tö, e' paké Juan tso' s'wöto wé a̱ e' a̱. E' kue̱ki̱ ie' tö ie'pa böl kié ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ta̱ ichéitö ie'pa a̱: —A' yú Skëkëpa Jesús a̱ ichakök tö ¿be' dör wé̱ pairine'bitu̱ idi' wa s'blúie yëule tö idatse̱ e', ö yi skà panèia̱ sa' tö? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mik ie'pa de Jesús ska' ta̱ ie'pa tö iché ie' a̱: —Juan S'wöskuökwak tö sa' patké be' a̱ ichakök tö ¿be' dör wé̱ pairine'bitu̱ idi' wa s'blúie yëule tö idatse̱ e', ö yi skà panèia̱ sa' tö? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","E' wösha̱ ta̱ Jesús tö s'kirirke duè tsa̱ki̱ë wa̱, esepa bua'wé̱ tai̱ë. Ñies s'tteke wimblupa sulusi tö, ena s'wöbla kë̀ wawër esepa bua'wé̱itö tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","E' ukuöki̱ ta̱ ie' tö iché Juan ttökatapa böl a̱: —A' yúne Juan ska' ta̱ ì sué̱ a' tö, ì ttsé a' tö, e' ko̱s pakö́ ie' a̱. Ichö́ ie' a̱ tö s'wöbla kë̀ wawër esepa wöbla wawënene; s'kraulewa̱ kë̀ shko esepa shkéne; wé̱pa kiri'we̱ke lepra tö esepa buanene batse'nene; s'kukuö̀ kë̀ wattsër esepa wattsënene; s'duowa̱ shke̱neka̱ne; ñies Skëköl ttè buaë e' pakane s'sia̱rëpa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Yi kë̀ yöki̱ ye' sulune, ayëcha buaë ese! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mik ie'pa míyalne, eta̱ Jesús tö Juan tté pakémitke pë' a̱, ta̱ ichéitö ie'pa a̱: “Mik a' dë'rö ká̱ sir poë wé̱ kë̀ yi se̱rku̱' ee̱ Juan sa̱u̱k, eta̱ ¿i̱ma a' e̱rbikö̀ wëm wé̱se suè̱mi a' tö? A' kë̀ dë'rö wëm ëse, ka̱bikeitsö̀ wì̱ a̱ dià a̱ we̱s kua'kö wöppè siwa̱' tö es, ese sa̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","A' kë̀ dë'rö wëm ese sa̱u̱k, e' ta̱ ¿wëm wé̱se sa̱u̱k a' dë'rö? A' kë̀ dë'rö wëm e̱' paiö̀ datsi' bua'bua wa, ese sa̱u̱k. A' wa̱ ijche̱r tö wé̱pa e̱' paiö̀ es ena íyi bua'bua tso' iwa̱ tai̱ë e̱' ttsë'wo̱ie buaë, esepa se̱rke blu' u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Erë ¿wëm wé̱se sa̱u̱k a' dë'rö? A' dë'rö wëm dör Skëköl tteköl ese sa̱u̱k. Ye' tö a' a̱ ichè tö moki̱ Juan dör Skëköl tteköl, erë ie' kë̀ dör e' ë̀. Ie' dör Skëköl tteköl ese tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Skëköl yëkkuö ki̱ itso' kitule wé̱ Skëköl tö ichè wé̱ pairi'bitu̱itö idi' wa s'blúie e' a̱, e' tö ichè i' es: ‘Ye' tso'tke ye' ttè pakökwak patkök be' yöki̱ ke̱we be' ñalé̱ yuök.’ Skëköl ttè pakökwak e' dör Juan. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ye' ichè a' a̱ tö s'ditsö ulitane shu̱a̱, kë̀ yi ku̱' Juan tsa̱ta̱. Erë ì blúie Skëköl tso', e' shu̱a̱ yi dör ësela, ese dör ie' tsa̱ta̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Mik pë' ulitane ñies inuköl shtökwakpa Roma wökirpa a̱, e'pa tö Jesús s'wöbla'we̱ke e' ttsé, eta̱ ie'pa tö iché tö Skëköl ttè dör yësyësë. Ie'pa dë' a̱s Juan tö ie'pa wöskuö̀ iwà kkachoie tö ie'pa tö Juan ttè klö'wé̱, e' kue̱ki̱ ie'pa tö iché es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Erë fariseowakpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa kë̀ wa̱ Juan ttè klöo̱ne, e' kue̱ki̱ ie' kë̀ wa̱ ie'pa wösune, es ie'pa tö Skëköl e̱r buaë chöke ie'pa a̱ e' watéttsa̱.) ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús tö iché: “¿I̱ma a' chèmi ye' tö? ¿We̱s a' dör? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","A' dör we̱s ttè i' tö ichè es: Ala'rla tso' inuk u itöki̱. Sha̱bötspa a̱rke tai̱ë ta̱ iché iyamipa a̱: ‘Sa' tö pulë bla'wé̱, erë a' kë̀ klötëne'; sa' tö s'e̱riar ttseittsé, erë a' kë̀ i̱i̱ne'.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","E' wà dör tö Juan S'wöskuökwak de batsöta̱', kë̀ blo' yeta̱' ta̱ a' tö iché tö aknama tso' ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","E' ukuöki̱ ta̱ ye' dör S'ditsö Alà, e' de kë̀ batsöta̱', blo' yeta̱', ta̱ a' tö ye' cheke tö ye' chkö̀ tai̱ë, blo' yè tai̱ë, ñies tö ye' dör inuköl shtökwakpa ena pë' sulusipa male̱pa, esepa sini'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","A' tö ye' cheke es erë isue̱rasö bulebök ta̱ tö wé̱pa se̱rke we̱s Skëköl siwé̱ tö ichè es, esepa dör yësyësë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseowak eköl kiè Simón, e' tö Jesús kié chkök ie' u a̱. E' kue̱ki̱ Jesús mía̱ ie' ska' ta̱ ie'pa e̱' tulése̱r chkök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Eta̱ alaköl sulusi se̱rke ká̱ e' a̱, e' wa̱ ijche̱newa̱ tö Jesús tso' chkök fariseowak e' u a̱. Ie' wa̱ kiö̀ masmas de e' ukkuö yöule ák bua'bua kiè alabastro ese wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ie' de dur Jesús ska', e' i̱u̱ke Jesús tsi̱kka, iwöriö yënane tai̱ë Jesús klö̀ ki̱, e' pasiwé̱itö itsà̱ wa, ta̱ Jesús klö̀ wöalattsémiitö ta̱ kiö̀ masmas téitö Jesús klö̀ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mik fariseowak tö Jesús kié chkök e' tö alaköl sué̱, eta̱ ibikeitséitö: “Wëm wí̱ mú dör Skëköl tteköl moki̱, e̱'ma ie' é̱na ia̱rmi alaköl wé̱se tso' ie' kök. Ie' é̱na ia̱rwa̱mi tö e' dör alaköl sulusi.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesús iché ie' a̱: —A Simón, ilè tso' ye' wa̱ yënoie be' a̱. Ie' iiu̱té: —A s'wöbla'u̱kwak, ichö́ ña. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús tö iché: —Wëm böl ñarke inuköl peitökwak ulà a̱. Eköl ñarke cien ske̱yök (500), iëköl ñarke dabom ske̱yök (50). ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ie'pa böl kë̀ a̱ ipato̱r, e' kue̱ki̱ inuköl peitökwak tö inuì̱ olo'yé ie'pa ki̱. Ye' tö be' a̱ ichakè tö ie'pa böl, ¿wé̱ne ë́k é̱na inuköl peitökwak dalërmi kibiie? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ie' iiu̱té: —Ye' a̱ ta̱, wé̱ne nuì̱ olone kibiie e' ë́k. Jesús tö iché: —Buaë be' iiu̱té. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Eta̱ Jesús tö alaköl sué̱ ta̱ ichéitö Simón a̱: —Alaköl i' sa̱ú̱. Mik ye' dewa̱ be' u a̱, eta̱ be' kë̀ wa̱ ye' a̱ di' mène ye' klö̀ skuoie, erë alaköl i' tö ye' klö̀ skué iwöriö wa ta̱ ipasiwé̱itö itsà̱ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Be' kë̀ wa̱ ye' shke̱o̱ne wöalattsè wa we̱s s'wöblar es. Erë ie' dewa̱ í̱e̱, eta̱ ie' tö ye' klö̀ wöalattsémi tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Be' kë̀ wa̱ kiö̀ ësela, e' tëne ye' wökir ki̱ we̱s s'wöblar es. Erë ie' tö kiö̀ masmas tuè̱ darërëë ese té ye' klö̀ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","E' kue̱ki̱ ye' ichè be' a̱ tö ie' é̱na ye' dalër tai̱ë e' wa iwënewa̱ tö ì sulu wamblé ie' tö tai̱ë, e' nuí̱ olone ie' ki̱. Erë wé̱pa kë̀ é̱na ye' dalërta̱' tai̱ë, e' wa iwënewa̱ tö esepa ki̱ inuì̱ olone elkela ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","E' ukuöki̱ ta̱ ie' iché alaköl e' a̱: —Ì sulu ko̱s wamblé be' tö e' nuí̱ olone be' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Imale̱pa kiule chkök ñies tso' ee̱, e'pa ñì chakérak: —A' ichè ¿yi ie' dör e' ttö̀ es? Skëköl ë̀ a̱ se' nuì̱ olo'yarmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Erë ie' tö alaköl a̱ iché: —Be' e̱rblé ye' mik, e' tö be' tsa̱tkée. Be' yúne bë̀rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","E' ukuöki̱ ta̱ Jesús mía̱ ì blúie Skëköl tso' e' tté buaë pakök ká̱ blublu ena ká̱ tsitsir tso' e' a̱. Ie' ttekölpa tsá̱ dabom eyök kí̱ böl, e'pa shköke ie' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ñies alakölpa we̱lepa buao̱'ne ie' tö, e'pa shköke ie' ta̱. E'pa we̱lepa bak weinuk wimblupa sulusi wa̱, ñies duè wa̱. Ie'pa eköl, kiè María Magdala wak, e' a̱ aknamapa yë'ttsa̱itö döka̱ kul. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ñies Juana dör Cuza alaköl, e' shköke ie' ta̱. Cuza dör Herodes dalì kkö'nukwak. Ñies Susana ena alakölpa male̱pa tai̱ë shköke ie' ta̱. Ie'pa tö Jesús ena ittökatapa ki̱meke tai̱ë, ì tso' ie'pa wa̱ ese wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pë' e̱' yélur iká̱ ki̱ debitu̱ tai̱ë Jesús ska'. Ie' tö ie'pa a̱ ittè kleé i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Wëm mía̱ eköl të kuatkök ta̱ ie' tö iwö ppé ululu të ki̱ Mik ie' tso' iwö ppök, eta̱ ditsöwö we̱le a̱newa ñala̱ ska' ta̱ pë' dakélor iki̱, e' tö iñatélur, ñies dù debitu̱ tö ikatéwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ditsöwö we̱le a̱newa áklo a̱ ta̱ e' kuölö ta̱ itskine buaë. Erë ká̱ tsabe kë̀ ta̱' ee̱, e' kue̱ki̱ bet ta̱ isinewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ditsöwö we̱le a̱newa dika'chka shu̱a̱. Dika'chka ena ditsöwö talane ñita̱, erë dika'chka e̱' aléka̱ iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Erë ditsöwö we̱le a̱ne íyök bua'bua ki̱, ese tskine talane wöne buaë. Iklö we̱le wöne döka̱ cien eyök (100) elka elka. Mik Jesús tö iché o̱ne, eta̱ ikí̱ chéitö ie'pa a̱ a̱neule: “¡A' é̱na ye' ttö̀ ttsak, e̱'ma ikukueblö́ bua'ie!” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesús ttökatapa tö ie' a̱ ichaké: —Ttè wakleébö, ¿i̱ma e' wà dör? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ie' tö iché ie'pa a̱: “Ì blúie Skëköl tso' e' tté blëulewa̱, e' ké̱wö menea̱t a' a̱ ijche̱noie. Erë pë' tso' tai̱ë kë̀ é̱na ye' ttè klö'wa̱k, esepa a̱ ye' tö ikleeke a̱s ie'pa tö iweblö̀ je', erë kë̀ ie'pa a̱ iwà wër, ñies a̱s ie'pa tö ittsö̀ je', erë kë̀ ie'pa a̱ iwà a̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ttè wakleéyö e' wà dör i' es: Skëköl ttè pakèsö e' dör we̱s ditsöwö kuatkèsö es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pë' we̱lepa ta̱ itkö̀mi we̱s itka ditsöwö a̱newa ñala̱ ska' ñe' ta̱ itka es. Esepa tö Skëköl ttè ttsé, erë bë́ de ie'pa ska' ta̱ iyéttsa̱itö ie'pa e̱r a̱ a̱s ie'pa kë̀ tö iklö'ù̱ ta̱ itsa̱tkër. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","We̱lepa skà ta̱ itkö̀mi we̱s itka ditsöwö a̱newa áklo a̱ ñe' ta̱ itka es. Esepa tö Skëköl ttè ttsé ta̱ iklö'wé̱rakitö ttsë'ne buaë wa erë ekuölö ë̀. Ie'pa kë̀ a̱ e̱' tkërwa̱ darërëë Skëköl ttè a̱. Mik ie'pa weinemitke ie' ttè kue̱ki̱, eta̱ ie'pa a̱nemine tottola. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","We̱lepa skà ta̱ itkö̀mi we̱s itka ditsöwö a̱newa dika'chka shu̱a̱ ñe' ta̱ itka es. Esepa tö Skëköl ttè ttsé, erë ie'pa tö íyi tso' ká̱ i' ki̱ e' bikeitseke kibiie. Ie'pa e̱r me'rie inuköl ena ì tso' ká̱ iki̱ tö s'ttsë'we̱ke buaë ese ki̱. Ese ko̱s tö Skëköl ttè kui'wé̱wa̱ ie'pa e̱r a̱, ta̱ ie'pa kë̀ se̱ne buaë Skëköl ttè a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Erë we̱lepa skà ta̱ itköke we̱s itka ditsöwö a̱newa íyök buaë ki̱ ñe' ta̱ itka es. Esepa tö Skëköl ttè ttsé ta̱ iklö'wé̱ e̱r buaë wa moki̱. Ie'pa tö iiu̱teke buaë ta̱ iwà dalöiekerakitö ke̱kraë. E' kue̱ki̱ ie'pa tö ì buaë ko̱s ese wé̱ we̱s Skëköl ki̱ ikiane es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Mik bö'wö wötskéka̱sö, eta̱ kë̀ sö ipabikepawa̱, kë̀ sö ipatkepawa̱ ka̱' diki̱a̱. E' skéie itkekeka̱ ká̱kke̱ s'yamipa datse̱ esepa wö a̱ ká̱ ñi'wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Es ñies ttè tso' blëulewa̱ i̱'ñe ta̱, ese jche̱rdawa̱ sulitane wa̱ aishkuö ta̱. Ì ché ye' tö, e' kë̀ wà a̱ne ie'pa é̱na i̱'ñe ta̱, erë e' wà a̱rdaë ie'pa é̱na aishkuö ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Yi e̱' yuak buaë ye' ttè wa, ese a̱ ikí̱ meraëyö a̱s ie' é̱na iwà a̱r buaë. Erë yi kë̀ e̱' yuak ye' ttè wa, ì bikeitsé ese tö tö a̱ne ié̱na, e' ko̱s yërdattsa̱ne iyöki̱. E' kue̱ki̱ ye' ttö̀ kukueblö́ a' tö bua'ie.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Eta̱ Jesús mì ena iëlpa ena ikutapa e'pa debitu̱ ie' weblök. Erë ie' tkër wé̱ pë' tso' tai̱ë e' shu̱a̱, e' kue̱ki̱ ie'pa kë̀ dë'wa̱ ie' ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","E' biyö́ ché yile tö ie' a̱: —Be' mì ena be' ëlpa ena be' kutapa e'pa shkö̀ be' weblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ie' tö iiu̱té: —Ëkëkë, erë ye' tö a' a̱ ichè tö wé̱pa tö Skëköl ttè ttsé ta̱ iwà iu̱téitö, esepa dör we̱s ye' mì ena ye' ëlpa ena ye' kutapa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Etökicha ta̱ Jesús e̱' iéka̱ kanò a̱ ittökatapa ta̱, ta̱ ichéitö ie'pa a̱: —Mishka batsöri wi̱she̱t. Eta̱ ie'pa míyal. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ie'pa mirwa̱ia̱ ta̱ ie' kapowa̱ kanò a̱. E' dalewa siwa̱' batsi̱neka̱ tai̱ë tö di' u̱yéka̱ tai̱ë ta̱ kanò a̱ di' iëneka̱mi katsi̱rkewa̱tke. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","E' kue̱ki̱ ie'pa tö iti̱'wé̱ka̱ ta̱ ichérakitö ia̱: —¡A s'wöbla'u̱kwak! ¡A s'wöbla'u̱kwak! ¡Se' duölurmi! Eta̱ ie' e̱' kéka̱ ta̱ siwa̱' ena di' yöli uñéitö ta̱ iwöklönewa̱ mía̱ne alamië. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","E' ukuöki̱ ta̱ ie' tö iché ie'pa a̱: —¿We̱s a' e̱rblöke ye' mik, e' de? Erë ie'pa suanéka̱ tai̱ë, tkinewa̱ tai̱ë ta̱ iñi chakéka̱: —¿Yi dör wëm wí̱? ¡E' ttö̀ dalöié di' tö ena siwa̱' tö! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","E' ukuöki̱ ta̱ ie'pa mía̱ demi ká̱ kiè Gerasa a̱te̱ batsöri wi̱she̱t Galilea wösha̱ë ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mik Jesús e̱' yéttsa̱ de ká̱ sí ki̱, eta̱ wëm eköl de ie' ska', e' a̱ aknamapa tso'. Ie' dör Gerasa wak. Ia̱ia̱ë ie' se̱ne'mi sume, kë̀ se̱rku̱'ia̱ u a̱, ie' se̱rke pö a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mik ie' tö Jesús sué̱, eta̱ ie' a̱neka̱ tai̱ë ta̱ ie̱' tkéwa̱ kuchë ki̱. Ie' iché Jesús a̱: —A Jesús, be' dör Skëköl dör íyi ulitane tsa̱ta̱ e' alà. ¿Iö́k be' de ye' tsiriu̱k? Ye' múa̱t bë̀rë. Ye' kköchö̀ tai̱ë be' a̱ tö kë̀ ye' we'ikar. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesús tö ichétke wimblu sulusi a̱ ke̱we: “Be' e̱' yö́ttsa̱ wëm se̱ a̱.” E' kue̱ki̱ wimblu tö ie' a̱ iché es. Ia̱ia̱ë ie' we'ikbitu̱ aknama tö. Ke̱kraë aknama tö ie' wö a̱li̱we̱ke. E' kue̱ki̱ pë' tö ie' mue̱ke iulà a̱ iklö a̱ tabechka daloie wa, erë e' batsélor ie' tö tottola ta̱ aknama tö ie' kí̱ a̱li̱wé̱ka̱ patkémi wé̱ kë̀ yi se̱rku̱' ese ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Eta̱ Jesús tö ie' a̱ ichaké: —¿I̱ma be' kiè? Ie' iiu̱té: —Ye' kiè Tai̱ë Wakpa. Ie' a̱ aknamapa tso' tai̱ë, e' kue̱ki̱ ie' tö iu̱té es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ie'pa kköchöke tai̱ë Jesús a̱: “Kë̀ sa' patkarmi ka̱uk tai̱ë tso' i̱ski̱ë e' a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tsi̱net ka̱bata kuli' a̱ köchi iëte̱r tai̱ë chkök, e' kue̱ki̱ wimblupa kköchöke Jesús a̱: “Ka̱wö mú sa' a̱ e̱' tiu̱kwa̱ köchipa jaì a̱.” Jesús tö iké̱wö mé ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Eta̱ ie'pa e̱' yélur wëm a̱ ta̱ ie̱' tié̱lur köchipa a̱. Köchi ko̱s poneka̱ tu̱nemirak ká̱ spé mik brutolonemi batsöri a̱ ta̱ ee̱ iduolur. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mik köchi kkö'nukwakpa tö isué̱, eta̱ itkayalmi ta̱ itté ppéka̱rakitö ká̱ e' wa'ñe. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pë' de tai̱ë iweblök tö ì tka. Mik ie'pa de Jesús ska', eta̱ wëm a̱ aknamapa yërulune tai̱ë, e' sué̱ ie'pa tö itkër Jesús wörki̱ datsi' iéne é̱na ká̱ a̱nene buaë. E' tö ie'pa suawé̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wé̱pa tö ì tka e' sué̱, e'pa tö ipaké ie'pa a̱ tö we̱s wëm a̱ aknamapa bak e' buanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ká̱ e' wakpa ulitane suane tai̱ë, e' kue̱ki̱ ie'pa kköché Jesús a̱: “Be' e̱' yö́ttsa̱ sa' ká̱ a̱.” Eta̱ Jesús e̱' iéka̱ kanò a̱ ittökatapa ta̱ ta̱ imía̱tke. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Eta̱ wëm a̱ aknamapa yërulune e' kköché Jesús a̱: “Ye' shkakmi be' ta̱.” Erë Jesús tö iiu̱té: —Au, be' e̱' tsú̱a̱t. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Be' yúne be' u a̱ ta̱ ì ko̱s wé̱ Skëköl tö be' a̱, e' pakö́ sulitane a̱. Ta̱ ie' mía̱, ta̱ ì ko̱s buaë wé̱ Jesús tö ie' a̱, e' pakéitö sulitane a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mik Jesús dene batsöri io̱she̱t, eta̱ pë' tso' tai̱ë ie' panuk, e' kue̱ki̱ ie'pa tö ie' kiéwa̱ ttsë'ne bua' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Eta̱ wëm eköl kiè Jairo e' de. Ie' dör judiowak ñì dapa'wo̱ wé e' wökir eköl. Ie' e̱' té̱wa̱ wöwakköt Jesús wörki̱ ta̱ ikköchöke tai̱ë ie' a̱: “Mishka bet ye' u a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jairo alà dör ekla ë̀ wák dör alaköl ki̱ duas tso' dabom eyök ki̱ bök ulatök (12), e' duökewa̱tke. Jesús miria̱, e' dalewa tai̱ë pë' dami, e' tërdami ie' mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","E'pa shu̱a̱ alaköl dami eköl e' du'mi alakölpa duè wa̱ e' ki̱ duas de dabom eyök ki̱ bök (12). Ì ko̱s tso' ie' wa̱ e' e̱wé̱waitö yës s'kapeyökwak ki̱, erë kë̀ yi a̱ ibuanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ie' dewa̱ tsi̱net Jesús tsi̱ kke̱r ta̱ idatsi' bata kéwa̱itö. E' wösha̱ ta̱ ipë́ wöklöne ta̱ ibuanene buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Eta̱ Jesús tö ichaké: —¿Yi tö ye' ké? Sulitane tö iché: —Kë̀ sa' wa̱ be' kàne. Pedro tö iché ia̱: —A s'wöbla'u̱kwak, pë' tso' tai̱ë e' tërdami be' mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Erë Jesús tö iché: —Ye' ittsé tö ilè tka ye' diché wa. E' kue̱ki̱ ye' wa̱ ijche̱r tö yile tö ye' ké. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mik alaköl buanene, e' tö isué̱ tö kë̀ ie' a̱ e̱' blënukia̱ ta̱ ide Jesús ska' painéka̱ tai̱ë suane wa. Ie' e̱' tkéwa̱ kuchë ki̱ Jesús wörki̱ ta̱ ie' e̱' chéka̱ sulitane kukua tö ì kue̱ki̱ Jesús kéwa̱itö. Ie' tö iché: “Mik ye' tö be' kéwa̱, e' wösha̱ë ta̱ ye' buanene.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús tö iché ia̱: —A alà busi, be' e̱rblé ye' mik, e' kue̱ki̱ be' buanene. Be' yúne bë̀rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ie' ttökeia̱ alaköl ta̱, e' dalewa eköl bite̱ Jairo u a̱, e' debitu̱ ta̱ iché Jairo a̱: —Be' alà busi blënewa̱tke. S'wöbla'u̱kwak kë̀ tsiriwa̱ria̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mik e' ttsé Jesús tö, eta̱ ie' tö iché Jairo a̱: —Kë̀ be' tkinuk. Be' e̱rblö́ ye' mik ë̀, be' alà busila buardane. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mik ie'pa de Jairo u a̱, eta̱ Jesús kë̀ wa̱ yi kàne shkökwa̱ wé̱ busila nu me'r ee̱. Pedro ena Santiago ena Juan ena alà yë́ ena imì, e'pa ë̀ kiéwa̱itö e̱' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","E' dalewa sulitane i̱u̱ke alárke tai̱ë. Erë Jesús tö ie'pa a̱ iché: —Kë̀ a' i̱u̱kia̱. Busila kë̀ du'wa̱, ikapöme'r ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Sulitane wa̱ ijche̱r tö busila duowa̱, e' kue̱ki̱ ie'pa tö ie' wayuéka̱ ja̱ñeitséka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Erë Jesús tö busila ulà klö'wé̱wa̱, ta̱ iché ie' a̱: —¡A tayëla, be' e̱' kö́ka̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Eta̱ ishke̱neka̱ne, e' bet ta̱ ie' e̱' kéka̱ ta̱ Jesús tö iché ie'pa a̱: —Itiö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iyë́ ena imì tkirulune iweblök. Eta̱ Jesús tö iché ie'pa a̱: —Ì tka í̱e̱, e' kë̀ char yi a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús tö ittökatapa dabom eyök kí̱ böl e'pa dapa'wé̱ ta̱ diché méitö ie'pa a̱ aknamapa ulitane trë'wo̱yal. Ñies ka̱wö méitö ie'pa a̱ s'kirirke bua'wo̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ipatkérak ì blúie Skëköl tso' e' tté buaë pakök ñies s'bua'u̱kne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ta̱ ie' tö iché ie'pa a̱: —Mik a' mi'ke, eta̱ kë̀ ì tsa̱rmi. Shko kéli, sku', íyi ñanoie, inuköl, datsi' skà, ese ko̱s kë̀ tsa̱rmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mik yile tö a' a̱ iché a' kapö́rö, eta̱ a' tso' ká̱ e' a̱ e' dalewa a' kapö́rö ie' u ë̀ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Eta̱ ká̱ we̱le wakpa kë̀ wa̱ a' kinewa̱, e' ta̱ a' e̱' yö́lur ká̱ e' a̱, ta̱ ka̱po tso' a' klöttö mik, e' ppö́ö a' tö. E' tö ie'pa a̱ ikkacheraë tö ie'pa dör Skëköl bolökpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Eta̱ ie'pa míyal judiowak ké̱ tsitsir ko̱s a̱ Skëköl ttè buaë pakök ñies s'kirirke bua'u̱kne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Herodes dör Galilea wökir, mik e' tö ì ko̱s we̱ke Jesús tö e' tté ttsé, eta̱ ie' tö ibikeitséka̱ tai̱ë tö yi dör Jesús. We̱lepa tö icheke tö Jesús dör Juan S'wöskuökwak köte̱wa̱ e' shke̱neka̱ne. We̱lepa tö icheke tö ie' dör Skëköl tteköl bak kiè Elías e' shke̱neka̱ne. We̱lepa tö icheke tö ie' dör Skëköl ttekölpa skà bak esepa we̱le shke̱neka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Erë Herodes tö iché: —Ye' wák tö Juan kuli' tökök patkë', e' ta̱ wëm tté ttséyö tso' íyi u̱k tai̱ë s'tkiwè̱ ekkë ¿e' dör yi? E' kue̱ki̱ Herodes é̱na suluë Jesús sua̱kwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mik Jesús ttekölpa tsá̱ e'pa dene, eta̱ ì ko̱s wé̱ ie'pa tö, e' pakéne ie'pa tö Jesús a̱. Eta̱ Jesús tö ie'pa kiémi e̱' ta̱ dö̀ tsi̱net ká̱ kiè Betsaida wé̱ kë̀ yi se̱rku̱' ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Erë mik pë' male̱pa wa̱ ijche̱newa̱, eta̱ ie'pa mí itöki̱ ta̱ ie'pa kiéwa̱itö buaë. Ì blúie Skëköl tso' e' tté buaë paké ie' tö ie'pa a̱ ñies s'kirirke bua'wé̱neitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mik ká̱ tuirketke, eta̱ Jesús ttökatapa dabom eyök kí̱ böl (12) e'pa de ie' ska' ta̱ ichérakitö ia̱: —Ká̱ i' ki̱ kë̀ ì ku̱' katanoie ñanoie, e' kue̱ki̱ ie'pa yuö́mi a̱s ie'pa mi' ká̱ tso' tsi̱net ena pë' se̱rke tsi̱net esepa ska' chkè ta̱u̱k ñè ena kapökrö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús tö ie'pa a̱ iché: —Ie'pa tiö́ a' tö. Ie'pa tö iiu̱té: —Sa' wa̱ pan ske̱l ena nima bötö e' ë̀ tso'. Kë̀ sa' mìne ikí̱ ta̱u̱k, e' ta̱ ì tso' sa' wa̱ e' kë̀ dökka̱ ie'pa tai̱ë ekkëpa tioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wëpa tso' ee̱ döka̱ mil ske̱yök (5000), e' kue̱ki̱ ittökatapa tö iché es. Erë Jesús tö ie'pa a̱ iché: —A' tö ie'pa kö́ e̱' tkökse̱r i̱ski̱ ek tsi̱ní ek tsi̱ní dabom ske̱yök (50) dabom ske̱yök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Es ie'pa tö iwé̱ ta̱ pë' ulitane e̱' tkése̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","E' ukuöki̱ ta̱ ie' tö pan ske̱l ena nima bötö, e' klö'wé̱ ta̱ iká̱ sué̱ ká̱ jaì a̱ ta̱ wëstela chéitö Skëköl a̱. E' ukuöki̱ ta̱ ie' tö pan ena nima blaté mé ittökatapa a̱ a̱s ie'pa tö iwatiö̀ pë' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mik ie'pa chké de wë', eta̱ ibata a̱te̱, e' shtérakitö iëne döka̱ kkö́la dabom eyök ki̱ bök (12). ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Etökicha ta̱ Jesús tso' ittökatapa ë̀ ta̱. Ie' tso' S'yë́ ta̱ ttök, ta̱ ee̱ ie' tö ie'pa a̱ ichaké: —¿I̱ma pë' tö ichè tö ye' dör yi? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ie'pa tö iiu̱té: —We̱lepa tö icheke tö be' dör Juan S'wöskuökwak. We̱lepa skà tö icheke tö be' dör Skëköl tteköl bak kiè Elías e' shke̱neka̱ne. We̱lepa skà tö icheke tö be' dör Skëköl ttekölpa bak ká̱ ia̱ia̱ë e' we̱le shke̱neka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ie' tö ie'pa a̱ ichaké: —Erë ¿i̱ma a' ichè, ye' dör yi? Pedro tö iiu̱té: —Be' dör wé̱ pairine'bitu̱ idi' wa sa' blúie e'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Erë Jesús kë̀ wa̱ ie'pa kàne yi a̱ ichök yi dör ie'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ñies ie' tö iché: —Ye' dör S'ditsö Alà, e' weirdaë tai̱ë. Judiowak kue̱blupa ena sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa tö ye' waterattsa̱. Ye' tterawa̱, e' ki̱ ká̱ de mañat eta̱ ye' shke̱rdaka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","24","E' ukuöki̱ ta̱ ie' tö iché ie'pa ulitane a̱: —Yi e̱' tsa̱tkak ittèwa̱ yöki̱, ese kë̀ ulà a̱ se̱ne michoë dö̀pa. Erë yi e̱' mettsa̱ ttèwa̱ ye' dalërmik, ese ulà a̱ idöraë. E' kue̱ki̱ yi e̱' yuak ye' ttökataie, ese kë̀ kàne tkinukia̱ e̱' ki̱. E' skéie ke̱kraë ika̱wöta̱ e̱' chök dö̀ ittèwa̱ wötëulewa̱ krus mik ekkë. Es ie' ka̱wöta̱ shkök ye' itöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Íyi ulitane tso' ká̱ i' a̱, e' de a' ulà a̱, erë se̱ne michoë kë̀ dë' a' ulà a̱, e' ta̱ e' dör ¿ìie bua' a' a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mik ye' dör S'ditsö Alà, e' dene ye' olo wa, ñies ye' Yë́ olo wa, ñies ibiyöchökwakpa batse'r e'pa olo wa, eta̱ wé̱pa jaëne ye' ki̱, esepa ki̱ ye' jaërdaë ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Moki̱ ye' tö a' a̱ ichè tö a' tso' í̱e̱, e' we̱lepa tö ì blúie Skëköl tso' e' sue̱raë ka̱m iblërulur e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","E' ki̱ ká̱ de pàköl (8) ulatök, eta̱ Jesús mía̱ ka̱bata a̱ ttök S'yë́ ta̱. Pedro ena Juan ena Santiago e'pa mítse̱r iwa̱ e̱' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ie' tso' ttök S'yë́ ta̱, eta̱ iwö manenettsa̱ mía̱ kua̱'ki̱ dalölöë ñies idatsi' mía̱ saruruë wöñarke dalölöë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","E' wösha̱ ta̱ wëpa de iëte̱r böl tso' ttök ie' ta̱. Ie'pa dör Skëköl ttekölpa bak ká̱ ia̱ia̱ë kiè Moisés ena Elías e'pa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ie'pa olo buneka̱ tai̱ë dalölöë. Ie'pa iëte̱r ka̱pakök Jesús ta̱ we̱s ie' tterawa̱ pë' tö Jerusalén a̱s iwà tkö̀ we̱s Skëköl ki̱ ikiane es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro ena iyamipa böl, e'pa tteke kapèwa̱ tö tai̱ë. Erë mik ie'pa ti̱'neka̱ne bua'ie, eta̱ ie'pa tö Jesús olo tai̱ë e' sué̱, ñies wëpa böl iëte̱r ttök ie' ta̱ e'pa sué̱rakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mik Moisés ena Elías mitkene, eta̱ Pedro tö iché Jesús a̱: —A S'wöbla'u̱kwak, buaë se' tso' í̱e̱. Sú̱ sa' tö úla yuèka̱ mañatkuela, etkue be' a̱, etkue Moisés a̱, etkue Elías a̱. Erë ì cheke Pedro tö e' wà kë̀ a̱ne ie' é̱na. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro ttökeia̱, e' wö shà̱ ta̱ mochka tö ie'pa ki̱téwa̱. E' tö ie'pa suawé̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mochka shu̱a̱ ie'pa tö ttö̀ ttsé tö ichè: “Se̱ dör ye' alà, e' pairi'bitu̱bak ye' tö idi' wa a' blúie. Ie' ttö̀ iu̱tö́.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mik ie'pa tö ttè e' ttsé, eta̱ ie'pa tö isué̱ tö Jesús a̱te̱ dur ekörla. Erë ì ttsé ie'pa tö, ì sué̱ ie'pa tö, e' blé ie'pa tö ie̱r a̱, kë̀ ie'pa wa̱ ipakane yi a̱ dö̀ aishkuö ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bule es ta̱ ie'pa tso' ka̱bata a̱ e'pa bite̱yal, eta̱ tai̱ë pë' de Jesús ñale̱tsu̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","E' shu̱a̱ wëm tso' eköl, e' tö iché a̱neule: —A s'wöbla'u̱kwak, be' we'ikèyö, ye' aladulaköl sa̱ú̱, e' dör ye' alà eköl ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mik wimblu sulusi tö ie' é̱na ká̱ chöwé̱wa, eta̱ ie' a̱neka̱ tai̱ë, painéka̱ katötöë, ta̱ ikkö̀ a̱ ishuya deka̱ tai̱ë. Ke̱kraë ie' we'ikekeitö sia̱rë. Wimblu kë̀ é̱na ie' akwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ye' kköché tai̱ë be' ttökatapa a̱ tö wimblu trë'ú̱shkar erë kë̀ ie'pa a̱ io̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús tö iché ie'pa ulitane a̱: —A' wakpa kë̀ e̱rblöta̱' Skëköl mik, a' kë̀ é̱na ká̱ a̱ne. ¿Mik ye' se̱rmirö a' ta̱? ¿Ko̱s ye' tö a' dalë'ttsemirö? Be' alà tsú̱bitu̱ ña. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mik duladula de tsi̱net, eta̱ aknama tö ie' é̱na ká̱ chöwé̱wa kéu̱ i̱ski̱ ta̱ ipaineka̱ tai̱ë. Erë Jesús tö wimblu sulusi uñé trë'wé̱shkar ta̱ duladula bua'wé̱neitö méneitö iyë́ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ì buaë wé̱ Skëköl tö idiché tai̱ë wa e' tö ie'pa ulitane tkiwé̱wa̱. Ì buaë wé̱ Jesús tö, e' chekeia̱ ie'pa tö ñì a̱, e' dalewa ie' tö iché ittökatapa a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ì cheke ye' tö a' a̱, e' ttsö́ buaë, kë̀ a' é̱na ichökwa: Ye' dör S'ditsö Alà, e' wömerdattsa̱ pë' ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Erë ì ché ie' tö e' blëulewa̱ ie'pa yöki̱, e' kue̱ki̱ ie'pa kë̀ é̱na iwà a̱ne. Ñies ie'pa suane ichakök tö i̱ma iwà dör. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","E' ukuöki̱ ta̱ Jesús ttökatapa ñì iu̱tökerak tö ie'pa shu̱a̱ yi dö̀mi ibua'ie imale̱pa tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ì bikeitsök ie'pa tso', e' sué̱wa̱ Jesús tö, e' kue̱ki̱ ie' tö alala kié eköl duése̱r ie' o̱'mik ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ta̱ ichéitö ie'pa a̱: —A' shu̱a̱ yi e̱' wöéwa imale̱pa diki̱a̱ diöshe̱t ese dör ibua'ie. E' kue̱ki̱ yi tö alala i'se kiéwa̱ ye' ttö̀ wa, ese tö ye' wák kiéwa̱. Es ñies yi tö ye' kiéwa̱, ese tö yi tö ye' patkë'bitu̱, e' kiéwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan tö iché Jesús a̱: —A s'wöbla'u̱kwak, wëm sué̱ sa' tö eköl, e' tö aknama trë'wé̱yal be' ttö̀ wa. Erë ie' kë̀ ku̱' se' ta̱, e' kue̱ki̱ sa' tö iché ia̱ tö kë̀ iwa̱ria̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús tö iiu̱té: —Yi kë̀ ku̱' ñippök se' ta̱, ese tso' se' ta̱. E' kue̱ki̱ kë̀ iwöklö'wa̱r. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesús mi'keka̱ne ká̱ jaì a̱, e' ké̱wö dökewa̱tke, eta̱ Jesús tö ibikeitsé tö ye' mía̱ diché wa Jerusalén, ta̱ imía̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ie' tö wëpa we̱lepa patkémi ie' yöki̱ ke̱we u yulök kaporöie. Ie'pa mía̱ demi ká̱ tso' etk Samaria ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Erë Samaria wakpa wa̱ ijche̱r tö Jesús ena ittökatapa mi'ke Jerusalén, e' kue̱ki̱ ie'pa kë̀ wa̱ ikinewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mik Jesús ttökatapa kiè Santiago ena Juan e'pa tö isué̱ tö Samaria wakpa kë̀ wa̱ ie'pa kinewa̱, eta̱ ie'pa tö Jesús a̱ iché: —A Skëkëpa, ¿be' ki̱ ikiane tö sa' tö bö' kiè ká̱ jaì a̱ ie'pa e̱wo̱wa? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Erë Jesús wötréene ie'pa sa̱u̱k ta̱ ie'pa uñéitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","E' ukuöki̱ ta̱ ie'pa mía̱ ká̱ skà tso' tsi̱net ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ie'pa mirwa̱ ñala̱ ki̱ ta̱ wëm eköl tö Jesús a̱ iché: —A këkëpa, ye' mi'ke be' ta̱ ká̱ wa'ñe wé̱ be' mírö ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús tö iiu̱té: —Bakli' u ta̱', ñies dúla u ta̱', erë ye' dör S'ditsö Alà, e' kë̀ wa̱ u ta̱' se̱noie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús tö iché wëm eköl skà a̱: —Mishka ye' ta̱. Erë wëm tö iiu̱té: —A këkëpa, ka̱wö mú ña, mik ye' yë́ blërkewa̱ e' nu wötökwa̱, e' ukuöki̱ ta̱ ye' mi'ke be' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús tö iiu̱té: —Wé̱pa dör we̱s s'duulewa̱ es Skëköl wöa̱, a̱s esepa tö iyamipa nu wötö̀. Erë be' yú, ì blúie Skëköl tso' e' tté pakök sulitane a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wëm eköl skà tö iché Jesús a̱: —Ye' e̱' yuak be' ttökataie, erë ke̱we ka̱wö mú ña shkoie e̱' chöka̱t ye' yamipa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús tö iiu̱té: —Yi e̱' yué ye' ttökataie ta̱ ì ko̱s méa̱titö ye' dalërmik, erë ibikeitséneitö tai̱ë, eta̱ ese kë̀ ki̱ ì blúie Skëköl tso' e' mène. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","E' ukuöki̱ ta̱ Skëkëpa Jesús tö ittökatapa skà shu̱shté döka̱ dabom kuryök kí̱ böl (72) patkèmi ie' yöki̱ ke̱we böl böl wé̱ ie' mi'ke ese ska'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ie' tö iché ie'pa a̱: “Moki̱ pë' tso' tai̱ë e' ki̱ Skëköl ttè buaë kiane ttsè. Esepa dör we̱s iyiwö tso'tke wë'ià̱ë shtè es, erë ishtökwakpa kë̀ dör tai̱ë. E' kue̱ki̱ a' tö ikiö́ kanè wák a̱ tö ishtökwakpa patkö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","A' yú. Ye' tso' a' patkök ye' ttè pakök pë' shu̱a̱ we̱s obejala èmi namu tso' tai̱ë, ese shu̱a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Inuköl skúla ena dalì skú ena klökkuö skà, ese ko̱s kë̀ tsa̱rmi yës. Ñies yi kué̱ a' tö ñala̱ wa, ese kë̀ ta̱ a' ttök tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mik a' dewa̱ yile ska', eta̱ ke̱we ichö́ ie'pa a̱ tö ‘Skëköl e̱r buaë chö̀ a' a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ie'pa tö a' kiéwa̱ e̱r bua' wa, e' ta̱ Skëköl e̱r buaë chöraë ie'pa a̱. Erë kë̀ idör es, e' ta̱ Skëköl kë̀ e̱r buaë chö̀pa ie'pa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ie'pa tö a' kiéwa̱ buaë, e' ta̱ a' e̱' tsú̱a̱t u e' a̱. Ttè tso' e' tö ichè i' es: ‘Kaneblökwak chkö̀mi ì kanewe̱keitö e' ské wa.’ E' kue̱ki̱ ì meke ie'pa tö a' a̱ ñè yè, e' ñú, e' yö́. U e' ë̀ a̱ a' e̱' tsú̱a̱t a' tso' ká̱ e' a̱ e' dalewa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ká̱ wé̱ a' demi ta̱ ká̱ e' wakpa tö a' kiéwa̱ buaë, e' ta̱ ì mekeitö a' a̱ ñè e' ñú. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ie'pa duöke, e' ta̱ e'pa bua'ú̱ne. Ñies ichö́ ie'pa a̱: ‘Ì blúie Skëköl tso' e' ké̱wö dewa̱tke tsi̱net a' o̱'mik.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Erë ká̱ we̱le wakpa kë̀ wa̱ a' kinewa̱, e' ta̱ a' yú ie'pa ñala̱ wa ta̱ ichö́ ie'pa a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘A' ka̱po tso' sa' klöttö mik, e' ppée sa' tö iwà kkachoie tö a' dör Skëköl bolökpa. Erë a' wa̱ ijche̱nú tö ì blúie Skëköl tso' e' ké̱wö dewa̱tke tsi̱net a' o̱'mik.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ye' tö a' a̱ ichè tö mik Skëköl tö a' chakeketke inuí̱ ki̱ aishkuö ta̱, eta̱ ká̱ e' wakpa weirdaë sia̱rë Sodoma wakpa bak se̱nuk suluë e'pa tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“A Corazín wakpa, a Betsaida wakpa, ¡wëstela i̱na a' ta̱! Ì kë̀ o̱r yi a̱ ese wé̱ ye' tö tai̱ë a' wörki̱, erë kë̀ a' e̱r maneo̱ne. E' ú̱pa ye' tö Tiro ena Sidón e' wakpa wörki̱, e̱'ma ká̱ ia̱ia̱ë ie'pa e̱r maneo̱'bak. Ie'pa tö e̱riane datsi' a̱ja̱ë ese ië'ka̱bak, ñies ie'pa e̱' tkë'ka̱bak mulu̱chka ki̱ iwà kkachoie tö ie'pa e̱r mane'wé̱ Skëköl a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","E' kue̱ki̱ ye' tö ichè tö aishkuö ta̱ mik a' wöchakirketke a' nuì̱ ki̱ e' ké̱wö de, eta̱ a' wömerdattsa̱ weinuk tai̱ë shu̱te̱ Tiro ena Sidón wakpa tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A Cafarnaúm wakpa, kë̀ a' tö ibikeitsök tö a' mi'mitse̱r ká̱ jaì a̱. Ie' tö a' patkerami diöshe̱t wé̱ s'wimblu weirke ee̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Eta̱ Jesús tö iché ittökatapa a̱: “Yi tö a' ttö̀ ttseke ta̱ iu̱tekeitö, ñies ese tö ye' ttö̀ ttseke ta̱ iu̱tekeitö. Yi tö a' wateke, ñies ese tö ye' wateke. Ñies yi tö ye' wateke, ese tö Skëköl tö ye' patkë', e' wateke.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","E' ukuöki̱ ta̱ Jesús ttökatapa döka̱ dabom kuryök ki̱ böl (72) patkë' ie' tö, e'pa dene ttsë'nerak buaë. Ie'pa tö iché ie' a̱: —A Skëkëpa, aknamapa tö sa' ttö̀ dalöié be' ttö̀ wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ie' tö ie'pa iu̱té: —Tö́. A' e̱' aléka̱ Satanás ki̱ je'. Ye' isué̱ tö ie' bate̱shkar ká̱ jaì a̱ we̱s alá wöñar es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ye' tö a' a̱ diché mé e̱' aloka̱ tkabë̀ ki̱ ena bachë' ki̱ ñies e̱' aloka̱ Satanás diché ki̱. Es kë̀ ì tö a' we'ikepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kë̀ a' ttsë'nuk buaë wimblupa sulusi tö a' ttö̀ dalöié, e' ë̀ kue̱ki̱. E' skéie a' kiè tso' kitule ká̱ jaì a̱ se̱ne michoë yëkkuö ki̱, e' kue̱ki̱ a' ttsë'nú buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jesús tso'ia̱ ttök ittökatapa ta̱, e' shu̱a̱ Wiköl Batse'r tö ie' ttsë'wé̱ buaë shu̱te̱. Ie' tö iché: “A ye' Yë́, be' dör íyi ulitane tso' ká̱ jaì a̱ ena ká̱ i' a̱ e' Këköl. Be' tö ttè ikkë blë'wa̱ pë' wa̱ siwa̱' jche̱r i̱ski̱ë ena e̱rbikö̀ tai̱ë esepa yöki̱. Erë ikkachéwa̱bö s'ësela a̱. Es be' ki̱ ikiane, e' kue̱ki̱ be' iwé̱ es. E' kue̱ki̱ be' ki̱kéka̱yö.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesús tté S'yë́ ta̱ o̱ne ta̱ ichéitö pë' tso' ee̱ e'pa a̱: “Ye' Yë́ tö íyi ulitane méa̱t ye' ulà a̱. Ye' dör Skëköl Alà, kë̀ yi wa̱ ijche̱r moki̱ tö we̱s ye' dör, e' jche̱r ye' Yë́ ë̀ wa̱. Ñies kë̀ yi wa̱ ijche̱r moki̱ tö we̱s ye' Yë́ dör, e' jche̱r ye' ë̀ wa̱. Ñies wé̱pa a̱ ye' é̱na ikkachakwa̱ esepa wa̱ ijche̱rmi.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Eta̱ Jesús wötréene ittökatapa kke̱ ta̱ ichéitö ie'pa ë̀ a̱: “Ye' tö a' a̱ ichè tö Skëköl ttekölpa tai̱ë ena blu'pa bak ká̱ ia̱ia̱ë esepa tai̱ë tö, ì sué̱ a' tö, e' kkeyë' sia̱rë suè̱, erë ie'pa kë̀ wa̱ isu̱ne. Ñies ì ttsé a' tö, e' kkeyë' sia̱rë ie'pa tö ttsè, erë ie'pa kë̀ wa̱ ittsë̀ne. E' kue̱ki̱ wé̱pa tö ì sué̱ a' tö e' sué̱, ayëcha buaë esepa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Etökicha ta̱ s'wöbla'u̱k ttè dalöiëno wa ese eköl debitu̱ Jesús ska', e' tö ie' a̱ ichaké itsa̱ioie: —A s'wöbla'u̱kwak, ¿Ì wè̱mi ye' tö a̱s se̱ne michoë dö̀ ye' ulà a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús tö ie' a̱ ichaké ñies: —¿Ì tso' kitule Skëköl yëkkuö ki̱? ¿I̱ma e' wà dör be' a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Eta̱ s'wöbla'u̱kwak tö iiu̱té: —Skëköl yëkkuö tö iché: ‘Skëköl dalëritsö́ a' e̱r ko̱s wa, a' wák ko̱s wa, a' diché ko̱s wa, ena a' e̱rbikè ko̱s wa.’ Ñies e' tö ichè: ‘A' male̱pa dalëritsö́ we̱s a' wákpa e̱' dalër es.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús tö iché ie' a̱: —Be' tö iiu̱té buaë. Be' tö iwé̱ es, e' ta̱ se̱ne michoë döraë be' ulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Erë ie' e̱' tsa̱tkak ttè e' yöki̱, e' kue̱ki̱ ie' tö Jesús a̱ ichaké: —Eta̱ s'yamipa chè Skëköl yëkkuö tö, ¿esepa dör s'yamipa wé̱se? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Eta̱ Jesús tö iiu̱té ttè i' wa: —Wëm eköl datse̱ Jerusalén, e' micho Jericó, eta̱ ñala̱ wa akblökwakpa tö ie' klö'wé̱wa̱. Ì dami iwa̱ ko̱s dö̀ idatsi' e' bléwa̱rakitö. Ie' ppérakitö tai̱ë ta̱ imíyal. Ie' méa̱t tër ie'pa tö ñala̱ ska', tsir eta̱ iduowa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Eta̱ judiowak eköl dör sacerdote e' dami ñala̱ e' ki̱. Mik ie' tö wëm tër shka̱'ule e' sué̱, eta̱ ie' tkami bánet iyöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Es ñies judiowak skà eköl dör Leví aleri kaneblöke Skëköl wé a̱, e' dami ñala̱ e' ki̱. Mik ie' tö wëm tër shka̱'ule, e' sué̱, eta̱ ie' ñies tkami bánet iyöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Erë samariawakpa kë̀ mik a' wödör, sue̱ke a' tö suluë, esepa eköl dör wëm, e' dami ñala̱ e' ki̱. Mik ie' tö wëm tër shka̱'ule e' sué̱, eta̱ ie' wa iwër sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ie' de iska', ta̱ wé̱ ishka̱'ne e' paskuéitö vino wa, paikléitö kiö̀ wa, ta̱ ipatréwa̱itö datsi'tak wa. E' ukuöki̱ ta̱ ie' tö itkéka̱ iwák burro ki̱ tsé̱mi wé̱ s'kaporö ese wé a̱, ta̱ ee̱ ie' tö ikkö'néia̱ ipasué̱ia̱ buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bule es ta̱ samariawak tö s'kaporö wé, e' wák patué̱ inuköl döka̱ s'kaneblö̀ ká̱ böt e' ské ekkë, ta̱ iché ie' a̱: ‘Wëm shka̱'ule i' kkö'nú ña. Ilè kí̱ tué̱ be' tö ie' a̱, e' ta̱ e' ki̱ ye' tö be' patue̱rane mik ye' dene eta̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Eta̱ Jesús tö ichaké s'wöbla'u̱kwak a̱: —Wëm shka̱'wé̱ akblökwakpa tö e' sué̱ ie'pa mañal tö, ¿ie'pa wé̱ tö idalëritsé moki̱ we̱s s'ka̱wöta̱ s'yamipa dalëritsök es? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","S'wöbla'u̱kwak tö iiu̱té: —Wé̱ tö isué̱ e̱r sia̱rë wa e'. Jesús tö ie' a̱ iché: —Es be' yú ta̱ iú̱ we̱s samariawak tö iwé̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús ena ittökatapa míyal ñala̱ wa dö̀ Jerusalén, ta̱ ie'pa de ká̱ tsir ese a̱. Ee̱ alaköl se̱rke eköl kiè Marta, e' tö Jesús kiéwa̱ buaë ie' u a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ël, kiè María, e' e̱' tkéwa̱ tsi̱net Jesús ska', ta̱ ì cheke Jesús tö e' ttsök ie' tkër. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Erë Marta wa̱ kanè tso' tai̱ë iu a̱ kanewè̱, e' kue̱ki̱ ie' de Jesús ska' ta̱ ichéitö ie' a̱: —A Skëkëpa, ye' ël tö ye' méa̱t ekörla u kanéu̱k, ¿e' kë̀ ki̱ be' tkine? Ichö́ ie' a̱ tö ye' ki̱mú. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Erë Jesús tö iiu̱té: —A Marta, a Marta, tai̱ë be' e̱' tkiu̱ke kanè tso' tai̱ë be' u a̱ e' ki̱, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","erë íyi etkë̀, e' dör ibua'ie, e' shu̱shté María tö wè̱. Kë̀ yi tö iyepattsa̱ iulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Etökicha ta̱ Jesús tso' ttök S'yë́ ta̱. Mik ie' tté o̱ne, eta̱ ie' ttökatapa eköl tö ie' a̱ iché: —A Skëkëpa, Juan S'wöskuökwak tö ittökatapa wöblao̱' ttök S'yë́ ta̱. Es ñies sa' wöbla'ú̱ ttök S'yë́ ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús tö ie'pa a̱ iché: —Mik a' ttöke S'yë́ ta̱, eta̱ ichö́ ie' a̱ i' es: ‘A Sa' Yë́, a̱s be' dalöiö̀ sa' tö ì ulitane tsa̱ta̱. A̱s be' dö̀ sa' blúie da'a̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Chkè kiane sa' ki̱ se̱noie, e' mú sa' a̱ ká̱ bit ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Sa' male̱pa ko̱s e' nuì̱ olo'yeta̱' sa' tö ie'pa ki̱, e' kue̱ki̱ sa' nuì̱ olo'yö́ sa' ki̱. Kë̀ sa' marttsa̱ tö ì sulu tö sa' e̱rkiöù̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ñies ie' tö ie'pa wöbla'wé̱ ttè i' wa: —Sö ichèmi tö a' we̱le wa̱ yami tso' eköl, ese ska' a' mía̱ nañewe ká̱ sha̱böts, ta̱ a' tö iché ie' a̱: ‘A yami, írö ye' yami datse̱ bánet, e' debitu̱ ye' ska', erë ye' kë̀ wa̱ ì ta̱' mè ie' a̱. Be' we'ikèyö, pan peitö́ ña mañat.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Be' yami e' tö a' iu̱tèmi i' es: ‘Kë̀ ye' tsiriwa̱r. Ukkö wötënewa̱tke. Ye' ena ye' ala'r, sa' e̱' té̱wa̱tke kapökwa̱. Ye' kë̀ e̱' köpaka̱ ì muk be' a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jesús tö iché ie'pa a̱ tö u wák e' kë̀ e̱' köpaka̱ chkè muk a' a̱, a' dör iyami e' ë̀ kue̱ki̱. Erë a' tö ikié kröröë, kë̀ wöklör ekkë, e' ta̱ ie' e̱' köraka̱ ta̱ ì ko̱s kiane a' ki̱, e' meraëitö a' a̱, a' tö ie' a̱ ikié kröröë e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","“Wé̱pa tö íyi kié Skëköl a̱, esepa a̱ imeraëitö. Wé̱pa tö íyi yulé ie' ska' esepa tö ikue̱raë. Wé̱pa tö ie' chaké, esepa kierawa̱itö we̱shke̱. E' kue̱ki̱ ì kiane a' ki̱ e' kiö́ ie' a̱, eta̱ ie' tö a' a̱ imeraë; e' yulö́ ie' ska', eta̱ a' tö ikue̱raë; ie' chakö́, eta̱ ie' tö a' kierawa̱ we̱shke̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Kë̀ alà yë́ wé̱ne tö tkabë̀ mepa ilà a̱ nima kiéitö e' skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ñies kë̀ a' wé̱ne tö bachë' mepa ilà a̱ dakro sia̱' kiéitö e' skéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","A' dör pë' suluë erë e' tö íyi buaë meke a' alà a̱. ¡E' yita̱ buaë S'yë́ tso' ká̱ jaì a̱ e' tö Wiköl Batse'r meraë yi tö ie' a̱ ikié ese a̱!” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Etökicha ta̱ Jesús tso' aknama trë'u̱kshkar wëm eköl a̱. Aknama tö wëm e' ttö̀ wöblëo̱'wa̱. Mik aknama mía̱, eta̱ wëm ttéka̱ne buaë. Wé̱pa ko̱s tö isué̱, e'pa tkirulune iweblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Erë ie'pa we̱lepa tö iché: “Beelzebú dör bë́, e' diché wa ie' tö ie'pa trë'we̱keyal.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ie'pa we̱lepa skà é̱na Jesús tsa̱iak, e' kue̱ki̱ ie'pa tö ikié ie' a̱ tö ì kë̀ o̱r yi a̱ ese ú̱itö iwà kkachoie tö moki̱ ie' patkë'bitu̱ Skëköl tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Erë ì bikeitseke ie'pa tö, e' sué̱wa̱ ie' tö, e' kue̱ki̱ ie' tö ie'pa a̱ iché: “S'se̱rke ká̱ etkë̀ ki̱, e' ñì blabatsélor ta̱ iñippöke iwakpa ë̀ ñita̱, kë̀ wöklör, e' ta̱ ie'pa wákpa ë̀ ñì e̱u̱kewa kë̀ diché ta̱'ia̱. Ñies ñì yamipa ë̀ e̱' kéka̱ ñippök ñita̱, kë̀ wöklör, e' ta̱ ie'pa sulunewa̱ mía̱ sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Es ñies Satanás mú tö aknamapa trë'wé̱yal, e' ta̱ ie' tso' ñippök iwakpa ë̀ ta̱. ¿We̱s ì blúie ie' tso' e' se̱rmiia̱? A' icheke tö aknamapa trë'wé̱yal ye' tö Beelzebú diché wa, e' kue̱ki̱ e' ché ye' tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ye' tö itrë'ú̱payal Beelzebú diché wa, e̱'ma ¿yi diché wa a' klépa tö itrë'wè̱yalmi? Ie'pa kë̀ a̱ itrënukyal Beelzebú diché wa. E' kue̱ki̱ ¿we̱s a' tö ye' kkatèmi tö ye' tö itrë'we̱keyal Beelzebú diché wa? A' wakpa klépa tö iwà kkacheraë tö a' ttè kë̀ dör moki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aknamapa trë'wé̱yalyö Skëköl diché wa, e' ta̱ e' wà kiane yënoie tö ì blúie Skëköl tso', e' ké̱wö dewa̱tke a' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mik wëm diché tai̱ë tö iu kkö'neke buaë tabè wa, ì wa, eta̱ ie' íyi ko̱s tso' blëule buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Erë mik wëm skà datse̱ diché ta̱' tai̱ë shu̱te̱ ie' tsa̱ta̱, ñippök ie' ta̱, eta̱ e' e̱' aléka̱ iki̱ ta̱ íyi mik ie̱rblöke e̱' tsa̱tkoie ena ì skà ko̱s tso' ie' wa̱, e' yéttsa̱ se̱raa̱ iyöki̱, ta̱ ikakmémiitö iyamipa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Yi kë̀ dör ye' sini', ese dör ye' bolök. Yi kë̀ tö ye' ki̱mè obeja kkö'nuk buaë, ese tö obeja po'we̱kemi. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Mik wimblu sulusi trëneshkar yile a̱, eta̱ imía̱ ká̱ sir poë wé̱ kë̀ yi ku̱' ese ska'. Ie' tso' ká̱ yulök se̱noie, erë kë̀ ie' wa̱ iku̱ne. E' kue̱ki̱ ie' ibikeitsé: ‘Ye' mía̱ne wé̱ ye' trëneshkar ee̱ se̱nuk.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mik ie' demine wëm e' a̱, eta̱ ie' tö isué̱ tö wëm dör we̱s u shu̱iriule buaë maneneë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Eta̱ ie' mía̱ iyamipa kí̱ yulök döka̱ kul suluë shu̱te̱ ie' tsa̱ta̱ ta̱ ie'pa ko̱s de se̱nuk wëm e' a̱. Wëm e' mía̱ne suluë shu̱te̱ ke̱net tsa̱ta̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús tso' ttök, eta̱ alaköl eköl dur ee̱, e' tö iché a̱neule: —¡Alaköl tö be' tsöo̱', be' talao̱', ayëcha buaë e'! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Erë ie' iiu̱té: —¡Ayëcha buaë shu̱te̱, wé̱pa tö Skëköl ttè ttsé ta̱ idalöiekerakitö esepa! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ie'pa kí̱ ñì dapa'wé̱ Jesús pamik, eta̱ ie' tö iché ie'pa a̱: “A' dör pë' suluë. A' tö ye' a̱ ikieke tö ì kë̀ o̱r yi a̱ ese u̱yö iwà kkachoie tö moki̱ Skëköl tö ye' patkë'bitu̱. Erë ye' tö ilè we̱raë etökicha ë̀me iwà kkachoie, e' dör we̱s Jonás ta̱ ibak es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ì bak Jonás ta̱ e' tö iwà kkayë' Nínive wakpa a̱ tö Skëköl tö ie' patkë'bitu̱ ie'pa pattök. Es ñies, ye' dör S'ditsö Alà, e' tö iwà kkacheraë a' a̱ tö moki̱ Skëköl tö ye' patkë'bitu̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aishkuö ta̱ mik a' wöchakirketke a' nuì̱ ki̱, eta̱ alaköl datse̱ ká̱ bánet diwö tskirke e' o̱'mik bak iká̱ blúie, e' e̱' köraka̱ Skëköl wörki̱ a' kkatök tö a' dör pë' suluë. Ká̱ ia̱ia̱ë ie' dë'bitu̱ datse̱ ka̱mië shu̱te̱ se' blú bak kiè Salomón wa̱ íyi jche̱r tai̱ë, e' ttö̀ ki̱ttsök. Erë i̱'ñe ta̱ ye' dur a' shu̱a̱, e' dör Salomón tsa̱ta̱, erë a' kë̀ tö ye' ttö̀ iu̱tè. E' kue̱ki̱ alaköl e' tö a' kkateraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mik Jonás tö Nínive wakpa paut, e' tö ie'pa e̱r maneo̱'ttsa̱ Skëköl a̱, erë i̱'ñe ta̱ ye' dur í̱e̱rö, e' dör Jonás tsa̱ta̱, erë a' kë̀ e̱r mane'ù̱ Skëköl a̱. E' kue̱ki̱ aishkuö ta̱ mik a' wöchakirketke a' nuì̱ ki̱, eta̱ Nínive wakpa e̱' köraka̱ Skëköl wörki̱ a' kkatök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kë̀ yi tö bö'wö tskepaka̱ ta̱ ibléwa̱itö ö ipatkéwa̱itö kalkuö diki̱a̱. E' skéie se' tö itkekeka̱ ká̱kke̱ se' yamipa datse̱ e'pa wö a̱ ká̱ ñi'wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Se' wöbla dör we̱s bö'wö es se' chkà ko̱s a̱. E' kue̱ki̱ se' wöbla dör buaë, e' ta̱ se' chkà ko̱s e' a̱ ká̱ olo ta̱' buaë. E' dör we̱s se' e̱r dör buaë es, ì ko̱s yësyësë buaë, ese ki̱ se' e̱r me'rie. Erë se' wöbla dör suluë, e' ta̱ se' chkà ko̱s e' tso' stui a. E' dör we̱s se' e̱r suluë es, ì ko̱s suluë, ese ki̱ se' e̱r me'rie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","A' e̱' kkö'nú buaë a̱s a' kë̀ e̱' ki̱tö'ù̱ tö a' wöbla wawër buaë, erë kë̀ iwawër buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","A' wöbla dör buaë, e' ta̱ ì ko̱s buaë, ese wër buaë a' wa. E' dör we̱s a' se̱rke wé̱ bö'wö ñarke ke̱kraë ee̱ es, kë̀ ku̱' stui a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mik Jesús tté o̱ne, eta̱ fariseowak eköl tö ie' kiémi chkök iu a̱. Eta̱ ie' mía̱ demi ee̱ e̱' tkése̱r mesa kulé ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Erë fariseowak e' tö isué̱ tö kë̀ ie' wa̱ iulà pakö̀ne we̱s ie'pa wöblar es, e' tö ie' tsiriwé̱ka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","E' kue̱ki̱ Jesús tö iché ie' a̱: —A fariseowakpa, A' dör we̱s a' tka̱' ko̱s pa skueke a' tö iki̱kke̱ ë̀ es. A' wër buaë, erë a' e̱r suluë. A' dör akblökwakpa. A' ki̱ s'yamipa íyi ko̱s e' kianettsa̱ a' ë̀ a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡A' kë̀ é̱na ì a̱ne yës! ¿A' kë̀ wa̱ ijche̱r tö Skëköl tö se' chkà yö', e' ë̀ tö se' e̱r yö'? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","S'sia̱rëpa ki̱mú a' íyi wa, eta̱ ì ko̱s a̱tdaë maneneë a' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡A fariseowakpa, wëstela i̱na a' ta̱! Ka̱köla tso' iëno chkè a̱ kiè menta ena ruda ena iskà tso', ese ko̱s tsá̱ meke a' tö Skëköl a̱. Erë a' kë̀ se̱rku̱' yësyësë s'male̱pa ta̱. A' kë̀ tö Skëköl dalëritseta̱', e' u̱k a' ka̱wöta̱ ñies. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡A fariseowakpa, wëstela i̱na a' ta̱! Kula' tso' a' ñì dapa'wo̱ wé a̱ këkëpa dalöiërta̱' esepa a̱, ese ki̱ a' wöbatsö e̱' tkökse̱r. A' ki̱ ikiar tö a' shke̱'wè̱ we̱s këkëpa tai̱ë shke̱'wè̱ es, wé̱ pë' tso' tai̱ë, e'pa wöwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Wëstela i̱na a' ta̱! A' dör we̱s pö tso' kë̀ jche̱r yi wa̱ e' bata ki̱ s'shkörami es. Ishu̱ dör ñá tai̱ë alar suluë, e' kë̀ alar ttsëne s'wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","S'wöbla'u̱kwak ttè dalöiëno wa, ese tso' eköl ee̱, e' tö iché Jesús a̱: —A s'wöbla'u̱kwak, mik be' tö e' ché fariseowakpa a̱, eta̱ ñies be' tso' sa' chök suluë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús tö iiu̱té: —¡A s'wöbla'u̱k ttè dalöiëno wa wakpa, wëstela i̱na a' ta̱ ñies! A' ttè dalöiëno tai̱ë darërëë, ese meke a' tö s'male̱pa a̱ wà dalöiè we̱s dalì e̱kke̱ë iè s'ki̱ es, erë a' ulatska ë̀ kë̀ tie̱ta̱'wa̱ a' tö ie'pa ki̱moie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Wëstela i̱na a' ta̱! A' tö Skëköl ttekölpa bak ká̱ ia̱ia̱ë e'pa pö yuekene pa̱'a̱li̱, erë a' yë́pa tö ie'pa kötulur. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Es a' tso' iwà kkachök tö ì wamblë' a' yë́pa tö, e' dör buaë a' a̱. A' yë́pa tö ie'pa kötulur, ta̱ i̱'ñe ta̱ a' tö ie'pa pö yuekene buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“E' kue̱ki̱ Skëköl wa̱ íyi jche̱r tai̱ë, e' tö iyë'a̱tbak: ‘Ye' tö ye' ttekölpa ena ye' ttè pakökwakpa patkeraë Israel aleripa a̱, eta̱ e'pa we̱lepa tterawa̱ ie'pa tö, ñies we̱lepa skà we'ikeraë ie'pa tö.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Skëköl ttekölpa tai̱ë kötulur a' yë́pa tö. Mik ká̱ i' yöne kuaë, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","eta̱ Abel kötwa̱ Caín tö. E' itöki̱ a' yë́pa bak tö Skëköl ttekölpa tai̱ë kötmi. Ibata kötwa̱rakitö e' dör Zacarías. E' kötwa̱ ie'pa tö ka̱' tso' íyi moka̱ Skëköl a̱ e' ena iwé e' shu̱sha̱. Skëköl ttekölpa ko̱s kötulurbak a' yë́pa tö, e' nuí̱ kierane ie' tö a' ena wé̱pa dör a' es, e'pa a̱. Moki̱ ye' tö a' a̱ ichè tö Skëköl ttekölpa ko̱s kötulur a' yë́pa bak e'pa tö, e' nuí̱ kue̱ki̱ a' ena wé̱pa dör we̱s a' es, esepa weirdaë sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡A s'wöbla'u̱k ttè dalöiëno wa wakpa, wëstela i̱na a' ta̱! A' wa̱ Skëköl yëkkuö tso', e' dör we̱s ukkö yottsa̱ tso' es a̱s se' wa̱ ijche̱r tö we̱s Skëköl dör. Erë e' kkëu̱k a' tso' a' male̱pa yöki̱. A' kë̀ wa̱ ijche̱r moki̱ tö we̱s Skëköl dör, ñies wé̱pa ki̱ e' kiane jche̱noie, esepa wöklö'we̱ke a' tö a̱s ie'pa kë̀ wa̱ ijche̱r.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Eta̱ Jesús e̱' yéttsa̱ u e' a̱. S'wöbla'u̱k ttè dalöiëno wa wakpa ena fariseowakpa uluneka̱ tai̱ë ie' ki̱. Ie'pa tö ie' chakémi tai̱ë ttè darërëë wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ie'pa é̱na ie' klö'wa̱kwa̱ ittè ki̱ ikkatoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","3","Eta̱ pë' dapane tai̱ë Jesús ska' döka̱ miles, e'pa tërke ñì mik tai̱ë. Jesús tö ichémi ittökatapa a̱ ke̱we: “A' e̱' kkö'nú fariseowakpa pan wölöwo̱ka̱ yöki̱. E' wà kiane chè tö a' e̱' kkö'nú we̱s ie'pa se̱r e' yöki̱. Ie'pa e̱' wamblö̀ suluë, erë ie̱' ö̀rak tö ie'pa dör buaë s'male̱pa tsa̱ta̱. Kë̀ ì ku̱' blëulewa̱ ese kë̀ kkayërpawa̱ aishkuö ta̱. Ese ko̱s jche̱rdane. Ì cheke a' tö bikeitsè a' tö tö kë̀ ittsë̀ne, ese ttserane sulitane tö. Ì ko̱s cheke a' tö asas ukkö wötëulewa̱ shu̱a̱, ese yërdane a̱neule sulitane kukua. E' kue̱ki̱ a' e̱' kkö'nú a̱s a' kë̀ e̱' ö̀ we̱s ie'pa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“A ye' yamipa, kë̀ a' suanuk yi tö s'tteta̱'wa̱ esepa yöki̱. Ie'pa tö s'ttéwa̱, erë e' ukuöki̱ ta̱ kë̀ we̱s ie'pa a̱ se' o̱nukia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Erë sú̱yö a' a̱ ichè tö yi yöki̱ a' ké suanuk. A' suanú Skëköl yöki̱. Ie' tö a' ttèwa̱mi, e' ukuöki̱ ta̱ ie' wa̱ diché ta̱' a' u̱yowa̱ bö' ké̱ a̱. Ye' tö iskà chène a' a̱, a' suanú ie' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Dúla ske̱l tuè̱ tottola, inuköl böt wöshkila ë̀, erë ie'pa kë̀ ska' Skëköl e̱r chöta̱'wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ñies a' kë̀ ska' ie' e̱r chöpawa. Dö̀ a' tsa̱kö bitö tso' shta̱o̱ule ie' wa̱. Ie' a̱ ta̱ a' tuè̱ tai̱ë tkö̀ka̱ dúla tso' tai̱ë ese tsa̱ta̱, e' kue̱ki̱ kë̀ a' suanuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Yi e̱' chö̀ sulitane wörki̱ tö ie' dör ye' dör S'ditsö Alà, e' ttökata, e' ta̱ ese cheraëyö Skëköl biyöchökwakpa wörki̱ tö ie' dör ye' ttökata. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Erë yi tö iblé sulitane wörki̱ tö ie' kë̀ dör ye' ttökata, e' ta̱ ñies ibleraëyö Skëköl biyöchökwakpa wörki̱ tö ie' kë̀ dör ye' ttökata. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Yi tö, ye' dör S'ditsö Alà, e' ché suluë, e' nuí̱ olo'yèmi Skëköl tö iki̱. Erë yi tö Wiköl Batse'r ché suluë, e' kë̀ ki̱ inuì̱ olorpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mik pë' tö a' klö'wé̱wa̱ tsé̱mi kkatè ye' ttè kue̱ki̱ judiowak ñì dapa'wo̱ wé a̱ ö s'shu̱lökwakpa wörki̱ ö s'wökirpa wörki̱, eta̱ kë̀ a' tkinuk tö ì chèmi a' dör e̱' tsa̱tkoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","E' wösha̱ ta̱ Wiköl Batse'r tö ttè eraë a' a̱ chè ie'pa a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Pë' dapane tai̱ë e' eköl tö Jesús a̱ iché: —A s'wöbla'u̱kwak, ichö́ ye' ël a̱ tö sa' yë́ íyi ukuö a̱te̱ ko̱s e' blatö́ö, ye' icha mú ye' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús tö iu̱té: —A wëm, ye' kë̀ dör a' íyi shu̱lökwak, ñies ye' kë̀ dör a' íyi blatökwak. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ñies Jesús tö iché: —Se̱ne chö́k e' kë̀ döku̱' s'ulà a̱ íyi tso' s'wa̱ tai̱ë ese wa. E' kue̱ki̱ a' e̱' kkö'nú íyi kkechè tai̱ë ese ko̱s yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Eta̱ Jesús tö ttè kleé ie'pa i' es: “Wëm eköl dör inuköl blú tai̱ë, e' tö íyi wöwé̱ tai̱ë shu̱te̱ iká̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ie' tö ibikeitsè: ‘Ye' íyi wöne tai̱ë ¿we̱s e' wè̱mi ye' tö? Kë̀ ichë'ka̱ia̱ iwé a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Eta̱ ie' tö ichè: ‘Ye' é̱na ia̱ne tö we̱s ye' tö iwè̱mi. Sú̱yö iwé tkèttsa̱ ské yuèka̱ne pa̱'a̱li̱, bërie shu̱te̱, e' a̱ ye' iyiwö ko̱s ena ì ko̱s tso' ye' wa̱ e' blekeyö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","E' ukuöki̱ ta̱ ie' tö ibikeitsé: íyi tso' tai̱ë ye' wa̱ blëule, e' mik ye' se̱rmi dö̀ duas tai̱ë. E' kue̱ki̱ sú̱ ye' e̱nù, chkö̀, di'yö̀, ttsë'r buaë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Erë Skëköl tö iché ie' a̱: ‘Be' kukuö̀ darërëë, bë́rë nañewe be' duöwa̱raë, eta̱ ì ko̱s tso' be' wa̱ blëule, e' a̱te̱ pë' kua̱'ki̱ ulà a̱.’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Eta̱ Jesús tö iché: “Es itköraë wé̱ tö íyi blé tai̱ë iwák a̱ ká̱ i' a̱, erë kë̀ se̱rku̱' we̱s Skëköl ki̱ ikiane es, ese wák dör sia̱rë Skëköl a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","E' ukuöki̱ ta̱ Jesús tö iché ittökatapa a̱: “Ye' tö a' a̱ ichè: Kë̀ a' tkinuk ì kiane a' ki̱ se̱noie, chkeie, datsi'ie, ìie, ese ko̱s ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","S'tso' ttsë'ka e' kë̀ dör chkök ë̀me, ñies s'chkà kë̀ dör datsi' ë̀ ioie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Dù sa̱ú̱ a' tö. Ie'pa kë̀ tö ì kuatketa̱' ì wöshteta̱' kë̀ tö chkè bleta̱', erë Skëköl tö ie'pa tieke. E' yita̱ ie' a̱ ta̱ a' tuè̱ tai̱ë dù ko̱s tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","A' tkirke tai̱ë e̱' ki̱, e' kë̀ tö a' a̱ ka̱wö kí̱ mepa se̱noie ekuölö ë̀. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","E' dör tottola erë kë̀ a' a̱ io̱r. ¿We̱s a' tkirke íyi malè̱ ki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“A' tö ma'ma wörkua bua'buaala ese sa̱ú̱ we̱s italar, kë̀ kaneblöta̱', kë̀ datsi' yueta̱'. Erë́ blu' bak kiè Salomón, e' wa̱ íyi ulitane bua'buaë bak tai̱ë, erë ye' tö a' a̱ ichè tö ie' datsi' bua'bua, e' kë̀ wër buaë we̱s ma'ma wër es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ka̱kö sué̱sö i̱'ñe, bule ta̱ iñanewa, erë Skëköl tö iki̱tkeke buaala iwörkua wa. Ie' tö ka̱kö ki̱tkeke es, ¡e' yita̱ ie' tö a' kianeia̱ e̱rblö̀ buaë ie' mik, e' paieraë! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","E' kue̱ki̱ kë̀ a' e̱r mukwa̱ chkè ki̱, di'yè ki̱, ese ko̱s kë̀ ki̱ a' tkinuk. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pë' kë̀ tö Skëköl dalöiè esepa tkirke tai̱ë íyi ko̱s ekkë ki̱. Erë ì ko̱s kiane a' ki̱ e' jche̱rtke a' Yë́ wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","E' skéie ì ko̱s blúie Skëköl tso' e' ki̱ a' e̱r mú ke̱weie. A' tö iwé̱ es, e' ta̱ ñies íyi ñekkë döraë a' ulà a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“A ye' obejapala, kë̀ a' suanuk ì yöki̱. A' kë̀ dör tai̱ë, erë S'yë́ e̱r buaë chöke a' a̱. Ie' tö a' shu̱shté a̱s ì blúie ie' tso' e' dö̀ a' ulà a̱ ie' ta̱ ñita̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ì tso' a' wa̱, e' wataú̱ttsa̱ ta̱ iské mú s'sia̱rëpa a̱. Ì dör buaë Skëköl a̱, e' ú̱, eta̱ es a' a̱ íyi bua'bua blërdaë ká̱ jaì a̱ we̱s inuköl blèsö, ì kë̀ nurta̱'wa̱, ese a̱ es. Ee̱ akblökwakpa kë̀ a̱ iekiblënuk, ñies powak kë̀ a̱ ikatanukwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Wé̱ a' íyi bua'bua tso' ee̱ a' e̱r me'rie ñies, e' kue̱ki̱ a' íyi blö́ ká̱ jaì a̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“A' tso' e̱rki̱ we̱s kanè mésopa tö iwökir tso' ulabatsè ké̱wö tkö'u̱k datse̱ne, ese panè es. Ie'pa tso'tke ie' panuk datsi' iënetke ikanewo̱ie, ibö'wö tskéka̱tke buaë. Mik iwökir de ta̱ ichaké ukkö a̱, eta̱ bet ta̱ ie'pa ukkö ppée ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wé̱pa kué̱ iwökir tö ttsë'ka ie' panuk mik ide eta̱, ayëcha bua esepa. Moki̱ ye' tö a' a̱ ichè tö ie' e̱' paiöraë we̱s chkè watiökwak es ta̱ ikanè mésopa keraëitö e̱' tkökse̱r kula' ki̱ ta̱ ie'pa tieraëitö chkè buaë wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kanè mésopa kué̱ iwökir tö ttsë'ka ie' panuk ká̱ sha̱böts alè ö ká̱ ñirketke alè eta̱, ayëcha buaë esepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Erë a' é̱na ia̱nú tö u wák mú wa̱ ijche̱r tö we̱kkë akblökwak datse̱, e̱'ma ie' kë̀ tö ka̱wö mepa yi a̱ dökwa̱ iíyi ekiblök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Es ñies ye' dör S'ditsö Alà, e' datse̱ne mik a' kë̀ ku̱' ye' panuk eta̱, we̱s akblökwak es. E' kue̱ki̱ a' tso' e̱rki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro tö Jesús a̱ ichaké: —A Skëkëpa, ttè wakleébö ¿e' dör sa' ë̀ a̱ ö sulitane a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ie' iiu̱té: “Kanè méso yësyësë ka̱bikeitsö̀ buaë, ese mekeka̱ iwökir tö imale̱pa kue̱bluie ie'pa tiök ke̱kraë mik kë̀ iku̱' e' dalewa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Iwökir dene ta̱ ikué̱itö iu̱k we̱s iyëneia̱ es, e' ta̱ ayëcha e' dör buaë ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Moki̱ ye' tö a' a̱ ichè tö kanè méso e' meraka̱itö, ie' wa̱ íyi tso' ko̱s, e' kue̱bluie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Erë kanè méso ñe' e̱rbikö̀ tö ‘ye' wökir kë̀ döpane bet.’ E' kue̱ki̱ ie' tö imale̱pa wëpa ena alakölpa ppémi darërëë. Ñies ie' chkémi, di'yémi tai̱ë ena ie̱' ttémi blo' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Erë idiwö ena iké̱wö kë̀ wa ie' ku̱' ipanuk, eta̱ iwökir dörane ta̱ iwe'ikeraitö sia̱rë wömerattsa̱ weinuk we̱s pë' kë̀ e̱rblöta̱' Skëköl mik esepa es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kanè méso wé̱ wa̱ ì kiane iwökir ki̱, ese jche̱r buaë, erë ie' kë̀ wa̱ ì o̱ne yës, kë̀ tö ittö̀ dalöiè, ese we'ikeraë iwökir tö sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Erë kanè méso wé̱ kë̀ wa̱ ijche̱r ta̱ e' tö ì suluë wamblé, e' ta̱ ese we'ikeraë iwökir tö erë kë̀ tai̱ë. Wé̱pa a̱ imène tai̱ë kanebloie Skëköl a̱, esepa a̱ ikieraëitö tai̱ë. E' sù̱ wé̱pa a̱ imène tai̱ë shu̱te̱, esepa a̱ ikieraëitö tai̱ë shu̱te̱. Ko̱s se' a̱ imène e' mik se' a̱ ichakirdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ye' dë'bitu̱ ká̱ i' a̱ s'aláu̱k we̱s bö' tai̱ë wöbatska̱ ese tö s'aláwè̱ es, e' mú wöbatska̱tke. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Erë ke̱we ta̱ ye' weirdaë sia̱rë, e' ka̱wöta̱ dalë'ttsèyö, e' tö ye' e̱riawe̱ke tai̱ë dö̀ mik itka eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿A' ibikeitsé tö ye' dë'bitu̱ ká̱ i' a̱ a̱s a' se̱r bë̀rë ñita̱? Ye' ichè, au. E' skéie ye' dë'bitu̱ a' blabatsök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","I' ta̱ iñak tkënewa̱mitke, se' se̱rke ske̱l ñita̱, e' ñì blabatsöraë ye' ttè kue̱ki̱, böl ñippöraë mañal ta̱, mañal ñippöraë böl ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iyë́ ñippöraë ilà wëbie ta̱ ena ilà ñippöraë iyë́ ta̱; imì ñippöraë ilà busi ta̱ ena ilà ñippöraë imì ta̱; yàk ñippöraë iyàk ta̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ñies Jesús tö ie'pa a̱ iché: “Mik a' isué̱ tö ka̱li̱ moneka̱ diwö mi'ke e' ëka̱, eta̱ a' tö icheke ‘ka̱li̱ yërdaë’, eta̱ moki̱ iwà yërdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mik a' ittsé tö siwa̱' datse̱ ká̱ sir poë e' ëka̱, eta̱ a' tö icheke ‘dìba a̱rdaë’, eta̱ moki̱ iwà a̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡A' e̱' ö̀ suluë! A' é̱na ia̱ne mik ka̱li̱ yërmi, mik dìba a̱rmi, erë ì u̱k ye' tso' iwà kkachoie tö yi dör ye', ¿we̱s kë̀ e' wà a̱ne a' é̱na? ¡A' kë̀ wa̱ ì jche̱r tai̱ë we̱s a' ibikeitseke es!” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Ì kue̱ki̱ a' kë̀ a̱ ibikeits tö ì dör buaë, ì dör suluë Skëköl a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Yile tö a' kkaté nuì̱ kue̱ki̱ e' wa̱ a' mí s'shu̱lök wé a̱, e' ta̱ ima'ú̱ shu̱lè ie' ta̱ ñala̱ ki̱ a̱s ie' kë̀ tö a' wömùttsa̱ s'shu̱lökwak ulà a̱ we'ikè. A' kë̀ tö iwè̱ es, e' ta̱ s'shu̱lökwak tö a' wömerattsa̱ s'shkëkipa ulà a̱ ta̱ e'pa tö a' wöterawa̱ s'wöto wé a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ye' tö a' a̱ ichè tö kë̀ a' döpattsa̱ dö̀ mik a' tö nuì̱ e' patué̱ttsa̱ se̱raa̱ eta̱. E' kue̱ki̱ a' e̱r mane'ú̱ Skëköl a̱ ka̱m iwà dö̀ a' ki̱ e' yöki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","E' ë̀ ké̱wö ta̱ pë' we̱lepa tso' ee̱, e'pa tö iché Jesús a̱ tö Galilea wakpa wëpa we̱lepa tso' iyiwak jchök mè Skëköl a̱ iwé a̱. E' dalewa Pilato tö ie'pa ttökulur patké ta̱ ipë́ shu̱tuéka̱ iyiwak jchëne e' pë́ ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús tö iché ie'pa a̱: “¿I̱ma a' e̱rbikö̀? ¿Galilea wakpa kötulur ñe'pa dör pë' sulusipa tkö̀ka̱ imale̱pa tsa̱ta̱, e' kue̱ki̱ ie'pa weine es? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ye' tö iché au, kë̀ idör es. Erë a' kë̀ e̱r mane'ù̱, e' ta̱ ñies a' wákpa ko̱s duölurdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ñies u tso' Jerusalén kiè Siloé, e' yöule ka̱kke̱ë ák wa, mik e' anebitu̱ a̱neka̱ ie'pa ki̱, eta̱ ie'pa duo döka̱ dabom eyök ki̱ pàköl (18). ¿I̱ma a' e̱rbikö̀? ¿Ie'pa duolur ñe'pa ki̱ inuì̱ tso' tkö̀ka̱ Jerusalén wakpa male̱pa tsa̱ta̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ye' tö a' a̱ ichè au, kë̀ idör es. Erë a' kë̀ e̱r mane'ù̱ Skëköl a̱, e' ta̱ ñies a' duölurdaë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús tö ttè kleé ie'pa a̱ i' es: “Wëm eköl wa̱ kal kiè higuera tso' tkëule elka idali shu̱a̱. Ie' mía̱ iwö yulök, erë kë̀ iwö ta̱' yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","E' kue̱ki̱ ichéitö idali kkö'nukwak a̱: ‘I' ta̱ duas mañal, ye' de ke̱kraë higuera wö yulök, erë kë̀ iwö ta̱'. E' kue̱ki̱ itö́öbö a̱s kë̀ iku̱' àr ëanas.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Erë idali kkö'nukwak tö iché: ‘A këkëpa, a̱s iaria̱ duas ek. Sú̱yö iwì paiklè kapöli tkèka̱ iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","E' wa sö isué̱ tö duas ëtö ta̱ iwörmi e̱'ma buaë idir. Erë kë̀ iwöne, e' ta̱ iteerasö.’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","E̱no diwö et a̱ Jesús tso' s'wöbla'u̱k Skëköl ttè wa ñì dapa'wo̱ wé etkue a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Eta̱ ee̱ alaköl tso' eköl tteke wimblu sulusi tö wököulewa̱. Ie' kirirke es, e' ki̱ duas de dabom eyök ki̱ pàköl (18). Kë̀ ie' a̱ e̱' wödurka̱ yësyësë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Mik Jesús tö isué̱, eta̱ ikiéitö e̱' ska' ta̱ ichéitö ia̱: —A tayë, be' buanene. Duè tö be' kiri'we̱ke, e' ulà a̱ be' tkashkar. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Eta̱ ie' ulà méka̱ iki̱ ta̱ iwöduneka̱ne yësyësë ta̱ Skëköl ki̱kéka̱miitö tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Erë Jesús tö alaköl bua'wé̱ne e̱no diwö a̱, e' kue̱ki̱ judiowak ñì dapa'wo̱ wé e' wökir uluneka̱ iki̱ tai̱ë. E' kue̱ki̱ ie' tö iché pë' dapane ee̱ e'pa a̱: —Domingo etö shu̱a̱ ká̱ tso' kul. Ká̱ teröl dör se' a̱ kanebloie. Ká̱ teröl shu̱a̱ a' shkö́ í̱e̱ bua'wè̱ne. Kë̀ a' kine e̱no diwö a̱ bua'wè̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesús tö iché ie' a̱: —¡A' e̱' ö̀ suluë! E̱no diwö a̱ a' ulitane tö a' iyiwak wöttseeke ta̱ itse̱kemi di' yök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tayë i' dör Abraham aleri, e' tso' klöulewa̱ Satanás ulà a̱ döka̱ duas dabom eyök ki̱ pàköl (18) we̱s iyiwak moulewa̱ es. Erë́ i̱'ñe dör e̱no diwö, erë ¿we̱s a' kë̀ ki̱ ikiane tö iwöttsèeyö aknama yöki̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mik Jesús tö e' ché, eta̱ ibolökpa jaëneka̱ tai̱ë. Erë pë' male̱pa ttsë'nerak buaë, ì buaë ko̱s wé̱ Jesús tö e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ñies Jesús tö iché: “Ì blúie Skëköl tso' ¿we̱s e' dör? ¿Ttè wé̱ wa yö ikleèmi? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","E' dör we̱s mostaza wö tkéwa̱ wëm eköl tö íyök a̱ es. Mostaza wö dör tsirlala, erë itskine talane bërie kalie, ese ulà tsa̱ka̱ dù u yuöke.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ñies Jesús tö iché: “Ì blúie Skëköl tso' ¿ttè wé̱ wa yö ikleèmi? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","E' dör we̱s pan wölöwo̱ka̱ wötué tayë tö harinachka mañayök a̱ es. E' tö harinachka, e' ko̱s wölöwé̱ka̱ tai̱ë.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús dami Jerusalén ñalé̱ wa, eta̱ ee̱ ká̱ tso' tseë, ká̱ blublu ena ká̱ tsitsir, e' wakpa wöbla'we̱ke Jesús tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Eta̱ yile tö ie' a̱ ichaké: —A këkëpa ¿yëne tö kë̀ yi tsa̱tkërpa tai̱ë? Ie' iu̱té: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Tsa̱tkè wékkö dör tsir. Tai̱ë pë' tö ima'we̱raë shkökwa̱ia̱, erë kë̀ ie'pa döpawa̱. E' kue̱ki̱ a' e̱' diché iö́ shkökwa̱ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mik u wák e̱' kéka̱ tö ukkö wötéwa̱, eta̱ a' tso' u'rki̱, e'pa tö ie' kieke ukkö a̱. A' tö ichakeke: ‘A këkëpa, be' ukkö kköppö́ö sa' a̱.’ Erë ie' tö a' iu̱teraë: ‘Kë̀ ye' wa̱ a' su̱ule.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Eta̱ a' tö icheraë ie' a̱: ‘Sa' chka' be' ta̱. Sa' di'ya' be' ta̱. Be' tö sa' wöblao̱' sa' ká̱ a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Erë ie' tö a' iu̱teraë: ‘Kë̀ ye' wa̱ a' su̱ule. A' dör ì sulu wamblökwakpa, a' yúshka bánet ye' yöki̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mik a' tö Abraham, Isaac, Jacob ena Skëköl ttekölpa ko̱s e'pa sué̱ ì blúie Skëköl tso' e' a̱, erë a' u̱yanettsa̱ bánet, eta̱ a' i̱u̱raë sia̱rë a' kà yilitdawa̱ weine kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","S'ditsö datse̱ ká̱ wa'ñe, esepa döraë chkök buaë ì blúie Skëköl tso' e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Es se' we̱lepa kë̀ dalöiërta̱' ká̱ i' a̱, esepa dalöiërdaë tai̱ë aishkuö ta̱. E' sù̱ se' we̱lepa dalöiërta̱' tai̱ë ká̱ i' a̱, esepa a̱tdaë ibataie aishkuö ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","E' wösha̱ ta̱ fariseowakpa we̱lepa de Jesús ska' ta̱ ichéitörak ia̱: —Herodes é̱na be' ttakwa̱, e' kue̱ki̱ be' yúshka ká̱ bánet. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús tö ie'pa iu̱té: —A' yú ta̱ ichö́ s'ki̱tö'u̱kwak ñe' a̱: ‘I̱'ñe ena bule ye' tso' aknamapa trë'u̱kyal, ñies s'bua'u̱kne, böiki ta̱ ye' kanè e̱ne.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ye' mitke i̱'ñe, e' shkö̀mi bule böiki tkörö Jerusalén wé̱ ie'pa wöblane Skëköl ttekölpa bak e'pa ttökulur ee̱, e' kue̱ki̱ ye' kë̀ ttepawa̱ í̱e̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡A Jerusalén wakpa, Skëköl ttekölpa ko̱s ttekewa̱ a' tö ke̱kraë! ¡Ñies ittè pakökwakpa patkeke ie' tö a' a̱, e'pa ttekewa̱ a' tö ák wa! ¡We̱kkë ye' e̱rkiè tö ye' mú a' dapa'wè̱ e̱' ska' we̱s dakro mitchke tö ila'rla dapa'wè̱ ipik diki̱a̱ es, erë kë̀ a' ki̱ ikiane yës! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ye' ttö̀ ttsö́, Skëköl kë̀ tö a' ká̱ kkö'nepaia̱. Ye' tö a' a̱ ichè tö a' kë̀ tö ye' sue̱paia̱ dö̀ mik ye' dene eta̱. E' ké̱wö ska' ta̱ a' tö ye' cheraë: ‘¡Ayëcha buaë yi datse̱ Skëköl ttö̀ wa e'!’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Etökicha ta̱ e̱no diwö a̱ Jesús mía̱ chkök fariseowakpa wökir eköl, e' u a̱. Eta̱ ee̱ fariseowakpa we̱lepa tso' iweblök krereë ikkatoie ilè ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Eta̱ wëm eköl kirirke iëneka̱ tai̱ë, e' de dur Jesús wörki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Eta̱ Jesús tö ichaké s'wöbla'u̱k ttè dalöiëno wa wakpa a̱ ena fariseowakpa a̱: —¿Ka̱wö ta̱' se' a̱ s'bua'u̱kne e̱no diwö a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Erë ie'pa kë̀ wa̱ ie' iu̱tëne yës. Eta̱ Jesús tö wëm e' klö'wé̱ ta̱ ibua'wé̱itö ta̱ ichéitö ia̱: ‘Be' yúshka.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Eta̱ ie' tö iché fariseowakpa a̱: —A' alà ö a' baka a̱nemi di' biule uk a̱ e̱no diwö a̱, e' ta̱ bet a' mía̱ iyöktsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ie'pa kë̀ a̱ ie' iu̱tëne yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús isué̱ tö pë' shke̱ñaule chkök, e'pa we̱lepa tö kula' tso' këkëpa dalöiërta̱' tai̱ë, esepa a̱ ese shu̱shté e̱' tkoie. E' kue̱ki̱ ie' tö ie'pa patté i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Mik yile tö a' we̱le shke̱ñé ulabatsè ké̱wö tkö'u̱k, eta̱ kë̀ a' e̱' tkökse̱r kula' tso' këkëpa tai̱ë a̱ ese kulé ki̱. Isalema këkëpa dalöiërta̱' tai̱ë a' tsa̱ta̱ ese de, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","eta̱ yi tö a' shke̱ñé, e' tö ichè a' a̱: ‘Be' we'ikèyö, kula' se̱ mú këkëpa i' a̱ e̱' tkoie.’ Eta̱ a' jaërka̱mi tai̱ë, miraë e̱' tkökse̱r kula' tso' se' ësepa a̱ ese ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","E' skéie, mik yi tö a' shke̱ñé, eta̱ a' e̱' tkö́se̱r kula' tso' se' ësepa a̱ ese kulé ki̱. Es mik yi tö a' shke̱ñé, e' de a' ska', eta̱ ie' tö ichè be' a̱: ‘A yami, be' yú e̱' tkökse̱r kula' tso' këkëpa a̱, ese kulé ki̱.’ Es pë' ko̱s tso' ee̱, e'pa tö a' dalöieraë we̱s këkëpa tai̱ë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yi e̱' ttsö̀ka̱ tai̱ë, ese a̱rdawa diöshe̱t, erë yi e̱' wöéwa, ese ki̱kardaka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wëm tö ie' shke̱ñé chkök, e' a̱ Jesús tö iché ñies: —Mik be' tö pë' shke̱ñeke chkök be' ska' ö di'yök be' ska', eta̱ be' sini'pa ena be' ëlpa ena be' yamipa male̱pa ena inuköl blúpa se̱rke tsi̱net be' pamik, esepa ko̱s kë̀ shke̱ñar. Ie'pa tö be' shke̱ñèmine, eta̱ es be' ulà a̱ iské detke. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","E' skéie mik be' ka̱wö tkö'u̱ke, eta̱ s'sia̱rëpa ena s'yulë́pa ena s'klö̀ bachiulewa̱ ena s'wöbla kë̀ wawër, esepa shke̱ñú. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ie'pa kë̀ a̱ iské menukne be' a̱. Erë mik s'se̱r yësyësë, esepa duowa̱ shke̱neka̱ aishkuö ta̱, eta̱ Skëköl tö be' a̱ iské meraë, e' tö be' ttsë'we̱raë buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wëm eköl tkër chkök mesa ki̱ ie'pa ta̱, mik e' tö ì ché Jesús tö e' ttsé, eta̱ ie' tö iché ia̱: —Wé̱pa ka̱wö tkö'we̱raë buaë aishkuö ta̱ ì blúie Skëköl tso' e' a̱, ayëcha buaë esepa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús tö ie' a̱ iché: —Wëm eköl tö ka̱wö tkö'we̱ke tai̱ë ta̱ ie' tö tai̱ë pë' shke̱ñé. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mik ika̱wö tkö'u̱ke e' diwö de, eta̱ ie' tö iché ikanè méso a̱: ‘Se' ka̱wö tkö'u̱ke, e' tso'tke kaneo̱ule e' kue̱ki̱ be' yú s'kiule ko̱s e'pa a̱ ichök tö a' shkö́ ka̱wö tkö'u̱k.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Erë ie'pa ulitane tö iché kanè méso a̱: ‘Wëstela be' ta̱, erë sa' wötkërke tai̱ë, kë̀ sa' dö̀pa.’ Itsá̱ tö iché ie' a̱: ‘E̱rpa ye' tö ká̱ tué̱ e' sa̱u̱k ye' mi'ke, e' kue̱ki̱ ye' kë̀ dö̀pa. Ye' kköchö̀ be' a̱ tö e' olo'yö́ ye' ki̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Iskà tö iché: ‘Baka wë'ñe tué̱yö kanebloie dabop, e' wà ma'u̱k ye' mi'ke, e' kue̱ki̱ ye' kë̀ dö̀pa. Ye' kköchö̀ be' a̱ tö e' olo'yö́ ye' ki̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Iëköl tö iché: ‘Írö ye' ulabatséwa̱, e' kue̱ki̱ kë̀ ye' dö̀pa.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ikanè méso bite̱a̱ne iwökir ska' ta̱ ì ko̱s ché ie'pa tö ie' a̱ e' chéne ie' tö. Eta̱ u wák uluneka̱ tai̱ë ta̱ ichéitö ia̱: ‘Be' yú bet ñala̱ kibi ki̱, ñies ñala̱ male̱pa ki̱, ta̱ s'sia̱rëpa ena s'yulë́pa ena s'wöbla kë̀ wawër ena s'klö̀ bachiulewa̱, esepa tsú̱bitu̱ í̱e̱ ka̱wö tkö'u̱k ye' ta̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Bë́rë ta̱ kanè méso dene, e' tö iché iwökir a̱: ‘A këkëpa, ì u̱k be' tö ye' patké, e' wé̱tke ye' tö, erë be' u ka̱m wà iër.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Eta̱ iwökir tö iché ie' a̱: ‘Be' skà yúne u tso' bánet ese ñalé̱ ko̱s wa, eta̱ pë' kö́ shkökwa̱ ye' u a̱ a̱s iwà iërka̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ye' tö ichè tö wé̱pa shke̱ña' ye' tö ke̱we, e'pa kë̀ wé̱ne ka̱wö tkö'ù̱pa ye' ta̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tai̱ë pë' mir Jesús itöki̱ ta̱ ie' e̱' wötrée ta̱ ichéitö ie'pa a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yi se̱nak ye' ttökataie, erë kë̀ ié̱na ye' dalër iyë́, imì, ilaköl, ila'r, iëlpa, ikutapa tsa̱ta̱, ñies iwák tsa̱ta̱, e' ta̱ ese kë̀ dö̀pa ye' ttökataie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yi kë̀ e̱' chö̀ weinuk dö̀ ittèwa̱ krus mik ta̱ ise̱r we̱s ye' ttökata es, ese kë̀ dö̀pa ye' ttökataie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ichö̀sö tö a' we̱le é̱na u yuak bërie. Ke̱we ie' e̱' tkökese̱r ibikeitsök tö ko̱s u e' tuè̱ isuo̱ie tö inuköl dömika̱ ö kë̀ idö̀paka̱ iyuoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Erë ie' kë̀ wa̱ ibikeitse̱ ke̱we, e' ta̱ ie' tö ichkí tuléwa̱ ta̱ inuköl kë̀ ta̱'ia̱ iyuoie. Sulitane tö isuè̱mi, e'pa tö ie' wayueraë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ie'pa tö ichèmi: ‘Wëm wí̱ u yuémi, erë kë̀ ie' a̱ iyöneia̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ñies ká̱ blu' we̱le wa̱ ijche̱r tö ká̱ kua̱'ki̱ blu' datse̱ ñippök ie' ta̱, e' ta̱ ie' e̱' tkörase̱r ibikeitsök ke̱we: ‘Ye' wa̱ ñippökwakpa tso' döka̱ 10.000. Ye' bolök wa̱ ñippökwakpa tso' döka̱ 20.000. ¿Ye' e̱' alömika̱ iki̱ ö kë̀ ye' e̱' alö̀paka̱ iki̱?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ie' isué̱ tö ie' kë̀ e̱' alö̀paka̱ ibolök ki̱, e' ta̱ ka̱m ibolök dö̀ tsi̱net, e' yöki̱ ie' tö ibiyöchökwakpa patkeraë ibolök a̱ ichök tö ‘¿we̱s sö ishu̱lèmi a̱s se' se̱r bë̀rë ñita̱?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","E' kue̱ki̱ yi se̱nak ye' ttökataie ese tö iwà bikeitsö́ ke̱we. Es a' kë̀ e̱' chö̀ ì ko̱s tso' a' wa̱ e' muka̱t, e' ta̱ kë̀ a' dö̀pa ye' ttökataie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Dayë dör buaë, erë kë̀ ikke ta̱'ia̱, e' ta̱ kë̀ ibuarpaia̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kë̀ ibua'ia̱ íyök kapeyoie. Kë̀ ibua'ia̱ ìie. E' dör buaë kèu̱mi ë̀. ¡Yi é̱na ye' ttö̀ ttsak, e̱'ma ikukueblö́ bua'ie!” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ke̱kraë inuköl shtökwakpa Roma wökirpa a̱, esepa döke tai̱ë Jesús ska' iki̱ttsök. Ñies pë' male̱pa cheke fariseowakpa tö tö e'pa dör pë' sulusipa, esepa döke tai̱ë Jesús ttöke e' ki̱ttsök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseowakpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa tö Jesús chémi suluë ñì a̱. Ie'pa tö iché: —Ie' tö pë' sulusipa sue̱ke buaë, ñies esepa ta̱ ie' chköke. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","E' kue̱ki̱ ttè kleé ie' tö ie'pa a̱ i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“A' isie wa̱ obeja tso' döka̱ cien, e' etö chowa, e' ta̱ a' tö imale̱pa döka̱ dabom su̱li̱yök ki̱ su̱li̱tu (99), e' meraa̱t iké̱ a̱ ta̱ a' miraë ichowa e' yulök dö̀ wé̱ a' tö ikué̱ ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mik a' tö ikué̱, eta̱ a' ttsë'rdaë buaë ta̱ a' tö ikeraka̱ pperaka̱ kuli' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Mik a' dene iu a̱, eta̱ a' yamipa ena pë' se̱rke a' o̱'mik, e'pa kiera a' tö a' u a̱ ta̱ a' tö icheraë ie'pa a̱: ‘Ye' obeja chë'wa, e' kué̱neyö. A' ttsë'nú buaë ye' ta̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Es ñies ye' tö a' a̱ ichè tö mik pë' sulusi eköl, ese e̱r mane'wé̱ Skëköl a̱, eta̱ e' tö Skëköl tso' ká̱ jaì a̱, e' ttsë'wé̱ buaë shu̱te̱ tkö̀ka̱ imale̱pa döka̱ dabom su̱li̱yök kí̱ su̱li̱tu (99) e̱' bikeitsö̀ tö ie'pa dör yësyësë, kë̀ ka̱wöta̱ e̱r mane'u̱k, esepa tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ñies alaköl wa̱ inuköl tso' döka̱ dabop, e' chowa etk, e' ta̱ ie' tö bö'wö tskéka̱ iushkléttsa̱ ta̱ iyulé bua'iewa̱ ta̱ iwà kué̱itö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","E' ukuöki̱ ta̱ ie' tö iyamipa ena pë' se̱rke io̱'mik e'pa kié iu a̱ ta̱ ichéitö ie'pa a̱: ‘¡A' ttsë'nú buaë ye' ta̱! Ye' inuköl chë'wa, e' kué̱neyö, e' kue̱ki̱ e' ké̱wö tkö'ù̱sö ñita̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Es ñies ye' tö a' a̱ ichè tö mik pë' sulusi eköl e̱r mane'wé̱ Skëköl a̱, eta̱ e' tö Skëköl biyöchökwakpa ttsë'we̱ke buaë shu̱te̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ñies Jesús tö ikleé ie'pa a̱ ttè i' wa: “Këkëpa eköl alà dör böl wëpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ilà tsirla tö iché iyë́ a̱: ‘A yë́wö, ì mekea̱t be' tö ye' a̱ mik be' duökewa̱tke eta̱, e' mútke be' tö ye' a̱.’ Eta̱ iyë́ íyi ko̱s, e' blabatséitö méitö ila'r böl a̱ eköl eköl ko̱s ika̱wöta̱ imuk ia̱ ekkë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ká̱ kë̀ bak tai̱ë, eta̱ ì ko̱s méitö ilà tsirla a̱, e' watué̱ttsa̱ ilà tö, e' ské klö'wé̱itö ta̱ imía̱ ká̱ kua̱'ki̱. Ee̱ ie' tö ie' inuköl ko̱s we'ikéwa íyi sulu ë̀ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mik ie' inuköl e̱newa, eta̱ bli a̱ne tai̱ë ká̱ e' ki̱, e' kue̱ki̱ ie' ttémitke bli tö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ee̱ ta̱ ie' mía̱ kanè yulök ká̱ e' wakpa eköl ska'. Eta̱ wëm e' tö ie' a̱ kanè mé köchi tiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ie' duéwa̱ bli wa̱ suluë. Köchi chkè kë̀ ñano se' a̱ ese ñakwa̱ ie' é̱na, erë kë̀ yi tö ie' a̱ imè. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Bata ekkë ta̱ ie' tö ibikeitsé: ‘¿Iö́k ye' e̱' tötkër bli wa̱ í̱e̱? We̱kkë ye' yë́ u a̱ kanè mésopa tso', e'pa wa̱ chkè tso' tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ye' mía̱ne ye' yë́ ska', ta̱ ye' tö icheraë ie' a̱: A yë́wö, ye' tö ì sulu wamblé Skëköl ki̱, ñies be' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ye' jaëne tai̱ë. Ye' kiök be' alà, e' kë̀ dör ye' sia̱rla e' a̱. E' skéie ye' sa̱ú̱ we̱s be' kanè mésopa sue̱kebö es.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Eta̱ ie' e̱' kéka̱ mía̱ iyë́ ska'. “Mik idökemitke iyë́ ska', eta̱ iyë́ wö de iska' ta̱ idoia̱ ka̱mië ta̱ ie' wa iwër sia̱rë. Ie' tu̱nemi iñale̱tsu̱k ta̱ ipaklö'wé̱wa̱itö iwöalattséitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Eta̱ ilà tö iché ie' a̱: ‘A yë́wö, ye' tö ì sulu wamblé Skëköl ki̱ ñies be' ki̱. Ye' jaëne tai̱ë. Ye' kiök be' alà, e' kë̀ dör ye' sia̱rla e' a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Erë iyë́ tö iché ikanè mésopa a̱: ‘Datsi' bua'ie yulö́ iö́ka̱ ie' ki̱ bet, ta̱ ula'tsio iö́wa̱ ta̱ klökkuö iö́ka̱ iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Baka pupula bua'bua yulö́ ta̱ ittö́wa̱. Ye' alà dene e' ké̱wö tkö'we̱kesö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ye' alà i' dene, e' dör we̱s ie' du'wa̱ e' shke̱neka̱ne es. Ye' alà minea̱ ye' yöki̱ kë̀ tté ttsëneia̱ ye' wa̱, e' dene e' kue̱ki̱ iké̱wö tkö'ù̱sö.’ Eta̱ ie'pa tö iké̱wö tkö'wé̱mi tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“E' dalewa ilà kibi tso' kaneblök kañika̱. Mik ie' datse̱ e' de tsi̱net u a̱, eta̱ ie' tö ittsé tö iyamipa alárkerak tai̱ë blarkerak, klötöke tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Eta̱ ie' tö kanè méso kié eköl ta̱ ichakéitö: ‘¿Ì ké̱wö tkö'we̱ke a' tö ekkë?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Eta̱ kanè méso tö ie' iu̱té: ‘Be' ël dene, e' kue̱ki̱ be' yë́ tö sa' patké baka pupula bua'ie ttökwa̱ be' ël dene buaë, kë̀ we̱s ie' dë', e' ké̱wö tkö'wo̱ie.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Erë e' tö ilà kibi uluwé̱ka̱ tai̱ë. Ie' kë̀ shkakwa̱ we̱shke̱. E' kue̱ki̱ iyë́ e̱' yéttsa̱ u'rki̱ ta̱ iwöpablé tai̱ë ta̱ iché ie' a̱: ‘Be' shkö́wa̱ sa' ta̱, kë̀ be' ulunuk.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Erë ie' tö iyë́ iu̱té: ‘Ye' kaneblë'mi be' a̱ e' ki̱ duas de tai̱ë. Ye' kë̀ wa̱ be' ttö̀ dalöse̱o̱ulewa̱ yës. Erë chibola ë̀ kë̀ meule be' wa̱ ye' a̱ katano ye' sini'pa ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Erë i̱'ñe ta̱ be' alà e' dene. Ie' tö be' inuköl we'ikwa alakölpa sulusipa ta̱ eta̱ be' tö baka bua'ie ttökwa̱ patké ie' dene e' ké̱wö tkö'wo̱ie.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Iyë́ tö ie' iu̱té: ‘A alala, be' tkëria̱ ye' ta̱ ke̱kraë. Ì ko̱s tso' ye' wa̱ e' dör be' icha. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Erë be' ël dene buaë, e' dör we̱s ie' du'wa̱ e' shke̱neka̱ne es. Ie' minea̱ ye' yöki̱ kë̀ tté ttsënene ye' wa̱, e' dene, e' kue̱ki̱ s'ka̱wöta̱ e' ké̱wö tkö'u̱k chkè wa, di'yè wa, ttsë'ne bua' wa.’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ñies Jesús tö ttè kleé ittökatapa a̱ i' es: “Wëm bak eköl kaneblöke inuköl blú a̱ iíyi kue̱bluie. Etökicha ta̱ pë' we̱lepa tö ie' kkaté iwökir a̱ tö ie' tso' iwökir inuköl we'ikökwa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Iwökir tö ie' kié ta̱ iché ia̱: ‘Ye' wa̱ ijche̱newa̱ tö be' tso' ye' inuköl we'ikök. Be' kë̀ a̱ kanè ta̱'ia̱. Ye' be' trë'we̱keshkar. E' yöki̱ ì ko̱s kanewé̱ be' tö, e' yëkkuö kkachö́ ye' a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ie' ibikeitsé: ‘Ye' wökir tö ye' trë'we̱keshkar, ¿we̱s ye' e̱' ù̱mi? Kë̀ ye' diché ta̱'ia̱ kanè darërë wo̱ie ena ye' jaëne inuköl kakkiök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ye' é̱na ia̱netke tö we̱s ye' e̱' ù̱mi mik ye' trëneshkar eta̱ a̱s yile tö ye' kkö'nù.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Eta̱ ie' tö pë' ko̱s ña'we̱ke iwökir tö e'pa kiéttsa̱ eköl eköl. Mik e' tsá̱ de, eta̱ e' a̱ ie' tö ichaké: ‘¿Ko̱s be' ñarke ye' wökir ulà a̱?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","E' tö iu̱té: ‘Ye' ñarke ie' ulà a̱ kiö̀ döka̱ galon cien (100) ekkë.’ Ie' iché ia̱: ‘I' be' yëkkuö. Be' e̱' tkö́se̱r bet ta̱ yëkkuö se̱ ki̱ be' ñarke se̱, e' mane'ú̱ttsa̱ ta̱ ishtö́ka̱ tö be' ñarke galon döka̱ dabom ske̱yök ë̀ (50).’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","E' ukuöki̱ ta̱ ie' tö ichaké iëköl ñarke a̱: ‘¿Ñe be', ko̱s be' ñarke ye' wökir ulà a̱?’ E' tö iu̱té: ‘Ye' ñarke trigowö döka̱ saco cien (100) ekkë.’ Ie' tö iché ia̱: ‘I' be' yëkkuö. Se̱ ki̱ be' tö imane'ú̱ttsa̱ ta̱ ishtö́ iki̱ saco döka̱ dabom paryök ë̀ (80).’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mik ì wambléitö, e' jche̱newa̱ iwökir wa̱ ta̱ ibikeitséitö: ‘Ye' íyi kue̱blu kë̀ wa̱ ikanè o̱ne yësyësë, erë ie' ka̱bikeitso buaë e̱' ki̱moie. E' ë̀ kue̱ki̱ iki̱kekeka̱yö.’ ” Jesús tö ichéne: “Es ñies yö ichè tö wé̱pa kë̀ tö Skëköl dalöiè esepa ka̱bikeitsö̀ buaë e̱' ki̱moie tkö̀ka̱ wé̱pa dör ie' olo ta̱' tai̱ë e' icha esepa tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","E' kue̱ki̱ yö ichè a' a̱ tö inuköl kë̀ dör ibua'ie. E' wa s'male̱pa ki̱mú a̱s ie'pa tö Skëköl dalöiö̀. A' tö iwé̱ es e' ta̱ aishkuö ta̱ ie'pa tö a' kierawa̱ buaë we̱shke̱ se̱no wé yöbië e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Yi tö kanè tsitsir we̱ke yësyësë, ñies ese tö kanè tai̱ë wè̱mi es. Erë yi kë̀ tö kanè tsitsir we̱ku̱' yësyësë, ñies ese kë̀ tö kanè tai̱ë wè̱pa yësyësë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","E' kue̱ki̱ inuköl kë̀ wakanewè̱ a' tö yësyësë, e' ta̱ ¿yi e̱rblö̀mi a' mik ì tue̱ta̱' chökle, ese wakanéwo̱ie? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ñies a' kë̀ tö o̱'ka icha wakanewè̱ yësyësë, e' ta̱ ¿yi tö a' icha mèmi a' a̱ wakanewè̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Wé̱ klöulewa̱ kanè mésoie, ese ka̱wöta̱ iwökir ë̀ ttö̀ dalöiök. Iwökirpa chö́pa böl, e̱'ma ie' ka̱wöta̱ eköl ë̀ dalöiök ena iëköl watöktsa̱. Es a' kë̀ a̱ e̱r menukwa̱ Skëköl ki̱ ena inuköl ki̱ ñita̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ì ché Jesús tö e' ttsé se̱raa̱ fariseowakpa tö. Ie'pa é̱na inuköl dalër tai̱ë, e' kue̱ki̱ ie'pa tö iwayué. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ie' tö iché ie'pa a̱: “A' e̱' ö̀ sulitane wörki̱ tö a' dör pë' buaë yësyësë, erë a' e̱r su̱ule buaë Skëköl wa̱. Ì ki̱kekeka̱ s'ditsö tö tai̱ë, ese wër suluë ie' wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ì kit Moisés ena Skëköl ttekölpa tö yëkkuö ki̱, e' wa s'wöblao̱nebitu̱ dö̀ mik Juan S'wöskuökwak dë'bitu̱ eta̱. Erë e' itöki̱ ta̱ ì blúie Skëköl tso' e' tté buaë pakarke ta̱ sulitane tso' ima'u̱k darërëë diché wa dökwa̱ e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Ká̱ jaì ena ká̱ i' e̱rta̱'wa. Erë Skëköl yëkkuö kitule, e' kë̀ e̱rta̱'wa yës, e' wà tköraë se̱raa̱ döwa̱ ttè bataë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Wëm tö itayë éwa ese tö tayë skà tsé̱wa̱ne, e' ta̱ e' wa ie' tö ise̱newa̱bak ke̱we e' dalöse̱wé̱wa̱. Ñies tayë a'wa iwëm tö, ese tsé̱wa̱ne wëm o̱'ka tö, e' ta̱ e' wa ie' tö tayë e' se̱newa̱bak ke̱we e' dalöse̱wé̱wa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Inuköl blú bak eköl e' e̱' paiö̀ datsi' bua'bua ë̀ wa. Ke̱kraë ie' chköke, di' yöke buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ñies s'sia̱rë bak eköl kiè Lázaro, e' e̱' tkökese̱r blu' e' u wékkö a̱. Ie' pa dör smewö ë̀me. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ie' é̱na blu' chkè po darke, e' ñakwa̱ suluë. Chichi döke ie' smewö pakuyök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ká̱ et ta̱ ie' sia̱rla blënewa̱, ta̱ Skëköl biyöchökwakpa tö ie' wimblu tsé̱mi ká̱ jaì a̱ chkök Abraham ta̱. Ñies inuköl blú ñe' blënewa̱ ta̱ inú wötënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Eta̱ ie' tso' weinuk sia̱rë wé̱ s'wimblu weirke ee̱ ta̱ iwökéka̱ ta̱ Abraham sué̱itö ka̱mië ká̱ bánet, e' batsi̱' a̱ Lázaro tkër. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Eta̱ ie' a̱r tai̱ë Abraham wöa̱ ta̱ ichéitö: ‘¡A këkëpa Abraham, ye' sa̱ú̱ e̱r sia̱rë wa! Ye' weirke tai̱ë bö' i' a̱. Be' we'ikèyö, Lázaro patkö́ iulatska bata nuu̱kka̱ di' a̱ ta̱ ipatkö́ ye' ku' nuu̱kka̱ a̱s ipase̱r.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Erë Abraham tö iiu̱té: ‘Be' é̱na ia̱nú tö mik be' bak ttsë'ka, eta̱ íyi buaë ko̱s bak be' wa̱. E' skéie Lázaro bak weinuk sia̱rë. Erë i̱'ñe ta̱ ie' wöpablëne buaë, e' skéie be' weirkene sia̱rë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kí̱ie ta̱, ká̱blë i̱ski̱ë e' tso' se' shu̱sha̱ë. E' kue̱ki̱ sa' shkak a' ska', esepa kë̀ dö̀pa a' ska'. Ñies a' shkak sa' ska', esepa kë̀ dö̀pa sa' ska'.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Inuköl blú tö iché: ‘A yë́wö Abraham, ye' kköchö̀ be' a̱, Lázaro patkö́ ye' yë́ u a̱ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ye' ëlpa döka̱ ske̱l, e'pa pattök a̱s ie'pa kë̀ dö̀ ká̱ i' a̱ wé̱ s'weirke sia̱rë ee̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham tö iché ie' a̱: ‘Ì kit Moisés ena Skëköl ttekölpa male̱pa e'pa tö yëkkuö ki̱, e' tso' ie'pa wa̱, ¡a̱s ttè e' iu̱tö̀ ie'pa tö!’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Blu' tö iiu̱té: ‘A yë́wö Abraham, e' kë̀ dör wë'. Erë se' duowa̱ eköl shke̱neka̱ne ese tö ie'pa patté, e' ta̱ ie'pa e̱r mane'u̱raë.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Erë Abraham tö iché ia̱: ‘Ttè kit Moisés ena Skëköl ttekölpa e'pa tö, e' kë̀ iu̱tëne ie'pa wa̱, e' ta̱ s'du'wa̱ shke̱neka̱ne ese mía̱ ie'pa pattök, e' ta̱ ñies ie'pa kë̀ tö ie' ttö̀ iu̱tepa.’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús tö iché ittökatapa a̱: “Ke̱kraë se' e̱rkiöo̱rke ì sulu wamblök; ¡erë yi tö se' e̱rkiöwe̱ke, esepa tö inuí̱ sue̱raë! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yi tö ikkëpala e̱rblöke ye' mik, esepa eköl ké ì sulu wamblök, esepa weirdaë sia̱rë shu̱te̱ tkö̀ka̱ ák wawoie mué̱wa̱ ikuli' a̱ batrèemi dayë a̱ e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡A' tso' wösh wa! “A' yami tö ì sulu wamblé a' ki̱, e' ta̱ iuñú. Ie' e̱r mane'wé̱ne, e' ta̱ inuì̱ olo'yö́ iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Erë́ ká̱ etkë̀ a̱ ie' tö ì sulu wamblé a' ki̱ döka̱ kuktökicha (7), erë ie' iché döka̱ kuktökicha: ‘ye' e̱r mane'wé̱ne,’ e' ta̱ ilo'yö́ iki̱.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Eta̱ Skëkëpa Jesús ttekölpa tsá̱ e'pa tö ie' a̱ iché: —Sa' ki̱mú kí̱ e̱rblök Skëköl mik. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ie' tö ie'pa iu̱té: —A' e̱rblö́pa Skëköl mik tsir we̱s mostaza wö dör tsirla ekkë, e̱'ma a' tö ichèmi kal bërie i' a̱: ‘Be' e̱' yö́ttsa̱ í̱e̱ e̱' tkö́wa̱ dayë a̱’, ta̱ iyërdattsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ichö̀sö tö a' we̱le wa̱ kanè méso tso' eköl, e' mía̱ të tök alè ö a' iyiwak kkö'nuk alè. Mik idene u a̱, eta̱ a' kë̀ tö ichepa ie' a̱: ‘We̱shke̱, be' e̱' tkö́se̱r chkök, ye' tö be' tieke.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A' kë̀ tö ichepa ia̱ es. E' skéie a' tö ichera ie' a̱: ‘Be' datsi' mane'ú̱, be' u̱lö́ ye' a̱ ta̱ ye' tiö́. Ye' panú, ye' chké o̱ne, ye' di' yane o̱ne, e' wa be' mi' chkök.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ie' tö iwé̱ we̱s a' tö ie' ké iu̱k es, e' ki̱ a' kë̀ tö wëstela chepa ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Es ñies mik ì u̱k Skëköl tö se' ké, ese wé̱sö se̱raa̱, eta̱ ichö̀sö ie' a̱ i' es: ‘Ì u̱k sa' kàne, e' ë̀ wé̱ sa' tö. Sa' dör kanè mésopa ësepala ë̀.’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús michoë Jerusalén, e' damitkö Samaria ena Galilea. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mik ie' dökemitke ká̱ tsitsirla a̱ ta̱ ee̱ wëpa döka̱ dabop kiri'we̱ke lepra tö, e'pa e̱' yéttsa̱ iëte̱r ka̱mië ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ta̱ ia̱rkerak Jesús tsa̱ka̱: —¡A Jesús, a s'wöbla'u̱kwak, sa' sa̱ú̱ e̱r sia̱rë wa! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mik ie' tö ie'pa sué̱, eta̱ ichéitö ie'pa a̱: —A' yú e̱' kkachök sacerdotepa a̱ a̱s sulitane wa̱ ijche̱r tö a' buanene. Ie'pa mirwa̱ia̱ ñala̱ ki̱ e' dalewa ie'pa buanene. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mik ie'pa eköl tö isué̱ tö ibuanene, eta̱ ibite̱a̱ne Jesús ska' Skëköl ki̱kökka̱ tai̱ë a̱neule. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ie' e̱' tkéwa̱ kuchë ki̱ iwö méwa̱ íyök ki̱ Jesús klö̀ ska' wëstela chök. Wëm e' dör Samaria wak. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús tö iché ia̱: —¿A' buanene e' kë̀ dör dabop? ¿Wé̱ be' male̱pa su̱li̱tu (9)? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wëm dör ká̱ kua̱'ki̱ wak ¿e' ë̀ bite̱a̱ne Skëköl ki̱kökka̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ie' tö iché wëm a̱: —Be' e̱' kö́ka̱ be' yúshkane. Be' e̱rblé ye' mik, e' tö be' bua'wé̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseowakpa tö ichaké Jesús a̱: —Ì blúie Skëköl tso', ¿mik e' ké̱wö datse̱? Ie' tö ie'pa iu̱té: —Ì blúie Skëköl tso' e' kë̀ dör íyi suè̱mi sulitane tö ese. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Itso'tke a' shu̱a̱, e' kue̱ki̱ kë̀ yi a̱ iyërpa, ‘Í̱e̱ itso'’, ö ‘Wì̱e̱ itso'’. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ta̱ ichéitö ittökatapa a̱: —Iké̱wö döraë mik a' tö ibikeitseraë: ‘Jesús dör S'ditsö Alà, e' mú dö̀ i' ta̱ s'blúie. E' diwö et ë̀ kkechekesö suè̱.’ A' tö bikeitseraë es, erë a' kë̀ tö isue̱pa ka̱m ye' döne e' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","We̱lepa tö icheraë: ‘Í̱e̱ ie' de’, ö ‘Diàe̱ ie' de’; erë kë̀ a' minuk isa̱u̱k, kë̀ a' minuk itöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ye' dör S'ditsö Alà, mik e' dene, eta̱ sulitane tso' ká̱ wa'ñe e'pa tö isue̱raë we̱s alá wöñar tö ká̱ olo ppèe ká̱ wa'ñe e' suè̱sö es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Erë e' yöki̱ ke̱we ye' ka̱wöta̱ weinuk tai̱ë ye' bolökpa ulà a̱, ie'pa tö ye' waterattsa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ye' dör S'ditsö Alà, mik e' dene, eta̱ e' ké̱wö döraë we̱s Noé ké̱ska' es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","E' ké̱wö ska' ta̱ ie'pa tso' chkök, di'yök, se̱nukwa̱ we̱s ke̱kraë es dö̀ mik Noé dewa̱ ikanò bërie e' a̱ eta̱. E' bet ta̱ di' dettsa̱ tai̱ë ie'pa ki̱, e' tö ie'pa ulitane ttélur. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Es ñies iwamblëne wëm bak kiè Lot, e' ké̱wö ska' ta̱. Sodoma wakpa tso' chkök, di'yök, ie'pa tso' íyi ta̱u̱k ena íyi watau̱k, ie'pa tso' íyi kuatkök ena u yuök we̱s ke̱kraë es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Erë mik Lot e̱' yéttsa̱ Sodoma, eta̱ azufre datse̱ ká̱ jaì a̱ wöñarke bö'ie, ese yëne ká̱ e' ki̱ we̱s ka̱li̱ es, e' tö ie'pa ko̱s ttélur. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Es itköraë mik ye' dör S'ditsö Alà, e' dene eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Mik e' ké̱wö de, eta̱ yi tso' u bata ki̱, ese kë̀ dökwa̱ne we̱shke̱ iíyi tsu̱kmi. Ñies yi tso' kaneblök kañika̱, ese kë̀ dökwa̱ne we̱shke̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ì bak Lot alaköl ta̱ e' ska' a' e̱r a̱nú. Ie' yönane dayë wösiie, ie' é̱na iíyi dalër tai̱ë e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yi e̱' tsa̱tkak ittèwa̱ yöki̱, ese ulà a̱ se̱ne michoë kë̀ dö̀pa aishkuö ta̱. Erë yi e̱' mettsa̱ ttèwa̱ ye' dalërmik, ese ulà a̱ se̱ne michoë döraë aishkuö ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ye' tö a' a̱ ichè tö e' nañewe se' böl kapöke ka̱' etkë̀ ki̱, ta̱ eköl mira iwa̱ ta̱ iëköl a̱tdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Alakölpa böl tulur ák wawök ñita̱ ta̱ eköl mira iwa̱ ta̱ iëköl a̱tdaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesús ttökatapa tö ie' a̱ ichaké: —A Skëkëpa, ¿wé̱ e' wamblërmi? Jesús tö ie'pa iu̱té ttè i' wa: —Sulitane wa̱ ijche̱r tö wé̱ ölö́ daparke tai̱ë, ee̱ ilè nu tër. Es ilè sue̱raë a' tö iwà kkachoie tö wé̱ iwamblërmi. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús é̱na ikkachak ittökatapa a̱ tö s'ka̱wöta̱ ikiök S'yë́ a̱ ke̱kraë kë̀ shtrirta̱'wa̱, e' kleéitö ie'pa a̱ i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Ká̱ et ki̱ s'shu̱lökwak eköl tso', e' kë̀ suarta̱' Skëköl yöki̱, ñies ie' kë̀ tö yi dalöieta̱'. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ká̱ e' a̱ ñies alaköl dör schö́ tso' eköl, e' ñippöke ibolök ta̱. Ke̱kraë ie' mía̱ s'shu̱lökwak ñe' ska' ta̱ ichekeitö ia̱: ‘Ye' ki̱mú. Ye' bolök tö ye' we'ikeke, e' shu̱lö́ ye' a̱’. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","E' tka ká̱ tai̱ë erë s'shu̱lökwak kë̀ wa̱ iiu̱tëne. Bata ekkë ta̱ s'shu̱lökwak tö ibikeitsé: ‘Alaköl schö́ i' tso' ye' tsiriu̱k ñië. Erë́ ye' kë̀ suarta̱' Skëköl yöki̱, ñies kë̀ ye' tö yi dalöieta̱', ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","erë ie' tté shu̱leraëyö a̱s kë̀ idöia̱ ye' shtriu̱k tai̱ë ttè e' wa.’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Skëkëpa tö ikí̱ ché: “Ì ché s'shu̱lökwak suluë ñe' tö e' bikeitsö́ buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wé̱pa shu̱kitulebak Skëköl wa̱, tso' ie' a̱ ikiök ñië nañeë, ¿esepa kë̀ tsa̱tkepaitö? ¿Ie' tö ie'pa keraë ipanuk? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ye' ichè, au. Ie'pa tsa̱tkeraitö bet, kë̀ dör ká̱ tai̱ë. Erë ye' dör S'ditsö Alà, mik e' dene, eta̱ s'e̱rblöke Skëköl mik, ¿esepa kuè̱miyö ká̱ i' a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pë' tso' Jesús ttö̀ ki̱ttsök, e'pa we̱lepa e̱' bikeitsö̀ tö ie'pa se̱rke yësyësë Skëköl wöa̱, erë ie'pa wöska sulu s'male̱pa wër. Esepa a̱ ie' tö ttè kleé i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Wëpa böl mía̱ Skëköl wé a̱ ttök S'yë́ ta̱. Eköl dör fariseowak, eköl dör inuköl shtökwak Roma wökirpa a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","fariseowak ttödur S'yë́ ta̱, ie' iché i' es: ‘A Skëköl, wëstela chekeyö be' a̱ tö ye' kë̀ dör suluë we̱s s'male̱pa es. Ie'pa dör akblökwakpa ena pë' sulusipa ena s'se̱newa̱bak e' dalöse̱u̱kwa̱ wakpa. Ñies ye' kë̀ dör suluë we̱s inuköl shtökwak dur wí̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Domingo bit ta̱ ye' batsöke ká̱ böt ká̱ böt ke̱kraë. Ñies ì ko̱s de ye' ulà a̱, e' blatekeyö döka̱ dabop, e' tsá̱ eyök mekeyö be' a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Erë inuköl shtökwak e' dur bánet, ie' e̱riane tai̱ë, ie' wö ë̀ kë̀ kaneka̱ ká̱ jaì sa̱u̱k, ie' batsi̱' ë̀ töke iulà wa ie' e̱riane tai̱ë kue̱ki̱. Ie' tö iché: ‘¡A Skëköl, ye' dör pë' sulusi, ye' sa̱ú̱ e̱r sia̱rë wa!’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesús tö ichéne: Ye' tö a' a̱ ichè tö yi e̱' ttsö̀ka̱ tai̱ë ese wöardawa, erë yi e̱' wöéwa ese ki̱kardaka̱ tai̱ë. E' kue̱ki̱ inuköl shtökwak ñe' mía̱ne iu a̱ klö'wé̱ Skëköl tö we̱s pë' buaë yësyësë es. Erë fariseowak kë̀ minene es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pë' wa̱ ala'rla debitu̱ Jesús ska' a̱s ie' ulà mùka̱ iki̱. Erë mik e' sué̱ ittökatapa tö, eta̱ ie'pa tö pë' uñélor. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Erë ie' tö ittökatapa kié ta̱ ichéitö: —A̱s ala'rla bitu̱ ye' ska'. Wé̱pa dör we̱s ie'pa es, esepa blúie Skëköl tso', e' kue̱ki̱ kë̀ iwöklö'wa̱ria̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Moki̱ ye' tö ichè tö yi kë̀ e̱' wöö̀wa we̱s alala es, ì blúie Skëköl tso' e' kiowa̱, ese kë̀ döpawa̱ia̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Judiowak wökir eköl tö Jesús a̱ ichaké: —A S'wöbla'u̱kwak, be' dör buaë, ¿ì wè̱mi ye' tö a̱s se̱ne michoë dö̀ ye' ulà a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ie' tö iiu̱té: —¿Ì kue̱ki̱ be' ye' kié buaë? Skëköl eköl ë̀ dör buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ttè me'a̱tbak ie' tö dalöiëno, e' jche̱r be' wa̱ buaë. E' tö ichè: ‘Kë̀ a' ka̱wö ta̱' s'se̱newa̱bak dalöse̱u̱kwa̱, kë̀ a' ka̱wö ta̱' s'ttökwa̱, kë̀ a' ka̱wö ta̱' akblök, kë̀ a' ka̱wö ta̱' s'kkatök ka̱chè wa, a' yë́ ena a' mì dalöiö́.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wëm e' tö ie' a̱ iché: —Ttè e' ko̱s dalöië'bitu̱ ye' tö, ye' ià̱ duladula eta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ie' tö ttè e' ttsé ta̱ ie' iiu̱té: —Íyi etkë̀ kianeia̱ be' a̱ wè̱, e' dör i': ì tso' be' wa̱, e' wataú̱ttsa̱ se̱raa̱ ta̱ iské múttsa̱ s'sia̱rëpa a̱. E' ukuöki̱ ta̱ be' shkö́ ye' ta̱ ye' ttökataie. Es ta̱ íyi buaë tai̱ë döraë be' ulà a̱ ká̱ jaì a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Erë wëm e' dör inuköl blú tai̱ë e' kue̱ki̱ mik ie' tö e' ttsé, eta̱ ie' e̱rianeka̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús tö isué̱ tö ie̱riane ta̱ ichéitö ia̱: —¡Inuköl blúpa a̱ darërëë idir dökwa̱ ì blúie Skëköl tso' e' a̱! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Esepa a̱ döka̱ ee̱, e' dör darërëë tkö̀ka̱ kameio tkö̀mi datsi' yuo diké ese wöukla a̱ e' tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wé̱pa tso' ittsök e'pa tö ichaké Jesús a̱: —E' dör es, e̱'ma ¿yi tsa̱tkërmi? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ie' tö ie'pa iu̱té: —Ì kë̀ o̱r s'ditsö a̱, ese o̱rmi Skëköl a̱ buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Eta̱ Pedro tö ie' a̱ iché: —Ittsö́, sa' íyi ko̱s me'a̱t sa' tö ta̱ sa' bite̱ be' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ie' tö iché ie' a̱: —Moki̱ ye' tö a' a̱ iché tö yi isie tö iu ö ilaköl ö iëlpa ö iyë́ ö imì ö ila'r, e' méa̱t ì blúie Skëköl tso' e' dalërmik, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ese ulà a̱ iské dörane tai̱ë shu̱te̱ ká̱ i' a̱, ñies aishkuö ta̱ se̱ne michoë döraë iulà a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús tö ittökatapa dabom eyök kí̱ böl (12), e'pa kiémi bánet ta̱ ichéitö ie'pa a̱: “Se' mirka̱ Jerusalén i', eta̱ ee̱ ì ko̱s kita̱t Skëköl ttekölpa tö yëkkuö ki̱ e' wà tköraë, ye' dör S'ditsö Alà, e' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ie'pa tö ye' wömerattsa̱ pë' kë̀ dör judiowak esepa ulà a̱. E'pa tö ye' wayueraë, cheraë suluë, iwiri tuörarak ye' ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ie'pa tö ye' pperaë, ye' tterawa̱; erë e' ki̱ ká̱ de mañat eta̱ ye' shke̱rdaka̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Erë ì ché ie' tö ittökatapa a̱, e' wà blëulewa̱ ie'pa yöki̱, e' kue̱ki̱ ie'pa kë̀ a̱ iwà a̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mik Jesús demi tsi̱net Jericó, eta̱ ee̱ wëm tkër eköl ñala̱ ska' inuköl kak kiök. Ie' wöbla kë̀ wawër. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mik ie' tö ittsé tö pë' dami tai̱ë ñala̱ ki̱, eta̱ ie' tö ichaké tö ¿ì wamblërke? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ie'pa tö iché ie' a̱ tö Jesús Nazaret wak dami ñala̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","E' kue̱ki̱ ie' tö iché a̱neule: —¡A Jesús, s'blú David bak e' aleri, ye' sa̱ú̱ e̱r sia̱rë wa! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pë' dami Jesús yöki̱ ke̱we, e' tö wëm e' uñeke a̱s isiwa̱'blö̀wa̱. Erë ie' tö ikí̱ ché a̱neule: —¡A David aleri, ye' sa̱ú̱ e̱r sia̱rë wa! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús e̱' duése̱r ta̱ itsu̱k patkéitö. Mik ide, eta̱ Jesús tö ie' a̱ ichaké: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ì kiane be' ki̱ tö ye' tö iwè̱ be' a̱? Ie' iiu̱té: —A këkëpa, ye' ki̱ ikiane tö ye' wöbla buarne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús tö ie' a̱ iché: —¡Be' e̱rblé ye' mik, e' wa be' buanene! ");
INSERT INTO bzdNTpo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","E' wösha̱ ta̱ ie' wöbla buanene ta̱ imía̱ Jesús ta̱ e' tö Skëköl ki̱keka̱rami tai̱ë. Ñies wé̱pa ko̱s tö isué̱ e'pa tö Skëköl ki̱keka̱rami tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús de Jericó, e' shkö̀dur ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ee̱ wëm eköl se̱rke kiè Zaqueo, e' dör inuköl shtökwakpa Roma wökirpa a̱, e'pa wökir. Ie' dör inuköl blú tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ie' ki̱ Jesús kiane suè̱, erë ie' dör tsirlala i̱ski̱la, tai̱ë pë' tso', e' kue̱ki̱ ie' kë̀ wö dë'ka̱ Jesús sa̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","E' kue̱ki̱ ie' tu̱nemi wé̱ Jesús tkökemi ee̱ tkaka̱ kal ulà a̱ ipanuk suè̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mik Jesús dökemitke kal e' diki̱a̱, eta̱ iwökéka̱ ta̱ iché Zaqueo a̱: —A Zaqueo, be' e̱' ö́wa bet. I̱'ñe ye' mi'ke be' ska' kapökrö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueo e̱' éwa bet ta̱ Jesús kiéwa̱itö iu a̱ ttsë'ne buaë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mik pë' ulitane tö isué̱, eta̱ ie'pa tö Jesús ché suluë. Ie'pa tö iché ñì a̱: “¿Iö́k ie' mi'ke pë' sulusi u a̱?” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueo e̱' duéka̱ ta̱ iché Skëkëpa Jesús a̱: —A këkëpa, ye' ttö̀ ttsö́. Ì ko̱s tso' ye' wa̱, e' sha̱böts meraëyö s'sia̱rëpa a̱. Ñies yile íyi ekibléyö, e' ta̱ e' mekeneyö ie' a̱ döka̱ tkëtökicha. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús tö iché ie' a̱: —Be' dör Abraham aleri, erë be' e̱rblé Skëköl mik moki̱ we̱s Abraham es, e' kue̱ki̱ i̱'ñe ta̱ be' de Abraham alà chö́kie. E' kue̱ki̱ i̱'ñe be' tsa̱tkëne, ñies wé̱pa tso' be' u a̱ e̱rblé Skëköl mik e'pa tsa̱tkëne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ye' dör S'ditsö Alà, e' dë'bitu̱, wé̱pa chë'ulur ì sulu ulà a̱ esepa yulök tsa̱tkè. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesús dökemitke Jerusalén. Pë' tso' ie' ttö̀ ki̱ttsök, e'pa tö ibikeitsé tö mik ie' de Jerusalén eta̱ ì blúie Skëköl tso' e' ké̱wö dewa̱tke da'a̱ie. E' kue̱ki̱ ie' tö ie'pa a̱ ikleé i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Wëm tso' eköl dör blu' ditséwö, e' mía̱ ka̱mië ká̱ kua̱'ki̱ a̱ iblú kibi ska' a̱s e' tö ie' tkö̀ka̱ blu'ie, wé̱ ie' bite̱ ee̱. E' ukuöki̱ ta̱ ibitu̱kea̱ne. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ka̱m ie' mi', eta̱ ie' tö ie' kanè mésopa kié dabop, e'pa a̱ ie' tö inuköl mé tai̱ë ñikkëë eköl eköl a̱. Ie' tö iché ie'pa a̱: ‘A' tö inuköl se̱ wakaneú̱ dö̀ mik ye' döne eta̱, isuo̱ie ko̱s a' tö ikí̱ klö'wè̱mi.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Erë pë' se̱rke ie' ka̱ska', e'pa é̱na ie' a̱r suluë. E' kue̱ki̱ ie'pa we̱lepa patkérakitö blu' kibi ska' ichök: ‘Sa' kë̀ ki̱ ie' kiane sa' blúie, e' kue̱ki̱ kë̀ itkarka̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Erë blu' kibi tö ie' tkéka̱ blu'ie ta̱ ie' mía̱ne wé̱ ibite̱ ee̱. Mik ie' dene, eta̱ ie' tö ikanè mésopa dabop, wé̱pa a̱ ie' tö inuköl me'a̱t, e'pa kiök patké isuo̱ie tö ko̱s inuköl kí̱ klö'wé̱rakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Itsá̱ debitu̱ tö iché iblú a̱: ‘A këkëpa, be' inuköl wakanewé̱yö, e' kí̱ klö'wé̱yö döka̱ dabobtökicha.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Blu' tö ie' iu̱té: ‘E' dör buaë. Be' dör kanè méso buaë. Ì elkela wakanewé̱bö yësyësë, e' kue̱ki̱ ye' tö be' tkekeka̱ ká̱ dabop, e' wökirie.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Iskà debitu̱ tö iché: ‘A këkëpa, be' inuköl wakanewé̱yö, e' kí̱ klö'wé̱yö döka̱ ske̱tökicha.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ñies blu' tö ie' iu̱té: ‘Ye' tö be' tkekeka̱ ká̱ ske̱l, e' wökirie.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Erë iëköl debitu̱, e' tö iblú a̱ iché: ‘A këkëpa, i' be' inuköl. Ye' tö ipatréwa̱ tsa̱mo a̱ ta̱ ibléyö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Be' dör wëm e̱r darërëë ese. Ì kë̀ dör be' icha ese klö'we̱kewa̱bö. Ñies be' tö íyi wöshteke wé̱ kë̀ be' wa̱ ikuatkëne ee̱. Ye' suane be' yöki̱, e' kue̱ki̱ ye' tö be' inuköl blé.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Eta̱ blu' tö ie' a̱ iché: ‘Be' dör kanè méso sulusi ese. Ye' tö be' kichaterattsa̱ be' wák ttè wa. Be' tö iché tö ye' dör wëm e̱r darërëë ese. Be' tö iché tö ì kë̀ dör ye' icha ese klö'we̱kewa̱yö, ñies tö ye' tö íyi wöshteke wé̱ kë̀ ye' wa̱ ikuatkëne ee̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","E' dör es, e' ta̱ ¿ì kue̱ki̱ be' kë̀ wa̱ ye' inuköl blëne inuköl bló wé a̱ a̱s ee̱ ikí̱ klör? Be' tö iú̱pa es, e̱'ma mik ye' dene, eta̱ ye' inuköl ena ikí̱ klöne e' de ye' ulà a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Eta̱ blu' tö iché itso'rak ee̱, e'pa a̱: ‘Inuköl yö́ttsa̱ ie' ulà a̱, ta̱ imú wé̱ wa̱ itso' dabop, e' a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Erë ie'pa tö blu' a̱ iché: ‘A këkëpa, erë ¿ì kue̱ki̱ be' tö ie' a̱ ikí̱ meke, ie' wa̱ itso'tke dabop?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ie' tö ie'pa iu̱té: ‘Ye' tö a' a̱ iché tö wé̱ wa̱ íyi tso', ese a̱ ikí̱ merdaë. Erë wé̱ kë̀ wa̱ ì ku̱', ì tso' ese wa̱ elkela, e' yerattsa̱ iyöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wé̱pa kë̀ ki̱ ye' kiane blu'ie, e'pa dör ye' bolökpa; ie'pa tsú̱bitu̱ í̱e̱ ta̱ ittö́lur ye' wörki̱.’ ” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús ttè paké o̱ne, eta̱ ie' mirka̱ia̱ Jerusalén ñalé̱ ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mik idökemitke tsi̱net Betfagé ena Betania a̱te̱ ka̱bata kiè Olivo ké̱bata e' kuli' a̱, eta̱ ie' tö ittökatapa böl kié ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ta̱ ichéitö ia̱rak: —A' yú ke̱we, u tso' se' wösha̱ë e' a̱, eta̱ ee̱ burro kue̱raë a' tö etö moule kë̀ ki̱ yi e̱' tkëuleka̱ ese. E' wötsö́ö ta̱ itsú̱bitu̱ ña. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Yile tö a' a̱ ichaké: ¿Ìie a' tö iwötseeke? e' ta̱ iiu̱tö́: Skëkëpa ki̱ ikiane. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ittökatapa míyal ta̱ ikué̱rakitö we̱s Jesús tö iché ie'pa a̱ es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ie'pa tso' burro wötsöök ta̱ burro wakpa debitu̱ ta̱ ichakéitö: —¿Ìie a' tö burro se̱ wötseeke? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ie'pa tö iu̱té: —Skëkëpa Jesús ki̱ ikiane e' kue̱ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Eta̱ ittökatapa wa̱ burro bite̱tse̱r Jesús a̱. Ie'pa tö ipaio ki̱kke̱ méka̱ burro ki̱, ta̱ Jesús ki̱merakitö e̱' tkökka̱ iki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús mirka̱ia̱ Jerusalén ñalé̱ ki̱, ee̱ pë' tso' tai̱ë, e'pa tö paio ki̱kke̱ shuélor ñala̱ ki̱ ke̱we Jesús yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ie'pa mirwa̱ Olivo ké̱bata kuli' a̱ wö wa'k. Iklépa tso' tai̱ë, e'pa a̱nemi ttsë'ne buaë wa. Skëköl ki̱kéka̱rakitö tai̱ë. Ì kë̀ o̱r yi a̱ ese o̱' Jesús tö tai̱ë ie'pa wörki̱, e' kue̱ki̱ Skëköl ki̱kéka̱rakitö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ie'pa tö iché: —¡Ayëcha buaë s'blú i' datse̱ Skëköl ttö̀ wa! Skëköl tso' ká̱ jaì a̱ olo ta̱' tai̱ë a̱s e' ta̱ se' se̱r bë̀rë. Ie' ki̱köka̱sö. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pë' shu̱a̱ fariseowakpa we̱lepa tso', e'pa tö iché Jesús a̱: —Be' klépa uñú. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Erë ie' tö ie'pa iu̱té: —Ye' tö iché a' a̱ tö ie'pa siwa̱'bléwa̱, e' ta̱ ák tö ye' ki̱keraka̱ a̱neule. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mik ie' de tsi̱net Jerusalén, eta̱ ie' ikí̱ sué̱ ta̱ ie' i̱é̱ idalërmik. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ie' tö ibikeitsé: ¡A' mú wa̱ ijche̱r i̱'ñe tö we̱s a' se̱rmi bë̀rë Skëköl ta̱! Erë e' tso' blëule a' yöki̱, e' kue̱ki̱ a' kë̀ a̱ isu̱rpa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ka̱wö sulu döraë a' ki̱. A' bolökpa döraë, e'pa tö a' ká̱ köierawa̱ shkit a̱s a' kë̀ tkö̀yal. Ie'pa miraë ñippök a' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ie'pa tö a' ká̱ ena a' wakpa ko̱s e̱we̱rawa. A' u ko̱s olordawa̱, e' éki kë̀ a̱tpa ñì bata ki̱. Skëköl de a' tsa̱tkök, e' ké̱wö de a' ki̱ erë iwatéttsa̱ a' tö. E' kue̱ki̱ e' ko̱s tköraë a' ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","E' ukuöki̱ ta̱' Jesús de Skëköl wé a̱, ta̱ ie' tö íyi watau̱kwakpa trë'wé̱yalmi, ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ta̱ ichéitö ie'pa a̱: —Skëköl tö iyë' iyëkkuö ki̱: ‘Ye' u dör tto ye' ta̱ wé’, erë a' tö iia'wé̱ka̱ akblo wéie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ke̱kraë Jesús tö s'wöbla'we̱ke Skëköl wé a̱. Sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa ñies judiowak wökirpa male̱pa, e'pa tö ileritsekerak Jesús ttowa̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Erë judiowak male̱pa ulitane tö ie' ttöke e' ki̱ttseke e̱r bua' wa, e' kue̱ki̱ ibolökpa kë̀ ulà dë'wa̱ ittökwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Etökicha ta̱ Jesús tso' s'wöbla'u̱k ena Skëköl ttè buaë e' pakök Skëköl wé a̱ ta̱ ee̱ sacerdotepa wökirpa ena s'wöbla'u̱k ttè dalöiëno wa wakpa ena judiowak kue̱blupa e'pa de. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ie'pa tö ichaké ie' a̱: —¿Yi ttö̀ wa be' tö íyi ikkë we̱ke? ¿Yi tö e' ké̱wö mé be' a̱? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Ie' iiu̱té: —Ñies ye' tö a' a̱ ilè chakeke: ¿Yi tö Juan patkë' s'wöskuök? ¿Skëköl tso' ká̱ jaì a̱ e' ö s'ditsö? Ye' iu̱tö́. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eta̱ ie'pa ichémi ñì a̱: “Se' tö ichèmi tö Skëköl tö Juan patkë', e' ta̱ ie' tö se' iu̱tèmi: ‘¿Ì kue̱ki̱ a' kë̀ wa̱ ie' ttè klöo̱ne?’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ñies pë' ulitane tö iklö'wé̱ tö moki̱ë Juan dör Skëköl tteköl, e' kue̱ki̱ kë̀ se' a̱ iyënuk tö ipatkë' s'ditsö tö. Se' tö iché es, e' ta̱ ie'pa tö se' ttèwa̱mi ák wa.” ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","E' kue̱ki̱ ie'pa tö iiu̱té: —Kë̀ sa' wa̱ ijche̱r tö yi tö Juan patkë' s'wöskuök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ie' tö ie'pa a̱ iché: —Es ñies ye' kë̀ tö a' a̱ ichepa yi tö ye' a̱ ka̱wö mé íyi ikkë wo̱ie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","E' ukuöki̱ ta̱ Jesús ttémi pë' ta̱ ta̱ ttè kleéitö i' es: “Wëm eköl tö uva kuatké tai̱ë. Ie' tö ipeitéa̱t wëpa we̱lepa a̱ a̱s ie'pa tö ipataù̱ ie' a̱ iwörke e' kak wa. E' ukuöki̱ ta̱ ie' mía̱ ká̱ kua̱'ki̱ dö̀ ká̱ tai̱ë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mik uva wöline tso'tke wë'ià̱ë shtè, eta̱ ie' tö ikanè méso patkémi eköl ie' icha tsu̱k. Erë kanéu̱kwakpa tö ikanè méso klö'wé̱wa̱, ppé sia̱rë, ta̱ ipatkémine ulà wöchka. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Eta̱ iwák tö ikanè méso skà patkémine eköl. Ñies e' ché ie'pa tö suluë, ppé sia̱rë, ta̱ ipatkémine ulà wöchka. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ikanè méso skà patkémine ie' tö eköl, eta̱ ñies e' shka̱'wé̱rakitö tai̱ë, ta̱ itrë'wé̱shkar. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Bata ekkë ta̱ iwák tö iché: ‘¿Ì wè̱mi ye' tö? Ye' alà dalër tai̱ë ye' é̱na, e' patkerami ye' tö. Isalema ie'pa tö ie' dalöièmi.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Erë mik kanè mésopa tö kanè wák alà sué̱, eta̱ ie'pa tö iché ñì a̱: ‘Ie' wì̱ dör ká̱ i' wak alà, e' a̱ ká̱ i' a̱tdaë. E' kue̱ki̱ ittöwa̱sö, eta̱ es ká̱ i' a̱tdaë se' ulà a̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","E' kue̱ki̱ ie'pa tö iklö'wé̱wa̱ yéttsa̱ bánet ta̱ ittéwa̱rakitö. “Ye' tö a' a̱ ichakè: ¿I̱ma a' ibikeitsé? ¿Ì we̱raë kanè wák tö? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yö ichè tö ie' miraë ta̱ kanéu̱kwakpa tteratulur, ta̱ uva kané meraneitö pë' kua̱'ki̱ a̱.” Mik e' ttsé judiopa wökirpa tö, eta̱ ie'pa tö iché: —E' mú kë̀ wamblër es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Erë ie' tö ie'pa sué̱ krereë, ta̱ ichéitö: —¿We̱s a' tö ibikeitsèmi tö e' kë̀ tkö̀pa a' ta̱? Skëköl yëkkuö tö ye' ché i' es: ‘Ák watë'ttsa̱ u yuökwakpa tö, e' yönene ák bua'buaie.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yi klastkëne ák e' mik ese pa̱rolordaë ena yi ki̱ ák e' a̱neka̱ ese yalitdawa̱ idiki̱a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ie'pa tö isué̱wa̱ tö kleè e' wa Jesús tö ie'pa ché. E' kue̱ki̱ ie'pa é̱na ie' klö'wa̱kwa̱ ee̱, erë ie'pa suane pë' yöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","E' kue̱ki̱ ie'pa tso' Jesús weblök isuo̱ie tö ì ki̱ ikkatërmi. Ie'pa tö wëpa we̱lepa patké ie' chakök ittö̀ yoktsa̱, e' wa ikkatè Roma wökirpa a̱ a̱s e'pa tö iklö'ù̱wa̱. Wëpa e'pa e̱' ö̀ tö ie'pa dör pë' buaë yësyësë ese. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ie'pa tö ie' a̱ ichaké: —A s'wöbla'u̱kwak, sa' wa̱ ijche̱r tö ì cheke be' tö ena ttè wa be' tö s'wöbla'we̱ke, e' dör moki̱. Be' a̱ sulitane dör ñies ë̀me. Be' tö s'wöbla'we̱ke yësyësë Skëköl ñalé̱ tté wa. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿I̱ma be' tö ibikeitsè? Roma wökir kibi patuè̱sö ¿e' dör buaë ö kë̀ idör buaë? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ie' wa̱ ijche̱r tö ie'pa tso' ie' chakök e̱r sulu wa, e' kue̱ki̱ ie' iiu̱té i' es: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Inuköl tso' a' wa̱ Roma wökir patuo̱ie, e' kkachö́ ye' a̱ et. ¿Yi diököl ena yi kiè me'rka̱ iki̱? Ie'pa tö iiu̱té: —Roma wökir kibi. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ie' iché ie'pa a̱: —E̱'ma ko̱s Roma wökir kibi icha, ese mú ie' a̱. Ta̱ ko̱s Skëköl icha, ese mú ie' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ì ko̱s ché ie' tö sulitane wörki̱, e' a̱ ie'pa kë̀ wa̱ ì ku̱ne ie' kkatoie. Ie' tö ie'pa iu̱té es, e' tö ie'pa tkiwé̱wa̱. E' kue̱ki̱ ie'pa siwa̱'blélur iyöki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","E' ukuöki̱ ta̱ saduceowakpa we̱lepa debitu̱ Jesús ska'. E' wakpa tö iklö'wé̱ tö s'duowa̱ e' kë̀ shke̱nukka̱ne. Ie'pa tö ie' a̱ ichaké: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—A s'wöbla'u̱kwak, Moisés tö ttè dalöiëno kita̱t yëkkuö ki̱ se' a̱, e' tö ichè i' es: Wëm blënewa̱ kë̀ alà a̱te̱, e' ta̱ ie' ël ka̱wöta̱ ischö́ tsu̱kwa̱ a̱s ilà kö̀ka̱ iël blënewa̱ e' a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Etökicha wëpa bak döka̱ kul ñì ëlpa. Ikibi alaköl tsé̱wa̱, erë iblënewa̱ kë̀ alà a̱te̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","E' ukuöki̱ ta̱ ie' itöki̱ iël tö ischö́ tsé̱wa̱, erë ñies e' blënewa̱ kë̀ alà a̱te̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Es itka iël skà ta̱ ñies imale̱pa ko̱s e'pa ta̱. Ie'pa kul blërulune kë̀ alà a̱te̱ yës. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Bata ekkë ta̱ ñies alaköl e' blënewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Wëpa kul e'pa bak alaköl eköl ë̀ ta̱. Mik s'duowa̱ e'pa shke̱neka̱ne, eta̱ ¿wé̱ne dö̀mi ie' wëm chö́kie? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ie' tö ie'pa iu̱té: —S'tso'ia̱ ká̱ i' a̱ ta̱ wëpa ena alakölpa ñì tsu̱kewa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Erë aishkuö ta̱ wé̱pa ki̱ se̱ne michoë mène, esepa shke̱rdaka̱ne ta̱ ee̱ wëpa ena alakölpa kë̀ se̱rpawa̱ia̱ ñita̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ie'pa se̱r michoë kë̀ duöta̱'wa̱ we̱s Skëköl biyöchökwakpa kë̀ duöta̱'wa̱ es. Skëköl tö ie'pa shke̱o̱'ka̱ne, e' kue̱ki̱ ie'pa döraë ie' ala'rie. E' kue̱ki̱ ie'pa kë̀ se̱rpawa̱ia̱ ñita̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ñies Moisés wák tö se' a̱ ikkayë' tö s'duowa̱ e'pa shke̱rdaka̱ne. Kal tsir wöñarke bö'ie e' paka'itö, ee̱ ie' tö iyë' tö Skëköl dör Abraham, Isaac ena Jacob, e'pa Këköl. Es isué̱sö tö ie'pa tso'ia̱ ttsë'ka Skëköl a̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","E' wà kiane chè tö s'tso' ttsë'ka ena s'duowa̱, e'pa ko̱s tso' ttsë'ka Skëköl a̱ ke̱kraë. E' kue̱ki̱ ie' kë̀ dör s'duowa̱ e' Këköl. Ie' dör s'ttsë'ka e' Këköl. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Eta̱ s'wöbla'u̱k ttè dalöiëno wa wakpa we̱lepa tö iché ie' a̱: —A s'wöbla'u̱kwak, ì ché be' tö, e' chébö buaë yësyësë. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Eta̱ saduceowakpa kë̀ kësik dë'ka̱ia̱ ie' a̱ ì skà chakök. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús tö ie'pa a̱ ichaké: —¿We̱s ie'pa tö ichèmi tö wé̱ pairine'bitu̱ idi' wa s'blúie, e' dör s'blú bak kiè David e' aleri? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Erë David wák tö ie' yë'a̱t yëkkuö kiè Salmos e' ki̱. Ie' tö iyë'a̱t i' es: ‘Skëköl tö iché ye' Këköl a̱: Be' e̱' tkö́se̱r ye' ulà bua'kka dalöiëno tai̱ë ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","dö̀ mik ye' tö be' bolökpa mérö be' klö̀ diki̱a̱ eta̱.’ ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Es se' isué̱ tö wé̱ pairine'bitu̱ idi' wa s'blúie, e' kié David wák tö ie' Këköl, e' ta̱ ¿we̱s ie' dör David aleri? ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sulitane tso' Jesús ttöke e' ki̱ttsök, eta̱ ie' tö iché ittökatapa a̱: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“A' e̱' kkö'nú s'wöbla'u̱k ttè dalöiëno wa wakpa yöki̱. Ie'pa wöbatsö shkök datsi' batsì̱ë ese mik wé̱ pë' tso' tai̱ë ese ska' a̱s pë' tö ie'pa shke̱'ù̱ we̱s këkëpa dalöiërta̱' tai̱ë es. Ñies se' ñì dapa'wo̱ wé a̱ ena wé̱ ie'pa ka̱wö tkö'we̱kerakitö, ese ska' kula' tso' këkëpa dalöiërta̱' esepa a̱, ese yuleke ie'pa tö e̱' tkoie. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ie'pa tö alakölpa schö́ u yekettsa̱ iulà a̱ ta̱ iwökatekerakitö ittökerak S'yë́ ta̱ braraë e' wa. Ie'pa weirdaë sia̱rë s'male̱pa tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús tso'ia̱ Skëköl wé a̱, eta̱ ie' tso' inuköl blúpa tso' inuköl iök kalkuö tso' iioie mè Skëköl a̱ ese a̱ e'pa sa̱u̱k. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ñies ie' tö alaköl eköl sia̱rëla dör schö́ e' sué̱ inuköl wöshkila yöule cobre wa ese böt iökwa̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Eta̱ Jesús tö iché: —Moki̱ ye' tö a' a̱ ichè tö alaköl wí̱ sia̱rëla dör schö́ e' tö inuköl iéwa̱ kibiie imale̱pa ko̱s tsa̱ta̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ie'pa ulitane tö inuköl kuö̀ a̱te̱ ese ié, erë ie' sia̱rë, e' tö ie' wa̱ itso' se̱noie e' ko̱s méttsa̱. E' kue̱ki̱ ye' tö ie' ché es. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Eta̱ Jesús ttökatapa we̱lepa tso' ichök tö Skëköl wé wër buaala, ki̱tkëule tai̱ë ák bua'bua wa ena íyi bua'bua kakmeule Skëköl a̱ tai̱ë, ese wa. Jesús tö iché: ");
INSERT INTO bzdNTpo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Iké̱wö döraë eta̱ ì ko̱s sué̱ a' tö i', e' olordawa̱ se̱raa̱, iékwö ë̀ kë̀ a̱tpa ñì bata ki̱. ");
INSERT INTO bzdNTpo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Eta̱ ittökatapa tö ichaké: —A s'wöbl