﻿USE sofia;
DROP TABLE IF EXISTS sofia.byr_vpl;
CREATE TABLE byr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES byr_vpl WRITE;
INSERT INTO byr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","5","Sɨnnawɨ kɨgaakuna Gotɨyai sɨgunyasɨ kwaakesɨ wakyaaꞌ. Tɨvi wakakegaaꞌ kwaaka kunevaꞌ warɨna kyaaꞌ, sagaaꞌ Gotɨyare Kuryai aalɨbunyavɨ munyaba yɨlayamarina yaaꞌ. Yuyaba jɨhɨnyaꞌ yadɨsɨ Gotɨyai wɨjaaꞌ “Yɨrɨkeꞌgɨ dɨvuꞌ!” Miꞌna kujaaꞌ yɨrɨka purɨna yaaꞌ. Gotɨyai yɨrɨkeꞌ wanganaka wɨjaaꞌ “Tewaanyasɨra. Yɨrɨkegaakɨ.” Gotɨyai yɨrɨkeꞌ gavi wakɨna, jɨhɨnyaꞌ gavi wakɨna yaaꞌ. Wakɨna yaka “Jɨhɨnyaꞌ sawɨsasɨra,” wɨjaaꞌ. Miꞌna kujaaꞌ yɨrɨka pɨrɨꞌ miꞌnanyɨra. ");
INSERT INTO byr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","8","Yɨrɨka mudɨkeꞌ kavuryaaꞌ Gotɨyai wɨjaaꞌ “Aalyamwavɨdaasɨ yɨraaya bilaawana!” Wɨdɨna kyaaꞌ yɨraaya bilaawɨna yaaꞌ. Gotɨyai wɨjaaꞌ “Munya keꞌba sɨgunyasɨ.” Yɨrɨka pɨryaai miꞌnanyɨra, sagaaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","13","Yɨrɨka mudɨkeꞌ kavuryaaꞌ aalya naangeꞌ yunebanna waꞌdɨsɨ Gotɨyai wɨjaaꞌ “Aalya naanga daꞌ avaala pɨba warana!” Gotɨyai sara kujaaꞌ aalya maalɨka wannyɨna yaaꞌ. Sagaaꞌ sɨla, mugunya, kwaaka warɨna yaaꞌ. Miꞌna warɨna kyaaꞌ Gotɨyai wɨjaaꞌ “Yɨta, maye, sɨgya, kure, kɨnna, wapaaya yuya yɨmaꞌnyɨna yana!” Sara kujaaꞌ, sagaaꞌ yɨmaꞌnyaakengɨ. Sinakejɨ tainakejɨ yɨmaꞌnyaaꞌ. Yɨrɨka daryaai darɨꞌ miꞌnanyɨra. ");
INSERT INTO byr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","19","Yɨrɨka mudɨkeꞌ kavuryaaꞌ Gotɨyai wɨdɨna “Baaka naangeꞌ (Nyɨlyai), baaka maalɨkeꞌ (lawei), sɨlɨngaamɨnya warana!” Sara wɨdɨna kyaaꞌ nyɨlyai, lawei, sɨlɨngaamɨnya yɨmaꞌnyɨna yaaꞌ. Gotɨyai wɨdɨna yaaꞌ “Yɨrɨkegaaꞌ nyɨla wɨdɨna yana! Sawɨsagaaꞌ lawei, sɨlɨngaamɨnya wɨdɨna yana!” Savɨdaasɨ kwaakevakɨ yɨrɨkesɨ wanyɨwanyasɨ warɨꞌ. Gotɨyare sɨmunya nyɨlyalyɨ lawelyɨ saraarɨna wawɨnya yanyaꞌne saꞌ gavi wakɨna, burɨkegaaꞌne saꞌ gavi wakɨna yaaꞌ. Yɨrɨka daryaai daryaai miꞌnanyɨra, sagaaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","23","Yɨrɨka mudɨka kavuryaaꞌ sagaaꞌ Gotɨyai wɨdɨna “Jawɨnya, buta, waalabya aalyavɨ wɨlaryaꞌne pɨnɨ mwaalana!” Miꞌna wɨdɨna kyaaꞌ jawɨnya, waalabya, buta yuya aalyavɨ mwaalɨna yaaꞌ. Mwaalɨna yeva aalyavɨ kusawɨ jawɨnya, waalabya bwaranya wɨlayariwannyɨna yaaꞌ. Nabaai Gotɨyai yuta ge ge munyawɨnnera wɨmwaaihɨna, kwaakewɨnnera wɨmwaaihɨna yaaꞌ. Yusara sara wɨmwaaihakeraavɨdaasɨ naanga mɨjayariwannɨguna yaaꞌ. Sagaaꞌ yɨrɨka daryaai daryaai darɨꞌ miꞌnanyɨra. ");
INSERT INTO byr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","31","Yɨrɨka mudɨkeꞌ kavuryaaꞌ Gotɨyai yagaala wɨdɨna “Jɨlɨkyaawarya, yɨkurɨyaawia yuya yɨmaꞌnyɨna yana!” Sara wɨdɨna kyaaꞌ kwaakevɨ yɨmaꞌnyɨna yaakengɨ. Nabaai Gotɨyai kamaala, maaꞌnyaanna sara wakɨna yaaꞌ. Yuya yɨmaꞌnyaakengɨdaasɨ naanga yariwannɨguna yaaꞌ. Sagaaꞌ Gotɨyai sɨgya, waanga tɨka nyaꞌne sɨmudɨnya yadɨvɨsaraavɨna wɨjaavɨna yaaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","7","Gotɨyai yuyaraavɨ wɨmwaaihakere. Aꞌmwelyɨ aꞌmwesɨ sawaarɨ yavɨkaryɨna. Gamɨ kwaibɨsawaarɨ yavɨkaryɨna yaꞌ. Gotɨyai kwaakeꞌ lɨvɨna yaka lɨvɨgɨrɨꞌmwanna yaka aꞌmwerɨ yavɨkarina yaꞌ. Aꞌmwere kɨlaakejɨꞌ yavɨkaryaka Gotɨyai gamɨre sɨnnyɨkɨ pwaꞌnyɨ kamakuraꞌ sagaaꞌ aꞌmwei yɨmaꞌnyɨna kyaꞌ “Ataamɨma gɨmɨre yayaꞌ gɨthɨwana,” Gotɨyai sara wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","... ");
INSERT INTO byr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","17","Gotɨyai wawɨnya naangeꞌ burɨnna burɨnna yaꞌ. Burɨnna burɨnna yaka Ataamɨmɨ maarɨna yaka wawɨnyavɨ wɨlamarakɨna yaꞌ. Kwaaka Yɨthenɨ aalɨmaangevɨ wawɨnya saꞌ waraꞌ. Aꞌmwe pwai yɨsarɨdaaꞌnyɨ yɨsɨla maranajɨ kwajɨ gazagaasagaaꞌ kamwaaladɨka. Nabaai yɨta pwai sɨduta nawɨꞌnyaꞌ sɨduta kayaaꞌnanyaꞌ yawɨryaꞌnei waayaꞌ. Gotɨyai Ataamɨmɨ wɨdaꞌ “Gɨmɨ wawɨnya davɨ dɨmaremwaaideigɨnyɨ. Yɨsɨla wawɨnya davɨdaasa da dɨnadengɨ,” wɨdaꞌ. “Wawɨnya davɨ tɨnnyaba yɨsai sɨduta yawɨryaꞌnei waayɨkerɨdaaꞌnyɨ yɨsɨla naꞌgɨzɨ, gɨmɨ sɨduta tewaanya yawɨꞌna jɨthesɨ. ‘Nabaai gɨmɨ sɨduta kayaaꞌna yawɨꞌna jɨthesɨra,’ gɨthɨwa. Yɨsɨla saꞌ gɨmɨ manɨnnesɨ,” wɨdɨna. “Gɨmɨ naꞌgɨzɨ dɨvaidesɨ,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","20","Yuta jɨlɨkyaawarya yuya Gotɨyai kwaakevɨdaaꞌnyɨ yavɨkaryakera Ataamɨ mwaaidɨsɨyaba makwasaabaꞌ. Kamakwasaabaꞌ Ataamɨ yuyaraavɨ yaya wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","25","Sagaaꞌ Gotɨyai daꞌ “Ataamɨ gavei mwaalya saꞌ kayaaꞌnanyabwi yɨꞌ. Nɨmɨ aꞌmwe gamɨnyɨneꞌ yavɨkarima! Aꞌmwe saꞌ gamɨnyɨ wɨgaimwagathesɨra,” daꞌ Gotɨyai. Sara daka Gotɨyai Ataamɨmɨ se naanga marakakei waꞌdɨꞌnyɨ Ataamɨmɨre laasarɨꞌ galalɨvɨꞌmwagamaaꞌna yaka gamɨre kɨlaakejɨꞌ yɨhula yajɨdaꞌna yaꞌ. Yajɨdaꞌna yaka aꞌmwevɨ laasarɨꞌ yavɨkaryaꞌ. Kyavɨkaryaꞌ Ataamɨ kadɨkaavaꞌ Gotɨyai aꞌmweꞌ wɨmaarina yaꞌ. Wɨmaarina kyaꞌ aꞌmwevɨ Ataamɨ wanganaka “Nɨmɨjɨ avaalyaꞌgɨnyɨra,” wɨdɨna. “Gotɨyai nɨmɨre laasarɨꞌ nyɨlɨvɨꞌmwagakaka gyavɨkariwakeꞌneꞌ ‘Aꞌmweꞌgɨ,’ gɨthɨdeinyɨra,” wɨdɨna yaꞌ. Sayabadaaꞌnyɨ dahaaꞌ aꞌmwe pwai ganɨmaangelyɨ ganaangesɨ sawaaryabadaasɨ yagalyaꞌmakuna yojɨ aꞌmweꞌ kwala maarɨna yojɨ gamɨre aꞌmwesɨ mwaalɨna yakɨlyɨyagaaꞌ kɨyoi yune kɨlaaka gave pɨjɨꞌnanyɨ. Gotɨyai wɨdɨna yaꞌ “Kɨrɨmɨre kaimɨraaya jawakɨnyidewaaihɨlyɨra. Nabaai yɨkurɨyaawiarajɨ mala kayaawaryarajɨ jɨlɨkyaawaryarajɨ yuyangɨ dɨmaremwaalyidewaaihɨlyɨra.” Kannyɨmaayawaarɨ sawaarɨ wagɨla muvwaꞌnyaꞌ. Gotɨyai gamɨ yavɨkaryakengɨ tɨnna dara wanganakeꞌ tewaanya naanga waꞌdɨsɨ wanganakengɨra. Yɨrɨka ata pwina ata purɨdaaꞌnyɨ pwai miꞌnanyɨra sagaaꞌ. Yɨrɨka mudɨkeꞌ kavuraꞌ Gotɨyai gannya wawɨnya miꞌna yaka kwazaaka mwaalaꞌ. “Yɨrɨka daryaai daryaai daryaai darɨꞌ sagaaꞌne saꞌ gavinyaꞌnesɨra,” wɨdaꞌ Gotɨyai. ");
INSERT INTO byr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","7","Kamaala sai sɨduꞌnakei aꞌmwevɨ wɨdɨna “Gotɨyai jɨhɨthaka? ‘Kɨrɨmɨ yɨsɨla yɨta dangɨdaaꞌnyɨ mamaranyɨkanesɨ,’ jɨhɨthako?” Sara wɨdɨna kyaꞌ aꞌmweꞌ wɨdɨna “Yɨsɨlya nakajanga yawɨꞌmanɨgoi. Yɨsɨla yɨta wawɨnyavɨ tɨnnyaba waayɨkerɨdaaꞌnyɨ naarɨmɨ mamaranakanesɨ. Yɨta darɨ yɨmeꞌnakwoihɨjɨ balɨna yakadeꞌnaalyɨ,” wɨdɨna. Wɨdɨna kyaꞌ kamaalyai wɨdɨna “Kɨrɨmɨ dɨvalyidewaaihi mɨka. Kɨrɨmɨ kayaaꞌnanya pɨnɨnna tewaanya pɨnɨnna yawɨꞌna jidewaaihɨlyɨra,” wɨdɨna. “Kɨrɨmɨ Gotɨyaibɨꞌ jɨmaꞌnyidewaaihɨlyɨ. Saꞌna nabaai Gotɨyai yawɨꞌmanɨꞌ,” wɨdɨna. Kamaalyai miꞌna wɨdɨna kyaꞌ, sagaaꞌ aꞌmweꞌ tɨnna wanganakeꞌ “Yɨsɨla maranyɨna yɨma!” daꞌ. Sara daka maranyɨna yaꞌ. Nabaai gamɨre kwalaangerɨ kumaryaꞌ aꞌmwei yɨsɨlyai maranyɨna yaꞌ. Tɨviꞌna maranyɨna kyaꞌ kɨrɨmɨ sawaai kunya yawɨragi. Yawɨragɨla dara yennagɨlyaꞌ “Kannya maayaꞌnaai daaka!” Dahɨlegaaꞌ wagɨla kuvwaꞌnaꞌ yɨkɨwasa gipwaina, kannya yɨraꞌnyɨna yagi. ");
INSERT INTO byr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","13","Sawɨsaburɨ Gotɨyai wawɨnyavɨ kaanya yamaryɨna. Yamaryɨna yadaaꞌnyɨ Ataamɨjɨ gannya aꞌmwesɨ sawaai gamɨnyɨ wɨꞌnagɨla yɨkaavɨlyavɨ kɨmaꞌnyawɨ lɨka yulyaꞌna yagi. Yulyaꞌdakɨlyɨ Gotɨyai jaka wɨdɨna “Gawɨ mwaaihɨlo?” Sara wɨdɨna kyaꞌ aꞌmwei wɨdaꞌ “Purinya kiwaa guꞌnɨwa. Kannya maayainyɨ lɨka yulyake,” wɨdaꞌ. Gotɨyai wɨdɨna “Saꞌna aai kagɨthɨwakaka? ‘Yɨsɨla mamaranɨnnesɨra,’ gɨthɨwaꞌdeꞌ danɨwaana?” wɨdɨna yaꞌ. Wɨdɨna kyaꞌ Ataamɨ wɨdɨna “Aꞌmwe nyɨjaavagɨne daꞌ yɨsɨla kanyɨmaariwaꞌ nɨwana.” Sara wɨdɨna kyaꞌ aꞌmweꞌ wɨdaꞌ “Nɨmɨnyɨ kamaalyai kwaasɨyagaala kanyɨdɨwaꞌ yɨsɨla maranyɨna yɨwana.” ");
INSERT INTO byr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","15","Miꞌna wɨdɨna kyaꞌ kamaalyarɨ Gotɨyai wɨdɨna “Sayaba kamaala sɨvɨlata maaya daigɨ labwatavamarina jahoꞌdeigɨnyɨ. Gɨmɨre kaimɨraayara kwarajɨ savɨre kaimɨraayara kwarajɨ sɨmɨlɨka winadɨvɨꞌ mala tannɨpɨꞌdeꞌna wɨjɨwaakɨderera,” wɨdɨna. “Gamɨre sɨvidaahunnyavɨ kayaaka yɨgaidɨzaꞌneꞌ gɨmɨre mɨnyagɨnyavɨ gɨvɨzaꞌjɨvaladeigɨnyɨ,” wɨdɨna yaꞌ kamaalyarɨ. ");
INSERT INTO byr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Gotɨyai aꞌmwevɨ wɨdɨna “Mudangegaaꞌ gɨnnya kaimɨraayai maꞌdaaꞌgiyagaaꞌ daanga naanga gɨvɨnadeꞌgɨnyɨra. Sara yɨjaꞌ gɨnnya aꞌmwerɨ yɨlaaya jɨhaidesɨ. Nabaai gamɨ gɨmaremwaaladelyɨ,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","19","Gotɨyai Ataamɨmɨ wɨdɨna “Sayaba adaꞌ gɨmɨ sara yɨwaanya saꞌneꞌ nɨmɨ kwaakevakɨ kurɨvaarɨya wakɨdeinyɨ. Kwakaꞌmuri gɨmɨ wapaaya nyaꞌne wawɨnya naanga yadɨ sagaaꞌ gɨmɨnyɨ maaꞌna naanga ginadeigɨnyɨ. Yuyagaaꞌ kwaihwaainakeigɨ mwaalaꞌgɨzɨyagaaꞌ gɨmɨ sara jɨtheigɨnyɨ. Kwaakejɨsɨ gyavɨkaryagɨnyaigɨ gɨmɨ balaꞌgiyagaaꞌ gɨmɨre kɨlaakejɨꞌ kwaaka ayɨna yɨmaꞌnadezɨkɨ,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","24","Miꞌna wɨdɨna yaka Gotɨyai yaawɨhɨlaakeꞌ maarɨna yaka kannya yavɨkarina yakewaai maarɨna yagɨla kannya mariraꞌnyɨna yagi. Ataamɨ aꞌmwevɨ wɨdaꞌ “Yɨvaꞌ gɨthɨwe saꞌ gɨnnya yaya naangeꞌ gɨthɨwa.” Aꞌmwe yuyaraavɨ kuvɨnaangeꞌ yɨmaꞌnadeꞌnanyɨra. Ataamɨjɨ Yɨvasɨ sawaai kunya kayaaꞌna yawɨꞌna, tewaanna yawɨꞌna yadiꞌ mwaalagi. “Yɨsɨla gaalyaꞌneꞌ nyɨna yakɨri gazagaasagaaꞌ namwaalyɨkadɨka!” daka Gotɨyai wɨdaasɨna. Sara wɨdaasɨna yaka “Yɨta tewaanyarɨna maremwaaipɨꞌderaava,” daka wawɨnyavɨ mwasɨlaa ejelɨya dameraavɨ wɨmwaaihaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","24","Ataamɨjɨ Yɨvasɨ sawaai kaimaleraarɨ wɨmwaaihagi. Kenɨ gannya wawɨnyavɨ yadaasɨ Aivelɨ jɨlɨkyaawaryaraavɨ maremwaalɨna. Pɨgaaꞌ Kenɨ wawɨnyavɨdaasɨ wapaaya maarɨna yaka Gotɨyarɨ wɨmaaryɨna. Aivelɨ sipɨzipɨya tewaanyai maaraka Gotɨyarɨ wɨmaaryɨna. Kumaaryagi tawanakei wɨmaaryaka Aivelɨmɨna Gotɨyai yɨlaaya yɨna yaꞌ. Wapaaya wɨmaaryaka Kenɨmɨna jɨkurya yɨna yaꞌ. Jɨkurya yɨna kyaꞌ Kenɨ sɨnna tɨka kudavaꞌ sagaaꞌ Gotɨyai wɨdɨna “Kenɨ sɨnna tɨka magɨthavanna! Kayaaꞌnanyabwi minnera!” Wɨla dɨvi wawɨnyavɨ aꞌmwera mamwaalyaba Kenɨjɨ Aivelɨjɨ saraai mwaaidakɨri Kenɨ Aivelɨmɨ tamakɨna. Tamakɨna kyaꞌ dɨvi sagaaꞌ Gotɨyai Kenɨmɨ wɨdɨna “Jɨhwaalaangei gazɨyaka?” Sara wɨdɨna kyaꞌ Kenɨ wɨdɨna “Mwanganyɨweinyɨ. Gamɨnyɨ maremwaaidɨnyainyɨ daaka!” Gotɨyai wɨdɨna “Jɨhwaarɨ baarɨꞌ yɨwaa? Jɨhwaalaangare tawejɨꞌ kwaakevakɨ warɨꞌ. Dɨvi sagaaꞌ kwaakevakɨ wawɨnya yaꞌgɨzɨyagaaꞌ wapaaya maalɨke dakanadeigɨnyɨ. Gɨmɨ gazabazaba yamarina jɨtheigɨnyɨ.” Miꞌna wɨdɨna kyaꞌ sagaaꞌ Kenɨ wɨdɨna “Gɨmɨ mala kanyɨramaasaꞌgɨzɨ gazabazaba mwalamarina yɨdeinyɨ. Yamaryadaaꞌmujɨ aꞌmwei nyanganojɨ mala nyɨramakadeinyɨ.” Gotɨyai wɨdɨna “Aawano. Sasareꞌ mika.” Wɨdɨna yaka Gotɨyai “Kenɨmɨ mala narabɨka!” daka Kenɨmɨre yamevɨ pɨkarya yaꞌ. Sagaaꞌ Gotɨyaryabadaasɨ Kenɨ kwaaka Nothɨnei kaanna wɨna yaꞌ. Gamɨre kaimɨraayara kwaaka mudɨkeba mwalaaweva kwaariꞌmasannajɨ, pɨradaazannajɨ yuya kunnya saburana yawɨreva yavɨkaryeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","26","(-) ");
INSERT INTO byr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","32","Kwarame naangegaaꞌ 130 Ataamɨ wavɨlavakei gannya kaimale pwai yawakɨna. Yɨvaꞌ gawaalɨꞌ Ataamɨ ganɨmaangeibɨꞌnanyai mɨlaka gannya kaimalerɨ ganaangeꞌ wɨdɨna “Satai gɨnnya yayaꞌ gɨthɨwana.” Dɨvi sagaaꞌ Satai naanga mena yɨmaꞌnakegaaꞌ kaimale Yɨnozarɨ yawakɨna. Sɨnnawɨ Gotɨyarɨna majɨ, mwaalɨna yesara Yɨnozai yɨmaꞌnakegaaꞌ ayɨna Gotɨyarɨna dadɨvɨꞌ mwaaleꞌ. Ataamɨjɨ Yɨvasɨ sawaare kaimale taaya mɨlagi. Kwarame 930 kwavɨlavaꞌ Ataamɨ balaꞌ. Yɨnozai kaimale Kenanɨmɨ kyawakɨnaꞌ, Kenanɨ kaimale Maalalelɨmɨ kyawakɨnaꞌ, Maalalelɨ kaimale Jaaretharɨ yawakɨnaꞌ. Jaarethai kaimale Yɨnokɨyarɨ kyawakɨnaꞌ, Yɨnokɨyai kaimale Metuzalaamɨ yawakɨnaꞌ. Gotɨyareburɨ Yɨnokɨyai tewaanna yɨna yaka mabalyakei Gotɨyai maraabɨna yaꞌ. Metuzalaa kaimale Lamekerɨ yawakɨnaꞌ. Kwarame 969 wavɨlavakei Metuzalaa balaꞌ. Lamekei kaimale Nowaarɨ yawakɨnaꞌ. Aꞌmwe pwara kaimale taaya yawakɨneꞌ. Nowaai kaimale Samɨ, Aamɨ, Jaivetai saraavɨ yawakɨnaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","8","Aꞌmwerajɨ aꞌmwejɨ kwala naanga kimaꞌneꞌ “Aꞌmwengɨ nemɨ kwala maraana!” deva Gotɨyare kuvɨbwaalɨvava maarɨna. Maarɨna kyeꞌ kunnya kaimɨraayara aꞌmwe dɨragɨnya naangera yɨmaꞌneꞌ. Gotɨyai tɨnna dara wanganakeꞌ kayaaꞌnanyaraavɨ wanganaꞌ. “Kayaaꞌnanyabwi sara yaana!” yawɨꞌdɨvɨsara yuyagaaꞌ yesaꞌna Gotɨyai dɨna “Aꞌmwe atina ata purɨdaaꞌnyɨ pwainanyaraavɨ kwarame ata sɨvɨlɨraai (120) kwavɨlavojɨ wakɨdengɨra kunnya balyaꞌnegaaꞌ.” “Aꞌmwera, aꞌmwe, yaawarya, jɨlɨka, yaawia, yuta, yuya tamakɨdengɨra,” dɨna. Miꞌna dɨna yaka Gotɨyai daꞌ “Nowaai aꞌmwe tewaanyarɨna yɨvainɨdelyɨra.” ");
INSERT INTO byr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","22","(-) ");
INSERT INTO byr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","5","Nowaai aꞌmwe tewaanyai Gotɨyarɨ gyaꞌmwei. Gotɨyai Nowaarɨ wɨdɨna “Sɨpɨyaꞌ angeꞌbɨꞌ saꞌ aalyavɨ aꞌba yɨlaradeꞌ javɨkarideigɨnyɨ. Sɨpɨya maalɨka javɨkarideꞌna miꞌ. Sɨpɨya naangeꞌ javɨkarideigɨnyɨ. Sɨpɨyavɨre yɨdaꞌna saamɨnaangeꞌ anga naangebabɨꞌ javɨkari! Sɨpɨyaꞌ angajɨna lalangyagɨnyaꞌbɨꞌ javɨkari! Yɨdaꞌna kekina laalayagɨnyaꞌbɨꞌ saꞌ duthaakwia! Sɨpɨyaꞌ mɨnyeꞌna amwi pɨrɨꞌ tɨnnyaba pɨrɨꞌ dakineba pɨrɨꞌ javɨkari! Yɨrɨtɨnna munyaba yunebanna yunebanna jɨthaakwia! Tɨkurya tɨnnyaba pɨrɨꞌ aꞌmwera bulyaꞌneꞌ kaanyaꞌ javɨkari!” “Aalya naangeꞌ yunebanna pɨdɨravadesɨ. Sɨmudɨnya yadɨvɨsaraavɨ yuyaraavɨ aalya naangeꞌ wakɨwɨjaꞌ maramɨladere. Kɨrɨꞌ kɨrɨmɨyoihi kɨrɨbwaalɨvavajɨ saraavɨre aꞌmwengɨjɨ sɨpɨyavɨ wɨlɨna jidengihɨlyɨ. Nɨmɨre yagaala gɨthɨdeinyɨ. Saꞌ jɨlɨkyaawarya yɨkurɨyaawia kɨmaaka pɨyoina pɨyoina sɨpɨyavɨ dɨmarulakɨdengɨ. Jɨlɨkyaawarya yɨkurɨyaawia pɨnɨ pɨyoina ata purɨdaaꞌnyɨ pwaraaina kɨmaaka miꞌ. Sa sɨpɨyavɨ dɨmarulakɨdengɨ. Wapaaya ge ge gɨmɨnyɨne sɨpɨyavɨ wɨlapɨꞌdengɨne wapaaya jovɨrawakya!” Miꞌna wɨdɨna kyaꞌ Nowaai sara yɨna. Miꞌna yɨna kyaꞌ Gotɨyai Nowaarɨ wɨdaꞌ “ Aꞌmwe pwara aꞌmwe pɨnɨ kayaaꞌna yadɨvɨsangɨna gɨmɨ tewaanya yadɨnyaigɨnna sarɨmɨ sɨpɨyavɨ dulyidera. Sawɨta ata yuyi ata purɨdaaꞌnyɨ pwaraai miꞌna kajɨnnojɨ burɨkeꞌ wakɨdeinyɨra. Yuya baihɨrinɨpɨꞌdengɨra,” wɨdaꞌ Gotɨyai. ");
INSERT INTO byr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","24","Kwarame naangegaaꞌ 600 sagaaꞌ Nowaarɨ kwavɨlavaꞌ, gamɨjɨ gannya balaangesɨ sawaare kaimɨraayarajɨ kumɨre balaangejɨ sɨpɨyavɨ kuleꞌ Gotɨyai kaanyaꞌ tihɨraꞌ. Sɨpɨyavɨ kaanyaꞌ mena karihɨraꞌ sawɨta aꞌmweraare ata sɨvɨlɨraai jɨnnaꞌdaaꞌnyɨ aalɨburɨka naanga yadaaꞌnyɨ aalɨyɨmɨnya naanga yɨrɨvakegaaꞌ aalya yɨlaabaka kwaakevakɨ aalɨbunya naangeꞌ dɨꞌnaꞌ. Burɨka naanga tɨvi kavawɨraꞌ sagaaꞌ aalɨbunya naangeꞌ yunebanna mugunyangɨ kamarulakaꞌ yuya baleꞌ. Sɨpɨyaꞌ aalyavɨ aꞌba yɨlaꞌdɨsɨ Nowaalyɨ sɨpɨyavɨ wɨlareta yuyajɨ tewaanya mwaaleꞌ. Lawe dɨkaai dɨkaai dɨꞌ kwaakevakɨ aalɨbunya dɨꞌnaraꞌ. ");
INSERT INTO byr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","22","Nowaai sɨpɨyavɨ wɨlaꞌdɨꞌnyɨ Gotɨyai sɨmunya yawɨraꞌ. Yawɨraka yɨhuta wakɨna kyaꞌ aalyaꞌ walyuina yadaasɨ lawe dɨkaai dɨkaai dɨꞌ kwavɨlavaꞌ aalya maalɨka warɨna kyaꞌ, sɨpɨyaꞌ Ararata mugunyavɨ waraꞌ. Kwaraꞌ sawɨta aꞌmwe pwaraare ata sɨvɨlɨraai kajɨnnaꞌ Nowaai sɨpɨyavɨya yɨrɨtɨnnyarɨkɨ baasaka mwasawɨ kaamyaakerɨ marapɨlakwaasɨna yaꞌ. Kwaakevakɨ aalɨbunya waꞌdɨsɨ kaamyaakei pɨlakuna. Pɨlakuna kyaꞌ Nowaai “Aalya tɨvi kyeꞌnɨgwaimwaawɨꞌ daaꞌ?” daka mwasawɨ kwaamɨryarɨ marapɨlakwaasɨna yaꞌ. Aalɨbunyaꞌ kuna waꞌdɨsɨ kwaamɨryai mwalaawiaꞌneba kunewɨ wanganaka ayawɨnna sɨpɨyavɨna bulamwaaina. Bulamwaaina kyaꞌ sawɨta ata pwi yaka ata purɨdaaꞌnyɨ pwaraai kajɨnnaꞌ pɨgaaꞌ Nowaai kwaamɨryarɨ marapɨlakwaasaꞌ. Kamarapɨlakwaasaꞌ sawɨsɨrɨ kwaamɨryai yɨta wolivɨyare kɨwasaꞌ mudɨꞌmɨlamaraawɨna yaꞌ. Kamakabaꞌ Nowaai tɨnna wanganaka “Kwaakevaꞌ yaalɨka menanyɨra,” yawɨraꞌ. Kyawɨraꞌ sawɨta ata pwi ata purɨdaasɨ pwaraai kajɨnnaꞌ pɨgaaꞌ Nowaai kwaamɨryarɨ kamarapɨlakwaasaꞌ saꞌ kwaamɨryai yuna kaanna wɨna yaꞌ. Wɨna kyaꞌ Nowaai sɨpɨyavɨya kaanyaꞌ baasaka wanganaasaꞌ. Tɨnna dara wanganakeꞌ kwaakeꞌ yaalɨkevɨ wanganaꞌ. Mena kwanganaꞌ lawe puꞌna kwavɨlavaꞌ Gotɨyai Nowaarɨ wɨdɨna, “Sarɨmɨ mwasabanna jɨkwalyaabila! Jɨlɨkyaawaryaraavɨ yɨkurɨyaawiaraavɨ dɨvuradɨhalamakwalyaama! Kumɨ sara kwaakevakɨ kwala naanga yariwannɨpɨꞌderera.” Sara wɨdɨna kyaꞌ sɨpɨyavɨdaaꞌnyɨ Nowaalyɨ gamɨre gawaalɨsɨ yuya mwasabanna walyaabɨna yeꞌ. Walyaabɨna kyeꞌ Nowaai sɨmunya yawɨraka “Gotɨyai neyɨvainɨwakeꞌna nɨmɨ Gotɨyai tewannyarɨna yɨlaaya yɨgalɨdeꞌna jɨlɨkyaawarya yɨkurɨyaawia wɨjaawɨwɨnabɨsaꞌ dɨkevɨ gaayadɨka yɨravɨma!” yawɨraka Gotɨyarɨne simɨnyeꞌ lɨvalaabaꞌ. Lɨvalaabaka dɨka mariraꞌna yaka “Jɨlɨkyaawarya yɨkurɨyaawia kɨmaaka mwarikera,” daka maarɨna yaka simɨnye lɨvalaabakevɨ dɨkevɨ marakɨna yaꞌ. Sɨmahurɨka wɨvwasɨꞌna yakevɨdaaꞌnyɨ tɨrɨnya wabatɨrɨnya winnaka Gotɨyai daꞌ “Dɨvi yunegaaꞌ nɨmɨ yeꞌna sɨmudɨnya yadɨvɨsangɨ maramuneinyɨra.” ");
INSERT INTO byr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","4","Gotɨyai Nowaalyɨ gawaalɨvaanga kwarajɨ kɨnɨdakaavɨ yagaaihɨwɨnya wɨdaꞌ “Sarɨmɨ kwala naanga jɨmaꞌnyideihɨlyɨra. Nabaai sarɨmɨ kwaakevakɨ gazabazaba mwalamarina jideihɨlyɨra. Kwaakevakɨ mwaaidɨvɨsajɨ aalyavɨ mwaaidɨvɨsajɨ yuya dɨmaremwaalyidengɨra. Sarɨmɨ maremwaaidɨvɨsa dɨnyideihɨlyɨra. ‘Yɨkurɨyaawia naana!’ dapɨjɨ karamapɨri gamɨre tawe kabwalaawojɨ tɨka nyɨna jideihɨlyɨra.” Gotɨyai sara wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","11","“Aꞌmwe pwai aꞌmwe pwarɨ karamakori gamɨnyɨ tamakɨna jidelyɨra. Malakayaawaryai aꞌmwe pwarɨ tɨka kadavori gamɨnyɨ tamakɨna jidelyɨra. Nɨmɨ aꞌmwera nɨmɨbɨsaraavɨ yavɨkaryeꞌna sara dɨramakyideihɨlyɨra,” wɨdaꞌ Gotɨyai. ");
INSERT INTO byr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","17","“Yɨraayavɨ nɨmɨre akume yɨlakɨdeinyɨra. Akume wageꞌbɨsavɨ wanganapɨjɨ daꞌ jawɨryidesɨra. ‘Gotɨyai nemɨnyɨjɨ mwaaidɨvɨta yuyangɨjɨ gannya kɨwɨnyaꞌ nedaꞌ,’ sara jawɨryidesɨra. Aalɨbunya kwaakevakɨ dɨꞌnarakeꞌbɨsaꞌ nɨmɨ wakeꞌ dɨvi mulaabyɨ yadesɨra. Kwaakevakɨ mwaaibɨzangɨ mamaramɨlyɨ yadesɨra,” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","27","Nowaai wɨla gɨraipɨwawɨnya burɨdaꞌ. Burɨnna yaka gɨraipɨzɨla maarɨna, gɨraipɨzɨla aalyaꞌ gulyavɨ maꞌmwagikɨna aalya yɨrɨkeꞌ waainɨyaꞌ maranyɨna yaꞌ. Aalya yɨrɨkeꞌ maranaka sɨmunya myawɨryaꞌ. Sara yaka angevɨ kannya maayai se warɨna yaꞌ. Se kwaraꞌ Aamɨ, Kainanɨmɨre ganɨmaangei, Nowaai kannya maayai warakerɨ wanganaꞌ. Wanganaka gannya kɨdaraarɨ mwasawɨ mwaalagɨlyaraarɨ saꞌ wɨdaꞌ, Aamɨ. Kudaꞌ Samɨjɨ Jaivetalyɨ saraai yɨvɨta maarɨna, kɨrɨnɨmaangerɨ bwakakɨna tɨnna mwanganyɨ yagi. Dɨvi sagaaꞌ Nowaai dɨkaaꞌna yaka Aamɨ gawaalɨvaangei yakeꞌna yawɨraꞌ. Sɨmunya yawɨꞌna “Aamɨ kayaaꞌnanya maalɨka yɨvanɨka kɨrɨꞌ gawaalɨvaangei kayaaꞌnanya naanga yadengɨra,” yawɨraka wɨdaꞌ “Kainanɨmɨre avaalyara Kainanɨmɨ wɨmwaaihakera wɨmaremwaaibɨꞌdelyɨra. Samɨmɨna dɨvi nɨmɨre Gotɨyai tewaanya wiadelyɨra. Yɨ Gotɨyai Jaivetare kaimɨraaya kwala naanga yɨmaꞌnyɨna, yɨ aꞌmwe naangera yɨmaꞌnyɨna yɨpɨꞌderera. Kainanɨmɨre kaimɨraayara Samɨmɨre kaimɨraayaraavɨne Jaivetare kaimɨraayaraavɨne wawɨnya wɨdaayɨpɨꞌderera,” wɨdaꞌ Nowaai. ");
INSERT INTO byr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","29","Nowaare mudangegaaꞌ kwarame naanga (950) kwavɨlavaꞌ Nowaai balaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","14","Jaivetai kuvɨnɨmaangei Gomajɨ Maahohɨlyɨ Mathalyɨ Jaavanɨjɨ Tuvalɨjɨ Mesekalyɨ Tɨraazɨlyɨ saraavɨ yawakɨnaꞌ. Aamɨ kuvɨnɨmaangei Kuzɨlyɨ Yɨzɨpɨyalyɨ Putɨyalyɨ Kainanɨjɨ saraavɨ yawakɨnaꞌ. Kuzi ganɨmaangei Nɨmɨrothɨ yawakɨnaꞌ. Dɨvi sagaaꞌ Nɨmɨrothɨ aꞌmwe dɨragɨnyai, malyai yɨmaꞌnaꞌ. Anga naangeba Baivelɨ, Erekɨ, Aakathɨ, Kalɨne kwaaka Sinaa mannakeba Nɨmɨrothɨ maremwaalakebera. Maremwaalaka kwaaka Azɨrɨya anga naangeba Ninɨva, Rewavothɨ-Yɨya, Kaala, Rezanɨ anga sa madaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","20","Kainanɨ kɨrɨnɨmaangei Saaithonɨjɨ Etɨlyɨ saraarɨ yawakɨnaꞌ. Kainanɨmɨrera Jevuzɨyara, Amoyara, Gihaazɨyara, Ivayara, Aakayara, Sɨnɨyara, Aavathɨyara, Semaarayara, Aamaatɨyara Kainanɨmɨrera sara yɨmaꞌnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","32","Samɨ kuvɨnɨmaangei Elamɨ, Azu, Aapakɨzathɨ, Lutɨ, Aaramɨ yawakɨnaꞌ. Saꞌ Nowaarɨ gawaalɨvaangera aꞌmwe yuyaraavɨ kwaakevakɨ mwaaidɨvɨsaraavɨ yawakɨneꞌ. ");
INSERT INTO byr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","9","Kwaakevakɨ aꞌmwe mwaalesara yagaala avaala pɨrɨꞌna dɨneꞌ. Kumɨ sara kwaaka Sinaana kaanna wɨna yeꞌ. Wɨna yeva dɨneꞌ “Gotɨyai sara nedaꞌ ‘Yuyaba dɨmwalamaryɨla!’ nedaka kɨrɨꞌ nemɨ kwaaka gazabazaba mamwalamaryaanna! Dava nemɨ aꞌmwe naangaina yɨmaꞌnyɨna yaadeine. Nemɨ anga naanga madaatheꞌ nabaai anga saamɨnaangeꞌ sɨlyaꞌbɨsaꞌ madaathera,” dɨneꞌ. Miꞌna dɨneva anga madaapɨjɨ Gotɨyai daka “Nɨmɨ walanganaawɨma!” daka walaabaꞌ. Walaabaka wanganaka “Aꞌmwera kunnya yawɨꞌna yapɨjɨyavɨ sara nyɨpɨdɨka!” daka “Aꞌmwera yagaala geꞌ geꞌ dɨpɨꞌdeꞌnana,” daka taalɨta kagɨnyɨwagaꞌ sagaaꞌ yagaala avaalyaꞌ desara sagaaꞌ yagaala geꞌ geꞌ dɨna yeꞌ. Yagaala geꞌ geꞌ dɨna yeva “Anga naangeba madɨna yɨvanɨgoꞌ warana!” deva mamajeꞌ. Anga mamajara kyeꞌ Gotɨyai wɨdaasɨna kyaꞌ anga gazabazabanna mwalamaryɨna yeꞌ. Anga naangeba yosɨnna yeva sara yagalyaꞌmaꞌnɨka sabanneꞌ dɨnɨkesɨ Baivelɨ. Yagaala geꞌ geꞌ yɨmaꞌnyɨna yakebanne yayaꞌ Baivelɨ sara woꞌnyɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","25","Samɨmɨre gawaalɨvaangei Aapakɨzathɨyai ganɨmaangei Kainanɨmɨ yawakɨnaꞌ. Yɨ Kainanɨ ganɨmaangei Selaamɨ yawakɨnaꞌ. Yɨ Selaa ganɨmaangei Eva, yɨ Eva ganɨmaangei Pelehɨ, yɨ Pelehɨ ganɨmaangei Rewɨ, yɨ Rewɨ ganɨmaangei Seruhɨ, yɨ Seruhɨ ganɨmaangei Naawo, yɨ Naawo ganɨmaangei Teraamɨ yawakɨnaꞌ. Aꞌmwe dara kuvɨbwaalɨvava kuvɨraayava yawakɨneꞌ. ");
INSERT INTO byr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","32","Aꞌmwe Teraa kuvɨnɨmaangei Evɨramɨ, Naawo, Aaranɨ yawakɨnaꞌ. Aaranɨ ganɨmaangei Lotɨmɨ yawakɨnaꞌ. Gamɨre kwaaka Kalɨthɨya saba Aaranɨ balaꞌ. Kabalaꞌ Naawo Aaranɨmɨre garaavaangaꞌ Milɨkaavɨ maaraꞌ. Nabaai Evɨramɨ Saraayaꞌ maaraꞌ. Kamaaraꞌ Saraayaꞌ kaimɨraavɨmaayaꞌ mwaalaꞌ. Aꞌmwe naanga Teraajɨ, Evɨramɨjɨ, Saraayasɨ, Lotɨjɨ, sa angeba E kwaaka Kalɨthɨya mannɨkebadaaꞌnyɨ wɨna. Kaanna wɨna yeva “Kwaaka Kainanɨnennava,” deva angeba Aaranɨ bɨna yeva mwaalɨna. Mwaalɨna kyeꞌ saba Teraa balaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","3","Gotɨyai Evɨramɨmɨ jaka wɨdɨna “Gɨnnya angebadaaꞌnyɨ dɨwona! Gɨmɨjɨ avaalyaraavɨ jahalyaꞌmakwo! Kwaaka anga dɨmwaaide pɨbanna kagivwarɨdaakwaꞌmujɨ dɨmwaaideigɨnyɨ. Nɨmɨ sainyɨ gɨnnya kaimɨraayangɨ maremwaalɨdeinyɨ. Gɨmɨrera kwala naanga yɨmaꞌnɨpɨꞌdere. Gɨmɨ aꞌmwe naangei jɨmaꞌnadeigɨnyɨ. Yɨ gɨmɨnyɨ jɨwaalɨvavaavɨna aꞌmwe kwaakevakɨ yuneba mwaaidɨvɨsaraavɨ tewaanna yɨdere. Kumɨ sarɨmɨnyɨne tewaanna kyapɨjɨ kumɨnyɨne tewaanna yɨdeinyɨ. Kumɨ sarɨmɨnyɨne kayaaꞌna kyapɨjɨ nɨmɨ kumɨnyɨne kayaaꞌna yɨdeinyɨra,” wɨdaꞌ Gotɨyai. ");
INSERT INTO byr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Gotɨyai Evɨramɨmɨ sara kudaꞌ Evɨramɨ angeba Aaranɨdaaꞌnyɨ wɨna. Kwaaka Kainanɨnei gannya balaanga Saraayasɨ Lotɨ gathaakaangare gawaalɨsɨ gɨlyɨvɨta yuyajɨ kaanna makuna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","7","Evɨramɨ angeba Sekemɨ kwaaka Kainanɨ mannɨkeba wavɨlaꞌna yaka yɨꞌdarya More mwaalɨna. Mwaalɨna kyaꞌ Gotɨyai Evɨramɨmɨ wɨdaꞌ “Kwaaka Kainanɨ yuneba jɨwaalɨvaangeraavɨ kɨnɨdakaavihɨrɨne yɨhɨzaavɨdeinyɨra.” Miꞌna kudaꞌ Evɨramɨ “Nɨmɨ Gotɨyarɨ yɨlaaya yɨgalɨma! Jɨlɨkyaawaryarɨ wɨjaavɨma!” daka simɨnyeꞌ lɨvalaanna yaka jɨlɨkyaawarya gaayadɨka mariravakeꞌ dɨkeꞌ nasɨꞌna yakevɨdaasɨ Gotɨyarɨ sɨmatɨrɨnya winnaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Dɨvi sagaaꞌ Evɨramɨ mugunyavɨ angeba Betelɨ adaihɨsabanna wɨna. Sabanna wawaka angeba Betelɨ angeba Aayɨ yaareba gannya selɨ-anga madaka Gotɨyarɨna yɨlaaya yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","13","Pɨgaaꞌ wapaaya kunegaaꞌ mɨjɨkegaaꞌ Evɨramɨ Kwaaka Yɨzɨpɨna wɨna. Yɨzɨpɨna wawaka gannya balaangevɨ wɨdaꞌ “Gɨmɨ tewaanyaꞌgɨnyɨ. Yɨzɨpɨ mwaalyara gwanganapɨjɨ ‘Aꞌmwe saꞌ maraana!’ dapɨjɨ nyɨramakɨpɨꞌdeinyɨra. Gɨmɨ duthathera ‘Aꞌmwe sai nyaꞌmwelyɨra.’ ‘Naramakɨpɨka!’ daꞌgɨzɨ sara duthatheꞌgɨnyɨ. Sara kudaꞌgɨzɨ kave wanganakɨna nyɨpɨꞌdeinyɨ,” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","16","Yɨzɨpɨ mwaalyara kunnya maremwaalakerɨ wɨdɨna yadɨvɨꞌ “Peroyaigɨ, nemɨre aꞌmwe naangeigɨnyɨra.” Peroyare aꞌmwe naangera Saraayavɨ wanganeva Peroyarɨ wɨdeꞌ “Aꞌmwe saꞌ tewaanyasɨra.” Miꞌna kudeꞌ Aꞌmwe Pero Saraayavɨ gannya angevɨ wɨmwaaihɨna yaꞌ. Wɨmwaaihɨna yaka Evɨramɨmɨne aꞌmwerajɨ aꞌmwejɨ sangɨ wɨdaayadɨvɨsangɨ wɨjaavɨna yaꞌ. Nabaai jɨlɨkyaawarya naanga wɨjaavaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","20","Gotɨyai Peroyalyɨ gamɨre maremwaaiderajɨ saraavɨ Saraayavɨna kayaaka yɨgaina yaꞌ. Kayaaka yɨgaina kyaꞌ Pero Evɨramɨmɨ “Dulaamo!” kudaꞌ Evɨramɨ angevɨ wɨlɨna kyaꞌ Pero wɨdaꞌ “Baaꞌna yɨvanɨgɨna? ‘Aꞌmweꞌ nɨmɨresɨra,’ manyɨjɨwaꞌdɨnyaigɨ. Dahaaꞌ gɨnnya aꞌmwevɨ dɨmakwo!” Sara wɨdaka “Evɨramɨjɨ gamɨrerajɨ yarai wɨpɨka!” Pero gannya wɨdaayadɨvɨsaraavɨ “Evɨramɨmɨ wɨdasaawɨna jɨla!” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","4","Evɨramɨ angeba Betelɨna gɨlyɨvɨsajɨ jɨlɨkyaawaryajɨ maryagalaawɨna yaꞌ. Yagalaawɨna yaka Gotɨyarɨna “Yɨlaaya yɨgalɨma!” daka “Su!” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","13","Evɨramɨ bulɨmakaawoya gɨlyɨvɨta naangejɨyai mwaalaꞌ. Nabaai Lotɨ bulɨmakaawoya gɨlyɨvɨta kɨnɨjɨyai avaalyaba mwaalaꞌ. Mwaalagɨlyaraare jɨlɨkyaawarya wapaaya nyaꞌne maalɨka waraꞌ. Saꞌna Evɨramɨmɨre jɨlɨkyaawarya maremwaaidɨvɨsara Lotɨmɨre jɨlɨkyaawarya maremwaaidɨvɨsara maanga dɨnyɨna yeꞌ. Maanga dɨnyɨna kyeꞌ Evɨramɨ Lotɨmɨ wɨdaꞌ “Mayagaala madakanera! Pɨba kwaaka naanga warɨka. Gɨmɨ tuta pimagɨna dɨwona! Nɨmɨ pimagɨna wɨdera.” Sara kudaꞌ Lotɨ waraata aalya Jothanɨ saba aalɨnakeba dara wanganaꞌ “Ai, Gotɨyare kwaaka tewaanyaba waꞌdɨsɨ kɨrɨꞌ mwaaidɨ daaka? Gotɨyare wawɨnyabɨsabe,” daka Lotɨ walaawaka angeba Sothomɨ angeba Gamora aya kɨba mwaalaꞌ. Sothomɨ mwaalyarajɨ Gamora mwaalyarajɨ aꞌmwe kayaaꞌnanaangera mwaaleꞌ. Lotɨ kwalaawaꞌ Evɨramɨ kwaaka Kainanɨ mwaalɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","18","Evɨramɨ mwaalɨna kyaꞌ Gotɨyai wɨdaꞌ “Pina pina dɨmaranganamarya! Yuyaba dangadeva gɨzaavɨdeinyɨ. Gɨmɨ tɨnna kwanganaꞌgɨzɨ saba gɨmɨrebe. Nabaai gɨmɨre kaimɨraayara aꞌmwe naanga yɨmaꞌnɨpɨꞌderera. Aꞌmwera kwaatɨrya ata gibɨꞌdeꞌ mɨka. Gɨmɨre kaimɨraaya kwalaalya mwaaibɨzangɨ ata gibɨꞌdeꞌ mɨka.” Miꞌna kudaꞌ Evɨramɨ kaanna yamarina yaka yɨꞌdarya Maamɨre yɨꞌdarɨgidɨkusaba mwaalaka Gotɨyarɨne simɨnyeꞌ lɨvalaabaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","16","Pɨgaaꞌ aꞌmwe naanga kingɨya daraai daraalyarajɨ kumɨrerajɨ beva angeba Sothomɨ mwaalyarajɨ anga pɨbanyarajɨ saraavɨ baramakɨna. Baramakɨna kyeꞌ aꞌmwe kwalaalyara kabaleꞌ pwara mugunya pɨnɨngɨna lɨkaanya wɨna yeꞌ. Lɨkaanya wɨna kyeꞌ aꞌmwe naangera “Nedaayadɨvɨsarera,” deva Lotɨjɨ pwarajɨ saraavɨ wɨla galyɨrakɨna yeꞌ. Galyɨrakɨna yeva anga yuyabadaaꞌnyɨ gɨlyɨvɨta naanga yɨpalamaaꞌna. Yɨpalamaaꞌna kyeꞌ aꞌmwe pwai Evɨramɨmyawɨnna kaanyɨveꞌna wɨna yaka Evɨramɨmɨ wɨdaꞌ “Malyara anga Sothomɨ mwaalyaraavɨ baramakeva Lotɨmɨ wɨla yɨrakɨwaaꞌ.” Sara kudaꞌ Evɨramɨ gannya aawɨlasaraavɨ jaka wɨdaka malyaraavɨ mɨdɨnna yaꞌ. Mɨdɨnna kyaꞌ sawɨta kujɨnnaꞌ malyaraavɨ tamɨna kyeꞌ pwara lɨka wɨna kyeꞌ pwaraavɨ tamɨna yeꞌ. Tamɨna kyeꞌ Evɨramɨ Lotɨjɨ aꞌmwe pwarajɨ gɨlyɨvɨta naangejɨ ayawɨnna makabɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","20","Sothomɨ maremwaalakelyɨ Melɨkɨzɨthekɨ anga Saalemɨ maremwaalakelyɨ saraai Evɨramɨmɨ wɨjɨmaaꞌnyɨna yagi. Melɨkɨzɨthekɨ Evɨramɨmɨ wapaaya wɨjaavɨna yaka Gotɨyarei yagaala wɨdaꞌ “Gotɨyai sɨgunyasɨ kwaakesɨ wakyaakei gɨmɨnyɨ tewaanya gyɨnɨkelyɨra. Gamɨzai gɨmɨjɨ yagɨla gɨmɨnyɨne yɨkamaangeraavɨ yeꞌmwannaramyawaaihɨ. Gotɨyai tewaanyalyɨra.” Kudaꞌ Evɨramɨ gamɨre gɨlyɨvɨsa gazabazaba kwala marapɨgɨlaꞌna kyaꞌ gɨlyɨvɨta naanga atɨraalya waꞌdɨꞌnyɨ Evɨramɨ gɨlyɨvɨta pɨrɨꞌ Melɨkɨzɨthekɨ sarɨna yanga wɨjaavɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","24","Sothomɨ maremwaalakei Evɨramɨmɨ wɨdaꞌ “Gɨmɨ maꞌmwaanyangɨdaasɨ aꞌmweraavɨjɨ aꞌmwengɨjɨ yanga nyɨjaama! Gɨlyɨvɨsa gɨmɨrengɨra.” Kudaꞌ Evɨramɨ wɨdaꞌ “Nemɨ wapaaya pɨnɨ nɨwo. Miꞌna nɨwoꞌna warana! Aꞌmwe daraai dalyarajɨ kumɨrerajɨ pwara nɨmɨnyɨ marɨgaidaaꞌna nyawaaihasaraavɨ gɨlyɨvɨta pɨnɨ dumaarya! Saꞌ Gotɨyai nyɨgaimwadelyɨra. Gɨmɨnyɨ gɨlyɨvɨsa mamaari yɨdeinyɨra. Nɨmɨ sara yaꞌmujɨ gɨmɨ nadɨthɨka ‘Nɨmɨ Evɨramɨmɨ aꞌmwe naangei wɨmwaaihe!’ dɨwa,” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","21","Dɨvi sagaaꞌ Evɨramɨ waja kyaꞌnaꞌ Gotɨyai Evɨramɨmɨ wɨdaꞌ “Lɨka nadɨkwosɨꞌdɨka! Nɨmɨ gɨmɨnyɨ mwata tinyaꞌna saabyainyɨbɨsainyɨ gɨmaredaavɨdeinyɨra. Gɨlyɨvɨta naanga gɨzaavɨdeinyɨ.” Kudaꞌ saꞌ Evɨramɨ Gotɨyarɨ “Nyɨbwaalɨꞌ nyɨjaadeinyɨ daaka? Kanyɨjaavaꞌgɨzɨ nɨmɨ kabalaꞌmujɨ Elɨyaizai nyɨdaayadei nɨmɨre gɨlyɨvɨta yuya mamaari yadelyɨra.” Miꞌna kudaꞌ Gotɨyai wɨdɨna yaꞌ “Elɨyaizai gɨlyɨvɨsa mamaari yadengɨra. Jɨwaalɨꞌ kaimɨraaya pwai kyawakɨnaꞌgɨzɨ gamɨzai maaradengɨra. Sɨlɨngaamɨnyangɨ jɨlanganaawa! Sɨlɨngaamɨnya kwalaalya warɨka keꞌnɨngɨ jɨlanganaawa! Gɨmɨre kaimɨraaya kwalaalya avaaina yɨmaꞌnɨpɨꞌdengɨra.” Sara kudaꞌ Evɨramɨ “Gotɨyai nebwi nyɨdɨwaꞌ,” yawɨraka wɨlɨmwagaraꞌ. Sara kulɨmwagaraꞌ Gotɨyai dɨnyɨna yaꞌ “Aꞌmwe sai sara yawɨꞌmanɨkei dahaaꞌ aꞌmwe yɨdaꞌmaraangei wɨmwaaihɨweꞌna dɨwana.” Sara dɨnyɨna yaka Gotɨyai wɨdaꞌ “Gɨmɨnyɨ kwaaka Kalɨthɨyadaasɨ gɨmakulaabena kwaaka dava gɨzaave.” Kudaꞌ Evɨramɨ wɨdaꞌ “Gotɨyaigɨ, kwaakeꞌ nɨmɨreꞌ be yawɨtaꞌna yawɨrɨdeꞌneka?” Wɨdɨna kyaꞌ Gotɨyai wɨdaꞌ “Jɨlɨkyaawaryara dɨnyɨmakulaama!” Sara wɨdɨna kyaꞌ Evɨramɨ sara yɨna yaꞌ. Miꞌna makulaabaka bulatamaworipuꞌna yaka wakɨna yaꞌ. Yuta maalɨkeraavɨ tamakɨna yaꞌ. Yuta pwara pɨlavamarina “Mɨwɨta tɨka nyɨna yaana!” deva sagaaꞌ Evɨramɨ tɨnna wanganna yaka marirɨgalaasɨna yaꞌ. Dɨvidaasɨ nyɨlyai walakyaꞌnegaaꞌ nyɨla daavɨna kyaꞌ Evɨramɨ pɨgasaai waja yaꞌnyɨna yaka lɨka yɨna yaꞌ. Miꞌna lɨka yɨna kyaꞌ Gotɨyai wɨdaꞌ “Evɨramɨ, gɨmɨ aꞌmwe nei jɨmaꞌnadeigɨ sagaaꞌ dɨvaideigɨnyɨ. Dahaaꞌna mɨꞌ. Gɨmɨre kaimɨraayara kwaaka pɨbanna wɨna yapɨjɨ saba mwaaibɨꞌderera. Kwaaka saba mwaalyara ‘Aꞌmwera kumɨzara wawɨnya nedaayɨpɨꞌdera yaadeinaava,’ kadapɨjɨ yɨmaꞌnɨpɨꞌderera. Wawɨnya wɨdaayɨpɨꞌdera kyapɨjɨ kwarame naanga 400 kwavɨlavojɨ sara yɨkamaangera yɨpɨꞌderera. Nɨmɨ karamaꞌmujɨ yɨ gɨmɨre kaimɨraayara ayawɨnna wɨdasaabɨdere. Yɨ gɨlyɨvɨkɨraya kɨnɨjɨ kaanna makabɨna yɨpɨꞌdere,” wɨdaꞌ. Miꞌna kudaꞌ sawɨsaꞌ mena kajɨnnaꞌ Evɨramɨ dara wanganakeꞌ “Ai, dɨkeꞌ mɨwɨsangɨ tɨnnyaba danapɨraalaꞌmanɨka!” Kadaꞌ Gotɨyai gannya kɨwɨnyaꞌ wɨdaꞌ “Kwaaka davakɨ sarɨmɨnɨdakaavihɨrɨna yɨhɨzaawevakɨ,” wɨdaꞌ Gotɨyai. ");
INSERT INTO byr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","6","Saraayaꞌ Evɨramɨmɨre balaangaꞌ kaimɨraavɨmaayasɨra. Gamɨre wɨdaayadeꞌ Yɨzɨpɨ kwaakebadaaꞌnyɨ mwaalakeꞌ Ehaasɨra. Mwaalɨna kyaꞌ Saraayaꞌ Evɨramɨmɨ wɨdaꞌ “Gɨmɨ Ehaavɨ dɨmaaka! Kamaaraꞌgɨzɨ gamɨ nɨmɨnyɨne kaimɨraayangɨ mɨladengɨra.” Sara kudaꞌ Evɨramɨ Ehaavɨ maarɨna. Maarɨna kyaꞌ Ehaaꞌ kaimɨraavɨmunya yaka “Nɨmɨ munyaꞌnyɨ aꞌmwe naangeꞌnyɨ Saraayaꞌ kaimɨraavɨmaayaꞌ maalɨkesɨ,” yawɨꞌna. Sara yawɨꞌna kyaꞌ Saraayaꞌ Evɨramɨmɨ wɨdaꞌ “Ehaaꞌ nɨmɨnyɨna ‘Saraayaꞌ maalɨkesɨ,’ kunya yawɨꞌna yɨwaꞌdɨꞌ.” Kudaꞌ Evɨramɨ wɨdɨna “Gɨmɨresɨra. Gɨnnya kunya yawɨraꞌgɨzɨ sara ja!” Miꞌna kudaꞌ Saraayaꞌ Ehaavɨna sɨmɨlɨka wɨlɨna yaka “Wawɨnya naanga ja!” dadeꞌ kyaꞌ Ehaaꞌ “Saraayaꞌ kayaaꞌna nyɨvanɨꞌ. Nɨmɨ kaanna wɨma!” daka wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","16","Kaanna wɨna yaka aꞌmwera mamwaalya kuneba aalɨyɨmɨnyavɨ sabanna Ehaaꞌ mwalaawɨna yaꞌ. Kamwalaawaꞌ Gotɨyare mamaayai ejelɨyai wanganaka “Ehaaꞌ aagaꞌ kamwaalɨka,” daka wɨdaꞌ “Ehaaꞌ, gazɨneꞌgɨnaka?” Sara kudaꞌ Ehaaꞌ wɨdɨna “Saraayavɨna lɨka bena bamwaaihena.” Wɨdɨna kyaꞌ wɨdaꞌ “Saraayayawɨnna jahalaawa! Yagalaawaꞌgɨzɨ gamɨ savɨ duꞌnadera. Kale gyɨwakeꞌgɨnyɨ gwangamanɨkelyɨra Gotɨyai. Nabaai kaimɨraayai Yɨzɨmelɨ dɨmideꞌgɨnyɨ. Gamɨzai kavɨdaayai malakayaawaryaibɨsai yuyaraavɨ mala tamɨna yadelyɨra. Gɨmɨre kaimɨraayara kwala naanga yɨmaꞌnɨpɨꞌderera.” Sara kudaꞌ Ehaaꞌ dɨna yaꞌ “Gotɨyai nyangadelyɨra.” Dɨvidaaꞌnyɨ Evɨramɨ kwarame 86 kwavɨlavaꞌ sagaaꞌ Ehaaꞌ Yɨzɨmelɨmɨ mɨlaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","22","Evɨramɨ kwarame 99 wavɨlavakerɨ Gotɨyai wɨdɨna “Gotɨyainyɨ dɨragɨnyainyɨra.” Gotɨyai sara wɨdɨna kyaꞌ “Gotɨyai naangelyɨra,” daka walarutaꞌnyɨna. Walarutaꞌnyɨna kyaꞌ Gotɨyai wɨdaꞌ “Nɨnnya kɨwɨnyaꞌ gɨzaavɨdeꞌ gazagaasagaaꞌ nebwi waragothesɨra. Aꞌmwe gera geraavɨ kuvɨnɨmaangeigɨ jɨmaꞌnadeꞌna gɨnnya yayaꞌ Evɨraamɨ woꞌnadeigɨnyɨra. Gɨmɨrera pwara aꞌmwe naangera yɨmaꞌnɨpɨꞌderera. Sarɨmɨre Gotɨyainyɨra. Nɨmɨ sainyɨ Kwaaka Kainanɨ gɨmɨnyɨnajɨ gɨmɨre kaimɨraayaraavɨnajɨ yɨhɨzaavɨdeinyɨ. Gɨmɨjɨ gɨmɨnyɨ kaimɨraayarajɨ wawɨnya gɨthaayadɨvɨsarajɨ saihi kɨlaakejɨkɨ pɨkarya daꞌnyɨna jideihɨlyɨra. Bwaranyai sawɨta atina ata purɨdaaasɨ dawaai kajɨnnojɨ gamɨre kɨlaakejɨkɨ pɨkarya davɨna jideihɨlyɨra. Pɨkarya wanganapɨjɨ nɨmɨre kɨwɨnyaꞌ jawɨridesɨra. Aꞌmwe pwai ‘Nɨmɨre kɨlaakejɨkɨ pɨkarya madapɨnera!’ kadozɨ ‘Namwaaladɨka!’ dapɨjɨ Evɨraamɨjɨyaraavɨ yuyagaaꞌ yagalyaꞌmavaderɨ duthaasidelyɨra. Gɨnnya balaangaꞌ Seraaꞌ yaya mudɨka kwoꞌnojɨ gɨmɨnyɨna kaimɨraayai mɨladesɨra. Gamɨ saꞌ kuvɨnaangeꞌ aꞌmwe gera geraavɨ yɨmaꞌnadesɨra.” Sara kudaꞌ Evɨraamɨ jɨka gyaka wɨdaꞌ “Yuyaꞌnaai aꞌmwe neꞌnaalyɨ. Seraaꞌ kaimɨraayai gara mɨladevaka? O, Yɨzɨmelɨmɨna jawɨꞌdelyɨra.” Tɨviꞌna kudaꞌ Gotɨyai wɨdɨna “Yɨzɨmelɨmɨ tewaanya yɨdeꞌna aꞌmwe naangeraavɨre kuvɨnɨmaangei yɨmaꞌnadelyɨ. Saꞌna kɨrɨꞌ kwarame pɨrɨꞌ kwavɨlavojɨ Seraaꞌ kaimɨraayai gɨmɨnyɨna kamɨlojɨ ‘Aazakɨ,’ duthatheigɨnyɨ. Nabaai gamɨnyɨna nɨmɨre kɨwɨnyaꞌ wɨjaavɨdeinyɨ.” Tɨviꞌna wɨdaka Gotɨyai Evɨraamɨmɨ yagalyaꞌmaꞌna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Yagalyaꞌmaꞌna yakegaaꞌ sagaaꞌ Evɨraamɨjɨ aꞌmwe yuyarajɨ kunnya kɨlaakejɨkɨ pɨkarya daꞌnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","15","Evɨraamɨ Maamɨre yɨꞌdaryawɨ mwaaidɨꞌnyɨ Gotɨyai bwanganaꞌ. Evɨraamɨ gannya tɨkuryaba mwaalaka aꞌmwe daraai dalyaraavɨ wanganaka walyuna yaka ata bwaꞌnyɨna yaka wɨdɨna “Nɨmɨjɨ dava dalamwaalyɨla! Wapaaya aalya sarɨmɨnyɨne maarɨdeinyɨ. Aalya yɨnapɨjɨ wapaajɨ napɨjɨ dɨwideihɨlyɨra.” Kumɨ “Yo,” sara kudeꞌ Evɨraamɨ gannya angevɨ yarai wɨlɨna, Seraavɨ wɨdaka “Wapaaya yɨdɨka ja!” kaanyɨveꞌna wawaka jɨlɨkyaawarya maalɨka dɨwɨnyai maarɨna. Maarɨna kyaꞌ wɨdaayadei gurya davɨna yɨdɨka yɨna yakeꞌ Evɨraamɨ wapaaya kumaaryaꞌ kumɨ nyɨna. Miꞌna nyɨna yeva aꞌmwera Evɨraamɨmɨ wɨdeꞌ “Gɨmɨre balaangeꞌ Seraaꞌ gawɨ mwaalɨka?” Sara kudeꞌ Evɨraamɨ wɨdaꞌ “Angevɨ wɨlarɨꞌ.” Kudaꞌ pwai wɨdɨna “Kwarame mudɨkeꞌ kwavɨlavojɨ nɨmɨ yagalaawɨdehaaꞌ Seraaꞌ kaimɨraayarɨ mɨladesɨra.” Miꞌna kudaꞌ Seraaꞌ yagaala davɨ wɨꞌnaka yɨmunna jɨka gyaka dɨna “Naarɨmɨ sayoinaai aꞌmwe neyoinaalyɨra. Kaimɨraayai gara mɨlɨdeꞌnanaka! Nɨmɨ aꞌmwe neꞌnyɨra.” Sara yawɨꞌna kyaꞌ Gotɨyai Evɨraamɨmɨ wɨdaꞌ “Seraaꞌ jɨka baaꞌna gyɨwaka? Gotɨyainyɨ yuyangɨ yɨdeinyɨra. Gamɨ saꞌ dɨwɨjaꞌ kwarame pɨrɨꞌ kwavɨlavojɨ kaimɨraayarɨ mɨladesɨ.” Miꞌna kudaꞌ Seraaꞌ lɨka yaka “Ai, nɨmɨ jɨka magyɨwa.” Sara kudaꞌ Gotɨyai wɨdaꞌ “Gɨmɨ jɨka gyɨwaano.” ");
INSERT INTO byr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","33","Aꞌmwe daraai dai Evɨraamɨmɨ angevɨdaaꞌnyɨ “Sothomɨ angebanneinera,” deva kaanna wɨna. Evɨraamɨjɨ pwalyɨ maalɨkebanna wɨna. Maalɨkebanna wɨna kyagi Gotɨyai wɨdaꞌ “ ‘Sothomɨ mwaalyarajɨ Gamora mwaalyarajɨ aꞌmwe kayaaꞌnanaangerera,’ sara wɨꞌnadɨnyarera. Nɨmɨ walanganɨma! Aꞌmwe kayaaꞌnanaangeraavɨ sara wanganaꞌmuri nɨmɨ tamakɨdeinyɨra.” Aꞌmweraai “Naarɨmɨ walaawaka!” dahɨla walaawɨna kyagi Evɨraamɨ Gotɨyarɨ wɨdaꞌ “Aꞌmwe tewaanyarajɨ mwaaipɨjara nabaai dɨramakɨdeigɨ daaka? Aꞌmwe tewaanya nɨmɨre ata sɨvɨlɨraai aꞌmwe pware ata sɨvɨlɨraai aꞌmwe pware atɨraaina (50) mwaaidapɨjɨ anga naanga yuyaburaavɨ dɨramakɨdeigɨ daaka? Gɨmɨ kwaaka yuyavakɨ maremwaaidɨnyaigɨnyɨ. Gɨmɨ gazagaasagaaꞌ tewaanna yadɨnyaigɨnyɨra.” Sara kudaꞌ Gotɨyai wɨdɨna “Aꞌmwe nyɨdɨwaanyara mwaaidapɨjɨ anga naanga yuyaburaavɨ maramaki yɨdeinyɨra.” Sara kudaꞌ Evɨraamɨ Gotɨyarɨ aꞌmwe tewaanya ata sɨvɨlɨraai, ata sɨvɨlɨraai ata pwina saraavɨna kudaꞌ Gotɨyai “Maramaki yɨdera,” wɨdaꞌ. Sara wɨdɨna kyaꞌ Evɨraamɨ aꞌmwe tewaanya ata sɨvɨlɨraai, ata sɨvɨlɨraalyaraavɨna kudaꞌ Gotɨyai wɨdaꞌ “Angeba maramaki yɨdera.” Sara wɨdɨna kyaꞌ Evɨraamɨ aꞌmwe tewaanya ata sɨvɨlɨraai, atɨraalyaraavɨna ayawɨ kudaꞌ Gotɨyai ayawɨ wɨdaꞌ. Sara wɨdɨna kyaꞌ Evɨraamɨ aꞌmwe tewaanya ata sɨvɨlɨraalyaraavɨna ayawɨ kudaꞌ Gotɨyai ayawɨ wɨdaꞌ. Kudaꞌ Evɨraamɨ aayagaaꞌ wɨdaꞌ “Nɨmɨnyɨna sɨnna tɨka magɨthavannera! Nɨmɨ gave pɨgaaꞌna gɨthɨma! Aꞌmwe tewaanya nɨmɨre atɨraalyara mwaaidapɨjɨ anga naangangɨ dɨramakɨdeigɨ daaka?” Miꞌna wɨdɨna kyaꞌ Gotɨyai wɨdaꞌ “Aawano. Aꞌmwe tewaanya atɨraalyara mwaaidapɨjɨ anga naangengɨ maramaki yɨdeinyɨra.” Miꞌna wɨdaka Gotɨyai kaanna wɨna yaꞌ. Wɨna kyaꞌ Evɨraamɨ gannya angewɨnna yagalaawɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","3","Sawɨsaburɨ Sothomɨ angeburɨnna ejelɨyaraai walaabahi. Aꞌmwe Lotɨ tɨkuryaba mwaaidɨꞌnyɨ ejelɨyaraai kulaabahi Lotɨ wɨdaꞌ “Ata bwaꞌnaana! Nɨmɨre angevɨna kaanya wawaajɨ anga savɨ waꞌmwaraana!” Kudaꞌ ejelɨyaraai wɨdahi “Aala, mwasaba se waꞌmwaraka!” Sara wɨdɨna kyagi Lotɨ “Nɨmɨre angevɨ waraana! ‘Aala,’ beꞌna dɨwaala? Nɨmɨre angevɨ waꞌmwaraana?” Saꞌ kudaꞌ gamɨjɨ wɨlɨna yeva wapaaya nyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","11","Ejelɨyaraai “Naarɨmɨ se waꞌmwaraka!” dahɨla yamaze yɨnaꞌna yadakɨlyɨ Sothomɨ mwaalyara kaanna bɨna yeva Lotɨmɨ jaka wɨdɨna “Aꞌmweraai gawɨ mwaaihɨla? Dɨmakwalyaama! Nemɨ saraarɨ ata lɨmwanna yaana!” Sara kudeꞌ Lotɨ walyuna yaka kaanya tihɨꞌna yaꞌ. Tihɨraka kumɨnyɨ wɨdaꞌ “Sarɨmɨ kayaaꞌna mipɨnera! Nɨmɨre taayawaai saaigɨꞌnyawaai mwaaihɨlyawaarɨ dɨmaarila! Aꞌmweraarɨna myawɨpɨnera!” Miꞌna kudaꞌ Sothomɨ mwaalyara wɨdeꞌ “Gɨmɨ maaveigɨnyɨra. Nemɨnyɨna gɨmɨ dɨnemaremwaaideigɨ daaka! Gɨmɨnyɨna naangevaꞌna kayaaꞌna yaana! Baaꞌna nedɨwaana!” Sara kudeꞌ ejelɨyaraai Lotɨmɨ angevɨdaaꞌnyɨ mwagiꞌnamaata yagɨla kaanya tihɨꞌna yagi. Tihɨꞌna yagɨla Sothomɨ mwaalyaraavɨ tɨnna galapɨnyɨwanna kyagi Sothomɨ mwaalyara tɨnna mwanganyeva “Kaanyaꞌ gavanaka?” deva deva tɨnna wanganyɨꞌmaaꞌna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","14","Ejelɨyaraai Lotɨmɨ wɨdahi “Gotɨyai ‘Aꞌmwe anga davanyara kayaaꞌna yadɨvɨsara daaka?’ daka yawɨraꞌ. Anga davɨdaaꞌnyɨ kɨnɨdakaavihi dɨwila! Naarɨmɨ woꞌdaaina yakadera.” Miꞌna kudahi Lotɨ aꞌmweraai gamɨre taayawaarɨ maaryaꞌneraarɨ kaanna wɨna yaka yagaala wɨdaꞌ “Nemɨ yarai lɨkaanya wawaana! Anga dava kayaaka yadevera.” Sara kudaꞌ saꞌ aꞌmweraai kadɨka muꞌnyɨ yagɨla saba mwaalagi. ");
INSERT INTO byr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","22","Yɨrɨkeꞌ gaai puꞌdaasɨyagaaꞌ dɨkaaꞌna, ejelɨyaraai Lotɨmɨ yagaala naanga wɨdɨna “Dahaasagaaꞌ nemɨ yarai kaanyaana!” Wɨdɨna kyagi Lotɨ kave mwaalɨna kyaꞌ saraai Lotɨmɨjɨ gannya aꞌmwevɨjɨ kɨrɨnnya taayawaarɨjɨ “Yarai kaanyaana!” wɨdahɨla magapɨrina yagɨla angebadaaꞌnyɨ kaanna makuna yagi. Ejelɨyaraai wɨdɨna “Yarai, yarai, ayahi tɨgɨnyɨmaꞌnya mipɨnera! Mugunyavɨna lɨkaanya jɨlaawila! Nabaibɨthɨka!” Sara wɨdɨna kyagi Lotɨ wɨdaꞌ “Mugunyavɨna kaanya yɨlaawiaꞌna lɨka yɨwana. Angebanna yayaꞌ Sawa nɨmɨ wɨlaawɨjɨwana?” Kudaꞌ ejelɨyaraai wɨdahi “Yo, yarai.” ");
INSERT INTO byr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","29","Yarai kaanna wɨna yaka Lotɨ nyɨlyai gaai bilapijɨꞌdaaꞌnyɨyagaaꞌ anga Sawa wɨlɨna yaꞌ. Wɨlɨna kyaꞌ Gotɨyai dɨkesɨ sɨla dɨꞌnakesɨ sangɨ burɨke sɨrɨmyaꞌbɨsaꞌ Sothomɨ angebanna Gamora angebanna wasɨꞌna kyaꞌ angeba kayaaka yɨna yaꞌ. Wasɨꞌna kyaꞌ Lotɨmɨre balaangaꞌ tɨgɨnyɨmaꞌnya kyaꞌ aꞌmwevɨ galyewaaꞌmwanna kyaꞌ aꞌmweꞌ saala yɨmaꞌnyɨna yaꞌ. Mwanyagaaꞌ Evɨraamɨ Sothomɨ Gamora angeba dara wanganakeꞌ “Ai, yunebanna jɨsaꞌ jimwaꞌ!” ");
INSERT INTO byr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","38","Dɨvi sagaaꞌ Lotɨ Sawa angeba mwaalyaꞌnei lɨka yadaaꞌnyɨ gamɨjɨ gamɨre taayawaalyɨ mugunyangɨna kaanna waweva simaangeyawɨ mwaalɨna. Mwaaidapɨjɨ aꞌmwe sɨraangeꞌ gyaꞌmwevɨ wɨdaꞌ “Aꞌmweraai nehɨmaarikadeꞌnaai mamwaalyɨgoi. Nehɨrɨnɨmaangerɨ aalya waainɨyaꞌ wɨjaavakadera. Miꞌna wɨjaavakwoihɨri kaimɨraaya mɨlakadeꞌnaarɨneꞌ sɨnnawɨ nɨmɨjɨ gamɨjɨ se waraka! Dɨvi gɨmɨjɨ se darila!” Sawɨsavɨ sɨraangeꞌ sara kyaꞌ saꞌ myawɨryaꞌ Lotɨ. Sawɨta pɨri ganyaabulaangesɨ waragɨla sagaaꞌ sɨmunya myawɨryaꞌ. Kɨnadaai sara yɨ sɨraangeꞌ kaimɨraaya Mawaavɨrɨ mɨlaꞌ. Yɨ ganyaabulaangeꞌ kaimɨraaya Amonɨmɨ mɨlaꞌ. Savɨdaaꞌnyɨ Mawaavɨrava Amonɨmɨvava yɨmaꞌnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","7","Evɨraamɨ Yɨꞌdarya Maamɨredaaꞌnyɨ Kwaaka Geraanei kaanna wɨna yaꞌ. Wɨna yaka ayagaaꞌ aꞌmweraavɨneꞌna lɨka yaka wɨdaꞌ “Seraaꞌ nyaꞌmwesɨra.” Sara kudaꞌ Avimɨlekɨ Geraa maremwaaidei Seraavɨ gannya angevɨ wakaꞌ. Sawɨta sagaaꞌ wajaꞌ kyaꞌnaꞌ Gotɨyai wɨdaꞌ “Aꞌmwe pware balaangeꞌ maꞌmwaana. Sayaba dɨvaideigɨnyɨra.” Avimɨlekɨ Seraavɨ kwala mamaaryaka Gotɨyarɨ wɨdaꞌ “Nɨmɨnyɨjɨ nɨmɨre maremwaaidɨnyaraavɨjɨ dɨramakɨjɨwaana? Evɨraamɨ nyɨdɨwaꞌdɨꞌ ‘Gamɨ nyaꞌmwesɨra.’ Nabaai Seraaꞌ nyɨdɨwaꞌdɨꞌ ‘Evɨraamɨ nyaꞌmwelyɨra.’ ” Wɨdɨna kyaꞌ Gotɨyai wɨdaꞌ “Saꞌ yawɨꞌmwa. Gɨmɨnyɨne ‘Avimɨlekɨ kayaaꞌna nyadɨꞌ! Seraavɨ mamaarannera!’ dena navɨka gɨmwaaihe. Evɨraamɨmɨne Seraavɨ ayawɨ dumaarya! Gamɨ sai nɨmɨnyɨne wɨdadelyɨra. Gamɨ ‘Avimɨlekɨ nabaladɨka!’ dozɨ Gotɨyainyɨ yagaala nyɨdathera,” wɨdaꞌ Gotɨyai. ");
INSERT INTO byr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","18","Mwanyavɨ Avimɨlekɨ Evɨraamɨmɨ jaka wɨdaꞌ “Kaajo!” Evɨraamɨ kabaꞌ wɨdaꞌ “Nemɨ gɨmɨnyɨne kayaaꞌna myadaanyainera. Saꞌ baaꞌnebwi yɨvanɨgɨna?” Sara kudaꞌ Evɨraamɨ wɨdɨna “ ‘Aꞌmwe davanyara Gotɨyareburɨ myadɨvɨsarera,’ dena ‘Seraaꞌ nyaꞌmwesɨra,’ yɨhɨthɨwaꞌdeinyɨ. ‘Nyɨramakɨpɨꞌdeꞌna Seraavɨ maapɨꞌdera,’ dena yɨhɨthɨwaꞌdeinyɨ. Gamɨzaꞌ nɨmware taayaꞌ mwaalaka nɨwaavɨre taayaꞌ mamwaalyɨ kyaꞌ nɨmɨ maare.” Miꞌna wɨdɨna kyaꞌ Avimɨlekɨ Evɨraamɨmɨna Seraavɨ wɨjaavɨna yaꞌ. Nabaai wawɨnya yadɨvɨsaraavɨjɨ jɨlɨkyaawaryaraavɨjɨ wɨjaavɨna yaꞌ. Wɨjaavaka wɨdaꞌ “Dava nɨmɨre kwaakeꞌ warɨkeba gɨmɨre kunyavɨdaaꞌnyɨ ‘Gɨmɨre kwaaka warɨkeba mwaalɨma!’ daꞌgɨzɨ dɨmwaala!” Avimɨlekɨ sara kudaꞌ Evɨraamɨ Avimɨlekɨmɨna Gotɨyarɨ kudaꞌ Gotɨyai gamɨnyɨjɨ gannya aꞌmwengɨjɨ tewaanna yaꞌ. Miꞌna kyaꞌ ayaꞌna Avimɨlekɨmɨre aꞌmwe kaimɨraayangɨ mɨleꞌ. ");
INSERT INTO byr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","8","Evɨraamɨ kwarame 100 (waanɨ aadɨretɨ) wavɨlavakei kaimɨraayarɨ kyawakɨnaꞌ Gotɨyai sara wɨdakeꞌ Evɨraamɨ “Gannya yayaꞌ Aazakɨ,” wɨdaꞌ. Aazakɨ sawɨta daryaai daryaai daryaai darɨꞌ kajɨnnaꞌ ganɨmaangai gamɨre kɨlaakevɨ pɨkarya yaꞌ. Seraaꞌ wɨdaꞌ “Gotɨyai nɨmɨnyɨna tewaanna yɨnɨkelyɨra. Nɨmɨjɨ nɨmɨre aꞌmwelyɨ saꞌnaai aꞌmwe neꞌnaai kaimɨraayarɨ maaroi. Aꞌmwe aꞌmwera jɨka maregyɨpɨꞌdelyɨra,” wɨdaꞌ. Seraaꞌ Aazakɨmɨ aamunya mujaayɨ yakegaaꞌ Evɨraamɨ munne naangeꞌ yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","21","Ehaavɨre kaimalei Yɨzɨmelɨ Aazakɨmɨ maanga dada mala tamɨna yadaaꞌnyɨ Seraaꞌ wanganaka Evɨraamɨmɨ wɨdaꞌ “Ehaasɨ gamɨre kaimɨraayalyɨ sawaarɨ duthaaso! Gɨmɨ balaꞌgɨzɨ ‘Yɨzɨmelɨ nɨmɨre gɨlyɨvɨsa namaaradɨka!’ daꞌgɨzɨ duthaaso!” Miꞌna kudaꞌ Evɨraamɨmɨ gannya kaimɨraayaryaba kale wiaꞌ. Kale wiadaaꞌnyɨ Gotɨyai wɨdɨna “Ehaasɨ Yɨzɨmelɨjɨ sawaarɨna kale magyannera! Dɨvi sagaaꞌ gɨmɨre kaimɨraaya Yɨzɨmelɨmɨre kwala naanga yɨrɨvadengɨ. Saꞌ Aazakɨ jɨwaalɨvaanga nebulyai naangelyɨra.” Yɨrɨka kavuraꞌ Evɨraamɨ Ehaavɨne wapaajɨ aalyasɨ wɨjaavaka wɨdaꞌ “Dahaaꞌ dɨwila!” Kudaꞌ kɨnaai yagalyaꞌmaꞌna yagɨla kaanna kaanna yamaryagɨla kwaaka kayaaꞌna naanga Bɨyazivana yɨꞌmaꞌna. Yɨꞌmaꞌna kyagi dɨvidaasɨ aalɨtala kuneꞌ waꞌdɨsɨ yɨta maalɨkikɨ yɨkaavɨlyavɨ Ehaaꞌ Yɨzɨmelɨmɨ yagalyaꞌmavaka pɨba mwaalɨna yaꞌ. Mwaalakebadaaꞌnyɨ dɨna “ ‘Nɨmɨre kaimalei baladerɨ tɨnna nangamudɨka!’ dena yɨkaavɨlyavɨ mwaaidɨsɨ pɨba mwaaimwa.” Sara dɨna kyaꞌ Gotɨyare mamaayai ejelɨyai Ehaavɨ jaka wɨdɨna “Lɨka minnera! Yɨzɨmelɨ kɨnna dadaasɨ wɨꞌnɨwa. Gamɨ mwaalajare kwala naanga yadengɨ.” Sagaaꞌ Gotɨyai aalɨyɨmɨnyavɨ yɨbwarɨdaakwaꞌ. Kyɨbwarɨdaakwaꞌ Ehaaꞌ aalya yɨrɨna yaka gawaalɨvɨ wirina yaꞌ. Yɨzɨmelɨ aꞌmwei yɨmaꞌnaka Kwaaka Paraanɨ mwaalaꞌ. “Aꞌmwe Yɨzɨpɨ mwaalyaꞌ maarana!” Ehaaꞌ daka maaraka Yɨzɨmelɨmɨna wɨjaavaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","31","Avimɨlekɨjɨ gannya aꞌmwe naangelyɨ saraai Evɨraamɨmyawɨnna bahɨla wɨdɨna “Gotɨyai gɨhaimwadelyɨra. Gɨmɨnyɨne jaꞌmweinyɨ yɨmaꞌnɨgeinyɨra. ‘Yuyagaaꞌ jaꞌmwei yɨmaꞌnɨdeinyɨ,’ nebwina nyɨdana! Kwaasɨ nadɨthɨka!” Sara wɨdɨna kyaꞌ Evɨraamɨ wɨdaꞌ “Avimɨlekɨ, jaꞌmweinyɨ. Sara dɨwaanyaꞌ gɨmɨre gɨthaayadɨvɨsara nemɨre aalɨbunyavɨ kuka maꞌmwaava.” Kudaꞌ Avimɨlekɨ “Nɨmɨ mujɨweinyɨra,” yawɨraka wɨdaꞌ “Yagaala daꞌ myawɨriwana.” Sara kudaꞌ Evɨraamɨ jɨlɨkyaawarya Avimɨlekɨmɨne wɨmaaryaꞌ. Nabaai sipɨzipɨya dɨwɨnya dawaai dawaai dawaai daꞌ gavinya pɨba wɨmwaaihɨna yaꞌ. Wɨmwaaihɨna kyaꞌ Avimɨlekɨ wɨdaꞌ “Sa gavinya pɨba beꞌna wɨmwaihɨwaana?” Miꞌna kudaꞌ Evɨraamɨ wɨdɨna “Sipɨzipɨya sa dɨmaaꞌdengɨna aꞌmwe pwara yawɨpɨꞌdeꞌ ‘Evɨraamɨ aalɨhavi’ nɨnnya’ lɨkɨnɨkesɨra,’ ” wɨdaꞌ. Savɨdaasɨ kwaakavɨne yayaꞌ Bɨyaziva wɨdɨna yaꞌ Evɨraamɨ. ");
INSERT INTO byr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","34","Evɨraamɨ miꞌna kyaꞌ Avimɨlekɨjɨ gamɨre aꞌmwe naangelyɨ saraai kɨrɨnnya Kwaaka Pɨlɨzɨtɨyana wɨna. Kaanna wɨna kyagi Evɨraamɨ “Gotɨyai gazagaasagaaꞌ mwaaladelyɨra,” daka Bɨyaziva yɨta dɨragɨnya burɨnna yaka Gotɨyarɨna yɨleyagaala wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","19","Dɨvidaaꞌnyɨ Gotɨyai daka “Evɨraamɨ gara yadelaka?” wɨdaꞌ “Aazakɨmɨna yɨlaaya naanga yadɨnyaigɨnyɨra. Gamɨnyɨ Moraaya kwaakevɨna dɨmakwodeigɨnyɨra. Mugunya savɨ Aazakɨmɨ dɨkevɨ dɨmariraꞌdelyɨra. ‘Gotɨyarɨna wɨjaavɨdeinyɨ,’ dɨthadeigɨnyɨra.” Miꞌna kudaꞌ yɨrɨkeꞌ kavuraꞌ Evɨraamɨ jɨlɨkyaawarya dogiyavɨ dɨkɨraya yɨlakɨna kyaꞌ Aazakɨjɨ wawɨnya wɨdaayadisaraalyɨ gamɨjɨ wɨna. Kaanya kuna yadaaꞌnyɨ sawɨta pɨryaai kajɨnnaꞌ Moraayana kwaaka yɨꞌmavaawɨna yeꞌ. Yɨꞌmavaawɨna kyeꞌ Evɨraamɨ wawɨnya wɨdaayadisaraarɨ wɨdɨna “Dava jemwaalyɨla! Nɨmɨjɨ kaimɨraayalyɨ sainaai mugunyavɨna yɨlaawaka! Gotɨyarɨna wɨdakadera. Miꞌna wɨdakwoihɨri naarɨmɨ yagalaawakadera.” Sara wɨdɨna yaka Evɨraamɨ kwaariꞌmatasɨ dɨkesɨ yengwɨtavamakuna yaꞌ. Aazakɨ dɨkɨraya makuna yaꞌ. Kaanna yɨlaawɨna yadaakɨri Aazakɨ Evɨraamɨmɨ wɨdaꞌ “Nɨmwai, jɨlɨkyaawarya Gotɨyarɨne wɨjaavakadei gavanako?” Kudaꞌ Evɨraamɨ wɨdaꞌ “Nyɨbwaalɨꞌ, Gotɨyai jɨlɨkyaawaryarɨ nehɨzaavadelyɨra.” Sabanna yɨlyɨꞌmavaawɨna kyagi Evɨraamɨ simɨnyeꞌ lɨvalaabaka dɨke yabɨlɨngaka Aazakɨmɨ wɨla marapwɨyɨna yaka dɨka yabɨlɨngakevɨ aꞌbadaaꞌnyɨ yɨlamaarakɨna yaka kwaariꞌmata maarɨna yaka dɨna “Nɨmɨ daakwɨma kwaariꞌmata dasɨ!” Kadaꞌ Gotɨyare ejelɨyai jaka wɨdaꞌ “Jɨwaalɨvɨ maramakɨnnera! ‘Dahaaꞌ Evɨraamɨ nɨmɨrebwi yadelyɨra,’ daka Gotɨyai gɨmɨnyɨna yawɨꞌmwaꞌ.” Miꞌna wɨdɨna kyaꞌ Evɨraamɨ tɨnna dara wanganakeꞌ “Jɨlɨkyaawaryarɨ yɨsɨkɨ gɨlaꞌmwannaꞌna yɨwakeꞌ daaka!” Gawaalɨvɨ wɨlyaꞌ yaarɨna yaka gɨlaꞌmwannaꞌdɨꞌnyɨyai maarɨna yaka tamɨna yaka simɨnyevɨ yɨlamarakɨna yaka dɨka yɨraꞌna yaka Gotɨyarɨ wina yaꞌ. Evɨraamɨ yɨleyagaala wɨdaꞌ “Dava Gotɨyai nejaavaderyaba.” Nabaai Gotɨyai Evɨraamɨmɨ jaka wɨdaꞌ “Nɨnnya yayaꞌna gɨthɨvanɨgeꞌ ‘Nyɨbwaalɨꞌ Aazakɨmɨ Gotɨyarɨna wɨjaavɨma!’ dɨwaanyaꞌna gɨmɨre kaimɨraayara sɨlɨngaamɨnya yuyabɨsara kwala naanga naanga yɨrɨpɨꞌderera. Yɨ kumɨ sara kunnya y’ kamaangeraavɨ maremwaaibɨꞌderera. Yɨ kumɨnyɨna nɨmɨ aꞌmwe kwaakevakɨ mwaalyaraavɨne tewaanna yɨderera,” wɨdaꞌ Gotɨyai. Miꞌna kudaꞌ Evɨraamɨjɨ Aazakɨjɨ walaabɨna kyagi Evɨraamɨmɨre wawɨnya yadisaraalyɨ ayawɨ Bɨyazivana bɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","24","Dɨvi sagaaꞌ Evɨraamɨmɨ wɨꞌnaꞌ “Naawo jɨthaakaangei gawaalɨvaanga aꞌmwere sɨvɨlɨraai ata purɨdaaꞌnyɨ pwaraalyaraavɨ yawakɨnaꞌ. Gawaalɨvaanga pwai Betɨyɨwelɨ taaya Revekaavɨ yawakɨnaꞌ,” wɨꞌnaꞌ Evɨraamɨ. ");
INSERT INTO byr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","20","Seraaꞌ kwarame 127 kwavɨlavaꞌ Evɨronɨ angeba balaꞌ. Kabalaꞌ Evɨraamɨ kɨnna dɨna. Miꞌna kɨnna dɨna yaka Evɨraamɨ Etɨyaraavɨ wɨdaꞌ “Kwaaka daꞌ nɨmɨreꞌ daaka! Mudɨkeinyɨra. Nɨnnya aꞌmweꞌ wakɨdeꞌna kwaaka pɨrɨꞌ nyɨjaayɨla!” Sara kudaꞌ Etɨyara wɨdeꞌ “Aꞌmwe naangeigɨ, nemɨre gɨlaaya wakadaanyaba saba gɨnnya aꞌmweꞌ dakya tewaanyaba!” Sara kudeꞌ Evɨraamɨ “Su!” daka wɨdaꞌ “Simaanga Maakɨpela sabanna nɨgwɨmubya yɨhidera.” Kwaaka savɨ gyakwai Epɨronɨ Evɨraamɨmɨ wɨdaꞌ “Gazare wɨjaavɨna yɨdeinyɨra.” Miꞌna kudaꞌ “Kwaakaꞌna nɨgwia gɨzaavɨdera. Nɨgwia gara gara gɨzaavɨjɨwano?” Epɨronɨ wɨdaꞌ “Aꞌmwera ‘Gɨlaaya wakaana!’ dadɨvɨꞌ 90 kinaaya mubadɨvɨsasɨra. Nyaꞌmweigɨ nɨgwia warana! Gɨnnya aꞌmweꞌ dakya!” Sara kudaꞌ Evɨraamɨ Epɨronɨmɨne nɨgwia wɨjavadaaꞌnyɨ aꞌmwe yuyara banganaraꞌ. Kwaaka miꞌna mubaka Maamɨre kwaaka saba simaangevɨ Seraavɨ wakaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","9","Evɨraamɨ aꞌmwe nei mwaalaka gannya wawɨnya wɨdaayade naangerɨ jaka wɨdaka wɨdɨna “Nɨmɨre kaimɨraayarɨne aꞌmweꞌ dumaaridera. Kainanɨ mwaalyaraayawɨnna munnera! Nɨmɨre avaalyaraayawɨnna kaanya wawaꞌgɨzɨ dɨmaraawɨde. Yagaala naangaꞌ Gotɨyaryaba ‘Evɨraamɨgɨ nyɨdɨwaanyaꞌ sara yɨdeinyɨra,’ nyɨdana!” Wɨdɨna kyaꞌ wawɨnya wɨdaayadei yagaala Evɨraamɨ wɨdake wɨdaꞌ “Aꞌmweꞌ ‘Sabanna kaanna mwɨyɨ yɨdeꞌnyɨ,’ kanyɨdozɨ gamɨre kwaakevɨna Aazakɨmɨ makabɨna yɨdeinyɨ da?” Sara kudaꞌ Evɨraamɨ wɨdɨna “Arɨkawɨnyɨra. Nɨnnya kaimɨraayai mamakunnera! Gotɨyai gannya mamaayarɨ yaasɨna kyojɨ gamɨ gɨmɨnyɨne tewaanna yadelyɨra. Aꞌmweꞌ ‘Aalo,’ kadozɨ, ‘Kaanya muwɨnera!’ kagɨthozɨ gɨmɨre wawɨnya miꞌnanyɨra. Waramaryana!” Miꞌna wɨdɨna kyaꞌ wawɨnya wɨdaayadei wɨdaꞌ “Gɨmɨ dɨwaanyabwi yɨdeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","14","Evɨraamɨmɨre wɨdaayadei kaanya wawaka narɨnna, nɨgwia, gɨlyɨvɨta naanga maaraka kaamelɨya atɨraalyangɨ gɨlyɨvɨsa yɨlamarakaka kaanna makuna. Makuna yaka kwaaka Mezapotemɨyana yɨꞌmavaawɨna yaka angeba Aaranɨ aalɨkaviꞌnɨnnyayaba mwaalɨna. Gamɨre kaamelɨyara sɨvɨla tɨkaꞌna aalɨkaviꞌnɨnnyayaba mwaalɨna. Mwaalɨna kyaꞌ Evɨraamɨmɨre wɨdaayadei Gotɨyarɨ wɨdɨna “Gotɨyaigɨ, Evɨraamɨmɨne tewaanna yɨjaꞌ gɨmɨre asɨrɨna wɨma! Davanya sɨdɨraaya aalɨkavi’ nɨnnyavɨna kulaabapɨjɨ sɨdɨraaya pɨrɨꞌ kulaabozɨ ‘Aalyaꞌ dɨnyɨrya!’ sara kudaꞌmujɨ aalyaꞌ nyɨryojɨ nabaai nɨmɨre kaamelɨyaraavɨne aalyaꞌ kwiryojɨ yawɨꞌna yɨdera ‘Aazakɨmɨneꞌ daaka aꞌmwe dava!’ dɨdeinyɨra,” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","25","Gotɨyarɨ wɨdadaaꞌnyɨyagaaꞌ sɨdɨraaya Revekaaꞌ aalyaꞌna bɨna. Sɨdɨraaya saꞌ nawɨꞌnyaꞌ kwala mamaaryaꞌ mwaalɨna yakesɨ. Evɨraamɨmɨre wawɨnya wɨdaayadei wanganaka wɨdaꞌ “Aalyaꞌ nyɨryaama! Nɨma!” Miꞌna kudaꞌ Revekaaꞌ aalyaꞌ yarai yɨrɨna yaka wɨjaavɨna. Sara yaka wɨdaꞌ “Nabaai gɨmɨre kaamelɨyaraavɨne aalyaꞌ pɨrɨsɨ wirima!” Sara wɨdakeꞌ yadaaꞌnyɨ Evɨraamɨmɨre wɨdaayadei tɨnna wanganaꞌ. Revekaavɨne sɨnna kadɨtaavarya gɨlɨraka wɨjaavɨna yaka wɨdaꞌ “Gɨmaamaangei aaihwareꞌgɨnaka? Gɨmaamaangere angevɨ gavinyavɨ nɨmɨ mwaalɨdeinyɨ dɨngaka?” Kudaꞌ Revekaaꞌ wɨdaꞌ “Betɨyɨwelɨmɨreꞌnyɨra. Naawomɨ balaangeꞌ Milɨkaaꞌ gamɨzai mɨlaꞌ. Nɨmware anga wapaaya waꞌdevɨ dɨmwaaideigɨnyɨra,” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","27","Evɨraamɨmɨre wɨdaayadei “Gotɨyai naangeigɨnyɨ,” daka tutaꞌnyɨna yaka wɨdaꞌ “Evɨraamɨ guꞌnadelyɨra. Nyɨmaremwaaiderɨne tewaanna yagɨna gamɨjɨ avaalyaraavɨna nyɨbwarɨdakɨwaana,” wɨdaꞌ Gotɨyarɨ. ");
INSERT INTO byr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","31","Revekaaꞌ “Nɨwaavɨ wɨdɨma!” daka kaanyɨveꞌna wɨna. Dɨvi gathaakaangei Laivanɨ aalɨbunyayabanna baka wɨdaꞌ “Ata bwaꞌnaka! Kaajo! Nemɨre angevɨ tewaanya yɨwevɨ dɨmwaalo!” Sara kudaꞌ Evɨraamɨmɨre wɨdaayadelyɨ Laivanɨjɨ wawagi. ");
INSERT INTO byr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","49","Laivanɨ kaamelɨyaraavɨne wapaaya wɨmaarina yaka aalya yɨnyaꞌnesɨ wapaayajɨ maarɨna yaka Evɨraamɨmɨre wɨdaayaderɨ wɨjaavɨna yaꞌ. Wɨjaavɨna kyaꞌ saꞌ wɨdaayadei wɨdɨna “Sɨnnawɨ sagaaꞌ ‘Nɨmɨ wɨlaabena nɨmɨre wawɨnyaꞌ berɨvaka?’ dena dɨnyuꞌnyi! Nɨmɨre dɨwɨjavɨ kanyuꞌnapɨjɨ nɨmɨ wapaa nɨdera. Evɨraamɨmɨre wawɨnya wɨdaayadɨnyainyɨ naangeinyɨ Gotɨyai Evɨraamɨmɨne tewaanna kyaꞌ gɨlyɨvɨkɨravɨnakelyɨra. Seraasɨ Evɨraamɨjɨ aꞌmwe neyoi kyɨmaꞌnagi Seraaꞌ kaimalei kamɨlaꞌ kaimalerɨ Aazakɨ yayaꞌ woꞌnaꞌ. Evɨraamɨ kabalojɨ Aazakɨ gɨlyɨvɨta yuya maaradelyɨra. Evɨraamɨ nyɨdaꞌ ‘Kaanna wɨjaꞌ nɨmɨjɨ avaalyaraavɨreba Aazakɨmɨne aꞌmweꞌ dɨvɨramaaꞌ! Gotɨyai gɨhaimwagadeigɨnyɨra. Aꞌmweꞌ kagɨthozɨ “Kaanna mwɨyɨ yɨdeꞌnyɨ,” wawɨnya gɨmɨreꞌ mɨꞌ,’ sara nyɨdaꞌ Evɨraamɨ. Nɨmɨ aalɨbunyayabanna bena Gotɨyarɨ wɨdɨwa ‘Aazakɨmɨre balaangaꞌ yɨmaꞌnadevɨ nyɨbwarɨdaakwia!’ Kudɨwa Gotɨyai Revekaavɨ nyɨbwarɨdaakwɨwaꞌ. Evɨraamɨmɨre gawaalɨvɨne aꞌmweꞌ Revekaaꞌ dumaarijɨwaai? ‘Nɨmɨ yawɨrɨdeꞌna kɨrɨmɨre sɨmunya yawɨꞌdita nyɨjɨla!’ Nɨmɨ yɨhuꞌnɨma!” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","61","Revekaavɨre ganɨmaangei Betɨyɨwelɨjɨ Laivanɨjɨ sanɨdaai wɨdahi “Gotɨyai dara yakeꞌ naarɨmɨ yagaala madakanera! Revekaavɨ dɨmakwona!” Miꞌna kudahi Evɨraamɨmɨre wɨdaayadei gɨlyɨvɨta naanga yanga mudaꞌ. Mwanyavɨ “Nɨmɨ wɨma!” dadaaꞌnyɨ Revekaavɨre ganaangesɨ gathaakaangelyɨ wɨdahi “Dava sawɨta atɨraai mwaalakɨri dɨwidewaaihɨlyɨ.” Saꞌ Evɨraamɨmɨre wɨdaayadei wɨdaꞌ “Aala. Dahaaꞌ kaanna wɨdera.” Sara kudaꞌ Revekaavɨ wɨdahi “Dahaaꞌ gamɨjɨ dɨwijɨwaai?” Revekaaꞌ wɨdaꞌ “Nɨmɨ kaanna wɨdera.” Sara kudaꞌ gyaꞌmwelyɨ ganaangesɨ sawaai wɨdahi “Gɨmɨ kaimɨraaya kwala naanga maaꞌdɨzara kunnya yɨkamaangeraavɨ maremwaaibɨꞌderera.” Miꞌna kudahi Evɨraamɨmɨre wɨdaayadei Revekaavɨjɨ gamɨre wɨdaayadɨvɨsangɨjɨ maarɨna kyaꞌ kumɨ kaanna wɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","67","Pɨgaaꞌ sawɨsaburɨ Aazakɨ wawɨnyavɨ mwaalaka dara wanganakeꞌ “Kaamelɨyara keibanna jɨnɨgava!” Aazakɨ wangadaaꞌnyɨ Revekaaꞌ gamɨzarɨ wanganaka bwalaawɨna yaka Evɨraamɨmɨre wɨdaayaderɨ wɨdaꞌ “Aꞌmwei aaihwalaka?” “Aazakɨ gɨmɨre kwalaangelyɨra.” Sara kudaꞌ Revekaaꞌ kawaaka yɨꞌnaꞌ. Wɨdaayadei Aazakɨmɨ gamɨ yakeꞌ wɨdaꞌ. Miꞌna kudaꞌ Aazakɨ Revekaavɨ gannya angevɨ wɨmwaaihɨna kyaꞌ aꞌmweyoi mwaalagi. ");
INSERT INTO byr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","6","Evɨraamɨ aꞌmwe pɨrɨꞌ Keturaayaꞌ kamaaraꞌ gawaalɨvaanga daraai daraai daraai mɨlaꞌ. Gawaalɨvavaavɨ yaya geꞌ geꞌ wɨdaꞌ “Pwai Sɨmɨranɨ, pwai Jokɨzaanɨ, pwai Methaanɨ, pwai Mɨthɨyanɨ, pwai Yɨzɨvaakɨ, pwai Sɨwaa.” Yaya woꞌnɨkera kamwaaleꞌ dɨvidaasaꞌ Keturaayavɨreraavɨ Evɨraamɨ gɨlyɨvɨta pwarɨ pɨrɨꞌna, pwarɨ pɨrɨꞌna wɨmaaryaka wɨdaasaka gannya gɨlyɨvɨta yuya Aazakɨmɨna wɨjaavaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","11","Evɨraamɨ kwarame 175 kwavɨlavaꞌ balaꞌ. Kabalaꞌ gawaalɨvaangeraai Aazakɨjɨ Yɨzɨmelɨjɨ saraai Maakɨpela simaangevɨ Evɨraamɨ Seraavɨ wakakevɨ wakagi. Yɨ Gotɨyai Evɨraamɨmɨne tewaanna sara yakeꞌ yɨ Aazakɨmɨne tewaanna sara yaꞌ. Tewaanna yadaaꞌnyɨ Aazakɨ aalɨbunya Laaꞌeroi saba mwaalaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","18","Yɨzɨmelɨ kwaaka Yɨzɨpɨ pimagɨ mwaalyai kuvɨnɨmaangei gawaalɨvaanga sɨvɨlɨraai ata purɨdaasɨ pwaraalyaraavɨ wɨmwaaihaꞌ. Yɨzɨmelɨ mwaalakei mwaalakei balaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","26","Aazakɨmɨre aꞌmweꞌ Revekaaꞌ kaimɨraavɨmaayaꞌ mwaaidɨꞌnyɨ Aazakɨ Gotɨyarɨ Revekaavɨna kudaꞌ aꞌmwe kaimɨraavɨmunnakeꞌ mwaalaꞌ. Kaimɨraavɨmunnakaꞌ kamwaalaꞌ Gotɨyai wɨdaꞌ “Bwaranyaraai pwaraainesɨ. Aꞌmwe saraai yɨ pwai aꞌmwe pwaraavɨ kuvɨnɨmaangei yɨmaꞌnadelyɨ. Yɨ pwai aꞌmwe pwaraavɨ kuvɨnɨmaangei yɨmaꞌnadelyɨra. Pwai dɨragɨnna kamwaalojɨ pwai kɨbawana mwaaladelyɨra. Sɨraangei dɨviyarɨne wawɨnya wɨdaayadelyɨra,” wɨdaꞌ Gotɨyai. Dɨvidaaꞌnyɨ Revekaaꞌ avaalagaaꞌ bwaranyaraai pwaraai maaraꞌ. Kamaaraꞌ “Sɨraangarɨne yayaꞌ Yɨzoi dɨviyai Jaikopɨ,” sara dahi. ");
INSERT INTO byr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","34","Kɨdaraai aꞌmweraai kyɨmaꞌnagi yɨ Yɨzoi yɨkurɨyaawɨhayaꞌna yakelyɨ. Yɨ Jaikopɨ gannya wawɨnyanna yɨwaainada angebanna mwaaidelyɨ. Yɨkurɨyaawia kamaaraꞌ waburyaꞌna wiakei Aazakɨ Yɨzorɨ yɨlaaya marina yaꞌ. Revekaaꞌ Jaikopɨmɨ yɨlaaya maryaꞌ. Pɨgaaꞌ Jaikopɨ yɨwaadabe yɨraaina yakegaaꞌ Yɨzoi mɨjɨka wiakei yɨꞌdaryavɨdaasɨ wɨlaabaꞌ. Wɨlaabaka Jaikopɨmɨ wɨdaꞌ “Wapaaya wayaaka pɨrɨꞌ nyɨjaama!” Miꞌna kudaꞌ Jaikopɨ wɨdaꞌ “Sɨnnawɨ sagaaꞌ sɨraangebwina gɨmubɨma! ‘Nɨmɨ aꞌmwe naanga yɨmaꞌnɨdeinyɨ,’ dena gɨthɨwa.” Yɨzoi wɨdaꞌ “Mɨjɨka naanga nyɨwakeꞌna nɨmɨ kabaimudɨkeinyɨra. Nɨmɨ aꞌmwe naangeinyɨ dadɨnyainyɨ dahaaꞌ aawano. Nɨmɨ aꞌmwe naangeinyɨ mamwaalyɨ yɨdeinyɨra. Aꞌmwe naangannyaꞌ waramaryana! Saꞌ maalɨkesɨra.” Sara kudaꞌ Jaikopɨ wɨdaꞌ “Kwaasɨ yagaala nanyɨdɨthɨka! Naangeꞌna nyɨdana!” Sara kudaꞌ Yɨzoi sara yaꞌ. Miꞌna kyaꞌ Jaikopɨ wapaaya kujaavaꞌ Yɨzoi naꞌ. ");
INSERT INTO byr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","6","Kwaaka Kainanɨ Aazakɨ mwaaidɨꞌnyɨ mɨjɨka wiadaaꞌnyɨ Kwaaka Pɨlɨzɨtɨya wawaka Geraa angebanna yɨꞌmavaawɨna yaꞌ. Sagaaꞌ “Avimɨlekɨ kwaaka daꞌ maremwaaidelyɨ,” wɨdesalyɨ. Gotɨyai Aazakɨmɨ wɨdaꞌ “Dava dɨmwaai! Yɨzɨpɨna munnera! Nɨmɨre yagaala gɨmaamaangei Evɨraamɨmɨ wɨdei tewaanna yakerɨne yagaala saꞌ gɨmɨjɨ kaimɨraayarari gɨmɨnyɨnajɨ tewaanna yɨhyɨdeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","11","Aazakɨ mwaalaka Avimɨlekɨmɨ wɨdaꞌ “Revekaaꞌ nyaꞌmwesɨra.” Dɨvidaasɨ Avimɨlekɨ dara wanganakeꞌ “O, Revekaaꞌ gannya balaangeꞌ daaka!” daka Avimɨlekɨ wɨdaꞌ “Revekaayaba beꞌna nedahɨna! Kwaasɨ yagaalyaꞌ ‘Nyaꞌmwesɨreva,’ nedahɨ.” Miꞌna sara kudaꞌ “Aꞌmweraavɨna lɨka yena yɨhɨthe.” Miꞌna kudaꞌ Avimɨlekɨ gannya maremwaaideraavɨ yagaala naanga wɨdaꞌ “Aazakɨmɨjɨ Revekaavɨjɨ sawaarɨ mipɨnera!” ");
INSERT INTO byr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","16","Aazakɨ Pɨlɨzɨtɨya mwaalaka witɨzɨla burɨnna kyaꞌ savɨdaasɨ sɨla naanga kyɨꞌnaꞌ maaraꞌ. Nabaai gamɨre jɨlɨkyaawarya kwala naanga yɨmaꞌnyɨna yeꞌ. Pɨlɨzɨtɨya mwaalyara dara wanganesaꞌ “Ai, Aazakɨmɨre gɨlyɨvɨta naangengɨra.” Deva aalɨbunyavɨ kwaakeꞌ maryabɨsɨꞌna yeꞌ. Maryabɨsɨꞌna kyeꞌ Avimɨlekɨ Aazakɨmɨ wɨdaꞌ “Gɨmɨ dɨragɨnyaigɨnyɨra. Dava dɨhalyaꞌmaka!” ");
INSERT INTO byr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","25","Avimɨlekɨ ‘Dɨhalyaꞌmaꞌ!” kudaꞌ Aazakɨ kaanna wawaka Geraa taawalyawɨ mwaalaꞌ. Saba Evɨraamɨ mwaalakegaaꞌ gamɨre wɨdaayadɨvɨsara aalɨbunya lɨkeꞌ. Sɨnnawɨ Evɨraamɨ kabalaꞌ Pɨlɨzɨtɨyara kwaaka maryabɨsɨꞌna yeꞌ. Aazakɨ ayawɨ dɨvidaaꞌnyɨ jɨrɨpwasɨꞌnaꞌ. Aazakɨmɨre wɨdaayadɨvɨsara aalɨbunya lɨkeva dara wanganesaꞌ “Aalyaꞌ dalyuvanɨka!” desagaaꞌ Geraa mwaalyaraavɨ sɨnna tɨka naanga wɨdavaꞌ. Kudavaꞌ Geraa mwaalyara wɨdeꞌ “Aalya daꞌ nemɨresɨra.” Sara kudeꞌ Aazakɨmɨre wɨdaayadɨvɨsara aalɨbunya pɨrɨꞌ lɨkeꞌ. Kalɨkeꞌ Geraa mwaalyara ayaba “Nemɨresɨra,” kudeꞌ Aazakɨ wawaka aalɨbunya pɨrɨꞌ lɨkaꞌ. Miꞌna kalɨkaꞌ sagaaꞌ aꞌmwera kave mwaalɨna yeꞌ. Kave mwaalɨna kyeꞌ Aazakɨ daꞌ “Gotɨyai tewaanya nemwaaihakebanyɨra.” Dɨvidaasɨ Aazakɨ kwaaka Bɨyazivana wawaka kamwaalaꞌ Gotɨyai gamɨnyɨne tewaanna yaꞌ. Aazakɨ tewaanya mwaalaka simɨnyeꞌ laabaka dɨkeꞌ yɨravaka jɨlɨkyaawaryarɨ wakaka Gotɨyarɨna yɨleyagaala daꞌ. ");
INSERT INTO byr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","33","Dɨvidaasɨ pɨgaaꞌ Avimɨlekɨjɨ gannya aꞌmwe naangelyɨ saraai wawagɨla wɨdahi “Gotɨyai gɨmɨjɨ yuyagaaꞌ mwaimwaai. Nemɨ nyaꞌmwana dɨnaadera,” wɨdahi. Miꞌna kudahi Aazakɨ tɨka munne naanga yavɨgalaꞌ. Mwanyavɨ sagaaꞌ nyaꞌmwana dɨneꞌ. Kadɨneꞌ Avimɨlekɨjɨ aꞌmwe naangelyɨ saraai kaanna kwawagi Aazakɨmɨre wawɨnya wɨdaayadɨvɨsara Aazakɨmɨ wɨdeꞌ “Aalɨbunya pɨrɨꞌ kalɨkɨwo aalya yɨrɨꞌna yɨvanɨꞌ.” Aazakɨ wɨꞌnaka “Nɨmɨjɨ Avimɨlekɨjɨ yagaala tewaanya dɨmwaai,” daka “Aalɨbunya saꞌ Siva dɨdeinyɨra,” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","35","Yɨzoi Etɨyaraavɨrebanna wawaka Bɨyarɨyare garaavaangaꞌ Juthitɨ maarɨna. Nabaai Elonɨmɨre garaavaangaꞌ Baazɨmatɨ maarɨna. Aꞌmwewaai maavewaarɨ kamaaraꞌ Aazakɨmɨjɨ Revekaavɨjɨ sawaarɨ kale wiaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","4","Aazakɨ aꞌmwe nei tɨnna mwanganyɨna, Yɨzorɨ jaka wɨdɨna kyaꞌ Yɨzoi wɨlaabɨna kyaꞌ wɨdaꞌ “Nɨmɨ aꞌmwe neinyɨ maalɨkegaaꞌ balɨdeinyɨ dɨngaka? Naangegaaꞌ balɨdeinyɨ dɨngaka? Mwata mwaryagɨnya dɨmaaꞌ! Yɨꞌdaryawɨnna wawaꞌgɨzɨ yɨkurɨyaawia nyɨbalayaawa! Yɨkurɨyaawia maaraꞌgɨzɨ nɨmɨnyɨne waburyaꞌna mɨwɨta tewaanya dɨvɨraaya! Nɨmɨ miꞌna naꞌmujɨ gɨmɨnyɨne yagaala tewaanyaꞌ gɨthɨdera.” ");
INSERT INTO byr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","17","Yɨzoi yɨkurɨyaawɨhayaꞌnei kaanna kwawaꞌ Revekaaꞌ Jaikopɨmɨ Aazakɨ wɨdakeꞌ aya wɨdaꞌ. Miꞌna wɨdaka wɨdaꞌ “Nɨmɨre dɨwɨjaꞌna ja! Jɨlɨkyaawarya maalɨkewaarɨ memeyawaarɨ dɨmaaꞌdeꞌna nɨmɨ mɨwɨta tewaanya gɨmaamaangerɨne pɨraayɨdera. Kavɨraayaꞌmujɨ gɨmɨ maaraꞌgɨzɨ duzaade. Gamɨ nojɨ yagaala tewaanyaꞌ gɨthathelyɨ.” Sara kudaꞌ Jaikopɨ wɨdaꞌ “Nyɨdaakaangei Yɨzoi kwazaakiꞌnakelyɨ. Nɨmaamaangei awaarimaayainyɨ nyɨmwanganojɨ ‘Jaikopɨ kwaasɨ yɨvanɨka,’ dozɨ yagaala tewaanyaꞌ manyɨjɨ nanyadɨka! Yagaala kayaaꞌnanaangeꞌ nanyɨdathɨka!” Sara kudaꞌ Revekaaꞌ wɨdaꞌ “Yagaala kayaaꞌnanaangeꞌ gɨthozɨ nɨmɨnyɨ nyɨdathesɨ. Nɨmɨresɨra. Saꞌ dɨwɨjaꞌna ja!” Sara kudaꞌ Jaikopɨ sara kyaꞌ mɨwɨta pɨraayɨna yaꞌ. Pɨraayɨna yaka Yɨzore kannyɨla tewaanya maaraka Jaikopɨmɨ marirakuna yaꞌ. Marirakuna yaka memeyavɨ kɨlaakeꞌ asawaarɨ tɨlɨnnyavɨ marabaazɨꞌmakwɨna yaꞌ. Miꞌna yaka Jaikopɨmɨ Aazakɨmɨne wapaaya wɨmaaryaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","29","Wapaaya kumaaryaꞌ Jaikopɨ Aazakɨmyawɨnna wawaka wɨdaꞌ “Nɨmwai!” Miꞌna kudaꞌ Aazakɨ wɨdaꞌ “Nyɨbwaalɨꞌ aaihwaigɨnaꞌ?” “Yɨzoinyɨ gɨmɨre sɨraangeinyɨ gɨmɨ sara nyɨdɨwaanyaꞌ sara yɨwa. Dahaaꞌ nɨmɨre yɨkurɨyaawia dɨnana! Miꞌna naꞌgɨzɨ yagaala tewaanyaꞌ nyɨdatheinyɨ.” Miꞌna kudaꞌ saꞌ Aazakɨ wɨdaꞌ “Yɨkurɨyaawia yaraina yaraina gara tamwaana?” Jaikopɨ wɨdaꞌ “Gotɨyai kanyɨjaawaꞌ tamwengɨ.” Aazakɨ wɨdaꞌ “Davanna dɨvama! Gɨmwanganɨma!” Sara kudaꞌ Jaikopɨ bɨna kyaꞌ Aazakɨ ata mwanganna yaka wɨdaꞌ “Jaikopɨmɨre maanguraayaꞌ guꞌnena gɨmwangamwa. Gɨmɨre asaꞌ Yɨzoreꞌbɨꞌnanyasɨra. Yɨzoigɨ daaka?” Sara kudaꞌ Jaikopɨ wɨdaꞌ “Sahwainyɨra.” Aazakɨ wɨdaꞌ “Nyɨdɨwaanyaꞌ yɨkurɨyaawia nyɨjaama! Nɨmɨ nɨma! Mena naꞌmujɨ yagaala tewaanyaꞌ gɨthɨdero.” Aazakɨ kudaꞌ Jaikopɨna kujaavaꞌ Aazakɨ mɨwɨtajɨ aalya waainɨyasɨ naka wɨdaꞌ “Dava dɨvama! Yɨlaaya marinaka!” Miꞌna kudaꞌ kɨnɨdaai yɨlaaya marinagi. Aazakɨ gamɨre baazɨꞌmaꞌnya kannyɨla tɨrɨnya winnaka yagaala tewaanyaꞌna wɨdɨna “Gɨmɨre baazɨꞌmaꞌnya kannyɨla Gotɨyai wapaaya tewaanya yɨrɨvadɨwakebadaasɨ wawɨdɨrɨnyavɨ winnɨwa. Gotɨyai gɨmɨnyɨne burɨkeꞌ wɨjaavɨna, sɨlɨja wɨjaavɨna, kwaaka tewaanya wɨjaavɨna gyadeigɨnyɨ. Gɨmɨre wawɨnyavɨ tɨka munne naanga gɨryadengɨ. Aꞌmwe pwara gɨmɨnyɨ gɨthaayɨpɨꞌdera yɨmaꞌnapɨjɨ ‘Aꞌmwe naangeigɨ,’ gɨthɨpɨꞌdeigɨnyɨ. Gɨmɨ naangeigɨ jɨmaꞌnadeigɨnyɨ gɨmɨjɨyara maalɨka yɨmaꞌnɨpɨꞌdere. Nabaai gɨmɨjɨyara ‘Aꞌmwe naangeigɨ,’ gɨthɨpɨꞌdeigɨnyɨra. Aꞌmwe pwai yagaala kayaaꞌnanaangeꞌ kagɨthozɨ gannyasɨra. Aꞌmwe pwai yagaala tewaanyaꞌ kagɨthozɨ gannyasɨra,” wɨdaꞌ Aazakɨ. ");
INSERT INTO byr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","40","Aazakɨ kudaꞌ Jaikopɨ wɨna kyaꞌ avaalyagaaꞌ Yɨzoi wapaaya maarɨna yaka bɨna yaka ganɨmaangerɨ wɨdaꞌ “Yaawia gɨmɨnyɨne maaꞌmwe dɨnana! Miꞌna naꞌgɨzɨ yagaala tewaanyaꞌ nyɨdathera.” Sara kudaꞌ ganɨmaangei wɨdaꞌ “Aaihwaigɨnaka?” “Yɨzoinyɨra. Gɨmɨre sɨraangeinyɨra.” Sara kudaꞌ Aazakɨ bɨꞌbɨta wida wɨdaꞌ “Wapaaya aai nyɨjaawaka? Nena wɨdɨwa yagaala tewaanyawo. Sɨnnawɨ yagaala tewaanya miꞌna wɨdena dɨvidaaꞌnyɨ mudɨka wɨja saꞌ aawano.” Mena kudaꞌ Yɨzoi kɨnna daka wɨdaꞌ “Nabaai yagaala tewaanya pɨnɨ nyɨdana!” Saꞌ Aazakɨ wɨdaꞌ “Jɨhwaalaangei kwaasɨ kanyɨdɨwaꞌ wɨdɨwa ‘Gɨmɨ aꞌmwe naangeigɨnyɨ. Jaꞌmwei wabelyɨ. Gɨmɨre kaimɨraayara gamɨreraavɨ maremwaaibɨꞌdere,’ wɨdɨwa. ‘Nabaai gamɨre wawɨnya tewaanna yadengɨ,’ wɨdɨwa.” Sara kudaꞌ Yɨzoi kɨnna maredɨna yaka wɨdaꞌ “Nɨmɨnyɨne yagaala tewaanya pɨrɨꞌna nyɨdana!” Aazakɨ wɨdaꞌ “Kwaaka kayaaꞌnanaangeba burɨka maalɨka yadeva saba dɨmwaaideigɨnyɨ. Gɨmɨnne wapaayanna mala dɨradeigɨnyɨ. Gɨmɨ jɨhwaalaangerɨne duthaayɨdeigɨnyɨ. Saꞌ dɨvidaasɨ yagalyaꞌmakuna jɨtheigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","46","(-)");
INSERT INTO byr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","5"," Jaikopɨ sara kyaꞌ Yɨzore sɨnna tɨka naanga kudavaꞌ daꞌ “Jaikopɨmɨ mala tamɨdeinyɨra.” Yawɨta sara kyaꞌ Revekaaꞌ dara wanganakeꞌ “Yɨzoi Jaikopɨmɨ mala tamadei daaka!” Daka “Jaikopɨmɨ pɨbanna wɨdaasɨma!” daꞌ. Miꞌna daka Aazakɨmɨ wɨdaꞌ “ ‘Yɨzoi aꞌmwe Etɨyawaarɨ maarakeꞌneꞌ Jaikopɨ sara nyadɨka!’ dena gɨthɨwano.” Tɨviꞌna kudaꞌ Aazakɨ Jaikopɨmɨ jaka wɨdɨna yaka yagaala tewaanyaꞌ wɨdaka wɨdɨna “Kainanɨ mwaalyavɨ mamaaꞌdɨnnera! Laivanɨ jaakaangere kaimɨraayaꞌ dɨmaaꞌdeigɨnyɨ. Gotɨyai kaimɨraaya naanga gɨzaavadeigɨnyɨ. Gotɨyai Evɨraamɨmɨ wɨdaꞌ ‘Kwaakeꞌ gɨzaavɨdeinyɨ.’ Wɨdaka kwaaka dava gɨmɨnyɨjɨ gɨmɨre kaimɨraayaraavɨjɨ saihɨrɨne yɨhɨzaavadesɨra.” Aazakɨ miꞌna wɨdɨna kyaꞌ Jaikopɨ kwaaka Aaranɨ sawɨ Laivanɨ mwaalakewɨnna wawaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","9","Yɨzoi sara wɨꞌnaka “Nɨmaamaangei Kainanɨ mwaalyanna ‘Aꞌmwe tewaanya mɨꞌ,’ saꞌbɨta yawɨꞌmwa,” daka Evɨraamɨre gawaalɨꞌ Yɨzɨmelɨmɨre taayaꞌ maaraꞌ. ");
INSERT INTO byr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","22","Jaikopɨ “Kwaaka Aaranɨ sawɨnneinyɨ,” daka kaanna wɨna yakegaaꞌ pɨba se waꞌmwaraka waja yaꞌnyɨna yaka dara wanganakeꞌ “Kɨnnaanya yɨravamakinɨkeꞌ kwaakevɨdaasaꞌ yune sɨgunyavɨnanyaꞌ daaka!” Gotɨyare mamaaya ejelɨyara walaabɨna, yɨlaabɨna yadaapi wanganaꞌ. Sara kwanganaꞌ Gotɨyai wɨdaꞌ “Nɨmɨ Gotɨyainyɨra. Evɨraamɨjɨ Aazakɨjɨ saraai nyuꞌnagi. Kwaaka daꞌ gɨmɨjɨ gɨmɨre kaimɨraayarajɨ yɨhɨzaavɨdesɨ. Gɨmɨre kaimɨraayara kwala naanga yɨmaꞌnapɨjɨ kwaaka davɨ yunebanna mwaaibɨꞌdengɨ. Gɨmɨjɨyaraavɨna aꞌmwe kwaakevakɨ mwaaibɨzaraavɨne tewaanna yɨdeinyɨ. Gɨmɨjɨ wawakwoihɨri dava ayawɨnna yagalaawɨna yakwolyɨ bakadeinaalyɨ. Nɨmɨre yagaalyaꞌ nebwi gɨthɨwa.” Miꞌna kudaꞌ Jaikopɨ dɨkaaꞌna yaka daꞌ “Gotɨyai dava mwaaidɨsɨ myawɨriwana. Davadaasɨ sɨgunyavɨnanyasɨra. Nɨmɨ lɨka yɨwana.” Yɨrɨkeꞌ kavuraꞌ Jaikopɨ daavaka sɨla yɨrɨꞌmata dɨhaihɨsai yawɨtaꞌnei yɨdaꞌna marɨdaakwaꞌ. Marɨdaakuna yaka “Dava Betelɨ (Gotɨyare angeba dɨnɨkesɨ),” daka welivananyaꞌ dɨngɨna yaꞌ Gotɨyarɨna. Sara yaka Gotɨyarɨ wɨdaꞌ “Nɨmɨjɨ kwawakwolyɨ, wapaaya nɨgwɨlalaaka yɨvɨta nyɨjaavaꞌgɨzɨ nɨmware angewɨnna ayawɨnna kanyɨmakabaꞌgɨri gɨmɨrebwi yɨdeinyɨ. Gɨlyɨvɨta ata yuyɨraai kanyɨjaavaꞌgɨzɨ ayawɨ pɨrɨꞌna gɨzaavɨdeinyɨ. Yuyagaaꞌ yuyagaaꞌ pɨrɨꞌna, pɨrɨꞌna gɨzaavɨdeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","14","Jaikopɨ nyɨla bilyɨrɨꞌdevannei Kwaaka Aaranɨna yɨꞌmavaawɨna yaꞌ. Aalɨbunyavɨ jɨlɨkyaawarya kwala naanga mwaaidapɨjɨ wanganaka kaanna bɨna yaka jɨlɨkyaawarya maremwaaidɨvɨsaraavɨ wɨdaꞌ “Aꞌmwe Laivanɨ jawɨꞌmwaava?” “Yo, yawɨꞌmwo. Nabaai garaavaangaꞌ Rasalaꞌ ganɨmaangere sipɨzipɨyajɨ makabɨvanɨkeꞌ,” wɨdeꞌ. Aalɨbunyavɨ sɨlyaꞌ maratangɨrakɨna waꞌdɨꞌnyɨ Jaikopɨ sɨlyaꞌ maarɨna yaka pɨba marakɨna yɨna yaka aalya yɨrɨna, gamɨre sipɨzipɨyangɨna wɨjaavɨna yaꞌ. Miꞌna wɨjaavaka Rasalavɨ ata wɨbwaꞌnaka wɨdaꞌ “Laivanɨ nyaakaangelyɨ.” Sara kudaꞌ Rasalaꞌ gannya angevɨna yarai wɨna yaka ganɨmaangerɨ kudaꞌ kaanyɨveꞌna wɨjɨmaaꞌnyɨna yaka ata wɨbwaꞌnyɨna yaka gannya angevɨna makabaꞌ. Jaikopɨ angevɨ bwina kyaꞌ Laivanɨ wɨdaꞌ “ ‘Nɨmɨreigɨnyɨ,’ nebwi gɨthɨwa.” Tɨviꞌna kudaꞌ Jaikopɨ saba mwaalaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","20","Lawe puꞌ wavɨlaꞌdaaꞌnyɨ Jaikopɨ gyaakaangere wawɨnya yɨna kyaꞌ Laivanɨ wɨdaꞌ “Dahaaꞌ nɨgwɨwawɨnya mivanɨgɨnyajɨ gɨthɨwana. Berɨꞌ gɨzaavɨjɨwano?” Miꞌna kudaꞌ Jaikopɨ wɨdaꞌ “Kwarame dawaai dawaai dawaai daꞌ sagaaꞌ gɨthaayɨdeinyɨra. Nɨmɨ mena kyaꞌmujɨ jɨraavaanga dɨviyaꞌ Rasalavɨ nyɨjaadeigɨnyɨ.” Sara wɨdɨna kyaꞌ “Dɨwaanyaꞌ tewaanyasɨra. Gɨzaavɨdesɨra,” wɨdaꞌ. Savɨdaasɨ Jaikopɨ yɨlaaya yada wawɨnya yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","30","Kwarame dawaai dawaai dawaai daꞌ kwavɨlavaꞌ Jaikopɨ Laivanɨmɨ wɨdaꞌ “Rasalaꞌ nyɨjaama!” Sara kudaꞌ Laivanɨ tɨka munne yɨlɨna yaka saꞌ sawɨsavɨ garaavaanga Lɨyaaꞌ Jaikopɨmɨna wɨjaavaꞌ. Mwanyavɨ Jaikopɨ dara wanganakeꞌ “Aꞌmwe Lɨyaaꞌ damwaalɨꞌ!” Daka Laivanɨmɨna sɨnna tɨka wɨdavaꞌ. Sɨnna tɨka kudavaꞌ Laivanɨ wɨdaꞌ “ ‘Sɨnnawɨ aꞌmwe sɨraangeꞌ wɨjavaana!’ doꞌ sɨmunya nemɨresɨra. Gɨmɨ Lɨyaasɨ sawɨta ata yuyi ata purɨdaasɨ pɨrɨwaai dɨmwaaidera. Mwaalaꞌgɨzɨ sagaaꞌ Rasalaꞌ gɨzaavɨdeꞌna kwarame ata yuyi ata purɨdaasɨ pɨrɨwaala pɨnɨ nɨmɨre wawɨnya nyɨdaayadeigɨnyɨ.” Sara kudaꞌ Jaikopɨ sara yaꞌ. Nabaai Laivanɨ aꞌmwe Sɨlɨpaavɨ wawɨnya wɨdaayadevɨneꞌ garaavaangevɨneꞌ Lɨyaavɨneꞌ wɨjaavɨna, aꞌmwe Bilaavɨ wɨdaayadevɨneꞌ garaavaanga pɨrɨvɨna wɨjaavaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","35","(-)");
INSERT INTO byr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","13"," Lɨyaaꞌ kaimɨraayai sɨraangei Ruvanɨ mɨlaka kaimɨraayai Sɨmɨyanɨ mɨlaka kaimɨraayai Livaai mɨlaka kaimɨraayai Juthai mɨlaꞌ. Rasalaꞌ kaimɨraavɨmaayaꞌ mwaalakeꞌ Jaikopɨmɨne wɨdaayadevɨ Bilaavɨ wɨjaavaꞌ. Miꞌna kujaavaꞌ Bilaaꞌ kaimɨraayaraai mɨlaꞌ. Kamɨlaꞌ Rasalaꞌ “Nɨmɨrelyɨ,” daka sɨraangere yaya Denɨ, dɨviyai Napɨtalaai wɨdaꞌ. Dɨvidaasɨ Lɨyaaꞌ dara wanganakeꞌ “Nɨmɨ kaimɨraaya pɨnɨ mɨlɨdeꞌnyɨ daaka!” Daka wɨdaayadevɨ Sɨlɨpaavɨ Jaikopɨmɨnevɨ wɨjaavaꞌ. Miꞌna kujaavaꞌ Sɨlɨpaaꞌ kaimɨraayaraai mɨlaꞌ. Kamɨlaꞌ Lɨyaaꞌ kɨrɨmɨre yayaꞌ pwai Gethɨ, pwai Azai wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","24","Pɨgaaꞌ Ruvanɨ yɨsɨla maaraka ganaanga Lɨyaavɨ wɨjaavaꞌ. Kujaavaꞌ Rasalaꞌ wɨdaꞌ “Yɨsɨla pɨrɨꞌ nyɨjaama!” Miꞌna kudaꞌ Lɨyaaꞌ wɨdaꞌ “ ‘Ganɨmaangerɨ maaꞌdɨnyaꞌgɨ yɨsɨlaꞌ maarɨma!’ dathɨwaana?” “Yɨsɨla miꞌna nyɨjaavaꞌgɨzɨ sawɨsavɨ nɨmɨre aꞌmwerɨ dɨmaaꞌdera,” wɨdaꞌ Rasalaꞌ. Nyɨla kwalakaꞌ Jaikopɨ gannya angevɨna kulaabaꞌ Lɨyaaꞌ wɨdaꞌ “Nɨmɨre angevɨna wɨlaabɨzaꞌna nɨmɨ gɨmɨnyɨ yɨsɨlanna miꞌna gɨmubɨwa. Naarɨmɨ mwaalaka!” Sara kamwaalagi Lɨyaaꞌ kaimɨraayai Yɨzakaai mɨlaꞌ. Dɨvidaasɨ kaimɨraaya pwai Sevulanɨ mɨlaꞌ. Aayagaasaꞌ taaya Daainaꞌ mɨlaꞌ. Lɨyaaꞌ yuya miꞌna kamɨlaꞌ Gotɨyai Rasalavɨna tewaanna kyaꞌ Rasalaꞌ kaimɨraayai Jozepɨyai mɨlaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","36","Rasalaꞌ Jozepɨyai kamɨlaꞌ Jaikopɨ “Nemɨ sanɨdakana wɨna yawaajɨ nɨnnya angevɨ mwalaana!” kadaꞌ Laivanɨ wɨdɨna “Gɨmɨ dava mwaalaꞌgi wawɨnya ja!” Miꞌna wɨdɨna kyaꞌ Jaikopɨ wɨdaꞌ “Gɨmɨnyɨna gyɨdeigɨnyɨ. Miꞌna gyaꞌmujɨ jɨlɨkyaawarya jaane yuya maarɨdeinyɨ.” Laivanɨ wɨꞌnaka wɨdaꞌ “Tewaanyasɨra.” ");
INSERT INTO byr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","43","Dɨvi Jaikopɨ yɨsarɨkaavɨ dapaina, kɨlaaka woipɨraꞌna yaꞌ. Sara yaka dara wanganakeꞌ “Jɨlɨkyaawarya tewaanya yawakɨmanɨgaꞌ,” daka jɨlɨkyaawarya wanganyaꞌne yɨsarɨkaavɨ marakɨna yaꞌ. Dɨvidaasɨ jɨlɨkyaawarya tewaanya bwaranya jaane mɨleꞌ. Jɨlɨkyaawarya tewaanya jaane yɨmaꞌnyɨna kyeꞌ Jaikopɨ maarɨna yaꞌ. Jɨlɨkyaawarya wabe Laivanɨmɨre mwaaleꞌ. Jaikopɨ gɨlyɨvɨta naangejɨyai mwaalɨna. Gamɨre wɨdaayadɨvɨta naangejɨ jɨlɨkyaawarya naangejɨ mwaalɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","16","Jaikopɨ dara wɨꞌnakeꞌ “Laivanɨmɨre gawaalɨvava ‘Nenɨmaangere gɨlyɨvɨta yuya maaꞌdelyɨra,’ dathɨvanɨgava!” Miꞌna daka nabaai dara wanganakeꞌ “Laivanɨ jɨkurya nyɨvanɨkei daaka!” Sara kadaꞌ Gotɨyai Jaikopɨmɨ wɨdaꞌ “Gɨnnya angewɨnna ayawɨnna dɨwodera. Nɨmɨjɨ wawakadera.” Miꞌna kudaꞌ Jaikopɨ Rasalavɨjɨ Lɨyaavɨjɨ wɨdɨna “Nɨmɨ kɨrɨnɨmaangerɨne wawɨnya naanga yadɨnyainyɨ. Wawɨnaangeinyɨ yadaari gamɨ kwaasɨ nyɨdadelyɨ. Kwaasɨ kanyɨdaꞌ Gotɨyai kɨrɨnɨmaangere jɨlɨkyaawarya kwalaalyara nyɨjaawaꞌdɨꞌ. Nabaai Gotɨyai nyɨdɨwaꞌ ‘Gɨnnya angewɨnna dɨwona!’ ” Sara wɨdɨna kyaꞌ Rasalasɨ Lɨyaasɨ sawaai wɨdahi “Gotɨyai sara gɨthɨwakeꞌ sara jɨ!” ");
INSERT INTO byr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","21","Miꞌna kudahi Jaikopɨ “Nɨmaamaanga Aazakɨ Kainanɨ mwaalyaryawɨnna wɨma!” daka gannya balaangengɨ gannya kaimɨraayangɨ jɨlɨkyaawaryangɨ maarɨna yaka wawaꞌ. Saꞌ Rasalaꞌ ganɨmaangere sɨvuyaꞌbɨsaꞌ kuka maarɨna. Kuka maarɨna kyaꞌ Laivanɨ navɨka mwaalaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","42","Laivanɨ “Jaikopɨ kaanna wɨna kyɨwaꞌdɨꞌ,” wɨꞌnaka Jaikopɨmɨ mɨdɨnna yaꞌ. Kaanna wɨna wɨna, sawɨta ati ata purɨdaasɨ pwaraai kajɨnnaꞌ tusavɨ mɨjaahalaka wɨdaꞌ “Baarɨꞌ yɨwaana? Kwaasɨ baaꞌna yagɨna nyɨraavaangewaarɨ wɨla yɨrakɨnɨkewaarɨ baaꞌna makwasɨwaabɨna? Nabaai nɨmɨre sɨvuyaꞌbɨsaꞌ kuka baaꞌna maryawalyaadɨna? Lɨka beꞌna yulyaragɨna wɨwaꞌdɨ? ‘Nɨmɨ Jaikopɨmɨ mala tamɨma!’ dena sawɨsavɨ waja yaꞌnyawaaihe. Gɨmɨre Gotɨyai waja nyɨjawaalɨꞌ ‘Jaikopɨmɨna kave duthana!’ ” Sara kudaꞌ Jaikopɨ wɨdɨna “Gɨmɨre sɨvuyaꞌbɨsaꞌ kuka mamaryɨwaꞌde. Lɨka yulyarena dɨwaꞌde ‘Laivanɨ garaavaangewaarɨna nanyɨpalamaaradɨka!’ ” Miꞌna kudaꞌ Laivanɨ Jaikopɨmɨre gɨlyɨvɨsangɨ tɨnna wanganaka saꞌ gamɨre sɨvuyaꞌbɨsaꞌ Rasalaꞌ lɨka yulyakakeꞌ mabɨrɨmaaryaꞌ. Mabɨrɨmaaryakegaaꞌ Jaikopɨ Laivanɨmɨ maanga wɨdaꞌ “Baaꞌneka! Gɨmɨre wawɨnya yadaari gɨmɨre jɨlɨkyaawarya kwala naanga yɨmaꞌnyɨna kyeꞌ nɨmɨ mamaranyena. Gɨmɨre jɨlɨkyaawarya kunewɨ bɨrena bɨrena nɨmɨre gɨzaave. Saꞌ yuyagaaꞌ nɨmɨnyɨne kwaasɨ yagɨ. Gɨmɨ kwaasɨ kyagɨ nɨmɨre Gotɨyai nyɨgaimwagaka sawɨsavɨ mayagaala gɨzawaalɨꞌ,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","55","Laivanɨ wɨdaꞌ “Nyɨraavaangewaalyɨ, aataasɨ, aataravajɨ nɨmɨre jɨlɨkyaawaryajɨ mwaaihaꞌ. Saꞌ baarɨꞌ yɨjɨwa?” Sara kudaꞌ Jaikopɨjɨ Laivanɨjɨ yagaala naanga kadɨnagi Laivanɨ wɨdaꞌ “Naarɨmɨ geva geva kamwaalakwolyɨ Gotɨyai nehwanganadelyɨra. Nyɨraavaangewaarɨna kayaaꞌna kamaremwaalaꞌgɨzɨ Gotɨyai gwanganadeigɨnyɨra. Gɨmɨ aꞌmwe pɨrɨvɨ kamaaraꞌgɨzɨ gwanganadelyɨra.” Miꞌna kudaꞌ Jaikopɨjɨyara sɨla marakɨna kyeꞌ Laivanɨ wɨdaꞌ “Sɨla naanga tɨhwawɨnya maramadakɨwaasaꞌ gɨmɨnyɨna malyaꞌna nɨmɨ mwavɨlayɨ yɨdeinyɨ. Nabaai nɨmɨnyɨna malyaꞌna gɨmɨ mwavɨlayɨ jɨtheigɨnyɨra. Gotɨyarɨna gɨthɨweꞌ nebulyasɨ.” Sara kudaꞌ Jaikopɨ wɨdaꞌ, “Sɨla naanga mwavɨlayɨ yɨdeinyɨ malyaꞌnesɨ.” Jaikopɨ nebwina wɨdaka jɨlɨkyaawaryarɨ Gotɨyarɨna tamaka yɨdɨka yɨna kyaꞌ Jaikopɨjɨ Laivanɨjɨ nagi. Yɨrɨkeꞌ kavuraꞌ Laivanɨ se waꞌmwarakei dɨkaaꞌna yaka garaavaangewaarɨjɨ kɨrɨmɨre kaimɨraayangɨjɨ sangɨ yɨlaaya yɨgalaꞌ. Yɨlaaya yɨgalaka yagaala tewaanya wɨdaka gannya angewɨnna wawaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","12","Jaikopɨ kaanna wɨna yakegaaꞌ dara wanganakeꞌ “Nɨmɨjɨ Gotɨyare mamaayara ejelɨyarajɨ mwaaiho.” Sara daka Jaikopɨ sɨhumale yaasadɨvɨsaraavɨ gathaakaanga Yɨzorɨna wɨdaasaꞌ. Yaasadɨvɨsara kaanna waweva Yɨzorɨ wɨdeꞌ “Jaikopɨ gɨmɨnyawɨnna bɨvanɨꞌ. Gamɨre gɨlyɨvɨta naanga warɨka.” Yaasadɨvɨsara Yɨzorɨ wɨꞌneva kaanna bɨna yeva Jaikopɨmɨ wɨdeꞌ “Yɨzolyɨ aꞌmwe kwala naangerajɨ sara bɨvanɨgava.” Miꞌna kudeꞌ Jaikopɨ lɨka yaka Gotɨyarɨ wɨdaꞌ “Gɨhaimwagɨdeinyɨ nyɨdahɨnyaꞌ ‘Gɨmɨre kaimɨraaya kwala naanga yɨmaꞌnɨpɨꞌdere.’ Nyɨgaimwadɨnyaigɨnyɨ. Nabaai dahaaꞌ nɨmɨre gɨlyɨvɨta naanga warɨꞌ. ‘Gɨnnya angewɨnna dɨwodera,’ nyɨdahɨnyaꞌ saꞌ nyɨdaakaanga Yɨzorɨna nɨmɨ lɨka yena ‘Yɨzoi naneramakadɨka!’ dena ‘Nyɨgaimwana!’ gɨthɨwa.” ");
INSERT INTO byr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","21","“Yɨzorɨ sɨnna tɨka nudavadɨꞌ! Jɨlɨkyaawarya naanga yanga wɨjaavɨma!” daka Jaikopɨ Yɨzorɨne jɨlɨkyaawaryangɨ maryaasaka gamɨ dɨvidaaꞌnyɨ mɨdɨnaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","32","Jaikopɨ gamɨrengɨ kudaasaꞌ kumɨza gamɨre gɨlyɨvɨtajɨ Aalya Javokɨ maragaꞌmakuna. Maragaꞌmakuna kyaꞌ Jaikopɨ gave kwai mwaalaꞌ. Sawɨsavɨ pwai baka Jaikopɨmɨ asangɨ galalɨmwanna yaꞌ. Mala tannadaakɨri yɨrɨka purɨna kyaꞌ pwai Jaikopɨmɨ wɨdaꞌ “Nyɨmakwaasa!” Sara kudaꞌ Jaikopɨ wɨdaꞌ “Yagaala tewaanyaꞌ nyɨdaꞌgɨzɨ dɨwodera.” Pwai wɨdaꞌ “Gɨnnya yayaꞌ Jaikopɨ (kwaasɨ yadei) saꞌ Gotɨyarɨjɨ aꞌmweraavɨjɨ yagaala bazɨwaimanaawɨgɨnyaigɨ, malyaꞌ gɨmɨnna dathɨvalaradɨnyaigɨ, gɨnnya yaya mudɨkeꞌ Yɨzɨrelɨmo.” Jaikopɨ wɨdaꞌ “Gotɨyarɨ wanganena kwaihwaainakeinyɨ mwaaimwa.” Nyɨla bilaawɨna yadaaꞌnyɨ Jaikopɨ tuꞌmudɨka wɨdaꞌdaaꞌnyɨ yɨgala yɨgala kaanya wawaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","20","Jaikopɨ dara wanganakeꞌ “Yɨzolyɨ gamɨre aꞌmwerajɨ sara jɨnɨgava!” Daka gannyangɨ wavɨlaꞌna yaꞌ. Wavɨlaꞌna kyaꞌ Lɨyaasɨ Rasalasɨ kaimɨraayajɨ aꞌmwe wɨdaayadisawaalyɨ sa mɨdɨnna yeꞌ. Mɨdɨnna kyeꞌ Jaikopɨ gathaakaangeryawɨnna bɨna. Bɨna kyaꞌ Yɨzoi tewaanya mwaalaka “Jaikopɨjɨ ata bwaꞌnaka!” daka kaanyɨveꞌna bɨna kyaꞌ kɨnna maredɨnagi. Miꞌna kamaredɨnagi Jaikopɨmɨva bɨna yeva Yɨzorɨna “Ata bwaꞌnaana!” dɨna yeva ata bwaꞌnyɨna yeꞌ. Tɨviꞌna bwaꞌnyɨna kyeꞌ Yɨzoi wɨdaꞌ “Jɨlɨkyaawarya nɨmɨnyɨne makabɨwaanya waramaryana!” Sara kudaꞌ Jaikopɨ “Nɨmɨ kuneinyɨ daaka!” kudaꞌ Yɨzoi maaraꞌ. Yɨzoi miꞌna maaraka wɨdaꞌ “Nemɨjɨ sarɨmɨjɨ sanna kaanyaana!” Sara kudaꞌ Jaikopɨ wɨdaꞌ “Nɨmɨre jɨlɨkyaawaryajɨ nɨmɨre kaimɨraayajɨ kave kave wɨna yɨna yaadennera.” Tɨviꞌna kudaꞌ Yɨzolyɨ gannya wɨdaayadɨvɨsarajɨ sara Jaikopɨ yagalyaꞌmaꞌna yeva Kwaaka Sɨyaana waweꞌ. Kaanna kwaweꞌ angeba Sekɨmɨ Kwaaka Kainanɨ mannɨkebanna yɨꞌmavaawɨna yaka kwaaka mubaka saba mwaalaꞌ. Miꞌna mwaalaka Yɨzɨrelɨ Gotɨyarɨne simɨnyeꞌ lɨvalaabaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","5","Lɨyaavɨre taayaꞌ Daainaꞌ “Angeba Sekɨmɨ mwaalyangɨ angirɨꞌmaata yɨma!” daka kaanna wɨna yaꞌ. Anga saba Aꞌmwe Aamo maremwaaida mwaalaꞌ. Aꞌmwe sare gawaalɨꞌ Sekɨmɨ Daainavɨ wanganaka “Sɨdɨraaya tewaanyaꞌ maaꞌmujava,” yawɨꞌna. Sara yawɨꞌna yaka ata lɨmwanna yaꞌ. Ata lɨmwanna yaka Sekɨmɨ ganɨmaangerɨ wɨdaꞌ “Sɨdɨraaya daꞌ nɨmɨre aꞌmwevɨna ganɨmaangerɨ duthana! ‘Gɨmɨre taayaꞌ nɨmɨre mɨgɨnyarɨneꞌ nyɨjaama!’ ” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","31","Jaikopɨ dara wɨꞌnakeꞌ “Sekɨmɨ nɨmɨre taayaꞌ ata lɨmwanna jɨwaka!” Dɨna kyaꞌ gawaalɨvava pɨba yɨbwaꞌnadapɨjɨ navɨka mwaalaꞌ. Jɨlɨkyaawarya maremwaaidɨvɨsara gawaalɨvava bɨna yeva kuꞌneꞌ sɨnna tɨka naanga wɨdavaꞌ. Sɨnna tɨka kudavaꞌ saꞌ Aamo Jaikopɨmɨre gawaalɨvavaavɨ wɨdaꞌ “Sekɨmɨ nyɨbwaalɨvɨne Taaya Daainaꞌ nyɨjaama! Gannya aꞌmweꞌ maaradelyɨ. Sarɨmɨ yagaala sara nyɨjideꞌ sara yɨhɨzaavɨdesɨra.” Miꞌna kudaꞌ Jaikopɨmɨre gawaalɨvava kwaasɨ wɨdɨna “Nemɨ yuyaina kɨlaaka pɨkarya neyɨnɨkeinera. Sarɨmɨ kɨlaaka pɨkarya kadaꞌnapɨjɨ Daainaꞌ Sekɨmɨmɨneꞌ yɨhɨzavaadesɨra.” Sara wɨdɨna kyeꞌ Aamojɨ Sekɨmɨ gawaalɨsɨ saraai yɨlaaya yagi. Kɨrɨnnya angewɨnna wawagɨla kɨrɨmɨre aꞌmweraavɨ wɨdahi “Jaikopɨmɨre gawaalɨvava sara nehɨthɨwaasaꞌ sara yaana! Dɨvidaasɨ Jaikopɨmɨre gɨlyɨvɨsa maraadengɨra.” Sara dɨneva angeba Sekɨmɨ mwaalyara kunnya kɨlaaka pɨkarya daꞌneꞌ. Kadaꞌneꞌ kɨlaaka daanga wɨvɨdaaꞌnyɨ Daainavɨre gyaꞌmweraai Sɨmɨyanɨ Livaai saraai wɨlaabahɨla Sekɨmɨ mwaalyaraavɨ tamakɨna yagi. Tamakɨna kyagi Jaikopɨmɨ gawaalɨvava beva Sekɨmɨmɨre angevɨdaasɨ Daainaꞌ makuna yeꞌ. Nabaai aꞌmwejɨ kaimɨraayajɨ Sekɨmɨ mwaalyaraavɨre gɨlyɨvɨsajɨ makwaweꞌ. Jaikopɨ aꞌmwe pwaraavɨna lɨka yaka gawaalɨvavaavɨ mayagaala wɨdɨna. Mayagaala wɨdɨna kyaꞌ “Sekɨmɨ neyaꞌmwevɨ kayaaꞌnanaanga yakelyɨra,” wɨdeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","8","Gawaalɨvava sara kyeꞌ Gotɨyai Jaikopɨmɨ wɨdaꞌ “Betelɨ sawɨnna dɨmwaaidera. Mwaalaꞌgɨzɨ nɨmɨnyɨne simɨnyeꞌ dɨlɨvalaama!” Miꞌna kudaꞌ Jaikopɨ gamɨrebadaaꞌnyaraavɨ wɨdaꞌ “Sarɨmɨre sɨvuya yuya sabɨsa dɨmarasɨꞌnyɨla! Sarɨmɨre kuryara tewaanyara mwaaibɨka! Nabaai kɨlaakejɨka gɨrɨkaꞌnana aalya dɨzɨnyɨla! Aalya jɨnapɨjɨ kwaabɨhannya baazɨꞌmaꞌnya tewaanya yaaka dakyɨla! Betelɨ sawɨnna nemɨ kaanyaana! Saba Gotɨyai nɨmɨjɨ mwaaiderɨna nɨmɨ simɨnyeꞌ lɨvalaabɨdera!” Jaikopɨ sara wɨdɨna yakeꞌ gamɨjɨyara sara yeꞌ. Miꞌna kyeꞌ wodaapɨjɨ Gotɨyai aꞌmwe pwara yuyaraavɨ Jaikopɨjɨyaraavɨna, “Sarɨmɨ aꞌmwe saraavɨ mipɨnera!” kadaꞌ aꞌmwe yuyara lɨka yɨna yeꞌ. Jaikopɨ Betelɨ mwaalaka Gotɨyarɨna yɨleyagaala wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","15","Jaikopɨ Gotɨyai yayaꞌ Yɨzɨrelɨ woꞌnɨkei dara wanganakeꞌ “Gotɨyai damwaalɨꞌ!” Kadaꞌ Gotɨyai wɨdaꞌ “Nɨmɨ Gotɨya dɨragɨnyainyɨ. Gɨmɨre kaimɨraavɨzɨmya kwala naanga yɨmaꞌnyɨna yɨpɨꞌdengɨ. Gɨmɨre kaimɨraavɨzɨmya pwara aꞌmwe naanga yɨmaꞌnɨpɨꞌderera. Kwaaka Evɨraamɨjɨ Aazakɨjɨ saraarɨna wɨjaaveba gɨmɨjɨ gɨmɨre kaimɨraavɨzɨmyajɨ sangyɨhɨrɨna yɨhɨzaavɨnɨkeꞌ.” Sara kudaꞌ Jaikopɨ sɨla naangei daaꞌdɨꞌnyɨyaba Gotɨyarɨna welɨyaꞌ dɨngɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","26","Betelɨ sabadaasa wodaapɨjɨ Rasalaꞌ kaimalei mɨlaka balaꞌ. Kabalaꞌ sagaaꞌ Jaikopɨ kaimɨraayarɨna yayaꞌ Bejaminɨ woꞌnaꞌ. Jaikopɨ kale wiadaasɨ Betɨlemɨ sangineba Rasalaꞌ wakaka kwaaka saba mwaalɨna. Saba mwaalɨna yadɨsɨ Ruvanɨ ganɨmaangere balaanga Bilaavɨ ata lɨmwanna kyaꞌ Jaikopɨ sara yawɨraꞌ. Jaikopɨmɨre gawaalɨvaanga sɨvɨlɨraai ata purɨdaasɨ pwaraalyara yuyara mwaaleꞌ. ");
INSERT INTO byr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","29","Angeba Maamɨre mwaalyai Jaikopɨmɨre ganɨmaangei Aazakɨ mwaaidɨsɨ Jaikopɨ baꞌ. Aazakɨ aꞌmwe nei kwarame naanga 180 kwavɨlavaꞌ balaꞌ. Kabalaꞌ gawaalɨvaangeraai Yɨzolyɨ Jaikopɨjɨ saraai wakagi. ");
INSERT INTO byr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","43","Yɨzolyɨ Jaikopɨjɨ saraare jɨlɨkyaawarya mwaaidapɨjɨ kumɨre tɨka munne maalɨka waꞌdɨsɨ Yɨzoi gannya balaangejɨ kaimɨraayajɨ jɨlɨkyaawaryajɨ makuna yaka Sɨyaa mugunyavɨ maremwaalaꞌ. Maremwaalaka Yɨthomɨyaraavɨ ganɨmaangei yɨmaꞌnaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","4","Jaikopɨ Kwaaka Kainanɨ mwaalakegaaꞌ Jozepɨyarɨ kwarame atɨraai sɨvɨla pwi yuya yaka sɨvɨla purɨdaasɨ pwaraaina kwavɨlavaꞌ sagaaꞌ mwaalaꞌ. Kamwaalaꞌ Jozepɨyadaraka sipɨzipɨya yɨꞌdɨvaidɨvɨꞌ mwaaleꞌ. Jozepɨyare ganaangeꞌ maarakegaaꞌ Yɨzɨrelɨ aꞌmwe nei mwaalakeꞌna Jozepɨyarɨ yɨlaaya naanga marina yaꞌ. Gawaalɨvava pwaraavɨ yɨlaaya maalɨka maryaꞌ. Yɨlaaya naanga maryaka Jaikopɨ Jozepɨyarɨna baazɨꞌmaꞌnya tewaanyaꞌ yavɨkaryaꞌ. Jozepɨyai gaverɨna kyavɨkaryaꞌ gyaꞌmwera “Maraajava kale newɨlaꞌmwaka,” kadeꞌ sɨnna tɨka davɨna wiaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","11","Jozepɨyai waja yaꞌnyɨna yaka gyaꞌmweraavɨ “Nɨmɨre waja yɨvanɨgeꞌ yɨhɨzɨwaakɨ,” wɨdaꞌ. “Wawɨnyavɨ witɨya lɨlaajabɨsa maramurɨtaꞌna yadaawojɨ nɨmɨre witɨpwɨyaꞌ dɨkavedaaꞌna yaka daavɨna yadɨsɨ sarɨmɨre witɨpwɨya dɨkavedaaꞌna gɨꞌduꞌna yaka ‘Aꞌmwe naangeigɨnyɨ,’ ” wɨdaꞌ. Jozepɨyai sara kudaꞌ gyaꞌmwera “Kwaasɨ nedɨwaꞌ,” deva “Nemɨnyɨna dɨnemaremwaaijɨwaa?” wɨdeꞌ. Dɨvi pɨgaaꞌ Jozepɨyai waja mudɨka pɨrɨꞌ yaꞌnaka ganɨmaangelyɨ gyaꞌmwerajɨ saraavɨ wɨjɨwaakɨna yaꞌ. “Nyɨlyalyɨ lawelyɨ sɨlɨngaamɨnya sɨvɨlɨraai ata purɨdaasɨ pwaina sara nɨmɨnyɨna gɨꞌduraꞌna yawaaihava.” Miꞌna kudaꞌ Jaikopɨ wɨdaꞌ “Baaꞌna dɨwaana? ‘Nɨmaamaangelyɨ nyɨnaangesɨ nyaꞌmwerajɨ sa nɨmɨnyɨna gɨꞌduꞌna yɨpɨꞌdera,’ dathɨwaana?” wɨdaꞌ. Jozepɨyare yagaalaꞌna gyaꞌmwera sɨnna tɨka wɨdaꞌdaasɨ ganɨmaangei kave yawɨraꞌ. ");
INSERT INTO byr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","17","Kwaaka Sekɨmɨ Jaikopɨmɨre gawaalɨvava jɨlɨkyaawarya yɨꞌdɨvaidaapi Yɨzɨrelɨ Jozepɨyarɨ “Jaꞌmwera tewaanya damwaaihava?” wɨdaka wɨdaasaꞌ. Kudaasaꞌ Jozepɨyai kaanna kaanna Sekɨmɨ sawɨnna baꞌ. Miꞌna baka dara wanganakeꞌ “Weꞌ, nyaꞌmwera pwara mamwaalyɨjɨhava!” Daka wanganamaryɨna. Wanganamaryɨna yadaasɨ aꞌmwe pwai wanganaka wɨdaꞌ “Nɨmɨ jaꞌmweraavɨ wɨꞌnɨwaꞌde ‘Kwaaka Dothanɨ sabanna kaanyaana!’ dɨdaapi.” Sara kudaꞌ Jozepɨyai kaanna wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","24","Badaaꞌnyɨ Jozepɨyarɨ gyaꞌmwera wanganeva dɨneꞌ “Waja yadei yɨnɨkerɨ tamakaana! Tamakawaajɨ ‘Kavɨjɨlɨkei tamakɨwakelyɨra,’ wɨdaathera. Tamakawaajɨ ‘Gamɨre waja nebulyaꞌ daaka!’ daatheꞌna,” dɨneꞌ. Kadɨneꞌ Ruvanɨ sɨraangei “Jozepɨyarɨ yɨvalɨma!” daka “Maramaki jide. Kaviꞌnɨnnyavɨ marirakɨna jidelyɨra,” wɨdaꞌ. Tɨviꞌna kudaꞌ Jozepɨyai yɨꞌmavaawɨna kyaꞌ lɨmwanna yeva gannya baazɨꞌmaꞌnya tewaanyaꞌ yɨraipurasɨꞌna yeva kaviꞌnɨnna kunevɨ yɨrakeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","30","Jozepɨyai kaviꞌnɨnnyavɨ wɨlaꞌdɨsɨ gyaꞌmwera wapaaya nadaapi Mithɨyanɨ mwaalyara badaapi Juthai gyaꞌmweraavɨ wɨdaꞌ “Neyaꞌmwe Jozepɨyarɨna aꞌmwe saraavɨne mubaana! Nennya neyaꞌmweryaba maramakaannera!” Sara kudaꞌ kaviꞌnɨnnyavɨdaasɨ Jozepɨyarɨ wɨlyabaalyɨ marayɨꞌdɨvaina yeva maramwagiꞌnamaaꞌna yeva kinaaya ata sɨvɨlɨraaina mubeꞌ. Kamubeꞌ Mithɨyanɨ mwaalyara Kwaaka Yɨzɨpɨna makuna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","36","Jozepɨyarɨ gyaꞌmwera jɨlɨkyaawaryai tameva gamɨre tawe maareva Jozepɨyare baazɨꞌmaꞌnyaꞌ tawevɨ maradɨvaina. Maradɨvaina yeva kuvɨnɨmaangerɨ “Baazɨꞌmaꞌnya daꞌ yakɨnɨkeꞌ maaꞌmwosɨ. Jɨwaalɨvaangereꞌ daaka?” wɨdaawɨna yeꞌ. Wɨdaawɨna kyeꞌ Jaikopɨ wanganaka wɨdaꞌ “Yo. Nyɨbwaalɨvaangere baazɨꞌmaꞌnyasɨ. Kavɨjɨlɨkei dawakɨwakerɨnera.” Sara kudaꞌ kale naanga wiadaasɨ Jozepɨyarɨna kɨnna naanga bazɨwɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","30","Sagaaꞌ Juthai Kainanɨ mwaalyaꞌ kamaaraꞌ gannya aꞌmweꞌ kaimɨraaya daraai dai mɨlaꞌ. Aꞌmwe Ei, sɨraangei Taimaaꞌ kwala maaraꞌ. Kamaaraꞌ gamɨrebwi kayaaꞌnanaangebwi kyaꞌ Gotɨyai “Gamɨ balyaꞌnegaaꞌ wakɨdeinyɨra,” dɨnɨkeꞌna Ei balaꞌ. Kabalaꞌ Juthai kutabanyai Wonanɨmɨ wɨdaꞌ “Aꞌmwe Taimaaꞌ dɨmaaꞌ!” Sara kudaꞌ maarɨna yaka “Kaimɨraayanna waramaryana!” daka kayaaꞌna yaꞌ. Kayaaꞌna yakeꞌna Gotɨyai dɨna “Balyaꞌnegaaꞌ wakɨdeinyɨ.” Miꞌna dɨnɨkevɨ Wonanɨ balɨna yaꞌ. Kabalaꞌ Juthai Taimaavɨ wɨdaꞌ “Navɨka dɨmwaala! Aꞌmwe pwarɨ mamaaꞌnɨnnera! Gɨmaamaangeryawɨnna kaanna wɨna jɨ! Saba dɨmwaai! Nyɨbwaalɨꞌ aaya wɨryaakei Silaa naanga gɨrina kyojɨ gamɨzarɨ dɨmaaꞌnana!” Wɨdɨna kyaꞌ Taimaaꞌ kaanna wɨna yaꞌ. Saꞌ Silaa naanga gɨrina kyaꞌ Juthai “Nyɨbwaalɨvaanga dai gannya gyaꞌmweraalyɨ nabaai nabaladɨka!” daka Silaamɨ “Taimaaꞌ dɨmaaꞌ!” mujaꞌ. Yagaala mujɨ yaka mwaalɨna yakere balaangeꞌ balɨna yaꞌ. Balɨna kyaꞌ Taimaaꞌ kwaasɨ kyaꞌ “Juthai Taimaavɨ ata lɨmwamwaka,” dɨnyɨna yeꞌ. Dɨnyɨna kyeꞌ Taimaaꞌ kaimɨraayaraai pwaraai avaalyagaaꞌ maarɨna yaꞌ. Maarɨna kyaꞌ “Sɨraangei Perezɨ, dɨvidaasai Jeraa,” woꞌnaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","5","Kwaaka Yɨzɨpɨna Mithɨyanɨ mwaalyara Jozepɨyarɨ makuna yeva Aꞌmwe Potipaarɨna mubyeꞌ. Kwaaka Yɨzɨpɨ saba maremwaalakei Peroyalyɨra. Potipaai Peroyare aꞌmwe naangelyɨra. Gotɨyai Jozepɨyarɨ wɨgaimwanna yada Jozepɨyai gannya wawɨnya nayaa yɨna yaꞌ. Nayaa yɨna yadaasɨ Potipaai dara wanganakeꞌ “Gamɨre wawɨnya tewaanya jɨvanɨka!” Sara daka gannya angasɨ gannya gɨlyɨvɨsajɨ maremwaaiderɨ wɨmwaaihaꞌ. Wɨmwaaihɨna kyaꞌ Gotɨyai Potipaarɨna tewaanna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","9","Jozepɨyai tewaanyai angevɨ wɨlaꞌdɨsɨ Potipaare aꞌmweꞌ “Tewaanyarɨna maarɨma!” daka wɨdaꞌ “Aꞌmwaagaigɨ, avaanna wɨlakadeꞌnanyɨ.” Sara kudaꞌ Jozepɨyai “Aala,” wɨdɨna yaꞌ. “Potipaai gannya gɨlyɨvɨsa maremwaaina yadɨnyainyɨ nyɨmwaaihɨna yaꞌ. Gamɨreꞌgɨnyɨra. Nɨmɨreꞌgɨ daaka! Sara nɨmɨ myɨwɨnera! Sabwi kyaꞌmujɨ Gotɨyai nɨmɨnyɨna sɨmunya kayaaꞌna nanyawɨradɨka!” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","23","Gazagaasagaaꞌ Potipaare aꞌmweꞌ sana sana wɨdadeꞌ Jozepɨyai “Aala,” sara wɨdaꞌ. Pɨgaaꞌ sara wɨdakei “Nɨmɨre wawɨnya yɨma!” daka angevɨ wɨlaꞌna yaꞌ. Wɨlaꞌna yadɨsɨ Potipaare aꞌmwe gaveꞌ mwaalaka gamɨre baazɨꞌmaꞌnyavɨ lɨmwanna yaka “Kwala nyɨmaaꞌ!” wɨdaꞌ. Sara yaka sara wɨdɨna kyaꞌ Jozepɨyai yɨraipɨvalakɨna yaka lɨkaanya wɨna yaꞌ. Lɨkaanya wɨna kyaꞌ Potipaare aꞌmweꞌ sɨnna tɨka kudavaꞌ wawɨnya wɨdaayadɨvɨsaraavɨ jaka wɨdɨna yaꞌ. “Yɨvɨruyarajɨyai sai kwayagaala nyɨdɨvanɨꞌ. Nɨmɨ ‘Aaka, aaka,’ dɨweꞌnyɨ gamɨ lɨkaanya wɨna yɨwaꞌ. Danganyɨla! Gamɨre baazɨꞌmaꞌnyaꞌ warɨkaagavaakana!” wɨdaꞌ. Sara wɨdaka navɨka mwaalaꞌ. Potipaai gannya angevɨ wɨlaabaka gannya aꞌmweꞌ wɨdakeꞌ kwɨꞌnaꞌ sɨnna tɨka davɨna wiaꞌ. Davɨna kwiaꞌ Jozepɨyarɨ kalavuzavɨ wɨmwaaihɨna yaꞌ. Wɨmwaaihɨna kyaꞌ Jozepɨyai wɨlaꞌdɨsɨ Gotɨyai baihanaꞌdɨsɨ kalavuzavɨ damei Jozepɨyarɨ tewaanya yaꞌ. “Kalavuza mwaaidɨvɨsara pwaraavɨ dɨmaremwaaideigɨnyɨ,” Jozepɨyarɨ wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","4","Jozepɨyai kalavuzavɨ mwaaidɨsɨyagaaꞌ pɨgaaꞌ gamɨre wawɨnya wɨdaayadisaraarɨna Aꞌmwe Pero sɨnna tɨka davɨna kwiaꞌ kalavuzavɨ wɨmwaaihɨna yaꞌ. Aꞌmwe pwai Peroyare wapaayajɨ aalyasɨ wɨmaarina yadei, yɨ aꞌmwe pwai Peroyare gɨrɨkula yɨdɨka yadei saraalyɨ Jozepɨyalyɨ kalavuzavɨ mwaaleꞌ. ");
INSERT INTO byr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","19","Aꞌmwe pwaraai sawɨsavɨ waja yɨna yagi. Waja yɨna kyagi mwanyavɨ Jozepɨyai wɨlaabɨna kyaꞌ jɨkurɨna mwaalɨna yagɨla “Sawɨsavɨ naarɨmɨ waja yaꞌnyawaaiholyainaalyɨra. Waja bewaja yɨvanɨgolyaꞌna aai nehɨzɨwaakajɨwaka?” wɨdahi. Sara kudahi Jozepɨyai “Nɨmɨre Gotɨyai waja yawɨꞌdelyɨ. Kɨrɨmɨre waja nyɨji! Gotɨyai nyɨjɨwaakadeinyɨ,” wɨdaꞌ. Aꞌmwe pwai Peroyare wapaaya wɨmaarina yadei gannya waja Jozepɨyarɨ wɨdaꞌ “Gɨraipɨwɨla taanya dawaai daꞌ waꞌdɨsɨ nɨmɨ wangamwa. Wangadaari purɨrya yɨꞌnadaasɨ wanganyawaaiheꞌ dahaaꞌ mya mena yimwakeꞌ wangamwa. Mena kyimwaꞌ Peroyare gulyavɨ maramaꞌmwagikɨna yena wɨjaavɨna yɨwana.” Miꞌna kudaꞌ Jozepɨyai wɨdɨna “Waja saꞌ gɨzɨwaakɨ! Taanya dawaai dasaꞌ sawɨta daryaai darɨꞌ saꞌbɨsasɨra. Sawɨta daryaai darɨꞌ kajɨnnojɨ Pero ‘Nɨmɨre wapaaya dɨnyɨmaryaama! Ayaꞌ jɨthera,’ gɨthathera. Gɨmɨ sara yaꞌgɨzɨ nɨmɨnyɨna jawɨꞌdeigɨnyɨ. Yawɨraꞌgɨzɨ ‘Jozepɨyai kayaaꞌnanyaꞌ myakerɨ kalavuzavɨ wɨmwaaihava,’ duthathera.” wɨdɨna. Aꞌmwe pwai Peroyare gɨrɨkula yɨdɨka yadei sara wɨꞌnaka Jozepɨyarɨ wɨdaꞌ “Nabaai nɨmɨ waja yaꞌnyawaaihe. Soigɨlya dawaai daꞌ kinya yɨlamarina yɨvanɨgeinyɨ. Soigɨlya aaya aꞌbanyavɨ gɨrɨkula ge ge mihɨnɨke yusara gɨrɨkula dapanadaapi baihanakeinyɨ,” wɨdaꞌ. Tɨviꞌna kudaꞌ Jozepɨyai “Gɨmɨre wajaꞌ gɨzɨwaakɨ! Soigɨlya akwalamwai sawɨta daryaai darɨꞌ saꞌbɨsasɨra. Sawɨta daryaai darɨꞌ kagɨzɨnnojɨ Peroyai yɨsarɨ wɨla tɨdavojɨ gɨmɨnyɨ pɨgaaꞌ wɨla kamaragɨrɨdavojɨ yusara gɨnɨpɨꞌdeigɨnyɨ,” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","23","Sawɨta daryaai darɨꞌ kajɨnnaꞌ Peroyai gannya wawɨnya wɨdaayadɨvɨsaraavɨne tɨka munne yaꞌ. Sagaaꞌ Jozepɨyai sara wɨdakeꞌna Pero sara yaꞌ. Aꞌmwei gamɨre wapaaya wɨmaarina yaderɨna jaka wɨdɨna yaka “Gɨmɨre wawɨnya sɨnnawɨnyaꞌ jɨ!” wɨdaꞌ. Aꞌmwei gamɨre gɨrɨkula yɨdɨka yaderɨ wɨla mararɨdavaꞌ. Peroyare wapaaya wɨmaaryadei gannya wawɨnya yɨna yada Jozepɨyarɨna Peroyarɨ mujaka navɨka mwaalaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","8","Kwarame pɨrɨwaai kwavɨlavaꞌ sawɨta pɨrɨkɨ Pero waja pɨrɨwaai yaꞌnaꞌ. Yaꞌnyɨna yaka mwanyavɨ kave yɨdaakuna kyaꞌ aꞌmwe kwai aꞌmwe kɨrɨꞌ waja sawaarɨna kunnakai mamwaalyaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","13","Kunnakei mamwaalyɨ kyaꞌ Peroyare wapaaya wɨmaaryadei Peroyarɨ wɨdɨna “Dahaasagaaꞌ Jozepɨyarɨna yawɨꞌmwa. Nɨmɨjɨ gɨmɨre gɨrɨkula yɨdɨka yadelyɨ sainaarɨna sɨnna tɨka kagɨthavaꞌ kalavuzavɨ maranehɨmwaaihagɨ. Sawɨta pɨgaaꞌ waja yaꞌnɨgolyainaalyɨra. Jozepɨyai Yɨvɨruyarajɨyai saba mwaalaka naarɨmɨre waja nehɨzɨwaakaꞌ. Nehɨthaꞌ ‘Pero “Gɨmɨre wawɨnya sɨnnawɨnyaꞌ jɨ!” gɨthathera,’ sara nyɨdaꞌ. Gɨrɨkula yɨdɨka yaderɨ ‘Pero wɨla maragɨrɨdavadera,’ wɨdaꞌ. Gamɨre yagaala nebulyasɨra. Sara nehɨthakeꞌ sara yagɨ,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","24","Aꞌmwe naangei Pero Jozepɨyarɨna wɨdasaabɨna yaꞌ. Wɨdasaabɨna kyaꞌ Jozepɨyai maryaata wɨrɨꞌnyɨna yaka kwaabɨhannya tewaanya baazɨꞌmaꞌnya tewaanya mariraꞌnyɨna yaka buladaaꞌna yaꞌ. Buladaaꞌna yadɨsɨ Pero wɨdaꞌ “Nɨmɨ waja yaꞌnyawaaiheꞌ aꞌmwe yuyara aꞌmwe yuya manyɨjɨwaaꞌ. Gɨmɨnyɨna ‘Waja yaꞌnadɨvɨtanna wɨdadelyɨra aꞌmwe sai,’ nyɨdɨwaꞌ pwai.” Sara kudaꞌ “Nɨmɨre Gotɨyai gɨmɨre wajaꞌna nayaa gɨzɨwaakadera,” wɨdaꞌ. Pero Jozepɨyarɨ wɨdɨna “Waja dasaꞌ Aalya Naayɨlɨ aalɨmaangevɨ daaꞌderi bulɨmakaawoya wapemɨnnaka daraai daraai daraai dalyara aalyavɨdaasɨ bilaawɨna yawaaihaꞌ. Bilaawɨna yeva bulɨmakaawoyara kurɨya mudɨꞌmɨlanyɨna yadaapi bulɨmakaawoya maalɨka daraai daraai daraai dalyara aalyavɨdaasɨ bilaawɨna yeva bulɨmakaawoya naangeraavɨ maalɨkera tɨka bilanyɨna yawaaihaꞌ. Nyɨna kyawaaihaꞌ nɨmɨ dɨkaaꞌna yena nabaai se waꞌmwarena yaꞌne waja pɨrɨꞌ yaꞌnyawaaihe. Witɨyagɨnyaꞌ gave pɨrɨꞌnanyavɨ sɨla naanga dawaai dawaai dawaai dasa yɨꞌnɨwakengɨ banganakeinyɨ. Sɨla tewaanya pɨnɨ dɨvidaasɨ yɨꞌnyɨna. Yɨꞌnyɨna yaka kuzɨꞌnya warɨke witɨzɨla sɨnnawɨnya tewaanya yɨꞌnɨwakengɨ maranyɨna yadaapi banganakeinyɨ. Wajawaai sara yaꞌnɨwa,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","36","Pero miꞌna kudaꞌ Jozepɨyai wɨdaꞌ “Wajawaai pɨrɨwaai sara yɨwaanya kɨrɨꞌ avaala gɨzɨwaakɨma! Bulɨmakaawoyaraavɨna yaꞌnɨwaaꞌnajɨ witɨzɨlaꞌna yaꞌnɨwaaꞌnajɨ avaaiyagaala gɨthɨdera. Gotɨyai dɨvi sara yadeꞌna sara gɨzɨwaainɨvanɨka giwɨriwaꞌ. Kwarame dawaai dawaai dawaai daꞌ wavɨlaꞌdaawojɨ Yɨzɨpɨ dava wapaaya naanga waradevanyɨra. Kwarame dawaai dawaai dawaai daꞌ kwavɨlavojɨ kwarame dawaai dawaai dawaai daꞌ sagaaꞌ mɨjɨka dɨvalyidevanyɨra wapaaya mwaryadozɨ. Nɨmɨre yagaala dɨweꞌna ‘Dahaaꞌ aꞌmwe sɨduꞌnakei aꞌmweraavɨ kwarame tewaanyagaaꞌ wɨdasaawɨna “Mɨjɨkegaaꞌnana wapaaya naanga kanyɨjaavapɨjɨ angengɨ marikwakɨna yɨdera,” dada yaderɨ dumwaaihya! Sara kyaꞌgɨzɨ mɨjɨkegaaꞌ wapaaya tɨka nyaꞌne waradegaakɨra sagaaka.’ ” ");
INSERT INTO byr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","45","Peroyai Jozepɨyarɨ wɨdaꞌ “Gotɨyai gamɨre sɨmunya gɨzaavaꞌ. Nɨmɨre wawɨnyasɨ Yɨzɨpɨ kwaakesɨ dɨmaremwaaidera.” Sara wɨdaka gannya ataka magalabwapaina yaka “Nɨmɨre wawɨnya yadelyɨra,” daka Jozepɨyare asarɨ ataka yɨhɨna yaꞌ. Nabaai baazɨꞌmaꞌnya tewaanya marawɨbaazɨꞌmakuna yaka nɨgwia golɨya mararɨnna yaꞌ Peroyai. Mararɨnna yaka Yɨzɨpɨ mwaalyaꞌ aꞌmwe nawɨꞌnyaꞌ Jozepɨyarɨ balaangeꞌ wɨmaarina yaꞌ. Aꞌmwevɨne yayaꞌ Aazanaatɨ woꞌnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","57","Jozepɨyai kwarame 30 kwavɨlavaꞌ sagaaꞌ Peroyare wawɨnya yaꞌnei yɨmaꞌnaꞌ. Kwarame tewaanya dawaai dawaai dawaai daꞌ sagaaꞌ wavɨlaꞌdaaꞌnyɨ anga yuyaba wapaaya naanga marikwakɨna. Marikwakɨna kyaꞌ kwarame dawaai dawaai dawaai daꞌ sagaaꞌ mɨjɨka naanga yɨmaꞌnaꞌ. Mɨjɨka naanga kyɨmaꞌnaꞌ sabanyara Peroyarɨ wapaayanna jaka wɨdɨna. Jaka wɨdɨna kyeꞌ Pero wɨdaꞌ “Jozepɨyaryawɨnna dɨwila! Gamɨ sara yɨhɨthatheꞌ sara jɨla!” Jozepɨyai aꞌmweraavɨ wɨꞌnaka anga tɨka wapaaya wakadɨvɨsavɨ basamakwina yaka wapaaya mubɨna yaꞌ aꞌmwe Yɨzɨpɨ mwaalyaraavɨne. Nabaai kwaaka yuyabanna mɨjɨka naanga waꞌdɨsɨ pɨbanyara “Nemɨ Yɨzɨpɨ saba wapaaya mubaana!” dɨneva bɨna yeva wapaaya mubɨna yeꞌ Jozepɨyarɨ. ");
INSERT INTO byr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","5","Kainanɨ kwaaka wapaaya mwaryadɨsɨ “Kwaaka Yɨzɨpɨ wapaaya warɨꞌ,” dɨdaapi Jaikopɨ wɨꞌnyɨna. Sara wɨꞌnyɨna yaka gawaalɨvaangeraavɨ wɨdaꞌ “Kwaaka Yɨzɨpɨ sabanna wopɨjɨ wapaaya dɨmubyideihɨlyɨra.” Miꞌna wɨdaka “Bejaminɨ wɨryaakei nyɨbwaalɨꞌ nabaladɨka! Dava mwaaladelyɨra,” daka Jozepɨyarɨ gyaꞌmwe ata yuyɨraai darera gavera wɨdasaawɨna kyaꞌ kaanna wɨna yeva Yɨzɨpɨna yɨꞌmavaawɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","7","Gyaꞌmwera Yɨzɨpɨna yɨꞌmavaawɨna yeva Jozepɨyaryabanna wɨna yeva “Aꞌmwe naangeigɨ,” deva gɨꞌduꞌna yeꞌ. Gɨꞌduꞌna kyeꞌ Jozepɨyai dara wanganakeꞌ “Ai, sara nyaꞌmwera dava damwaaihaꞌ.” Miꞌna dɨna kyaꞌ “Jozepɨyalyɨra,” majara “Yɨzɨpɨyalyɨra,” dɨneꞌ kumɨzara. Jozepɨyai “Nɨmɨ kwaasɨ yagaala wɨdɨma!” daka maangeꞌbɨꞌ wɨdɨna “Gawɨdaasaihɨlaꞌ!” wɨdɨna yaꞌ. Gyaꞌmwera “ ‘Wapaaya mubaana!’ dona Kwaakabanne yayaꞌ Kainanɨdaasainera,” wɨdɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","17","Jozepɨyai gannya wajaꞌne gyaꞌmweraavɨna yawɨraka wɨdaꞌ “ ‘Nemɨ kwaaka kuka maraana!’ deva dava sarɨmɨ bwangamwaava.” “Arɨkawɨnyɨra. Aꞌmwe naangeigɨ, ‘Wapaaya mubya yaana!’ dona bonanyɨra. Kainanɨ mwaalyare gawaalɨvaanga atɨraai sɨvɨla purɨdaasɨ pwaraalyɨyainera. Wɨryaakei ganɨmaangelyɨ mwaaihi. Neyaꞌmwe pwai balaꞌ.” Sara kudeꞌ Jozepɨyai wɨdɨna “Sarɨmɨnyɨna yaamɨjɨ yɨhyɨdeinyɨ. Davanna sarɨmɨre wɨryaakei mabi kyojɨ davadaasɨ mwɨyɨ jideihɨlyɨ. Gave pwai kaanna wɨna yojɨ wɨryaakerɨ wɨjɨmaꞌnaawɨna yadelyɨra. Sarɨmɨ pwaihi kalavuzavɨ dɨmwaalyide. ‘Sarɨmɨre yagaala kwaasɨ nyɨdeꞌ,’ daꞌmujɨ sɨmunyaꞌ sarɨmɨnyɨna ‘Damakaanyara bɨvanɨgava,’ yawɨrɨdeinyɨra.” Miꞌna wɨdaka kalavuzavɨ yuyara wɨmwaaihɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","25","Sawɨta pɨryaaina kajɨnnaꞌ Jozepɨyai wɨdɨna “Nɨmɨre dɨwɨjaꞌna jide. Gave pwai kalavuzavɨ mwaalanneꞌneꞌna pwara wapaaya sarɨmɨre kɨnɨdakaavɨne makuna yɨpɨꞌdengɨra. Wɨryaakerɨ kanyɨmakabapɨjɨ sarɨmɨre yagaalyaꞌ yawɨrɨdeinyɨra. Sara kyawɨraꞌmujɨ mabalyɨ jideihɨlyɨra.” Jozepɨyai Yɨzɨpɨ yagaala wɨdadaaꞌnyɨ pwai maridɨna kyaꞌ Jozepɨyarɨ gyaꞌmwera kunnya yagaala dɨneꞌ “Negwaalaanga Jozepɨyarɨna kayaaꞌna yo. Gamɨ kɨnna dadaasɨ wanganona nemɨ dɨragɨnna mwaaloꞌna dahaaꞌ Gotɨyai nemɨnyɨneꞌ kayaaꞌna neyɨvanɨꞌ.” Aꞌmwe Ruvanɨ gyaꞌmweraavɨ wɨdaꞌ “Nɨmɨ yɨhɨthe ‘Mɨgɨnyarɨne kayaaꞌnanyabwi mipɨnera!’ Kyɨhɨtheꞌ mwɨꞌnyɨjeꞌ.” Ruvanɨ sara kudaꞌ Jozepɨyai mwasawɨnna kaanna bwalyuna yaka kɨnna dɨna. Kɨnna dɨna yaka Sɨmɨyanɨmɨ maaraka wɨla pwɨyɨna. Wɨla pwɨyɨna yaka wɨdaayaderɨ kave wɨdɨna “Wapaaya kumɨre gɨlya dɨmaramihya! Aꞌmwe gei gere nɨgwia gannya gɨlyavɨ dɨmihya! Nabaai wapaaya tusavɨne dumaari!” Sara wɨdɨna kyaꞌ sara yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","28","Jozepɨyarɨ gyaꞌmwera wapegɨlya maareva jɨlɨkyaawarya dogiyaraavɨre bulevɨ aꞌba yɨlamarakɨna yeva angebanna kaanna makuna yeꞌ. Kaanna makuna kyeꞌ pɨba waꞌmwaresaba aꞌmwe pwai “Nɨmɨre jɨlɨkyaawaryarɨne wapaaya wɨmaarima!” daka gannya wapegɨlyaꞌ maarɨna yaka wɨlyaꞌ maryaaꞌna. Maryaaꞌna yaka dara wanganakeꞌ “Ai, wapaaya aꞌba nɨmɨre nɨgwia darɨka! Ai, nɨgwia da aai mihɨwaka!” Sara daka gyaꞌmweraavɨ wɨdaꞌ “Nɨmɨre nɨgwia gɨlyavɨ minnarɨꞌ.” Tɨviꞌna kudaꞌ yuyara lɨka yɨna yeva dɨneꞌ “Gotɨyai baarɨꞌ neyɨwaka?” ");
INSERT INTO byr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","38","Kwaaka Kainanɨna bɨna yeva kuvɨnɨmaanga Jaikopɨmɨ sara yesaꞌ sara wɨdɨna. Miꞌna wɨdɨna kyeꞌ Jaikopɨ wɨdaꞌ “Jozepɨyai mamwaalyɨꞌ. Sɨmɨyanɨ mamwaalyɨꞌ. Dahaaꞌ sarɨmɨ ‘Bejaminɨmɨ makuna yaana!’ dapɨjɨ makuna jideꞌ daaka! Savɨ kale nyɨwaka. Bejaminɨ mwaalana!” Sara kudaꞌ Ruvanɨ ganɨmaangerɨ wɨjaaꞌ “Bejaminɨmɨ nyɨjaama! Maremwaalɨdeinyɨ. Aya gɨmɨnyawɨnna mulaabi kyaꞌmujɨ nyɨbwaalɨvaangeraarɨ dɨramakya!” Wiꞌna kudaꞌ Jaikopɨ “Nyɨbwaalɨvaangelyɨ mwikanera!” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","14","Wapaaya Yɨzɨpɨ sabadaasa miꞌna nyɨna kyeꞌ kuvɨnɨmaangei wɨdaꞌ “Sarɨmɨ ayahi dɨwila! Wapaaya pɨnɨ dɨnemubyɨla!” Juthai wɨdaꞌ “Bejaminɨjɨ muyɨ kyawaajɨ aꞌmwei wapaaya manemubi neyadera.” Tɨviꞌna kudaꞌ kuvɨnɨmaanga Yɨzɨrelɨ navɨka mwaalɨna yaka pɨgaaꞌ wɨdaꞌ “Wikɨra. Wɨryaakelyɨ dɨwila! Nabaai yanga wɨjaayaꞌne wɨmaarina, nɨgwia aya sarɨmɨre gɨlyavɨ mihakɨnɨke Yɨzɨpɨ mwaalyarɨ dumaari! Nɨgwia navɨka yɨwaꞌdɨke dɨngaka? Nɨgwia pɨnɨ maarapi wapemubyaꞌna dɨmakwi! Dahaaꞌ yarai dɨwi!” ");
INSERT INTO byr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","24","Yɨzɨrelɨ sara wɨdakeꞌ sara yeꞌ. Yɨzɨpɨ sabanna Jozepɨyaryabanna kabeꞌ Jozepɨyai Bejaminɨmɨ wanganna. Miꞌna wanganaka gannya angevɨ mwaaiderɨ wɨdaꞌ “Tɨka munne naanga jovɨrava! Sɨrɨgwajagaaꞌ aꞌmwe darari naadera.” Jozepɨyai sara kudaꞌ aꞌmwe pwai tɨka wapaaya yovɨravaꞌ. Jozepɨyare angevɨ gyaꞌmwera davaabɨna yeva lɨka yɨna yeva wɨdaayaderɨ wɨdeꞌ “Kɨgaaꞌ nemɨre gɨlyavɨ nɨgwia mihakɨwaꞌdɨkei mwanganyɨwaꞌdo. Nɨgwia sa aya maaꞌmwo. Nabaai nɨgwia pɨnɨ maarona wapaaya pɨnɨnna mubaathera.” Wiꞌna kudeꞌ Jozepɨyare angevɨ maremwaaidei wɨdaꞌ “Lɨka mipɨnera! Kɨgaaꞌ sarɨmɨre nɨgwia maaꞌmwaꞌde. Gotɨyai nɨgwia pɨnɨ sarɨmɨre gɨlyavɨ dahamihakɨwaꞌdɨꞌ?” Wɨdɨna yaka Sɨmɨyanɨmɨ kalavuzavɨdaasɨ maarɨna kyaꞌ aꞌmwe yuyara angevɨ marasaabɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","34","Gyaꞌmwera angevɨ wɨlaꞌdapi sɨrɨgwajagaaꞌ Jozepɨyai wɨlaabɨna kyaꞌ gyaꞌmwera “Aꞌmwe naangeigɨ,” wɨdɨna yeva gɨꞌduꞌna yeva wapaaya waburya yanga wɨjaavɨna. Yanga wɨjaavɨna kyeꞌ Jozepɨyai wɨdaꞌ “Sarɨmɨnyɨ sɨrɨnɨmaangei tewaanya damwaalɨꞌ?” “Tewaanya mwaalɨꞌ,” wɨdɨna yeva gɨꞌduꞌna yeꞌ. Gɨꞌduꞌna kyeꞌ Jozepɨyai Bejaminɨmɨ wanganaka wɨdaꞌ “Sarɨmɨre wɨryaakelyɨ kabɨwaaꞌ yɨhwangamwa.” Jozepɨyarɨ kale wiadaasɨ Bejaminɨmɨ wɨdaꞌ “ ‘Gotɨyai tewaanna gyadeigɨnyɨ,’ gɨthɨma!” wɨdaka yarai gavinyaba wɨladaaꞌna yaka kɨnna maredɨna. Kɨnna maredɨna yaka gannya sɨnnyɨꞌ aalya yɨnyɨna yaka ayawɨnna wɨlaabɨna yaꞌ. Jozepɨyai “Nemɨ naana!” daka sɨraangei pimagɨ wɨmwaaihɨna wɨryaakei pimagɨ wɨmwaaihɨna kutabanyara nayaa wɨmwaaihɨna yaꞌ. Wɨmwaaihɨna yaka wapaaya jaapaina yaka pwaraavɨ kɨbangwa wina, Bejaminɨmɨ wapaaya naanga wina yaꞌ. Sara yɨna kyaꞌ gyaꞌmwera kumɨre gaidaaꞌna wanganna wapaaya naanga Bejaminɨmɨ wina yakeꞌ wanganeva atɨka maruꞌnaꞌna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","9","Kɨdaraka miꞌna kaneꞌ Jozepɨyai gannya wawɨnya wɨdaayaderɨ wɨdɨna “Kumɨre gɨlyangɨ wapaaya dɨmaramihya! Aꞌmwera nɨgwia gannya gɨlyangɨ dɨmihya! Aꞌmwe pwarevɨ sara ja! Aꞌmwe pwarevɨ sara ja! Nabaai nɨmɨre maaꞌgula tewaanya naangeꞌ wɨryaakere gɨlyavɨ dɨmaramihya!” Sara wɨdɨna kyaꞌ wɨdaayadei sara yaꞌ. Mwanyagaaꞌ Jozepɨyarɨ gyaꞌmwera yagalyaꞌmakuna. Yagalyaꞌmakuna kyeꞌ Jozepɨyai wɨdaayaderɨ wɨdaꞌ “Aꞌmwe saraavɨ dɨmɨjaahala! Mɨjaahaina yaꞌgɨzɨ dara dutha! ‘Nɨmɨre aꞌmwe naangere maaꞌgula tewaanya naangeꞌ kuka kyɨwaakɨra.’ ” Wɨdaayadei kaanna kaanna wɨna yaka mɨjaahalaka Jozepɨyai wɨdakeꞌ sara wɨdaꞌ. Sara kudaꞌ Jozepɨyarɨ gyaꞌmwera wɨdeꞌ “Aawa. Maaꞌgula sai mamaariwo. Pware gɨlyavɨ maaꞌgulyai wanganaꞌgɨzɨ gamɨzai dɨramakɨdelyɨra. Nabaai nemɨ yuyaina gɨmɨre aꞌmwe naangere wawɨnya wɨdayadaanyaina yɨmaꞌnaadeinera.” ");
INSERT INTO byr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","17","Jozepɨyarɨ wɨdaayadei wɨdaꞌ “Maaꞌgula sarɨ kuka maaꞌmwaka gavei wɨdaayadei yɨmaꞌnadelyɨ. Sarɨmɨ pwaihi kaanna dɨwila!” Miꞌna wɨdaka kumɨre gɨlyangɨ wanganna wanganna yaka Bejaminɨmɨre gɨlyavɨ maaꞌgulyaꞌ daapɨna yaꞌ. Daapɨna kyaꞌ Jozepɨyarɨ gyaꞌmwera kale kwiaꞌ lɨka yɨna yeꞌ. Lɨka yɨna yeva Jozepɨyaryawɨnna ayɨna kaanna wɨna yeva kale wiadaasɨ sagaaꞌ gɨꞌduꞌna yeꞌ. Gɨꞌduꞌna kyeꞌ Jozepɨyai wɨdɨna “Sarɨmɨ sara yɨvanɨgasaꞌna nɨmɨ sɨduꞌnakeinyɨ yawɨꞌdɨnyainyɨra. Daꞌ baaꞌna yɨwaatavaka?” Wiꞌna wɨdɨna kyaꞌ Juthai wɨdaꞌ “Nemɨ yagaala berɨꞌ gɨthaazɨwona? Nemɨ kayaaꞌna yɨvanɨgoꞌ dahaaꞌ gɨmɨre wawɨnya gɨthayadaanyaina yɨmaꞌnaadera.” Sara kudaꞌ Jozepɨyai wɨdɨna “Arɨkawɨnyɨra. Nɨmɨre maaꞌgulyaꞌ kuka maaꞌmwakei gavei nɨmɨre nyɨdaayadei yɨmaꞌnadera. Aꞌmwe pwara kuvɨnɨmaangeryawɨnna ayahi kaanna wɨna yɨpɨꞌdera.” ");
INSERT INTO byr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","34","Miꞌna wɨdɨna yakegaaꞌ Juthai wɨdaꞌ “Bejaminɨmɨne nenɨmaangei yɨlaaya naanga marivanɨka. Kwarame kwalaalya naanga kwavɨlavaꞌ sagaaꞌ neyaꞌmwe Jozepɨyai pwai mɨka. Sagaaꞌ yuyagaaꞌ nenɨmaangerɨ kale wiaꞌ. Dahaaꞌ Bejaminɨmɨ kamaaraꞌgɨzɨ nenɨmaangei balɨna yadelyɨra. ‘Bejaminɨ kaanna wɨna yade,’ daꞌgɨzɨ nɨmɨ dava mwaalaꞌmujɨ wawɨnya gɨthaayadɨnyainyɨ yɨmaꞌnɨdeinyɨra. Bejaminɨ kaanna muyɨ nyadɨka! Nɨmaamaangeryawɨnna aya muyɨ yadɨ mwaalɨna yɨdeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","15","Juthai sara kudaꞌ Jozepɨyai kale naanga wiadaaꞌnyɨ wɨdaayadɨvɨsara yuyaraavɨ mwasawɨnna wɨdasaawɨna. Wɨdasaawɨna yaka kɨnna naanga maredakerɨ Yɨzɨpɨ mwaalyara wɨꞌnyɨna. Kadɨka wɨꞌnyɨna kyeꞌ Jozepɨyai gyaꞌmweraavɨ wɨdɨna “Jozepɨyainyɨ. Nɨmaamaangei nayaa kuna damwaalɨꞌ?” Sara wɨdɨna kyaꞌ gyaꞌmwera atɨka maruꞌnaꞌna yeva yagaala majara navɨka yɨna. Navɨka yɨna kyeꞌ wɨdɨna “Mithɨyanɨ mwaalyaraavɨ kanyɨmubeꞌ kumɨzara Yɨzɨpɨna nyɨmakwaweꞌ. Sarɨmɨ sara nyesaihi dahaaꞌ kave dɨmwaalyi! ‘Nemɨ kayaaꞌna naangeina,’ majɨ jideꞌna Gotɨyai ‘Kumɨ nabalapɨdɨka!’ daka sarɨmɨnyɨna waasɨna nyaꞌ. Waasɨna nyaka ‘Kwaaka Yɨzɨpɨ yuyaba dɨmaremwaaideigɨnyɨra,’ nyɨdɨnɨkeinyɨra. Wapaa kunegaaꞌ kwarame pɨrɨwaai kwavɨlavaꞌ kwarame dawaai dawaai daꞌ wavɨlavadengɨ. Nɨmaamaangeryawɨnna yarai dɨwila! Dara duzi! ‘Nɨmwai gɨmɨnyɨ kɨnɨdakaavihɨrɨjɨ gɨmɨre gɨlyɨvɨsajɨ Yɨzɨpɨna dɨmakwona!’ sara duzi! Wapaaya kunegaaꞌ maremwaaina yɨhyɨdeinyɨra. ‘Gamɨ Jozepɨyalyɨra,’ miꞌna yawɨꞌmwaava. Naangeꞌ yɨhɨthɨwana.” Miꞌna wɨdɨna yaka Bejaminɨmɨ galamujɨꞌna yaka kɨnna maredɨna yaka gyaꞌmwe pwaraavɨ galamujɨꞌna, kɨnna maredɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","28","Yɨzɨpɨya aꞌmwe naangei Peroyai “Jozepɨyarɨ gyaꞌmwera mena bɨna yɨwaaꞌ,” wɨꞌnaka yɨlaaya yɨna yaꞌ. Yɨlaaya yɨna yaka Jozepɨyarɨ wɨdaꞌ “Jaꞌmweraavɨ dara dutha! ‘Kaarɨzɨya (kaareꞌbɨsa) dɨmaaryi! Kwaaka Kainanɨna ayahi dɨwila! Sabadaasɨ sɨrɨnɨmaangelyɨ sarɨmɨrejɨ sangɨ nɨmɨnyawɨnna dava dɨmakabyidengɨra,’ dutha!” Pero sara kudaꞌ Jozepɨyai kwaabɨhannya baazɨꞌmaꞌnya wapaaya tusavɨ nɨgwɨyaꞌne wɨmaarina yaka Bejaminɨmɨne nɨgwia naanga baazɨꞌmaꞌnya pɨjaakuna wɨmaarina. Wɨmaarina yaka nabaai wapaaya jɨlɨkyaawarya ganɨmaangarɨne yaasɨna. Yaasɨna kyaꞌ gyaꞌmwera Kainanɨna ayɨna wɨna yeva Jaikopɨmɨ Jozepɨyarɨna wɨdeꞌ. Jozepɨyarɨna kudeꞌ Jaikopɨ balyengɨꞌnaꞌ. Balyengɨꞌnaka wɨdaꞌ “Saꞌ nebwina mɨka.” Kaarɨzɨya Jozepɨyai yasaabɨna yake wanganaka wɨdaꞌ “Nebulyasɨra. Jozepɨyai kwaihwaainakei mwaalɨꞌ. Nɨmɨ wanganaawɨma! Miꞌna wanganaꞌmujɨ dɨvi balɨdeinyɨra,” wɨdaꞌ Jaikopɨ. ");
INSERT INTO byr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","4","Yɨzɨrelɨ gannya gɨlyɨvɨta yuya maarɨna yaka anga Bɨyazivana yɨꞌmavaawɨna yaka jɨlɨkyaawarya Gotɨyarɨna dɨka yɨraꞌna yaꞌ. Yɨraꞌna kyaꞌ Gotɨyai wɨdaꞌ “Gotɨyainyɨra. Gɨmaamaanga Aazakɨ yɨlaaya nyɨmaryaꞌ. Kwaaka Yɨzɨpɨ sabanneigɨ lɨka minnera! Saba gɨmɨreraavɨ kwala naangera dɨragɨnyara wɨmwaaihɨna yɨdeinyɨra. Gɨmɨjɨ wawakadeinaalyɨra. Nabaai gɨmɨ balaꞌdaaꞌgi Jozepɨyai gɨmɨnyaba mwaaladelyɨra. Wɨla pɨgaaꞌ ayɨna byaꞌneihɨrɨ yɨhɨmwaaihɨdeinyɨra,” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","27","Bɨyazivadaasɨ Yɨzɨpɨ sabanne Jaikopɨjɨ gawaalɨvava garaayava sa kaanna wɨna yeꞌ. Yɨzɨpɨ sabanna yɨꞌmavaaweva aꞌmwe daraai dalyaraavɨre ata sɨvɨlɨraai yaka pware atɨraai yuya mwaaleꞌ. (Yuya 70 mwaaleꞌ). ");
INSERT INTO byr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","34","Jaikopɨ Jutharɨ wɨdasaawɨna “Jozepɨyaigɨ Kwaaka Gozanɨ wɨraꞌnaka!” Jozepɨyai wɨjɨmaaꞌnyɨna kyaꞌ galamujɨꞌnyɨna yagɨla kɨnna maredɨnagi. Kamaredɨnagi ganɨmaangei wɨdaꞌ “Gwangamweinyɨ dahaaꞌ yɨlaaya yɨna, nayaa balɨdeinyɨra.” Jozepɨyai kumɨzangɨ wɨdaꞌ “Nɨmɨ kaanna waanyɨna yaꞌmujɨ Peroyarɨ wɨdɨna yɨdeinyɨra. ‘Jɨlɨkyaawaryajɨ kaimɨraavɨzɨmyajɨ nɨmɨre sa bamwaaihava.’ Sarɨmɨ dara duzi! ‘Nemɨ jɨlɨkyaawarya yɨꞌdɨvaidaanyainera.’ Yɨzɨpɨ mwaalyara jɨlɨkyaawaryaraavɨna yɨlaaya myadɨvɨsarera. Yɨꞌdɨvaidɨvɨsaihi mwaaidapi Peroyai ‘Gozanɨ kwaaka tewaanyaba dɨmwaalyɨla!’ yɨhɨthathelyɨra.” ");
INSERT INTO byr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","6","Jozepɨyai gyaꞌmweraavɨ miꞌna wɨdaka Peroyaryawɨnna kaanna wɨna yaka wɨdaꞌ “Nɨmaamaangelyɨ nyaꞌmwerajɨ sara Kwaaka Gozanɨ mwaaihaꞌ.” Jozepɨyai Peroyarɨ wɨdakegaaꞌ gyaꞌmwera aꞌmwe daraai daraai dalyara Peroyare angevɨ mwaaleꞌ. Kamwaaleꞌ Peroyai wɨdɨna “Bewawɨnya yadɨvɨtaihɨlaka?” Sara kudaꞌ kumɨ wɨdeꞌ “Nenɨmaangei jɨlɨkyaawarya kyɨꞌdɨvalaꞌ nabaai nemɨ sara yɨꞌdɨvaidaanyainera. Kwaaka Kainanɨ nemɨre jɨlɨkyaawaryaraavɨne wapaaya mwarika. ‘Kwaaka Gozanɨ saba dɨmwaalyɨla!’ kanedaꞌgɨzɨ saba mwalaadennera.” Miꞌna kudeꞌ Peroyai Jozepɨyarɨ wɨdaꞌ “Gɨmaamaangelyɨ jaꞌmwerajɨ saraavɨ dutha! ‘Kwaaka Gozanɨ tewaanyaba dɨmwaalyɨla!’ ‘Wawɨnaangera pwara damwaaihava!’ daꞌgɨzɨ ‘Peroyare jɨlɨkyaawarya jɨꞌdɨvalyɨla!’ duthana!” ");
INSERT INTO byr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","12","Miꞌna dɨnagɨlyagaaꞌ Jozepɨyai ganɨmaangerɨ wɨjɨmaaꞌnyɨna yaka kaanna bɨna. Kaanna bɨna kyagi Peroyai Jaikopɨmɨ wanganaka wɨdaꞌ “Kwarame gara gara gwavɨlavaka?” Sara kudaꞌ Jaikopɨ wɨdaꞌ “Aꞌmwe neinyɨ kwarame naanga naanga (130) nyavɨlavaꞌ.” Wiꞌna wɨdaka “Kwarame kwalaalya gɨmɨ tewaanna mwaaihɨna gyathe Gotɨyai.” Sara wɨdaka sabadaasɨ kaanna wɨna yaꞌ. Nabaai Jozepɨyai kaanna wɨna yaka kwaaka tewaanyaba ganɨmaangelyɨ gyaꞌmwerajɨ saraavɨne wɨjaavɨna yaka wapaaya kumɨnyɨne wɨjaavɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","26","Sagaaꞌ Kwaaka Kainanɨ Kwaaka Yɨzɨpɨ sabanyaai wapaaya kunegaakɨra. Aꞌmwemɨlɨka Jozepɨyarɨ wapaaya kamubeꞌ Jozepɨyai nɨgwia maaraka Peroyarɨna wɨjaavaꞌ. Sana sana yɨna yɨna yakegaaꞌ aꞌmwemɨlɨka Jozepɨyarɨ wɨdeꞌ “Nemɨ dahaaꞌ nɨgwia mwarika. Kunemɨlɨkanera. Mɨjɨka naanga balaꞌdaanyamɨlɨkanera. Wapaaya nejaama!” Tɨviꞌna kudeꞌ Jozepɨyai wɨdaꞌ “Sarɨmɨre jɨlɨkyaawarya kanyɨjaavapɨjɨ wapaaya yɨhɨzaavɨdeihɨlyɨra.” Sara kudaꞌ aꞌmwemɨlɨka jɨlɨkyaawarya maareva wɨjaavɨna kyeꞌ Jozepɨyai wapaaya wɨjaavɨna yaꞌ. Wapaaya wɨjaavɨna kyaꞌ kwarame pɨrɨꞌ kwavɨlavaꞌ aꞌmwemɨlɨka Jozepɨyaryabanna kaanna bɨna yeva wɨdeꞌ “Nɨgwiajɨ jɨlɨkyaawaryajɨ yuya mwariꞌ. Dahaaꞌ kunegaaꞌ mɨjɨka naangegaaꞌ nemɨre kwaakejɨ nemɨjɨ warɨꞌ. Wapaaya nyaꞌne witɨzɨla wiaꞌne kanejaavaꞌgɨzɨ yuya gɨzavaadera.” Aꞌmwemɨlɨka sara kudeꞌ Jozepɨyai Yɨzɨpɨ mwaalyaraavɨ wɨdɨna “Sarɨmɨre kwaakejɨ sarɨmɨjɨ sangihɨrɨ Peroyarɨne yɨhɨmubɨvanɨge nayaa jawɨrila! Wiaꞌne yɨhɨzaavanɨge dɨvurɨjɨla! Yawaka kyojɨ sarɨmɨ mɨlɨna yapɨjɨ gɨlya atina mihapɨjɨ gɨlya gave pɨrɨꞌ Peroyarɨne wɨmaarina jidesɨra. Sana sana witɨzɨla yuya jidengɨra. Gɨlya dawaai dawaalyangɨdaasɨ witɨzɨla nyaꞌne witɨzɨla wiaꞌne dɨmaaryidengyɨhɨlyɨra. Sarɨmɨresɨra.” Sara wɨdɨna kyaꞌ aꞌmwemɨlɨka yɨlaaya yɨna yeva wɨdaꞌ “Dahaaꞌ nemɨ mwalaadeinera. Peroyare wɨdayadaanyaina yɨlaaya mwalaadera.” ");
INSERT INTO byr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","31","Jaikopɨnɨdaka kwala naanga yɨmaꞌnyɨna kyeꞌ Gozanɨ mwaalakei Jaikopɨ gɨlyɨvɨta naangejɨyai mwaalaꞌ. Jaikopɨ kwarame 147 kwavɨlavaꞌ dara wanganakeꞌ “Ai, nɨmɨ aꞌmwe neinyɨ yarai balɨdeinyɨ daaka!” Daka Jozepɨyarɨ “Yarai dɨvama!” jaka wɨdɨna yaka wɨdaꞌ “Nɨmɨ kabalaꞌmujɨ Yɨzɨpɨ dava nanyakɨpɨka! Nɨmaamaangei warɨkeba dɨnyakideinyɨra.” Sara kudaꞌ Jozepɨyai “Naangeꞌ gɨthɨwana ‘Gɨnnya dadɨnyaba gwakɨdeꞌnanyɨra,’ ” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","9","Pɨgaaꞌ sagaaꞌ aꞌmwemɨlɨꞌ Jozepɨyarɨ wɨdaꞌ “Gɨmaamaangei nabalɨnakei mwaalɨꞌ.” Sara wɨꞌnaka Jozepɨyalyɨ gawaalɨvaangeraalyɨ “Nemɨ Jaikopɨmɨ wanganaana!” deva kaanna wɨna yeꞌ. Jozepɨyarɨ gawaalɨꞌ pwai Manaazai pwai Yɨpɨremɨ mwaalagi. Jaikopɨmɨ angyɨrɨꞌmaata kyeꞌ Jaikopɨ Jozepɨyarɨ wɨdaꞌ “Anga Betelɨ Kwaaka Kainanɨ mannɨkeba Gotɨyai nɨmɨnyaba wɨlaabaka nyɨdaꞌ ‘Gɨmɨre kaimɨraaya kwala naanga gɨzaavɨdeinyɨra. Nabaai kumɨnyɨne gazagaasagaaꞌ Kwaaka Kainanɨ wɨjaavɨdeinyɨ,’ sara nyɨdaꞌ. Jozepɨyaigɨ gɨmɨre kaimɨraayaraai Yɨzɨpɨ saba yawakɨnagɨnyaraai nɨmɨnneraalyɨra. Yɨpɨremɨjɨ Manaazalyɨ saraarɨ nyɨmakama! Kɨrɨmɨnyɨ tewaanna wɨdɨdeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","22","Yɨzɨrelɨ aꞌmwe nei tɨnna jɨhɨnna wiadaaꞌnyɨ mwaalɨna yaꞌ. Yɨzɨrelɨ sara kudaꞌ Jozepɨyai Yɨpɨremɨjɨ Manaazalyɨ saraarɨ yosɨgalamakuna kyaꞌ Yɨzɨrelɨ galamujɨꞌna, yɨlaaya marina yaka Jozepɨyarɨ wɨdaꞌ “ ‘Jozepɨyai pɨgaaꞌ magwanganyadɨnyainyɨra,’ dena saꞌ Gotɨyai sara kyaꞌ gɨmɨjɨ kaimɨraayaraalyɨ saihɨrɨ sara yɨhwangamanɨge.” Miꞌna kudaꞌ Jozepɨyai gamɨre sɨraanga Manaazarɨ Yɨzɨrelɨmɨre angasɨrɨ wɨmwaaihɨna, Yɨpɨremɨmɨ kwanaamimagɨ wɨmwaaihɨna yaꞌ. Wɨmwaaihɨna kyaꞌ Yɨzɨrelɨ asɨraai wovihɨralɨmwagaꞌnyɨna yaꞌ kaimaleraarɨ. Sara kyaꞌ Jozepɨ dara wanganakeꞌ “Ai, nɨmware angasi dɨviyarɨ dathathɨwagalɨmwagarɨka!” Dɨna yaka gamɨre angasi lɨmwanna yaka wɨdaꞌ “Manaazai sɨraangelyɨra. Gamɨnyɨ angasɨlyɨ dɨlɨmwagaka!” Kudaꞌ Yɨzɨrelɨ wɨdaꞌ “Aawana, kunya yawɨꞌmanɨgeinyɨra. Manaazare kaimɨraaya kwala naanga yɨrɨvadengɨra. Saꞌ Yɨpɨremɨre kwala naanga naanga yɨrɨvadengɨra.” Nabaai Yɨzɨrelɨ wɨdaꞌ “ ‘Gotɨyai Evɨraamɨjɨ Aazakɨjɨ nɨmɨjɨ sainaavɨ tewaanna sara neyakabaaibɨꞌ kaimɨraayaraarɨ tewaanna sara wiadelyɨra,’ yɨhɨthɨvanɨge. Jozepɨyaigɨ nɨmɨ dɨvi maalɨkegaaꞌ balɨdera. Sarɨmɨnɨdakaavihɨlyɨ Gotɨyalyɨ saihi dɨmwaalyideihɨlyɨra. Gotɨyai sarɨmɨ Kwaaka Kainanɨna ayɨna makuna yɨhyadelyɨra. Kwaaka pɨba Amoyaraavɨreba kuka maarena kwaaka saba gɨzaawa. Gɨmɨresɨra. Jaꞌmweraavɨreꞌ mɨka.” ");
INSERT INTO byr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","28","“Nyɨbwaalɨvava kumɨnyɨne wiadeꞌna wɨjɨwaakɨma!” daka Jaikopɨ gawaalɨvavaavɨ “Jɨkabila!” jaka wɨdɨna yaꞌ. Wɨdɨna kyaꞌ yuyara wɨlɨna kyaꞌ Jaikopɨ wɨdɨna “Ruvanɨ, nɨmɨre sɨraangeigɨnyɨra. Nɨmɨre aꞌmwevɨ kwala maaragɨnyaꞌna kutabanyaigɨ yɨmaꞌnyɨna jɨtheigɨnyɨra. Sɨmɨyanɨjɨ Livaalyɨ saraaihi sɨnna tɨka wɨdaꞌdaasɨ aꞌmwe yagɨmaayaraavɨ tamakagɨlyaꞌna Yɨzɨrelɨmɨreraayaba pɨba pɨba mwalamarina yɨpɨꞌderera kɨrɨmɨrera. Juthai, jaꞌmwera yɨlaaya gɨmaripɨꞌderera. Nabaai wawɨnya gɨthaayadɨvɨsara yɨmaꞌnɨpɨꞌderera. Gɨmɨre yɨkamaangera gɨmɨnyɨne lɨkaanya wɨpɨꞌdera. Juthai malakayaawaryaibɨsai laayonɨyaibɨsalyɨra. Jutharera kuna maremwaaina yadaapi Gamɨrei kwaamuꞌnanyagaaꞌ maremwaaidei bathelyɨra. Aꞌmwe pɨba pɨbanyara wɨꞌnapɨjɨ gamɨre yagaalyaꞌ sara yɨpɨꞌdelyɨra. Yɨsɨla naanga waꞌdaawojɨ waburyaꞌna maranadengɨra Juthai. Sevulanɨ aalɨbumaangevɨ mwaaladelyɨra. Yɨzakaai gannya yagɨnya dɨragɨnyai kwaaka tewaanyaba mwaalɨna yadei wawɨnya naanga yɨna yadelyɨra. Denɨ kotɨyavɨ yawɨbwaꞌdei gamɨrera yagaaihɨwɨnya dathelyɨra. Gamɨzai tusavɨ naawɨnaanyai mwaalɨkeibɨsalyɨra. Gethɨyarɨ yɨkamaangera ‘Tamaana!’ dapi wɨlaabapɨjɨ dɨvi lɨkaanya wodaapi Gethɨyai tamadelyɨra. Azai wapaaya tewaanya waꞌdevanyai aꞌmwe naangera maremwaaidɨvɨsaraavɨne wapaaya sa wɨmaarina yadelyɨra. Napɨtalaai namaannya kaanyɨveꞌna wodeibɨsalyɨ. Gamɨ yagaala nayaa makabathelyɨ Napɨtalaai. Jozepɨyai yɨta sinakeibɨsalyɨra. Padɨvɨsara gamɨnyɨna mwata yevɨnna, Gotɨyai mwaryagɨnyavɨ gamɨre asawaai dɨragɨnyabwi wina yadei. Nemɨre Gotɨyai dɨragɨnyai yuyagaaꞌ yuyagaaꞌ tewaanna wiadelyɨra. Bejaminɨ kavɨjɨlɨkei tɨka daꞌdeibɨsalyɨra.” Jaikopɨ sara wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","33","(-)");
INSERT INTO byr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","13"," Jaikopɨ yagaaihɨwɨnya miꞌna wɨdaka wɨdɨna “Dahaaꞌ yarai balɨna yɨde. Kabalaꞌmujɨ Maakɨpela simaangevɨ Kwaaka Kainanɨ saba dɨnyakyideinyɨ.” Mena wɨdɨna yaka balaꞌ. Kabalaꞌ Jozepɨ ganɨmaangerɨ galamujɨꞌna yaka kɨnna maredɨna yaꞌ. Kɨnna maredɨna yɨna yaka wɨdaayadɨvɨsaraavɨ wɨdaꞌ “Nɨmaamaangere kɨlaaka bwiaꞌna marazɨnanyaꞌ maarapɨjɨ dɨvuri!” Yɨzɨpɨ mwaalyarajɨ Jaikopɨnɨdakajɨ sawɨta 70 jɨnnadaaꞌnyɨyagaaꞌ kɨnna maredɨna yeꞌ. Kɨnna maredɨna kyeꞌ Jozepɨyai wɨdaayadɨvɨsaraavɨ wɨdasaawɨna kyaꞌ Peroyarɨ wɨdeꞌ “Jozepɨyai gɨthɨvanɨꞌ ‘Nɨmaamaangerɨ naangeꞌ wɨdahe “Kwaaka Kainanɨ gwakɨdeinyɨra.” Sara wɨdahe “Jozepɨyaigɨ dɨwona!” kanyɨdaꞌgɨzɨ wɨdeinyɨra. Nɨmɨ baryai miꞌna wakaꞌmujɨ ayɨna bɨna yɨdeinyɨra.’ ” Sara kudeꞌ Peroyai wɨdaꞌ “Gɨmɨ dɨwona!” Wiꞌna kudaꞌ Jozepɨyalyɨ gyaꞌmwerajɨ Yɨzɨpɨ mwaalya aꞌmwe naangerajɨ Kainanɨna wɨna yeꞌ. Kwaaka Aatathɨna yɨꞌmavaawɨna kyeꞌ sawɨta atina ata purɨdaasɨ pwaraaina kujɨnnaꞌ kɨnna naanga dɨna yeꞌ. Kɨnna naanga miꞌna kadeꞌ Jaikopɨmɨ gawaalɨvava gamɨnyɨ Maakɨpela simaangevɨ wakɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","21","Jozepɨyalyɨ gyaꞌmwerajɨ aꞌmwe yuyarajɨ Yɨzɨpɨna ayɨna wɨna yeꞌ. Gyaꞌmwera Jozepɨyarɨna lɨka yeva dɨneꞌ “Nemɨ kɨgaasagaaꞌ Jozepɨyarɨ kayaaꞌna yo. Dahaaꞌ nemɨnyɨna kayaaꞌna yadei dɨngaka? Baarɨꞌ yajɨwaꞌ?” dɨnyɨna yeꞌ. Dɨnyɨna yeva Jozepɨyaryawɨnna wɨna yeva wɨdeꞌ “Nemɨ kayaaꞌnanyabwi gɨmɨnyɨna yobwi myawɨri jɨthe. Warana! Nemɨ gɨmɨre dɨzavɨ kadɨka wɨꞌnyɨna gyaatheinera. Nenɨmaangei mwaalakegaaꞌ sara nejɨwaakakeinera.” Miꞌna wɨꞌnaka Jozepɨyai kɨnna daka kavena wɨdaꞌ “Lɨka mipɨnera! ‘Jozepɨyarɨ kayaaꞌna yaana!’ kadɨneꞌ Gotɨyai ‘Nɨmɨ aꞌmwe kwala naanga yɨvainɨdera mɨjɨkegaaꞌ,’ daka ‘Jozepɨyarɨ gyaꞌmwera yɨvanɨgasaꞌ sara yɨpɨꞌdeꞌnanyɨra,’ daꞌ Gotɨyai. Sarɨmɨnyɨna tewaanya maremwaalɨdeinyɨra,” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","26","Jozepɨyalyɨ gamɨrejɨ sa Yɨzɨpɨ saba mwaaleꞌ. Jozepɨyai kwarame 110 wavɨlavakei gyakaangengɨ tɨnna wanganaꞌ. Tɨnna miꞌna wanganaka gamɨrengɨ wɨdaꞌ “Nɨmɨ yarai balɨdeinyɨra. Gotɨyai sarɨmɨnyɨ Kwaaka Kainanɨ Gotɨyai kwaaka Evɨraamɨmɨneꞌ Aazakɨmɨneꞌ Jaikopɨmɨneꞌ wɨjaavakebanna ayɨna makuna yɨhyadelyɨra. Naangaꞌna yagaalyaꞌ dɨnyɨjɨla! ‘Nemɨ kwaaka Kainanɨna kaanyagaaꞌ Jozepɨyare yagɨnya makuna yawaajɨ saba wakɨna yaadengɨra.’ ” Sara wɨdaka balɨna yaꞌ. Kabalaꞌ pwara “Gannya kɨlaakeꞌ tewaanya warana!” deva marazɨnanyaꞌ purɨna yeva bɨkusavɨ wɨlakɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jizaazai Kɨraazɨtɨyai yɨmaꞌnanneꞌna Ne Kuvɨdaarava Ne Kwɨyakwaravaavɨne yayangɨ. Ne Devitɨmɨre yɨsavaakɨdaaꞌnyɨ Jizaazai yɨmaꞌnyɨna. Ne Evɨraamɨmɨre yɨsavaakɨdaaꞌnyɨ Devitɨ yɨmaꞌnyɨna. Yagaala daꞌ Jizaazai Kɨraazɨtɨyarera sɨnnawɨ yɨmaꞌnɨnɨkeraavɨnesɨ. ");
INSERT INTO byr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Evɨraamɨ Aazakɨmɨ ganɨmaangelyɨ. Aazakɨ Jaikopɨmɨ ganɨmaangei. Jaikopɨ Jutharɨjɨ gathaaꞌgahwaaravaavɨjɨ ganɨmaangei. ");
INSERT INTO byr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juthai Perezarɨjɨ Jeraamɨjɨ ganɨmaangei. Perezarɨ ganaangeꞌ avaalyagaaꞌ kɨdaraarɨ maarakeꞌ Temaaꞌ. Perezai Ezɨronɨmɨ ganɨmaangei. Ezɨronɨ Raamɨmɨ ganɨmaangei. ");
INSERT INTO byr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Raamɨ Aminɨthapɨmɨ ganɨmaangei. Aminɨthapɨ Naazonɨmɨ ganɨmaangei. Naazonɨ Saalɨmonɨmɨ ganɨmaangei. ");
INSERT INTO byr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saalɨmonɨ Bowaazarɨ ganɨmaangei. Bowaazarɨ ganaangeꞌ Rayaaꞌ. Bowaazai Wovetɨmɨ ganɨmaangei. Wovetɨmɨ ganaangeꞌ Rutɨyaꞌ. Wovetɨ Jeziyarɨ ganɨmaangei. ");
INSERT INTO byr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jeziyai Kingɨya Devitɨmɨ ganɨmaangei. Devitɨ Solomonɨmɨ ganɨmaangei. Solomonɨmɨ ganaangeꞌ kwala mudɨꞌmaaꞌnyaꞌ Yuraayarɨ maaꞌnakesɨra. Yuraayai kabalaꞌ Devitɨ maaraka Solomonɨmɨ wɨmwaaihaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonɨ Rɨyavowaamɨmɨ ganɨmaangei. Rɨyavowaamɨ Avaazarɨ ganɨmaangei. Avaazai Ezarɨ ganɨmaangei. ");
INSERT INTO byr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ezai Jewozapatɨmɨ ganɨmaangei. Jewozapatɨ Joraamɨmɨ ganɨmaangei. Joraamɨ Azaayarɨ ganɨmaangei. ");
INSERT INTO byr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Azaayai Jotaamɨmɨ ganɨmaangei. Jotaamɨ Ayaazarɨ ganɨmaangei. Ayaazai Ezɨkaayarɨ ganɨmaangei. ");
INSERT INTO byr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezɨkaayai Manaazarɨ ganɨmaangei. Manaazai Emozarɨ ganɨmaangei. Emozai Jozaayarɨ ganɨmaangei. ");
INSERT INTO byr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jozaayai Jekonaayarɨjɨ gahwaaravaavɨjɨ ganɨmaangei. Sagaaꞌ Bavɨlonɨ mwaalyara Yɨzɨrelɨyaraavɨ tamakeva makwaweva Anga Bavɨlonɨ menyawɨnna wɨmwaaiheꞌ. ");
INSERT INTO byr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Anga Bavɨlonɨ kalavuzɨwawɨnya yadaapi Jekonaayai Sɨyalɨtiyalɨmɨ ganɨmaangelyɨ. Sɨyalɨtiyalɨ Seravaavelɨmɨ ganɨmaangei. ");
INSERT INTO byr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Seravaavelɨ Avaayatɨmɨ ganɨmaangei. Avaayatɨ Elaayakimɨmɨ ganɨmaangei. Elaayakimɨ Ezorɨ ganɨmaangei. ");
INSERT INTO byr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ezoi Sethokɨmɨ ganɨmaangei. Sethokɨ Ekimɨmɨ ganɨmaangei. Ekimɨ Elaayatɨmɨ ganɨmaangei. ");
INSERT INTO byr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaayatɨ Elɨyaazarɨ ganɨmaangei. Elɨyaazai Mataanɨmɨ ganɨmaangei. Mataanɨ Jaikopɨmɨ ganɨmaangei. ");
INSERT INTO byr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jaikopɨ Jozepɨyarɨ ganɨmaangei. Jozepɨyai Maarɨyaavɨ kwalaangai yɨmaꞌnaꞌ. Maarɨyaaꞌ Jizaazarɨ maarakelyɨ. Jizaazai sahwai Kɨraazɨtɨyai woꞌnɨkelyɨ. Gotɨyai dahɨlakakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sarevɨdaaꞌnyɨ aayawɨ Ne Evɨraamɨ mwalyaakegaaꞌdaasɨ saamɨnaangegaaꞌ Ne Devitɨ yɨmaꞌnyɨna. Evɨraamɨmɨdaaꞌnyɨ mɨjɨyɨmaꞌnɨgaveva sɨvɨlyɨrɨdaaꞌnyɨ daraai daraalyara (14) yɨmaꞌnyaasare. Nabaai aayawɨ Devitɨ mwalyaakegaaꞌdaasɨ saamɨnaangegaaꞌ Anga Bavɨlonɨ kalavuzɨwawɨnya yaasagaaꞌ yɨmaꞌnyɨna. Yɨ Devitɨmɨdaaꞌnyɨ mɨjɨyɨmaꞌnɨgaveva sɨvɨlyɨrɨdaaꞌnyɨ daraai daraalyara yɨmaꞌnyaasare. Nabaai Bavɨlonɨ kalavuzɨwawɨnya yaasagaaꞌdaasɨ mɨjɨyɨmaꞌnɨgaveva sɨvɨlyɨrɨdaaꞌnyɨ daraai daraalyai yɨmaꞌnaꞌ Kɨraazɨtɨyai. ");
INSERT INTO byr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jizaazai Kɨraazɨtɨyai yɨmaꞌnakegaaꞌ dara yɨmaꞌnɨnɨkesɨ. Jizaazarɨ ganaangeꞌ Maarɨyaaꞌ sɨdɨraayaꞌ yɨmaꞌnaka Jozepɨyarɨna dahɨlakɨna yesaꞌ Jozepɨyai kwala mamaaryadɨꞌnyɨ Gotɨyare Kuryai Maarɨyaavɨre munyɨkɨ mihakɨna kyaꞌ dara wanganakeꞌ “O, Maarɨyaaꞌ kaimɨraavɨmunnakeꞌ daaka!” ");
INSERT INTO byr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kwalaangei Jozepɨyai aꞌmwe yɨdaꞌnanyai “Wagɨla wɨjaavɨma!” majai. Sarei “Kave makwasakɨna yɨma!” ");
INSERT INTO byr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","yawɨꞌdaaꞌnyɨ, yɨthaanyi, wajavɨ Naangere mamaayai ejelɨyai yɨmaꞌnaabɨna. Sara yɨmaꞌnaabɨna yaka wɨdɨna “Jozepɨyaigɨ, Devitɨmɨre gawaalɨꞌgɨ Maarɨyaavɨ maaryaꞌnevɨna yawɨta kwalaalya minnera! Sareꞌ dareꞌnesɨ. Kaimɨraavɨmunya saꞌ Kurya Tewaanyai wɨjaavakesɨra. ");
INSERT INTO byr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kaimalei maaradelyɨ. Kamaarojɨ gannya yayaꞌ ‘Jizaazala,’ duthathelyɨ. Sareꞌ dareꞌnesɨ. Gamɨreraavɨ kumɨre kayaaꞌnanya jɨpalasɨꞌnojɨ padaihasamaaradeꞌna ‘Jizaazala (Padaihasamaaꞌdela),’ duthathelyɨra,” mamaayai wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kɨgaakuna Naangei pɨropetɨyarɨ (Gotɨyarɨ wɨꞌnawɨjɨwaakaderɨ) kujaaꞌ sai pɨkarya yɨdayaaꞌ. Gotɨyai “Sareꞌ yunebanna yɨmaꞌnana!” kadaꞌ Maarɨyaaꞌ kaimɨraavɨmunnakeꞌ yɨmaꞌnaꞌ. Pɨropetɨyare yagaalya dara dɨnɨꞌ ");
INSERT INTO byr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Yɨthaanyi, sɨdɨraayaꞌ aꞌmwelyɨ myeꞌmwannaryaꞌ Kaimɨraavɨmunya wannyɨna yojɨ Kaimalei maarɨna yadelyɨ. Gannya yayaꞌ ‘Yɨmanyɨwelɨma,’ wɨdɨpɨꞌdei.” Yayavɨ aaya kaavɨlyaꞌ daresɨ. Gotɨyai nemɨjɨ yeꞌmwannemwaaihonoyaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jozepɨyai waja yaꞌnaka dɨkaaꞌna yaka Naangere mamaayai wɨdakabaaibɨꞌ sara yaꞌ. Maarɨyaavɨ maarɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sareꞌ kɨrɨꞌ myeꞌmwannaryaꞌ yune kaimɨraayai maarakegaaꞌna. Maarɨyaaꞌ kamaaraꞌ gamɨre yayaꞌ “Jizaazala,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kingɨyai Erotɨyai Kwaaka Juthɨya maremwaaidɨꞌnyɨ Kwaaka Juthɨya Anga Betɨlemɨ Jizaazarɨ maarakegaaꞌ, yɨthaanyi, aꞌmwe sɨlɨngaamɨnyangɨne sɨduꞌnakera nyɨlariyara Anga Naanga Jeruzaalemɨna byɨꞌmaꞌna yeꞌ. Byɨꞌmaꞌna yeva aꞌmweraavɨ wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Bwaranyai Juyaraavɨ maremwaalyaꞌnei yɨmaꞌnakei gawɨ mwaalɨka? Sareꞌ dareꞌnesɨ. Aꞌmweꞌ kamaaraꞌ nyɨlyai byɨlyɨrɨꞌdeva gamɨre sɨlɨngaamɨnyarɨꞌ kyɨmaꞌnaabaꞌ tɨnna wanganona dɨnyɨna ‘Gamɨnyɨ lotuyaꞌna yɨlaaya yaana!’ Dɨnyɨna yona bɨwona,” wɨdɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Yagaala saꞌ Kingɨya Erotɨyai kadɨka wɨꞌnaka jɨkurya kyaꞌ nabaai Jeruzaalemɨ mwaalyara yuyara yawɨta kwalaalya yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Erotɨyai jɨkurya yaka Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangeraavɨjɨ Yɨzɨrelɨyaraavɨre Kɨwɨjaraavɨjɨ jɨꞌbwaraꞌ. Sahwaraavɨ yɨdaanganaꞌ “Kɨraazɨtɨyarɨ Gotɨyai dahɨlakyaakerɨna yemwaaimanɨgo. Sahwai aaihɨba yɨmaꞌnadelaka?” ");
INSERT INTO byr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sara kyɨdaanganaꞌ wɨdeꞌ “Kwaaka Juthɨya Anga Betɨlemɨ sahɨba yɨmaꞌnadelyɨ. Sareꞌ dareꞌnesɨ. Gotɨyarɨ wɨꞌnawɨjɨwakyaakei pɨropetɨyai dara yavɨkaryaꞌ ");
INSERT INTO byr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betɨlemɨ angebagɨ Jutharaavɨre kwaakevɨ sabagɨ Maalɨkebagɨ kɨrɨꞌ anga pɨbanyaavɨ naangebagɨnyɨ. Gɨmɨnyɨdaaꞌnyɨ Aꞌmwe Naangei yɨmaꞌnadelyɨ. Sai nɨmɨre Yɨzɨrelɨyaraavɨ maremwaaladelyɨ. Sareꞌna anga pɨbanyaavɨ davɨlaꞌdevagɨnyɨ.’ ” Sara wɨdeꞌ Gotɨyare bukuya kunnakera. ");
INSERT INTO byr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dɨvidaaꞌnyɨ Erotɨyai sɨlɨngaamɨnyangɨ sɨduꞌnakeraavɨ kave wɨjɨvwaramaaꞌna. Miꞌna wɨjɨvwaramaaꞌna yaka nayaa yɨdaanganna “Sɨlɨngaamɨnya saꞌ behaaꞌ yɨmaꞌnaka?” Yɨdaanganna kyaꞌ sareꞌ wɨdeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wɨdesagaaꞌ Erotɨyai Betɨlemɨna wɨdaasɨna yaꞌ. Nabaai wɨdaꞌ “Dɨwila! Kaimalerɨna dɨvɨraawila! Tɨvɨ bɨramaarapɨjɨ dɨnyɨjideihɨlyɨra. Kanyɨdapɨjɨ yɨlaaya yɨdeꞌna wɨdeinyɨ.” Kwaasɨ sara wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kingɨyarɨ kadɨka wɨꞌneva Betɨlemɨna wɨna. Wodɨvɨꞌ yɨthaanyi, sɨlɨngaamɨnyarɨꞌ nyɨlarimagɨ tɨnna wanganesarɨꞌ ayɨna tɨnna wanganna yeva sɨlɨngaamɨnyarɨꞌ mɨdɨnna yeꞌ. Sɨlɨngaamɨnyarɨꞌ sɨnnawɨ woda angevɨ kaimalei mwaaidɨꞌnyɨyaba lɨvamudaꞌna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Lɨvamudaꞌna yadɨꞌnyɨ sareꞌ yɨlaaya wana naanga yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yɨlaaya naanga yɨna yeva angevɨ wɨlɨna yeva kaimalelyɨ Maarɨyaaꞌ ganaangesɨ sanaarɨ tɨnna wanganna. Tɨnna wanganna yeva kwadaai gɨlɨna yeva kaimalerɨ lotuyaꞌna yɨlaaya yeꞌ. Yɨlaaya yevegaaꞌ kumɨre bukusangɨ baasɨna yeva yanga wɨjaavɨna yeꞌ. Nɨgwia golɨyasɨ wabatɨrɨnya winyaꞌnesɨ marazɨnanya dɨragɨnyaꞌ mesɨ yanga wɨjaavɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Wɨjaavɨna yeva pɨba se waꞌmwaꞌna yesara waja yaꞌnyɨna yadaapi Gotɨyai wɨdaꞌ “Erotɨyaryawɨnna nupɨdɨka!” Miꞌna kudaꞌ dɨkaaꞌna yeva tuta pɨrɨvɨ wɨna yeꞌ kunnya angebannera. ");
INSERT INTO byr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wɨna yesagaaꞌ, yɨthaanyi, wajavɨ Naangere mamaaya pwai Jozepɨyarɨ wɨdaꞌ “Dɨkaaꞌna ja! Kaimalelyɨ ganaangesɨ Yɨzɨpɨna lɨkaanya dɨmakwona! Saba dɨmwaaideigɨnyɨ. Nɨmɨ kagɨthaꞌmujɨyagaaꞌna. Sareꞌ dareꞌnesɨ. Erotɨyai kaimɨraayarɨna ‘Tamɨma!’ dozɨ bɨraabathelyɨ. Yarai dɨmakwona!” ");
INSERT INTO byr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sara kudaꞌ Jozepɨyai dɨkaaꞌna yaka sawɨsagaaꞌ Yɨzɨpɨ sabanna kaimalelyɨ ganaangesɨ sawaarɨ makuna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Makuna yaka Erotɨyai kuna mwaalakegaaꞌ Yɨzɨpɨ saba mwaalaꞌ. Erotɨyai mena balakegaaꞌna Jozepɨyai ayɨna bɨna yaꞌ. “Kɨgaakuna Naangeinyɨ nyuꞌnawɨjɨwaakadei yagaala jaakeꞌ yunebanna yɨmaꞌnana!” kadaꞌ ayɨna bɨna yaꞌ. Yagaala dara dɨnɨꞌ “Nyɨbwaalɨvaangerɨ jaka kude Yɨzɨpɨdaaꞌnyai baꞌ.” Sara dɨnɨkeꞌ yunebanna yɨmaꞌnaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Sɨduꞌnakera kwaweꞌ dɨvidaaꞌnyɨ Erotɨyai dara wanganakeꞌ “Ai! Sɨduꞌnakera kwaasɨ nyɨdɨzɨwaimwaasainyɨ daaka! Ayahi mabanyɨjɨwaava!” Sara daka sɨmɨlɨkwibwaꞌnyai yawɨꞌna “Kingɨya gave kwainyɨ mwaalɨdeinyɨra. Kaimalerɨ tamakɨma!” Yawɨꞌna yaka nabaai sɨmunya yawɨꞌna “Nɨmɨnyɨ Sɨduꞌnakera sɨlɨngaamɨnyarɨꞌ gaai bilyɨrɨꞌna yakegaaꞌna nyɨjawalyaadaasaꞌ.” Sara yawɨꞌna yaka gannya malyaraavɨ wɨdaasɨna “Betɨlemɨ sabanna avaalyabanna dɨwila! Saba kaimalera kwarame pɨrɨwaaina yɨmaꞌnɨnɨkeraavɨjɨ dahaasa maalɨkeraavɨjɨ yuyaꞌ dɨramabwakɨrila!” Erotɨyai sara kudaasaꞌ malyara sara yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sara yesavɨna Jeremaayai Gotɨyarɨ wɨꞌnawɨjɨwaakadei yɨdayaakeꞌ yunebanna yɨmaꞌnaꞌ. Dara dɨnɨꞌ ");
INSERT INTO byr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Raama saba kɨnna wɨꞌnɨnɨkesɨ. Kɨnna dɨvanɨgava. Kɨnna bazɨwɨvanɨgava. Rasalaꞌ gawaalɨvavaavɨ kɨnna maredɨvanɨka. Kumɨ mamwaalyɨgasaꞌna gamɨ dara dɨvanɨko ‘Kale naanga nyadaaꞌnyɨ gaimwangeꞌnemɨlɨkaavɨ mwɨꞌnɨwɨnera!’ ” ");
INSERT INTO byr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Dɨvidaaꞌnyɨ Erotɨyai kabalaꞌ, yɨthaanyi, Kwaaka Yɨzɨpɨ wajavɨ Naangere mamaayai Jozepɨyarɨ wɨdaꞌ ");
INSERT INTO byr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Dɨkaavaꞌgɨzɨ kaimɨraayalyɨ ganaangesɨ sawaarɨ Kwaaka Yɨzɨrelɨna dɨmakwona! Sareꞌ dareꞌnesɨ. ‘Kaimɨraayarɨ tamakaana!’ desara miꞌna baleꞌ.” ");
INSERT INTO byr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sara kudaꞌ Jozepɨyai se waraka mwanyavɨ dɨkaaꞌna yaka Kwaaka Yɨzɨrelɨna kaimalelyɨ ganaangesɨ sawaarɨ makabɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kaanna kaanna makabɨna yaka dara wɨꞌnakeꞌ “O, Erotɨyarɨneba gawaalɨꞌ Aakalayaazai Kwaaka Juthɨya maremwaaidei jɨmaꞌnɨwaꞌdɨka!” Sara daka yawɨꞌna “Aakalayaazai Erotɨyaibɨsalyɨ,” yawɨꞌna yaka Jozepɨyai lɨka yaka “Sawɨnna nuwɨdɨka!” dɨna yaꞌ. Miꞌna dɨna yaka sawɨsavɨ waja yaꞌnakeꞌna pɨwɨnna Kwaaka Galɨlinei kaanna wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kaanna wɨna yaka Anga Naazaretɨ saba mwalaawaꞌ. Sarevɨdaaꞌnyɨ Gotɨyarɨ wɨꞌnawɨjɨwaakadɨvɨsara yɨdayaasaꞌ Jizaazarɨna yunebanna yɨmaꞌnaꞌ. Yagaala saꞌ dara dɨnɨꞌ “Pwara ‘Naazaretɨ mwaalyala! Kayaaꞌnanyaraavɨdaaꞌnyala,’ dɨpɨꞌdelyɨ.” Sara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Saba Jizaazai kuna mwaalakegaaꞌ yɨrɨka sangɨ Jonɨ aalyavɨ bavɨtaazɨya yaꞌnei Kwaaka Juthɨya wawɨmaayaba byɨꞌmaꞌna, wɨjɨwaakɨna ");
INSERT INTO byr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mudɨkebwi jawɨramaaka! Sareꞌ dareꞌnesɨ. Gotɨyai Sɨgunyavɨ mwaalɨkei nemaremwaaladeꞌ aya kɨgaaꞌ yɨmaꞌnɨwakeꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sareꞌ dareꞌnesɨ. Sarerɨna Gotɨyarɨ wɨꞌnawɨjɨwaakyai Aazaayai dara dɨnɨꞌ “Wawɨmaayaba pwai maanguraayaꞌ jaka yɨmanɨꞌ. ‘Naangei batherɨne tusaꞌ javadaꞌgalyɨlo! Gamɨre tusangɨ yɨdaꞌna jamakwilo!’ ” Jonɨmɨna sara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kaamelɨarɨlya tinɨkeꞌ baazɨꞌmaꞌnaka munnaanyaꞌ yɨlakelyɨ. Gamɨre wapaaya baarɨnnajɨ aakaraavɨre kwarakejɨ sa nakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Sagaaꞌ Anga Jeruzaalemɨ mwaalyarajɨ Kwaaka Juthɨya anga yuyaba mwaalyarajɨ Aalya Jothanɨ pihɨrɨ pihɨrɨ anga yuyaba mwaalyarajɨ Jonɨmyawɨnna badɨvɨꞌ kadɨka buꞌneꞌ. ");
INSERT INTO byr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kadɨka buꞌneva kunnya kayaaꞌnanya yadɨvɨsa kajalɨkurakeꞌ Aalya Jothanɨyavɨ bavɨtaazɨya yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Perɨzɨyara kwala naangeꞌ Sazuzɨyara kwala naangeꞌ yawɨꞌna “Aalyavɨ bavɨtaazɨya neyana!” yawɨꞌna yeva sara besaraavɨ Jonɨ tɨnna wanganaka maanga wɨdaꞌ “Sarɨmɨ naawɨnaanyaraavɨre kaimɨraayaihɨlyɨ. Gotɨyai sabwine saꞌ kayaaka yɨhyadeihɨlyɨ. ‘Sɨnna tɨkebwi yɨmaꞌnaabatheꞌna lɨkaanya dɨwila!’ aai yɨhɨthɨwaka! ");
INSERT INTO byr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sarevɨdaaꞌnyɨ sarɨmɨ ‘Mudɨkebwi yawɨramaraana!’ dapɨjɨyanna tewaanya jɨla! Sara yapɨjɨ sɨmunya mudɨkebulyɨyaihi yɨsɨla nawɨꞌnyabɨta nayaa sara jideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Sarɨmɨre sɨmunyangɨ dara myawɨpɨna! ‘Evɨraamɨmɨ gyakwalaangeina mwaaihoꞌna Gotɨyai taanga sa mujaayɨ neyadeꞌnanyɨ.’ Sareꞌ mɨka! Yɨhɨthɨma! Gotɨyarɨ aꞌmweraavɨna wɨgainajɨ kwajɨ ‘Sɨla da Evɨraamɨmɨdaaꞌnya kaimɨraayara yɨmaꞌnɨpɨka!’ dazɨ kwajɨ sa kyɨmaꞌnadɨka! Sareꞌ yɨnɨga wiꞌna yannelyɨra. ");
INSERT INTO byr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yɨsa dawaasaꞌne saajɨngeꞌ yɨsangɨ kaavɨlyavɨ miꞌna warɨkabaaibɨꞌ Gotɨyai sarɨmɨnyɨ yɨhyawɨbwaryaꞌnei yemwaalɨka! Sarevɨdaaꞌnyɨ yɨta yuya sɨla nawɨꞌnya myɨꞌnyade dawaasɨna yojɨ dɨkevɨ marasɨꞌna yadengɨ. ");
INSERT INTO byr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Pwara yawɨranganna ‘Sahwara mudɨkebwi jɨvanɨgava!’ yɨhyawɨpɨꞌdeꞌna aalyavɨ bavɨtaazɨya yɨhyɨdeꞌnanyɨ. Sareinyɨ dɨvidaaꞌnyɨ nyɨmɨdɨnɨkei nyavɨlavɨkelyɨ. Dɨragɨnaangelyɨ. Gamɨnyɨna nɨmɨ tewaanyainyɨna mɨꞌ. Wɨdaayadei gamɨre maremwaaidere kwaabɨzɨvɨlyawaai makwode kɨrɨꞌ sara yɨdeꞌna yɨnɨga wiꞌna nawɨꞌnyainyɨ mɨka! Sahwai nawɨꞌnya naangelyɨ. Naangei Kurya Tewaanyarɨ pwaihɨrɨna bavɨtaazɨya yɨhyadelyɨra. Nabaai pwaihɨrɨna dɨkevɨ bavɨtaazɨya yɨhyadelyɨra. ");
INSERT INTO byr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Sahwai saavolɨya parɨnakeꞌ gannya asɨrɨ lɨmwada witɨya yɨlamarasɨꞌna yɨlamarasɨꞌna kyojɨ witɨzɨla bwalaꞌna kyojɨ yagɨnya kɨlaaka kurɨvaarɨya yɨhuta bamakuna kyojɨ sai witɨzɨla witɨzɨlangevɨ marakɨna yojɨ dɨka myɨgaayaꞌnevɨ yagɨnya kɨlaaka kurɨvaarɨya marayɨraꞌna yadengɨ.” ");
INSERT INTO byr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jonɨ aalyavɨ bavɨtaazɨya yaꞌnei Jizaazai Galɨlidaaꞌnyai Aalya Jothanɨyawɨnna bɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sarerɨ Jonɨ wɨdɨna “Aawa, tewaanyaigɨ aalyavɨ bavɨtaazɨya yɨnneigɨnyɨ. Nɨmɨnyawɨnna gara bɨwaa?” ");
INSERT INTO byr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Wɨdɨna kyaꞌ Jizaazai maꞌmaaꞌna “Sabwi aawa. Gɨthɨwɨjaꞌ dɨnyo! Sareꞌ dareꞌnesɨ. Gotɨyai yawɨꞌna ‘Sara yɨkajavwi yɨdaꞌmaraangesɨ.’ Sareꞌna sara yaka! Keꞌbaꞌnanyainyɨ.” Sara kudaꞌ Jizaazarɨ bavɨtaazɨya yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bavɨtaazɨya yakegaaꞌ aalyavɨdaaꞌnyɨ yɨmeꞌnyaꞌbɨꞌ Jizaazai byɨlaawɨna kyaꞌ, yɨthaanyi, Sɨgunyaꞌ mujaangɨna kyaꞌ Gotɨyare Kuryai kwaamɨryaibɨsarɨ tɨnna wanganna. Tɨnna wanganna yadaaꞌnyɨ Kuryai Jizaazarɨ bwalamwaaina yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bwalamwaaina kyaꞌ, yɨthaanyi, Sɨgunyavɨdaaꞌnyɨ maanguraayaꞌ wɨdaꞌ “Sai nɨmɨre Nyɨbwaalɨvaangelyɨ. Sarɨna tewaanna nyɨvuꞌnadelyɨ. Nɨmɨre kurya tewaanya wɨkadɨnyalyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sagaaꞌ Kotɨya Maryadei Jizaazarɨ yaamɨjɨta yaꞌnerɨ aꞌmwamaayaba Kuryai yɨbwarɨdaakuna. ");
INSERT INTO byr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yɨbwarɨdaakuna kyaꞌ sawɨta aꞌmweraare sɨvɨlatɨraalya wavɨlaꞌdaaꞌnyɨ wapaaya manyaꞌ. Wapaaya manyakei mɨjɨka wiaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mɨjɨka wiadaaꞌnyɨ Kayaaꞌnanyaburɨ Walapapalakadei gamɨnyawɨnna bɨna yaka wɨdaꞌ “Gotɨyare Gawaalɨvaangeinyɨ daakajɨ, sɨla sangɨ kudaꞌgɨzɨ bɨretɨya kyɨmaꞌnojɨ dɨna!” ");
INSERT INTO byr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sara kudaꞌ maꞌmaaꞌna yaꞌ “Dara dɨnɨꞌ ‘Bɨretɨya gave najaꞌ kuryarɨ dɨragɨnya wɨjaayaꞌneꞌna mɨꞌ. Aawa. Yagaala gazasaꞌ Gotɨyare maangevɨ wɨdakeꞌ kuryarɨ dɨragɨnya wɨjaayaꞌnesɨ.’ ” ");
INSERT INTO byr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sagaaꞌ anga tewaanyabanna (Jeruzaalemɨna) Kotɨya Maryadei yɨbwarɨmakuna yaka Gotɨyare Angevɨ munyaba yɨlamarɨdaakuna yaka ");
INSERT INTO byr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","wɨdaꞌ “Gotɨyare Gawaalɨvaangeinyɨ daakajɨ, kwaakewɨnna dɨthɨkwosɨka! Sareꞌ dareꞌnesɨ. Dara dɨnɨꞌ ‘Gɨmɨnyɨna Gotɨyai mamaayaraavɨ kudozɨ Sɨlyavɨ gɨmɨre sɨvɨla mala nyamaaꞌdɨka! Sareꞌna asajɨ nayaa maragɨlɨmwabɨka!’ Sara dɨnɨkeꞌna kwaakewɨnna dɨthɨkwosɨka!” ");
INSERT INTO byr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sara kudaꞌ Jizaazai yawɨraka “Saataanɨ Gotɨyare bukuyaꞌ kayaaꞌna marayɨwaka,” wɨdaꞌ “Yagaala pɨrɨꞌ dara dɨnɨꞌ ‘Naangei gɨmɨre Gotɨyarɨ yaamɨjɨ minna! Yune gɨmɨre yawɨsaꞌ yɨjaigɨ dara myawɨꞌdɨnna! “Gotɨyai yaasɨwaꞌna nyɨgaimwagatheinyɨra.” Sara myawɨꞌdɨnna!’ ” ");
INSERT INTO byr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nabaai Kotɨya Maryadei ayɨna yɨbwarɨmakuna yaka mugunyavɨ keꞌmwewɨnna yɨlamarɨdakwaawɨna yaka Kwaaka davakɨ yuyaba maremwaaidɨvɨta yuyajɨ kumɨre byaannyajɨ yɨbwarɨdaakwaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Yɨbwarɨdaakuna yaka wɨdaꞌ “Yuya nawɨꞌnya sa tɨnna wangamanɨgengɨ gɨzaavɨdeinyɨ. Kwadaai gɨlaꞌgi lotuyaꞌna yɨlaaya nyɨmaryɨjaigɨ gɨzaavɨdeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sara kudaꞌ Jizaazai wɨdaꞌ “Saataanɨ, dɨwo! Sareꞌ dareꞌnesɨ. Dara dɨnɨꞌ ‘Naangei gɨmɨre Gotɨyarɨ yɨlaaya dɨmarya! Yɨsaraavɨjɨ sɨlaangeraavɨjɨ yɨlaaya minna! Gotɨyai gaverɨ yɨlaaya ja!’ Sara dɨnɨkeꞌna Saataanɨ dɨwo!” ");
INSERT INTO byr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sara wɨdakegaaꞌ Kotɨya Maryadei yagalyaꞌmaꞌna kyaꞌ, yɨthaanyi, Gotɨyare mamaayara walaabɨna yeva wɨdaayɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jizaazai wɨꞌnyɨna “Kalavuzangevɨ Jonɨmɨ wɨla yɨrakesalyɨ.” Sara wɨꞌnyɨna yaka Kwaaka Galɨlina wɨna. ");
INSERT INTO byr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kwaaka Galɨlina wɨna yaka Anga Naazaretɨ yagalyaꞌmavaka Anga Kaapanɨyamɨna bamwaaina. Kaapanɨyamɨ saba aalɨbumaangevɨ mannɨkeba. Yɨzɨrelɨya yɨsavakaai Sevyulanɨmɨyara Napɨtalaarɨyara yɨsavakaare kwaakevɨ Anga Kaapanɨyamɨ mannɨkebe. ");
INSERT INTO byr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Gotɨyai “Kɨgaaꞌ Aazaayai nyuꞌnawɨjɨwaakadei wɨjaakeꞌ yunebanna yɨmaꞌnana!” kadaꞌ saba mwaalɨna yaꞌ. Dara dɨnɨꞌ ");
INSERT INTO byr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sevyulanɨmɨyaraavɨrebajɨ Napɨtalaarɨyaraavɨrebajɨ, Aalɨbumaangina Aalya Jothanɨyavɨ pihɨrɨ Kwaaka Galɨli Gotɨyarɨ muꞌnyara Anga pimagɨ, ");
INSERT INTO byr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Saba mwaalyara jɨhɨnyavɨ mwaaidɨvɨsara Baaka naangei mena wanganesare. Balyaꞌnebanne aꞌmabaalyavɨ kayaaꞌna mwaaidɨvɨsaraavɨne Yɨrɨka naangeꞌ mena wɨvurakere.” Jizaazai mwaalakebwinajɨ wɨjɨwaakakebwinajɨ sara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sagaaꞌ Jizaazai mwaalaka yagaalyaꞌ gaai wɨjɨwaakɨna. Wɨjɨwaakɨna yada wɨdaꞌ “Kayaaꞌnanyabwi wasɨꞌnaꞌgɨzɨ mudɨkebwi jawɨramaaka! Sareꞌ dareꞌnesɨ. Sɨgunyavɨ mwaalɨkei nemaremwaaladehaaꞌ aya kɨgaaꞌ yɨmaꞌnɨwakeꞌnanyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Galɨli Aalɨbumaangevɨ sahwai kaanya woda Saaimonɨ, Pitai woꞌnɨkelyɨ gamɨre gahwaalaangei Edɨruyalyɨ sadaraarɨ tɨnna wanganna. Sadaraai jawɨnya maaꞌdisaraai aalɨbunyavɨ jawɨgɨlyaꞌ wasɨꞌdiꞌ tɨnna wanganna. Wasɨꞌnagɨleꞌ dareꞌnesɨ. Jawɨnya mwagiꞌnagɨlyaraalyɨ. ");
INSERT INTO byr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tɨnna wanganna yaka wɨdaꞌ “Saraaihi dɨnyɨmɨdɨnaabyi! Jawɨnya maaꞌditabaaibɨꞌ Gotɨyarɨne aꞌmweraavɨ maaryaꞌneraaihɨrɨ yɨhɨzɨwaakɨdeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sara kudaꞌ yɨmeꞌnyaꞌbɨꞌ sadaraai jawɨgɨlyaꞌ yagalyaꞌmaꞌna yagɨla mɨdɨnna yagi. ");
INSERT INTO byr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kaanya sangyɨneba wɨna yaka Sevathiyare gawaalɨꞌ kwaraai Jemɨzalyɨ gamɨre gahwaalaangei Jonɨjɨ kɨdaraarɨ tɨnna wanganna. Sadaraalyɨ kɨrɨnɨmaanga Sevathiyalyɨ sɨpɨyavɨ yɨlamwaaina yeva jawɨgɨlya bɨꞌnyɨna yadaapɨjɨ tɨnna wanganna. Tɨnna wanganna yaka sadaraarɨ jaka wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jaka wɨdɨna kyaꞌ yɨmeꞌnyaꞌbɨꞌ sɨpɨyasɨ kɨrɨnɨmaangelyɨ yagalyaꞌmaꞌna yagɨla mɨdɨnna yagi. ");
INSERT INTO byr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kwaaka Galɨli yuyaba kaanya yamaryada kumɨre lotuangengɨ wɨjɨwɨrina. Yagaala tewaanyaꞌ Gotɨyai nemaremwaalyaꞌneꞌ wɨjɨwaakɨna. Sarei aꞌmweraavɨ nabalya ge gejɨyaraavɨjɨ yɨrɨka mwaaidɨvɨsaraavɨjɨ tewaanya yavadaꞌgaina yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sara tewaanya yakerɨna Kwaaka Naanga Sɨrɨya yunebanna dɨwɨna yeꞌ. Miꞌna dɨwɨna yesaꞌna nabalɨnakeraavɨjɨ nalaaya ge gejɨyaraavɨjɨ daanga naanga wɨvɨderaavɨjɨ yɨmaka widɨvɨsaraavɨ bɨꞌbɨta yadɨvɨꞌ walaꞌdaawadɨvɨsaraavɨjɨ yagɨnya bainɨkeraavɨjɨ makabɨna yeꞌ. Makabɨna kyeꞌ tewaanya yavadaꞌgalaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tewaanya kyavadaꞌgalaꞌ Galɨlidaaꞌnyarajɨ Anga Atɨraalyabadaaꞌnyarajɨ Anga Jeruzaalemɨdaaꞌnyarajɨ Kwaaka Juthɨyadaaꞌnyarajɨ Aalya Jothanɨyavɨ pihɨrɨdaaꞌnyarajɨ yɨkabɨna yeva kwala bwaꞌnaanya naanga mɨdɨnna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aꞌmwe kwala naange yɨkabɨna yadaapɨjɨ Jizaazai tɨnna wanganna yaka mugunyavɨ yɨlaawɨna yaka saba walamwaaina kyaꞌ gamɨre mɨdɨdɨvɨsara gamɨnyawɨnna bɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Bɨna kyeꞌ gaai dara wɨjɨwaakɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkera Gotɨyarɨna dara yawɨꞌdɨvɨsara ‘Nemɨ maalɨkemɨlɨkane. Nemɨre kuryara dɨragɨnyara mɨꞌ.’ Sareraavɨ Sɨgunyavɨ mwaalɨkei maremwaaladeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkera kale wiadaaꞌnyɨ kayaaꞌnanyanna kɨnna dadɨvɨsara. Gotɨyai kumɨre sɨmunyangɨ dɨragɨnna yɨvaimwagadeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkera kwaamuꞌnanyara sɨmɨlɨka yarai mwɨlyɨ yadera Gotɨyai yawɨꞌna ‘Sahwaraavɨ tewaanya yuya Kwaaka yuya wɨjaavɨdeinyɨ,’ yawɨꞌna yakei wɨjaavadeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkera, aꞌmwera wapaayajɨ aalyasɨ mɨjɨka wiadevaaibɨꞌ aꞌmwera ‘Gotɨyai nemɨnyɨna “Yɨdaꞌmaraangeihi nɨmɨreihɨlyɨ,” yawɨrana!’ yawɨꞌmanɨgasara. Munya widevaaibɨꞌ Gotɨyai gamɨrebwi wɨjaavadeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkera aꞌmwe pwaraavɨna kale wɨgaimwadɨvɨtara. Pwara tewaanna yadɨvɨsaraavɨnajɨ kayaaꞌna yadɨvɨsaraavɨnajɨ kale wɨgaimwadɨvɨsara. Sareraavɨna Gotɨyai kale wɨgaimwagathei tewaanya wiadeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkera, Gotɨyarɨna sɨmunya pɨrɨꞌnanyara bɨꞌdɨvɨsara. Sarera Gotɨyarɨ bɨramaapɨꞌdeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkera, Gotɨyarɨna yuya maimaanga sabwi yɨgapalakadɨvɨsara. Gotɨyai sahwaraavɨ ‘Nɨmɨre nyɨbwaalɨvaangeigɨnyɨra,’ wɨdatheꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkera, tewaanya yɨdaꞌmaraangebwi mɨdɨbɨzara dazahɨrɨvɨ taanginyaꞌ maapɨnera. Sareraavɨ Sɨgunyavɨ mwaalɨkei maremwaaladeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Yɨlaaya yadɨvɨꞌ tewaanaanga yɨhinɨkeihi, nabaai gɨmɨnyɨ pwara tɨnna gwangadɨvɨꞌ nɨmɨnyɨ nyɨmɨdɨdɨnyaꞌna bɨrala gɨthadɨvɨꞌ gɨhaꞌmɨjamaryadɨvɨꞌ yagaala kayaaꞌnanya dala pɨnɨnna pɨnɨnnanya kwaasɨ gɨthɨpɨꞌdeigɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sareꞌna Sɨgunyavɨ yanga naangeꞌ gɨrɨvɨkɨsaꞌ gɨmɨnyɨna gyemwaalɨkeꞌna yɨlaaya ja! Sareꞌna gɨmɨ munyɨꞌ nayaa gaimakunna maremwaalaꞌgi yɨlaaya naanga ja! Sareꞌ dareꞌnesɨ. Sɨnnawɨ Gotɨyarɨ wɨꞌnawɨjɨwaakadɨvɨsara gaꞌmɨjamakwawevera Sɨgunyavɨ yangeꞌ tɨvɨkɨta nawɨꞌnyaꞌ maryaatabaai gɨmɨ tɨvɨkɨta naangeꞌ dɨmaaꞌdeigɨnyɨra. Sareꞌna yɨlaaya naanga ja! ");
INSERT INTO byr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Gɨmɨ Kwaakevakɨyaraavɨre saalyaigɨnyɨra. Saala wapaayangɨ waburya wiadevaaibɨꞌ aꞌmwe davakɨyara gɨmɨnyɨ tɨnna gwanganapɨjɨ tewaanyabwi yawɨpɨneigɨnyɨra. Sareꞌ kɨrɨꞌ saala waryaanya yɨmaꞌnajaꞌ waburya ayɨna gara yɨmaꞌnadevaka! Saala sasareꞌ wapaayangɨna waburya mi yannesɨ. Saala sasareꞌ yɨnahu marasɨꞌna yadɨvɨꞌ kumɨre sɨvɨlyasɨ paihɨꞌdɨvɨsasɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Gɨmɨ Kwaakevakɨyaraavɨne dɨꞌbaakeigɨnyɨ. Mugunyavɨ anga pɨrɨꞌ yɨlamannɨkeꞌ lɨka yulyaranneꞌ mɨꞌ. Aawa. Wannadesɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aꞌmwera laamɨvananyarɨ dɨkeꞌ yewɨtaꞌdɨvɨꞌ maaꞌgulyavɨ amwi wɨlakadɨvɨꞌ mɨꞌ. Aawa. Yɨꞌbɨnyavɨ aꞌbadaaꞌnyɨ munyaba yɨlakadɨvɨkɨ. Sareꞌ aꞌmwe angevɨ mwaaidapiyaraavɨ wanyɨwanya wiadesɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Sarevɨ dɨꞌbaakeigɨ aꞌmwera tɨnna nayaa wangabɨꞌdeꞌna tewaanyabwina nayaa ja! Tewaanya yuyabwi yadaaꞌgɨzɨ tɨnna gwanganapɨjɨ Gɨmaamaanga Sɨgunyavɨ mwaalɨkerɨna yawɨrapɨjɨ yɨlaaya yɨna yadɨvɨꞌ gamɨnyɨ yayaꞌ munyaba makibɨꞌdelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","‘Pɨropetɨyara Gotɨyarɨ wɨꞌnawɨjɨwaakadɨvɨsaraavɨre yagaalyajɨ Ne Mozɨzare Kɨwɨnyasɨ dɨnɨkenna marasɨꞌnadei dɨngaka?’ Nɨmɨnyɨna sɨmunya sara nyawɨꞌdɨka! Nɨmɨ marasɨtaꞌneinyɨ bɨweinyɨ mɨka! Aawa. ‘Nɨmɨ yagaala sanne yunebanna yɨmaꞌnyaꞌneinyɨ bɨweinyɨ.’ ");
INSERT INTO byr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sareꞌ dareꞌnesɨ. Nebulyaꞌna yɨhɨthɨvanɨge. Sɨgunyasɨ Kwaakesɨ aaya yɨmaꞌnadehaaꞌna pɨkarya maalɨka aane pɨmɨlɨꞌ kɨmɨlɨꞌ myagalyaꞌmayɨ yadesɨ. Nabaai Kɨwɨnyavɨre maalɨka aane pɨmɨlɨꞌ kɨmɨlɨꞌ yɨwawodeꞌ mɨꞌ. Arɨkewɨ. Yagaala sangɨ kaavɨlyaꞌ tɨviꞌna yɨmaꞌnadehaaꞌna sa miꞌnanya yɨwawadengɨra. ");
INSERT INTO byr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sarevɨdaaꞌnyɨ Kɨwɨnyavɨre yagaala maalɨka saꞌ aꞌmwe pwai marasɨꞌnajaꞌ aꞌmwe pwara kwaraavɨ wɨjɨwaakadelyɨ ‘Sasara minnera!’ Aꞌmwe sarerɨ Sɨgunyavɨ mwaalɨkei maremwaalade kwai aꞌmwemɨlɨꞌ mwaalademɨlɨkɨ. Aꞌmwei Kɨwɨnyaꞌ mɨdɨnajai aꞌmwe pwara kwaraavɨ wɨjɨwaakajai mɨdɨnyaꞌna, sahwai aꞌmwe naangei mwaaladelyɨ Sɨgunyavɨ mwaalɨkei maremwaaladevɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sareꞌ dareꞌnesɨ. Yagaala da gɨthɨvanɨge. Kɨwɨnya wɨjɨwaakadɨvɨsaraavɨrebulyɨ Perɨzɨyaraavɨrebulyɨ sabwi gɨmɨre yɨdaꞌmaraangebwi mwavɨlayɨ yɨjaigɨ Sɨgunyavɨ mwaalɨkei maremwaaidevɨ dulaadeigɨ mɨꞌ. Arɨkewɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Gɨmɨ kadɨka mena wɨꞌnagɨ yagaala dathaꞌ Ne sɨnnawɨnyara maaresavɨ. Aꞌmwerɨ maramakɨnna! Aꞌmwe pwai aꞌmwe pwarɨ tamakajaꞌna sai kotɨya wɨmaryɨpɨꞌdelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nebulyaꞌna dɨnɨkeꞌ nɨmɨ sainyɨ gɨthɨvanɨge. Aꞌmwe gazaizai gyaꞌmwerɨna sɨnna tɨka wɨdavajai, nabaai sahwarɨ kotɨyaꞌ wɨmaryɨpɨꞌdelyɨ. Nabaai, aꞌmwe pwai gyaꞌmwerɨ bɨrala wɨdazai kotɨya naangeꞌ wɨmaryɨpɨꞌdelyɨ. Nabaai, aꞌmwe pwai ‘Gɨmɨ yɨmaka aaꞌnaaꞌneigɨnyɨ,’ wɨdazai Dɨka Naangevɨ naawadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Sarevɨdaaꞌnyɨ pɨgaaꞌ gɨmɨ ‘Gotɨyarɨ wɨjaavɨma nɨmɨre kayaaꞌnanya marasɨꞌnyaꞌneꞌ!’ daꞌgɨzɨ sareꞌ wɨjaayaꞌneba makabaꞌgɨzɨ dara jawɨꞌdeꞌ ‘O, nyaꞌmwerɨna yagaalya kɨnɨnnakeinyɨ dahayɨnɨgena!’ ");
INSERT INTO byr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Sara daꞌgɨzɨ Gotɨyarɨ wɨjaayaꞌneba gɨmɨre yovɨravamakabɨzaꞌ wakaꞌgɨzɨ jaꞌmweryawɨnna jɨꞌmavaawa! Jaꞌmwelyɨ yagaalyaꞌ mena yavadaꞌgalaꞌgɨzɨ sagaaꞌ gɨmɨre yovɨraꞌdɨzaꞌ Gotɨyarɨ duzaadesɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Pwai gɨmɨnyɨna ‘Kotɨya marima!’ kadozɨ yarai yavadaꞌgainyɨna jideraaihɨlyɨ. ‘Sahwai yawɨbwaꞌderyaba nanyɨmarakadɨka! Nabaai, yawɨbwaꞌdei nyɨmaarojɨ pɨlɨzɨmaanyaraavɨ nanyɨmarɨmwangadɨka! Pɨlɨzɨmaanyara kalavuzangevɨ nanyɨmwaaihɨpɨdɨka!’ jawɨka! ");
INSERT INTO byr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nebulyaꞌna gɨthɨvanɨge. Gotɨyarɨne sareigɨ kayaaꞌna yagɨnebwina yuya mamubyaꞌgɨzɨyagaaꞌna kalavuzavɨ jahalyaꞌmaꞌdeigɨ mɨka! ");
INSERT INTO byr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Sɨnnawɨ dɨnɨkeꞌ kadɨka mena dara wɨꞌnɨvanɨgɨ. Aꞌmwe pwarevɨ ata malɨmwadɨnnera! ");
INSERT INTO byr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sahɨrɨꞌna dara gɨthɨvanɨge. Aꞌmwe gazaizai tɨnna banganaꞌna yajaꞌ ‘Aꞌmwevɨ ata lɨmwamwɨjainyɨ!’ yawɨꞌda gannya sɨmunyavɨ mena ata lɨmwamwakelyɨra. ");
INSERT INTO byr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Sareꞌna gɨmɨre aangasɨmagɨnya tɨnnyai banganaꞌdɨzɨyai kayaaꞌnanyabwina kagɨmwagiꞌnojɨ jɨwaꞌmwagasɨꞌna jɨtheigɨnyɨ. Sareꞌ dareꞌnesɨ. Kɨlaaka yuyajɨsɨyaigɨnyɨ Dɨkevɨ maragɨlɨvaramajaꞌna kayaaꞌnanyasɨ. Kɨlaaka pimagɨnya pɨjɨꞌ maayaigɨ mwaaidɨzaꞌna tewaanyasɨ. Sareꞌ daresɨ. Tɨnnyai jɨwaꞌmwagasɨꞌnyaꞌneꞌ daanga wɨvɨnyasɨ. Kɨrɨꞌ Dɨkevɨ wɨyaꞌneꞌ kayaaꞌnanaangesɨ. Sarevɨdaaꞌnyɨ aꞌmwengɨna nyawɨꞌdɨka! ");
INSERT INTO byr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nabaai, gɨmɨre aangasɨmagɨnya asi kayaaꞌnanyaburɨ givwarɨdaakwajai dapalasɨꞌna ja! Sareꞌ dareꞌnesɨ. Kɨlaaka yuyajɨsɨyaigɨnyɨ Dɨkevɨ maragɨlɨvaramajaꞌna kayaaꞌnanyasɨ. Kɨlaaka pimagɨnya pɨjɨꞌ maayaigɨ mwaaidɨzɨyaꞌna tewaanyasɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kɨgaakuna dara dɨnɨkesɨ. Aꞌmwei gannya aꞌmwevɨ wɨdaasajai kwala maaryaꞌ yesɨmaꞌnya yaꞌne pɨkarɨyɨkwia wɨjaavojɨ wɨdaasadesɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Dɨnɨka kɨrɨꞌ nɨmɨ gɨthɨvanɨge. Gɨnnya aꞌmwevɨ mudaasɨnnera! Aꞌmweꞌ pwarɨ maridaayɨ yajaꞌ gazaizai kudaasojɨ aꞌmwe pwarɨ maaꞌnajaꞌ gannya aꞌmwevɨna Gotɨyai yawɨꞌna ‘Aꞌmwe saꞌ ata lɨmwamanɨkesɨ. Sare kɨrɨꞌ gannya aꞌmwei yɨwetawakyaꞌ gamɨresɨ.’ Nabaai aꞌmwe pwarɨ maaꞌnajai mudɨkei savɨ ata lɨmwagathelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yagaala pɨrɨꞌ Ne sɨnnawɨnyaraavɨ wɨjaakeꞌ gɨmɨ kadɨka mena dara wɨꞌnɨvanɨgɨ. Gotɨyarɨna yagaala dɨragɨnyaꞌ ‘Nyɨgɨvɨna!’ wɨdɨzaꞌ majesɨmaꞌdɨnna! Aawa, yuya wɨdɨzaꞌ Gotɨyarɨna sasara ja! ");
INSERT INTO byr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Dɨnɨkeꞌna kɨrɨꞌ nɨmɨ gɨthɨvanɨge. ‘Sara yɨdeinyɨ,’ nebwina wɨdɨzaigɨ savɨna yagaala dɨragɨnyaꞌ sasara mudɨnna! Aangyagaala kave duthana! Dara mudɨnna! ‘Sɨgunyaꞌ nebulyaꞌna warɨkabaaibɨꞌ gɨthɨwɨjaꞌ nebulyaꞌna gɨthɨvanɨge.’ Sara mudɨnna! Sɨgunyavɨ Gotɨyai yɨlamwaaida maremwaalɨkebanneꞌna yaasɨwaꞌna sara mudɨnna! (Gɨmɨreba daa!) ");
INSERT INTO byr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yagaala pɨrɨꞌ nebulya yɨvaimwangeꞌna Kwaakevakɨna mudɨnna! ‘Kwaakevaꞌ dɨragɨnyaꞌ warɨkeꞌna nɨmɨre yagaala nebulyaꞌ gɨthɨvanɨge!’ Kwaaka davaꞌ Gotɨyare sɨvɨlyaꞌ paihɨremwaaidevanneꞌna sara mudɨnna! Nabaai Anga Jeruzaalemɨna yaasɨwaꞌna mudɨnna yagaala pɨrɨvɨ nebulya yɨvaimwagyaꞌneꞌ! Jeruzaalemɨ saba yuyangɨ Maremwaaidere angebanneꞌna sara mudɨnna! ");
INSERT INTO byr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yagaala pɨrɨꞌ dɨragɨnya yɨvaimwagyaꞌneꞌna mudɨnna gɨmɨre mɨnyagɨnyavɨna! ‘Nɨmɨre mɨjasajɨꞌ yaaka wannana!’ daꞌgɨzɨ yaaka yɨmaꞌnadezɨꞌ daa! ‘Nɨmɨre mɨjasajɨꞌ jɨhɨnya wannana!’ daꞌgɨzɨ jɨhɨnya yɨmaꞌnadezɨꞌna daa! Aawa! Wawɨnya Gotɨyaresɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sareꞌna aangyagaala duthana! ‘Tewaanyasɨ,’ daꞌgɨzɨ ‘Yayo,’ duthana! ‘Yɨdeinyɨ mɨꞌ,’ daꞌgɨzɨ ‘Aawano,’ duthana! Sasare sabwi wiꞌnanyɨ. Yagaala saꞌ mɨjeꞌmwamwɨya yadɨnya Kayaaꞌnanyai gɨzɨwaakadengɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yagaala pɨrɨꞌ wɨjaakeꞌ kadɨka dara wɨꞌnɨvanɨgɨ. Aꞌmwe pwai pware tɨnnyarɨ karamajɨwaꞌmwagozɨ gamɨre tɨnnyarɨ dɨramajɨwaꞌmwagyɨla! Nabaai pware maangerɨꞌ kalɨvɨkɨrojɨ sarerɨ maangerɨꞌ dɨlɨvɨkɨryɨla! ");
INSERT INTO byr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sareꞌ kɨrɨꞌ nɨmɨ dara gɨthɨvanɨge. Aꞌmwei kayaaꞌna kagyozɨ tɨvɨkɨta minna! Aawa. Aꞌmwe pwai maangwɨdaanyaba kagɨramojɨ mɨnya mamaaꞌdɨnna! Aawa! Nayaa ja! Maangwɨdaanya pimagɨ tamyaꞌna duzaadeꞌna yawɨrannelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pwai gɨmɨnyɨna yawɨꞌna ‘Sahwarɨ kotɨyaꞌ yaꞌmujɨ gamɨre baazɨꞌmaꞌnyaꞌ maarɨdeinyɨ.’ Sara yawɨꞌna yajarɨ yɨvɨsasɨ duzaadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aꞌmwe naangei dɨragɨnna dazai ‘Nɨmɨre gɨlyɨvɨsa esaba dɨmakɨlaawa!’ Dazare gɨlyɨvɨta saamɨnyabanna dɨmakɨlaawadeigɨnyɨ. Sara Gotɨyareigɨ yɨnneigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pwai kagithaanganojɨ ‘Saꞌ dɨnyɨmaryaama!’ ‘Nɨgwia dɨnyɨmaryaama!’ sarɨna yanga wɨjaavɨna jɨthelyɨ. Nabaai aꞌmwei kagɨthozɨ ‘Yaamata nyɨjaama!’ sahwarɨna buleꞌna mujaavɨnna! Yarai duzaama! ");
INSERT INTO byr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yagaala pɨrɨꞌ wɨjaakeꞌ kadɨka wɨꞌnɨvanɨgɨ dara dɨnɨkeꞌna. Jaꞌmwerɨna kale gyana! Yɨkamaangerɨna sɨnna tɨka gɨthavana! ");
INSERT INTO byr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sara dɨnɨka kɨrɨꞌ nɨmɨ gɨthɨvanɨge. Gɨmɨre yɨkamaangerɨna kale gyana! Kayaaꞌna gyadɨvɨsaraavɨna wɨgaimwangeꞌna Gotɨyarɨ dara duthana! ‘Sahwaraavɨ tewaanya dɨmwaaihya! Tewaanna dɨwia!’ ");
INSERT INTO byr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Sara yɨjaigɨ ‘Nɨmaamaanga Sɨgunyavɨ mwaalɨkere kaimɨraayainyɨ yɨmaꞌnɨma!’ dadɨ yɨnneigɨnyɨra. Gotɨyai nyɨlyarɨ sara wɨdadaaꞌnyɨ nyɨlyai aꞌmwe kayaaꞌnanyaraavɨre wawɨnyangɨjɨ tewaanya kwaraavɨre wawɨnyangɨjɨ sara wɨdɨvanɨkabaaibɨsasɨ. Gotɨyai burɨkeꞌ sara wɨdadaaꞌnyɨ aꞌmwe yɨdaꞌmaraanga yadɨvɨsaraavɨrengɨnajɨ yɨdaꞌmaraanga myadɨvɨsaraavɨrengɨnajɨ burɨkeꞌ sara pɨvanɨkabaaibɨsasɨ. ");
INSERT INTO byr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sareꞌ dareꞌnesɨ. Aꞌmwe gɨmɨnyɨ tewaanna gyadɨvɨta gaveraavɨ tewaanna yɨjaꞌna Gotɨyai tɨvɨkɨta nawɨꞌnyaꞌ gɨzaavadeꞌ daaka! Yɨthaa, taakɨzɨya maaꞌdɨvɨsara kayaaꞌna yadɨvɨsara avaaina sara yadɨvɨsarera. Sahwaraavɨrebwi davɨlaka! Gotɨyai sara yadevaaibɨꞌ aꞌmwe yuyaraavɨ tewaanna dɨwia! ");
INSERT INTO byr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jaꞌmwe gaveraavɨ ‘Nyaꞌmweigɨ!’ dadɨ yɨlaaya wɨmarijaigɨ pwaraavɨrebwina davɨlaꞌdeigɨ daa! Aawa. Ajɨmya Pɨnɨngɨyara Gotɨyarɨ malɨmwagyadɨvɨta kwarajɨ sara yadɨvɨsare. Yuyaraavɨ yɨlaaya dumarya! ");
INSERT INTO byr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sarevɨdaaꞌnyɨ Gɨmaamaanga Sɨgunyavɨyai nayaa yɨdaꞌna yadevaaibɨꞌ gɨmɨ kwaigɨ tewaanyaraavɨnajɨ kayaaꞌnanyaraavɨnajɨ tewaanna wiaꞌneigɨ yune nebulyaꞌnanyaigɨ yɨmaꞌnɨnneigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Nayaa jawɨka! Davwi minna! Tewaanya nawɨꞌnyabura dara minnera! Aꞌmwera tɨnna nyangabɨkajɨ! ‘Sai tewaanyalyɨra,’ yawɨpɨkajɨ. Sara minnera! Sara yɨjɨyaigɨnyɨ Gɨmaamaanga Sɨgunyavɨ mwaalɨkei yanga tewaanya gɨrɨvɨkɨranneigɨ mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Sarevɨdaaꞌnyɨ ‘Aꞌmwe gɨlyɨvɨta maayaraavɨna nɨgwia wɨmaryaawɨma!’ daꞌgɨzɨyagaaꞌ nabaai dara dɨzaigɨ ‘Aꞌmwera nyangabɨka!’ aꞌmweraavɨ sɨnnawɨ namarayaasɨdɨꞌ gware makupɨjavaaina! Minna! Sareꞌ dareꞌnesɨ. Aꞌmwe kwaasɨyara yadɨvɨtabaaibɨꞌ lotuangengɨjɨ adukulalyangɨjɨ saba jaka wɨdɨna ‘Yanga nayaa wɨjaavɨma nɨgwɨmaayaraavɨne!’ Sahwara yawɨꞌna ‘Aꞌmwera nɨmɨnyɨna “Aꞌmwe tewaanyalyɨ. Yangelyɨ,” dɨnɨpɨka!’ yawɨꞌna yadɨvɨꞌ sara yadɨvɨkɨ. Nebulyaꞌna gɨthɨvanɨge. Sasareraavɨ wɨmaryɨpɨja saꞌ kumɨre wɨrɨvɨkɨsasɨ. Sasareraavɨ aꞌmwera yɨlaaya wɨmaryɨpɨjaꞌna yanga tɨviꞌna maapɨjaraavɨna Sɨgunyavɨ mwaalɨkei yanga tewaanya wɨrɨvɨkɨrannera mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sasara minna! Aawa. ‘Gɨlyɨvɨta maayaraavɨna wɨmaaryɨdeinyɨ,’ daꞌgɨzɨ yulyaꞌna jɨtheigɨnyɨ. ‘Nyaꞌmwerajɨ angebajɨyarajɨ tɨnna nanyangabɨthɨka!’ daꞌgɨzɨ yulyaꞌna dumaaryɨdevulyɨ. ");
INSERT INTO byr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Lɨka yulyaꞌna jɨthevwi Gɨmaamaangei yawɨꞌna ‘Sahwai tewaanna yɨwakeꞌ aꞌmwera yɨlaaya myɨwaasaꞌna yanga tewaanya wɨrɨvɨkɨrɨdeinyɨ.’ ");
INSERT INTO byr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‘Gotɨyarɨ wɨdɨma!’ daꞌgɨzɨyagaaꞌ aꞌmwe kwaasɨyara wɨdadɨvɨtabaaibɨꞌ nudɨthɨka! Sahwara lotuangengɨ wɨladaaꞌdɨvɨꞌ aꞌmwera tɨnna wanganyaꞌnera Gotɨyarɨ wɨdadɨvɨtare. Sarebwina tewaanya wɨvuꞌnadere. Nabaai tuꞌnyalabɨnyaba daaꞌdɨvɨꞌ ‘Aꞌmweyura tɨnna nyangabɨka!’ dadɨvɨꞌ Gotɨyarɨ wɨdadɨvɨsare. Sasareigɨ myɨmaꞌnɨnna! Nebulyaꞌna gɨthɨvanɨge. Aꞌmwera yɨlaaya wɨmaryɨpɨjaꞌna yanga tɨviꞌna maapɨjaraavɨna yanga tewaanya wɨrɨvɨkɨradera mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sareꞌna aawa. Gɨmɨ ‘Gotɨyarɨ wɨdɨma!’ daꞌgɨzɨyagaaꞌ gaveigɨ angevɨ kusawɨ wɨlaꞌgɨzɨ kaanya tihɨraꞌgɨzɨ Gɨmaamaanga lɨka yulyaꞌdeva mwaalɨkerɨ gaverɨ duthana! Gɨmaamaangei lɨka yulyaꞌdɨnyangɨna tɨnna wangada gɨrɨvɨkɨradelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","‘Gotɨyarɨ wɨdɨma!’ daꞌgɨzɨyagaaꞌ yagaala kwalaalya yaasɨwaꞌna madɨnna! Aꞌmwe Anga Pimagɨnyara Gotɨyarɨ malɨmwagyadɨvɨsara yadɨvɨtabaaibɨꞌ minna! Sareꞌ dareꞌnesɨ. Sahwara yawɨꞌna ‘Yagaala kwalaalya wɨdɨvainaajaꞌ yuya maraadengɨ. Yuya yɨmaꞌnadengɨ.’ Yawɨꞌna yadɨvɨꞌ sara dadɨvɨsare. ");
INSERT INTO byr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sarabɨꞌ myɨmaꞌnɨnna! Sareꞌ dareꞌnesɨ. Gɨmaamaangei gɨmɨnyɨne mena yawɨꞌmwakelyɨ. Sɨnnawɨ yagaala midaanganyɨ kyaꞌgɨzɨ mena yawɨꞌmanɨꞌ gɨhainɨvanɨka yuyanna. ");
INSERT INTO byr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sarevɨdaaꞌnyɨ gɨmɨ Gotɨyarɨ dara duthana! ‘Nenɨmaangeigɨ Sɨgunyavɨ mwaaihɨnyaigɨ, Gɨmɨre yayaꞌ gɨrɨꞌmaayaꞌ yɨmaꞌnana! ");
INSERT INTO byr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nemaremwaaidɨnyagaaꞌ yarai yɨmaꞌnana! Gɨmɨre sɨmunyabwi yunebanna yɨmaꞌnana! Sɨgunyavɨyara gɨmɨre sɨmunya gɨmɨdɨdɨvɨtabaaibɨꞌ Kwaakevakɨyaina gɨmɨre sɨmunya gɨmɨdɨnaana! ");
INSERT INTO byr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yɨrɨka dahaaꞌnena aawapaaya dɨnejaama! ");
INSERT INTO byr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kayaaꞌna neyɨvanɨgasanna marasɨꞌnɨwobaaibɨꞌ Nemɨre yɨwetawakyanna dɨnemarasɨka! ");
INSERT INTO byr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yɨjɨwaala yɨnɨkeba nemɨnyɨ manemakabɨnnera! Aawa, Kayaaꞌnanyai nudathɨwaaladɨkajɨ dɨnevadaihasamaaka! Nemaremwaaidɨnyaigɨnyɨneꞌnanyɨ. Dɨragɨnya aaya kaavɨlyaigɨnyɨneꞌnanyɨ. Byaannyabulyɨyaigɨnyɨneꞌnanyɨra. Yuyagaaꞌ yuyagaaꞌ waragotheꞌnanyɨra. Sahɨrɨsɨra. Nebula naangesɨ.’ Sara duthana! ");
INSERT INTO byr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Dɨnyuꞌnana! Pwara yɨwetawakya gyɨwaasanna marasɨꞌnɨjaꞌna Gɨmaamaanga Sɨgunyavɨyai gɨmɨrenna gɨmarasɨꞌnadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Sahwaraavɨrenna mamarasɨꞌnyɨ yɨjaꞌna Gɨmaamaanga kwalyɨ gɨmɨre yɨwetawakyanna marasɨꞌnyɨna gyathei mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Gotɨyarɨ nayaa yawɨryaꞌneigɨ wapaayanna tɨka manyɨjaꞌ jɨkurya minna! Kwaasɨyara kunnya sɨnnyɨka gwarakuꞌna yadɨvɨꞌ ‘Pwara nyawɨrangabɨka! “Sai sɨnnyɨꞌ mɨjɨkɨlaaꞌna yɨwaka! Sareꞌ Gotɨyarɨna manyadei tewaanyalyɨ,” yawɨpɨka!’ yawɨꞌdɨvɨꞌ yadɨvɨtabaaibɨꞌ minna! Nebulyaꞌna gɨthɨvanɨge. Sasareraavɨ aꞌmwera yɨlaaya wɨmaryɨpɨjaꞌna yanga tɨviꞌna maꞌmwaasaraavɨna yanga tewaanya wɨrɨvɨkɨrannera mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aawa, gɨmɨ Gotɨyarɨna manyaꞌgɨzɨ sɨnnyɨkɨ aalya yɨnaꞌgɨzɨ mɨnyagɨnyavɨ welivananyaꞌ dɨvuꞌnana! ");
INSERT INTO byr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Sara yaꞌgɨzɨ ‘Aꞌmwera “Sai wapaaya manyɨvanɨkelyɨ,” nyawɨrangabɨthɨka!’ daꞌgɨzɨ gɨnnya sɨnnyɨꞌ sara mi. Aawa. Gɨmaamaanga lɨka yulyaꞌdeva mwaalɨkei gavei gɨmɨre lɨka yulyaryaꞌnebwi tɨnna wangada gɨrɨvɨkɨradelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Gɨlyɨvɨta tewaanyanna tewaanyanna mamaryovɨrawakɨnna Kwaaka davakɨ dava! Kwaaka davakɨ maaꞌnyaannyarajɨ napolɨkejɨ gɨlyɨvɨsangɨ kayaaka yɨgaidengɨ. Nabaai kukera kurɨkeꞌ daburalɨvɨꞌdɨvɨꞌ kuka maaꞌdɨvɨsangɨ. Dava sa mamaryovɨrawakɨnna! ");
INSERT INTO byr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Gɨlyɨvɨta tewaanyanna tewaanyanna dɨmaryovɨrawakya Sɨgunyavɨ! Sahɨba maaꞌnyaannyarajɨ napolɨkejɨ gɨlyɨvɨsangɨ kayaaka myɨgalyadengɨ. Nabaai kukera madaburalɨvɨryadɨvɨꞌ kuka myadɨvɨsangɨ. (Tewaanya yuyanna gɨthɨwe sara yaꞌgɨzɨ gɨmɨre gɨlyɨvɨta Sɨgunyavɨya kɨnɨnnakeigɨ dɨmwaaideigɨnyɨ.) ");
INSERT INTO byr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sareꞌ dareꞌnesɨ. Gɨmɨre gɨlyɨvɨta tewaanya mariꞌbwarakɨnɨkeba sahɨba gɨmɨre sɨmunyasɨ warɨkesɨ. (Pwai Sɨgunyavɨ gɨlyɨvɨta tewaanya mariꞌbwarakada sahɨnɨngɨna sɨmunya pɨrɨꞌnanyai mwaaidelyɨ. Gotɨyarɨ yawɨꞌdelyɨ. Sareꞌna gɨthɨwa.) ");
INSERT INTO byr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Tɨnnyai kɨlaakejɨkɨne laamɨvananyaꞌ wannadevaaibɨꞌ aꞌmweraavɨre sɨmunya yawɨꞌdɨvɨsasɨ. Sarevɨdaaꞌnyɨ sɨmunyavɨ nayaa yawɨꞌdɨ yanga nayaa wɨmaryɨjaꞌ laamɨvananya saꞌ nayaa wannade yunejɨkɨra. ");
INSERT INTO byr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Sareꞌ sɨmunyavɨ kayaaꞌna yawɨꞌdɨ yanga nayaa mumaryɨjaꞌ laamɨvananyaꞌ jɨhɨnyaꞌ waꞌdezɨkɨ. Sarevɨdaaꞌnyɨ tɨnnyai jɨhɨnyaꞌ sara yɨmaꞌnajaꞌ gɨmɨre sɨmunya jɨhɨnya naangeꞌbɨꞌ kayaaꞌnanya sa yawɨꞌdɨnneigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Maremwaala pwaraarɨna aane pwai kwai yɨnɨga wiꞌna wɨdaayaꞌnei mɨka! Sareꞌ dareꞌnesɨ. Pwarɨna sɨnna tɨka wɨdavojɨ pwarɨna tewaanna wɨvuꞌnyɨna. Pwarɨ lɨmwanna yada pwarɨ buleꞌna wɨjaavɨna yadelyɨ. Sabaaibɨꞌ avaalyagaaꞌ Gotɨyare wɨdaayaꞌneigɨ yɨmaꞌnyɨna, nɨgwia naanga maaryaꞌneigɨ yɨmaꞌnyɨna jɨtheigɨ mɨka! Nɨgwia naangenna yawɨꞌna yɨjaigɨ Gotɨyarɨ myawɨri. Gotɨyarɨ yawɨꞌna yɨjaigɨ nɨgwia naangenna myawɨri. ");
INSERT INTO byr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Sarevɨ gɨthɨvanɨge. Tewaanya mwaaidɨnyavɨna sɨmunya kwalaalya myawɨꞌdɨnna! Sara yawɨꞌdɨ dɨna ‘Nɨmɨ benɨ nɨwɨneka? Be aalya nɨwɨneka?’ Nabaai gɨmɨre kɨlaakejɨkɨna sɨmunya kwalaalya myawɨꞌdɨnna! Sara yawɨꞌdɨ dɨna ‘Nɨmɨ kannya yɨvɨta benɨ yɨraꞌnɨwɨneka?’ Dɨna myɨnna! Tewaanya mwaaidɨnyaꞌ wavɨlavɨkeꞌ midaaka tɨka wapaaya sangɨ! Kɨlaakejɨꞌ wavɨlavɨkeꞌ midaaka kannya yɨvɨta sangɨ! ");
INSERT INTO byr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yusara munyawɨ pɨlakwodɨvɨsaraavɨ tɨnna dangana! Wapewia mamayadɨvɨtare. Angengɨ wapaaya mamujɨꞌbwarakyadɨvɨtare. Sarera kwaraavɨna Gɨmaamaanga Sɨgunyavɨyai wapaaya wɨjaavadengɨ. Gotɨyai yusaraavɨ nayaa maremwaaidei yawɨꞌdele! Gɨmɨ naangeigɨ midaaka! Yusara yune maalɨkera midaaka! Gotɨyarɨna naangeigɨnyɨra. ");
INSERT INTO byr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sarɨmɨjɨya pwai yawɨta kwalaalya yojɨ ‘Kwarame kwalaalya mwaalɨdeinyɨ,’ dɨragɨnna dozɨ sara yɨmaꞌnadei daaka! Sareꞌna mɨka! ");
INSERT INTO byr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nabaai kannya yɨvɨsangɨna sɨmunya yawɨrɨkwaasaꞌ beꞌna yawɨꞌmanɨgɨ! Kaabidaryaba pwasa waayɨkengɨ tɨnna jawɨrangana! Mɨraagɨkɨꞌna yade mɨꞌ. Baazɨꞌmaꞌnya tidɨvɨta mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sara myadɨvɨta kɨrɨꞌ dara gɨthɨvanɨge. Sɨnnawɨ sagaaꞌ Ne Solomonɨ gannya nɨgwɨlalaaka byaannaka yuya wakakelyɨ. Sareꞌ kɨrɨꞌ nɨgwɨlalaaka nawɨꞌnya maayalyɨ pwasa waayɨka dazabɨsa. ");
INSERT INTO byr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pwasa kaabinnyangɨne nɨgwɨlalaakebɨsa nawɨꞌnya dahaaꞌ waayɨꞌ. Mwanyagaaꞌ kaabinna samɨlɨka ‘Maalɨkesɨra,’ dadɨvɨꞌ davɨna yapɨjɨ dɨkevɨ yɨrapɨꞌdengɨ. Kurɨvaarɨya sasare Gotɨyai pwasa wakada nayaa maremwaalɨꞌ. Sareꞌ ‘Gotɨyai nayaa mamaremwaalyɨ neyadelyɨ,’ yawɨꞌmanɨgɨnyaigɨ nayaa jawɨka! Kurɨvaarɨya sasare Gotɨyai nayaa maremwaalanneꞌna gɨmɨnyɨ gɨvaazɨꞌmakwadeigɨ midaaka! ");
INSERT INTO byr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Sarevɨdaaꞌnyɨ sɨmunya yawɨrɨkwaasaꞌ myawɨꞌdɨnna! Dara nadɨthɨꞌ ‘Nɨmɨ benɨ nɨwɨneka? Be aalya nɨwɨneka? Nɨmɨ kannya yɨvɨta benɨ yɨraꞌnɨwɨneka?’ Sara madɨnna! ");
INSERT INTO byr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sareꞌ dareꞌnesɨ. Gotɨyarɨ malɨmwagyadɨvɨsara ajɨmya yuyangɨyara sɨmudaadaanya yawɨꞌdɨvɨꞌ yuya daza bɨramaaꞌdɨvɨsabulyɨ. Gɨmɨrebwi pɨbulyɨ. Sareꞌ dareꞌnesɨ. Gɨmaamaanga Sɨgunyavɨyai gɨmɨnyɨna mena yawɨꞌmanɨꞌ ‘Sa wɨmudaasɨwaka.’ ");
INSERT INTO byr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sazanna sɨmunya kwalaalya myawɨꞌdɨnna! Sɨnnawɨ Gotɨyai yuyaraavɨ maremwaalade gaveꞌ jawɨka! Gotɨyare yɨdaꞌmaraanga sabwina jawɨka! Sara yɨjaigɨ dɨvidaaꞌnyɨ yuya sa pɨnɨ kɨnɨjɨ gɨzaavadelyɨ. Nayaa gyavadaꞌgalamaremwaaladelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sarevɨdaaꞌnyɨ mwanyagaaꞌnengɨna sɨmunya kwalaalya myawɨꞌdɨnna! Sareꞌ dareꞌnesɨ. Mwanyagaaꞌ puꞌdehaaꞌ sangɨna jawɨꞌdehaakɨ. Dahaasagaaꞌne taanginya warɨꞌ. Sa wiꞌnanyɨ. Mwanyagaaꞌne taanginya yɨmaꞌnadengɨna dahaaꞌ myawɨꞌdɨnna! ");
INSERT INTO byr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Aꞌmweraavɨ yaasɨwaꞌna mamaryawɨbwaꞌdɨnna! ‘Sai kayaaꞌnanyalyɨ,’ kyawɨranganaꞌgɨzɨ Gotɨyai ‘Kayaaꞌnanyaigɨnyɨ,’ gyawɨbwaradeigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sareꞌ dareꞌnesɨ. Pwaraavɨ yawɨbwaꞌdɨzabaaibɨꞌ Gotɨyai avaaina gyawɨbwaradeigɨnyɨ. Aꞌmweraavɨ tɨvɨkɨꞌdɨzabaaibɨꞌ Gotɨyai avaaina gɨrɨvɨkɨradeigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Sareꞌ keꞌbaꞌna gɨthɨma! Gɨmɨre tɨnnyarɨ yɨsavaꞌ gwarɨkeꞌ berɨꞌna myawɨryadɨ jaꞌmwere tɨnnyarɨ yɨtɨrɨdɨrɨnyamɨlɨꞌ banganaꞌmanɨgɨ! ");
INSERT INTO byr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Yɨthaa, gɨmɨre tɨnnyarɨ yɨsavaꞌ gwarɨka kɨrɨꞌ wɨdɨna ‘Yɨtɨrɨdɨrɨnya gɨmarasɨꞌnaabɨma!’ wɨdɨna yaꞌgɨzɨ gathaꞌdara jɨtheigɨnaka! (Gamɨre yɨwetawakya maalɨkemɨlɨꞌ yɨtɨrɨdɨrɨnyamɨlɨꞌbɨsamɨlɨꞌ warɨka kɨrɨꞌ gɨmɨre yɨwetawakyaꞌ naangeꞌnanyɨ.) ");
INSERT INTO byr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kwaasɨyaigɨ, aayagaaꞌ gɨnnya tɨnnyarɨ yɨsavaꞌ yuneꞌna marasɨꞌnaꞌgɨzɨ yɨ dɨvidaaꞌnyɨ jaꞌmwere tɨnnyarɨ yɨtɨrɨdɨrɨnyamɨlɨꞌ marasɨꞌnyaꞌneigɨ gɨmɨre tɨnnyalyɨ nayaa dangadeigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‘Tɨka nanyɨdavadɨka!’ dadɨ jɨlɨkeraavɨna gɨrɨꞌmaaya mujaavɨnnebaaibɨꞌ Gotɨyare yagaala tewaanyaꞌ aꞌmwera ‘Yagaala saꞌ muꞌnaanna!’ yawɨꞌdɨvɨsaraavɨna mujaavɨnna! ‘Yaawaryara sɨvɨla nalɨvadɨvainadaapɨka!’ dadɨ kwaakevɨ gɨnnya kwaalɨka nawɨꞌnyaꞌ mamarasɨꞌnɨnnebaaibɨꞌ Gotɨyare yagaala tewaanyaꞌ aꞌmwera yaawaryarabɨsara ‘Saꞌ yaasɨwaꞌnanyasɨ,’ dɨragɨnna yawɨꞌdɨvɨsaraavɨ mujɨwaakɨnna! ");
INSERT INTO byr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Gotɨyarɨ yaamɨjɨ yɨdaanganyɨ yɨdaanganya kyaꞌgɨzɨ gɨzaavadeigɨnyɨ. Gotɨyarɨ wɨdɨzaigɨ bɨrɨbɨrya yaꞌgɨzɨ dɨvɨramaaꞌdeigɨnyɨ. Gotɨyarɨ wɨdɨzaigɨ kaanyavɨ mala tamaabɨ tamaabya yaꞌgɨzɨ Gotɨyai gɨvasamaraabatheigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sareꞌ dareꞌnesɨ. Gazaizai yɨdaangada maaradeꞌnanyɨ. Bɨꞌdei bɨramaaradeꞌnanyɨ. Kaanyavɨ mala tamaabaderɨ Gotɨyai wɨbasamaraabatheꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sarɨmɨjɨyarɨ gawaalɨvaangei ‘Nɨmwai, gɨrɨkulyaꞌ dɨnyɨmaryaama!’ yɨdaanganajaꞌna ganɨmaangei sɨlyai wɨmaryaabathei dɨngaka! ");
INSERT INTO byr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","‘Nɨmwai jawɨnyaꞌ dɨnyɨmaryaama!’ yɨdaanganajaꞌna naawɨnaanyai wɨmaryaabathei dɨngaka! Sarei baawalaka! ");
INSERT INTO byr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Sarevɨdaaꞌnyɨ gɨmɨ kayaaꞌnanyaigɨ kwaigɨ kɨrɨꞌ gɨnnya kaimɨraayangɨ tewaanya wiadɨnyaigɨnyɨ. Yɨthaa, Tewaanaangei Gɨmaamaanga Sɨgunyavɨ mwaalɨkei yuyaraavɨ wavɨlavɨkei tewaanya wɨjaavade yɨdaangabɨzaraavɨna! Ai, naangaange! ");
INSERT INTO byr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Sarevɨdaaꞌnyɨ ‘Aꞌmwera nɨmɨnyɨna sara yɨpɨka!’ dɨzanna aꞌmweraavɨna dazahɨbwina sara ja! Dazaꞌ Kɨwɨnya dɨnɨkevɨjɨ yagaala pɨropetɨyara Gotɨyarɨ wɨꞌnawɨjɨwaakadɨvɨsaraavɨrevɨjɨ aaya kaavɨlyasɨ. ");
INSERT INTO byr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Tɨkurya pwigalyarɨkɨ dula! Kayaaka yɨgalyaꞌneba Dɨkeyabanne tɨkurya naangaangeꞌ yaka maadaawaꞌnyasɨ. Dɨkeyabanne tutaanya yɨgɨpala yɨnɨgukesɨ. Savɨdaaꞌnyɨ dazahɨrɨvɨ aꞌmwe kwalaalyara wimanaawɨgasarera. ");
INSERT INTO byr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yuyagaaꞌ yuyagaaꞌ mwaalyaꞌnebanne tɨkurya pwigalyarɨꞌ warɨkerɨkɨ. Gaalyaꞌnebanne tutaanyavɨ yagɨyagɨ wɨyaꞌnesɨ. Savɨdaaꞌnyɨ dazahɨrɨkɨ aꞌmwe pwaina pwaina bɨramaaꞌmanɨgasarera. Sareꞌna tɨkurya pwigalyarɨkɨ nayaa dula! ");
INSERT INTO byr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Nayaa jawɨka! Gotɨyarɨna kwaasɨ yagaala wɨjaꞌneraavɨna mala nayaa jɨwannana! Kumɨre kɨlaakejɨka tɨnna wanganaꞌgɨzɨ ‘Sahwara sipɨzipɨyarera. Naangerera nɨmɨnyawɨnna bɨvanɨgasarera,’ yaasɨwaꞌna madɨnna! Yɨ ‘Kɨlaakejɨkɨna sipɨzipɨyara mwaaihata kwara kɨrɨꞌ sɨmunyavɨna kavɨjɨlɨka mɨjɨꞌnanyara mwaaihava,’ gɨthɨwa. Sahwara kayaaka gyɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sahwaraavɨre saburɨna yɨsɨlyabɨꞌ jawɨrangadeigɨnyɨ. Dara jawɨka! Gɨraipɨzɨla namannyulyabaarɨ maaꞌdɨvɨsara daa! Pihɨzɨla yɨta lannakikɨ maaꞌdɨvɨsara daa! Sabaaibɨꞌ kayaaꞌnanyabulyɨyara yagaala nawɨꞌnyaꞌ nayaa gɨzɨwaakɨpɨꞌdera daa! ");
INSERT INTO byr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sasarevɨdaaꞌnyɨ yɨta tewaanya gazɨsɨꞌ yɨsɨla nawɨꞌnya yɨꞌnadikɨ. Yɨta kayaaꞌnanyɨꞌ yɨsɨla kayaaꞌnanya yɨꞌnadikɨ. ");
INSERT INTO byr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yɨta tewaanyɨꞌ yɨsɨla kayaaꞌnanya yɨꞌnadiꞌ mɨꞌ. Nabaai yɨta kayaaꞌnanyɨꞌ yɨsɨla nawɨꞌnya yɨꞌnadiꞌ mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yɨta gazɨsɨꞌ yɨsɨla tewaanya myɨꞌnyadiꞌ dɨkevɨ dapalasɨꞌna yadɨvɨsɨkɨ. ");
INSERT INTO byr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sarevɨdaaꞌnyɨ Gotɨyarɨna kwaasɨ yagaala wɨjaꞌneraavɨre saburɨna jawɨrangadeigɨnyɨ. Kayaaꞌnanyanna yaꞌneraavɨna jawɨka! ‘Gotɨyare yagaala manejɨvanɨgasare!’ ");
INSERT INTO byr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Gazaizai nɨmɨnyɨ ‘Naangeigɨ! Naangeigɨ!’ nyɨdadei Sɨgunyavɨya maremwaaideva wɨlamwaaladei mɨꞌ. Aawa. Aꞌmwei Nɨmaamaanga Sɨgunyavɨ mwaalɨkere sɨmunyabwi mɨdɨnajai yune sahwaina wɨlamwaaladelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sagaaꞌ Yɨrɨka Naanga sarɨkɨ aꞌmwe kwalaalyara dara nyɨdɨpɨꞌde ‘Naangeigɨ! Naangeigɨ! Gɨmɨnne yayaꞌ maarona Gotɨyare yagaala wɨdahoina midaaka! Gɨmɨnne yayaꞌ yɨmaka widɨvɨsaraavɨ dɨragɨnna wɨdona yɨmaka sa wɨdaasɨna yoina midaaka! Gɨmɨnne yayaꞌ dɨragɨnna wɨdona atɨka maruꞌnaryaꞌne sanna yoina midaaka!’ ");
INSERT INTO byr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sara kanyɨdapɨjɨ sahwaraavɨ dara jalɨkurakɨdeinyɨ ‘Yuyagaaꞌ myɨhwanganyadɨnyaihɨlyɨ. Maaveihɨlyɨ. Kayaaꞌna yadɨvɨsaihi kaanna dɨwila!’ ");
INSERT INTO byr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Aꞌmwe gazaizai nɨmɨre yagaala da kadɨka wɨꞌnojɨ mɨdɨnajai sɨmunnakelyɨ. Pwaibɨsalyɨ. Yɨ, sai gamɨre angeꞌ sɨlaangerɨ aꞌbadaaꞌnyɨ yɨlamadakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Dɨvidaaꞌnyɨ burɨka naangeꞌ padaaꞌnyɨ aalyaaka puꞌdaaꞌnyɨ yɨhusa dɨragɨnna yadaaꞌnyɨ yuya sa anga savɨ mɨlyɨtakuꞌna. Mɨlyɨtakuꞌna yaka kɨrɨꞌ mwalaraawiaꞌ. Sareꞌ dareꞌnesɨ. Sɨlaangerɨ aꞌbadaaꞌnyɨ sɨla lɨvalaanna kyaꞌ dɨragɨnna mɨwɨꞌnɨkeꞌna mwalaraawiaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aꞌmwe gazaizai nɨmɨre yagaala da kadɨka wɨꞌnojɨ mamɨdɨnyɨ yajai sɨduꞌmaayalyɨ. Pwaibɨsalyɨ. Yɨ, sai gamɨre angeꞌ siwekevɨ madakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nabaai, burɨka naangeꞌ padaaꞌnyɨ aalyaaka puꞌdaaꞌnyɨ yɨhusa dɨragɨnna yadaaꞌnyɨ anga saꞌ mɨlyɨtakuꞌna kyaꞌ angeꞌ walaraawɨna. Yo, walaraawɨna yaka kayaaka yuna yɨgaina yakesɨ.” ");
INSERT INTO byr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jizaazai yagaala saꞌ mena jɨꞌmwannakegaaꞌ aꞌmwe kwala bwaꞌnaanyara atɨka maruꞌnakulɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Sareꞌ dareꞌnesɨ. Kumɨnyɨ Kɨwɨjara wɨjɨwaakadɨvɨtabaaibɨꞌ mujɨwaakyaꞌ. Aawa, yagaalyavɨ aaya kaavɨlyai dɨragɨnyasɨyai wɨjɨwaakakeꞌna atɨka maruꞌnakulɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mugunyavɨ yagalyaꞌmavaka kaanna walaabɨna yadaaꞌnyɨ kwala bwaꞌnaanya kwalaalyara gamɨre yagaala wɨꞌnesara mɨdɨnna yɨna. ");
INSERT INTO byr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mɨdɨnna yɨna yadaapi, yɨthaanyi, samatanakei gamɨnyawɨ aya kɨbanna bɨna yaka lotuyaꞌna kwaakewɨ walarutaꞌnyɨna yaka lotuyaꞌna kwadaai gɨlɨna yakegaaꞌ wɨdɨna “Naangeigɨ, nɨmɨnyɨna ‘Tewaanya yavadaꞌgaina wima!’ dɨzaꞌna gɨmɨ wikɨra.” ");
INSERT INTO byr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Wɨdɨna kyaꞌ ata dathɨwanna yaka wɨdɨna “Sareꞌ nyɨvuꞌnɨwaꞌ. Maamɨdarya jɨmaꞌnana!” Dazagaaꞌ yɨmeꞌnyaꞌbɨꞌ gamɨre samate yɨwɨna kyaꞌ tewaanyai yɨmaꞌnakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tewaanyai yɨmaꞌnakerɨ Jizaazai wɨdɨna “Dɨnyuꞌnana! Sareigɨ aꞌmwe aane pwai kwarɨ nujɨwaakɨdɨka! Aawa. Gotɨyare Angevɨna yarai wawaꞌgɨzɨ Gotɨyarɨna mubɨthɨka yɨraꞌderɨ gɨnnya kɨlaaka tewaanyajɨꞌ duzɨwainaawɨdeigɨnyɨ. Tɨnna miꞌna kagyɨwarojɨ Gotɨyarɨna wɨjaayaꞌneꞌ Ne Mozɨzare Kɨwɨnyaꞌ dɨnɨkeꞌ sara jɨtheigɨnyɨ. Sara kyaꞌgɨzɨ pwara jalɨkurakɨna ‘Sarei tewaanya yɨmaꞌnɨwaꞌ. Gamɨre samate mena yɨwɨwaka!’ Pwara sara yawɨtaꞌna sara jɨtheigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Anga Kaapanɨyamɨna wɨlaawɨna kyaꞌ Romɨya aawɨlasaraavɨ maremwaalaka pwai bɨna yaka dɨragɨnna buthɨna ");
INSERT INTO byr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Naangeigɨ nɨmɨre yaasɨwaꞌwawɨnyai nalaavɨnakei angevɨ warɨka. Gamɨre yagɨnya yuya mena bainɨkerɨnera. Daanga naanga wɨvɨmanɨkerɨnera.” ");
INSERT INTO byr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sara buthɨna kyaꞌ “Nɨmɨ wawaꞌmujɨ tewaanya yavadaꞌgalɨma!” ");
INSERT INTO byr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wɨdaka kɨrɨꞌ aawɨlasaraavɨ maremwaalakei dara maꞌmaaꞌna “Naangeigɨ, nɨmɨre angevɨna aꞌmwe maalɨkeinyɨrevɨna nulaabɨthɨka! Aawa. Maalɨkinyainyɨ. Gɨmɨ Naangeigɨnyɨra. Sareꞌna yune yagaalyaꞌna kadaꞌgɨzɨ nɨmɨre nyɨdaayadei tewaanya yɨmaꞌnadelyɨra. ");
INSERT INTO byr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gɨthɨweꞌ dareꞌnesɨ. Nɨmɨnyɨ naangera nyɨmaremwaaihasaraavɨ dɨragɨnnakeraavɨ mɨdɨnna yadɨnyainyɨ. Nabaai aawɨlasara pwaraavɨ maremwaaiheinyɨ. Sareinyɨ pwarɨ wɨdɨwɨjaꞌ ‘Gɨmɨ dɨwona!’ sai kaanna wɨna yadelyɨ. Nabaai pwarɨ wɨdɨna ‘Gɨmɨ kaaja!’ sai bɨna yadelyɨ. Nɨnnya yaasɨwaꞌwawɨnyarɨ wɨdɨna ‘Wawɨnya dazaꞌ jɨtheꞌnanyɨ,’ sai wawɨnyaꞌ sara yɨna yadelyɨ. Sareinyɨ gɨthɨwa ‘Sabaaibɨꞌ yune yagaalyaꞌna kadaꞌgɨzɨ nɨmɨre wɨdaayadei tewaanya yɨmaꞌnadelyɨ.’ ” ");
INSERT INTO byr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wɨdɨna kyaꞌ Jizaazai saꞌ kadɨka wɨꞌnaka atɨka maruꞌnaꞌna yɨna yaka aꞌmwera mɨdɨnesaraavɨ wɨdɨna “Nebulyaꞌna yɨhɨthɨvanɨge. Yɨzɨrelɨyai dɨragɨnna lɨmwanga daꞌdarebulyɨya aane pwai kwarɨ mabɨramaaryadɨnyainyɨ. (Romɨ mwaalya dai nɨmɨnyɨna yawɨꞌna ‘Dɨragɨnaangei yune yagaalyaꞌna nalaavɨnakeraavɨ yavadaꞌgaidelyɨ.’) ");
INSERT INTO byr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Sareꞌna yɨhɨthɨvanɨge. Nyɨlyai bilyɨrɨꞌdimagɨdaaꞌnya aꞌmwe kwalaalyara yɨꞌmavaabɨna. Yɨ nyɨlyai walakadimagɨ yɨꞌmavaabɨna. Yɨnasarajɨ saajarajɨ yɨꞌmavaabɨna yɨpɨꞌdere. Maremwaalade Sɨgunyavɨyavɨ yɨꞌmavaabɨna yapɨjɨ tɨꞌmunnevɨ Yɨzɨrelɨyaihɨre Ne sɨnnawɨnyara Evɨraamɨjɨ Aazakɨjɨ Jaikopɨjɨ sarajɨ yeꞌmwannemwaala yɨpɨꞌdere. ");
INSERT INTO byr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sareꞌ kɨrɨꞌ Yɨzɨrelɨyaihi Gotɨyai yɨhɨmaremwaalanne pwaihɨrɨ mwasawɨ jɨhɨnya kewewɨnɨ yɨhɨmarasɨꞌnadeihɨlyɨ. Dazahɨba kɨnna naanga dadɨvɨꞌ maangerɨkaavɨ dɨhɨzɨvainyideihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sara wɨdaka aawɨlasaraavɨ maremwaaiderɨ wɨdɨnana “Gɨnnya angevɨna dɨwona! ‘Nɨmɨre yaasɨwaꞌwawɨnyarɨ yagaalyaꞌna tewaanya javadaꞌgaidelyɨ,’ yawɨꞌmwaanyabaaibɨꞌ sahwai tewaanya sara yɨmaꞌnadeꞌnanyɨ.” Sara wɨdakegaaꞌ sahɨgaaꞌ yaasɨwaꞌwawɨnyai tewaanya yɨmaꞌnaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pitare angevɨ Jizaazai wɨlɨna yaka Pitarɨ ganyaalɨmaangeꞌ nabalɨdɨꞌnakeꞌ waꞌdɨꞌnyɨyavɨ tɨnna wanganna. ");
INSERT INTO byr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tɨnna wanganna yaka gamɨre asɨrɨ dathɨwanna kyaꞌ nabalɨdɨkeꞌ yagalyaꞌmakuna. Sara yagalyaꞌmakuna kyaꞌ daavɨna yaka Jizaazarɨne tɨka wapaaya yovɨrawakɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Sawɨtɨrɨnyaburɨ nyɨlyai walakakegaaꞌ Kwazaakegaaꞌ yɨꞌmwannakegaaꞌ Jizaazaryawɨnna aꞌmwe yɨmaꞌnaka kwalaalyaraavɨ makabɨna yɨna. Makabɨna yɨna kyeꞌ yagaala gaveꞌ yɨmakeraavɨ wɨdaasɨna. Wɨdaasɨna yaka pwara nalaavɨnaka yuyaraavɨ tewaanya yavadaꞌgaina. ");
INSERT INTO byr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Sarevɨdaaꞌnyɨ Gotɨyarɨ wɨꞌnawɨjɨwaakadei pɨropetɨyai Aazaayai kɨgaakuna jaakeꞌ yuneꞌ yɨmaꞌnyɨna. Dara dɨnɨkeꞌ “Gamɨ nemɨre nagaazabwi marasɨꞌmwaꞌ. Nemɨre nabalya yuya makuwaꞌ.” Sara dɨnɨkeꞌ yunebanna yɨna yaꞌ Jizaazai. ");
INSERT INTO byr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kwala bwaꞌnaanya naangeꞌ Jizaazaryawɨnna yɨkabɨna yɨkabɨna yadaapɨjɨ sai tɨnna wanganna yɨna yakegaaꞌ gamɨreraavɨ wɨdɨna “Aalɨbunya kengimagɨnna wawaana!” ");
INSERT INTO byr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Miꞌna kudaꞌ Kɨwɨjai bɨna yɨna yaka wɨdɨna “Wɨjɨwaakyaigɨ, nɨmɨ gɨmɨdɨnamarideꞌnanyɨ kaanya yamarija yuyabanna.” ");
INSERT INTO byr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sara kudaꞌ sai wɨdɨna “Kavɨjɨlɨka maalɨkera kwaakevakɨ daibuꞌnya kɨnɨnnakere. Nabaai sɨgunyavɨne yusara arɨta kɨnɨnnakere. Sareꞌ kɨrɨꞌ Aꞌmweraavɨne Kaimɨraayainyɨ mɨnyagɨnya dɨhaihɨsaꞌneba kuneinyɨ. (Anga se waꞌdɨnyaꞌ kuneinyɨ. Nɨmɨ sareinyɨna ‘Mɨdɨnɨma!’ dɨzaigɨ se waryaba sɨmunya yuneꞌna yawɨraꞌgɨzɨ dɨnyɨmɨdɨnaama!)” ");
INSERT INTO byr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wɨdakegaaꞌ mɨdɨnyaꞌne pwai wɨdɨna “Naangeigɨ, mɨdɨnyaꞌna tewaanyaꞌ dɨngaka nɨnnya nɨmwarɨ tɨviꞌna maralɨkirakaꞌmujɨyagaaꞌna?” ");
INSERT INTO byr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sareꞌ Jizaazai wɨdɨna “Kanyɨmɨdɨnaꞌgɨzɨ manyɨmɨdɨnyadɨvɨsara bainɨkerabɨsara balyaraavɨ sara lɨkirakɨpɨka! Kuna nyɨmɨdɨnaama!” ");
INSERT INTO byr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aalɨbunyavɨ aꞌba sɨpɨyaꞌ warakevɨ sai yɨlamwaaina kyaꞌ gamɨre mɨdɨdɨvɨsara mɨdɨdɨvɨꞌ yɨlamwaaina kyeꞌ aalyavɨ makuna. ");
INSERT INTO byr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aalyavɨ makuna yadaaꞌnyɨ, yɨthaanyi, yɨhuꞌmaanarya naangeꞌ yɨna yaka sɨpɨyavɨ aalɨmavajɨnaaka mɨladathɨvaina yɨna yadaaꞌnyɨ kɨrɨꞌ sai se warɨna. ");
INSERT INTO byr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Se waꞌdɨꞌnyɨ wɨna yeva yɨdɨkaaꞌna yeva yarai wɨdɨna “Naangeigɨ! Dɨnevadaihasamaaka! Yɨwawaadeꞌna yɨwona!” ");
INSERT INTO byr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yarai wɨdɨna kyeꞌ wɨdɨna “Lɨkeꞌ baaꞌna yɨvanɨgava! ‘Gotɨyai nayaa mamaremwaalyɨ neyadelyɨ,’ lɨmwamanɨgasaihi daaka!” Sara wɨdɨna yaka daavɨna yaka yɨhusangɨjɨ aalɨmavajɨnaakengɨjɨ maanga wɨdɨna. Maanga wɨdɨna yakeꞌna yɨhusa myɨna, aalyaꞌ ayahi kave dathɨvaaina yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kave dathɨvaaina kyaꞌ aꞌmwera atɨka maruꞌnakulɨna yeva dɨnyɨna “Aꞌmwe dazai beibɨtalaka? Yɨhusasɨ aalyasɨ gamɨre yagaalyaꞌ nebwi kadɨka yɨna yɨwakeva?” ");
INSERT INTO byr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aalɨbumaangevɨ pimagɨ Gathaara mwaalyaraavɨre kwaakevɨna sai yɨꞌmavaawɨna. Sahɨba aꞌmweraai yɨmakera kɨnɨnnakeraai mwaalɨna. Saraai gɨlekaviꞌnɨnnyaba mwaalɨna. Saraai sɨgyaarya yɨmaꞌnadisaraai mwaalɨna. Sarevɨdaaꞌnyɨ aꞌmwera tutaanya saba kaanya myamaryadɨvɨsare. Sareraai gɨlekaviꞌnɨnnyabadaaꞌnyaraai gamɨnyɨ burataꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Burataꞌnyɨna yagɨla, yɨthaanyi, jaka wɨdanganna “Nemɨnyɨ gara dɨneyɨdeꞌneka! Gotɨyare Kaimɨraayaigɨ, Yawɨbwasagaaꞌ yɨrɨka aayarɨꞌ mavurinanyɨra! Davanna bɨwaanyaꞌ sɨnnawɨ nemɨnyɨ sagaaꞌne daanga wɨjaayaꞌneigɨ davɨwaana! Yɨrɨka sarɨꞌ aawano.” Sara wɨdahi. ");
INSERT INTO byr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sagaaꞌ yaawarya kwalaalya naanga menya kɨbaweba mwaaleva kurɨvaarɨya tɨka nɨdaaꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tɨka nɨdaaꞌnyɨna yadaapɨjɨ yɨmakera Jizaazarɨ dɨragɨnna yɨdaanganna “Nabaai, nedaasɨjaꞌ, yɨ yaawarɨkwala dazavɨ yɨkulaadeꞌna dɨnedaasɨdeigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sara wɨdɨna kyeꞌ Jizaazai wɨdɨna “Kaanna dɨwila!” Yɨthaanyi, sagaaꞌ aꞌmwe saraarɨ yagalyaꞌmaꞌna yɨna yeva yaawaryaraavɨ kusawɨ wɨlɨna yɨna. Wɨlɨna yɨna kyeꞌ, yɨthaanyi, yaawarya yuya dazara kaanyaveꞌna walaawɨna yɨna yeꞌ davaanyaba. Davaanyaba walaawɨna yɨna yeva aalɨbunyavɨ walaraawɨna yeva aalyavɨ baihulaawɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yaawaryara balɨna kyeꞌ sagaaꞌ yaawaryaraavɨ maremwaaidɨvɨsara lɨkaanya wɨna. Sara yeva kumɨre anga naangebanna yɨꞌmavaawɨna yeva yagaala yuya daza wɨjɨwaakɨna yɨna yeꞌ. Aꞌmweraai yɨmaꞌnakeraarɨ yaka sabwina bazɨwɨna. ");
INSERT INTO byr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bazɨwɨna kyeꞌ anga naanga sabanyara Jizaazarɨna bavɨramaaꞌna. Sahwarɨna bavɨramaaꞌna yeva yagaala dɨragɨnna yɨdaanganna “ ‘Kwaaka nemɨre dava yagalyaꞌmavojɨ kwaaka pɨwɨnna kaanna yɨna yana!’ kadɨwo sara ja!” ");
INSERT INTO byr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sɨpɨyavɨ yɨlamwaaina yaka aalɨbumaangebaarɨ pimagɨnna ayɨna wɨna yaka gannya angebanna yɨꞌmavaawɨna. ");
INSERT INTO byr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Miꞌna yɨꞌmavaawɨna kyaꞌ, yɨthaanyi, gamɨnyawɨnna aꞌmwe nalaavɨnaka pwai makabɨna yeꞌ. Aꞌmwe sare yagɨnya yuya bainɨkei yɨꞌbɨnyavɨ warɨbainyɨna yakelyɨ. Makabɨna kyeꞌ sai kumɨre lɨmwangebwi tɨnna yawɨranganna “Sahwara nɨmɨnyɨna ‘Yavadaꞌgalannelyɨ,’ deva makabɨwaava.” Tɨnna yawɨranganna yaka nalaavɨnaka sarɨ wɨdɨna “Kaimɨraayaigɨ, lɨka minnera! Gɨmɨre kayaaꞌnanya marasɨꞌnɨvanɨge.” ");
INSERT INTO byr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yɨthaanyi! Aꞌmwe Kɨwɨja pwara dɨnyɨna “Aꞌmwe dazai kayaaꞌnanya kwaasɨ marasɨꞌnyaꞌnei aꞌmwe kwai kɨrɨꞌ kwaasɨ yawɨꞌna ‘Nɨmɨ Gotɨyainyɨ.’ Sareꞌna Gotɨyarɨ bɨrala wɨdɨwakelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kumɨre sɨmunyangɨ mena yawɨrangada Jizaazai dara wɨdɨna “Sarɨmɨre sɨmunyangɨ kayaaꞌnanyanna beꞌna yawɨꞌmanɨgava! ");
INSERT INTO byr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sareꞌ dareꞌnesɨ. Yagaala naangewaai aꞌmwe darɨ wɨdɨma! Pɨrɨꞌ wɨdɨwɨjaꞌ ‘Gɨmɨre kayaaꞌnanya gɨmarasɨꞌnɨvanɨge,’ pɨrɨꞌ wɨdɨwɨjaꞌ ‘Dɨkaavaꞌgɨzɨ kaanya jamarya!’ Yagaala sawaai naangewaai midaaka! ");
INSERT INTO byr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Sarɨmɨ yawɨramaata jideꞌna yɨhɨzɨwaainɨma! ‘ “Aꞌmweraavɨne Kaimɨraayai dɨragɨnyaꞌ kɨnɨnnakelyɨ. Kwaaka davakɨ wagɨlyaꞌ marasɨꞌnyaꞌne dɨragɨnyaꞌ kɨnɨnnakelyɨ,” jawɨryɨla!’ dena yɨhɨzɨwaainɨma!” Wɨdaka yagɨnya yuya bainɨka sarɨ wɨdɨna “ Dɨkaavaꞌgɨzɨ gɨnnya yɨꞌbɨnyaꞌ maarɨna, gɨnnya angevɨna kaanna makuna jɨ!” ");
INSERT INTO byr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sarei daavɨna yɨna yaka gannya angevɨna kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kaanna wɨna yadaaꞌnyɨ kwala bwaꞌnaanyaꞌ savɨ tɨnna wanganeva lɨka yɨna. Lɨka yevegaaꞌ “Aꞌmwe darɨ dɨragɨnya sasareꞌ wɨjaavadele!” dɨneva Gotɨyarɨne yayaꞌ munyaba makina yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jizaazai saba yagalyaꞌmavaka kaanya yamaryada aꞌmwe pwarɨ tɨnna wangamabɨna. Aꞌmwe sai Matɨyui woꞌnɨkei taakɨzɨangevɨ taakɨzɨya maaꞌda mwaalɨna. Mwaalɨna yadɨꞌnyɨ tɨnna wangamabɨna yaka wɨdɨna “Dɨnyɨmɨdɨnaama!” Sara wɨdɨna kyaꞌ sai daavɨna yaka mɨdɨnna. ");
INSERT INTO byr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sagaaꞌ Matɨyure angevɨ wapaaya nyemwaaina yada, yɨthaanyi, aꞌmwe kwalaalyara taakɨzɨya maaꞌdɨvɨsarajɨ kɨwɨnya galazekɨvaidɨvɨsarajɨ yɨkabɨna. Yɨkabɨna yeva Jizaazalyɨ gamɨre mɨdɨdɨvɨsara kwarajɨ wapaaya yeꞌmwannanyɨna. ");
INSERT INTO byr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wapaaya yeꞌmwannanyɨna yadɨvɨꞌ Perɨzɨyara tɨnna wanganna yeva dɨvidaaꞌnyɨ gamɨreraavɨ maanga wɨdɨna “Beꞌnevaka! Sarɨmɨre wɨjɨwaakyai taakɨzɨya maaꞌdɨvɨsarajɨ kɨwɨnya galazekɨvaidɨvɨsarajɨ wapaaya beꞌna yeꞌmwannanɨvanɨkelaka! Tewaanyara daaka!” ");
INSERT INTO byr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Savɨ sai kadɨka wɨꞌnyɨna yaka keꞌbaꞌna wɨdɨna “Aꞌmwe dɨragɨnnakera dotaravaavɨna wɨgainadera mɨka! Aawa. Aꞌmwe nalaavɨnakerana dotaravaavɨna wɨgainadere. ");
INSERT INTO byr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gotɨyare bukuyaꞌ dara dɨnɨkesɨ. Bulɨmakaawoyangɨjɨ sipɨzipɨyangɨjɨ mubɨthɨka yɨrasaꞌne yaasɨwaꞌna nyɨjaavadɨvɨsanna aala! Pwaraavɨ kaleꞌna duhaimwagyidevwina nyɨvuꞌnɨvanɨꞌ. Sara dɨnɨkeꞌ dareꞌnesɨ. Sɨmunya nayaa jawɨramaraawila! Aꞌmwera dɨragɨnnakerabɨsara ‘Nemɨ yɨdaꞌmaraangeinera,’ dɨdɨvɨsaraavɨ jaka wɨjaꞌneinyɨ bɨweinyɨ mɨka. Aawa. Aꞌmwera nalaavɨnakerabɨsara ‘Nemɨ kayaaꞌnanyainera,’ dɨdɨvɨsaraavɨ jaka wɨjaꞌneinyɨ bɨweinyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sagaaꞌ Jonɨmɨ mɨdɨnesara gamɨnyawɨnna bɨna yeva wɨdɨna “Gathaꞌdarevaka? Nemɨjɨ Perɨzɨyarajɨ Gotɨyarɨ wɨjaꞌna tɨka munnenna kɨmaakɨya dakɨdaanyaꞌ kɨrɨꞌ gɨmɨdɨdɨvɨsara sazabwina myadɨvɨsaꞌ beꞌnevaka?” ");
INSERT INTO byr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jizaazai keꞌbaꞌna wɨdɨna “Kumɨnyaba munnevɨ kwala maaryai mwaaidɨꞌnyɨ sagaaꞌ mɨgɨnyalyɨyaraavɨ kale wiadera daa! Aawa. Dɨvidaaꞌnyɨ kumɨnyawɨdaaꞌnyɨ mɨgɨnyarɨ yɨpalamaapɨꞌdehaaꞌ sagaaꞌ tɨka munnenna ‘Aala!’ wɨdɨpɨꞌdeꞌnanyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Keꞌbaꞌna pɨrɨꞌ wɨdɨna “Baazɨꞌmaꞌnya yawaka dabuꞌnɨkevɨ gipwalyaꞌna aꞌmwe aane pwai kwai kwaabɨhannya gaala pɨmɨlɨꞌ aalya myamɨlɨꞌ maaꞌdei mɨꞌ. Sareꞌ dareꞌnesɨ. Nabaai sasara maarajaꞌ dabuꞌnɨka savɨ gipwalyaꞌne kwaabɨhannyamɨlɨꞌ aalya yagaaꞌ maalɨka wannyɨna yojɨ baazɨꞌmaꞌnyaꞌ ayahi kayaaka lihɨꞌna yadesɨ. Sara yojɨ dabuꞌnɨkeꞌ naanga yɨmaꞌnyɨna yadesɨ.” (Ne sɨnnawɨnyaraavɨre yagaalyavɨnajɨ Jizaazare yagaala mudɨkevɨnajɨ wɨdɨna.) ");
INSERT INTO byr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wɨdɨna yaka keꞌbaꞌna wɨdɨna “Nabaai aꞌmwera aalɨtala memehɨlaaka yawakevɨ waainɨya gaalyaꞌ mwaꞌmwagikadɨvɨtara mɨꞌ. Kɨrɨꞌ sara yɨpɨjaꞌ waainɨya gaalyaꞌ bilamariꞌbwarakadaawori kɨlaakeꞌ tɨꞌmɨwɨꞌna yadesɨ. Sara yojɨ waainɨyaꞌ bwaladɨmaꞌnaawɨna yojɨ waainɨyasɨ kɨlaakesɨ kayaaka yadewaalyɨ. Kɨrɨꞌ memehɨlaaka mudɨkevɨ waainɨya mudɨkeꞌ mwaꞌmwagikadɨvɨsaꞌ yuyawaai tewaanna warɨna yadewaalyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jizaazai yagaala saꞌ kuna wɨdadaaꞌnyɨ lotuangevɨ aꞌmwe naanga pwai aya kɨbanna wɨlaabɨna yaka kwadaai bulagina yaka wɨdɨna “Nɨmɨre taayaꞌ dahaasagaaꞌ mena kabaimwakɨra. Kɨrɨꞌ gɨmɨ ata buladathɨwanna kyaꞌgɨzɨ ayahi gaalyaꞌ mwaaladeꞌnanyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sara wɨdɨna kyaꞌ daavɨna yaka mɨdɨnna yada gamɨre mɨdɨdɨvɨsarajɨ mɨjamakuna. ");
INSERT INTO byr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yɨthaanyi, aꞌmwe pɨrɨꞌ baizaaka maꞌnyaakeꞌ kwarame atɨraai sɨvɨlɨrɨdaaꞌnyɨ pɨrɨwaaina wavɨlavakeꞌ nabalɨnakeꞌ mwaaidɨꞌnyɨ. Aꞌmwe dazaꞌ sarɨ bulyɨmagɨ kɨbaweba gidɨkuꞌna wɨlaabɨna yaka gamɨre baazɨꞌmaꞌnyɨmaangebaarɨ ata bulayɨmeꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sareꞌ dareꞌnesɨ. Gannya sɨmunyavɨ dara dɨna “Nɨmɨ gamɨre baazɨꞌmaꞌnyavɨ yune asaꞌna yɨmeꞌnɨwɨjaꞌ ayɨna tewaanya yɨmaꞌnɨdera.” Yawɨta savɨdaaꞌnyɨ ata bulayɨmeꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ata bulayɨmeꞌnyɨna kyaꞌ sai gɨnyɨmaꞌnyɨna yaka tɨnna wanganna yakegaaꞌ wɨdɨna “Nyɨraavaangeꞌgɨ lɨka minnera! Nɨmɨnyɨ dɨragɨnna yawɨralɨmwanna yɨwaanyaꞌna tewaanya gyavadaꞌgaimweꞌgɨnyɨ.” Sara wɨdɨna kyaꞌ sagaaꞌdaaꞌnyɨ aꞌmweꞌ tewaanya yɨmaꞌnyɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aꞌmwe naanga dazare angevɨna Jizaazai biꞌmaꞌna yɨna yaka, aꞌmwera gwarevɨ makuꞌdaapi kwalaalyara kɨnna naanga dadaapi tɨnna wanganna. ");
INSERT INTO byr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tɨnna wanganna yaka wɨdɨna “Dalyula! Sareꞌ dareꞌnesɨ. Taayaꞌ yɨnahu mabalyɨwaka! Aawa. Se warɨka. Sareꞌna dalyula!” Sara wɨdɨna kyaꞌ “Se mwarika! Baimwakevɨnera,” deva jɨka maregina. ");
INSERT INTO byr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jɨka maregina kyeꞌ kwalaalyaraavɨ mena wɨdaasaka sagaaꞌ kusawɨ wɨlɨna yaka taavɨzɨdɨraaya savɨre asɨrɨ lɨmwanna yɨna yaka yɨdɨkaaꞌna. ");
INSERT INTO byr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Sara yakevɨ yagaala anga yuneba maredɨmwɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jizaazai anga saba yagalyaꞌmavaka kaanya yamaryada aꞌmwe tɨbɨnya pwaraai mɨdɨnna yagɨla jaka danganna “Ne Devitɨmɨre kaimɨraayaigɨ! Naarɨmɨnyɨ kaleꞌna dɨnehɨhaimwana!” ");
INSERT INTO byr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jaka danganna kyagi angevɨ wɨlɨna yɨna kyaꞌ tɨbɨnya saraai gamɨnyabanna wɨlaabɨna yɨna kyagi sai saraarɨ wɨdɨna “Nɨmɨnyɨna dara jawɨralɨmwamanɨgi? ‘Sahwai naarɨmɨnyɨne yavadaꞌgaina nehyadelyɨra. Sahwai wikɨra.’ ” Sara wɨdɨna kyaꞌ saraai wɨdɨna “Yo, Naangeigɨ sara yawɨꞌmwoi.” ");
INSERT INTO byr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Miꞌna wɨdɨna yagɨlyagaaꞌ kɨrɨmɨre tɨnnyaraarɨ ata dathɨwanna yaka wɨdɨna “Nɨmɨnyɨna dɨragɨnna yawɨralɨmwamanɨgɨlabaaibɨꞌ sara yɨmaꞌnyɨna yɨhyana!” ");
INSERT INTO byr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Sara kudaꞌ yuyaraare tɨnnyaraai yɨta lɨvɨna yaka tɨnna wanganna. Tɨnna wanganna kyagi Jizaazai dɨragɨnna dara wɨdɨna “Mala nayaa jɨwannyi! Aꞌmwe aane pwai kwai dazavɨ nyawɨranganadɨka! Mujɨwaakyɨkana!” ");
INSERT INTO byr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wɨdɨna yaka kɨrɨꞌ saraai mwasawɨnna walyuna yagɨla yagaala saꞌ wɨjɨwakamarina yɨna yagi gamɨnyɨna anga yunebanyaavɨ. ");
INSERT INTO byr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Saraai walyuna yadaakɨlyɨ, yɨthaanyi, aꞌmwe pwarɨ makabɨna. Aꞌmwe sarɨ yɨmakei wɨlamwaaidei maanga bɨpainɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sahwarɨ makabɨna kyeꞌ yɨmakerɨ miꞌna wɨdaasɨna yɨna kyaꞌ maanga bɨpainɨkei yagaala dɨna. Yagaala dɨna yada yɨ kwala bwaꞌnaanya atɨka maruꞌnaꞌna yadɨvɨꞌ dɨna “Nemɨ Yɨzɨrelɨyainaavɨreba aane kɨgaaꞌ pɨgaaꞌ daꞌdare pɨnɨ wangadaanyaina mɨꞌ.” ");
INSERT INTO byr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Sareꞌ kɨrɨꞌ Perɨzɨyara maanga dɨna “Yɨmaka naangere dɨragɨnyavɨ wɨdaasɨvanɨka yɨmakeraavɨ.” ");
INSERT INTO byr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Anga naangebanyajɨ anga maalɨkebanyajɨ yunebanna Jizaazai yamarina yada kumɨre lotuangengɨ aꞌmweraavɨ wɨjɨwɨrina, Gotɨyai maremwaalyaꞌne yagaala tewaanyaꞌ wɨjɨwaakɨna, nabalya yuya dala nabinyannajɨ nalaaya yuya dala nabinyannajɨ tewaanya yavadaꞌgaina. ");
INSERT INTO byr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sana sana yada kwala bwaꞌnaanyangɨ tɨnna wanganaka sahwaraavɨna kale naanga wina yaꞌ. Sipɨzipɨyaraavɨ maremwaaidei maayara mwaaihatabaaibɨꞌ sahwara taanginyajɨ yawɨta kwalaalyajɨ yadɨvɨꞌ dɨragɨmaayara mwaalesaꞌna kale naanga wina. ");
INSERT INTO byr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sarevɨdaaꞌnyɨ gamɨre mɨdɨdɨvɨsaraavɨ dɨragɨmaayara gamɨnyɨ lɨmwabɨneraavɨna keꞌbaꞌna wɨdɨna “Wawɨnyangɨ tɨka munne kwalaalya mya mena yɨlakengɨ. Kɨrɨꞌ mya maaꞌdɨvɨsara kwalaalyara mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Sarevɨdaaꞌnyɨ tɨka munne Maremwaaiderɨ duzɨla! ‘Gɨnnya yadɨvɨsaraavɨ gɨmɨre tɨka munne mariꞌbwarakyaꞌneraavɨ duthaasa!’ dapɨjɨ sara duzɨla.” ");
INSERT INTO byr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jizaazai gannya mɨdɨdɨvɨsaraavɨ (12) jaka wɨdɨna kyaꞌ sarera yɨkabɨna. Yɨkabɨna kyeꞌ gannya dɨragɨnyaꞌ wɨjaavɨna. Yɨmaka gɨrɨꞌnakera aꞌmweraavɨre munyɨkaavɨ wɨlamwaalesaraavɨ dɨragɨnna wɨdaasaꞌnebulyɨ nalaaya yuya dala nabinya nabalya yuya tewaanya yavadaꞌgalyaꞌnebulyɨ sazaburaavɨneꞌna gannya dɨragɨnyaꞌ wɨjaavɨna. ");
INSERT INTO byr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Gamɨre yagaalyaꞌ wɨdaasade sɨvɨlyɨrɨdaaꞌnyɨ pwaraalyaraavɨne yaya darengɨ. Aaya mudɨꞌnanyai Saaimonɨ, Pitai woꞌnɨkelyɨ, yɨ gamɨre gahwaalaangei Edɨruyalyɨ. Pwai Jemɨzai Sevathiyare kaimɨraayalyɨ, gamɨnyɨ gahwaalaangei Jonɨjɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipɨjɨ Baatolomyulyɨ. Tomaazalyɨ Matɨyui taakɨzɨya maarakelyɨ. Jemɨzai Alɨpɨyaazare kaimɨraayalyɨ Tathɨyaazalyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saaimonɨ “Kumɨrebanna Romɨyaraavɨ yɨrawasaana!” dadɨvɨsarajɨyalyɨ Juthaazai Yɨzɨkerɨyotɨyai dɨvidaaꞌnyɨ Jizaazarɨ yɨkamaangeraavɨna wibwarɨdaakwakelyɨ. Yuyara wɨdaasaderera. ");
INSERT INTO byr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sɨvɨlɨrɨdaaꞌnyɨ pwaraala saraavɨ Jizaazai maryaasaꞌnei yagaaikɨwɨnya dara wɨjaavɨna. Nɨmɨre yagaalyaꞌna duzɨwaakyɨla! Ajɨmya pɨnɨngɨyaraayawɨnna mupɨnera! Anga naanga Samerɨya mwaalyaraayawɨnna mwibɨnera! ");
INSERT INTO byr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Aawa. Yɨzɨrelɨya sɨmyaraayawɨnna dɨwila! Yɨzɨrelɨya yuyara dɨragɨnna malɨmwagyadɨvɨsara sipɨzipɨyara yɨwɨnamaꞌna sotaꞌ sotaꞌ yɨgasaraayawɨnna dɨwila! ");
INSERT INTO byr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sarɨmɨ wawopɨjɨ yagaalyaꞌ dara duzɨwakaawi! “Sɨgunyavɨya maremwaaideꞌ nebawa mɨka! Aya kɨgaaꞌ yɨmaꞌnɨwaka!” ");
INSERT INTO byr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nabaai wawopɨjɨ nalaavɨnakeraavɨ javadaꞌgalyɨla! Bainɨkeraavɨ jathɨkaayɨla! Samatanakeraavɨ tewaanya javadaꞌgalyɨla! Sara yadɨvɨꞌ aꞌmweraavɨre munyɨkaavɨ yɨmakera wɨlamwaaidɨvɨsaraavɨ duthaasɨla! Sasare dɨragɨnyabwina sarɨmɨ yanga maaꞌdɨvɨta nɨgwia mubyaꞌne maayangɨ. Sarevɨdaaꞌnyɨ dazabwina yanga nayaa duzaayɨla! Sanna nɨgwia mamaapɨna! ");
INSERT INTO byr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sarɨnnya paawɨzɨyangɨ golɨyajɨ monejɨ nɨgwiajɨ mamihakɨpɨna! ");
INSERT INTO byr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kaanya wodɨvɨsaꞌne gɨlyajɨ mamaapɨna! Baazɨꞌmaꞌnya pɨrɨsɨ kwaariꞌmasɨvɨla pɨrɨwaalyɨ yadita mavamaryaꞌne pɨrɨsɨ mamaapɨna! Aawa. Sareꞌ dareꞌnesɨ. Aꞌmwei wawɨnya yojɨ gannya tɨka wapaaya maaranneꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Anga naanga pɨbajɨ anga maalɨka kɨbajɨ kusawɨ wɨlapɨjɨ sɨmunyaꞌ nayaa dara jawɨranganyideihɨlyɨ. Aꞌmwe anga dazabanyai tewaanya yaka yɨdaꞌmaraangei aaihwalaka? Yɨ, aꞌmwe salyɨ sarɨmɨ kuna yeꞌmwannemwaaina yapɨjɨ yune anga saba yagalyaꞌmapɨjahaaꞌnanneihi. ");
INSERT INTO byr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yɨ sarerɨ angevɨ wɨlapɨjɨyagaaꞌ anga savɨyayorɨ “Nyaꞌmwenɨdaki! Gotɨyare kwaamuꞌnanyabwi yɨhwarana!” duzideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nabaai anga savɨyara sarɨmɨnyɨna tewaanna yɨhyɨpɨjaꞌ sarɨmɨre yagaala tewaanyavɨyaꞌ saraavɨ tewaanya waradesɨ. Sahwara kwaamuꞌna mwaaibɨꞌdera. Kɨrɨꞌ nawɨꞌnya myɨ yɨhyɨpɨjaꞌ yagaala tewaanyavɨyaꞌ sarɨmɨnyawɨnna ayɨna gɨnyɨravaabathesɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nabaai pwai kwai angevɨna makuyaꞌna “Aala!” wɨvuꞌnajai sarɨmɨre yagaalyangɨ kadɨka muꞌnyɨ yɨhyɨpɨjaꞌ anga savɨ, pɨrɨvɨ anga naanga kɨba mwasawɨ walyaabɨna yɨna yapɨjɨ “Gotɨyai yagaainakei yɨhɨzathelyɨ,” wɨdapɨjɨ sarɨmɨre sɨvɨlyangɨ kwaatɨrɨdɨrɨnya yɨhɨmɨwɨꞌnɨka sa purakɨrasɨꞌna jideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nebulyaꞌna yɨhɨthɨvanɨge. Kotɨya maryaꞌne yɨrɨkerɨkɨ Anga Sothomɨ Anga Gomora kayaaꞌnanyabanyaai mwaalyaraavɨneꞌ tɨvɨkɨsavɨ anga naanga dazaba mwaalyaraavɨre tɨvɨkɨsaꞌ wavɨlavadesɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yɨthaanyi! Nɨmɨ kavɨjɨlɨkeraavɨ tɨnnyawɨnna sipɨzipɨya kwaamusaihɨrɨ marayɨhyaasɨwa. Sarevɨdaaꞌnyɨ sarɨmɨ sɨmunyaꞌ nayaa yawɨꞌdɨvɨꞌ nayaa jideihɨlyɨ. Nabaai kwaamɨryarebwibɨꞌ kave mwaaidɨvɨꞌ pwaraavɨ kayaaꞌna mipɨnera! Nayaa duzɨwaakyɨla! ");
INSERT INTO byr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aꞌmweraavɨna mala nayaa jɨwannyɨla! Sareꞌ dareꞌnesɨ. Kunnya kaajolɨyaraayabanna kotɨya yɨhɨmaripɨꞌdeihɨlyɨ. Kunnya lotuangengɨ kusawɨ wɨlyabaalyɨ dɨka yɨhɨhɨdapɨꞌdeihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nɨmɨnyɨna “Walamarakaana!” yawɨꞌdɨvɨꞌ Gaꞌmaanɨyaraayawɨnnajɨ Kingɨyaraayawɨnnajɨ yɨhɨmakupɨꞌdeihɨlyɨ. Sagaaꞌ sahwaraavɨ kadɨka muꞌnyadɨvɨsaraavɨjɨ ajɨmya yuyangɨyaraavɨjɨ nɨmɨnyɨneꞌna jalɨkurakyaꞌneihi duzɨwaakyideꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kotɨyavɨ kyɨhɨmarɨmwangapɨjɨ yawɨta kwalaalya myadɨvɨꞌ dara nyawɨpɨdɨꞌ! “Nemɨ gara wɨdaazɨwona? Nemɨ be yagaalyaꞌ wɨrɨvɨkɨraanneka?” Sareꞌ dareꞌnesɨ. Sagaasagaaꞌ yunegaaꞌ yagaala duzɨwaakyideꞌ sarɨmɨre sɨmunyavɨ Gotɨyare Kuryai yɨhwakadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yune sarɨmɨ saihina duzɨwaakyideihi mɨꞌ. Aawa. Sɨrɨnɨmaangere Kuryai wɨlayɨhɨmwaaida yagaala saꞌ sarɨmɨre maangikaavɨdaasɨ wɨjɨwaakadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nabaai aꞌmwei Gotɨyarɨ malɨmwagyadei gahwaalaangerɨ Gotɨyare lɨmwadeꞌna kotɨya kumarɨmwaaihojɨ yɨnahu tamakɨpɨjai. Yɨ nabaai ganɨmaangei gannya kaimɨraayarɨ avaala sana yadelyɨ. Nabaai kaimɨraayara kɨrɨnaangewaarɨ yɨkamaanga yɨmaꞌnyɨna yapɨjɨ tamakyaꞌna kotɨyavɨ wɨmwaaihɨna. ");
INSERT INTO byr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nɨmɨre yayavɨneꞌna yuyara sɨmɨlɨka widere sarɨmɨnyɨna. Kɨrɨꞌ aaya yune naangegaaꞌna aꞌmwe dɨragɨnna daavajai Gotɨyai padaihasamaaradelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nabaai anga naanga pɨba Gotɨyarɨne yawɨsaihɨrɨ kayaaka juwɨꞌnyɨna kihyapɨjɨ anga naanga pɨbanna lɨkaanya yɨkuna jideihɨlyɨ. Sareꞌ dareꞌnesɨ. Nebulyaꞌna yɨhɨthɨvanɨge. Sarɨmɨ wawɨnyaꞌ Yɨzɨrelɨ anga naanga yuyabanya yarai miꞌmwannyadapi Aꞌmweraavɨne Kaimɨraayai bathehaaꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mɨdɨdei gannya wɨjɨwaakyarɨ wavɨlavadei mɨꞌ. Nabaai yaasɨwaꞌwawɨnyai gamɨre naangei wavɨlavadei mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yɨ mɨdɨdei gamɨre wɨjɨwaakyai mwaaidevaaibɨꞌ yɨmaꞌnajaꞌ saꞌ wikɨra. Nabaai wawɨnya wɨdaayadei gamɨre maremwaalyai mwaaidevaaibɨꞌ yɨmaꞌnajaꞌ saꞌ wikɨra. Nɨmɨnyɨ kayaaꞌna yɨpɨjaꞌ sarɨmɨnyɨ kayaaꞌna yɨhyɨpɨꞌdeihɨlyɨ. Nɨmɨ angevɨ maremwaaidɨnyainyɨna dara dɨwaꞌdaaꞌ “Yɨmaka Naangere dɨragɨnyavɨna yɨmakeraavɨ wɨdaasɨvanɨꞌ.” Sara dɨna “Biyelɨzɨvulɨgɨ Yɨmaka Naangeigɨnyɨ,” dɨna yɨwaꞌdaasaꞌna sarɨmɨnyɨna nɨmɨre angevɨyaihɨrɨna kayaaꞌna gathaꞌdara dɨpɨꞌdeꞌneka! ");
INSERT INTO byr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Sarevɨdaaꞌnyɨ kumɨnyɨna lɨka mipɨnera! Sareꞌ dareꞌnesɨ. Yuyaburaavɨjɨ yuyangɨjɨ bwakakɨnɨke kuꞌmaayaba waraabathengɨ. Yuya kulaaꞌnya lɨka yulyarɨke aꞌmwera yawɨrangabɨꞌdengɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sarenna jɨhɨnyavɨ lɨka yulyarɨkevɨ yagaala yɨhɨthɨvanɨge daza yɨrɨkegaaꞌ aꞌmweraayaba duzɨwaakyidengɨ. Nabaai sarɨmɨ kave kadɨkiꞌna wɨꞌnakɨvanɨgasa angevɨ munya keꞌba daaꞌdɨvɨꞌ naanna duzɨwaakyidengɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Sarɨmɨre kɨlaakejɨkaavɨ aꞌmwe yɨnahu tamakɨpɨꞌderaavɨna lɨka mipɨna! Kɨrɨꞌ sarɨmɨre kuryaraavɨjɨ tamakɨpɨnera mɨꞌ. Aawa. Dɨka Kayaaꞌnanaangevɨ Gotɨyai kuryarɨjɨ kɨlaakejɨkɨjɨ yuyaraarɨ kayaaka yɨgalannerɨna lɨka jideꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yuta maalɨka pwaraai nɨgwia puꞌnanyɨsɨ mubadɨvɨsɨꞌ midaaꞌ! Kɨrɨꞌ Sɨrɨnɨmaangei “Aala!” kadozɨ yuta maalɨka sarei mabalyojɨ kwaakevakɨ bwalaraawadei mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kɨrɨꞌ sarɨmɨnyɨneꞌna sarɨmɨre mɨnyagɨnyangɨ mɨjata yuyangɨ ata mena ginɨkengɨ. Gotɨyai sarɨmɨnyɨna mena yuna yawɨꞌnɨkeihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Sarevɨdaaꞌnyɨ lɨka mipɨna! Dareꞌ jawɨryɨla! Yuta maalɨkeraavɨ Gotɨyai nayaa maremwaaide kwalaalyaraavɨ nemɨ dɨragɨnna mena wavɨlaꞌmwoinera! Sara jawɨryɨla! ");
INSERT INTO byr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Sarengɨdaaꞌnyɨ yɨhɨthɨma! Gazaizai Kwaaka davakɨ aꞌmweraayaba jalɨkurakɨvanɨkei “Nɨmɨ Jizaazareinyɨ,” yɨ sahwarɨna aayagaaꞌ Sɨgunyavɨ Nɨmaamaangerɨ jalɨkurakɨdeinyɨ “Sahwai nɨmɨrelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kɨrɨꞌ gazaizai aꞌmweraayaba wɨjɨwaakajai “Jizaazareinyɨ mɨka!” yɨ sahwarɨna Sɨgunyavɨ Nɨmaamaangerɨ wɨjɨwaakɨdeinyɨ “Sahwarɨna myawɨriweinyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Sarɨmɨ sɨmunya myawɨpɨna! “Kwaaka davakɨna Jizaazai mala yuya yɨgaꞌmwagakyaꞌnajɨ narya wakyaꞌnajɨ bɨwakelyɨ.” Nɨmɨ narya wakya saꞌna bɨweinyɨ mɨꞌ. Aawa. Kwaariꞌmasɨramɨnyaꞌ makabeneinyɨ. Aꞌmweraavɨ tangɨvalyaꞌna bɨweinyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sareꞌ dareꞌnesɨ. Yɨkamaanga yɨmaꞌnyaꞌnevɨna bɨweinyɨ. Nɨmɨnyɨneꞌna aꞌmwelyɨ ganɨmaangelyɨ sɨmunya geꞌ geꞌ tangɨvalakɨlyɨ maanga dɨnyɨna. Yɨ sɨdɨraayasɨ ganaangesɨ sɨmunya geꞌ geꞌ tangɨvalakɨlyɨ maanga dɨnyɨna. Yɨ aꞌmwesɨ ganyaalɨmaangesɨ sɨmunya geꞌ geꞌ tangɨvalakɨlyɨ maanga dɨnyɨna. ");
INSERT INTO byr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yɨ aꞌmwelyɨyara avaaimwaalya kwara yɨkamaanga mwaalɨna yɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Aꞌmwei ganɨmaanga pwarɨna ganaanga kɨrɨvɨna dɨragɨnna yawɨꞌna yada nɨmɨnyɨna maalɨꞌna yawɨꞌna yade sahwai nɨmɨrei wiꞌnanyai mɨka. Nɨmɨnyɨna tewaanyai mɨꞌ. Nabaai gawaalɨvaanga pwarɨna garaavaanga kɨrɨvɨna dɨragɨnna yawɨꞌna yada nɨmɨnyɨna maalɨꞌna yawɨꞌna yade sahwai nɨmɨrei wiꞌnanyai mɨka! ");
INSERT INTO byr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nabaai yɨta yovihɨrarannɨkeꞌ kanyɨjaavapɨjɨ makwawaꞌmujɨ yɨta savɨ balɨdevaaibɨꞌ nɨmɨnyɨne taanginyanna bɨraizɨkanna “Aala!” dada kuna manyɨmɨdɨnyajai nɨmɨrei wiꞌnanyai mɨka. ");
INSERT INTO byr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aꞌmwei gannya gaala yune kaveya sabwina yawɨꞌda nɨmɨnyɨna “Aala,” dazai gamɨre kuryai kayaaka yɨnadelyɨ. Yɨ aꞌmwei nɨmɨnyɨna dɨragɨnna yawɨꞌda gamɨre mwaalyabwi yagalyaꞌmavajai nɨmɨnyɨna balajai gamɨre kuryai yuyagaaꞌ yuyagaaꞌ tewaanna mwaaladelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nɨmɨre yagaalyaꞌ jamaryadaapɨjɨ aꞌmwei wɨgaimwangeꞌna yɨhɨmaarajai yɨ sarɨmɨnyɨ gaveihɨrɨ mamaari yɨhyadelyɨ. Avaalyagaaꞌ nɨmɨnyɨjɨ nyɨmaaradelyɨ. Nabaai nyɨmaarajai, yɨthaanyi, sarevɨdaaꞌnyɨ nyɨmaryasaabakerɨ maaradelyɨ. Tewaanya maaradelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aꞌmwei yawɨꞌna “Sahwai pɨropetɨyai Gotɨyarɨ wɨꞌnawɨjɨwaakadei mwaalɨkeꞌna wɨgaimwagɨma! Pɨropetɨyarɨ nɨmɨre angevɨna marakaabɨwɨjarɨ nayaa maremwaalɨma!” Yɨ aꞌmwe dazarɨ Gotɨyai pɨropetɨyarɨ yanga wɨrɨvɨkɨradevaaibɨꞌ yanga tɨvɨkɨta nawɨꞌnyaꞌ wɨjaavadelyɨ. Nabaai aꞌmwei yawɨꞌna “Sahwai yɨdaꞌmaraangei mwaalɨkeꞌna wɨgaimwagɨma!” Yawɨꞌna yojɨ gannya angevɨna maarajai Gotɨyai yɨdaꞌmaraangerɨ yanga wɨrɨvɨkɨradevaaibɨꞌ yanga wɨrɨvɨkɨta wɨjaavadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nabaai pwai aꞌmwe maalɨkeraavɨ tɨnna wanganna yojɨ yawɨꞌna “Jizaazare mɨdɨderɨ wɨgaimwagɨma!” Yawɨꞌna yojɨ kaapɨvananyavɨ aalya nyaꞌne gaveꞌ yanga wɨjaavajai, yɨthaanyi, nebulyaꞌna yɨhɨthɨvanɨge. Aꞌmwe dazarɨne yanga wɨrɨvɨkɨta yaasɨwaꞌna yɨwawodeꞌ mɨꞌ. Arɨkewɨ. ");
INSERT INTO byr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jizaazai gannya sɨvɨlɨrɨdaaꞌnyɨ pwaraala saraavɨre wawɨnyaꞌna kɨwɨnya dazaꞌ tɨviꞌna jɨkuꞌna yaka sabadaaꞌnyɨ kumɨre anga naanga sawɨnna kaanna wɨna yaka aꞌmweraavɨ wɨjɨwɨryada wɨjɨwaakɨna yɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jonɨ kalavuzavɨ mwaalɨna yada Kɨraazɨtɨyai yadaaꞌnyɨya yuya sanna Jonɨ kadɨka wɨꞌnyɨna yaka gannya mɨdɨdisaraarɨ gamɨnyawɨnna maryaasɨna. ");
INSERT INTO byr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Dara wɨdaasɨna “Nemɨ ‘Sɨgunyavɨdaaꞌnyɨ bathelyɨra,’ dadaanyaigɨ dahwaigɨ dɨngaka? Pwarɨna yemwalaadei dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sara wɨdaasɨna yakeraai Jizaazarɨ yɨdaanganna kyagi yagaalyavɨ tɨvɨkɨꞌna “Jonɨmyawɨnna kɨrɨmɨ yuya kadɨka wɨꞌnagɨla tɨnna wangamanɨgɨla sannajɨ duthɨthaakwila! ");
INSERT INTO byr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tɨbɨnyara tɨnna yenyɨna, sɨvɨla kayaaꞌnanyara kaanya yamarina, samatanakera nawɨꞌnya yɨmaꞌnyɨna, aꞌmwe kadɨka muꞌnyɨmuꞌnyara yagaalyangɨ kadɨka wɨꞌnyɨna, bainɨkera ayɨna yɨdɨkaaꞌna, aꞌmwe nɨgwɨmaayaraavɨ yagaala tewaanyaꞌ wɨjɨwaakɨna yadɨnyainyɨ. ");
INSERT INTO byr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nabaai nɨmɨnyɨna pwai sɨmunya pɨrɨwaalyɨyai mamwaalyɨ yajai dɨragɨnya nyɨlɨmwagazai yɨ dazai yɨlaaya yada tewaanaanga yɨnɨkelyɨra.” Jizaazai Jonɨmɨna sara wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jonɨmɨre saraai mena wɨna yadaakɨlyɨ sagaaꞌ Jizaazai Jonɨmɨna kwala bwaꞌnaanyavɨ dara wɨdɨna “Aꞌmwera maayabanna sarɨmɨ kaanna wɨna yeva bewarɨ wanganaaweva? Suya pɨrɨkɨ yɨhusaꞌ galalɨwihɨrakerɨꞌbɨsarɨ dahawanganaaweꞌ? ");
INSERT INTO byr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aawa. Sarɨmɨ tɨnna bewarɨ wanganaaweva? Baazɨꞌmaꞌnya wolata baazɨꞌmaꞌnɨkerɨ dahawanganaaweꞌ? Aawa. Yɨthaanyi! Baazɨꞌmaꞌnya wolata baazɨꞌmaꞌnadɨvɨꞌ kingɨyaraavɨre angengɨ mwaaidɨvɨsare. ");
INSERT INTO byr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kɨrɨꞌ bewarɨna waweva? Pɨropetɨyarɨ Gotɨyarɨ wɨꞌnawɨjɨwaakaderɨ wanganyaꞌneihi dɨngaka? Yo, yɨhɨthɨvanɨge. Dazahwai pɨropetɨyai yaka kɨrɨꞌ pɨropetɨyaraavɨrebwi wavɨlavɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yune aꞌmwe sahwarɨna dɨnɨkerɨnesɨ. Gotɨyai dara wɨjaaꞌ ‘Yɨthaa, nɨmɨre wɨjɨwaakyaꞌnei maryasaabɨdelyɨ. Gɨmɨnyɨna sɨnnawɨ waanyɨna yadelyɨ. Gɨmɨnne tutaanya maryovɨrawakɨna yadelyɨ.’ ");
INSERT INTO byr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nebulyaꞌna yɨhɨthɨvanɨge. Jonɨ Bavɨtaazɨya Yadei aꞌmweraavɨdaaꞌnyara Kwaakevakɨ yɨmaꞌnɨgata yuyaraavɨ wavɨlavɨkelyɨ. Kɨrɨꞌ Sɨgunyavɨya Gotɨyai maremwaaidevɨne aꞌmwe yune maalɨkei yɨ sahwai Jonɨmɨ wavɨlavɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jonɨ Bavɨtaazɨya Yaderegaaꞌ dahaaꞌ kuna yɨvanɨgaꞌ. Aꞌmwera Sɨgunyavɨya Gotɨyai maremwaaideꞌ dɨragɨnna yawɨramaaꞌmanɨgasaꞌnanyɨ. Yɨ aꞌmwe dɨragɨnaangera dɨragɨnna lɨmwagaꞌmanɨgasaꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sareꞌ dareꞌnesɨ. Pɨropetɨya yuyara dɨnɨkejɨ Kɨwɨnya kɨnɨjɨ dara dɨnɨꞌ ‘Naangei yuyaraavɨ maremwaaladelyɨ.’ Sara dɨnɨkeꞌ nabaai aayaangei Jonɨ nɨmɨnyɨna sara wɨdakelyɨ. Sagaaꞌnanyɨra. ");
INSERT INTO byr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nabaai ‘Maremwaaladeꞌ myɨmaꞌnyɨ kyojɨ sɨnnawɨ pwai bathelyɨ. Sahwai Yɨlaajare wawɨnyaꞌ yaakeꞌ makabathelyɨ.’ Sara dɨnɨkesɨ. Sarɨmɨ ‘Kadɨka wɨꞌnaajaina,’ yawɨrapɨjɨyaihi duꞌnyɨla! Jonɨ Yɨlaajalyɨ. ");
INSERT INTO byr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aꞌmwe kadɨꞌnakei yagaala dazaꞌ nayaa wɨꞌnana! ");
INSERT INTO byr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Aꞌmwe dahaasaraavɨna benɨbɨtaraavaka! Darebaaibɨsarera. Angwaasabanna avaannyaꞌne kaimɨraayara mwaaleva kaimɨraaya pwaraavɨna jaka wɨdangamanɨgaꞌ ");
INSERT INTO byr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","(Jonɨmɨneꞌna) ‘Avaannyaꞌna mudɨkangengɨne gware makuꞌmanɨgo Kɨrɨꞌ “Kwarame aala!” dɨvanɨgave!’ (Nɨmɨnyɨneꞌna wɨdangamanɨgaꞌ) ‘Nemɨ baryangɨne kɨdaata dɨvanɨgo Kɨrɨꞌ “Kaladaata aala!” dɨvanɨgave!’ ");
INSERT INTO byr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sare aaya kaavɨlyaꞌ daꞌdaresɨ. Jonɨ bakegaaꞌ wapaaya ge gejɨ waainɨyasɨ ‘Aala!’ dada mwaalakeꞌna dara dɨna yɨvanɨgaꞌ, ‘Yɨmakei kɨnɨnnakelyɨ.’ ");
INSERT INTO byr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aꞌmweraavɨne Kaimɨraayai bɨwaꞌdɨkegaaꞌ wapaaya ge gejɨ waainɨyasɨ nada mwaalɨkeꞌna dɨna ‘Yɨthaanyi! Aꞌmwe sahwai munaanga naangesɨyai nɨvanɨkelyɨra. Nabaai waainɨya kwalaalya nɨvanɨkelyɨra. Taakɨzɨya maaꞌdɨvɨsaraavɨjɨ kɨwɨnya galazekɨvaidɨvɨsaraavɨjɨ kwɨyaꞌmwelyɨra.’ Jonɨjɨ sainaai Gotɨyare sɨdusabwina maarola wawɨnya nawɨꞌnya yɨvanɨgolyainaalyɨ. Wawɨnya sa sɨduꞌnakera dara yawɨranganna ‘Gotɨyare sɨduta tewaanyabwina sara yɨvanɨgi. Yɨdaꞌmaraangesɨra.’ ” ");
INSERT INTO byr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Sagaaꞌ anga pɨbanyaavɨ Jizaazai gamɨre dɨragɨnya kwalaalya yaka kɨrɨꞌ sɨmunya mudɨkebwi myawɨryeva. Sareꞌna dazagaaꞌ sahwai maanga gaai dara wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Weꞌ! Korazinɨ mwaalyaihɨle! Betɨzaaitha mwaalyaihɨle! Weꞌ! Weꞌ! Kayaaꞌna yɨhyadeihɨlyɨ. Menyaraavɨreba Taayaa mwaalyarajɨ Saaithonɨ mwaalyarajɨ nɨmɨ dɨragɨnaanga sa sarɨmɨre angeba yɨwaꞌdengɨ tɨnna wangabɨzɨ kwajɨ yɨ kɨgaakuna sɨmunya mudɨkebwi yarai kyawɨramaapɨdɨka! Kumɨrebwina kale wiadaaꞌnyɨ baazɨꞌmaꞌnya kɨrɨkɨrɨnakera mwaaidɨvɨꞌ kwaagɨsasɨ kavuꞌnɨpɨdɨka! Sareꞌna kayaaꞌna yɨhyadeihɨlyɨra. ");
INSERT INTO byr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Sare kɨrɨꞌ yɨhɨthɨvanɨge. Kotɨya maryaꞌne yɨrɨkerɨkɨ Taayaa mwaalyarajɨ Saaithonɨ mwaalyarajɨ saraavɨre taanginyaꞌ naanga sabɨta mɨꞌ. Taanga yɨhɨvɨramaarade saꞌ wavɨlavadesɨ. ");
INSERT INTO byr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nabaai Kaapanɨyamɨ mwaalyaihi Sɨgunyavɨna yɨhɨmakɨladeihi dɨngaka? Aawa. Dɨkevɨ dalaawideihɨlyɨra. Anga Sothomɨ nɨmɨ dɨragɨnya da sarɨmɨre angeba yɨwaꞌdengɨ yɨwɨjɨ kwajɨ dahaasagaaꞌ kuna kamannadɨka! ");
INSERT INTO byr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kɨrɨꞌ yɨhɨthɨvanɨge. Kotɨya maryaꞌne yɨrɨkerɨkɨ Sothomɨ mwaalyaraavɨre taanginya maalɨka yaka sabaaibɨꞌ yɨhyadeꞌna mɨꞌ. Taanga sarɨmɨnyɨ yɨhyadeꞌ wavɨlavadesɨ.” ");
INSERT INTO byr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dazagaaꞌ Jizaazai dara dɨna “Nɨmwai! Sɨgunyavɨnajɨ Kwaaka davakɨnajɨ Naangeigɨnyɨra. Su! Su! Yuya dazanna ‘Aꞌmwe sɨmunya nayaa yawɨꞌdaanyaina sɨduꞌnakeinera. Gotɨyarɨ myawɨraanna!’ yawɨꞌdɨvɨta saraavɨna lɨka yulyakɨvanɨgɨ. Sara yagɨna ‘Nemɨ yune kaimɨraaya maalɨkeina. Sɨduꞌmaayaina,’ yawɨꞌdɨvɨsaraavɨna wibwarɨdaakuvanɨgɨnyaꞌna ‘Su! Su!’ gɨthɨvanɨge. ");
INSERT INTO byr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yo, Nɨmwai, gɨmɨre sabwi sasarebulyɨ. Gɨmɨre yawɨta ‘Sareꞌ wabahɨlaaka nawɨꞌnyaꞌ nyɨwaꞌ,’ dahɨna sara yɨvanɨgɨnyaꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nɨmaamaangei yuyajɨ yuyaburajɨ nyɨmarɨmwangakeinyɨ saza maremwaaidɨnyainyɨ. Gawaalɨkɨ nayaa yuna yawɨrangadei aane pwai kwai mɨꞌ. Aawa. Nɨmwai gave sahwaina Gawaalɨkɨ nayaa yawɨrangadelyɨ. Nabaai Nɨmwarɨ gazaizai nayaa yawɨrangadei pwai mɨꞌ. Aawa. Gawaalɨꞌ gave sahwaina Nɨmwarɨ nayaa yawɨrangadelyɨ. Yɨ Gawaalɨꞌ pwai kwarɨna dara yawɨꞌna ‘Aꞌmwe sahwarɨna Nɨmwarɨ yawɨranganyaꞌna wibwarɨdaakuma!’ Yɨ sara yawɨrajaꞌ sahwara Nɨmwarɨ yawɨrangabɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Aꞌmweihi yagɨyagɨ yadɨvɨꞌ taanga naanga maaꞌmanɨgasaihi yuyaihi nɨmɨnyawɨnna dɨvila! Nɨmɨ sarɨmɨnyɨne kuryaraavɨ kwazaakeꞌneihɨrɨ yɨhɨmwaaihɨdeinyɨra. ");
INSERT INTO byr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kwaamuꞌnanyainyɨ sɨmɨlɨka yarai manyulyadeꞌnajɨ nɨmɨre sɨmunyavɨ nɨmɨ sainyɨ walamarakɨdɨnyaꞌnajɨ nɨmɨrebwi maaꞌdɨvɨꞌ nɨmɨreihi yɨmaꞌnadɨvɨꞌ nɨmɨre yagaala jawɨramaarila! Sara yapɨjɨ sarɨmɨre kuryara kwazaakeꞌ bɨramaaꞌdɨvɨꞌ kwaamuꞌnanyaihi dɨmwaalyideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sareꞌ dareꞌnesɨ. Nɨmɨrebwi tewaanyabulyɨ. Taangeꞌna mɨꞌ. Sareꞌ yɨhɨhaimwagɨdeihɨlyɨ. Nɨmɨre taangeꞌ naangeꞌ mɨꞌ. Sareꞌ nɨmɨre dɨragɨnyaꞌ yɨhɨzaavɨdeihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sagaaꞌ Kwazaaka pɨrɨkɨ witɨwawɨnyavɨ tɨnnyabanne tusavɨ Jizaazai kaanna wɨna. Kaanna wɨna yadaaꞌnyɨ gamɨrera mɨdɨdɨvɨsara mɨjɨka wiadaaꞌnyɨ witɨzɨlya maarɨna yeva tɨka nyɨna. ");
INSERT INTO byr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tɨka nyɨna yadaapɨjɨ Perɨzɨyara dazavɨ tɨnna wanganna, sarɨ wɨdɨna “Yɨthaa! Gɨmɨdɨdɨvɨsara wawɨnya yɨvanɨgasaꞌna nemɨre kwazaakevɨ kɨwɨnyaꞌ galazekɨvaimanɨgasarera gɨmɨrera!” ");
INSERT INTO byr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sara wɨdɨna kyeꞌ wɨdɨna “Kayaaꞌna myɨwaava. Ne Devitɨ yaake dɨnɨka dazavɨ madanganyadɨvɨtaihi daa! Nɨmɨ dɨwe dazagaaꞌ sahwalyɨ yeva gamɨrerajɨ mɨjɨka mwaalesagaakɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yɨ sagaaꞌ sahwara Gotɨyare angevɨ wɨlɨna yɨna yeva gɨrɨkula Gotɨyarɨne warɨke tɨka nyɨna yeꞌ. Gɨrɨkula tewaanya sa Devitɨjɨ gamɨrerajɨ tɨka nyaꞌne mɨꞌ. Aawa. Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta gavera tɨka nyaꞌnengɨra. Tɨka nyɨna yesaꞌna kɨwɨnya saꞌ galazekɨvaina yeta kɨrɨꞌ Gotɨyai yagaala mujakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nabaai Kɨwɨnyavɨ dɨnɨka pɨrɨvɨ madanganyadɨvɨsaihi daaka! Sareꞌ dara dɨnɨkesɨ. Kwazaakegaaꞌ Gotɨyare Angevɨ Gotɨyarɨna yɨraꞌdɨvɨsara wawɨnya yɨpɨnerera. Yagaala mwarika! Kwazaakegaaꞌne kɨwɨnya dɨnɨkengɨ pariꞌmaꞌdɨvɨsarera. Kɨrɨꞌ yɨwetawakya maayare.” ");
INSERT INTO byr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Gamɨnyɨna keꞌbaꞌna wɨdɨna “Dathaꞌ yɨhɨthɨvanɨge. Kwaaka davakɨ pwai Gotɨyare Angeꞌ wavɨlavɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yɨ Gotɨyare bukuyavɨ dara dɨnɨꞌ ‘Sipɨzipɨyaraavɨ yaasɨwaꞌna manyɨjaavɨpɨneihɨlyɨ. Aala! Pwaraavɨna kale gaimwangeꞌna nyɨvuꞌnɨvanɨꞌ.’ Sara dɨnɨkeꞌ nayaa yawɨrangabɨzɨ kwajɨ aꞌmwe kayaaꞌnanya maayaraavɨna ‘Sahwara Kɨwɨnyaꞌ galazekɨvaimwaaꞌ,’ majɨ kyɨpɨdɨka! ");
INSERT INTO byr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sareꞌ dareꞌnesɨ. Aꞌmweraavɨne Kaimɨraayai Kwazaakegaaꞌneꞌ maremwaalɨkelyɨra. Sarevɨdaaꞌnyɨ nɨmɨre yagaala dazavɨ dɨmɨdɨnyɨla!” ");
INSERT INTO byr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sabadaaꞌnyɨ Jizaazai kaanna wɨna yaka kumɨre lotuangevɨ wɨlɨna. ");
INSERT INTO byr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yɨthaanyi, saba aꞌmwe pwai gamɨre asaꞌ yaalɨka mena yɨnɨkei mwaalɨna. Sahwarɨna yawɨꞌdɨvɨꞌ dɨnyɨna “Kwazaakebwi kayaaka kyojɨ Jizaazarɨ kotɨya jaana!” dɨneva sarɨ yɨdaanganna “Kwazaakegaaꞌ nalaavɨnakeraavɨ nawɨꞌnya yavadaꞌgalaadevwi dɨngaka? Kɨwɨnyaꞌ galazekɨvalaadevwi dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sara kudeꞌ sai wɨdɨna “Sarɨmɨjɨya pwai kwazaakegaaꞌ kaviꞌnɨnna pɨrɨvɨ gamɨre sipɨzipɨya pwai walaraawɨna yajarɨ malɨmwagyada mamwagiꞌnamakilyɨ yadei gawalaka! ");
INSERT INTO byr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sarɨmɨjɨyai yarai mwagiꞌnamakidaavadelyɨ. Kwazaakegaaꞌna maanga aawana! Sipɨzipɨyai maalɨkelyɨra. Aꞌmwei naangaangelyɨra. Sarevɨdaaꞌnyɨ Kwazaakegaaꞌ aꞌmweraavɨne wɨgaimwangeꞌ Kɨwɨnyavɨna tewaanyasɨ.” ");
INSERT INTO byr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sara wɨdaka asaꞌ yaalɨka mena yɨnɨkerɨ wɨdɨna “Gɨnnya asaꞌ dɨvyaasɨbwaꞌnana!” Sagaaꞌ gamɨre ata yɨwɨbwaꞌnyɨna yada asi ayabaaibɨꞌ ata pwibɨꞌ maamɨdaryi yɨmaꞌnyɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kɨrɨꞌ Perɨzɨyara bwalyuna yɨna yeva “Jizaazarɨ tamakaana!” deva yagaalyaꞌ jamungajɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jizaazai kumɨre tamakyaꞌne savɨna mena yawɨꞌna yaka saba yagalyaꞌmaꞌna, kaanna wɨna. Nabaai aꞌmwe kwalaalyara mɨdɨnna yeꞌ. Sara kyeꞌ aꞌmwe nalaavɨnaka yuyaraavɨ tewaanya yavadaꞌgaina yɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yavadaꞌgaina yɨna yaka dɨragɨnna wɨdɨna “Gɨmɨnyɨneꞌna yɨweꞌ pwaraavɨ mujɨwaakɨnna!” ");
INSERT INTO byr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Gotɨyarɨ wɨꞌnawɨjɨwakyaakei Aazaayai dɨnɨkeꞌ “Yunebanna yɨꞌmwannana!” Gotɨyai kadaꞌ sara yɨna yaꞌ. Sahwai kave yabwina dareꞌ dɨnɨkesɨ. Gotɨyai sahwarɨna dara jaaꞌ ");
INSERT INTO byr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yɨthaanyi! Wɨdahɨlakɨwei nyɨdaayade tewaanyalyɨ. Sahwarɨna nɨmɨnyɨ tewaanya nyɨvuꞌnadelyɨ. Nɨmɨre sɨmunya yɨlaaya yadelyɨ. Nɨmɨre Kuryarɨ sahwarɨna yɨlawɨmwaaihɨdelyɨ. Ajɨmya yuyangɨyaraavɨ yawɨbwasaꞌnebwina wɨjɨwaakadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Maiyagaala majada jaka dathei mɨꞌ. Tuta naangengɨ kadɨka wɨꞌnɨpɨꞌdei mɨꞌ. Gamɨre maanguraayaꞌ jaka damaryadei mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Suyarɨꞌ walagɨꞌduraꞌnɨkerɨꞌ mwagalɨvɨpaidɨvɨtabaaibɨꞌ Dɨragɨmaayaraavɨ kayaaka yɨgaladei mɨꞌ. Laamɨvananyavɨre wikɨyaꞌ maalɨꞌna nadeꞌ yɨgaaꞌmwadɨvɨtabaaibɨꞌ Sɨmunyavɨ nɨmɨnyɨna maalɨꞌna yawɨꞌnɨkeraavɨ yɨgaaꞌmwagathei mɨꞌ. Kuna yadaawori yɨdaꞌmaraangebwi yunebanna waradehaaꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ajɨmya yuyangɨyara sahwarɨ lɨmwabɨꞌdelyɨ. Padaihasamaaryaꞌnerɨ sahwara yemwaaibɨꞌdelyɨ.” Pɨropetɨya Aazaayai sara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dazagaaꞌ gamɨnyawɨnna aꞌmwe pwarɨ makabɨna yɨna yeꞌ. Aꞌmwe dazarɨ yɨmakei wɨlamwaalɨkei. Yɨmakei wɨlamwaaidɨsɨyaꞌna sahwai tɨbɨnyai yɨmaꞌnyɨna, maanga bɨpainɨkei yɨmaꞌnyɨna yakelyɨ. Sahwarɨ Jizaazai nawɨꞌnya yavadaꞌgaina yakevɨdaaꞌnyɨ maanga bɨpainɨkei yagaala dɨna yaka tɨnna wanganna. ");
INSERT INTO byr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yɨ aꞌmwe kwala bwaꞌnaanya yuya lɨka yɨwainɨgulɨna yɨna yeva dɨnyɨna “Dazai Ne Devitɨmɨre Kaimɨraayarɨ yemwaaimanɨgo sahwai dɨngaka!” ");
INSERT INTO byr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kɨrɨꞌ Perɨzɨyara saꞌ kadɨka wɨꞌnyɨna yeva dɨna “Aꞌmwe dazai yɨmakeraavɨ maremwaaidei Biyelɨzɨvulɨmɨre dɨragɨnyaꞌ maaraka yɨmakeraavɨ wɨdaasɨvanɨkelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sara dɨna yadaapi kumɨre sɨmunyangɨ mena yawɨranganna yaka wɨdɨna “Maremwaaide gave pɨbadaaꞌnyara pɨvakaai mararangɨvainadɨvɨꞌ mala bwaꞌnɨpɨjaꞌ maremwaaide dazaꞌ kayaaka yɨmaꞌnadesɨra. Nabaai aꞌmwe anga pɨbanyara anga kɨrɨvɨyara tɨnnyaba mararangɨvainadɨvɨꞌ mala bwaꞌnɨpɨjaraavɨreba waradeꞌ mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sabaaibɨꞌ Saataanɨmɨrera jaapainyɨna yadɨvɨꞌ pwara Saataanɨmɨre pwaraavɨ wɨdaasɨpɨjavɨdaaꞌnyɨ Saataanɨmɨre maremwaaideꞌ gara daavadevaka! Aawa. Kayaaka yɨnadevaakɨra. Kɨrɨꞌ Saataanɨ manyɨgaimwagyada yɨmakeraavɨ wɨdaasɨvanɨge. ");
INSERT INTO byr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nabaai nyɨdɨwaasaꞌna Saataanɨmɨre dɨragɨnyavɨ yɨmakeraavɨ wɨdaasɨwɨjɨ kwajɨ sarɨmɨre mɨdɨdɨvɨsara yɨmakeraavɨ wɨdaasadɨvɨsara dɨragɨnyavɨ aaihwarevɨ wɨdaasɨvanɨgaꞌ! Sareꞌna mɨꞌ. Sarevɨ sarɨmɨrera sarɨmɨnyɨ yawɨbwaꞌna ‘Aꞌmwera Saataanɨmɨre dɨragɨnyavɨ yɨmakeraavɨ mudaasɨvanɨgava! Sabwi aawaawa!’ Sara yawɨbwapɨꞌderera sarɨmɨrera. ");
INSERT INTO byr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kɨrɨꞌ Gotɨyare Kuryai nyɨgaimwadaawojɨ yɨmakeraavɨ wɨdaasɨwɨjaꞌ yɨ sarɨmɨ jawɨranganyide ‘Nemɨnyawɨnna Gotɨyai maremwaaideꞌ mena bɨwaka! Sareꞌna yɨmakeraavɨ sahwai wɨdaasɨvanɨkelyɨ.’ Sara jawɨranganyide.” ");
INSERT INTO byr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Gamɨnyɨneꞌna keꞌbaꞌna wɨdɨna “Pwai kwai yawɨrajai ‘Dɨragɨnyare gɨlyɨvɨsangɨ gara maarɨdeinyaka?’ Dɨragɨnyare angevɨ wɨlɨna yaka Dɨragɨnyarɨ wɨla yuneꞌna yɨrapwekaka yɨ sagaaꞌ gɨlyɨvɨsa maragɨꞌmwagamaaꞌna yɨwakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Pwai manyɨgaimwagyɨvanɨkei sahwai nɨmɨre yɨkamaangelyɨ. Sai nɨmɨreraavɨ myeꞌmwannayɨꞌbwaramwaaihyɨvanɨgolyai pɨwɨ pɨwɨ nɨmɨreraavɨ tamaasɨvanɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Sarevɨ yɨhɨthɨvanɨge. Kayaaꞌnanya yuyajɨ bɨrala saza dadɨvɨsajɨ Gotɨyai marasɨꞌnadelyɨ. Kɨrɨꞌ Kurya Tewaanyarɨna yagaaibɨraizɨka dazare wagɨlyaꞌ marasɨꞌnadei mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Gazaizai Aꞌmweraavɨne Kaimɨraayarɨna yagaala kayaaꞌnanyaꞌ bɨrala dazai yɨ gamɨre wagɨlyaꞌ Gotɨyai wɨmarasɨꞌnadelyɨ. Kɨrɨꞌ gazaizai Kurya Tewaanyarɨna yagaala kayaaꞌnanyaꞌ dazai yɨ gamɨre wagɨla dazaꞌ marasɨꞌnadei mɨꞌ. Aawa. Dahaaꞌ kɨgaasɨ dɨvi yɨmaꞌnade kɨgaasɨ waragwothesɨ. Kurya Tewaanyai yadengɨna pwai bɨralyaꞌ dazai ‘Saataanɨmɨre dɨragɨnyasɨreva,’ wagɨla dazaꞌ Gotɨyai marasɨꞌnadei mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nabaai sarɨmɨ yawɨrangabɨneihɨlyɨ ‘Yɨsɨꞌ tewaanyɨkɨ,’ dɨpɨjaꞌ ‘Yɨ gamɨre yɨsɨla kɨnɨjɨ tewaanyangɨra,’ dɨpɨneihɨlyɨ. Nabaai ‘Yɨsɨꞌ kayaaꞌnanyɨkɨ,’ dɨpɨjaꞌ ‘Yɨ gamɨre yɨsɨla kɨnɨjɨ kayaaꞌnanyangɨ,’ dɨpɨneihɨlyɨ. Sareꞌ dareꞌnesɨ. Yɨsɨlanna aꞌmwera wangadɨvɨꞌ yɨsɨlyangɨne yɨsɨkana yawɨꞌdɨvɨkɨ. (Nabaai “Jizaazai tewaanyanna yadevɨdaaꞌnyɨ sahwai tewaanyalyɨreva.”) ");
INSERT INTO byr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Naawɨnaanyarɨdaaꞌnyaihi, aꞌmwe kayaaꞌnanyaihi mwaaihasaꞌna yagaala nawɨꞌnya gathaꞌdara dɨpɨneihɨlaka! Sareꞌ dareꞌnesɨ. Aꞌmwere sɨmunya yunevɨ yawɨꞌde daza maangevɨdaaꞌnyɨ dadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Aꞌmwe nawɨꞌnyai gamɨre sɨmunyavɨ yawɨta tewaanya wɨlawaꞌdelyɨ. Sarevɨdaaꞌnyɨ yagaala yuna tewaanyabwina dadelyɨ. Aꞌmwe kayaaꞌnanyai gamɨre sɨmunyavɨ yawɨta kayaaꞌnanya wɨlaꞌdelyɨ. Sarevɨdaaꞌnyɨ yagaala kayaaꞌnanyabwina dadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kɨrɨꞌ sarevɨdaaꞌnyɨ yɨhɨthɨvanɨge. Kotɨya maryaꞌne yɨrɨkerɨkɨ Gotɨyai yagaala gazaza yaasɨwaꞌna damaryadɨvɨsanna maryawɨbwaradengɨra. ");
INSERT INTO byr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sareꞌ dareꞌnesɨ. Yune gɨmɨre yagaala dadɨnya dazahɨrɨvɨna Gotɨyai ‘Aꞌmwe yɨdaꞌmaraangeigɨnyɨra,’ gɨthathelyɨ. Nabaai gɨmɨre yune yagaala dadɨnya sahɨrɨvɨna ‘Aꞌmwe kayaaꞌnanyaigɨnyɨra,’ gɨthathelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Dazagaaꞌ Kɨwɨja pwarajɨ Perɨzɨya pwarajɨ sara maꞌmaaꞌna “Wɨjɨwaakyaigɨ, nevuꞌnɨvanɨkeꞌna tɨnna wanganyaꞌnevɨna atɨka maruꞌnasaꞌ wɨjɨwaainyaꞌ ja! (Wanganawaajɨ ‘Jizaazai nebulyaꞌ nedɨvanɨkelyɨ,’ yawɨraadera.)” ");
INSERT INTO byr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Wɨdɨna kyeꞌ sai jaꞌnawɨdɨna “Dahaasaihi kayaaꞌnanyaihɨlyɨ. Aꞌmwei mwaaidɨꞌnyɨ aꞌmweꞌ pwaraavɨ tidavamaryadevaaibɨꞌ Gotɨyarɨ nayaa mi yadɨvɨꞌ gevwi yadɨvɨsaihɨlyɨ. Sareihi nyɨdɨwaaꞌ ‘Wɨjɨwaainyaꞌ wanganawaajɨ gyawɨranganaadeinera.’ Kɨrɨꞌ wɨjɨwaainya pɨnɨ myɨhibwarɨdaakwɨwɨna! Aawa. Wɨjɨwaainya pɨropetɨya Jonaamɨreꞌna yune sahɨrɨꞌna yɨhibwarɨdaakwɨdeinyɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sareꞌ dareꞌnesɨ. Kɨgaaꞌ Jonaa jawɨnya naangevɨre munyɨkɨ wɨlaꞌdɨꞌnyɨ yɨrɨka daryaai darɨꞌ wavɨlavakabaai Aꞌmweraavɨne Kaimɨraayai kwaakevɨ kusawɨ wɨlaꞌdozɨ yɨrɨka daryaai darɨꞌ wavɨlavadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kotɨya maryaꞌnevɨ Menya Ne sɨnnawɨnya Ninɨva mwaalyarajɨ dahaasa daihɨlyɨ daavapɨjɨ sahwara sarɨmɨre kayaaꞌnanyabwina yɨhɨzɨdapɨꞌderera. Sahwara Jonaa yagaala wɨjaakevɨ kadɨka nayaa wɨꞌneva sɨmunya mudɨkebwina yawɨramaryaasaꞌnanyɨ. Yɨthaanyi, dahaaꞌ dava pwai mwaalɨꞌ Jonaamɨ wavɨlavɨkei. Sahwarɨ sarɨmɨ kadɨka wɨꞌneva malɨmwagaryɨgasaꞌna sahwara yɨhɨzɨdapɨꞌdeihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kotɨya maryaꞌnevɨ aꞌmwe naangeꞌ kwinɨyaꞌ kwaaka aayawɨdaaꞌnyavɨjɨ dahaasa daihɨrɨjɨ kihithɨkaavojɨ kwinɨya dazaꞌ sarɨmɨre kayaaꞌnanyabwina jalɨkurakadesɨ. Tuta saamɨnaanga kɨrɨvɨ Solomonɨmɨre kunya nawɨꞌnyaangeꞌ wɨꞌnyaꞌneꞌ byaakeꞌnanyɨ. Yɨthaanyi, dahaaꞌ dava pwai mwaalɨꞌ Solomonɨmɨ wavɨlavɨkei. Sahwarɨ sarɨmɨ kadɨka wɨꞌneva mamɨdɨnyɨvanɨgasaꞌna kwinɨya dazaꞌ yɨhɨzɨdavadeihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Keꞌbaꞌna wɨdɨna “Nabaai yɨmakei aꞌmwe pware munyɨkɨdaaꞌnyɨ bwalaawɨna yaka anga aꞌgaaye pɨbanna bɨryaꞌnei yaalɨkɨryabanna kaanya yɨwɨnamaꞌna. Kaanya yɨwɨnamaꞌna yada kɨrɨꞌ mwaalyaꞌne saba mabɨramaari yajai ");
INSERT INTO byr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","dɨna ‘Nɨnnya angevɨdaaꞌnyɨ bwalaawɨna yɨwebanna ayɨna wɨdeinyɨ.’ Sai wɨna, anga savɨ tɨnna wanganna ‘Mena tɨrɨmaaya bwakɨreva aaraare yɨdakɨwaata kuneꞌ daaka! Yune kunesɨ. Wikɨra.’ ");
INSERT INTO byr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sara dazai kaanna wɨna, yɨmaka ata purɨdaaꞌnyɨ pwaraalyaraavɨ wɨjɨmaꞌnaawɨna. Yɨmaka gazaizare kayaaꞌnanyabwi yɨmaka sɨnnawɨnyare kayaaꞌnanyaburɨ wavɨlavɨkerera. Sareraavɨ wɨjɨmaꞌnaawɨna yaka aꞌmwere munyɨkɨ yuyara bulamwaaina. Sɨnnawɨ yɨmaka pwarɨna aꞌmwe sai kayaaꞌna mwaalɨna, dɨvidaaꞌnyɨ yɨmaka kayaaꞌnanaangeraavɨna sai kayaaꞌna naanna mwaalɨna. Nabaai yune sasare sahɨbwina dahaasa aꞌmwe kayaaꞌnanyaihɨrɨneꞌ yɨmaꞌnadesɨ.” ");
INSERT INTO byr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kwala bwaꞌnaanyavɨ yagaalyaꞌ kuna wɨdadaaꞌnyɨ, yɨthaanyi, mwasawɨ gamɨre ganaangesɨ gyaꞌmwerajɨ bathaaꞌna. “Gamɨjɨ yagaala yeꞌmwannadaana!” deva bathaaꞌna yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Bathaaꞌna yɨna yadapɨjɨ pwai tɨnna wanganna yaka Jizaazarɨ wɨdɨna “Yɨthaanyi, gwaangesɨ jaꞌmwerajɨ ‘Yagaala yeꞌmwannadaana!’ deva mwasaba bathaakava!” ");
INSERT INTO byr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sara kudaꞌ kɨrɨꞌ sahwarɨ maꞌmaaꞌna “Nɨmɨnyɨ nɨwaaꞌ aaihɨrɨvaka? Nɨmɨnyɨ nyaꞌmwera aaihwaravaavaka?” ");
INSERT INTO byr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Wɨdɨna yaka gamɨnyɨ mɨdɨdɨvɨsaraavɨ ata yɨdaꞌna yaka wɨdɨna “Yɨthaanyi, dazahwara kumɨre kuryaraavɨna nɨmɨnyɨ nɨwaasɨ nyaꞌmwerajɨ sanaka mwaaihaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sareꞌ dareꞌnesɨ. Sɨgunyavɨ Nɨmaamaangei mwaalɨkere sɨmunyabwi mɨdɨnajai sahwai nyaꞌmwelyɨ. Sahwai nyaꞌmwesɨ. Sahwai nɨwaasɨ.” ");
INSERT INTO byr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yɨrɨka sarɨkɨ angevɨdaaꞌnyɨ Jizaazai walyuna yaka aalɨbunyavɨna wɨna yaka maangebaarɨ walamwaaina. ");
INSERT INTO byr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Walamwaaina yadɨꞌnyɨ gamɨnyawɨnna kwala bwaꞌnaanya naanga yɨꞌbwaꞌnaabɨna. Sara yesaꞌna botɨya pukɨ yɨladɨkwosɨꞌna yaka yɨlamwaaina yadɨꞌnyɨ aalɨbumaangebaarɨ kwala bwaꞌnaanya yuyaꞌ daavɨna. ");
INSERT INTO byr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Daavɨna yadapi keꞌbaꞌnanyangɨ yagaala kwalaalya dara wɨjɨwaakɨna “Yɨthaanyi, gannya wawɨnyavɨ aꞌmwe pwai witɨzɨla pɨraihɨrakyaꞌnei wɨna. ");
INSERT INTO byr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wɨna yaka pɨraihɨrakadaaꞌnyɨ witɨzɨla pɨnɨ tutaanyavɨ bwalaraawɨna. Sarengɨ yusara bamaranyɨna. ");
INSERT INTO byr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nabaai pɨba amwi sɨla naangejɨꞌ waꞌdɨꞌnyɨ aꞌba kwaaka maalɨkejɨꞌ warɨkeba witɨzɨla pɨnɨ bwalaraawɨna. Kwaaka samwinariꞌ maayabanneꞌna sa yarai yɨrɨꞌna. ");
INSERT INTO byr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kɨrɨꞌ nyɨlyai bilyɨrɨꞌna yada baihinyɨna. Sara yadaaꞌnyɨ sa pwipula dɨragɨnya maaya warɨna yadevɨ yɨnahu yawaka baidaaꞌnyɨna yada baihɨꞌna. ");
INSERT INTO byr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kwaakevɨ lannake waꞌdɨꞌnyɨ aꞌba witɨzɨla pɨnɨ bwalaraawɨna yaka yɨrɨꞌna kyaꞌ lange yɨrɨꞌna yaka langa sabara naanga bilaawɨna yada witɨzɨla yɨrɨꞌdengɨ dathɨwaaina. ");
INSERT INTO byr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kɨrɨꞌ witɨzɨla pɨnɨ kwaaka mɨnarɨnaka nawɨꞌnyavaakɨ bwalaraawɨna yɨna yada tɨka munne yɨmaꞌnyɨna. Yɨ pɨnɨ 100 yɨmaꞌnyɨna, yɨ pɨnɨ 60 yɨmaꞌnyɨna, yɨ pɨnɨ 30 yɨmaꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aꞌmwe kadɨꞌnakei kadɨka wɨꞌnana!” ");
INSERT INTO byr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Gamɨnyawɨnna gamɨre mɨdɨdɨvɨsara yɨkabɨna yeva dara buthɨna “Aꞌmweraavɨ keꞌbaꞌnanya beꞌna wɨdɨvanɨgɨna?” ");
INSERT INTO byr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sara buthɨna kyeꞌ sai wɨdɨna “Sɨgunyavɨ mwaalɨkei aꞌmweraavɨ maremwaaidevɨne yoimavajalɨkurakyanna Gotɨyai mena yɨhivwarɨdaakuwakeꞌnanyɨ. Kɨrɨꞌ sahwaraavɨ yawɨta saꞌ mujaayɨwakeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sareꞌ dareꞌnesɨ. Pwai nɨmɨnyɨne sɨmunya kɨnɨnnakei nɨmɨnyɨna nayaa yawɨrojɨyarɨ Gotɨyai sɨmunya kwalaalya kujaavojɨ sahwai sɨmunya nawɨꞌnya naanga naanga kɨnɨnnakei yɨmaꞌnadeꞌnanyɨ. Pwai kadɨka nyuꞌnajai nɨmɨnyɨna navɨka mwaalojɨ nɨmɨnyɨne sɨmunya maayarɨ Gotɨyai sɨmunya maalɨka daza kɨmɨlɨꞌ marasɨꞌnadeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sarevɨ keꞌbaꞌnanya wɨdɨvanɨge. Dara dɨnɨꞌ ‘Tɨnna wangadaapi kɨrɨꞌ myawɨranganyɨvanɨgaꞌ. Kadɨka wɨꞌnadaapi kɨrɨꞌ muꞌnamaarivanɨgaꞌ. Aaya kaavɨlyaꞌ myawɨramaari yɨvanɨgaꞌ.’ Sareꞌna keꞌbaꞌnanya wɨdɨvanɨge. ");
INSERT INTO byr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sareraavɨna Pɨropetɨya Aazaayare yagaala pɨrɨꞌ wɨjaakeꞌ nebulyaꞌna yuneꞌna yɨmaꞌnɨnɨkesɨ. Dara dɨnɨkesɨ. Gotɨyai dara wɨjaaꞌ ‘Kadɨka wɨꞌnadɨvɨꞌ kɨrɨꞌ kaavɨlyavɨ jawɨramaaryideihi mɨꞌ. Tɨnna baihanaꞌdɨvɨꞌ kɨrɨꞌ kaavɨlyaꞌ jawɨranganyideihi mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Aꞌmwe dazaraavɨre sɨmunya mena jɨnnɨnɨkeꞌnanyɨ. Kadɨka maaꞌna widera kadɨka wɨꞌnɨwaasaꞌnanyɨ. Kumɨre tɨnnyai tɨbarya dɨragɨnna yɨwaasaꞌnanyɨ. “Tɨnna nayaa nanganaadɨka!” deva “Kadɨka nayaa nuꞌnaadɨka!” deva “Sɨmunya nayaa nyawɨraadɨka!” deva Sahwara sara myɨpɨjɨ kwajɨ Nɨmɨnyɨna gɨnyɨwannɨpɨjɨ kwajɨ Tewaanya yavadaꞌgalamwaaihɨna kyɨwɨdɨka!’ Aazaayai sara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kɨrɨꞌ sarɨmɨ yɨlaaya yɨpɨneihɨlyɨ. Sarɨmɨre tɨnnyai yawɨrangamanɨgasaꞌnanyɨ. Yɨ sarɨmɨre kadɨkiꞌ wɨꞌnamaaꞌmanɨgasaꞌnanyɨ. Sareꞌna yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkeihɨlyɨra. ");
INSERT INTO byr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sareꞌ dareꞌnesɨ. Nebulyaꞌna yɨhɨthɨvanɨge. Kɨgaakuna Gotɨyarɨ wɨꞌnawɨjɨwakyaata pɨropetɨya kwalaalyarajɨ aꞌmwe yɨdaꞌmaraanga kwalaalyarajɨ tɨnna wanganyaꞌneraavɨ wɨvuꞌnakera tɨnna mwanganyɨ. Sarɨmɨ tɨnna wangamanɨgasangɨ tɨnna mwanganyɨ. Nabaai sarɨmɨ kadɨka wɨꞌnɨvanɨgasangɨna sahwaraavɨ wɨvuꞌnakera kadɨka muꞌnyaasare. Tɨnna sara wangamanɨgasaꞌnajɨ kadɨka sara wɨꞌnɨvanɨgasaꞌnajɨ yɨlaaya yɨpɨneihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Sarevɨdaaꞌnyɨ sarɨmɨ keꞌbaꞌnanya witɨzɨla pɨraihɨrakamaryadevɨ aaya kaavɨlyavɨ duꞌnamaarila! ");
INSERT INTO byr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Witɨzɨla tusavɨnya daresɨ. Gazaizai, Gotɨyai maremwaalade yagaalyaꞌ kadɨka yaasɨwaꞌna wɨꞌnada aaya kaavɨlyaꞌ myawɨramaaryaderyawɨnna Kayaaꞌnanyai widaavada gamɨre sɨmunyavɨ yagaala wɨlaburɨnnɨkeꞌ yarai yɨpalamarasɨꞌdelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Witɨzɨla sɨla naanga kɨnɨnnakebanne daresɨ. Pwai yagaalyaꞌ wɨꞌnada yɨlaaya yɨna yada yɨmeꞌnyaꞌbɨꞌ maarɨna. ");
INSERT INTO byr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kɨrɨꞌ sahwai witɨya pwipula dɨragɨnya maaya waayɨkabaaibɨꞌ dɨragɨmaayai maalɨkegaaꞌ yagaalyaꞌ yagalyaꞌmaꞌna. Pwara nɨmɨre yagaalyaꞌna maanga wɨdɨna, taanginya wɨjaavɨna. Kayaaꞌna yadɨvɨsaꞌna yɨmeꞌnyaꞌbɨꞌ yagalyaꞌmaꞌdelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Witɨzɨla lannakebanne daresɨ. Pwai yagaalyaꞌ wɨꞌnyɨna yada lɨmwanna yada dahaaꞌne sɨmunya kwalaalya kuna yawɨꞌda Kwaakevakɨya gɨlyɨvɨsanna nɨgwia kwalaalya mariꞌbwarakyaꞌna yawɨꞌda yɨ daza nɨmɨre yagaalyavɨ dathɨvaidelyɨ. Yɨ sareꞌna tɨka munne yɨꞌnade mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Witɨzɨla nawɨꞌnyavaakɨne daresɨ. Pwai yagaala kadɨka wɨꞌnada aaya kaavɨlyaꞌ nayaa yawɨrangada tɨka munne yɨꞌnadevaaibɨꞌ tewaanya naanga yadelyɨ. Pwai waanɨ aadɨretɨyai wana nawɨꞌnyaanga yadelyɨ. Pwai sɨkɨzɨtiyai wana nawɨꞌnya yadelyɨ. Pwai tetiyai nawɨꞌnya yadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Keꞌbaꞌnanya pɨrɨꞌ wɨjaavada dara wɨdɨna “Sɨgunyavɨya maremwaaideꞌ aꞌmwe pwai sɨla nawɨꞌnya gannya wawɨnyavɨ pɨraihɨrakakabaaibɨꞌnesɨ. ");
INSERT INTO byr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kɨrɨꞌ aꞌmwera se waꞌdapiyavɨ sarɨne yɨkamaangei bɨna yaka kurɨvaarɨya kayaaꞌnanyangɨre sɨla witɨyangɨ aꞌba bwasɨꞌna yaka kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kaanna wɨna kyaꞌ dɨvi witɨya yɨrɨꞌna yaka sɨla yɨꞌnyɨna kyaꞌ dara wanganesaꞌ ‘O! kurɨya kayaaꞌnanyajɨ waayɨke daaka!’ ");
INSERT INTO byr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Miꞌna deva yaasɨwaꞌwawɨnyara wɨna yeva gyakwarɨ wɨdɨna ‘Maremwaaidɨnyaigɨ, gɨnnya wawɨnyavɨ sɨla nawɨꞌnya pɨraihɨrakagɨnya midaaka! Sarevɨdaaꞌnyɨ kurɨvaarɨya kayaaꞌnanya wangamwoya gawɨdaaꞌnyangaka?’ ");
INSERT INTO byr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wɨdɨna kyeꞌ sai wɨdɨna ‘Yɨkamaanga pwai kyakɨra.’ Wɨdɨna kyaꞌ yaasɨwaꞌwawɨnyara wɨdɨna ‘Wawaajɨ kurɨvaarɨya yuya daza guvɨlayɨꞌbwarakɨna yaajɨwona?’ ");
INSERT INTO byr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kɨrɨꞌ sai wɨdɨna ‘Aala. Sarɨmɨ kurɨvaarɨya mariꞌbwarakɨpɨjaꞌ witɨyajɨ nyelaapɨdɨka! ");
INSERT INTO byr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Waayana! Yuyawaai mena kirɨvamwannakɨlyɨ sɨla yune yabwaryagaaꞌnannengɨra. Witɨzɨla yabwaryagaaꞌ aꞌmwe wawɨnya dazavɨyaraavɨ wɨdɨdeinyɨra “Sɨnnawɨ sarɨmɨ kurɨvaarɨya kayaaꞌnanya mena mariꞌbwarakapɨjɨ dɨka marirayaꞌne wɨla dɨmaramurɨtawakyi! Kɨrɨꞌ witɨya mariꞌbwarapɨjɨ anga wɨlaryaꞌnevɨ nɨmɨre tɨka munne dɨmarakyidengɨ,” wɨdɨde,’ wɨdaꞌ.” ");
INSERT INTO byr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Keꞌbaꞌnanya pɨrɨꞌ wɨjaavɨna. Sɨgunyavɨya maremwaaideꞌ daꞌbɨsasɨ. Maazɨtetɨya yɨsɨkɨdaaꞌnyɨ yɨsɨla yɨrɨꞌda saamɨnyɨꞌ gɨryadevaaibɨꞌ sɨnnawɨ Gotɨyai pwara pwaraavɨ maarɨna yojɨ dɨvi aꞌmwe kwala naanga naanga wɨmaremwaaladevɨnanyɨ. Aꞌmwe pwai yɨta maazɨtetɨya sɨkɨdaaꞌnyɨ yɨsɨlyamɨlɨꞌ maarɨna yaka gannya wawɨnyavɨ maraburɨnna. ");
INSERT INTO byr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Maazɨtetɨyɨkɨre yɨsɨlyaꞌ, yɨsɨla tɨka munne pukaavɨrebɨta mɨꞌ. Aawa. Saꞌ wana maalɨkesɨ. Kɨrɨꞌ dɨvidaaꞌnyɨ yɨsɨꞌ naanga yɨmaꞌnyɨna, yuya tɨka munne wawɨnya savɨya sangɨ wavɨlaꞌna yadikɨra. Yɨsɨꞌ yɨmaꞌnadaaꞌna yadɨꞌnyɨyɨkɨ yusara sɨgunyavɨyara gamɨre taanyabaraavɨ bamwaaina yesɨkɨra. ");
INSERT INTO byr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Keꞌbaꞌnanya pɨrɨꞌ wɨdɨna “Sɨgunyavɨya maremwaaideꞌ yɨzɨyaꞌbɨsasɨ. Aꞌmwe pɨrɨꞌ yɨzɨya dazaꞌ maarɨna yojɨ gɨrɨkulyaꞌne pɨlawaaya naanga yegɨnyɨwanna. Dɨvidaaꞌnyɨ gɨrɨkula yuya daza lɨwɨnya mɨlamakina yakesɨ.” ");
INSERT INTO byr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yagaala yuya sa Jizaazai kwala bwaꞌnaanyangɨ yune keꞌbaꞌnanya yagaalyavɨna wɨjɨwaakakengɨ. Yagaala aane pɨrɨꞌ kɨrɨꞌ kuꞌmaayaba wɨjalɨkurakakei mɨꞌ. Aawa. Yune keꞌbaꞌnanyavɨna wɨjɨwaakaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sarevɨdaaꞌnyɨ pɨropetɨyai dɨnɨkeꞌ yunebanna yɨꞌmwannyɨna. Jizaazarɨna dara dɨnɨkesɨ. Maangeꞌ taavaꞌmujɨ keꞌbaꞌna dɨdeinyɨ. Kwaaka davaꞌ wakyaakevɨdaaꞌnyɨ Lɨka yulyarɨkenajɨ yoimavɨdeinyɨ. ");
INSERT INTO byr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sagaaꞌ Jizaazai kwala bwaꞌnaanyangɨ yagalyaꞌmaꞌna yaka angevɨ wɨlɨna. Wɨlɨna kyaꞌ gamɨre mɨdɨdɨvɨsara gamɨnyawɨnna yɨkabɨna yeva wɨdɨna “Keꞌbaꞌnanya dazavɨne aaya kaavɨlyaꞌ wawɨnyavɨ kurɨvaarɨya kayaaꞌnanya pwaꞌnɨka dazaꞌna dɨnejɨwaakya!” ");
INSERT INTO byr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sara wɨdɨna kyeꞌ dara wɨrɨvɨkɨꞌna “Aꞌmwei witɨzɨla nawɨꞌnya pɨraihɨrakakei sai Aꞌmweraavɨne Kaimɨraayainyɨ. ");
INSERT INTO byr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wawɨnya saꞌ Kwaaka davakɨ. Yɨ witɨzɨla nawɨꞌnya sa maremwaaidevɨne kaimɨraayarera. Yɨ kurɨvaarɨya kayaaꞌnanya sa Kayaaꞌnanya Saataanɨmɨre kaimɨraayarera. ");
INSERT INTO byr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yɨkamaanga kurɨvaarɨyangɨre pɨraihɨrakaka dazai Kotɨya Maryadelyɨ. Tɨka munne yabwaryaꞌnegaaꞌ, Kwaaka davaꞌ aayagaaꞌnesɨ. Wawɨnya wɨdaayadɨvɨsara yabwaryaꞌnera sahwara Gotɨyare mamaayarera. ");
INSERT INTO byr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sarevɨdaaꞌnyɨ kurɨvaarɨya kayaaꞌnanya mariꞌbwarapɨjɨ dɨkevɨ marirapɨꞌdevaaibɨꞌ Kwaaka davakɨ yɨrɨka aayarɨkɨ yuna sasara yɨpɨꞌdere. ");
INSERT INTO byr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Aꞌmweraavɨne Kaimɨraayainyɨ nɨnnya ejelɨyaraavɨ maryasaabɨdeinyɨ. Kwaaka davakɨ nɨmɨre maremwaaidɨnyaba pwaraavɨre sɨmunya kayaaka yɨgaidɨvɨta yuyaraavɨjɨ yaasɨwaꞌna kayaaꞌna yadɨvɨta kwaraavɨjɨ maryɨꞌbwarapɨjɨ ");
INSERT INTO byr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","dɨka naangevɨ marasɨpɨꞌdere. Dɨka dazavɨ kɨnna naanga dadɨvɨꞌ kunnya maangerɨka kɨdɨkɨvainya yɨpɨꞌdere. ");
INSERT INTO byr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dazagaaꞌ Kuvɨnɨmaangere maremwaaidevɨ aꞌmwe yɨdaꞌmaraangera nyɨlyaibɨꞌ baaka naanga bavɨwɨna yɨpɨꞌderera. Aꞌmwe kadɨꞌnakei kadɨka padaꞌgalawɨꞌnana! ");
INSERT INTO byr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Sɨgunyavɨya maremwaaideꞌ, nɨgwɨbukuta pɨrɨꞌ wawɨnya pɨrɨvɨ lɨka yulyakɨnɨkabaaibɨsasɨ. Aꞌmwe pwai wawɨnya savɨ lɨkɨna yaka ‘Nɨgwɨbukusaꞌ daaka!’ daka ayɨna lɨka yulyakɨna. Sai yɨlaaya naanga yɨna, gamɨre gɨlyɨvɨsangɨna kale mwi yakei yuya marayaasɨna yaka nɨgwia naanga maaraka nɨgwɨbukusaꞌ maaryaꞌnei wawɨnya sajɨꞌ yasaawɨna. ");
INSERT INTO byr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nabaai Sɨgunyavɨya maremwaaideꞌ aꞌmwei kwaalɨturyaanga nawɨꞌnyanna nawɨꞌnyanna mubada ayɨna mubade sabaaibɨsasɨ. ");
INSERT INTO byr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sai bɨrɨna bɨrɨna yada kwaalɨturyaanga wana nawɨꞌnyaanga pɨrɨꞌ tɨnna wanganna yaka nɨgwia naanga wɨgainakei gamɨre gɨlyɨvɨta yuya marayaasɨna yaka kwaalɨturyaanga nawɨꞌnya dazaꞌ mubaawɨna, ‘Nɨmɨresɨra,’ dɨna. ");
INSERT INTO byr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nabaai Sɨgunyavɨya maremwaaideꞌ saalaalyavɨ jawɨgɨlya naangeꞌ waketabaaibɨsasɨ. Sara yadɨvɨꞌ kusawɨ jawɨnya dala nabinabinya wɨlamwaaina yeva ");
INSERT INTO byr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","yune warɨna kyeꞌ aalɨmaangebaarɨ tɨyawɨnna makulaabɨna. Makulaabɨna yeva jawɨnya nawɨꞌnyanna nawɨꞌnyanna tɨwɨnya naangevɨ marakɨna. Kɨrɨꞌ jawɨnya kayaaꞌnanya marasɨꞌna. ");
INSERT INTO byr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kwaaka davakɨya yɨrɨka aayarɨkɨ sasara yɨmaꞌnadehaakɨ. Gotɨyare mamaayara walaabapɨjɨ aꞌmwe yɨdaꞌmaraangeraavɨ tɨnnyawɨ mwaaihata aꞌmwe kayaaꞌnanyaraavɨ jaapaina yapɨjɨ ");
INSERT INTO byr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","kayaaꞌnanyaraavɨ dɨka naangevɨ maralɨvarabɨꞌdere. Dɨka dazavɨ kɨnna naanga dadɨvɨꞌ kunnya maangerɨka kɨjɨvainɨpɨꞌdere.” ");
INSERT INTO byr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sara wɨdɨna yaka gamɨreraavɨ yɨdaanganna “Yagaala yuya dangɨne aaya kaavɨlyaꞌ mena dahayawɨꞌmwaava?” Sagaaꞌ kumɨ wɨdɨna “Yo, yawɨꞌmwona.” ");
INSERT INTO byr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sai wɨdɨna “Sarevɨ Kɨwɨja gazaizai Sɨgunyavɨya maremwaaidevɨne mɨdɨdei yɨmaꞌnyɨna yakei angevɨ gyakwalaanga pwai mwaalakabaaibɨsalyɨ. Angevɨ gyakwai gannya yovɨravemwaalyavɨ wɨlɨna yaka gɨlyɨvɨta aya pɨnɨjɨ mudɨka pɨnɨjɨ makwalyaabɨna. Sabaaibɨꞌ nɨmɨrei Kɨwɨnyavɨ sɨduꞌnakei Gotɨyare yagaala ayajɨ nɨmɨre yagaala mudɨkejɨ yawɨramaaꞌdelyɨra.” Jizaazai sara wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jizaazai keꞌbaꞌnanya sa mena wɨdɨna yaka anga dazaba yagalyaꞌmakuna. ");
INSERT INTO byr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Sara yaka gannya angebanna wɨlaawɨna yaka kumɨre lotuangevɨ wɨlɨna yaka wɨjɨwaakɨna. Sarevɨdaaꞌnyɨ lɨka yɨwainɨgulaawɨna yɨna yeva dɨna “Yawɨta dazajɨ dɨragɨnya dazajɨ aꞌmwe dazai gawɨ maarakengaka! ");
INSERT INTO byr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aꞌmwe dazai kaaꞌmadaayarei midaaka! Nabaai Maarɨyaaꞌ ganaangeꞌ midaaka! Jemɨzalyɨ Jozepɨyalyɨ Saaimonɨjɨ Juthaazalyɨ gamɨnyɨ gahwaalaangera midaaka! ");
INSERT INTO byr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nabaai gamɨre gyaꞌmwe yuya nemɨjɨ myeꞌmwannemwaalyadɨvɨsa daaka! Sarevɨdaaꞌnyɨ sɨduta dazasɨ dɨragɨnya dazajɨ yuya gawɨ maarakengaka?” ");
INSERT INTO byr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sara dɨna yevegaaꞌ sahwarɨna jɨkurya yɨna yadɨvɨsare. Jɨkurya yadɨvɨsaraavɨ Jizaazai wɨdɨna “Pɨropetɨyarɨna anga yuyabanna ‘Aꞌmwe naangelyɨ,’ dɨdɨvɨkɨ. Kɨrɨꞌ gannya angebannajɨ gannya angevɨnajɨ ‘Aꞌmwe naangelyɨ,’ majadɨvɨkɨ.” ");
INSERT INTO byr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sagaaꞌ anga dazaba dɨragɨnya ya kwalaalya myaꞌ kumɨ sahwarɨ malɨmwagyadaapiyaꞌna. ");
INSERT INTO byr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sagaaꞌ naanga Erotɨyai Galɨli maremwaalakei Jizaazarɨna yɨhusɨrɨ kadɨka wɨꞌnyɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kadɨka wɨꞌnyɨna yaka gamɨre wɨgaimwadɨvɨsaraavɨ wɨdaꞌ “Dazai Bavɨtaazɨya Yadei Jonɨ. Sai lɨkirakɨnɨkevɨdaaꞌnyɨ ayɨna dɨkaavakelyɨ. Sarevɨ dɨragɨnya naanga dazaꞌ miꞌna maaraka nawɨꞌnyangɨ yɨvanɨkesɨ.” ");
INSERT INTO byr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Saꞌ darevɨnyɨ. Erotɨyai Jonɨmɨ galalɨmwanna yaka wɨla senɨyabaalyɨ yɨrɨna yaka kalavuzangevɨ wɨmwaaihɨna. Erotɨyaazaꞌ kɨgaaꞌ Erotɨyare gyaꞌmwei Pilipɨmɨre aꞌmwevɨnesɨ. Pilipɨ kuna mwaaidɨꞌnyɨ Erotɨyai gyaꞌmwere balaangevɨ yaasɨwaꞌna maarakeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sareꞌ dareꞌnesɨ. Jonɨ Erotɨyarɨ wɨdɨna “Aꞌmwe pware dazaꞌ maaꞌmwaꞌdɨnya saꞌ Gotɨyare kɨwɨnyaꞌ galazekɨvaimanɨgɨnyaigɨnyɨ.” Wɨdɨ wɨja yadeꞌna Erotɨyaazaꞌ sɨnna tɨka wɨdaꞌdaaꞌnyɨ kudaꞌ Erotɨyai kalavuzangevɨ wɨmwaaihɨna. ");
INSERT INTO byr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Wɨmwaaihɨna yaka “Jonɨmɨ tamakɨma!” daka yaka kɨrɨꞌ aꞌmwe yuyaraavɨna lɨka yɨna. Aꞌmwe sahwara yawɨꞌna “Jonɨ Gotɨyarɨ wɨꞌnawɨjɨwaakadelyɨ. Pɨropetɨyalyɨra.” Sahwara sara yawɨꞌna yadɨvɨꞌ sahwaraavɨna lɨka yɨna navɨka mwaalɨna yakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pɨgaaꞌ yɨrɨkerɨꞌ Erotɨyarɨ ganaangeꞌ mudanga yaka sarɨkɨna yawɨremwaalyaꞌna aꞌmwe pwara Erotɨyalyɨ yɨꞌbwaꞌnemwaaina. Tɨka munnevɨ yɨꞌbwaꞌnemwaaleva Erotɨyaazavɨre taavɨzɨdɨraayaꞌ kumɨnyɨ tɨnnyaba kwarame yɨwɨlaabɨna. (Juyaraavɨrebwi “Aꞌmwe tewaanyaꞌ aꞌmweraayaba kwarame myannera!” dɨnɨkebulyɨ.) Kwarame yɨwɨlaabɨna kyaꞌ Erotɨyai wabahɨlaaka yɨna. ");
INSERT INTO byr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sarevɨdaaꞌnyɨ yagaala dɨragɨnaanga wakɨna “Gotɨyarɨna naanga nebulyaꞌna gɨthɨma! ‘Gɨmɨnyɨ gɨvuꞌnajanna kanyɨdaanganaꞌgɨzɨ gɨmɨnyɨ wɨjaavɨna gideinyɨ. (Nyɨgɨvɨna!)’ ” ");
INSERT INTO byr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sara wakɨna kyaꞌ sɨdɨraaya dazavɨ ganaangeꞌ gamɨnyɨ sɨmunyaꞌ wɨjaavɨna yɨna kyaꞌ sɨdɨraayaꞌ wɨdɨna “Jonɨ Bavɨtaazɨya Yadere mɨnyagɨnyaꞌ tɨwɨnya nyegalanya pukɨ dɨꞌgwalaꞌgɨzɨ dava nɨmɨnyɨna dɨnyɨjaadeigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wɨdɨna kyaꞌ maremwaaidei Jonɨmɨna kale wiadaaꞌnyɨ yawɨꞌna “Aꞌmwe yuya dathara nɨmɨre yagaala dɨragɨnyaꞌ kadɨka kanyuꞌnɨwaakɨra.” Sara daka gamɨre wɨdaayadɨvɨsaraavɨ wɨdɨna “Taayaꞌ sara nyɨdɨwakeꞌ sara jɨla!” ");
INSERT INTO byr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Miꞌna wɨdɨna kyaꞌ gamɨrera kalavuzangevɨ walaawɨna yeva Jonɨmɨre mɨnyagɨnyaꞌ wopuramaaꞌna yeva ");
INSERT INTO byr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","tɨwɨnya nyegalanya pukɨ gamɨre mɨnyagɨnyaꞌ dɨꞌgwalamakabɨna, sɨdɨraaya dazavɨna wɨjaavɨna. Wɨjaavɨna kyeꞌ ganaangeyawɨnna makuna. ");
INSERT INTO byr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ganaangeyawɨnna makuna kyaꞌ sareꞌ Jonɨmɨrera kadɨka wɨꞌnyɨna yeva gɨlaayarɨ bamaaꞌna yɨna yeva lɨkirakɨna. Mena lɨkirakɨna yeva Jizaazarɨ wɨdaawɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jizaazai yagaala saꞌ kadɨka wɨꞌnyɨna yakegaaꞌ anga saba yagalyaꞌmaꞌna yaka sɨpɨyavɨ yɨlamwaaina yaka aꞌmwera mamwaalyɨgata pɨbanna kaanna wɨna. Kaanna wɨna yadaaꞌnyɨ kwala bwaꞌnaanya anga naangengɨdaaꞌnyara kadɨka sara wɨꞌnesara kwaakaanya gamɨnyɨ mɨjamakuna. ");
INSERT INTO byr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mɨjamakuna kyeꞌ dɨvi Jizaazai tɨyawɨnna bularaawaka aꞌmwe kwalaalya naangera bamwaaidapi sai tɨnna wanganna. Kwalaalyaraavɨ tɨnna wanganna yaka kale wina kwiaꞌ nabaai kumɨre nalaavɨnakeraavɨ yavadaꞌgaina. ");
INSERT INTO byr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sara yada sawɨtɨrɨnyaburɨ gamɨre mɨdɨdɨvɨsara gamɨnyawɨnna bɨna yeva wɨdɨna “Dazɨmagɨ aꞌmwera maayɨmagɨnyɨ. Nabaai yɨrɨkerɨꞌ mena buwaꞌ. Sarevɨdaaꞌnyɨ aꞌmweraavɨ dɨmarayaasa! ‘Angebanya yunewɨnna yamaryapɨjɨ wapaaya mubɨpɨka!’ daꞌgɨzɨ dɨmarayaasa!” ");
INSERT INTO byr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sara wɨdɨna kyeꞌ kɨrɨꞌ Jizaazai wɨdɨna “Beꞌna wɨpɨneraavaka? Sarɨmɨ saihi wapaaya duzaayɨla!” ");
INSERT INTO byr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Sara wɨdɨna kyaꞌ gamɨrera wɨdɨna “Nemɨ dava tɨka wapaaya kwalaalya manewarika. Gɨrɨkula atinanya gave pɨnɨjɨ jawɨnya gave pwaraalyɨna warɨka.” ");
INSERT INTO byr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Wɨdɨna kyeꞌ sai wɨdɨna “Daza nɨmɨnyaba davanna dɨmakabila!” ");
INSERT INTO byr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sara wɨdɨna yaka aꞌmweraavɨ wɨdɨna “Kaabinnyavɨ dalamwaalyɨla!” Wɨdɨna yaka gɨrɨkula ata pwinanyajɨ jawɨnya pwaraalyɨ maarɨna yaka Sɨgunyavɨ maranganna yɨna yaka “Wapaaya naanga nyɨjawaanyaꞌna yɨlaaya gyɨwa!” Gotɨyarɨ wɨdɨna. Wɨdɨna yaka wapaaya sa maragunyɨna yaka gamɨre mɨdɨdɨvɨsaraavɨ wɨjaavɨna. Wɨjaavɨna kyaꞌ sahwara aꞌmweraavɨ yanga mudɨna. ");
INSERT INTO byr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yanga mudɨna kyeꞌ yuyara yunebanna nyɨna yeva munya yɨnyɨna. Munya yɨnyɨna kyaꞌ gamɨrera wapaaya pɨnɨ nagihesa mariꞌbwaꞌna yɨna yeva soigɨlya tinɨka sɨvɨlyɨrɨdaaꞌnyɨ pukaalyangɨ maanga yekuꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aꞌmwe gavera paaivɨ taawɨzanɨyara nɨnɨkeꞌna. Nabaai aꞌmwe kwalaalyajɨ kaimɨraayajɨ nɨnɨkengɨ. ");
INSERT INTO byr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sagaaꞌ yɨmeꞌnyaꞌbɨꞌ mɨdɨdɨvɨsaraavɨ wɨdɨna “Sɨpɨyavɨ dɨkwosɨꞌnapɨjɨ yɨlamwaalapɨjɨ aalɨbunyavɨ pimagɨnna sɨnnawɨ sahwaihidaaꞌnyɨ daanyɨla! Kwala bwaꞌnaanyangɨ maryaasaꞌmujɨyagaaꞌna yɨhɨzɨmaꞌnaawɨdeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Miꞌna wɨdɨna yaka aꞌmweraavɨ mena maryaasɨna yɨna yaka sai gavei mugunyavɨna yɨlaawɨna, Gotɨyarɨ wɨdɨna. Kuna wɨdɨna yadaaꞌnyɨ sawɨta maalɨka jɨnnyɨna kyaꞌ mugunya savɨ yuna gavei mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mwaalɨna yadɨꞌnyɨ sɨpɨyaꞌ aalyavɨ naangebanna wɨlaawɨna yaka widawadaaꞌnyɨyagaaꞌ yɨhusaꞌ sɨnnyɨmagɨdaaꞌnyɨ wɨlaabɨna yaka aalɨmavajɨnaakeꞌ sɨpɨyavɨ galarɨvɨkɨꞌna yadaaꞌnyɨ sɨpɨyaꞌ mihɨlaꞌmihɨlaꞌ kaanya wɨna. ");
INSERT INTO byr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kuna galarɨvɨkɨꞌna yadaaꞌnyɨ yɨrɨkunyagaaꞌ Jizaazai aalɨbunyavɨ aꞌba wɨlaabɨna yaka kumɨnyawɨnna yɨꞌmaꞌna. ");
INSERT INTO byr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yɨꞌmaꞌna kyaꞌ mɨdɨdɨvɨsara tɨnna wanganna yadɨvɨꞌ “Akai, sai gɨlaaya pwalyɨra,” dɨna yeva lɨka yɨwainɨgulaawɨna yɨna yeva “Aaka! Aaka!” jaka dɨna. ");
INSERT INTO byr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jaka dɨna kyeꞌ sahwai yɨmeꞌnyaꞌbɨꞌ wɨdɨna “Dɨragɨnna dɨmwaalyɨla! Nɨmɨ sahwainyɨra. Lɨka mipɨnera!” ");
INSERT INTO byr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pitai gamɨre yagaalyaꞌ kadɨka wɨꞌnaka jaꞌnawɨdɨna “Naangeigɨ yune saigɨ mwaaidɨzaigɨ ‘Aalyavɨ aꞌba nɨmɨnyawɨnna dulaama!’ dɨragɨnna dɨnyɨdana!” ");
INSERT INTO byr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sara wɨdɨna kyaꞌ sahwai wɨdɨna “Dulaama!” Wɨdɨna kyaꞌ Pitai sɨpɨyavɨ walyuna yaka aalyavɨ aꞌba wɨlaawɨna yɨna yaka Jizaazaryawɨnna wɨlaawɨna. ");
INSERT INTO byr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kɨrɨꞌ yɨhusaꞌ wanganaka lɨka yɨna yada aalyavɨ kusawɨ kɨbaweba gaai walaawɨna. Sara yada jaka dɨna “Naangeigɨ dɨnyɨvadaihasamaako!” ");
INSERT INTO byr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jaka sara kudaꞌ yɨmeꞌnyaꞌbɨꞌ Jizaazai ata yɨwɨbwaꞌna yaka yɨrɨꞌbwaꞌna yaka wɨdɨna “Gɨmɨ nɨmɨnyɨ lɨmwangebwi yuna maalɨkebulyɨyaigɨnyɨra. Sɨmunya pɨrɨwaalyaꞌ beꞌna yawɨꞌmanɨgɨ!” ");
INSERT INTO byr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wɨdɨna yaka saraai sɨpɨyavɨ dɨkwosɨꞌna kyagi yɨhusaꞌ miꞌna yɨwɨna. ");
INSERT INTO byr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Miꞌna yɨwɨna kyaꞌ sɨpɨyavɨ mwaalesara gamɨnyɨ kwadaai gɨlɨna yeva yɨlaaya wina yeva wɨdɨna “Naanga yuna nebulyasɨ. Gɨmɨ Gotɨyare Gawaalɨvaangeigɨnyɨra!” ");
INSERT INTO byr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Aalɨbunyavɨ mena lɨvajulagaꞌmaveva Ganezaaretɨ sɨmagɨnna yɨꞌmavaawɨna yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yɨꞌmavaawɨna yɨna kyeꞌ aꞌmwe anga dazɨmagɨnyara yawɨꞌna “Sai Jizaazalyɨra.” Yawɨꞌna yeva anga yuyabanya daza yagaalyaꞌ wɨdaasɨna yɨna yeꞌ. Sara kyeꞌ gamɨnyawɨnna nalaavɨnaka yuyaraavɨ makabɨna. ");
INSERT INTO byr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sara makabɨna yeva aꞌmwe nalaavɨnakera tewaanya yɨmaꞌnyaꞌnera gamɨre baazɨꞌmaꞌnyavɨ maangebaarɨ asaꞌna wɨdathɨwabɨꞌdeꞌna yɨdaanganna wieꞌ. Sara yɨdaanganna kwieꞌ sahwara sara yeva yuyara ayɨna tewaanya yɨmaꞌnesarera. ");
INSERT INTO byr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sagaaꞌ Perɨzɨya pwarajɨ Kɨwɨja pwarajɨ Jeruzaalemɨ yagalyaꞌmaveva Jizaazaryawɨnna kaanna bɨna yeva wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Gɨmɨre mɨdɨdɨvɨsara Ne sɨnnawɨnyara nejaavɨnɨka sabwi marasɨta yadɨvɨsaꞌ gathaꞌdarevɨnaka? Sareꞌ dareꞌnesɨ. ‘Tɨka wapaaya naana!’ dadɨvɨꞌ Ne sɨnnawɨnyara dɨnɨkabaaibɨꞌ kunnya asa aalya yɨdɨvɨtara mɨka! Gɨrɨkitaꞌnanyara tɨka nadɨvɨsare. Beꞌneka?” ");
INSERT INTO byr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sara wɨdɨna kyeꞌ sai wɨrɨvɨkɨꞌna “Sarɨmɨ yune sarɨnnyaburɨna mɨdɨmanɨgasaihɨlyɨ. Sara yadɨvɨꞌ Gotɨyare kɨwɨnya dɨnɨkengɨjɨ galazekɨvaimanɨgasaꞌ gathaꞌdarevɨnaka! ");
INSERT INTO byr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sareꞌ dareꞌnesɨ. Gotɨyai dɨnɨꞌ ‘Gɨmaamaangelyɨ gwaangesɨ sawaare yaya makidɨ duhaimwana!’ Yɨ nabaai dɨnɨꞌ ‘Aꞌmwei ganɨmaanga pwarɨ ganaanga kɨrɨvɨ bɨraiyagaala wɨdade sai yɨnahu balana!’ ");
INSERT INTO byr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kɨrɨꞌ sarɨmɨ Gotɨyare yagaalyaꞌ mamɨdɨnyadɨvɨꞌ Ne sɨnnawɨnyaraavɨre gavebwi mɨdɨdɨvɨꞌ dara dadɨvɨsaihɨlyɨ ‘Gazaizai nɨgwia kɨnɨnnakei gannya ganɨmaanga pwarɨ ganaanga kɨrɨvɨ wɨdɨna “Gɨmɨnyɨne gaimwangeꞌne dazaꞌ Gotɨyarɨ wɨjaayaꞌneꞌ dahɨlakɨwesɨ. Sareꞌna yɨhɨzaavɨwɨneinyɨ mɨꞌ.’” ");
INSERT INTO byr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Aꞌmwei sara wɨdazai sarɨmɨ dɨna ‘Sahwai ganɨmaanga pwarɨna ganaanga kɨrɨvɨna mugaimwagannera!’ Sara dɨna yadɨvɨta sasare dazaburɨ sarɨmɨ Gotɨyare yagaalyaꞌ walamarakadɨvɨsaihɨlyɨ. Sara yadɨvɨꞌ yune sarɨnnya sabwineꞌna munyabanna makidɨvɨsaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kwaasɨyaihi! Sarɨmɨnyɨna Pɨropetɨya Aazaayai yɨdaꞌna wɨjaaꞌ. Dara dɨnɨꞌ ");
INSERT INTO byr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Aꞌmwe dara maangejɨ nɨmɨnne yayaꞌ munyaba makidɨvɨꞌ Kɨrɨꞌ kumɨre sɨmunya nɨmɨnyɨ menyaba warɨkengɨ. ");
INSERT INTO byr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Aꞌmweraavɨre yune kɨwɨnyanna wɨjɨwaakadɨvɨsangɨna “Gotɨyare yagaalyaꞌna dɨmɨdɨnyɨla!” wɨdadɨvɨsare. Sarevɨdaaꞌnyɨ yɨlaaya yaasɨwaꞌna nyadɨvɨsare.’ Sarɨmɨnyɨna nayaa sara dɨnɨkesɨ.” ");
INSERT INTO byr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kwala bwaꞌnaanyavɨ gamɨnyawɨnna jaka wɨjɨvwaramaaꞌna yɨna yaka wɨdɨna “Sarɨmɨ kadɨka wɨꞌnapɨjɨ nayaa jawɨrila! ");
INSERT INTO byr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yuya maangevɨ kusawɨ wideꞌna aꞌmwerɨ gɨrɨka yɨgalakadeꞌ mɨꞌ. Aawa. Maangevɨdaaꞌnyɨ yagaala walyaabyaꞌ yune sahɨrɨꞌna gɨrɨkitaꞌnanyai yɨmaꞌnadesɨra.” ");
INSERT INTO byr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sagaaꞌ gamɨre mɨdɨdɨvɨsara gamɨnyɨ buthɨna “Aꞌmwe Perɨzɨyara gɨmɨre yagaala saꞌ kadɨka wɨꞌneva jɨkurya yɨvanɨgasaraavɨna jawɨꞌmanɨgɨna?” ");
INSERT INTO byr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Sara wɨdɨna kyeꞌ sai keꞌbaꞌna wɨrɨvɨkɨꞌna “Nɨmaamaangei Sɨgunyavɨ mwaalɨkei gazavɨzavɨ maburɨjakeꞌ yune aꞌmweraavɨreꞌ pwipula kɨnɨjɨ laavadesɨ. ");
INSERT INTO byr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Perɨzɨyaraavɨna yawɨta kwalaalya mipɨnera! Sahwara tɨbɨnyara tɨbɨnya pwaraavɨ wibwarɨdaakwadɨvɨsare. Kɨrɨꞌ tɨbɨnya pwai tɨbɨnya pwarɨ tusarɨꞌ wibwarɨdaakwajai yuya saraai kwaraai kaviꞌnɨnnyavɨ walaraawɨna yɨkaderaalyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Sara wɨdɨna kyaꞌ Pitai wɨdɨna “Maangevɨ widevɨne keꞌbaꞌnanya dazavɨya kaavɨlyaꞌ dɨnejalɨkurakya! Sara kyaꞌgɨzɨ wɨꞌnaadeinera.” ");
INSERT INTO byr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Wɨdɨna kyaꞌ wɨdɨna “Sarɨmɨ kwaihɨlyɨ wana sɨmumaayaihi kuna jɨvanɨgava! ");
INSERT INTO byr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Dareꞌna myawɨrijɨhyɨvanɨgava! Gazaza kwaaꞌnakejɨ kwaaꞌmaayajɨ maangevɨ kusawɨ wide sa munyɨkɨ wɨlaminada dɨvidaaꞌnyɨ lɨkaviꞌnɨnnyavɨna kewɨnɨ marasɨꞌde. (Sarevɨdaaꞌnyɨ wapaaya saza gɨrɨkitaꞌnanyarɨ mumwaaihyadengɨ.) ");
INSERT INTO byr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kɨrɨꞌ yagaala maangevɨdaaꞌnya walyaabya daza sɨmunyavɨdaaꞌnyɨ yɨmaꞌnɨvanɨkengɨ. Yɨ dazahɨnɨza aꞌmwe gɨrɨkitaꞌnanyarɨ wɨmwaaihadengɨ. ");
INSERT INTO byr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sareꞌ dareꞌnesɨ. Sɨmunyavɨdaaꞌnyɨ yɨmaꞌnade sa darengɨ. Sɨduta kayaaꞌna yawɨꞌna, aꞌmweraavɨ tamakɨna, aꞌmwengɨ ata lɨmwanna, wagɨla maaryaꞌne gɨrɨkitaꞌnanya yɨna, kukebwi yɨna, kotɨyavɨ kwaasɨ jalɨkurakɨna, bɨraiyagaala dɨna. Yuya sabwi sɨmunyavɨ miꞌna yawɨꞌna yeva sara yadɨvɨsangɨ. ");
INSERT INTO byr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sarevɨdaaꞌnyɨ yuya daza aꞌmwe gɨrɨkitaꞌnanyarɨ wɨmwaaihɨna yɨnɨkengɨ. Kɨrɨꞌ aꞌmwei gannya asi aalya minyajai tɨka wapaaya nojɨyaꞌna sahwai gɨrɨkitaꞌnanyai Gotɨyarɨna yɨmaꞌnadei mɨꞌ.” ");
INSERT INTO byr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sahɨba Jizaazai yagalyaꞌmaꞌna yɨna yaka anga Taayaajɨ anga Saaithonɨjɨ sɨmagɨnna kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kaanna wɨna yaka keiba yamaryadaaꞌnyɨ, yɨthaanyi, Kenaanɨ mwaalya pɨrɨꞌ menyaꞌ dazɨmagɨ mwaaideꞌ bɨna yaka jaka buthɨna “Naangeigɨ, Ne Devitɨmɨre Kaimɨraayaigɨnyɨ nɨmɨnyɨna kale dɨnyɨgaimwana! Nɨnnya taayavɨ yɨmakei yuna kayaaka nyɨgalakivanɨka!” ");
INSERT INTO byr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sara wɨdɨna kyaꞌ kɨrɨꞌ yagaala pɨrɨꞌ jaꞌnajaꞌ mi. Jaꞌnajaꞌ mi kyaꞌ mɨdɨdɨvɨsara gamɨnyawɨnna bɨna yeva dɨragɨnna wɨdɨna “Aꞌmwe dazaꞌ yune jakeꞌna jakeꞌna nedamɨdɨnɨka. Savɨ ayɨna dɨmaryaasa!” ");
INSERT INTO byr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sara wɨdɨna kyeꞌ sai dara wɨdɨna “Yɨzɨrelɨyaraavɨre yɨsavaakɨdaaꞌnyɨ sipɨzipɨyara yɨwɨnadaaꞌna yɨnɨkeraavɨna gaveraavɨna nyɨmaryasaabakeinyɨ. (Aꞌmwe daꞌ Yɨzɨrelɨyaꞌ mɨka. Menyasɨra.)” ");
INSERT INTO byr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wɨdɨna kyaꞌ saꞌ wɨlaabɨna yaka kwadaai bulagina yɨna yaka bularutaꞌnyɨna yaka wɨdɨna “Naangeigɨ dɨnyɨgaimwana!” ");
INSERT INTO byr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kɨrɨꞌ sai ayɨna jaꞌnawɨdɨna “Kaimɨraayangɨre tɨka wapaaya marawaajɨ jɨlɨkeraavɨ namaralɨvaramaadɨka!” ");
INSERT INTO byr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Sara wɨdɨna kyaꞌ saꞌ wɨdɨna “Naangeigɨ nebulyaꞌna dɨwaana. Kaimɨraayara tewaanya mwaaidɨvɨsare. Nabaai jɨlɨkera wapaaya tɨrɨdɨrɨnya kwɨyakwaravaavɨre yɨꞌbɨnyavɨ bwalaꞌdaawade maribwaranadɨvɨsare.” ");
INSERT INTO byr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sara wɨdɨna kyaꞌ Jizaazai jaꞌnawɨdɨna “Aꞌmweꞌgɨ, nɨmɨnyɨna gɨmɨre dɨragɨnna lɨmwangebwi saꞌ naangesɨ. Nyɨdɨwaanyavɨna gɨvuꞌnɨvanɨkabaaibɨꞌ saꞌ yɨmaꞌnyɨna gyana!” Sara kudaꞌ sagaasagaaꞌ gamɨre taayaꞌ ayɨna tewaanya yɨmaꞌnyɨna yakesɨ. ");
INSERT INTO byr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Anga saba Jizaazai yagalyaꞌmaꞌna yɨna yaka Galɨli aalɨbumaangebaarɨ aya kɨbanna wɨlaawɨna yaka mugunyavɨ yɨlaawɨna, yɨlamwaaina. ");
INSERT INTO byr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yɨlamwaaina yadɨꞌnyɨ aꞌmwe kwalaalyara gamɨnyawɨnna biꞌbwaꞌnyɨna. Biꞌbwaꞌnyɨna yadɨvɨꞌ sɨvɨla kayaaꞌnanyarajɨ yagɨnya yadɨꞌmwannɨkerajɨ tɨbɨnyarajɨ maanga jɨnɨnɨkerajɨ, nabaai aꞌmwe nalaavɨnaka kwalaalya pwarajɨ saraavɨ makabɨna yeva gamɨre sɨvɨlyɨryaba gidɨkuꞌ yarai wɨmwaaihɨna. Sara yadapi tewaanya yavadaꞌgaina wiaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Sarevɨdaaꞌnyɨ kwala bwaꞌnaanya atɨka maruꞌnaꞌna. Aꞌmwe maanga yɨnahu jɨnɨnɨkera yagaala dadaapi tɨnna wanganna, yɨ yagɨnya yadɨꞌmwannɨkera maamɨdarya yɨmaꞌnyɨna, yɨ sɨvɨla kayaaꞌnanyara kaanya yamarina, yɨ tɨbɨnyara tɨnna yenyɨna yadaapi tɨnna wanganna yeva atɨka maruꞌnaꞌna. Atɨka maruꞌnaꞌna yeva Yɨzɨrelɨyaraavɨ Gotɨyarɨna yayaꞌ byaannakeꞌ munya keꞌbanna makina yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jizaazai gamɨre mɨdɨdɨvɨsaraavɨ jaka wɨdɨna yɨna yaka wɨdɨna “Kwala bwaꞌnaanyavɨna kale naanga nyɨvanɨka. Nɨmɨjɨ yɨrɨka daryaai darɨꞌ mena nyeꞌmwannamwaaleva wapaaya maayaraavɨna. Ayɨna mɨjɨkaanya maryaasaꞌna ‘Aala!’ dɨvanɨge. Tutaanyavɨ nabalapɨdɨka!” ");
INSERT INTO byr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wɨdɨna kyaꞌ sahwara wɨdɨna “Dathimagɨ aꞌmwera maayɨmagɨnyɨra. Sareꞌna nemɨ kwala naanga davɨ wapaaya sara wɨjaayaꞌne gɨrɨkula kwalaalya gawɨ maraajɨwona?” ");
INSERT INTO byr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Wɨdɨna kyeꞌ Jizaazai wɨdɨna “Sarɨmɨnyɨne gɨrɨkula gara gara warɨka?” Wɨdɨna kyaꞌ wɨdɨna “Nemɨnyɨ gɨrɨkula ata purɨdaaꞌnyɨ pwaraaina newarɨka. Jawɨnya maalɨka pwaina pwaina warɨka.” ");
INSERT INTO byr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Wɨdɨna kyeꞌ kwala bwaꞌnaanyavɨ wɨdɨna yɨna kyaꞌ kwaakevɨ walamwaihulɨna. Kwala bwaꞌnaanyaꞌ walamwaihulɨna kyeꞌ ");
INSERT INTO byr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","gɨrɨkula ata purɨdaaꞌnyɨ pwaraala sajɨ jawɨnyarajɨ maarɨna yɨna yaka Gotɨyarɨ “Su! Su!” wɨdɨna yaka gunyɨna, gamɨre mɨdɨdɨvɨsaraavɨ wɨjaavɨ wɨjaaya yɨna kyaꞌ sahwara aꞌmweraavɨ yanga bumumulɨna. ");
INSERT INTO byr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yanga bumumulɨna kyeꞌ yuyara yunebanna miꞌna nyɨna. Sara yeva munya kwinaꞌ nagiheta bwalaraawake ayɨna mariꞌbwaꞌna yɨna yeva soigɨlya tinɨka naanga ata purɨdaaꞌnyɨ pukaalyangɨ ayɨna yunebanna maanga yekuꞌnyɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Aꞌmwera tɨka nya (4,000) po taawɨzanɨyare. Nabaai aꞌmwejɨ kaimɨraayajɨ tɨka nesangɨ. ");
INSERT INTO byr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Soigɨlyangɨ mariꞌbwarakɨna kyeꞌ kwala bwaꞌnaanyangɨ maryaasɨna yaka sɨpɨyavɨ yɨladɨkwosɨꞌnamwaaina yɨna yaka Maahathanɨ sɨmagɨnna kaanna wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Perɨzɨyarajɨ Sazuzɨyarajɨ sara Jizaazaryawɨnna bɨna yeva yɨjɨwaalyaꞌna yaamɨjɨ wɨdɨna “Gotɨyai gɨmaryasaabakeigɨ dɨngaka? Sɨgunyavɨ dɨragɨnyaꞌ maaraꞌgɨzɨ atɨka maruꞌnata wɨjɨwaainyaꞌ kyaꞌgɨzɨ gɨmɨnyɨna yawɨraadeꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kɨrɨꞌ sahwai yagaala saꞌ kadɨka wɨꞌnyɨna yaka wɨrɨvɨkɨꞌna “Sawɨsaburɨna dara dadɨvɨsaihɨlyɨ ‘Sɨgunyaꞌ wayaaka yɨrarakɨwakeꞌna nawɨꞌnyagaaꞌ yɨmaꞌnadera.’ ");
INSERT INTO byr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nabaai pɨgaaꞌ mwanyavɨna dara dadɨvɨkɨ ‘Yɨraayangeꞌ tɨnga mɨlaꞌnaraka sɨgunya wayaakesɨra. Sareꞌna dahaaꞌ yɨhusasɨ burɨkesɨ waradera.’ Sara dadɨvɨkɨ. Yo, sasareꞌ sarɨmɨ sɨgunyavɨreburɨ wangadɨvɨꞌ nayaa maryawɨbwaꞌdɨvɨkɨ. Kɨrɨꞌ dahaaꞌne sangɨjɨ dɨragɨnya yɨvanɨgengɨjɨ wangadɨvɨꞌ nayaa mamaryawɨbwaryɨvanɨgaꞌ. ‘Gotɨyai naangegaaꞌ wakadehaaꞌ yarai yɨmaꞌnadesɨ,’ majɨvanɨgaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Dahaasaihi kayaaꞌnanyaihɨlyɨ. Aꞌmwei mwaaidɨꞌnyɨ aꞌmweꞌ pwaraavɨ tidavamaryadevaaibɨꞌ Gotɨyarɨ yagalyaꞌmaꞌna yeva gevwi yadɨvɨsaihɨlyɨ. Sareihi nyɨdɨwaaꞌ ‘Dɨragɨnyaꞌ wɨjɨwaainyaꞌ wanganaana!’ Kɨrɨꞌ wɨjɨwaainyaꞌ mihibwarɨdaakwɨwɨna! Aawa. Dɨvi pɨropetɨya Jonaamɨ yaakeꞌ wɨjɨwaainya saꞌ danganyideihɨlyɨ.” Sara wɨdɨna yaka yagalyaꞌmaꞌna yaka kaanna wɨna. (Matɨyui 12:39,40) ");
INSERT INTO byr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Aalɨbunyavɨ Jizaazalyɨ mɨdɨdɨvɨsarajɨ lɨvajulagaꞌmaꞌna yeva gamɨrera gɨrɨkula pɨnɨnna navɨka yɨna, mamakabi. ");
INSERT INTO byr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Mamakabi kyeꞌ sagaaꞌ Jizaazai wɨdɨna “Mala nayaa jɨwannyɨla! Perɨzɨyarajɨ Sazuzɨyarajɨ saraavɨre yɨzɨyaꞌna mala nayaa jɨwannyɨla!” ");
INSERT INTO byr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sara wɨdɨna kyaꞌ kɨrɨꞌ sahwara dɨnyɨna “Sai dara dɨwaꞌ ‘Nɨmɨrera gɨrɨkula lɨwɨnya pamidakya mamakabi yɨwaaꞌ.’” ");
INSERT INTO byr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sara dɨnyɨna kyeꞌ Jizaazai kumɨre yagaalyaꞌ yawɨranganna yaka wɨdɨna “Nɨmɨnyɨ maalɨꞌna lɨmwagakava. ‘Sahwai negaimwagathelyɨ,’ majɨvanɨgasaihɨlyɨ. Kɨrɨꞌ ‘Gɨrɨkulya maayainera,’ beꞌna dɨmanɨgaꞌ! ");
INSERT INTO byr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Sarɨmɨ sɨmunya maayaihi dɨngaka! Gɨrɨkula ata pwinanya sa aꞌmwe 5,000 maaresanna myawɨrijɨvanɨgaꞌ! Sara yeva soigɨlya tinɨkengɨ maangeꞌ yunebanna gara garengɨ yekureꞌ? ");
INSERT INTO byr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nabaai sarɨmɨ myawɨrijɨvanɨgaꞌ gɨrɨkula ata purɨdaaꞌnyɨ pwaraala daza aꞌmwe 4,000 maꞌmwaꞌdaasanna! Sara yeva soigɨlya naanga tinɨkengɨ gara garengɨ maramihɨwaꞌdaaꞌ? ");
INSERT INTO byr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Myawɨrivanɨgasaꞌ gathaꞌdarevaka! Nɨmɨ gɨrɨkula pamidakyanna myɨhɨzɨvanɨge. Nɨmɨ yɨhɨthɨvanɨge. Sarɨmɨ mala nayaa jɨwannyɨla Perɨzɨyarajɨ Sazuzɨyarajɨ saraavɨre yɨzɨyaꞌna!” ");
INSERT INTO byr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Sagaaꞌ sahwara sɨmunya nayaa yawɨramaaꞌna “ ‘Gɨrɨkula pamidakyavɨne yɨzɨyaꞌna yɨpɨꞌdeꞌna,’ dɨnɨka mɨꞌ. Aawa. ‘Perɨzɨyarajɨ Sazuzɨyarajɨ saraavɨre wɨjɨwaakyanna nadapamaapɨdɨka!’ daka dɨnɨkesɨ.” ");
INSERT INTO byr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sizaarɨya Pilipaai sɨmagɨnna Jizaazai biꞌmavaawɨna yaka gamɨre mɨdɨdɨvɨsaraavɨ yɨdaanganna “Aꞌmwera Aꞌmweraavɨne Kaimɨraayainyɨna dadɨvɨta aaihwalaka?” ");
INSERT INTO byr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yɨdaanganna kyaꞌ kumɨ dɨna “Pwara dara dɨna ‘Jonɨ Bavɨtaazɨya Yadelyɨra.’ Pwara dɨna ‘Sai Ne Yɨlaajalyɨ.’ Nabaai pwara dɨna ‘Sai Ne Jeremaayai dɨngaka? Sai ne pɨropetɨya pwai dɨngaka?’” ");
INSERT INTO byr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mena dɨna kyeꞌ sai wɨdɨna “Sarɨmɨ saihi ‘Aaihwala?’ nyɨdɨvanɨgava.” ");
INSERT INTO byr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sara wɨdɨna kyaꞌ Saaimonɨ Pitai “Gɨmɨ Kɨraazɨtɨyaigɨnyɨ. Gotɨyai dahɨlakyaakeigɨnyɨ. Gotɨyai yuyagaaꞌ gaala mwaaidere Gawaalɨvaangeigɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sara wɨdɨna kyaꞌ Jizaazai “Saaimonɨ Jonaamɨre kaimɨraayaigɨ yɨlaaya yadɨ tewaanaanga yɨnɨkeigɨnyɨ. Aꞌmwe Kwaakevakɨyara mɨwɨsajɨ tawesɨ kɨnɨnnakera givwarɨdaakwetara mɨꞌ. Aawa. Nɨmaamaangei Sɨgunyavɨ mwaalɨkei sahwai givwarɨdaakwɨwakelyɨ. Sareꞌna tewaanaanga yɨnɨkeigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nabaai nɨmɨ gɨmɨnyɨ gɨthɨvanɨge. Gɨmɨ Pitaigɨnyɨ. Yagaala dara dɨnɨꞌ ‘Sɨlyaigɨnyɨ.’ Yɨ gɨmɨ nyɨdɨwaanyaꞌ sɨlaangeꞌbɨsavɨ munyaba nɨmɨre kusɨlaanyara angeꞌbɨsaraavɨ dɨragɨnya wɨmwaaihɨdeinyɨ. Sahwara dɨragɨnyara sara mwaaidɨvɨꞌ balyabwine dɨragɨnyasɨ saza dɨragɨnyaraavɨ dathɨwanna yade mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gotɨyarera yɨmaꞌnyaꞌnebwina Sɨgunyavɨya maremwaaidevɨne dɨragɨnyaꞌ kaanya baasaꞌneꞌ gɨzaavɨdeinyɨ. Kwaakevakɨ yangɨna ‘Kayaaꞌnanyangɨ,’ kadaꞌgɨzɨ yɨ sangɨna Sɨgunyavɨ Gotɨyai mena sara yawɨꞌna. Kwaakevakɨ yangɨna ‘Tewaanyangɨ,’ kadaꞌgɨzɨ yɨ sangɨna Sɨgunyavɨ Gotɨyai mena sara yawɨꞌna yɨnɨkelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wɨdɨna yaka sagaaꞌ gamɨreraavɨ dɨragɨnna wɨdɨna “Aꞌmwe pwaraavɨ ‘Gamɨ sai Kɨraazɨtɨyalyɨra,’ nudɨpɨdɨka!” ");
INSERT INTO byr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sagaaꞌdaaꞌnyɨ Jizaazai Kɨraazɨtɨyai mɨdɨdɨvɨsaraavɨ gaai yɨbwarɨdaakuna “Jeruzaalemɨna wɨwɨneinyɨ aꞌmwe naangerajɨ Gotɨyarɨne tamiraꞌdɨvɨta naangerajɨ Kɨwɨjarajɨ sara daanga naanga nyɨjaavɨpɨꞌdeinyɨ. Nabaai nyɨramakɨpɨꞌdeinyɨ. Dɨvidaaꞌnyɨ yɨrɨka darɨkaai darɨkɨ ayɨna nyɨdɨkaavadeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sara wɨdɨna kyaꞌ Pitai maanga tɨyabaarɨna makuna yaka maanga wɨdɨna “Naangeigɨ, aawa nebulyasɨ. Gotɨyarɨ gɨmɨnyɨna sɨnna tɨka wɨdaꞌdevwi magyɨmaꞌnannera!” ");
INSERT INTO byr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Wɨdɨna kyaꞌ kɨrɨꞌ gamɨnyawɨnna sai gɨnyɨwannyɨna yaka Pitarɨ wɨdɨna “Saataanɨgɨ, nɨmɨnyɨ dusɨmagɨ bulaawa! Nɨmɨre tusavɨ kaanya nanyɨrihɨꞌdɨka! Gotɨyare sɨmunyaꞌ myawɨramaarivanɨgɨ. Aawa. Yune aꞌmweraavɨreꞌ yawɨramaaꞌmanɨgɨnyaigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Wɨdɨna yaka sagaaꞌ Jizaazai gamɨre mɨdɨdɨvɨsaraavɨ wɨdɨna “Gazaizai nɨmɨnyɨna ‘Mɨdɨnɨma!’ dazai gamɨrebulyɨ gamɨre yayasɨ kwaakewɨ walamarakojɨ aꞌmwera kayaaꞌna nyapɨjɨ yɨta yovihɨrarannɨkevɨri nyɨramakɨpɨꞌdevaaibɨꞌ sahwai kayaaꞌnanya maaryaꞌnei ‘Jizaazarɨna wikɨra!’ dozɨ nyɨmɨdɨnaabana! ");
INSERT INTO byr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sareꞌ dareꞌnesɨ. Aꞌmwe pwai ‘Jizaazarɨna nanyɨramakɨpɨdɨka!’ dazai nyɨmarasɨꞌnajai padaihasamaaꞌnade kɨrɨꞌ gamɨre gaalyabwi yɨwɨna yadevulyɨ. Kɨrɨꞌ aꞌmwe pwai nɨmɨnyɨna yawɨrojɨyai balyaꞌnei dɨragɨnna nyɨlɨmwagazai gamɨre gaalyabwi bɨramaaradevulyɨ. ");
INSERT INTO byr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sareꞌ dareꞌnesɨ. Aꞌmwe pwai Kwaakevakɨya gɨlyɨvɨta yuya maarajai kɨrɨꞌ gamɨre gaalyabwi yɨwɨna yadevulyɨ. Sarevɨdaaꞌnyɨ gɨlyɨvɨta sa gathaꞌdara wɨgaimwagathelaka! Sahwai gamɨre gaalyabwi ayɨna mubamaaryaꞌnei be nɨgwia wɨjaavadelaka! ");
INSERT INTO byr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Dareꞌnanyɨ. Aꞌmweraavɨne Kaimɨraayai Ganɨmaangere byaannyasɨ gannya ejelɨyara kwarajɨ yeꞌmwannɨgwalaabathelyɨ. Yɨrɨka dazagaaꞌ aꞌmwe yuyara yadɨvɨta yune sabwineꞌna wɨrɨvɨkɨradeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nebulyaꞌna yɨhɨthɨvanɨge. Dava daakata pwara mabalyadapiyara kuna mwaaidɨvɨꞌ Aꞌmweraavɨne Kaimɨraayai aꞌmweraavɨ maremwaalyaꞌnei nawɨꞌnyarɨ tɨnna nayaa wangabɨꞌdehaaꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yɨrɨka ata purɨdaaꞌnyɨ pɨrɨꞌna mena wavɨlaꞌna kyaꞌ mugunya keꞌmwewɨ yɨnaawɨnɨkevɨ Jizaazai Pitarɨjɨ Jemɨzalyɨ Jonɨ gamɨre gahwaalaangelyɨ saraarɨjɨ gaveraavɨ makɨlaawɨna. Sagaaꞌ yune kumɨnna mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yadapi Jizaazare kɨlaakejɨꞌ kumɨre tɨmyɨralyarɨ pɨjɨꞌbɨꞌ yɨmaꞌnyɨna yaka nabinna yɨmaꞌnyɨna. Nabaai gamɨre sɨnnyɨꞌ nyɨlyaꞌbɨꞌ lɨvamwadɨna, gamɨre baazɨꞌmaꞌnya sa baakeꞌbɨꞌ yaaka naanga mwadɨna. ");
INSERT INTO byr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sara yada, yɨthaanyi, Ne Mozɨzalyɨ Ne Yɨlaajalyɨ saraai yɨmaꞌnaabɨna yagɨla Jizaazalyɨ yagaala yeꞌmwannadɨna yadaakɨlyɨ tɨnna wanganna wieꞌ. ");
INSERT INTO byr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pitai tɨnna wanganaka Jizaazarɨ wɨdɨna “Naangeigɨ dava mwalaajaꞌ saꞌ tewaanyasɨra. Sara yawɨꞌdɨzaꞌna dava sɨmɨnya dawaai dasa marɨdaakudengɨ. Pɨrɨꞌ gɨmɨnneꞌ, pɨrɨꞌ Ne Mozɨzarɨneꞌ, pɨrɨꞌ Ne Yɨlaajarɨneꞌ.” ");
INSERT INTO byr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sai yagaalyaꞌ kuna dadaasɨ, yɨthaanyi, yɨraaya pɨrɨꞌ wanyɨwanya naanga yɨna yaka kumɨnyɨ bwaakɨna. Yɨthaanyi, yɨraaya savɨdaasɨ maanguraaya pɨrɨꞌ yagaala dara dɨna “Dai nɨmɨre Nyɨbwaalɨvaangelyɨ. Darɨ kurya wɨkadɨnyalyɨ. Yɨlaaya nyɨgaimanɨꞌ. Dahwarɨ kadɨka duꞌnyɨla!” ");
INSERT INTO byr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wɨdɨna kyaꞌ mɨdɨdɨvɨsara kadɨka wɨꞌnyɨna yeva kwaakewɨnna walarutaꞌnyɨna, kumɨre sɨnnyɨꞌ kwaakevɨ tutawaꞌna yɨna yadɨvɨꞌ sahwara lɨka naanga yenayɨna. ");
INSERT INTO byr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Lɨka naanga yɨna yadɨvɨꞌ Jizaazai kumɨnyawɨnna wɨlaabɨna yaka ata yɨmeꞌnyɨna yaka wɨdɨna “Sahwaihi dɨthɨkaayɨla! Lɨka mipɨnera!” ");
INSERT INTO byr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wɨdɨna kyaꞌ tɨnna maradɨhaihɨranganna yeva aane pwai kwarɨ mamaranganyɨ. Aawa. Jizaazai yune gaverɨ maranganna. ");
INSERT INTO byr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sagaaꞌ mugunyavɨ yagalyaꞌmaꞌna yeva kewɨnɨna kuna waidaawadɨvɨꞌ Jizaazai dɨragɨnna wɨdɨna “Sarɨmɨ tɨnna wangamwaata dazanna aꞌmwe pwaraavɨ nudɨpɨdɨka! Aꞌmweraavɨne Kaimɨraayarɨ balojɨyarɨ yɨdɨkaavojɨyagaaꞌna duzideihɨlyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wɨdɨna kyaꞌ mɨdɨdɨvɨsara yɨdaanganna “Kɨwɨja sɨduꞌnakera dara gathaꞌdara dadɨvɨtavɨnaka? ‘Yɨlaajai mena kabozɨ dɨvidaaꞌnyɨ Kɨraazɨtɨyai Gotɨyai wɨdahɨlakyaakei walaabathelyɨ.’ ” ");
INSERT INTO byr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yɨdaanganna kyeꞌ sai jaꞌnawɨdɨna “Yo, nebulyaꞌna wɨdadɨvɨsasɨ. Yɨlaajai sɨnnawɨ bɨna, yuya byavadaꞌgalawɨmwaaihyaꞌnelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kɨrɨꞌ yɨhɨthɨvanɨge. Yɨlaajai mena bake kwarɨ kɨrɨꞌ aꞌmwera myawɨranganyesalyɨ. Aawa. Yune kunnya saburɨna mɨdɨdɨvɨꞌ dala nabinabinyabwi wiesalyɨ. Wɨramakesalyɨ. Nabaai sasare sahɨrɨsavɨ Aꞌmweraavɨne Kaimɨraayarɨ wana kayaaꞌna wipɨꞌdelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sara wɨdɨna kyaꞌ gamɨrera yawɨꞌna “Jonɨ Bavɨtaazɨya Yaderɨna danedɨvanɨka! Sahwai Yɨlaajalyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Aꞌmwe kwala bwaꞌnaanya naangeraayabanna yɨꞌmavaawɨna kyeꞌ aꞌmwe pwai gamɨnyawɨnna bɨna yaka kwadaai bahina yaka ");
INSERT INTO byr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","wɨdɨna “Naangeigɨ, nɨmɨre kaimɨraayarɨna gɨmɨ kaleꞌna dɨnyɨgaimwana! Yɨmaka wida gannya kɨlaakejɨꞌ yuna kayaaꞌna mwaaidelyɨra. Sareꞌ dareꞌnesɨ. Kwalaalyagaaꞌ dɨkevɨ walaꞌdaawadelyɨ. Nabaai aalyavɨ walaꞌdaawadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gɨmɨre gɨmɨdɨdɨvɨsaraayawɨnna makabɨwei tewaanya mi kiwaakɨra.” ");
INSERT INTO byr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Wɨdɨna kyaꞌ Jizaazai jaꞌnawɨdɨna “Sarɨmɨ aꞌmwe dahaasaihi naangegaaꞌ mwaaidɨ dɨragɨnna nyɨlɨmwadɨvɨsaihi mɨka. Nabaai sarɨmɨre sɨmunyasɨ tewaanyaꞌ mɨka! Nɨmɨnyɨna nayaa myawɨryaihi sarɨmɨjɨ kuna gathaꞌdaregaaꞌ yɨhyeꞌmwannemwaalɨdehaaꞌnanaka! Gotɨyare dɨragɨnya yawɨramaaryaꞌneihɨrɨna kuna gathaꞌdaregaaꞌ nyadehaaꞌnanaka! Kaimɨraaya sarɨ dava nɨmɨnyabanna dɨmakabila!” ");
INSERT INTO byr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Wɨdɨna yaka Jizaazai yɨmaka sarɨ maiyagaala wɨdɨna kyaꞌ kaimɨraaya dazarɨ yagalyaꞌmakuna kyaꞌ sarevɨ yuna sagaasagaaꞌdaasɨ tewaanya mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tewaanya mwaalɨna kyaꞌ Jizaazaryawɨnna yune gamɨrerana bɨna yeva, pwara yagalyaꞌmavesagaaꞌ wɨdɨna “Nemɨ yɨmaka dazarɨ yɨnɨga wiꞌna mudaasɨyaꞌ gathaꞌdara yaannevɨnaka?” ");
INSERT INTO byr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wɨdɨna kyeꞌ sai wɨdɨna “Gotɨyarɨ yɨnɨga wiꞌna malɨmwagyɨvanɨgasaꞌnanyɨ. Sareꞌ dareꞌnesɨ. Nebulyaꞌna yɨhɨthɨvanɨge. Maazɨtetɨya savɨre yɨsɨlyaꞌ maalɨtaayasɨ. Maalɨkeꞌ gɨrinɨkabaaibɨꞌ dɨragɨnna lɨmwanga maalɨtaaya dazaꞌ kɨnɨnnakeihi mwaaibɨzaihi mugunya dazaꞌ kudapɨjɨ ‘Keibanna dɨwona!’ yɨ nabaai saꞌ kaanna wɨna yadesɨ. Nabaai aane pɨrɨꞌ kɨrɨꞌ mi jideꞌ mɨꞌ. Yuyanna jideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kɨrɨꞌ yɨmaka sasarera wɨdaasaꞌneꞌ davwi jɨla! Tɨka wapaaya kɨmaakɨya wakɨna yapɨjɨ, Gotɨyarɨ dɨragɨnna jɨthaanganyidevulyɨ. Sabwi gavebwi yapɨjɨ yɨmaka dazaraavɨ duthaasideihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Anga Galɨli sabanna yeꞌmwannɨguna yesagaaꞌ Jizaazai wɨdɨna “Aꞌmweraavɨne Kaimɨraayainyɨ aꞌmwe pwai makabozɨ aꞌmwe naangeraavɨna kanyɨmarɨmwangojɨ ");
INSERT INTO byr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nyɨramakɨpɨꞌdeinyɨ. Nɨmɨ miꞌna balɨna kyaꞌmujɨ yɨrɨka daryaai darɨkɨ ayɨna nyɨdɨkaavadeinyɨ.” Sara wɨdɨna kyaꞌ gamɨrera kale naanga wiadaaꞌnyɨ sɨmunya yawɨriꞌmaaꞌna yɨna yeva sana mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Dɨvi anga Kaapanɨyamɨna yɨꞌmavaawɨna yɨna kyeꞌ Gotɨyare Angevɨne taakɨzɨya maaꞌdɨvɨsara Pitaryawɨnna buthɨna “Sarɨmɨre yɨhɨzɨwaakadei Gotɨyare Angevɨna taakɨzɨya wakadei midaaka?” ");
INSERT INTO byr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Buthɨna kyeꞌ sai wɨdɨna “Yo.” Sara wɨdaka angevɨ wɨlɨna kyaꞌ sɨnnawɨ Jizaazai wɨdɨna “Saaimonɨgɨ dareꞌna gara yawɨꞌmanɨgɨna? Kingɨyara Kwaakevakɨyaraavɨ maremwaaidɨvɨsara nɨgwɨtaakɨzɨya saza aaihwaravaavɨ maaꞌdɨvɨtaraavaka? Kunnya jɨlɨkaimɨraayaraavɨ maaꞌdɨvɨsara dɨngaka? Aꞌmwe pwaraavɨ maaꞌdɨvɨsara dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Wɨdɨna kyaꞌ Pitai wɨdɨna “Aꞌmwe pwaraavɨre nɨgwia maaꞌdɨvɨsare.” Wɨdɨna kyaꞌ Jizaazai wɨdɨna “Sarevɨdaaꞌnyɨ sahwaraavɨre jɨlɨkaimɨraayara taakɨzɨya wakadɨvɨtara mɨꞌ. (Sabaaibɨꞌ Gotɨyare Kaimɨraayainyɨ Gotɨyare Angevɨna taakɨzɨya wakadɨnyainyɨ mɨꞌ.) ");
INSERT INTO byr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kɨrɨꞌ ‘Taakɨzɨya mwaki kyakwoihɨjɨ naarɨmɨnyɨna jɨkurya nyawɨpɨdɨka!’ dena gɨthɨma! Sareꞌna wawoꞌgɨzɨ aalɨbunyavɨ jawɨwɨkɨyaꞌ dasɨꞌnaawa! Sara wasɨꞌnaꞌgɨzɨ jawɨnya aaya mudɨꞌna wɨravabwaꞌdɨzai maarɨna yaꞌgɨzɨ maangeꞌ galaraaꞌmwanna yaꞌgɨzɨ nɨgwia puꞌ kusawɨ wɨlaꞌdozɨ dɨvɨramaaꞌdeigɨnyɨ. Nɨgwia dazahuꞌ maarɨna yaꞌgɨzɨ yuya kwainaarɨne taakɨzɨyaꞌ dumaarideigɨnyɨ.” Sara wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Dazagaaꞌ mɨdɨdɨvɨsara Jizaazaryawɨnna bɨna yeva “Kwaaka davakɨ Jizaazai nemɨre Kingɨyai yarai yɨmaꞌnadelyɨ,” deva wɨdɨna “Sɨgunyavɨya maremwaaidevɨne gɨmɨre mɨdɨdaanyainajɨyai yuna naangei aaihwalaka? Yuyainaavɨ wavɨlaꞌmanɨkei aaihwalaka?” ");
INSERT INTO byr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Wɨdɨna kyeꞌ kaimale pwarɨ jaka jɨvwaramaaꞌna yaka tɨnnyaba marɨdaakuna yaka ");
INSERT INTO byr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","dara wɨdɨna “Nebulyaꞌna yɨhɨthɨvanɨge. Sarɨmɨ kaimɨraaya maalɨkerabɨꞌ mimaꞌnyɨ yɨpɨjaꞌ Sɨgunyavɨya maremwaaidevɨ dulyideihi mɨꞌ. Arɨkewɨnyɨra. ");
INSERT INTO byr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sarevɨdaaꞌnyɨ pwai yune gamɨ sai kwaakewɨ walamarakɨnojɨ kaimɨraaya dazaibɨꞌ yɨmaꞌnajai, yɨ Sɨgunyavɨya maremwaaidevɨneꞌna aꞌmwe dazai pwaraavɨ wavɨlavadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nabaai pwai kwai nɨmɨnyɨna yawɨrojɨ kaimɨraaya dareibɨsarɨ maarajai yɨ sarevɨ nɨmɨnyɨ nyɨmaaradelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pwara kaimɨraaya maalɨkera kwaamuꞌ mwaaidɨvɨsarabɨtara nɨmɨnyɨna dɨragɨnna lɨmwabɨzarajɨya pwarɨ aꞌmwei walapapalakyaꞌna wɨdɨna kyojɨ nɨmɨrei kayaaꞌnanyabwi yajaꞌ yɨ aꞌmwe dazarɨna yɨhɨthɨma! Sahwai sara yajai Gotɨyarɨna yagaainakei kyɨmaꞌnojɨ Gotɨyai kayaaꞌna dɨragɨnaanna wiadelyɨ. Sɨnnawɨ nɨmɨrerɨ kayaaꞌna mujahaaꞌ sɨla naangei gamɨre tɨlɨnnyavɨ lɨvarɨdapɨjɨ kwajɨ saalaalyavɨ kewewɨnɨ maralɨvarabɨzɨ kwajɨ tewaanyaꞌ kwaradɨka! Gotɨyai kayaaꞌna dɨragɨnaanna wiadeꞌneꞌna sabwi tewaanyaꞌ kwaradɨka! ");
INSERT INTO byr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Weꞌ, aꞌmwe Kwaakevakɨyara pwaraavɨ kayaaꞌnanyabwi walapapalakyaraavɨna Gotɨyai taangebwi wɨrɨvɨkɨraderaavɨna kale nyɨwaka. Pwara nɨmɨnyɨ yagalyaꞌmapɨjaꞌna sahwaraavɨ Gotɨyai dɨragɨnaanna wiadelyɨ. Weꞌ, sareꞌna sahwaraavɨna kale nyɨwaꞌ. Sareꞌ dareꞌnesɨ. Kayaaꞌnanya dazabwi yɨmaꞌnaabathevulyɨ. Nebulyasɨ. Kɨrɨꞌ aꞌmwe sasare sabwi makabade sarɨna, weꞌ, Gotɨyai kayaaꞌnanaanga wɨrɨvɨkɨradeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nabaai gɨmɨre asɨlyɨ kayaaꞌnanya yɨjaigɨ gɨmɨre sɨmunyaꞌ kayaaka kyɨgalojɨ ‘Kayaaꞌnanyaba namwaaimudɨka!’ dɨzaigɨ sasare gɨnnya asɨrɨ dakuꞌnyɨna yaꞌgɨzɨ lɨvaranna ja! Ata gave pwina kɨnɨnnakeigɨ yuyagaaꞌne gaalyabwina dɨmwaaideigɨnyɨneꞌna tewaanyasɨ. Ata puraai kɨnɨnnakeigɨ Dɨka myɨgaayaꞌnevɨ maragɨlɨvarabɨꞌdeꞌna kayaaꞌnanyasɨ. Sareꞌna sabwina minna! Nabaai gɨmɨre sɨvɨlyɨlyɨ wawaꞌgɨzɨ kayaaꞌnanya yɨjaigɨ sɨmunyaꞌ kayaaka kyɨgalojɨ ‘Kayaaꞌnanyaba nanyɨmwaaihadɨka!’ dɨzaigɨ sasare sɨvɨlyɨrɨ dakuꞌnyɨna yaꞌgɨzɨ lɨvaranna ja! Sɨvɨla gave pwina kɨnɨnnakeigɨ yuyagaaꞌne gaalyabwina dɨmwaaideigɨnyɨneꞌna tewaanyasɨ. Sɨvɨla puraai kɨnɨnnakeigɨ Dɨka myɨgaayaꞌnevɨ maragɨlɨvarabɨꞌdeꞌna kayaaꞌnanyasɨ. Sareꞌna ayɨna dɨragɨnna gɨthɨma! Sasarebwina minna! ");
INSERT INTO byr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nabaai gɨmɨre tɨnnyalyɨ kayaaꞌnanya wangadɨzaigɨ sɨmunyaꞌ kayaaka kyɨgalojɨ ‘Kayaaꞌnanyaba nanyɨmwaaihadɨka!’ dɨzaigɨ sasare tɨnnyarɨ jɨwaꞌmwanna yaꞌgɨzɨ lɨvaranna. Tɨnna gave pwaina kɨnɨnnakeigɨ yuyagaaꞌne gaalyabwina dɨmwaaideigɨnyɨneꞌna tewaanyasɨ. Tɨnna pwaraai kɨnɨnnakeigɨnyɨ Dɨka Naangevɨ maragɨlɨvarabɨꞌdeꞌna kayaaꞌnanyasɨ. Dazasareꞌna sabwina minna! ");
INSERT INTO byr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mala nayaa jɨwannyɨla! Sarɨmɨ sɨmunya kaimɨraaya daraavɨna dara nyawɨpɨdɨꞌ! ‘Dazarajɨya pɨmɨlɨꞌ wana yaasɨwaꞌnanyalyɨra.’ Sareꞌ dareꞌnesɨ. Dara yɨhɨthɨvanɨge. Ejelɨyara kaimɨraayaraavɨ nayaa maremwaaidɨvɨsarera. Sahwaraavɨ daanga wina yadaaꞌnyɨ taanga maarɨna yɨpɨja yuyanna ejelɨyara Nɨmwai Sɨgunyavɨ mwaalɨkerɨ wɨjɨwaakadɨvɨsare. ");
INSERT INTO byr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Sareꞌ dareꞌnesɨ. Aꞌmweraavɨne Kaimɨraayainyɨ tusavɨ yadakunɨkeraavɨ padaihasamaaryaꞌneinyɨ bɨweinyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Sarɨmɨ dareꞌna gara yawɨꞌmanɨgava? Aꞌmwe pwai sipɨzipɨya waanɨ aadɨretɨyara kɨnɨnnakei mwaalajai sipɨzipɨya pwai kyadaavojɨ bɨrɨbɨryaꞌnei wawadei midaaka! Sai mugunyangɨ sipɨzipɨyara 99 mwaaidapi yagalyaꞌmaꞌna yojɨ sipɨzipɨya gave pwainanya yadaavaja dazaina bɨrɨbɨrya yaꞌnelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nebulyaꞌna yɨhɨthɨvanɨge. Sai mena bɨramaarajai sipɨzipɨya gave pwainanya dazarɨna yɨlaaya naanga yadelyɨ. Yɨ sipɨzipɨyara 99 myadaayɨ yadaapiyaraavɨna yɨlaaya maalɨka yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sasare sabaaibɨꞌ Sɨrɨnɨmaanga Sɨgunyavɨ mwaalɨkei maalɨka dazarajɨyarɨna sɨmunyaꞌ dɨna ‘Kaimɨraaya dazai myadaavanna! Aala!’ dada bɨramaaꞌmanɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nabaai jaꞌmwei kayaaꞌnanya pɨbwi gyazaryawɨnna wɨna yaꞌgɨzɨ yune kɨrɨmɨnna mwaalɨna yakɨlyɨ gamɨre kayaaꞌnanyabwi jalɨkurakɨna. Nabaai sai kadɨka nayaa guꞌnajai yɨ tewaanna yavadaꞌgalamwaaida gɨmɨjɨ avaaizɨmunya jeꞌmwannamwaalyideraaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kɨrɨꞌ gɨmɨre yagaalyaꞌ kadɨka maguꞌnyajai yɨ aꞌmwe pwaina aꞌmwe kwaraaina maarɨna yaꞌgɨzɨ gɨmɨjɨ wɨna. Wɨna kyapɨjɨ aꞌmwe pwaraaihi daraai dala kwaihi gamɨre yagaala jalɨkurakyaꞌneihi dɨthɨnyideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kɨrɨꞌ sahwaraare yagaalyaꞌ kadɨka muꞌnyɨ yajai nɨmɨre kusɨlaanyaraavɨ wɨdɨna. Nabaai kusɨlaanyaraavɨre yagaalyaꞌna kadɨka muꞌnyɨ yajai sarɨna dara jawɨꞌdelyɨ. Anga naanga pimagɨnyai menyai yɨmaꞌnadei daaka! Taakɨzɨya maaꞌda kuka maaꞌdei daaka! Sareraavɨ yɨvanɨgevaaibɨꞌ sahwarɨ sara yɨdeinyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nebulyaꞌna yɨhɨthɨvanɨge. Nɨmɨreihi sɨryaꞌmweraavɨna Kwaaka davakɨ dɨmaremwaalyideihɨlyɨ. Sahwaibɨsaraavɨna Kwaaka davakɨ ‘Sabwi kayaaꞌnanyabulyɨ. Kusɨlaanyainaayawɨ dɨwona!’ wɨdapɨjɨyagaaꞌ yɨ Sɨgunyavɨ Gotɨyai ‘Sabwi kayaaꞌnanyabulyɨ,’ mena sara yawɨꞌna. Nabaai Kwaaka davakɨ ‘Sabwi tewaanyabulyɨ,’ dapɨjɨyagaaꞌ Sɨgunyavɨ ‘Sabwi tewaanyabulyɨ,’ mena sara yawɨꞌna yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nabaai yagaala ayɨna yɨhɨthɨvanɨge. Kwaaka davakɨ gazazangɨna sarɨmɨjɨyaraai avaaizɨmunyaꞌna yakɨlyɨ Gotɨyarɨ yɨdaanganyɨkajaꞌ yɨ sasareꞌ Sɨgunyavɨ mwaalɨkei Nɨmaamaangei sahwaraarɨna yannelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yo, nɨmɨnyɨna aꞌmwe pwaraaihi daraai dala kwaihi anga pɨba yɨꞌbwaꞌnemwaaibɨzaihi sarɨmɨnyɨ tɨnnyaba mwaalɨdeꞌna Nɨmwai sara yɨhɨgaimwagatheꞌnanyɨ.” Sara wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Dazagaaꞌ Pitai gamɨnyawɨnna bɨna yɨna yaka wɨdɨna “Naangeigɨ, nyaꞌmwei kayaaꞌnanya yɨya kanyojɨ gamɨre kayaaꞌnanya marasɨꞌnyaꞌneinyɨ kayaaꞌnanya sa gara gara nyadengaka? Yɨnɨga wiꞌna ata purɨdaaꞌnyɨ pwaraainanyaꞌna dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Wɨdɨna kyaꞌ Jizaazai dara wɨdɨna “Ata purɨdaaꞌnyɨ yune pwaraainanyaꞌna gɨthɨweꞌna mɨꞌ. Aawa. Yɨnɨga wiꞌna kwala naanga naangenna gɨthɨwa.” ");
INSERT INTO byr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Sara wɨdɨna yaka savɨna keꞌbaꞌnanyaꞌ dara wɨdɨna “Sarevɨdaaꞌnyɨ Sɨgunyavɨya maremwaaidevɨ aꞌmweraavɨre kayaaꞌnanyanna marasɨꞌnyaꞌnebwi dareꞌbɨsabulyɨ. Pɨgaaꞌ aꞌmwe pwai Kingɨyai maremwaaidei yawɨꞌna ‘Nɨnnya nyɨdaayadɨvɨtaraavɨre nɨgwɨtɨvɨkɨta yavadaꞌgalamaarɨma!’ ");
INSERT INTO byr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sara yawɨꞌna kyaꞌ nɨgwia gaai yamaasagaaꞌ dinaaya naanga naangeꞌ (10 milɨyonɨ kinaaya) kɨnɨnnakerɨ makabɨna. ");
INSERT INTO byr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Makabɨna kyeꞌ kɨrɨꞌ dinaaya yɨnɨga tɨvɨkɨryaꞌneꞌ sai nɨgwia maayalyɨ. Sarevɨdaaꞌnyɨ kingɨyai dɨragɨnna wɨdɨna ‘Aꞌmwe dazalyɨ gamɨre aꞌmwesɨ kaimɨraayajɨ gannya gɨlyɨvɨta yuyajɨ marayaasɨpɨka! Sara miꞌna yaasɨna yapɨjɨ nɨgwia daza nɨmɨnyɨneꞌna dinaaya tɨvɨkɨryaꞌne maapɨka!’ ");
INSERT INTO byr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sara wɨdɨna yakevɨdaaꞌnyɨ wɨdaayade dazai kingɨyaryaba kwadaai bulagina yaka kɨnna dɨna yaka wɨdɨna ‘Weꞌ, nɨmɨnyɨna kale kagyozɨ nɨmɨnyɨna yemwaala dɨnya! Nabaai dinaaya yuyaꞌ gɨrɨvɨkɨrɨdeinyɨra.’ ");
INSERT INTO byr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kadɨka sara wɨꞌnaka wɨdaayade dazare naangei sahwarɨna kale wina kyaꞌ wɨdɨna ‘Wikɨra. Gɨmɨre dinaayaꞌ manyɨjaayɨ dɨnyɨdeigɨnyɨ. Wiꞌnanyɨra. Miꞌna gɨmarasɨꞌnyɨwana.’ Sara wɨdɨna yaka dinaaya saꞌ yɨnahu marasɨꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Sara kyaꞌ mwasawɨnna wɨdaayade dazai walyuna yaka gamɨjɨya wɨdaayade pwarɨ walyanganna. Sahwai sɨnnawɨnyarɨna dinaaya maalɨkeꞌ (100 kinaaya) kɨnɨnnakelyɨ. Yɨthaanyi, sɨnnawɨnyai avaaiwawɨnya dazarɨ walyanganna yaka galalɨmwanna yɨna yaka gamɨre tɨlɨnnyavɨ galagɨraaꞌdɨwanna yada wɨdɨna ‘Nɨmɨnyɨneꞌ gɨmɨre dinaaya yuya yunebanna dɨrɨvɨkɨka!’ ");
INSERT INTO byr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Sarevɨdaaꞌnyɨ gamɨre avaaiwawɨnyai kwadaai gɨlɨna yaka dɨragɨnna yɨdaanganna ‘Nɨmɨnyɨna kale kagyozɨ nɨmɨnyɨna yemwaala dɨnya! Nɨmɨre dinaaya gɨrɨvɨkɨrɨdeigɨnyɨ.’ ");
INSERT INTO byr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kɨrɨꞌ sai ‘Aala!’ dɨna. Aawa. Sarɨ kalavuzavɨ marɨmwaaihɨna yaka ‘Sahwai dinaaya saꞌ nɨmɨnyɨna tɨvɨkɨradehaaꞌna yagalyaꞌmavadelyɨ.’ ");
INSERT INTO byr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Sara wɨdɨna kyaꞌ sarevɨdaaꞌnyɨ gamɨre avaaiwawɨnyara sasare sabwi wanganeva kale naanga wiadaaꞌnyɨ kumɨre naangerɨ yagaala yuya daza wɨjɨwakaawɨna. ");
INSERT INTO byr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sara wɨjɨwakaawɨna kyeꞌ aꞌmwe naangei wɨdaayade dazarɨ jaka wɨdɨna yaka dara wɨdɨna ‘Yaasɨwaꞌwawɨnya kayaaꞌnanyaigɨ! Aayagaaꞌ nɨmɨnyɨ kɨnna kanyɨdɨwaa sareꞌna gɨmɨre dinaaya yuya yaasɨwaꞌna gɨmarasɨꞌnyɨweigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nɨmɨ kale gɨhaimwamwebaaibɨꞌ gɨmɨre avaaiwawɨnyarɨ kale kugaimwadɨka! Sara yɨjɨ kwajɨ sabwi nawɨꞌnyaꞌ kwaradɨꞌ!’ ");
INSERT INTO byr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wɨdɨna yaka gamɨre naangei sɨnna tɨka wɨdaꞌdaaꞌnyɨ aꞌmwe daangita wɨjaavadɨvɨsaraayawɨ marɨmwangakɨna. Gamɨre dinaaya yɨnɨga wiꞌna yɨꞌmwannyaꞌnerɨ marɨmwangɨna yakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nabaai sarɨmɨre sɨmunyangɨ sarɨmɨ yuyaihi sɨryaꞌmwe gazarazaraavɨre kayaaꞌnanya mamarasɨpɨjaꞌ yɨ Nɨmaamaangei Sɨgunyavɨ mwaalɨkei avaaina sana yɨhyathelyɨ.” Sara wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jizaazai yagaala daza jɨꞌmwannyɨna yakegaaꞌ anga Galɨli yagalyaꞌmaꞌna yɨna yaka Aalya Jothanɨ pimagɨnna anga naanga Juthɨyanna wɨna. ");
INSERT INTO byr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wɨna kyaꞌ kwala bwaꞌnaanya naanga sahwarɨ mɨdɨnyɨna kyeꞌ dazɨmagɨ kumɨre nalaaya tewaanya yavadaꞌgaina wiaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nabaai gamɨnyawɨnna Perɨzɨya pwara bɨna yeva “Kayaaꞌna jaꞌnanedazɨwaka?” yawɨꞌna yadɨvɨꞌ yaamɨjɨ yɨjɨwaaina yaꞌnera wɨdɨna “Nemɨre kɨwɨnya dɨnɨkeburɨ gazannazanna aꞌmwei gannya aꞌmwevɨ yɨnahu wɨdaasaꞌ tewaanyaꞌ dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sara wɨdɨna kyeꞌ sai jaꞌnawɨdɨna “Gotɨyare bukuyavɨ dɨnɨka dathaꞌ madanganyadɨvɨsaihi daaka! Sɨnnawɨ kɨgaakuna Gotɨyai yuya wakyaakegaaꞌ kwalyalyɨ balyasɨ sawaarɨ yavɨkarina yaakeyolyɨ. ");
INSERT INTO byr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Sara yaka sai dɨna ‘Sarevɨdaaꞌnyɨ aꞌmwei ganɨmaangelyɨ ganaangesɨ sawaarɨ yagalyaꞌmavojɨ gannya aꞌmwesɨ yɨrakuꞌna yɨkadeyolyɨ. Nabaai sayoi kɨlaaka gave pɨjɨꞌnanyayoi yɨmaꞌnyɨkadeyolyɨ.’ Yagaala dazavɨ myawɨryadɨvɨsaihi daaka! ");
INSERT INTO byr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sarevɨdaaꞌnyɨ sayoi kɨlaaka pɨjɨkaaina ayawɨ yɨkadewaai mɨꞌ. Aawa. Sayoi yune kɨlaaka gave pɨjɨꞌnanyɨ. Sarevɨdaaꞌnyɨ sasare sabwi Gotɨyai mena yeꞌmwannemwaaihɨnɨkelyɨ. Aꞌmwera nadahaaibwapɨdɨka!” ");
INSERT INTO byr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wɨdɨna kyaꞌ sahwara wɨdɨna “Nedɨwaanyaꞌna Ne Mozɨzai kɨwɨnyaꞌ dara beꞌna dɨnɨkavaka? ‘Aꞌmwei gamɨre balaangevɨ wɨdaasaꞌnei pɨkarɨyɨkwiavɨ yɨdaꞌna yojɨ aꞌmwevɨ wɨjaavojɨ yunakaanna wɨdaasadelyɨra.’ Beꞌna dɨnɨkevɨnaka!” ");
INSERT INTO byr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Wɨdɨna kyeꞌ sai wɨdɨna “Sarɨmɨre sɨmunyangɨ galarɨlavɨmwaaihɨnyɨna kiwaakɨra. Sarevɨdaaꞌnyɨ Mozɨzai sarɨmɨre aꞌmwengɨ wɨdaasaꞌna baihanaꞌna yɨhyaakelyɨ. Kɨrɨꞌ sɨnnawɨ kɨgaakuna sasare dazabwi waryaakebwi mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nabaai dara yɨhɨthɨvanɨge. Pwai kwai gamɨre aꞌmweꞌ mudɨkerɨ maridaayɨ yajaꞌ sahɨrɨvɨ yaasɨwaꞌna wɨdaasadevɨdaaꞌnyɨ aꞌmwe pɨrɨvɨ nayaa yɨdaanganojɨ kwala maarajai yɨ sahwarɨna Gotɨyai dɨna ‘Aꞌmwe sai ata lɨmwangebwi kayaaꞌna yɨwakelyɨ.’” ");
INSERT INTO byr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Sagaaꞌ gamɨre mɨdɨdɨvɨsara wɨdɨna “Aꞌmwei gannya aꞌmwevɨ sara mudaasɨ yajaꞌna nemɨ kwala namaraadɨka! Nemɨ aꞌmwe maayaina mwalaadevwi nawɨꞌnyasɨ.” ");
INSERT INTO byr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Wɨdɨna kyeꞌ sai wɨdɨna “Yagaala dazaꞌ yɨnɨga wiꞌna yawɨramaaryaꞌnera yuyaraavɨna mɨꞌ. Aawa. Gotɨyai kwala mamaarya sasareburɨne dɨragɨnyaꞌ wɨjaavojɨya pwaraavɨnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sareꞌ dareꞌnesɨ. Yɨ kwala yɨnɨga mamaaryaꞌnera aꞌmwe dala pwarana pwarananyavɨnyɨ. Pwara kuvɨnaange maarɨna yesagaaꞌ kwala maaryaꞌnera mamwaalyɨ yɨpɨnerera. Pwaraavɨ aꞌmwera munya daꞌnɨkera kwala yɨnɨga maapɨꞌdera mɨꞌ. Pwara Sɨgunyavɨya maremwaaidevɨne wawɨnyaꞌ yawɨꞌdɨvɨꞌ kumɨ sara kɨmaakɨya dakadɨvɨꞌ kwala mamaaryadɨvɨsare. Aꞌmwei yagaala dazaꞌ yɨnɨga wiꞌna yawɨramaarannei sai yawɨramaaꞌna yana!” ");
INSERT INTO byr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sagaaꞌ gamɨnyawɨnna kaimɨraaya maalɨka pwaraavɨ makabɨna. “Kumɨre mɨnyagɨnyangɨ gamɨre asaꞌ wɨdathɨwada Gotɨyarɨ sahwaraavɨna wɨdana!” deva makabɨna. Miꞌna makabɨna kyeꞌ kɨrɨꞌ gamɨre mɨdɨdɨvɨsara kumɨnyɨ maanga wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Maanga wɨdɨna kyeꞌ Jizaazai wɨdɨna “Nɨmɨnyawɨnna kaimɨraayaraavɨ dɨmaryasaabila! Sarɨmɨ darihɨralɨmwagata mipɨnera! Sareꞌ dareꞌnesɨ. Sɨgunyavɨya maremwaaidevɨnera maalɨka sasareraavɨna Gotɨyai yanga wɨjaavadeꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sara wɨdɨna kyaꞌ gamɨnyawɨnna bɨna kyeꞌ asaꞌ mɨnyagɨnyangɨ dathɨwanna wiaꞌ. Sara wiaka dɨvidaaꞌnyɨ dazɨmagɨ yagalyaꞌmaꞌna yaka kaanna wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yɨthaanyi, aꞌmwe pwai gamɨnyawɨnna biꞌmaꞌna yaka wɨdɨna “Wɨjɨwaakyaigɨ, ‘Yuyagaaꞌ yuyagaaꞌne gaalyabwi maarɨma!’ daꞌmujɨ tewaanya gareꞌna yɨdeinyaka?” ");
INSERT INTO byr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Wɨdɨna kyaꞌ jaꞌnawɨdɨna “Tewaanyaꞌna nɨmɨnyɨna beꞌna nyɨdaangamanɨgɨna? Tewaanyai yune gave sahwainanyalyɨra. Kɨrɨꞌ gɨmɨ ‘Gaala nebulyaburɨ mwaalyaꞌneinyɨ,’ yawɨꞌdɨzaꞌ kɨwɨnya dɨnɨkengɨ nayaa dɨmɨdɨna!” ");
INSERT INTO byr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Sai wɨdɨna “Kɨwɨnya garengaka?” Jizaazai wɨdɨna “Dathaꞌdarenna ‘Aꞌmwe maramakɨnnera! Pware aꞌmwevɨ ata malɨmwadɨnnera! Kuka minnera! Aꞌmwe pwaraavɨna kwaasɨ yagaala majalɨkurakɨnnera! ");
INSERT INTO byr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gɨmɨre gɨmaamaangelyɨ gwaangesɨ sawaare yaya munyaba makidɨ duhaimwana! Gɨmɨnyɨna gɨvuꞌnadevaaibɨꞌ pwaraavɨna avaaina nawɨꞌnya gɨvuꞌnana!’” ");
INSERT INTO byr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sara wɨdɨna kyaꞌ mɨgɨnya sai wɨdɨna “Kɨwɨnya yuya daza mena mɨdɨdɨnyangɨra. Nɨmɨnyɨ kuna gareꞌ nyɨgainɨvanɨkevaka?” ");
INSERT INTO byr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Wɨdɨna kyaꞌ Jizaazai wɨdɨna “Gɨmɨ ‘Yune nebulyaꞌnanyainyɨ yɨmaꞌnɨma!’ dɨzaigɨ gɨmɨre gɨlyɨvɨta yuya yasaawaꞌgɨzɨ aꞌmwe gɨlyɨvɨꞌmaayaraavɨ nɨgwia duzaama! Sarevɨdaaꞌnyɨ Sɨgunyavɨ gɨmɨ gɨlyɨvɨta kwalaalya kɨnɨnnakeigɨ jɨmaꞌnadeigɨnyɨ. Nabaai nɨmɨnyɨ dɨnyɨmɨdɨnaama!” ");
INSERT INTO byr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wɨdɨna kyaꞌ mɨgɨnyai yagaala dazaꞌ kadɨka sara wɨꞌnyɨna yaka kale wiadaaꞌnyɨ kaanna wɨna. Sareꞌ dareꞌnesɨ. Sai gɨlyɨvɨta kwalaalya kɨnɨnnakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sagaaꞌ Jizaazai gamɨre mɨdɨdɨvɨsaraavɨ wɨdɨna “Nebulyaꞌna yɨhɨthɨvanɨge. Sɨgunyavɨya maremwaaidevɨ aꞌmwe nɨgwɨhɨravɨnakei yagɨyagɨ wɨladelyɨ. Yaasɨwaꞌna mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ayahi yɨhɨthɨvanɨge. Kaamelɨyai ‘Langa kwaabɨhannya gipwaidɨvɨta sarɨkɨre daibuꞌnyavɨ wɨlɨma!’ dozɨ saꞌ yagɨyagɨ wawɨnya maayasɨ. Nɨgwɨhɨravɨnakei ‘Gotɨyai maremwaaidevɨ wɨlɨma!’ dozɨ saꞌ yagɨyagɨ wawɨnyasɨ.” ");
INSERT INTO byr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wɨdɨna kyaꞌ mɨdɨdɨvɨsara kadɨka sara wɨꞌnyɨna yeva lɨka yɨwainɨgulaawɨna yɨna yeva wɨdɨna “ ‘Nɨgwɨhɨravɨnakei aawa!’ daakajɨ aaihwarɨ padaihasamaarannelaka?” ");
INSERT INTO byr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Wɨdɨna kyeꞌ Jizaazai tɨnna baihanaꞌna wiaka wɨdɨna “Aꞌmwera wiꞌna mɨka! Kumɨ sara Gotɨyaryawɨnna mabi yɨpɨnerera. Kɨrɨꞌ Gotɨyai yuyabwi yɨnɨga wiꞌna yannelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Wɨdɨna kyaꞌ sagaaꞌ Pitai jaꞌnawɨdɨna “Yɨthaa, nemɨ yuyangɨ yagalyaꞌmavona gɨmɨdɨmwona. Sarevɨdaaꞌnyɨ nemɨ tɨvɨkɨryaꞌne benɨ maraadengaka?” ");
INSERT INTO byr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Wɨdɨna kyaꞌ Jizaazai kumɨnyɨ dara wɨdɨna “Nebulyaꞌna dara yɨhɨthɨvanɨge. Yuya mudɨka yɨmaꞌnadehaaꞌ Aꞌmweraavɨne Kaimɨraayai dɨragɨnyasɨ byaannyasɨ kɨnɨnnakei kingɨyarɨ namwaalyɨta nawɨꞌnyavɨ mwaalade dazahɨgaaꞌ sarɨmɨ nyɨmɨdɨdɨvɨsaihi kwaihɨlyɨ namwaalyɨta nawɨꞌnya sɨvɨlɨrɨdaaꞌnyɨ pwaraala sangɨ dɨmwaalyideihɨlyɨ. Sara yadɨvɨꞌ yawɨbwaryaꞌneihi Yɨzɨrelɨyaraavɨre yɨsavakaavɨ sɨvɨlɨrɨdaaꞌnyɨ pwaraala savakaavɨ dɨmaremwaalyideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nabaai gazaizai nɨmɨnne yayavɨna yawɨꞌda nɨmɨre wawɨnya yada yɨ sahwai gamɨre angevɨ yagalyaꞌmaꞌna. Yɨ gyaꞌmwe pwaraavɨ gyaꞌmwe kɨnɨngɨ yagalyaꞌmaꞌna. Yɨ ganɨmaanga pwarɨ ganaanga kɨrɨvɨ yagalyaꞌmaꞌna. Yɨ gamɨre kaimɨraayangɨ yagalyaꞌmaꞌna. Yɨ aawawɨnyangɨ yagalyaꞌmaꞌna. Yɨ sarevɨdaaꞌnyɨ sahwai tewaanya kwalaalya naanga maaradelyɨ. Nabaai sara yojɨ Ganɨmaangere yuyagaaꞌ yuyagaaꞌne gaalyabwi maaradelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kɨrɨꞌ dahaaꞌ aꞌmwe kwalaalyara kumɨre yaya munyaba warɨkera dɨvi nɨmɨnyɨneꞌna kumɨre yaya kwaakeba waraderera. Nabaai dahaaꞌ aꞌmwe kwalaalyara kumɨre yaya kwaakeba warɨkera dɨvi nɨmɨnyɨneꞌna kumɨre yaya munyaba waraderera. ");
INSERT INTO byr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sareꞌ daꞌdaresɨ. Sɨgunyavɨya maremwaaideꞌ aꞌmwe pwai aawawɨnya kɨnɨnnakei yɨnɨkabaaibɨsasɨ. Wana mwanyavɨ (6 kɨlokɨ) gamɨre gɨraipɨwiwawɨnyavɨ wɨdaayaꞌne pwaraavɨ maaryaꞌnei kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kaanna wɨna yaka aꞌmweraavɨ wɨdɨna ‘Nɨmɨre gɨraipɨwiwawɨnyavɨ nyɨdaayaꞌneihɨrɨ nemɨre sabwineꞌna pwarɨ dahaaꞌne kinaayaꞌ pwarɨ dahaaꞌne kinaayaꞌ yɨhɨzaavɨdeinyɨ.’ ‘Yo, wikɨra,’ jaꞌnawɨdɨna kyeꞌ gamɨre wawɨnyavɨna wɨdaasɨna. ");
INSERT INTO byr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wɨdaasɨna yaka mwanyɨzɨrɨgwajahaaꞌ maaketɨyaba ayahi wɨna yaka aꞌmwe pwara yaasɨwaꞌna yadapiyaraavɨ tɨnna wanganna. ");
INSERT INTO byr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tɨnna wanganna yaka wɨdɨna ‘Sarɨmɨ kwaihɨlyɨ nɨmɨre wiwawɨnyavɨna kaanna wawopɨjɨ jaawila! Yɨ nabaai nɨgwia yɨdaꞌnanya yɨhɨzaavɨdeinyɨra.’ Kudaꞌ sarevɨdaaꞌnyɨ kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kaanna wɨna kyeꞌ dɨvidaaꞌnyɨ sɨrɨgwajahaasɨ sɨvɨraryagaasɨ gyakwai ayahi wɨna yaka avaaina sana yɨna. ");
INSERT INTO byr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nabaai sawɨsaburɨ (5 kɨlokɨ) ayahi kaanna wɨna yaka aꞌmwe pwara daaꞌdapiyaraavɨ tɨnna wanganna yaka wɨdɨna ‘Dava nyɨlaanga davɨ yaasɨwaꞌ gathaꞌdarevɨna daakava?’ ");
INSERT INTO byr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Sahwara jaꞌnawɨdɨna ‘Nemɨnyɨ wawɨnya nejaayaꞌnei pwai midaakajɨnyɨra.’ Jaꞌnawɨdɨna kyeꞌ sai wɨdɨna ‘Sarɨmɨ kwaihɨlyɨ nɨmɨre wawɨnyavɨna dɨwila!’ ");
INSERT INTO byr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Sara wɨdɨna kyaꞌ yuyara wawɨnya yɨna kyeꞌ nyɨla walakyagaaꞌ mena kyɨmaꞌnaꞌ wiwawɨnyavɨ gyakwalaangei gamɨre maredaasarɨ dara wɨdɨna ‘Wawɨnyavɨ nyɨdayɨwaasaraavɨ jaka wɨdaꞌgɨzɨ nɨgwia duzaama! Wawɨnya aaya dɨvidaaꞌnyaraavɨ sahwaraavɨdaaꞌnyɨ duzaama! Nɨgwia sahwaraavɨ kuna kuna wɨjaavaꞌgɨzɨ yune wawɨnya sɨnnawɨ wɨdaayaraayabanna jɨꞌmwannadesɨra.’ ");
INSERT INTO byr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Sara wɨdɨna kyaꞌ maredaasai sara yɨna yada aꞌmwera wawɨnyaꞌ yamaaꞌdɨvɨꞌ yune sawɨsaburɨ (5 kɨlokɨ) yesara biꞌmaꞌna yɨna yeva pwai kinaaya pɨrɨꞌ pwai kinaaya pɨrɨꞌ maarɨna. Sagaaꞌ yɨrɨka yunevɨna wawɨnyavɨ nɨgwia kinaaya pukɨra. ");
INSERT INTO byr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Maarɨna kyeꞌ wawɨnya aayagaaꞌdaaꞌnyɨ yamaaꞌnɨka sara tɨnna wanganna yeva yawɨꞌna ‘Dɨvidaaꞌnyara pwai kinaaya pɨrɨꞌ pwai kinaaya pɨrɨꞌ maꞌmwaasaꞌna nemɨ pɨnɨjɨ maraadeinera.’ Sara yawɨꞌna kyeꞌ kɨrɨꞌ sara kwarajɨ pwai kinaaya pɨrɨꞌ pwai kinaaya pɨrɨꞌ maarɨna. ");
INSERT INTO byr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Sara maarɨna yeva jɨkurya yɨna yeva wawɨnyavɨ gyakwalaangerɨ maanga wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Aꞌmwe dazara aaya dɨvidaaꞌnyɨ yɨmaꞌnaabadɨvɨꞌ wawɨnyaꞌ yune waanɨ aawaayaꞌna wavɨlaꞌderera. Gɨmɨ nɨgwia saraavɨ wɨjawaanyaꞌ nemɨ maraanneꞌ wɨjawaana! Kɨrɨꞌ nemɨ wawɨnya naanga yadaa mwanyavɨdaaꞌnyaina yune nyɨla walakyagaaꞌna yɨꞌmwannɨvanɨgoinera. Sara yadaawori nyɨla naangeꞌ nebaihinɨvanɨkeinera.’ ");
INSERT INTO byr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Maanga sara wɨdɨna kyeꞌ wawɨnyavɨ gyakwalaangei kumɨjɨya pwarɨ jaꞌnawɨdɨna ‘Nyaꞌmweigɨ, gɨmɨnyɨna kayaaꞌna magivanɨge. Naarɨmɨ kinaaya pɨrɨꞌna “Tewaanyasɨra,” myawɨrijɨhyɨwola? ");
INSERT INTO byr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sarevɨdaaꞌnyɨ gɨnnya nɨgwiaꞌ maarɨna yaꞌgɨzɨ kaanna wɨna jɨ! Nyɨvuꞌnɨvanɨka daresɨ. Gɨzaavanɨgevaaibɨꞌ aꞌmwe aaya dɨvidaaꞌnya dazarɨ avaala wɨjaawa. ");
INSERT INTO byr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Sareꞌ yune nɨmɨresɨ. Nɨnnya nɨgwia yune sangɨna yɨnɨga mi yɨwɨneinyɨ dɨngaka? Nɨmɨ tewaanyabwina yadɨnyainyɨneꞌna sɨmunyavɨ jɨkurya yawɨꞌdɨ wabarɨnna yɨvanɨgɨnyaigɨ dɨngaka?’ wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Keꞌbaꞌna yɨhɨthɨwe daꞌdaresɨ. Aꞌmwe dɨvidaaꞌnyara sɨnnawɨnyara yɨmaꞌnɨpɨꞌderera. Nabaai aꞌmwe sɨnnawɨnyara yune dɨvidaaꞌnyɨna yɨmaꞌnɨpɨꞌderera. (Gotɨyai gannya gaalyabwi aaya dɨvidaaꞌnyaraavɨna avaaina sɨnnawɨ wɨjaavaderera. Nabaai gannya gaalyabwi sɨnnawɨ aayagaaꞌdaaꞌnyaraavɨna dɨvidaaꞌnyɨ wɨjaavaderera.)” ");
INSERT INTO byr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jeruzaalemɨna kaanya yɨlaawiaꞌnei woda gamɨre sɨvɨlɨrɨdaaꞌnyɨ pwaraalyara gavera gamɨnyabanna jɨꞌbwaramakuna yaka tutaanyavɨ kavena wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yɨthaanyi, dahaaꞌ Jeruzaalemɨneina yimanaawɨgo. Sahɨba aꞌmwe pwai Aꞌmweraavɨne Kaimɨraayainyɨ Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangeraavɨnajɨ Kɨwɨjaraavɨnajɨ nyɨmarɨmwaaihadelyɨ. Marɨmwaaihɨna kanyojɨ kotɨyavɨ nɨmɨnyɨna wɨdɨna ‘Kayaaꞌnanyai balana!’ ");
INSERT INTO byr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sara wɨdɨna yapɨjɨ ajɨmya pɨnɨngɨyaraavɨna Menyaraavɨna nyɨmarɨmwangɨpɨꞌdeinyɨ. Wɨmarɨmwangɨna kanyapɨjɨ yagaaibɨraizɨka nyɨdanganapɨjɨ wɨla kayaaꞌnanyabaalyɨ mala naanga nyɨramapɨjɨ yɨsavɨri maranyɨramarɨmupɨꞌdeinyɨ. Sara kanyapɨjɨ yɨrɨka darɨkaai darɨkɨ ayɨna nyɨdɨkaavadeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Dazagaaꞌ Sevathiyare balaangesɨ gamɨre gawaalɨvaangeraalyɨ kɨnɨdaka yeꞌmwannɨguna yeva Jizaazaryawɨnna bɨna. Miꞌna bɨna yeva kwaakevɨ kɨrɨnaangeꞌ walarutaꞌnyɨna yaka “Pɨrɨꞌna githaanganɨjɨwana?” wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Wɨdɨna kyaꞌ wɨdɨna “Gɨvuꞌnɨvanɨkeꞌ berɨvaka?” Wɨdɨna kyaꞌ wɨdɨna “Gɨmɨre dɨmaremwaaidevɨ nɨmɨre kaimɨraaya datharaai, pwai gɨmɨre aangasɨmagɨ, pwai gɨmɨre kwanaamimagɨ mwaalyɨkadeꞌna sara dɨnyɨdana! Sareꞌna nyɨvuꞌnɨvanɨkesɨ.” ");
INSERT INTO byr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Wɨdɨna kyaꞌ jaꞌnawɨdɨna “Yɨdaangamanɨgata dazaꞌ nayaa myawɨranganyɨvanɨgaꞌ. Kaapɨvananyavɨ nɨdevaaibɨꞌ maalɨkegaaꞌ taanga naanga nyadesɨ. Taanga naanga sa kyɨhyojɨ kɨrɨmɨ yɨnɨga wiꞌna yɨkaneraaihi daaka?” Sara wɨdɨna kyaꞌ kɨdaraai wɨdɨna “Naarɨmɨ wiꞌna yakaneinaalyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Wɨdɨna kyagi wɨdɨna “Nebulyasɨ. Nɨmɨre kaapɨvananyavɨ dɨnyideraaihɨlyɨ. Kɨrɨꞌ ‘Nɨmɨre aangasɨmagɨ sahwai mwaalana! Nɨmɨre kwanaamimagɨ sahwai mwaalana!’ wɨjaꞌneꞌ nɨmɨreꞌ mɨka! Aawa. Sahɨbanyaarɨ mwaalyaꞌneraarɨna Nɨmaamaangei mena dahɨlakɨna, sara yawɨꞌmwakelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nabaai atɨraalyara yagaala dazaꞌ kadɨka wɨꞌnyɨna yeva sadaraarɨna sɨnna tɨka davɨna. ");
INSERT INTO byr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Sɨnna tɨka wɨdaꞌdaaꞌnyɨ kɨrɨꞌ Jizaazai gamɨnyawɨnna jaka jɨvwaramaaꞌna yaka wɨdɨna “Sarɨmɨ yawɨꞌmanɨgaꞌ ‘Kingɨyara ajɨmya yuyangɨyaraavɨrera kunnya aꞌmweraavɨ dathɨwanna yadɨvɨꞌ dɨragɨnya wɨmaremwaaidɨvɨsarera. Nabaai kumɨre aꞌmwe naangera dɨragɨnya yadɨvɨsare. Aꞌmwera aꞌmwemɨlɨka kumɨre yagaalya mɨdɨnyaꞌna dɨragɨnya yadɨvɨsare.’ ");
INSERT INTO byr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kɨrɨꞌ sasare dazabwi sarɨmɨnyɨ myɨhwarannera! Aawa. Pwai kwai sarɨmɨjɨyai ‘Naanga mwaalɨma! Aꞌmwe naangeinyɨ yɨmaꞌnɨma!’ wɨvuꞌnajai sarɨmɨre yɨhɨthaayadei mwaalana! ");
INSERT INTO byr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nabaai pwai kwai sarɨmɨjɨyai ‘Aaya sɨnnawɨnyainyɨ mwaalɨma!’ wɨvuꞌnajai yaasɨwaꞌwawɨnya yadeibɨꞌnanyai mwaalana! ");
INSERT INTO byr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sabaaibɨꞌ Aꞌmweraavɨne Kaimɨraayainyɨ ‘Nyɨdaayɨpɨꞌdeꞌnanyɨ,’ majɨ yena bɨweinyɨ. Aawa. ‘Yune kumɨnyɨ wɨdaayɨdeꞌnanyɨ. Aꞌmwe kwalaalyaraavɨneba ayɨna mubamaaryaꞌneinyɨ balɨdeinyɨ,’ dena bɨweinyɨ. Nɨmɨ yadɨnyabaaibɨꞌ sarɨmɨ duthaayideihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sagaaꞌ anga Jeriko yagalyaꞌmaꞌna yɨna yeva kaanna wɨna. Kaanna wɨna yadaapi kwala bwaꞌnaanya naangeꞌ mɨdɨnyɨna. ");
INSERT INTO byr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mɨdɨnyɨna yadaapi, yɨthaanyi, tuꞌmaangebaarɨ aꞌmwe tɨbɨnyaraai mwaalɨna yadiꞌ “Jizaazai bɨvanɨkerɨnera,” kadɨka wɨꞌnyɨna yagɨla jaka dɨragɨnna dɨna “Naangeigɨ, Ne Devitɨmɨre Kaimɨraayaigɨ, naarɨmɨnyɨ kaleꞌna dɨnehɨhaimwana!” ");
INSERT INTO byr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jaka sara kudahi kwala bwaꞌnaanyaꞌ “Jaka saꞌ makuꞌnyɨka!” deva maanga wɨdɨna. Maanga wɨdɨna kyeꞌ kɨrɨꞌ saraai jaka naanga dɨragɨnna kuna wɨdɨna “Naangeigɨ, Ne Devitɨmɨre Kaimɨraayaigɨ naarɨmɨnyɨ kaleꞌna dɨnehɨhaimwana!” ");
INSERT INTO byr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sara wɨdɨna kyagi Jizaazai mudaꞌna yaka saraarɨ jaka wɨjɨvwaramaaꞌna yaka wɨdɨna “Kɨrɨmɨnyɨ gara yɨhideꞌnanaka? Berɨvɨna yɨhɨvuꞌnadevaka?” ");
INSERT INTO byr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wɨdɨna kyaꞌ “Naangeigɨ ‘Naarɨmɨre tɨnnyara tewaanya yavadaꞌgalana!’ kadakwoihɨjɨ dɨnehya! Sareꞌna yawɨꞌmanɨgoi.” ");
INSERT INTO byr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kadɨka sara wɨꞌnyɨna yaka Jizaazai kale naanga wina kyaꞌ sagaaꞌ kɨrɨmɨre tɨnnyaraavɨ asa dathɨwanna. Sarevɨ wana sagaasagaaꞌ kɨrɨmɨre tɨnnyara nawɨꞌnya wanganna. Nawɨꞌnya wanganna yeva saraai gamɨnyɨ mɨdɨnna yɨna yagi. ");
INSERT INTO byr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jeruzaalemɨnera wɨna yeva Jeruzaalemɨ kɨbaweba anga Bepaaza aya kɨbanna yɨꞌmavaawɨna. Anga maalɨka saꞌ Mugunya Wolivɨ gidɨkusaba mannɨkebe. Aya kɨbanna yɨꞌmavaawɨna kyeꞌ Jizaazai gamɨre mɨdɨdita pwaraarɨ wɨdaasɨna ");
INSERT INTO byr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Kɨrɨmɨ anga maalɨka dazaba sangihɨrɨ wɨlakɨlyɨ yɨmeꞌnyaꞌbɨꞌ dogiya pɨrɨsɨ gamɨre dɨwɨnyai kwalyɨ wɨlyabaalyɨ galyɨrakɨnɨkenaarɨ danganyideraaihɨlyɨ. Sanaarɨ wɨla yaramaaꞌna yakɨlyɨ nɨmɨnyawɨnna dɨmakabyideraaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nabaai aꞌmwe pwai kwai yagaala pɨrɨꞌ yɨhɨthazai dara duzideraaihɨlyɨ ‘Naangerɨ wana kunerɨ kɨnaarɨna wɨgainɨvanɨkeꞌnanyɨ.’ Sara kudakɨlyɨ yɨmeꞌnyaꞌbɨꞌ sanaarɨ marayɨhyasaabathelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sara yeta dazaꞌ Gotɨyai “Pɨropetɨyare yagaala dɨnɨka dazavɨ yunebanna yaꞌneꞌ yɨmaꞌnana!” kadaꞌ sara yeꞌ. Yagaala saꞌ dara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Mugunya Saayonɨ mwaalyaraavɨ dara duzɨla! “Yɨthaanyi, sarɨmɨnyawɨnna sarɨmɨre kingɨyai bɨvanɨkelyɨ. Sahwai kwaamuꞌnanyai nawɨꞌnyabwi yɨna yadelyɨ. Sagaaꞌ dogiyarɨ aꞌba yɨlamwaalaka bɨvanɨkelyɨ. Sai dogiyavɨre dɨwɨnyarɨ aꞌba yɨlamwaalɨkelyɨ.” Pɨropetɨyare yagaalyaꞌ sara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jizaazai gamɨre mɨdɨdisaraarɨ sara wɨdaasɨna kyaꞌ saraai sara yɨna. ");
INSERT INTO byr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dogiya ganaangesɨ dɨwɨnya kwalyɨ sanaarɨ makabɨna yagɨla kɨrɨnnya baazɨꞌmaꞌnya dɨragɨnya dogiyarɨ aꞌba yɨlakɨna kyagi sai munyaba yɨlamwaaina kyaꞌ makuna. ");
INSERT INTO byr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Makuna yadaaꞌnyɨ kwala bwaꞌnaanya naangeꞌ tutaanyavakɨ yɨlaayaꞌna kumɨre baazɨꞌmaꞌnya yɨraipuꞌnyɨna yeva kwala pɨgɨlavajɨrɨꞌbwarakɨwɨlaawɨna yɨna yeꞌ. Nabaai pwara yɨtaanya paayɨna yadɨvɨꞌ tutaanyavɨ yɨlaayaꞌna wakɨwɨlɨna. ");
INSERT INTO byr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kwala bwaꞌnaanya pɨnɨ Jizaazarɨ sɨnnawɨ yɨmaꞌnyɨna yadɨvɨꞌ waanyɨna, kwala bwaꞌnaanya pɨnɨ dɨvidaaꞌnyɨ mɨdɨnyɨna, yuyara jaka wɨdamɨdɨnna “Ne Devitɨmɨre Kaimɨraayarɨ yɨlaaya maryaana! Naangere yayavɨnei bɨvanɨkerɨ tewaanya wɨjaavana! Sɨgunya keꞌmwewɨ Gotɨyarɨneꞌ munyabanna makɨlaana!” Jaka saꞌ wɨdɨ wɨja yɨna yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jaka wɨdɨna wɨdɨna wɨdɨna yadaapi Jeruzaalemɨna wɨlɨna yada aꞌmwe yuya angebanyara jaanga dɨkiꞌnɨgulɨna yɨna yeva dɨna “Aꞌmwe dazai aaihwalaka?” ");
INSERT INTO byr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Sara dɨna kyeꞌ aꞌmwera kaanya wodɨvɨꞌ dɨna “Dazai pɨropetɨya Jizaazalyɨ. Naazaretɨ mwaalyai Galɨlidaaꞌnyalyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Gotɨyare Anga Naangevɨ Jizaazai wɨlɨna yɨna yaka savɨ aꞌmwe yuyara nɨgwia maaryaꞌnera mubadɨvɨsaraavɨ wɨlatamabwakɨraasɨna. Yɨ aꞌmwera nɨgwɨyadaihamaata yadaapiya yɨꞌbɨnya yuya marapuratawakɨna. Yɨ kwaamɨrya Gotɨyarɨ wɨjaayaꞌneraavɨne aꞌmweraavɨre namwaalyɨsangɨ marapuratawakɨna. ");
INSERT INTO byr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Sara yaka sai wɨdɨna “Gotɨyare bukuyaꞌ dara dɨnɨkesɨ. Nɨmɨre Angeꞌ anga Gotɨyainyɨ nyɨdɨpɨꞌdevɨna dɨpɨꞌdesɨra. Sara dɨnɨka kɨrɨꞌ sarɨmɨ kayaaꞌna yadɨvɨꞌ aꞌmwe kukeraavɨre kɨmaꞌnyawɨbɨsaꞌ wakɨvanɨgasaihɨlyɨ,” sara wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Gotɨyare Anga Naangevɨ mwaalɨna yadɨꞌnyɨ aꞌmwe tɨbɨnya pwarajɨ sɨvɨla kayaaꞌnanyarajɨ gamɨnyawɨnna bɨna kyeꞌ nawɨꞌnya yavadaꞌgaina wiaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kɨrɨꞌ nawɨꞌnya yɨna yakengɨ Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ Kɨwɨjarajɨ sara tɨnna wanganna yeva nabaai Gotɨyare Angevɨ kaimɨraayamɨlɨka jaka wɨladadaapi “Ne Devitɨmɨre Kaimɨraayarɨna yɨlaaya yaana!” kadɨka wɨꞌnyɨna kyeꞌ sahwaraavɨ sɨnna tɨka naanga davɨna. ");
INSERT INTO byr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sɨnna tɨka davɨna yadaaꞌnyɨ wɨdɨna “Dazamɨlɨka yagaala dɨwaata dazaꞌ duꞌnɨwaana!” Sara wɨdɨna kyeꞌ Jizaazai wɨdɨna “Yo, wɨꞌnɨwana. Sareꞌ dɨnɨkeꞌ madanganyadɨvɨtaihi daaka! Dara dɨnɨkesɨ. Kaimɨraaya maalɨkemɨlɨkaavɨre maangevɨ Aamunya nɨvanɨgasamɨlɨkaavɨre maangevɨ Gɨmɨ yɨlaaya nawɨꞌnya galawɨratayɨwaa. Gɨmɨnyɨne yayaꞌ munyabanna makimanɨgasamɨlɨke. Sara dɨnɨkeꞌna dɨvanɨgaꞌ.” ");
INSERT INTO byr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Wɨdɨna yaka sahwaraavɨ yagalyaꞌmaꞌna yaka anga naangeba mwasɨlaa walyuna yɨna yaka sawɨta sarɨkɨ Betaanina waꞌmwaraawɨna. ");
INSERT INTO byr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mwanyavɨ anga naangebanna ayɨna wɨna yadaaꞌnyɨ mɨjɨka wina. ");
INSERT INTO byr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mɨjɨka wina yadaaꞌnyɨ wodimagɨnna tuꞌmaangebaarɨ yɨta pihɨya pɨrɨꞌ tɨnna maranganna yaka savɨna biꞌmaꞌna yaka kɨrɨꞌ tɨka munne aane pɨrɨꞌ kɨrɨꞌ mwaryadɨꞌnyɨ wanganna. Aawa. Yune kɨwasɨrana waꞌdɨꞌnyɨ wanganna. Yɨta savɨ dara wɨdɨna “Yuyagaaꞌ tɨka munne aane pɨrɨꞌ kɨrɨꞌ myɨꞌnyɨ jɨtheꞌgɨnyɨ.” Sagaaꞌ yɨta pihɨya saꞌ yawaka balɨna. ");
INSERT INTO byr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Miꞌna yawaka balɨna kyaꞌ mɨdɨdɨvɨsara tɨnna wanganna yeva lɨka yɨwɨlɨna. Lɨka yɨwɨlɨna yeva wɨdɨna “Yɨta pihɨya saꞌ dahaaꞌ yawaka yarai gathaꞌdarevɨna baimwaka?” ");
INSERT INTO byr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Wɨdɨna kyeꞌ Jizaazai jaꞌnawɨdɨna “Nebulyaꞌna yɨhɨthɨvanɨge. Sarɨmɨ dɨragɨnna lɨmwabɨzaꞌ sarɨmɨ sɨmunya pɨrɨwaai maaya yɨpɨneihi yɨ yɨta pihɨyavɨ yɨwebaaibɨꞌ yɨnɨga wiꞌna yɨpɨneihɨlyɨ. Yune sahɨrɨꞌna yanneꞌ mɨꞌ. Aawa. Sarɨmɨ mugunya dazavɨ wɨdɨna ‘Mugunyaꞌgɨ dɨkaavaꞌgɨzɨ saalaalyavɨna dɨthɨkwosɨka!’ Wɨdɨna kyapɨjɨ saꞌ sasara yannesɨ. Pwara mi yɨpɨnebaaibɨꞌ sarɨmɨ sasareꞌ yɨpɨneihɨlyɨra. ");
INSERT INTO byr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nabaai sarɨmɨ dɨragɨnna lɨmwagaꞌdɨvɨꞌ yuya sare yaꞌne wɨjangɨ Gotɨyarɨ kidaanganapɨjɨ yɨ sa yadengɨ.” ");
INSERT INTO byr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Gotɨyare Angevɨ wɨlaawɨna yaka kusawɨ aꞌmweraavɨ wɨjɨwaakɨna yadaaꞌnyɨ Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ aꞌmweraavɨne aꞌmwe naangerajɨ gamɨnyawɨnna bɨna yeva wɨdɨna “Dazanna yɨvanɨgɨnya be dɨragɨnyaꞌ maaragɨna yɨvanɨgɨnyaigɨnaka? Nabaai dɨragɨnya dazaꞌ aaihwai gɨzaawakavaka?” ");
INSERT INTO byr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sara wɨdɨna kyeꞌ Jizaazai jaꞌnawɨdɨna “Nɨmɨ kwainyɨjɨ pɨrɨꞌna yɨhiwaaravɨdeꞌnanyɨ. Nɨmɨre yɨwaarata saꞌ nyɨrɨvɨkɨpɨjaꞌ nɨmɨ kwainyɨjɨ be dɨragɨnyaꞌ maarena daza yɨvanɨgeꞌna yɨhɨthɨdeinyɨ. ");
INSERT INTO byr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jonɨmɨre bavɨtaazɨyabwi gawɨ yɨmaꞌnakavaka? Sabwi Sɨgunyavɨdaasaꞌ daaka? Aꞌmweraavɨrennanyaꞌ daaka?” Sara wɨdɨna kyaꞌ sahwara yagaala dɨnyɨna “Nemɨ ‘Sabwi Sɨgunyavɨyasɨra,’ wɨdaazaꞌ sai dara wɨdɨna ‘Nabaai nɨmɨnyɨne sahɨrɨꞌna dɨragɨnna beꞌna malɨmwagiwaꞌdaaꞌ?’ ");
INSERT INTO byr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kɨrɨꞌ yawɨꞌdaanyavɨdaaꞌnyɨ ‘Sabwi aꞌmweraavɨresɨ,’ wɨdaazaꞌ sarevɨ yuyara dara yawɨꞌna ‘Jonɨ sai pɨropetɨyalyɨra.’ Yawɨꞌna yadɨvɨsaꞌna ‘Naneramakɨpɨdɨka!’ yawɨꞌdaa lɨka yaanneinera.” ");
INSERT INTO byr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Miꞌna dɨnyɨna yeva sarevɨdaaꞌnyɨ sahwara Jizaazarɨ jaꞌnawɨdɨna “Nemɨ myawɨrivanɨgona.” Jaꞌnawɨdɨna kyeꞌ dara wɨdɨna “Nɨmɨ kwainyɨjɨ ‘Be dɨragɨnyaꞌ maarena daza yɨvanɨgevɨna,’ myɨhɨthɨwɨneinyɨra. ");
INSERT INTO byr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nabaai sarɨmɨ gara yawɨꞌmanɨgaꞌ? Aꞌmwe pwai kaimɨraaya pwaraai kɨnɨnnakei. Gamɨre sɨraangeryawɨnna wɨna yaka wɨdɨna ‘Kaimɨraayaigɨ, dahaasagaaꞌ gɨraipɨwiwawɨnyavɨ jaawa!’ ");
INSERT INTO byr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kɨrɨꞌ sai jaꞌnawɨdɨna ‘Aala! Myɨwɨna!’ Sara wɨdɨna yaka dɨvidaaꞌnyɨ sɨmunya ayahi yawɨraka kaanna wɨna, wawɨnya yɨna. ");
INSERT INTO byr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nabaai ganɨmaangei kaimɨraaya pwaryawɨnna wɨna yaka avaaina sasara wɨdaawɨna kyaꞌ sai jaꞌnawɨdɨna ‘Yo, nɨmwai naangeigɨ nɨmɨ yɨdeinyɨ.’ Sara wɨdaka sai mwɨyɨna. ");
INSERT INTO byr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kaimɨraaya pwaraala saraarɨdaaꞌnyɨ ganɨmaangere sɨmunyabwi mɨdɨnakei aaihwalaka?” Sara yɨwaaraꞌna kyaꞌ sahwara wɨdɨna “Aaya mudɨkei.” Wɨdɨna kyeꞌ Jizaazai dara wɨdɨna “Sarɨmɨnyɨ nebulyaꞌna yɨhɨthɨvanɨge. Aꞌmwe kayaaꞌnanya taakɨzɨya maaꞌdɨvɨsarajɨ yaasɨwaꞌna maradaakudɨvɨsajɨ sa sarɨmɨnyɨ wavɨlaꞌna yeva Gotɨyai maremwaaidevɨ sɨnnawɨ waamanɨgasangɨ. ");
INSERT INTO byr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sareꞌ dareꞌnesɨ. Sarɨmɨnyawɨnna Jonɨ tewaanya yɨdasabwi yɨhibwarɨdaakwiaꞌnei bɨna kyaꞌ sarɨmɨ aꞌmwe naangeihi gamɨre yagaalyaꞌ dɨragɨnna lɨmwagetaihi mɨꞌ. Kɨrɨꞌ taakɨzɨya maaꞌdɨvɨsarajɨ yaasɨwaꞌna maradaakudɨvɨsajɨ gamɨre yagaalyaꞌ dɨragɨnna lɨmwanna yesare. Sarevɨ tɨnna mena wanganeva kɨrɨꞌ sarɨmɨre sɨmunyabwi mudɨkebwi myawɨramaari yeva dɨragɨnna malɨmwagyesaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Keꞌbaꞌnanya pɨrɨꞌ kadɨka duꞌnyɨla! Aꞌmwei kwaaka naanga kɨnɨnnakei mwaalaꞌ. Sahwai gɨraipɨwiwawɨnyaꞌ yɨna. Kurɨta yagɨꞌmawakɨna yaka gɨraipɨwɨlyabara dapalaburɨnna yaka wawɨnyavɨ kusɨlaa sɨlaanga gɨraipɨya mwaꞌmwagikyaꞌne lɨkayavɨkarina yaka anga maremwaalyarɨne puꞌ yɨlamanna. Sai wawɨnya sajɨꞌna aꞌmwera wawɨnya yadɨvɨsaraavɨ wɨdɨna ‘Nɨmɨre wiwawɨnyaꞌ maarapɨjɨ nayaa maremwaalapɨjɨ dɨvi wizɨla mya kyojɨ wizɨla nɨmɨnyɨne wakapɨjɨ sarɨmɨnyɨne dɨmaaryideihɨlyɨ.’ Sara wɨdɨna, pɨwɨnna wɨna. ");
INSERT INTO byr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pɨwɨnna wɨna kyaꞌ dɨvidaaꞌnyɨ gɨraipɨwɨlyabaraavɨ sɨlya mariꞌbwarakyagaaꞌ gamɨnne wizɨla pɨnɨ maaryaꞌneraavɨ wɨdaayadɨvɨsaraavɨ wɨdaasɨna. ");
INSERT INTO byr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Sara wɨdaasɨna kyaꞌ wawɨnya savɨ yadɨvɨsara gamɨre wɨdaayadɨvɨsaraavɨ mujaayeva galalɨmwanna. Yɨ pwarɨ wɨlyabaalyɨ mararanna, yɨ pwarɨ yɨnahu tamakɨna, nabaai pwarɨ sɨlyajɨ lɨvaranna. ");
INSERT INTO byr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sara yɨna kyeꞌ gyakwai gannya wɨdaayadɨvɨta pwaraavɨ ayahi maryasaabɨna. Kwalaalya kɨbaweraavɨ maryaasɨna, kɨgaaꞌ maryaasaka sarabɨꞌna mɨꞌ. Maryasaabɨna kyaꞌ wawɨnya savɨ yadɨvɨsara avaala sasare sabwi kayaaꞌna yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nabaai dɨvidaaꞌnyɨ aayagaaꞌ wawɨnya savɨ gyakwai dara yawɨꞌna ‘Nyɨbwaalɨvaangerɨ sahwara dɨnɨpɨꞌderera “Gawaalɨꞌ naangelyɨra.” Sara dɨnyɨna nayaa yɨpɨꞌderera.’ Gyakwai sara yawɨꞌna yaka gannya gawaalɨvaangerɨ maryaasɨna. ");
INSERT INTO byr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Maryaasɨna kyaꞌ kɨrɨꞌ sahwai kuna kaanna wɨna yadaaꞌnyɨ wawɨnya savɨ yadɨvɨsara gawaalɨvaangerɨ tɨnna wanganna yɨna yeva kumɨ sara dara dɨna ‘Aꞌmwe dathai ganɨmaangere yuya maaradelyɨra. Yarala! Nemɨ yarai tamakaana! Sara yawaajɨ gamɨre wawɨnya dava daꞌ maraadeinera.’ ");
INSERT INTO byr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sarevɨdaaꞌnyɨ sahwara sarɨ galalɨmwanna yeva wawɨnyavɨ mwasɨlaanna maraasɨna yɨna yeva sarɨ yɨnahu tamakɨna. ");
INSERT INTO byr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Sara tamakɨna yesavɨdaaꞌnyɨ wiwawɨnyavɨ gyakwalaangei bozɨ aꞌmwe wawɨnyavɨ yɨvanɨgata dazaraavɨ gathaꞌdarebwi byathei dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Sara wɨdɨna kyaꞌ aꞌmwe naangera wɨdɨna “Aꞌmwe kayaaꞌnanya dazaraavɨ wana kayaaka wigalakaderera. Sara yɨgalakojɨ sai gɨraipɨwiwawɨnyaꞌ aꞌmwe pwaraavɨ maremwaalyaꞌneraavɨna wɨjaavaderera. Nabaai tɨka munne maaryaꞌnegasa sahwarɨna wizɨla wɨjaavɨpɨꞌdelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jizaazai kumɨnyɨ wɨdɨna “Sarɨmɨ Gotɨyare bukuyavɨ yɨdaꞌnɨka dazaꞌ madanganyadɨvɨꞌ daaka! Saꞌ dara dɨnɨkesɨ. Sɨlaangerɨ sianga madɨvɨsara yawɨbwarasɨꞌnesalyɨ. Simɨjamaanga nawɨꞌnyai yɨmaꞌnyɨna yakelyɨ. Naangei sasareꞌ mena yakelyɨ. Tɨnna yawɨranganona ‘Nawɨꞌnyabulyɨ,’ dɨnolyɨ. Nebwina sara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Sarevɨ aꞌmwe naangeihɨrɨ yɨhɨthɨvanɨge. Gotɨyai maremwaaidevɨ sarɨmɨnyɨ yɨhɨmarasɨꞌnojɨ aꞌmwe anga naanga pimagɨnya pwaraavɨna gamɨre maremwaaidevɨ nawɨꞌnyabwina wizɨlyabɨsabwina yɨpɨꞌderaavɨna yanga wɨjaavadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wɨdɨna yaka gamɨ sarɨna wɨdɨna “Nabaai sɨlaangerɨna dɨma! Sɨlaanga dazarɨ aꞌba walarannajai wana kayaaka wɨsɨꞌnadelyɨ. Nabaai sɨlaanga dazai pwai kwarɨ aꞌbadaaꞌnyɨ bwalaramajai sarɨ surɨnya yɨnahu bwalarɨngɨꞌnyɨna yojɨ yɨhusaꞌ tɨrya sa pwaꞌnyɨ makurasɨꞌna yadelyɨ.” Jizaazai pwara malɨmwagyaraavɨna wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Gotɨyarɨna yɨraꞌdɨvɨta naangerajɨ Perɨzɨyarajɨ gamɨre keꞌbaꞌnanyangɨ kadɨka wɨꞌnyɨna yeva dara yawɨresaꞌ “O, nemɨ kwainaavɨna dathɨvanɨka!” ");
INSERT INTO byr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sara deva “Sahwarɨ galalɨmwagaana!” deva kɨrɨꞌ kwala bwaꞌnaanyangɨna lɨka yɨna. Kwala bwaꞌnaanya yawɨꞌna “Jizaazai pɨropetɨyalyɨ.” Sara yawɨꞌna yesaꞌna “Sɨla nalɨwakɨpɨdɨka!” deva navɨka mwaalɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jizaazai kuna wɨdada keꞌbaꞌnanya pɨrɨꞌ dara wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Sɨgunyavɨya maremwaaideꞌ darebaaibɨsasɨ. Aꞌmwe kingɨyai gannya gawaalɨvaangerɨne kwala maarya munne naangeꞌ yɨna. ");
INSERT INTO byr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tɨka wapaaya naanga yovɨrawakɨna yaka sɨnnawɨ aꞌmwe pwaraavɨ tɨka munne nyaꞌneraavɨ yagaala mena wɨdɨthaakwakeraavɨna yagaala wɨdaasɨna. Gamɨre wɨdaayadɨvɨsaraavɨ, jaka wɨjɨvwaramaaryaꞌneraavɨ sahwaraayawɨnna maryaasɨna. Maryaasɨna kyaꞌ wɨdaayadɨvɨsara sara wɨdɨna kyeꞌ sahwara sɨmunyangɨ muvuꞌnyakera ‘Aala! Mabi yɨdeinyɨ,’ dɨna. ");
INSERT INTO byr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","‘Mabi yɨdeinyɨ,’ desavɨdaaꞌnyɨ ganɨmaangei wɨdaayadɨvɨta pwaraavɨ wɨdɨna ‘Aꞌmwe jaka wɨdɨweraayawɨnna wawopɨjɨ dara duzɨla! “Yɨthaanyi, nɨmɨre tɨka munne mena yovɨrawakɨvanɨge. Bulɨmakaawoya naangerajɨ dɨwɨnya mɨnarɨnakerajɨ mena tamapɨraayɨna. Nabaai yuya pɨnɨjɨ mena yovɨrawakɨwo warɨka. Kwala maaryaꞌnegaaꞌ jɨkabila!” ’ ");
INSERT INTO byr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Wɨdaayadɨvɨsara yagaala dazaꞌ wɨdaawɨna yeꞌ. Kɨrɨꞌ sahwara kadɨka muꞌnyɨna yeva kaanya yɨwɨnamaꞌna. Pwai gannya wawɨnyawɨnna wɨna, pwai mubyaꞌnei gannya sɨtɨwaayavɨna kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sara yɨna kyeꞌ kɨrɨꞌ pwara kingɨyare wɨdaayadɨvɨsaraavɨ galalɨmwanna yɨna yeva bɨrala yɨna, mala tamɨna, yɨnahu tamakɨna. ");
INSERT INTO byr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Sarevɨdaaꞌnyɨ kingɨyarɨ sɨnna tɨka davɨna kwiaꞌ gannya aawɨlasaraavɨ maryaasɨna kyaꞌ aawɨlasara wɨdaayadɨvɨsaraavɨ tamaketa saraavɨ tamakyaꞌnera wɨna yeva sara mena yeva sahwaraavɨre anga naangeꞌ dɨka yɨraꞌna. ");
INSERT INTO byr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sara kyeꞌ kingɨyai wɨdaayadɨvɨsaraavɨ wɨdɨna ‘Tɨka munne kwala maaryaꞌne mena yovɨrawakɨwaasa warɨka. Kɨrɨꞌ aꞌmwe nɨmɨ jaka wɨdɨwera sara galazekɨvaimwaasara yɨnɨga wiꞌna yɨpɨꞌdera mɨka. ");
INSERT INTO byr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Sarevɨdaaꞌnyɨ yuya tutaamaanga yalabɨnya yɨkebanya kaanya jamarila! Nabaai aꞌmwe yuyaraavɨ tɨnna wanganapɨjɨ tɨka munnenna jaka duzɨvwaramakabila!’ ");
INSERT INTO byr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Sara wɨdɨna kyaꞌ wɨdaayadɨvɨta dazara tutaanya yuya sabanyana yɨwɨnamaꞌna yɨna yeva aꞌmwe yuyaraavɨ mariꞌbwaꞌna. Aꞌmwe kayaaꞌnanyarajɨ aꞌmwe tewaanyarajɨ mariꞌbwaꞌna. Mudɨkanga saba bamwaaina yeva yunebanna mɨlalɨmwagaꞌna. ");
INSERT INTO byr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Aꞌmwera walamwaaina yadaapi kingɨyai tɨnna wanganyaꞌnei wɨlaabɨna. Wɨlaabɨna yaka aꞌmwe pwarɨ kwala maaryaꞌne baazɨꞌmaꞌnyaꞌ nawɨꞌnyaꞌ mamarakyakerɨ tɨnna wanganna. ");
INSERT INTO byr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tɨnna wanganna yaka wɨdɨna ‘Aꞌmweigɨ, kwala maaryaꞌne baazɨꞌmaꞌnya mamarakyagɨna kuta dawɨnna gathaꞌdara bwimwaanyaigɨnaka?’ Sara wɨdɨna kyaꞌ kɨrɨꞌ sai yagaala maayai. ");
INSERT INTO byr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sarevɨdaaꞌnyɨ kingɨyai wɨdaayadɨvɨsaraavɨ dara wɨdɨna ‘Sarɨmɨ gamɨre sɨvɨla asangɨ wɨla galapwɨyapɨjɨ mwasɨlaa jɨhɨnyavɨ mwaaladeꞌna dɨmaralɨvaramila! Jɨhɨnya dazavɨ aꞌmwera kɨnna dadɨvɨꞌ kunnya maangerɨka kɨjɨvainadɨvɨsarera.’” ");
INSERT INTO byr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sareꞌ dareꞌnesɨ. Keꞌbaꞌna sara wɨdɨna yaka wɨdɨna “Yo, Gotɨyai aꞌmwe kwalaalyaraavɨ jaka wɨdadelyɨra. Kɨrɨꞌ sai gave pwaraavɨna pwaraavɨna dahɨlakadelyɨ. Aꞌmwe kwalaalyara kadɨka muꞌnyɨ yadɨvɨꞌ gamɨnyawɨnna mabyadɨvɨsare.” ");
INSERT INTO byr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Perɨzɨyara Jizaazarɨna yagaalyaꞌ daawɨna “Sarɨ wɨla galapwɨyaꞌnevɨ nemɨ yagaalyaꞌ gara jamungajakaajɨwona? Sai yagaala kayaaꞌnanyaꞌ kudozɨ yaawiai naanyavɨ lɨvapadevaaibɨꞌ pwɨyaana!” ");
INSERT INTO byr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dɨnyɨna yeva jamungajakɨna yeva kumɨre mɨdɨdɨvɨsaraavɨjɨ Kingɨya maalɨkei Erotɨyare kwaraavɨjɨ wɨdaasɨna kyeꞌ Jizaazaryawɨnna yɨꞌmavaawɨna yɨna yeva “Kwaasɨyagaala kudawaajɨ sai navɨka mwaalojɨ yaasɨwaꞌna kanedozɨ wɨla yɨraana!” deva wɨdɨna “Wɨjɨwaakyaigɨ, nemɨ yawɨꞌmanɨgo ‘Gɨmɨ aꞌmwe yɨdaꞌmaraangeigɨnyɨra. Nabaai yagaala yune nebulyaꞌnanyavɨ Gotɨyarebwi wɨjɨwaakadɨnyaigɨnyɨra. Gɨmɨ aꞌmwe pwarɨna sɨmunya kwalaalya yawɨꞌdɨnyaigɨ mɨka. Aawa. Aꞌmwe yuyaraavɨ yagaala avaainanya wɨjɨwaakadɨnyaigɨnyɨra.’ ");
INSERT INTO byr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sarevɨdaaꞌnyɨ dɨnedana! Gɨmɨ gara yawɨꞌmanɨgɨna? Yunebanne Kingɨyai Sizaarɨ taakɨzɨya wɨjaayaꞌnebwi tewaanyabwi dɨngaka? Gotɨyai ‘Kayaaꞌnanyabulyɨ,’ yawɨꞌdei dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kɨrɨꞌ Jizaazai kumɨre sɨmunya kayaaꞌnanya sabwi yawɨranganna yaka wɨdɨna “Kwaasɨyaihi, yaamɨjɨ beꞌna nyɨjɨwaaimanɨgava! ");
INSERT INTO byr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Taakɨzɨya wakyaꞌne nɨgwia puꞌ dɨnyɨbwarɨdaakwila!” Wɨdɨna kyaꞌ sahwaryawɨnna nɨgwia sɨꞌ makabɨna. ");
INSERT INTO byr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nɨgwia sɨꞌ makabɨna kyeꞌ sai sɨkɨna yɨdaanganna “Aꞌmabaala dathasɨ yaya dathasɨ saꞌ aarɨnevaka?” ");
INSERT INTO byr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yɨdaanganna kyaꞌ wɨdɨna “Sizaarɨnesɨra.” Wɨdɨna kyeꞌ wɨdɨna “Sareꞌna Sizaarɨne sa Sizaarɨna durɨvɨkɨryidengɨra. Nabaai Gotɨyare sa Gotɨyarɨna durɨvɨkɨryidengɨra.” ");
INSERT INTO byr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yagaala saꞌ kadɨka wɨꞌneva lɨka yɨwaainyɨna. Lɨka yɨwaainyɨna yadɨvɨꞌ sarɨ yagalyaꞌmaꞌna yɨna yeva kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Yɨrɨka dazarɨkɨ Sazuzɨyara gamɨnyawɨnna bɨna. Sazuzɨyara dara dadɨvɨsare “Aꞌmwera balɨna yadɨvɨꞌ ayɨna dɨkaapɨꞌdera mɨka. Aawa. Yɨnahu baidɨvɨsarera.” Gamɨnyawɨnna bɨna yeva dara yɨwaaraꞌna ");
INSERT INTO byr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Wɨjɨwaakyaigɨ, Ne Mozɨzai kɨwɨnya dara dɨnɨkesɨ. Aꞌmwe pwai kaimɨraavɨmaayai kabalojɨ gahwaalaangei gamɨre aꞌmwevɨ kwala maarojɨ gathaakaanga baryarɨne kaimɨraaya yɨmavɨdaakuna yana! ");
INSERT INTO byr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sara dɨnɨkeꞌna kɨgaaꞌ ata purɨdaaꞌnyɨ pwaraala kɨdaraka nemɨjɨyadaraka mwaalesare. Nabaai aaya mudɨkei kwala maaraka mwaalakegaaꞌ mena balɨna. Sai kaimɨraaya maayai balakevɨdaaꞌnyɨ gamɨre aꞌmwe dazavɨ gahwaalaangei kwala maarɨna yaka nabaai sahwalyɨ kaimɨraaya maayai balɨna. ");
INSERT INTO byr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nabaai ayahidaaꞌnyai avaala sana yɨna, nabaai ayawɨdaasalyɨ. Sana sana yɨwɨna yeva aaya wɨryaakei yune ata purɨdaaꞌnyɨ pwaraala sai avaaina yɨna. ");
INSERT INTO byr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yuyara mena balɨna kyeꞌ aaya dɨvidaaꞌnyɨ aꞌmwe kɨrɨsɨ balɨna. ");
INSERT INTO byr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Sarevɨdaaꞌnyɨ aꞌmwe bainɨkera ayɨna dɨkaasagaaꞌ aꞌmwe dazaꞌ ata purɨdaaꞌnyɨ pwaraala saraavɨ aꞌmwe aaihwareꞌ mwaaladevaka? Sareꞌ dareꞌnesɨ. Yuyara kwala maaresaꞌna aaihwareꞌ mwaaladevaka?” ");
INSERT INTO byr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jizaazai jaꞌnawɨdɨna “Gotɨyare yagaala dɨnɨkengɨjɨ Gotɨyare dɨragɨnya kɨrɨvɨnajɨ myawɨrivanɨgata sarevɨdaaꞌnyɨ nayaa myawɨryadɨvɨꞌ dɨwaasaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sareꞌ dareꞌnesɨ. Aꞌmwe bainɨkera ayɨna dɨkaasagaaꞌ aꞌmwera kwala ayahi mamaaryɨ yɨpɨꞌderera. Nabaai aꞌmwe kwala ayahi mamaaꞌnyɨ yɨpɨꞌdengɨra. Aawa. Sɨgunyavɨ ejelɨyara kwala mamaaryarabɨsara mwaaibɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nabaai bainɨka sara ayɨna dɨkaasaꞌna Gotɨyai sarɨmɨre Ne sɨnnyawɨnyaraavɨ yɨhɨzaake yagaalyaꞌ madanganyadɨvɨsaihi daaka! Gotɨyai Ne Mozɨzarɨ wɨjaakeꞌ dara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Dahaaꞌ kuna nɨmɨ Evɨraamɨmɨre Gotɨyainyɨra. Aazakɨmɨre Gotɨyainyɨra. Jaikopɨmɨre Gotɨyainyɨra. Sara dɨnɨkeꞌna sahwai aꞌmwe bainɨkeraavɨre Gotɨyai mɨka. Aawa. Gamɨre bainɨkeraavɨ kuna maremwaaidelyɨ. Gamɨnyɨne aꞌmwe gaala mwaaihasaraavɨre Gotɨyalyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Gamɨre yagaala saꞌ kwala bwaꞌnaanya kadɨka wɨꞌneva lɨka yɨwainɨgulaawɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Perɨzɨyara dara wɨꞌnesaꞌ “Yɨthaanyi, Sazuzɨyaraavɨ kumɨre yagaalyangɨ maange galabɨpaimwakei daaka!” Sara deva gamɨnyawɨnna yɨꞌbwaꞌnaabɨna. ");
INSERT INTO byr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yɨꞌbwaꞌnaabɨna yeva kumɨjɨya pwai kɨwɨnya sɨduꞌnakei “Yɨwetawakya dana!” daka yɨjɨwaalyaꞌna yɨwaaraꞌna ");
INSERT INTO byr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Wɨjɨwaakyaigɨ, kɨwɨnya yuyangɨ wavɨlavaka naanga wavɨlavɨkeꞌ kɨwɨnya berɨvaka?” ");
INSERT INTO byr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yɨwaaraꞌna kyaꞌ wɨdɨna “Gɨmɨre Naangei Gotɨyarɨna gɨnnya sɨmunyavɨ yunebanna tewaanya gɨvuꞌnana! Gɨnnya kuryai sahwarɨ yɨlaaya yɨnɨga wiꞌna wɨmaryana! Gɨnnya sɨdusavɨ yunebanna sahwarɨ jawɨrangana! Gɨnnya sɨmunyavɨ yunebanna, gɨnnya kuryarɨ yunebanna, gɨnnya sɨdusavɨ yunebanna gɨmɨre Naangei Gotɨyarɨna tewaanya gɨvuꞌnana! ");
INSERT INTO byr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kɨwɨnya dazaꞌ naangesɨ. Saꞌ gamɨ wana naanga nebulyasɨ. ");
INSERT INTO byr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nabaai ayawɨdaasaꞌ dazahɨrɨꞌ saꞌbɨsasɨ. Saꞌ daresɨ. Gɨmɨnyɨna kale gyadevaaibɨꞌ aꞌmwe pwaraavɨna kale tewaanya gyana! ");
INSERT INTO byr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kɨwɨnya pɨrɨwaala dazawaai kɨwɨnyangɨne yagaala yuya kaavɨlyawaai, nabaai Gotɨyarɨ wɨꞌneva wɨjaata pɨropetɨyaraavɨre yagaala kaavɨlyawaalyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Perɨzɨyara kuna yɨꞌbwaꞌnemwaaidapi Jizaazai kumɨnyɨ yɨdaanganna ");
INSERT INTO byr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Sarɨmɨ Kɨraazɨtɨyarɨna Gotɨyai maryasaabyarɨna gara yawɨꞌmanɨgava? Sai kaimɨraaya aaihwarelaka?” Yɨdaanganna kyaꞌ sahwara wɨdɨna “Ne Devitɨmɨre Kaimɨraayalyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Wɨdɨna kyeꞌ wɨdɨna “Nabaai Kurya Tewaanyai Devitɨmɨ sɨmunya kujayaaꞌ Devitɨ gathaꞌdareꞌ wɨdɨna ‘Naangeigɨ!’ Dara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Naangei nɨmɨre Naangerɨ dara wɨdaꞌ ‘Gɨmɨ nɨmɨre aangasɨmagɨ dɨragɨnyaba dɨmwaala! Nabaai dɨvidaaꞌnyɨ gɨmɨre yɨkamaangeraavɨ dathɨwagɨdeinyɨ. Gɨmɨre sɨvɨlyɨraarɨ amwi dathɨwagɨderaavɨ marulawakɨdehaaꞌnanyɨ.’ ");
INSERT INTO byr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Sara dɨnɨkeꞌna yɨ Devitɨ wɨdakei ‘Naangeigɨna,’ sahwai ‘Devitɨmɨre kaimɨraayalyɨreva,’ gathaꞌdarevaka?” ");
INSERT INTO byr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Sara wɨdɨna kyaꞌ gamɨre yagaala saꞌ yɨnɨga wiꞌna jaꞌnawɨdakei aꞌmwe pwai kwai mɨꞌ. Sahwara dara myawɨryesaꞌ “O, Kɨraazɨtɨyai Gotɨyare Gawaalɨvaangei daaka!” Majeva nabaai yɨrɨka dazarɨkɨ yɨdaanganyaꞌnenna lɨka gaai yeꞌ. Nabaai dɨvidaaꞌnyɨ majaꞌnawɨjɨ yɨpɨnera pɨnɨnna midaanganyɨ yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Dɨvidaaꞌnyɨ Jizaazai kwala bwaꞌnaanyangɨjɨ gamɨre mɨdɨdɨvɨsaraavɨjɨ wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Kɨgaakuna Ne Mozɨzai Kɨwɨnyaꞌ nejaavaka nemɨre sɨnnawɨnyaraavɨ wɨjɨwaakɨna neyaakelyɨ. Dahaaꞌ Mozɨzai yaakabaaibɨꞌ Kɨwɨjarajɨ Perɨzɨyarajɨ Mozɨzare namwaalyɨsavɨ Kɨwɨnya yɨhɨzɨwaakɨvanɨgasarera. ");
INSERT INTO byr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Sarevɨdaaꞌnyɨ Gotɨyare bukuyavɨne yagaala yuya sa yɨhɨzɨwaakɨvanɨgasa kadɨka nayaa wɨꞌnadɨvɨꞌ sana sana dɨmɨdɨnyɨla! Kɨrɨꞌ kumɨre yadɨvɨta sabwi sarɨmɨ mamɨdɨbɨnera! Sareꞌ dareꞌnesɨ. Sahwara kɨwɨnyanna dadɨvɨsa kɨrɨꞌ sabwi myadɨvɨsarera. ");
INSERT INTO byr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Aꞌmwera gɨlyɨvɨta ge ge wɨla maramurɨtaveva pwaraavɨre egwengɨ yɨlakeva ‘Sahwara taanga yuya sa makupɨka! Kɨrɨꞌ taanga sa nemɨre ata maalɨka kɨmɨlɨka mamakwawaanna!’ yawɨꞌna yeva yɨvanɨgatabaaibɨꞌ Kɨwɨjarajɨ Perɨzɨyarajɨ taanginya kɨwɨnya taanginanya wɨjaavɨna yadɨvɨꞌ sazaburana myadɨvɨsarera. ");
INSERT INTO byr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yuyangɨ yadɨvɨsanna yawɨꞌna ‘Aꞌmwera nenganapɨjɨ “Aꞌmwe sahwai tewaanyalyɨ,” yawɨrapɨjɨ nemɨre yaya munyaba makibɨka!’ Sara yawɨꞌna yadɨvɨꞌ yuya yadɨvɨsare. Kumɨrebwi dareꞌnebulyɨ. Nemɨ Juyainaavɨrebwina kumɨre gɨlyɨka Gotɨyare yagaala pɨkarɨyɨkwia maalɨka mihyaꞌnikaavɨ naanga yavɨkaryadɨvɨꞌ aꞌmwera tɨnna wanganyaꞌnera yamengɨjɨ asangɨjɨ marapwɨyadɨvɨsare. Gotɨyarɨ wɨjaꞌnegaaꞌne baazɨꞌmaꞌnyangɨ maangebara saamɨnaangebara yavɨkaryadɨvɨꞌ aꞌmwera tɨnna wanganyaꞌneꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tɨka munnengɨ namwaalyɨta aaya naangengɨ walamwaalyaꞌnera nawɨꞌnya wimaꞌnaderera. Nabaai lotuangengɨ walamwaala yaꞌne aaya kekyɨrɨꞌna ‘Aꞌmwe naangeinyɨ sahɨba mwaalɨma!’ yawɨꞌdɨvɨꞌ nawɨꞌnya wimaꞌnaderera. ");
INSERT INTO byr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aꞌmweraayaba yɨkabadɨvɨsaba ‘Aꞌmwera nedɨpɨka! “Aꞌmwe naangeigɨ! Tewaanyaigɨ!” Nabaai aꞌmwera nedɨpɨka! “Wɨjɨwaakyaigɨ!” Sazabwi tewaanya wɨvuꞌnaderera. ");
INSERT INTO byr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kɨrɨꞌ nɨmɨreihɨrɨna aꞌmwera ‘Ravaai, Wɨjɨwaakyaigɨ!’ nyɨhɨthɨpɨdɨka! Sareꞌ dareꞌnanyɨ. Sarɨmɨre wɨjɨwaakya yune gave pwainanyainyɨ mwaaiheinyɨ. Sarɨmɨ yuyaihi kwɨyaꞌmweihɨlyɨ. (Avaalyaihɨlyɨ.) ");
INSERT INTO byr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nabaai Kwaaka davakɨ dava aꞌmwe pwarɨ ‘Nenɨmaangeigɨ!’ madɨpɨna! Sareꞌ dareꞌnanyɨ. Sarɨmɨre sɨrɨnɨmaangei yune gave pwainanyalyɨ. Sahwai Sɨgunyavɨ mwaalɨkelyɨ. Sareꞌna aꞌmweraavɨ ‘Nenɨmaangeigɨ!’ madɨpɨna! ");
INSERT INTO byr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nabaai aꞌmwera ‘Nemaremwaaidɨnyaigɨ!’ nyɨhɨthɨpɨka! Sareꞌ dareꞌnanyɨ. Sarɨmɨre maremwaalyai yune gave pwainanyalyɨ. Sahwarɨ Gotɨyai dahɨlakaka maryasaabakei Kɨraazɨtɨyalyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sarɨmɨjɨya pwai ‘Aꞌmwe naangeinyɨ yɨmaꞌnɨma!’ dazai wawɨnya yɨhɨthaayadei sarɨmɨre yagaala mɨdɨdei mwaaladelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aꞌmwei yaya yune gamɨnneꞌna makinajai gamɨnne yayaꞌ kwaakewɨ waradesɨ. Nabaai aꞌmwei gamɨnne yayaꞌ kwaakewɨ kamarakwojɨ yaya naangeꞌ maaradelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Weꞌ! Kɨwɨjaihɨlyɨ Perɨzɨyaihɨlyɨ saihi maanga pɨrɨwaalyɨyaihi mala nayaa jɨwannyɨla! Sɨgunyavɨya maremwaaide kaadihɨsaꞌ aꞌmweraavɨre sɨnnyɨkaavɨ maratihɨꞌdɨvɨsaihɨlyɨ. Sareꞌ dareꞌnesɨ. Sarɨmɨ kusawɨ widɨvɨtaihi mɨka. Nabaai aꞌmwera ‘Maremwaaidevɨ kusawɨ wɨlaana!’ dadɨvɨꞌ yadaapi sarɨmɨ tusavɨ kaanya wɨridɨvɨsaihɨlyɨ. Sareꞌna mala nayaa jɨwannyɨla! ");
INSERT INTO byr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Weꞌ! Kɨwɨjaihɨlyɨ Perɨzɨyaihɨlyɨ saihi maanga pɨrɨwaalyɨyaihi mala nayaa jɨwannyɨla! Yaanyɨwaakemɨlɨkaavɨne angengɨna kwaasɨ dadɨvɨꞌ angengɨya yaasɨwaꞌna maaꞌdɨvɨꞌ sahɨmɨlɨka yune kunemɨlɨka wɨmwaaihadɨvɨsaihɨlyɨ. Sareihi sarɨmɨre kayaaꞌnanya dazangɨ lɨka yulyakyaꞌneihi Gotɨyarɨ yagaala saamɨnya kwaasɨ wɨdadɨvɨsaihɨlyɨ. Sarevɨdaaꞌnyɨ kayaaꞌnanya sahɨbwina tɨvɨkɨryaꞌne naanga dɨmaaryideihɨlyɨ. Pwara tɨvɨkɨryaꞌne maalɨka maapɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Weꞌ! Kɨwɨjaihɨlyɨ Perɨzɨyaihɨlyɨ saihi maanga pɨrɨwaalyɨyaihi mala nayaa jɨwannyɨla! Saalaalyavɨjɨ kwaakevakɨjɨ wavɨlaꞌna yadɨvɨꞌ ‘Aꞌmwe pwai nemɨre kɨwɨnya mɨdɨnana!’ yawɨꞌdɨvɨꞌ bɨrɨkaanya yamaryadɨvɨsaihɨlyɨ. Miꞌna bɨramaaꞌna yadɨvɨꞌ sahwai yɨhɨmɨdɨdaasɨ Dɨkevɨ naawiaꞌnerɨ wɨmwaaihadɨvɨsaihɨlyɨ. Nabaai gamɨre kayaaꞌnanyabwi sarɨmɨre kayaaꞌnanyabwi wavɨlaꞌna yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Weꞌ! Tɨnna tɨbɨnyaihi ‘Tusarɨꞌ wibwarɨdakwaana!’ dadɨvɨsaihi mala nayaa jɨwannyɨla! Dara kwaasɨ dadɨvɨsaihɨlyɨra. Gazaizai Gotɨyare Angevɨna dozɨ gamɨre yagaalyaꞌ dɨragɨnna yɨvaimwagazai nabaai sara mi yajaꞌ saꞌ yaasɨwaꞌnanyasɨra. Kɨrɨꞌ gazaizai Gotɨyare Angevɨne golɨyanna dozɨ gamɨre yagaalyaꞌ dɨragɨnna yɨvaimwagazai nabaai gamɨ dazabaaibɨꞌ sana yɨna yadelyɨra. ");
INSERT INTO byr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tɨnna tɨbɨnyara tusarɨꞌ mwanganyadɨvɨtabaaibɨꞌ sɨduꞌmaayaihi mwaaihasaihɨlyɨ. Dɨnyɨjɨla! Golɨya naangeꞌ daaka? Gotɨyare Angeꞌ golɨya tewaanyaꞌ wakake anga saꞌ naangeꞌ daaka? Yɨ Gotɨyare Angeꞌ naangesɨ. Golɨyavɨ wavɨlaꞌnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nabaai kwaasɨ dara dadɨvɨsaihɨlyɨ. Gazaizai yagaala dɨragɨnyaꞌ jaꞌnei Gotɨyarɨne sipɨzipɨya sazangɨne kwaraanyabanna (taangejɨ marewɨjaꞌnebanna) dozɨ dɨragɨnya saꞌ dazai saꞌ yaasɨwaꞌnanyasɨ. Kɨrɨꞌ kwaraanyaba Gotɨyarɨ wɨjaayaꞌne sipɨzipɨya sazangɨna dozɨ yagaala dɨragɨnya saꞌ dazai nabaai gamɨ dazabaaina sana yɨna yadelyɨ. Sana myɨ yojɨ yagaainakei yɨmaꞌnadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tɨnna tɨbɨnyaihɨlyɨra. Sareꞌ dareꞌnesɨ. Sipɨzipɨya saza naange dɨngaka? Kwaraanyaꞌ sipɨzipɨya sazangɨ tewaanya yɨmaꞌnade kwaraanya saꞌ naangeꞌ dɨngaka? Kwaraanya saꞌ naangesɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sarevɨdaaꞌnyɨ aꞌmwei kwaraanyaꞌna dozɨ yagaala dɨragɨnyaꞌ dazai kwaraanyabannajɨ kwaraanyabanne sipɨzipɨya saza yuyangɨnajɨ yagaala dɨragɨnyaꞌ dathelyɨra. ");
INSERT INTO byr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nabaai pwai Gotɨyare Angevɨna dozɨ yagaala dɨragɨnyaꞌ dazai yɨ Gotɨyare Angevɨnajɨ Gotɨyare Angevɨ mwaalɨkerɨnajɨ yagaala dɨragɨnyaꞌ dathelyɨra. ");
INSERT INTO byr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nabaai pwai Sɨgunyavɨna dozɨ yagaala dɨragɨnyaꞌ dazai Gotɨyare namwaalyɨsarɨnajɨ namwaalyɨsarɨ yɨlamwaalɨka dazarɨnajɨ yagaala dɨragɨnyaꞌ dathelyɨra. (Matɨyui 5:33-37) ");
INSERT INTO byr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Weꞌ! Kɨwɨjaihɨlyɨ Perɨzɨyaihɨlyɨ maanga pɨrɨwaalyɨyaihi mala nayaa jɨwannyɨla! Sareꞌ dareꞌnanyɨ. Wawɨnyavɨya maalɨka yuya jɨsaꞌbɨsasɨ yɨmaasaꞌbɨsasɨ saza yuya sarɨmɨ ata yuyɨraai marajaapaidɨvɨꞌ ata yuyɨraalya pimagɨnya yɨlaayaꞌna Gotɨyarɨ duzaayidengɨ. Kɨrɨꞌ sarɨmɨ Kɨwɨnyavɨya yagaala naanga pimagɨnya yagalyaꞌmaꞌmwaaꞌ. Yɨ aꞌmweraavɨ maryawɨbwata yaꞌne yagaala yɨdaꞌmaraangebwi myɨvanɨgaꞌ. Yɨ kale gaimwangeꞌnebwi myɨvanɨgaꞌ. Yɨ Gotɨyarɨ nayaa malɨmwagivanɨgaꞌ. Kɨwɨnya Gotɨyarɨne ata yuyɨraalya pimagɨnyaꞌ wɨjaayaꞌnebwi nyagalyaꞌmapɨdɨka! Kɨrɨꞌ Kɨwɨnyavɨya yagaala naanga yɨhɨthɨwe nayaa nebulyaꞌna jɨla! ");
INSERT INTO byr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tɨnna tɨbɨnyaihi ‘Tusarɨꞌ wibwarɨdakwaana!’ kwaasɨ dadɨvɨsaihɨlyɨ. Sarɨmɨre aalyavɨ kavagazerɨ lɨwasɨꞌnadɨvɨꞌ kɨrɨꞌ sarɨmɨre aalyavɨ kaamelɨyarɨ tɨnna mwanganyɨna, yenɨguꞌnadɨvɨtabaaibɨꞌ sarɨmɨ maalɨkebwina nayaa yadɨvɨꞌ kɨrɨꞌ Gotɨyare Kɨwɨnya naanga tɨnna mwanganyɨna, navɨkaꞌna myadɨvɨsaihɨlyɨ. Sareꞌna tɨnna tɨbɨnyaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Weꞌ! Kɨwɨjaihɨlyɨ Perɨzɨyaihɨlyɨ maanga pɨrɨwaalyɨyaihi mala nayaa jɨwannyɨla! Aꞌmwera paletɨyangɨjɨ kaapɨyangɨjɨ mwasɨmagɨ gɨrɨka puꞌmaꞌdɨvɨꞌ kɨrɨꞌ kusawɨ gɨrɨka waꞌda aalya wapaaya sɨvya buꞌnɨkabaaibɨꞌ sarɨmɨ aꞌmwera tɨnna wanganyaꞌneraavɨna maalɨkebwina nayaa yadɨvɨꞌ kɨrɨꞌ kusawɨ sarɨmɨre sɨmunyangɨ kuka yɨpalamaasabulyɨ wabahɨlaaka yɨhyada naanna yabulyɨ maanga yɨhyekuꞌnɨkeihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Perɨzɨyaigɨ tɨbɨnyaigɨ ‘Mwasɨmagɨ kimagɨjɨ tewaanya yɨmaꞌnana!’ daꞌgɨzɨ sɨnnawɨ kaapɨvananyarɨ kusawɨ yuneꞌna dɨvuꞌmawasɨꞌnadesɨ. Kusɨmagɨ naangimagɨnyɨ. Mwasɨmagɨ maalɨkimagɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Weꞌ! Kɨwɨjaihɨlyɨ Perɨzɨyaihɨlyɨ maanga pɨrɨwaalyɨyaihi mala nayaa jɨwannyɨla! Sarɨmɨ gɨlekaviꞌnɨnnyangɨ yaakesɨ puꞌnɨkeibɨsaꞌnanyɨ. Mwasɨmagɨ tɨnna wanganyaꞌnyɨmagɨ nawɨꞌnyɨmagɨnyɨ. Kɨrɨꞌ kusawɨ aꞌmwe mena bainɨkeraavɨre yagɨnyajɨ bwia yuyajɨ gɨrɨkitaꞌnanyajɨ yunebanna wɨlayɨhihunarɨꞌ. Sasarebɨsaihi mala nayaa jɨwannyɨla! ");
INSERT INTO byr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sabaaibɨꞌ sarɨmɨ kwaihi kwaasɨ yadɨvɨꞌ aꞌmwera tɨnna yɨhwangadɨvɨꞌ ‘Aꞌmwe tewaanyarera,’ yawɨꞌdɨvɨꞌ kɨrɨꞌ sarɨmɨnyɨ kusawɨ kwaasɨyabulyɨ Kɨwɨnyavɨ galazekɨvalyabulyɨ wɨlayɨhwarɨkeihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Weꞌ! Kɨwɨjaihɨlyɨ Perɨzɨyaihɨlyɨ maanga pɨrɨwaalyɨyaihi mala nayaa jɨwannyɨla! Sareꞌ dareꞌnanyɨ. Ne pɨropetɨyaraavɨre gɨlekaviꞌnɨnnyangɨ gɨleange madɨvɨsaihɨlyɨ. Aꞌmwe yɨdaꞌmaraangeraavɨre gɨleangengɨ yɨwaala yɨwadɨvɨsaihɨlyɨra. ");
INSERT INTO byr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yɨwaala yɨwadɨvɨꞌ nabaai dɨna ‘Nemɨre Ne sɨnnawɨnyaraavɨregaaꞌ mwalaajɨ kwajɨ pɨropetɨyaraavɨre taweꞌ munya dayaꞌna magaimwagi kyaadɨꞌ!’ ");
INSERT INTO byr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","‘Nemɨre Ne sɨnnawɨnyara,’ dadɨvɨta sarevɨdaaꞌnyɨ sarɨmɨ pɨropetɨyaraavɨ tamaketa saraavɨreihi mwaaihasaꞌ jalɨkurakɨmanɨgaꞌ. Gotɨyare yagaalyaꞌ mamaarivanɨgasaꞌna avaaina yadɨvɨsaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sareihi, yarala! Sarɨmɨre Ne sɨnnawɨnyaraavɨrebwi yunebanna jaawila! ");
INSERT INTO byr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kamaala kayaaꞌnanyaihi! Naawɨnaanyaraavɨre kaimɨraayaihi sarɨmɨnyɨ Gotɨyai kotɨyaꞌ yɨhɨmaryojɨ Dɨkevɨna yɨhɨmarasɨꞌnadeihɨlyɨ. Lɨkaanya gathaꞌdara dɨwideihɨlaka! ");
INSERT INTO byr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sarevɨ, yɨthaanyi, sarɨmɨnyawɨnna nɨmɨ pɨropetɨya pwaraavɨjɨ aꞌmwe sɨmunnakeraavɨjɨ nɨmɨre Kɨwɨjaraavɨjɨ maryasaabɨdeinyɨ. Kamaryasaabaꞌmujɨ sahwaraavɨ pwaraavɨ dɨramakyideihɨlyɨ. Pwaraavɨ yɨsavɨri nilɨya jeramyideihɨlyɨ. Sarɨmɨre lotuangengɨ pwaraavɨ wɨla kayaaꞌnanyabaalyɨ lɨkurapɨjɨ taanga wɨjaayaꞌneihi anga naanga pɨbanna sara yapɨjɨ anga naanga pɨbanna dɨhaꞌmɨjamakwideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sara kyapɨjɨ Kwaaka davakɨ yɨdaꞌmaraanga yuyaraavɨre taweꞌ munya dayaasavɨne tɨvɨkɨta dɨmaaryideihɨlyɨ. Saꞌ yune sarɨnnyaburɨnyɨ. Sarɨmɨ yɨdaꞌmaraangeraavɨ mena tamakyaasaraavɨ Aivelɨ yɨdaꞌmaraangerɨdaaꞌnyɨ tamakɨna, kuna kuna yeva yune Sekaraayarɨ tamakɨna. Sekaraayai Berakaayare kaimɨraayarɨ Gotɨyare Angevɨjɨ Gotɨyarɨne sipɨzipɨya sazangɨne kwaraanyabajɨ tɨnnyaba sarɨmɨ mena tamakyaasalyɨ. Saꞌ yune sarɨnnyabulyɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nebulyaꞌna yɨhɨthɨvanɨge. Yuya kayaaꞌnanya dazanna aꞌmwe dahaaꞌ mwaaihata dazaihɨrɨ tɨvɨkɨsaꞌ yɨhimaꞌnadesɨ. (Gamɨre yagaalyaꞌ bule wɨjaavesaꞌnajɨ gamɨnyɨ tamakyaꞌnajɨ sara wɨdɨna yaꞌ.) ");
INSERT INTO byr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jeruzaalemɨ mwaalyaihi! Jeruzaalemɨ mwaalyaihi! Sarɨmɨ Ne pɨropetɨyaraavɨ tamakɨna, sarɨmɨnyawɨnna Gotɨyai wɨdaasakeraavɨ sɨla lɨwakɨna yaasaihɨlyɨ. Kukuraayaꞌ gannya bwaranyangɨ jaka jɨvwaramaaꞌda gannya pɨyayawɨ marulakamaremwaaidevaaibɨꞌ sarɨmɨreraavɨ mariꞌbwarɨmwaaihyaꞌneinyɨ gara garegaaꞌ nyɨvuꞌnaka kɨrɨꞌ sarɨmɨnyɨ mihɨvuꞌnyɨvanɨka! Weꞌ! ");
INSERT INTO byr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yɨthaanyi, sarɨmɨre anga davɨ mena yenadakupɨjava yɨmaꞌnadesɨ. ");
INSERT INTO byr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sareꞌ dareꞌnesɨ. Dara yɨhɨthɨvanɨge. Ayawɨdaasɨ tɨnna dɨnyanganyideinyɨ mɨka! Arɨkewɨnyɨ. Dɨvi nɨmɨnyɨna dara dɨzidehaaꞌnanyɨ. ‘Naangerɨne yayavɨ aꞌmwei bathelyɨra. Sahwarɨ Gotɨyai tewaanya wiadelyɨra.’ Sara dapɨjɨ dɨnyanganyideihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Gotɨyare Angevɨ Jizaazai yagalyaꞌmaꞌna yaka kaanna wodaaꞌnyɨ gamɨre mɨdɨdɨvɨsara Gotɨyare Angevɨya angengɨ yɨbwarɨdaakwiaꞌnera gamɨnyawɨnna bɨna yeva yɨbwarɨdaakuna. ");
INSERT INTO byr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yɨbwarɨdaakuna kyeꞌ jaꞌnawɨdɨna “Anga yuya da dangamanɨgaꞌ! Nebulyaꞌna yɨhɨthɨvanɨge. Dava sɨla pwai sɨla pwarɨ yɨlarɨkerɨ wanganakɨpɨꞌdei mɨꞌ. Arɨkewɨ. Yuya kayaaka woꞌdalasɨꞌna yapi kewɨnɨ pɨwɨ pɨwɨ maralɨvarabɨꞌdengɨ.” ");
INSERT INTO byr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mugunya Wolivɨyavɨ walamwaaidɨꞌnyɨ mɨdɨdɨvɨsara gavera mwaaidɨvɨꞌ gamɨnyawɨnna gavera bɨna yeva wɨdɨna “Gotɨyare Angeꞌ kayaaka yɨgaibɨꞌde nedɨwaanya gathɨngaaꞌ yɨmaꞌnadengaka? Nabaai nemɨ tɨnna berɨꞌ wanganawaajɨ yawɨranganaadeinaavaka? ‘Naangei yarai walaabathehaaꞌ aya kɨgaaꞌ yɨmaꞌnɨwaꞌ. Nabaai aayagaaꞌ Kwaaka davasɨ yuyajɨ yarai yɨwodengɨra.’” ");
INSERT INTO byr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sara wɨdɨna kyeꞌ Jizaazai dara jaꞌnawɨdɨna “Mala nayaa jɨwannyɨla! Aꞌmwe pwai kwai kwaasɨ yagaala kihɨthozɨ sarɨmɨ kwaasɨya nyɨpɨdɨka! ");
INSERT INTO byr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sareꞌ dareꞌnesɨ. Aꞌmwe kwalaalyara nɨmɨnne yayaꞌ bihɨthadɨvɨꞌ dara dɨpɨꞌdere, “Nɨmɨ sahwainyɨ Kɨraazɨtɨyainyɨreva. Gotɨyai nyɨdahɨlakaka nyɨmaryasaabakeinyɨra.” Sara kyapɨjɨ aꞌmwe kwalaalyara kwaasɨ yagaala wɨꞌnapɨjɨ kwaasɨya mɨdɨbɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Malyangɨjɨ malyavɨre yɨhukyagaalyangɨjɨ kadɨka duꞌnabalaryideihɨlyɨ. Mala nayaa jɨwannyɨla! Lɨka miwaainɨpɨnera! Sareꞌ dareꞌnesɨ. Mala sajɨ maiyagaala sajɨ yɨmaꞌnadengɨ. Kɨrɨꞌ aayagaaꞌ yaraina mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Sareꞌ dareꞌnesɨ. Anga naanga pimagɨnyara anga naanga pimagɨnya pwaraavɨ malyaꞌ bwaꞌnɨpɨꞌderera. Nabaai kingɨya pware yɨta pɨvaaꞌ kingɨya pware yɨta pɨvaasɨ malyaꞌ bwaꞌnɨpɨꞌderera. Kingɨya kwalaalyara sana sana yɨpɨꞌderera. Nabaai kwaaka pɨwɨ pɨwɨ mɨjɨka naangeꞌ wiaderera. Kwaakevakɨ pɨwɨ pɨwɨ wɨnɨnya yadevakɨra. ");
INSERT INTO byr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Taanga yuya daza yɨmaꞌnade aꞌmweꞌ mudangegaaꞌ kaimɨraaya maaryaꞌneꞌ sɨnnawɨ aayagaaꞌ daanga wɨvɨdevaaibɨꞌ yɨmaꞌnadengɨ. Dɨvi taanga naanga yɨmaꞌnadengɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Dazagaaꞌ nɨmɨreihɨrɨ yɨhɨlɨmwagapɨjɨ daangejɨ taanginyajɨ yɨhɨzaayaꞌneraavɨna yɨhɨmarɨmwangɨpɨꞌderera. Sara yɨhyadɨvɨꞌ daanga yɨhɨzaavapɨjɨ nabaai yɨhɨramakɨpɨꞌderera. Nabaai ajɨmya yuyangɨyara sarɨmɨnyɨna sɨmɨlɨka wimwaaladerera. Nɨmɨnne yayaꞌ yɨhwaꞌdeꞌna nyɨmɨdɨdɨvɨsaihɨrɨna sɨmɨlɨka wimwaaladengɨra. ");
INSERT INTO byr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nabaai dazagaaꞌ kwalaalyara nyɨlɨmwabɨzara nɨmɨnyɨ yagalyaꞌmapɨꞌderera. Yagalyaꞌmavapɨjɨ kunnya kwɨyaꞌmweraavɨ yɨkamaangeraavɨna yɨbwarɨdaakupɨꞌderera. Nabaai kumɨ sara kunnya kwɨyaꞌmweraavɨna sɨmɨlɨka wimwaaladerera. ");
INSERT INTO byr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kwaasɨya pɨropetɨya kwalaalyara yɨmaꞌnaabapɨjɨ ‘Gotɨyai kanyɨdɨwaꞌ yɨhɨthɨvanɨgeinyɨ,’ kwaasɨ yɨhɨthɨpɨꞌderera. Nabaai aꞌmwe kwalaalyara kwaasɨ yagaala wɨꞌnapɨjɨ kwaasɨya mɨdɨbɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kayaaꞌnanya sabwi naanga yɨmaꞌnyɨna yadevulyɨ. Sarevɨdaaꞌnyɨ aꞌmwe kwalaalyaraavɨre kale yabwi yɨwodesɨ. Kale mwiaderera. ");
INSERT INTO byr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kɨrɨꞌ yune yɨrɨka aayagaaꞌna aꞌmwei dɨragɨnna daavajai sahwarɨ Gotɨyai padaihasamaaradelyɨra. ");
INSERT INTO byr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nabaai Gotɨyai maremwaaidevɨ yagaala tewaanya dazavɨna wɨjɨwaakɨpɨꞌderera. Ajɨmya yuyangɨyaraavɨ jalɨkurakyaꞌneꞌ Kwaaka yuyawɨ gazawɨzawɨ mwaalyaraavɨ wɨjɨwaakɨpɨꞌdere. Sahɨrɨvɨ dɨvidaaꞌnyɨ yɨrɨka aayarɨꞌ yɨmaꞌnadehaakɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ne Deniyalɨ, pɨropetɨyai Gotɨyarɨ wɨꞌnaka yavɨkaryaaꞌ. Dara dɨnɨkesɨ, “Anga nawɨꞌnyavɨ kayaaꞌnanaangei kayaaka yɨgaidei daavadelyɨ.” Pɨkarya dazaꞌ danganajai yagaala saꞌ sɨmunya nayaa yawɨrana! Nabaai dara wɨdɨna “Yɨ kayaaꞌnanaangei kayaaka yɨgaidei Gotɨyare Angevɨ daaꞌdozɨyarɨ tɨnna wanganapɨjɨ sarevɨdaaꞌnyɨ ");
INSERT INTO byr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Juthɨya mwaalyara mwaaibɨzara ‘Naneramakadɨka!’ dapɨjɨ mugunyangɨna lɨkaanya yɨlaawɨpɨka! ");
INSERT INTO byr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Aꞌmwei angevɨ aꞌba yɨlamwaalojɨyai gɨlyɨvɨta maaryaꞌnei gannya angevɨ mwalaawanna! Aawa. Lɨkaanya wawana! ");
INSERT INTO byr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nabaai aꞌmwei wawɨnyawɨ mwaalojɨyai gannya yɨvɨsaꞌ maaryaꞌnei ayɨna mwawanna! Aawa. Lɨkaanya wawana! ");
INSERT INTO byr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Weꞌ! Yɨrɨka saryaavɨ aꞌmwe kaimɨraavɨmunnakejɨ aꞌmwe bwaranyangɨ aamunya wɨmaaryadaapiyajɨ lɨkaanya yarai wɨpɨꞌde mɨꞌ. Weꞌ! ");
INSERT INTO byr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gotɨyarɨ nayaa duzɨla! ‘Yɨrɨlyagaaꞌnajɨ kwazaakegaaꞌnajɨ kayaaꞌnanyagaaꞌ lɨkaanya nawaadɨka! Sarevɨdaaꞌnyɨ tewaanyagaaꞌ dɨthakɨdesɨ.’ ");
INSERT INTO byr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sareꞌ dareꞌnanyɨ. Dazagaaꞌ taanga naangeꞌ yɨmaꞌnadeꞌnanyɨ. Maalɨkeꞌna mɨꞌ! Sɨnnawɨ Kwaaka davaꞌ mudɨkevaꞌ yɨmaꞌnyaakevɨdaaꞌnyɨ dahaaꞌ kuna waꞌdɨꞌnyɨyagaaꞌ sasare taanginya sabwi mimaꞌnyaaka taanginya sabulyɨ. Nabaai dɨvi kɨgaasɨ taanginya sasarebwi yɨmaꞌnadevwi mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Gotɨyai yɨrɨka sagasa myesɨmayajɨ kwajɨ aꞌmwe yuyara yɨwɨna yɨpɨnere. Kɨrɨꞌ gannya aꞌmwe mena dahɨlakakeraavɨna Gotɨyai yawɨꞌda sarevɨ yɨrɨka sagasa yesɨmaꞌna yadehaakɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Dazagaaꞌ pwai kwai kwaasɨ yɨhɨthazai ‘Yɨthaanyi, dava Gotɨyai dahɨlakaka maryasaabaka Kɨraazɨtɨyai mwaalɨka!’ nabaai yɨhɨthazai ‘Aagaiba mwaalɨꞌ,’ sarɨmɨ dɨragɨnna nyawɨralɨmwabɨthɨka! ");
INSERT INTO byr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sareꞌ dareꞌnesɨ. Aꞌmwe pwara bɨna yapɨjɨ pwara kwaasɨ yagaala dara bihɨthɨpɨꞌderera ‘Nɨmɨ Gotɨyai nyɨdahɨlakaka nyɨmaryasaabakeinyɨ Kɨraazɨtɨyainyɨ.’ Pwara dara bihɨthɨpɨꞌderera ‘Nɨmɨ pɨropetɨya pwainyɨ. Gotɨyai kanyɨdɨwaꞌ yɨhɨthɨvanɨgeinyɨ.’ Kwaasɨya sahwara yɨjɨwaainya naangejɨ atɨka maruꞌnaryajɨ yɨpɨꞌdengɨ. Gotɨyai gamɨnne mena dahɨlakakeraavɨna ‘Navɨka marayadangɨraana!’ dadɨvɨꞌ dahɨlakakera kwaasɨya kayaaꞌnanya mɨdɨnyaꞌneraavɨ walapapalakyaꞌna yaamɨjɨ wɨdɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yɨthaanyi, sara myɨmaꞌnyagaaꞌ dazaꞌna mena yɨhɨthɨwa. ");
INSERT INTO byr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Sarevɨdaaꞌnyɨ kwaasɨ dara gɨthɨpɨjaꞌ ‘Yɨthaa! Kengimagɨ aꞌmwera maayɨmagɨ mwaalɨka!’ gɨmɨ sahimagɨnna mwɨyɨ jɨdimagɨnyɨ. Kwaasɨ dara gɨthɨpɨjaꞌ ‘Yɨthaa! Kuꞌdɨka lɨka yulyarɨkevɨ mwaalɨka!’ dɨragɨnna nyawɨralɨmwadɨka! ");
INSERT INTO byr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sareꞌ dareꞌnesɨ. Nyɨlyai bilyɨrɨꞌdimagɨdaaꞌnyɨ yune nyɨlyai walakadimagɨnna yɨnamɨraata yadevaaibɨꞌ Aꞌmweraavɨne Kaimɨraayainyɨ yuyara sara nyangabɨꞌdeinyɨ. Walaabɨdehaaꞌ lɨka yulyaꞌna yɨdeinyɨ mɨꞌ. Kuꞌmaayaba walaabɨdeinyɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gazabazaba aꞌmwe bainɨkere kɨlaakejɨꞌ warɨkeba tɨka nyaꞌnera kaamyaakera biꞌbwaꞌnemwaaidɨvɨsabe. ");
INSERT INTO byr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Taanginya sagaasa davwi mena kabwawojɨ maalɨkegaaꞌ nyɨlyai jɨhɨnya yaꞌna yadelyɨ. Sara yojɨ lawei baaka mavi yadelyɨ. Nabaai sɨgunyavɨdaaꞌnyɨ sɨlɨngaamɨnya bwalapɨꞌdengɨ. Nabaai sɨgunyavɨya dɨragɨnaange yonyɨ yonyɨ yɨwainɨgulaawɨpɨꞌdengɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dazagaaꞌ sɨgunyavɨ Aꞌmweraavɨne Kaimɨraayainyɨre yɨjɨwaainyaꞌ yɨmaꞌnadesɨ. Sara kyɨmaꞌnojɨ Kwaaka davakɨya pɨvaka yuyavakɨ kɨnna naanga dɨpɨꞌderera. Kɨnna dadɨvɨꞌ sahwara tɨnna nyangabɨꞌdere. Sɨgunyavɨya yɨraayangɨ Aꞌmweraavɨne Kaimɨraayainyɨ yɨlamwaalaꞌmujɨ dɨragɨnya naangesɨ byaanna naangesɨ sawaalyɨyainyɨ walaabɨdeinyɨ tɨnna nyangabɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Waidavadaaꞌmuri gwareꞌ yagaala naangeꞌ kyɨnnojɨ nɨmɨre ejelɨyaraavɨ maryasaabɨdeinyɨ. Kamaryasaabaꞌmujɨ sahwara nɨnnya dahɨlakeraavɨ yuyɨmagɨdaaꞌnyɨ Kwaakevakɨ aaya tɨya kɨwɨjɨ yunewɨdaaꞌnyɨ makabɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Keꞌbaꞌnanyaꞌ yɨta pihɨyarɨneꞌ sɨmunya jawɨramaarila! Gamɨre taanyabaraavɨ wɨvya naanga yada sedala pwaꞌnyɨna yada sarɨmɨ mena dara yawɨrangadɨvɨkɨ. Jarɨsagaaꞌ yarai yɨmaꞌnadesɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sara yadevaaibɨꞌ yuya yɨhɨthɨwengɨ tɨnna wanganapɨri dara jawɨranganyideihɨlyɨ. Aya kɨgaaꞌ mena jɨmaꞌnɨwaka! Kaanyayaba bathaavadei daaka! ");
INSERT INTO byr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nebulyaꞌna yɨhɨthɨvanɨge. Dazagaasa aꞌmwe dazara mabalyadapi yuya yɨhɨthɨwe daza yɨmaꞌnadehaaꞌnanyɨ. Arɨkawɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sɨgunyasɨ Kwaakesɨ yɨwawodesɨ. Kɨrɨꞌ nɨmɨre yagaalya yɨwawode mɨꞌ. Arɨkawɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yɨrɨka sarɨkɨna sagaaꞌna yawɨrangadei aꞌmwe pwai kwai mɨka. Aawa. Sɨgunyavɨya ejelɨyara kwarajɨ myawɨryare. Gawaalɨꞌ kwalyɨ myawɨranganyalyɨ. Aawa. Nɨmwai gave pwainanyai sagaaꞌna yawɨꞌdelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sareꞌ dareꞌnesɨ. Nowaaregaaꞌ sabwi yaatabaaibɨꞌ yadaapɨjɨ Aꞌmweraavɨne Kaimɨraayainyɨ ayɨna bamwaalɨdehaakɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sareꞌ dareꞌnesɨ. Aalyaaka naangeꞌ mimaꞌnyagaaꞌ sagaaꞌ tɨka wapaaya nyɨna, aalya nyɨna, kwala maarɨna, kwala maaꞌnyɨna, dazabwi kuna yadaapi Nowaai sɨpɨyavɨ wɨlɨna yaka sagaaꞌna. ");
INSERT INTO byr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wɨlɨna yaka wɨlamwaaidɨꞌnyɨ sɨmunya myawɨryara yaasɨwaꞌ sana mwaalɨna yadapi aalyaaka naangeꞌ bathɨꞌnɨgilɨna yaka aꞌmwe yuya dazaraavɨ maraminna. Navɨka mwaalɨna yaatabaaibɨꞌ aꞌmwera kuna yadɨvɨꞌ yadaapɨjɨ Aꞌmweraavɨne Kaimɨraayainyɨ ayɨna bamwaalɨdehaakɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dazagaaꞌ wawɨnyawɨ aꞌmwe pwaraai yɨna, ejelɨyara pwarɨna maarɨna yapɨjɨ pwarɨ marivainyɨna. ");
INSERT INTO byr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Witɨzɨla maalɨꞌna lɨlɨwadɨvɨsavɨ aꞌmwe pɨrɨwaai lɨlɨwanna yadaakɨlyɨ ejelɨyara pɨrɨvɨ maarɨna yapɨjɨ pɨrɨvɨ marivainyɨna. ");
INSERT INTO byr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Sarevɨdaaꞌnyɨ nayaa dɨvaihanaryɨla! Sarɨmɨre Naangeinyɨ walaabɨdehaaꞌ myawɨri jideꞌna nayaa dɨvaihanarila! ");
INSERT INTO byr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nayaa dara jawɨrila! Angevɨ gyakwai mena yawɨrajɨ kwajɨ ‘Sawɨsavɨ sagaaꞌ kukei wɨlaabathehaakɨra,’ nayaa padaꞌgalamaremwaaina kyadɨka! Nabaai gamɨre angevɨ woꞌdalamakulajarɨ kuka dazarɨ kwanganakadɨka! Kuka dazarɨ kavadaihɨrakadɨka! ");
INSERT INTO byr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sarevɨ dɨvadaꞌgalemwaalyɨla! Aꞌmweraavɨne Kaimɨraayainyɨ walaabɨdevɨna myawɨryadaapiyagaaꞌ walaabɨdeꞌna sagaaꞌneihi nayaa dɨvadaꞌgalemwaalyɨla! ");
INSERT INTO byr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kumɨregaaꞌ angevɨ maremwaaidereraavɨna wapaaya wɨjaayaꞌnerɨ bewarɨ dahɨlakadelaka? Yɨ wɨdaayade sɨmunyaꞌ yawɨꞌdei gamɨre wawɨnyavɨ nayaa padaꞌgalamaremwaaide sahwarɨ dahɨlakadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Miꞌna dahɨlakojɨ pɨwɨnna wɨna. Aꞌmwe naangei ayɨna bozɨ gannya wɨdaayaderɨ sara wɨdakabaaibɨꞌ sara yadaawojɨyarɨ tɨnna bwanganna yajai wɨdaayade dazai yɨlaaya yada tewaanaanga yɨnadelyɨra. ");
INSERT INTO byr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nebulyaꞌna yɨhɨthɨvanɨge. Gamɨre gɨlyɨvɨta yuya sangɨneꞌna maremwaalyaꞌnerɨ dahɨlakadelyɨra. ");
INSERT INTO byr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kɨrɨꞌ wɨdaayade dazai kayaaꞌnanyai mwaalajai gannya sɨmunyavɨ dara yawɨrajai ‘Nɨmɨre aꞌmwe naangei yarai bathei mɨka,’ ");
INSERT INTO byr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","gamɨre wɨgaimwadɨvɨsaraavɨ mala tamɨna yada munnejɨ tɨka nyɨna, yɨmaka widɨvɨsaraayaba yeꞌmwannanyɨna yajai ");
INSERT INTO byr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","‘Dahaaꞌ ayɨna bathelyɨ,’ sɨmunya myawɨri yadaawojɨyagaaꞌ, yɨ sagaaꞌna sɨduꞌmaayai mwaaidozɨyagaaꞌ wɨdaayade dazare naangei bathelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mena bozɨ wɨdaayade dazarɨ yuna dakurakɨna yojɨ aꞌmwe kwaasɨyaraavɨjɨ maryeꞌmwannamwaaihadelyɨ. Dazɨmagɨ sahwara kɨnna naanga dadɨvɨꞌ daangeꞌna kunnya maangerɨka kɨjɨvainɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Dazagaaꞌ Sɨgunyavɨya maremwaaidevwi dareꞌbɨsasɨ. Sɨdɨraaya atɨraalya mwaaidɨvɨꞌ kunnya laamɨvananya maarɨna yeva aꞌmwe mɨgɨnyai kwala maaryaꞌnerɨ lɨvawɨjɨmaaꞌnyaꞌnemɨlɨka wɨna. ");
INSERT INTO byr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Atɨlya sɨmunya kayaaꞌna yawɨꞌna, atɨlya sɨmunya tewaanna yawɨꞌna. ");
INSERT INTO byr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sɨmunya maayamɨlɨka kunnya laamɨvananya makabɨna. Sara yeva kɨrɨꞌ welivananyasɨ mamakabi yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nabaai sɨmunnakemɨlɨka kunnya welivanadalyangɨ welivananya dɨngikɨna yeva kɨnɨjɨ tɨhuꞌna makabɨna yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aꞌmwei kwala maaryaꞌnei yarai mabi. Yarai mabi kyaꞌ sarevɨ aꞌmwe yuyamɨlɨka seꞌna yɨdakuwɨlaawɨna yɨna yeva se wakulɨna. ");
INSERT INTO byr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Se wakulɨna yadapi sawɨta kalawawegaaꞌ jaka pɨrɨꞌ yɨnnɨgavɨna ‘Yɨthaanyi! Kwala maaryaꞌnei kaanya yɨnɨka. Tutaanyavɨ wɨjɨmaꞌnaawapɨjɨ dɨmakabila!’ ");
INSERT INTO byr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jaka yɨnnɨgavɨna kyaꞌ sɨdɨraaya yuya sa dɨkaaꞌna yeva kumɨre laamɨvananya yovɨrawakɨna. ");
INSERT INTO byr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yovɨrawakɨna yadɨvɨꞌ sɨduꞌmaayamɨlɨka sɨduꞌnakemɨlɨkaavɨ wɨdɨna ‘Nemɨre laamɨvananya mena yɨgaavadeꞌna yɨwaka. Sareꞌna sarɨmɨre welivananya maalɨka pɨjɨꞌ dɨnejaayɨla!’ ");
INSERT INTO byr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kɨrɨꞌ sɨduꞌnakemɨlɨka jaꞌnawɨdɨna ‘Nemɨre welivananya daꞌ nemɨnyɨjɨ sarɨmɨnyɨjɨ yɨnɨga wiꞌna neyadeꞌ mɨka! Aawa. Mubangevɨna wawopɨjɨ yune sarɨnnyaꞌneꞌ dɨmubaawila!’ ");
INSERT INTO byr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sara wɨdɨna kyeꞌ samɨlɨka welivananyaꞌ mubyaꞌnemɨlɨka kaanna wɨna. Kaanna wɨna yadaapi aꞌmwei kwala maaryaꞌnei kaanya biꞌmaꞌna. Kaanya biꞌmaꞌna kyaꞌ sahwarɨna yemwaaleta samɨlɨka kwala maarya munne naangevɨnemɨlɨka gamɨjɨ yeꞌmwannɨgwina. Sara kyeꞌ kaanyaꞌ maratihɨꞌna. ");
INSERT INTO byr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kaanyaꞌ tihɨꞌnɨkeꞌ dɨvidaaꞌnyɨ sɨdɨraaya pɨmɨlɨka bɨna yeva sahɨmɨlɨka wɨdɨna ‘Naangeigɨ, naangeigɨ, kaanyaꞌ dɨnebasamaraama!’ ");
INSERT INTO byr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kɨrɨꞌ jaꞌnawɨdɨna ‘Nebulyaꞌna yɨhɨthɨvanɨge. Sarɨmɨnyɨ mihwanganyadɨnyainyɨ.’ ");
INSERT INTO byr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Sarevɨdaaꞌnyɨ aꞌmwe kwala maaryaꞌnei byahaaꞌna myawɨryetabaaibɨꞌ bɨde yɨrɨka sarɨkɨna sagaaꞌna myawɨrivanɨgasaꞌna nayaa dɨvaihanaryɨla! ");
INSERT INTO byr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Bɨdehaaꞌneꞌ dareꞌnesɨ. Aꞌmwe pwai ‘Menyabanna kaanya wɨma!’ dakei gannya wɨdaayadɨvɨsaraavɨ jaka wɨdɨna yaka gannya gɨlyɨvɨsa wɨmaarina. ");
INSERT INTO byr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","‘Kumɨre sɨmunya genna gennanya warɨka. Sɨmunya nawɨꞌnya yaderɨna naanga wɨjaavɨma! Sɨmunya kɨbawe yaderɨna kɨbawe wɨjaavɨma! Sɨmunya maalɨka yaderɨna maalɨka wɨjaavɨma!’ daka pwarɨna paaivɨ taawɨzanɨ kinaaya (K5000) wɨmaarina, nabaai pwarɨna tu taawɨzanɨ kinaaya (K2000) wɨmaarina, nabaai pwarɨna waanɨ taawɨzanɨ kinaaya (K1000) wɨmaarina. Yuya wɨmaarina yaka pɨwɨnna kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kaanna wɨna kyaꞌ paaivɨ taawɨzanɨ kinaaya maarakei yɨmeꞌnyaꞌbɨꞌ wɨna yaka mubɨmubya yaka paaivɨ taawɨzanɨya mudɨka pɨnɨjɨ yeꞌmwagakɨna yaka tenɨ taawɨzanɨ kinaaya lɨmwanna. ");
INSERT INTO byr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nabaai sabaaibɨꞌ aꞌmwe 2,000 kinaaya maarakei sai kwalyɨ mubɨmubya yaka 2,000 kinaaya pɨnɨjɨ yeꞌmwagakɨna. ");
INSERT INTO byr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kɨrɨꞌ aꞌmwe 1,000 kinaaya maarakei kwaakevɨ kaviꞌnɨnnyaꞌ lɨkaawɨna yaka nɨgwia sa gannya aꞌmwe naangere sa lɨkirakɨna. ");
INSERT INTO byr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Dɨvidaaꞌnyɨ saamɨnyagaaꞌ mena buna kyaꞌ wɨdaayadɨvɨta sahwaraavɨre aꞌmwe naangei ayɨna bɨna yaka ‘Sahwarajɨ nɨmɨre nɨgwia wɨjaave sanna yagaalyaꞌ yeꞌmwannadɨma!’ dɨna. ");
INSERT INTO byr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dɨna yaka yeꞌmwannadɨna yada paaivɨ taawɨzanɨ kinaaya maarakei bɨna, sai nɨgwia 5,000 kinaaya pɨnɨjɨ makabɨna yaka 10,000 kinaaya wakɨna yaka wɨdɨna ‘Aꞌmwe naangeigɨ, 5,000 kinaaya nyɨjaavagɨnya. Yɨthaa! Mubɨmubya maryena 5,000 kinaaya pɨnɨjɨ maaꞌmwengɨra.’ ");
INSERT INTO byr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sara wɨdɨna kyaꞌ gamɨre aꞌmwe naangei wɨdɨna ‘Tewaanyasɨ. Nyɨdaayadɨnya tewaanyaigɨnyɨra. Sara gɨthe wawɨnyavɨ tewaanna lɨmwadɨnyaigɨnyɨra. Wawɨnya pɨrɨꞌ pɨrɨvɨ tewaanna lɨmwadɨnyaigɨnyɨ. Sarevɨdaasɨ wawɨnya kwalaalyangɨ maremwaaidɨnyaigɨnyɨ gɨmwaaihɨma! Aꞌmwe naangeinyɨre yɨlaaya naangevɨ dulamwaala!’ ");
INSERT INTO byr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Sara wɨdɨna kyaꞌ tu taawɨzanɨ kinaaya maarakei kwalyɨ bɨna yaka wɨdɨna ‘Aꞌmwe naangeigɨ, 2,000 kinaaya nyɨjaavagɨnyangɨ. Yɨthaa! Mubɨmubya maryena 2,000 kinaaya pɨnɨjɨ maaꞌmwengɨra.’ ");
INSERT INTO byr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Sara wɨdɨna kyaꞌ gamɨre aꞌmwe naangei wɨdɨna ‘Tewaanyasɨ. Nyɨdaayadɨnya tewaanyaigɨnyɨra. Sara gɨthe wawɨnyavɨ lɨmwadɨnyaigɨnyɨra. Wawɨnya pɨrɨꞌ pɨrɨvɨ tewaanna lɨmwadɨnyaigɨnyɨ. Sarevɨdaasɨ wawɨnya kwalaalyangɨ maremwaaidɨnyaigɨnyɨ gɨmwaaihɨma! Aꞌmwe naangeinyɨre yɨlaaya naangevɨ dulamwaala!’ ");
INSERT INTO byr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Sara wɨdɨna kyaꞌ kɨrɨꞌ waanɨ taawɨzanɨ kinaaya maarakei kwalyɨ bɨna yaka kwaasɨ wɨdɨna ‘Aꞌmwe naangeigɨ, mena dara yawɨꞌmanɨge. Gɨmɨ aꞌmwe kɨrɨꞌmɨryaigɨnyɨ. Wawɨnyangɨ gɨmɨre gɨthaayadɨvɨsara burɨdɨvɨta tɨka munnengɨ midɨnyaigɨnyɨ. Pwara witɨzɨla pɨraihɨramaaꞌdɨvɨta witɨzɨla sa maarakadɨnyaigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Sasareigɨnyɨneꞌna lɨka yena gɨmɨre nɨgwia 1,000 kinaaya kwaakevɨ lɨka yulyaꞌmwagake. Gɨmɨre nɨgwia dathavaaka.’ ");
INSERT INTO byr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Sara wɨdɨna kyaꞌ gamɨre aꞌmwe naangei jaꞌnawɨdɨna ‘Nyɨdaayadɨnya kayaaꞌnanyaigɨnyɨ. Maaꞌna gideigɨnyɨ. Nyɨdɨwaanyaꞌ yawɨꞌmanɨgɨnyaigɨ daa! Wawɨnyangɨ pwara burɨdɨvɨsangɨ tɨka munne yabwaryadaari pwara witɨzɨla pɨraihɨramaaꞌdɨvɨta maarakadɨnyainyɨ. ");
INSERT INTO byr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Sara kwaasɨ yawɨꞌna yɨjaigɨ bengɨyavɨ nɨnnya nɨgwia mwaki beꞌna yɨwaana! Sareꞌ tewaanna nyakɨjɨ kwajɨ nɨnnya nɨgwiajɨ nɨgwia pɨnɨjɨ kabamaaꞌmudɨkeinyɨ.’ ");
INSERT INTO byr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Sara wɨdɨna yaka pwaraavɨ wɨdɨna ‘Sarevɨdaaꞌnyɨ sarɨmɨ gamɨnyɨ 1,000 kinaaya dazaꞌ yɨpalamaarapɨjɨ tenɨ taawɨzanɨya kɨnɨnnaka dazarɨ duzaayɨla! ");
INSERT INTO byr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sareꞌ dareꞌnesɨ. Gazaizai pɨnɨ kɨnɨnnakerɨ pɨnɨjɨ kujaavaꞌmujɨ naanga naanga kɨnɨnnakei yɨmaꞌnadelyɨ. Kɨrɨꞌ pɨnɨ maayarɨ maalɨkejɨꞌ navɨka lɨmwagarɨkevɨ maarɨdelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nyɨdaayade waryaanya dazarɨ mwasɨlaanna jɨhɨnya aayawɨnna dɨmarasɨꞌnyɨla! Dazɨmagɨ kɨnna naanga dadɨvɨꞌ daangeꞌna kunnya maangerɨka kɨjɨvainya yɨpɨꞌdevanyɨra.’ ");
INSERT INTO byr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Dɨvi sagaaꞌ Aꞌmweraavɨne Kaimɨraayai gannya byaannyavɨ maarojɨ ejelɨya yuyara kwarajɨ ayɨna bathelyɨ. Dazagaaꞌ gannya maremwaaide namwaalyɨta byaannakevɨ walamwaaladelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nabaai ejelɨyara nɨmɨnyawɨnna ajɨmya yuyangɨyaraavɨ maryɨꞌbwaramakabɨna kyapɨjɨ sipɨzipɨyaraavɨ maremwaaidei pimagɨ sipɨzipɨyaraavɨ pimagɨ memeyaraavɨ maryawɨbwarɨdaakuna yadevaaibɨꞌ pimagɨnyaai marɨdaakwɨdere. ");
INSERT INTO byr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Aangasɨmagɨ tewaanyara sipɨzipɨyaraavɨ marɨdaakuna, kwanaamimagɨ kayaaꞌnanyara memeyaraavɨ marɨdaakuna. ");
INSERT INTO byr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Marɨdaakuna yaꞌmujɨ nɨmɨre aangasɨmagɨ mwaaidapiyaraavɨ Kingɨyainyɨ wɨdɨna ‘Nɨmaamaangei tewaanya yɨhɨzaavɨnɨkeihi bamaarideihɨlyɨ. Aaya Kwaakevaꞌ mudɨka yɨmaꞌnakegaaꞌ Nɨmwai mena yovɨrawakɨnɨkeba sarɨmɨnyɨneba nayaa yɨhɨmaremwaaladeva sɨrɨnɨmaangereba yanga dɨvɨramaaryideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sareꞌ dareꞌnesɨ. Nɨmɨ mɨjɨka nyakeinyɨna sarɨmɨ wapaaya wɨjaavɨna nyeꞌ. Aalyaꞌna mɨjɨka kanyaꞌ sarɨmɨ aalyaꞌ wɨjaavɨna nyeꞌ. Nɨmɨ angavaayainyɨ mwaaleinyɨ sarɨmɨre angengɨna makuna nyeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nɨmɨ baazɨꞌmaꞌnya maayainyɨ sarɨmɨ baazɨꞌmaꞌnyaꞌ wɨjaavɨna kanyeꞌ baazɨꞌmaꞌneinyɨ. Nɨmɨ nalaavɨnakeinyɨ mwaaideri sarɨmɨ maremwaaina nyeꞌ. Nɨmɨ kalavuzangevɨ mwaaideri sarɨmɨ banyanganesaihɨlyɨ.’ ");
INSERT INTO byr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Sara wɨdɨna kyaꞌmujɨ aꞌmwe yɨdaꞌmaraangera jaꞌnawɨdɨna ‘Naangeigɨ, nemɨ mɨjɨꞌnanyaigɨnyɨ gathɨngaaꞌ gwanganona wapaaya gɨzaavo? Aalyaꞌna mɨjɨkeꞌ gathɨngaaꞌ kagyaꞌ aalyaꞌ gɨzaavo? ");
INSERT INTO byr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Gɨmɨ angavaayaigɨnyɨ gathɨngaaꞌ gwanganona nemɨre angevɨna gɨmakwawo? Gɨmɨ baazɨꞌmaꞌnya maayaigɨ gathɨngaaꞌ yadaꞌgi baazɨꞌmaꞌnya gɨzaavo? ");
INSERT INTO byr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nalaavɨnakeigɨnyɨ gathɨngaaꞌ gwanganona gɨmaremwaalo? Kalavuzangevɨ gathɨngaaꞌ mwaaidaꞌgi gɨmɨnyawɨnna bo?’ ");
INSERT INTO byr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sara kanyɨdapɨjɨ Kingɨyainyɨ jaꞌnawɨdɨna ‘Nebulyaꞌna yɨhɨthɨvanɨge. Nyaꞌmwera aꞌmwe darajɨya pwai aꞌmwe maalɨkei mwaaidɨꞌnyɨ kɨrɨꞌ sahwarɨ sara yadɨvɨꞌ yɨ nɨmɨnyɨ sara nyesaihɨlyɨ.’ ");
INSERT INTO byr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Sara wɨdɨna yaꞌmujɨ sagaaꞌ kwanaamimagɨ mwaaidapiyaraavɨ wɨdɨna ‘Dɨkevɨ marasɨꞌnyaꞌneihi nɨmɨnyawɨdaaꞌnyɨ dɨwideihɨlyɨ. Gotɨyai Dɨka dazaꞌ Saataanɨmɨnajɨ gamɨre ejelɨyaraavɨnajɨ yovɨrawakɨnɨkesɨ. Sare kɨrɨꞌ Dɨka dazaꞌ myɨgaayɨ yaꞌnevɨ dɨwideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sareꞌ dareꞌnesɨ. Mɨjɨka mwaaideri nyaꞌne nyɨjaavetaihi mɨꞌ. Aalyaꞌna mɨjɨka nyadaaꞌnyɨ aalyaꞌ nyɨjaavetaihi mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Angavaayainyɨ mwaaideri sarɨmɨre angengɨna nyɨmakwawetaihi mɨꞌ. Baazɨꞌmaꞌnya maayainyɨ baazɨꞌmaꞌnyaꞌ nyɨbaazɨꞌmakwetainyɨ mɨka! Nɨmɨ nalaavɨnakeinyɨ mwaaleinyɨ, kalavuzangevɨ mwaaideri sarɨmɨ nyɨmaremwaaletaihi mɨꞌ.’ ");
INSERT INTO byr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Sara wɨdɨna kyaꞌmujɨ nabaai kumɨ kwara jaꞌnawɨdɨna ‘Naangeigɨ, gɨmɨ mɨjɨka yadaaꞌgi gathɨngaaꞌ gwanganoigɨnaka? Nabaai aalyaꞌna baidaaꞌgi nabaai angavaayaigɨ nabaai baazɨꞌmaꞌnya maayaigɨ nabaai nalaavɨnakeigɨ nabaai kalavuzangevɨ gathɨngaaꞌ mwaaidaꞌgi nemɨ nayaa magyavadaꞌgalyo?’ ");
INSERT INTO byr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Sara kanyɨdapi jaꞌnawɨdɨna ‘Nebulyaꞌna yɨhɨthɨvanɨge. Aꞌmwe darajɨya pwai aꞌmwe maalɨkei mwaaidɨꞌnyɨ kɨrɨꞌ sahwarɨ sara myadɨvɨꞌ yɨ nɨmɨnyɨ sara nyetaihi mɨꞌ.’ ");
INSERT INTO byr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Sara wɨdɨna kyaꞌmujɨ aꞌmwe dazara daangesɨ taangesɨ maraawɨpɨꞌderera. Kɨrɨꞌ aꞌmwe yɨdaꞌmaraangera gaala yuyagaaꞌ yuyagaaꞌne mwaalyaꞌnebwi maapɨꞌderera.” ");
INSERT INTO byr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jizaazai yagaala yuya daza mena jɨꞌmwannaka dazagaaꞌ gamɨre mɨdɨdɨvɨsaraavɨ wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Sarɨmɨ yawɨꞌmanɨgaꞌ ‘Yɨrɨka pɨrɨkaaina kwavɨlavojɨ Pariꞌmaꞌmunneꞌ yɨmaꞌnadesɨ.’ Sagaaꞌ Aꞌmweraavɨne Kaimɨraayainyɨ yɨsavɨri nilɨya nyɨramarɨmudaakwiaꞌneinyɨ nyɨmarɨmwangɨpɨꞌdeinyɨra.” (Pariꞌmasaꞌnegaaꞌ Ne Mozɨzai mwaaidɨꞌnyɨ Gotɨyai Yɨzɨrelɨya sɨnnawɨnyaraavɨ yɨvainyaakegaaꞌne yawɨsaꞌnesɨ.) ");
INSERT INTO byr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dazagaaꞌ Gotɨyarɨne tamiraꞌdɨvɨta naangerajɨ aꞌmweraavɨre aꞌmwe naangerajɨ sara Gotɨyarɨna mubɨthɨka Yɨraꞌde Naangere angevɨ yɨꞌbwaꞌnyɨna. Gotɨyarɨna Yɨraꞌde Naangei Kaayapaazai woꞌnɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yɨꞌbwaꞌnyɨna yeva yagaaikɨwɨnya bathɨwɨna “Jizaazarɨna kwaasɨ yawaajɨ kɨmaꞌnyawɨ galalɨmwagawaajɨ maratamaana!” deva jamungajakeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kɨrɨꞌ sahwara dɨna “Tɨka Munnevɨ sasare sa myaannera! Aꞌmwera mala narannɨpɨdɨka!” ");
INSERT INTO byr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betaani anga Saaimonɨ Samatanakerevɨ Jizaazai mwaaidɨꞌnyɨ ");
INSERT INTO byr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","gamɨnyawɨnna aꞌmwe pɨrɨꞌ bɨna, sitala nawɨꞌnyavɨ welivananyaꞌ nɨgwia naanga mubya yɨnɨkeꞌ makabɨna. Makabɨna yaka yɨꞌbɨnyavɨ mwaaidɨꞌnyɨyagaaꞌ gamɨre mɨnyagɨnyavɨ welivananya saꞌ dɨngɨna. ");
INSERT INTO byr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Dɨngɨna yadaaꞌnyɨ mɨdɨdɨvɨsara tɨnna wanganna yɨna yeva sɨnna tɨka wɨdaꞌdaaꞌnyɨ dɨna “Welivananya saꞌ yaasɨwaꞌna beꞌna yɨwaka! ");
INSERT INTO byr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Sareꞌ dareꞌnesɨ. Nemɨ welivananya dazaꞌ aꞌmweraavɨna mubyaꞌna wɨjavaajaꞌ savɨna nɨgwia naanga marawaajɨ aꞌmwe gɨlyɨvɨta maayaraavɨ wɨjavaannengɨra.” ");
INSERT INTO byr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kɨrɨꞌ Jizaazai kumɨre yagaalyaꞌ yawɨranganna yɨna yaka sahwaraavɨ wɨdɨna “Ai, aꞌmwe davɨ taanginyabwi beꞌna wɨjaavanɨgava! Sareꞌ dareꞌnesɨ. Sahɨrɨꞌ tewaanyabwi nyɨvanɨkeꞌna kave mwaalana! ");
INSERT INTO byr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sareꞌ dareꞌnesɨ. Yuyagaaꞌ aꞌmwe gɨlyɨvɨꞌmaayara sarɨmɨjɨ yeꞌmwannemwaaidɨvɨsarera. Kɨrɨꞌ nɨmɨ sarɨmɨjɨ yuyagaaꞌ yeꞌmwannemwaalɨdeinyɨ mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nabaai sareꞌ dareꞌnesɨ. Aꞌmweꞌ nɨmɨre kɨlaakejɨkɨ welivananya dazaꞌ nyɨdɨngɨwakeꞌ sahɨrɨꞌ sasara yɨwaka dazaꞌ kaviꞌnɨnnyavɨ yavadaꞌgalayɨrakyaꞌneinyɨ nyɨwakeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nebulyaꞌna yɨhɨthɨvanɨge. Kwaaka yuyavakɨ yagaala tewaanya dazaꞌ wɨjɨwakamaryadɨvɨꞌ aꞌmwe dazaꞌ dava nyɨwaka dazanna dɨpɨꞌdengɨ. Sara kyapɨjɨ sarevɨdaaꞌnyɨ aꞌmwevɨna sɨmunya nayaa yawɨpɨꞌdeꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Dazagaaꞌ sɨvɨlyɨrɨdaasɨ pwaraalyarajɨya pwai, Juthaazai Yɨzɨkerɨyotɨyai woꞌnɨkei Gotɨyarɨne tamiraꞌdɨvɨta naangeraayawɨnna kaanna wɨna yaka ");
INSERT INTO byr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","wɨdɨna “Sarɨmɨnyɨna gamɨnyɨ kyɨhibwarɨdaakwaꞌmujɨ nɨmɨnyɨ benɨ dɨnyɨjaayideihɨlaka?” Wɨdɨna kyaꞌ nɨgwia sɨlɨvaaya tetiya (30) ata gɨlɨna yeva wɨjaavɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Wɨjaavɨna yesagaaꞌdaaꞌnyɨ “Sahwarɨ kumɨnyɨna wibwarɨdaakwiaꞌneinyɨ tewaanyagaaꞌ yɨma!” daka yaamɨjɨ yɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kave mwaalyaꞌnegaaꞌne yɨrɨka sɨnnawɨnyarɨkɨ bɨretɨya yɨzɨya maayagaaꞌ mɨdɨdisaraai Jizaazaryawɨnna bɨna yagɨla wɨdɨna “Pariꞌmaꞌmunneꞌ tɨka nyaꞌneigɨnyɨna tɨka wapaaya gawɨ yovɨravawakakadeinaalaka?” ");
INSERT INTO byr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wɨdɨna kyagi gamɨ wɨdɨna “Kɨrɨmɨ anga naangewɨ wɨlaawakɨlyɨ aꞌmwe nyɨnagaawaryawɨnna wɨna yakɨlyɨ duzɨla! ‘Wɨjɨwaakyai dara gɨthɨwaka “Nɨmɨregaaꞌ aya kɨgaakɨra. Gɨmɨre angevɨ nɨmɨrerari Pariꞌmaꞌmunneꞌ yeꞌmwannanaadeꞌnanyɨ,” gɨthɨwaꞌ,’ duzɨla!” ");
INSERT INTO byr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jizaazai sara wɨdakabaaibɨꞌ mɨdɨdisaraai sara yagɨla Pariꞌmaꞌmunneꞌ yovɨrawakɨna yagi. ");
INSERT INTO byr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sawɨsaꞌ kajɨnnaꞌ yɨꞌbɨnyavɨ sɨvɨlyɨrɨdaaꞌnyɨ pwaraalyarajɨ walamwaaina. ");
INSERT INTO byr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wapaaya kuna nadɨvɨꞌ sai wɨdɨna “Nebulyaꞌna yɨhɨthɨvanɨge. Sarɨmɨnyɨdaaꞌnya pwai nɨmɨre yɨkamaangeraavɨna nɨmɨnyɨ nyɨbwarɨdaakwadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sara wɨdɨna kyaꞌ kumɨre kale naanga wiadaaꞌnyɨ pwaidaasɨ pwaidaasɨ gaai yɨdaanganna “Naangeigɨ, nɨmɨ daaka!” ");
INSERT INTO byr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sara wɨdɨna kyeꞌ sahwai jaꞌnawɨdɨna “Aꞌmwe dazai nɨmɨjɨ dɨzɨyavɨ ata yeꞌmwannamakwaimwaawola sai kuꞌmaayaba nyɨmarimaꞌnaabathelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yo, Gotɨyare bukuyavɨ mena dɨnɨkabaaibɨꞌ Aꞌmweraavɨne Kaimɨraayainyɨ wɨdeinyɨ. Kɨrɨꞌ weꞌ! aꞌmwe dazai Aꞌmweraavɨne Kaimɨraayainyɨ yɨkamaangeraavɨna nyɨbwarɨdaakwaderɨ kayaaka wigaladelyɨ. Aꞌmwe dazarɨ ganaangeꞌ gamɨnyɨ mamaaryajɨ kwajɨ gamɨnyɨna tewaanyaꞌ kwaradɨka!” ");
INSERT INTO byr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sara wɨdɨna kyaꞌ Juthaazai yɨkamaangeraavɨna wibwarɨdaakwiaꞌnei jaꞌnawɨdɨna “Wɨjɨwaakyaigɨ nɨmɨ daaka?” Gamɨ wɨdɨna “Yɨ dɨwaanya kɨbaaibɨsasɨ.” ");
INSERT INTO byr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tɨka munne kuna nadaapi Jizaazai bɨretɨyaꞌ maarɨna yaka Gotɨyarɨ “Su! Yɨlaaya gɨmariwa,” wɨdɨna yaka gunyɨna yaka mɨdɨdɨvɨsaraavɨna wɨjaavɨna yaka wɨdɨna “Maarapɨjɨ dɨnyɨla! Dazaꞌ nɨmɨre kɨlaakejɨkɨra.” ");
INSERT INTO byr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nabaai waainɨyavɨ kaapɨvananyaꞌ maarɨna yaka Gotɨyarɨ “Su! Su!” wɨdɨna yaka sahwaraavɨna wɨjaavɨna yaka wɨdɨna “Sarɨmɨ yuyaihi aalya dazaꞌ dɨnyɨla! ");
INSERT INTO byr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Sareꞌ dareꞌnesɨ. Dazaꞌ nɨmɨre taweꞌ wɨlɨmwagarɨkebwi yaꞌnesɨ. Aꞌmwe kwalaalyaraavɨre wagɨlya marasɨꞌnyaꞌneꞌ nɨmɨre taweꞌ yadɨmwawakɨnadesɨ. Gotɨyai nɨmɨre taweꞌ bwalaradeꞌ tɨnna wanganojɨ wɨlɨmwagarɨkebwi nebulyaꞌ dakadesɨ. ");
INSERT INTO byr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yɨhɨthɨvanɨge. Gɨraipɨwɨlyabaarɨ yɨsi-aalya ayahi nɨdeinyɨ mɨꞌ. Arɨkawɨ. Dɨvi Nɨmaamaangei maremwaaladevɨ sarɨmɨjɨ yeꞌmwannemwaaina yaade yɨrɨka sagaaꞌna yɨsi-aalya mudɨkeꞌ yeꞌmwannanɨdesɨ.” ");
INSERT INTO byr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Daata pɨrɨꞌ mena dɨna yeva mwasawɨnna walyuna yɨna yeva Mugunya Wolivɨna kaanna wɨna. (Yɨledaata 118) ");
INSERT INTO byr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sagaaꞌ Jizaazai wɨdɨna “Dahaaꞌ sawɨta davɨ sarɨmɨ yuyaihi lɨka yapɨjɨ dɨnyagalyaꞌmayideihɨlyɨ. Sareꞌ dara dɨnɨkeꞌnanyɨ ‘Nɨmɨ sipɨzipɨyaraavɨ maremwaaiderɨ karamaꞌmujɨ Sipɨzipɨyavaakɨyara lɨkaanya yɨwɨnamaꞌna yɨpɨꞌderera.’ Sara dɨnɨkabaaibɨꞌ lɨkaanya yɨwɨnamaꞌna jideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kɨrɨꞌ ayɨna kyanyɨdɨkaavojɨ Galɨlina yɨhibwaramakwaanɨdeinyɨ sarɨmɨnyɨ waanɨdeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Sara wɨdɨna kyaꞌ Pitai jaꞌnawɨdɨna “Yɨ pwara yuyara lɨka yapɨjɨ lɨkaanya gyahalyaꞌmapɨjara nɨmɨ sainyɨ yuyagaaꞌ lɨka mi yaꞌmujɨ gyahalyaꞌmavɨdeinyɨ mɨꞌ. Arɨkawɨ.” ");
INSERT INTO byr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Wɨdɨna kyaꞌ Jizaazai wɨdɨna “Nebulyaꞌna gɨthɨvanɨge. Dahaaꞌ sawɨta dathavɨ kukuraayai jaka majadori dahasaai dahaaꞌ dara dɨthatheigɨnyɨ ‘Sahwarɨ mwanganyɨvanɨgeinyɨ.’” ");
INSERT INTO byr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Wɨdɨna kyaꞌ Pitai wɨdɨna “Arɨkewɨ. Gɨmɨjɨ yeꞌmwannabaimujainyɨ kɨrɨꞌ dɨdeinyɨ mɨꞌ ‘Sahwarɨ wangamanɨgeinyɨ mɨka!’ Aawa nebulyasɨ.” Nabaai Pitai sara wɨdakabaaibɨꞌ mɨdɨdɨvɨta yuya kwarajɨ avaaina sara dɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sagaaꞌ kwaaka pimagɨnya Gazamani Jizaazai kumɨjɨ yeꞌmwannɨguna yaka mɨdɨdɨvɨsaraavɨ wɨdɨna “Dava dalamwaalyɨla! Mwaaidapi kengimagɨnna wawaꞌmujɨ Gotɨyarɨ wɨdɨma!” ");
INSERT INTO byr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wɨdɨna yaka Pitarɨjɨ Sevathiyare kaimɨraayaraai kwaraarɨjɨ yeꞌmwannɨguna yaka kale naanga wiadaaꞌnyɨ naanga yɨbwakɨnna. ");
INSERT INTO byr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Naanga yɨbwakɨnna yada kumɨnyɨ wɨdɨna “Nɨmɨre kuryai naanga kuna yɨbwakɨmanɨge. Sareꞌna nɨmɨ balɨdeꞌna yɨwana. Dava mwaalapi se mwapɨna! Nɨmɨnyɨna nyemwaalapɨjɨ nɨmɨnyɨna Gotɨyarɨ duzɨla!” ");
INSERT INTO byr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wɨdɨna yaka kɨbaweba sangirɨꞌ wɨna yaka gamɨre sɨnnyɨꞌ kwaakeyɨna walarutaꞌnyɨna yaka Gotɨyarɨ wɨdɨna “Nɨmwai, ‘Wiꞌnanyɨra,’ dɨzaigɨ taanginya dazaꞌ dɨnyɨmarasɨka! Kɨrɨꞌ nɨmɨre yawɨsabwi manyɨmɨdɨdɨnnera! Aawa. Yune gɨmɨre yawɨsabwina dɨmɨdɨdeigɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wɨdɨna yaka mɨdɨdɨvɨsaraayawɨnna kaanna bɨna yaka se waꞌdapi tɨnna wanganna. Tɨnna wanganna yaka Pitarɨ wɨdɨna “Gathaꞌdarevaka? Maalɨka gavegaaꞌna nɨmɨjɨ myeꞌmwanneyemwaalyɨ yɨpɨneihi daaka! ");
INSERT INTO byr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sarɨmɨ yemwaala yapɨjɨ Gotɨyarɨ duzɨla! ‘Kayaaꞌna jɨla!’ Saataanɨ yɨhɨthaabyaꞌnei nyɨhɨvɨramaaradɨka! Sareꞌna Gotɨyarɨ duzɨla! Nebulyasɨ. Sarɨmɨre sɨmunyaꞌ tewaanya yadaawori kɨrɨꞌ kɨlaakejɨꞌ dɨragɨnya maayajɨkɨra.” ");
INSERT INTO byr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sara wɨdɨna yaka ayahidaasɨ wɨna yaka Gotɨyarɨ wɨjaꞌ ayabaaibɨꞌna wɨdɨna “Nɨmwai, taanginya dazaꞌ yɨnɨga manyavɨlayɨ yanneꞌ sarevɨdaaꞌnyɨ taanga dazaꞌ nyana! Sara yajaꞌ yune gɨmɨre sɨmunyabwina yɨmaꞌnana!” ");
INSERT INTO byr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nabaai ayahi bɨna yaka se waꞌdapi tɨnna bwanganna. Sareꞌ dareꞌnesɨ. Kumɨre tɨmakɨrɨkɨryajɨ yadapiyaꞌna se warɨna yesarera. ");
INSERT INTO byr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bwanganna yaka ayahi yagalyaꞌmakuna yaka dahasaai dahaaꞌ Gotɨyarɨ wɨdɨna. Gotɨyarɨ wɨjaꞌ ayagaaꞌ wɨdaka sabaaibɨꞌna wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wɨdɨna yaka dɨvidaaꞌnyɨ mɨdɨdɨvɨsaraayawɨnna bɨna yaka wɨdɨna “Sarɨmɨ se kuna wareva kave damwaaihava! Yɨthaanyi! Nɨmɨnyɨnegaaꞌ mena yɨmaꞌnɨwakegaakɨra. Aꞌmwe kayaaꞌnanyaraavɨna Aꞌmweraavɨne Kaimɨraayainyɨ nyɨbwarɨdaakuvanɨkeinyɨ. ");
INSERT INTO byr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sarɨmɨ dɨkaavapɨjɨ nemɨ kaanya wɨjɨmaꞌnawaana! Yɨthaanyi! Kɨbawe maalɨkeba yɨkamaangeraavɨna nyɨbwarɨdaakuvanɨkei bɨwakelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kuna wɨdadaaꞌnyɨ, yɨthaanyi, Juthaazai sɨvɨlɨrɨdaaꞌnyɨ pwaraalyarajɨyai bɨna. Aꞌmwe kwala naangeꞌ kwaariꞌmasɨramɨnyajɨ kɨlɨkejɨ lɨmwagevera salyɨ yeꞌmwannɨgavɨna. Sahwaraavɨ Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ aꞌmweraavɨne aꞌmwe naangerajɨ maryasaabɨna yesarera. ");
INSERT INTO byr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nabaai aꞌmwe yɨkamaangeraavɨna wibwarɨdaakwiaꞌnei sɨnnawɨ wɨjɨwaainyaꞌneꞌna wɨdɨna “Nɨmɨ aꞌmwe pwarɨ maangwɨdaanyaba buꞌbuta yɨwɨjai sahwalyɨra. Sahwarɨ dɨhalalɨmwagyidelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sara wɨdakei yɨmeꞌnyaꞌbɨꞌ Jizaazaryawɨnna wɨlaabɨna yɨna yaka wɨdɨna “Nyaꞌmwei! Wɨjɨwaakyaigɨ!” Wɨdɨna yaka gamɨnyɨ nayaa buꞌbuta yɨna. ");
INSERT INTO byr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Buꞌbuta yɨna kyaꞌ Jizaazai wɨdɨna “Aꞌmweigɨ, gɨmɨ yaꞌne sanna bɨwaaigɨ ja!” Sagaaꞌ gamɨnyawɨnna kaanna bɨna yeva Jizaazarɨ galalɨmwanna. ");
INSERT INTO byr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sara galalɨmwanna kyeꞌ aꞌmwe pwai Jizaazalyɨ yeꞌmwannemwaaina yakei gamɨrei gamɨre kwaariꞌmasɨramɨnyaꞌ magalabwaꞌnyɨna yaka “Jizaazarɨ yavadaihasamaarɨma!” daka Mubɨthɨka Yɨraꞌde Naangere wɨdaayadere kadɨkiꞌ dakurasɨꞌna. ");
INSERT INTO byr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Dakurasɨꞌna yakegaaꞌ Jizaazai gamɨrerɨ wɨdɨna “Gɨmɨre kwaariꞌmasɨramɨnyaꞌ ayaba dakya! Aꞌmwe yuyara kwaariꞌmasɨramɨnyajɨ maratabɨzaraavɨ kwaariꞌmasɨramɨnyajɨ kayaaka yɨgaidɨvɨsarera. ");
INSERT INTO byr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gɨmɨ myawɨrijɨwaana! Nɨmaamaangerɨ yɨnɨga wiꞌna myɨdaanganyɨ yɨwɨneinyɨ daaka! Sara yɨdaangamwɨjai dahaasagaaꞌ ejelɨya kwalaalya naangeraavɨ aamiya sɨvɨlɨrɨdaaꞌnyɨ pwaraalyarajɨ pwarajɨ saraavɨ nyɨjaavadeinyɨ midaaka! Sara myawɨrijɨwaana! ");
INSERT INTO byr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kɨrɨꞌ sara yɨwɨjaꞌ Gotɨyare pɨkaryaꞌ yuya sasara yɨmaꞌnyaꞌna dɨnɨkeꞌ yuneꞌ gara yɨmaꞌnadevaka!” ");
INSERT INTO byr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dazagaaꞌ Jizaazai kwala bwaꞌnaanyaꞌ wɨdɨna “Kwaariꞌmasɨramɨnyajɨ kɨlɨkejɨ lɨmwanna yadɨvɨꞌ aꞌmwe kuka yɨpalamaaꞌderɨ galapwɨyadɨvɨtabaai yaꞌneihi beva daaka! Yɨrɨka gazagaasagaaꞌ Gotɨyare Angevɨ wɨlamwaaidɨ aꞌmweraavɨ wɨjɨwaakadɨnyagaaꞌ magalanyɨlɨmwagyadɨvɨsaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kɨrɨꞌ pɨropetɨyaraavɨre pɨkarya dɨnɨkengɨ yunebanna yɨmaꞌnyaꞌnenna yuya daza nyɨvanɨgasannanyɨra.” Sara wɨdɨna kyaꞌ mɨdɨdɨvɨsara Jizaazarɨ yagalyaꞌmaꞌna yevera lɨkaanya yɨwɨnamaꞌna. ");
INSERT INTO byr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Aꞌmwe Jizaazarɨ galalɨmwagevera Gotɨyarɨna Mubɨthɨka Yɨraꞌde Naangei Kaayapaazaryawɨnna makuna. Kaayapaazaryabanna Kɨwɨjarajɨ aꞌmwe naangerajɨ yɨꞌbwaꞌnemwaaina yesarera. ");
INSERT INTO byr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Makuna yɨna yadaapi Pitai menyaba mɨjamakuna yaka Gotɨyarɨna Yɨraꞌde Naangere angwaasabanna yɨꞌmaꞌna yaka wɨlɨna yaka wɨdaayadɨvɨsarajɨ yeꞌmwannemwaaina. “Aayaꞌ berɨꞌ yɨmaꞌnadeꞌ dɨngaka? Yawɨranganɨma!” daka yeꞌmwannemwaaina yakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sai mwaaidɨꞌnyɨ Gotɨyarɨna yɨraꞌdɨvɨta naangerajɨ kaajolɨya naanga yuyarajɨ aꞌmwera kwaasɨ jalɨkurakyaꞌneraavɨna bɨrɨna bɨrɨna. Jizaazarɨna kwaasɨ yagaala jaꞌnera sara jalɨkurakyaꞌna “Sahwarɨ tamakaana!” deva bɨrɨna bɨrɨna. ");
INSERT INTO byr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kɨrɨꞌ kwaasɨya nayaa jalɨkurakyaꞌneraavɨ mabɨramaarina. Yɨ aꞌmwe kwalaalyara bɨna yeva kwaasɨ yagaala yaamɨjɨ buthɨna yeva kwaasɨ kwaasɨ kayaaꞌna jalɨkurakɨna yesaꞌna mabɨramaarina. Mabɨramaari kyeꞌ kɨrɨꞌ dɨvidaaꞌnyɨ aꞌmwe pwaraai biꞌmaꞌna yagɨla ");
INSERT INTO byr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","wɨdɨna “Aꞌmwe dazai dara dakelyɨ ‘Gotɨyare Angeꞌ woꞌdaaimwɨneinyɨ. Sara yaꞌmujɨ dahasaai dahaaꞌ ayɨna mamuneinyɨ.’ Sara dakerɨ naarɨmɨ nayaa wɨꞌnolyarɨnera.” ");
INSERT INTO byr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sara kwaasɨ kudahi Gotɨyarɨna Yɨraꞌde Naangei daavɨna yaka gamɨnyɨ wɨdɨna “Aꞌmwe dazaraai yagaala dazaꞌ githaangamanɨgɨlyaꞌna yagaala aane pɨrɨꞌ kɨrɨꞌ majaꞌnawɨdɨzɨwaana?” ");
INSERT INTO byr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kɨrɨꞌ Jizaazai yagaala majai maadɨnna yɨna. Maadɨnna yɨna kyaꞌ Gotɨyarɨna Yɨraꞌde Naangei gamɨnyɨ wɨdɨna “Gotɨya gaala kɨnɨnnakerɨneꞌna dɨragɨnna githaanganɨma! ‘Naanga nebulyaꞌ dɨnedana! Gotɨyai gɨthahɨlakaka gɨmaryasaabakeigɨ Kɨraazɨtɨyaigɨ Gotɨyare Gawaalɨvaangeigɨ daaka?’” ");
INSERT INTO byr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sara wɨdɨna kyaꞌ Jizaazai wɨdɨna “Yɨ dɨwaanya kɨbaaibɨsasɨ. Sareꞌ kɨrɨꞌ yɨhɨthɨvanɨge. Dahaaꞌdaasɨ Aꞌmweraavɨne Kaimɨraayai Gotɨyare aangasɨrɨ, yuya dɨragɨnya kɨnɨnnakere aangasɨrɨ mwaalojɨyarɨ danganyideihɨlyɨ. Nabaai sahwai sɨgunyavɨ yɨraayangɨ yɨlamwaalojɨ walaabathelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sagaaꞌ sara wɨdɨna kyaꞌ Gotɨyarɨna Yɨraꞌde Naangei sɨnna tɨka wɨdaꞌdaaꞌnyɨ gannya baazɨꞌmaꞌnyaꞌ lihɨvainyɨna yaka “Yune aꞌmwei mwaalɨkei kɨrɨꞌ ‘Gotɨyare dɨragɨnyaba mwaalɨdeinyɨ,’ dɨwakeꞌna Gotɨya nawɨꞌnyarɨna bɨrala yɨwakelyɨra,” daka wɨdɨna “Dazai Gotɨyarɨna bɨraiyagaala dɨvanɨka! Sareꞌna kusɨzɨkelyɨra. Ayahi aꞌmwe pwaraavɨ jalɨkurakyaꞌneraavɨ jaka berɨꞌna wɨdaatheinaavaka! Yɨthaanyi! Dahaasagaaꞌ Gotɨyarɨna bɨraiyagaala dɨvanɨkeꞌ kadɨka mena wɨꞌnɨvanɨgava. ");
INSERT INTO byr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sarɨmɨ gara yawɨꞌmwaava?” Sara wɨdɨna kyaꞌ sahwara jaꞌnawɨdɨna “Kayaaꞌnanya kɨnɨnnakelyɨra. Balana!” ");
INSERT INTO byr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wɨdɨna yeva sagaaꞌ gamɨre sɨnnyɨkɨ maagwala wopwakɨna yɨna yeva asa gwaamwanna tamɨna yeva pwara aꞌararaalyajɨ gamɨre maangwɨdaanyawaarɨ jɨrɨꞌbwaratanna yeva ");
INSERT INTO byr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","wɨdɨna “Kɨraazɨtɨyaigɨ mwaaidɨzaigɨ nabaai Gotɨyai gɨthada nedadɨnyaigɨ mwaaidɨzaigɨ dɨnedana! Malyaꞌ aai gɨramwaka!” Bɨraiyagaala saꞌ wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mwasawɨ angwɨrɨsavɨ Pitai mwaaidɨꞌnyɨ aꞌmweꞌ wɨdaayade pɨrɨꞌ gamɨnyawɨnna wɨlaabɨna yaka wɨdɨna “Jizaazai Galɨli mwaalyaryaba gɨmɨ kwaigɨjɨ yeꞌmwannemwaaidɨnyaigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kɨrɨꞌ aꞌmwe yuyaraayaba yuna wɨdɨna “Aawana. Gɨmɨre dɨwaanya dazarɨ nɨmɨ mwanganyɨweinyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wɨdɨna yaka mwasawɨnna walyuna yaka tɨkuryavɨ yɨhulɨvɨlɨyavɨ walyamwaaina. Walyamwaaina yadɨꞌnyɨ aꞌmwe pɨrɨꞌ tɨnna wanganaka saba mwaaidapiyaraavɨ wɨdɨna “Aꞌmwe dazai Jizaazai Naazaretɨ mwaalyalyɨ yeꞌmwannemwaaidelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wɨdɨna kyaꞌ sai ayɨna wɨdɨna “Gotɨyaryaba nebulyaꞌna yɨhɨthɨma! Aꞌmwe dazarɨ mwanganyɨweinyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wɨdɨna kyaꞌ dɨvi maalɨkegaaꞌ aꞌmwe pwara mwaaleva bathakulaawɨna yeva Pitarɨ buthɨna “Naanga nebulyasɨ. Gɨmɨ aꞌmwe sahwarajɨyaigɨnyɨ. Sareꞌ dareꞌnesɨ. Gɨnnya maanguraayaꞌ woꞌdɨmwaaigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Wɨdɨna kyeꞌ sagaaꞌ sai yagaala dɨragɨnna dɨna “Gotɨyai nyangamanɨkeꞌna kwaasɨ yɨhɨthɨwɨjɨ kwajɨ buleꞌna nyɨjaavadeinyɨra! (Daaina!) Aꞌmwe dazarɨ mwanganyɨweinyɨra. Aawa, nebulyasɨ.” Sai mena kadaꞌ yɨmeꞌnyaꞌbɨꞌ kukuraayai jaka dɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jaka dɨna kyaꞌ Pitai Jizaazare yagaalyaꞌ wɨdakeꞌ ayɨna yawɨꞌna “ ‘Kukuraayai jaka majadozɨ dahasaai dahaaꞌ dara dɨthatheigɨnyɨ “Sahwarɨ mwanganyɨvanɨgeinyɨ.” ’ ” Sara yawɨꞌna yaka yune mwasawɨnna walyuna yaka kɨnna naanga walyadɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yɨrɨkeꞌ mena kavuraꞌ Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ aꞌmweraavɨre aꞌmwe naangerajɨ sara yagaaikɨwɨnya Jizaazarɨ tamakyaꞌna jamungajakɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mena jamungajakɨna yeva wɨla pwɨyɨna yeva Gaꞌmaanɨya naangei Paailatɨmyawɨnna makuna yeva wɨjavaawɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sagaaꞌ Juthaazai yɨkamaangeraavɨna Jizaazarɨ wibwarɨdaakwakei dara wanganakeꞌ “Kotɨyavɨ walamarakadɨvɨꞌ ‘Balana!’ dɨragɨnna dɨwaasai daaka!” Sara daka sɨmunya mudɨkebwi yawɨꞌna yɨna yaka nɨgwia sɨlɨvaaya (30) daza ayɨna makabɨna yaka Gotɨyarɨna yɨraꞌdɨvɨta naangerajɨ aꞌmwe naangerajɨ saraavɨna yaamɨjɨ wɨjaavɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Sai wɨdɨna “Nɨmɨ kayaaꞌna yɨweinyɨra. Aꞌmwei kayaaꞌnanya maayarɨ gamɨre yɨkamaangeraavɨna wibwarɨdaakuweinyɨra. Sarei tawesɨ baladeꞌna nɨmɨre yɨwetawakyasɨ.” Kɨrɨꞌ sahwara wɨdɨna “Sasare saꞌ nemɨrevɨdaasɨ daaka! Aaya kaavɨlyaꞌ gɨmɨrevɨdaasɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sara wɨdɨna kyeꞌ Gotɨyare Angevɨ nɨgwia sɨlɨvaaya (30) wasɨꞌna yaka gamɨ sai wɨla lɨvapwaraawɨna yɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kɨrɨꞌ Gotɨyarɨna yɨraꞌdɨvɨta naangera nɨgwia sɨlɨvaaya daza maarɨna yɨna yeva dɨna “Nɨgwia datha aꞌmwerɨ tamakyaꞌnenna nɨgwiangɨra. Sareꞌna Gotɨyare Angevɨne nɨgwiangɨjɨ yeꞌmwagakya myaannera!” ");
INSERT INTO byr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yagaala pɨrɨꞌ jamungajakɨna yɨna yeva nɨgwia dazajɨ wawɨnya pɨjɨꞌ kwadɨka yavɨkaryaderejɨꞌ woꞌnɨkejɨꞌ mubɨna. Aꞌmwe anga menyabadaasaraavɨna gɨlekaviꞌnɨnnyaba lɨkyɨrakyaꞌnera sajɨꞌ mubɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sarevɨ wawɨnya dazajɨꞌ yaya dɨnɨkeꞌ “Wawɨnya Tawanakejɨkɨra.” Nabaai yaya dazaꞌ dahaaꞌ kuna warɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sara kyeꞌ sagaaꞌ yagaala pɨrɨꞌ sɨnnawɨ Gotɨyai Ne pɨropetɨya Jeremaayarɨ wɨjaakeꞌ yuneꞌna yɨmaꞌnakesɨ. Dara dɨnɨkesɨ. Nɨgwia sɨlɨvaaya (30) sa Yɨzɨrelɨyarajɨya pwarɨ mubyaꞌne sɨlɨvaaya dahɨlaketa daza maarɨna yeva ");
INSERT INTO byr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Naangei nyɨdakabaaibɨꞌ kwadɨka yavɨkaryadere wawɨnyajɨꞌ mubyaꞌnera wɨjaavesangɨra. Sara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gaꞌmaanɨya naangeryaba Jizaazai daavɨna yadɨꞌnyɨ Gaꞌmaanɨya naangei yɨdaanganna “Gɨmɨ Juyaraavɨre kingɨyaigɨ daaka?” Yɨdaanganna kyaꞌ Jizaazai wɨdɨna “Yɨ dɨwaanya kɨbaaibɨsasɨ.” ");
INSERT INTO byr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sagaaꞌ Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ aꞌmwe naangerajɨ sahwarɨ kotɨyaꞌ marina. Kɨrɨꞌ sahwai majaꞌnawɨjɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Majaꞌnawɨjɨ kyaꞌ sagaaꞌ Paailatɨ wɨdɨna “Yagaala yuya kotɨya gɨmarivanɨgata daza kadɨka muꞌnyɨjɨvanɨgɨna!” ");
INSERT INTO byr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wɨdɨna kyaꞌ sahwai yagaala pɨrɨꞌ majaꞌnawɨjɨ. Sarevɨdaaꞌnyɨ Gaꞌmaanɨya naangei atɨka naanga maruꞌnaꞌna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kwarame yuya sangɨ Munne savɨ Gaꞌmaanɨya naangei aꞌmwe kalavuza pwarɨna yɨralawaasadelyɨ. Kwala bwaꞌnaanyaꞌ aꞌmwe gave pwarɨna dɨna yadaapi Paailatɨ yune gave saina yɨralawaasɨna wiadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nabaai dazagaaꞌ kalavuzangevɨ aꞌmwe kayaaꞌnanya pwarɨna kadɨka wɨꞌnadɨvɨsai mwaalɨna. Sahwai Baravaazai woꞌnɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Sarevɨdaaꞌnyɨ kwala bwaꞌnaanyaꞌ yɨꞌbwaꞌnaabɨna yɨna kyeꞌ Paailatɨ wɨdɨna “Sarɨmɨnyawɨnna yɨhiralawasaabɨdeꞌna aaihwarɨna yawɨꞌmanɨgava? Baravaazarɨ yɨralawaasɨjɨwana? Jizaazarɨna sahwara dɨna ‘Kɨraazɨtɨyarɨnera,’ dadɨvɨsarɨ yɨralawaasɨjɨwana?” ");
INSERT INTO byr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sara wɨdakeꞌ dareꞌnesɨ. Sahwai yawɨꞌna “Jizaazarɨna sɨmunya kayaaꞌna jawɨꞌmanɨgava! Tɨganaaryaꞌna kotɨya marina yɨvanɨgaꞌ.” ");
INSERT INTO byr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paailatɨ yawɨbwaꞌdere namwaalyɨsarɨ yɨlamwaaina yɨna yadɨꞌnyɨ gamɨre aꞌmweꞌ yagaalyaꞌ dara wɨdasaabɨna “Aꞌmwe yɨdaꞌmaraanga dazarɨna minnera! Sawɨsavɨ nɨmɨ wajaꞌ yaꞌnena banganakelyɨra. Sara yaꞌnena taanga naanga nyɨmwakeꞌnyɨra. Sareꞌna minnera!” ");
INSERT INTO byr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sara wɨdasaabɨna kyaꞌ kɨrɨꞌ Gotɨyarɨna yɨraꞌdɨvɨta naangerajɨ aꞌmwe naangerajɨ kwala bwaꞌnaanyangɨre sɨmunyavɨ yɨdɨkavɨmwaaihɨna “Paailatɨmɨna jaka kadapi Baravaazarɨ kudaasojɨ Jizaazarɨ tamakɨpɨꞌdeꞌnana!” ");
INSERT INTO byr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yɨdɨkavɨmwaaihɨna kyeꞌ Gaꞌmaanɨya naangei yaamɨjɨ wɨdɨna “Aꞌmwe dazaraarɨdaaꞌnyɨ aaihwarɨ yɨralavɨjɨwana?” Wɨdɨna kyaꞌ sahwara dɨna “Baravaazai.” ");
INSERT INTO byr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dɨna kyeꞌ Paailatɨ wɨdɨna “Sarevɨdaaꞌnyɨ Jizaazarɨ sahwara ‘Kɨraazɨtɨyarɨnera,’ dadɨvɨsarɨ gara yɨjɨwana?” Wɨdɨna kyaꞌ yuyara wɨdɨna “Yɨsavɨri dɨmarayeramyɨla!” ");
INSERT INTO byr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kɨrɨꞌ Paailatɨ wɨdɨna “Beꞌnanaka! Be kayaaꞌnanya yɨwakalaka!” Kɨrɨꞌ jaka naanga dɨragɨnna danganna “Yɨsavɨri dɨmarayeramyɨla!” ");
INSERT INTO byr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Sagaaꞌ Paailatɨ yɨbwakɨnna “Nɨmɨre yagaalyaꞌ yɨnɨga wiꞌna mi yadeꞌ daaka! Sarevɨ mala naangeꞌ dɨkaavajɨwaka!” Sarei aalya pɨrɨꞌ maarɨna yaka kwala bwaꞌnaanyayaba gamɨre asɨraarɨ aalya yɨnyɨna. Sara yaka wɨdɨna “Aꞌmwe dazai balajaꞌ kayaaꞌnanyaꞌ nɨmɨreꞌ mɨka! Yune sarɨnnyaburɨnyɨra. Sarevɨdaaꞌnyɨ nɨnnya ata aalya yɨmwana!” ");
INSERT INTO byr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wɨdɨna kyaꞌ aꞌmwe yuyara jaꞌnawɨdɨna “Gamɨre taweꞌna yɨwetawakya dazaꞌ nemɨnyawɨnna nabaai nemɨre kaimɨraaya kwaraavɨjɨ bathesɨra.” ");
INSERT INTO byr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wɨdɨna kyeꞌ sagaaꞌ Paailatɨ Baravaazarɨ yɨralawaasɨna yɨna. Yɨralawaasɨna yɨna yaka Jizaazarɨ wɨla kayaaꞌnanyabaalyɨ lɨꞌbwaꞌna yɨna yaka “Yɨsavɨri nilɨya marayerabɨka!” daka aawɨlasaraavɨ wɨmaarina yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Dazagaaꞌ Gaꞌmaanɨya naangere aawɨlasara Jizaazarɨ Gaꞌmaanɨyare angevɨna makuna, sagaaꞌ sahwaryabanna yuyavaakɨyara yɨꞌbwaꞌnaabɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yɨꞌbwaꞌnaabɨna yɨna yeva gamɨre baazɨꞌmaꞌnya saza galyɨraipuꞌna yɨna yeva baazɨꞌmaꞌnya wayaaka nawɨꞌnya pɨrɨꞌ baazɨꞌmakuna. Kingɨyara baazɨꞌmaꞌnya saꞌ baazɨꞌmaꞌnadɨvɨsaꞌ sara baazɨꞌmakuna. ");
INSERT INTO byr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Baazɨꞌmakuna yeva wɨla lannakebaarɨ kingɨyare nyɨlɨla pwaibɨsaꞌ gɨtavagwavaaihɨꞌna yeva gamɨre mɨnyagɨnyavɨ yɨlamwaaihɨꞌna. Sara yeva suya pɨrɨꞌ kwaasɨya kingɨyare yɨsarɨꞌ gamɨre aangasɨmagɨ wɨmwangɨna yeva “Sahwai kwaasɨya kingɨyai yɨmaꞌnɨwaka. Sarevɨ bɨrala yaana!” yawɨꞌna yadɨvɨꞌ sahwarɨ kwadaai gɨlɨna yeva bɨraiyagaala wɨdanganna “Juyaraavɨre kingɨyaigɨ! Tewaanya dɨmwaala!” ");
INSERT INTO byr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bɨraiyagaala wɨdanganna yadɨvɨꞌ maagwalyajɨ wopamɨjɨrakɨna yadɨvɨꞌ suya sarɨꞌ maarɨna yeva gamɨre mɨnyagɨnyavɨ maratanna yadɨvɨꞌ sara yɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sara yɨna yɨna yeva bɨrala mena yɨna yeva baazɨꞌmaꞌnya saꞌ galyɨraipuramaaꞌna yɨna yeva gannya baazɨꞌmaꞌnya ayaꞌ marabaazɨꞌmakuna. Ayaꞌ marabaazɨꞌmakuna yeva yɨsavɨri nilɨya maratamarɨmwiaꞌnera gamɨnyɨ kaanna makuna. ");
INSERT INTO byr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kaanya wodɨvɨsagaaꞌ aꞌmwe Saairini mwaalya pwarɨ gamɨnne yayaꞌ Saaimonɨ, yɨ sarɨ tɨnna wanganna. Tɨnna wanganna yeva sahwarɨna dɨragɨnna dɨna yeva Jizaazarɨne yɨta yovihɨrarannɨkeꞌ makwɨyaꞌna. Dɨragɨnna kyeꞌ aꞌmwei yɨta makuna yada ");
INSERT INTO byr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","pɨba Golɨhota woꞌnɨkebanna yɨꞌmavaawɨna. Yaya savɨna aaya kaavɨlyaꞌ daresɨ. Pɨba Gɨlemɨnyagɨnyabanna. ");
INSERT INTO byr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yɨꞌmavaawɨna yeva waainɨya marazɨnanya yɨrɨkesɨ yegɨnyɨwannɨkeꞌ daangeꞌneꞌ maarɨna yeva “Sai nana!” deva wɨjaavɨna. Kɨrɨꞌ nagaanganna yaka “Aala!” dɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","“Aala!” dɨna kyaꞌ yɨsavɨri nilɨya mena tameva “Gamɨre baazɨꞌmaꞌnya saza yamaraana!” deva saatuyara maragɨrɨdaꞌna. Saatuyara maragɨrɨdaꞌna yeva baazɨꞌmaꞌnya jaapaina yeva pwai pɨrɨꞌ pwai pɨrɨꞌ maarɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Maarɨna yeva sahɨba walamwaaina yɨna yeva sahwarɨ maremwaaina. ");
INSERT INTO byr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Munyaba gamɨre mɨnyagɨnyavɨ munyaba gamɨnyɨne yagaala kotɨya maryesaꞌ yɨlayɨdawakɨna yesasɨ. Dara yɨdavesaꞌ “Dathai Jizaazalyɨ. Juyaraavɨre Kingɨyalyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jizaazaryaba gidɨkusaba yɨsavɨri kuka yɨpalamaaꞌdisaraarɨ nilɨya maratamarɨmuna. Aangasɨmagɨ pwarɨ kwanaamimagɨ pwarɨ maratamarɨmuna yesaraalyɨ. ");
INSERT INTO byr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aꞌmwe kaanya yɨnadaaꞌdɨvɨsara sahwarɨ bɨraiyagaala danganna. Kumɨre mɨnyagɨnyarɨ wɨnaangɨwɨnaangɨta yadɨvɨꞌ ");
INSERT INTO byr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","bɨraiyagaala dara danganna “Gotɨyare Angeꞌ woꞌdalakadɨ ‘Dahasaai dahaaꞌ ayɨna madɨdesɨra,’ jaigɨ gɨmɨ saigɨ dɨvadaihasamaaꞌnana! Gɨmɨ Gotɨyare Gawaalɨvaangeigɨ mwaaidɨzaigɨ yɨta yovihɨrarannɨka savɨ yagalyaꞌmavaꞌgɨzɨ dalaama!” ");
INSERT INTO byr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sasarebaaibɨꞌ Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangera Kɨwɨjarajɨ aꞌmwe naangerajɨ sarajɨ bɨraiyagaala wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Gamɨ padaihasamaaryaꞌnei aꞌmwe pwaraavɨ gaimwanna yaka gamɨ sai yɨnɨga gaimwannannei mɨka! Gamɨ Yɨzɨrelɨyaraavɨ kingɨyai midaaka! Yɨta yovihɨrarannɨkevɨ yagalyaꞌmavojɨ kwalaabozɨ sahwarɨ dɨragɨnna yawɨralɨmwagaatheꞌnana! ");
INSERT INTO byr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Gotɨyarɨna gannya sɨmunyavɨ dɨkavɨmwaaihɨnyɨna yakei midaaka! Gotɨyai sahwarɨna wɨvuꞌnajai dahaasagaaꞌ padaihasamaarana! Sareꞌ dareꞌnesɨ. Sahwai dɨna ‘Gotɨyare Gawaalɨvaangeinyɨra.’ ” ");
INSERT INTO byr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bɨraiyagaala sara wɨdetabaaibɨꞌ kuka yɨpalamaaꞌdisaraarɨ Jizaazaryaba yɨsavɨri maratamarɨmwesaraai bɨraiyagaala wɨdahɨlyaraalyɨ. ");
INSERT INTO byr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sɨrɨgwajahaaꞌdaaꞌnyɨ kwaaka yuneba jɨhɨnyaꞌ jɨnnadaaꞌnyɨyagaaꞌ yune sɨvɨraryagaaꞌna miꞌna yɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sɨvɨraryagaaꞌ aya kɨgaaꞌ Jizaazai Yɨvɨruyagaala jaka dɨragɨnna dɨna “Yɨli, Yɨli, lama savakɨtaani?” Saꞌ daresɨ. Nɨmɨre Gotɨyaigɨ, nɨmɨre Gotɨyaigɨ, beꞌna nyagalyaꞌmaꞌmwaana! ");
INSERT INTO byr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jaka sara dɨna kyaꞌ sahɨba daavesarajɨya pwara saꞌ kadɨka wɨꞌnyɨna yeva dɨna “Aꞌmwe dazai Ne Yɨlaajarɨ jaka wɨdɨvanɨka.” ");
INSERT INTO byr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sara dɨna kyeꞌ yɨmeꞌnyaꞌbɨꞌ kumɨjɨya pwai kaanyaveꞌna wawaka saalaalyavɨya jɨꞌmɨnya pɨrɨꞌ maraawɨna yɨna yaka yɨrɨkaalyavɨ marapaihɨna yaka aalɨnakeꞌ suya pɨrɨkɨ yɨlamarakɨna yaka “Nana!” daka wɨjaavɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kɨrɨꞌ pwara dɨna “Kavaaya! Nemɨ tɨnna mena wanganawaajɨna. Yɨlaajai padaihasamaraabazarɨ tɨnna wanganaadeꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sara dɨna kyeꞌ Jizaazai jaka naanga dɨragɨnna ayɨna dɨna yaka gamɨre kuryarɨ yaasɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yɨthaanyi, Gotɨyare Angevɨ kusawɨnya tɨkuryavɨ janne naangeꞌ majɨkɨnadaaꞌdeꞌ munya keꞌba lihɨꞌna yakeꞌ yune kewɨnɨnna sara yaka pimagɨnyaai yɨmaꞌnyɨna. Sara yaka Kwaakevaꞌ wɨnɨnya yɨna yada sɨlaange tɨngɨraꞌna. ");
INSERT INTO byr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sara yaka gɨlekaviꞌnɨnnya basɨnadaaꞌna yaka tewaanyara sɨnnawɨ se mena bainɨkera kwalaalyaraavɨre kɨlaakejɨka ayɨna yɨdɨkaaꞌna. ");
INSERT INTO byr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yɨdɨkaaꞌna kyaꞌ kaviꞌnɨnnyangɨ yagalyaꞌmaꞌna yeva Jizaazai ayɨna mena dɨkaavakegaaꞌ anga naanga tewaanyabanna Jeruzaalemɨna wɨna. Wɨna yeva aꞌmwe kwalaalyaraayaba wɨjɨwaainyɨna kyeꞌ sahwaraavɨ tɨnna wanganna yesarera. ");
INSERT INTO byr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Wɨnɨnya yakevɨ aawɨlasaraavɨ maremwaalyalyɨ aawɨlasarajɨ Jizaazarɨ dame maredaata yesara tɨnna wanganna yeva nabaai nabinabinya yɨmaꞌnyɨna yadaapiyangɨ tɨnna wanganna yeva lɨka naanga yɨna. Lɨka naanga yɨna yadɨvɨꞌ dɨna “Naanga nebulyasɨ. Aꞌmwe dazai Gotɨyare Gawaalɨvaangelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Dazaba aꞌmwe kwalaalya kɨbaweba keiba paaꞌbwaꞌna daavɨna yeva banganaꞌna yadɨvɨꞌ mwaalesangɨra. Aꞌmwe daza Galɨli yagalyaꞌmaveva “Sahwarɨ wɨgaimwagaana!” devengɨra. ");
INSERT INTO byr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Sajɨya aꞌmwe pɨrɨꞌ Maarɨyaaꞌ Maahɨthaala mwaalyasɨ nabaai pɨrɨꞌ Jemɨzalyɨ Jozepɨyalyɨ saraarɨ ganaangeꞌ Maarɨyaasɨ, pɨrɨꞌ Sevathiyare gawaalɨvaangeraarɨ ganaangesɨ sa mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sawɨtɨrɨnyabwi kimaꞌnaꞌ aꞌmwe pwai wɨna. Sai gɨlyɨvɨta naangejɨyai Aarɨmathɨya mwaalyai Jozepɨyai woꞌnɨkelyɨ. Sahwai Jizaazarɨ mɨdɨdei mwaalaꞌ. ");
INSERT INTO byr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Sai Paailatɨmyawɨnna wɨna yaka Jizaazare kɨlaakejɨꞌ maaryaꞌna yɨdaanganna. Yɨdaanganna kyaꞌ sagaaꞌ Paailatɨ aawɨlasaraavɨ dɨragɨnna wɨdɨna kyaꞌ Jozepɨyarɨ gɨlaayai wɨmaarina. ");
INSERT INTO byr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Wɨmaarina kyeꞌ Jozepɨyai gɨlaayarɨ maarɨna yaka kwaabɨhannya yaaka nawɨꞌnyaꞌ maarɨna yaka marayewaaꞌmwanna. ");
INSERT INTO byr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sara yɨna yaka gannya simaanga mudɨkevɨ gɨlaayarɨ kave wɨlakɨna. Simaanga saꞌ sɨlaanga pwarɨ lɨlɨsamakulaawɨnɨkesɨ. Kave wɨlakɨna yaka sɨla naanga sai maramwarangɨkulaawɨna yaka kaviꞌnɨmaangevɨ sɨlyaꞌ tihɨrakɨna yaka kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jozepɨyai kɨlaakejɨꞌ wakadaaꞌnyɨ dazaba simaangevɨ akyamwi aꞌmwewaai walamwaaina. Aꞌmwe pɨrɨꞌ Maarɨyaaꞌ Maahɨthaala mwaalyaꞌ, yɨ pɨrɨꞌ Maarɨyaa pɨrɨꞌ gɨryawoꞌnyaꞌ. Aꞌmwe sawaai keiba walamwaaina yagi. ");
INSERT INTO byr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yɨrɨka dɨvidaaꞌnyarɨkɨ, kwazaakegaaꞌna yovɨrawakyaꞌnegaaꞌ dɨvidaaꞌnyarɨkɨ Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ Perɨzɨyarajɨ Paailatɨmyawɨnna biꞌbwaꞌnemwaaina. ");
INSERT INTO byr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Biꞌbwaꞌnemwaaina yeva wɨdɨna “Maremwaalyaigɨ! Aꞌmwe kwaasɨya dazai kuna mwaalakegaaꞌ nedakeꞌ mena yawɨꞌmwo. Dara dɨna ‘Dɨvidaaꞌnyɨ yɨrɨka darɨkaai darɨkɨ ayɨna dɨkaavɨdeinyɨra.’ ");
INSERT INTO byr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Sarevɨdaaꞌnyɨ gɨmɨ nayaa kadaꞌgɨzɨ yune yɨrɨka darɨkaai darɨkɨnannevɨ simaanga dazavɨ nayaa tihɨpɨꞌdeꞌnanyɨ. Gamɨre mɨdɨdɨvɨsara kuka bulalɨvamaarapɨri aꞌmweraavɨ nudɨpɨdɨka! ‘Kaviꞌnɨnnyavɨdaaꞌnyai ayɨna mena dɨkaaꞌmwakerɨnera.’ Sara kudapɨri dɨvidaaꞌnyɨ kwaasɨyabwi kɨgaasa kwaasɨyaburɨ navɨlavadɨka!” ");
INSERT INTO byr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Sara wɨdɨna kyeꞌ Paailatɨ wɨdɨna “Sarɨmɨ aꞌmwe dame daayaꞌne pwaraavɨ dɨmaaryɨla! Sarɨmɨ wawapɨjɨ simaanga dazavɨ dameraavɨ dɨthaakwila! Sarɨmɨ nayaa miꞌna yawɨꞌna yɨpɨnebaaibɨꞌ dameraavɨ dɨthaakwila!” ");
INSERT INTO byr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Sara wɨdɨna kyaꞌ sahwara kaanna wɨna yeva gɨlekaviꞌnɨnnyavɨ dame daakuna. Sɨla sarɨ baavesɨ wakɨna, kaanya tɨlɨna yeva saba dame daayaꞌneraavɨ wɨdɨmwaaihɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kwazaakegaaꞌ mena kabawoꞌ wikɨyarɨkɨne yɨrɨka mudɨkerɨkɨ yɨrɨkunyagaaꞌ Maarɨyaaꞌ Maahɨthaala mwaalyasɨ Maarɨyaa pɨrɨsɨ gɨlekaviꞌnɨnnyabanna wanganyaꞌnewaai wɨna. ");
INSERT INTO byr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yɨthaanyi! Sagaaꞌ wɨnɨnya naangeꞌ yɨna. Sareꞌ dareꞌnesɨ. Sɨgunyavɨdaaꞌnyɨ Naangere ejelɨyai walaabɨna yaka sɨlyai birɨkwasamakulaawɨna yɨna yaka sɨlyarɨ aꞌba yɨlamwaaina. ");
INSERT INTO byr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sahware sɨnnyɨꞌ yɨnamɨraasaꞌbɨꞌ wannyɨna, nabaai gamɨre baazɨꞌmaꞌnyaꞌ sɨgujaakavɨre yaakebɨꞌ wannyɨna yakelyɨra. ");
INSERT INTO byr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Gamɨnyɨna aawɨlasara lɨka naanga yɨna yeva bɨꞌbɨta yɨna yeva aꞌmwe mena bainɨkerabɨꞌ yɨmaꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yɨmaꞌnyɨna kyeꞌ ejelɨyai aꞌmwe sawaarɨ wɨdɨna “Kɨrɨmɨ lɨka mɨkanera! Nɨmɨ yawɨꞌna ‘Jizaazarɨ yɨsavɨri tamarɨmuwaꞌdaasarɨna bɨrɨkaanyawaaihi bɨvanɨgɨla.’ Sareꞌna lɨka mɨkanera! ");
INSERT INTO byr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Sai dava mamwaalyɨka! Sareꞌ dareꞌnesɨ. Kɨgaaꞌ dakabaaibɨꞌ mena yɨdɨkaaꞌmwakerɨna! Gamɨ waꞌde adava bulanganyɨla! ");
INSERT INTO byr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nabaai yarai wawakɨlyɨ gamɨre mɨdɨdɨvɨsaraavɨ duthaawila! ‘Kaviꞌnɨnnyavɨdaaꞌnyɨ mena yɨdɨkaaꞌmwakelyɨ. Nabaai, yɨthaanyi, Galɨlinei sarɨmɨnyɨ sɨnnawɨ waanadelyɨ. Dazɨmagɨ sahwarɨ tɨnna danganyiderɨna.’ Yɨthaanyi, mena yɨhɨthɨwa.” ");
INSERT INTO byr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wɨdɨna kyaꞌ sawaai lɨka yadiꞌ yɨlaaya kuna kuna yɨna yadiꞌ simaangeyaba yarai yagalyaꞌmaꞌna yagɨla gamɨre mɨdɨdɨvɨsaraavɨ wɨjaꞌnewaai kaanyaveꞌna wɨna. ");
INSERT INTO byr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kaanyaveꞌna wɨna yadaakɨlyɨ, yɨthaanyi, tusavɨ Jizaazai sawaaryabanna yɨmaꞌnadavaabɨna yaka wɨdɨna “Nyaꞌmwewaaihi! Tewaanya kwaamuꞌnanyabwi yɨhwarana!” Wɨdɨna kyaꞌ sawaai aya kɨbanna wɨlaabɨna yagɨla gamɨre sɨvɨlyaraarɨ lɨmwanna yagɨla lotuya wina. ");
INSERT INTO byr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Dazagaaꞌ Jizaazai sawaarɨ wɨdɨna “Lɨka mɨkanera! Wawakɨlyɨ nyaꞌmweraavɨ Galɨlina wɨpɨꞌdeꞌna duthaawila! Nabaai dazahimagɨ nyangabɨꞌdeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aꞌmwe sawaai kuna wodaakɨri, yɨthaanyi, dame pwara gɨlekaviꞌnɨnnyaba maredaavesara anga naangeba wɨlɨna yɨna yeva yuya yɨmaꞌnaka sanna Gotɨyarɨna yɨraꞌdɨvɨta naangeraavɨ wɨdɨna. Sara wɨdɨna kyeꞌ ");
INSERT INTO byr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","sahwara aꞌmwe naangerajɨ yɨꞌbwaꞌnemwaaina yɨna yeva yagaala pɨrɨꞌ jamungajakɨna yeva dameraavɨ nɨgwia kwalaalya wɨjaavɨna yɨna yeva ");
INSERT INTO byr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","wɨdɨna “Nɨgwia dazanna maarapɨri dara dɨzideihɨlyɨ ‘Sawɨsavɨ nemɨ se waꞌdori gamɨre mɨdɨdɨvɨsara lɨka yulyaꞌna beva gɨlaayarɨ kuka bamaryawaaihasarera.’ Duzideꞌna yɨhɨmubɨwo. Sara kadapɨjɨ ");
INSERT INTO byr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gaꞌmaanɨya naangei yagaala dazaꞌ kadɨka wɨꞌnajarɨ woyagaala wɨdawaajɨ sarɨmɨ sɨmunya kwalaalya myawɨryaꞌneihɨrɨ yɨhɨmwaihaadeihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sara wɨdɨna kyeꞌ damera nɨgwia sa maarɨna yɨna yeva sara wɨdetabaaibɨꞌ sara yɨna. Sara yɨna yadɨvɨꞌ yagaala dazaꞌ Juyara gazabazaba wɨꞌnyɨna yeꞌ. Nabaai dahaasagaaꞌ dazaꞌ Juyara kuna wɨdadɨvɨsasɨ. ");
INSERT INTO byr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Sɨvɨlɨrɨdaaꞌnyɨ pwainanyara Galɨlinera kaanna wɨna yeva mugunya Jizaazai sahɨbanna sara dakebanna yɨꞌmavaawɨna. ");
INSERT INTO byr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yɨꞌmavaawɨna yeva gamɨnyɨ tɨnna wanganna yeva lotuya wɨmarina. Lotuya sara wɨmarina yadɨvɨꞌ kɨrɨꞌ pwai pwai sɨmunya pɨrɨwaai yawɨꞌna. ");
INSERT INTO byr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sara yadɨvɨꞌ yuyaraayawɨnna wɨlaabɨna yaka dara wɨdɨna “Sɨgunyavɨjɨ Kwaakevakɨjɨ sabanyaarɨ dɨragɨnyaꞌ Gotɨyai nyɨjaavakeinyɨ. Dɨragɨnya yuya pɨnɨngɨna wavɨlaꞌdɨnyainyɨra. Wawɨnya yuya sabanyaai maremwaaidɨnyainyɨ. ");
INSERT INTO byr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sarevɨdaaꞌnyɨ sarɨmɨ Kwaaka davakɨya ajɨmya pɨnɨngɨyara nɨmɨre nyɨmɨdɨdɨvɨsara yɨmaꞌnɨpɨꞌdeꞌna duthaawila! Nɨmwalyɨ Gawaalɨvaangeinyɨjɨ Kurya Tewaanyalyɨ sainaavɨre yayavɨ aꞌmweraavɨ aalyavɨ bavɨtaazɨya jideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nabaai sara yapi yagaala yɨhɨzaave gazazanna mɨdɨnyaꞌneraavɨ duziwakamaryideihɨlyɨra. Yɨthaanyi! Yuyagaaꞌ yune aayaꞌne dazagaaꞌna sarɨmɨjɨ yeꞌmwannamwalaadeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gotɨyare Gawaalɨvaangei Jizaazai Kɨraazɨtɨyai gamɨre yagaala tewaanya mudɨkeꞌ sɨnnawɨ yɨmaꞌnaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Gotɨyare wɨꞌnawɨjɨwaakakei Pɨropetɨya Aazaayai dara dɨnɨꞌ Jizaazarɨna, “Yɨthaa, nɨmɨre wɨdaasadɨnyai gɨmɨnyɨna waamanɨꞌ. ‘Gɨmɨre tusavɨ nayaa yadera,’ gɨthɨwa. ");
INSERT INTO byr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Wawɨnya maayaba jaꞌmaanguraayaꞌ yɨmanɨꞌ, ‘Naangei batherɨne tusaꞌ javadaꞌgalyɨlo! Gamɨre tusangɨ yɨdaꞌna jamakwilo!’ ” ");
INSERT INTO byr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Sara dɨnɨkeꞌna Jonɨ wawɨnya maayaba mwaalaka sɨnnawɨ sagaaꞌ aꞌmweraavɨ aalyavɨ bavɨtaazɨya yada wɨdɨna “Sarɨmɨre sɨmunyabwi mudɨkebwi yawɨramaaꞌna kyapɨjɨ nɨmɨ bavɨtaazɨya yɨhyɨdeinyɨ. Gotɨyai sarɨmɨre kayaaꞌnanyabwi yɨhɨmarasɨꞌnadelyɨra,” wɨdɨna Jonɨ. ");
INSERT INTO byr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sara wɨdɨna yadaaꞌnyɨ “Gamɨnyawɨnna wawaajɨ yagaala saꞌ kadɨka wɨꞌnaana!” deva Kwaaka Juthɨya mwaalyarajɨ Anga Jeruzaalemɨ mwaalyarajɨ yuyara wɨna. Miꞌna wɨna yeva gamɨre yagaalyaꞌ wɨꞌneva wɨjalɨkurakɨna “Nebulyasɨra. Nemɨ kayaaꞌnanyabwi sana sana yɨwosɨra.” Wɨdɨna kyeꞌ Aalya Jothanɨyavɨ bavɨtaazɨya yaꞌ Jonɨ. ");
INSERT INTO byr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jonɨ baazɨꞌmaꞌnya kaamelɨyavɨre arɨlyaꞌ yavɨkarinɨkeꞌ mariraꞌnyɨna yaka bulɨmakaawomunnaanya marida mwaalakelyɨ. Gannya wapaaya baarɨnnajɨ aakangɨre kwarakajɨ tɨka nada mwaalakei. ");
INSERT INTO byr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yagaala daꞌ wɨdɨna “Nɨmɨ bɨweinyɨ. Dɨvi pwai bathelyɨra. Nɨmɨre dɨragɨnyaꞌ waꞌdɨꞌnyɨ kɨrɨꞌ gamɨre dɨragɨnya naangeꞌ nabaai wavɨlaꞌna yadesɨ nɨmɨrevɨ. Naangere kwaariꞌmasɨvɨlyavɨ wɨla pwɨyɨnɨkeꞌ kwadaai gɨlaꞌmwi galyaaꞌmuneꞌ nɨmɨ naangeinyɨ mɨka. Myɨwɨneinyɨra. ");
INSERT INTO byr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nɨmɨ aalya gavevɨ bavɨtaazɨya yɨhyɨvanɨge saꞌ Naangei Kurya Tewaanyarɨ bavɨtaazɨya yɨhyadelyɨra,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jonɨ sara wɨdadaasɨyagaaꞌ Kwaaka Galɨli Anga Naazaretɨdaaꞌnyai Jizaazai bɨna kyaꞌ Aalya Jothanɨyavɨ Jonɨ bavɨtaazɨya yɨna. ");
INSERT INTO byr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Miꞌna bavɨtaazɨya yɨna kyaꞌ aalyavɨ sai bilaawaka yɨmeꞌnyaꞌbɨꞌ dara wanganakeꞌ “Sɨgunyaꞌ tɨvɨ damujaangɨka! Kekwai Kuryai kwaamɨryaibɨsai daimwaabɨka!” Mena kadaꞌ Kuryai walaabɨna yaka gamɨre munyɨkɨ kusawɨ bulamwaaina. ");
INSERT INTO byr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bulamwaaina kyaꞌ Sɨgunyavɨdaasɨ Gotɨyarebadaasɨ Gotɨyai yagaala wɨdɨna “Saigɨ, nɨmɨre Nyɨbwaalɨvaangeigɨnyɨ. Kurya tewaanya gukadɨnyaigɨnyɨ. Sahwaigɨ yɨlaaya nyɨgaimanɨgɨ,” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yɨmeꞌnyaꞌbɨꞌ Kuryai “Aꞌmwera maayabanna yarai dɨwo!” jɨrɨꞌgalaasaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jɨrɨꞌgalaasɨna kyaꞌ sahwai kaanna wɨna kyaꞌ yɨrɨka aꞌmweraare sɨvɨlatɨraai kwavɨlavaꞌ aꞌmwera maayaba mwaaidɨsɨ Saataanɨ “Kayaaꞌnanyabwi yana!” daka yaamɨjɨ yɨjɨwaalaꞌ. Yɨjɨwaaina yakegaaꞌ malakayaawaryarana mwaaidapiyaba Jizaazai sarari yeꞌmwannamwaaina yaꞌ. Sahwai saba mwaalakegaaꞌ Gotɨyare mamaayara ejelɨyara wɨgaimwanna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Dɨvidaaꞌnyɨ Jonɨmɨ wɨla yɨrakɨna kyeꞌ Jizaazai Kwaaka Galɨlina wɨlaawɨna yaka saba Gotɨyare yagaala tewaanyaꞌ wɨjɨwakamarina. ");
INSERT INTO byr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wɨjɨwakamarina yakegaaꞌ wɨdaꞌ “Dahaaꞌ yemwaalyagaaꞌ aayasɨra. Dahaaꞌ yunegaaꞌnanyɨ. Gotɨyai aꞌmweraavɨ maremwaaidehaaꞌ yɨmaꞌnɨwaꞌ dahaaꞌ. Gotɨyarɨna sarɨmɨre sɨmunyabwi mudɨkebwi jawɨramaarila! Yagaala tewaanyaꞌ wɨꞌnapɨjɨ ‘Nebulyasɨra. Sara yaana!’ dɨthɨnyideꞌna yɨhɨthɨwa. Yagaala saꞌ nayaa dɨlɨmwagarila!” wɨjɨwaakɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Galɨli aalɨbumaangevɨ sahwai wodaaꞌnyɨ Saaimonɨjɨ Saaimonɨmɨre gahwaalaangei Edɨruyalyɨ sadaraai jawɨgɨlyaꞌ aalyavɨ marasɨꞌna yadaakɨlyɨ wangamabɨna yaꞌ. Marasɨꞌnagɨleꞌ dareꞌnesɨ. Jawɨnya mwagiꞌnagɨlyaraalyɨ. ");
INSERT INTO byr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Wangamabɨna yaka wɨdaꞌ “Dɨnyɨmɨdɨnaabyɨla! Kanyɨmɨdɨnaabakɨlyɨ kihɨzɨwaakaꞌmuri jawɨnya maaꞌditabaaibɨꞌ Gotɨyarɨne aꞌmweraavɨ maaryaꞌneraaihɨrɨ yɨhɨmwaaihɨderaaihɨlyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Miꞌna kudaꞌ yɨmeꞌnyaꞌbɨꞌ kɨrɨnnya jawɨgɨlya yagalyaꞌmaꞌna yagɨla mɨdɨnna yagi. ");
INSERT INTO byr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mɨdɨnna kyagi Jizaazai pɨzɨꞌgwa wawaka Sevathiyare gawaalɨꞌ kwaraai Jemɨzalyɨ Jonɨjɨ sadaraai wanganakeraai sɨpɨyavɨ mwaalagɨla jawɨgɨlya kayaaka yɨnɨke bɨꞌnyɨna yagi. ");
INSERT INTO byr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bɨꞌnadaakɨlyɨ yɨmeꞌnyaꞌbɨꞌ jaka wɨdɨna kyaꞌ “Yarai dulaabila!” kɨrɨnɨmaangei Sevathiyalyɨ gannya nɨgwɨwawɨnyarari sɨpɨyavɨ mwaalesaraavɨ yagalyaꞌmaꞌna yagɨla kɨdaraai gamɨnyɨ mɨdɨnna yagi. ");
INSERT INTO byr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kumɨ sara angeba Kaapanɨyamɨna wɨna kyeꞌ Juyaraavɨre Kwazaakegaaꞌ yɨmaꞌnyɨna kyaꞌ yɨmeꞌnyaꞌbɨꞌ gamɨ Juyaraavɨre Lotuangevɨ wɨlɨna yaka Gotɨyare yagaala wɨjɨwaakɨna. ");
INSERT INTO byr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wɨjɨwaakɨna kyaꞌ yuyara gamɨre yagaalyaꞌ wɨꞌneva atɨka maruꞌnaꞌmuluna yeꞌ. “Kɨwɨjaraavɨrebwi kwaasɨ kwaasɨyaꞌbɨsabulyɨ. Jizaazai gannya sɨmunyavɨ yuya yawɨꞌnɨkelyɨ,” dɨdaapi atɨka maruꞌnaꞌna yeꞌ. Sareꞌ dareꞌnanyɨ. Jizaazai dɨragɨnya kɨnɨnnakei wɨjɨwaakakeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Yɨmeꞌnyaꞌbɨꞌ aꞌmwei yɨmaka widei Lotuangevɨ wɨlɨna yaka ");
INSERT INTO byr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","jaka danganna “Jizaazai Naazaretɨ mwaalyaigɨ, nemɨnyɨ berɨꞌ dɨneyɨdeꞌna bahɨneka? Nemɨ aaꞌneinaavɨ kayaaka dɨneyɨgaideꞌna daaka? Gɨmɨnyɨna yawɨꞌmwa. Gotɨyare tewaanyaigɨnyɨna yawɨꞌmwa.” ");
INSERT INTO byr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Miꞌna jaka kadaꞌ Jizaazai maanga wɨdɨna “Yagaala madɨnnera! Aꞌmwe sarɨdaasɨ dɨwona!” ");
INSERT INTO byr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sara kudaꞌ yɨmakei aꞌmwerɨ yɨkɨlaaka wɨlaka jaka naanga daka kaanna wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aꞌmwera yuyara tɨnna wanganeva atɨka maruꞌnakulɨna yadɨvɨꞌ kumɨ sara dɨneꞌ “Ai, daꞌ berɨvaka? Wɨjɨwaakyaꞌneꞌ mudɨkesɨ. Aꞌmwe sai yagaala dɨragɨnna wɨdɨvanɨkelyɨ. Nabaai yɨmakeraavɨ sara wɨdɨwake sara yɨvanɨgava!” ");
INSERT INTO byr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kadɨneꞌ yɨmeꞌnyaꞌbɨꞌ Galɨli yuyabanyara Jizaazai yakeꞌna maalɨkegaaꞌ wɨꞌnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yɨmeꞌnyaꞌbɨꞌ Jizaazai Lotuangevɨdaaꞌnyai bwalyuna kyaꞌ Jizaazalyɨ Jemɨzalyɨ Jonɨjɨ pwarajɨ sara kaanna wɨna yeva Saaimonɨjɨ Edɨruyalyɨ saraare angevɨ bwina yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bwina kyeꞌ mɨdɨka wɨdaꞌdaasɨ Saaimonɨmɨ ganyaalɨmaangeꞌ waꞌdɨsɨ yɨmeꞌnyaꞌbɨꞌ kumɨ Jizaazarɨ wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Miꞌna wɨdɨna kyeꞌ nabalɨnakeyabanna bɨna yaka maradɨhaaꞌbwaꞌna yaꞌ. Jizaazai sara kyaꞌ nabalyaꞌ mena yɨwɨna kyaꞌ aꞌmweꞌ kumɨnyɨne wapaaya yovɨrawakɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nyɨlyai mena walakyagaaꞌ sabanyara nabalɨnakengɨjɨ yɨmaka widɨvɨsangɨjɨ sangɨ gamɨnyawɨnna makuna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Makuna yeva saba mwaalyara yuyara tɨkuryaba davaabɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Davaabɨna kyeꞌ Jizaazai aꞌmwe nabalya ge ge waꞌdɨvɨsaraavɨ nabalyaꞌ wangadaaꞌnyɨ “Tewaanya jɨmaꞌnana!” sana sana kudaꞌ tewaanya yɨmaꞌnɨgulɨna yeꞌ. Nabaai aaꞌne kwalaalyaraavɨ wɨdaasɨna yaꞌ. Aaꞌnera gamɨnyɨna yawɨꞌdaapiyaꞌna wangada “Yagaala madɨpɨnera! Kwaasɨ yadɨvɨsaihɨrɨ nayɨhuꞌnɨpɨdɨka!” wɨdaka wɨdaasɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jizaazai se waꞌmwarakei yɨrɨkunyagaaꞌ dɨkaaꞌna yaka walyuna yaka aꞌmwera maaya kunebanna kaanna wɨna yaka Gotɨyarɨ yagaala wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kuna wɨdɨna yadaaꞌnyɨ Saaimonɨjɨ gamɨnyaba mwaalesarajɨ bɨrɨbɨrɨkaanyara wɨna yeva ");
INSERT INTO byr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","yɨrɨꞌmaaꞌna yeva wɨdeꞌ “Yuyara gɨmɨnyɨna bɨramarivanɨgava aꞌmweraava.” ");
INSERT INTO byr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tɨviꞌna kudeꞌ gamɨ wɨdɨna “Angeba pɨnɨ aya kɨbanna nemɨ kaanyaana! Anga saba Gotɨyare yagaala wɨjɨwaakɨdeꞌna bwalyuwa.” ");
INSERT INTO byr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wɨdaka Galɨli yuyaba kumɨre Lotuangengɨ yagaala Gotɨyare wɨjɨwakamaryaꞌ. Sagaaꞌ aꞌmwe yɨmaka widɨvɨsaraavɨdaasa yɨmakeraavɨ wɨdaasaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Aꞌmwe samatanakei gamɨnyawɨnna bɨna yaka “Jizaazai naangelyɨ,” daka kwadaai gɨlɨna yaka yagaala naanga dɨragɨnna wɨdaꞌ “Nɨmɨre kɨlaakejɨꞌ ‘Tewaanya mwaalana!’ nyawɨꞌdɨzaꞌ gɨmɨ sara dɨnyavadaꞌgala! Sara yɨnneigɨnyɨ gɨmɨ.” ");
INSERT INTO byr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wɨdɨna kyaꞌ Jizaazai kale kwiaꞌ ata dathɨwanna yaka wɨdɨna “ ‘Sara yɨma!’ yawɨꞌmanɨge. Gɨmɨre kɨlaakejɨꞌ yɨhula dana!” ");
INSERT INTO byr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wɨdɨna kyaꞌ yɨmeꞌnyaꞌbɨꞌ samate saꞌ yaꞌmaꞌna yaka gamɨre kɨlaakejɨkɨ yarai yɨwɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kɨlaakejɨkɨ yɨwɨna kyaꞌ Jizaazai maanga wɨdɨna yaka ");
INSERT INTO byr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","wɨdɨna “Nayaa dɨnyuꞌnana! (Nɨmɨnyɨna najɨꞌbwaꞌnemwaaibɨthɨka!) Aꞌmwe aane pwai kwarɨ ‘Sara nyɨwaka,’ mudɨnna! Aane pɨrɨꞌ kɨrɨꞌ mujɨwaakɨnna! Aawa. Kaanna wawaꞌgɨzɨ sipɨzipɨya Gotɨyarɨna mubɨthɨka yɨraꞌderɨ pɨrizɨyarɨ duzɨwaainana! Dahaaꞌ kɨlaakeꞌ tewaanya warɨkeꞌna Mozɨzai dɨnɨkeꞌ Gotɨyarɨneꞌ dumaarideꞌna aꞌmwera yawɨꞌna ‘Aꞌmwere samateꞌ menanyɨra,’ gyawɨpɨꞌdera.” Miꞌna wɨdaka yɨmeꞌnyaꞌbɨꞌ wɨdaasɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sara kudaasaꞌ aꞌmwei walyuna yaka yuyaba yagaala saꞌ wɨjɨwaakyaꞌnei yuyaraavɨ wɨdɨvainadaaꞌna yɨkwaasaꞌ. Gamɨ sara kyaꞌ “Aꞌmwera nyanganapɨjɨ nɨmɨnyɨna nanyɨdahidɨwagamaremwaaibɨthɨka!” daka Jizaazai angeba mwɨyai yaayeba mwaalɨna yadɨsɨ gazabazabadaaꞌnyɨ gamɨnyawɨnna yɨkabɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sawɨta pɨjaaꞌ kajɨnnaꞌ sai Kaapanɨyamɨna ayɨna yagalaawaka bamwaaina yaꞌ. Bamwaaidɨꞌnyɨ dara wɨꞌnesaꞌ “Anga aya mwaaidevɨ damwaalɨꞌ!” ");
INSERT INTO byr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Sara deva kwala yɨꞌbwaꞌnyɨna yeꞌ. Kwala yɨꞌbwaꞌnyɨna yeva tɨkuryaba daavanneba kune pɨba madaayɨ yeva angavɨneꞌ mwasabanneꞌ bamwaihwodapi yagaalyaꞌ wɨjɨwaakɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wɨjɨwakadaaꞌnyɨ pwara makabɨna kyeꞌ aꞌmwe daraai daraalyara kɨlaaka yagɨnya bainɨkerɨ marikwavamakabɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Marikwaꞌna yeva “Aꞌmwe kwalaalyara damwaaihava!” deva kwala bwaꞌnaanyavɨneꞌna Jizaazaryawɨnna mabamakulyara angevɨ aꞌba bamaragaꞌnɨgilaawɨna yɨna yeva munyaba Jizaazai wɨlamwaaidɨsɨyaba kwavɨsaꞌ daburaabɨna yeva yagɨnya bainɨkei yɨꞌbɨnnakerɨ maralaꞌmwagakɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Maralaꞌmwagakɨna kyeꞌ Jizaazai kumɨre lɨmwangebwi yawɨranganna “Aꞌmwe dara ‘Jizaazai dɨragɨnaangei aꞌmwerɨ tewaanya negaimwagathelyɨra,’ yawɨreva makabɨwaava,” Jizaazai yawɨraka yagɨnya bainɨkerɨ wɨdɨna “Nyɨbwaalɨꞌ, gɨmɨre kayaaꞌnanya gɨmarasɨꞌmwa.” ");
INSERT INTO byr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sara wɨdɨna kyaꞌ Kɨwɨjara pwara saba mwaaleva kumɨre kunya yawɨꞌna ");
INSERT INTO byr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Aꞌmwe dai yagaala saꞌ baaꞌna dɨvanɨka! ‘Gotɨyarɨ wavɨlaꞌmweinyɨ,’ dathɨvanɨka! Kayaaꞌnanya aai marasɨꞌnadelaka! Gotɨyai gavei marasɨꞌnadelyɨra. Sareꞌ Gotɨyarɨ yagaaibɨraizɨka dɨwakei daaka!” yawɨranganna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yawɨrangadaapi yɨmeꞌnyaꞌbɨꞌ Jizaazai gannya sɨmunyavɨ yawɨꞌna “Aꞌmwe dara sara jawɨꞌmanɨgava!” daka wɨdɨna “Sarɨmɨre sɨmunyangɨ sareꞌ baaꞌna yawɨꞌmanɨgava! ");
INSERT INTO byr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Darewaai naangewaai midaaka! Pɨrɨꞌ dareꞌ. Yagɨnya bainɨkerɨ wɨdɨdeꞌ ‘Gɨmɨre kayaaꞌnanya gɨmarasɨꞌmwa.’ Pɨrɨꞌ dareꞌ. Wɨdɨdeꞌ ‘Dɨthɨkaaka! Yɨꞌbɨnyaꞌ maaraꞌgɨzɨ dɨmakwalyona!’ Yagaala yuya sawaai naangewaai midaaka! Nɨmɨ kudaꞌmuri ‘Dɨthɨkaaka! Yɨꞌbɨnyaꞌ maaraꞌgɨzɨ dɨmakwalyona!’ sara yadeꞌna ");
INSERT INTO byr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","sarɨmɨ yawɨꞌna ‘Ai, Kwaaka davakɨ aꞌmwe sai kayaaꞌnanya marasɨꞌnyaꞌnei dɨragɨnnakelyɨ,’ jawɨryideihɨlyɨ. Sara jawɨryideꞌna Aꞌmweraavɨne Kaimɨraayai yagɨnya bainɨkerɨ sara wɨdana!” ");
INSERT INTO byr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Aꞌmwerɨ wɨdɨna “Gɨthɨwa, ‘Dɨthɨkaaka! Gɨnnya yɨꞌbɨnyaꞌ marikwavaꞌgɨzɨ gɨnnya angevɨna dɨmakwalyona!’ ” ");
INSERT INTO byr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sara wɨdɨna kyaꞌ daavaka yɨmeꞌnyaꞌbɨꞌ yɨꞌbɨnyaꞌ marikwaꞌna yaka kaanya walyodaaꞌnyɨ sareꞌna aꞌmwe yuyara tɨnna wanganna yeva atɨka maruꞌnakulɨna yeva Gotɨyarɨ yɨlaaya yeva “Sabwi nemɨ sara mwanganyainera,” dɨnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jizaazai ayɨna walyoka aalɨbumaangevɨ mwaaidɨsɨ aꞌmwera yuyara yɨꞌbwaꞌnyɨna yeva mwaaidapi Jizaazai wɨjɨwaakɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Livaayai Alɨpɨyaazarei taakɨzɨya maaꞌdei taakɨzɨya maaꞌdeva mwaaidɨꞌnyɨ Jizaazai wangamabaka wɨdɨna “Nyɨmɨdɨnaama!” Miꞌna wɨdɨna kyaꞌ daavɨna yaka mɨjɨwɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Livaayare angevɨ Jizaazai namwaaidɨsɨ taakɨzɨya maaꞌdɨvɨsarari aꞌmwe kɨwɨnya maalɨꞌna yadɨvɨsarari sara Jizaazalyɨ gamɨrerari saraayaba mwaalɨna yeꞌ. Sareꞌ dareꞌnesɨ. Kumɨ sara kwalaalyara gamɨnyɨ mɨdɨnesara. ");
INSERT INTO byr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Namwaaidapi Kɨwɨjara Perɨzɨyara “Gamɨ salyɨ kɨwɨnya maalɨꞌna yadɨvɨsarari taakɨzɨya maaꞌdɨvɨsarari jeꞌmwannanɨvanɨgava!” deva gamɨreraavɨ wɨdɨna “Taakɨzɨya maaꞌdɨvɨsarajɨ kɨwɨnya maalɨꞌna wɨyadɨvɨsarajɨ saraayaba baaꞌna nɨvanɨka!” wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yagaala saꞌ wɨdɨna kyeꞌ Jizaazai wɨꞌnakei wɨdɨna “Dotarɨna nabalɨmaayara wɨgainadera mɨꞌ. Aawa. Nabalɨnakera wɨgainadere. Sareꞌna nɨmɨ sainyɨ aꞌmwe yɨdaꞌmaraangebulyɨyainajɨyaraavɨ jɨvwaramaaryaꞌneinyɨ mabye. Aawa. Kɨwɨnya maalɨꞌna yadɨvɨsaraavɨneꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pɨgaaꞌ Jonɨmɨrerajɨ Perɨzɨyarajɨ “Gotɨyarɨna wapaaya manaannera!” deva navɨka mwaaidapi pwara wɨlaabɨna yeva Jizaazarɨ wɨdɨna “Beꞌneka? Jonɨmɨrerari Perɨzɨyaraavɨrerari sara wapaaya manyara mwaalɨna yadapi kɨrɨꞌ gɨmɨrera wapaaya baaꞌna nɨvanɨgava!” ");
INSERT INTO byr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Wɨdɨna kyeꞌ Jizaazai wɨdɨna yaꞌ “Mudɨkangeyabanne munne yadɨvɨsagaaꞌ aꞌmweꞌ maarade mɨgɨnyai mwaaidozɨ aꞌmwe aꞌmwera tɨka munne manɨpɨne yɨpɨjara daaka! ");
INSERT INTO byr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mɨgɨnyai mwaaidoriyagaaꞌ wapaa nɨpɨꞌdengɨra. Pɨgasa kimaꞌnojɨ kumɨnyabadaasai aꞌmweꞌ maarade mɨgɨnyai yɨpalasɨꞌna kyapi sagaaꞌ kumɨ sa wapaa tɨka manyɨ yɨpɨꞌdengɨra. Sareꞌ kanyɨpalasɨꞌnapɨri nɨmɨrera wapaaya manyɨ yɨpɨꞌdengɨra.” ");
INSERT INTO byr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sareꞌ Jizaazai gamɨre yagaala mudɨkeꞌna wɨdɨna “Yɨvɨta gaalyaꞌ aꞌmwe pwai dakurojɨ ‘Yɨvɨta ayɨkɨ mɨwɨrɨma!’ myawɨryajai tewaanyalyɨra. Sara mɨwɨꞌna yajɨ kwajɨ mɨwɨtaꞌne yɨvɨta yɨvɨsɨkɨ kayaaka kyadɨka! Yɨvɨta gaalyamɨlɨꞌ yɨvɨta ayɨkɨ kayaaka yadeꞌna naanga lihɨꞌna yadesɨra. ");
INSERT INTO byr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nabaai memekɨlaaka waainɨtalyaꞌ aꞌmwe aane pwai kwai waainɨtala ayavɨ waainɨya gaalyaꞌ mamaradɨngiki yadelyɨ. Sara maradɨngikajaꞌ aalɨmaagwala bilamariꞌbwarakadaawori waainɨyaꞌ memekɨlaakevɨ kayaaka kyojɨ waainɨyaꞌ bwalaraawɨna yadesɨra kɨlaaka yuya tɨꞌmɨwɨrojɨya. Sareꞌ aawa. Waainɨya gaalyaꞌ memekɨlaaka mudɨkevɨ maradɨngikɨna yajaꞌ tewaanya warɨna yadesɨra.” ");
INSERT INTO byr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Juyaraavɨre Kwazaaka pɨgaaꞌ lɨlaajabɨta witɨziwawɨnyavɨ tɨnnyaba tusavɨ sai widavadaasɨ gamɨrera mɨdɨnaabɨna, mɨjɨka wiadaaꞌnyɨ witɨzɨla gimujɨna yeꞌ. Saꞌna kɨwɨnya dɨnɨkeꞌ “Kwaakaanya yamaryadɨvɨꞌ tusavɨ aꞌmwera witɨzɨla maapɨka!” dɨnɨkesɨra. ");
INSERT INTO byr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Gimujɨna kyeꞌ Perɨzɨyara Jizaazarɨ wɨdɨna “Yɨthaa, Kwazaakegaaꞌ dahaaꞌ baaꞌna gimujɨvanɨgava! Kɨwɨnya sareꞌna warɨkesɨra. Sa pɨgaaꞌ dɨhimujidengɨra. Kwazaakegaaꞌ mipɨnera sabwi!” ");
INSERT INTO byr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sara wɨdɨna kyeꞌ Jizaazai wɨdɨna “Baaꞌna nyɨdɨwaava! Ne Devitɨ yaake pɨkarɨyɨkwiavɨ tɨnna mwanganyadɨvɨsaihi daaka? Devitɨjɨ gamɨjɨyarajɨ sara wapaaya kunera mɨjɨka wiadaaꞌnyɨ ");
INSERT INTO byr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","sipɨzipɨya Gotɨyarɨna Yɨraꞌde Naangei Avaayathai mwalyaakegaaꞌ Devitɨ Gotɨyarɨna yɨraꞌde pwarɨ gɨrɨkulyaꞌna wɨdaka Gotɨyare Angevɨ wɨlaabɨna kyaaꞌ Gotɨyai tɨnna wanganyaꞌne gɨrɨkula wakyaasa kujayaaꞌ maranyɨna yaaꞌ. Gɨrɨkula sa miꞌna kwaryaaꞌ ‘Gotɨyare yɨraꞌdɨvɨsara gavera maranadɨvɨsarera,’ kɨwɨnyaꞌ sara dɨnɨkesɨra. Devitɨ Gotɨyarɨna yɨraꞌdei mamwalyaakei maranyɨna yaka nabaai gamɨjɨyaraavɨna wɨmaryaaꞌ. Sareꞌ Gotɨyai maiyagaala mujaaꞌ.” ");
INSERT INTO byr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sara wɨdaka wɨdɨna yaꞌ “Sɨnnawɨ Gotɨyai aꞌmweraavɨ yavɨkaryaka dɨvidaasɨ aꞌmweraavɨneꞌna Kwazaakegaaꞌ wakyaaꞌ. Sɨnnawɨ Kwazaakegaaꞌ mwaryaka dɨvidaasɨ Kwazaakegaaꞌneꞌna aꞌmweraavɨ myavɨkaryaaꞌ. Arɨkewɨ. ");
INSERT INTO byr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sara yaakeꞌna Aꞌmweraavɨne Kaimɨraayai Kwazaakegaaꞌne Naangei ‘Aꞌmwera sara sara yɨpɨꞌderera,’ wɨdadelyɨra,” wɨdaꞌ Jizaazai gamɨnyɨneꞌna. ");
INSERT INTO byr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Lotuangevɨ ata pimagɨnyi yaalɨka mena yɨnɨkei mwaaidɨꞌnyɨ Jizaazai ayɨna wɨlamwaaina. ");
INSERT INTO byr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wɨlamwaaina kyaꞌ “Jizaazai Kwazaakegaaꞌ aꞌmwere asaꞌ tewaanya yavadaꞌgaina yajɨwaka?” deva Aꞌmwe Perɨzɨyara banganaꞌna yeꞌ. “Asaꞌ tewaanya yavadaꞌgaina yajaꞌ nemɨ kotɨya wɨmwaaihɨna yaadeinaava,” deva banganaꞌna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nayaa banganaꞌna yadapi Jizaazai ata kayaaꞌnanyarɨ wɨdɨna “Tɨnnyabanna dɨthaaka!” ");
INSERT INTO byr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aꞌmweraavɨ wɨdɨna “Kwazaakegaaꞌna kɨwɨnya gara dɨvanɨka? Kwazaakegaaꞌna tewaanya yɨjaꞌnebwi sara dathɨvanɨka? Kwazaakegaaꞌna kayaaꞌnanya yɨjaꞌnebwi sara dathɨvanɨka? Nabaai ‘Aꞌmweraavɨ tewaanya mwaaibɨꞌdeꞌna dɨhaimwana!’ dathɨvanɨka? ‘Aꞌmweraavɨ dɨramakya!’ kɨwɨnya sara dathɨvanɨka?” wɨdɨna. Sara wɨdɨna kyaꞌ kumɨ sara yagaala mujɨ, maadɨnna mwaalɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Maadɨnna mwaalɨna kyeꞌ kumɨre sɨmunyangɨ ata yaalɨka yɨnɨkerɨna kumɨnyɨ kale mwiadaaꞌnyɨ Jizaazai wangamabɨna. Wangamabɨna kyaꞌ saraavɨneꞌna kale wiadaasɨ avaalyagaaꞌ maadɨnna mwaaidapiyaraavɨna gamɨre sɨnna tɨka wɨdaꞌdaasɨ aꞌmwerɨ wɨdɨna “Gɨnnya asaꞌ jɨwɨbwaka!” Sara wɨdɨna kyaꞌ ata yɨna kyaꞌ ata kayaaꞌnanyaꞌ maamɨdaryaꞌ yɨmaꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Maamɨdaryaꞌ yɨmaꞌnyɨna kyaꞌ yɨmeꞌnyaꞌbɨꞌ Lotuangevɨ Perɨzɨyara bwalyuna yeva Erotɨyarerajɨ yɨꞌbwaꞌnyɨna kyeꞌ jamungajeꞌ “Jizaazai baladeꞌna nemɨ gara yaadelaka?” ");
INSERT INTO byr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jizaazalyɨ gamɨrerajɨ saba yagalyaꞌmaꞌna yeva Aalɨbunya Galɨlina wɨna. Nabaai kwala naanga kaanna wɨna. Kwaaka Galɨli mwaalyarajɨ Kwaaka Juthɨya mwaalyarajɨ ");
INSERT INTO byr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Anga Jeruzaalemɨ mwaalyarajɨ Kwaaka Yɨthumɨya mwaalyarajɨ Aalya Jothanɨ pimagɨ mwaalyarajɨ Anga Taayaa Anga Saaithonɨ sabanyaai mwaalyarajɨ yuya sara “Jizaazai sana sana yɨvanɨkelyɨra,” deva gamɨnyawɨnna kaanna bɨna. ");
INSERT INTO byr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kaanna bɨna kyeꞌ kwala bwaꞌnaanya naangeꞌna gamɨreraavɨ wɨdɨna “Kwala bwaꞌnaanya daꞌ bule nanyɨnadɨka! Botɨyaꞌ nɨmɨnyɨneꞌ jovɨrawakyɨla! Aalyavɨ waꞌdɨꞌnyɨ botɨyavɨdaaꞌnyɨ wɨjɨwaakɨdeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sareꞌ dareꞌnesɨ. Sara wɨdɨna yakeꞌneꞌ Jizaazai aꞌmweraavɨ tewaanya yavadaꞌgaina kyaꞌ nalaavɨnakera “Jizaazarɨ yɨmetavɨma!” dɨneva yɨmetaꞌna yesaꞌna wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aꞌmwe pwara yɨmaka widɨvɨsara Jizaazarɨ tɨnna wanganeva gamɨnyawɨ walaꞌna yeva “Aakayɨ,” jaka dɨna “Gotɨyare Gawaalɨvaangeigɨnyɨra,” wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sara wɨdɨna kyeꞌ Jizaazai yɨmakeraavɨ yagaala dɨragɨnɨnaanga wɨdɨna “Nɨmɨnyɨna ‘Gotɨyare Gawaalɨvaangelyɨ,’ madɨpɨnera!” ");
INSERT INTO byr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jizaazai mugunyangɨ wɨlaawɨna yaka “Aꞌmwera nɨmɨrera yɨmaꞌnɨpɨꞌdera,” dakeraavɨ jaka wɨdɨna kyaꞌ kumɨ wɨlaabɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Wɨlaabɨna kyeꞌ aꞌmwe atɨraai sɨvɨlyɨrɨdaaꞌnyɨ pwaraalyaraavɨ dahɨlakɨna yaka “Nɨmɨnyaba dɨmwaalyɨla! Nabaai yagaala wɨjɨwakamaryaꞌna yɨhɨthaasɨdera! ");
INSERT INTO byr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yɨmakeraavɨ wɨdaasaꞌne dɨragɨnyaꞌ yɨhɨzaavɨdeinyɨ,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aꞌmwe atɨraai sɨvɨlyɨrɨdaaꞌnyɨ pwaraala sareraavɨne yaya darengɨra. Yɨ pwai Saaimonɨ yaya pɨrɨꞌ Jizaazai wɨdakeꞌ Pitai, ");
INSERT INTO byr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","yɨ pwaraai Jemɨzai Sevathiyare gawaalɨvaangelyɨ Jonɨ Jemɨzare gahwaalaangelyɨ sadaraai yaya pɨrɨꞌ wɨdake Bawanezɨzɨ (aangyagaalyaꞌna Yɨꞌmuyagaainakeraai), ");
INSERT INTO byr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","yɨ pwai Edɨruyai, pwai Pilipɨ, pwai Baatolomyui, pwai Matɨyui, pwai Tomaazai, pwai Jemɨzai Alɨpɨyaazarei, pwai Tathɨyaazai, pwai Saaimonɨ “Kumɨreba Romɨyara wɨpɨka!” dadei, ");
INSERT INTO byr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","pwai Juthaazai Yɨzɨkerɨyotɨyai dɨvidaasɨ Jizaazarɨ yɨkamaangeraavɨna wibwarɨdaakwiaꞌnei. ");
INSERT INTO byr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jizaazai gannya angevɨ wɨlaabɨna. Miꞌna wɨlaabɨna kyaꞌ kwala bwaꞌnaanya yɨꞌbwaꞌnamwaaina kyeꞌ Jizaazalyɨ gamɨrerajɨ sara yɨna yɨna yeva “Wapaaya warana! Gotɨyare wawɨnya yaana!” deva wapaaya manyɨ yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wapaaya manyɨ kyeꞌ Jizaazai yakeꞌna gamɨre jɨlɨkaimɨraaya sara wɨꞌneva “Nemɨ gamɨnyɨ marawaana!” deva kaanna bɨna yeꞌ. Sareꞌ dareꞌnesɨ. “Sɨmunya maayai mwaalɨka,” desaꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kɨwɨjara Anga Jeruzaalemɨdaasara dɨna “Jizaazarɨ munyɨkɨ yɨmaka Biyelɨzɨvulɨ kɨnɨnnakelyɨra.” Nabaai dɨna “Yɨmakeraavɨ maremwaala naangei gannya dɨragɨnyaꞌ kujaavaꞌ Jizaazai yɨmakeraavɨ wɨdaasɨna yadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sara dɨna kyeꞌ Jizaazai aꞌmweraavɨ “Kaajɨla!” wɨdaka keꞌbaꞌna yagaala wɨdɨna “Saataanɨ Saataanɨmɨ gara yojɨ wɨdaasɨnannelaka? ");
INSERT INTO byr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kingɨyare aꞌmwera anga kɨba mwaalyara jaapaina yɨpɨjaꞌ mala bwaꞌnyɨna yɨpɨjaꞌ sahwara dɨragɨnya daapɨneꞌ mɨka! ");
INSERT INTO byr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aꞌmwe pɨnɨdaka kajapalemwalamaryapɨjɨ sanɨdaka dɨragɨnya daapɨneꞌ mɨka! ");
INSERT INTO byr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Savɨneꞌna Saataanɨjɨ gamɨrerajɨ jaapaina yɨpɨjaꞌ mala bwaꞌnyɨna kyapɨjɨ Saataanɨ maremwaaideva dɨragɨnya madaayɨ yannesɨ. Aawa. Savɨneꞌna Saataanɨ miꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Aꞌmwe aane pwai kwai aꞌmwe dɨragɨnyare gɨlyɨvɨsa kuka yɨpalamaasaꞌna gamɨre angevɨ mulaawi yannelyɨ. Arɨkewɨnyɨra. Sɨnnawɨ sai aꞌmwe dɨragɨnyarɨ wɨla pwɨyajaꞌ dɨvi kuka yɨpalamaaradelyɨra. ");
INSERT INTO byr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yagaala daꞌ jawɨka! Nebwina gɨthɨma! Aꞌmwera kayaaꞌnanyabwi yɨvanɨgasabwi sabulyɨ Gotɨyarɨna yagaaibɨraizɨka ge ge dɨza yɨvanɨgasajɨ yɨvanɨgasara Gotɨyarɨ kudapɨjɨ Gotɨyai kayaaꞌnanya sa wɨmarasɨꞌnadelyɨra. ");
INSERT INTO byr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Sare kɨrɨꞌ Kuryai Tewaanyarɨna yagaaibɨraizɨka wɨdɨvanɨgasa yuyagaaꞌ Gotɨyai mumarasɨꞌnyɨ yadelyɨra. Aawa. Kurya Tewaanyarɨna bɨrala sabwina yɨwetawakya sabwi yuyagaaꞌ yuyagaaꞌ waragothevulyɨra. Sabwi Gotɨyai mamarasɨꞌnyɨ yadelyɨra!” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jizaazarɨna “Yɨmakei kɨnɨnnakelyɨ. Gotɨyare Kuryai kɨnɨnnakei mɨka,” dɨnesaꞌna Jizaazai sara wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sagaaꞌ Jizaazarɨ ganaangesɨ gahwaalaangerajɨ biꞌmaꞌna. Miꞌna biꞌmaꞌna yeva angevɨ mwasawɨ daaveva gamɨnyɨna pwaraavɨ wɨdɨna “ ‘Gɨmɨjɨyarajɨ gwaangesɨ mwaaihava,’ duthaawila!” ");
INSERT INTO byr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sara wɨdɨna kyeꞌ kwala bwaꞌnaanyaꞌ gamɨnyaba wɨlamwaaleva wɨdɨna “Yɨthaa! Gwaangesɨ jaꞌmwerajɨ jaꞌmwejɨ sa mwasaba bamwaaleva gɨmɨnyɨna jaka dɨvanɨgaꞌ.” ");
INSERT INTO byr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jizaazai wɨꞌnaka maꞌmaaꞌna “Nɨnnya nɨwaaꞌ berɨvaka? Nyɨgwaalaangera bewaraavaka?” ");
INSERT INTO byr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wɨdaka gamɨnyaba bamwaihwodapiyangɨ tɨnna wanganaka wɨdɨna “Yɨthaanyi! Dathara nɨwaasɨ nyɨgwaalaangerajɨ mwaaihaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aꞌmwe pwara kwara Gotɨyai wɨdɨnɨkeꞌ sara yɨvanɨgasara sahwara nɨwaasɨ nyɨgwaalaangerajɨ nyɨnyaabulaangejɨ mwaaihava.” ");
INSERT INTO byr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pɨgaaꞌ Jizaazai aalɨbumaangebaarɨ gaai wɨjɨwaakɨna. Wɨjɨwaakɨna yadaasɨ kwala yɨꞌbwaꞌnemwaalesaꞌna sɨpɨyavɨ wɨlamwaaina kyaꞌ sɨpɨyaꞌ aalyavɨ aꞌba yɨlaꞌna yadɨsɨ kwala bwaꞌnaanya yuya aalɨbumaangebaarɨ mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sara mwaalɨna yadapi Jizaazai wɨjɨwaakya kwalaalya kumɨnyɨneꞌna yagaala keꞌbaꞌna wɨdɨna yaꞌ ");
INSERT INTO byr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Dɨnyuꞌnyɨla! Yɨthaanyi, pɨgaaꞌ aꞌmwe witɨzɨla pɨraihɨrakyaꞌnei kaanna wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wawaka gannya wawɨnyavɨ sɨla kavɨraihɨrakaꞌ sɨla pɨnɨ tuꞌmaangeba bwalaraawɨna kyaꞌ yusara bamaranyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pɨba amwi sɨla naangejɨꞌ waꞌdɨꞌnyɨ aꞌba kwaaka maalɨkejɨꞌ waꞌdɨꞌnyɨyaba sɨla pɨnɨ pɨraihɨrakake witɨzɨla yarai yɨrɨꞌna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Yɨrɨꞌna kyaꞌ gannya mɨwɨrinya naanga magɨri kyaꞌ nyɨla naanga wɨdɨna yakegaaꞌ yawaka baihinyɨna yaka yuya balɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kwaakevɨ lannake waꞌdɨsɨ aꞌba sɨla pɨnɨ pɨraihɨrakake yɨrɨꞌna kyaꞌ lannake kɨnɨjɨ yɨrɨꞌna yaka naanga gɨrina yaka kayaaka galadathɨwanna kyaꞌ kurɨjɨrɨka dɨna yaka gamɨre sɨla miꞌnyɨ yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Sɨla pɨnɨ kwaaka tewaanyavɨ kavɨraihɨrakaꞌ sɨla sa tewaanya yɨrɨꞌna yaka naanga gɨrina, sɨla tewaanya yɨꞌnyɨna yaꞌ. Yɨꞌnyɨna yake pɨnɨ sɨla pɨrɨvɨdaaꞌnyɨ kɨbawe (30) yɨꞌnyɨna yaꞌ. Sɨla pɨnɨ sɨla pɨrɨvɨdaaꞌnyɨ naanga kɨbawe (60) yɨꞌnyɨna yaꞌ. Sɨla pɨnɨ sɨla pɨrɨvɨdaaꞌnyɨ naanga (100) yɨꞌnyɨna yaꞌ,” sara wɨdɨna yaꞌ Jizaazai. ");
INSERT INTO byr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yagaala keꞌbaꞌna miꞌna wɨdaka Jizaazai wɨdɨna yaꞌ “Kadɨꞌnakeinyɨ daakajɨ nayaa dɨnyuꞌnana!” ");
INSERT INTO byr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Aꞌmwe kwala bwaꞌnaanya mena wɨna yesagaaꞌ Jizaazare atɨraai yaka sɨvɨlyɨrɨdaasɨ pwaraai sarajɨ aꞌmwera gamɨjɨ mwaaidɨvɨsarajɨ sa Jizaazarɨ yɨwaaraꞌna “Yagaala keꞌbaꞌna dɨwaanyaꞌ dɨnejɨwaakya!” ");
INSERT INTO byr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sara yɨwaaraꞌna kyeꞌ Jizaazai wɨdɨna “Yagaala nebulyaꞌ yoimavajalɨkurakyaꞌ Gotɨyai maremwaaideꞌneꞌ Gotɨyai yɨhɨzɨwaainɨwaka. Aꞌmwe pwara mwasɨlaanyara yagaala yuya keꞌbaꞌnanya gave pɨrɨvɨna wɨꞌnɨvanɨgaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Saꞌna yɨmaꞌnyaꞌneꞌ dɨnɨkesɨra. Tɨnna sara wangadɨvɨꞌ kɨrɨꞌ sɨmunya myawɨranganyɨvanɨgaꞌ. Kadɨka sara wɨꞌnadɨvɨꞌ kɨrɨꞌ sɨmunya myawɨramaarivanɨgaꞌ. Yawɨrapɨjɨ mudɨkebwi yawɨramaapɨjɨ kwajɨ Gotɨyai kumɨre kayaaꞌnanyabwi kamarasɨꞌnadɨka! ");
INSERT INTO byr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sai wɨdɨna “Yagaala keꞌbaꞌnanya saꞌ myawɨryijɨwaava? Yagaala saꞌ myawɨri yeva yagaala keꞌbaꞌnanya pɨnɨ gara jawɨryideihɨlaka? ");
INSERT INTO byr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aꞌmwei yɨhɨthɨwei yɨsɨla pɨraihɨrakakei Gotɨyare yagaala wɨjɨwaakadelyɨra. ");
INSERT INTO byr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sɨla pɨnɨ tuꞌmaangevɨ pɨraihɨrakake bwalaraawɨna kyaꞌ yusara maranyɨna yeta pwara Gotɨyare yagaala kuꞌnapɨjɨ yɨmeꞌnyaꞌbɨꞌ Saataanɨ yarai bɨna yojɨ yagaala wɨꞌnɨpɨjaꞌ yarai marasɨꞌna yadengɨra. ");
INSERT INTO byr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Sɨla amwi waꞌdɨsɨ kwaaka maalɨkejɨkɨ yɨsɨla pɨraihɨrakake pwara sabaaibɨꞌ Gotɨyare yagaala yɨmeꞌnyaꞌbɨꞌ yɨlaayaꞌna wɨꞌnyɨna yapɨjɨ ");
INSERT INTO byr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kumɨ sara dɨragɨnyaꞌ kɨnɨnnakera mamwaalyɨ. Aawa. Dɨvi maalɨkegaaꞌ aꞌmwera Gotɨyare yagaalyaꞌna maanga wɨdɨna, taanginya wina kyapɨjɨ yɨmeꞌnyaꞌbɨꞌ Gotɨyarɨna yagalyaꞌmaꞌna yɨpɨꞌdengɨra. ");
INSERT INTO byr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kwaakevɨ lannake waꞌdɨsɨ sɨla pɨnɨ pɨraihɨrakake pwara Gotɨyare yagaala nayaa wɨꞌnyɨna yɨpɨꞌdengɨra. ");
INSERT INTO byr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Aꞌmwe sara Kwaaka davakɨna yawɨꞌna, nɨgwɨlalaakenna yawɨꞌna, gɨlyɨvɨta naangenna yawɨꞌdɨvɨsara sara yɨpɨꞌdeꞌna Gotɨyare yagaalyaꞌ kayaaka galadathɨwanna kyojɨ aꞌmwera navɨka mwaaipɨjara Gotɨyare yagaala navɨka yɨpɨꞌdere waryaanyara. ");
INSERT INTO byr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kwaaka tewaanyavɨ sɨla pɨnɨ pɨraihɨrakake pwara Gotɨyare yagaala nayaa wɨꞌnyɨna, daapɨna yɨpɨꞌdengɨra. Aꞌmwe sara Gotɨyarɨne tewaanya yɨpɨꞌderera. Pwara tewaanya kɨbawe (30) yɨpɨꞌde, pwara tewaanya naanga kɨbawe (60) yɨpɨꞌde. Pwara tewaanya naanga (100) yɨpɨꞌdesɨra.” ");
INSERT INTO byr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sagaaꞌ sai wɨdɨna “Aꞌmwe pwai laamuyai maaꞌgulyaꞌ marirɨꞌmwagakɨnɨkerɨ lɨka marulyakadei daaka! Nabaai se waryaꞌne yɨꞌbɨnya dalaangevɨ laamuyai lɨka marulyakadei daaka! Aawa. Yɨꞌbɨnyavɨ yɨlakadeꞌnesɨra. ");
INSERT INTO byr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sareꞌ dareꞌnesɨ. Nɨmɨre yagaala aane pɨrɨꞌ kɨrɨꞌ lɨka yulyaꞌnɨkeꞌ dɨvi nayaa yɨbwarɨdaakwadesɨ. Dahaaꞌ wɨjɨwaakɨyagaala wɨdadɨnya aane pɨrɨꞌ kɨrɨꞌ bwakakɨnɨkeꞌ aꞌmwera myawɨrivanɨgasaꞌ ‘Dɨvi kuꞌmaayaba yɨmaꞌnaabana!’ dena bwakakeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kadɨꞌnakeinyɨ daakajɨ nayaa duꞌnana!” ");
INSERT INTO byr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jizaazai wɨdɨna “Kadɨka wɨꞌnɨvanɨgasaꞌ nayaa jawɨrila! Yawɨbwasaꞌ dɨrɨvɨkɨꞌdeꞌ saꞌ gɨrɨvɨkɨradesɨ. Nabaai pɨrɨꞌ gyeꞌmwagahɨzaavadesɨ. ");
INSERT INTO byr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sareꞌ dara yɨhɨthɨvanɨge. Aꞌmwe pwai ‘Jizaazare yagaala waburya nyɨwaka! Wɨꞌnɨma!’ kadozɨ Gotɨyai yagaala pɨnɨ wɨjɨwaakadelyɨra. Pwai ‘Jizaazare yagaalya taanga nyɨwaka. Waramaryana!’ dazai Gotɨyare yagaalya myawɨri yajai nɨmɨre yagaalyaꞌ wasɨꞌnajarɨ Gotɨyai yagaala pɨnɨ mujɨwaaki yadelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yagaala pɨrɨꞌ wɨdɨna “Gotɨyai aꞌmweraavɨ maremwaaideꞌ naanga yɨmaꞌnyaꞌneꞌna daresɨ. Aꞌmwei wawɨnyavɨ sɨla pɨraihɨrakadevaaibɨsasɨ. ");
INSERT INTO byr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pɨraihɨrakadevɨ aꞌmwei sawɨsavɨ se waꞌda yɨrɨka puꞌdaasɨyavɨ dɨkaaꞌna yada navɨka mwaaidɨꞌnyɨ sɨla pɨraihɨrakadengɨdaaꞌnyɨ bilyɨrɨꞌna. Bilyɨrɨꞌna yadevɨ naanga sara bilyɨrɨꞌdaaꞌnyɨyaꞌna myawɨri. ");
INSERT INTO byr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kwaaka gamɨ savɨdaasɨ yɨlaabɨna. Sɨnnawɨ witɨya maalɨke bilyɨrɨꞌna, dɨvi purɨrya yɨꞌnyɨna, dɨvi sɨla yawaka yɨna yadesɨ. ");
INSERT INTO byr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aꞌmwei dara wangadeꞌ ‘Yawaka miꞌna yɨwakeꞌ daaka!’ dada yɨmeꞌnyaꞌbɨꞌ kwaariꞌmata yadɨꞌmwagakɨnɨkesɨ marawɨdɨlavamaaꞌna yade sɨla maaryagaaꞌnanyɨ. Gotɨyai aꞌmweraavɨ maremwaaideꞌ naanga yɨmaꞌnyaꞌneꞌna sahɨrɨsɨra. Sareꞌna aꞌmwera myawɨryarera.” ");
INSERT INTO byr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jizaazai wɨdɨna “Gotɨyai aꞌmweraavɨ maremwaaideꞌna be yagaala yɨhɨzɨwaakɨjɨwana? Saꞌna keꞌbaꞌnanya berɨvɨ wakaadevaka? ");
INSERT INTO byr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Darebaaibɨsasɨ. Gotɨyai maremwaaideꞌ sɨnnawɨ maalɨka warɨna, dɨvi naanga yɨmaꞌnyaꞌneꞌna yɨsɨꞌ maazɨtetɨ woꞌnɨkikɨne sɨla maazɨtetɨ maalɨkesɨra. Yuya pɨnɨ Kwaakevakɨ naangengɨra. Yɨsɨꞌ maazɨtetɨ aranya naangeꞌbɨsɨkɨra. ");
INSERT INTO byr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Yɨsɨla maalɨka saꞌ pwai kwaakevɨ maraburɨnna yada yɨsɨla maalɨtaayamɨlɨkɨdaaꞌnyɨ yɨsɨꞌ yɨrɨꞌna yada naanga gɨrina yada sɨgya naangeꞌ waayadɨꞌnyɨ yutara sɨgunyavɨyara gamɨre taanyangɨ arɨta yɨlyalaanna yadɨvɨꞌ kɨmaꞌnyawɨ mwaaidɨvɨsare. Gotɨyai maremwaaideꞌ sahɨrɨsɨra.” ");
INSERT INTO byr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jizaazai yawɨꞌna “Kumɨre yawɨsa navɨlaꞌmudɨka! Nayaa yawɨpɨnebaaibɨꞌ wɨjɨwaakɨma!” daka keꞌbaꞌnanya kwalaalyangɨ gamɨre yagaala wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wɨdɨna yakevɨ aꞌmweraavɨ keꞌbaꞌnanyanna wɨdɨna. Kɨrɨꞌ kɨmaꞌnyawɨ gannya gaveraavɨ aangyagaala nayaa wɨjɨwaakɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yɨrɨka savɨ nyɨla kabwalaawaꞌ aalɨbumaangevɨ Jizaazai gamɨreraavɨ wɨdɨna “Aalɨbunya davɨ kengihɨrɨ gaꞌmakwawaana!” ");
INSERT INTO byr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wɨdɨna kyaꞌ kwala naangengɨ yagalyaꞌmaꞌna yeva gamɨrera sɨpɨyavɨ Jizaazai wɨlamwaaidɨꞌnyɨyavɨ wɨlamwaaina kyeꞌ gamɨ kwarɨjɨ makuna yaꞌ. Nabaai sɨpɨya pɨnɨ aalyavɨ yɨlarake wɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kaanna kaanna wodaapi yɨhuꞌmaanaryaꞌ kyaꞌ aalɨmavajɨnaaka sɨpɨyavɨ yɨlawɨresɨꞌnaabɨna kyaꞌ sɨpɨyavɨ aalya buladɨꞌnyɨna yaꞌ. Aalya naangeꞌ buladɨꞌnyɨna kyaꞌ gamɨrera dara wanganesaꞌ “O, weꞌ, nemɨ balaajɨwona!” ");
INSERT INTO byr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Deva Jizaazai sɨpɨyavɨ lɨkimagɨ mwaalakei dɨhaihɨsavɨ se warakerɨ. Deva dɨthɨkavɨmwaaihɨna yeva yarai wɨdɨna “Aaka, Nejɨwaakadɨnyaigɨ, nemɨ yarai nyɨwawaadɨka! Nemɨnyɨna ‘Nabaipɨka!’ myawɨrijɨvanɨgɨ?” ");
INSERT INTO byr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sara wɨdɨna kyeꞌ Jizaazai dɨkaaꞌna yaka yɨhusavɨ maanga wɨdaka “Miꞌnanyɨra,” aalyavɨ wɨdɨna “Aalyaꞌgɨ jaka madɨnna! Kave warɨna ja!” Wɨdɨna yakevɨ yɨhuꞌmaanaryaꞌ miꞌna mudaꞌna kyaꞌ aalyaꞌ kave warɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aalyaꞌ kave warɨna kyaꞌ Jizaazai wɨdɨna “Lɨka baaꞌna yɨvanɨgaꞌ! Gotɨyarɨ malɨmwagyɨvanɨgaꞌ lɨka yɨwaasaꞌ!” ");
INSERT INTO byr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Gamɨrera sara wanganeva lɨka naanga yeva dɨneꞌ “Yɨhusasɨ aalyasɨ sawaai gamɨre yagaalyaꞌ wɨꞌnɨwaalyaꞌ be aꞌmwelaka!” ");
INSERT INTO byr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Aalɨbunya pimagɨnna Aꞌmwe Geraaza mwaalyara mwaaidapɨjɨyabanna yɨꞌmavaawɨna kyeꞌ ");
INSERT INTO byr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","sahwai sɨpɨyavɨdaaꞌnyɨ walamwaaina yadɨꞌnyɨ yɨmeꞌnyaꞌbɨꞌ aꞌmwe pwai simaanga gɨlaaya wakesabadaaꞌnyai yɨmaka widei gamɨnyɨna wɨjɨmaꞌnaabɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aꞌmwe sai yuyagaaꞌ gɨlaaya wakesaba mwaalakelyɨ. Aꞌmwe aane pwai kwai gamɨnyɨ senɨyabaalyɨ wɨla mavwɨyɨ yannei. ");
INSERT INTO byr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sareꞌ darevɨnyɨ. Kwalaalyagaaꞌ aꞌmwera senɨyabara maareva asɨraarɨ wɨla pwekɨpwekya sɨvɨlyɨraarɨ wɨla pwekɨpwekya kyeꞌ gamɨ sai asɨraarɨ wɨla pwekɨnɨke galayesɨwɨꞌna yaka sɨvɨlyɨraarɨ wɨla pwɨyɨnɨke sɨlyalyɨ lɨvatamayesɨꞌnyɨna yaꞌ. Sareꞌ aane pwai kwai dɨragɨnnakei sahwarɨ madathɨvalyɨ yannelyɨ. ");
INSERT INTO byr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yuyagaaꞌ yɨrɨkevɨ sawɨsavɨ gɨlaaya wakadɨvɨsabajɨ mugunyabajɨ kaanya yamaryada jaka naanga dada gannya kɨlaakejɨkɨ sɨlyajɨ lɨvadaidaarivainyɨna yaꞌ yɨmaka widei. ");
INSERT INTO byr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sai saamɨnyabadaaꞌnyɨ daavakei Jizaazarɨ tɨnna wanganakegaaꞌ yarai kaanyaveꞌna walyaabɨna yaka “Sahwai naangelyɨ,” daka gamɨnyawɨ kwadaai gɨlaka ");
INSERT INTO byr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","jaka naanga wɨdɨna “Jizaazai, Gotɨyai Sɨgunyavɨ munya keꞌmwɨ mwaaidereigɨ midaaka! Nɨmɨnyɨna berɨꞌ jɨzɨwaana? Gotɨyarɨneꞌna naangeꞌ gɨthɨvanɨge. Daanga manyɨjaavɨnnera! Mala manyɨradɨnnera!” ");
INSERT INTO byr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Sareꞌ dareꞌnesɨ, Jizaazai “Yɨmakaihi, aꞌmwere munyɨkɨdaaꞌnyɨ dɨwila!” wɨdakeꞌna. ");
INSERT INTO byr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sai yɨwaaraꞌna yawalyaadɨꞌ “Gɨmɨnyɨne yayaꞌ berɨvaka?” Yɨwaaraꞌna yawalyaadɨkeꞌ yɨmaka widei wɨdɨna “Nɨmɨnyɨne yayaꞌ Kwala Naangeinyɨ. Sareꞌ nemɨ kwala naangeina mwaaihoꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sara wɨdaka yagaala dɨragɨnna dɨza yaꞌ “Kwaaka davɨdaasɨ yɨmakeraavɨ mudaasɨnna!” ");
INSERT INTO byr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mugunya sakyavɨ yaawaryara kwala naanga nɨdaaꞌnyɨna yadaapɨjɨ ");
INSERT INTO byr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","yɨmakera dɨragɨnna wɨdɨna “Yaawaryaraayabanna dɨnedaasa! Yaawaryaraavɨre munyɨkaavɨ wimɨlaadeꞌna dɨnedaasa!” ");
INSERT INTO byr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yɨmakera sara wɨdɨna kyeꞌ Jizaazai “Yo, dɨwila!” Wɨdɨna kyaꞌ yɨmakera aꞌmwerɨdaaꞌnyɨ bwalyuna yeva yaawaryaraavɨ wɨlɨna kyeꞌ yaawaryara kwala naanga (2,000) mwaaidapiyara davaanyavɨ yarai walaawɨna yeva aalɨbunyavɨ walaꞌna yeva yuyara balɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Saba yaawaryaraavɨ yɨꞌdɨvaidɨvɨsara dara wanganesaꞌ “O, akai, nemɨre yaawaryara mena davaimwaava!” Deva yarai wɨna yɨna yeva angebajɨ wawɨnyangɨjɨ saraavɨ wɨdeꞌ yagaala saꞌ. Wɨdesaꞌna aꞌmwera dɨnyɨna “Sara yɨmaꞌnɨwakeꞌ nemɨ walyanganaana!” dɨneva walyaabɨna. ");
INSERT INTO byr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jizaazaryawɨnna walyaabɨna yeva dara wanganesaꞌ “Aꞌmwei kwaabɨhannya mariraꞌnakei sɨduta nayaa yawɨꞌmanɨkei kɨgaaꞌ yɨmaka kwalaalyara mwaalesai tewaanyai damwaalɨka!” Deva lɨka naanga yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Lɨka kyeꞌ aꞌmwera yuya wanganesara mudɨkeraavɨ yɨmaka wɨlakerɨ sara yɨmaꞌnakevɨnajɨ yaawaryaraavɨnajɨ wɨjɨwaakɨna. ");
INSERT INTO byr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Sara wɨjɨwaakɨna kyeꞌ sabanyara sarɨ naanga wɨdɨna “Nemɨreba davɨ namwaaidɨka! Dɨwona!” ");
INSERT INTO byr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wɨdɨna yesavɨ sai sɨpɨyavɨ yɨladaaꞌdɨꞌnyɨ yɨmaka wɨlakei naangeꞌ widaanganna “ ‘Gɨmɨjɨ mwaaimuneinyɨ wɨma!’ gɨthɨwa.” ");
INSERT INTO byr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sara wɨdɨna kyaꞌ Jizaazai wɨdɨna “Aawa. Sare kɨrɨꞌ gɨnnya angevɨna wawaꞌgɨzɨ gɨnnya jɨlɨkaimɨraayangɨ Gotɨyai sara nayaa gyɨwakenna gɨmɨnyɨna Gotɨyare kale yɨwakeꞌna sara duzɨwaakya!” ");
INSERT INTO byr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wɨdɨna yakeꞌna sai kaanna wɨna yaka Angaba Atɨraalyaba saba Jizaazai gamɨnyɨna sara yakenna sara kujɨwaakaꞌ aꞌmwe yuyara atɨka maruꞌnaꞌna yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jizaazai sɨpɨyavɨ wɨlamwaaidɨsɨ ayɨhɨrɨna sɨpɨyaꞌ ayɨna makuna yakegaaꞌ gamɨnyawɨnna kwala bwaꞌnaanya naangeꞌ yɨꞌbwaꞌnamwaaina yadapi sai aalɨbumaangevɨ mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mwaalɨna yadɨꞌnyɨ Lotuangevɨ maremwaaide pwai Jaarazai woꞌnɨkei bwanganna yaka gamɨre sɨvɨlyaraaryaba kwadaai gɨlɨna yaka ");
INSERT INTO byr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","yagaala dɨragɨnna wɨdɨna “Nɨnnya taaya nabalɨnakeꞌ baladeꞌna. ‘ “Tewaanyaꞌ yɨmaꞌnana! Gaala mwaalana!” daꞌmujɨ “Nɨmɨre asɨraai dathɨwagaawɨma!” ’ daꞌgi dulaama!” ");
INSERT INTO byr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aꞌmwei sara wɨdɨna kyaꞌ gamɨjɨ wawagi. Kaanya wodaakɨlyɨ kwala naangeꞌ wawesara gamɨnyawɨ galyɨtata yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Galyɨtata kyeꞌ aꞌmwe nalaavɨnakeꞌ mwaalakeꞌ baizaaka maꞌnadeꞌ yuyagaaꞌ kwarame atɨraai sɨvɨlyɨrɨdaaꞌnyɨ pɨrɨwaalya wavɨlaꞌnɨkeꞌ mwaalakesɨra nalaavɨnakeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nalaaya maalɨka waꞌdɨꞌnyɨ nalaavɨnakevɨ dotarava yaamɨjɨ yɨya kyeꞌ daanga naanga wɨvɨnakeꞌ. Gamɨre yuyajɨya mena wɨjaavɨna yakeꞌ. Tewaanya aane pɨrɨꞌ kɨrɨꞌ mi wiakeꞌ. Aawa. Aꞌmwe nɨgwɨmaayaꞌ sɨnnawɨ nalaaya maalɨkeꞌ kɨnɨnnakeꞌ, sagaaꞌ nalaaya naangeꞌ kɨnɨnnakeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sareꞌ Jizaazarɨneꞌna wɨꞌnaka kwala naangevɨ dusɨdaaꞌnyɨ lɨka yulyaraabɨna yaka gamɨre kwaabɨyɨvɨsavɨ yɨmeꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sareꞌ dareꞌnesɨ. “Gamɨre kwaabɨyɨvɨta gavevɨ yɨmeꞌnɨwɨjaꞌ nɨmɨ tewaanya yɨmaꞌnɨma!” dakeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yɨmeꞌnyaꞌbɨꞌ kurabala yaalɨka miꞌna yɨna. Miꞌna yɨna yaka dara wanganakeꞌ “Nɨmɨre nabalyaꞌ miꞌna daaka!” ");
INSERT INTO byr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sareꞌ yɨlaaya kyaꞌ yɨmeꞌnyaꞌbɨꞌ Jizaazai sahwai dara wanganakeꞌ “Nɨmɨnyɨ dɨragɨnyaꞌ nyalyɨwakeꞌ daaka!” Dakegaaꞌ kwala naangevɨ yarai gɨnyɨwannaka wɨdɨna “Nɨmɨre kwaabɨyɨvɨsavɨ aai yɨmeꞌnɨwaka?” ");
INSERT INTO byr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Sara wɨdɨna kyaꞌ “Kwala bwaꞌnaanya dathaꞌ gɨmɨnyɨ galyɨtata yɨvanɨgasaꞌna gara nedɨwaa? ‘Aai yɨmeꞌnɨwaꞌ?’ ” wɨdeꞌ gamɨrera. ");
INSERT INTO byr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wɨdesaꞌ sahwai sareꞌ yakeꞌ tɨnna wanganyaꞌnei tɨnna wanganaasɨna. ");
INSERT INTO byr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wanganasadaaꞌnyɨ aꞌmwe saꞌ “Nɨmɨre kɨlaakejɨꞌ tewaanyaꞌ yɨmaꞌnɨwaka,” daka lɨka yɨna, bɨꞌbɨta yaka gamɨnyabanna bulaꞌna yaka yuya sanna wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yuya sanna wɨdɨna kyaꞌ sai wɨdɨna “Nyɨraavɨ, nɨmɨnyɨna nayaa yawɨralɨmwamwaanyaꞌna gɨmɨ maamɨdarya yɨmaꞌnɨwaa. Gɨmɨre kɨlaakeꞌ kuna waradeꞌ kwaamuꞌna dɨmwaihwodeꞌgɨnyɨ,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kuna wɨdɨna yadaaꞌnyɨ Lotuangevɨ maremwaaiderera angevɨdaasɨ bwalyuna yeva kaanna bɨna yeva wɨdɨna “Gɨnnya taayaꞌ mena baimwaka. Gotɨyare yagaala wɨjɨwaakaderɨ wawɨnya naanga kuna minna! Taanga wɨjaavanɨgɨnyaꞌ kabaimwakɨra.” ");
INSERT INTO byr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sahwara wɨdadaapi Jizaazai yagaala saꞌ kadɨka wɨꞌnada Lotuangevɨ maremwaaiderɨ wɨdɨna “Lɨka minna! Nɨmɨnyɨna sɨmunyavɨ dɨragɨnna dɨlɨmwana!” ");
INSERT INTO byr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sara wɨdɨna yaka aꞌmwe pwaraavɨ wɨdɨna “Sarɨmɨ dɨmwaalyi! Nɨmɨjɨ Pitalyɨ Jemɨzalyɨ Jonɨ Jemɨzare gyaꞌmwelyɨ gave saina wawaana! Aane pwaigɨ kwaigɨ aawa.” ");
INSERT INTO byr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wɨdɨna yaka kaanna wɨna yeva Lotuangevɨ maremwaaidere angevɨna yɨꞌmavaawɨna kyeꞌ dara wanganakeꞌ “Aꞌmwemɨlɨka yagaala naanga bazɨwodaapi pwara kɨnna dathɨvanɨgava! Jakɨnna dathɨvanɨgava!” ");
INSERT INTO byr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Miꞌna wanganaka angevɨ wɨlɨna yaka wɨdɨna “Yagaala naangesɨ jakɨnnyasɨ baaꞌna dɨvanɨgava! Taayaꞌ balya myɨwaꞌ. Aawa. Se warɨꞌ.” ");
INSERT INTO byr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sara wɨdɨna kyaꞌ gamɨnyɨna mayagaaijɨka kamaregyeꞌ kɨrɨꞌ sahwai yuyaraavɨ mwasawɨnna maratɨvatawaasɨna yaka taayavɨ ganaangesɨ ganɨmaangelyɨ gamɨnyawɨ mwaalesarajɨ sa makuna kyaꞌ taayayabanna wɨlɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Miꞌna wɨlɨna kyeꞌ gɨlaayavɨ ata lɨmwanna yaka kunnya yagaala wɨdɨna yaꞌ “Talitha kumi!” aangyagaala dɨna “ ‘Taayaꞌgɨ dɨthɨkaaka!’ gɨthɨwa.” ");
INSERT INTO byr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sara wɨdɨna kyaꞌ yɨmeꞌnyaꞌbɨꞌ taayaꞌ dɨkaaꞌna yaka kaanya dɨkavayamarina yaꞌ. Sareꞌ dareꞌnesɨ. Taaya saꞌ kwarame atɨraai sɨvɨlyɨrɨdaasɨ pwaraalya wavɨlavakesɨra. Kaanya dɨkavayamarina kyaꞌ yɨmeꞌnyaꞌbɨꞌ atɨka kamaruꞌnareꞌ ");
INSERT INTO byr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","sai dɨragɨnna wɨdɨna yaꞌ “Sarɨmɨ nayaa dɨnyuꞌnyɨla! Nɨmɨ yɨwe saꞌ aꞌmwe pwai kwai aꞌmwe pɨrɨꞌ kɨrɨꞌ nyuꞌnadɨka! Dahaaꞌ taayavɨne wapaaya nyaꞌne dumaarila!” ");
INSERT INTO byr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sabadaasɨ sai gannya angebanna wɨyaꞌnei wɨna. Gamɨrera mɨdɨnna. ");
INSERT INTO byr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Gamɨre angebanna kyɨꞌmavaꞌ Juyaraavɨre Kwazaakegaaꞌ yɨmaꞌnakegaaꞌ Lotuangevɨ buladaaꞌna yakegaaꞌ wɨjɨwaakɨna. Sara wɨjɨwaakɨna yadaaꞌnyɨ aꞌmwe kwalaalyara wɨꞌneva atɨka maruꞌnareva dɨnyɨna “Yagaala dazaꞌ aꞌmwe dai gawɨ maaꞌmwaka! Bewai yɨwɨrivanɨka! Dɨragɨnya yɨya wɨꞌnɨwaꞌdo gamɨre asɨraalyɨ gara yɨwaka! ");
INSERT INTO byr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kaaꞌmadaayai midaaka! Maarɨyaaꞌ gawaalɨꞌ midaaka! Jemɨzalyɨ Jozɨzalyɨ Juthaazalyɨ Saaimonɨjɨ saraavɨre kwɨyaꞌmwei midaaka! Dava nemɨjɨya ganyaabulaanga damwaaihava! Nemɨjɨ avaalyalyɨ. Aꞌmwe naangei mɨka,” dɨnyɨna yeꞌ. Sara dɨnyɨna yeva Jizaazare sɨmunya myawɨri kyeꞌ sagaaꞌ gamɨnyɨna sɨnna tɨka davɨna. ");
INSERT INTO byr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Sɨnna tɨka wɨdaꞌdaaꞌnyɨ Jizaazai wɨdɨna “Pwara Gotɨyare wɨꞌnawɨjɨwaakyarɨne yayaꞌ yɨlaaya makimanɨgaꞌ. Kɨrɨꞌ gamɨre kwaakeba mwaalyarajɨ kwɨyaꞌmwerajɨ gannya angevɨ mwaaihasajɨ sa gamɨre yayaꞌ mamakɨlyɨvanɨgaꞌ.” ");
INSERT INTO byr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Sara wɨdɨna yaka angeba saba dɨragɨnya yaꞌne aane pɨnɨ kɨnɨ myaꞌ. Kɨrɨꞌ nalaavɨnaka pwaina pwaina, pɨrɨꞌna pɨrɨꞌna ata kudathɨwagaꞌ tewaanya mwaalɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sara yesaꞌna dɨna “Aꞌmwe kwalaalyara nɨmɨnyɨna manyɨlɨmwagyɨwaava!” Sara yesaꞌna maruꞌnaꞌna yaꞌ. Sabanne angebanna wɨjɨwakamarina yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sara yakegaaꞌ atɨraai sɨvɨlyɨrɨdaasɨ pwaraalyara bɨna kyeꞌ “Nɨmɨre yagaalyaꞌna aꞌmwe pwaraaihi pimagɨnna dɨwila! Aꞌmwe pwaraaihi pimagɨnna dɨwila! Aꞌmwe yuyaihi sana sana jɨla! Nɨmɨre dɨragɨnyabwi kyɨhɨzaavaꞌmujɨ aꞌmwe yɨmaka widɨvɨsaraavɨ wanganapɨjɨ yɨmakeraavɨ gɨrɨꞌnakeraavɨ duthaasideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tusavɨne gɨlyɨvɨta maayaihi yadisarɨkananyaihi dɨwila! Tɨka wapaaya, gɨlyaꞌ, nɨgwɨgɨlyɨꞌ mamaapɨnera! ");
INSERT INTO byr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Aawa. Kwaariꞌmasɨvɨla dɨvaazɨꞌmaꞌnyɨla! Baazɨꞌmaꞌnya pɨrɨwaai mabaazɨꞌmaꞌnɨpɨnera! Sareꞌna yarai dɨwideihɨlyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nabaai gamɨreraavɨ wɨdɨna “Angebanna yɨꞌmavaawapɨjɨ anga gave pɨrɨvɨ dɨmwaalyɨla! Wapaayaꞌna myɨrɨꞌmaranamaripɨnera! Anga gave saba se wapɨjavadaasɨ kaanna dɨwideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Anga pɨbanyara ‘Aꞌmweraaihi kaajɨla!’ mihɨza pwara ‘Kɨrɨmɨre yagaalyaꞌ wɨꞌnaana!’ mihɨza kwara kamwaalapɨjɨ kaanna wɨyagaaꞌ ‘Anga gɨrɨkitaꞌnanyababɨsaba midaaka!’ dɨna yakɨlyɨ tɨrya saraaihɨre sɨvɨla warojɨya purakɨrasɨꞌna yakɨlyɨ kaanna dɨwideꞌna angebanyara kunnyabwi yawɨpɨꞌderera. Sareꞌ jalɨkurakyaꞌnesɨ.” ");
INSERT INTO byr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Gamɨrera miꞌna wɨꞌneva pina pina yɨwɨnadaaꞌna yeva aꞌmweraavɨ wɨdɨna “Sarɨmɨre sɨmunyabwi mudɨkebwi jawɨramaarila!” ");
INSERT INTO byr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sara wɨdɨna yesagaaꞌ yɨmaka kwalaalyaraavɨ wɨdaasɨna yeva aꞌmwe nabalɨnakeraavɨ yɨsiwelivananyaꞌ mɨnyagɨnyangɨ dɨngɨna yeva tewaanya wɨmwaaihɨna yeꞌ gamɨrera. ");
INSERT INTO byr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yuyaba aꞌmwera gamɨ yakengɨ dɨnyɨdɨnya yadɨvɨsaꞌna pɨba maremwaaidei Erotɨyai dara wɨꞌnakeꞌ “Sahwai nawɨꞌnya jɨvanɨka!” Wɨꞌnakeꞌ daresɨ. Pwara Jizaazarɨna dɨnyɨna “Gamɨ sai Jonɨnyɨra. Jonɨ Bavɨtaazɨya Yadei balaka Gotɨyai yɨdɨkaavaka savɨna kwaihwaainakei dɨragɨnya dɨvanɨgɨnyaꞌ maaraka tewaanya saza yɨvanɨkelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Sara dɨnyɨna kyeꞌ pwara dɨneꞌ “Gamɨ sai Yɨlaajai kɨgaakuna balyaakelyɨra.” Dɨnesavɨ pwara dɨnyɨna “Aꞌmwe sai wɨꞌnawɨjɨwaakadei sɨnnawɨ Gotɨyarɨ wɨꞌneva aꞌmweraavɨ wɨjɨwakyaasarabɨsalyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Aꞌmwe pwara sana sana kadɨneꞌ Erotɨyai wɨdɨna “Jonɨ sahwalyɨra. Aꞌmwerɨ wɨde ‘Aꞌmwe Jonɨmɨ tɨlɨnnyaꞌ doripuka!’ Kude balakei dahaaꞌ tewaanya mwaalɨꞌ,” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Sareꞌ dareꞌnesɨ. Sahwai Erotɨyaazaꞌ gyaꞌmwe Pilipɨmɨre balaangaꞌ kwala maaraꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Sareꞌ dareꞌnesɨ. Jonɨ wɨdɨna “Jaꞌmwere aꞌmweꞌ baaꞌna maꞌmwaana! Sabwina Gotɨyare Kɨwɨnyabwi galazekɨvaimwaa,” wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sara wɨdɨna kyaꞌ Erotɨyaazavɨ sɨnna tɨka wɨdaꞌdaaꞌnyɨ Erotɨyai Erotɨyaazavɨ yɨlaaya maryaka yakeꞌna Erotɨyai aꞌmweraavɨ kudaasaꞌ Jonɨmɨ wɨla marirakɨna yeva kalavuzangevɨ wɨmwaaihɨna yeꞌ. Jonɨ kalavuzangevɨ kamwaalaꞌ Erotɨyaazavɨ sɨnna tɨka kuna wɨdaꞌdaaꞌnyɨ “Jonɨmɨ tamakɨma!” dada Erotɨyarɨ kudaꞌ “Aawa,” wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Sareꞌ dareꞌnanyɨ. Sai dɨna “Jonɨ aꞌmwe naangelyɨra. Sahwai yɨdaꞌmaraangei. Tewaanyaburɨ mwaaidei,” daka “Erotɨyaazaꞌ naramakadɨka!” daka Jonɨmɨ kalavuzangevɨ nayaa maremwaaina. Maremwaaina yakei Jonɨmɨre yagaalyaꞌ wɨꞌnada sɨmunya kwalaalya yawɨꞌna yada yɨlaaya yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pɨgaaꞌ Erotɨyaazavɨnegaaꞌ yɨmaꞌnakegaaꞌ Erotɨyai daka “Nɨwaaꞌ nɨmɨnyɨ nyɨmaarakegaaꞌ jɨmaꞌnɨwaka!” daka gamɨre wɨdaayadɨvɨsaraavɨ wɨdɨna “Yarala, dahaaꞌ Kwaaka maremwaaidɨvɨsarajɨ aawɨlasaraavɨ maremwaaidɨvɨta naangerajɨ Galɨli mwaalya naangerajɨ saraavɨna tɨka munne jovɨrayɨla dahaaꞌ sagaaka!” Wɨdɨna kyaꞌ Erotɨyaazaꞌ dara wanganakeꞌ “Dahaaꞌ Jonɨmɨre balyagaaꞌ daaka!” ");
INSERT INTO byr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sara kadaꞌ tɨka munne nadaapi Erotɨyaazavɨre garaavaangaꞌ bulaawɨna yaka kwarame yɨna. Taayaꞌ kwarame sara kyaꞌ Erotɨyalyɨ aꞌmwerari yɨlaaya yɨna. Yɨlaaya yɨna kyeꞌ Erotɨyai taayavɨ wɨdɨna “ ‘Sare nyɨjaama!’ kanyɨdaꞌgɨzɨ gɨzaavɨdeinyɨra. ");
INSERT INTO byr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nebulyaꞌ gɨthɨwa ‘Nɨmɨre gɨlyɨvɨta naange warɨꞌ. Gɨlyɨvɨta sa Kingɨyainyɨreba yune tɨnnyabanna gɨzaapalyɨdeinyɨ,’ ” wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sara wɨdakeꞌ walyuna yaka ganaangevɨ wɨdɨna “Nɨmɨ berɨꞌna wɨdɨjɨwana?” “ ‘Jonɨ Bavɨtaazɨya Yadere mɨnyagɨnyaꞌ dɨnyɨmaryaama!’ sara duthana!” ");
INSERT INTO byr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sara wɨdɨna kyaꞌ yɨmeꞌnyaꞌbɨꞌ taaya saꞌ yarai bulaawɨna yaka Erotɨyarɨ wɨdɨna “Dara yawɨꞌmanɨge. Jonɨ Bavɨtaazɨya Yadere mɨnyagɨnyaꞌ maaraꞌgɨzɨ paletɨyavɨ wakaꞌgɨzɨ yarai nyɨjaama!” ");
INSERT INTO byr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wɨdakevɨ Erotɨyai kale naanga wiadaaꞌnyɨ “Nebulyaꞌ gɨthɨwa,” wɨdakeꞌna nabaai tɨka munne nesara sara wɨꞌnesaꞌna “ ‘Aala,’ nudɨwɨdɨka!” daka ");
INSERT INTO byr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","yɨmeꞌnyaꞌbɨꞌ damerɨ wɨdaasaꞌ “Jonɨ Bavɨtaazɨya Yadere mɨnyagɨnyaꞌ dalamaralɨngipuramaraawa!” Wɨdaasakei walyuna yaka kalavuzangevɨ Jonɨmɨre tɨlɨnnyaꞌ woripuꞌna yaka ");
INSERT INTO byr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mɨnyagɨnyaꞌ paletɨyavɨ wakɨna yaka makulaabaka taayavɨna bulawɨjaavaꞌ. Kabulawɨjaavaꞌ taayaꞌ ganaangevɨna wɨjaavɨna. ");
INSERT INTO byr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sagaaꞌ Jonɨmɨrera dara wɨꞌnesaꞌ “Weꞌ, Jonɨ mena davaimwaka!” Deva kaanna wɨna yeva kɨlaakejɨꞌ maarɨna yeva kaanna makwaweva simaangevɨ wakɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jizaazai wɨdasaawakera yagalaaweva ayɨna beva gamɨnyɨ kumɨ yuya sara yesaꞌna nabaai wɨjɨwaakesaꞌna wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wɨdɨna yesara mwaaidapi kwalaalyara bulawɨꞌnyaagaidɨvɨꞌ wodaapi pwara bulawɨꞌnyɨna yadaapi Jizaazalyɨ gamɨrerajɨ wapaaya nyaꞌnegaaꞌ mwarina. ");
INSERT INTO byr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wapaaya nyaꞌnegaaꞌ mwari yakeꞌna gannyaraavɨ wɨdɨna “Gaveina aꞌmwera maayawɨnna kwawaajɨ pɨgaaꞌ kwazaaka dɨmwaalyɨla!” Sara wɨdɨna kyaꞌ sahwara gavera sɨpɨyavɨ wɨlamwaaidapi pɨwɨ aꞌmwera maayawɨnna makuna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Makuna yadaaꞌnyɨ aꞌmwe kwalaalyara tɨnna wanganeva “Jizaazai gamɨrerari damakuvanɨka!” deva anga yuyabanyara aalɨbumaangevɨ kaanyaveꞌna kaanyaveꞌna sahwaraavɨ wavɨlaveva aꞌmwera maayabanna yɨꞌmaꞌna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yɨꞌmaꞌna yevera aalɨbumaangevɨ mwaaidapi gamɨ kwaakevakɨ bwalamwaaina yaka dara wanganakeꞌ “Kwala bwaꞌnaanya naangeꞌ daaka!” Daka “O, aꞌmwe dara aꞌmwe da jɨlɨkyaawarya sipɨzipɨya yɨꞌdɨvaidei maaya yaasɨwaꞌna mwaaihava.” Sara dɨna yakeꞌna gamɨre kale wiadaaꞌnyɨ yagaala kwalaalya gaai wɨjɨwaakɨna yɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wɨjɨwaakɨna yɨna kyaꞌ sawɨtɨrɨnyaburɨ gamɨrera bɨna yeva wɨdɨna “Sawɨsaburɨ menanyɨra. ");
INSERT INTO byr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Dava anga mamannyɨka dava aꞌmweraavɨ duthana! ‘Davadaasaihi, angeburajɨ wawɨnyaba anga mannɨkebajɨ wawopɨjɨ sarɨmɨnne wapaaya nyaꞌneihi dɨnyide dɨmubyɨla!’” ");
INSERT INTO byr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sara wɨdɨna kyeꞌ sai wɨdɨna “Sarɨmɨ saihi wapaaya dumaarila!” Wɨdɨna kyaꞌ “Nemɨ gara yaajɨwo? Nɨgwia kwalaalya (200 kinaaya) maraajɨ kwajɨ gɨrɨkula mubaawɨna yawaajɨ aꞌmwe yuyara wapaaya maalɨka kanɨpɨdɨka!” wɨdɨna gamɨrera. ");
INSERT INTO byr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“Wapaaya gara gara warɨꞌ? Danganamarila!” wɨdɨna. Sai wɨdɨna yakera tɨnna wanganamaryaaweva ayawɨnna beva wɨdɨna “Gɨrɨkula dawaai dawaai daꞌ jawɨnya pwaraalyɨ waꞌdɨꞌnyɨ wangamwona,” butheꞌ gamɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Buthɨna kyeꞌ aꞌmwe sahwaraavɨ wɨdɨna “Kurɨvaarɨyangɨ yuyaraavɨ nayaa geva geva jawɨbwaramwaaihila!” ");
INSERT INTO byr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Sara wɨdɨna kyaꞌ pɨba kumɨ kwala naanga (100) mwaalɨna, pɨba kwala naanga (50) mwaalɨna, sana sana yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sana sana mwaalɨna kyeꞌ Jizaazai gɨrɨkula atɨlya dazajɨ jawɨnya pwaraalyɨ maaraka sɨgunyavina maranganaka Gotɨyarɨna “Su! Wapaaya danna gɨmɨre yayaꞌ makimwa,” wɨdaka gɨrɨkula gunyɨna gunyɨna yaka gamɨreraavɨna wɨmaarina aꞌmwe kwala naanga mwaaidapɨjɨyaraavɨna yanga wɨmujaꞌne. Nabaai jawɨnya pwaraai mɨlɨkɨna mɨlɨkɨna yaka yuyaraavɨna yanga jaapalawɨmudaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kajaapalawɨmudaꞌ tɨka nyɨna kyeꞌ munya yunebanna kwinaꞌ ");
INSERT INTO byr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","pɨnɨ warɨna nɨganakesa warɨna kyaꞌ gamɨrera maarɨna yeva jawɨnya sara nɨganaketa maarɨna yeva gɨlya atɨraai sɨvɨlyɨrɨdaaꞌnyɨ pukaalyangɨ maramihyekuꞌna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wapaaya nesamɨlɨkaavɨdaasara aꞌmwe gavera (5000) paaivɨ taawɨzanɨyara mwaaleva nyɨna yeꞌ wapaaya. ");
INSERT INTO byr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yɨmeꞌnyaꞌbɨꞌ gannyaraavɨ wɨdɨna “Yarala, sɨpɨyavɨ wɨlamwaalapɨjɨ angeba Betɨzaaitha aalɨbunyavɨ pimagɨ mannɨkebanna dɨwideihɨlyɨra. Wodaapɨjɨ kwala bwaꞌnaanya davɨ wɨdɨdehaaꞌnanyɨ ‘Sarɨnnya angengɨ dɨwila!’ Dɨvi nɨmɨ wɨlaabɨdera.” ");
INSERT INTO byr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Sara wɨdakera wɨna kyeꞌ kwala bwaꞌnaanyavɨ “Tewaanya dɨwila!” wɨdaka “Gotɨyarɨ wɨdɨma!” daka mugunyangɨ yɨlaawɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yɨlaawɨna kyaꞌ sawɨsaꞌ kajɨnnaꞌ gamɨrera sɨpɨyavɨ mwaaidapi aalɨbunyavɨ tɨnnyaba sɨpɨyaꞌ wɨlaꞌdɨꞌnyɨ gavei kwaakevakɨ mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mwaalɨna yakei wanganakeꞌ “O, yɨhuta naangeꞌ tɨvaataꞌmwakeꞌna nɨmɨrera aalyavɨ yɨsɨkari yarai yarai makwɨya yadaapi sɨpɨyaꞌ kavena damakuvanɨka!” Daka yɨrɨkunyagaaꞌ aalɨbunyavɨ aꞌba gaꞌnɨguna yaka sɨpɨyaꞌ waꞌdɨsɨyaba “Nɨmɨreraavɨ wavɨlavɨma!” yawɨꞌna. ");
INSERT INTO byr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yawɨꞌna yakei aalyavɨ aꞌba gaꞌnɨguna yakerɨ gamɨrera wanganeva “Ai, gɨlaayai daaka!” deva “Ewɨ,” jaka wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Sareꞌ dareꞌnanyɨ. Yuyara gamɨnyɨna tɨnna wanganna yadɨvɨꞌ lɨka naanga yɨna. “Ewɨ,” jaka wɨdɨna kyeꞌ yɨmeꞌnyaꞌbɨꞌ wɨdɨna “Dɨragɨnna dɨmwaalyɨla! Nɨmɨnyɨra. Lɨka mipɨnera!” ");
INSERT INTO byr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sara wɨdɨna yakei sɨpɨyavɨ yɨlamwaaina kyaꞌ yɨhusaꞌ mi. Yɨhusaꞌ mi kyaꞌ gamɨrera kumɨ sara tɨnna banganakulɨna yeꞌ. Atɨka naanga maruꞌnaꞌna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sareꞌ dareꞌnesɨ. Gamɨre dɨragɨnyaꞌna myawɨri yeꞌ. Sahwai wapaaya gunyadaaꞌnyɨ wapaaya kwalaalya yɨmaꞌnyɨna yakevɨ wanganyawalyaadaasara myawɨri yeꞌ. Aawa. ");
INSERT INTO byr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Aalɨbunyavɨ gaꞌmakuna yeva Kwaaka Ganezaaretɨna yɨꞌmavaaweva sɨpɨyaꞌ wɨla marirakɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Marirakɨna yeva sɨpɨyavɨdaasara waidavadaapi yɨmeꞌnyaꞌbɨꞌ aꞌmwe aꞌmwera gamɨnyɨ tɨnna wanganeva ");
INSERT INTO byr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","kaanyaveꞌna waweva anga yuya dangɨ aꞌmwe nabalɨnakeraavɨ maramarina. Sai mwaaidɨsɨyabanna yɨꞌbɨnnakeraavɨ makabɨna “O sahɨbanna damwaalɨka!” deva sahɨbanna makabɨna. ");
INSERT INTO byr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sahwai anga naanga kɨba anga maalɨka pɨba gazabazaba wɨlyɨrɨꞌmaaꞌna kyaꞌ kumɨ wapemubya yadɨvɨsabanna nabalɨnakeraavɨ makabɨna yeꞌ. Makabɨna yeva yagaala naanga wɨdɨna “Nabalɨnakera gɨmɨre kwaabɨhannyavɨ maangebaarɨ yɨmeꞌnyɨna yɨpɨka!” deva wɨdɨna kyeꞌ nabalɨnakera gamɨre kwaabɨhannyavɨ yɨmeꞌnyɨna yeva yuya sahwara tewaanya mwaalɨna yeꞌ nabalɨnakera. ");
INSERT INTO byr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Aꞌmwe Perɨzɨyarajɨ yagaaikɨwɨjara Jeruzaalemɨdaasara pwarajɨ sara gamɨnyawɨnna yɨbwaramakabɨna yeva ");
INSERT INTO byr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","dara bwanganesaꞌ “Gamɨre pwara ata gɨrɨkitaꞌnanyara asangɨ aalya minyara wapaaya danɨvanɨgava!” ");
INSERT INTO byr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Sareꞌ dareꞌnesɨ. Perɨzɨyarajɨ Juya yuyarajɨ sara dɨnyɨna “Ne sɨnnyawɨnyara sara dɨnɨkeꞌna nemɨ sara yaana!” Dɨnyɨna yadɨvɨꞌ asangɨ aalya minyara wapaaya nadɨvɨtara mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sara wapemubyasɨyara kunnya angevɨ wɨleva aalya minyevera wapaaya manyɨ yeꞌ. Ne sɨnnawɨnyaraavɨrebwi kumɨre sɨmunyangɨdaasɨ maalɨkebwina mɨꞌ. Naangebulyɨ pɨburajɨ lɨmwadɨvɨꞌ “Nemɨre kuryara gɨrɨkitaꞌnanya nyɨpɨdɨka!” deva kaapɨvananya maaꞌgula paletɨya aalya yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sara yadɨvɨsara Perɨzɨyarajɨ yagaaikɨwɨjarajɨ sara yɨkabɨna yeva yɨwaaraꞌna “Gɨmɨrera ‘Ne sɨnnawɨnyaraavɨrebwi yaana!’ majara ata gɨrɨkitaꞌnanyajɨ nɨvanɨgaꞌ. Ne sɨnnawɨnyaraavɨreburɨ kaanya myamarivanɨgaꞌ. Aawa. Ata gɨrɨkiꞌnakera wapaaya nɨvanɨgaꞌ. Sabwi beꞌna yɨvanɨgava?” ");
INSERT INTO byr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tɨviꞌna yɨwaaraꞌna kyeꞌ wɨdaꞌ “Aazaayai Gotɨyarɨ wɨꞌnawɨjɨwaakadei pɨropetɨyai sarɨmɨnyɨna kwaasɨyabwi yadɨvɨsaihɨrɨna nayaa dɨnɨkabaaibɨsasɨra. Aꞌmwera nayaa maangiꞌna nyɨdɨvanɨgasaꞌ Kumɨre sɨmunyabwi menyaba warɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Gazare yɨlaaya nyɨdɨvanɨgasangɨ muꞌnyɨvanɨge. Aꞌmweraavɨrebwi yaasɨwaꞌna wɨjɨwakadaapɨri ‘Gotɨyarebulyɨra,’ yawɨꞌna yɨvanɨgaꞌ. Sara dɨnɨkesɨra. ");
INSERT INTO byr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Sarɨmɨ Gotɨyare yagaaikɨwɨnya yagalyaꞌmaꞌmanɨgasaꞌ aꞌmweraavɨrebwi nayaa lɨmwamanɨgaꞌ.” ");
INSERT INTO byr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nabaai wɨdɨna “Nawɨꞌnyɨna Gotɨyare yagaaikɨwɨnya wasɨꞌna yadɨvɨꞌ sarɨnnyabwi mɨdɨnyaꞌneihi yɨvanɨgasaihɨlyɨra. Beꞌna yɨvanɨgava! ");
INSERT INTO byr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sareꞌ dareꞌnesɨ. Mozɨzai wɨjaaꞌ ‘Gɨmaamaangelyɨ gwaangesɨ sayorɨ nayaa kadɨka dɨvadaꞌgalawɨꞌnana!’ Nabaai ‘Pwai yuyagaaꞌ ganɨmaangerɨna ganaangevɨna bɨrala yadei yuna balana!’ ");
INSERT INTO byr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mozɨzai sara wɨdɨna yaaka kɨrɨꞌ sarɨmɨ dadɨvɨꞌ ‘Pwai wɨdazaꞌ “Nɨmwai pwai nɨwaaꞌ kɨrɨꞌ kamaaradɨke nɨmɨre Kovanɨyaꞌ warɨkengɨra.” ’ (Kovanɨyaꞌ yagaala saꞌ “Gotɨyarɨna wɨjaayaꞌneva dɨnɨkeꞌ.”) ");
INSERT INTO byr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Sara kudozɨ ‘Kovanɨyaꞌ miꞌna wakaꞌgɨzɨ gɨmaamaanga pwarɨna gwaanga kɨrɨvɨna mujaavɨnna!’ sarɨmɨ sara dakadɨvɨꞌ aꞌmwe sai navɨka mwaaladelyɨ. Sara yadɨvɨꞌ ‘Nemɨrebura nemɨre kaimɨraayaraavɨ wɨjɨwakaana!’ ");
INSERT INTO byr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sara dadɨvɨsaꞌna ‘Gotɨyai wɨjaakeꞌ gesɨra,’ yawɨꞌdɨvɨtabaaibɨsasɨ. Nabaai avaalyabɨta kwalaalya sana sana yadɨvɨsaihɨlyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sagaaꞌ kwala bwaꞌnaanyavɨ jaka ayɨna jɨvwaramaaꞌna yaka wɨdɨna “Yuyangihi, nyuꞌnapi sɨmunya nayaa jawɨrila! ");
INSERT INTO byr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mwasɨmagɨnya aane pɨrɨꞌ kɨrɨꞌ aꞌmwe pwarɨ kulaabozɨ gɨrɨka yɨmaꞌnannei mɨka. Aawa. Yuya aꞌmwe sare kusɨmagɨnyavɨdaasa kwalyaabozɨ gɨrɨka yɨmaꞌnadengɨra. ");
INSERT INTO byr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Aꞌmwei kadɨꞌnakei nayaa wɨꞌnana!” ");
INSERT INTO byr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kwala bwaꞌnaanyavɨ yagalyaꞌmavaka angevɨ wɨlɨna yakegaaꞌ gamɨrera yagaala keꞌbaꞌnanyaꞌna wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Sara wɨdɨna kyeꞌ wɨdɨna “Nabaai pwarajɨ sarɨmɨjɨ sara myawɨrijɨwaava! ‘Yuya kamaranojɨ mwasɨmagɨnya aꞌmwerɨ kulaabozɨ gɨrɨka yɨmaꞌnannei mɨka,’ myawɨrijɨwaava! ");
INSERT INTO byr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Wapaaya sa sɨmunyavɨ mulyɨ yadeꞌnanyɨ. Aawa. Gamɨre sɨngwalɨkerɨ bwalaawɨna kyojɨ lɨka wɨrasɨꞌna yadengɨra.” Sara wɨdakeꞌ “Tɨka wapaaya yuya kɨmaaka mɨka.” ");
INSERT INTO byr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sai wɨdɨna “Aꞌmwere kusawɨnyavɨdaasaꞌ walyaabɨna kyojɨ saꞌ gɨrɨka yakadesɨra. ");
INSERT INTO byr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sareꞌ dareꞌnanyɨ. Aꞌmweraavɨre sɨmunyavɨdaasɨ yawɨta kayaaꞌna naanga yɨna, gamɨ marɨdaakunyɨna, kuka yɨna, aꞌmwerɨ tamakɨna, ");
INSERT INTO byr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","aꞌmwevɨ ata lɨmwanna, gɨlyɨvɨsangɨ wabarɨnna yɨna, yɨ sɨnna tɨka wɨdayaꞌnebwi yɨna, kwaasɨ yɨna, jɨlɨkera yadɨvɨsabaaibɨꞌ yɨna, tɨganaarya yɨna, pwarɨna kwaasɨ yagaala dɨna, bɨrala yɨna, pihadɨka yɨna, yɨ yaasɨwaꞌyamarya yɨna yadɨvɨsangɨra. ");
INSERT INTO byr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kayaaꞌnanya yuya davura kusawɨnyavɨdaaꞌnyɨ walyaabɨna, aꞌmwere sɨmunyavɨdaaꞌnyɨ walyaabɨna kyojɨ gɨrɨka yakɨna yadengɨra,” Jizaazai wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sabadaasai angeba Taayaa sabannei wɨna. Anga saba Kwaaka Sɨrɨya mannɨkeba. Sai wɨna yakei “Aane pwai kwai aane pɨrɨꞌ kɨrɨꞌ nanyanganadɨka!” daka angevɨ kave mwaalɨna yada lɨka yulyaꞌdɨꞌnyɨ kɨrɨꞌ aꞌmwera dara wanganeꞌ “O, dava sahwai damwaalɨka!” Miꞌna kadeꞌ lɨka myulyari yakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yɨmeꞌnyaꞌbɨꞌ taayaꞌ yɨmaka widevɨ ganaangeꞌ “Sahwai mwaalɨka,” wɨꞌnaka bɨna yaka gamɨre sɨvɨlyɨraaryaba aꞌmwe saꞌ bularutawaꞌna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aꞌmwe saꞌ Gɨrikɨyagaala dadeꞌ Kwaaka Sɨrɨya mwaalya Pɨnɨzɨyaraavɨreꞌ aꞌmwe saꞌ naanga yɨwaaraꞌna “Nyɨraavaangavɨre munyɨkɨ yɨmakerɨ duthasaawadeigɨ daaka?” ");
INSERT INTO byr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yɨwaaraꞌna kyaꞌ Jizaazai Juyaraavɨ wɨgaimwadei wɨjɨwaakɨyagaala wɨdɨna “Sɨnnawɨ kaimɨraayangɨna wapaaya wɨjaavɨpɨka! Sareꞌ dareꞌnesɨ. Sɨnnawɨ jɨlɨkeraavɨna kaimɨraayangɨre wapaaya namarasɨꞌnɨpɨdɨka!” Saꞌna wɨdakeꞌ sɨnnawɨ Juyaraavɨ wɨgaimwadelyɨra. ");
INSERT INTO byr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Sara wɨdɨna kyaꞌ aꞌmwe saꞌ daka “Juyaꞌnyɨ mɨka. Maaveꞌnyɨra. Jɨlɨka sarabɨsaꞌnyɨ,” daka wɨdɨna “Yo, Naangeigɨ saꞌna kaimɨraayangɨre wapepwaka kabwalaraawojɨ jɨlɨkera yɨꞌbɨnyavɨ dalaangevɨ mwaalapɨjɨ maribwaranɨpɨꞌderera.” ");
INSERT INTO byr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","“Gɨmɨ nyɨdɨwaanyavɨna gɨnnya angebanna wawoꞌgɨzɨ taayavɨ dangadera. Dahaaꞌ yɨmakai taayavɨre munyɨkɨdaaꞌnyɨ mena wɨwaka.” ");
INSERT INTO byr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aꞌmweꞌ wɨꞌnaka gannya angebanna wɨna kyaꞌ taayaꞌ yɨꞌbɨnyavɨ waꞌdɨꞌnyɨ dara wanganakeꞌ “Yɨmaka marawɨnaangɨꞌdei mena davwalyuwaka!” ");
INSERT INTO byr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Anga Taayaa sabadaasai Saaithonɨ angeburɨna yɨꞌmavaawɨna yaka pina lavɨtaꞌna yaka Atɨraalyaba angeburaavɨ gɨꞌmavamaryaka aalɨbunya Galɨlina yɨꞌmaꞌna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yɨꞌmaꞌna kyaꞌ gamɨnyawɨnna aꞌmwe pwara aꞌmwe kadɨkɨryai taalɨꞌmabyarɨ jɨvwaramakabɨna yeva naanga wɨdɨna “Kadɨkɨryare mɨnyagɨnyavɨ ata dɨthathɨwana!” ");
INSERT INTO byr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Sara wɨdɨna kyeꞌ sahwai kadɨkɨryarɨ sangineba makuna kyaꞌ gaveraai mwaaidakɨlyɨ Jizaazai gamɨre kadɨkikaarɨ asɨraai tɨlavalɨmwagaꞌnyɨna yaka asɨrɨ maagwala yɨnyɨna yaka kadɨkɨryare taalɨsarɨ dathakɨna yaka ");
INSERT INTO byr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","sɨgunyayɨna maranganaka sɨmudɨngwaimale yaka wɨdɨna Juyaraavɨre yagaalyavɨ “Epaata!” Yagaala saꞌ “Kadɨka dɨvaaso!” kadɨka tewaanya wɨꞌnyaꞌna dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wɨdɨna kyaꞌ kadɨkɨryare kadɨka tewaanya wɨꞌnyɨna yaka gannya taalɨsalyɨ yagaala tewaanya dɨna sagaaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kadɨkɨryai tewaanya mwaaidɨꞌnyɨ Jizaazai aꞌmwe pwaraavɨ wɨdɨna “Nɨmɨ yɨweꞌna aane pwarɨ kwarɨ yagaala mudɨpɨnera!” wɨdaꞌ yagaala naanga. Dɨragɨnna sara wɨdake saꞌna wɨdɨwɨja yesara dɨragɨnaanga sara yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pwara wɨꞌneva atɨka maruꞌnareva “Sahwai yuyangɨ tewaanya yɨwakelyɨra. Kadɨkɨryara nayaa wɨꞌnyaꞌneraavɨ wɨmwaaihada taalɨꞌmabyara nayaa wɨjaꞌneraavɨ wɨmwaaihadei,” dɨneꞌ. ");
INSERT INTO byr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yɨrɨka sangɨ gamɨnyawɨnna kwala naangeꞌ yɨꞌbwaꞌnyɨna yeva tɨka wapemaayara mwaaidapi Jizaazai gamɨreraavɨna jaka jɨvwaramaaraka wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kwala bwaꞌnaanya dasɨ nɨmɨjɨ yɨrɨka daryaai darɨꞌ mwaaidori yaꞌna dahaaꞌ wapaaya maayaraavɨna kale nyɨwaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kumɨ mɨjɨka wiadaasɨ ‘Sarɨnnya angebanna dɨwila!’ wɨdɨwɨjaꞌ aꞌmwe pwara maave keiba mwaalyarajɨ aꞌmwe pwarajɨ tusavɨ mɨjɨka nabalapɨka!” ");
INSERT INTO byr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wɨdɨna yakevɨ gamɨrera yagaala maꞌmaaꞌna “Dava aꞌmwera mamwaalyadɨvɨsaba aane pwai kwai aꞌmweraavɨne wapaaya gawɨ maarajɨwaꞌ!” ");
INSERT INTO byr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sai yɨdaanganaꞌ “Gɨrɨkula gara gara warɨka?” Sara kyɨdaanganaꞌ “Ati ata purɨdaaꞌnyɨ pwaraaina.” ");
INSERT INTO byr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Sara wɨdɨna kyeꞌ kwala bwaꞌnaanyavɨ wɨdɨna “Yuyangihi, kwaakevɨ dalamwaalyɨla!” Wɨdɨna yaka gɨrɨkula ata purɨdaaꞌnyɨ pwaraalyangɨ maaraka Gotɨyarɨ “Su! Su!” wɨdaka gunyɨna gunyɨna yaka aꞌmwengɨne wapaaya wɨjaayaꞌnera gamɨreraavɨ wɨjaavɨna kyaꞌ sara kwala bwaꞌnaanyavɨna wɨjaavɨna. ");
INSERT INTO byr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Miꞌna wɨjaavɨna yesara jawɨnya pɨrɨꞌna pɨrɨꞌna waꞌdɨsɨya wɨmaarina kyeꞌ Gotɨyarɨ “Su! Gɨmɨre yayaꞌ makimwa,” wɨdaka gamɨreraavɨ wɨdɨna “Jawɨnya dajɨ aꞌmweyuraavɨna yanga dumaarila!” ");
INSERT INTO byr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Aꞌmwe yuya maranyɨna kyeꞌ munya yɨnyɨna kyaꞌ wapaa pɨnɨ nɨganakɨna yeta bwakuna wapaaya pɨnɨ gɨlya ati ata purɨdaaꞌnyɨ pukaalyangɨ maramiheꞌ gamɨrera. ");
INSERT INTO byr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tɨka wapaaya neta kwala naanga naanga (4000) mwaalesare. Mwaalesaraavɨ sai wɨdɨna “Aꞌmweihi, wapaa miꞌna nɨvanɨgasaihi, sarɨnnya angebanna dɨwila!” ");
INSERT INTO byr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Sara wɨdɨna yaka yɨmeꞌnyaꞌbɨꞌ wɨdaasɨna, gamɨrerari sɨpɨyavɨ wɨlamwaaina kyaꞌ Kwaaka Dalɨmaanutaneraavɨ makuna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Saba Perɨzɨya pwara gamɨnyawɨnna wɨlaabɨna yeva “Gamɨ sarɨ kayaaꞌnanyaꞌna yaamɨjɨ wɨdaana!” yawɨreva “Yɨdakwasanganaana!” deva wɨdɨna “Gotɨyare dɨragɨnyaꞌ maaraꞌgɨzɨ wɨjɨwaainya dɨragɨnyaꞌ ja! Wanganaadeꞌna Gotɨyareigɨ dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sara wɨdɨna kyeꞌ gamɨre sɨmunyavɨ kale wiadaaꞌnyɨ sɨmudɨngwaimale yaka wɨdɨna “Dahaaꞌ mwaaihasara ‘Wɨjɨwaainya dɨragɨnyaꞌ ja!’ baaꞌna nyɨdɨwaava! Nebwi yɨhɨthɨvanɨge. Wɨjɨwaainya dɨragɨnyaꞌ mwanganyɨ jideihɨlyɨra dahaasaihi. Arɨkawɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sara wɨdɨna yakei kumɨ saraavɨ yarai yagalyaꞌmavaka sɨpɨyavɨ wɨlamwaaina kyaꞌ aalɨbunyavɨ pimagɨnna makuna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Gamɨrera wapaayanna navɨka yɨna kyeꞌ kumɨjɨ sɨpɨyavɨ gɨrɨkula gave pɨrɨꞌna waraꞌ. ");
INSERT INTO byr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Gɨrɨkula gave pɨrɨꞌna waꞌdɨꞌnyɨyagaaꞌ gamɨ “Dɨnyuꞌnyɨla! Mala nayaa jɨwannyɨla! Perɨzɨyaraavɨre lɨwɨnya pamidakyaꞌnesɨ Erotɨyare lɨwɨnya pamidakyaꞌnesɨ nayaa jawɨrila!” ");
INSERT INTO byr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wɨdɨna kyaꞌ gamɨrera dɨnyɨna “Wapaaya mamaariwoꞌna nedɨwaka.” ");
INSERT INTO byr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Dɨnyɨna yesaꞌna Jizaazai yawɨraka wɨdɨna “ ‘Nemɨ wapemaayainereꞌ,’ baaꞌna dɨmanɨgaꞌ! Kunyaꞌ myawɨrijɨvanɨgaꞌ! Sɨduꞌmaayaihi daa! ");
INSERT INTO byr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tɨnnakeihi, tɨnna mwanganyɨjɨvanɨgaꞌ! Kadɨꞌnakeihi, kadɨka muꞌnyɨjɨvanɨgaꞌ! Nɨmɨ sɨnnawɨ yeꞌna nayaa myawɨrijɨvanɨgaꞌ! ");
INSERT INTO byr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Sagaaꞌ gɨrɨkula atina gunyɨna kye paaivɨ taawɨzanɨyara miꞌna kaneꞌ wapaa bwakuna yake sarɨmɨ gɨlya gara garengɨ maramiheꞌ?” Sara wɨdɨna kyaꞌ wɨdɨna yeꞌ “Atɨraai sɨvɨlyɨrɨdaaꞌnyɨ pukaalyangɨ maramiho.” ");
INSERT INTO byr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wɨdɨna kyeꞌ wɨdɨna “Gɨrɨkula ati ata purɨdaaꞌnyɨ pwaraalyangɨ po taawɨzanɨyara kanɨwaꞌdaaꞌ wapaaya pɨnɨnna yunebanne gɨlya gara gara maramihɨwaꞌdaaꞌ?” Sara wɨdɨna kyaꞌ wɨdɨna “Ati ata purɨdaaꞌnyɨ pukaalyangɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wɨdɨna yesaraavɨ wɨdɨna yaꞌ “Saꞌna dahaaꞌ kunya kuna myawɨrijɨvanɨgaꞌ?” ");
INSERT INTO byr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kumɨ Anga Betɨzaaithana kyɨꞌmaveꞌ gamɨnyawɨnna aꞌmwe pwara aꞌmwe tɨbɨnyarɨ jɨvwaramakuna yeva naanga wɨdɨna “Aꞌmwe darɨ ata dɨthathɨwadeꞌnanyɨ!” ");
INSERT INTO byr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sara wɨdɨna kyeꞌ Jizaazai tɨbɨnyare asavɨ maaraka angebadaasɨ jɨvwaramakuna yaka gamɨre tɨnnyaraarɨ maagwala wopɨna yaka gamɨre tɨnnyaraarɨ ata dathɨwagaka yɨdaanganna “Pɨrɨꞌ kɨrɨꞌ dangamwaana?” ");
INSERT INTO byr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yɨdaanganna kyaꞌ maranganamaryaka wɨdɨna “Aꞌmweraavɨ dahawangamanɨge? Yɨsara kaanya yamaryɨvanɨkabaaibɨꞌ sahwaraavɨ wanganaasɨwana.” ");
INSERT INTO byr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sagaaꞌ wɨdakere tɨnnyaraarɨ ata ayɨna dathɨwanna kyaꞌ aꞌmwei dɨragɨnna kwanganaꞌ gamɨre tɨnna tewaanya kyɨmaꞌnaꞌ yuyangɨ tɨnna nayaa wanganaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nayaa wangadaaꞌnyɨ sai wɨdaasɨna yaꞌ “Gɨnnya angevɨna dɨwona! Anga dava ayɨna mulaawɨnnera!” ");
INSERT INTO byr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jizaazalyɨ gamɨrerari sara Sizaarɨya Pilipaai angeburaavɨna gɨꞌmavamarina yadaapi gamɨreraavɨ wɨdɨna “Nɨmɨnyɨna aꞌmwera aaihwala nyɨdɨvanɨgava?” ");
INSERT INTO byr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Gamɨrera wɨdɨna “Gɨmɨnyɨna ‘Jonɨ aalyavɨ bavɨtaazɨya yakei dɨkaavakela,’ pwara dɨmanɨgaꞌ. ‘Ne Yɨlaajai dɨkaavakela,’ pwara dɨmanɨgaꞌ. ‘Gotɨyarɨ wɨꞌnawɨjɨwakyaaka pwai dɨkaavakela,’ pwara dɨmanɨgaꞌ.” ");
INSERT INTO byr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sara wɨdɨna kyeꞌ yɨwaaraꞌna “Sahwaihi, nɨmɨnyɨna baarɨva dɨmanɨgataihɨlaka?” “Kɨraazɨtɨyaigɨnyɨra. Gotɨyai gɨthasaabakeigɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pitai sara wɨdɨna kyaꞌ sai “Naangeꞌ yɨhɨthɨwa. Saꞌna nɨmɨnyɨna aane pwarɨ kɨrɨvɨ mudɨpɨnera!” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sai gamɨreraavɨ gaai wɨjɨwaakɨna “Aꞌmweraavɨne Kaimɨraayainyɨ daanga naanga nyɨvɨnadeinyɨra. Juyaraavɨre aꞌmwe naangerajɨ sipɨzipɨya Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ Kɨwɨjarajɨ sara nɨmɨnyɨna ‘Aꞌmwe kayaaꞌnanaangelyɨra,’ dɨnapɨri nyɨramakɨpɨꞌdeinyɨra. Kanyɨramakapi yɨrɨka daryaai darɨꞌ kanyavɨlavojɨ baryainyɨ ayɨna dɨkaavɨdeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yagaala saꞌ kuꞌmaayaba aangyagaala wɨdɨna kyaꞌ Pitai sahwarɨ sangyɨnebanna jɨvwaramakwoka maanga wɨdɨna “Naangeigɨ, sabwi myawɨꞌdɨnna!” ");
INSERT INTO byr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sara maanga wɨdɨna kyaꞌ gɨnyɨmaꞌnaka gamɨreraavɨ tɨnna wanganaka Pitarɨ maanga wɨdɨna “Saataanɨgɨ, nɨmɨnyɨ dusɨmagɨnna dɨwona! Gotɨyai sara yawɨꞌmanɨkebura myawɨrivanɨgɨ. Aawa. Aꞌmwera sara yawɨꞌmanɨgasabura yawɨꞌmanɨgɨnyaꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Aꞌmwe kwala bwaꞌnaanyavɨjɨ gamɨreraavɨjɨ jaka wɨjɨvwaramaaꞌna kyaꞌ gamɨnyawɨnna bɨna kyeꞌ wɨdɨna “Aꞌmwe kɨrɨꞌ aꞌmwe kwai ‘Jizaazareinyɨ. Mɨdɨnɨma!’ yawɨrajaꞌ ‘Nɨmɨnyɨneꞌna myawɨꞌmunera!’ datheꞌna pwara ‘Aꞌmwerɨ yɨta yovihɨrarannɨkevɨri tamakaana!’ kadapɨri sai ‘Jizaazarɨna balɨdeinyɨra,’ dozɨ nɨmɨrebwi yawɨꞌdei nyɨmɨdɨnadelyɨra. ");
INSERT INTO byr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sareꞌ dareꞌnesɨ. Yɨ aꞌmwe pwai lɨka yojɨ ‘Nanyɨramakɨpɨka! Nɨmɨre gaalyaꞌ padaihasamaaꞌnɨma! Jizaazarɨ wasɨꞌnɨdeinyɨra,’ dozɨ navɨka mwaalajai gamɨre kuryai kayaaka yadelyɨra. Kɨrɨꞌ pwai ‘Jizaazarɨna nyɨramakɨpɨꞌdeinyɨra. Nɨmɨre gaalyaꞌ kayaaka yana!’ yawɨꞌda nɨmɨre yagaala tewaanyaꞌna yawɨrajaꞌ yuyagaaꞌ gamɨre kuryai nayaa padaihasamaaꞌdelyɨra. ");
INSERT INTO byr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sareꞌ dareꞌnesɨ. Aꞌmwe pwai Kwaaka davakɨ gɨlyɨvɨsajɨ yuyajɨ sangɨ maarojɨ manyɨlɨmwagari kyojɨ gamɨre kuryai yɨwɨna yadelyɨ. Saꞌ tewaanyaꞌ daaka! Arɨkewɨnyɨra! ");
INSERT INTO byr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sareꞌ dareꞌnesɨ. Aꞌmwere kuryai kayaaka yɨmaꞌnyɨna kyojɨ gannya kuryarɨna aꞌmwe sai Gotɨyarɨ berɨsɨ mubathelaka! Aawa. ");
INSERT INTO byr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Sareꞌ dareꞌnesɨ. Kwaaka davakɨ mwaaidɨvɨsara Gotɨyarɨna navɨka yadɨvɨꞌ aꞌmweꞌ aꞌmwe pwarɨ ata lɨmwanna yadeꞌbɨsarera. Kayaaꞌnanaangera nɨmɨnyɨnajɨ nɨmɨre yagaalyaꞌnajɨ sangɨna ‘Wagɨla nanevwaꞌnadɨka! Sahwarɨ wasɨꞌnɨma!’ deva yɨvanɨgasara. Nabaai dɨvi Aꞌmweraavɨne Kaimɨraayai Ganɨmaangere byaanna dɨragɨnyaꞌ kamaarojɨ Gotɨyare mamaayara ejelɨya tewaanyarajɨ kwalaabori wagɨla wɨvwaꞌnɨvanɨkeraavɨna gamɨ sarɨ wagɨla wɨvwaꞌnadelyɨra. Saraavɨ wasɨꞌnadelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sai aꞌmweraavɨ wɨdɨna “Nebwi yɨhɨthɨwa. Dava mwaaihasarajɨya pwara dɨvi kwaihwaainakera kuna mwaalapɨjɨ mabalyɨ yapɨjɨ dara wangabɨꞌdeꞌ ‘Ai, Gotɨyai dɨragɨnna damaremwaalɨka!’ Sara wangabɨꞌdehaaꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yɨrɨka daryaai daryaai daryaai kwavɨlavaꞌ Jizaazai Pitalyɨ Jemɨzalyɨ Jonɨjɨ saraavɨ maarɨna kyaꞌ mugunya naangevɨ yɨlaawɨna yɨlaawɨna yeva gavera daavɨna kyeꞌ pwara mamwaalyɨ kyeꞌ gamɨre kɨlaakejɨꞌ nawɨꞌnyajɨꞌ gavinyajɨꞌ kyalɨngɨnaꞌ kumɨ tɨnna wanganna. ");
INSERT INTO byr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tɨnna wanganna yadaapɨjɨ gannya kwaabɨhannya yaaka naangeꞌ yɨmaꞌnakevɨ Kwaakevakɨ mwaaidɨvɨsara yaaka saꞌ sara myalɨngɨnyadesɨra. ");
INSERT INTO byr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yaaka naangeꞌ kyɨmaꞌnaꞌ Ne sɨnnawɨnyaraai Yɨlaajalyɨ Mozɨzalyɨ saraai Gotɨyarebadaasaraai yɨmaꞌnaabɨna, daavɨna yagɨla Jizaazarɨ wɨdɨna kyagi dɨnyɨna. ");
INSERT INTO byr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Sara dɨnyɨna kyeꞌ gamɨrera tɨnna wanganna yeva Pitai Jizaazarɨ yaasɨwaꞌ wɨdɨna “Nejɨwaakadɨnyaigɨ, nemɨ dava mwaaihoꞌ tewaanyasɨra. Sɨmɨnya dawaai dasangɨ yarɨlaana! Pɨrɨꞌ gɨmɨnyɨneꞌ, pɨrɨꞌ Mozɨzarɨneꞌ, pɨrɨꞌ Yɨlaajarɨneꞌ yarɨlaana!” ");
INSERT INTO byr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Sareꞌ dareꞌnesɨ. Pitai “Nɨmɨ gara dɨjɨwa?” dɨna yakelyɨ. Nabaai sareꞌ dareꞌnesɨ. Sahwalyɨ gamɨreraalyɨ sara lɨka naanga yesaꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Sagaaꞌ yɨraayaꞌ kumɨnyɨ gɨꞌdala yɨrɨna kyaꞌ yɨraayavɨdaasɨ maanguraayaꞌ “Dathai nyɨbwaalɨvaangelyɨ. Yɨlaaya yadɨ kurya wɨkadɨnyalyɨra. Dahwarɨ nayaa duꞌnyɨla!” ");
INSERT INTO byr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yagaala saꞌ wɨꞌneva yɨmeꞌnyaꞌbɨꞌ dara wanganesaꞌ “Ai, aane pwai kwarɨ tɨnna mwanganyɨ, Jizaazai gavei nemɨjɨ damwaalɨka!” ");
INSERT INTO byr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sɨlyarɨdaaꞌnyɨ gamɨrerari waidavadaapi sai naanga wɨdɨna “Wangamwaasaꞌna aꞌmweraavɨ mudɨpɨnera! Dɨvi Aꞌmweraavɨne Kaimɨraayainyɨ balaꞌmuri bainɨkeraayawɨdaaꞌnyɨ dɨkaaꞌmujahaaꞌna yɨ sagaaꞌ duzideihɨlyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sara wɨdɨna kyaꞌ kumɨ sara aꞌmweraavɨ yagaala saꞌ mujɨwaaki. Mujɨwaakyaꞌnera dɨnyɨna “ ‘Balaꞌmuri bainɨkeraayawɨdaaꞌnyɨ ayɨna dɨkaavɨdeinyɨra,’ nedɨwakeꞌna be yagaalavaka?” ");
INSERT INTO byr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sara dɨnyɨna yeva gamɨnyɨ yɨwaaraꞌna “Yagaaikɨwɨjara nedɨvanɨgaꞌ ‘Sɨnnawɨ Ne Yɨlaajai kabozɨ dɨvi Kɨraazɨtɨyai bathelyɨra.’ Savɨneꞌna baaꞌna nedɨvanɨgaꞌ?” ");
INSERT INTO byr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sara wɨꞌnaka wɨdɨna “Yo, dɨnɨkeꞌ sɨnnawɨ Yɨlaajai bozɨ yuyangɨ yavadaꞌgaladelyɨra. Nabaai Aꞌmweraavɨne Kaimɨraayainyɨna dɨnɨkeꞌ ‘Yɨ Kwaaka davakɨ daanga naanga wɨvɨnadelyɨra. Yɨ yɨlaaya mamari yɨpɨꞌdelyɨra.’ Sareꞌ gara yɨdaꞌnɨkevaka? ");
INSERT INTO byr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kɨrɨꞌ nɨmɨ sainyɨ yɨhɨthɨvanɨge. Yɨlaajai miꞌna bakelyɨra. Miꞌna bakerɨ kayaaꞌnanaangenna wiesaꞌ Gotɨyare bukuyaꞌ sara dɨnɨkabaaibɨsaꞌnesɨra.” ");
INSERT INTO byr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Gamɨre pwaraavɨ wɨjɨmaꞌnaaweva dara wanganesaꞌ “Kwala bwaꞌnaanya naangeꞌ kumɨnyaba mwaaidapi Yagaaikɨwɨjarajɨ nemɨrerajɨ maanga dathɨmanɨgava!” ");
INSERT INTO byr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Dɨna kyeꞌ yɨmeꞌnyaꞌbɨꞌ bwaꞌnaanya yuyaꞌ gamɨnyɨ tɨnna wanganesagaaꞌ atɨka maruꞌnareva gamɨnyawɨnna kaanyaveꞌna beva “Naangeigɨ,” wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sara wɨdɨna kyeꞌ sai yɨwaaraꞌna “Maanga beꞌna dɨmanɨgataihɨlaka?” ");
INSERT INTO byr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yɨwaaraꞌna kyaꞌ bwaꞌnaanyavɨdaaꞌnya pwai wɨdɨna “Nejɨwaakadɨnyaigɨ nyɨbwaalɨvaangei yɨmaka widei yagaala majarɨ gɨmɨnyawɨnna makabɨwa. ");
INSERT INTO byr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yɨmakei galalɨmwanna yada kaimalerɨ kwaakevɨna bwalamarakɨna yadehaaꞌ gamɨre maangevɨ maagwaitala yɨmaꞌnada maangerɨka maagɨlakuꞌgɨlakuta yadaasɨ gamɨre kɨlaaka yuneba dɨragɨnya yɨmaꞌnade sagaaꞌ. ‘Yɨmakei duthaasɨla!’ dena gɨmɨreraavɨ kudɨwa sahwara yɨna yɨna kyɨwaaꞌ yɨmakei kuna widelyɨra. Myɨ yɨpɨnere.” ");
INSERT INTO byr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sara wɨdɨna kyaꞌ sai maꞌmaaꞌna “Dahaasaihi, malɨmwagyadɨvɨsaihi sarɨmɨnyaba mwaalaꞌmujɨ yɨhɨzɨwaakaꞌmujɨ sarɨmɨnyɨneꞌna taanga kuna gathɨngaaꞌ maarɨdeinyaka! Kaimale dai nɨmɨnyawɨnna dɨmakabyɨla!” ");
INSERT INTO byr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Miꞌna wɨdɨna kyaꞌ makabɨna kyeꞌ yɨmakei Jizaazarɨ wanganaka yɨmeꞌnyaꞌbɨꞌ kaimalerɨ yɨkɨlaaka galyɨmaꞌna kyaꞌ kwaakewɨ bwalaꞌna yaka gɨnyɨwannyɨ gɨnyɨwannya yɨna kyaꞌ gamɨre maangevɨ maagwaitala yɨmaꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sara yɨmaꞌnyɨna kyaꞌ sai ganɨmaangerɨ yɨwaaraꞌna “Saꞌ garegaaꞌ yɨmaꞌnakavaka?” Yɨwaaraꞌna kyaꞌ ganɨmaangei wɨdɨna “Kaimale maalɨkegaaꞌ sara yɨmaꞌnaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kyɨmaꞌnaꞌ yɨmakei kwalaalyagaaꞌ kaimalerɨna ‘Tamakɨma!’ daka dɨkevɨ marasɨꞌna yada avaala kwai aalyavɨ marapaihɨna yadei. Sareꞌ kɨrɨꞌ ‘Nɨmɨre dɨragɨnyaꞌ darɨka!’ dɨzaꞌ naarɨmɨnyɨna kale kagyozɨ nehɨgaimwana!” ");
INSERT INTO byr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sara wɨdɨna kyaꞌ Jizaazai wɨdɨna “ ‘Nɨmɨre dɨragɨnyaꞌ darɨka!’ dɨzaꞌ pwai nayaa nyɨmɨdɨmanɨkei sahwai yuya yannelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dɨragɨnna sara kudaꞌ yɨmeꞌnyaꞌbɨꞌ ganɨmaangai yarai wɨdɨna “Gɨmɨdɨmanɨgevwi maalɨka warɨkeꞌna naanga yɨmaꞌnyaꞌneꞌ dɨnyɨgaimwana!” ");
INSERT INTO byr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jizaazai dara wanganakeꞌ “O, kwala bwaꞌnaanyaꞌ kaanyaveꞌna jɨkabɨvanɨgava!” Daka yɨmakerɨ maanga wɨdɨna “Yɨmakeigɨ kadɨkɨryaigɨ yagaala majaigɨ kaimalerɨ beꞌna wɨmwaaihɨna! Gamɨre munyɨkɨdaasɨ yunakaanna dɨwona! Ayɨna nabwidɨka!” ");
INSERT INTO byr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sara wɨdɨna kyaꞌ yɨmakei jaka dɨna yaka kaimalerɨ naanga galyɨmaꞌna yaka bwalyuna. Sara bwalyuna kyaꞌ kaimalei baryaibɨꞌ warɨna kyaꞌ pwara dɨnyɨna “Mena baimwaka.” ");
INSERT INTO byr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sara dɨnyɨna kyeꞌ Jizaazai gamɨre asavɨ yɨrɨꞌbwaꞌna kyaꞌ kaimalei sagaaꞌ tewaanya dɨkaaꞌna yaka daavɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Angevɨ miꞌna wɨlamwaaina kyaꞌ gamɨjɨ gamɨrerari gavera mwaaidapi gamɨrera yɨdaanganna “Sahwaina yɨmakerɨ wɨdasaanneꞌ gara yawaajɨ wɨdasaannekajɨnyɨra?” ");
INSERT INTO byr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yɨdaanganna kyeꞌ sai wɨdɨna “Yɨmaka darɨna Gotɨyarɨ tɨbarɨyagaala kadapɨri bwalyawodelyɨra. Aane pɨrɨꞌ kɨrɨꞌna mɨka!” ");
INSERT INTO byr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Sabadaaꞌnyara Kwaaka Galɨli wavɨlaꞌna. Wavɨlaꞌna yadaapi “Aꞌmwera nanyangabɨthɨka!” daka sai kave wɨna. ");
INSERT INTO byr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Sareꞌ dareꞌnanyɨ. “Nɨmɨreraavɨ wɨjɨwaakɨma!” daka wɨdɨna “Aꞌmweraavɨne Kaimɨraayainyɨ pwai nɨmɨnyɨ yɨkamaangeraavɨna kwibwarɨdaakwojɨ yɨkamaangera kanyɨramakapɨri balɨdeinyɨra. Miꞌna balaꞌmujɨ yɨrɨka daryaai darɨkɨ ayɨna dɨkaavɨdeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sara wɨdɨna kyaꞌ yagaala saꞌna myawɨryadɨvɨꞌ nabaai, yɨdaanganyaꞌna lɨka yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Angaba Kaapanɨyamɨna yɨꞌmaveva angevɨ ayɨna kabulamwaaleꞌ sai gamɨreraavɨ yɨwaaraꞌna “Tusavɨ wɨvanɨgasaihi be yagaala dɨmanɨgatavaka?” ");
INSERT INTO byr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wɨdɨna kyaꞌ sahwara yagaala majara mwaalɨna. Sareꞌ dareꞌnesɨ. Tusavɨ dɨnyɨna “Nemɨjɨyai aꞌmwe naangei aaihwalaka? Nɨmɨ dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Majara mwaalɨna kyeꞌ walamwaalaka gamɨre atɨraai sɨvɨlyɨrɨdaaꞌnyɨ pwaraalyaraavɨ jɨvwaramaaꞌna yaka wɨdɨna “Pwai gannya sɨmunyavɨ ‘Sɨnnawɨnyainyɨ yɨmaꞌnɨma!’ yawɨrajai sai yuyaraavɨne aayaangei yɨmaꞌnana! Yuya saraavɨna wɨdaayadei yɨmaꞌnana! Sai yawɨꞌna ‘Nɨmɨ maalɨkeinyɨra. Yuyaraavɨre wɨdaayɨdeinyɨ yɨmaꞌnɨma!’ dozɨya sahwai naangei yɨmaꞌnadelyɨra Gotɨyarɨna.” ");
INSERT INTO byr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Wɨdɨna yaka kaimɨraayamɨlɨꞌ maaraka tɨnnyaba mwaaidapiyaba gannya tɨꞌmunyavɨ maramujɨꞌna yaka wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Pwai kwai nɨmɨnyɨna yawɨrojɨ kaimɨraaya daibɨsamɨlɨꞌ maarajaꞌ nɨmɨnyɨ nyɨmaaradeinyɨra. Nabaai sai sara nyɨmaarajai nɨmɨnyɨ gaveinyɨ nyɨmaaradeinyɨ mɨꞌ. Aawa. Nɨmaamaangei nyɨdasaabakerɨjɨ maaradelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jonɨ wɨdɨna, “Nejɨwaakadɨnyaigɨ, nemɨ dara wangamwoꞌ ‘Aꞌmwei gɨmɨre yayaꞌ wɨdaka yɨmakeraavɨ aꞌmweraavɨre munyɨkaavɨdaasɨ dathasɨvanaabɨka!’ Sai nemɨjɨyai mɨꞌ. Savɨdaasɨ nemɨ wɨdɨwo ‘Sabwi minnera maaveigɨ!’ ” ");
INSERT INTO byr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Miꞌna wɨdɨna kyaꞌ Jizaazai wɨdɨna “ ‘Sabwi minnera!’ mudɨpɨnera! Sareꞌ dareꞌnesɨ. Aane pwai kwai nɨmɨre yayaꞌ wɨdozɨ dɨragɨnaangeꞌ yojɨ maalɨkegaaꞌ nɨmɨnyɨna kayaaꞌna wɨdathei mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sareꞌ dareꞌnesɨ. Aꞌmwe nemɨre yɨkamaangei mamwaalyɨkei nemɨnyɨnelyɨ. ");
INSERT INTO byr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sareꞌ dareꞌnesɨ. Pwai sarɨmɨnyɨna ‘Kɨraazɨtɨyarerɨ mɨjɨkaꞌna aalya tɨka nyaꞌneꞌ wɨjaavɨma!’ dozɨyaꞌna nɨmɨnyɨna yɨhɨzaavajai. Yɨ sahwarɨna nebwi yɨhɨthɨwa. Gotɨyai gamɨnyɨne tɨvɨkɨta tewaanya mujaayɨ yadei mɨka! Arɨkewɨ.” ");
INSERT INTO byr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Pwai kaimɨraaya damɨlɨꞌbɨsamɨlɨꞌ nɨmɨnyɨ nyɨlɨmwagaꞌdemɨlɨꞌ pwarebwi kujaawaꞌ walaꞌmwaakeꞌ kayaaꞌnanaangesɨra. Aꞌmwei sara yajarɨna Gotɨyarɨ sɨnna tɨka naanga wɨdavadelyɨra. Sɨnnawɨ sahwai pwarebwi mujaayadɨꞌnyɨyagaaꞌ aꞌmwe darɨ maapɨjɨ kwajɨ sɨla naangeꞌ gamɨre tɨlɨnnyavɨ tɨmupɨjɨ kwajɨ aalɨbunyavɨ wɨvaihɨna kyɨpɨkeꞌna wabana yɨnɨkesɨra.” ");
INSERT INTO byr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jizaazai yawɨraka “Kayaaꞌnanya nyɨpɨdɨka! Dɨkevɨ nulaawɨpɨka!” daka keꞌbaꞌna wɨdɨna “Nabaai gɨnnya asasɨ kayaaꞌnanyabwi yɨjɨ kwajɨ gɨnnya asavɨ woripuꞌnaꞌgi ata gavesɨyaigɨ Gotɨyarebanna jɨlaawadeꞌna tewaanyasɨra. ");
INSERT INTO byr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kayaaꞌnanyabwi yɨjɨ kwajɨ asawaalyɨyaigɨ yaayebanna gazagaasagaaꞌ Dɨkeꞌ yɨdaꞌnɨvanɨkevɨna dulaawadeꞌna kayaaꞌnanaangesɨra. ");
INSERT INTO byr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nabaai gɨnnya sɨvɨlyasɨ kayaaꞌnanyabwi yɨjɨ kwajɨ woripuꞌnaꞌgi sɨvɨla gavesɨyaigɨ Gotɨyarebanna dulaawadeꞌna tewaanyasɨra. ");
INSERT INTO byr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kayaaꞌnanyabwi yɨjɨ kwajɨ sɨvɨlyawaalyɨyaigɨ Dɨkevɨna dulaawadeꞌna kayaaꞌnanaangesɨra. ");
INSERT INTO byr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nabaai gɨnnya tɨnnyalyɨ kayaaꞌnanyabwi yɨjɨ kwajɨ gɨnnya tɨnnyai galajɨwaꞌmwannaꞌgɨzɨ tɨnna gavelyɨyaigɨ Gotɨyai maremwaaidevanna dulaawadeꞌna tewaanyasɨra. Kayaaꞌnanyabwi yɨjɨ kwajɨ tɨnnyaraalyɨyaigɨ Dɨkevɨna dulaawadeꞌna kayaaꞌnanaangesɨra. ");
INSERT INTO byr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Dɨka savɨ yuyagaaꞌ gumɨlɨka gɨlaayangɨ tɨka nadɨvɨsa mabalyɨ yɨpɨꞌdengɨra. Dɨka myɨgaakuri yadesɨra. ");
INSERT INTO byr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Sareꞌ dareꞌnesɨ. Aꞌmwera Gotɨyare yagaalyaꞌ wɨꞌnadɨvɨsara tewaanna mwaaibɨꞌdere. Kayaaꞌnanyabwi dɨkeꞌbɨsabwi kyɨmaꞌnojɨ Gotɨyare dɨragɨnyabwi kujaavojɨ dɨragɨnya tewaanna mwaaibɨꞌdere. ");
INSERT INTO byr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Saalyaꞌ nawɨꞌnyasɨra. Saꞌna saalyaꞌ gɨrɨngwɨta yɨmaꞌnojɨ nawɨꞌnya ayɨna gara yadevaka? Aawa. Nawɨꞌnya mimaꞌnyɨ yadesɨra. ‘Nemɨ saala gɨrɨngwɨsaꞌbɨsaina nyɨmaꞌnaadɨka!’ dapɨjɨ nayaa dɨmwaalyidera. Gazaizai gamɨnyɨ pwarɨna kwaamuꞌna mwaalana!” ");
INSERT INTO byr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sabadaasai sai Kwaaka Juthɨya wavɨlavaka Aalya Jothanɨ gaꞌmavaka kwaaka saba kamwaalaꞌ gamɨnyawɨ kwala bwaꞌnaanya mwaaidapi wɨjɨwaakadevaaibɨꞌ aya kɨnɨ nayaa wɨjɨwaakɨna. ");
INSERT INTO byr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sara wɨjɨwaakɨna yadaaꞌnyɨ Perɨzɨya pwara wɨlaabeva “Sahwai kayaaꞌnanyaꞌ yana!” deva yaamɨjɨ yɨwaaraꞌna “Pwai gannya balaangevɨ wasɨꞌnajaꞌ sabwi tewaanna yadevwi daaka? Kayaaꞌna yadevwi daaka?” ");
INSERT INTO byr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sara yɨwaaraꞌna kyeꞌ wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“Savɨneꞌ Ne Mozɨzai sɨrɨnɨmaangeraavɨ yagaala berɨvɨ wɨjaihɨlaka?” Sahwara wɨdɨna “Mozɨzai daꞌ dɨnɨꞌ ‘Aꞌmwe pwai yawɨrojɨ “Nɨnnya aꞌmweꞌ wasɨꞌnɨma!” dozɨ pɨkarɨyɨkwiavɨ yagaala saꞌ yɨdavojɨ gannya balaangeꞌ yunakunyavɨ wasɨꞌnadelyɨra.’ ” ");
INSERT INTO byr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sara wɨdɨna kyeꞌ Jizaazai wɨdɨna “Sarɨmɨre sɨmunyangɨ galarɨlavɨmwaaihɨnyɨna yɨwaata sabwina kɨwɨnya saꞌ Ne Mozɨzai dɨnɨkesɨra. ");
INSERT INTO byr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dɨnɨkeꞌ sɨnnawɨ sagaaꞌ Gotɨyai yuya wakyaakegaaꞌ Gotɨyare yagaala dɨnɨꞌ ‘Gotɨyai kwalyalyɨ gannya balyasɨ yavɨkaryaakeꞌna ");
INSERT INTO byr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","aꞌmwe pwai ganɨmaangelyɨ ganaangesɨ sawaarɨ yagalyaꞌmakuna yojɨ aꞌmweꞌ maarɨna yojɨ ");
INSERT INTO byr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","gamɨre aꞌmwesɨ mwaalɨna yakɨriyagaaꞌ kɨyoi avaalyawaalyɨ. Kɨlaaka gavejɨꞌ yɨmaꞌnikadewaalyɨ.’ Saꞌ dɨnɨkeꞌna aꞌmwe pwalyɨ aꞌmwe pɨrɨsɨ sawaai mɨka. Aawa. Kɨlaaka gavejɨsɨyawaalyɨ. ");
INSERT INTO byr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Sarevɨdaaꞌnyɨ Gotɨyai kɨlaaka gavejɨsɨyawaarɨ wakakeꞌna kwalaangei gannya balaangevɨ mwasɨꞌnannesɨra.” ");
INSERT INTO byr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Salyɨ gamɨrerari angevɨ bulamwaaina kyeꞌ gamɨrera aꞌmwevɨ wasɨꞌnyaꞌna yɨwaaraꞌna. ");
INSERT INTO byr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Savɨneꞌ yɨwaaraꞌna kyeꞌ wɨdɨna “Pwai kwai gannya balaangevɨ wasɨꞌnojɨ aꞌmwe mudɨkevɨ kamaarojɨ Gotɨyai wanganojɨ ‘Gannya balaanga ayavɨna aꞌmwe mudɨkevɨ ata lɨmwamwakelyɨra,’ dathelyɨra Gotɨyai. ");
INSERT INTO byr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nabaai aꞌmweꞌ gannya kwalaangerɨ byenɨdaꞌmakwalyuna yajaꞌ aꞌmwe pwarɨ kamaaꞌnojɨ ‘Gannya kwalaangerɨna aꞌmwe mudɨkerɨ ata lɨmwamwakesɨra,’ dathelyɨra Gotɨyai.” ");
INSERT INTO byr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Aꞌmweyura “Sahwai ata yɨmetavana!” deva gamɨnyawɨnna kunnya kaimɨraayaraavɨ makabɨna kyeꞌ gamɨrera maanga wɨdɨna “Mipɨnera!” ");
INSERT INTO byr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jizaazai dara wanganakeꞌ “Ai, nɨmɨrera maanga duthɨvanɨgava!” Daka sɨnna tɨka kudavaꞌ wɨdɨna “Nɨmɨnyawɨnna kaimɨraaya bɨpɨka! Kumɨnyɨna kaanya maribɨnera! Sareꞌ dareꞌnesɨ. Gotɨyai maremwaaideva pwara kaimɨraaya darabɨsara Gotɨyarɨ lɨmwadɨvɨsara mwaaibɨꞌdengɨra. ");
INSERT INTO byr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nebwi yɨhɨthɨwa. Pwai kwai ‘Gotɨyareba mwaalɨma!’ dazai ‘Kaimɨraayai Gotɨyarɨ yɨlaaya yadeibɨsainyɨ yɨmaꞌnɨwɨjainyɨ,’ majɨ kyori Gotɨyare maremwaaide nawɨꞌnyaba mulaabi yadelyɨra. Arɨkawɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sara wɨdaka kaimɨraaya gannya asawaalyɨ mujɨꞌna yaka ata yɨmetaꞌna yaka “Gotɨyai gɨmɨnyɨ tewaanna gyathelyɨra,” wɨdɨna wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Angebadaasai kwaakaanya wodaaꞌnyɨ aꞌmwei gamɨnyawɨnna kaanyaveꞌna wawaka “Naangelyɨra,” daka kwadaai gɨlaka yɨwaaraꞌna “Nejɨwaakadɨnya tewaanyaigɨ, ‘Gotɨyare yuyagaaꞌ yuyagaaꞌne gaalyabwi maarɨma!’ daꞌmujɨ gara yɨdeinyaka?” ");
INSERT INTO byr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sara wɨdɨna kyaꞌ Jizaazai wɨdɨna “ ‘Tewaanyaigɨ,’ nyɨdɨwaanyaꞌ baaꞌna nyɨdɨwaa? Pwara kayaaꞌnanyara, Gotɨyai gavei tewaanyalyɨra. ");
INSERT INTO byr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yagaaikɨwɨnya dara yawɨꞌmwaa. Aꞌmwe maramakɨnna! Aꞌmwengɨ ata malɨmwadɨnna! Kuka minna! Kwaasɨ yagaala majalɨkurakɨnna! Kwaasɨya yaꞌgɨzɨ pwarengɨ kuka mamaaꞌdɨnna! Gɨmaamaangelyɨ gwaangesɨ gɨzɨkaja sara jɨthengɨra. Kɨrɨmɨre yayaꞌ dɨmakɨla!” ");
INSERT INTO byr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aꞌmwei sare wɨꞌnaka wɨdɨna “Nejɨwaakadɨnyaigɨ, yagaaikɨwɨnya sangɨ kaweꞌnyagaaꞌdaaꞌnyɨ sara mɨdɨdɨnyainyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Wɨdɨna kyaꞌ Jizaazai wanganaka gamɨnyɨna wɨvuꞌnakerɨ wɨdɨna “Gave pɨrɨꞌna gɨhainɨvanɨꞌ. Wawaꞌgɨzɨ gɨnnya gɨlyɨvɨsa yaasaꞌgɨzɨ nɨgwia maaraꞌgɨzɨ gɨlyɨvɨꞌmaayaraavɨ yanga wɨjaavaꞌgɨzɨ Gotɨyareba warade gɨlyɨvɨsajɨyaigɨ nyɨmɨdɨnaadeigɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sara wɨdakeꞌna aꞌmwere kale wiadaaꞌnyɨ “Aala,” dɨna jɨkurya yaka kavena wɨna yaꞌ. Sareꞌ dareꞌnesɨ. Gamɨre gɨlyɨvɨta kwalaalya kɨnɨnnakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Miꞌna wɨna kyaꞌ Jizaazai aꞌmweraavɨ maranganaka gamɨreraavɨ wɨdɨna “Gɨlyɨvɨkɨraya naangejɨyara wawɨnya naanga yɨna yɨna yɨpɨjara kwajɨ Gotɨyai maremwaaideva tewaanyaba kupɨdɨkerera.” ");
INSERT INTO byr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Sara wɨdɨna kyaꞌ gamɨrera atɨka maruꞌnakulɨna. Atɨka maruꞌnakulɨna kyeꞌ Jizaazai ayɨna maꞌmaaꞌna “Kaimɨraayaihi, Gotɨyai maremwaaidevanna wɨlyaꞌna wawɨnya naangesɨra. ");
INSERT INTO byr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Langa lɨlɨtavaloꞌmaꞌnɨkerɨkɨ jɨlɨkyaawarya kaamelɨyai wɨlaawadeꞌna wawɨnya maalɨkesɨ. Gotɨyai maremwaaideva gɨlyɨvɨta naangejɨyai wɨlaawadeꞌna wawɨnya naangesɨra.” ");
INSERT INTO byr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Sara kudaꞌ atɨka maruꞌnaꞌmuluna yeva dɨnyɨna “Gotɨyarebanna aai yɨlaawadevanaka? Aarɨ padaihasamaaradelaka?” ");
INSERT INTO byr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dɨnyɨna kyeꞌ Jizaazai kumɨnyɨ tɨnna wanganaka wɨdɨna “Aꞌmwera yapi mulaawi yɨpɨꞌdera. Aawa. Gotɨya gavei kyojɨ wɨlaawɨpɨꞌderera. Sareꞌ dareꞌnesɨ. Gotɨyai yuyanna yadelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pitai sarɨ gaai wɨdɨna “Yɨthaa, nemɨ yuyangɨ yaꞌmawakona gɨmɨdɨnaabɨho.” ");
INSERT INTO byr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sara wɨdɨna kyaꞌ Jizaazai wɨdɨna “Nebwi yɨhɨthɨwa. Aane pwai kwai nɨmɨnyɨneꞌnajɨ yagaala tewaanyaꞌnajɨ gannya angeꞌ gyaꞌmwera gyaꞌmwe ganaangeꞌ ganɨmaangei gannya kaimɨraaya gannya wawɨnya yaꞌmawakojɨ ");
INSERT INTO byr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kɨrɨꞌ dahaasagaaꞌ anga kwalaalya, gyaꞌmwe kwala naange, ganaanga kwalaalya, kaimɨraaya kwala naanga naanga, wawɨnya naangevaꞌ mamaari yadei midaaka! Kwaaka davakɨ naanga naanga maarade kɨrɨꞌ nɨmɨnyɨneꞌna pwara taanginya wɨjaavɨpɨꞌde dɨvi yɨmaꞌnadehaaꞌ Gotɨyare nawɨꞌnyaba yuyagaaꞌ yuyagaaꞌne gaalyabwi maaradelyɨra. ");
INSERT INTO byr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Saꞌna Kwaaka davakɨ pwarɨna ‘Aꞌmwe sɨnnawɨnyalyɨra,’ dɨmanɨgasarɨna Gotɨyareba ‘O, aayaangemɨlɨkɨra,’ dɨnɨpɨꞌdelyɨra. Yɨ pwarɨna ‘Aꞌmwe aayaangemɨlɨkɨ,’ dɨmanɨgasarɨna Gotɨyareba ‘O, sɨnnawɨnyalyɨra,’ dɨnɨpɨꞌdelyɨra. Yɨ kwalaalyaraavɨna sara dɨnɨpɨꞌderera.” ");
INSERT INTO byr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jeruzaalemɨnera tusavɨ kaanya widawadaapi Jizaazai kaanya wodaaꞌnyɨ pwara “Sabannei lɨka myɨwaka,” deva atɨka maruꞌnakulɨna yeva mɨdɨnna yesara lɨka yɨna. Lɨka yɨna kyeꞌ sai gamɨreraavɨ pɨba wɨmwaaihaka gamɨnyɨna yɨmaꞌnyaꞌneꞌna wɨdɨna ");
INSERT INTO byr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Yɨthaanyi! Jeruzaalemɨneina yimanaawɨgo. Saba Aꞌmweraavɨne Kaimɨraayainyɨ maarapi sipɨzipɨya Gotɨyarɨna yɨraꞌdɨvɨta naangerajɨ yagaaikɨwɨjarajɨ saraavɨ kanyɨmarɨmwaaihori aꞌmwe sara nɨmɨnyɨna ‘Sai baladelyɨra,’ jɨdavapi anga naanga pimagɨnyaraavɨ (Romɨ mwaalyaraavɨ) nyɨmarɨmwaaihɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kanyɨmarɨmwaaihapi bɨrala nyapɨri maagwala nyopwasɨꞌnapɨri lannaka wɨlyabaalyɨ mala nyɨramapɨri nyɨramakɨpɨꞌdeinyɨ. Kabalaꞌmuri yɨrɨka daryaai darɨꞌ kwavɨlavojɨ kwaihwaainakeinyɨ ayɨna dɨkaavɨdeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sagaaꞌ Jemɨzalyɨ Jonɨjɨ kɨdaraai Sevathiyare gawaalɨꞌ kwaraai saryawɨnna wɨlaabahɨla wɨdɨna “Nejɨwaakadɨnyaigɨ, gɨthakadeꞌ naarɨmɨnyɨneꞌna sara jɨtheinaalyɨra. Sara yawɨꞌmwoi.” ");
INSERT INTO byr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Miꞌna wɨdɨna kyagi wɨdɨna “Kɨrɨmɨnyɨna baarɨꞌ yɨjɨwa?” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“Naarɨmɨnyɨna tewaanyaba maremwaalaꞌgɨzɨ gɨmɨre byaannakevɨ ‘Pwaigɨ aangasavɨ pwaigɨ kwanaamevɨ namwaalyɨta nawɨꞌnyawaarɨ kwalamwaalakɨlyɨ nemɨ maremwalaadeinera,’ sara nehɨthana!” ");
INSERT INTO byr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Saꞌ wɨdɨna kyagi Jizaazai wɨdɨna “Nyɨdaangamanɨgɨlyaꞌ myawɨriwaai. Daanga nyɨvɨnadeꞌna kaapɨya saꞌ dɨnyideraaihi daaka? Nabaai daanga kihɨvɨnojɨ dɨragɨnyaraaihi daaꞌ? Nɨmɨre kɨlaaka yuyajɨkɨ daanga nyɨvɨnadeꞌna nɨmɨre bavɨtaazɨyaꞌ nyɨmaꞌnadesɨreva nabaai kɨrɨmɨre kɨlaaka yuyajɨkɨ daanga kihɨvɨnojɨ kɨrɨmɨ dɨragɨnna dɨmwaalyideraaihi daaka?” ");
INSERT INTO byr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sara wɨdɨna kyaꞌ wɨdɨna “Naarɨmɨ dɨragɨnyainaai wikɨra. Wiꞌna yakaneinaalyɨ.” Jizaazai wɨdaꞌ “Kaapɨyavɨ aalya nɨdeꞌ savɨ aalya dɨnyideraaihɨlyɨ. Nɨmɨnyɨ bavɨtaazɨyaꞌ nyaꞌdeꞌ kɨrɨmɨnyɨ yɨhwaradesɨ. ");
INSERT INTO byr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Sare kɨrɨꞌ nɨmɨre aangasavɨjɨ nɨmɨre kwanaamevɨjɨ walamwaalyaꞌna nɨnnya wawɨnyaꞌ daaka! Aawa. Gotɨyai yawɨrojɨ gamɨ sahwai namwaalyɨta nawɨꞌnyawaai yovɨrawakyaakewaarɨna pwaraarɨ wɨmwaaihadelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Gamɨrera pwara atɨraalyara sadaraai wɨdahɨlyaꞌ wɨꞌnyɨna kyeꞌ Jemɨzalyɨ Jonɨjɨ sadaraarɨna sɨnna tɨka wɨdavɨna. ");
INSERT INTO byr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sɨnna tɨka wɨdaꞌdaaꞌnyɨ Jizaazai wɨjɨvwaramaaꞌna “Yuyaihi, kaajɨla!” wɨdɨna “Ajɨmya yuyangɨyaraavɨrebwi yawɨꞌmwaaꞌ. Ajɨmya yuyangɨyaraavɨ maremwaaidɨvɨsara ‘Nemɨ aꞌmwe naangeinera,’ dɨdɨvɨꞌ aꞌmweraavɨ marulawakɨna yadɨvɨꞌ mwaaihaꞌ. Nabaai kumɨre aꞌmwe naangera kumɨnyɨ dɨragɨnna yadɨvɨsarera. ");
INSERT INTO byr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sabwi mipɨnera! Sarɨmɨjɨyai pwai ‘Nɨmɨ aꞌmwe naangeinyɨ yɨmaꞌnɨma!’ yawɨrojɨ pwaraavɨ wɨdaayojɨ aꞌmwe naangei yɨmaꞌnadelyɨra. ");
INSERT INTO byr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pwai kwai ‘Pwaraavɨne sɨnnawɨnyainyɨ yɨmaꞌnɨma!’ yawɨrojɨ pwaraavɨre yaasɨwaꞌwawɨnyai yɨmaꞌnojɨ sɨnnawɨnyai yɨmaꞌnadelyɨra. ");
INSERT INTO byr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sareꞌ dareꞌnesɨ. Sahwainyɨ Aꞌmweraavɨne Kaimɨraayainyɨ pwara nyɨdaayɨpɨꞌdeꞌna mabyɨwa. Aawa. Pwaraavɨre wɨdaayɨdeꞌna bɨweinyɨ. Aꞌmweraavɨre kayaaꞌnanyabwina mubyaꞌna kabalaꞌmujɨ aꞌmwera tewaanna mwaaibɨꞌdeꞌna bɨweinyɨ. Kwalaalyaraavɨna aꞌmwamɨnɨgwiainyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Anga Jeriko yɨꞌmavaaweva sahwalyɨ gamɨrerari kwala bwaꞌnaanyasɨ sara Jeriko yaꞌmaꞌdaapi Baatɨmayaazai, Tɨmayaazare gawaalɨꞌ, tɨbɨnyai aꞌmweraavɨ “Nɨgwia nyɨjaama! Tɨbɨnyainyɨ,” dadei tuꞌmaangebaarɨ mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mwaalɨna yaka dara wɨꞌnakeꞌ “Jizaazai Naazaretɨ mwaalyai daaka!” Daka jaka wɨdɨna “Ne Devitɨmɨreigɨ, Jizaazai, nɨmɨnyɨ kale dɨnyɨgaimwana!” ");
INSERT INTO byr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sara jaka wɨdɨna kyaꞌ pwara maanga wɨdɨna “Madɨnna! Kave dɨmwaala!” Maanga wɨdɨna kyeꞌ kɨrɨꞌ jaka naanga naanga wɨdɨna “Ne Devitɨmɨreigɨ, nɨmɨnyɨ kale dɨnyɨgaimwana!” ");
INSERT INTO byr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jizaazai sara wɨꞌnaka mudaraka pwaraavɨ wɨdɨna “Nɨmɨnyawɨnna duzɨvwaramaarila!” Miꞌna wɨdɨna kyaꞌ sahwara tɨbɨnyarɨ jaka jɨvwaramaaꞌna, wɨdɨna “Wikɨra. Jɨvaimwanna! Gɨzɨvwaramaaꞌmwakeꞌ yarai dɨthɨkaaka!” ");
INSERT INTO byr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wɨdɨna kyeꞌ gannya yɨvɨta tapalasɨꞌnaka yarai dɨkwosɨꞌnadaavaka Jizaazaryawɨnna wɨlaabɨna. ");
INSERT INTO byr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Wɨlaabɨna kyaꞌ Jizaazai wɨdɨna “Gɨmɨnyɨna berɨꞌ yɨjɨwa? Gara yawɨꞌmwaa?” Tɨbɨnyai wɨdɨna “Naangeigɨ (Ravuni), ‘Nɨmɨ tɨnna wanganɨma!’ dena gɨthɨwa.” ");
INSERT INTO byr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sara wɨdɨna kyaꞌ Jizaazai wɨdɨna “Nɨmɨnyɨ nyɨlɨmwamwaanyaꞌna gɨmɨre tɨnnyaraai tewaanya yana! Kaanya dɨwona!” Sara wɨdɨna kyaꞌ gamɨre tɨnnyaraai tewaanya kyɨmaꞌnaꞌ tusavɨ Jizaazai kwawaꞌ aꞌmwei mɨdɨnna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jeruzaalemɨ adaihɨsaba Anga Bepaaza Anga Betaani mannɨkeba Mugunya Wolivɨ yɨꞌmaꞌna kyeꞌ gamɨre pwaraarɨ wɨdaasɨna ");
INSERT INTO byr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Angeba sakyɨrɨꞌ sakyaba wɨlaawakɨlyɨ yɨmeꞌnyaꞌbɨꞌ dogiya naanga saadɨwɨnyai wɨla pwekɨnɨkerɨ wanganakɨlyɨ dogiyarɨ aꞌmwe aane pwai kwai milamwaalyarɨ wɨla yaarakɨlyɨ nɨmɨnyawɨnna dɨmakabyɨla! ");
INSERT INTO byr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aꞌmwe pwai kwai ‘Sabwi baaꞌna yɨvanɨgi?’ yɨhɨthazaꞌ dara duzɨla! ‘Naangei sarɨna kugainɨvanɨkɨra. Nabaai miꞌna kyojɨ sagaaꞌ yɨmeꞌnyaꞌbɨꞌ dogiyarɨ ayɨna maryasaabathelyɨ.’ ” ");
INSERT INTO byr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Miꞌna wɨdaasɨna kyaꞌ saraai kaanya wawagɨla adusavɨ dogiya naanga saanyai tɨkuryaba mwasawɨ wɨla pwekɨnɨkerɨ wanganagɨla wɨla yaarɨna. ");
INSERT INTO byr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Wɨla yaarɨna kyagi saba pwara daavɨna yeva wɨdɨna “Baarɨꞌ yɨvanɨgi? Dɨwɨnya sarɨ baaꞌna yaaꞌmanɨgi?” ");
INSERT INTO byr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sara wɨdɨna kyeꞌ saraai Jizaazai wɨdakeꞌ kudahi “Wikɨra. Dɨmakwila!” ");
INSERT INTO byr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sara wɨdɨna kyeꞌ Jizaazaryawɨnna dogiya saanyarɨ makabɨna kyagi yɨvɨta mararaapaleva dogiyarɨ yɨlakɨna kyeꞌ sahwai yɨvɨsɨkaavɨ aꞌba yɨlamwaaina. ");
INSERT INTO byr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sara yɨlamwaaina kyaꞌ aꞌmwe kwalaalyara “Sahwai naangerɨ yɨlaaya yaana!” dɨnyɨna yeva kunnya yɨvɨsa tusavɨ marakɨna kyeꞌ pwara “Tɨnna tewaanya wanganyaꞌnengɨ,” deva taanya kɨwaꞌnake pedaꞌna yeva tusavɨ nayaa marakɨna. ");
INSERT INTO byr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nayaa marakɨna kyeꞌ sai yɨlamwaaidɨꞌnyɨ sɨnnawɨnyarajɨ dɨviyarajɨ sara yɨlaaya yeva jaka wɨdanganna “Naangeigɨ, Gotɨyai padaihasamaarana! Gotɨyai Naangei gɨthasaabakeꞌna gamɨnyɨne yayavɨ bɨwaanyaigɨnyɨ tewaanna gɨzaavana! ");
INSERT INTO byr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Sɨnnawɨ Ne Devitɨ tewaanya nemaremwalyaakabaaibɨꞌ Gotɨyarɨna dɨnemaremwaala! Maremwaala savɨ Gotɨyai tewaanna wiana! Menya keꞌmwewɨnyaigɨ dɨnevadaihasamaaka! Su! Su!” ");
INSERT INTO byr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sai Anga Jeruzaalemɨ wɨlaawɨna yaka Gotɨyare angevɨ wɨlaawaka saba yuyangɨ tɨnna wangamabɨna yaka sagaaꞌ sawɨsɨrɨna mena yɨmaꞌnakegaaꞌ Betaani anga maalɨkevɨna gamɨrera atɨraai sɨvɨlyɨrɨdaaꞌnyɨ pwaraalyarajɨ kaanna wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mwanyavɨ dɨkaaveva Betaanidaasara wodaapi gamɨnyɨ mɨjɨka wina. ");
INSERT INTO byr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mɨjɨka wina yadaaꞌnyɨ keiba yɨta pihɨyai kɨwaꞌnakerɨ tɨnna wanganaka “Yɨsɨlya daaka?” daka kaanna wɨna. Yɨsaryabanna baka sagaaꞌ dara wanganakeꞌ “O, kɨwata gave daaka?” Sareꞌ dareꞌnesɨ. Yɨta yuya yɨsɨla mya mɨlyadɨꞌnyɨ. ");
INSERT INTO byr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Daka yɨsarɨ wɨdɨna “Yɨsimaayaigɨ yuyagaaꞌ aane pwai kwai gɨmɨre yɨsɨla manyɨ gyatheigɨnyɨ.” Sara wɨdadaasɨ gamɨrera wɨꞌnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jeruzaalemɨna yɨꞌmavaawɨna kyeꞌ Gotɨyare angevɨ saba Jizaazai wɨlaabɨna yaka yaasaraavɨ marirɨgalaasɨna yaꞌ. Nɨgwia yanga yɨnyaꞌneraavɨre yɨꞌbɨnyangɨjɨ kwaamɨrya yaasadɨvɨsaraavɨre namwaalɨsangɨjɨ marapuratawasɨꞌna yaka ");
INSERT INTO byr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","aꞌmweraavɨ wɨdɨna “Gotɨyare anga davɨ aane pwaigɨ kwaigɨ gɨlyɨvɨsa mamwaꞌnalotaꞌdɨnnera!” ");
INSERT INTO byr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sara wɨdɨna yaka wɨjɨwaakɨna “Gotɨyare bukuyaꞌ dɨnɨkeꞌ ‘Gotɨyai dara wɨdakeꞌna daaka! “Nɨmɨre angeꞌ tɨbarɨyagaala jaꞌnesɨra. Aꞌmwe ajɨmya yuyangɨyara angevɨ wɨlaabapi tɨbarɨyagaala nyɨdɨpɨꞌdesɨra.” ’ Sara dɨnɨkeꞌ pwara wɨlaabɨna kyɨwaaꞌ sahwaraavɨre nɨgwia mwagiꞌnyaꞌneba daa dava!” ");
INSERT INTO byr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sipɨzipɨya Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ yagaaikɨwɨjarajɨ sara wɨꞌnadɨvɨꞌ Juya naangera gamɨnyɨna “Baladeꞌna gara yaadeinaavaka?” dɨnyɨna. Sareꞌ dareꞌnesɨ. Sahwarɨna lɨka naanga yesaꞌnanyɨ. Sareꞌ dareꞌnesɨ. Kwala bwaꞌnaanyaꞌ wɨjɨwaakɨyagaalyaꞌna atɨka maruꞌnaꞌmuluna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sara dɨnyɨna kyeꞌ sawɨsaꞌ kajɨnnaꞌ angebadaaꞌnyɨ salyɨ gamɨrerajɨ bwalaawɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mwanyavɨ tusavɨ kaanya wodaapi yɨta pihɨyaꞌ pwipulyajɨ taanyajɨ yuya yawaka balakeꞌ tɨnna wanganna. ");
INSERT INTO byr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tɨnna wanganna kyeꞌ Pitai miꞌna yawɨraka sarɨ wɨdɨna “Nejɨwaakyaigɨ, dangana! Yɨta pihɨyai yagaala dɨragɨnyaꞌ wɨdɨwaꞌdɨnyai mena baimwaka.” ");
INSERT INTO byr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Wɨdɨna kyaꞌ kumɨnyɨ wɨdɨna “Gotɨyarɨ dɨlɨmwagarila! ");
INSERT INTO byr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nebwi yɨhɨthɨwa. Pwai mugunyaꞌ wɨdozɨ ‘Mugunyaigɨ dɨkaavaꞌgɨzɨ saalaalyavɨ dɨvaihɨnana!’ Nabaai gamɨre sɨmunyavɨ ‘Mugunyai sara yadelyɨra,’ kalɨmwagarojɨ Gotɨyai gamɨnyɨna sara yadelyɨra. ");
INSERT INTO byr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Savɨneꞌna yɨhɨthɨwa. Tɨbarɨyagaala duthathe gɨnnya sɨmunyavɨ ‘Gotɨyai mena sara nyɨjaawaꞌ,’ kadaꞌgɨzɨ gɨzaavadengɨra. ");
INSERT INTO byr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tɨbarɨyagaalyaꞌna daavaꞌgɨzɨ yawɨꞌdɨzaꞌ ‘Ai, pwai kwai kayaaꞌna nyɨwaka! Sɨnna tɨka nyɨdaꞌmwaꞌ,’ sagaaꞌ ‘Gamɨre kayaaꞌnanyaꞌ miꞌna marasɨꞌnɨwa,’ jawɨka! Nabaai Gɨmaamaangei Sɨgunyavɨ mwaalɨkei gɨmɨre kayaaꞌnanya marasɨꞌnadeꞌna sara ja! ");
INSERT INTO byr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kɨrɨꞌ pwara kayaaꞌna gyɨwaasaꞌna kumɨre yɨwetawakya mamarasɨꞌnyɨ yɨjaꞌ, yɨ gɨmɨre yɨwetawakyanna Gɨmaamaangei Sɨgunyavɨ mwaalɨkei mamarasɨꞌnyɨ yadelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jeruzaalemɨna ayɨna wɨlaabɨna. Miꞌna wɨlaabɨna kyeꞌ sahwai Gotɨyare angevɨ kaanya bulayamaryadaaꞌnyɨ gamɨnyawɨnna sipɨzipɨya Gotɨyarɨna yɨraꞌdɨvɨta naangerajɨ yagaaikɨwɨjarajɨ aꞌmwe naangerajɨ wɨlaabeva ");
INSERT INTO byr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","wɨdɨna “Sa be dɨragɨnya yawaaihɨnyavaka? Yawaaihɨnyaꞌna sa yaꞌneigɨnyɨ dɨragɨnyaꞌ aai gɨzaavakasɨyaka?” ");
INSERT INTO byr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jizaazai sahwaraavɨ wɨdɨna “Yagaala pɨrɨꞌ yɨhiwaaravɨma! Savɨ kajaꞌnanyɨdapi sara yawaaiheꞌne dɨragɨnyaꞌ yɨhɨzɨwaakɨdeinyɨra. ");
INSERT INTO byr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jonɨ aalya bavɨtaazɨyabwina Sɨgunyavɨdaasɨ Gotɨyai duzɨwaakaka? Kwaakevakɨ aꞌmwera duzɨwaakeva? Dɨzaꞌnanyɨjɨla!” ");
INSERT INTO byr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sara wɨdɨna kyaꞌ yagaala dɨnyɨna “ ‘Sɨgunyavɨdaasasɨra,’ kudawaajɨ ‘Jonɨ nɨmɨnyɨna wɨjɨwaakaꞌ. Baaꞌna muꞌnyetaihɨlaka!’ nanedathɨka! ");
INSERT INTO byr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Sareꞌ kɨrɨꞌ ‘Aꞌmweraavɨdaasasɨ,’ madaanna! Kwala bwaꞌnaanyaꞌ nanerabɨka! Sahwaraavɨna lɨka yadaa mwaaiho.” Sareꞌ dareꞌnesɨ. Aꞌmwe yuyara yawɨꞌna “Nebulyasɨ. Jonɨ Gotɨyarɨ wɨꞌnanejɨwaakadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Sara dɨnyɨna yeva Jizaazarɨ maꞌmaaꞌna “Saꞌna myawɨrivanɨgo.” Jizaazai wɨdɨna “Nabaai manyɨjɨvanɨgasaꞌna nɨmɨ yawaaiheꞌne dɨragɨnyaꞌna mihɨzɨwaakɨwɨnesɨ.” ");
INSERT INTO byr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sahwai keꞌbaꞌna wɨdɨna “Aꞌmwe pwai wawɨnyavɨ gɨraipɨzɨla maaryaꞌna burɨnna yaꞌ. Sai kurɨta yavɨkaryaka gɨraipɨwɨla burɨdaka kaviꞌnɨnnyavɨ gɨraipɨzɨla mwaꞌmwagikyaꞌneꞌ lɨkaka anga maalɨkiꞌ wawɨnyaba banganaryaꞌniꞌ madɨna. Miꞌna madɨna yaka pwaraavɨ wɨdaꞌ ‘Nɨmɨre wawɨnyaꞌ maremwaalapi gɨraipɨzɨla pɨnɨ yɨhɨzaavɨde.’ Sahwara wawɨnyaꞌ kamaremwaaleꞌ aꞌmwe sai kwaaka pɨbanna kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kaanna wɨna kyaꞌ gɨraipɨzɨla mya yakegaaꞌ sai gannya wawɨnyawɨnna wɨdaayaderɨ wawɨnyavɨne sɨla pɨnɨnna wɨdaasɨna. ");
INSERT INTO byr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Aꞌmwe wɨdaasɨna yakei kaanna wɨna kyaꞌ wawɨnyaꞌ maremwaaidɨvɨsara wɨdaayade sarɨ galalɨmwanna yeva mala wɨrameva ayɨna wawɨnyaꞌ gyakwaryawɨnna simaayarɨ wɨdaasɨna. ");
INSERT INTO byr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sara wɨdaasɨna kyeꞌ gyakwai wɨdaayade pwarɨ wɨdaasɨna kyaꞌ gamɨre mɨnyagɨnyavɨ kayaaka yeva bɨrala yɨna. ");
INSERT INTO byr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sara kyeꞌ wɨdaayade pwarɨ wɨdaasɨna kyaꞌ sarɨ mena tamakeva wɨdaayade pwaraavɨ wɨdaasakeraavɨ pwaraavɨ mala tamɨna yeva pwaraavɨ mena tamakɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sara kyeꞌ wawɨnya gyakware pwai gawaalɨvaangei yɨlaaya wɨmaryadei kuna mwaalaꞌ. Ganɨmaangei daka ‘Nyɨbwaalɨvaangerɨna tewaanna yawɨpɨꞌderera,’ daka wɨdaasɨna. ");
INSERT INTO byr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wɨdaasɨna kyaꞌ widavadaaꞌnyɨ wawɨnyaꞌ maremwaaidɨvɨsara tɨnna wanganeva dɨneꞌ ‘Sai gawaalɨꞌ dɨvi ganɨmaangere yuya maaradelyɨra. Yarala, tamakawaajɨ gamɨre wawɨnyaꞌ namaaradɨꞌdeꞌna maraadeinera.’ ");
INSERT INTO byr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sara dɨnyɨna yeva galalɨmwanna yeva tamakɨna yeva gɨraipɨziwawɨnyavɨdaaꞌnyɨ marasɨꞌna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Gɨraipɨwawɨnyavɨ naangei berɨꞌ yadelaka? Sahwai wɨlaabozɨ aꞌmwe saraavɨ kayaaka wigalakojɨ aꞌmwe pwaraavɨ ‘Sarɨmɨ nɨmɨre wawɨnyaꞌ dɨmaremwaalyideihɨlyɨra,’ wɨdathelyɨ. ");
INSERT INTO byr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Gotɨyai dɨnɨkeꞌ pɨkarɨyɨkwia tɨnna mwanganyɨ yadɨvɨsaꞌ daaka?” wɨdɨna yaꞌ. Wɨdɨna yaka sahwai yawɨꞌna “Sɨlaangeinyɨra,” yawɨraka wɨdɨna “Dara dɨnɨkeꞌ ‘Anga madɨvɨsara sɨlaangerɨ wanganeva “Kayaaꞌnanyai,” dɨneva marasɨꞌna yesai Simɨjamaanga nawɨꞌnyai yɨmaꞌnyɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gotɨyare sara wakɨna yakeꞌ Tɨnna wanganona “Tewaanyaꞌ,” dɨno.’ Gotɨyare bukuyaꞌ sara dɨnɨkesɨ.” ");
INSERT INTO byr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Juya naangera dara wanganeꞌ “O, nemɨnyɨna keꞌbaꞌnanyaꞌ duthɨwaka!” Deveꞌna “Jizaazarɨ wɨla yɨrakaana!” dɨneva kwala bwaꞌnaanyavɨna lɨka yeva gamɨnyawɨ yagalyaꞌmavaawɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Aꞌmwe naanga sara Perɨzɨya pwarajɨ Erotɨyare pwarajɨ saraavɨ wɨdaasɨna “Jizaazai kayaaꞌna wɨdatheꞌna dɨwila! ‘Kayaaꞌna kudozɨ kalavuzavɨ wɨmwaihaana!’ dapɨri dɨwila!” ");
INSERT INTO byr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Sara wɨdaasɨna yesara kaanna bɨna yeva wɨdɨna “Nejɨwaakadɨnyaigɨ, ‘Nebulyaꞌ dadeꞌ midaaka!’ gyawɨꞌmwo. Aꞌmwe aane pwai kwai gɨmɨnyɨna dɨvanɨkeꞌna lɨka myɨvanɨgɨ. Sareꞌ dareꞌnesɨ. Aꞌmweraavɨre sɨnna gavevɨ tɨnna mwanganyadɨnyaigɨnyɨ. Aawa. Aꞌmwe naangeraavɨjɨ aꞌmweraavɨjɨ avaaina wɨdadɨ Gotɨyarebwi gavebwi nayaa wɨjɨwaakadɨnyaigɨnyɨra. Romɨ maremwaaidei Sizaarɨ taakɨzɨya wɨjaayaꞌna nemɨre yagaaikɨwɨnya berɨꞌ dɨnɨkavaka? Tewaanyaꞌ daaka? Aawa daaka? Taakɨzɨya wɨjavaadeina daaka? Mujavaanneina daaka?” ");
INSERT INTO byr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sara wɨdesara kwaasɨ yagaala wɨdesaraavɨna yawɨraka wɨdɨna “ ‘Sahwai kayaaꞌnanyabwi yana!’ yawɨreva yaamɨjɨ baaꞌna nyɨdɨwaava! Moneꞌ tɨnna wanganyaꞌneinyɨ dɨnyɨmaryaama!” ");
INSERT INTO byr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wɨdɨna kyaꞌ miꞌna makabɨna kyeꞌ wɨdɨna “Pikɨzaaya dasɨ pɨkarya dajɨ aaihwarengaka?” ");
INSERT INTO byr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“Maremwaaidei Sizaarengɨra,” wɨdeꞌ sahwara. Sara wɨdɨna kyeꞌ Jizaazai wɨdɨna “Sizaarɨ Sizaare ayɨna duzaayɨla! Gotɨyarɨ Gotɨyare ayɨna duzaayɨla!” Sara wɨdɨna kyaꞌ gamɨnyɨna “Nawɨꞌnyabwina dadele!” dɨnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Aꞌmwe Sazuzɨyara, “Aꞌmwera kabalapi yuna madɨkaayɨ yɨpɨꞌdera,” yawɨresarajɨya pwara gamɨnyawɨnna beva yɨwaaraꞌna ");
INSERT INTO byr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Nejɨwaakadɨnyaigɨ, Ne Mozɨzai nedɨnɨkeꞌ ‘Aꞌmwe pwai kware gyaꞌmwei balajai kaimɨraavɨmaayai aꞌmwevɨ bwasɨkwojaꞌ aꞌmwei aꞌmwe savɨ maarojɨ kaimɨraaya maryawakɨnna, yayaꞌ baryarɨneꞌ wɨdɨna yadengɨra.’ ");
INSERT INTO byr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Saꞌna dɨnɨkeꞌ aꞌmwe ata purɨdaasɨ pwaraalyadaraka mwaaleꞌ. Kamwaaleꞌ sɨraangai aꞌmwevɨ maaraka kaimɨraavɨmaayai gamɨre sɨvigwaꞌjɨkerɨnei kunei balaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kabalaꞌ dɨviyai aꞌmwe savɨ maaraka kaimɨraavɨmaayai balaꞌ. Kabalaꞌ dɨviya pwai avaaina yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sana sana yuyara ata purɨdaasɨ pwaraalyadaraka aꞌmwe savɨ maareva kaimɨraavɨmaayadaraka baleꞌ. Kabaleꞌ aayagaaꞌ aꞌmwe saꞌ balaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dɨkaasagaaꞌ sahwaraavɨ kyɨdɨkaavojɨ aꞌmwe gawareꞌ mwaaladevaka? Sareꞌ dareꞌnesɨ. Ata purɨdaasɨ daraalyara yuya sadaraka balaanga saꞌ maaresaꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sara yɨwaaraꞌna kyeꞌ Jizaazai wɨdɨna “Sarɨmɨre sɨmunya kayaaꞌna yawɨꞌmanɨgaꞌ. Gotɨyare bukuyasɨ Gotɨyare dɨragɨnyasɨ myawɨrivanɨgasavɨ kayaaꞌna yawɨꞌmanɨgasaꞌna midaaka! ");
INSERT INTO byr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sareꞌ dareꞌnesɨ. Baryara dɨkaapɨꞌdehaaꞌ aꞌmwera aꞌmwengɨ mamaarina, aꞌmwe aꞌmweraavɨ mamaaꞌnyɨ yɨpɨꞌdengɨ. Aawa. Sɨgunyavɨ balaangengɨ mamaaryadɨvɨsara mamaayara mwaaihatabaaibɨsarera. ");
INSERT INTO byr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nabaai baryara dɨkaapɨꞌdeꞌna Ne Mozɨzai yɨdayaakeꞌ yɨsɨꞌ dɨka nyaakeꞌ yagaalyavɨ mwanganyɨjeva! Yɨsɨkɨdaasɨ Gotɨyai Mozɨzarɨ wɨjaaꞌ ‘Dahaaꞌ Evɨraamɨmɨre Gotɨyainyɨ. Dahaaꞌ Aazakɨmɨre Gotɨyainyɨ. Dahaaꞌ Jaikopɨmɨre Gotɨyainyɨ.’ ");
INSERT INTO byr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mozɨzai sara yɨdayaakeꞌ aꞌmwera baleva Gotɨyareba mwaaihasaꞌna Gotɨyai wɨdɨna ‘Kumɨre Gotɨyainyɨ.’ Aꞌmwera yawɨꞌna ‘O, aꞌmwe bainɨkera.’ Kɨrɨꞌ Gotɨyai yawɨꞌna ‘Nɨmɨnyɨneꞌna gaala mwaaihasara.’ Sarɨmɨre yagaala kwaasɨ yagaalyasɨra,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yagaaikɨwɨja pwai baka dɨnyɨna yesaꞌ wɨꞌnaka dara wanganakeꞌ “Sahwai nayaa duthɨvanɨka!” Daka yɨwaaraꞌna “Yagaaikɨwɨnya kwalaalya warɨꞌ. Yagaaikɨwɨnya aaya sɨnnawɨnyaꞌ berɨvaka?” ");
INSERT INTO byr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jizaazai jaꞌnawɨdɨna “Yagaaikɨwɨnya sɨnnawɨnyaꞌ dara dɨnɨkeꞌ ‘Yɨzɨrelɨyaihi duꞌnyi! Naangei nemɨre Gotɨyai Naanga gave pwainanyalyɨra. ");
INSERT INTO byr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Naangei gɨmɨre Gotɨyarɨna naanga gɨvuꞌnana! Gɨmɨre sɨmunya yuyavɨjɨ gɨmɨre kurya naangeinajɨ gɨmɨre yawɨta yuyangɨjɨ, gɨmɨre dɨragɨnya yuyangɨjɨ Gotɨyarɨna naanga gɨvuꞌnana!’ ");
INSERT INTO byr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yagaaikɨwɨnya aya kɨrɨꞌ dara dɨnɨkeꞌ ‘Gɨmɨ saigɨ gɨmɨnyɨna kale gyɨvanɨkeꞌ aꞌmwe gɨmɨre angeba mwaalɨkerɨna sara kale gyana!’ Yagaaikɨwɨnya dawaai naangewaalyɨra. Yagaaikɨwɨnya aane pɨrɨꞌ kɨrɨꞌ yuya sawaarɨ wavɨlaꞌmanɨka pɨrɨꞌ mɨꞌ.” ");
INSERT INTO byr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Sara wɨdɨna kyaꞌ Yagaaikɨwɨjai wɨdɨna “Nejɨwaakadɨnyaigɨ, tewaanya dɨwaana. Nayaa dɨwaa ‘Gamɨ gave pwainanyalyɨ. Gotɨya aane pwai kwai mamwaalyɨꞌ.’ ");
INSERT INTO byr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Gamɨnyɨna sɨmunya yuyasɨ, munyɨꞌ yuyɨsɨ, yawɨta yuyasɨ, dɨragɨnya yuyajɨ, naanga nevuꞌnadeꞌna tewaanyasɨra. Nabaai nemɨnyɨna kale neyɨvanɨkeꞌ aꞌmwe nemɨre angeba mwaalɨkerɨna kale sara neyana! Saꞌ tewaanyasɨra. Sawaai naangewaalyɨra. Gotɨyarɨne sipɨzipɨya bulɨmakaawoya yuyara dɨka nasɨꞌna yadejɨ yuya yanga wɨmaarina yadaanyajɨ sa maalɨkengɨra.” ");
INSERT INTO byr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sara wɨdɨna kyaꞌ Jizaazai dara wanganakeꞌ “Gamɨ sai tewaanya dathɨvanɨka!” Daka wɨdɨna “Gotɨyai maremwaaideva maavewɨ mamwaalyɨgɨ.” Sara wɨdɨna kyaꞌ aꞌmwe aane pwai kwai myawɨramaari “Nɨmɨ lɨka myɨvanɨge. Yagaala pɨnɨ yɨwaaravɨdeinyɨra,” myawɨramaari yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Gotɨyare Angevɨ Jizaazai wɨjɨwaakakei wɨdɨna “ ‘Kɨraazɨtɨyai, Gotɨyai wɨdasaabathei Ne Devitɨmɨ Gawaalɨkɨra,’ Yagaaikɨwɨjara sara beꞌna wɨdɨvanɨgava? ");
INSERT INTO byr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Gotɨyare Kuryarɨ Devitɨ sahwai pɨkarya yɨdayaaꞌ ‘Nemɨre Naangei nɨmɨre Naangerɨ wɨdaꞌ “Naarɨmɨ yuyaraavɨ maremwaalakadeinaalyɨ. Nɨmɨre aangasabanna dɨmwaaideigɨnyɨ. Gɨmɨre sɨvɨlyɨraarɨ yɨkamaangeraavɨ marulawakɨdehaaꞌnanyɨ.” ’ ");
INSERT INTO byr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devitɨ sahwai Kɨraazɨtɨyarɨna ‘Naangelyɨra,’ sara dɨnɨkeꞌna gamɨre gawaalɨvaangei gara mwaalɨka!” Sara wɨdɨna kyaꞌ kwala bwaꞌnaanya wɨꞌneva yɨlaaya yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sara wɨjɨwaakɨna “Yagaaikɨwɨja pwaraavɨrebwi mipɨnera! Mala nayaa jɨwannyɨla! Kumɨ sara yɨlaayabwi ‘Aꞌmwera yawɨpɨka! “Sara sɨduꞌnakera mwaaihava!” ’ deva yɨvɨta gaala saamɨnyaꞌ marabwaayeva kaanya yamaryɨvanɨgasabwi. Mubyabanna aꞌmwera ‘Naangeigɨ. Tewaanyaigɨ,’ wɨdɨvanɨgasabwi. ");
INSERT INTO byr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lotuangevɨ naangeraavɨre namwaalyɨsangɨ mwaaimanɨgasabwi. Tɨka munnegaaꞌ nawɨꞌnyaba gaveba nɨvanɨgasabwi. Sabwina yɨlaaya marivanɨgaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sara yɨvanɨgasara yaanyɨwaakengɨre angengɨ kuka yuna maaꞌmanɨgasara. Aꞌmwera ‘Kumɨ sara tewaanyarera,’ yawɨryaꞌnera tɨbarɨyagaala naanga kwaasɨ wɨdɨvanɨgaꞌ. Sara yɨvanɨgasaraavɨ Gotɨyai naanna jɨdavadera daanga naanga wɨvɨnaderera,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Gotɨyare angevɨ nɨgwia wakyaꞌneba aya kɨba Jizaazai mwaalaka aꞌmwera nɨgwia wakesangɨ tɨnna wanganna. Tɨnna wangadaaꞌnyɨ aꞌmwera gɨlyɨvɨta naangejɨyara nɨgwia naanga kwakeꞌ ");
INSERT INTO byr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","yaanyɨwaakeꞌ gɨlyɨvɨꞌmaayaꞌ baka nɨgwia maalɨkikaai wakɨna. ");
INSERT INTO byr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sara wakɨna kyaꞌ sai gamɨreraavɨ jɨvwaramaaꞌna yaka wɨdɨna “Nyuꞌnyɨla! Nebwi yɨhɨthɨwa. Yaanyɨwaaka gɨlyɨvɨꞌmaaya daꞌ Gotɨyarɨna naanga wɨjaawaka. Pwara maalɨꞌna wɨjawaava. ");
INSERT INTO byr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sareꞌ dareꞌnesɨ. Sahwara nɨgwia naange wakɨwaasa Gotɨyai wanganaka nabaai nɨgwia naanga naanga kumɨre angengɨ kuna warɨke wanganaka dɨvanɨꞌ ‘Yanga maalɨkesɨra.’ Aꞌmweꞌ nɨgwia maalɨkikaai wakɨwakevɨ Gotɨyai wanganaka dara wangamwakeꞌ ‘Ai, aꞌmwe saꞌ wɨgainɨwakeꞌ gannya yuya dakɨwaka! Nɨgwia pɨnɨ wapaaya mubyaꞌna mwarijɨka!’ Daka dɨvanɨꞌ ‘Yanga naangesɨra.’ ” ");
INSERT INTO byr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sai Gotɨyare angevɨ bwalyodaaꞌnyɨ gamɨre pwai wɨdɨna “Nejɨwaakadɨnyaigɨ, dangana! Sɨla anga tewaanya sangɨ dangana!” ");
INSERT INTO byr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jizaazai wɨdɨna “Anga tewaanya dangɨ mwanganyɨjɨvanɨgɨna? Sɨlaanga aꞌba yɨlaꞌdɨꞌnyɨyaꞌ kunewɨ mwari yadesɨ. Arɨkewɨ. Yuya woꞌdalayɨwɨnasɨpɨꞌdengɨ.” ");
INSERT INTO byr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Dɨvi sagaaꞌ Mugunya Wolivɨ sai mwaaidɨꞌnyɨ Gotɨyare Angeꞌ pihɨrɨ mannadɨsɨ wangadaaꞌnyɨ aꞌmwera mamwaalyaba Pitalyɨ Jemɨzalyɨ Jonɨjɨ Edɨruyalyɨ sara yɨwaaraꞌna ");
INSERT INTO byr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Dɨnedana! Dɨwaanya saꞌ Gotɨyare angevɨna gathɨhaaꞌ yɨmaꞌnadevaka? ‘Jizaazai sara nedakeꞌ yarai yɨmaꞌnaabazɨ!’ be wɨjɨwaainyaꞌ wanganawaajɨ yawɨraadevaka?” ");
INSERT INTO byr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Miꞌna yɨwaaraꞌna kyeꞌ Jizaazai gaai wɨdɨna “Sarɨmɨ mala nayaa jɨwannyɨla! Pwai kwai kwaasɨ yagaala nayɨhɨthathɨka! ");
INSERT INTO byr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aꞌmwe kwalaalyara nɨmɨnyɨne yayaꞌ maarapɨjɨ wɨdɨpɨꞌdera ‘Nɨmɨ sahwainyɨra. Kɨraazɨtɨyainyɨra.’ Sara kadapɨjɨ aꞌmwe kwalaalyara ‘Nebulyasɨra,’ dapi kumɨnyɨ aꞌmwe kwaasɨyaraavɨ mɨdɨbɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nabaai malyangɨnajɨ malyangɨne yɨhukyagaalyangɨnajɨ wɨꞌnapɨjɨ yawɨta kwalaalya mipɨnera! Aawa. Sa yɨmaꞌnanneꞌna kɨrɨꞌ Kwaakevakɨ aayaꞌ yarai yadeꞌ mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Sareꞌ dareꞌnesɨ. Anga naanga pimagɨnyara anga naanga pimagɨnya pwarajɨ mala bwaꞌnɨpɨꞌderera. Aꞌmwe naanga kingɨya pwarera aꞌmwe naangai kingɨya pwarerari mala bwaꞌnɨpɨꞌderera. Kwalaalyaba wɨnɨnya yadengɨra. Mɨjɨka naanga yɨmaꞌnadengɨra. Yuya yuya sa yɨbwasɨnapi dɨvidaasɨ kayaaꞌnanya yɨmaꞌnadehaakɨra. ");
INSERT INTO byr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kayaaꞌnanyara kayaaka nayɨhigaibɨꞌdeꞌna nayaa jawɨrila sarɨmɨ saihi! Pwara sarɨmɨnyɨ wɨla yɨrakapɨjɨ kaajolɨyaraavɨ yɨhɨmaaripɨꞌdere. Lotuangengɨ yɨhɨrabɨꞌdeihɨlyɨ. Nɨmɨnyɨna Gaꞌmaanɨyaraavɨjɨ aꞌmwe naangeraavɨ kingɨyaraavɨjɨ kihɨmwangapɨjɨ sarɨmɨ yagaala tewaanyaꞌ nebulyaꞌna dɨzalɨkurakyideꞌnanyɨ! ");
INSERT INTO byr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Gotɨyai yawɨrakeꞌna aꞌmwe ajɨmya yuyangɨyara gazabazaba mwaaihasaraavɨ Gotɨyare yagaala tewaanyaꞌ sɨnnawɨ kujɨwaakapɨjɨ dɨvi aayaꞌna yɨmaꞌnadehaakɨra. ");
INSERT INTO byr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wɨla yɨhirapɨjɨ kotɨya yadɨvɨta angevɨna yɨhɨmarɨmwaaihyaꞌnera kihɨmakabapɨjɨ sarɨmɨ yawɨta kwalaalya mipɨnera! ‘Nɨmɨ gara wɨdɨdeinyaka?’ myawɨpɨnera! Aawana. Sagaaꞌ Gotɨyai yagaalyaꞌ sara kyɨhɨzaavojɨ dathazaꞌ sara duzideihɨlyɨra. Sareꞌ dareꞌnesɨ. Sagaaꞌ sarɨmɨ duzideihi mɨka. Aawa. Kurya Tewaanyai sara wɨdathelyɨra. ");
INSERT INTO byr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Aꞌmwe pwai dɨna ‘Nyaꞌmwerɨ tamakɨpɨꞌdeꞌnanyɨ,’ dozɨ gyaꞌmwerɨ kotɨya yadɨvɨsabanna wɨmarɨmwaaihadelyɨ. Nabaai ganɨmaanga pwai gannya kaimɨraayarɨ wɨmarɨmwaaihadelyɨ. Kaimɨraaya pwara kuvɨnɨmaangeyuraavɨ kotɨyabanna makuna yɨpɨꞌde yuya baibɨꞌdengɨra. ");
INSERT INTO byr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nɨmɨre yayavɨna yɨhyawɨꞌdɨvɨꞌ saihɨrɨna aꞌmwe yuyaraavɨ sɨnna tɨka wɨdavaderera. Kɨrɨꞌ aꞌmwe pwai nɨmɨnyɨna dɨragɨnna daavajarɨ aayagaaꞌ gannya baryaꞌnegaaꞌ Gotɨyai padaihasamaaradelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yagaala daꞌ yɨdavɨdeꞌna nayaa jawɨrila! Sahwai wɨdɨna “Kayaaꞌnanaangei kayaaka yɨgaidei saba madaayɨ yajava kadaavojɨ danganyideihɨlyɨ.” Pɨkarya savɨ wanganaꞌgɨzɨ Jizaazare yagaala saꞌ jawɨramaaka! “Daaꞌdɨsɨ Juthɨya mwaalyara mugunyangɨna yarai lɨkaanya wɨpɨka! ");
INSERT INTO byr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aꞌmwe pwai namwaalɨkwaasavɨ mwaalojɨyai ‘Angevɨ gɨlyɨvɨta kɨnɨ wɨlamaarɨma!’ majai yarai lɨkaanya wɨna yana!. ");
INSERT INTO byr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aꞌmwe pwai wawɨnya yɨvanɨkei gannya angevɨna yɨvɨta maaryaꞌnei ayɨna mabannelyɨ. ");
INSERT INTO byr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Dazagaasagaaꞌ, weꞌ, aꞌmwe kaimɨraavɨmunnakenge! Weꞌ, aamunya wɨjaavanɨgave sagaake! ");
INSERT INTO byr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","‘Burɨkeꞌ nabwalaradɨka! Yɨrɨlyaꞌ nanedathɨka!’ dapɨjɨ tɨbarɨyagaala duzɨla! ");
INSERT INTO byr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sareꞌ dareꞌnesɨ. Sagaaꞌna aꞌmweraavɨ daanga naanga wɨvɨnadehaakɨra. Daanga naanga nevɨnaja sagaaꞌ kayaaꞌnanyagaakɨra. Sɨnnawɨ Gotɨyai wakyaakegaasɨ kɨgaasɨ dahaaꞌ kɨgaasɨ wɨla dɨvi kɨgaasɨ daanga sabwi aawano. Arɨkewɨ. ");
INSERT INTO byr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","‘Yɨrɨka sa daanga naangegaaꞌ yesɨmavadɨma!’ Gotɨyai yagaala sara majɨ yajaꞌ aꞌmwe yuya kɨlaaꞌnake mamwaalyɨ yɨpɨꞌdengɨra. Aawa. ‘ “Nɨmɨre dahɨlakɨwera nabaibɨthɨka!” dena nɨmɨ yesɨmavadɨma!’ Gotɨyai dɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Sagaaꞌ pwai kwai gɨthazaꞌ ‘Dangana! Dava Kɨraazɨtɨyai mwaalɨꞌ,’ nabaai gɨthazaꞌ ‘Dangana! Keiba mwaalɨꞌ,’ sarɨmɨ muꞌnɨpɨnera! ");
INSERT INTO byr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Dɨvi kwaasɨ kwaasɨ Kɨraazɨtɨyara, Gotɨyarɨ wɨꞌnawɨjɨwaakadɨvɨta kwaasɨ kwaasɨyara kumɨ sara kwaasɨ yawɨradɨdɨvɨꞌ wɨlaabapɨjɨ dapɨjɨ ‘Gotɨyai dahɨlakakera yawɨpɨꞌdeꞌ dɨngaka? Kwaasɨ yagaala wɨꞌnɨpɨka! Kayaaꞌna yɨpɨka!’ wɨjɨwaainyajɨ atɨka maruꞌnatajɨ kwaasɨ yɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Sara yɨpɨꞌdeꞌna sarɨmɨ saihi tewaanna nayaa dɨvaihanaryɨla! Mala nayaa jɨwannyɨla! Dɨvi yuya sa yɨmaꞌnyɨna yadengɨna sɨnnawɨ sagaaꞌ yɨhɨthɨvanɨge. ");
INSERT INTO byr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Sareꞌ kɨrɨꞌ sagaaꞌ daanga naanga wɨvɨnade sasaꞌ tɨviꞌna kyojɨ yɨrɨka sangɨ nyɨlyai mujɨ kyojɨ jɨhɨnya yɨmaꞌnyɨna, nabaai lawei mujɨ yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sɨgunyavɨdaasɨ sɨlɨngaamɨnyarɨka pɨrɨꞌ bwalaꞌna, pɨrɨꞌ bwalaꞌna, sɨgunyavɨ dɨragɨnya warɨkevɨ wɨnɨnya naangeꞌna yɨmaꞌnadesɨ. ");
INSERT INTO byr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Wɨnɨnya kyojɨ Aꞌmweraavɨne Kaimɨraayai yɨraayavɨ dɨragɨnya naangeꞌ, tewaanya naangeꞌ, byaanna naangeꞌ waꞌdozɨyavɨ kwalaabozɨ wangabɨꞌdelyɨra. ");
INSERT INTO byr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sahwai ejelɨyaraavɨ wɨdaasɨna ‘Nɨmɨre dahɨlakengɨ Kwaakevakɨ yuneba pimagɨ pimagɨ akyamwidaaꞌnyɨ akyamwidaaꞌnyɨ kwala dalamariꞌbwaraawila!’ wɨdasaabɨna yadelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Yɨta pihɨya wanganapɨjɨ keꞌbaꞌnanya saꞌ jawɨrila! Pihɨtaanyavɨ wɨvya naanga kyojɨ sedala pwaꞌnyɨna yojɨyagaaꞌ sarɨmɨ yawɨꞌdɨvɨꞌ ‘Pihɨyaꞌ lɨꞌmwaꞌ. Nyɨlyagaaꞌ aya kɨgaaꞌ yɨmaꞌnadehaakɨ.’ ");
INSERT INTO byr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sara yawɨꞌdɨvɨtabaaibɨꞌ sarɨmɨ dɨwe sangɨ yɨpɨꞌdengɨ wanganapɨjɨ dara jawɨrila! ‘Gamɨ miꞌna yarai walaabathei. Tɨkuryavɨ daavɨꞌ.’ ");
INSERT INTO byr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nebulyaꞌna yɨhɨthɨwa. Aꞌmwe sagaaꞌ mwaalyara kuna myɨmanɨgwiadapi yuya dɨwe sa yɨmaꞌnadehaaꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sɨgunyasɨ Kwaakevasɨ savakaai dɨvi sagaaꞌ kiwawojɨ kɨrɨꞌ nɨmɨre yagaalyaꞌ yɨwawodeꞌ mɨꞌ. Waragothesɨra.” ");
INSERT INTO byr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Yɨrɨka walaabɨde sagaaꞌna aane pwai kwai yawɨradehaaꞌ mɨꞌ. Ejelɨyara Gotɨyareba mwaaihasara myawɨrivanɨgaꞌ. Gotɨyarɨ Gawaalɨvaangai myawɨrivanɨꞌ. Nɨmwai gavei yawɨꞌmanɨꞌ. ");
INSERT INTO byr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Sarɨmɨ mala nayaa jɨwannyɨla! Sareꞌ dareꞌnesɨ. ‘Sagaaꞌ gathɨhaaꞌ yɨmaꞌnadeꞌ dɨngaka?’ myawɨrivanɨgo. Sareꞌna dɨvaihanaryɨla! ");
INSERT INTO byr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Aꞌmwe daibɨsainyɨra. Aꞌmwe sai pɨwɨnnei gannya wawɨnyangɨ wɨdaayadɨvɨsaraavɨ maramwaaihɨna kumɨre wawɨnyaꞌna, pwai gannya wawɨnya wɨjɨwaakɨna, pwai gannya wawɨnya wɨjɨwaakɨna sana sana yaka tɨkuryaba mwaaidei damerɨ wɨdɨna ‘Nayaa dɨvaihanaꞌ!’ wɨdɨwakelyɨ. Sahɨbaaibɨꞌ yɨhɨthɨma! ");
INSERT INTO byr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","‘Sarevɨdaaꞌnyɨ nɨmɨreihi, nabaai nayaa dɨvaihanaryɨla!’ Sareꞌ dareꞌnesɨ. Angevɨne naangerɨna yawɨꞌna ‘Gamɨ gathɨngaaꞌ bathei dɨngaꞌ!’ myawɨrivanɨgo. ‘Sawɨsavɨ bathei dɨngaka? Kalawawegaaꞌ bathei dɨngaka? Yɨrɨkunyagaaꞌ bathei dɨngaka? Yɨrɨke byaaka gaai yadaaworiyagaaꞌ bathei dɨngaka? Nemɨ myawɨrivanɨgo,’ dapi nayaa dɨvaihanaryɨla! ");
INSERT INTO byr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","‘Nɨmɨ yɨmeꞌnyabɨꞌ yɨmaꞌnaabaꞌmujɨ yarai walaabɨdeꞌna se waꞌdapi nayɨhwangamudɨꞌ! ");
INSERT INTO byr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nabaai nɨmɨrerajɨ kayaaꞌna nabaibɨthɨka!’ dena yɨhɨthɨvanɨge saꞌna aꞌmweraavɨ wɨdɨvanɨge ‘Nayaa dɨvaihanaryɨla!’ ” wɨdɨna yaꞌ Jizaazai. ");
INSERT INTO byr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","“Sawɨta daryaai kajɨnnojɨ tɨka Pariꞌmaꞌmunneꞌnajɨ tɨka munne Gɨrɨkula lɨwɨnya pamidakɨna myadeꞌnajɨ naadengɨra,” Juyara dɨnyɨna. Sara dɨnyɨna kyeꞌ sagaaꞌ sipɨzipɨya Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ Juyaraavɨre Yagaaikɨwɨjarajɨ dɨnyɨna “Nemɨ lɨka gavabɨꞌ yulyarawaajɨ wɨla yɨrawaajɨ tamakaadeꞌna sahwarɨ?” dɨnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Sareꞌ dareꞌnesɨ. Sahwara dɨna “Tɨka munne sagaaꞌ aꞌmwera mala nanerabɨka! Sagaaꞌ sarɨna mwaalana!” ");
INSERT INTO byr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sai Anga Betaani mwaalaka Saaimonɨ Samatanakere angevɨ wɨlɨna wapaaya nyaꞌnei walyamwaaidɨsɨ aꞌmweꞌ wɨlaabɨna. Aꞌmweꞌ simaaꞌgula nawɨꞌnya wabatɨrɨnya naathɨ tɨrɨnya winyaꞌne mubya naange yakeꞌ yɨꞌnɨkesɨ makulaabɨna. Makulaabɨna yaka simaaꞌgulyaꞌ tɨngɨꞌna yaka gamɨre mɨnyagɨnyavɨ dɨngɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tɨviꞌna dɨngɨna kyaꞌ pwara sɨmunyangɨ sɨnna tɨka wɨdaꞌdaaꞌnyɨ dɨnyɨna “Wabatɨrɨnya winyaꞌneꞌ beꞌna wasɨꞌnɨwaka! ");
INSERT INTO byr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Sareꞌ dareꞌnesɨ. Wabatɨrɨnya saꞌ kinaaya kwala naanga naanga (yɨrɨka 300 wawɨnyaꞌne nɨgwia) mubazɨ kwajɨ aꞌmwe nɨgwɨmaayaraavɨ nɨgwia kujaavadɨka!” Dɨnyɨna yeva “Aꞌmwemɨlɨꞌgɨ baaꞌna yɨwaa!” maanga wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Maanga miꞌna wɨdɨna kyeꞌ Jizaazai wɨdɨna “Aꞌmweꞌ mwaalana! Sara baaꞌna wɨdɨvanɨgava! Nɨmɨnyɨna tewaanya nawɨꞌnyaꞌ nyɨwakesɨra. ");
INSERT INTO byr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sareꞌ dareꞌnesɨ. Sarɨmɨnyaba yuyagaaꞌ aꞌmwe nɨgwɨmaayara mwaaidɨvɨꞌ ‘Wawɨnya maayaraavɨ tewaanya wideinyɨ,’ yawɨrapiyagaaꞌ tewaanya jideihɨlyɨra. Wawɨmaayara yuna mwaaidɨvɨꞌ kɨrɨꞌ nɨmɨ sarɨmɨnyaba yuyagaaꞌ mamwaalyɨ yɨdeinyɨra. ");
INSERT INTO byr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aꞌmwe saꞌ yanneꞌna yɨwaꞌ. Dahaaꞌ nɨmɨre kɨlaakejɨkɨ kanyɨdɨngɨwaꞌ dɨvidaasɨ wabatɨrɨnakeinyɨ balɨdeinyɨra. ");
INSERT INTO byr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nebulyaꞌna yɨhɨthɨwa. Kwaaka yuyavakaavɨ yagaala tewaanyaꞌ wɨdɨpɨꞌdevakaavɨ aꞌmweꞌ nyɨnɨkeꞌ gamɨnyɨ yawɨpɨꞌdeꞌna wɨjɨwaakɨpɨꞌdesɨra.” ");
INSERT INTO byr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sagaaꞌ gamɨre aꞌmwe ata yuyɨraai sɨvɨlyɨrɨdaasɨ pwaraalyara mwaaidɨvɨꞌ aꞌmwe gavei Yɨzɨkerɨyotɨyai Juthaazai woꞌnɨkei mwaaida “Kumɨ wɨla yɨrakɨpɨꞌdeꞌna wɨdɨma!” daka sipɨzipɨya Gotɨyarɨne tamiraꞌdɨvɨta naangeraayawɨnna wɨna. ");
INSERT INTO byr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Miꞌna wawaka yagaala wɨdɨna kyaꞌ kumɨ yɨlaaya marina yeva “Gɨmɨnyɨna nɨgwia gɨzavaana!” wɨdɨna yeꞌ. Miꞌna wɨdɨna kyeꞌ yawɨꞌna “Kumɨ Jizaazarɨ wɨla yɨrakɨpɨꞌdeꞌna nɨmɨ gara yɨdeinyaka?” Yawɨraka kuna yawɨꞌna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Munne Gɨrɨkula lɨwɨnya mamɨlyadeꞌ gaai yɨmaꞌnyɨna kyaꞌ sagaaꞌ Pariꞌmaꞌmunne sipɨzipɨya dɨwɨnyarɨ Juyara tadɨvɨsagaaꞌ gamɨrera wɨdɨna “Nemɨ kwawaajɨ gɨmɨ Pariꞌmaꞌmunne sipɨzipɨyarɨ dɨnadeꞌna gava yovɨrawakaajɨwona?” ");
INSERT INTO byr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sara wɨdɨna kyeꞌ gamɨreraarɨ wɨdaasɨna yaꞌ “Angeba wɨlakɨri aꞌmwe pwai aalɨtalyaꞌ kinya marina yɨwakerɨ duzɨmaꞌnaawila! Wɨjɨmaꞌnaawakɨri angevɨ wɨlaawadevanyarɨ dɨmɨdɨnyɨla! ");
INSERT INTO byr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Saba angesɨyarɨ duzɨla! ‘Gotɨyare yagaala wɨjɨwaakadei gɨthɨvanɨꞌ “Gavi kuꞌdɨka yarinɨkevɨ se waꞌdeva gavanaka? Pariꞌmaꞌmunnevɨ nɨmɨjɨ nɨmɨrerari naadevanyɨra.” ’ ");
INSERT INTO byr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kɨrɨmɨ sara kudakɨri gavi kuꞌdɨka naanga munyaba yarinɨkevɨ nemɨnyɨne namwaalyɨtajɨ taivolɨyajɨ warɨkevɨ yɨhibwarɨdaakwadevɨ nemɨnyɨna wapaaya jovɨrawakyɨla!” ");
INSERT INTO byr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tɨviꞌna wɨdaasɨna kyaꞌ gamɨreraai wawagɨla angeba wɨlaawɨna yagɨla dara wanganagɨlyaꞌ “Jizaazai sara nehɨthɨwake darɨꞌ!” Miꞌna yawɨragɨla Pariꞌmaꞌmunne yuya yovɨrawakɨna yagi. ");
INSERT INTO byr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sawɨsaꞌ mena kajɨnnaꞌ sahwai gamɨrerari bɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bɨna kyaꞌ wapewakamaranyavɨna asɨrajɨ dɨhaihɨꞌna yadɨvɨꞌ namwaaidapi Jizaazai wɨdɨna “Nebulyaꞌna yɨhɨthɨwa. Sarɨmɨjɨya pwai nɨmɨnyɨna yɨkamaangera wɨla nyɨrakɨpɨꞌdeꞌna nyɨmarɨmwaaihadei nɨmɨjɨ wapaa nɨvanɨgolyai nɨmɨnyɨna yɨkamaangeraavɨ wɨdathelyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Sara wɨdɨna kyaꞌ kumɨnyɨ kale wiadaaꞌnyɨ pwai wɨdɨna “Nɨmɨ daaka? Nɨmɨ dɨngaka?” pwai wɨdɨna “Nɨmɨ daaka?” yuyara sana sana wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Miꞌna wɨdɨna kyeꞌ sahwai wɨdɨna “Atɨraai sɨvɨlyɨrɨdaasɨ pwaraalyaihɨlyɨya pwalyɨ gɨrɨkula maaꞌgula gavevɨ dɨwɨlavanɨvanɨgolyalyɨra. ");
INSERT INTO byr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gotɨyare bukuyaꞌ dɨnɨkabaaibɨsaꞌna ‘Aꞌmweraavɨne Kaimɨraayai baryaꞌnei wawadelyɨra.’ Weꞌ, aꞌmwei Aꞌmweraavɨne Kaimɨraayarɨna yɨkamaangeraavɨ wɨdathele! Sara kyojɨ aꞌmwe sarɨ ganaangeꞌ mamaari yajɨ kwajɨ tewaanya kyadɨꞌ!” ");
INSERT INTO byr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kumɨ nadaapi Jizaazai gɨrɨkula maaraka Gotɨyarɨ wɨdaꞌ “Gɨmɨre yayaꞌ makimwa. Su! Su!” Miꞌna wɨdaka gunyɨna gunyɨna yaka wɨjaavaka wɨdɨna “Dɨmaaryɨla! Daꞌ nɨmɨre kɨlaakejɨkɨra.” ");
INSERT INTO byr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wɨdaka kaapɨvananyaꞌ maaraka Gotɨyarɨ “Su!” wɨdaka wɨjaavɨna kyaꞌ kumɨ sara yuyara pwai nyɨna pwai nyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Miꞌna nyɨna kyeꞌ wɨdɨna “Waainɨyaꞌ miꞌna nɨwaasaꞌ yɨ, wɨlɨmwagarɨkeburɨne nɨmɨre taweꞌ nɨwaasasɨ. Nɨmɨre tawe saꞌ gɨragɨre aꞌmwe kwalaalyaraavɨna bwalaravadesɨ. ");
INSERT INTO byr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nebulyaꞌna yɨhɨthɨvanɨge. Aalya waainɨyaꞌ gɨraipɨwɨlyavɨdaasaꞌ ayɨna manyaꞌmujɨ Gotɨyai maremwaaideva waainɨya mudɨkeꞌ nɨdehaaꞌnanyɨ. Arɨkewɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tɨviꞌna wɨdɨna kyaꞌ yɨledaata pɨrɨꞌna deva Mugunya Wolivɨna kaanna wɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jizaazai wɨdɨna “Sarɨmɨ lɨka yapi nɨmɨnyɨ dɨnyagalyaꞌmakwideihɨlyɨra. Gotɨyai dara dɨnɨkesɨ. Sipɨzipɨya yɨꞌdɨvaiderɨ karamakaꞌmujɨ sipɨzipɨyara lɨkaanya yɨwɨnadaapɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sara jide kɨrɨꞌ nɨmɨ kabalaꞌmujɨ kanyadɨkaavojɨ Galɨlineinyɨ sɨnnawɨ yɨhibwaramakwaanɨdeinyɨ waanɨdera.” ");
INSERT INTO byr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Sara wɨdɨna kyaꞌ Pitai wɨdɨna “Aꞌmwe yuyara kyagɨhalyaꞌmakwopi nɨmɨ aawa!” ");
INSERT INTO byr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jizaazai wɨdɨna “Nebulyaꞌna gɨthɨwa. Sawɨta dahaasagaaꞌ nɨmɨnyɨna ‘Aꞌmwe sarɨ mwanganyainyɨra,’ duthatheigɨnyɨra. Dahasaai dahaaꞌ kadaꞌgɨzɨ kukuraayai yagaala pɨgasaai dathelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Sara wɨdɨna kyaꞌ yagaala dɨragɨnna bazɨwɨna “Gɨmɨnyɨna ‘Aꞌmwe sarɨ mwanganyainyɨ,’ majɨ yɨwɨjaꞌ nehɨramakɨpɨꞌdeinaalyɨra. Arɨkawɨ.” Gamɨ sara wɨdakeꞌ yuyara sara wɨdɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yaayeba Gazamani woꞌnɨkebanna wɨna kyeꞌ sai gamɨreraavɨ wɨdɨna “Nɨmɨ tɨbarɨyagaala wɨdadaaꞌmujɨ dava dalamwaalyɨla!” ");
INSERT INTO byr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pitalyɨ Jemɨzalyɨ Jonɨjɨ saraavɨ pɨbanna makuna yaka lɨka kyaꞌ gamɨre kale dusɨna gɨnyɨwannaꞌna kyaꞌ ");
INSERT INTO byr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","kumɨnyɨ wɨdɨna “Nɨmɨre kale dusɨna nyɨgɨnyɨwannaꞌmwakeꞌ balɨdeinyɨ dɨngaka? Dava mwaalapɨjɨ dɨvaihanaryi!” ");
INSERT INTO byr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Sara wɨdɨna yaka sangirɨꞌna wawaka kwaakevɨna walaꞌna yaka tɨbarɨyagaala wɨdɨna “Daanga nyɨvɨnadehaaꞌna gɨthɨwa. Nɨmɨnyɨna ‘Daanga mavɨnannera!’ dɨzaꞌ daanga nyɨvɨnyaꞌneꞌ myɨmaꞌnyɨ yana! ");
INSERT INTO byr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tataai, Nɨmwai, dɨragɨnaangeigɨ, yuya nayaa yɨnneigɨnyɨra. ‘Daanga nuvɨnadɨka! Sabwi marasɨꞌnɨma!’ dɨzaꞌ dɨmarasɨꞌna! Kɨrɨꞌ sɨmunya nɨmɨreburɨdaasɨ minnera! Aawa. Gɨnnyaburɨdaasɨ ja!” ");
INSERT INTO byr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ayɨna baka dara wanganakeꞌ “Se dakava!” Daka Pitarɨ wɨdɨna “Saaimonɨ, se dakɨ? Maalɨkegaaꞌ mabaihanarijɨwaa? ");
INSERT INTO byr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sarɨmɨ tɨbarɨyagaala dɨthavaihanarila! ‘Saataanɨ kayaaꞌna naneyadɨka!’ majaihi ‘Nemɨ nayaa baihanaraana!’ kuryaraavɨ yawɨꞌmanɨgaꞌ. Sarɨmɨre kɨlaakejɨkɨ maaꞌna naanga yɨhimanɨkeꞌna se waꞌmwaaꞌ.” ");
INSERT INTO byr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Sara wɨdaka ayɨna wawaka tɨbarɨyagaala wɨdakeꞌ ayawɨdaasɨ wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Miꞌna wɨdɨna yaka ayɨna baka dara wanganakeꞌ “Se dakava!” Sareꞌ dareꞌnesɨ. Kumɨre tɨnnya seꞌna yɨdaakweꞌ. Sara kadaꞌ kumɨ dɨna “Nemɨ berɨꞌ wɨdaazɨwona?” deva navɨka mwaalɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Dahasaai dahaaꞌ yagalaawaka wɨdɨna “Kwazaaka se waꞌmanɨgasaihi daaka? Miꞌnanyɨra. Yɨthaanyi, dahaaꞌ kyɨmaꞌnɨwaꞌ Aꞌmweraavɨne Kaimɨraayainyɨ tamakyaꞌna pwai kayaaꞌnanyaraavɨ malyaꞌneraavɨ mena wibwarɨdaakuwaka! ");
INSERT INTO byr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Dɨthaayɨla! Nemɨ wɨrataꞌnaana! Yɨthaanyi, nɨmɨnyɨna yɨkamaangeraavɨ wibwarɨdaakwakei yɨnɨꞌ.” ");
INSERT INTO byr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sagaaꞌ wɨdadaaꞌnyɨ yɨmeꞌnyaꞌbɨꞌ Juthaazai aꞌmwe atɨraai sɨvɨlyɨrɨdaasɨ pwaraalyarajɨya pwai bɨna. Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ Juyaraavɨre Kɨwɨjarajɨ Juya naangerajɨ sara wɨdaasɨna kyeꞌ kwala naanga mwaalevera kwaariꞌmasɨramɨnya, kɨlɨyɨꞌgwahaalya lɨmwanna yevera Juthaazalyɨ bɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sɨnnawɨ sagaaꞌ yɨkamaangeraavɨ wibwarɨdaakwakei wɨjɨwaakakei “Nɨmɨ yɨlaaya mariwɨjai sahwalyɨ. Nayaa lɨmwagapɨjɨ nayaa baihanaꞌdɨvɨꞌ dɨmakwila!” ");
INSERT INTO byr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sara wɨjɨwaakakei baka yɨmeꞌnyaꞌbɨꞌ gamɨnyawɨnna wɨjɨmaatavaka wɨdɨna “Naangeigɨ!” Tɨviꞌna wɨdaka yɨlaaya marina yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yɨlaaya marina kyaꞌ aawɨlasara ata galalɨmwanna yeva wɨla yɨrɨna. ");
INSERT INTO byr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wɨla yɨrɨna kyeꞌ daavesarajɨya Jizaazarei akwai, kwaariꞌmasɨramɨnyaꞌ maaraka sipɨzipɨya Gotɨyarɨna Yɨraꞌde Naangere yaasɨwaꞌwawɨnyarɨ yɨrɨꞌgainyɨna yaka gamɨre kadɨkikɨ lihɨwɨꞌna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sara kyaꞌ Jizaazai malyaꞌneraavɨ wɨdɨna “Kuka yɨpalamaaꞌdɨnyainyɨ daaka! Kwaariꞌmasɨramɨnyajɨ kɨlɨyɨꞌgwahaalyajɨ lɨmwanna yeva ‘Yɨpalamaaꞌdeibɨsarɨ wɨla yɨraana!’ deva davɨvanɨgaꞌ! ");
INSERT INTO byr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gazagaasagaaꞌ yɨrɨkeryaavɨ Gotɨyare Angevɨ sarɨmɨjɨ mwaaidɨ yɨhɨzɨwaakadɨnyagaaꞌ wɨla manyɨryadɨvɨsaihɨlyɨ. Aawa. Saꞌna kɨgaakuna Gotɨyai dɨnɨkeꞌ yuneꞌna yɨmaꞌnana!” ");
INSERT INTO byr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tɨviꞌna wɨdɨna kyaꞌ gamɨrera yagalyaꞌmaꞌna yeva lɨkaanya wɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mɨgɨnya akwai kwaabɨhannya pɨrɨꞌna yewaaꞌbwaꞌnakei mɨdɨnna kyaꞌ pwara kwaabɨhannyaꞌ galamwagiꞌnyɨna kyeꞌ ");
INSERT INTO byr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kamagaduyɨvaleꞌ kannyɨmaayai kaanyaveꞌna wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jizaazarɨ Gotɨyarɨna Yɨraꞌde Naangeryawɨnna makuna yadaapɨjɨ Gotɨyarɨna yɨraꞌdɨvɨta naangerajɨ Juya naangerajɨ Juyaraavɨre Kɨwɨjarajɨ yɨꞌbwaꞌnɨgavɨna. ");
INSERT INTO byr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yɨꞌbwaꞌnɨgavɨna yadaapi Pitai menyaba mɨdɨnaawɨna yaka Gotɨyarɨna Yɨraꞌde Naangere angwaasavɨ wɨna kyaꞌ damerari mwaaleva dɨka yimwannyɨna. ");
INSERT INTO byr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Dɨka yɨmwannyɨna yadaapi Gotɨyarɨna Yɨraꞌdɨvɨta naangerajɨ kaajolɨya yuyarari sara dɨnyɨna “Nemɨ tamakaadeꞌna aꞌmwera dɨna ‘Jizaazai kayaaꞌna yakevɨ wanganena,’ dɨpɨꞌdera gawɨ mwaaihava?” Dɨnyɨna kyeꞌ kɨrɨꞌ aꞌmwe sahwara mamwaalyɨna. ");
INSERT INTO byr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sareꞌ dareꞌnesɨ. Aꞌmwe pɨjaakuna gamɨnyɨna kwaasɨ yagaala jalɨkurakesaꞌ kɨrɨꞌ kumɨre yagaala avaainanyaꞌ majasɨ. ");
INSERT INTO byr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pwara daavɨna yeva kwaasɨ yagaala dara wɨjalɨkurakɨna ");
INSERT INTO byr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Gamɨ dakeꞌ nemɨ wɨꞌno. Dara daꞌ ‘Gotɨyare anga daꞌ aꞌmwera yavɨkaryaasaꞌ kayaaka yɨgalaꞌmujɨ yɨrɨka daryaai darɨkɨ anga pɨrɨꞌ aꞌmwera mamajɨ yɨpɨꞌdeꞌ madɨdeinyɨra,’ sara wɨꞌno.” ");
INSERT INTO byr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Sare kɨrɨꞌ kumɨre yagaala geꞌ geꞌ dɨna yesaꞌ avaainanyaꞌ mɨka. ");
INSERT INTO byr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Gotɨyarɨna Yɨraꞌde Naangei tɨnnyaba daavaka Jizaazarɨ yɨwaaraꞌna “Yagaala pɨrɨꞌ mamaꞌmaaꞌdɨnneigɨ daaka? Aꞌmwe dara jalɨkurakya aane pɨbwi kɨbwi mamaꞌmaarijɨwaana?” ");
INSERT INTO byr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sara yɨwaaraꞌna kyaꞌ sahwai yagaala majai aane pɨrɨꞌ kɨrɨꞌ marɨvɨkɨri yaꞌ. Pɨgasaai Sipɨzipɨya Gotɨyarɨna Yɨraꞌde Naangei yɨwaaraꞌna “Kɨraazɨtɨyaigɨ daaka? Gotɨyai tewaanaanga yɨnɨkere kaimɨraayaigɨ daaka?” ");
INSERT INTO byr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sara yɨwaaraꞌna kyaꞌ Jizaazai wɨdɨna “Sahwainyɨra. Aꞌmweraavɨne Kaimɨraayai Gotɨyai dɨragɨnnakere aangasɨmagɨ kamwaalojɨ Gotɨyalyɨ maremwaalyɨkaderaarɨ danganyidelyɨra. Nabaai yɨraaya sɨgunyavɨ waꞌdengɨ gamɨ walaabathelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Miꞌna wɨdɨna kyaꞌ Gotɨyarɨna Yɨraꞌde Naangerɨ sɨnna tɨka kudavaꞌ baazɨꞌmaꞌnyaꞌ maralihɨvainyɨna yaka yuyaraavɨ wɨdɨna “Nemɨ tɨviꞌna wɨꞌnɨwoꞌ gamɨnyɨna yagaala jalɨkurakyaꞌne pwaraavɨna nemudaasɨwakeina daaka! ");
INSERT INTO byr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gotɨyarɨna yagaaibɨraizɨka dɨwakeꞌ sarɨmɨ miꞌna wɨꞌnɨwaava. Berɨꞌ dɨzijɨwaaꞌ?” Sara wɨdɨna kyaꞌ yuyara jɨdaꞌna “Kayaaꞌnanyabwi yɨwakeꞌna balana!” ");
INSERT INTO byr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pwara gamɨnyɨ maagwala wopwakɨna yeva gamɨre sɨnnyavɨ bwakakɨna yeva asɨlyɨ gwamwagaranna yeva wɨdɨna “Gotɨyarɨ wɨꞌnaꞌgɨzɨ dɨnejɨwaakya! ‘Aai gɨramwaka?’ ” Miꞌna wɨdɨna kyeꞌ damera gamɨnyɨ araraalyajɨ tamamakuna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kwaakeba angwaasaba Pitai mwaaidɨꞌnyɨ Gotɨyarɨna Yɨraꞌde Naangere wawɨnya wɨdaayadeꞌ baka ");
INSERT INTO byr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pitai dɨka yimwannakerɨ tɨnna wanganaka baihanaꞌna yaꞌ. Baihanaꞌna yaka wɨdɨna “Gɨmɨjɨ Naazaretɨ mwaalyai Jizaazaryaba mwaaidɨnyaigɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Saꞌ wɨdɨna kyaꞌ Pitai “Nanyɨrabɨka!” daka kwaasɨ wɨdɨna “Arɨkawɨnyɨ. Gɨmɨ nyɨdɨwaanyaꞌ myawɨryadɨnyainyɨra.” Miꞌna wɨdaka adɨkurya savɨna mwalaawɨna. ");
INSERT INTO byr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mwalaawɨna kyaꞌ wɨdaayadeꞌ wanganaka aꞌmwe yaasɨwaꞌmwaalyaraavɨ ayahi wɨdɨna “Aꞌmwe dai kumɨjɨyalyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pitai nabaai wɨdɨna “Arɨkawɨnyɨ.” Dɨvi sagaaꞌ kɨbawegaaꞌ aꞌmwe yaasɨwaꞌmwaalyara Pitarɨ ayahi wɨdɨna “Nebulyaꞌna gɨthɨwaka. Kumɨjɨyaigɨnyɨ. Sareꞌ dareꞌnesɨ. Galɨli mwaalyaigɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sara wɨdɨna kyeꞌ yagaala dɨragɨnya wɨdɨna “(Daaina!) Gotɨyaryaba nebulyaꞌnanyasɨra. Kwaasɨyaꞌna mɨka! Sarɨmɨ dɨwaata aꞌmwe sarɨ mwanganyadɨnyainyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Miꞌna wɨdɨna kyaꞌ yɨmeꞌnyaꞌbɨꞌ kukuraayai yarai pɨgasaai dɨna yaꞌ. Dɨna kyaꞌ Pitai yawɨꞌna yaꞌ “Jizaazai sara nyɨdɨwaꞌ ‘Kukuraayai pɨgasaai jaka majɨ kyojɨ nɨmɨnyɨna dahasaai dahaaꞌ julyakɨdeigɨnyɨ.’ ” Pitai sara yawɨraka “ ‘Jizaazareinyɨ mɨka,’ beꞌna wɨdɨweinyaka!” kale kwiaꞌ kɨnna bazɨwɨlaawɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mwanyagaaꞌ yɨrɨkeꞌ gaai puꞌdaaꞌnyɨ yɨmeꞌnyaꞌbɨꞌ Gotɨyarɨne tamiraꞌdɨvɨsarajɨ aꞌmwe naangerajɨ Juyaraavɨre Kɨwɨjarajɨ kaajolɨya pwarajɨ sara gamɨnyɨna jamungajɨna. Miꞌna jamungajɨna yeva Jizaazarɨ wɨla pwɨyɨna, Gaꞌmaanɨyai Kwaaka Juthɨya maremwaaide Paailatɨmyawɨnna makuna yeva sarɨ marɨmwaaihɨna. ");
INSERT INTO byr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Marɨmwaaihɨna kyeꞌ Paailatɨ gamɨnyɨ yɨwaaraꞌna “Juyaraavɨ maremwaaidɨnyaigɨ kingɨyaigɨ daaka?” Yɨwaaraꞌna kyaꞌ Jizaazai wɨdɨna “Gɨmɨ nyɨdɨwaanyaꞌ nebulyasɨ.” ");
INSERT INTO byr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sara wɨdɨna kyaꞌ Gotɨyarɨna yɨraꞌdɨvɨta naangera “Gamɨre kayaaꞌna yade sanna Paailatɨmɨ wɨjɨwakaana!” deva kwaasɨ yagaala kwalaalya wɨjɨwaakɨna. ");
INSERT INTO byr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Miꞌna wɨjɨwaakɨna kyeꞌ Paailatɨ ayɨna yɨwaaraꞌna “Tɨvɨkɨta pɨrɨꞌ kɨrɨꞌ jaꞌnadɨna jɨtheigɨ midaaka? Yɨthaa, gɨmɨnyɨna kayaaꞌnanya kwalaalya nyɨjɨwakɨwaasange!” ");
INSERT INTO byr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yɨwaaraꞌna kyaꞌ Jizaazai yagaala aane pɨrɨꞌ kɨrɨꞌ majai mwaalakeꞌna Paailatɨ atɨka maruꞌnaꞌna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kwazaaka naanga munne yanyagaaꞌ yuyagaaꞌ Juyara Paailatɨmɨ wɨdadɨvɨsare “Ayabaaibɨꞌ kalavuzarɨ yunakaanya duthaasa!” Sara dɨnɨkeꞌna Paailatɨ sara yakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sagaaꞌ aꞌmwera kwaakevakɨ maremwaaidɨvɨsaraavɨ mala bwaꞌdaaveva aꞌmweraavɨ karamakeꞌ naangera kalavuzangevɨ wɨmwaaihɨna. Kalavuzangevɨ wɨmwaaiheta pwai Baaravaazai woꞌnɨkei mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mwaalɨna kyaꞌ kwala naangeꞌ beva Paailatɨmɨ gaai wɨdɨna “Dahaaꞌna nemɨnyɨna ayɨna yɨyabwi yagɨnyaꞌ sara ja!” ");
INSERT INTO byr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Wɨdɨna kyeꞌ Paailatɨ wɨdɨna “Aꞌmweihi, Juyaraavɨ maremwaaiderɨ wɨla yaarɨjɨwa?” ");
INSERT INTO byr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sareꞌ dareꞌnesɨ. Paailatɨ dara yawɨrakelyɨ “Aꞌmwe kwalaalyara Jizaazarɨ yɨlaaya wɨmariwaasaꞌnanyɨ. Gotɨyarɨna yɨraꞌdɨvɨta naangera tɨganaarya yadɨvɨꞌ kotɨyavɨ marɨwɨmwaaihɨna yɨwaava.” ");
INSERT INTO byr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Miꞌna wɨdɨna kyaꞌ Gotɨyarɨna yɨraꞌdɨvɨta naangera kwala naangevɨ wɨjɨwɨrina “ ‘Jizaazai waramaryana! Aꞌmwe Baravaazarɨ nejaavana!’ yarai duzɨla!” Sara wɨjɨwaakɨna kyeꞌ sara yɨna. ");
INSERT INTO byr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Miꞌna yɨna kyeꞌ Paailatɨ jaꞌnawɨdɨna “Nyɨdɨwaasaꞌna ‘Aꞌmwe sai Juyaraavɨ maremwaaidela,’ dadɨvɨsarɨna gara yɨjɨwa?” ");
INSERT INTO byr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wɨdɨna kyaꞌ ayɨna jaka danganna “Yɨsavɨri tamakyaꞌna nilɨya dɨramo!” ");
INSERT INTO byr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Baaꞌnevaka? Be kayaaꞌnanya yɨwakalaka?” Saꞌna wɨdɨna kyaꞌ kwala bwaꞌnaanyaꞌ jaka naanga danganna “Tamakyaꞌna yɨsavɨri nilɨya dɨramo!” ");
INSERT INTO byr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Sara danganna kyeꞌ Paailatɨ “Kwala bwaꞌnaanya nɨmɨnyɨna yɨlaaya yɨpɨka!” daka Baravaazarɨ wɨla yaaraka dameraavɨ wɨdɨna “Jizaazarɨ wɨla nilɨnakebaalyɨ tamapɨjɨ yɨsavɨ nilɨya jeramyɨla!” ");
INSERT INTO byr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kwaaka Juthɨya maremwaaide angwaata Pɨraitorɨyamɨ (kotɨ angeꞌ) woꞌnɨkewɨnna damera Jizaazarɨ jɨvwaramakwaweva aawɨlata yuya pwaraavɨ jaka jɨvwaramaaꞌna. ");
INSERT INTO byr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jaka jɨvwaramaaꞌna kyeꞌ yuyara yɨkabeva “Jizaazai kwaasɨkingɨyai yɨmaꞌnana! Bɨrala yaana!” deva kingɨyɨvɨta wayaakeꞌ egwevɨ marajɨkɨreva wɨla lannakesɨ gɨhɨpaleva gamɨre mɨnyagɨnyavɨ maramwaaihɨꞌna. ");
INSERT INTO byr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Maramwaaihɨꞌna yeva bɨralyaꞌna wɨdɨna “Naangeigɨ, Juyaraavɨ maremwaaidɨnyaigɨ yuyagaaꞌ dɨmwaaideigɨne!” ");
INSERT INTO byr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sara wɨdɨna yeva yɨsarɨsɨ mɨnyagɨnyavɨ tamɨna yeva gamɨnyɨ maagwala wopwakɨna yeva “Naangelyɨra,” kwaasɨyaꞌ deva kwadaai gɨleꞌ. ");
INSERT INTO byr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bɨralyaꞌ sara yɨna yeva yɨvɨta wayaakeꞌ mararaakurasɨꞌneva gamɨre baazɨꞌmaꞌnyaꞌ marajɨkɨreva “Yɨsavɨ nilɨya wɨramaana!” deva jɨvwaramakuna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tusavɨ Saaimonɨ Anga Saairini mwaalyai, Alekɨzaadalyɨ Rupaazalyɨ saraarɨ kɨrɨnɨmaangei wawɨnyabadaaꞌnyai Jeruzaalemɨnei wɨrataꞌnyɨna yeva aawɨlasara naanga wɨdɨna “Aꞌmwe sare yɨsaꞌ dɨmakɨlaawa!” Miꞌna naanga wɨdɨna kyeꞌ Saaimonɨ yɨsaꞌ makɨlaawɨna. ");
INSERT INTO byr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Makɨlaawɨna yadaaꞌnyɨ Mugunya Golɨhotabanna Jizaazarɨ wɨjɨvwaramakuna. Golɨhota “Gɨlemɨnyagɨnyabanna,” dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Saba “Daanga naanga nuvɨnadɨka!” deva aalya waainɨyavɨ kɨwata mɨrɨya woꞌnɨke yɨkeva “Daꞌ dɨnana!” wɨdɨna kyeꞌ “Aala!” wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","“Aala!” wɨdɨna kyaꞌ aawɨlasara Jizaazarɨ maareva yɨsavɨ nilɨya wɨrameva “Gamɨre yɨvɨta baazɨꞌmaꞌnya saza japalaana! Saatuya yawaajɨ ata gɨlyavɨ wanganawaajɨ japalamakwawaana!” deva saatuya yeva gamɨre baazɨꞌmaꞌnya jaapaina. ");
INSERT INTO byr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sagaaꞌ yɨsavɨ nilɨya wɨramesagaaꞌ mwanyavɨ naainɨ kɨlokɨyagaakɨra. ");
INSERT INTO byr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tamakyaꞌne pɨkarya “Kingɨyai Juyaraavɨre maremwaaidei,” yɨdaveva yɨsavɨ munyaba yɨlakɨna. ");
INSERT INTO byr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yɨlakɨna yeva gamɨre aangasɨmagɨ aꞌmwe pwarɨ kwanaamimagɨ pwarɨ nilɨya wɨrameꞌ kuka yɨpalamaaꞌdisaraarɨ. ");
INSERT INTO byr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Saꞌna wɨramɨna kyeꞌ sagaaꞌ Gotɨyare bukuyaꞌ dɨnɨkeꞌ yuneba yɨmaꞌnaꞌ. Yagaala saꞌ “Kayaaꞌnanyaraavɨ sara yɨpɨꞌdeꞌ gamɨnyɨjɨ sara yɨpɨꞌdelyɨra,” dɨnɨkesɨra. ");
INSERT INTO byr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aꞌmwe aꞌmwera wavɨlavesa kunnya mɨnyagɨnyara wɨnaangɨꞌnyɨ wɨnaangɨꞌnya yadaapi bɨrala dara wina. “Aꞌa! ‘Gotɨyare Angevɨ kayaaka yɨgalaꞌmwi yɨrɨka dawaai dasangɨ mamwɨneinyɨ,’ nedahɨnyaigɨ, ");
INSERT INTO byr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","sahwaigɨ gɨmɨ saigɨ gaimwannaꞌgɨzɨ nilɨya lawasɨꞌnaꞌgɨzɨ yɨsavɨdaaꞌnyɨ dalaama! Dɨvadaihasamaaꞌnana!” ");
INSERT INTO byr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sara bɨrala wɨdɨna kyeꞌ nabaai sabaaibɨꞌ Gotɨyarɨna yɨraꞌdɨvɨta naangera Juya yagaaikɨwɨjarajɨ Jizaazarɨna bɨrala dɨneꞌ “Pwaraavɨna dɨragɨnna padaihasamaarakele! Gamɨ sahwai padaihasamaaꞌnannele! ");
INSERT INTO byr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kɨraazɨtɨyai Yɨzɨrelɨyaraavɨ maremwaaidei kingɨyai yɨsavɨdaasɨ kwalaabozɨ wanganawaajɨ gamɨnyɨ nayaa lɨmwagaraadeꞌnanyɨ.” Bɨrala sara dɨnyɨna kyeꞌ gamɨnyawɨ pwaraai nilɨya wɨramesaraai bɨrala wɨdɨna yagi. ");
INSERT INTO byr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sɨrɨgwajahaaꞌ kyɨmaꞌnaꞌ kwaakevaꞌ yuyavaꞌ yɨrɨka kɨgaaꞌ jɨhɨnyaꞌ jɨnnaka tɨri kɨlokɨyagaaꞌ jɨhɨnyaꞌ miꞌna jɨnnakegaaꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sagaaꞌ tɨri kɨlokɨyagaaꞌ Jizaazai jaka naanga gannya yagaalyaꞌ danganna “Eloi, Eloi lama savakɨtaani.” Yagaala saꞌ aangyagaala “Nɨmɨre Gotɨyaigɨ, nɨmɨre Gotɨyaigɨ beꞌna nyagalyaꞌmaꞌmwaana?” ");
INSERT INTO byr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jaka sara danganna kyaꞌ saba daaveta pwara wɨꞌneva dɨnyɨna “Yɨthaanyi, Yɨlaajarɨ jaka wɨdɨwaka.” ");
INSERT INTO byr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dɨnyɨna kyeꞌ pɨbanna pwai kaanyaveꞌna wawaka aalya waainɨya yɨrɨkevɨ saalaalyavɨya jɨꞌmɨnyaꞌ marapaihaka aalɨnakeꞌ yɨsarɨkɨre sɨnnyarɨkɨ wakaka “Aalyaꞌ nana! Pɨzɨꞌgwa mwaalana!” daka makɨlaawaka pwaraavɨ wɨdɨna “Kavaayɨla! Yɨlaajai bozɨ yɨsavɨdaasɨ makwalaabazaꞌ wanganaadera.” ");
INSERT INTO byr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Wɨdɨna kyaꞌ Jizaazai jaka naangeꞌ wɨdaka sɨmudɨnya yɨnahu yekɨꞌna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Gotɨyai Gotɨyare Angevɨ janne naangeꞌ jɨkɨꞌnɨkeꞌ munyabadaasɨ kwaakewɨnna kayaaka daburaꞌ yuneba. ");
INSERT INTO byr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jizaazarɨ nilɨya tameta yɨsavɨ aawɨlata naangei Anga Romɨ mwaalyai maredaavakei dara wanganakeꞌ “Sara davaimwaka!” Daka wɨdɨna “Nebulyasɨra. Aꞌmwe dai Gotɨyarɨ gawaalɨvaangelyɨra.” ");
INSERT INTO byr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wɨdadaaꞌnyɨ keiba aꞌmwe daaveva tɨnna wanganna. Aꞌmwe sa, Maarɨyaaꞌ Maahɨthaala mwaalyasɨ Maarɨyaaꞌ Jemɨzai dɨviyalyɨ Jozɨzalyɨ kɨdaraarɨ kɨrɨnaangesɨ Saalomiyasɨ sa ");
INSERT INTO byr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jizaazai Kwaaka Galɨli mwaalakegaaꞌ kaanya yeꞌmwannayamaryeva wapaaya aalya wɨjaavesajɨ aꞌmwe pɨnɨjɨ Jizaazalyɨ Anga Jeruzaalemɨna yɨlaabeta aꞌmwe pɨnɨjɨ sangyɨneba mwaalɨna yeva tɨnna wanganna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sawɨsaburɨ kyɨmaꞌnaꞌ Jozepɨyai Aarɨmathɨya mwaalyai bɨna. ");
INSERT INTO byr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Bɨna yakei aꞌmwe tewaanyai Kaajolɨyai sagaaꞌ Gotɨyai Kwaaka yuyavakɨ maremwaaidehaaꞌna kave yemwaalakelyɨ. Jizaazai balakegaaꞌ Pɨraaidehaaꞌ Jozepɨyai “Kwazaakegaaꞌ gɨlaayai enana narɨbainadɨka!” daka Juyaraavɨre Kwazaakegaaꞌ yovɨraꞌdaapiyagaaꞌna dɨragɨnna yɨvaimwanna yaka Paailatɨmyawɨnna baka Jizaazare kɨlaakejɨkɨna wɨdɨna “Gɨlaayai walyamarirakɨma! Nyɨmaryaama!” ");
INSERT INTO byr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sara wɨdɨna kyaꞌ Paailatɨ maruꞌnaꞌna “Ai, dahaaꞌ miꞌna davalɨka?” daka aawɨlata naangerɨna jɨvwaramaaꞌna. Sara jɨvwaramaaꞌna kyaꞌ naangei kulaabaꞌ yɨdaanganna “Jizaazai mena baimwakei daaꞌ?” ");
INSERT INTO byr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yɨdaanganna kyaꞌ sai “Yo. Mena baimwaꞌ,” wɨdɨna kyaꞌ Jozepɨyarɨ wɨdɨna “Wikɨra. Gɨlaayarɨ dulamaraawa!” ");
INSERT INTO byr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sara wɨdɨna kyaꞌ Jozepɨyai wawaka kwaabɨyɨvɨta saamɨnya yaakeꞌ mubyawalyaadɨkei yɨsayabanna baka gamɨnyɨ makwalaabaka yaakesɨ yewaꞌmwagapwɨyaka makulaawaka kaviꞌnɨnnyavɨ simaangevɨ lɨlɨvɨdaakunɨkevɨ wɨlakaka sɨla naangei simaangevɨ tihɨrakɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jozepɨyai sara yadaaꞌnyɨ Maarɨyaaꞌ Maahɨthaala mwaalyasɨ Maarɨyaaꞌ Jozɨzarɨ ganaangesɨ gamɨre wakyaꞌneba tɨnna wanganna yagi. ");
INSERT INTO byr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kwazaakegaaꞌ miꞌna kwavɨlavaꞌ Maarɨyaaꞌ Maahɨthaala mwaalyasɨ Maarɨyaaꞌ Jemɨzarɨ ganaangesɨ Saalomiyasɨ sa “Nemɨ Jizaazare kɨlaakejɨkɨ puraana!” deva marazɨnanya wabatɨrɨnnakeꞌ mubɨna. ");
INSERT INTO byr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mena mubɨna kyeꞌ Saadehaaꞌ mwanyavɨ yɨrɨkeꞌ gaai puꞌdaaꞌnyɨyagaaꞌ simaangevɨne aꞌmwe kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kaanna kuna wɨna yesa dɨnyɨna “Sɨlaangei kaviꞌnɨmaangevɨ warɨkerɨ nemɨnyɨna aai baasadelaka?” ");
INSERT INTO byr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sara dɨneva maranganna yadɨvɨꞌ dara wanganesaꞌ “Ai, sɨlyai mena davaasɨnɨka!” Sareꞌ dareꞌnesɨ. Sɨla sai wapemɨnnakei warakelyɨ. ");
INSERT INTO byr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Miꞌna deva simaangevɨ wɨlaawɨna yeva kumɨnyɨ aangasɨmagɨ mɨgɨnyai kwaabɨhannya yaaka nawɨꞌnyaꞌ yɨraꞌnakerɨ tɨnna wanganna. Tɨnna wanganna yeva lɨka yɨna yeva atɨka maruꞌnaꞌna. ");
INSERT INTO byr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Atɨka maruꞌnaꞌna yadaapi mɨgɨnyai wɨdɨna “Lɨka mipɨnera! Jizaazai Naazaretɨ mwaalyarɨ yɨsavɨri nilɨya wɨramwaꞌdaasarɨna bɨꞌmanɨgava. Sara yawɨꞌmwa. Kyɨdɨkaaꞌmwaꞌ dava mamwaalyɨka. Yɨthaanyi! Wakɨwaꞌdaasaba danganyɨla! ");
INSERT INTO byr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sare kɨrɨꞌ wawopɨri gamɨrerajɨ Pitalyɨ saraavɨ duthaawila! ‘Sɨnnawɨ Kwaaka Galɨli kwaanaꞌmujɨ sarɨmɨ nyɨmɨdɨnaabyidera! Miꞌna yɨhɨthevaaibɨꞌ saba dɨnyanganyideinyɨra,’ sahwai sara nyɨdɨwaꞌ.” ");
INSERT INTO byr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Sara wɨdɨna kyaꞌ simaangeyabadaaꞌnya kaanyaveꞌna walyaweva lɨkaanya wɨna. Sareꞌ dareꞌnesɨ. Bɨꞌbɨta yadɨvɨꞌ lɨka yeva sɨmunya nayaa myawɨri. Lɨkaanya wɨna yeva aane pwarɨ kwarɨ aane pɨrɨvɨ kɨrɨvɨ mujɨ yeꞌ. Sareꞌ dareꞌnesɨ. Lɨka naanga wiakeꞌna sahɨnɨ kunna marinaawɨna yesangɨ. ");
INSERT INTO byr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Saadehaaꞌ yɨrɨkunyagaaꞌ Jizaazai dɨkaavaka sɨnnawɨ Maarɨyaaꞌ Maahɨthaala mwaalyavɨdaasɨ yɨmaka ati ata purɨdaaꞌnyɨ pwaraalyaraavɨ marasɨꞌnakevɨ gamɨnyɨna wɨjɨwaainaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Wɨjɨwaainakegaaꞌ aꞌmwe saꞌ wawaka gamɨjɨyara yɨkwaraamaya dadaapiyaraavɨ buthɨna “Jizaazai kwaihwaainakei mwaaidɨꞌnyɨ wangamwerɨnera.” ");
INSERT INTO byr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sara kadɨka wɨꞌneva “Kwaasɨ yagaala nedɨwaka,” dɨnyɨna yeva saꞌna malɨmwagi yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Sara yɨna yesagaaꞌdaasɨ aꞌmweraai wawɨnyanneba kaanya kyamaryagi sahwai mudɨkeibɨsai wɨlaabaka pɨgasaai wɨjɨwaainaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","“Jizaazalyɨ,” sara yawɨragɨla ayɨna wawagɨla gamɨre pwaraavɨ wɨdɨna kyagi sahwaraare yagaalyaꞌna “Kwaasɨyaꞌ,” dɨnyɨna yeva saꞌna malɨmwagi yeꞌ. ");
INSERT INTO byr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Dɨvidaaꞌnyɨ angevɨ gamɨrera atɨraai yaka sɨvɨlyɨrɨdaasɨ pwaina sarera wapaaya tɨka nadaapi sahwai wɨlaabaka gamɨ mena dɨkaavakerɨ pwara tɨnna wanganeva gamɨre pwaraavɨ wɨdesaꞌ malɨmwagyesaꞌnajɨ sɨmunya myawɨryesaꞌnajɨ maanga wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Maanga miꞌna wɨdaka wɨdɨna “Yuyabanna Kwaaka yuyavakɨna wawopɨjɨ yagaala tewaanyaꞌ Gotɨyai wakyaaka yuyaraavɨ duzɨwaakyideihɨlyɨra. ");
INSERT INTO byr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Savɨneꞌna pwai kanyɨlɨmwagarojɨ aalyavɨ bavɨtaazɨya kyapi Gotɨyai kayaaꞌnanya marasɨꞌnada padaihasamaaradelyɨ. Aꞌmwe pwai manyɨlɨmwagaryojɨ gannya kayaaꞌnanya yɨnahu waragothengɨra. Sahwarɨ jɨdavadelyɨ. ");
INSERT INTO byr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aꞌmwera kanyɨlɨmwagarapi wɨjɨwaainya dara yɨmaꞌnade. Nɨmɨre dɨragɨnyaꞌ maarapɨjɨ nɨmɨnyɨne yayavɨ yɨmakeraavɨ aꞌmweraavɨre munyɨkaavɨdaasɨ wɨdaasɨpɨꞌde. Nabaai Maaveraavɨre yagaala wɨdɨpɨꞌde. ");
INSERT INTO byr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Naawɨnaanyarɨ maarapɨjɨ aalya nabaidɨvɨsaꞌ napɨjɨ mabalyɨ yɨpɨꞌde. Arɨkawɨnyɨra. Nabalɨnakengɨre mɨnyagɨnyangɨ ata kadathɨwagapɨjɨ nabalɨnake tewaanya mwaaibɨꞌde. Sara yɨmaꞌnɨpɨꞌdengɨra,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sarevɨdaaꞌnyɨ miꞌna wɨdɨna yakegaaꞌ Gotɨyai Naanga Jizaazarɨ makɨlaawɨna. Sara makɨlaawɨna kyaꞌ Gotɨyareba Sɨgunyavɨna Jizaazai yɨlaawaka Gotɨyare aangasɨmagɨ walamwaaina. ");
INSERT INTO byr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Miꞌna walamwaaina kyaꞌ gamɨrera waweva yuyaba wɨjɨwakadaapɨjɨ Naangei wɨgaimwagaꞌ. Kugaimwagaꞌ gamɨjɨ nawɨꞌnya kyeꞌ aꞌmwera tɨnna wanganyaꞌnera dara wɨjaꞌna “Yagaala saꞌ Gotɨyaresɨra,” sahwai wɨjɨwaainya yaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Aꞌmwe naanga Tɨyopɨlaazaigɨ, yagaala davɨ duꞌnana! Kɨgaaꞌ aꞌmwe kwalaalyara Kɨraazɨtɨyarɨna nayaa yɨdavesaꞌ nemɨnyawɨ Gotɨyai sara yakeꞌna yɨdavesasɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Sɨnnawɨ sagaaꞌ aꞌmwe pwara yuya sa tɨnna nayaa wangadɨvɨꞌ nayaa jalɨkuraketabaaibɨta yɨdaveꞌ. Aꞌmwe kwaraavɨre tɨnnyasɨ wanganɨkeraavɨ mɨdɨdɨvɨꞌ yɨdaveꞌ. Aꞌmwe sara Gotɨyare yagaalyasɨyara sahwaraavɨre maangikɨ mɨdɨneꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tɨyopilaazaigɨ, dɨragɨnyaigɨ, nɨmɨ sara yɨdavesavɨjɨ sara nyɨdesavɨjɨ yawɨramaarena Naangerɨne yagaala aaya kaavɨlyangɨ sabura bɨramaarena “Sareꞌna yavɨkarideꞌna tewaanyasɨ,” yawɨrena yagaala da yavɨkarivanɨgeinyɨ. Sɨnnawɨnyasɨ tɨnnyabanyasɨ dɨviyasɨ yagaala yuya sa yavadaꞌgalakena gɨmɨnyɨne nayaa yavɨkarivanɨge. ");
INSERT INTO byr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Savɨdaaꞌnyɨ tɨnna wanganaꞌgɨzɨ jawɨka! “Yagaala saꞌ nɨmɨ kadɨka miꞌna wɨꞌneꞌ naanga nebulyaꞌna yawɨramaarɨma!” daꞌgi jawɨka! Sareꞌna gyavɨkarivanɨge. ");
INSERT INTO byr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Naanga Erotɨyai Kwaaka Juthɨya maremwaalakelyɨyagaaꞌ Sekaraayai mwaalɨna. Sai Gotɨyarɨna mubɨthɨka yɨraꞌdelyɨ pɨrizɨyai sahwai. Gamɨjɨyara pɨrizɨyara yɨta pɨvaakɨya Avaazarera. Nabaai gamɨre balaangeꞌ Yɨlɨzavetɨyaꞌ Eronɨmɨ yɨsavaakɨdaasasɨ kɨrɨsɨ. Eronɨ sai Gotɨyarɨna Yɨraꞌde Naangei aaya sɨnnawɨnyalyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sayorɨna Gotɨyai yawɨꞌna “Tewaanna mwaaidisawaalyɨ. Nɨmɨre kɨwɨnyajɨ yagaalyajɨ nayaa mɨdɨdisawaai,” yawɨꞌna yakeyolyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sayoi kaimɨraaya kunewaai. Yɨlɨzavetɨyaꞌ kwazɨka mwaaidɨꞌnyɨyaꞌna kunewaai. Nabaai kɨrɨmɨ sawaai newaai. ");
INSERT INTO byr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pɨgaaꞌ Sekaraayalyɨyara Gotɨyare Angevɨ yadaapiyagaaꞌ Sekaraayai sai Gotɨyarɨna yɨna. ");
INSERT INTO byr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pɨrizɨyara kunnya wawɨnyanna dɨnyɨna yadɨvɨꞌ Sekaraayai dahɨlakesai “Wabatɨrɨnyaꞌne yɨkunaabɨthɨka mariravɨma!” daka Gotɨyare Angevɨ wɨlɨna. ");
INSERT INTO byr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sagaaꞌ pɨrizɨyai yɨkunaabɨthɨka yɨraꞌna yadehaaꞌ Juya pwara mwasawɨ yɨꞌbwaꞌnemwaaidɨvɨꞌ Gotɨyarɨ wɨdadɨvɨsabulyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Gotɨyare Angevɨ wɨlɨna kyaꞌ yɨkunaabɨthɨka yɨraꞌnɨke dɨꞌbɨnyavɨ Gotɨyare mamaayai ejelɨyai yɨmaꞌnaabɨna yaka dɨꞌbɨnyavɨ tewaanyaba aangasɨmagɨnna daavɨna. ");
INSERT INTO byr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Daavɨna yadɨsɨ Sekaraayai tɨnna wanganaka sɨmunya kwalaalya yawɨraka lɨka naanga yɨna. ");
INSERT INTO byr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lɨka naanga yɨna kyaꞌ sagaaꞌ mamaayai wɨdaꞌ “Sekaraayai lɨka minnera! Gotɨyai gɨmɨre yɨdaanganyaꞌ guꞌnɨwakeꞌnanyɨ. Gɨmɨre aꞌmweꞌ Yɨlɨzavetɨyaꞌ gɨmɨre kaimalei maaradesɨ. Gamɨre yayaꞌ ‘Jonɨma,’ duthathelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sai kimaꞌnojɨ yɨlaaya naanga jɨtheigɨnyɨ. Aꞌmwera aꞌmwe yɨlaaya yɨpɨꞌdengɨ sahwarɨna. ");
INSERT INTO byr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Sareꞌ dareꞌnesɨ. Gotɨyai tɨnna wangada sarɨna dathe ‘Aꞌmwe naangelyɨ.’ Sai aalya waainɨyasɨ bɨyaayaꞌbɨsasɨ aawa, manyɨ yadelyɨra. Ganaangevɨre munyɨkɨ mwaaidori aayawɨdaasɨ Gotɨyare Kuryai yuneꞌna wɨlamwaaladelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Aꞌmwei yɨmaꞌnojɨ Gotɨyarɨna wɨjɨwaakɨna kyojɨ Yɨzɨrelɨya kwala naanga sɨmunya mudɨka maarapɨri kunnya Gotɨyai Naangerɨ yɨlaaya ayɨna yɨpɨꞌdengɨra. ");
INSERT INTO byr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kɨgaaꞌ Gotɨyarɨ wɨꞌnawɨjɨwaakadei pɨropetɨyai Yɨlaajai dɨragɨnna yaakabaaibɨꞌ sai waanyɨna, wɨdɨna kyojɨ dɨvi Naangei bathelyɨ. Dɨragɨnna wɨjɨwakamaryadaawori kuvɨnɨmaangera kumɨre kaimɨraayangɨ tewaanya yɨpɨꞌderera. Nabaai Gotɨyarebwi myawɨryaraavɨ mwagiꞌnamaarojɨyara yɨdaꞌmaraangeraavɨre sɨmunyaburɨ mɨdɨbɨꞌdeꞌnanyɨ. Sara jovɨrawakɨna kyojɨ Naangerɨna yemwaaibɨꞌdere.” ");
INSERT INTO byr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraayai ejelɨyarɨ wɨdaꞌ “Nyɨdɨwaanyaꞌ gara yojɨ nyɨdɨwaanya sareꞌ yawɨramaarɨdeinyaka! Sareꞌ dareꞌnesɨ. Nɨmɨ neinyɨ. Nɨmɨre aꞌmwevɨ kwarame naanga naanga wavɨlaꞌnɨkesɨ.” ");
INSERT INTO byr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ejelɨyai jaꞌnawɨdɨna “Nɨmɨ Gevɨrɨyelɨnyɨ. Gotɨyare sɨnnyɨkɨ daaꞌdɨnyainyɨ. Gotɨyai kanyɨdasɨwaabɨꞌ walaabena yagaala tewaanyaꞌ gɨmɨnyɨ gɨzaꞌneinyɨ makwalaabeneinyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Sara yɨweꞌ kɨrɨꞌ nɨmɨre yagaalyaꞌ malɨmwagiwaa. Dɨwe sa, nebulya yɨmaꞌnadengɨ kumɨregaaꞌ. Yɨthaa, nɨmɨre yagaalyaꞌ manyuꞌnyɨwaanyaꞌna yagaala majɨ yɨnneigɨnyɨ. Yagaala majaigɨ kuna mwaalaꞌgɨri gɨthɨwe kimaꞌnaabozɨyagaaꞌna dɨthatheigɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sara dɨdaakɨlyɨyagaaꞌ mwasawɨ aꞌmwera Sekaraayarɨ yemwaaidɨvɨꞌ yawɨꞌdɨvɨꞌ “Gotɨyare Angevɨ naangegaaꞌ beꞌna wɨlamwaalɨꞌ?” yawɨꞌdɨvɨꞌ atɨka maruꞌnaꞌna yadɨvɨꞌ mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mwaalɨna yadapi walyuna yaka yagaala majɨ yannei kamwaalaꞌ dara wanganesaꞌ “O, Gotɨyare Angevɨ aꞌmabaaitɨnna wanganakei daaka!” Miꞌna kadeꞌ yagaala majai asaꞌna yɨna yakelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Gotɨyare Angevɨ Sekaraayai gannya wawɨnyaꞌ miꞌna yakegaaꞌ gamɨre angevɨna wɨna. ");
INSERT INTO byr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Angevɨna wɨna kyaꞌ dɨvi gamɨre aꞌmweꞌ Yɨlɨzavetɨyaꞌ kaimɨraavɨmunnakeꞌ mwaalɨna. Kaimɨraavɨmunnakeꞌ mwaalɨna yada gannya angevɨ lawe atina kave wɨlamwaaina. ");
INSERT INTO byr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Wɨlamwaaina yada dakesɨ “Naangei nɨmɨnyɨna kale wiadaaꞌnyɨ tewaanna dara nyaka aꞌmweraayawɨnna nɨmɨre wagɨla maare saꞌ nyɨmarasɨꞌmwaꞌ.” ");
INSERT INTO byr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lawe ati ata purɨdaaꞌnyɨ pukɨ Yɨlɨzavetɨyaꞌ kaimɨraavɨmunnakeꞌ mwaaidɨꞌnyɨyagaaꞌ Gotɨyai Ejelɨya Gevɨrɨyelɨmɨ wɨdasaabaꞌ “Kwaaka Galɨli Anga Naazaretɨna dalaawa! ");
INSERT INTO byr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nɨmɨre yagaalyaꞌ sɨdɨraayavɨ duthana! Sɨdɨraaya Ne Devitɨ yɨta savaakɨdaaꞌnyai Jozepɨyarɨna dakɨnɨkesɨ. Sɨdɨraaya saꞌ Maarɨyaasɨ.” ");
INSERT INTO byr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gotɨyai kudasaabaꞌ ejelɨyai taayayawɨ wɨlaabɨna yaka wɨdaꞌ “Kwaamuꞌnanyabwi gwarana! Gotɨyai gɨmɨjɨ mwaalɨꞌ. Gotɨyai tewaanya naanga gyɨwakeꞌgɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ejelɨyai sara wɨdakeꞌna Maarɨyaaꞌ sɨmunya kwalaalya yawɨꞌda dɨna “Saꞌ be yagaala nyɨdɨwakeꞌnyaka?” ");
INSERT INTO byr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dɨna yaka ejelɨyai wɨdaꞌ “Maarɨyaaꞌ, lɨka minnera! Sareꞌ dareꞌnesɨ. Gotɨyai tewaanya gyɨvanɨꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yɨthaa, kaimɨraavɨmunnakeꞌgɨ mwaalaꞌgɨzɨ kaimɨraayai mɨlaꞌgi gamɨre yayaꞌ ‘Jizaazala,’ dɨthathelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Sai naangei yɨmaꞌnadelyɨ. Aꞌmwera gamɨnyɨna dɨna ‘Gotɨyai munya keꞌmwewɨnyare Gawaalɨvaangelyɨreva.’ Naangei Gotɨyai kingɨyarɨ wɨmwaaihadelyɨ. Kɨgaaꞌ Ne sɨnnawɨnyai Devitɨ gamɨre gyakwalaangei kingɨyai mwalyaakabaaibɨꞌ mwaaladelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yuyagaaꞌ yuyagaaꞌ Jaikopɨjɨyaraavɨ maremwaaladelyɨ. Sai aꞌmweraavɨ maremwaalagwotheꞌ kayaaka mi yadesɨ.” ");
INSERT INTO byr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maarɨyaaꞌ ejelɨyarɨ yɨdaanganaꞌ “Kwala manyɨmaaryaꞌnyɨ mwaaihevɨ gara yɨmaꞌnadeꞌna dɨwaana?” ");
INSERT INTO byr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mamaayai jaꞌnawɨdɨna “Kuryai Tewaanyai gɨmɨnyawɨ walaabathelyɨ. Nabaai Gotɨyare dɨragɨnyaꞌ gɨvwakalɨmwagaradeꞌgɨnyɨ. Gotɨyai sara kyojɨ kaimɨraaya tewaanyarɨna ‘Gotɨyare Gawaalɨvaangelyɨ,’ dɨpɨꞌdelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yɨthaa, gɨmɨnyɨ jɨnyɨwanaanga Yɨlɨzavetɨyaꞌ neꞌ mwaaida ‘Kaimɨraaya mamaaryadesɨ,’ deta kɨrɨꞌ dahaaꞌ kaimɨraavɨmunnakeꞌ mwaaidɨꞌnyɨ lawe ati wavɨlaꞌmwakesɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gotɨyai mi yade pɨnɨ aawa; mwarika! Sareꞌna gamɨre yagaala gazasaꞌ sara yɨmaꞌnadesɨ.” ");
INSERT INTO byr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maarɨyaaꞌ wɨdaꞌ “Gotɨyare wɨdaayadɨnyaꞌnyɨ. Gotɨyare yagaalyaꞌ sara nyɨdɨwaanyabaaibɨꞌ nyɨmaꞌnadeꞌnyɨ.” Miꞌna kudaꞌ mamaayai kaanna wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yɨrɨka sangɨ Maarɨyaaꞌ yarai kaanna wɨna. Kwaaka Juthɨya sabanne mugunyangɨna kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kaanna wɨna yaka angebanna yɨꞌmavaawɨna yaka Sekaraayare angevɨ wɨlɨna yaka Yɨlɨzavetɨyavɨ wɨdaꞌ “Aama!” ");
INSERT INTO byr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Miꞌna kudaꞌ sagaaꞌ Yɨlɨzavetɨyaꞌ kadɨka kuꞌnaꞌ gamɨre munyavɨ bwaranyai yarai yɨtaꞌna. Bwaranyai yarai yɨtaꞌna kyaꞌ Kuryai Tewaanyai Yɨlɨzavetɨyavɨ sɨmunyavɨ yunebanna wɨlamwaaina kyaꞌ ");
INSERT INTO byr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","jaka naanga wɨdɨna “Gotɨyai gamɨre bwaranyarɨ maaryaꞌneꞌgɨnyɨ dahɨlakakeꞌna aꞌmwe yuya pɨnɨngɨna Gotɨyai tewaanya naanga yanga gyadeꞌnanyɨ. Nabaai bwaranyai gɨmɨre munyavɨ minɨkerɨ Gotɨyai tewaanya naanga yanga yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nɨmɨre Naangerɨ ganaangeꞌgɨ nɨmɨnyɨ angyɨrɨꞌmaata nyɨwaa. Nɨmɨ aꞌmwe naangeꞌnyɨ daaka! Maalɨkeꞌnyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sareꞌ dareꞌnesɨ. Yɨthaa, ‘Aama,’ kanyɨdɨwaa nɨmɨre munyɨkɨ bwaranyai yɨlaaya yada yarai nyɨtaꞌmwakeꞌnyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gɨmɨ dahɨna ‘Naangei nyɨdɨwakeꞌ nebulyaꞌ yɨmaꞌnadesɨ,’ dahɨna yɨlaaya yadɨ tewaanaanga yɨnɨkeꞌgɨnyɨra.” Wɨdaꞌ Yɨlɨzavetɨyaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maarɨyaaꞌ wɨdaꞌ “Nɨmɨre sɨmunyavɨ Naangerɨ yɨledaata dɨvanɨge. ");
INSERT INTO byr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Gotɨyai nɨmɨre padaihasamaaryaꞌnerɨ sahwarɨ Nɨmɨre kuryai yɨlaaya yɨwaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Gotɨyare wɨdaayadɨnyaꞌ nyɨ maalɨkeꞌnyɨ nyawɨꞌmwakeꞌna Nɨmɨ saꞌnyɨ yɨlaaya naanga yɨvanɨge. Sareꞌ dareꞌnesɨ. Dɨragɨnyai nawɨꞌnyabwina nyɨwaꞌ. Mɨjayɨmaꞌnɨgwɨyara ‘Maarɨyaaꞌ tewaanaanga yɨnɨkesɨra,’ maredɨmwɨpɨꞌdeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dɨragɨnya Naangei naangenna nyɨwakenneꞌ dɨwɨpɨꞌdesɨ. Gotɨyarɨna yayaꞌ tewaanyaꞌ makɨlaana! ");
INSERT INTO byr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Gotɨyarɨna ‘Naangelyɨra,’ dadaanyainaavɨnajɨ Dɨvi mɨjayɨmaꞌnɨgwɨyara mɨjayɨmaꞌnɨgwɨpɨꞌderaavɨnajɨ dɨwɨpɨꞌderaavɨnajɨ Yuyainaavɨna Gotɨyai kaleꞌna negaimwadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Gamɨre atasɨ dɨragɨnna yɨna yada Pihadɨkeraavɨre sɨmunyavɨ ‘Tewaanyainyɨ,’ yawɨꞌdɨvɨsaraavɨ, Sara yɨpɨꞌdera dɨngakajɨ Gazawɨzawɨ marasɨꞌnamarina yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Gotɨyai maremwaaidɨvɨsaraavɨ kwaakeba marulawakadelyɨ. Aꞌmwe kwaamuꞌnanyaraavɨ munyaba makɨladelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aꞌmwe gɨlyɨvɨꞌ maaya kuneraavɨ yanga wɨjaavade Aꞌmwe kwalaalyajɨyaraavɨ mujaayɨ yojɨ Kuneraavɨ wɨdaasɨna yadere gɨlyɨvɨꞌnakeraavɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nemɨre Ne sɨnnawɨnyaraavɨ wɨjaakeꞌ yawɨꞌda Yɨzɨrelɨyaina wɨdayadaanyainaavɨ kaleꞌna negaimwamwaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Evɨraamɨmɨnajɨ neyakwalaangeraavɨnajɨ kale wiada Gotɨyai sahwaraavɨ nayaa wɨjaakabaaibɨꞌ Yuyagaaꞌ Evɨraamɨmɨrevaakɨdaaꞌnyainaavɨ tewaanna negaimwadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maarɨyaaꞌ sara daka Yɨlɨzavetɨyayaba lawe dɨkaai dɨꞌ mwaalɨna yaka gannya angebanna ayɨna wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Yɨlɨzavetɨyaꞌ kaimɨraaya maarya yunegaaꞌ yɨbwakɨnaka kaimɨraayai maarɨna. ");
INSERT INTO byr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kaimɨraayai maarɨna kyaꞌ anga avaalyabanyarajɨ gamɨjɨyarajɨ dara wɨꞌnesaꞌ “Ai, sareꞌna Naangei Yɨlɨzavetɨyavɨna kale naanga wiwakei daaka!” Miꞌna deva gamɨjɨ yɨlaaya yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sawɨta ati ata purɨdaaꞌnyɨ dawaai kwavɨlavaꞌ bwaranyare kɨlaaka pimagɨnyajɨꞌ dawasɨꞌnyaꞌna beva yawɨꞌdɨvɨꞌ “Ganɨmaangere yaya Sekaraayai wɨdaana!” ");
INSERT INTO byr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","deva saꞌ ganaangeꞌ jaꞌnawɨdɨna “Aawa, gamɨre yayaꞌ Jonɨ.” ");
INSERT INTO byr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kumɨ wɨdeꞌ “Gɨmɨjɨya aane pwai kwai yaya savɨ mamwaalyɨka.” ");
INSERT INTO byr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sara wɨdeva ganɨmaangerɨ yayaꞌna asaꞌna yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekaraayai yagaala majai pɨkarɨyɨkwiasɨ pɨkarɨyɨsarɨsɨ makabyaꞌneraavɨ ata akwebwata kyaꞌ miꞌna wɨjaavɨna kyeꞌ pɨkarya yɨdavaꞌ “Gannya yayaꞌ Jonɨ.” Sara kidavaꞌ atɨka maruꞌnaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Atɨka maruꞌnaꞌna kyeꞌ sagaaꞌ Sekaraayai maanga tavadɨna, Gotɨyarɨ yɨlaaya wiada yɨleyagaala wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yɨleyagaala wɨdɨna kyaꞌ anga avaalyabanyara lɨka yɨna yeva dɨvi Kwaaka Juthɨya mugunya yunebanna dɨwɨna yagaala saꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Dɨwɨna yeva yuyara savɨ wɨꞌneva sɨmunyavɨ nayaa yawɨrakɨna yeva dɨnyɨna “Kaimɨraaya sai bewaibɨtai yɨmaꞌnadelaka?” Sareꞌ dareꞌnesɨ. Tɨnna dara wanganesaꞌ “Gotɨyare dɨragɨnyabwi gamɨjɨ damwaaimwaka!” Deva sara dɨnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jonɨmɨ ganɨmaangei Sekaraayare sɨmunyavɨ Kuryai Tewaanyai yuneꞌna wɨlamwaaina yadɨꞌnyɨ Sekaraayai Gotɨyarɨ wɨꞌnawɨjɨwaakɨna yada wɨdaꞌ ");
INSERT INTO byr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Naangerɨ yɨlaaya wiaana! Naangerɨ yɨledaata wɨdaana! Yɨzɨrelɨyainaavɨre Gotɨyarɨ wɨdaana! Gamɨreinaavɨ negaimwamwakeꞌna Wiwawɨnyabwi neyɨpalasɨꞌnaka Nemaaꞌmwakeꞌna yɨlaaya yaano! ");
INSERT INTO byr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wɨdaayadei Devitɨmɨre yɨsavaakɨdaasarɨ wɨmwaaihadelyɨ. Ayawɨ nevadaihasamaaraderɨ Dɨragɨnyarɨ wɨmwaaihadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Aayawɨdaasɨ Gotɨyarɨ wɨꞌnawɨjɨwaakadɨvɨsaraavɨ wɨjaakabaaibɨꞌ Sahwara tewaanyara nemɨnyɨna yɨdayaasaꞌ ");
INSERT INTO byr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Naangeꞌnanyaꞌ yɨhɨthɨwaꞌ ‘Yɨkamaangeraavɨ yɨhɨvadaihasamaarɨde Sarɨmɨnyɨna sɨmɨlɨka wimwaaiderera. Sahwaraavɨre dɨragɨnya marasɨꞌnɨderera.’ ");
INSERT INTO byr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nemɨre Ne sɨnnawɨnyaraavɨna wɨdaꞌ ‘Nɨmɨre lɨmwagaka tewaanyaꞌ yawɨꞌdɨ Sarɨmɨnyɨ kale yɨhɨgaimwamanɨge Gotɨyainyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ne Evɨraamɨmɨ dɨragɨnyaꞌ wɨdena Yune naanga nebulyaꞌ wɨde “Yɨkamaangeraavɨ yɨhɨvadaihasamarɨde Lɨka myadɨvɨsaihi dɨnyɨdaayideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Yuyagaaꞌ mwaaibɨzagaaꞌ tewaanyaihi Nɨmɨnyɨna yɨdaꞌmaraangebwi yawɨꞌdɨvɨsaihi Nɨmɨnyaba tewaanna dɨmwaalyideihɨlyɨ.” ’ ” ");
INSERT INTO byr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sekaraayai daka gawaalɨꞌ Jonɨmɨ wɨdaꞌ “Nyɨbwaalɨꞌ, gɨmɨnyɨna pwara dɨpɨꞌdeꞌ ‘Gotɨyai munya keꞌmwewɨ mwaalɨka Sahwarɨ wɨꞌnawɨjɨwaakadelyɨ pɨropetɨyai.’ Gɨthɨwe sareꞌ daꞌdareꞌnesɨ. Dɨvidaaꞌnyɨ Naangei bathevɨna Sɨnnawɨ waanyɨna yaꞌgɨzɨ Tusaꞌ javadaꞌgalakya jɨthesɨra. ");
INSERT INTO byr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Sarevɨna gamɨreraavɨ duthatheꞌnanyɨ, ‘Naangei sarɨmɨre kayaaꞌnanyabwi yɨhɨmarasɨꞌnojɨ Yɨhɨvadaihasamaarojɨyai gannya tewaanyabwi yɨhyadelyɨ.’ ");
INSERT INTO byr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nemɨre Gotɨyai kaleꞌna negaimwadelyɨ; Nawɨꞌnya tewaanyabwi nemaremwaaidelyɨ. Sɨgunyavɨya yɨrɨkerɨ nemɨnyɨna yasaabathe. ");
INSERT INTO byr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Baakei walaabozɨ jɨhɨnyawɨ mwaidaanyaina Balyaꞌna lɨka yadaanyabwi marasɨꞌnojɨ Kwaamusagaaꞌ tewaanya mwalaadevwi nejaavadelyɨ.” Sekaraayai sara wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kaimɨraaya sai gɨrina yada gamɨre kɨlaakejɨsɨ kuryalyɨ naanga yaꞌ. Aꞌmwera mamwaalyaba mwaalaka dɨvidaaꞌnyɨ aꞌmwe Yɨzɨrelɨyaraayawɨ kuꞌmaayaba gamɨre wawɨnyaꞌ yakegaaꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yɨrɨka sangɨ Romɨ Gaꞌmaanɨya Maremwaaidei Sizaa Wohazɨtaazai wɨdaꞌ “Kwaaka yuyavakaavɨ mwaalyaraavɨre yaya bukuyavɨ maapɨka!” ");
INSERT INTO byr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sagaaꞌ yaya mudɨꞌna maaryagaaꞌ Kwirɨnɨyaazai Kwaaka Sɨrɨya maremwaaidehaakɨ. ");
INSERT INTO byr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","“Yaya maapɨka!” kudaꞌ sareꞌna kuvɨnɨmaangeraavɨre angewɨnna yuyara kaanna wɨna yeꞌ. Gazaizai gannya abwaibwalaasavɨna wɨna. ");
INSERT INTO byr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ne Devitɨmɨre yɨsavaakɨdaasai Jozepɨyai mwaalakelyɨ. Ne Devitɨmɨrei Kwaaka Galɨli Anga Naazaretɨdaaꞌnyai Kwaaka Juthɨya Anga Betɨlemɨna kaanna wɨna. Anga savɨ kɨgaakuna Kingɨya Devitɨmɨre angebanyɨ. Saba Devitɨmɨ ganaangeꞌ maryaakebanyɨ. ");
INSERT INTO byr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jozepɨyarɨne taayaꞌ dakɨnɨkeꞌ Maarɨyaaꞌ kaimɨraavɨmunnakeꞌ kɨrɨsɨ “Naarɨmɨre yaya maapɨka!” dahɨla kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kaanna wɨna yagɨla Betɨlemɨ mwaaidakɨlyɨ Maarɨyaaꞌ kaimɨraaya maaryagaaꞌ yɨbwakɨnaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Sara yaka gannya sɨraangei maarɨna. Maarɨna yaka kwaabɨhannya maryewaaꞌmwanna yaka bulɨmakaawoyaraavɨre wapaaya nadɨvɨsavɨ maradɨꞌgwalakɨna yaꞌ. Anga pwara waraawiaꞌnevɨ yuneba gɨrasɨꞌnakeꞌna bulɨmakaawoyaraavɨrevɨ maradɨꞌgwalakɨna yakelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Saba angeba mwasɨlaa sipɨzipɨyangɨ maremwaaidɨvɨsara mwaaidɨvɨꞌ sawɨta savɨ kaabidaryawɨ sipɨzipɨyangɨ maremwaaina yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sipɨzipɨyangɨ maremwaaina yadapi Naangere ejelɨyai yɨmaꞌnaabɨna kyaꞌ Naangere byaanna dɨragɨnyaꞌ wannyɨna yakesɨ kumɨnyaba. Wannyɨna kyaꞌ lɨka naanga kyeꞌ ");
INSERT INTO byr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","mamaayai wɨdaꞌ “Lɨka mipɨna! Sareꞌ dareꞌnesɨ. Yɨthaanyi, yagaala tewaanyaꞌ makwaimanaabɨhe. Yagaala saꞌ yuyara wɨꞌnapɨjɨ yɨlaaya naanga yɨpɨꞌdeꞌ makwaimwaabe. ");
INSERT INTO byr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dahaasagaaꞌ Ne Devitɨmɨre angeba kaimalerɨ maaꞌmwakei. Sai sarɨmɨre kayaaꞌnanyaburɨjɨ pwaraavɨre kayaaꞌnanyaburɨjɨ yɨhɨvadaihasamaaradelyɨ. Sarɨ Gotɨyai dahɨlakaka maryasaabɨwakei Kɨraazɨtɨyalyɨ. Naangelyɨ. Sareꞌna kwalaalyara yɨlaaya naanga yɨpɨꞌdeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sarɨmɨ wawapɨjɨ sarɨmɨnyɨ wɨjɨwaainyaꞌneꞌ dara wangabɨzaꞌ ‘Ai! Bulɨmakaawoyaraavɨre wapaaya nadɨvɨsavɨ kwaabɨhannya yewaaꞌmwannɨkei daaka!’ Tɨnna miꞌna wanganapɨjɨ jawɨryide ‘Nebulyasɨ. Sai nemaaradelyɨ.’” ");
INSERT INTO byr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ejelɨyaryaba ejelɨya kwala naangeꞌ yarai yɨmaꞌnaabɨna yeva Gotɨyare aamiyara Gotɨyarɨ yɨlaaya yadɨvɨꞌ yɨledaata pɨrɨꞌ naanna deꞌ ");
INSERT INTO byr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Gotɨyai Sɨgunyavɨ munya keꞌmwewɨ mwaalɨꞌ. Sarɨna nemɨ yɨlaaya naanga yaana! Su! Kwaakewɨnyaraavɨna Gotɨyarɨ kale wiada ‘Kwaamuꞌnanyabwi wɨwakɨma!’ dɨna yadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mamaayara Sɨgunyavɨnera ayɨna yɨlaawɨna kyeꞌ sipɨzipɨyangɨ maremwaaidɨvɨsara dɨnyɨna yeꞌ “Betɨlemɨna kaanyaana! Sara yɨmaꞌnɨwakevɨna Gotɨyai sara nedɨwakeꞌna tɨnna wanganaadeꞌna kaanyaana!” ");
INSERT INTO byr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dɨnyɨna yeva yarai kaanna wɨna yeva wanganna yeꞌ. Maarɨyaasɨ Jozepɨyalyɨ bulɨmakaawoyaraavɨre wapaaya nadɨvɨsavɨ kaimɨraayai wɨlaꞌdɨsɨyaba tɨnna wanganeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Gamɨnyɨ tɨnna wanganeva yagaala mamaayai wɨdakeꞌ wɨdeꞌ kaimɨraaya bwaranyarɨna. ");
INSERT INTO byr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kumɨ sara yagaala kadeꞌ pwara wɨꞌnyɨna yeva atɨka wɨꞌnareꞌ. ");
INSERT INTO byr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maarɨyaaꞌ gannya sɨmunyavɨ yagaala sa wakɨna yaka yawɨramaremwaaina yadesɨ. ");
INSERT INTO byr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipɨzipɨyangɨ maremwaaidɨvɨsara ayɨna wodɨvɨꞌ “Ejelɨyai sara nedɨwakeꞌ nebulyasɨra. Nemɨ kadɨka wɨꞌnona tɨnna wangamwo naangeꞌnanyasɨ,” dɨwɨna yadɨvɨꞌ Gotɨyarɨ yayaꞌ byaannakeꞌ munyaba makina yeva Gotɨyarɨ yɨlaaya naanga yɨwɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Dɨvi sawɨta ati ata purɨdaaꞌnyɨ pɨrɨwaai miꞌna kajɨnnaꞌ kɨlaaka pimagɨnyajɨꞌ dawasɨꞌna yadɨvɨsagaaꞌ kaimɨraayare kɨlaaka dawasɨꞌna yeva “Jizaazala,” wɨdɨna yeꞌ. Kɨgaaꞌ Maarɨyaaꞌ kaimɨraavɨmunya kuneꞌ mwaaidɨꞌnyɨ mamaayai yaya saꞌ wɨdakeꞌ “Jizaazala,” wɨdɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ne Mozɨzare Kɨwɨnya dɨnɨkeꞌna (yɨrɨka 40) Jozepɨyalyɨ Maarɨyaasɨ sayoi mudangeꞌne gɨrɨkitaꞌnanyaꞌ wasɨꞌnyaꞌneꞌna Angeba Jeruzaalemɨna kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nabaai Naangere Kɨwɨnya dɨnɨkabaaibɨsasɨ. Bwaranya sɨnnawɨnyai Naangerɨnelyɨ. Sara dɨnɨkeꞌna Jeruzaalemɨna kaimɨraayarɨ wɨjɨwaainyaꞌna kaanna makuna. ");
INSERT INTO byr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nabaai Naangere Kɨwɨnyaꞌ dɨnɨꞌ “ ‘Kwaamɨryawaai dahamwaaihi? Gulɨkwaamɨrya tihɨnyawaai dahamwaaihi?’ daꞌgɨzɨ dɨka yɨraꞌna yɨjaꞌ dɨka nasɨꞌna yadesɨ Gotɨyarɨneꞌ. Mudangeꞌne gɨrɨkitaꞌnanya marasɨꞌnyaꞌnebwinanyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yɨthaa, Angeba Jeruzaalemɨ aꞌmwei Sɨmɨyonɨ woꞌnɨkei mwaalɨna yaꞌ. Sai aꞌmwe tewaanyai Gotɨyare yagaala dɨragɨnna lɨmwagaꞌdei Sɨmɨyonɨ Yɨzɨrelɨyaraavɨ tewaanya yɨvaimwaderɨna yemwaaina yakelyɨ. Gotɨyare Kuryai Tewaanyai gamɨnyɨ mwaaida yagaala naanga wɨdaꞌ ");
INSERT INTO byr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","“Sɨnnawɨ Naangere wɨdahɨlakyai Kɨraazɨtɨyarɨ tɨnna wanganaꞌgɨzɨ dɨvi dɨvaideigɨnyɨ. Sɨnnawɨ dɨvaideꞌ mɨka!” ");
INSERT INTO byr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sarei mwaalɨna kyaꞌ Kuryai Tewaanyai Gotɨyare Angevɨ wibwarɨdaakuna kyaꞌ sai kaanna wɨlaabɨna. Kaanna wɨlaabɨna yaka Gotɨyare Angevɨ mwaaidɨꞌnyɨ ganɨmaangelyɨ ganaangesɨ sayoi kaimɨraaya Jizaazarɨ makabɨna. “Gotɨyare kɨwɨnyaꞌ dɨnɨkeꞌna sara wɨjɨwainaawɨna yaka!” dahɨla makabɨna. ");
INSERT INTO byr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Miꞌna makabɨna kyagi Sɨmɨyonɨ kaimɨraayarɨ asɨrɨ yɨlamarayagalakɨna yaka Gotɨyarɨna yɨlaaya yada wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Naangeigɨ, dahaaꞌ naanga nyɨdahɨnyaꞌ yɨwaa. Gɨthaayadɨnyainyɨ nɨmɨre munya tewaanya waꞌdeinyɨ Tewaanna yawɨꞌna yadɨnyainyɨ nayaa balɨdeinyɨ. ");
INSERT INTO byr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nayaa balɨde sareꞌ dareꞌnanyɨ. Nɨnnya tɨnnyaraai dara wangamanɨgeꞌ ‘Gotɨyare nemɨnyɨ Nevadaihasamaaraderɨ dangamanɨge!’ ");
INSERT INTO byr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Sai tewaanyarɨ dahɨlakagɨna wɨmwaihɨwaa. Aꞌmwe yuyara wanganyaꞌnerɨ wɨmwaihɨwaa. ");
INSERT INTO byr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Sai baakei ajɨmya yuyangɨyaraavɨ wɨjɨwaakada Gɨmɨreburɨ mudɨkera nayaa tɨnna wangabɨꞌdere. Gɨmɨreina Yɨzɨrelɨyaina byaanna dɨragɨnyavɨ mwalaadeine.” ");
INSERT INTO byr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Sɨmɨyonɨ kaimɨraayarɨna wɨdakeꞌna kaimɨraayare ganɨmaangelyɨ ganaangesɨ sawaai atɨka maruꞌnaꞌna yagi. ");
INSERT INTO byr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Atɨka maruꞌnaꞌna yadaakɨlyɨ Sɨmɨyonɨ wɨdaꞌ “Gotɨyai tewaanya yanga yɨhyadelyɨ.” Wɨdaka ganaanga Maarɨyaavɨ wɨdaꞌ “Gotɨyai kaimɨraaya darɨ dahɨlakakelyɨ. Yɨzɨrelɨya pwara kuꞌnapɨjɨ munyaba makɨladerera. Pwara muꞌnyɨ yɨpɨjara kwaakeba marulawakaderera. Sai Gotɨyare sɨmunyaꞌ wɨjɨwaainada Kwalaalyara sahwarɨ maanga wɨdɨpɨꞌdevɨneꞌna ");
INSERT INTO byr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yawɨta kayaaꞌnanya lɨka yulyaꞌdɨvɨsaraavɨna Aꞌmwe yuyara nayaa yawɨrangabɨꞌdeꞌnanyɨ. Kale naanga gyadeꞌna Kwaariꞌmasɨramɨnya sɨnnakeꞌ gɨthavadevaaibɨsaꞌna Kɨnna naanga dɨthatheꞌgɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gotɨyarɨ wɨꞌnawɨjɨwaakadeꞌ pɨropetɨyaꞌ Anaꞌ mwaalaꞌ. Saꞌ Panyɨwelɨmɨre garaavaangaꞌ, Ne sɨnnawɨnyai Aazarevaakɨdaaꞌnyasɨ. Aꞌmwe saꞌ nesɨ. Aꞌmwerɨ maaꞌnaka aꞌmwelyɨyagaaꞌ kwarame ati ata purɨdaaꞌnyɨ pɨrɨwaai mwaalaka ");
INSERT INTO byr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","yaanyɨwaakeꞌ kwarame 84 (aꞌmwe daraai daraalyaraavɨre atɨzɨvɨlɨraai yaka dawaai dawaai) wavɨlaꞌnɨkeꞌ aꞌmwe neꞌ mwaalaꞌ. Gotɨyare Angevɨ yagalyaꞌmata mi, yuyagaaꞌ Gotɨyarɨ dɨragɨnna yɨdaangadeꞌ wapaayajɨ manyɨ, kɨmaaka mwaaida Gotɨyarɨ wɨdada mwaalakesɨ. ");
INSERT INTO byr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sɨmɨyonɨ kuna wɨdadaaꞌnyɨyagaaꞌ aꞌmwe saꞌ bɨna yaka Gotɨyarɨ “Su! Su!” wɨdaka kaimɨraayarɨna pwaraavɨ wɨdɨna. Gotɨyai Anga Jeruzaalemɨ mwaalyaraavɨ wiwawɨnyabwi yɨpalasɨꞌnyaꞌna yemwaalesara sahwaraavɨ wɨdɨna yaꞌ aꞌmwe saꞌ. ");
INSERT INTO byr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Naangere Kɨwɨnya dɨnɨka yuya miꞌna yeva Kwaaka Galɨli kunnya Anga Naazaretɨna ayɨna wɨna yeva mwaalɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kaimɨraayai naanga gɨrina yaka dɨragɨnya yakelyɨ. Sai sɨmunya nayaa yawɨrakei Gotɨyare yanga wɨgaimwangebwi waꞌdelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kwarame yuyagaaꞌ Angeba Jeruzaalemɨna Jizaazare ganɨmaangelyɨ ganaangesɨ kaanna wɨna. Kɨgaakuna Gotɨyai Yɨzɨrelɨyaraavɨ maramyɨ yaka pariꞌmaꞌna yaakeꞌna Juyara Pariꞌmaꞌmunneꞌ nyɨna yadɨvɨsaꞌna sawaai kaanna wɨna yagɨlyawaalyɨ. ");
INSERT INTO byr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jizaazarɨ kwarame atɨraai sɨvɨlyɨrɨdaaꞌnyɨ pɨrɨwaai kwavɨlavaꞌ sagaaꞌ ayabaaibɨꞌ munne tɨka nyaꞌna Jeruzaalemɨna wɨna yadiꞌ Jizaazarɨ makilaawɨna. ");
INSERT INTO byr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Miꞌna makilaawɨna yagɨla munne nyɨna yagɨla kɨrɨnnya angevɨna kaanna wɨna. Kaanna wɨna yadaakɨlyɨ Anga Jeruzaalemɨ kaimale Jizaazai mwaalɨna. Saꞌna ganɨmaangelyɨ ganaangesɨ myawɨri yagɨla ");
INSERT INTO byr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Pwarajɨ wɨwaka,” dahɨla yɨrɨka sari kaanna wɨna. Kaanna wɨna yagɨla sawɨsɨrɨ “Gawɨ mwaalɨka?” dahɨla kɨrɨmɨjɨyaraayaba kɨryaꞌmweraayaba bɨrɨna bɨrɨna. ");
INSERT INTO byr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Aawa. Kunewɨ wanganagɨla Jeruzaalemɨna ayɨna wɨna yagɨla ");
INSERT INTO byr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","yɨrɨka daryaai darɨkɨ Jizaazarɨ bɨramaaꞌna. Gotɨyare Angevɨ Gotɨyare kɨwɨnya wɨjɨwaakadɨvɨsara Juyaraayaba bɨramaaꞌna yagi. Saba Jizaazai walamwaaina yada wɨjɨwaakadɨvɨsaraavɨre yagaala wɨꞌnaka kumɨnyɨ yɨwaaraꞌna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sai sɨmunya nayaa yawɨꞌda yagaala nayaa wɨdakeꞌna aꞌmwera wɨꞌnyɨna yeva atɨka maruꞌnaꞌna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nabaai ganɨmaangelyɨ ganaangesɨ tɨnna wanganagɨla atɨka maruꞌnaꞌna yagɨla ganaangeꞌ wɨdɨna “Kaimɨraayaigɨ, naarɨmɨnyɨna baaꞌna yɨwaa? Yɨthaa, gɨmaamaangelyɨ nɨmɨjɨ saꞌnaarɨ taanga nehyadaaꞌnyɨ gɨmɨnyɨna bɨꞌmanɨgoi.” ");
INSERT INTO byr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sai wɨdaꞌ “Nɨmɨnyɨna beꞌna bɨꞌmanɨgɨla? Nɨmware angevɨ mwaaimujaꞌna beꞌna bɨramarivanɨgɨla? Kɨrɨmɨ myawɨrijɨwaai?” ");
INSERT INTO byr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sara kudaꞌ kɨrɨꞌ sawaai myawɨramaaryagi wɨdakeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Anga Naazaretɨna kɨrɨmɨjɨ walaawaka mwaalaka kɨrɨmɨ sawaarɨ kwaakewɨ nayaa mwaalaꞌ. Jizaazai yuya yakeꞌna ganaangeꞌ gannya sɨmunyavɨ nayaa wakaka kave maremwaalaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sɨmunya dɨragɨnna yawɨꞌdaaꞌnyɨ Jizaazare kɨlaakejɨsɨ sɨmunyasɨ tewaanna yada Gotɨyalyɨ aꞌmwerajɨ tɨnna wanganeva yɨlaaya yadaapɨjɨ mwaalaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taaivɨrɨyaazai Sizaai yuyaraavɨ maremwaaidɨꞌnyɨ kwarame potinɨya (14) wavɨlaꞌdaaꞌnyɨyavɨ Anga Juthɨya sɨmagɨ Podɨyaazai Paailatɨ Gaꞌmaanɨya naangei mwaaidɨꞌnyɨ Galɨli saba Erotɨyai maremwaalaka maalɨkei mwaaidɨꞌnyɨ Yɨturɨyanajɨ Tɨrakonaaitazɨnajɨ sabanyaai Erotɨyarɨ gyaꞌmwei Pilipɨ maremwaalaka maalɨkei mwaaidɨꞌnyɨ Aavɨlinɨ saba Laazanɨyaazai maremwaalaka maalɨkei mwaaidɨꞌnyɨ ");
INSERT INTO byr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","nabaai Anaazalyɨ Kaayapaazalyɨ sanyalɨdaai Gotɨyarɨna Mubɨthɨka Yɨraꞌdita Naangeraai mwaaidakɨlyɨ yɨ dazagaaꞌ aꞌmwera mamwaalyɨgasaba Jonɨ Sekaraayare gawaalɨvaangei sahwaryawɨ Gotɨyare yagaalyaꞌ biꞌmaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Sarevɨdaaꞌnyɨ sai Aalya Jothanɨyavɨ yunewɨ yuyaba yamaryada “Gotɨyai aꞌmweihɨre kayaaꞌnanya marasɨꞌnyaꞌna sɨmunya mudɨkebwi yawɨramaaꞌna kyapɨjɨ bavɨtaazɨyaꞌ yɨhideꞌnanyɨ,” sara wɨdamaryakelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sareꞌ kɨgaakuna Aazaayarɨ Gotɨyai kujaaꞌ bukuyavɨ pɨkarya yavɨkarinɨkabaaibɨsasɨ. Dara dɨnɨꞌ “Wawɨmaayaba pware maanguraayaꞌ jaka yɨmanɨꞌ ‘Naangerɨne tusaꞌ nayaa yavadaꞌgalakɨna jɨlo! Gamɨre tusangɨ yɨdaꞌna nayaa jamakwilo! ");
INSERT INTO byr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Taawala yuyangɨ yunebanna nayaa marajɨngɨrapɨjɨ Mugunya naangejɨ maalɨkejɨ sa dɨthavapɨraalayɨlo! Tuta kayaaꞌna naadɨya yɨdaꞌna javadaꞌgalyɨlo! Tutaanya sɨla yaasɨwaꞌna waramarike dɨmarasɨꞌnyɨlo! ");
INSERT INTO byr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Sarevɨ Gotɨyai padaihasamaaryabwina yuyara wangabɨꞌderero.’” Sara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aꞌmwe kwala bwaꞌnaanyara Jonɨmɨre bavɨtaazɨya maaryaꞌnera yɨkabadaapɨjɨ sasarei saraavɨ wɨdɨna “Naawɨnaanyara kave kwaasɨ neyadɨvɨtabaai sarɨmɨ sɨmunya ayabwina kɨnɨnnakeihi bavɨtaazɨya yaasɨwaꞌna maaryaꞌneihi bɨvanɨgasaihi daa! ‘Gotɨyai kayaaꞌnanyanna taanga nyɨhɨzaavadɨka! Yaasɨwaꞌna bavɨtaazɨya maapɨjaihi tewaanna dɨmwaalyideihɨlyɨra,’ kwaasɨ sara aai yɨhɨthɨwaka! ");
INSERT INTO byr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sarevɨdaaꞌnyɨ taanga naangeꞌna sɨmunya mudɨkebwina nayaa yawɨramaaꞌna jɨla! Sara yapɨjɨ sɨmunya mudɨkebulyɨyaihi yɨsɨla nawɨꞌnyabɨta nayaa sara jideihɨlyɨ. Sarɨmɨ saihi dara madɨbɨnera! ‘Evɨraamɨmɨ gyakwalaangeina mwaaihoꞌna Gotɨyai taanga sa mujaayɨ neyadeꞌnanyɨ.’ Sara myawɨpɨna! Sareꞌ dareꞌnesɨ. Nayaa yɨhɨthɨma! ‘Sɨla daza Evɨraamɨmɨre kaimɨraaya yɨmaꞌnana!’ Gotɨyai sara wɨdazai yɨ sahwai yɨnɨga wiꞌna yannelyɨ. ‘Evɨraamɨmɨ gyakwalaangeinera,’ dɨmanɨgasaꞌ naangeꞌ daaka! ");
INSERT INTO byr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dahaasagaaꞌ Gotɨyai yɨsarɨ kaavɨlyawɨ dapalyaꞌnei gannya saajɨngei mena lɨmwagɨkelyɨ. Sarevɨdaaꞌnyɨ yɨta gazarazara yɨsɨla tewaanya miꞌnyɨ yajara sare sara dapalojɨ dɨkevɨ marasɨꞌnaderera.” ");
INSERT INTO byr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sai sara wɨdadaaꞌnyɨ yɨ kwala bwaꞌnaanyara yɨdaanganna “Weꞌ! Sarevɨdaaꞌnyɨ nemɨ gara yaadeinaavaka?” ");
INSERT INTO byr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Sara yɨdaanganna kyeꞌ jaꞌnawɨdɨna “Aꞌmwei baazɨꞌmaꞌnya pɨrɨwaai kɨnɨnnakei aꞌmwe pwarɨ baazɨꞌmaꞌnyaꞌ maayarɨ pɨrɨꞌ wɨjaavana! Aꞌmwei wapaaya kɨnɨnnakei sai kwalyɨ wapaayanna avaaina sana yɨna yana!” ");
INSERT INTO byr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wɨdɨna kyaꞌ aꞌmwe taakɨzɨya maaꞌdɨvɨta pwarajɨ bavɨtaazɨya maaryaꞌnera gamɨnyɨ wɨdɨna “Nejɨwaakadɨnyaigɨ, nemɨ gara yaadeinaavaka?” ");
INSERT INTO byr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wɨdɨna kyeꞌ sai wɨdɨna “Gaꞌmaanɨyai yɨhɨthɨvanɨkabaaibɨꞌna taakɨzɨya nɨgwia yɨnɨga wiꞌnanya dɨmaaryideihɨlyɨ. Nɨgwia kwaala pɨnɨjɨ mamwagiꞌnɨpɨnera!” ");
INSERT INTO byr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wɨdɨna kyaꞌ nabaai aawɨlata pwarajɨ sahwarɨ yɨdaanganna “Nabaai nemɨ sahwaina gara yaadeinaavaka?” Sara wɨdɨna kyeꞌ sai wɨdɨna “Sarɨmɨ aꞌmweraavɨ kwaasɨ kotɨyajɨ myadɨvɨꞌ kumɨre nɨgwia mwagiꞌnyaꞌneihi mipɨna! Nɨgwia mwagiꞌnyaꞌneihi aꞌmweraavɨ mala maramamaripɨnera! Sarɨmɨre maremwaaidei nɨgwia yɨhɨzaavanɨka sahɨnɨnna ‘Wikɨra!’ dɨthɨnyɨla! Nɨgwia pɨnɨjɨna mudɨpɨna!” ");
INSERT INTO byr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aꞌmwe yuyaraavɨre sɨmunyavɨ Jonɨmɨna dɨragɨnna dara yawɨꞌna “Bewalaka? Berɨꞌna yadelaka?” Yawɨꞌna yadɨvɨꞌ dara yawɨꞌna “Gotɨyai pwarɨ dahɨlakojɨ maryasaabathei Kɨraazɨtɨyai dɨngaka Jonɨ?” ");
INSERT INTO byr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Sara yawɨꞌna yadaapɨjɨ Jonɨ jaꞌnawɨdɨna “Nɨmɨ sainyɨ aangaalyavɨ bavɨtaazɨya yɨhyadɨnyainyɨ. Dɨvi aꞌmwe pwai bathei yɨ gamɨre dɨragɨnyaꞌ nɨmɨre dɨragɨnyavɨ nyavɨlavɨkelyɨ. Gamɨre mamaayainyɨ nɨmɨ nebulyaꞌnanyainyɨ mɨka! Sahwarɨna nɨmɨ wana maalɨkeinyɨra. Wɨgaimwagyaꞌneinyɨ gamɨre kwaariꞌmasɨvɨlyaꞌ galyaaꞌmuneꞌ nɨmɨ aꞌmwe nawɨꞌnyainyɨ mɨꞌ. Sahwai sarɨmɨnyɨ pwaihɨrɨna Kurya Tewaanyarɨ kusawɨ bavɨtaazɨya yɨhyaꞌnei Kurya Tewaanyarɨ wɨlayɨhɨmwaaihadelyɨ. Nabaai pwaihɨrɨ muꞌnyaꞌneihɨrɨ daangevɨ bavɨtaazɨya yɨhyaꞌnei dɨkevɨ wɨlayɨhɨmwaaihadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sai gannya saavolɨya parɨnakeꞌ gannya asɨrɨ lɨmwada witɨya yɨlamarasɨꞌna yɨlamarasɨꞌna kyojɨ yagɨnya kɨlaake kurɨvaarɨya yɨhuta bamakuna kyojɨ witɨzɨla gamɨre witɨzɨlangevɨ marakadelyɨ. Gamɨre mɨnyevɨ witɨya kune kwarojɨ kurɨvaarɨya dɨka migaayaꞌnevɨ mariravadengɨ.” ");
INSERT INTO byr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sarevɨdaaꞌnyɨ Jonɨ sara wɨdɨna yaka nabaai kumɨre sɨmunyarɨ yɨdɨkavɨmwaaihya yaꞌnei yagaala kwalaalya pɨnɨjɨ dɨna yɨna yaꞌ. Nabaai sasare dazabwi aꞌmweraavɨ yagaala tewaanyaꞌ wɨjɨwaakadevulyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kɨrɨꞌ sai Aꞌmwe Erotɨyarɨ kumɨre maremwaala maalɨkerɨ maanga wɨdɨna. Erotɨyare gyaꞌmwere aꞌmweꞌ Erotɨyaazavɨ kuka maarakeꞌnajɨ nabaai kayaaꞌna yɨwetawakya yuya sara yakeꞌnajɨ maanga wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Maanga wɨdɨna kyaꞌ Erotɨyai kayaaꞌna yɨwetawakya yaka yuya daza yɨwetawakya pɨrɨsɨ yeꞌmwanna yakesɨ. Sahwai Jonɨmɨ kalavuzavɨ wɨmwaaihɨna yakelyɨ. Sara yakesɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jonɨ tewaanya mwaalakegaaꞌ aꞌmwe yuyaraavɨ bavɨtaazɨya yakegaaꞌ yɨ Jizaazai kwarɨjɨ bavɨtaazɨya kyaꞌ Jizaazai Gotɨyarɨ wɨdadaaꞌnyɨ, yɨthaa, sɨgunyaꞌ mujaangɨna kyaꞌ ");
INSERT INTO byr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kurya Tewaanyai walaabɨna. Kurya Tewaanyai yuta kwaamɨryaibɨsai sahwaryawɨnnei walaabɨna. Miꞌna walaabɨna yaka bwalamwaaina kyaꞌ Sɨgunyavɨdaaꞌnyɨ maanguraaya pɨrɨꞌ jaka yɨnyɨna “Gɨmɨ nɨmɨre Nyɨbwaalɨvaangeigɨnyɨra. Gɨmɨnyɨna tewaanna nyɨvuꞌnadeigɨnyɨ. Kurya tewaanya gukadɨnyaigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jizaazai gamɨre wawɨnya aaya mudɨꞌna yamaata yakegaaꞌ gamɨre kwarame aꞌmwere sɨvɨlatɨraalya pware atɨraalya (30) pɨnɨjɨ mena kwavɨlavaꞌ kɨrɨꞌ aꞌmwera yawɨꞌna “Sai Jozepɨyare gawaalɨkɨra.” Sahwai Yɨlaarelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Sahwai Maatatɨmɨrelyɨ. Sahwai Livaayarelyɨ. Sahwai Melɨkaarelyɨ. Sahwai Janaarelyɨ. Sahwai Jozepɨyarelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Sahwai Matataayazarelyɨ. Sahwai Emozɨmɨrelyɨ. Sahwai Nayaamɨmɨrelyɨ. Sahwai Ezɨlaarelyɨ. Sahwai Nahaarelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Sahwai Mayaatɨmɨrelyɨ. Sahwai Matataayazarelyɨ. Sahwai Semenɨmɨrelyɨ. Sahwai Jozekɨmɨrelyɨ. Sahwai Jotharelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Sahwai Jowaananɨmɨrelyɨ. Sahwai Rezarelyɨ. Sahwai Seravaavelɨmɨrelyɨ. Sahwai Sɨyalɨtiyalɨmɨrelyɨ. Sahwai Neraarelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Sahwai Melɨkaarelyɨ. Sahwai Ethaarelyɨ. Sahwai Kozaamɨmɨrelyɨ. Sahwai Elɨmathaamɨmɨrelyɨ. Sahwai Erɨmɨrelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Sahwai Jozuwaakɨrelyɨ. Sahwai Elɨyazarelyɨ. Sahwai Jorimɨmɨrelyɨ. Sahwai Maatatɨmɨrelyɨ. Sahwai Livaayarelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Sahwai Sɨmɨyonɨmɨrelyɨ. Sahwai Jutharelyɨ. Sahwai Jozepɨyarelyɨ. Sahwai Jonaanɨmɨrelyɨ. Sahwai Elaayakimɨmɨrelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Sahwai Melɨyarelyɨ. Sahwai Mennaamɨrelyɨ. Sahwai Matatarelyɨ. Sahwai Netaanɨmɨrelyɨ. Sahwai Devitɨmɨrelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Sahwai Jeziyarelyɨ. Sahwai Wovetɨmɨrelyɨ. Sahwai Bowaazarelyɨ. Sahwai Saalɨmonɨmɨrelyɨ. Sahwai Naazonɨmɨrelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Sahwai Aminɨthapɨmɨrelyɨ. Sahwai Athɨminɨmɨrelyɨ. Sahwai Anaarelyɨ. Sahwai Ezɨronɨmɨrelyɨ. Sahwai Perezarelyɨ. Sahwai Jutharelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Sahwai Jaikopɨmɨrelyɨ. Sahwai Aazakɨmɨrelyɨ. Sahwai Evɨraamɨmɨrelyɨ. Sahwai Teraamɨrelyɨ. Sahwai Naaworelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Sahwai Seruhɨmɨrelyɨ. Sahwai Rewɨmɨrelyɨ. Sahwai Pelehɨmɨrelyɨ. Sahwai Evemɨrelyɨ. Sahwai Selaamɨrelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sahwai Kainaanɨmɨrelyɨ. Sahwai Aapakɨzathɨmɨrelyɨ. Sahwai Samɨmɨrelyɨ. Sahwai Nowaarelyɨ. Sahwai Lamekɨmɨrelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Sahwai Metuzalaamɨrelyɨ. Sahwai Yɨnokɨmɨrelyɨ. Sahwai Jaaretharelyɨ. Sahwai Maalalelɨmɨrelyɨ. Sahwai Kainaanɨmɨrelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Sahwai Yɨnozarelyɨ. Sahwai Satarelyɨ. Sahwai Aataamɨmɨrelyɨ. Sahwai Gotɨyarelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kurya Tewaanyai Jizaazarɨ yuneba wɨlamwaaidɨꞌnyɨ Aalya Jothanɨyavɨ yagalyaꞌmaꞌna yɨna yaka ayɨna kaanna wɨna. Sarevɨ aꞌmwamaayabanna Kurya Tewaanyai sahwarɨ yɨbwarɨdaakuna yadaaꞌnyɨ ");
INSERT INTO byr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","sai aꞌmwera mamwaalyɨgata dazaba mwaalɨna yadɨꞌnyɨ yɨrɨka aꞌmwe pwaraare sɨvɨla atɨraalya (40) bwodaaꞌnyɨyagaaꞌ Kotɨya Maryadei kayaaꞌnanyaꞌna yaamɨjɨ walapapalakɨna. Yaamɨjɨ walapapalakɨna yadaaꞌnyɨyagaaꞌ sai wapaaya aane kɨrɨꞌ pɨrɨꞌ tɨka manyɨ kyaꞌ dɨvidaaꞌnyɨ mɨjɨka wina. ");
INSERT INTO byr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mɨjɨka wina yadaaꞌnyɨ sagaaꞌ Kotɨya Maryadei wɨdɨna “Nabaai gɨmɨ ‘Gotɨyare Gawaalɨvaangeinyɨ daakajɨ,’ yɨ sɨla dazarɨ duthana! ‘Sɨlyaꞌgɨ bɨretɨya jɨmaꞌnana!’ ” ");
INSERT INTO byr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Wɨdɨna kyaꞌ Jizaazai jaꞌnawɨdɨna “Bukuyaꞌ dara dɨnɨꞌ ‘Yune bɨretɨyaꞌnanyaꞌ saꞌ aꞌmwerɨ gaala yɨnɨga wɨjaavadeꞌ mɨka! (Aꞌmwerɨ kuryarɨ yɨvaimwagatheꞌ mɨꞌ!)’ ” ");
INSERT INTO byr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Miꞌna wɨdɨna kyaꞌ mugunya naangevɨna makilaawɨna yaka sareꞌ yɨmeꞌnyaꞌbɨꞌ Kwaakevakɨya maremwaaidɨvɨta kingɨyaraavɨne yuya sangɨ wibwarɨdaakuna. ");
INSERT INTO byr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Yɨna yaka Kotɨya Maryadei wɨdɨna “Maremwaaidɨvɨta yuya dɨragɨnya daza gɨmɨnyɨ gɨzaavɨdeinyɨra. Dazahɨnɨngɨne byaanna dɨragɨnyajɨ gɨzaavɨdeinyɨ. Yuya gɨthɨwe daza nɨmɨre yuya mena yɨmaꞌnɨnɨkengɨra. Sareꞌna nɨmɨ ‘Aꞌmwe pwarɨ wɨjaavɨma!’ dɨwɨjaꞌ, yɨ nɨmɨ wɨjaavɨna yɨdeinyɨra. ");
INSERT INTO byr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nabaai gɨmɨ walarutaꞌnaꞌdɨzaigɨ nɨmɨnyɨ lotuya nyɨmaryɨjaigɨ sarevɨdaaꞌnyɨ yuya daza gɨmɨre yɨmaꞌnadengɨra.” ");
INSERT INTO byr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sara wɨdɨna kyaꞌ Jizaazai wɨrɨvɨkɨꞌna “Bukuyaꞌ dara dɨnɨꞌ ‘Gɨmɨ Naangerɨ gɨmɨre Gotɨyarɨ yɨlaaya nayaa dumarya! ‘Yune gave sahware wawɨnyanna nayaa lɨmwagaꞌna jɨtheigɨnyɨ.’ ” ");
INSERT INTO byr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Wɨdɨna kyaꞌ Jeruzaalemɨna yɨbwarɨdaakuna yɨna yaka Gotɨyare Angevɨ yuna munya keꞌbevanna yɨlamarakaawɨna yaka wɨdɨna “Nabaai gɨmɨ ‘Gotɨyare Gawaalɨvaangeinyɨ daakajɨ,’ davadaasɨ kewɨnɨnna dɨthɨkwosɨka! ");
INSERT INTO byr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sareꞌ dareꞌnesɨ. Bukuyaꞌ dara dɨnɨꞌ ‘Gamɨre ejelɨyaraavɨ kudozɨ gɨmɨnyɨ nayaa gɨmaremwaaibɨꞌderera.’ ");
INSERT INTO byr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nabaai ‘Sɨla pwai gɨmɨre sɨvɨlyarɨ nagɨmwinadɨka! ‘Sahwara kumɨre asajɨ maragɨlɨmwagapɨꞌderera.’ Sara dɨnɨkeꞌnesɨ.” ");
INSERT INTO byr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sara wɨdɨna kyaꞌ Jizaazai jaꞌnawɨdɨna “Yagaalyaꞌ dara dɨnɨꞌ ‘Gɨmɨ Naangerɨ gɨmɨre Gotɨyarɨ yaamɨjɨ minnera! Gotɨyare sɨmunyaꞌ waꞌdori yune gɨnnya sɨmunyavɨdaaꞌnyɨ sara minnera!’ Sara dɨnɨkesɨ.” ");
INSERT INTO byr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Miꞌna wɨdɨna kyaꞌ Kotɨya Maryadei walapapalakya dala pɨnɨnnanya yaamɨjɨ mena yaka Jizaazarɨ yagalyaꞌmaꞌna yaka pɨgaaꞌnei yemwaaina yaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kurya Tewaanyare dɨragɨnyavɨ Jizaazai Galɨlinei ayɨna wɨna yaꞌ. Sarevɨdaaꞌnyɨ gamɨnyɨne yagaalyaꞌ anga saba yuyaba yɨꞌnamaryaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sarevɨ yuyagaaꞌ aꞌmweraavɨ kumɨre lotuangengɨ wɨjɨwaakɨna. Sara wɨjɨwaakɨna yadaaꞌnyɨ aꞌmwe yuyara gamɨnne yayaꞌ byaannakeꞌ munyaba makina yadɨvɨkɨ. ");
INSERT INTO byr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jizaazai Naazaretɨnei kaanna wɨna. Sɨnnawɨ maalɨkegaaꞌ, sai anga naanga dazaba mwaalakelyɨ. Sara mwaalaka naanga yɨmaꞌnakelyɨ sahɨba. Sai yuyagaaꞌ yadevaaibɨꞌna kwazaakegaaꞌ lotuangevɨ wɨlaawɨna. Wɨlaawɨna yaka Gotɨyare yagaalyaꞌ tɨnna danganyaꞌnei daavɨna. ");
INSERT INTO byr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Sarerɨ bukuya pɨropetɨya Aazaayai wɨjaakeꞌ dɨnɨkeꞌ wɨjaavɨna. Wɨjaavɨna kyaꞌ bukuyaꞌ maratɨlaayɨna yaka yagaalyaꞌ dara yɨdaꞌnɨkevɨ wanganna ");
INSERT INTO byr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Naangere Kuryai nɨmɨnyɨ nyɨmwaalɨka. Sarevɨdaaꞌnyɨ gɨlyɨvɨꞌmaayaraavɨna yagaala tewaanyaꞌ wɨjɨwaakyaꞌneinyɨ Welivananyaꞌ dɨngɨna nyadevɨ nɨmɨnyɨ nyɨdahɨlakakeinyɨ. Kalavuzɨyaraavɨ dara wɨjɨwaakyaꞌneinyɨ nyɨmaryasaabakeinyɨ ‘Kalavuzɨwawɨnyavɨ yagalyaꞌmavapi kaanya dɨwila!’ ‘Aꞌmwe tɨbɨnyaihi tɨnna ayɨna danganyɨla!’ Taanga yɨhyadeihi taanga saꞌ marasɨꞌnyaꞌneinyɨ Nayaa tewaanyaihi yɨhɨmwaaihyaꞌneinyɨ nyɨdasaabakeinyɨ. ");
INSERT INTO byr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Naangere tewaanyagaaꞌ na padaihasamaaryagaaꞌna wɨjɨwaakyaꞌneinyɨ.” Sara tɨnna wanganna, wɨdɨna yaka ");
INSERT INTO byr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","bukuyaꞌ marabukuꞌna yaka maremwaalyarɨ ayɨna wɨjaavɨna yaka wɨjɨwaakyaꞌnei walamwaaina. Sarevɨ aꞌmwe yuya lotuangevɨ mwaaidapiyara tɨnnyaꞌ yune gave sahwarɨna yɨꞌbwaranganna yesalyɨ. ");
INSERT INTO byr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Walamwaaina yaka sahwaraavɨ gaai wɨdɨna “Dahaasagaaꞌ Gotɨyare pɨkarya dazaꞌ yuna nebwina yɨmaꞌnɨwaka. Sarevɨ sarɨmɨ kadɨka mena wɨꞌnɨwaasagaaꞌ nebwina yɨmaꞌnɨwaka.” ");
INSERT INTO byr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sara wɨdɨna kyaꞌ sahwarɨne yayavɨ munyaba makidɨvɨꞌ yagaala nawɨꞌnya gamɨre maangikɨdaaꞌnyɨ wɨdakevɨna atɨka maruꞌnaꞌna yeva dɨnyɨna “Ai, aꞌmwe dazai Jozepɨyare kaimɨraayai midaaka!” ");
INSERT INTO byr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Dɨnyɨna kyeꞌ sahwaraavɨ wɨdɨna “Naanga nebulyasɨ. Sarɨmɨ yagaala keꞌbaꞌnanya dathaꞌ dɨnyɨjideinyɨ ‘Dotaigɨ gɨmɨre kɨlaakejɨkɨ nayaa javadaꞌgainadeigɨnyɨ.’ Anga Kaapanɨyamɨ yagɨnyabaaibɨꞌna, sa kadɨka mena wɨꞌnongɨ nabaai gɨmɨre anga dava gɨmɨre kɨlaakejɨꞌbɨsaba avaala sahɨbaaibɨꞌna ja!” ");
INSERT INTO byr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sara wɨdɨna yaka wɨdɨna “Nebulyaꞌna yɨhɨthɨvanɨge. Gannya angeba pɨropetɨya aane pwai kware yagaalyavɨ kadɨka muꞌnyadɨvɨsarera. ");
INSERT INTO byr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yɨthaanyi, naanga nebulyavɨnyɨ. Yɨhɨthɨvanɨge. Pɨropetɨya Yɨlaajaregaaꞌ Yɨzɨrelɨ saba yaanyɨwaaka kwalaalya mwalyaasangɨra. Dazagaaꞌ kwarame dawaai daꞌ yaka lawe ata purɨdaaꞌnyɨ puꞌna wavɨlaꞌdaaꞌnyɨ nyɨla naangegaaꞌ yada burɨka mi yada anga yuyaba yuneba mɨjɨka naangeꞌ yɨmaꞌnyɨna yaakegaakɨra. ");
INSERT INTO byr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kɨrɨꞌ Yɨzɨrelɨdaaꞌnya yaanyɨwaaka pɨrɨyawɨnna Gotɨyai Yɨlaajarɨ mamaryaasɨ yɨna yaꞌ. Aawa. Sai Sarepaatɨ Saaithonɨ sɨmagɨnnerɨ yune menyabanyaꞌ yaanyɨwaaka pɨrɨvɨ mɨjɨkeꞌna wɨgaimwagyaꞌnerɨ maryaasɨna. ");
INSERT INTO byr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Sabaaibɨꞌ Pɨropetɨya Yɨlaazare sahɨgaaꞌ Yɨzɨrelɨ saba aꞌmwe samatanaka kwalaalyara mwaalɨna yadapi kɨrɨꞌ sahwaraavɨ myavadaꞌgalawɨmwaaihi kyaaꞌ tewaanyara mimaꞌnyaasare. Aawa. Yune menyabanyarɨ Sɨrɨyadaaꞌnya Nemaanɨ sahwarɨ yavadaꞌgalawɨmwaaihɨna yaakelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jizaazai sara wɨdɨna kyaꞌ aꞌmwe yuyara lotuangevɨ mwaaleva yagaala savɨ kadɨka sara wɨꞌnyɨna yeva sɨnna tɨka yune davɨna. ");
INSERT INTO byr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Sɨnna tɨka yune davɨna kwiaꞌ daavɨna yeva anga naanga saba mwasɨlaa maryaasɨna. Kumɨre anga naanga dazaba mugunya pɨrɨvɨ yɨlamannaawodɨꞌnyɨyaba. “Davaanyavɨ kewɨnɨ sahwarɨ lɨvaramaana!” deva sahwarɨ kumɨre anga yɨlamannadɨꞌnyɨya davaamaangebaarɨ kaanya makuna. ");
INSERT INTO byr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kaanya makuna kyeꞌ kɨrɨꞌ sahwai kumɨnyɨ tɨnnyaba pɨraaihɨꞌnyɨna yaka kaanya mena wɨna. ");
INSERT INTO byr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sai Kaapanɨyamɨna walaawɨna. Anga naanga saꞌ Galɨli mannɨkesɨ. Walaawɨna yaka Juyaraavɨre kwazaakegaaꞌ wɨjɨwaakɨna yɨna. ");
INSERT INTO byr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sare savɨ sahwara kadɨka wɨꞌnyɨna yeva atɨka maruꞌnaꞌmuluna. Sai dɨragɨnya naangeꞌ kɨnɨnnakei wɨjɨwaakya nawɨꞌnyaꞌ wɨdakeꞌna atɨka maruꞌnaꞌmuluna. ");
INSERT INTO byr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lotuangevɨ aꞌmwe pwai mwaalɨna. Sahwarɨ yɨmakei wɨmwaaidɨꞌnyɨyalyɨ. Sai mwaalɨna yada jaka naanga danganna ");
INSERT INTO byr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Akai! Naazaretɨdaaꞌnyɨ Jizaazaigɨ, nemɨnyɨ gara yaꞌneigɨ bahɨneka? Nemɨnyɨ kayaaka neyɨgalyaꞌneigɨ bahɨneigɨ daaka? Gɨmɨnyɨna sɨmunya mena gyawɨꞌmwa. ‘Gɨmɨ Gotɨyare tewaanya nawɨꞌnyaangeigɨ daaka!’ yawɨꞌmwa!” ");
INSERT INTO byr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jaka sara danganna kyaꞌ kɨrɨꞌ Jizaazai maanga wɨdɨna “Yɨmakeigɨ maangeꞌ bɨpalaꞌgɨzɨ aꞌmwe sarɨ jahalyaꞌmakwona!” Sara maanga wɨdɨna kyaꞌ aꞌmweraayaba yɨmaka dazai aꞌmwe sarɨ kwaakewɨ yɨvatawakɨna yɨna yaka sarɨ kayaaka migalyɨ yaka sarɨ yagalyaꞌmakuna. ");
INSERT INTO byr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Sara yagalyaꞌmakuna kyaꞌ aꞌmwe yuyara lɨka yɨwainɨgulɨna yadɨvɨꞌ kumɨ sara dara dɨnyɨna “Yagaala sasare saꞌ be yagaalavaka? Aꞌmwe naangeibɨsai dɨragɨnnakei yɨmakeraavɨ dɨragɨnna wɨdɨwakeꞌ sahwara kadɨka wɨꞌneva aꞌmweraavɨ yagalyaꞌmaveva kaanna wɨwaasarera.” ");
INSERT INTO byr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sarevɨdaaꞌnyɨ Jizaazarɨne yagaalya dazɨmagɨ anga yuneba yamarina yaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sagaaꞌ Jizaazai daavɨna yaka lotuanga savɨ yagalyaꞌmaꞌna yaka Saaimonɨmɨre angevɨna wɨlaawɨna. Saaimonɨmɨre ganyaalɨmaangevɨ bɨꞌbɨꞌnalaayaꞌ wiadaaꞌnyɨyavɨ. Wɨlaawɨna kyaꞌ “Sahɨrɨvɨ wɨgaimwagana!” yawɨreva gamɨnyɨna yɨdaanganna. ");
INSERT INTO byr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yɨdaanganna kyeꞌ sahɨrɨyaba aya kɨba gaidavaabɨna yɨna yaka bɨꞌbɨꞌnalaaya saꞌ maanga wɨdɨna. Sareꞌ bɨꞌbɨꞌnalaaya saꞌ yagalyaꞌmakuna. Yuna sagaasagaaꞌ aꞌmwe dazaꞌ dɨkaaꞌna yɨna yaka kumɨnne wapaaya yovɨrawakɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nyɨlyai gaai walakyagaaꞌ Juyaraavɨre kwazaakeꞌ mena yɨwawakegaaꞌ sawɨtɨrɨnyaburɨ aꞌmwe kwɨyaꞌmwanakera nalaaya dala nabinabinyajɨyaraavɨ sahwaryawɨnna makabɨna. Miꞌna makabɨna kyeꞌ sai gamɨre asaꞌ aꞌba yɨlakadaaꞌnyɨ aꞌmwe yuya sare saraavɨ tewaanya ayɨna yavadaꞌgaina. ");
INSERT INTO byr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nabaai yɨmakera aꞌmwe kwalaalyaraavɨ yagalyaꞌmaꞌdɨvɨꞌ yuna kaanna wɨna. Yɨmaka dazara jaka naanga danganna “Gɨmɨ Gotɨyare Gawaalɨꞌgɨnyɨra.” Sahwara sɨduꞌnaka dareꞌna yawɨꞌdɨvɨsaꞌna “Sai Kɨraazɨtɨyai daaka! Gotɨyai dahɨlakaka maryasaabakei daaka!” jaka sara danganna. Jaka danganna yadaapɨjɨ sahwai mayagaala wɨdɨna kyaꞌ sahwara maanga bɨpaina yeva kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yɨrɨka gaai puꞌdaaꞌnyɨ anga saba yagalyaꞌmaꞌna yɨna yaka aꞌmwera mamwaalyɨgasɨmagɨnna kaanna wɨna. Kaanna wɨna kyaꞌ kwala bwaꞌnaanya sahwarɨna bɨrɨbɨrya yɨna yeva gamɨnyawɨnna yɨkuna. “Nemɨnyɨ neyagalyaꞌmavojɨ nawodɨka! Gamɨnyɨ dahalalɨmwagaana!” yawɨreva yɨkuna. ");
INSERT INTO byr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kɨrɨꞌ sahwai wɨdɨna “Gotɨyai maremwaaide yagaala tewaanyaꞌ anga naanga pɨbanyajɨ wɨjɨwaakɨma! Wawɨnya dazaꞌ yaꞌneinyɨ Gotɨyai nyɨdasaabakeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sarei nabaai Juyaraavɨre lotuangengɨ yagaalyaꞌ wɨjɨwaakɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pɨgaaꞌ aalɨbunya Ganezaaretɨ maangebaarɨ daavɨna. Aꞌmwe kwala bwaꞌnaanyaꞌ gamɨnyɨ yuneba gɨhɨpalemwaaina Gotɨyare yagaalyavɨna kadɨka wɨꞌnyaꞌnere. ");
INSERT INTO byr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aalɨbumaangebaarɨ botɨya pukaai waꞌdɨꞌnyɨ kɨrɨꞌ aꞌmwe jawɨnya maaryaꞌnera botɨyɨkaarɨ yagalyaꞌmaꞌna yɨna yeva jawɨnya mwagiꞌnyaꞌne jawɨgɨlya aalya lɨvayɨna yesarera. ");
INSERT INTO byr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Daavɨna yaka kwala bwaꞌnaanyaꞌ yuneba gɨhɨpalemwaalesaraavɨ tɨnna wanganna yada botɨya pukɨ dɨkwosɨꞌna. Botɨya sɨꞌ Saaimonɨmɨrikɨ. Sara yaka botɨyɨkɨ gyakwalaangerɨ wɨdɨna “Botɨya dɨkɨ kengina maalɨkɨbaweba jɨtawaasa!” Sagaaꞌ botɨyɨkɨ yɨlamwaaina yaka kwala bwaꞌnaanyangɨ wɨjɨwaakɨna. ");
INSERT INTO byr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yagaala mena wɨjɨwaakɨna yakegaaꞌ Saaimonɨmɨ wɨdɨna “Botɨyɨꞌ aalyavɨ tɨnnyaba pɨzɨꞌgwana jɨtavamakulaawa! Sara yaꞌgɨzɨ kɨrɨmɨ jawɨnya maaryaꞌne jawɨgɨlyaꞌ dakyɨla!” ");
INSERT INTO byr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sara wɨdɨna kyaꞌ Saaimonɨ wɨdɨna “Aꞌmwe naangeigɨ dahaaꞌ sawɨta darɨkɨ nemɨ yuyaina yagɨyagɨ wawɨnya yɨvanɨgoine. Sara yadaa kɨrɨꞌ jawɨnya aane pɨnɨ kɨnɨ maaꞌmanɨgoina mɨꞌ. Sareꞌ kɨrɨꞌ gɨmɨ dɨwaanyaꞌna jawɨgɨlyaꞌ marakɨma!” ");
INSERT INTO byr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sara yɨna yagɨla jawɨnya kwalaalya naanga bulaminyɨna yadaapiyagaaꞌ jawɨgɨlyaꞌ maramumwɨnyɨrɨjɨ yɨna. ");
INSERT INTO byr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sara kyaꞌ sagaaꞌ botɨya pukɨ mwaaidakiya kumɨjɨyaraarɨ jaka wɨdɨna yagɨla kɨrɨmɨnyɨ gaimwangeꞌna akwebwata yɨna kyagi sara yɨkabɨna kyagi botɨya sɨkaarɨ jawɨnya yunebanna yekuꞌnyɨna. Sagaaꞌ botɨya sɨkaai kewɨnɨ makwalaawɨjɨ yɨna. ");
INSERT INTO byr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sara yɨna yadaaꞌnyɨ Saaimonɨ Pitai tɨnna wanganna yaka Jizaazaryawɨ sɨvigɨꞌnyɨryawɨ walarutaꞌnyɨna yɨna yaka dɨna “Naangeigɨ, nɨmɨ kayaaꞌnanyabwi kɨnɨnnakeinyɨna nyagalyaꞌmavaꞌgɨzɨ dɨwona!” ");
INSERT INTO byr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sareꞌ dareꞌnesɨ. Sahwai jawɨnya yuya maareta sangɨ tɨnna wanganaka lɨka yɨwaainyɨna. Nabaai aꞌmwe gamɨjɨ yeꞌmwannamwaaleta kwarajɨ sara kwara lɨka yɨwaainyɨna. ");
INSERT INTO byr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nabaai sabaaibɨꞌ Sevathiyare kaimɨraayaraai Jemɨzalyɨ Jonɨjɨ saraai Saaimonɨmɨ yeꞌmwannayadisaraai kwaraalyɨ lɨka yɨwaainyɨna. Pitai lɨka yɨwaainyɨna yaka sara wɨdɨna. Sara wɨdɨna kyaꞌ Jizaazai Saaimonɨmɨ wɨdɨna “Lɨka minnera! Dahaaꞌdaaꞌnyɨ aꞌmweraavɨ gaala mwaalyaꞌneraavɨ maarɨ maarya jɨtheigɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wɨdɨna kyaꞌ maangebaarɨ tɨyawɨnna botɨyɨkaai yɨtavamakulaawɨna yɨna yeva yuya sa saba yovɨgaipwakɨna yeva sahwarɨ mɨdɨnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jizaazai anga naanga pɨba mwaaidɨꞌnyɨ, yɨthaa, aꞌmwe pwai gamɨre kɨlaakejɨkɨ yunebanna samate waꞌdɨꞌnyɨyai mwaalɨna. Sai mwaalɨna yaka Jizaazarɨ tɨnna wanganna, gamɨre sɨnnyɨkɨ kwadaai walarutaꞌnyɨna yaka sahwarɨ dɨragɨnna yɨdaanganna “Naangeigɨ, gɨnnya sɨmunyavɨ sara yawɨꞌdɨzaꞌ yɨnɨga wiꞌna tewaanya nyavadaꞌgaidɨnneigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sara yɨdaanganna kyaꞌ asaꞌ yɨwɨbwaꞌna yaka sahwarɨ asaꞌ dathɨwanna yaka wɨdɨna “Sɨmunyavɨ sara yawɨꞌmwa. Tewaanya jɨmaꞌnana!” Sara wɨdɨna kyaꞌ yɨmeꞌnyaꞌbɨꞌ samate saꞌ mena yɨwɨna. ");
INSERT INTO byr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mena yɨwɨna kyaꞌ “Aꞌmwera nɨmɨnyawɨnna yaasɨwaꞌna nabɨpɨdɨka!” daka dɨragɨnna wɨdɨna “Sarevɨ aꞌmwe aane pwai kwarɨ nujɨwaakɨdɨka! Aawa. Gɨmɨre kɨlaakejɨꞌ Gotɨyarɨna mubɨthɨka yɨraꞌderɨ pɨrizɨyarɨ duzɨwainaawa! Sara yaꞌgɨzɨ Mozɨzai dakabaaibɨꞌ yɨraꞌnadeꞌ dɨka nasɨꞌnade gɨmɨnyɨna girayadelyɨra. Sarevɨdaaꞌnyɨ aꞌmwera gyawɨrangabɨꞌderera ‘O, sare samateꞌ mena jɨwɨwaka!’ ” ");
INSERT INTO byr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sara dɨragɨnna wɨdɨna kyaꞌ kɨrɨꞌ sanna yɨhusɨnna yɨnnagɨꞌmavaka kuna naangeba yɨꞌnamarina. Sara yadaaꞌnyɨ sarevɨdaaꞌnyɨ kwala bwaꞌnaanya kwalaalya gamɨnyawɨnna yɨkabɨna. Gamɨre yagaalyavɨ kadɨka wɨꞌnyaꞌnera kumɨre nalaaya marasɨꞌnyaꞌnajɨ yɨkabɨna. ");
INSERT INTO byr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yɨkabɨna yadaapi kɨrɨꞌ yuyagaaꞌ sai aꞌmwera mamwaalyɨgasaba woda gavei Gotɨyarɨ wɨdadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pɨgaaꞌ sai wɨjɨwaakɨna yadaaꞌnyɨ Perɨzɨya pwarajɨ kɨwɨnya dɨnɨkengɨna maremwaaidɨvɨsarajɨ sara mwaalɨna. Anga yuyabanyadaasɨ Galɨli sɨmagɨdaasɨ Juthɨya sɨmagɨdaasɨ Jeruzaalemɨ sɨmagɨdaasɨ yɨkabevere. Sarevɨ Naangere dɨragɨnyaꞌ Jizaazarɨ wɨlaꞌdɨꞌnyɨ nalaavɨnakeraavɨ tewaanya yavadaꞌgalyaꞌnei mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sara mwaalɨna yadɨꞌnyɨ, yɨthaa, aꞌmwe pwara aꞌmwe pwarɨ yɨꞌbɨnyavɨ makabɨna. Aꞌmwe dazare yagɨnya yuya mena bainɨkei. Sare sarɨna “Angevɨ marikwavamakulaawɨna yawaajɨ gamɨnyawɨ aya kɨba gidɨkuꞌnawakaana!” deva ");
INSERT INTO byr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","kɨrɨꞌ kwala bwaꞌnaanyaꞌna yesarera. Kwalaalyara mɨjahɨbalakɨna yadapi nalaavɨnaka sarɨ makulaawiaꞌne tutaanya aane pɨrɨꞌ minyadɨꞌnyɨ bɨrɨbɨrya yɨꞌmaareva. Sarevɨdaaꞌnyɨ angevɨ munyabanna bamaragaꞌnɨgilaawɨna yɨna yeva angevɨ munyabanna daburaabɨna. Mena daburaabɨna yeva yɨꞌbɨnyavɨ yɨlaꞌdɨꞌnyɨyarɨ maralaaꞌmwanna yɨna yeva wɨlyabaarɨ aꞌmweraayaba tɨnnyaba kewɨnɨ kave yɨbwaꞌmwagaasɨna yeva Jizaazarɨ kusɨmagɨ walakɨna. ");
INSERT INTO byr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Walakɨna kyeꞌ kumɨre gamɨnyɨneꞌna lɨmwanga saburɨ yawɨranganaka wɨdɨna “Aꞌmweigɨ, gɨmɨre kayaaꞌnanya mena gɨmarasɨꞌmwana.” ");
INSERT INTO byr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wɨdɨna kyaꞌ Kɨwɨjarajɨ Perɨzɨyarajɨ kumɨ sara yagaaikwalaalya dɨnyɨna “Aꞌmwe dazai yuna bewai dɨngaka! Gotɨyarɨna yagaaibɨraizɨka yɨvanɨka sala! Kayaaꞌnanya sangɨ yɨnahu marasɨꞌnadei aꞌmwei pwai mɨka. Saꞌ Gotɨyai wawɨnyaꞌ yune gave sahwaresɨra.” ");
INSERT INTO byr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Dɨnyɨna yadaapi Jizaazai kumɨre sɨmunya yawɨꞌdaapiyangɨ mena yawɨranganna yaka kumɨnyɨ dara jaꞌnawɨdɨna “Sarɨmɨre sɨmunyangɨ sɨmugwalaalya yaasɨwaꞌna yawɨꞌmanɨgasaꞌ beꞌneka! ");
INSERT INTO byr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kaveya yaꞌne pɨrɨwaai berɨwaalaka! Nabaai nɨmɨ dɨwɨjaꞌ dɨngaka? ‘Gɨmɨre kayaaꞌnanya mena marasɨꞌmwana?’ Nabaai nɨmɨ dɨwɨjaꞌ dɨngaka? ‘Gɨmɨ daavaꞌgɨzɨ kaanya dɨwona?’ Aawa. Yuyawaai naangewaalyɨ. ");
INSERT INTO byr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kɨrɨꞌ sarɨmɨnyɨna ‘Sahwara nayaa dara yawɨpɨka! “Aꞌmweraavɨne Kaimɨraayai Kwaaka davakɨneꞌna kayaaꞌnanyanna yɨnɨga wiꞌna marasɨꞌnyaꞌnei dɨragɨnya kɨnɨnnakelyɨ,” ’ dena yɨma!” Aꞌmwe gannya yagɨnya yuya mena bainɨka sarɨ dara wɨdɨna “Gɨthɨwa. Gɨmɨ daavaꞌgɨzɨ gɨnnya yɨꞌbɨnyaꞌ maaraꞌgɨzɨ gɨnnya angevɨneigɨ kaanya dɨmakwona!” ");
INSERT INTO byr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sara wɨdɨna kyaꞌ aꞌmwe dazaraavɨre tɨnnyarɨ yuna sagaasagaaꞌ sai daavɨna yaka kɨgaaꞌ yɨlarakeꞌ maarɨna yɨna yaka gannya angevɨna kaanna wɨna. Sarevɨ sai Gotɨyarɨne yayaꞌ munyaba makina yada kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kaanna wɨna kyaꞌ yuyara atɨka maruꞌnakulɨna yeva Gotɨyarɨne yayaꞌ byaannakeꞌ munyaba makina yadɨvɨꞌ lɨka yɨwainɨgulɨna yeva dɨna “Dahaaꞌ nemɨ nabinya pɨburɨ wangamwona!” ");
INSERT INTO byr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Dɨvidaaꞌnyɨ yagalyaꞌmaꞌna yada taakɨzɨya maaꞌdɨvɨta angevɨ taakɨzɨya maaꞌde pwai Livaayai woꞌnɨkei mwaaidɨꞌnyɨyarɨ tɨnna wangamabɨna yaka wɨdɨna “Dɨnyɨmɨdɨnaama!” ");
INSERT INTO byr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Wɨdɨna kyaꞌ daavɨna yaka yuya sa saba yagalyaꞌmawakɨna yɨna yaka Jizaazarɨ mɨdɨnyɨna. ");
INSERT INTO byr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sara yakei Livaayai gannya angevɨ gamɨnyɨne tɨka wapaaya yɨdɨka naanga yɨna. Aꞌmwe taakɨzɨya maaꞌdɨvɨta kwalaalyarajɨ aꞌmwe kwalaalya pwarajɨ walamwaaina yɨna yeva saraalyɨ tɨka wapaaya yeꞌmwannanyɨna. ");
INSERT INTO byr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Sahwarajɨ yeꞌmwannanyɨna yadaapi Perɨzɨyarajɨ kumɨrera Kɨwɨjarajɨ sara gamɨre mɨdɨdɨvɨsaraavɨ maamayagaala wɨdɨna. Sahwara wɨdɨna “Aꞌmwe taakɨzɨya maaꞌdɨvɨsarajɨ gɨrɨkitaꞌnanyarajɨ sarɨmɨ tɨka wapaayajɨ aalyajɨ beꞌna yeꞌmwannanɨvanɨgava!” ");
INSERT INTO byr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Maanga wɨdɨna kyeꞌ Jizaazai wɨrɨvɨkɨꞌna “Aꞌmwe maamɨdaryara dotaayaraavɨna wɨgainadera mɨka. Aawa. Yune nalaavɨnaka sarana wɨgainadere. ");
INSERT INTO byr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nɨmɨ aꞌmwera ‘Nemɨ yɨdaꞌmaraangeinera,’ dɨdɨvɨsara sɨmunya mudɨkeꞌ yawɨramaapɨkajɨ jaka jɨvwaramaaryaꞌneinyɨ bɨweinyɨ mɨka! Aawa. Aꞌmwe gɨrɨkitaꞌnanyara sɨmunya mudɨkeꞌ yawɨpɨꞌdeꞌna jaka jɨvwaramaaryaꞌneinyɨ bɨweinyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sagaaꞌ gamɨnyɨ dara wɨdɨna “Jonɨmɨrera tɨka munnengɨ kɨmaakɨya dakadɨvɨsare. Sara yadɨvɨꞌ Gotɨyarɨ saamɨnyagaaꞌ wɨdadɨvɨsare. Sabaaibɨꞌ Perɨzɨyainaavɨre kwarajɨ avaala sara yadɨvɨsare. Sareꞌ kɨrɨꞌ gɨmɨrera kɨmaakɨya madakyadɨvɨꞌ tɨka wapaayajɨ aalyajɨ tɨka nɨvanɨgave!” ");
INSERT INTO byr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sara wɨdɨna kyeꞌ Jizaazai sahwaraavɨ wɨdɨna “Mudɨkangegaaꞌ aꞌmwe pwaraavɨre kwɨyaꞌmwei kwala maaryaꞌnei aꞌmwe dazai sarajɨ kuna yeꞌmwannemwaaidori sarɨmɨ tɨka munne yɨnɨga kɨmaakɨya dakɨpɨneihi daaka! Aawa. ");
INSERT INTO byr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kɨrɨꞌ dɨvi sagaaꞌ kumɨnyɨ aꞌmwe kwala maaryaꞌne dazarɨ kipalamakwopɨjɨ yɨ dazagaaꞌ kuna tɨka munne kɨmaakɨya dakɨbɨꞌderera.” ");
INSERT INTO byr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wɨdɨna yaka keꞌbaꞌnanyaꞌ sahwaraavɨ wɨdɨna “Baazɨꞌmaꞌnya gaalyavɨdaaꞌnyɨ pɨmɨlɨꞌ davamaarojɨ baazɨꞌmaꞌnya lihɨꞌnɨka yawakevɨ mɨwɨryaꞌnei aꞌmwei aane pwai kwai mɨka! Aawa. Aꞌmwe pwai sasara yajaꞌ baazɨꞌmaꞌnya mudɨkeꞌ kayaaka yɨgaladelyɨ. Nabaai kwaabɨyɨvɨta davamaaraja gaala mudɨkemɨlɨꞌ baazɨꞌmaꞌnya yawaka dazaꞌbɨꞌ avaaina wannadewaai mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nabaai aꞌmwe aane pwai kwai aalya waainɨya mudɨkeꞌ meme kɨlaaka aya yawakevɨ maradɨngiꞌdei mɨꞌ. Aawa. Pwai sara yajai waainɨya gaala mudɨkeꞌ aalɨmaagwala bilamariꞌbwarakada kɨlaakeꞌ maramumwɨnyɨrojɨ kwaakevakɨna bwaladɨmaꞌnaawɨna. Sara yojɨ nabaai meme kɨlaaka kɨrɨsɨ kayaaka yɨnyɨna. ");
INSERT INTO byr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kɨrɨꞌ aꞌmwei meme kɨlaaka yune gaala mudɨkevɨna waainɨya gaala mudɨkeꞌ maradɨngikadelyɨ. Yɨ tewaanyasɨ.” ");
INSERT INTO byr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Gamɨre wɨjɨwaakya mudɨkevɨna sai wɨdɨna “Nabaai yuyagaaꞌ aꞌmwei aalya waainɨya aya yawakeꞌ mena nadei aalya mudɨkeꞌna wɨvuꞌnadeꞌ mɨꞌ. Sareꞌ dareꞌnesɨ. Yuyagaaꞌ aya yawakeꞌna yawɨꞌna yada dadelyɨ ‘Aya yawakeꞌ waburyasɨra.’ ” ");
INSERT INTO byr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kwazaaka pɨgaaꞌ witɨwawɨnyavɨ tusavɨ kaanya yamarina yadaaꞌnyɨ gamɨre mɨdɨdɨvɨsara witɨzɨla pɨnɨ gimujɨna yɨna yeva kumɨre asangɨ lɨlɨvɨwanna yeva tɨka nyɨna. ");
INSERT INTO byr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tɨka nyɨna kyeꞌ kɨrɨꞌ Perɨzɨya pwara dɨna “Gimujɨna yeva lɨlɨvɨwanna yɨwaasaꞌ Kwazaakegaaꞌna kɨmaakesɨra. Sarɨmɨ beꞌna yɨvanɨgava!” ");
INSERT INTO byr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sara dɨna kyeꞌ Jizaazai wɨrɨvɨkɨꞌna “Ne Devitɨ yaka dazanna pɨkarya dɨnɨkevɨ madanganyadɨvɨtaihi daaka! Dɨvanɨge dazagaaꞌ sahwalyɨ gamɨrerari saraavɨ mɨjɨka yesagaaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devitɨ Gotɨyare Angevɨ wɨlaawɨna yɨna yaka bɨretɨyaꞌ Gotɨyaryaba wakyaasaꞌ maarɨna yaka tɨka nyɨna. Bɨretɨya dazaꞌ aꞌmwe yuyaraavɨna kɨmaakɨya dakɨnɨkesɨ. Yune pɨrizɨyarana tɨka nyaꞌnesɨ. Yɨ sareꞌ kɨrɨꞌ Devitɨ tɨka naka gamɨre kwaraavɨjɨ wɨjayaakesɨ. Dazahɨrɨvɨ madanganyadɨvɨtaihi daaka! Sai yaasɨwaꞌna manyaakeꞌna Gotɨyai maanga majaakelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wɨdɨna yaka wɨdɨna “Aꞌmweraavɨne Kaimɨraayai kwazaakegaaꞌne Naangelyɨ. (Kwazaakevɨ ‘Saꞌ nawɨꞌnyabulyɨ. Saꞌ kayaaꞌnanyabulyɨ,’ dakannelyɨ.)” ");
INSERT INTO byr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kwazaaka pɨrɨkɨ Juyaraavɨre lotuangevɨ wɨlaawɨna yaka aꞌmweraavɨ yagaalyaꞌ wɨjɨwaakɨna. Sagaaꞌ aꞌmwe pwai gamɨre aangasɨmagɨnya asi yaalɨka yɨnnɨkei mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sarei mwaalɨna yadɨꞌnyɨ Kɨwɨjarajɨ Perɨzɨyarajɨ Jizaazarɨ yawɨrabanganaꞌna. “Yawɨranganaana! Kwazaakegaaꞌ nalaavɨnakeraavɨ tewaanya yavadaꞌgaladei dɨngaka? Sara yajaꞌ kotɨyaꞌ maryaꞌneina yaana!” deva yawɨrabanganaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sara yadaapi kɨrɨꞌ kumɨre sɨmunyangɨ mena yawɨranganna yaka aꞌmwe dazarɨ asi yaalɨka yɨnnɨkerɨ wɨdɨna “Gɨmɨ daavaꞌgɨzɨ tɨnnyaba dɨthaaka!” Wɨdɨna kyaꞌ sai dɨkavedaaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sara yɨna kyaꞌ Jizaazai kumɨnyɨ wɨdɨna “Yɨhithaanganɨdeꞌnanyɨra ‘Nabaai kwazaakegaaꞌ tewaanyabwina yadaanyaꞌ yɨdaꞌnanyaꞌ dɨngaka? Kayaaꞌnanyabwina yadaanyaꞌ yɨdaꞌnanyaꞌ dɨngaka? Nabaai aꞌmweraavɨ padaihasamaꞌdaanyabwineꞌ dɨngaka? Aꞌmweraavɨ kayaaka yɨgaidaanyabwineꞌ dɨngaka?’ ” ");
INSERT INTO byr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wɨdɨna yaka aꞌmwe yuyaraavɨ tɨnna wanganamarina yaka aꞌmwe dazarɨ wɨdɨna “Gɨmɨre asaꞌ jɨwɨbwaka!” Wɨdɨna kyaꞌ aꞌmwei sara yɨna kyaꞌ gamɨre asaꞌ ayɨna maamɨdarya yɨmaꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yɨmaꞌnyɨna kyaꞌ kɨrɨꞌ sahwara sɨnna tɨka yuna naanga davɨna yadaaꞌnyɨ kumɨ sara dɨnaawɨna “Nemɨ Jizaazarɨ gara yaadeinaavaka?” ");
INSERT INTO byr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Dazagaaꞌ “Nɨmwarɨna wɨdɨma!” daka mugunyavɨna yɨlaawɨna yɨna yaka Gotɨyarɨ wɨdɨna. Sawɨta dazagaasa sarɨkɨ Gotɨyarɨna kuna yɨdangadaaꞌnyɨ yune yɨrɨkeꞌna mɨdaihɨrakɨna. ");
INSERT INTO byr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nyɨlyai bilyɨrɨꞌna kyaꞌ gamɨre mɨdɨdɨvɨsaraavɨ jaka wɨdɨna kyaꞌ yɨkabɨna. Sara yɨkabɨna kyeꞌ sahwarajɨya sɨvɨlɨrɨdaaꞌnyɨ pwaraalyaraavɨ dahɨlakɨna yɨna yaka “Yayaꞌ Apozelɨyaihɨlyɨ. (Nɨmɨre yagaalyaꞌna yɨhɨthaasɨdeihɨlyɨra,)” wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Pwai Saaimonɨnyɨ. Sarei sarɨ Jizaazai “Pitaigɨnyɨ,” yaya saꞌ wɨdɨna. Nabaai Edɨruyai, Saaimonɨmɨ gahwaalaangelyɨ. Nabaai Jemɨzalyɨ Jonɨjɨ Pilipɨjɨ Baatolomyulyɨ ");
INSERT INTO byr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matɨyulyɨ Tomaazalyɨ. Nabaai Jemɨzai Alɨpɨyaazare gawaalɨkɨ. Nabaai Saaimonɨ yaya pɨrɨꞌ Selotɨma woꞌnɨkelyɨ. (Selotɨ - gannya kwaakevakɨna yawɨꞌdei.) ");
INSERT INTO byr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Nabaai Juthaazai Jemɨzare gawaalɨkɨ. Nabaai Juthaazai Yɨzɨkerɨyotɨyalyɨ. Dɨvidaaꞌnyɨ sai Jizaazarɨ gamɨre yɨkamaangeraavɨna wibwarɨdaakwiai yɨmaꞌnakelyɨra. ");
INSERT INTO byr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Dahɨlakakegaaꞌ kewɨnɨ kumɨjɨ yeꞌmwannɨgwalaawɨna yeva kwaaka waraasaba daavɨna. Sahɨba gamɨre pwara kwalaalyarajɨ aꞌmwe kwala naangera, yuya Juthɨya sabadaasarajɨ Jeruzaalemɨdaasarajɨ saalaalyavɨ maangebaarɨ Anga Taayaajɨ Anga Saaithonɨjɨ sawaarɨ aya kɨbadaasarajɨ mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Gamɨre yagaalyavɨ kadɨka wɨꞌnyaꞌnera “Sahwai nemɨre nalaaya nemarasɨꞌnadeꞌnana! Nemɨnyɨ pwaraavɨ, yɨmakera taanga wɨjaayaraavɨ yɨmakeraavɨ wɨdaasadeꞌnana!” yawɨreva yɨkabɨna. Sarera yɨkabɨna kyeꞌ tewaanya yavadaꞌgaina. ");
INSERT INTO byr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sagaaꞌ gamɨre dɨragɨnyaꞌ yɨna yaka yuyaraavɨ tewaanya wimaꞌnakeꞌna kwala bwaꞌnaanyaꞌ yuyara “Gamɨnyɨ yune asaꞌna kimeꞌnawaajɨ tewaanya neyavadaꞌgaladeꞌnana!” Sara deva sara yeva tewaanya mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Gamɨre mɨdɨdɨvɨsaraavɨ tɨnna maranganna yɨna yada wɨdɨna “Yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkeihɨlyɨ gɨlyɨvɨꞌmaayaihi. Gotɨyai maremwaaidevɨ sarɨmɨ sahwaihɨre warɨkeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkeihi, Dahaaꞌ mɨjɨka yɨhivanɨkeihi Dɨvi yunebanna napɨjɨ Sarɨmɨnyɨ munya yɨhinadeꞌnanyɨ. Yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkeihi, Dahaaꞌ kɨnna dɨwaainɨvanɨgasaihi Dɨvidaaꞌnyɨ jɨka dɨhideꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Aꞌmweraavɨne Kaimɨraayainyɨ nyɨmɨdɨdaapiyaꞌna aꞌmwera sarɨmɨnyɨna sɨmɨlɨka wɨladere. Sara kwɨyojɨ sarɨmɨnyɨ yɨhɨthaasadɨvɨꞌ navaruyagaala yɨhɨthadɨvɨꞌ sarɨmɨnyɨne yaya yuna kayaaꞌna marihɨlaasɨna yɨhipɨꞌdere. Nɨmɨnyɨneꞌna sara kihyapɨjɨ sare saꞌna yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkeihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sagaaꞌ sasare saꞌ yɨhipɨjaꞌ yɨ yɨlaaya naanga yadɨvɨꞌ yɨlaaya nebwina kwarame jideihɨlyɨ. Yɨthaanyi! Sareꞌ dareꞌnesɨ. Sɨgunyavɨ Gotɨyaryaba sarɨmɨre wɨrɨvɨkɨsaꞌ yuna naangesɨ. Nabaai sareꞌ dareꞌnesɨ. Sɨnnawɨ kwɨyakwarava kuvɨdaarava Gotɨyarɨ wɨꞌnawɨjɨwaakadɨvɨsaraavɨ pɨropetɨyaraavɨ avaaina sasara yaasare tɨvɨkɨta nawɨꞌnya maaryaꞌneraavɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Sare kɨrɨꞌ ‘Weꞌ! Gɨlyɨvɨꞌnakeihi sɨmunyangɨ tewaanya yɨhyaꞌne Sarɨmɨ mena maaresaꞌna mala nayaa jɨwannyɨla! Sareihi Gotɨyarɨ myawɨryaꞌneihi taanga wɨjaavɨna yɨhyadeihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Weꞌ! Dahaaꞌ yunebanna neva munya yɨhimwakeihi Dɨvidaaꞌnyɨ mɨjɨka yɨhyadeꞌna sarɨmɨ mala jɨwannyɨla! Sareihi Gotɨyarɨ myawɨryaꞌneihi taanga wɨjaavɨna yɨhyadeihɨlyɨ. Weꞌ! Dahaaꞌ jɨka givanɨgasaihi mala jɨwannyɨla! Dɨvidaaꞌnyɨ kɨnna dadɨvɨꞌ kɨdaraalya naanga bwalayɨhɨravaawadengɨ, Sareihi Gotɨyarɨ myawɨryaꞌneihi taanga wɨjaavɨna yɨhyadeihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Weꞌ! Yuyara sarɨmɨnyɨne yaya munyaba makibɨzaꞌna yɨ nabaai mala jɨwannyɨla! Sareꞌ dareꞌnesɨ. Sɨnnawɨ kwɨyakwarava kuvɨdaarava pɨropetɨya kwaasɨyaraavɨne yaya munyaba avaaina sasara makɨlyaasare tɨvɨkɨta kayaaꞌnanya maaryaꞌneraavɨna.’ ");
INSERT INTO byr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kɨrɨꞌ nɨmɨre yagaalyaꞌ kadɨka nyuꞌnɨvanɨgasaihɨrɨ yɨhɨthɨvanɨge. Sarɨmɨre yɨkamaangeraavɨna kale yɨhyana! Aꞌmwera sarɨmɨnyɨna sɨmɨlɨka widaaworiyaraavɨ tewaanyabwina jideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aꞌmwera sarɨmɨnyɨ paasɨyagaala yɨhɨthɨpɨjaraavɨ gaimwangebwina duzideihɨlyɨ ‘Gotɨyai tewaanna yɨhyana!’ Aꞌmwe bɨraiyagaala yɨhɨthɨpɨjaraavɨ gaimwangeꞌna Gotɨyarɨ duzideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nabaai aꞌmwe pwai gɨmɨre maangwɨdaanya pimagɨ kagɨramojɨ yɨ gɨmɨre maangwɨdaanya pimagɨ tamyaꞌna gɨnyɨwannyɨna jɨtheigɨnyɨ. Aꞌmwe pwai gɨmɨre yɨvɨsaꞌ kagɨmwagiꞌnojɨ gɨmɨre baazɨꞌmaꞌnyaꞌ maarajaꞌna kɨmaakɨya madakɨnnera! ");
INSERT INTO byr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nabaai gazaizai gɨlyɨvɨta pɨnɨnna kagithaanganojɨ sarɨ wɨjaavɨna jɨthelyɨ. Aꞌmwe pwai gɨmɨre gɨlyɨvɨsa kagɨmaarojɨ ‘Ayɨna dɨnyɨjaama!’ dɨragɨnna mudangadɨnna! ");
INSERT INTO byr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sasare sabwi sarɨmɨ yawɨꞌdɨvɨsabwina ‘Aꞌmwera sara nyɨpɨka!’ dapi sasare sahɨbaaibɨꞌ kumɨnyɨ sara jideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nabaai sarɨmɨnyɨna kale wiadevaaibɨꞌ sarɨmɨ aꞌmweraavɨna kale yɨhyajaꞌ Gotɨyarɨ sarɨmɨnyɨ yanga gaimwanga yaꞌne benɨ dɨmaaryideihɨlaka! Sareꞌ dareꞌnesɨ. Aꞌmwe kayaaꞌnanya kwarajɨ sahwaraavɨna kale wiade saraavɨna kale wiadere. Sareihi sahwaraavɨ wavɨlaꞌmanɨgasaihi daa! ");
INSERT INTO byr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Sareꞌ dareꞌnesɨ. Sarɨmɨ aꞌmwera tewaanna yɨhipɨjaraavɨ tewaanyabwina wiadɨvɨꞌ sarɨmɨnyɨ gaimwanga yaꞌne benɨ dɨmaaryideihɨlaka! Yɨ aꞌmwe kayaaꞌnanya sara kwarajɨ sasare sabwi yɨna yadɨvɨsare. ");
INSERT INTO byr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Sarɨmɨ gɨlyɨvɨta yaamata wɨjaayaꞌneihi yawɨꞌna ‘Sa ayɨna nyɨjaavadelyɨ,’ Gotɨyarɨ sarɨmɨnyɨ gaimwanga yaꞌne benɨ dɨmaaryideihɨlaka! ‘Avaalya ayɨna maarɨma!’ dadɨvɨꞌ kayaaꞌnanya kwarajɨ kayaaꞌnanya kwaraavɨ yaamata wɨjaavadɨvɨsare. ");
INSERT INTO byr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Sare kɨrɨꞌ sarɨmɨ sarɨnnya yɨkamaangeraavɨna kale yɨhyana! Sahwaraavɨ nayaa tewaanyabwina jɨla! Aꞌmweraavɨ gɨlyɨvɨta yaamata nayaa duzaayɨla! ‘Ayɨna nyɨrɨvɨkɨpɨꞌdengɨra,’ sanna sɨmunya nyawɨpɨdɨka! Sarɨmɨ sara yɨpɨjaꞌ, Gotɨyaryaba sarɨmɨre wɨrɨvɨkɨsaꞌ yuna naangesɨ. Nabaai sarɨmɨ Gotɨya Munya Keꞌbevanyare kaimɨraayaihi dɨmwaalyideihɨlyɨ. Sahwai aꞌmwera gamɨnyɨ ‘Su! Su!’ mujadɨvɨsaraavɨ aꞌmwe kayaaꞌnanya kwaraavɨ naangeꞌna wiadeꞌnanyɨ. Sarei yadevaaibɨꞌ tewaanna yɨpɨjaihi sasare sare kaimɨraayaihi dɨmwaalyideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sɨrɨnɨmaanga Sɨgunyavɨyarɨ aꞌmwe yuyaraavɨna kale wiadevaaibɨꞌ aꞌmweraavɨna kale nayaa yɨhyana! ");
INSERT INTO byr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Sarɨmɨ aꞌmwe pwaraavɨ mamaryawɨbwaryadɨvɨꞌ ‘Kayaaꞌnanyarera,’ madɨpɨna! Sara majɨpɨjaihɨrɨna Gotɨyai kwalyɨ ‘Kayaaꞌnanyarera,’ dathei mɨka! Arɨkewɨ. Nabaai pwaraavɨ majɨdapɨnera! Sara majɨdayɨpɨjaihɨrɨ Gotɨyai kwalyɨ jɨdavadei mɨka! Arɨkewɨ. Aꞌmweraavɨre kayaaꞌnanya sarɨmɨnyɨne dɨmarasɨꞌnyideihɨlyɨ. Sara yɨpɨjaihɨre kayaaꞌnanya Gotɨyai yɨhɨmarasɨꞌnadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Sarɨmɨ aꞌmweraavɨ gɨlyɨvɨsanna yanga nayaa duzaayideihɨlyɨ. Sara yɨpɨjaihɨrɨ Gotɨyai yanga nayaa yɨhɨzaavadelyɨ. Yanga naanga naanga yɨhɨzaavadelyɨ. Maanga yunebanna yekuꞌnyaꞌne wɨjaavɨna, tɨvɨpalamihya yɨna, purataꞌnyɨna, naanga naanga wɨjaavɨna, kuneba mwari yada pɨnɨ bwalaraawɨna yade sabaaibɨꞌ yɨhɨzaavadelyɨ. Sareꞌ dareꞌnesɨ. Yɨnɨga wiꞌnanya sarɨmɨ aꞌmweraavɨ wɨrɨvɨkɨꞌdɨvɨsa yanga wɨjaaya dazahɨnɨngɨ Gotɨyai sarɨmɨnyɨ ayɨna yɨhɨrɨvɨkɨradelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Keꞌbaꞌna yagaala pɨrɨꞌ wɨjɨwaakɨna “Aꞌmwe pwai tɨbɨnyai aꞌmwe tɨbɨnya pwarɨ tusarɨꞌ yɨnɨga yɨbwarɨdaakwannei dɨngaka! Aawa. Yuyaraai kaviꞌnɨnnyavɨ walaraawɨna yɨkaneraalyɨ. (Gotɨyarɨ myawɨryai Gotɨyareburɨ pwarɨ yɨbwarɨdaakwannei mɨka!) ");
INSERT INTO byr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nabaai sɨkulɨya yadei gamɨre wɨjɨwaakyarɨ wavɨlavadei mɨka! Gazaizai sɨkulɨyaꞌ mena yɨꞌmwannojɨ gannya wɨjɨwaakyaibɨꞌ avaaina yɨmaꞌnadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Gɨmɨnyɨ jaꞌmwere tɨnnyarɨ yɨtɨrɨdɨrɨnya maalɨkemɨlɨꞌ waꞌdɨꞌnyɨ tɨnna wanganna. (Sareꞌ daresɨ. Jaꞌmwere yɨwetawakya maalɨkemɨlɨꞌ waꞌdɨꞌnyɨyasɨ.) Tɨnna wanganna yaka kɨrɨꞌ gɨnnya tɨnnyarɨ yɨta naangewaꞌ gwaꞌdɨꞌnyɨyaigɨ nayaa beꞌna myawɨryaigɨnaka! ");
INSERT INTO byr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Gathaꞌdara yaꞌgɨzɨ jaꞌmwerɨ yɨnɨga wiꞌna wɨdɨnneigɨnaka! ‘Nyaꞌmwei, gɨmɨre tɨnnyarɨ yɨtɨrɨdɨrɨnya maalɨka gwarɨka saꞌ gɨthɨhaaꞌmwagɨdeinyɨra.’ Gɨmɨ tɨnna nayaa myennyaigɨ gɨmɨre tɨnnyarɨ yɨta naanga gwarɨka savaaꞌna sara gathaꞌdara duthatheigɨnaka! Kwaasɨyaigɨ, aayagaaꞌ gɨmɨre tɨnnyarɨ gwarɨka yɨta naanga savaaꞌ yuneꞌna papurasɨꞌnaꞌgɨzɨ dɨvi tɨnna nayaa padaꞌgalanganaꞌgɨzɨ yɨtɨrɨdɨrɨnya maalɨka pɨmɨlɨꞌ jaꞌmwere tɨnnyarɨ warɨkeꞌ dɨvapurasɨꞌdeigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Sareꞌ dareꞌnesɨ. Yɨta tewaanyɨꞌ yɨsɨla kayaaꞌnanya yɨꞌnadiꞌ mɨka! Nabaai yɨta kayaaꞌnanyɨꞌ yɨsɨla tɨka munne tewaanya yɨꞌnadiꞌ mɨka! ");
INSERT INTO byr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sareꞌ dareꞌnesɨ. Aꞌmwera yɨta gazɨsɨkɨ tɨka munnengɨ mena yawɨranganapɨjɨyara sahwara yawɨꞌna ‘Sɨkɨre yɨsɨla nawɨꞌnya yɨꞌnɨwakeꞌna yɨta tewaanyɨkɨra.’ Yɨta pukɨna yawɨꞌna ‘Sɨkɨre yɨsɨla kayaaꞌnanya yɨꞌnɨwakeꞌna yɨta kayaaꞌnanyɨkɨra.’ Tɨka munnengɨ mena yawɨranganna yadɨvɨꞌ yawɨꞌdɨvɨsare. Sareꞌ dareꞌnesɨ. Aꞌmwera yɨta pihɨyɨkɨre yɨsɨlya lannakengɨ maaꞌdɨvɨtara daa! Nabaai wɨla gɨraipɨwɨlyavɨ yɨsɨlya mubwawɨlyabaarɨ gimujadɨvɨta daa! ");
INSERT INTO byr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aꞌmwe tewaanyai gamɨre sɨmunyavɨ nawɨꞌnaange wɨwarɨkei. Sarevɨdaaꞌnyɨ sai tewaanyabwina yadelyɨ. Aꞌmwe kayaaꞌnanyai gamɨre sɨmunyavɨ kayaaꞌnanaange wɨwarɨkei. Sarevɨdaaꞌnyɨ sai kayaaꞌnanyabwina yadelyɨ. Sareꞌ dareꞌnesɨ. Yawɨta sasare saꞌ sɨmunyavɨ yunebanna wɨlaꞌdeꞌ, yɨ saꞌ maangiꞌ dadevulyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Sarɨmɨ ‘Naangeigɨ! Naangeigɨ!’ beꞌna nyɨdangadɨvɨsaihɨlaka! ‘Naangeigɨ!’ nyɨdangadɨvɨta kɨrɨꞌ nɨmɨre yagaalyangɨ mamɨdɨnyɨ yɨpɨjaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nabaai gazaizai nɨmɨnyawɨnna bozɨyai nɨmɨre yagaalyangɨ kadɨka nyuꞌnada yagaalyangɨ mɨdɨnajarɨ, gamɨrebwina sɨmunya jawɨryideꞌna yɨhibwarɨdaakwɨdeinyɨ. ");
INSERT INTO byr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Aꞌmwe dazai aꞌmwe pwai ‘Angeꞌ madɨma!’ dada yadevaaibɨsalyɨ. Aayagaaꞌ kaviꞌnɨnnyaꞌ lɨkɨwaidaawada kwaakevɨ kusawɨ yune sɨla naangevaakɨ gɨrɨkwidelyɨ. Sara yada nabaai dɨvidaaꞌnyɨ angeꞌ sahɨvaakɨ aꞌbadaaꞌnyɨ yɨlamadesɨ. Nabaai dɨvidaaꞌnyɨ aalyaaka naangeꞌ puꞌda aalyaꞌ anga dazavɨ tɨvɨtawakɨna yadaasɨ kɨrɨꞌ mwalaraawi yɨna yadesɨ. Aꞌmwe dazai angeꞌ tewaanya madevɨna mwalaraawi. ");
INSERT INTO byr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kɨrɨꞌ pwai nɨmɨre yagaalyaꞌ kadɨka nyuꞌnada mamɨdɨnyɨ yajai, yɨ sai aꞌmwe pwai angeꞌ kwaakevakɨ yaasɨwaꞌ madathɨhɨdaakuna yadevaaibɨsalyɨ. Aayagaaꞌ kwaakevɨ kusawɨ yune sɨla naangevaakɨ gɨrɨkwidei mɨꞌ. Dɨvi aalya saꞌ anga savɨ tɨvɨtawakɨna yadaaꞌnyɨ yɨmeꞌnyaꞌbɨꞌ walaraawɨna yada yɨnahu kayaaka yɨmaꞌnyɨna.” ");
INSERT INTO byr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Aꞌmwera kadɨka wɨꞌnyaꞌne gamɨre yagaalya mena wɨdaka sabadaaꞌnyɨ anga Kaapanɨyamɨ sabanna yɨꞌmavaawɨna. ");
INSERT INTO byr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Saba aꞌmwe atɨlyaraavɨre sɨvɨla atɨraalya aawɨlasaraavɨ maremwaaide akwai mwaalɨna. Sare sai gamɨre yaasɨwaꞌwawɨnyai sarɨna tewaanya wɨvuꞌnadei. Yɨ wɨdaayade dazai sagaaꞌ nalaayaꞌ kɨnɨnnakei mena balyaꞌneba yadaaꞌnyɨ ");
INSERT INTO byr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","aawɨlasaraavɨ maremwaaidei “Jizaazai bamwaalɨka!” kadɨka wɨꞌnyɨna yaka Juyaraavɨre aꞌmwe naanga pwaraavɨ dara wɨdaasɨna “Gɨmɨ baꞌgɨzɨ nɨmɨre nyɨdaayaderɨ tewaanya javadaꞌgaideigɨ daaka?” ");
INSERT INTO byr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wɨdaasɨna kyaꞌ sahwara Jizaazaryawɨnna yɨꞌmavaawɨna yɨna yeva sahwarɨ wɨdɨna yeva yagaala dɨragɨnna wɨdɨna “Sai aꞌmwe tewaanyarɨnera. Gɨmɨ yɨnɨga wiꞌna dɨhaimwaderɨnera. ");
INSERT INTO byr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Sareꞌ dareꞌnesɨ. Sai nemɨ Juyainaavɨna tewaanya wɨvuꞌnaderɨnera. Sai yune gamɨ sai nemɨre lotuangeꞌ madakerɨnera.” ");
INSERT INTO byr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Sara wɨdɨna kyeꞌ sahwarajɨ Jizaazai yeꞌmwannɨguna yaka angeyaba aya kɨbanna mena yɨꞌmavaawɨna kyaꞌ aawɨlasaraavɨ maremwaaide dazai gyaꞌmwe pwaraavɨ maryaasɨna yɨna kyaꞌ Jizaazarɨ yagaalyaꞌ dara wɨjaꞌnera makabɨna “Naangeigɨ, nɨmɨnyawɨnna byaꞌneigɨnyɨ taanga nagɨzaavɨwɨdɨka! Sareꞌ dareꞌnesɨ. Nɨmɨ aꞌmwe tewaanyainyɨ daaka! Nɨmɨre angevɨ bwidɨzaꞌna nɨmɨ yɨnɨga wiꞌna nawɨꞌnyaigɨbɨsainyɨ daaka! Tewaanyaigɨnyɨnera. ");
INSERT INTO byr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sarevɨdaaꞌnyɨ nɨmɨ kwainyɨ yawɨꞌmwa ‘Nɨmɨ aꞌmwe nawɨꞌnyainyɨ daaka! Nabaai gɨmɨnyawɨnna yɨnɨga wiꞌna wɨdeinyɨ daaka!’ Aawa. Gɨmɨ yune yagaalyaꞌna kadaꞌgɨzɨ nyɨdaayadei ayɨna tewaanya yɨmaꞌnana! ");
INSERT INTO byr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sareꞌ dareꞌnesɨ. Nɨmɨ kwainyɨ aꞌmwe naangera nyɨmaremwaaidɨvɨꞌ wawɨnya nyɨjaavadɨvɨsainyɨ. Sareinyɨ mwaaidɨ nabaai nɨmɨre aawɨlasara kɨnɨnnakeinyɨ kwaakewɨ nyɨmwaaihasara. Yɨ nabaai nɨmɨ pwarɨ kudaꞌmujɨ ‘Gɨmɨ dɨwona!’ yɨ sai kaanna wɨna yadelyɨ. Nabaai nɨmɨ pwarɨ kudaꞌmujɨ ‘Gɨmɨ kaaja!’ sai kaanna bɨna yadelyɨ. Nabaai nɨmɨre yaasɨwaꞌwawɨnyarɨ wɨdɨna ‘Gɨmɨ wawɨnya sasare saꞌ ja!’ Sara kudaꞌmujɨ yɨ sai wawɨnya saꞌ yɨna yadelyɨ. (Sarevɨdaaꞌnyɨ yune yagaalyaꞌna kadaꞌgɨzɨ nyɨdaayadei tewaanya yɨmaꞌnadelyɨ.)” ");
INSERT INTO byr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sara wɨdasaabɨna kyaꞌ Jizaazai yagaala dazavɨ kadɨka wɨꞌnaka atɨka maruꞌnaꞌna yaka gɨnyɨmaꞌnyɨna yaka kwala bwaꞌnaanyaꞌ mɨdɨdapiya saraavɨ wɨdɨna “Sarɨmɨnyɨ anga menyabadaaꞌnya sarɨna yɨhɨthɨvanɨge. Yune Yɨzɨrelɨ kɨbadaaꞌnyɨ yawɨralɨmwanga sasare sabwi kɨnɨnnaka aꞌmwe pwarɨ mabɨramaaryainyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sara wɨdɨna kyaꞌ aawɨlasaraavɨ maremwaaidei maryasaabaka aꞌmwe dazara angevɨna ayɨna wɨna yeva wawɨnya wɨdaayaderɨ maamɨdaryai mena yɨmaꞌnakerɨ tɨnna wanganna. ");
INSERT INTO byr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Dɨvi maalɨkegaaꞌ mwanyavɨ anga naanga pɨbanna Nenɨ woꞌnɨkebanna kaanna wɨna. Gamɨre mɨdɨdɨvɨta kwarajɨ kwala bwaꞌnaanya naangerajɨ yeꞌmwannɨguna. ");
INSERT INTO byr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yeꞌmwannɨguna yadaapi sai kaadihɨta anga naangeyabanya dazayaba aya kɨbanna badaaꞌnyɨ, yɨthaa, aꞌmwe bainɨka pwarɨ makabɨna. Aꞌmwe bainɨka dazarɨ ganaangeꞌ kaimɨraaya yune gave dazahwainanyalyɨyasɨ. Aꞌmwe saꞌ yaanyɨwaakesɨ. Anga naanga dazabadaaꞌnya aꞌmwe kwala bwaꞌnaanya naangera aꞌmwe dazasɨ yeꞌmwannɨgavɨna. ");
INSERT INTO byr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sara yɨna kyeꞌ Naangei aꞌmwe dazavɨ tɨnna wanganna yaka gamɨnyɨna kale yenyɨꞌnyɨna yaka aꞌmwevɨ wɨdɨna “Kɨnna madɨnnera!” ");
INSERT INTO byr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sara wɨdɨna yaka aya kɨba gidɨkuꞌ wɨlɨna yaka aꞌmwe bainɨkei yɨlaꞌdɨꞌnyɨya yɨꞌbɨnya savɨ asaꞌ dathɨwanna kyaꞌ aꞌmwe barɨyɨꞌbɨnya saꞌ makabadaapiyara sana dakulɨna yɨna yadapi wɨdɨna “Mɨgɨnyaigɨ gɨmɨnyɨ gɨthɨvanɨge. Dɨthɨkaaka!” ");
INSERT INTO byr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sara wɨdɨna kyaꞌ mena bainɨka dazai dɨkaaꞌna yaka dɨkavamwaaina yaka yagaalyaꞌ gaai dɨna. Sara yadaaꞌnyɨ sai aꞌmwe dazarɨ ganaangevɨna wɨmaarina. ");
INSERT INTO byr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sarevɨdaaꞌnyɨ aꞌmwe yuyara lɨka naanga yɨna yeva Gotɨyarɨne yayaꞌ byaannakeꞌ munya keꞌbeva makina. Sahwara dɨna “Nemɨnyɨ pɨropetɨya naangei Gotɨyarɨ wɨꞌnawɨjɨwaakadei mena kimaꞌnaabɨka!” Nabaai dɨna “Gamɨre aꞌmweinaavɨ gaimwanga yaꞌne Gotɨyai mena bakelyɨreva.” ");
INSERT INTO byr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Dɨna kyeꞌ aꞌmwera Juthɨya yuyabajɨ yuya bularaawia kɨbajɨ yamaryadɨvɨꞌ gamɨ yaka sanna yagaaikɨwɨnya bathɨwɨna. ");
INSERT INTO byr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jizaazai yaka yuya dazangɨna Jonɨmɨre mɨdɨdɨvɨsara kalavuzangevɨ Jonɨmɨ wɨjɨwaakɨna. ");
INSERT INTO byr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Sarevɨ Jonɨ gamɨre pwaraarɨ jaka wɨdɨna yaka Naangerɨ wɨjaꞌne yagaala pɨrɨꞌ makwɨyaꞌneraarɨ wɨdaasɨna. Sai saraarɨ wɨdɨna “ ‘Aꞌmwe bathelyɨra,’ Juyaina dadaanyaigɨ sahwaigɨ bahɨnyaigɨ dɨngaka? Pwarɨna yemwalaadeina dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wɨdasaabɨna kyaꞌ aꞌmwe pwaraala dazaraai gamɨnyawɨnna mena yɨꞌmaꞌna yɨna yagɨla wɨdɨna “Jonɨ Bavɨtaazɨya Yadei gɨmɨnyawɨnna nehɨmaryasɨwaabɨkeinaalyɨra. Sai dara dɨwaꞌ ‘ “Aꞌmwe bathelyɨra,” dadaanyaigɨ sahwaigɨ bahɨnyaigɨ dɨngaka? Pwarɨna yemwalaadeina dɨngaka?’ ” ");
INSERT INTO byr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wɨdɨna kyagi dazahɨgaaꞌ aꞌmwe kwalaalyaraavɨ tewaanya yavadaꞌgaidaaꞌnyɨyagaaꞌ. Nalaaya dala nabinabinya kɨnɨnnakeraavɨjɨ nabalya taanga wɨjaayaꞌne kɨnɨnnakeraavɨjɨ yɨmakera kɨnɨnnakeraavɨjɨ tewaanya yavadaꞌgaina. Nabaai tɨbɨnya kwalaalyara, yangeꞌna yavadaꞌgaidaaꞌnyɨ tɨnna yenyɨna. ");
INSERT INTO byr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sara yavadaꞌgaina yaka Jonɨmɨreraarɨ yɨwaarasaꞌna jaꞌnawɨdɨna “Kaanya wawokɨlyɨ Jonɨmɨ duthɨthaakwila! Dahaaꞌ tɨnna wangadiꞌ kadɨka wɨꞌnɨwaalyangɨna duthaawila! Aꞌmwe tɨbɨnyara tɨnna ayɨna yenyɨna, sɨvɨla kayaaꞌnanyara kaanya yamarina, samatanakeraavɨre kɨlaakejɨka nawɨꞌnya yɨmaꞌnyɨna. Nabaai aꞌmwe kadɨka muꞌnyɨmuꞌnyara yagaalyangɨ kadɨka wɨꞌnyɨna, aꞌmwe bainɨkera ayɨna dɨkaaꞌna, aꞌmwe gɨlyɨvɨꞌmaayaraavɨ yagaala tewaanyaꞌ wɨjɨwaakɨna yadɨnyainyɨ. Sasarera sara yɨvanɨgaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nabaai aꞌmwei nɨmɨnyɨ lɨmwangebwina yawɨta kwalaalya myaja sare sai yɨlaaya yada tewaanaanga yɨnɨkelyɨ.” Jizaazai Jonɨmɨna sara wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jonɨ maryasaabaka saraai mena kaanna wodaakɨlyɨ kwala bwaꞌnaanyaraavɨ Jonɨmɨna wɨdɨna “Aꞌmwera maayabanna tɨnna bewarɨ wanganyaꞌneihi wɨwaꞌdaataihɨlaka? Suya pɨrɨꞌ yɨhusaꞌ galalɨwihɨrakerɨꞌbɨsarɨ tɨnna wanganyaꞌneihi wɨwaꞌdaasaihi dɨngaka? ");
INSERT INTO byr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aawa. Tɨnna bewarɨ wanganyaꞌneihi wɨwaꞌdaataihɨlaka? Baazɨꞌmaꞌnya wolasa baazɨꞌmaꞌnɨkerɨ wanganyaꞌneihi wɨwaꞌdaasaihi daaka? Yɨthaanyi! Baazɨꞌmaꞌnya nawɨꞌnyɨnaangenna wakadɨvɨꞌ kɨlaakejɨkɨne gɨlyɨvɨta nawɨꞌnyanna kɨnɨnnaka sasara aꞌmwe dazara kingɨyaraavɨre angengɨ mwaaidɨvɨsare. Sasarerabɨtarɨ mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aawa. Tɨnna bewarɨ wanganyaꞌneihi wɨwaꞌdaataihɨlaka? Pɨropetɨya Gotɨyarɨ wɨꞌnawɨjɨwaakadei dɨngaka? Yo, sarɨmɨnyɨ yɨhɨthɨvanɨge. Sai pɨropetɨyai yaka kɨrɨꞌ yɨ pɨropetɨyaraavɨreburɨ wavɨlavɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nabaai aꞌmwe yune dazahwarɨna Bukuyaꞌ yɨdaꞌnɨkerɨnera. Dara dɨnɨꞌ ‘Yɨthaa, nɨmɨre yagaalyaꞌ makwɨyaꞌnerɨ maryasaabɨdeinyɨ. ‘Sɨnnawɨ gɨmɨnyɨ yɨbwaramakwaanna gyathelyɨ. ‘Sai gɨmɨnyɨna tusaꞌ maryovɨrawakɨna yadelyɨ.’ Sara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sarɨmɨnyɨ yɨhɨthɨvanɨge. Jonɨ Kwaakevakɨ aꞌmweraavɨdaaꞌnyara yɨmaꞌnɨgata yuyaraavɨ wavɨlavɨkelyɨ. Aꞌmwe Gotɨyai maremwaalademɨlɨꞌ yɨmaꞌnajamɨlɨꞌ yuna maalɨkemɨlɨꞌ mwaaloriyamɨlɨꞌ kɨrɨꞌ Jonɨmɨ wavɨlavademɨlɨkɨra.” ");
INSERT INTO byr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sara wɨdɨna kyaꞌ sahwara kadɨka wɨꞌneva aꞌmwerajɨ aꞌmwe taakɨzɨya maaꞌdɨvɨsarajɨ sahwara dɨna “Yo, Gotɨyare sabwi yɨdaꞌmaraangebulyɨ.” Jonɨmɨ sahwara bavɨtaazɨya maaresare. ");
INSERT INTO byr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kɨrɨꞌ nabaai Perɨzɨyarajɨ kɨwɨnyangɨ yawɨꞌdɨvɨta sɨduꞌnakerajɨ Jonɨmɨ bavɨtaazɨya maaretara mɨꞌ. Sarevɨdaaꞌnyɨ sahwara Gotɨyai wibwarɨdakwadaaꞌnyɨya nawɨꞌnya savɨ buleꞌna wɨjaavesare. ");
INSERT INTO byr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jizaazai dɨna “Sarevɨdaaꞌnyɨ nɨmɨ dazagaaꞌne aꞌmweraavɨna keꞌbaꞌnanya berɨꞌ yɨhɨthɨma! Sahwara gathaꞌdara aꞌmweraavaka! ");
INSERT INTO byr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sarera darebaaibɨsamɨlɨke. Avaannyaꞌne kaimɨraayamɨlɨka angwaasabanna mwaaidɨvɨꞌ kaimɨraaya pɨmɨlɨkaavɨna jaka dangadɨvɨsamɨlɨke (Jonɨ yaasɨwakebwi myaderɨna) ‘Kwala maaꞌnyaꞌne gware makuꞌmanɨgo. Kɨrɨꞌ “Kwarame aala!” dɨvanɨgave!’ (Nɨmɨ angyɨrɨꞌmaasabwi yadɨnyainyɨna) ‘Nemɨ baryangɨne kɨdaata dɨvanɨgo. Kɨrɨꞌ sarɨmɨre kɨdalaala mabwalayɨhɨravaawivanɨke!’ ");
INSERT INTO byr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Sareꞌ daꞌdareꞌnesɨ. Jonɨ Bavɨtaazɨya Yadei bɨna yɨna yaka pɨgasa bɨretɨya tɨka manyɨ, yuyagaaꞌ waainɨya tɨka manyɨ. Sareꞌna nabaai sarɨmɨ dɨna ‘Yɨmakei kɨnɨnnakelyɨ.’ ");
INSERT INTO byr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aꞌmweraavɨne Kaimɨraayai bɨna yɨna yaka tɨka wapaa nada waainɨyasɨ nadaaꞌnyɨ sarɨmɨ dɨna ‘Yɨthaanyi! Sai aꞌmwe tɨka kwalaalya nadelyɨra. Sara yada waainɨya kwalaalyajɨ nadelyɨ. Yaawaryaibɨsalyɨ. Sai aꞌmwe taakɨzɨya maaꞌdɨvɨsaraavɨjɨ aꞌmwe kayaaꞌna gɨrɨkitaꞌnanyaraavɨjɨ sahwaraavɨ kwɨyaꞌmwelyɨra.’ Sara dadɨvɨsaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kɨrɨꞌ Jonɨjɨ sainaai Gotɨyare sɨdusabwine kaimɨraayainaai wawɨnya nawɨꞌnya yɨvanɨgolyainaalyɨ. Wawɨnya sa sɨduꞌnakera dara yawɨranganna ‘Gotɨyare sɨduta tewaanyabwina sara yɨvanɨgi. Yɨdaꞌmaraangesɨra.’” ");
INSERT INTO byr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Perɨzɨya pwai gamɨjɨ tɨka wapaaya byeꞌmwannanyaꞌna Jizaazarɨ wɨdɨna. Sara wɨdɨna kyaꞌ Perɨzɨya dazare angevɨna kaanna wɨna yaka tɨka munne savɨ mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yɨthaa! Anga naanga dazaba aꞌmwe kayaaꞌnanya yadeꞌ mwaalɨna. Sare saꞌ “Jizaazai anga Perɨzɨya dazare angevɨ tɨka wapaaya nɨvanɨkeva,” wɨꞌnyɨna. Sarevɨ aꞌmwe dazaꞌ gamɨre kayaaꞌnanyanna yawɨraka sitala (sɨla alɨvezɨta) saadaaya nawɨꞌnyaangeꞌ yɨꞌnɨkeꞌ makabɨna yɨna yaka ");
INSERT INTO byr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","wɨlaabɨna yɨna yaka Jizaazaryaba bulyɨmagɨ aya kɨba sɨvigɨꞌnyɨryawɨ gidɨkuꞌ bulagaidaaꞌna yɨna yaka kɨnna dɨwaainyɨna. Kɨnna dɨwainadaaꞌnyɨ gamɨre kɨdalaalya Jizaazare sɨvɨlyɨrɨ bwalaravaawɨna kyaꞌ gannya mɨjata saamɨnyasɨ yaalɨka yɨmwanna. Sara miꞌna yaka gamɨre sɨvɨlyɨrɨ buꞌbuta kwalaalya biwɨna yaka welivananya saadaayasɨ sɨvɨlyɨrɨ yevuꞌna. ");
INSERT INTO byr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sara yɨna yadaaꞌnyɨ Perɨzɨya gamɨnyɨ wɨjɨvwarɨjɨmaaꞌnaka dazai sasarevɨ tɨnna wanganaka sɨmunyavɨ dara yawɨꞌna “Aꞌmwe dathai sai pɨropetɨya nebulyai mwaalajɨ kwajɨ aꞌmwe gamɨnyɨ ata dathɨwamanɨka savɨ kyawɨranganadɨka! Nabaai gamɨre kɨburɨjɨ kyawɨranganadɨka! Yɨ dazaꞌ aꞌmwe kayaaꞌnanya yadeꞌ mwaalɨkeꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sara yawɨꞌna kyaꞌ Jizaazai gamɨre sɨmunyaburɨna jaꞌnawɨdɨna “Saaimonɨ, yagaala pɨrɨꞌ gɨthɨdeꞌ warɨꞌ.” Wɨdɨna kyaꞌ sai wɨdɨna “Nejɨwaakadɨnyaigɨ dɨnyɨdana!” ");
INSERT INTO byr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Sara kudaꞌ wɨdɨna “Aꞌmwe pwaraai aꞌmwe pwarɨ dinaayaꞌ kɨnɨnnakeraai. Pwai dinaayaꞌ naanga naanga (K500) wɨwarɨkei, nabaai pwai yune kɨbawe (K50) wɨwarɨkei. ");
INSERT INTO byr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Saraai dinaaya dazaꞌ yɨnɨga wiꞌna yɨkaderaai mɨka! Sarevɨdaaꞌnyɨ aꞌmwe sai ‘Saraaihɨre dinaaya maarɨderaaihi mɨꞌ,’ wɨdɨna yadelyɨ. Nabaai sarevɨdaaꞌnyɨ dazahwaraarɨdaaꞌnyɨ pwai sahwarɨna tewaanya naanga wɨvuꞌnɨvanɨkei aaihwalaka?” ");
INSERT INTO byr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Wɨdɨna kyaꞌ Saaimonɨ dara jaꞌnawɨdɨna “Nɨmɨ yawɨꞌmanɨge. Aꞌmwe dazai dinaaya naangeꞌ miꞌnanyaꞌ dakɨwakei dɨngaka!” Sara wɨdɨna kyaꞌ sahwarɨ wɨdɨna “Gɨmɨre yawɨbwata yɨwaanyaꞌ yɨdaꞌnanyasɨra.” ");
INSERT INTO byr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wɨdɨna yaka aꞌmwe dazayɨmagɨnna gɨnyɨmaꞌnyɨna yaka Saaimonɨmɨ wɨdɨna “Gɨmɨ aꞌmwe dathava davɨ tɨnna mwanganyɨjɨwaana! Angyɨrɨꞌmaasaraavɨna Juyaina yadaanyabaaibɨꞌ gɨmɨre angevɨ kabwimwa nɨmɨre sɨvɨlyavɨ aalya yɨnyaꞌneꞌ nyɨjawaanyaigɨ mɨka. Kɨrɨꞌ aꞌmwe dathaꞌ gamɨre kɨdaraaibɨrɨkesɨ nɨmɨre sɨvɨlyɨraarɨ nyɨwakesɨra. Sara yaka gannya mɨjasasɨ yaalɨka nyimwamwakesɨra. ");
INSERT INTO byr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gɨmɨ buꞌbuta maranyɨwaanyaigɨ mɨka! Kɨrɨꞌ nabaai nɨmɨ bwimwegaaꞌdaasɨ yaka kuna dahaakɨgaasɨ aꞌmwe dathaꞌ nɨmɨre sɨvɨlyawaarɨ buꞌbusaꞌ kuna maranyɨvanɨka. ");
INSERT INTO byr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nɨmɨre mɨnyagɨnyavɨ welivananyasɨ nyɨvuꞌmwaanyaigɨ mɨka! Kɨrɨꞌ aꞌmwe dathaꞌ nɨmɨre sɨvɨlyawaarɨ welivananya saadaayasɨ nyɨvuꞌmwakeinyɨra. ");
INSERT INTO byr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sarevɨdaaꞌnyɨ gɨmɨnyɨ gɨthɨvanɨge. Dazahɨrɨꞌ kayaaꞌnanya kwalaalyabwi yadevɨ gamɨre kayaaꞌnanya daza marasɨꞌmweꞌna, sarevɨdaaꞌnyɨ sahɨrɨꞌ nɨmɨnyɨna yuna nebwina wɨvuꞌnɨvanɨkesɨ. Kɨrɨꞌ aꞌmwei kayaaꞌnanya maalɨkemɨlɨꞌ yaderɨ nɨmɨ marasɨꞌnɨwɨja saꞌ yɨ sai nɨmɨnyɨna yuna maalɨꞌna wɨvuꞌnadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wɨdɨna yaka sahɨrɨvɨ wɨdɨna “Gɨmɨre kayaaꞌnanya mena gɨmarasɨꞌmwengɨra.” ");
INSERT INTO byr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wɨdɨna kyaꞌ aꞌmwera gamɨjɨ wapeyɨꞌbɨnyavɨ yeꞌmwannemwaalesara kumɨ sahwaraavɨ gaai dɨnyɨna “Aꞌmwe kayaaꞌnanyabwi marasɨꞌmwaka dazai bewai dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sarevɨ Jizaazai aꞌmwe savɨ wɨdɨna “Nɨmɨnyɨ dɨragɨnna nyɨlɨmwamwaanyaꞌna gɨmɨnyɨ kayaaꞌnanyabwina gɨvadaihasamaaꞌmweꞌgɨnyɨ. Gɨmɨ kaanna wawoꞌgɨzɨ gɨmɨre munyɨꞌ kwaamuꞌ kave nayaa gwarana!” ");
INSERT INTO byr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Dɨvi maalɨkegaaꞌ anga naangebanyajɨ anga maalɨkebanyajɨ Jizaazai kaanya yamarina yada Gotɨyai maremwaaidevɨne yagaala tewaanyaꞌ wɨjɨwaakɨna. Sagaaꞌ sɨvɨlɨrɨdaaꞌnyɨ pwaraalyara gamɨjɨ yeꞌmwannayamarina. ");
INSERT INTO byr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nabaai aꞌmwe pɨnɨ, sɨnnawɨ kɨgaaꞌ Jizaazai kumɨjɨya pɨnɨngɨ yɨmakera marasɨꞌnaka pɨnɨngɨre nalaaya marasɨꞌnake, sa kɨnɨjɨ sahwalyɨ yeꞌmwannayamarina. Aꞌmwe pɨrɨꞌ Maarɨyaasɨ. Sahɨrɨvɨna Maahɨthaala mwaalyava wɨdadɨvɨsasɨ. Sɨnnawɨ Jizaazai sahɨrɨvɨ yɨmaka ata purɨdaaꞌnyɨ pwaraainanyara marasɨꞌnakesɨ. ");
INSERT INTO byr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nabaai pɨrɨꞌ Jowaanaꞌ, Erotɨyare angevɨ maremwaaide Suzaamɨre aꞌmwesɨ. Pɨrɨꞌ Suzanasɨ. Nabaai aꞌmwe yuya kwalaalya pɨnɨjɨ sahɨnɨjɨ sahwalyɨ yeꞌmwannɨguna. Aꞌmwe daza Jizaazarɨjɨ gamɨreraavɨjɨ kumɨre gɨlyɨvɨsangɨ wɨgaimwagesangɨ. ");
INSERT INTO byr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sarevɨ aꞌmwe kwala bwaꞌnaanya naangera biꞌbwaꞌnemwaaina yadɨvɨꞌ anga pɨnɨngɨdaaꞌnyara gamɨnyawɨnna yɨkabɨna yɨkabɨna. Yɨkabɨna yɨkabɨna yɨna kyeꞌ yagaala keꞌbaꞌnanyaꞌ wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Pɨraihɨrakade pwai witɨzɨla pɨraihɨrakyaꞌnei wɨna. Wɨna yaka wawɨnyavɨ witɨzɨla pɨraihɨrakamarivanɨkelyɨ. Sai pɨraihɨrakɨwodaasɨ nabaai witɨzɨla pɨnɨ tusavɨ bwalaraawɨna. Sare sangɨ nabaai aꞌmwera sɨvɨlyajɨ paihɨramarina yadaapi yusara sɨgunyavɨyara tɨka maranyɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nabaai witɨzɨla pɨnɨ sɨlaangevɨ kwaaka maalɨkevɨ bwalaraawɨna. Sa yɨrɨꞌna yaka kɨrɨꞌ kwaakevaꞌ aalya tɨꞌgɨrya maayavakɨ sarevɨdaaꞌnyɨ sɨla sasare daza yɨnahu yawaka baidaaꞌna yaka balɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nabaai witɨzɨla pɨnɨ wɨla lannakebaraayaba bwalaraawɨna. Sare sa wɨla lannakebarajɨ yeꞌmwannayɨrɨꞌna yɨna yaka aꞌnɨngɨ dathɨwaaina. ");
INSERT INTO byr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nabaai witɨzɨla pɨnɨ kwaaka nawɨꞌnya mɨnarɨnakevakɨ bwalaraawɨna yɨnɨke sa yɨrɨꞌna yaka tɨka munne kwalaalya yɨꞌnyɨna. Darebɨsa yɨꞌnyɨna, gavemɨlɨkɨdaaꞌnyɨ waanɨ aadɨretɨya yɨꞌnyɨna.” Sara wɨdɨna yaka jaka dɨragɨnna wɨdɨna “Aꞌmwe kadɨꞌnakei yagaala dathavɨ kadɨka nayaa wɨꞌnana!” ");
INSERT INTO byr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Gamɨre mɨdɨdɨvɨsara gamɨnyɨ keꞌbaꞌnanya dazavɨneꞌna yagaala kaavɨlyaꞌna yɨdaanganna. ");
INSERT INTO byr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yɨdaanganna kyeꞌ sai wɨdɨna “Sarɨmɨnyɨ Gotɨyai gannya maremwaaidevwina yulyakɨyagaala dɨnɨka aaya kaavɨlyavɨ yawɨranganyaꞌneihɨrɨ mena yɨhibwarɨdaakuwakelyɨ. Sarevɨ kɨrɨꞌ aꞌmwe pwara yune keꞌbaꞌnanya yagaalyavɨ kadɨka wɨꞌnɨvanɨgaꞌ. Sarevɨdaaꞌnyɨ ‘Tɨnna wangadɨvɨꞌ kɨrɨꞌ yawɨrangadɨvɨꞌ mɨꞌ. Kadɨka wɨꞌnadɨvɨꞌ kɨrɨꞌ wɨꞌnamaaꞌdɨvɨꞌ mɨꞌ.’ ");
INSERT INTO byr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Keꞌbaꞌna yagaala dazavɨne aaya kaavɨlyaꞌ yɨ daresɨ. Witɨzɨla daza yɨ sa Gotɨyare yagaalyasɨ. ");
INSERT INTO byr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nabaai witɨzɨla pɨnɨ tusavɨ bwalaꞌdaawade, yɨ sa aꞌmwera yagaalya kadɨka wɨꞌnadɨvɨsaꞌnesɨ. Kɨrɨꞌ dɨvidaaꞌnyɨ Kotɨya Maryadei badehaaꞌ kumɨre sɨmunyavɨ yagaala dazaꞌ marasɨꞌdelyɨ. Sai ‘Gotɨyarɨ nalɨmwabɨka! Sara kyapɨjɨ Gotɨyai nuvadaihasamaaradɨka!’ daka marasɨꞌnadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nabaai witɨzɨla pɨnɨ sɨlaangevɨ kwaakejɨkɨ bwalaraawɨna, yɨ sa aꞌmwera yagaalyavɨ kadɨka wɨꞌnadɨvɨꞌ wɨꞌnamaaꞌna yadɨvɨꞌ savɨneꞌna yɨlaaya naanga yɨna. Sahwara pwipula maayara maalɨkegaaꞌna lɨmwadɨvɨꞌ kɨrɨꞌ yɨjɨwaala pɨgasa lɨka sangina yɨgɨꞌdaaꞌdɨvɨsare. ");
INSERT INTO byr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nabaai witɨzɨla pɨnɨ wɨla lannakebaraavɨ bwalaꞌdaawade yɨ sa aꞌmwera yagaalya kadɨka wɨꞌnadɨvɨꞌ kaanya yamaryadaapɨjɨ taanginya dala nabinya pɨburajɨ nɨgwia gɨlyɨvɨta sajɨ Kwaaka davakɨya yɨlaaya dala nabinya saburajɨ wɨdathɨvaidere. Yuya sa Gotɨyarɨ mwagiꞌnadengɨ. Sarevɨdaaꞌnyɨ kumɨre tɨka wapaaya sa yɨꞌnabaladengɨra. Bwɨyangɨra. ");
INSERT INTO byr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kɨrɨꞌ witɨzɨla kwaaka nawɨꞌnya mɨnarɨnakevakɨ bwalaꞌdaawade daza, yɨ sa aꞌmwera kumɨre sɨmunya nawɨꞌnyaangevɨ Gotɨyare yagaalyaꞌ kadɨka wɨꞌnadɨvɨꞌ yuna dɨragɨnna lɨmwagaꞌna. Sara yadɨvɨꞌ taanginya wiadaaꞌnyɨ dɨragɨnna kuna yadɨvɨꞌ tɨka munne naanga yɨmaꞌnadaaꞌnyɨ mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Aꞌmwe aane pwai kwai laamɨvananyaꞌ yewɨtaꞌda maaꞌgulyavɨ amwidaaꞌnyɨ yulyakadei mɨꞌ. Nabaai se waryaꞌne yɨꞌbɨnyavɨ dalaangevɨ marulyakadei mɨꞌ. Aawa. Laamɨvananyavɨne yɨꞌbɨnyavɨ aꞌba munyaba yɨlɨmwaaihadesɨ. ‘Aꞌmwera angevɨ bulapɨriyara dɨꞌbaaka dazavɨ tɨnna wangabɨka!’ dada munyaba yɨlɨmwaaihadesɨ. ");
INSERT INTO byr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sareꞌ dareꞌnesɨ. Yuya lɨka yulyakɨnɨke dɨvi nabaai sa kuꞌmaayaba yuna yalɨkuꞌnaraabathengɨ. Yuya bwakakɨnɨke dɨvi nabaai sa kuꞌmaayaba jalɨkuꞌnaraabathengɨ. Sare sangɨ nabaai aꞌmwera yuna yawɨrangabɨꞌdengɨ. ");
INSERT INTO byr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Sarevɨdaaꞌnyɨ sarɨmɨ mala nayaa jɨwannyɨla! Sara yapi nɨmɨre yagaalyavɨ kadɨka nayaa dɨnyuꞌnyideihɨlyɨ. Sareꞌ dareꞌnesɨ. Aꞌmwe pwai nɨmɨre yagaalyaꞌ lɨmwagarojɨyarɨ sare sarɨ nabaai Gotɨyai lɨmwanga pɨbulyɨ yanga kuna wɨjaavadelyɨ. Kɨrɨꞌ pwai nɨmɨre yagaalyaꞌ malɨmwagaryajai nebulyaꞌna kwaasɨ yawɨꞌmanɨke ‘Mena lɨmwamanɨgena,’ yawɨꞌmanɨkeꞌna, yɨ sa Gotɨyai marasɨꞌnadengɨ.” Jizaazai sara wɨdakesɨ. ");
INSERT INTO byr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sagaaꞌ gamɨnyawɨnna ganaangesɨ gahwaalaangerajɨ yɨkabɨna. Kɨrɨꞌ aꞌmwe kwala bwaꞌnaanya naangera kwala yɨꞌbwaꞌnyɨna yadaapɨjɨyavɨna gamɨnyaba aya kɨbanna gidɨkuꞌ mulaabi. ");
INSERT INTO byr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mulaabi kyeꞌ sahwarɨ aꞌmwe pwara wɨdɨna “Gɨmɨnyɨ gwaangesɨ gɨmɨre jɨhwaalaangerajɨ tɨnna gwanganyaꞌnera mwasawɨ bathaakava.” ");
INSERT INTO byr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wɨdɨna kyeꞌ kɨrɨꞌ sahwai sahwaraavɨ maꞌmaaꞌna “Aꞌmwera Gotɨyare yagaalyaꞌ kadɨka wɨꞌnadɨvɨꞌ mɨdɨbɨzara, yɨ dazara nɨmɨnyɨ nɨwaavajɨ nɨmɨnyɨ nyɨgwaalaangerera.” ");
INSERT INTO byr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yɨrɨka pɨrɨkɨ sɨpɨya pɨrɨvɨ gamɨre mɨdɨdɨvɨsarajɨ yɨladɨkwosɨꞌnamwaaina yaka kumɨnyɨ wɨdɨna “Nemɨ aalɨbunyavɨ pimagɨ, kengimagɨnna bwalyawaadeinera.” Sara wɨdɨna yaka kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sɨpɨyaꞌ kaanya wodaaꞌnyɨyagaaꞌ sai se warɨna. Se warɨna yadɨꞌnyɨ aalɨbunyavɨ yɨhuꞌmaanaryaꞌ yɨmaꞌnyɨna kyaꞌ sɨpɨyavɨ bwaladɨꞌnaawɨna yadɨꞌnyɨ kewɨnɨ walamaradathataꞌneba aya kɨba mena yɨmaꞌnyɨna kyaꞌ ");
INSERT INTO byr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","bulaawɨna yeva gamɨnyɨna bulyɨdɨkavaawɨna yevegaaꞌ wɨdɨna “Aꞌmwe naangeigɨ! Aꞌmwe naangeigɨ! Yuna dahaasagaaꞌ nemɨ yaraina yɨwawaadeꞌna yɨwoneva.” Wɨdɨna kyeꞌ daavɨna yaka yɨhuta sasɨ aalɨmavajɨnaaka naanga sasɨ maanga wɨdɨna. Sara wɨdɨna kyaꞌ yɨhuta yɨnahu mudaꞌna kyaꞌ aalyaꞌ ayɨna aalɨmavajɨnaaka mimaꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sara kyaꞌ sagaaꞌ sai wɨdɨna “Sarɨmɨre dɨragɨnna lɨmwangebwi gawɨ warɨka!” Sagaaꞌ sahwara lɨka yɨna yadɨvɨꞌ atɨka maruꞌnaꞌna yadɨvɨꞌ dɨnyɨna “Sarevɨdaaꞌnyɨ be aꞌmwelaka! Sai yɨhusasɨ aalyasɨ maanga kudɨwaꞌ kadɨka wɨꞌnyɨna yɨwaai!” ");
INSERT INTO byr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dɨvi sɨpɨyɨhuselɨyaꞌ makuna yaka Geraaza sɨmagɨnna yɨꞌmavaawɨna. Anga dazaba aalɨbunya Galɨli pimagɨ warɨkeba. ");
INSERT INTO byr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yɨꞌmavaawɨna kyaꞌ Jizaazai sɨpɨyavɨ yagalyaꞌmavaka tɨyawɨnna wɨlaawɨna kyaꞌ aꞌmwe anga naanga dazabnne mwaalyai sahwarɨ wɨrataꞌnyɨna. Aꞌmwe dazarɨ yɨmaka pwara wɨmwaaidapiyai. Saamɨnyagaaꞌ sahwai kwaabɨhannya kuna miraꞌnyadei. Sahwai anga aane pɨrɨꞌ kɨrɨvɨ mwaaidei mɨꞌ. Aawa. Sai gɨlekaviꞌnɨnnyabanya mwalamaryadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aꞌmwe dazai Jizaazarɨ tɨnna wanganaka jaka danganna yɨna yaka gamɨre sɨvigɨꞌnyɨryaba aya kɨba wɨlaabɨna yaka kwaakevakɨ bulaꞌna yaka jaka naangaveꞌna danganna “Jizaazai, Gotɨya yuna munya keꞌbevanyareigɨ! Nɨmɨnyɨ gara dɨnyɨdeꞌna bahɨneigɨnaka? Akai, dɨragɨnna yɨdaanganna gima! Nɨmɨnyɨ daanga manyɨjaavɨnnera!” ");
INSERT INTO byr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Sara wɨdakeꞌ dareꞌnesɨ. Jizaazai yɨmaka dazarɨna mena wɨdɨna “Aꞌmwe dazarɨ yagalyaꞌmakuna yɨna ja!” Nabaai sareꞌ dareꞌnanyɨ. Saamɨnya kwalaalyagaaꞌ yɨmaka dazai aꞌmwe dazarɨ galalɨmwagaꞌdelyɨ. Sarevɨdaaꞌnyɨ aꞌmwera yuyagaaꞌ sahwarɨ asawaalyɨ wɨla senɨyabaalyɨ yapwekɨna yadɨvɨꞌ sɨvɨlyaraalyɨ wɨla yapwekɨna yadɨvɨta sahwarɨ maredaaꞌdɨvɨsalyɨ. Kɨrɨꞌ sahwai yuya kwaariꞌmawɨla kɨbara yesɨvalakɨwɨna yada sarevɨ yɨmaka dazai aꞌmwera mamwaalyɨgata pimagɨnna yɨdangɨramakwodelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","“Daanga manyɨjaavɨnnera!” jaka kudaꞌ Jizaazai sahwarɨ yɨdaanganna “Gɨmɨnne yayaꞌ aaihwaigɨnaka?” Yɨdaanganna kyaꞌ sai wɨdɨna “Kwalaalyainyɨ.” Yɨmaka kwalaalyara gamɨnyɨ wɨlamwaainɨkerɨna “Kwalaalyainyɨ,” wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wɨdɨna yaka yɨmaka dazara jaka dɨragɨnna danganna “Gɨmɨ nemɨnyɨ dɨka kewewɨnneinaavɨna mamaraneyaasɨnnera!” ");
INSERT INTO byr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Sara dɨragɨnna danganna yevegaaꞌ yaawarɨkwala naangeꞌ mugunyavɨ aya kɨba kurɨvaarɨya nɨdaaꞌnyɨna yadaapi yɨmaka dazara yawɨꞌdɨvɨꞌ “Daanga naangeba nalarawaadɨka!” jaka dɨragɨnna danganna “Yaawarɨkwala naanga dazaraayawɨnna kanedaasaꞌgɨzɨ yuimɨlaana!” Dɨragɨnna sara danganna kyeꞌ wɨdanganaasɨna yɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Wɨdanganaasɨna yɨna kyaꞌ yɨmaka dazara aꞌmwe dazarɨ yagalyaꞌmaꞌna yɨna yeva yaawaryaraavɨre munyɨkaavɨ wiminna. Sara kyeꞌ yaawarɨkwala dazaꞌ davaanyavɨ kaanyaveꞌna dɨragɨnna walaawɨna. Sare sara aalɨbunyavɨ walakuna yɨna yeva aalya mihuna yɨna yeva yuya kwalyaꞌ baihɨrirɨꞌna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yaawaryaraavɨ yɨꞌdɨvaidɨvɨsara sasara yɨmaꞌnaka dazangɨ tɨnna wanganna yeva lɨkaanya wɨna. Lɨkaanya wɨna yeva anga naangebanyavɨjɨ wawɨnangengɨjɨ mwaaidɨvɨsaraavɨna yagaala dazaꞌ wɨjɨwakamaryaawɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Sara yɨna kyeꞌ aꞌmwera dazangɨ tɨnna wanganaawiaꞌnera Jizaazaryawɨnna biꞌmaꞌna yɨna yeva aꞌmwerɨ yɨmakera mena yagalyaꞌmakwawesarɨ tɨnna wanganna. Sai kwaabɨhannyaꞌ yɨraꞌnɨkei gamɨre sɨmunyai nawɨꞌnya yawɨꞌda Jizaazare sɨvɨlyɨryaba gidɨkuꞌ aya kɨba mwaaidɨꞌnyɨ. Aꞌmwera dazavɨ tɨnna wanganeva lɨka naanga yɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nabaai aꞌmwera sasare dazangɨ tɨnna wanganesara sɨnnawɨ aꞌmwe dazarɨ yɨmakera wɨlamwaaidapiyarɨ ayɨna tewaanya yavadaꞌgalakerɨna sara wɨjɨwaakɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wɨjɨwaakɨna yɨna kyeꞌ aꞌmwe yuya anga Geraaza sɨmagɨdaaꞌnyara gamɨnyɨ wɨdɨna “Nemɨnyɨ neyagalyaꞌmavaꞌgɨzɨ kaanya dɨwona!” Kumɨ lɨka naanga yadɨvɨsaꞌna sara wɨdɨna. Sara yadaapi sɨpɨyavɨ dɨkwosɨꞌna yaka ayɨna kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kuna mwaaidɨꞌnyɨyagaaꞌ aꞌmwe yɨmakera mena yagalyaꞌmakwaweta dazai dɨragɨnna yɨdaanganna “Nɨmɨ gɨmɨjɨ yeꞌmwannɨguma!” Sara wɨdɨna kyaꞌ kɨrɨꞌ sahwarɨ wɨdaasaꞌnerɨ wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Gɨnnya angebanna ayɨna kaanna dɨwodeigɨnyɨra. Sara wawoꞌgɨzɨ Gotɨyai gɨmɨnyɨ giwaka yuya sanna duzɨwaakɨdeigɨnyɨra.” Sara wɨdɨna kyaꞌ sarevɨdaaꞌnyɨ aꞌmwe dazai kaanna wɨna yaka gamɨre anga naangebanya yuyaraavɨ yagaalyaꞌ wɨjɨwaakɨna. Jizaazai gamɨnyɨ wɨvadaꞌgalaka yuya sanna wɨjɨwaakɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jizaazai ayɨna kaanna bakevɨ aꞌmwe kwala bwaꞌnaanyaꞌ wɨjɨmaꞌnaabɨna yeva yɨlaaya yɨna. Sareꞌ dareꞌnesɨ. Yuyara sahwarɨna yemwaaina yadɨvɨꞌ yɨlaaya yɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yɨlaaya yɨna yadaapi aꞌmwe pwai sahwarɨne yayaꞌ Jaairazai biꞌmaꞌna. Sai Juyaraavɨre lotuangeꞌ maremwaaide pwalyɨ. Sai biꞌmaꞌna yaka Jizaazare sɨvigɨꞌnyɨrɨ bulaꞌna yaka dɨragɨnna yɨdaanganna “Nɨmɨre angevɨna dɨvama! ");
INSERT INTO byr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nɨnnya taayaꞌ yune gave kɨrɨꞌnanyasɨra. Yɨ gamɨre kwarame atɨraai sɨvɨlɨrɨdaaꞌnyɨ pwaraaibɨsasɨ. Sareꞌna saꞌ baladeꞌna nebawa mɨka. Sareꞌna yarai dɨvama!” Jizaazai kaanya wodaaꞌnyɨ aꞌmwe kwala bwaꞌnaanya naangeꞌ gamɨnyɨ yunebanna bathakwamwadakuna. ");
INSERT INTO byr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bathakwamwadakuna yadapi aꞌmwe pɨrɨꞌ mwaalɨna. Dazahɨrɨꞌ yuyagaaꞌ baizaaka maꞌnada kuna mwaaidɨꞌnyɨ kwarame sɨvɨlɨrɨdaaꞌnyɨ pwaraaina mwaainɨkeꞌ. Nabaai gamɨre nalaaya sasare dazaꞌ aꞌmwe tewaanya yavadaꞌgala yaꞌnei aane pwai kwai mamwaalyɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aꞌmwe dazaꞌ gamɨnyɨ dusɨ bulyɨmagɨnna wɨlaabɨna yɨna yaka gamɨre baazɨꞌmaꞌnyavɨre maangebaarɨ asaꞌ dathɨwagaavɨna. Asaꞌ sara dathɨwagaavɨna kyaꞌ sagaasagaaꞌ gamɨre taweꞌ yaalɨka yɨlɨna yaka ayɨna mimaꞌnyɨ. ");
INSERT INTO byr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ayɨna mimaꞌnyɨ kyaꞌ Jizaazai wɨdɨna “Nɨmɨnyɨ asaꞌ aai nyɨdathɨwamwaabɨka!” Wɨdɨna kyaꞌ sareꞌna yuyara mɨjadɨwɨlɨna “Nɨmɨ aawa. Nɨmɨ aawa.” Sara yɨna kyeꞌ Pitai wɨdɨna “Aꞌmwe naangeigɨ, aꞌmwe kwala bwaꞌnaanya naangera gɨmɨnyɨ gyahɨhɨpaledaakava. Yɨ sara yeva yunebanna gɨhɨpaledaakava!” ");
INSERT INTO byr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wɨdɨna kyaꞌ kɨrɨꞌ Jizaazai wɨdɨna “Pɨmɨlɨꞌ ata nyɨdathɨwamwakeinyɨra. Sareꞌ dareꞌnesɨ. Nɨmɨ yɨbwakɨmanɨge. ‘Nɨmɨre dɨragɨnya pimagɨnyaꞌ mena wɨwakeinyɨ daaka!’ yawɨꞌmanɨge.” ");
INSERT INTO byr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wɨdɨna kyaꞌ aꞌmwe dazaꞌ yawɨꞌna yaka “Gamɨnyɨna lɨka myulyaki yɨdeꞌnyɨ daaka!” yawɨraka. Sarevɨdaaꞌnyɨ saꞌ lɨka naanga yɨna yada gamɨnyɨ aya kɨba kwaakevakɨ kwadaai bulagina. Sara yaka aꞌmwe yuyaraayaba gannya nalaayaꞌna asaꞌ dathɨwagakeꞌ wɨjɨwaakɨna yaka nabaai wɨdɨna “Sara yena sagaaꞌ nɨmɨre nalaayaꞌ yarai yɨwɨwakeꞌnera.” ");
INSERT INTO byr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dɨna kyaꞌ sahɨrɨvɨ wɨdɨna “Nyɨraavɨ, gɨmɨre dɨragɨnna nyɨlɨmwamwaanyabwi gɨmɨnyɨ ayɨna tewaanya gyavadaꞌgaimwakeꞌgɨnyɨ. Gɨmɨre munyɨꞌ kave kwaamuꞌ waꞌdozɨ kaanya dɨwona!” ");
INSERT INTO byr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sai yagaalyaꞌ kuna dadaaꞌnyɨ aꞌmwe pwai maremwaaidere angevɨdaaꞌnyai bɨna yɨna yaka maremwaaiderɨ wɨdɨna “Gɨmɨre jɨraavaangeꞌ mena kabaimwakɨra. Nejɨwaakaderɨ yaasɨwaꞌna mamakunnera!” ");
INSERT INTO byr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sara wɨdɨna kyaꞌ kɨrɨꞌ Jizaazai dazaꞌ kadɨka wɨꞌnaka ganɨmaangerɨ jaꞌnawɨdɨna “Gɨmɨ lɨka minnera! Gɨmɨ yune dɨragɨnna dɨnyawɨralɨmwagaka! Sareꞌna gɨmɨre kaimɨraayaꞌ ayɨna tewaanya yɨmaꞌnadesɨ.” ");
INSERT INTO byr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wɨdɨna yaka maremwaaidere angevɨna kaanna wɨna yaka aꞌmweraavɨ mwanganaki, gamɨjɨ angevɨna yeꞌmwannɨgulyaꞌna. Aawa. Sahwai yune Pitarɨjɨ Jonɨmɨjɨ Jemɨzarɨjɨ taayavɨ ganɨmaangeyorɨjɨ maarɨna yaka gamɨjɨ yeꞌmwannɨgwina. ");
INSERT INTO byr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nabaai aꞌmwe yuyara kaimɨraaya dazavɨna kɨnna jakɨnna bazemwaihuna yadaapi kɨrɨꞌ wɨdɨna “Sarɨmɨ kɨnna madɨpɨnera! Saꞌ mena baimwakaꞌ mɨka. Aawa. Saꞌ se warɨka.” ");
INSERT INTO byr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wɨdɨna yadaaꞌnyɨ gamɨnyɨ jɨka maregina. Kumɨ yawɨꞌdɨvɨꞌ “Saꞌ mena baimwakesɨra,” bɨrala wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bɨrala wɨdɨna kyeꞌ sarevɨ kɨrɨꞌ kaimɨraayavɨre asɨrɨ lɨmwagaꞌna yɨna yaka jaka wɨdɨna “Kaimɨraayaꞌgɨ dɨthɨkaaka!” ");
INSERT INTO byr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sara wɨdɨna kyaꞌ taaya dazavɨre kuryai gamɨnyawɨnna ayɨna bɨna yaka bulamwaaina kyaꞌ sagaasagaaꞌ taayaꞌ dɨkavamwaaina. Miꞌna dɨkavamwaaina kyaꞌ sarevɨna sayorɨ wɨdɨna “Sahɨrɨvɨ wapaaya dumaarila!” ");
INSERT INTO byr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Taayavɨ ganɨmaangeyoi atɨka maruꞌnaꞌna yadaakɨlyɨ sahɨyorɨ dɨragɨnna wɨdɨna “Nɨmɨ yɨwe dazaꞌna kɨrɨmɨyoihi aꞌmwe pwaraavɨ nujɨwaakikadɨka!” ");
INSERT INTO byr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sagaaꞌ gamɨre sɨvɨlɨrɨdaaꞌnyɨ pwaraalyaraavɨ jaka wɨjɨvwarɨjɨmaaꞌnyɨna yɨna yaka sare saraavɨ dɨragɨnya naangesɨ naangaangenna yaꞌneraavɨne dɨragɨnyabulyɨ wɨjaavɨna. Yuya yɨmakeraavɨjɨ nalaaya dala nabinanyangɨjɨ marasɨꞌnyaꞌnebwi wɨjaavɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Gotɨyai aꞌmweraavɨ maremwaaidevɨjɨ wɨjɨwaakyaꞌneraavɨ nabaai nalaavɨnakeraavɨ tewaanya yavadaꞌgalyaꞌneraavɨ wɨdaasɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wɨdaasɨna yakegaaꞌ wɨdɨna “Sarɨmɨ gɨlyɨvɨta kaanya yamaryaꞌne aane pɨrɨꞌ kɨrɨꞌ namaapɨdɨka! Yadisarɨkajɨ gɨlya yɨvɨlyajɨ wapaayajɨ nɨgwiajɨ wana yuna namaapɨka! Nabaai sarɨmɨ baazɨꞌmaꞌnya pɨrɨwaaina namaapɨdɨka! ");
INSERT INTO byr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nabaai sarɨmɨ anga pɨrɨvɨ wɨlapɨjɨ yɨ yune anga dazahɨrɨvɨna dɨmwaalyideihɨlyɨ. Anga saba wɨjɨwaakɨna jideihɨlyɨ. Dɨvi anga dazavɨ yagalyaꞌmavapɨjɨ yɨ kaanna dɨwideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pwara kumɨre angengɨna mihɨmakwi yɨhipɨjaraavɨ anga naanga dazaba jahalyaꞌmakwideihɨlyɨ. Sara yapɨjɨyaihi sarɨmɨre sɨvɨlyangɨ kwaatɨrɨdɨrɨnya dɨvurakɨrasɨꞌnɨgwideihɨlyɨ. Sahwara tɨnna wanganapɨjɨ kumɨre sabwinajɨ Gotɨyai taanga wɨjaayaꞌnajɨ yawɨpɨꞌdeꞌnanyɨ. Kumɨnyɨne jalɨkurakyaꞌnesɨ.” ");
INSERT INTO byr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wɨdɨna kyaꞌ sahwara anga yuyabanya kaanya yamarina yadɨvɨꞌ yagaala tewaanyaꞌ wɨjɨwaakɨna yadɨvɨꞌ gazabazaba nalaavɨnakeraavɨ nawɨꞌnya yavadaꞌgalamwaaihɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galɨli saba maremwaalaka maalɨkei Erotɨyai yuya dazangɨneꞌna kadɨka wɨꞌnyɨna yaka yawɨta kwalaalya yɨna. Jizaazarɨna aꞌmwe pwara dɨna “Jonɨ kaviꞌnɨnnyavɨdaaꞌnyai ayɨna dɨkaaꞌmwakerɨnereva.” ");
INSERT INTO byr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nabaai pwara dɨna “Ne Pɨropetɨya Yɨlaajai yɨmaꞌnaabɨvanɨkerɨnereva.” Nabaai pwara “Pɨropetɨya sɨnnawɨ kɨgaakunanya pwai ayɨna dɨkaaꞌmwakerɨnereva.” Sara wɨdesaꞌna yawɨta kwalaalya yɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Sarevɨ Erotɨyai dɨna “Nɨmɨ Jonɨmɨre tɨlɨnnyaꞌ mena woripuragerɨnera. Kɨrɨꞌ aꞌmwe dazai yagaala dazavɨ sasara wɨꞌnɨvanɨgei bewalaka?” Sara dakei “Aꞌmwe sahwarɨ tɨnna wanganɨma!” daka yakelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wɨdaasakera apozelɨyara yagalaawɨna yeva yuya kumɨ yageta sanna gamɨnyɨ wɨdɨna. Mena wɨdɨna kyeꞌ sahwai sahwaraavɨ maarɨna yaka aꞌmwe pwaraavɨ yagalyaꞌmaꞌna yɨna yaka yune kumɨ sarana anga naanga pɨbanna Betɨzaaitha woꞌnɨkebanna kaanna makuna. ");
INSERT INTO byr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Makuna kyaꞌ kɨrɨꞌ dɨvidaaꞌnyɨ aꞌmwera dazavɨna yawɨꞌna yeva sahwarɨ mɨjamakuna. Sara yevera gamɨnyawɨnna yɨkabɨna kyeꞌ gamɨnyawɨnna bahesaꞌna sahwai yɨlaaya yɨna. Yɨlaaya yɨna yaka Gotɨyai aꞌmweraavɨ maremwaaidevɨna wɨjɨwaakɨna. Sara yada aꞌmwe nalaavɨnakeraavɨ nawɨꞌnya yavadaꞌgaina. ");
INSERT INTO byr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Sara kyaꞌ sawɨtɨrɨnyaburɨ gamɨre sɨvɨlɨrɨdaaꞌnyɨ pwaraalyara gamɨnyawɨnna bɨna yɨna yeva wɨdɨna “Gɨmɨ aꞌmweraavɨ kamaryaasaꞌgɨzɨ anga yuyabanyajɨ wawɨnangejɨ sawɨnna ‘Wawopɨjɨ wapaaya napɨjɨ se waꞌmwaraawɨpɨka!’ daꞌgɨzɨ dɨmaryaasa! ‘Nemɨ mwaaihoya dimagɨ aꞌmwera maayɨmagɨnyɨra,’ gɨthɨwoꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sara wɨdɨna kyeꞌ kɨrɨꞌ wɨdɨna “Yune sarɨmɨ saihina tɨka nyaꞌne duzaayɨla!” Kɨrɨꞌ sahwara wɨdɨna “Nemɨ wapaaya kwalaalya manewarika. Bɨretɨya atina yaka jawɨnya pwaraalyɨna warɨka. Aꞌmwe yuya datharaavɨneꞌna nemɨ tɨka munne mubawaadeꞌna sara dahayawɨꞌmwaana?” ");
INSERT INTO byr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Sareꞌ dareꞌnanyɨ. Aꞌmwe paaivɨ taawɨzanɨya (5,000) darerabɨꞌ mwaaidapi. Gamɨre mɨdɨdɨvɨsaraavɨ wɨdɨna “Sarɨmɨ duzɨla! ‘Pivɨti pivɨtiyara avaala pɨba yɨꞌbwaꞌnapɨjɨ nayaa walamwaaina jɨla!’” ");
INSERT INTO byr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wɨdɨna kyaꞌ sara wɨdɨna yeva aꞌmwe yuyaraavɨ nayaa sara waladɨmwaaihɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Waladɨmwaaihɨna kyeꞌ bɨretɨya atɨlya sajɨ jawɨnyaraalyɨ maarɨna yaka Sɨgunyavɨna maranganna yaka “Wapaayanna yɨlaaya gɨmaryɨwa!” wɨdɨna. Sara mena yakegaaꞌ gunyɨna yaka aꞌmwe kwala bwaꞌnaanyaraavɨ yanga bumumulaawiaꞌne gamɨreraavɨ wɨmaarina. ");
INSERT INTO byr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wɨmaarina kyaꞌ yuyaraavɨna wɨjavaawɨna kyeꞌ yunebanna mena nyɨna yeva. Yuyara munya mena yɨnyɨna kwiaꞌ nɨganamudɨwɨraketa yuya sa kuna bwakwodɨꞌnyɨ soigɨlya sɨvɨlɨrɨdaaꞌnyɨ pukaalyangɨ maramihɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pɨgaaꞌ sahwai gavei Gotɨyarɨ wɨdadaaꞌnyɨ gamɨre mɨdɨdɨvɨsara gamɨjɨ yeꞌmwannemwaaina. Sagaaꞌ sahwai sahwaraavɨ yɨdaanganna “Kwala bwaꞌnaanya nɨmɨnyɨna nyɨdɨvanɨgata aaihwainyaka?” ");
INSERT INTO byr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Sarevɨ nabaai sahwara jaꞌnawɨdɨna “Pwara ‘Jonɨ Bavɨtaazɨya Yadelyɨra,’ gɨthɨvanɨgasaigɨnyɨ. Nabaai pwara ‘Yɨlaajalyɨra,’ gɨthɨvanɨgasaigɨnyɨ. Nabaai pwara dɨna ‘Pɨropetɨya sɨnnawɨ kɨgaakunanya pwai gɨlekaviꞌnɨnnyavɨ ayɨna dɨkaaꞌmwakelyɨreva.’ ” ");
INSERT INTO byr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Sara jaꞌnawɨdɨna kyeꞌ sai wɨdɨna “Nabaai yune sarɨmɨ saihi nɨmɨnyɨna nyɨdɨvanɨgata bewainyaka?” Sara wɨdɨna kyaꞌ Pitai jaꞌnawɨdɨna “Gɨmɨ Gotɨyai gɨthahɨlakaka maryasaabakeigɨ Kɨraazɨtɨyaigɨnyɨra. Gotɨyareigɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kɨrɨꞌ kumɨnyɨ dɨragɨnna wɨdɨna “Mala nayaa jɨwannyɨla! Aꞌmwe pwara kwaraavɨ yagaala dazaꞌ wɨjɨwaakyaꞌna kɨmaakɨya miꞌna dakɨwana!” ");
INSERT INTO byr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Sara wɨdɨna yaka wɨdɨna “Aꞌmweraavɨne Kaimɨraayai taanga kwalaalya maaradelyɨra. Sarevɨ nabaai aꞌmwe naangerajɨ Gotɨyarɨne tamiraꞌdɨvɨta naangerajɨ Kɨwɨjarajɨ sahwarɨ buleꞌna wɨjaavɨpɨꞌdelyɨra. Sara yapɨjɨ sahwarɨ tamakɨpɨjai yɨrɨka daryaai darɨkɨ sahwarɨ ayɨna yɨdɨkaavadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sahwai yuyaraavɨ wɨdɨna “Nabaai aꞌmwe pwai kwai nɨmɨnyɨ ‘Mɨdɨnɨma!’ yawɨrajai gamɨ sai gannya sɨmunyavɨ wiekɨrakada yuya yɨrɨkerɨkaavɨ gannya yɨta yovihɨrarannɨkeꞌ nayaa marikwavadeꞌbɨꞌna ‘Nɨmɨ Jizaazarɨna baimujaꞌ tewaanyasɨ. Aꞌmwera Jizaazarɨna kayaaꞌna nyɨpɨꞌdeꞌ wikɨra,’ yawɨꞌda nɨmɨnyɨ sɨvigɨꞌnyɨrɨ nayaa nyɨmɨdɨnadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sareꞌ dareꞌnesɨ. Aꞌmwe pwai ‘Jizaazarɨna nanyɨramakɨpɨdɨka!’ dazai nɨmɨnyɨ nyɨmarasɨꞌnajai kuna mwaalade kɨrɨꞌ gamɨre gaala mwaalyabwi yagalyaꞌmavadevulyɨ. Kɨrɨꞌ pwai nɨmɨnyɨna yawɨrojɨ balajai dɨragɨnna nyɨlɨmwagazai yɨ yɨnɨga wiꞌnanyɨra. Sahware gaalyabwi tewaanna padaihasamaaꞌnadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Sareꞌ dareꞌnesɨ. Aꞌmwe pwai nɨgwia gɨlyɨvɨta saza Kwaakevakɨya yuya sa maarajai sarevɨ gamɨ sai yuna kayaaka yɨmaꞌnada nabaai gamɨre gaala mwaalyabwi yagalyaꞌmavojɨ gamɨ yuya maarɨna yaja sasare daza gamɨnyɨ gathaꞌdara gaimwagathengaka! ");
INSERT INTO byr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sareꞌ dareꞌnesɨ. Aꞌmwe pwai nɨmɨnyɨnajɨ nɨmɨre yagaalyavɨnajɨ sangɨna ‘Wagɨla nanyɨvwaꞌnadɨka! Sahwarɨ wasɨꞌnɨma!’ dazai Aꞌmweraavɨne Kaimɨraayai gannya byaanna naangevɨjɨ Nɨmwarevɨjɨ ejelɨya tewaanyaraavɨrevɨjɨ walaabathehaaꞌ yɨ sahwai ‘Aꞌmwe dazai kwarɨna wagɨla nanyɨvwaꞌnadɨka! Bule wɨjaavɨma!’ wɨdathelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sareꞌ kɨrɨꞌ nebulyaꞌna yɨhɨthɨvanɨge. Nabaai aꞌmwe pwara dava daakata dara yarai mabalyadapi Gotɨyai aꞌmweraavɨ maremwaaidevɨ tɨnna wangabɨꞌdehaaꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yagaala daza mena dakegaaꞌ, dɨvi yɨrɨka ata purɨdaaꞌnyɨ daraai mena kwavɨlavaꞌ sahwai Pitarɨjɨ Jonɨmɨjɨ Jemɨzarɨjɨ maarɨna yɨna yaka mugunyavɨna Gotɨyarɨ wɨjaꞌnei yɨlaawɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yɨlaawɨna yaka Gotɨyarɨ kuna wɨdɨvainadaaꞌdɨꞌnyɨ gamɨre sɨnnyɨꞌ mudɨka pwaibɨꞌ yɨmaꞌnyɨna yaka nabaai gamɨre baazɨꞌmaꞌnyaꞌ yuna yaakeꞌ wannyɨna, kɨmihɨmɨla yɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sara kyaꞌ, yɨthaa, aꞌmwe pwaraai sahwalyɨ yagaala yeꞌmwannadɨna. Pwai Ne Mozɨzalyɨ. Pwai Ne Yɨlaajalyɨ. ");
INSERT INTO byr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yɨ sahwaraai byaanna naangevɨ yagɨleraai yɨmaꞌnaabɨna yagɨla sare saraai Jizaazai Jeruzaalemɨ yuneꞌna yaꞌna sanna dɨnyɨna. Sahwai Kwaaka davakɨ yagalyaꞌmavojɨ wawodelyɨra. ");
INSERT INTO byr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Wɨdɨna yadaapi Pitalyɨ pwaraai gamɨjɨyaraalyɨ seyɨvɨta kwimaꞌnaꞌ kɨrɨꞌ yaaka dɨkavayɨmaꞌnyɨna yeva byaanna naangeꞌ sahwarɨdaaꞌnyɨ kimaꞌnaꞌ tɨnna nayaa wanganna. Nabaai aꞌmwe dazaraai kwaraalyɨ sahwalyɨ yeꞌmwannadaaꞌdakɨlyɨ tɨnna wanganna. ");
INSERT INTO byr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Saraai “Gamɨnyɨ yagalyaꞌmavakwoihɨlyɨ wawaka!” dahɨla yadaakɨlyɨ Pitai Jizaazarɨ wɨdɨna “Aꞌmwe naangeigɨ, nemɨ dava mwaaihoyaꞌ tewaanyasɨra. Sɨmɨnya dawaai dasa yarɨlaadeinera. Pɨrɨꞌ gɨmɨnyɨneꞌ, pɨrɨꞌ Mozɨzarɨneꞌ, pɨrɨꞌ Yɨlaajarɨneꞌ.” Pitai sahwai sɨmunya nayaa myawɨryakei yagaala dazaꞌ sara wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kuna wɨdɨna yadaaꞌnyɨ yɨraaya pɨjɨꞌ galayewaaꞌmwanna. Yɨraayajɨꞌ galayewaaꞌmwanna yadaaꞌnyɨ sahwara lɨka naanga yɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lɨka yɨna yadaapi yɨraaya savɨ kusawɨdaaꞌnyɨ maanguraaya pɨrɨꞌ jaka yɨnyɨna “Dathai nɨmɨre Nyɨbwaalɨvaangelyɨra. Nɨmɨ mena wɨdahɨlakelyɨra. Gamɨre yagaalyavɨ kadɨka duꞌnyɨla!” ");
INSERT INTO byr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Maanguraaya dazaꞌ mena kabinɨgwawaꞌ Jizaazai yuna gavei mwaaidɨꞌnyɨ tɨnna wanganna. Sara yeva kumɨre maange bɨpaina. Nabaai dazagaaꞌ aꞌmwe aane pwai kwarɨ sahwara tɨnna wanganeta sanna mujɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yɨrɨka ayawɨdaasarɨkɨ mugunyavɨ yagalyaꞌmaveva walaawɨna kyeꞌ aꞌmwe kwala bwaꞌnaanya naangeꞌ gamɨnyɨna burataꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Burataꞌnyɨna kyeꞌ, yɨthaa, aꞌmwe pwai kwala bwaꞌnaanya dazavɨdaaꞌnyai jaka danganna, “Wɨjɨwaakadɨnyaigɨ, dɨragɨnna githaanganɨma! Nɨmɨre kaimɨraayarɨ tɨnna dɨnyanganya! Nɨmɨ kaimɨraaya yune gave dazahwainanyainyɨra. ");
INSERT INTO byr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sare sarɨ, yɨthaa, yɨmakei galapwelɨmwagaꞌdelyɨra. Sara wiadaaꞌnyɨ sahwai jaahwasaꞌbɨꞌ kayaaꞌjaka dadelyɨra. Nabaai sara yada yɨmaka dazai yuna kayaaꞌna galarɨvɨtawakadelyɨra. Sara wiadaaꞌnyɨ gamɨre maangevɨdaaꞌnyɨ maagwaitala yaakeꞌ yɨmaꞌnaabadelyɨ. Gamɨre kɨlaakejɨkɨ yuna kayaaka wigalakada yarai yagalyaꞌmakwodei mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nabaai ‘Yɨmaka dazai marasɨpɨka!’ dena gɨmɨre mɨdɨdɨvɨsaraavɨ wɨdena yagɨnna yɨdangadaari kɨrɨꞌ yuna aawaawa. Myɨ yɨpɨnere.” ");
INSERT INTO byr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jaka sara danganna kyaꞌ Jizaazai jaꞌnawɨdɨna “Sarɨmɨ aꞌmwe dathahaasaihi dɨragɨnna lɨmwangebwi kuneihi, sarɨmɨre sɨmunyaꞌ nayaa yɨdaꞌna mwarikeihi, sarɨmɨjɨ kuna gathaꞌdaregaaꞌna yɨhyeꞌmwannemwaalaꞌmujɨ sarɨmɨre taanginya maarɨdeinyaka! Gɨmɨre kaimɨraayai davanna dɨmakulaama!” ");
INSERT INTO byr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wɨdɨna kyaꞌ gamɨre kaimɨraayai kuna widavadaaꞌnyɨ yɨmaka dazai kwaakewɨ marawɨnangɨrakɨna yaka yuna kayaaꞌna yawɨnangɨrakɨna. Sara wiadaaꞌnyɨ kɨrɨꞌ Jizaazai yɨmaka dazarɨ maanga wɨdɨna yaka kaimɨraayarɨ tewaanya yavadaꞌgaina yɨna yaka ganɨmaangerɨ ayɨna wɨjaavɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Sarevɨ aꞌmwe yuyara Gotɨyare dɨragɨnyaꞌ byaanna savɨ tɨnna wanganeva lɨka yɨwainɨgulɨna. Aꞌmwe yuyara Jizaazai yaka yuya dazanna atɨka kuna maruꞌnaꞌna yadaapi gamɨre mɨdɨdɨvɨsaraavɨ wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Sarɨmɨ yagaala dathavɨneꞌna gɨthɨdeꞌ kadɨkikɨ nayaa dakyɨla! Daꞌdaresɨ. Dɨvi kɨbawe maalɨkegaaꞌ Aꞌmweraavɨne Kaimɨraayainyɨ nɨmɨre yɨkamaangeraavɨna nyɨbwarɨdaakwadeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kɨrɨꞌ sahwara yagaala dazavɨ nayaa myawɨramaari. Yagaala dazavɨne aaya kaavɨlyaꞌ sahwaraavɨna kukuꞌnya wɨlaꞌna. Sarevɨdaaꞌnyɨ sahwara sahɨrɨvɨna nayaa myawɨramaari. Sarevɨ nabaai sahwara yagaala dazavɨna yɨdaanganyaꞌna lɨka yɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sagaaꞌ gamɨrera gemarasɨꞌnyɨyagaala pɨrɨꞌ “Nemɨjɨya naangei aaihwalaka? Nɨmɨnyɨra. Nɨmɨnyɨra,” geꞌ bivɨkɨꞌnɨguna. ");
INSERT INTO byr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Geꞌ bivɨkɨꞌnɨguna yadaapi Jizaazai kumɨre sɨmunyavɨ gemarasɨꞌnyɨyagaalyavɨ yawɨranganna. Yawɨranganna yaka sarevɨ sahwai kaimɨraaya maalɨka pɨmɨlɨꞌ maarɨna yaka gamɨjɨ maryeꞌmwannadaaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Sara yaka sai wɨdɨna “Aꞌmwe pwai kaimɨraaya maalɨka dathamɨlɨkɨ nɨmɨnyɨne yayavɨna maarajai sai nɨmɨnyɨ nyɨmaaradelyɨ. Nabaai sai nɨmɨnyɨ nyɨmaarajai yɨ nɨmɨnyɨ nyɨmaryasaabaka dazarɨ maaradelyɨ. Sarebwi dareꞌnebulyɨ. Aꞌmwei sarɨmɨ yuyaihɨrɨneꞌna tɨnnyabanyai yuna maalɨka mwaalajai yɨ Gotɨyarɨna sai yuna naangelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jonɨ jaꞌnawɨdɨna “Aꞌmwe naangeigɨ, aꞌmwe pwai gɨmɨnyɨne yayavɨ yɨmakeraavɨ wɨdasadaaꞌnyɨ tɨnna wangamwoine. Sara yada kɨrɨꞌ nemɨnyɨ manemɨdɨnyɨvanɨkeꞌna sahwarɨna kɨmaakɨya dakɨwolyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wɨdɨna kyaꞌ kɨrɨꞌ Jizaazai sahwarɨ wɨdɨna “Sahwarɨna kɨmaakɨya madakɨpɨnera! Sareꞌ dareꞌnanyɨ. Aꞌmwei sarɨmɨnyɨna yɨkamaanga mihivanɨkei sai sarɨmɨnyɨnelyɨra. Yɨkamaangei mɨka!” ");
INSERT INTO byr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jizaazarɨ Sɨgunyavɨna makilaawia yaꞌne Gotɨyaregaaꞌ aya kɨgaaꞌ mena kimaꞌnaꞌ gamɨre sɨmunyai yovɨrawakɨna yaka Jeruzaalemɨna kaanya wɨyaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sarevɨ gamɨnyɨ sɨnnawɨ yovɨrawakaawiaꞌna pwaraarɨ yagaalyaꞌ wɨdaasɨna. Miꞌna wɨdaasɨna kyaꞌ dazaraai kaanna wɨna yeva Samerɨya mwaalyaraavɨre anga pɨbanna wɨlaawɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sabanna wɨlaawɨna kyagi kɨrɨꞌ anga dazabanyara Jizaazarɨ kumɨre angengɨna makwɨyaꞌna “Aala!” dɨna, mamaari. Sahwara yawɨꞌdɨvɨꞌ “Sahwai Jeruzaalemɨna wawadeꞌnanyɨra. Nemɨre naangebanna mɨꞌ.” Sahwara gevwi yadɨvɨsaꞌna “Aala!” dɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","“Aala!” dɨna kyeꞌ gamɨre mɨdɨdisaraai Jemɨzalyɨ Jonɨjɨ sahwaraai sasare saburɨ wanganagɨla wɨdɨna “Naangeigɨ, kayaaꞌna sara yɨwaasaꞌna Sɨgunyavɨdaaꞌnyɨ dɨkeꞌna kudawaajɨ dɨkeꞌ walaabozɨ aꞌmwe datharaavɨ dɨkeꞌ nakadeꞌna sɨmunya myawɨrijɨwaana?” ");
INSERT INTO byr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wɨdɨna kyagi kɨrɨmɨnyɨmagɨ gɨnyɨmaꞌnyɨna yaka maanga wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Maanga wɨdɨna yaka sahwara anga pɨbannera kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sahwara tutaanyavɨ kaanya wodɨvɨꞌ aꞌmwe pwai gamɨnyɨ wɨdɨna “Gɨmɨ kaanya yamarija anga yuya sabanya nɨmɨ kwainyɨjɨ gɨmɨdɨnamarideinyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Wɨdɨna kyaꞌ Jizaazai wɨdɨna “Kavɨjɨlɨkera kwaakevakɨ kumɨre daibuꞌnya kɨnɨnnakerera. Nabaai sɨgunyavɨne yuta kwarajɨ arɨsa kɨnɨnnakerera. Sareꞌ kɨrɨꞌ Aꞌmweraavɨne Kaimɨraayai gamɨre mɨnyagɨnyɨꞌ yɨladɨhaihɨta yaꞌneba kunelyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wɨdɨna yaka aꞌmwe pwarɨ wɨdɨna “Nɨmɨnyɨ dɨnyɨmɨdɨnaama!” Kɨrɨꞌ sai wɨdɨna “Gɨmɨ nɨmɨnyɨna ‘Ya,’ majɨ jɨtheigɨ dɨngaka? Nɨmɨnyɨ nɨmaamaangerɨ tɨviꞌna maralɨkirakaawaꞌmujɨneinyɨra. (Miꞌna kabalojɨ bɨdeinyɨra.)” ");
INSERT INTO byr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wɨdɨna kyaꞌ kɨrɨꞌ sahwarɨ wɨdɨna “Baaꞌnana! Pwara, Gotɨyarɨna majadɨvɨsara, kurya bainɨkera baryaraavɨ maralɨkirakɨpɨꞌderera. Kɨrɨꞌ gɨmɨ kaanya wawaꞌgɨzɨ Gotɨyai maremwaaidevɨna aꞌmweraavɨ duzɨwakaawa!” ");
INSERT INTO byr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wɨdɨna kyaꞌ nabaai aꞌmwe pwai wɨdɨna “Naangeigɨ, gɨmɨnyɨ gɨmɨdɨmune kɨrɨꞌ nɨmɨnyɨna ‘Ya,’ kyawɨraꞌgɨzɨ nɨmɨ wawoꞌmujɨyagaaꞌ nɨmɨjɨ avaaimwaalya yuyaraavɨ ata yuneꞌna bwaꞌnaawɨdeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sarevɨ Jizaazai sarɨ wɨdɨna “Pwai nɨmɨre wawɨnya yadei kwai kɨrɨꞌ yuyagaaꞌ dusɨmagɨnna gamɨre ayabwina gɨnyɨmaꞌnangadei sasare sai Gotɨyai aꞌmweraavɨ maremwaaideꞌna wɨjɨwaakyaꞌnei yɨnɨga wiꞌna yadei mɨka.” ");
INSERT INTO byr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Sa yaka dɨvidaaꞌnyɨ Naangei aꞌmwe sevedituya (72) pwaraavɨjɨ dahɨlakɨna yaka pwaraarɨna pwaraarɨna maryaasɨna. Gamɨnyɨneꞌna sahwaraavɨ sɨnnawɨ wɨdaasɨna. Anga naanga yuyabanyaavɨnajɨ anga maalɨka yuyabanyaavɨnajɨ dɨvidaaꞌnyɨ yune gamɨ saina wɨyaꞌnebanyana sahwaraavɨ maryaasɨna. ");
INSERT INTO byr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Sarevɨ sai sahwaraavɨ wɨdɨna “Pɨrɨꞌ daresɨ. Tɨka munne kwalaalya wawɨnyavɨ mena yovɨgaipwakɨnɨkengɨra. Pɨrɨꞌ daresɨ. Tɨka munne maaryaꞌne aꞌmwera kwalaalyara mɨka. Sarevɨdaaꞌnyɨ sarɨmɨ wawɨnyavɨ Naangerɨ kidaanganapɨjɨ gamɨre tɨka wapaaya mariꞌbwarakyaꞌnera gamɨre wawɨnya wɨdaayadɨvɨsaraavɨ yarai wɨdaasaderera. ");
INSERT INTO byr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nabaai sarɨmɨ kaanya dɨwila! Yɨthaanyi! Nɨmɨ yɨhɨmaryaasɨweihi kavɨjɨlɨkeraavɨ tɨnnyabanna sipɨzipɨya maalɨkebɨsaihi dɨwideihɨlyɨra. ");
INSERT INTO byr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sarɨmɨ nɨgwɨpaawɨzɨyasɨ gɨlyasɨ kwaariꞌmasɨvɨla pɨrɨwaalyɨ namaapɨdɨka! Tutaanyavɨ aꞌmwera badaapiyaraavɨ aangaaꞌna dɨvainadaasaꞌna ‘Nyaꞌmwei! Nyaꞌmwei!’ mudɨpɨna! ");
INSERT INTO byr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nabaai sarɨmɨ anga pɨrɨvɨ wɨlapɨjɨ yɨ sɨnnawɨ aayagaaꞌ dara duzideihɨlyɨ ‘Anga davɨ wɨlamwaaidɨvɨsangihɨrɨ kave kwaamuꞌ tewaanya yɨhwarana!’ ");
INSERT INTO byr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nabaai aꞌmwe pwai kave kwaamuꞌ maaꞌdei anga dazavɨyai mwaalajai yɨ sarɨmɨ kwaamuꞌ wɨjaavɨpɨja saꞌ dazarɨ wɨlawɨwaradesɨ. Kɨrɨꞌ nabaai aꞌmwe pwai sasara mi yajaꞌ yɨ sabwi sarɨmɨnyawɨnna ayɨna bozɨ kwɨyakwaihɨrɨ bihwaradesɨ. ");
INSERT INTO byr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kɨrɨmɨnyɨ maarɨna yɨpɨjara sahwaraavɨre yune anga gave pɨrɨvɨna dɨmwaalyideihɨlyɨ. Sara yapi tɨka wapaajɨna aalyajɨna yɨhɨzaavɨpɨja dɨnyideihɨlyɨ. Sareꞌ dareꞌnanyɨ. Wawɨnya wɨdaayadei gannya wawɨnyaꞌna gannya nɨgwia yɨnɨga wiꞌna maarannelyɨ. Sarebaaibɨꞌna yɨhɨzaavɨpɨja dɨnyideihɨlyɨ. Anga pɨrɨvɨdaaꞌnyɨ anga pɨrɨvɨna tɨka wapaaya maaryaꞌneihi yaasɨwaꞌna nyamaripɨka! ");
INSERT INTO byr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nabaai sarɨmɨ anga naanga pɨba kulaawopɨjɨ sahɨbanyara yɨhɨmaarapɨjɨ kunnya angengɨna kihɨmakwopɨjɨ yɨ wapaaya yanga yɨhɨzaavɨpɨja dɨthaapyideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nabaai anga dazabanya aꞌmwe nalaavɨnakeraavɨ ayɨna tewaanya yavadaꞌgaina jideihɨlyɨ. Sara yapɨjɨ duzideihɨlyɨ ‘Gotɨyai aꞌmweraavɨ maremwaaideꞌ yɨmaꞌnaabathehaaꞌ sarɨmɨnyɨna mena aya kɨgaaꞌ yɨmaꞌnaabɨwaka.’ Sara duzideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kɨrɨꞌ sarɨmɨ anga naanga pɨbanna kulaawapɨjɨ sahɨbanyara kunnya angengɨna mihɨmakwɨyɨ kihyapɨri yɨ anga dazabadaaꞌnya tuꞌmaangeba davaawapɨjɨ dara dɨzideihɨlyɨ ");
INSERT INTO byr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Sarɨmɨre anga dazabadaaꞌnyɨ kwaatɨryamɨlɨka naarɨmɨre sɨvɨlyangɨ nehɨmɨwɨꞌnɨwake sarɨmɨnyawɨnna ayɨna yɨhɨpurakɨrasɨꞌnaabakadengɨ. Sareꞌ kɨrɨꞌ sɨmunya nayaa dara jawɨrila! “Gotɨyai aꞌmweraavɨ maremwaaideꞌ yɨmaꞌnaabathehaaꞌ mena aya kɨgaaꞌ yɨmaꞌnaabɨwaka!” ");
INSERT INTO byr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nɨmɨ yɨhɨthɨvanɨge. Yɨrɨka aaya sarɨkɨ anga naanga dazahɨbanyaraavɨ taanginya naanga wɨjaavadere. Taanginya dazaꞌ kayaaꞌnanyara Sothomɨ mwaalyaraavɨ taanginya naangeꞌ wɨjaavadeꞌ wavɨlavadesɨ. ");
INSERT INTO byr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Weꞌ! Korazinɨ mwaalyaihɨle! Weꞌ! Betɨzaaitha mwaalyaihɨle! Weꞌ! Nɨmɨ anga Taayaajɨ anga Saaithonɨjɨ sabanyaai nɨmɨre dɨragɨnyaꞌ yɨwɨjɨ kwajɨ sarɨmɨre angeba nɨmɨ yebaaibɨꞌ yɨ sarevɨ sɨnnawɨ yɨmeꞌnyaꞌbɨꞌ sabanyaalyara kaleꞌna baazɨꞌmaꞌnya mumunyɨꞌnɨka baazɨꞌmaꞌnadɨvɨꞌ kwaagɨsavɨ mwaalapɨjɨ sɨmunya mudɨkeꞌ kyawɨpɨdɨka! ");
INSERT INTO byr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sare kɨrɨꞌ Gotɨyai aꞌmweraavɨ maryawɨbwata yadehaaꞌ taanginya naangeꞌ Taayaajɨ Saaithonɨjɨ sabanyaalyaraavɨ wɨjaavadere. Taanginya naanga sarɨmɨnyɨ yɨhɨzaavadeꞌ yɨ sahwaraavɨrevɨ wavɨlavadesɨ. ");
INSERT INTO byr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nabaai Kaapanɨyamɨ mwaalyaihi ‘Nemɨ Sɨgunyavɨnna nennya yaya makɨlaana!’ dadɨvɨꞌ kɨrɨꞌ yune Dɨkevɨna dalaawideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aꞌmwei sarɨmɨre yagaalya kadɨka nayaa yɨhuꞌnajai yɨ sai nɨmɨre yagaalya kadɨka nyuꞌnadelyɨ. Nabaai aꞌmwei sarɨmɨnyɨ buleꞌna yɨhɨzaavajai yɨ sai nɨmɨnyɨ buleꞌna nyɨjaavadelyɨ. Kɨrɨꞌ nɨmɨnyɨ buleꞌna nyɨjaavajai yɨ sai nɨmɨnyɨ nyɨmaryasaabaka sai kwarɨjɨ buleꞌna wɨjaawakelyɨra.” Jizaazai sara wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Dɨvi aꞌmwe sevedituyara ayɨna beva sahwara yɨlaaya naanga yɨna yadɨvɨꞌ wɨdɨna “Naangeigɨ, nemɨ gɨmɨnne yayaꞌ kumɨnyɨ wɨdaasaꞌneina wɨdadaawori yɨmaka kwarajɨ nemɨre yagaalyangɨ mɨdɨdɨvɨꞌ aꞌmweraavɨ yagalyaꞌmakuna yesarera.” ");
INSERT INTO byr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Sara wɨdɨna kyeꞌ sai wɨdɨna “Yɨmakeraavɨ wɨdaasɨwaꞌdaasagaaꞌ nayaa dara wangamwaꞌde ‘Yɨraayavɨ yɨꞌmunya pidevaaibɨꞌ Saataanɨmɨre dɨragɨnyaꞌ yarai bwalarakelyɨ.’ ");
INSERT INTO byr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yɨthaanyi, sarɨmɨnyɨ dɨragɨnyaꞌ mena yɨhɨzaawa. Yɨ sarevɨdaaꞌnyɨ naawɨnaanyaraavɨjɨ marayɨnɨgaawalyaraavɨjɨ sɨvɨlyaꞌ yɨnɨga bɨzaꞌjɨvaibɨneihɨlyɨ. Nabaai Yɨkamaangerɨne dɨragɨnya yuya sangɨ yɨnɨga wiꞌna davɨlayideihɨlyɨ. Sarevɨ sarɨmɨnyɨ kayaaka yɨgalakyaꞌne yuya pɨnɨ sa kayaaka yɨnɨga wiꞌna yɨhigalakade mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sare kɨrɨꞌ sarɨmɨ yɨlaaya myadɨvɨꞌ dara yɨvanɨgasaihɨlyɨ ‘Yɨmakera nemɨre yagaala dɨvanɨgo dangɨ mɨdɨnna kyɨwaaꞌ wɨdaasɨvanɨgorera.’ Aawa. Sabwi maalɨkebulyɨ. Sarɨmɨnyɨne yaya Sɨgunyavɨ mena yavɨkaryakɨwakebwi naangebulyɨ. Sareꞌna Gotɨyarɨna yɨlaaya nayaa jɨla!” ");
INSERT INTO byr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Dazagaasagaaꞌ Kurya Tewaanyai Jizaazare sɨmunyavɨ yɨlaaya yɨwagɨmwaaihɨna yɨna kyaꞌ sahwai wɨdɨna “Nɨmwai, gɨmɨ saigɨ Sɨgunyavɨnajɨ Kwaakevakɨnajɨ yuna Naangeigɨnyɨ. Gɨmɨre yayaꞌ munyaba makimanɨge. ‘Su! Su!’ Gɨmɨ aꞌmwe daraavɨ sɨkulɨya myaraavɨna yuya da wibwarɨdakuwaanyaigɨnyɨ. Yɨ aꞌmwe sɨmunnakeraavɨnajɨ sɨkulɨya yaraavɨnajɨ yuya da lɨka yulyakɨwaanyaigɨnyɨ. Yɨ sareꞌna gɨmɨre yayaꞌ munyaba makimanɨge. Yo, Nɨmwai gɨmɨre sɨmunya sabwi yune sasarebulyɨ. Sareꞌna sara yadɨnyaigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sara wɨdɨna yaka aꞌmweraavɨ wɨdɨna “Nɨmaamaangei sɨmunya yuya nyɨmarɨmwangakeinyɨ. Sarevɨdaaꞌnyɨ Gawaalɨvɨ aaya kaavɨlyaꞌ yawɨrangadei aꞌmwe aane pwai kwai mɨꞌ. Aawa. Sahwarɨ Nɨmwai yune gave sahwaina yawɨrangadelyɨ. Sarevɨ nabaai Nɨmwarɨ yawɨrangadei aꞌmwe aane pwai kwai mɨꞌ. Aawa. Sahwarɨ yune Gawaalɨꞌna yawɨrangadelyɨ. Nabaai aꞌmweraavɨ Gawaalɨꞌ Nɨmwarɨ wibwarɨdaakwajara, sara Nɨmwarɨ yawɨrangabɨꞌdere.” ");
INSERT INTO byr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yune gamɨre mɨdɨdɨvɨsarana Jizaazalyɨ yeꞌmwannamwaaleva yɨ sahwai kumɨnyɨmagɨnna gɨnyɨmaꞌnyɨna yaka wɨdɨna “Sarɨmɨ wangamanɨgasangɨ pwara wangadɨvɨꞌ sahwara yɨlaaya naanga yadɨvɨꞌ tewaanaanga winadere. ");
INSERT INTO byr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sareꞌ dareꞌnesɨ. Nɨmɨ yɨhɨthɨvanɨge. Ne pɨropetɨya kwalaalyarajɨ ne kingɨya kwalaalyarajɨ yuyangɨ sarɨmɨ tɨnna wangamanɨgata sangɨ ‘Wanganaana!’ deva yeta kɨrɨꞌ sahwara tɨnna mwanganyɨna. Nabaai yagaala sarɨmɨ kadɨka wɨꞌnɨvanɨgata dazangɨ ‘Kadɨka wɨꞌnaana!’ deva yeta kɨrɨꞌ sahwara kadɨka muꞌnyɨna. Sareꞌna yɨlaaya jɨla!” ");
INSERT INTO byr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sagaaꞌ, yɨthaa, kɨwɨnyangɨ wɨjɨwaakade pwai Jizaazarɨ yaamɨjɨ walapapalakyaꞌnei daavɨna yaka wɨdɨna “Wɨjɨwaakadɨnyaigɨ, gara yaꞌmujɨ yuyagaaꞌ yuyagaaꞌne gaala mwaalyabwi maaꞌmuneinyaka?” ");
INSERT INTO byr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sara wɨdɨna kyaꞌ sai wɨdɨna “Kɨwɨnyavɨ be yagaalyaꞌ dɨnɨkevaka? Gɨmɨ gathaꞌdara dangamanɨgɨ?” ");
INSERT INTO byr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wɨdɨna kyaꞌ sahwai jaꞌnawɨdɨna “Naangei gɨmɨre Gotɨyai sahwarɨna gɨmɨre sɨmunya yunevɨ yuna tewaanya gɨvuꞌnadeigɨnyɨra. Nabaai gɨmɨre kurya yuyarɨ yuna tewaanyarɨnajɨ gɨmɨre dɨragɨnya yuyavɨ yuna tewaanyarɨnajɨ gɨmɨre sɨduta yuyavɨ yuna tewaanyarɨnajɨ gɨvuꞌnadeigɨnyɨ. Nabaai yune gɨmɨ saigɨnyɨna tewaanya gɨvuꞌnadevaaibɨꞌ aꞌmwe pwarɨna avaaimwaalya kwarɨna tewaanya nayaa gɨvuꞌnada duhaimwadeigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wɨdɨna kyaꞌ sai wɨdɨna “Gɨmɨ yagaala nebulyaꞌ jaꞌnanyɨdɨwaanyaꞌ. Yɨ sasara yaꞌgɨzɨ yuyagaaꞌ gaala dɨmwaaideigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sareꞌ kɨrɨꞌ sɨduꞌnakei yawɨꞌna “Pwara nɨmɨnyɨna yawɨpɨka! ‘Sahwai sasarebwine yɨdaꞌmaraangei mwaaidelyɨ.’ ” Sara yawɨꞌna yaka Jizaazarɨ wɨdɨna “Nɨmɨnyɨ avaaimwaalyai bewalaka?” ");
INSERT INTO byr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sara wɨdɨna kyaꞌ Jizaazai sahwarɨ dara jaꞌnawɨdɨna “Juya pwai Jeruzaalemɨ yagalyaꞌmavaka Jerikonei kaanya waidawadaaꞌnyɨ tutaanyavɨ aꞌmwe yɨpalamaaꞌdɨvɨsara sahwarɨ bɨramaareva sahware gɨlyɨvɨta yuya yɨpalamaaꞌna yɨna yeva yɨraipɨvalakɨna yɨna yeva mala naanga miꞌna tameva balyaꞌneba yagalyaꞌmaꞌna yɨna yeva kaanna wɨna. Sarei sai tutaanyavɨ warɨna yadɨꞌnyɨ sai mena balya yaꞌneba. ");
INSERT INTO byr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Dazagaaꞌ tutaanya dazavɨ Gotɨyarɨna mubɨthɨka yɨraꞌdei pɨrizɨya pwai kaanna wɨna. Kaanya sara wodehaaꞌ aꞌmwe sarɨ tɨnna wanganalɨkɨmawakaabɨna yaka sarɨ wangamabɨna yɨna yaka tutaamaangebaarɨ yaaikaanna wɨna yaka wavɨlakuna. ");
INSERT INTO byr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sasare sahɨbaaibɨꞌ nabaai Gotɨyare Angevɨ wɨdaayadei Livaaya pwai sahimagɨ biꞌmaꞌna yɨna yaka aꞌmwe sarɨ kave wanganyɨkɨmawakaabɨna yaka sarɨ wangamabɨna yakegaaꞌ tutaamaangebaarɨ yaaikaanna wɨna yaka wavɨlakuna. ");
INSERT INTO byr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nabaai aꞌmwe Samerɨya mwaalya pwai Juyara jɨkurɨtɨnna yadɨvɨsaraavɨdaaꞌnyai tutaanyavɨ kaanya badehaaꞌ aꞌmwe sai waꞌdɨsɨyaba biꞌmaꞌna. Miꞌna biꞌmaꞌna yaka sahwarɨ tɨnna wanganna yaka kale naanga yenyɨꞌnanganna. ");
INSERT INTO byr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Sara yakei sahwaryabanna wɨlaawɨna yaka gamɨre kɨlaakejɨkɨ mala tamagɨthaaihɨresangɨ welivananyasɨ waainɨyasɨ dɨngavuꞌna yaka waꞌwaaya sangɨ wɨla pwɨyɨna. Sara mena yaka aꞌmwe sarɨ dɨhaaꞌbwaꞌna yaka gamɨre dogiyarɨ munyaba yɨlamaramwaaihɨna yaka kaanna makwalaawɨna, angavaavɨhaanya wodɨvɨsara waraawiaꞌne angevɨna marakaawɨna yaka nayaa maremwaaina. ");
INSERT INTO byr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sarevɨ yɨrɨka dɨvidaaꞌnyarɨkɨ gamɨre gɨlyavɨ nɨgwia pukaai daapɨna yaka aꞌmwe anga angavaayara waryaꞌne savɨ gyakwarɨ wɨjaavɨna yaka wɨdɨna ‘Aꞌmwe datharɨ nayaa dɨmaremwaaidelyɨra. Nabaai gɨmɨre nɨgwia pɨnɨjɨ aꞌmwe darɨna yɨgainamayɨꞌdɨzaꞌ yɨ ayɨna baꞌmujɨyagaaꞌ nɨmɨre nɨgwia bahɨzaavɨdeinyɨ.’ ” ");
INSERT INTO byr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jizaazai sara wɨdɨna yaka wɨdɨna “Dahaaꞌ gɨmɨ gara dahayawɨꞌmwaana? Daraai dala saraavɨdaaꞌnyɨ pwai aꞌmwe yɨpalamaaꞌdɨvɨsara sara kyeꞌ kayaaka yɨnaka dazarɨna avaaimwaalyai yɨmaꞌnakei bewai dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sara wɨdɨna kyaꞌ sahwai wɨdɨna “Aꞌmwe kale kwiaꞌ gaimwanga yaka dazalyɨ.” Wɨdɨna kyaꞌ Jizaazai wɨdɨna “Gɨmɨ wawoꞌgɨzɨ avaaina sasara jɨtheigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kaanya wodɨvɨsagaaꞌ Jizaazai anga pɨbanna kaanya wɨlaawɨna. Kaanya wɨlaawɨna kyaꞌ aꞌmwe pɨrɨꞌ gamɨnne yayaꞌ Maathaꞌ sahɨrɨꞌ gamɨre angevɨna “Dɨneyɨrɨꞌmarɨmwaaihya!” wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aꞌmwe sareꞌ gamɨnyɨ ganyaabulaangeꞌ sahɨrɨvɨne yayaꞌ Maarɨyaaꞌ kɨnɨnnakesɨ. Maarɨyaa saꞌ Naangere sɨvigɨꞌnyɨryawɨ bulamwaaina yaka sahware yagaala dadaaꞌnyɨyangɨ kadɨka bulawɨꞌbaleꞌna. ");
INSERT INTO byr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kadɨka bulawɨꞌbaleꞌna yadɨꞌnyɨ Maathaꞌ tɨka wapaaya yovɨrawakyaꞌ wawɨnya kwalaalya biwɨna. Sara biwoda gamɨre sɨmunyai kewi kewi sɨmunya yawɨꞌdaaꞌnyɨna. Sara yawɨꞌdaaꞌnyɨna yakeꞌ gamɨnyawɨnna wɨlaabɨna yaka wɨdɨna “Naangeigɨ, nɨmɨnyɨ nyɨnyaabulaangeꞌ nɨmɨnyɨ gaveꞌnyɨ nyagalyaꞌmakuwakeꞌnyɨra. Sareꞌnyɨ tɨka wapaaya yovɨrawakɨvanɨgena. Ai, gɨmɨ dazavɨneꞌna sɨmunya myawɨrijɨvanɨgɨna? Nɨmɨnyɨna ‘Wɨgaimwagana!’ daꞌgɨzɨ sara duthana!” ");
INSERT INTO byr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kɨrɨꞌ Naangei sahɨrɨvɨ jaꞌnawɨdɨna “Maathaꞌ, Maathaꞌ, gɨmɨ sɨmugwalaalya yawɨꞌdɨ gɨmɨre sɨmunyaꞌ yawɨta kwalaalyangɨna yɨwaꞌnadɨkaata yɨvanɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kɨrɨꞌ gave pɨrɨꞌnanyaꞌ wɨmudaasɨvanɨꞌ. Sareꞌna dareꞌnanyɨ. Maarɨyaaꞌ tewaanya dazaꞌ maaꞌmanɨkeꞌnanyɨra. Sahɨrɨvɨ saꞌ tewaanya dazaꞌ mamarasɨꞌnɨwɨna!” ");
INSERT INTO byr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pɨgaaꞌ Jizaazai gave pimagɨnna bulamwalaawaka Gotɨyarɨ wɨdɨna. Dɨvi sai mena wɨdakegaaꞌ gamɨre mɨdɨde pwai gamɨnyɨ wɨdɨna “Naangeigɨ, Jonɨ gamɨre mɨdɨdɨvɨsaraavɨ wɨjɨwaakakabaaibɨꞌ Gotɨyarɨ wɨdaathevwina dɨnejɨwaakya!” ");
INSERT INTO byr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Sara wɨdɨna kyaꞌ sai saraavɨ wɨdɨna “Sarɨmɨ Gotɨyarɨna ‘Wɨdaana!’ yawɨrapɨjɨyagaaꞌ yɨ dara duzideihɨlyɨ, ‘Nɨmwai, gɨmɨnne yayaꞌ gɨrɨꞌmaayaꞌ yɨmaꞌnana! Gɨmɨre maremwaaidɨnyaꞌ yuneba nayaa yɨmaꞌnana! ");
INSERT INTO byr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gazagaasagaaꞌ nemɨnne mwanyagaaꞌne nyɨnyaꞌne dɨnejaama! ");
INSERT INTO byr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nemɨre kayaaꞌnanya dɨnemarasɨka! Sareꞌ darevɨnyɨra. Kayaaꞌna neyade gazaizare Wɨrɨvɨkɨta marasɨꞌdaanyabaaibɨsasɨ. Yaamɨjɨ yɨjɨwaala yaꞌne saburɨ Maneyɨbwarɨdaakunnera nemɨnyɨ!’ Gotɨyarɨ sara duzideihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nabaai sai wɨdɨna “Sarɨmɨjɨya pwai gyaꞌmwe pwai kɨnɨnnakei mwaalajai sawɨta naanga kalawawegaaꞌ kaanna wɨna yojɨ gyaꞌmwe dazarɨ wɨdaawɨna ‘Nyaꞌmweigɨ, bɨretɨya dawaai data pɨnɨ dɨnyɨjaama! ");
INSERT INTO byr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nɨmɨnyɨ nyaꞌmwe pwai kaanya yamarivanɨkei nɨmɨnyawɨnna kabiꞌmaꞌmwaꞌ sahwarɨ wɨjaayaꞌne wapaaya kuneinyɨ yenanyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nabaai aꞌmwe anga dazavɨ kusawɨdaaꞌnyai jaꞌnawɨdɨna ‘Taanga manyakɨnnera! Kaanyaꞌ mena tihɨꞌnɨwakesɨra. Sarevɨ nabaai nɨmɨre kaimɨraayamɨlɨka kuvɨnɨmaangeinyɨjɨ yɨꞌbɨnyavɨ mena yeꞌmwannaꞌmwaasainyɨ. Nɨmɨ madɨkaayɨ yaꞌmujɨ magɨmaari yɨwɨneinyɨra,’ wɨdaꞌ. Sarevɨ gathaꞌdarevaka! ");
INSERT INTO byr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Sarɨmɨnyɨ yɨhɨthɨvanɨge. Angevɨ gyakwai aꞌmwe sarɨna gyaꞌmwe kwai mwaalajai kɨrɨꞌ mujaayɨ. Sareꞌ kɨrɨꞌ aꞌmwe sai jakeꞌna jakeꞌna kudozɨ sahwai yuna maaꞌna wida sarevɨdaaꞌnyɨ sai gamɨnyɨ wɨmudaasa yuya sa wɨmaarina yannelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nabaai sarɨmɨnyɨ yɨhɨthɨvanɨge. Sarɨmɨ Gotɨyarɨ kuna nayaa kidaanganapɨri yɨhɨzaavadelyɨra. Yɨdaanganyaꞌ kuna nayaa bɨrapɨri yɨ dɨvɨramaaryideihɨlyɨ. Kaanyavɨ mala kuna karamapɨri Gotɨyai kaanyaꞌ yɨhɨvasamaraabathelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sareꞌ dareꞌnesɨ. Aꞌmwe gazaizai Gotɨyarɨ maaryaꞌnei sahwarɨ yɨdaangada maaꞌdelyɨra. Bɨrɨbɨrya yadei bɨramaaꞌdelyɨ. Nabaai kaanyavɨ mala tamaabaderɨ Gotɨyai kaanyaꞌ wɨbasamaraabathelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sarɨmɨjɨya ganɨmaanga pwarɨ gawaalɨvaangei kidaanganojɨ ‘Nɨmwai, jawɨnya pɨrɨꞌ nyɨmaryaama!’ naawɨnaanyarɨ wɨmaaryadei daaka! ");
INSERT INTO byr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","‘Yukwaraka pɨrɨꞌ nyɨmaryaama!’ kidaanganojɨ marayɨnɨgaawalyaꞌ wɨmaaryadei daaka! Arɨkewɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sarevɨdaaꞌnyɨ aꞌmwe kayaaꞌnanyaihi mwaaidɨvɨꞌ sarɨmɨre kaimɨraayamɨlɨkaavɨ tɨka nyaꞌne nawɨꞌnyanna wɨjaavɨpɨjaihi sasare sahɨbwi Gotɨyai wavɨlaꞌdei daaka! Sahwai Nɨmwai Sɨgunyavɨdaaꞌnyɨ aꞌmwe gamɨnyɨ yɨdangadaapiyaraavɨna Kurya Tewaanyarɨ wɨjaavadere.” Sara wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yɨmaka pwai aꞌmwe pwarɨ wɨlamwaaina yada aꞌmwe sare maangeꞌ mena bɨpainɨkelyɨ. Jizaazai yɨmaka sahwarɨ wɨdaasɨna kyaꞌ sare sarɨ yɨmakei mena wɨna kyaꞌ aꞌmwe maanga bɨpainɨka dazai yagaala wɨdɨna kyaꞌ kwala bwaꞌnaanya atɨka maruꞌnaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Atɨka maruꞌnaꞌna kyeꞌ kɨrɨꞌ aꞌmwe pwara dɨnyɨna “Sahwai yɨmakeraavɨ marasɨꞌmanɨkeꞌna Biyelɨzɨvulɨmɨre dɨragɨnyasɨ marasɨꞌmanɨkelyɨ. Yɨmakeraavɨ maremwaaidere dɨragɨnyasɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nabaai aꞌmwe pwara “Yaamɨjɨ yɨjɨwalaana!” yawɨreva sarera wɨdɨna “ ‘Gotɨyai gamɨjɨ dahamwaalɨka?’ yawɨtaꞌneina dara gɨthaana! Sɨgunyavɨdaaꞌnya dɨragɨnya pɨrɨꞌ kyaꞌgɨzɨ tɨnna wanganaana!” ");
INSERT INTO byr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sara yawɨꞌna yadaapi kɨrɨꞌ kumɨre sɨmunyangɨ yawɨranganna yaka wɨdɨna “Maremwaaide gave pɨbadaaꞌnya pwara pɨvakaai tangɨvalapɨjɨ mala bwaꞌnɨpɨjaꞌ maremwaaide dazaꞌ kayaaka yɨnyɨna yadesɨ. Nabaai gave kɨnɨdaka tangɨvainapɨri mala bwaꞌnɨpɨjaꞌ dazanɨdaka kayaaka yɨmaꞌnyɨna yɨpɨꞌdenɨdakera. ");
INSERT INTO byr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nabaai Saataanɨmɨre yɨsavaaꞌ pɨvakaai tangɨvainapɨri mala bwaꞌnɨpɨjaꞌ gamɨre maremwaaideꞌ gara warannevaka! Sarɨmɨ kanyɨdɨwaakɨra ‘Biyelɨzɨvulɨmɨre dɨragɨnyasɨ wɨdaasɨvanɨkelyɨreva.’ ");
INSERT INTO byr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nabaai Biyelɨzɨvulɨmɨre dɨragɨnyasɨ yɨmakeraavɨ wɨdaasɨwɨjɨ kwajɨ yɨ sarɨmɨrera dɨragɨnya aaihwaresɨ wɨdaasadɨvɨtavaka? Sarevɨ kumɨ sara sarɨmɨre kwaasɨ yagaala dazangɨ yɨhyawɨbwapɨꞌdere. ");
INSERT INTO byr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kɨrɨꞌ Gotɨyare aꞌjawɨnyai nɨmɨnyɨ nyɨgaimwadaaꞌnyɨ nɨmɨ yɨmakeraavɨ wɨdaasɨwɨjaꞌ yɨ sarɨmɨnyawɨnna Gotɨyai maremwaaideꞌ mena bɨvanɨꞌ. ");
INSERT INTO byr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Aꞌmwe dɨragɨnaanga kwai mwaryagɨnyɨsɨ mwasaagalyajɨ yune lɨmwadei damei gannya angwaasaba nayaa dɨragɨnna maredaaꞌna yadɨꞌnyɨ gamɨre gɨlyɨvɨta yuya sa nayaa dathɨvaina waradengɨ. ");
INSERT INTO byr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kɨrɨꞌ dɨragɨnaanga pwai sɨnnawɨnyare dɨragɨnyaꞌ wavɨlaꞌdei bɨna yaka dathɨvaina yaka gamɨre mwaryagɨnya mwasaagala kɨlɨka gamɨnyɨ yɨvaimwade sa yuya tamipalamaaꞌna. Sara tamipalamaaꞌna yaka gamɨre gɨlyɨvɨta yuya sa yanga mudɨna. ");
INSERT INTO byr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Pwai yaasɨwaꞌna ‘Yɨmakeraavɨ maremwaaidere dɨragɨnyasɨnyɨra,’ yawɨꞌde sai nɨmɨnyɨnei mwaaidei mɨꞌ. Yɨ sahwai nɨmɨnyɨna yɨkamaangelyɨ. Pwai nɨmɨjɨ sipɨzipɨyaraavɨ myeꞌmwannamwaaihyɨ yada sahwai yaasɨwaꞌna tamayɨwɨnasamaryadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yɨmakei aꞌmwe pwarɨ mena yagalyaꞌmavaka nawɨꞌnya pɨba bɨramaaryaꞌnei aꞌgaaye mwaalyaꞌnei yaalɨkɨryabanna loꞌmavamarina. Nabaai sasare pɨba mabɨramaari yaka yɨ dara dɨna ‘Anga sɨnnawnnaɨ nɨmɨ mwaale dazavɨdaaꞌnyainyɨ ayɨna kaanya wɨdeꞌnanyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Sare sai kaanna wɨna yaka anga dazavɨ tɨnna wanganaawɨna, dara yakeꞌ ‘Mena padaꞌgalabwakɨraka mena nayaa warɨkeꞌ daaka! Kuneꞌ daaka!’ ");
INSERT INTO byr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sara dozɨ kaanna wɨna yojɨ yɨmaka gamɨre kayaaꞌnanyaꞌ wavɨlaveta ata purɨdaaꞌnyɨ pwaraainanyaraavɨ kayaaka yɨgalakyaꞌneraavɨ wɨjɨmaꞌnaawɨna. Sara yaka yuyara bɨna yeva sare sara kusawɨ wɨlɨna yeva wɨlamwaaina. Sɨnnawɨ aꞌmwe dazai kayaaꞌna mwaalakelyɨ. Kɨrɨꞌ aayagaaꞌ yuna kayaaꞌnanaangei mwaalɨna. (Sasarebaaibɨꞌ aꞌmwere sɨmunyaꞌ kuneꞌ waꞌdɨꞌnyɨ Gotɨyai mulamwaalyadɨꞌnyɨ sahwai kayaaꞌnanaangei mwaalɨna yadelyɨ.)” ");
INSERT INTO byr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yagaala daza kuna wɨdɨna yadaaꞌnyɨ kwala bwaꞌnaanyavɨ aꞌmwe pɨrɨꞌ jaka wɨdanganna “Aꞌmwe sɨnnawɨ gɨmɨnyɨ mudanga gyaka aamunya gɨzaavaka saꞌ yɨ sahɨrɨꞌ yɨlaaya yada tewaanaanga yɨnɨkesɨra.” ");
INSERT INTO byr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jaka wɨdanganna kyaꞌ kɨrɨꞌ sai wɨdɨna “Aawa, aꞌmwera Gotɨyare yagaalyaꞌ kadɨka wɨꞌnadɨvɨꞌ mɨdɨbɨzara sahwara yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkerera.” ");
INSERT INTO byr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kwala bwaꞌnaanya kuna biꞌbwaꞌnemwaaidapi sai dara wɨdɨna “Dathahaasara aꞌmwe kayaaꞌnanyarera. Sahwara ‘Dɨragɨnya wɨjɨwaainya pɨrɨvɨ tɨnna wanganaana!’ yawɨreva jaka wɨdɨna. Sara kanyɨdɨwaaꞌ kɨrɨꞌ sahwaraavɨ dɨragɨnya wɨjɨwaainya pɨrɨꞌ wɨjɨwaainɨdeinyɨ mɨka. Aawa. Ne Jonaamɨre dɨragɨnya wɨjɨwaainya yune dazahɨrɨꞌnanyawɨkuꞌ wɨjɨwaainɨdeinyɨra. ");
INSERT INTO byr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sareꞌ dareꞌnesɨ. Sɨnnawɨ kɨgaaꞌ Jonaa Ninɨva mwaalyaraavɨna Gotɨyare wɨjɨwaainyaꞌneꞌ yɨmaꞌnyaakabaaibɨꞌ yɨ Aꞌmweraavɨne Kaimɨraayai dathahaasaraavɨnei Gotɨyare wɨjɨwaainyaꞌneꞌ yɨmaꞌnadelyɨ. (Sareꞌna sarɨmɨ yawɨꞌna ‘O, Gotɨyai Jizaazarɨ maryasaabakelyɨ.’) ");
INSERT INTO byr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dɨvi Gotɨyai aꞌmweraavɨ yawɨbwaradehaaꞌ saawɨtɨyɨmagɨdaaꞌnyɨ kwinɨyaꞌ maremwalyaakevɨ aꞌmwe dathahaasa daraavɨjɨ yɨdɨkaaꞌna kyojɨ kwinɨya sahɨrɨꞌ kumɨre kayaaꞌna yadɨvɨsabwine yagaainakeraavɨna jalɨkurakaabathesɨ. Kwinɨya dazaꞌ Kwaakevakɨ tɨyawɨnnanyawɨ Solomonɨmɨre sɨdusabwi kadɨka wɨꞌnyaꞌneꞌ bɨna. Yɨ sahɨrɨꞌ bɨna kyaaꞌ, yɨthaanyi, dahaaꞌ Solomonɨmɨ wavɨlaꞌdei dava mwaalɨka dalaaka! Mwaalɨka kɨrɨꞌ sarɨmɨ manyuꞌnyɨvanɨgasaꞌneꞌna kwinɨya saꞌ nayaa wɨꞌnyaakeꞌ sarɨmɨre kayaaꞌnanyabwi jalɨkurakaabathesɨ. ");
INSERT INTO byr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nabaai maryawɨbwaradehaaꞌ aꞌmwe Ninɨva mwaalyaraavɨ dathahaasaraavɨjɨ yɨdɨkaaꞌna kyojɨ dathahaasaraavɨre kayaaꞌnanyabwina jalɨkurakaabɨpɨꞌderera. Ninɨva mwaalyara Ne Jonaa wɨjɨwakadaaꞌnyangɨ kadɨka wɨꞌnadɨvɨꞌ sɨmunya mudɨkeꞌ yawɨramaaꞌna. Sahwara sara yɨna kyaaꞌ, yɨthaanyi, dahaaꞌ Jonaamɨ wavɨlaꞌdei sai dava mwaalɨka dalaaka! Mwaalɨka kɨrɨꞌ muꞌnyɨvanɨgasaꞌneꞌna Ninɨva mwaalyara nayaa wɨꞌnyaasara kumɨre kayaaꞌnanyabwi jalɨkurakaabɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Aꞌmwe aane pwai kwai laamɨvananyaꞌ yewɨtaꞌda lɨka yulyaryaꞌneba wɨlakada mɨꞌ. Nabaai maaꞌgula pɨrɨvɨ amwihidaaꞌnyɨ wɨlakada mɨꞌ. Aawa. Yɨꞌbɨnyavɨ munyaba yɨlakadesɨ. Sarevɨ aꞌmwera kusawɨnna bwidɨvɨꞌ ‘Dɨꞌbaaka wanyɨwanya dazavɨ tɨnna wangabɨka!’ dada saba yɨlakadesɨ. ");
INSERT INTO byr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Gɨmɨre tɨnnyai kɨlaakejɨkɨna laamɨvananyalyɨ. Tɨnnyai baakeꞌ maaꞌdelyɨ. Tewaanyabwi baakeꞌbɨsabwi sɨmunya nayaa yawɨꞌdɨ yɨ gɨmɨre yuya kɨlaakejɨꞌ baaka padezɨkɨ. Kɨrɨꞌ kayaaꞌnanyabwi jɨhɨnyaꞌbɨsabwi sɨmunya yawɨꞌdɨ yɨ gɨmɨre kɨlaaka yuyajɨꞌ yuna jɨhɨnya yɨmaꞌnadezɨkɨ. ");
INSERT INTO byr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Sarevɨdaaꞌnyɨ nayaa dɨmaremwaainyɨla! Baaka gɨmɨnyɨ wɨlagwarɨka dazaꞌ jɨhɨnya nyɨmaꞌnadɨka! Nɨmɨnyɨna nayaa jawɨka! ");
INSERT INTO byr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sarevɨdaaꞌnyɨ gɨmɨre kɨlaaka yuyajɨꞌ baaka kɨnɨnnakejɨꞌ yajazɨꞌ pimagɨnya pɨjɨꞌ jɨhɨnya pɨjɨꞌ myajazɨꞌ yɨ sarevɨ laamɨvananyavɨre baakeꞌ gɨlɨvamwadadevaaibɨꞌ gɨmɨre kɨlaakejɨꞌ yunebanna baaka padezɨkɨ.” ");
INSERT INTO byr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jizaazai yagaala mena jɨꞌmwannaka yadɨꞌnyɨ Perɨzɨya pwai gamɨre angevɨ wapaaya tɨka nyaꞌna sahwarɨ jaka jɨvwarɨjɨmaaꞌnyɨna. Sarei sai angevɨna wɨlaawɨna yaka wapaaya nyaꞌne yɨꞌbɨnyavɨ mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sare yaka sɨnnawɨ ata aalya minyai wapaaya nadaaꞌnyɨ Perɨzɨya sai tɨnna wanganna yaka aalya minyaꞌna nɨꞌnɨka yɨna. ");
INSERT INTO byr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nɨꞌnɨka yɨna kyaꞌ Naangei wɨdɨna “Sarɨmɨ Perɨzɨyaihi kaapɨvananya paletɨyangɨ mwasɨmagɨnna aalya yadɨvɨkɨ. Kɨrɨꞌ sarɨmɨnyɨ kusawɨ kukebulyɨ kayaaꞌnanya gɨrɨkitaꞌnanyabulyɨ yuna wɨlayɨhwarɨkeihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Aꞌmwe sɨduꞌmaayaihi! Gotɨyai yune mwasawɨnya yavɨkaryaka nabaai kusawɨnya yavɨkaryaakei daaka! (Sarɨmɨre sɨmunyavɨjɨ padaꞌgalamaremwaaina jɨla!) ");
INSERT INTO byr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sare kɨrɨꞌ sarɨmɨre sɨmunyavɨ aꞌmwe gɨlyɨvɨsanna wɨgainɨvanɨkeraavɨ yanga nayaa duzaayɨla! Kwaasɨyaꞌna mujaavɨpɨna! Nabaai sasara tewaanya yɨpɨjaꞌ aꞌmwera dara yawɨpɨꞌdeꞌ ‘O, aꞌmwe sasarei gamɨre sɨmunyaꞌ yuneꞌna tewaanya warɨkeꞌ daaka! Yuya gɨrɨkitaꞌnanya maaya daaka!’ ");
INSERT INTO byr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Weꞌ! Perɨzɨyaihi mala nayaa jɨwannyɨla! Sarɨmɨ yɨmaasajɨ jɨsajɨ sɨgya yuya dala nabinyajɨ mɨlɨkɨvaidɨvɨꞌ atɨraai yɨmaꞌnadaaꞌnyɨ pimagɨnyavaaꞌ Gotɨyarɨ wɨjaavadɨvɨsaihɨlyɨ. Sara nayaa yadɨvɨꞌ kɨrɨꞌ yɨdaꞌmaraangeburɨjɨ Gotɨyarɨna tewaanya wɨvuꞌnyaburɨjɨ wavɨlaꞌdɨvɨsaihɨlyɨ. Sasare sabwi yadɨvɨꞌ pɨbwi sɨgyajɨyabulyɨ myagalyaꞌmayɨ yɨpɨjaꞌ saꞌ tewaanyasɨ. (Sareꞌna Gotɨyai daanga wɨjaayaꞌneihi mala jɨwannyɨla!) ");
INSERT INTO byr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Perɨzɨyaihi, weꞌ! Sarɨmɨ lotuangengɨ aꞌmweraavɨ sɨnnyɨkaavɨ, tewaanyaba walamwaalyaꞌna tewaanya yɨhɨvuꞌnadeihɨlyɨ. Sarevɨ nabaai aꞌmwera kwala yɨꞌbwaꞌnadɨvɨsaba ‘Aꞌmwe naangeigɨ!’ wɨjaꞌna nawɨꞌnya yɨhɨvuꞌnadeihɨlyɨ. Sareꞌna mala nayaa jɨwannyɨla! ");
INSERT INTO byr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Sarɨmɨ weꞌ! Gɨlekaviꞌnɨnnya kwaakevɨ kusawɨ lɨka yulyarɨkebɨsaihɨlyɨ. Sara yulyaꞌdɨꞌnyɨ aꞌmwera tɨnna mwanganyadɨvɨꞌ gɨrɨkitaꞌnanyaꞌna myawɨryadɨvɨꞌ sahɨnɨngɨ aꞌbadaaꞌnyɨ yɨlayamaryadɨvɨsare. Sarɨmɨre gɨrɨkitaꞌnanya lɨka yulyaꞌdɨvɨsaꞌna mala nayaa jɨwannyɨla!” ");
INSERT INTO byr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aꞌmwe kɨwɨnya dɨnɨkengɨ sɨduꞌnaka pwai gamɨre yagaalyangɨ jaꞌnawɨdɨna “Wɨjɨwaakadɨnyaigɨ, sara wɨdadɨ gɨmɨre yagaala taanga nemɨ kwainaavɨjɨ dɨragɨnna nedangamanɨgɨna!” ");
INSERT INTO byr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Wɨdɨna kyaꞌ sai wɨdɨna “Kɨwɨnya dɨnɨkengɨ yawɨꞌdɨvɨsaihi, weꞌ! Aꞌmweraavɨ taanginya yɨlakadɨvɨsaihɨlyɨ. Naanga dakadɨvɨsaihɨlyɨ. Sara wiadaapi yagɨyagɨ makidɨvɨsarera. Kɨrɨꞌ sarɨmɨ saihi taanginya maakata dazangɨ yaꞌneihi ata pwi wakya yadɨvɨtaihi mɨꞌ. Sareꞌna mala nayaa jɨwannyɨla! ");
INSERT INTO byr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Sarɨmɨnyɨ weꞌ! Sarɨmɨre Ne sɨnnawɨnyara pɨropetɨyaraavɨ tamakesarera. Sarevɨ sahwaraavɨre gɨleange madɨvɨsaihɨlyɨra. Sareꞌna mala nayaa jɨwannyɨla! ");
INSERT INTO byr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sasare dazabwi aꞌmweraavɨ dareꞌbɨꞌ yɨbwarɨdaakwadɨvɨsaihɨlyɨ ‘Ne sɨnnawɨnyara sasara yaata sabwina nawɨꞌnyasɨ.’ Yɨ, pɨropetɨyaraavɨ tamakadaapɨjɨ sarɨmɨ gɨleange madɨvɨsaꞌna ‘Ya, tewaanyabulyɨ,’ jalɨkurakɨdɨvɨsaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Sarevɨ sarɨmɨnyɨna Gotɨyare sɨduta naangesɨyai sai mena dara dɨnɨꞌ ‘Pɨropetɨyaraavɨjɨ wɨdaasadɨnyaraavɨjɨ maryaasɨwɨjaraavɨ pwaraavɨ tamayɨwɨnasamaryadɨvɨꞌ pwaraavɨ tamakɨpɨꞌderera.’ ");
INSERT INTO byr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sarevɨdaaꞌnyɨ aꞌmwe dathahaasaihi sɨnnawɨ kɨgaakuna pɨropetɨya yuyaraavɨ tamakyaasaihɨre mɨnya maaryaꞌne sangɨjɨ dahaaꞌ kɨgaasɨ kuna yɨvanɨgasaihɨre mɨnya maaryaꞌne sangɨjɨ dazahɨrɨvɨne taanginyaꞌ dɨmaaryideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Yɨ sɨnnawɨ Aivelɨmɨre taweꞌ bwalaawɨna yaakelyɨ sareibɨsara dɨvidaaꞌnyɨ tɨnnyabanyaraavɨre tawe bwalaawɨna yaakerajɨ aayagaaꞌ Sekaraayare taweꞌ bwalaawɨna yakelyɨ saraavɨne tawevɨnanyɨra. Aayai Sekaraayarɨ kwaraanyabajɨ (taangejɨ marewɨjaꞌnebajɨ) anga nawɨꞌnyavɨjɨ tɨnnyaba tamakesalyɨ. Yo, sarɨmɨnyɨ yɨhɨthɨvanɨge. Yuya dazavɨneꞌna dathahaasaihɨrɨ mɨnya maaradeꞌnanyɨ tawe saꞌ. ");
INSERT INTO byr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kɨwɨnya dɨnɨkengɨ sɨduꞌnakeihi, weꞌ! Sarɨmɨ Gotɨyarɨne yagaalyavɨ sɨduta yawɨramaaryaꞌne sɨmunyaꞌ kiyaꞌbɨꞌ kuka marasɨꞌmwaasasɨ. Sarɨmɨ saihi sɨmunya dazavɨ kaanyavɨ mabaasadɨvɨꞌ kusawɨ mulyɨvanɨgaꞌ. Aꞌmwe pwara ‘Kusawɨ wɨlaana!’ dadɨvɨꞌ yadaapi sahwaraavɨ kaanyaꞌ tihɨꞌmanɨgasaihɨlyɨ. Sareꞌna mala nayaa jɨwannyɨla!” ");
INSERT INTO byr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Anga dazavɨdaaꞌnyɨ walyuna yadaaꞌnyɨ Kɨwɨjarajɨ Perɨzɨyarajɨ saraavɨ sɨnna tɨka naanga wɨdaꞌdaaꞌnyɨ gamɨnyɨ kwaasɨ yagaala jɨdayaꞌneꞌna yagɨyagɨ bɨrɨna. “Gamɨnyɨ yaamɨjɨ walapapalakaana!” yawɨꞌdɨvɨꞌ yaamɨjɨ yɨna yɨna. ");
INSERT INTO byr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Sahwarɨ kotɨya yɨnɨga maryaꞌne saꞌna “Gamɨre maangikɨdaaꞌnyɨ yagaala pɨrɨꞌ kinori bɨramaraana!” yawɨꞌdɨvɨꞌ sahwarɨ nayaa baihanaramarina. ");
INSERT INTO byr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sarevɨ aꞌmwe kwala bwaꞌnaanyavɨne taawɨzanɨya naangera yɨꞌbwaꞌnyɨna yeva pwaraavɨre sɨvɨlyangɨ dɨhɨbainadɨvɨꞌ yuneba mɨjahɨbalakɨna. Yuneba mɨjahɨbalakɨna yadapi sɨnnawɨ gamɨre mɨdɨdɨvɨsaraavɨ gaai wɨdɨna “Perɨzɨyaraavɨre yɨzɨyavɨna nayaa javadaꞌgalayawɨrila! Kumɨre kwaasɨya sabwina yɨhɨthɨvanɨge. (Bɨretɨya yavɨkaryadɨvɨꞌ yɨzɨyaꞌ yuneba pamidakɨna yadevaaibɨꞌ Perɨzɨyaraavɨre kwaasɨya sabwina sarɨmɨnyɨ yuneba nulayɨhwaradɨka!) ");
INSERT INTO byr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yuya sa bwakakɨna yɨnɨke yɨ kuꞌmaaya yamaꞌmawakɨna yadengɨ. Nabaai yuya kukuꞌnyɨ yagaalya yawɨrangabɨꞌdengɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sarevɨdaaꞌnyɨ sarɨmɨ yagaala yuya jɨhɨnyavɨ dadɨvɨsa yɨrɨkevɨ aꞌmwera kadɨka wɨꞌnɨpɨꞌdere. Nabaai yagaala yuya sarɨmɨ angengɨ kusawɨ kadɨkengɨ yuna kavena aꞌmabyahaala dadɨvɨsa, yɨ sare sa angevɨ munyaba yɨladaavapɨjɨ wɨjɨwaakɨpɨꞌdengɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nɨnnya nyaꞌmweihi, sarɨmɨnyɨ dara yɨhɨthɨvanɨge. Aꞌmwera sarɨmɨre kɨlaakejɨꞌ yuna baimwagakya yaꞌna lɨka mipɨnera! Sareꞌna nabaai dɨvi ayahi pɨnɨjɨ yɨpɨꞌdera mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Sarɨmɨ lɨka jiderɨna yɨhibwarɨdaakwɨdeinyɨ. Sai Gotɨyai tamakojɨ dɨvi dɨragɨnyaꞌ kɨnɨnnakei aꞌmweraavɨ Dɨkevɨ kewɨnɨ maralɨvaramanne dazarɨna lɨka jideihɨlyɨ. Yo, sarɨmɨnyɨ yɨhɨthɨvanɨge. Dazahwarɨna lɨka nayaa jideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Binna atɨlyara nɨgwia maalɨka pukaalyɨna mubadɨvɨsɨkaai daaka! Sareꞌna kɨrɨꞌ Gotɨyai yuta sasare gave saina navɨka yadei mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aawa. Sarevɨ sahwai sarɨmɨre mɨnyagɨnyangɨya mɨjata yuyangɨ ata mena gimanɨkengɨ. Sareꞌna lɨka mipɨnera! Binna kwalaalyaraavɨne nɨgwiangɨ sarɨmɨ mena wavɨlaꞌnɨkeihɨlyɨra. ");
INSERT INTO byr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sarɨmɨnyɨ yɨhɨthɨvanɨge. Aꞌmwe gazaizai nɨmɨnyɨna aꞌmweraayaba jalɨkurakajai ‘Sahwarɨ mɨdɨdɨnyainyɨ,’ yɨ Aꞌmweraavɨne Kaimɨraayai sai kwai dazarɨna Gotɨyare ejelɨyaraayaba jalɨkurakadelyɨ ‘Sahwai nɨmɨrelyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kɨrɨꞌ pwai nɨmɨnyɨna aꞌmweraayaba jalɨkurakajai ‘Mamɨdɨnyadɨnyainyɨ,’ yɨ dazarɨna Gotɨyare ejelɨyaraayaba ‘Nɨmɨrei mɨka,’ jalɨkurakadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Gazaizai Aꞌmweraavɨne Kaimɨraayarɨna bɨraizɨka wɨdazai, yɨ Gotɨyarɨ kudozɨ gamɨre kayaaꞌnanya saꞌ marasɨꞌnadelyɨ. Kɨrɨꞌ Kurya Tewaanyarɨna yagaaibɨraizɨka dazai, yɨ Gotɨyai gamɨre kayaaꞌnanya saꞌ marasɨꞌnadei mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nabaai kotɨyaꞌna lotuangengɨ maremwaaidɨvɨsaraayabajɨ gaꞌmaanɨyaraayabajɨ yawɨbwaꞌdɨvɨsaraayabajɨ yɨhɨmakwodɨvɨꞌ sarevɨ yawɨta kwalaalya mi yadɨvɨꞌ sɨmunya dara myawɨpɨnera! ‘Nemɨ yagaalyaꞌ gara wɨrɨvɨkɨraadeinaavaka? Be yagaala wɨdaatheinaavaka?’ ");
INSERT INTO byr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sareꞌ dareꞌnanyɨ. Dazahɨrɨsavɨ dazahaasagaaꞌ Kurya Tewaanyai sarɨmɨre yagaala wɨdɨpɨneꞌ kihɨzaavojɨ duzideihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kwala bwaꞌnaanyavɨ aꞌmwe pwai wɨdɨna “Wɨjɨwaakadɨnyaigɨ nehɨrɨnɨmaangei kabaimwaꞌdɨꞌ nyɨdaakaangei gɨlyɨvɨta yuya maaꞌmwaꞌdɨkelyɨ. Sahwarɨ duthatheꞌna gɨthɨwana. Gɨlyɨvɨsa tɨnnyaba jaapalojɨ pimagɨnyavaaꞌ nyɨjaavadeꞌna.” ");
INSERT INTO byr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Wɨdɨna kyaꞌ sai wɨdɨna “Gathaꞌdarevaka! Kɨrɨmɨnyɨ yawɨbwataꞌneinyɨ aaihwai nyɨdahɨlakɨwakainyaka! Gɨlyɨvɨsa jaapala yɨhɨthaayaꞌneinyɨ daaka!” ");
INSERT INTO byr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sara wɨdɨna yaka kumɨnyɨ wɨdɨna “Sarɨmɨ mala jɨwannyɨla! Nayaa javarannemwaalyɨla! Gɨlyɨvɨsangɨna tɨganaarya nyɨpɨdɨka! Aꞌmwe gɨlyɨvɨta naanga kwalaalyajɨyai, sai gamɨre gɨlyɨvɨta dazangɨna gaalyabwi kɨnɨnnakei daaka!” ");
INSERT INTO byr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Wɨdɨna yaka keꞌbaꞌnanya pɨrɨꞌ wɨdɨna “Aꞌmwe pwai gɨlyɨvɨkɨravɨnakei gamɨre wawɨnyajɨꞌ tɨka munne kwalaalya maarakejɨkɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sarevɨneꞌna aꞌmwe dazai gannya sɨmunyavɨ dara yawɨrakelyɨ ‘Aka, nɨmɨ dainyɨ gara yɨwɨneke! Nɨmɨre tɨka munne yuya yɨnɨga mariꞌbwarakɨde ange kuneinyɨre!’ ");
INSERT INTO byr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dɨna yaka sai dɨna ‘Yɨ, nɨmɨ dara yɨdesɨ. Nɨmɨre anga yuya tɨka munne marikwakadɨnya sa woꞌdaalaꞌmujɨ yune naangenna naangenna madɨdeinyɨra. Sara madaꞌmujɨ nɨmɨre witɨya yuyajɨ gɨlyɨvɨta yuyajɨ anga dazangɨ mariꞌbwarakɨdeinyɨra. ");
INSERT INTO byr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sara yaꞌmujɨ nabaai nɨmɨre kuryarɨ wɨdɨna “Kuryaigɨ, kwarame kwalaalyangɨne tɨka munne yɨnɨga waradengɨra. Sarevɨ dahaaꞌ kave aꞌgaaye dɨmwaaideꞌnanyɨ. Tɨka wapaajɨ nadɨ waainɨyajɨ nadɨ yɨlaaya yadɨ dɨmwaaideꞌnanyɨ.” ’ ");
INSERT INTO byr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Sara dɨna kyaꞌ kɨrɨꞌ Gotɨyai sahwarɨ wɨdɨna ‘Aꞌmwe sɨmumaayaigɨ! Yuna dahaasagaaꞌ sawɨta davɨ dɨvaideigɨnyɨ. Gɨmɨre kuryarɨ maarɨdelyɨ. Sareꞌna gɨlyɨvɨta yuya yovɨgaipwakɨvanɨgɨnya yɨ sa aaihwai maaradengaka! Gɨmɨ aawa!’ ");
INSERT INTO byr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sasarebaaibɨꞌ Gotɨyarɨna nawɨꞌnya naangebura maayai, Gotɨyarɨna gɨlyɨvɨkɨravɨnakei mamwaalyɨ yajai gɨlyɨvɨta gannyanne kwalaalya naanga mariꞌbwarakadei gamɨre kuryai waryaanyai yɨmaꞌnadelyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Gamɨre mɨdɨdɨvɨsaraavɨ wɨdɨna “Sarevɨ sarɨmɨnyɨ yɨhɨthɨvanɨge. Sarɨmɨre mwaalyabwina sɨmunya kwalaalya myawɨpɨnera! Sara yawɨꞌdɨvɨꞌ dara nadɨpɨka! ‘Nemɨ tɨka munne benɨ naadeinaavaka?’ Nabaai sarɨnnya kɨlaakejɨkaavɨna sɨmunya kwalaalya myawɨpɨnera! Sara yawɨꞌdɨvɨꞌ dara nadɨpɨdɨka! ‘Nemɨre kɨlaakejɨkɨ be yaawiajɨ baazɨꞌmaꞌnaadeinaavaka?’ ");
INSERT INTO byr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sareꞌ dareꞌnanyɨ. Gaalyabwi sabwi naangebulyɨ. Tɨka nyaꞌnennanya sa maalɨkengɨ. Nabaai kɨlaaka sajɨꞌ naangejɨkɨra. Baazɨꞌmaꞌnya sa maalɨkengɨra. ");
INSERT INTO byr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yusaraavɨna jawɨranganyɨla! Witɨya wia burɨdɨvɨtara mɨꞌ. Tɨka munne gimujayɨꞌbwarakaabadɨvɨtara mɨꞌ. Kumɨre tɨka munne angejɨ anga yuhwakamaaryaꞌnejɨ kunere. Kɨrɨꞌ Gotɨyai tɨka wapaaya wɨjaavadere. Sareꞌna sarɨmɨ aꞌmweihi yusaraavɨ yuna naanga wavɨlaꞌdɨvɨsaihi midaaka! ");
INSERT INTO byr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sarɨmɨjɨya pwai sɨmunya kwalaalya yawɨrajai sangirɨꞌ kɨbawamaalɨꞌna pɨrɨsɨ gamɨre mwaalyagaaꞌna yɨbwaꞌmwagannei daaka! ");
INSERT INTO byr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sarevɨdaaꞌnyɨ sarɨmɨ sare maalɨka samɨlɨꞌ mi yɨpɨneihi mwaaibɨzaꞌ yɨ yuya pɨnɨnna sɨmunya kwalaalya beꞌna yawɨꞌmanɨgaꞌ! ");
INSERT INTO byr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sarɨmɨ mayawaaꞌ pwasangɨna jawɨranganyɨla! Tɨretɨya mihwiadɨvɨsangɨ. Kwaabɨyɨvɨta marɨlyadɨvɨsangɨ. Kɨrɨꞌ sarɨmɨnyɨ yɨhɨthɨvanɨge. Kɨgaakuna Kingɨya Solomonɨ gamɨre nɨgwɨlalaaka byaannaka yuya yɨwaala yɨwannyaakelyɨ. Kɨrɨꞌ mayawaaꞌ pwata dazabaaibɨꞌ sahwai gamɨre yɨwaala tewaanya kɨnɨnnakei mɨꞌ! ");
INSERT INTO byr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wawɨnyangɨ dahaaꞌ kurɨvaarɨya waayɨke sare sa yune mwanyagaaꞌ davapɨjɨ dɨkevɨ sɨtovɨyavɨ marirapɨꞌdengɨ. Nabaai yaasɨwakurɨvaarɨya sa, yɨ sangɨ Gotɨyai yɨwaala yɨwagɨthaakwadengɨ. Sarevɨdaaꞌnyɨ yɨ sarɨmɨ dɨragɨnna maalɨꞌna lɨmwadɨvɨsaihi kurɨvaarɨya sa yuna naanga wavɨlaꞌdɨvɨsaihɨrɨ yɨhɨvaazɨꞌmakwadei daaka! ");
INSERT INTO byr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Sarevɨ sarɨmɨ yawɨrɨkwaasa kwalaalya myɨpɨnera! ‘Nemɨ tɨka wapaaya benɨ naadeinaavaka? Aalya benɨ naadeinaavaka?’ Nabaai sɨmudaadaanya myawɨpɨnera! ");
INSERT INTO byr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sareꞌ dareꞌnesɨ. Kwaaka davakɨ Naangerɨna malɨmwagyadɨvɨsara ajɨmya yuyangɨyara wapaaya aalya gɨlyɨvɨta sazanna bɨramaaryaꞌnera sɨmunya kwalaalya yawɨꞌdɨvɨsare. Sarɨmɨ yuya sasarenna yɨhɨmudaasada sanna Sɨrɨnɨmaangei mena yawɨꞌmanɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sare kɨrɨꞌ Gotɨyai aꞌmweraavɨ maremwaaideꞌ bɨramaasaꞌna sɨmunya jawɨryideꞌnanyɨ. Sara kyawɨrapɨri yuya daza kɨnɨjɨ yɨhɨzaavadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sarɨmɨ sipɨzipɨya maalɨkevaasɨyaihi lɨka mipɨnera! Gamɨre maremwaaideꞌ yɨhɨzaayaꞌnei Sɨrɨnɨmaangei yagaalyaꞌ mena jamungajakelyɨ. Sareꞌ yɨlaaya yakelyɨ. Sareꞌna lɨka mipɨnera! ");
INSERT INTO byr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sarɨmɨre gɨlyɨvɨsa mubya yapɨjɨ sare nɨgwianna wɨmudaasɨvanɨkeraavɨ gaimwangeꞌna yanga duzaayidengɨ. Sara kyapɨri Sɨgunyavɨ gɨlyɨvɨta nawɨꞌnyanna nawɨꞌnyanna sarɨmɨnyɨne waradeꞌnanyɨ. Sɨgunyavɨya gɨlyɨvɨsa yuneba dɨmariꞌmwanade mɨꞌ. Sara kyapɨri Sɨgunyavɨ sarɨmɨnyɨne nɨgwɨpaawɨzɨya kayaaka minyɨ yade waradengɨ. Sarevɨ nabaai kukera kuka mamaraabyadɨvɨsangɨ. Saba maaꞌnyaannyɨkera tɨka manyadɨvɨsangɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sareꞌ dareꞌnanyɨ. Sarɨmɨre gɨlyɨvɨta nawɨꞌnyanna nawɨꞌnyanna warɨkebanna yɨ dazahɨbanna sarɨmɨre sɨmunya yawɨrɨbainyɨna jidevera. ");
INSERT INTO byr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tavaravananeꞌna sarɨmɨre kwaabɨhannya keꞌbanna gɨꞌmwagayɨraꞌnapɨjɨ munnaanya dɨvadathɨvainyɨla! Sara yapɨjɨ laamɨvananyaꞌ yewɨtawakapɨjɨ tavaravana dɨmwaalyɨla! ");
INSERT INTO byr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Aꞌmwera kunnya naangerɨna mudɨkangeyaba munne naangeyabadaaꞌnyai bazarɨna yawɨꞌdɨvɨꞌ yemwaaidɨvɨtabaaibɨꞌna jemwaalyɨla! Nabaai ‘Sai bozɨ kaanyavɨ mala kabaramojɨ kaanyaꞌ yɨmeꞌnyaꞌbɨꞌ basamaraana!’ dapi jemwaalyɨla! ");
INSERT INTO byr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Naangei bozɨ gamɨre wɨdaayadɨvɨsara nayaa baihanaꞌdɨvɨꞌ se mwaryadapi wanganojɨ yɨlaaya yada sarevɨ wɨdaayadɨvɨta dazara yɨlaaya yadɨvɨꞌ tewaanaanga yɨnɨkerera. Naanga nebulyaꞌna yɨhɨthɨvanɨge. Naangei sai gamɨ sai kwaabɨhannyaꞌ tuꞌna gɨꞌmwagayɨraꞌnojɨ munnaanyaꞌ padathɨvainojɨ gamɨreraavɨ ‘Yɨꞌbɨnyavɨ walamwaaibɨkajɨ,’ wɨdathelyɨ. Sara yojɨ gamɨ sai tɨka wapaaya buzaavadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nabaai sai sawɨsavɨ kalawawegaaꞌ bathei dɨngaka? Yɨrɨꞌjɨhɨnyagaaꞌ bathei dɨngaka? Sara bazai tɨnna dara wanganajaꞌ ‘O, se mwarijɨhava!’ Yɨ wɨdaayadɨvɨta sara yɨlaaya yadɨvɨꞌ tewaanaanga winaderera. ");
INSERT INTO byr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Daꞌdareꞌ jawɨrila! ‘Angevɨ gyakwalaangei mena yawɨrajɨ kwajɨ “Aꞌmwe kukei sagaaꞌ bathei daaka!” aꞌmwe kuka dazai angevɨ kadavalɨvɨramakulaꞌ sahwarɨ kwanganakadɨka!’ ");
INSERT INTO byr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nabaai sarɨmɨ kwaihɨlyɨ nayaa tavaravana dɨmwaalyɨla! Aꞌmweraavɨne Kaimɨraayai gave pɨgaaꞌ bathehaaꞌna sarɨmɨ jawɨryidehaaꞌ ‘Dahaasagaaꞌ mabi yadelyɨra,’ yɨ dazagaasagaaꞌ bathelyɨra. Sareꞌna tavaravana dɨmwaalyɨla!” ");
INSERT INTO byr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sagaaꞌ Pitai wɨdɨna “Naangeigɨ, keꞌbaꞌnanya dazaꞌna yune nemɨnyɨneꞌ dahanedɨvanɨgɨna? Aꞌmwe yuya kwaraavɨjɨneꞌ dahanedɨvanɨgɨna?” ");
INSERT INTO byr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sara wɨdɨna kyaꞌ Naangei wɨdɨna “Yɨ, maremwaaide sɨmunya nawɨꞌnya kɨnɨnnakei gannya wawɨnyavɨ nayaa lɨmwagaꞌdei aaihwalaka? Dazahwai sarɨ gannya naangei gamɨre wɨdaayadɨvɨsaraavɨ maremwaalyaꞌnerɨ dahɨlakadelyɨ. Maremwaalya sahwai sahwaraavɨnegaaꞌ kimaꞌnojɨ wapaaya saza yanga wɨjaayaꞌnelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Gamɨre naangei ayɨna kaanya byaꞌnegaaꞌ sɨnnawɨ wɨdakabaaibɨꞌ sara yaderɨ yɨ yaasɨwaꞌwawɨnya dazarɨ tɨnna dara kwanganori yɨ sarevɨ yɨlaaya naanga yada tewaanaanga winadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nebulyaꞌna yɨhɨthɨvanɨge. Naangei gamɨre gɨlyɨvɨta yuyangɨ maremwaala yaꞌnerɨ dahɨlakadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kɨrɨꞌ yaasɨwaꞌwawɨnya dazare sɨmunyavɨ dara yawɨrajai ‘Nɨmɨre naangei yarai mabi yannei dɨngaka,’ wawɨnya wɨdaayadɨvɨsaraavɨjɨ wɨdaayadɨvɨsangɨjɨ mala tamɨna. Sara tamɨbainadaaꞌda tɨka munne naangejɨ biyaayajɨ nyɨna yada yɨmaka wɨlɨbainadaaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sahwai sasara yɨbainadaaꞌdori yaasɨwaꞌwawɨnya dazare naangei yɨrɨka pɨgaaꞌ ayɨna bɨna yadelyɨ. Baza sagaaꞌ sarɨkɨ wɨdaayadei yemwaala yadei mɨꞌ. Nabaai yɨrɨka gave pɨgaaꞌ sahwai yawɨrangadei mɨꞌ. Kayaaꞌna yɨna yadaawori naanga dazai sahwarɨ yuna woripuꞌna yadelyɨ. Sara yada aꞌmwe malɨmwagyadɨvɨsaraavɨre tɨvɨkɨsaburɨ yeꞌmwagamwaaihɨna yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Wɨdaayade dathai gamɨre naangere saburɨ mena yawɨꞌda kɨrɨꞌ tavaravana myada naangere saburɨ mamɨdɨnyade sarerɨ naangei mala dɨragɨnna tamɨna yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kɨrɨꞌ wɨdaayadei sɨmunya myawɨryai naangere saburɨ gamɨnyɨ mala yɨnɨga tamannerɨna, saꞌna naangei mala maalɨꞌna tamɨna yadelyɨ. Aꞌmwe kwalaalya maaꞌdɨvɨsara ayɨna kwalaalya wɨrɨvɨkɨradere. Nabaai aꞌmwera aꞌmwe pwarɨ gɨlyɨvɨta kwalaalya wɨjaavɨpɨjai yɨ sare sarɨ ‘Gɨlyɨvɨta kwalaalya pɨnɨjɨ nerɨvɨkɨrana!’ yawɨrapɨjɨ jaka wɨdɨpɨꞌdelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Dɨkeꞌ kurɨya yaaye yɨngakɨnɨke nadevaaibɨꞌ aꞌmweraavɨ maratangɨvalyaꞌneinyɨ Kwaakevakɨna bɨweinyɨ. Sarevɨ tewaanna yawɨꞌmanɨge dɨka dazaꞌ yɨmeꞌnyaꞌbɨꞌ yɨdatheꞌna. ");
INSERT INTO byr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Taanginyavɨ (bavɨtaazɨyavɨ) nyɨvaihadeꞌ kɨnɨnnakeinyɨ. Dahaaꞌ sara manyainyɨ nɨmɨre sɨmunyaꞌ taanga nyɨnaꞌmanɨkeꞌna ‘Yarai yɨmaꞌnadeꞌ tewaanyasɨ,’ yawɨꞌmanɨge. ");
INSERT INTO byr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sarɨmɨ nɨmɨnyɨna dahayawɨꞌmanɨgava? ‘Kwaakevakɨya yuyaraavɨ avaaizɨmunya wakyaꞌnei bɨwakei dɨngaka!’ Aawa. Sarɨmɨnyɨ yɨhɨthɨvanɨge. Nɨmɨ aꞌmweraavɨ maratangɨvalyaꞌneinyɨ bɨweinyɨra. ");
INSERT INTO byr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sareꞌ dareꞌnesɨ. Dahaasɨ dɨvi kɨgaasɨ anga pɨrɨvɨ aꞌmwe atɨlya mwaalapɨriyangɨ pɨvakaai tangɨvainɨpɨꞌdengɨ. Dawaai dasamɨlɨka pɨrɨwaarɨna sɨmunya geꞌ kɨnɨnnake mwaaibɨꞌdengɨ. Nabaai pɨrɨwaai dawaai dasangɨna sɨmunya geꞌ kɨnɨnnakewaai mwaalyɨkadewaalyɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kɨnɨdaai jaapainakɨlyɨ ganɨmaangei gevwi yawɨꞌna, gawaalɨvaangei gevwi yawɨꞌna yadiꞌ mwaalyɨkaderaalyɨ. Nabaai kaimɨraayai gannya ganɨmaangerɨna gevwi yawɨꞌna yadelyɨ. Kɨnaai jaapainakɨlyɨ ganaangeꞌ gevwi yawɨꞌna, taayaꞌ gevwi yawɨꞌna mwaalyɨkadewaalyɨ. Nabaai kɨyataai jaapainakɨlyɨ aꞌmwe naangeꞌ gyaayaꞌ gevwi yawɨꞌna, gyaayaꞌ gevwi yawɨꞌna yadiꞌ mwaalyɨkadewaalyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aꞌmwe kwala bwaꞌnaanyangɨjɨ wɨdɨna “Nyɨlyai walakadimagɨ yɨraaya tɨnga yemina yadaaꞌnyɨ sarɨmɨ tɨnna sara wangadɨvɨꞌ yɨmeꞌnyaꞌbɨꞌ dara dadɨvɨsaihɨlyɨ ‘Ai, burɨkeꞌ bwalaradeꞌnanyɨra.’ Sara deva yadapi yɨ sara yɨmaꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nabaai yɨhuta dɨragɨnyaꞌ saawɨtɨyɨmagɨdaaꞌnyɨ badevɨ tɨnna wangadɨvɨꞌ sarɨmɨ dadɨvɨkɨ ‘Nyɨlyaꞌ tɨrɨkwaaꞌdɨka nadeꞌna yɨwaka.’ Yɨ sare saꞌ yɨmaꞌnyɨna yadesɨ. ");
INSERT INTO byr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kwaasɨ yadɨvɨsaihi, Kwaakevakɨya saburɨjɨ sɨgunyavɨya saburɨjɨ tɨnna nayaa yawɨrangadɨvɨsaihɨlyɨ. Sare kɨrɨvɨdaaꞌnyɨ kɨrɨꞌ dahaasa sabwineꞌna Gotɨyai yɨvanɨka aaya kaavɨlyaꞌna sɨmunya myawɨranganyɨvanɨgasaꞌ baaꞌna yadɨvɨkaka! ");
INSERT INTO byr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sarɨmɨ saihi nɨmɨnyɨna sɨmunya nayaa mamaryawɨbwaryadɨvɨꞌ ‘Sai yɨdaꞌmaraangelyɨ,’ beꞌna yadɨvɨkaka! ");
INSERT INTO byr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sareꞌ dareꞌnesɨ. Kotɨyaꞌneigɨ aꞌmwe pwalyɨ tutaanyavɨ kaanya yeꞌmwannɨgwodiꞌ aꞌmwe sai kotɨya gɨmaryaꞌnelyɨ saraaihi tutaanyavɨ kaanya kuna wodiꞌ yɨ dazagaaꞌ yagaalyaꞌ yuneꞌna jamungajakyaꞌ jideraaihɨlyɨ. Sahwai yawɨbwaꞌderyawɨnna nagɨmakwodɨꞌdeꞌna. Sara kagɨmakwawojɨ yɨ yawɨbwaꞌdei pɨlɨzɨmaanɨyarɨ kagɨmaaryojɨ pɨlɨzɨmaanɨyai kalavuzangevɨ nagɨmwaaihadɨka! ");
INSERT INTO byr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Gɨmɨnyɨ gɨthɨvanɨge. Kalavuzanga dazavɨ yarai jahalyaꞌmakwodeigɨ mɨka! Aayagaaꞌ gɨmɨre yadɨnya naanga sannajɨ maalɨka sannajɨ yuneꞌna tɨvɨkɨraꞌgɨzɨyagaaꞌnanyɨ. Gotɨyai nagɨmaryawɨbwaradɨka!” ");
INSERT INTO byr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sahɨgaaꞌ aꞌmwe pwara bamwaaina yeva aꞌmwe Galɨli mwaalya pwaraavɨna wɨdɨna. Sahwaraavɨ Paailatɨ tamakaka Naangerɨna Pɨrizɨyara sɨmakurɨꞌdɨka tamiraꞌmwaꞌdaata sangɨre tawesɨ sahwaraavɨre tawesɨ waramwannyɨna kyɨwaꞌdɨꞌ balɨna yɨwaꞌdaasaraavɨna wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Wɨdɨna kyeꞌ sai jaꞌnawɨdɨna “Sarɨmɨ dahayawɨꞌmanɨgaꞌ ‘O, aꞌmwe Galɨlidaaꞌnya dazara taanginya sara maaꞌmwaꞌdaasaꞌna nemɨ yawɨꞌmwo “Galɨlidaaꞌnya yuya pwaraavɨre yuna kayaaꞌnanya gɨrɨkitaꞌnanyabwi wavɨlakasarera.” ’ Sara dahayawɨꞌmanɨgaꞌ? ");
INSERT INTO byr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nɨmɨ yɨhɨthɨvanɨge. Sasarebwi mɨꞌ. Aawa. Sarɨmɨ sɨmunya mudɨkebwi myawɨramaari yɨpɨjaꞌ sarɨmɨ yuya kwaihi yuna kayaaka avaaina sasara jɨmaꞌnyideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nabaai aꞌmwe (18) eitinɨyara kɨgaaꞌ anga saamɨnaanga Silowamɨneꞌ kumɨnyɨ dɨthɨngɨta tamaka tamakɨna yakere. Saꞌna sarɨmɨ dara dahayawɨꞌmanɨgaꞌ? ‘Baihɨraka saraavɨre tɨvɨkɨsabwina aꞌmwe pwara anga Jeruzaalemɨ mwaaihata saraavɨre kayaaꞌnanyangɨne saburɨ wavɨlavɨkebwi dɨngaka!’ ");
INSERT INTO byr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nɨmɨ yɨhɨthɨvanɨge. Sasarebwi mɨꞌ. Aawa. Sarɨmɨ sɨmunyabwi mudɨkebwi myawɨramaari yɨpɨjaꞌ sarɨmɨ yuya kwaihi yuna kayaaka saꞌbɨꞌna jɨmaꞌnyideihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Keꞌbaꞌnanya daꞌ wɨjɨwaakɨna yɨna “Aꞌmwe pwai gamɨre gɨraipɨwiwawɨnyajɨkɨ yɨta pihɨyaꞌ waayɨkesɨ. Sara waayɨkevɨ pɨgaaꞌ tɨka munne pɨnɨ yɨꞌnajanna bɨramaaryaꞌnei kaanna bɨna. Aawaawa, pɨnɨ miꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Sarevɨdaaꞌnyɨ wawɨnyavɨ wɨdaayaderɨ wɨdɨna ‘Yɨthaa, kwarame dawaai dasangɨ yɨta pihɨya savɨ yɨsɨla yɨꞌnajanna bwanganyaꞌneinyɨ, kɨrɨꞌ miꞌnyɨ yadesɨ. Sareꞌna yɨta saꞌ dawasɨꞌna jɨthesɨ. Kwaakevakɨya mɨnarya sajɨꞌ yaasɨwaꞌna beꞌna yɨgainamayɨꞌdezɨkaka!’ ");
INSERT INTO byr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sara wɨdɨna kyaꞌ sai jaꞌnawɨdɨna ‘Aꞌmwe naangeigɨ, kwarame dahaasa davɨ wanganakɨna jɨthelyɨ. Pɨzɨꞌgwa waayadelyɨ. Yɨta sɨkɨ kaavɨlyawɨ kwaakejɨꞌ lɨkaꞌmujɨ bulɨmakaawoyaraavɨre lɨkejɨ marakaabɨdehaaꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kwarame ayawɨdaasa pɨrɨvɨ yɨsɨlya tewaanya yɨꞌnadiꞌ dɨngaka? Sarevɨ nabaai miꞌnyɨ yajɨꞌ dapalasɨꞌna jɨthikɨ.’ ” ");
INSERT INTO byr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kwazaakegaaꞌ lotuanga pɨrɨvɨ aꞌmweraavɨ wɨjɨwaakɨna. ");
INSERT INTO byr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yɨthaa, sagaaꞌ aꞌmwe pɨrɨꞌ nalaaya yɨmakei mwaaidɨꞌnyɨyaꞌ mwaalɨna. Sarevɨ yɨmaka dazai nalaayaꞌ kuna wɨjavadaaꞌnyɨ kwarame (18) eitinɨya wavɨlaꞌnɨkesɨ. Sarevɨdaaꞌnyɨ aꞌmwe dazavɨre bulayagɨnyarɨꞌ naadɨya gɨhaarɨꞌnɨkerɨkɨ. Sara yɨnɨkevɨ yɨdaꞌna nayaa madaayɨ yadesɨ. ");
INSERT INTO byr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jizaazai wɨjɨwaakɨna yada aꞌmwe sahɨrɨvɨ tɨnna wanganna yɨna yaka jaka jɨvwarɨjɨmaaꞌnyɨna yakegaaꞌ wɨdɨna “Aꞌmweꞌgɨ, gɨmɨre nalaayaꞌ mena wɨla gyaaꞌmwesɨra.” ");
INSERT INTO byr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Sara wɨdaka aꞌmwe dazavɨ asaꞌ yɨladathɨwanna kyaꞌ jaahwasaꞌbɨꞌ yɨdaꞌna tewaanna daavɨna. Yɨdaꞌna tewaanna daavɨna yaka Gotɨyarɨne yayaꞌ munyaba makida yɨlaaya naanga yɨna. ");
INSERT INTO byr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yɨlaaya naanga yɨna kyaꞌ lotuangevɨ maremwaaidei Jizaazai kwazaakegaaꞌ tewaanya yavadaꞌgaidaaꞌnyɨyaꞌna sɨnna tɨka davɨna. Sarevɨ maremwaaidei kwala bwaꞌnaanyavɨ wɨdɨna “Wawɨnya yaꞌne yɨrɨterɨka ata purɨdaaꞌnyɨ pwaina. ‘Aꞌmwera nemɨre nalaaya nemarasɨpɨka!’ yawɨpɨjaihi wawɨnya yaꞌne yɨrɨka dazarɨkaavɨ dɨvideihɨlyɨ. Sasare sa yaꞌneihi kwazaakegaaꞌ mikabɨpɨnera!” ");
INSERT INTO byr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sara wɨdɨna kyaꞌ Naangei jaꞌnawɨdɨna “Kwaasɨ yadɨvɨsaihi! Kwazaaka sagaaꞌ sarɨmɨ yuyaihi wodɨvɨꞌ bulɨmakaawoya pwaraavɨjɨ dogiya kwaraavɨjɨ pwɨyɨnɨkeraavɨ yɨralawaasadɨvɨsaihɨlyɨ. Sara yadɨvɨꞌ aalya nyaꞌneraavɨ aalyayawɨnna makwodɨvɨsaihɨlyɨ. Saꞌ tewaanyabulyɨ. ");
INSERT INTO byr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kɨrɨꞌ aꞌmwe dathaꞌ aꞌmwesɨ. Ne sɨnnawɨnya Evɨraamɨmɨresɨ. Sarevɨ Saataanɨ, yɨthaanna, kwarame (18) eitinɨyangɨ dathɨwagamaremwaaidesɨ. Sareꞌ pwɨyɨnɨkesɨ. Kwazaakegaaꞌ sasare pwɨyɨnɨka dazaꞌ wɨla yaaꞌmujaꞌ, yɨ saꞌ kayaaꞌnanyaꞌ dɨngaka!” ");
INSERT INTO byr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sai sara kudaꞌ sagaaꞌ gamɨre yɨkamaangera wagɨla maarɨna. Nabaai sai nawɨꞌnya byaannaka yaka sangɨ kwala bwaꞌnaanya yuyaꞌ wanganeva yɨlaaya naanga mɨjɨwɨlɨna. ");
INSERT INTO byr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sarevɨdaaꞌnyɨ ayahi pɨnɨjɨ wɨdɨna “Gotɨyai aꞌmweraavɨ maremwaaideꞌ berɨꞌbɨtavaka! Nɨmɨ gathaꞌdara yɨhɨzɨwaakɨwɨnevaka! ");
INSERT INTO byr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Davaaibɨsasɨra. Aꞌmwe pwai arajɨla pɨrɨꞌ maaraka gannya wawɨnyajɨkɨ maraburɨnna. Sara maraburɨnna yaka savɨ naanga yɨrɨꞌna yaka yɨsɨꞌ yɨmaꞌnyɨna. Sara yakikɨ sɨgunyavɨya yusara taanyabaraavɨ bamwaaina. Sabaaibɨsasɨra.” ");
INSERT INTO byr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sarei ayɨna wɨdɨna “Nɨmɨ Gotɨyai aꞌmweraavɨ maremwaaidevɨna gathaꞌdara yɨhɨzɨwaakɨwɨnevaka! ");
INSERT INTO byr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Davaaibɨsasɨra. Aꞌmwe pɨrɨꞌ yɨzɨyaꞌ maaraka gɨrɨkwimaaꞌgula naangevɨ yegɨnyɨwanna kyaꞌ dɨvidaaꞌnyɨ gɨrɨkula yuya sa lɨwɨnya pamidakɨna. Saꞌbɨsasɨra.” ");
INSERT INTO byr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sahwai Jeruzaalemɨ sabannei kaanya woda anga naanga pɨbanyajɨ anga maalɨka pɨbanyajɨ sabanyaavɨ lotavamarina. Kaanya sara lotavamaryadehaaꞌ yuyaraavɨ wɨjɨwaakɨna. ");
INSERT INTO byr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Lotavamarina yadaaꞌnyɨ aꞌmwe pwai yɨdaanganna “Naangeigɨ, Gotɨyai aꞌmwe pwaina pwainanyaraavɨna padaihasamaaradei dɨngaka?” Sara yɨdaanganna kyaꞌ yuyaraavɨ wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kaadihɨta maalɨka dazarɨkɨ wɨlyaꞌnevɨ sarɨmɨre yagɨnya nayaa dɨragɨnna taabɨrɨwala dɨthaayɨla! Nɨmɨ yɨhɨthɨvanɨge. Aꞌmwe kwalaalyara ‘Kusawɨ wɨlaana!’ dapɨjɨ yɨpɨjara kɨrɨꞌ yɨnɨga wiꞌna wibɨꞌdera mɨꞌ. Sareꞌna sarɨmɨre yagɨnya nayaa dɨragɨnna taabɨrɨwala dɨthaayɨla! ");
INSERT INTO byr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Dɨvi sagaaꞌ anga savɨ gyakwalaangei angevɨya kaadihɨsaꞌ kaanya maratihɨꞌna yajavɨ. Sarɨmɨ mwasaba bathaaꞌna yapɨjɨ kaanyavɨ mala baramɨdaaꞌnadɨvɨꞌ jaka dara dɨna jideihɨlyɨ ‘Naangeigɨ, nemɨnyɨ kaanyaꞌ dɨnebasamaraama!’ Sara kudapɨjɨ sai sarɨmɨnyɨ dara yɨhɨthathelyɨ ‘Nɨmɨ mayɨhwanganyadɨnyainyɨra. Sarɨmɨ aꞌmwe anga gavadaasaihɨlaka!’ ");
INSERT INTO byr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sareꞌna nabaai sarɨmɨ gaai duzideihɨlyɨ ‘Nemɨ gɨmɨjɨ tɨka wapaaya aalya yeꞌmwannanoneinera. Nabaai gɨmɨ nemɨre tusabanyaavɨ nemɨnyɨ nejɨwaakagɨnyaigɨnyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kɨrɨꞌ sahwai sarɨmɨnyɨ ayɨna yɨhɨthathelyɨ ‘Nɨmɨ mayɨhwanganyadɨnyainyɨra. Sarɨmɨ aꞌmwe anga gavadaasaihɨlaka! Sarɨmɨ aꞌmwe kayaaꞌnanyabwina yadɨvɨsaihi, sareihi yuyaihi nɨmɨnyɨ dava ganyɨla!’ ");
INSERT INTO byr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Sarɨmɨ Ne Evɨraamɨmɨjɨ Ne Aazakɨmɨjɨ Jaikopɨmɨjɨ pɨropetɨya yuyaraavɨjɨ tɨnna danganyideihɨlyɨ. Yɨ sahwara Gotɨyai maremwaaidevɨ mwaaidapɨjɨ kɨrɨꞌ sarɨmɨ saihi yɨnahu mwasɨlaa yɨhɨmarasɨꞌnajaihi dɨmwaalyideihɨlyɨ. Sarevɨ sarɨmɨ kɨnna dadɨvɨꞌ sarɨnnya maangerɨkaavɨ dɨhɨzɨvainyidesɨra. ");
INSERT INTO byr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yɨ, aꞌmwerajɨ aꞌmwejɨ nyɨlyai bilyɨrɨꞌdimagɨdaaꞌnyarajɨ nyɨlyai walakadimagɨdaasarajɨ akyamwidaaꞌnyarajɨ sahwara Gotɨyai aꞌmweraavɨ maremwaaidevɨ tɨka munne nyemwaaibɨꞌdere. ");
INSERT INTO byr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yɨthaanyi, aꞌmwe pwara kumɨre yaya kwaakeba warɨkera dɨvi kumɨre yaya munyaba waraderera. Nabaai pwara kumɨre yaya munyaba warɨkera dɨvi kumɨre yaya kwaakeba waraderera.” ");
INSERT INTO byr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sagaasagaaꞌ gamɨnyawɨnna Perɨzɨya pwara yɨkabɨna yɨna yeva wɨdɨna “Erotɨyai gɨmɨnyɨ gɨramakadeꞌna anga dathava yagalyaꞌmavaꞌgɨzɨ pimagɨnna dɨwodeigɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Sara wɨdɨna kyeꞌ kumɨnyɨ wɨdɨna “Kavɨjɨlɨka kayaaꞌnanya dazarɨ dara duthaawila! ‘Yɨthaanyi! Dahaasɨ mwanyagaasɨ nɨmɨ yɨmakeraavɨ wɨdaasadɨ aꞌmwe nalaavɨnakeraavɨ tewaanya yavadaꞌgaimanɨgehaakɨ. Sarevɨ yɨrɨka daryaai darɨkɨ nɨmɨre wawɨnyaꞌ yuneba yɨꞌmwannɨdehaakɨ.’ ");
INSERT INTO byr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sareꞌ kɨrɨꞌ dahaasɨ mwanyagaasɨ alyɨjɨ nɨmɨ kaanya wɨdehaakɨ. Anga pɨba pɨropetɨya aane pwarɨ tamakɨpɨꞌdei mɨꞌ. Aawa. Yune Jeruzaalemɨ sahɨbanna nyɨramakɨpɨꞌdeinyɨ. ");
INSERT INTO byr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jeruzaalemɨgɨ, Jeruzaalemɨgɨ pɨropetɨyaraavɨ tamakadɨnyabagɨnyɨ. Sara yadɨ Gotɨyai aꞌmweraavɨ gɨmɨnyawɨnna maryasaabaderaavɨ sɨlyajɨ lɨwakadɨnyabagɨnyɨ. ‘Kukuraayaꞌ gannya pɨyayawɨ bwaranyangɨ marulakamaremwaaidevaaibɨꞌ saamɨnya kwalaalya naangegaaꞌ gɨmɨre kaimɨraayangɨ mariꞌbwarɨma!’ dena yɨweinyɨ. Sarɨmɨ ‘Aala,’ dadaapɨjɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yɨthaanyi! Gɨmɨre angevɨ Gotɨyai mena yagalyaꞌmaꞌmwakesɨ. Sarɨmɨnyɨ yɨhɨthɨvanɨge. Sarɨmɨwɨ dɨpɨja sagaaꞌna ‘Naangerɨne yayavɨna bɨvanɨka dazarɨ yayaꞌ munyaba makɨlaana!’ dɨnyanganyideinyɨ. Pɨgaaꞌ nɨmɨnyɨ ayawɨdaaꞌnyɨ dɨnyanganyideinyɨ mɨka! Arɨkewɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kwazaaka pɨgaaꞌ pɨrɨkɨ Perɨzɨyaraavɨ maremwaaidere angevɨ Jizaazai tɨka wapaaya nyaꞌnei wɨna. Wɨna yaka sara nadaaꞌnyɨ kumɨ nayaa baihanaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nayaa baihanaꞌna yadaapi, yɨthaa, aꞌmwe pwai, gannya kɨlaakejɨꞌ mɨlamakinɨkei, sare sai gamɨnyaba aya kɨba bamwaaina. ");
INSERT INTO byr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Aya kɨba bamwaaina kyaꞌ Jizaazai kɨwɨnyangɨ maremwaaidɨvɨsaraavɨjɨ Perɨzɨyaraavɨjɨ yɨdaanganna “Kwazaakegaaꞌ nemɨ nalaavɨnakeraavɨ tewaanya yavadaꞌgalaanneꞌ tewaanyaꞌ dɨngaka? Aawa dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yɨdaanganna kyaꞌ sahwara kadɨka wɨꞌnabalakulɨna yadapi aꞌmwe sarɨ maarɨna yɨna yaka tewaanya yavadaꞌgaina yaka gannya angebannerɨ wɨdaasɨna. ");
INSERT INTO byr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wɨdaasɨna yaka sarevɨ wɨdɨna “Sarɨmɨjɨya pwai kaviꞌnɨnnyavɨ gamɨre kaimɨraaya pwai bulɨmakaawoya kwai kwalyɨꞌnaraawojɨ kwazaakegaaꞌ aꞌmwe sai yɨmeꞌnyaꞌbɨꞌ malɨvamakɨlyɨ yadei daaka!” ");
INSERT INTO byr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Sarevɨdaaꞌnyɨ ayɨna mujaꞌnawɨjɨ yɨpɨnerera. ");
INSERT INTO byr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Aꞌmwera tɨka munne dazavɨnera badaapi namwaalyɨta nawɨꞌnyangɨna “Mwalaana!” dadɨvɨꞌ yadaapi sahwai tɨnna wanganna yaka sarevɨdaaꞌnyɨ keꞌbaꞌna yagaala pɨrɨꞌ wɨjɨwaakɨna. Sai wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nabaai aꞌmwe pwai mudɨkangegaaꞌne munne naanga savɨna jaka gɨthɨjɨmaaꞌnajaigɨ namwaalyɨta nawɨꞌnyavɨ mamwaaidɨnnera! Aꞌmwe mudɨkanga sahɨrɨsɨyai aꞌmwe pwarɨ gɨmɨnyɨne yayavɨ gwavɨlavɨka pwarɨ jaka nujɨvwarɨjɨmaaꞌnadɨka! ");
INSERT INTO byr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nabaai sasara yajaꞌ yɨ aꞌmwe yuyaraaihɨrɨ jaka yɨhizɨvwarɨjɨmaaꞌnajai dara gɨthathelyɨ ‘Aꞌmwe daahawai namwaalyɨta daahaꞌ maarana!’ Sara kyojɨ gɨmɨ wagɨla naangeꞌ maarɨna yaꞌgɨzɨ gamɨnyɨ dusɨmagɨdaasɨ kewɨnɨna walyamwalaawɨna jɨtheigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Namwaalyɨta nawɨꞌnyavɨ yarai mwaalyaꞌnebwi jɨtheigɨ mɨꞌ. Aawa. Aꞌmwe pwai jaka gɨthazaigɨ munne savɨna woꞌgɨzɨyaigɨ yune aaya tɨyawɨnna dɨmwaaideigɨnyɨ. Gɨmɨ sara yɨjaꞌ aꞌmwe gɨmɨnyɨ jaka gɨthazai sai bɨna yojɨ gɨthathelyɨ ‘Nyaꞌmweigɨ, namwaalyɨta naanga nawɨꞌnya dava davɨ bilamwaala!’ Sai sasara kyojɨ aꞌmwe yuyaraavɨre tɨnnyarɨ yaakimaꞌnyaigɨ mwaalaꞌgɨzɨ tɨka wapaaya jeꞌmwannanadeigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sareꞌ dareꞌnanyɨ. Gazaizai yune gamɨnne yayaꞌ munyaba makɨlajai Gotɨyai dalaangewɨ marulawakɨna yadelyɨ. Kɨrɨꞌ pwai yayaꞌ gamɨnyɨna mamakinyɨ yajai yɨ sarɨna Gotɨyai gamɨnne yayaꞌ munyaba makɨladelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sagaaꞌ sai tɨka munne savɨna jaka jɨvwarɨjɨmaaꞌnaka aꞌmwerɨ wɨdɨna “Nabaai gɨmɨ tɨka munne naanga pɨrɨꞌ yɨdɨka yɨjaigɨ gɨmɨnyɨ gwajaꞌmweraavɨjɨ jɨthaaꞌjɨhwaaravaavɨjɨ gɨmɨre avaaitawejɨkɨyaraavɨjɨ gɨmɨre angebanya avaaimwaalya gɨlyɨvɨkɨravɨnakeraavɨjɨ Gotɨyai tɨvɨkɨta gɨzaayaꞌneigɨ jaka mudɨnneigɨnyɨ. Nabaai dɨvidaaꞌnyɨ gɨmɨnyɨ jaka kagɨthapɨjɨ kumɨre angengɨ gɨmɨre tɨka wapaaya yɨdɨka wɨdaayɨja sanna nanaawɨdɨka! Sara kyaꞌgɨzɨ Gotɨyare wɨrɨvɨkɨta dɨmaaꞌdeigɨ mɨꞌ! ");
INSERT INTO byr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Aawa. Gɨmɨ tɨka munne yɨdɨka naanga yaꞌgɨzɨ yɨ aꞌmwe gɨlyɨvɨꞌmaayaraavɨjɨ aꞌmwe kɨlaaka kayaaka yɨmaꞌnɨnɨkeraavɨjɨ sɨvɨla kayaaꞌnanyaraavɨjɨ aꞌmwe tɨnna tɨbɨnyaraavɨjɨ duzɨmaaꞌnadeigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aꞌmwe sasare sara tɨka munne gɨmɨre sanna ayɨna gɨrɨvɨkɨpɨꞌdera mɨꞌ. Sareꞌna yɨlaaya yadɨ tewaanaanga gyɨnadeigɨnyɨ. Sareꞌ dathareꞌnesɨ. Dɨvi aꞌmwe yɨdaꞌmaraangeraavɨ kaviꞌnɨnnyavɨdaaꞌnyɨ ayɨna yɨdɨkaavajahaaꞌ Gotɨyai tɨka munne daza gɨrɨvɨkɨradeigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Aꞌmwe saraavɨdaaꞌnya pwai gamɨjɨ tɨka wapaaya yeꞌmwannanyɨna yada yagaala dazavɨ kadɨka wɨꞌnakei sahwarɨ wɨdɨna “Aꞌmwe Gotɨyai aꞌmweraavɨ maremwaaidevɨ tɨka munne najai sai yɨlaaya yada tewaanaanga yɨnadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wɨdɨna kyaꞌ sahwai wɨdɨna “Aꞌmwe pwai ‘Tɨka munne naanga yɨdɨka yɨma!’ daka aꞌmwe kwalaalyaraavɨ tɨka munne savɨna yɨkabyaꞌneraavɨ jaka mena wɨdakere. ");
INSERT INTO byr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nabaai tɨka munne sa nyaꞌnegaaꞌ mena kɨbawa kimaꞌnaꞌ gamɨre wɨdaayaderɨ wɨdaasɨna kyaꞌ aꞌmwe sɨnnawɨ jaka wɨjɨvwarakeraavɨ wɨdaawɨna. Sai dara wɨdɨna ‘Sarɨmɨ kaajɨla! Yuya tɨka wapaaya sa tɨvi mena yovɨgaipwakɨwona.’ ");
INSERT INTO byr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kɨrɨꞌ aꞌmwe yuya dazara sɨmunya pɨrɨvɨ yagaalyaꞌ dɨna yeva wɨdɨna ‘Nemɨ mwawaanneinera.’ Aꞌmwe pwai wɨdɨna ‘Nɨmɨ wawɨnya pɨjɨꞌ mena mubena tɨnna wanganaawɨdera. Weꞌ, munne savɨ yuna wɨdeinyɨ mɨka!’ ");
INSERT INTO byr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nabaai pwai wɨdɨna ‘Nɨmɨre wawɨnya yaꞌne bulɨmakaawoya mena mubeneinyɨra. Sara mubɨwe sa yaamɨjɨ yaawɨdeꞌnanyɨ. Weꞌ, munne savɨ yuna wɨdeinyɨ mɨka!’ ");
INSERT INTO byr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nabaai pwai wɨdɨna ‘Yuna dahaasagaaꞌ mudɨkangeꞌ madeneinyɨra. Sɨdɨraayaꞌ mena maareneinyɨra. Sareinyɨ yuna wɨdeinyɨ mɨka!’ ");
INSERT INTO byr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yuyara avaaina ‘Aala!’ wɨdɨna kyeꞌ wɨdaayade dazai ayɨna wɨna yaka sasare sabwineꞌna gamɨre aꞌmwe naangerɨ wɨdɨna. Wɨdɨna kyaꞌ angevɨ gyakwalaangei sɨnna tɨka wɨdaꞌdaaꞌnyɨ gamɨre wɨdaayaderɨ wɨdɨna ‘Yarala! Tutaanya naangebanyana yarai wawaꞌgɨzɨ anga naangebanna yɨnɨguka tutaanya maalɨka yuyabanyanajɨ dɨwodeigɨnyɨ. Sara wawaꞌgɨzɨ aꞌmwe gɨlyɨvɨꞌmaayaraavɨjɨ aꞌmwe kɨlaaka kayaaka yɨmaꞌnɨnɨkeraavɨjɨ aꞌmwe tɨnna tɨbɨnyaraavɨjɨ aꞌmwe sɨvɨla kayaaꞌnanyaraavɨjɨ sasare sara mariꞌbwaramaryaꞌgɨzɨ nɨmɨre angevɨna dɨmakadeigɨnyɨ.’ ");
INSERT INTO byr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sara wɨdɨna kyaꞌ wɨdaayade dazai sara yaka dɨna ‘Naangeigɨ, gɨmɨre yagaalyavɨ mena gɨmɨdɨmwana. Kɨrɨꞌ namwaalyɨta pɨnɨ sɨhumale pɨnɨ yaasɨwaꞌ warɨna.’ ");
INSERT INTO byr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Wɨdɨna kyaꞌ naangei gamɨre wɨdaayaderɨ wɨdɨna ‘Tutaanya yuya naangebanya wawaꞌgɨzɨ wawɨnyabanya wawɨdɨvɨmaangebaraavɨ yamaryadɨ aꞌmweraavɨ aꞌmwemɨlɨkaavɨ bulamariꞌbwarɨmwaaihya! “Nɨmɨre angeꞌ yunebanna yana!” dena yawɨꞌmanɨgena. ");
INSERT INTO byr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sareꞌ dareꞌnesɨ. Gɨmɨnyɨ gɨthɨvanɨge. Aꞌmwe yuya dazara sɨnnawɨ kɨgaaꞌ nɨmɨ jaka jɨvwarɨjɨmaaꞌnera nɨmɨre tɨka wapaaya yɨnɨga wiꞌna nagaangabɨꞌdera mɨka.’ ” ");
INSERT INTO byr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jeruzaalemɨna kuna woda kwala bwaꞌnaanya naangera gamɨjɨ kaanya yamarina yadaapi sahwai gɨnyɨmaꞌnyɨna yaka wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Gazaizai nɨmɨnyawɨnna bazai, kɨrɨꞌ sai ganɨmaangerɨjɨ ganaangevɨjɨ gannya aꞌmwevɨjɨ kaimɨraayangɨjɨ gathaaꞌgahwaaravaavɨjɨ gyaꞌmwengɨjɨ nabaai gannya gaala kɨrɨvɨjɨ sangɨna tewaanya naanga wɨvuꞌnajai nabaai nɨmɨnyɨna tewaanya maalɨꞌna wɨvuꞌnajai yɨ sahwai nɨmɨre nyɨmɨdɨdei myɨmaꞌnyɨ yannelyɨra. ");
INSERT INTO byr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aꞌmwei balyaꞌnei gannya yɨta yovihɨrarannɨkeꞌ mamarikwayɨ yojɨyai nyɨmɨdɨnajai yɨ sahwai nɨmɨre nyɨmɨdɨdei myɨmaꞌnyɨ yannelyɨra. ");
INSERT INTO byr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Sareꞌ daꞌdareꞌnesɨ. Sarɨmɨjɨya pwai ‘Anga saamɨnaanga keꞌmwewɨnya pɨrɨꞌ madɨma!’ dozɨyai yɨ sai kave kwaamuꞌ mwaalojɨ anga dazavɨne nɨgwiaꞌna sɨmunya nayaa yawɨradelyɨ. Sai yawɨrade ‘Nɨgwia anga savɨneꞌ yɨnɨga wiꞌna majɨꞌmwannyaꞌneꞌ dɨngaka?’ ");
INSERT INTO byr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nabaai yuneꞌna sasara mi yajaꞌ, yɨ dɨvidaaꞌnyɨ simɨnyeꞌ mena laabozɨya kɨrɨvɨ anga saꞌ yunebanna majɨꞌmwannadeꞌ mɨꞌ. Sarevɨ aꞌmwe yuyara tɨnna wanganna yɨna yapɨjɨ aꞌmwe dazarɨ yagaaibɨraizɨka buthangamuna nyɨpɨdɨka! ");
INSERT INTO byr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Dara wɨdɨna ‘Aꞌmwe dazai anga dazaꞌ madɨthaakuna yɨna yaka nɨgwiaꞌna majɨꞌmwannyaꞌnei mi yannelyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nabaai kingɨya pwai kingɨya pwalyɨ mala bwaꞌnyaꞌnei, yɨ sarei nayaa kwaamuꞌ mwaalojɨ sɨmunya nayaa yawɨradelyɨ. Gamɨ sare aawɨlasara (10,000) tenɨ taawɨzanɨyarajɨyai dara yawɨꞌna ‘Kingɨya sahware aawɨlasara (20,000) tɨwedi taawɨzanɨyarajɨyalyɨ malyaꞌ yɨnɨga wiꞌna bwaꞌnɨdeinyɨ dɨngaka? Aawa dɨngaka?’ Sare savɨneꞌna yuneꞌna yawɨrojɨyai ");
INSERT INTO byr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","sai yawɨꞌna ‘Malyaꞌ yɨnɨga wiꞌna mwavɨlaꞌmuneinyɨ daaka!’ yawɨrojɨ, yɨthaanyi, gamɨre yɨkamaangei mena saamɨnyaba kuna yɨdori, sai aꞌmwe pwara maryaasɨna yadelyɨ. Maryaasajara wawapɨjɨ malyavɨ woyagaala dahidɨwagaawia yaꞌnera. ");
INSERT INTO byr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sasare sahɨbaaibɨꞌ sarɨmɨjɨya gazaizai gannya gɨlyɨvɨta yuya sangɨna buleꞌna mujaayɨ yajai, yɨ sahwai nɨmɨre nyɨmɨdɨdei myɨmaꞌnyɨ yannelyɨra. ");
INSERT INTO byr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sarevɨdaaꞌnyɨ yɨhɨthɨma! Saala sa yuna nawɨꞌnyaangengɨ. Kɨrɨꞌ nabaai saalyaꞌ gamɨre yɨrɨla miꞌna kadozɨ yɨ ayɨna gannya saalyaꞌ nawɨꞌnyaꞌ nemɨ gara kyawaajɨ yɨmaꞌnannevaka! ");
INSERT INTO byr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sasare saala saꞌ wawɨnyangɨ nemɨ yɨnɨga wakaanne mɨꞌ. Nabaai bulɨmakaawoyangɨre lɨkejɨ yɨnɨga wiꞌna marirakurakaanne mɨꞌ. Nemɨ yaasɨwaꞌna bwakɨrasɨꞌdaanyangɨ. Aꞌmwei kadɨꞌnakei yagaala dazaꞌ sai kadɨka nayaa wɨꞌnana!” ");
INSERT INTO byr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pɨgaaꞌ aꞌmwe taakɨzɨya maaꞌdɨvɨsarajɨ aꞌmwe gɨrɨkitaꞌnanyarajɨ gamɨre yagaalyaꞌ kadɨka wɨꞌnyaꞌnera gamɨnyawɨnna yɨkabɨna yɨna. ");
INSERT INTO byr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yɨkabɨna yɨna yeva Perɨzɨyarajɨ Kɨwɨjarajɨ mayagaala yawɨꞌna, dɨnyɨna “Aꞌmwe dazai aꞌmwe gɨrɨkitaꞌnanyarajɨ yeꞌmwannemwaaida tɨka yeꞌmwannanɨvanɨkelyɨreva.” ");
INSERT INTO byr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sai sarevɨ yawɨꞌna yaka keꞌbaꞌna yagaalyaꞌ wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Aꞌmwe pwai sarɨmɨjɨyai sipɨzipɨya (100) waanɨ aadɨretɨya kɨnɨnnakei, nabaai sipɨzipɨya pwai sangineba yadaaꞌna kyojɨ sipɨzipɨyangɨ gyakwalaangei (99) naaidi naainɨyangɨ pimagɨ aꞌmwamaayaba yagalyaꞌmaꞌna yojɨ kurɨvaarɨya nɨdaꞌnadaapi kaanna wɨna sipɨzipɨya pwai yadaavajaina bɨramaarajahaaꞌna. Sarɨmɨjɨyai sara yadei midaaka! ");
INSERT INTO byr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mena bɨramaarojɨ gamɨre egwevɨ yɨlamarakwojɨ yɨlaaya naanga yada marikwavamakuna. ");
INSERT INTO byr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nabaai gamɨre angevɨ bamariꞌmavojɨ gamɨre gyaꞌmweraavɨjɨ avaaimwaalyaraavɨjɨ jaka wɨjɨꞌbwaꞌna kyojɨ sarera biꞌbwaꞌnyɨna. Biꞌbwaꞌnyɨna kyapɨjɨ sai wɨdɨna ‘Sarɨmɨ nɨmɨjɨ yɨlaaya dɨnyeꞌmwannayɨla! Nɨmɨre sipɨzipɨya pwai yadaaꞌnɨkei nɨmɨ bɨrena mena bɨramaaꞌmwana!’ Sara wɨdathelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sarɨmɨnyɨ yɨhɨthɨvanɨge. Sasarebaaibɨꞌ, Sɨgunyavɨ mwaaidɨvɨsara yɨlaaya yadɨvɨsarera. Aꞌmwe naaidi naainɨyara ‘ “Nemɨ yɨdaꞌmaraangeina,” dadaa sɨmunya mudɨkebwi yawɨramaaryaꞌneina mamwaalyɨgoinera!’ yawɨꞌdɨvɨsara yɨ sahwaraavɨna yɨlaaya myadɨvɨsasɨ. Kɨrɨꞌ aꞌmwe kayaaꞌna yade pwai sɨmunya mudɨkebwi yawɨramaarajarɨna yɨlaaya naanga yadɨvɨsasɨ. ");
INSERT INTO byr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nabaai aꞌmwe pɨrɨꞌ nɨgwia atɨraalya kɨnɨnnakeꞌ dɨvi nɨgwia puꞌ yɨmaanyɨna. Daꞌdara yadeꞌ midaaka! Laamɨvananyai yewɨtaꞌna yɨna yojɨ nɨgwiꞌna bwakɨranganna, bavuralangasɨwalyuna, kuna bɨrɨna yada yune bɨramaarajahaaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mena bɨramaaꞌna yojɨ gamɨre gyaꞌmwengɨjɨ gamɨre avaaimwaalyayuraavɨjɨ jaka wɨdɨna kyojɨ biꞌbwaꞌnemwaaina kyapɨjɨ wɨdɨna ‘Nɨmɨjɨ yɨlaaya dɨnyeꞌmwannayɨla! Nɨmɨre nɨgwia nawɨꞌnya puꞌ yɨwɨwakiꞌ mena bɨramaarena ayɨna mena maaꞌmwana!’ Sara wɨdathesɨ. ");
INSERT INTO byr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Sarevɨdaaꞌnyɨ sarɨmɨnyɨ yɨhɨthɨvanɨge. Sasarebaaibɨꞌ aꞌmwe kayaaꞌna yade pwai sɨmunya mudɨkebwi yawɨramaarajaꞌna Gotɨyare mamaayara yɨlaaya yɨpɨꞌdere.” ");
INSERT INTO byr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nabaai wɨdɨna “Aꞌmwe pwai mɨgɨnya pwaraai kɨnɨnnakei. ");
INSERT INTO byr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sarevɨ gahwaalaanga aaya wɨryaakei ganɨmaangerɨ wɨdɨna ‘Nɨmwai, nɨmɨ gɨlyɨvɨta yuyangɨna dara yawɨꞌmwa “Naarɨmɨ yuya darainaarɨ dɨnehɨzaapalya! Sara jaapalaꞌgɨzɨ nɨmɨnyɨnevaaꞌ dahaaꞌ yuneꞌna dɨnyɨjaapalya!” ’ Wɨdɨna kyaꞌ kɨrɨnɨmaangei gamɨre gɨlyɨvɨta yuya sadaraarɨ wɨjaapalyɨna. ");
INSERT INTO byr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wɨjaapalyɨna yaka aaya wɨryaakerɨna wɨjaavɨna kyaꞌ sahwai saba maalɨkegaaꞌ mwaalɨna yaka gamɨre gɨlyɨvɨta yuya mariꞌbwaꞌna yaka anga saamɨnya menya pɨwɨ pwaraavɨrewɨnna mwalaawɨna. Anga dazaba kuna mwaaida gamɨre gɨlyɨvɨsa yaasɨwaꞌ mariwɨnamaꞌna yɨna yaka gannya kayaaꞌnanya yade saburɨdaasɨ yuna gɨlyɨvɨꞌmaayai mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sahwai gamɨre gɨlyɨvɨta yuya mena wasɨꞌnakei mwaaidɨꞌnyɨ dɨvidaaꞌnyɨ anga dazaba mɨjɨka naanga pɨrɨꞌ yɨmaꞌnyɨna. Sara yɨmaꞌnyɨna kyaꞌ sai gɨlyɨvɨta aane pɨmɨlɨꞌ muwaryadɨsɨ. ");
INSERT INTO byr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sarei anga dazabadaaꞌnya aꞌmwe pwarɨ wawɨnyaꞌ wɨdaayɨna. Aꞌmwe sai gamɨre yaawarɨkurɨsabanna wɨdaasɨna yɨna yakei yaawaryaraavɨ maremwaaida yɨꞌdɨvaina. (Juyaraavɨne wawɨnya saꞌ gɨrɨkitaꞌnanyaꞌ warɨka kɨrɨꞌ yɨna.) ");
INSERT INTO byr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","‘Yaawaryara nadɨvɨsa nɨmɨre munya wiꞌna wiana!’ daka yakelyɨ. Sahwarɨ wapaaya wɨjaayaꞌnei aꞌmwe aane pwai kwai mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sagaaꞌ gamɨ kayaaꞌna mwaalake sabwineꞌna sɨmudaadaanya kwalaalya yawɨraka gamɨnyɨneꞌna nayaa yawɨꞌna yaka dɨna ‘Nɨmɨnyɨ nɨmware yuya wawɨnya wɨdaayadɨvɨsara tɨka munne kwalaalya nadaapi kɨrɨꞌ dava yune nɨmɨ mwaaihe dainyɨ mɨjɨka naangeꞌ yuna jɨvanɨgena! ");
INSERT INTO byr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Baaꞌnana! Nɨmɨ wɨladaaꞌna yaꞌmujɨ nɨnnya nɨmwaryawɨnna ayɨna wɨdeꞌnanyɨ. Sara yaꞌmujɨ nɨmwarɨ dara wɨdɨdeinyɨ. Nɨmwai, nɨmɨ kayaaꞌnanyabwi sana yɨweinyɨ. Sɨgunyavɨya Gotɨyarɨjɨ gɨmɨnyɨjɨ kayaaꞌnanyabwi sana yɨweinyɨ. ");
INSERT INTO byr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Dahaaꞌ nɨmɨ aꞌmwe nawɨꞌnyainyɨ mɨꞌ. Sareꞌna nɨmɨnyɨna ayawɨdaaꞌnyɨ “Nɨmɨre kaimɨraayalyɨra,” nyɨdɨnneinyɨ mɨka. Gɨmɨre wawɨnya gɨthaayaꞌneinyɨ dɨnyɨdahɨlakɨdeigɨnyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sarevɨ sai ganɨmaangeryawɨnnei kaanna wɨna. Sara kaanna wɨna yake sai menya keiba kuna widavadaaꞌnyɨ ganɨmaangei tɨnna maranganna. Tɨnna maranganna yɨna yaka ganɨmaangere kale sahwarɨna yenyɨꞌnanganna wiadaaꞌnyɨ kaanyaveꞌna walyuna yaka gannya kaimɨraayarɨ walyagalamujɨraawɨna yɨna yaka maangwɨdaanyaba buꞌbuta marina. ");
INSERT INTO byr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Buꞌbuta marina yadaaꞌnyɨ gawaalɨvaangei wɨdɨna ‘Nɨmwai, nɨmɨ kayaaꞌnanyabwi sana yɨweinyɨ. Sɨgunyavɨya Gotɨyarɨjɨ gɨmɨnyɨjɨ kayaaꞌnanyabwi sana yɨweinyɨ. Dahaaꞌ nɨmɨ aꞌmwe nawɨꞌnyainyɨ mɨꞌ. Nɨmɨnyɨna ayawɨdaaꞌnyɨ “Nɨmɨre kaimɨraayalyɨra,” nyɨdɨnneinyɨ mɨka!’ ");
INSERT INTO byr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kɨrɨꞌ ganɨmaangei gamɨre yaasɨwaꞌwawɨnyaraavɨ wɨdɨna ‘Yarala! Sarɨmɨ baazɨꞌmaꞌnya nawɨꞌnyaangesɨ maarapɨjɨ makabapɨjɨ dɨvaazɨꞌmakwila! Sara miꞌna yapɨjɨ nɨgwɨlalaaka nawɨꞌnya dɨrɨmwila! Nabaai kwaariꞌmasɨvɨlyai maarapɨjɨ dɨvaazɨꞌmakwila! ");
INSERT INTO byr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sara mena yapɨjɨyagaaꞌ bulɨmakaawoya dɨwɨnya sɨgunnakei galyɨramakabapɨjɨ baramila! Nemɨ tɨka munne yabwakɨlanadaa yɨlaaya yaadeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sareꞌ dareꞌnanyɨ. Nɨmɨre kaimɨraaya dathai mena bainɨkei, kɨrɨꞌ dahaaꞌ sai gaala ayɨna mwaalɨka. Mena yadakwokei, kɨrɨꞌ nemɨ ayɨna bɨramaaꞌmwolyɨra.’ Sara daka wapeyɨdɨka naanga pɨrɨꞌ yɨna. ");
INSERT INTO byr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Yɨlaaya yadaapi aaya sɨraangei wawɨnyawɨ yɨbwaꞌnyɨna yaka dɨvidaaꞌnyɨ angebanna bɨna yaka anga kwala bwaꞌnaanya bwamwaihodapiyabanna wɨlaabɨna yaka kadɨkeꞌ wɨꞌnyɨna ‘Pɨradazajɨ tadɨvɨꞌ kwarame dahɨꞌmaꞌmanɨgava!’ ");
INSERT INTO byr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kadɨka wɨꞌnyɨna yaka wɨdaayade pwarɨ jaka jɨvwarɨjɨmaaꞌnyɨna yɨna yaka sahwarɨ yɨdaanganna ‘Gathaꞌdara yɨvanɨgava?’ ");
INSERT INTO byr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yɨdaanganna kyaꞌ sai wɨdɨna ‘Jɨhwaalaangei ayɨna mena bɨwakerɨnereva. Sara bɨwakerɨna gɨmɨnyɨ gɨmaamaangei bulɨmakaawoya dɨwɨnyai maratamaka sahwarɨna yɨdɨka yakevɨnyɨra. Gannya kaimɨraayai kɨgaakuna mena yɨwɨnɨka kwai ayɨna mena maaraka maamɨdarya mwaaimwakerɨna yoꞌdakwɨya miwakerɨna yɨwakeꞌnanyɨ.’ ");
INSERT INTO byr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nabaai sare kɨrɨvɨ aaya sɨraangei sɨnna tɨka wɨdaꞌdaaꞌnyɨ angevɨ wɨlyaꞌna ‘Aala!’ yawɨꞌna. Sara yawɨꞌdaꞌnadaaꞌnyɨ gannya ganɨmaangei mwasawɨnna bwalyuna yɨna yaka yagaala nawɨꞌnyaꞌ bwalyawɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Sara wɨdadaaꞌnyɨ ganɨmaangerɨ jaꞌnawɨdɨna ‘Yɨthaa, kwarame kwalaalya bodaaꞌnyɨyangɨ nɨmɨ gɨmɨre wawɨnyaꞌ lɨmwagaꞌdɨnyainyɨ. Yuyagaaꞌ nɨmɨ gɨmɨre yagaalyaꞌ galagɨzekɨvaidɨnyainyɨ mɨka! Sareꞌna kɨrɨꞌ gɨmɨ memedɨwɨnyai pwai nɨmɨ nyaꞌmwerajɨ yɨlaaya yadɨ yɨdɨka yanɨwɨnei nyɨꞌdaalyadɨnyainyɨ mɨka! Yuna aawaawa. ");
INSERT INTO byr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sarevɨ da gɨmɨre kaimɨraaya dathazai gɨmɨre gɨlyɨvɨta yuya dazaza aꞌmwe kayaaꞌna gɨrɨkitaꞌnanyabwi yadɨvɨsamɨlɨkaavɨ yanga yaasɨwaꞌna wɨjavamaryada yuya gɨlyɨvɨsa yɨmɨngaasɨnakelyɨ. Sara yakei ayɨna bakerɨ, gamɨnyɨna kale kagiwaꞌ bulɨmakaawodɨwɨnyai maratamagɨna yɨdɨka yɨvanɨgɨ.’ ");
INSERT INTO byr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Sara wɨdɨna kyaꞌ sai wɨdɨna ‘Kaimɨraayaigɨ, gazagaasagaaꞌ naarɨmɨnɨdainaai yeꞌmwannemwaaidasanɨdainaalyɨ. Sarevɨ nɨmɨre gɨlyɨvɨta yuya sa yune gɨmɨnyɨnannengɨ. ");
INSERT INTO byr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sare kɨrɨvɨ dahaasagaaꞌ nemɨ yɨlaaya yaadeꞌnanyɨ. Yɨlaaya sara yawaajɨ nemɨre munyɨꞌ tewaanya nawɨꞌnya yɨmaꞌnadeꞌna. Gɨmɨre jɨhwaalaanga dazai mena yɨnahu bainɨka kwai, kɨrɨꞌ dahaaꞌ gaalyai mwaaimwaꞌ. Sai mena yagalyaꞌmakwokei kwai, kɨrɨꞌ dahaaꞌ nemɨ ayɨna bɨramaaꞌmwolyɨ. Sareꞌna yɨlaaya davwi yakadeꞌ tewaanyasɨra.’ ” ");
INSERT INTO byr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nabaai Jizaazai gamɨre mɨdɨdɨvɨsaraavɨ wɨdɨna “Aꞌmwe gɨlyɨvɨkɨravɨnaka pwai gamɨre wawɨnyavɨ maremwaaidei kɨnɨnnakelyɨ. Nabaai aꞌmwe pwara gɨlyɨvɨkɨravɨnaka saryawɨnna yɨkabɨna yeva wawɨnyavɨ maremwaaide sarɨna jɨdaꞌna ‘Gɨmɨre wawɨnyavɨ gɨmaremwaalyadei gɨmɨre gɨlyɨvɨsa yaasɨwaꞌna mariwɨnamaꞌna yɨvanɨkelyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Sara jɨdaꞌna kyeꞌ sai gamɨre wawɨnyavɨ maremwaaiderɨ jaka jɨvwarɨjɨmaaꞌnyɨna yaka wɨdɨna ‘Gɨmɨnyɨna yagaala wɨꞌnɨweꞌ gathaꞌdarevaka! Kaanya wawaꞌgɨzɨ gɨmɨre wawɨnyaꞌne pɨkarɨyɨkwia yavadaꞌgalakaawɨna ja nɨmɨre gɨlyɨvɨta yuya maremwaaidɨnya sanna! Sareꞌ dareꞌnesɨ. Gɨmɨ maremwaalyaꞌ ayahi pɨrɨsɨ jɨtheigɨ mɨka!’ ");
INSERT INTO byr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Sarevɨ maremwaala dazai gamɨre sɨmunyavɨ dara dɨnyɨna ‘Aka, nɨmɨre naangei nɨmɨre maremwaala yadɨnya savɨ nyɨdaasadeꞌna nyɨwakeꞌna gara yɨdeinyaka? Nɨmɨ kwaakevaꞌ yɨnɨga malɨki yɨwɨneinyɨ dɨragɨnya maayainyɨra. Sareꞌna nabaai aꞌmwe pwaraavɨ wapejanna damaasaꞌna, nɨmɨnyɨ wagɨla nyɨvwaꞌnadeinyɨra. ");
INSERT INTO byr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kɨrɨꞌ dahaaꞌ nɨmɨ yawɨꞌmanɨge. Nɨmɨ gara yaꞌmujɨ yɨdeinyaka? O, miꞌna yawɨramaaꞌmwana! Naangei maremwaala savɨ nyɨdaasajahaaꞌ “Aꞌmwera kumɨre angengɨ wɨwɨjahaaꞌ nɨmɨnyɨ nyɨmaapɨka!” dadɨ mena yawɨꞌmwa.’ ");
INSERT INTO byr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Sara yawɨꞌna yaka sarevɨ sai aꞌmwe gamɨre naangerɨ dinaaya damaaꞌdɨvɨsaraavɨ jaka wɨdɨna kyaꞌ sare sara pwaidaaꞌnyɨ pwaidaaꞌnyɨ gamɨnyawɨnna bɨna. Aꞌmwe pwaidaaꞌnyɨ sɨnnawɨ wɨlaabɨna kyaꞌ maremwaaidei yɨdaanganna ‘Nɨmɨre naangerɨ dinaaya gara gare gwarɨkaigɨnaka?’ ");
INSERT INTO byr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yɨdaanganna kyaꞌ sai wɨdɨna ‘(100) Waanɨ aadɨretɨ kwadɨka naanga welivanatainakengɨra.’ Wɨdɨna kyaꞌ maremwaaidei wɨdɨna ‘Gɨmɨre dinaaya dazaꞌne pɨkarɨyɨkwiaꞌ maaraꞌgɨzɨ sarevɨ walamwaaina yaꞌgɨzɨ yune (50) pivɨtiyaꞌna yarai jɨthaka! Nabaai nɨmɨnyɨna nayaa sara jawɨka!’ ");
INSERT INTO byr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nabaai dɨvidaaꞌnyɨ aꞌmwe pwai biꞌmaꞌna yɨna kyaꞌ sahwai yɨdaanganna ‘Gɨmɨre dinaaya gara garengaka?’ Sara wɨdɨna kyaꞌ sai wɨdɨna ‘Gɨlya naanga (100) waanɨ aadɨretɨ witɨyangɨra.’ Wɨdɨna kyaꞌ sai wɨdɨna ‘Gɨmɨre dinaayaꞌna pɨkarɨyɨkwia daꞌ maaraꞌgɨzɨ yune (80) eitiyaꞌna jɨthawakya!’ Sana sana yɨna. ");
INSERT INTO byr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Sana sana yɨna kyaꞌ naangei sareꞌ yawɨranganna yaka maremwaala kayaaꞌnanya kukebwi yaka kɨrɨꞌ dazai aꞌmwe sɨduta yawɨꞌnɨkeibɨꞌ yade sabwineꞌna yɨ sahwarɨ wɨdɨna ‘Gɨmɨ saigɨnyɨ gaimwannyaꞌneigɨ sɨduꞌnakeigɨne!’ Aꞌmwe naangei sara yɨna. Sareꞌna dareꞌnanyɨ. Kumɨregaasaraavɨna aꞌmwe Kwaaka dathavakɨyabwinera kumɨre wawɨnya yabwina dɨragɨnya yadɨvɨsare. Sara yadɨvɨꞌ aꞌmwe baakevɨyabwineraavɨ wavɨlaꞌdɨvɨsare. ");
INSERT INTO byr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nabaai nɨmɨ sarɨmɨnyɨ yɨhɨthɨvanɨge. Aꞌmwera nɨgwia maaꞌdɨvɨꞌ dazajɨ kayaaꞌnanya dala nabinabinyanna marayadɨvɨsare. Sare kɨrɨꞌ sarɨmɨ daza maarapɨjɨ dazajɨ nawɨꞌnyanna kamarayapɨjɨ sarɨnnya sɨryaꞌmwe yɨmaꞌnɨpɨꞌdeꞌnanyɨ. ‘Dɨvi nɨgwia lɨmwagasagaaꞌ mena kiwawojɨ yɨ anga yuyagaaꞌ yuyagaaꞌ nayaa kwaamuꞌ mwaalyaꞌnebanna Gotɨyai nemaramwaaihana!’ dapi sara jideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Aꞌmwe kwai gɨlyɨvɨta wana maalɨkeꞌna nayaa padaꞌgainemwaaina yajai yɨ sai gɨlyɨvɨta naanga kɨrɨvɨnajɨ nayaa padaꞌgainemwaaladelyɨ. Nabaai aꞌmwei gɨlyɨvɨta wana maalɨkeꞌna kayaaꞌna yɨna, yɨdaꞌna myajai yɨ sai gɨlyɨvɨta naanga kɨrɨvɨna kayaaꞌna yɨna, yɨdaꞌna mi yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Sarevɨdaaꞌnyɨ sarɨmɨ Kwaaka davakɨya nɨgwiajɨ kayaaꞌna marayadɨvɨta sanna mavadaꞌgainemwaalyɨ yɨpɨjaꞌ nebula nawɨꞌnya maremwaala yaꞌneihɨrɨ aaihwai yɨhɨzaavadeihɨlaka! ");
INSERT INTO byr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nabaai sarɨmɨ pware gɨlyɨvɨsangɨ nayaa mamaremwaalyɨ yɨpɨjaꞌ yɨ nebula nawɨꞌnya sarɨnnyannanyaꞌ Gotɨyai dɨragɨnna dakeꞌ yɨhɨzaavadeꞌ daaka! ");
INSERT INTO byr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Angevɨ wɨdaayadei maremwaala yuyaraare wawɨnyawaai lɨmwagaradei aane pwai kwai mɨka. Aawa. Sareꞌ dareꞌnesɨ. Maremwaala pwarɨna sɨmɨlɨka wimwaaina yojɨ pwarɨna tewaanna wimaꞌnyɨna yadei dɨngaka! Pwarɨ lɨmwagaꞌna yada pwarɨ buleꞌna wɨjaavɨna yadei dɨngaka! Sarɨmɨ Gotɨyarɨnajɨ gɨlyɨvɨsangɨnajɨ saburaarɨna wawɨnya wɨdaayɨpɨneihi mɨka!” ");
INSERT INTO byr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Perɨzɨyara nɨgwianna tewaanya wimaꞌnadere. Sare sara Jizaazai dadaaꞌnyɨya yagaala yuya dazangɨ kadɨka wɨꞌnevera gamɨnyɨ bɨraiyagaala wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sara yɨna yadaapi sai wɨdɨna “Sarɨmɨ yawɨꞌna ‘Aꞌmwera nenganapɨjɨ nemɨnyɨna yawɨpɨka! “Aꞌmwe yɨdaꞌmaraangerera.” ’ Yawɨꞌna yadɨvɨꞌ yɨvanɨgasaihɨlyɨra. Sara yadɨvɨta sabwina sarɨmɨre sɨmunyaburɨ Gotɨyai mena yɨhyawɨrangamanɨkelyɨ. Aꞌmwera yɨlaaya yadɨvɨsanna yɨ Gotɨyare tɨnnyarɨ gɨrɨkitaꞌnanya kayaaꞌnanyabulyɨra. ");
INSERT INTO byr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mozɨzare yagaala Kɨwɨnyavɨnesɨ pɨropetɨyaraavɨre yagaalyasɨ yune Jonɨmɨregaaꞌna waꞌmwaꞌdɨkengɨ. Kɨrɨꞌ yune Jonɨmɨregaaꞌdaasɨ yaka dahaakɨgaasɨ Gotɨyai aꞌmweraavɨ maremwaaidevɨne yagaala tewaanyaꞌ anga yuyabanya yɨmaꞌnɨvanaabɨkesɨ. Nabaai aꞌmwe yuyara maremwaaide dazavɨ wɨlamwaalyaꞌna dɨragɨnya kuna yɨvanɨgasare. ");
INSERT INTO byr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sɨgunyavasɨ Kwaakevasɨ yɨwawodeꞌ wawɨnya maalɨkesɨ. Kɨrɨꞌ kɨwɨnyavɨya maalɨka pimagɨnyamɨlɨꞌ saꞌ yɨwawodeꞌ wawɨnya naangesɨ. Yunenna yɨmaꞌnadengɨ. ");
INSERT INTO byr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Gazaizai gannya aꞌmwevɨ wɨdaasada aꞌmwe mudɨka pɨrɨvɨ maarajai baꞌdalavalɨmwangebwi yɨna. Ata lɨmwangebwi yɨna. Nabaai aꞌmwei aꞌmwe pɨrɨvɨ sɨnnawɨ gannya wasɨꞌnajavɨ kwala maarajai sai baꞌdalavalɨmwangebwi yɨna. ");
INSERT INTO byr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Aꞌmwe pwai gɨlyɨvɨkɨravɨnakei mwaalɨna yakelyɨ. Yuyagaaꞌ baazɨꞌmaꞌnya taaihɨja tewaanyanna tewaanyanna, baazɨꞌmaꞌnya wayaakejɨ wakadelyɨ. Sara yada yuya yɨrɨkerɨkaavɨ tɨka wapaa tewaanyanna tewaanyanna yovɨgalamaaꞌdelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Gamɨre angevɨne tɨkuryaba aꞌmwe gɨlyɨvɨꞌmaaya pwarɨ walawɨmwaaihɨna yesalyɨ. Gamɨnne yayaꞌ Lazaarazai woꞌnɨkei gamɨre kɨlaakejɨkɨ yunebanna waꞌwaaya waꞌdɨsɨyai. ");
INSERT INTO byr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","‘Aꞌmwe gɨlyɨvɨkɨravɨnaka dazare yɨꞌbɨnya wapewakyaba wapaaya tɨrɨdɨrɨnya yɨꞌbɨnyavɨ dalaangewɨ bwalaꞌdawadaaꞌnyɨya maranɨdeinya. Sa maranadɨ munya nyɨnadeinya,’ yawɨꞌda nabaai jɨlɨkera wɨlaabɨna yadɨvɨꞌ gamɨre waꞌwaayangɨ kumɨre taalɨsajɨ yanyɨna. ");
INSERT INTO byr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Dɨvi aꞌmwe gɨlyɨvɨꞌmaaya dazai balɨna yɨna kyaꞌ sareꞌ ejelɨyara maarɨna yɨna yeva makuna yevera Evɨraamɨjɨ yeꞌmwannamwaihaawɨna. Nabaai aꞌmwe gɨlyɨvɨkɨravɨnaka sai kwalyɨ balɨna yɨna kyaꞌ lɨkirakɨna. ");
INSERT INTO byr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Sai Dɨkevɨ mwaalaka daanga naanga wɨvɨnyɨna. Sara wɨvɨdaaꞌnyɨ munyaba kekina tɨnna maranganna. Evɨraamɨ saamɨnya menyaba mwaaidɨꞌnyɨ Lazaarazai sahwalyɨ yeꞌmwannemwaaidɨꞌnyɨ tɨnna wanganna. ");
INSERT INTO byr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tɨnna wanganna yaka gɨlyɨvɨkɨravɨnakei jaka danganna ‘Nɨmwai, Ne Evɨraamɨ, dɨka davɨ daanga naanga kayaaꞌna nyɨvɨmanɨkeꞌna nɨmɨnyɨna kale kagyozɨ “Gamɨre aꞌjawɨnyai aalyavɨ bwalapaihojɨ aꞌmwere taalɨsarɨ kudathɨwagaavojɨ yɨrɨla maalɨꞌna wɨdana!” daꞌgɨzɨ Lazaarazarɨ dɨmaryasaama!’ ");
INSERT INTO byr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Sara danganna kyaꞌ kɨrɨꞌ Evɨraamɨ wɨdɨna ‘Kaimɨraayaigɨ, dahaaꞌ gɨmɨ pɨnɨnna jawɨka! Sɨnnawɨ gɨmɨ gaala mwaalagɨnegaaꞌ gɨlyɨvɨta yuya tewaanya maaragɨ. Nabaai Lazaarazai yuya kayaaꞌnanya maarakelyɨ. Kɨrɨꞌ dahaaꞌ anga dava gamɨre munyɨꞌ tewaanna waꞌmanɨka. Sara yadaaꞌnyɨ gɨmɨ daanga kayaaꞌnanyaꞌ maaꞌmanɨgɨ. ");
INSERT INTO byr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nabaai pɨnɨjɨyavɨ nemɨnyɨ tɨnna dava sarɨmɨnyɨjɨ nemɨnyɨjɨ Gotɨyai sitɨkulala naanga pɨrɨꞌ wakakesɨ. Sarevɨna aꞌmwe dava mwaaihasara sitɨkulala savɨ mavɨralavaabyapɨjɨ sarɨmɨnyawɨnna wɨyaꞌna wɨpɨnera mɨꞌ. Nabaai aꞌmwe kengimagɨ mwaaihasara sitɨkulalyavɨ mavɨraalayapɨjɨ nemɨnyawɨnna wɨlaabɨpɨnera mɨꞌ.’ ");
INSERT INTO byr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Wɨdɨna kyaꞌ sai wɨdɨna ‘Sarevɨdaaꞌnyɨ Nɨmwai, gɨmɨnyɨ githaangamanɨge. Nɨmaamaangere angevɨna Lazaarazarɨ dɨmaryaasa! ");
INSERT INTO byr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Sareꞌ dareꞌnesɨ. Nɨmɨ atɨla nyɨdaaꞌnyɨgwaaravaava mwaaihasara kɨnɨnnakeinyɨ. “Saraayawɨnna Lazaarazai wawojɨ yagaala jalɨkurakɨna yana! Nabaai daanga naanga maaryaꞌne davanna sara kwarajɨ nabɨpɨdɨka!” dena githaangamanɨge. Sɨmunya mudɨkebwi yawɨramaapɨjaꞌ daanga wɨvɨnadera mɨka!’ ");
INSERT INTO byr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Wɨdɨna kyaꞌ Evɨraamɨ wɨdɨna ‘Mozɨzare yagaalyajɨ Gotɨyarɨ wɨꞌnawɨjɨwakyaasaraavɨrejɨ warɨka. Sare sangɨ kadɨka wɨꞌnɨpɨka!’ ");
INSERT INTO byr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wɨdɨna kyaꞌ sai wɨdɨna ‘Aawaawa, Nɨmwai Evɨraamɨ, saꞌ yɨnɨga wiꞌnanneꞌ mɨka! Aawa. Aꞌmwe bainɨka pwai bainɨkeraayawɨ ayɨna dɨkaavojɨ kumɨnyawɨnna kwawojɨ sahwara sɨmunya mudɨkebwina yawɨramaaꞌna yɨpɨꞌderera.’ ");
INSERT INTO byr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Wɨdɨna kyaꞌ kɨrɨꞌ wɨdɨna ‘Nabaai Mozɨzare yagaalyangɨjɨ wɨjaata pɨropetɨyaraavɨrengɨjɨ kadɨka muꞌnyɨ yɨpɨjaꞌ yɨ nabaai aꞌmwe pwai bainɨkeraayawɨ ayɨna dɨkaavajaꞌna nabaai saꞌ kɨrɨꞌnajɨ dɨragɨnna lɨmwabɨꞌdera mɨka!’ ” ");
INSERT INTO byr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sagaaꞌ sahwai gamɨre mɨdɨdɨvɨsaraavɨ wɨdɨna “Dala pɨnɨnna pɨnɨnnanya sabura aꞌmweraavɨ kayaaꞌnanyabwina walapapalakyaꞌna yɨmaꞌnaabathengɨ. Kɨrɨꞌ aꞌmwe walapapalakyabwi sasara wɨjaavaja sarɨna weꞌ, mala nayaa yɨwannana! ");
INSERT INTO byr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nabaai kaimɨraaya maalɨkemɨlɨkaavɨdaaꞌnya pɨmɨlɨkɨ kayaaꞌnanyabwina walapapalakadelyɨ. Yɨ sahwai sara kayaaꞌna myɨ yojɨyagaaꞌ sɨla naanga lɨlɨꞌnɨka pwai gamɨre tɨlɨnnyavɨ maryegipwɨyapɨjɨ saalaalyavɨ kewɨnɨ maralɨvarabɨꞌdeꞌ yɨ gamɨnyɨna tewaanyasɨra. Pɨmɨlɨkɨ kayaaꞌnanyaburɨ marulawakajarɨ Gotɨyai kayaaꞌna yadeꞌna yɨ gamɨnyɨna kayaaꞌnanaangesɨ. ");
INSERT INTO byr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Sarɨmɨ sahwaihɨrɨna mala nayaa jɨwannyɨla! Gɨmɨnyɨ jɨthaaꞌjɨhwaai kayaaꞌnanyabwi kagyozɨ sarɨ maanga duthatheigɨnyɨ. Nabaai sai mudɨkebwi kyawɨramaarojɨ gamɨre kayaaꞌnanyabwi dɨmakwaasa! ");
INSERT INTO byr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nabaai yɨrɨka gave pɨgaaꞌ pɨrɨkɨ sai kayaaꞌnanyabwi gɨmɨnyɨ ata purɨdaaꞌnyɨ pɨgasaaina kagyozɨ nabaai ata purɨdaaꞌnyɨ pɨgasaaina gɨmɨnyawɨnna ayɨna bozɨ wɨdɨna ‘Kale nyɨwaka! Mudɨkebwi yawɨramaarɨma!’ Sara kagɨthozɨ gamɨre kayaaꞌnanyabwi dɨmakwaasa!” ");
INSERT INTO byr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Naangei maryaasadera apozelɨyara Naangerɨ wɨdɨna “Pwaraavɨre kayaaꞌnanyabwi marasɨꞌnyaꞌneburɨna gɨmɨnyɨna nemɨre lɨmwangebwi naanga jahɨriwana! Nemɨ yɨnɨga wiꞌna yaanneina daaka!” ");
INSERT INTO byr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sara wɨdɨna kyeꞌ Naangei wɨdɨna “Sarɨmɨre lɨmwangebwi aranyavɨre sɨla maalɨkemɨlɨꞌbɨsabwi gɨryaꞌnebwi warajɨ kwajɨ yɨta mɨjamaanga daꞌ dara duzideihɨlyɨ ‘Gɨmɨre pwipula lɨkalaaꞌnaꞌgɨzɨ saalaalyavɨ ayɨna dɨthavaawa!’ Yɨ sara kudapɨjɨ sarɨmɨre yagaalyavɨ yɨhuꞌnojɨ kihɨmɨdɨnadɨka! ");
INSERT INTO byr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nabaai aꞌmwe sarɨmɨnyɨdaaꞌnya pwai yaasɨwaꞌwawɨnya pwai kɨnɨnnakei mwaalajai gamɨre wawɨnyai kwaaka budawakɨwodei dɨngaka? Sipɨzipɨyarajɨ maremwaaidei dɨngaka? Sare sai dɨvidaaꞌnyɨ wawɨnyavɨdaaꞌnyɨ ayɨna bɨna kyojɨ maremwaalyai sahwarɨ dara wɨdathei daaka! ‘Yɨmeꞌnyaꞌbɨꞌ kaanya baꞌgɨzɨ bamwaalaꞌgɨzɨ tɨka munne dɨnana!’ Sara wɨdathei daaka! ");
INSERT INTO byr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aawa. Sai wɨdɨna yadelyɨ ‘Munnaanyasɨ marilaꞌgɨzɨ nɨmɨnne wapaaya jovɨrawakya! Sara yaꞌgɨzɨ nɨmɨnne wapaaya lɨvadɨꞌgwalaꞌgɨzɨ dɨmakulaama! Tɨka wapaajɨ waainɨyasɨ mena kanaꞌmujɨ dɨvidaaꞌnyɨ gɨmɨ tɨka wapaajɨ waainɨyasɨ dɨnadeigɨnyɨ.’ ");
INSERT INTO byr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yaasɨwaꞌwawɨnya dazai gamɨre yagaalyaꞌ nayaa yadeꞌna aꞌmwe naanga sai yɨlaaya yada ‘Kaimala! Su!’ wɨdadei dɨngaka! Aawa. ");
INSERT INTO byr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Sarevɨdaaꞌnyɨ nabaai sarɨmɨ kwaihi Gotɨyai yɨhɨthathengɨ sara yapɨjɨ nayaa dara dɨzi! ‘Nemɨ yaasɨwaꞌwawɨnya waryaanyainera. Wawɨnya sara yɨwo sa, yɨ sa yuna nemɨre wawɨnyaꞌna yɨwongɨra. Wawɨnya kwaala myɨwo.’ ” ");
INSERT INTO byr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jizaazai anga Jeruzaalemɨnei woda anga Samerɨyanajɨ anga Galɨlinajɨ tɨnna yaareba wɨna. ");
INSERT INTO byr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wɨna yada anga pɨba yɨꞌmavaawɨna yɨna yadaaꞌnyɨ aꞌmwe samatanaka atɨraalyara tutaanyavɨ bavɨramaaꞌna yeve kwara menyaba sangirɨꞌ daavɨna yeva ");
INSERT INTO byr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","jaka dɨragɨnna wɨdɨna “Jizaazai, aꞌmwe naangeigɨ, nemɨnyɨna kaleꞌna dɨnegaimwana!” ");
INSERT INTO byr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jaka sara wɨdɨna kyeꞌ sai sahwaraavɨ tɨnna wanganna yɨna yaka wɨdɨna “Pɨrizɨyara Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨsara ‘Tewaanyaihɨlyɨra,’ wɨjaꞌneraayawɨnna sarɨmɨre kɨlaakejɨꞌ makwopɨjɨ duzɨwainaawila!” Sara kudaasaꞌ sahwara kaanna yɨkuna yɨna yeva yadaapi kumɨre kɨlaakejɨꞌ tewaanya yɨmaꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sarevɨ nabaai sahwaraavɨ tɨnnyabadaaꞌnya aꞌmwe pwai gannya kɨlaakejɨꞌ tewaanya yɨmaꞌnɨwakejɨkɨ tɨnna yennaka sai ayɨna kaanna bɨna. Sara yake sai jaka naanga dada Gotɨyarɨne yayaꞌ byaannakeꞌ munyaba makina. ");
INSERT INTO byr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Makina yada Jizaazare sɨvigɨꞌnyɨryawɨ yarai walarutaꞌnyɨna yaka “Kaimala! Su!” wɨdɨna. Aꞌmwe dazai Juyai mɨka. Sahwai anga Samerɨya mwaalyai. ");
INSERT INTO byr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Wɨdɨna kyaꞌ Jizaazai yagaala dɨna “Nɨmɨ yawɨꞌmweꞌ ‘Aꞌmwe atɨraalyara tewaanya dahayɨmaꞌnɨwaava.’ Kɨrɨꞌ aꞌmwe ata purɨdaaꞌnyɨ daraai daraalyara pwara gazɨ mwaaihava! ");
INSERT INTO byr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ayɨna bozɨ Gotɨyarɨne yayaꞌ munyaba makɨladei aꞌmwei pwai mɨka! Aꞌmwe anga pimagɨdaaꞌnya dazai yune gave pwainanyai dɨngaka!” ");
INSERT INTO byr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nabaai sai wɨdɨna “Daavaꞌgɨzɨ kaanna dɨwona! Nɨmɨnyɨ dɨragɨnna yawɨralɨmwangebwi tewaanya ayɨna gyavadaꞌgaimwaka.” ");
INSERT INTO byr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pɨgaaꞌ Perɨzɨyara sahwarɨ yɨdaanganna “Gotɨyai aꞌmweraavɨ maremwaaladeꞌ gathɨngaaꞌ biꞌmavadevaka?” Sara yɨdaanganna kyeꞌ sahwai jaꞌnawɨdɨna “Gotɨyai aꞌmweraavɨ maremwaaladeꞌ bathehaaꞌna aꞌmwera aꞌmwemɨlɨka tɨnnyarajɨ baihanaꞌdɨvɨsara mɨka. ");
INSERT INTO byr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Sahwara dara dadɨvɨsara mɨꞌ! ‘Yɨthaa! Dava dahawarɨka! Aagaiba dahawarɨka!’ Yɨthaanyi! Sareꞌ dareꞌnesɨ. Gotɨyai aꞌmweraavɨ maremwaaladeꞌ sarɨmɨnyɨ kusawɨ mena yɨhɨmwaalɨka!” (Gamɨ sahwarɨna “Mena yɨhɨmwaalɨka!” wɨdɨna yaꞌ.) ");
INSERT INTO byr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sagaaꞌ gamɨre wɨmɨdɨdɨvɨsaraavɨ wɨdɨna “Dɨvi pɨgaaꞌ yɨmaꞌnajahaaꞌ Aꞌmweraavɨne Kaimɨraayare yɨrɨka pɨrɨꞌ tɨnna wanganyaꞌneihi sarɨmɨre sɨmunyaꞌ tewaanna kuna yɨhɨvuꞌnadeihɨlyɨ. Kɨrɨꞌ sarɨmɨ tɨnna danganyideihi mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nabaai yɨhɨthɨpɨꞌdesɨ. Yɨthaanyi, aagimagɨ mwaalɨka! Pwara yɨhɨthɨpɨꞌdesɨ. Yɨthaanyi, dava mwaalɨka! Kɨrɨꞌ sarɨmɨ mupɨnera! Sahwaraavɨ mamɨjamakupɨnera! ");
INSERT INTO byr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sasarevɨ dareꞌnesɨ. Sɨgunyavɨ yuneba, pimagɨdaaꞌnyɨ sɨmagɨnna yɨnamɨraata yadevaaibɨꞌ Aꞌmweraavɨne Kaimɨraayai biꞌmavadehaaꞌ yuyara wangabɨꞌdelyɨra. ");
INSERT INTO byr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kɨrɨꞌ sahwai taanga kwalaalya maarojɨyarɨ aꞌmwe dahaasa dathara buleꞌna wɨjaavɨpɨꞌdelyɨra. ");
INSERT INTO byr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nowaare yɨrɨkeryaavɨ yetabaaibɨꞌ Aꞌmweraavɨne Kaimɨraayaregaaꞌ yɨmaꞌnade yɨrɨkeryaavɨ yɨ sara yɨpɨꞌdere. ");
INSERT INTO byr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tɨka munnejɨ nɨwainadaapi, waainɨyajɨ nadaapi, kwala maꞌdaapi, kwala maꞌnadaapi yune Nowaai sɨpɨyavɨ wɨlaka sagaaꞌna. Yɨthaanyi, sagaaꞌ burɨka naangeꞌ bwalaꞌna yaka aalɨbunya naangeꞌ padɨꞌnyɨna yakegaaꞌ yuya aꞌmweraavɨ yuna kayaaka yɨgalakɨna. ");
INSERT INTO byr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nabaai Lotɨmɨre yɨrɨkeryaavɨ avaaina sasare yesare. Tɨka munne nyemwaaina, waainɨyajɨ nadaapi, gɨlyɨvɨsa mubɨna, ‘Gɨlyɨvɨsa pwara mubya neyɨpɨka!’ yawɨꞌdɨvɨꞌ mubɨna, wawɨnyajɨ yɨna, angejɨ madɨna. ");
INSERT INTO byr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kɨrɨꞌ anga Sothomɨ Lotɨ yagalyaꞌmavaka kaanna wɨna yaakegaaꞌ nabaai yɨrɨka yune dazahɨgaasarɨkɨ sɨgunyavɨdaaꞌnyɨ burɨkeꞌbɨꞌ dɨkesɨ sɨla dɨꞌnakesɨ anga saburɨna wasɨꞌnaabɨna kyaꞌ yuya aꞌmweraavɨjɨ aꞌmwengɨjɨ yuna kayaaka baihɨrakɨna. ");
INSERT INTO byr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yɨ avaaina sasare sahɨbaaibɨꞌ Aꞌmweraavɨne Kaimɨraayai kuꞌmaayaba yɨmaꞌnaabathe yɨrɨkerɨkɨ yɨmaꞌnadesɨ. ");
INSERT INTO byr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Yɨrɨka dazarɨkɨ aꞌmwe pwai gannya angevɨ munyaba yɨlamwaalojɨ, nabaai angevɨ kusawɨ gamɨre gɨlyɨvɨsa waꞌdoriya gɨlyɨvɨsanna angevɨ nulamaaradɨka! Nabaai sasare sahɨbaaibɨꞌ aꞌmwe pwai wawɨnyawɨ mwaalojɨyai ayɨna nawodɨka! ");
INSERT INTO byr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotɨmɨre aꞌmweꞌ gɨlyɨvɨsanna tɨgɨnyɨmaꞌnya yɨwiaakevɨna sarɨmɨ sɨmunya nayaa jawɨrila! Lɨkaanya jɨla! ");
INSERT INTO byr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aꞌmwe gazaizai gannya kɨlaakejɨkɨne mwaalyabwina yɨlaaya yawɨꞌda lɨmwagarajai yɨ gamɨre gaalyabwi yɨwawodevulyɨ. Sareꞌ kɨrɨꞌ, nabaai aꞌmwe gazaizai gannya mwaalyabwi yagalyaꞌmavojɨyai yɨ gamɨre gaalyabwi tewaanna nayaa wɨvadaihasamaaradesɨ. ");
INSERT INTO byr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nɨmɨ yɨhɨthɨvanɨge. Sawɨta dazarɨkɨ aꞌmwe pwaraai yɨꞌbɨnya pɨrɨvɨ se warɨna yadakɨlyɨ Gotɨyai pwarɨ maarɨna yojɨ pwarɨ saba yagalyaꞌmaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aꞌmwe pɨrɨwaai witɨzɨla lɨlɨka yɨmaꞌnyaꞌne yadaakɨlyɨyagaaꞌ Gotɨyai pɨrɨvɨ maarɨna yojɨ pɨrɨvɨ saba yagalyaꞌmaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Aꞌmwe pwaraai wawɨnyawɨ mwaalɨna yadakɨlyɨ Gotɨyai pwarɨ maarɨna yojɨ pwarɨ saba yagalyaꞌmaꞌna.” ");
INSERT INTO byr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yagaala dazaꞌ kadɨka wɨꞌneva sahwara wɨdɨna, “Naangeigɨ, nedɨwaanya dazasaꞌ gawɨ yɨmaꞌnadeꞌnevaka?” Sara wɨdɨna kyeꞌ sai wɨdɨna “Bainɨkeraavɨre kɨlaakejɨꞌ warɨkeba yune dazahɨbeva yuta kaamyaakera kwala biꞌbwaꞌdɨvɨsabera.” ");
INSERT INTO byr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sagaaꞌ yuyagaaꞌna Gotɨyarɨna yɨdaangabɨꞌdeꞌ, maaꞌna nyunadɨꞌdeꞌna Jizaazai keꞌbaꞌna dara wɨjɨwaakɨna ");
INSERT INTO byr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Anga naanga pɨba yawɨbwaꞌde pwai mwaalɨna. Yawɨbwaꞌde dazai Gotɨyarɨna myawɨri yada nabaai aꞌmwe kwaraavɨnajɨ sɨmunya kwalaalya myawɨryadei. ");
INSERT INTO byr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nabaai aꞌmwe pɨrɨꞌ yaanyɨwaakeꞌ anga naanga dazaba mwaalɨna. Yuyagaaꞌ yawɨbwaꞌde dazaryawɨnna bɨbya yɨbainadaaꞌdehaaꞌ wɨdadesɨ ‘Nɨmɨre yɨkamaangei kayaaka nyɨgalakadeꞌnanyɨ. Sahwarɨ gɨmɨ kotɨyavɨ nayaa dɨnyɨgaimwadeꞌnanyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sara wɨdɨwɨja yada sɨnnawɨ sagaaꞌ yawɨbwaꞌde dazai sahɨrɨvɨna kotɨyavɨ gaimwangeꞌna ‘Aala,’ yawɨꞌna. Sara yawɨꞌna yaka kɨrɨꞌ dɨvi sai gannya sɨmunyavɨ dara yawɨꞌna ‘Nɨmɨ Gotɨyarɨna lɨka mivanɨgeinyɨ. Nabaai aꞌmwe kwaraavɨnajɨ sɨmunya yawɨrɨkwaasa mivanɨgeinyɨ. ");
INSERT INTO byr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Kɨrɨꞌ aꞌmwe dathava dathaꞌ yaanyɨwaaka dathaꞌ nɨmɨnyɨ taanga nyɨjaavadeinyɨra. Yuyagaaꞌ yuyagaaꞌ bɨbya yɨbainadaꞌdavadaawori dɨvi nɨmɨre kɨlaakejɨꞌ yuna maaꞌna nanyɨmaꞌnadɨka!’ daka gamɨre kotɨyaꞌna gaimwanna wina yakelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Naangei sara wɨdɨna yaka dara wɨdɨna “Yawɨbwaꞌde kayaaꞌnanya dazare yagaalyaꞌ nayaa jawɨrila! ");
INSERT INTO byr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yawɨbwaꞌde kayaaꞌnanyai kave kave yawɨbwarakelyɨ. Gotɨyai avaalyai daaka! Gotɨyare dahɨlakakera yuya yɨrɨkerɨkaavɨjɨ yuya sawɨsarɨkaavɨjɨ sahwarɨ yɨdaangadɨvɨsaraavɨ kotɨyaꞌna yarai gaimwanna mwi yadei daaka! Sahwaraavɨ kave kave gaimwanna mwi yadei daaka! Aawa. ");
INSERT INTO byr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yɨhɨthɨvanɨge. Sai kotɨyaꞌna yarai wɨgaimwagathelyɨ. Sareꞌ kɨrɨꞌ dɨvi Aꞌmweraavɨne Kaimɨraayai bathehaaꞌ dazagaasagaaꞌ aꞌmwe Kwaakevakɨyaraavɨ tɨnna wanganajaꞌ dɨragɨnna lɨmwadɨvɨꞌ dɨngaka!” wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aꞌmwe pwara yayaꞌ yune kumɨ saraavɨneꞌna makinadɨvɨꞌ “Nemɨ aꞌmwe yɨdaꞌmaraangeinera. Aꞌmwe pwara yuna kayaaꞌnanaangerera,” dadɨvɨsaraavɨ keꞌbaꞌna dara wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Aꞌmwe pwaraai Gotɨyarɨ wɨjaꞌneraai Gotɨyare Angevɨna kaanna wɨlaawɨna. Pwai Perɨzɨyai. Nabaai pwai aꞌmwe taakɨzɨya maaꞌdelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Perɨzɨyai dazai daaꞌda yune gannya sɨmunyavɨna Gotɨyarɨna dara dɨna ‘Gotɨyaigɨ, nɨmɨ aꞌmwe pwarabɨtainyɨ mɨka! Sarevɨdaaꞌnyɨ gɨmɨnyɨna “Su! Su!” gɨthɨwa. Pwara kwaasɨ yɨna yadɨvɨꞌ kuka yɨna yadɨvɨsare. Nayaa yɨdaꞌmaraangebwi myadɨvɨsare. Pwaraavɨrengɨ ata lɨmwadɨvɨsare. Nabaai nɨmɨ aꞌmwe taakɨzɨya maaꞌde dazaibɨtainyɨ mɨka. Kɨrɨꞌ nɨmɨ aawa. ");
INSERT INTO byr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yuya wikɨyarɨkaavɨ yɨrɨka pɨrɨkaarɨna tɨka wapaaya kɨmaakɨya dakadɨnyainyɨ. Nabaai yuya maaꞌdɨnya ata yuyɨraai jaapaidɨ pimagɨnyavaaꞌ gɨmɨnyɨ gɨzaavadɨnyainyɨ.’ ");
INSERT INTO byr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Sara wɨdɨna kyaꞌ kɨrɨꞌ aꞌmwe taakɨzɨya maaꞌdei menya saamɨnya keiba daavɨna yaka Sɨgunyavɨna kekina mamaranganyaꞌ. Aawa. Sai gamɨre kayaaꞌnanyabwina kale wiada gannya kɨhɨsaba mala tannyɨna yaka dɨna ‘Gotɨyaigɨ, nɨmɨ aꞌmwe kayaaꞌna yadɨnyainyɨ. Sareinyɨna kaleꞌna dɨnyɨgaimwana! Nɨmɨnyɨna gɨmɨre sɨnna tɨka wɨdaꞌdevwi dɨnyɨmarasɨꞌna!’ ");
INSERT INTO byr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Sarɨmɨnyɨ yɨhɨthɨvanɨge. Aꞌmwe taakɨzɨya maaꞌde dazai, Gotɨyai gamɨre kayaaꞌnanyanna marasɨꞌnaka ‘Tewaanyaigɨnyɨra,’ wɨdakei sarei gannya angevɨna ayɨna wawakelyɨ. Kɨrɨꞌ nabaai aꞌmwe pwai aawa. Aꞌmwei yayaꞌ yune gamɨnneꞌna munyaba makɨlajai, Gotɨyai dalaangewɨ marulawakadelyɨ. Kɨrɨꞌ aꞌmwei gamɨnyɨne yayaꞌ munyaba mamakinyɨ yajai, yɨ Gotɨyai gamɨnyɨne yayaꞌ munyaba makɨladelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kaimɨraaya maalɨkemɨlɨkaavɨjɨ gamɨnyawɨnna makabɨna yɨna. Sahɨyura yawɨꞌna “Tewaanyaꞌna asaꞌ dathɨwagatheꞌna gamɨnyawɨnna makwawaana!” deva makabɨna yadaapi kɨrɨꞌ gamɨre mɨdɨdɨvɨsara dazavɨ tɨnna wanganna yeva sahɨyuraavɨ maanga wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Maanga wɨdɨna yadaapi Jizaazai kaimɨraayamɨlɨkaavɨ gamɨnyabanna jaka jɨvwarɨjɨmaaꞌnyɨna yaka wɨdɨna “Kaimɨraayamɨlɨka yune nɨmɨnyawɨnna bɨpɨka! Sarɨmɨ magaladalɨmwabɨnera! Sareꞌ dareꞌnesɨ. Gotɨyai aꞌmweraavɨ maremwaaideꞌ, yɨ sasaremɨlɨkaavɨnesɨ. ");
INSERT INTO byr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nebulyaꞌna yɨhɨthɨvanɨge. Pwai kwai Gotɨyai aꞌmweraavɨ maremwaaideꞌ kaimɨraaya maalɨkemɨlɨꞌbɨꞌ mamaaryajai, yɨ sai kusawɨ yɨnɨga wiꞌna wɨladei mɨka. Arɨkewɨ.” ");
INSERT INTO byr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aꞌmwe naanga pwai gamɨnyɨ yɨdaanganna “Wɨjɨwaakya tewaanyaigɨ, nɨmɨ gara yaꞌmujɨ gaala yuyagaaꞌ yuyagaaꞌ tewaanya mwaalyaꞌneꞌ maarɨdeinyaka?” ");
INSERT INTO byr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yɨdaanganna kyaꞌ Jizaazai wɨdɨna “ ‘Tewaanyaigɨnyɨreva,’ beꞌna nyɨdɨwaana? Tewaanyai, Gotɨyai yune gave sahwainanyalyɨra. Pwara aawa. ");
INSERT INTO byr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kɨwɨnya dɨnɨkevɨ mena yawɨꞌdɨnyaigɨnyɨ. Dara dɨnɨꞌ ‘Aꞌmwe pwaraavɨrengɨ ata malɨmwadɨnna! Aꞌmweraavɨ maramakɨnna! Kuka mamaaꞌdɨnna! Aꞌmwe pwarɨneꞌna kwaasɨ majalɨkurakɨnna! Gɨnnya gɨmaamaangelyɨ gwaangesɨ sawaare yagaalyangɨ nayaa dɨmɨdɨna! Kɨrɨmɨre yayaꞌ dɨmakɨla!’ ” ");
INSERT INTO byr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wɨdɨna kyaꞌ sai wɨdɨna “Kɨgaaꞌ yune kaweꞌnyagaaꞌdaaꞌnyɨ dahaakɨgaasɨ kɨwɨnya yuya dazangɨ mɨdɨmanɨgeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jizaazai yagaala dazaꞌ kadɨka wɨꞌnaka sahwarɨ wɨdɨna “Yune gave pɨnɨnneꞌna kuna gɨmudaasɨvanɨkeigɨnyɨra. Aꞌmwera mubya gipɨꞌdeꞌna gɨmɨre gɨlyɨvɨta yuya duzaama! Nɨgwia maaraꞌgɨzɨ aꞌmwe gɨlyɨvɨꞌmaayaraavɨ gɨmɨre nɨgwia duzaama! Gɨmɨ sasara yɨjaꞌ, Sɨgunyavɨne nawɨꞌnyaange kɨnɨnnakeigɨnyɨra. Sareigɨ dɨnyɨmɨdɨnaama!” ");
INSERT INTO byr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wɨdɨna kyaꞌ dazai yagaala dazaꞌ kadɨka wɨꞌnaka gamɨre sɨmunyai taanga yɨmaꞌnyɨna. Sareꞌ dareꞌnesɨ. Sahwai aꞌmwe gɨlyɨvɨkɨravɨnakei. ");
INSERT INTO byr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Gamɨre sɨmunyai taanga yɨmaꞌnyɨna kyaꞌ Jizaazai sahwarɨ tɨnna wangada wɨdɨna “Aꞌmwe gɨlyɨvɨta kwalaalyajɨyara Gotɨyai maremwaaidevɨ yagɨyagɨ wibɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sareꞌ dareꞌnesɨ. Kaamelɨyaꞌ ‘Langerɨkɨre daibuꞌnyavɨ wɨlɨma!’ dozɨ yajaꞌ sara mi yadesɨ. Sahɨbaaibɨꞌ aꞌmwe gɨlyɨvɨkɨravɨnakei ‘Gotɨyai maremwaaidevɨ wɨlaawɨma!’ dada yagɨyagɨ yɨna yajaꞌ yadei mɨꞌ.” ");
INSERT INTO byr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wɨdɨna kyaꞌ aꞌmwera dazaꞌ kadɨka wɨꞌnevera wɨdɨna “Nabaai sasara yajaꞌ aarɨ wɨvadaihasamaaradelaka? Gaala yuyagaaꞌ yuyagaaꞌ mwaalyaꞌneꞌ maarojɨ mwaaladei aaihwalaka?” ");
INSERT INTO byr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sara wɨdɨna kyeꞌ sai wɨdɨna “Aꞌmwera yuya mi yɨpɨne sangɨ, sa Gotɨyai yɨnɨga wiꞌna yadengɨra.” ");
INSERT INTO byr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Wɨdɨna kyaꞌ Pitai wɨdɨna “Yɨthaa, nemɨre angebanyajɨ gɨlyɨvɨsangɨjɨ mena yagalyaꞌmavoneinera. Sara yona gɨmɨnyɨ gɨmɨdɨdaanyaꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Wɨdɨna kyaꞌ sai kumɨnyɨ wɨdɨna “Nebulyaꞌna yɨhɨthɨvanɨge. Aꞌmwe aane pwai kwai, Gotɨyai maremwaaidevɨna yawɨꞌda angevɨjɨ aꞌmwevɨjɨ gathaaꞌgahwaaravaavɨjɨ ganɨmaangeyorɨjɨ kaimɨraayangɨjɨ yagalyaꞌmavakerɨna, ");
INSERT INTO byr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nabaai dahaasavɨ Gotɨyai kwalaalya sanna mibwaꞌmwagi yadei daaka! Nebulyasɨ. Nabaai sarei dɨvi naanga yɨmaꞌnajahaaꞌ gaala yuyagaaꞌ yuyagaaꞌ mwaalyaꞌneꞌ maaradelyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sagaaꞌ gamɨre atɨraai sɨvɨlɨrɨdaaꞌnyɨ pwaraalyaraavɨ maarɨna yɨna yaka wɨdɨna “Yɨthaanyi, dahaaꞌ Jeruzaalemɨna wimanaabɨho. Sahɨba Aꞌmweraavɨne Kaimɨraayainyɨna Gotɨyai pɨropetɨyaraavɨ kujaaꞌ yagaala yuya sa yɨdayaasangɨ yuna yɨmaꞌnyɨna yadeꞌnanyɨra. ");
INSERT INTO byr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Sareꞌ dareꞌnesɨ. Sahwainyɨ aꞌmwe Anga Naanga Pimagɨnyaraavɨna nyɨmarɨmwangɨpɨꞌdeinyɨra. Sara yapɨjɨ yagaaibɨraizɨkejɨ nyɨdangadɨvɨꞌ yuna kayaaꞌna nyɨgaidɨvɨꞌ nɨmɨre sɨnnyɨkɨ maagwala nyuraꞌmwawakɨpɨꞌdeinyɨra. ");
INSERT INTO byr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Wɨlyabaalyɨ dɨka nyɨlɨꞌbwarapɨjɨ maratamanyɨrɨmupɨꞌdeinyɨra. Balaꞌmuri yɨrɨka daryaai darɨkɨ ayɨna dɨkaavɨdeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Wɨdɨna kyaꞌ yagaala dazaꞌ myawɨrina. Yagaala dazavɨne aaya kaavɨlyaꞌ kumɨnyɨ lɨka yulyaꞌna. Sahwara sɨmunyaꞌ nayaa myawɨri yagaala wɨdaka dazavɨ. ");
INSERT INTO byr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sahwai anga Jeriko aya kɨbanna yɨꞌmaꞌna yaka, yadaaꞌnyɨ tuꞌmaangebaarɨ aꞌmwe pwai tɨbɨnyai walamwaaida aꞌmweraavɨ nɨgwianna jaka wɨdangadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sarevɨ sahwai aꞌmwe kwala bwaꞌnaanyaꞌ yɨkabɨvanɨgaveva, kadɨka wɨꞌnyɨna yaka sai aꞌmwe pwaraavɨ yɨdaanganna “Gathaꞌdara yɨvanɨgaveva?” ");
INSERT INTO byr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yɨdaanganna kyaꞌ jaꞌnawɨdɨna “Jizaazai Naazaretɨ mwaalyai kaanya bɨvanɨkeva.” ");
INSERT INTO byr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Sara wɨdɨna kyeꞌ sai jaka wɨdanganna “Jizaazai, Devitɨmɨ gawaalɨꞌgɨ nɨmɨnyɨna kale gyana!” ");
INSERT INTO byr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jaka wɨdangadaaꞌnyɨ aꞌmwe aaya sɨnnawɨ yɨkwaadɨvɨsara maanga dara wɨdɨna “Maangeꞌ bɨpaina yaꞌgɨzɨ dɨmakuꞌnana!” Kɨrɨꞌ jaka naanga kuna danganna yada wɨdɨwɨja yɨna “Devitɨmɨ gawaalɨꞌgɨ, nɨmɨnyɨ kaleꞌna dɨnyɨgaimwana!” ");
INSERT INTO byr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sara wɨdɨwɨja yɨna yadaaꞌnyɨ Jizaazai bathaaꞌna yɨna yaka saraavɨ dɨragɨnna wɨdɨna “Davanna nɨmɨnyabanna dɨmakabila!” Wɨdɨna kyaꞌ sai mena aya kɨbanna wɨlaabɨna yɨna yaka yadɨꞌnyɨ sai sahwarɨ yɨdaanganna ");
INSERT INTO byr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nɨmɨ gɨmɨnyɨ berɨꞌ gara gideꞌnanaka?” Yɨdaanganna kyaꞌ sai wɨdɨna “Naangeigɨ, ‘Nɨmɨ tɨnnyaꞌ ayɨna wanganɨma!’ dena yawɨꞌmanɨgena.” ");
INSERT INTO byr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Wɨdɨna kyaꞌ Jizaazai wɨdɨna “Gɨmɨre tɨnnyai ayɨna danganna! Gɨnnya dɨragɨnna lɨmwangebwi gɨmɨnyɨ tewaanya gyavadaꞌgaimwaka.” ");
INSERT INTO byr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sara wɨdɨna kyaꞌ jaahwasaꞌbɨꞌ gamɨre tɨnnyai tewaanya yɨmaꞌnyɨna yaka yennyɨna. Sarei Jizaazarɨ mɨdɨnna yɨna yaka Gotɨyarɨne yayaꞌ byaannakeꞌ munyaba makina. Sarevɨ aꞌmwera dazavɨ tɨnna wanganeva Gotɨyarɨne yayaꞌ munyaba makina yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jeriko sawɨnna wɨlaawaka adutaanyavɨ kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Yɨthaa, sagaaꞌ saba aꞌmwe pwai, Sakɨyaazai woꞌnɨkei mwaalɨna. Sai aꞌmwe taakɨzɨya maaꞌdɨvɨsaraavɨ maremwaaide aꞌmwe naangelyɨ. Sare sai nɨgwia kwalaalya kɨnɨnnakelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sahwai “Jizaazai bewai dɨngaka? Yawɨranganɨma!” daka yakelyɨra. Aꞌmwe kwala bwaꞌnaanyaꞌ mwaaidapi Sakɨyaazai sahwai aꞌmwe tuꞌnanyalyɨ. Sare sai gamɨnyɨ tɨnna mwanganyɨna. ");
INSERT INTO byr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sara mwanganyɨ yakegaaꞌ sɨnnawɨ gamɨdaaꞌnyɨ kaanyaveꞌna wɨlaawɨna yɨna yaka “Sahwarɨ tɨnna yɨwarɨma!” yawɨꞌna yaka yɨta mɨgɨlyarɨ keꞌmu yɨꞌnɨgina. Sahwai yawɨꞌna “Sarei tutaanyarɨꞌ darɨkɨ bathei daaka!” yɨladaaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yɨladaaꞌna yaka yemwaaidɨꞌnyɨyɨmagɨnna Jizaazai biꞌmaꞌna yɨna yaka kekina maranganna yaka wɨdɨna “Sakɨyaazai, yɨta sarɨ yarai yagalyaꞌmaꞌna yaꞌgɨzɨ dalaama! Yuna dahaasagaaꞌ nɨmɨ gɨmɨre angevɨ mwaalɨdera.” ");
INSERT INTO byr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sara wɨdɨna kyaꞌ wɨꞌnyɨna yaka yarai walaabɨna yɨna yaka gamɨre sɨmunyaꞌ yɨlaaya yɨna yakegaaꞌ gamɨre angevɨnerɨ kaanna makuna. ");
INSERT INTO byr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nabaai aꞌmwe yuyara dazaꞌ tɨnna wanganeva kɨnɨmyagaala dɨna “Aꞌmwe kayaaꞌna yade pware angevɨ angyɨrɨꞌmaata yɨvanɨkelyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kɨnɨmyagaala sara dɨna kyeꞌ Sakɨyaazai daavɨna yaka Naangerɨ wɨdɨna “Naangeigɨ, yɨthaa, nɨmɨre gɨlyɨvɨta yuya sa yune tɨnnyabanna jaapalɨdeꞌnanyɨra. Sara jaapalaꞌmujɨ pimagɨnyavaaꞌ aꞌmwe gɨlyɨvɨꞌmaayaraavɨ yanga wɨjaavɨdeinyɨra. Nabaai nɨmɨ aꞌmwe gazarɨzarɨ kwaasɨ yagaala wɨdena gamɨre gɨlyɨvɨta pɨrɨꞌ kuka sara maarena yɨ gamɨnyɨ gɨlyɨvɨta dawaai dawaalya sanna ayɨna wɨrɨvɨkɨrɨdeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sara wɨdɨna kyaꞌ Jizaazai sahwarɨ wɨdɨna “Yuna dahaasagaaꞌ aꞌmwe anga dathavɨyarɨ Gotɨyai mena wɨvadaihasamaaꞌmwakelyɨra. Aꞌmwe dazai kwai Ne sɨnnawɨnya Evɨraamɨmɨrei nebwina yɨmaꞌnɨwakeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sareꞌ dareꞌnesɨ. Aꞌmweraavɨne Kaimɨraayai aꞌmwera yagalyaꞌmaꞌnɨkeraavɨ ayɨna bɨramaaryaꞌnei nabaai padaihasamaaryaꞌnei bɨwakelyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sagaaꞌ sahwara yagaala dazaꞌ kadɨka wɨꞌnyɨna yeva yawɨꞌna “Yuna dahaasagaaꞌ Gotɨyai aꞌmweraavɨ maremwaaladeꞌ kuꞌmaayaba yɨmaꞌnaabatheꞌna yɨwaka! Gotɨyai nevadaihasamaarojɨ Jizaazai nemɨre kingɨya naangerɨ yarai wɨmwaaihadeꞌnanyɨ.” Sara yawɨꞌna yɨna yesaꞌnajɨ nabaai anga Jeruzaalemɨna aya kɨba mena yɨꞌmata yaꞌneba yɨdɨꞌnyɨyaꞌnajɨ keꞌbaꞌna yagaala pɨrɨsɨ wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Sarevɨdaaꞌnyɨ dara wɨdɨna “Aꞌmwe naanga akwai anga saamɨnya menya pɨwɨnna kingɨyai yɨmaꞌnyaꞌnei yagalaawɨna yaꞌnei wɨna. ");
INSERT INTO byr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sɨnnawɨ sare sai gamɨre yaasɨwaꞌwawɨnya atɨraalyaraavɨ jaka jɨꞌbwaꞌna yaka nɨgwia kinaaya jaapaina yaka sɨvɨlatɨraala pwarɨ sɨvɨlatɨraala pwarɨ sana sana avaaina yanga wɨjaavɨna. Sara yakegaaꞌ wɨdɨna ‘Sarɨmɨ nɨgwia daza makwawopɨjɨ nɨmɨnyɨneba bɨzɨnɨzɨya pɨnɨ javɨkaryaawila! Yune nɨmɨ ayɨna bɨwɨjahaaꞌnaneihɨlyɨra.’ Sara wɨdɨna yaka kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kaanna wɨna kyaꞌ kɨrɨꞌ aꞌmwe anga dazabanyara dazalyɨya avaaimwaalyara sahwarɨna sɨmɨlɨka wimwaaina. Sɨmɨlɨka sara wimwaaina yadɨvɨꞌ gamɨnyɨ dɨvidaaꞌnyɨ aꞌmwe marewɨjaraavɨ maryaasɨna kyeꞌ sahwarɨ dɨvidaaꞌnyɨ mɨjamakuna. Sara yevera sahwara dɨna ‘Nemɨ yawɨꞌmwo. Aꞌmwe dazai nemɨre kingɨyai namwaaladɨka!’ ");
INSERT INTO byr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Yagaala saꞌ mɨjamakuna kyeꞌ kɨrɨꞌ sarɨ kingɨya dahɨlakɨna yesai dɨvi ayɨna bɨna yɨna yakei. Sai wɨdɨna ‘Nɨmɨre nyɨdaayadɨvɨta sɨnnawɨ nɨgwia wɨjaavena maryaasage dazaraavɨ jaka duzɨla! Nɨmɨ yawɨranganɨdeꞌna aꞌmwe yuya pwaina pwainanyara nɨgwia kwaala gara gare maꞌmwaata dɨngaka?’ ");
INSERT INTO byr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sara wɨdɨna kyaꞌ sahwara bɨna yeveraavɨdaaꞌnyɨ pwai aayagaaꞌ maarakei wɨdɨna ‘Naangeigɨ, gɨmɨre nɨgwia tɨwedi kinaaya (20) dazangɨdaaꞌnyɨ bɨzɨnɨzɨya yavɨkaryena nɨgwia kwaala tu aadɨretɨ kinaaya (200) maaꞌmwana.’ ");
INSERT INTO byr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Sara wɨdɨna kyaꞌ kingɨyai wɨdɨna ‘Nyɨdaayadɨnya tewaanyaigɨ, wawɨnya tewaanaangeꞌna yadɨnyaigɨnyɨra. Gɨlyɨvɨta maalɨkengɨneꞌna nayaa yavadaꞌgainadɨnyaigɨnyɨra. Sarevɨdaaꞌnyɨ dahaaꞌ anga atɨraalyangɨ dɨmaremwaaideigɨnyɨ gɨthahɨlakɨweigɨnyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nabaai ayawɨdaaꞌnyɨ pwai bɨna yaka buthɨna ‘Naangeigɨ, gɨmɨre tɨwedi kinaayajɨ (20) nɨmɨ bɨzɨnɨzɨwawɨnya yadɨ dahaaꞌ nɨgwia kwaala waanɨ aadɨretɨ kinaaya (100) maaꞌmwana.’ ");
INSERT INTO byr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Sara wɨdɨna kyaꞌ kingɨyai wɨdɨna ‘Nabaai sabaaibɨꞌ anga atɨlyangɨ dɨmaremwaaideigɨnyɨ gɨthahɨlakɨweigɨnyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nabaai wawɨnya wɨdaayade pwai bɨna yɨna yaka wɨdɨna ‘Naangeigɨ, gɨmɨre nɨgwia tɨwedi kinaaya (20) dava warɨka dangaakana! Kwaabɨyɨvɨꞌbubunya pɨrɨvɨ yewaaꞌmwagena wake davaakana! ");
INSERT INTO byr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Sareꞌ dareꞌnesɨ. Gɨmɨnyɨ gwangadɨ aꞌmwe kɨrɨꞌmɨryaigɨnyɨ. Gɨlyɨvɨta aꞌmwe pwara wakamaremwaaidɨvɨsa, sa gɨmɨ maarɨna yadɨnyaigɨnyɨ. Nabaai tɨka wapaaya aꞌmwe pwara burɨdɨvɨsa, sa gɨmɨ yabwarina yadɨnyaigɨnyɨ. Sareꞌna nɨmɨ gɨmɨnyɨna lɨka naanga yadɨnyainyɨ.’ ");
INSERT INTO byr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Sara wɨdɨna kyaꞌ kingɨyai wawɨnya wɨdaayade dazarɨ wɨdɨna ‘Nyɨdaayadɨnya yuna kayaaꞌnanyaigɨ, yune gɨnnya yagaala dazahɨrɨvɨneꞌna kotɨyaꞌ gɨmarideigɨnyɨra. Gɨmɨ yawɨꞌdɨnyaigɨnyɨ. Nɨmɨ aꞌmwe kɨrɨꞌmɨryainyɨ. Nabaai gɨlyɨvɨsa aꞌmwe pwara wakamaremwaaidɨvɨsa nɨmɨ maaꞌdɨnyainyɨ dɨngaꞌ! Nabaai tɨka munne aꞌmwe pwara burɨdɨvɨsa, sa nɨmɨ yabwaryadɨnyainyɨ dɨngaka! Sasareinyɨ dɨngaka! ");
INSERT INTO byr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nɨnnya nɨgwia “Bengɨyavɨ wakɨma!” majaꞌneigɨ beꞌna yadɨnyaigɨnaka? Sara yɨjɨ kwajɨ nabaai ayɨna bena nɨgwia kwaalyajɨ yɨlakɨpɨja kabamaaꞌmudɨka!’ ");
INSERT INTO byr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nabaai aꞌmwe aya kɨba gaidaꞌdaavadapiyaraavɨ dara wɨdɨna ‘Dazahware tɨwedi kinaaya (20) dazaꞌ wɨdamaarapɨjɨ aꞌmwe tu aadɨretɨ kinaayajɨya (200) dazarɨ dumaarila!’ ");
INSERT INTO byr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Sara wɨdɨna kyaꞌ sahwara wɨdɨna ‘Naangeigɨ, sai mena tu aadɨretɨ kinaaya kɨnɨnnakelyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Sara wɨdɨna kyeꞌ sai wɨdɨna ‘Yɨhɨthɨvanɨge. Aꞌmwe gazaizai tewaanya kɨnɨnnakei lɨmwagazaꞌ nabaai nɨmɨ naanga pɨnɨjɨ yanga wɨjaavɨdeinyɨ. Kɨrɨꞌ aꞌmwe pwai tewaanya malɨmwagaryajai, sai yune maalɨkenna lɨmwagarajaꞌ sasare saꞌ marasɨꞌnɨdesɨ. ");
INSERT INTO byr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Sare kɨrɨꞌ nɨmɨre yɨkamaanga dazara, sahwara yawɨꞌna “Sai nemɨre kingɨyai namwaaladɨka!” Sara yawɨꞌdɨvɨsaꞌna sarɨmɨ nɨmɨre tɨnna daryabanna makabapɨjɨ baramakila!’ ” ");
INSERT INTO byr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jizaazai yagaala dazaꞌ mena jɨꞌmwannaka sɨnnawɨ anga Jeruzaalemɨna kaanya waanyɨna. ");
INSERT INTO byr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Waanyɨna yadehaaꞌ anga Bepaaza anga Betaani sabanyaaina aya kɨbanna yɨꞌmaꞌna, mugunyavɨ Wolivɨ woꞌnɨkebanna, sare sabadaaꞌnyɨ gamɨre mɨdɨdita pwaraarɨ dara wɨdaasɨna ");
INSERT INTO byr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kɨrɨmɨ saraaihi anga akyamwina dulaawideraaihɨlyɨra. Sara wɨlaawakɨlyɨ dogiya dɨwɨnya pwai wɨla yɨrakɨnɨkerɨ bɨramaaꞌna jideraaihɨlyɨ. Dogiya sai aaya mudɨꞌna aꞌmwe aane pwai kwai milamwalɨbwaayarɨ. Sare sai wɨlyaꞌ yarɨmakwaasakɨlyɨ dɨmakabidelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Sare savɨ nabaai aꞌmwe pwai kwai dara yɨhithaanganajai ‘Dogiya sarɨ beꞌna yɨralaꞌmanɨgɨleva!’ yɨ kɨrɨmɨ ayɨna dara duzideraaihɨlyɨ ‘Naangerɨ kumudaasɨwaꞌ bamaaꞌmwoi.’ ” ");
INSERT INTO byr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Saraarɨ sara mena maryaasɨna kyaꞌ saraai kaanna wɨna yagɨla kɨrɨmɨnyɨ yuya sara wɨdaka sanna bɨramaaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bɨramaaꞌna yagɨla dogɨya dɨwɨnya sarɨ wɨlaꞌnya yɨꞌdɨvalakɨnɨkeꞌ yaarɨna yadaakɨlyɨ dogɨya sahwarɨ kwɨyakwarava saraarɨ yɨdaanganna “Dogiya dɨwɨnya sarɨ wɨlyaꞌ beꞌna galyaaꞌmanɨgɨleva?” ");
INSERT INTO byr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Sara yɨdaanganna kyeꞌ saraai wɨdɨna “Naangerɨ kumudaasɨwakɨra.” ");
INSERT INTO byr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Wɨdɨna kyagi “Wikɨra,” wɨdɨna kyeꞌ Jizaazaryawɨnna saraai dɨwɨnya sai makabɨna yagɨla kɨrɨmɨre baazɨꞌmaꞌnya saamɨnya dogiyarɨ aꞌba yɨlakɨna kyagi Jizaazai aꞌba bulevɨ yɨlamwaaina. ");
INSERT INTO byr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Dogiyarɨ yɨlamwaaina yadɨꞌnyɨ makuna yadaaꞌnyɨ aꞌmwera aꞌmwemɨlɨka yɨlaayaꞌna kumɨre baazɨꞌmaꞌnya saamɨnya tutaanya kaanya widavadaaꞌnyɨyavakɨ kwala pɨgɨlawakɨwɨlaawɨna. ");
INSERT INTO byr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kwala pɨgɨlawakɨwɨlaawɨna yadaapi sahwai aya kɨba tuꞌadaihɨsaba Mugunya Wolivɨ mena wɨlaabɨna. Mena wɨlaabɨna yakegaaꞌ aaya walaraimwannasaba gamɨre mɨdɨdɨvɨsara kwala bwaꞌnaanya yuyara Gotɨyarɨ yɨlaaya naanga yɨna. Yuya dɨragɨnya yɨjɨwakadaaꞌnya tɨnna wanganeta sanna yawɨꞌdɨvɨꞌ jaka dɨragɨnna dɨna yadɨvɨꞌ Gotɨyarɨ yayaꞌ munyaba makina. ");
INSERT INTO byr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jakeꞌ dara dɨna “Naangerɨne yayavɨna bɨwaka Kingɨyarɨ Tewaanya naanga yanga yana! Sɨgunyavɨne naryaꞌ yarai yɨmaꞌnana! Munyawɨnyarɨne yayaꞌ byaannakeꞌ makɨlaana!” ");
INSERT INTO byr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jaka sara dɨna yadaapi Perɨzɨya pwara kwala bwaꞌnaanyavɨdaaꞌnyara gamɨnyɨ wɨdɨna “Wɨjɨwaakadɨnyaigɨ, gɨmɨre gɨmɨdɨdɨvɨsaraavɨ mayagaala duthatheꞌnanyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sara wɨdɨna kyeꞌ jaꞌnawɨdɨna “Yɨhɨthɨvanɨge. Kumɨre maange bɨpaibɨzaꞌ, yɨ sɨlyara kumɨ sara yagaala jaka dɨpɨꞌdera daaka!” ");
INSERT INTO byr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jeruzaalemɨ aya kɨbanna sai yɨꞌmavaka anga naangeba tɨnna wanganna yɨna yaka savɨna kɨnna maredɨna. ");
INSERT INTO byr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Sai dɨna “Dahaaꞌ yɨrɨka darɨkɨ nabaai gɨmɨ kave mwaalya sabwina, naryavɨne mena kyawɨꞌdɨkebagɨ - weꞌ! Kɨrɨꞌ dahaaꞌ nɨmɨnyɨna myawɨryadɨnyaꞌna naryavɨ wakyaꞌnebwi myawɨramaarivanɨgɨ. (Nɨmɨnyɨna ‘Aala!’ dadɨvɨꞌ daza gɨmɨ tɨnna mwanganyɨvanɨgɨ.) ");
INSERT INTO byr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pɨgaaꞌ yɨmaꞌnajahaaꞌ mala bwaꞌnyaꞌne gɨmɨre yɨkamaangera gɨmɨnyɨ yunewɨnna kurɨta keꞌbeva saamɨnya gyamaapɨꞌdeꞌgɨnyɨra. Kurɨta dazavɨ yunebanna bamwadaꞌnarapɨjɨ yunebanna akyamwi akyamwi maragɨhɨpaledaaꞌna gyɨpɨꞌdeꞌgɨnyɨ. Akyamwidaaꞌnyɨ akyamwidaaꞌnyɨ mala makulaabɨpɨꞌdevagɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sara yapɨjɨ gɨmɨnyɨ kayaaka kuna gihalakapɨjɨ gɨmɨjɨ gɨnnyarajɨ sanaaihɨrɨ kayaaka yɨhigalakɨpɨꞌdenaaihɨlyɨ. Sareꞌna gɨmɨnne sɨla pwarɨ wanganakɨpɨꞌdei mɨꞌ. Kurɨkavɨne sɨla pwarɨ aꞌba yɨlamwaalɨkei mwari yadelyɨ. Aawa. Yuya woꞌdalasɨꞌnɨpɨꞌdere. Aane pwai kwai waradei mɨꞌ. Aawa. Gotɨyai maryasaabakei gɨvadaihasamaaryaꞌnerɨ gɨmɨ sɨmunya myawɨri yagɨna bule wɨjaavanɨgɨnyaꞌgɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sai sara kɨnna maredɨna yada sara dɨna yakegaaꞌ Gotɨyare Angevɨ wɨlaawɨna yaka sahɨba kusawɨ nɨgwia mwagiꞌnadɨvɨsaraavɨ wɨlatamabwakɨraasɨna yada ");
INSERT INTO byr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","wɨdɨna “Gotɨyare Bukuyaꞌ dara yɨdaꞌnɨkesɨ. Nɨmɨre angeꞌ nɨmɨnyɨ wɨjaꞌneꞌ mannadesɨra. Sara dɨnɨka kɨrɨꞌ sarɨmɨ yɨwaasaꞌna aꞌmwe kukera lɨka yulyaryaꞌnebabɨsaba yɨmaꞌnɨwakebera.” ");
INSERT INTO byr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yuya yɨrɨkerɨkaavɨ Gotɨyare Angevɨ wɨjɨwaakada mwaalɨna. Sare sarɨna Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ Gotɨyare Kɨwɨjarajɨ aꞌmweraavɨre aꞌmwe naangerajɨ “Sahwarɨ tamakaana!” deva yesare. ");
INSERT INTO byr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Sareꞌ dareꞌnesɨ. Aꞌmwe yuyara gamɨre yagaalyaꞌ kadɨka wɨꞌnyaꞌna dɨragɨnna yɨvanɨgasaraavɨneꞌna. ");
INSERT INTO byr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yɨrɨka pɨrɨkɨ pɨgaaꞌ Gotɨyare Angevɨ sai aꞌmwemɨlɨka aꞌmweraavɨ wɨjɨwaakɨna yɨna yada yagaala tewaanyaꞌ wɨjɨwaakɨna. Sara yadaaꞌnyɨyaba gamɨnyawɨnna Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ Kɨwɨjarajɨ nabaai aꞌmwe naangerajɨ yɨkabɨna. ");
INSERT INTO byr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Sara yɨkabɨna yeva wɨdɨna “Nemɨnyɨ dɨnedana! Daza yɨvanɨgɨnyanna be dɨragɨnyasɨ yɨvanɨgɨnyavaka? Dɨragɨnya dazaꞌ aaihwai gɨzaawakavaka?” ");
INSERT INTO byr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sara wɨdɨna kyeꞌ sai kumɨnyɨ jaꞌnawɨdɨna “Nabaai nɨmɨ kwainyɨjɨ yagaala pɨrɨꞌna yɨhithaanganɨdeꞌnanyɨra. Nɨmɨnyɨ dɨnyɨjɨla! ");
INSERT INTO byr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jonɨmɨre bavɨtaazɨya yadeꞌ Sɨgunyavɨyaꞌ dɨngaka? Saꞌ aꞌmweraavɨre sɨmunyaburɨdaaꞌnyaꞌ dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sara jaꞌnawɨdɨna kyaꞌ sarevɨ kumɨ sara dɨnyɨna “Nabaai nemɨ wɨdaazaꞌ ‘Sabwi Sɨgunyavɨyabulyɨra,’ sai nedathe ‘Jonɨmɨre yagaalyavɨna dɨragɨnna malɨmwagyaihi beꞌna yadɨvɨtaihɨlaka!’ ");
INSERT INTO byr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nabaai nemɨ wɨdaazaꞌ ‘Sabwi yune aꞌmweraavɨre sɨmunyaburɨdaaꞌnyabulyɨra,’ sara wɨdaazaꞌna aꞌmwe yuyara sɨla nanelɨwakɨpɨdɨka! Sareꞌ dareꞌnesɨ. Yuyara ‘Jonɨ Gotɨyarɨ wɨꞌnawɨjɨwaakadei, pɨropetɨyalyɨra,’ dɨragɨnna yawɨꞌdɨvɨsaꞌnanyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sara dɨnyɨna yeva jaꞌnawɨdɨna “Nemɨ myawɨrivanɨgo. Jonɨmɨre bavɨtaazɨyaꞌ gawɨdaaꞌnyɨ yɨmaꞌnakeꞌ dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jaꞌnawɨdɨna kyeꞌ Jizaazai kumɨnyɨ wɨdɨna “Sasare savɨdaaꞌnyɨ ‘Nɨmɨ dɨragɨnya gathaꞌdaresɨyainyɨ yadɨnyainyakeva,’ mayɨhɨzɨ yɨhideinyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Aꞌmweraavɨ keꞌbaꞌna yagaala dathaꞌ gaai wɨjɨwaakɨna “Aꞌmwe pwai gɨraipɨwawɨnya pɨjɨꞌ yaburɨdakɨna yajazɨkɨ. Gɨraipɨwawɨnya sajɨꞌ ‘Aꞌmwe pwara maremwaaibɨkajɨ,’ wɨjaavɨna yakei gamɨ sai anga menya pɨwɨ saamɨnyagaaꞌ mwaalyaꞌnei. ");
INSERT INTO byr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Gɨraipɨwawɨnyajɨkɨ tɨka munne yabwaryagaaꞌ gamɨre wawɨnyavɨ maremwaaidɨvɨsaraayawɨnna gamɨre wɨdaayade pwarɨ maryasaabɨna. ‘Wawɨnya maremwaaidɨvɨta sangɨdaaꞌnyɨ tɨka munne pɨvaaꞌ wiabwaripɨkajɨ,’ maryasaabɨna. Sara yɨna kyaꞌ kɨrɨꞌ aꞌmwe wawɨnyavɨ maremwaaidɨvɨsara wɨdaayaderɨ mala tamɨna yeva kunerɨ ayɨna maragaibwakɨrasaabɨna. ");
INSERT INTO byr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sara yɨna kyeꞌ nabaai wawɨnya wɨdaayade pwarɨ ayɨna ayawɨnna maryaasɨna. Maryaasɨna kyaꞌ nabaai sai kwarɨjɨ mala tamɨna yeva bɨralyabwi yɨna yeva maragaibwakɨrasaabɨna. ");
INSERT INTO byr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nabaai ayɨna ayawɨnna pwarɨna maryaasɨna. Sarerɨ yɨnahu tamɨna yeva gaꞌbwarala naanga yɨnɨkerɨ mwasɨlaa marasɨꞌnyɨna kyeꞌ sai kunei ayɨna bɨna. ");
INSERT INTO byr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Sara yadaapɨri wawɨnyavɨ gyakwai dɨna ‘Gathaꞌdara yɨdeinyaka? Nɨnnya nyɨbwaalɨvaangei nawɨꞌnyɨna tewaanna wivanɨgei maryaasɨdera. Sahware yagaalyavɨ kadɨka yɨnɨga wiꞌna wɨꞌnɨpɨꞌdei dɨngaka?’ ");
INSERT INTO byr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Maryaasɨna kyaꞌ kɨrɨꞌ wawɨnya dazavɨ maremwaaidɨvɨta dazara gamɨre gawaalɨvaangei badaaworiyarɨ tɨnna wanganna yeva kumɨ sara dɨnyɨna ‘Aꞌmwe dazai dɨvi ganɨmaangere yuya sa maaradelyɨra. Yarala, tamakaana! “Wawɨnya dazɨꞌ yune nemɨ saina lɨmwagaraana!” dawaajɨ tamakaana!’ ");
INSERT INTO byr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Sara dɨnyɨna yeva gɨraipɨwawɨnya sajɨkɨ mwasɨlaa makwalyuna yeva yɨnahu tamakɨna. Sarevɨdaaꞌnyɨ gɨraipɨwawɨnya sajɨkɨ gyakwai sahwaraavɨ gathaꞌdara wiadelaka! ");
INSERT INTO byr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aꞌmwe wawɨnyavɨ maremwaaidɨvɨsaraavɨna bɨna yojɨ kayaaka wigalakadelyɨ. Sara yojɨ gɨraipɨwawɨnya sajɨꞌ aꞌmwe mudɨka pwaraavɨ wɨjaavadezɨkɨ.” Jizaazai sara wɨdɨna kyaꞌ saꞌ kadɨka wɨꞌnevera wɨdɨna “Sasare sabwi myɨmaꞌnanna! Arɨkawɨ.” ");
INSERT INTO byr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sara wɨdɨna kyeꞌ sahwai kumɨnyɨ tɨnna wanganaka wɨdɨna “Bukuyavɨ yagaala dazavɨ be kaavɨlaꞌ warɨkavaka? ‘Sɨla dazai anga madɨvɨsara yawɨbwarasɨꞌnesai, Angevɨ simɨjamaanga yuna naangei yɨmaꞌnɨwakelyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sara dɨnɨkeꞌ aꞌmwe gazaizai sɨla dɨragɨnaanga dazarɨ walatannojɨyai, yuna kayaaka wɨsɨꞌnadelyɨ. Nabaai sɨla dazai aꞌmwe pwai kwarɨ aꞌbadaaꞌnyɨ walaramajai dazai yuna kayaaka mɨlɨkiꞌnyɨna yojɨyai yune surɨnya yɨwagakɨna yadelyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aꞌmwe Kɨwɨjarajɨ Gotɨyarɨne tamiraꞌdɨvɨta naangerajɨ sahwara yawɨꞌna “Yuna dazagaaꞌ sahwarɨ galalɨmwagaana!” dɨnyɨna. Sareꞌ dareꞌnesɨ. “Sahwai yagaala dazaꞌ nemɨnyɨneꞌna kwaasɨ dɨvanɨkeva.” Kɨrɨꞌ aꞌmwe yuyara mwaaidapiyavɨna lɨka naanga yɨna yeva kave mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Sagaaꞌ gamɨnyɨ baihanaꞌna yadɨvɨꞌ aꞌmwe pwaraavɨ gamɨreburɨ kwaasɨ yawɨramaataꞌneraavɨ maryasaabɨna. Aꞌmwe dazara kwaasɨ darebwi yadɨvɨꞌ “Nemɨnyɨna ‘Aꞌmwe yɨdaꞌmaraangerera,’ yawɨrana!” yawɨresaraavɨ “Gamɨre yagaala kayaaꞌnanyaꞌ wɨꞌnawaajɨ Gaꞌmaanɨya naangeryaba kotɨyavɨ marakaana!” deva maryasaabɨna. ");
INSERT INTO byr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sarera kwaasɨ dara yɨdaanganna “Wɨjɨwaakadɨnyaigɨ, nemɨ nayaa yawɨꞌmanɨgo ‘Gɨmɨre yagaalyaꞌ yɨdaꞌmaraangesɨra. Sara yadɨ gɨmɨ saigɨ aꞌmwemɨlɨkaavɨ aꞌmweraavɨ yagaala nebulyaꞌna wɨjɨwaakadɨnyaigɨnyɨra. Aꞌmwe naangeraavɨna lɨka myadɨnyaigɨnyɨ. Aawa. Yuyaraavɨ Gotɨyarebwi yune nebulyabwina wɨjɨwaakadɨnyaigɨnyɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sareigɨ gara yawɨꞌmanɨgɨna? Gotɨyare kɨwɨnyaꞌ berɨꞌ dɨnɨkavaka? Sizaarɨ taakɨzɨya wɨjavaadeina dɨngaka? Mujaayɨ yaadeina dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Sara yɨdaanganna kyeꞌ sahwai kwaasɨ yagaala wɨdadaapiya dazabwina mena yawɨꞌna. Sarevɨ sai wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Taakɨzɨnɨgwia pɨrɨꞌ dɨnyɨjɨwaainyɨla! Nɨgwia dazavɨ pɨkaryasɨ pikɨzaayasɨ warɨkeꞌ aarɨnevaka?” Wɨdɨna kyaꞌ sahwara wɨdɨna “Sizaarɨnesɨra.” ");
INSERT INTO byr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Sara wɨdɨna kyeꞌ sai wɨdɨna “Yɨ Sizaarɨne sa, Sizaarɨ duzaayidengɨra. Nabaai Gotɨyare sa, yɨ Gotɨyarɨ duzaayidengɨra.” ");
INSERT INTO byr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Sara nayaa wɨdɨna kyaꞌ aꞌmweraayaba gamɨre yagaalyavɨna magalalɨmwagi yeꞌ. Yagaala kumɨnyɨ wɨrɨvɨkɨꞌdaasɨya dazanna atɨka maruꞌnaꞌna. Sara yeva yagaala majɨna. ");
INSERT INTO byr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Aꞌmwe pwara Sazuzɨyaraavɨre yɨsavaakɨdaasara gamɨnyawɨnna bɨna. Sahwara Sazuzɨyara yuyara dara dadɨvɨsare “Aꞌmwe baidɨvɨsara ayɨna madɨkaayɨ yɨpɨꞌderera.” ");
INSERT INTO byr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Sarera bɨna yeva yɨdaanganyaꞌ wɨdɨna “Wɨjɨwaakadɨnyaigɨ, nemɨnyɨna Mozɨzai yagaala pɨrɨꞌ dara yɨdayaakesɨra ‘Aꞌmwe pwai kwai kwala maarojɨyai dɨvidaaꞌnyɨ kaimɨraavɨmaayai balɨna yajaꞌ nabaai gamɨjɨya gathaaꞌgahwaai pwai aꞌmwe savɨ kwala maarɨna yojɨ baryarɨne kaimɨraayai yɨmavɨdaakuna yana!’ ");
INSERT INTO byr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sara yɨdaꞌnɨkevɨdaaꞌnyɨ kumɨ avaalyadaraka ata purɨdaaꞌnyɨ pwaraalyara mwaalɨna. Sareraavɨdaaꞌnyɨ pwai aaya sɨraangei aꞌmwevɨ kwala maarɨna. Sarei sai kaimɨraavɨmaayai balɨna. ");
INSERT INTO byr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Sara balɨna kyaꞌ ayawɨdaaꞌnyɨ gahwaalaanga pwai aꞌmwe dazavɨ kwala maarɨna, balɨna. ");
INSERT INTO byr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Dɨvidaaꞌnyɨ ayawɨ gahwaalaanga pwai avaaina sana yɨna. Sasare savɨ ata purɨdaaꞌnya pwaraala yuya sadaraka aꞌmwe savɨ kwala maareva yuyara kaimɨraavɨmaayara balɨna. ");
INSERT INTO byr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yuyara sara balɨna kyeꞌ dɨvidaaꞌnyɨ aꞌmwe saꞌ kɨrɨsɨ balɨna. ");
INSERT INTO byr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Sarevɨdaaꞌnyɨ aꞌmwe baidɨvɨsara ayɨna dɨkaapɨjahaaꞌ aꞌmwe dazaꞌ aꞌmwe aaihwareꞌ mwaaladevaka? Yɨdaanganya sareꞌ dareꞌnesɨ. Aꞌmwe ata purɨdaaꞌnyɨ pwaraalyara aꞌmwe savɨ kwala maareva kumɨre aꞌmweꞌ mwaalakeꞌnanyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jizaazai kumɨnyɨ wɨdɨna “Yuna dahaasara kwala maaꞌdɨvɨꞌ kwala maaꞌnadɨvɨsare. ");
INSERT INTO byr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kɨrɨꞌ dɨvi nawɨꞌnya sagaaꞌ kurɨnakera mwaaibɨnera, ayɨna dɨkaapɨnera yɨ dazara kwala mamaari yɨna, kwala mamaaꞌnyɨ yɨna yɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Sareꞌ dareꞌnesɨ. Ayawɨdaaꞌnyɨ ayɨna mabalyɨ yɨpɨꞌdera. Sareꞌ dareꞌnesɨ. Ejelɨyarabɨꞌ mwaaibɨꞌderera. Gotɨyai baryaraavɨ ayɨna yɨdɨkaavajaꞌna gamɨre kaimɨraayara mwaaibɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nabaai aꞌmwe bainɨkera ayɨna dɨkaapɨꞌdeꞌ Mozɨzai kwalyɨ nejɨwaakadelyɨ. Yɨta maalɨkikɨ dɨtaalɨta yɨdadaaꞌnyɨyaꞌnajɨ kɨwɨnya dara dadelyɨ ‘Dahaaꞌ Naangei Evɨraamɨmɨre Gotɨyalyɨ. Aazakɨmɨre Gotɨyalyɨ. Jaikopɨmɨre Gotɨyalyɨ.’ Sara dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Sasare savɨdaaꞌnyɨ Gotɨyai yune aꞌmwe bainɨkeraavɨna Gotɨyai mɨka. Aawa. Sai Gotɨya aꞌmwe gaala kurɨnakeraavɨnelyɨ. Sareꞌ dareꞌnesɨ. Gotɨyai yawɨꞌna ‘Aꞌmwera yawɨꞌna “Bainɨkerera,” kɨrɨꞌ yuyara gaala kurɨnakerera.’ ” ");
INSERT INTO byr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sara wɨdɨna kyaꞌ Kɨwɨja pwara gamɨnyɨ jaꞌnawɨdɨna “Wɨjɨwaakadɨnyaigɨ gɨmɨ tewaanya dɨwaana.” ");
INSERT INTO byr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Sareꞌ dareꞌnesɨ. Aꞌmwera ayɨna yɨdaanganya aane pɨrɨꞌ kɨrɨsɨ wɨjaꞌneꞌ lɨka naanga yesaꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kumɨnyɨ wɨdɨna “Gathaꞌdarevɨ dadɨvɨtavaka? ‘Kɨraazɨtɨyai, Gotɨyai dahɨlakakei, Devitɨmɨre kaimɨraayalyɨreva.’ ");
INSERT INTO byr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yɨdaanganya sareꞌ dareꞌnesɨ. Bukuya Saamɨyavɨ Devitɨ gamɨ sai dara wɨjaaꞌ ‘Naangei nɨmɨre Naangerɨ dara wɨdaꞌ “Gɨmɨ nɨmɨre aangasɨmagɨ dɨragɨnyaba mwaaidaꞌgɨzɨ ");
INSERT INTO byr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Yɨkamaangeraavɨ gɨmɨre sɨvɨlyɨraarɨ marulawakɨdehaaꞌnanyɨ,” ’ ");
INSERT INTO byr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Sara dɨnɨkevɨdaaꞌnyɨ Devitɨ gamɨ sai dɨna ‘Naangelyɨra.’ ‘Sai gamɨre kaimɨraayala,’ gathaꞌdarevɨnaka?” ");
INSERT INTO byr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aꞌmwe yuyaraayaba, yuyara kadɨka wɨꞌnyɨna yadaapi, sai gamɨre mɨdɨdɨvɨsaraavɨ wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Aꞌmwe Kɨwɨja daraavɨna yawɨrapɨjɨ nayaa javadaꞌgainyideihɨlyɨra. Mala nayaa jɨwannyideihɨlyɨra. Dareraavɨnesɨ. Baazɨꞌmaꞌnya saamɨnya baazɨꞌmaꞌnadɨvɨꞌ kaanya yamaryaꞌna tewaanna wɨvuꞌnaderera. Aꞌmwe aꞌmwera kwala yɨꞌbwaꞌnemwaaidɨvɨsaba wabwiwayagaala ‘Aꞌmwe naangeigɨ!’ wɨjavwina tewaanna wɨvuꞌnaderera. Lotuangevɨ nawɨꞌnyaba aꞌmweraavɨre tɨnnyarɨ walamwaalyaꞌna tewaanna wimaꞌnaderera. Sara yadɨvɨꞌ tɨka munne naangengɨ namwaalyɨta nawɨꞌnyarɨ yɨlamwaalyaꞌna tewaanna wɨvuꞌnaderera. ");
INSERT INTO byr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Sarera aꞌmwe yaanyɨwaakengɨ kwaasɨ yagaala wɨdadɨvɨꞌ kunnya angengɨya kuka yuna maaꞌdɨvɨsarera. ‘Aꞌmwera nemɨnyɨna “Tewaanyarera,” yawɨpɨka!’ deva Gotɨyarɨ wɨjavwina saamɨnyabwi mɨjeꞌmwamwodɨvɨsarera. Sara yadɨvɨta sabwineꞌneꞌ wɨrɨvɨkɨryaꞌnegaaꞌ taanginya naangeꞌ pwaraavɨ wavɨlasaꞌ kuna maapɨꞌderera.” ");
INSERT INTO byr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Maranganna yaka baihanaꞌdɨꞌnyɨ aꞌmwe gɨlyɨvɨta naangejɨyara Gotɨyarɨne nɨgwia wakadɨvɨta bukusarɨ nɨgwia sɨhumale wakɨ wakya yɨna. ");
INSERT INTO byr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wakɨ wakya yɨna yadaapi tɨnna baihanaꞌna yada aꞌmwe yaanyɨwaaka wɨgainaka pɨrɨvɨ tɨnna wanganna. Sahɨrɨꞌ bukusarɨ nɨgwia maalɨka pukaainanyɨkaai yɨrakakesɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tɨnna wanganna yaka wɨdɨna “Nebulyaꞌna yɨhɨthɨvanɨge. Aꞌmwe yaanyɨwaaka wɨgainada dazaꞌ nɨgwia yɨrakɨvanɨkeꞌ aꞌmwe pwaraavɨ wavɨlaꞌmwakesɨra. ");
INSERT INTO byr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sareꞌ dareꞌnesɨ. Yuya dazara nɨgwia naanga kɨnɨnnakera, sarera Gotɨyarɨne wɨjaayaꞌne pimagɨnya maalɨkemɨlɨꞌna wɨjaavanɨgasarera. Kɨrɨꞌ aꞌmwe dazaꞌ yuna wɨgainadaaꞌnyɨ kɨrɨꞌ gamɨre nɨgwia yuya yɨrakɨna yɨvanɨkeꞌ, gamɨnne tɨka wapaaya mubyaꞌne pɨnɨ mivainyɨ yɨwakesɨra.” ");
INSERT INTO byr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aꞌmwe pwara Gotɨyare Angevɨna dɨna “Anga dazavɨ sɨla tewaanya paidapaide yɨꞌdejɨ mannɨkesɨra. Nabaai Gotɨyarɨne yuya nawɨꞌnya, sɨhumale sajɨ aaraare yawakadɨvɨsasɨra.” Sara dɨna yadaapi sai wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Dahaaꞌ sarɨmɨ tɨnna wangamanɨgata daza pɨgaaꞌ yɨmaꞌnajahaaꞌ sɨla pwai sɨla pwarɨ aꞌbadaaꞌnyɨ yɨlamɨwɨꞌnaradei mɨka! Yuya budawasɨꞌna yɨpɨja kewɨnɨ bwalaraawadengɨra.” ");
INSERT INTO byr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sahwarɨ yɨdaanganna wieꞌ “Nejɨwaakadɨnyaigɨ, dazaba gathɨhaasagaaꞌ yɨmaꞌnadevaka? Sarevɨ nemɨ yawɨranganaade ‘Sarevɨ saꞌ yɨmaꞌnadehaaꞌ aya kɨgaaꞌne wɨjɨwaainyaꞌ berɨvaka?’ ” ");
INSERT INTO byr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sara yɨdaanganna kyeꞌ sai wɨdɨna “Sarɨmɨ mala nayaa jɨwannyɨla! Kwaasɨyabwina nayɨhɨthɨpɨka! Sarevɨ dareꞌnesɨ. Sarɨmɨnyawɨnna aꞌmwe kwalaalyara badɨvɨꞌ nɨmɨnyɨne yayaꞌ yɨhɨthadɨvɨꞌ wɨdɨna ‘Nɨmɨ sainyɨ sahwainyɨra.’ Nabaai sahwara yɨhɨthɨpɨꞌde ‘Aya kɨgaaꞌ mena yɨmaꞌnɨwakegaakɨra.’ Sara yɨhɨthɨpɨjaraavɨ namɨdɨbɨthɨka! ");
INSERT INTO byr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mala naanga bwaꞌnadɨvɨꞌ dadaapiya sangɨna sarɨmɨ kadɨka duꞌnyideihɨlyɨ. Sare sanna sarɨmɨ lɨka nyɨwaainɨpɨdɨka! Aawa. Sareꞌ dareꞌnesɨ. Sasare dazaza sɨnnawɨ mena yɨmaꞌnojɨ kɨrɨꞌ yɨrɨka aayarɨꞌnegaaꞌ yɨmeꞌnyaꞌbɨꞌ yɨmaꞌnadeꞌ mɨka!” ");
INSERT INTO byr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sagaaꞌ sahwai wɨdɨna “Aꞌmwe anga naanga pimagɨnyarajɨ aꞌmwe anga naanga pimagɨnya pwarajɨ mala bwaꞌnɨpɨꞌderera. Nabaai kingɨya pware savaasɨ kingɨya pware sarajɨ mala bwaꞌnɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kwaakevakɨ wɨnɨnya naangenna naangennanya lavirɨꞌmwagakadevakɨra. Anga pimagɨdaaꞌnyɨ anga pimagɨnna aꞌmweraavɨ mɨjɨka naangejɨ nabalya naangejɨ yɨmaꞌnaderera. Sɨgunyavɨ dala nabinabinya naangenna naangennanya wɨjɨwaainya yɨmaꞌnaabazangɨ lɨka yɨrɨꞌgalamihyaꞌne danganyideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kɨrɨꞌ yuya daza mimaꞌnaabyadozɨ sarɨmɨnyɨ ata galayɨhɨlɨmwagapɨjɨ yuna kayaaꞌna yɨhipɨꞌdeihɨlyɨ. Lotuangengɨ kotɨya yɨhɨmaryadɨvɨꞌ kalavuzavɨ yɨhɨmwangɨmwaaihɨpɨꞌdeihɨlyɨ. Nɨmɨnne yaya savɨna ‘Marulawakaana!’ yawɨꞌdɨvɨꞌ kingɨyarajɨ Gaꞌmaanɨya naangerajɨ saraayawɨnna yɨhɨmakabadɨvɨꞌ yɨhɨmarɨdaakupɨꞌdeihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sasare savɨ nɨmɨnyɨna nayaa jalɨkurakɨna jideꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sare savɨdaaꞌnyɨ sarɨmɨ yagaala kumɨnyɨ ayɨna wɨjaꞌne sarɨmɨre sɨmunyarɨ myawɨramaremwaaibɨna! ");
INSERT INTO byr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sareꞌ dareꞌnesɨ. Sarɨmɨre maangikaavɨ nɨmɨ sainyɨ nɨmɨre yagaalya yɨhwakadɨ sɨmunya tewaanya yɨhɨzaavɨdeinyɨra. Sareꞌna sarɨmɨre yuya yɨkamaanga kwara nɨmɨre yagaala yɨhɨzaavɨwɨja dazavɨ marayɨhɨrɨvɨkɨpɨꞌdera mɨka! ");
INSERT INTO byr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Sɨrɨnɨmaangerajɨ sɨrɨdaasɨrɨgwaaravajɨ avaalyarajɨ sɨryaꞌmwerajɨ sara yɨkamaangeraayawɨnna yɨhɨmaaripɨꞌdeihɨlyɨ. Sara yadaapi sarɨmɨnyɨdaaꞌnya pwaraavɨ tamakɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nabaai aꞌmwe yuyara nɨmɨnne yaya savɨna yawɨꞌdɨvɨꞌ sarɨmɨnyɨna sɨmɨlɨka wimwaaladeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kɨrɨꞌ sarɨmɨre mɨnyagɨnyangɨya mɨjata aane pwai kwai samwi yalaꞌdaavadei mɨka. Arɨkewɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Sarɨmɨ dɨragɨnna daavapɨjɨyavɨ sarɨmɨre gaalyabwi dɨmaaryideihɨlyɨra. ");
INSERT INTO byr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Dɨvi Jeruzaalemɨna aamiyara aawɨlasara bapɨjɨ bahɨhɨpaidapi sarɨmɨ danganyidehaaꞌ jawɨryide ‘Anga naangeba kayaaka yɨgalakyaꞌnegaaꞌ mena nebawa mɨka!’ ");
INSERT INTO byr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Dazagaaꞌ aꞌmwe anga Juthɨya mwaaibɨzara mugunyangɨna lɨkaanya yɨlaawɨpɨka! Nabaai aꞌmwe Jeruzaalemɨ mwaaibɨzara yarai yagalyaꞌmavapɨjɨ pɨwɨnnera wɨpɨka! Yɨ anga naangeba mwasɨlaa mwaaibɨzara sahɨba kusawɨ mulaawɨpɨna! ");
INSERT INTO byr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Dazahɨgaaꞌ yɨ Gotɨyaregaaꞌ kayaaꞌnanyabwina tɨvɨkɨta yaꞌnegaaꞌ yɨmaꞌnadehaakɨra. Sarevɨdaaꞌnyɨ yagaala yuya Gotɨyare Bukuyavɨ yɨdaꞌnɨke sa yuna nebwina yɨmaꞌnadennanyɨra. ");
INSERT INTO byr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yɨrɨka sasarerɨkaavɨ aꞌmwe kaimɨraavɨmunnakenna weꞌ! Nabaai kaimɨraayangɨ aamunya yaꞌdaapɨjɨyanna weꞌ! Sareꞌ dareꞌnesɨ. Kwaaka dazavakɨ taanginya naangeꞌ yɨmaꞌnadevakɨra. Gotɨyare sɨnna tɨkeꞌ aꞌmwe dazaraavɨ aꞌmwe dazamɨlɨkaavɨ waradesɨra. ");
INSERT INTO byr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kwaariꞌmasɨramɨnyaꞌ yuneba tamaasaderera. Yɨkamaangera kalavuza maaꞌdɨvɨꞌ ajɨmya yuyangɨyaraavɨ marɨmwaaihɨpɨꞌdere. Aꞌmwe ajɨmya yuyangɨyaraavɨre sɨvɨlyajɨ Jeruzaalemɨ paihɨꞌdɨvɨꞌ dathɨwagemwaaibɨꞌderera. Sara yapɨjɨyaraavɨregaaꞌ dɨvidaaꞌnyɨ ajɨmya yuyangɨya saraavɨregaaꞌna yɨnahu miꞌna kyɨmaꞌnojɨ Jeruzaalemɨ Juyara ayɨna nayaa maremwaaibɨꞌdesɨra. ");
INSERT INTO byr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nyɨlyarɨjɨ lawerɨjɨ sɨlɨngaamɨnyarɨkaavɨjɨ sɨgunya yunevɨ dala nabinabinya wɨjɨwaainyaꞌne yɨmaꞌnadengɨ. Nabaai Kwaakevakɨ saalaalyavɨre aalɨmavajɨnaakeꞌ yɨꞌmunyaꞌbɨꞌ wɨlapida gazamɨlɨsamɨlɨꞌ wɨlamujangɨꞌdaawori aꞌmwe ajɨmya yuyangɨyaraavɨre sɨmunyavɨ yuna kayaaka wigaida lɨka naanga yɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Aꞌmwera Kwaakevakɨ yɨmaꞌnade sanna yawɨꞌdɨvɨꞌ kumɨre kɨlaakejɨꞌna lɨka naanga yɨpɨꞌderera. Sareꞌna kumɨre tɨnnyara jɨhɨmihɨta kɨrɨbɨbɨnya wɨbwaaꞌnaderera. Sareꞌ dareꞌnesɨ. Sɨgunyavɨya dɨragɨnya dɨꞌnake sa yonyɨ yonyɨ yɨmaꞌnadeꞌnanyɨra. ");
INSERT INTO byr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dazaꞌ kimaꞌnojɨ Aꞌmweraavɨne Kaimɨraayainyɨ yɨraaya pɨjɨkɨ waidavadaaꞌmuri dɨragɨnya naangesɨ byaanna naangesɨyainyɨ nyangabɨꞌdeinyɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dɨvi yuya daza gaai yɨmaꞌnadaawori ‘Gotɨyai nemɨnyɨ ayɨna maaryaꞌnegaaꞌ aya kɨba menanyɨra,’ yawɨꞌdɨvɨꞌ sara yɨmaꞌnyaꞌneꞌna nayaa dɨragɨnna daavapɨjɨ sarɨmɨre mɨnyagɨnyɨꞌ kekina dɨhaihɨta jideihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sahwai keꞌbaꞌna yagaala pɨrɨꞌ kumɨnyɨ wɨdɨna “Yɨta pihɨyɨkɨjɨ yɨta pukaavɨjɨ tɨnna wangadɨvɨsaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yɨkwarakeꞌ yɨnarɨwaala kyaꞌnojɨ tɨnna wanganapɨjɨ sarɨmɨ saihi jawɨryide ‘Nyɨlyai gaai damaarojɨ tewaanyagaaꞌ aya kɨgaaꞌ yɨmaꞌnadeꞌ daaka!’ ");
INSERT INTO byr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sasare sahɨbaaibɨsaꞌ sasare sahɨnɨ kimaꞌnojɨ tɨnna wanganapɨjɨ jawɨryide ‘Gotɨyai aꞌmweraavɨ maremwaaideꞌ mena aya kɨba daaka!’ ");
INSERT INTO byr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nebulyaꞌna yɨhɨthɨvanɨge. Sarevɨ aꞌmwe sagaasara mabalyɨ kyapɨri yuya daza mena yɨmaꞌnadehaaꞌnanyɨ. Arɨkewɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sɨgunyasɨ Kwaakesɨ mena yɨwɨna yojɨ kɨrɨꞌ nɨmɨre yagaalyaꞌ yɨwodeꞌ mɨka. Arɨkewɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Sarɨmɨ mala nayaa jɨwannyɨla! Biyaaya nyawaaihasaꞌna mɨnyagɨnyɨꞌ kɨrɨbɨbɨnya nyɨhimaꞌnadɨka! Biyaaya yuyagaaꞌ yaasɨwaꞌna nadɨvɨꞌ yɨmaka nyuibɨthɨka! Kɨlaakejɨkɨne sanna sɨmudaadaanya nyawɨꞌmwaainɨpɨdɨka! Sasare sabwi sarɨmɨre sɨmunyavɨ kuna dathɨvaina yɨhyojɨ yɨ sagaaꞌ naanyaꞌ yaawiarɨ lɨvavuꞌdɨhɨꞌdevaaibɨꞌ Naangere yɨrɨkerɨꞌ yɨmeꞌnyaꞌbɨꞌ yɨhɨbɨramaaradeihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sareꞌ dareꞌnesɨ. Yɨrɨka dazarɨꞌ aꞌmwe Kwaakevakɨ yuneba mwaaihata yuyaraavɨ yɨmaꞌnaderɨkɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Gazagaasagaaꞌ sarɨmɨ nayaa dɨvaihanaryɨla! Sara yadɨvɨꞌ ‘Nemɨnyɨ dɨragɨnya nejaavana!’ dapi Gotɨyarɨ dɨragɨnna jɨthaanganyɨla! Sarevɨdaaꞌnyɨ yɨ yɨmaꞌnaabathe yuya dazangɨ davɨlayideihɨlyɨra. Sara yapi Aꞌmweraavɨne Kaimɨraayainyaba dɨthaayideꞌnanyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yuya yɨrɨkerɨkaavɨ Gotɨyare Angevɨ aꞌmweraavɨ wɨjɨwaakakelyɨ. Sawɨsavɨ Mugunya Wolivɨ woꞌnɨkevɨna se yɨlaꞌdaawadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sarevɨ yuya aꞌmwera yuna mwanyavɨna dɨkakwalyodɨvɨꞌ Gotɨyare Angevna gamɨre yagaalyangɨ kadɨka buꞌnyaꞌnera badɨvɨsarera. ");
INSERT INTO byr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gɨrɨkula lɨwɨnya mavamidakyaꞌne munnegaaꞌ nawɨꞌnyagaaꞌ aya kɨgaaꞌ mena yɨmaꞌnyɨna. Yɨ “Pariꞌmaꞌmunneva! Gotɨyai Ne sɨnnawɨnyaraavɨ yɨvainyaakegaaka!” dadɨvɨsagaakɨ. ");
INSERT INTO byr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aya kɨgaaꞌ mena yɨmaꞌnyɨna kyaꞌ Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ Kɨwɨjarajɨ sahwara aangaꞌmweraavɨna lɨka yɨna yeveꞌna kuna dɨnyɨna “Nemɨ sahwarɨ kave gathaꞌdara yawaajɨ tamakaadelaka?” ");
INSERT INTO byr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sagaaꞌ Kayaaꞌnanyai Saataanɨ Juthaazare sɨmunyavɨ wɨlamwaaina. Sai Yɨzɨkerɨyotɨyala woꞌnɨkei, sɨvɨlɨrɨdaaꞌnyɨ pwaraalyaraavɨdaaꞌnyai. ");
INSERT INTO byr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Sarei wawokegaaꞌ Gotɨyarɨna yɨraꞌdɨvɨtara pɨrizɨya naangerajɨ Gotɨyare Angevɨ maremwaaidɨvɨta naangerajɨ yagaalyaꞌ jamungajɨna. Sahwarɨ kumɨnyɨneba wɨmaaryaꞌne tusarɨꞌna bɨryaꞌnei. ");
INSERT INTO byr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Sara mena jamungajevera yɨlaaya yeva Juthaazarɨ nɨgwia wɨjaayaꞌneꞌna jamungajakɨna. ");
INSERT INTO byr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sarevɨ kumɨre yagaalyavɨna Juthaazai “Ya!” wɨdɨna yakei sahwarɨ kumɨnyɨneba wɨmaaryaꞌne tusarɨꞌna bɨrɨna bɨrɨna. Sarei yune gave pɨgaaꞌnei, aꞌmwera aꞌmwe gamɨjɨ myeꞌmwannamwaalyadapiyagaaꞌnei. ");
INSERT INTO byr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gɨrɨkula lɨwɨnya mavamidakyaꞌne yɨrɨkeꞌ yɨmaꞌnyɨna. Yɨrɨka dazarɨkɨ Pariꞌmaꞌmunne sipɨzipɨya dɨwɨnyai tadɨvɨsagaakɨ. ");
INSERT INTO byr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sarevɨ sai Pitarɨjɨ Jonɨmɨjɨ saraarɨ maryaasaꞌneraarɨ wɨdɨna “Kɨrɨmɨ wawokɨlyɨ nemɨnne tɨꞌmunne tɨka naade jovɨrawakaawila!” ");
INSERT INTO byr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wɨdɨna kyaꞌ saraai wɨdɨna “Naarɨmɨ gawɨ yovɨrawakadeꞌna nehɨthɨwaana?” ");
INSERT INTO byr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wɨdɨna kyagi sai wɨdɨna “Yɨthaanyi! Anga naangebanna wɨlaawakɨlyɨ aꞌmwe pwai kwadɨka naangevɨ aalyaꞌ makwojɨyai tutaanyavɨ kɨrɨmɨnyɨ yɨhurataꞌnajai. Yɨ kɨrɨmɨ sarɨ mɨjamakuna yakɨlyɨ anga gamɨ wɨlaja savɨna kwaraaihɨlyɨ wɨlɨna jidesɨra. ");
INSERT INTO byr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Sara yakɨlyɨ anga dazavɨ gyakwalaangerɨ nayaa dara duzideraaihɨlyɨ ‘Nejɨwaakadei gɨmɨnyɨ gɨthɨwakeigɨnyɨ “Nɨmɨrerajɨ tɨꞌmunne naadeꞌ nɨmɨnne kuꞌdɨkeꞌ gava warɨka?” ’ ");
INSERT INTO byr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Sara kudakɨlyɨ sai kuꞌdɨka yarinɨka naangeꞌ munyawɨ, wapeyɨꞌbɨnyajɨ namwaalyɨsajɨ kɨnɨnnakevɨ yɨhibwarɨdaakwadelyɨ. Kuꞌdɨka dazahɨrɨvɨ tɨꞌmunne jovɨrawakyideraaihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Miꞌna wɨdɨna kyaꞌ maryaasakeraai kaanna wɨna yagɨla gamɨ wɨdaka kɨbaaina sana yɨna yagi. Sara yagɨla Pariꞌmaꞌmunne yovɨrawakɨna. ");
INSERT INTO byr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tɨka nyaꞌnegaaꞌ mena kimaꞌnaꞌ yɨꞌbɨnyavɨ sai walamwaaina yadaaꞌnyɨ wɨdaasadera apozelɨyara walayeꞌmwannemwaaina. ");
INSERT INTO byr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sai wɨdɨna “Sarɨmɨjɨ Pariꞌmaꞌmunne daꞌ yeꞌmwannanyaꞌna tewaanya dɨragɨnna nyɨvuꞌnɨvanɨꞌ. Sara yaꞌmujɨyainyɨ dɨvi daanga maarɨdeinyɨra. ");
INSERT INTO byr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sareꞌ dareꞌnesɨ. Dara yɨhɨthɨvanɨge. Sarɨmɨjɨ tɨꞌmunne ayawɨdaaꞌnyɨ sasara yɨhyeꞌmwannanɨdeinyɨ mɨka. Arɨkawɨ. Kɨrɨꞌ Gotɨyai aꞌmweraavɨ maremwaalade sa yune nebwina yɨmaꞌnajahaaꞌna yɨ sagaaꞌ ayɨna nɨdeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wɨdɨna yaka kaapɨvananyai maarɨna yaka Gotɨyarɨ suya wɨdɨna yaka wɨdɨna “Sarɨmɨ dathaꞌ maarapɨjɨ yanga dɨmunɨgulaawila! ");
INSERT INTO byr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sareꞌ dareꞌnesɨ. Dara yɨhɨthɨvanɨge. Dahaasɨ dɨvi kɨgaasɨ waainɨwɨlyabaarɨdaaꞌnya yɨsiaalya manyɨ yɨdeinyɨra. Arɨkawɨ. Gotɨyai aꞌmweraavɨ maremwaalade saꞌ yuneꞌ nebwina yɨmaꞌnajahaaꞌna yɨ sagaaꞌ ayɨna nɨdeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wɨdɨna yaka gɨrɨkulyaꞌ maarɨna yaka Gotɨyarɨ suya wɨdɨna yaka gunyɨna yaka wɨjaavɨna yakegaaꞌ wɨdɨna “Dazaꞌ nɨmɨre kɨlaakejɨkɨra. Sarɨmɨnyɨneꞌna wɨjaavɨnɨdezɨkɨra. Sarɨmɨ yuyagaaꞌ sasara yadɨvɨꞌ nɨmɨnyɨna ayɨna jawɨryidevwinesɨ.” ");
INSERT INTO byr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wɨdɨna kyaꞌ mena nevegaaꞌ kaapɨvananya sahwarɨ avaaina sana yɨna, “Kaapɨvananya dathai nɨmɨre tawevɨya yagaala wɨlɨmwagarɨke mudɨkesɨra. Sarɨmɨnyɨneba nɨmɨre taweꞌ yɨhɨthɨngikɨdesɨra. Nyɨramakɨpɨꞌdesɨra. ");
INSERT INTO byr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kɨrɨꞌ yɨthaanyi, aꞌmwe nɨmɨnyɨ yɨkamaangeraavɨna nyɨbwarɨdaakwiaꞌnei yɨꞌbɨnya dava davɨ nɨmɨjɨ yeꞌmwannamwaaihola dalaakana! ");
INSERT INTO byr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aꞌmweraavɨne Kaimɨraayainyɨ sɨnnawɨ Gotɨyai tuta yawɨbwarakakevɨ mɨdɨmanɨge. Kɨrɨꞌ weꞌ! Yɨkamaangeraavɨna nyɨbwarɨdaakwiaꞌne dazarɨ kayaaka gara yɨgainadei dɨngaka! Weꞌ!” ");
INSERT INTO byr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sai sara daka yadɨꞌnyɨ kumɨ sara yɨdaanganyɨ yɨdaanganya binɨgulɨna “Sasare sabwi aaihwai yadeꞌnevaka?” ");
INSERT INTO byr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Dɨvi maalɨkegaaꞌ sahwara gavamarasɨꞌnyɨyagaala dɨnyɨna, “Aꞌmweraayaba nemɨnyɨdaaꞌnyɨ nemɨre aꞌmwe naangei aaihwalaka? Nɨmɨ dɨngaka!” ");
INSERT INTO byr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sara wɨdesavɨna sai wɨdɨna “Ajɨmya yuyangɨya kingɨyara kwaakewɨnna aꞌmweraavɨ marulawakadɨvɨsara. Aꞌmweraavɨ maremwaalyabwine dɨragɨnyaꞌ kɨnɨnnakera yawɨꞌna ‘Aꞌmwera nemɨnyɨna yawɨpɨka! “Sahwara yanga neyadɨvɨsarera.” ’ ");
INSERT INTO byr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kɨrɨꞌ sarɨmɨ sasare sabwi nyɨpɨdɨka! Aawa. Aꞌmwe sarɨmɨnyɨdaaꞌnyɨ pwai naanga yɨmaꞌnajai sai aaya dɨviyai yɨmaꞌnana! Nabaai sarɨmɨre maremwaalyai sara yɨhɨthaayadei mwaalana! ");
INSERT INTO byr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sareꞌ dareꞌnesɨ. Aꞌmwe naangei aaihwalaka? Aꞌmwei yɨꞌbɨnyavɨ namwaalyɨsarɨ mwaaidei dɨngaka? Aꞌmwei wapaaya bulawɨjaayaꞌne wɨdaayadei dɨngaka? Namwaalyɨsarɨ yɨlamwaalaka tɨka munne nada aꞌmwe dazai sahwalyɨra. Kɨrɨꞌ sarɨmɨnyɨ tɨnnyaba sarɨmɨnyɨ gaimwanga yaꞌneinyɨ yɨhɨthaayadeibɨsainyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nɨmɨnyɨ yɨjɨwaalaꞌne yɨmaꞌnakegaaꞌ sarɨmɨ kwaihɨlyɨ kuna nyeꞌmwannamwaaimanɨgasaihɨlyɨ. Nyagalyaꞌmakuvanɨgataihi mɨka. ");
INSERT INTO byr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sarevɨ nɨmɨnyɨna Nɨmaamaangei maremwaalyaburɨ nyɨjaavakabaaibɨꞌ sarɨmɨnyɨna maremwaalyabwi yɨhɨzaavɨdeinyɨra. ");
INSERT INTO byr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nɨmɨre maremwaaidɨnyainyɨre yɨꞌbɨnyavɨ tɨꞌmunne nyeꞌmwannanadɨvɨꞌ aalya nyeꞌmwannanyaꞌneihi yɨhɨzaavɨdeihɨlyɨ. Nabaai kingɨyaraavɨre namwaalyɨsaraavɨ mwaalapɨri aꞌmwe Yɨzɨrelɨya yɨta savakaavɨya sɨvɨlɨrɨdaaꞌnya pwaraalyaraavɨne yawɨbwaꞌdɨvɨsaihi dɨmwaalyideihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saaimonɨ! Saaimonɨ! Yɨthaa! Kayaaꞌnanyai Saataanɨ sarɨmɨnyɨ maaryaꞌna mena wɨdɨwakeihɨlyɨ. Witɨya asasɨ gɨrɨdavalɨlɨvaidevaaibɨꞌ yɨjɨwaalyaꞌneihɨrɨ walayɨhɨvapalakadeihɨlyɨra. ");
INSERT INTO byr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sare kɨrɨꞌ Gotɨyarɨ gɨmɨnyɨna dara yɨdaangamweigɨnyɨ ‘Saaimonɨmɨre dɨragɨnna lɨmwagasabwi mimaananna!’ Sareigɨ nɨmɨnyɨna ayɨna gɨnyɨmaꞌnaawaꞌgɨzɨ baꞌgɨzɨyaigɨ gɨmɨjɨya jaꞌmweraavɨ jɨvaimwadeigɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Sara wɨdɨna kyaꞌ sai wɨdɨna “Naangeigɨ, gɨmɨjɨ kalavuzangevɨna yeꞌmwannɨgwɨyaꞌnajɨ gɨmɨjɨ yeꞌmwannabalyaꞌnajɨ mena yawɨmaꞌnɨweinyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Sara wɨdɨna kyaꞌ sai wɨdɨna “Pitaigɨ gɨthɨvanɨge. Sawɨta datharɨkɨ yɨrɨkunyagaaꞌ kukuraayai jaka majadoriyagaaꞌna dahasaai dahaaꞌ ‘Jizaazarɨ mwanganyainyɨra,’ duthatheigɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sai yuya sahwaraavɨ wɨdɨna “Sɨnnawɨ kɨgaaꞌ nɨmɨ yɨhɨmaryaaseihi, nɨgwɨpaawɨzɨyajɨ gɨlyajɨ kwaariꞌmasɨvɨlyajɨ mamakwɨyɨ yesaihɨlyɨ. Dazahɨgaaꞌ sarɨmɨ gɨlyɨvɨta pɨrɨꞌ kɨrɨꞌ yɨhɨmudaasakeihi daaka?” Wɨdɨna kyaꞌ sahwara wɨdɨna “Aawa. Nemɨnyɨ aane pɨrɨꞌ kɨrɨꞌ mɨka!” ");
INSERT INTO byr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wɨdɨna kyeꞌ sai wɨdɨna “Kɨrɨꞌ dahaaꞌ aꞌmwei nɨgwɨpaawɨzɨya kɨnɨnnakei sai saꞌ nayaa maarana! Gɨlya kɨrɨsɨ avaala sara jɨla! Aꞌmwei kwaariꞌmasɨramɨnya maayai gannya yɨvɨsaꞌ nɨgwianna mubɨna yojɨ kwaariꞌmasɨramɨnya pɨrɨꞌ mubathelyɨra. ");
INSERT INTO byr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sareꞌ dareꞌnesɨ. Dara yɨhɨthɨvanɨge. Gotɨyare bukuyavɨ yɨdaꞌnɨkeꞌ yunebanna nɨmɨnyɨ nyɨmaꞌnana! Dareꞌ dɨnɨꞌ ‘Aꞌmwe kɨwɨnyangɨ galazekɨvaidɨvɨsarajɨ yeꞌmwagakɨpɨꞌdelyɨra.’ Sareꞌ dareꞌnesɨ. Yuna dazahɨrɨsaꞌna nɨmɨnyɨna yɨdaꞌnɨke dazaꞌ, saꞌ yunebanna dahaaꞌ nebwina nyɨꞌmwannadeꞌnanyɨ. (Aꞌmwera nɨmɨnyɨna kayaaꞌna yawɨꞌmanɨgatabaaibɨꞌ nabaai sarɨmɨnyɨna yawɨpɨꞌdevɨna yɨhɨthɨwa.)” ");
INSERT INTO byr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sara wɨdɨna kyaꞌ sahwara wɨdɨna “Naangeigɨ, yɨthaa, kwaariꞌmasɨramɨnya pɨrɨwaai dathawaalaakana!” Wɨdɨna kyeꞌ sai wɨdɨna “Saꞌ yɨnɨga wiꞌnanyɨra!” ");
INSERT INTO byr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Anga naangebadaaꞌnyai walyawoka yuyagaaꞌ ayabanna widaawadeva Mugunya Wolivɨnei kaanna wɨna yadaaꞌnyɨ mɨdɨdɨvɨsara sahwarɨ mɨdɨnna. ");
INSERT INTO byr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sara yadaapɨjɨ sɨmagɨ kɨba mena yɨꞌmavaka sahwaraavɨ wɨdɨna “Naangerɨ nayaa duzɨla! Yɨjɨwaalaꞌne kayaaꞌnanyabwi sarɨmɨnyɨ nyɨhɨbɨramaaradɨka!” ");
INSERT INTO byr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wɨdɨna yaka saraavɨ yagalyaꞌmaꞌna yaka menya sangirɨꞌ aꞌmwei sɨla lɨwakadaaꞌnyɨ waꞌdaawadevanna wɨna. Miꞌna wɨna yaka kwadaai walagina yaka wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Nɨmwai, gɨmɨ tewaanna nyawɨraꞌgɨzɨ kaapɨvananya dai dɨmarasɨꞌdevaaibɨꞌ balyaꞌne daꞌ dɨmarasɨka! Sareꞌ kɨrɨꞌ nɨmɨrebwi mamɨdɨdɨnna! Aawa. Yune gɨnnyabwina dɨmɨdɨna!” ");
INSERT INTO byr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Wɨdɨna kyaꞌ Sɨgunyavɨdaaꞌnya ejelɨya pwai gamɨnyawɨnna walaabɨna yaka dɨragɨnna yɨvaimwanna. ");
INSERT INTO byr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sagaaꞌ Jizaazai gamɨre kɨlaakejɨkɨ taanga naanga widaaꞌnyɨ yɨbwakɨda Gotɨyarɨna dɨragɨnna naanga kuna wɨdɨna. Sara wɨdadaaꞌnyɨyavɨ gamɨre dɨkwagɨlyaꞌ taweꞌbɨꞌ yɨmaꞌnyɨna yaka kwaakevakɨna bwalaravaawɨna. ");
INSERT INTO byr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bwalaravaawɨna kyaꞌ mena wɨdakegaaꞌ daavɨna yaka gamɨreraayawɨnnei kaanna wɨna. Sarei gamɨreraavɨ tɨnna dara wanganakeꞌ “Se dakava!” Sɨmunyai taanga winaꞌdaaꞌnyɨ, sarevɨdaaꞌnyɨ waꞌdapi. ");
INSERT INTO byr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Sara daka wɨdɨna “Se daꞌ beꞌneꞌ wakava! Dɨkaavapɨjɨ Gotɨyarɨ duzɨla! Sarɨmɨnyɨ yɨjɨwaalaꞌne kayaaꞌnanyabwi bozɨ nayɨhɨlɨmwagathɨka!” ");
INSERT INTO byr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sahwai yagaalyaꞌ kuna dadaaꞌnyɨyagaaꞌ, yɨthaa, kwalaalyara yɨkabɨna. Aꞌmwe dazai Juthaazai woꞌnɨkei, sai sɨvɨlɨrɨdaaꞌnyɨ pwaraalyaraavɨdaaꞌnyai, yɨ sahwai wibwarɨdaakuna. Sarei maangwɨdaayɨlaaya yaꞌnei Jizaazaryaba aya kɨbanna wɨlaabɨna. ");
INSERT INTO byr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Wɨlaabɨna kyaꞌ kɨrɨꞌ Jizaazai wɨdɨna “Juthaazaigɨ, Aꞌmweraavɨne Kaimɨraayarɨ maangwɨdaayɨlaaya yɨwaanyaꞌ yɨ dazaꞌ nɨmɨre yɨkamaangeraavɨ nyɨmarɨmwangɨdeꞌna daaka!” ");
INSERT INTO byr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wɨdɨna kyaꞌ gamɨnyaba daavesara yɨmaꞌnyavɨna yawɨranganna yeva dɨna “Naangeigɨ, dahwaraavɨ nemɨ kwaariꞌmasɨramɨnyasɨ tamakaadeꞌna gɨmɨ gara yawɨꞌmwaana?” ");
INSERT INTO byr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dɨna kyeꞌ gamɨre pwai Gotɨyarɨna Mubɨthɨka Yɨraꞌde Naangere wɨdaayaderɨ mala yarai tamɨna yaka kadɨka aangasɨmagɨnyɨꞌ yuna dakuꞌna kyaꞌ bwalaraawɨna. ");
INSERT INTO byr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sare savɨ Jizaazai tɨnna wanganaka jaꞌnawɨdɨna “Sabwi mipɨna!” Sara wɨdaka aꞌmwe dazare kadɨkikyaba ata dathɨwanna yɨna yaka aꞌmwerɨ ayɨna tewaanya padaꞌgalawɨmwaaihɨna. ");
INSERT INTO byr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tewaanya padaꞌgalawɨmwaaihɨna yaka Jizaazai Gotɨyarɨna yɨraꞌdɨvɨta naangerajɨ Gotɨyare Angevɨ maremwaaidɨvɨsarajɨ aꞌmwe naangerajɨ sara gamɨnyɨ galalɨmwangeꞌna yɨkabesaraavɨ wɨdɨna “Kuka yɨpalasɨꞌnaderɨ yɨravɨmaaryaꞌneihi badɨvɨtabaaibɨꞌ kwaariꞌmasɨramɨnya darɨkajɨ kɨlɨka dajɨ makabɨwaata daihi bɨwaasaihi daaka! ");
INSERT INTO byr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yuya yɨrɨkerɨkaavɨ Gotɨyare Angevɨ sarɨmɨjɨ yɨhyeꞌmwannemwaaidɨnyainyɨra. Sare sagaaꞌ galanyɨlɨmwadɨvɨtainyɨ mɨka. Aawa. Dahaaꞌ sagaaꞌ yuna sarɨmɨregaakɨra. Dahaaꞌ jɨhɨnyavɨre dɨragɨnyaꞌ wavɨlavadehaakɨra.” ");
INSERT INTO byr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sarɨ galalɨmwanna yeva makuna. Gotɨyarɨna Yɨraꞌde Naangere angevɨna makwina. Sagaaꞌ Pitai kwalyɨ mɨdɨnna yake kwai kɨrɨꞌ menyaba sangirɨꞌ mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Angwɨrɨka byarihwinaakevɨ dɨkeꞌ yɨraꞌna yeva mwaihulɨna. Sara mwaaidapiyaba dɨvidaaꞌnyɨ Pitai walajaꞌnagaimwaaina. ");
INSERT INTO byr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sarei dɨkevɨ mwaaidɨꞌnyɨ wɨdaayade aꞌmwe pɨrɨꞌ tɨnna wanganna. Wɨdaayade dazaꞌ baihanaꞌna yaka wɨdɨna “Aꞌmwe dazai kwalyɨ sahwalyɨ yeꞌmwannemwaaidakɨlyɨ wangamwaꞌdelyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dɨna kyaꞌ kɨrɨꞌ sai “Aawa,” wɨdɨna yaka wɨdɨna “Aꞌmweꞌgɨ nɨmɨ mwanganyainyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wɨdɨna kyaꞌ dɨvi maalɨkegaaꞌ aꞌmwe pwai tɨnna wanganakei wɨdɨna “Gɨmɨ kwaigɨ sahwarajɨyaigɨnyɨra.” Sara wɨdɨna kyaꞌ Pitai wɨdɨna “Aꞌmwaagaigɨ, nɨmɨ sahwainyɨ mɨka!” ");
INSERT INTO byr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Dɨvi kɨbawa nyihaanya pɨrɨꞌ mena kabwawaꞌ aꞌmwe pwai dɨragɨnna wɨdɨna “Naanga nebulyasɨ. Aꞌmwe dazai kwalyɨ yeꞌmwannemwaaidelyɨra. Sareꞌ dareꞌnesɨ. Sai aꞌmwe Galɨlidaasalyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wɨdɨna kyaꞌ kɨrɨꞌ Pitai wɨdɨna “Aꞌmwaagaigɨ, yagaala dɨwaanya savɨ nɨmɨ myawɨryainyɨra.” Sai kuna dadaaꞌnyɨ jaahwasaꞌbɨꞌ kukuraayai jaka dɨna. ");
INSERT INTO byr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jaka dɨna yakegaaꞌ Naangei gɨnyɨmaꞌnyɨna yaka Pitarɨ maranganna. Pitarɨ maranganna kyaꞌ sai ayɨna yawɨꞌna yagaala Naangei wɨdaka saꞌna. Sagaaꞌ dara wɨdakeꞌna “Sawɨta dazarɨkɨ kukuraayai jaka majadori gɨmɨ dahasaai dahaaꞌ dɨthatheigɨnyɨ ‘Jizaazarɨ mwanganyainyɨra.’ ” ");
INSERT INTO byr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Sara yawɨꞌna yaka mwasɨlaanna walyuna yaka kɨnna walyadɨna. ");
INSERT INTO byr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Aꞌmwera gamɨnyɨ galalɨmwanna yeva bɨraiyagaala wɨdadɨvɨꞌ mala tamɨna ");
INSERT INTO byr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","yadɨvɨꞌ kwaabɨyɨvɨsasɨ gamɨre tɨnnyarɨ kawaaka yɨrakɨna yeva yɨdaanganna “Gotɨyarɨ wɨꞌnawɨdadɨnyabaaibɨꞌ dɨnedana! Malyaꞌ aai gɨramanɨka!” ");
INSERT INTO byr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yagaala kayaaꞌnanya kwalaalya pɨnɨjɨ bɨraizɨka wɨdɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nyɨlyai bilyɨrɨꞌdaasɨyagaaꞌ aꞌmweraavɨre aꞌmwe naangera savaakɨyara, Gotɨyarɨna yɨraꞌdɨvɨta naanga kwarajɨ Kɨwɨja kwarajɨ sara yɨꞌbwaꞌnemwaaina. Sarera gamɨnyɨ kumɨre kaajolɨyaraayawɨnna makuna yɨna yeva wɨdɨna ");
INSERT INTO byr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Gɨmɨ Kɨraazɨtɨyaigɨ mwaaidɨzaigɨ dɨnedana! Kɨraazɨtɨyaigɨ daaka?” Dɨna kyeꞌ sai wɨdɨna “Nabaai nɨmɨ yɨhɨthɨwɨjaꞌ sarɨmɨ dɨragɨnna myawɨralɨmwagi jideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nabaai yagaala pɨnɨnna yɨhithaangamujaꞌ, nɨmɨre yɨhɨthɨwɨjavɨ dɨnyɨjaꞌnajideihi mɨka! Arɨkewɨ. ");
INSERT INTO byr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kɨrɨꞌ dahaasɨ yuya dɨvi kɨgaasɨ Aꞌmweraavɨne Kaimɨraayai Gotɨyare aangasɨmagɨ dɨragɨnya naangesɨyaba walamwaaladelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wɨdɨna kyaꞌ yuyara wɨdɨna “Sarevɨdaaꞌnyɨ yuna gɨmɨ saigɨ Gotɨyare Kaimɨraayaigɨ daaka?” Dɨna kyeꞌ sai wɨdɨna “Sarɨmɨ saihi dɨwaasaꞌ. Yɨ nɨmɨ sahwainyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wɨdɨna kyaꞌ sahwara dɨnyɨna “Yagaalyaꞌ jalɨkurakyaraavɨreꞌ kadɨkeꞌ ayɨna beꞌna wɨꞌnaajɨwona! Sareꞌ dareꞌnesɨ. Gamɨre maangikɨdaaꞌnyɨ yagaala dazaꞌ kadɨwaꞌ nemɨ mena wɨꞌnɨwona.” ");
INSERT INTO byr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aꞌmwe yuyara daavɨna yeva gamɨnyɨ maarɨna yeva Paailatɨmyabanna makuna. ");
INSERT INTO byr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Sara yeva kotɨyaꞌ gaai marina yadɨvɨꞌ wɨdɨna “Nemɨ aꞌmwe dazarɨ tɨnna wangamanɨgolyɨ. Nemɨjɨya yɨta savaakɨyaraavɨrebwi yɨpalasɨꞌda gamɨrebwi yɨvanɨkelyɨra. Sizaarɨ taakɨzɨya wɨjaayaꞌnajɨ kɨmaakɨya nedakɨvanɨkelyɨra. Nedadelyɨ ‘Nɨmɨ sainyɨ Kɨraazɨtɨyainyɨra. Kingɨyainyɨra.’ ” ");
INSERT INTO byr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Wɨdɨna kyeꞌ Paailatɨ sahwarɨ yɨdaanganna “Gɨmɨ Juyaraavɨre kingɨyaigɨ daaka?” Wɨdɨna kyaꞌ Paailatɨmɨ jaꞌnawɨdɨna “Gɨmɨ saigɨ sara dɨwaanyaꞌ sahɨrɨsɨra.” ");
INSERT INTO byr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Wɨdɨna kyaꞌ Paailatɨ Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ kwala bwaꞌnaanyavɨyarajɨ saraavɨ wɨdɨna “Aꞌmwe datharɨ gamɨre yɨwetawakya aane pɨmɨlɨꞌ mabɨramaariwana!” ");
INSERT INTO byr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sarevɨ kɨrɨꞌ sahwara naanga dɨragɨnna kuna wɨdɨna “Sahwai aꞌmweraavɨ aꞌmwemɨlɨkaavɨ yagaala wɨjɨwaakada Juthɨya sɨmagɨ yunebanna lɨka yɨwainɨgwimanaawɨgasalyɨra. Galɨli sabadaaꞌnyɨ yamaaꞌdei sasare sabwi mɨjɨmabada yune davannanyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Paailatɨ kadɨka sara wɨꞌnaka sahwaraavɨ yɨdaanganna “Aꞌmwe dazai Galɨli mwaalyai daaka?” ");
INSERT INTO byr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yɨdaanganna yaka kumɨre jaꞌnawɨjaꞌ “Aꞌmwe kwaaka Erotɨyai maremwaaide sɨmagɨdaaꞌnyalyɨra,” kadɨka wɨꞌnaka yawɨbwaryaꞌnei Erotɨyaryawɨnnerɨ maryaasɨna. Dazagaaꞌ kɨgaaꞌ Erotɨyai kwalyɨ Jeruzaalemɨ mwaaidɨꞌnyɨ. ");
INSERT INTO byr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Maryaasɨna kyaꞌ Erotɨyai Jizaazarɨ tɨnna wanganaka yɨlaaya naanga yɨna. Sareꞌ dareꞌnesɨ. Sahwarɨna yagaalyaꞌna kadɨka wɨꞌnadei, saamɨnyagaaꞌ kuna “Sahwarɨ yɨwarɨma!” yawɨꞌdei. Nabaai “Sahwai atɨka maruꞌnata pɨrɨꞌ wɨjɨwaainyaꞌ kyojɨ wanganɨma!” yawɨꞌdei. ");
INSERT INTO byr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sare sagaaꞌ Erotɨyai kwalaalyanna bithangamuna. Sareꞌ Jizaazai gamɨre yagaalyangɨna yagaala aane pɨrɨꞌ kɨrɨꞌ mujaꞌna muraayɨ. ");
INSERT INTO byr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mujaꞌna muraayɨ kyaꞌ Gotɨyarɨna yɨraꞌdɨvɨta naangerajɨ Kɨwɨjarajɨ sara gamɨnyaba bahaidaaꞌna yɨna yeva kotɨyaꞌ dɨragɨnna marina. ");
INSERT INTO byr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Sara yadaapi Erotɨyai gamɨre aawɨlasarajɨ yuna kayaaꞌna jɨwɨꞌnyɨna yada bɨraiyagaalyajɨ wɨdɨna. Miꞌna wɨdɨna yeva bɨralyaꞌna kingɨyare yɨvɨta nawɨꞌnyaanga pɨrɨꞌ maarɨna yeva marabwakaabɨna yeva Paailatɨmyawɨnna ayɨna maryaasɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sɨnnawɨ kɨgaaꞌ Erotɨyai Paailatɨjɨ yɨkamaanga yɨmaꞌnagɨlyaraalyɨ. Kɨrɨꞌ dahaaꞌ saraai nyaꞌmwana dɨnagɨla nawɨꞌnyɨna mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Paailatɨ Gotɨyarɨna yɨraꞌdɨvɨta naangeraavɨjɨ aꞌmwe naangeraavɨjɨ aꞌmweraavɨjɨ jaka wɨdɨna kyaꞌ sarera biꞌbwaꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Biꞌbwaꞌnyɨna kyeꞌ sai wɨdɨna “Aꞌmwe nɨmɨnyawɨnna nyɨmakabɨwaata dazarɨna sarɨmɨ dɨwaaꞌ ‘Aꞌmweraavɨrebwina nemaruwɨnakadelyɨra.’ Sareꞌna nabaai sarɨmɨre tɨnnyarɨ yɨdasaba yagaala dazahɨrɨꞌneꞌna yɨdangadaari. Yɨthaanyi! Sarɨmɨ kotɨya marivanɨgata dazaꞌneꞌ nɨmɨ gamɨre yɨwetawakya aane pɨrɨꞌ kɨrɨꞌ mabɨramaariwelyɨra. ");
INSERT INTO byr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aawa. Erotɨyai kwalyɨ avaala sana yɨwakelyɨra. Sara yaka nemɨnyawɨnna nemaryasɨwaabɨkelyɨra. Yɨthaanyi! Aꞌmwe dazai nemɨ yɨnɨga wiꞌna maratamarɨmwaadeꞌ yɨwetawakya aane pɨrɨꞌ kɨrɨꞌ yadei mɨka! ");
INSERT INTO byr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Sarevɨdaaꞌnyɨ wɨlyabaalyɨna lɨꞌbwaraꞌmujɨ wɨdaasɨdelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kumɨrebwi sasarebwi yadɨvɨsara “Yuya Pariꞌmaꞌmunne tewaanya sarɨkaavɨ Paailatɨ aꞌmwe kalavuzarɨ kumɨnyɨna wɨmaaryadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sagaaꞌ kwala bwaꞌnaanyasɨ jaka naangaꞌna dara dɨna “Yɨsavɨri dɨmaratamarɨmwia! Sara yaꞌgɨzɨ Baravaazai nemɨnyawɨnna dɨnejaama!” ");
INSERT INTO byr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baravaazai sai anga naangeba gaꞌmaanɨyaraavɨ mala bwaꞌdelyɨ. Sara bwaꞌda aꞌmwerɨ tamakadaaꞌnyɨ kalavuzavɨ wɨmwaaihɨnɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jaka sara kadeꞌ Paailatɨ “Jizaazarɨ wɨdaasɨdeꞌnana,” yawɨraka ayɨna jaka wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sara yadaaꞌnyɨ jaka wɨdɨna yeꞌ “Maaraꞌgɨzɨ yɨsavɨri jeramo! Yɨsavɨri jeramo!” ");
INSERT INTO byr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jaka sara wɨdɨna kyeꞌ dahasaai dahaaꞌ wɨdɨna “Beꞌnanaka! Aꞌmwe dazai be kayaaꞌnanyabwi yɨwakalaka! Nemɨ gamɨnyɨ yɨnɨga wiꞌna maratamarɨmwaade kayaaꞌnanya aane pɨrɨꞌ kɨrɨvɨ mabɨramaariwelyɨra. Sarevɨdaaꞌnyɨ wɨlyabaalyɨ lɨꞌbwaraꞌmujɨ maryaasɨma!” ");
INSERT INTO byr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wɨdɨna kyaꞌ kɨrɨꞌ jaka dɨragɨnna naangaꞌna dɨna yɨna yeva jaka naanga dɨragɨnna kuna dɨna, “Sahwarɨ maaraꞌgɨzɨ yɨsavɨri jeramo!” Kumɨre jaka naanga bathɨwaweta sa Paailatɨmɨre yagaalyaꞌ dathɨwanna. ");
INSERT INTO byr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Sara kyeꞌ Paailatɨ kumɨre yagaalyangɨ mɨdɨnna. ");
INSERT INTO byr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Aꞌmwera jaka wɨdɨna aꞌmwe kalavuzavɨ mwaaidɨꞌnyɨya sarɨ ayɨna maaryaꞌna gaꞌmaanɨyaraavɨ mala bwaꞌda aꞌmwerɨ tamakakerɨ sagaaꞌ Paailatɨ kumɨre asɨrɨna wɨmaarina. Kumɨreburɨ mɨdɨnna yaka Jizaazarɨ aawɨlasaraavɨre asɨrɨna wɨmarɨmwaaihɨna. ");
INSERT INTO byr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Gamɨnyɨ makwodɨvɨꞌ aꞌmwe pwarɨ Saaimonɨ Saairini mwaalyarɨ galalɨmwanna. Sai anga naangeba wɨlaawiaꞌnei tutaanyavɨ kaanya yɨdɨꞌnyɨ. Galalɨmwanna yeva yɨta yovihɨrarannɨkeꞌ gamɨre egwevɨ yɨlamarakɨna kyeꞌ yɨkwavamakwoda Jizaazarɨ mɨdɨnna. ");
INSERT INTO byr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mɨdɨnna yadaaꞌnyɨ kwala bwaꞌnaanya naanga, aꞌmwerajɨ aꞌmwejɨ gamɨnyɨ mɨdɨnna. Aꞌmwe sa kale wiadaaꞌnyɨ kɨnna dadɨvɨꞌ kaladaasajɨ damɨdɨnna. ");
INSERT INTO byr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Damɨdɨnna yadaapi Jizaazai gɨnyɨmaꞌnyɨna yaka wɨdɨna “Aꞌmwe Jeruzaalemɨdaasangihi, nɨmɨnyɨna kɨnna madɨpɨnera! Aawa. Kɨnnyaꞌ yune sarɨmɨnyɨneꞌnajɨ sarɨnnya kaimɨraayangɨnajɨ dɨzideꞌnera. ");
INSERT INTO byr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yɨthaanyi! Sareꞌ dareꞌnanyɨ. Dɨvi pɨgaaꞌ yɨmaꞌnajahaaꞌ dɨpɨꞌde ‘Aꞌmwe kaimɨraayanna yagɨnyajɨ bwaraminya kwazɨka kɨnɨnnakejɨ aamunya myaayadɨvɨsajɨ kumɨ sa yɨlaaya yadɨvɨꞌ tewaanaanga winadengɨra.’ ");
INSERT INTO byr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dazagaaꞌ aꞌmwera mugunyangɨ dangabɨꞌdengɨ ‘Mugunya keꞌnɨngihi bwalanelamwaalyɨla!’ Mugunya maalɨkerɨkaavɨ wɨdɨpɨꞌde ‘Mugunya ketɨrɨkaavihi bwalanelamwalabaihɨrakyɨla!’ Lɨka naanga yadɨvɨꞌ sara dɨpɨꞌdere. ");
INSERT INTO byr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sareꞌ dareꞌnanyɨ. Yɨta gaalyarɨ dɨkeꞌ navɨridevaaibɨꞌ tewaanyainyɨ kɨrɨꞌ nyɨramakɨpɨjaꞌ yɨ yɨta yawakerɨ dɨkeꞌ yarai nasɨꞌdevaaibɨꞌ kayaaꞌnanyaihɨrɨ gathaꞌdareꞌ yɨhimaꞌnadeihɨlaka!” ");
INSERT INTO byr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aꞌmwe pwaraai kwaraarɨjɨ makuna. Aꞌmwe saraai kayaaꞌnanyabwi yadisaraarɨ. Saraai gamɨnyɨjɨ yeramyaꞌneraarɨ. ");
INSERT INTO byr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kaanya makuna yadɨvɨꞌ pɨba Gɨlemɨnyagɨnyaba woꞌnɨkebanna yɨꞌmavaawɨna yevegaaꞌ dazahɨba gamɨnyɨ yɨsavɨri wɨrameꞌ. Nabaai aꞌmwe kayaaꞌnanya saraai kwaraarɨjɨ yerameꞌ. Pwarɨ gamɨnyɨ aangasɨmagɨ tamɨna, pwarɨ kwanaamimagɨ tamɨna. ");
INSERT INTO byr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yɨsavɨri kurameꞌ Jizaazai wɨdɨna “Nɨmwaigɨ, kumɨre kayaaꞌna yɨwaata davurɨ tɨvɨkɨta dɨmarasɨka! Sareꞌ dareꞌnesɨ. Yɨvanɨgata dahɨbwina myawɨryarera.” Wɨdɨna kyaꞌ aawɨlasara gamɨre kwaabɨyɨvɨta saza maramunyɨna yeva saatuyara gɨrɨdaꞌgɨrɨdata yeva pwai wavɨlavakei pɨvaaꞌ maarɨna. Sana sana yeva yuyara yunebanna maarɨna. ");
INSERT INTO byr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sare savɨ aꞌmwera bathakuna yeva baihanaꞌna. Sahwara baihanaꞌna yadaapi aꞌmwe naangera gamɨnyɨ bɨraiyagaala wɨdanganna “Sai aꞌmwe pwaraavɨ padaihasamaaꞌna mena yakelyɨ. Gotɨyare Kɨraazɨtɨyai, Gotɨyai dahɨlakadei mwaalajaꞌ yɨ sarei gamɨ sai padaihasamaaꞌnana! Nabaladɨka!” ");
INSERT INTO byr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bɨraiyagaala wɨdanganna yadaapi aawɨlata kwarajɨ bɨraiyagaala wɨdɨna yadɨvɨꞌ gamɨnyabanna wɨlaabɨna yɨna yeva “Waainɨya yɨrɨkeꞌ wɨjavaana!” deva yaamɨjɨ makina yeva ");
INSERT INTO byr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","dara dɨna “Juyaraavɨre kingɨyaigɨ mwaaidɨzaigɨ gɨmɨ saigɨ dɨvadaihasamaaꞌna!” ");
INSERT INTO byr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pɨkarya pɨrɨꞌ gamɨnyɨ munyaba yɨdaꞌnɨkeꞌ dɨna “Aꞌmwe dazai Juyaraavɨre Kingɨyalyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aꞌmwe kayaaꞌnanya tamarɨmweta saraarɨdaaꞌnya pwai gamɨnyɨ bɨrala wɨdɨna “Kɨraazɨtɨyaigɨ daaka! Gɨmɨ saigɨ dɨvadaihasamaaꞌnana! Nabaai naarɨmɨ kwainaarɨjɨ dɨnehɨvadaihasamaaka!” ");
INSERT INTO byr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bɨrala sara wɨdɨna kyaꞌ kayaaꞌnanya pwai yagaala dazaꞌ kadɨka wɨꞌnaka maanga wɨdɨna “Sahwalyɨ daangeꞌ avaaina maꞌmwaanyaꞌna Gotɨyarɨna lɨka mijɨwaana! ");
INSERT INTO byr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Naarɨmɨnyɨ nehɨramwaasaꞌ, saꞌ tewaanya yɨdasabwi yɨwaasasɨ. Sareꞌ dareꞌnesɨ. Naarɨmɨ taanga maaꞌmwola davwi naarɨmɨ yadata yuna yɨdata sabwina maaꞌmwoi. Kɨrɨꞌ aꞌmwe dava dai yɨwetawakya aane pɨrɨꞌ kɨrɨꞌ myadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wɨdɨna yaka wɨdɨna “Jizaazaigɨ, dɨvi dɨragɨnna maremwaalaꞌgɨzɨ nɨmɨnyɨna nayaa dɨnyawɨꞌdeigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Dɨna kyaꞌ sai wɨdɨna “Nebulyaꞌna gɨthɨwa ‘Yuna dahaasagaaꞌ nɨmɨjɨ anga Tewaanyaba dɨmwaaideꞌnanyɨ Parathaazɨ.’ ” ");
INSERT INTO byr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nyɨlyagaaꞌ sɨrɨgwajahaaꞌbɨsagaaꞌ yɨmaꞌnyɨna kyaꞌ nyɨlyai balɨna. Sarevɨ jɨhɨnyaꞌ anga yuneba jɨnnaraka yune sawɨꞌjɨhɨnyaꞌ tɨri kɨlokɨyagaaꞌna sawɨsɨrɨ. ");
INSERT INTO byr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Yɨrɨkeꞌ yɨmaanyɨna yaka dɨvidaaꞌnyɨ Gotɨyare Angevɨya kwaabɨyɨvɨta naangeꞌ jɨkɨꞌnadaaꞌdɨꞌnyɨya janne saꞌ yuneba kayaaka lihɨꞌna yɨna yaka pɨvakaai yɨmaꞌnyɨna. ");
INSERT INTO byr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sagaasagaaꞌ Jizaazai jaka naanga dɨragɨnna wɨdɨna “Nɨmwai nɨmɨre kuryai gɨmɨre asɨrɨ gwakɨwana.” Sai sara wɨdɨna yaka gannya kuryarɨ yaasɨna. ");
INSERT INTO byr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yaasɨna kyaꞌ aawɨlasaraavɨ maremwaaidei dazangɨ tɨnna wanganaka Gotɨyarɨne yayaꞌ munyaba makɨlaka sai dɨna “Yuna nebulyasɨ. Aꞌmwe dazai yuna yɨdaꞌmaraangelyɨra.” ");
INSERT INTO byr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Dɨna kyaꞌ kwala bwaꞌnaanya baihanasaꞌna biꞌbwaꞌnesara yɨmaꞌnaka sangɨ tɨnna wanganeva kunnya kɨhɨsangɨ kaleꞌna mala tannadɨvɨꞌ kaanna ayɨna yɨkwaweꞌ. ");
INSERT INTO byr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Sarevɨ gamɨre yuya gyaꞌmwerajɨ aꞌmwe Galɨlidaaꞌnyɨ yawɨmaꞌneva gamɨnyɨ mɨdɨnaabesamɨlɨkajɨ sangirɨꞌ menyaba daaveva yuya yɨmaꞌnaka dazangɨ tɨnna wanganeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Yɨthaa! Aꞌmwe pwai Jozepɨyai woꞌnɨkei Juyaraavɨre Anga Aarɨmathɨya sabadaaꞌnyai mwaalɨna. Sarei Juyaraavɨ kaajolɨyai, aꞌmwe tewaanyai yune yɨdaꞌmaraangei ");
INSERT INTO byr_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","kaajolɨya pwaraavɨre sɨmunyabwinajɨ kumɨrebwinajɨ aala wɨvuꞌnadei, sai Gotɨyai aꞌmweraavɨ maremwaaidevɨna yemwaaidelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aꞌmwe dazai Paailatɨmyawɨnna kaanna wɨna yaka sahwarɨ Jizaazare kɨlaakejɨꞌ maaryaꞌna yɨdaanganna. ");
INSERT INTO byr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sara yaka yagaalyaꞌ maarɨna yaka wɨna yaka yɨsavɨdaaꞌnyɨ gamɨre kɨlaakejɨꞌ makwalaabɨna yɨna yaka kwaabɨyɨvɨta yaakesɨ yewaaꞌbwaꞌna yɨna yaka simaangevɨna wɨlakaawɨna. Simaanga dazaꞌ sɨla naangevɨ lɨlɨsɨwinɨkeꞌ. Sɨnnawɨ kɨgaaꞌ aꞌmwe bainɨka aane pwai kwarɨ mulakɨbwaayavɨ, mudɨꞌna wakaꞌ. ");
INSERT INTO byr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sagaaꞌ yɨrɨka tɨka munne yovɨrawakyaꞌnerɨkɨra. Kwazaakegaaꞌ maalɨkegaaꞌ yɨmaꞌnyaꞌnegaakɨ. ");
INSERT INTO byr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jozepɨyai sara yadaaꞌnyɨ aꞌmwe Galɨlidaaꞌnyɨ yawɨmaꞌneva Jizaazarɨ mɨjɨmabesa sahwarɨ mɨjamakuna. Yevemɨlɨka simaanga dazavɨ tɨnna wanganna yeva gamɨre kɨlaakejɨꞌ sara wakɨnɨkejɨꞌ tɨnna wanganna. ");
INSERT INTO byr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tɨnna mena wanganna yeve sagaaꞌ kunnya angengɨna ayɨna kaanna wɨna. Saremɨlɨka marazɨnanyajɨ welivananya wabatɨrɨnnaka nawɨꞌnyajɨ yovɨrawakɨna yeꞌ. Sara yevemɨlɨka kwazaakegaaꞌ kɨwɨnyaꞌ sara dɨnɨkevɨna kave mwaalɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wikɨya mudɨkerɨkɨ Saadehaaꞌ, byaaka wanyɨwanya yakegaaꞌ simaangeyabanne kaanna wɨna. Sɨnnawɨ mena tɨviꞌna yovɨrawaketa welivananya nawɨꞌnya tɨrɨnnaka sajɨ maarɨna yeva makuna. ");
INSERT INTO byr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sare dara wanganesaꞌ “O, sɨlyai kengimagɨ mena mwarangɨramwaihɨwaasai daaka!” Simaangevɨre tɨkuryavɨ marihɨꞌnaryadɨꞌnyɨ sara dɨna. ");
INSERT INTO byr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dɨna yeva kusawɨ wɨlɨna yeva dara wanganesaꞌ “O, Naanga Jizaazare kɨlaakejɨꞌ mwarijɨka!” ");
INSERT INTO byr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sara deve saꞌneꞌna sɨmunya kwalaalya yawɨꞌdaaꞌnadɨvɨꞌ navɨꞌnavɨka yɨdaaꞌnyɨna. Sara yadɨvɨꞌ, yɨthaa, aꞌmwe pwaraai kumɨnyabanna yɨmaꞌnaabahɨla daaꞌdakɨlyɨ wanganna. Saraai kɨrɨmɨre baazɨꞌmaꞌnyawaarɨdaaꞌnya lɨvamwadadaaꞌnyɨyaraai. ");
INSERT INTO byr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wanganna yeva lɨka naanga yadɨvɨꞌ kumɨre mɨnyagɨnya samwina tutaꞌnareva kwaakeyɨna baihanaꞌna yadapi saraai wɨdɨna “Aꞌmwe bainɨkeraavɨreba aꞌmwe gaala kɨnɨnnakerɨna beꞌna bɨꞌmanɨgatangihɨlaka! ");
INSERT INTO byr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Dava mwarika. Aawa. Mena yɨdɨkaaꞌmwakerɨnera! Sɨnnawɨ sai Galɨli kuna mwaalakegaaꞌ yɨhɨthaka dazaꞌna ayɨna jawɨrila! ");
INSERT INTO byr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Sai dara yɨhɨthaꞌ ‘Aꞌmweraavɨne Kaimɨraayai aꞌmwe kayaaꞌnanyaraavɨre asɨrɨ kumarɨmwangapɨjɨ yɨsavɨri tamarɨmupɨꞌdelyɨ. Sarei yɨrɨka darɨkaai darɨkɨ ayɨna dɨkaavadelyɨ.’ ” ");
INSERT INTO byr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sara wɨdɨna kyagi sa gamɨ kɨgaaꞌ yagaala wɨdaka sanna yawɨꞌna yɨna yeva ");
INSERT INTO byr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","simaangeyaba yagalyaꞌmakuna yeva sɨvɨlɨrɨdaaꞌnyɨ pwainanyaraavɨjɨ aꞌmwe yuya pwaraavɨjɨ yuya wanganeta dazanna wɨdaawɨna. ");
INSERT INTO byr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aꞌmwe sa, Maahɨthaala mwaalyaꞌ Maarɨyaasɨ Jowaanasɨ Maarɨyaaꞌ Jemɨzare ganaangesɨ sajɨ aꞌmwe pɨmɨlɨka yeꞌmwannamwaaina yesamɨlɨkajɨ sa apozelɨyaraavɨ yagaala dazaꞌ wɨdaawɨna. ");
INSERT INTO byr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sara wɨdaawɨna kyeꞌ kɨrɨꞌ sahwara yawɨꞌna “Aꞌmwe da kɨrɨbɨbɨyagaala dahanedɨwaava!” Sara yawɨꞌna yeva kumɨre yagaalyangɨ myawɨralɨmwagina. ");
INSERT INTO byr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sara yadaapi Pitai simaangeyabannei yarai kaanyaveꞌna wɨna yaka walarutaꞌnyɨna yaka keꞌmu kusawɨnna wanganaasɨna yakei kwaabɨyɨvɨsanna gavenna waꞌdɨꞌnyɨ wanganna. Sarei angebanna ayɨna wɨna yaka mena wanganaka sanneꞌna sɨmugwalaalya yawɨꞌna. ");
INSERT INTO byr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yɨthaa, yɨrɨka dazahɨrɨka sagaaꞌ kumɨnyɨdaaꞌnya pwaraai, saraai anga maalɨka pɨba Emayaazɨ woꞌnɨkebanna kaanya wɨna. Tuta saꞌ yune Jeruzaalemɨdaaꞌnyaꞌ Emayaazɨna yɨnamudarɨkeꞌ levenɨ kilomitaayababɨsaba. ");
INSERT INTO byr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Saraai kaanya wodiꞌ yuya yɨmaꞌnaka dazanna yagaalyaꞌ dɨnɨguna. ");
INSERT INTO byr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kɨrɨmɨ saraai yɨdaanganyɨ yɨdaanganya yadiꞌ wɨna. Sara yɨnɨgodaakɨlyɨ Jizaazai gamɨ sai aya kɨbanna yɨmaꞌnadavaabɨna yɨna yaka saraalyɨ yeꞌmwannɨgwaanna. ");
INSERT INTO byr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Saraalyɨ yeꞌmwannɨgwaanna yadaaꞌnyɨ kɨrɨꞌ kɨrɨmɨre tɨnnyangɨ nabinya pɨnɨ bɨꞌjɨralɨmwagaꞌdɨꞌnyɨ saraai myawɨri “Sai Jizaazai daaka!” ");
INSERT INTO byr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sara myawɨri kyagi sai wɨdɨna “Saraaihi, benna dɨnɨgodiꞌ wɨvanɨgɨla?” Sara wɨdaka saꞌna saraai daavɨna yagɨla sɨmunyaꞌ taanga winaꞌdɨꞌnyɨ sɨnnyɨꞌ gwarakuꞌna. ");
INSERT INTO byr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sara yagɨla aꞌmwe pwai Kɨlayopaazai woꞌnɨkei jaꞌnawɨdɨna “Aꞌmwe kwalaalya anga pɨbadaaꞌnya pɨbadaaꞌnyara dahaaꞌ Jeruzaalemɨ yune sabanna mwaaihava. Sareꞌna nabaai gɨmɨ gaveigɨ yune yɨrɨka dahɨnɨngɨ anga naanga Jeruzaalemɨ yɨmaꞌnɨwaka savɨ myawɨryaigɨ daaka!” ");
INSERT INTO byr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Sai sara daka yadɨꞌnyɨ sahwai saraarɨ yɨdaanganna “Benɨnneka?” Yɨdaanganna kyaꞌ saraai wɨdɨna “Yɨmaꞌnɨwaka sa Jizaazai Naazaretɨ mwaalyarɨnera. Sahwai Gotɨyarɨ wɨꞌnawɨjɨwaakadei Gotɨyare tɨnnyarɨjɨ aꞌmwe yuyaraavɨre tɨnnyarɨjɨ wawɨnya dɨragɨnyajɨ yada yagaala dɨragɨnyajɨ dadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sarerɨ Gotɨyarɨna yɨraꞌdɨvɨta naangerajɨ nemɨre maremwaaidɨvɨsarajɨ Gaꞌmaanɨyare asɨrɨ marakesarɨnera. Sarerɨ Gaꞌmaanɨyai balyaꞌnerɨna yagaala jamungajakerɨnera. Sarerɨ tamarɨmwɨwaꞌdaasarɨnera. ");
INSERT INTO byr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sare kɨrɨꞌ kɨgaaꞌ nemɨ dɨragɨnna dara lɨmwagoine. Aꞌmwe dazai Yɨzɨrelɨyainaavɨ ayɨna nevadaihasamaaradei daaka! Yo, nabaai yagaala pɨrɨsɨ kuna warɨꞌ. Sasare daza mena yɨmaꞌnɨwaꞌdɨkevɨ yɨ dahaaꞌ yɨrɨka gamɨnne darɨkaai yaka darɨkɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Sarevɨ yuna dahaasagaaꞌ nemɨnyɨdaaꞌnya aꞌmwe pɨnɨ nemɨnyabanna kabathɨwaaꞌ lɨka yɨwaainɨwoinera. Yuna mwanyavɨ simaangeyabanna wawevemɨlɨka ");
INSERT INTO byr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","gamɨre kɨlaakejɨꞌ mwanganyɨwaasamɨlɨkera. Sara mwanganyɨ yeva ayɨna beva dara nedɨwaaꞌ ‘Nemɨ ejelɨya pwaraarɨ wangamwo. Sahwaraai nedɨwaai “Sai gaala mwaalɨꞌ.” ’ ");
INSERT INTO byr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nabaai nemɨnyɨdaaꞌnya pwaraai simaangeyaba wawogɨla aꞌmwe nedɨwaatabaai avaaina sarengɨ wangamwaalyaraalyɨ. Kɨrɨꞌ yune gamɨ sarɨ miwariwaala.” ");
INSERT INTO byr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sara wɨdɨna kyagi wɨdɨna “Kɨrɨmɨ sɨmunya maayaraaihi! Yagaala yuya pɨropetɨyara dɨhata sangɨna kɨrɨmɨre sɨmunyaꞌ dɨragɨnyaꞌ yawɨralɨmwadiꞌ mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Gathaꞌdarevɨnaka! Kɨrɨmɨ myawɨriwaai ‘Kɨraazɨtɨyai daangeꞌ aayagaaꞌ mena maarojɨyai dɨvi gannya byaanna dɨragɨnyavɨ wɨlamwaaladei daaka!’ ” ");
INSERT INTO byr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Sara wɨdɨna yaka Mozɨzare yagaalyangɨnajɨ pɨropetɨya yuyaraavɨre yagaalyajɨ sareꞌ wɨjɨwaakɨna. Yune gamɨ sarɨna dɨnɨka Bukuyavɨ yuya aaya kaavɨlyajɨ maridɨna. ");
INSERT INTO byr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Sarera saraai puꞌnɨgohɨla anga saba aya kɨbanna yɨꞌmaꞌna. Sarevɨ gamɨ “Sangirɨꞌ kɨbawa wɨma!” yawɨrakei sara yɨna. ");
INSERT INTO byr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sara yɨna yadaaꞌnyɨ saraai dahalalɨmwanna yagɨla wɨdɨna “Naarɨmɨjɨ yeꞌmwannamwalaana! Nyɨlyai gaai waladathakadaaꞌnyɨyagaaꞌ sawɨta mɨlyɨnɨgubala yaꞌne kɨbawa yadɨꞌnyɨ.” Sara dɨragɨnna wɨdɨna kyagi sai kusawɨ wɨlɨna yaka saraalyɨ wɨlyeꞌmwannamwaaina. ");
INSERT INTO byr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sara yɨna yeva dɨvi “Tɨka wapaa naana!” deva saraalyɨ walamwaaina yaka ayabaaibɨꞌ bɨretɨyaꞌ maarɨna yaka Gotɨyarɨ “Wapaayanna gɨmɨre yayaꞌ makimwa!” wɨdɨna yaka gunyɨna yaka saraarɨ wɨjaavɨna. ");
INSERT INTO byr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sai sara kyaꞌ kɨrɨmɨre tɨnnya padaꞌgalayenna yɨna yagɨla sagaaꞌ sahwarɨ yɨwaranganna. Sara mena kyagi sawɨ sai kaanna yɨmamajɨnaꞌna kyaꞌ saraai ayawɨ mwanganyɨ yagi. ");
INSERT INTO byr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sarevɨ saraai dɨnyɨna “Naarɨmɨ tutaanyavɨ badaakwoihɨlyɨyagaaꞌ yagaalyaꞌ nehɨzɨwaakada Bukuyavɨre yawɨta aaya kaavɨlyabwi nehɨzɨwakadaaꞌnya yɨ dazagaaꞌ naarɨmɨre sɨmunyaꞌ yuna nebwina nehidɨkaaꞌmwakeꞌ daaka!” ");
INSERT INTO byr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sara dɨnyɨna yagɨla dazagaasagaaꞌ kuna Jeruzaalemɨneraai ayɨna kaanna wɨna yagi. Wawogɨleraai yɨꞌbwaꞌnemwaaidapi sɨvɨlɨrɨdaaꞌnyɨ pwainanyaraavɨjɨ kɨryaꞌmwe pwaraavɨjɨ bɨramaaꞌna. ");
INSERT INTO byr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Sara kyagi saraarɨ wɨdɨna “Naangei nebwina ayɨna dathɨkaaꞌmwaka! Saaimonɨmɨ mena yɨmaꞌnaabɨwakelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Sara wɨdɨna kyeꞌ saraai tutaanyavɨ wodiꞌ wanganagɨlyanna wɨjɨwaakɨna. Saraai wɨdɨna “Sai gunyadaaꞌnyɨ naarɨmɨ yawɨrangamwolyarɨnera.” ");
INSERT INTO byr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yagaalyaꞌ kuna dɨnɨbainadaaꞌdapi sahwai kumɨnyɨ tɨnnyaba yɨmaꞌnadavaabɨna yaka wɨdɨna “Kwaamuꞌ dɨmwaalyɨla!” ");
INSERT INTO byr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Saꞌneꞌ lɨka yɨwaaineva lɨka naanga yɨna. “Kurya pwarɨ dahawangamwona,” yawɨreva lɨka yɨna kyeꞌ ");
INSERT INTO byr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","sai wɨdɨna “Sarɨmɨre sɨmunyai beꞌneꞌ yɨwɨnakɨvanɨgava! Nabaai sɨmunyangɨ yawɨta kwalaalya beꞌna yawɨꞌmanɨgava! ");
INSERT INTO byr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nɨmɨre asɨraalyɨ sɨvɨlyɨraalyɨ dɨnyanganyɨla! Nɨmɨ sainyɨ sahwainyɨra. Asa nyɨmwangadɨvɨꞌ dɨnyanganyɨla! Sareꞌ dareꞌnanyɨ. Nɨmɨnyɨ nyangamwaatabaaibɨꞌ kuryai mɨwɨta yagɨnya kunelyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Sara wɨdɨna yaka kumɨnyɨ gamɨre ata sɨvɨla wɨjɨwaainyɨna. ");
INSERT INTO byr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tɨviꞌna wɨjɨwaainyɨna kyaꞌ yɨlaaya naanga yadɨvɨsaꞌnajɨ atɨka maruꞌnaꞌdɨvɨsaꞌnajɨ sareꞌ myawɨralɨmwagi yadaapi sai wɨdɨna “Dava sarɨmɨre tɨka wapaaya pɨnɨ mwarijɨka?” ");
INSERT INTO byr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wɨdɨna kyaꞌ yɨdɨka yakɨnɨka jawɨnya pimagɨnyavaaꞌ wɨmaarina kyeꞌ ");
INSERT INTO byr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","sai maaraka nadaaꞌnyɨ tɨnna wanganna. ");
INSERT INTO byr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sai kumɨnyɨ wɨdɨna “Kɨgaaꞌ sarɨmɨjɨ kuna mwaalena yagaala da mena yɨhɨthe. Sɨnnawɨ kɨgaaꞌ nɨmɨnyɨna yuya yɨdaveta sa Mozɨzare Kɨwɨnyavɨjɨ pɨropetɨyaraavɨre bukuyangɨjɨ Saamɨyangɨjɨ yuya daza yɨ yunebanna sara yɨmaꞌnyaꞌnevɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wɨdɨna yaka sagaaꞌ Gotɨyare Bukuyavɨ yawɨranganyaꞌnera kumɨre sɨmunyangɨ yɨwɨrinyaꞌne sɨmunya wakɨna yaka ");
INSERT INTO byr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","wɨdɨna “Bukuyaꞌ dara dɨnɨꞌ ‘Kɨraazɨtɨyai daangeꞌ maarojɨyai yuna baladei yɨrɨka darɨkaai darɨkɨ ayɨna dɨkaavadelyɨ. ");
INSERT INTO byr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Sarerɨneꞌna nabaai gamɨnne yayavɨ yuya ajɨmya yuyangɨyaraavɨ wɨjɨwakadaapɨri pwara sɨmunya mudɨkebwi kyawɨramaarapɨri Gotɨyai kumɨre gɨrɨkitaꞌnanya duimwagasɨꞌnaderera. Wawɨnya dazaꞌ Jeruzaalemɨdaaꞌnyɨ yamaapɨꞌderera.’ ");
INSERT INTO byr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yuya dazanna aꞌmweraavɨ jalɨkurakyaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yɨthaanyi! Nɨmwai yune naanga nebulyaꞌna dakeꞌ yɨhɨzaayaꞌnerɨ sarɨmɨnyawɨnna yɨhyasaabɨdeꞌnanyɨ. Kɨrɨꞌ anga naanga dathahɨba kuna mwaalapɨjɨ yune keꞌmwewɨ Sɨgunyavɨdaaꞌnya dɨragɨnyaꞌ walaabazahaaꞌnanneihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Gamɨreraavɨ Betaani sabanna makuna yaka. Sara yakei gamɨre asɨraai munyaba makɨlaka Gotɨyare dɨragɨnya yanga wɨjaayaꞌnei kumɨnyɨ tewaanaangeꞌ winadeꞌ wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kuna wɨdɨna yada kumɨnyɨ yagalyaꞌmakuna kyaꞌ Gotɨyai Sɨgunyavɨnerɨ makilaawɨna. ");
INSERT INTO byr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Makilaawɨna yadaaꞌnyɨ sahwara gamɨnyɨ yɨlaaya wɨmarina yeva Jeruzaalemɨna ayɨna wawesara yɨlaaya naanga yɨna. ");
INSERT INTO byr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Sarera yuyagaaꞌ Gotɨyare Angevɨ mwaaidɨvɨꞌ Gotɨyarɨne yayaꞌ munyaba makidɨvɨsare. ");
INSERT INTO byr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sɨnnawɨ kɨgaakuna Kwaaka davaꞌ mimaꞌnyawɨ Gotɨyarɨne Yagaalyai mwalyaakewɨnyɨ. Nabaai, Gotɨyai mwaalakewɨ gamɨnyawɨ Gotɨyarɨne Yagaalyai mwaalɨꞌ. Gotɨyarɨne Yagaalyai sahwai Gotɨyai. ");
INSERT INTO byr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sɨnnawɨ kɨgaakuna aayawɨdaasɨ Gotɨyalyɨ sahwai mwalɨbainyɨna yaakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gotɨyai sara kyawɨraꞌ sahwai yuyangɨ sara wakɨnɨkengɨ. Aane pɨrɨꞌ kɨrɨꞌ gamɨ saba yɨmaꞌnakaꞌ mɨꞌ. Aawa, sahwai wakakengɨ yuya sa. ");
INSERT INTO byr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sɨnnawɨ sagaaꞌ sahwarɨ gaalyabwi warakelyɨ. Gaala sabwi aꞌmwe yuyaraavɨre Baakelyɨ. Yɨnɨka sai aꞌmweinaavɨna kunya tewaanya yawɨryaꞌne nejaavɨnɨkerɨna. Kunya tewaanya yawɨryaꞌne wɨjaavɨna kaneyaꞌ baaka savɨ nayaa mwaidaanyaine. (Gotɨyarɨna nayaa yawɨꞌdaanyaine.) ");
INSERT INTO byr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Saburɨdaasɨ jɨhɨnya kayaaꞌnanyaburɨ Gotɨyare baakeꞌ wannyɨna. Nabaai jɨhɨnya saꞌ baakevɨ mwavɨlayɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Gotɨyai yawɨꞌna “Aꞌmwera baakevɨ mwaaibɨka!” yawɨraka sɨnnawɨ aꞌmwerɨ wɨdaasakelyɨ. Sai Jonɨ (Bavɨtaazɨya Yadei) wɨdaasakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Aꞌmwe sahwai jalɨkurakyaꞌnei bɨna. “Aꞌmweraavɨ aꞌmwengɨ Jizaazai Baakerɨna wɨjalɨkurakana!” daka wɨdaasakei bɨna. “Kadɨka wɨꞌnapɨjɨ Naangerɨ lɨmwagapɨka!” dakei bɨna. ");
INSERT INTO byr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jonɨ gamɨ sai Baakei mɨka! Aawa. “Baaka nawɨꞌnya sarɨna jalɨkurakana!” dakelyɨra. ");
INSERT INTO byr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Dɨvi Baakei Kwaaka davakɨna walaabaka aꞌmwe gazainazainaavɨna Baaka nebulyaꞌnanyalyɨ. Aꞌmwe yuyainaavɨ kunya tewaanya yawɨryaꞌne nejaavadei. ");
INSERT INTO byr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nabaai, Kwaaka davakɨ sai bamwaaina yaꞌ. Sɨnnawɨ Gotɨyai kyawɨraꞌ sahwai Kwaaka davaꞌ sara wakɨna. Sara wakɨna yaka bamwaaina kyaꞌ kɨrɨꞌ Kwaaka davakɨ mwaalyara gamɨ sahwarɨ myawɨramaari yesalyɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Gannya Anga Yɨzɨrelɨna bɨna yaka bamwaaidɨsɨ gamɨjɨyara mamaari. ");
INSERT INTO byr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sara yɨna yeva mamaari kyeꞌ kɨrɨꞌ aꞌmwera pwara “Nebulyasɨra. Naangelyɨra,” deva maarɨna yeꞌ. Maarɨna kyeꞌ sai yuya saraavɨna gannya dɨragɨnyabwi wɨjaavɨna yaꞌ. Gannya dɨragɨnya sabwi sahwara Gotɨyare kaimɨraayara yɨmaꞌnyaꞌnebulyɨ. Gamɨ sahwarɨnajɨ gamɨre yayavɨnajɨ lɨmwagaꞌdɨvɨsaraavɨnebulyɨ. Yɨ sahwara mudɨkera yɨmaꞌnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Aꞌmweraavɨre yɨsavakaavɨdaasɨ tawengɨna mudɨkera mimaꞌnyɨna. Aawa. Kɨlaakejɨkɨya sɨdusaburɨ mudɨkera mimaꞌnyɨna. Aawa. Aꞌmweraavɨre dɨragɨnyavɨ mudɨkera mimaꞌnyɨna. Aawa. Gotɨyai gevwi yawɨꞌna “Sahwara nɨmɨre kaimɨraayara mudɨkeraavɨ yawakɨnɨma!” kadɨnɨꞌ yɨmaꞌnɨgavɨnɨkengɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Gotɨyarɨne Yagaalyai aꞌmwe kɨlaaꞌnakei yɨmaꞌnyɨna yakei nemɨnyawɨ gannya selɨ angeꞌ yɨladaakuna. Gamɨre kɨlaakejɨkɨ wɨlamwaaina yɨna yada tɨnna dara wanganoꞌ “O, Nawɨꞌnyai dɨragɨnaangei daaka!” Sara dadaa gamɨre byaannyavɨ tɨnna wangano. Ganɨmaangerɨdaaꞌnyai gavei yamakɨnarɨkabaaibɨta byaanna sasɨ. Sahwarɨ yuneba yanga gaimwangebulyɨ nebulyabulyɨ maanga yekuꞌnɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Aꞌmwe Jonɨ gamɨnyɨna nejalɨkurakada jaka dara danganna “Aꞌmwe dazarɨna yɨhɨthelyɨ. Nɨmɨ Gotɨyare yagaala kyɨhɨthɨwa dɨviya pwai bozɨ yɨhɨzɨwaakadei Naangelyɨ. Nɨmɨ sahwainyɨ mɨka! Nɨmɨ maalɨkeinyɨra. Nɨmɨ mimaꞌnyagaaꞌ kuna mwalyaakeꞌna Sɨnnawɨnyalyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sahwai maanga yekuꞌnɨkevɨdaaꞌnyɨ nemɨ yuyainaavɨna wana nawɨꞌnya nejaavadeꞌna tewaanna mwaaiho. Nemɨnyɨna gamɨre yanga gaimwagaimwangeꞌ nejaavada nejaavɨnɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sareꞌ Gotɨyai kujaaꞌ Ne Mozɨzai Gotɨyare Kɨwɨnya tewaanyaꞌ wɨjaavɨna. Wɨjaavɨna neyɨnɨkeꞌ nemɨnyawɨnna Gotɨyai Kɨraazɨtɨya Jizaazarɨ wɨdasaabɨna. Wɨdasaabɨna kyɨnɨꞌ sahwarɨ nemɨnyɨna yanga gaimwangebulyɨ nebulyabulyɨ yɨmaꞌnɨnɨkeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Gotɨyarɨ aꞌmwe Kwaaka davakɨyaina wangadaanyarɨna mɨꞌ. Aane pwai kwai tɨnna mwanganyɨ. Aawa, Gotɨyai gavei Ganɨmaangeryaba kusɨmagɨnna mwaalɨkei nemɨnyɨ yɨbwarɨdaakwia neyɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jonɨmɨre jalɨkurakya daresɨ. Jonɨmyawɨnna Juyara Anga Jeruzaalemɨ mwaalya naangera aꞌmwe pwaraavɨ wɨdaasɨna. Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨsaraavɨjɨ Gotɨyare Angevɨ wɨdaayadɨvɨsara Livaayaraavɨjɨ wɨdaasɨna. Miꞌna wɨdaasɨna kyeꞌ wɨna yɨna yeva Jonɨmɨ yɨwaaraꞌna “Gɨmɨ bewaigɨnaka?” ");
INSERT INTO byr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yɨwaaraꞌna kyeꞌ Jonɨ “Yagaala saꞌ madɨwɨnera!” myawɨri yaka aangyagaala nebulyaꞌ kave nayaa wɨdɨna “Nɨmɨ Gotɨyai Nyɨdahɨlakyaaka Kɨraazɨtɨyainyɨ mɨka!” ");
INSERT INTO byr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Sara yɨwaaraꞌna “Nabaai, bewaigɨnaka? Ne Yɨlaajaigɨ daaka?” Sara yɨwaaraꞌna kyeꞌ Jonɨ wɨdɨna “Aawa, nɨmɨ mɨka!” Sahwara wɨdɨna “Gotɨyarɨ nayaa wɨꞌnanejɨwaakade naangerɨna yemwaaiho sahwaigɨ daa?” Wɨdɨna kyeꞌ maꞌmaaꞌna “Aawa!” ");
INSERT INTO byr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Sarevɨdaaꞌnyɨ gamɨnyɨ wɨdɨna “Dɨnedana! Bewaigɨnaka? ‘Nedasɨwaasaraavɨ jaꞌnawɨjaꞌ nayaa wɨdaana!’ dona gyɨwaaraꞌmanɨgo. Sahwaigɨ gɨmɨnyɨna be yagaala dɨmanɨgɨnyavaka?” ");
INSERT INTO byr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wɨdɨna kyeꞌ sai wɨdɨna “Nɨmɨ sainyɨ dareinyɨra “Aꞌmwamaayaba maanguraayainyɨ jaka wɨdangadɨnyainyɨra. “Naangei tuta tewaanyavɨ wawodeꞌna “Tusaꞌ yɨdaꞌna nayaa jamakwila!” ’ Wɨꞌnawɨjɨwaakya Aazaayai nɨmɨnyɨna sara dɨnɨkesɨ.” ");
INSERT INTO byr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yɨwaaraveveraavɨ aꞌmwe Perɨzɨyara wɨdaasɨna yesare. ");
INSERT INTO byr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Sahwara gamɨnyɨ yɨwaaraꞌna “Gɨthahɨlakɨnɨka Kɨraazɨtɨyaigɨ mɨka! Gɨmɨ Ne Yɨlaajaigɨ mɨka! Wɨꞌnawɨjɨwaakya naangerɨna yemwaaiho sahwaigɨ mɨka! Sarevɨdaaꞌnyɨ aꞌmweraavɨ aalyaꞌ baaꞌna yɨvanɨgɨna?” ");
INSERT INTO byr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jonɨ maꞌmaaꞌna “Aalyavɨ bavɨtaazɨyaꞌ yadɨnyainyɨ. Aꞌmwe pwai sarɨmɨnyaba tɨnnyaba daavɨkerɨ myawɨranganyɨvanɨgava. ");
INSERT INTO byr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Gamɨ sai aꞌmwe naangelyɨ. Sɨnnawɨ nɨmɨ bɨweinyɨ, sahwai dɨviyai yarai bathei naangei mwaalɨka. Nɨmɨ gaimwangeꞌna naangere kwaariꞌmasɨvɨlyaꞌ yɨraipurɨdeinyɨ mɨka. Sahwarɨna nɨmɨ aꞌmwe nawɨꞌnyainyɨ daaka!” sara wɨdaꞌ Jonɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yuya sa Aalya Jothanɨ kengihɨrɨ Anga Betaani Jonɨ aalyavɨ bavɨtaazɨyaꞌ yadaaꞌnyɨyaba yɨmaꞌnyɨna yakengɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mwanyagaaꞌ Jonɨ mwaalaka Jizaazai bakerɨ tɨnna wanganaasɨna yaka aꞌmweraavɨ wɨdɨna “Yɨthaanyi, dazai Gotɨyarei Sipɨzipɨya Dɨwɨnyala! Kayaaꞌnanyanna aꞌmwera sipɨzipɨyarɨ tamɨna yadɨvɨꞌ kwaraanyaba Gotɨyarɨna dɨka nasɨꞌna yadevaaibɨꞌ sai Kwaakevakɨ mwaalyainaavɨre kayaaꞌnanyanna marasɨsaꞌna baladelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Sahwarɨna yɨhɨthadɨnyalyɨ. Nɨmɨ bɨweinyɨ, dɨvi aꞌmwei bathelyɨ. Nɨmɨ mimaꞌnyagaaꞌ sai kuna mwalyaakelyɨ. Sai sɨnnawɨnyai Naangelyɨ. Nɨmɨ maalɨkeinyɨra. ");
INSERT INTO byr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","‘Bozɨyai Naanga kwarɨnera,’ yawɨrena gamɨnyɨ myawɨranganyainyɨ. Aawa. ‘Sahwarɨna Yɨzɨrelɨyaraavɨ yɨbwarɨdaakwiaꞌna yɨma!’ dena bɨwa. Aalya yɨhyadɨnya savɨ dara jawɨryideꞌ ‘O, sai Naangei daaka!’ ” ");
INSERT INTO byr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jonɨ tɨnna mena bahanaraka aꞌmwe Juyaraavɨ wɨjalɨkurakɨna “Sɨgunyavɨ Gotɨyarebadaaꞌnyɨ Kuryai Tewaanyai kwaamɨryaibɨsai walaabɨna yaka aꞌmwe sarɨ mwalɨbainɨkerɨ tɨnna wanganerɨnera. ");
INSERT INTO byr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Sɨnnawɨ gamɨnyɨ myawɨranganyainyɨ. Aawa. Bavɨtaazɨyaꞌna nyɨdasaabakei sahwai nyɨdaꞌ ‘Dɨvi dara dangadeigɨnyɨ. Kurya Tewaanyai aꞌmwe pwarɨ bwalamwaaina yajaꞌ wanganaꞌgɨzɨ dara jawɨꞌdeꞌ “Ai, sai aꞌmweraavɨna Kurya Tewaanyarɨ yanga wɨjaavadei daaka!” Gɨmɨ aalyavɨ bavɨtaazɨyaꞌ jɨtheꞌ sai Kuryarɨ bavɨtaazɨyaꞌ yadelyɨ.’ ");
INSERT INTO byr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Sara wɨdɨna nyakeꞌ tɨnna nayaa wangamweinyɨ yɨhɨzalɨkurakɨvanɨge. Sai Gotɨyare Gawaalɨvaangelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mwanyagaaꞌ Jonɨjɨ gamɨreraalyɨ sara ayaba daaꞌdapi Jizaazai kaanya yamarina. ");
INSERT INTO byr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kaanya yamarina yada Jonɨ wanganaasaka gannyaraarɨ wɨdɨna “Yɨthaanyi! Sai Gotɨyarei Sipɨzipɨya Dɨwɨnyala!” ");
INSERT INTO byr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wɨdɨna kyaꞌ Jonɨmɨreraai kadɨka wɨꞌnyɨna yagɨlyaraai saraai Jizaazarɨ mɨdɨnna. ");
INSERT INTO byr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Sara mɨdɨnna yɨna yadaakɨlyɨ gɨnyɨmaꞌnaka saraai mɨdɨnaabɨna yagɨlyaraarɨ tɨnna wanganaka yɨwaaraꞌna “Berɨꞌna bɨꞌmanɨgɨla?” Saraai wɨdahi “Ravaai, anga garɨvɨ mwaaihɨna?” Yɨvɨruyagaalyaꞌ “Ravaai,” yagaalyaꞌ “Nejɨwaakadɨnyaigɨ,” wɨdɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Ravaai, anga garɨvɨ mwaaihɨna?” wɨdɨna kyagi sai wɨdɨna “Kaanya bakɨlyɨ danganyɨla!” Sarevɨdaaꞌnyɨ gamɨjɨ wɨna yagɨla gannya anga mwaaidevɨ tɨnna wanganna yagɨla sagaaꞌ gamɨnyaba mwaalɨna yagi. Bɨna yɨna yagɨlegaaꞌ sawɨtɨrɨnyagaakɨ (4 kɨlokɨ). ");
INSERT INTO byr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Saraai Jonɨmɨ kadɨka wɨꞌnagɨla Jizaazalyɨ wawagɨla pwai Edɨruyalyɨ. Edɨruyai sai, Saaimonɨ Pitare gyaꞌmwelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Edɨruyai sai sɨnnawɨ wɨna yaka Saaimonɨ gyaꞌmwerɨna bɨrɨkaanya yɨna yaka wɨdɨna “Ai! Nemɨ Mezaayarɨ mena bɨramaaꞌmwona!” Yaya saꞌ “Mezaayai,” dɨnɨꞌ “Kɨraazɨtɨyai.” ");
INSERT INTO byr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wɨdɨna yaka Saaimonɨmɨ gamɨnyawɨnna makuna. Makuna kyaꞌ Jizaazai tɨnna wanganaka wɨdɨna “Gɨmɨ Jonɨmɨre gawaalɨꞌgɨnyɨ Saaimonɨgɨ. Gɨmɨre yayaꞌ Sipaazai gɨthɨvanɨgesɨ.” Juyaraavɨre yagaala “Sipaazai,” Gɨrikɨyagaala “Pitai,” aangyagaala “Sɨlaangei,” dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mwanyagaaꞌ Jizaazai “Pwarajɨ Galɨlineinera,” daka Pilipɨmɨ bɨrɨna yaka wɨdɨna “Dɨnyɨmɨdɨnaama!” ");
INSERT INTO byr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipɨ sai Anga Betɨzaaitha mwaalyalyɨ. Anga saba Edɨruyalyɨ Pitalyɨ sadaraai mwaaidisaba. ");
INSERT INTO byr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipɨ kadɨka wɨꞌnyɨna yaka Nataanyalɨmɨ bɨramaaꞌna yaka wɨdaꞌ “Kaanyaka! Ne Mozɨzai kɨwɨbukuyavɨ pwarɨna yɨdaꞌnɨkeꞌ nabaai, Gotɨyarɨ wɨꞌnawɨjɨwaakyara sarɨna pɨkarya yɨdaꞌnɨkevɨne sarɨ mena bɨramaaꞌmwona. Sai, Jizaazai Jozepɨyare gawaalɨꞌ Naazaretɨ mwaalyalyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Wɨdɨna kyaꞌ Nataanyalɨ yɨwaaraꞌna “Naazaretɨdaaꞌnyara tewaanyara daaka! Savɨdaaꞌnyɨ tewaanyai dalyaabɨwaka!” Pilipɨ wɨdaꞌ “Sahwaigɨ bwangana! Nebulyaꞌna gɨthɨwana. Bwangana!” ");
INSERT INTO byr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nataanyalɨ badaaꞌnyɨ Jizaazai tɨnna wanganaka sarɨna wɨdɨna “Yɨthaanyi! Sai Yɨzɨrelɨya tewaanyalyɨ. Kwaasɨ yadei mɨka!” ");
INSERT INTO byr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataanyalɨ savɨ kadɨka wɨꞌnaka yɨwaaraꞌna “Nɨmɨnyɨna gara yawɨꞌmwaana?” Yɨwaaraꞌna kyaꞌ sai wɨdɨna “Sagaaꞌ Pilipɨ gɨmɨnyɨna mabɨriwakegaaꞌ yɨta pihɨya kaavɨlyavɨ mwaaidaꞌgi gwangamweigɨnyɨra,” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataanyalɨ wɨdɨna “Ravaai, Nejɨwaakadɨnyaigɨ, gɨmɨnyɨna dɨwa. Gɨmɨ Gotɨyare Gawaalɨkɨ. Yɨzɨrelɨyainaavɨ nemaremwaaidɨnyaigɨne!” ");
INSERT INTO byr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Wɨdɨna kyaꞌ sagaaꞌ sai wɨdɨna “ ‘Yɨta pihɨyavɨ mwaaidaꞌgi gwangamwa,’ gɨthɨweꞌna nɨmɨnyɨna danyɨlɨmwamwaana! Sabwi maalɨkebwi, dɨvi naangengɨ dangadengɨra.” ");
INSERT INTO byr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Gamɨnyɨ wɨdɨna “Nebulyaꞌ yɨhɨthɨvanɨge. Sɨgunyaꞌ basɨnadaaꞌdozɨ Gotɨyare mamaayara ejelɨyara Aꞌmweraavɨne Kaimɨraayaryawɨnna walaabɨna, yɨlaawɨna yadaapɨri danganyideihɨlyɨra,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yɨrɨka daryaai darɨkɨ Kwaaka Galɨli Anga Kena savɨ kwala maarya yɨna. Kwala maarya yɨna kyeꞌ tɨka munnevɨ Jizaazarɨ ganaangeꞌ mwaalɨna yadɨꞌnyɨ nabaai, ");
INSERT INTO byr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jizaazalyɨ gamɨrerari saraavɨ munneꞌna jɨvwaramaaꞌna. ");
INSERT INTO byr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sara yɨna kyeꞌ munneꞌ nyɨna yadaapɨjɨ aalya waainɨyaꞌna wɨgainyɨna yadaaꞌnyɨ ganaangeꞌ Jizaazarɨ wɨdɨna “Aalya waainɨyaꞌ maayarera.” ");
INSERT INTO byr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Wɨdɨna kyaꞌ sai wɨdɨna “Aꞌmweꞌgɨ ‘Sana sana ja!’ baaꞌna nyɨdɨwaana? Nɨmɨregaaꞌ mɨka!” ");
INSERT INTO byr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sara wɨdɨna kyaꞌ ganaangeꞌ wɨdaayadɨvɨsaraavɨ wɨdɨna “Sara yɨhɨthatheꞌna sara jɨla!” ");
INSERT INTO byr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Juyara aalya yɨnyabwina waꞌdɨꞌnyɨ si-aalɨtala atina ata purɨdaaꞌnyɨ nyɨdala kune warakengɨ. Aalɨtala gazasaꞌ maanga kyekuꞌnaꞌ aalya naanga (80, 100 litaaya) dɨꞌnaꞌnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Si-aalɨtala sa kune warake, sahwai wɨdaayadɨvɨsaraavɨ wɨdɨna “Aalɨtala sa aalya maanga yunebanna yekuꞌnade dɨmaradɨngikaabyɨla!” Wɨdɨna kyaꞌ maanga yekuꞌnyaꞌne aalya maradɨngikɨna maradɨngikɨna kyeꞌ ");
INSERT INTO byr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","wɨdɨna “Aalya pɨrɨꞌ yɨrapɨjɨ tɨka munnevɨ maremwaaiderɨna dumaryaawila!” Sara wɨdɨna kyaꞌ makuna yeva wɨjaavɨna kyeꞌ sai yaamɨjɨ nyɨna. ");
INSERT INTO byr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Aalya saꞌ sɨnnawɨ aangaalyaꞌ dɨꞌnaꞌdɨꞌnyɨ dɨvi aalya waainɨyaꞌ yɨmaꞌnyɨna yɨnɨkesɨ. Yaamɨjɨ nyɨna yaka dɨna “Waburyasɨ. Waainɨya daꞌ gawɨdaaꞌnyavaka?” Sai myawɨri yada sareꞌna wɨdaayadɨvɨsara yawɨreva aalya wɨjaavɨna yesarera. Kuna myawɨri yada mɨgɨnyai taayaꞌ maarakerɨ munnevɨ maremwaalakei wɨdɨna “Kaajo!” ");
INSERT INTO byr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Wɨdɨna yaka wɨdɨna “Nemɨnyɨna tewaanya yɨwaana! Sɨnnawɨ aꞌmwe pwara gazarazara aalya waainɨya nawɨꞌnyaꞌ munne wɨjaavɨna yadɨvɨꞌ dɨvi aꞌmwera waainɨya naanga nadɨvɨꞌ nayaa myawɨryaraavɨna aalya waainɨya yɨrɨkeꞌ wɨjaavɨna yadɨvɨsare pwara. Sareꞌna yadɨnyaigɨ mɨka! Kwaigɨ aalya waainɨya nawɨꞌnyaꞌ navɨka yɨꞌnadɨꞌnyɨ, waainɨya pɨrɨꞌ miꞌna kanɨwo dɨvi nawɨꞌnyaꞌ wɨjaavɨna neyɨwaanyaigɨnyɨ,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kwaaka Galɨli Anga Kena saba Jizaazai wɨjɨwaainyaꞌne saꞌ yɨna yaꞌ. Wɨjɨwaainyaꞌne sɨnnawɨnyaꞌ yakesɨ. Gannya byaanna dɨragɨnyabwi wɨjɨwaainakeꞌna wɨjɨwaainyaꞌne saꞌ yakesɨ. Gamɨrera naangebwi wanganeva gamɨnyɨ lɨmwanna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mena yakegaaꞌ sagaaꞌ Anga Kaapanɨyamɨ sabanna gamɨjɨ ganaangesɨ gyaꞌmwerari gamɨrerari walyuna yeva yɨrɨka pɨrɨꞌ pɨrɨꞌ saba bamwaaina yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juyara dɨna “Aya kɨgaaꞌ Pariꞌmaꞌmunneꞌ naadera Gotɨyai nemɨnyɨna dɨragɨnna kavadaihasamaryaaꞌ yaasɨwaꞌwawɨnya Yɨzɨpɨ saba yagalyaꞌmayaawoꞌ yawɨtaꞌnegaaꞌ.” Juyara dɨdaapi Anga Jeruzaalemɨ sabanna yɨlaawɨna. ");
INSERT INTO byr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yɨlaawɨna yaka Gotɨyare Angevɨ wɨlɨna yaka dara wanganakeꞌ “O, aꞌmwera bulɨmakaawoyarajɨ sipɨzipɨyarajɨ kwaamɨryarajɨ damubɨvanɨgava! Nɨgwia nawɨꞌnya Gotɨyarɨ wɨjaayaꞌna nɨgwia pɨmɨlɨka yanga yɨnyɨna yadɨvɨsara kunnya yɨꞌbɨnyangɨ damwaaihava!” ");
INSERT INTO byr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dɨna yaka “Sabwi mipɨnera!” daka wɨlyabaai maarɨna yaka mala lɨꞌbwaryaꞌneꞌ yavɨkarina yaka Gotɨyare Angevɨdaaꞌnyɨ sipɨzipɨyarajɨ bulɨmakaawoyarajɨ saraavɨ tamaasɨna yaka nɨgwia mariwɨnasɨꞌna yaka yanga yɨnyɨna yadɨvɨsaraavɨre yɨꞌbɨnya yarai marapuratawasɨꞌna. ");
INSERT INTO byr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sara miꞌna yaka kwaamɨryaraavɨ mubadɨvɨsaraavɨ wɨdɨna “Sa dɨmakwalyula! Nɨmware angeꞌ mubangeꞌna mɨka. Dɨmakwila!” ");
INSERT INTO byr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wɨdɨna kyaꞌ gamɨrera yawɨꞌna “Gotɨyare bukuyaꞌ dɨnyɨna ‘Gotɨyaigɨ gɨmɨre angevɨna yɨlaaya dɨka nɨmɨre sɨmunyavɨ nyɨnadevaaibɨsasɨ.’ Dɨnɨkesɨ Gotɨyare bukuyaꞌ, sahwarɨna.” ");
INSERT INTO byr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sara yakevɨdaaꞌnyɨ Juya naangera sɨnna tɨka wɨdaꞌdaaꞌnyɨ yɨwaaraꞌna “Yɨwaanyaꞌna aai gɨthɨwaka? Gotɨyai naangeigɨnyɨ gɨmwaaihɨwakeꞌ yawɨraadeꞌna dɨragɨnya wɨjɨwaainyaꞌ ja!” ");
INSERT INTO byr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yɨwaaraꞌna kyeꞌ wɨdɨna “Gotɨyare anga nawɨꞌnya darɨ kayaaka kyɨgalapɨri yɨrɨka daryaai darɨkɨ ayɨna yɨdɨkaavɨdesɨ.” ");
INSERT INTO byr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Sarevɨdaaꞌnyɨ Juyara wɨdɨna “Saꞌ beꞌna dɨwaana! ‘Yɨrɨka daryaai darɨkɨ yarai madɨdesɨ,’ dɨwaaꞌ kɨgaaꞌ kwarame pɨjaakuna (46) sara wavɨlavakesɨ anga daꞌ madaapi. Yɨrɨka daryaai darɨkɨ gaverɨkaavɨ dɨmadeigɨ dathɨwaana!” ");
INSERT INTO byr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Wɨdɨna yesaꞌna kɨrɨꞌ sahwai gannya kɨlaakejɨkɨna wɨdɨna sɨlangavɨna mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Sara wɨdɨna kyeꞌ dɨvi Jizaazarɨ ayɨna yɨdɨkaaꞌna kyaꞌ gamɨrera yagaalyaꞌ wɨdakeꞌna yawɨꞌna yeva dɨna “Gotɨyare bukuyaꞌ sara dɨnɨkeꞌna kɨgaakuna Jizaazai wɨdakeꞌ nebulyasɨ,” dɨna, lɨmwanna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Anga Jeruzaalemɨ sagaaꞌ Pariꞌmaꞌmunnegaaꞌ mwaalɨna yada nawɨꞌnyajɨ dɨragɨnyajɨ yadaaꞌnyɨ aꞌmwe kwalaalyara tɨnna sara wanganeva gamɨnyɨna dɨna “Sahwai naangelyɨ,” gamɨnne yayaꞌ lɨmwanna. ");
INSERT INTO byr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sara lɨmwanna kyeꞌ aꞌmweraavɨrebwina aꞌmwera yaasɨwaꞌwɨꞌnya yesaꞌna nayaa yawɨꞌda kumɨnyɨna yɨlaaya yarai myɨna. ");
INSERT INTO byr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aꞌmweraavɨre yawɨtaꞌnajɨ kumɨre sɨdusaꞌnajɨ nayaa yawɨꞌdei. Sarebwi pwai mujɨwaakyɨ yaꞌ. Sarebwi wɨgainadei mɨꞌ. Sareꞌ dareꞌnesɨ. Sahwai aꞌmweraavɨne sɨduꞌnakei nayaa yawɨralɨmwagarɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Juya pwara Perɨzɨkɨwɨnya yadɨvɨꞌ mwaalɨna yeve pwai Nikothimaazai woꞌnɨkei Perɨzɨyai mwaalɨna yakelyɨ. Sai aꞌmwe naangei Juyaraavɨ maremwaaidei mwaalakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mwaalɨna yaka sawɨta pɨrɨvɨ Jizaazaryawɨnna bɨna yaka bamwaaina yaka wɨdɨna “Wɨjɨwaakyaigɨ, ‘Gotɨyai gɨthasɨwaabɨkeigɨ bahɨna wɨjɨwaakɨna neyɨvanɨgɨ. Sareꞌ dareꞌnesɨ. Aꞌmwera wɨjɨwaainyangɨ yɨvanɨgɨ. Dɨragɨnya yɨvanɨgɨ. Gotɨyai magɨhaimwagyazɨ kwajɨ sara mi kyɨdɨꞌ dɨragɨnya davwi,’ sara yawɨꞌmwona.” ");
INSERT INTO byr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jizaazai jaꞌnawɨdɨna “Naanga nebulyaꞌna gɨthɨvanɨge. Aꞌmwe pwai kwai ayahi mudɨkei mimaꞌnyɨ yajai Gotɨyai maremwaaladeva tɨnna mwanganyɨ yannelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikothimaazai wɨdɨna “Aꞌmwe naangei mudɨkei yɨmaꞌnadeꞌna gara yojɨ yɨmaꞌnadelaka? Pɨgasaai aꞌmwei ganaangevɨ munyɨkɨ ayɨna wɨlaminyɨna kyojɨ ganaangeꞌ gara maaradelaka ayahwala!” ");
INSERT INTO byr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Sai jaꞌnawɨdɨna “Naanga nebulyaꞌna gɨthɨvanɨge. Kurya Tewaanyai aꞌmwerɨ aalya myɨ kyojɨ mudɨka mumwaaihi kyojɨ sai Gotɨyare maremwaaideva wɨladei mɨka! ");
INSERT INTO byr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Aꞌmweyore kaimɨraayai mɨwɨꞌnaka yagɨnnakalyɨ. Gotɨyarei, gamɨre munyɨkɨ Kurya Tewaanyai bulamwaaina kyojɨ sai aꞌmwe Gotɨyare Kuryai kɨnɨnnakelyɨ mudɨkei. ");
INSERT INTO byr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gɨthɨweꞌna ‘Sarɨmɨnyɨ mudɨka ayahi yɨhɨmwaaihana!’ gɨthɨweꞌna atɨka maruꞌnata myɨnnera! ");
INSERT INTO byr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yɨhuta gamɨ saꞌ kaanna wɨna yadevaaibɨsasɨ. Yɨhusaꞌ kadɨka wɨꞌnadɨnyaigɨ ‘Sawɨnna wawadeꞌ daaka! Sabadaaꞌnyɨ batheꞌ daaka!’ dadɨnyaigɨ mɨꞌ. Aawa, sareꞌna Gotɨyare Kurya Tewaanyai gazaizare munyɨkɨ bulamwaaina yɨnɨkei mudɨka yɨmaꞌnɨꞌ. Mudɨkei tewaanna yada aꞌmwera tɨnna wangamanɨgaꞌ. Kumɨ mwanganyɨvanɨgaꞌ aaya kaavɨlyavɨ.” ");
INSERT INTO byr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikothimaazai maꞌmaaꞌna, “Nyɨdɨwaanyaꞌ gara yɨmaꞌnɨnɨkavaka?” ");
INSERT INTO byr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Sai wɨdɨna “Yɨzɨrelɨyainaavɨre nejɨwaakadɨnyaigɨ sabwi myawɨrivanɨgɨnyaigɨ daa? ");
INSERT INTO byr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Naanga nebulyaꞌna gɨthɨvanɨge. Nayaa yawɨramaꞌdaanya yawɨꞌdaa yɨhɨthɨvanɨgo. Tɨnna nayaa wangadaanya yɨhɨthɨvanɨgo. Sara yɨhɨthɨvanɨgoꞌna nemɨre jalɨkurakyavɨ mamaaryɨvanɨgasaihɨlyɨ. Sabwi kadɨka myɨvanɨgata saꞌ baaꞌna yɨvanɨgaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kwaaka davakɨ yɨnɨkengɨna kyɨhɨthɨwa malɨmwagyɨvanɨgaꞌ ‘Nebulyasɨ,’ sara majɨ yɨwaasaꞌ Sɨgunyavɨ yɨnɨkengɨna yɨhɨthɨwɨjaꞌ gara dɨlɨmwagyideihɨlaka! ");
INSERT INTO byr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Sɨgunyavɨna yɨlaawakei aꞌmwei pwai kwai mɨka. Sɨgunyavɨ Aꞌmweraavɨne Kaimɨraayai mwaalaka savɨdaaꞌnyɨ sai gavei walaabaꞌ.” ");
INSERT INTO byr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kɨgaaꞌ aꞌmwamaayaba Ne Mozɨzai kwaariꞌmakamaalyaꞌ yɨsavakɨ pwɨyaka daakuna yaaꞌ. Kamaalyarɨ makilyaakabaaibɨꞌ yɨsavakɨ tamakyaꞌna Aꞌmweraavɨne Kaimɨraayarɨ sara makibɨꞌdelyɨra. ");
INSERT INTO byr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Sahwai “Gazaizai nyɨlɨmwagarori gaala yuyagaaꞌnebwi maarana!” kadozɨ sara makibɨꞌdelyɨra. ");
INSERT INTO byr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sareꞌ dareꞌnesɨ. Kwaaka davakɨyainaavɨna Gotɨyarɨ kale naanga kwiaꞌ Gotɨyai nemɨnyɨna Gawaalɨvaanga gaverɨ nejaavakelyɨ. “Gazaizai sahwarɨ wɨlɨmwagarojɨ myɨwawanna! Aawa. Gaala yuyagaaꞌnebwi maarana!” daka nejaavakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Sareꞌ dareꞌnanyɨ. Gotɨyai dɨna “Nyɨbwaalɨvaangei aꞌmweraavɨ kotɨyaꞌna maryawɨbwaradela!” daka myasaabyaꞌ. Aawa. “Nyɨbwaalɨvaangerɨ aꞌmweraavɨna padaihasamaata yɨma!” daka kwaaka davakɨ yasaabɨna yaꞌ Gotɨyai. ");
INSERT INTO byr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Gawaalɨvaangerɨna lɨmwagaza pwarɨ Gotɨyai kotɨyaꞌ maryawɨbwaꞌdei mɨꞌ. Malɨmwagyaza pwai kotɨyaꞌ mena yawɨbwaꞌnɨkelyɨ. Gotɨyare Gawaalɨvaanga gaverɨna gamɨre yayavɨnajɨ malɨmwagaryajaꞌna kotɨyaꞌ mena dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kotɨyaꞌna dara dɨnɨꞌ “Nemɨre kwaaka davakɨ pwai nebulyaꞌ nejɨwaakakeꞌna Baakei walaabɨna yaka kɨrɨꞌ aꞌmwera kayaaꞌnanya yadɨvɨsara kayaaꞌnanyabwi jɨhɨnyaburɨna wɨvuꞌnakere. Baakerɨna wɨvuꞌnakara mɨꞌ. Sareꞌ dareꞌnesɨ. Kumɨ yadɨvɨsa kayaaꞌnanyangɨra,” sareꞌna dɨnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sareꞌ dareꞌnesɨ. Gazaizai kayaaꞌnanya yadei Baakerɨna sɨmɨlɨka wimanɨkei Baakeryawɨnna mabi yɨvanɨꞌ. “Baakeryaba pwara nɨmɨre kayaaꞌnanyabwi nanyangabɨka!” daka mabyɨvanɨꞌ. ");
INSERT INTO byr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sara yada kɨrɨꞌ pwai nebulyaꞌna tewaanna yadei Baakeryawɨnna nayaa bɨvanɨꞌ. “Baakeryabanna kwawaꞌmujɨ pwara yawɨtaꞌna ‘Gotɨyarɨ yuya sa tewaanna jɨvanɨka!’ ” daka kaanna bɨvanɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sangɨ dɨvidaaꞌnyɨ Kwaaka Juthɨya sawɨ Jizaazalyɨ gamɨrerari kaanna. Miꞌna kaanna yaka saba kumɨjɨ mwaalaka bavɨtaazɨyaꞌ aalya yɨna. ");
INSERT INTO byr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Bavɨtaazɨyaꞌ yadaaꞌnyɨ nabaai aalya naangeꞌ waꞌdɨꞌnyɨyaꞌna Jonɨ Kwaaka Yɨnonɨ Anga Selimɨ pimagɨnna wawaka bavɨtaazɨyaꞌ yɨna. Bavɨtaazɨyaꞌ yɨna yada gamɨnyawɨnna aꞌmwera aꞌmwe samɨlɨka badaapi kumɨnyɨ bavɨtaazɨyaꞌ yɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sareꞌ dareꞌnesɨ. Sagaaꞌ tewaanna mwaalaka kalavuza mumwaaihyagaaꞌ Jonɨmɨ. ");
INSERT INTO byr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sagaaꞌ Juyai yawɨꞌna “Aalya yɨnyaꞌnebwi yɨnɨga wiꞌna daaka? Be bavɨtaazɨyavaka nawɨꞌnyaꞌ?” Dɨna yaka Jonɨmɨreraavɨ yagaala naanga wɨdɨna kyaꞌ maanga dɨnyɨna. ");
INSERT INTO byr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Miꞌna dɨnyɨna kyeꞌ Jonɨmyawɨnna gamɨrera bɨna yeva wɨdɨna “Wɨjɨwaakyaigɨ, kɨgaaꞌ Aalya Jothanɨ pimagɨ pihɨrɨ mwaalagɨna aꞌmwe pwalyɨ mwaalagɨna sarɨna nejalɨkurakagɨnyalyɨ. Yɨthaa, dahaaꞌ sai bavɨtaazɨyaꞌ yɨvanɨkeꞌ gamɨnyawɨnna yuyara wɨvanɨgaꞌ.” ");
INSERT INTO byr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jonɨ maꞌmaaꞌna “Sarɨna sɨmunya kwalaalya myawɨpɨnera! Sɨgunyavɨdaaꞌnyɨ Gotɨyai aꞌmwerɨ mujaayɨ yajaꞌ aane pɨrɨꞌ kɨrɨꞌ mamaari yannelyɨ. Gotɨyai dɨna ‘Aꞌmwe pwai naangelyɨ. Pwai maalɨkelyɨ,’ sana sana yɨna yadelyɨ Gotɨyai. ");
INSERT INTO byr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Sarɨmɨ sahwaihi nɨmɨre yagaala kadɨka nyuꞌnesaihɨlyɨ. Dara yɨhɨthe. Gotɨyai dɨnɨka Kɨraazɨtɨyainyɨ mɨka! Aawa. Gotɨyai nɨmɨnyɨdaasɨ nyɨdaasakeinyɨ. Dɨvi sahwai bathelyɨ, sara yɨhɨthe. Keꞌbaꞌna yɨhɨthɨma! ");
INSERT INTO byr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mɨgɨnyai taayaꞌ maaꞌmwakelyɨ. Mudɨkangegaaꞌ mɨgɨnyaryawɨnna taayaꞌ wɨna. Wɨna kyɨwaꞌ mɨgɨnyai yɨlaaya yɨna yaka wɨdɨna. Wɨdɨna kyɨwaꞌ gyaꞌmwei mwaalaka gamɨre maanguraayavɨ kadɨka wɨꞌnyɨna yaka yɨlaaya naanna yɨna. Taayaꞌ gyaꞌmweryawɨ mwaalɨkeꞌna yɨlaaya yɨna yɨwaꞌ. Saꞌbɨsaꞌna aꞌmwera Jizaazaryawɨnna wɨna yɨvanɨgasaꞌna yɨlaaya yuna yɨvanɨge. ");
INSERT INTO byr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Gamɨ naangei nyavɨlavɨkelyɨ. Nɨmɨ naangeinyɨ myɨmaꞌnɨwɨneinyɨ. Nɨmɨ maalɨkeinyɨ yɨmaꞌnɨdeinyɨ,” wɨdɨna yaꞌ Jonɨ. ");
INSERT INTO byr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Munyabadaasɨ dɨragɨnyai walaabakei yuyainaavɨ nevɨlavɨkelyɨ. Kwaakevakɨdaasɨ pwaina Kwaakevakɨyaina kwaakevakɨyabwi wɨdɨna, kwaasɨ kwaasɨ yagaala wɨdɨna yadaanyaine. Sɨgunyavɨdaasai yuyainaavɨ nevɨlavɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Sai Gotɨyaryaba tewaanyabwi tɨnna wanganakengɨ kadɨka wɨꞌnakengɨ sangɨna jalɨkurakɨna. Sare jalɨkurakɨna kyaꞌ kɨrɨꞌ aane pwai kwai kadɨka wɨꞌnaka gamɨre yagaalyaꞌ muꞌnyaꞌ. Aawa. ");
INSERT INTO byr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pwai gamɨre jalɨkurakyaꞌ daapɨna yakeꞌ yɨ, “Gotɨyai nebulyaꞌnanyai!” dɨragɨnna dɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Sareꞌ dareꞌnesɨ. Sahwarɨ Gotɨyai yasaabɨna kyaꞌ Gotɨyare yagaalyangɨ wɨjɨwaakɨna. Sareꞌ dareꞌnesɨ. Gotɨyai sahwarɨna gamɨre Kuryarɨ wɨjaavɨna yaꞌ. Gotɨyai gamɨre Kuryarɨ maalɨꞌna wɨjaavakarɨna mɨꞌ. Naanga yuyabwi wɨjaavakerɨna. Gotɨyai gamɨre Kuryarɨ yɨnahu wɨjaavakeꞌna sai Gotɨyare yagaalyaꞌ nayaa wɨdɨna neyaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Gawaalɨvaangerɨna Ganɨmaangerɨ tewaanya wɨvuꞌnada yɨlaaya yada dɨragɨnyajɨ yuyajɨ mwangɨna yada wɨdɨna “Yuya dɨmaremwaala!” wɨdakerɨna. ");
INSERT INTO byr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Gawaalɨvaangerɨ nayaa lɨmwagaꞌdei gaala yuyagaaꞌ yuyagaaꞌnebwi kɨnɨnnakelyɨ. Kwai Gawaalɨvaangerɨ malɨmwagaryadei gaalyabwi tɨnna mwanganyɨ. Aawa. Gotɨyarɨ sɨnna tɨka wɨdayabwi sahwarɨ kuna wɨwarɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Aꞌmwe Perɨzɨyara dara wɨꞌnesaꞌ “Ai, aꞌmwe kwalaalyara Jizaazarera yɨmaꞌnyɨna yeva aꞌmwe pwai pwai Jonɨmɨrera yɨmaꞌnyɨna. Jizaazai aꞌmwe kwala naangevɨ bavɨtaazɨyaꞌ jɨvanɨka!” ");
INSERT INTO byr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Sara wɨꞌneta kwaraavɨ Jizaazai bavɨtaazɨyaꞌ myaꞌ. Aawa. Gamɨrera gavera bavɨtaazɨyaꞌ yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Perɨzɨyara sara dɨdaapi sarevɨdaaꞌnyɨ Jizaazai saꞌna wɨꞌnaka Kwaaka Juthɨya yaꞌmaꞌna yaka “Kwaaka Galɨlina ayɨna wɨma!” daka ");
INSERT INTO byr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kwaaka Samerɨya lotayaꞌnei kaanna wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Wawakegaaꞌ Kwaaka Samerɨya Anga Saaika woꞌnɨkebanna yɨꞌmavaawɨna. Kɨgaakuna Ne Jaikopɨ gawaalɨvaanga Jozepɨyarɨne kwaakeꞌ wɨjayaakeba anga saꞌ mannɨkebe. ");
INSERT INTO byr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nabaai saba Ne Jaikopɨ aalɨkaviꞌnɨnnyaꞌ lɨkyaakeba kaviꞌnɨnnyaꞌ kuna dɨꞌnaꞌdɨsɨyaba. Jizaazai kaanna kaanna wodaaꞌnyɨ maaꞌna naanga wiadaaꞌnyɨ sɨrɨgwajahaaꞌ aalɨkaviꞌnɨnna sayabanna yɨꞌmavaawɨna yaka walamwaaina yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Aalya yɨryaꞌneꞌ Kwaaka Samerɨya mwaalyaꞌ bɨna yɨna kyaꞌ Jizaazai wɨdɨna “Aalyaꞌ dɨnyɨryaama!” ");
INSERT INTO byr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Sareꞌ dareꞌnanyɨ. Gamɨrera “Wapaaya mubaana!” deva anga savɨna wɨlaawɨna yesai gavei sara wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sarevɨdaaꞌnyɨ aꞌmwe saꞌ wɨdɨna “Gɨmɨ Juyaigɨ, nɨmɨ aꞌmweꞌnyɨ Samerɨya mwaalyaꞌnyɨ aalyaꞌna nyɨwaraꞌmwaanyaꞌna gɨthɨwa.” Sareꞌ dareꞌnesɨ. Samerɨya mwaalyara gwarewakɨ aalyaꞌ nyɨna yadɨvɨꞌ Juyara gwarewakɨna “Aala!” dadɨvɨsaꞌna wɨdɨna yaꞌ aꞌmweꞌ. ");
INSERT INTO byr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jizaazai jaꞌnawɨdɨna “ ‘Gotɨyare sɨhumaleꞌ nyɨjaavana!’ yawɨꞌdɨzaꞌ aꞌmwe sai gɨthɨwaka saꞌ ‘Aalyaꞌ dɨnyɨryaama!’ gɨmɨ wɨdɨzɨ kwajɨ sai aalyaꞌ aꞌmwera gaala mwaaibɨneꞌ kagɨzaavadɨka!” ");
INSERT INTO byr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Aꞌmweꞌ wɨdaꞌ “Aꞌmwe naangeigɨ, aalɨkaviꞌnɨnna daꞌ saamɨnaangeꞌ warɨkeꞌ kebanɨ aalyaꞌ dɨꞌnɨꞌ. Aalɨgwareꞌ maayaigɨnyɨ. Aalyaꞌ aꞌmwera gaala mwaaibɨꞌdeꞌ gawɨ dɨmaaꞌjɨwaa? ");
INSERT INTO byr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nemɨre Ne Jaikopɨ aalɨkaviꞌnɨnna daꞌ nemɨnyɨneꞌ kalɨkyaaꞌ aalya kuna nadaanyannera. Gamɨjɨ gawaalɨvaangerari gamɨre jɨlɨkyaawaryarari aalya daꞌ nyɨna yaaꞌ aalɨkaviꞌnɨnna tewaanya davɨ. Sarei nemɨre Nei aꞌmwe naangelyɨ aalya naanga nejayaakei. ‘Aalya tewaanya naangeꞌ gɨzaavɨma!’ dahɨna gamɨnyɨ wavɨlaꞌmwaanyaigɨ daa?” ");
INSERT INTO byr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jizaazai jaꞌnawɨdɨna “Aꞌmwe yuyara aalya daꞌ nadɨvɨꞌ dɨvi mɨjɨka ayɨna wiadeꞌ kɨrɨꞌ ");
INSERT INTO byr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","aꞌmwe dai aalyaꞌ wɨjaavɨdeꞌ nojɨ yuyagaaꞌ mɨjɨka mwi yadelyɨ. Arɨkewɨ. Aalyaꞌ wɨjaavɨdeꞌ gamɨre munyɨkɨ wɨlarojɨ nabaai yimɨnyaꞌ yɨmaꞌnadelyɨ. Yimɨnyavɨdaasɨ aalya nawɨꞌnyaꞌ bilyɨrɨꞌna yada aꞌmwe savɨ yuyagaaꞌ yuyagaaꞌneꞌ gaala wɨmwaaihadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aꞌmweꞌ wɨdɨna “Aꞌmwe naangeigɨ, aalya saꞌ nyɨjaama! ‘Naꞌmuri mɨjɨka ayɨna manyojɨ davanna mabi yaꞌmujɨ aalyaꞌ myɨri yɨdeꞌnyɨ,’ dena gɨthɨwa.” ");
INSERT INTO byr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Sai wɨdɨna “Gɨnnya aꞌmwerɨna duzɨmaꞌnaawa!” ");
INSERT INTO byr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Wɨdɨna kyaꞌ aꞌmweꞌ jaꞌnawɨdɨna “Aꞌmwamaayaꞌnyɨ.” Jizaazai wɨdɨna “Naangeꞌ nyɨdɨwaana ‘Aꞌmwamaayaꞌnyɨ.’ ");
INSERT INTO byr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Sareꞌ dareꞌnanyɨ. Kɨgaaꞌ aꞌmwe atɨlyaraavɨ maaꞌnagɨna kɨgaaꞌ pɨgaaꞌ yuyaraavɨ byenɨdakwawagɨ. Dahaaꞌ aꞌmwe mwaaihɨlyai gɨmɨreina mɨka! Nebulyaꞌ sara nyɨdɨwaa.” ");
INSERT INTO byr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aꞌmweꞌ wɨdɨna “Aꞌmwe naangeigɨ, gɨmɨnyɨna dara wangamweꞌ ‘O, aꞌmwe dai Gotɨyarɨ wɨꞌnawɨjɨwaakadei daaka!’ ");
INSERT INTO byr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mugunya davɨ nɨmɨre Ne sɨnnawɨnyara Samerɨya mwaalyara Gotɨyarɨ yɨlaaya yɨna. Sara yɨna kyaaꞌ kɨrɨꞌ Juyaihi sahwaihi wɨdɨna ‘Aawa, Gotɨyarɨ yɨlaaya Jeruzaalemɨ yɨpɨꞌdeva.’ Sara nedɨvanɨgaꞌ.” ");
INSERT INTO byr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jizaazai wɨdɨna “Aꞌmweꞌgɨ, gɨthɨdeꞌna duꞌnana! Dɨvi pɨgaaꞌ yɨmaꞌnadehaaꞌ mugunya davɨ aꞌmwera Nɨmwarɨ yɨlaaya mi yɨpɨꞌdeꞌ Anga Jeruzaalemɨ yɨlaaya mi yɨpɨꞌdehaakɨ. Aawa, yawɨta sabwi. ");
INSERT INTO byr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kwaaka Samerɨya mwaalyaihi sɨduta maalɨkaꞌ yadɨvɨꞌ Gotɨyarɨ yɨlaaya kwaasɨ kwaasɨ yadɨvɨsaihɨlyɨ. Juyainaavɨdaasɨ dakɨnɨkei bɨwaka, aꞌmweraavɨ padaihasamaaꞌdeꞌna Gotɨyarɨ nayaa yawɨꞌna yadaa yɨlaaya tewaanna yadaanyaine Juyaina. ");
INSERT INTO byr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sareꞌ kɨrɨꞌ sagaaꞌ yɨmaꞌnadehaaꞌ gɨthɨwegaaꞌ, dahaaꞌ miꞌna yɨmaꞌnɨwakegaaꞌ aꞌmwera, aꞌmwe Nɨmwarɨ yɨlaaya nebwina yɨpɨꞌdera. Kumɨre kuryara yɨlaaya yɨpɨꞌdeꞌ nabaai, nebulyaꞌna yɨlaaya yɨpɨꞌdera. Sareꞌ dareꞌnesɨ. Sara yɨlaaya yɨpɨꞌderaavɨna Gotɨyai dɨna ‘Sahwara yɨlaaya nyɨpɨka!’ dadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gotɨyai Kuryalyɨ. Aꞌmwei mɨka. Sareꞌna aꞌmwera kumɨre kuryaraavɨjɨ nebulyaburɨjɨ yɨlaaya yɨpɨnerera. Yaasɨwaꞌna yɨlaaya mipɨna!” ");
INSERT INTO byr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Aꞌmwe saꞌ wɨdɨna “Dara yawɨꞌmwa. Dɨvi Mezaayai yaya pɨrɨꞌ Kɨraazɨtɨyai woꞌnɨkei bathelyɨ. Sai bazai yuyabwi, yuyangɨ nedathelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jizaazai wɨdɨna “Dahaaꞌ gɨthɨvanɨge dainyɨ nɨmɨ sahwainyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sagaasagaaꞌ Jizaazarera yagalaawɨna yeva dara wanganesaꞌ “Ai, aꞌmwevɨ wɨdɨvanɨkei daaka!” Deva atɨka maruꞌnaꞌna yeva kɨrɨꞌ kumɨjɨya aane pwai kwai savɨ mujɨna “Baaꞌna bahɨneka?” sarɨ myɨwaarayɨna “Aꞌmwe savɨ baaꞌna wɨdɨvanɨgɨna?” Sara mujɨ, navɨka mwaalɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Sarevɨdaaꞌnyɨ aꞌmweꞌ gannya aalɨgwareꞌ wakɨna yaka gannya angebanna ayɨna wɨlaawɨna yaka aꞌmwe anga sabanyaraavɨ wɨdɨna ");
INSERT INTO byr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ai, aꞌmweihi kaajɨla! Aꞌmwe pwarɨ danganyɨla! Yuya yadɨnyanna nyɨdɨwakelyɨ. Gotɨyai dahɨlakyaakei Mezaayai dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Sara wɨdɨna kyaꞌ anga saba yaꞌmaꞌna yeva sahwaryawɨnna wɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Angebanna aꞌmweꞌ wodaaꞌnyɨ gamɨrera Jizaazarɨ wɨdɨna “Nejɨwaakadɨnyaigɨ, wapaa dɨmaranana!” ");
INSERT INTO byr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sara wɨdɨna kyeꞌ kɨrɨꞌ wɨdaꞌ “Aala, wapaa pɨnɨjɨyainyɨ sarɨmɨ mwanganya.” ");
INSERT INTO byr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Miꞌna wɨdɨna wɨyakevɨdaaꞌnyɨ gamɨrera yɨwaaraꞌnyɨna “Pwai wapaaya dahamakabɨwaka?” ");
INSERT INTO byr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jizaazai wɨdɨna “Nɨmɨre wapaaya pɨrɨsɨ. Daꞌna yɨhɨthɨvanɨge. Nyɨdasaabakei sara nyɨdɨvanɨkebwi gamɨre sɨmunyabwi sara yɨvanɨgeꞌna nɨmɨre wapaayasɨ. Gamɨre wawɨnyaꞌ miꞌna yɨꞌmwannyaꞌneꞌ nɨmɨre wapaayasɨ. ");
INSERT INTO byr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Sarɨmɨ wawɨnya tɨnna wangadɨvɨꞌ dara dɨdɨvɨꞌ midaaka! ‘Lawe dɨkaai dɨkaai kwavɨlavojɨ wapaaya mɨlaadera.’ Yɨhɨthɨwa. Dahaaꞌ saꞌ madɨpɨna! Yɨthaanyi! Wawɨnya keinɨngɨ nayaa danganyɨla! Kɨgaaꞌ pwara burɨnna yeva witɨzɨla yawaka yɨꞌnɨkabaaibɨꞌ aꞌmwera nɨmɨnyɨna yarai nyuꞌnɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pwai wapaaya mɨlojɨ mɨlojɨ kave yovɨrawakadeꞌ gamɨre tɨvɨkɨta mena maaꞌmanɨꞌ. Yɨ witɨzɨla yuyagaaꞌ yuyagaaꞌne gaalyabwine mena yovɨrawakɨvanɨꞌ. Sɨla pɨraihɨrakadelyɨ wapaaya yovɨrawakadelyɨ ‘Witɨzɨla mena warɨkeꞌna yɨlaaya yaka!’ dahɨla sara yovɨrawakɨvanɨꞌ. Saꞌna pwai Gotɨyare yagaalyaꞌ wɨjɨwaakɨna yadelyɨ pwai aꞌmwera Gotɨyareraavɨ wɨmwaaihɨna yadelyɨ saraai sareꞌna yɨlaaya yɨkaderaalyɨ. ");
INSERT INTO byr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Sareꞌ dareꞌnesɨ. Darevɨ nebulyaꞌ dɨdɨvɨꞌ ‘Aꞌmwe pwai burɨnna yadelyɨ. Aꞌmwe pwai midelyɨ.’ Yɨ saꞌ nebulyasɨ. ");
INSERT INTO byr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wawɨnya pɨrɨvɨ sarɨmɨ myesavɨna ‘Wapaaya dɨmaaryɨla!’ yɨhɨthɨwe. Wawɨnya savɨ pwara mɨraagɨkɨꞌna kyeꞌ sarɨmɨ kumɨre wapaaya dɨmaaryidengɨ. Sɨnnawɨ pwara aꞌmweraavɨ Gotɨyare yagaala wɨjɨwaakɨna yadɨvɨꞌ dahaaꞌ sarɨmɨ yagaala tewaanyaꞌ kudapɨjɨ aꞌmwera nɨmɨrera yɨmaꞌnɨpɨꞌderera,” wɨdɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Anga saba mwaalyara Kwaaka Samerɨya mwaalya kwalaalyara aꞌmwevɨre jalɨkurakyaꞌ kadɨka wɨꞌnyɨna “Yuya yadɨnyanna nyɨdɨwakelyɨ.” Sara kadɨka wɨꞌnyɨna yeva Jizaazarɨ lɨmwanna yadɨvɨꞌ “Mezaayai Kɨraazɨtɨyalyɨ. Gotɨyai dahɨlakyaakelyɨ,” dɨna. ");
INSERT INTO byr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sarevɨdaaꞌnyɨ Kwaaka Samerɨya mwaalyara gamɨnyawɨnna wɨna yeva dɨragɨnna wɨdɨna “Nemɨnyawɨ se daꞌmwaka!” Wɨdɨna kyeꞌ savɨ yɨrɨka daryaai mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mwaalɨna yada gamɨre yagaala wɨdɨna yakeꞌna pwara kwalaalyara gamɨnyɨ lɨmwanna yeva dɨna “Mezaayalyɨ. Gotɨyai dahɨlakakelyɨ!” ");
INSERT INTO byr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Dɨna yeva aꞌmwevɨ wɨdɨna “Nabaai, dahaaꞌ gamɨnyɨ lɨmwamanɨgo. Nedɨwaanyaꞌna mɨka! Sareꞌ dareꞌnesɨ. Nemɨ sahwaina kadɨka wɨꞌnona dara yawɨꞌmanɨgoꞌ ‘O, nebulyaꞌ, Kwaaka davakɨ mwaalyaraavɨna Naangei padaihasamaaradei daaka!’ Sara dona gamɨnyɨ lɨmwamanɨgo.” ");
INSERT INTO byr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Anga saba sawɨta daryaai Jizaazai waꞌmwaraka saba yaꞌmaꞌna yaka Kwaaka Galɨlina wɨna. ");
INSERT INTO byr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jizaazai sahwai wɨdakeꞌ “Gannyaba mwaalyara aꞌmwe pɨropetɨyai Gotɨyarɨ wɨꞌnawɨjɨwaakaderɨ mujɨ ‘Aꞌmwe naangeigɨnyɨ,’ mujɨ yadɨvɨsalyɨ.” Wɨdakeꞌna Galɨlina wɨna. ");
INSERT INTO byr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Miꞌna wɨna kyaꞌ saba mwaalyara gamɨnyɨna maarɨna. Anga Jeruzaalemɨ Pariꞌmaꞌmunneꞌna kaanna yeva munnegaaꞌ Jizaazai yuyangɨ tewaanna yadaaꞌnyɨyangɨ tɨnna wanganeva “Tewaanyasɨ,” desaꞌna gamɨnyɨna yɨlaaya yɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kwaaka Galɨli Anga Kena mannɨkebanna Jizaazai ayɨna wɨna. Saba kɨgaaꞌ dɨragɨnna kyaꞌ aangaalyaꞌ waꞌdɨꞌnyɨ aalya waainɨyaꞌ yɨmaꞌnɨkebe. Anga pɨba Kaapanɨyamɨ kingɨyare aꞌmwe naangei mwaalɨna yadɨꞌnyɨ gamɨre kaimɨraayai nabalɨnakei warɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jizaazai Anga Kenana ayɨna wɨna kyaꞌ kingɨyare sai dara wɨꞌnakeꞌ “Galɨlina Juthɨyadaaꞌnyai Jizaazai damwaalɨꞌ!” Miꞌna daka gamɨnyawɨnna wɨna yaka yɨdaanganaꞌ “Nɨmɨre kaimɨraayai yarai baladeꞌna nɨmɨjɨ wawaꞌgɨzɨ nabalya saꞌ dɨmarasɨꞌnana! Yarala!” ");
INSERT INTO byr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jizaazai wɨdɨna “Sarɨmɨre yawɨꞌdɨvɨsabwi yawɨꞌmwa. Nɨmɨre yɨjɨwaainyajɨ dɨragɨnyajɨ sarɨmɨ tɨnna mwanganyɨpɨjaꞌ nɨmɨnyɨ manyɨlɨmwagyɨ jideihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kingɨyarei kave wɨdɨna “Aꞌmwe naangeigɨ, nɨnnya kaimalei nabaladɨka! Naarɨmɨ yarai wawaka!” ");
INSERT INTO byr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jizaazai wɨdɨna “Gɨnnya angevɨna kaanna dɨwona! Gɨnnya kaimalei mabalyai mwaalɨꞌ. Nabalyaꞌ maayai mwaalɨꞌ.” Jizaazai wɨdakeꞌ aꞌmwe sai lɨmwanna yaka dɨna yada “Nebulyasɨ,” kaanna wɨna. ");
INSERT INTO byr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Gannya angevɨna kuna kaanna wɨna yadaaꞌnyɨ gamɨre yaasɨwaꞌwawɨnyara wɨjɨmaaꞌnyɨna yeva wɨdɨna “Gɨmɨre kaimɨraayai tewaanya mwaalɨꞌ. Nabalyaꞌ aawa.” ");
INSERT INTO byr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Sarevɨdaaꞌnyɨ sai yɨwaaraꞌna “Nɨmɨre kaimɨraayarɨna gathɨngaaꞌ yɨwɨwaka?” Sara yɨwaaraꞌna kyaꞌ wɨdɨna “Wona sɨrɨgwajahaaꞌ waanɨ kɨlokɨyagaaꞌ kɨlaaka dɨka menanyɨra.” ");
INSERT INTO byr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Sarevɨdaaꞌnyɨ ganɨmaangei yawɨꞌna “Yo, sagaasagaaꞌ Jizaazai nyɨjawaalɨꞌ ‘Gɨnnya kaimalei tewaanyai mwaalɨꞌ.’ ” Sara yawɨꞌna yaka kɨnɨdaka sahwarɨ lɨmwanna yesanɨdakera. ");
INSERT INTO byr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kwaaka Juthɨyadaasɨ Kwaaka Galɨlina yɨꞌmavaawɨna yaka Kwaaka Galɨli yɨjɨwaainyaꞌ kaimalerɨna yakeꞌ dɨragɨnya pɨrɨwaalyaꞌ yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Sare mena kyɨmaꞌnaꞌ Juyara Gotɨyarɨna tɨka munneꞌ nadɨvɨsagaaꞌ kyɨmaꞌnaꞌ Anga Jeruzaalemɨna Jizaazai kaanna wɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jeruzaalemɨ saba Sipɨzipɨtɨkuryaꞌ woꞌnɨkevɨ pimagɨnyavɨ aalɨbunyaꞌ dɨꞌnaꞌna yaꞌ. Aalɨbumaangevɨ yɨhulɨvɨlɨya ati mannɨꞌ. Aalɨbunya saꞌ “Bethezɨtha,” Yɨvɨruyagaala woꞌnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yɨhulɨvɨlɨyangɨ nalaavɨnaka kwala naanga mwaalɨna yeꞌ. Nalaavɨnakera pwara tɨbɨnyara, pwara sɨvɨla nadɨya yɨnɨkera, pwara kɨlaaka bainɨkera mwaalɨna yeꞌ. Savɨ yuyara aalyaꞌ kwaayakwaayaꞌna yemwaaina. ");
INSERT INTO byr_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Pɨgaaꞌ, pɨgaaꞌ aalyavɨ Sɨgunyavɨdaasai Naangere mamaayai ejelɨyai walaabɨna yaka aalyaꞌ gɨnyɨwanna. Sara gɨnyɨwanna kyaꞌ sagaaꞌ sɨnnawɨnyai nalaavɨnakei aalya sɨnaapwipulyavɨ yarai walaawɨna, yɨthaa, maamɨdaryai yɨmaꞌnakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Yemwaaina yadɨvɨꞌ nabaai, aꞌmwe akwai yemwaaina yada kwarame naanga naanga (kwarame 38) wavɨlaꞌdaaꞌnyai nalaavɨnakei mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sai mwaalɨna yadɨꞌnyɨ Jizaazai bɨna yaka yawɨꞌna “Weꞌ, aꞌmwe sai nalaavɨnakei kwarame kwalaalya mwaaidelyɨ,” yawɨꞌna yaka wɨdɨna “Gɨmɨre sɨmunya ‘Maamɨdaryainyɨ yɨmaꞌnɨma!’ yawɨꞌdɨnyaigɨ daaka?” ");
INSERT INTO byr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nalaavɨnakei jaꞌnawɨdɨna “Aꞌmwe naangeigɨ, aalyaꞌ kwaaya yadaaꞌnyɨyagaaꞌ ‘Aalɨbunyavɨ nyɨmarapaihana!’ dena aꞌmwe bewai yanneka? Walaawɨna yadaazɨ sɨnnawɨ pwai yarai wavɨlaꞌna nyada aalyavɨ paihɨnyɨna yadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jizaazai wɨdɨna “Daavaꞌgɨzɨ nalabwaryaꞌ pwalaꞌgɨzɨ kaanya dɨmakwo!” ");
INSERT INTO byr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sara kudaꞌ yɨmeꞌnyaꞌbɨꞌ aꞌmwei maamɨdaryai yɨmaꞌnaka gannya nalabwaryaꞌ pwalaka kaanna wɨna yaꞌ. Sagaaꞌ Juyaraavɨre Kwazaakegaaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Sarevɨdaaꞌnyɨ Juyara naangera nalaavɨnakei tewaanyai yɨmaꞌnakerɨ wɨdɨna “Juyainaavɨre Kwazaakegaakɨ. Nemɨre kɨwɨnyaꞌ dɨnɨꞌ ‘Kwazaakegaaꞌ nalabwaryaꞌ mamakunnera!’ Sara dɨnɨkegaaꞌ beꞌna makuvanɨgɨna?” ");
INSERT INTO byr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sai wɨdɨna “Aꞌmwei maamɨdarya nyɨdɨkaaꞌmwakei nyɨdɨwaꞌ ‘Gɨnnya nalabwaryaꞌ pwalaꞌgɨzɨ kaanya dɨmakwo!’ Sara kanyɨdɨwakɨra.” ");
INSERT INTO byr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kumɨ yɨwaaraꞌna “ ‘Gɨnnya nalabwaryaꞌ pwalaꞌgɨzɨ dɨmakwo!’ gɨthɨwakei aaihwalaka?” ");
INSERT INTO byr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yɨwaaraꞌna kyeꞌ kɨrɨꞌ tewaanya yɨmaꞌnakei myawɨrina. Sareꞌ dareꞌnesɨ. Aalɨbunyavɨ kwala naanga mwaaidapi Jizaazai kave wɨna kyaꞌ sai sahwarɨna wɨdaꞌ “Aaihwai dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Dɨvi sagaaꞌ Gotɨyare Angevɨ Jizaazai gamɨnyɨ bɨramaaraka wɨdɨna “Yɨthaa, dahaaꞌ maamɨdaryaigɨ mwaaihɨ. Kayaaꞌnanyabwi minna! Kɨgaaꞌ nabalya kayaaka gihaideigɨnyɨ. Aya kayaaꞌnanaanga gyadeꞌbɨta naanga pɨrɨꞌ nagyathɨka! Gɨmɨre kayaaꞌnanya minna!” ");
INSERT INTO byr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Aꞌmwei Jizaazarɨ kadɨka wɨꞌnyɨna yakegaaꞌ Juyara naangeraayawɨnna wɨdaawɨna “Aꞌmwei maamɨdarya nyɨdɨkaaꞌmwakei Jizaazalyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sarevɨdaaꞌnyɨ naangera dara yawɨresaꞌ “Nɨwaava, Juyainaavɨre Kwazaakegaaꞌ kayaakaꞌna aꞌmwe sai sabwi yadei daaka!” Sara deva Jizaazaryawɨnna kaanna yeva sagaaꞌ Kwazaakegaaꞌ sara yakeꞌna “Balana!” deva maanga gaai wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Maanga gaai wɨdɨna yadɨvɨꞌ Jizaazai wɨdɨna “Dahaaꞌna nɨnnya Nɨmwai yɨvanɨkegaaꞌnanyɨ. Nabaai nɨmɨ yɨvanɨgeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sarevɨdaaꞌnyɨ Jizaazai sara wɨdakegaaꞌ Juya naangera dɨnyɨna “Nemɨre kɨwɨnyaꞌ Kwazaakegaaꞌna kayaaka yɨwaꞌ. Saꞌ kayaaꞌnanyasɨ. Kayaaꞌnanyaꞌ kɨrɨꞌ nedɨwaꞌ ‘Gotɨyai nɨnnya Nɨmwalyɨ,’ saꞌ kayaaꞌnanaangesɨ. Yarai balana!” Jizaazai wɨdɨna “Gotɨyai nɨnnya Nɨmwalyɨ,” yaka “Nɨmɨ Gotɨyarɨ avaalyainyɨ,” dɨnɨkeꞌna dɨnyɨna yeꞌ Juyara. ");
INSERT INTO byr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Juya naangera dɨnyɨna yesagaaꞌ Jizaazai gamɨnyɨna wɨdaꞌ “Naanga nebulyaꞌna yɨhɨthɨvanɨge. Gawaalɨvaangei gamɨre sɨmunyavɨdaaꞌnyɨ aane pɨrɨꞌ kɨrɨꞌ yannei mɨꞌ. Aawa. Nɨmwai yadaawori wanganajanna yadelyɨ. Sareꞌ dareꞌnesɨ. Yuya Nɨmwai yade Gawaalɨꞌ yɨvanɨke sahɨnɨngɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sareꞌ dareꞌnesɨ. Nɨmwarɨ Gawaalɨvaangerɨna wɨvuꞌnadeꞌna Nɨmwai sahwai wawɨnya yɨvanɨka yuya sa yɨbwarɨdaakwadelyɨ. Gawaalɨꞌ nabalɨnakerɨ tewaanya yaka wawɨnya maalɨkesɨ. ‘Sarɨmɨ atɨka maruꞌnaꞌna jɨla!’ daka Nɨmwai wawɨnya naange wibwarɨdaakwojɨ Gawaalɨꞌ sana yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sareꞌ dareꞌnesɨ. Nɨmwai bainɨkeraavɨ yɨdɨkaaꞌda gaala wɨjaavadevaaibɨꞌ Gawaalɨꞌ ‘ “Sahwaraavɨ yɨdɨkaavɨma!” daꞌmujɨ wɨmwaaihɨma!’ dozɨ gaalyabwi wɨjaavadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Sareꞌ dareꞌnesɨ. Nɨmwai aane pwarɨ kwarɨ kotɨyaꞌ mujadelyɨ. Aawa. Wawɨnya savɨna dɨragɨnyaꞌ Gawaalɨvaangerɨ kujaawaꞌ sai kotɨya yuyanna wɨdathelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Sarevɨ ‘Aꞌmwe yuyara Nɨmwainyɨne yayaꞌ munyabanna makimanɨgatabaaibɨꞌ Nyɨbwaalɨvɨne yayaꞌ makibɨka!’ daka wɨjaawakelyɨ. Gawaalɨvaangerɨne yayaꞌ munyaba mamakɨlyadei yɨ sai Nɨmwai wɨdasaabakerɨne yayaꞌ mamakɨlyadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Naanga nebulyaꞌna yɨhɨthɨvanɨge. Aꞌmwei yagaalyavɨ kadɨka nyuꞌnajai Gotɨyai nyɨdasaabakerɨ lɨmwagaꞌna yojɨ sagaasagaaꞌ yuyagaaꞌ yuyagaaꞌne gaalyabwi kɨnɨnnakelyɨ. Sai kotɨyaꞌ jɨdayaꞌneba wɨlaabathei mɨꞌ. Aawa. Sahwai balyaburɨdaaꞌnyɨ gaalyaburɨna mena gaꞌmaꞌna yɨwakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Naanga nebulyaꞌna yɨhɨthɨvanɨge. Pɨgaaꞌ yɨmaꞌnyaꞌnegaaꞌ dahaaꞌ bainɨkera balyabwi yadɨvɨsara Gotɨyare Gawaalɨvaangere maanguraayaꞌ kadɨka mena wɨꞌnapɨjɨ nabaai, kadɨka wɨꞌnɨpɨjara gaala mwaaibɨꞌdere. ");
INSERT INTO byr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sareꞌ dareꞌnesɨ. Nɨmwai dɨragɨnna mwaalɨkei gamɨ sahwai gaalyabwine aaya kaavɨlyai mwaalɨkabaaibɨꞌ Gotɨyai Gawaalɨvaangerɨna dɨna kyaꞌ Gawaalɨvaangei gamɨ sahwai gaalyabwine aaya kaavɨlyalyɨra. ");
INSERT INTO byr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sahwai, Aꞌmweraavɨne Kaimɨraayai mwaalɨkeꞌna Gotɨyai wɨdaꞌ ‘Dɨragɨnyaꞌ kagɨzaawa aꞌmweraavɨna kotɨyaꞌ jawɨbwaꞌdeigɨnyɨ.’ ");
INSERT INTO byr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Sara wɨdaka saꞌ atɨka mamaruꞌnapɨna! Dɨvi pɨgaaꞌ yɨmaꞌnajahaaꞌ wakadɨvɨsangɨdaaꞌnyɨ baryara gamɨre maanguraayavɨ wɨꞌnapɨri ");
INSERT INTO byr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kunnya wakɨnɨkeba yagalyaꞌmaꞌna, walyaabɨna yɨpɨꞌdere. Pwara mwaalyagaaꞌ tewaanna mwaaibɨzara dɨkaavapɨjɨ gaalyabwi maapɨꞌdere. Pwara mwaalyagaaꞌ kayaaꞌna mwaaibɨzara kadɨkaavapɨjɨ kotɨyaꞌ jɨdasabwi maapɨꞌdere. ");
INSERT INTO byr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nɨmɨre sɨmunyavɨdaaꞌnyɨ aane pɨrɨꞌ kɨrɨꞌ mi yɨwɨneinyɨ. Yagaala Nɨmware wɨꞌnɨwebaaibɨꞌ maryawɨbwaꞌmanɨge aꞌmweraavɨ kotɨyaꞌna. Nɨmɨre sɨmunyavɨ mabɨramaarivanɨge. Aawa. Nyɨdasaabaka sare sɨmunyaꞌ maaꞌmanɨgeꞌna nɨmɨre yawɨbwata saꞌ yɨdaꞌmaraangesɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Sahwainyɨ gaveinyɨ ‘Naangeinyɨ,’ jalɨkurakɨmujɨ kwajɨ pwara ‘Nebulyaꞌ mɨka!’ kadɨpɨdɨka! ");
INSERT INTO byr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nɨmɨnyɨna nayaa jalɨkurakadei pwai mwaalɨꞌ. Yagaala sara yɨhɨzalɨkurakɨvanɨkeꞌ ‘Jalɨkurakya saꞌ nebulyasɨ,’ yawɨꞌmwa. ");
INSERT INTO byr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jonɨmyawɨnna sarɨmɨ aꞌmweraavɨ kudaaseꞌ Jonɨ nebulyaburɨna yɨhɨzalɨkurakaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Sareꞌna aꞌmwe gaveraavɨ nɨmɨnyɨna jalɨkurakyabwina mamaaryadɨnyainyɨ. Aawa. ‘Sarɨmɨnyɨ nayaa yɨhɨvadaihasamaarɨma!’ dena yɨhɨthɨvanɨge. Jonɨ yɨhɨthakeꞌna ");
INSERT INTO byr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jonɨ dɨꞌbaakelyɨ. Dɨꞌbaaka sai naka aꞌmweraavɨna wanyɨna yakelyɨ. Jonɨ mwaalaka gannya baakeꞌ sarɨmɨnyɨna wanyɨna yakeꞌ, maalɨkegaaꞌ baaka savɨna gamɨre yagaalyavɨna yɨlaaya yesaihɨlyɨ. Jonɨ nɨmɨnyɨna nayaa yɨhɨthakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nabaai, nɨmɨnyɨna jalɨkurakya pɨnɨ warɨke Jonɨmɨre yagaalyavɨ wavɨlaꞌna yaka dɨnɨkengɨ. Sareꞌ dareꞌnesɨ. Yuya yɨvanɨge Nɨmwai ‘Sana ja!’ nyɨdade wawɨnya sa yɨvanɨge tɨnna wanganeva dara yawɨꞌmwaasaꞌ ‘O, Jizaazai sara yadeꞌna Ganɨmaangei wɨdasaabakei daaka!’ Jalɨkurakya sahɨrɨsɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nɨmɨre wawɨnya sa nɨmɨnyɨna yɨhɨthɨvanɨka nabaai, Nɨmwai nyɨdasaabakei nɨmɨnyɨna nayaa jalɨkurakɨwakelyɨ. Sareꞌna sarɨmɨ gamɨre maanguraayaꞌ kadɨka muꞌnyadɨvɨꞌ gamɨre sɨnnyaꞌ tɨnna mwanganyadɨvɨsaihɨlyɨ. Arɨkawɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Sarɨmɨre sɨdusangɨ gamɨre yagaalyaꞌ mwarɨbainyɨꞌ. Sahwai nyɨdasaabakeinyɨ dainyɨ manyɨlɨmwagyadɨvɨsaꞌna gamɨre yagaalyaꞌ mwarɨbainyɨna. ");
INSERT INTO byr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Sarɨmɨ yawɨꞌna ‘Yuyagaaꞌ yuyagaaꞌne gaalyabwi kɨnɨnnakeinyɨ mwaalɨma!’ yawɨꞌna yadɨvɨsaꞌna Gotɨyare bukuyaꞌ kave bɨrɨna bɨrɨna yadɨvɨsaihɨlyɨ. Gotɨyare bukuyaꞌ dɨnɨke sahɨnɨ nɨmɨnyɨna jalɨkurakɨnɨkeinyɨra. ");
INSERT INTO byr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nɨmɨnyɨna dɨnɨkeꞌna kɨrɨꞌ sarɨmɨ ‘Gaalyabwi kɨnɨnnakeinyɨ mwaalɨma!’ deva nɨmɨnyawɨnna dɨvideꞌ sarɨnnya sɨmunyangɨ myawɨrivanɨgaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nɨmɨnyɨna ‘Yɨlaaya yaadeina daaka!’ dɨpɨjaꞌ sarɨmɨresɨ. Aꞌmweraavɨ byaannyaꞌ mamaarivanɨge. ");
INSERT INTO byr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Aawa. Sarɨmɨnyɨna yawɨꞌmwa. Sarɨmɨnyɨ Gotɨyarɨna tewaanya yɨhɨvuꞌnadevwi mwariꞌ. Sareꞌ yawɨꞌmwa. ");
INSERT INTO byr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nɨmware dɨragɨnyaꞌ maarena gamɨnyɨne yayavɨ bɨwa. Kabɨwa kɨrɨꞌ sarɨmɨ nɨmɨnyɨ mamaari. Pwai gannya dɨragɨnyaꞌ maarojɨ gannya yayavɨ bazai, yɨ sahwarɨ dɨmaaryideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sahwaihi sarɨmɨnyɨna ‘Aꞌmwe tewaanyalyɨ,’ deva yɨlaaya marivanɨgasaꞌ byaannyaꞌ wɨjaavanɨgasaꞌna ‘Gotɨyai gavei yɨlaaya neyana!’ majaihɨlyɨ. Sarɨmɨ sara yadɨvɨꞌ nɨmɨnyɨna gara dɨnyɨlɨmwagyideihɨlaka? ‘Naangeigɨnyɨ,’ gara dɨzideihɨlaka? ");
INSERT INTO byr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Sareꞌna myawɨri yadɨvɨꞌ dɨvi sarɨmɨ dɨnyɨna yɨpɨꞌde ‘Ganɨmaangerɨ nemɨnyɨna kotɨyaꞌ jɨna yadei daaka!’ Sara myawɨpɨna! Aawa, nɨmɨ kotɨyaꞌ jɨna myɨwɨna! Sarɨmɨ Ne Mozɨzarɨna dɨnyɨna ‘Sai nevadaihasamaaradelyɨ,’ dɨnyɨna yadɨvɨꞌ kɨrɨꞌ Ne Mozɨzai sarɨmɨnyɨna kotɨyaꞌ jɨna yɨhyathelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sareꞌ dareꞌnesɨ. Mozɨzai nɨmɨnyɨna bukuyaꞌ yɨdaꞌnɨkeꞌna sarɨmɨ Ne Mozɨzarɨ nayaa lɨmwanna yɨpɨjɨ kwajɨ kanyɨlɨmwabɨthɨka! ");
INSERT INTO byr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kwaasɨ yadɨvɨꞌ Mozɨzai yɨdaꞌnɨke malɨmwagi yeva yagaala yɨhɨthɨwe gara dɨnyɨlɨmwagyideihɨlaka?” ");
INSERT INTO byr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Sare mena kyɨmaꞌnaꞌ Aalɨbunya Galɨli (yaya pɨrɨꞌ Aalɨbunya Taaivɨrɨyaazavɨ) Jizaazai sɨpɨyavɨ wɨlamwaaina kyaꞌ pimagɨnna makuna. ");
INSERT INTO byr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Makuna kyaꞌ kwala bwaꞌnaanyaꞌ mɨdɨnna. Yɨjɨwaainya naange Jizaazai nalaavɨnakera tewaanyaraavɨ wɨmwaaihɨna yake tɨnna wanganna yesaꞌna Jizaazarɨ mɨdɨnna yeva gamɨnyawɨnna bɨna. ");
INSERT INTO byr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Miꞌna bɨna kyeꞌ mugunyavɨ yɨlaawɨna yaka saba gamɨrerari walamwaaina. ");
INSERT INTO byr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Sagaaꞌ Juyaraavɨre Pariꞌmaꞌmunneꞌnegaaꞌ aya kɨgaaꞌ yɨmaꞌnakegaakɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Walamwaaina yaka Jizaazai wanganaasɨna yaka tɨnna dara wanganakeꞌ “Nɨmɨnyawɨnna kwala naanga davɨvanɨgaꞌ!” Sara dakeꞌna Pilipɨmɨ wɨdɨna “ ‘Aꞌmwe dara wapaaya nɨpɨka!’ dona gɨrɨkula yuyaraavɨne gawɨ mubaazɨwona?” ");
INSERT INTO byr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jizaazai Pilipɨmɨna dɨna “Gara nyɨdazɨhyɨwaka? Yaamɨjɨ wɨdɨma!” Sareꞌ dareꞌnesɨ. “Sara yɨdeinyɨ,” mena yakei. ");
INSERT INTO byr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipɨ jaꞌnawɨdɨna “Weꞌ, ‘Gazaizai maalɨkeꞌ maarana!’ dona kinaaya 200 (tu aadɨretɨ) wapaaya bɨretɨyanne mubaazɨ kwajɨ wiꞌna yɨmaꞌnadeꞌ mɨꞌ.” ");
INSERT INTO byr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Gamɨre pwai Edɨruyai Saaimonɨ Pitare gahwaalaangei Jizaazarɨ wɨdɨna ");
INSERT INTO byr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Dava kaimale pwai yɨsɨla baali bɨretɨya atɨlyajɨ jawɨnya pɨrɨwaalyɨ sa kɨnɨnnakei mwaalɨꞌ. Sare kɨrɨꞌ aꞌmwe kwalaalya darera tɨka nyaꞌne wapaaya sa benɨngaka!” ");
INSERT INTO byr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jizaazai wɨdɨna “Aꞌmweraavɨ aꞌmwengɨ duzɨla! ‘Dalamwaalyɨla!’ ” Saba kurɨdarya naangebe. Sarevɨdaaꞌnyɨ aꞌmwera aꞌmwe walamwaaina. Aꞌmwera gavera kwalaalyara (5,000) mwaalɨna yeva walamwaaina. ");
INSERT INTO byr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yuya, aꞌmwera aꞌmwe walamwaaina kyeꞌ Jizaazai bɨretɨya sa maarɨna yaka Gotɨyarɨ “Su! Su!” wɨdɨna kyaꞌ bɨretɨya naanga yɨmaꞌnadaaꞌnyɨ aꞌmwe walamwaaina yadapiyangɨna yanga wɨjaavɨna. Wɨjaavɨna yaka bɨretɨya wɨjaavakabaaina jawɨnyawaai wɨjaavɨna kyaꞌ “Sareꞌ nɨma!” yawɨꞌdɨvɨꞌ sara nyɨna kyeꞌ munya winaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Munya kwinaꞌ sai gamɨreraavɨ wɨdaꞌ “Nagihɨwaasa yaasɨwaꞌ warya nyadɨka! Wapaaya waꞌmwaka yuya dɨmaaryi!” ");
INSERT INTO byr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sarevɨdaaꞌnyɨ gamɨrera sara yeva soigɨlya atɨraai sɨvɨlyɨrɨdaaꞌnyɨ pɨrɨwaalyangɨ mihɨna mihɨna kyeꞌ maanga yekuꞌnyɨna. Aꞌmwera aꞌmwe yɨsibaalibɨretɨya nagihesa soigɨlya sangɨ maanga yekuꞌnyɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Sarevɨdaaꞌnyɨ aꞌmwera Jizaazai yɨjɨwaainya saꞌ yakeꞌ tɨnna wanganna yeva dɨnyɨna “Gotɨyai wɨjaaka ‘Kwaakevakɨ nyuꞌnawɨjɨwaakadei bathelyɨra,’ wɨjaakei sahwalyɨ. Nebulyasɨra. Sahwalyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sarevɨdaaꞌnyɨ Jizaazai dara wanganakeꞌ “ ‘Kingɨyai nemaremwaaladei yɨmaꞌnana!’ dapi yarai galalɨmwanna nyɨpɨꞌdera daaka!” Sara daka mugunyavɨ ayɨna yɨlaawɨna yaꞌ gavei. ");
INSERT INTO byr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sawɨtɨrɨnyagaaꞌ aalɨbumaangebaarɨna gamɨrera walaawɨna yeva ");
INSERT INTO byr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","sɨpɨyavɨ yɨlamwaaina kyeꞌ aalɨbunyavɨ Anga Kaapanɨyamɨna makuna. Sawɨsaꞌ kajɨnnaꞌ kumɨnyawɨnna Jizaazai kuna mabyaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Sɨpɨyaꞌ makuna yadaaꞌnyɨ yɨhuta naangeꞌ yaka aalɨmavajɨnaaka naanga yɨna yadaaꞌnyɨ ");
INSERT INTO byr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","naangeba (5 kilomitaaya pɨnɨ, 6 kilomitaaya kɨnɨ) gamɨrera sɨpɨyaꞌ yɨsajɨ aalyavɨ maarɨmaarya yɨna. Sarevɨdaaꞌnyɨ aalyavɨ aꞌba Jizaazai gaꞌnɨguna yaka sɨpɨyavɨ aya kɨbanna yɨꞌmaꞌna yakerɨ tɨnna wanganna yeva lɨka naanga yɨna. ");
INSERT INTO byr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lɨka naanga yɨna kyeꞌ sai wɨdɨna “Nɨmɨnyɨra. Lɨka mipɨnera!” ");
INSERT INTO byr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Sara wɨdɨna kyaꞌ gamɨrera dɨna “Sɨpɨyavɨ yɨlamwaalana!” Dɨna kyeꞌ sahwai yɨlamwaaina kyaꞌ sagaaꞌ “Sabanna yɨꞌmavawaana!” desabanna sɨpɨyaꞌ yarai yɨmaꞌnaabɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mwanyavɨ aalɨbunya pimagɨ kwala bwaꞌnaanyaꞌ kuna mwaalɨna yeva dara yawɨresaꞌ “O, wona sɨpɨya pɨnɨ mwari kyɨwaꞌdɨꞌ gaveꞌ yɨlaꞌmwaꞌdɨkeꞌ daaka!” Nabaai, dara yawɨresaꞌ “Sɨpɨyaꞌ gannyarajɨ Jizaazai milamwaalyɨ yawaalɨꞌ. Aawa. Sahwarɨ yaꞌmaꞌna kyawaaihaꞌ sɨpɨyaꞌ gavera damakwiawaalɨka!” ");
INSERT INTO byr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Dadaapi Anga Taaivɨrɨyaazɨdaaꞌnyɨ aalɨbumaanga sabaarɨna sɨpɨya pɨnɨ bɨna. Naangei Gotɨyarɨ “Su! Su!” wɨdɨna kyaꞌ kwala bwaꞌnaanyaꞌ bɨretɨya nesaba samwinebanna sɨpɨya sa bɨna. ");
INSERT INTO byr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sarevɨdaaꞌnyɨ kwala bwaꞌnaanyaꞌ dara wanganesaꞌ “O, Jizaazai pwai midaaka! Jizaazarera pwara midaaka!” Mena deva sɨpɨya sangɨ yɨlamwaaina yeva “Jizaazarɨna bɨraana!” deva Anga Kaapanɨyamɨna wɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aalɨbunyavɨ aꞌmwera gaꞌmaꞌna yeva Jizaazarɨna bɨrɨna bɨrɨna yeva bɨramaaꞌna yeva yɨwaaraꞌna “Wɨjɨwaakyaigɨ, dava gathɨngaaꞌ bɨwaa?” ");
INSERT INTO byr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jizaazai jaꞌnawɨdɨna “Naanga nebulyaꞌna yɨhɨthɨvanɨge. Nɨmɨ dɨragɨnna yadɨnyangɨna yɨjɨwaainyangɨna sɨdusaꞌ nayaa myawɨryadɨvɨꞌ nyɨbɨꞌmanɨgaꞌ. Aawa. Bɨretɨya neva munya yɨhinyawaalɨkeꞌna nyɨbɨꞌmanɨgaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Wapaaya bwia buꞌdenna wawɨnyaꞌ minna! Aawa. Yuyagaaꞌ yuyagaaꞌne gaalyaꞌne wapaaya ge waragwode sanna wawɨnyaꞌ jɨ! Wapaaya sa Aꞌmweraavɨne Kaimɨraayai gɨzaavadengɨ. Sareꞌ dareꞌnesɨ. Gotɨyai Ganɨmaangei gannya dɨragɨnyaꞌ kujaavaꞌ baavanaka sahwai sara yadelyɨra.” ");
INSERT INTO byr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Sarevɨdaaꞌnyɨ kumɨ wɨdɨna “ ‘Nemɨ Gotɨyare wawɨnyanna yaana!’ dona gara yawaajɨ yaadeinaavaka?” ");
INSERT INTO byr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jizaazai jaꞌnawɨdɨna “Gotɨyare wawɨnya saꞌna daresɨ. Sahwai wɨdasaabakerɨna dɨragɨnna dɨlɨmwagarila!” ");
INSERT INTO byr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Sarevɨdaaꞌnyɨ kumɨ wɨdɨna “Nabaai, ‘Nemɨ tɨnna wanganawaajɨ gɨlɨmwagaana!’ dawaajɨ yɨjɨwaainyaꞌ garɨvɨ dɨneyɨdevaka? Berɨꞌ jɨzɨwaana? ");
INSERT INTO byr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Aꞌmwamaayaba Ne sɨnnawɨnyara sɨgunyavɨdaaꞌnya wapaaya manaaya nyaasare. Gotɨyare bukuyaꞌ dɨnɨkabaaibɨsasɨ. Sɨgunyavɨdaasɨ wapaaya tɨka nyaꞌne wɨjaavaꞌ. Sara dɨnɨkesɨ.” ");
INSERT INTO byr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Sarevɨdaaꞌnyɨ Jizaazai wɨdɨna “Nebulyaꞌna yɨhɨthɨvanɨge. Mozɨzai Sɨgunyavɨdaaꞌnya wapaayaꞌ mena yɨhɨzayaakei mɨka! Aawa. Nɨmaamaangei yuyagaaꞌ Sɨgunyavɨdaaꞌnya Wapaaya Nebulyarɨ yɨhɨzaavadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sareꞌ dareꞌnesɨ. Gotɨyare Wapaayai Sɨgunyavɨdaaꞌnyai Kwaakevakɨ mwaalyaraavɨna gaalyabwi wɨjaavadelyɨ yuyagaaꞌ.” ");
INSERT INTO byr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sarevɨdaaꞌnyɨ kumɨ wɨdɨna “Aꞌmwe naangeigɨ, yuyagaaꞌ wapaaya nedɨwaanyaꞌ dɨnejaadeigɨnyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jizaazai wɨdɨna “Gaalyabwine wapaaya sai sahwainyɨ. Aꞌmwera aawapaaya tɨka nyɨna yadɨvɨꞌ ayawɨ mɨjɨka yɨna. Aalya nyɨna yadɨvɨꞌ ayawɨ mɨjɨka yadɨvɨtara. Pwai nɨmɨnyawɨnna wɨlaabozɨ gannya kuryai mɨjɨka mwi. Arɨkewɨ. Sai nyɨlɨmwagozɨ aalyaꞌna mwinyɨ yadelyɨ. Arɨkawɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aawa. Nabaai, pɨrɨwaaina dara yɨhɨthɨwa. Tɨnna nyangamwaasainyɨ. Manyɨlɨmwagyɨvanɨgasaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nɨmwai nyɨjaavajara yuyara nɨmɨnyawɨnna bɨpɨꞌdeinyɨ. Nɨmɨnyawɨnna sara bozɨyarɨ mwasɨmagɨnna marasɨꞌnɨdei mɨka. Arɨkewɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nɨmɨ ‘Nɨmɨre sɨmunyabwi miwɨna! Aawa. Nyɨdasaabakere sɨmunyabwi yɨma!’ dena Sɨgunyavɨdaaꞌnyɨ walaabeinyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nyɨdasaabakere sɨmunyabwi daresɨ. Nɨmɨnyɨna yuyaraavɨ nyɨjaavake aane pwarɨ kwarɨ myagalyaꞌmayainyɨ. Aawa. Yɨrɨka Aayagaaꞌ sahwarɨ tewaanna yɨdɨkaavɨdelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Sareꞌ dareꞌnesɨ. Nɨmaamaangere sɨmunyabwi dara yawɨꞌmanɨkesɨ. Gazaizai Nyɨbwaalɨvɨ wanganojɨ sahwarɨ lɨmwagarojɨ yuyagaaꞌ yuyagaaꞌne gaalyabwi maarana! Sara kanyɨdaꞌ Yɨrɨka Aayagaaꞌ sahwarɨ yɨdɨkaavɨdelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jizaazai wɨdɨna “Sɨgunyavɨdaaꞌnyɨ Wapaayainyɨ walaabeinyɨ.” Wɨdɨna yakeꞌna Juyara pwara jɨkurya yeva kɨnɨmyagaala dɨna. ");
INSERT INTO byr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Sarevɨdaaꞌnyɨ dɨnyɨna “Baaꞌna nedɨwaꞌ? Aꞌmwe dai Jizaazai Jozepɨyare gawaalɨvaangei daaka! Ganɨmaangerɨnajɨ ganaangevɨnajɨ yawɨꞌmwo. ‘Sɨgunyavɨdaaꞌnyɨ walaabeinyɨ,’ gara nedɨwakelaka!” ");
INSERT INTO byr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jizaazai jaꞌnawɨdɨna “Jɨkurya yeva kɨnɨmyagaala dɨmanɨgasaꞌna mipɨnera! ");
INSERT INTO byr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nɨmwai nyɨdasaabakei nɨmɨnyawɨnna aane pwarɨ kwarɨ mamwagiꞌnya yajaꞌ sai nɨmɨrei yɨmaꞌnyaꞌnei mabyɨ yannelyɨ. Nɨmwai sahwarɨ mwagiꞌnyɨ yajarɨ Yɨrɨka Aayagaaꞌ tewaanna mwaaladeꞌna yɨdɨkaavɨdeinyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Gotɨyarɨ wɨꞌnawɨjɨwaakyara yɨdayaasangɨ dara dɨnɨkesɨ. Gotɨyai aꞌmwe yuyaraavɨ wɨjɨwaakadelyɨ. Sara dɨnɨkeꞌ gazaizai Nɨmwarɨ kadɨka wɨꞌnyɨna yojɨ gamɨre wɨjɨwaakyaꞌ maarɨna yada sahwai nɨmɨnyawɨnna bathelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Aꞌmwe pwai kwai Nɨmwarɨ mwanganyadei mɨꞌ. Gotɨyaryawɨdaasai dazahwai gaveina wanganaꞌ Nɨmwarɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Naanga nebulyaꞌna yɨhɨthɨvanɨge. Aꞌmwe nyɨlɨmwagarajai yuyagaaꞌ yuyagaaꞌne gaalyabwi kɨnɨnnakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sahwainyɨ gaalyabwine Wapaayainyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Aꞌmwamaayaba sarɨmɨre Ne sɨnnawɨnyara wapaaya manaayaꞌ nyaata kwara balɨna. ");
INSERT INTO byr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Balɨna yaasaꞌ Sɨgunyavɨdaaꞌnyɨ Wapaayai walaabɨna yakeꞌ daresɨ. Pwai kwai Wapaaya sarɨ maranajai mabalyɨ yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Wapaaya sai Sɨgunyavɨdaaꞌnyɨ walaabeneinyɨ sahwainyɨ. Aꞌmwe pwai kwai Wapaaya sainyɨ nyɨnajai yuyagaaꞌ yuyagaaꞌ tewaanya mwaaladelyɨ. Wapaaya nɨmɨ wɨjaavɨwɨjaꞌ nɨmɨre mɨwɨsajɨꞌna nabaai Kwaakevakɨ mwaalyaraavɨna mɨwɨta sajɨꞌ mubaꞌmujɨ Kwaakevakɨ mwaalyaraavɨ gaalyabwi wɨmaaridezɨkɨra.” ");
INSERT INTO byr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sara wɨdakevɨdaaꞌnyɨ Juyara maanga naanga dɨnyɨna yeva yɨwaaraꞌnyɨna “Aꞌmwe dai gannya mɨwɨsajɨꞌ nyaꞌneꞌ gara nejaavannelaka!” ");
INSERT INTO byr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Sarevɨdaaꞌnyɨ Jizaazai wɨdɨna “Naanga nebulyaꞌna yɨhɨthɨvanɨge. Aꞌmweraavɨne Kaimɨraayare mɨwɨsajɨsɨ gamɨre tawesɨ manyɨ yɨjaꞌ sahwaigɨnyɨ gaalyabwi kɨnɨnnakeigɨ mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aꞌmwei nɨmɨre mɨwɨsajɨꞌ nyɨna, nɨmɨre taweꞌ najai yuyagaaꞌ yuyagaaꞌne gaalyabwi kɨnɨnnakelyɨ. Yɨrɨka Aayagaaꞌ sai baryarɨ yɨdɨkaavɨdelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sareꞌ dareꞌnesɨ. Nɨmɨre mɨwɨsajɨꞌ wapaaya nebulyasɨ. Nɨmɨre taweꞌ aalya nyɨnyaꞌne nebulyasɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aꞌmwei nɨmɨre mɨwɨsajɨꞌ nyɨna, nɨmɨre taweꞌ najai nɨmɨnyɨ wɨlamwaaina nyadelyɨ. Sarɨ wɨlamwaaina yɨdelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nɨmwai yuyagaaꞌ gaala mwaaida mwaalɨkei nyɨdasaabakeinyɨ Nɨmware dɨragɨnyaꞌna mwaaihevaaibɨꞌ aꞌmwei nyɨnajai nɨmɨre dɨragɨnyaꞌna mwaaladelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Sɨgunyavɨdaaꞌnyɨ Wapaaya sai walaabakelyɨ. Ne sɨnnawɨnyara wapaaya manaayaꞌ neva balyaasaꞌ wapaaya sabaaibɨtaꞌ mɨka! Aꞌmwei Wapaaya sai najai yuyagaaꞌ yuyagaaꞌ gaala mwaaladelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Anga Kaapanɨyamɨ Juyaraavɨre lotuangevɨ wɨjɨwaakɨna yada yuya sa sara wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sarevɨdaaꞌnyɨ wɨdakeꞌ gamɨrera kwalaalyara kadɨka wɨꞌnyɨna yeva dɨnyɨna “Yagaala saꞌ taangesɨ. Aai wɨꞌnojɨ daapadevaka!” ");
INSERT INTO byr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jizaazai gannya sɨmunyavɨ dara yawɨrakeꞌ “Nɨmɨre mɨdɨdɨvɨsara savɨna kɨnɨmyagaala yɨvanɨgasara daaka!” Sara daka wɨdɨna “Yɨhɨthɨweꞌna sarɨmɨre sɨmunyaburɨ navɨka galayɨgala jɨhyɨwaka! Nɨmɨnyɨ dɨnyasɨꞌnyideihi daaka? ");
INSERT INTO byr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Sarevɨdaaꞌnyɨ sɨnnawɨ Aꞌmweraavɨne Kaimɨraayai mwaalakewɨnna ayɨna yɨlaawɨna kyojɨ sarɨmɨ wangabɨzaꞌ sagaaꞌ garevaka! ");
INSERT INTO byr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yuyagaaꞌne gaala sabwi Gotɨyare Kuryai yɨhɨzaavadelyɨ. Aꞌmweraavɨre mɨwɨsajɨkɨ dɨmaaryidevwina mɨꞌ. Yagaala sa nɨmɨnyɨna yɨhɨthɨvanɨge sa Gotɨyare Kuryaina yɨhɨthɨvanɨge. Yagaala sa gaalyabwinenna yɨhɨthɨvanɨge. ");
INSERT INTO byr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sare kɨrɨꞌ sarɨmɨ pwaihi manyɨlɨmwagyɨvanɨgasaihi mwaaihaꞌ.” Sareꞌ dareꞌnesɨ. Aayawɨdaasɨ Jizaazai malɨmwagyɨ yɨpɨjaraavɨna mena yawɨrakeꞌ nabaai sɨnnawɨ “Yɨnagaawai yɨkamaangeraavɨ nɨmɨnyɨna wibwarɨdaakwadei daaka!” mena yawɨrakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Sai wɨdaka wɨdɨna “Sarevɨ dara yɨhɨthɨwa. Nɨmwai aane pware kware sɨdusavɨ ‘Jizaazarɨ dɨmɨdɨna!’ yawɨta mwaki yajaꞌ nɨmɨnyawɨnna aꞌmwe sai mabi yannelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sarevɨ gamɨrera kwalaalyara gamɨnyɨ yagalyaꞌmaveva ayɨna wɨna. Yuyagaaꞌ gamɨjɨ ayɨna myamari yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sarevɨdaaꞌnyɨ Jizaazai gamɨrera sɨvɨlyɨraai ata purɨdaaꞌnyɨ pwaraalyaraavɨ wɨdɨna “Nabaai, sahwaihi dɨnyaꞌmayideihi daaka?” ");
INSERT INTO byr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saaimonɨ Pitai jaꞌnawɨdɨna “Naangeigɨ, aaryawɨnna wawaadeinaavaka! Aawa, yuyagaaꞌ yuyagaaꞌne gaalyabwine yagaalya kɨnɨnnakeigɨnyɨ. ");
INSERT INTO byr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Gɨlɨmwagaꞌmanɨgo. Gɨmɨnyɨna dara yawɨꞌmwo. Gotɨyare Tewaanaangeigɨnyɨ. Gɨrɨka maayaigɨnyɨ. Sara yawɨꞌmwo.” ");
INSERT INTO byr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jizaazai jaꞌnawɨdɨna “Sɨvɨlyɨraai ata purɨdaaꞌnyɨ pwaraalyaihɨrɨ dahɨlakeihi daaka! Yo, sareꞌ sarɨmɨnyɨdaaꞌnya pwai yɨmakelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Saaimonɨ Yɨzɨkerɨyotɨyarɨ gawaalɨꞌ Juthaazarɨna wɨdɨna yaꞌ. Sareꞌ dareꞌnesɨ. Jizaazarei aꞌmwe atɨraai sɨvɨla purɨdaaꞌnyɨ pwaraalyai Juthaazai kwalyɨ mwaaleva kɨrɨꞌ dɨvi maalɨkegaaꞌ yɨkamaangeraavɨna Jizaazarɨ wibwarɨdaakwadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Sare mena kyɨmaꞌnaꞌ Kwaaka Galɨli saba Jizaazai kaanya yamarina. Sareꞌ dareꞌnesɨ. Juya naangera dɨnyɨna “Jizaazarɨ tamakaana!” dɨnyɨna yesaꞌna gamɨre sɨmunyavɨ “Kwaaka Juthɨya kaanya myamari yɨdera.” ");
INSERT INTO byr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Sagaaꞌ Juyara “Aya kɨgaaꞌ Tɨka Munne Sɨmɨnangeꞌ munneꞌ naadesɨ,” desagaakɨ. ");
INSERT INTO byr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Sarevɨdaaꞌnyɨ gamɨre gyaꞌmwera gamɨnyɨna muꞌnyadɨvɨꞌ wɨdɨna “Nɨmɨ naangeinyɨ daakajɨ, dava yaꞌmavaꞌgɨri Kwaaka Juthɨya dɨwodera. ‘Naange yɨvanɨgenna nɨmɨrera tɨnna wangabɨka!’ daꞌgɨzɨ dɨwodera. ");
INSERT INTO byr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sareꞌ dareꞌnesɨ. Aane pwai kwai yawɨꞌna ‘Yuyara nyangabɨka!’ daka yɨnɨkeꞌ lɨka myulyarivanɨꞌ. Sara yɨja kwaaka yuyavakɨ kuꞌmaayaba sara jɨthera,” wɨdeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Sareꞌ dareꞌnesɨ. Pwara gamɨnyɨna “Naangelyɨ,” malɨmwagyesaꞌ nabaai, gyaꞌmwera malɨmwagyesare. ");
INSERT INTO byr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Sarevɨdaaꞌnyɨ Jizaazai wɨdɨna “Nyɨdɨwaasaꞌ nɨmɨnyɨne tewaanyagaaꞌ myɨmaꞌnyɨwaꞌ. Yuyagaaꞌ sarɨmɨnyɨne tewaanyagaaꞌ warɨꞌ. ");
INSERT INTO byr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kwaakevakɨ mwaalyara sarɨmɨnyɨna sɨnna tɨka mudayɨ yɨpɨneihɨlyɨ. Kɨrɨꞌ nɨmɨ ‘Sarɨmɨre yadɨvɨsabwi kayaaꞌnanaangebulyɨ,’ wɨjalɨkurakɨvanɨgeꞌna aꞌmweraavɨ nɨmɨnyɨna sɨnna tɨka davɨna yɨvanɨkere. ");
INSERT INTO byr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tɨka munneꞌ nɨpɨꞌdewɨ jɨlaawila! Dahaaꞌ Munne savɨ milaawɨwɨna! Nɨmɨre tewaanyagaaꞌ yuna myɨmaꞌnyɨwaꞌ.” ");
INSERT INTO byr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sara wɨdɨna yaka Kwaaka Galɨli pɨzɨꞌgwa mwaalɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Munnevɨ gyaꞌmwera mena wawesagaaꞌ Jizaazai mwaalɨna yaka savɨna kave wɨna. Aꞌmwe kwala naangerajɨ mwɨyɨ. Aawa. Dɨvi kɨmaꞌnyɨkaanyabɨꞌ kave wɨna. ");
INSERT INTO byr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sarevɨdaaꞌnyɨ Munnevɨ Juyara yaamɨjɨ bɨrɨna yeva yɨwaaraꞌnyɨna “Gava mwaalɨka?” ");
INSERT INTO byr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kwala bwaꞌnaanyavɨ aꞌmwera gamɨnyɨna aꞌmabyahaala dɨnyɨna dɨnyɨna. Pwara wɨdɨna “Aꞌmwe nawɨꞌnyalyɨ.” Pwara wɨdɨna “Sareꞌ mɨꞌ. Aawa, aꞌmweraavɨ kwaasɨ wɨdadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Aꞌmabyahaala dɨnyɨna yeveꞌ kɨrɨꞌ Juya naangeraavɨna lɨka yesaꞌna kuꞌmaayaba aane pwai kwai mujɨ yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Munnevɨ tɨnnyagaaꞌ Gotɨyare Angevɨ Jizaazai wɨlaawɨna yaka wɨjɨwaakɨna. ");
INSERT INTO byr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wɨjɨwaakɨna yadaaꞌnyɨ Juya naangera atɨka maruꞌnaꞌna yadɨvɨꞌ dɨnyɨna “Nemɨre sɨkulɨyangɨ myakeꞌ sɨduta naangeꞌ gara yawɨramaarakalaka?” ");
INSERT INTO byr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Sarevɨdaaꞌnyɨ Jizaazai jaꞌnawɨdɨna “Wɨjɨwaakadɨnyaꞌ nɨmɨre wɨjɨwaakyaꞌ mɨka! Aawa. Wɨjɨwaakya saꞌ Nyɨdasaabakeresɨ. ");
INSERT INTO byr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pwai kwai gannya sɨdusavɨ dɨna ‘Gotɨyai sara kanedozɨ sara nebwina yɨma!’ Dɨna yajaꞌ yawɨta kɨrɨꞌ dathelyɨ ‘Gotɨyai Jizaazarɨ wɨjɨwaakyaꞌ kujaavaꞌ Jizaazai sara nejɨwaakɨvanɨkelyɨ.’ Nabaai yawɨta pɨrɨꞌ dathelyɨ ‘Jizaazai gavei yawɨraka yaasɨwaꞌna nejɨwaakɨvanɨkelyɨ.’ Yɨ Gotɨyare sɨmunyavɨ mɨdɨnajai sɨdusavɨ dɨragɨnna dara yawɨꞌna yadeꞌ ‘Ai, Jizaazare nejɨwaakadeꞌ Gotɨyarɨdaaꞌnyaꞌ daaka!’ ");
INSERT INTO byr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aꞌmwei gannya sɨdusavɨdaaꞌnyɨ gannyabwi aꞌmweraavɨ wɨdada ‘Nɨmɨnyɨna aꞌmwera dɨnɨpɨka! “Aꞌmwe sai naangelyɨ,” sara dɨnɨpɨka!’ yawɨꞌdelyɨ. Sara yada kɨrɨꞌ pwai yawɨꞌna ‘Aꞌmwera nyɨdasaabakerɨna dɨnɨpɨka! “Gotɨyai naangelyɨ. Byaannakelyɨ,” ’ yawɨꞌna yada nebulyabwi dadelyɨ. Sai nadɨyabwi gamɨnyɨ mwariꞌ. ");
INSERT INTO byr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ne Mozɨzai Kɨwɨnyaꞌ yɨhɨzayaakei daaka! Yɨhɨzayaaka kɨrɨꞌ sarɨmɨjɨya aane pwai kwai Kɨwɨnyaꞌ dɨnɨkebwi myadelyɨ. Nɨmɨnyɨna dɨnyɨna ‘Sarɨ tamakaana!’ Saꞌna baaꞌna dɨmanɨgataihɨlaka?” ");
INSERT INTO byr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kwala bwaꞌnaanya saꞌ jaꞌnawɨdɨna “Yɨmakei gɨmwaalɨkeigɨ! Aai gɨramakajɨwaka!” ");
INSERT INTO byr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jizaazai jaꞌnawɨdɨna “Kwazaakegaaꞌ dɨragɨnya pɨrɨꞌ kye yuyaihi atɨka maruꞌnaꞌna yesaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ne Mozɨzai dɨnɨꞌ ‘Sawɨta ati ata purɨdaaꞌnyɨ pɨrɨwaalyɨ kajɨnnojɨ gɨnnya kaimɨraayare kɨlaakejɨꞌ dɨthako!’ Dɨnɨkeꞌna pɨgaaꞌ Kwazaakegaaꞌ kaimalerɨ davesaihɨlyɨ. Sara yadɨvɨꞌ ‘Tewaanyasɨ,’ dadɨvɨkɨ. Sabwi sɨnnawɨ Mozɨzai yakebwi mɨꞌ. Aawa. Sɨnnawɨ kɨgaaꞌ waryaakebulyɨ. ");
INSERT INTO byr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Sarɨmɨ dɨnyɨna ‘Kɨlaaka dayaꞌna Mozɨzare Kɨwɨnya kayaaka nyɨgalaadɨka! Kwazaakegaaꞌna yawɨta myaanna! Kwazaakegaaꞌ kaimalerɨ kɨlaakejɨꞌ davaadeinera.’ Sara dɨnyɨna yadɨvɨꞌ Kwazaakegaaꞌ nabalɨnakerɨ maamɨdarya yɨnahu yɨdɨkaaveinyɨna sɨnna tɨka beꞌna yɨhɨthaꞌmwaka! ");
INSERT INTO byr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sareꞌna sarɨmɨ mwasɨmagɨnyaꞌ tɨnna wanganna yadɨvɨꞌ mipɨna! Aawa. Yawɨbwata yɨdaꞌmaraangebwi nayaa jɨla!” ");
INSERT INTO byr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sarevɨdaaꞌnyɨ Anga Jeruzaalemɨ mwaalya pwara dɨnyɨna “Sarɨna ‘Tamakaana!’ dɨmanɨgasai daaka! ");
INSERT INTO byr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yɨthaa, kuꞌmaayaba aꞌmweraayaba wɨdɨvanɨkelyɨ. Maiyagaala aane pɨrɨꞌ kɨrɨꞌ yuyara mujɨvanɨgaꞌ. Nɨwaava, aꞌmwe naangera mena dɨnyɨna ‘Sai Kɨraazɨtɨyalyɨ. Gotɨyai dahɨlakyaakelyɨ,’ nayaa dɨnyɨna yɨvanɨgasara midɨngaka! ");
INSERT INTO byr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Sareꞌna kɨrɨꞌ Kɨraazɨtɨyai kabozɨ aane pwai kwai gamɨnyɨna dɨnyɨna ‘Gawɨdaasɨ bɨwakalaka! Aawa, myawɨryadaanyaine.’ Aꞌmwe dai bakewɨnna yuyaina yawɨꞌmwo.” ");
INSERT INTO byr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Sarevɨdaaꞌnyɨ Gotɨyare Angevɨ Jizaazai wɨjɨwaakakegaaꞌ sagaaꞌ naangaveꞌna wɨdɨna “Nɨmɨnyɨna tɨvɨ yawɨꞌmwaasainyɨ daaka! Nɨmɨ bahewɨnna jawɨꞌmanɨgava! Nɨmɨ sainyɨ sɨdusaꞌ yawɨrena mabye. Aawa. Nebulyai nyɨdasaabakei sahwarɨ myawɨranganyadɨvɨsalyɨ. ");
INSERT INTO byr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kɨrɨꞌ sai kanyɨdasaabaꞌ gamɨnyawɨdaaꞌnyɨ baheꞌna sarɨ yawɨꞌmanɨge.” ");
INSERT INTO byr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sarevɨdaaꞌnyɨ aꞌmwe naangera dɨna “Jizaazarɨ wɨla pwɨyawaajɨ kalavuzavɨ wakaana!” dɨna yeva yaamɨjɨ yɨna yɨna yeva Jizaazare balyaꞌnegaaꞌ kuna mimaꞌnyɨ yakeꞌna aane pwai kwai magalalɨmwagi yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kwala bwaꞌnaanyavɨ aꞌmwe kwalaalyara gamɨnyɨ lɨmwanna yeva dɨnyɨna “Kɨraazɨtɨya kwai bozɨ dahware yɨjɨwaainya yɨvanɨke wavɨlaꞌna yadei daaka! Aawa.” ");
INSERT INTO byr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kwala bwaꞌnaanyaꞌ sangɨ Jizaazarɨna aꞌmabyahaala dɨdaapi Aꞌmwe Perɨzɨyara kadɨka wɨꞌnyɨna yeva “Sahwarɨ wɨla yɨpɨka!” deva sahwarajɨ Gotɨyarɨne tamiraꞌdɨvɨta naangerajɨ sara Gotɨyare Angevɨ dameraavɨ wɨdaasɨna. ");
INSERT INTO byr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sarevɨdaaꞌnyɨ Jizaazai kwala bwaꞌnaanyaꞌ wɨdɨna “Pɨzɨꞌgwa sarɨmɨnyaba mwaalaꞌmujɨ dɨvi nyɨdasaabakeryawɨnna kaanya wɨdeinyɨ. ");
INSERT INTO byr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nɨmɨnyɨna ‘Tɨnna wanganaana!’ dɨzideꞌ kɨrɨꞌ mabɨramaari dɨnyideihɨlyɨ. Sagaaꞌ mwaaimujawɨnna mwɨyɨ jideihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Sarevɨdaaꞌnyɨ Juyara naangera dɨnyɨna “Mabɨramaari yaanneꞌna gawɨnnelaka? Aꞌmwe Gɨrikɨyaraavɨre angengɨ Juyara mwaaidɨvɨsangɨna wawojɨ Gɨrikɨyaraavɨ wɨjɨwaakadei daaka? ");
INSERT INTO byr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nedɨwaꞌ ‘Nɨmɨnyɨna “Tɨnna wanganaana!” dɨzideꞌ kɨrɨꞌ mabɨranyɨmaari dɨnyidera. Mwaaimujawɨnna mwɨyɨ jideihɨlyɨ.’ Sara nedɨwakeꞌ be yagaala nedɨwaka?” ");
INSERT INTO byr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Munnevɨ aayagaaꞌ sagaaꞌ naangegaakɨ. Sagaaꞌ Jizaazai daavɨna yaka naangaveꞌna wɨdɨna “Pwai kwai aalyaꞌna mɨjɨka wiajai nɨmɨnyawɨnna bozɨ nadelyɨra. ");
INSERT INTO byr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Gotɨyare bukuyaꞌ nɨmɨnyɨna dɨnɨkabaaibɨꞌ ‘Pwai lɨmwanna nyada gamɨre munyavɨdaaꞌnyɨ aalya gaalyaꞌne walaawɨna yadengɨra.’ ” ");
INSERT INTO byr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jizaazai nabaai Gotɨyare Kuryarɨna wɨdɨna. Aꞌmwera Jizaazarɨ lɨmwanna yadɨvɨꞌ maalɨkegaaꞌ kumɨre munyangɨ Kuryai maapɨꞌdelyɨ. Sareꞌ dareꞌnesɨ. Sagaaꞌ Jizaazai mabalyɨ yaka madɨkaayɨ yaka Nawɨꞌnyaba byaannakei kuna myɨmaꞌnyakeꞌna Kuryaregaaꞌ mɨꞌ. Dɨvi Jizaazai yɨlaawɨna kyaꞌ Kuryarɨ wɨjaayagaaꞌ yɨmaꞌnakegaakɨra. ");
INSERT INTO byr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kwala bwaꞌnaanyavɨ aꞌmwe pwara yagaala sa kadɨka wɨꞌnyɨna yeva wɨdɨna “Nebulyasɨ. Gotɨyarɨ wɨꞌnawɨjɨwaakadei pɨropetɨya kwarɨna yemwaaimanɨgolyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pwara wɨdɨna “Sai Gotɨyai dahɨlakyaakei Kɨraazɨtɨyalyɨ.” Wɨdɨna yesaꞌ kɨrɨꞌ pwara wɨdɨna “Nɨwaava, Kɨraazɨtɨyai Galɨlidaaꞌnyai daaka! ");
INSERT INTO byr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Gotɨyare bukuyaꞌ dɨnɨꞌ ‘Kɨraazɨtɨyai Ne Devitɨmɨre yɨsavaakɨdaaꞌnyalyɨ. Nabaai, Devitɨ mwalyaakeba anga Betɨlemɨ saba Kɨraazɨtɨyarɨ ganaangeꞌ maaradelyɨ.’ Sara dɨnɨkeꞌ daaka!” ");
INSERT INTO byr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Sarevɨdaaꞌnyɨ kwala bwaꞌnaanyavɨ jaapalyaꞌ yɨmaꞌnyɨna. Pwara Jizaazarɨna yɨlaaya yadaapi pwara yɨlaaya mi. ");
INSERT INTO byr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Pwara yawɨꞌna “Kalavuzangevɨ wɨmwaihaana!” yawɨꞌna yeveꞌ kɨrɨꞌ aane pwai kwai ata magalalɨmwagi yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sarevɨdaaꞌnyɨ Gotɨyarɨna mubɨthɨka yɨraꞌdɨvɨta naangerajɨ Aꞌmwe Perɨzɨyarajɨ wɨdaaseta saraayawɨnna damera ayɨna wɨna kyeꞌ sahwara yɨwaaraꞌna “Gamɨnyɨ mamakabyɨ beꞌna yɨwaava?” ");
INSERT INTO byr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Damera jaꞌnawɨdɨna “Pwara manejesare dahaaꞌ aꞌmwe nedɨvanɨkabaaibɨꞌ.” ");
INSERT INTO byr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sarevɨdaaꞌnyɨ Perɨzɨyara jaꞌnawɨdɨna “Gamɨre kwaasɨ yagaalyaꞌna ‘Nebulyasɨ,’ dathɨwaaꞌ! ");
INSERT INTO byr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Aꞌmwe naangerajɨ Perɨzɨyainajɨ sainaavɨdaasai pwai kwai gamɨnyɨ lɨmwamanɨkei daaka! ");
INSERT INTO byr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aawa. Kwala bwaꞌnaanya daꞌ Ne Mozɨzare Kɨwɨnyaꞌ myawɨryeva gamɨnyɨ yaasɨwaꞌna lɨmwamanɨgasaꞌna Gotɨyai Dɨkevɨ sahwaraavɨ marasɨꞌnaderera.” ");
INSERT INTO byr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikothimaazai kumɨjɨyai mwaalɨna. Sɨnnawɨ Jizaazaryawɨ sai angyɨrɨꞌmaata yakelyɨ. Sai mwaalɨna yada ");
INSERT INTO byr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","wɨdɨna “Nabaai, ‘Yaasɨwaꞌna kotɨyaꞌ ja!’ madɨnyɨka nemɨre kɨwɨnyaꞌ. Dara dɨnɨꞌ ‘Aꞌmwere yagaalya nayaa wɨꞌnyɨna yaꞌgɨzɨ gamɨrebwina nayaa yawɨraꞌgɨzɨ dɨvi sagaaꞌ kotɨyaꞌna “Kayaaꞌnanyaigɨ,” dɨzɨdaꞌdeigɨnyɨ,’ ” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kumɨ jaꞌnawɨdɨna “Nabaai, Galɨlidaasaigɨ daaka! Gotɨyarɨna yɨdaꞌnɨkengɨ nayaa wanganaꞌgɨzɨ dara jawɨꞌdeꞌ ‘Pɨropetɨya pwara Galɨlidaaꞌnyara yɨmaꞌnɨpɨꞌdera daa!’ ” ");
INSERT INTO byr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Sagaaꞌ wɨna. Gazaizai gannya angebannelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kunnya angengɨna wɨna kyeꞌ Mugunya Wolivna Jizaazai yɨlaawɨna. ");
INSERT INTO byr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yɨlaawɨna yaka yuna mwanyavɨ yɨrɨkeꞌ purakegaaꞌ Gotɨyare Angevɨna ayɨna wɨna. Ayɨna wɨna kyaꞌ gamɨnyawɨnna aꞌmwe yuyara yɨꞌbwaꞌna yɨna kyeꞌ Jizaazai walamwaaina yɨna yaka wɨjɨwaakɨna. ");
INSERT INTO byr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wɨjɨwaakɨna yadaaꞌnyɨ Juyaraavɨre Kɨwɨjarari Perɨzɨyarari sara aꞌmwevɨ makulaabɨna. Aꞌmwe saꞌ pwarɨ ata lɨmwadaaꞌnyɨ galalɨmwanna yesasɨ. Aꞌmwevɨ makulaabɨna yeva aꞌmwe yuyaraayaba tɨnnyaba wɨmwaaihɨna. ");
INSERT INTO byr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Miꞌna wɨmwaaihɨna yeva Jizaazarɨ wɨdɨna “Wɨjɨwaakyaigɨ, aꞌmwe daꞌ ata lɨmwagyawaalɨkevɨ pwara galalɨmwagyawaaihaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nemɨre Kɨwɨnyavɨ Ne Mozɨzai dakɨnɨkeꞌ ‘Aꞌmweꞌ ata lɨmwagazaꞌ tamakyaꞌna sɨlyajɨ dɨlɨwakyidesɨ.’ Sarevɨdaaꞌnyɨ gɨmɨ gara dadɨnyaigɨnaka?” ");
INSERT INTO byr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kumɨ yawɨꞌna “Jizaazarɨ yaamɨjɨ yɨjɨwalaana! ‘Sai kayaaꞌna wɨdɨna kyojɨ kotɨyaꞌ jɨna yaana!’ dara wɨdaana!” yawɨꞌna yeva wɨdɨna. Wɨdɨna kyeꞌ kɨrɨꞌ Jizaazai walarutaꞌnyɨna yaka kwaakevɨ gannya asɨlyɨ pɨkarya yɨdaꞌna. ");
INSERT INTO byr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pɨkarya yɨdaꞌna yadaaꞌnyɨ kumɨ kwara daavɨna yeva kuna yɨwaaraꞌna kyeꞌ sai daavɨna yaka wɨdɨna “Sarɨmɨjɨyai pwai dɨna ‘Kayaaꞌnanyasɨ,’ dɨna yojɨ yuyagaaꞌna kayaaꞌnanya myade sai sahwaidaaꞌnyɨ sɨlyaꞌ lɨwakadelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wɨdɨna yaka ayɨna walarutaꞌnyɨna yaka kwaakevɨ pɨkarya yɨdaꞌna. ");
INSERT INTO byr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pɨkarya yɨdaꞌna yadaaꞌnyɨ wɨdakevɨ kadɨka wɨꞌnyɨna yeva kunnya kayaaꞌnanya yawɨreva yuyara yaꞌmaꞌna. Pwai wɨna, pwai wɨna, sara yaꞌmaꞌna. Sɨnnawɨ aꞌmwe naangera wɨna, dɨvi aꞌmwera wɨna, dɨvi mɨgɨnyara wɨna. Yuyara yaꞌmaꞌna kyeꞌ Jizaazai gavei mwaalɨna. Aꞌmweꞌ tɨnnyaba daavɨna yadɨꞌnyɨyasɨ Jizaazai gavei mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Gavei mwaalɨna yaka daavɨna yaka aꞌmwevɨ wɨdɨna “Aꞌmweꞌgɨ, gawɨ mwaaihaꞌ! Yuyara ‘Aꞌmwe kayaaꞌnanyasɨra,’ gɨzɨdaveva sɨla magɨlɨwakiwaatara daa!” ");
INSERT INTO byr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Aꞌmweꞌ wɨdɨna “Naangeigɨ, aawa, aane pwai kwai mɨka!” Jizaazai wɨdɨna “Nabaai, sara yɨwaasaꞌ nɨmɨjɨ sara magɨzɨdaꞌmuna! Wawaꞌgɨzɨ kɨrɨꞌ dahaaꞌdaasɨ kayaaꞌnanyabwi ayɨna minna!” ");
INSERT INTO byr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Sarevɨdaaꞌnyɨ Gotɨyare Angevɨ kwala bwaꞌnaanyaꞌ mwaaidapiyaraavɨ Jizaazai ayɨna wɨdɨna “Kwaakevakɨ mwaalyaraavɨre Baakeinyɨ. Pwai nyɨmɨdɨnaabozɨ jɨhɨnyavɨ kaanya myamari yadelyɨ. Arɨkewɨ. Aawa. Sahwai Gaalyaꞌne Baakei kɨnɨnnakei mwaaladelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sarevɨdaaꞌnyɨ aꞌmwe Perɨzɨyara wɨdɨna “Gɨmɨ sahwaigɨnyɨna nejalɨkurakɨwaanyaꞌ yaasɨwaꞌna nedɨwaa. Sabwi gaveigɨ dadɨnyaigɨre jalɨkurakyaꞌ nebulaꞌ mɨꞌ.” ");
INSERT INTO byr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jizaazai jaꞌnawɨdɨna “Aawa, nɨmɨnyɨna yɨhɨzalɨkurakɨwɨjaꞌ kɨrɨꞌ nɨmɨre yɨhɨthadɨnyaꞌ nebulyasɨ. Kaanya bahevɨdaaꞌnyaꞌ yawɨꞌmweꞌ kaanya wɨdewɨnnyaꞌ yawɨꞌmweꞌna nebulyasɨ nɨmɨre yagaalyaꞌ. Kaanya bevɨdaaꞌnyaꞌ sarɨmɨ myawɨriwaasaꞌ kaanya wɨdewɨnnyaꞌ myawɨriwaasaꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Sarɨmɨ aꞌmweraavɨrebwi kɨlaakejɨsɨyabwi yawɨꞌdɨvɨꞌ yawɨbwaꞌdɨvɨsaihɨlyɨ. Dahaaꞌ aane pwarɨ kwarɨ kotɨyaꞌ myawɨbwarivanɨge. ");
INSERT INTO byr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kɨrɨꞌ yawɨbwaꞌmujaꞌ nɨmɨre yawɨbwata saꞌ nebulyasɨ. Gaveinyɨ mɨka. Aawa. Nɨmɨjɨ nyɨdasaabakelyɨ sainaai wɨdakadeꞌna nebulyaꞌ wɨdadɨnyainyɨ nɨmɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nabaai sarɨmɨre Kɨwɨnyaꞌ dara dɨnɨkesɨ. Aꞌmweraare jalɨkurakyaꞌ nebulyasɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Sara dɨnɨkeꞌna nɨmɨnyɨna yɨhɨzalɨkurakɨvanɨgeꞌ, nabaai, nyɨdasaabakei Nɨmwai nɨmɨnyɨna nayaa yɨhɨzalɨkurakɨvanɨkelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sarevɨdaaꞌnyɨ kumɨ yɨwaaraꞌna “Gɨmaamaangei gawɨ mwaalɨka?” Wɨdɨna kyeꞌ Jizaazai jaꞌnawɨdɨna “Sarɨmɨ nɨmɨnyɨ myawɨriwaaꞌ. Nɨmaamaangerɨ myawɨriwaaꞌ. Nɨmɨnyɨna yawɨpɨjaꞌ Nɨmwarɨna kyawɨpɨdɨka!” ");
INSERT INTO byr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Gotɨyare Angevɨ kuꞌdɨka Gotɨyarɨna nɨgwɨbukusa waꞌdɨꞌnyɨyaba Jizaazai wɨjɨwaakada yagaala yuya sa wɨdɨna. Sara wɨdakerɨ aane pwai kwai kalavuzaꞌna magalalɨmwagi. Gamɨregaaꞌ balyaꞌnegaaꞌ mimaꞌnyɨ yakeꞌna magalalɨmwagi yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Sarevɨdaaꞌnyɨ Jizaazai ayɨna wɨdɨna “Kaanna kwawaꞌmuri sarɨmɨ yaasɨwaꞌna bɨrɨna nyapɨjɨ kɨrɨꞌ sarɨmɨre kayaaꞌnanyaburɨ dɨvalyideihɨlyɨ. Nɨmɨ wɨwɨjawɨnna sarɨmɨ mabyɨ yɨpɨneihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Sarevɨdaaꞌnyɨ Juyara naangera dɨnyɨna “Nemɨnyɨ ‘Nɨmɨ wɨwɨjawɨnna sarɨmɨ mabyɨ yɨpɨneihɨlyɨ,’ wɨdɨna neyɨwakeꞌna gamɨnyɨ tamakɨnadei daaka? Gara nedɨwaka?” ");
INSERT INTO byr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Sara dɨnyɨna kyeꞌ sai wɨdɨna “Sarɨmɨ dava kwaakewɨnyangɨdaaꞌnyaihɨlyɨ. Nɨmɨ Munyabadaaꞌnyainyɨ. Kwaaka davakɨdaaꞌnyaihɨlyɨ. Kwaaka davakɨdaaꞌnyainyɨ mɨꞌ. ");
INSERT INTO byr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Sarevɨdaaꞌnyɨ dara yɨhɨthɨwe. Sarɨmɨre kayaaꞌnanyangɨ dɨvalyideihɨlyɨ. Sareꞌ dareꞌnesɨ. ‘Mwaaiheinyɨ nɨmɨnyɨra,’ yɨhɨthɨvanɨgeꞌ malɨmwagyɨ yɨpɨjaihi sarɨmɨre kayaaꞌnanyangɨ dɨvalyideihɨlyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sarevɨdaaꞌnyɨ kumɨ wɨdɨna “Bewaigɨnaka?” Sara wɨdɨna kyeꞌ Jizaazai wɨdɨna “Aayawɨdaaꞌnyɨ yɨhɨthadɨnyainyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yagaala kwalaalya yɨhɨthɨwɨjaihɨlyɨ. Yadɨvɨta kwalaalyangɨna yɨhɨthɨwɨjainyɨ. Sarengɨna yɨhyawɨbwaꞌmujainyɨ. Sareꞌ kɨrɨꞌ nyɨdasaabakei nebulyalyɨ. Nyɨdɨwake yagaala sa kadɨka wɨꞌnadɨ kwaakevakɨ mwaalyaraavɨ wɨdadɨnyainyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ganɨmaangerɨna wɨdakeꞌ sɨdusa myawɨrina. ");
INSERT INTO byr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sarevɨdaaꞌnyɨ Jizaazai wɨdɨna “Aꞌmweraavɨne Kaimɨraayarɨ makilarɨmwapɨjɨ dara jawɨryideꞌ ‘O, Jizaazai nedaꞌ “Mwaaiheinyɨ nɨmɨnyɨra,” nedakeꞌ nebulyaꞌ daaka!’ Nabaai ‘O, gamɨnyɨ sɨmunyavɨ aane pɨrɨꞌ kɨrɨꞌ mijɨvanɨka!’ Aawa. Nɨmwai sara nyɨjɨwaakɨwakabaaibɨꞌ nayaa sare yɨhɨthɨvanɨge. ");
INSERT INTO byr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nyɨdasaabakei nɨmɨjɨ mwaaidelyɨ. Nyɨdasaabakei yɨlaaya yade yuyagaaꞌ sara yadɨnyaꞌna nɨmɨ gaveinyɨ manyaꞌmayɨwakelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yagaala sa Jizaazai wɨdake aꞌmwe kwalaalyara kadɨka wɨꞌnyɨna yeva gamɨnyɨ lɨmwanna yesalyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sarevɨdaaꞌnyɨ Juyara Jizaazarɨ lɨmwanna yesaraavɨ Jizaazai wɨdɨna “Nɨmɨre yagaalyavɨ sara mwaaibɨzaihi nɨmɨreihi nebulyaihi dɨmwaalyideihɨlyɨ. Sara yapɨjɨ nayaa dɨnyɨmɨdɨnyideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nɨmɨre nebulyabwi yɨpɨjaihi nebulyabwina sarɨmɨre yaasɨwaꞌwawɨnya yɨhɨmarasɨꞌnadengɨra.” ");
INSERT INTO byr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kumɨ wɨdɨna “Ne Evɨraamɨmɨre yɨsɨlyaina. Gamɨre kaimɨraayainera. Yuyagaaꞌ yaasɨwaꞌwawɨnya myadaa mwaaihoinera. ‘Sarɨmɨre yaasɨwaꞌwawɨnyaꞌ yɨhɨmarasɨꞌnadengɨra,’ nedɨwaanya be yagaalavaka?” ");
INSERT INTO byr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jizaazai jaꞌnawɨdɨna “Naanga nebulyaꞌna yɨhɨthɨvanɨge. Gazaizai kayaaꞌnanyabwi yada kayaaꞌnanyabwineꞌna yaasɨwaꞌwawɨnyalyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Yaasɨwaꞌwawɨnya kwai yuyagaaꞌ yuyagaaꞌ angevɨ mamwaalyadelyɨ. Gawaalɨꞌ yuyagaaꞌ yuyagaaꞌ angevɨ mwaaidelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Sarevɨdaaꞌnyɨ Gotɨyarɨ Gawaalɨꞌ sarɨnnya yaasɨwaꞌwawɨnya kyɨhipalasɨꞌnojɨ dɨragɨnyaihi nebwina dɨmwaalyideihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Sarɨnnya kɨlaakejɨkana ‘Evɨraamɨmɨre yɨsɨlyaihɨlyɨ,’ yawɨꞌmwa. Saꞌna kɨrɨꞌ nɨmɨnyɨna dɨna ‘Nemɨre sɨdusangɨ gamɨre yagaalyaꞌ mulannera!’ dɨna yadɨvɨsaꞌna ‘Sarɨ tamakaana!’ dɨnyɨna yɨvanɨgasaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nɨmwaryaba yawɨrangane sara yɨhɨthɨvanɨge. Sarevɨdaaꞌnyɨ sɨrɨnɨmaangerɨ wɨꞌneva sara yɨvanɨgasaihɨlyɨra.” ");
INSERT INTO byr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kumɨ jaꞌnawɨdɨna “Aawa, Ne Evɨraamɨ nenɨmaangelyɨ. Sahwalyɨ.” Wɨdɨna kyeꞌ Jizaazai wɨdɨna “Evɨraamɨmɨreihi mwaaibɨzɨ kwajɨ Evɨraamɨ yaake avaalyabwi kyɨpɨdɨka! ");
INSERT INTO byr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yuyagaaꞌ Gotɨyarɨ kadɨka wɨꞌnena nebulyaꞌ sara yɨhɨthadɨnyainyɨ. Sara yadɨ kɨrɨꞌ nɨmɨnyɨna dɨnyɨna ‘Sarɨ tamakaana!’ Sabwi Evɨraamɨ myɨna. ");
INSERT INTO byr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Sɨrɨnɨmaangei yadevwi yɨvanɨgasaihɨlyɨ.” Sara wɨdɨna kyaꞌ kumɨ yarai wɨdɨna “Aꞌmwe yaasɨwaꞌ maryawakɨdɨvɨꞌ nemwaaihɨnɨkeina mɨꞌ. Nenɨmaanga gavei kɨnɨnnakeine Gotɨyai.” ");
INSERT INTO byr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jizaazai wɨdɨna “Gotɨyai sɨrɨnɨmaangei nebwina mwaalajɨ kwajɨ nɨmɨnyɨna kyɨhɨvuꞌnadɨka! Sareꞌ dareꞌnesɨ. Gotɨyarɨdaaꞌnyainyɨ walaabɨna yena dava mwaaihe. Sareꞌ dareꞌnesɨ. Sɨmunya nɨmɨrevɨdaaꞌnyɨ bɨna yeinyɨna mɨꞌ. Aawa. Gotɨyai sahwai nɨdasaabakeinyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yagaalyaꞌ yɨhɨthɨvanɨgeꞌ myawɨramaari baaꞌna yɨvanɨgaꞌ? Nɨmɨre yagaalyaꞌna sarɨmɨ muꞌnyɨ yɨpɨneihɨlyɨ. Sarɨmɨ dɨnyɨna ‘Kadɨka muꞌnaannera!’ ");
INSERT INTO byr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sɨrɨnɨmaangei Kotɨyaꞌ Jadereihɨlyɨ. Sɨrɨnɨmaangere yawɨsajɨ gamɨrebulyɨ sangɨna dɨnyɨna ‘Sabwi yaana! Nevuꞌnɨvanɨkebulyɨ.’ Sahwai sɨnnawɨdaaꞌnyɨ aꞌmweraavɨ tamakadelyɨ. Gamɨre sɨdusavɨ nebulyaꞌ maaya kunesɨ. Sareꞌna yuyagaaꞌ nebulyaburɨ madaayadelyɨ. Sareꞌna yuyagaaꞌ nebulyaꞌna sɨnna tɨka wɨdaꞌdelyɨ. Kwaasɨ yagaalyaꞌ dadei gamɨ sahwarebwi yadelyɨ. Kwaasɨ yagaalyaburɨ gyakwalaangelyɨ. Sareꞌna kwaasɨ yagaalyaꞌ dada gannyangɨ dadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nebulyaꞌ yɨhɨthadɨnyaꞌna manyɨlɨmwagyadɨvɨta gamɨreihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nɨmɨnyɨna nebwina aai wɨdɨwaka ‘Kayaaꞌnanyabulyɨyalyɨ!’ Aawa. Nebulyaꞌ yɨhɨthadɨ malɨmwagyɨ baaꞌna nyadɨvɨtaihɨlaka? ");
INSERT INTO byr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Gotɨyarɨdaaꞌnyai Gotɨyare yagaalya kadɨka wɨꞌnadelyɨ. Sarevɨ sarɨmɨ Gotɨyarɨdaaꞌnyaihi Gotɨyareihi mamwaalyɨgasaꞌna yagaala sa muꞌnyɨvanɨgasaihɨlyɨra.” ");
INSERT INTO byr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juyara Jizaazarɨ jaꞌnawɨdɨna “Gɨmɨnyɨna ‘Sai kayaaꞌnanyai Kwaaka Samerɨya mwaalyalyɨ. Yɨmakei kɨnɨnnakelyɨ,’ nebwina sara dɨnoina daaka!” ");
INSERT INTO byr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jizaazai jaꞌnawɨdɨna “Yɨmakei maayainyɨ. Aawa. Nɨmaamaangerɨne yayaꞌ munyaba makidɨnyainyɨ. Sara makidɨnya kɨrɨꞌ nɨmɨnyɨne yayaꞌ marulawakadɨvɨsaihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","‘Nɨmɨ aꞌmwe naangeinyɨ, byaannakeinyɨ,’ majadɨ mabɨrivanɨge aꞌmweraavɨna. Aawa. Pwai nɨmɨnyɨna ‘Aꞌmwe naangei byaannakelyɨ,’ dada nɨmɨnyɨna ‘Nebwina dadelyɨ,’ jawɨbwaꞌdelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Naanga nebulyaꞌna yɨhɨthɨvanɨge. Pwai kwai nɨmɨre yagaalyaꞌ mɨdɨnajai yuyagaaꞌ yuyagaaꞌ balyabwi mwanganyɨ yadelyɨ. Arɨkawɨ.” ");
INSERT INTO byr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juyara wɨdɨna “Sareꞌna gɨmɨnyɨna ‘Sarei yɨmakei kɨnɨnnakelyɨ,’ dɨragɨnna yawɨꞌmwo. Ne Evɨraamɨ balɨna yaaꞌ. Gotɨyarɨ wɨꞌnawɨjɨwaakyara pɨropetɨyara balɨna yaaꞌ. Sareꞌ kɨrɨꞌ nedɨwaa ‘Pwai kwai nɨmɨre yagaalyaꞌ mɨdɨnajai yuyagaaꞌ yuyagaaꞌ balyabwi myagaanganyɨ yadelyɨ. Arɨkawɨ.’ ");
INSERT INTO byr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Neyakwalaanga Evɨraamɨ balyaakerɨna, ‘Evɨraamɨ maalɨkelyɨ. Nɨmɨ naangeinyɨ,’ sara danedɨwaa! Nabaai, pɨropetɨyara balɨna yaasaꞌ gɨmɨ sahwaigɨnyɨna yawɨꞌdɨnyaigɨ bewaigɨnaka!” ");
INSERT INTO byr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jizaazai jaꞌnawɨdɨna “Nɨmɨ gaveinyɨ wɨdɨna ‘Aꞌmwe naangeinyɨ, byaannakeinyɨ,’ sara wɨdɨna yɨwɨjaꞌ nɨnnya byaannyaꞌ yaasɨwaꞌna yɨmaꞌnadesɨ. Saꞌ kunesɨ. Nɨmɨnyɨna ‘Sai byaannakelyɨ,’ wɨdɨna yade Nɨmaamaangelyɨ. Nɨmwai sahwarɨna sarɨmɨ dɨnyɨna ‘Nemɨre Gotɨyalyɨ,’ dɨnyɨna yadɨvɨta sahwalyɨ. Sareꞌna nɨmɨnyɨna avaaina kadɨpɨdɨkeihɨlyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yuyagaaꞌ gamɨnyɨ myawɨramaarivanɨgasaꞌ kɨrɨꞌ gamɨnyɨ yawɨramaaꞌmanɨge. ‘Sarɨ myawɨrivanɨge,’ yɨhɨthɨwɨjɨ kwajɨ kwaasɨ dadɨnyainyɨ sarɨmɨbɨsainyɨ kyɨmaꞌnɨwɨdɨka! Sareꞌna gamɨnyɨna yawɨꞌmanɨgeꞌ gamɨre yagaalyaꞌ sara mɨdɨdɨnyainyɨ. ");
INSERT INTO byr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Sɨrɨnɨmaanga Evɨraamɨ nɨmɨnyɨna dɨna ‘ “Gotɨyai dahɨlakakeregaaꞌ wanganɨma!” daꞌmujɨ yɨlaaya yɨwɨjainyɨ.’ Dɨna yaka sareꞌ tɨnna wanganaka yɨlaaya yɨna yaaꞌ.” ");
INSERT INTO byr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Sarevɨdaaꞌnyɨ Juyara wɨdɨna “Neigɨ daaka! Kwarame pwaraare sɨvɨlatɨraai pware atɨraalya gwavɨlavakeigɨ daaka! Ne sɨnnawɨnya Evɨraamɨmɨ tɨnna danganye!” ");
INSERT INTO byr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jizaazai wɨdɨna “Naanga nebulyaꞌna yɨhɨthɨvanɨge. Sɨnnawɨ Ne Evɨraamɨ mimaꞌnyagaaꞌdaaꞌnyɨ sahwainyɨ nɨmɨnyɨra.” ");
INSERT INTO byr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Sarevɨdaaꞌnyɨ kumɨ “Sɨla lɨwakaana!” deva lɨvɨna kyeꞌ kɨrɨꞌ Jizaazai yulyaꞌna yaka Gotɨyare Angevɨna yaꞌmaꞌna yɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jizaazai kaanya yamaryada aꞌmwe pwarɨ tɨnna wangamabɨna. Aꞌmwe sarɨ mudangegaaꞌdaaꞌnyɨ tɨbɨnyai mwaalaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tɨnna wangamabɨna kyaꞌ gamɨrera yɨwaaraꞌna “Nejɨwaakadɨnyaigɨ, tɨbɨnyarɨna kayaaꞌnanyabwi aai yakeꞌna yɨmaꞌnakalaka mudangegaaꞌ? Sahwai kayaaꞌnanyabwi yakei dɨngaka? Gamɨnyɨ ganɨmaangeyoi kayaaꞌnanyabwi yagɨlyayoi dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jizaazai jaꞌnawɨdɨna “Tɨbɨnyai mwaalɨkeꞌna gamɨre kayaaꞌnanyajɨ ganɨmaangeyore kayaaꞌnanyajɨ sangɨna mɨka. Aawa. Tɨbɨnyai mwaalɨkeꞌna Gotɨyai ‘Gamɨnyɨna nɨmɨre wawɨnyanna wɨjɨwaainɨma!’ daka sara yaꞌnesɨ. ");
INSERT INTO byr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yɨrɨkeꞌ puꞌdaaꞌnyɨ nyɨmaryasaabakere wawɨnya kuna yaanneinera. Dɨvi aane pwai kwai wawɨnya mi yannegaaꞌ jɨnnadesɨ. ");
INSERT INTO byr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kwaakevakɨ mwaaidɨ kwaakevakɨ mwaalyaraavɨne Baakeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jizaazai mena wɨdɨna yakegaaꞌ kwaakeꞌ maaraka kwaakevɨ maagwala wɨraaꞌmavaka maagwalyasɨ kwaakesɨ yamwaaihaka aꞌmwere tɨnnyaraarɨ araka marayepuraka ");
INSERT INTO byr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","wɨdɨna “Aalɨbunya Silowamɨyawɨnna wawaꞌgɨri gɨnnya sɨnnyaꞌ aalya jɨnana!” wɨdɨna. Yayaꞌ Silowamɨ “Maryasaawɨnɨkevɨ,” dɨnɨkesɨ. Sarevɨdaaꞌnyɨ aꞌmwei wawaka gannya sɨnnyaꞌ aalya yɨnaka tɨnna nayaa wangada ayɨna bɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Sarevɨdaaꞌnyɨ gamɨre angeꞌ avaalyaba mwaalyarajɨ sɨnnawɨ sai “Nɨgwia nyɨjaama!” wɨdadaaꞌnyɨyarɨ tɨnna wanganesarajɨ yɨwaaraꞌnyɨna “Walamwaaina yada aꞌmweraavɨ ‘Nɨgwia nyɨjaama!’ wɨdadei midaaka?” ");
INSERT INTO byr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Pwara wɨdɨna “Sahwalyɨ,” wɨdɨna yesaꞌ kɨrɨꞌ pwara wɨdɨna “Aawa, sai mɨka! Saibɨsalyɨ.” Sara dɨnyɨna yadaapi aꞌmwe sai wɨdɨna “Sahwainyɨra.” ");
INSERT INTO byr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Sarevɨdaaꞌnyɨ kumɨ yɨwaaraꞌna “Gɨnnya tɨnnyaraai tewaanyaraai waꞌdɨꞌnyɨ gara yɨmaꞌnɨwaka?” ");
INSERT INTO byr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Gamɨ jaꞌnawɨdɨna “Aꞌmwe Jizaazai woꞌnɨkei araka yamwaaihaka nɨnnya tɨnnyaraarɨ maranyɨraka nyɨdɨwaꞌ ‘Silowamɨyawɨnna wawaꞌgɨzɨ gɨnnya sɨnnyaꞌ aalya jɨnana!’ Sarevɨdaaꞌnyɨ kaanya wɨna yena yɨnɨwegaaꞌ sagaaꞌ tɨnna yarai wangamweinyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Sara wɨdɨna kyaꞌ kumɨ yɨwaaraꞌna “Gawɨ mwaalɨka?” Gamɨ wɨdɨna “Aawa, sarɨna myawɨriwa. Gawɨ dahamwaalɨka?” ");
INSERT INTO byr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aꞌmwe Perɨzɨyaraayawɨnna aꞌmwera kɨgaaꞌ tɨbɨnyai mwaalakerɨ yɨbwaramakuna. ");
INSERT INTO byr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jizaazai araka yamwaaihaka gamɨre tɨnnyaraai “Yenana!” dakegaaꞌ Juyaraavɨre Kwazaakegaakɨ. ");
INSERT INTO byr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Sarevɨdaaꞌnyɨ Kwazaakegaaꞌna Perɨzɨyara yɨwaaraꞌna “Tɨnna tewaanna wangamanɨgɨnyaꞌ gara yagɨneka?” Yɨwaaraꞌna kyeꞌ sai wɨdɨna “Nɨmɨre tɨnnyaraarɨ araka pɨrɨꞌ kamaranyɨꞌmwaꞌ nɨnnya sɨnnyaꞌ aalya yɨnena, yɨthaa, tɨnna tewaanna wangamanɨge.” ");
INSERT INTO byr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sarevɨdaaꞌnyɨ Perɨzɨya pwara wɨdɨna “Kɨwɨnya Kwazaakegaaꞌ myadeꞌna aꞌmwe sarɨ Gotɨyai maryasaabakei mɨka. Tewaanyai mɨka!” Wɨdɨna kyeꞌ kɨrɨꞌ pwara wɨdɨna “Sabwi yɨjɨwaainya yakebwi aꞌmwe kayaaꞌnanyai gara yannelaka! Tewaanyai dɨngaka?” Sara dɨnyɨna yeva kumɨnyɨ jaapainyɨna yadɨvɨꞌ maanga dɨnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sarevɨdaaꞌnyɨ pɨgaaꞌ Perɨzɨyara aꞌmwerɨ ayɨna yɨwaaraꞌna “Nedɨwaa ‘Nɨmɨre tɨnnyaraai tewaanyaraai wakɨwaꞌ.’ Nabaai, nedɨwaanyaꞌ sarɨna berɨva nedɨvanɨgɨ?” Aꞌmwei wɨdɨna “Gotɨyarɨ wɨꞌnawɨjɨwaakyai pɨropetɨyalyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Sarevɨdaaꞌnyɨ Juyara naangera sɨduta geꞌ geꞌ yawɨꞌna yeva dara muꞌnyɨ yesaꞌ “Ai, sɨnnawɨ tɨbɨnyai mwaalaka dahaaꞌ tɨnna nayaa wangamanɨkei daaka!” Mujevegaaꞌna pwaraavɨ wɨdɨna “Aꞌmwe darɨ ganɨmaangeyorɨna dɨmaraawila!” ");
INSERT INTO byr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Sawɨnna bɨna kyagi aꞌmwe naangera yɨwaaraꞌna “Aꞌmwe dai kɨrɨbwaalɨvaangei daaka? Mudangegaaꞌ ‘Tɨbɨnyai daaka!’ dathahi? Sarevɨdaaꞌnyɨ dahaaꞌ tɨnnyaꞌ gara yaka wangamanɨka?” ");
INSERT INTO byr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Sarevɨdaaꞌnyɨ neyoi jaꞌnawɨdɨna “ ‘Sahwai nehɨrɨbwaalɨvaangelyɨ. Mudangegaaꞌ tɨbɨnyai maarolyai daaka!’ yawɨꞌmanɨgoi. ");
INSERT INTO byr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Sareꞌna dahaaꞌ tɨnna wangamanɨkeꞌna myawɨrivanɨgoi. ‘Tɨnna jena!’ wɨdɨwakerɨ mwanganyaꞌnaalyɨra. Gamɨnyɨ jɨwaarayɨla! Nehɨrɨbwaalɨvaangei aꞌmwelyɨ. Sahwai gamɨnyɨna yɨhɨthathelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Juya naangeraavɨna lɨka yadisaꞌna neyoi sara wɨdɨna. Sareꞌ dareꞌnesɨ. Juya naangera mena dɨnyɨna “Yo, pwai kwai wɨdɨna ‘Sahwai Kɨraazɨtɨyalyɨ. Gotɨyai dahɨlakyaakelyɨ,’ wɨdɨna neyajai nemɨ wɨdɨna yaanneinera ‘Nemɨre lotuangengɨ muidɨnna! Maaveigɨnyɨ.’ ” ");
INSERT INTO byr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mena dɨnyɨna yesavɨdaaꞌnyɨ lɨka yagɨla sara wɨdɨna. Neyoi wɨdɨna “Aꞌmwelyɨ. Gamɨnyɨ jɨwaarayɨla!” ");
INSERT INTO byr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sarevɨdaaꞌnyɨ pɨgasaai aꞌmwei mudangegaaꞌ tɨbɨnyai yɨmaꞌnakerɨna ayɨna jaka wɨdɨna yeva gamɨnyɨ wɨdɨna “Gotɨyai gwangamanɨkerɨna ‘Byaannakelyɨ,’ duthana! Sareꞌna nedana! Aꞌmwe sarɨ nedɨwaanyai ‘Aꞌmwe kayaaꞌnanyalyɨ,’ nayaa sara yawɨꞌmanɨgo.” ");
INSERT INTO byr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Sarevɨdaaꞌnyɨ aꞌmwe sai jaꞌnawɨdɨna “ ‘Aꞌmwei nawɨꞌnyai dɨngaka? Kayaaꞌnanyai dɨngaka?’ Sareꞌ myawɨrivanɨge. Gave pɨrɨꞌna yawɨꞌmwa ‘Kɨgaaꞌ tɨbɨnyainyɨ mwaale. Dahaaꞌ tɨnnakeinyɨ tɨnna wangamanɨgeinyɨ.’ Sara yawɨꞌmwa.” ");
INSERT INTO byr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Sarevɨdaaꞌnyɨ kumɨ yɨwaaraꞌna “Gɨmɨnyɨ gara gyaka? Gara yaka ‘Tɨnna jena!’ gɨthɨwakeꞌ?” ");
INSERT INTO byr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aꞌmwei jaꞌnawɨdɨna “Mena yɨhɨthɨwa. Sara yɨhɨthɨweꞌ kadɨka muꞌnyɨwaataihi daa! ‘Savɨ kadɨka wɨꞌnaana!’ ayɨna baaꞌna nyɨdɨwaaꞌ. Sarɨmɨre sɨmunyavɨ ‘Gamɨreina yɨmaꞌnaana!’ dɨmanɨgasaihi daaka!” wɨdaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Sara wɨdɨna kyaꞌ kumɨ sarɨ bɨrala wɨdɨna yeva wɨdɨna “Aꞌmwe sahwareigɨnyɨ. Nemɨ Ne Mozɨzareinera. Sarɨ mɨdɨdaanyaina. ");
INSERT INTO byr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Gotɨyai Mozɨzarɨ wɨjaakeꞌna yawɨꞌmwo. ‘Aꞌmwe pwai gawɨdaaꞌnyai dɨngaka!’ nemɨ myawɨriwo.” ");
INSERT INTO byr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Aꞌmwei jaꞌnawɨdɨna “Sara nyɨdɨwaasaꞌna atɨka maruꞌnaꞌmanɨge. Sawɨdaaꞌnyai bakeꞌna myawɨrivanɨgasai ‘Tɨnna jena!’ nyɨdɨwakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Aꞌmwera kayaaꞌnanyabwi yadɨvɨsaraavɨ Gotɨyai kadɨka muꞌnyɨ yɨvanɨkeꞌ yawɨꞌmwo. Aawa. Pwai kwai Gotɨyarɨna dɨna ‘Naangelyɨ. Lɨka yadɨnyalyɨ. Sara nyɨdatheꞌ gamɨre sɨmunyavɨ sara yɨdeinyɨ,’ daderɨ Gotɨyai kadɨka nayaa wɨꞌnyɨna yɨvanɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sɨnnawɨ Kwaakevakɨ wakyaakegaaꞌdaasɨ yuyagaaꞌ kadɨka dara muꞌnyadaanyaꞌ ‘O, pwai mudangegaaꞌ tɨbɨnyai yɨmaꞌnakerɨ “Tɨnna jena!” dathaka!’ Sara muꞌnyadaanyainera. ");
INSERT INTO byr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Gotɨyaryawɨdaaꞌnyɨ mabi yajai Gotɨyare dɨragɨnya aane pɨrɨꞌ kɨrɨꞌ kyadɨkaꞌ mɨka.” ");
INSERT INTO byr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kumɨ wɨdɨna “Mudangegaaꞌ yuna kayaaꞌnanyaigɨnyɨ. Dɨvi kuna kayaaꞌnanyabwi yadɨnyaigɨnyɨ. Sareigɨ danejɨwakɨwaana!” Sara wɨdɨna yeva lotuangevɨ gamɨnyɨ marasɨꞌnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jizaazai kadɨka dara wɨꞌnakeꞌ “Lotuangevɨ aꞌmwerɨna dasɨꞌnɨwaaꞌ!” Mena daka aꞌmwerɨ bɨramaaꞌna yaka wɨdɨna “Aꞌmweraavɨne Kaimɨraayarɨ dalɨmwagaꞌmanɨgɨna?” ");
INSERT INTO byr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wɨdɨna kyaꞌ aꞌmwei wɨdɨna “Aꞌmwe naangeigɨ, aꞌmwela dɨvanɨgɨnyarɨna ‘Sahwarɨ mɨdɨnɨma!’ dena dɨnyɨbwarɨdaakwia!” ");
INSERT INTO byr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jizaazai wɨdɨna “Gamɨ sahwarɨ tɨnna mena wangamwaa. Sai dahaaꞌ gɨthɨvanɨkei sahwalyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Aꞌmwei wɨdɨna “Naangeigɨ, gɨlɨmwagaꞌmanɨgena.” Wɨdɨna yaka Jizaazaryaba kwadaai gɨlɨna yaka lotuya yɨna yaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jizaazai yuyaraavɨ wɨdɨna “Kwaaka davakɨ nɨmɨ aꞌmweraavɨ yawɨbwataꞌna bɨna ye. ‘Tɨbɨnyara bɨꞌmanɨgasara, nabaai sara wangabɨka!’ dena bɨna. ‘Tɨnnakera “Nemɨ tewaanyainera,” dadɨvɨtara, nabaai, tɨbɨnyara yɨmaꞌnɨpɨka!’ dena bɨna ye.” ");
INSERT INTO byr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Perɨzɨya pwara gamɨnyɨ mwaalesara Jizaazai wɨdakeꞌ kadɨka wɨꞌneva yɨwaaraꞌna “Nemɨnyɨna dathɨwaana? ‘Tɨbɨnyaihi Gotɨyarɨna sɨdusaꞌ myawɨrivanɨgaꞌ,’ sara dathɨwaana?” ");
INSERT INTO byr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jizaazai wɨdɨna “Tɨbɨnyaihi bɨꞌmanɨgasaihi mwaaibɨzɨ kwajɨ kayaaꞌnanyaihi kuna mamwaalyɨ kyɨpɨdɨka! Saꞌna ‘Tɨnna nayaa wangamanɨgo tewaanyaina,’ dadɨvɨꞌ kayaaꞌnanya kɨnɨnnakeihi mwaaihaꞌ.” ");
INSERT INTO byr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jizaazai wɨdaꞌ “Naanga nebulyaꞌna yɨhɨthɨvanɨge. Sipɨzipɨkurɨsavɨ tɨkuryavɨ mulyɨ yajaꞌ kɨrɨꞌ kukidaaꞌnyɨ dɨkwosɨꞌna yajai yɨ sai kukelyɨ. Nabaai, kuka yɨpalamaaꞌdelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tɨkuryavɨna aꞌmwe pwai wɨlaabɨna yajai sai sipɨzipɨyaraavɨ maremwaaidelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sahwarɨna kaanyavɨ maremwaaidei kaanya basadaawori sipɨzipɨyaraavɨ maremwaaide sai gannya sipɨzipɨyaraavɨ ‘Yɨnagaawai! Yɨnagaavaihaꞌ!’ jaka wɨdɨna yadaaꞌnyɨ sipɨzipɨyara gamɨnyɨ maanguraayaꞌ kadɨka wɨꞌnyɨna yadaapi mwasɨlaanna yɨbwaramakwalyuna yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mwasɨlaa gannya yuyaraavɨ mena yɨbwaramakwalyuna yada sɨnnawɨ waanyɨna yadaaꞌnyɨ gamɨnyɨ mɨdɨnna yadɨvɨꞌ gamɨre maanguraayaꞌ wɨꞌnamaaꞌna yadɨvɨsaꞌna mɨdɨdɨvɨkɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Aꞌmwe mudɨkerɨ mɨdɨdɨvɨꞌ mɨꞌ. Arɨkawɨ. Aawa. Mudɨkerɨna lɨkaanya wɨna. Mudɨkeraavɨre maanguraayaꞌ yadɨvɨsaꞌna lɨkaanya wɨna yadɨvɨsarera.” ");
INSERT INTO byr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jizaazai yagaala keꞌbaꞌnanya saꞌ kudaꞌ kɨrɨꞌ kumɨ dɨnyɨna “Nedɨwaka saꞌ be yagaalavaka? Myawɨriwona.” ");
INSERT INTO byr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Sarevɨdaaꞌnyɨ Jizaazai ayɨna wɨdɨna “Naanga nebulyaꞌna yɨhɨthɨvanɨge. Nɨmɨ sainyɨ sipɨzipɨyaraavɨne kaadihɨsainyɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yuya pwara sɨnnawɨ kukera kuka yɨpalamaaꞌdɨvɨsarera. Nɨmɨ mabyahaaꞌ kwaasɨyara yɨhɨthesaꞌ kɨrɨꞌ sipɨzipɨyara nɨmɨrera kadɨka muꞌnyɨ yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kaadihɨsainyɨ nɨmɨnyɨra. Nɨmɨnyawɨnna aꞌmwe pwai bazai kusawɨnna wɨlajai Gotɨyai wɨvadaihasamaaradelyɨ. Sipɨzipɨkurɨsavɨ sai wɨlamwaaina yada mwasɨlaa wapaaya bwalyamaaꞌna yada ayawɨnna wɨlɨna yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kukei ‘Kuka maarɨma! Saraavɨ tamɨma! Saraavɨ kayaaka yɨgalakɨma!’ dada badelyɨ. Nɨmɨ ‘Saraavɨ gaalyabwi maapɨka! Yɨ gaalyabwi naanga naanga maapɨka! Munya winana!’ dena baheinyɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Sipɨzipɨyaraavɨ maremwaaide tewaanyai nɨmɨnyɨra. Sipɨzipɨyaraavɨ maremwaaide tewaanyai dɨna ‘Nɨmɨrera mwaaibɨka! Nɨmɨ balɨma! Nɨmɨrera nabaibɨthɨka!’ dada gamɨre gaalyabwi walakɨna yadelyɨra. ");
INSERT INTO byr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nɨgwɨwawɨnyai kavɨjɨlɨkei bozɨyarɨ tɨnna wanganojɨ sipɨzipɨyaraavɨ yaꞌmaꞌna yojɨ lɨkaanya wɨna. Nɨgwɨwawɨnyai sipɨzipɨyaraavɨ maremwaaidei mɨka. Gannyaraavɨ gyakwai mɨka. Savɨdaaꞌnyɨ sai lɨkaanya wɨna. Lɨkaanya wɨna kyojɨ kavɨjɨlɨkei sipɨzipɨyaraavɨ tɨka davɨna kyojɨ pwara pɨwɨnna pɨwɨnna lɨkaanya wɨna yapɨjɨ yɨwɨnadaaꞌna yɨpɨꞌderera. ");
INSERT INTO byr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nɨgwɨwawɨnyai gannya nɨgwiannajɨ gannya kɨlaakejɨꞌnajɨ gavenna yawɨꞌna yada myawɨrina ‘Sipɨzipɨyaraavɨna yɨlaaya yɨma! Tewaanna maremwaaimujainyɨ,’ sara myawɨryori nɨgwɨwawɨnyai lɨkaanya wɨna yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Sipɨzipɨyaraavɨ maremwaaide tewaanyai nɨmɨnyɨra. Nɨmwai nɨmɨnyɨ nyawɨꞌda nɨmɨ Nɨmwarɨ yawɨꞌdɨnyabaaibɨꞌ nɨmɨ nɨmɨreraavɨ yawɨꞌdɨ kumɨ nɨmɨnyɨ nyawɨꞌdɨvɨsainyɨ. Kumɨnyɨ yawɨꞌdɨ kumɨnyɨna nɨmɨre gaalyabwi walakɨna yadɨ baimujainyɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Sipɨzipɨya pwara nɨmɨrera mwaalɨna yadɨvɨꞌ sipɨzipɨkurɨta davɨ mamwaalyɨ yadɨvɨsarera. Sahwaraavɨjɨ makabɨna yɨdere. Nɨmɨre maanguraayaꞌ kadɨka nyuꞌnapɨri dahaaꞌ nɨmɨre sipɨzipɨyara mwaaihasarajɨ mudɨkera nɨmɨrerajɨ sipɨzipɨkwala gaveꞌ yɨmaꞌnɨpɨꞌdesɨra. Yuyaraavɨ maremwaaladei gavei mwaalɨkelyɨra. ");
INSERT INTO byr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Savɨdaaꞌnyɨ nɨmɨ dɨna ‘ “Nɨmɨre gaalyabwi ayɨna maarɨma!” daꞌmujɨ nɨmɨreraavɨna sabwi walakɨdeinyɨ,’ dadɨnyaꞌna Nɨmwai nɨmɨnyɨna kurya nyukadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Aane pwai kwai nɨmɨre gaalyabwi mamaaryɨwaꞌ. Aawa. Nɨmɨ sainyɨ kave walakɨna yɨdeinyɨ. Nɨmɨ navɨka mwaalɨna kyaꞌmuri pwara nyɨramakɨpɨꞌdeꞌ mɨꞌ. Aawa, nɨmɨ sainyɨ dɨna ‘Pwara nyɨramakɨpɨka!’ dɨna kyaꞌmuri nyɨramakɨpɨꞌdeinyɨ. Sahwainyɨ dɨragɨnyainyɨ dɨna ‘Pwaraavɨna balɨma!’ nabaai Nɨmwai sara nyɨdakakeinyɨ dɨragɨnyaꞌ nyɨjaavakeꞌ dɨvi sara yɨdeinyɨra.” ");
INSERT INTO byr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jizaazare yagaala sanna kadɨka wɨꞌnyɨna yeva Juyara maanga dɨnyɨna yeva ayɨna jaapainyɨna. ");
INSERT INTO byr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kwalaalyara dɨnyɨna “Yɨmakei kɨnɨnnakelyɨ. Aaꞌnelyɨ. Yɨmakyagaala dɨvanɨkelyɨra. Gamɨnyɨ kadɨka baaꞌna wɨꞌnɨwaava!” ");
INSERT INTO byr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sara dɨnyɨna yadaapi pwara wɨdɨna “Yagaala sa yɨmakei wɨlamwaaidere yagaala mɨka. Aaꞌnei aꞌmwe tɨbɨnyarɨ ‘Tɨnna jena!’ gara wɨdɨwaka?” wɨdɨna yeꞌ Juyara. ");
INSERT INTO byr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pɨgaaꞌ Anga Jeruzaalemɨ Juyara yawɨꞌdɨvɨꞌ “Gotɨyare Angeꞌ tewaanyaꞌ ayɨna yɨmaꞌnyaakeꞌna tɨka munne naana! Gotɨyarɨ yɨlaaya yaana!” Dɨnyɨna yesagaaꞌ yɨrɨlyagaaꞌ burɨkegaakɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Munne sagaaꞌ Gotɨyare Angevɨ Ne Solomonɨmɨne yɨhukangevɨ Jizaazai kaanya yamarina. ");
INSERT INTO byr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Sarevɨdaaꞌnyɨ gamɨnyawɨnna Juyara yɨkabɨna, dakwamwadaꞌna yeva wɨdɨna “Nemɨ ‘Sahwai dɨngaka? Pwai dɨngaka?’ kuna yawɨꞌmanɨgoꞌna nayaa gathɨngaaꞌ dɨnedathevaka? Aangyagaala nebwina kavena dɨnedana! Kɨraazɨtɨyaigɨ Gotɨyai gɨthahɨlakakeigɨ mwaaidɨzaꞌ naangeꞌnanyaꞌ dɨnedana!” ");
INSERT INTO byr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jizaazai jaꞌnawɨdɨna “Mena yɨhɨthena kɨrɨꞌ nɨmɨnyɨ malɨmwagyɨ yɨwaava. Nɨmaamaangere dɨragɨnyasɨ tewaanna yɨvanɨge wawɨnyanna nayaa nyɨjalɨkurakyaka kɨrɨꞌ sarɨmɨ manyɨlɨmwagyɨvanɨgaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nɨmɨre sipɨzipɨyaihi mwaaibɨzɨ kwajɨ kanyɨlɨmwabɨthɨka! Nɨmɨre sipɨzipɨyaihɨrɨna mɨꞌ. Sareꞌna manyɨlɨmwagyɨvanɨgaꞌ. ");
INSERT INTO byr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nɨmɨre sipɨzipɨyara nɨmɨre maanguraayaꞌ kadɨka wɨꞌnadɨvɨꞌ nɨmɨ yawɨꞌmanɨge sarera nyɨmɨdɨdɨvɨsare. ");
INSERT INTO byr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yuyagaaꞌ yuyagaaꞌne gaalyabwi wɨjaavadɨ yuyagaaꞌ yuyagaaꞌ myɨwɨyɨ yɨpɨꞌdere. Arɨkawɨ. Nɨmɨreraavɨ aꞌmwe pwai kwai nɨmɨre asɨrɨ myɨpalasɨꞌnyɨ nyapɨjɨ kayaaꞌna myɨ yɨpɨꞌdere. ");
INSERT INTO byr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nɨmaamaangei sahwaraavɨ nyɨjaavakei dɨragɨnaangelyɨ. Yuyara pwara dɨragɨmaayare. Nɨmaamaangei maremwaaimanɨkeraavɨ aane pwai kwai Nɨmware asɨrɨ mipalasɨꞌnyɨ yannere. ");
INSERT INTO byr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nɨmɨjɨ Nɨmwalyɨ sanɨdainaai avaalyainaalyɨ,” wɨdɨna yaꞌ Jizaazai. ");
INSERT INTO byr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Sagaaꞌ Juyara “Tamakyaꞌna sɨlaange lɨwakaana!” deva sɨla ayɨna maarɨna. ");
INSERT INTO byr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ayɨna maarɨna kyeꞌ Jizaazai jaꞌnawɨdɨna “Nɨmwai nyɨdaꞌ ‘Dɨragɨnyajɨ tewaanyajɨ ja!’ Sara kanyɨdaꞌ sarɨmɨnyawɨ kwalaalya sara yɨwa. Nɨmɨre wawɨnya garɨꞌna yawɨꞌdɨvɨꞌ ‘Lɨwakaana!’ dadɨvɨꞌ yɨvanɨgava sɨlyajɨ?” ");
INSERT INTO byr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Juyara jaꞌnawɨdɨna “Gɨmɨ wawɨnya tewaanyavɨna ‘Sɨla lɨwakaana!’ dɨvanɨgoꞌna mɨꞌ. Aawa. Gotɨyarɨna bɨrala yɨvanɨgɨnyaꞌna saꞌna yawɨꞌdaa ‘Sɨla lɨwakaana!’ dɨvanɨgoꞌna. Gɨmɨ sahwaigɨ aꞌmweigɨ kwaigɨ kɨrɨꞌ nedɨwaa ‘Nɨmɨ Gotɨyainyɨ,’ sara nedɨwaaꞌna bɨrala yɨvanɨgɨnyaigɨnyɨ aꞌmwe kwaigɨ.” ");
INSERT INTO byr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jizaazai jaꞌnawɨdɨna “Sarɨmɨre yagaaikɨwɨnyaꞌ dɨnɨꞌ ‘Gotɨyai wɨdɨna “Sarɨmɨ gotɨyaihɨlyɨ.” ’ ");
INSERT INTO byr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Sara dɨnɨkeꞌ nabaai, ‘Yuyagaaꞌ Gotɨyare bukuyavɨ yagaalyaꞌ dɨnɨkeꞌ waragothesɨ,’ yawɨꞌdaanyainera. Aꞌmwe saraavɨ Gotɨyai wɨdɨna ‘Sarɨmɨ gotɨyaihɨlyɨ,’ wɨdɨna yaakeꞌnanyɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Sareꞌ Nɨmwai gamɨre wawɨnyaꞌna nayaa yɨdeꞌna tewaanyainyɨ nyɨdahɨlakaka Kwaakevakɨna maryasaabɨna kanyaꞌ sareinyɨ ‘Gotɨyarɨ Gawaalɨvaangeinyɨ,’ yɨhɨthɨweꞌna ‘Sahwai Gotɨyarɨ bɨrala yɨwaka,’ gara dɨmanɨgaꞌ! ");
INSERT INTO byr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yɨthaa, Nɨmwai yɨvanɨkabaaibɨꞌ gamɨre wawɨnyanna myɨwɨjɨ kwajɨ malɨmwagyɨ dɨnyideihɨlyɨ. Sarebwi tewaanyabulyɨ. ");
INSERT INTO byr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Sareꞌ kɨrɨꞌ Nɨmwai yɨvanɨkabaaibɨꞌ nɨmɨ sara yɨvanɨgeꞌna dɨnyɨlɨmwagyɨla! Nɨmɨ yagaala yɨhɨthɨweꞌna malɨmwagyɨ nyɨpɨjaꞌ wawɨnya sanna yɨvanɨgevwi wanganapɨri dɨlɨmwagyɨla! Sara yapɨri ‘ “O, Nɨmwai Jizaazarɨ wɨlamwaalɨkei daaka! Jizaazai Nɨmwarɨ wɨlamwaaidei daaka!” yawɨraana! Kuna sara yawɨraana!’ dapɨri wawɨnya sanna dɨlɨmwagyɨla.” ");
INSERT INTO byr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Sarevɨdaaꞌnyɨ kumɨ yagaalyaꞌna jɨkurya yeva ayɨna yawɨꞌna “Kalavuzaꞌna wɨla pwɨyaana!” Sara deva yesaꞌ. Jizaazai kumɨnyabadaaꞌnyɨ kaanna wodaaꞌnyɨ tɨnna wanganeva wanganakɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Aalya Jothanɨyavɨ Jizaazai ayɨna gaꞌmaꞌna yaka sɨnnawɨ sagaaꞌ Jonɨ aalyavɨ bavɨtaazɨyaꞌ yakewɨ wɨna yaka saba mwaalɨna. Saba mwaalɨna yadɨꞌnyɨ ");
INSERT INTO byr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","gamɨnyawɨnna aꞌmwe kwalaalyara bɨna. “Jonɨ sahwai atɨka maruꞌnata aane pɨrɨꞌ kɨrɨꞌ myɨ yaꞌ. Yuya aꞌmwe darɨna nedakabaaibɨsa nebulyangɨ,” dɨnyɨna yeva bɨna. ");
INSERT INTO byr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bɨna kyeꞌ saba aꞌmwe kwalaalyara gamɨnyɨ lɨmwagaꞌna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Aꞌmwe pwai Lazaarazai woꞌnɨkei Anga Betaani mwaalyai nabalɨnakei yɨmaꞌnyɨna. Anga Betaani savɨ Maarɨyaasɨ ganaanaanga Maathasɨ sanadaai mwaalagɨlyabanyɨ. ");
INSERT INTO byr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maarɨyaa saꞌ Naangere sɨvɨlyaraarɨ welivananya wabatɨrɨnyaꞌ dɨngɨna yaka gannya mɨjasasɨ yɨwaipɨwanna yakeꞌ gamɨnyɨ gathaakaanga Lazaarazai nabalɨnakei mwaalakesɨ. ");
INSERT INTO byr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nabalɨnakei yɨmaꞌnyɨna yakevɨdaaꞌnyɨ kɨnadaai Jizaazarɨ yagaalyaꞌ wɨdaasɨna “Naangeigɨ, gɨnnya jaꞌmwei nalaavɨnakelyɨ,” wɨdaasɨna yagi. ");
INSERT INTO byr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jizaazai kɨrɨmɨre yagaalyaꞌ wɨdaasagɨlyaꞌ kadɨka wɨꞌnyɨna yaka gamɨreraavɨ wɨdɨna “Nabalya saꞌ yuna balyabwineꞌna mɨka. Aawa. Nabalya saꞌ yɨmaꞌnɨwaꞌdɨkeꞌna aꞌmwera dɨnyɨna ‘Gotɨyai Naangelyɨ. Gotɨyai byaanna dɨragɨnyaꞌ kɨnɨnnakelyɨ.’ Sareꞌnesɨ. Nabaai nɨmɨnyɨna ‘Gotɨyare Gawaalɨvaangei Naangelyɨ. Byaannakelyɨ,’ daka nabalya saꞌ yɨmaꞌnɨwaꞌdɨꞌ.” ");
INSERT INTO byr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jizaazai Maathavɨjɨ gamɨre ganyaabulaangevɨjɨ Lazaarazarɨjɨ sagɨnyɨrakaavɨna wɨvuꞌnakelyɨra. ");
INSERT INTO byr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sarevɨdaaꞌnyɨ “Nabalɨnakei mwaalɨꞌ,” wɨdaasagɨlyaꞌ Jizaazai kadɨka wɨꞌnyɨna yaka saba mwaalakeba yɨrɨka pɨryaarɨ kuna mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mena kuna mwaalɨna yaka gamɨreraavɨ wɨdɨna “Kwaaka Juthɨyanna Lazaarazare angewɨnna ayɨna wawaana!” ");
INSERT INTO byr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Gamɨrera wɨdɨna “Akai, nejɨwaakadɨnyaigɨ kɨgaaꞌ maalɨkegaaꞌ Juyara dɨnyɨna ‘Jizaazarɨ sɨlaangejɨ lɨwakaana!’ Sareꞌna Juthɨyanna ayɨna jɨtheigɨ daaka!” ");
INSERT INTO byr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jizaazai jaꞌnawɨdɨna “Nɨmɨregaaꞌ miꞌna daaka! Yɨthaa, yɨrɨkegaaꞌ nyɨlyai dadehaaꞌ (12 aawaaya) midaaka! Kwaaka davakɨ yɨrɨkeꞌ puꞌdaasɨyagaaꞌ aꞌmwe pwai yɨrɨkevɨ kaanna yamarina yajai kwaaka davakɨya baakeꞌ tɨnna wangadeꞌna mala myamaari yadelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sareꞌ kɨrɨꞌ sawɨsavɨ sai kaanna yamarina yajai baakeꞌ gamɨnyɨ mularikeꞌna mala yamaaradelyɨ. Dahaaꞌ yɨrɨkeꞌbɨsagaaꞌ wawaana!” ");
INSERT INTO byr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Sa wɨdɨna yaka pɨrɨꞌ wɨdɨna “Neyaꞌmwei Lazaarazai se waꞌmwaka kɨrɨꞌ kaanna wawaꞌmuri yɨdɨkaavɨdeinyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Sarevɨdaaꞌnyɨ gamɨrera wɨdɨna “Naangeigɨ, se waꞌmanɨkeꞌ tewaanyabulyɨ. Dɨvi nalaayaꞌ mena yadelyɨ. Sareꞌna mawaanna!” ");
INSERT INTO byr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jizaazai gamɨre balyaꞌnebwina wɨdakesɨ. “Lazaarazai mena baimwaka.” Gamɨrera yawɨꞌna “ ‘Se waꞌmwaka,’ nedɨwakesɨ.” ");
INSERT INTO byr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sara yawɨꞌna yesavɨdaaꞌnyɨ Jizaazai aangyagaala kave wɨdɨna “Lazaarazai baimwakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Savɨdaasɨ kɨrɨꞌ gamɨnyaba mamwaalyɨweꞌna ‘Nɨmɨrera nyɨlɨmwagapɨka!’ dena yɨlaaya yɨvanɨge. Sareꞌ gamɨnyawɨnna kaanya wawaana!” ");
INSERT INTO byr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Sarevɨdaaꞌnyɨ Aꞌmwe Tomaazai Jizaazare pwaraavɨ wɨdɨna “Wikɨra. ‘Gamɨjɨ balaana!’ dawaajɨ yuyainajɨ wawaana!” wɨdaꞌ. Tomaazai gɨraꞌmɨraala maarakei mwaalaka kunnya yagaala “Dɨthimaazai,” woꞌnɨkelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sarevɨdaaꞌnyɨ Jizaazai kaanna wɨna yɨna yaka savɨna yɨꞌmaꞌna yakegaaꞌ dara wɨꞌnakeꞌ “Lazaarazai kabaimwaꞌdɨꞌ yɨrɨka daryaai daryaalyavɨ simaangevɨ wakɨnɨkelyɨra.” ");
INSERT INTO byr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Anga Betaani saꞌ Anga Jeruzaalemɨdaaꞌnyɨ esabera. Jeruzaalemɨdaaꞌnyɨ kilomitaaya dawaai dasaba mannɨkebanyɨ Anga Betaani. ");
INSERT INTO byr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Juyara “Betaani esabera,” dɨna yeva kwalaalyara Maathavɨjɨ Maarɨyaavɨjɨ sanadaarɨna angyɨrɨꞌmaata yɨna. “Kɨryaꞌmwerɨna kaleꞌna wɨgaimwagaana! ‘Kale nyɨwaka,’ wɨdaana!” deva angyɨrɨꞌmaata yɨna. ");
INSERT INTO byr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maathaꞌ kadɨka dara wɨꞌnakeꞌ “Ai, Jizaazai davɨvanɨka!” Sara dakevɨdaaꞌnyɨ mwasawɨnna walyawɨjɨmaꞌnaawɨna kyaꞌ gannya angevɨ Maarɨyaaꞌ mwaalɨna. ");
INSERT INTO byr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maarɨyaaꞌ mwaalɨna yadɨꞌnyɨ Maathaꞌ Jizaazarɨ wɨjɨmaaꞌnyɨna yaka wɨdɨna “Naangeigɨ, dava mwaaidɨzɨ kwajɨ nyɨdaakaangei mabalyɨ kyadɨka! ");
INSERT INTO byr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Savɨna kɨrɨꞌ yawɨꞌna ‘Nabaai dahaaꞌ sagaaꞌ gɨmɨ Gotɨyarɨ jɨwaaraꞌdeꞌna Gotɨyai sara wɨjaavadelyɨra.’ Sara yawɨꞌmweꞌnyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jizaazai wɨdɨna “Jɨthaakaangei mwaaladei dɨkaavadera.” ");
INSERT INTO byr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Sara wɨdɨna kyaꞌ aꞌmweꞌ wɨdɨna “Nɨmɨ yawɨꞌna ‘Aayagaaꞌ Kwaaka davaꞌ aayaꞌ yɨmaꞌnadehaaꞌ dɨkaasagaaꞌ ayɨna mwaaladelyɨ. Dɨkaavadelyɨ,’ sara yawɨꞌmwana.” ");
INSERT INTO byr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jizaazai wɨdɨna “Nɨmɨ aꞌmweraavɨ aꞌmwengɨ yɨdɨkaaꞌdɨnyainyɨ nɨmɨnyɨra. Dɨkaasabwi nɨmɨnyɨra. Nɨmɨ aꞌmweraavɨ aꞌmwengɨ wɨmwaaihadɨnyainyɨ. Gaalyabwi nɨmɨnyɨra. Pwai nyɨlɨmwagazai balajai mwaaladelyɨra. ");
INSERT INTO byr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Gazaizai tewaanna mwaaida nyɨlɨmwada yuyagaaꞌ mabalyɨ yadelyɨra. Arɨkawɨ. Sabwina dalɨmwamanɨgɨ?” ");
INSERT INTO byr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aꞌmweꞌ wɨdɨna “Yo, Naangeigɨ, gɨmɨnyɨna dara lɨmwamanɨge ‘Gɨmɨ Kɨraazɨtɨyaigɨ Gotɨyarɨ Gawaalɨvaangei Kwaaka davakɨna bahɨnyaigɨnyɨra.’ Sara yawɨꞌna yɨweꞌnyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Saꞌ Maathaꞌ wɨdakegaaꞌ ayɨna wɨna yaka ganyaabulaanga Maarɨyaavɨ kave danganna yaka kukuꞌnya wɨdɨna “Dava Nejɨwaakadei bamwaalaka gɨthathelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Wɨdɨna kyaꞌ aꞌmwe saꞌ wɨꞌnyɨna, daavɨna yaka wɨjɨmaaꞌnyaꞌneꞌ yarai walyuna. ");
INSERT INTO byr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Sagaaꞌ anga saba Jizaazai mwɨlaabyɨ. Aawa. Maathaꞌ wɨjɨmaaꞌnakeba kuna mwaalɨna yakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yarai walyuna kyaꞌ angevɨ Maarɨyaayaba Juyara wɨlamwaaina yeva kale wiakera tɨnna dara wanganesaꞌ “O, Maarɨyaaꞌ daavɨna yaka yarai walyuvanɨkeꞌ daaka!” Sara devevɨdaaꞌnyɨ mɨdɨnaabɨna. Juyara yawɨꞌna “Gɨlaayarɨ wakɨnɨkeba kɨnnyaꞌna walyuvanɨka,” yawɨꞌna yeva mɨdɨnaabɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jizaazaryawɨnna Maarɨyaaꞌ yɨꞌmaꞌna yaka tɨnna wangadevɨdaaꞌnyɨ gamɨre sɨvɨlyaraarɨ walaꞌna yaka avaaina wɨdɨna “Naangeigɨ, dava mwaaidɨzɨ kwajɨ nyɨdaakaangei mabalyɨ kyadɨka!” ");
INSERT INTO byr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maarɨyaaꞌ kɨnna dadaasɨ Jizaazai tɨnna wanganna. Nabaai gamɨjɨ Juyara besara kɨnna dadaapi Jizaazai tɨnna wanganna. Tɨnna wanganna yakevɨdaaꞌnyɨ kale naanga wiadaasɨ gamɨre kuryarɨ sɨmuyɨwaala yawɨꞌna, aꞌmwera baryaꞌna sɨmunya kwalaalya yawɨꞌna. ");
INSERT INTO byr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Sɨmunya kwalaalya yawɨꞌna yaka yɨwaaraꞌna “Sarɨmɨ gawɨ wakɨwaꞌdaava?” Kumɨ wɨdɨna “Naangeigɨ, bwanganna ja!” ");
INSERT INTO byr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Wɨdɨna kyeꞌ Jizaazarɨ kɨdaraalya walaabɨna. ");
INSERT INTO byr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kɨnna dɨna yadaaꞌnyɨyaꞌna Juyara dɨnyɨna “Yɨthaa, Lazaarazarɨna tewaanya wɨvuꞌnakerɨnesɨ.” ");
INSERT INTO byr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Dɨnyɨna kyeꞌ kɨrɨꞌ pwara dɨnyɨna “Tɨbɨnyarɨ ‘Tɨnna jena!’ wɨdaꞌ. Saꞌna daaka! Sarebaaibɨꞌ gamɨ wɨdɨna ‘Lazaarazai mabaidɨnna!’ wɨdazɨ kwajɨ sahwai mabalyɨ kyadɨkei daaka!” dɨnyɨna yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Sarevɨdaaꞌnyɨ Jizaazai kale naanga ayɨna wiadaasɨ gamɨnyɨ sɨmuyɨwaala ayɨna yawɨꞌna yada gɨlaayai wakɨnɨkewɨnna wɨna. Gɨlaaya wakɨnɨke saꞌ simaangesɨ. Simaangevɨ tɨkuryavɨ sɨlaangevaꞌ tihɨꞌnɨkesɨ. ");
INSERT INTO byr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Gɨlaayai wakɨnɨkewɨnna mena wɨna yaka wɨdɨna “Sɨlaanga daꞌ dɨvaasɨla!” Sara kudaꞌ Maathaꞌ gɨlaayarɨ ganyaabulaangeꞌ wɨdɨna “Aawa, Naangeigɨ, butɨrɨnyaꞌ wɨlarɨka. Sareꞌ dareꞌnesɨ. Yɨrɨka daryaai daryaalyarɨkɨ dahaaꞌ!” ");
INSERT INTO byr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jizaazai wɨdɨna “ ‘Gɨmɨ nyɨlɨmwagaꞌgɨzɨ Gotɨyare byaanna dɨragɨnyabwi tɨnna dangadeꞌgɨnyɨ,’ gɨthɨweinyɨ midaaka!” ");
INSERT INTO byr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Sara wɨdɨna yakevɨdaaꞌnyɨ sɨlaangeꞌ baasɨna. Mena baasɨna kyeꞌ Jizaazai maranganna yaka wɨdɨna “Nɨmwai, ‘Su! Su!’ gɨthɨwa. Kadɨka nyuꞌnɨwaanyaꞌna ‘Su,’ gɨthɨwa. ");
INSERT INTO byr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yuyagaaꞌ kadɨka nyuꞌnadɨnyaigɨnyɨneꞌna yawɨꞌmweꞌ kɨrɨꞌ dava kwala naanga mwaaihasaraavɨna sara gɨthɨwa. ‘ “Gotɨyai Jizaazarɨ yasaabakeva,” lɨmwabɨka!’ dena sara gɨthɨwa.” ");
INSERT INTO byr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Sa miꞌna wɨdɨna yaka maanguraaya naangevaꞌna jaka wɨdɨna “Lazaarazaigɨ, dalyaama!” ");
INSERT INTO byr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Sara wɨdɨna kyaꞌ baryai walyaabɨna. Baryare asɨraalyɨ sɨvɨlyɨraalyɨ kwaabɨhannyaꞌ gwavaaihɨꞌnɨkeꞌ, gamɨre sɨnnyaꞌ kwaabɨyɨvɨsaꞌ gwavaaihɨꞌnɨkelyɨ. Sare kɨrɨꞌ baryai walyaabɨna kyaꞌ Jizaazai aꞌmweraavɨ wɨdɨna “Kaanya wawodeꞌna jɨꞌdaalyɨla!” wɨdaꞌ. Kudaꞌ sara yeꞌ. ");
INSERT INTO byr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sarevɨdaaꞌnyɨ Juyara Maarɨyaaꞌ angyɨrɨꞌmaata yeta kwalaalyara Jizaazai yakeꞌ tɨnna wanganeva Jizaazarɨ lɨmwanna yadɨvɨꞌ “Kɨraazɨtɨya sahwalyɨ,” dɨna. ");
INSERT INTO byr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Sara dɨna kyeꞌ kɨrɨꞌ pwara Aꞌmwe Perɨzɨyaraayawɨnna wɨna yeva Jizaazai yakeꞌna wɨdɨna. ");
INSERT INTO byr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Miꞌna wɨdɨna yesavɨdaaꞌnyɨ Perɨzɨyarajɨ Gotɨyarɨna yɨraꞌdɨvɨta naangerajɨ Juyaraavɨre Kaajolɨyarajɨ yɨꞌbwaꞌna yeva dɨnyɨna “ ‘Gara yaadevaka?’ Aꞌmwe dai yɨjɨwaainya kwalaalya yɨvanɨkele! ");
INSERT INTO byr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nemɨ mujɨna ‘Sabwi minnera!’ mujɨ yaajaꞌ yuyara gamɨnyɨ lɨmwabɨꞌdelyɨ. Sara kyapɨjɨ Aꞌmwe Romɨya naangera yaasɨna kyapɨjɨ aawɨlasara bɨna yapi Gotɨyare Angevɨ kayaaka yɨgalapi yɨta davaakɨya Juyainaavɨ neramakɨpɨꞌdeꞌnanyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kumɨjɨya pwai Kaayapaazai woꞌnɨkei sagaaꞌ Gotɨyarɨna Mubɨthɨka Yɨraꞌde Naangei mwaalɨna yaka wɨdɨna “Sɨduta maayaihɨlyɨ. Aane pɨrɨꞌ kɨrɨꞌ myawɨriwaava. ");
INSERT INTO byr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","‘Pwai aꞌmweraavɨna balana! Gave pwai balajaꞌ nemɨre yɨsavaakɨya yuyaraavɨ kayaaka myɨgalakɨpɨna!’ dawaajɨ saꞌ tewaanyasɨ. Sara myawɨrivanɨgasaihi daaka!” ");
INSERT INTO byr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sareꞌ wɨdɨna yakeꞌ sai gavei sara mujakelyɨ. Aawa. Kwarame sagaaꞌ Gotɨyarɨna Yɨraꞌde Naangei mwaainɨkerɨneꞌ Gotɨyare yagaala wɨdaꞌ “Juya yɨsavaakɨyara mabaibɨna! Jizaazai sahwaraavɨna baladelyɨ.” ");
INSERT INTO byr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Sara dake yɨsavaakɨya sahwara gavera mɨꞌ. “Pwara pɨwɨnna pɨwɨnna kɨgaakuna yosɨnɨgasara Gotɨyarera yɨmaꞌnɨpɨka!” dozɨ yuyara Gotɨyare avaalyaraavɨ maryɨꞌbwaramwaaihadeꞌna Jizaazai baladelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sarevɨdaaꞌnyɨ sagaaꞌdaasɨ Juya naangera “Sahwarɨ tamakaana!” deva dɨnyɨna “Davwina tamakaana! Pɨbwi dɨngaka? Gevwi dɨngaka?” ");
INSERT INTO byr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Miꞌna jamungajakɨna yesavɨdaaꞌnyɨ Kwaaka Juthɨya aꞌmweraayaba kuꞌmaayaba Jizaazai kaanya myamari yaꞌ. Aawa. Yaꞌmaꞌna yaka aꞌmwamaayaba pimagɨnna kaanna wɨna Anga Yɨpɨremɨnei. Saba gannyarari mwaalɨna yakelyɨ. ");
INSERT INTO byr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Juyara yawɨꞌna “Gotɨyai yɨkamaangeraavɨ tamakyaakeꞌ Ne sɨnnawɨnyaraavɨ maramaki yaka kave pariꞌmayaakeꞌnanyɨ.” Sara yawɨꞌdɨvɨꞌ “Pariꞌmaꞌmunneꞌ tɨka naana!” dadɨvɨꞌ yɨꞌbw